﻿USE sofia;
DROP TABLE IF EXISTS sofia.azb_vpl;
CREATE TABLE azb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES azb_vpl WRITE;
INSERT INTO azb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," Başlanğıcda Allah göyləri və yeri yaratdı. ");
INSERT INTO azb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Yer quruluşsuz və boş idi. Dərin sular üzərində qaranlıq var idi. Allahın Ruhu suların üzərində dolaşırdı. ");
INSERT INTO azb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Allah dedi: «Qoy işıq olsun». İşıq oldu. ");
INSERT INTO azb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allah gördü ki, işıq yaxşıdır. Sonra O, işığı qaranlıqdan ayırdı. ");
INSERT INTO azb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allah işığı «gündüz», qaranlığı isə «gecə» adlandırdı. Axşam oldu, səhər açıldı; bu, birinci gün idi. ");
INSERT INTO azb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Sonra Allah dedi: «Qoy suların arasında bir qübbə olsun və suları bir-birindən ayırsın». ");
INSERT INTO azb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Allah qübbəni düzəltdi və qübbənin altındakı suları onun üstündəki sulardan ayırdı. Belə də oldu. ");
INSERT INTO azb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allah qübbəni «göy» adlandırdı. Axşam oldu, səhər açıldı; bu, ikinci gün idi. ");
INSERT INTO azb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Sonra Allah dedi: «Qoy göyün altındakı sular bir yerə yığılsın ki, quru görünsün». Belə də oldu. ");
INSERT INTO azb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allah qurunu «yer», su yığınlarını isə «dənizlər» adlandırdı. Allah gördü ki, bu, yaxşıdır. ");
INSERT INTO azb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Sonra Allah dedi: «Qoy yer üzü bitkilər yetirsin: toxumlar bitirən ot-ələf və torpaqda hər növ bəhərli ağaclar yetişsin. Ağaclar meyvə gətirsin və toxumları meyvələrinin içində olsun». Belə də oldu. ");
INSERT INTO azb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Yer üzü bitkilər yetirdi: hər növ toxum bitirən ot-ələf və hər növ ağac yetişdi. Ağaclar meyvə gətirirdi və toxumları meyvələrinin içində idi. Allah gördü ki, bu, yaxşıdır. ");
INSERT INTO azb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Axşam oldu, səhər açıldı; bu, üçüncü gün idi. ");
INSERT INTO azb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Sonra Allah dedi: «Qoy göy qübbəsində gecəni gündüzdən ayıran çıraqlar olsun. Onlar işarələri, fəsilləri və günlərlə illəri göstərsin. ");
INSERT INTO azb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Qoy onlar göy qübbəsində çıraq olub, yer üzünə işıq saçsın». Belə də oldu. ");
INSERT INTO azb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Allah iki böyük çıraq düzəltdi: gündüzü idarə etmək üçün böyük çıraq, gecəni idarə etmək üçün kiçik çıraq. O həmçinin ulduzları düzəltdi. ");
INSERT INTO azb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Allah onları göy qübbəsinə qoydu ki, yer üzünə işıq saçsın, ");
INSERT INTO azb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","gündüzü və gecəni idarə etsin, işığı qaranlıqdan ayırsın. Allah gördü ki, bu, yaxşıdır. ");
INSERT INTO azb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Axşam oldu, səhər açıldı; bu, dördüncü gün idi. ");
INSERT INTO azb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Sonra Allah dedi: «Qoy sular çoxlu canlı məxluqlarla qaynaşsın, yer üstündəki göy qübbəsində quşlar uçsun». ");
INSERT INTO azb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Allah nəhəng su əjdahalarını və suda qaynaşan hər növ bütün sürünən canlı məxluqları, həmçinin hər növ bütün qanadlı quşları yaratdı. Allah gördü ki, bu, yaxşıdır. ");
INSERT INTO azb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Allah onlara bərəkət verərək dedi: «Törəyib çoxalın və dənizlərdəki suları doldurun, quşlar da yer üzündə çoxalsın». ");
INSERT INTO azb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Axşam oldu, səhər açıldı; bu, beşinci gün idi. ");
INSERT INTO azb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Sonra Allah dedi: «Qoy yer üzü hər növ canlı məxluqlar – hər növ ev heyvanları, sürünən canlılar və çöl heyvanları əmələ gətirsin». Belə də oldu. ");
INSERT INTO azb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Allah hər növ çöl heyvanlarını, hər növ ev heyvanlarını və yerdə sürünən bütün canlıları yaratdı. Allah gördü ki, bu, yaxşıdır. ");
INSERT INTO azb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Sonra Allah dedi: «Öz surətimizə və bənzərimizə görə insanı yaradaq. Qoy o, dənizdəki heyvanlara, göydəki quşlara, yerdəki heyvanlara, bütün yer üzünə və yerdə sürünən canlıların hamısına hökmranlıq etsin». ");
INSERT INTO azb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Allah insanı Öz surətində yaratdı, Allahın surətində yaratdı, onları kişi və qadın olaraq yaratdı. ");
INSERT INTO azb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Allah onlara xeyir-dua verərək dedi: «Törəyib çoxalın və yer üzünü bürüyüb ona sahib olun: dənizdəki heyvanlar, göydəki quşlar, yerdə sürünən bütün canlılar üzərində hökmranlıq edin». ");
INSERT INTO azb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Allah dedi: «Budur, yer üzündə toxum verən bütün ot-ələfi və meyvələrində toxumu olan bütün ağacların bəhərini sizə verirəm ki, qidalanasınız. ");
INSERT INTO azb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Yerdəki heyvanların, göydəki quşların və yerdə sürünən canlıların hamısına – nəfəsi olan bütün canlılara isə yem olmaq üçün bütün yaşıl otları verirəm». Belə də oldu. ");
INSERT INTO azb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allah gördü ki, yaratdığı hər şey çox yaxşıdır. Axşam oldu, səhər açıldı; bu, altıncı gün idi. ");
INSERT INTO azb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Göylər və yer, oradakı hər şey beləcə tamamlandı. ");
INSERT INTO azb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Allah yeddinci günə qədər gördüyü işləri qurtardı və yeddinci gün gördüyü işlərdən ayrılıb istirahət etdi. ");
INSERT INTO azb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Allah yeddinci günə bərəkət verdi və onu təqdis etdi, çünki gördüyü bütün yaratma işini qurtarıb həmin gün istirahət etdi. ");
INSERT INTO azb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Rəbb Allahın göyləri və yeri yaratmasının hekayəti belədir: Rəbb Allah göyləri və yeri yaradanda ");
INSERT INTO azb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","yer üzündə heç bir bitki yox idi, heç bir çöl otu da bitmirdi, çünki Rəbb Allah yer üzünə hələ yağış göndərməmişdi və torpağı becərən insan da yaranmamışdı. ");
INSERT INTO azb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Amma yerdən su çıxırdı və bütün torpağı sulayırdı. ");
INSERT INTO azb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Rəbb Allah yerin torpağından insanı düzəltdi və onun burnuna həyat nəfəsi üfürdü. Beləcə insan canlı varlıq oldu. ");
INSERT INTO azb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Sonra Rəbb Allah şərqdə yerləşən Edendə bir bağ saldı və düzəltdiyi insanı orada yerləşdirdi. ");
INSERT INTO azb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Rəbb Allah torpaqda gözəl görünüşlü və yemək üçün şirin meyvəli cürbəcür ağaclar yetirdi. O həmçinin bağın ortasında həyat ağacını və xeyirlə şəri bilmə ağacını bitirdi. ");
INSERT INTO azb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Bağı suvarmaq üçün Edendən bir çay çıxırdı, oradan isə dörd qola bölünürdü. ");
INSERT INTO azb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Onlardan birinin adı Pişondur. O bütün Xavila ölkəsini dolanaraq axır. Orada qızıl çıxır. ");
INSERT INTO azb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Bu ölkənin qızılı yaxşıdır. Burada həm də ətirli qatran və damarlı əqiq var. ");
INSERT INTO azb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","İkinci çayın adı Gixondur. O, Kuş ölkəsini dolanaraq axır. ");
INSERT INTO azb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Üçüncü çayın adı Dəclədir. O, Aşşur ölkəsinin şərqindən axır. Dördüncü çay Fəratdır. ");
INSERT INTO azb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Rəbb Allah insanı götürüb Eden bağına qoydu ki, oranı becərsin və saxlasın. ");
INSERT INTO azb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Rəbb Allah insana əmr edib dedi: «Bağdakı bütün ağacların bəhrəsindən istəyəndə yeyə bilərsən. ");
INSERT INTO azb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ancaq xeyirlə şəri bilmə ağacının meyvəsindən yemə, çünki ondan yeyən gün hökmən öləcəksən». ");
INSERT INTO azb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Rəbb Allah yenə dedi: «İnsanın tək olması yaxşı deyil, Mən ona münasib olan bir köməkçi yaradacağam». ");
INSERT INTO azb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Rəbb Allah bütün çöl heyvanlarını və göydəki bütün quşları torpaqdan düzəltdi. Sonra onları insanın yanına gətirdi ki, onun bunları necə adlandıracağını görsün. İnsan hər heyvana hansı adı qoydusa, o cür də adlandı. ");
INSERT INTO azb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","İnsan bütün ev heyvanlarına, göydəki quşlara və bütün çöl heyvanlarına ad verdi, amma insana münasib olan bir köməkçi tapılmadı. ");
INSERT INTO azb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","O zaman Rəbb Allah insana dərin yuxu göndərdi və o yuxuya getdi. Onda Rəbb Allah onun qabırğasının birini götürdü və yerini ətlə örtdü. ");
INSERT INTO azb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Rəbb Allah insandan götürdüyü qabırğadan qadını düzəltdi və onu insanın yanına gətirdi. ");
INSERT INTO azb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","İnsan dedi: «Bax, nəhayət, bunun Sümüyü mənim sümüyümdən, Bədəni mənim bədənimdəndir. Adına “qadın” deyiləcək, Çünki o, kişidən götürülüb». ");
INSERT INTO azb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Buna görə də kişi öz ata-anasını tərk edib arvadına qovuşacaq və onlar bir bədən olacaq. ");
INSERT INTO azb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adəm və arvadı – ikisi də çılpaq idi, ancaq bundan utanmırdılar. ");
INSERT INTO azb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Rəbb Allahın yaratdığı bütün çöl heyvanlarının ən hiyləgəri ilan idi. İlan qadına dedi: «Doğrudanmı, Allah sizə “bağda olan heç bir ağacın bəhrələrindən yeməyin” deyib?» ");
INSERT INTO azb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Qadın ilana dedi: «Bağdakı ağacların bəhrələrindən yeyə bilərik. ");
INSERT INTO azb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Amma bağın ortasındakı ağacın meyvələri barədə Allah deyib: “Ondan yeməyin və ona toxunmayın, yoxsa öləcəksiniz!”» ");
INSERT INTO azb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","İlan qadına dedi: «Yox, əsla ölməzsiniz. ");
INSERT INTO azb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Əksinə, Allah bilir ki, o meyvələrdən yediyiniz gün gözləriniz açılacaq və xeyirlə şəri bilərək Allah kimi olacaqsınız». ");
INSERT INTO azb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Qadın gördü ki, ağacın meyvəsi yemək üçün yaxşıdır, gözə xoş görünür və bu ağac insana dərrakə verməyi vəd edir. Buna görə də o həmin meyvədən dərib yedi. Sonra yanında olan ərinə də verdi, o da yedi. ");
INSERT INTO azb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","O vaxt ikisinin də gözləri açıldı və çılpaq olduqlarını bildilər. Buna görə də əncir yarpaqlarını bir-birinə hörüb özlərinə fitə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Onlar günün sərinliyində bağda gəzişən Rəbb Allahın səsini eşitdilər. Adəm və onun arvadı Rəbb Allahın hüzurundan qaçıb bağdakı ağacların arasında gizləndilər. ");
INSERT INTO azb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Rəbb Allah Adəmi səsləyib dedi: «Haradasan?» ");
INSERT INTO azb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","O cavab verdi: «Bağda səsini eşitdim və çılpaq olduğum üçün qorxdum, ona görə də gizlənmişəm». ");
INSERT INTO azb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Rəbb Allah dedi: «Kim sənə bildirdi ki, çılpaqsan? Sənə yeməyi qadağan etdiyim ağacın meyvəsindən yeməmisən ki?» ");
INSERT INTO azb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adəm dedi: «Mənimlə birgə olmaq üçün verdiyin qadın o ağacın meyvəsindən verdi, mən də yedim». ");
INSERT INTO azb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Rəbb Allah qadına dedi: «Sən niyə belə etdin?» Qadın dedi: «İlan məni yoldan çıxartdı, mən də yedim». ");
INSERT INTO azb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Rəbb Allah ilana dedi: «Sən bunu etdiyin üçün Bütün ev heyvanları və çöl heyvanları arasında Lənət qazanırsan. Qarnın üstündə sürünəcəksən, Bütün ömrün boyu torpaq yeyəcəksən. ");
INSERT INTO azb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mən səninlə qadın arasına, Sənin balanla onun övladı arasına Düşmənçilik salıram. Bu övlad sənin başından vuracaq, Sən də onu dabanından sancacaqsan». ");
INSERT INTO azb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Sonra Rəbb Allah qadına dedi: «Hamilə olanda sənə Çox əziyyət verəcəyəm, Uşaqlarını ağrı içində doğacaqsan. Ərinə meylli olacaqsan, O sənə ağalıq edəcək». ");
INSERT INTO azb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Sonra Rəbb Allah Adəmə dedi: «Arvadının sözünə qulaq asdığın üçün, Qadağan etdiyim, “meyvəsini yemə” dediyim Ağacdan yediyin üçün Sənə görə torpaq lənətlənir. Ömrün boyu zəhmətlə Torpaqdan yemək əldə edəcəksən. ");
INSERT INTO azb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","O sənə tikan və qanqal bitirəcək, Sən də çöldəki ot-ələfi yeyəcəksən. ");
INSERT INTO azb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Alın tərinlə çörək yeyəcəksən. Axırda torpağa qayıdacaqsan, Çünki oradan götürülmüsən, Ona görə ki yerin torpağısan, Torpağa da qayıdacaqsan». ");
INSERT INTO azb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adəm arvadının adını Həvva qoydu, çünki o, yer üzündə yaşayanların hamısının anası oldu. ");
INSERT INTO azb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Onda Rəbb Allah Adəmlə arvadı üçün dəridən paltar düzəltdi və onlara geyindirdi. ");
INSERT INTO azb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Sonra Rəbb Allah dedi: «Budur, insan xeyirlə şərin nə olduğunu bilərək bizlərdən biri kimi oldu. Qoy indi əlini uzadaraq həyat ağacının meyvəsindən dərib yeməsin və əbədi yaşamasın!» ");
INSERT INTO azb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Rəbb Allah insanı Eden bağından çıxartdı ki, o özünün də bir qismindən götürüldüyü torpağı becərsin. ");
INSERT INTO azb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Rəbb Allah insanı qovdu. O, Eden bağının şərqinə keruvlarını və hər tərəfə fırlanan odlu qılıncını qoydu ki, həyat ağacına gedən yolu qorusunlar. ");
INSERT INTO azb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adəm arvadı Həvva ilə yaxınlıq etdi və Həvva hamilə olub Qabili doğdu. Həvva dedi: «Rəbbin köməyi ilə bir insan qazandım». ");
INSERT INTO azb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Sonra o, Qabilin qardaşı Habili doğdu. Habil çoban oldu, Qabil isə əkinçi. ");
INSERT INTO azb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bir müddət keçəndən sonra Qabil torpağın bəhrəsindən Rəbb Allaha təqdim gətirdi. ");
INSERT INTO azb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habil də sürüsündə ilk doğulan heyvanlardan bir neçəsini və onların piyini təqdim etdi. Rəbb Habili və onun təqdimini qəbul etdi, ");
INSERT INTO azb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ancaq Qabili və onun təqdimini qəbul etmədi. Buna görə də Qabil bərk qəzəblənib qaşqabağını salladı. ");
INSERT INTO azb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Rəbb Qabilə dedi: «Niyə qəzəblənmisən? Niyə qaşqabağını sallamısan? ");
INSERT INTO azb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Əgər yaxşı iş görürsənsə, Mən qəbul etmərəmmi? Əgər yaxşı iş görmürsənsə, günah qapının ağzında durub. Onun meyli sənədir, ancaq sən ona üstün gəlməlisən». ");
INSERT INTO azb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Sonra Qabil qardaşı Habilə bir söz dedi və onlar çölə getdilər. Orada Qabil qardaşı Habilin üstünə hücum çəkib onu öldürdü. ");
INSERT INTO azb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Sonra Rəbb Qabildən soruşdu: «Qardaşın Habil haradadır?» O dedi: «Bilmirəm, məgər mən qardaşımın keşikçisiyəm?» ");
INSERT INTO azb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Rəbb dedi: «Sən nə etdin? Qardaşının qanının səsi torpaqdan Mənə fəryad edir. ");
INSERT INTO azb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","İndi sən torpaqdan lənət aldın; o torpaq ki sənin əlinlə tökülən qardaş qanını udmaq üçün ağzını açdı. ");
INSERT INTO azb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Torpağı becərdiyin zaman o daha gücünü sənə verməyəcək. Yer üzündə qaçaq və sərgərdan olacaqsan». ");
INSERT INTO azb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qabil Rəbbə dedi: «Cəzam çəkə biləcəyimdən daha artıqdır. ");
INSERT INTO azb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Bax bu gün Sən məni torpaqdan qovursan. Mən də Sənin hüzurundan gizlənib yer üzündə qaçaq və sərgərdan olacağam. Ancaq kim mənə rast gəlsə, məni öldürəcək». ");
INSERT INTO azb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Rəbb ona dedi: «Xeyr! Kim Qabili öldürsə, ondan yeddi qat intiqam alınacaq». Rəbb Qabilə bir əlamət qoydu ki, ona rast gələn kəs onu öldürməsin. ");
INSERT INTO azb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Beləcə Qabil Rəbbin hüzurunu tərk etdi və Eden bağından şərqdə – Nod torpağında yaşamağa başladı. ");
INSERT INTO azb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qabil arvadı ilə yaxınlıq etdi və arvadı hamilə olub Xanoku doğdu. O zaman o, bir şəhər tikdi, şəhərə oğlu Xanokun adını verdi. ");
INSERT INTO azb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Xanokdan İrad törədi. İraddan Mehuyael törədi. Mehuyaeldən Metuşael törədi. Metuşaeldən Lemek törədi. ");
INSERT INTO azb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek iki arvad aldı: birinin adı Ada, o birinin adı Silla idi. ");
INSERT INTO azb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Yavalı doğdu. Yaval çadırda yaşamağın və sürü saxlamağın əsasını qoydu. ");
INSERT INTO azb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Onun qardaşının adı Yuval idi. O hər cür lira və tütək çalmağın əsasını qoydu. ");
INSERT INTO azb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silla isə Tuval-Qayini doğdu. Tuval-Qayin tuncdan və dəmirdən hər cür kəsici alətlər düzəldərdi. Onun Naama adlı bacısı var idi. ");
INSERT INTO azb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Bir dəfə Lemek arvadlarına dedi: «Ey Ada və Silla, səsimi eşidin, Ey Lemekin arvadları, sözümə qulaq asın: Məni yaraladığı üçün Bir adam öldürdüm, Məni zədələdiyi üçün Bir cavan öldürdüm. ");
INSERT INTO azb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Qabil üçün yeddi qat qisas alınacaqsa, Lemek üçün yetmiş yeddi qat alınacaq». ");
INSERT INTO azb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adəm yenə arvadı ilə yaxınlıq etdi və Həvva bir oğlan doğub adını Şet qoyaraq dedi: «Qabilin öldürdüyü Habilin yerinə Allah mənə başqa bir oğul bəxş etdi». ");
INSERT INTO azb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Şetin də bir oğlu oldu və adını Enoş qoydu. O zaman insanlar Rəbbin adını çağırmağa başladı. ");
INSERT INTO azb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adəmin nəsil tarixçəsi belədir. Allah insanı yaradanda onu Öz bənzərinə görə yaratdı. ");
INSERT INTO azb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Allah onları kişi və qadın olaraq yaratdı, onlara xeyir-dua verdi və yaratdığı gün onları «insan» adlandırdı. ");
INSERT INTO azb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adəmin yüz otuz yaşı olanda özünə bənzər, öz surətində bir oğlu oldu və adını Şet qoydu. ");
INSERT INTO azb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Şet doğulandan sonra Adəm səkkiz yüz il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adəm doqquz yüz otuz il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Şet yüz beş yaşında olanda oğlu Enoş doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enoş doğulandan sonra Şet səkkiz yüz yeddi il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Şet doqquz yüz on iki il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoş doxsan yaşında olanda oğlu Qenan doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Qenan doğulandan sonra Enoş səkkiz yüz on beş il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoş doqquz yüz beş il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qenan yetmiş yaşında olanda oğlu Mahalalel doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel doğulandan sonra Qenan səkkiz yüz qırx il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Qenan doqquz yüz on il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel altmış beş yaşında olanda oğlu Yered doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yered doğulandan sonra Mahalalel səkkiz yüz otuz il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel səkkiz yüz doxsan beş il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yered yüz altmış iki yaşında olanda oğlu Xanok doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Xanok doğulandan sonra Yered səkkiz yüz il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yered doqquz yüz altmış iki il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Xanok altmış beş yaşında olanda oğlu Metuşelah doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metuşelah doğulandan sonra Xanok üç yüz il Allahla bir yol getdi. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Xanok üç yüz altmış beş il yaşadı. ");
INSERT INTO azb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","O, Allahla bir yol getdi. Sonra qeyb oldu, çünki Allah onu Öz yanına götürdü. ");
INSERT INTO azb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuşelah yüz səksən yeddi yaşında olanda oğlu Lemek doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemek doğulandan sonra Metuşelah yeddi yüz səksən iki il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metuşelah doqquz yüz altmış doqquz il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemek yüz səksən iki yaşında olanda bir oğlu doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","O dedi: «Bu oğul Rəbbin lənətlədiyi torpağı becərəndə çəkdiyimiz əziyyətlərdə, əlimizin zəhmətində bizə təsəlli verəcək». Buna görə də onun adını Nuh qoydu. ");
INSERT INTO azb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuh doğulandan sonra Lemek beş yüz doxsan beş il yaşadı. Onun başqa oğulları və qızları oldu. ");
INSERT INTO azb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemek yeddi yüz yetmiş yeddi il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuh beş yüz yaşında olanda Sam, Ham və Yafəs adında oğulları oldu. ");
INSERT INTO azb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","İnsanlar yer üzündə çoxalmağa başladı və onların qızları doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","O zaman Allah oğulları gördülər ki, insan qızları çox gözəldir və bəyəndikləri hər qızı özlərinə arvad etdilər. ");
INSERT INTO azb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Rəbb dedi: «Mənim Ruhum insanda əbədi qalmayacaq, çünki onlar ancaq bədəndir. Onların ömrü yüz iyirmi il olacaq». ");
INSERT INTO azb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Həmin dövrdə və Allah oğulları insan qızlarını arvad alıb övladları doğulan dövrdə də yer üzündə böyük adamlar yaşayırdı. Bunlar qədim dövrün qəhrəman və adlı-sanlı adamları idi. ");
INSERT INTO azb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Rəbb gördü ki, yer üzündəki insanların şər əməlləri çoxdur və hər zaman onların ürəyindəki fikirlər və niyyətlər pisliyə doğru yönəlir. ");
INSERT INTO azb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","O, yer üzündə insanları yaratdığına peşman oldu və ürəyində kədərləndi. ");
INSERT INTO azb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Rəbb dedi: «Yaratdığım insanları yer üzündən siləcəyəm, bunu insanlarla birgə heyvanların, sürünənlərin və quşların da başına gətirəcəyəm, çünki onları yaratmağıma peşman olmuşam». ");
INSERT INTO azb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ancaq Nuh Rəbbin gözündə lütf tapdı. ");
INSERT INTO azb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuhun tarixçəsi belədir: Nuh saleh və öz nəsli arasında qüsursuz bir adam idi. O, Allahla bir yol gedirdi. ");
INSERT INTO azb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhun üç oğlu oldu: Sam, Ham və Yafəs. ");
INSERT INTO azb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ancaq Allahın önündə yer üzündəki insanlar pozğunlaşmışdı və dünya zorakılıqla dolmuşdu. ");
INSERT INTO azb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allah yer üzündəki insanların daha da pozğunlaşdığını gördü, çünki dünyadakı bütün bəşər yolunu azmışdı. ");
INSERT INTO azb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Allah Nuha dedi: «Önümdə olan bütün bəşərin sonu çatıb, çünki yer üzü onların zorakılığı ilə dolub. Buna görə də Mən onları yer üzü ilə birgə məhv edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Özünə qofer ağacından bir gəmi düzəlt, onun içində otaqlar düzəlt, üstünə içəridən və bayırdan qatran vur. ");
INSERT INTO azb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Gəmini belə düzəlt: onun uzunluğu üç yüz qulac, eni əlli qulac, hündürlüyü isə otuz qulac olsun. ");
INSERT INTO azb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gəminin üstündən bir qulac aşağı pəncərə açarsan və qapısını yan tərəfdən qoyarsan. Gəminin üç mərtəbəsi olsun: biri altda, biri ortada, biri də üstdə. ");
INSERT INTO azb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Bax Mən yer üzünü suya qərq edəcəyəm ki, göylər altında həyat nəfəsi olan bütün canlılar məhv olsun və yer üzündə olanların hamısı öləcək. ");
INSERT INTO azb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ancaq əhdimi səninlə bağlayıram. Sən oğulların, arvadın və gəlinlərinlə birgə gəmiyə minərsən. ");
INSERT INTO azb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Bütün heyvanlardan, canlı məxluqlardan bir cütünü – erkək və dişisini gəmiyə götürərsən ki, səninlə birgə sağ qalsın. ");
INSERT INTO azb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Növlərinə görə quşların, heyvanların və yerdə sürünənlərin hər birindən bir cütü sənin yanına gələcək ki, sağ qalsın. ");
INSERT INTO azb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Həmçinin özünlə birlikdə hər cür azuqə götürüb yanına yığ ki, sənin və onların yeməyi olsun». ");
INSERT INTO azb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuh hər şeyi etdi: Allah ona necə əmr etmişdisə, o da hər şeyi eləcə yerinə yetirdi. ");
INSERT INTO azb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Rəbb Nuha dedi: «Sən bütün ailənlə birgə gəmiyə gir, çünki bu bəşər nəsli içində yalnız səni önümdə saleh gördüm. ");
INSERT INTO azb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Hər pak heyvanın erkək və dişisindən yeddi cüt, hər murdar heyvanın erkək və dişisindən bir cüt götür, ");
INSERT INTO azb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","həmçinin göydəki hər quşun erkək və dişisindən yeddi cüt götür; qoy bütün yer üzündə onların nəsli kəsilməsin. ");
INSERT INTO azb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Çünki yeddi gün sonra yer üzünə qırx gün-qırx gecə yağış yağdıracağam və yaratdığım bütün canlıları yer üzündə məhv edəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Rəbb Nuha necə əmr etmişdisə, o da hər şeyi eləcə yerinə yetirdi. ");
INSERT INTO azb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yer üzündə daşqın olanda Nuhun altı yüz yaşı var idi. ");
INSERT INTO azb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuh, onun arvadı, oğulları və gəlinləri daşqından qurtarmaq üçün birlikdə gəmiyə mindilər. ");
INSERT INTO azb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Allahın Nuha əmr etdiyi kimi pak və murdar heyvanların, quşların, bütün yerdə sürünənlərin ");
INSERT INTO azb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","erkək və dişisi cüt-cüt Nuhun yanına gəlib gəmiyə mindi. ");
INSERT INTO azb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Yeddi gün sonra yer üzündə daşqın oldu. ");
INSERT INTO azb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Həmin gün – Nuhun ömrünün altı yüzüncü ilində, ikinci ayın on yeddinci günü dərinlikdə olan bütün gur su qaynaqları püskürdü və göylərin pəncərələri açıldı. ");
INSERT INTO azb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yer üzünə qırx gün-qırx gecə yağış yağdı. ");
INSERT INTO azb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Elə həmin gün Nuh, onun arvadı, oğulları Sam, Ham, Yafəs və üç gəlini gəmiyə mindilər. ");
INSERT INTO azb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Onlarla birgə hər növ çöl heyvanı, hər növ ev heyvanı, hər növ yerdə sürünən, hər növ göydə uçan canlı və hər cür quş gəmiyə girdi: ");
INSERT INTO azb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","həyat nəfəsi olan bütün canlılardan cüt-cüt Nuhun yanına gəlib gəmiyə mindi. ");
INSERT INTO azb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Allahın Nuha əmr etdiyi kimi bütün canlılardan erkək və dişi heyvanlar gəmiyə girdilər. Onların dalınca Rəbb gəminin qapısını örtdü. ");
INSERT INTO azb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Yer üzündə qırx gün daşqın oldu və su çoxalıb gəmini yerdən yuxarı qaldırdı. ");
INSERT INTO azb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Su çox yuxarı qalxıb yer üzünü aldı və gəmi suyun üzündə üzməyə başladı. ");
INSERT INTO azb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Su yer üzünü elə tutdu ki, göylər altında olan bütün uca dağlar suya qərq oldu. ");
INSERT INTO azb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Su dağların zirvəsindən on beş qulac qalxdı və onları örtdü. ");
INSERT INTO azb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yer üzündə hərəkət edən canlıların hamısı – quşlar, ev heyvanları, çöl heyvanları, yerdə sürünənlər və bütün insanlar məhv oldu. ");
INSERT INTO azb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Quruda yaşayan, burnunda həyat nəfəsi olan canlı varlıqların hamısı öldü. ");
INSERT INTO azb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Rəbb yer üzündə olan bütün canlıları məhv etdi: insanlardan tutmuş heyvanlara, sürünənlərə və göydəki quşlara qədər hər şey yer üzündə məhv oldu. Yalnız Nuh və onunla birgə gəmidə olanlar sağ qaldı. ");
INSERT INTO azb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Yüz əlli gün ərzində su yer üzündə çoxaldı. ");
INSERT INTO azb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Allah Nuhu və onunla birgə gəmidə olan bütün çöl heyvanlarını və ev heyvanlarını yada saldı. Allah yer üzünə külək göndərdi və su azalmağa başladı. ");
INSERT INTO azb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Dərinlikdə olan su qaynaqları və göylərin pəncərələri bağlandı, yağış dayandı. ");
INSERT INTO azb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Su yer üzündən tədricən çəkildi, yüz əlli gün keçdikdən sonra su azaldı. ");
INSERT INTO azb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yeddinci ayın on yeddinci günü gəmi Ararat dağlarında dayandı. ");
INSERT INTO azb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Onuncu aya qədər su yavaş-yavaş çəkildi, onuncu ayın birinci günü dağların zirvələri göründü. ");
INSERT INTO azb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Qırx gün sonra Nuh düzəltdiyi gəminin pəncərəsini açıb ");
INSERT INTO azb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bir qarğa buraxdı; qarğa uçub getdi və yer üzündə su quruyana qədər hər tərəfi dolaşdı. ");
INSERT INTO azb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nuh bu dəfə bir göyərçin buraxdı ki, suyun yer üzündən çəkilib-çəkilmədiyini bilsin. ");
INSERT INTO azb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Amma göyərçin qonmaq üçün rahat bir yer tapmadığına görə onun yanına – gəmiyə qayıtdı, çünki hələ bütün yer üzündə su var idi. Nuh əlini uzadıb göyərçini tutdu və gəmiyə – öz yanına apardı. ");
INSERT INTO azb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","O daha yeddi gün gözlədi və göyərçini yenə gəmidən buraxdı. ");
INSERT INTO azb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Axşamüstü göyərçin onun yanına qayıtdı. Göyərçinin ağzında təzə zeytun yarpağı var idi. Nuh suyun yer üzündən çəkildiyini bildi. ");
INSERT INTO azb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","O daha yeddi gün gözlədi və göyərçini yenə buraxdı, artıq göyərçin onun yanına qayıtmadı. ");
INSERT INTO azb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhun ömrünün altı yüz birinci ilində, birinci ayın birinci günü yer üzündə su qurudu. Nuh gəminin qapağını qaldırdı və torpağın üzərindəki suyun quruduğunu gördü. ");
INSERT INTO azb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","İkinci ayın iyirmi yeddinci günü yer üzündəki su tamamilə qurudu. ");
INSERT INTO azb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Allah Nuha dedi: ");
INSERT INTO azb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Sən öz arvadın, oğulların və gəlinlərinlə birgə gəmidən çıx. ");
INSERT INTO azb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Səninlə birgə olan bütün canlıları – quşları, heyvanları və yerdə sürünənləri bayıra çıxart. Qoy yer üzünə yayılsınlar və yer üzündə törəyib çoxalsınlar». ");
INSERT INTO azb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nuh öz arvadı, oğulları və gəlinləri ilə birgə gəmidən çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bütün heyvanlar, sürünənlər, quşlar və yerdə sürünən bütün canlılar dəstə-dəstə gəmini tərk etdilər. ");
INSERT INTO azb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuh Rəbbə bir qurbangah düzəltdi. O hər cür pak heyvandan və pak quşdan götürüb orada yandırma qurbanı təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Bundan Rəbbə xoş ətir qalxdı və Rəbb ürəyində dedi: «Cavanlığından bəri insan ürəyinin fikirlərinin həmişə pis olmasına baxmayaraq, insanlara görə bir daha yer üzünü lənətləməyəcəyəm. İndi elədiyim kimi bütün canlıları bir daha məhv etməyəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Dünya durduqca Əkin-biçin, isti-soyuq, Yay-qış və gecə-gündüz Sona yetməyəcək». ");
INSERT INTO azb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Allah Nuha və onun oğullarına xeyir-dua verib dedi: «Törəyib çoxalın və yer üzünü bürüyün. ");
INSERT INTO azb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Qurudakı bütün heyvanlar, göydəki bütün quşlar, yerdə sürünən bütün canlılar və dənizdə olan bütün balıqlar sizdən qorxub dəhşətə gələcək. Onlar sizin ixtiyarınıza verilib. ");
INSERT INTO azb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bütün canlılar da sizə qida olsun, onların hamısını bütün göy otlar kimi sizə verirəm. ");
INSERT INTO azb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ancaq əti onun canı olan qanla birgə yeməyin. ");
INSERT INTO azb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sizin isə qanınız tökülərsə, əvəzini hökmən alacağam. Hər heyvandan hesabınızı alacağam. Həmçinin insandan – qardaşının canını alan hər kəsdən əvəzini alacağam. ");
INSERT INTO azb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kim insan qanı töksə, Onun da qanı İnsan əli ilə töküləcək. Çünki Allah insanı Öz surətinə görə yaradıb. ");
INSERT INTO azb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Siz törəyib çoxalın, Yer üzünə yayılın, Orada çoxalın». ");
INSERT INTO azb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Allah Nuha və yanında olan oğullarına dedi: ");
INSERT INTO azb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Mən sizinlə, sizdən sonrakı nəslinizlə Öz əhdimi bağlayıram, ");
INSERT INTO azb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","gəmidən çıxan yer üzündəki bütün canlı məxluqlarla – quşlar, ev heyvanları və bütün çöl heyvanları ilə əhdimi bağlayıram. ");
INSERT INTO azb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Sizinlə Öz əhdimi qoyuram ki, bütün canlılar bir daha daşqınla məhv olmayacaq və heç vaxt yer üzünü viran edən daşqın baş verməyəcək». ");
INSERT INTO azb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Allah yenə dedi: «Mənim sizinlə və sizinlə olan bütün canlılarla nəsillər boyu əbədi olaraq bağladığım əhdin əlaməti budur: ");
INSERT INTO azb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","buludda Öz göy qurşağımı qoyuram ki, Mənimlə yer üzü arasında olan əhdin əlaməti olsun. ");
INSERT INTO azb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mən yer üzünə bulud gətirdiyim zaman buludda göy qurşağı görünəcək. ");
INSERT INTO azb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Onda Mən sizinlə və bütün canlı məxluqlarla bağladığım əhdi yada salacağam. Sular bir daha daşqına çevrilib bütün canlıları məhv etməyəcək. ");
INSERT INTO azb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Buludda göy qurşağı olacaq. Mən Allah onu görüb yer üzündə yaşayan bütün canlı məxluqlarla bağladığım əbədi əhdi yada salacağam». ");
INSERT INTO azb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Allah yenə Nuha dedi: «Mənim yer üzündə yaşayan bütün canlılarla bağladığım əhdin əlaməti budur». ");
INSERT INTO azb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Gəmidən çıxan Nuhun oğulları bunlardır: Sam, Ham və Yafəs. Hamdan Kənan törədi. ");
INSERT INTO azb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuhun üç oğlu bunlardır və yer üzündə yayılan bütün insanlar onlardan törədi. ");
INSERT INTO azb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh torpağı becərməyə başladı və bir üzüm bağı saldı. ");
INSERT INTO azb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","O, şərab içib sərxoş oldu və öz çadırında çılpaq uzandı. ");
INSERT INTO azb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kənanın atası Ham atasının çılpaq olduğunu gördü və bunu bayırda iki qardaşına söylədi. ");
INSERT INTO azb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sam və Yafəs bir paltar götürüb öz çiyinlərinə saldılar və dal-dalı içəri girib, atalarının çılpaq bədənini örtdülər. Onlar üzlərini əks tərəfə çevirmişdilər ki, atalarının çılpaqlığını görməsinlər. ");
INSERT INTO azb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuh öz sərxoşluğundan ayıldı və kiçik oğlunun əməlini bilib dedi: ");
INSERT INTO azb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","«Kənana lənət olsun, Öz qardaşlarının qullarına qul olsun». ");
INSERT INTO azb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yenə dedi: «Samın Allahı Rəbbə alqış olsun, Kənan ona qul olsun. ");
INSERT INTO azb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Allah Yafəsə genişlik versin, Samın çadırlarında yaşasın. Kənan ona qul olsun». ");
INSERT INTO azb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nuh daşqından sonra üç yüz əlli il yaşadı. ");
INSERT INTO azb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","O, doqquz yüz əlli il ömür sürüb öldü. ");
INSERT INTO azb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuhun oğulları Sam, Ham və Yafəsin nəsil tarixçəsi belədir. Daşqından sonra onların oğulları oldu. ");
INSERT INTO azb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafəsin oğulları: Qomer, Maqoq, Maday, Yavan, Tuval, Meşek və Tiras. ");
INSERT INTO azb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Qomerin oğulları: Aşkenaz, Rifat və Toqarma. ");
INSERT INTO azb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavanın oğulları: Elişa, Tarşiş, Kittim və Dodanim. ");
INSERT INTO azb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Onların nəsilləri adalara, öz torpaqlarına yayıldı. Öz millətlərinin arasında dillərə və qəbilələrə ayrıldı. ");
INSERT INTO azb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamın oğulları: Kuş, Misrayim, Put və Kənan. ");
INSERT INTO azb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuşun oğulları: Seva, Xavila, Savta, Raama və Savteka. Raamanın oğulları: Səba və Dedan. ");
INSERT INTO azb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuşun Nəmrud adlı bir oğlu da oldu. O, yer üzündə ilk qüdrətli adam oldu. ");
INSERT INTO azb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nəmrud Rəbbin önündə mahir bir ovçu idi, buna görə də xalqın arasında «Rəbbin önündə Nəmrud kimi mahir ovçu» sözü deyilir. ");
INSERT INTO azb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Əvvəlcə onun padşahlığına Şinar ölkəsində olan Babil, Erek, Akkad və Kalne daxil idi. ");
INSERT INTO azb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","O bu torpaqdan Aşşur torpağına köçüb, Ninevanı, Rexovot-İri, Kelahı, ");
INSERT INTO azb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Nineva ilə böyük şəhər olan Kelahın arasındakı Reseni tikdi. ");
INSERT INTO azb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayimin nəsilləri bunlardır: Ludlular, Anamlılar, Lehavlılar, Naftuhlular, ");
INSERT INTO azb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patroslular, Filiştlilərin əcdadı olan Kasluhlular, həmçinin Kaftorlular. ");
INSERT INTO azb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kənanın nəsilləri bunlardır: ilk oğlu Sidon, Xet, ");
INSERT INTO azb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","həmçinin Yevuslular, Emorlular, Qirqaşlılar, ");
INSERT INTO azb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Xivlilər, Arqlılar, Sinlilər, ");
INSERT INTO azb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Ervadlılar, Semarlılar və Xamatlılar. Sonralar Kənan qəbilələri ətraf yerlərə yayıldı. ");
INSERT INTO azb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kənanlıların ərazisi Sidondan Gerara tərəf Qəzzəyə qədər, Sodoma, Homorraya, Admaya, Sevoyimə tərəf Leşaya qədər uzanırdı. ");
INSERT INTO azb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Bunlar öz ölkələrində və millətlərinin arasında qəbilələrinə və dillərinə görə ayrılan Ham oğulları idi. ");
INSERT INTO azb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Everin bütün oğullarının əcdadı və böyük olan Yafəsin qardaşı Samın da oğulları oldu. ");
INSERT INTO azb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Samın oğulları: Elam, Aşşur, Arpakşad, Lud və Aram. ");
INSERT INTO azb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramın oğulları: Us, Xul, Geter və Maş. ");
INSERT INTO azb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakşaddan Şelah törədi, Şelahdan Ever törədi. ");
INSERT INTO azb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Everin iki oğlu oldu: birinin adı Peleq idi, çünki onun dövründə yer üzü bölündü. Qardaşının adı Yoqtan idi. ");
INSERT INTO azb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqtandan Almodad, Şelef, Xasarmavet, Yerah, ");
INSERT INTO azb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diqla, ");
INSERT INTO azb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oval, Avimael, Səba, ");
INSERT INTO azb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Xavila və Yovav törədi; bunların hamısı Yoqtanın oğulları idi. ");
INSERT INTO azb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Onlar şərqdə – Meşadan Sefara tərəf yerləşən dağlıq bölgədə məskən salmışdı. ");
INSERT INTO azb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Bunlar öz ölkələrində və millətləri arasında qəbilələrinə və dillərinə görə ayrılan Sam oğulları idi. ");
INSERT INTO azb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Öz millətləri arasında nəsillərinə görə Nuh oğullarının qəbilələri bunlardır. Daşqından sonra onların nəsillərindən yer üzünə millətlər yayıldı. ");
INSERT INTO azb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bütün dünyada bir dil və bir danışıq var idi. ");
INSERT INTO azb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","İnsanlar şərqdən köçüb gəldikləri zaman Şinar torpağında bir düzənliyə rast gəldilər və orada məskən saldılar. ");
INSERT INTO azb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sonra bir-birlərinə dedilər: «Gəlin kərpic düzəldək və onu yaxşı bişirək». Onlar daş əvəzinə kərpic və palçıq əvəzinə qatran götürdülər. ");
INSERT INTO azb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Yenə dedilər: «Gəlin özümüzə bir şəhər və başı göylərə çatan bir qüllə tikib ad çıxaraq, daha bütün yer üzünə yayılmayaq». ");
INSERT INTO azb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Rəbb bəşər övladlarının tikdiyi şəhəri və qülləni görmək üçün aşağı endi. ");
INSERT INTO azb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Rəbb dedi: «Budur, onların hamısı bir xalqdır və bir dilləri var. Buna görə də bu işi görməyə başlamışlar və indi etmək istədikləri işə heç kəs mane olmayacaq. ");
INSERT INTO azb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Gəlin aşağı enib orada onların dilini qarışdıraq ki, bir-birlərinin dilini başa düşməsinlər». ");
INSERT INTO azb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Rəbb onları oradan bütün yer üzünə yaydı. Onlar şəhəri tikməyi dayandırdı. ");
INSERT INTO azb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Buna görə də o yerin adına Babil dedilər, çünki orada Rəbb bütün dünyadakı adamların dilini qarışdırdı və onları bütün yer üzünə yaydı. ");
INSERT INTO azb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Samın nəsil tarixçəsi belədir: daşqından iki il sonra Sam yüz yaşında olanda oğlu Arpakşad doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arpakşad doğulandan sonra Sam beş yüz il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpakşad otuz beş yaşında olanda oğlu Şelah doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Şelah doğulandan sonra Arpakşad dörd yüz üç il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Şelah otuz yaşında olanda oğlu Ever doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ever doğulandan sonra Şelah dörd yüz üç il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ever otuz dörd yaşında olanda oğlu Peleq doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleq doğulandan sonra Ever dörd yüz otuz il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleq otuz yaşında olanda oğlu Reu doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu doğulandan sonra Peleq iki yüz doqquz il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu otuz iki yaşında olanda oğlu Seruq doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruq doğulandan sonra Reu iki yüz yeddi il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruq otuz yaşında olanda oğlu Naxor doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naxor doğulandan sonra Seruq iki yüz il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naxor iyirmi doqquz yaşında olanda oğlu Terah doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terah doğulandan sonra Naxor yüz on doqquz il yaşadı. Onun çoxlu oğlu və qızı oldu. ");
INSERT INTO azb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah yetmiş yaşında olanda oğulları İbram, Naxor və Haran doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terahın nəsil tarixçəsi belədir: Terahdan İbram, Naxor və Haran törədi. Harandan Lut törədi. ");
INSERT INTO azb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran atası Terahın sağlığında doğulduğu ölkədə – Xaldeylilərin Ur şəhərində öldü. ");
INSERT INTO azb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","İbram və Naxor özlərinə arvad aldılar. İbramın arvadının adı Saray, Naxorun arvadının adı isə Milka idi. Milka və İska Haranın qızları idi. ");
INSERT INTO azb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray sonsuz idi, onun uşağı olmurdu. ");
INSERT INTO azb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah oğlu İbramı, Haranın oğlu olan nəvəsi Lutu, oğlu İbramın arvadı olan gəlini Sarayı özü ilə götürdü və Kənan torpağına getmək üçün Xaldeylilərin Ur şəhərindən çıxdı. Onlar Xarana gəlib, orada məskən saldılar. ");
INSERT INTO azb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah iki yüz beş il ömür sürüb Xaranda öldü. ");
INSERT INTO azb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Rəbb İbrama dedi: «Öz torpağından, qohumlarının arasından, ata evindən çıx, sənə göstərəcəyim torpağa get. ");
INSERT INTO azb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Səndən böyük bir millət törədəcəyəm, sənə xeyir-dua verəcəyəm, adını ucaldacağam və bərəkət qaynağı olacaqsan. ");
INSERT INTO azb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Sənə xeyir-dua verənlərə xeyir-dua verəcəyəm, sənə lənət edənləri lənətləyəcəyəm. Yer üzünün bütün tayfaları sənin vasitənlə xeyir-dua alacaq». ");
INSERT INTO azb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","İbram Rəbbin ona söylədiyi kimi oradan çıxdı. Lut da onunla birgə getdi. Xarandan çıxdığı vaxt İbram yetmiş beş yaşında idi. ");
INSERT INTO azb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","İbram arvadı Sarayı, qardaşı oğlu Lutu, Xaranda əldə etdikləri bütün əmlakı və özünün bütün nökərlərini götürüb Kənan torpağına tərəf yola düşdü. Onlar Kənan torpağına gəldilər. ");
INSERT INTO azb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","İbram oranı dolaşıb, Şekem deyilən yerdəki More palıdının yanına çatdı. O vaxt bu torpaqda Kənanlılar yaşayırdı. ");
INSERT INTO azb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Rəbb İbrama görünüb dedi: «Bu torpağı sənin nəslindən olana verəcəyəm». İbram ona görünən Rəbbə orada bir qurbangah düzəltdi. ");
INSERT INTO azb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Buradan Bet-Elin şərqində yerləşən dağlıq yerə tərəf yola düşdü və burada çadır qurdu. Çadırdan qərbdə Bet-El, şərqdə isə Ay şəhəri idi. İbram orada da Rəbbə bir qurbangah qurdu və Rəbbin adını çağırdı. ");
INSERT INTO azb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","İbram tədricən cənuba doğru hərəkət edirdi. ");
INSERT INTO azb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bu torpaqda aclıq başlandı. İbram müvəqqəti qalmaq üçün Misirə getdi, çünki ölkədə böyük aclıq hökm sürürdü. ");
INSERT INTO azb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","O, Misirə yaxınlaşanda arvadı Saraya dedi: «Bax mən bilirəm ki, sən gözəl qadınsan. ");
INSERT INTO azb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Misirlilər səni görüb deyəcəklər: “Bu onun arvadıdır”. Onda məni öldürəcəklər, səni isə sağ buraxacaqlar. ");
INSERT INTO azb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Bəlkə sən deyəsən ki, mənim bacımsan, onda sənin xatirinə mənimlə yaxşı rəftar edərlər və mən də sağ qalaram». ");
INSERT INTO azb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","İbram Misirə gəlib çatanda Misirlilər onun arvadının çox gözəl olduğunu gördülər. ");
INSERT INTO azb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Fironun əyanları da qadını gördülər və onu firona təriflədilər. Qadın fironun sarayına aparıldı. ");
INSERT INTO azb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Onun xatirinə firon İbramla da yaxşı rəftar etdi: İbram qoyun-keçi, mal-qara, erkək və dişi eşşəklər, qullar, qarabaşlar və dəvələr sahibi oldu. ");
INSERT INTO azb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ancaq Rəbb İbramın arvadı Saraydan ötrü fironun və onun ev adamlarının başına böyük fəlakətlər gətirdi. ");
INSERT INTO azb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Firon İbramı çağırıb dedi: «Bu nə işdir, mənim başıma gətirdin? Bu qadının sənin arvadın olduğunu niyə mənə bildirmədin? ");
INSERT INTO azb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nə üçün “bu mənim bacımdır” dedin ki, mən də onu özümə arvad olmaq üçün aldım? İndi isə arvadını da götür get». ");
INSERT INTO azb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Firon adamlara onlar barədə əmr verdi və İbramla arvadını sahib olduğu bütün şeylərlə birgə yola saldılar. ");
INSERT INTO azb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","İbram arvadı və sahib olduğu bütün şeylərlə birgə Misirdən çıxıb Negev torpağına getdi. Lut da onunla idi. ");
INSERT INTO azb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","İbram çox varlandı: onun çoxlu sürüsü və qızıl-gümüşü oldu. ");
INSERT INTO azb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Negevdən çıxıb bir yerdən o biri yerə keçərək Bet-Elə qədər – Bet-Ellə Ay şəhəri arasında əvvəllər çadır qurduğu yerə getdi. ");
INSERT INTO azb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","İbram ilk vaxt düzəltdiyi qurbangahın yanına çatdı və orada Rəbbin adını çağırdı. ");
INSERT INTO azb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","İbramla birlikdə olan Lutun da qoyun-keçisi, mal-qarası və çadırları var idi. ");
INSERT INTO azb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Birlikdə yaşamaq üçün yer onlara darlıq edirdi, çünki onların malı çox idi və birgə qala bilməzdilər. ");
INSERT INTO azb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","İbramın sürülərinin çobanları ilə Lutun sürülərinin çobanları arasında mübahisə düşdü. O vaxt bu torpaqda Kənanlılar və Perizlilər yaşayırdı. ");
INSERT INTO azb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","İbram Luta dedi: «Qoy mənimlə sənin və çobanlarımla çobanların arasında mübahisə olmasın, çünki biz qohumuq. ");
INSERT INTO azb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bütün torpaqlar gözünün önündə deyilmi? Gəl ayrılaq. Əgər sən sola getsən, mən sağa gedəcəyəm, sən sağa getsən, mən sola gedəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lut başını qaldırıb İordan çayının kənarındakı düzənliyi gördü. O vaxt bu yer Misir torpağı kimi bütünlüklə Soara qədər suvarılırdı və Rəbbin bağı kimi idi. Rəbb hələ Sodom və Homorranı məhv etməmişdi. ");
INSERT INTO azb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lut özünə İordan çayının kənarındakı düzənliyi seçdi. O, şərqə tərəf hərəkət etdi. Beləcə onlar bir-birindən ayrıldı. ");
INSERT INTO azb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","İbram Kənan torpağında qaldı, Lut isə düzənlikdəki şəhərlərdə yaşamağa başladı və Sodoma qədər öz çadırlarını qurdu. ");
INSERT INTO azb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomun əhalisi çox pozğun idi və Rəbbə qarşı çoxlu günah edirdi. ");
INSERT INTO azb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut İbramdan ayrıldıqdan sonra Rəbb İbrama dedi: «Başını qaldırıb dayandığın yerdən şimala, cənuba, şərqə və qərbə tərəf bax. ");
INSERT INTO azb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Gördüyün bütün torpaqları əbədi olaraq sənə və nəslinə verəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nəslini yerin tozu qədər çoxaldacağam. Əgər bir nəfər yerin tozunu saya bilərsə, sənin nəslini də saya bilər. ");
INSERT INTO azb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Qalx bu torpağı uzununa və eninə dolaş, çünki Mən onu sənə verirəm». ");
INSERT INTO azb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","İbram çadırını götürdü və gəlib Xevronda olan Mamre palıdının yanında məskən saldı. O burada Rəbbə bir qurbangah düzəltdi. ");
INSERT INTO azb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bu zaman Şinar padşahı Amrafel, Ellasar padşahı Aryok, Elam padşahı Kedorlaomer və Qoyim padşahı Tidal ");
INSERT INTO azb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sodom padşahı Beraya, Homorra padşahı Birşaya, Adma padşahı Şinava, Sevoyim padşahı Şemeverə, Bela, yəni Soar padşahına qarşı müharibəyə başladı. ");
INSERT INTO azb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bu son beş padşah indi Duz dənizi adlanan Siddim vadisində öz qoşunlarını birləşdirdi. ");
INSERT INTO azb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Onlar on iki il Kedorlaomerin əsarəti altında qalmış, on üçüncü il isə üsyan etmişdilər. ");
INSERT INTO azb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","On dördüncü il Kedorlaomer və onunla birgə olan padşahlar gəlib Aşterot-Qarnayimdə Rafalıları, Hamda Zuzluları, Şave-Qiryatayimdə Emliləri, ");
INSERT INTO azb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","çöl kənarındakı El-Parana qədər uzanan Seir dağlarında Xorluları qırdılar. ");
INSERT INTO azb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sonra geri qayıdıb En-Mişpata, yəni Qadeşə getdilər. Bütün Amaleq torpağının əhalisini və Xaseson-Tamarda yaşayan Emorluları qırdılar. ");
INSERT INTO azb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sodom padşahı, Homorra padşahı, Adma padşahı, Sevoyim padşahı, Bela, yəni Soar padşahı Siddim vadisinə gəlib, ");
INSERT INTO azb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elam padşahı Kedorlaomerlə, Qoyim padşahı Tidalla, Şinar padşahı Amrafellə, Ellasar padşahı Aryokla döyüşə girdilər: dörd padşah beş padşaha qarşı idi. ");
INSERT INTO azb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddim vadisində qatranla dolu çoxlu çuxur var idi. Sodom və Homorra padşahları döyüşdən qaçanda oraya yıxıldılar, sağ qalanlar isə dağlara qaçdılar. ");
INSERT INTO azb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Qaliblər Sodom və Homorranın bütün əmlakını və azuqəsini götürüb getdilər. ");
INSERT INTO azb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","İbramın qardaşı oğlu Lutu və onun əmlakını özləri ilə apardılar, çünki o da Sodomda yaşayırdı. ");
INSERT INTO azb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Döyüşdən sağ qurtaran bir nəfər gəlib İbrani İbrama bunu xəbər verdi. O, Eşkolun və Anerin qardaşı Emorlu Mamrenin palıdının yanında yaşayırdı. Onlar İbramın müttəfiqləri idi. ");
INSERT INTO azb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","İbram qohumu Lutun əsir alındığını eşidəndə evində doğulmuş, döyüş təlimi keçmiş üç yüz on səkkiz nökərini götürüb düşmənləri Dana qədər təqib etdi. ");
INSERT INTO azb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Özü və nökərləri gecə vaxtı dəstələrə bölünüb, onları qırdılar və sağ qalanları Dəməşqin şimal tərəfində olan Xovaya qədər təqib etdilər. ");
INSERT INTO azb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","İbram qarət olunmuş bütün əmlakı, qardaşı oğlu Lutu və onun əmlakını, həmçinin qadınları və xalqı geri qaytardı. ");
INSERT INTO azb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","İbram Kedorlaomer və onunla olan padşahları məğlub edib qayıdanda Sodom padşahı «Padşah vadisi» adlanan Şave vadisində onun pişvazına çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Onda Salem padşahı Melkisedeq çörək və şərab gətirdi. O, Allah-Taalanın kahini idi. ");
INSERT INTO azb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melkisedeq İbrama xeyir-dua verib dedi: «Göy və yeri yaradan Allah-Taala İbrama xeyir-dua versin. ");
INSERT INTO azb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Düşmənlərini sənə təslim edən Allah-Taalaya alqış olsun». İbram bütün qənimətin onda birini Melkisedeqə verdi. ");
INSERT INTO azb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom padşahı İbrama dedi: «Adamlarımı mənə ver, əmlak isə sənə qalsın». ");
INSERT INTO azb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ancaq İbram Sodom padşahına dedi: «Göy və yeri yaradan Allah-Taala Rəbbin dərgahına and üçün əlimi qaldırıram ki, ");
INSERT INTO azb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","sənin nə bir ipini, nə də bir çarıq bağını götürürəm, ta deməyəsən ki, mən İbramı varlandırdım. ");
INSERT INTO azb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nökərlərin yediklərindən başqa, hər şey sənin olsun. Üstəlik mənimlə gedən adamlar – Aner, Eşkol və Mamre öz paylarını götürsün». ");
INSERT INTO azb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bir müddət sonra İbrama görüntüdə Rəbbin bu sözü nazil oldu: «Ey İbram, qorxma. Sənin qalxanın Mənəm. Mükafatın çox böyük olacaq». ");
INSERT INTO azb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","İbram dedi: «Ey Xudavənd Rəbb, mənə nə verəcəksən? Mənim övladım yoxdur, evimin sahibi bu Dəməşqli Eliezer olacaq». ");
INSERT INTO azb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","İbram sözünə davam etdi: «Sən mənə övlad vermədiyin üçün evimin nökəri mənim varisim olacaq». ");
INSERT INTO azb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ona Rəbbin bu sözü nazil oldu: «O sənin varisin olmayacaq, öz belindən gələn övladın sənin varisin olacaq». ");
INSERT INTO azb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Rəbb onu bayıra çıxarıb dedi: «Göyə bax, oradakı ulduzları saya bilərsənsə, say». Yenə dedi: «Nəslin o qədər olacaq». ");
INSERT INTO azb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","İbram Rəbbə iman etdi və Rəbb bunu ona salehlik saydı. ");
INSERT INTO azb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Rəbb İbrama dedi: «Bu torpağı sənə irs olaraq vermək üçün səni Xaldeylilərin Ur şəhərindən çıxaran Mən Rəbbəm». ");
INSERT INTO azb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","İbram soruşdu: «Ya Xudavənd Rəbb, onu irs olaraq alacağımı necə bilim?» ");
INSERT INTO azb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Rəbb ona dedi: «Mənim üçün bir üçyaşlı düyə, bir üçyaşlı keçi, bir üçyaşlı qoç, həmçinin bir qumru və bir göyərçin balası gətir». ");
INSERT INTO azb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","İbram bunların hamısını götürüb kəsdi və iki hissəyə ayırdı, hər hissəni o birinin qarşısına qoydu, ancaq quşları iki hissəyə ayırmadı. ");
INSERT INTO azb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yırtıcı quşlar cəmdəklərin üzərinə uçub gəldilər, ancaq İbram onları qovdu. ");
INSERT INTO azb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Günəş batan vaxt İbrama dərin yuxu gəldi. Birdən onun üzərinə dəhşət və qatı qaranlıq çökdü. ");
INSERT INTO azb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Rəbb İbrama dedi: «Yəqin bil ki, nəslin yad ölkədə qərib olacaq, orada olan millətə köləlik edəcək və onlara dörd yüz il zülm ediləcək. ");
INSERT INTO azb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ancaq onların köləlik edəcəkləri xalqı Özüm cəzalandıracağam. Bundan sonra onlar böyük əmlakla oradan çıxacaqlar. ");
INSERT INTO azb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Sən isə atalarının yanına gedəcəksən, uzun ömür sürəndən sonra sülh içində öləcəksən. ");
INSERT INTO azb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Sənin dördüncü nəslin buraya qayıdacaq, çünki Emorluların günah kasası hələ dolmayıb». ");
INSERT INTO azb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Günəş batıb qaranlıq düşəndə tüstü çıxan bir təndir və alovlanan məşəl görünərək parçalanmış heyvanların arasından keçdi. ");
INSERT INTO azb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","O gün Rəbb İbramla əhd bağlayıb dedi: «Misir çayından böyük Fərat çayına qədər uzanan bu torpaqları – ");
INSERT INTO azb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Qenlilərin, Qenizlilərin, Qadmonluların, ");
INSERT INTO azb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Xetlilərin, Perizlilərin, Rafalıların, ");
INSERT INTO azb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Emorluların, Kənanlıların, Qirqaşlıların və Yevusluların torpağını Mən sənin nəslinə verirəm». ");
INSERT INTO azb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","İbramın arvadı Sarayın uşağı olmurdu. Onun Həcər adında Misirli bir qarabaşı var idi. ");
INSERT INTO azb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saray İbrama dedi: «Bax Rəbb mənim bətnimi bağladı ki, uşağım olmasın. Qarabaşımla yaxınlıq et, qoy o mənim üçün uşaq doğsun». İbram Sarayın sözünə qulaq asdı. ");
INSERT INTO azb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","İbramın arvadı Saray qarabaşı Misirli Həcəri götürüb əri İbrama arvad olmaq üçün verdi; bu əhvalat İbram Kənan torpağında on il yaşadıqdan sonra baş verdi. ");
INSERT INTO azb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","İbram Həcərlə yaxınlıq etdi və Həcər hamilə oldu. Həcər hamilə olduğunu görəndə xanımına həqarətlə baxmağa başladı. ");
INSERT INTO azb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saray İbrama dedi: «Mənim təhqir olunmağıma sən səbəb oldun. Mən qarabaşımı sənin qoynuna verdim, o da hamilə olduğunu görəndə mənə həqarətlə baxmağa başladı. Qoy səninlə mənim aramda Rəbb hökm etsin». ");
INSERT INTO azb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","İbram Saraya dedi: «Qarabaşını sənin ixtiyarına verirəm, ona nə istəyirsən, elə». Saray qarabaşı ilə sərt rəftar etməyə başladı və qarabaşı onun yanından qaçdı. ");
INSERT INTO azb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Rəbbin mələyi Şur yolundakı çöldə olan bulağın yanında onu tapdı. ");
INSERT INTO azb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mələk ondan soruşdu: «Ey Sarayın qarabaşı Həcər, haradan gəlib, haraya gedirsən?» Həcər dedi: «Mən xanımım Sarayın yanından qaçıram». ");
INSERT INTO azb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Rəbbin mələyi ona dedi: «Xanımının yanına qayıt və ona tabe ol». ");
INSERT INTO azb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Rəbbin mələyi sözünə davam etdi: «Sənin nəslini lap çoxaldacağam, çoxluğuna görə sayı-hesabı bilinməyəcək». ");
INSERT INTO azb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Sonra Rəbbin mələyi ona dedi: «Bax sən hamiləsən, Bir oğul doğacaqsan. Onun adını İsmail qoyarsan, Çünki Rəbb əziyyət içində fəryadını eşitdi. ");
INSERT INTO azb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","O, insanlar arasında Vəhşi eşşək kimi olacaq: O hamıya, Hamı isə ona qarşı çıxacaq, Bütün qardaşları ilə yola getməyərək yaşayacaq». ");
INSERT INTO azb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Həcər onunla danışan Rəbbi «Sən El-Roisən» adlandırdı, çünki o söyləmişdi: «Doğrudan da, burada məni görən Allahı gördüm». ");
INSERT INTO azb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Buna görə də həmin bulaq Beer-Laxay-Roi adlanır. O, Qadeşlə Beredin arasında yerləşir. ");
INSERT INTO azb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Həcər İbrama bir oğul doğdu və İbram Həcərdən olan oğlunun adını İsmail qoydu. ");
INSERT INTO azb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Həcər ona İsmaili doğanda İbramın səksən altı yaşı var idi. ");
INSERT INTO azb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","İbram doxsan doqquz yaşında olanda Rəbb ona görünərək dedi: «Külli-İxtiyar Allah Mənəm. Mənim yolumla get və kamil ol. ");
INSERT INTO azb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Əhdimi Özümlə sənin aranda qoyacağam və nəslini lap çoxaldacağam». ");
INSERT INTO azb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","İbram üzüstə düşdü. Allah onunla danışıb dedi: ");
INSERT INTO azb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Mən səninlə əhd bağlamışam, sən çoxlu millətin atası olacaqsan. ");
INSERT INTO azb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Daha sənə İbram deyilməyəcək, bu gündən adın İbrahim olacaq, çünki səni çoxlu millətin atası etdim. ");
INSERT INTO azb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nəslini lap çoxaldacağam, səndən millətlər törədəcəyəm və nəslindən padşahlar çıxacaq. ");
INSERT INTO azb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Özümlə sənin və səndən sonrakı nəslinin arasında əbədi əhd qoyuram ki, Mən sənin və səndən sonrakı nəslinin Allahı olacağam. ");
INSERT INTO azb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Sənə və səndən sonrakı nəslinə qərib kimi yaşadığın bu torpağı – bütün Kənan torpağını əbədi mülk olaraq verəcəyəm və onların Allahı olacağam». ");
INSERT INTO azb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Sonra Allah İbrahimə dedi: «Sən və səndən sonrakı övladların nəsillər boyu əhdimə əməl edin. ");
INSERT INTO azb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mənim səninlə və səndən sonrakı nəslinlə bağladığım, sizin əməl edəcəyiniz əhdin əlaməti budur: qoy aranızda olan bütün kişilər sünnət olunsun. ");
INSERT INTO azb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Sünnət ətinizi kəsin; bu Mənimlə sizin aranızda olan əhdin əlaməti olacaq. ");
INSERT INTO azb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Evinizdə doğulmuş yaxud nəslinizdən olmayıb bir yadellidən satın alınmış kişi cinsindən olan hər uşaq səkkizinci gün sünnət olunsun; bu, nəsildən-nəslə davam etsin. ");
INSERT INTO azb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Evinizdə doğulmuş yaxud satın alınmış hər uşaq mütləq sünnət olunmalıdır. Beləcə Mənim əhdimin əlaməti əbədi olaraq bədəninizdə olacaq. ");
INSERT INTO azb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Sünnət əti kəsilməmiş kişi cinsindən olan hər kəs xalqının arasından qovulacaq, çünki əhdimi pozmuş olacaq». ");
INSERT INTO azb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Allah yenə İbrahimə dedi: «Arvadın Saraya isə artıq Saray demə. Bundan sonra onun adı Sara olacaq. ");
INSERT INTO azb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ona xeyir-dua verəcəyəm, ondan sənə bir oğul verəcəyəm. Saraya xeyir-dua verəcəyəm: o, millətlərin anası olacaq və xalqların padşahları ondan doğulacaq». ");
INSERT INTO azb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","İbrahim üzüstə düşdü və gülüb ürəyində dedi: «Yüz yaşlı adamın oğlu ola bilərmi? Doxsan yaşında olan Sara doğacaqmı?» ");
INSERT INTO azb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Sonra İbrahim Allaha dedi: «Kaş ki İsmail Sənin önündə xeyir-dua alaydı!» ");
INSERT INTO azb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Allah isə dedi: «Xeyr, arvadın Sara sənə bir oğul doğacaq və adını İshaq qoyacaqsan. Onunla və ondan sonrakı nəsli ilə əhdimi əbədi olaraq davam etdirəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","İsmail barədə dediyin sözləri də eşitdim. Ona xeyir-dua verəcəyəm, onu bəhərli edəcəyəm, nəslini lap çoxaldacağam. O, on iki başçının atası olacaq. Ondan böyük bir millət törədəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Əhdimi isə gələn il bu vaxt Saranın sənə doğacağı İshaqla saxlayacağam». ");
INSERT INTO azb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Allah İbrahimlə söhbətini bitirərək ondan ayrılıb yuxarı çəkildi. ");
INSERT INTO azb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","İbrahim oğlu İsmaili, evində doğulan bütün nökərləri, satın aldığı hər kəsi – öz evində kişi cinsindən olan bütün adamları götürüb həmin gün Allahın ona dediyi kimi sünnət etdi. ");
INSERT INTO azb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Sünnət əti kəsilən vaxt İbrahim doxsan doqquz yaşında idi. ");
INSERT INTO azb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Oğlu İsmail isə sünnət əti kəsilən vaxt on üç yaşında idi. ");
INSERT INTO azb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","İbrahim oğlu İsmaillə birgə həmin gün sünnət olundu. ");
INSERT INTO azb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Onunla birgə evdəki bütün kişilər – evində doğulan və yadellilərdən satın alınmış hər kəs sünnət olundu. ");
INSERT INTO azb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mamre palıdının yanında Rəbb İbrahimə göründü; bu zaman o, günün istisində çadırın girəcəyində oturmuşdu. ");
INSERT INTO azb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","O, başını qaldırıb baxanda qarşısında üç adamın dayandığını gördü. Onları görən kimi çadırın girəcəyindən onları qarşılamağa qaçdı və yerə qədər əyilib dedi: ");
INSERT INTO azb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","«Ey ağam, əgər indi gözündə lütf tapdımsa, qulunun yurdundan yan keçmə. ");
INSERT INTO azb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","İndi bir az su gətirərlər, ayaqlarınızı yuyub, ağac altında dincələrsiniz. ");
INSERT INTO azb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mən isə bir parça çörək gətirərəm ki, canınıza qüvvət gəlsin. Ondan sonra gedərsiniz, çünki siz qulunuzun yanından keçirdiniz». Onlar dedilər: «Dediyin kimi elə». ");
INSERT INTO azb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","İbrahim çadıra – Saranın yanına qaçıb dedi: «Tez ol, üç sea narın un götürüb xəmir yoğur və kökə bişir». ");
INSERT INTO azb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","İbrahim mal-qaraya tərəf qaçdı. Oradan körpə və yaxşı bir buzov götürüb nökərinə verdi. Nökər də onu hazırlamaq üçün tələsdi. ");
INSERT INTO azb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","İbrahim kəsmiyi, südü və hazırladığı buzovu götürüb onların qabağına qoydu, özü isə ağacın altında, onların yanında durdu. Onlar da yedilər. ");
INSERT INTO azb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sonra İbrahimə dedilər: «Arvadın Sara haradadır?» O dedi: «Burada çadırdadır». ");
INSERT INTO azb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Onlardan biri dedi: «Gələn il bu vaxt yenə də sənin yanına gələcəyəm. Onda arvadın Saranın bir oğlu olacaq». Sara onun arxasında, çadırın girəcəyində durub qulaq asırdı. ");
INSERT INTO azb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","İbrahim və Sara qocalıb yaşa dolmuşdular. Sara aybaşıdan kəsilmişdi. ");
INSERT INTO azb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","O, ürəyində gülüb dedi: «Qocaldığım halda mənə belə şadlıq üz verə bilərmi? Ağam da qocadır». ");
INSERT INTO azb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Rəbb İbrahimə dedi: «Sara nə üçün “Qocaldıqdan sonra mən uşaq doğa bilərəmmi?” deyib güldü? ");
INSERT INTO azb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Rəbb üçün çətin bir şey varmı? Gələn il bu vaxt Mən yenə sənin yanında olacağam və Saranın bir oğlu olacaq». ");
INSERT INTO azb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara qorxduğu üçün «gülmədim» deyib inkar etdi. Ancaq Rəbb dedi: «Xeyr, güldün». ");
INSERT INTO azb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","O adamlar qalxıb oradan Sodoma tərəf baxdılar. İbrahim onları yola salmaq üçün onlarla birgə getdi. ");
INSERT INTO azb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","O vaxt Rəbb dedi: «Mən edəcəyim şeyi İbrahimdən gizlədəcəyəmmi? ");
INSERT INTO azb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Həqiqətən, İbrahimdən böyük və güclü bir millət törəyəcək, onun vasitəsilə yer üzünün bütün millətləri xeyir-dua alacaq. ");
INSERT INTO azb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Çünki Mən onu seçdim ki, oğullarına və özündən sonrakı nəslinə saleh və ədalətli işlər görmək üçün Rəbbin yolu ilə getməyi tapşırsın. Rəbb də İbrahim barədə dediyi sözü yerinə yetirsin». ");
INSERT INTO azb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Rəbb yenə dedi: «Sodom və Homorraya qarşı qalxan fəryad böyük, oranın adamlarının günahı çox ağırdır. ");
INSERT INTO azb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Buna görə də aşağı enib baxacağam ki, Mənə çatan fəryadın doğru olub-olmadığını bilim». ");
INSERT INTO azb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","O adamlar oradan dönüb Sodoma getdilər, ancaq İbrahim hələ də Rəbbin önündə dururdu. ");
INSERT INTO azb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","İbrahim yaxın gəlib dedi: «Doğrudanmı, Sən salehi də günahkarla birgə məhv edəcəksən? ");
INSERT INTO azb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Əgər bu şəhərdə əlli nəfər saleh adam olsa, Sən yenə də oranı məhv edəcəksən? Əlli nəfər saleh adamın xatirinə bu yerə rəhm etməyəcəksən? ");
INSERT INTO azb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Axı Sən bunu eləməzsən, saleh adamı günahkarla birgə öldürməzsən. Saleh adamın aqibətini günahkarınkı kimi etməzsən, Sən bunu eləməzsən. Bütün dünyanın Hakimi belə ədalətsizlik etməz». ");
INSERT INTO azb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Rəbb dedi: «Əgər Sodom şəhərində əlli nəfər saleh adam tapsam, onların xatirinə bütün bu yerə rəhm edəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","İbrahim cavab verdi: «Mən önündə toz və kül kimi bir şey olsam da, indi bunu Rəbbə söyləməyə cəsarət edirəm: ");
INSERT INTO azb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","əlli nəfərdən beş nəfər az saleh adam tapılsa, beş nəfər əskik olduğu üçün bütün şəhəri məhv edərsənmi?» Rəbb dedi: «Əgər orada qırx beş nəfər tapsam, şəhəri dağıtmayacağam». ");
INSERT INTO azb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","İbrahim yenə Onu dilə tutub dedi: «Əgər orada qırx nəfər tapılsa, necə?» Rəbb dedi: «Qırx nəfərin də xatirinə bunu etmərəm». ");
INSERT INTO azb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","İbrahim dedi: «Mən çox danışdığım üçün Rəbb qəzəblənməsin: əgər orada otuz nəfər tapılsa, necə?» Rəbb dedi: «Əgər orada otuz nəfər də tapılsa, bunu etmərəm». ");
INSERT INTO azb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","İbrahim dedi: «Mən yenə də Rəbbə bunu söyləməyi cəsarət edirəm: orada iyirmi nəfər tapılsa, necə?» Rəbb dedi: «İyirmi nəfərin də xatirinə oranı məhv etmərəm». ");
INSERT INTO azb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","İbrahim dedi: «Qoy Rəbb qəzəblənməsin ki, mən son dəfə danışacağam: orada on nəfər tapılsa, necə?» Rəbb dedi: «On nəfərin də xatirinə oranı məhv etmərəm». ");
INSERT INTO azb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Rəbb İbrahimlə söhbətini bitirib getdi. İbrahim də öz yerinə qayıtdı. ");
INSERT INTO azb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Axşam iki mələk Sodoma gəldi. Lut şəhərin darvazası yanında oturmuşdu. O, mələkləri gördü, qalxıb onları qarşıladı və yerə qədər əyilib dedi: ");
INSERT INTO azb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«Ağalarım, qulunuzun evinə girib gecələyin və ayaqlarınızı yuyun. Səhər qalxıb yolunuza davam edərsiniz». Onlar dedilər: «Yox, biz gecəni şəhər meydanında keçirəcəyik». ");
INSERT INTO azb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lut onları çox dilə tutdu, axırda onlar Lutla birgə onun evinə getdilər. Lut onları qonaq edib mayasız çörəklər bişirdi və onlar yedilər. ");
INSERT INTO azb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ancaq onlar yatmazdan əvvəl cavandan tutmuş qocaya qədər Sodom şəhərinin hər məhəlləsindən olan kişilər evi əhatəyə aldılar. ");
INSERT INTO azb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Adamlar Lutu çağırıb ona dedilər: «Bu gecə sənin yanına gələn adamlar haradadır? Onları bizim yanımıza gətir ki, onlarla yaxınlıq edək». ");
INSERT INTO azb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lut bayıra – onların yanına çıxıb arxasınca qapını örtdü. ");
INSERT INTO azb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","O dedi: «Qardaşlarım, pislik etməyin. ");
INSERT INTO azb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mənim ərə getməmiş iki qızım var. Qızlarımı sizin yanınıza gətirim, onlara nə istəyirsiniz, edin. Ancaq bu adamlara toxunmayın, çünki onlar mənim evimin qonaqlarıdır». ");
INSERT INTO azb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kişilər qışqırıb dedilər: «Geri çəkil! Bu adam burada qəribdir, ancaq ağalıq edir. İndi səninlə onlardan da pis rəftar edəcəyik». Onlar Luta hücum edib qapını qırmaq üçün yaxınlaşdılar. ");
INSERT INTO azb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Onda içəridəki mələklər əllərini uzadıb Lutu evin içinə – öz yanlarına saldılar və qapını bağladılar. ");
INSERT INTO azb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Evin qapısı arxasında duran adamları kiçikdən tutmuş böyüyə qədər kor etdilər. Bu səbəbdən adamlar qapını tapa bilmədilər. ");
INSERT INTO azb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mələklər Luta dedilər: «Burada daha kimin var? Bu şəhərdə kürəkənlərin, oğulların, qızların – nəslindən olan hər kəs varsa, hamısını bu yerdən çıxart, ");
INSERT INTO azb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","çünki biz bu yeri məhv edəcəyik. Bu xalqın əleyhinə qalxan fəryad Rəbbə gəlib çatmışdır, buna görə də Rəbb bizi göndərib ki, onu məhv edək». ");
INSERT INTO azb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lut gedib qızlarını almaq istəyən kürəkənlərinə dedi: «Qalxıb bu yerdən çıxın, çünki Rəbb şəhəri məhv edəcək». Ancaq kürəkənləri güman etdilər ki, o zarafat edir. ");
INSERT INTO azb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Səhər açılanda mələklər Lutu tələsdirərək dedilər: «Qalx yanındakı arvadını və iki qızını götür get, yoxsa şəhərdəkilərin günahlarına görə məhv olacaqsan». ");
INSERT INTO azb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lut yavaş tərpəndi. Rəbb ona mərhəmət etdiyinə görə həmin şəxslər onun, arvadının və iki qızının əlindən tutub şəhərdən kənara çıxartdılar. ");
INSERT INTO azb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Onları çıxaran zaman mələklərdən biri dedi: «Öz canını qurtar, arxana baxma. Bu düzənliyin heç yerində qalma, dağa qalx, yoxsa həlak olarsan». ");
INSERT INTO azb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lut onlara dedi: «Aman, ağam! ");
INSERT INTO azb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","İndi bu qulun sənin gözündə lütf tapdı və canımı xilas etməklə mənə göstərdiyin xeyirxahlığını çoxaltdın. Ancaq dağa çata bilmərəm, çünki bəla mənə də yetişə bilər və həlak olaram. ");
INSERT INTO azb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yaxınlıqda qaça biləcəyim kiçik bir şəhər var. Qoy oraya qaçıb canımı qurtarım. Axı o şəhər kiçikdir». ");
INSERT INTO azb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mələklərdən biri Luta dedi: «Sənin xatirinə bunu da edərəm: dediyin şəhəri dağıtmaram. ");
INSERT INTO azb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tez ol, oraya qaç! Sən oraya çatmamış Mən bir şey etməyəcəyəm». Buna görə də o şəhər Soar adlandı. ");
INSERT INTO azb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Günəş doğanda Lut Soara gəldi. ");
INSERT INTO azb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Rəbb Sodom və Homorranın üzərinə göydən odlu kükürd yağdırdı, ");
INSERT INTO azb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","bu şəhərləri, bütün düzənliyi, oranın bütün sakinlərini və torpaqda bitən hər şeyi məhv etdi. ");
INSERT INTO azb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ancaq Lutun arvadı dönüb geriyə baxdı və duz sütununa çevrildi. ");
INSERT INTO azb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","İbrahim səhər erkən qalxıb Rəbbin önündə durduğu yerə getdi. ");
INSERT INTO azb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Oradan Sodom və Homorraya, bütün düzənliyə baxdı. O, yerdən kürə tüstüsü kimi bir tüstü qalxdığını gördü. ");
INSERT INTO azb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Allah düzənlikdəki şəhərləri məhv etdiyi zaman İbrahimi xatırladı, buna görə də Lutun yaşadığı şəhərləri dağıdarkən onu fəlakət içindən çıxartdı. ");
INSERT INTO azb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lut iki qızı ilə birgə Soardan çıxıb dağda yaşadı, çünki Soarda yaşamaqdan qorxurdu. O, iki qızı ilə bir mağarada qaldı. ");
INSERT INTO azb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Onun böyük qızı kiçiyinə dedi: «Atamız qocalıb və bu dünyada insan adətinə görə yanımıza girməyə bir kişi yoxdur. ");
INSERT INTO azb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Gəl atamıza şərab içirək və onunla yataq ki, öz atamızdan nəslimiz olsun». ");
INSERT INTO azb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Onlar o gecə atalarına şərab içirdilər. Böyük qız içəri girib atası ilə yatdı, atası isə onun nə vaxt yatıb-durduğunu bilmədi. ");
INSERT INTO azb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","O biri gün böyük qız kiçiyinə dedi: «Mən dünən gecə atamla yatdım. Gəl bu gecə də ona şərab içirək və sən də onunla yat ki, öz atamızdan nəslimiz olsun». ");
INSERT INTO azb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","O gecə yenə atalarına şərab içirdilər. Kiçik qız qalxıb onunla yatdı, atası isə onun nə vaxt yatıb-durduğunu bilmədi. ");
INSERT INTO azb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lutun iki qızı beləcə atalarından hamilə oldu. ");
INSERT INTO azb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Böyük qız bir oğul doğdu və onun adını Moav qoydu. O, indiki Moavlıların əcdadıdır. ");
INSERT INTO azb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kiçik qız da bir oğul doğdu və onun adını Ben-Ammi qoydu. O, indiki Ammonluların əcdadıdır. ");
INSERT INTO azb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","İbrahim Mamredən Negev torpağına köçdü və Qadeşlə Şur arasında məskən saldı. Sonra bir müddət Gerarda qaldı. ");
INSERT INTO azb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","İbrahim orada arvadı Sara barəsində «bu mənim bacımdır» söylədi. Gerar padşahı Avimelek adam göndərib Saranı apardı. ");
INSERT INTO azb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ancaq gecə yuxuda Allah Avimelekə görünüb dedi: «Apardığın qadına görə sən öləcəksən, çünki o, bir nəfərin arvadıdır». ");
INSERT INTO azb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Avimelek qadına toxunmamışdı. O dedi: «Ya Rəbb, məgər sən günahsız xalqı öldürə bilərsən? ");
INSERT INTO azb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","O adam mənə “bu mənim bacımdır” demədimi? Qadın özü də “o mənim qardaşımdır” dedi. Mən bunu sadədillik və təmiz niyyətlə etdim». ");
INSERT INTO azb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Allah yuxuda dedi: «Mən də bilirəm ki, sən bunu sadədilliklə etdin. Buna görə də səni ona toxunmağa qoymayaraq Mənə qarşı günah etməkdən saxladım. ");
INSERT INTO azb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","İndi isə qadını ərinə qaytar, çünki o, peyğəmbərdir. Sənin üçün dua edər, salamat qalarsan. Ancaq qadını qaytarmasan, özün və bütün nəslin hökmən öləcək». ");
INSERT INTO azb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Avimelek səhər tezdən qalxıb bütün adamlarını çağırdı və bu sözləri onların qarşısında söylədi. Adamlar çox qorxdular. ");
INSERT INTO azb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Avimelek İbrahimi çağırıb ona dedi: «Bizə nə etdin? Sənə qarşı nə günah etdim ki, özümün və padşahlığımın üzərinə bu böyük təqsiri gətirdin? Mənə qarşı nalayiq işlər etdin». ");
INSERT INTO azb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Avimelek yenə İbrahimə dedi: «Bu işi görəndə nə düşünürdün?» ");
INSERT INTO azb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","İbrahim dedi: «Düşünürdüm ki, burada Allah qorxusu yoxdur və arvadıma görə məni öldürəcəklər. ");
INSERT INTO azb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","O, doğrudan da, mənim bacımdır: atamız birdir, ancaq anamız ayrıdır. Mən onu arvad aldım. ");
INSERT INTO azb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Allah məni ata evimdən qürbətə apardığı vaxt ona dedim: “Mənə bu cür yaxşılıq elə: gedəcəyimiz hər yerdə mənim barəmdə ‹bu mənim qardaşımdır› söylə”». ");
INSERT INTO azb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Avimelek İbrahimə qoyun-keçi, mal-qara, qullar və qarabaşlar verdi. Arvadı Saranı da ona qaytardı. ");
INSERT INTO azb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Avimelek dedi: «Mənim ölkəm sənin önündədir: istədiyin yerdə yaşaya bilərsən». ");
INSERT INTO azb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sonra Saraya dedi: «Bax qardaşına min parça gümüş verdim. Qoy bu gümüş sənin yanındakılara günahsızlığını göstərən bir sübut olsun və hər kəs sənin günahsız olduğunu bilsin». ");
INSERT INTO azb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","İbrahim Allaha dua etdi, Allah da Avimelekə, onun arvadına və cariyələrinə şəfa verdi: onların uşaqları oldu. ");
INSERT INTO azb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Çünki Rəbb İbrahimin arvadı Saradan ötrü Avimelekin evində olan bütün qadınların bətnini bağlamışdı. ");
INSERT INTO azb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Rəbb dediyi kimi Saraya nəzər saldı və ona söylədiyi sözü yerinə yetirdi: ");
INSERT INTO azb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara hamilə oldu və İbrahimin qocalıq çağında – Allahın ona söylədiyi vaxt bir oğul doğdu. ");
INSERT INTO azb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","İbrahim Saradan doğulan oğluna İshaq adını qoydu. ");
INSERT INTO azb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Allahın İbrahimə əmr etdiyi kimi o, oğlu İshaqı doğulandan səkkiz gün sonra sünnət etdi. ");
INSERT INTO azb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","İshaq doğulanda İbrahimin yüz yaşı var idi. ");
INSERT INTO azb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara dedi: «Allah mənim üzümü güldürdü. Bunu eşidən hər kəs mənimlə birgə güləcək». ");
INSERT INTO azb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","O yenə dedi: «Kim İbrahimə deyərdi ki, Sara uşaq əmizdirəcək? Amma qocalıq çağında mən ona bir oğul doğmuşam». ");
INSERT INTO azb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Uşaq böyüyüb süddən kəsildi. İshaqın süddən kəsildiyi gün İbrahim böyük bir ziyafət verdi. ");
INSERT INTO azb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara gördü ki, Misirli Həcərin İbrahimə doğduğu oğlu ona gülür. ");
INSERT INTO azb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara İbrahimə dedi: «Bu cariyəni və onun oğlunu qov. Bu cariyənin oğlu mənim oğlum İshaqla birgə varis olmayacaq». ");
INSERT INTO azb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bu iş İbrahimi çox narahat etdi, çünki İsmail də onun oğlu idi. ");
INSERT INTO azb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Allah İbrahimə dedi: «Uşaqdan və cariyəndən ötrü narahat olma. Saranın sənə söylədiyi bütün sözlərə qulaq as, çünki İshaqdan törəyənlər sənin nəslin adlanacaq. ");
INSERT INTO azb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Amma cariyənin oğlundan da bir millət törədəcəyəm, çünki o da sənin nəslindir». ");
INSERT INTO azb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","İbrahim səhər tezdən qalxdı, çörək və bir tuluq su götürüb çiyninə qoyaraq Həcərə verdi. Uşağı da ona verib onu yola saldı. Həcər gedib Beer-Şeva çölündə dolaşdı. ");
INSERT INTO azb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tuluqda su qurtardı. O, oğlunu bir kolun altına qoydu. ");
INSERT INTO azb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Sonra oradan bir ox məsafəsi qədər aralanıb uzaqda oturdu. «Oğlumun ölümünü görməyim» dedi və uşağın qarşısında oturub hönkür-hönkür ağladı. ");
INSERT INTO azb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Allah uşağın səsini eşitdi. Allahın mələyi göylərdən Həcəri çağırıb dedi: «Sənə nə olub, Həcər? Qorxma, çünki uşağın oturduğu yerdən Allah onun səsini eşitdi. ");
INSERT INTO azb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Qalx uşağı qaldır, onu qucağına götür. Mən ondan böyük bir millət törədəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Allah Həcərin gözlərini açdı və o, bir su quyusu gördü. Gedib tuluğu su ilə dolduraraq uşağa içirtdi. ");
INSERT INTO azb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah bu uşaqla idi. O böyüyüb, çöldə yaşamağa başladı və mahir oxatan oldu. ");
INSERT INTO azb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","O, Paran çölündə məskən saldı. Anası ona Misir torpağından bir arvad aldı. ");
INSERT INTO azb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","O zaman Avimelek və onun ordu başçısı Pikol İbrahimə dedilər: «Sən nə etsən, Allah səninlədir. ");
INSERT INTO azb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","İndi burada Allahın haqqına mənə and iç ki, nə mənə, nə oğluma, nə də nəvəmə xəyanət edəcəksən: mən sənə sadiq olduğum kimi sən də mənə və qaldığın torpağın adamlarına sadiq ol». ");
INSERT INTO azb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","İbrahim «mən and içirəm» dedi. ");
INSERT INTO azb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Avimelekin adamlarının qəsb etdiyi su quyusundan ötrü İbrahim Avimeleki məzəmmət etdi. ");
INSERT INTO azb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Avimelek dedi: «Bilmirəm, bu işi kim etdi. Sən də mənə bildirmədin, mən ancaq indi eşidirəm». ");
INSERT INTO azb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","İbrahim qoyun-keçi və mal-qara alıb Avimelekə verdi. Beləcə ikisi bir əhd bağladı. ");
INSERT INTO azb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","İbrahim sürüsündən yeddi dişi quzunu ayırıb qoydu. ");
INSERT INTO azb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Avimelek İbrahimə dedi: «Ayırıb qoyduğun bu yeddi dişi quzu nə üçündür?» ");
INSERT INTO azb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","O dedi: «Bu yeddi dişi quzunu məndən götür ki, bu quyunu qazdığıma şəhadət olsun». ");
INSERT INTO azb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Buna görə də o buranı Beer-Şeva adlandırdı, çünki onların ikisi də orada and içdi. ");
INSERT INTO azb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Beləcə Beer-Şevada əhd bağladılar. Sonra Avimelek və onun ordu başçısı Pikol qalxıb Filiştlilərin ölkəsinə qayıtdılar. ");
INSERT INTO azb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","İbrahim Beer-Şevada bir yulğun ağacı əkdi və orada əbədi Allah olan Rəbbin adını çağırdı. ");
INSERT INTO azb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","İbrahim Filiştlilərin ölkəsində uzun müddət qaldı. ");
INSERT INTO azb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bir müddət sonra Allah İbrahimi sınağa çəkdi. O «Ey İbrahim!» deyə çağırdı. İbrahim «Buradayam!» dedi. ");
INSERT INTO azb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Allah dedi: «Sevdiyin yeganə oğlunu – İshaqı götürüb Moriya torpağına get. Orada sənə göstərəcəyim bir dağda oğlunu yandırma qurbanı olaraq təqdim et». ");
INSERT INTO azb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","İbrahim səhər tezdən qalxdı və eşşəyini palanladı. Özü ilə iki nökərini və oğlu İshaqı götürdü. O, yandırma qurbanı üçün odun yardı və qalxıb Allahın dediyi yerə yollandı. ");
INSERT INTO azb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","İbrahim üçüncü gün başını qaldırıb uzaqdan o yeri gördü. ");
INSERT INTO azb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","O, nökərlərinə dedi: «Siz eşşəklə birlikdə burada qalın, mən uşaqla oraya gedəcəyəm. Səcdə edib, yanınıza qayıdarıq». ");
INSERT INTO azb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","İbrahim yandırma qurbanı üçün odun götürüb oğlu İshaqın kürəyinə qoydu, odu və bıçağı isə özü götürdü. İkisi birlikdə getdilər. ");
INSERT INTO azb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","İshaq atası İbrahimi çağırdı: «Ay ata!» O cavab verdi: «Buradayam, oğlum». İshaq dedi: «Od və odun var, bəs yandırma qurbanı olacaq quzu haradadır?» ");
INSERT INTO azb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","İbrahim dedi: «Oğlum, yandırma qurbanı olacaq quzunu Allah Özü hazırlayacaq». İkisi birlikdə getdilər. ");
INSERT INTO azb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sonra Allahın İbrahimə göstərdiyi yerə gəldilər. İbrahim orada bir qurbangah düzəldib odunları düzdü və oğlu İshaqın əl-qolunu bağlayıb qurbangaha, odunların üstünə qoydu. ");
INSERT INTO azb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","İbrahim əlini uzadıb oğlunu kəsmək üçün bıçağı götürdü. ");
INSERT INTO azb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Rəbbin mələyi göylərdən onu çağırdı: «İbrahim, İbrahim!» O «Mən buradayam!» dedi. ");
INSERT INTO azb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mələk dedi: «Uşağa əl qaldırma və ona bir şey etmə. İndi bildim ki, sən Allahdan qorxursan; öz yeganə oğlunu Məndən əsirgəmədin». ");
INSERT INTO azb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","İbrahim başını qaldırıb baxdı və arxasında buynuzları kolluğa ilişmiş bir qoç gördü. İbrahim gedib qoçu götürdü və oğlunun əvəzinə yandırma qurbanı olaraq təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","İbrahim o yeri Yahve-İre adlandırdı; buna görə də indiyə qədər belə deyilir: «Rəbbin dağında hazırlanacaq». ");
INSERT INTO azb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Rəbbin mələyi yenə göylərdən İbrahimi çağırıb dedi: ");
INSERT INTO azb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Rəbb bəyan edir: “Öz varlığıma and içirəm ki, sən bu işi etdiyinə və yeganə oğlunu əsirgəmədiyinə görə ");
INSERT INTO azb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Mən sənə böyük xeyir-dua verəcəyəm, nəslini göydəki ulduzlar və dəniz kənarındakı qum qədər artırıb çoxaldacağam. Sənin nəslin öz düşmənlərinin şəhərlərinə sahib olacaq. ");
INSERT INTO azb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dünyanın bütün millətləri sənin nəslinin vasitəsilə xeyir-dua alacaq, çünki sən Mənim sözümə qulaq asdın”». ");
INSERT INTO azb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Sonra İbrahim öz nökərlərinin yanına qayıtdı və onlar qalxıb Beer-Şevaya getdilər. İbrahim Beer-Şevada sakin oldu. ");
INSERT INTO azb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bir müddət sonra İbrahimə xəbər verib söylədilər: «Budur, Milka qardaşın Naxora oğullar doğdu: ");
INSERT INTO azb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ilk oğlu Us, onun qardaşı Buz, Aramın atası olan Qemuel, ");
INSERT INTO azb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Xazo, Pildaş, İdlaf və Betuel». ");
INSERT INTO azb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueldən Rivqa törədi. Bu səkkiz övladı Milka İbrahimin qardaşı Naxora doğdu. ");
INSERT INTO azb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Onun adı Reuma olan cariyəsi də Tebahı, Qahamı, Taxaşı və Maakanı doğdu. ");
INSERT INTO azb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara yüz iyirmi yeddi il yaşadı; o bu qədər ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara Kənan torpağında olan Qiryat-Arbada, yəni Xevronda öldü. İbrahim yas tutub ağlamaqdan ötrü Saranın cəsədinin yanına getdi. ");
INSERT INTO azb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","İbrahim cəsədin yanından gedib Xetlilərə dedi: ");
INSERT INTO azb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Mən sizin aranızda qərib və qonağam. Yanınızda qəbir düzəltmək üçün mənə torpaq sahəsi satın ki, öz ölümü götürüb orada basdırım». ");
INSERT INTO azb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Xetlilər İbrahimə cavab verdilər: ");
INSERT INTO azb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Ey ağamız, bizə qulaq as: sən aramızda Allahın qoyduğu bir başçısan, öz ölünü də qəbirlərimizin ən yaxşısında basdır; ölünü basdırmaq üçün bizdən heç kəs qəbrini səndən əsirgəməz». ");
INSERT INTO azb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","İbrahim qalxıb o ölkənin xalqı olan Xetlilərə təzim etdi. ");
INSERT INTO azb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Sonra onlarla danışıb dedi: «Əgər siz mənim ölümü basdırmağa razısınızsa, mənə qulaq asın: mənim üçün Sohar oğlu Efrondan xahiş edin ki, ");
INSERT INTO azb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","tarlasının qurtaracağında ona məxsus olan Maxpela mağarasını mənə satsın, yanınızda qəbir düzəltmək üçün onu tam dəyəri ilə mənə versin». ");
INSERT INTO azb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron Xetlilərin arasında oturmuşdu. Xetli Efron şəhər darvazasının yanına yığılan bütün Xetlilərin önündə İbrahimə belə cavab verdi: ");
INSERT INTO azb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Yox, ağam, mənə qulaq as: mən tarlanı və orada olan mağaranı sənə verirəm, öz xalqımın adamları önündə onu sənə verirəm; get ölünü basdır». ");
INSERT INTO azb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","İbrahim o ölkənin xalqına təzim etdi. ");
INSERT INTO azb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Sonra o ölkənin xalqının yanında Efrona belə dedi: «Xahiş edirəm, mənə qulaq as: tarlanın dəyərini verirəm, onu məndən götür, qoy mən də öz ölümü orada basdırım». ");
INSERT INTO azb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron İbrahimə cavab verdi: ");
INSERT INTO azb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Ay ağam, mənə qulaq as: torpağın qiyməti dörd yüz şekel gümüşdür; mənimlə sənin aranda bu nədir? Ölünü basdır». ");
INSERT INTO azb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","İbrahim Efronun sözünü qəbul edib Xetlilərin yanında Efronun dediyi kimi tacirlərin tərəzi daşları ilə dörd yüz şekel gümüş çəkdi. ");
INSERT INTO azb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Beləcə Mamre qarşısındakı Maxpelada olan Efronun tarlası, oradakı mağara, tarlada və onun ərazisində olan bütün ağaclar ");
INSERT INTO azb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Xetlilərin gözü önündə – şəhər darvazasında yığılanların qarşısında İbrahimin mülkü oldu. ");
INSERT INTO azb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bundan sonra İbrahim arvadı Saranı Kənan torpağında olan Mamre, yəni Xevron qarşısındakı Maxpela tarlasının mağarasında basdırdı. ");
INSERT INTO azb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Beləcə Xetlilər tarlanı və orada olan mağaranı qəbir düzəltmək üçün İbrahimə mülk verdilər. ");
INSERT INTO azb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","İbrahim qocalıb yaşa dolmuşdu. Rəbb hər şeydə ona xeyir-dua vermişdi. ");
INSERT INTO azb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Bir gün İbrahim evində bütün işləri idarə edən qulbaşıya dedi: «Əlini budumun altına qoyub ");
INSERT INTO azb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","göyün və yerin Allahı Rəbbin adına mənə and iç ki, oğluma aralarında yaşadığım Kənanlıların qızlarından arvad almayacaqsan, ");
INSERT INTO azb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ancaq mənim ölkəmə, qohumlarımın yanına gedib oğlum İshaq üçün arvad alacaqsan». ");
INSERT INTO azb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nökər ona dedi: «Bəlkə qız mənimlə birgə bu ölkəyə gəlməyə razı olmadı? Onda oğlunu sənin çıxdığın ölkəyə aparımmı?» ");
INSERT INTO azb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","İbrahim ona dedi: «Bax oğlumu oraya aparma. ");
INSERT INTO azb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Məni atamın evindən və doğulduğum torpaqdan çıxaran, mənimlə danışan və and içərək “bu torpağı sənin nəslinə verəcəyəm” deyən göylərin Allahı Rəbb Öz mələyini sənin önündə göndərəcək və sən oradan oğluma arvad alıb gətirəcəksən. ");
INSERT INTO azb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Əgər o qadın səninlə gəlmək istəməsə, sən bu anddan azad olursan. Ancaq mənim oğlumu oraya aparma». ");
INSERT INTO azb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nökər əlini ağası İbrahimin budu altına qoyub bu işə görə ona and içdi. ");
INSERT INTO azb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nökər ağasından on dəvə və ən yaxşı hədiyyələr götürüb getdi və Aram-Naharayimə, Naxor şəhərinə gəldi. ");
INSERT INTO azb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Axşam qadınlar su çəkmək üçün çıxdıqları zaman onun dəvələri şəhərin kənarında olan su quyusunun yanında dayandı. ");
INSERT INTO azb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Sonra dua etdi: «Ya Rəbb, ağam İbrahimin Allahı, yalvarıram, bu gün işimi avand elə və ağam İbrahimə xeyirxahlıq göstər. ");
INSERT INTO azb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mən bu bulağın yanında dururam; şəhər sakinlərinin qızları su çəkmək üçün buraya gəlirlər. ");
INSERT INTO azb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Qoy elə olsun ki, mənim “xahiş edirəm, səhəngini endir, su içim” deyəcəyim və mənə “özün də iç və dəvələrinə də verim” söyləyəcək qız qulun İshaq üçün təyin etdiyin arvad olsun; bundan bilərəm ki, ağama xeyirxahlıq edirsən». ");
INSERT INTO azb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","O, duasını bitirməmişdi ki, İbrahimin qardaşı Naxorun arvadı Milkadan doğulan oğlu Betuelin qızı Rivqa çiynində səhəng gəldi. ");
INSERT INTO azb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Qız görünüşcə çox gözəl idi və hələ bakirə idi. O, bulağa endi və səhəngini doldurub yuxarı qalxdı. ");
INSERT INTO azb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nökər onun qabağına qaçıb dedi: «Xahiş edirəm, səhəngindən mənə bir az su ver, içim». ");
INSERT INTO azb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Qız dedi: «Ağam, buyur iç». Qız tez səhəngini əli üstünə endirdi və ona su verdi. ");
INSERT INTO azb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ona su verəndən sonra dedi: «Dəvələrin üçün də su çəkim, içib doysunlar». ");
INSERT INTO azb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Qız tez səhəngini təknəyə boşaltdı, su çəkmək üçün cəld quyunun yanına qaçdı və nökərin bütün dəvələri üçün su çəkdi. ");
INSERT INTO azb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","O adam sakit duraraq diqqətlə qıza baxırdı ki, Rəbbin onun yoluna xeyir-dua verib-vermədiyini bilsin. ");
INSERT INTO azb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Dəvələr su içib qurtaranda o adam çəkisi bir beqa olan qızıl burun sırğası, qızın qolları üçün çəkisi on şekel olan iki bilərzik götürüb dedi: ");
INSERT INTO azb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","«Mənə de görüm, sən kimin qızısan? Atanın evində bizə gecə qalmaq üçün yer tapılarmı?» ");
INSERT INTO azb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Qız ona dedi: «Mən Milkanın Naxora doğduğu Betuelin qızıyam». ");
INSERT INTO azb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Yenə dedi: «Bizdə saman da, yem də çoxdur və gecələməyə yer də var». ");
INSERT INTO azb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","O adam əyilib Rəbbə səcdə etdi. ");
INSERT INTO azb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Sonra dedi: «Ağam İbrahimin Allahı Rəbbə alqış olsun ki, xeyirxahlığını və sədaqətini ağamdan əsirgəmədi: Rəbb məni birbaş ağamın qardaşının evinə gətirdi». ");
INSERT INTO azb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Qız qaçıb anasının evində bu barədə danışdı. ");
INSERT INTO azb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rivqanın bir qardaşı var idi, adı Lavan idi. Lavan çıxıb o adamın yanına – bulağa qaçdı. ");
INSERT INTO azb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","O, bacısının burun halqasını və qollarındakı bilərziyi görəndə, bacısı Rivqanın «bu adam mənimlə belə danışdı» sözlərini eşidəndə o adamın yanına gəldi. O, bulaq başında dəvələrin yanında dayanmışdı. ");
INSERT INTO azb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lavan dedi: «Ey Rəbbin xeyir-dua verdiyi adam, içəri gir. Nə üçün bayırda durursan? Mən sənə otaq və dəvələrinə yer hazırlamışam». ");
INSERT INTO azb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","O adam evə girdi. Lavan dəvələrin yükünü boşaltdı, onlara saman və yem verdi, o adama və onunla birgə olanlara ayaqlarını yumaq üçün su verdi. ");
INSERT INTO azb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Onların qabağına yemək gətirildi, ancaq həmin adam dedi: «Məqsədimi söyləməyincə yeməyəcəyəm». Lavan dedi: «Söylə». ");
INSERT INTO azb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","O dedi: «Mən İbrahimin nökəriyəm. ");
INSERT INTO azb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Rəbb ağama çoxlu xeyir-dua verdi: onu varlandırdı, ona qoyun-keçi, mal-qara, qızıl-gümüş, qullar, qarabaşlar, dəvələr və eşşəklər verdi. ");
INSERT INTO azb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ağamın arvadı Sara da qoca ikən ağama bir oğul doğdu. Ağam özünə məxsus olan hər şeyi ona verdi. ");
INSERT INTO azb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Sonra da məni and içdirərək dedi: “Ölkələrində yaşadığım Kənanlıların qızlarından oğluma arvad alma, ");
INSERT INTO azb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ancaq atamın evinə – qohumlarımın yanına gedib oradan oğluma bir arvad al”. ");
INSERT INTO azb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mən ağama dedim: “Bəlkə o qadın mənimlə gəlmədi”. ");
INSERT INTO azb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","O mənə dedi: “Önündə davrandığım Rəbb səninlə Öz mələyini göndərəcək, yolun uğurlu olacaq və qohumlarımın arasından – atamın evindən oğluma bir arvad alacaqsan. ");
INSERT INTO azb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Qohumlarımın yanına getdiyin zaman içdiyin anddan azad olacaqsan: əgər o qızı sənə verməsələr, içdiyin anddan azad olacaqsan”. ");
INSERT INTO azb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Mən də bu gün bulağın yanına gəlib dua etdim: “Ey ağam İbrahimin Allahı Rəbb, yalvarıram, getdiyim yolu aç. ");
INSERT INTO azb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","İndi mən bulağın yanında dururam; su çəkməyə gələn və mənim ona ‹xahiş edirəm, mənə səhəngindən bir az su ver, içim› deyəcəyim, ");
INSERT INTO azb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","onun da mənə ‹sən də iç, dəvələrinə də gedib su çəkim› söyləyəcək qız ağamın oğlu üçün Rəbbin təyin etdiyi arvad olsun”. ");
INSERT INTO azb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mən ürəyimdə dua etməyi qurtarmamışdım ki, Rivqa səhəngi çiynində gəldi və bulağa enib su çəkdi. Ona dedim: “Xahiş edirəm, mənə su ver”. ");
INSERT INTO azb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","O tez səhəngini çiynindən endirib dedi: “Sən iç, gedim dəvələrinə də su verim”. Mən içdim, o isə dəvələrə su verdi. ");
INSERT INTO azb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ondan soruşdum: “Sən kimin qızısan?” O dedi: “Milkanın Naxora doğduğu Betuelin qızıyam”. Mən də onun burnuna halqa və qollarına bilərziklər taxdım. ");
INSERT INTO azb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Sonra əyilib Rəbbə səcdə etdim. Ağamın qardaşı qızını oğluna almaq üçün məni birbaş buraya gətirən ağam İbrahimin Allahı Rəbbə şükür etdim. ");
INSERT INTO azb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","İndi mənə deyin görüm, siz ağama xeyirxahlıq və sədaqət göstərmək istəyirsiniz ya yox? Bunu mənə bildirin ki, mən də nə edəcəyimi bilim». ");
INSERT INTO azb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lavan və Betuel ona belə cavab verdilər: «Bu iş Rəbdən oldu; sənə nə yaxşı, nə də pis söz deyə bilərik. ");
INSERT INTO azb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Bax Rivqa qarşındadır: onu götürüb get və qoy o, Rəbbin söylədiyi kimi ağanın oğluna arvad olsun». ");
INSERT INTO azb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","İbrahimin nökəri onların sözlərini eşidəndə yerə qapanıb Rəbbə səcdə etdi. ");
INSERT INTO azb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Nökər qızıl-gümüş şeylər və paltarlar çıxarıb Rivqaya verdi. Onun qardaşına və anasına da qiymətli şeylər bağışladı. ");
INSERT INTO azb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Özü və onunla birgə olan adamlar yeyib-içdilər və orada gecələdilər. Səhər qalxanda nökər dedi: «Məni ağamın yanına göndərin». ");
INSERT INTO azb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Qızın qardaşı ilə anası dedilər: «Qoy qız bizimlə heç olmasa on gün qalsın, sonra gedər». ");
INSERT INTO azb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Nökər onlara dedi: «İndi ki Rəbb mənə yol açdı, məni gecikdirməyin, buraxın ağamın yanına gedim». ");
INSERT INTO azb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Onlar dedilər: «Qoy qızı çağırıb öz dilindən eşidək». ");
INSERT INTO azb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rivqanı çağırıb ona dedilər: «Bu adamla gedirsənmi?» O da «gedirəm» dedi. ");
INSERT INTO azb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Onlar bacıları Rivqanı, onun dayəsini, İbrahimin nökərini və onunla olan adamları yola saldılar. ");
INSERT INTO azb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rivqaya xeyir-dua verib dedilər: «Ey bacımız, Minlərlə, on minlərlə övlada ana olasan! Qoy nəslin yağıların yurduna sahib olsun!» ");
INSERT INTO azb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rivqa və qulluqçuları qalxıb dəvələrə mindilər və o adamla birgə getdilər. Beləliklə, nökər Rivqanı götürüb getdi. ");
INSERT INTO azb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","İshaq Beer-Laxay-Roi yolu ilə gəldi, çünki o, Negev torpağında yaşayırdı. ");
INSERT INTO azb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Axşam düşəndə İshaq bir qədər düşünmək üçün çöllüyə getdi. O, başını qaldırıb baxanda gördü ki, dəvələr gəlir. ");
INSERT INTO azb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rivqa da başını qaldırıb İshaqı görəndə dəvədən düşdü. ");
INSERT INTO azb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","O, nökərdən soruşdu: «Bizi qarşılamaq üçün çöllüyə gələn bu adam kimdir?» Nökər «ağamdır» dedi. Rivqa rübəndini üzünə çəkib örtündü. ");
INSERT INTO azb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nökər baş vermiş bütün işlər barədə İshaqa danışdı. ");
INSERT INTO azb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","İshaq Rivqanı anası Saranın yaşadığı çadıra apardı və Rivqa onun arvadı oldu. İshaq onu sevdi və anasının ölümündən sonra onunla təsəlli tapdı. ");
INSERT INTO azb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","İbrahim başqa bir arvad aldı. Onun adı Qetura idi. ");
INSERT INTO azb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Qetura ona bunları doğdu: Zimran, Yoqşan, Medan, Midyan, İşbaq və Şuah. ");
INSERT INTO azb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoqşandan Səba və Dedan törədi. Dedanın nəsilləri: Aşşurlular, Letuşlular, Leumlular. ");
INSERT INTO azb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midyanın oğulları: Efa, Efer, Xanok, Avida və Eldaa. Bunların hamısı Qeturanın övladlarıdır. ");
INSERT INTO azb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","İbrahim özünə məxsus olan hər şeyi İshaqa verdi. ");
INSERT INTO azb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Cariyələrinin oğullarına isə hədiyyələr verdi. Sağlığında onları oğlu İshaqın yanından şərq torpağına tərəf göndərdi. ");
INSERT INTO azb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","İbrahim yüz yetmiş beş il ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","O, uzun ömür sürdü, qoca vaxtında son nəfəsini verərək ölüb əcdadlarına qoşuldu. ");
INSERT INTO azb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Oğulları İshaq və İsmail onu Mamre qarşısında olan Maxpela mağarasında, Xetli Sohar oğlu Efronun tarlasında basdırdılar. ");
INSERT INTO azb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","O tarlanı İbrahim Xetlilərdən satın almışdı. İbrahim və arvadı Sara orada basdırıldı. ");
INSERT INTO azb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Allah İbrahimin ölümündən sonra oğlu İshaqa xeyir-dua verdi. İshaq Beer-Laxay-Roidə yaşayırdı. ");
INSERT INTO azb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saranın qarabaşı Misirli Həcərin İbrahimə doğduğu İsmailin nəsil tarixçəsi belədir. ");
INSERT INTO azb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Doğulma sırasına görə İsmailin oğullarının adları belədir: İsmailin ilk oğlu Nevayot, Qedar, Adbeel, Mivsam, ");
INSERT INTO azb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mişma, Duma, Massa, ");
INSERT INTO azb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Xadad, Tema, Yetur, Nafiş və Qedma; ");
INSERT INTO azb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","İsmailin oğulları bunlardır, kəndləri və obaları ilə birgə onların adları belədir. Onlar öz tayfalarının on iki başçısı idi. ");
INSERT INTO azb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","İsmail yüz otuz yeddi il ömür sürdü. O, ömrünü başa vurdu və ölüb əcdadlarına qoşuldu. ");
INSERT INTO azb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","İsmailin nəsilləri Xaviladan Şura qədər olan ərazidə məskən saldı. Şur Aşşura gedərkən Misirin qarşısındadır. Onlar qardaşlarının yaşadığı yerin qarşısında yerləşmişdi. ");
INSERT INTO azb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","İbrahimin oğlu İshaqın tarixçəsi belədir: İbrahimdən İshaq törədi. ");
INSERT INTO azb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","İshaq Paddan-Aramdan Aramlı Lavanın bacısı, Aramlı Betuelin qızı Rivqanı arvad alanda qırx yaşında idi. ");
INSERT INTO azb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","İshaq arvadı üçün Rəbbə yalvardı, çünki o, sonsuz idi. Rəbb İshaqın yalvarışını eşitdi, onun arvadı Rivqa hamilə oldu. ");
INSERT INTO azb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rivqanın bətnindəki uşaqlar çarpışmağa başladı. O da «Niyə bu iş başıma gəldi?» deyib bu barədə Rəbdən soruşmağa getdi. ");
INSERT INTO azb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Rəbb ona dedi: «Sənin bətnində iki millət var, Sənin qarnından iki xalq çıxacaq. Bir xalq o biri xalqdan güclü olacaq, Böyüyü kiçiyinə qulluq edəcək». ");
INSERT INTO azb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rivqanın doğmaq vaxtı çatanda məlum oldu ki, onun bətnində əkizlər var. ");
INSERT INTO azb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","İlk doğulan uşağın bütün dərisi qırmızı və tüklü cübbə kimi idi. Onda onun adını Esav qoydular. ");
INSERT INTO azb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ondan sonra qardaşı doğuldu. O, əli ilə Esavın topuğundan tutmuşdu. Onun adını Yaqub qoydular. Onların doğulduğu vaxt İshaq altmış yaşında idi. ");
INSERT INTO azb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Uşaqlar böyüdü. Esav mahir ovçu və çöl adamı oldu. Yaqub isə çadırlarda yaşayan mülayim bir adam oldu. ");
INSERT INTO azb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","İshaq Esavı sevirdi, çünki onun ovladığı heyvanlar İshaqın xoşuna gəlirdi. Rivqa isə Yaqubu sevirdi. ");
INSERT INTO azb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Bir gün Yaqub şorba bişirirdi. Esav isə çöldən yorğun gəldi. ");
INSERT INTO azb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esav Yaquba dedi: «Bu qırmızı şorbadan bir az ver, yeyim, çünki acmışam». Buna görə də ona Edom adı verildi. ");
INSERT INTO azb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaqub dedi: «Əvvəlcə ilk oğulluq haqqını mənə sat». ");
INSERT INTO azb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esav dedi: «Bir halda ki mən acından ölürəm, ilk oğulluq haqqı nəyimə lazımdır?» ");
INSERT INTO azb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaqub dedi: «Əvvəlcə mənə and iç». Esav ona and içdi və ilk oğulluq haqqını Yaquba satdı. ");
INSERT INTO azb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yaqub Esava çörək və mərci şorbası verdi. Esav yeyib-içdi, sonra qalxıb getdi. Beləcə Esav ilk oğulluq haqqına etinasızlıq etdi. ");
INSERT INTO azb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","İbrahimin yaşadığı dövrdə olan aclıqdan başqa, ölkədə daha bir aclıq oldu. İshaq Gerara, Filiştlilərin padşahı Avimelekin yanına getdi. ");
INSERT INTO azb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Rəbb ona görünüb dedi: «Misirə getmə, sənə söylədiyim ölkədə məskən sal, ");
INSERT INTO azb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","bu torpaqda qal. Mən səninlə olacağam və sənə xeyir-dua verib bütün bu ölkələri sənə və nəslinə verəcəyəm; atan İbrahimə içdiyim andı yerinə yetirəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nəslini göydəki ulduzlar qədər çoxaldacağam və bütün bu ölkələri nəslinə verəcəyəm. Yer üzünün bütün millətləri sənin nəslinin vasitəsilə xeyir-dua alacaq. ");
INSERT INTO azb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Çünki İbrahim sözümə qulaq asıb Mənim buyruğuma, əmrlərimə, qaydalarıma və qanunlarıma əməl etdi». ");
INSERT INTO azb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","İshaq da Gerarda yaşadı. ");
INSERT INTO azb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","O ölkənin sakinləri İshaqın arvadı barədə soruşanda «bu mənim bacımdır» dedi, çünki «mənim arvadımdır» deməyə qorxdu. Öz-özünə dedi: «Yoxsa Rivqadan ötrü bu yerin adamları məni öldürərlər». Rivqa görünüşcə çox gözəl idi. ");
INSERT INTO azb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","İshaq orada uzun müddət qaldı. Bir gün Filiştlilərin padşahı Avimelek pəncərədən baxıb gördü ki, İshaq arvadı Rivqanı əzizləyir. ");
INSERT INTO azb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Avimelek İshaqı çağırıb dedi: «O ki sənin arvadındır. Bəs niyə onun barəsində “bu mənim bacımdır” dedin?» İshaq ona dedi: «Çünki istəmədim ki, ondan ötrü ölüm». ");
INSERT INTO azb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Avimelek dedi: «Bu nə işdir başımıza gətirdin? Az qalmışdı ki, xalqdan biri sənin arvadınla yatsın. Beləcə bizi günaha batıracaqdın». ");
INSERT INTO azb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Sonra Avimelek «bu adama və onun arvadına toxunan mütləq öldürüləcək» deyə bütün xalqa elan etdi. ");
INSERT INTO azb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","İshaq o torpaqda toxum əkdi və o il yüz qat məhsul aldı. Beləcə Rəbb ona xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Bu şəxs böyük adam oldu. Çox böyük adam olana qədər get-gedə yüksəldi. ");
INSERT INTO azb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Onun çoxlu qoyun-keçisi, mal-qarası və xidmətçiləri olduğuna görə Filiştlilər ona paxıllıq etməyə başladı. ");
INSERT INTO azb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Atası İbrahimin dövründə atasının qullarının qazdığı bütün quyuları Filiştlilər qapayıb torpaqla doldurmuşdular. ");
INSERT INTO azb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Avimelek İshaqa dedi: «Yanımızdan get, çünki bizdən çox güclü oldun». ");
INSERT INTO azb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","İshaq oradan getdi, Gerar vadisində məskən saldı və orada qaldı. ");
INSERT INTO azb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","İshaq atası İbrahimin dövründə qazılmış su quyularını yenə qazdı, çünki Filiştlilər İbrahimin ölümündən sonra onları qapamışdılar. O, atasının qoyduğu adları yenə onlara verdi. ");
INSERT INTO azb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","İshaqın qulları vadidə torpağı qazdılar və bir içməli su quyusu tapdılar. ");
INSERT INTO azb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerar çobanları «su bizimdir» deyib İshaqın çobanları ilə mübahisə etdilər. O, quyunun adını Eseq qoydu, çünki onun üstündə mübahisə etmişdilər. ");
INSERT INTO azb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Onlar başqa bir quyu qazdılar. Onun üçün də mübahisə etdilər. İshaq bu quyunun adını Sitna qoydu. ");
INSERT INTO azb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","İshaq oradan köçüb başqa bir quyu qazdı. Ancaq onun üçün mübahisə etmədilər, buna görə də İshaq onun adını Rexovot qoyub dedi: «İndi Rəbb bizə genişlik verdi və biz bu torpaqda çoxalacağıq». ");
INSERT INTO azb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","İshaq oradan Beer-Şevaya getdi. ");
INSERT INTO azb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","O gecə Rəbb ona görünüb dedi: «Mən atan İbrahimin Allahıyam. Qorxma, çünki Mən səninləyəm. Qulum İbrahimə görə sənə xeyir-dua verəcəyəm və nəslini çoxaldacağam». ");
INSERT INTO azb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","İshaq orada bir qurbangah düzəltdi və Rəbbin adını çağırdı. O özünə çadır qurdu. İshaqın qulları orada bir quyu qazdılar. ");
INSERT INTO azb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","O zaman Avimelek məsləhətçisi Axuzzat, ordu başçısı Pikol ilə birgə Gerardan İshaqın yaşadığı torpağa gəldi. ");
INSERT INTO azb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","İshaq onlara dedi: «Nə üçün yanıma gəlmisiniz? Sizin ki məndən acığınız gəlirdi və məni yanınızdan qovdunuz». ");
INSERT INTO azb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Onlar dedilər: «Biz aydın gördük ki, Rəbb, doğrudan da, səninlədir. İndi istəyirik ki, səninlə bizim aramızda and olsun. Gəl səninlə əhd bağlayaq ki, ");
INSERT INTO azb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","biz sənə toxunmadığımız və yalnız yaxşılıq edib sağ-salamat yola saldığımız kimi sən də bizə heç bir pislik etməyəcəksən. İndi sən Rəbbin xeyir-dua verdiyi adamsan». ");
INSERT INTO azb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","İshaq onlara ziyafət verdi və onlar yeyib-içdilər. ");
INSERT INTO azb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Səhər tezdən qalxıb bir-birlərinə and içdilər. İshaq onları yola saldı və onlar sağ-salamat onun yanından getdilər. ");
INSERT INTO azb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","O gün İshaqın qulları gəldilər və qazdıqları quyu barədə ona bildirərək «su tapdıq» dedilər. ");
INSERT INTO azb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","İshaq bu quyunun adını Şiva qoydu, buna görə də şəhərin adı bu günə qədər Beer-Şevadır. ");
INSERT INTO azb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esav qırx yaşında olanda Xetli Beerinin qızı Yehuditi və Xetli Elonun qızı Basmatı arvad aldı. ");
INSERT INTO azb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Onlar İshaqın və Rivqanın ürəklərinə dərd oldu. ");
INSERT INTO azb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","İshaq qocalıb gözləri görməyəndə böyük oğlu Esavı yanına çağırıb dedi: «Ay oğlum». Esav ona «mən buradayam» dedi. ");
INSERT INTO azb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","İshaq dedi: «Mən artıq qocalmışam, bu gün-sabah öləcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","İndi silahını, yayını və oxdanını götür, çöllüyə get və mənim üçün heyvan ovla. ");
INSERT INTO azb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Sonra da mənə xoşladığım ləzzətli yeməyi hazırla və gətir ki, yeyim. Onda ölməmişdən qabaq mən sənə xeyir-dua verərəm». ");
INSERT INTO azb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","İshaq oğlu Esavla danışarkən Rivqa eşidirdi. Esav heyvan ovlayıb gətirmək üçün çöllüyə getdi. ");
INSERT INTO azb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rivqa oğlu Yaquba belə dedi: «Bax mən eşitdim ki, atan qardaşın Esava bu sözləri dedi: ");
INSERT INTO azb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Mənim üçün ov əti gətir, mənə ləzzətli yemək hazırla ki, yeyim. Sonra sənə ölümümdən qabaq Rəbbin hüzurunda xeyir-dua verərəm”. ");
INSERT INTO azb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Oğlum, indi sənə əmr edəcəyim sözlərə qulaq as: ");
INSERT INTO azb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","bu saat sürüyə gedib oradan mənə iki yaxşı oğlaq gətir. Onlardan atanın xoşladığı kimi ləzzətli yemək hazırlayacağam. ");
INSERT INTO azb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sən də onu yeməsi üçün atana aparacaqsan ki, ölümündən qabaq sənə xeyir-dua versin». ");
INSERT INTO azb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaqub anası Rivqaya dedi: «Qardaşım Esav tüklü bir adamdır, mən isə tüksüzəm. ");
INSERT INTO azb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Birdən atam mənə əlini sürtər və mən onun nəzərində yalançı olaram. Onda üzərimə xeyir-dua yox, lənət gətirərəm». ");
INSERT INTO azb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Anası ona dedi: «Sənə olunacaq lənət mənə gəlsin, oğlum. Ancaq sözümə qulaq as: get, dediyim şeyi mənə gətir». ");
INSERT INTO azb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yaqub gedib oğlaqları götürdü və anasına gətirdi, anası da onun atasının xoşladığı kimi ləzzətli yemək hazırladı. ");
INSERT INTO azb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rivqa böyük oğlu Esavın evdə saxladığı ən gözəl paltarını götürüb kiçik oğlu Yaquba geyindirdi. ");
INSERT INTO azb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Onun əllərinə və boynunun tüksüz yerinə oğlaq dəriləri bağladı. ");
INSERT INTO azb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Sonra hazırladığı ləzzətli yeməyi və çörəyi oğlu Yaqubun əlinə verdi. ");
INSERT INTO azb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaqub atasının yanına gəlib dedi: «Ay ata». Atası dedi: «Mən buradayam. Sən kimsən, oğlum?» ");
INSERT INTO azb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaqub atasına dedi: «Sənin ilk oğlun Esavam. Dediyin kimi elədim. Qalx otur və gətirdiyim ov ətindən ye ki, mənə xeyir-dua verəsən». ");
INSERT INTO azb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","İshaq oğluna dedi: «Necə oldu ki, belə tez ov tapdın, oğlum?» O dedi: «Sənin Allahın Rəbb mənə uğur verdi». ");
INSERT INTO azb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","İshaq Yaquba dedi: «Yaxın gəl, oğlum, əlimi sənə sürtüb bilim ki, doğrudanmı, oğlum Esavsan ya yox?» ");
INSERT INTO azb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaqub atası İshaqa yaxınlaşdı. İshaq əlini ona sürtüb dedi: «Səs Yaqubun səsidir, ancaq əllər Esavın əlləridir». ");
INSERT INTO azb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","İshaq onu tanımadı, çünki onun əlləri qardaşı Esavın əlləri kimi tüklü idi. İshaq Yaquba xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","O soruşdu: «Doğrudanmı, sən oğlum Esavsan?» Yaqub dedi: «Bəli». ");
INSERT INTO azb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","İshaq dedi: «Oğlum, gətirdiyin ov ətini qabağıma qoy, yeyim, sonra da sənə xeyir-dua verərəm». Yaqub yeməyi onun qabağına qoydu və o yedi, Yaqub ona şərab gətirdi və o içdi. ");
INSERT INTO azb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Atası İshaq Yaquba dedi: «Oğlum, indi yaxınlaş, atanı öp». ");
INSERT INTO azb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","O yaxınlaşıb atasını öpdü. İshaq onun paltarının qoxusunu hiss etdi və ona xeyir-dua verib dedi: «Bax oğlumun qoxusu Rəbbin xeyir-dua verdiyi Çölün qoxusu kimidir. ");
INSERT INTO azb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Allah sənə göylərin şehini, Torpağın şirəsini, Bol buğda və çoxlu təzə şərab versin. ");
INSERT INTO azb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Xalqlar sənə qulluq etsin, Ümmətlər sənə baş əysin. Öz qardaşlarına ağa ol, Ananın oğulları sənə baş əysin. Sənə lənət edənlərə lənət gəlsin, Sənə xeyir-dua verənlər xeyir-dua alsın». ");
INSERT INTO azb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","İshaq Yaquba xeyir-dua verib qurtarandan sonra Yaqub atası İshaqın yanından çıxar-çıxmaz qardaşı Esav ovdan qayıtdı. ");
INSERT INTO azb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esav da ləzzətli yemək hazırlayıb atasına gətirdi və ona dedi: «Atam qalxıb oğlunun gətirdiyi ov ətindən yesin və mənə xeyir-dua versin». ");
INSERT INTO azb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Atası İshaq ondan soruşdu: «Sən kimsən?» O cavab verdi: «Mən ilk oğlun Esavam». ");
INSERT INTO azb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","İshaqın canına bərk titrətmə düşdü və o dedi: «Bəs onda heyvan ovlayıb mənə gətirən kim idi? Sən gəlməmişdən qabaq hər şeydən yedim və ona xeyir-dua verdim. Xeyir-dua da onunku oldu». ");
INSERT INTO azb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esav atasının sözlərini eşidəndə ucadan və acı səslə fəryad edib dedi: «Ay ata, mənə də xeyir-dua ver». ");
INSERT INTO azb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","İshaq dedi: «Qardaşın hiylə ilə gəlib sənin xeyir-duanı aldı». ");
INSERT INTO azb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esav dedi: «Onu nahaq yerə Yaqub çağırmırlar ki? Bununla ikinci dəfədir ki, məni aldadır: əvvəl ilk oğulluq haqqımı, indi də xeyir-duamı aldı». Sonra soruşdu: «Bəs mənə xeyir-dua saxlamamısan?» ");
INSERT INTO azb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","İshaq Esava cavab verdi: «Onu sənə ağa etdim, bütün qardaşlarını ona qul olaraq verdim, buğda və təzə şərabla onu təmin etdim. Bəs sənə nə edim, oğlum?» ");
INSERT INTO azb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esav atasına dedi: «Səndə yalnız bir xeyir-dua varmı, ata? Mənə də xeyir-dua ver, ata». Esav hönkürüb ağladı. ");
INSERT INTO azb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Atası İshaq ona belə cavab verdi: «Yaşadığın yer torpağın şirəsindən, Yuxarıda göylərin şehindən uzaq olacaq. ");
INSERT INTO azb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Qılıncınla yaşayıb Qardaşına qulluq edəcəksən. Amma azad olmaq istəyəndə Onun boyunduruğunu Boynundan qırıb atacaqsan». ");
INSERT INTO azb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Atası Yaquba xeyir-dua verdiyinə görə Esav qardaşına nifrət etdi. O öz-özünə dedi: «Atamın matəm günləri yaxınlaşır. O zaman qardaşım Yaqubu öldürərəm». ");
INSERT INTO azb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Böyük oğlu Esavın dediyi sözlər Rivqanın qulağına çatdı. Buna görə də xəbər göndərib kiçik oğlu Yaqubu çağırdı və ona dedi: «Bax qardaşın Esav səni öldürməklə qisas almaq istəyir. ");
INSERT INTO azb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Oğlum, indi sözümə qulaq as: qalxıb Xarana, qardaşım Lavanın yanına qaç. ");
INSERT INTO azb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Qardaşının hirsi soyuyana qədər bir müddət Lavanın yanında qal. ");
INSERT INTO azb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Sənə qarşı qəzəbi sönəndə, ona elədiyini unudanda xəbər göndərib səni oradan çağıraram. Nə üçün bir gündə ikinizdən də məhrum olum?» ");
INSERT INTO azb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sonra Rivqa İshaqa dedi: «Xetli qızların əlindən həyatımdan bezdim. Əgər Yaqub da beləcə bu ölkənin qızlarından – Xetli qızlardan özünə arvad alsa, daha mən niyə yaşayıram?» ");
INSERT INTO azb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","İshaq Yaqubu çağırıb ona xeyir-dua verdi və xəbərdarlıq edərək dedi: «Kənan qızlarından arvad alma. ");
INSERT INTO azb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Qalxıb Paddan-Arama, ana baban Betuelin evinə get. Oradan dayın Lavanın qızlarından özünə arvad al. ");
INSERT INTO azb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Külli-İxtiyar Allah sənə xeyir-dua versin, səni bəhərli edib nəslini çoxaltsın, səndən çoxlu xalq törəsin; ");
INSERT INTO azb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","İbrahimin xeyir-duasını sənə və səninlə birgə nəslinə versin ki, Allahın İbrahimə verdiyi torpağı – qərib kimi yaşadığın torpağı irs olaraq alasan». ");
INSERT INTO azb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","İshaq Yaqubu yola saldı. O, Paddan-Arama, Yaqubla Esavın anası Rivqanın qardaşı Aramlı Betuel oğlu Lavanın yanına getdi. ");
INSERT INTO azb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esav gördü ki, İshaq Yaquba xeyir-dua verdi və özünə arvad almaq üçün onu Paddan-Arama göndərdi; həm də ona xeyir-dua verən zaman «Kənan qızlarından arvad alma» deyib xəbərdarlıq etdi. ");
INSERT INTO azb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaqub da ata-anasına qulaq asıb Paddan-Arama getdi. ");
INSERT INTO azb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esav gördü ki, Kənan qızları atası İshaqın xoşuna gəlmir. ");
INSERT INTO azb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esav İsmailin yanına getdi. O, İbrahim oğlu İsmailin qızı Maxalatı arvadlarının üstünə arvad aldı. Maxalat Nevayotun bacısı idi. ");
INSERT INTO azb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaqub Beer-Şevadan çıxıb Xarana tərəf getdi. ");
INSERT INTO azb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Bir yerə çatıb orada gecələdi, çünki günəş batmışdı. O torpaqdan bir daş götürüb başının altına qoydu və orada yatdı. ");
INSERT INTO azb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","O, yuxuda gördü ki, yerin üzərində bir nərdivan durmuş və onun başı göylərə çatmışdır. Allahın mələkləri onunla çıxıb-düşürdülər. ");
INSERT INTO azb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Rəbb nərdivanın üstündə durub deyirdi: «Mən baban İbrahimin və İshaqın Allahı Rəbbəm. Üstündə yatdığın torpağı sənə və nəslinə verəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Sənin nəslin yerin tozu kimi çox olacaq, qərbə, şərqə, şimala və cənuba yayılacaq. Yer üzünün bütün tayfaları sənin və nəslinin vasitəsilə xeyir-dua alacaq. ");
INSERT INTO azb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mən həmişə səninləyəm, gedəcəyin hər yerdə səni qoruyacağam və bu torpağa qaytaracağam. Dediyimi edənə qədər səni tərk etməyəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaqub yuxusundan oyanıb dedi: «Doğrudan da, Rəbb buradadır. Mən isə bunu bilmirdim». ");
INSERT INTO azb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Sonra qorxub dedi: «Bu yer necə də qorxuludur. Bu, Allahın evindən başqa bir şey ola bilməz, bura göylərin qapısıdır». ");
INSERT INTO azb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaqub səhər tezdən qalxdı. O, başının altına qoyduğu daşı götürüb sütun kimi qoydu və üstünə zeytun yağı tökdü. ");
INSERT INTO azb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","O yerin adını Bet-El qoydu, ancaq əvvəlcə şəhərin adı Luz idi. ");
INSERT INTO azb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yaqub əhd edib dedi: «Əgər Allah mənimlə olsa, getdiyim bu yolda məni qorusa, mənə yemək üçün çörək və geymək üçün paltar versə, ");
INSERT INTO azb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sağ-salamat atamın evinə dönsəm, o zaman Rəbb mənə Allah olacaq. ");
INSERT INTO azb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Sütun kimi qoyduğum bu daş da Allahın evi olacaq. Ay Allah, mənə verəcəyin hər şeyin onda birini Sənə verəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yaqub yoluna davam edərək şərq xalqlarının torpağına getdi. ");
INSERT INTO azb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","O gördü ki, çöllükdə bir quyu var və onun yanında üç qoyun sürüsü yatıb, çünki quyudan o sürülərə su verirdilər. Quyunun ağzında böyük bir daş var idi. ");
INSERT INTO azb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bütün sürülər oraya yığılırdı. Adamlar daşı quyunun ağzından yuvarlayıb qoyunlara su verir və yenə daşı yerinə – quyunun üstünə qoyurdular. ");
INSERT INTO azb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaqub onlardan soruşdu: «Ey qardaşlar, haradansınız?» Onlar dedilər: «Biz Xarandanıq». ");
INSERT INTO azb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yaqub onlara dedi: «Naxorun nəvəsi Lavanı tanıyırsınızmı?» Onlar dedilər: «Tanıyırıq». ");
INSERT INTO azb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaqub onlardan soruşdu: «O, sağ-salamatdırmı?» Onlar dedilər: «Bəli, sağ-salamatdır. Odur, qızı Rəhilə də qoyunlarla gəlir». ");
INSERT INTO azb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaqub dedi: «Hələ axşama çox vaxt var, sürülərin yığılma vaxtı deyil. Qoyunlara su verin, sonra aparıb otarın». ");
INSERT INTO azb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Onlar dedilər: «Bütün sürülər yığılmayınca və daş quyunun ağzından yuvarlanmayınca bunu edə bilmərik, yalnız onda qoyunlara su verə bilərik». ");
INSERT INTO azb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yaqub onlarla danışarkən Rəhilə atasının qoyunları ilə gəldi, çünki o, çoban idi. ");
INSERT INTO azb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaqub dayısı Lavanın qızı Rəhiləni və dayısı Lavanın qoyunlarını görəndə yaxınlaşıb daşı quyunun ağzından yuvarladı və dayısı Lavanın qoyunlarına su verdi. ");
INSERT INTO azb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yaqub Rəhiləni öpdü və hönkürtü ilə ağladı. ");
INSERT INTO azb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yaqub atasının qohumlarından və Rivqanın oğlu olduğunu Rəhiləyə bildirdi. Rəhilə də qaçıb atasına danışdı. ");
INSERT INTO azb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lavan bacısı oğlu Yaqubun gəldiyini eşidəndə onu qarşılamağa qaçdı. Onu qucaqlayıb öpdü və evinə gətirdi. Yaqub hər şeyi Lavana danışdı. ");
INSERT INTO azb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lavan ona dedi: «Sən, doğrudan da, mənim sümüyümdən, mənim ətimdənsən». Yaqub onun yanında bir ay qaldı. ");
INSERT INTO azb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lavan Yaquba dedi: «Məgər qohum olduğun üçün mənə havayı xidmət edəcəksən? Mənə söylə, haqqın nə olsun?» ");
INSERT INTO azb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lavanın iki qızı var idi: böyüyünün adı Lea, kiçiyininki Rəhilə idi. ");
INSERT INTO azb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leanın gözləri zəif görürdü, Rəhilə isə çox gözəl və qamətli idi. ");
INSERT INTO azb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaqub Rəhiləyə vuruldu və dedi: «Kiçik qızın Rəhilə üçün sənə yeddi il xidmət edərəm». ");
INSERT INTO azb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lavan dedi: «Onu sənə vermək başqa adama verməkdən daha yaxşıdır. Yanımda qal». ");
INSERT INTO azb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yaqub Rəhiləyə görə yeddi il xidmət etdi. Onu sevdiyi üçün bu müddət gözünə bir neçə gün kimi göründü. ");
INSERT INTO azb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yaqub Lavana dedi: «Vaxtım çatdı; indi arvadımı mənə ver ki, onun yanına girim». ");
INSERT INTO azb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lavan o torpağın bütün adamlarını topladı və bir ziyafət verdi. ");
INSERT INTO azb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Gecə qızı Leanı götürüb Yaqubun yanına apardı. Yaqub onun yanına girdi. ");
INSERT INTO azb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lavan öz qarabaşı Zilpanı Leaya qulluqçu olmaq üçün verdi. ");
INSERT INTO azb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Səhər məlum oldu ki, bu, Leadır. Yaqub Lavana dedi: «Nə üçün mənimlə belə rəftar etdin? Sənin yanında Rəhilə üçün xidmət etmədimmi? Bəs məni niyə aldatdın?» ");
INSERT INTO azb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lavan dedi: «Bizim yerdə kiçik qızı böyüyündən əvvəl ərə vermək olmaz. ");
INSERT INTO azb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Bu həftəni bitir, onu da sənə verərik. Onun üçün də yanımda daha yeddi il xidmət etməlisən». ");
INSERT INTO azb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaqub belə də etdi: o həftəni bitirdi. Lavan da qızı Rəhiləni ona arvad olmaq üçün verdi. ");
INSERT INTO azb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Öz qarabaşı Bilhanı da qızı Rəhiləyə qulluqçu olmaq üçün verdi. ");
INSERT INTO azb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaqub Rəhilənin də yanına girdi. Rəhiləni Leadan da çox sevdi. O, Lavanın yanında daha yeddi il xidmət etdi. ");
INSERT INTO azb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Rəbb Leanın sevilmədiyini görüb onun bətnini açdı. Rəhilə isə sonsuz idi. ");
INSERT INTO azb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea hamilə olub bir oğul doğdu və onun adını Ruven qoyaraq dedi: «Yəqin Rəbb mənim fağırlığımı gördü. İndi ərim məni sevəcək». ");
INSERT INTO azb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","O yenə hamilə olub bir oğul doğdu və dedi: «Rəbb sevilmədiyimi eşidib mənə bunu da verdi». Onun da adını Şimeon qoydu. ");
INSERT INTO azb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea yenə hamilə olub bir oğul doğdu və dedi: «İndi bu dəfə ərim mənə bağlanacaq, çünki ona üç oğul doğdum». Buna görə də adını Levi qoydu. ");
INSERT INTO azb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","O yenə hamilə olub bir oğul doğdu və dedi: «Bu dəfə Rəbbi mədh edəcəyəm». Buna görə də onun adını Yəhuda qoydu. Sonra o, bir müddət doğmadı. ");
INSERT INTO azb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rəhilə Yaquba uşaq doğmadığını görəndə bacısına həsəd apardı və ərinə dedi: «Mənə uşaq ver, yoxsa ölərəm». ");
INSERT INTO azb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaqubun Rəhiləyə qəzəbi alovlandı və o dedi: «Məgər mən sənin bətninə bəhər verməyən Allaham?» ");
INSERT INTO azb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rəhilə dedi: «Qarabaşım Bilhanı götür və yanına gir. Qoy o, dizlərimin üstünə bir uşaq doğsun və ondan uşaqlarım olsun». ");
INSERT INTO azb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rəhilə qarabaşı Bilhanı ona arvad olmaq üçün verdi və Yaqub onun yanına girdi. ");
INSERT INTO azb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha hamilə olub Yaquba bir oğul doğdu. ");
INSERT INTO azb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rəhilə dedi: «Allah məni haqlı çıxartdı və səsimi eşidib mənə bir oğul verdi». Buna görə də onun adını Dan qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rəhilənin qarabaşı Bilha yenə hamilə olub Yaquba ikinci oğul doğdu. ");
INSERT INTO azb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rəhilə dedi: «Bacımla güclü mübarizəyə girişib ona üstün gəldim». O, uşağın adını Naftali qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea daha doğmadığına görə qarabaşı Zilpanı götürüb Yaquba arvad olmaq üçün verdi. ");
INSERT INTO azb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Leanın qarabaşı Zilpa Yaquba bir oğul doğdu. ");
INSERT INTO azb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea «uğur qazandım» deyib onun adını Qad qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leanın qarabaşı Zilpa Yaquba ikinci oğul doğdu. ");
INSERT INTO azb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea dedi: «Xoşbəxtəm, çünki qadınlar məni bəxtiyar sayacaqlar». O, uşağın adını Aşer qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruven buğda biçini vaxtı gedib tarlada məhəbbət otları tapdı və onları anası Leaya gətirdi. Rəhilə Leaya dedi: «Oğlunun məhəbbət otlarından mənə də ver». ");
INSERT INTO azb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea ona dedi: «Ərimi əlimdən aldığın bəs deyilmi? İndi də oğlumun məhəbbət otlarını almaq istəyirsən?» Rəhilə dedi: «Elə isə qoy ərim oğlunun məhəbbət otlarının əvəzində bu gecə səninlə yatsın». ");
INSERT INTO azb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yaqub axşam çöldən gələndə Lea onu qarşılamağa çıxıb dedi: «Mənim yanıma gir, çünki səni oğlumun məhəbbət otları ilə satın almışam». Yaqub o gecə onunla yatdı. ");
INSERT INTO azb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Allah Leanı eşitdi və o hamilə olub Yaquba beşinci oğlunu doğdu. ");
INSERT INTO azb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea dedi: «Allah haqqımı verdi, çünki qulluqçumu ərimə verdim». O, uşağın adını İssakar qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea yenə hamilə olub Yaquba altıncı oğlunu doğdu. ");
INSERT INTO azb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","O dedi: «Allah mənə yaxşı bir hədiyyə verdi, bu dəfə ərim mənə hörmət edəcək, çünki ona altı oğul doğdum». O, uşağın adını Zevulun qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sonra bir qız doğub, adını Dina qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Allah Rəhiləni yada salıb onu da eşitdi və bətnini açdı. ");
INSERT INTO azb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","O hamilə olub bir oğul doğdu və dedi: «Allah xəcalətimi götürdü». ");
INSERT INTO azb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","O «Rəbb mənə bir oğul da artırsın» deyib uşağın adını Yusif qoydu. ");
INSERT INTO azb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rəhilə Yusifi doğandan sonra Yaqub Lavana dedi: «Məni göndər, öz torpağıma və ölkəmə gedim. ");
INSERT INTO azb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Əvəzində sənə xidmət etdiyim arvadlarımı və uşaqlarımı da ver, gedim, çünki sənə necə xidmət etdiyimi yaxşı bilirsən». ");
INSERT INTO azb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lavan ona dedi: «Əgər indi sənin gözündə lütf tapdımsa, yanımda qal, çünki baxıcılıq edib sənə görə Rəbbin mənə xeyir-dua verdiyini gördüm». ");
INSERT INTO azb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Sonra dedi: «Haqqını mənə təyin et, verim». ");
INSERT INTO azb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaqub ona dedi: «Sənə necə xidmət etdiyimi və mənimlə olan sürülərini necə saxladığımı bilirsən. ");
INSERT INTO azb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Çünki mən gəlməmişdən əvvəl sənin malın az idi, sonra isə xeyli çoxaldı; Rəbb mənim gəlişimlə sənə xeyir-dua verdi. Bəs mən öz ailəm üçün nə vaxt çalışacağam?» ");
INSERT INTO azb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lavan dedi: «Sənə nə verim?» Yaqub dedi: «Mənə heç nə vermə. Əgər bunu etsən, yenə sənin sürünü qoruyub ona baxaram: ");
INSERT INTO azb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","qoy bu gün sənin bütün sürülərinin içindən keçib qoyunlar arasından hər xallı, zolaqlı qoyunu və qara quzunu, keçilər arasından hər zolaqlı və xallı keçini ayırım; haqqım da bu olsun. ");
INSERT INTO azb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Bundan sonra qarşında olan haqqım üçün gəldikdə düzlüyüm mənim barəmdə şəhadət edəcək. Qoy keçilərdən xallı və zolaqlı olmayanı, quzulardan da qara olmayanı oğurlanmış sayılsın». ");
INSERT INTO azb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lavan dedi: «Yaxşı, qoy dediyin kimi olsun». ");
INSERT INTO azb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Amma o həmin gün alabəzək və xallı təkələri, bütün zolaqlı və xallı keçiləri, ağ keçiləri və bütün qara quzuları ayırıb oğullarının ixtiyarına verdi. ");
INSERT INTO azb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Sonra özü Yaqubdan üç günlük yol qədər uzaqlaşdı. Yaqub isə Lavanın qalan sürüsünü otarırdı. ");
INSERT INTO azb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaqub ağcaqovaq, badam və çinar ağacından düzəldilmiş təzə çubuqlar götürdü və çubuqların qabığını soyub ağ rəngli içi üzə çıxana qədər zolaqlar açdı. ");
INSERT INTO azb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Sonra qabığını soyduğu çubuqları sürülərin su içmək üçün gəldikləri təknələrə, heyvanların qabağına qoydu. Onlar gəlib su içəndə döllənirdi. ");
INSERT INTO azb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Beləcə heyvanlar çubuqların qabağında döllənirdi və sürülərdə alabəzək, xallı və zolaqlı heyvanlar doğulurdu. ");
INSERT INTO azb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaqub quzuları ayırırdı və sürünün üzünü Lavanın sürüsündə olan bütün alabəzək və qara heyvanlara tərəf tuturdu. O öz sürüsünü ayrıca qoydu və onları Lavanın sürüsünə qatmadı. ");
INSERT INTO azb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Hər dəfə sürünün qüvvətli heyvanları dölləndikləri zaman Yaqub təknələrə, sürünün gözləri önünə çubuqlar qoyurdu ki, çubuqlar arasında döllənsinlər. ");
INSERT INTO azb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ancaq heyvanlar zəif olanda onları qoymazdı. Beləcə zəif heyvanlar Lavanın, qüvvətli heyvanlar isə Yaqubun oldu. ");
INSERT INTO azb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Bu adam çox varlandı: onun çoxlu sürüsü, qarabaşı, qulu, dəvəsi və eşşəyi oldu. ");
INSERT INTO azb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaqub Lavanın oğullarının bu sözləri dediklərini eşitdi: «Yaqub atamıza məxsus olan hər şeyə sahib oldu, bütün bu var-dövləti atamıza məxsus olan əmlakdan əldə etdi». ");
INSERT INTO azb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaqub Lavanın ona münasibətini gördü, o da Yaqubla əvvəlki kimi rəftar etmirdi. ");
INSERT INTO azb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Rəbb Yaquba dedi: «Atalarının ölkəsinə, öz qohumlarının yanına qayıt. Mən səninlə olacağam». ");
INSERT INTO azb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaqub xəbər göndərib Rəhiləni və Leanı çöllərə – sürüsünü otardığı yerə çağırdı. ");
INSERT INTO azb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yaqub onlara dedi: «Mən atanızın münasibətini görürəm ki, mənimlə əvvəlki kimi rəftar etmir. Ancaq atamın Allahı mənimlədir. ");
INSERT INTO azb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Siz bilirsiniz ki, var gücümlə atanıza xidmət etmişəm. ");
INSERT INTO azb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Atanız məni aldatdı və haqqımı on dəfə dəyişdirdi, amma Allah onu mənə pislik etməyə qoymadı. ");
INSERT INTO azb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","O, “xallı heyvanlar sənin haqqın olacaq” deyəndə bütün sürüdə xallı heyvanlar doğuldu. “Sənin haqqın alabəzək heyvanlar olacaq” deyəndə isə bütün sürüdə alabəzək heyvanlar doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Beləcə Allah atanızın sürüsünü alıb mənə verdi. ");
INSERT INTO azb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Sürünün dölləndiyi vaxt yuxuda başımı qaldırıb gördüm ki, sürüdəki heyvanlarla cütləşən təkələr alabəzək, xallı və ləkəlidir. ");
INSERT INTO azb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Yuxuda Allahın mələyi mənə dedi: “Yaqub!” “Mən buradayam!” deyə cavab verdim. ");
INSERT INTO azb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","O dedi: “İndi başını qaldır, gör ki, sürüdəki heyvanlarla cütləşən bütün təkələr alabəzək, xallı və ləkəlidir, çünki Lavanın sənə etdiyi hər şeyi gördüm. ");
INSERT INTO azb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mən Bet-Eldə sənə görünən Allaham. Orada bir sütun qoyub məsh etdin və Mənim önümdə əhd etdin. İndi qalxıb bu torpaqdan get və doğulduğun torpağa qayıt”». ");
INSERT INTO azb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rəhilə və Lea ona cavab verdilər: «Məgər atamızın mülkündə bir payımız ya mirasımız var? ");
INSERT INTO azb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Məgər o bizi özgə hesab etmir? Axı o bizi satıb bizim üçün ödənmiş pulu da xərclədi. ");
INSERT INTO azb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Buna görə də Allahın atamızdan aldığı bütün o var-dövlət bizim və uşaqlarımızındır. İndi sən də Allahın söylədiyi şeylərin hamısına əməl et». ");
INSERT INTO azb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Onda Yaqub qalxıb uşaqlarını və arvadlarını dəvələrə mindirdi. ");
INSERT INTO azb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Bütün sürüsünü, qazandığı bütün var-dövlətini, Paddan-Aramda əldə etdiyi öz sürüsünü sürdü ki, Kənan torpağına, atası İshaqın yanına getsin. ");
INSERT INTO azb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lavan qoyunlarını qırxmağa gedəndə Rəhilə atasına məxsus olan ev bütlərini oğurladı. ");
INSERT INTO azb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaqub qaçdığını bildirməməklə Aramlı Lavanı aldatdı. ");
INSERT INTO azb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Beləcə özünə məxsus olan hər şeyi götürüb qaçdı. O, Fərat çayını keçib Gilead dağlıq bölgəsinə yönəldi. ");
INSERT INTO azb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yaqubun qaçdığı Lavana üçüncü gün bildirildi. ");
INSERT INTO azb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","O, qohumlarını özü ilə götürüb yeddi gün onu təqib etdi və Gilead dağlıq bölgəsində Yaquba çatdı. ");
INSERT INTO azb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Allah gecə yuxusunda Aramlı Lavana görünüb dedi: «Özünü gözlə, Yaquba nə yaxşı, nə də pis söz de». ");
INSERT INTO azb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lavan Yaquba çatdı. Yaqub dağda çadır qurmuşdu. Lavan qohumları ilə birgə Gilead dağında çadır qurdu. ");
INSERT INTO azb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lavan Yaquba dedi: «Niyə belə etdin? Məndən gizlicə qaçdın və qızlarımı müharibə əsirləri kimi apardın. ");
INSERT INTO azb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nə üçün gizlicə qaçıb məni aldatdın? Mənə bunu bildirmədin ki, səni sevinclə, mahnı oxumaqla, dəf və lira çalmaqla yola salım. ");
INSERT INTO azb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Məni nəvələrimlə qızlarımı öpməyə qoymadın; ağılsızcasına rəftar etmisən. ");
INSERT INTO azb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Sizə pislik edə bilərdim, ancaq atanızın Allahı dünən gecə mənə belə söylədi: “Özünü gözlə, Yaquba nə yaxşı, nə də pis söz de”. ");
INSERT INTO azb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","İndi atanın evi üçün bərk darıxdığına görə çıxıb gedirsən. Bəs büt allahlarımı niyə oğurlayıb aparırsan?» ");
INSERT INTO azb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaqub Lavana cavab verdi: «Qorxub düşündüm ki, qızlarını zorla məndən alarsan. ");
INSERT INTO azb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Büt allahlarını isə kimin yanında tapsan, o sağ qalmayacaq. Qohumlarımızın önündə yoxlayıb məndə nəyini tapsan, özünə götür». Ancaq Yaqub Rəhilənin onları oğurladığını bilmirdi. ");
INSERT INTO azb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lavan Yaqubun, Leanın və iki qarabaşın çadırına girdi, ancaq büt allahları tapmadı. O, Leanın çadırından çıxıb Rəhilənin çadırına girdi. ");
INSERT INTO azb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rəhilə ev bütlərini götürərək dəvənin yəhərinə qoyub onların üstündə oturmuşdu. Lavan bütün çadırı yoxladı, ancaq onları tapmadı. ");
INSERT INTO azb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rəhilə atasına dedi: «Hüzurunda qalxa bilmədiyim üçün ağam qəzəblənməsin, çünki qadın adətinə mübtəlayam». Lavan axtardı, ancaq ev bütlərini tapmadı. ");
INSERT INTO azb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaqub qəzəblənib Lavanla mübahisə etdi. O, Lavana söylədi: «Günahım və təqsirim nədir ki, məni belə təqib edirsən? ");
INSERT INTO azb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Bütün şeylərimi yoxladın, bütün ev şeylərindən nə tapdın? Tapdığın şeyi mənim qohumlarımın və öz qohumlarının qabağına qoy ki, ikimizin arasında şəhadət olsun. ");
INSERT INTO azb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ötən iyirmi il sənin yanında işlədim, qoyunların və keçilərin balalarını salmadı, sürülərindəki qoçlarını yemədim. ");
INSERT INTO azb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Vəhşi heyvanların parçaladığı heyvanı sənin yanına gətirməzdim, zərərini özüm çəkərdim. İstər gündüz, istərsə də gecə oğurlanan hər heyvanı məndən tələb edərdin. ");
INSERT INTO azb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Gündüzün istisi, gecənin soyuğu məni əldən salardı, yuxum gözümdən tökülərdi. ");
INSERT INTO azb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","İyirmi il sənin evində qaldım: iki qızın üçün on dörd il və sürün üçün altı il sənə xidmət etdim. Sən isə on dəfə haqqımı dəyişdirdin. ");
INSERT INTO azb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Atamın və İbrahimin Allahı, İshaqın sitayiş etdiyi Allah mənimlə olmasaydı, indi yəqin məni əliboş yola salardın. Allah əzabımı və əlimin zəhmətini gördü, dünən gecə sənə xəbərdarlıq etdi». ");
INSERT INTO azb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lavan Yaquba belə cavab verdi: «Qızlar mənim qızlarım, uşaqlar mənim uşaqlarım, sürülər mənim sürülərim və sənin gördüyün hər şey mənimdir. Bu gün qızlarıma yaxud onların doğduqları uşaqlara nə edə bilərəm? ");
INSERT INTO azb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","İndi gəl bir-birimizə əhd edək ki, səninlə mənim aramda şahid olsun». ");
INSERT INTO azb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yaqub bir daş götürüb sütun kimi qoydu. ");
INSERT INTO azb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","O öz qohumlarına dedi: «Daş yığın». Onlar daşları götürüb bir qalaq düzəltdilər və o qalağın yanında yeyib-içdilər. ");
INSERT INTO azb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lavan onun adını Yeqar-Sahaduta qoydu, Yaqub isə onun adını Qaled qoydu. ");
INSERT INTO azb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lavan dedi: «Bu qalaq bu gün mənimlə sənin aranda şahiddir». Buna görə də onun adı Qaleddir. ");
INSERT INTO azb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ona həm də Mispa deyildi, çünki Lavan demişdi: «Bir-birimizdən ayrılan zaman qoy Rəbb səninlə mənim aramda gözətçi olsun. ");
INSERT INTO azb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Söz ver ki, qızlarımı incitməyəcəksən və onların üstünə arvad almayacaqsan. Bil ki, bizim aramızda bir nəfər şahid olmasa da, Allah aramızda şahiddir». ");
INSERT INTO azb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lavan yenə Yaquba dedi: «Bax bu da öz aramızda düzəltdiyim qalaq və sütun! ");
INSERT INTO azb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Bu qalaq və sütun şahid olsunlar ki, nə mən sənin tərəfinə – qalağın o tayına gedəcəyəm, nə də sən pislik etmək üçün mənim tərəfimə – qalağın və sütunun bu tayına gələcəksən. ");
INSERT INTO azb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Qoy İbrahimin, Naxorun və onların atalarının Allahı aramızda hökm etsin!» Yaqub atası İshaqın sitayiş etdiyi Allaha and içdi. ");
INSERT INTO azb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sonra Yaqub o dağda qurban kəsdi və qohumlarını çörək yeməyə çağırdı. Onlar çörək yedilər və dağda gecələdilər. ");
INSERT INTO azb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lavan səhər tezdən qalxıb nəvələrini və qızlarını öpdü, onlara xeyir-dua verdi. Sonra öz yerinə qayıtdı. ");
INSERT INTO azb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaqub yoluna davam etdi. Allahın mələkləri ona rast gəldi. ");
INSERT INTO azb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaqub onları görəndə dedi: «Bu, Allahın ordugahıdır». O yerin adını Maxanayim qoydu. ");
INSERT INTO azb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaqub özündən qabaq Edom çölünə, Seir torpağına, qardaşı Esavın yanına qasidlər göndərdi. ");
INSERT INTO azb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Onlara bu əmri verdi: «Ağam Esava söyləyin ki, qulun Yaqub belə deyir: “Mən Lavanın yanında qalıb indiyə qədər yaşadım”. ");
INSERT INTO azb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mal-qaram, eşşəklərim, qoyun-keçim, qullarım və qarabaşlarım oldu. Mən ağama xəbər vermək üçün yanına qasidlər göndərdim ki, sənin gözündə lütf tapım». ");
INSERT INTO azb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Qasidlər Yaqubun yanına qayıdıb dedilər: «Qardaşın Esavın yanına getdik. Özü də səni qarşılamaq üçün gəlir və yanında dörd yüz nəfər var». ");
INSERT INTO azb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaqub çox qorxub həyəcanlandı. Yanında olan adamları, qoyun-keçini, mal-qaranı və dəvələri iki dəstəyə ayırıb dedi: ");
INSERT INTO azb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","«Əgər Esav bir dəstəyə hücum edib onları qırsa, arxada qalan dəstə qaça bilsin». ");
INSERT INTO azb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Sonra Yaqub dedi: «Ey babam İbrahimin Allahı, atam İshaqın Allahı Rəbb, Sən mənə demişdin: “Öz ölkənə və qohumlarının yanına qayıt. Mən sənə yaxşılıq edəcəyəm”. ");
INSERT INTO azb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Quluna göstərdiyin bütün xeyirxahlığa və sədaqətə layiq deyiləm; bu İordan çayını təkcə dəyənəyimlə keçdim, indi isə iki dəstə köçüm var. ");
INSERT INTO azb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Yalvarıram, məni qardaşım Esavın əlindən qurtar. Çünki onun gəlib məni, uşaqlarımla analarını öldürməsindən qorxuram. ");
INSERT INTO azb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Sən dedin: “Hökmən sənə yaxşılıq edəcəyəm, nəslini saysız-hesabsız dəniz qumu qədər çoxaldacağam”». ");
INSERT INTO azb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yaqub o gecəni orada keçirtdi. Özündə olan hər şeydən qardaşı Esava hədiyyə olaraq ");
INSERT INTO azb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","iki yüz keçi, iyirmi təkə, iki yüz qoyun, iyirmi qoç, ");
INSERT INTO azb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","balaları ilə birgə otuz sağmal dəvə, qırx inək, on buğa, iyirmi dişi və on erkək eşşək götürdü. ");
INSERT INTO azb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Sürüləri ayrı-ayrı qullarına tapşırdı və onlara dedi: «Mənim qabağımda gedin və bir sürü ilə o biri sürü arasında məsafə saxlayın». ");
INSERT INTO azb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yaqub birinci qula əmr edib dedi: «Qardaşım Esav sənə rast gəlib “Kimin adamısan, hara gedirsən, qabağındakı bu heyvanlar kimindir?” deyə soruşanda ");
INSERT INTO azb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ona söylə: “Bunlar qulun Yaqubundur, bu da ağam Esava göndərilmiş hədiyyələrdir. Özü də bizim dalımızca gəlir”». ");
INSERT INTO azb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Sonra o, ikinci, üçüncü quluna və sürülərin dalınca gedən hər kəsə əmr edib dedi: ");
INSERT INTO azb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","«Esava rast gələndə ona eyni sözləri söyləyin: “Qulun Yaqub da dalımızca gəlir”». Çünki o öz-özünə deyirdi: «Əvvəlcə qabağımda göndərdiyim hədiyyələrlə onu rəhmə gətirərəm, sonra onunla görüşərəm. Bəlkə onda məni qəbul edər». ");
INSERT INTO azb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hədiyyələr Yaqubun qabağında getdi, o isə gecəni düşərgədə yatdı. ");
INSERT INTO azb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yaqub gecə qalxıb iki arvadını, iki cariyəsini və on bir uşağını götürərək Yabboq çayının keçidindən keçdi. ");
INSERT INTO azb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Onları götürüb çayı keçirtdi və özünə məxsus şeyləri də keçirtdi. ");
INSERT INTO azb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sonra Yaqub tək qaldı. Dan yeri sökülənə qədər bir Şəxs onunla güləşdi. ");
INSERT INTO azb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yaquba üstün gələ bilmədiyini görüb onun budunun oynağına zərbə vurdu. O Şəxslə güləşərkən Yaqubun budunda oynağı zədələndi. ");
INSERT INTO azb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","O Şəxs dedi: «Burax, gedim, çünki səhər açılır». Yaqub dedi: «Mənə xeyir-dua verməsən, Səni buraxmaram». ");
INSERT INTO azb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","O Şəxs soruşdu: «Adın nədir?» O dedi: «Yaqub». ");
INSERT INTO azb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","O Şəxs dedi: «Artıq sənə Yaqub deyil, İsrail deyiləcək, çünki sən Allahla və insanlarla güləşib üstün gəlmisən». ");
INSERT INTO azb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaqub soruşdu: «Xahiş edirəm, adını söylə». O dedi: «Adımı niyə soruşursan?» O Şəxs orada Yaquba xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaqub o yerin adını Peniel qoydu, çünki demişdi: «Allahı üz-üzə gördüm və salamat qaldım». ");
INSERT INTO azb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaqub Penieldən keçəndə günəş doğdu. O, bir budundan axsayırdı. ");
INSERT INTO azb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ona görə bu günə qədər də İsraillilər bud oynağının üzərindəki vətərləri yeməzlər. Çünki güləşən Şəxs Yaqubun bud oynağının vətərinə toxunmuşdu. ");
INSERT INTO azb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaqub başını qaldırıb gördü ki, Esav dörd yüz adamla birlikdə gəlir. O, Leanın, Rəhilənin və iki cariyəsinin uşaqlarını ayırdı: ");
INSERT INTO azb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","cariyələrlə onların uşaqlarını qabağa, Lea ilə onun uşaqlarını ortaya, Rəhilə ilə Yusifi isə arxaya qoydu. ");
INSERT INTO azb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Özü isə onların qabağına keçdi və qardaşına yaxınlaşanda yeddi dəfə yerə əyildi. ");
INSERT INTO azb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esav Yaqubu qarşılamaq üçün qaçıb onu qucaqladı və boynuna sarılıb öpdü. Onlar ağlaşdılar. ");
INSERT INTO azb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esav başını qaldırıb qadınları və uşaqları görəndə dedi: «Bunlar sənin nəyindir?» Yaqub dedi: «Allahın sənin quluna lütf etdiyi uşaqlardır». ");
INSERT INTO azb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Əvvəl cariyələrlə uşaqları yaxınlaşıb təzim etdilər, ");
INSERT INTO azb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","sonra Lea ilə uşaqları yaxınlaşıb təzim etdilər, axırda isə Yusiflə Rəhilə yaxınlaşıb təzim etdilər. ");
INSERT INTO azb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esav soruşdu: «Rast gəldiyim o biri dəstəni nə üçün göndərmişdin?» Yaqub dedi: «Ağamın gözündə lütf tapmaq üçün». ");
INSERT INTO azb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esav dedi: «Mənim sürüm çoxdur, qardaşım, səndə olan sənin olsun». ");
INSERT INTO azb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaqub dedi: «Yox, xahiş edirəm, indi gözündə lütf tapdımsa, məndən bu hədiyyələri götür. Çünki sənin üzünü görəndə Allahın üzünü görmüş sandım, mənə qarşı çox xeyirxah oldun. ");
INSERT INTO azb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xahiş edirəm, sənə gətirilən hədiyyələri götür. Çünki Allah mənə lütf etdi və indi mənim hər şeyim var». Yaqub təkid etdikdən sonra Esav hədiyyələri götürdü. ");
INSERT INTO azb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esav dedi: «Köç edib gedək. Mən sizin qabağınızda gedəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaqub ona dedi: «Ağam bilir ki, uşaqlar zəifdir, yanımda olan qoyun-keçi və mal-qara da sağmaldır. Sürüləri bir gün bərk sürsələr, hamısı tələf olar. ");
INSERT INTO azb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Xahiş edirəm, ağam qulundan qabaqda getsin, mən isə ağamın yanına, Seirə çatana qədər qabağımda olan sürülərin və uşaqların yerişinə görə yavaş sürəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esav dedi: «Mənimlə olan adamların bəzisini səninlə qalmaq üçün qoyum». Yaqub dedi: «Bu nəyə lazımdır? Mən ancaq ağamın gözündə lütf tapmaq istəyirəm». ");
INSERT INTO azb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esav o gün yola düşüb Seirə qayıtdı. ");
INSERT INTO azb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaqub Sukkota köçüb özünə ev tikdi və sürüsünə ağıllar düzəltdi. Ona görə də bu yerin adını Sukkot qoydular. ");
INSERT INTO azb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaqub Paddan-Aramdan qayıtdıqdan sonra sağ-salamat Kənan torpağında olan Şekem şəhərinə gəldi və şəhərin qarşısında məskən saldı. ");
INSERT INTO azb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","O, çadırını qurduğu tarla sahəsini Şekemin atası Xamorun oğullarından yüz parça gümüşlə satın aldı. ");
INSERT INTO azb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yaqub orada bir qurbangah qurub adını El-Elohe-İsrail qoydu. ");
INSERT INTO azb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leanın Yaquba doğduğu qızı Dina o ölkənin qızlarını görməyə çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","O ölkənin ağası Xivli Xamorun oğlu Şekem onu gördü. Qızı aparıb onunla yatdı və onu zorladı. ");
INSERT INTO azb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Onun ürəyi Yaqubun qızı Dinaya bağlandı. Şekem qızı sevdi və onunla xoş rəftar etdi. ");
INSERT INTO azb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Şekem atası Xamora dedi: «Bu qızı mənə arvad al». ");
INSERT INTO azb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaqub qızı Dinanın zorlandığını eşitdi, ancaq oğulları çöldə sürülərinin yanında olduqları üçün onlar gələnə qədər susdu. ");
INSERT INTO azb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Şekemin atası Xamor Yaqubla danışmaq üçün onun yanına getdi. ");
INSERT INTO azb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaqubun oğulları bunu eşidib çöllükdən gəldilər. Onlar məyus oldular və bərk qəzəbləndilər. Çünki Şekem Yaqubun qızı ilə yatmaqla İsraili rüsvay etmişdi, belə iş etmək olmazdı. ");
INSERT INTO azb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Xamor onlara belə dedi: «Oğlum Şekemin ürəyi qızınıza bağlanıb. Xahiş edirəm, qızı ona arvad olmaq üçün verəsiniz. ");
INSERT INTO azb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Bizimlə qohum olun: öz qızlarınızı bizə arvad verin, bizim qızlarımızı özünüzə alın. ");
INSERT INTO azb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Bizimlə qalın, ölkə də sizin ixtiyarınızdadır: burada yaşayın, ticarət edin və mülk sahibi olun». ");
INSERT INTO azb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Şekem qızın atasına və qardaşlarına dedi: «Sizin gözünüzdə lütf tapmaq üçün məndən nə istəsəniz, verərəm. ");
INSERT INTO azb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Məndən çoxlu başlıq və hədiyyələr istəyin, söylədiyiniz hər şeyi verərəm. Ancaq qızı arvad olmaq üçün mənə verin». ");
INSERT INTO azb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yaqubun oğulları Şekemə və onun atası Xamora hiylə ilə cavab verdilər, çünki Şekem bacıları Dinanı zorlamışdı. ");
INSERT INTO azb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Onlara dedilər: «Biz bunu edə bilmərik, bacımızı sünnətsiz bir adama ərə verə bilmərik. Bu bizim üçün rüsvayçılıq olar. ");
INSERT INTO azb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ancaq bir şərtlə sizinlə razı oluruq: bütün kişiləriniz sünnət edilib bizim kimi olsalar, ");
INSERT INTO azb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","öz qızlarımızı sizə ərə verərik, sizin qızlarınızı özümüzə alarıq və sizinlə yaşayıb bir xalq olarıq. ");
INSERT INTO azb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Əgər bizə qulaq asmasanız və sünnət olunmasanız, qızımızı götürüb gedəcəyik». ");
INSERT INTO azb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Onların sözləri Xamorun və oğlu Şekemin xoşuna gəldi. ");
INSERT INTO azb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Cavan oğlan bu işi dərhal etdi, çünki Yaqubun qızı çox xoşuna gəlmişdi. Şekem atasının evində ən hörmətli adam idi. ");
INSERT INTO azb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Xamor və oğlu Şekem öz şəhərlərinin darvazasına gəldilər və şəhərin adamlarına belə dedilər: ");
INSERT INTO azb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Bu adamlar bizimlə səmimidir. Qoy bu ölkədə yaşasınlar və ticarət etsinlər. Bu ölkə onlar üçün kifayət qədər genişdir. Onların qızlarını özümüzə arvad alarıq, öz qızlarımızı da onlara ərə verərik. ");
INSERT INTO azb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bu adamlar yalnız bir şərtlə bizimlə yaşamağa və bir xalq olmağa razı olurlar ki, bizim də bütün kişilərimiz onlar kimi sünnət olunsun. ");
INSERT INTO azb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Onların sürüləri, mülkləri və heyvanları bizim olmayacaqmı? Gəlin onlarla razılaşaq və onlar bizimlə yaşasın». ");
INSERT INTO azb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Şəhərin bütün sakinləri Xamora və oğlu Şekemə qulaq asdılar: şəhər əhalisindən olan bütün kişilər sünnət olundu. ");
INSERT INTO azb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Üçüncü gün onlar hələ də ağrı çəkən zaman Dinanın qardaşları – Yaqubun iki oğlu Şimeon və Levi qılınclarını götürüb maneəsiz şəhərə girdilər və bütün kişiləri qılıncdan keçirtdilər. ");
INSERT INTO azb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Xamoru və oğlu Şekemi də öldürdülər. Dinanı Şekemin evindən götürüb getdilər. ");
INSERT INTO azb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaqubun oğulları ölənlərin yanına gəldilər və şəhəri qarət etdilər, çünki bacılarını zorlamışdılar. ");
INSERT INTO azb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Onların qoyun-keçilərini, mal-qaralarını, eşşəklərini, şəhərdə və çöldə olan hər şeyi götürdülər. ");
INSERT INTO azb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bütün mallarını, uşaqlarını və qadınlarını əsir apardılar, onların evlərində olan hər şeyi qarət etdilər. ");
INSERT INTO azb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaqub Şimeona və Leviyə dedi: «Ölkədə yaşayan Kənanlılarda və Perizlilərdə mənə qarşı nifrət oyadıb məni bəlaya saldınız. Biz sayca azıq, əgər birləşib bizi qırsalar, özüm də ailəmlə birgə həlak olacağam». ");
INSERT INTO azb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Amma onlar dedilər: «Bəs bizim bacımızla bir fahişə kimi rəftar etmək olarmı?» ");
INSERT INTO azb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Allah Yaquba dedi: «Qalxıb Bet-Elə get və orada qal. Qardaşın Esavın əlindən qaçanda sənə görünən Allaha orada bir qurbangah düzəlt». ");
INSERT INTO azb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaqub ailəsinə və onunla olanların hamısına dedi: «Yanınızda olan özgə büt allahlarını atın və özünüzü pak edib paltarlarınızı dəyişin. ");
INSERT INTO azb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Qalxıb Bet-Elə gedək. Dərdli günümdə mənə cavab verən və getdiyim yolda mənimlə olan Allaha orada bir qurbangah düzəldəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Onlar yanlarında olan bütün özgə büt allahlarını və qulaqlarındakı sırğaları Yaquba verdilər. Yaqub bunları Şekem yaxınlığında olan palıdın altında basdırdı. ");
INSERT INTO azb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Onlar yola düşdülər. Allah ətraf şəhərlərin sakinlərini dəhşətə salmışdı və buna görə də onlar Yaqubun oğullarını təqib etmədilər. ");
INSERT INTO azb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaqub yanındakı bütün adamlarla birgə Kənan torpağında olan Luza, yəni Bet-Elə gəldi. ");
INSERT INTO azb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Burada bir qurbangah düzəldib o yerin adını El-Bet-El qoydu, çünki qardaşının əlindən qaçanda Allah Özünü orada Yaquba zahir etmişdi. ");
INSERT INTO azb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rivqanın dayəsi Devora öldü. Onu Bet-Elin aşağısında olan palıdın altında basdırdılar. Oranın adını Allon-Bakut qoydular. ");
INSERT INTO azb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaqub Paddan-Aramdan qayıdanda Allah yenə Yaquba göründü və ona xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Allah ona dedi: «Sənin adın Yaqubdur. Artıq adın Yaqub çağırılmayacaq, bundan sonra adın İsrail olacaq». Allah onun adını İsrail qoydu ");
INSERT INTO azb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","və ona dedi: «Külli-İxtiyar Allah Mənəm. Qoy nəslin artıb çoxalsın. Səndən bir millət və çoxlu millət törəyəcək, sənin nəslindən çoxlu padşahlar çıxacaq. ");
INSERT INTO azb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","İbrahimə və İshaqa verdiyim torpağı sənə verəcəyəm. Səndən sonra da onu sənin nəslinə verəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Allah Yaqubla danışdığı yerdə onun yanından yuxarı çəkildi. ");
INSERT INTO azb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaqub Allahın onunla danışdığı yerdə bir sütun qoydu, üstünə içmə təqdimi səpdi və sonra üzərinə zeytun yağı tökdü. ");
INSERT INTO azb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaqub Allahın onunla danışdığı yerin adını Bet-El qoydu. ");
INSERT INTO azb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Onlar Bet-Eldən yola düşdülər. Efrata çatana yaxın Rəhilə doğdu. Onun doğuşu ağır oldu. ");
INSERT INTO azb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Doğuş zamanı ağrı çəkəndə mamaça ona dedi: «Qorxma, yenə də bir oğlun oldu». ");
INSERT INTO azb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","O, ölüm ayağında can verərkən oğlunun adını Ben-Oni qoydu, ancaq atası onun adını Binyamin qoydu. ");
INSERT INTO azb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rəhilə öldü və Efrata, yəni Bet-Lexemə gedən yolda basdırıldı. ");
INSERT INTO azb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaqub onun qəbri üstünə bir daş qoydu. O bu günə qədər Rəhilənin başdaşıdır. ");
INSERT INTO azb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","İsrail yola düşdü və Eder qülləsinin o biri tərəfində çadır qurdu. ");
INSERT INTO azb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","İsrail bu ölkədə yaşayanda Ruven gedib atasının cariyəsi Bilha ilə yatdı. İsrail bunu eşitdi. ");
INSERT INTO azb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Yaqubun on iki oğlu var idi. Leanın oğulları: Yaqubun ilk oğlu Ruven, Şimeon, Levi, Yəhuda, İssakar və Zevulun. ");
INSERT INTO azb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rəhilənin oğulları: Yusif və Binyamin. ");
INSERT INTO azb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rəhilənin qulluqçusu Bilhanın oğulları: Dan və Naftali. ");
INSERT INTO azb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leanın qulluqçusu Zilpanın oğulları: Qad və Aşer. Yaqubun Paddan-Aramda doğulan oğulları bunlardır. ");
INSERT INTO azb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaqub Qiryat-Arbada, yəni Xevronda olan Mamreyə, atası İshaqın yanına gəldi. İbrahim və İshaq Mamredə qərib idilər. ");
INSERT INTO azb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","İshaq yüz səksən il ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","O qocalıb yaşa dolaraq canını tapşırdı və ölüb əcdadlarına qoşuldu. Oğulları Esav və Yaqub onu basdırdılar. ");
INSERT INTO azb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esavın, yəni Edomun tarixçəsi belədir. ");
INSERT INTO azb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esav Kənan qızlarından Xetli Elonun qızı Adanı, Xivli Siveonun qızı Ananın qızı Oholivamanı, ");
INSERT INTO azb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","həmçinin İsmailin qızı, Nevayotun bacısı Basmatı arvad aldı. ");
INSERT INTO azb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Esava Elifazı doğdu, Basmat isə Reueli doğdu. ");
INSERT INTO azb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholivama Yeuşu, Yalamı və Qorahı doğdu; Esavın Kənan torpağında doğulan oğulları bunlardır. ");
INSERT INTO azb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esav arvadlarını, oğullarını, qızlarını, evindəki adamların hamısını, sürülərini, bütün heyvanlarını və Kənan torpağında qazandığı bütün var-dövləti götürüb qardaşı Yaqubun yanından başqa bir torpağa getdi. ");
INSERT INTO azb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Çünki əmlakları çox olduğuna görə bir yerdə yaşaya bilmədilər; sürüləri çox olduğu üçün qaldıqları torpağa sığmırdılar. ");
INSERT INTO azb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esav, yəni Edom Seir dağlıq diyarında məskən saldı. ");
INSERT INTO azb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Edomluların əcdadı Esavın Seir dağlıq diyarındakı tarixçəsi belədir. ");
INSERT INTO azb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esavın oğullarının adları belədir: Esavın arvadı Adanın oğlu Elifaz, Esavın arvadı Basmatın oğlu Reuel. ");
INSERT INTO azb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazın oğulları: Teman, Omar, Sefo, Qatam və Qenaz. ");
INSERT INTO azb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna Esavın oğlu Elifazın cariyəsi idi. O, Elifaza Amaleqi doğdu. Esavın arvadı Adanın nəvələri bunlardır. ");
INSERT INTO azb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuelin oğulları bunlardır: Naxat, Zerah, Şamma və Mizza; bunlar Esavın arvadı Basmatın nəvələridir. ");
INSERT INTO azb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esavın arvadı Siveon qızı Ana qızı Oholivamanın oğulları bunlardır: o, Esava Yeuşu, Yalamı və Qorahı doğdu. ");
INSERT INTO azb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esav oğullarının başçıları bunlardır: Esavın ilk oğlu Elifazın oğulları: başçı Teman, başçı Omar, başçı Sefo, başçı Qenaz, ");
INSERT INTO azb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","başçı Qorah, başçı Qatam, başçı Amaleq. Edom torpağında Elifazdan olan başçılar bunlardır; onlar Adanın nəvələridir. ");
INSERT INTO azb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esavın oğlu Reuelin oğulları bunlardır: başçı Naxat, başçı Zerah, başçı Şamma, başçı Mizza. Edom torpağında Reueldən olan başçılar bunlardır; onlar Esavın arvadı Basmatın nəvələridir. ");
INSERT INTO azb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esavın arvadı Oholivamanın oğulları bunlardır: başçı Yeuş, başçı Yalam, başçı Qorah; onlar Esavın arvadı Ana qızı Oholivamanın nəslindən olan başçılardır. ");
INSERT INTO azb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bunlar Esavın, yəni Edomun oğullarıdır, bunlar da onların başçılarıdır. ");
INSERT INTO azb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ölkədə yaşayan Xorlu Seirin oğulları bunlardır: Lotan, Şoval, Siveon, Ana, ");
INSERT INTO azb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dişon, Eser və Dişan. Edom torpağında başçılıq edən Xorlu Seirin oğulları bunlardır. ");
INSERT INTO azb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanın oğulları Xori və Hemam, Lotanın bacısı Timna. ");
INSERT INTO azb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Şovalın oğulları bunlardır: Alvan, Manaxat, Eval, Şefo və Onam. ");
INSERT INTO azb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Siveonun oğulları bunlardır: Ayya və Ana; atası Siveonun eşşəklərini otararkən çöldə isti bulaqlar tapan Ana budur. ");
INSERT INTO azb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ananın övladları bunlardır: Dişon və Ananın qızı Oholivama. ");
INSERT INTO azb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dişonun oğulları bunlardır: Xemdan, Eşban, İtran və Keran. ");
INSERT INTO azb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eserin oğulları bunlardır: Bilhan, Zaavan və Aqan. ");
INSERT INTO azb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dişanın oğulları bunlardır: Us və Aran. ");
INSERT INTO azb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Xorlulardan olan başçılar bunlardır: başçı Lotan, başçı Şoval, başçı Siveon, başçı Ana, ");
INSERT INTO azb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","başçı Dişon, başçı Eser, başçı Dişan; Seir torpağında qəbilələrinə görə Xorlu başçılar bunlardır. ");
INSERT INTO azb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","İsraillilərə bir kəs padşahlıq etməzdən əvvəl Edom ölkəsində padşahlıq edən adamlar bunlardır: ");
INSERT INTO azb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Edomda Beorun oğlu Bela padşah oldu. Onun şəhəri Dinhava idi. ");
INSERT INTO azb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela öldü və onun yerinə Bosradan olan Zerah oğlu Yovav padşah oldu. ");
INSERT INTO azb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yovav öldü və onun yerinə Temanlıların torpağından olan Xuşam padşah oldu. ");
INSERT INTO azb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Xuşam öldü və onun yerinə Moav çölündə Midyanlıları qıran Bedad oğlu Hadad padşah oldu. Onun şəhəri Avit idi. ");
INSERT INTO azb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad öldü və onun yerinə Masreqadan olan Samla padşah oldu. ");
INSERT INTO azb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla öldü və onun yerinə Rexovot-Hannahardan olan Şaul padşah oldu. ");
INSERT INTO azb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Şaul öldü və onun yerinə Akbor oğlu Baal-Xanan padşah oldu. ");
INSERT INTO azb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbor oğlu Baal-Xanan öldü və onun yerinə Hadar padşah oldu. Onun şəhəri Pau idi. Onun arvadının adı Me-Zahav qızı Matred qızı Mehetavel idi. ");
INSERT INTO azb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esavın nəslindən olan başçıların qəbilələrinə və yerlərinə görə adları belədir: başçı Timna, başçı Alva, başçı Yetet, ");
INSERT INTO azb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","başçı Oholivama, başçı Ela, başçı Pinon, ");
INSERT INTO azb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","başçı Qenaz, başçı Teman, başçı Mivsar, ");
INSERT INTO azb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","başçı Maqdiel, başçı İram; sahib olduqları ölkədə yaşadıqları yerlərə görə Edom başçıları bunlardır. Esav da Edomluların əcdadıdır. ");
INSERT INTO azb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaqub atasının qərib olduğu Kənan torpağında yaşadı. ");
INSERT INTO azb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yaqubun tarixçəsi belədir. Yusif on yeddi yaşında bir gənc idi. O öz qardaşları – atasının arvadları Bilhanın və Zilpanın oğulları ilə birlikdə sürü otarırdı. Yusif onların pis işləri barədə xəbərləri atasına çatdırırdı. ");
INSERT INTO azb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","İsrail Yusifi bütün oğullarından çox sevirdi, çünki Yusif onun qocalıq çağının oğlu idi. O, Yusifə əlvan paltar tikdirdi. ");
INSERT INTO azb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Qardaşları gördülər ki, ataları onlardan çox Yusifi sevir. Buna görə də ona nifrət etdilər və onunla yaxşı rəftar etmədilər. ");
INSERT INTO azb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Bir dəfə Yusif yuxu gördü və onu qardaşlarına danışdı. Bundan sonra ona daha çox nifrət etməyə başladılar. ");
INSERT INTO azb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusif onlara dedi: «Gördüyüm bu yuxuya qulaq asın: ");
INSERT INTO azb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","biz zəminin ortasında dərz bağlayırdıq; mənim dərzim qalxıb dik durdu, sizin dərzləriniz isə mənim dərzimi əhatəyə alıb ona təzim etdilər». ");
INSERT INTO azb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Qardaşları ona dedilər: «Doğrudanmı, sən bizə padşah olacaqsan, hökmranlıq edəcəksən?» Onlar yuxularına və sözlərinə görə Yusifə daha çox nifrət etdilər. ");
INSERT INTO azb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusif başqa bir yuxu gördü və onu qardaşlarına danışıb dedi: «Yenə bir yuxu gördüm; gördüm ki, günəş, ay və on bir ulduz mənə təzim edir». ");
INSERT INTO azb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","O, yuxusunu atasına və qardaşlarına danışanda atası onu danlayıb dedi: «Bu gördüyün yuxu nə deməkdir? Doğrudanmı, mən, anan və qardaşların yerə əyilib sənə təzim etmək üçün gələcəyik?» ");
INSERT INTO azb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Qardaşları ona paxıllıq etdilər, atası isə bu sözü yadda saxladı. ");
INSERT INTO azb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Bir gün Yusifin qardaşları atalarının sürüsünü otarmaq üçün Şekemə getdilər. ");
INSERT INTO azb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","İsrail Yusifə dedi: «Qardaşların Şekemdə sürü otarırlar. Gəl səni də onların yanına göndərim». O, atasına dedi: «Getməyə hazıram». ");
INSERT INTO azb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","İsrail yenə ona dedi: «Get bax, qardaşların yaxşıdırmı, sürü salamatdırmı? Sonra mənə xəbər gətir». Beləcə onu Xevron vadisindən yola saldı. Yusif gəlib Şekemə çatdı. ");
INSERT INTO azb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Çöldə dolaşarkən bir nəfər ona rast gəldi. Bu adam «Nə axtarırsan?» deyə ondan soruşdu. ");
INSERT INTO azb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","O dedi: «Mən qardaşlarımı axtarıram. Mənə de görüm, onlar sürünü harada otarırlar?» ");
INSERT INTO azb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Bu adam dedi: «Buradan getdilər, çünki mən onların “Dotana gedək” sözlərini eşitdim». Yusif qardaşlarının dalınca düşdü və onları Dotanda tapdı. ");
INSERT INTO azb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Qardaşları onu uzaqdan gördülər. Yusif onların yanına çatmamış onu öldürmək qərarına gəldilər. ");
INSERT INTO azb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Qardaşlar bir-birlərinə dedilər: «Baxın, bu yuxular görən gəlir. ");
INSERT INTO azb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","İndi gəlin onu öldürüb bir quyuya ataq, sonra da deyək ki, vəhşi heyvan onu parçaladı. Onda görərik, yuxuları necə çin çıxır». ");
INSERT INTO azb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruven bunu eşidib Yusifi onların əlindən qurtarmaq üçün dedi: «Gəlin ona toxunmayaq». ");
INSERT INTO azb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruven onlara «qan tökməyin, onu çöldə olan bu quyuya atın, ancaq ona toxunmayın» dedi. Bunu ona görə deyirdi ki, Yusifi qardaşlarının əlindən qurtarıb atasının yanına qaytarsın. ");
INSERT INTO azb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusif qardaşlarının yanına çatanda onlar Yusifin əyninə geydiyi alabəzək paltarı dartıb çıxartdılar. ");
INSERT INTO azb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Özünü də götürüb quyuya atdılar. Quyu boş idi, orada su yox idi. ");
INSERT INTO azb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Qardaşlar çörək yemək üçün oturdular. Onlar başlarını qaldıranda gördülər ki, Gileaddan İsmaillilərin bir karvanı gəlir. Onların dəvələri ədviyyat, balzam və ətriyyatla yüklənmişdi və bunları Misirə aparırdılar. ");
INSERT INTO azb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yəhuda qardaşlarına dedi: «Əgər qardaşımızı öldürüb qətli ört-basdır etsək, bunun nə xeyri olar? ");
INSERT INTO azb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Gəlin onu İsmaillilərə sataq və ona toxunmayaq, çünki qardaşımızdır, biz eyni qandanıq». Qardaşları onun sözü ilə razılaşdılar. ");
INSERT INTO azb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Oradan Midyan tacirləri keçəndə Yusifi quyudan çıxarıb İsmaillilərə iyirmi gümüşə satdılar. Onlar da Yusifi Misirə apardılar. ");
INSERT INTO azb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruven quyuya tərəf qayıdıb gördü ki, Yusif orada yoxdur. O, paltarını cırdı. ");
INSERT INTO azb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Sonra qardaşlarının yanına qayıdıb dedi: «Uşaq yoxdur, bəs mən nə edim?» ");
INSERT INTO azb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Onlar Yusifin paltarını götürdülər və bir keçi kəsib paltarı qana batırdılar. ");
INSERT INTO azb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Sonra qardaşlar bu əlvan paltarı götürüb atalarına gətirdilər və dedilər: «Biz bunu tapdıq: gör, oğlunun paltarıdır ya yox?» ");
INSERT INTO azb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","O, paltarı tanıyıb dedi: «Bu, oğlumun paltarıdır; yəqin onu vəhşi bir heyvan yeyib. Həqiqətən, Yusif parçalanıb». ");
INSERT INTO azb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaqub öz paltarını cırdı və belinə çul bağladı; o uzun müddət oğlu üçün yas tutdu. ");
INSERT INTO azb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bütün oğulları və qızları ona təsəlli vermək üçün yığışdı, ancaq o təsəlli tapmaq istəməyib dedi: «Kədərlə oğlumun yanına – ölülər diyarına enəcəyəm». Beləcə atası onun üçün ağladı. ");
INSERT INTO azb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midyanlılar isə Yusifi Misirdə fironun bir əyanı olan mühafizəçilər rəisi Potifara satdılar. ");
INSERT INTO azb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","O zaman Yəhuda qardaşlarından ayrılaraq Xira adlı Adullamlı bir adamın yanına gedib məskən saldı. ");
INSERT INTO azb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yəhuda orada Şua adlı Kənanlı bir adamın qızını gördü. Yəhuda qızı arvad alıb yanına girdi. ");
INSERT INTO azb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Qadın hamilə olub bir oğlan doğdu və Yəhuda onun adını Er qoydu. ");
INSERT INTO azb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Qadın yenə hamilə olub bir oğlan doğdu və adını Onan qoydu. ");
INSERT INTO azb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Sonra yenə də bir oğlan doğub, adını Şela qoydu. Qadın onu doğduğu zaman Yəhuda Kezivdə idi. ");
INSERT INTO azb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yəhuda ilk oğlu Er üçün bir arvad aldı, onun adı Tamar idi. ");
INSERT INTO azb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yəhudanın ilk oğlu Er Rəbbin gözündə pis idi və Rəbb onu öldürdü. ");
INSERT INTO azb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yəhuda Onana dedi: «Qardaşın arvadının yanına gir, öz qayınlıq vəzifəni yerinə yetirib qardaşın üçün nəsil yetişdir». ");
INSERT INTO azb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan bilirdi ki, bu nəsil ona məxsus olmayacaq. Buna görə də qardaşı arvadının yanına girəndə toxumunu yerə tökərdi ki, qardaşı üçün nəsil yetişdirməsin. ");
INSERT INTO azb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onun etdiyi bu iş Rəbbin gözündə pis oldu və Rəbb onu da öldürdü. ");
INSERT INTO azb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yəhuda gəlini Tamara dedi: «Atanın evinə qayıt, oğlum Şela böyüyənə qədər dul olaraq qal». Yəhuda fikirləşdi ki, Şela da qardaşları kimi ölə bilər. Tamar gedib atasının evində qaldı. ");
INSERT INTO azb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Uzun müddətdən sonra Şuanın qızı olan Yəhudanın arvadı öldü. Yəhuda matəm qurtarandan sonra dostu Adullamlı Xira ilə birlikdə Timnata sürüsünü qırxanların yanına getdi. ");
INSERT INTO azb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamara bildirdilər: «Bax qayınatan sürüsünü qırxmaq üçün Timnata gəlir». ");
INSERT INTO azb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar dulluq paltarını əynindən çıxarıb rübənd örtdü və bürünüb Timnata gedən yolda olan Enayim darvazasının yanında oturdu. Çünki o görürdü ki, Şela böyüyüb, o isə hələ də Şelaya ərə verilməyib. ");
INSERT INTO azb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yəhuda onu görəndə elə bildi ki, bir fahişə qadındır, çünki üzünü örtmüşdü. ");
INSERT INTO azb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yəhuda yolunu ona tərəf salıb dedi: «İcazə ver, sənin yanına girim». Ancaq onun öz gəlini olduğunu bilmədi. Qadın dedi: «Yanıma girmək üçün mənə nə verirsən?» ");
INSERT INTO azb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yəhuda dedi: «Sürüdən bir oğlaq göndərərəm». O dedi: «Onu göndərənə qədər mənə girov olaraq bir şey verərsənmi?» ");
INSERT INTO azb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yəhuda soruşdu: «Girov olaraq sənə nə verim?» Qadın dedi: «Öz möhürünü, qaytanını və əlində olan əsanı». Yəhuda bunları qadına verib yanına girdi. Qadın ondan hamilə qaldı. ");
INSERT INTO azb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Sonra Tamar qalxıb getdi və rübəndini çıxarıb dulluq paltarını geydi. ");
INSERT INTO azb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yəhuda qadından girovunu almaq üçün Adullamlı dostunun vasitəsilə oğlağı göndərdi. Ancaq o, qadını tapmadı. ");
INSERT INTO azb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Qadının olduğu yerin adamlarından soruşdu: «Enayimdə yol kənarında olan fahişə haradadır?» Onlar dedilər: «Burada fahişə yoxdur». ");
INSERT INTO azb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","O, Yəhudanın yanına qayıdıb dedi: «Onu tapa bilmədim. O yerin adamları da “burada fahişə yoxdur” dedilər». ");
INSERT INTO azb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yəhuda dedi: «Qoy bu şeylər onunku olsun, ancaq biz bu işdən rüsvay olmayaq. Bax mən bu oğlağı ona göndərdim, amma sən onu tapmadın». ");
INSERT INTO azb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bundan təxminən üç ay sonra Yəhudaya bildirdilər: «Gəlinin Tamar zina edib, həm də bu zinadan hamilə qalıb». Yəhuda dedi: «Onu çıxarıb yandırın». ");
INSERT INTO azb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","O bayıra çıxarıldığı zaman qayınatasına xəbər göndərib dedi: «Mən bu şeylərin sahibi olan adamdan hamilə qaldım». Sonra dedi: «Bax gör, bu möhür, qaytan və əsa kimindir?» ");
INSERT INTO azb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yəhuda bunları tanıyıb dedi: «O məndən haqlıdır, çünki onu oğlum Şelaya vermədim». Yəhuda onunla bir daha yaxınlıq etmədi. ");
INSERT INTO azb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar doğanda məlum oldu ki, bətnində əkiz var. ");
INSERT INTO azb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Doğuş vaxtı bir uşaq əlini çıxartdı. Mamaça götürüb onun əlinə qırmızı ip bağladı və dedi: «Əvvəlcə bu doğuldu». ");
INSERT INTO azb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ancaq o uşaq əlini geri çəkdi və qardaşı birinci doğuldu. Mamaça dedi: «Özünə necə deşik açdın?» Buna görə də onun adını Peres qoydular. ");
INSERT INTO azb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ondan sonra əlində qırmızı ip olan qardaşı doğuldu. Onun adını Zerah qoydular. ");
INSERT INTO azb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yusif Misirə aparıldı. Fironun bir əyanı – mühafizəçilər rəisi Misirli Potifar onu oraya gətirmiş İsmaillilərdən satın aldı. ");
INSERT INTO azb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Rəbb Yusiflə idi və o, işlərində uğur qazanırdı. Yusif Misirli ağasının evində qalırdı. ");
INSERT INTO azb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ağası gördü ki, Rəbb onunladır və etdiyi hər işdə ona uğur verir. ");
INSERT INTO azb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusif ağasının gözündə lütf tapdı və onun şəxsi xidmətçisi oldu. Ağası Yusifi evinə nəzarətçi təyin etdi və özünə məxsus olan hər şeyi onun ixtiyarına verdi. ");
INSERT INTO azb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Evinin və özünə məxsus olan hər şeyin ixtiyarını ona verən vaxtdan bəri Rəbb Yusifə görə Misirlinin evinə bərəkət verdi, evində, tarlasında və özünə məxsus olan hər şeydə Rəbbin bərəkəti göründü. ");
INSERT INTO azb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ağası özünə məxsus olan hər şeyi Yusifin ixtiyarına vermişdi, yediyi yeməkdən başqa, evində olan heç nədən xəbəri yox idi. Yusif gözəl və yaraşıqlı idi. ");
INSERT INTO azb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Bir müddət sonra ağasının arvadının Yusifə gözü düşüb dedi: «Gəl mənimlə yat». ");
INSERT INTO azb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ancaq Yusif bundan imtina edib ağasının arvadına dedi: «Mən burada olarkən ağam evində nə olduğunu bilmir və özünə məxsus olan hər şeyi mənim ixtiyarıma verib. ");
INSERT INTO azb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Bu evdə isə hətta o məndən böyük deyil və səndən başqa heç bir şeyi məndən əsirgəmədi, çünki sən onun arvadısan. Bəs mən necə bu böyük pisliyi edib Allahın önündə günaha bata bilərəm?» ");
INSERT INTO azb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Qadın hər gün bunu Yusifə deyirdi, Yusif isə onunla yatmağa, hətta birgə olmağa razı olmurdu. ");
INSERT INTO azb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Bir gün Yusif öz işini görmək üçün evə girdi. İçəridə ev adamlarından heç kəs yox idi. ");
INSERT INTO azb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Qadın «Mənimlə yat!» deyib onun paltarından tutdu. Yusif paltarını onun əlində qoyub qaçdı və bayıra çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Qadın onun paltarını əlində qoyub qaçdığını görəndə ");
INSERT INTO azb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ev adamlarını çağırıb dedi: «Baxın, ağanız bu İbranini bizi təhqir etmək üçün yanımıza gətirib. O mənimlə yatmaq üçün yanıma gəldi, mən isə ucadan qışqırdım. ");
INSERT INTO azb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","O, səsimi ucaldıb qışqırdığımı görəndə paltarını yanımda qoyub qaçdı və bayıra çıxdı». ");
INSERT INTO azb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Yusifin ağası evə gələnə qədər qadın onun paltarını özündə saxladı. ");
INSERT INTO azb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sonra ərinə də bu sözləri söyləyib dedi: «Bizə gətirdiyin bu İbrani qul məni təhqir etmək üçün yanıma gəldi. ");
INSERT INTO azb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Səsimi ucaldıb qışqırdığım zaman paltarını yanımda qoyub bayıra qaçdı». ");
INSERT INTO azb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yusifin ağası arvadının «sənin qulun mənimlə belə rəftar etdi» sözlərini eşidəndə bərk qəzəbləndi. ");
INSERT INTO azb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ağası Yusifi götürüb padşahın məhbuslarının saxlanıldığı zindana təhvil verdi. Yusif zindanda qaldı. ");
INSERT INTO azb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ancaq Rəbb Yusiflə idi və ona xeyirxahlıq göstərdi. O, zindanın baş nəzarətçisinin gözündə lütf tapdı. ");
INSERT INTO azb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Zindanın baş nəzarətçisi zindanda olan bütün məhbusları Yusifin ixtiyarına verdi. Orada görülən hər işə o başçılıq edirdi. ");
INSERT INTO azb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Zindanın baş nəzarətçisi Yusifin ixtiyarında olan heç nəyə nəzarət etmirdi, çünki Rəbb Yusiflə idi və etdiyi hər işdə ona uğur verirdi. ");
INSERT INTO azb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bir müddət sonra Misir padşahının saqisi və çörəkçisi ağaları Misir padşahına qarşı günah etdilər. ");
INSERT INTO azb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Firon bu iki əyanına – baş saqiyə və baş çörəkçiyə bərk qəzəbləndi ");
INSERT INTO azb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","və onları mühafizəçilər rəisinin evində – Yusifin məhbus olduğu zindanda saxladı. ");
INSERT INTO azb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mühafizəçilər rəisi Yusifi onlara xidmətçi təyin etdi və Yusif də onlara xidmət etdi. Onlar bir müddət zindanda qaldılar. ");
INSERT INTO azb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Bir gün Misir padşahının zindanda məhbus olan saqisi və çörəkçisi yuxu gördülər. Hər ikisi bir gecədə müxtəlif mənalı yuxular gördü. ");
INSERT INTO azb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Səhər Yusif onların yanına gəldi və kədərli olduqlarını gördü. ");
INSERT INTO azb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yusif onunla birgə ağasının evində, zindanda olan firon əyanlarından soruşdu: «Niyə bu gün üzünüz kədərlidir?» ");
INSERT INTO azb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Onlar Yusifə dedilər: «Yuxu görmüşük, ancaq onu yozan yoxdur». Yusif onlara dedi: «Yuxu yozmaq Allahın işi deyilmi? Onu mənə danışın». ");
INSERT INTO azb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Baş saqi yuxusunu Yusifə danışıb dedi: «Yuxumda gördüm ki, önümdə bir üzüm tənəyi var. ");
INSERT INTO azb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tənəkdə üç budaq var idi. Onlarda tumurcuqlar görünüb çiçək açdı və salxımlar yetişdi. ");
INSERT INTO azb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Fironun piyaləsi mənim əlimdə idi. Üzümləri götürüb fironun piyaləsinə sıxdım və piyaləni firona verdim». ");
INSERT INTO azb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusif ona dedi: «Onun yozması belədir: üç budaq üç gündür. ");
INSERT INTO azb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Üç gün ərzində firon səni yüksəldəcək. Səni öz işinə qaytaracaq, sən də onun saqisi olduğun vaxtdakı kimi əvvəlki qaydaya görə fironun piyaləsini əlinə verəcəksən. ");
INSERT INTO azb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ancaq sənin vəziyyətin yaxşılaşanda məni yadına sal və xeyirxahlıq göstər. Haqqımda firona danışıb məni bu yerdən çıxart. ");
INSERT INTO azb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Doğrudan da, mən İbranilərin torpağından oğurlanmışam və burada da zindana salınmağa layiq bir iş görməmişəm». ");
INSERT INTO azb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Baş çörəkçi Yusifin yuxunu yaxşılığa yozduğunu görüb ona dedi: «Mən isə yuxuda gördüm ki, başımın üstündə üç səbət ağ çörək var. ");
INSERT INTO azb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ən üstdəki səbətdə çörəkçinin firon üçün bişirdiyi hər cür çörək var. Quşlar başımın üstündəki səbətdən onları yeyirdi». ");
INSERT INTO azb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusif belə cavab verdi: «Onun yozması belədir: üç səbət üç gündür. ");
INSERT INTO azb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Üç gün ərzində firon sənin başını bədənindən ayıracaq, özünü də ağacdan asacaq və quşlar sənin ətini didəcək». ");
INSERT INTO azb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Üçüncü gün – fironun ad günü o bütün əyanlarına ziyafət verdi. Baş saqini və baş çörəkçini əyanlarının önünə çıxartdı. ");
INSERT INTO azb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Baş saqini saqiliyinə qaytardı və o, piyaləni fironun əlinə verdi, ");
INSERT INTO azb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","baş çörəkçini isə asdırdı; hər şey Yusifin yozduğu kimi oldu. ");
INSERT INTO azb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ancaq baş saqi Yusifi yada salmadı və onu unutdu. ");
INSERT INTO azb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","İki il keçəndən sonra firon belə bir yuxu gördü: o, Nil çayının sahilində dayanmışdı. ");
INSERT INTO azb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Çaydan yeddi bəslənmiş və kök inək çıxdı. Onlar qamışlıq içində otlamağa başladı. ");
INSERT INTO azb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Onlardan sonra haldan düşmüş və arıq olan başqa yeddi inək Nil çayından çıxdı. Onlar çayın sahilindəki inəklərin yanında dayandılar. ");
INSERT INTO azb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Haldan düşmüş və arıq inəklər bəslənmiş və kök olan yeddi inəyi yedilər. Onda firon yuxudan oyandı. ");
INSERT INTO azb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Sonra yatıb ikinci dəfə bu yuxunu gördü: bir saplaqdan yeddi dolu və yaxşı sünbül çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Onlardan sonra isə cılız və şərq küləyindən yanmış yeddi sünbül bitdi. ");
INSERT INTO azb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Cılız sünbüllər yeddi böyük və dolu sünbülü uddular. Onda firon oyandı; bu bir yuxu idi. ");
INSERT INTO azb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Səhəri gün onun ürəyi narahat oldu. O xəbər göndərib Misirin bütün sehrbazlarını və müdriklərini çağırdı. Firon onlara öz yuxusunu danışdı, ancaq onların arasında fironun yuxusunu yozan bir adam tapılmadı. ");
INSERT INTO azb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Baş saqi firona belə söylədi: «Mən bu gün öz günahımı yadıma saldım: ");
INSERT INTO azb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","bir dəfə firon qullarına qəzəbləndi və mənimlə baş çörəkçini zindana, mühafizəçilər rəisinin evinə saldı. ");
INSERT INTO azb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Biz bir gecə yuxu gördük, hər birimiz müxtəlif mənalı yuxular gördük. ");
INSERT INTO azb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Orada bizimlə birgə mühafizəçilər rəisinin qulu olan bir İbrani gənc var idi. Biz ona danışdıq, o da yuxularımızı yozdu, hər birimizə yuxusunun mənasını izah etdi. ");
INSERT INTO azb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","O bizə necə yozmuşdusa, elə də oldu: mən öz vəzifəmə qaytarıldım, baş çörəkçi isə asıldı». ");
INSERT INTO azb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Firon xəbər göndərib Yusifi çağırdı. Onu tez zindandan çıxartdılar. O, başını qırxıb paltarlarını dəyişdi və fironun hüzuruna gəldi. ");
INSERT INTO azb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Firon Yusifə dedi: «Bir yuxu görmüşəm, ancaq onu yozan yoxdur. Mən sənin barəndə eşitmişəm ki, yuxuları eşidib yoza bilirsən». ");
INSERT INTO azb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusif firona cavab verdi: «Bu məndən deyil, Allah fironun xeyrinə cavab verəcək». ");
INSERT INTO azb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Firon Yusifə dedi: «Yuxumda gördüm ki, Nil çayının sahilində durmuşam. ");
INSERT INTO azb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Çaydan kök və bəslənmiş yeddi inək çıxdı. Onlar qamışlıq içində otlamağa başladı. ");
INSERT INTO azb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Onlardan sonra halsız, çox cılız və arıq olan başqa yeddi inək çıxdı. Bütün Misir ölkəsində bunlar kimi cılız inək görməmişəm. ");
INSERT INTO azb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Arıq və cılız inəklər əvvəlki yeddi kök inəyi yedilər. ");
INSERT INTO azb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kök inəklər onların qarınlarına girdiklərinə baxmayaraq, bu bilinmirdi, onlar əvvəlki kimi arıq idi. Onda oyandım. ");
INSERT INTO azb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Yenə yuxumda gördüm ki, bir saplaqdan yeddi dolu və böyük sünbül çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Onlardan sonra solğun, cılız və şərq küləyindən yanmış yeddi sünbül bitdi. ");
INSERT INTO azb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Cılız sünbüllər yeddi dolu sünbülü uddular; bunları sehrbazlara danışdım, ancaq izah edən olmadı». ");
INSERT INTO azb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusif firona dedi: «Fironun yuxularının mənası eynidir. Allah etmək istədiyi işi firona bildirdi. ");
INSERT INTO azb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Yeddi bəslənmiş inək yeddi ildir, yeddi dolu sünbül də yeddi ildir; yuxuların mənası eynidir. ");
INSERT INTO azb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Onlardan sonra çıxan yeddi arıq, cılız inək və şərq küləyindən yanmış boş yeddi sünbül də yeddi ildir; yeddi il aclıq olacaq. ");
INSERT INTO azb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Firona demək istədiyim sözlər bunlardır. Allah etmək istədiyi işi firona göstərdi. ");
INSERT INTO azb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Bütün Misir torpağında yeddi il böyük bolluq olacaq. ");
INSERT INTO azb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Bundan sonra yeddi il aclıq olacaq. Misir ölkəsində olan bütün bolluq yaddan çıxacaq və aclıq ölkəni əldən salacaq. ");
INSERT INTO azb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ölkədəki bolluq ondan sonra gələn aclıq üzündən görünməyəcək, çünki aclıq çox ağır olacaq. ");
INSERT INTO azb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Firon yuxunu iki dəfə görüb, çünki Allah belə qərara gəlmişdir və tezliklə bu işi görəcək. ");
INSERT INTO azb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Buna görə də firon ağıllı və müdrik bir adam axtarsın, onu Misir ölkəsinə başçı təyin etsin. ");
INSERT INTO azb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Firon ölkədə məmurlar qoymağı əmr etsin və yeddi il bolluq zamanı Misir torpağının məhsullarının beşdə birini yığsın. ");
INSERT INTO azb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Qoy onlar uğurlu olan bu illərin bütün məhsullarını toplasınlar. Taxılı isə azuqə olaraq şəhərlərdə fironun nəzarəti altında yığıb saxlasınlar. ");
INSERT INTO azb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Bu azuqə Misir torpağına gələn yeddi il aclıq dövrü üçün ehtiyat olacaq, ta ki ölkə əhalisi aclıqdan qırılmasın». ");
INSERT INTO azb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Bu sözlər fironun və onun əyanlarının xoşuna gəldi. ");
INSERT INTO azb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Firon əyanlarına dedi: «Bu adam kimi Allahın Ruhuna malik olan bir kəs tapa biləcəyikmi?» ");
INSERT INTO azb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Sonra firon Yusifə dedi: «İndi ki Allah sənə bütün bu şeyləri bildirdi, deməli, sənin kimi ağıllı və müdrik adam yoxdur. ");
INSERT INTO azb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Sən mənim saray adamlarıma başçılıq edəcəksən və bütün xalqım sənin əmrinlə idarə olunacaq. Mən yalnız taxtda səndən böyük olacağam». ");
INSERT INTO azb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Firon yenə Yusifə dedi: «Səni bütün Misir ölkəsinə başçı təyin edirəm». ");
INSERT INTO azb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Firon öz möhürünü barmağından çıxarıb Yusifin barmağına taxdı, ona incə kətan paltar geyindirdi və boynuna qızıl zəncir asdı. ");
INSERT INTO azb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Firon əmr etdi ki, onu özünün ikinci arabasına mindirsinlər və qarşısında «Diz çökün!» deyib bağırsınlar. Beləcə o, Yusifi bütün Misir ölkəsinə başçı qoydu. ");
INSERT INTO azb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firon Yusifə dedi: «Mən fironam. Bütün Misir ölkəsində heç kəs sənsiz əlini yaxud ayağını tərpətməyəcək». ");
INSERT INTO azb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Firon Yusifin adını Safnat-Paneah qoydu və On şəhərinin kahini Poti-Feranın qızı Asnatı ona arvad olmaq üçün verdi. Yusif bütün Misir ölkəsini gəzməyə çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Misir padşahı fironun hüzurunda olarkən Yusif otuz yaşında idi. Yusif fironun hüzurundan çıxıb bütün Misir ölkəsini dolaşdı. ");
INSERT INTO azb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yeddi bolluq ilində torpaq qucaq-qucaq məhsul verdi. ");
INSERT INTO azb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusif yeddi ildə Misir torpağında yığılmış bütün məhsulu topladı. O, məhsulu şəhərlərə qoydu. Hər şəhərin ətrafında olan tarlada yetişən məhsulu o şəhərdə saxladı. ");
INSERT INTO azb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusif dəniz qumu qədər çox taxıl yığdı və daha onu hesablamadı, çünki sayı-hesabı yox idi. ");
INSERT INTO azb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Aclıq illərindən qabaq Yusifin iki oğlu oldu; onları Yusifə On kahini Poti-Feranın qızı Asnat doğdu. ");
INSERT INTO azb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusif ilk oğlunun adını Menaşşe qoydu, çünki demişdi: «Allah bütün zəhmətimi və atamın evindəkilərin hamısını mənə unutdurdu». ");
INSERT INTO azb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","İkinci oğlunun adını Efrayim qoydu, çünki demişdi: «Allah əziyyət çəkdiyim torpaqda məni bəhərli etdi». ");
INSERT INTO azb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Misir torpağında yeddi il bolluq qurtardı. ");
INSERT INTO azb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Yusifin söylədiyi kimi yeddi il aclıq başladı. Bütün ölkələrdə aclıq oldu, lakin Misir torpağının hər yerində ərzaq var idi. ");
INSERT INTO azb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Bütün Misir əhalisi aclıq çəkəndə çörək üçün firona fəryad etdi. Firon bütün Misirlilərə dedi: «Yusifin yanına gedin, onun dediyini edin». ");
INSERT INTO azb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bütün yer üzündə aclıq oldu. Yusif məhsul olan bütün anbarları açıb Misirlilərə taxıl satırdı. Misir torpağında aclıq gücləndi. ");
INSERT INTO azb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bütün ölkələrin adamları taxıl almaq üçün Misirə, Yusifin yanına gəlirdilər, çünki bütün yer üzündə şiddətli aclıq idi. ");
INSERT INTO azb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaqub öyrəndi ki, Misirdə taxıl var. O öz oğullarına dedi: «Nə üçün bir-birinizə baxırsınız?» ");
INSERT INTO azb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yenə dedi: «Mən eşitdim ki, Misirdə taxıl var, gedib oradan bizim üçün taxıl alın ki, ölməyib yaşayaq». ");
INSERT INTO azb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yusifin on qardaşı taxıl almaq üçün Misirə getdi. ");
INSERT INTO azb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ancaq Yaqub Yusifin qardaşı Binyamini qardaşları ilə birgə göndərmədi, çünki fikirləşirdi ki, onun başına bir fəlakət gələ bilər. ");
INSERT INTO azb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Taxıl almağa gələnlər arasında İsrailin oğulları da var idi, çünki Kənan torpağında da aclıq hökm sürürdü. ");
INSERT INTO azb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusif ölkənin başçısı idi və ölkənin bütün əhalisinə də taxılı özü satırdı. Yusifin qardaşları gəlib onun önündə üzlərini yerə qoyub səcdə etdilər. ");
INSERT INTO azb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusif qardaşlarını görüb tanıdı, ancaq onlarla yad adam kimi rəftar edərək sərt danışdı. Yusif onlardan soruşdu: «Haradan gəlirsiniz?» Onlar dedilər: «Ərzaq almaq üçün Kənan torpağından gəlirik». ");
INSERT INTO azb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusif qardaşlarını tanıdı, amma onlar Yusifi tanımadılar. ");
INSERT INTO azb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusif qardaşları barədə gördüyü yuxuları xatırlayıb onlara dedi: «Siz casussunuz, ölkənin zəif yerlərini öyrənmək üçün gəlmisiniz». ");
INSERT INTO azb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Qardaşları ona dedilər: «Xeyr, ey ağamız, qulların yalnız ərzaq almaq üçün gəliblər. ");
INSERT INTO azb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Biz hamımız bir adamın oğullarıyıq. Biz təmiz adamlarıq, qulların casus deyil». ");
INSERT INTO azb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ancaq Yusif onlara dedi: «Xeyr, siz ölkənin zəif yerlərini öyrənmək üçün gəlmisiniz». ");
INSERT INTO azb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Onlar dedilər: «Biz qulların on iki qardaşıq və Kənan torpağında bir adamın oğullarıyıq. Kiçik qardaşımız indi atamızın yanındadır, bir qardaşımız isə yoxa çıxıb». ");
INSERT INTO azb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusif onlara dedi: «Hər şey mən dediyim kimidir: siz casussunuz, ");
INSERT INTO azb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ancaq mən sizi belə yoxlayacağam: fironun canına and olsun ki, kiçik qardaşınız buraya gəlməsə, siz buradan gedə bilməyəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Aranızdan bir nəfəri göndərin ki, qardaşınızı gətirsin, siz isə burada saxlanacaqsınız. Onda sizin düz deyib-demədiyiniz bilinəcək. Yoxsa fironun canına and olsun ki, siz casussunuz». ");
INSERT INTO azb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yusif üç gün onları zindanda saxladı. ");
INSERT INTO azb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Üçüncü gün Yusif onlara dedi: «Dediyimə əməl edib canınızı qurtarın, çünki mən Allahdan qorxuram. ");
INSERT INTO azb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Əgər siz təmiz adamsınızsa, qoy qardaşlarınızdan biri həbs olunduğunuz yerdə qalsın, siz isə gedib ailələrinizi aclıqdan qurtarmaq üçün taxıl aparın. ");
INSERT INTO azb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Sonra kiçik qardaşınızı mənim yanıma gətirin. Beləcə düz dediyinizi biləcəyəm və canınızı qurtaracaqsınız». Qardaşlar belə də etdilər. ");
INSERT INTO azb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Onlar bir-birlərinə dedilər: «Doğrudan da, biz qardaşımızın qarşısında təqsirkarıq. O bizə yalvardığı vaxt çəkdiyi əziyyəti gördük, ancaq ona qulaq asmadıq. Buna görə də başımıza bu bəla gəldi». ");
INSERT INTO azb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruven onlara belə cavab verdi: «Mən demədimmi uşağa pislik etməyin, lakin siz mənə qulaq asmadınız. İndi isə onun qanına görə cəza çəkirik». ");
INSERT INTO azb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Qardaşları Yusifin onları başa düşdüyünü bilmirdilər, çünki onlar tərcüməçi vasitəsilə danışırdılar. ");
INSERT INTO azb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusif onların yanından kənara çəkilib ağladı. Sonra qardaşlarının yanına qayıdıb onlarla söhbət etdi. Aralarından Şimeonu götürüb qardaşlarının gözü qabağında onun əl-qolunu bağladı. ");
INSERT INTO azb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusif əmr etdi ki, onların çuvalları taxılla doldurulsun, hər birinin verdiyi pul da öz çuvalına qoyulsun və onlara yol üçün azuqə verilsin. Belə də edildi. ");
INSERT INTO azb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Qardaşlar taxıllarını eşşəklərinin belinə yükləyib oradan getdilər. ");
INSERT INTO azb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Onlardan biri gecələdiyi yerdə eşşəyinə yem vermək üçün çuvalını açanda öz pulunu gördü: pul çuvalın ağzında idi. ");
INSERT INTO azb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","O, qardaşlarına dedi: «Pulum özümə qaytarılıb, budur, o, çuvalımın içindədir». Qardaşların ürəyi həyəcana düşdü və onlar qorxa-qorxa bir-birlərinə dedilər: «Allah bizim başımıza nə iş gətirdi?» ");
INSERT INTO azb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Onlar Kənan torpağına, ataları Yaqubun yanına gəldilər və başlarına gələn bütün hadisələri ona danışıb dedilər: ");
INSERT INTO azb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«O ölkənin başçısı olan adam bizimlə sərt danışdı, bizi ölkəyə gələn casuslar hesab etdi. ");
INSERT INTO azb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ona dedik: “Biz təmiz adamlarıq, casus deyilik. ");
INSERT INTO azb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Biz bir atanın oğulları, on iki qardaşıq. Bir qardaşımız yoxa çıxıb, biri də indi Kənan torpağında atamızın yanındadır”. ");
INSERT INTO azb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","O ölkənin başçısı olan adam bizə dedi: “Sizin təmiz adam olduğunuzu bundan biləcəyəm: qardaşlarınızdan birini yanımda qoyub, ailələrinizi aclıqdan qurtarmaq üçün taxıl götürərək gedin. ");
INSERT INTO azb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Sonra kiçik qardaşınızı yanıma gətirin. O zaman sizin casus deyil, təmiz adam olduğunuzu biləcəyəm. Onda qardaşınızı sizə təhvil verəcəyəm və ölkədə alver edə bilərsiniz”». ");
INSERT INTO azb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Qardaşlar çuvallarını boşaldarkən gördülər ki, hər kəsin çuvalında pul kisəsi var. Özləri və onların atası pul kisələrini görəndə qorxdular. ");
INSERT INTO azb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ataları Yaqub onlara dedi: «Siz məni övladsız qoydunuz. Yusif yox, Şimeon yox, Binyamini də aparacaqsınız. Bütün bunları mənim başıma gətirmək istəyirsiniz». ");
INSERT INTO azb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruven atasına belə dedi: «Əgər onu sənin yanına gətirməsəm, iki oğlumu öldürərsən. Onu mənim ixtiyarıma ver, mən də onu qaytarıb yanına gətirəcəyəm». ");
INSERT INTO azb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaqub dedi: «Oğlum sizinlə getməyəcək, çünki onun qardaşı ölüb və tək qalıb. Əgər getdiyiniz yolda onun başına bir iş gəlsə, mənim ağ saçlı başımı kədər içində ölülər diyarına endirəcəksiniz». ");
INSERT INTO azb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kənan torpağında aclıq güclənmişdi. ");
INSERT INTO azb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Qardaşların Misirdən gətirdiyi buğda yeyilib tükənəndə ataları onlara dedi: «Yenə gedib bizə bir az ərzaq alın». ");
INSERT INTO azb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yəhuda ona belə söylədi: «O adam bizə ciddi xəbərdarlıq edib dedi ki, əgər qardaşınız sizinlə gəlməsə, gözümə görünməyin. ");
INSERT INTO azb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Əgər sən qardaşımızı bizimlə göndərsən, gedib ərzaq alarıq. ");
INSERT INTO azb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ancaq onu göndərməsən, getməyəcəyik, çünki o adam bizə dedi ki, qardaşınız sizinlə gəlməsə, gözümə görünməyin». ");
INSERT INTO azb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","İsrail dedi: «Niyə o adama daha bir qardaşınız olduğunu bildirib mənə pislik etdiniz?» ");
INSERT INTO azb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Onlar dedilər: «O adam özümüz və ailəmiz barədə dəfələrlə bizə belə suallar verdi: “İndi atanız sağdırmı? Başqa qardaşlarınız varmı?” Biz də onun bu suallarına cavab verdik. Ağlımıza gələrdi ki, o bizə “qardaşınızı gətirin” deyəcək?» ");
INSERT INTO azb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Sonra Yəhuda atası İsrailə dedi: «Uşağı mənimlə göndər ki, qalxıb gedək. Sən də, biz də, uşaqlarımız da ölməyib sağ qalarıq. ");
INSERT INTO azb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mən ona zamin dururam, onu məndən tələb edərsən. Əgər onu sənin yanına gətirib qarşında dayandırmasam, ömrüm boyu önündə təqsirkar olacağam. ");
INSERT INTO azb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Çünki biz gecikməsəydik, indi iki dəfə gedib-qayıdardıq». ");
INSERT INTO azb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ataları İsrail onlara dedi: «Əgər belədirsə, bunu edin: torbalarınızda bu torpağın ən yaxşı məhsullarından o adama hədiyyə olaraq bir qədər balzam, bal, ədviyyat, ətriyyat, püstə və badam götürün. ");
INSERT INTO azb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Özünüzlə iki qat artıq pul götürün. Çuvallarınızın içində geri qaytarılmış pulu öz əllərinizlə aparıb verin, bəlkə bir səhv olub. ");
INSERT INTO azb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Qardaşlarınızı götürüb gedin və o adamın yanına qayıdın. ");
INSERT INTO azb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Külli-İxtiyar Allah o adamda sizə qarşı mərhəmət oyandırsın, o da digər qardaşınızı və Binyamini sizə təhvil versin. Mən uşaqlarımdan məhrum olacağamsa, qoy olum». ");
INSERT INTO azb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Qardaşlar özləri ilə hədiyyə və iki qat artıq pul götürdülər. Binyamini də götürüb qalxdılar və Misirə gəlib Yusifin önündə durdular. ");
INSERT INTO azb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusif Binyamini onlarla bərabər görəndə öz ev nəzarətçisinə dedi: «Bu adamları evə apar və heyvan kəsib hazırla, çünki onlar mənimlə nahar edəcəklər». ");
INSERT INTO azb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","O adam Yusifin dediyinə əməl etdi: bu adamları Yusifin evinə apardı. ");
INSERT INTO azb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bu adamlar Yusifin evinə aparıldıqları üçün qorxub dedilər: «Keçən dəfə çuvallarımızda geri qaytarılmış pul üstündə bizi aparırlar. O istəyir ki, bizə qarşı bəhanə tapıb üstümüzə düşsün, bizi özünə qul etsin və eşşəklərimizi alsın». ");
INSERT INTO azb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Onlar Yusifin ev nəzarətçisinə yaxınlaşdılar və evin astanasında ona belə söylədilər: ");
INSERT INTO azb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Ey ağamız, keçən dəfə biz ərzaq almaq üçün gəlmişdik. ");
INSERT INTO azb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ancaq gecələdiyimiz yerə çatdığımız zaman çuvallarımızı açıb gördük ki, hər birimizin pulu çəkisi əskik olmayaraq çuvalımızın içindədir. İndi onu öz əllərimizlə geri qaytarırıq. ");
INSERT INTO azb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ərzaq almaq üçün özümüzlə başqa pul da gətirmişik. O pulu isə çuvallarımıza kimin qoyduğunu bilmirik». ");
INSERT INTO azb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ev nəzarətçisi dedi: «Narahat olmayın, qorxmayın. Özünüzün və atanızın Allahı sizə çuvallarınızda xəzinə verdi. Pulunuz mənə gəlib çatdı». Sonra Şimeonu onların yanına gətirdi. ");
INSERT INTO azb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","O adam qardaşları Yusifin evinə gətirdi. Ayaqlarını yumaq üçün onlara su verdi və eşşəklərinə yem verdi. ");
INSERT INTO azb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Qardaşlar Yusif nahara gələnə qədər hədiyyəni hazırladılar, çünki orada yemək yeyəcəklərini eşitdilər. ");
INSERT INTO azb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusif evə gələndə onlar hədiyyəni otağa gətirib təqdim etdilər, onun önündə yerə qədər əyilib səcdə etdilər. ");
INSERT INTO azb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusif onların kefini soruşub dedi: «O dediyiniz qoca atanız salamatdırmı? Hələ də yaşayırmı?» ");
INSERT INTO azb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Onlar dedilər: «Sənin qulun atamız salamatdır, hələ də yaşayır». Onlar Yusifə əyilib təzim etdilər. ");
INSERT INTO azb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusif başını qaldıranda öz anasının oğlu olan qardaşı Binyamini görüb dedi: «Mənə söylədiyiniz kiçik qardaşınız budurmu?» Sonra Binyaminə dedi: «Ey oğlum, Allah sənə lütf etsin». ");
INSERT INTO azb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusif tələsik oradan çıxdı, çünki qardaşını görəndə ürəyi sızıldadı, onu ağlamaq tutdu və otağa girib orada ağladı. ");
INSERT INTO azb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sonra üzünü yuyub çıxdı, özünə gəlib dedi: «Yemək gətirin». ");
INSERT INTO azb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yeməyi ona ayrıca, qardaşlarına ayrıca, onunla birgə yeyən Misirlilərə isə ayrıca qoydular, çünki Misirlilər İbranilərlə birgə yemək yeməzdilər; bu, Misirlilər üçün iyrənc bir şey idi. ");
INSERT INTO azb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Qardaşlar böyük-kiçikliyinə görə Yusifin hüzurunda oturdular. Onlar bir-birlərinə baxıb çaşdılar. ");
INSERT INTO azb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusifin önündəki yeməklərdən onlara pay ayrıldı. Ancaq Binyaminin payı onların hər birinin payından beş qat artıq idi. Onlar yeyib-içdilər və onunla bərabər xoş vaxt keçirdilər. ");
INSERT INTO azb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusif öz ev nəzarətçisinə əmr edib dedi: «Bu adamların çuvallarını gücləri çatana qədər ərzaqla doldur və hər kəsin pulunu öz çuvalının ağzına qoy. ");
INSERT INTO azb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kiçiyinin çuvalının ağzına isə mənim kasamı – gümüş kasanı və taxıl əvəzinə verilən pulu qoy». O, Yusifin dediyi sözə əməl etdi. ");
INSERT INTO azb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Səhər açılanda bu adamları eşşəkləri ilə birgə yola saldılar. ");
INSERT INTO azb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Onlar hələ şəhərdən uzaqlaşmamışdı ki, Yusif öz ev nəzarətçisinə dedi: «Qalx o adamların dalınca get və onlara çatdığın zaman belə söylə: “Nə üçün yaxşılığa pisliklə cavab verdiniz? ");
INSERT INTO azb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bu kasa ağamın içdiyi və onunla baxıcılıq etdiyi kasa deyilmi? Siz çox pis iş tutdunuz”». ");
INSERT INTO azb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ev nəzarətçisi onlara çatdı və bu sözləri söylədi. ");
INSERT INTO azb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Qardaşlar ona dedilər: «Nə üçün ağam belə sözlər söyləyir? Bu iş qullarından uzaq olsun. ");
INSERT INTO azb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Biz çuvalımızın içində tapdığımız pulu Kənan torpağından sənə geri qaytardıq. Ağanın evindən necə qızıl yaxud gümüş oğurlaya bilərik? ");
INSERT INTO azb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Qoy bu şey qullarından kimdə tapılsa, o adam öldürülsün və biz də ağamıza qul olaq». ");
INSERT INTO azb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","O dedi: «Yaxşı, qoy siz deyən kimi olsun: bu kimin yanında tapılsa, o mənə qul olsun, qalanlarınız isə təqsirkar olmayacaqsınız». ");
INSERT INTO azb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Onların hər biri tələsik çuvalını yerə endirdi və çuvalının ağzını açdı. ");
INSERT INTO azb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ev nəzarətçisi böyükdən başlayıb kiçiyə qədər onları axtardı və kasa Binyaminin çuvalından tapıldı. ");
INSERT INTO azb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Qardaşlar paltarlarını cırdılar və hər biri eşşəyini yükləyib şəhərə qayıtdı. ");
INSERT INTO azb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yəhuda qardaşları ilə birgə Yusifin evinə gəldi. O hələ də orada idi. Onlar Yusifin önündə yerə qapandılar. ");
INSERT INTO azb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusif onlara dedi: «Bu nə işdir, görmüsünüz? Güman etmədiniz ki, mənim kimi bir adam baxıcılıq edə bilər?» ");
INSERT INTO azb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yəhuda dedi: «Ağama nə deyim, nə söyləyim? Özümüzü necə təmizə çıxara bilərik? Allah öz qullarında təqsir gördü. İndi biz də, yanında kasa tapılan adam da ağamızın quluyuq». ");
INSERT INTO azb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","O dedi: «Yox, mən belə etməyəcəyəm. Yalnız yanında kasa tapılan adam mənə qul olacaq, siz isə sağ-salamat atanızın yanına gedin». ");
INSERT INTO azb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yəhuda ona yaxınlaşıb dedi: «Ey ağam, xahiş edirəm ki, qulunun dediyi sözlərə qulaq as və quluna qarşı qəzəbin alovlanmasın, çünki sən firon kimi bir adamsan. ");
INSERT INTO azb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","O zaman ağam qullarından “Sizin atanız yaxud qardaşınız varmı?” deyə soruşanda ");
INSERT INTO azb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","biz ağamıza söyləmişdik: “Bizim bir qoca atamız və onun da ixtiyar çağında doğulan bir kiçik uşağı var. Onun bir qardaşı öldü, anasından doğulan yalnız o qaldı. Atası onu çox sevir”. ");
INSERT INTO azb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Sən qullarına demişdin: “Onu mənim yanıma gətirin ki, öz gözümlə görüm”. ");
INSERT INTO azb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Biz də ağamıza demişdik: “Uşaq atasından ayrıla bilməz, çünki atasından ayrılsa, atası ölər”. ");
INSERT INTO azb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Amma sən qullarına demişdin: “Əgər kiçik qardaşınız sizinlə gəlməsə, bir daha gözümə görünməyin”. ");
INSERT INTO azb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Sənin qulun atamın yanına gəldiyimiz zaman ağamızın sözlərini ona çatdırdıq. ");
INSERT INTO azb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Atamız dedi: “Yenə gedin, bizə bir az ərzaq alıb gətirin”. ");
INSERT INTO azb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Biz dedik: “Gedə bilmərik. Kiçik qardaşımız bizimlə getsə, gedərik, kiçik qardaşımız bizimlə getməsə, o adamın gözünə görünə bilmərik”. ");
INSERT INTO azb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Sənin qulun atam bizə dedi: “Bilirsiniz ki, arvadım mənə iki oğul doğdu. ");
INSERT INTO azb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Bir oğlum yanımdan getdi və dedim ki, onu yəqin vəhşi bir heyvan parçalayıb; indiyə qədər o oğlumu görməmişəm. ");
INSERT INTO azb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Bu oğlumu da yanımdan aparsanız və onun başına bir iş gəlsə, ağ saçlı başımı kədər içində ölülər diyarına endirəcəksiniz”. ");
INSERT INTO azb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","İndi sənin qulun atamın yanına qayıtdığım zaman uşaq bizimlə olmasa və ürəyi bütün sevgisi ilə uşağa bağlanan atamız ");
INSERT INTO azb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","onu görməsə, ölər. Onda biz qulların qulun atamızın ağ saçlı başını kədər içində ölülər diyarına endirərik. ");
INSERT INTO azb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mən qulun, atama uşaq üçün zamin durub dedim: “Əgər onu sənin yanına gətirməsəm, atamın önündə ömrüm boyu təqsirkar olacağam”. ");
INSERT INTO azb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","İndi xahiş edirəm, qoy uşağın əvəzinə mən ağama qul olmaq üçün qalım, uşaq isə qardaşlarımla birgə getsin. ");
INSERT INTO azb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Çünki o mənimlə olmasa, necə atamın yanına gedə bilərəm? Onda mən atamın başına fəlakət gəldiyini görərəm». ");
INSERT INTO azb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusif yanında duranların hamısının önündə özünü saxlaya bilməyib qışqırdı: «Hamını yanımdan çıxarın». Yusif özünü qardaşlarına tanıtdığı zaman yanında heç kəs yox idi. ");
INSERT INTO azb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","O hönkürüb ağladı. Misirlilər və fironun saray adamları eşitdilər. ");
INSERT INTO azb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusif qardaşlarına dedi: «Mən Yusifəm. Atam hələ sağdırmı?» Qardaşları ona cavab vermədilər, çünki çaşıb qalmışdılar. ");
INSERT INTO azb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusif qardaşlarına dedi: «Mənə yaxın gəlin». Onlar yaxın gəldilər. Yusif dedi: «Misirə satdığınız qardaşınız Yusif mənəm. ");
INSERT INTO azb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","İndi məni buraya satdığınız üçün kədərlənməyin və təəssüflənməyin, çünki Allah həyatınızı qorumaq üçün məni sizdən qabaq buraya göndərdi. ");
INSERT INTO azb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Artıq iki ildir ki, ölkədə aclıqdır, hələ beş il də əkin-biçin olmayacaq. ");
INSERT INTO azb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Allah məni sizdən qabaq buraya göndərdi ki, sizi yer üzündə saxlasın və böyük bir qurtuluşla həyatınızı qorusun. ");
INSERT INTO azb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ona görə də məni buraya göndərən siz deyilsiniz, Allahdır. O məni firona ata, onun bütün saray adamlarına ağa, bütün Misir ölkəsinə isə başçı etdi. ");
INSERT INTO azb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tez atamın yanına gedib ona söyləyin ki, oğlun Yusif belə deyir: “Allah məni bütün Misir ölkəsinə ağa etdi. Daha durma, yanıma gəl. ");
INSERT INTO azb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Qoşen vilayətində yaşayarsan. Özün, oğulların, nəvələrin, qoyun-keçin, mal-qaran – sənin hər şeyin mənə yaxın olar. ");
INSERT INTO azb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Orada sənin qayğına qalaram, çünki daha beş il aclıq olacaq. Yoxsa özün, ailən və bütün yaxın adamların yoxsulluq çəkəcək”. ");
INSERT INTO azb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","İndi sizin və qardaşım Binyaminin gözləri görür ki, bu sözləri dilimlə sizə deyirəm. ");
INSERT INTO azb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Misirdə sahib olduğum böyük izzəti və bütün gördüklərinizi atama bildirin və tezliklə atamı buraya gətirin». ");
INSERT INTO azb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yusif qardaşı Binyaminin boynuna sarılıb ağladı, Binyamin də onun boynuna sarılıb ağladı. ");
INSERT INTO azb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusif bütün qardaşlarını öpdü və onların boynuna sarılıb ağladı. Bundan sonra qardaşları onunla söhbət etdilər. ");
INSERT INTO azb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yusifin qardaşlarının gəlməsi barədə fironun sarayına xəbər çatdı. Bu xəbər fironun və onun əyanlarının xoşuna gəldi. ");
INSERT INTO azb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Firon Yusifə dedi: «Qardaşlarına söylə ki, belə etsinlər: heyvanlarınızı yükləyin və yola düşüb Kənan torpağına gedin. ");
INSERT INTO azb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Atanızı və ev adamlarınızı götürüb yanıma gəlin. Sizə Misir ölkəsində ən yaxşı torpağı verəcəyəm, torpağın şirəsini yeyəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Sənə isə əmr olunur ki, onlara söyləyəsən: “Belə edin: arvad-uşağınız üçün Misir ölkəsində özünüzə arabalar götürün və atanızı gətirib gəlin”. ");
INSERT INTO azb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Orada qalan şeylərinizdə gözünüz qalmasın, çünki bütün Misir torpağının ən yaxşı şeyləri sizindir». ");
INSERT INTO azb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","İsrailin oğulları belə də etdilər. Yusif fironun əmri ilə onlara arabalar və yol üçün azuqə verdi. ");
INSERT INTO azb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Onların hər birinə bir dəst paltar verdi, Binyaminə isə üç yüz parça gümüş və beş dəst paltar verdi. ");
INSERT INTO azb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yusif atası üçün Misirin ən yaxşı şeyləri ilə yüklənmiş on eşşək, yol üçün taxıl, çörək və azuqə yüklənmiş on dişi eşşək göndərdi. ");
INSERT INTO azb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","O, qardaşlarını yola saldı və onlar getdilər. Yusif onlara dedi: «Yolda dava etməyin». ");
INSERT INTO azb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Onlar Misirdən çıxıb Kənan torpağına, ataları Yaqubun yanına gəldilər. ");
INSERT INTO azb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ona hər şeyi danışıb dedilər: «Yusif sağ-salamatdır, özü də bütün Misir ölkəsinə başçılıq edir». Yaqub heyrətlənib qaldı və onlara inanmadı. ");
INSERT INTO azb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Qardaşlar Yusifin onlara dediyi bütün sözləri ona söylədilər. Onu aparmaq üçün Yusifin göndərdiyi arabaları görəndə ataları Yaqubun ürəyi ruhlandı. ");
INSERT INTO azb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","İsrail dedi: «İndi inandım ki, oğlum Yusif sağ-salamatdır. Qoy ölməmişdən qabaq gedib onu görüm». ");
INSERT INTO azb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","İsrail özünə məxsus hər şeyi ilə birgə yola çıxdı. Beer-Şevaya gəlib atası İshaqın Allahına qurbanlar kəsdi. ");
INSERT INTO azb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Gecə görüntülərində Allah İsraili çağırdı: «Yaqub! Yaqub!» Yaqub cavab verdi: «Mən buradayam». ");
INSERT INTO azb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Allah dedi: «Mən Allaham, atanın Allahıyam. Misirə getməkdən qorxma, çünki orada səndən böyük bir millət törədəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mən də səninlə birgə Misirə gedəcəyəm. Səni yenə oradan çıxaracağam. Yusif öz əli ilə sənin gözlərini bağlayacaq». ");
INSERT INTO azb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yaqub Beer-Şevadan çıxdı. İsrailin oğulları ataları Yaqubu və arvad-uşaqlarını fironun Yaqubu aparmaq üçün göndərdiyi arabalara mindirdilər. ");
INSERT INTO azb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yaqub və onun bütün övladları heyvanlarını və Kənan torpağında əldə etdikləri hər şeyi götürüb Misirə gəldilər. ");
INSERT INTO azb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","O özü ilə birgə oğullarını və qızlarını, oğul nəvələrini və qız nəvələrini – bütün övladlarını Misirə gətirdi. ");
INSERT INTO azb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","İsrailin Misirə gələn oğullarının – Yaqubla oğullarının adları belədir: Yaqubun ilk oğlu Ruven. ");
INSERT INTO azb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruvenin oğulları: Xanok, Pallu, Xesron və Karmi. ");
INSERT INTO azb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Şimeonun oğulları: Yemuel, Yamin, Ohad, Yakin, Sohar və bir Kənanlı qadından doğulan Şaul. ");
INSERT INTO azb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levinin oğulları: Gerşon, Qohat və Merari. ");
INSERT INTO azb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yəhudanın oğulları: Er, Onan, Şela, Peres və Zerah. Ancaq Er və Onan Kənan ölkəsində öldülər. Peresin oğulları: Xesron və Xamul. ");
INSERT INTO azb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","İssakarın oğulları: Tola, Puvva, Yov və Şimron. ");
INSERT INTO azb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zevulunun oğulları: Sered, Elon və Yaxleel. ");
INSERT INTO azb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bunlar Yaqubun Leadan doğulan övladlarıdır. Lea onları və qızı Dinanı Paddan-Aramda doğdu. Yaqubun oğul və qız övladları cəmi otuz üç nəfər idi. ");
INSERT INTO azb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Qadın oğulları: Sifyon, Haqqi, Şuni, Esbon, Eri, Arodi və Areli. ");
INSERT INTO azb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aşerin oğulları: İmna, İşva, İşvi, Beria və onların bacısı Serah. Berianın oğulları: Xever və Malkiel. ");
INSERT INTO azb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bunlar Lavanın qızı Leaya verdiyi Zilpadan doğulan Yaqub övladlarıdır. Onlar on altı nəfər idi. ");
INSERT INTO azb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaqubun arvadı Rəhilənin oğulları: Yusif və Binyamin. ");
INSERT INTO azb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusifin Misirdə On şəhərinin kahini Poti-Feranın qızı Asnatdan Menaşşe və Efrayim adlı iki oğlu oldu. ");
INSERT INTO azb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Binyaminin oğulları: Bela, Beker, Aşbel, Gera, Naaman, Exi, Roş, Muppim, Xuppim və Ard. ");
INSERT INTO azb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bunlar Yaqubun Rəhilədən doğulan övladlarıdır. Onlar on dörd nəfər idi. ");
INSERT INTO azb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danın oğlu Xuşim. ");
INSERT INTO azb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalinin oğulları: Yaxseel, Quni, Yeser, Şillem. ");
INSERT INTO azb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bunlar Lavanın qızı Rəhiləyə verdiyi Bilhadan doğulan Yaqub övladlarıdır. Onlar cəmi yeddi nəfər idi. ");
INSERT INTO azb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaqubun oğullarının arvadlarından başqa, Yaqubun nəslindən olan və onunla Misirə gələn övladları altmış altı nəfər idi. ");
INSERT INTO azb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusifin Misirdə doğulan iki oğlu ilə birlikdə Misirə köçən Yaqubun ailəsində yetmiş nəfər var idi. ");
INSERT INTO azb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaqub Qoşen yoluna bələdçilik etmək üçün özündən əvvəl Yəhudanı Yusifin yanına göndərdi. Onlar Qoşen torpağına girəndə ");
INSERT INTO azb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusif arabasını hazırlayıb Qoşenə atası İsraili qarşılamağa getdi. Özünü atasına tanıtdırıb onun boynuna sarıldı və uzun müddət onu qucaqlayıb ağladı. ");
INSERT INTO azb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","İsrail Yusifə dedi: «İndi ölə bilərəm, çünki üzünü gördüm. Sən sağ-salamatsanmış». ");
INSERT INTO azb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusif qardaşlarına və atasının ailəsinə dedi: «Qoy gedim firona xəbər verim ki, Kənan torpağında yaşayan qardaşlarımla atamın ailəsi yanıma gəliblər. ");
INSERT INTO azb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Onlar sürü sahibi olan çobanlardır. Ona görə də qoyun-keçiləri, mal-qaraları və bütün şeyləri ilə birlikdə gəliblər. ");
INSERT INTO azb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Firon sizi çağırıb “Nə işin sahibisiniz?” deyə soruşsa, ");
INSERT INTO azb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","deyin: “Atalarımız kimi biz də uşaqlıqdan bəri heyvandarlıqla məşğuluq”. Belə deyin ki, qoy sizi Qoşen vilayətində yerləşdirsin, çünki Misirlilər çobanlardan iyrənirlər». ");
INSERT INTO azb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusif fironun yanına daxil olub dedi: «Kənan torpağından atam və qardaşlarım qoyun-keçiləri, mal-qaraları və özlərinə məxsus hər şeyləri ilə birgə buraya gəliblər və indi Qoşen vilayətindədirlər». ");
INSERT INTO azb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Sonra qardaşları arasından beşini götürüb fironun hüzuruna gətirdi. ");
INSERT INTO azb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firon Yusifin qardaşlarına dedi: «Nə işin sahibisiniz?» Onlar firona dedilər: «Biz qulların, atalarımız kimi çobanıq. ");
INSERT INTO azb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bu ölkəyə müvəqqəti yaşamaq üçün gəlmişik, çünki Kənan torpağında dəhşətli aclıq hökm sürür. Sürülərimiz üçün otlaq yox idi. İndi xahiş edirik ki, Qoşen vilayətində yaşamağa izin verəsiniz». ");
INSERT INTO azb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Firon Yusifə dedi: «Atanla qardaşların yanına gəliblər. ");
INSERT INTO azb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misir torpağı sənin önündədir: atanla qardaşlarını bu torpağın ən yaxşı yerlərində yerləşdir. Qoy Qoşen vilayətində yaşasınlar. Aralarında hansı bacarıqlıdırsa, onu mənim sürülərimə çoban qoy». ");
INSERT INTO azb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusif atası Yaqubu götürüb fironun hüzuruna gətirdi. Yaqub firona xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firon Yaqubdan soruşdu: «Neçə yaşın var?» ");
INSERT INTO azb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaqub firona cavab verdi: «Ömrümün yüz otuz ilini qürbətdə keçirdim, amma ömrüm az və ağır oldu, atalarımın qürbətdəki ömrü qədər uzun olmadı». ");
INSERT INTO azb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Sonra firona xeyir-dua verib onun hüzurundan çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusif atası ilə qardaşlarını Misirdə yerləşdirdi və fironun əmrinə əsasən onlara ölkənin ən yaxşı yerində – Ramses bölgəsində mülk verdi. ");
INSERT INTO azb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Bundan əlavə, Yusif atasına, qardaşlarına və atasının ailəsinə malik olduqları uşaqların sayına görə çörək saxladı. ");
INSERT INTO azb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Aclıq getdikcə o qədər gücləndi ki, heç bir ölkədə çörək tapılmadı. Misir və Kənan ölkələrinin əhalisini aclıq taqətdən salmışdı. ");
INSERT INTO azb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusif satdığı taxılın əvəzində Misir və Kənan ölkələrində yığılan bütün pulları toplayıb fironun sarayına apardı. ");
INSERT INTO azb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Misir və Kənan ölkələrində pul qurtaranda bütün Misirlilər Yusifin yanına gəlib dedilər: «Bizə çörək ver. Gərək qarşında ölək? Axı pulumuz qurtarıb». ");
INSERT INTO azb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusif dedi: «Onda heyvanlarınızı verin. Əgər pulunuz qurtarıbsa, heyvanlarınızı verin, onların əvəzinə sizə çörək verərəm». ");
INSERT INTO azb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Onlar heyvanlarını Yusif üçün gətirdilər. Yusif də atların, qoyun-keçi və mal-qara sürülərinin, eşşəklərin əvəzinə onlara çörək verdi. Həmin il onları heyvanları əvəzinə verdiyi çörəklə saxladı. ");
INSERT INTO azb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","İl başa çatanda ikinci il yenə onun yanına gəlib dedilər: «Ağamızdan gizli deyil ki, pulumuz qurtarıb, heyvan sürülərimiz də ağamızındır. Ağamızın hüzurunda canımız və torpaqlarımızdan başqa bir şeyimiz qalmadı. ");
INSERT INTO azb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nə üçün gözünün önündə torpağımızla bərabər məhv olaq? Bizi və torpaqlarımızı çörək əvəzinə satın al. Qoy firon bizim də, torpaqlarımızın da sahibi olsun. Toxum ver ki, ölməyib yaşaya bilək, həm də torpağımız səhraya çevrilməsin». ");
INSERT INTO azb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Beləliklə, Yusif Misirin bütün torpaqlarını firon üçün satın aldı. Bütün Misirlilər öz zəmilərini satdılar, çünki aclıqdan əzab çəkirdilər. Bütün torpaqlar fironun oldu. ");
INSERT INTO azb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yusif Misir ərazisinin bir ucundan o biri ucuna qədər bütün əhalisini şəhərlərə köçürdü. ");
INSERT INTO azb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Yalnız kahinlərin torpağını satın almadı, çünki onlar firondan məvacib alır və fironun verdiyi məvaciblə dolanırdılar. Buna görə də torpaqlarını satmadılar. ");
INSERT INTO azb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusif xalqa dedi: «Sizi də, torpaqlarınızı da firon üçün satın almışam. Alın, bu sizin toxumunuz, torpağı əkin. ");
INSERT INTO azb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Məhsul yığılanda onun beşdə birini firona verin. Beşdə dördünü isə toxumluq olaraq istifadə edin. Həm özünüz, həm külfətiniz, həm də övladlarınız yesin». ");
INSERT INTO azb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Xalq isə dedi: «Sən bizim canımızı qurtardın. Qoy ağamızın gözündə lütf tapaq, biz fironun köləsi oluruq». ");
INSERT INTO azb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusif məhsulun beşdə birinin firona verilməsi barədə Misirdə bir torpaq qanunu qoydu. Bu qanun bu günə qədər qüvvədədir. Yalnız kahinlərin torpaqları firona verilmədi. ");
INSERT INTO azb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","İsrailin nəsli Misirdəki Qoşen vilayətində yaşayaraq orada mülk sahibi oldu. Onlar artaraq çoxaldılar. ");
INSERT INTO azb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaqub Misir torpağında on yeddi il yaşadı. O, yüz qırx yeddi il ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","İsrailin öləcəyi gün yaxınlaşanda oğlu Yusifi çağırıb dedi: «Əgər gözündə lütf tapmışamsa, əlini budumun altına qoy və and iç ki, xeyirxahlıq və sədaqət göstərib məni Misirdə basdırmayacaqsan, ");
INSERT INTO azb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ancaq atalarımla birgə uyumaq üçün öləndə məni Misirdən aparıb onların məqbərəsində basdıracaqsan». Yusif dedi: «Dediyin kimi edərəm». ");
INSERT INTO azb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Atası dedi: «Mənə and iç». O da and içdi. İsrail yatağının başına söykənib Allaha səcdə etdi. ");
INSERT INTO azb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bir müddət sonra Yusifə dedilər: «Atan xəstədir». O, iki oğlunu – Menaşşe və Efrayimi özü ilə götürdü. ");
INSERT INTO azb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yaquba xəbər verib dedilər: «Budur, oğlun Yusif yanına gəlir». İsrail gücünü toplayıb yatağı üstündə oturdu. ");
INSERT INTO azb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaqub Yusifə dedi: «Külli-İxtiyar Allah Kənan torpağında olan Luzda mənə göründü və xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","O mənə belə dedi: “Bax Mən səni bəhərli edib nəslini çoxaldacağam, səndən çoxlu xalq törədəcəyəm. Səndən sonra bu torpağı övladlarına əbədi mülk olaraq verəcəyəm”. ");
INSERT INTO azb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","İndi sənin yanına, Misirə gəlməzdən əvvəl Misir torpağında doğulan iki oğlun da mənimdir: Efrayim və Menaşşe Ruvenlə Şimeon kimi mənimki olacaq. ");
INSERT INTO azb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Onlardan sonra sənin üçün doğulan uşaqlar isə səninki olacaq, öz miras torpaqlarında qardaşlarının adları ilə qeyd olunacaq. ");
INSERT INTO azb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mən Paddandan gələndə Kənan torpağında Efrata yaxın yerdə Rəhilə yanımdaca öldü. Onu elə orada – Efrat yolunda, yəni Bet-Lexemdə basdırdım». ");
INSERT INTO azb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","İsrail Yusifin oğullarını görüb dedi: «Bunlar kimdir?» ");
INSERT INTO azb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusif atasına dedi: «Allahın burada mənə verdiyi oğullarımdır». İsrail dedi: «Onları yanıma gətir, xeyir-dua verim». ");
INSERT INTO azb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","İsrail artıq qocalmış, gözləri zəifləmişdi və görə bilmirdi. Yusif oğullarını atasının yanına apardı və atası onları öpüb qucaqladı. ");
INSERT INTO azb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Sonra İsrail Yusifə dedi: «Düşünmürdüm ki, üzünü bir də görərəm, amma Allah mənə sənin övladlarını da göstərdi». ");
INSERT INTO azb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusif övladlarını atasının dizləri yanından kənara çəkib onun qarşısında üzünü yerə qoyaraq səcdə etdi. ");
INSERT INTO azb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Sonra oğullarını götürüb Efrayimi sağ əli ilə İsrailin sol tərəfinə, Menaşşeni isə sol əli ilə İsrailin sağ tərəfinə çəkərək ona yaxınlaşdırdı. ");
INSERT INTO azb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","İsrail əllərini çarpaz uzatdı: sağ əlini kiçik olan Efrayimin, sol əlini isə Menaşşenin başına qoydu. Menaşşe ilk oğul olduğuna baxmayaraq, İsrail əllərini qəsdən dəyişdi. ");
INSERT INTO azb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","İsrail Yusifə xeyir-dua verərək belə dedi: «Atalarım İbrahimin, İshaqın xidmət etdiyi Allah, Bu günə qədər mənim qayğıma qalan Allah, ");
INSERT INTO azb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Məni bütün pisliklərdən xilas edən Mələk Qoy bu uşaqlara da xeyir-dua versin! Onlar mənim adımla, Atalarım İbrahim və İshaqın Adı ilə çağırılsın, Yer üzündə çoxaldıqca çoxalsın!» ");
INSERT INTO azb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusif atasının sağ əlini Efrayimin başına qoyduğunu gördü və bu onun xoşuna gəlmədi. O, atasının əlini Efrayimin başından götürüb Menaşşenin başına qoymaq istədi. ");
INSERT INTO azb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Buna görə də atasına dedi: «Ata, ilk oğul Menaşşedir, sağ əlini onun başına qoy. Belə düz deyil». ");
INSERT INTO azb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Lakin atası istəməyib dedi: «Bilirəm, oğlum, bilirəm. Menaşşenin nəslindən də böyük bir xalq olacaq. Amma kiçik qardaşından daha böyük bir xalq törəyəcək, onun nəslindən çoxlu millətlər yaranacaq». ");
INSERT INTO azb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","O gün İsrail nəvələrinə xeyir-dua verərək dedi: «İsrail nəsli “Qoy Allah səni Efrayim və Menaşşe kimi etsin” Deyərək sizin adınızla Xeyir-dua verəcək». Yaqub beləcə Efrayimi Menaşşedən üstün tutdu. ");
INSERT INTO azb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","İsrail Yusifə dedi: «Artıq mən ölürəm, amma Allah sizinlə olacaq, sizi atalarınızın torpağına qaytaracaq. ");
INSERT INTO azb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sənə qardaşlarından bir pay da artıq olaraq Şekemi verirəm. Onu mən Emorluların əlindən qılıncım və kamanımla almışam». ");
INSERT INTO azb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yaqub oğullarını çağırıb dedi: «Yanıma toplaşın, gələcəkdə başınıza gələnləri sizə söyləyim: ");
INSERT INTO azb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ey Yaqub oğulları, yığılıb eşidin, Atanız İsrailə qulaq asın: ");
INSERT INTO azb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ey Ruven, ilk oğlum, Sən mənim gücümsən, qüdrətimin başlanğıcısan. Ləyaqətin hamıdan üstündür, Qüvvətin hamıdan çoxdur. ");
INSERT INTO azb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Amma sən su kimi oynaqsan, Artıq üstün olmayacaqsan. Çünki atanın yatağına girib Onu murdar etdin – Bax o, döşəyimə çıxdı. ");
INSERT INTO azb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Şimeonla Levi qardaşdır, Qəddarlıq qılıncları ilə silahlanıblar. ");
INSERT INTO azb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ey qəlbim, onların məclisinə getmə, Ey şərəfim, onların toplantısında olma. Çünki onlar qəzəblənəndə qətl etdilər, Əylənəndə öküzlərin ayaq vətərini kəsdilər. ");
INSERT INTO azb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Lənət olsun vəhşi qəzəblərinə, Lənət olsun qəddar hiddətlərinə. Onları Yaqubda böləcəyəm, İsraildə səpələyəcəyəm. ");
INSERT INTO azb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yəhuda, qardaşların səni mədh edəcək, Düşmənlərin boynu əlində olacaq, Atanın oğulları önündə səcdə edəcək. ");
INSERT INTO azb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yəhuda bir aslan balasıdır, Ey oğlum, sən şikara çıxanda Bir şir kimi yerə əyilirsən, Dişi aslan kimi torpağa yatırsan. Kim səni yerindən qaldıra bilər? ");
INSERT INTO azb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Padşahlıq əsası Yəhudanın əlindən getməyəcək, Hökmdarlıq əsası onun nəslindən itməyəcək; O vaxta qədər ki əsanın Sahibi gələcək. Onda xalqlar Ona itaət edəcək. ");
INSERT INTO azb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Eşşəyini tənəyə, Ulağını ən seçmə bir tənəyə bağlayacaq. Paltarını şərabda, Köynəyini üzümün qanında yuyacaq. ");
INSERT INTO azb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Gözləri şərabdan da parlaq olacaq, Dişləri süddən də ağ olacaq. ");
INSERT INTO azb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zevulun isə dəniz kənarında yaşayacaq, Ora gəmilərin limanı olacaq, Ərazisi Sidonun yanınadək uzanacaq. ");
INSERT INTO azb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Qoyun ağılları arasında uzanan İssakar Bir qüvvətli ulağa oxşar. ");
INSERT INTO azb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","O, yaxşı və rahat olan yer, Bir səfalı ölkə görsə, Çiynini yük daşımaq üçün əyər, Mükəlləfiyyətçi qul olar. ");
INSERT INTO azb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan İsrail qəbilələrindən biri olub Öz xalqına hökm edəcək. ");
INSERT INTO azb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan yol üstündə bir ilan, Cığırda bir gürzə olacaq; Elə bir gürzə ki atın topuğundan sancır, Süvarisi arxası üstə yıxılır. ");
INSERT INTO azb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ya Rəbb! Mən Sənin xilasını gözləyirəm. ");
INSERT INTO azb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Qad talançı basqınına düçar olacaq, Lakin onları topuğundan vuracaq. ");
INSERT INTO azb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aşerdən zəngin nemətlər gələcək, O, şahanə ləzzətli yeməklər yetirəcək. ");
INSERT INTO azb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali azad edilmiş bir maraldır, Ondan gözəl balalar doğulacaq. ");
INSERT INTO azb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusif barlı bir ağac, Çeşmə kənarında meyvəli bir ağacdır, Budaqları divarın üstündən aşar. ");
INSERT INTO azb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Oxçular ona güclü hücum etdilər, Düşmənçilik edib üstünə ox yağdırdılar. ");
INSERT INTO azb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Amma Yaqubun qüdrətli Allahı – İsrailin Daşı və Çobanı olan Allahın sayəsində Onun kamanı möhkəm, Qolları qüvvətli oldu. ");
INSERT INTO azb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Sənə kömək edən Atanın Allahıdır, Sənə xeyir-dua verən Külli-İxtiyardır. Yuxarıda göylərin bərəkəti ilə, Dərinlikdə olan Su mənbələrinin bərəkəti ilə, Döşlərin və bətnlərin bərəkəti ilə Sənə xeyir-dua verəcək. ");
INSERT INTO azb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Atanın xeyir-duası Atalarımın xeyir-duasından daha ucadır; Əbədi qalan təpələrin Zirvəsinə çatar. Qoy xeyir-dualarım Yusifin – qardaşlar arasında Başçı olanın üstündə olsun. ");
INSERT INTO azb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Binyamin acgöz bir qurddur, Səhər ovunu yeyər, Axşam qənimət paylar». ");
INSERT INTO azb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bunların hamısı İsrailin on iki qəbiləsidir. Ataları onlara xeyir-dua verərkən bu sözləri söylədi və hər birinə xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Sonra Yaqub oğullarına vəsiyyət edib dedi: «Mən ölüb əcdadlarıma qoşulacağam. Məni atalarımın yanında – Xetli Efronun tarlasında olan mağarada basdırın. ");
INSERT INTO azb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","O mağara Kənan torpağında olan Mamre qarşısındakı Maxpela tarlasındadır. İbrahim o mağaranı qəbir düzəltmək üçün Xetli Efrondan tarlası ilə birlikdə satın almışdı. ");
INSERT INTO azb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","İbrahimlə arvadı Sara və İshaqla arvadı Rivqa orada basdırılmışdı. Mən Leanı da orada basdırdım. ");
INSERT INTO azb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Həmin tarla ilə oradakı mağara Xetlilərdən satın alınıb». ");
INSERT INTO azb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaqub oğullarına vəsiyyət edib qurtaranda ayaqlarını yatağına yığaraq son dəfə nəfəs aldı və ölüb əcdadlarına qoşuldu. ");
INSERT INTO azb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusif özünü atasının üstünə atdı və ağlayaraq onu öpdü. ");
INSERT INTO azb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Sonra həkim xidmətçilərinə atasının meyitini mumiyalamağı əmr etdi. Həkimlər İsraili mumiyaladılar. ");
INSERT INTO azb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Bu iş qırx günə görüldü, çünki mumiyalamaq üçün qırx gün lazım idi. Misirlilər yetmiş gün İsrail üçün yas tutdular. ");
INSERT INTO azb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yas günləri qurtarandan sonra Yusif fironun saray adamlarına müraciət edib dedi: «Əgər gözünüzdə lütf tapmışamsa, firona söyləyin ki, ");
INSERT INTO azb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","atam məni and içdirib demişdi: “Mən can üstəyəm. Kənan torpağında özüm üçün qəbir qazmışam, məni orada basdır”. İndi qoy o mənə izin versin ki, gedib atamı basdırım və qayıdım». ");
INSERT INTO azb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firon dedi: «Get, atanın sənə and içdirdiyi kimi onu basdır». ");
INSERT INTO azb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Beləliklə, Yusif atasını basdırmağa getdi. Fironun bütün əyanları, sarayın və Misirin bütün ağsaqqalları, ");
INSERT INTO azb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusifin bütün ev adamları, qardaşları və atasının ev adamları onu müşayiət etdilər. Qoşen vilayətində yalnız uşaqlarını, qoyun-keçilərini və mal-qaralarını qoydular. ");
INSERT INTO azb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Onlarla birgə atlılar və arabalar da yola çıxmışdı, ona görə də dəstə çox böyük idi. ");
INSERT INTO azb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Onlar İordan çayının yaxınlığındakı Atad xırmanına çatanda böyük ağlaşma ilə matəm qurdular. Yusif atası üçün yeddi gün yas tutdu. ");
INSERT INTO azb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","O ölkənin əhalisi olan Kənanlılar Atad xırmanındakı yası görəndə dedilər: «Gör Misirlilər necə böyük matəmlə yas tuturlar». Ona görə də İordan çayının yaxınlığındakı bu yerə Avel-Misrayim adı verildi. ");
INSERT INTO azb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaqubun oğulları atalarının vəsiyyətini əmr etdiyi kimi yerinə yetirdilər. ");
INSERT INTO azb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Onu Kənan ölkəsinə gətirib Mamre qarşısındakı Maxpela tarlasında olan mağarada basdırdılar. İbrahim bir vaxt həmin mağaranı qəbir düzəltmək üçün tarla ilə birlikdə Xetli Efrondan satın almışdı. ");
INSERT INTO azb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusif atasını dəfn etdikdən sonra həm özü, həm qardaşları, həm də onunla birlikdə atasının dəfninə gələnlərin hamısı Misirə qayıtdı. ");
INSERT INTO azb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ataları öləndən sonra Yusifin qardaşları öz aralarında dedilər: «Bəlkə Yusif bizə qarşı kin saxlayır. Əgər ona etdiyimiz pisliyə görə bizdən qisas alarsa, nə edərik?» ");
INSERT INTO azb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Buna görə də Yusifə xəbər göndərdilər: «Atan ölümündən qabaq bizə vəsiyyət etdi ki, gedib Yusifə belə deyin: ");
INSERT INTO azb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Bax səndən xahişim budur ki, qardaşlarının günahını və təqsirini bağışlayasan. Axı onlar sənə pislik ediblər”. Xahiş edirik, sən atanın Allahının qulları olan biz qardaşlarının günahını bağışla». Bu sözlər Yusifə çatanda o ağladı. ");
INSERT INTO azb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Sonra qardaşları özləri Yusifin yanına gedib önündə yerə qapandılar və dedilər: «Biz sənin qullarınıq». ");
INSERT INTO azb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yusif onlara dedi: «Məgər mən Allaham ki, məndən qorxursunuz? ");
INSERT INTO azb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Baxın siz mənə qarşı pis fikrə düşdünüz, lakin Allah onu yaxşı işə çevirdi ki, bu gün gördüyünüzü etsin və çoxlu adamın həyatını qorusun. ");
INSERT INTO azb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ona görə də qorxmayın, mən həm sizi, həm də övladlarınızı saxlayacağam». Yusif onlara ürəklərincə olan sözlərlə təsəlli verdi. ");
INSERT INTO azb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusifin və atasının nəsli Misirdə sakin oldu. Yusif yüz on il ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","O, Efrayimin üç nəsil övladlarını gördü. Menaşşenin oğlu Makirin övladları da Yusifin yanında doğuldu. ");
INSERT INTO azb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bir gün Yusif qardaşlarına dedi: «Mən ölürəm, amma Allah mütləq sizə nəzər salacaq. O sizi bu ölkədən İbrahimə, İshaqa və Yaquba and içdiyi torpağa aparacaq». ");
INSERT INTO azb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Sonra Yusif İsrailin övladlarını and içdirib dedi: «Allah mütləq sizə nəzər salacaq. Gedən zaman mənim sümüklərimi də buradan çıxarın». ");
INSERT INTO azb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusif yüz on yaşında öldü. Onu Misirdə mumiyalayıb bir tabuta qoydular. ");
INSERT INTO azb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yaqubla birlikdə ailələri ilə Misirə gələn İsrail övladlarının adları bunlar idi: ");
INSERT INTO azb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruven, Şimeon, Levi, Yəhuda, ");
INSERT INTO azb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","İssakar, Zevulun, Binyamin, ");
INSERT INTO azb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Qad, Aşer, ");
INSERT INTO azb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yaqubun nəslindən törənən yetmiş nəfər idi. Yaqubun oğlu Yusif artıq Misirdə idi. ");
INSERT INTO azb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Vaxt yetişdi, Yusif, qardaşları və o nəslin hamısı öldü. ");
INSERT INTO azb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Amma İsrail övladları çoxalıb böyüdülər, sayları artdı və onlar çox qüvvətləndi; ölkə onlarla doldu. ");
INSERT INTO azb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Misirdə Yusifi tanımayan yeni bir padşah taxta çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","O, xalqına dedi: «Baxın İsrail övladları sayca bizdən çox və daha qüvvətlidir. ");
INSERT INTO azb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Gəlin onlarla ağılla rəftar edək, yoxsa çoxalar və müharibə vaxtı düşmənlərimizlə birləşib bizə qarşı vuruşar, sonra isə ölkəni tərk edərlər». ");
INSERT INTO azb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Misirlilər İsrail övladlarına əziyyət vermək üçün onların üzərinə zülmkar iş nəzarətçiləri qoydular. İsrail övladları firon üçün Pitom və Ramses adlanan şəhərlər tikdilər. Orada anbarlar yerləşdirdilər. ");
INSERT INTO azb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ancaq İsrail övladlarına əziyyət vermələrinə baxmayaraq, onlar çoxalıb artırdı. Onda Misirlilər İsrail övladlarından qorxub, ");
INSERT INTO azb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","onları sıxıntılı əsarətdə saxladılar. ");
INSERT INTO azb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Misirlilər İsrail övladlarını ağır işlərlə – palçıq tapdalamaqla, kərpic kəsməklə və hər cür tarla işləri ilə amansızcasına işlədib onların həyatını acı etdilər. ");
INSERT INTO azb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misir padşahı birinin adı Şifra, o birinin adı Pua olan İbrani mamaçalarına dedi: ");
INSERT INTO azb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«İbrani qadınlarını doğuzduranda baxın: əgər uşaq oğlan olarsa, onu öldürün, yox, əgər qız olsa, qoy yaşasın». ");
INSERT INTO azb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ancaq mamaçalar Allahdan qorxurdular və buna görə Misir padşahının onlara əmr etdiyi kimi etmədilər və oğlan uşaqlarını sağ buraxdılar. ");
INSERT INTO azb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Misir padşahı mamaçaları çağırtdırıb onlara dedi: «Niyə belə etdiniz? Niyə oğlan uşaqlarını sağ buraxdınız?» ");
INSERT INTO azb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mamaçalar firona dedilər: «Çünki İbrani qadınları Misirli qadınlar kimi deyil, onlar daha sağlamdırlar və mamaçalar onların yanına gəlməzdən əvvəl doğurlar». ");
INSERT INTO azb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Buna görə Allahın xalqı çoxalıb artdı. Allah mamaçalara da xeyirxahlıq göstərdi. ");
INSERT INTO azb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ondan qorxduqlarına görə bu qadınlara da ailə nəsib etdi. ");
INSERT INTO azb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Firon bütün xalqına əmr edib dedi: «İbranilərdən hər doğulan oğlan uşağını Nil çayına atın! Hər qız uşağını isə sağ qoyun». ");
INSERT INTO azb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","O zaman Levi qəbiləsindən bir kişi öz nəslindən bir arvad aldı. ");
INSERT INTO azb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","O hamilə olub oğul doğdu və uşağın gözəl olduğunu görüb üç ay gizlətdi. ");
INSERT INTO azb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Bundan artıq onu gizlədə bilməyərək qamışdan bir səbət götürüb ona qır və qatran sürtdü, körpəni səbətin içinə salıb Nil çayının kənarındakı qamışlığın arasına qoydu. ");
INSERT INTO azb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Körpənin bacısı isə onun başına nə gələcəyini bilmək üçün uzaqda durub baxırdı. ");
INSERT INTO azb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Fironun qızı çimmək üçün çaya girdi. Onun qarabaşları isə çayın kənarında gəzişirdilər. Fironun qızı qarğıların arasında səbəti görüb onu gətirmək üçün kənizini göndərdi. ");
INSERT INTO azb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Sonra səbəti açıb bir oğlan gördü. Körpə ağlayırdı. Fironun qızı ona rəhmi gəldiyindən dedi: «Bu, İbrani oğlanlarındandır». ");
INSERT INTO azb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Körpənin bacısı fironun qızına dedi: «Bəlkə gedib sənin üçün İbrani qadınlarından bir dayə çağırım ki, körpəni əmizdirsin?» ");
INSERT INTO azb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Fironun qızı ona «get» dedi. Qız gedib körpənin anasını çağırdı. ");
INSERT INTO azb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fironun qızı ona dedi: «Bu körpəni götürüb mənim üçün əmizdir, sənə bunun haqqını verərəm». Qadın körpəni götürüb əmizdirdi. ");
INSERT INTO azb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Uşaq böyüdü və qadın onu firon qızının yanına apardı. Fironun qızı uşağı oğulluğa götürdü. O, uşağın adını Musa qoyub dedi: «Oğlanı sudan çıxartdığım üçün ona bu adı qoydum». ");
INSERT INTO azb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Çox illər keçdi, Musa böyüdü. Bir dəfə o öz xalqının yanına getdi və onların ağır zəhmətini gördü. Bir Misirlinin onun xalqından olan İbranini döydüyünü gördü. ");
INSERT INTO azb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa ətrafına baxıb heç kəsin olmadığını görəndə Misirlini öldürüb qumda gizlətdi. ");
INSERT INTO azb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ertəsi gün o yenə gedəndə gördü ki, iki İbrani bir-biri ilə dalaşır. Musa haqsız olana dedi: «Yoldaşını niyə vurursan?» ");
INSERT INTO azb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","O adam dedi: «Səni bizim üstümüzə kim başçı və hakim qoyub? Yoxsa Misirlini öldürdüyün kimi məni də öldürmək fikrindəsən?» Musa qorxaraq ürəyində dedi: «Deyəsən, bu iş barədə bilirlər». ");
INSERT INTO azb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Firon bu işdən xəbərdar olanda Musanı öldürtdürmək istədi. Ancaq Musa fironun əlindən qaçıb Midyan torpağına çataraq bir quyunun yanında oturdu. ");
INSERT INTO azb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midyan kahininin yeddi qızı var idi. Onlar gəlib quyudan su çəkərək atalarının qoyun-keçilərinə su vermək üçün təknələri doldurdular. ");
INSERT INTO azb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","O vaxt çobanlar gəlib onları qovdular; onda Musa qalxıb qızlara kömək etdi və qoyun-keçilərinə su verdi. ");
INSERT INTO azb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Qızlar ataları Reuelin yanına gələndə o dedi: «Necə oldu ki, bu gün tez gəldiniz?» ");
INSERT INTO azb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Onlar dedilər: «Bir Misirli bizi çobanların əlindən qurtardı və bizim üçün quyudan su çəkib qoyun-keçiyə su verdi». ");
INSERT INTO azb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","O, qızlarına dedi: «O adam haradadır? Onu niyə buraxdınız? Çağırın, gəlib çörək yesin». ");
INSERT INTO azb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa o adamın evində qalmağa razı oldu. O da qızı Sipporanı Musaya arvad olaraq verdi. ");
INSERT INTO azb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sippora bir oğlan doğdu. Musa onun adını Gerşom qoyub dedi: «Mən yad bir ölkədə qərib oldum». ");
INSERT INTO azb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Xeyli vaxt keçəndən sonra Misir padşahı öldü. İsrail övladları ağır zəhmət çəkdikləri üçün fəryad edib inlədilər. Ağır zəhmətlərinə görə etdikləri nalələri Allaha çatdı. ");
INSERT INTO azb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Allah onların iniltisini eşitdi; İbrahimlə, İshaqla və Yaqubla olan əhdini xatırladı. ");
INSERT INTO azb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Allah İsrail övladlarının qul olduqlarını gördü və onlara nəzər saldı. ");
INSERT INTO azb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa qayınatası Midyan kahini Yetronun sürüsünü otarırdı. Bir dəfə o, sürünü səhranın o biri tərəfinə aparıb Allahın dağı Xorevə gəldi. ");
INSERT INTO azb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Birdən Rəbbin mələyi ona bir kol arasından od-alov içərisində göründü; od içində kolun sönmədən yanmasını görüb ");
INSERT INTO azb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa öz-özünə dedi: «Gedim, bu qəribə mənzərəyə baxım, görüm nə üçün bu kol yanıb qurtarmır». ");
INSERT INTO azb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Rəbb Musanın baxmağa gəldiyini görəndə Allah kolun ortasından onu çağırıb dedi: «Musa, Musa!» O da «mən buradayam» dedi. ");
INSERT INTO azb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Allah dedi: «Buraya yaxınlaşma. Ayaqlarından çarıqlarını çıxart, çünki durduğun yer müqəddəs torpaqdır». ");
INSERT INTO azb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Sonra dedi: «Mən atanın Allahı, İbrahimin Allahı, İshaqın Allahı və Yaqubun Allahıyam». Musa üzünü örtdü, çünki Allaha baxmağa qorxurdu. ");
INSERT INTO azb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Rəbb dedi: «Həqiqətən, Mən Misirdə olan xalqımın əziyyətini gördüm, nəzarətçilərin əlindən etdikləri fəryadlarını eşitdim və dərdlərinə nəzər saldım. ");
INSERT INTO azb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Mən ona görə gəldim ki, onları Misirlilərin əlindən qurtarıb bu ölkədən çıxarım və geniş, nemətli bir diyara, süd və bal axan torpağa – Kənanlıların, Xetlilərin, Emorluların, Perizlilərin, Xivlilərin və Yevusluların ölkəsinə aparım. ");
INSERT INTO azb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","İndi isə İsrail övladlarının fəryadı Mənə çatdı, Misirlilərin onlara etdikləri zülmü görürəm. ");
INSERT INTO azb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Buna görə də get. Səni fironun yanına göndərirəm ki, xalqım İsrail övladlarını Misirdən çıxarasan». ");
INSERT INTO azb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musa Allaha dedi: «Axı mən kiməm ki, fironun yanına gedib İsrail övladlarını Misirdən çıxarım?» ");
INSERT INTO azb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Allah dedi: «Mən səninləyəm. Mənim səni göndərdiyimə əlamət bu olacaq: sən xalqı Misirdən çıxaranda bu dağda Mənə ibadət edəcəksiniz». ");
INSERT INTO azb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa Allaha dedi: «İsrail övladlarının yanına gedib “məni sizin yanınıza atalarınızın Allahı göndərib” deyəndə onlar məndən soruşa bilərlər: “Bəs Onun adı nədir?” Onda mən nə deyim?» ");
INSERT INTO azb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Allah Musaya dedi: «Var Olan Mənəm». Sonra dedi: «İsrail övladlarına belə söylə: “‹Mənəm› deyən sizin yanınıza məni göndərdi”». ");
INSERT INTO azb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","O yenə Musaya dedi: «İsrail övladlarına söylə: “Atalarınızın Allahı, İbrahimin Allahı, İshaqın Allahı və Yaqubun Allahı Rəbb məni sizin yanınıza göndərdi”. Əbədi olaraq adım budur. Nəsildən-nəslə anılan ismim budur. ");
INSERT INTO azb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Get, İsrail ağsaqqallarını topla və onlara belə söylə: “Atalarınızın Allahı, İbrahimin, İshaqın və Yaqubun Allahı Rəbb mənə görünərək bunları dedi: ‹Siz və Misirdə başınıza gətirilənlərin hamısı nəzərimdədir. ");
INSERT INTO azb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Söz verdim ki, sizi Misirdəki əziyyətdən qurtarıb Kənanlıların, Xetlilərin, Emorluların, Perizlilərin, Xivlilərin və Yevusluların ölkəsinə – süd və bal axan torpağa aparacağam›”. ");
INSERT INTO azb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","İsrail ağsaqqalları sənin sözünə qulaq asacaqlar. Sən onlarla birgə Misir padşahının yanına gedib de: “İbranilərin Allahı Rəbb bizə göründü. İndi bizə izin ver ki, çöldə birlikdə üç günlük yol gedək və orada Allahımız Rəbbə qurban gətirək”. ");
INSERT INTO azb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Amma bilirəm ki, Misir padşahı qüdrətli əl vasitəsilə məcbur olmasa, sizin getməyinizə izin verməyəcək. ");
INSERT INTO azb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mən də əlimi uzadıb orada hər cür xariqələrimi göstərərək Misiri vuracağam; bundan sonra Misir padşahı sizi buraxacaq. ");
INSERT INTO azb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Bu xalqa qarşı Misirlilərin gözündə lütf qazandıracağam ki, yola düşdüyünüz zaman əliboş getməyəsiniz. ");
INSERT INTO azb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Hər qadın öz qonşusundan, yaxınlıqda qalan qadından qızıl-gümüş əşya və paltar istəsin. Bunlarla oğul və qızlarınızı bəzəyəcəksiniz, beləcə Misirliləri soyacaqsınız». ");
INSERT INTO azb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa belə cavab verdi: «Bəlkə onlar mənə inanmayaraq sözümə qulaq asmayıb “Rəbb sənə görünməyib” deyəcəklər?» ");
INSERT INTO azb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Rəbb Musaya dedi: «Sənin əlindəki nədir?» O dedi: «Əsa». ");
INSERT INTO azb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Rəbb dedi: «Onu yerə at». Musa onu yerə atdı və əsa ilan oldu. Musa onun qabağından qaçdı. ");
INSERT INTO azb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Rəbb Musaya dedi: «Əlini uzadıb onun quyruğundan tut». Musa əlini uzadıb tutanda o yenə əlində əsa oldu. ");
INSERT INTO azb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Sonra Rəbb dedi: «Bu əlamət ona görədir ki, İsraillilər atalarının Allahı, İbrahimin Allahı, İshaqın Allahı və Yaqubun Allahı Rəbbin sənə göründüyünə inansınlar». ");
INSERT INTO azb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Rəbb yenə dedi: «İndi əlini qoynuna qoy». Musa əlini qoynuna qoydu. Onu qoynundan çıxaranda, əli cüzama tutulub qar kimi ağappaq oldu. ");
INSERT INTO azb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Sonra Rəbb dedi: «Əlini yenə qoynuna qoy». Musa yenə əlini qoynuna qoydu. Əlini qoynundan götürəndə əli yenə də bədəni kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Rəbb davam etdi: «Əgər sənə inanmasalar və əvvəlki əlaməti qəbul etməsələr, sonrakı əlaməti qəbul edəcəklər. ");
INSERT INTO azb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Bu iki əlamətə də inanmayıb sözünə qulaq asmasalar, Nil çayının suyundan götürüb quruya tök. Çaydan götürdüyün su quruda qana çevriləcək». ");
INSERT INTO azb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa Rəbbə dedi: «Ya Xudavənd, mən nə keçmişdə, nə də qulunla danışdığın vaxt natiq olmamışam, çünki dili ağır, səlis danışmayan bir adamam». ");
INSERT INTO azb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Rəbb ona dedi: «Ağzı insana kim verib? İnsanı lal, kar, kor yaxud gözlü edən kimdir? Bunu edən Mən Rəbb deyiləmmi? ");
INSERT INTO azb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","İndi get, Mən ağzınla danışacağam və deyəcəyin sözü sənə öyrədəcəyəm». ");
INSERT INTO azb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Musa dedi: «Ya Xudavənd, yalvarıram, başqa adamı göndər». ");
INSERT INTO azb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Rəbb Musaya qəzəblənib dedi: «Qardaşın Levili Harun yoxdurmu? Bilirəm ki, onun yaxşı nitqi var. İndi o səni qarşılamağa gəlir. Səni görəndə ürəkdən sevinəcək. ");
INSERT INTO azb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Qardaşınla danış, nə demək lazımdırsa, ona başa sal. Mən isə sənin və onun ağzı ilə danışacağam. Sizə nə etməyi öyrədəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Sənin əvəzinə xalqla Harun danışacaq. O sənin üçün ağız kimi, sən isə onun üçün Allah kimi olacaqsan. ");
INSERT INTO azb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Bu əsanı əlinə götür; onunla əlamətlər göstərəcəksən». ");
INSERT INTO azb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa oradan getdi və qayınatası Yetronun yanına qayıdıb dedi: «İzin ver qayıdıb Misirdəki xalqımın yanına gedim, görüm onlar sağ-salamatdırlar ya yox?» Yetro Musaya dedi: «Salamat get». ");
INSERT INTO azb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Midyan torpağında Rəbb Musaya dedi: «Misirə qayıt, çünki sənin canını almaq istəyən adamların hamısı ölüb». ");
INSERT INTO azb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa arvadını və oğullarını götürüb eşşəyə mindirdi və Allahın buyurduğu əsanı əlinə götürüb Misirə yollandı. ");
INSERT INTO azb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Rəbb Musaya dedi: «Misirə qayıdanda sənə buyurduğum bütün möcüzələrə fikir ver və fironun hüzurunda onları göstər; ancaq Mən onun ürəyini inadkarlaşdıracağam və o, xalqı buraxmayacaq. ");
INSERT INTO azb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Firona söyləyəcəksən: “Rəbb belə deyir: İsrail Mənim oğlum, Mənim ilkimdir. ");
INSERT INTO azb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Sənə dedim ki, Mənə ibadət etmək üçün oğlumu burax! Sən isə onu buraxmaqdan boyun qaçırdın. Onda Mən sənin ilk oğlunu öldürəcəyəm”». ");
INSERT INTO azb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Yolda gecələyərkən Rəbb Musaya rast gəldi və onu öldürmək istədi. ");
INSERT INTO azb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","O zaman Sippora çaxmaq daşı götürüb oğlunu sünnət etdi və sünnət ətini Musanın ayaqlarına toxundurub dedi: «Sən mənim qan adaxlımsan». ");
INSERT INTO azb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Beləliklə, Rəbb ondan əl çəkdi. Sippora Musaya sünnətə görə «qan adaxlımsan» demişdi. ");
INSERT INTO azb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Rəbb Haruna dedi: «Musanı qarşılamaq üçün səhraya get». Harun gedib Allahın dağında qardaşına rast gəldi və onunla öpüşdü. ");
INSERT INTO azb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa Haruna Rəbb onu necə göndərdiyini bildirdi. Rəbbin bütün sözlərini və ona göstərmək üçün əmr etdiyi bütün əlamətləri barədə Haruna danışdı. ");
INSERT INTO azb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa və Harun gedib İsrail övladlarının bütün ağsaqqallarını topladılar. ");
INSERT INTO azb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Harun Rəbbin Musaya söylədiyi sözlərin hamısını onlara dedi və xalqın qarşısında əlamətlər göstərdi. ");
INSERT INTO azb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Xalq bunlara inandı. Onlar Rəbbin İsrail övladlarının əziyyətini görüb nəzər saldığını eşidəndə əyilib Ona səcdə etdilər. ");
INSERT INTO azb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Musa və Harun gəlib firona dedilər: «İsrailin Allahı Rəbb belə deyir: “Xalqımı burax ki, səhrada Mənim üçün bayram keçirsinlər!”» ");
INSERT INTO azb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firon dedi: «Rəbb kimdir ki, Onun səsinə qulaq asıb İsrail övladlarını buraxım? Rəbbi tanımıram, İsrail övladlarını da buraxmıram». ");
INSERT INTO azb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Onlar dedilər: «İbranilərin Allahı bizə göründü. Qoy səhrada üç gün yol gedək və Allahımız Rəbbə qurban gətirək ki, bizə vəba göndərməsin yaxud da qılıncla məhv etməsin». ");
INSERT INTO azb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Misir padşahı onlara dedi: «Ey Musa və Harun, nə üçün xalqı işindən ayırırsınız? Gedin, işinizi görün». ");
INSERT INTO azb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Sonra firon dedi: «Artıq ölkədə xalq çoxdur, siz isə onları işindən ayırıb istirahət verirsiniz». ");
INSERT INTO azb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Həmin gün firon xalqın nəzarətçilərinə və gözətçilərinə əmr edib dedi: ");
INSERT INTO azb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«İndiyə kimi etdiyinizdən fərqli olaraq, bir daha xalqa kərpic düzəltmək üçün saman verməyin. Qoy özləri gedib saman yığsınlar. ");
INSERT INTO azb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ancaq indiyə qədər onların üzərlərinə qoyduğunuz gündəlik kərpic sayını azaltmayın. Çünki onlar tənbəldirlər və buna görə də “gedək Allahımıza qurban gətirək” deyib fəryad edirlər. ");
INSERT INTO azb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Bu adamlara daha ağır iş verilsin ki, çox çalışsınlar və yalanlara fikir verməsinlər». ");
INSERT INTO azb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Xalqın nəzarətçi və gözətçiləri adamların yanına gəlib onlara dedilər: «Firon belə deyir: “Mən sizə saman verməyəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gedin, özünüz haradan istəyirsiniz, saman götürün, ancaq işiniz azalmayacaq”». ");
INSERT INTO azb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Xalq bütün Misir torpağına səpələnib saman əvəzinə küləş yığmağa başladı. ");
INSERT INTO azb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nəzarətçilər onları məcbur edərək deyirdilər: «Sizə saman verilən vaxt gördüyünüz gündəlik işi yerinə yetirin». ");
INSERT INTO azb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Firon nəzarətçiləri İsrail övladlarının üzərinə qoyduqları İsrailli gözətçiləri döyüb dedilər: «Niyə dünən və bu gün indiyə qədər olan gündəlik kərpic sayını yerinə yetirməmisiniz?» ");
INSERT INTO azb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","İsrail övladlarından olan gözətçilər fironun yanına gəlib ona fəryad edərək dedilər: «Qullarınla niyə belə rəftar edirsən? ");
INSERT INTO azb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Qullarına saman vermirlər, ancaq bizə “kərpiclər düzəldin” deyirlər. Budur, qulların döyülür. Bu sənin xalqının günahıdır». ");
INSERT INTO azb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","O isə dedi: «Tənbəlsiniz, tənbəl, buna görə də “gedək, Rəbbə qurban gətirək” deyirsiniz. ");
INSERT INTO azb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","İndi gedin işləyin. Sizə saman verilməyəcək, ancaq gündəlik kərpic sayını düzəltməlisiniz». ");
INSERT INTO azb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","İsrailli gözətçilər «sizin üçün müəyyən olunmuş gündəlik kərpic sayı azalmayacaq» sözlərini eşidəndə pis vəziyyətə düşdüklərini anladılar. ");
INSERT INTO azb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","İsrailli gözətçilər fironun yanından çıxanda yolda durub onları gözləyən Musa və Harunla rastlaşıb ");
INSERT INTO azb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","dedilər: «Qoy Rəbb sizin nə etdiyinizi görsün və sizi məhkum etsin! Siz bizi fironla əyanlarının gözündə iyrənc etdiniz və bizi öldürmək üçün əllərinə qılınc verdiniz». ");
INSERT INTO azb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa Rəbbə müraciət edib dedi: «Ey Xudavənd, nə üçün xalqı belə bəlaya saldın? Məni niyə göndərdin? ");
INSERT INTO azb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sənin adınla fironla danışmaq üçün gələndən bəri o bu xalqı bəlaya salır, Sən isə onları heç azad etmirsən». ");
INSERT INTO azb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Rəbb Musaya dedi: «İndi Mənim firona nə edəcəyimi görəcəksən: qüdrətli əllə məcbur olanda İsrail xalqını buraxacaq, qüdrətli əllə məcbur olub onları ölkəsindən qovacaq». ");
INSERT INTO azb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Sonra Allah Musaya dedi: «Mən Rəbbəm. ");
INSERT INTO azb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mən İbrahimə, İshaqa və Yaquba Külli-İxtiyar Allah adı ilə göründüm, ancaq Rəbb adı ilə Özümü onlara tanıtdırmadım. ");
INSERT INTO azb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Onlarla da Mən əhd bağladım ki, qərib yaşadıqları ölkəni – Kənan torpağını onlara verim. ");
INSERT INTO azb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","İndi də Misirlilərin əsarətdə saxladığı İsrail övladlarının iniltisini eşidib Öz əhdimi xatırladım. ");
INSERT INTO azb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Buna görə də İsrail övladlarına söylə: “Mən Rəbbəm. Sizi Misirlilərin zülmündən qurtaracağam, onların əsarətindən çıxaracağam və qolumu uzadıb böyük cəzalar bahasına sizi satın alacağam. ");
INSERT INTO azb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Sizi Özümə xalq edəcəyəm və sizin Allahınız olacağam. Onda biləcəksiniz ki, sizi Misirlilərin zülmündən qurtaran Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mən İbrahimə, İshaqa və Yaquba and içərək verəcəyimi vəd etdiyim torpağa sizi aparıb, oranı sizə mülk olaraq verəcəyəm. Mən Rəbbəm”». ");
INSERT INTO azb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa İsrail övladlarına elə söylədi. Ancaq onlar ruhdan düşdüklərinə və ağır əsarət çəkdiklərinə görə Musaya qulaq asmadılar. ");
INSERT INTO azb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Misir padşahı fironun yanına gedib söylə ki, İsrail övladlarını ölkəsindən buraxsın!» ");
INSERT INTO azb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa Rəbbin önündə dedi: «İsrail övladları mənə qulaq asmadı, firon mənə necə qulaq asacaq? Mən yaxşı danışa bilmirəm». ");
INSERT INTO azb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Rəbb Musa və Harunla danışıb onlara İsrail övladları və Misir padşahı firon üçün əmrlər verdi ki, İsrail övladlarını Misir torpağından çıxartsınlar. ");
INSERT INTO azb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","İsrail övladlarının nəsil başçıları bunlardır: İsrailin ilk oğlu Ruvenin oğulları: Xanok, Pallu, Xesron və Karmi; Ruvenin nəsli bunlardan ibarətdir. ");
INSERT INTO azb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Şimeonun oğulları: Yemuel, Yamin, Ohad, Yakin, Sohar və Kənanlı bir qadının oğlu Şaul; Şimeonun nəsli bunlardan ibarətdir. ");
INSERT INTO azb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Nəsillərinə görə Levinin oğulları bunlardır: Gerşon, Qohat və Merari. Levi yüz otuz yeddi il ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Nəsillərinə görə Gerşonun oğulları: Livni və Şimey. ");
INSERT INTO azb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Qohatın oğulları: Amram, İshar, Xevron və Uzziel; Qohat yüz otuz üç il ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarinin oğulları: Maxli və Muşi; nəsillərinə görə Levinin ailəsi bunlardan ibarətdir. ");
INSERT INTO azb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram bibisi Yokevedi arvad olaraq aldı; arvadı ona Harunu və Musanı doğdu. Amram yüz otuz yeddi il ömür sürdü. ");
INSERT INTO azb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","İsharın oğulları: Qorah, Nefeq və Zikri. ");
INSERT INTO azb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzzielin oğulları: Mişael, Elsafan və Sitri. ");
INSERT INTO azb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Harun Naxşonun bacısı Amminadavın qızı Elişevanı arvad aldı; arvadı ona Nadavı, Avihunu, Eleazarı və İtamarı doğdu. ");
INSERT INTO azb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Qorahın oğulları: Assir, Elqana və Aviasaf; Qorahın ailəsi bunlardan ibarətdir. ");
INSERT INTO azb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Harunun oğlu Eleazar Putielin qızlarından birini arvad aldı; arvadı ona Pinxası doğdu. Ailələrinə görə Levililərin nəsil başçıları bunlardır. ");
INSERT INTO azb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Adları çəkilən Harun və Musa o adamlardır ki, Rəbb onlara «İsrail övladlarını dəstələrlə Misir torpağından çıxarın» demişdi. ");
INSERT INTO azb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Onlar həmin Musa və Harun idi ki, İsrail övladlarını Misir torpağından çıxarmaq üçün Misir padşahı fironla danışmışdılar. ");
INSERT INTO azb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Misir torpağında Rəbbin Musa ilə danışdığı gün ");
INSERT INTO azb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Rəbb Musaya dedi: «Mən Rəbbəm! Sənə dediyim bütün sözləri Misir padşahı firona söylə». ");
INSERT INTO azb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Musa Rəbbin önündə dedi: «Mən yaxşı danışa bilmirəm, firon mənə necə qulaq asacaq?» ");
INSERT INTO azb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Rəbb Musaya dedi: «Səni firon üçün Allah kimi qoydum, qardaşın Harun isə sənin peyğəmbərin olacaq. ");
INSERT INTO azb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mənim sənə verdiyim əmri qardaşın Haruna söylə. Qoy o da firona söyləsin ki, İsrail övladlarını ölkəsindən buraxsın! ");
INSERT INTO azb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lakin Mən fironun ürəyini inadkar edəcəyəm ki, Misir torpağında göstərəcəyim çoxlu əlamətlər və möcüzələrə baxmayaraq, ");
INSERT INTO azb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","firon sizə qulaq asmasın. Onda Mən əlimi Misir torpağına uzadıb böyük cəzalar göndərərək ordularımı – xalqım İsrail övladlarını onların arasından dəstələrlə çıxaracağam. ");
INSERT INTO azb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Əlimi Misir torpağına uzadaraq İsrail övladlarını onların arasından çıxardığım vaxt Misirlilər biləcəklər ki, Rəbb Mənəm!» ");
INSERT INTO azb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Rəbb Musa və Haruna necə əmr etmişdisə, onlar da elə etdilər. ");
INSERT INTO azb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Fironla danışdıqları vaxt Musanın səksən, Harunun isə səksən üç yaşı var idi. ");
INSERT INTO azb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Firon sizə “məni inandırmaq üçün bir möcüzə göstərin” deyəndə Musa Haruna desin: “Öz əsanı götürüb fironun önündə yerə at ki, ilana dönsün”». ");
INSERT INTO azb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa və Harun fironun yanına gəlib Rəbb necə əmr etmişdisə, elə də etdilər. Harun öz əsasını fironun və onun əyanlarının qarşısında yerə atdı və əsa ilana döndü. ");
INSERT INTO azb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Firon isə müdrik adamları və cadugərləri çağırdı. Misir sehrbazları da öz sehrləri ilə belə etdilər. ");
INSERT INTO azb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Hər biri öz əsasını yerə atıb ilana döndərdi, ancaq Harunun əsası onların əsalarını uddu. ");
INSERT INTO azb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Lakin Rəbbin söylədiyi kimi fironun ürəyi inadkar oldu və onlara qulaq asmadı. ");
INSERT INTO azb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Rəbb Musaya dedi: «Fironun inadkar ürəyi var, xalqı buraxmaqdan boyun qaçırır. ");
INSERT INTO azb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sən sabah səhər firon suya tərəf gedəndə qarşısına çıx. İlana dönən əsanı əlinə götürüb, onu Nil çayının sahilində gözlə. ");
INSERT INTO azb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Sonra firona de: “İbranilərin Allahı Rəbb məni yanına göndərdi ki, sənə deyim: ‹Xalqımı burax ki, səhrada Mənə ibadət etsin!› Ancaq sən indiyə qədər qulaq asmadın, ");
INSERT INTO azb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","buna görə də Rəbb belə deyir: ‹Bundan biləcəksən ki, Rəbb Mənəm. Bax mən əlimdəki əsanı Nil çayının suyuna vuracağam, onda su qana dönəcək. ");
INSERT INTO azb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Çayda olan balıqlar öləcək və çay iylənəcək, Misirlilər çaydan su içməyə iyrənəcəklər›”». ");
INSERT INTO azb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Rəbb Musaya dedi: «Haruna belə söylə: “Əsanı götür və əlini bütün Misir çayları, arxları, gölləri, hovuzları üzərinə uzat”. Onlar qana dönsün, bundan başqa bütün Misir torpağında həm taxta, həm də daş qablarda qan olacaq». ");
INSERT INTO azb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Rəbb Musa və Haruna necə əmr etmişdisə, onlar da elə etdilər: fironun və onun əyanlarının qarşısında Harun əsasını qaldırdı və çaydakı suya vurdu. Nil çayındakı bütün su qana döndü; ");
INSERT INTO azb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","çaydakı balıqlar öldü və çay iyləndi. Misirlilər buradan su içə bilmədilər. Misir torpağı qan içində idi. ");
INSERT INTO azb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Amma Misir sehrbazları da öz sehrləri ilə belə etdilər. Rəbbin söylədiyi kimi fironun ürəyi inadkar oldu və onlara qulaq asmadı. ");
INSERT INTO azb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firon qayıdıb öz sarayına gəldi; bu işi də ürəyinə salmadı. ");
INSERT INTO azb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bütün Misirlilər Nil çayı sahilində yer qazmağa başladılar ki, içməli su tapsınlar. Çünki çayın suyundan içə bilmirdilər. ");
INSERT INTO azb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Rəbb çaya bəla göndərəndən sonra yeddi gün keçdi. ");
INSERT INTO azb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Rəbb Musaya dedi: «Fironun yanına gedib ona söylə: “Rəbb belə deyir: xalqımı burax ki, Mənə ibadət etsin! ");
INSERT INTO azb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Əgər sən xalqımı buraxmaq istəməsən, mən sənin bütün torpağını qurbağalarla doldurub bəlaya salacağam. ");
INSERT INTO azb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Çay qurbağalarla qaynaşacaq və oradan çıxıb sənin sarayında, yataq otağında, yatağının üstündə gəzəcəklər, əyanlarının, xalqının evlərinə, təndirlərinə və xəmir tabaqlarına girəcəklər. ");
INSERT INTO azb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Sənin, xalqının və bütün əyanlarının üstünə qurbağalar çıxacaq”». ");
INSERT INTO azb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Rəbb Musaya dedi: «Haruna belə söylə: əsanı götür və əlini çayların, arxların və göllərin üzərinə uzat. Qoy Misir torpağı qurbağalarla dolsun». ");
INSERT INTO azb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Harun əlini Misir suları üzərinə uzatdı və oradan qurbağalar çıxıb Misir torpağını bürüdü. ");
INSERT INTO azb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Sehrbazlar da öz sehrləri ilə belə etdilər və Misir torpağına qurbağalar yetirdilər. ");
INSERT INTO azb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Firon Musanı və Harunu çağırıb dedi: «Rəbbə yalvarın ki, məndən və xalqımdan qurbağaları rədd etsin, onda Rəbbə qurban gətirmək üçün xalqı buraxaram». ");
INSERT INTO azb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa firona dedi: «Söylə, nə vaxt sənin, əyanların və xalqın üçün dua edim ki, qurbağalar səndən və evlərindən yox olsun və yalnız çayda qalsınlar?» ");
INSERT INTO azb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firon dedi: «Sabah». Musa dedi: «Sən dediyin kimi olacaq. Bundan biləcəksən ki, Allahımız Rəbbə bənzəri yoxdur! ");
INSERT INTO azb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Qurbağalar səndən, evlərindən, əyanlarından və xalqından rədd olacaq, yalnız çayda qalacaqlar». ");
INSERT INTO azb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musa və Harun fironun yanından çıxdılar. Musa Rəbbin fironun üzərinə göndərdiyi qurbağalara görə Ona yalvardı. ");
INSERT INTO azb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Rəbb də Musanın sözünə əməl etdi. Evlərdə, həyətlərdə, tarlalarda olan qurbağalar öldü. ");
INSERT INTO azb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Onları qalaq-qalaq yığdılar və torpaq iylənməyə başladı. ");
INSERT INTO azb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ancaq firon vəziyyətin yüngülləşdiyini görəndə Rəbbin söylədiyi kimi ürəyində inad etdi və onlara qulaq asmadı. ");
INSERT INTO azb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Rəbb Musaya dedi: «Haruna belə söylə: “Əsanı uzadıb yerin tozuna vur ki, o bütün Misir ölkəsində mığmığalara dönsün”». ");
INSERT INTO azb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Onlar belə də etdilər. Harun əlindəki əsanı uzadıb yerin tozuna vurdu və insanların da, heyvanların da üstünə mığmığalar qondu. Bütün Misir torpağında yerin tozu mığmığaya döndü. ");
INSERT INTO azb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Sehrbazlar da öz sehrləri ilə mığmığalar gətirmək istədilər, ancaq bunu bacarmadılar. İnsanların da, heyvanların da üstünə mığmığalar qondu. ");
INSERT INTO azb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Sehrbazlar firona dedilər: «Bunda Allahın əli var». Ancaq Rəbbin söylədiyi kimi fironun ürəyi inadkar oldu və o qulaq asmadı. ");
INSERT INTO azb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Rəbb Musaya dedi: «Səhər tezdən qalx. Firon suya tərəf gedəndə onun qarşısına gedib belə söylə: “Rəbb belə deyir: xalqımı burax ki, Mənə ibadət etsin! ");
INSERT INTO azb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Əgər sən onları azad etmək istəməsən, sənin, əyanlarının, xalqının üzərinə və evlərinin içinə mozalan yığınları göndərəcəyəm. Misirlilərin evləri, yaşadıqları torpaq mozalanlarla dolacaq. ");
INSERT INTO azb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ancaq o gün xalqımın yaşadığı Qoşen torpağını ayıracağam ki, orada mozalanlar olmasın. Bundan biləcəksən ki, bu ölkədə Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Sənin xalqınla Öz xalqım arasında fərq qoyacağam. Bu əlamət sabah olacaq”». ");
INSERT INTO azb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Rəbb belə də etdi. Fironun sarayını, əyanlarının evlərini, bütün Misir torpağını ağır mozalan yığını basdı. Mozalanların əlindən ölkə viran oldu. ");
INSERT INTO azb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Firon Musanı və Harunu çağırıb dedi: «Gedin, bu ölkədə öz Allahınıza qurban gətirin». ");
INSERT INTO azb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ancaq Musa dedi: «Belə etmək olmaz, çünki bizim Allahımız Rəbbə qurban kəsməyimiz Misirlilərdə ikrah hissi oyadacaq. Misirlilərin qabağında ikrah oyadan qurbanlar kəssək, onlar bizi daşqalaq etməzlərmi? ");
INSERT INTO azb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Biz istəyirik ki, səhrada üç gün yol gedək və Allahımız Rəbbin bizə əmr etdiyi kimi qurban gətirək». ");
INSERT INTO azb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Firon dedi: «Mən sizi buraxıram ki, səhrada Allahınız Rəbbə qurban gətirəsiniz, ancaq çox uzağa getməyin. Mənim üçün də yalvarın». ");
INSERT INTO azb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa dedi: «Mən sənin yanından gedirəm. Rəbbə dua edəcəyəm ki, sabah fironu, əyanlarını və xalqını mozalanlardan qurtarsın. Ancaq qoy firon xalqı Rəbbə qurban gətirməyə buraxmamaqla yenə də bizi aldatmasın». ");
INSERT INTO azb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Musa fironun yanından gedib Rəbbə yalvardı. ");
INSERT INTO azb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Rəbb Musanın sözünə əməl etdi. Fironu, əyanlarını və xalqını mozalanlardan qurtardı. Daha mozalan qalmadı. ");
INSERT INTO azb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ancaq bu dəfə də firon ürəyində inadkarlıq etdi və xalqı buraxmadı. ");
INSERT INTO azb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Rəbb Musaya dedi: «Fironun yanına gedib ona söylə: “İbranilərin Allahı Rəbb belə deyir: xalqımı burax ki, Mənə ibadət etsin! ");
INSERT INTO azb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Əgər sən onları buraxmaqdan boyun qaçırıb saxlamağı davam etsən, ");
INSERT INTO azb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","budur, Rəbb tarlanda olan heyvanların – at, eşşək, dəvə, mal-qara və qoyun-keçinin üzərinə əlini qaldıracaq; çox ağır qırğın olacaq. ");
INSERT INTO azb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ancaq Rəbb İsrail övladlarının heyvanları ilə Misirlilərin heyvanları arasında fərq qoyacaq. İsrail övladlarına məxsus olan heyvanlardan heç biri ölməyəcək”». ");
INSERT INTO azb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Rəbb vaxt təyin edib dedi: «Rəbb bunu ölkədə sabah edəcək». ");
INSERT INTO azb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Məhz bunu da Rəbb səhəri gün etdi. Misirlilərin bütün heyvanları öldü. Ancaq İsrail övladlarının heyvanlarından heç biri ölmədi. ");
INSERT INTO azb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firon vəziyyəti soruşdu və İsrail övladlarının heyvanlarından heç birinin ölmədiyi barədə xəbər aldı. Ancaq fironun ürəyi inadkar oldu və o, xalqı buraxmadı. ");
INSERT INTO azb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Rəbb Musaya və Haruna dedi: «Kürədən əlinizə ovuc-ovuc qurum götürün. Qoy Musa onu fironun gözü önündə göyə səpsin. ");
INSERT INTO azb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Bütün Misir torpağında toz qalxacaq, insanların və heyvanların bədənində irinli çibanlar əmələ gətirəcək». ");
INSERT INTO azb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Onlar kürə qurumunu götürüb fironun hüzurunda dayandılar. Musa onu göyə qədər səpdi, insanların və heyvanların bədəninə irinli çibanlar çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Sehrbazlar da bu cəzaya görə Musanın qabağında dayana bilmədilər, çünki sehrbazların və bütün Misirlilərin bədənlərinə çibanlar çıxmışdı. ");
INSERT INTO azb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Rəbbin Musaya söylədiyi kimi oldu: Rəbb fironun ürəyini inadkar etdi və firon onlara qulaq asmadı. ");
INSERT INTO azb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Rəbb Musaya dedi: «Sabah səhər tezdən qalx və fironun qarşısına gedib ona belə söylə: “İbranilərin Allahı Rəbb belə deyir: xalqımı burax ki, Mənə ibadət etsin! ");
INSERT INTO azb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Çünki Mən bu dəfə sənin ürəyinə, əyanlarının və xalqının da üzərinə bütün bəlalarımı göndərəcəyəm. Bundan biləcəksən ki, bütün dünyada Mənə bənzər yoxdur. ");
INSERT INTO azb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Əgər indi əlimi uzadıb səni və xalqını qırğınla cəzalandırmış olsaydım, yer üzündən silinib atılardın. ");
INSERT INTO azb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Amma ona görə səni qoruyub saxladım ki, Öz gücümü sənə göstərim və adım bütün dünyaya elan edilsin. ");
INSERT INTO azb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Sən hələ də Mənim xalqıma qarşı durmusan və onu buraxmırsan. ");
INSERT INTO azb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Budur, Mən sabah bu vaxt çox güclü bir dolu göndərəcəyəm: elə bir dolu ki Misir qurulandan indiyə qədər orada olmayıb. ");
INSERT INTO azb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","İndi heyvanlarını və çöldə olan hər şeyini apar, çünki tarlada qalan bütün insanlar və heyvanlar evə gətirilməsə, onların üzərinə dolu yağacaq və öləcəklər”». ");
INSERT INTO azb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Fironun əyanlarından bəzisi Rəbbin sözündən qorxub öz qul və heyvanlarını tələsik evlərinə gətirdi. ");
INSERT INTO azb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Rəbbin sözünə etinasızlıq edənlər isə öz qul və heyvanlarını tarlada qoydular. ");
INSERT INTO azb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Rəbb Musaya dedi: «Əlini göyə uzat. Qoy bütün Misir torpağına və orada olan insanların, heyvanların və bütün tarla bitkilərinin üzərinə dolu yağsın». ");
INSERT INTO azb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa əsasını göyə qaldırdı. Rəbb ildırımla dolu göndərdi və yerə od düşdü; Rəbb Misir torpağı üzərinə dolu yağdırdı. ");
INSERT INTO azb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Beləliklə, çox güclü bir dolu yağdı. Dolu içində od alışırdı; Misir milləti mövcud olduğu vaxtdan bəri burada belə dolu olmamışdı. ");
INSERT INTO azb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Dolu bütün Misir torpağında insandan tutmuş heyvana və tarla bitkilərinə qədər hər şeyi məhv etdi. Çöldə bitən bütün otlar və ağaclar tələf oldu. ");
INSERT INTO azb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ancaq İsrail övladlarının yaşadığı Qoşen torpağına dolu yağmadı. ");
INSERT INTO azb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firon Musanı və Harunu çağırtdırıb onlara dedi: «Bu dəfə günah etdim. Rəbb ədalətlidir, mən və xalqım isə haqsızıq. ");
INSERT INTO azb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kifayətdir! Rəbbə yalvarın ki, bu dəhşətli ildırım və dolu dayansın. Sizi azad edərəm, daha burada qalmayın». ");
INSERT INTO azb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa ona dedi: «Şəhərdən çıxanda əlimi Rəbbə tərəf qaldıracağam, ildırım dayanacaq və daha dolu yağmayacaq. Bundan biləcəksən ki, dünya Rəbbə məxsusdur. ");
INSERT INTO azb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ancaq mən bilirəm ki, sən və əyanların yenə də Rəbb Allahdan qorxmursunuz». ");
INSERT INTO azb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Bu vaxt kətan və arpa məhsulu məhv oldu, çünki arpa dən gətirmiş, kətan isə qozalanmışdı. ");
INSERT INTO azb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ancaq buğda və pərinc məhsulu məhv olmadı, çünki onlar gec yetişir. ");
INSERT INTO azb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa fironun yanından ayrılıb şəhərdən çıxdı və əlini Rəbbə tərəf qaldırdı; ildırım və dolu dayandı və yerə yağış yağmadı. ");
INSERT INTO azb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Firon yağışın, dolunun və ildırımın dayandığını görüb yenə də günah etməyə başladı, özü və əyanları ürəklərini inadkar etdilər. ");
INSERT INTO azb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Rəbbin Musa vasitəsilə söylədiyi kimi fironun ürəyi inadkarlaşdı və o, İsrail övladlarını buraxmadı. ");
INSERT INTO azb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Rəbb Musaya dedi: «Fironun yanına get. Mən fironun və əyanlarının ürəyini ona görə inadkar etmişəm ki, onların arasında Öz əlamətlərimi göstərim. ");
INSERT INTO azb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Sən isə Misirdə nə cür işlər etdiyimi və onlara göstərdiyim əlamətləri oğluna və nəvənə nəql edərsən. Onda biləcəksiniz ki, Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musa və Harun yenə fironun yanına gəlib ona söylədilər: «İbranilərin Allahı Rəbb belə deyir: “Nə vaxta qədər qarşımda özünü aşağı tutmaqdan imtina edəcəksən? Xalqımı burax ki, Mənə ibadət etsin! ");
INSERT INTO azb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Əgər sən Mənim xalqımı azad etməsən, Mən sabah ölkənə çəyirtkələr göndərəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Çəyirtkələr yer üzünü elə örtəcək ki, torpağı görmək olmayacaq. Dolu yağandan sonra sizə qalan şeyləri də onlar yeyəcəklər; tarladakı ağaclarınızın verdiyi zoğları da yeyəcəklər. ");
INSERT INTO azb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Onlar sənin, əyanlarının və bütün Misirlilərin evlərini dolduracaqlar. Belə şeyi nə ataların, nə də babaların bu torpaqda məskən saldıqları gündən indiyə qədər görməmişdilər”». Musa dönüb fironun yanından çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Fironun əyanları ona dedilər: «Nə vaxta qədər bu adam bizə tələ quracaq? Bu adamları burax, qoy onlar özlərinin Allahı Rəbbə ibadət etsinlər. Məgər sən hələ bilmirsən ki, Misir məhv olur?» ");
INSERT INTO azb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Musanı və Harunu yenə fironun yanına çağırdılar. Firon onlara dedi: «Gedin, Allahınız Rəbbə ibadət edin. Ancaq deyin görək kimlər gedəcək?» ");
INSERT INTO azb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa dedi: «Uşaq, qoca, oğul, qızlarımız, qoyun-keçi və mal-qaramızla birgə gedəcəyik, çünki Rəbbə bayram etməliyik». ");
INSERT INTO azb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firon onlara dedi: «Əgər mən sizi arvad-uşağınızla birgə buraxsam, qoy Rəbb sizə kömək olsun! Yəqin sizin pis niyyətiniz var. ");
INSERT INTO azb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Belə olmaz! Siz kişilər gedin və Rəbbə ibadət edin. Məgər bunu istəmirsiniz?» Sonra firon onları öz hüzurundan qovdu. ");
INSERT INTO azb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Onda Rəbb Musaya dedi: «Əlini Misir torpağının üzərinə uzat. Qoy Misir torpağına çəyirtkələr hücum etsin və bütün ölkənin bitkilərini, dolu yağandan sonra qalan hər şeyi yesinlər». ");
INSERT INTO azb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa əsasını Misir torpağının üzərinə uzatdı. Rəbb ölkəyə bütün o günü və gecəni davam edən şərq küləyi göndərdi. Səhər açılanda şərq küləyi özü ilə çəyirtkələr gətirdi. ");
INSERT INTO azb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Çəyirtkələr Misir ölkəsinə hücum edərək bütün Misir torpağına yayıldılar. Onlar o qədər çox idi ki, bu qədəri heç vaxt olmayıb və bundan sonra da olmayacaq. ");
INSERT INTO azb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Çəyirtkələr bütün yer üzünü elə bürüdü ki, torpaq görünmürdü. Onlar ölkənin bütün bitkilərini və dolu yağandan sonra qalan bütün meyvələrini yedilər; bütün Misir torpağında nə ağaclarda, nə də çöllüklərdə heç bir yaşıllıq qalmadı. ");
INSERT INTO azb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Firon tələsik Musanı və Harunu çağırıb onlara dedi: «Allahınız Rəbbə və sizə qarşı günah etdim, ");
INSERT INTO azb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","xahiş edirəm, təkcə bu dəfə günahımı bağışlayın və Allahınız Rəbbə yalvarın ki, bu ölümcül bəla məni tərk etsin». ");
INSERT INTO azb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa fironun yanından çıxıb Rəbbə yalvardı. ");
INSERT INTO azb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Rəbb küləyi döndərib çox güclü qərb küləyi göndərdi və külək çəyirtkələri aparıb Qırmızı dənizə atdı və bütün Misir ölkəsində bir çəyirtkə belə, qalmadı. ");
INSERT INTO azb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ancaq Rəbb fironun ürəyini inadkarlaşdırdı və o, İsrail övladlarını buraxmadı. ");
INSERT INTO azb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Sonra Rəbb Musaya dedi: «Əlini göyə tərəf uzat ki, Misir torpağında zülmət, qatı qaranlıq olsun». ");
INSERT INTO azb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa əlini göyə tərəf uzatdı və Misir torpağında üç gün qatı zülmət oldu. ");
INSERT INTO azb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Üç gün heç kəs bir-birini görmədi və heç kəs yerindən tərpənə bilmədi. Bütün İsrail övladlarının yaşadıqları yerlər isə işıqlıq idi. ");
INSERT INTO azb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Firon Musanı çağırıb dedi: «Gedin, Rəbbə ibadət edin. Qoy uşaqlarınız da sizinlə getsin, ancaq qoyun-keçiniz və mal-qaranız burada qalsın». ");
INSERT INTO azb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa isə dedi: «Sən bizə ünsiyyət qurbanları və yandırma qurbanları da verməlisən ki, Allahımız Rəbbə qurban gətirək. ");
INSERT INTO azb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Heyvanlarımız da bizimlə getməlidir: bir dırnaqlı da qalmamalıdır, çünki Allahımız Rəbbə qurban gətirmək üçün onları götürməliyik. Ancaq biz oraya gedib çatmamış Rəbbə nəyi qurban gətirəcəyimizi bilmirik». ");
INSERT INTO azb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Rəbb fironun ürəyini inadkar etdi və o, İsrail övladlarını buraxmaq istəmədi. ");
INSERT INTO azb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Sonra firon Musaya dedi: «Rədd ol, özünü gözlə və bir də mənim gözümə görünmə. Yenə də gözümə görünsən, öləcəksən». ");
INSERT INTO azb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa dedi: «Düz deyirsən, bir daha gözünə görünmərəm». ");
INSERT INTO azb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Sonra Rəbb Musaya dedi: «Fironun və Misirlilərin üzərinə daha bir cəza göndərəcəyəm. Bundan sonra o sizi buradan buraxacaq. Hətta nəinki buraxacaq, buradan tamam qovacaq. ");
INSERT INTO azb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Xalqa çatdır ki, hər kişi öz qonşusundan və hər qadın öz rəfiqəsindən qızıl-gümüş əşyalar istəsin». ");
INSERT INTO azb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Rəbb Öz xalqına Misirlilərin gözündə lütf qazandırdı. Musa özü də Misir ölkəsində fironun əyanlarının və xalqın gözündə çox böyük adam idi. ");
INSERT INTO azb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa dedi: «Rəbb belə deyir: “Gecə yarısı Mən Misirin ortasından keçəcəyəm; ");
INSERT INTO azb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Misir torpağında taxtda oturan fironun oğlundan tutmuş dəyirman arxasında olan kəniz oğluna qədər hamının ilk oğlu öləcək. Hətta bütün heyvanların da ilk balaları öləcək. ");
INSERT INTO azb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Bütün Misir torpağında elə böyük fəryad qopacaq ki, indiyədək beləsi olmamışdır və bundan sonra da olmayacaq. ");
INSERT INTO azb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Lakin bütün İsraillilərin arasında nə insanların, nə də heyvanların üstünə heç it də hürməyəcək. Bundan biləcəksiniz ki, Rəbb İsrail övladları ilə Misirlilər arasında fərq qoymuşdur”. ");
INSERT INTO azb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Sonra bütün bu qulların yanıma gələcək və mənə təzim edib deyəcəklər: “Sən və ardınca gələn bütün xalq buradan çıxın!” Bundan sonra mən çıxacağam». Sonra Musa qızğın qəzəblə fironun yanından çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Rəbb Musaya demişdi: «Misir torpağında möcüzələrim çoxalsın deyə firon sizə qulaq asmayacaq». ");
INSERT INTO azb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa və Harun bütün bu möcüzələri fironun hüzurunda göstərdilər. Ancaq Rəbb fironun ürəyini inadkarlaşdırdı və o, İsrail övladlarını öz torpağından buraxmırdı. ");
INSERT INTO azb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Misir torpağında Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Bu ay sizin üçün ilin ilk ayı olacaq. ");
INSERT INTO azb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Bütün İsrail icmasına söyləyin: qoy bu ayın onuncu günündə hər kəs öz ailəsi üçün bir quzu, hər ev üçün bir quzu götürsün. ");
INSERT INTO azb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Əgər bir adamın ailəsi bir quzu üçün sayca azdırsa, qoy o adam evinə yaxın qonşusu ilə birgə bir quzu götürüb insanların sayına, hər kəsin yeyəcəyinə görə bölsün. ");
INSERT INTO azb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Özünüzə birillik qüsursuz erkək heyvan götürün: ya qoyunlardan bir toğlu yaxud keçilərdən bir çəpiş olsun. ");
INSERT INTO azb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Onu ayın on dördüncü gününə qədər saxlayın. Qoy axşamçağı bütün İsrail icmasının camaatı onu kəssin. ");
INSERT INTO azb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Qurbanın qanından götürüb onu yeyəcəkləri evin qapısının hər iki yan taxtasına və üst dirəyinə sürtsünlər. ");
INSERT INTO azb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Qoy həmin gecə onun ətini yesinlər; əti odda bişirib mayasız çörək və acı göyərti ilə yesinlər. ");
INSERT INTO azb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Onu çiy yaxud suda qaynadılmış halda yox, başı, ayaqları və içalatı ilə birgə odda bişirilmiş halda yeyin. ");
INSERT INTO azb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ondan səhərə qədər bir şey saxlamayın və səhər qalanını yandırın. ");
INSERT INTO azb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Onu belə yeyin: beliniz qurşanmış, çarıqlarınız ayağınızda və dəyənəyiniz əlinizdə olsun, onu tələsik yeyin. Bu, Rəbbin Pasxasıdır. ");
INSERT INTO azb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Mən isə o gecə Misir torpağından keçəcəyəm. Misir torpağında olan həm insanların bütün ilk oğullarını, həm də heyvanların bütün ilk balalarını öldürəcəyəm. Bütün Misir allahlarına da cəza verəcəyəm. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Sizin olduğunuz evlər üzərindəki qan sizin üçün əlamət olacaq. Qanı görəndə yan keçəcəyəm və Misir ölkəsini cəzalandırdığım zaman sizə məhvedici bəla gəlməyəcək. ");
INSERT INTO azb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Bu gün sizin üçün xatirə günü olacaq və onu Rəbb üçün bayram edəcəksiniz. Nəsildən-nəslə əbədi qayda olaraq onu bayram edin. ");
INSERT INTO azb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yeddi gün mayasız çörək yeyin. Hətta birinci gün evlərinizdən mayanı yığışdırın. Çünki birinci gündən yeddinci günə qədər mayalı çörək yeyən hər kəsin ayağı İsrail övladlarının arasından kəsilməlidir. ");
INSERT INTO azb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sizin üçün birinci və yeddinci günlərdə müqəddəs toplantı olsun. Bu günlər hər kəs özünə yemək hazırlamaqdan başqa heç bir iş görməsin. ");
INSERT INTO azb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Bu Mayasız Çörək bayramına ona görə riayət edin ki, məhz həmin gün sizi dəstələrlə Misir torpağından çıxartdım. Qoy nəsildən-nəslə bu sizin üçün əbədi qayda olsun və bu günə riayət edin. ");
INSERT INTO azb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Birinci ayın on dördüncü gününün axşamından ayın iyirmi birinci gününün axşamına qədər mayasız çörək yeyin. ");
INSERT INTO azb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Yeddi gün evinizdə maya olmasın, çünki mayalı bir şey yeyən hər kəs istər ölkədə qərib, istərsə də yerli olsun, ayağı İsrail icmasının arasından kəsilməlidir. ");
INSERT INTO azb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Heç bir mayalı şey yeməyin, yaşadığınız hər bir yerdə mayasız çörək yeyin». ");
INSERT INTO azb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa İsrailin bütün ağsaqqallarını çağırıb dedi: «Ailələrinizə görə özünüz üçün toğlu ya çəpiş seçib götürün və Pasxa qurbanını kəsin. ");
INSERT INTO azb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bir çəngə züfa otu götürüb ləyəndə olan qana batırın və oradakı qandan qapının üst dirəyinə və yan taxtalarına sürtün. Səhərə qədər heç kəs evinin qapısından çıxmasın. ");
INSERT INTO azb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Rəbb Misirliləri bəlaya salmaq üçün gələndə qapının üst dirəyinin və hər iki yan taxtasının üzərində qan görüb o qapıdan yan keçəcək. Məhvedicini evinizə girməyə qoymayacaq. ");
INSERT INTO azb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Buna özünüz və övladlarınız üçün əbədi qayda kimi həmişə riayət edin. ");
INSERT INTO azb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Rəbbin söylədiyi kimi sizə verdiyi torpağa çatanda bu ibadətə riayət edərsiniz. ");
INSERT INTO azb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Övladlarınız sizdən “Bu ibadətin mənası sizin üçün nədir?” deyə soruşduqları zaman ");
INSERT INTO azb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","onlara söyləyin: “Bu, Misirliləri bəlaya saldığı zaman Misirdə İsrail övladlarının evləri yanından keçib xilas edən Rəbb üçün Pasxa qurbanıdır”». Xalq əyilib səcdə etdi. ");
INSERT INTO azb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Rəbb Musaya və Haruna necə əmr etmişdisə, İsrail övladları gedib elə də etdilər. ");
INSERT INTO azb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gecəyarısı Rəbb Misir torpağında olan bütün ilk oğulları öldürdü; taxtda oturan fironun ilk oğlundan tutmuş zindanda olan əsirin ilk oğluna qədər hər ilk oğul, heyvanların hər ilk balası da öldü. ");
INSERT INTO azb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","O gecə firon, onun əyanları və bütün Misirlilər qalxdılar. Misirdən böyük bir fəryad qopdu, çünki elə bir ev yox idi ki, orada ölən olmasın. ");
INSERT INTO azb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Firon gecə Musanı və Harunu çağırıb dedi: «Çıxın gedin! Həm özünüz, həm də bütün İsraillilər xalqımın arasından çıxın gedin, istədiyiniz kimi Rəbbə ibadət edin. ");
INSERT INTO azb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Necə ki deyirdiniz, qoyun-keçinizi və mal-qaranızı da götürüb gedin, mənə də xeyir-dua verin». ");
INSERT INTO azb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirlilər xalqı ölkədən tələsik qovdular. Onlar deyirdilər: «Yoxsa hamımız öləcəyik». ");
INSERT INTO azb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Xalq maya qata bilmədiyi xəmiri götürdü, paltarlarına bürünmüş xəmir tabaqlarını çiyinlərində apardı. ");
INSERT INTO azb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","İsrail övladları Musanın sözünə əməl etdilər. Misirlilərdən qızıl-gümüş əşyalar və paltar istədilər. ");
INSERT INTO azb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Rəbb xalqa Misirlilərin gözündə lütf qazandırdı və onlara istədiklərini verdilər. Beləcə onlar Misirliləri soydular. ");
INSERT INTO azb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","İsrail övladları Ramsesdən Sukkota yola düşdülər. Arvad-uşaqdan əlavə, altı yüz minə qədər piyada gedən kişi var idi. ");
INSERT INTO azb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Qarışıq bir izdiham, çoxlu qoyun-keçi, mal-qara sürüləri də onlarla birgə yollandı. ");
INSERT INTO azb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Misirdən çıxardıqları maya qatılmayan xəmirdən mayasız kökələr bişirdilər. Çünki Misirdən qovulmuşdular və orada qalıb özlərinə yol üçün azuqə hazırlaya bilməmişdilər. ");
INSERT INTO azb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","İsrail övladlarının Misirdə yaşadığı müddət dörd yüz otuz il olmuşdu. ");
INSERT INTO azb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Məhz bu dörd yüz otuz il tamam olan gün Rəbbin bütün dəstələri Misir torpağından çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Rəbb o gecə onları Misirdən qurtarmaq üçün ayıq saxladı. İsrail xalqı bütün nəsillər boyu o gecə Misirlilərin əlindən qurtarmağın xatirəsi kimi Rəbb üçün ayıq qalmalı idilər. ");
INSERT INTO azb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Rəbb Musaya və Haruna dedi: «Pasxa bayramının qaydaları belədir: heç bir qərib ondan yeməsin; ");
INSERT INTO azb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ancaq hər kəsin pulla satın alınmış qulu sünnət olunduqdan sonra onu yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Qonaq və muzdlu işçi ondan yeməməlidir. ");
INSERT INTO azb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Qoy bu yemək bir evdə yeyilsin, əti evdən bayıra çıxarılmasın və onun bir sümüyü də qırılmasın. ");
INSERT INTO azb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Bütün İsrail icması bu yeməyi yesin. ");
INSERT INTO azb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Sənin yanında qonaq olan qərib Rəbbin Pasxa bayramını keçirmək istəsə, ailəsində olan bütün kişilərlə birgə sünnət olunsun. Yalnız bu zaman onu keçirə bilər və o da sizin həmtayfanız kimi sayılar. Sünnət olunmayan heç bir kişi ondan yeməsin. ");
INSERT INTO azb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Yerli üçün də, yanınızda yaşayan yadelli üçün də qanun eynidir». ");
INSERT INTO azb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","İsrail övladları Rəbbin Musaya və Haruna əmr etdiyi kimi də etdilər. ");
INSERT INTO azb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Rəbb o gün İsrail övladlarını Misir torpağından dəstələrlə çıxartdı. ");
INSERT INTO azb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«İsrail övladları arasında hər bətndən ilk doğulan bütün oğlanları və bütün heyvanların balalarını Mənim üçün təqdis et; onlar Mənimdir». ");
INSERT INTO azb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa xalqa dedi: «Misirdən, köləlik diyarından çıxdığınız bu günü xatırlayın. Çünki Rəbb sizi qüdrətli əli ilə oradan çıxartdı və buna görə də mayalı çörək yeməyin. ");
INSERT INTO azb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Çıxdığınız bu gün Aviv ayındadır. ");
INSERT INTO azb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Rəbb atalarınıza and etmişdi ki, Kənanlıların, Xetlilərin, Emorluların, Xivlilərin, Yevusluların ölkəsini sizə verəcək. Sizi süd və bal axan torpağa gətirəcəyi vaxt bu ibadəti həmin ayda icra edin. ");
INSERT INTO azb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yeddi gün mayasız çörək yeyin, yeddinci gün Rəbbə bayram olsun. ");
INSERT INTO azb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","O yeddi gün ərzində yalnız mayasız çörək yeyilməlidir. Aranızda bütün ölkədə nə mayalı çörək, nə də maya görünməsin. ");
INSERT INTO azb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","O günü övladlarınıza bildirib deyin: “Misirdən çıxdığım vaxt Rəbb mənim üçün nələr etdiyinə görə belə edirəm”. ");
INSERT INTO azb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Qoy bu əlinizdə nişanə və gözlərinizin önündə xatirə olsun ki, Rəbbin qanunu dilinizdən düşməsin. Çünki Rəbb sizi qüdrətli əli ilə Misirdən çıxartdı. ");
INSERT INTO azb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","İldən-ilə təyin olunan vaxt bu qanuna riayət edin. ");
INSERT INTO azb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Rəbb sizə və atalarınıza and içdiyi kimi Kənanlıların ölkəsinə gətirib, oranı sizə verən vaxtdan bəri ");
INSERT INTO azb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ana bətnindən hər ilk doğulan oğlanlarınızı Rəbbə təqdim etməlisiniz: ilk doğulan bütün heyvan balaları da Rəbbin olsun. ");
INSERT INTO azb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Hər ilk doğulan eşşək balası əvəzinə bir qoyun-keçi balası verin. Əgər əvəzini verməsəniz, boynunu sındırın. Övladlarınızın arasında hər ilk oğulun əvəzini ödəyin. ");
INSERT INTO azb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Gələcəkdə övladlarınız sizdən “Bu nədir?” soruşanda deyin: “Rəbb bizi Misirdən, köləlik diyarından qüdrətli əli ilə çıxartdı. ");
INSERT INTO azb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Firon bizi buraxmamağa inadkarlıq edəndə Rəbb Misir torpağında olan həm insanların bütün ilk oğlanlarını, həm də heyvanların bütün ilk balalarını öldürdü. Buna görə mən bütün ilk doğulan heyvan balalarını Rəbbə qurban verirəm, bütün ilk oğullarımın isə əvəzini ödəyirəm”. ");
INSERT INTO azb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Qoy bu əlinizdə nişanə və gözünüz önündə xatirə olsun, çünki Rəbb bizi qüdrətli əli ilə Misirdən çıxartdı». ");
INSERT INTO azb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Firon xalqı buraxdığı zaman Allah onları Filiştlilərin ölkəsindən yol qısa olduğuna baxmayaraq, o yolla gətirmədi. Çünki O dedi: «Yoxsa xalq müharibə görəndə bəlkə peşman olub Misirə qayıdar». ");
INSERT INTO azb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Allah xalqı Qırmızı dənizə tərəf səhra yolu ilə dolayı apardı. İsrail övladları Misir torpağından silahlanıb çıxdılar. ");
INSERT INTO azb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa Yusifin sümüklərini özü ilə apardı, çünki Yusif İsrail övladlarına «Allah mütləq sizə nəzər salacaq. Gedən zaman özünüzlə sümüklərimi də buradan çıxarın» deyərək and içdirmişdi. ");
INSERT INTO azb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","İsrail övladları Sukkotdan yola düşüb səhranın kənarında olan Etamda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Rəbb onların qabağı ilə gündüz onlara yol göstərmək üçün bulud dirəyində, gecə isə onlara işıq vermək üçün od dirəyində gedirdi ki, gündüz də, gecə də gedə bilsinlər. ");
INSERT INTO azb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gündüzlər bulud dirəyi, gecələr isə od dirəyi xalqın önündən ayrılmadı. ");
INSERT INTO azb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«İsrail övladlarına belə söylə: “Dönüb Pi-Haxirot qabağında düşərgə salın. Miqdol ilə dənizin arasında, Baal-Sefon qarşısında dənizin sahilində düşərgəniz olsun”. ");
INSERT INTO azb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firon düşünəcək ki, İsrail övladları torpaqda dolaşır, səhra onların yolunu kəsmişdir. ");
INSERT INTO azb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mən isə fironu inadkar edəcəyəm ki, o sizi təqib etsin. Sonra firon və onun ordusunu məğlub edib izzətimi göstərəcəyəm. Bütün Misirlilər biləcəklər ki, Rəbb Mənəm». İsraillilər belə də elədilər. ");
INSERT INTO azb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Misir padşahına İsrail xalqının qaçdığını xəbər verəndə firon və məmurlarının fikri dəyişdi. Onlar dedilər: «Biz nə üçün belə etdik? İsrail övladları bizim qullarımız idi. Axı niyə onları buraxdıq?» ");
INSERT INTO azb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Firon döyüş arabalarını hazırlayıb adamlarını özü ilə götürdü. ");
INSERT INTO azb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","O, altı yüz seçmə döyüş arabasını və Misirin bütün arabalarını götürdü. Hər arabanın öz zabiti var idi. ");
INSERT INTO azb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Rəbb Misir padşahı fironun ürəyini yenə də inadkar etdi və o, İsrail övladlarını təqib etdi. İsrail övladları isə cürətlə gedirdilər. ");
INSERT INTO azb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misirlilər, fironun bütün araba atları, süvariləri və ordusu onları təqib edib Pi-Haxirot yanında, Baal-Sefon qarşısında dənizin sahilində qurduqları düşərgəyə çatdılar. ");
INSERT INTO azb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firon yaxınlaşanda İsrail övladları baxıb gördülər ki, Misirlilər onlara doğru gəlirlər. Buna görə də İsrail övladları çox qorxdu və Rəbbə fəryad etdilər. ");
INSERT INTO azb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Onlar Musaya dedilər: «Məgər Misirdə qəbiristanlıq yoxdur ki, sən bizi səhrada ölməyə apardın? Bizi Misirdən çıxarıb başımıza nə gətirdin? ");
INSERT INTO azb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Misirdə sənə “Bizdən əl çək, Misirlilərə qulluq edək!” demirdikmi? Səhrada ölməkdən Misirlilərə qulluq etmək bizim üçün yaxşıdır». ");
INSERT INTO azb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa isə xalqa belə dedi: «Qorxmayın! Durun, Rəbbin bu gün sizi necə xilas edəcəyinə baxın. İndi gördüyünüz Misirliləri daha heç vaxt görməyəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Sakit olun, Rəbb sizin üçün döyüşəcək!» ");
INSERT INTO azb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Rəbb Musaya dedi: «Nə üçün Mənə fəryad edirsən? İsrail övladlarına de ki, yola düşsünlər. ");
INSERT INTO azb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Sən isə əsanı qaldırıb, əlini dənizin üzərinə uzat, sularını yar ki, İsrail övladları dənizin ortasında quru yerdən keçsinlər. ");
INSERT INTO azb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mən Misirlilərin ürəklərini inadkar edəcəyəm ki, sizi təqib etsinlər. Sonra fironu, onun bütün ordusunu, döyüş arabalarını və süvarilərini məğlub edib izzətimi göstərəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Fironu, döyüş arabalarını və süvarilərini məğlub edib izzətimi göstərdiyim zaman Misirlilər biləcəklər ki, Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","İsrail düşərgəsinin önündə gedən Allahın mələyi onların arxasına keçdi. Bulud dirəyi önlərindən arxalarına keçib, ");
INSERT INTO azb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Misir ordusunun və İsrail düşərgəsinin arasında durdu. Bulud bir tərəfə zülmət verdi, o birisinə isə gecə işığı verdi. Bütün gecə bu xalqlar bir-birinə yaxınlaşmadılar. ");
INSERT INTO azb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa əlini dəniz üzərinə uzatdı. Rəbb bütün gecə əsən qüvvətli şərq küləyi ilə dənizin suyunu qovub yerini quruya çevirdi. Sular yarıldı və ");
INSERT INTO azb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","İsrail övladları dənizin ortasında quru yerdən keçdilər. Sular onlar üçün sağ və sol tərəfdən divar oldu. ");
INSERT INTO azb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misirlilər onları təqib etdilər; fironun atları, döyüş arabaları və süvariləri İsrail övladlarının ardınca dənizin ortasına girdilər. ");
INSERT INTO azb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Dan yeri söküləndə Rəbb od və bulud dirəyindən Misir ordusuna baxıb onların arasına qarışıqlıq saldı. ");
INSERT INTO azb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","O, arabaların çarxlarını elə ləngitdi ki, arabalar güclə hərəkət etdi. Misirlilər dedilər: «Gəlin İsrail övladlarından qaçaq, çünki Rəbb onların tərəfində bizə qarşı döyüşür». ");
INSERT INTO azb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Rəbb Musaya belə dedi: «Əlini dənizin üzərinə uzat ki, sular Misirlilərin, döyüş arabalarının və süvarilərin üzərinə qayıtsın». ");
INSERT INTO azb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa əlini dənizin üzərinə uzatdı. Səhərə yaxın dəniz adi hala qayıtdı. Misirlilər sulardan qaçmaq istəyəndə Rəbb onları itələyib dənizin ortasına atdı. ");
INSERT INTO azb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Yerinə qayıdan sular döyüş arabalarını, süvariləri, İsrail övladlarının ardınca dənizə gedən fironun bütün ordusunu örtüb uddu. Onlardan bir nəfər də olsun sağ qalmadı. ");
INSERT INTO azb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","İsrail övladları isə dənizin ortasında quru yerdən keçib getmişdilər. Sular onlar üçün sağ və sol tərəfdə divar olmuşdu. ");
INSERT INTO azb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Məhz o gün Rəbb İsraili Misirlilərin əlindən xilas etdi. İsrail xalqı Misirliləri dənizin sahilində ölü gördü. ");
INSERT INTO azb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","İsrail xalqı Rəbbin Misirlilərə böyük qüvvətlə nə etdiyini görəndə Rəbdən qorxdu, Ona və qulu Musaya güvəndi. ");
INSERT INTO azb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","O vaxt Musa ilə İsrail övladları Rəbbə bu ilahini oxudular: «Rəbbə ilahi oxuyacağam, Çox böyük zəfər çaldı. Atı və süvarini dənizə tulladı. ");
INSERT INTO azb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Rəbb qüvvətim, məzmurumdur, O məni xilas etdi. Rəbb mənim Allahımdır, Ona həmd edəcəyəm. Atamın Allahıdır, Rəbbi yüksəldəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Rəbb döyüşçüdür, Rəbdir Onun adı. ");
INSERT INTO azb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Fironun döyüş arabalarını, Ordusunu da dənizə atdı. Döyüş arabalarının başçıları Qırmızı dənizdə boğuldu. ");
INSERT INTO azb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Əngin sulara bürünüb Daş tək dərinliklərə Necə də qərq oldular. ");
INSERT INTO azb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ya Rəbb! Sənin sağ əlin qüdrətdən izzətləndi. Ya Rəbb! Sənin sağ əlin düşməni əzəndir. ");
INSERT INTO azb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Sənə qarşı çıxanları möhtəşəm əzəmətin yıxar, Sənin göndərdiyin qəzəb onları saman çöpü tək yandırar. ");
INSERT INTO azb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Burnunun nəfəsi ilə sular toplanar, Yığılar bir yerə, axınlar dayanar, Dəniz qoynunda coşan sular qatılaşar. ");
INSERT INTO azb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Düşmən dedi: “İzləyim, çatıb qənimət paylayım: Bundan canım doyacaq, Qılıncımla onları məhv edəcəyəm”. ");
INSERT INTO azb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nəfəsinlə üfürdün, dənizlə onları bürüdün. Qurğuşun tək onlar nəhəng sularda batdılar. ");
INSERT INTO azb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ya Rəbb, allahlar arasında Sənin kimisi varmı? Müqəddəslikdə əzəmətli, zəhmli və alqışlara layiq, Möcüzələr yaradan Sənin kimisi varmı? ");
INSERT INTO azb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Sağ əlini uzadanda torpaq onları uddu. ");
INSERT INTO azb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Məhəbbətinlə qurtardığın xalqa Sən yol göstərdin. Müqəddəs məskəninə Öz gücünlə apardın. ");
INSERT INTO azb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Xalqlar eşidib əsdi, Filişt sakinlərini qorxu kəsdi. ");
INSERT INTO azb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom başçılarını o an dəhşət bürüdü. Moav igidlərini vahimələrə saldı. Kənan sakinləri isə üzülüb qaldı. ");
INSERT INTO azb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Onların üzərini qorxu, vəlvələ aldı. Güclü qoluna görə daş tək lal-kar oldular, O vaxtadək ki xalqın keçəcək, Ya Rəbb, qurtardığın xalq keçəcək! ");
INSERT INTO azb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ya Rəbb, xalqını gətirib salacaqsan mülkün olan dağına, Yaşamaq üçün Özünə yaratdığın yerə, Ey Xudavənd! Əlinlə qurduğun Müqəddəs məkanına. ");
INSERT INTO azb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Rəbb əbədi, daima padşahlıq edəcəkdir». ");
INSERT INTO azb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Fironun atları, döyüş arabaları və süvariləri ilə birgə dənizə girəndə Rəbb dənizin sularını onların üzərinə geri qaytarmışdı. İsrail övladları isə dənizin ortasında quru yerdən keçmişdilər. ");
INSERT INTO azb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Harunun bacısı peyğəmbər Məryəm əlinə dəf aldı; bütün qadınlar əllərinə dəf alıb oynayaraq onun ardınca çıxdılar. ");
INSERT INTO azb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Məryəm onların qarşısında bu ilahini oxudu: Rəbbə ilahi oxuyun, Çox böyük zəfər çaldı. Atı və süvariləri dənizə tulladı! ");
INSERT INTO azb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musa İsrail xalqını Qırmızı dənizin sahilindən gedən yola gətirdi. Onlar Şur səhrasına çıxıb orada üç gün yol getdilər, amma su tapmadılar. ");
INSERT INTO azb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Maraya çatdılar, lakin oranın suyunu içə bilmədilər, çünki çox acı idi. Buna görə də o yer Mara adlanır. ");
INSERT INTO azb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Xalq «Nə içək?» deyə Musadan giley-güzar etdi. ");
INSERT INTO azb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa Rəbbə fəryad etdi və Rəbb ona bir ağac göstərdi. Musa onu suya atdı və su şirin oldu. Orada İsrail övladlarını sınağa çəkdiyi yerdə Rəbb onlar üçün qayda-qanun qoyaraq dedi: ");
INSERT INTO azb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«Əgər siz Allahınız Rəbbin səsinə qulaq asıb Onun gözündə doğru olsanız, Onun əmrlərini dinləyib bütün qanunlarına riayət etsəniz, Misirlilərə verdiyim xəstəliklərin heç birini sizə verməyəcəyəm. Çünki sizə şəfa verən Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Sonra İsrail övladları Elimə gəldilər. Orada on iki su qaynağı və yetmiş xurma ağacı var idi. İsrail xalqı orada sular ətrafında düşərgə qurdu. ");
INSERT INTO azb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Bütün İsrail övladlarının icması Elimdən yola düşdü. Onlar Misir ölkəsindən çıxdıqdan sonra ikinci ayın on beşinci günü Elim və Sina dağı arasındakı Sin səhrasına çatdılar. ");
INSERT INTO azb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Səhrada bütün İsrail övladlarının icması Musa ilə Harunun əlindən giley-güzar etdi. ");
INSERT INTO azb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","İsraillilər onlara dedilər: «Kaş ki Misir ölkəsində ət qazanlarının yanında oturanda doyunca çörək yediyimiz vaxt Rəbbin əlində öləydik! Siz bizi bu səhraya ona görə gətirdiniz ki, bütün bu camaatı aclıqdan öldürəsiniz». ");
INSERT INTO azb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Rəbb Musaya dedi: «Budur, Mən sizin üçün göydən çörək yağdıracağam. Qoy xalq hər gün çıxıb lazımi miqdarda o çörəyi yığsın. Mənsə onları sınayacağam ki, qanunuma görə yaşayırlar ya yox. ");
INSERT INTO azb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Altıncı gün yığdıqları digər günlər yığdıqlarından ikiqat artıq olsun, o gün də onu hazırlasınlar». ");
INSERT INTO azb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa və Harun bütün İsrail övladlarına dedilər: «Axşam biləcəksiniz ki, sizi Misir ölkəsindən çıxaran Rəbdir. ");
INSERT INTO azb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Səhər isə Rəbbin izzətini görəcəksiniz. Çünki Rəbb Onun əlindən giley-güzarınızı eşitdi. Axı biz kimik ki, siz əlimizdən giley-güzar edirsiniz?» ");
INSERT INTO azb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa dedi: «Sizə axşam yeməyə ət, səhər isə doyunca çörək verən Rəbdir; çünki sizin Ona qarşı olan deyinməyinizi eşidən Odur. Axı biz kimik ki? Deyinməyiniz bizə qarşı deyil, Rəbbə qarşıdır». ");
INSERT INTO azb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa Haruna dedi: «Bütün İsrail icmasına belə söylə: “Rəbbin hüzuruna yaxınlaşın, çünki O sizin deyinməyinizi eşitmişdir”». ");
INSERT INTO azb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Harun bütün İsrail övladlarının icması ilə danışdığı vaxt onlar səhraya baxıb Rəbbin əzəmətinin buludda göründüyünü gördülər. ");
INSERT INTO azb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Mən İsrail övladlarının deyinməklərini eşitdim. Onlara de: axşamçağı ət yeyəcək, səhər isə çörəklə doyacaqsınız. Onda biləcəksiniz ki, Allahınız Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Axşam bildirçinlər uçub bütün düşərgəni bürüdülər. Səhər düşərgənin ətrafına şeh düşdü. ");
INSERT INTO azb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Şeh buxarlananda səhrada, torpaq üzərində qırova bənzər nazik lopalar göründü. ");
INSERT INTO azb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","İsraillilər bunu gördükdə bir-birinə «Bu nədir?» dedilər, çünki onun nə olduğunu bilmirdilər. Musa onlara dedi: «Bu Rəbbin sizə yeməyə verdiyi çörəkdir. ");
INSERT INTO azb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Rəbbin əmri budur: hər adam yemək üçün özünə lazımi miqdarda ondan yığsın. Öz çadırında olan adamların sayına görə adambaşı bir omer götürsün». ");
INSERT INTO azb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","İsrail övladları belə də etdilər. Kimi çox, kimi də az yığdı. ");
INSERT INTO azb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Onlar omer ilə ölçdükləri zaman çox yığanın artığı, az yığanın əskiyi olmadı. Hər kəs özünə lazımi miqdarda yemək yığdı. ");
INSERT INTO azb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa İsrail övladlarına dedi: «Qoy səhərə qədər heç kimdə bu yeməkdən qalmasın». ");
INSERT INTO azb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Lakin bəziləri Musanın sözünə baxmayıb bundan səhərə qədər saxladılar. Saxladıqları yemək qurdlanıb iyləndi. Musa onlara qəzəbləndi. ");
INSERT INTO azb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","İsrail övladlarından hər kəs özünə lazımi miqdarda hər səhər ondan yığırdı. Günəş qızanda isə o əriyirdi. ");
INSERT INTO azb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","İsrail övladları altıncı gün bu yeməkdən ikiqat artıq, adambaşı iki omer yığdılar. İcma başçıları gəlib bunu Musaya bildirdilər. ");
INSERT INTO azb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa onlara dedi: «Rəbb belə deyir: “Sabah istirahət günü – Rəbb üçün təqdis olunan Şənbə günüdür. Bu gün bişirdiyiniz hər şeyi bişirin, qaynatdığınız hər şeyi qaynadın, artığı da özünüz üçün səhərə qoyub saxlayın”». ");
INSERT INTO azb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","İsrail övladları Musa onlara əmr etdiyi kimi yeməyi səhərə saxladılar. Onun içində nə qurd oldu, nə də iyləndi. ");
INSERT INTO azb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa dedi: «Bu gün o yeməyi yeyin, çünki Rəbb üçün Şənbə günüdür. Bu gün çöldə yemək tapmayacaqsınız. ");
INSERT INTO azb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Siz onu altı gün ərzində yığın; yeddinci gün – Şənbə günü o yemək yox olacaq». ");
INSERT INTO azb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Xalqın bəziləri yeddinci gün yemək yığmağa çıxdılar, amma tapmadılar. ");
INSERT INTO azb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Rəbb Musaya dedi: «Nə vaxta qədər əmrlərimə və qanunlarıma itaət etməkdən boyun qaçıracaqsınız? ");
INSERT INTO azb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Baxın Rəbb sizə Şənbə günü verdi. Buna görə də O sizə hər altıncı gün iki günlük yemək verir. Qoy hər kəs öz evində qalsın və yeddinci gün heç yerə çıxmasın». ");
INSERT INTO azb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Beləcə xalq yeddinci gün istirahət etdi. ");
INSERT INTO azb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","İsrail xalqı bu yeməyin adını «manna» qoydu. O, görünüşcə keşniş toxumu kimi idi, rəngi ağ, dadı isə ballı yuxaya bənzəyirdi. ");
INSERT INTO azb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa dedi: «Rəbbin əmri budur: “Mannadan bir omer doldurun; Misir ölkəsindən sizi çıxardığım zaman səhrada sizə yedirtdiyim yeməyi görmək üçün qoy bu nəsildən-nəslə qorunsun”». ");
INSERT INTO azb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa Haruna dedi: «Bir qab götür, ona omer dolu manna qoy. Bu Rəbbin hüzurunda nəsildən-nəslə qorunub saxlanmalıdır». ");
INSERT INTO azb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Rəbbin Musaya əmr etdiyi kimi Harun onu şəhadət lövhələrinin önündə qoruyub saxladı. ");
INSERT INTO azb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","İsrail övladları qırx il ərzində əhalisi olduqları Kənan ölkəsinin sərhədinə gələnə qədər manna yedilər. ");
INSERT INTO azb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Bir omer efanın onda bir hissəsidir. ");
INSERT INTO azb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Bütün İsrail övladlarının icması Sin səhrasından yola düşüb Rəbbin buyurduğuna görə dayana-dayana köç edirdilər. Onlar Refidimdə düşərgə saldılar. Orada xalqın içməyə suyu yox idi. ");
INSERT INTO azb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ona görə də xalq Musa ilə münaqişə edib belə dedi: «Bizə içməyə su verin». Musa onlara dedi: «Niyə mənimlə münaqişə edirsiniz? Nə üçün Rəbbi sınayırsınız?» ");
INSERT INTO azb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Xalq orada olanda susamışdı. Ona görə də Musanın əlindən deyinib dedi: «Axı niyə bizi Misirdən çıxartdın? Bu bizi, oğullarımızı və heyvanlarımızı susuzluqdan öldürmək üçündürmü?» ");
INSERT INTO azb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa Rəbbə fəryad edib dedi: «Axı mən bu xalq ilə nə edim? Bir az da keçsə, məni daşqalaq edəcəklər». ");
INSERT INTO azb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Rəbb Musaya dedi: «Xalqın qarşısına çıx. Özünlə bərabər bir neçə İsrail ağsaqqalı götür. Nil çayına vurduğun əsanı əlinə alıb irəli get. ");
INSERT INTO azb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Orada – Xorevdəki qayanın üstündə Mən sənin önündə dayanacağam. Zərbə ilə qayaya vur və oradan xalq üçün içməli su çıxacaq». Musa da İsrail ağsaqqallarının gözü qarşısında bunu etdi. ");
INSERT INTO azb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa o yeri Massa və Meriva adlandırdı, çünki orada İsrail övladları münaqişə etmişdilər və «görəsən Rəbb aramızdadır ya yox» deyə Rəbbi sınamışdılar. ");
INSERT INTO azb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Bundan sonra Amaleqlilər gəlib Refidimdə İsrail övladları ilə döyüşdülər. ");
INSERT INTO azb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa Yeşuaya dedi: «Bizim üçün bir neçə adam seç, get Amaleqlilərlə döyüş. Sabah mən əlimdə Allahın əsası ilə təpənin başında dayanacağam». ");
INSERT INTO azb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yeşua da Musa deyən kimi etdi və gedib Amaleqlilərlə döyüşdü. Musa, Harun və Xur isə təpənin başına çıxdılar. ");
INSERT INTO azb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musa əlini qaldıranda İsrail övladları üstün gəlirdi, əlini endirəndə isə Amaleqlilər üstün gəlirdi. ");
INSERT INTO azb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Lakin Musanın əlləri yorulurdu. Ona görə də bir daş götürüb onun altına qoydular. Musa daşın üstündə oturdu. Əlinin birindən Harun, o birisindən isə Xur yapışdı. Beləcə Musanın gün batanacan əlləri möhkəm qaldı. ");
INSERT INTO azb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yeşua Amaleq padşahını və xalqını qılıncdan keçirib qırdı. ");
INSERT INTO azb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Rəbb Musaya dedi: «Bunu xatirə olaraq kitaba yaz, Yeşuanın qulağına çatdır ki, Mən Amaleqin adını büsbütün yer üzərindən siləcəyəm». ");
INSERT INTO azb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa bir qurbangah düzəldərək adını Yahve-Nissi qoyub ");
INSERT INTO azb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","dedi: «Rəbbin taxtına doğru əl uzadılırdı. O, nəsildən-nəslə Amaleqlilərə qarşı döyüşəcək». ");
INSERT INTO azb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Midyanlıların kahini olan Musanın qayınatası Yetro Allahın Musa və xalqı İsrail üçün gördüyü bütün işləri, Rəbbin İsraili Misirdən çıxartdığını eşitdi. ");
INSERT INTO azb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Musanın qayınatası Yetro Musanın arvadı Sipporanı iki oğlu ilə birgə geri gətirdi. Musa əvvəlcədən arvadını onun yanına göndərmişdi. ");
INSERT INTO azb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Musa «mən yad bir ölkədə qərib oldum» deyib oğlanlarının birinin adı Gerşom qoymuşdu. ");
INSERT INTO azb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","«Atamın Allahı köməyim oldu və məni fironun qılıncından qurtardı» deyib o birisinin adını Eliezer qoymuşdu. ");
INSERT INTO azb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Musanın qayınatası Yetro, oğulları və arvadı Musanın düşərgə saldığı Allahın dağı yerləşən səhraya gəlib, ");
INSERT INTO azb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","bu xəbəri Musaya göndərdi: «Mən – sənin qayınatan Yetro, arvadın və iki oğlunla yanına gəlirəm». ");
INSERT INTO azb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa qayınatasının qarşısına çıxdı, təzim edib onunla öpüşdü; onlar bir-birlərindən hal-əhval tutub çadıra girdilər. ");
INSERT INTO azb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa qayınatasına Rəbbin İsrail övladlarının xatirinə firona və Misirlilərə etdiyi bütün şeylər, yolda çəkdikləri bütün əziyyəti və Rəbbin onları necə qurtardığını nəql etdi. ");
INSERT INTO azb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro Rəbbin İsrail övladlarına etdiyi bütün yaxşılıqlara və Misirlilərin əlindən onları qurtardığına görə sevindi. ");
INSERT INTO azb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetro dedi: «Sizi Misirlilərin və fironun əlindən qurtaran Rəbbə alqış olsun! Xalqı Misirlilərin əlinin altından qurtaran Odur. ");
INSERT INTO azb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","İndi bildim ki, Rəbb bütün allahlardan böyükdür, çünki onların öyündüklərindən də üstün oldu». ");
INSERT INTO azb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Sonra Musanın qayınatası Yetro Allaha yandırma və ünsiyyət qurbanları gətirdi. Harun ilə İsrail övladlarının bütün ağsaqqalları Musanın qayınatası ilə Allahın hüzurunda yemək yeməyə gəldilər. ");
INSERT INTO azb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ertəsi gün Musa oturub xalqa hakimlik edirdi. Xalq da səhərdən axşamadək Musanın ətrafında dayanmışdı. ");
INSERT INTO azb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Qayınatası Musanın xalq üçün nə etdiyinə baxıb dedi: «Nə üçün bu xalqa belə edirsən? Niyə sən tək oturursan və bütün xalq səhərdən axşamadək ətrafında dayanıb gözləyir?» ");
INSERT INTO azb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa qayınatasına dedi: «Ona görə ki xalq Allahdan soruşmaq üçün mənim yanıma gəlir. ");
INSERT INTO azb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Həll olunmalı məsələləri olan adamlar yanıma gələndə aralarında qərar çıxarıram. Allahın qayda-qanunlarını da onlara bildirirəm». ");
INSERT INTO azb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musanın qayınatası ona dedi: «Gördüyün iş yaxşı deyil. ");
INSERT INTO azb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Əlbəttə, həm sən, həm də səninlə olan xalq üzülərsiniz. Axı bu iş sənin üçün ağırdır, onu təkbaşına edə bilməzsən. ");
INSERT INTO azb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","İndi sözümə qulaq as, sənə bir məsləhət verim. Qoy Allah sənə yar olsun! Sən bu xalqa görə Allahın hüzurunda dayan və işlərini də Ona çatdır. ");
INSERT INTO azb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Onları qayda-qanunlar barəsində xəbərdar et, gedəcəkləri yolu və görəcəkləri işi göstər. ");
INSERT INTO azb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Bütün xalq arasından bacarıqlı, Allahdan qorxan, etibarlı, haram qazanca nifrət edən adamları seç. Onları minbaşı, yüzbaşı, əllibaşı, onbaşı təyin et ki, ");
INSERT INTO azb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","xalqı hər zaman mühakimə etsinlər. Qoy hər böyük işi sənin yanına gətirsinlər, hər kiçik işə isə özləri hakimlik etsinlər. Beləcə öz yükünü yüngülləşdir. Qoy o adamlar bu yükü səninlə daşısınlar. ");
INSERT INTO azb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Əgər belə etsən, Allah da sənə belə əmr etsə, dözə bilərsən. Bütün xalq da razı olub öz yerinə gedər». ");
INSERT INTO azb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa qayınatası deyən sözlərə qulaq asıb əməl etdi. ");
INSERT INTO azb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Bundan sonra Musa İsrail övladları arasından bacarıqlı adamlar seçdi və onlardan xalqa başçı – minbaşılar, yüzbaşılar, əllibaşılar, onbaşılar təyin etdi. ");
INSERT INTO azb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Onlar hər vaxt xalqı mühakimə edirdilər. Çətin işləri isə Musanın yanına gətirir, hər kiçik işi isə özləri mühakimə edirdilər. ");
INSERT INTO azb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Sonra Musa qayınatasını yola saldı, o da öz ölkəsinə getdi. ");
INSERT INTO azb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","İsrail övladları Misir torpağından çıxdıqdan sonra üçüncü ayda – yeni ay günü Sina səhrasına gəldilər. ");
INSERT INTO azb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Onlar Refidimdən köçüb Sina səhrasına gəldilər. O səhrada İsrail övladları dağın qarşısında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa isə dağa – Allahın hüzuruna çıxdı. Rəbb onu dağdan çağırıb dedi: «Yaqub nəslinə, İsrail övladlarına belə söylə: ");
INSERT INTO azb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Misirlilərə nələr etdiyimi, sizi qartal qanadlarında daşıdığım kimi yanıma gətirdiyimi siz özünüz gördünüz. ");
INSERT INTO azb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","İndi isə əgər sözümə diqqətlə qulaq asıb əhdimə riayət etsəniz, siz bütün xalqlar arasından Mənə məxsus xalq olacaqsınız. Bütün yer üzü Mənimdir; ");
INSERT INTO azb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","siz isə Mənə xidmət edən kahinlər padşahlığı, müqəddəs millət olacaqsınız”. Bu sözləri İsrail övladlarına söylə». ");
INSERT INTO azb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musa gəlib xalqın ağsaqqallarını çağırdı və Rəbbin ona əmr etdiyi hər kəlməni onların qarşısına qoydu. ");
INSERT INTO azb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bütün xalq bir nəfər kimi belə cavab verdi: «Rəbbin bütün söylədiklərinə əməl edəcəyik». Musa xalqın cavabını Rəbbə çatdırdı. ");
INSERT INTO azb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Rəbb Musaya dedi: «Budur, Mən sənin yanına qatı buludda gəlirəm, qoy xalq səninlə danışdığımı eşidib sənə daim inansın». Musa xalqın sözlərini Rəbbə çatdırdı. ");
INSERT INTO azb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Rəbb Musaya dedi: «Xalqın yanına get. Bu gün və sabah onları təqdis et. Qoy paltarlarını da yusunlar. ");
INSERT INTO azb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Üçüncü günə hazır olsunlar, çünki üçüncü gün bütün xalqın gözü qarşısında Rəbb Sina dağı üzərinə enəcək. ");
INSERT INTO azb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Xalqın ətrafına sərhəd çəkib de: “Özünüzü dağa çıxmaqdan, onun ətəyinə toxunmaqdan gözləyin. Dağa toxunan hər kəs öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Eləsinə əl vurulmasın, ancaq daşqalaq edilsin ya da oxla vurulsun. İstər heyvan, istərsə də insan, bunların yaşamaq üçün izni yoxdur. Qoç buynuzundan olan şeypur uzun-uzadı çalınanda onlar dağa çıxa bilərlər”». ");
INSERT INTO azb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa dağdan xalqın yanına endi. O, xalqı təqdis etdi. Onlar paltarlarını yudular. ");
INSERT INTO azb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Sonra Musa xalqa dedi: «Üçüncü günə hazır olun, qadınlarla yaxınlıq etməyin». ");
INSERT INTO azb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Üçüncü günün səhəri açılanda göy gurultusu, şimşəklər, dağ üzərində qatı bir bulud və çox uca şeypur səsi oldu. Düşərgədə olan bütün xalq titrədi. ");
INSERT INTO azb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Allahı qarşılamaq üçün Musa xalqı ordugahdan apardı və onlar dağın ətəyində durdular. ");
INSERT INTO azb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Bütün Sina dağı tüstü içində idi, çünki Rəbb onun üzərinə alov içərisində enmişdi. Bütün dağ kürənin verdiyi tüstü kimi tüstülənirdi, bərk titrəyirdi. ");
INSERT INTO azb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Şeypur səsi get-gedə ucalırdı. Musa danışırdı və Allah ona səslə cavab verirdi. ");
INSERT INTO azb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Rəbb Sina dağı üzərinə, dağın başına endi və Musanı dağın başına çağırdı. Musa oraya qalxdı. ");
INSERT INTO azb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Rəbb Musaya dedi: «Düş, xalqa tapşır ki, məbada Rəbbi görmək üçün Onun tərəfində olan sərhədi keçsin, yoxsa çoxları məhv olar. ");
INSERT INTO azb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Rəbbə yaxınlaşan kahinlər də özlərini təqdis etsin ki, Rəbb onlara qarşı çıxmasın». ");
INSERT INTO azb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa Rəbbə dedi: «Xalq Sina dağına çıxmaz, çünki Sən “dağa sərhəd çək və oranı təqdis et” deyə bizə tapşırıq verdin». ");
INSERT INTO azb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Rəbb ona dedi: «Düş get. Sən və səninlə bərabər Harun bura çıxın. Qoy kahinlərlə xalq Rəbbin yanına çıxmaq üçün sərhədi keçməsinlər, yoxsa Rəbb xalqa qarşı çıxar». ");
INSERT INTO azb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musa xalqın yanına enib bunu onlara söylədi. ");
INSERT INTO azb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Allah bütün bu sözləri belə söylədi: ");
INSERT INTO azb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Səni Misir torpağından, köləlik diyarından çıxaran Allahın Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Məndən başqa allahların olmasın. ");
INSERT INTO azb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Özün üçün heç bir oyma büt, nə yuxarıda – səmada və ya aşağıda – yerdə, nə də yerdən aşağıya yığılan sulardakı şeylərin heç birinin surətini düzəltmə. ");
INSERT INTO azb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Belə şeylərə səcdə qılaraq ibadət etmə. Çünki Mən, sənin Allahın Rəbb, qısqanc Allaham. Mənə nifrət edən ataların cəzasını üç-dörd nəslə qədər övladlarına çəkdirərəm. ");
INSERT INTO azb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Məni sevib əmrlərimə əməl edənlərin isə minlərlə nəslinə məhəbbət göstərərəm. ");
INSERT INTO azb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Allahın Rəbbin adını boş yerə dilinə gətirmə, çünki Rəbb Öz adını boş yerə dilinə gətirəni cəzasız qoymaz. ");
INSERT INTO azb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Şənbə gününü yadda saxlayıb təqdis et. ");
INSERT INTO azb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Altı gün çalışıb bütün işlərini gör. ");
INSERT INTO azb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Lakin yeddinci gün Allahın Rəbbin Şənbə günüdür. Bu gün sən, oğlun, qızın, qulun, qarabaşın, heyvanların, yanında qalan yadelli də heç bir iş görməsin. ");
INSERT INTO azb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Çünki altı gün ərzində Rəbb göyləri və yeri, dənizi və kainatdakı hər şeyi yaratdı, yeddinci gün isə istirahət etdi. Bunun üçün Rəbb Şənbə gününə bərəkət verib onu müqəddəs saydı. ");
INSERT INTO azb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ata-anana hörmət et ki, Allahın Rəbbin sənə verdiyi torpaqda ömrün uzun olsun. ");
INSERT INTO azb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Qətl etmə. ");
INSERT INTO azb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Zina etmə. ");
INSERT INTO azb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Oğurluq etmə. ");
INSERT INTO azb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Heç kimə qarşı yalandan şahidlik etmə. ");
INSERT INTO azb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Heç kimin evinə tamah salma. Heç kimin arvadına, quluna, qarabaşına, öküzünə, eşşəyinə – heç bir şeyinə tamah salma». ");
INSERT INTO azb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Bütün xalq göy gurultusunu, şimşəkləri, şeypur səsini, dağın tüstülənməsini eşidib görəndə qorxub sarsıldı və uzaqda durdu. ");
INSERT INTO azb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Musaya dedilər: «Sən bizimlə danış, biz də eşidək. Qoy Allah bizimlə danışmasın, yoxsa ölərik». ");
INSERT INTO azb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa xalqa dedi: «Qorxmayın, Allah ona görə gəlib ki, sizi sınağa çəksin və siz günah etməmək üçün Onun qorxusu qarşınızda olsun». ");
INSERT INTO azb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Xalq uzaqda duranda Musa orada Allahın olduğu qatı qaranlığa yaxınlaşdı. ");
INSERT INTO azb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Rəbb Musaya dedi: «İsrail övladlarına belə de: “Siz gördünüz ki, Mən sizinlə göylərdən danışdım. ");
INSERT INTO azb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Mənimlə yanaşı olan başqa allahlar düzəltməyin, özünüz üçün qızıldan və gümüşdən allahlar düzəltməyin. ");
INSERT INTO azb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mənim üçün torpaqdan qurbangah düzəldib yandırma və ünsiyyət qurbanları olaraq öz qoyun-keçi və mal-qaranı onun üstündə qurban gətir. Adım çəkilən hər yerdə yanına gəlib sənə bərəkət verəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Əgər Mənim üçün daşdan qurbangah düzəltsən, yonma daşdan tikmə, çünki onun üzərində alətlə işləsən, onu murdar edərsən. ");
INSERT INTO azb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ayıbın açılmamaq üçün Mənim qurbangahıma pilləkənlə çıxma”. ");
INSERT INTO azb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Sən onların qarşısına bu hökmləri qoymalısan: ");
INSERT INTO azb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Sizdən biri İbrani qul alarsa, o qul altı il qulluq edib yeddinci il pulu ödəmədən azad olunsun. ");
INSERT INTO azb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Əgər qulun tək gəlib, qoy tək də getsin; yox, əgər arvadı vardısa, qoy arvadı ilə getsin. ");
INSERT INTO azb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Əgər qul sahibi quluna arvad veribsə və qulun arvadı oğlan yaxud qız doğubsa, arvadla uşaqları ağası üçün qalsın. Qul isə tək getsin. ");
INSERT INTO azb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Lakin qul təkidlə: “Ağamı, arvadımla uşaqlarımı sevirəm və azad olmaq istəmirəm” desə, ");
INSERT INTO azb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","onda qoy qulun ağası onu məbədə – Allahın hüzuruna gətirsin. Qulunu qapıya yaxud qapının yan taxtasına söykəyib qulağını bizlə deşsin. Bu qul ağasına ömürlük qulluq etsin. ");
INSERT INTO azb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Bir adam qızını qarabaş olaraq satarsa, qız kişi qullar kimi azad olmasın. ");
INSERT INTO azb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Əgər o qız onu özü üçün təyin edən ağasının gözündə pis görünərsə, ağası qızın ödənmə pulunu qəbul edib onu azad etsin; o ağanın qızı yadellilərə satmağa ixtiyarı yoxdur, çünki o qızla xaincəsinə rəftar etdi. ");
INSERT INTO azb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Əgər ağa onu oğlu üçün təyin edibsə, onunla adətə görə öz qızı kimi rəftar etməlidir. ");
INSERT INTO azb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Əgər o adam ikinci arvad alırsa, birinci arvadını yemək və paltar təminatından və arvadlıq hüququndan məhrum etməsin. ");
INSERT INTO azb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Əgər əri bu üç haqqı qadına vermirsə, qoy bu qadın heç nə ödəmədən azad edilsin. ");
INSERT INTO azb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Adam vurub öldürən şəxs öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Lakin o şəxs öldürmək qəsdində olmasa və ölüm Mənim iznimlə olsa, o zaman onun üçün bir yer təyin edərəm ki, oraya pənah gətirsin. ");
INSERT INTO azb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Bir adam başqa adamı qəsdən hiylə ilə öldürsə, o adamı hətta Mənim qurbangahımdan götür ki, öldürülsün. ");
INSERT INTO azb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Atasını yaxud anasını döyən adam öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","İnsan oğurlayıb satan yaxud saxlayan adam öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Atasını yaxud anasını söyən adam öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Adamlar münaqişə edəndə başqa adamın daşla yaxud yumruqla vurduğu bir adam ölməyib yatağa düşərsə və ");
INSERT INTO azb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","sonra yataqdan qalxıb əl ağacı ilə bayırda gəzərsə, onu vuran adam cəzasız qalsın və yatdığı müddətin əvəzini ödəsin, sağalana qədər ona qayğı göstərsin. ");
INSERT INTO azb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Bir adamın dəyənəklə vurduğu qulu yaxud qarabaşı zərbədən ölərsə, o adam cəzalandırılmalıdır. ");
INSERT INTO azb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Əgər qul yaxud qarabaş bir-iki gün ərzində ölməsə, ağa cəzalandırılmasın; çünki qul yaxud qarabaş ağanın əmlakıdır. ");
INSERT INTO azb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Adamlar dalaşanda bir hamilə qadın ona dəyən zərbədən uşaq salarsa və başqa ziyan ona dəyməsə, o qadının ərinin tələbi ilə təqsirkar adam hakimlərin təyin etdiyi məbləğdə cərimə ödəməlidir. ");
INSERT INTO azb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Əgər qadına ziyan dəyibsə, təqsirkar adam can əvəzinə can, ");
INSERT INTO azb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","göz əvəzinə göz, diş əvəzinə diş, əl əvəzinə əl, ayaq əvəzinə ayaq, ");
INSERT INTO azb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","yanıq əvəzinə yanıq, yara əvəzinə yara, zədə əvəzinə zədə ödəsin. ");
INSERT INTO azb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ağa qulunun yaxud kənizinin gözünə vurub onu kor edərsə, gözün əvəzinə onu azad etsin. ");
INSERT INTO azb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Əgər ağa qulunun yaxud kənizinin dişini sındırsa, dişin əvəzinə qulunu azad etsin. ");
INSERT INTO azb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Mal-qaradan olan heyvan kişini yaxud qadını buynuzla vurub öldürərsə, heyvan daşqalaq edilsin; onun əti yeyilməsin, heyvan sahibi isə günahsız sayılsın. ");
INSERT INTO azb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Lakin əgər heyvan o vaxta qədər vurağan olub, sahibi isə bundan xəbərdar edilsə də, onun qarşısını almasa və nəticədə heyvan kişini yaxud qadını öldürərsə, heyvan daşqalaq edilsin, sahibi isə öldürülsün. ");
INSERT INTO azb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Əgər heyvanın sahibindən ödənmə pulu istənilirsə, o istənilən pulun məbləğini ödəyib canının əvəzini ödəyə bilər. ");
INSERT INTO azb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Oğlanı ya qızı buynuzlayan heyvana qarşı eyni hökm işlənsin. ");
INSERT INTO azb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Əgər heyvan qulu ya kənizi buynuzu ilə vursa, ağasına otuz şekel gümüş verilsin, heyvan isə daşqalaq olsun. ");
INSERT INTO azb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Bir adam quyunu açıb ya da qazdığı quyunun üstünü örtməsə və ora mal-qara yaxud eşşək düşsə, ");
INSERT INTO azb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","quyunun sahibi zərəri ödəsin; heyvanın dəyərini sahibinə versin, ölən heyvan isə o adama qalsın. ");
INSERT INTO azb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Bir adamın mal-qarası başqasının mal-qarasını vurub öldürsə, sahiblər həm sağ qalan heyvanı satıb dəyərini yarı bölməli, həm də ölü heyvanı yarı bölməlidirlər. ");
INSERT INTO azb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Amma heyvanın o vaxta qədər vurağan olduğu məlum olanda onun qarşısını almayan sahibi heyvanın əvəzinə heyvan verib zərəri ödəsin; ölən heyvan isə ona qalmalıdır. ");
INSERT INTO azb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Bir adam mal-qara yaxud qoyun-keçidən oğurlayıb kəsər yaxud satarsa, qoy o adam mal-qara əvəzinə beş heyvan, qoyun-keçi əvəzinə dörd heyvan verib zərəri ödəsin. ");
INSERT INTO azb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Əgər gecə oğru birinin evinə girərkən yaxalanıb öldürülsə, qoy qanı batsın. ");
INSERT INTO azb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Əgər hadisə gün doğandan sonra baş versə, qan tökən müqəssir sayılsın. Oğru zərəri ev yiyəsinə ödəməlidir. Əgər oğrunun zərəri ödəməyə gücü çatmırsa, qoy oğurluğuna görə özü satılsın. ");
INSERT INTO azb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Əgər oğurlanan mal-qara, eşşəklər ya qoyun-keçi oğrunun əlində diri tapılsa, qoy oğru zərəri ikiqat ödəsin. ");
INSERT INTO azb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Bir adam öz tarlasında yaxud üzüm bağında otardığı heyvanları başqa adamın tarlasına otlamağa buraxarsa, o adam öz tarlasının yaxud üzüm bağının ən yaxşı barından zərəri ödəsin. ");
INSERT INTO azb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Alışan od kollara düşüb dərz, əkin yaxud tarlanı məhv edərsə, yanğını yandıran adam zərəri ödəməlidir. ");
INSERT INTO azb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Bir adama saxlamağa verilən gümüş yaxud əşya onun evindən oğurlanarsa və oğru tapılarsa, zərəri ikiqat ödəsin. ");
INSERT INTO azb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Əgər oğru tapılmasa, evin sahibi Allahın hüzuruna yaxınlaşıb and içsin ki, başqa adamın əmanətinə xəyanət etməyib. ");
INSERT INTO azb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Hər hansı itmiş bir əşya – mal-qara, eşşək, qoyun-keçi, paltar barədə “bu mənimdir” deyən iki tərəfin mübahisəli işi Allahın hüzuruna gətirilməlidir; Allahın haqsız çıxardığı adam o birisinə zərəri ikiqat ödəməlidir. ");
INSERT INTO azb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Bir adama saxlamağa verilən başqa adamın eşşəyi, mal-qarası, qoyun-keçisi yaxud başqa bir heyvanı heç kəs görmədən ölər, yaralanar yaxud aparılarsa ");
INSERT INTO azb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","bu adamlar arasında Rəbbin adına içilən and olsun ki, biri o birisinin əmanətinə xəyanət etməyib. Qoy heyvanın sahibi bunu qəbul etsin, ona zərəri ödəməsin. ");
INSERT INTO azb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Əgər heyvan həmin adamdan oğurlanıbsa, onu saxlayan adam zərəri sahibinə ödəsin. ");
INSERT INTO azb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Əgər heyvanı vəhşi heyvan parçalayıbsa, onu saxlayan adam parçalanan heyvanı sübut kimi sahibinə gətirsin, zərərini isə ödəməsin. ");
INSERT INTO azb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Bir adamın borc aldığı heyvan sahibinin yanında olmayanda yaralanar yaxud ölərsə, o adam zərəri ödəməlidir. ");
INSERT INTO azb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Əgər heyvanın sahibi yanındadırsa, zərər ödənməməlidir. Əgər heyvan muzdla tutulubsa, zərər muzd haqqına daxil edilir. ");
INSERT INTO azb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Bir adam nişanlı olmayan bakirə qızı tovlayıb onunla yaxınlıq edərsə, qıza görə başlıq verib onu özünə arvad etməlidir. ");
INSERT INTO azb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Əgər qızın atası onu o adama ərə verməyə qəti razı deyilsə, o adam bakirə qızların başlığına müvafiq məbləğdə pul ödəsin. ");
INSERT INTO azb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Cadugər qadın sağ qalmasın. ");
INSERT INTO azb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Heyvanlarla cinsi əlaqəyə girən hər kəs öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Rəbdən başqa digər allahlara qurban gətirən adam tamamilə məhv olunsun. ");
INSERT INTO azb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Qərib adama nə haqsızlıq, nə də zülm edin, çünki siz özünüz də Misir ölkəsində qərib idiniz. ");
INSERT INTO azb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Heç bir dul qadına və yetimə əziyyət verməyin. ");
INSERT INTO azb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Əgər bunlardan birinə əziyyət versəniz və o Mənə fəryad etsə, Mən hökmən fəryadını eşidəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Qəzəblənib sizi qılıncdan keçirəcəyəm. Arvadlarınız dul, uşaqlarınız isə yetim qalacaq. ");
INSERT INTO azb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Xalqıma, yanında yaşayan kasıba pul borc versəniz, onunla sələmçi kimi rəftar etməyin, üstünə sələm qoymayın. ");
INSERT INTO azb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Əgər başqasının paltarını girov alırsınızsa, gün batandan əvvəl ona girovu qaytarın. ");
INSERT INTO azb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Çünki bu paltar onun yeganə örtüyü və əyninin geyimidir. Bəs o adam yatanda nə ilə üstünü örtsün? O Mənə fəryad edəndə səsini eşidəcəyəm, çünki Mən lütfkaram. ");
INSERT INTO azb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Allaha küfr etmə və xalqın başçısına lənət etmə. ");
INSERT INTO azb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Öz məhsulunu və şirə təqdimlərini Mənə gətirməyini gecikdirmə. İlk oğullarını Mənə həsr et. ");
INSERT INTO azb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Mal-qaranın və qoyun-keçinin ilk balaları ilə də belə et: yeddi gün onları anaları ilə qoyub, səkkizinci gün Mənə həsr et. ");
INSERT INTO azb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Mənim üçün müqəddəs xalq olun. Məhz buna görə də vəhşi heyvanın çöldə parçaladığı heyvanın ətini yeməyin, onu itlərə atın. ");
INSERT INTO azb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Boş xəbər gəzdirməyin. Yalançı şahid olmaq üçün haqsız adamla əlbir olmayın. ");
INSERT INTO azb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Şər iş görən izdihama qoşulmayın. Məhkəmədə çoxları ilə birləşərək ədaləti təhrif edib yalançı şahid olmayın. ");
INSERT INTO azb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kasıba da məhkəmədə meylini salma. ");
INSERT INTO azb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Sən düşməninin azmış buğasına, inəyinə yaxud eşşəyinə rast gəlsən, sahibinə qaytarmalısan. ");
INSERT INTO azb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Sənə nifrət edən adamın eşşəyini yükü altında yıxılmış halda görəndə onu tərk etmə; ona kömək et ki, bu yükdən azad olsun. ");
INSERT INTO azb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Möhtac olan adamın məhkəmə işində ona qarşı ədaləti təhrif etmə. ");
INSERT INTO azb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Yalan işdən uzaq ol. Günahsıza və salehə ölüm hökmü vermə. Çünki Mən haqsıza bəraət qazandırmayacağam. ");
INSERT INTO azb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Rüşvət alma, çünki rüşvət gözüaçıqları kor edər, salehlərin sözlərini isə təhrif edər. ");
INSERT INTO azb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Qəribə zülm etmə. Siz də qəribliyi hiss etmisiniz, çünki özünüz də Misir ölkəsində qərib idiniz. ");
INSERT INTO azb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Altı il torpağınızı əkin və məhsulunu yığın. ");
INSERT INTO azb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Yeddinci il ona əl dəyməyin ki, xalqınızdan olan möhtaclar oradan yesin. Onlardan artıq qalanı isə çöl heyvanları yesin. Üzüm və zeytun bağlarınızda da belə hərəkət edin. ");
INSERT INTO azb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Altı gün işlərinizi görün, yeddinci gün isə istirahət edin ki, mal-qaranız və eşşəyiniz rahatlansın, evinizdə doğulan qullar və qəriblər də dincəlsin. ");
INSERT INTO azb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Mənim sizə söylədiyim hər şeyə riayət edin. Başqa allahların adını çəkməyin, qoy o adlar sizin ağzınızdan heç vaxt çıxmasın. ");
INSERT INTO azb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Mənə ildə üç dəfə bayram edin: ");
INSERT INTO azb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Mayasız Çörək bayramını qeyd edin. Mən sizə əmr etdiyim kimi Aviv ayında təyin olunmuş vaxt yeddi gün mayasız çörək yeyin. Çünki Misirdən o ayda çıxdınız. Heç kəs önümə əliboş gəlməsin. ");
INSERT INTO azb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Tarladakı əkinin nübarı ilə Biçin bayramını qeyd edin. İlin sonunda işinin bütün məhsulunu tarladan yığıb Yığım bayramını qeyd edin. ");
INSERT INTO azb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","İldə üç dəfə sizin bütün kişiləriniz Sahibləri Rəbbin hüzuruna gəlsinlər. ");
INSERT INTO azb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Mənə gətirilən qurbanın qanını mayalı çörəklə təqdim etməyin. Bayram qurbanımın piyi səhərə qədər qalmasın. ");
INSERT INTO azb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Torpağın nübarının ilk hissəsini Allahınız Rəbbin məbədinə gətirin. Oğlağı anasının südündə bişirməyin. ");
INSERT INTO azb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Budur, Mən yolda sizi qorumaq və hazırladığım yerə gətirmək üçün qarşınızda bir Mələk göndərirəm. ");
INSERT INTO azb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Onun hüzurunda ehtiyatlı olun və səsinə qulaq asın. Ona qarşı üsyan qaldırmayın, O, itaətsizliyinizi bağışlamaz, çünki Mənim adım onun üzərindədir. ");
INSERT INTO azb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Əgər Onun səsinə qulaq asıb dediyimə əməl etsəniz, onda Mən sizin düşmənlərinizə düşmən, yağılarınıza isə yağı olacağam. ");
INSERT INTO azb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mələyim qarşınızda gedəcək və sizi Emorluların, Xetlilərin, Perizlilərin, Kənanlıların, Xivlilərin və Yevusluların yanına gətirəcək; Mən onları silib atacağam. ");
INSERT INTO azb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Onların allahlarına səcdə etməyin, onlara ibadət etməyin və qaydalarına əməl etməyin. O allahları dağıdıb yox edin, onların daş sütunlarını parça-parça etməlisiniz. ");
INSERT INTO azb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Siz isə Allahınız Rəbbə xidmət edin, O da çörəyinizə və suyunuza bərəkət verəcək; sizin daxilinizdən xəstəliyi yox edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ölkənizdə nə uşaq salan, nə də sonsuz qadın olacaq. Ömrünüzü də uzun edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Öz dəhşətimi qarşınızca göndərirəm. Sizin aralarına getdiyiniz bütün xalqlara qarışıqlıq salacağam və bütün düşmənlərinizin dönüb sizdən qaçmasına bais olacağam. ");
INSERT INTO azb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Eşşəkarısını da qarşınızca göndərəcəyəm, o da Xivliləri, Kənanlıları və Xetliləri önünüzdən qovacaq. ");
INSERT INTO azb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Lakin bir il ərzində onları önünüzdən qovmayacağam ki, ölkə viranə qalmasın və çöl heyvanları çoxalıb sizin üstünüzə daraşmasın. ");
INSERT INTO azb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Yavaş-yavaş onları önünüzdən o vaxtacan qovacağam ki, siz törəyib çoxalaraq ölkənin sahibi olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Qırmızı dənizdən Filişt dənizinə qədər, səhradan Fərat çayına qədər sərhədlərinizi çəkəcəyəm. Ölkənin sakinlərini sizə təslim edəcəyəm, siz isə onları yanınızdan qovarsınız. ");
INSERT INTO azb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nə onlarla, nə də allahları ilə əhd kəsin. ");
INSERT INTO azb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Qoymayın ki, onlar ölkənizdə yaşasınlar və sizin Mənə qarşı günah edərək onların allahlarına ibadət etməyinizə bais olsunlar. Bu sizə tələ olacaq». ");
INSERT INTO azb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Rəbb Musaya dedi: «Sən, Harun, Nadav, Avihu və İsrail ağsaqqallarından yetmiş nəfər Rəbbin yanına çıxın. Uzaqdan səcdə edin. ");
INSERT INTO azb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sonra yalnız sən, ey Musa, Rəbbin hüzuruna yaxınlaş, o biriləri yaxınlaşmasınlar. Xalq isə səninlə buraya çıxmasın». ");
INSERT INTO azb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa gəlib Rəbbin bütün sözlərini və hökmlərini xalqa nəql etdi. Bütün xalq bir səslə cavab verib dedi: «Rəbbin söylədiyi sözlərin hamısına əməl edəcəyik». ");
INSERT INTO azb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa Rəbbin bütün sözlərini yazdı. O, səhər erkən durub dağın ətəyində qurbangah və İsrailin on iki qəbiləsinə görə on iki sütun qurdu. ");
INSERT INTO azb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Sonra Musa İsrailin cavanlarına Rəbbin önündə yandırma qurbanları və ünsiyyət qurbanları olaraq buğalar kəsdirdi. ");
INSERT INTO azb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa heyvanların qanının yarısını götürüb ləyənlərə tökdü. Qanın o biri yarısını isə qurbangahın üstünə səpdi. ");
INSERT INTO azb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","O, əhd kitabını əlinə alıb xalqa ucadan oxudu və onlar dedilər: «Rəbbin söylədiyi bütün sözlərə əməl edib qulaq asacağıq!» ");
INSERT INTO azb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Sonra Musa qanı götürüb xalqın üstünə səpərək dedi: «Budur bütün bu sözlərə görə Rəbbin sizinlə kəsdiyi əhdin qanı». ");
INSERT INTO azb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Bunu edib Musa Harun, Nadav, Avihu və İsrail ağsaqqallarından yetmiş nəfərlə birgə çıxıb, ");
INSERT INTO azb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","İsrailin Allahını gördülər. Onun ayaqları altında göy yaqutdan döşəməyə bənzər, səmanın özü kimi aydın bir şey var idi. ");
INSERT INTO azb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Allah İsrailin başçılarına əl qaldırmadı; onlar Allahı gördülər və yeyib-içdilər. ");
INSERT INTO azb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Rəbb Musaya dedi: «Mənim yanıma dağa çıx və orada dur; xalqı öyrətmək üçün qanunu və əmrləri yazdığım daş lövhələri sənə verim». ");
INSERT INTO azb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa köməkçisi Yeşua ilə Allahın dağına çıxmaq üçün qalxdı. ");
INSERT INTO azb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ağsaqqallara isə dedi: «Biz geri qayıdanadək burada gözləyin. Budur, Harun və Xur yanınızdadır; kimin nə çətin işi varsa, onların yanına gedə bilər». ");
INSERT INTO azb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa bunu deyəndən sonra dağa çıxdı. Bulud dağı bürüdü. ");
INSERT INTO azb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Rəbbin izzəti Sina dağının üstündə məskən saldı. Bulud onu altı gün bürüdü. Yeddinci gün Rəbb Musanı buludun içindən çağırdı. ");
INSERT INTO azb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Rəbbin izzəti İsrail övladlarının gözündə dağın başında yandırıb-yaxan alov kimi görünürdü. ");
INSERT INTO azb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa buludun içinə girib dağa çıxdı və qırx gün-qırx gecə dağda qaldı. ");
INSERT INTO azb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Mənə ianələr gətirmək barədə İsrail övladlarına belə söylə: könlü istəyən hər bir adamdan ianəni qəbul edin. ");
INSERT INTO azb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Onlardan qəbul edəcəyiniz ianələr budur: qızıl, gümüş, tunc, ");
INSERT INTO azb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","bənövşəyi, tünd qırmızı və al rəngli iplik, incə kətan, keçi yunu, ");
INSERT INTO azb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","qırmızı boyanmış qoç dəriləri, suiti dəriləri, əbrişim ağacı, ");
INSERT INTO azb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","çıraq üçün zeytun yağı, məsh yağı və ətirli buxur üçün ətriyyatlar, ");
INSERT INTO azb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","efodla döşlüyün üstünə taxılan damarlı əqiq və sağanaq daşları. ");
INSERT INTO azb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Mənim üçün Müqəddəs məkan düzəltsinlər ki, aralarında məskunlaşım. ");
INSERT INTO azb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Mənim məskənimi və onun bütün avadanlığını göstərdiyim nümunələrə görə düzəldin. ");
INSERT INTO azb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Qoy əbrişim ağacından sandıq düzəltsinlər: uzunluğu iki qulac yarım, eni qulac yarım, hündürlüyü qulac yarım olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Onu içəridən və bayırdan xalis qızılla ört, ətrafına qızıl zolaq qoy. ");
INSERT INTO azb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Sandıq üçün dörd tökmə qızıl halqa düzəlt və onları onun dörd ayağına, iki halqanı bir yanına, iki halqanı isə o biri yanına bərkit. ");
INSERT INTO azb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Əbrişim ağacından şüvüllər düzəlt və üzərini qızılla ört. ");
INSERT INTO azb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Sandığı daşımaq üçün şüvülləri sandığın yanlarındakı halqalara keçir. ");
INSERT INTO azb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Şüvüllər sandığın halqalarında qalıb oradan ayrılmasın. ");
INSERT INTO azb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Sənə verəcəyim şəhadət lövhələrini sandığın içinə qoy. ");
INSERT INTO azb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Xalis qızıldan kəffarə qapağını düzəlt. Qoy uzunluğu iki qulac yarım, eni isə qulac yarım olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kəffarə qapağının hər iki ucu üçün yastılanmış qızıldan iki keruv düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Bir keruv qapağın bir ucunda, o birisi isə o biri ucunda olaraq qapağın iki ucunda olan keruvlar düzəlt ki, onunla bir hissədən olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Keruvlar yuxarıya açılmış qanadları ilə kəffarə qapağını örtsünlər. Keruvların üzləri bir-birinə qarşı qapağa doğru olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kəffarə qapağını sandığın üstünə qoy; sənə verəcəyim şəhadət lövhələrini isə sandığın içinə qoy. ");
INSERT INTO azb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Orada kəffarə qapağının üzərində, Şəhadət sandığının üstündəki iki keruv arasında səninlə görüşəcəyəm və İsrail övladları üçün sənə əmr edəcəyim hər şeyi söyləyəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Əbrişim ağacından bir masa düzəlt: uzunluğu iki qulac, eni bir qulac, hündürlüyü isə qulac yarım olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Onu xalis qızılla ört. Ətrafına qızıl zolaq qoy. ");
INSERT INTO azb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ətrafında eni bir ovuc olan yan lövhələri düzəlt. Yan lövhələrin ətrafına da qızıl zolaq qoy. ");
INSERT INTO azb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Masa üçün dörd qızıl halqa düzəlt, halqaları onun dörd küncünə, dörd ayağına bərkit. ");
INSERT INTO azb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Halqalar yan lövhələrə yaxın olaraq masanı aparan şüvüllərin keçdiyi yerlər olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Şüvülləri əbrişim ağacından düzəlt və onları qızılla ört; masa onların vasitəsi ilə aparılsın. ");
INSERT INTO azb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Masa üçün xalis qızıldan sinilər və nimçələr, içmə təqdimlərini tökmək üçün dolçalar və piyalələr düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Daima Mənim hüzurumda masanın üstünə təqdis çörəkləri qoy. ");
INSERT INTO azb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Xalis qızıldan bir çıraqdan düzəlt. Bu çıraqdan yastılanmış qızıldan olmalıdır. Altlığı, gövdəsi, kasacıqları, qönçələri və gülləri onunla bir hissədən olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Çıraqdanın yanlarından altı budaq – onun bir yanından üç budaq, o biri yanından da üç budaq çıxsın. ");
INSERT INTO azb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Hər bir budağında badam çiçəyinə bənzər üç kasacıq, qönçə və gül olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Çıraqdanın gövdəsində isə badam çiçəyinə bənzər dörd kasacıq, qönçə və gül olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Çıraqdanın gövdəsindən çıxan altı budağın bir cütünün altında bir qönçə, o biri cütünün altında bir qönçə, o birinin də altında bir qönçə olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Qönçələr və budaqlar onunla bir hissədən ibarət olsun; hamısı eyni hissədən, yastılanmış xalis qızıldan olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Onun üçün yeddi çıraq düzəlt və çıraqları onun üstünə qoy ki, qabaq tərəfinə işıq salsın. ");
INSERT INTO azb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Maşaları və xəkəndazları da xalis qızıldan olsun. ");
INSERT INTO azb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Çıraqdan və onun bütün avadanlığı bir talant xalis qızıldan düzəldilsin. ");
INSERT INTO azb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Dağda sənə göstərilən nümunəyə görə bunların hamısını ehtiyatla düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Müqəddəs məskəni on pərdədən düzəlt. Pərdələri nəfis toxunmuş incə kətandan, bənövşəyi, tünd qırmızı və al rəngli iplikdən, üstünü isə keruvlar şəklində naxışla düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Hər pərdənin uzunluğu iyirmi səkkiz qulac, eni isə dörd qulac olsun. Qoy bütün pərdələr bir ölçüdə olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pərdələrdən beşi bir-birinə birləşdirilsin, digər beşi də bir-birinə birləşdirilsin. ");
INSERT INTO azb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Bir birləşmənin ucunda olan pərdənin kənarında bənövşəyi ilgəklər düzəlt, o biri birləşmənin ucunda olan pərdənin kənarında da eyni şəkildə ilgəklər düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Bir pərdəyə əlli ilgək, o biri birləşmədəki pərdənin kənarında onlara uyğun gələn əlli ilgək düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Qızıldan əlli bənd düzəlt. Bəndlərlə pərdələri bərkit və çadırı birləşdir ki, məskən bütöv olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Məskəni örtən çadır üçün keçi yunundan on bir ədəd pərdə düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Hər pərdənin uzunluğu otuz qulac, eni isə dörd qulac olsun. On bir pərdə bir ölçüdə olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Beş pərdəni ayrıca və altı pərdəni ayrıca birləşdir. Altıncı pərdəni isə çadırın qabaq tərəfindən qatla. ");
INSERT INTO azb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Bir birləşmənin qıraq pərdəsinin kənarında əlli ilgək, o biri birləşmənin qıraq pərdəsinin kənarında da əlli ilgək düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tuncdan əlli bənd düzəlt; bəndləri ilgəklərə tax və çadırı birləşdir ki, o bütöv olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Çadırın pərdələrindən artıq qalan pərdənin yarısını məskənin arxa tərəfindən salla. ");
INSERT INTO azb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Çadırın pərdələrinin uzunluğunun hər iki ucunda artıq qalan bir qulac parça məskəni örtmək üçün onun hər iki tərəfindən sallansın. ");
INSERT INTO azb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Çadır üçün qırmızı boyanmış qoç dərilərindən bir pərdə və onun üstündə suiti dərilərindən bir pərdə düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Müqəddəs məskən üçün əbrişim ağacından dik duran çərçivələr düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Hər çərçivənin uzunluğu on qulac, eni isə qulac yarım olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hər çərçivənin üstündə iki bir-birinə bağlanan zivana olsun; məskənin bütün çərçivələrini belə düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Məskənin cənub tərəfi üçün iyirmi çərçivə ");
INSERT INTO azb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","və onların altına qoyulacaq qırx gümüş altlıq düzəlt; hər çərçivənin altında iki zivanası üçün iki altlıq olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Məskənin şimal tərəfi üçün də iyirmi çərçivə ");
INSERT INTO azb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","və qırx gümüş altlıq, hər çərçivənin altında iki altlıq olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Məskənin qərbə doğru arxası üçün altı çərçivə düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Məskənin arxa küncləri üçün isə iki çərçivə düzəlt ki, ");
INSERT INTO azb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","bunlar aşağıda birləşib yuxarıda bir halqaya taxılsın; hər iki künc üçün elə iki çərçivə olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Bu səkkiz çərçivə üçün on altı gümüş altlıq, hər çərçivənin altında iki altlıq olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Əbrişim ağacından şüvüllər düzəlt: məskənin hər iki tərəfindəki çərçivələri üçün beş şüvül, ");
INSERT INTO azb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","məskənin qərbə doğru arxa tərəfdəki çərçivələri üçün də beş şüvül olsun. ");
INSERT INTO azb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Orta şüvül çərçivələrin ortasından bir ucdan o biri uca qədər uzansın. ");
INSERT INTO azb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Çərçivələri qızılla ört; şüvüllərin keçdiyi halqaları qızıldan düzəlt; şüvülləri də qızılla ört. ");
INSERT INTO azb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Dağda sənə göstərilən layihəyə görə müqəddəs məskəni qur. ");
INSERT INTO azb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Pərdəni bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan, üstünü isə keruvlar şəklində naxışla düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Onu dörd dirək üstündə as; hər dirək qızılla örtülmüş əbrişim ağacından olsun. Üstündə qızıl qarmaqları olsun və dörd gümüş altlıq üstündə dursun. ");
INSERT INTO azb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Pərdəni bəndlərdən as və Şəhadət sandığını oraya, pərdənin arxasına gətir. Bu pərdə Müqəddəs yerlə Ən Müqəddəs yeri ayırsın. ");
INSERT INTO azb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ən Müqəddəs yerdə Şəhadət sandığının üstünə kəffarə qapağını tax. ");
INSERT INTO azb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Masanı pərdənin bayır tərəfinə, çıraqdanı masanın qarşısına – məskənin cənub tərəfinə, masanı isə şimal tərəfinə qoy. ");
INSERT INTO azb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Hüzur çadırının girişi üçün arakəsməni bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan, naxış tikməsi ilə düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Bu arakəsmə üçün də əbrişim ağacından beş dirək düzəlt və üstünü qızılla ört; üstündə qızıl qarmaqlar olsun və onlar üçün tuncdan beş altlıq tök. ");
INSERT INTO azb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Qurbangahı əbrişim ağacından düzəlt. Qoy dördbucaq şəklində olub uzunluğu beş qulac, eni də beş qulac, hündürlüyü isə üç qulac olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Qurbangahın dörd küncündən onunla bir hissədən olan dörd buynuz düzəlt. Qurbangahın üstünü tuncla ört. ");
INSERT INTO azb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Oranın kül qablarını, kürəklərini, ləyənlərini, çəngəllərini, xəkəndazlarını – bütün avadanlığını tuncdan düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Qurbangah üçün tuncdan torlu şəbəkə düzəlt. Torun dörd bucağında tuncdan dörd halqa düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Onu qurbangahın kənarından aşağıya qoy ki, şəbəkə onun yarısına qədər yetişsin. ");
INSERT INTO azb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Qurbangah üçün əbrişim ağacından şüvüllər düzəlt və üstünü tuncla ört. ");
INSERT INTO azb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Şüvülləri halqalara tax ki, onlar qurbangahı aparan zaman onun hər iki yanında olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Qurbangahın içi boş və taxtadan olsun. Dağda sənə göstərdiyim kimi onu düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Müqəddəs məskənin həyətini düzəlt. Həyətin cənub tərəfində bir tərəf üçün uzunluğu yüz qulac olan pərdələr nəfis toxunmuş incə kətandan olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Onların iyirmi dirəyi və iyirmi altlığı tuncdan, dirəklərin qarmaqları və bəndləri isə gümüşdən olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Şimal tərəfi üçün də uzunluğu yüz qulac pərdə olsun; onların iyirmi dirəyi və iyirmi altlığı tuncdan, dirəklərin qarmaqları və bəndləri isə gümüşdən olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Qərb tərəfində uzunluğu həyətin eni qədər əlli qulac pərdələr olsun. Onlar üçün on dirək və on altlıq düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Şərq tərəfində də həyətin eni əlli qulac olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Darvazanın bir tərəfi üçün üç dirəyi və üç altlığı olan uzunluğu on beş qulac pərdələr olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","O biri tərəf üçün də üç dirəyi və üç altlığı olan uzunluğu on beş qulac pərdələr olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Həyətin darvazası üçün uzunluğu iyirmi qulac olan bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan naxış tikməli arakəsmə, onun dörd dirəyi və dörd altlığı olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Həyətin bütün ətraf dirəkləri gümüşlə bəndlənsin; onların gümüş qarmaqları və tunc altlıqları olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Həyətin uzunluğu yüz qulac və eni hər yerdə əlli qulac olsun; nəfis toxunmuş incə kətandan olan pərdənin hündürlüyü isə beş qulac, altlıqları da tuncdan olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Müqəddəs məskənin ibadəti üçün işlənən bütün avadanlığı, onun bütün payaları kimi həyətin bütün payaları da tuncdan olsun. ");
INSERT INTO azb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Sən İsrail övladlarına əmr et ki, işıq yandırmaq üçün sənə zeytundan çəkilmiş xalis yağ gətirsinlər. Bu yağdan çıraqlar daima ");
INSERT INTO azb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Hüzur çadırında, Şəhadət sandığının qarşısındakı pərdənin bayır tərəfində yansın. Harunla oğulları onu hər axşam Rəbbin hüzurunda yandırıb səhərə qədər nəzarət etsinlər. Qoy bu, nəsildən-nəslə İsrail övladları üçün əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Sən isə qardaşın Harunu və onun oğulları Nadavı, Avihunu, Eleazarı və İtamarı İsrail övladlarının arasından yanına gətir ki, onlar Mənə kahinlik etsin. ");
INSERT INTO azb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Qardaşın Haruna izzət və gözəllik üçün müqəddəs geyimlər hazırla. ");
INSERT INTO azb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Sən də hikmət ruhu ilə doldurduğum bütün məharətli ustalara Harunun təqdis olunması üçün ona geyimlərin hazırlamasını tapşır ki, o Mənə kahinlik etsin. ");
INSERT INTO azb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Onların hazırlayacağı geyimlər bunlardır: döşlük, efod, üst cübbə, dama-dama xirqə, çalma və qurşaq. Bu müqəddəs geyimləri qardaşın Haruna və oğullarına hazırlasınlar ki, Mənə kahinlik etsinlər. ");
INSERT INTO azb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Qoy geyimləri hazırlayanlar qızıl, bənövşəyi, tünd qırmızı, al rəngli iplik və incə kətan götürsünlər. ");
INSERT INTO azb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Efodu qızıldan, bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan naxışla düzəltsinlər. ");
INSERT INTO azb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hər iki ucunu bir-birinə bağlayan iki çiyinlik olsun ki, o bərkidilsin. ");
INSERT INTO azb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Efodun üstündəki kəmər eyni hissədən olsun. O da qızıldan, bənövşəyi, tünd qırmızı və al rəngli iplik və nəfis toxunmuş incə kətandan olsun. ");
INSERT INTO azb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","İki ədəd damarlı əqiq daşı götür və üstündə İsrailin oğullarının adlarını həkk et. ");
INSERT INTO azb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Onların doğulma sırası ilə bir daşın üstündə altı ad, o birisinin üstündə qalan altı adı, ");
INSERT INTO azb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","həkkakın işi olan möhür oyması kimi iki daş üstündə İsrailin oğullarının adlarını həkk et. Bunları hörmə qızıl sağanaqlara salıb, ");
INSERT INTO azb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","bu iki daşı efodun çiyinliklərinə tax. Bunlar İsrailin oğullarının xatirə daşlarıdır; Harun onların adlarını Rəbbin önündə iki çiynində xatirə kimi gəzdirəcək. ");
INSERT INTO azb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Hörmə qızıldan sağanaqlar düzəlt, ");
INSERT INTO azb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","xalis qızıldan iki ipə bənzər burma zəncir düzəlt; burma zəncirləri sağanaqlara tax. ");
INSERT INTO azb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Hökm döşlüyünü efod kimi naxışlı düzəlt. Onu qızıldan, bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Döşlük ikiqat, dördbucaq şəklində olub uzunluğu bir qarış, eni də bir qarış olsun. ");
INSERT INTO azb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Üstündəki bir çərçivəyə dörd sıra daş tax. Birinci sıra yaqut, topaz, zümrüd ");
INSERT INTO azb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ikinci sıra firuzə, göy yaqut və almaz, ");
INSERT INTO azb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","üçüncü sıra sirkon, əqiq və ametist, ");
INSERT INTO azb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","dördüncü sıra sarı yaqut, damarlı əqiq və yəşəm daşı olsun. Bu daşlar hörmə qızıl sağanaqlara taxılsın. ");
INSERT INTO azb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Daşlar İsrailin oğullarının adlarına görə on iki dənə olsun; hər daş on iki qəbilədən birinin adının oyma möhürü olsun. ");
INSERT INTO azb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Döşlük üçün xalis qızıldan ipəbənzər burma zəncirlər qayır. ");
INSERT INTO azb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Döşlük üçün iki qızıl halqa düzəlt və onları döşlüyün iki ucuna tax. ");
INSERT INTO azb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","İki qızıl ipi döşlüyün uclarındakı iki halqaya tax. ");
INSERT INTO azb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","İplərin o biri uclarını iki hörmə sağanağa taxıb efodun çiyinliklərinin qabaq tərəfinə bağla. ");
INSERT INTO azb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Yenə də iki qızıl halqa düzəlt və onları döşlüyün iki ucuna, efodla yanaşı iç qatına tax. ");
INSERT INTO azb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Digər iki qızıl halqa düzəlt və onu efodun çiyinliklərinin qabaq tərəfinə, aşağıya, efodun kəməri ilə birləşmə üzərinə bərkit. ");
INSERT INTO azb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Döşlük halqaları ilə efodun halqalarına bənövşəyi qaytanla bağlanıb efodun kəmərinin üzərinə bərkidilsin ki, döşlük efoddan sallanmasın. ");
INSERT INTO azb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Harun Müqəddəs yerə daxil olduğu zaman Rəbbin önündə daima xatirə olaraq İsrailin oğullarının adlarını hökm döşlüyündə, ürəyinin üstündə daşıyacaq. ");
INSERT INTO azb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Urim və Tummimi də hökm döşlüyünə qoy ki, Rəbbin hüzuruna daxil olduğu zaman onlar da ürəyinin üstündə olsun. Beləcə Harun İsrail övladlarının hökmünü Rəbbin hüzurunda daima ürəyinin üstündə daşıyacaq. ");
INSERT INTO azb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Efodun cübbəsini büsbütün bənövşəyi iplikdən tik. ");
INSERT INTO azb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ortasında baş keçirmək üçün yer olsun. Onun kənarında cırılmamaq üçün yaxa toxunsun. ");
INSERT INTO azb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Cübbənin ətəyinin ətrafına bənövşəyi, tünd qırmızı və al rəngli iplikdən narlar və zınqırovlar düz: ");
INSERT INTO azb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","cübbənin ətəyi boyunca ətrafında qızıl zınqırov və nar sıra ilə düzülsün. ");
INSERT INTO azb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Qoy cübbə Harun xidmət etdiyi zaman əynində olsun. Verdiyi səs də onun Müqəddəs yerə – Rəbbin hüzuruna girib-çıxdığı zaman eşidilsin ki, o ölməsin. ");
INSERT INTO azb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Xalis qızıldan bir lövhəcik düzəlt və onun üzərində möhür oyması olaraq “Rəbbə həsr edilmiş” yazısını həkk et. ");
INSERT INTO azb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Onu bənövşəyi qaytanla çalmanın üstünə – qabaq tərəfinə tik. ");
INSERT INTO azb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Beləcə lövhəcik Harunun alnının üstündə olsun. İsrail övladlarının təqdis etdikləri bütün müqəddəs hədiyyələrin Rəbbin qarşısında məqbul olub-olmamasının məsuliyyətini Harun daşıyacaq. Buna görə də qoy lövhəcik həmişə Harunun alnında olsun. ");
INSERT INTO azb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Xirqəni incə kətandan dama-dama hör. Çalmanı da incə kətandan düzəlt. Qurşağın üzərinə naxış tikib düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Harunun oğullarına izzət və gözəllik üçün xirqələr, qurşaqlar və papaqlar düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bunları qardaşın Harunla oğullarına geyindirib onları məsh et, vəzifəyə qoy və Mənə kahinlik etmək üçün təqdis et. ");
INSERT INTO azb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Beldən buda qədər lüt bədənlərini örtən kətan alt paltarları tik. ");
INSERT INTO azb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Bunları Harunla oğulları Müqəddəs yerdə xidmət etmək üçün Hüzur çadırına daxil olanda yaxud qurbangaha yaxınlaşanda cəza çəkib ölməmək üçün geyəcəklər. Bu, Harunla övladlarına əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Mənə kahinlik etmək üçün onları bu qaydada təqdis et. Qüsursuz bir buğa və iki qoç götür. ");
INSERT INTO azb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Mayasız çörəkləri, zeytun yağı ilə yoğrulmuş mayasız kökələri və üstünə zeytun yağı sürtülmüş mayasız qoğalları narın buğda unundan hazırla. ");
INSERT INTO azb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Onları bir səbətin içinə qoy, buğa və iki qoçla birgə təqdim et. ");
INSERT INTO azb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Sonra Harunla oğullarını Hüzur çadırının girişinə gətir və onları su ilə yuyundur. ");
INSERT INTO azb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Geyimlərini götürüb Harunun əyninə xirqəni, efod cübbəsini, efodu və döşlüyü geyindir və efodun kəmərini belinə bağla. ");
INSERT INTO azb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Onun başına çalmanı, çalmaya da müqəddəslik tacını qoy. ");
INSERT INTO azb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Məsh yağını götürüb Harunun başına tök və onu məsh et. ");
INSERT INTO azb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Sonra oğullarını gətir və onlara xirqələr geyindir. ");
INSERT INTO azb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Haruna və onun oğullarının belinə qurşaq bağla və başlarına papaq qoy. Əbədi qaydaya görə kahinlik onların olsun. Beləcə Harunla oğullarını vəzifəyə qoy. ");
INSERT INTO azb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Sonra Hüzur çadırının önünə buğanı gətir. Qoy Harunla oğulları əllərini buğanın başına qoysunlar. ");
INSERT INTO azb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Buğanı Rəbbin önündə, Hüzur çadırının girişində kəs. ");
INSERT INTO azb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Buğanın qanından götür və barmağınla qurbangahın buynuzlarına çək. Qanın qalan hissəsini isə qurbangahın altlığına tök. ");
INSERT INTO azb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Heyvanın içalatını örtən bütün piyi, qaraciyərin quyruğa bənzər hissəsini, hər iki böyrəyini və üstündəki piyi qurbangahda tüstülədib yandır. ");
INSERT INTO azb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Buğanın ətini, dərisini və bağırsağını düşərgənin kənarında yandır. Bu, günah qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Bir qoç da götür; qoy Harunla oğulları əllərini qoçun başına qoysunlar. ");
INSERT INTO azb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sonra qoçu kəs, qanını götür və onu qurbangahın hər tərəfinə səp. ");
INSERT INTO azb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Qoçu parça-parça doğra, içalatını və budlarını yuyub, tikələrinin və başının üstünə qoy. ");
INSERT INTO azb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Bütün qoçu qurbangahda tüstülədib yandır. Bu, Rəbb üçün yandırma qurbanı, Onun xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Sən o biri qoçu da götür, Harunla oğulları əllərini onun başına qoysunlar. ");
INSERT INTO azb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Sonra qoçu kəs; qanından bir az götürüb Harunun sağ qulağının mərcəyinə, oğullarının sağ qulaq mərcəklərinə, onların sağ əllərinin və sağ ayaqlarının baş barmaqlarına çək. Qoçun qanını qurbangahın hər tərəfinə səp. ");
INSERT INTO azb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Qurbangahdakı qandan və məsh yağından götürüb Haruna və onun geyimlərinə, oğullarına və onların geyimlərinə çilə. Beləcə Harun və onun geyimləri, oğulları və onların geyimləri təqdis olunsun. ");
INSERT INTO azb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Sonra qoçun piyini, quyruğunu, içalatını örtən piyi, qaraciyərinin quyruğa bənzər hissəsini, hər iki böyrəyini, üstündəki piyi və sağ budunu götür. Çünki bu təqdis qoçudur. ");
INSERT INTO azb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Rəbbin önündə olan mayasız çörəklər səbətindən bir yastı çörək kökəsi, bir zeytun yağı ilə yoğrulmuş çörək kökəsi və bir qoğal götür. ");
INSERT INTO azb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Bunların hamısını Rəbbin hüzurunda yellədərək təqdim etmək üçün Harunun və onun oğullarının əllərinə qoy. ");
INSERT INTO azb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Sonra bu şeyləri əllərindən alıb qurbangahda yandırma qurbanı ilə tüstülədib yandır. Bu, Rəbbin hüzurunda Onun xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Harunun təqdis qurbanı olan qoçdan döş ətini götürüb Rəbbin hüzurunda yellədərək təqdim et. Bu sənin payındır. ");
INSERT INTO azb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Harunla oğullarının təqdis qurbanı olan qoçdan yellədilən döş ətini və qaldırılan budu təqdis et. ");
INSERT INTO azb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Bu qaldırılan pay Harunla övladlarının İsraillilərdən gələn əbədi pay olsun. Bu da İsrail övladlarının ünsiyyət qurbanlarından Rəbbə qaldırılan pay olsun. ");
INSERT INTO azb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Harunun müqəddəs geyimləri özündən sonra oğullarına qalsın ki, onları geyərək məsh olunub vəzifəyə qoyulsunlar. ");
INSERT INTO azb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Onun yerinə kahin olub Müqəddəs yerdə xidmət etmək üçün Hüzur çadırına daxil olan oğlu yeddi gün o geyimləri geysin. ");
INSERT INTO azb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Təqdis qurbanı olan qoçun ətini götür və müqəddəs bir yerdə qaynat. ");
INSERT INTO azb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Harunla oğulları o qoçun ətini və səbətdə olan çörəyi Hüzur çadırının girişində yesinlər. ");
INSERT INTO azb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Özlərini vəzifəyə qoyub təqdis edəndə günahlarının kəffarə olması üçün istifadə edilən bu şeyləri onlar yesin; amma yad adamlar bunları yeməsin, çünki bu şeylər müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Əgər təqdis qurbanının ətindən və çörəkdən səhərə qədər qalarsa, qalığını yandır; bu şeylər yeyilməz, çünki müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Mən sənə necə əmr etmişəmsə, o cür də Harunla oğulları üçün et. Onların vəzifəyə keçmə vaxtını yeddi gün davam etdir. ");
INSERT INTO azb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Hər gün kəffarə üçün günah qurbanı olaraq bir buğa gətir. Qurbangah üçün kəffarə edərək onu pak et və təqdis etmək üçün məsh et. ");
INSERT INTO azb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yeddi gün ərzində qurbangah üçün kəffarə edərək onu təqdis et. Sonra qurbangah ən müqəddəs sayılacaq və ona toxunan hər şey müqəddəs olacaq. ");
INSERT INTO azb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Daimi olaraq hər gün qurbangah üzərində birillik iki toğlu gətir. ");
INSERT INTO azb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Toğlunun birini səhər, digərini isə axşamçagı təqdim et. ");
INSERT INTO azb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Birinci toğlu ilə birlikdə dörddə bir hin zeytun yağı ilə yoğrulmuş onda bir efa narın un və içmə təqdimi olaraq dörddə bir hin şərab gətir. ");
INSERT INTO azb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Axşamçağı təqdim etdiyin o biri toğlu ilə səhərki kimi taxıl təqdimi və içmə təqdimi gətir. Bu, Rəbbin xoşuna gələn ətirli təqdimdir. ");
INSERT INTO azb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Bu sizin üçün nəsildən-nəslə Hüzur çadırının girişində, Rəbbin önündə daimi yandırma qurbanı olacaq. Mən orada sizinlə görüşüb, səninlə danışacağam. ");
INSERT INTO azb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Orada Mən İsrail övladları ilə görüşəcəyəm; Hüzur çadırı Mənim izzətimlə təqdis olunacaq. ");
INSERT INTO azb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mən Hüzur çadırını və qurbangahı təqdis edəcəyəm; Harunla oğullarını da təqdis edəcəyəm ki, Mənə kahinlik etsinlər. ");
INSERT INTO azb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","İsrail övladları arasında məskunlaşacağam və onların Allahı olacağam. ");
INSERT INTO azb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Onlar da biləcəklər ki, aralarında məskunlaşmaq üçün onları Misir torpağından çıxaran Allahı Rəbb Mənəm, onların Allahı Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Əbrişim ağacından buxur yandırmaq üçün qurbangah düzəlt. ");
INSERT INTO azb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Qoy uzunluğu bir qulac eni də bir qulac, hündürlüyü isə iki qulac olsun, buynuzları onunla bir hissədən olsun. ");
INSERT INTO azb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Onun üzərini, hər yanını və buynuzlarını xalis qızılla ört və ətrafına qızıl zolaq qoy. ");
INSERT INTO azb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Onun üçün iki qızıl halqa düzəlt; qarşı-qarşıya olan iki yanda, zolağın altında düzəlt. Bu onu aparan şüvüllərin keçdiyi yerlər olsun. ");
INSERT INTO azb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Şüvülləri əbrişim ağacından düzəlt və qızılla ört. ");
INSERT INTO azb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Bu qurbangahı Şəhadət sandığının qarşısında olan pərdənin önünə – Mənim səninlə görüşəcəyim yerə, kəffarə qapağının önünə qoy. ");
INSERT INTO azb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Harun qurbangahda ətirli buxur yandırsın. Həm səhər çıraqları hazırladığı zaman, ");
INSERT INTO azb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","həm də axşamçağı çıraqları yandırdığı zaman onu yandırsın. Bu sizin üçün nəsildən-nəslə Rəbbin önündə daimi buxur təqdimidir. ");
INSERT INTO azb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Onun üstündə nə yad buxur, nə yandırma qurbanı, nə də taxıl təqdimi gətirin; içmə təqdimi də tökməyin. ");
INSERT INTO azb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","İldə bir dəfə Harun günah üçün kəffarə qurbanının qanını qurbangahın buynuzlarına çəkərək qurbangah üçün kəffarə etsin. Nəsildən-nəslə, ildən-ilə bir dəfə belə etsin. Qurbangah Rəbb üçün ən müqəddəsdir». ");
INSERT INTO azb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«İsrail övladlarını siyahıya aldığın zaman sayılan hər bir adam öz həyatının əvəzini Rəbbə versin ki, sayıldıqlarına görə aralarında bəla olmasın. ");
INSERT INTO azb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Sayılmış adamlara daxil olan hər kəs yarım şekel gümüş versin. Bu, iyirmi geradan ibarət olan Müqəddəs yerdəki şekelə görə sayılsın. Bu yarım şekel Rəbbin payıdır. ");
INSERT INTO azb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","İyirmi və ondan yuxarı yaşda sayılmış adamlar arasından hər bir kişi bu payı Rəbbə versin. ");
INSERT INTO azb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Həyatlarınızı kəffarə etmək üçün Rəbbin payını verəndə varlı yarım şekeldən çox, kasıb yarım şekeldən əskik verməsin. ");
INSERT INTO azb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Bu kəffarə pulunu İsrail övladlarından götürüb Hüzur çadırının ibadəti üçün təyin et. Bu, həyatlarınızı kəffarə etmək üçün Rəbbin önündə İsrail övladlarının xatirəsi olacaq». ");
INSERT INTO azb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Yuyunmaq üçün bir tunc ləyən düzəlt. Qoy altlığı da tuncdan olsun. Onu Hüzur çadırı ilə qurbangahın arasına qoy, içini də su ilə doldur ki, ");
INSERT INTO azb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Harunla oğulları əl-ayaqlarını o su ilə yusunlar. ");
INSERT INTO azb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Onlar Hüzur çadırına daxil olduğu zaman su ilə yuyunsunlar, yoxsa öləcəklər. Xidmət etmək və Rəbb üçün yandırma təqdimi tüstülədib yandırmaq üçün qurbangaha yaxınlaşanda da ");
INSERT INTO azb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","əl-ayaqlarını yusunlar, yoxsa öləcəklər. Bu, Harunla övladları üçün nəsildən-nəslə əbədi qayda olsun». ");
INSERT INTO azb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Bu gözəl ətriyyatlardan götür: beş yüz şekel duru mirra, onun yarısı qədər iki yüz əlli şekel ətirli darçın, iki yüz əlli şekel ətirli qamış ");
INSERT INTO azb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","və beş yüz şekel Çin darçını, hər şey Müqəddəs yerdəki şekelə görə sayılsın; həm də bir hin zeytun yağı. ");
INSERT INTO azb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Bunların hamısından müqəddəs məsh yağı hazırla; bu ətriyyatçının tərtib etdiyi ətriyyat, müqəddəs məsh yağı olacaq. ");
INSERT INTO azb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Həmin yağla bunları məsh et: Hüzur çadırını, Şəhadət sandığını, ");
INSERT INTO azb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","masanı və onun bütün ləvazimatını, çıraqdanı və onun əşyalarını, buxur qurbangahını, ");
INSERT INTO azb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","yandırma qurbanları üçün qurulan qurbangahı və onun bütün avadanlığını, tunc ləyəni və onun altlığını. ");
INSERT INTO azb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Beləcə bu şeyləri təqdis et ki, ən müqəddəs olsunlar; onlara toxunan hər şey müqəddəs olacaq. ");
INSERT INTO azb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Harunla oğullarını da məsh edərək təqdis et ki, Mənə kahinlik etsinlər. ");
INSERT INTO azb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","İsrail övladlarına belə de: “Bu sizin üçün nəsildən-nəslə Mənə müqəddəs məsh yağı olacaq. ");
INSERT INTO azb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Bu yağ insan bədənlərinə tökülməsin. Tərkibinə görə ona bənzər heç nə hazırlamayın. Bu yağ müqəddəsdir, onu müqəddəs sayın. ");
INSERT INTO azb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ona bənzərini düzəldən yaxud onu kənar şəxsin üzərinə tökən hər kəs xalqı arasından qovulsun”». ");
INSERT INTO azb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Sonra Rəbb Musaya dedi: «Bu ətirli maddələrdən götür: balzam, onika, ilan kölgəsi, xalis kündür; hər şey eyni miqdarda olsun. ");
INSERT INTO azb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Bunların hamısından buxur hazırla; ətriyyatçının düzəltdiyi bu qatışıq duzlanmış, təmiz və müqəddəs olsun. ");
INSERT INTO azb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ondan bir qədərini narın döy və Mənim səninlə görüşəcəyim yer olan Hüzur çadırında Şəhadət sandığının önünə qoy. Bu sizin üçün ən müqəddəs olsun. ");
INSERT INTO azb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Hazırladığın buxurun tərkibinə görə özünüz üçün buxur hazırlamayın; bunu Rəbb üçün müqəddəs sayın. ");
INSERT INTO azb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ona bənzər olan ətir vurmaq üçün hazırlayan hər kəs xalqın arasından qovulsun». ");
INSERT INTO azb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Bax Yəhuda qəbiləsindən Xur oğlu Uri oğlu Besaleli adı ilə çağırıb, ");
INSERT INTO azb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","onu Allahın Ruhu ilə hikmət, dərrakə, bilik və hər cür məharətlə doldurmuşam ki, ");
INSERT INTO azb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","qızıl, gümüş və tuncla işləməyi bacarsın, ");
INSERT INTO azb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","daş-qaş yonsun, ağac oysun, hər cür məharət göstərə bilsin. ");
INSERT INTO azb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mən də Dan qəbiləsində olan Axisamak oğlu Oholiavı ona köməkçi təyin etmişəm. Hər müdrik adamın ürəyinə hikmət qoymuşam ki, Mən sənə necə əmr etmişəm, belə də etsinlər: ");
INSERT INTO azb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Hüzur çadırını, Şəhadət sandığını və üstündəki kəffarə qapağını, çadırın bütün avadanlığını, ");
INSERT INTO azb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","masanı və onun ləvazimatını, xalis qızıldan çıraqdanı və onun bütün əşyalarını, buxur qurbangahını, ");
INSERT INTO azb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","yandırma qurbanları üçün qurulan qurbangahı və onun bütün avadanlığını, ləyəni və onun altlığını, ");
INSERT INTO azb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","toxunmuş geyimləri – kahin Harunun müqəddəs geyimlərini və oğullarının kahinlik etmək üçün geyimlərini, ");
INSERT INTO azb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","məsh yağını, Müqəddəs yer üçün ətirli buxuru Mən sənə necə əmr etmişəmsə, qoy o cür də düzəltsinlər». ");
INSERT INTO azb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Sən İsrail övladlarına belə söylə: “Mənim Şənbə günlərimə riayət edin. Çünki bu Mənimlə sizin aranızda nəsildən-nəslə onu bilmək üçün bir əlamətdir ki, sizi təqdis edən Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Beləliklə, Şənbə gününə riayət edin, çünki o sizin üçün müqəddəsdir. Onu ləkələyən öldürülməlidir. O gün iş görən hər kəs xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Altı gün iş görülsün, yeddinci gün isə Rəbb üçün təqdis olunan Şənbə istirahət günü olsun. O gün iş görən hər kəs öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","İsrail övladları nəsildən-nəslə əbədi əhd kimi Şənbə gününə riayət və əməl etsinlər. ");
INSERT INTO azb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Mənimlə İsrail övladları arasında əbədi bir əlamətdir ki, altı gün ərzində Rəbb göyləri və yeri yaratdı, yeddinci gün isə istirahət etdi və dincəldi”». ");
INSERT INTO azb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sina dağında Allahın Musa ilə söhbəti qurtarandan sonra Allah Öz barmağı ilə yazılmış iki şəhadət daş lövhəsini Musaya verdi. ");
INSERT INTO azb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Xalq Musanın dağdan enmədiyini, gecikdiyini görəndə Harunun ətrafına toplaşıb ona dedi: «Qalx və bizim üçün allahlar düzəlt ki, qabağımızca getsinlər. Çünki bizi Misir torpağından çıxaran adamın – bu Musanın başına nə iş gəldiyini bilmirik!» ");
INSERT INTO azb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Harun onlara cavab verdi: «Arvadlarınızın, oğullarınızın, qızlarınızın qulaqlarından qızıl sırğaları çıxarıb mənim yanıma gətirin». ");
INSERT INTO azb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bütün xalq qulaqlarında olan qızıl sırğaları çıxarıb Haruna gətirdi. ");
INSERT INTO azb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Harun onlardan qızıl götürdü, oyma aləti ilə surət verib dana şəklində tökmə büt düzəltdi. Xalq «Ey İsrail övladları, budur sizi Misir torpağından çıxaran allahlarınız!» dedi. ");
INSERT INTO azb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Harun bunu gördükdə dananın qabağında bir qurbangah düzəltdi və elan etdi: «Sabah Rəbb naminə bayram olacaq». ");
INSERT INTO azb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ertəsi gün xalq səhər tezdən qalxıb yandırma qurbanları ilə ünsiyyət qurbanları kəsdi. Xalq oturub yeyib-içdi, sonra isə qalxıb oynaşdı. ");
INSERT INTO azb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Rəbb Musaya dedi: «Tez ol, düş aşağı, çünki Misirdən gətirdiyin xalqın öz əxlaqını pozdu və ");
INSERT INTO azb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mən onlara əmr etdiyim yoldan yaman tez döndü. Özləri üçün tökmə dana düzəldib ona səcdə qıldılar, qurban kəsdilər və dedilər: “Ey İsrail övladları, budur sizi Misir torpağından çıxaran allahlarınız!”» ");
INSERT INTO azb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Rəbb Musaya sözünü davam etdi: «Görürəm ki, bu xalq dikbaş xalqdır. ");
INSERT INTO azb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Qoy Mən xalqa qarşı qəzəblənib onu yox edim, səndən isə böyük millət əmələ gətirim». ");
INSERT INTO azb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Musa Allahı Rəbbə yalvarıb dedi: «Ya Rəbb, nə üçün Öz xalqına qarşı qəzəbin alovlansın? Sən onları Misirdən böyük qüvvətinlə və qüdrətli əlinlə qurtarmadınmı? ");
INSERT INTO azb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Axı nə üçün Misirlilər “Onları pis niyyətlə, dağlarda öldürüb yer üzündən yox etmək üçün çıxartdı” desinlər? Yalvarıram, qəzəbini yatır və Öz xalqına bəla gətirmək niyyətindən dön. ");
INSERT INTO azb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Qulların İbrahimi, İshaqı, və İsraili xatırla və Özün naminə onlara and edərək “nəslinizi göydəki ulduzlar qədər çoxaldacağam, vəd etdiyim bu ölkənin hamısını nəslinizə verəcəyəm və onlar əbədilik oraya sahib olacaqlar” dedin». ");
INSERT INTO azb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Beləliklə, Rəbb Öz xalqına bəla gətirmək niyyətindən döndü. ");
INSERT INTO azb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa əlində iki şəhadət lövhəsi ilə dönüb dağdan endi. Lövhələrin iki tərəfi – bu üzü də, o üzü də yazılı idi. ");
INSERT INTO azb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Onlar Allahın işi idi; üzərindəki oyma yazılar Onun yazısı idi. ");
INSERT INTO azb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yeşua xalqın səs-küyünü eşidərək Musaya dedi: «Düşərgədən müharibə səsi gəlir». ");
INSERT INTO azb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa cavab verdi: «Bu qələbə çalanların nidası deyil, Məğlubiyyətə uğrayanların da səsi deyil. Mən nəğmə səsi eşidirəm». ");
INSERT INTO azb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa düşərgəyə yaxınlaşıb dananı və onun ətrafındakı rəqsləri gördü. O qəzəbləndi və lövhələri əlindən atıb dağın ətəyində parça-parça etdi. ");
INSERT INTO azb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Xalqın düzəltdiyi dananı götürüb yandırdı, toza dönənə qədər əzdi və suyun üzünə səpələyib İsrail övladlarına içirtdi. ");
INSERT INTO azb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa Harundan soruşdu: «Bu xalq sənə nə etdi ki, onları belə böyük günaha batırdın?» ");
INSERT INTO azb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harun cavab verdi: «Qoy ağam qəzəblənməsin. Sən bu xalqı tanıyırsan. Onun niyyəti pisdir. ");
INSERT INTO azb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Onlar mənə dedilər: “Bizim üçün allahlar düzəlt ki, qabağımızda getsinlər. Çünki bizi Misir torpağından çıxaran adamın – bu Musanın başına nə iş gəldiyini bilmirik!” ");
INSERT INTO azb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Mən isə onlara dedim: “Kimdə qızıl varsa, onu çıxarın”. Xalq da qızılı mənə verdi. Mən onu oda atdım və bu dana alındı». ");
INSERT INTO azb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa bildi ki, xalq nəzarətdən çıxıb. Harun nəzarəti o qədər zəiflətmişdi ki, düşmənlər onları lağa qoyurdular. ");
INSERT INTO azb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa düşərgənin girişində durub çağırdı: «Rəbbin tərəfində olanlar, mənim yanıma gəlin!» Bütün Levi övladları onun yanına toplaşdı. ");
INSERT INTO azb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Musa onlara dedi: «İsrailin Allahı Rəbb belə deyir: “Qoy hər biriniz qılıncını belinə qurşasın. Hər kəs düşərgədə qapı-qapı gəzərək öz qardaşını, dostunu və qonşusunu öldürsün”». ");
INSERT INTO azb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levililər də Musa onlara etdiyi əmrə əməl etdilər. O gün üç minə yaxın adam həlak oldu. ");
INSERT INTO azb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa Levililərə dedi: «Bu gün sizin hər biriniz oğlunun və qardaşının canı bahasına xeyir-dua alıb Rəbb üçün vəzifəyə təyin olundunuz». ");
INSERT INTO azb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ertəsi gün Musa xalqa dedi: «Siz böyük günaha batdınız. İndi isə Mən Rəbbin hüzuruna qalxacağam ki, bəlkə günahınızı kəffarə edə bilim». ");
INSERT INTO azb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa Rəbbin hüzuruna qayıdıb dedi: «Ah, bu xalq böyük günaha batıb, özünə qızıldan allahlar düzəltdi; ");
INSERT INTO azb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","İndi yalvarıram, onların günahlarını bağışla. Əgər belə etməsən, adımı yazdığın kitabdan sil». ");
INSERT INTO azb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Rəbb Musaya dedi: «Mənə qarşı kim günah işlədibsə, onun adını kitabımdan siləcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Lakin indi get, xalqı sənə dediyim yerə apar. Budur, Mələyim sənin qarşında gedəcək. Ancaq cəza günü gələndə onlara günahlarına görə cəza verəcəyəm». ");
INSERT INTO azb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Rəbb Harunun düzəltdiyi danaya və gördükləri işə görə İsrail xalqını bəlaya saldı. ");
INSERT INTO azb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Rəbb Musaya dedi: «Sən və Misir torpağından çıxardığın xalq bu yeri tərk edin; İbrahimə, İshaqa və Yaquba and edərək “Sənin nəslinə onu verəcəyəm” dediyim torpağa, ");
INSERT INTO azb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","qarşında bir mələk göndərib Kənanlıları, Emorluları, Xetliləri, Perizliləri, Xivliləri və Yevusluları oradan qovacağım ");
INSERT INTO azb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","süd və bal axan torpağa gedin. Siz dikbaş xalqsınız, buna görə Mən aranızda getməyəcəyəm, yoxsa yolda sizi məhv edərəm». ");
INSERT INTO azb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Xalq bu bəd xəbəri eşidəndə yas tutdu. Heç kəs bəzək taxmadı. ");
INSERT INTO azb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Rəbb Musaya demişdi: «İsrail övladlarına belə söylə: “Siz dikbaş xalqsınız, Mən aranızdan bir anlıq getsəydim, sizi məhv edərdim. İndi isə bəzəklərinizi çıxarın, Mən də bilim ki, sizinlə nə edəcəyəm”». ");
INSERT INTO azb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Beləcə Xorev dağının ətəyində İsrail övladları bəzəklərini soyundular. ");
INSERT INTO azb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa çadırı götürüb onu düşərgədən kənarda – uzaqda qurardı. Onu Hüzur çadırı adlandırdı. Rəblə məsləhətləşən hər kəs düşərgədən kənardakı Hüzur çadırına gedərdi. ");
INSERT INTO azb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musa çadıra tərəf çıxdığı vaxt bütün xalq durardı. Hər kəs çadırının girişində gözləyib, Musa çadıra girənə qədər ardınca baxardı. ");
INSERT INTO azb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa Hüzur çadırına girəndə bulud dirəyi düşüb çadırın girişində durardı; Rəbb Musa ilə danışardı. ");
INSERT INTO azb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bütün xalq Hüzur çadırının girişində duran bulud dirəyini görər, hamı qalxıb öz çadırının girişində səcdə qılardı. ");
INSERT INTO azb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Rəbb Musa ilə üz-üzə, dostu ilə söhbət etdiyi kimi danışardı. Sonra Musa düşərgəyə qayıdardı. Lakin onun gənc köməkçisi Nun oğlu Yeşua çadırı tərk etməzdi. ");
INSERT INTO azb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa Rəbbə dedi: «Bax Sən mənə “bu xalqı çıxart” deyirsən, amma mənimlə birgə kimi göndərəcəyini mənə bildirmirsən. Halbuki Sən dedin: “Səni adınla tanıyıram və gözümdə lütf tapmısan”. ");
INSERT INTO azb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Əgər mən, doğrudan da, Sənin gözündə lütf tapmışamsa, yalvarıram, Öz yolunu mənə agah elə ki, Səni tanıyım və gözündə lütf tapım. Bax bu camaat Sənin xalqındır». ");
INSERT INTO azb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","O isə Musaya cavab verdi: «Mənim hüzurum səninlə gedəcək. Özüm sənə rahatlıq verəcəyəm». ");
INSERT INTO azb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa Rəbbə cavab verdi: «Əgər Sənin hüzurun bizimlə getməsə, bizi buradan göndərmə. ");
INSERT INTO azb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Xalqımın mənimlə birlikdə Sənin gözündə lütf tapması indi nə ilə bilinəcək? Sənin bizimlə getməyindən deyilmi? Biz yer üzündə olan digər xalqlardan nə ilə fərqlənək?» ");
INSERT INTO azb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Rəbb Musaya cavab verdi: «Sən Məndən dilədiyin bu şeyi edəcəyəm. Çünki gözümdə lütf tapdın və səni adınla tanıyıram». ");
INSERT INTO azb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa dedi: «İzzətini mənə göstər». ");
INSERT INTO azb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Rəbb dedi: «Mən bütün xeyirxahlığımı Sənin qarşından keçirəcəyəm və Rəbb olan adımı qarşında bəyan edəcəyəm. Kimə istəsəm, lütf göstərərəm, kimə istəsəm, rəhm edərəm». ");
INSERT INTO azb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Sonra O davam etdi: «Üzümü isə görə bilməzsən, çünki Məni görən adam sağ qalmaz». ");
INSERT INTO azb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Sonra Rəbb dedi: «Budur, Mənim yanımda yer var, elə burada, bu qayanın üstündə dur. ");
INSERT INTO azb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","İzzətim keçəndə səni qayadakı bir yarığa qoyacağam; Mən keçənə qədər səni əlimlə örtəcəyəm. ");
INSERT INTO azb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Sonra əlimi səndən çəkəcəyəm və sən Məni arxadan görəcəksən, üzüm isə görünməyəcək». ");
INSERT INTO azb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Rəbb Musaya dedi: «Əvvəlki kimi özün üçün iki daş lövhə yon; qırdığın əvvəlki lövhələrdə yazılan sözləri yeni lövhələrin üstündə yazacağam. ");
INSERT INTO azb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Səhərə hazır ol və Sina dağına çıx. Dağın zirvəsi üstündə önümdə dur. ");
INSERT INTO azb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Qoy heç kəs səninlə çıxmasın və dağda heç bir adam görünməsin. Dağın ətəyində nə qoyun-keçi, nə də mal-qara otlasın». ");
INSERT INTO azb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Rəbb ona buyurduğu kimi Musa əvvəlkilərə bənzər iki daş lövhə yondu və səhər erkən durub, əlində iki daş lövhə tutaraq Sina dağına çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Rəbb buludun içindən enib orada Musa ilə durdu və Rəbb olan Öz adını bəyan edib ");
INSERT INTO azb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Musanın qarşısından keçərək dedi: «Rəbb Mənəm, rəhmli və lütfkar Rəbb Allaham. Mən hədsiz səbirli, bol məhəbbətli və sədaqətliyəm, ");
INSERT INTO azb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","minlərlə nəslinə məhəbbətimi göstərərəm, cəzanı, qanunsuzluğu və günahı bağışlayaram; lakin cəzasız qoymaram, ataların cəzasını üçüncü-dördüncü nəslə qədər nəvə-nəticələrinə verərəm». ");
INSERT INTO azb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa dərhal yerə sərilib Rəbbə səcdə qıldı. ");
INSERT INTO azb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Sonra Musa dedi: «Ey Xudavənd, əgər gözündə lütf tapmışamsa, yalvarıram, Sən, ey Xudavənd, aramızda ol. Biz dikbaş bir xalq olsaq da, təqsirimizlə günahımızı bağışla və bizə sahib ol». ");
INSERT INTO azb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Rəbb Musaya dedi: «Budur, Mən sənin bütün xalqınla əhd kəsirəm. Hamının qarşısında elə möcüzələr edəcəyəm ki, beləsi dünyada heç yerdə, heç bir millət arasında yaranmamışdı. Sizin ətrafınızdakı bütün xalqlar görəcəklər ki, Rəbbin işi, Mənim sənin üçün etdiyim şeylər qorxuncdur. ");
INSERT INTO azb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mənim sizə bu gün verdiyim əmrə riayət edin. Budur, Mən önünüzdən Emorluları, Kənanlıları, Xetliləri, Perizliləri, Xivliləri və Yevusluları qovuram. ");
INSERT INTO azb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Özünüzü girdiyiniz torpağın sakinləri ilə əhd kəsməkdən gözləyin ki, o sizə bir tələ olmasın. ");
INSERT INTO azb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Onların qurbangahlarını dağıdın, daş sütunlarını sındırın, ilahə Aşera bütlərini kəsin. ");
INSERT INTO azb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Başqa allahlara səcdə etməyin, çünki Rəbbin adı qısqancdır, O, həqiqətən, qısqanc Allahdır. ");
INSERT INTO azb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ona görə də nə o torpağın sakinləri ilə əhd kəsin, nə də öz allahları ilə xəyanət edib, onlara qurban kəsən vaxt sizi də dəvət edəndə qurbanlarından dadın. ");
INSERT INTO azb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Onların qızlarını öz oğullarınıza arvad olaraq almayın ki, onlar öz allahları ilə xəyanət edib sizin oğullarınıza da o allahlara xəyanət etdirməsinlər. ");
INSERT INTO azb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Özünüz üçün tökmə allahlar düzəltməyin. ");
INSERT INTO azb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Mayasız Çörək bayramını qeyd edin. Mən sizə əmr etdiyim kimi Aviv ayında təyin olunan vaxtı yeddi gün mayasız çörək yeyin, çünki Aviv ayında Misirdən çıxdınız. ");
INSERT INTO azb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Bütün ilk doğulan oğlanlar və bütün heyvanlarınızın, istər mal-qaranızın, istərsə də qoyun-keçinizin ilk doğulan balaları Mənimdir. ");
INSERT INTO azb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","İlk doğulan eşşək balası əvəzinə bir qoyun-keçi balası verin. Əgər əvəzini verməsəniz, boynunu sındırın. Aranızda hər adamın ilk oğlunun əvəzini ödəyin. Heç kəs önümə əliboş gəlməsin. ");
INSERT INTO azb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Altı gün işlərinizi görün, yeddinci gün isə istirahət edin. Şum və biçin vaxtı da belə istirahət edin. ");
INSERT INTO azb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Buğda biçinin nübarı ilə Həftələr bayramını qeyd edin. İlin sonunda isə Yığım bayramını qeyd edin. ");
INSERT INTO azb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","İldə üç dəfə sizin bütün kişiləriniz Sahibləri İsrailin Allahı Rəbbin hüzuruna gəlsinlər. ");
INSERT INTO azb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Çünki Mən sizin qarşınızdan millətləri qovub sərhədlərinizi elə genişləndirəcəyəm ki, siz ildə üç dəfə öz Allahınız Rəbbin hüzurunda görünmək üçün gələndə heç kəs sizin torpağınıza tamah salmasın. ");
INSERT INTO azb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Mənə gətirilən qurbanın qanını mayalı çörəklə təqdim etməyin. Pasxa bayramının qurban əti səhərə qədər qalmasın. ");
INSERT INTO azb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Torpağın nübarının ilk hissəsini Allahınız Rəbbin məbədinə gətirin. Oğlağı anasının südündə bişirməyin». ");
INSERT INTO azb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Rəbb Musaya dedi: «Bu sözləri yaz, çünki bu sözlərə görə Mən səninlə və bütün İsraillə əhd kəsirəm». ");
INSERT INTO azb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Beləliklə, Musa Rəblə qırx gün-qırx gecə qaldı. Bu müddət ərzində Musa heç nə yemədi, heç nə içmədi. O, lövhələrin üstündə əhdin sözlərini, On Əmri yazdı. ");
INSERT INTO azb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa əlində iki şəhadət lövhəsi tutub Sina dağından enəndə bilmirdi ki, Rəblə danışdığına görə üzü nur saçır. ");
INSERT INTO azb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Harun və bütün İsrail övladları Musanın üzünü nur saçan gördülər və ona yaxınlaşmaqdan qorxdular. ");
INSERT INTO azb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Musa onları çağıranda Harunla bütün icma başçıları ona yaxınlaşdı və Musa onlarla söhbət etdi. ");
INSERT INTO azb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sonra bütün İsrail övladları ona yaxınlaşdı. Musa Rəbbin Sina dağında ona nəql etdiyi bütün işləri onlara əmr etdi. ");
INSERT INTO azb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa söhbəti bitirəndə üzünə bir niqab çəkdi. ");
INSERT INTO azb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Musa Rəbbin hüzuruna Onunla danışmaq üçün gedəndə niqabı çıxarar və çıxanadək niqabsız olardı. Çıxanda ona nə əmr olunduğunu İsrail övladlarına nəql edirdi. ");
INSERT INTO azb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","İsrail övladları isə Musanın üzünün nur saçdığını görərdilər. Sonra Musa içəri girib Rəblə danışana qədər yenə də niqabı üzünə çəkərdi. ");
INSERT INTO azb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa İsrail övladlarının bütün icmasını toplayıb onlara dedi: «Rəbb sizə bu şeylərə əməl etməyi əmr etdi. ");
INSERT INTO azb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Altı gün işlərinizi görün, yeddinci gün isə sizin Rəbb üçün müqəddəs Şənbəniz, istirahət gününüzdür. O gün iş görən hər kəs öldürülsün. ");
INSERT INTO azb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Şənbə günü yaşadığınız heç bir yerdə od yandırmayın». ");
INSERT INTO azb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa bütün İsrail övladlarının icmasına dedi: «Rəbbin əmr etdiyi iş budur: ");
INSERT INTO azb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","öz aranızdan Rəbbə bir ianə toplayın. Qoy könlü istəyən hər kəs Rəbbə belə ianə gətirsin: qızıl, gümüş, tunc, ");
INSERT INTO azb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","bənövşəyi, tünd qırmızı və al rəngli iplik, incə kətan, keçi yunu, ");
INSERT INTO azb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","qırmızı boyanmış qoç dəriləri, suiti dəriləri, əbrişim ağacı, ");
INSERT INTO azb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","çıraq üçün zeytun yağı, məsh yağı və ətirli buxur üçün ətriyyatlar, ");
INSERT INTO azb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","efodla döşlüyün üstünə taxılan damarlı əqiq və sağanaq daşları. ");
INSERT INTO azb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Aranızdakı ürəyi hikmətlə dolu hər adam gəlib Rəbbin əmr etdiyi hər şeyi düzəltsin: ");
INSERT INTO azb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","müqəddəs məskəni, onun çadırını, örtüyünü, bəndlərini, çərçivələrini, şüvüllərini, dirəklərini və altlıqlarını; ");
INSERT INTO azb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sandığı və onun şüvüllərini; kəffarə qapağını, arakəsmə pərdəsini; ");
INSERT INTO azb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","masanı, onun şüvüllərini və bütün ləvazimatını; təqdis çörəklərini; ");
INSERT INTO azb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","işıq verən çıraqdanı, onun ləvazimatını, çıraqlarını və işıq yağını; ");
INSERT INTO azb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","buxur qurbangahını və şüvüllərini; məsh yağını, ətirli buxuru; məskənin girişi üçün arakəsməni; ");
INSERT INTO azb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","yandırma qurbanları üçün qurulan qurbangahı, onun üçün tunc şəbəkəni, şüvüllərini və bütün avadanlığını; ləyəni və onun altlığını; ");
INSERT INTO azb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","həyətin pərdələrini, dirəklərini və altlıqlarını; həyətin darvazası üçün arakəsməni; ");
INSERT INTO azb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","məskənin payalarını; həyətin payalarını; onların iplərini; ");
INSERT INTO azb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","müqəddəs yerdə xidmət üçün toxunmuş geyimləri: kahin Harunun müqəddəs geyimlərini və oğullarının kahinlik etmək üçün geyimlərini». ");
INSERT INTO azb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","İsrail övladlarının bütün icması Musanın yanından çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ürəyinə toxunan və könlü istəyən hər adam gəlib Hüzur çadırı, onun inşası və müqəddəs geyimlər üçün Rəbbə ianə gətirdi. ");
INSERT INTO azb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Kişilər və qadınlar – könlü istəyənlərin hamısı bəzəkli sancaqlar, sırğalar, üzüklər, bilərziklər kimi bütün qızıl əşyalarını gətirdilər. Hər kəs qızılı yellətmə təqdimi kimi Rəbbə təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kimdə bənövşəyi, tünd qırmızı və al rəngli iplik, incə kətan, keçi yunu, qırmızı boyanmış qoç dəriləri və suiti dəriləri var idisə, bunları təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Gümüş və tunc gətirən hər kəs də onu Rəbbə ianə olaraq təqdim etdi. Kimdə əbrişim ağacı var idisə, onu bütün inşa işi üçün təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ürəyi hikmətlə dolu bütün qadınlar öz əlləri ilə əyirdiyi bənövşəyi, tünd qırmızı və al rəngli iplik və incə kətan ipliyi təqdim etdilər; ");
INSERT INTO azb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","bu işi ürəkdən görmək istəyən bacarıqlı qadınlar keçi yunu əyirdilər. ");
INSERT INTO azb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Xalqın başçıları bunları təqdim etdilər: efodla döşlüyün üstünə taxılan damarlı əqiq və sağanaq daşlarını, ");
INSERT INTO azb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","çıraq, məsh yağı, ətirli buxur üçün ətriyyatı və zeytun yağını. ");
INSERT INTO azb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","İsrail övladlarından hər kişi, hər qadın Rəbbin Musa vasitəsilə yerinə yetirmək üçün verdiyi əmrə əsasən Rəbbə könüllü təqdimlər gətirdilər. ");
INSERT INTO azb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa İsrail övladlarına dedi: «Baxın Rəbb Yəhuda qəbiləsindən Xur oğlu Uri oğlu Besaleli adı ilə çağırıb ");
INSERT INTO azb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Allahın Ruhu ilə hikmət, dərrakə, bilik və hər cür məharətlə doldurmuşdur ki, ");
INSERT INTO azb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","o, qızılla, gümüşlə, tuncla işləməyi bacarsın, ");
INSERT INTO azb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","daş-qaş yonsun, ağac oysun, hər cür məharətlə bacarıq göstərə bilsin. ");
INSERT INTO azb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Rəbb onun və Dan qəbiləsindən olan Axisamak oğlu Oholiavın ürəklərinə başqalarını öyrətmək bacarığını qoymuş, ");
INSERT INTO azb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ürəklərini hikmətlə doldurmuşdur ki, oymaçılıq, naxışçılıq, bənövşəyi, tünd qırmızı və al rəngli iplikdə və incə kətanda naxış tikməsi, toxuculuq – hər cür sənəti bacara bilsinlər. ");
INSERT INTO azb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besalel, Oholiav və bütün ürəkləri hikmətlə dolu, Rəbbin onlara bu işi bacarmaq üçün hikmət və dərrakə verdiyi adamlar Rəbbin etdiyi hər şeyə görə müqəddəs yerin inşa işini görsünlər». ");
INSERT INTO azb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa Besaleli, Oholiavı və bütün ürəkləri hikmətlə dolu – Rəbbin onların ürəklərinə hikmət qoyduğu adamları, bu işi ürəkdən görmək istəyənlərin hamısını çağırdı. ");
INSERT INTO azb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Onlar müqəddəs yerin inşa işini görmək üçün İsrail övladlarının gətirdiyi bütün ianələri Musanın yanından götürdülər. İsrail övladları hər səhər könüllü təqdimlər gətirməyə davam edirdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Onda müqəddəs yerin inşası ilə məşğul olan hikmətli sənətkarlar hər işlərindən ayrılaraq ");
INSERT INTO azb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Musanın yanına gəlib dedilər: «Xalq Rəbbin əmr etdiyi inşa işi üçün lazım olandan çox şey gətirir». ");
INSERT INTO azb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musa əmr verdi və düşərgədə elan etdirdi ki, nə kişi, nə də qadın müqəddəs yer üçün daha ianə gətirməsin. Beləcə xalq bir daha ianə gətirmədi. ");
INSERT INTO azb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Çünki bütün işi görmək üçün xammal lazımi miqdardan artıq idi. ");
INSERT INTO azb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","İşi görmək üçün ürəkləri hikmətlə dolu bütün adamlar müqəddəs məskəni on pərdədən düzəltdilər. Pərdələri nəfis toxunmuş incə kətandan bənövşəyi, tünd qırmızı və al rəngli iplikdən, üstünü isə keruvlar şəklində naxışla düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Hər pərdənin uzunluğu iyirmi səkkiz qulac, eni isə dörd qulac idi. Bütün pərdələr eyni ölçüdə idi. ");
INSERT INTO azb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pərdənin beşini də bir-birinə birləşdirdilər. Digər beşini də bir-birinə birləşdirdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Bir birləşmənin qıraq pərdəsinin kənarında bənövşəyi ilgəklər düzəltdilər; o biri birləşmənin qıraq pərdəsinin kənarında da eyni şəkildə ilgəklər düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Bir pərdəyə əlli ilgək, o biri birləşmədəki pərdənin kənarında da onlara uyğun gələn əlli ilgək düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Qızıldan əlli bənd düzəltdilər. Bəndlərlə pərdələri bərkitdilər və çadırı birləşdirdilər. Beləliklə, müqəddəs məskən bütöv oldu. ");
INSERT INTO azb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Məskəni örtən çadır üçün keçi yunundan on bir ədəd pərdə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Hər pərdənin uzunluğu otuz qulac, eni isə dörd qulac idi. On bir pərdə bir ölçüdə idi. ");
INSERT INTO azb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Beş pərdəni ayrıca, altı pərdəni də ayrıca bitişdirdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Bir birləşmənin qıraq pərdəsinin kənarındakı kimi o biri birləşmənin qıraq pərdəsinin kənarında da əlli ilgək düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Çadırı birləşdirib bütöv etmək üçün tuncdan əlli bənd düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Çadır üçün qırmızı boyanmış qoç dərilərindən bir pərdə və onun üstündə suiti dərilərindən bir pərdə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Müqəddəs məskən üçün əbrişim ağacından dik duran çərçivələr düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Hər çərçivənin uzunluğu on qulac, eni isə qulac yarım idi. ");
INSERT INTO azb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Hər çərçivənin üstündə iki bir-birinə bağlanan zivana var idi; məskənin bütün çərçivələrini belə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Məskənin cənub tərəfi üçün iyirmi çərçivə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Onların altına qoyulmaq üçün hər çərçivənin altındakı iki zivana üçün iki altlıq düzəltdilər; beləcə qırx gümüş altlıq düzəldildi. ");
INSERT INTO azb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Məskənin şimal tərəfi üçün də iyirmi çərçivə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Hər çərçivənin altında iki altlıq olmaqla qırx gümüş altlıq düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Məskənin qərbə doğru arxası üçün altı çərçivə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Məskənin arxa küncləri üçün isə iki çərçivə düzəltdilər; ");
INSERT INTO azb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","bunlar aşağıda birləşib yuxarıda bir halqaya taxıldı; hər iki künc üçün o cür iki çərçivə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Bu səkkiz çərçivə üçün on altı gümüş altlıq, hər çərçivənin altında iki altlıq düzəldildi. ");
INSERT INTO azb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Əbrişim ağacından şüvüllər düzəltdilər: məskənin hər iki tərəfdəki çərçivələri üçün beş şüvül, ");
INSERT INTO azb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","məskənin qərbə doğru arxa çərçivələri üçün də beş şüvül düzəldildi. ");
INSERT INTO azb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Çərçivələrin ortasında bir ucdan o biri uca qədər uzanan orta şüvül düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Çərçivələri qızılla örtdülər; şüvüllərin keçdiyi halqaları qızıldan düzəltdilər; şüvülləri də qızılla örtdülər. ");
INSERT INTO azb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Pərdəni bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan, üstünü isə keruvlar şəklində naxışla düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Onun üçün əbrişim ağacından dörd dirək düzəltdilər və onları qızılla örtdülər, üstündə qızıl qarmaqları qoydular; onlar üçün dörd gümüş altlıq tökdülər. ");
INSERT INTO azb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Çadırın girişi üçün arakəsməni bənövşəyi, tünd qırmızı və al rəngli iplikdən və nəfis toxunmuş incə kətandan naxış tikməsi ilə düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Onun beş dirək və qarmaqlarını da düzəltdilər. Yuxarılarını və bəndlərini qızılla örtdülər; beş altlığı isə tuncdan düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalel əbrişim ağacından sandıq düzəltdi. Sandığın uzunluğu iki qulac yarım, eni qulac yarım və hündürlüyü qulac yarım idi. ");
INSERT INTO azb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Onu içəridən və bayırdan xalis qızılla örtdü, ətrafına isə qızıl zolaq qoydu. ");
INSERT INTO azb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Onun dörd ayağı üçün dörd tökmə qızıl halqa, iki halqanı bir yanı, qalan iki halqanı isə o biri yanı üçün düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Əbrişim ağacından şüvüllər düzəldib üzərini qızılla örtdü. ");
INSERT INTO azb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Sandığı daşımaq üçün şüvülləri sandığın yanlarındakı halqalara keçirtdi. ");
INSERT INTO azb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Xalis qızıldan kəffarə qapağını düzəltdi. Uzunluğu iki qulac yarım, eni isə qulac yarım idi. ");
INSERT INTO azb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Kəffarə qapağının hər iki ucu üçün yastılanmış qızıldan iki keruv düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Bir keruv qapağın bir ucunda, o birisi isə o biri ucunda olaraq qapağın iki ucunda olan keruvlar onunla bir hissədən idi. ");
INSERT INTO azb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Keruvlar yuxarıya açılmış qanadları ilə kəffarə qapağını örtdülər. Keruvların üzləri bir-birinə qarşı qapağa doğru idi. ");
INSERT INTO azb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Əbrişim ağacından masa düzəltdi; uzunluğu iki qulac, eni bir qulac, hündürlüyü isə qulac yarım idi. ");
INSERT INTO azb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Onu xalis qızılla örtdü. Ətrafına qızıl zolaq qoydu. ");
INSERT INTO azb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ətrafında eni bir ovuc olan yan lövhələr düzəltdi. Yan lövhələrin ətrafına da qızıl zolaq qoydu. ");
INSERT INTO azb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Masa üçün dörd qızıl halqa tökdü, halqaları onun dörd küncünə, dörd ayağına bərkitdi. ");
INSERT INTO azb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Halqalar yan lövhələrə yaxın olaraq masanı aparan şüvüllərin keçdiyi yerlər idi. ");
INSERT INTO azb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Masanı aparmaq üçün şüvülləri əbrişim ağacından düzəltdi və onları qızılla örtdü. ");
INSERT INTO azb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Masanın ləvazimatını – xalis qızıldan siniləri və nimçələri, piyalələri və içmə təqdimlərini tökmək üçün dolçaları düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Xalis qızıldan bir çıraqdan düzəltdi. Bu çıraqdan yastılanmış qızıldan idi; altlığı, gövdəsi, kasacıqları, qönçələri və gülləri onunla bir hissədən ibarət idi. ");
INSERT INTO azb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Çıraqdanın yanlarından altı budaq – bir yanından üç budaq, o biri yanından da üç budaq çıxdı. ");
INSERT INTO azb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Hər bir budağında badam çiçəyinə bənzər üç kasacıq, qönçə və gül var idi. ");
INSERT INTO azb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Çıraqdanın gövdəsində isə badam çiçəyinə bənzər dörd kasacıq, qönçə və gül var idi. ");
INSERT INTO azb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Çıraqdanın gövdəsindən çıxan altı budağın bir cütünün altında bir qönçə, o biri cütünün altında bir qönçə, o birinin də altında bir qönçə var idi. ");
INSERT INTO azb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Qönçələr və budaqlar onunla bir hissədən idi; hamısı eyni hissədən, yastılanmış xalis qızıldan idi. ");
INSERT INTO azb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Onun üçün yeddi çıraq düzəltdi. Maşaları və xəkəndazları da xalis qızıldan idi. ");
INSERT INTO azb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Çıraqdanı və onun bütün avadanlığını bir talant xalis qızıldan düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Əbrişim ağacından buxur yandırmaq üçün qurbangah düzəltdi; uzunluğu bir qulac, eni də bir qulac, hündürlüyü isə iki qulac idi. Buynuzları onunla bir hissədən idi. ");
INSERT INTO azb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Onun üzərini, hər yanını və buynuzlarını xalis qızılla örtdü, ətrafına qızıl zolaq qoydu. ");
INSERT INTO azb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Onun üçün iki qızıl halqa düzəltdi; qarşı-qarşıya olan iki yanda, zolağın altında düzəltdi. Bu onu aparan şüvüllərin keçdiyi yerlər idi. ");
INSERT INTO azb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Şüvülləri əbrişim ağacından düzəltdi və onları qızılla örtdü. ");
INSERT INTO azb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ətriyyatçının işi olan Müqəddəs məsh yağını və təmiz ətirli buxuru da hazırladı. ");
INSERT INTO azb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Yandırma qurbanı üçün qurulan qurbangahı əbrişim ağacından düzəltdi. Dördbucaq şəklində olub uzunluğu beş qulac, eni də beş qulac, hündürlüyü isə üç qulac idi. ");
INSERT INTO azb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Qurbangahın dörd küncündə onunla bir hissədən olan dörd buynuz düzəltdi. Qurbangahın üstünü tuncla örtdü. ");
INSERT INTO azb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Qurbangahın bütün avadanlığını – kül qablarını, kürəkləri, ləyənləri, çəngəlləri və xəkəndazları – hər şeyi tuncdan düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Qurbangah üçün kənarından aşağıya onun yarısına qədər yetişəcək torlu şəbəkəni tuncdan düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Tunc şəbəkənin dörd bucağında şüvüllərin keçdiyi dörd halqanı tökdü. ");
INSERT INTO azb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Əbrişim ağacından şüvüllər düzəldib üstünü tuncla örtdü. ");
INSERT INTO azb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Qurbangahı aparmaq üçün şüvülləri onun hər iki yanındakı halqalara taxdı. Qurbangahın içi boş və taxtadan idi. ");
INSERT INTO azb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Tunc ləyəni və onun tunc altlığını Hüzur çadırının girişində xidmət edən qadınların güzgülərindən düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Müqəddəs məskənin həyətini düzəltdi. Həyətin cənub tərəfində uzunluğu yüz qulac olan pərdələr nəfis toxunmuş incə kətandan idi. ");
INSERT INTO azb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Onların iyirmi dirəyi və iyirmi altlığı tuncdan, dirəklərin qarmaqları və bəndləri isə gümüşdən idi. ");
INSERT INTO azb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Şimal tərəfində də uzunluğu yüz qulac pərdə idi; onların iyirmi dirəyi və iyirmi altlığı tuncdan, dirəklərin qarmaqları və bəndləri isə gümüşdən idi. ");
INSERT INTO azb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Qərb tərəfində uzunluğu əlli qulac pərdələr idi. Onların on dirəyi və on altlığı var idi. Dirəklərin qarmaqları və bəndləri isə gümüşdən idi. ");
INSERT INTO azb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Şərq tərəfində də həyətin eni əlli qulac idi. ");
INSERT INTO azb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Darvazanın bir tərəfində üç dirəyi və üç altlığı olan uzunluğu on beş qulac pərdələr var idi. ");
INSERT INTO azb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Həyətin darvazasının o biri tərəfində də üç dirəyi və üç altlığı olan uzunluğu on beş qulac pərdələr var idi. ");
INSERT INTO azb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Həyətin bütün ətraf pərdələri nəfis toxunmuş incə kətandan, ");
INSERT INTO azb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","dirəklərin altlıqları tuncdan, dirəklərin qarmaqları və bəndləri gümüşdən, başlıqların örtüyü də gümüşdən idi; həyətin bütün dirəkləri gümüşlə bəndləndi. ");
INSERT INTO azb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Həyətin darvazasının naxış tikməli arakəsməsi bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan idi; uzunluğu iyirmi qulac, hündürlüyü isə həyətin pərdələri kimi beş qulac idi. ");
INSERT INTO azb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Onun dörd dirəyi, dörd tunc altlığı, gümüş qarmaqları, başlıqlarının gümüş örtüyü və bəndləri var idi. ");
INSERT INTO azb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Məskənin və həyətin bütün ətraf payaları tuncdan idi. ");
INSERT INTO azb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Musanın əmri ilə kahin Harunun oğlu İtamarın başçılığı ilə Levililərin xidmət göstərib apardığı məkanın – Şəhadət məskəninin hesabatı budur. ");
INSERT INTO azb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yəhuda qəbiləsindən Xur oğlu Uri oğlu Besalel Rəbbin Musaya əmr etdiyi hər şeyi düzəltdi. ");
INSERT INTO azb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Onunla çalışan Dan qəbiləsindən olan Axisamak oğlu Oholiav oymaçılıq, naxışçılıq, bənövşəyi, tünd qırmızı və al rəngli iplikdə və incə kətanda naxış tikməsi işini bacarırdı. ");
INSERT INTO azb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Müqəddəs yerin bütün inşası üçün işlənən qızılın, ianə verilən qızılın ümumi çəkisi Müqəddəs yerdəki şekelə görə iyirmi doqquz talant yeddi yüz otuz şekel idi. ");
INSERT INTO azb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Siyahıya alınan icmanın verdiyi gümüşün çəkisi Müqəddəs yerdəki şekelə görə yüz talant və min yeddi yüz yetmiş beş şekel idi. ");
INSERT INTO azb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Bu, sayılmış adamlara daxil olan hər kəs, iyirmi yaşında və ondan yuxarı olan altı yüz üç min beş yüz əlli kişi üçün adambaşı bir beqa, yəni Müqəddəs yerdəki şekelə görə yarım şekel idi. ");
INSERT INTO azb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Müqəddəs yerin altlıqlarını və pərdələrin altlıqlarını tökmək işinə yüz talant gümüş yüz altlıq üçün yüz talant, yəni hər altlıq üçün bir talant gümüş işləndi. ");
INSERT INTO azb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Min yeddi yüz yetmiş beş şekel gümüş isə dirəklər üçün qarmaqlar düzəltmək, başlıqlarını örtmək və onları bəndləmək üçün işləndi. ");
INSERT INTO azb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","İanə verilən tuncun çəkisi yetmiş talant və iki min dörd yüz şekel idi. ");
INSERT INTO azb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ondan Hüzur çadırı girişinin altlıqları, tunc qurbangah, oradakı tunc şəbəkəni, qurbangahın bütün avadanlığı, ");
INSERT INTO azb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","həyətin ətraf altlıqları, həyətin darvazasının altlıqları, məskənin bütün payaları və həyətin bütün ətraf payaları düzəldildi. ");
INSERT INTO azb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Rəbb Musaya əmr etdiyi kimi bənövşəyi, tünd qırmızı və al rəngli iplikdən Müqəddəs yerdə xidmət üçün toxunmuş geyimlərini və Harunun müqəddəs geyimlərini hazırladılar. ");
INSERT INTO azb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Efodu qızıldan, bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan hazırladılar. ");
INSERT INTO azb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Qızıl lövhələri döyüb onlardan saplar kəsdilər və onlarla bənövşəyi, tünd qırmızı və al rəngli iplik və nəfis toxunmuş kətanın arasına naxışlar tikdilər. ");
INSERT INTO azb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Hər iki ucunu bir-birinə bağlayan çiyinlik düzəltdilər ki, o bərkidilsin. ");
INSERT INTO azb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Efodun üstündəki kəmər eyni hissədən idi. O da qızıldan, bənövşəyi, tünd qırmızı və al rəngli iplik və nəfis toxunmuş incə kətandan idi. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Hörmə qızıl sağanaqlara salınıb üstündə möhür oyması kimi İsrailin oğullarının adları həkk olunmuş damarlı əqiq daşlarını ");
INSERT INTO azb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","efodun çiyinliklərinə taxdılar. Bunlar İsrailin oğullarının xatirə daşlarıdır. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Döşlüyü də efod kimi naxışlı qızıldan, bənövşəyi, tünd qırmızı, al rəngli iplikdən və nəfis toxunmuş incə kətandan düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Döşlük ikiqat, dördbucaq şəklində olub uzunluğu bir qarış, eni də bir qarış düzəldildi. ");
INSERT INTO azb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Üstünə dörd sıra daş taxdılar. Birinci sıra yaqut, topaz, zümrüd; ");
INSERT INTO azb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ikinci sıra firuzə, göy yaqut və almaz; ");
INSERT INTO azb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","üçüncü sıra sirkon, əqiq və ametist; ");
INSERT INTO azb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","dördüncü sıra sarı yaqut, damarlı əqiq və yəşəm daşı idi. Bu daşlar hörmə qızıl sağanaqlara salındı. ");
INSERT INTO azb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Daşlar İsrailin oğullarının adlarına görə on iki dənə idi; hər daş on iki qəbilədən birinin adının oyma möhürü idi. ");
INSERT INTO azb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Döşlük üçün xalis qızıldan ipəbənzər burma zəncirlər qayırdılar. ");
INSERT INTO azb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","İki hörmə qızıl sağanaq və iki qızıl halqa düzəltdilər. Halqaları döşlüyün iki ucuna taxdılar. ");
INSERT INTO azb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","İki qızıl ipi döşlüyün uclarındakı iki halqaya taxdılar. ");
INSERT INTO azb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","İplərin o biri uclarını iki hörmə sağanağa taxıb efodun çiyinliklərinin qabaq tərəfinə bağladılar. ");
INSERT INTO azb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Yenə də iki qızıl halqa düzəldib onları döşlüyün iki ucuna, onun efodla yanaşı iç qatına taxdılar. ");
INSERT INTO azb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Digər iki qızıl halqa düzəltdilər və onu efodun çiyinliklərinin qabaq tərəfinə, aşağıya, efodun kəməri ilə birləşmələrin üzərinə bərkitdilər. ");
INSERT INTO azb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Döşlüyü halqaları ilə efodun halqalarına bənövşəyi qaytanla bağlayıb efodun kəmərinin üzərinə bərkitdilər ki, döşlük efoddan sallanmasın. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Efodun cübbəsini büsbütün toxunma bənövşəyi iplikdən tikdilər. ");
INSERT INTO azb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Onun ortasında baş keçirmək üçün yer tikdilər. Onun kənarında cırılmamaq üçün yaxa toxudular. ");
INSERT INTO azb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Cübbənin ətəyinin ətrafına nəfis toxunmuş bənövşəyi, tünd qırmızı və al rəngli iplikdən narlar düzdülər. ");
INSERT INTO azb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Xalis qızıl zınqırovlar düzəldib, cübbənin ətəyi boyunca narların arasına tikdilər. ");
INSERT INTO azb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Beləcə xidmət cübbəsinin ətəyi boyunca ətrafında zınqırov və nar sıra ilə düzüldü. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Harun və oğulları üçün toxunma incə kətan xirqələri, ");
INSERT INTO azb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","nəfis toxunmuş incə kətandan çalma, incə kətan papaqları, əyirmə incə kətan alt paltarı, ");
INSERT INTO azb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","nəfis toxunmuş incə kətan və bənövşəyi, tünd qırmızı və al rəngli iplikdən naxış tikməli qurşağı tikdilər. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Xalis qızıldan müqəddəslik tacı olan lövhəciyi düzəltdilər və onun üzərinə möhür oyması olaraq «Rəbbə həsr edilmiş» yazısını yazdılar. ");
INSERT INTO azb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Onu çalmanın üstünə qoymaq üçün bənövşəyi qaytan tikdilər. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Beləliklə, müqəddəs məskən, yəni Hüzur çadırı üçün bütün işlər tamamlandı. Rəbb Musaya necə əmr etmişdisə, İsrail övladları da bu işi eləcə tamamladılar. ");
INSERT INTO azb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Müqəddəs məskəni Musanın qarşısına gətirdilər. Çadırını və onun avadanlığını, bəndlərini, çərçivələrini, şüvüllərini, dirəklərini, altlıqlarını, ");
INSERT INTO azb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","qırmızı boyanmış qoç dərilərindən örtüyü, suiti dərilərdən düzəldilmiş örtüyü, arakəsmə pərdəsini, ");
INSERT INTO azb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Şəhadət sandığını və onun şüvüllərini, kəffarə qapağını, ");
INSERT INTO azb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","masanı və onun ləvazimatını; təqdis çörəklərini, ");
INSERT INTO azb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","xalis qızıldan çıraqdanı, onun düzülmüş çıraqlarını və işıq yağını, ");
INSERT INTO azb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","qızıl qurbangahını, məsh yağını, ətirli buxuru, çadırın giriş arakəsməsini, ");
INSERT INTO azb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","tunc qurbangahını, onun üçün tunc şəbəkəni, onun şüvüllərini və bütün avadanlığını, ləyəni və onun altlığını, ");
INSERT INTO azb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","həyətin pərdələrini, dirəklərini və altlıqlarını, həyətin darvazası üçün arakəsməni, onun iplərini və payalarını – Hüzur çadırı və məskənin ibadəti üçün bütün əşyaları, ");
INSERT INTO azb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","müqəddəs yerdə xidmət üçün toxunmuş geyimləri – kahin Harunun müqəddəs geyimlərini və oğullarının kahinlik etmək üçün geyimlərini – hər şeyi ona gətirdilər. ");
INSERT INTO azb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Rəbb Musaya necə əmr etmişdisə, İsrail övladları da bu işi eləcə tamamladılar. ");
INSERT INTO azb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa bütün işləri nəzərdən keçirib gördü ki, onlar bu işə Rəbbin əmr etdiyi kimi əməl ediblər. Musa onlara xeyir-dua verdi. ");
INSERT INTO azb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Birinci ayın birinci günü müqəddəs məskəni, yəni Hüzur çadırını qur. ");
INSERT INTO azb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Şəhadət sandığını oraya qoy və pərdə ilə qabağını kəs. ");
INSERT INTO azb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Sonra masanı gətir, üstünə əşyaları düz. Çıraqdanı gətir, çıraqları da quraşdır. ");
INSERT INTO azb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Buxur üçün qızıl qurbangahı Şəhadət sandığının qabağına qoy. Məskənin giriş arakəsməsini də qur. ");
INSERT INTO azb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Yandırma qurbanları üçün qurulan qurbangahı məskənin – Hüzur çadırının girişinin qarşısında yerləşdir. ");
INSERT INTO azb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ləyəni Hüzur çadırı ilə qurbangahın arasına qoy, içinə su tök. ");
INSERT INTO azb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ətrafında həyət qur və həyətin darvazasının arakəsməsini as. ");
INSERT INTO azb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Sonra məsh yağını götürüb məskəni və içindəki hər şeyi məsh et. Beləliklə, onu və bütün avadanlığını təqdis et ki, müqəddəs olsun. ");
INSERT INTO azb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Yandırma qurbanlar üçün qurulan qurbangahı, onun avadanlığını məsh edib qurbangahı təqdis et ki, o ən müqəddəs olsun. ");
INSERT INTO azb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ləyənlə altlığını məsh edib təqdis et. ");
INSERT INTO azb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Harunla oğullarını Hüzur çadırının girişinə gətirib onları su ilə yuyundur. ");
INSERT INTO azb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Haruna müqəddəs geyimlər geyindir. Onu məsh edib təqdis et ki, Mənə kahinlik etsin. ");
INSERT INTO azb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Sonra Harunun oğullarını təqdim et və onlara xirqələr geyindir. ");
INSERT INTO azb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Atalarını məsh etdiyin kimi onları da məsh et ki, Mənə kahinlik etsinlər. Onlar nəsildən-nəslə əbədi kahinlik üçün məsh olunacaqlar». ");
INSERT INTO azb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Rəbb Musaya necə əmr etmişdisə, o da bu cür etdi. ");
INSERT INTO azb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","İsrail övladlarının Misirdən çıxdığı vaxtın ikinci ilində, birinci ayın birinci günündə məskən quruldu. ");
INSERT INTO azb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa çadırı qurdu: altlıqlarını qoydu, taxtalarını bərkitdi, şüvüllərini qurdu və dirəklərini dikəltdi. ");
INSERT INTO azb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Məskənin üzərinə çadır saldı, onun üstünə də çadırın örtüyünü qoydu. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Bundan sonra o, şəhadət lövhələrini götürüb sandığın içinə qoydu. Şüvülləri sandığa taxdı, kəffarə qapağını da sandığın üstünə qoydu. ");
INSERT INTO azb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Sandığı məskənin içinə gətirdi və arakəsmə pərdəsini qurub Şəhadət sandığının qabağını kəsdi. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Masanı Hüzur çadırının içində, şimal tərəfində, pərdənin bayır tərəfindən yerləşdirdi. ");
INSERT INTO azb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Onun üstünə Rəbbin hüzurunda çörək düzdü. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Çıraqdanı isə Hüzur çadırının içində, masanın qarşısında, məskənin cənub tərəfində yerləşdirdi. ");
INSERT INTO azb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Çıraqlarını da Rəbbin hüzurunda quraşdırdı. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Qızıl qurbangahı da Hüzur çadırının içində, pərdənin önündə yerləşdirdi; ");
INSERT INTO azb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","onun üstündə ətirli buxur yandırdı. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Məskənin girişində arakəsməni qurdu. ");
INSERT INTO azb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Yandırma qurbanları üçün qurulan qurbangahı məskənin, Hüzur çadırının girişində yerləşdirdi; onun üstündə yandırma qurbanını və taxıl təqdimini gətirdi. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ləyəni Hüzur çadırı ilə qurbangah arasında yerləşdirib içinə yuyunmaq üçün su tökdü. ");
INSERT INTO azb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa, Harun və oğulları orada əl-ayaqlarını yuyardılar. ");
INSERT INTO azb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Onlar Hüzur çadırına girdikləri və qurbangaha yaxınlaşdıqları zaman yuyunardılar. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Məskənlə qurbangahın ətrafında həyəti qurdu və həyət darvazasının arakəsməsini asdı. Beləliklə, Musa işləri bitirdi. ");
INSERT INTO azb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","O vaxt bulud Hüzur çadırını bürüdü və Rəbbin izzəti məskəni doldurdu. ");
INSERT INTO azb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa Hüzur çadırına girə bilmədi, çünki bulud onun üstündə yerləşmişdi və Rəbbin izzəti məskəni doldurmuşdu. ");
INSERT INTO azb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","İsrail övladlarının bütün səfəri boyu bulud məskənin üstündən qalxanda yola düşərdilər; ");
INSERT INTO azb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","bulud qalxmayanda isə, qalxdığı günə qədər yola düşməzdilər. ");
INSERT INTO azb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Səfərləri boyu bütün İsrail xalqının gözləri önündə gündüz Rəbbin buludu məskənin üzərində, gecələr isə od buludun içində idi. ");
INSERT INTO azb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Rəbb Musanı Hüzur çadırından çağırıb belə dedi: ");
INSERT INTO azb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«İsrail övladlarına bəyan et və de: “Sizdən bir nəfər öz heyvanlarından Rəbbə qurban gətirəndə qoy qurbanlığı mal-qara yaxud qoyun-keçi olsun. ");
INSERT INTO azb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Əgər qurbanı bir baş mal-qaradan ibarət yandırma qurbanıdırsa, bu qüsursuz erkək heyvan olsun. Bu qurbanın Rəbbin hüzurunda məqbul olması üçün onu gətirən adam onu Hüzur çadırının girişinə gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","O adam əlini yandırma qurbanının başına qoysun ki, qurban özü üçün kəffarə kimi qəbul olunsun. ");
INSERT INTO azb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","O, buğanı Rəbbin önündə kəssin. Harun nəslindən olan kahinlər qanı təqdim edərək Hüzur çadırının girişi yanındakı qurbangahın hər tərəfinə səpsinlər. ");
INSERT INTO azb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Sonra o adam yandırma qurbanının dərisini soyub qurbanı parça-parça doğrasın. ");
INSERT INTO azb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kahin Harunun övladları qurbangahda od qalayıb üstünə odun düzsünlər. ");
INSERT INTO azb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Harun nəslindən olan kahinlər buğanın başını və piyini parça-parça doğranmış hissələrlə birlikdə qurbangahın odunları ilə qalanan od üstünə düzsünlər. ");
INSERT INTO azb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Qurbanın içalatı və budlarını isə o adam su ilə yusun. Kahin bunların hamısını qurbangahda tüstülədib yandırsın. Bu, yandırma qurbanı, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Əgər kiminsə yandırma qurbanı qoyun-keçidən ibarətdirsə, qoy bu qüsursuz erkək heyvan olsun. ");
INSERT INTO azb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Onu qurbangahın şimal tərəfində, Rəbbin önündə kəssin; Harun nəslindən olan kahinlər isə heyvanın qanını qurbangahın hər tərəfinə səpsinlər. ");
INSERT INTO azb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Sonra o adam heyvanı parça-parça doğrasın, başını və piyini kəssin; xidmət edən kahin də qurbanı qurbangahın odunları ilə qalanan od üstünə düzsün. ");
INSERT INTO azb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","İçalatı və budları isə o adam su ilə yusun. Kahin bunların hamısını təqdim edib qurbangahda tüstülədib yandırsın. Bu, yandırma qurbanı, Rəbbin xoşuna gələn ətirli təqdimdir. ");
INSERT INTO azb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Əgər kiminsə Rəbbə yandırma qurbanı quşdan ibarətdirsə, qoy qumru quşlarından yaxud göyərçinlərdən qurban gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kahin onu qurbangaha gətirsin, boynunu üzüb başını qurbangahda tüstülədib yandırsın; qanı isə qurbangahın yan tərəfindən axıdılsın. ");
INSERT INTO azb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kahin quşun çinədanını lələkləri ilə çıxarıb qurbangahın şərq tərəfinə, küllüyə atsın. ");
INSERT INTO azb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Sonra o, qanadlarını tutaraq quşu yırtsın, amma iki yerə bölməsin. Bundan sonra kahin quşu qurbangahda odunla qalanan od üstündə tüstülədib yandırsın. Bu, yandırma qurbanı, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kimsə Rəbbə taxıl təqdimi gətirərsə, təqdimi narın un olsun, üstünə də zeytun yağı töküb kündür qoysun. ");
INSERT INTO azb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Onu Harun nəslindən olan kahinlərə gətirsin. Sonra isə kahin bir ovuc unla yağ və kündürün hamısını götürərək qurbangahda xatirə təqdimi kimi tüstülədib yandırsın. Bu, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Taxıl təqdiminin qalan hissəsi isə Harunla övladlarına məxsus olsun. Bu, Rəbb üçün verilən yandırma təqdimindən götürüldüyünə görə ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Təndirdə bişirilmiş taxıl təqdimi gətirəndə zeytun yağı ilə narın undan yoğrulmuş mayasız kökələr və üstünə zeytun yağı sürtülmüş mayasız qoğallar təqdim et. ");
INSERT INTO azb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Əgər təqdimin sacda bişmiş taxıl təqdimidirsə, onu narın undan, zeytun yağı ilə yoğrulmuş mayasız kökə kimi bişir. ");
INSERT INTO azb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Onu ov və üstünə zeytun yağı tök. Bu, taxıl təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Əgər təqdimin tavada bişən taxıl təqdimidirsə, onu narın undan zeytun yağı ilə hazırla. ");
INSERT INTO azb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bu üsullarla hazırlanan taxıl təqdimini Rəbbin yanına gətir və kahinə təqdim et. O da təqdimini qurbangaha aparsın. ");
INSERT INTO azb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kahin bu təqdimdən xatirə təqdimi kimi pay götürərək qurbangahda tüstülədib yandırsın. Bu, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Taxıl təqdiminin qalan hissəsi isə Harunla övladlarına məxsus olsun. Bu, Rəbb üçün verilən yandırma təqdimindən götürüldüyü üçün ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Rəbbə gətirilən heç bir taxıl təqdimi mayalı xəmirdən hazırlanmasın. Tərkibində ya maya ya da bal olan təqdim Rəbb üçün yandırma təqdimi kimi tüstülədilib yandırılmasın. ");
INSERT INTO azb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Bunları ilk məhsul təqdimləri kimi Rəbbin yanına gətirin. Amma xoşa gələn ətir kimi qurbangahda təqdim olunmasın. ");
INSERT INTO azb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Taxıl təqdimlərinin hər birini duzla, onlardan Allahınla əhdinin duzunu əsirgəmə. Bütün təqdimlərini duzla. ");
INSERT INTO azb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Əgər sən Rəbbə nübarından taxıl təqdimini gətirsən, onda təzə taxılı odda qovurub yarmasını təqdim et. ");
INSERT INTO azb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Onun üstünə zeytun yağı və kündür qoy. Bu, taxıl təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kahin bir az yarma və zeytun yağı götürərək bütün kündürlə xatirə təqdimi kimi tüstülədib yandırsın. Bu, Rəbb üçün verilən yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Əgər kimsə ünsiyyət qurbanı gətirsə və qurbanlıq heyvan mal-qaradandırsa, qoy o, Rəbbin hüzuruna qüsursuz erkək və ya dişi heyvan gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Qoy adam əlini qurbanlığın başına qoyub Hüzur çadırının girişində kəssin və Harun nəslindən olan kahinlər qanı qurbangahın hər tərəfinə səpsinlər. ");
INSERT INTO azb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Qoy o adam ünsiyyət qurbanından bunları Rəbb üçün yandırma təqdimi kimi gətirsin: içalatı örtən piyi və üstündəki piyi, ");
INSERT INTO azb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","belindəki hər iki böyrəyi, üstündəki piyi və qaraciyərin quyruğa bənzər hissəsini – bunları böyrəkləri ilə birgə çıxartsın. ");
INSERT INTO azb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Bunları Harun övladları qurbangahda odunlarla qalanan od üstündəki yandırma qurbanı ilə tüstülədib yandırsınlar. Bu, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Əgər Rəbbə təqdim olunan ünsiyyət qurbanı qoyun-keçidəndirsə, qoy o, qüsursuz erkək və yaxud dişi heyvan gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Əgər gətirdiyi qurban bir qoyundursa, qoy onu Rəbbin önündə belə təqdim etsin: ");
INSERT INTO azb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","əlini qurbanın başına qoyub onu Hüzur çadırının qabağında kəssin, Harun övladları qanı qurbangahın hər tərəfinə səpsinlər. ");
INSERT INTO azb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Qoy o adam ünsiyyət qurbanından bunları Rəbb üçün yandırma təqdimi kimi gətirsin: onurğayadək kəsdiyi quyruğunu, içalatı örtən piyi və üstündəki bütün piyi ");
INSERT INTO azb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","belindəki hər iki böyrəyini, üstündəki piyi və qaraciyərin quyruğa bənzər hissəsini – bunları böyrəkləri ilə birgə çıxartsın. ");
INSERT INTO azb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Bunları kahin qurbangahda tüstülədib yandırsın. Bu, Rəbb üçün yandırma təqdimi olaraq verilən paydır. ");
INSERT INTO azb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Əgər adamın qurbanlığı bir keçidirsə, qoy onu Rəbbin önündə belə təqdim etsin: ");
INSERT INTO azb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","əlini heyvanın başına qoyub onu Hüzur çadırının qabağında kəssin. Harun övladları onun qanını qurbangahın hər tərəfinə səpsinlər. ");
INSERT INTO azb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Qoy o adam qurbandan bunları Rəbb üçün yandırma təqdimi kimi gətirsin: içalatı örtən piyi və üstündəki bütün piyi, ");
INSERT INTO azb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","belindəki hər iki böyrəyini və üstündəki piyi, qaraciyərin quyruğa bənzər hissəsini – bunları böyrəkləri ilə birgə çıxartsın. ");
INSERT INTO azb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kahin bunları qurbangah üstündə tüstülədib yandırsın. Bu, yemək – yandırma təqdimi, xoşa gələn ətirdir. Bütün piy Rəbbə məxsusdur. ");
INSERT INTO azb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Bu bütün yaşadığınız yerlərdə nəsildən-nəslə sizin üçün əbədi qayda olsun: piyi də, qanı da yeməyin”». ");
INSERT INTO azb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«İsrail övladlarına belə de: “Əgər kimsə etməməli olduğu halda Rəbbin bütün əmrlərindən birini bilmədən pozarsa, qoy bunlara əməl etsin. ");
INSERT INTO azb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Əgər məsh edilmiş baş kahin günah işlədib xalqı da borclu etsə, o günaha görə Rəbbə günah qurbanı olaraq qüsursuz bir buğa təqdim etsin. ");
INSERT INTO azb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Buğanı Hüzur çadırının girişinə, Rəbbin hüzuruna gətirsin və əllərini heyvanın başına qoyub onu Rəbbin hüzurunda kəssin. ");
INSERT INTO azb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Sonra məsh edilmiş kahin buğanın qanından götürüb Hüzur çadırına gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kahin barmağını qana batıraraq Rəbbin hüzurunda Müqəddəs yerin pərdəsi qabağında yeddi dəfə çiləsin. ");
INSERT INTO azb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Sonra kahin Hüzur çadırında, Rəbbin önündə olan ətirli buxur qurbangahının buynuzlarına o qandan çəksin, buğanın qanının qalan hissəsini isə Hüzur çadırının girişindəki yandırma qurbanları üçün qurulan qurbangahın altlığına töksün. ");
INSERT INTO azb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Qoy sonra kahin günah qurbanı olan buğanın piyini bütövlükdə götürsün. İçalatı örtən piyi və üstündəki bütün piyi, ");
INSERT INTO azb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","belindəki hər iki böyrəyi və üstündəki piyi, qaraciyərin quyruğa bənzər hissəsini – bunları böyrəkləri ilə birgə çıxartsın. ");
INSERT INTO azb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Bunların hamısı ünsiyyət qurbanı olan mal-qaradan götürüldüyü kimi götürülsün və həmin kahin onları yandırma qurbanları üçün qurulan qurbangahda tüstülədib yandırsın. ");
INSERT INTO azb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Buğanın dərisini, başından budlarına qədər bütün ətini – içalatını, bağırsaqlarını, ");
INSERT INTO azb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","hər qalan hissəsini düşərgədən kənara çıxarıb kül tökülən pak bir yerə atsın və orada odunla yandırsın. ");
INSERT INTO azb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Əgər bütün İsrail icması bilmədən günah işlətsə, bu onların nəzərindən qaçsa və etməməli olduqları halda Rəbbin bütün əmrlərindən birini pozub təqsirkar olsalar, ");
INSERT INTO azb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","işlədikləri günah aşkara çıxanda camaat günah qurbanı olaraq bir buğa götürüb Hüzur çadırının qabağına gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","İcmanın ağsaqqalları Rəbbin hüzurunda əllərini buğanın başına qoyub onu kəssinlər. ");
INSERT INTO azb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Sonra məsh edilmiş kahin buğanın qanından götürüb Hüzur çadırına gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Kahin barmağını qana batırıb Rəbbin hüzurunda pərdənin qabağına yeddi dəfə çiləsin. ");
INSERT INTO azb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Sonra kahin Hüzur çadırında Rəbbin önündəki qurbangahın buynuzlarına o qanı çəksin və buğanın qanının qalan hissəsini isə Hüzur çadırının girişindəki yandırma qurbanları üçün qurulan qurbangahın altlığına töksün. ");
INSERT INTO azb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Sonra o heyvanın bütün piyini götürərək qurbangahda tüstülədib yandırsın; ");
INSERT INTO azb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","günah qurbanı olan buğaya nə cür etsə, bu buğaya da eyni cür etsin. Bununla kahin xalq üçün kəffarə etsin ki, xalq bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Sonra kahin buğanı düşərgədən kənara çıxarıb əvvəlki buğanı yandıran kimi yandırsın. Bu, camaat üçün verilən günah qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Başçılardan biri günah işlədərək etməməli olduğu halda Allahı Rəbbin bütün əmrlərindən birini bilmədən pozub təqsirkar olsa, ");
INSERT INTO azb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","işlətdiyi günah özünə aşkar olanda qoy qurban olaraq qüsursuz təkə gətirsin; ");
INSERT INTO azb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","əlini təkənin başına qoyub onu Rəbbin hüzurunda – yandırma qurbanlar kəsilən yerdə onu kəssin. Bu, günah qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Sonra kahin barmağı ilə günah qurbanının qanından bir az götürüb yandırma qurbanları üçün qurulan qurbangahın buynuzlarına çəksin. Qanın qalan hissəsini isə həmin qurbangahın altlığına töksün. ");
INSERT INTO azb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Sonra o heyvanın bütün piyini ünsiyyət qurbanının piyi kimi qurbangahda tüstülədib yandırsın. Bununla kahin o adam üçün günahını kəffarə etsin ki, o bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Əgər ölkə xalqından bir nəfər etməməli olduğu halda Rəbbin əmrlərindən birini pozaraq bilmədən günah işlədib bu günahda təqsirkar olsa, ");
INSERT INTO azb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","işlətdiyi günah özünə aşkar olanda qoy o, günahına görə özü üçün qurban – qüsursuz dişi keçi gətirsin ");
INSERT INTO azb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","və əlini günah qurbanının başına qoyub bu qurbanı yandırma qurbanları kəsilən yerdə kəssin. ");
INSERT INTO azb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Sonra kahin barmağı ilə qurbanın qanından bir az götürüb yandırma qurbanları üçün qurulan qurbangahın buynuzlarına çəksin; qanın qalan hissəsini isə qurbangahın altlığına töksün. ");
INSERT INTO azb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Sonra heyvanın bütün piyini ünsiyyət qurbanının piyini çıxardığı kimi çıxarıb onu Rəbbin xoşuna gələn ətir kimi qurbangahda tüstülədib yandırın. Bununla kahin o adam üçün kəffarə etsin ki, o bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Əgər adam günah qurbanı olaraq qoyun gətirsə, qoy o, qüsursuz dişi heyvan gətirsin ");
INSERT INTO azb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","və əlini günah qurbanının başına qoysun və onu yandırma qurbanları kəsilən yerdə kəssin. ");
INSERT INTO azb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Sonra kahin öz barmağı ilə günah qurbanının qanından bir az götürüb yandırma qurbanları üçün qurulan qurbangahın buynuzlarına çəksin; qanın qalan hissəsini isə qurbangahın altlığına töksün. ");
INSERT INTO azb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Sonra o adam heyvanın bütün piyini ünsiyyət qurbanı olan qoyunun piyi kimi çıxarsın və kahin onu qurbangahda Rəbb üçün verilən yandırma təqdimi üzərində tüstülədib yandırsın. Bununla kahin o adam üçün işlətdiyi günahı kəffarə etsin ki, o bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Günahın işləndiyini görərək yaxud bilərək şahidi olan adam and içdiriləndə bu barədə şəhadət etməsə, cəzasını çəkər. ");
INSERT INTO azb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Bilmədən hər hansı murdar bir əşyaya, çöl, ev ya da qaynaşan heyvanın leşinə toxunan hər kəs murdar və təqsirkar sayılır. ");
INSERT INTO azb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Birini murdarlayan ifrazata, insandan ifraz olan murdarlığa bilmədən toxunan kəs – nə cür murdarlıq olursa olsun – onu dərk edəndə təqsirkar sayılır. ");
INSERT INTO azb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Düşünmədən və bilmədən hər hansı bir ehtiyatsız andla pislik yaxud yaxşılıq etmək üçün and içən hər kəs bunu biləndə təqsirkar sayılır. ");
INSERT INTO azb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Bu adam bunlardan birinə görə təqsirini biləndə qoy günahını etiraf etsin ");
INSERT INTO azb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","və o, günaha görə Rəbbin qarşısında təqsirini yumaq üçün sürüdən dişi qoyun ya da dişi keçi götürüb günah qurbanı olaraq gətirsin. Bununla kahin o adam üçün günahını kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Lakin əgər o adamın qoyun-keçi qurbanı kəsməyə gücü çatmırsa, günahına görə təqsirini yumaq üçün Rəbbə iki qumru quşu yaxud da iki göyərçin – biri günah qurbanı, digərini yandırma qurbanı olaraq gətirsin ");
INSERT INTO azb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","və kahinə versin. Kahin əvvəl günah qurbanı olan quşu təqdim etsin: başını bədəndən ayırmadan boynunu üzsün ");
INSERT INTO azb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","və günah qurbanının qanından qurbangahın bir tərəfinə çiləsin, qanın digər hissəsini isə qurbangahın altlığına töksün. Bu, günah qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","İkinci quş da qayda-qanuna uyğun olaraq yandırma qurbanı kimi təqdim olunsun. Bununla kahin o adam üçün işlətdiyi günahı kəffarə etsin ki, o bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Əgər o adamın hətta iki qumru quşuna və yaxud iki göyərçinə gücü çatmırsa, qoy işlətdiyi günah üçün narın undan efanın onda birini günah qurbanı kimi təqdim etsin. Lakin qoy onun üstünə nə zeytun yağı, nə də kündür qoymasın, çünki bu günah qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Qoy bu adam onu kahinin yanına gətirsin. Kahin ondan xatirə təqdimi kimi bir ovuc götürüb qurbangahda Rəbb üçün verilən yandırma təqdimi üzərində tüstülətsin. Bu, günah qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Bununla kahin o adam üçün işlətdiyi hər hansı bir günahı kəffarə etsin ki, o adam bağışlansın. Qalan hissə taxıl təqdimi kimi kahinə məxsus olsun”». ");
INSERT INTO azb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Rəbbin müqəddəs şeylərinə etinasız yanaşıb bilmədən günah edən hər kəs təqsir qurbanı olaraq sürüdən qüsursuz bir qoç gətirsin. Bu təqsir qurbanı Müqəddəs yerdəki şekelə münasib gümüş şekellə qiymətləndirilməlidir. ");
INSERT INTO azb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Müqəddəs şeylərə vurduğu ziyanı da qoy o adam ödəsin və üstünə beşdə birini əlavə edərək kahinə versin; kahin onun üçün təqsir qurbanı olan qoçla kəffarə etsin ki, o bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Əgər bir nəfər günah işlədib etməməli olduğu halda Rəbbin bütün əmrlərindən birini pozarsa və bunu bilmədən edərsə, təqsirkar sayılıb cəzasını çəkməlidir. ");
INSERT INTO azb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Qoy o, kahinin yanına təqsir qurbanı olaraq sürüdən qüsursuz və dəyərli bir qoç gətirsin. Bununla kahin onun bilmədən törətdiyi günahı kəffarə etsin ki, o bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Bu, təqsir qurbanıdır. Həmin adam Rəbbin qarşısında təqsirkar olmuşdur». ");
INSERT INTO azb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Əgər bir şəxs günah edib Rəbbə xəyanət edərsə, özünə əmanət edilən, girov qoyulan yaxud oğurluq bir şey barəsində başqa bir adamı aldadarsa ya da ona haqsızlıq edərsə, ");
INSERT INTO azb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","itmiş bir əşyanı tapıb yalan söylərsə, yalandan and içərsə, yəni insanların edə biləcəyi bu günahlardan birini edərsə, ");
INSERT INTO azb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","o şəxs günah etmiş olur və təqsirkar sayılır. Oğurladığı ya da haqsızlıqla ələ keçirdiyi şeyi, özünə əmanət edilən ya da tapdığı itmiş əşyanı ");
INSERT INTO azb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","yaxud barəsində yalandan and içdiyi şeyin üzərinə beşdə birini də əlavə edərək təqsir qurbanını gətirdiyi gün sahibinə geri qaytarsın. ");
INSERT INTO azb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Bu adam Rəbbin qarşısında təqsirini yumaq üçün kahinin yanına təqsir qurbanı olaraq sürüdən qüsursuz və dəyərli bir qoç gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Bununla kahin günah edən adam üçün təqsirinə səbəb olduğu hər şeyi Rəbbin önündə kəffarə etsin ki, o bağışlansın». ");
INSERT INTO azb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Harunla oğullarına əmr verib de: “Yandırma qurbanına aid olan təlimat budur. Yandırma qurbanı bütün gecə səhərə qədər qurbangahdakı odda qalsın, bu od isə qoy sönmədən yansın. ");
INSERT INTO azb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Qoy kahin kətan paltarını, kətan alt geyimini əyninə geyib qurbangahda yandırma qurbanını məhv edən oddan çıxan külü götürüb qurbangahın yanına qoysun. ");
INSERT INTO azb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Sonra kahin geyimini çıxarıb başqa paltar geyinsin və külü düşərgədən kənara çıxararaq pak bir yerə töksün. ");
INSERT INTO azb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Qoy od qurbangahda yansın və sönməsin. Hər səhər kahin odunla od qalayıb üstünə yandırma qurbanını düzsün və ünsiyyət qurbanlarının piyini tüstülədib yandırsın. ");
INSERT INTO azb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Qoy bu od qurbangahda daima yansın və sönməsin. ");
INSERT INTO azb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Taxıl təqdiminə aid olan təlimat budur. Harun övladları bunu Rəbbin hüzurunda qurbangahın qabağında təqdim etsinlər. ");
INSERT INTO azb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Qoy kahin bir ovuc taxıl təqdimini, narın un ilə zeytun yağını və üstündəki kündürün hamısını götürüb qurbangahda tüstülətsin. Bu, Rəbbin xoşuna gələn ətir – xatirə təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Təqdimin qalan hissəsini Harunla övladları yesin; onu müqəddəs bir yerdə – Hüzur çadırının həyətində mayasız çörək kimi yesinlər. ");
INSERT INTO azb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Bu, taxıldan maya ilə bişirilməsin. Bunu Mənə gətirilən yandırma təqdimlərindən kahinlərə düşən pay kimi verirəm. O, günah qurbanı və təqsir qurbanı kimi ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Harunun hər kişi övladı nəsildən-nəslə bunu yesin. Bu, Rəbbə gətirilən yandırma təqdimlərindən onlara verilən əbədi paydır. Bunlara toxunan hər şey müqəddəs sayılar”». ");
INSERT INTO azb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«Harunun məsh olunacağı gün Harunla oğullarının Rəbbə edəcəkləri təqdim budur: daimi taxıl təqdimi olaraq narın undan efanın onda birini – yarısı səhər, yarısı isə axşam, ");
INSERT INTO azb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","zeytun yağı ilə qarışdırılmış, sacda bişmiş halda gətirsin və bu taxıl təqdimini parça-parça qırıb təqdim etsin. Bu, Rəbbin xoşuna gələn ətirdir. ");
INSERT INTO azb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Harun nəslindən yerinə keçən məsh edilmiş kahin onu belə də hazırlasın; bunu Rəbbə əbədi pay olaraq bütünlüklə tüstülədib yandırsın. ");
INSERT INTO azb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kahinin gətirdiyi hər taxıl təqdimi bütünlüklə yandırılsın, o yeyilməməlidir». ");
INSERT INTO azb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«Harunla oğullarına belə de: “Günah qurbanına aid olan təlimat budur. Günah qurbanı yandırma qurbanı kəsilən yerdə – Rəbbin önündə kəsilsin. Bu qurban ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Günah qurbanını təqdim edən kahin onu müqəddəs bir yerdə – Hüzur çadırının həyətində yesin. ");
INSERT INTO azb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Onun ətinə toxunan hər bir şey müqəddəs sayılar; o qurbandan bir damla qan geyimlərə sıçrasa, o geyim müqəddəs bir yerdə yuyulsun. ");
INSERT INTO azb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ətin bişirildiyi saxsı qab sındırılsın; əgər o, tunc qabda bişirilibsə, həmin qab təmizlənib su ilə yaxalansın. ");
INSERT INTO azb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kahin nəslindən hər kişi onu yesin; o ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Lakin Müqəddəs yerdə günahı kəffarə etmək üçün qanından Hüzur çadırına gətirilən günah qurbanının hamısı yeyilməməlidir, qoy yandırılsın. ");
INSERT INTO azb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Təqsir qurbanına aid olan təlimat budur. O ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Təqsir qurbanı yandırma qurbanları kəsilən yerdə kəsilsin. Kahin onun qanını qurbangahın hər tərəfinə səpsin. ");
INSERT INTO azb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Onun bütün piyini təqdim etsin: quyruğunu, içalatı örtən piyi, ");
INSERT INTO azb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","belindəki hər iki böyrəyini və üstündəki piyi, qaraciyərin quyruğa bənzər hissəsini – bunları böyrəkləri ilə birgə çıxartsın. ");
INSERT INTO azb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Qoy kahin bunu Rəbb üçün yandırma təqdimi olaraq qurbangahda tüstülədib yandırsın. Bu, təqsir qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ətini kahin nəslindən olan hər kişi yesin; bu ət müqəddəs bir yerdə yeyilsin, çünki o ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Günah qurbanına da, təqsir qurbanına da aid olan təlimat eynidir: qurbanın əti həmin qurbanla kəffarə edən kahinə məxsus olsun. ");
INSERT INTO azb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Bir adamın gətirdiyi yandırma qurbanının dərisi də həmin qurbanı təqdim edən kahinə məxsus olsun. ");
INSERT INTO azb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Təndirdə bişirilmiş hər taxıl təqdimi, tavada, sacda hazırlanan hər bir şey onu götürüb təqdim edən kahinə məxsus olsun. ");
INSERT INTO azb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Zeytun yağı ilə yoğrulmuş yaxud hər quru taxıl təqdimi isə bütün Harun övladları arasında bərabər paylara bölünsün. ");
INSERT INTO azb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Rəbbə təqdim olunan ünsiyyət qurbanına aid olan təlimat budur. ");
INSERT INTO azb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Əgər kimsə onu təşəkkür etmək üçün qurban gətirsə, onda o, zeytun yağı ilə yoğrulmuş mayasız kökələr, üstünə zeytun yağı sürtülmüş mayasız qoğallar və zeytun yağı ilə narın undan yoğrulmuş kökələr gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Bundan əlavə, o, mayalı çörək kökələrini təşəkkür ifadə edən ünsiyyət qurbanı ilə təqdim olaraq gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Bunların hər növündən birini Rəbbə qaldırılan pay kimi təqdim etsin. O, ünsiyyət qurbanının qanını səpən kahinə məxsus olsun. ");
INSERT INTO azb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Təşəkkür ifadə edən ünsiyyət qurbanının əti qurban kəsilən gün yeyilsin. O, səhərə qədər qalmamalıdır. ");
INSERT INTO azb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Əgər kimsə verdiyi əhdə görə yaxud könüllü təqdim olaraq qurban gətirərsə, qurbanın əti kəsildiyi gün yeyilsin, qalan hissəsi isə sabahkı gün yeyilə bilər, ");
INSERT INTO azb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","lakin üçüncü günə qalan qurbanlıq əti yandırılsın. ");
INSERT INTO azb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Əgər ünsiyyət qurbanlarının ətindən üçüncü gün yeyilsə, o qurbanı gətirən adam qəbul olunmaz və qurban onun xeyrinə sayılmaz, bu ət iyrənc sayılar və onu yeyən adam cəzasını çəkər. ");
INSERT INTO azb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Murdar sayılan hər hansı bir şeyə toxunan ət yeyilməməli və yandırılmalıdır. Hər pak adam murdar ətdən başqa hər cür ət yeyə bilər; ");
INSERT INTO azb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","murdar halda isə Rəbbə kəsilən ünsiyyət qurbanının ətini yeyən hər kəs xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Bir nəfər hər hansı murdar əşyaya, insandan ifraz olan murdarlığa yaxud murdar bir heyvana yaxud hər hansı iyrəndirici bir murdar şeyə toxunub sonra da Rəbbin ünsiyyət qurbanının ətindən yeyərsə, xalqı arasından qovulsun”». ");
INSERT INTO azb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«İsrail övladlarına belə de: “Mal-qara, qoyun və keçi piyini yeməyin. ");
INSERT INTO azb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Təbii yolla ölən yaxud parçalanıb ölən heyvanın piyini hər bir başqa iş üçün işlədə bilərsiniz, lakin onu qətiyyən yemək olmaz. ");
INSERT INTO azb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Rəbb üçün yandırma təqdimi olaraq verilən heyvanın piyindən yeyən hər kəs xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Bütün yaşadığınız yerlərdə heç vaxt quşların və heyvanların qanını yeməyin; ");
INSERT INTO azb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","qan yeyən hər kəs xalqı arasından qovulsun”». ");
INSERT INTO azb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«İsrail övladlarına belə de: “Rəbbə ünsiyyət qurbanı təqdim edən şəxs onun bir hissəsini Rəbbin hüzuruna qurban gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Onu öz əli ilə Rəbb üçün yandırma təqdimi olaraq gətirsin; heyvanın piyi ilə döş ətini gətirib Rəbbin hüzurunda yellətmə təqdimi versin. ");
INSERT INTO azb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kahin piyi qurbangahda tüstülədib yandırsın; döş əti isə Harunla övladlarına məxsus olsun. ");
INSERT INTO azb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ünsiyyət qurbanları olan heyvanlarınızın sağ budunu qaldırma təqdimi kimi kahinə verin; ");
INSERT INTO azb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","həmin sağ bud ünsiyyət qurbanının qanını və piyini təqdim edən Harun övladlarının payı olsun”. ");
INSERT INTO azb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Çünki Mən yellədilən döş ətini və qaldırılan budu İsrail övladlarından, onların ünsiyyət qurbanlarından götürüb kahin Harunla övladlarına İsraillilərdən gələn əbədi pay kimi vermişəm. ");
INSERT INTO azb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Bu, Rəbbə kahinlik etmək üçün bunları təqdim etdiyi gün Rəbb üçün verilən yandırma təqdimlərindən Harunun və övladlarının payıdır; ");
INSERT INTO azb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Harunla övladları məsh olunduğu gün Rəbb əmr etmişdir ki, nəsildən-nəslə İsrail övladları bu əbədi payı onlara versinlər». ");
INSERT INTO azb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Bu, yandırma qurbanına, taxıl təqdiminə, günah qurbanına, təqsir qurbanına, təqdis təqdiminə və ünsiyyət qurbanına aid olan ");
INSERT INTO azb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Rəbbin Sina dağında Musaya əmr etdiyi təlimatdır. Rəbb bu təlimatı İsrail övladlarına Sina səhrasında qurbanlarını Ona təqdim etməklə əlaqədar əmr etdiyi gündə vermişdi. ");
INSERT INTO azb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Harunla oğullarını, geyimlərini, məsh yağını və günah qurbanı kəsmək üçün bir buğa, iki qoç, bir səbət mayasız çörək götür. ");
INSERT INTO azb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Sonra bütün icmanı Hüzur çadırının girişinə topla». ");
INSERT INTO azb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa Rəbbin əmrinə əməl etdi. İcma Hüzur çadırının girişinə yığılanda ");
INSERT INTO azb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa onlara dedi: «Rəbbin əmr etdiyi budur». ");
INSERT INTO azb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Sonra Musa Harunla oğullarını irəli gətirib onları su ilə yuyundurdu. ");
INSERT INTO azb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Harunun əyninə xirqəsini geyindirib belinə qurşağını bağladı, üstündən cübbəsini geyindirdi və üstünə efodu qoydu. Efodun kəmərini belinə bağlayıb efodu özünə bərkitdi. ");
INSERT INTO azb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Efodun üstündən döşlüyünü, döşlüyündə isə Urim və Tummimi yerləşdirdi. ");
INSERT INTO azb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Onun başına çalmanı, çalmanın qabaq hissəsinə qızıl lövhəciyi olan müqəddəslik tacını qoydu. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Musa məsh yağını götürüb məskəni və içindəki hər şeyi məsh edərək təqdis etdi. ");
INSERT INTO azb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Sonra məsh yağını qurbangaha yeddi dəfə çiləyib onunla bütün avadanlığını, ləyənlə altlığını da təqdis etmək üçün məsh etdi. ");
INSERT INTO azb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Musa bir az məsh yağı götürüb Harunun başına tökərək onu təqdis etmək üçün məsh etdi. ");
INSERT INTO azb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Sonra Musa Harunun oğullarını irəli gətirdi, onlara xirqə geyindirdi, bellərinə qurşaq bağladı və başlarına papaq qoydu. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Bundan sonra Musa günah qurbanı üçün nəzərdə tutulmuş buğanı gətirdi. Harunla oğulları həmin buğanın başına əllərini qoydular. ");
INSERT INTO azb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa buğanı kəsdi, qanını götürüb barmağı ilə qurbangahın buynuzlarının ətrafına çəkərək qurbangahı pak etdi. Sonra qanın qalan hissəsini qurbangahın altlığına tökdü və murdarlığını kəffarə etmək üçün onu təqdis etdi. ");
INSERT INTO azb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musa heyvanın içalatının üstündəki bütün piyi, qaraciyərin quyruğa bənzər hissəsini, hər iki böyrəklə piyini götürərək qurbangahda tüstülədib yandırdı. ");
INSERT INTO azb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Buğanı – dərisini, ətini və bağırsaqlarını düşərgənin kənarında yandırdı. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Musa yandırma qurbanı üçün nəzərdə tutulmuş qoçu gətirdi. Harunla oğulları əllərini qoçun başına qoydular. ");
INSERT INTO azb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa qoçu kəsdi və qanını qurbangahın hər tərəfinə səpdi. ");
INSERT INTO azb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Qoçu parça-parça doğradı; Musa qoçun başını, parçalarını və piyini tüstülədib yandırdı. ");
INSERT INTO azb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Sonra içalatını və budlarını su ilə yudu və bütün qoçu qurbangahda tüstülədib yandırdı. Bu, yandırma qurbanı, Rəbbin xoşuna gələn ətir – yandırma təqdimi idi. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Musa o biri qoçu – təqdis qoçunu gətirdi; Harun və oğulları əllərini qoçun başına qoydular. ");
INSERT INTO azb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa onu kəsdi; qanından bir az götürüb Harunun sağ qulağının mərcəyinə, sağ əlinin və sağ ayağının baş barmağına çəkdi. ");
INSERT INTO azb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Bundan sonra Musa Harunun oğullarını gətirib onların sağ qulaq mərcəklərinə, sağ əllərinin baş barmaqlarına və sağ ayaqlarının baş barmaqlarına qan çəkdi. Musa heyvanın qanını qurbangahın hər tərəfinə səpdi. ");
INSERT INTO azb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Sonra piyini, quyruğunu, içalatının üstündəki piyi, qaraciyərinin quyruğa bənzər hissəsini, hər iki böyrəklə piyini və sağ budunu götürdü. ");
INSERT INTO azb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Rəbbin önündə olan mayasız çörəklər səbətindən bir mayasız kökə, bir zeytun yağı ilə yoğrulmuş çörək kökəsi və bir qoğal götürüb piylə sağ budun üstünə qoydu. ");
INSERT INTO azb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","O bunların hamısını Rəbbin hüzurunda yellətmə təqdimi üçün Harunun və oğullarının əllərinə verdi. ");
INSERT INTO azb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Sonra Musa həmin şeyləri onların əllərindən alıb qurbangahda yandırma qurbanı ilə birlikdə tüstülədib yandırdı. Bu, təqdis qurbanı, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa döş ətini götürdü və onu Rəbbin hüzurunda yellədərək təqdim etdi. Bu, təqdis qurbanı olan qoçdan Musanın payı idi. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa məsh yağını və qurbangahdakı qanı götürüb Haruna, onun geyimlərinə, oğullarına və geyimlərinə çilədi. Beləliklə, Harunu və onun geyimlərini, oğullarını və onların geyimlərini təqdis etdi. ");
INSERT INTO azb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Sonra Musa Harunla oğullarına dedi: «Əti Hüzur çadırının girişində qaynadın və “Harunla oğulları onu yesin” deyib əmr etdiyimə görə onu orada təqdis təqdimi üçün səbətdəki çörəklə yeyin. ");
INSERT INTO azb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Çörəyin və ətin qalan hissələrini yandırın. ");
INSERT INTO azb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Təqdis günləri başa çatana qədər yeddi gün Hüzur çadırının girişindən kənara çıxmayın; çünki vəzifəyə keçmə vaxtınız yeddi gün davam edəcək. ");
INSERT INTO azb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Bu gün edilən hər şeyi Rəbb kəffarəniz üçün əmr etdi. ");
INSERT INTO azb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Yeddi gün ərzində gecə-gündüz Hüzur çadırının girişində qalın və Rəbbin buyruğuna riayət edin ki, ölməyəsiniz. Mənə belə əmr verilib». ");
INSERT INTO azb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Harunla oğulları Rəbbin Musa vasitəsilə əmr etdiyi hər şeyə əməl etdilər. ");
INSERT INTO azb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Bundan səkkiz gün sonra Musa Harunla oğullarını və İsrail ağsaqqallarını yanına çağırıb ");
INSERT INTO azb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Haruna dedi: «Özün üçün günah qurbanı kimi qüsursuz bir erkək dana və yandırma qurbanı kimi qüsursuz bir qoç götür və Rəbbin hüzurunda təqdim et. ");
INSERT INTO azb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Sonra İsrail övladlarına de: “Günah qurbanı kimi bir təkə, yandırma qurbanı kimi birillik qüsursuz bir dana və birillik qüsursuz bir toğlu, ");
INSERT INTO azb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Rəbbin hüzurunda kəsilən ünsiyyət qurbanları kimi bir buğa, bir qoç və zeytun yağı ilə yoğrulmuş taxıl təqdimləri götürün. Çünki bu gün Rəbb sizə görünəcək”». ");
INSERT INTO azb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Musanın əmr etdiyi hər şey Hüzur çadırının önünə gətirildi. Sonra bütün icma yaxınlaşıb Rəbbin hüzurunda durdu. ");
INSERT INTO azb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa dedi: «Rəbb bu işi əmr etdi ki, siz əməl edəsiniz, onda Rəbbin izzəti sizə görünəcək». ");
INSERT INTO azb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa Haruna dedi: «Qurbangaha yaxınlaş və özün üçün günah qurbanı ilə yandırma qurbanını gətir. Həm özünün, həm də xalqının günahlarını bunlarla kəffarə et. Xalqın qurbanını da təqdim edərək onların günahını bununla kəffarə et. Rəbb əmr etdiyi kimi olsun». ");
INSERT INTO azb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Harun qurbangaha yaxınlaşıb özü üçün günah qurbanı olan dananı kəsdi. ");
INSERT INTO azb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Onun qanını Harunun oğulları atalarına təqdim etdilər. Harun barmağını qana batırıb qurbangahın buynuzlarına çəkdi; qanın qalan hissəsini isə qurbangahın altlığına tökdü. ");
INSERT INTO azb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Sonra günah qurbanının piyini, böyrəklərini, qaraciyərini, quyruğa bənzər hissəsini qurbangahda tüstülədib yandırdı. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Qurbanın əti ilə dərisini düşərgənin kənarında yandırdı. ");
INSERT INTO azb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Bundan sonra Harun yandırma qurbanını kəsdi. Onun qanını Harunun oğulları atalarına gətirdilər; o da qanı qurbangahın hər tərəfinə səpdi. ");
INSERT INTO azb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Parça-parça kəsilən qurbanı və başını Haruna gətirdilər; o da onları qurbangahda tüstülədib yandırdı. ");
INSERT INTO azb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Qurbanın içalatı ilə budlarını yuyaraq qurbangahda yandırma qurbanı ilə birgə tüstülədib yandırdı. ");
INSERT INTO azb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Bundan sonra Harun xalqın qurbanını təqdim etdi. Xalq üçün günah qurbanı olan təkəni götürüb kəsdi; onu birinci günah qurbanı kimi gətirdi. ");
INSERT INTO azb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Yandırma qurbanı üçün heyvan gətirdi və onu qayda-qanuna uyğun olaraq təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Sonra Harun taxıl təqdimini gətirdi. Səhər təqdim olunan yandırma qurbanından savayı ovuclarını taxıl təqdimi ilə doldurub qurbangahda tüstülədərək yandırdı. ");
INSERT INTO azb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Harun xalq üçün ünsiyyət qurbanı olan buğanı və qoçu kəsdi. Harunun oğulları bunların qanını atalarına gətirdilər; o da qanı qurbangahın hər tərəfinə səpdi. ");
INSERT INTO azb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Buğanın və qoçun piyini, quyruğunu, içalatı örtən piyini, böyrəklərini, qaraciyərinin quyruğa bənzər hissəsini götürüb ");
INSERT INTO azb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","döş ətlərini üstünə qoydular. Harun da bu piyi qurbangahda tüstülədib yandırdı, ");
INSERT INTO azb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","döş ətlərini isə sağ budları ilə birlikdə Rəbbin önündə yellədərək təqdim etdi. Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Harun günah qurbanını, yandırma qurbanını və ünsiyyət qurbanını gətirdikdən sonra əllərini xalqa doğru uzadıb onlara xeyir-dua verdi. Sonra o aşağı düşdü. ");
INSERT INTO azb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa ilə Harun Hüzur çadırına girdilər. Sonra onlar çıxıb birlikdə xalqa xeyir-dua verdilər. O vaxt Rəbbin izzəti bütün xalqa göründü ");
INSERT INTO azb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","və Rəbbin hüzurundan od çıxıb qurbangahdakı yandırma qurbanı ilə piyi yandıraraq yox etdi. Bütün xalq bunu görərək sevincdən qışqırıb üzüstə yerə döşəndi. ");
INSERT INTO azb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Harun oğulları Nadav və Avihu buxurdanlarını götürüb içinə közərmiş kömürlə buxur qoydular və Rəbbin önünə haram od gətirdilər. Belə təqdimi Rəbb əmr etməmişdi. ");
INSERT INTO azb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Rəbb hüzurundan od göndərib onları məhv etdi. Onlar Rəbbin hüzurunda öldülər. ");
INSERT INTO azb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa Haruna dedi: «Budur, Rəbb belə demişdir: “Mənə yaxınlaşanlar Məni müqəddəs saysınlar; Bütün xalq Məni izzətləndirsin”». Harun isə susurdu. ");
INSERT INTO azb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa Harunun əmisi Uzzielin oğulları Mişaellə Elsafanı çağırıb dedi: «Yaxın gəlin və qardaşlarınızın cəsədlərini Müqəddəs yerin önündən düşərgənin kənarına aparıb qoyun». ");
INSERT INTO azb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Musa bu sözü deyən kimi onlar yaxınlaşdılar və cəsədləri xirqələri əynindəcə düşərgənin kənarına aparıb qoydular. ");
INSERT INTO azb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa Haruna və onun sağ qalan oğulları Eleazar və İtamara dedi: «Siz yas tutaraq saçlarınızı dağıtmayın, geyimlərinizi cırmayın. Yoxsa ölərsiniz və Rəbb bütün icmaya qəzəblənər. Ancaq bütün İsrailli soydaşlarınız Rəbbin yandırdığı adamların yasını tutsun. ");
INSERT INTO azb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Hüzur çadırının girişindən kənara çıxmayın, yoxsa ölərsiniz, çünki Rəbbin məsh yağı sizin üstünüzdədir». Onlar da Musanın dediyi kimi etdilər. ");
INSERT INTO azb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Rəbb Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Sən və övladların Hüzur çadırına nə şərab, nə də başqa kefləndirici içki içib girməyin, yoxsa ölərsiniz. Qoy bu, nəsildən-nəslə sizin üçün əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Müqəddəslə adi şeyləri ayırd edin, həm də pak və murdar şeylər arasında fərq qoyun. ");
INSERT INTO azb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Mənim Musa vasitəsilə bəyan etdiyim bütün qaydaları İsrail övladlarına öyrədin». ");
INSERT INTO azb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa Haruna və sağ qalan oğulları Eleazarla İtamara dedi: «Rəbb üçün verilən yandırma təqdimlərindən qalan taxıl təqdimini götürün və mayasız çörək bişirib qurbangahın yanında yeyin, çünki bu ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Onu müqəddəs bir yerdə yeyin, mənə verilmiş əmrə görə bu, Rəbb üçün verilən yandırma təqdimlərindən sənin və övladlarının payına düşür. ");
INSERT INTO azb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Yellədilən döş ətini və qaldırılan bud ətini isə sən, oğulların və qızların pak bir yerdə yeyin; çünki bunlar İsrail övladlarının ünsiyyət qurbanlarından sənin və övladlarının payı kimi ayrılıb. ");
INSERT INTO azb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Qaldırılan bud ətini və yellədilən döş ətini Rəbbin önündə yellətmək üçün yandırma təqdimi olan piylə birlikdə gətirin. Bu sizin və övladlarınızın əbədi payı olacaq. Rəbb belə əmr etmişdir». ");
INSERT INTO azb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa günah qurbanı olan təkəni axtardı. O isə yandırılmışdı. Musa Harunun sağ qalan oğullarına – Eleazara və İtamara qəzəblənib dedi: ");
INSERT INTO azb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Siz nə üçün günah qurbanını müqəddəs sayılan yerdə yemədiniz? Çünki bu qurban ən müqəddəsdir və sizə verilib ki, onunla icmanın günahlarının cəzasını üzərindən götürüb onlar üçün Rəbbin önündə kəffarə edəsiniz. ");
INSERT INTO azb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Təkənin qanı içəri, Müqəddəs yerə gətirilmədi. Mən sizə əmr etdiyim kimi siz onun ətini mütləq Müqəddəs yerdə yeməli idiniz». ");
INSERT INTO azb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Harun Musaya dedi: «Bu gün günah qurbanı və yandırma qurbanı Rəbbin önündə təqdim olunmuşdur. Ancaq başıma belə iş gəldi. Əgər mən bu gün günah qurbanını yemiş olsaydım, o, Rəbbə məqbul olardımı?» ");
INSERT INTO azb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa bunu eşidib razılaşdı. ");
INSERT INTO azb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Rəbb Musa ilə Haruna belə dedi: ");
INSERT INTO azb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«İsrail övladlarına belə deyin: “Quruda yaşayan heyvanlardan belələrinin ətini yemək olar. ");
INSERT INTO azb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hər hansı qoşadırnaqlı gövşəyən heyvanın ətini yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Lakin gövşəyən yaxud qoşadırnaqlı heyvanlar içində bunları yeməyin: dəvə, çünki o gövşəsə də, qoşadırnaqlı deyil, buna görə də sizin üçün haramdır; ");
INSERT INTO azb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","qayadovşanı, çünki o gövşəsə də qoşadırnaqlı deyil, buna görə də sizin üçün haramdır; ");
INSERT INTO azb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","dovşan, çünki o gövşəsə də qoşadırnaqlı deyil, buna görə də sizin üçün haramdır; ");
INSERT INTO azb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","donuz, çünki o qoşadırnaqlı olsa da, gövşəmir, buna görə də sizin üçün haramdır. ");
INSERT INTO azb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Onların nə ətini yeyin, nə də leşinə toxunun, onlar sizin üçün haramdır. ");
INSERT INTO azb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Sularda, dənizlərdə yaxud çaylarda yaşayan heyvanlardan üzgəcləri və pulcuqları olanların hamısını yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Amma sularda, dənizlərdə yaxud çaylarda qaynaşan heyvanlardan üzgəcləri və pulcuqları olmayan hər canlı məxluq sizin üçün iyrənc olsun. ");
INSERT INTO azb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Onların ətini yeməyin və leşindən iyrənin; onlar sizin üçün iyrənc olsun. ");
INSERT INTO azb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Sularda üzgəcləri və pulcuqları olmayanların hamısı sizin üçün iyrənc olsun. ");
INSERT INTO azb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Quşlardan bunları iyrənc olduğuna görə yeməyin: qartal, keçələkərkəs, qaraquş, ");
INSERT INTO azb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","çalağan, bütün şahin cinsindən olanlar, ");
INSERT INTO azb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","bütün qarğa cinsindən olanlar, ");
INSERT INTO azb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","dəvəquşu, bayquş, qağayı, bütün qırğı cinsindən olanlar, ");
INSERT INTO azb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","yapalaq, qarabatdaq, böyük bayquş, ");
INSERT INTO azb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ağ bayquş, qutan, leş kərkəsi, ");
INSERT INTO azb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","leylək, bütün vağ cinsindən olanlar, şanapipik, yarasa. ");
INSERT INTO azb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Dördayaqla gəzən, qanadlı qaynaşan heyvanların hamısı da sizin üçün iyrənc olsun. ");
INSERT INTO azb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Lakin dördayaqla gəzən, qanadlı qaynaşan heyvanlardan yerdə sıçramaq üçün oynaqlı ayaqları olanları yeyə bilərsiniz; ");
INSERT INTO azb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","onlardan bütün çəyirtkə cinsindən olanları, bütün keçəl çəyirtkə cinsindən olanları, bütün sisək cinsindən olanları, bütün şala cırcıraması cinsindən olanları yemək olar. ");
INSERT INTO azb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Bütün digər dördayaqlı qanadlı qaynaşan heyvanlar isə sizin üçün iyrənc olsun. ");
INSERT INTO azb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Bu heyvanlardan siz özünüz murdar ola bilərsiniz. Hər kim onların leşinə toxunursa, axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Onların leşindən bir hissəsini daşıyan hər kəs də geyimlərini yusun; axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Qoşadırnağı olmayan yaxud gövşəməyən hər dırnaqlı heyvan sizin üçün murdar olsun. Onların leşinə toxunan hər kəs murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Pəncələri üstündə yeriyən dördayaqlı hər heyvan sizin üçün murdar olsun; onların leşinə toxunan hər kəs axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Onların leşini daşıyan geyimlərini yusun və axşama qədər murdar sayılsın. Bu heyvanlar sizin üçün murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Yerdə qaynaşan heyvanlar arasında sizin üçün murdar olan bunlardır: kor siçan, siçan, hər növ kərtənkələ, ");
INSERT INTO azb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","gekkon, varan, kərtəncik, kələz, buqələmun. ");
INSERT INTO azb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Bunlar bütün qaynaşan heyvanlar arasında sizin üçün murdar olsun. Onların leşinə toxunan hər kəs axşamadək murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Onlardan birisinin leşi üstünə düşən hər şey murdar sayılsın. Hər taxta, parça, dəri yaxud giş əşya nə cür iş üçün işlənsə, suya salınsın. Axşama qədər murdar sayılsın, axşamdan sonra təmiz sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Onlardan biri gil qabın içinə düşsə, onun içindəki hər şey murdar sayılsın və qab qırılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Belə bir qabdan su xörəyin içinə tökülsə, o xörək murdarlanır. Bu cür qabın içində hər içki murdarlanır. ");
INSERT INTO azb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","O heyvanlardan birinin leşi üstünə düşən hər bir şey murdar sayılsın. İstər təndir, istərsə də ocaq sökülsün, çünki murdarlanıb; onlar sizin üçün murdar olsun. ");
INSERT INTO azb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ancaq su bulağı yaxud su anbarı pak sayılsın. Bu heyvanların leşinə toxunan hər kəs murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Bunlardan birinin leşi əkin üçün ayrılmış toxumun üstünə düşərsə, o toxum təmiz sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Amma leş suya salınmış toxumun üstünə düşərsə, toxum sizin üçün murdar olsun. ");
INSERT INTO azb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Əti sizin üçün yeməli olan heyvanlardan biri ölərsə, leşinə toxunan adam axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","O heyvanın leşindən yeyən adam geyimini yusun və axşama qədər murdar sayılsın. Leşini daşıyan adam da geyimləri yusun və axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Yer üzündə sürünən hər qaynaşan heyvan sizin üçün iyrənc olsun; onu yeməyin. ");
INSERT INTO azb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","İstər qarnı üstündə, istər dörd ayağı ilə sürünən ya da yer üzündəki çoxayaqlı olan qaynaşan heyvanlardan yeməyin, çünki onlar iyrəncdir. ");
INSERT INTO azb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Qaynaşan heyvanların heç biri ilə özünüzü iyrənc edib murdarlamayın, çünki onlara görə siz murdar olarsınız. ");
INSERT INTO azb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Allahınız Rəbb Mənəm. Özünüzü təqdis edin və müqəddəs olun, çünki Mən müqəddəsəm; özünüzü yerdə sürünən heç bir qaynaşan heyvanla murdar etməyin. ");
INSERT INTO azb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Çünki Allahınız olmaq üçün sizi Misir torpağından çıxaran Rəbb Mənəm. Müqəddəs olun, çünki Mən müqəddəsəm”». ");
INSERT INTO azb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Heyvan, quş, sularda üzən hər cür canlı məxluq, yer üzündə qaynaşan hər cür heyvan haqqında təlimat budur. ");
INSERT INTO azb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Bununla pakla murdar şeylər arasında, yeyilən və yeyilməyən heyvanlar arasında fərq qoyulur. ");
INSERT INTO azb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«İsrail övladlarına belə de: “Hamilə olub oğlan uşağı doğan bir qadın aybaşı, murdarlıq dövründə olduğu kimi yeddi gün murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Səkkizinci gün uşaq sünnət olunsun. ");
INSERT INTO azb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Qadın qanaxmadan paklanmaq üçün daha otuz üç gün gözləsin. Bu paklanma dövrü bitənə qədər qadın heç bir müqəddəs şeyə toxunmamalı və Müqəddəs məkana yaxınlaşmamalıdır. ");
INSERT INTO azb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Əgər bir qadın qız uşağı doğarsa, aybaşı vaxtı kimi iki həftə murdar sayılsın və paklanmaq üçün əlavə olaraq altmış altı gün gözləsin. ");
INSERT INTO azb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Oğlan yaxud qız uşağı doğub paklanma müddəti bitəndə qadın Hüzur çadırının girişinə birillik toğlunu yandırma qurbanı kimi və göyərçin yaxud qumru quşunu kahinin yanına günah qurbanı kimi gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kahin bunları Rəbbin hüzurunda qurban gətirib, zahı qadın üçün kəffarə etsin ki, o qan axmasından pak olsun. Qız ya oğlan doğan zahı qadın üçün təlimat budur. ");
INSERT INTO azb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Əgər qadının toğlu gətirməyə gücü çatmırsa, onda birini yandırma qurbanı, o birini isə günah qurbanı olaraq iki qumru quşu yaxud iki göyərçin gətirsin. Bununla kahin həmin zahı üçün kəffarə etsin ki, o pak olsun”». ");
INSERT INTO azb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Bir adamın dərisində şiş yaxud səpki yaxud ləkə əmələ gəlib dəridə cüzam kimi görünən bir əlaməti olarsa, qoy o adam kahin Harunun yaxud onun nəslindən olan kahinlərin birinin yanına gətirilsin. ");
INSERT INTO azb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kahin dəridəki əlamətə baxsın. Əlamət üstündəki tükləri ağardıb dəridən dərin görünsə, bu, cüzamın bir əlamətidir. Kahin baxıb o adamı murdar elan etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Əgər dərisindəki ləkə ağ olub dəridən dərin görünməsə və üstündəki tükləri ağartmasa, kahin azarlını yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Yeddinci gün kahin ona baxsın. Onun nəzərində əlamət yerində qalıb dərisinə yayılmayıbsa, kahin onu yenə də yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Yeddinci gün kahin yenə də ona baxsın. Əlamət dərisinə yayılmayıb, solubsa, kahin o adamı pak elan etsin. Bu azar dəri səpməsidir. Qoy o adam geyimlərini yusun, sonra pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Lakin kahin ona baxıb pak saydıqdan sonra səpmə dərisinə yayılırsa, o yenə də özünü kahinə göstərsin. ");
INSERT INTO azb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kahin yenə də ona baxsın, dərisindəki səpmə yayılıbsa, kahin o adamı murdar elan etsin. Bu cüzamdır. ");
INSERT INTO azb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Bir adamın dərisində cüzam əlaməti əmələ gələrsə, qoy o adam kahinin yanına gətirilsin. ");
INSERT INTO azb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kahin ona baxsın, dəridəki tükləri ağardan xoralı ağ bir şiş varsa, ");
INSERT INTO azb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","bu, bədəninin dərisində kök salmış cüzamdır. Kahin o adamı murdar elan etsin, amma təcrid etməsin, çünki o murdardır. ");
INSERT INTO azb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Əgər cüzam dəriyə yayılıb bütün bədəni bürüsə və əlamətin onu təpədən dırnağadək tutması kahinə görünsə, ");
INSERT INTO azb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","qoy kahin diqqətlə baxsın. Cüzam bütün bədəni bürüyübsə, kahin azarlını pak elan etsin. Ağardığı üçün o adam pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Lakin o adamda xoralanma görünsə o, murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kahin o adama baxıb xoralanma görsə, onu murdar elan etsin. Xoralanma murdardır, o, cüzamdır. ");
INSERT INTO azb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Xoralanma sağalıb ağardığı halda o adam kahinin yanına getsin ");
INSERT INTO azb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","və kahin ona baxsın; əlamət ağarıbsa, o adamı pak elan etsin, çünki o, pakdır. ");
INSERT INTO azb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Bir adamın dərisində çiban əmələ gəlib sağaldıqdan sonra ");
INSERT INTO azb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","və yerində ağ şiş yaxud qırmızımtıl-ağ parlaq ləkə əmələ gələn halda bu əlamət kahinə göstərilsin. ");
INSERT INTO azb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kahin ləkəyə baxsın, üstündəki tükləri ağarıb dəridən dərin görünsə, kahin o adamı murdar elan etsin. Bu, çibanla başlanan cüzamdır. ");
INSERT INTO azb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Əgər kahin baxıb görsə ki, ləkənin üstündəki ağ tüklər yoxdur və ləkə dəridən dərin deyil, solğundur, onda kahin azarlını yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Əgər dəridəki ləkə yayılırsa, kahin adamı murdar elan etsin. Çünki bu, əlamətdir. ");
INSERT INTO azb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Amma ləkə yerində qalıb yayılmayıbsa, bu, çibandan qalan çapıqdır. Kahin o adamı pak elan etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Bir adamın dərisində olan yanıq yerində qırmızımtıl-ağ yaxud ağ parlaq ləkə əmələ gələrsə, ");
INSERT INTO azb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kahin ləkəyə baxsın, ləkə üstündəki tükləri ağardıb dəridən dərin görünsə, bu yanıqda başlanan cüzamdır. Kahin o adamı murdar elan etsin, çünki bu cüzamın əlamətidir. ");
INSERT INTO azb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Əgər kahin baxıb görsə ki, ləkənin üstündə ağ tüklər yoxdur və ləkə dəridən dərin olmayaraq solğun görünür, bu halda kahin azarlını yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Yeddinci gün kahin yenə azarlıya baxsın. Əgər ləkə dəriyə yayılıbsa, kahin o adamı murdar elan etsin; bu, cüzamın əlamətidir. ");
INSERT INTO azb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Amma ləkə yerində qalıb dərisində yayılmayıbsa və solubsa, bu, yanıqdan qalan şişdir; kahin o adamı pak elan etsin, çünki bu, yanıqdan qalan izdir. ");
INSERT INTO azb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Bir kişinin ya qadının başında ya çənəsində əlamət olanda ");
INSERT INTO azb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kahin ona baxsın. Əlamət dəridən dərin görünürsə və üstündəki tüklər sarı və nazikdirsə, kahin onu murdar elan etsin. Bu başda ya da çənədə iyrənc xəstəlik – qoturdur. ");
INSERT INTO azb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kahin qotur əlamətinə baxsın. Əlamət dəridən dərin görünməyib üstündə qara tüklər olmayan halda kahin qotur adamı yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Kahin yeddinci gün yenə də əlamətə baxsın, qoturluq yayılmayıbsa, üstündəki tüklər saralmayıbsa, qoturluq da dəridən dərin görünmürsə, ");
INSERT INTO azb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","qoy o adam qoturluq olan yerdən başqa bütün bədənini qırxsın. Sonra kahin onu yenə də yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Yeddinci gün kahin yenə də əlamətə baxsın. Əgər qotur dəriyə yayılmayıbsa və dəridən dərin görünməsə, kahin o adamı pak elan etsin. Qoy o adam geyimlərini yusun, sonra da pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Lakin əgər kahin xəstəni pak saydıqdan sonra qoturluq dəriyə yayılırsa, ");
INSERT INTO azb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kahin ona təkrarən baxsın. Qoturluq dərisinə yayılıbsa, kahin üstündəki sarı tükün olub-olmamasına baxmasın. O adam murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Lakin kahinin nəzərində qoturluq yerində qalıbsa və üstündə qara tük əmələ gəlirsə, qotur keçir və onda o adam pak sayılsın, kahin onu pak elan etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Bir kişinin yaxud qadının dərisində ağ parlaq ləkələr olarsa, ");
INSERT INTO azb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","qoy kahin baxsın; dərisində donuq ağ ləkələr varsa, bu başlanan dəmrovdur. O adam pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Başının təpəsində saçı tökülmüş kişi dazdır. O pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Əgər alnından saçı tökülübsə, o adamın alnı açılmışdır və o pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Lakin daz və yaxud alnı açılmış adamın saçı tökülən yerdən qırmızımtıl-ağ ləkə çıxarsa, bu həmin yerdə başlanan cüzamdır. ");
INSERT INTO azb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kahin oraya baxsın, saçı tökülmüş yerdəki şiş qırmızımtıl-ağdırsa və cüzam kimi görünürsə, ");
INSERT INTO azb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","o kişi iyrənc xəstəliyə tutulduğu üçün murdar sayılsın. Başındakı əlamətə görə kahin mütləq onu murdar elan etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Belə iyrənc xəstəliyə tutulan adamın geyimləri cırıq, saçı isə dağınıq olmalıdır. O adam üzünün aşağı hissəsini örtüb “Murdaram! Murdaram!” deyə çığırsın. ");
INSERT INTO azb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Dərisində əlamət olduğu bütün müddət o murdar sayılsın. Murdarlığına görə düşərgədən kənarda tək yaşasın. ");
INSERT INTO azb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Üstündə iyrənc kif əlaməti olan hər cür parça: yun ya da kətan geyim ");
INSERT INTO azb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","yaxud hər cür toxunma parça yaxud dəri və hər dəri məmulatı haqqında təlimat budur. ");
INSERT INTO azb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Ya geyimdə, dəridə ya da hər cür parçada, dəridən düzəlmiş hər bir əşyada əmələ gələn əlamət yaşıltəhər və ya qırmızımtıl olsa, bu, iyrənc kif əlamətidir. Qoy bu, kahinə göstərilsin. ");
INSERT INTO azb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kahin ona baxıb, əşyanı yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Yeddinci gün yenə də ona baxıb görsə ki, geyimə, parçaya, dəriyə yaxud dəridən düzəlmiş məmulata əlamət yayılıb, bu əlamət təhlükəli iyrənc kifdir, murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Üstündə əlamət olan yun ya da kətan geyimi yaxud parçanı yaxud dəridən olan əşyanı kahin yandırsın. Bu, iyrənc təhlükəli kifdir, yandırılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Amma əgər kahin baxıb görsə ki, geyimə, parçaya yaxud dəridən olan əşyaya əlamət yayılmayıb, ");
INSERT INTO azb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","kahin əmr versin ki, üstündə əlamət olan hər şey yuyulsun. Sonra onu yenə də yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Əlamət yuyulduqdan sonra kahin yenə də o şeyə baxsın. Əlamət yayılmadığı halda görkəmini dəyişməyibsə, o şey murdar sayılsın. Əlamət istər ön, istərsə arxa tərəfindən olsun, onu yandırmalısınız. ");
INSERT INTO azb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Lakin kahin baxıb görsə ki, əlamət yuyulduqdan sonra rəngi solub, qoy onu geyimdən, dəridən yaxud parçadan qopartsın. ");
INSERT INTO azb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Əgər bundan sonra əlamət geyimdə, parçada yaxud dəri əşyada yenidən əmələ gələrsə, o əşyanın sahibi onu yandırsın. ");
INSERT INTO azb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Yuyulduqdan sonra əlamət üstündən yox olan paltar, parça yaxud dəri əşya yenə də yuyulub pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Bu, yun və ya kətan geyimdə, hər toxunma parçada və dəridən olan hər əşyada əmələ gələn iyrənc kif əlamətinə əsasən onu pak ya murdar saymaq üçün təlimatdır». ");
INSERT INTO azb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Dərisində cüzam olan adamın paklanması haqqında təlimat budur. Bu adam kahinin yanına gətirildikdə ");
INSERT INTO azb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kahin düşərgədən kənara çıxıb cüzama tutulan xəstəyə baxsın; onun dərisindəki əlamətlər sağalıbsa, ");
INSERT INTO azb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","onda qoy kahin paklanan adam üçün iki pak diri quş, sidr ağacının budağı, al rəngli ip və züfa otu gətirməyi əmr etsin. ");
INSERT INTO azb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kahinin buyurduğuna görə quşların biri saxsı qabda axar su üzərində kəsilsin. ");
INSERT INTO azb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Sonra kahin sağ qalan quşu, sidr ağacının budağını, al rəngli ipi və züfa otunu götürüb, axar suyun üzərində kəsilən quşun qanına batırsın. ");
INSERT INTO azb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Sonra qoy cüzamdan paklanan adamın üstünə yeddi dəfə qanı çiləyib onu pak elan etsin. Sağ qalan quşu çölə buraxsın. ");
INSERT INTO azb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Paklanan adam geyimlərini yusun, özünü bütünlüklə qırxsın, su ilə yuyunsun; sonra pak sayılsın və düşərgəyə girsin. Amma o, yeddi gün ərzində öz çadırından kənarda yaşasın. ");
INSERT INTO azb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Yeddinci gün o adam saçını, saqqalını, qaşlarını, bədənindəki bütün tüklərini qırxsın, geyimini yusun, bədənini su ilə yusun, sonra pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Səkkizinci gün o adam qüsursuz iki erkək toğlu, birillik qüsursuz dişi toğlu, taxıl təqdimi olaraq bir efanın onda üç hissəsi miqdarında zeytun yağı ilə yoğrulmuş un və bir loq zeytun yağı gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Paklanma mərasimi ilə məşğul olan kahin paklanan adamı və gətirdiyi təqdimləri Rəbbin hüzuruna – Hüzur çadırının girişinə gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kahin erkək toğluların birini götürüb zeytun yağı ilə təqsir qurbanı kimi təqdim etsin. Onları Rəbbin hüzurunda yellədərək təqdim etsin. ");
INSERT INTO azb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Toğlunu günah qurbanı və yandırma qurbanı kəsdiyi yerdə – müqəddəs sayılan yerdə kəssin; çünki günah qurbanı kimi təqsir qurbanı da kahinə aiddir. O qurban ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Sonra kahin təqsir qurbanının qanından bir az götürüb paklanan adamın sağ qulağının mərcəyinə, sağ əlinin və sağ ayağının baş barmağına çəksin. ");
INSERT INTO azb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kahin bir az zeytun yağı götürüb sol ovcuna töksün və ");
INSERT INTO azb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","sağ əlinin bir barmağını sol ovcundakı zeytun yağına batıraraq Rəbbin hüzurunda yeddi dəfə çiləsin. ");
INSERT INTO azb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ovcunda qalan yağdan kahin paklanan adamın sağ qulaq mərcəyinə, sağ əlinə və sağ ayağının baş barmağına, yəni təqsir qurbanının qanından çəkdiyi yerlərə sürtsün. ");
INSERT INTO azb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kahin ovcundakı yağın qalan hissəsini bu adamın başına çəkib bununla onun üçün Rəbbin önündə kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Bundan sonra kahin günah qurbanını kəssin. Bununla paklanan adam üçün murdarlığını kəffarə etsin. Sonra isə yandırma qurbanını kəsib ");
INSERT INTO azb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","onunla taxıl təqdimini qurbangahda təqdim etsin. Beləcə kahin o adam üçün kəffarə etsin ki, o pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Əgər o adam yoxsuldur və bu təqdimlərə gücü çatmırsa, özünün kəffarəsi üçün yellədilən təqsir qurbanı kimi bir erkək toğlu, taxıl təqdimi kimi zeytun yağı ilə yoğrulmuş onda bir efa narın unla bir loq zeytun yağı, ");
INSERT INTO azb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","biri günah qurbanı, o biri yandırma qurbanı olaraq iki qumru quşu yaxud iki göyərçin götürsün. Bunlara gücü çatar. ");
INSERT INTO azb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Paklanmasının səkkizinci günü bu adam bunları kahinin yanına, Hüzur çadırının girişinə – Rəbbin hüzuruna gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kahin təqsir qurbanı olan toğlunu və bir loq zeytun yağını götürüb yelləmə təqdimi olaraq Rəbbin hüzurunda yelləsin və ");
INSERT INTO azb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","təqsir qurbanı olan toğlunu kəssin. Sonra kahin təqsir qurbanının qanından bir az götürüb paklanan adamın sağ qulaq mərcəyinə və sağ əli ilə sağ ayağının baş barmaqlarına çəksin. ");
INSERT INTO azb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kahin zeytun yağından bir az sol ovcuna töksün ");
INSERT INTO azb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","və sağ əlinin bir barmağı ilə sol ovcundakı yağdan Rəbbin hüzurunda yeddi dəfə çiləsin. ");
INSERT INTO azb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ovcundakı yağdan paklanan adamın sağ qulaq mərcəyinə, sağ əlinin və sağ ayağının baş barmağına, yəni təqsir qurbanının qanını çəkdiyi yerlərə çəksin. ");
INSERT INTO azb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Kahin ovcundakı yağın qalan hissəsini bu adamın başına çəksin. Bununla o adam üçün Rəbbin önündə kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sonra bu adam gücü çatan qədər qumru quşlarından ya göyərçinlərdən birini təqdim etsin. ");
INSERT INTO azb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Gücü çatan qədər birini günah qurbanı kimi, o birisini isə taxıl təqdimi ilə birgə yandırma qurbanı kimi təqdim etsin. Beləcə kahin paklanan adam üçün Rəbbin önündə kəffarə etsin». ");
INSERT INTO azb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Bu, dərisində cüzamın əlaməti olub paklanmasına gücü çatmayan adam üçün təlimatdır. ");
INSERT INTO azb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Sizə mülk olaraq verəcəyim Kənan torpağına girəndən sonra Mən ölkənizdə olan bir evə iyrənc kif əlaməti göndərsəm, ");
INSERT INTO azb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","qoy ev sahibi gedib kahinə “evimdə kifə bənzər bir şey görünüb” deyə xəbər versin. ");
INSERT INTO azb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kahin kifə baxmazdan əvvəl evi boşaltmağı əmr etsin ki, evdə hər bir əşya murdar sayılmasın, sonra o evə baxmağa getsin. ");
INSERT INTO azb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Əlamətə baxsın: evin divarlarında yaşıltəhər yaxud qırmızımtıl, divarın səthindən dərin görünən ləkələr varsa, ");
INSERT INTO azb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","kahin evdən çıxsın və onu bağlayıb yeddi gün müddətinə təcrid etsin. ");
INSERT INTO azb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Yeddinci gün kahin yenə də gəlib baxsın. Əlamət evin divarına yayılıbsa, ");
INSERT INTO azb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","onda əmr etsin ki, kifli daşlar qoparılsın və şəhərdən kənara – murdar yerə atılsın. ");
INSERT INTO azb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Sonra evin içinin hər tərəfini qaşıyıb təmizləsinlər və qaşıdıqları malanı şəhərdən kənara – həmin murdar yerə töksünlər. ");
INSERT INTO azb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Qoparılmış daşların yerinə başqa daşları götürüb qoysunlar, sonra təzə mala götürüb evi malalasınlar. ");
INSERT INTO azb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Əgər daşları qopardıqdan və evi qaşıyıb malalayandan sonra yenə də evdə kif əlaməti əmələ gəlsə, ");
INSERT INTO azb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kahin gedib baxsın. Əlamət evə yayılıbsa, evdə olan təhlükəli, iyrənc kif budur və o murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Belə halda qoy ev sökülsün, onun daşları, taxtaları, bütün malası şəhərdən kənara – murdar yerə atılsın. ");
INSERT INTO azb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ev bağlı olduğu vaxt ərzində evə girən hər bir adam axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","O evdə yeyən yaxud yatan adam geyimlərini yusun. ");
INSERT INTO azb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ev malalanandan sonra kahin gəlib evə baxanda görsə ki, əlamət evə yayılmayıb, o, evi pak elan etsin, çünki kif keçib gedib. ");
INSERT INTO azb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","O, evi pak etmək üçün iki quş, sidr ağacının budağı, al rəngli ip və züfa otunu götürüb ");
INSERT INTO azb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","quşların birini saxsı qabda axar su üzərində kəssin. ");
INSERT INTO azb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Sonra kahin sidr ağacının budağını, züfanı, al rəngli ipi və sağ qalan quşu götürüb kəsilən quşun qanına və axar suya batırsın, evə yeddi dəfə çiləyərək ");
INSERT INTO azb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","quşun qanı, axar su, sağ qalan quş, sidr ağacının budağı, züfa otu və al rəngli iplə o evi pak etsin. ");
INSERT INTO azb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Qoy kahin sağ qalan quşu şəhərdən kənara – çölə buraxsın. Beləcə o evi kəffarə etsin ki, o pak sayılsın». ");
INSERT INTO azb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Bu, hər cür cüzam, qotur, ");
INSERT INTO azb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","geyimlərdə və evlərdə əmələ gələn iyrənc kif, ");
INSERT INTO azb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","şiş, səpki və ləkə, ");
INSERT INTO azb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","belə cüzamın nə vaxt murdar, nə vaxt pak sayılması barədə müəyyən edən təlimatdır. ");
INSERT INTO azb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«İsrail övladlarına belə deyin: “Bir nəfərin xəstəliyə görə bədən axıntısı olarsa, o murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Xəstəliyə görə bədən axıntısı istər sərbəst axsın, istərsə də qatılaşsın, o şəxs murdar sayılır. ");
INSERT INTO azb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Üstündə yatdığı hər yataq və oturduğu hər şey murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kim onun yatağına toxunarsa, geyimini yusun, su ilə yuyunsun; sonra axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Xəstəliyə görə bədən axıntısı olan şəxs üstündə oturduğu əşyanın üstündə oturan hər kəs də geyimlərini yusun, su ilə yuyunsun, sonra axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Xəstəliyə görə bədən axıntısı olan şəxsin bədəninə toxunan hər kəs də geyimini yusun və özü su ilə yuyunsun, sonra axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Xəstəliyə görə bədən axıntısı olan şəxs pak adama tüpürsə, o adam geyimini yusun, su ilə yuyunsun. O, axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Xəstəliyə görə bədən axıntısı olan şəxsin mindiyi hər yəhər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Onun altında olmuş hər şeyə toxunan hər kəs də geyimlərini yusun, su ilə yuyunsun, sonra axşama qədər murdar sayılsın; belə şey daşıyan hər kəs də geyimini yusun. ");
INSERT INTO azb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Xəstəliyə görə bədən axıntısı olan şəxs əllərini yumamış kimə toxunarsa, o adam geyimlərini yusun və su ilə yuyunsun, sonra axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Xəstəliyə görə bədən axıntısı olan şəxsin toxunduğu hər saxsı qab sındırılsın, taxta qab isə su ilə yuyulsun. ");
INSERT INTO azb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Bu adam öz axıntısı kəsildiyi halda paklanmaq üçün yeddi gün gözləsin, geyimini yusun, bədənini axar su ilə yusun, sonra pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Səkkizinci gün iki qumru quşu ya iki göyərçin götürüb Rəbbin hüzuruna – Hüzur çadırının girişinə gəlsin və bunları kahinə versin. ");
INSERT INTO azb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kahin quşların birini günah qurbanı, o birini isə yandırma qurbanı kimi təqdim etsin. Bunlarla kahin o şəxs üçün axıntısına görə Rəbbin önündə kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Toxumu tökülən hər kişi bütün bədənini su ilə yusun, sonra axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Üstünə toxum tökülüb bulaşan hər geyim ya da dəri əşya yuyulsun, sonra axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kişi qadınla yaxınlıq edəndə toxumu tökülsə, hər ikisi su ilə yuyunsun. Sonra onlar axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Aybaşı vaxtı qanaxması olan hər qadın yeddi gün murdar sayılsın, ona toxunan hər kəs isə axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Aybaşı müddəti qadın nəyin üzərində uzanıb və yaxud otursa, hər şey murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","O qadının yatağına toxunan hər kəs öz geyimlərini yusun, su ilə yuyunsun və axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","O qadının oturduğu hər şeyə toxunan hər kəs də geyimlərini yusun, su ilə yuyunsun, sonra axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Əgər bir adam o qadının yatağına ya üstündə oturduğu şeyə toxunsa, o adam axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Əgər kişi qadınla yaxınlıq edən zaman qadın aybaşı görsə və kişi onunla bulaşsa, kişi də yeddi gün murdar sayılsın; kişinin yatdığı hər yataq da murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Bir qadının aybaşı vaxtından kənar ya da sonra neçə gün davam edən qanaxması olarsa, bütün bu axıntı müddəti aybaşı murdarlığı dövründəki kimi murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Bütün axıntı vaxtı aybaşı murdarlığı vaxtı kimi üstündə yatdığı yataq və oturduğu hər şey murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Onlara toxunan hər kəs də murdar sayılsın. Qoy o, geyimini yusun, su ilə yuyunsun və axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Əgər axıntısı kəsilsə, o qadın yeddi gün gözləsin, sonra pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Səkkizinci gün həmin o qadın iki qumru quşu yaxud iki göyərçin götürüb Hüzur çadırının girişinə, kahinin yanına gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kahin quşların birini günah qurbanı, o birisini isə yandırma qurbanı kimi təqdim etsin. Bunlarla kahin bu qadın üçün axıntısının murdarlığını Rəbbin önündə kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Beləcə İsrail övladlarını öz murdarlığından ayırın ki, aralarında olan Mənim məskənimi murdarlığı ilə murdar edib ölməsinlər”». ");
INSERT INTO azb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Bu təlimat xəstəliyə görə bədən axıntısı olan adamlar üçün, toxumu tökülməklə murdarlanan hər kişi üçün, ");
INSERT INTO azb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","aybaşı olub murdarlanan hər qadın üçün, axıntı növünə görə olan hər kişi və hər qadın üçün, murdar qadınla yaxınlıq edən hər kişi üçündür. ");
INSERT INTO azb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Harunun iki oğlu Rəbbin hüzuruna yaxınlaşıb öləndən sonra Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«Qardaşın Haruna söylə ki, istənilən vaxt pərdənin iç tərəfindəki Müqəddəs yerə, sandıq üzərindəki kəffarə qapağının önünə keçməsin ki, özü ölməsin, çünki Mən kəffarə qapağının üzərindəki buludda zahir oluram. ");
INSERT INTO azb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Buna görə Harun Müqəddəs yerə yalnız belə girə bilər: günah qurbanı üçün bir buğa və yandırma qurbanı üçün bir qoç götürsün; ");
INSERT INTO azb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","müqəddəs kətan xirqə geysin, əynində kətan alt paltarı da olsun, belinə kətan qurşaq bağlasın, başına çalma qoysun. Bunlar müqəddəs geyimlərdir. Qoy Harun əvvəl bədənini su ilə yusun, sonra onları geysin. ");
INSERT INTO azb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","İsrail övladlarının icmasından günah qurbanı iki təkə və yandırma qurbanı üçün bir qoç götürsün. ");
INSERT INTO azb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Harun özü üçün günah qurbanı olan buğanı təqdim etsin. Bununla həm özü, həm də ailəsi üçün günahını kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Sonra Harun iki təkəni götürüb Rəbbin önündə Hüzur çadırının girişində saxlasın. ");
INSERT INTO azb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Harun bu təkələrdən birini Rəbb üçün, o birisini Azazel üçün püşklə seçsin. ");
INSERT INTO azb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Sonra Harun püşklə Rəbbə məxsus olan təkəni günah qurbanı olaraq təqdim etsin. ");
INSERT INTO azb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Püşklə Azazel olmaq üçün seçilən təkəni isə Rəbbin önündə diri saxlasın ki, onu sonra Azazel olaraq çölə göndərib onunla kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Harun özü ilə ailəsi üçün kəffarə edən günah qurbanını – buğanı kəssin. ");
INSERT INTO azb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Rəbbin hüzurundan, qurbangahdan gətirilən közərmiş kömürlə dolmuş bir buxurdan götürüb, iki ovuc dolu narın əzilən xoş ətirli buxurla pərdənin iç tərəfinə keçsin. ");
INSERT INTO azb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Rəbbin hüzurunda buxuru oda qoysun. Beləcə buxur tüstüsü bulud ilə Şəhadət sandığının üzərində olan kəffarə qapağını örtsün ki, özü ölməsin. ");
INSERT INTO azb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Buğanın qanından götürüb barmağı ilə qapağın ön tərəfinə – qapağın qarşısına da yeddi dəfə çiləsin. ");
INSERT INTO azb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Sonra xalq üçün günah qurbanı olan təkəni kəssin və onun qanını pərdənin iç tərəfinə gətirib qanını buğanın qanı kimi kəffarə qapağının ön tərəfinə və qarşısına çiləsin. ");
INSERT INTO azb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Bununla Harun İsrail övladlarının murdarlığına, qanunsuzluğuna və bütün günahlarına görə Müqəddəs yer üçün kəffarə etsin; murdar xalqın arasında yerləşdiyinə görə Hüzur çadırı üçün belə etsin. ");
INSERT INTO azb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Müqəddəs yerdə kəffarə etməyə girəndən çıxana qədər Hüzur çadırında da heç kim olmasın. Harun özü, ailəsi və bütün İsrail camaatı üçün kəffarə edib ");
INSERT INTO azb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","çıxsın, sonra Rəbbin önündə olan qurbangaha gedib onun üçün kəffarə etsin; buğanın və təkənin qanından götürüb qurbangahın buynuzlarının ətrafına çəksin. ");
INSERT INTO azb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Harun qurbangahın üstünə barmağı ilə yeddi dəfə qan çiləsin. Beləcə onu İsrail övladlarının murdarlığından pak edib təqdis edin. ");
INSERT INTO azb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Qoy Harun Müqəddəs yeri, Hüzur çadırını, qurbangahı kəffarə edib qurtarandan sonra sağ qalan təkəni gətirsin ");
INSERT INTO azb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","və iki əlini o təkənin başına qoyub İsraillilərin bütün qanunsuzluğundan və günahlarından ötrü qazandığı cəzanın hamısını onun üzərində etiraf etsin və təkənin başına ötürsün. Sonra bu iş üçün təyin olunan bir adamın vasitəsilə çöldə yola salınsın. ");
INSERT INTO azb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Təkə onların bütün cəzasını öz üzərində ayaq dəyməmiş torpağa aparsın. O adam təkəni çöldə yola salsın. ");
INSERT INTO azb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Harun Hüzur çadırına girsin və Müqəddəs yerə girən zaman geymiş olduğu kətan geyimi çıxarıb orada qoysun. ");
INSERT INTO azb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Müqəddəs bir yerdə bədənini su ilə yusun və öz geyimini geysin. Oradan çıxıb öz yandırma qurbanını və xalqın yandırma qurbanını təqdim etsin. ");
INSERT INTO azb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Günah qurbanının piyini də qurbangahda tüstülədib yandırsın. ");
INSERT INTO azb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Azazel olan təkəni yola salan adam da geyimini və bədənini su ilə yusun, sonra düşərgəyə girsin. ");
INSERT INTO azb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Müqəddəs yerdə kəffarə etmək üçün qanı oraya gətirilən günah qurbanı olan buğa ilə təkənin dəri, ət və bağırsaqları düşərgənin kənarına aparılıb yandırılsın. ");
INSERT INTO azb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Onları yandıran adam geyimini, bədənini su ilə yusun, ondan sonra düşərgəyə girsin. ");
INSERT INTO azb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Bu sizin üçün əbədi bir qayda olsun. Yeddinci ayın onuncu günündə özünüzü hər şeydən məhrum edib heç bir iş görməyin; həm yerliləriniz, həm də aranızda yaşayan yadellilər belə etsin. ");
INSERT INTO azb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Çünki o gün sizin üçün kəffarə olunacaq ki, siz pak olasınız və Rəbbin hüzurunda bütün günahlarınızdan təmizlənəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","O gün sizin üçün Şənbə gününə bənzər istirahət günüdür. Özünüzü hər şeydən məhrum edin. Bu, əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Atasının yerinə kahinlik etmək üçün məsh edilmiş vəzifəli baş kahin belə kəffarə etsin: o, müqəddəs kətan geyimlərini geyib ");
INSERT INTO azb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ən Müqəddəs yer, Hüzur çadırı, qurbangah üçün kəffarə etsin; kahinlər və camaatın hər biri üçün də kəffarə etsin. ");
INSERT INTO azb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","İldə bir dəfə İsrail övladlarının bütün günahlarının kəffarə edilməsi üçün bu sizə əbədi qayda olsun». Rəbbin Musaya əmr etdiyi kimi oldu. ");
INSERT INTO azb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Harunla oğullarına və bütün İsrail övladlarına söylə: “Rəbbin əmri budur: ");
INSERT INTO azb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","İsraillilərdən düşərgədə yaxud onun kənarında mal-qara, qoyun ya da keçi kəsən ");
INSERT INTO azb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","onu Rəbbin məskəninə, Onun önünə qurban kimi təqdim edərək Hüzur çadırının girişinə gətirməyən hər kəs qan tökməkdə müqəssir sayılsın. Belə adam xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Belə ki İsrail övladları qurbanlarını çöldə kəsmək əvəzinə onları Rəbbin hüzuruna, Hüzur çadırının girişinə, kahinin yanına gətirsinlər və Rəbbə ünsiyyət qurbanları olaraq kəssinlər. ");
INSERT INTO azb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kahin belə qurbanın qanını Hüzur çadırı girişinin yanındakı Rəbbin qurbangahına səpsin, piyini isə Rəbbin xoşuna gələn ətir kimi tüstülədib yandırsın. ");
INSERT INTO azb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","İsrail övladları bir daha Rəbbə xəyanət edib heç vaxt təkə görkəmində bütlərə qurban kəsməsinlər. Bu, nəsildən-nəslə onlar üçün əbədi qayda olsun”. ");
INSERT INTO azb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Bir də ki onlara de: “İsrail övladlarından yaxud aralarında yaşayan yadellilərdən kim yandırma qurbanını və ya ünsiyyət qurbanını kəsəndə ");
INSERT INTO azb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Rəbbin hüzuruna təqdim edərək Hüzur çadırının girişinə qurban gətirməyən hər adam xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","İsrail övladlarından ya da aralarında yaşayan yadellilərdən bir az da olsa, qan yeyən hər kəsdən Mən üz döndərib xalqı arasından qovacağam, ");
INSERT INTO azb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","çünki hər məxluqa həyat verən qandır. Mən onu həyatınızın kəffarəsi üçün qurbangahda təqdim olunmağa təyin etmişəm; çünki həyat verdiyinə görə kəffarə edən qandır. ");
INSERT INTO azb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Buna görə də Mən İsrail övladlarına demişəm: ‹Sizdən heç bir kəs, aranızda yaşayan yadelli də qan yeməsin›. ");
INSERT INTO azb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","İsrail övladlarından ya da aralarında yaşayan yadellilərdən yeyilə bilən heyvan yaxud quş ovlayan insan onun qanını yerə axıdıb torpaqla örtsün. ");
INSERT INTO azb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Çünki hər məxluqa həyat verən onun qanıdır. Buna görə Mən İsrail övladlarına ‹heç bir məxluqun qanını yeməyin› demişəm. Çünki hər məxluqa həyat verən onun qanıdır. Onu yeyən hər kəs xalqının arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Yerli olsun, yadelli olsun, təbii yolla ölən, parçalanıb ölən heyvanı yeyən adam qoy geyimini yusun, su ilə yuyunsun və axşamadək murdar, sonra pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Əgər belə adam geyimini və bədənini yumasa, cəzasını çəkəcək”». ");
INSERT INTO azb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«İsrail övladlarına belə de: “Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nə əvvəl yaşadığınız Misir torpağının ənənələrinə əməl edin, nə də sizi aparacağım Kənan torpağına girəndən sonra adət-ənənələrinə əməl edib uymayın; ");
INSERT INTO azb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mənim hökmlərimə əməl edib qanunlarıma riayət edin, onlara uyğun yaşayın. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Qaydalarıma və hökmlərimə səylə əməl edin; onları yerinə yetirən adam bunların sayəsində yaşayacaq. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Qoy heç kəs öz yaxın qohumları ilə cinsi əlaqədə olmaq üçün onlara yaxınlaşmasın. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Atanla cinsi əlaqədə olma, ananla da cinsi əlaqədə olma; o sənin anandır, onunla cinsi əlaqədə olma. ");
INSERT INTO azb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Atanın arvadı ilə cinsi əlaqədə olma, çünki o sənin atanın namusudur. ");
INSERT INTO azb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Atabir yaxud anabir bacınla, səninlə bir evdə yaxud başqa yerdə böyümüş bacınla cinsi əlaqədə olma. ");
INSERT INTO azb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Öz oğlunun qızı yaxud qızının qızı ilə cinsi əlaqədə olma, çünki onların namusu sənin namusundur. ");
INSERT INTO azb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Atanın başqa arvadından doğulan qızı ilə cinsi əlaqədə olma; o sənin bacındır. ");
INSERT INTO azb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Bibinlə cinsi əlaqədə olma, çünki o, atanın yaxın qohumudur. ");
INSERT INTO azb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Xalanla cinsi əlaqədə olma, çünki o, ananın yaxın qohumudur. ");
INSERT INTO azb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Əminin namusunu tapdalama, onun arvadı ilə yaxınlıq etmə, çünki o sənin əmiarvadındır. ");
INSERT INTO azb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Oğlunun arvadı ilə cinsi əlaqədə olma. Oğlunun arvadı olduğu üçün onunla cinsi əlaqədə olma. ");
INSERT INTO azb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Qardaşının arvadı ilə cinsi əlaqədə olma, çünki bu, qardaşının namusudur. ");
INSERT INTO azb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Bir qadının həm özü, həm də qızı ilə cinsi əlaqədə olma. O qadının oğul ya da qız nəvəsi ilə cinsi əlaqədə olmaq üçün onları alma, çünki onlar sənin yaxın qohumların olduğu üçün bu, əxlaqsızlıqdır. ");
INSERT INTO azb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Arvadın sağ ikən onun bacısını günü olaraq alma və onunla cinsi əlaqədə olma. ");
INSERT INTO azb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Aybaşı murdarlığı zamanı qadınla cinsi əlaqədə olmaq üçün onunla yaxınlıq etmə. ");
INSERT INTO azb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Başqasının arvadı ilə yaxınlıq edib özünü murdarlama. ");
INSERT INTO azb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Övladlarının heç birini Molekə qurban olaraq təqdim etmə. Beləliklə, Allahının adını ləkələmə. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Kişi qadınla yaxınlıq etdiyi kimi kişi ilə yaxınlıq etməsin, bu, iyrəncdir. ");
INSERT INTO azb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Nə kişi, nə də qadın heç bir heyvanla cinsi əlaqəyə girib özünü murdarlamasın. Bu, rəzillikdir. ");
INSERT INTO azb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Bu şeylərin heç biri ilə özünüzü murdar etməyin, çünki önünüzdən qovacağım millətlər bunların hamısı ilə murdarlanıb, ");
INSERT INTO azb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","torpaqlarını da murdarlayıblar. Buna görə də Mən o torpağı cəzalandırıb sakinlərini oradan rədd edirəm. ");
INSERT INTO azb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","İstər yerli, istər aranızda yaşayan yadelli – hamınız qaydalarıma və hökmlərimə riayət edərək iyrənc işlərin heç birinə əməl etməyin. ");
INSERT INTO azb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Önünüzdəki ölkənin sakinləri bütün bu iyrənc işləri edərək torpağı murdarlayıblar. ");
INSERT INTO azb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Əgər siz də bu torpağı murdarlasanız, torpaq sizdən əvvəlki milləti ağzından qaytardığı kimi sizi də ağzından qaytaracaq. ");
INSERT INTO azb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Buna görə də bu iyrənc işlərin hər hansı birinə əməl edən hər kəs xalqının arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Beləliklə, önünüzdə edilən iyrənc adətlərinə əməl edib onlarla özünüzü murdar etməmək üçün Mənim buyruğuma riayət edin. Allahınız Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Bütün İsrail övladlarının icmasına bəyan edib de: “Müqəddəs olun, çünki Mən Allahınız Rəbb müqəddəsəm. ");
INSERT INTO azb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Sizdən hər kəs atasına və anasına hörmət etsin və Mənim Şənbə günlərimə riayət etsin. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Bütlərə tərəf dönməyin və özünüzə tökmə allahlar düzəltməyin. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Rəbbə ünsiyyət qurbanları gətirəndə elə gətirin ki, qurbanınız qəbul edilsin. ");
INSERT INTO azb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Qurbanınız kəsilən gün yaxud ertəsi gün yeyilsin, üçüncü günə qalan hissəsi yandırılsın. ");
INSERT INTO azb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Əgər ondan üçüncü gün yeyilsə, o qurban qəbul olunmaz, iyrənc sayılar. ");
INSERT INTO azb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","O qurbanı yeyən adam Rəbbin müqəddəs yeməyini murdar etdiyinə görə cəzasını çəkər. Qoy o, xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Torpağınızda məhsul biçəndə tarlanın qıraq-bucaqlarını biçməyin və biçindən düşən başaqları yığmayın. ");
INSERT INTO azb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Üzüm bağında da tənəkləri büsbütün təmizləyib yerə düşən salxımları yığmayın. Qalan məhsul kasıblara və qəriblərə qalsın. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Oğurlamayın, bir-birinizə yalan satıb aldatmayın. ");
INSERT INTO azb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Allahınızın adını ləkələməmək üçün adıma yalandan and içməyin. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Qonşunu istismar etmə, onu soyma; muzdlu işçinin zəhmət haqqını axşamdan səhərəcən özündə saxlama. ");
INSERT INTO azb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Kar adamı söymə və kor adamın qarşısına büdrədən heç bir şey qoyma. Allahından qorx. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Məhkəmədə haqsızlıq etməyin. Nə yoxsula üstünlük ver, nə də varlıya meyl sal, amma bir-birinizi ədalətlə mühakimə edin. ");
INSERT INTO azb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Xalq arasında xəbərçilik etmə; qonşunun qanının tökülməsini istəmə. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Soydaşına qarşı ürəyində nifrət bəsləmə. Başqa adamı mütləq tənbeh et ki, sən də günahının cəzasını çəkməyəsən. ");
INSERT INTO azb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Öz xalqından heç kəsdən qisas alma, heç kimə qarşı kin saxlama. Ancaq qonşunu özün kimi sev. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Mənim qaydalarıma riayət edin. Başqa növlərdən olan heyvanları cütləşdirməyin. Tarlanızda iki növ toxum əkməyin. Əyninizə iki növ sapdan toxunmuş paltar geyməyin. ");
INSERT INTO azb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Bir kişi başqa kişinin nişanlı, hələ qiyməti ödənməmiş, azad olunmamış qarabaşı ilə yaxınlıq edərsə, ona cəza verilsin. Amma onlar öldürülməsinlər, çünki qarabaş azad deyil, ");
INSERT INTO azb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","o kişi isə Rəbbin önünə – Hüzur çadırının girişinə təqsir qurbanı kimi bir qoç gətirsin. ");
INSERT INTO azb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kahin o kişi üçün işlətdiyi günahını təqsir qurbanı olan qoçla Rəbbin önündə kəffarə etsin ki, bu günahı bağışlansın. ");
INSERT INTO azb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kənan torpağına girib yemək üçün hər hansı bir meyvə ağacını əksəniz, meyvəsi sizin üçün üç il haramdır, onu yeməyin. ");
INSERT INTO azb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Dördüncü ildə onun bütün meyvəsi şükür təqdimi kimi Rəbb üçün müqəddəs sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Beşinci ildə isə o ağacın meyvəsini yeyə bilərsiniz. Bunu edin ki, məhsul xeyriniz üçün artsın. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Heç bir əti qanlı-qanlı yeməyin. Baxıcılıq etməyin və gələcəyi deməyin. ");
INSERT INTO azb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Gicgahlarınızı qırxmayın, saqqallarınızın kənarlarını kəsməyin. ");
INSERT INTO azb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ölülərə görə bədəninizə yara vurmayın, bədəninizə heç bir şəkil döydürməyin. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Qoy heç kim qızını fahişəlik edib ləkələnməyə qoymasın. Qoy fahişəlik ölkəyə yayılmasın ki, ölkə əxlaqsızlıqla dolub daşmasın. ");
INSERT INTO azb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Şənbə istirahət günlərimə riayət edin və Müqəddəs məkanıma ehtiramla yanaşın. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Cindarlara və ruh çağıranlara tərəf dönməyin, onlarla danışmayın, yoxsa murdarlanarsınız. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Yaşlıların qarşısında ayağa durun, ağsaqqallara hörmət eləyin. Allahınızdan qorxun. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Sizinlə ölkənizdə yaşayan heç bir qəribə haqsızlıq etməyin. ");
INSERT INTO azb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Hamınız onu öz adamınız, yerliniz kimi qəbul edin, hər kəs onu özünü sevən kimi sevsin. Çünki siz özünüz də Misir ölkəsində qərib idiniz. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Məhkəmədə, ölçüdə, çəkidə və miqdarda haqsızlıq etməyin. ");
INSERT INTO azb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Qoy tərəziniz, çəki daşınız, taxıl və maye ölçüsü üçün işlənən qablarınız düzgün olsun. Sizi Misir torpağından çıxaran Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Bütün Mənim qaydalarıma və hökmlərimə səylə əməl edin. Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«İsrail övladlarına de: “İsraillilərdən və İsraildə yaşayan yadellilərdən övladını Molekə təqdim edən hər kəs öldürülməlidir. Qoy ölkə xalqı onu daşqalaq etsin. ");
INSERT INTO azb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Öz övladını Molekə təqdim etdiyi üçün Mən o adamdan üz döndərib xalqı arasından qovacağam; çünki o, Müqəddəs məkanımı murdarlayıb müqəddəs adımı ləkələmişdir. ");
INSERT INTO azb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Əgər ölkə xalqı o adamın övladını Molekə təqdim etdiyini görüb göz yumaraq onu öldürməsə, ");
INSERT INTO azb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Mən Özüm həmin adamdan və ailəsindən üz döndərib onu və onunla birgə Moleklə Mənə xəyanət edən hər kəsi xalqın arasından qovacağam. ");
INSERT INTO azb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Mənə xəyanət edərək cindarlara və ruh çağıranlara tərəf dönən hər kəsdən üz döndərib xalqın arasından qovacağam. ");
INSERT INTO azb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Buna görə də özünüzü təqdis edin və müqəddəs olun, çünki Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Qaydalarıma səylə əməl edin, çünki sizi təqdis edən Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Atasına yaxud anasına lənət edən hər kəs öldürülməlidir. O adam öz atasına yaxud anasına lənət etdiyi üçün qanının tökülməyinə özü baisdir. ");
INSERT INTO azb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Başqa kişinin arvadı ilə zina edənlərə aid: qonşusunun arvadı ilə zina edən kişi zinakar qadınla birlikdə öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Atasının arvadı ilə yaxınlıq edən kişi atasının namusunu tapdalamış olur. Bunu edənlərin hər ikisi öldürülməlidir. Onlar qanlarının tökülməyinə özləri baisdir. ");
INSERT INTO azb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Gəlini ilə yaxınlıq edən kişi gəlini ilə birgə – hər ikisi öldürülməlidir, çünki bu rəzillikdir. Bunlar qanlarının tökülməyinə özləri baisdir. ");
INSERT INTO azb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kişi qadınla yaxınlıq etdiyi kimi kişi kişi ilə yaxınlıq edərsə, hər ikisi iyrənc iş görür və onlar öldürülməlidirlər; qanlarının tökülməyinə özləri baisdir. ");
INSERT INTO azb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Qadınla bərabər anasını arvad alan kişi əxlaqsızlıq edər; aranızda belə əxlaqsızlıq olmamaq üçün o kişi də, o qadınlar da yandırılsın. ");
INSERT INTO azb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Heyvanla cinsi əlaqəyə girən kişi öldürülməlidir; heyvan isə kəsilməlidir. ");
INSERT INTO azb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Hər hansı bir heyvanla cinsi əlaqəyə girən qadın heyvanla birgə öldürülməlidir. Bunlar qanlarının tökülməyinə özləri baisdir. ");
INSERT INTO azb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Əgər bir kişi atabir yaxud anabir bacısını alıb onunla cinsi əlaqədə olsa, qadın da onunla cinsi əlaqədə olsa, bu, rüsvayçılıqdır. Onlar xalqı arasından qovulsun. Bacısı ilə cinsi əlaqədə olan kişi cəzasını çəkər. ");
INSERT INTO azb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Əgər bir kişi aybaşı olan qadınla yaxınlıq edib onunla cinsi əlaqədə olarsa, qadının qanaxma mənbəyinin üstünü açar, qadın da öz qanaxma mənbəyinin üstünü açar. Hər ikisi xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Xalanla yaxud bibinlə yaxınlıq etmə, çünki yaxın qohumları ilə yaxınlıq edənlər cəzasını çəkərlər. ");
INSERT INTO azb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Əmisi arvadı ilə yaxınlıq edən kişi öz əmisinin namusunu tapdalamış olur; ikisi də günahının cəzasını çəkərək övladları olmadan öləcəklər. ");
INSERT INTO azb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Qardaşı arvadını alan kişi qardaşının namusunu tapdalayaraq murdar iş görür; onlar sonsuz qalacaqlar. ");
INSERT INTO azb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Siz Mənim qaydalarıma və hökmlərimə səylə əməl edin ki, yaşamaq üçün aparacağım torpaq sizi rədd etməsin. ");
INSERT INTO azb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Qarşınızdan qovacağım millətlərin adətlərinə uymayın; onlar bütün bu şeyləri etdiklərinə görə Mənim gözümdə iyrəncdirlər. ");
INSERT INTO azb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mən sizə dedim ki, onların torpağına siz sahib olacaqsınız; Mən o süd və bal axan torpağı sizə irs olaraq verəcəyəm. Sizi digər xalqlardan ayıran Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Beləliklə, siz pak və murdar heyvan və quşları bir-birindən ayırd edin. Sizin üçün ayırd etdiyim murdar sayılan heyvanlar yaxud quşlar ya da yerdə sürünən məxluqlarla özünüzü iyrənc etməyin. ");
INSERT INTO azb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Siz Mənim üçün müqəddəs olun, çünki Mən Rəbb müqəddəsəm. Mən sizi digər xalqlardan ayırdım ki, siz Mənim xalqım olasınız. ");
INSERT INTO azb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Cindar yaxud ruh çağıran kişilər və ya qadınlar öldürülməlidir, onlar daşqalaq olmalıdır. Bunlar qanlarının tökülməyinə özləri baisdir”». ");
INSERT INTO azb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Rəbb Musaya dedi: «Harun nəslindən olan kahinlərə bəyan edib belə de: “Qoy kahinlər öz xalqı arasından olan hər hansı bir meyitə görə özlərini murdar etməsin; ");
INSERT INTO azb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ancaq kahinin yaxın qohumu – anası, atası, oğlu, qızı, qardaşı ");
INSERT INTO azb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","yaxud da yanında yaşayan subay bacısı ölsə, kahin o ölüyə görə özünü murdar etməsin. ");
INSERT INTO azb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Qoy o, xalq arasında başçı olduğuna görə özünü murdar edib ləkələməsin. ");
INSERT INTO azb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Qoy kahinlər yas tutaraq başının heç bir hissəsini qırxmasın, saqqalının kənarını kəsməsin, bədənlərinə də yara vurmasınlar, ");
INSERT INTO azb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","özlərinin Allahı üçün müqəddəs olsunlar və Onun adını ləkələməsinlər, çünki onlar özlərinin Allahına pay, Rəbb üçün yandırma təqdimi gətirirlər. Buna görə də müqəddəs olsunlar. ");
INSERT INTO azb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Kahin fahişəni yaxud ləkələnmiş və ya ərindən boşanmış qadını da arvad almasın, çünki kahin Allahı üçün müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Onu müqəddəs say, çünki Allahına gətirilən payı təqdim edən odur; o sənin üçün müqəddəs olsun, çünki Mən – sizi təqdis edən Rəbb müqəddəsəm. ");
INSERT INTO azb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Fahişəliklə ləkələnən kahin qızı atasını da ləkələdiyinə görə yandırılsın. ");
INSERT INTO azb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Qohumları üzərində olan başında məsh yağı ilə məsh olunan və müqəddəs geyimləri geyən vəzifəli baş kahin yas tutaraq nə saçını dağıtsın, nə də əynindəki geyimini cırsın. ");
INSERT INTO azb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Bu kahin heç bir meyitə, hətta ölən ata-anasına yaxınlaşıb özünü murdar etməsin. ");
INSERT INTO azb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","O, Müqəddəs məkanı tərk etməsin və Allahın Müqəddəs məkanını ləkələməsin, çünki Allahın nişanəsi olan məsh yağı üzərindədir. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Bu kahin bakirə qız alsın; ");
INSERT INTO azb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","dul, boşanmış yaxud fahişəliklə ləkələnmiş qadın yox, yalnız öz xalqından olan bakirə qız alsın ki, ");
INSERT INTO azb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","onun övladları xalqı arasında ləkəli olmasın. Onu təqdis edən Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Haruna belə söylə: “Nəsildən-nəslə övladlarından qüsuru olan adam Allahına pay təqdim etmək üçün yaxınlaşmasın. ");
INSERT INTO azb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Bunlardan heç biri bu xidmətə yaxınlaşmasın: nə kor, nə axsaq, nə eybəcər, nə əlil, ");
INSERT INTO azb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","nə əl-ayağından şikəst, ");
INSERT INTO azb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","nə qozbel, nə cırtdanboy, nə gözündə titə olan, nə xoralı yaxud dəmrovlu, nə axtalanmış adam, ");
INSERT INTO azb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","yəni kahin Harunun nəslindən bədənində hər hansı bir qüsuru olan şəxs Rəbb üçün yandırma təqdimi verməyə yaxınlaşmasın. Onun bədənində qüsur var. Buna görə də o, Allahına pay gətirmək üçün yaxınlaşmasın. ");
INSERT INTO azb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Belə adam Allahına gətirilən paydan – həm ən müqəddəs yeməkdən, həm də müqəddəs yeməkdən yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Lakin o, bədənində qüsuru olduğuna görə nə müqəddəs pərdəyə, nə də qurbangaha yaxınlaşmasın ki, Müqəddəs məkanlarımı ləkələməsin, çünki onları təqdis edən Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musa Harunla oğullarına və bütün İsrail övladlarına belə dedi. ");
INSERT INTO azb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Harunla oğullarına söylə ki, İsrail övladlarının Mənim üçün təqdis etdikləri müqəddəs şeylərlə ehtiyatlı olsunlar və müqəddəs adımı ləkələməsinlər. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Onlara de: “Nəsildən-nəslə İsrail övladlarının Rəbb üçün təqdis etdikləri müqəddəs şeylərə murdar halda yaxınlaşan hər hansı bir övladınız Mənim hüzurumdan qovulsun. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Harun nəslindən iyrənc dəri xəstəliyi yaxud xəstəliyə görə bədən axıntısı olan heç kəs pak olana qədər müqəddəs yeməkdən yeməsin. Meyitə görə murdar olan şeyə toxunan hər kəs, toxumu tökülən hər kəs, ");
INSERT INTO azb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","onu murdarlayan qaynaşan heyvana və yaxud hər cür murdarlığı olan insana toxunan hər kəs də – ");
INSERT INTO azb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","belə şeylərə toxunan hər adam axşamadək bədənini yumayınca murdar sayılsın və müqəddəs yeməkdən yeməsin. ");
INSERT INTO azb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Günəş batanda isə o adam pak sayılsın, sonra müqəddəs yeməkdən yesin, çünki bu onun xörəyidir. ");
INSERT INTO azb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Murdarlanmamaq üçün kahin nə təbii yolla ölən, nə də parçalanıb ölən heyvanın ətini yesin. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Mənim buyruğuma riayət etsinlər ki, onu ləkələdikləri üçün günahının cəzasını çəkərək ölməsinlər. Onları təqdis edən Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Heç bir kənar şəxs: nə kahinin qonağı, nə də onun muzdlu işçisi müqəddəs yeməkdən yeməsin. ");
INSERT INTO azb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Lakin kahinin satın aldığı ya da evində doğulan qul o yeməkdən yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kənar adama ərə gedən kahin qızı müqəddəs təqdim yeməyindən yeməsin. ");
INSERT INTO azb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Amma dul qalmış və ya boşanmış, sonsuz qalaraq atasının evinə qayıdıb ailə üzvü kimi yaşayan kahin qızı atasının yeməyindən yeyə bilər. Lakin heç bir kənar şəxs ondan yeyə bilməz. ");
INSERT INTO azb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Bilmədən müqəddəs yeməkdən yeyən adam beşdə birini əlavə edərək əvəzini kahinə qaytarsın. ");
INSERT INTO azb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Qoy kahinlər İsrail övladlarının Rəbbə təqdim etdikləri müqəddəs yeməyi ləkələməsinlər. ");
INSERT INTO azb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Onlara bu müqəddəs yeməyi verib bunun təqsirini və cəzasını boyunlarına qoymasınlar; çünki onları təqdis edən Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Harunla oğullarına və bütün İsraillilərə belə de: “İsrail övladlarından yaxud İsraildə yaşayan yadellilərdən kimsənin yandırma qurbanı olaraq Rəbbə təqdim etdiyi hər əhdə görə təqdim və hər könüllü təqdim ");
INSERT INTO azb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","sizdən qəbul olunsun deyə ya mal-qaradan ya da qoyun-keçidən qüsursuz erkək olsun. ");
INSERT INTO azb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Qüsurlu heyvanı gətirmək olmaz, çünki belə qurban sizdən qəbul olunmaz. ");
INSERT INTO azb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kimsə Rəbbə əhdini ödəmək üçün yaxud könüllü təqdim olaraq mal-qaradan ya da qoyun-keçidən ünsiyyət qurbanı təqdim edərsə, heyvan qəbul olunsun deyə qüsursuz olsun; onun bədənində heç bir qüsur olmasın. ");
INSERT INTO azb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Rəbbə kor, yaralı, şikəst, qaysaqlı, xoralı, dəmrovlu heyvanları təqdim etməyin, Rəbb üçün yandırma təqdimi vermək üçün onları qurbangaha gətirməyin. ");
INSERT INTO azb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Mal-qaradan yaxud qoyun-keçidən çolaq yaxud qısaqıç heyvanı könüllü təqdim etmək olar, lakin əhdini ödəmək üçün o qəbul olunmaz. ");
INSERT INTO azb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Xayası zədələnmiş, əzilmiş, burulmuş ya da kəsilmiş heyvanı Rəbbə qurban gətirməyin, ölkənizdə buna yol verməyin. ");
INSERT INTO azb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Belə bir heyvanı yadellidən götürüb pay olaraq Allahınıza təqdim etməyin, çünki bu heyvan xarab və qüsurlu sayılaraq sizdən qəbul olunmaz”». ");
INSERT INTO azb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Buzov, quzu ya da oğlaq doğularsa, yeddi gün anasının yanında qalsın. Səkkizinci gündən etibarən Rəbb üçün yandırma təqdimi kimi qəbul oluna bilər. ");
INSERT INTO azb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Nə inək, nə qoyun, nə də keçi ilə balasını eyni gündə birlikdə kəsməyin. ");
INSERT INTO azb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Rəbbə təşəkkür qurbanı gətirəndə elə gətirin ki, o sizdən Rəbbə məqbul olsun. ");
INSERT INTO azb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Qurbanın əti həmin gün yeyilsin, səhərə qədər saxlanılmasın. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Mənim əmrlərimə səylə əməl edin. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mənim müqəddəs adımı ləkələməyin. Qoy İsrail övladları arasında müqəddəs tutulum. Sizi təqdis edən Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Allahınız olmaq üçün sizi Misir torpağından çıxartdım. Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«İsrail övladlarına belə de: “Rəbbin təyin etdiyi bayramlar, Mənim bayramlarım bunlardır. Bu vaxt müqəddəs toplantı çağırın: ");
INSERT INTO azb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Altı gün işinizi görün, yeddinci gün isə Şənbə istirahət və müqəddəs toplantı günüdür. Qoy Rəbbin bu Şənbə günü yaşadığınız bütün yerlərdə heç bir iş görülməsin. ");
INSERT INTO azb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Rəbbin təyin etdiyi bu müqəddəs toplantı günlərini bayramlar elan edin. ");
INSERT INTO azb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Birinci ayın on dördü axşamçağı Rəbbin Pasxa bayramıdır. ");
INSERT INTO azb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Həmin ayın on beşi Rəbbin Mayasız Çörək bayramıdır. Yeddi gün mayasız çörək yeyin. ");
INSERT INTO azb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Birinci gün müqəddəs toplantınız olsun; gündəlik işlərinizi görməyin. ");
INSERT INTO azb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Bu yeddi gün ərzində Rəbb üçün yandırma təqdimi gətirin. Yeddinci gün isə müqəddəs toplantınız olsun; gündəlik işlərinizi görməyin”». ");
INSERT INTO azb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«İsrail övladlarına de: “Sizə verəcəyim torpağa gəldiyiniz zaman məhsulunuzu biçəndə biçdiyiniz ilk dərzi kahinin yanına gətirin. ");
INSERT INTO azb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","O, dərzi Rəbbin hüzurunda yellədərək təqdim etsin ki, sizdən qəbul olunsun. Kahin onu Şənbənin ertəsi günü yellətsin. ");
INSERT INTO azb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Dərzi yellətdiyiniz gün Rəbbə birillik qüsursuz erkək toğlu yandırma qurbanı kimi kəsin. ");
INSERT INTO azb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Toğlu ilə birlikdə taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş bir efanın onda ikisi olan miqdarda narın un gətirin. Bu, Rəbb üçün yandırma təqdimi – Onun xoşuna gələn ətirdir. İçmə təqdimi olaraq da bir hin şərabın dörddə birini gətirin. ");
INSERT INTO azb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Bu qurbanı Allahınıza təqdim etdiyiniz həmin günə qədər nə çörək, nə qovurğa, nə də təzə sünbül yeməyin. Bu bütün yaşadığınız yerlərdə nəsildən-nəslə sizin üçün əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Şənbənin ertəsi günü olan yellədilən dərzi gətirdiyiniz gündən tam yeddi həftə, ");
INSERT INTO azb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","yeddinci Şənbə gününün ertəsinədək əlli gün sayın, sonra Rəbbə təzə taxıl təqdimi gətirin. ");
INSERT INTO azb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Yaşadığınız hər yerdən yellədib təqdim etmək üçün bir efanın onda ikisi narın undan maya ilə bişirilmiş iki kömbə çörəyi Rəbbə nübar təqdimi gətirin. ");
INSERT INTO azb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Çörəklə birgə birillik yeddi qüsursuz toğlu, bir buğa və iki qoç təqdim edin. Bunlar taxıl təqdimləri və içmə təqdimləri ilə birlikdə Rəbb üçün yandırma qurbanıdır, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Günah qurbanı üçün bir təkə, ünsiyyət qurbanı üçün isə iki birillik toğlu gətirin. ");
INSERT INTO azb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kahin bu iki toğlunu nübar çörəyi ilə birgə Rəbbin hüzurunda yellədərək təqdim etsin. Bunlar kahinin Rəbb üçün müqəddəs payı olsun. ");
INSERT INTO azb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Həmin gün özünüz üçün müqəddəs toplantı elan edin və heç bir gündəlik iş görməyin. Bu bütün yaşadığınız yerlərdə nəsildən-nəslə sizin üçün əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Torpağınızda məhsul biçəndə tarlanın qıraqlarını biçməyin və biçindən düşən başaqları yığmayın. Qoy qalan məhsul kasıblara və qəriblərə qalsın. Allahınız Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«İsrail övladlarına belə de: “Yeddinci ayın birinci günü sizin üçün istirahət günü, şeypur çalınma ilə qeyd olunan gün, müqəddəs toplantı günü olsun. ");
INSERT INTO azb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","O gün heç bir gündəlik iş görməyin və Rəbb üçün yandırma təqdimi gətirin”». ");
INSERT INTO azb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«İsrail övladlarına de: “Yeddinci ayın onu isə Kəffarə günüdür, müqəddəs toplantınız olsun; özünüzü hər şeydən məhrum edin və Rəbb üçün yandırma təqdimi gətirin. ");
INSERT INTO azb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Həmin gün heç bir iş görməyin, çünki bu, Allahınız Rəbbin hüzurunda sizin üçün kəffarə edilən Kəffarə günüdür. ");
INSERT INTO azb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Həmin o gün özünü hər şeydən məhrum etməyən adam xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","O gün hər hansı bir iş görən adamı Mən xalqı arasından yox edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Heç bir iş görməyin. Bu bütün yaşadığınız yerlərdə nəsildən-nəslə sizin üçün əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","O gün sizin üçün Şənbə istirahət günü kimidir. Özünüzü hər şeydən məhrum edin. Ayın doqquzuncu günü axşamdan ertəsi günün axşamına qədər Şənbə günü kimi istirahət edin”». ");
INSERT INTO azb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«İsrail övladlarına söylə: “Həmin yeddinci ayın on beşinci günündən Rəbb üçün yeddi gün Çardaqlar bayramını keçirin. ");
INSERT INTO azb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Birinci gün müqəddəs toplantı günüdür. Gündəlik işlərinizi görməyin. ");
INSERT INTO azb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Bu yeddi gün ərzində Rəbbə yandırma təqdimləri gətirin. Səkkizinci gün isə müqəddəs toplantınız olsun və Rəbbə yandırma təqdimləri gətirin. Bu gün təntənəli toplantı günüdür, gündəlik işlərinizi görməyin. ");
INSERT INTO azb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Bunlar Rəbbin təyin etdiyi bayramlardır: bu zaman müqəddəs toplantı çağırıb hər birini öz günündə olmaqla yandırma təqdimlərini – yandırma qurbanlarını, taxıl təqdimlərini, ünsiyyət qurbanlarını və içmə təqdimlərini Rəbbə gətirin. ");
INSERT INTO azb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Bunlar Rəbbin Şənbələrinə və Rəbbə verdiyiniz bütün ianələrə, bütün əhdlərin ödəmələrinə, bütün könüllü təqdimlərə əlavədir. ");
INSERT INTO azb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Üstəlik yeddinci ayın on beşinci günü torpağın məhsullarını yığandan sonra yeddi gün Rəbb üçün bayram keçirin. Birinci gün və səkkizinci gün istirahət günləri olsun. ");
INSERT INTO azb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Birinci gün gözəl ağacların meyvələrini, xurma ağaclarının budaqlarını, sıx yarpaqlı ağacların və çay kənarında bitən qovaq ağaclarının budaqlarını toplayıb Allahınız Rəbbin hüzurunda yeddi gün şənlik edin. ");
INSERT INTO azb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Hər il Rəbb üçün bu bayramı yeddi gün keçirin. Bu, nəsildən-nəslə sizin üçün əbədi qaydadır; bu bayramı yeddinci ayda qeyd edin. ");
INSERT INTO azb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Yeddi gün çardaqlarda qalın; bütün yerli İsraillilər çardaqlarda yaşasın. ");
INSERT INTO azb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Beləliklə, sizin nəsilləriniz bilsin ki, Mən İsrail övladlarını Misir torpağından çıxarandan sonra onları çardaqlarda yerləşdirdim. Allahınız Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Beləcə Musa İsrail övladlarına Rəbbin təyin etdiyi bayramlar barəsində nəql etdi. ");
INSERT INTO azb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«İsrail övladlarına əmr et ki, işıq yandırmaq üçün sənə zeytundan çəkilmiş xalis yağ gətirsinlər. Bu yağdan çıraqlar daima ");
INSERT INTO azb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Hüzur çadırında, şəhadət pərdəsinin bayır tərəfində yansın. Harun onu hər axşam Rəbbin hüzurunda yandırıb səhərə qədər nəzarət etsin. Bu, nəsildən-nəslə sizin üçün əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Rəbbin hüzurunda xalis qızıldan düzəlmiş çıraqdandakı çıraqlara daim nəzarət edilsin. ");
INSERT INTO azb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Narın un götürüb hər kökə bir efanın onda ikisi qədər miqdarda on iki kökə bişir. ");
INSERT INTO azb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Onları Rəbbin hüzurunda xalis qızıldan düzəlmiş masaya, iki sıraya altı-altı qoy. ");
INSERT INTO azb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Çörək sıralarının üstünə xalis kündür qoy. Çörəklərin üstündəki kündür Rəbb üçün yandırma təqdimi, çörək yerinə xatirə təqdimi olsun. ");
INSERT INTO azb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Qoy bu çörəklər hər Şənbə günü daim Rəbbin hüzurunda düzülsün. Bu, İsrail övladları üçün əbədi əhddir. ");
INSERT INTO azb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Bu çörəklər Harunla övladlarının payıdır. Onlar bu çörəkləri müqəddəs bir yerdə yesinlər. Çünki bunlar Rəbb üçün verilən yandırma təqdimlərindən ən müqəddəs, Harun övladları üçün əbədi paydır». ");
INSERT INTO azb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Bir gün anası İsrailli, atası Misirli olan bir adam İsrail övladlarının arasına çıxdı. O, düşərgədə bir İsrailli ilə savaşıb ");
INSERT INTO azb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Allahın adına küfr və lənət etdi. O adamı Musanın yanına gətirdilər. Onun anası Dan qəbiləsindən Dibri qızı Şelomit idi. ");
INSERT INTO azb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","O adamı həbs edib Rəbbin qərarını gözlədilər. ");
INSERT INTO azb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Lənət edəni düşərgədən kənara çıxar; qoy bu lənəti eşidənlər əllərini o adamın başına qoysunlar. Sonra qoy bütün icma onu daşqalaq etsin. ");
INSERT INTO azb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","İsrail övladlarına belə de: “Allahına lənət edən hər kəs öz günahının cəzasını çəkəcək; ");
INSERT INTO azb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Rəbbin adına küfr edən hər kəs öldürülməlidir. Bütün icma onu daşqalaq etsin; istər yadelli, istər yerli olsun, Allahın adına küfr etdiyinə görə öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Başqa bir adamın canını alan hər kəs öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Heyvanı öldürən isə can əvəzinə can olaraq zərəri ödəsin. ");
INSERT INTO azb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Bir adam başqa adamı yaralayarsa, o nə cür edibsə, ona da belə edilsin: ");
INSERT INTO azb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","sınıq əvəzinə sınıq, göz əvəzinə göz, diş əvəzinə diş; o adama nə cür yara vurubsa, ona da belə yara vurulsun. ");
INSERT INTO azb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Heyvan öldürən zərərini ödəsin. Adam öldürən isə özü öldürülsün. ");
INSERT INTO azb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Sizdə istər qərib, istər yerli üçün ədalət bir olsun; çünki Allahınız Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musa İsrail övladlarına bunu dedi. Lənət edəni düşərgədən kənara çıxarıb daşqalaq etdilər. Rəbbin Musaya əmr etdiyi kimi İsrail övladları buna əməl etdilər. ");
INSERT INTO azb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Rəbb Sina dağında Musaya belə söylədi: ");
INSERT INTO azb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«İsrail övladlarına de: “Sizə verəcəyim torpağa daxil olanda bütün ölkədə Şənbə günü kimi Rəbb üçün dinclik vaxtları olsun. ");
INSERT INTO azb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Altı il tarlanı ək, üzümlüyün budaqlarını kəs və məhsulunu yığ. ");
INSERT INTO azb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Yeddinci ildə isə torpaq Şənbə günü kimi dincə qoyulsun. Bu, Rəbbin dinclik ilidir. Bu il sən nə tarlanı ək, nə də üzümlüyünü buda, ");
INSERT INTO azb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","biçinindən düşən toxumdan bitən məhsulu biçmə və kəsilməmiş tənəklərdən salxımları yığma. Bu, torpaq üçün dinclik ili olsun. ");
INSERT INTO azb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Bu dinclik ilində torpağın verdiyi hər məhsul sizin üçün qida olacaq; qulunuz, qarabaşınız, muzdlu işçiniz, aranızda yaşayan gəlmənin, ");
INSERT INTO azb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ev heyvanının və ölkədəki vəhşi heyvanın qidası olacaq. ");
INSERT INTO azb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Özün üçün yeddi dinclik ili – yeddi dəfə yeddi il say. Yeddi dinclik ilinin müddəti qırx doqquz ildir. ");
INSERT INTO azb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Sonra yeddinci ayın onu – Kəffarə günü bütün ölkənizdə yüksək səslə şeypur çaldırmaqla ");
INSERT INTO azb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","əllinci ili təqdis edin və ölkənin bütün sakinləri üçün azadlıq elan edin. Bu il sizin üçün Azadlıq ili olsun; hamı öz mülkünə, öz ailəsinə qayıtsın. ");
INSERT INTO azb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Qoy əllinci il sizin üçün Azadlıq ili olsun. O il heç nə əkməyin, düşən toxumdan bitən məhsulu biçməyin, budanmamış meynələrinizdən yığmayın, ");
INSERT INTO azb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","çünki bu Azadlıq ili sizin üçün müqəddəs olsun. Tarlalarınızın verdiyi məhsulu yeyin. ");
INSERT INTO azb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Bu Azadlıq ilində hər kəs öz mülkünə qayıtsın. ");
INSERT INTO azb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kim torpaq sahəsini başqa adama satarsa, ondan alan soydaşına haqsızlıq etməsin. ");
INSERT INTO azb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Alan şəxs Azadlıq ilindən neçə il keçməsinə görə qiymətləndirib alsın. Satan isə məhsul götürəcəyi illərə münasib olaraq satsın. ");
INSERT INTO azb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","İllərin sayı çoxdursa, qiyməti qaldır, azdırsa, onu endir, çünki o sənə satılan məhsulların miqdarıdır. ");
INSERT INTO azb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Bir-birinizə qarşı haqsızlıq etməyin, amma Allahınızdan qorxun, çünki Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Mənim qaydalarıma əməl edin, hökmlərimə səylə riayət edin ki, ölkədə arxayın yaşayasınız. ");
INSERT INTO azb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Torpaq da barını verəcək ki, siz doyunca yeyib orada sakit yaşayasınız. ");
INSERT INTO azb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","‹Məhsul əkib-biçmədiyimiz yeddinci ildə nə yeyək?› soruşanda bilin: ");
INSERT INTO azb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","altıncı il üstünüzə elə bərəkət göndərəcəyəm ki, torpaq üçillik məhsul verəcək. ");
INSERT INTO azb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Səkkizinci il əkin və köhnə məhsuldan yeyin; doqquzuncu il təzə məhsul yetişənə qədər köhnəni yeyin. ");
INSERT INTO azb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Torpaq əbədi olaraq satılmaz; çünki torpaq Mənimdir, siz isə yanımda qərib və gəlməsiniz. ");
INSERT INTO azb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Bütün mülkünüzdən sahə satanda onu geri satınalma hüququnu saxlayın. ");
INSERT INTO azb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Yanındakı soydaşın yoxsullaşıb mülkündən bir sahə satılmalıdırsa, onun yaxın qohumu o sahəni geri satın ala bilər. ");
INSERT INTO azb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Geri satın alan qohumu yoxdursa, o soydaş sonra gücü çatıb geri satınalma məbləği tapsa, ");
INSERT INTO azb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","qoy satılan vaxtdan neçə illər keçdiyini hesablasın və qiymətin qalığını satdığı adama verib yenə öz mülkünə malik olsun. ");
INSERT INTO azb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Əgər gücü çatıb bu məbləği tapmasa, sahəsi Azadlıq ilinə qədər onu geri satın alan adama məxsus qalsın. Azadlıq ilində isə qaytarılsın ki, satan adam yenə öz mülkünə malik olsun. ");
INSERT INTO azb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Bir adam qalalı şəhərdə olan yaşayış evini satarsa, onu geri satınalma hüququ satdığı gündən bir il müddətinə qüvvədədir; satan adam evi geri satın ala bilər. ");
INSERT INTO azb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Amma əgər bütöv il tamamlananacan o adam evi geri satın ala bilməsə, qalalı şəhərdəki ev onu alana məxsus həmişəlik nəsildən-nəslə qalsın. Bu, Azadlıq ilində qaytarılmaz. ");
INSERT INTO azb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ətraf qala divarı olmayan kəndlərdəki evlər isə torpaq sahələri kimi sayılsın; onları geri satınalma hüququ olsun və Azadlıq ilində qaytarılsın. ");
INSERT INTO azb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Lakin Levililər özlərinə aid şəhərlərdə mülklərini satdıqları evləri daima geri satınalma hüququna malik olsunlar. ");
INSERT INTO azb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Levililərdən birinin mülkü satdığı və geri satın almadığı şəhər evi Azadlıq ilində ona qaytarılsın. Çünki Levililərin şəhərlərindəki evlər onların İsrail övladları arasındakı irsdir. ");
INSERT INTO azb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Onların şəhərlərinin ətraf otlaqları isə heç satılmamalıdır, çünki bunlar Levililərin ayrılmaz mülküdür. ");
INSERT INTO azb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Yanındakı soydaşın yoxsullaşıb və özünü təmin edə bilmirsə, ona yardım et. Qoy o sənin yanında yadelli ya gəlmə kimi yaşasın. ");
INSERT INTO azb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ondan nə sələm, nə də mənfəət götür. Allahından qorx və qoy soydaşın sənin yanında yaşaya bilsin. ");
INSERT INTO azb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ona nə sələmlə pul ver, nə də mənfəətini güdmək üçün yemək ver. ");
INSERT INTO azb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Kənan torpağını sizə vermək və Allahınız olmaq üçün sizi Misir torpağından çıxaran Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Yanındakı soydaşın yoxsullaşıb sənə özünü qul kimi satarsa, ona qulun ağır işini gördürmə. ");
INSERT INTO azb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Qoy o, yanında muzdlu işçi yaxud gəlmə kimi olsun. O, Azadlıq ilinədək yanında işləsin, ");
INSERT INTO azb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","sonra uşaqları ilə birlikdə səndən ayrılıb ailəsinin yanına, atalarının mülkünə qayıtsın. ");
INSERT INTO azb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Çünki İsrail övladları Mənim Misir torpağından çıxartdığım qullarımdır, buna görə də onlar qul kimi satılmasınlar. ");
INSERT INTO azb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","O soydaşına sərt ağalıq etmə. Allahından qorx. ");
INSERT INTO azb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Qullarınız və kənizləriniz ətrafınızdakı millətlərdən olsun. Siz onlardan nökər və qarabaş geri satın ala bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Aranızda yaşayan gəlmələrdən və onların ölkənizdə doğulmuş ailə üzvlərindən də geri satın ala bilərsiniz. Bunlar sizin mülkiyyətiniz olacaq. ");
INSERT INTO azb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Siz özünüzdən sonra bunları oğullarınıza əmlak kimi vəsiyyət edə bilərsiniz və onlar oğullarınızın mirası olub həyatı boyunca iş görəcəklər. Ancaq İsrailli soydaşlarınız arasında heç kim soydaşına sərt ağalıq etməsin. ");
INSERT INTO azb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Yanındakı soydaşın yoxsullaşıbsa, qonşuluqda yaşayan pulu olan bir yadelli ya da gəlməyə yaxud onun ailə üzvünə özünü qul olaraq satarsa, ");
INSERT INTO azb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","satıldıqdan sonra onun geri satınalma hüququ var. Qardaşlarından biri onu geri satın ala bilər; ");
INSERT INTO azb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","əmisi ya da əmisi oğlu da onu geri satın ala bilər. Ailəsindən hər bir yaxın qohumu da onu geri satın ala bilər. Öz gücü çatanda o adam özünü geri satın ala bilər. ");
INSERT INTO azb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Qoy bu adam ağası ilə özünü satdığı ildən Azadlıq ilinə qədər muzdlu işçinin iş müddəti kimi hesablaşsın və illərin sayına görə qiyməti qoyulsun. ");
INSERT INTO azb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Əgər illərin sayı hələ də çoxdursa, o buna görə geri satınalınmanın qiyməti olaraq satın alındığı məbləğin böyük bir hissəsini ödəsin. ");
INSERT INTO azb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Lakin əgər Azadlıq ilinə az qalırsa, o müddətə görə hesab edərək geri satınalınmanın qiyməti olaraq az ödəsin. ");
INSERT INTO azb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Yəni ilbəil muzdlu işçi kimi ağası ilə hesablaşsın. Qoy ağası da sənin gözün qarşısında ona sərt ağalıq etməsin. ");
INSERT INTO azb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Əgər o adam bu yolla geri satın alınmamışdırsa, Azadlıq ilində uşaqları ilə birgə azad olsun. ");
INSERT INTO azb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Çünki İsrail övladları Mənim qullarım, Mənim Misir torpağından çıxardığım qullarımdır. Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Özünüzə büt düzəltməyin; oyma büt yaxud sütun qoymayın, ölkənizdə yonulmuş daş qoyub səcdə etməyin; çünki Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Şənbə istirahət günlərimə riayət edin, Müqəddəs məkanıma ehtiramla yanaşın. Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Əgər qaydalarımla yaşayıb əmrlərimə səylə əməl etsəniz, ");
INSERT INTO azb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","sizə mövsümündə yağış göndərəcəyəm ki, torpaq öz məhsulunu, ağaclar isə meyvələrini versin. ");
INSERT INTO azb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Sizin xırmanınız o qədər bol olacaq ki, onun döyülməsi üzüm yığımına qədər davam edəcək, üzümünüz o qədər bol olacaq ki, onun yığılması əkin vaxtına qədər davam edəcək. Çörəyinizi doyunca yeyib ölkənizdə arxayın yaşayacaqsınız. ");
INSERT INTO azb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ölkənizə sülh verəcəyəm; yatanda sizi vahiməyə salan olmayacaq. Yırtıcı heyvanları ölkədən qovacağam və müharibə üzü görməyəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Düşmənlərinizi qovacaqsınız, onlar döyüş zamanı qarşınızda həlak olacaqlar. ");
INSERT INTO azb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Beşiniz yüz adamı, yüzünüz on min adamı qovacaq. Düşmənləriniz döyüş zamanı qarşınızda həlak olacaqlar. ");
INSERT INTO azb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Mən üzümü sizə çevirəcəyəm, sizi artırıb çoxaldacağam, sizinlə olan Öz əhdimi yerinə yetirəcəyəm. ");
INSERT INTO azb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Saxladığınız məhsul bütün il boyu sizə çatacaq. Yeni məhsula yer tapmaq üçün köhnəni boşaltmalı olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Üstəlik, Mən aranızda məskunlaşacağam və sizə nifrət etməyəcəyəm. ");
INSERT INTO azb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mən həm də aranızda yaşayıb sizin Allahınız olacağam, siz isə Mənim xalqım olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Sizi Misir torpağından çıxardan və onların köləliyindən azad edən, boyunduruğunuzu qırıb başınızı uca edən Allahınız Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Amma əgər Mənə qulaq asıb bütün bu əmrlərimə əməl etməsəniz, ");
INSERT INTO azb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","əvəzində qaydalarıma xor baxıb hökmlərimi qəlbinizdən rədd etsəniz, Mənim bütün əmrlərimə əməl etməyib, əhdimi pozsanız, ");
INSERT INTO azb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Mən sizə bunu edəcəyəm: göz çıxaran və qəlbi sıxan fəlakət, vərəm, qızdırma göndərəcəyəm. Toxumlarınızı hədər yerə əkəcəksiniz; düşmənləriniz onlardan əmələ gələn məhsulu yeyəcək. ");
INSERT INTO azb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Üzümü sizdən döndərəcəyəm, düşmənlərinizin qarşısında məğlub olacaqsınız, yağılarınız üzərinizdə hökm sürəcək; sizi qovan olmasa da, qaçacaqsınız. ");
INSERT INTO azb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Əgər buna baxmayaraq yenə də Mənə qulaq asmasanız, o vaxt günahlarınıza görə sizi yeddi qat artıq tənbeh edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Öyündüyünüz güclü təkəbbürünüzü qıracağam. Başınız üzərində olan göyləri dəmir və ayağınız altındakı yeri tunc kimi edəcəyəm ki, ");
INSERT INTO azb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","qüvvətiniz tükənsin; nə torpağınız məhsul, nə də ağaclarınız meyvə verəcək. ");
INSERT INTO azb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Əgər Mənə qarşı çıxıb sözlərimə hələ də qulaq asmaq istəməsəniz, Mən sizə günahlarınıza görə yeddiqat artıq bəla göndərəcəyəm. ");
INSERT INTO azb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Üstünüzə vəhşi heyvanlar göndərəcəyəm. Onlar övladlarınızı öldürüb, ev heyvanlarınızı parçalayacaq. Buna görə sayınız elə azalacaq ki, yollarınız viran qalacaq. ");
INSERT INTO azb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Əgər bunlardan ibrət dərsi almayıb Mənə qarşı çıxmaqda davam etsəniz, ");
INSERT INTO azb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Mən də sizə qarşı çıxacağam və günahlarınıza görə yenə də yeddiqat artıq cəzalandıracağam. ");
INSERT INTO azb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Əhdi pozduğunuza görə qisas almaq üçün üstünüzə müharibə göndərəcəyəm. Siz şəhərlərinizdə sığınanda aranıza vəba salacağam ki, düşmənin əlinə düşəsiniz. ");
INSERT INTO azb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Çörəyinizin kökünü kəsəcəyəm. On qadın bir təndirdə çörək bişirəcək və onu sizə çəki ilə paylayacaq, siz isə yeyib doymayacaqsınız. ");
INSERT INTO azb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Əgər siz bundan sonra da Mənə qulaq asmasanız və Mənə qarşı çıxsanız, ");
INSERT INTO azb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","bu dəfə Mən də sizə qarşı qəzəblə çıxıb günahlarınıza görə yeddiqat artıq tənbeh edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Oğul və qızlarınızın ətini yeməyə məcbur olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Səcdəgahlarınızı məhv edib, buxur qurbangahlarınızı yox edəcəyəm, bütlərinizi devirəcəyəm və meyitlərinizi o bütlərin üstünə sərəcəyəm. Sizi rədd edəcəyəm; ");
INSERT INTO azb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","şəhərlərinizi xaraba qoyacağam, Müqəddəs məkanlarınızı viranəliyə döndərib xoş ətirlərinizi qəbul etməyəcəyəm. ");
INSERT INTO azb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Mən ölkənizi elə viran qoyacağam ki, oranı işğal edən düşmənləriniz baxıb dəhşətə gəlsinlər. ");
INSERT INTO azb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Sizi isə millətlər arasına səpələyəcəyəm və arxanızca qılıncla düşəcəyəm. Torpağınız viranəliyə, şəhərləriniz xarabalığa dönəcək. ");
INSERT INTO azb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","O zaman ölkə viran qalacaq, siz isə düşmən torpağında yaşayacaqsınız. Bütün bu vaxt ərzində ölkə dinclik illərini qeyd edəcək. Yalnız o vaxt ölkə dinclik illərini qeyd edərək şadlanacaq. ");
INSERT INTO azb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Orada yaşadığınız dinclik illərində görmədiyi dincliyi ölkə viran qalan bütün müddət görəcək. ");
INSERT INTO azb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Düşmən ölkələrində sizdən sağ qalanların ürəklərinə elə cəsarətsizlik salacağam ki, onlar hətta küləkdən tərpənən yarpağın xışıltısından qorxub qaçacaqlar. Onları qovan olmasa da, müharibədən qaçan kimi qaçıb yıxılacaqlar; ");
INSERT INTO azb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","büdrəyib bir-birinin üstünə yıxılacaqlar, amma onları qovan olmayacaq; düşmənləriniz qarşısında durmağa qüvvətiniz olmayacaq. ");
INSERT INTO azb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Millətlər arasında həlak olacaqsınız, düşmən torpağı sizi udacaq. ");
INSERT INTO azb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Sizdən sağ qalanlarsa düşmən ölkələrində həm öz günahlarının cəzasını, həm də atalarının günahlarının cəzasını çəkib çürüyəcəklər. ");
INSERT INTO azb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Amma özlərinin və atalarının günahlarını, Mənə xainlik etdiklərini və Mənə qarşı çıxdıqlarını etiraf etsələr, ");
INSERT INTO azb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","– buna görə Mən də onlara qarşı çıxıb düşmən torpağına aparmışam – daş ürəkləri yumşalıb günahlarının əvəzini ödəsələr, ");
INSERT INTO azb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","o zaman Mən də Yaqubla, İshaqla və İbrahimlə bağladığım əhdimi və onlara vəd etdiyim ölkəni xatırlayacağam. ");
INSERT INTO azb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Bu torpaq onlar tərəfindən tərk ediləcək, onlarsız boş qalıb Şənbə istirahəti edib şadlanacaq. Onlarsa öz cəzalarını çəkəcəklər, çünki Mənim hökmlərimi rədd edərək qaydalarıma nifrət etdilər. ");
INSERT INTO azb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Bütün bunlara baxmayaraq, düşmən ölkəsində yaşadıqları zaman onlara xor baxıb rədd etməyəcəyəm. Beləcə Mən onları məhv edib bağladığım əhdimi pozmayacağam, çünki onların Allahı Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mən onların əcdadlarını başqa millətlərin qarşısında onların Allahı olmaq üçün Misir torpağından çıxaran vaxt bağladığım əhdimi xatırlayacağam; Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Bunlar Rəbbin Özü ilə İsrail övladları arasında Sina dağında Musa vasitəsilə verdiyi qaydalar, hökmlər və qanunlardır. ");
INSERT INTO azb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«İsrail övladlarına söylə: “İnsanları Rəbbə həsr edən adam əhdini bu dəyərlərinə görə ödəyə bilər: ");
INSERT INTO azb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Müqəddəs yerdəki şekelin ölçüsünə görə iyirmi yaşından altmış yaşına qədər kişinin dəyəri əlli şekel gümüş, ");
INSERT INTO azb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","qadının dəyəri otuz şekeldir; ");
INSERT INTO azb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","beş yaşından iyirmi yaşına qədər oğlanın dəyəri iyirmi şekel, qızın isə on şekeldir; ");
INSERT INTO azb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","bir aydan beş yaşa qədər olan oğlanın dəyəri beş şekel gümüş, qızın dəyəri isə üç şekel gümüşdür; ");
INSERT INTO azb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","altmış yaşından yuxarı olan kişinin dəyəri on beş şekel, qadının isə on şekeldir; ");
INSERT INTO azb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","əgər əhdinə əməl edən adam belə dəyəri ödəmək üçün çox kasıbdırsa, qoy həsr etdiyi adamı kahinin önünə gətirsin ki, kahin onu qiymətləndirsin. Əhdinə əməl edənin gücü nəyə çatırsa, kahin onun qiymətini təyin etsin. ");
INSERT INTO azb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Əgər bir nəfər Rəbbə qurban gətirilən heyvanlardan birini həsr etsə, bunlardan Rəbbə verilən hər baş heyvan müqəddəs sayılır. ");
INSERT INTO azb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","O adam heyvanı dəyişdirməsin. Nə pisi yaxşı ilə, nə yaxşını pislə əvəz etməsin. Əgər o, heyvanı dəyişdirirsə, dəyişdirilən heyvanların ikisi də müqəddəs sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Əgər Rəbbə qurban gətirməyə layiq olmayan hər hansı murdar heyvanlardan birini həsr etsə, qoy o heyvanı kahinin yanına gətirib ona göstərsin; ");
INSERT INTO azb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","kahin onu yaxşı ya pis olduğuna görə qiymətləndirsin və dəyəri onun təyin etdiyinə görə olsun. ");
INSERT INTO azb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Əgər heyvanı həsr edən onu geri satın almaq istəsə, qoy o dəyərinə beşdə biri qədər əlavə edərək ödəsin. ");
INSERT INTO azb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Bir nəfər öz evini müqəddəs təqdim kimi Rəbbə təqdis edəndə kahin evi yaxşı ya pis olduğuna görə qiymətləndirsin. Qiymət kahinin təyin etdiyi kimi qalsın. ");
INSERT INTO azb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Əgər o adam evini geri satın almaq istəsə, qoy o qiymətə görə beşdə birini əlavə edərək ödəsin və ev ona qayıtsın. ");
INSERT INTO azb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Əgər bir nəfər mülkü olan tarla sahəsini Rəbbə təqdis edirsə, oraya əkilən toxum miqdarına görə bir xomer arpa əkilən tarlanın qiyməti əlli şekel gümüş olsun. ");
INSERT INTO azb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Əgər o adam tarlasını Azadlıq ilindən başlayaraq təqdis edirsə, bu dəyər olduğu kimi qalsın. ");
INSERT INTO azb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Əgər tarlasını Azadlıq ilindən sonra təqdis edirsə, kahin onunla qiymətini sonrakı Azadlıq ilinə qədər qalan müddətə görə hesablaşsın və dəyəri belə aşağı salınsın. ");
INSERT INTO azb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Əgər tarlanı təqdis edən adam onu geri satın almaq istəsə, qoy o, gümüşə görə dəyərinə beşdə birini əlavə edərək ödəsin və tarla ona qayıtsın. ");
INSERT INTO azb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Əgər tarlanı geri satın almadan başqa birinə satarsa, sonra onu heç vaxt geri satın ala bilməz. ");
INSERT INTO azb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","O tarla Azadlıq ilində azad olanda həmişəlik həsr olunmuş bir tarla kimi Rəbb üçün təqdis edilmiş sayılsın; kahinin mülkü olsun. ");
INSERT INTO azb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Əgər bir nəfər öz mülkü olmayaraq, satın aldığı bir tarlanı Rəbbə təqdis edərsə, ");
INSERT INTO azb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","qoy kahin onunla Azadlıq ilinə qədər dəyərini hesablasın. O adam həmin gün qiyməti Rəbb üçün təqdis edilmiş bir şey kimi versin. ");
INSERT INTO azb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Azadlıq ilində həmin tarla mülk olub onu satan adama qaytarılsın. ");
INSERT INTO azb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Bütün dəyərlər Müqəddəs yerdəki şekelə görə sayılsın. Bu şekel iyirmi geraya bərabərdir. ");
INSERT INTO azb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Heyvanlar arasında ilk doğulanlar Rəbbə məxsusdur. Heç kim onu yenidən təqdis etməsin. İstər mal-qara, istər qoyun-keçi olsun, onlar Rəbbindir. ");
INSERT INTO azb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Əgər murdar heyvanın balası olsa, onu gətirən adam ümumi dəyərinə beşdə birini əlavə edərək geri satın ala bilər. Əgər o geri satın alınmırsa, dəyərinə satılsın. ");
INSERT INTO azb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Bir nəfərin öz əmlakından istər adam, istər heyvan, istər mülkü olan tarla sahəsi olsun – Rəbb üçün məhv edilməyə həsr etdiyi hər bir şey nə satılsın, nə də geri satın alınsın. Məhv edilməyə həsr olunmuş hər şey Rəbb üçün ən müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Məhv edilməyə həsr olunmuş hər kəs geri satın alınmamalıdır, hamısı öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Torpağın məhsulundan – onun verdiyi taxıldan və ağacların meyvəsindən bütün onda bir hissə Rəbbə məxsusdur və Onun üçün təqdis edilib. ");
INSERT INTO azb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Əgər bir nəfər öz onda bir hissəsini geri satın almaq istəsə, qoy qiymətinə beşdə birini əlavə edərək ödəsin. ");
INSERT INTO azb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Bütün mal-qaradan, qoyun-keçidən onda bir hissə, sayla çoban dəyənəyinin altından keçən hər onuncu heyvan Rəbb üçün təqdis edilmiş sayılsın. ");
INSERT INTO azb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Qoy heyvan sahibi heyvanlara yaxşı yaxud pis fərq qoyub baxmasın; birini o biri ilə dəyişdirməsin. Əgər o belə dəyişdirsə, dəyişdirilən heyvanların ikisi də müqəddəs sayılıb geri satın alınmamalıdır”». ");
INSERT INTO azb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Bu, Rəbbin Musaya İsrail övladları üçün Sina dağında verdiyi əmrlərdir. ");
INSERT INTO azb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","İsrail övladlarının Misirdən çıxmasının ikinci ilində, ikinci ayın birinci günü Sina səhrasında, Hüzur çadırında Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Bütün İsrail övladlarının icmasını, nəsilləri və ailələri ilə birlikdə siyahıya alın. Bütün kişiləri ayrı-ayrı sayıb adlarını yazın. ");
INSERT INTO azb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","İsraildə iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişini sən və Harun siyahıya alıb dəstələrə ayıracaqsınız. ");
INSERT INTO azb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Sizinlə bərabər hər qəbilədən bir kişi olsun; bu adamlar ailə başçısı olmalıdır. ");
INSERT INTO azb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Sizə kömək edəcək adamlar bunlardır: Ruven qəbiləsindən: Şedeur oğlu Elisur; ");
INSERT INTO azb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Şimeondan: Surişadday oğlu Şelumiel; ");
INSERT INTO azb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yəhudadan: Amminadav oğlu Naxşon; ");
INSERT INTO azb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","İssakardan: Suar oğlu Netanel; ");
INSERT INTO azb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zevulundan: Xelon oğlu Eliav; ");
INSERT INTO azb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yusif övladlarından: Efrayimdən: Ammihud oğlu Elişama; Menaşşedən: Pedahsur oğlu Qamliel; ");
INSERT INTO azb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Binyamindən: Gidoni oğlu Avidan; ");
INSERT INTO azb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dandan: Ammişadday oğlu Axiezer; ");
INSERT INTO azb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aşerdən: Okran oğlu Pagiel; ");
INSERT INTO azb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Qaddan: Deuel oğlu Elyasaf; ");
INSERT INTO azb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naftalidən: Enan oğlu Axira». ");
INSERT INTO azb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Bunlar icmadan təyin edilmiş adamlar, öz ata-babalarının qəbilə rəhbərləri və İsrailin tayfa başçıları idilər. ");
INSERT INTO azb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa ilə Harun adları göstərilən bu adamları apardılar. ");
INSERT INTO azb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","İkinci ayın birinci günündə bütün icmanı topladılar; nəsillərinə və ailələrinə görə adlarının siyahısı ilə iyirmi və ondan yuxarı yaşda olanlar ayrı-ayrı yazıldılar. ");
INSERT INTO azb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Rəbbin Musaya əmr etdiyi kimi onlar Sina səhrasında xalqı elə də siyahıya aldılar. ");
INSERT INTO azb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","İsrailin ilk oğlu Ruvenin övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına ayrı-ayrı qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ruven qəbiləsindən 46 500 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Şimeon övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına ayrı-ayrı qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Şimeon qəbiləsindən 59 300 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Qad övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Qad qəbiləsindən 45 650 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Yəhuda övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Yəhuda qəbiləsindən 74 600 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","İssakar övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","İssakar qəbiləsindən 54 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zevulun övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zevulun qəbiləsindən 57 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yusif nəslindən – Efrayim övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Efrayim qəbiləsindən 40 500 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Menaşşe övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Menaşşe qəbiləsindən 32 200 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Binyamin övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Binyamin qəbiləsindən 35 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan qəbiləsindən 62 700 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Aşer övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Aşer qəbiləsindən 41 500 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naftali övladlarından iyirmi və ondan yuxarı yaşda döyüşə qabil olan hər kişi mənsub olduğu nəsil və ailəyə görə adlar siyahısına qeyd edildi. ");
INSERT INTO azb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naftali qəbiləsindən 53 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Musa, Harun və İsrailin on iki rəhbəri tərəfindən bunlar siyahıya alındı; hər biri mənsub olduqları ailəni təmsil edirdi. ");
INSERT INTO azb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","İsraildə iyirmi və ondan yuxarı yaşda döyüşə qabil olan kişilərin hamısı mənsub olduqları ailəyə görə siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Siyahıya alınanlar cəmi 603 550 nəfər idi. ");
INSERT INTO azb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lakin onların arasında Levililər ailələrinə görə siyahıya alınmadı. ");
INSERT INTO azb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Çünki Rəbb Musaya demişdi: ");
INSERT INTO azb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Ancaq Levi qəbiləsini siyahıya alma və digər İsrail övladlarını aldığın siyahıya daxil etmə. ");
INSERT INTO azb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Şəhadət məskəni ilə onun bütün avadanlığı və məskənə aid olan hər şey üçün məsuliyyəti Levililərin üzərinə qoy. Məskəni və onun bütün avadanlığını onlar daşısınlar, məskənə baxsınlar və onun ətrafında düşərgə salsınlar. ");
INSERT INTO azb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Məskən daşınacağı zaman Levililər onu toplasınlar. Məskən bir yerə qoyulacağı zaman yenə Levililər onu qursunlar. Onlardan savayı məskənə yaxınlaşan öldürülsün. ");
INSERT INTO azb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","İsrail övladları öz çadırlarını bölüklərinə görə qursunlar. Hər kəs öz düşərgəsində bayrağının altında olsun. ");
INSERT INTO azb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Levililər isə Şəhadət məskəni ətrafında düşərgə salsınlar ki, İsrail icması Rəbbin qəzəbinə düçar olmasın. Levililər Şəhadət məskəninə cavabdeh olsunlar». ");
INSERT INTO azb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","İsrail övladları bütün bunları Rəbbin Musaya əmr etdiyi kimi etdilər. ");
INSERT INTO azb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«İsrail övladları Hüzur çadırını əhatə edərək bir az kənarda, hər biri öz bayrağının altında ailələrinin nişanı ilə düşərgə salsınlar. ");
INSERT INTO azb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Şərq tərəfində, gündoğana tərəf Yəhuda ordugahına aid bölüklər öz bayraqlarının altında düşərgə salsınlar. Yəhudalıların rəhbəri Amminadav oğlu Naxşon olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Yəhuda ordusunda 74 600 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Onun yanında düşərgə salanlar İssakar qəbiləsi olacaq. İssakarlıların rəhbəri Suar oğlu Netanel olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Onun ordusundan 54 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Sonra Zevulun qəbiləsi düşərgə salacaq. Zevulun övladlarının rəhbəri Xelon oğlu Eliav olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Onun ordusundan 57 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Yəhuda ordugahından bölüklərinə görə bütün sayılanlar 186 400 nəfər idi. Onlar birinci köçəcəklər. ");
INSERT INTO azb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Cənub tərəfində Ruven ordugahına aid bölüklər öz bayraqlarının altında düşərgə salacaqlar. Ruvenlilərin rəhbəri Şedeur oğlu Elisur olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ruven ordusundan 46 500 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Onun yanında düşərgə salanlar Şimeon qəbiləsi olacaq. Şimeonluların rəhbəri Surişadday oğlu Şelumiel olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Onun ordusundan 59 300 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Sonra Qad qəbiləsi düşərgə salacaq. Qadlıların rəhbəri Deuel oğlu Elyasaf olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Onun ordusundan 45 650 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ruven ordugahından bölüklərinə görə sayılanların cəmi 151 450 nəfər idi. İkinci onlar gedəcəklər. ");
INSERT INTO azb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Hüzur çadırı yola düşəndə Levililərin düşərgəsi düşərgələrin ortasında dursun. Hərə necə düşərgə salıbsa, həmin nizamla, öz bayrağı altında yola düşsün. ");
INSERT INTO azb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Qərb tərəfində Efrayim ordugahına aid bölüklər öz bayraqlarının altında düşərgə salacaqlar. Efrayimlilərin rəhbəri Ammihud oğlu Elişama olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Efrayim ordusundan 40 500 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Onun yanında düşərgə salanlar Menaşşe qəbiləsi olacaq. Menaşşelilərin rəhbəri Pedahsur oğlu Qamliel olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Onun ordusundan 32 200 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Sonra Binyamin qəbiləsi düşərgə salacaq. Binyaminlilərin rəhbəri Gidoni oğlu Avidan olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Onun ordusundan 35 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Efrayim ordugahından bölüklərinə görə sayılanların cəmi 108 100 nəfər idi. Üçüncü onlar gedəcəklər. ");
INSERT INTO azb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Şimal tərəfində Dan ordugahına aid bölüklər öz bayraqlarının altında düşərgə salacaqlar. Danlıların rəhbəri Ammişadday oğlu Axiezer olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Dan ordusundan 62 700 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Onun yanında düşərgə salanlar Aşer qəbiləsi olacaq. Aşerlilərin rəhbəri Okran oğlu Pagiel olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Onun ordusundan 41 500 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Sonra Naftali qəbiləsi düşərgə salacaq. Naftalililərin rəhbəri Enan oğlu Axira olsun. ");
INSERT INTO azb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Onun ordusundan 53 400 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan ordugahından cəmi 157 600 nəfər siyahıya alındı. Öz bayraqlarının altında ən sonuncu onlar gedəcəklər». ");
INSERT INTO azb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","İsrail övladlarından ailələrinə görə siyahıya alınanlar bunlardır. Ordugahlardan bölüklərinə görə cəmi 603 550 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ancaq Rəbbin Musaya əmr etdiyi kimi Levililər digər İsrail övladları ilə birgə siyahıya alınmadı. ");
INSERT INTO azb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","İsrail övladları Rəbbin Musaya əmr etdiyi hər şeyi yerinə yetirdilər. Bayraqlarının altında belə düşərgə saldılar və hər kəs nəsil və ailəsi ilə birgə belə yola düşdü. ");
INSERT INTO azb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Rəbb Sina dağında Musa ilə danışdığı zaman Harunla Musanın nəsil tarixçəsi belədir. ");
INSERT INTO azb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Harun oğullarının adları belədir: ilk doğulan Nadav, Avihu, Eleazar və İtamar. ");
INSERT INTO azb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Harun oğullarının kahinlik vəzifəsinə keçirdiyi məsh olunmuş kahinlər bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadav ilə Avihu Sina səhrasında Rəbbin önündə haram od təqdim edərkən oradaca öldülər. Onların övladları yox idi. Eleazarla İtamar ataları Harunun yanında kahinlik etdilər. ");
INSERT INTO azb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Levi qəbiləsini gətir və kahin Harunun önündə dayandır ki, ona kömək etsinlər. ");
INSERT INTO azb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Qoy Hüzur çadırında Harun və bütün icma üçün öz vəzifələrini yerinə yetirərək müqəddəs məskənə xidmət etsinlər. ");
INSERT INTO azb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Hüzur çadırının bütün avadanlığına baxsınlar və məskənə xidmət edərək İsrail övladları üçün vəzifələrini yerinə yetirsinlər. ");
INSERT INTO azb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Levililəri Harunla oğullarının ixtiyarına ver; onlar İsrail övladları arasından tamamilə Onun xidmətinə verilmişdir. ");
INSERT INTO azb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Harunla oğullarına tapşır ki, öz kahinlik vəzifələrini yerinə yetirsinlər; müqəddəs yerə yaxınlaşan kənar adam isə öldürülsün». ");
INSERT INTO azb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Budur, hər İsrail qadınının doğduğu ilk oğlan uşağının əvəzinə İsraillilər arasından Levililəri seçmişəm. Levililər Mənimdir. ");
INSERT INTO azb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Çünki bütün ilk oğlanlar Mənimdir. Misir torpağında bütün ilk doğulanları məhv etdiyim gün İsraildə istər insan, istərsə heyvan – erkək olan bütün ilk doğulanları Özüm üçün ayırdım. Onlar Mənim olacaq. Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Rəbb Sina səhrasında Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Levililəri ailələrinə, nəsillərinə görə siyahıya al. Bir aylıq və ondan yuxarı yaşda olan bütün kişi cinsindən olanları siyahıya al». ");
INSERT INTO azb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Musa da Rəbbin sözünə görə əmr edildiyi kimi onları siyahıya aldı. ");
INSERT INTO azb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Adbaad Levi oğulları bunlardır: Gerşon, Qohat və Merari. ");
INSERT INTO azb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Nəsillərinə görə Gerşonun nəsil başçısı olan oğullarının adları belədir: Livni və Şimey. ");
INSERT INTO azb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Qohatın nəsil başçısı olan oğulları: Amram, İshar, Xevron və Uzziel. ");
INSERT INTO azb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merarinin nəsil başçısı olan oğulları: Maxli və Muşi. Ailələrinə görə Levi nəsilləri bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Livni və Şimey nəsilləri Gerşon nəslindəndir. Gerşon tayfaları bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Bir aylıq və ondan yuxarı yaşda olan bütün kişi cinsindən 7500 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gerşon nəsilləri qərb tərəfində məskənin arxasında düşərgə salmalıdırlar. ");
INSERT INTO azb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gerşon nəslinə mənsub olan ailələrin rəhbəri Lael oğlu Elyasafdır. ");
INSERT INTO azb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Hüzur çadırında Gerşon övladları Müqəddəs məskənə, çadır örtüklərinə, Hüzur çadırının girişində olan arakəsməyə, ");
INSERT INTO azb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","həyətin pərdələrinə, məskənlə qurbangahın ətrafındakı həyətin darvazasının arakəsməsi ilə iplərinə və bunlarla əlaqədar olan bütün xidmətə cavabdehdirlər. ");
INSERT INTO azb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amram, İshar, Xevron və Uzziel nəsilləri Qohat nəslindəndir. Qohat nəsilləri bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Bir aylıq və ondan yuxarı yaşda olan bütün kişi cinsindən 8600 nəfər siyahıya alındı. Onlar müqəddəs əşyalara cavabdehdirlər. ");
INSERT INTO azb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Qohat nəsilləri çadırın cənub tərəfində düşərgə salmalıdırlar. ");
INSERT INTO azb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Qohat nəsillərinə mənsub ailələrin rəhbəri Uzziel oğlu Elisafandır. ");
INSERT INTO azb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Onlar sandığa, masaya, çıraqdana, qurbangahlara, müqəddəs yerdə ibadət üçün işlənən bütün əşyalara, arakəsmə pərdəsinə və bunlarla əlaqədar olan bütün xidmətə cavabdehdirlər. ");
INSERT INTO azb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Levili rəhbərlərinin rəhbəri kahin Harun oğlu Eleazardır. O, Müqəddəs yerə cavabdeh olanlara nəzarətçi təyin edilmişdir. ");
INSERT INTO azb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Maxli və Muşi nəsilləri Merari nəslindəndir. Merari nəsilləri bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Bir aylıq və ondan yuxarı yaşda olan bütün kişi cinsindən 6200 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari nəsillərinə mənsub ailələrin rəhbəri Avixayil oğlu Surieldir. Onlar məskənin şimal tərəfində düşərgə salmalıdırlar. ");
INSERT INTO azb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merarililərə məskənin çərçivələri, şüvülləri, dirəkləri, altlıqları, bütün avadanlığı və bunlarla əlaqədar bütün xidmət, ");
INSERT INTO azb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","məskənin ətrafındakı həyətin dirəkləri ilə altlıqları, payaları və ipləri həvalə olundu. ");
INSERT INTO azb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa və Harun ilə oğulları məskənin şərq tərəfində, gündoğana doğru Hüzur çadırının önündə düşərgə salmalıdırlar. Onlar İsrail övladları üçün öz vəzifələrini yerinə yetirərək Müqəddəs məkana cavabdehdirlər. Oraya yaxınlaşan kənar adam öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Rəbbin əmri ilə Musa və Harunun Levi nəsillərindən saydıqları bir aylıq və ondan yuxarı yaşda kişi cinsindən olanlar cəmi 22 000 nəfər idi. ");
INSERT INTO azb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Rəbb Musaya dedi: «Bir aylıq və ondan yuxarı yaşda kişi cinsindən olan, ilk doğulan bütün İsrail övladlarını adları ilə siyahıya al. ");
INSERT INTO azb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","İsrail övladlarının bütün ilk oğlanlarının əvəzinə Levililəri və İsraillilərin ilk doğulan heyvanlarının əvəzinə Levililərin heyvanlarını Mənim üçün ayır. Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Musa Rəbbin ona əmr etdiyi kimi etdi. İsrail övladları arasında bütün ilk doğulanları siyahıya aldı. ");
INSERT INTO azb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Adları qeyd edilən, bir aylıq və ondan yuxarı yaşda ilk doğulan kişi cinsindən olanlar cəmi 22 273 nəfər idi. ");
INSERT INTO azb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Levililəri İsrail övladlarının ilk doğulanlarının əvəzinə və Levililərin heyvanlarını onların heyvanları əvəzinə ayır. Levililər Mənim olacaq; Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","İsraillilərin ilk oğlanlarından olub Levililərin sayını aşan 273 nəfəri satın almaq məqsədi ilə, ");
INSERT INTO azb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","hər adam üçün hər şekeldə iyirmi gera olan Müqəddəs yerdəki şekelə görə beş şekel götür. ");
INSERT INTO azb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Onları Levililərin sayını aşanları satınalma ödənişi olaraq Haruna və oğullarına ver. ");
INSERT INTO azb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Musa Levililərlə əvəz olanların sayını aşan İsrail övladlarından satınalma ödənişini götürdü. ");
INSERT INTO azb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","İsrail övladlarının ilk oğlanlarından Müqəddəs yerdəki şekelə görə 1365 şekel aldı. ");
INSERT INTO azb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa Rəbbin sözünə görə, Rəbbin ona əmr etdiyi kimi satınalma ödənişini Harunla oğullarına verdi. ");
INSERT INTO azb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Levililər arasından Qohat övladlarına mənsub nəsillərlə ailələri siyahıya alın. ");
INSERT INTO azb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Hüzur çadırında xidmət etməyə gələn otuz yaşından əlli yaşına qədər kişilərin hamısını hesablayın. ");
INSERT INTO azb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Qohatlıların Hüzur çadırında xidməti budur: ən müqəddəs əşyalara baxmaq. ");
INSERT INTO azb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Düşərgə yola düşəndə Harunla oğulları içəri girsinlər, arakəsmə pərdəsini endirərək onunla Şəhadət sandığını örtsünlər. ");
INSERT INTO azb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Onun üzərinə suiti dərisindən örtük çəkərək üstünə büsbütün bənövşəyi kətan sərsinlər və onun şüvüllərini yerinə qoysunlar. ");
INSERT INTO azb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Təqdis masası üzərinə bənövşəyi kətan sərərək kətanın üstündə sinilər, nimçələr, dolçalar və içmə təqdimi tökmək üçün piyalələr olmalıdır. Daimi çörək onun üzərində qalsın. ");
INSERT INTO azb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Onların üzərinə al rəngli bir kətan sərərək suiti dərisindən bir örtük çəksinlər və onun şüvüllərini yerinə qoysunlar. ");
INSERT INTO azb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Bənövşəyi kətan götürüb, işıq verəcək çıraqdanı, çıraqlarını, maşalarını, xəkəndazlarını və çıraqdan xidmətində işlədilən bütün zeytun yağı qablarını örtsünlər. ");
INSERT INTO azb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Çıraqdanı və onun bütün avadanlığını suiti dərisindən bir örtüklə sarıyıb xərəyə qoysunlar. ");
INSERT INTO azb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Qızıl qurbangahın üzərinə bənövşəyi kətan sərərək onu suiti dərisindən bir örtüklə örtsünlər və şüvüllərini taxsınlar. ");
INSERT INTO azb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Müqəddəs yerdə ibadət zamanı işlədilən bütün əşyaları götürərək bənövşəyi kətanla sarısınlar və suiti dərisindən bir örtüklə örtüb xərəyə qoysunlar. ");
INSERT INTO azb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Qurbangahdan külü təmizləyib, üzərinə tünd qırmızı kətan çəksinlər. ");
INSERT INTO azb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","İbadət zamanı işlədilən bütün əşyaları: xəkəndazı, çəngəlləri, kürəkləri, ləyənləri, qurbangahın bütün avadanlığını onun üzərinə qoysunlar. Sonra bunların üstünü suiti dərisindən bir örtüklə örtüb şüvüllərini taxsınlar. ");
INSERT INTO azb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Düşərgə yola düşəndə Harunla oğulları müqəddəs əşyaları və bütün avadanlığı örtməyi qurtarandan sonra Qohatlılar onu daşımağa gəlsinlər. Amma müqəddəs şeylərə toxunmamalıdırlar ki, ölməsinlər. Hüzur çadırında olan bu şeyləri daşımaq məsuliyyəti Qohatlılara aiddir. ");
INSERT INTO azb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Kahin Harun oğlu Eleazarın işi çıraq üçün zeytun yağına, ətirli buxura, daimi taxıl təqdimi və məsh yağına nəzarət etməkdir. O bütün məskənə və içində olan hər şeyə, müqəddəs yerlə avadanlığına nəzarət edəcəkdir». ");
INSERT INTO azb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Qoymayın ki Levililər arasından Qohatlıların nəsilləri yox olsun. ");
INSERT INTO azb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ancaq ən müqəddəs şeylərə yaxınlaşdıqları zaman ölməyib sağ qalsınlar deyə Harunla oğulları içəri girib onların hərəsini öz işinin üstünə və öz yükünün başında qoysun. ");
INSERT INTO azb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Lakin Qohatlılar bir an belə, içəri girib müqəddəs əşyalara baxmasınlar, yoxsa ölərlər». ");
INSERT INTO azb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gerşonluları da mənsub olduqları ailələrə və nəsillərə görə siyahıya al. ");
INSERT INTO azb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Onlardan otuz yaşından əlli yaşına qədər olanların hamısını siyahıya al. Qoy xidmət edib Hüzur çadırında iş görmək üçün gəlsinlər. ");
INSERT INTO azb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","İş görmək və yük daşımaq xüsusunda Gerşon nəsillərinin vəzifəsi budur: ");
INSERT INTO azb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Müqəddəs məskənin pərdələrini, Hüzur çadırı ilə onun örtüyünü, üzərindəki suiti dərisindən xarici örtüyü, Hüzur çadırının girişində olan arakəsməni, ");
INSERT INTO azb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","həyətin pərdələrini və qurbangahın ətrafındakı həyətin darvazasının arakəsməsi ilə iplərini və onların ibadət üçün işlənən bütün əşyalarını daşısınlar; bu şeylərlə görüləcək bütün işləri Gerşonlular görsünlər. ");
INSERT INTO azb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","İstər yük daşımaq, istərsə başqa iş görmək, edəcəkləri bütün xidmətlər Harunla oğullarının rəhbərliyi ilə görülsün. Gerşonlular daşıyacaqları hər yükə cavabdeh olsunlar. ");
INSERT INTO azb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hüzur çadırında Gerşon nəsillərinin xidməti budur. Onların vəzifələri kahin Harun oğlu İtamarın nəzarəti altında olsun. ");
INSERT INTO azb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Merarililəri mənsub olduqları nəsillərə və ailələrə görə siyahıya al. ");
INSERT INTO azb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Otuz yaşından əlli yaşına qədər Hüzur çadırının işini görmək üçün gələnlərin hamısını siyahıya al. ");
INSERT INTO azb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Hüzur çadırında xidmət edərkən onların vəzifəsi budur: məskənin çərçivələrini, şüvüllərini, dirəklərini, altlıqlarını, ");
INSERT INTO azb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","çadırın ətrafındakı həyətin dirəkləri ilə altlıqlarını, payalarını, iplərini, bütün avadanlığını və işlətdikləri hər şeyi daşımaq. Hər kəsi adbaad təyin et ki, müəyyən əşyaları daşısın. ");
INSERT INTO azb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Hüzur çadırında Merari nəsillərinin vəzifəsi budur. Onlar kahin Harun oğlu İtamarın nəzarəti altında xidmət edəcəklər». ");
INSERT INTO azb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa ilə Harun və icma başçıları, Qohatlılardan nəsillərə və ailələrə görə ");
INSERT INTO azb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","otuz yaşından əlli yaşına qədər Hüzur çadırına xidmət edib iş görmək üçün gələn kişilərin hamısını siyahıya aldılar. ");
INSERT INTO azb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Nəsillərinə görə 2 750 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hüzur çadırında xidmət edən Qohat nəsillərinə mənsub kişilərin cəmi bu idi. Rəbbin Musa vasitəsilə verdiyi əmrə görə Musa ilə Harun onları siyahıya aldılar. ");
INSERT INTO azb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gerşonlulardan nəsillərinə və ailələrinə görə ");
INSERT INTO azb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","otuz yaşından əlli yaşına qədər Hüzur çadırına xidmət edib iş görmək üçün gələn kişilərin hamısı siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Nəsillərinə və ailələrinə görə 2630 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gerşon nəslindən siyahıya alınan, Hüzur çadırında xidmət edən kişilərin cəmi bu idi. Rəbbin əmrinə görə Musa ilə Harun onları siyahıya aldılar. ");
INSERT INTO azb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari övladlarından nəsillərinə və ailələrinə görə ");
INSERT INTO azb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","otuz yaşından əlli yaşına qədər Hüzur çadırına xidmət edib iş görmək üçün gələn kişilərin hamısı siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Nəsillərinə görə 3200 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hüzur çadırında xidmət edən Merari nəsillərinə mənsub kişilərin cəmi bu idi. Rəbbin Musa vasitəsi ilə verdiyi əmrə görə Musa ilə Harun onları siyahıya aldılar. ");
INSERT INTO azb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Musa ilə Harun və İsrail rəhbərləri, nəsillərinə və ailələrinə görə bütün Levililəri, ");
INSERT INTO azb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","otuz yaşından əlli yaşına qədər, Hüzur çadırında xidmət etmək və yük daşımaq üçün gələn kişilərin hamısını siyahıya aldılar. ");
INSERT INTO azb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","8580 nəfər siyahıya alındı. ");
INSERT INTO azb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Rəbbin əmrinə görə hər biri edəcəyi xidmətə və daşıyacağı yükə görə Musanın nəzarəti ilə siyahıya alındılar; onlar Rəbbin Musaya əmr etdiyi kimi siyahıya alındılar. ");
INSERT INTO azb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«İsrail övladlarına əmr et ki, bütün iyrənc dəri xəstəliyi və xəstəliyə görə bədən axıntısı olan yaxud da meyitdən murdarlanan hər kəsi düşərgədən çıxarsınlar. ");
INSERT INTO azb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Onlar istər kişi olsun, istər qadın, arasında olduğum düşərgələrini murdar etməsinlər, onları düşərgədən çıxarın». ");
INSERT INTO azb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","İsrail övladları beləcə etdilər: onları düşərgədən çıxardılar. Rəbb Musaya necə söylədisə, İsrail övladları elə də etdilər. ");
INSERT INTO azb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«İsrail övladlarına söylə: “İnsanların işlətdiyi günahlardan birini edərək Rəbbə xəyanət edən kişi yaxud qadın təqsirkardır”. ");
INSERT INTO azb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Qoy o işlətdiyi günahı etiraf edib təqsirinin əvəzinin beşdə birini əlavə edərək qarşısında təqsirkar olan adama ödəsin. ");
INSERT INTO azb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Əgər o adamın təqsirinin əvəzini ala biləcək qohumu yoxdursa, ödənəcək əvəz Rəbb üçün verilsin; qoy bu təqsirkar üçün verdiyi kəffarə təkəsi ilə birlikdə kahininki olsun. ");
INSERT INTO azb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","İsrail övladlarının kahinə təqdim etdikləri bütün müqəddəs ianələr kahinə məxsusdur. ");
INSERT INTO azb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Hər kəsin özü üçün təqdis etdiyi əşyalar özünə məxsusdur, amma kahinə nə verərlərsə, kahinə aiddir». ");
INSERT INTO azb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«İsrail övladlarına belə söylə: “Bir kişinin arvadı əyri yola düşüb ona xəyanət etsə və ");
INSERT INTO azb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","başqa kişi ilə yaxınlıq edib cinsi əlaqədə olduğu ərindən gizlədilirsə və beləcə qadının murdar işi ortaya çıxmamışsa, heç bir şahid olmadığı üçün günah üstündə tutulmamışsa, ");
INSERT INTO azb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","əri qısqanclığa qapılıb murdar iş görən arvadından şübhələnməyə başlayarsa yaxud arvadı murdar iş görmədiyi halda yenə qısqanclığa qapılıb ondan şübhələnərsə, ");
INSERT INTO azb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","kişi arvadını kahinin yanına aparsın və arvadı üçün təqdim olaraq istənilən efanın onda biri qədər arpa unu gətirsin. Onun üzərinə nə zeytun yağı töksün, nə də kündür qoysun, çünki bu qısqanclıq üçün taxıl təqdimidir. Təqsirkarlığı xatırladan xatirə təqdimidir. ");
INSERT INTO azb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kahin qadını Rəbbin hüzuruna gətirsin; ");
INSERT INTO azb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","gil qaba müqəddəs su alaraq müqəddəs məskənin döşəməsindən toz götürüb suya salsın. ");
INSERT INTO azb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kahin qadını Rəbbin önündə dayandıraraq onun saçını dağıtsın. Sonra xatirə təqdimini onun ovuclarına qoysun. Bu, qısqanclıq üçün taxıl təqdimidir. Kahinin əlində isə lənət gətirən acı su olacaq. ");
INSERT INTO azb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kahin qadına and içdirib desin: ‹Əgər sən başqa kişi ilə yaxınlıq etməmisənsə, ərinin nikahı altında olaraq əyri yola düşüb murdarlıq etməmisənsə, lənət gətirən bu acı su sənə zərər vurmayacaq. ");
INSERT INTO azb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Lakin əri ilə nikahda olaraq əyri yola düşərək ərindən başqa bir kişi ilə yaxınlıq edib murdar olmusansa› ");
INSERT INTO azb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","onda kahin qadına lənət andını içdirib belə desin: ‹Rəbb sənin bətnini sonsuz edib qarnını şişirtdiyi zaman səni xalqının içində lənət və töhmətə düçar etsin. ");
INSERT INTO azb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Lənət gətirən bu su sənin qarnını şişirtmək və bətnini sonsuz etmək üçün bağırsaqlarına daxil olsun›. Qadın ‹Amin, amin!› desin. ");
INSERT INTO azb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Kahin bu lənətləri bir tumara yazsın və acı suda islatsın, ");
INSERT INTO azb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","sonra lənət gətirən acı suyu qadına içirtsin. Lənət gətirən su onun bətninə girəcək və acı olacaq. ");
INSERT INTO azb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kahin qısqanclıq üçün taxıl təqdimini qadının əlindən alsın və Rəbbin hüzurunda yellədikdən sonra qurbangaha gətirsin. ");
INSERT INTO azb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Xatirə təqdimi olaraq taxıl təqdimindən ovuc dolusu götürsün və qurbangahda tüstülədib yandırsın, sonra qadına suyu içirtsin. ");
INSERT INTO azb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Qadına suyu içirdikdən sonra əgər qadın murdar olub ərinə xəyanət etmişsə, lənət gətirən su onun bətninə girəcək və acılıq verəcək; onun qarnı şişəcək, bətni sonsuz olacaq və özü xalqının arasında lənətlənəcəkdir. ");
INSERT INTO azb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Əgər qadın murdarlıq etməmişsə və pakdırsa, su zərər vurmayacaq və uşaq doğa biləcəkdir. ");
INSERT INTO azb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Qısqanclığa aid olan qanun belədir: bir qadın əri ilə nikahda olarkən əyri yola düşüb murdar olanda ");
INSERT INTO azb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","yaxud bir kişi qısqanclığa qapılıb arvadından şübhələnəndə kahin qadını Rəbbin hüzurunda qoysun və ona bütün bu qanunu icra etsin. ");
INSERT INTO azb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Kişi bu işdə cəzasız qalsın, o qadın isə öz günahının cəzasını çəksin”». ");
INSERT INTO azb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«İsrail övladlarına söylə və onlara əmr et: “Bir kişi və yaxud bir qadın nəzirilik əhdi edib özünü Rəbbə həsr edərsə, ");
INSERT INTO azb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","şərabdan və başqa kefləndirici içkidən çəkinsin. Hətta şərab sirkəsi də, başqa kefləndirici içkidən hazırlanmış sirkə də, üzüm suyu da içməsin; nə üzüm, nə də kişmiş yesin. ");
INSERT INTO azb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Nəziri olduğu müddətdə çəyirdəkdən qabığa qədər meynədən istehsal edilmiş heç bir şey yeməsin. ");
INSERT INTO azb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Nəziri olduğu bütün müddətdə başına ülgüc dəyməsin, saçını uzatsın; özünü Rəbbə həsr etdiyi müddət qurtarana qədər müqəddəs olsun. ");
INSERT INTO azb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Özünü Rəbbə həsr etdiyi günlərdə meyitə yaxınlaşmasın. ");
INSERT INTO azb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Atası və anası, qardaşı və bacısı ölsə, onlara görə özünü murdar etməsin; çünki özünü Allahına həsretmə rəmzi onun başı üzərindədir. ");
INSERT INTO azb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Nəziri olduğu bütün müddətdə o, Rəbbə həsr edilmişdir. ");
INSERT INTO azb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Yanında bir adam birdən-birə qəflətən ölərsə və nəzirinin saçını murdar eləyərsə, o təmiz olduğu gün – yeddinci gün başını qırxdırsın. ");
INSERT INTO azb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Səkkizinci gün Hüzur çadırının girişində kahinə iki qumru quşu yaxud iki göyərçin gətirsin. ");
INSERT INTO azb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kahin birini günah qurbanı və o birini yandırma qurbanı kimi təqdim etsin ki, nəzirinin günahı üçün kəffarə olsun, çünki meyitlə bir yerdə olmaqla o günah işlətdi. Həmin gün yenidən başını təqdis etsin. ");
INSERT INTO azb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nəziri olduğu müddətdə özünü Rəbbə yenidən həsr etsin və təqsir qurbanı olaraq birillik erkək toğlu gətirsin. Əvvəlki günlər isə boşa getsin, çünki nəziriliyi murdarlanmışdır. ");
INSERT INTO azb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Nəziriyə aid olan qanun budur: özünü həsr etdiyi müddət qurtaranda nəziri Hüzur çadırının girişinə gətirilsin. ");
INSERT INTO azb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Orada Rəbbə bu təqdimləri gətirsin: yandırma qurbanı olaraq birillik qüsursuz bir erkək toğlu, günah qurbanı olan birillik qüsursuz bir dişi toğlu, ünsiyyət qurbanı olan qüsursuz bir qoç, ");
INSERT INTO azb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","bir səbət mayasız çörək, narın undan zeytun yağı ilə yoğrulmuş mayasız kökələrdən və üstünə zeytun yağı sürtülmüş mayasız qoğallardan ibarət olan taxıl təqdimləri və içmə təqdimləri. ");
INSERT INTO azb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kahin Rəbbin önündə onları təqdim etsin; günah qurbanını və yandırma qurbanını gətirsin. ");
INSERT INTO azb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Mayasız çörək səbəti ilə birgə qoçu Rəbbə ünsiyyət qurbanı kimi gətirsin; kahin onun taxıl təqdimi ilə içmə təqdimini də gətirsin. ");
INSERT INTO azb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Nəziri Hüzur çadırının girişində öz həsr etdiyi saçını qırxsın, sonra saçını götürüb ünsiyyət qurbanının altındakı oda qoysun. ");
INSERT INTO azb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nəziri həsr etdiyi saçını qırxdıqdan sonra kahin qoçun bişmiş bir qolunu, səbətdən götürdüyü mayasız bir kökə və mayasız bir qoğal ilə birgə nəzirinin ovuclarına qoysun. ");
INSERT INTO azb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Sonra yellətmə təqdimi kimi onları Rəbbin hüzurunda yellətsin. Onlar yellədilən döş əti və qaldırılan budla birgə müqəddəsdir, kahinə məxsusdur. Ondan sonra nəziri şərab içə bilər. ");
INSERT INTO azb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Özünü həsr etdiyinə görə Rəbbə təqdimini və buna əlavə olaraq verə biləcəyi başqa şeyləri əhd edən nəziri ilə əlaqədar qanun budur. Nəzirilik qanuna görə nəziri nə əhd etmişsə, onu icra etməlidir”». ");
INSERT INTO azb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Harun və oğullarına belə de: İsrail övladlarına belə xeyir-dua verin: ");
INSERT INTO azb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Qoy Rəbb sənə xeyir-dua verib səni qorusun; ");
INSERT INTO azb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Rəbb Öz nurlu üzünü sənə göstərərək lütf versin. ");
INSERT INTO azb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Rəbb üzünü sənə tərəf çevirsin, sənə sülh versin”. ");
INSERT INTO azb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Beləcə kahinlər Mənim adımla İsrail övladlarına xeyir-dua verəndə Mən də onlara xeyir-dua verəcəyəm». ");
INSERT INTO azb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musa məskəni qurub qurtaranda onu və bütün avadanlığını məsh və təqdis etdi. Qurbangah və bütün avadanlığını da məsh və təqdis etdi. ");
INSERT INTO azb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Sonra İsrail rəhbərləri təqdimləri gətirdilər. Onlar nəsil başçıları, siyahıya alınan xalqa nəzarət edən qəbilə rəhbərləri idi. ");
INSERT INTO azb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Rəbbə təqdim olaraq üstü örtülü altı araba və on iki öküz gətirdilər; hər iki rəhbər üçün bir araba və hər rəhbər üçün bir öküz. Bu təqdimləri məskənin önünə gətirdilər. ");
INSERT INTO azb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Onları bu adamlardan götür ki, Hüzur çadırındakı xidmətlərdə işlənilsin. Onları Levililərə, hər birinin vəzifəsinə görə ver». ");
INSERT INTO azb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Musa arabaları və öküzləri götürüb Levililərə verdi. ");
INSERT INTO azb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gerşonlulara vəzifələrinə görə iki araba və dörd öküz verdi; ");
INSERT INTO azb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Merarililərə isə vəzifələrinə görə dörd araba və səkkiz öküz verdi. Onların hamısı kahin Harun oğlu İtamarın nəzarəti altında idi. ");
INSERT INTO azb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Lakin Qohatlılara bir şey vermədi, çünki onların vəzifəsi müqəddəs əşyaları çiyinlərində daşımaqdır. ");
INSERT INTO azb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Qurbangah məsh edilən gün rəhbərlər onun təqdisi üçün təqdimlər gətirdilər; onlar təqdimlərini qurbangahın qabağına gətirdilər. ");
INSERT INTO azb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Çünki Rəbb Musaya demişdi: «Qurbangahın təqdisi üçün hər gün bir rəhbər öz təqdimini gətirsin». ");
INSERT INTO azb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Birinci gün təqdimi gətirən Yəhuda qəbiləsindən Amminadav oğlu Naxşon oldu. ");
INSERT INTO azb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Amminadav oğlu Naxşonun gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","İkinci gün İssakarlıların rəhbəri Suar oğlu Netanel təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini; yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","qurban ediləcək ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Suar oğlu Netanelin gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Üçüncü gün Zevulunluların rəhbəri Xelon oğlu Eliav təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","qurban ediləcək ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Xelon oğlu Eliavın gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Dördüncü gün Ruvenlilərin rəhbəri Şedeur oğlu Elisur təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","qurban ediləcək ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Şedeur oğlu Elisurun gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Beşinci gün Şimeonluların rəhbəri Surişadday oğlu Şelumiel təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın un ilə dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Surişadday oğlu Şelumielin gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Altıncı gün Qadlıların rəhbəri Deuel oğlu Elyasaf təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Deuel oğlu Elyasafın gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Yeddinci gün Efrayimlilərin rəhbəri Ammihud oğlu Elişama təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Ammihud oğlu Elişamanın gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Səkkizinci gün Menaşşelilərin rəhbəri Pedahsur oğlu Qamliel təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Pedahsur oğlu Qamlielin gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Doqquzuncu gün Binyaminlilərin rəhbəri Gidoni oğlu Avidan təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Gidoni oğlu Avidanın gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Onuncu gün Danlıların rəhbəri Ammişadday oğlu Axiezer təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","yandırma qurbanı olaraq bir dana, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Ammişadday oğlu Axiezerin gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On birinci gün Aşerlilərin rəhbəri Okran oğlu Pagiel təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş narın unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","yandırma qurbanı olaraq bir dana, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, birillik beş erkək toğlu. Okran oğlu Pagielin gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On ikinci gün Naftalililərin rəhbəri Enan oğlu Axira təqdimlərini gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Onun təqdimləri bunlar idi: Müqəddəs yerdəki şekelə görə yüz otuz şekel ağırlığında bir gümüş sini, yetmiş şekellik bir gümüş ləyən – bunların ikisi də taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş unla dolu idi; ");
INSERT INTO azb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","buxur dolu on şekel ağırlığında bir qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","yandırma qurbanı olaraq bir buğa, bir qoç, bir erkək toğlu; ");
INSERT INTO azb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","günah qurbanı olaraq bir təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ünsiyyət qurbanı olaraq iki öküz, beş qoç, beş təkə, beş erkək toğlu. Enan oğlu Axiranın gətirdiyi təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Qurbangah məsh ediləndə İsrail rəhbərlərinin onun təqdisi üçün gətirdiyi təqdimlər bunlardır: on iki gümüş sini, on iki gümüş ləyən, on iki qızıl nimçə; ");
INSERT INTO azb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","hər gümüş nimçənin ağırlığı yüz otuz şekel və hər ləyənin ağırlığı isə yetmiş şekel idi; bütün gümüş qabların ağırlığı Müqəddəs yerdəki şekelə görə iki min dörd yüz şekel idi; ");
INSERT INTO azb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","buxurla dolu on iki qızıl nimçədən hər birinin ağırlığı Müqəddəs yerdəki şekelə görə on şekel olub. Beləliklə, nimçələrdəki bütün qızılın ağırlığı yüz iyirmi şekel idi; ");
INSERT INTO azb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","yandırma qurbanı olaraq, taxıl təqdimləri ilə birlikdə heyvanların cəmi on iki buğa, on iki qoç, on iki erkək toğlu və günah qurbanı olaraq on iki təkə; ");
INSERT INTO azb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ünsiyyət qurbanı üçün heyvanların cəmi iyirmi dörd buğa, altmış qoç, altmış təkə, altmış erkək toğlu. Qurbangah məsh ediləndən sonra onun təqdisi üçün verilən təqdimlər bunlar idi. ");
INSERT INTO azb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa Rəbb ilə danışmaq üçün Hüzur çadırına girdiyi zaman Şəhadət sandığında olan kəffarə qapağının üzərindəki iki keruvun arasından ona xitab edən Rəbbin səsini eşidərdi. Rəbb Musa ilə danışardı. ");
INSERT INTO azb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Haruna de: “Yeddi çırağı elə qoy ki, çıraqdanın önünü işıqlandırsın”». ");
INSERT INTO azb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harun belə etdi; Rəbbin Musaya əmr etdiyi kimi çıraqları çıraqdanın önündə yerləşdirdi. ");
INSERT INTO azb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Çıraqdanın quruluşu belə idi: altlığından gül təsvirlərinə qədər yastılanmış qızıldan hazırlanmışdı. Çıraqdan Rəbbin Musaya göstərdiyi nümunəyə görə düzəldilmişdi. ");
INSERT INTO azb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«İsrail övladlarının arasından Levililəri götür və onları pak et. ");
INSERT INTO azb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Onları pak etmək üçün belə et: paklama suyunu üzərlərinə çilə, sonra bədənlərindəki bütün tükləri qırxıb geyimlərini yusunlar. Beləliklə, pak olarlar. ");
INSERT INTO azb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","O zaman bir buğa və onun taxıl təqdimi olan zeytun yağı ilə yoğrulmuş narın un götürsünlər. Günah qurbanı olaraq yenə bir buğa götür. ");
INSERT INTO azb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Levililəri Hüzur çadırının önünə gətir. İsrail övladlarının bütün icmasını da topla. ");
INSERT INTO azb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Levililəri Rəbbin önünə gətirdikdə qoy İsrail övladları əllərini onların üzərinə qoysunlar. ");
INSERT INTO azb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Harun yellətmə təqdimi olaraq İsrail övladlarının arasından Levililəri Rəbbin önünə gətirəcək ki, Rəbbə xidmət etsinlər. ");
INSERT INTO azb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Levililər əllərini buğaların başlarına qoysunlar; birini günah qurbanı və o birini yandırma qurbanı olaraq Rəbbə gətir ki, Levililər üçün kəffarə olunsun. ");
INSERT INTO azb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Levililəri Harunla oğullarının önündə dayandır. Sonra da onları Rəbbə gətirib yellətmə təqdimi olaraq həsr edəcəksən. ");
INSERT INTO azb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Levililəri İsrail övladları arasından beləcə ayır ki, Levililər Mənim olsun. ");
INSERT INTO azb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Levililəri pak edib yellətmə təqdimi olaraq həsr et; bundan sonra onlar Hüzur çadırında xidmət etmək üçün içəri girə bilər. ");
INSERT INTO azb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Çünki İsrail övladları arasından onlar tamamilə Mənə verilmişdir; İsrailli qadınların doğduğu bütün ilk oğlanların əvəzinə onları Özümə götürdüm. ");
INSERT INTO azb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","İsrail övladları arasında ilk doğulan bütün oğlanlar və bütün heyvan balaları Mənimdir; Misir diyarında bütün ilk oğlanları məhv etdiyim gün onları Özümə təqdis etdim. ");
INSERT INTO azb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ona görə də İsrail övladları arasında bütün ilk oğlanların yerinə Levililəri götürdüm. ");
INSERT INTO azb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","İsrail övladları arasından Levililəri Haruna və oğullarına hədiyyə olaraq verdim ki, Hüzur çadırında İsrail övladları üçün xidməti yerinə yetirib kəffarə etsinlər və beləcə Müqəddəs yerə yaxınlaşan İsrailliləri bəlaya düçar olmaqdan qorusunlar». ");
INSERT INTO azb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa ilə Harun və bütün İsrail övladlarının icması Levililər üçün deyilənləri etdilər. İsrail övladları Rəbbin Levililər haqqında Musaya əmr etdiyi hər şeyi yerinə yetirdilər. ");
INSERT INTO azb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levililər özlərini pak edib geyimlərini yudular. Harun onları Rəbbin önünə gətirib yellədilən təqdim olaraq həsr etdi və onlar üçün kəffarə etdi ki, pak olsunlar. ");
INSERT INTO azb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ondan sonra Levililər Harunla oğullarının nəzarəti altında Hüzur çadırında xidmətlərini icra etmək üçün Rəbbin Musaya əmr etdiyini yerinə yetirdilər. ");
INSERT INTO azb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Bu qanun Levililərə aiddir. İyirmi beş yaş və ondan yuxarı olanlar Hüzur çadırının işini görmək üçün içəri girsinlər. ");
INSERT INTO azb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Əlli yaşa çatanda isə gördükləri xidmətlərini dayandırıb daha işləməməlidirlər. ");
INSERT INTO azb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hüzur çadırında öz vəzifələrini yerinə yetirən qardaşlarına yardım edə bilərlər, lakin özləri xidmət etməsinlər. Levililərin vəzifələrini belə qaydaya sal». ");
INSERT INTO azb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","İsrail övladları Misir torpağından çıxdıqdan sonra ikinci ilin birinci ayında Rəbb Sina səhrasında Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«İsrail övladları Pasxa bayramını təyin olunmuş vaxtda qeyd etsinlər. ");
INSERT INTO azb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Onu ayın on dördüncü günündə, axşamçağı, təyin olunmuş vaxtda keçirin; onu bütün qaydalarına və hökmlərinə görə qeyd edin». ");
INSERT INTO azb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Beləcə Musa İsrail övladlarına əmr etdi ki, Pasxa bayramını keçirsinlər. ");
INSERT INTO azb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Sina səhrasında, birinci ayın on dördüncü günündə, axşamçağı Pasxa bayramını keçirtdilər. İsrail övladları Rəbbin Musaya əmr etdiyi hər şeyi yerinə yetirdilər. ");
INSERT INTO azb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ölüyə toxunub murdar olan adamlar vardı ki, o gün onlar Pasxa bayramını keçirə bilmədilər. Həmin gün bu adamlar Musa və Harunun yanına gəlib ");
INSERT INTO azb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","belə dedilər: «Ölüyə görə biz murdarıq, nə üçün biz başqa İsrail övladları kimi Rəbbə qurban təqdim etməkdən məhrum olaq?» ");
INSERT INTO azb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa onlara dedi: «Dayanın, görüm Rəbb sizin barədə nə əmr edəcək». ");
INSERT INTO azb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«İsrail övladlarına belə de: “Əgər sizdən yaxud nəslinizdən bir nəfər ölüyə toxunub murdar olarsa yaxud uzaq yolda olarsa, yenə də Rəbbin Pasxa bayramını keçirtsin. ");
INSERT INTO azb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","İkinci ayın on dördüncü günü axşamçağı Pasxa bayramını qeyd etsinlər. Pasxa qurbanını mayasız çörək və acı göyərti ilə yesinlər. ");
INSERT INTO azb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ondan sabaha qədər heç nə qalmasın və bir sümük belə qırılmasın. Pasxaya aid olan bütün qanunları icra etsinlər. ");
INSERT INTO azb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Amma kim ki pakdır, uzaq yolda deyil və Pasxanı keçirmirsə, öz xalqı arasından qovulsun; çünki təyin olunan vaxtda Rəbbin təqdimini gətirməmişdir, o adam günahının cəzasını çəksin. ");
INSERT INTO azb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Əgər sizinlə yaşayan bir yadelli Rəbbin Pasxa bayramını keçirmək istəyirsə, Pasxanı qaydalarına və hökmlərinə görə keçirsin; həm yadelli üçün, həm də yerli əhali üçün qayda bir olsun”». ");
INSERT INTO azb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Məskənin qurulduğu gün məskəni, Şəhadət çadırını bulud bürüyərdi; axşamdan səhərə qədər məskənin üzərindəki bulud alova oxşayırdı. ");
INSERT INTO azb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Daima belə oldu. Məskəni bürüyən bulud gecələr oda oxşayırdı. ");
INSERT INTO azb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Bulud çadırın üzərindən qalxan zaman İsrail övladları köç edərdilər; əgər bulud harada dayanardısa, İsrail övladları da orada düşərgə salardılar. ");
INSERT INTO azb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Onlar Rəbbin əmrinə görə yola düşər və Rəbbin əmrinə görə də məskən salardılar. Nə vaxt bulud məskənin üzərində dayanardısa, onlar düşərgə saldıqları yerdə qalardılar. ");
INSERT INTO azb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Bulud uzun müddət çadırın üzərində dayananda İsrail övladları Rəbbin buyruğuna riayət edərdilər. ");
INSERT INTO azb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Bəzən bulud məskənin üzərində bir neçə gün görünərdi; onlar Rəbbin əmrinə görə düşərgə saldıqları yerdə qalar, yenə Rəbbin əmrinə görə yola düşərdilər. ");
INSERT INTO azb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Bəzən də bulud axşamdan səhərə kimi dayanırdı; səhər erkən bulud qalxdıqda yola düşərdilər. İstər gecə, istər gündüz olsun bulud qalxanda yola düşərdilər. ");
INSERT INTO azb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","İstər iki gün olsun, istər bir ay və yaxud bir il, bulud məskən üzərində dayanıb qalanda İsrail övladları düşərgə saldıqları yerdə qalar, köç etməzdilər. Lakin qalxan zaman yola düşərdilər. ");
INSERT INTO azb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Rəbbin əmrinə görə düşərgə salardılar və Rəbbin əmrinə görə də yola düşərdilər. Musa vasitəsilə verdiyi əmrə görə Rəbbin buyruğuna riayət edərdilər. ");
INSERT INTO azb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Özünə yastılanmış gümüşdən iki kərənay düzəlt. Bunları icmanı çağırmaq və düşərgədəkilərin köçməsi üçün işlət. ");
INSERT INTO azb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","İki kərənay birdən çalınarsa, bütün icma sənin yanına, Hüzur çadırının girişinə toplansın. ");
INSERT INTO azb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Əgər tək biri çalınarsa, rəhbərlər, İsrailin tayfa başçıları sənin yanına toplansınlar. ");
INSERT INTO azb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Yüksək səslə çalınanda şərqi düşərgədəkilər yola düşsünlər. ");
INSERT INTO azb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Yenə də yüksək səslə çalınanda cənubi düşərgədəkilər yola düşsünlər. Onları yola salmaq üçün yüksək səslə çalınsın. ");
INSERT INTO azb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Camaatı toplamaq lazım olanda çalın, amma yüksək səslə çalmayın. ");
INSERT INTO azb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Kərənayları Harun oğulları olan kahinlər çalsınlar. Bu, nəsildən-nəslə sizin üçün əbədi qayda olsun. ");
INSERT INTO azb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Sizi torpağınızda sıxışdıran düşmənə qarşı döyüşə çıxanda kərənayları yüksək səslə çalın ki, Allahınız Rəbbin yadına düşüb düşmənlərinizdən xilas olasınız. ");
INSERT INTO azb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Şad gününüzdə, bayramlarınızda və Təzə Ay mərasimində yandırma qurbanlarınızı və ünsiyyət qurbanınızı verərkən kərənay çalın; Allahınızın qarşısında bu sizin üçün bir xatirə olsun. Allahınız Rəbb Mənəm». ");
INSERT INTO azb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","İkinci ilin ikinci ayında, ayın iyirminci günündə Şəhadət məskəninin üzərindən bulud çəkildi. ");
INSERT INTO azb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","İsrail övladları köçlərinə görə Sina səhrasından yola düşdülər. Bulud Paran səhrasında dayandı. ");
INSERT INTO azb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","İlk dəfə olaraq Musa vasitəsilə Rəbbin əmrinə görə yola düşdülər. ");
INSERT INTO azb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Öncə Yəhuda ordu dəstələri öz bayraqları altında yola düşdülər. Bu orduya Amminadav oğlu Naxşon rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","İssakar qəbiləsinin ordusuna Suar oğlu Netanel rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zevulun qəbiləsinin ordusuna isə Xelon oğlu Eliav rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Məskən söküləndə məskəni daşıyan Gerşon övladları və Merari övladları yola düşdülər. ");
INSERT INTO azb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ruven ordu dəstələri öz bayraqları altında yola düşdülər. Onlara Şedeur oğlu Elisur rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Şimeon qəbiləsinin ordusuna Surişadday oğlu Şelumiel rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Qad qəbiləsinin ordusuna Deuel oğlu Elyasaf rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Müqəddəs əşyaları daşıyan Qohatlılar yola düşdülər; onlar gələnədək o birilər məskəni qurardılar. ");
INSERT INTO azb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Efrayim ordu dəstələri öz bayraqları altında yola düşdülər. Onlara Ammihud oğlu Elişama rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Menaşşe qəbiləsinin ordusuna Pedahsur oğlu Qamliel rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Binyamin qəbiləsinin ordusuna isə Gidoni oğlu Avidan rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ən axırda isə Dan ordu dəstələri öz bayraqları altında yola düşdülər. Bu orduya Ammişadday oğlu Axiezer rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aşer qəbiləsinin ordusuna Okran oğlu Pagiel, ");
INSERT INTO azb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Naftali qəbiləsinin ordusuna Enan oğlu Axira rəhbərlik edirdi. ");
INSERT INTO azb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","İsrail ordu dəstələri bu nizamla yola düşərdilər. ");
INSERT INTO azb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa qayınatası Midyanlı Reuel oğlu Xovava dedi: «Rəbbin “sizə verəcəyəm” dediyi yerə yola düşürük, bizimlə gəl, biz sənə yaxşılıq edərik. Çünki Rəbb İsrailə yaxşılıq edəcəyinə söz verib». ");
INSERT INTO azb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Xovav ona dedi: «Gedə bilmərəm. Mən öz torpağıma və qohum-əqrəbamın yanına gedəcəyəm». ");
INSERT INTO azb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa dedi: «Xahiş edirəm, bizi tərk etmə, çünki səhrada düşərgə salacağımız yerləri sən bilirsən. Bizə bələdçilik et. ");
INSERT INTO azb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Bizimlə getsən, Rəbbin bizə edəcəyi yaxşılığı biz də sənə edərik». ");
INSERT INTO azb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","İsrail övladları Rəbbin dağından ayrılıb üç gün yol getdilər. Rəbbin Əhd sandığı da üç gün onların önündə getdi ki, dincələcəkləri yeri onlara göstərsin. ");
INSERT INTO azb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Düşərgə saldıqları yerdən yola düşdükləri vaxt Rəbbin buludu gündüz onların üzərində idi. ");
INSERT INTO azb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sandıq yola düşəndə Musa deyirdi: «Ya Rəbb qalx! Qoy düşmənlərin dağılsın, Sənə nifrət edənlər Sənin hüzurundan qaçsın». ");
INSERT INTO azb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sandıq dayananda belə deyirdi: «Ya Rəbb, İsrail tayfalarının on minlərinin yanına qayıt». ");
INSERT INTO azb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Camaat çəkdiyi sıxıntıdan Rəbbə şikayət etdi. Rəbb bunu eşidəndə qəzəbi alovlandı. Rəbbin odu onların arasında yandı və düşərgə ətrafındakıların bəzilərini məhv etdi. ");
INSERT INTO azb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Camaat Musaya fəryad etdi. Musa Rəbbə yalvardı və od söndü. ");
INSERT INTO azb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","O yerin adı Tavera qoyuldu, çünki onların arasında Rəbbin odu yanırdı. ");
INSERT INTO azb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Xalqın arasında olan alçaq yadellilərin iştahası ifrat dərəcədə artdı. İsrail övladları da yenə ağlayıb dedilər: «Kaş ki yeməyə ətimiz olaydı! ");
INSERT INTO azb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Misirdə müftə yediyimiz balıqları, xiyarları, qarpızları, kəvərləri, soğanları və sarımsaqları yadımıza salırıq. ");
INSERT INTO azb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ancaq indi iştahamız küsüb, yeməyə mannadan başqa bir şey görmürük». ");
INSERT INTO azb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna görünüşcə keşniş toxumu kimi idi, rəngi də mirvari rəngində idi. ");
INSERT INTO azb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Camaat dolaşar və onu yığıb dəyirmanda üyüdər yaxud da həvəngdə döyərdilər. Qazanda qaynadaraq kökə düzəldərdilər. Onun dadı zeytun yağı ilə bişirilmiş yeməklərə oxşayırdı. ");
INSERT INTO azb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Manna gecə düşərgə üzərinə düşən şehlə bərabər düşərdi. ");
INSERT INTO azb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa xalqın, hər ailənin çadırının qarşısında ağlamaqlarını eşitdi və Rəbbin qəzəbi çox alovlandı. Musa da narazı idi. ");
INSERT INTO azb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ona görə Rəbbə dedi: «Sən nə üçün quluna əzab verdin? Sənin gözündə lütf tapmadığım üçün bu xalqın bütün yükünü mənim üzəriməmi qoyursan? ");
INSERT INTO azb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Bütün bu xalqa mənmi hamilə olmuşam? Bunları mənmi doğmuşam? Məgər Sən istəyirsən ki, südəmər uşağı gəzdirən dayə kimi atalarına and içib söz verdiyin torpağa onları qucağımda mən aparım? ");
INSERT INTO azb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Bütün bu xalqa yedirtmək üçün əti mən haradan tapım? Çünki onlar mənim qarşımda ağlayaraq “bizə ət ver, yeyək” deyirlər. ");
INSERT INTO azb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Bu xalqı mən təkbaşına daşıya bilmərəm, çünki bu mənim üçün çox ağırdır. ");
INSERT INTO azb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Əgər mənimlə bu cür davranacaqsansa, gözündə lütf tapdımsa, onda nə olar, məni öldür ki, belə əzabı görməyim». ");
INSERT INTO azb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Rəbb Musaya dedi: «Mənə xalq arasında rəhbər və mötəbər saydığın İsrail ağsaqqallarından yetmiş nəfər topla. Onları Hüzur çadırına gətir və qoy səninlə dursunlar. ");
INSERT INTO azb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mən enərək orada səninlə danışacağam. Səndə olan Ruhdan götürüb onlara verəcəyəm ki, xalqın yükünü səninlə bərabər çəksinlər. Bununla da bu yükü təkbaşına daşımayacaqsan. ");
INSERT INTO azb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Xalqa de ki, sabah üçün özlərini pak etsinlər, çünki ət yeyəcəklər. “Kaş ki ətimiz olaydı! Misirdə halımız yaxşı idi” deyərək bərkdən ağladınız. Bunu Rəbb eşitdi. Ona görə Rəbb sizə ət verəcək, yeyəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nə bir gün, nə iki gün, nə beş gün, nə on gün, nə də iyirmi gün yeyəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Düz bir ay, burnunuzdan gələnə qədər, iyrənənə qədər yeyəcəksiniz; çünki aranızda olan Rəbbi rədd etdiniz və Onun qarşısında “nə üçün Misirdən çıxdıq?” deyərək ağladınız». ");
INSERT INTO azb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa dedi: «Arasında olduğum bu xalqda altı yüz min piyada vardır və Sən deyirsən: “Mən onlara bir aylıq yemək üçün ət verəcəyəm”. ");
INSERT INTO azb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bütün qoyun-keçi və mal-qara kəsilərsə, onlar doyarmı? Dənizin bütün balıqları tutularsa, onlar doyarmı?» ");
INSERT INTO azb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Rəbb Musaya dedi: «Məgər Rəbbin əli qısaldımı? İndi görəcəksən sənə dediklərim yerinə yetir ya yox». ");
INSERT INTO azb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Musa çıxdı və Rəbbin sözünü xalqa çatdırdı. Xalqın ağsaqqallarından yetmiş nəfəri topladı və çadırın ətrafında dayandırdı. ");
INSERT INTO azb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Rəbb buludda endi və Musa ilə danışdı. Ondakı Ruhdan götürüb yetmiş nəfər ağsaqqallara verdi; onların üzərinə Ruh çökən zaman peyğəmbərlik etdilər, amma sonra etmədilər. ");
INSERT INTO azb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Düşərgədə iki adam qalmışdı, birinin adı Eldad və o birinin adı Medad idi. Onlar yazılan yetmiş nəfər arasında idilər, lakin çadıra getməmişdilər. Ruh onların da üzərinə çökdü və onlar düşərgədə peyğəmbərlik edirdilər. ");
INSERT INTO azb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Bir gənc qaçaraq Musaya xəbər verib dedi: «Eldad və Medad düşərgədə peyğəmbərlik edirlər». ");
INSERT INTO azb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Gəncliyindən bəri Musanın köməkçisi olan Nun oğlu Yeşua «ağam Musa, onlara qadağan et» deyib fikrini bildirdi. ");
INSERT INTO azb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa ona cavab verdi: «Sən mənə görəmi qısqanırsan? Kaş Rəbbin bütün xalqı peyğəmbər olaydı və Rəbb onlara Ruhunu verəydi!» ");
INSERT INTO azb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Sonra Musa və İsrail ağsaqqalları düşərgəyə qayıtdılar. ");
INSERT INTO azb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Rəbb dənizdən bildirçin gətirən bir külək əsdirdi. Külək bildirçinləri düşərgənin hər istiqamətindən bir günlük yol qədər uzaqlığa, yerin üzərindən iki qulac qədər hündürlüyə saldı. ");
INSERT INTO azb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Bütün o gün, o gecə və ertəsi gün camaat çıxıb bildirçinləri yığdı. Ən az yığan on xomer yığdı. Bildirçinləri özləri üçün düşərgənin ətrafına sərirdilər. ");
INSERT INTO azb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Amma əti hələ dişləri arasında çeynəməmişdən əvvəl xalqa qarşı Rəbbin qəzəbi alovlandı, Rəbb onları şiddətli vəba ilə cəzalandırdı. ");
INSERT INTO azb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","O yerin adı Qivrot-Hattaava qoyuldu, çünki iştahası başqa yemək çəkənlər orada basdırıldı. ");
INSERT INTO azb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Camaat Qivrot-Hattaavadan Xaserota köçüb orada qaldı. ");
INSERT INTO azb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Məryəm ilə Harun Kuşlu qadından ötrü Musadan giley edirdilər. Çünki Musa özünə arvad olaraq həmin Kuşlu qadını almışdı. ");
INSERT INTO azb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Onlar dedilər: «Rəbb yalnız Musa vasitəsiləmi danışdı? Bizim vasitəmizlə də danışmadımı?» Rəbb bunu eşitdi. ");
INSERT INTO azb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa yer üzündə yaşayan bütün adamlardan daha itaətkar bir insan idi. ");
INSERT INTO azb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Rəbb bir anlıq Musaya, Haruna və Məryəmə dedi: «Üçünüz də Hüzur çadırına gəlin». Üçü də oraya getdilər. ");
INSERT INTO azb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","O zaman Rəbb bulud dirəyində endi və çadırın girişində durub Harunla Məryəmi çağırdı; hər ikisi önə çıxanda ");
INSERT INTO azb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Rəbb onlara dedi: «İndi sözlərimi dinləyin; Əgər aranızda bir peyğəmbər varsa, Mən Rəbb görüntüdə ona Özümü bildirərəm, Yuxuda onunla danışaram. ");
INSERT INTO azb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Qulum Musa isə elə deyil, O bütün evimdə sadiqdir. ");
INSERT INTO azb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mən onunla müəmmalarla deyil, Üzbəüz açıq danışaram və O, Rəbbin surətini görür. Nə üçün qorxmayaraq qulum Musadan gileyləndiniz?» ");
INSERT INTO azb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Rəbb onlara bərk qəzəbləndi və oradan getdi. ");
INSERT INTO azb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Bulud çadırın üzərindən çəkiləndə Məryəm cüzama tutulmuş, qar kimi ağarmışdı. Harun Məryəmə baxdıqda gördü ki, o cüzama tutulub. ");
INSERT INTO azb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Harun Musaya dedi: «Ey ağam, rica edirəm ki, axmaqlıq və günah işlədiyimizə görə bizi bu cəzanı çəkməyə qoyma. ");
INSERT INTO azb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Rica edirəm, qoyma ki onun bədəni ananın bətnindən çıxan ölü doğulmuş uşağın yarı çürümüş bədəninə bənzəsin». ");
INSERT INTO azb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa Rəbbə fəryad edib dedi: «Yalvarıram, ay Allah, ona şəfa ver!» ");
INSERT INTO azb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Rəbb Musaya dedi: «Əgər atası onun üzünə tüpürmüş olsaydı, yeddi gün gözdən düşməyəcəkdimi?» ");
INSERT INTO azb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Məryəm yeddi gün düşərgədən kənar yerdə saxlandı. O geri gətirilənə qədər camaat köçmədi. ");
INSERT INTO azb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ondan sonra camaat Xaserotdan yola düşdü və Paran səhrasında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«İsrail övladlarına verəcəyim Kənan torpağına nəzər salmağa adamlar göndər; atalarının hər qəbiləsindən bir rəhbər göndər». ");
INSERT INTO azb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa Rəbbin əmrinə görə Paran səhrasından onları göndərdi; hamısı İsrail övladlarının başçılarındandır. ");
INSERT INTO azb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Adları bunlardır: Ruven qəbiləsindən Zakkur oğlu Şammua; ");
INSERT INTO azb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Şimeon qəbiləsindən Xori oğlu Şafat; ");
INSERT INTO azb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yəhuda qəbiləsindən Yefunne oğlu Kalev; ");
INSERT INTO azb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","İssakar qəbiləsindən Yusif oğlu İqal; ");
INSERT INTO azb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efrayim qəbiləsindən Nun oğlu Huşə; ");
INSERT INTO azb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Binyamin qəbiləsindən Rafu oğlu Palti; ");
INSERT INTO azb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zevulun qəbiləsindən Sodi oğlu Qaddiel; ");
INSERT INTO azb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yusif qəbiləsindən, yəni Menaşşe qəbiləsindən Susi oğlu Qaddi; ");
INSERT INTO azb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan qəbiləsindən Gemalli oğlu Ammiel; ");
INSERT INTO azb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aşer qəbiləsindən Mikael oğlu Setur; ");
INSERT INTO azb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naftali qəbiləsindən Vofsi oğlu Naxbi; ");
INSERT INTO azb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Qad qəbiləsindən Maki oğlu Geuel. ");
INSERT INTO azb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ölkəni nəzərdən keçirmək üçün Musanın göndərdiyi adamların adları belədir: Musa Nun oğlu Huşəyə Yeşua adını verdi. ");
INSERT INTO azb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa onları Kənan torpağını nəzərdən keçirmək üçün göndərərkən dedi: «Bu yoldan Negevə gedin və dağlığa çıxın. ");
INSERT INTO azb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ölkənin necə olduğunu görün. Orada yaşayan xalq güclümü, zəifmi, azmı, çoxmu? ");
INSERT INTO azb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Yaşadıqları ölkə necə, yaxşımı, pismi? Şəhərləri necə, hasarlımı, istehkamsızmı? ");
INSERT INTO azb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Torpaq necə, münbitmi, məhsulsuzmu? Orada ağac varmı, yoxsa yox? Əlinizdən gələni edib ölkənin meyvəsindən gətirin». O zaman üzüm yetişən mövsüm idi. ");
INSERT INTO azb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Onlar yola düşdülər və Zin səhrasından Xamat keçidindəki Rexova qədər ölkəni nəzərdən keçirdilər. ");
INSERT INTO azb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Negevə çıxdılar və Xevrona çatdılar; orada Anaqlı Aximan, Şeşay və Talmay yaşayırdı. Xevron Misirdəki Soan şəhərindən yeddi il əvvəl tikilmişdi. ");
INSERT INTO azb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Eşkol vadisinə çatanda bir salxım üzümü olan bir tənək budağı kəsdilər və adamların ikisi bir neçə nar və əncirlə birlikdə tənək budağını aralarında bir şüvüldə aparırdılar. ");
INSERT INTO azb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","İsrail oğullarının oradan kəsdikləri salxıma görə o yerə Eşkol vadisi deyildi. ");
INSERT INTO azb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Qırx gündən sonra ölkəni nəzərdən keçirib qayıtdılar. ");
INSERT INTO azb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Paran səhrasındakı Qadeşə, Musa ilə Harunun və bütün İsrail övladlarının icmasının yanına gəldilər. Onlara və bütün icmaya xəbər gətirdilər, sonra ölkənin meyvələrini onlara göstərdilər. ");
INSERT INTO azb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Musaya belə izah edərək dedilər: «Bizi göndərdiyin ölkəyə çatdıq. Həqiqətən də, orada süd və bal axır. Budur o torpağın meyvələri! ");
INSERT INTO azb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Lakin orada yaşayan xalq çox güclüdür. Şəhərlər istehkamlı və çox böyükdür. Hətta orada Anaqlıları gördük. ");
INSERT INTO azb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Negev məntəqəsində Amaleqlilər, dağlıqda Xetlilər, Yevuslular və Emorlular, dəniz kənarında və İordan çayı sahilində isə Kənanlılar yaşayırlar». ");
INSERT INTO azb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalev Musanın önündə camaatı sakitləşdirib dedi: «Gedib oranı ələ keçirək. Çünki biz mütləq onların öhdəsindən gələrik». ");
INSERT INTO azb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Onunla gedən adamlar isə dedilər: «O xalqa hücum edə bilmərik, çünki onlar bizdən güclüdürlər». ");
INSERT INTO azb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Nəzərdən keçirdikləri torpaq haqqında İsrail övladlarına pis xəbər gətirib dedilər: «Gözdən keçirmək üçün içindən keçdiyimiz torpaq öz əhalisinin başını yeyən torpaqdır və orada gördüyümüz hər kəs uca boyludur. ");
INSERT INTO azb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Orada nəhəng adamların nəslindən olan Anaqlıları gördük. Onların yanında özümüzü çəyirtkə boyda hiss etdik, onlara da elə göründük». ");
INSERT INTO azb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Bütün icma uca səslə fəryad qoparıb gecə boyu ağladı. ");
INSERT INTO azb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","İsrail övladları Musaya və Haruna qarşı deyindilər; bütün icma onlara dedi: «Kaş Misir torpağında ya da bu səhrada öləydik! ");
INSERT INTO azb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nə üçün Rəbb bizi bu torpağa aparır? Yəni biz qılıncla qırılaq? Arvadlarımız və uşaqlarımız əsir olacaqlar. Misirə qayıtmaq bizim üçün daha yaxşı olmazdımı?» ");
INSERT INTO azb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Sonra bir-birlərinə dedilər: «Özümüzə başçı seçək və Misirə qayıdaq». ");
INSERT INTO azb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","O zaman Musa ilə Harun orada toplanmış bütün İsrail icmasının camaatının önündə üzüstə yerə sərildi. ");
INSERT INTO azb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ölkəyə nəzər salanlardan Nun oğlu Yeşua və Yefunne oğlu Kalev paltarlarını cırdılar; ");
INSERT INTO azb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","bütün İsrail övladlarının icmasına belə dedilər: «Nəzərdən keçirmək üçün içərisindən keçdiyimiz ölkə çox yaxşı bir ölkədir. ");
INSERT INTO azb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Əgər Rəbb bizdən razı qalarsa, bizi o ölkəyə aparacaq, süd və bal axan torpağı bizə verəcək. ");
INSERT INTO azb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ancaq Rəbbə qarşı üsyankarlıq etməyin. Ölkənin xalqından qorxmayın, onları məğlub edə bilərik. Müdafiəçiləri onları atıb getmişdir, amma Rəbb bizimlədir. Onlardan qorxmayın!» ");
INSERT INTO azb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Lakin bütün icma «Onları daşqalaq edin!» deyəndə Rəbbin izzəti Hüzur çadırında bütün İsrail övladlarına göründü. ");
INSERT INTO azb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Rəbb Musaya belə dedi: «Nə vaxtadək bu xalq Mənə hörmətsizlik edəcək? Aralarında etdiyim əlamətləri görə-görə nə vaxta qədər Mənə iman gətirməyəcəklər? ");
INSERT INTO azb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Onları vəba ilə cəzalandıracağam. İrsdən məhrum edəcəyəm. Onlardan çox böyük və güclü bir milləti səndən törədəcəyəm». ");
INSERT INTO azb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa Rəbbə dedi: «O zaman Misirlilər eşidəcək, çünki bu xalqı onların arasından qüdrətinlə Sən çıxartdın. ");
INSERT INTO azb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Bunu ölkənin əhalisinə anladacaqlar. Eşitdilər ki, Sən Rəbb bu xalqın arasındasan. Çünki, ya Rəbb, Sən onlarla üzbəüz görüşürsən, Sənin buludun onların üzərində durur. Sən gündüz bulud sütunu və gecə alov sütunu ilə onlara yol göstərirsən. ");
INSERT INTO azb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Əgər bu xalqın hamısını bir nəfər kimi öldürsən, Sənin şöhrətini eşidən millətlər belə deyəcəklər: ");
INSERT INTO azb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Rəbb and içərək vəd etdiyi ölkəyə bu xalqı apara bilmədiyi üçün onları səhrada öldürdü”. ");
INSERT INTO azb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","İstəyirəm ki, qoy indi Xudavəndin böyük qüdrəti göstərilsin, necə ki Sən dedin: ");
INSERT INTO azb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“Rəbb hədsiz səbirli, bol məhəbbətli, cəzanı və qanunsuzluğu bağışlayandır, lakin cəzasız da qoymaz, ataların cəzasını üçüncü-dördüncü nəslə çəkdirər”. ");
INSERT INTO azb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","İstəyirəm ki, Misirdən çıxdıqları gündən bu günə kimi bu xalqı necə bağışlamısansa, onların günahını böyük məhəbbətinə görə bağışlayasan». ");
INSERT INTO azb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Rəbb dedi: «Sənin ricana görə bağışladım, ");
INSERT INTO azb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","amma Varlığıma və Rəbbin bütün dünyanı dolduran izzətinə and olsun ki, ");
INSERT INTO azb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","izzətimi və Misirdə, eləcə də səhrada etdiyim əlamətləri görüb Məni on dəfə sınayan, Mənim sözümü dinləməyən bu adamların heç biri ");
INSERT INTO azb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","atalarına and içərək vəd etdiyim torpağı görməyəcək və Mənə hörmətsizlik edənlərin heç biri oranı görməyəcək. ");
INSERT INTO azb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ancaq qulum Kalevdə başqa ruh var. O bütün qəlbi ilə ardımca getdi. Onu gəzdiyi torpağa aparacağam və onun nəsli oranı irs olaraq alacaq. ");
INSERT INTO azb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amaleqlilər və Kənanlılar dərədə yaşayırlar. Ona görə sabah qayıdın və Qırmızı dənizin yolu ilə səhraya gedin». ");
INSERT INTO azb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Nə vaxta qədər bu pis icma Mənə qarşı deyinəcək? İsrail oğullarının Mənə deyinmələrini eşitdim. ");
INSERT INTO azb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Onlara de ki, Rəbb deyir: “Varlığıma and olsun ki, Mənə qarşı dediklərinizin eynisini sizə edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Meyitləriniz bu səhraya səriləcək. Mənə deyinən iyirmi və ondan yuxarı yaşda olub siyahıya alınanların hamısı səhrada öləcək, ");
INSERT INTO azb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","sizi sakin edəcəyimə əlimi qaldırıb and içdiyim torpağa girməyəcəksiniz. Oraya yalnız Yefunne oğlu Kalev və Nun oğlu Yeşua girəcək. ");
INSERT INTO azb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Lakin ‹əsir olacaqlar› dediyiniz uşaqlarınızı oraya aparacağam və sizin rədd etdiyiniz ölkəni onlar tanıyacaqlar. ");
INSERT INTO azb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Sizə gəldikdə isə meyitləriniz bu səhraya səriləcək. ");
INSERT INTO azb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Övladlarınız qırx il səhrada çobanlıq edəcəklər. Nə vaxta qədər ki siz səhrada məhv olmamısınız, sizin xəyanətinizin acısını çəkəcəklər. ");
INSERT INTO azb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ölkəni nəzərdən keçirdiyiniz günlərin sayına görə qırx gün, hər gün üçün bir il olmaqla, qırx il günahlarınızın cəzasını çəkəcəksiniz və sizdən üz döndərdiyimi biləcəksiniz”. ");
INSERT INTO azb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mən Rəbb söylədim: “Həqiqətən, Mənə qarşı birləşən bu pis icmaya belə də edəcəyəm. Bu səhrada ölüb tələf olacaqlar”». ");
INSERT INTO azb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Musanın ölkəni nəzərdən keçirmək üçün göndərdiyi adamlar qayıdıb ölkə haqqında pis xəbər gətirərək bütün icmanın Rəbbə qarşı deyinməsinə səbəb oldular. ");
INSERT INTO azb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ölkə haqqında pis xəbər gətirənlər Rəbbin önündə vəbadan öldü. ");
INSERT INTO azb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ölkəni nəzərdən keçirmək üçün gedənlərdən yalnız Nun oğlu Yeşua və Yefunne oğlu Kalev sağ qaldılar. ");
INSERT INTO azb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa bu sözləri bütün İsrail övladlarına danışdı və xalq çox kədərləndi. ");
INSERT INTO azb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Onlar səhər tezdən qalxıb dağın təpəsinə çıxaraq dedilər: «Günah etmişik, indi Rəbbin vəd verdiyi yerə çıxırıq». ");
INSERT INTO azb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musa dedi: «Nə üçün Rəbbin əmrinə qarşı çıxırsınız? Bunu bacara bilməzsiniz. ");
INSERT INTO azb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Döyüşə çıxmayın, çünki Rəbb aranızda deyil. Düşmənlərinizə məğlub olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Çünki Amaleqlilər və Kənanlılar orada önünüzdədir və qılıncla öləcəksiniz; madam ki Rəbbin ardınca getməkdən vaz keçdiniz, Rəbb sizinlə bərabər olmayacaq». ");
INSERT INTO azb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ancaq onlar özlərinə güvənərək dağlığın ən yüksək təpəsinə çıxdılar. Lakin nə Rəbbin Əhd sandığı, nə də Musa düşərgədən ayrılmadı. ");
INSERT INTO azb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","O zaman həmin dağlıqda yaşayan Amaleqlilər və Kənanlılar enib onlara hücum etdilər və Xorma şəhərinədək qovub məğlubiyyətə uğratdılar. ");
INSERT INTO azb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«İsrail övladlarına belə söylə: “Sakin olmaq üçün sizə verəcəyim torpağa girib yaşadığınız vaxt ");
INSERT INTO azb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","əgər kimsə Rəbbin xoşuna gələn ətri təqdim etmək üçün yandırma qurbanı, əhd qurbanı, könüllü qurban yaxud bayram qurbanı olaraq mal-qaradan yaxud qoyun-keçidən Rəbb üçün yandırma təqdimi versə, ");
INSERT INTO azb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Rəbbə qurban gətirən adam taxıl təqdimi kimi dörddə bir hin zeytun yağı ilə yoğrulmuş efanın onda biri qədər narın un gətirsin. ");
INSERT INTO azb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Yandırma qurbanı yaxud digər növlü qurban üçün hər bir quzuya tökülən içmə təqdimi olaraq dörddə bir hin şərab hazırlayın. ");
INSERT INTO azb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Qoç üçün taxıl təqdimi kimi hinin üçdə biri qədər zeytun yağı ilə yoğrulmuş efanın onda iki hissəsi qədər narın un və ");
INSERT INTO azb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","içmə təqdimi kimi hinin üçdə biri qədər şərab hazırlayın. Bunları Rəbbin xoşuna gələn ətir olaraq təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Rəbbə yandırma qurbanı, əhd qurbanı və yaxud ünsiyyət qurbanı kimi bir buğa kəsərkən ");
INSERT INTO azb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","buğa ilə birlikdə taxıl təqdimi kimi yarım hin zeytun yağı ilə yoğrulmuş efanın onda üçü qədər narın un gətirin. ");
INSERT INTO azb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","İçmə təqdimi kimi yarım hin şərab təqdim edin. Bu, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Hər buğa, qoç, quzu və yaxud keçi belə hazırlansın. ");
INSERT INTO azb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Nə qədər heyvan kəssəniz, hər biri ilə birlikdə eyni təqdimi gətirin. ");
INSERT INTO azb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Hər bir yerli İsrail övladı Rəbbin xoşuna gələn ətri – yandırma təqdimini gətirərkən bu şeyləri belə etsin. ");
INSERT INTO azb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Müvəqqəti yaxud nəsildən-nəslə aranızda yaşayan yadelli Rəbbin xoşuna gələn ətri – yandırma təqdimini gətirərkən eynilə sizin etdiyiniz kimi etsin. ");
INSERT INTO azb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ey camaat, sizin üçün də, sizinlə yaşayan yadelli üçün də qayda birdir, nəsillər boyu daimi qaydadır, çünki Rəbb sizə də, yadellilərə də bir gözlə baxır. ");
INSERT INTO azb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sizin üçün də, sizinlə yaşayan yadellilər üçün də eyni qanun və eyni hökm olmalıdır”». ");
INSERT INTO azb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«İsrail övladlarına belə söylə: “Mən sizi aparacağım torpağa girib yaşadığınız vaxt ");
INSERT INTO azb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","torpağın çörəyindən yeyəndə onun müəyyən hissəsini Rəbbə qaldırma təqdimi kimi verin. ");
INSERT INTO azb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","İlk xəmirinizdən bir yastı kökə gətirin, bunu xırmanınızın qaldırma təqdimi kimi verin. ");
INSERT INTO azb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","İlk xəmirinizdən edilən bu qaldırma təqdimini nəsildən-nəslə qədər Rəbbə verin. ");
INSERT INTO azb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Əgər səhv edib Rəbbin Musaya buyurduğu əmrlərin birinə – ");
INSERT INTO azb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Rəbbin əmr etdiyi gündən başlayaraq nəsildən-nəslə Musa vasitəsilə sizə buyurduğu hər hansı bir şeyə əməl etmirsinizsə ");
INSERT INTO azb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","bu iş səhvən İsrail icması tərəfindən bilmədən edilirsə, onda bütün icma Rəbbin xoşuna gələn ətir olaraq qaydaya görə taxıl və içmə təqdimləri ilə birlikdə yandırma qurbanı olaraq bir buğa və günah qurbanı olaraq bir təkə gətirsin. ");
INSERT INTO azb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kahin bütün İsrail övladlarının icması üçün kəffarə etsin. Beləcə onlar bağışlanacaqlar, çünki səhv olmuşdur və bu səhv üçün də Rəbb üçün yandırma təqdimi olan qurbanlarını və Onun hüzurunda günah qurbanlarını gətirmişlər. ");
INSERT INTO azb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Bütün İsrail icması və aralarında yaşayan yadellilər bağışlanacaq, çünki bütün xalq bilmədən səhv etmişdir. ");
INSERT INTO azb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Əgər bir nəfər bilmədən günah edərsə, qoy günah qurbanı olaraq birillik dişi keçi gətirsin. ");
INSERT INTO azb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kahin bilmədən günah işlədən adam üçün Rəbbin önündə kəffarə etsin ki, o bağışlansın. Kəffarə edilən adam bağışlanacaq. ");
INSERT INTO azb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","İsrail övladları arasında yerli olsun ya da yadelli olsun, bilmədən günah edənlər üçün qoy qanun bir olsun. ");
INSERT INTO azb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Lakin əgər yerli ya yadelli qəsdən günah işlətsə, Rəbbə küfr etmişdir və xalqı arasından qovulsun. ");
INSERT INTO azb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Çünki o, Rəbbin sözünə xor baxıb və Onun əmrini pozub. Belə adam mütləq qovulsun və öz cəzasını çəksin”». ");
INSERT INTO azb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","İsrail övladları səhrada olarkən Şənbə günündə odun yığan bir adama rast gəldilər. ");
INSERT INTO azb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Odun toplayan adamla rastlaşanlar onu Musanın, Harunun və bütün icmanın qarşısına gətirdilər. ");
INSERT INTO azb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","O adamı həbs etdilər, çünki onunla nə edəcəkləri hələ qərara alınmamışdı. ");
INSERT INTO azb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Rəbb Musaya dedi: «Bu adam öldürülməlidir; qoy bütün icma onu düşərgədən kənara aparsın və daşqalaq edərək öldürsün». ");
INSERT INTO azb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","İcma o adamı düşərgədən kənara çıxarıb Rəbbin Musaya əmr etdiyi kimi daşqalaq edərək öldürdü. ");
INSERT INTO azb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«İsrail övladlarına de ki, nəsildən-nəslə geyimlərinin ətəklərinə dörd tərəfdən qotaz tiksinlər. Hər qotazın üzərinə bənövşəyi qaytan salsınlar. ");
INSERT INTO azb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Bu qotazlara baxanda Rəbbin bütün əmrlərini xatırlayın və onlara əməl edin; öz ürəyinizin və gözlərinizin istəklərinə qapılıb Mənə xəyanət etməyin. ");
INSERT INTO azb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","O zaman bütün əmrlərimi yadda saxlayıb yerinə yetirəcəksiniz və Allahınızın hüzurunda müqəddəs olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Allahınız olmaq üçün sizi Misir torpağından çıxaran Allahınız Rəbb Mənəm. Bəli, Allahınız Rəbb Mənəm!» ");
INSERT INTO azb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Levi oğlu Qohat oğlu İshar oğlu Qorah qürurlanıb Ruven nəslindən Eliav oğulları Datan ilə Aviram və Pelet oğlu On ilə birlikdə ");
INSERT INTO azb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Musaya qarşı üsyan qaldırdılar. İsrail övladlarından icmada seçilmiş və ad qazanmış iki yüz əlli nəfər icma rəhbəri onlara qoşuldu. ");
INSERT INTO azb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Birlikdə toplanaraq Musa ilə Haruna qarşı çıxdılar və onlara dedilər: «Artıq bəsdir! Çünki bütün icmanın hamısı müqəddəsdir və Rəbb onların arasındadır. Nə üçün siz özünüzü Rəbbin camaatından üstün tutursunuz?» ");
INSERT INTO azb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa bunu eşidib üzüstə yerə sərildi. ");
INSERT INTO azb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Sonra Qorah ilə bütün yoldaşlarına dedi: «Səhər Rəbb kimin Ona məxsus, kimin müqəddəs olduğunu göstərəcək və həmin adamın Öz hüzuruna girməsinə izin verəcək. Rəbbin seçdiyi adam hüzuruna girməsinə izin verdiyi adamdır. ");
INSERT INTO azb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ey Qorah və bütün yoldaşları, özünüz üçün buxurdanlar alın; ");
INSERT INTO azb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","səhəri gün Rəbbin hüzurunda onların içinə közərmiş kömür və buxur qoyun. Beləliklə, Rəbb kimi seçibsə, müqəddəs olan o olacaqdır. Ey Levililər, artıq bəsdir!» ");
INSERT INTO azb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa Qoraha bunu da söylədi: «Ey Levililər, mənə qulaq asın! ");
INSERT INTO azb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","İsrailin Allahı sizi İsrail icmasından seçib Öz hüzuruna gəlməniz üçün imkan yaratdı ki, Rəbbin məskənində iş görəsiniz və icmanın önündə duraraq onlara xidmət edəsiniz. ");
INSERT INTO azb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Sizə və bütün Levili qardaşlarınıza Öz hüzuruna girmə səlahiyyətini verdi. Bu sizə azmı gəlir? İndi kahinliyi də istəyirsiniz? ");
INSERT INTO azb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Deməli, ey Qorah, sən və bütün yoldaşların belə toplanaraq Rəbbə qarşı çıxırsınız. Harun kimdir ki, ona qarşı deyinirsiniz?» ");
INSERT INTO azb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musa Eliav oğulları Datanı və Aviramı çağırtdırdı və onlar dedi: «Gəlməyəcəyik! ");
INSERT INTO azb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Bizi səhrada öldürmək üçün süd və bal axan ölkədən çıxardığın bəs deyil, hələ özünü üzərimizdə başçı etmək istəyirsən? ");
INSERT INTO azb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Bundan başqa, bizi süd və bal axan bir ölkəyə gətirmədin, irs olaraq bizə tarlalar və bağlar vermədin. Bu adamların gözündən pərdə asmaq istəyirsən? Gəlməyəcəyik!» ");
INSERT INTO azb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa çox qəzəblənib Rəbbə dedi: «Onların təqdimlərinə əhəmiyyət vermə; onlardan bir eşşək belə, almadım və onların heç birinə pislik etmədim». ");
INSERT INTO azb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa Qoraha dedi: «Sən və bütün yoldaşların, sabah Rəbbin hüzurunda olun – sən, onlar və Harun. ");
INSERT INTO azb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Hər biriniz öz buxurdanınızı götürüb üzərinə buxur qoyun. Sonra iki yüz əlli nəfərin hər biri buxurdan götürüb Rəbbin hüzuruna gətirsin. Sən və Harun da buxurdanınızı gətirin». ");
INSERT INTO azb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Hər kəs öz buxurdanını götürüb içinə közərmiş kömür və buxur qoydu. Sonra Musa və Harunla birgə Hüzur çadırının girişində durdular. ");
INSERT INTO azb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Qorah Musa ilə Haruna qarşı çıxmaq üçün bütün yoldaşlarını Hüzur çadırının girişinə toplayanda Rəbbin izzəti bütün icmaya göründü. ");
INSERT INTO azb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Bu icmadan ayrılın ki, onları bir an içində məhv edim». ");
INSERT INTO azb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Onlar üzüstə yerə sərildilər: «Ey Allah, bütün bəşərə ruh verən Allah! Bir adamın günahına görə bütün icmayamı qəzəblənirsən?» ");
INSERT INTO azb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«İcmaya de: “Qorah, Datan və Aviramın məskənlərinin ətrafından çəkilin!”» ");
INSERT INTO azb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa qalxıb Datanla Aviramın yanına getdi. İsrailin ağsaqqalları da onun ardınca getdilər. ");
INSERT INTO azb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Musa icmaya xəbərdarlıq edib dedi: «Nə olar, bu pis adamların məskənlərindən uzaqlaşın və onlara aid olan heç bir şeyə toxunmayın. Yoxsa onların bütün günahlarına görə siz məhv olarsınız». ");
INSERT INTO azb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Hamı Qorah, Datan və Aviramın məskənlərindən uzaqlaşdı. Datanla Aviram, arvadları, oğulları və körpə uşaqları ilə çıxıb çadırlarının girişində durdular. ");
INSERT INTO azb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa dedi: «Bütün bu işləri etmək üçün məni Rəbbin göndərdiyini, özbaşıma hərəkət etmədiyimi bununla biləcəksiniz. ");
INSERT INTO azb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Əgər bu adamlar hər kəsin öldüyü kimi ölsələr və yaxud hər kəsin başına gələn təcrübələrdən keçsələr, o halda Rəbb məni göndərməmişdir. ");
INSERT INTO azb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Lakin Rəbb yeni bir şey etsə, yer ağzını açaraq onları və onlara aid olan hər şeyi udsa, onlar ölülər diyarına diri-diri ensələr, bu adamların Rəbbi təhqir etdiklərini anlayacaqsınız». ");
INSERT INTO azb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musa bütün bu şeyləri danışıb qurtaran kimi onların altındakı yer yarıldı. ");
INSERT INTO azb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Yer ağzını açdı, onları, ailələrini, Qoraha aid olan bütün adamları və bütün mallarını uddu. ");
INSERT INTO azb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Onlar və onlara aid olanların hamısı diri-diri ölülər diyarına endilər. Yer üzərlərinə qapandı və camaat arasından yox oldular. ");
INSERT INTO azb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Onların ətrafında olan bütün İsrail övladları onların fəryadını eşidib «Yer bizi də udmasın!» deyərək qaçışdılar. ");
INSERT INTO azb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Rəbbin hüzurundan od çıxdı və buxur təqdim edən iki yüz əlli nəfəri məhv etdi. ");
INSERT INTO azb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«Kahin Harun oğlu Eleazara de, buxurdanları yanmış adamların üstündən götürsün, sən isə közləri kənara dağıt, çünki buxurdanlar müqəddəsdir. ");
INSERT INTO azb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Öz həyatı bahasına günah edən bu adamların buxurdanlarından qurbangah üçün örtük olaraq lövhələr düzəltsinlər. Çünki buxurdanlar Rəbbə təqdim edildiyi üçün müqəddəsdir. Qoy bu, İsrail övladlarına əlamət olsun». ");
INSERT INTO azb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Yandırılan adamların təqdim etmiş olduqları mis buxurdanları, kahin Eleazar Rəbbin Musa vasitəsilə ona dediyi kimi götürüb döydü və onlardan qurbangahı örtmək üçün lövhələr düzəltdi. ");
INSERT INTO azb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Bu, İsrail övladlarına bir xatirədir ki, Harunun nəslindən olmayan bir kənar şəxs Rəbbin hüzuruna gəlib buxur yandırmasın, yoxsa Qorah və yoldaşları kimi məhv olar. ");
INSERT INTO azb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ancaq ertəsi gün bütün İsrail övladlarının icması Musaya və Haruna qarşı deyinərək dedilər: «Rəbbin xalqını siz öldürdünüz». ");
INSERT INTO azb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","İcma Musaya və Haruna qarşı çıxmaq üçün toplanıb Hüzur çadırına yönələndə qəflətən bulud çadırı bürüdü və Rəbbin izzəti göründü. ");
INSERT INTO azb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musa ilə Harun Hüzur çadırının önünə gəldilər. ");
INSERT INTO azb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«Bu icmanın arasından çıxın ki, onları bir anda məhv edim». Musa ilə Harun üzüstə yerə sərildilər. ");
INSERT INTO azb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Sonra Musa Haruna dedi: «Öz buxurdanını götür, içinə qurbangahdan közərmiş kömür və buxur qoy. Tez icmaya apar, onlar üçün kəffarə et, çünki Rəbb qəzəbini tökdü. Vəba başladı». ");
INSERT INTO azb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Musanın dediyi kimi Harun buxurdanı götürdü və camaatın arasına qaçdı. Gördü ki, xalq arasında vəba başlamışdır. Buna görə buxuru təqdim edərək xalq üçün kəffarə etdi. ");
INSERT INTO azb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Harun ölülərlə dirilər arasında duranda vəba dayandı. ");
INSERT INTO azb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Qorah əhvalatında ölənlərdən başqa vəbadan ölənlər on dörd min yeddi yüz nəfər idi. ");
INSERT INTO azb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Vəba dayandığına görə Harun Musanın yanına Hüzur çadırının girişinə qayıtdı. ");
INSERT INTO azb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«İsrail övladlarına de və hər qəbilə üçün bir əsa götür. Qəbilə rəhbərlərinin hər birindən alınan on iki əsa olacaq. Hər birinin adını öz əsasının üzərinə yaz. ");
INSERT INTO azb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Harunun adını Levi əsasının üzərinə yaz ki, hər qəbilə başçısı üçün bir əsa olsun. ");
INSERT INTO azb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Əsaları sizinlə görüşdüyüm yerə, Hüzur çadırındakı Şəhadət sandığının qarşısına qoy. ");
INSERT INTO azb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","O zaman seçəcəyim adamın əsası tumurcuqlayacaq və İsrail övladlarının sizə qarşı sürəkli deyinmələrinə son qoyacağam». ");
INSERT INTO azb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Musa İsrail övladları ilə danışdı. Onların bütün rəhbərləri ona bir əsa verdilər. Hər qəbilə rəhbəri üçün biri olmaqla on iki əsa var idi. Harunun əsası da onların əsaları arasında idi. ");
INSERT INTO azb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa əsaları Şəhadət çadırında Rəbbin önünə qoydu. ");
INSERT INTO azb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ertəsi gün Musa Şəhadət çadırına girdi və gördü ki, Levi nəslini təmsil edən Harunun əsası tumurcuqlayıb. Budur, tumurcuq qönçələnmiş, çiçək açmış və badam yetişdirmişdi. ");
INSERT INTO azb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa əsaların hamısını Rəbbin hüzurundan bütün İsrail övladlarının qarşısına çıxardı. Əsalara baxdılar və hər kəs öz əsasını götürdü. ");
INSERT INTO azb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Rəbb Musaya dedi: «Üsyan edənlərə qarşı əlamət olaraq saxlamaq üçün Harunun əsasını Şəhadət sandığının önünə qoy. Bu onların Mənim üçün deyinmələrinə son qoyacaq ki, ölməsinlər». ");
INSERT INTO azb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa Rəbbin əmr etdiyinə əməl etdi. ");
INSERT INTO azb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","İsrail övladları Musaya dedilər: «Yox olacağımız bəllidir! Məhv olacağıq! Hamımız həlak olacağıq! ");
INSERT INTO azb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Rəbbin məskəninə yaxınlaşan hər kəs ölür. Doğrudanmı hamımız öləcəyik?» ");
INSERT INTO azb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Rəbb Haruna dedi: «Sən, övladların və atanın nəsli Müqəddəs məkanla əlaqədar hər hansı bir günah üçün məsuliyyət daşıyacaqsınız. Kahinliklə əlaqədar günahlar üçün məsuliyyəti yalnız sən və oğulların daşıyacaqsınız. ");
INSERT INTO azb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Atanın qəbiləsi olan Levi qəbiləsinə mənsub olan soydaşlarınızı da özünlə götür ki, sən və övladların Şəhadət çadırının önündə ikən sənə qoşulub kömək etsinlər. ");
INSERT INTO azb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Sənin qarşında cavabdehlik daşıyaraq çadırın bütün işlərinə baxsınlar. Ancaq müqəddəs yerin əşyalarına və qurbangaha yaxınlaşmasınlar ki, həm onlar, həm də siz ölməyəsiniz. ");
INSERT INTO azb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Sənə qoşulsunlar və Hüzur çadırının işlərinə, çadırdakı bütün xidmətlərə cavabdeh olsunlar. Başqa heç kimsə sizə yaxınlaşmamalıdır. ");
INSERT INTO azb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Müqəddəs yerə və qurbangaha cavabdeh olun ki, İsrail övladları bir də qəzəbimə düçar olmasınlar. ");
INSERT INTO azb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Budur, Mən İsrail övladları arasından Levili soydaşlarınızı sizə hədiyyə olaraq seçdim. Onlar Rəbbə Hüzur çadırında xidmət etmək üçün həsr olunmuşlar. ");
INSERT INTO azb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Lakin qurbangaha və pərdənin iç tərəfinə aid olan hər şeyə yalnız sən və oğulların kahin kimi xidmət edin. Kahinlik xidmətinizi sizə hədiyyə olaraq verirəm. Sizdən başqa müqəddəs yerə kim yaxınlaşarsa, öldürülsün». ");
INSERT INTO azb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Rəbb Haruna dedi: «Budur, Mənə gətirilən təqdimlərə nəzarət etməyi sənə tapşırdım. İsrail övladlarının bütün müqəddəs təqdimlərini əbədi pay olaraq sənə və övladlarına verirəm. ");
INSERT INTO azb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Qurbangahda yandırılmayan ən müqəddəs təqdimlərdən bunlar sənin olsun: taxıl təqdimləri, günah qurbanları və təqsir qurbanları – Mənə gətirilən ən müqəddəs təqdimlərin hamısı sənin və övladlarının olsun. ");
INSERT INTO azb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Bu ən müqəddəs şeyləri ye. Kişi cinsindən hər kəs onlardan yeyə bilər. Onları müqəddəs say. ");
INSERT INTO azb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Bunlar, İsrail övladlarının xüsusi hədiyyə olaraq gətirdikləri yellətmə təqdimlərinin hamısı sənindir. Onları sənə və oğullarınla qızlarına əbədi pay olaraq verdim. Sənin ailəndə pak olan hər kəs onu yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Rəbbə verdikləri ilk məhsulları, zeytun yağının ən yaxşısının hamısını, təzə şərabın və buğdanın ən yaxşısının hamısını sənə verdim. ");
INSERT INTO azb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Torpaqlarında bitən nübardan Rəbbə gətirdiklərinin hamısı sənin olsun. Sənin ailəndə pak olan hər kəs onu yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","İsraildə Rəbbə həmişəlik həsr olunan hər şey sənin olsun. ");
INSERT INTO azb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Hər bətndən ilk doğulan, Rəbbə həsr olunan bütün oğlanlar və bütün heyvan balaları sənin olsun. Ancaq hər ilk oğlanın əvəzini mütləq ödə, hər murdar heyvanın ilk balasının da əvəzini ödə. ");
INSERT INTO azb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Onlar bir aylıq olanda sənin qoyduğun qiymətə görə iyirmi gera ağırlığında olan Müqəddəs yerdəki şekelə görə beş şekel gümüşlə əvəzlərini ödə. ");
INSERT INTO azb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ancaq inəyin, qoyunun və yaxud da keçinin ilk balasının əvəzini ödəmə. Onlar müqəddəsdir. Qanlarını qurbangah üzərinə səp və piylərini tüstülədib yandır ki, Rəbbin xoşuna gələn ətir – yandırma təqdimi olsun. ");
INSERT INTO azb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Yellədilən döş əti və sağ budu kimi onların əti də sənin olsun. ");
INSERT INTO azb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","İsrail övladlarının Mənə qaldırma təqdimi kimi gətirdikləri müqəddəs təqdimlərin hamısını Mən Rəbb sənə və oğullarınla qızlarına əbədi pay olaraq verdim. Bu, Rəbbin səninlə və nəslinlə kəsdiyi əbədi və pozulmaz əhddir». ");
INSERT INTO azb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Rəbb Haruna dedi: «Onların torpağında sənin irsin olmayacaq və onlar arasında heç bir payın olmayacaq. İsrail övladları arasında sənin payın və irsin Mənəm. ");
INSERT INTO azb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Levililərə isə İsraildə olan bütün varidatın onda birini irs olaraq verdim. Bu, xidmətlərinin, Hüzur çadırında etdikləri xidmətin əvəzidir. ");
INSERT INTO azb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Artıq İsrail övladları Hüzur çadırına yaxınlaşmasınlar ki, günahlarının cəzasını çəkib ölməsinlər. ");
INSERT INTO azb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lakin Hüzur çadırının xidmətini Levililər etsinlər və çadırla əlaqədar günahlarının cəzasını çəksinlər. Bu, nəsildən-nəslə qədər sizin üçün əbədi qaydadır. İsrail övladları arasında onların irsi olmayacaq. ");
INSERT INTO azb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Bunun yerinə Levililərə irs olaraq İsrail övladlarının Rəbbə qaldırma təqdimi kimi verdikləri onda birini verdim. Buna görə Levililər üçün dedim ki, İsrail övladları arasında onların irsi olmayacaq». ");
INSERT INTO azb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Levililərə belə söylə: “İsrail övladlarının məhsullarından irsiniz olaraq sizə verdiyim onda bir hissəni aldığınız vaxt bu hissənin onda birini Rəbbə qaldırma təqdimi kimi verin. ");
INSERT INTO azb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Təqdiminiz xırmanda döyülən taxıl yaxud üzümsıxandan çıxan məhsul kimi sayılacaq. ");
INSERT INTO azb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Beləliklə, siz də İsrail övladlarından alacağınız onda birlərinizin hamısından Rəbbə qaldırma təqdimini gətirib kahin Haruna verin. ");
INSERT INTO azb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Bütün hədiyyələrinizdən Rəbbə qaldırma təqdimi verin. Hər təqdim onun təqdis olunmuş ən yaxşı hissəsindən olsun”. ");
INSERT INTO azb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Bunun üçün onlara deyin: “Ondan ən yaxşısını təqdim etdiyiniz zaman bu, Levililər üçün xırman məhsulu yaxud üzümsıxan məhsulu kimi sayılacaq. ");
INSERT INTO azb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Siz və ev xalqınız hər yerdə onu yeyəcəksiniz, çünki o, haqqınız, Hüzur çadırında olan xidmətinizin əvəzidir. ");
INSERT INTO azb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ondan ən yaxşısını təqdim edəndə ondan savayı günahın cəzasını çəkməmək üçün İsrail övladlarının müqəddəs təqdimlərini pozmayın ki, ölməyəsiniz”». ");
INSERT INTO azb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Rəbb Musaya və Haruna dedi: ");
INSERT INTO azb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Bu, Rəbbin əmr etdiyi qanunun qaydasıdır: İsrail övladlarına deyin ki, qüsursuz, eyibsiz, heç vaxt boynuna bir boyunduruq taxılmayan bir qırmızı düyə gətirsinlər. ");
INSERT INTO azb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Onu kahin Eleazara verin. Düyə düşərgənin kənarına çıxarılsın və onun önündə kəsilsin. ");
INSERT INTO azb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kahin Eleazar barmağı ilə onun qanından götürərək Hüzur çadırının önünə doğru yeddi dəfə çiləsin. ");
INSERT INTO azb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Onun gözləri önündə düyə yandırılsın. Dərisi, əti və qanı, bağırsağı ilə birgə yansın. ");
INSERT INTO azb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kahin sidr ağacının budağını, züfa otunu və al rəngli ipi götürüb yandırılan düyənin üstünə atsın. ");
INSERT INTO azb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Kahin geyimlərini yusun, bədənini su ilə yusun, sonra düşərgəyə girsin. O, axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Qoy düyəni yandıran adam da geyimlərini yusun, bədənini də su ilə yusun və axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Düyənin külünü pak adam toplayıb düşərgənin kənarında pak bir yerə qoysun və İsrail övladlarının icması naminə paklama suyu düzəltmək üçün saxlanılsın. Bu, günah qurbanıdır. ");
INSERT INTO azb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Düyənin külünü toplayan adam geyimlərini yusun və axşama qədər murdar sayılsın. Bu, İsrail övladları üçün və aralarında yaşayan yadellilər üçün də əbədi bir qaydadır. ");
INSERT INTO azb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Hər hansı bir insan meyitinə toxunan yeddi gün murdar olacaq. ");
INSERT INTO azb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Üçüncü və yeddinci gün özünü paklama suyu ilə paklasın ki, pak olsun. Əgər üçüncü və yeddinci gün özünü paklamasa, pak olmayacaq. ");
INSERT INTO azb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Bir ölüyə, hər hansı bir insan meyitinə toxunan və özünü pak etməyən adam Rəbbin məskənini murdar edər, o şəxs İsraildən qovulsun. Paklama suyu onun üzərinə səpilmədiyi üçün murdar sayılsın. Onun murdarlığı hələ üzərində qalır. ");
INSERT INTO azb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Çadırda ölən adam üçün təlimat belədir: çadıra girən və çadırda olan hər kəs yeddi gün murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","İplə bağlanmış qapağı olmayan hər açıq qab murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Çöldə qılıncla öldürülmüş olana, bir ölüyə yaxud bir insan sümüyünə yaxud da qəbirə toxunan şəxs yeddi gün murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Murdar adam üçün yanmış günah qurbanı külündən götürüb onun üzərinə axar su tökün. ");
INSERT INTO azb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Pak bir adam züfa otunu götürüb, o suya batırsın və çadırın, bütün qabların və orada olanların üzərinə çiləsin. Sümüyə, öldürülən adama, meyitə yaxud da qəbirə toxunan adamın üzərinə də çiləsin. ");
INSERT INTO azb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Pak adam murdar adamın üzərinə üçüncü gün və yeddinci gün çiləsin və yeddinci gün bu pak olacaq. O, geyimlərini yusun, su ilə yuyunsun və axşam pak sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ancaq murdar olub özünü pak etməyən adam camaat arasından qovulsun, çünki Rəbbin Müqəddəs məkanını murdarlayıb. Onun üzərinə paklama suyu çilənmədiyi üçün o murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Bu onlara əbədi qayda olsun: paklama suyu çiləyən adam geyimlərini yusun və paklama suyuna toxunan adam axşama qədər murdar sayılsın. ");
INSERT INTO azb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Murdar adamın toxunduğu hər şey murdar sayılsın. O şeyə toxunan adam axşama qədər murdar sayılsın». ");
INSERT INTO azb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Birinci ay bütün İsrail övladlarının icması Zin səhrasına gəldi. Onlar Qadeşdə dayandılar. Məryəm oradaca öldü və elə orada da basdırıldı. ");
INSERT INTO azb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","İcma üçün su yox idi, ona görə Musa və Haruna etiraz etmək üçün toplandılar. ");
INSERT INTO azb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Xalq Musaya narazılıq edib dedi: «Kaş ki biz də soydaşlarımızla birgə Rəbbin önündə öləydik! ");
INSERT INTO azb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Rəbbin camaatını bu səhraya nə üçün gətirdiniz? Bizim və heyvanlarımızın burada ölməsi üçünmü? ");
INSERT INTO azb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nə üçün bizi Misirdən çıxarıb belə pis yerə gətirdiniz? Bura nə əkin, nə əncir, nə bağ, nə də nar yeridir. İçməyə belə, su yoxdur». ");
INSERT INTO azb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa ilə Harun camaatın önündən Hüzur çadırının girişinə getdilər və üzüstə yerə sərildilər. Rəbbin izzəti onlara göründü. ");
INSERT INTO azb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Əsanı götür, sən və qardaşın Harun icmanı toplayın və onların gözü önündə qayaya su versin deyə söyləyin. Qayadan onlara su çıxart, icmaya və heyvanlarına içirt». ");
INSERT INTO azb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa əmr olunduğu kimi əsanı Rəbbin önündən götürdü. ");
INSERT INTO azb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa ilə Harun camaatı qayanın önünə topladılar və onlara dedilər: «Ey dönük olanlar, indi dinləyin; bu qayadan sizə su çıxaraqmı?» ");
INSERT INTO azb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Musa əlini qaldırdı və əsası ilə iki dəfə qayaya vurdu, qayadan bol su çıxdı. Bütün icma və onların heyvanları su içdilər. ");
INSERT INTO azb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Lakin Rəbb Musaya və Haruna dedi: «Madam ki İsrail övladlarının gözü önündə Mənim müqəddəsliyimi göstərərək Mənə iman etmədiniz, bu camaatı onlara verdiyim ölkəyə aparmayacaqsınız». ");
INSERT INTO azb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Bu sulara Meriva suları deyilir, çünki bu yerdə İsrail övladları Rəbb ilə mübahisə etdilər və Rəbb onlara Öz müqəddəsliyini göstərdi. ");
INSERT INTO azb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa Qadeşdən Edom padşahına bu xəbərlə qasidlər göndərdi: «Qardaşın İsrail belə deyir: “Çəkdiyimiz zəhmətin hamısını bilirsən. ");
INSERT INTO azb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Atalarımız Misirə köçdülər və biz bir xeyli vaxt Misirdə yaşadıq. Misirlilər bizimlə və atalarımızla pis rəftar etdilər. ");
INSERT INTO azb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Rəbbə fəryad etdik, O da səsimizi eşitdi və bir mələk göndərdi, bizi Misirdən çıxardı. İndi biz sənin sərhədinə yaxın bir şəhər olan Qadeşdəyik. ");
INSERT INTO azb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Sənə rica edib torpağından keçmək üçün izin istəyirəm. Biz tarladan və bağdan keçməyəcəyik, heç bir quyudan su içməyəcəyik. Padşah yolu ilə sənin torpaqlarından keçənədək sağa və sola dönməyəcəyik”». ");
INSERT INTO azb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Lakin Edomlular ona dedilər: «Torpağımızdan keçməyin, yoxsa qarşınıza qılıncla çıxarıq». ");
INSERT INTO azb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","İsrail övladları onlara dedilər: «Biz əsas yolla getmək istəyirik. Əgər biz və sürülərimiz sularından içəriksə, dəyərini ödəyərik; yalnız piyada getməkdən başqa heç nə istəmirik». ");
INSERT INTO azb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edomlular dedilər: «Keçmək olmaz». Sonra Edomlular böyük və güclü bir ordu ilə onların qarşısına çıxdılar. ");
INSERT INTO azb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edomlular ölkəsindən İsrail övladlarının keçməsinə izin verməyəndə İsraillilər onların torpaqlarından çəkildilər. ");
INSERT INTO azb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Bütün İsrail icması Qadeşdən yola düşüb Hor dağına gəldi. ");
INSERT INTO azb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Rəbb Edom torpağı sərhədində Hor dağında Musa ilə Haruna belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Harun ölüb öz xalqına qovuşacaq, çünki Meriva sularında sözümə qarşı çıxdığınız üçün İsrail övladlarına vəd etdiyim ölkəyə girməyəcək. ");
INSERT INTO azb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Harunu və oğlu Eleazarı götür, onları Hor dağına apar. ");
INSERT INTO azb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Harunun paltarlarını çıxar və onları oğlu Eleazara geyindir, Harun isə oradaca ölüb xalqına qovuşacaq». ");
INSERT INTO azb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa Rəbbin əmr etdiyi kimi etdi və bütün icmanın gözü önündə Hor dağına çıxdılar. ");
INSERT INTO azb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa Harunun kahinlik geyimlərini çıxarıb oğlu Eleazara geyindirdi. Harun orada dağın təpəsində öldü. Musa ilə Eleazar dağdan endilər. ");
INSERT INTO azb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Bütün icma Harunun öldüyünü bildi. Bütün İsrail xalqı onun üçün otuz gün yas tutdu. ");
INSERT INTO azb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Negevdə yaşayan Kənanlı Arad padşahı İsrail övladlarının Atarim yolundan keçdiyini eşitdi. O, İsrail övladları ilə vuruşaraq bir neçə nəfəri əsir tutdu. ");
INSERT INTO azb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","İsrail övladları Rəbbə əhd edib dedilər: «Əgər, həqiqətən, bu xalqı bizə təslim etsən, o zaman onların şəhərlərini tamamilə yox edəcəyik». ");
INSERT INTO azb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Rəbb İsraillilərin səsini eşitdi. Kənanlıları onlara təslim etdi. İsraillilər də onları və şəhərlərini tamamilə yox etdilər və beləliklə, o yerin adı Xorma qoyuldu. ");
INSERT INTO azb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Xalq Hor dağını tərk edib Edom torpağının ətrafından keçmək üçün Qırmızı dəniz yolundan keçdi. Yolda onların səbri tükəndi. ");
INSERT INTO azb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Onlar Allaha və Musaya qarşı deyinirdilər: «Nə üçün siz bizi Misirdən çıxardınız? Səhrada ölmək üçünmü? Axı burada nə çörək, nə də su var. Bu dadsız yeməkdən də iyrənirik». ");
INSERT INTO azb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","O zaman Rəbb xalqın arasına zəhərli ilanlar göndərdi. İlanlar xalqı sancdı və İsrail övladlarından çox adam öldü. ");
INSERT INTO azb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Xalq gəlib Musaya dedi: «Biz günah etdik, çünki Rəbbə və sənə qarşı deyindik. İndi isə ilanları bizdən uzaqlaşdırmaq üçün Rəbbə yalvar». Musa xalqı xilas etmək üçün Rəbbə yalvardı. ");
INSERT INTO azb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Rəbb Musaya dedi: «Özünə bir ilan düzəlt və onu uzun dəyənəyin üzərinə qoy. İlan vuran adam ona baxdıqda sağalsın». ");
INSERT INTO azb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Musa tuncdan bir ilan düzəltdi və dəyənəyin üzərinə qoydu, ilan vuran hər adam tunc ilana baxan kimi sağalırdı. ");
INSERT INTO azb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","İsrail övladları yola düşüb Ovotda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ovotdan köç edib Moavın şərqindəki səhrada İye-Avarimdə dayandılar. ");
INSERT INTO azb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Oradan da yola düşdülər və Zered vadisində dayandılar. ");
INSERT INTO azb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Oradan da yola düşüb Emorluların sərhədindən başlanan səhradakı Arnon dərəsinin o tayında dayandılar, çünki Arnon dərəsi Moavlılarla Emorlular arasındakı sərhəddir. ");
INSERT INTO azb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Bu barədə «Rəbbin Döyüşləri» kitabında yazılmışdır: «Sufada olan Vahev və vadilər, Arnon, ");
INSERT INTO azb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Arın məskəninə uzanıb Moav sərhədinə çatan vadilərin yamacları…» ");
INSERT INTO azb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Oradan Beerə yola düşdülər; Rəbbin Musaya «xalqı topla, onlara su verəcəyəm» dediyi quyu budur. ");
INSERT INTO azb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","O zaman İsrail övladları bu nəğməni oxudular: «Ey quyu, suların fışqırsın, Ona nəğmə oxuyun, ");
INSERT INTO azb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","O quyu ki onu başçıların açdı, Xalqın əsilzadələri Əsa ilə, dəyənəklə qazdı». Sonra səhradan Mattanaya yollandılar. ");
INSERT INTO azb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattanadan Naxalielə, Naxalieldən Bamota, ");
INSERT INTO azb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamotdan isə Moav torpağında olan dərəyə, çölə baxan Pisqa dağının yamaclarına getdilər. ");
INSERT INTO azb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","İsrail Emorluların padşahı Sixona qasidlər göndərib dedi: ");
INSERT INTO azb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Rica edirəm, sənin torpağından keçmək üçün bizə izin verəsən. Nə tarlaya, nə də bağa girəcəyik. Quyularının suyundan belə, içməyəcəyik. Sənin sərhədindən keçənədək yalnız padşah yolu ilə gedəcəyik». ");
INSERT INTO azb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Lakin Sixon İsraili öz sərhədlərindən buraxmayaraq bütün ordusunu topladı və İsrail övladları ilə vuruşmaq üçün səhraya çıxdı. Yahsaya çatanda İsraillilərə hücum etdi. ");
INSERT INTO azb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","İsrail övladları onu qılıncdan keçirdilər, Arnondan Yabboqa və Ammonluların sərhədinə qədər uzanan torpaqlarını aldılar. Çünki Ammon sərhədinin möhkəm istehkamı var. ");
INSERT INTO azb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","İsrail övladları bu şəhərlərin hamısını ələ keçirdilər. Xeşbon və ətrafındakı qəsəbələr daxil olmaqla Emorluların bütün şəhərlərinə yerləşdilər. ");
INSERT INTO azb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Çünki Xeşbon Emorluların padşahı Sixonun şəhəri idi. Sixon Moavın əvvəlki padşahı ilə döyüşmüş və Arnona qədər uzanan bütün torpaqlarını ələ keçirmişdi. ");
INSERT INTO azb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Bunun üçün şairlər belə deyirlər: «Xeşbona gəlin; Qoy yenidən qurulsun, Sixonun şəhəri bərpa edilsin. ");
INSERT INTO azb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Çünki Xeşbondan atəş, Sixonun şəhərindən alov çıxdı; Moavın Ar şəhərini, Arnonun təpələrinin başçılarını Yandırıb məhv etdi. ");
INSERT INTO azb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Vay halına, ey Moav! Ey Kemoşun xalqı, yox oldun! Kemoş övladları Emorluların padşahı Sixonun qarşısından qaçdı, Qızları əsir aparıldı. ");
INSERT INTO azb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Lakin biz onları məğlub etdik, Xeşbondan Divona qədər məhv oldular, Medvaya uzanan Nofahadək Hər tərəfi viran etdik». ");
INSERT INTO azb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","İsraillilər Emorluların torpağında məskunlaşdı. ");
INSERT INTO azb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa Yazeri nəzərdən keçirmək üçün adamlar göndərdi. İsrail övladları ətraf qəsəbələri ələ keçirərək orada yaşayan Emorluları qovdular. ");
INSERT INTO azb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Sonra istiqaməti dəyişib Başana yollandılar. Başan padşahı Oq bütün ordusu ilə birlikdə Edreidə onlarla döyüşə çıxdı. ");
INSERT INTO azb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Rəbb Musaya dedi: «Ondan qorxma, çünki Mən onu, bütün xalqını və torpağını sənə təslim edirəm. Xeşbonda yaşayan Emorluların padşahı Sixonun başına gətirdiyini onun da başına gətir». ");
INSERT INTO azb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","İsraillilər onu, övladlarını və bütün xalqını bir nəfər qalmayana qədər qırdılar və torpağını ələ keçirdilər. ");
INSERT INTO azb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","İsrail övladları yola düşüb Moav düzənliyində, İordanın şərqində Yerixonun qarşısında dayandılar. ");
INSERT INTO azb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","İsrailin Emorluların başına gətirdiyi hər şeyi Sippor oğlu Balaq görmüşdü. ");
INSERT INTO azb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Camaatı gördükdə Moavlılar bərk qorxdular, çünki İsrail xalqı çox idi. Moav sakinləri İsrail övladlarından vahiməyə düşdü. ");
INSERT INTO azb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moavlılar Midyan ağsaqqallarına dedilər: «Öküz çöl otunu yediyi kimi bu camaat da indi bütün ətrafımızı yeyib qurtaracaq». O vaxtlar Sippor oğlu Balaq Moav padşahı idi. ");
INSERT INTO azb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Beor oğlu Bilamı çağırmaq üçün Fərat çayının kənarındakı Petora, onun vətəninə qasidlər göndərib dedi: «Budur, Misirdən bir xalq çıxıb, yer üzünü bürüyərək yaxınlığımda yerləşmişdir. ");
INSERT INTO azb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Xahiş edirəm, indi gəl, mənim xeyrimə bu xalqa lənət oxu, çünki onlar məndən güclüdür. Bəlkə onda mən onları məğlub edib ölkədən qova bildim. Sənin xeyir-dua verdiyin şəxsin xeyir-dualı, lənətlədiyin şəxsin lənətli olduğunu bilirəm». ");
INSERT INTO azb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moav ağsaqqalları ilə Midyan ağsaqqalları fala baxmaq haqqını əllərinə götürüb Bilamın yanına getdilər və Balaqın sözlərini ona söylədilər. ");
INSERT INTO azb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bilam onlara dedi: «Bu gecəni burada keçirin ki, Rəbb mənə söyləyəcəyini sizə deyim». Beləliklə, Moav başçıları Bilamın yanında qaldılar. ");
INSERT INTO azb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Allah Bilamın yanına gəlib dedi: «Evindəki bu adamlar kimdir?» ");
INSERT INTO azb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bilam Allaha dedi: «Moav padşahı Sippor oğlu Balaq mənim yanıma adam göndərib dedi: ");
INSERT INTO azb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","“Budur, Misirdən çıxan xalq yer üzünü bürüyür. İndi gəl, mənim xeyrimə görə ona lənət oxu, bəlkə döyüşüb onları qova bildim”». ");
INSERT INTO azb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Allah Bilama dedi: «O adamlarla getmə, o xalqa lənət etmə, çünki xeyir-dualı xalqdır». ");
INSERT INTO azb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Bilam səhər tezdən durdu və Balaqın başçılarına dedi: «Torpağınıza qayıdın, çünki Rəbb sizinlə birgə getməyə mənə izin vermir». ");
INSERT INTO azb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moav başçıları qalxdılar və Balaqın yanına gəlib dedilər: «Bilam bizimlə birgə gəlmək istəmədi». ");
INSERT INTO azb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Yenə Balaq əvvəlkilərdən daha çox və daha etibarlı başçılar göndərdi. ");
INSERT INTO azb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Bilamın yanına gəlib ona dedilər: «Sippor oğlu Balaq belə deyir: “Xahiş edirəm, yanıma gəlməkdən imtina etmə. ");
INSERT INTO azb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Çünki sənə çox mükafat verəcəyəm və nə desən, hamısını edəcəyəm. İndi xahiş edirəm, gəl, mənim xeyrimə görə bu xalqa lənət oxu”». ");
INSERT INTO azb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bilam cavab verib Balaqın adamlarına dedi: «Balaq evini qızıl və gümüşlə dolu mənə versə belə, Allahım Rəbbin sözündən yan keçib, nə kiçik, nə də böyük iş görə bilərəm. ");
INSERT INTO azb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","İndi xahiş edirəm, siz də bu gecə burada qalın və görüm Rəbb mənə başqa nə deyəcək». ");
INSERT INTO azb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","O gecə Allah Bilama görünüb ona dedi: «Əgər bu adamlar səni çağırmaq üçün gəliblərsə, qalx onlarla get, ancaq Mənim sənə söyləyəcəyim şeyləri et». ");
INSERT INTO azb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Bilam səhər tezdən qalxaraq eşşəyinə palan vurub Moav başçıları ilə birgə getdi. ");
INSERT INTO azb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","O getdiyi üçün Allahın qəzəbi alovlandı və Rəbbin mələyi ona qarşı çıxmaq üçün yolda durdu. Bilam eşşəyinə minmişdi və onunla bərabər iki nökəri də vardı. ");
INSERT INTO azb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Eşşək sıyrılmış qılıncı əlində, yolda duran Rəbbin mələyini gördü və yoldan dönərək tarlaya girdi. Bilam yoluna döndərmək üçün eşşəyi vurdu. ");
INSERT INTO azb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Rəbbin mələyi bağların arasında dar bir yolda durdu. Hər iki tərəf divar idi. ");
INSERT INTO azb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Eşşək Rəbbin mələyini görüb divara sıxıldı və Bilamın ayağını divara sıxışdırdı. O yenə eşşəyi vurmağa başladı. ");
INSERT INTO azb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Rəbbin mələyi irəli çıxdı və sağa-sola dönmək üçün yol olmayan dar bir yerdə durdu. ");
INSERT INTO azb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Eşşək Rəbbin mələyini gördü və Bilamın altında çökdü. Bilamın qəzəbi alovlandı, dəyənəklə eşşəyi vurdu. ");
INSERT INTO azb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Rəbb eşşəyin dilini açdı və o, Bilama dedi: «Sənə nə etdim ki, məni üç dəfə vurdun?» ");
INSERT INTO azb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bilam eşşəyə dedi: «Çünki mənimlə əyləndin. Kaş ki əlimdə bir qılınc olaydı, indi səni öldürərdim». ");
INSERT INTO azb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Eşşək Bilama dedi: «Ömrünün əvvəlindən bu günə qədər belinə mindiyin eşşəyin mən deyiləmmi? Mən sənə heç belə edərdimmi?» Bilam dedi: «Xeyr». ");
INSERT INTO azb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Sonra Rəbb Bilamın gözlərini açdı. Bilam əlində sıyrılmış qılınc olan Rəbbin mələyinin yolda durduğunu gördü və başını əyib üzüstə yerə sərildi. ");
INSERT INTO azb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Rəbbin mələyi ona dedi: «Nə üçün eşşəyini üç dəfə vurdun? Budur, mən sənə qarşı durmaq üçün çıxdım. Məncə tezliklə yolun məhvə doğru gedir. ");
INSERT INTO azb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Eşşək məni gördü, bu üç dəfədir ki, önümdən yana döndü. Əgər yoldan dönməsəydi, həqiqətən, indi səni öldürərdim və onu sağ buraxardım». ");
INSERT INTO azb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bilam Rəbbin mələyinə dedi: «Günah etdim, çünki sənin mənə qarşı yolda durduğunu bilmədim. İndi əgər bu sənin gözündə pis görünürsə, qoy evimə qayıdım». ");
INSERT INTO azb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Rəbbin mələyi Bilama dedi: «Bu adamlarla get, ancaq yalnız sənə deyəcəyim sözü de». Bilam Balaqın başçıları ilə bərabər getdi. ");
INSERT INTO azb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaq Bilamın gəldiyini eşitdikdə onu qarşılamaq üçün Arnon çayının kənarında, torpağının ən uzaq sərhədində olan İr-Moav şəhərinə getdi. ");
INSERT INTO azb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaq Bilama dedi: «Səni çağırtdırmaq üçün adam göndərmədimmi? Nə üçün mənim yanıma gəlmədin? Məgər mən sənə mükafat verə bilmirəmmi?» ");
INSERT INTO azb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bilam Balaqa dedi: «Budur, indi sənin yanına gəldim! Amma nə deyə bilərəm ki? Ancaq Allahın dilimə qoyacaq sözü söyləyəcəyəm». ");
INSERT INTO azb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Bilam Balaqla birgə getdi və Qiryat-Xusota gəldilər. ");
INSERT INTO azb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaq mal-qaranı və qoyun-keçini qurban kəsdi. Bilama və onunla birgə olan başçılara ət göndərdi. ");
INSERT INTO azb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Bundan sonra səhəri gün Balaq Bilamı götürdü və onu Bamot-Baala çıxartdı. Bilam oradan İsrail xalqının bir hissəsini gördü. ");
INSERT INTO azb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bilam Balaqa dedi: «Burada mənə yeddi qurbangah düzəlt və mənim üçün burada yeddi buğa və yeddi qoç hazırla». ");
INSERT INTO azb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaq Bilamın dediyi kimi etdi. Balaq ilə Bilam hər qurbangahda bir buğa və bir qoç təqdim etdilər. ");
INSERT INTO azb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Bilam Balaqa dedi: «Sən yandırma qurbanının yanında dur, mən gedim. Bəlkə Rəbb məni qarşılamağa gələcək və mənə nə göstərsə, sənə bildirərəm». Sonra çılpaq bir təpəyə çıxdı. ");
INSERT INTO azb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Allah Bilamla qarşılaşdı və Bilam Ona dedi: «Yeddi qurbangah hazırladım və hər qurbangahda bir buğa ilə bir qoç təqdim etdim». ");
INSERT INTO azb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Rəbb Bilamın vasitəsilə bir kəlam dedi: «Balaqın yanına qayıdıb belə de». ");
INSERT INTO azb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Bilam Balaqın yanına qayıtdı. Gördü ki, Balaq və Moavın bütün başçıları yandırma qurbanlarının yanında durublar. ");
INSERT INTO azb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Bilam gələcəkdən xəbər verib dedi: «Balaq məni Aramdan, Moav padşahı məni şərq dağlarından gətirdi, “Gəl, mənim xeyrimə görə Yaquba lənət oxu, Gəl İsrailə qarğış et” dedi. ");
INSERT INTO azb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Allahın lənət etmədiyinə mən necə lənət edim? Rəbbin qarğış etmədiyinə mən necə qarğış edim? ");
INSERT INTO azb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Qayaların zirvəsindən onları görürəm mən, Təpələrdən onlara baxıram. Müstəqil yaşayan, Ellərdən özünü ayıran Bir xalq görürəm. ");
INSERT INTO azb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Kim Yaqubun tozunu saya bilər? İsrailin dörddə birini Axı kim hesablar? Qoy saleh adamların ölümü ilə ölüm! Onlar necə olubsa, sonum elə olsun!» ");
INSERT INTO azb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaq Bilama dedi: «Mənə nə etdin? Düşmənlərimə lənət etmək üçün səni gətirdim, budur, sən onlara xeyir-dua verdin!» ");
INSERT INTO azb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Bilam cavab verdi: «Rəbbin dilimə qoyduğunu söyləməyə diqqət etməli deyiləmmi?» ");
INSERT INTO azb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaq ona dedi: «Xahiş edirəm, mənimlə gəl, başqa bir yerə gedək, oradan onları görəcəksən. Onların hamısını yox, bir qismini görəcəksən. Oradan mənim xeyrimə onlara lənət oxu». ");
INSERT INTO azb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Onu Pisqa təpəsindəki Sofim yaylağına apardı, yeddi qurbangah düzəltdi və hər qurbangahda bir buğa, bir qoç təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bilam Balaqa dedi: «Bir az irəlidə Rəblə görüşə gedirəm. Sən burada yandırma qurbanının yanında dur». ");
INSERT INTO azb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Rəbb Bilama görünüb nə deyəcəyini ona bildirərək dedi: «Balaqın yanına qayıt və belə de». ");
INSERT INTO azb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Beləliklə, Bilam Balaqın yanına gəldi. Gördü ki, Balaq yandırma qurbanının yanında durub. Moav başçıları da onunla bərabər idi. Balaq ondan soruşdu: «Rəbb nə dedi?» ");
INSERT INTO azb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bilam gələcəkdən xəbər verib dedi: «Ey Balaq, oyan və dinlə; Ey Sippor oğlu, mənə qulaq as. ");
INSERT INTO azb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Allah insan deyil ki, Yalan söyləsin, Bəşər oğlu deyil ki, Fikrini dəyişdirsin. Dediyini həyata keçirməzmi? Verdiyi sözü yerinə yetirməzmi? ");
INSERT INTO azb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Budur, xeyir-dua üçün əmr aldım; O, xeyir-dua vermişdir, Mən onu dəyişə bilmərəm. ");
INSERT INTO azb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yaqubda bədbəxtlik üz verməyəcək. İsraildə bəla olmayacaq. Özlərinin Allahı Rəbb onlarladır, Onları padşah kimi alqışlayırlar. ");
INSERT INTO azb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Allah onları Misirdən çıxardı; Onların çöl öküzü kimi qüvvəti vardır. ");
INSERT INTO azb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yaqub üçün edilən baxıcılıq baş tutmaz, İsrail üçün edilən falçılıq alınmaz. Bax indi deyiləcək: “Yaqub və İsrail üçün Allah nələr etdi!” ");
INSERT INTO azb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Budur, xalq dişi aslan tək oyanır, Şir kimi qalxır, Şikarını yeməyincə, Ölənlərin qanını içməyincə yatmayacaq». ");
INSERT INTO azb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaq Bilama dedi: «Onlara nə lənət oxu, nə də xeyir-dua ver». ");
INSERT INTO azb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ancaq Bilam Balaqa cavab verib dedi: «Məgər sənə demədim ki, Rəbb nə desə, hamısını etməliyəm?» ");
INSERT INTO azb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaq Bilama dedi: «Xahiş edirəm gəl, səni başqa bir yerə aparım; bəlkə Allahın gözünə xoş gələr ki, oradan onlara mənim xeyrimə görə lənət oxuyasan». ");
INSERT INTO azb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaq Bilamı çölə baxan Peor təpəsinə apardı. ");
INSERT INTO azb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bilam Balaqa dedi: «Burada mənə yeddi qurbangah düzəlt və burada mənim üçün yeddi buğa və yeddi qoç hazırla». ");
INSERT INTO azb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaq Bilamın dediyi kimi etdi. Hər qurbangahda bir buğa və bir qoç təqdim etdi. ");
INSERT INTO azb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Bilam Rəbbin gözündə İsrailə xeyir-dua verməyin yaxşı olduğunu gördükdə əvvəlki kimi baxıcılıq etmədi, amma üzünü səhraya doğru çevirdi. ");
INSERT INTO azb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Bilam gözlərini qaldırdı və İsraili qəbilələrinə görə yerləşmiş görəndə onun üzərinə Allahın Ruhu endi. ");
INSERT INTO azb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","O, gələcəkdən xəbər verib dedi: «Budur, Beor oğlu Bilamın kəlamı, Uzaq görən adamın kəlamı, ");
INSERT INTO azb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Allahın sözlərini eşidən, Külli-İxtiyarın görüntüsünü görən, Gözləri açıq, yerə sərilən adamın kəlamı: ");
INSERT INTO azb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Ey Yaqub, sənin çadırların, Ey İsrail, məskənlərin nə gözəldir! ");
INSERT INTO azb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Yayılırlar vadilər tək, Çay kənarındakı bağ-bağçalar tək, Rəbbin bitirdiyi əzvay ağacları tək, Çay kənarındakı sidr ağacları tək. ");
INSERT INTO azb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Satıllarından sular axacaq, Toxumları bol su ilə sulanacaq, Padşahları Aqaqdan böyük olacaq, Padşahlıqları ucalacaq. ");
INSERT INTO azb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Allah onları Misirdən çıxartdı; Onların çöl öküzü kimi qüvvəti var. Onlar düşmən millətləri yeyib qurtaracaq. Sümüklərini qıracaq, Oxları ilə onları dələcək. ");
INSERT INTO azb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Onlar pusub şir kimi yatar, Dişi aslana oxşar. Onları oyandırmağa kim cürət edər? Sizə xeyir-dua verən xeyir-dualı olsun, Sizə lənət oxuyan qoy lənətli olsun!”» ");
INSERT INTO azb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Bilama qarşı Balaqın qəzəbi alovlandı. Balaq əllərini bir-birinə vurdu və Bilama dedi: «Səni düşmənlərimə lənət etmək üçün çağırdım və budur, üçüncü dəfədir ki, onlara ancaq xeyir-dua verirsən. ");
INSERT INTO azb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","İndi tez get, yerinə qayıt. Demişdim ki, səni çox mükafatlandıracağam, amma Rəbb səni mükafatdan məhrum etdi». ");
INSERT INTO azb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bilam Balaqa dedi: «Yanıma göndərdiyin qasidlərə demədimmi, ");
INSERT INTO azb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Balaq mənə qızıl və gümüşlə dolu evini versə belə, Rəbbin sözündən bilə-bilə yan keçib yaxşılıq yaxud pislik edə bilmərəm. Rəbb nə desə, onu deyəcəyəm. ");
INSERT INTO azb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","İndi mən xalqımın yanına qayıdıram. Qoy mən bu xalqın gələcəkdə sənin xalqının başına nə gətirəcəyini bildirim». ");
INSERT INTO azb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Sonra Bilam gələcəkdən xəbər verib dedi: «Budur, Beor oğlu Bilamın kəlamı, Uzaq görən adamın kəlamı, ");
INSERT INTO azb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Allahın sözlərini eşidən, Haqq-Taalanın biliyinə qovuşan, Külli-İxtiyarın görüntüsünü görən, Gözləri açıq, yerə sərilən adamın kəlamı: ");
INSERT INTO azb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Onu mən görürəm, amma indi deyil, Mən ona baxıram, amma yaxından deyil. Yaqubdan bir ulduz çıxacaq, İsraildən bir Əsa ucalacaq, Moavlıların alınlarını, Şet övladlarının başlarını əzəcək. ");
INSERT INTO azb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Onun düşməni Edomla Seir təslim olacaq, İsrail isə get-gedə güclənəcək. ");
INSERT INTO azb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yaqubun nəslindən olan o adam Səltənət sürəcək, Şəhərdə sağ qalanları məhv edəcək”». ");
INSERT INTO azb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Bilam Amaleqliləri görəndə gələcəkdən xəbər verib belə dedi: «Amaleq millətlərin birincisi idi, Ancaq axırda məhv olacaq». ");
INSERT INTO azb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Qenliləri görəndə gələcəkdən xəbər verib belə dedi: «Məskəniniz möhkəm, Yuvanız qayada qurulub. ");
INSERT INTO azb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Amma, ey Qenlilər, Aşşurlular sizi əsir alanda Yanıb yox olacaqsınız». ");
INSERT INTO azb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Bilam gələcəkdən xəbər verməyə belə davam etdi: «Vay, Allah bunu etdiyi zaman kim yaşaya biləcək? ");
INSERT INTO azb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kittim sahillərindən gəmilər gələcək, Aşşur ilə Everi ram edəcək, Amma onlar da məhv olacaq». ");
INSERT INTO azb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Bundan sonra Bilam yola çıxıb evinə qayıtdı. Balaq da öz yoluna davam etdi. ");
INSERT INTO azb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","İsrail xalqı Şittimdə yaşayarkən kişiləri Moav qızları ilə zina etməyə başladı. ");
INSERT INTO azb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Bu qadınlar allahlarına qurban kəsəndə İsrail xalqını da dəvət edirdilər. İsrail xalqı qurban ətindən yedi və onların allahlarına səcdə etdi. ");
INSERT INTO azb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","İsrail övladları Peordakı Baal bütünə səcdə edənlərə qoşuldular və Rəbbin qəzəbi İsraillilərə qarşı alovlandı. ");
INSERT INTO azb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Rəbb Musaya dedi: «Xalqın bütün başçılarını götürüb gündüz Rəbbin önündə dar ağacından asdır. Beləliklə, qoy Rəbbin qızğın qəzəbi İsraildən dönsün». ");
INSERT INTO azb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Buna görə Musa İsrailin hakimlərinə dedi: «Hər biriniz öz adamlarınız arasında Peordakı Baala səcdə edənlərə qoşulanları öldürün». ");
INSERT INTO azb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Bu an İsrail övladlarından olan bir nəfər gəldi, Musanın və Hüzur çadırının girişində ağlaşan bütün İsrail övladlarının icmasının gözü önündə qohumlarına Midyanlı bir qadın gətirdi. ");
INSERT INTO azb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kahin Harun oğlu Eleazar oğlu Pinxas bunu görən kimi icmanın arasından qalxdı və əlinə bir nizə götürdü. ");
INSERT INTO azb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","İsrailli adamın ardınca çadırın içinə girdi, nizəni İsrailli kişinin və qadının qarnına soxdu. Beləliklə, İsrail övladlarını qıran vəba dayandı. ");
INSERT INTO azb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Vəbadan ölənlərin sayı iyirmi dörd min nəfər idi. ");
INSERT INTO azb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Kahin Harun oğlu Eleazar oğlu Pinxas Mənim qəzəbimi İsrail övladlarından döndərdi, çünki aralarında yalnız o Mənim qeyrətimi çəkdi. Beləliklə, Mən qeyrətimə görə İsrail övladlarını məhv etmədim. ");
INSERT INTO azb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Buna görə söylə: “Budur, Mən onunla sülh əhdi bağlayıram. ");
INSERT INTO azb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Bu onun üçün və ondan sonra gələn nəsli üçün əbədi kahinlik əhdi olacaq. Çünki Allahının qeyrətini çəkib İsrail övladları üçün kəffarə etdi”». ");
INSERT INTO azb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Midyanlı qadınla birgə öldürülən İsrailli kişinin adı Salu oğlu Zimri idi. O, Şimeonlular arasında bir nəsil rəhbəri idi. ");
INSERT INTO azb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Öldürülən Midyanlı qadının adı Sur qızı Kozbi idi. Sur Midyanda bir nəsil başçısı idi. ");
INSERT INTO azb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Midyanlıları düşmən hesab edin və onları qırın. ");
INSERT INTO azb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Çünki onlar hiylə ilə sizə düşmənçilik etdilər. Peor hadisəsində və Peorda baş verən vəba günündə öldürülən bacıları, Midyanlı bəyin qızı Kozbi məsələsində sizi aldatdılar». ");
INSERT INTO azb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Vəbadan sonra Rəbb Musaya və kahin Harun oğlu Eleazara dedi: ");
INSERT INTO azb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Bütün İsrail övladlarının icmasını, ailələrinə görə iyirmi və ondan yuxarı yaşda döyüşə qabil olan İsrail övladlarını sayın». ");
INSERT INTO azb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa ilə kahin Eleazar İordan çayı yanında, Yerixo qarşısında Moav düzənliyində onlarla danışıb dedi: ");
INSERT INTO azb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Rəbbin Musaya əmr etdiyi kimi iyirmi və ondan yuxarı yaşda olanları siyahıya alın!» Misir torpağından çıxan İsrail övladları bunlardır: ");
INSERT INTO azb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","İsrailin ilk oğlu Ruven, Ruvenlilər bunlardır: Xanok soyundan Xanok nəsli; Pallu soyundan Pallu nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Xesron soyundan Xesron nəsli; Karmi soyundan Karmi nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ruvenlilərin nəsilləri bunlardır, sayları 43 730 nəfər idi. ");
INSERT INTO azb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palunun oğlu Eliav, ");
INSERT INTO azb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliavın oğulları Nemuel, Datan və Aviram idi. Bunlar o Datanla Aviramdır ki, icma tərəfindən seçildi və Rəbbə üsyan edən Qorahın tərəfdarlarına qoşulub Musa ilə Haruna zidd getdilər. ");
INSERT INTO azb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Qorahla 250 yoldaşını od yandırıb yox edəndə yer yarıqları onları uddu. Qorahla birlikdə ölənlər başqalarına da bir ibrət oldu. ");
INSERT INTO azb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Qorahın nəsli isə ölmədi. ");
INSERT INTO azb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Nəsillərinə görə Şimeonlular bunlardır: Nemuel soyundan Nemuel nəsli; Yamin soyundan Yamin nəsli; Yakin soyundan Yakin nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah soyundan Zerah nəsli; Şaul soyundan Şaul nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Şimeon nəsilləri bunlardır, sayları 22 200 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Nəsillərinə görə Qadlılar bunlardır: Sefon soyundan Sefon nəsli; Haqqi soyundan Haqqi nəsli; Şuni soyundan Şuni nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni soyundan Ozni nəsli; Eri soyundan Eri nəsli: ");
INSERT INTO azb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod soyundan Arod nəsli; Areli soyundan Areli nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Qad nəsilləri bunlardır, sayları 40 500 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yəhudanın iki oğlu var idi: Er və Onan. Onlar Kənan torpağında öldülər. ");
INSERT INTO azb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Nəsillərinə görə Yəhudalılar bunlardır: Şela soyundan Şela nəsli; Peres soyundan Peres nəsli; Zerah soyundan Zerah nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Peres övladları bunlardır: Xesron soyundan Xesron nəsli; Xamul soyundan Xamul nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Yəhuda nəsilləri bunlardır, sayları 76 500 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Nəsillərinə görə İssakar övladları bunlardır: Tola soyundan Tola nəsli; Puva soyundan Puva nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaşuv soyundan Yaşuv nəsli; Şimron soyundan Şimron nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","İssakar nəsilləri bunlardır, sayları 64 300 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Nəsillərinə görə Zevulunlular bunlardır: Sered soyundan Sered nəsli; Elon soyundan Elon nəsli; Yaxleel soyundan Yaxleel nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Zevulun nəsilləri bunlardır, sayları 60 500 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Nəsillərinə görə Yusifin oğulları: Menaşşe və Efrayim. ");
INSERT INTO azb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Menaşşe övladları bunlardır: Makir soyundan Makir nəsli, Makir Gileadın atası idi; Gilead soyundan Gilead nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilead övladları bunlardır: İezer soyundan İezer nəsli; Xeleq soyundan Xeleq nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel soyundan Asriel nəsli; Şekem soyundan Şekem nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Şemida soyundan Şemida nəsli; Xefer soyundan Xefer nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Xefer oğlu Selofxadın oğlu olmadı, amma Maxla, Noa, Xoqla, Milka və Tirsa adında qızları var idi. ");
INSERT INTO azb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Menaşşe nəsilləri bunlardır, sayları 52 700 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Nəsillərinə görə Efrayim övladları bunlardır: Şutelah soyundan Şutelah nəsli; Beker soyundan Beker nəsli; Taxan soyundan Taxan nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Şutelah övladları bunlardır: Eran soyundan Eran nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efrayim övladlarının nəsilləri bunlardır, sayları 32 500 nəfərdir. Nəsillərinə görə Yusif övladları bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Nəsillərinə görə Binyaminlilər bunlardır: Bela soyundan Bela nəsli; Aşbel soyundan Aşbel nəsli; Axiram soyundan Axiram nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Şufam soyundan Şufam nəsli; Xufam soyundan Xufam nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belanın oğulları Ardla Naaman nəslindən törənənlər bunlardır: Ard soyundan Ard nəsli; Naaman soyundan Naaman nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Nəsillərinə görə Binyamin övladları bunlardır, sayları 45 600 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Nəsillərinə görə Dan övladları bunlardır: Şuxam soyundan Şuxam nəsli. Bunlar Dan nəslindən törənən nəsillərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Hamısı Şuxam nəslindəndir, sayları 64 400 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Nəsillərinə görə Aşerlilər bunlardır: İmna soyundan İmna nəsli; İşvi soyundan İşvi nəsli; Beria soyundan Beria nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beria övladları bunlardır: Xever soyundan Xever nəsli; Malkiel soyundan Malkiel nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aşerin Serah adında bir qızı var idi. ");
INSERT INTO azb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Aşer övladları bunlardır, sayı 53 400 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nəsillərinə görə Naftali övladları bunlardır: Yaxseel soyundan Yaxseel nəsli; Quni soyundan Quni nəsli; ");
INSERT INTO azb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeser soyundan Yeser nəsli; Şillem soyundan Şillem nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Naftali nəsilləri bunlardır, sayları 45 400 nəfərdir. ");
INSERT INTO azb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Sayılan İsrail övladlarının cəmi 601 730 kişi idi. ");
INSERT INTO azb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Adamların sayına görə ölkə bunlara irs olaraq bölünsün. ");
INSERT INTO azb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Sayı çox olana böyük, sayı az olana az pay verəcəksən. Siyahıya yazılanların sayına görə hər birinə düşən pay verilsin. ");
INSERT INTO azb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ancaq torpaq püşklə bölünsün. Hər kəsin payı atalarının aid olduğu qəbilələrin adına görə olacaq. ");
INSERT INTO azb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Kiçik ya böyük – hər qəbilənin payı püşklə bölünsün». ");
INSERT INTO azb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Nəsillərinə görə sayılan Levililər bunlardır: Gerşon soyundan Gerşon nəsli; Qohat soyundan Qohat nəsli; Merari soyundan Merari nəsli. ");
INSERT INTO azb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Bunlar da Levi nəsilləridir: Livni nəsli, Xevron nəsli, Maxli nəsli, Muşi nəsli, Qorah nəsli. Qohat Amramın atası idi. ");
INSERT INTO azb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amramın arvadının adı Yokeved idi. O, Misirdə Levi nəslindən doğulmuşdu. Amramdan Harun, Musa və bacıları Məryəm doğuldu. ");
INSERT INTO azb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Harunun Nadav, Avihu, Eleazar, İtamar adlı uşaqları oldu. ");
INSERT INTO azb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadavla Avihu Rəbbin önündə haram od təqdim edərkən öldülər. ");
INSERT INTO azb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Levililərdən sayılan bir aylıq və ondan yuxarı yaşda bütün kişi cinsindən olanlar 23 000 nəfər idi. Bunlar o biri İsrail övladları ilə birlikdə siyahıya alınmışdı. Çünki İsrail övladları arasında onlara miras verilməmişdi. ");
INSERT INTO azb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","İsrail övladlarının siyahısı İordan çayının yanında, Yerixo qarşısındakı Moav düzənliyində Musa və kahin Eleazar tərəfindən tutuldu. ");
INSERT INTO azb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Amma Musa ilə kahin Harunun Sina səhrasında saydığı İsrail övladlarından heç kim bu siyahıda olmadı. ");
INSERT INTO azb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ona görə ki Rəbb o vaxt siyahıya alınan İsrail övladlarının səhrada öləcəyini qətiyyətlə söyləmişdi. Onlardan Yefunne oğlu Kalevlə Nun oğlu Yeşuadan başqa kimsə sağ qalmamışdı. ");
INSERT INTO azb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Menaşşe oğlu Makir oğlu Gilead oğlu Xefer oğlu Selofxadın qızları Yusif oğlu Menaşşenin nəsillərinə mənsub idi. Qızların adları belədir: Maxla, Noa, Xoqla, Milka və Tirsa. ");
INSERT INTO azb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Onlar Musanın, kahin Eleazarın və rəhbərlərlə bütün icmanın önündə, Hüzur çadırının girişində durub dedilər: ");
INSERT INTO azb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Atamız səhrada öldü, lakin Qorahın tərəfini tutub Rəbbə qarşı üsyan edənlərin arasında deyildi. O öz günahına görə öldü və oğulları olmadı. ");
INSERT INTO azb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Oğlu olmadığına görə onun adı öz nəsli arasından nə üçün silinməlidir? Atamızın qardaşları arasında bizə bir mülk verin». ");
INSERT INTO azb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa onların işini Rəbbin önünə qoydu. ");
INSERT INTO azb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Selofxadın qızları doğru deyirlər: mütləq onlara atalarının qardaşları arasında mülk ver və atalarının mirasını onlara keçir. ");
INSERT INTO azb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","İsrail övladlarına de ki, əgər bir adam ölərsə və onun oğlu yoxdursa, o zaman mirası onun qızına keçir. ");
INSERT INTO azb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Əgər onun qızı yoxdursa, onda mirasını onun qardaşlarına ver. ");
INSERT INTO azb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Əgər qardaşları yoxdursa, onda mirasını atasının qardaşlarına ver. ");
INSERT INTO azb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Əgər atasının qardaşları yoxdursa, o zaman mirasını nəslindən ona ən yaxın olan qohumuna ver ki, mülk onun olsun. Bu, Rəbbin Musaya əmr etdiyi kimi İsrail övladlarına qanun və hökm olsun». ");
INSERT INTO azb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Rəbb Musaya dedi: «Bu Avarim dağına çıx və İsrail oğullarına verdiyim ölkəni gör. ");
INSERT INTO azb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Onu gördükdən sonra qardaşın Harun nə cür xalqına qovuşdusa, sən də elə ölüb, xalqına qovuşacaqsan. ");
INSERT INTO azb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Çünki Zin səhrasında əmrimə qarşı çıxdınız. İcma Mənə üsyan edəndə sulara görə onların gözləri önündə Mənim müqəddəsliyimi etiraf etmədiniz». Bunlar Zin səhrasındakı Qadeşdə olan Meriva sularıdır. ");
INSERT INTO azb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa Rəbbə dedi: ");
INSERT INTO azb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Rəbb – bütün bəşər ruhlarının Allahı, icma üzərinə bir adam nəsib etsin, ");
INSERT INTO azb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","o da onların önündə girib-çıxsın, onların önündə döyüşə gedib-gəlsin. Qoy Rəbbin icması çobansız sürü kimi olmasın». ");
INSERT INTO azb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Rəbb Musaya dedi: «İçində Ruh olan bir adamı – Nun oğlu Yeşuanı yanına gətirərək əlini onun üzərinə qoyacaqsan. ");
INSERT INTO azb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Onu kahin Eleazar və bütün icma qarşısında dayandırıb onların gözləri önündə ona vəzifə tapşır. ");
INSERT INTO azb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ona öz səlahiyyətindən ver ki, bütün İsrail icması ona itaət etsin. ");
INSERT INTO azb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","O, hökm almaq üçün kahin Eleazarın qarşısında duracaq. Eleazar isə Urim vasitəsilə Rəbdən soruşmalıdır. Yeşua ilə bütün İsraillilər icması Eleazarın əmri ilə döyüşə gedib-gəlsinlər». ");
INSERT INTO azb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa Rəbbin ona əmr etdiyi kimi etdi: Yeşuanı götürüb kahin Eleazarın və bütün icmasının önündə dayandırdı. ");
INSERT INTO azb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Rəbbin Musa vasitəsilə əmr etdiyi kimi əllərini onun üzərinə qoyaraq ona vəzifə tapşırdı. ");
INSERT INTO azb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«İsrail övladlarına əmr edib de: “Diqqət edin ki, Mənə təqdim olunan payı – yandırma təqdimini, Mənim xoşuma gələn ətri öz vaxtında verəsiniz”. ");
INSERT INTO azb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Onlara de: “Rəbbə verəcəyiniz yandırma təqdimi budur: daimi yandırma qurbanı olaraq hər gün iki birillik qüsursuz erkək toğlu. ");
INSERT INTO azb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Toğlulardan birini səhər, o birini isə axşamçağı təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Toğlu ilə birlikdə taxıl təqdimi olaraq dörddə bir hin çəkilmiş zeytun yağı ilə yoğrulmuş efanın onda biri narın un təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Bu, daimi yandırma qurbanı, Sina dağında buyurulan, Rəbbin xoşuna gələn ətir – Onun üçün yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Hər toğlu ilə birlikdə içmə təqdimi olaraq dörddə bir hin kefləndirici içkini Rəbbin adına müqəddəs yerdə tökün. ");
INSERT INTO azb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","O biri toğlunu axşamçağı təqdim edin. Səhərki kimi taxıl təqdimi və içmə təqdimi ilə birlikdə onu təqdim edin. Bu, Rəbbin xoşuna gələn ətir – yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Şənbə günündə iki birillik qüsursuz erkək toğlu və taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda iki efa narın un və onun içmə təqdimini təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Daimi yandırma qurbanı və onun içmə təqdimindən başqa hər Şənbənin yandırma qurbanı olan təqdim budur. ");
INSERT INTO azb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Hər ayın başında Rəbbə yandırma qurbanı olaraq qüsursuz iki buğa və bir qoç, birillik yeddi erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Hər buğa üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda üç efa narın un və tək qoç üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda iki efa narın un, ");
INSERT INTO azb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","hər toğlu üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda bir efa narın un təqdim edin. Bu, yandırma qurbanı Rəbbin xoşuna gələn ətir – Onun üçün yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Onların içmə təqdimləri bir buğa üçün yarım hin, qoç üçün üçdə bir hin və bir toğlu üçün dörddə bir hin şərab olacaq. İl boyu hər yeni ayda veriləcək yandırma qurbanı budur. ");
INSERT INTO azb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Daimi yandırma qurbanı və onun içmə təqdimlərindən başqa Rəbbə günah təqdimi olaraq bir təkə də təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Birinci ayın on dördüncü günü Rəbbin Pasxa bayramıdır. ");
INSERT INTO azb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Bu ayın on beşinci günü bayram olsun, yeddi gün mayasız çörək yeyilsin. ");
INSERT INTO azb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Birinci gün müqəddəs toplantı keçirin, gündəlik işlərinizi görməyin. ");
INSERT INTO azb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Rəbbə yandırma qurbanı, yandırma təqdimi olaraq iki buğa, bir qoç və birillik yeddi erkək toğlu təqdim edin; hamısı qüsursuz olsun. ");
INSERT INTO azb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Hər buğa üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda üç efa, qoç üçün onda iki, ");
INSERT INTO azb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","yeddi toğludan hər toğlu üçün onda bir efa narın un təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Özünüzü kəffarə etmək üçün günah qurbanı olaraq bir təkə təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Hər səhər təqdim edəcəyiniz daimi yandırma qurbanına əlavə olaraq bunları da təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Beləliklə, yeddi gün ərzində hər gün Rəbbin payını, Onun xoşuna gələn ətri – yandırma təqdimini verin. Bunu daimi yandırma qurbanı ilə içmə təqdiminə əlavə olaraq verin. ");
INSERT INTO azb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Yeddinci gün müqəddəs toplantı keçirin, gündəlik işlərinizi görməyin. ");
INSERT INTO azb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Nübarın təqdim edilməsi günü Həftələr bayramında Rəbbə təzə taxıl təqdimi gətirəndə müqəddəs toplantı keçirin, gündəlik işlərinizi görməyin. ");
INSERT INTO azb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Yandırma qurbanını Rəbbin xoşuna gələn ətir kimi iki buğa, bir qoç və birillik yeddi erkək toğlu olmaqla təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Hər buğa üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda üç efa, tək qoç üçün onda iki efa, ");
INSERT INTO azb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","yeddi toğludan hər toğlu üçün isə onda bir efa narın un təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Özünüzü kəffarə etmək üçün bir təkə də təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Daimi yandırma qurbanı taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. Qurban etdiyiniz heyvanlar qüsursuz olmalıdır. ");
INSERT INTO azb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Yeddinci ayda, ayın birində müqəddəs toplantı keçirin, heç bir gündəlik işlərinizi görməyin. O gün sizin üçün şeypur çalma günü olacaq. ");
INSERT INTO azb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Yandırma qurbanını Rəbbin xoşuna gələn ətir kimi qüsursuz bir buğa, bir qoç və birillik yeddi erkək toğlu olmaqla verin. ");
INSERT INTO azb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Buğa üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda üç efa, qoç üçün onda iki efa, ");
INSERT INTO azb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","yeddi toğludan hər toğlu üçün onda bir efa narın un təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Özünüzü kəffarə etmək üçün günah qurbanı olaraq bir təkə də təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Aylıq və gündəlik yandırma qurbanları ilə lazımi taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. Bu, Rəbbin xoşuna gələn ətir – Onun üçün yandırma təqdimidir. ");
INSERT INTO azb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Həmin yeddinci ayın onunda müqəddəs toplantı keçirin; özünüzü hər şeydən məhrum edin və heç bir iş görməyin. ");
INSERT INTO azb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Rəbbə xoş ətir kimi yandırma qurbanı olaraq bir buğa, bir qoç, birillik yeddi erkək toğlu təqdim edin. Onlar qüsursuz olmalıdır. ");
INSERT INTO azb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Buğa üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda üç efa, qoç üçün onda iki efa, ");
INSERT INTO azb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","yeddi toğludan hər toğlu üçün onda bir efa narın un təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Günah qurbanı olaraq bir təkə də təqdim edin. Kəffarələr üçün günah qurbanına, daimi yandırma qurbanına, onun taxıl təqdiminə və onların içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Yeddinci ayın on beşinci günündə müqəddəs toplantı keçirin; heç bir gündəlik işlərinizi görməyin. Rəbbin şərəfinə yeddi gün bayram keçirin. ");
INSERT INTO azb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Rəbbin xoşuna gələn ətir – yandırma təqdimi olaraq qüsursuz on üç buğa, iki qoç və birillik on dörd erkək toğlu verin. Onlar qüsursuz olmalıdır. ");
INSERT INTO azb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Hər buğa üçün taxıl təqdimi olaraq zeytun yağı ilə yoğrulmuş onda üç efa, hər qoç üçün onda iki efa, ");
INSERT INTO azb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","on dörd toğludan hər toğlu üçün onda bir efa narın un təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","İkinci gün qüsursuz on iki buğa, iki qoç, birillik on dörd erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Buğa, qoç və toğluların sayına görə onların lazımi taxıl və içmə təqdimlərini gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Üçüncü gün qüsursuz on bir buğa, iki qoç, birillik on dörd erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Buğa, qoç və toğluların sayına görə onların lazımi taxıl və içmə təqdimlərini gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Dördüncü gün qüsursuz on buğa, iki qoç, birillik on dörd erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Buğa, qoç və toğluların sayına görə onların lazımi taxıl və içmə təqdimlərini gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Beşinci gün qüsursuz doqquz buğa, iki qoç, birillik on dörd erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Buğa, qoç və toğluların sayına görə lazımi taxıl və içmə təqdimlərini gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Altıncı gün qüsursuz səkkiz buğa, iki qoç, birillik on dörd erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Buğa, qoç və toğluların sayına görə onların lazımi taxıl və içmə təqdimlərini gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Yeddinci gün qüsursuz yeddi buğa, iki qoç, birillik on dörd erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Buğa, qoç və toğluların sayına görə onların lazımi taxıl və içmə təqdimlərini gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Səkkizinci gün özünüz üçün təntənəli toplantı keçirin, heç bir gündəlik işlərinizi görməyin. ");
INSERT INTO azb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Yandırma qurbanı, Rəbbin xoşuna gələn ətir – yandırma təqdimi olaraq qüsursuz bir buğa, bir qoç və birillik yeddi erkək toğlu təqdim edin. ");
INSERT INTO azb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Buğa, qoç və toğluların sayına görə onların lazımi taxıl və içmə təqdimlərini gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Günah qurbanı olaraq bir təkə də təqdim edin. Daimi yandırma qurbanı ilə taxıl və içmə təqdimlərinə əlavə olaraq bunları gətirin. ");
INSERT INTO azb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Əhdə görə və könüllü təqdimlərinizdən əlavə təyin olunan bayramlarınızda Rəbbə bu yandırma qurbanlarınızı, taxıl təqdimlərinizi, içmə təqdimlərinizi və ünsiyyət qurbanlarınızı təqdim edin”». ");
INSERT INTO azb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Musa Rəbbin ona əmr etdiyi hər şeyi İsrail övladlarına bildirdi. ");
INSERT INTO azb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa İsrail övladlarının qəbilə başçılarına dedi: «Rəbb belə əmr etmişdir: ");
INSERT INTO azb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","bir kişi Rəbbə əhd edərək yaxud and içərək öhdəsinə nə isə götürərsə, verdiyi sözü pozmasın, ağzından çıxan hər şeyi yerinə yetirsin. ");
INSERT INTO azb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Əgər atasının evində yaşayan gənc qız Rəbbə əhd edib öhdəsinə nə isə götürərsə, ");
INSERT INTO azb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","lakin atası onun əhdini və öhdəsinə götürdüyü şeyi eşidəndə ona qarşı çıxmazsa, qızın etdiyi əhdlər və öhdəsinə götürdüyü şeylərin hamısı qüvvədə qalar. ");
INSERT INTO azb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Amma atası bunları eşidən gün mane olarsa, qızın etdiyi əhdlər və öhdəsinə götürdüyü şeylər qüvvədən düşər. Rəbb onu bağışlayar, çünki atası mane olmuşdur. ");
INSERT INTO azb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Əgər qız əhd yaxud düşünmədən öhdəsinə bir şey götürdükdən sonra ərə gedərsə, ");
INSERT INTO azb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","bunu eşidən əri həmin gün ona qarşı çıxmazsa, onun etdiyi əhdlər və düşünmədən öhdəsinə götürdüyü şeylər qüvvədə qalar. ");
INSERT INTO azb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Amma əri bunu eşidən gün mane olarsa, gəlinin etdiyi əhdlər və öhdəsinə götürdüyü şeylər qüvvədən düşər. Rəbb onu bağışlayar. ");
INSERT INTO azb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Dul yaxud boşanan qadının əhdi və öhdəsinə götürdüyü hər şey qüvvədə qalar. ");
INSERT INTO azb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Əgər ərli bir qadın əhd edər yaxud öhdəsinə nə isə götürərsə, ");
INSERT INTO azb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","əri bunu eşidəndə ona qarşı çıxmayıb mane olmazsa, qadının bütün əhdləri yaxud öhdəsinə götürdüyü şeylər qüvvədə qalar. ");
INSERT INTO azb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Amma əri bunları eşidən gün ona mane olarsa, qadının bütün əhdləri və öhdəsinə götürdüyü şeylər qüvvədən düşər. Əri mane olduğu üçün Rəbb qadını bağışlayar. ");
INSERT INTO azb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Əri qadının özünü məhrum etmək üçün etdiyi əhdləri yaxud and içərək öhdəsinə götürdüyü şeyləri təsdiq edə bilər ya da mane ola bilər. ");
INSERT INTO azb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Əgər əri bir gün içində bu barədə ona qarşı çıxmazsa, bütün əhdləri yaxud öhdəliklərini təsdiqləmiş olur. Onları eşidən gün qadına qarşı çıxmamaqla təsdiqləmiş sayılar. ");
INSERT INTO azb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Əgər onları eşitdikdən bir müddət sonra mane olursa, qadının cəzasını əri çəkər». ");
INSERT INTO azb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Kişi ilə arvadı, atası ilə onun evində yaşayan gənc qızı arasında münasibət barədə Rəbbin Musaya əmr etdiyi qaydalar bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«İsrail övladlarının qisasını Midyanlılardan al. Sonra isə ölüb öz xalqına qovuşacaqsan». ");
INSERT INTO azb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Buna görə Musa xalqa belə dedi: «Aranızdan bəzi adamları silahlandırın ki, Midyanlılarla döyüşə çıxıb Rəbbin qisasını onlardan alsınlar. ");
INSERT INTO azb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","İsrail qəbilələrinin hər birindən döyüşə min nəfər göndərin». ");
INSERT INTO azb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Beləliklə, İsrailin tayfalarından, hər qəbilədən min nəfər olmaqla döyüşə hazır on iki min nəfər seçildi. ");
INSERT INTO azb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa hər qəbilədən min nəfəri kahin Eleazarın oğlu Pinxasla birlikdə döyüşə göndərdi. Pinxas özü ilə müqəddəs yerə aid bəzi əşyaları və işarə vermək üçün kərənayları götürdü. ");
INSERT INTO azb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Onlar Rəbbin Musaya əmr etdiyi kimi Midyanlılarla döyüşüb bütün kişiləri qırdılar. ");
INSERT INTO azb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Qırılanlar arasında Midyanın beş padşahı vardı: Evi, Reqem, Sur, Xur və Reva. Beor oğlu Bilamı da qılıncla öldürdülər. ");
INSERT INTO azb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Sonra İsraillilər bütün Midyan qadınları ilə uşaqlarını əsir götürüb onların bütün naxır və sürülərini, bütün əşyalarını talan etdilər. ");
INSERT INTO azb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Midyanlıların yaşadıqları bütün şəhərlərə, obalara od vurdular. ");
INSERT INTO azb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","İnsanları, heyvanları, bütün qəniməti, talan mallarını götürdülər. ");
INSERT INTO azb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Əsirləri, qəniməti, talan mallarını İordan çayının şərqində, Yerixonun qarşısında, Moav düzənliyindəki düşərgədə olan Musa ilə kahin Eleazarın və İsrail övladlarının icmasının yanına gətirdilər. ");
INSERT INTO azb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, kahin Eleazar və icma rəhbərləri onları qarşılamaq üçün düşərgənin kənarına çıxdılar. ");
INSERT INTO azb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa döyüşdən qayıdan sərkərdələrə – minbaşılara və yüzbaşılara qəzəblənib ");
INSERT INTO azb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","«Bütün qadınları nə üçün sağ saxladınız?» dedi. ");
INSERT INTO azb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","«Bunlar həmin qadınlardır ki, Bilamın verdiyi nəsihətə uyub Peor hadisəsində İsrail övladlarının Rəbdən dönməsinə səbəb oldular. Ona görə Rəbbin icması arasında vəba törəndi. ");
INSERT INTO azb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","İndi bütün oğlan uşaqlarını və kişi ilə yaxınlıq etmiş qadınları öldürün. ");
INSERT INTO azb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Yalnız kişi ilə yaxınlıq etməmiş cavan qızları özünüz üçün sağ saxlayın. ");
INSERT INTO azb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Aranızda kimisə öldürən yaxud meyitə toxunan hər kəs yeddi gün düşərgənin kənarında qalsın. Üçüncü və yeddinci gün özünüzü, həm də əsirlərinizi pak edin. ");
INSERT INTO azb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Hər paltarı, dəridən, keçi tükündən və ağacdan düzələn nə varsa, hamısını pak edin». ");
INSERT INTO azb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Bundan sonra kahin Eleazar döyüşdən qayıdan əsgərlərə dedi: «Rəbbin Musaya əmr etdiyi qanunun qaydası belədir. ");
INSERT INTO azb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Qızılı, gümüşü, tuncu, dəmiri, qalayı, qurğuşunu, ");
INSERT INTO azb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","oda davamlı hər şeyi alovdan keçirin ki, pak sayılsın. Lakin paklama suyu ilə də paklansın. Oda davamsız şeyləri isə sudan keçirin. ");
INSERT INTO azb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Yeddinci gün geyimlərinizi yuyun, onda pak olacaqsınız, sonra düşərgəyə girin». ");
INSERT INTO azb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Sən, kahin Eleazar və icmanın nəsil başçıları ələ keçirilən insanları, heyvanları, talan mallarını sayın. ");
INSERT INTO azb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Talan mallarını döyüşə çıxan igidlərlə icmanın qalan qismi arasında yarı bölün. ");
INSERT INTO azb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Döyüşə gedən igidlərə düşən insan, mal-qara, eşşək, qoyun-keçi payından vergi olaraq beş yüzdə birini Rəbbə ayırın. ");
INSERT INTO azb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Bu vergini igidlərə bölünən paydan götürüb Rəbbə ianə olaraq təqdim etmək üçün kahin Eleazara verin. ");
INSERT INTO azb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","O biri İsrail övladlarına düşən paydan insan, mal-qara, eşşək, qoyun-keçi və başqa heyvanlardan əllidə birini götürüb Rəbbin məskəninə cavabdeh olan Levililərə verin». ");
INSERT INTO azb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musa ilə kahin Eleazar Rəbbin Musaya əmr etdiyinə əməl etdilər. ");
INSERT INTO azb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Döyüşə gedən igidlərin götürdüyü talan malından bu qənimətlər qalmışdı: 675 000 qoyun-keçi, ");
INSERT INTO azb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72 000 mal-qara, ");
INSERT INTO azb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61 000 eşşək, ");
INSERT INTO azb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","kişi ilə yaxınlıq etməmiş 32 000 qız. ");
INSERT INTO azb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Bunların yarısı döyüşə gedən igidlərə pay düşdü: 337 500 qoyun-keçi, ");
INSERT INTO azb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","bunlardan Rəbbə vergi olaraq 675 qoyun-keçi verildi; ");
INSERT INTO azb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36 000 mal-qara, bunlardan 72 mal-qara Rəbbə vergi olaraq ayrıldı; ");
INSERT INTO azb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30 500 eşşək, bunlardan 61 eşşək Rəbbə vergi olaraq ayrıldı; ");
INSERT INTO azb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16 000 nəfər, bunlardan 32 nəfər Rəbbə vergi olaraq ayrıldı. ");
INSERT INTO azb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa Rəbbin ona əmr etdiyi kimi Rəbbə vergi olaraq ayrılanları kahin Eleazara verdi. ");
INSERT INTO azb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Musanın döyüşə gedən igidlərdən ayırdığından İsrail övladlarına düşən payın yarısı bunlardır: ");
INSERT INTO azb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","İcmaya düşən yarı pay 337 500 qoyun-keçi, ");
INSERT INTO azb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36 000 mal-qara, ");
INSERT INTO azb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30 500 eşşək, ");
INSERT INTO azb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","16 000 insan. ");
INSERT INTO azb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Rəbbin ona əmr etdiyi kimi Musa İsrail övladlarının payından hər əlli nəfərdən və heyvandan birini seçib Rəbbin məskəninə cavabdeh olan Levililərə verdi. ");
INSERT INTO azb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ordu bölmələrində hökm verən sərkərdələr – minbaşılar və yüzbaşılar Musanın yanına gedib dedilər: ");
INSERT INTO azb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","«Biz qulların hökm etdiyimiz döyüşçülərin sayını öyrəndik. Onlardan heç kim əskik deyildir. ");
INSERT INTO azb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ona görə də hər birimiz əldə etdiyimiz qızıl əşyaları – xalxalları, bilərzikləri, üzükləri, sırğaları, boyunbağıları təqdim olaraq Rəbbə gətirdik ki, Rəbbin önündə özümüz üçün kəffarə edək». ");
INSERT INTO azb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa ilə kahin Eleazar qızılı və hər cür bəzək əşyalarını onlardan aldı; ");
INSERT INTO azb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","minbaşılardan və yüzbaşılardan Rəbbə ianə olaraq gətirdikləri qızıl cəmi 16 750 şekel ağırlığında idi. ");
INSERT INTO azb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Döyüşə gedən igidlərin hər biri özləri üçün talan edilmiş maldan götürmüşdü. ");
INSERT INTO azb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa ilə kahin Eleazar minbaşılardan və yüzbaşılardan qızılı alıb İsrail övladları üçün Rəbbin önündə bir xatirə olaraq Hüzur çadırına gətirdilər. ");
INSERT INTO azb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Ruvenlilərlə Qadlıların çoxlu heyvanları var idi. Onlar Yazer ilə Gilead torpaqlarını görəndə heyvan otarmaq üçün bu yerlərin münasib olduğunu başa düşdülər. ");
INSERT INTO azb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Qadlılarla Ruvenlilər gəlib Musaya, kahin Eleazara və icmanın rəhbərlərinə dedilər: ");
INSERT INTO azb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Atarot, Divon, Yazer, Nimra, Xeşbon, Elale, Sevam, Nevo və Beon ");
INSERT INTO azb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Rəbbin İsrail icmasına təslim etdiyi bu ölkə heyvan otarmaq üçün münasib yerdir; qullarının da heyvanları var». ");
INSERT INTO azb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Sonra əlavə etdilər: «Əgər biz sənin gözündə lütf tapmışıqsa, qoy bu torpaq mülk olaraq biz qullarına verilsin. Bizi İordandan o taya keçirməyin». ");
INSERT INTO azb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa cavab verdi: «İsrailli qardaşlarınız döyüşməyə gedərkən siz buradamı qalmaq niyyətindəsiniz? ");
INSERT INTO azb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Nə üçün çayı keçib Rəbbin onlara verdiyi torpağa getmək üçün İsrail övladlarını ruhdan salırsınız? ");
INSERT INTO azb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Qadeş-Barneadan o torpağı gözdən keçirməyə göndərdiyim atalarınız da belə hərəkət etdilər. ");
INSERT INTO azb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Onlar Eşkol vadisinə çatıb torpağı gördülər, lakin İsrail övladlarını ruhdan saldılar ki, Rəbbin verdiyi torpağa girməsinlər. ");
INSERT INTO azb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","O gün Rəbbin qəzəbi alovlandı və and içib dedi: ");
INSERT INTO azb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","“Misirdən çıxan iyirmi və ondan yuxarı yaşda olan adamların heç biri İbrahimə, İshaqa və Yaquba and içib vəd etdiyim torpağı heç vaxt görməyəcək, çünki onlar Mənim yolumda sədaqətlə getmədilər. ");
INSERT INTO azb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ancaq Qenizli Yefunne oğlu Kalev və Nun oğlu Yeşua bu torpağı görəcək, çünki onlar yolumda sədaqətlə getdilər”. ");
INSERT INTO azb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Rəbbin qəzəbi İsrailə qarşı alovlandı və Rəbb gözündə pislik etmiş nəsil ölənə qədər onları qırx il səhrada gəzdirdi. ");
INSERT INTO azb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Budur, atalarınızın yerinə siz – günahlılar nəsli qalxaraq Rəbbin qızğın qəzəbini İsrailə qarşı daha da alovlandırırsınız. ");
INSERT INTO azb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Əgər siz indi Rəbbin ardınca getməkdən dönsəniz, O bütün bu xalqı yenə də səhrada atacaq, siz də onların ölümünə səbəb olacaqsınız». ");
INSERT INTO azb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ruvenlilərlə Qadlılar Musaya yaxınlaşıb dedilər: «Burada sürülərimiz üçün ağıllar, övladlarımız üçün şəhərlər tikəcəyik. ");
INSERT INTO azb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Biz isə silahlanıb İsrail övladlarının qabağında getməyə hazırıq. Onlar vəd olunmuş torpağa daxil olana qədər onları tərk etmərik. Uşaqlarımız isə qoy möhkəmlənmiş şəhərlərdə qalsınlar ki, bu torpağın sakinlərindən qorunsunlar. ");
INSERT INTO azb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","İsrail övladlarından hər biri öz irsini alana qədər evlərimizə qayıtmayacağıq. ");
INSERT INTO azb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Biz onlarla birlikdə İordanın o biri tayındakı torpaqdan irs istəməyəcəyik, çünki bizim payımız İordanın şərq tərəfinə düşdü». ");
INSERT INTO azb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Musa onlara belə cavab verdi: «Əgər siz belə hərəkət edib silahlanaraq Rəbbin hüzurunda döyüşə getsəniz ");
INSERT INTO azb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","və Rəbb düşmənlərini hüzurundan qovana qədər hamınız Onun hüzurunda İordanın o biri tayına silahlı olaraq keçsəniz, ");
INSERT INTO azb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","bu torpaq Rəbbin önündə sizə tabe olarsa, onda qayıda bilərsiniz. Rəbbin və İsrailin qarşısında borclarınızı yerinə yetirmiş olarsınız. Onda bu torpaq Rəbbin təsdiqi ilə sizin mülkünüz olacaq. ");
INSERT INTO azb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Lakin əgər belə etməsəniz, budur, Rəbbə qarşı günah etmiş olursunuz və bilin ki, günahınıza görə cəza alacaqsınız. ");
INSERT INTO azb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Uşaqlarınız üçün şəhərlər, sürüləriniz üçün ağıllar düzəldin. Lakin vədinizi yerinə yetirin». ");
INSERT INTO azb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Qadlılarla Ruvenlilər Musaya dedilər: «Ağamız necə buyurursa, biz qulların elə də edərik. ");
INSERT INTO azb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Arvadlarımız, uşaqlarımız, qoyun-keçi və mal-qaramız, burada – Gilead şəhərlərində qalacaq. ");
INSERT INTO azb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Sənin qulların – hamımız silahlanaraq, ağamız buyurduğu kimi çayı keçib Rəbbin əmri ilə döyüşə çıxacağıq». ");
INSERT INTO azb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Musa onların haqqında kahin Eleazara, Nun oğlu Yeşuaya və İsrail övladlarının qəbilə başçılarına əmr etdi. ");
INSERT INTO azb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musa onlara dedi: «Əgər Qadlılarla Ruvenlilər silahlanaraq Rəbbin əmri ilə sizinlə İordan çayının o biri tayına keçərlərsə, torpaq zəbt olunarsa, onda Gilead torpağını onlara mülk olaraq verin. ");
INSERT INTO azb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Lakin əgər onlar silahlanıb sizinlə çayın o biri tayına keçməsələr, onlar sizin aranızda – Kənan torpağında miras alacaqlar». ");
INSERT INTO azb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Qadlılar və Ruvenlilər belə cavab verdilər: «Rəbb sənin qullarına necə deyibsə, biz də elə edərik. ");
INSERT INTO azb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Biz Rəbbin hüzurunda silahlanıb çaydan Kənan torpağına keçəcəyik, lakin bizim miras aldığımız torpaq İordanın bu tayında olsun». ");
INSERT INTO azb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Musa Emorlular padşahı Sixonun ölkəsini, Başan padşahı Oqun ölkəsini bütün ətraf şəhərləri və torpaqları ilə birlikdə Ruvenlilərlə Qadlılara və Menaşşe qəbiləsinin yarısına verdi. ");
INSERT INTO azb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Qadlılar möhkəmlənmiş şəhərlər olaraq Divonu, Atrotu, Aroeri, ");
INSERT INTO azb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot-Şofanı, Yazeri, Yoqbohanı, ");
INSERT INTO azb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimranı və Bet-Haranı bərpa etdilər və sürülər üçün ağıllar düzəltdilər. ");
INSERT INTO azb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruvenlilər isə Xeşbonu, Elaleni, Qiryatayimi, ");
INSERT INTO azb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nevonu, Baal-Meonu – onların adları sonra dəyişdirildi – və Sivmanı bərpa etdilər. Yenidən tikdikləri şəhərlərə başqa adlar qoydular. ");
INSERT INTO azb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Menaşşe oğlu Makirin övladları Gileada girib oradakı Emorluları qovdular və oranı ələ keçirdilər. ");
INSERT INTO azb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Musa Gileadı Menaşşe oğlu Makirin nəslinə verdi. Onlar orada məskən saldılar. ");
INSERT INTO azb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Menaşşe nəslindən olan Yair gedib Emorluların kəndlərini alaraq adlarını Xavvot-Yair qoydu. ");
INSERT INTO azb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Novah isə gedib Qenatı və ətrafdakı qəsəbələri aldı. Oranı da öz adı ilə Novah adlandırdı. ");
INSERT INTO azb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Musa və Harunun başçılığı ilə ordular halında Misir torpağından çıxan İsrail övladlarının köçləri bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Musa Rəbbin əmrinə görə onların köçlərini və dayanacaqlarını qeyd etdi. Onların köçləri və qaldıqları yerlər bunlardır: ");
INSERT INTO azb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","İsrail övladları Pasxa bayramının səhəri, birinci ayın on beşində Misirlilərin gözü qarşısında vüqarla Ramsesdən yola düşdü. ");
INSERT INTO azb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","O vaxt Misirlilər Rəbbin qırdığı bütün ilk oğlanları basdırırdılar. Rəbb onların allahlarını da Öz hökmünə məruz qoymuşdu. ");
INSERT INTO azb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","İsrail övladları Ramsesdən yola çıxıb Sukkotda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukkotu tərk edib səhra kənarındakı Etamda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etamı tərk edib Baal-Sefonun şərqində Pi-Haxirota qayıtdılar və Miqdol yaxınlığında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Pi-Haxirotu tərk edib dənizin ortasından keçərək səhraya çıxdılar. Etam səhrasında üç gün gəzib dolanandan sonra Marada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Maranı tərk edib on iki su çeşməsi və yetmiş xurma ağacı olan Elimə gedərək orada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elimi tərk edib Qırmızı dəniz kənarında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Qırmızı dənizin kənarından ayrılıb Sin səhrasında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Sin səhrasını tərk edib Dofqada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Dofqanı tərk edib Aluşda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Aluşu tərk edib Refidimdə düşərgə saldılar. Orada xalq üçün içməyə su yox idi. ");
INSERT INTO azb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Refidimi tərk edib Sina səhrasında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sina səhrasını tərk edib Qivrot-Hattaavada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Qivrot-Hattaavanı tərk edib Xaserotda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Xaserotu tərk edib Ritmada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ritmanı tərk edib Rimmon-Peresdə düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rimmon-Peresi tərk edib Livnada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Livnanı tərk edib Rissada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Rissanı tərk edib Qehelatda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Qehelatı tərk edib Şefer dağında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Şefer dağını tərk edib Xaradada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Xaradadan ayrılıb Maqhelotda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Maqhelotu tərk edib Taxatda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Taxatdan ayrılıb Terahda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Terahı tərk edib Mitqada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mitqanı tərk edib Xaşmonada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Xaşmonadan ayrılıb Moserotda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserotu tərk edib Bene-Yaaqanda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Bene-Yaaqandan ayrılıb Xor-Haqqidqadda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Xor-Haqqidqadı tərk edib Yotvatada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yotvatanı tərk edib Avronada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Avronanı tərk edib Esyon-Geverdə düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Esyon-Geveri tərk edib Zin səhrasında, yəni Qadeşdə düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Qadeşdən ayrılıb Edom torpağının sərhədindəki Hor dağında düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kahin Harun Rəbbin əmrinə görə Hor dağına çıxdı. İsraillilərin Misirdən çıxmasının qırxıncı ilində, beşinci ayın birinci günündə orada öldü. ");
INSERT INTO azb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Harun Hor dağında öləndə yüz iyirmi üç yaşında idi. ");
INSERT INTO azb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Kənan ölkəsinin Negev bölgəsində yaşayan Kənanlı Arad padşahı eşitdi ki, İsrail övladları gəlib. ");
INSERT INTO azb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","İsrail övladları Hor dağından ayrılıb Salmonada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Salmonanı tərk edib Punonda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punonu tərk edib Ovotda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Ovotu tərk edib Moav sərhədindəki İye-Avarimdə düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","İye-Avarimi tərk edib Divon-Qadda düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Divon-Qaddan ayrılıb Almon-Divlataymada düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almon-Divlataymanı tərk edib Nevo yaxınlığında olan Avarim dağlıq bölgəsində düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Avarim dağlıq bölgəsindən ayrılıb İordan çayı yanında, Yerixo qarşısında olan Moav düzənliyində düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","İordan çayı boyunca Bet-Yeşimotdan Avel-Şittimə qədər Moav düzənliyində düşərgə saldılar. ");
INSERT INTO azb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Orada, İordan çayı yanında, Yerixo qarşısındakı Moav düzənliyində Rəbb Musaya belə dedi: ");
INSERT INTO azb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«İsrail övladlarına de: “İordan çayından Kənan ölkəsinə keçəndə ");
INSERT INTO azb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ölkədə yaşayan bütün əhalini qovun. Oyma daşlarının, tökmə bütlərinin hamısını yox edin. Onların bütün səcdəgah yerlərini dağıdın. ");
INSERT INTO azb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ölkəni ələ keçirib orada məskunlaşacaqsınız, çünki mülk almaq üçün oranı sizə verdim. ");
INSERT INTO azb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Püşklə ölkəni nəsilləriniz arasında bölün. Böyük nəslə böyük torpaq payı, kiçik nəslə kiçik torpaq payı verin. Kimin püşkünə nə çıxsa, qoy ora onun olsun. Paylarınızı atalarınızın qəbilələrinə görə irs alın. ");
INSERT INTO azb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Amma yerli əhalini qovmasanız, qalanlar böyrünüzü kol kimi dolayıb tikan kimi gözünüzə girəcək. Yaşadığınız ölkədə sizə əziyyət verəcək. ");
INSERT INTO azb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Mən də onlara nə etməyi düşünsəm, onu sizə edəcəyəm”». ");
INSERT INTO azb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«İsrail övladlarına əmr et və onlara de: “Kənan ölkəsinə girdiyiniz zaman irs olaraq sizə düşən torpağın – Kənan torpağının sərhədləri belə olacaq: ");
INSERT INTO azb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Cənub tərəfiniz Zin səhrasından Edom sərhədi boyunca uzanacaq. Cənub sərhədiniz şərqdə Duz dənizinin ucundan başlayacaq. ");
INSERT INTO azb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Sərhədiniz Aqrabbim keçidinin cənubundan dolaşaraq Zin səhrasına keçəcək və oradan Qadeş-Barneanın cənubuna qədər uzanacaq. Oradan Xasar-Addara uzanıb Asmona keçəcək. ");
INSERT INTO azb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Sərhəd Asmondan Misir vadisinə qədər dolaşacaq və onun ucu dənizin yanında olacaq. ");
INSERT INTO azb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Qərb sərhədiniz Böyük dənizi və onun kənarı olacaq, qərb sərhədiniz belə olacaq. ");
INSERT INTO azb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Şimal sərhədiniz bu olacaq: Böyük dənizdən Hor dağına qədər nişan qoyacaqsınız. ");
INSERT INTO azb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Hor dağından da Xamat keçidinə qədər nişan qoyacaqsınız. Sərhədin ucu Sedadda olacaq. ");
INSERT INTO azb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Sərhəd Zifrona uzanacaq və onun ucu Xasar-Enanda olacaq. Bu, şimal sərhədiniz olacaq. ");
INSERT INTO azb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Şərq sərhədinizə Xasar-Enandan Şefama qədər nişan qoyacaqsınız. ");
INSERT INTO azb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Sərhəd Şefamdan Ayinin şərq tərəfində olan Rivlaya enəcək və oradan Kinneret gölünün şərq kənarındakı yamaclara çatacaq. ");
INSERT INTO azb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Sonra sərhəd İordan çayı boyunca enəcək və onun ucu Duz dənizinin yanında olacaq. Hər tərəfdən ölkənizin sərhədləri bunlar olacaq”». ");
INSERT INTO azb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Musa İsrail övladlarına əmr edib dedi: «Bu o torpaqdır ki, siz onu püşk vasitəsilə bölməlisiniz. Rəbbin əmri ilə onu doqquz yarım qəbilə arasında bölməlisiniz. ");
INSERT INTO azb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Çünki Ruven qəbiləsinin nəsilləri, Qad qəbiləsinin nəsilləri və Menaşşe qəbiləsinin o biri yarısı öz irsini aldılar. ");
INSERT INTO azb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Bu iki yarım qəbilə Yerixonun qarşısında İordan çayının şərq tərəfində irsini aldı». ");
INSERT INTO azb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Torpaqları sizə irs olaraq böləcək adamların adları belədir: kahin Eleazar və Nun oğlu Yeşua. ");
INSERT INTO azb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Torpaqları bölmək üçün hər qəbilədən bir nəfər rəhbər götürün. ");
INSERT INTO azb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Bu adamlar bunlardır: Yəhuda qəbiləsi üçün Yefunne oğlu Kalev; ");
INSERT INTO azb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Şimeon qəbiləsi üçün Ammihud oğlu Şamuel; ");
INSERT INTO azb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Binyamin qəbiləsi üçün Kislon oğlu Elidad; ");
INSERT INTO azb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan qəbiləsi üçün rəhbər olan Yoqli oğlu Buqqi; ");
INSERT INTO azb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yusif oğullarından Menaşşe qəbiləsi üçün rəhbər olan Efod oğlu Xanniel; ");
INSERT INTO azb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Efrayim qəbiləsi üçün rəhbər olan Şiftan oğlu Qemuel; ");
INSERT INTO azb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zevulun qəbiləsi üçün rəhbər olan Parnak oğlu Elisafan; ");
INSERT INTO azb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","İssakar qəbiləsi üçün rəhbər olan Azzan oğlu Paltiel; ");
INSERT INTO azb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aşer qəbiləsi üçün rəhbər olan Şelomi oğlu Axihud; ");
INSERT INTO azb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Naftali qəbiləsi üçün rəhbər olan Ammihud oğlu Pedahel». ");
INSERT INTO azb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Kənan torpağında İsrail övladlarına irs torpaqları bölmək üçün Rəbbin əmr etdiyi adamlar bunlardır. ");
INSERT INTO azb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","İordan çayının yanında, Yerixo qarşısında olan Moav düzənliyində Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«İsrail övladlarına əmr et ki, mülk etdikləri torpaqda yaşamaq üçün Levililərə şəhərlər versinlər. Sən şəhərlərin ətrafında Levililərə otlaqlar da ver. ");
INSERT INTO azb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Beləliklə, Levililərin yaşamaq üçün şəhərləri və onların mal-qaraları, sürüləri və digər heyvanları üçün otlaqları olsun. ");
INSERT INTO azb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Levililərə verəcəyiniz şəhərlərin ətrafındakı otlaqlar şəhər divarından min qulac uzanacaq. ");
INSERT INTO azb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Şəhər ortada olaraq şəhərin bayırından şərq tərəfini iki min qulac, cənub tərəfini iki min qulac, qərb tərəfini iki min qulac və şimal tərəfini iki min qulac ölçün. Bu onlar üçün şəhər otlaqları olsun. ");
INSERT INTO azb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Levililərə verəcəyiniz şəhərlərdən altı sığınacaq şəhər olsun ki, kimisə öldürən oraya qaça bilsin. Bunlardan başqa qırx iki şəhər də verin. ");
INSERT INTO azb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Levililərə verəcəyiniz şəhərlərin cəmi qırx səkkiz şəhər olsun. Onları otlaqları ilə birgə verin. ");
INSERT INTO azb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Levililərə verəcəyiniz şəhərlər hər qəbiləyə düşən payın nisbətində alınsın, çox şəhəri olan qəbilədən çox şəhər, az şəhəri olan qəbilədən az şəhər alın». ");
INSERT INTO azb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Sonra Rəbb Musaya dedi: ");
INSERT INTO azb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«İsrail övladlarına de: “Siz İordan çayını keçib Kənan torpağına girəndə ");
INSERT INTO azb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","sığınacaq şəhərlər olaraq bəzi şəhərlər seçin ki, bilmədən adam öldürən oraya qaçsın. ");
INSERT INTO azb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Qisas alandan sığınacaq şəhərləriniz bunlar olsun ki, adam öldürən şəxs icmanın önündə hökm alana qədər öldürülməsin. ");
INSERT INTO azb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Verəcəyiniz bu altı şəhər sizin üçün sığınacaq şəhərlər olsun. ");
INSERT INTO azb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","İordan çayının o biri tayında üç şəhər və Kənan torpağında üç şəhər verin. Bunlar sığınacaq şəhərlər olsun. ");
INSERT INTO azb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Bu altı şəhər İsrail övladlarına, aralarında yaşayan yadellilərə və qəriblərə sığınacaq şəhərləri olacaq. Belə ki bilmədən birini öldürən hər kəs oraya qaça bilsin. ");
INSERT INTO azb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Əgər biri dəmir bir alətlə başqa birini vurub öldürmüşsə, o adam qatildir. Qatil öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Əgər kimsə əlində insanın ölə biləcəyi bir daşla kimisə vurmuşsa və o adam ölmüşsə, onda o adam qatildir. Qatil öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Yaxud əlində adam öldürə bilən ağac bir alətlə birini vurub öldürmüşsə, o adam qatildir. Qatil öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Tökülən qanın qisasını alan özü qatili öldürsün, onunla rastlaşdığı zaman öldürsün. ");
INSERT INTO azb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Əgər onu kinlə itələyib yaxud pusquda duraraq ona tərəf bir şey atıb öldürmüşsə ");
INSERT INTO azb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ya da ədavətə görə onu əli ilə vurub öldürmüşsə, vuran mütləq öldürülməlidir. O qatildir, tökülən qanın qisasını alan adam qatilə rast gəldiyi zaman onu öldürsün. ");
INSERT INTO azb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Ancaq ədavəti olmayaraq birini qəflətən itələmişsə yaxud pusquda durmadan ona bir şey atmışsa ");
INSERT INTO azb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","və yaxud da onu görmədən üstünə adam öldürə bilən bir daş düşürüb öldürmüşsə, onda ölən şəxsi-qərəzlik olmadığından və ona ziyan vurmaq istəmədiyindən ");
INSERT INTO azb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","adam öldürənlə tökülən qanın qisasını alan arasında bu hökmlərə görə icma hökm çıxaracaq. ");
INSERT INTO azb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","İcma tökülən qanın qisasını alanın əlindən adam öldürəni qurtaracaq, qaçdığı sığınacaq şəhərə geri göndərəcək və o, müqəddəs yağla məsh olunmuş baş kahinin ölümünə qədər orada qalacaq. ");
INSERT INTO azb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Əgər adam öldürən qaçdığı sığınacaq şəhərin sərhədini keçərsə, ");
INSERT INTO azb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","tökülən qanın qisasını alan adam öldürəni sığınacaq şəhərin sərhəd kənarında taparsa və onu öldürərsə, o qatil sayılmayacaq. ");
INSERT INTO azb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Çünki adam öldürən baş kahinin ölümünə qədər sığındığı şəhərdə qalmalı idi. Ancaq baş kahinin ölümündən sonra öz mülkü olan torpağına qayıda bilər. ");
INSERT INTO azb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Bunlar nəsildən-nəslə bütün yaşadığınız yerlərdə qanun və hökm olacaq. ");
INSERT INTO azb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Bir adam bir adamı öldürsə, şahidlərin ifadəsi ilə öldürülsün. Lakin heç bir qatil tək şahidin ifadəsi ilə öldürülməsin. ");
INSERT INTO azb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ölüm cəzasına layiq qatilin canı üçün fidyə almayın, çünki o öldürülməlidir. ");
INSERT INTO azb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Sığınacaq şəhərinə qaçan üçün fidyə almayın ki, kahinin ölümündən əvvəl torpağında yaşamağa qayıtsın. ");
INSERT INTO azb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Beləcə olduğunuz ölkəni murdarlamayın. Çünki qan tökmək ölkəni murdar edər və ölkədə tökülən qanın əvəzi ancaq onu tökənin qanı ilə kəffarə oluna bilər. ");
INSERT INTO azb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Yaşadığınız, Mənim də olduğum ölkəni ləkələməyin. Çünki İsrail övladları arasında yaşayan Rəbb Mənəm”». ");
INSERT INTO azb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Yusif övladlarının nəsillərindən Menaşşe oğlu Makir oğlu Gilead nəslinin ailə başçıları yaxınlaşıb Musanın önündə və İsrail nəsil başçıları olan rəhbərlərin önündə belə danışdılar: ");
INSERT INTO azb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","«Rəbb ölkəni irs olaraq püşk ilə İsrail övladları arasında bölüşdürməyi ağamıza əmr etdi. Soydaşımız Selofxadın irsini onun qızlarına vermək ağamıza Rəbb tərəfindən əmr olundu. ");
INSERT INTO azb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Əgər Selofxadın qızları başqa bir İsrail qəbiləsinə mənsub kişilərə ərə getsələr, onların irsi bizim irsimizdən götürülüb mənsub olacaqları qəbilənin irsinə qatılar. Beləliklə, püşklə bizə düşən pay azalar. ");
INSERT INTO azb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","İsrail övladlarının Azadlıq ili gələndə qızların irsi ərlərinin mənsub olduqları qəbilənin irsinə əlavə olunar. Beləliklə, qızların irsi atalarımızın qəbiləsinə düşən irsdən alınar». ");
INSERT INTO azb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Musa Rəbbin əmrinə görə İsrail övladlarına əmr edib dedi: «Yusif nəslinin qəbiləsi doğru söyləyir. ");
INSERT INTO azb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Selofxadın qızları haqqında Rəbbin əmr edib dediyi söz budur: onlar öz istədikləri kişiyə ərə gedə bilər, ancaq atalarının mənsub olduğu qəbilədən olan nəsil içində ərə getməlidirlər ki, ");
INSERT INTO azb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","İsrail övladlarının irsi qəbilədən qəbiləyə keçməsin. İsrail övladlarının hər biri atalarının qəbiləsinin irsinə bağlı qalsın. ");
INSERT INTO azb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","İsrail qəbilələrindən hər hansı birində irsə malik olan hər qız atasının mənsub olduğu qəbilədən və nəsildən bir nəfərə ərə getməlidir ki, hər bir İsrail övladı atalarının irsinə malik olsun. ");
INSERT INTO azb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","İrs bir qəbilədən başqa qəbiləyə keçməsin. Hər bir İsrail qəbiləsi öz irsinə bağlı qalsın». ");
INSERT INTO azb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Rəbbin Musaya əmr etdiyinə əməl edərək Selofxadın qızları ");
INSERT INTO azb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Maxla, Tirsa, Xoqla, Milka və Noa əmisi oğlanlarına ərə getdilər. ");
INSERT INTO azb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Onlar Yusif oğlu Menaşşe nəsillərinə mənsub kişilərə ərə getdilər. Ona görə də irsi atalarının mənsub olduğu qəbilə və nəsil içində qaldı. ");
INSERT INTO azb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Rəbbin Musa vasitəsilə İordan çayının yanında Yerixo qarşısındakı Moav düzənliyində İsrail övladlarına verdiyi əmr və hökmlər bunlardır. ");
INSERT INTO azb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","İordan çayının şərq tərəfində səhrada Paranla Tofel, Lavan, Xaserot və Di-Zahav arasında, Sufun qarşısında olan Arava vadisində Musanın bütün İsraillilərə söylədiyi sözlər bunlar idi: ");
INSERT INTO azb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Seir dağının yolu ilə getmək üçün Xorevdən Qadeş-Barneaya qədər on bir günlük yol var idi. ");
INSERT INTO azb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Misirdən çıxdıqlarının qırxıncı ilində, on birinci ayın birində Musa Rəbbin İsrail övladları üçün ona əmr etdiyi hər şeyi söylədi. ");
INSERT INTO azb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Musa Xeşbonda yaşayan Emorluların padşahı Sixonu və Aştarotda, Edreidə yaşayan Başan padşahı Oqu məğlub edəndən sonra bu nitqi söylədi. ");
INSERT INTO azb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","İordan çayının şərq tərəfində yerləşən Moav torpağında Musa bu Qanunu izah etməyə başladı. ");
INSERT INTO azb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«Xorevdə olanda Allahımız Rəbb bizə belə dedi: “Bəsdir bu dağda yaşadığınız! ");
INSERT INTO azb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Qalxın buradan köçüb Emorluların dağlıq bölgəsinə, Arava vadisində, dağlarda, yamaclı-düzənlikli bölgədə, Negevdə və dəniz kənarında yaşayan bütün qonşu xalqların arasına, böyük Fərat çayına qədər uzanan Kənan torpağına və Livana gedin. ");
INSERT INTO azb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Sizin qarşınıza çıxardığım torpaq budur. Rəbbin atalarınıza – İbrahimə, İshaqa, Yaquba özləri üçün və özlərindən sonra gələn övladları üçün vəd etdiyi bu torpağa girərək oranı özünüzə mülk edin”. ");
INSERT INTO azb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","O vaxt mən sizə belə dedim: “Təkbaşına sizin yükünüzü daşıya bilmərəm. ");
INSERT INTO azb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Allahınız Rəbb sizi çoxaltdı və budur, bu gün siz göydəki ulduzlar qədər çoxsunuz. ");
INSERT INTO azb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Qoy atalarınızın Allahı Rəbbin söylədiyi kimi olsun, sizə xeyir-dua verərək olduğunuzdan min qat artıq etsin. ");
INSERT INTO azb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Axı mən təkbaşına zəhmətinizə, əziyyətinizə və münaqişələrinizə necə tab gətirim? ");
INSERT INTO azb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Özünüz üçün hər qəbilədən müdrik, uzaqgörən və təcrübəli adamlar seçin. Mən onları sizə başçı təyin edəcəyəm”. ");
INSERT INTO azb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Siz də “sən deyən yaxşıdır” dediniz. ");
INSERT INTO azb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Mən qəbilələrinizin müdrik və təcrübəli ağsaqqallarından götürüb sizə minbaşı, yüzbaşı, əllibaşı, onbaşı və qəbilə məmurları təyin etdim. ");
INSERT INTO azb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","O vaxt hakimlərinizə belə əmr etdim: “Aralarında münaqişəsi olan soydaşlarınızı dinləyin. Münaqişə istər İsrailli soydaşlarınız arasında, istərsə bir İsrailli ilə yadelli arasında olsun, hökm çıxararkən ədalətli olun. ");
INSERT INTO azb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Heç kimə tərəfkeşlik etmədən kiçiyi də böyük kimi dinləyərək hökm çıxarın. İnsan şəxsiyyətindən qorxmayın, hökm Allahındır. Sizin üçün çətin olan münaqişəli məsələləri isə mənim yanıma gətirin. Mən onlara qulaq asaram”. ");
INSERT INTO azb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","O vaxt edəcəyiniz şeylərin hamısını sizə əmr etdim. ");
INSERT INTO azb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Sonra biz Xorevdən köçdük. Allahımız Rəbbin bizə əmr etdiyi kimi gördüyünüz böyük və qorxunc səhranı keçərək Emorluların dağlıq bölgəsinə tərəf köçüb Qadeş-Barneaya çatdıq. ");
INSERT INTO azb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Mən orada sizə dedim: “Allahınız Rəbbin bizə verdiyi Emorluların dağlıq bölgəsinə çatdınız. ");
INSERT INTO azb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Budur, Allahınız Rəbb torpağı sizə verdi. Atalarınızın Allahı Rəbbin sizə söylədiyi kimi qalxın, oranı mülk edin. Heç nədən qorxub çəkinməyin”. ");
INSERT INTO azb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","O zaman hamınız yanıma gəlib dediniz: “Adamlar göndərək, qoy əvvəlcə torpağı onlar nəzərdən keçirsinlər. Qoy gedəcəyimiz yol və çatacağımız şəhərlər barədə bizə məlumat gətirsinlər”. ");
INSERT INTO azb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Bu fikir xoşuma gəldi. Hər qəbilədən bir nəfər olmaqla aranızdan on iki nəfər götürdüm. ");
INSERT INTO azb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Onlar dağlıq bölgəsinə qalxdılar. Eşkol vadisinə qədər gəlib oranı gözdən keçirdilər. ");
INSERT INTO azb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Bu torpağın məhsullarından əllərinə götürüb yanımıza qayıtdılar və belə məlumat verdilər: “Allahımız Rəbbin bizə vermək istədiyi münbit torpaqdır”. ");
INSERT INTO azb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Siz isə Allahımız Rəbbin əmrinə qarşı çıxaraq oraya qalxmaq istəmədiniz. ");
INSERT INTO azb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Öz çadırlarınızda deyindiniz: “Rəbb bizə nifrət edir. Bizi Misir ölkəsindən ona görə çıxartdı ki, Emorlulara təslim etsin və həlak etsin. ");
INSERT INTO azb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Axı biz hara gedirik? Soydaşlarımız ‹o xalq sayca bizdən çox və ucaboydur, böyük şəhərləri, göyə çatan hasarları var, Anaqlıları da orada gördük› deyə-deyə bizdə ürək qoymadılar”. ");
INSERT INTO azb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Onda mən sizə dedim: “Onlardan qorxub çəkinməyin. ");
INSERT INTO azb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Allahınız Rəbb qarşınızca gedir. Sizin üçün Özü döyüşəcək. Misirdə və səhrada gözünüz qarşısında sizin üçün etdiyi hər şeyi yenə də edəcəkdir. ");
INSERT INTO azb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","İnsan öz balasını apardığı kimi səhradan bu yerə çatana qədər Allahınız Rəbbin də sizi elə apardığını gördünüz”. ");
INSERT INTO azb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Buna baxmayaraq, sizə düşərgə salmağa yer axtarmaq və gedəcəyiniz yolu göstərmək üçün gecə alovla, gündüz buludla ");
INSERT INTO azb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","qarşınızca yol gedən Rəbbə etibar etmədiniz. ");
INSERT INTO azb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Rəbb bu danışığınızı eşidib qəzəbləndi və and içərək dedi: ");
INSERT INTO azb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Atalarınıza vermək üçün and etdiyim bu gözəl torpağı Yefunne oğlu Kalevdən başqa bu iyrənc nəslin adamlarından heç biri görməyəcək. ");
INSERT INTO azb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Oranı Kalev görəcək. Tamamilə Rəbbin ardınca getdiyi üçün ayaq basdığı torpağı ona və övladlarına verəcəyəm”. ");
INSERT INTO azb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Sizin ucbatınızdan Rəbb mənə də qəzəbləndi və belə dedi: “Sən də oraya girməyəcəksən. ");
INSERT INTO azb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Oraya sənin köməkçin Nun oğlu Yeşua girəcək. Onu cəsarətləndir, çünki torpağı İsraillilərə irs olaraq o böləcək. ");
INSERT INTO azb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","‹Əsir olacaqlar› dediyiniz balalarınız, yaxşını pisdən hələ ayıra bilməyən uşaqlarınız oraya girəcəklər. Ölkəni onlara verəcəyəm, oranı onlar mülk olaraq alacaqlar. ");
INSERT INTO azb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Siz isə dönüb Qırmızı dəniz yolundan səhraya köçün”. ");
INSERT INTO azb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Sonra siz mənə belə cavab verdiniz: “Rəbbə qarşı günah etdik. Allahımız Rəbbin bizə etdiyi əmrə əsasən çıxıb döyüşəcəyik”. Hamınız dağlığa çıxmağın asan olduğunu düşünərək döyüş silahlarına sarıldınız. ");
INSERT INTO azb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Rəbb mənə dedi: “Onlara de ki, aralarında Mən yoxam. Döyüşə çıxmasınlar, yoxsa düşmənlərinə məğlub olarlar”. ");
INSERT INTO azb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Siz isə mənim sözümə qulaq asmadınız. Rəbbin əmrinə qarşı çıxaraq döyüşə çıxmağa cürət etdiniz. ");
INSERT INTO azb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Bu dağlıq bölgəsində yaşayan Emorlular müqavimət göstərərək sizi arı kimi qovdular və sizi Seirdən Xormaya qədər qırdılar. ");
INSERT INTO azb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Belə olanda qayıdıb Rəbbin hüzurunda ağladınız, lakin Rəbb səsinizi eşitmədi və sizə qulaq asmadı. ");
INSERT INTO azb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Uzun müddət yerinizdəcə – Qadeşdə qaldınız. ");
INSERT INTO azb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Rəbbin mənə əmr etdiyi kimi qayıdıb Qırmızı dəniz yolu ilə səhraya köç etdik. Xeyli vaxt Seir dağlıq bölgəsini gəzib dolaşandan sonra ");
INSERT INTO azb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Rəbb mənə belə dedi: ");
INSERT INTO azb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Bu dağlıq bölgəsini gəzib dolaşmağınız kifayətdir, indi şimala dönün. ");
INSERT INTO azb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Xalqa belə əmr et: ‹Seirdə yaşayan qohumlarınız Esav övladlarının torpağından keçəcəksiniz. Onlar sizdən qorxacaqlar, buna görə çox diqqətli olun. ");
INSERT INTO azb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Onlarla münaqişə yaratmayın, çünki torpaqlarından bir qarış da sizə verməyəcəyəm. Ona görə ki Mən mülk olaraq Seir dağlıq bölgəsini Esav nəslinə vermişəm. ");
INSERT INTO azb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Onlardan yeməyi də, suyu da pulla alın, yeyib-içməyiniz qoy belə olsun›”. ");
INSERT INTO azb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Çünki Allahınız Rəbb əlinizdə olan hər işə xeyir-dua verib. Belə böyük səhrada gəzib-dolaşdığınız zaman O sizi qorumuşdu. Bu qırx il ərzində sizinlə olan Allahınız Rəbbin sayəsində heç nəyə ehtiyacınız olmayıb. ");
INSERT INTO azb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Biz Seir dağında yaşayan qohumlarımız Esav övladlarının torpağından, Elat və Esyon-Geverdən Arava yolundan burularaq Moav səhrası yolundan keçdik. ");
INSERT INTO azb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Rəbb mənə dedi: “Moavlıları incitmə və onlarla döyüşə girmə. Mən onların torpağından mülk olaraq sizə heç nə verməyəcəyəm, çünki Ar ölkəsini mülk olaraq Lut övladlarına vermişəm”. ");
INSERT INTO azb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Orada əvvəl Emlilər, Anaqlılar kimi ucaboy, güclü və çoxsaylı bir xalq yaşayırdı. ");
INSERT INTO azb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Onlar da Anaqlılar kimi Rafalılar sayılırdı, lakin Moavlılar onları Emlilər adlandırırdılar. ");
INSERT INTO azb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Seirdə isə əvvəllər Xorlular yaşayırdı. Esav övladları onları qovdu, İsraillilərin Rəbbin mülk olaraq verdiyi torpağın əhalisinə etdiyi kimi qarşılarına çıxan Xorluları qırıb torpaqlarında məskən saldılar. ");
INSERT INTO azb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Rəbb sözünə davam etdi: “İndi qalxıb Zered vadisini keçin”. Biz Zered vadisini keçdik. ");
INSERT INTO azb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Qadeş-Barneadan köçdüyümüz vaxtdan Zered vadisini keçənədək otuz səkkiz il oldu. Rəbbin and içdiyi kimi düşərgədə olan o dövrdəki nəslin döyüşçülərindən heç biri sağ qalmamışdı. ");
INSERT INTO azb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Onları ordugahdan yox edib qurtaranadək Rəbbin əli onlara qarşı oldu. ");
INSERT INTO azb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Xalqın bütün döyüş adamları ölüb-qurtarandan sonra ");
INSERT INTO azb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Rəbb mənə belə dedi: ");
INSERT INTO azb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Siz bu gün Moav torpağında yerləşən Ardan keçəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ammon övladlarına yaxınlaşanda onları incitməyin və münaqişə yaratmayın, çünki sizə Ammon övladlarının torpağından mülk olaraq heç nə verməyəcəyəm, ona görə ki oranı da Lut övladlarına vermişəm”. ");
INSERT INTO azb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Ora da Rafalıların torpağı sayılırdı, əvvəllər orada Rafalılar yaşayırdı. Ammonlular onları Zamzumlular adlandırırdılar. ");
INSERT INTO azb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Onlar da Anaqlılar kimi ucaboy, güclü və çoxsaylı bir xalq idi. Rəbb onları Ammonluların qarşısından yox etmişdi. Ammonlular onları qovub yerlərində məskən salmışdılar. ");
INSERT INTO azb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Rəbb Seirdə yaşayan Esav övladları üçün də həmin işi görərək Xorluları onların qarşısından yox etmişdi. Esav övladları Xorluları qıraraq yerlərində məskən saldılar və bu günə qədər orada yaşamaqdadırlar. ");
INSERT INTO azb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Kaftordan çıxan Kaftorlular isə Qəzzəyə qədər kəndlərdə yaşayan Avvalıları qırdılar və onların yerində məskən saldılar. ");
INSERT INTO azb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Rəbb dedi: “Qalxıb köç edin, Arnon vadisindən keçin. Bax Xeşbon padşahı Emorlu Sixonu və onun ölkəsini sizə təslim etdim. Özünüz üçün mülk olaraq oranı almağa başlayın. Onlarla döyüşə girin. ");
INSERT INTO azb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Bu gündən Mən səma altında olan bütün xalqları sizə görə qorxu və vahiməyə salmağa başlayıram. Sizin sorağınızı eşidənlər qarşınızda titrəyib büzüşəcəklər”. ");
INSERT INTO azb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Qedemot səhrasından Xeşbon padşahı Sixonun yanına sülh danışığı üçün qasidlər göndərdim və dedim: ");
INSERT INTO azb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Rica edirik, sənin torpağından keçmək üçün bizə izin verəsən. Yalnız yol keçəcəyik, oradan nə sağa, nə də sola dönəcəyik. ");
INSERT INTO azb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Pulla bizə yemək satsanız, yeyəcəyik, su satsanız, içəcəyik. Bizə ölkəni piyada keçmək kifayətdir. ");
INSERT INTO azb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Seirdə yaşayan Esav övladları və Arda yaşayan Moavlılar etdiyi kimi sən də izin ver ki, İordan çayından Allahımız Rəbbin bizə verdiyi torpağa keçək”. ");
INSERT INTO azb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Lakin Xeşbon padşahı Sixon bizi torpağından keçməyə qoymadı. Çünki bugünkü kimi Allahınız Rəbb sizə təslim etmək üçün onu inadkar və daşürəkli etdi. ");
INSERT INTO azb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Rəbb mənə dedi: “Bax Sixonu və ölkəsini sənə təslim etməyə başlayıram. Oranı fəth edib irs olaraq almağa başla”. ");
INSERT INTO azb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sixon özü və bütün ordusu döyüşmək üçün Yahsada bizim qarşımıza çıxdı. ");
INSERT INTO azb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Allahımız Rəbb onu bizə təslim etdi. Biz də Sixonu, övladlarını və bütün ordusunu qırdıq. ");
INSERT INTO azb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","O vaxt onun bütün şəhərlərini aldıq. Hər bir şəhəri kişi, qadın və uşaqlarla birlikdə tamamilə məhv etdik: kimsəni sağ qoymadıq. ");
INSERT INTO azb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Heyvanlarını götürüb aldığımız şəhərləri talan etdik. ");
INSERT INTO azb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Arnon vadisinin kənarında Aroerdən və vadidə olan şəhərdən Gileadadək qarşımıza bizdən güclü bir şəhər çıxmadı. Allahımız Rəbb onların hamısını bizə təslim etdi. ");
INSERT INTO azb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Lakin Ammonluların ölkəsinə, bütün Yabboq çayı kənarına və dağlıq bölgəsindəki şəhərlərə – Allahımız Rəbbin qadağan etdiyi heç yerə yaxınlaşmadıq. ");
INSERT INTO azb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Sonra istiqaməti dəyişib Başana yollandıq. Başan padşahı Oq bütün ordusu ilə bərabər Edreidə bizimlə döyüşə çıxdı. ");
INSERT INTO azb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Rəbb mənə dedi: “Ondan qorxma, çünki Mən onu, bütün xalqını və torpağını sənə təslim edirəm. Xeşbonda yaşayan Emorluların padşahı Sixonun başına gətirdiyini onun da başına gətir”. ");
INSERT INTO azb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Allahımız Rəbb Başan padşahı Oqu və bütün ordusunu bizə təslim etdi. Biz də kimsəni sağ buraxmadan hamısını qırıb ");
INSERT INTO azb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","bütün şəhərlərini aldıq, almadığımız bir şəhər belə, qalmadı. Aldığımız şəhərlərin sayı altmış idi. Bu yerlər Başanda Oqun ölkəsi olan bütün Arqov diyarını təşkil edirdi. ");
INSERT INTO azb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Şəhərlərin hamısının darvazaları cəftəli idi və hündür divarlarla əhatə olunmuşdu. Bundan əlavə, çoxlu divarsız kəndlər də var idi. ");
INSERT INTO azb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Xeşbon padşahı Sixonun başına gətirdiyimiz kimi onları da qırıb kişi, qadın və uşaqları ilə bərabər şəhərlərin hamısını tamamilə məhv etdik. ");
INSERT INTO azb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Bütün heyvanları götürüb şəhərləri talan etdik. ");
INSERT INTO azb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Beləcə o vaxtlar Arnon vadisindən Xermon dağına qədər olan İordan çayının şərqindəki Emorluların iki padşahının əlindən ölkəni aldıq. ");
INSERT INTO azb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidonlular Xermonu Siryon adlandırırdılar. Emorlular isə oraya Senir deyirdilər. ");
INSERT INTO azb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Yaylada olan bütün şəhərləri, bütün Gileadı, Oqun Başan ölkəsindəki şəhərləri olan Selka və Edreiyə qədər bütün Başan torpağını aldıq. ");
INSERT INTO azb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Rafalılardan ancaq Başan padşahı Oq sağ qalmışdı. O, dəmir çarpayısında yatardı. Hələ Ammon övladlarının Rabba şəhərində olan bu çarpayının adi ölçüyə görə uzunluğu doqquz, eni isə dörd qulac idi. ");
INSERT INTO azb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","O vaxt irs olaraq bu torpaqları aldıq: Arnon vadisinin yanında olan Aroerdən başlanan ölkəni, Gilead dağlıq bölgəsinin yarısını şəhərləri ilə bərabər Ruvenlilərə və Qadlılara verdim. ");
INSERT INTO azb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Gileadın qalan hissəsini, Oqun ölkəsi olan bütün Başanı Menaşşe qəbiləsinin yarısına verdim. Başanda olan bütün Arqov diyarına Rafalılar ölkəsi deyilirdi. ");
INSERT INTO azb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Menaşşe oğlu Yair Geşurlular və Maakatlıların sərhədinə qədər Arqov diyarını aldı. Oraya – Başana öz adına uyğun Xavvot-Yair adını verdi, bu günə qədər də belə adlanır. ");
INSERT INTO azb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Gileadı Makirə verdim. ");
INSERT INTO azb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ruvenlilərlə Qadlılara Gileaddan Arnon vadisinə qədər uzanan torpaqları verdim. Vadinin ortası onların sərhədi, Ammonlularla sərhədləri isə Yabboq çayı idi. ");
INSERT INTO azb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Aravada sərhəd İordan çayı idi: Kinneretdən Arava dənizinə, yəni Duz dənizinə, şərq tərəfdəki Pisqa yamaclarının altına qədər uzanırdı. ");
INSERT INTO azb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","O vaxtlar sizə əmr edib dedim: “Bu torpağı mülk olaraq almaq üçün Allahınız Rəbb sizə verdi. Siz – bütün cəngavərlər silahlanaraq soydaşlarınız İsrail övladlarının qarşısında gedin. ");
INSERT INTO azb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Hər biriniz sizə verdiyim şəhərlərə sonralar qayıda bilərsiniz”. ");
INSERT INTO azb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Amma Rəbb sizin kimi soydaşlarınıza da rahatlıq verənə qədər, Rəbbin İordan çayının şərqində onlara verdiyi torpağı mülk olaraq alana qədər arvadlarınız, uşaqlarınız və heyvanlarınız – bilirəm ki, çox heyvanlarınız var – sizə verdiyim şəhərlərdə qalsınlar. ");
INSERT INTO azb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","O vaxtlar Yeşuaya əmr edib dedim: “Allahınız Rəbbin bu iki padşahın başına gətirdiyi hər şeyi gözlərinizlə gördünüz. Rəbb keçəcəyiniz bütün ölkələrdə belə edəcək. ");
INSERT INTO azb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Onlardan qorxmayın, çünki Allahınız Rəbb Özü sizin üçün döyüşəcək!” ");
INSERT INTO azb_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","O zaman Rəbbə yalvararaq dedim: ");
INSERT INTO azb_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Ya Xudavənd Rəbb, Sən Öz böyüklüyünü və qüdrətli əlini bu quluna göstərməyə başladın. Göydə və yerdə hansı allah var ki, Sənin etdiyin böyük işləri görə bilsin, Sənin kimi hər şeyə qadir olsun! ");
INSERT INTO azb_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Rica edirəm, qoy İordan çayını keçib onun qərb tərəfində olan gözəl torpağı – o gözəl dağlıq bölgəsini və Livanı görüm”. ");
INSERT INTO azb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Lakin sizin ucbatınızdan Rəbb mənə qəzəblənmişdi, ona görə də məni eşitmədi və dedi: “Bəsdir, bu barədə bir daha Mənə müraciət etmə! ");
INSERT INTO azb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Pisqa təpəsinə çıxıb qərbə, şimala, cənuba və şərqə göz gəzdir. Qoy gözlərin oraları görsün, çünki sən İordan çayını keçməyəcəksən. ");
INSERT INTO azb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Yeşuaya əmr ver. Ona cəsarət verərək qüvvətləndir, çünki bu xalqın önündən keçərək görəcəyin torpağı irs olaraq onlar üçün Yeşua böləcək”. ");
INSERT INTO azb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Buna görə də Bet-Peor qarşısında olan dərədə dayandıq. ");
INSERT INTO azb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","İndi, ey İsraillilər, sizə öyrədəcəyim qaydalara və hökmlərə qulaq asın. Onlara əməl etsəniz, yaşayacaqsınız, atalarınızın Allahı Rəbbin sizə verəcəyi torpağa daxil olub oranı irs olaraq alacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Sizə verəcəyim əmrlərə heç nə artırıb-əskiltməyin. Yalnız Allahınız Rəbbin əmrlərinə – sizə verəcəyim əmrlərə riayət edin. ");
INSERT INTO azb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Rəbbin Baal-Peorda nələr etdiyini öz gözünüzlə gördünüz. Allahınız Rəbb Peordakı Baala səcdə edənlərin hamısını aranızdan yox etdi. ");
INSERT INTO azb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Siz isə Allahınız Rəbbə sadiq olduğunuz üçün bu gün sağsınız. ");
INSERT INTO azb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Baxın Allahım Rəbbin mənə əmr etdiyi qayda və hökmləri sizə öyrətmişəm ki, mülk olaraq almaq üçün daxil olacağınız torpaqda bunlara əməl edəsiniz. ");
INSERT INTO azb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Onlara diqqətlə riayət edin. Bu, digər xalqlara nə qədər müdrik və aqil olduğunuzu göstərər. Onlar bu qaydaları eşidəndə deyəcəklər ki, bu böyük millət, həqiqətən, müdrik və aqil bir xalqdır! ");
INSERT INTO azb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Allahımız Rəbb hər dəfə dua edərkən bizə yaxın olar. Axı hansı millət belə üstündür ki, Allahı ona bu cür yaxın olsun? ");
INSERT INTO azb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Hansı millət belə üstündür ki, bu gün qarşınıza gətirdiyim bu Qanun kimi ədalətli qaydalara və hökmlərə malik olsun? ");
INSERT INTO azb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ancaq diqqətli olun. Gözünüzlə gördüklərinizi unutmamaq və ömür boyu yaddan çıxarmamaq üçün böyük səy göstərin. Bunları övladlarınıza, nəvələrinizə öyrədin. ");
INSERT INTO azb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Xorevdə Allahınız Rəbbin önündə dayandığınız günü xatırlayın. O zaman Rəbb mənə dedi: “Xalqı Mənim üçün bir yerə topla. Mən Öz sözlərimi onlara eşitdirəcəyəm. Belə ki yer üzərində yaşadıqları müddətdə yalnız Məndən qorxmağı öyrənsinlər və övladlarına öyrətsinlər”. ");
INSERT INTO azb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Siz də yaxınlaşıb dağın ətəyində dayandınız. Dağ yanır, alovu göyün dərinliklərinə çatırdı. Hər yan isə qara bulud və qatı zülmət içində idi. ");
INSERT INTO azb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Rəbb sizinlə bu alovun içərisindən danışdı. Siz Onun danışıq səsini eşitdiniz, lakin bir surət görmədiniz. Yalnız bir səs var idi. ");
INSERT INTO azb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","O sizə əhdini, yəni əməl etmənizi buyurduğu On Əmri elan etdi. Bunları iki daş lövhə üzərinə yazdı. ");
INSERT INTO azb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Elə o vaxt Rəbb mənə mülk olaraq almaq üçün gedəcəyiniz torpaqda əməl edəcəyiniz qayda və hökmləri öyrətmək tapşırığını verdi. ");
INSERT INTO azb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Rəbb Xorevdə alovun içərisindən sizinlə danışan gün heç bir surət görmədiniz. Buna görə çox diqqətli olun ki, ");
INSERT INTO azb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","yoldan azıb özünüz üçün kişi və yaxud qadınabənzər, ");
INSERT INTO azb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","yerdə olan hər hansı bir heyvanabənzər, göydə uçan hər hansı bir qanadlı quşabənzər, ");
INSERT INTO azb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","torpaqda sürünən hər hansı bir məxluqabənzər, yerin dərinliklərində yığılan suda yaşayan hər hansı bir balığabənzər, hər hansı bir cisməbənzər oyma büt yaratmayasınız. ");
INSERT INTO azb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Gözlərinizi göyə qaldıraraq günəşi, ayı, ulduzları və bütün səma cisimlərini görəndə azmayın. Allahınız Rəbbin bütün səma altındakı xalqlara verdiyi bu şeylərlə aldanıb onlara səcdə edərək sitayiş etməyin. ");
INSERT INTO azb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Sizə gəldikdə isə, Rəbb sizi götürüb dəmirəridən soba içindən – Misirdən çıxarıb ki, bugünkü kimi Ona məxsus xalq olasınız. ");
INSERT INTO azb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Sizin ucbatınızdan Allahınız Rəbb mənə qəzəbləndi və and etdi ki, mən İordan çayını keçib irs olaraq sizə verdiyi o gözəl torpağa daxil olmayım. ");
INSERT INTO azb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","İordan çayını keçə bilməyib bu torpaqda öləcəyəm. Siz isə o gözəl torpağa keçəcək və oranı mülk olaraq alacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Ehtiyatlı olun ki, Allahınız Rəbbin sizinlə etdiyi əhdi unutmayasınız. Allahınız Rəbbin qadağan etdiyi hər hansı bir şeyə bənzər oyma büt yaratmayın. ");
INSERT INTO azb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Çünki Allahınız Rəbb hər şeyi yandırıb-yaxan alovdur. O, qısqanc Allahdır. ");
INSERT INTO azb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Siz ölkədə yaşayıb övladlarınız, nəvələriniz doğulandan sonra oyma büt yaradaraq yoldan azsanız, Allahınız Rəbbin gözündə pis olanı edib Onu acıqlandırsanız, ");
INSERT INTO azb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","sizin qarşınızda bu gün göyləri və yeri şahid tuturam ki, mülk olaraq almaq üçün İordan çayını keçib getdiyiniz torpaq üzərindən tezliklə yox olacaqsınız. O torpaqda uzun ömür sürməyəcəksiniz, tamamilə məhv olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Rəbb sizi xalqlar arasına səpələyəcək və apardığı yerdə millətlər arasında sizdən az miqdarda adam sağ qalacaq. ");
INSERT INTO azb_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Orada isə siz insanın əl işi olan – görməyən, eşitməyən, yeməyən, iy bilməyən ağacdan və ya daşdan olan allahlara qulluq edəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Amma o yerdə Allahınız Rəbbi axtaracaqsınız. Əgər Onu bütün qəlbinizlə, bütün varlığınızla axtarsanız, tapacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Əzabda olarkən, bütün bu hadisələr başınıza gələrkən, nəhayət, Rəbbə dönüb Ona qulaq asacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Axı Allahınız Rəbb rəhmli Allahdır. O sizi atmaz, məhv etməz. Atalarınıza andla təsdiq etdiyi əhdi unutmaz. ");
INSERT INTO azb_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","İndi Allahınızın yer üzərində insan yaratdığı gündən bəri sizdən əvvəlki dövrün günləri barədə göylərin bir başından o biri başına qədər hamıdan soruşun. Belə böyük hadisə olubmu? Belə bir şey eşidilibmi? ");
INSERT INTO azb_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Hansı bir xalq sizin kimi alov içərisindən danışan Allahın səsini eşitdi və sağ qaldı? ");
INSERT INTO azb_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Yaxud hansı allah Allahınız Rəbb kimi Misirdə gözləriniz önündə sizin xeyrinizə işləyərək imtahanlarla, əlamətlərlə, möcüzələrlə, döyüşlərlə, qüdrətli əli ilə, uzanan qolu ilə, böyük zəhmi ilə başqa millətin üstünə gedib onlardan öz millətini aldı? ");
INSERT INTO azb_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Bütün bunlar sizə ona görə göstərildi ki, bunu biləsiniz: yalnız Rəbb Allahdır, başqası yoxdur. ");
INSERT INTO azb_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Sizi tərbiyə etmək üçün göylərdən səsini sizə eşitdirdi. Öz böyük alovunu yer üzərində sizə göstərdi və alovun içərisindən Onun sözlərini eşitdiniz. ");
INSERT INTO azb_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Atalarınızı sevdiyindən onlardan sonra övladlarını seçdi. Sizi böyük qüdrəti ilə Misirdən Şəxsən Özü çıxartdı ki, ");
INSERT INTO azb_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","sizdən böyük və qüvvətli millətləri qarşınızdan qovsun və bugünkü kimi onların torpağını irs olaraq vermək üçün sizi oraya gətirsin. ");
INSERT INTO azb_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Bu gündən bilin və yadınızda qalsın ki, yuxarıda – göydə və aşağıda – yerdə Rəbb Allahdır. Ondan başqası yoxdur. ");
INSERT INTO azb_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Bu gün sizə verdiyim Rəbbin qanun və əmrlərinə riayət edin ki, sizə, sizdən sonra gələn övladlarınıza xeyir gətirsin, Allahınız Rəbbin əbədi olaraq verdiyi bu torpaqda uzun ömür sürəsiniz». ");
INSERT INTO azb_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","O zaman Musa İordan çayının şərq tərəfində üç şəhər seçdi. ");
INSERT INTO azb_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Bu şəhərləri qonşusu ilə əvvəlcədən ədavəti olmayan və bilmədən onu öldürən adamın oraya qaçması üçün ayırdı. Belə adam bu şəhərlərdən birinə qaçıb sağ qala bilər. ");
INSERT INTO azb_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Bunlar Ruven qəbiləsi üçün yaylada yerləşən səhradakı Beser, Qadlılar üçün Gileaddakı Ramot, Menaşşe qəbiləsi üçün isə Başandakı Qolan şəhərləri idi. ");
INSERT INTO azb_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Musa Qanunu İsrail övladlarının qarşısına qoydu. ");
INSERT INTO azb_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Bu, Misirdən çıxan zaman Musanın İsrail övladlarına verdiyi göstərişlər, qayda və hökmlərdir. ");
INSERT INTO azb_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Bunları Musa İordan çayının şərqində Misirdən çıxan zaman Musa ilə İsrail övladlarının həlak etdikləri Xeşbonda yaşayan Emorluların padşahı Sixonun ölkəsində olan Bet-Peor qarşısındakı dərədə söylədi. ");
INSERT INTO azb_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","İrs olaraq onun ölkəsini və Başan padşahı Oqun ölkəsini – İordan çayının şərq tərəfindən əldə edilən Emorluların iki padşahının ölkəsini, ");
INSERT INTO azb_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Arnon vadisi kənarında olan Aroerdən Siyon dağına qədər, yəni Xermona qədər, ");
INSERT INTO azb_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","İordan çayının şərqində Arava dənizinə qədər olan Pisqa yamaclarının altındakı bütün Aravanı aldılar. ");
INSERT INTO azb_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Musa bütün İsrailliləri çağırıb dedi: «Dinlə, ey İsrail! Bu gün sənə deyəcəyim qayda və hökmləri öyrənib dəqiq əməl et! ");
INSERT INTO azb_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Xorevdə Allahımız Rəbb bizimlə əhd kəsdi. ");
INSERT INTO azb_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Bu əhdi Rəbb atalarımızla deyil, bu gün məhz burada bizim sağ qalanlarımızla kəsdi. ");
INSERT INTO azb_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Rəbb dağdakı alovun içərisindən sizinlə üzbəüz danışdı. ");
INSERT INTO azb_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","O zaman Rəbbin sözünü izah etmək üçün sizinlə Rəbbin arasında mən dayanmışdım. Alovdan qorxduğunuza görə dağa çıxmadınız. ");
INSERT INTO azb_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Rəbb belə dedi: “Səni Misir torpağından, köləlik diyarından çıxaran Allahın Rəbb Mənəm. ");
INSERT INTO azb_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Məndən başqa allahların olmasın. ");
INSERT INTO azb_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Özün üçün heç bir oyma büt, nə yuxarıda – səmada və ya aşağıda – yerdə, nə də yerdən aşağıya yığılan sulardakı şeylərin heç birinin surətini düzəltmə. ");
INSERT INTO azb_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Belə şeylərə səcdə qılaraq ibadət etmə. Çünki Mən sənin Allahın Rəbb qısqanc Allaham. Mənə nifrət edən ataların cəzasını üç-dörd nəslə qədər övladlarına çəkdirərəm. ");
INSERT INTO azb_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Məni sevib əmrlərimə əməl edənlərin isə minlərlə nəslinə məhəbbət göstərərəm. ");
INSERT INTO azb_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Allahın Rəbbin adını boş yerə dilinə gətirmə, çünki Rəbb Öz adını boş yerə dilinə gətirəni cəzasız qoymaz. ");
INSERT INTO azb_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Allahın Rəbbin sənə etdiyi əmrə əsasən Şənbə gününü qeyd və təqdis et. ");
INSERT INTO azb_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Altı gün çalışıb bütün işlərini gör. ");
INSERT INTO azb_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Lakin yeddinci gün Allahın Rəbbin Şənbə günüdür. Bu gün sən, oğlun, qızın, qulun, qarabaşın, öküzün, eşşəyin, heç bir heyvanın, yanında qalan yadellin də heç bir iş görməsin, sənin kimi qul-qarabaşın da istirahət etsin. ");
INSERT INTO azb_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Misir torpağında sənin kölə olduğunu və Allahın Rəbbin qüdrətli əli, uzanan qolu ilə səni oradan çıxardığını yadda saxla. Məhz buna görə Şənbə gününü qeyd etməyi Allahın Rəbb sənə əmr edib. ");
INSERT INTO azb_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Allahın Rəbbin sənə əmr etdiyi kimi ata-anana hörmət et ki, ömrün uzun olsun və Allahın Rəbbin sənə verəcəyi torpaqda xoş güzəranın olsun. ");
INSERT INTO azb_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Qətl etmə. ");
INSERT INTO azb_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Zina etmə. ");
INSERT INTO azb_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Oğurluq etmə. ");
INSERT INTO azb_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Heç kimə qarşı yalandan şahidlik etmə. ");
INSERT INTO azb_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Heç kimin arvadına tamah salma. Heç kimin evinə, tarlasına, quluna, qarabaşına, öküzünə, eşşəyinə – heç bir şeyinə tamah salma”. ");
INSERT INTO azb_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Rəbb bu sözləri bütün camaatınıza dağda alovun, buludun və qatı qaranlığın içərisindən ucadan söylədi, başqa bir söz demədi. Sonra bunları iki lövhə üzərinə yazıb mənə verdi. ");
INSERT INTO azb_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Dağ alovlanıb-yanarkən zülmət içindən siz Onun səsini eşidəndə bütün qəbilə başçılarınız və ağsaqqallarınız mənə yaxınlaşdı. ");
INSERT INTO azb_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Belə dediniz: “Budur, Allahımız Rəbb bizə ehtişamını və əzəmətini göstərdi. Alovun içərisindən Onun səsini eşitdik. Bu gün gördük ki, Allah insanla danışanda insan sağ qalır. ");
INSERT INTO azb_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Bu gün niyə ölməliyik? Axı bu böyük alov bizi külə döndərər. Əgər Allahımız Rəbbin səsini bir də eşitsək, o zaman öləcəyik. ");
INSERT INTO azb_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Bütün bəşəriyyət içərisində bizim kimi alov içərisindən var olan Allahın səsini eşidib sağ qalan varmı? ");
INSERT INTO azb_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Sən Ona yaxınlaş, Allahımız Rəbbin deyəcəyi hər şeyə qulaq as. Sonra Allahımız Rəbbin dediyi hər şeyi bizə söylə! Biz isə buna qulaq asıb əməl edəcəyik”. ");
INSERT INTO azb_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Rəbb mənə bunları deyəndə bu sözləri siz də eşitdiniz. Rəbb mənə dedi: “Bu xalqın sənə söylədiklərini eşitdim. Söylədikləri hər şeyi yaxşı dedilər. ");
INSERT INTO azb_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Kaş ki ürəkləri dönməsin, Məndən qorxsunlar və bütün əmrlərimə əməl etsinlər. O zaman həm özlərinin, həm də övladlarının xoş güzəranı olar. ");
INSERT INTO azb_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Get, onlara de ki, çadırlarına qayıtsınlar. ");
INSERT INTO azb_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Sən isə burada yanımda dayan. Bütün əmrləri, qayda və hökmləri sənə deyəcəyəm. Sən xalqa öyrət ki, mülk olaraq almaq üçün onlara verəcəyim torpaqda bunları yerinə yetirsinlər”. ");
INSERT INTO azb_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Allahınız Rəbbin sizə əmr etdiklərinə diqqətlə əməl edin, onlardan nə sağa, nə də sola dönün. ");
INSERT INTO azb_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Bütünlüklə Allahınız Rəbbin sizə əmr etdiyi yolda gəzin. Onda sağ qalarsınız, xoş güzəranınız olar və mülk olaraq alacağınız torpaqda uzun ömür sürərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Allahınız Rəbbin sizə öyrətmək üçün mənə buyurduğu əmr, qayda və hökmlər bunlardır. Ona görə də irs olaraq almaq üçün gedəcəyiniz torpaqda bunlara əməl edin. ");
INSERT INTO azb_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ömrün boyu sən, oğlun, nəvələrin sənə buyurduğum Onun bütün qayda və əmrlərinə əməl etməklə Allahın Rəbdən qorx ki, ömrün uzun olsun. ");
INSERT INTO azb_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Dinlə, ey İsrail! Bunlara diqqətlə əməl et ki, atalarının Allahı Rəbbin sənə söz verdiyi kimi süd və bal axan torpaqda xoş güzəran görərək çoxalıb artasan. ");
INSERT INTO azb_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Dinlə, ey İsrail! Allahımız Rəbb yeganə Rəbdir. ");
INSERT INTO azb_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Allahın Rəbbi bütün qəlbinlə, bütün varlığınla, bütün gücünlə sev. ");
INSERT INTO azb_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Bu gün sənə əmr etdiyim bu sözlər ürəyində kök salsın. ");
INSERT INTO azb_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Bunları övladlarının şüuruna yaxşı-yaxşı yerit. Evində oturanda, yol gedəndə, yatanda, duranda bunlar barədə danış. ");
INSERT INTO azb_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Onları yazıb qoluna bir nişan kimi, gözlərinin arasına alın bağı kimi bağla, ");
INSERT INTO azb_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","evlərinin qapı çərçivələrinə və darvazalarına yaz. ");
INSERT INTO azb_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Allahın Rəbb səni ata-babaların İbrahimə, İshaqa, Yaquba etdiyi anda görə verəcəyi torpağa aparacaq. Orada inşa etmədiyin böyük və gözəl şəhərlər, yığmadığın gözəl şeylərlə dolu evlər, ");
INSERT INTO azb_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","zəhmətini çəkmədiyin qazılmış su quyuları, salmadığın üzümlüklər və zeytunluqlar var. Yeyib-doyanda isə diqqətli ol. ");
INSERT INTO azb_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Səni Misir torpağından – köləlik diyarından çıxaran Rəbbi unutma. ");
INSERT INTO azb_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Allahın Rəbdən qorx və Ona qulluq et. Andı Onun adı ilə et. ");
INSERT INTO azb_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Yad allahların – başqa xalqların allahlarının ardınca getmə ki, ");
INSERT INTO azb_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Allahın Rəbbin sənə qarşı qəzəbi alovlanmasın və səni yer üzündən yox etməsin, çünki aranızda olan Allahın Rəbb qısqanc bir Allahdır. ");
INSERT INTO azb_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Allahınız Rəbbi Massada sınadığınız kimi sınamayın. ");
INSERT INTO azb_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ona görə də Allahınız Rəbbin sizə buyurduğu əmrlərə, göstərişlərə və qanunlara diqqətlə əməl edin. ");
INSERT INTO azb_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Rəbbin gözündə doğru və yaxşı olana əməl et ki, xoş güzəranın olsun, Rəbbin atalarına vəd etdiyi gözəl torpağı irs olaraq ala biləsən. ");
INSERT INTO azb_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Rəbb də söz verdiyi kimi bütün düşmənlərini qarşından qovacaq. ");
INSERT INTO azb_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Əgər gələcəkdə oğlun sənə “Allahımız Rəbbin sizə buyurduğu göstərişlərin, qayda və hökmlərin mənası nədir?” deyə soruşsa, ");
INSERT INTO azb_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","oğluna belə de: “Biz Misirdə fironun köləsi idik. Rəbb oradan bizi qüdrətli əli ilə çıxartdı. ");
INSERT INTO azb_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Rəbb gözümüzün önündə Misirə, fironla bütün ailəsinə böyük, dəhşətli əlamətlər və möcüzələr göstərdi. ");
INSERT INTO azb_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Bizi oradan çıxartdı ki, atalarımıza vəd etdiyi bu torpağa gətirsin və oranı bizə versin. ");
INSERT INTO azb_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Allahımız Rəbb bütün bu qaydalara əməl etməyi və Ondan qorxmağı bizə ona görə buyurdu ki, həmişə güzəranımız xoş olsun, bugünkü kimi bizi sağ saxlasın. ");
INSERT INTO azb_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Allahımız Rəbbin hüzurunda bizə buyurduğu bütün bu əmrlərə diqqətlə əməl etsək, bunu bizə salehlik sayacaq”. ");
INSERT INTO azb_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Allahınız Rəbb sizi gedəcəyiniz torpağa aparır. Siz oranı mülk olaraq alacaqsınız. O sizin önünüzdən bir çox milləti – Xetliləri, Qirqaşlıları, Emorluları, Kənanlıları, Perizliləri, Xivliləri, Yevusluları – sizdən xeyli çox, xeyli qüvvətli yeddi milləti qovacaq. ");
INSERT INTO azb_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Allahınız Rəbb onları sizə təslim edəcək. Siz onları məğlub edərək tamamilə məhv edin. Onlarla əhd bağlamayın və rəhm etməyin. ");
INSERT INTO azb_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Onlarla qohum olmayın, oğullarına qız verib, oğullarınıza onlardan qız almayın. ");
INSERT INTO azb_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Çünki onlar övladlarınızı Mənim ardımca getməkdən döndərib, başqa allahlara qulluq etdirəcəklər. Onda Rəbbin sizə qarşı qəzəbi alovlanacaq və tezliklə sizi yox edəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Onlarla belə rəftar edin: qurbangahlarını dağıdıb daş sütunlarını sındırın, ilahə Aşera bütlərini baltalayıb oyma bütlərini odda yandırın. ");
INSERT INTO azb_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Çünki siz Allahınız Rəbbin müqəddəs xalqısınız. O sizi yer üzündəki bütün xalqlar içərisindən Özünə məxsus xalq olaraq seçdi. ");
INSERT INTO azb_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Rəbbin sizi sevməsi, seçməsi o biri xalqlardan daha çox olduğunuz üçün deyil. Həqiqətən, siz onlardan azsınız. ");
INSERT INTO azb_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Rəbb sizi sevdiyi və atalarınıza verdiyi vədi yerinə yetirmək istədiyi üçün qüdrətli əli ilə sizi Misirdən çıxartdı. O sizi köləlik diyarından, Misir padşahı firondan satın aldı. ");
INSERT INTO azb_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Bilin ki, Allahınız Rəbb əsl Allahdır. O, vəfalı Allahdır. Əhdinə sadiq qalıb Onu sevənlərin, əmrlərini yerinə yetirənlərin minlərlə nəslinə məhəbbətini göstərər. ");
INSERT INTO azb_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Ona nifrət edənləri isə qisas alaraq məhv edəcək. Onlardan qisasını almağa gecikməyəcək, bunu mütləq edəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Ona görə sizə bu gün buyurduğum əmrləri, qaydaları və hökmləri diqqətlə yerinə yetirin. ");
INSERT INTO azb_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Əgər bu əmrlərə qulaq asıb diqqətlə əməl edəcəksinizsə, Allahınız Rəbb ata-babalarınıza etdiyi anda sadiq qalıb məhəbbətini göstərəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","O sizi sevəcək, bərəkətli edib çoxaldacaq. Sizə vermək üçün atalarınıza and etdiyi torpaqda, bətninizdən doğulanlarınızı, torpağınızın bəhrəsini, buğdanızı, təzə şərabınızı, zeytun yağınızı, mal-qaranızın və qoyun-keçilərinizin balalarını bərəkətli edəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","O biri xalqlardan daha çox siz xeyir-dua alacaqsınız. Heç bir kişi və qadınınız sonsuz, heç bir heyvanınız qısır olmayacaq. ");
INSERT INTO azb_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Rəbb üzərinizdən bütün xəstəlikləri götürəcək. Sizi Misirdə gördüyünüz dəhşətli xəstəliklərin heç birinə məruz qoymayacaq. Bu bəlalara sizə nifrət edənləri düçar edəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Allahınız Rəbbin sizə təslim edəcəyi bütün xalqların axırına çıxacaqsınız. Onlara rəhm etməyin, allahlarına sitayiş etməyin. Əgər belə etsəniz, bu sizə tələ olar. ");
INSERT INTO azb_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Bəlkə düşünürsünüz ki, bu millətlər bizdən güclüdür, onları necə qova bilərik? ");
INSERT INTO azb_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Onlardan qorxmayın. Allahınız Rəbbin firona və bütün Misirlilərə nə etdiyini xatırlayın. ");
INSERT INTO azb_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Gözünüzlə gördüyünüz böyük sınaqları, sizi Misirdən çıxaran zaman Allahınız Rəbbin göstərdiyi əlamətləri, möcüzələri, qüdrətli əlini, uzanan qolunu xatırlayın. Hazırda qorxduğunuz xalqların hamısını Allahınız Rəbb bu hala salacaq. ");
INSERT INTO azb_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Yerdə qalıb sizdən gizlənənlərin üzərinə də Allahınız Rəbb eşşəkarısı göndərib hamısını yox edəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Onlardan heç qorxmayın, çünki aranızda olan Allahınız Rəbb böyük və zəhmli Allahdır. ");
INSERT INTO azb_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Allahınız Rəbb yavaş-yavaş o millətləri qarşınızdan qovacaq. Onları tezliklə məhv edə bilməyəcəksiniz, yoxsa çöl heyvanları üstünüzə daraşar. ");
INSERT INTO azb_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Allahınız Rəbb onları sizə təslim edəcək və vahiməyə salaraq, nəhayət, yox edəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Onların padşahlarını da sizə təslim edəcək. Siz də onların adlarını səma altından siləcəksiniz. Siz onları qırarkən kimsə qarşınızı ala bilməyəcək. ");
INSERT INTO azb_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Onların allah saydıqları oyma bütlərə od vurub yandırın. Onlara çəkilmiş qızıl-gümüşə gözünüz düşməsin. Özünüz üçün onlardan götürməyin, yoxsa tələyə düşərsiniz, çünki onlar Allahınız Rəbbin gözündə iyrəncdir. ");
INSERT INTO azb_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Belə iyrənc şeyləri evinizə gətirməyin, yoxsa siz də onlar kimi məhv olarsınız. Onlara tamamilə ikrah və nifrət etməlisiniz, çünki belə təsvirlər məhv olunmağa həsr olunub. ");
INSERT INTO azb_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Bu gün sizə buyurduğum bütün əmrləri yerinə yetirməyə çalışın. Onda yaşayıb çoxalar və Rəbbin atalarınıza vəd etdiyi torpağa daxil olub irs olaraq oranı alarsınız. ");
INSERT INTO azb_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Allahınız Rəbbin sizi qırx il səhrada gəzdirdiyi uzun səyahəti yada salın. Bunu ona görə etdi ki, təkəbbürünüzü qırsın və sizi sınaqdan keçirərək ürəyinizdəkini öyrənsin; görsün ki, siz Onun əmrlərinə əməl edəcəksiniz ya yox. ");
INSERT INTO azb_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Təkəbbürünüzü qırmaq üçün sizi ac qoydu, sonra isə nə sizin, nə də atalarınızın gördüyü manna ilə sizi qidalandırdı. Bununla öyrətdi ki, insan yalnız çörəklə deyil, Rəbbin ağzından çıxan hər kəlmə ilə yaşayar. ");
INSERT INTO azb_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Bu qırx il ərzində paltarınız yırtılıb dağılmadı, ayaqlarınız şişmədi. ");
INSERT INTO azb_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Bunu ürəkdən dərk edin ki, insan öz övladına necə tərbiyə verirsə, Allahınız Rəbb də sizə elə tərbiyə verir. ");
INSERT INTO azb_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Allahınız Rəbbin əmrlərinə riayət edib Onun yolları ilə gedin və Ondan qorxun. ");
INSERT INTO azb_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Çünki Allahınız Rəbb sizi gözəl torpağa – çay və gölləri olan, dərə və təpələrində bulaqlar çağlayan yerlərə aparır. ");
INSERT INTO azb_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","O torpaq buğda, arpa, üzüm, əncir, nar, yağlı zeytun və bal yetirir. ");
INSERT INTO azb_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Ora elə bir torpaqdır ki, orada qıtlıqla çörək yeməyəcək və heç nəyə möhtac olmayacaqsınız; daşlarından dəmir, dağlarından isə mis çıxara biləcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Yeyib-doyanda sizə verdiyi gözəl torpağa görə Allahınız Rəbbə həmd edəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Ehtiyatlı olun ki, Allahınız Rəbbi unutmayasınız. Bu gün sizə buyurduğum Rəbbin əmr, hökm və qaydalarına riayət edin. ");
INSERT INTO azb_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Yeyib doyanda, gözəl evlər tikib içərisində oturanda, ");
INSERT INTO azb_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","naxırınız, sürünüz çoxalanda, qızıl-gümüşünüz və hər şeyiniz artanda ");
INSERT INTO azb_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ürəyiniz qürurla dolmasın. Diqqət edin ki, sizi Misir torpağından – köləlik diyarından çıxaran Allahınız Rəbbi unutmayasınız. ");
INSERT INTO azb_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Rəbb sizi o böyük və qorxunc səhrada, zəhərli ilan və əqrəblərlə dolu olan o susuz şoran torpaqlarda gəzdirdi, sizə sərt qayalardan su çıxartdı. ");
INSERT INTO azb_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Sizi atalarınıza məlum olmayan manna ilə qidalandırdı. Xoş güzəranınız olsun deyə təkəbbürünüzü qıraraq sizi sınaqdan keçirdi. ");
INSERT INTO azb_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ürəyinizdə “biz öz qabiliyyətimizlə və biləyimizin gücü ilə bu sərvəti qazandıq” deməyəsiniz. ");
INSERT INTO azb_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Unutmayın ki, bu sərvəti qazanmaq qabiliyyətini sizə verən Allahınız Rəbdir. O bunu edir ki, bugünkü kimi atalarınıza vəd verərək sizinlə kəsdiyi əhdi yerinə yetirsin. ");
INSERT INTO azb_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Əgər Allahınız Rəbbi unudub başqa allahların ardınca getsəniz, onlara sitayiş edərək səcdə etsəniz, bu gün sizin qarşınızda şəhadət edirəm ki, mütləq məhv olacaqsınız! ");
INSERT INTO azb_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Allahınız Rəbbin sözünə qulaq asmasanız, Rəbb sizin qarşınızdan millətləri yox etdiyi kimi sizi də yox edəcək. ");
INSERT INTO azb_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Ey İsraillilər, qulaq asın! Bu gün sizdən daha böyük, daha qüdrətli millətlərin torpaqlarını irs olaraq almaq üçün İordan çayını keçmək ərəfəsindəsiniz. Onların şəhərləri böyük, hasarları göylərə çatır. ");
INSERT INTO azb_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Bu güclü, ucaboy xalq Anaqlılardır. Onları tanıyırsınız və barələrində belə eşitmisiniz: “Anaqlıların qarşısında kim dayana bilər?” ");
INSERT INTO azb_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Bu gün də bilin ki, sizin önünüzdə gedən Allahınız Rəbb hər şeyi yandırıb-yaxan alovdur. Rəbb onları qıracaq, qarşınızda boyun əydirəcək və sizə söylədiyi kimi onları qovub tezliklə yox edəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Allahınız Rəbb onları önünüzdən kənara atanda ürəyinizdə deməyin ki, bu torpağı almaq üçün Rəbb bizi buraya salehliyimizə görə gətirdi. Belə ki Rəbb bu millətləri pis əməllərinə görə önünüzdən qovur. ");
INSERT INTO azb_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Torpaqlarına girib irs olaraq oranı almağınız sizin salehliyinizə və ürəyinizin düzlüyünə görə deyil. Ancaq Allahınız Rəbb bu millətləri pis əməllərinə görə sizin qarşınızdan qovacaq ki, ata-babalarınız İbrahimə, İshaqa, Yaquba verdiyi vədi yerinə yetirsin. ");
INSERT INTO azb_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Bilin ki, Allahınız Rəbb salehliyinizə görə bu gözəl torpağı mülk olaraq almaq üçün sizə vermir, çünki siz dikbaş bir xalqsınız. ");
INSERT INTO azb_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Bunu yada salın və Allahınız Rəbbi səhrada necə qəzəbləndirdiyinizi unutmayın. Misir torpağından çıxdığınız gündən bu yerə gələnədək Rəbbə qarşı nə qədər itaətsizlik etdiniz. ");
INSERT INTO azb_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Rəbbi Xorevdə qəzəbləndirdiniz. Rəbb sizi məhv edəcək qədər hiddətləndi. ");
INSERT INTO azb_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Mən Rəbbin sizinlə etdiyi əhdin lövhələri olan daş lövhələri götürmək üçün dağa çıxanda orada qırx gün-qırx gecə qaldım: nə çörək yedim, nə də su içdim. ");
INSERT INTO azb_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Rəbb Allah mənə Öz barmağı ilə yazdığı iki daş lövhə verdi. Yığıldığınız gün dağda Rəbbin sizə alovun içindən bildirdiyi bütün əmrlər onların üzərində yazılmışdı. ");
INSERT INTO azb_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Rəbb iki daş lövhəni – əhd lövhələrini qırx gün-qırx gecənin sonunda mənə verdi. ");
INSERT INTO azb_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Sonra Rəbb dedi: “Tez ol, dağdan en, çünki Misirdən çıxardığın xalq əxlaqsızlıq edir. Onlar buyurduğum yoldan yaman tez azdılar. Özlərinə tökmə büt yaradıblar”. ");
INSERT INTO azb_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Rəbb mənə bunu da söylədi: “Görürəm ki, bu xalq dikbaş xalqdır. ");
INSERT INTO azb_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Qoy onları yox edim. Adlarını səma altından silim. Səndən isə onlardan daha güclü, daha böyük millət törədim”. ");
INSERT INTO azb_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Mən dönərək dağdan aşağı endim. Dağ alovlanıb yanırdı. Əhdin yazıldığı iki lövhə əlimdə idi. ");
INSERT INTO azb_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Gördüm ki, Allahınız Rəbbə qarşı günah edirsiniz. Özünüz üçün danayabənzər bir tökmə büt düzəltmisiniz və Rəbbin sizə buyurduğu yoldan yaman tez azmısınız. ");
INSERT INTO azb_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Buna görə də əlimdə tutduğum iki lövhəni atdım və gözünüz önündə onları parça-parça etdim. ");
INSERT INTO azb_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Yenə Rəbbin hüzurunda heç nə yeyib-içmədən qırx gün-qırx gecə yerə sərilib qaldım, çünki günah etmişdiniz və Rəbbin gözündə pis sayılan işlər görərək Onu qəzəbləndirmişdiniz. ");
INSERT INTO azb_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Rəbbin qızğın qəzəbi qarşısında qorxdum. Qəzəbi o qədər alovlanmışdı ki, O sizi yox etmək istəyirdi. Amma Rəbb yenə də yalvarışımı eşitdi. ");
INSERT INTO azb_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Rəbb Haruna da hiddətlənmişdi. Onu da yox etmək istəyirdi. O an Harun üçün də yalvardım. ");
INSERT INTO azb_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Etdiyiniz günah əşyasını – o danayabənzər tökmə bütü götürüb oda atdım və sındırdım, əzib toza döndərdim. Sonra tozu dağdan axan selə tökdüm. ");
INSERT INTO azb_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Siz Taverada, Massada, Qivrot-Hattaavada da Rəbbi qəzəbləndirdiniz. ");
INSERT INTO azb_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Rəbb sizi Qadeş-Barneadan yola salarkən belə buyurmuşdu: “Gedin, sizə verəcəyim torpağı özünüz üçün irs olaraq alın”. Siz isə Allahınız Rəbbin əmrinə qarşı çıxdınız, Rəbbə güvənmədiniz, sözünə qulaq asmadınız. ");
INSERT INTO azb_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Sizi tanıyan gündən bu vaxta qədər dayanmadan Rəbbə qarşı üsyankar oldunuz. ");
INSERT INTO azb_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Rəbb sizi yox edəcəyini söylədiyi üçün qırx gün-qırx gecə Onun hüzurunda yerə döşənib qaldım. ");
INSERT INTO azb_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Rəbbə yalvarıb dedim: “Ya Xudavənd Rəbb, Misirdən böyük qüvvətinlə, qüdrətli əlinlə çıxararaq qurtardığın xalqını, Öz irsini yox etmə. ");
INSERT INTO azb_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Qulların İbrahimi, İshaqı, Yaqubu yada sal. Bu xalqın dikbaşlığına, pisliyinə, günahına nəzər salma. ");
INSERT INTO azb_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Yoxsa bizi çıxartdığın ölkənin xalqı deyəcək ki, Rəbb onları vəd etdiyi torpağa apara bilmədi və bu xalqa nifrət etdiyi üçün onları səhrada məhv etmək məqsədi ilə Misirdən çıxartdı. ");
INSERT INTO azb_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Halbuki onlar Sənin xalqın, Sənin irsindir. Sən onları böyük qüdrətinlə, uzanan qolunla oradan çıxartmısan”. ");
INSERT INTO azb_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","O vaxt Rəbb mənə dedi: “Əvvəlki kimi özün üçün iki daş lövhə yon və dağa – yanıma çıx. Ağacdan bir sandıq da düzəlt. ");
INSERT INTO azb_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Qırdığın əvvəlki lövhələrdə yazılan sözləri yeni lövhələrin üstündə yazacağam. Onları sandığa qoy”. ");
INSERT INTO azb_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Əbrişim ağacından bir sandıq düzəldib əvvəlki kimi iki daş lövhəni yondum. Sonra bu iki daş lövhəni əlimə götürüb dağa çıxdım. ");
INSERT INTO azb_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Rəbb yığıldığınız gün dağda alovun içindən Özünün sizə bildirdiyi On Əmri bu lövhələr üzərinə yenə də əvvəlki kimi yazdı və mənə verdi. ");
INSERT INTO azb_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Mən dönüb dağdan enərək Rəbbin mənə əmr etdiyi kimi bu lövhələri düzəltdiyim sandığa qoydum və həmin lövhələr orada qaldı. ");
INSERT INTO azb_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","İsrail övladları Yaaqan övladlarına məxsus quyular olan yerdən Moseraya köçdülər. Harun orada ölüb dəfn olundu. Onun yerinə oğlu Eleazar kahin oldu. ");
INSERT INTO azb_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Oradan Qudqodaya və Qudqodadan da axar sular diyarı olan Yotvataya köçdülər. ");
INSERT INTO azb_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","O zaman Rəbb Levi qəbiləsini ayırdı ki, Rəbbin Əhd sandığını daşısınlar, Rəbbə xidmət edərək, Onun adı ilə xeyir-dua verərək hüzurunda dayansınlar. Onlar bu günədək eyni işi görürlər. ");
INSERT INTO azb_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Elə buna görə də Levililərə İsrailli soydaşları ilə birlikdə pay və irsi torpaq düşmədi. Allahınız Rəbbin onlara söz verdiyi kimi onların irsi Rəbb Özüdür. ");
INSERT INTO azb_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Əvvəlki kimi yenə də qırx gün-qırx gecə dağda qalmışdım. Rəbb bu dəfə də məni dinlədi və ona görə sizi qırmaq istəmədi. ");
INSERT INTO azb_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Rəbb mənə dedi: “Qalx köçən xalqın qarşısında get ki, atalarına vəd edib söz verdiyim torpağa daxil olub oranı irs olaraq alsınlar”. ");
INSERT INTO azb_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","İndi, ey İsrail, axı Allahın Rəbb səndən nə istəyir? Yalnız bunu istəyir: Ondan qorx, tamamilə Onun yolunu tut, Onu sev, bütün qəlbinlə və bütün varlığınla Allahın Rəbbə sitayiş et. ");
INSERT INTO azb_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Bu gün xoş güzəranın üçün sənə buyurduğum Rəbbin əmr və qaydalarına riayət et. ");
INSERT INTO azb_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Bax göylər, göylərin ən uca qatları belə, yer üzü və yer üzərində olan hər şey Allahın Rəbbindir. ");
INSERT INTO azb_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Lakin Rəbb atalarınıza şəfqətli olmuşdur. Onları sevib sonrakı nəsil olan sizi bugünkü kimi bütün xalqlar arasından seçdi. ");
INSERT INTO azb_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Elə buna görə ürəklərinizi sünnət edin ki, bir daha dikbaş olmayasınız. ");
INSERT INTO azb_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Çünki Allahınız Rəbb allahların Allahı, hökmranların Hökmranıdır. O tərəfkeşlik etməyən, rüşvət almayan, böyük, qüdrətli, zəhmli Allahdır. ");
INSERT INTO azb_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","O, yetimin və dul qadının haqqını qoruyur. Qəribi sevir, ona çörək və paltar verir. ");
INSERT INTO azb_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Siz də qəribi sevin, çünki özünüz də Misir ölkəsində qərib idiniz. ");
INSERT INTO azb_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Allahınız Rəbdən qorxun, Ona sitayiş edərək sadiq qalın və yalnız Onun adı ilə and için. ");
INSERT INTO azb_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ona həmişə həmd edin. Gözünüzlə gördüyünüz əzəmətli və zəhmli əlamətləri edən Allahınızdır. ");
INSERT INTO azb_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Atalarınız yetmiş nəfər olaraq Misirə getmişdi. İndi isə Allahınız Rəbb sizi çoxaldaraq göydəki ulduzlar qədər edib. ");
INSERT INTO azb_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Allahınız Rəbbi sevin. Həmişə Onun buyruq, qayda, hökm və əmrlərinə əməl edin. ");
INSERT INTO azb_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Bu gün yadda saxlayın ki, Allahınız Rəbbin təlimini öyrənib sınaqdan keçirən övladlarınız deyil, sizsiniz. Onun əzəmətini, qüdrətli əlini, uzanan qolunu, ");
INSERT INTO azb_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Misirdə firona və bütün torpağına etdiyi əlamətləri, gördüyü işləri, ");
INSERT INTO azb_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Misir ordusuna, onların atlarına, döyüş arabalarına nə etdiyini, ardınızca düşərkən onları Qırmızı dənizin sularında necə qərq etdiyini, Rəbbin onları bu günədək davam edən bir qırğına necə düçar etdiyini ");
INSERT INTO azb_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","və səhrada, bu yerə çatanadək sizin üçün nə etdiyini, ");
INSERT INTO azb_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Ruvenli Eliavın oğullarına – Datana və Avirama nə etdiyini gördünüz: bütün İsraillilərin arasında yeri yardı, onları və evindəkiləri çadırları ilə bərabər onlara məxsus olan bütün canlıları uddu. ");
INSERT INTO azb_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Siz Rəbbin etdiyi bu əzəmətli işlərin hamısını öz gözlərinizlə görürsünüz. ");
INSERT INTO azb_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Bu gün sizə buyurduğum əmrlərin hamısına əməl edin ki, qüvvətli olasınız və mülk olaraq almaq üçün İordan çayını keçəcəyiniz torpağa girib oranı zəbt edəsiniz. ");
INSERT INTO azb_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Rəbbin atalarınıza və onların övladlarına vəd etdiyi südlə bal axan torpaqda uzun ömür sürəsiniz. ");
INSERT INTO azb_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Çünki mülk olaraq almaq üçün girəcəyiniz torpaq çıxmış olduğunuz Misir ölkəsinə bənzəmir. Orada toxumunuzu əkirdiniz, bostan kimi ayağınızla sulayırdınız. ");
INSERT INTO azb_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Amma mülk olaraq almağa gedəcəyiniz torpaq dağlı-dərəli bir diyardır. Bu torpaq göydən yağış suyu içər. ");
INSERT INTO azb_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Ora Allahınız Rəbbin lütf göstərdiyi elə bir torpaqdır ki, ilin əvvəlindən sonuna qədər Allahınız Rəbbin nəzəri altındadır. ");
INSERT INTO azb_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Rəbb deyir: “Əgər bu gün sizə buyurduğum əmrlərə yaxşı qulaq assanız, Allahınız Rəbbi sevib bütün qəlbinizlə, bütün varlığınızla ona sitayiş etsəniz, ");
INSERT INTO azb_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","o zaman Mən torpağınıza yağışı – ilk yağışla son yağışı vaxtlı-vaxtında verəcəyəm. Onda taxılınızı, təzə şərabınızı və zeytun yağınızı yığacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Çöldə heyvanlarınıza ot verəcəyəm. Siz doyunca yeyəcəksiniz”. ");
INSERT INTO azb_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Onda məbada ürəyiniz aldansın, azmayın, başqa allahlara səcdə və sitayiş etməyin. ");
INSERT INTO azb_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Belə etsəniz, Rəbbin sizə qarşı qəzəbi alovlanacaq. O, göyləri bağlayıb yağış yağdırmayacaq, torpağınızı məhsulsuz qoyacaq və tezliklə Rəbbin sizə verdiyi o gözəl torpaqdan yox olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Buna görə də mənim bu sözlərimi ürəyinizdə və ağlınızda saxlayın, qolunuza bir nişan kimi, gözlərinizin arasına alın bağı kimi bağlayın, ");
INSERT INTO azb_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","övladlarınıza öyrədin. Evinizdə oturanda, yol gedəndə, yatanda, duranda bunlar barədə danışın. ");
INSERT INTO azb_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Onları evlərinizin qapı çərçivələrinə və darvazalarına yazın. ");
INSERT INTO azb_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Belə etsəniz, Rəbbin atalarınıza vəd etdiyi torpaqlarda sizin də, övladlarınızın da ömrü uzun olar və göy yer üzərində durduqca orada yaşayarsınız. ");
INSERT INTO azb_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Əməl etməniz üçün sizə buyurduğum bütün bu əmrləri diqqətlə yerinə yetirsəniz, Allahınız Rəbbi sevib Onun yolları ilə getsəniz və yalnız Ona bağlı qalsanız, ");
INSERT INTO azb_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","onda Rəbb qarşınızdan bütün millətləri qovacaq və sizdən daha böyük, daha güclü millətlərin torpaqlarını mülk olaraq alacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Ayaq basdığınız hər yer sizin olacaq. Sərhədiniz səhradan Livana, Fərat çayından Qərb dənizinə qədər uzanacaq. ");
INSERT INTO azb_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Sizin qarşınızda heç kim dayana bilməyəcək. Allahınız Rəbb sizə vəd etdiyi kimi ayaq basacağınız hər yerə vahimə və qorxunuzu yayacaq. ");
INSERT INTO azb_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Budur, bu gün qarşınıza xeyir-dua və lənəti qoyuram. ");
INSERT INTO azb_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Allahınız Rəbbin əmrlərinə, bu gün sizə buyurduğum əmrlərə qulaq assanız, xeyir-dua alacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Əgər Allahınız Rəbbin əmrlərini dinləməsəniz, tanımadığınız başqa allahların ardınca gedərək bu gün sizə buyurduğum yoldan azsanız, lənətə düçar olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Allahınız Rəbb mülk olaraq almaq üçün girəcəyiniz torpağa sizi aparanda Gerizim dağında xeyir-dua, Eval dağında isə lənət oxuyacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Bu iki dağ İordan çayının qarşı tayında, yolun şərqində – Aravada yaşayan Kənanlılar ölkəsində, Qilqal qarşısında, More palıdlarının yanındadır. ");
INSERT INTO azb_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Allahınız Rəbbin sizə verəcəyi torpağı irs olaraq almaq üçün İordan çayını keçmək ərəfəsindəsiniz. Oranı ələ keçirib yerləşəndə ");
INSERT INTO azb_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","bu gün önünüzə qoyacağım bütün qayda və hökmləri yerinə yetirmək üçün diqqətli olun. ");
INSERT INTO azb_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Atalarınızın Allahı Rəbbin mülk olaraq almaq üçün sizə verəcəyi torpaqda ömür boyu bu qaydalara və hökmlərə riayət edin. ");
INSERT INTO azb_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Hansı millətlərin torpaqlarını alacaqsınızsa, allahlarına səcdə etdikləri uca dağlarda, təpələrdə, kölgəli hər ağacın altında olan bütün yerləri mütləq viran qoyun. ");
INSERT INTO azb_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Qurbangahlarını dağıdıb daş sütunları sındırın, ilahə Aşera bütlərini odda yandırıb allah saydıqları oyma bütləri baltalayın və adlarını o yerlərdən silin. ");
INSERT INTO azb_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Allahınız Rəbbə bu cür pərəstiş etməyin. ");
INSERT INTO azb_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Allahınız Rəbbin adını qoymaq üçün bütün qəbilələriniz arasından seçəcəyi yeri, Onun məskənini axtarın və oraya gedin. ");
INSERT INTO azb_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Yandırma qurbanlarınızı, ünsiyyət qurbanlarınızı, qazancınızın onda bir hissəsini, qaldırma təqdimlərinizi, əhd etdiklərinizi, könüllü təqdimlərinizi, mal-qara və qoyun-keçilərinizin ilk balalarını oraya gətirin. ");
INSERT INTO azb_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Orada sizə bərəkət verən Allahınız Rəbbin önündə ailələrinizlə birlikdə yemək yeyəcəksiniz. Onda hansı işə əl atacaqsınızsa, sevinc tapacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Bu gün burada etdiklərinizi orada etməyin. Burada hər kəs öz nəzərində nəyi düz sayırsa, onu da edir. ");
INSERT INTO azb_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Çünki hələ Allahınız Rəbbin sizə verəcəyi rahatlığa və irs torpağa çatmamısınız. ");
INSERT INTO azb_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Amma İordan çayını keçib Allahınız Rəbbin irs olaraq sizə verəcəyi torpaqda məskunlaşacaqsınız. Rəbb sizi ətrafınızdakı bütün düşmənlərdən qurtararaq rahatlıq verəcək və əmin-amanlıq içərisində yaşayacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","O zaman sizə əmr etdiyim hər şeyi – yandırma təqdimlərinizi, ünsiyyət qurbanlarınızı, qazancınızın onda bir hissəsini, qaldırma təqdimlərinizi və Rəbbə həsr etdiyiniz bütün seçmə təqdimlərinizi Allahınız Rəbbin Öz isminə məskən seçəcəyi yerə gətirəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Allahınız Rəbbin qarşısında siz, oğullarınız, qızlarınız, qullarınız, qarabaşlarınız, şəhərlərinizdə yaşayan sizinlə birgə payı və irsi torpağı olmayan Levililər qoy sevinsin. ");
INSERT INTO azb_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Ehtiyatlı olun! Hər gördüyünüz yerdə yandırma qurbanlarınızı təqdim etməyin. ");
INSERT INTO azb_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Yandırma qurbanlarınızı qəbilələrinizin birində Rəbbin seçəcəyi yerdə təqdim edin. Sizə əmr etməkdə olduğum hər şeyi orada edəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Ancaq Allahınız Rəbbin sizə verdiyi bərəkətə görə yaşadığınız şəhərlərdə ürəyiniz istəyən qədər heyvan kəsib ətindən yeyə bilərsiniz. Pak yaxud murdar insan bu əti ceyran və ya maral əti yediyiniz kimi yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Qanını isə yeməyin, su kimi yerə tökün. ");
INSERT INTO azb_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Taxılınızın, təzə şərablarınızın, zeytun yağınızın onda bir hissəsini, mal-qara və qoyun-keçilərinizin ilk balalarını, əhd etdiklərinizin hamısını, könüllü təqdimlərinizi, qaldırma təqdimlərinizi yaşadığınız şəhərlərdə yeməyin. ");
INSERT INTO azb_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Siz, oğullarınız, qızlarınız, qul və qarabaşlarınız, şəhərlərinizdə yaşayan Levililər bunları Allahınız Rəbbin hüzurunda, Onun seçəcəyi yerdə yeyəcəksiniz. Allahınız Rəbbin hüzurunda hansı işə əl atsanız, sevinc tapacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Ehtiyatlı olun! Bu torpaqda yaşadığınız müddətdə Levililərə etinasız yanaşmayın. ");
INSERT INTO azb_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Allahınız Rəbbin sizə vəd etdiyi kimi sərhədinizi genişləndirəndə ət yemək istəyərək “gəlin ət yeyək” desəniz, ürəyiniz istəyən qədər ət yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Allahınız Rəbbin adını qoymaq üçün seçdiyi yer sizdən uzaqdırsa, əmr etdiyim kimi Rəbbin verdiyi naxırlardan, sürülərdən heyvan kəsib öz şəhərlərinizdə ürəyiniz istəyən qədər ət yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Pak yaxud murdar insan bu əti ceyran və ya maral əti kimi yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Lakin ehtiyatlı olun ki, əti qanlı-qanlı yeməyəsiniz, çünki ətə can verən qandır. Ətlə birlikdə canı yeməyin. ");
INSERT INTO azb_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Qanı yeməyin, su kimi yerə tökün. ");
INSERT INTO azb_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Qan yeməyin. Belə etsəniz, Rəbbin gözündə doğru olanı etmiş olarsınız. Onda həm sizin, həm də sizdən sonra gələn övladlarınızın xoş güzəranı olar. ");
INSERT INTO azb_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Müqəddəs təqdimlərinizi, əhd etdiyiniz təqdimləri götürüb Rəbbin seçəcəyi yerə gedin. ");
INSERT INTO azb_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Yandırma qurbanlarınızı, əti və qanı Allahınız Rəbbin qurbangahında təqdim edin. Qurbanlarınızın qanı Allahınız Rəbbin qurbangahında tökülsün. Ətini isə yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Sizə çatdırdığım bütün bu əmrlərə düzgün əməl edin. Allahınız Rəbbin gözündə yaxşı və doğru işlər gördüyünüz üçün sizin və sizdən sonra gələn övladlarınızın həmişə xoş güzəranı olar. ");
INSERT INTO azb_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Allahınız Rəbb torpaqlarını almağa gedəcəyiniz millətləri qarşınızdan yox edəcək. Torpaqlarını irs olaraq alıb orada yaşayanda, ");
INSERT INTO azb_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","onları yox edəndə ehtiyatlı olun ki, onların felinə düşməyəsiniz. “Bu millətlər allahlarına necə sitayiş edirdilərsə, biz də elə edək” deyərək onların allahlarına müraciət etməyin. ");
INSERT INTO azb_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Allahınız Rəbbə bu cür pərəstiş etməyin. Onlar öz allahları üçün Rəbbin nifrət etdiyi iyrənc işləri görürlər. Belə ki oğullarını, qızlarını odda yandıraraq allahlarına qurban verirlər. ");
INSERT INTO azb_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Sizə buyurduğum bütün əmrlərə diqqətlə əməl edin. Onlardan nəyisə əskildib, onlara nəyisə artırmayın. ");
INSERT INTO azb_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Əgər aranızdan bir peyğəmbər yaxud bir röya görən çıxıb sizə bir əlamət ya da möcüzə olacağını söyləyərsə, ");
INSERT INTO azb_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","sonra “tanımadığınız yad allahların ardınca gedək və onlara sitayiş edək” deyərsə, bəhs etdiyi əlamət və ya möcüzə həyata keçsə də, ");
INSERT INTO azb_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","belə peyğəmbərin yaxud röya görənin sözlərinə qulaq asmayın. Bilin ki, Allahınız Rəbb sizi sınayır, görmək istəyir, siz Allahınız Rəbbi bütün qəlbinizlə, bütün varlığınızla sevirsinizmi? ");
INSERT INTO azb_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Siz Allahınız Rəbbin ardınca gedin və Ondan qorxun. Onun əmrlərinə əməl edib sözlərinə qulaq asın, Rəbbə sitayiş edərək Ona bağlı qalın. ");
INSERT INTO azb_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","O peyğəmbər yaxud röya görən isə öldürülsün, çünki sizi Misir ölkəsindən çıxaran və köləlik diyarından qurtaran Allahınız Rəbbə qarşı getməyə sövq edirdi. Onlar sizi Allahınız Rəbbin əmr etdiyi yolla getməkdən azdırmaq istəyirdi. Beləliklə, aranızdan pisliyi atın. ");
INSERT INTO azb_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Hətta bir anadan doğulan qardaşınız, öz oğlunuz və ya qızınız, qoynunuzdakı arvadınız ya da candan əziz dostunuz sizi gizlicə başdan çıxarmaq üçün sizə və atalarınıza naməlum olan allahlardan, ");
INSERT INTO azb_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","ətraf xalqların, dünyanın bu başından o biri başına qədər sizə yaxın və ya uzaq xalqların allahlarından bəhs edib “gedək yad allahlara sitayiş edək” desə, ");
INSERT INTO azb_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ona uyaraq qulaq asmayın. Ona heyfiniz gəlməsin, acımayın, onu qorumayın. ");
INSERT INTO azb_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Mütləq onu öldürün. Əvvəlcə siz, sonra bütün xalq qoy onu daşqalaq etsin. ");
INSERT INTO azb_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Sizi Misir torpağından, köləlik diyarından çıxaran Allahınız Rəbdən ayırmaq üçün çalışdığına görə onu daşqalaq edib öldürün. ");
INSERT INTO azb_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Onda bunun sorağını alan bütün İsraillilər qorxacaq və bir də aranızda buna bənzər pis işlər olmayacaq. ");
INSERT INTO azb_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Allahınız Rəbbin sizə yaşamaq üçün verəcəyi şəhərlərin birində ");
INSERT INTO azb_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","sizin aranızdan yaramaz adamlar çıxıb “tanımadığınız yad allahların ardınca gedək və onlara sitayiş edək” deyərək şəhərlərində yaşayan xalqı azdırdıqlarını eşitsəniz, ");
INSERT INTO azb_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","bunu araşdıraraq yaxşı-yaxşı tədqiq edin. Eşitdikləriniz doğrudursa və aranızdan birisinin belə iyrənc iş gördüyü sübut edilərsə, ");
INSERT INTO azb_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","mütləq o şəhərdə yaşayanları qılıncdan keçirin. Şəhəri tamamilə məhv edib oradakı bütün xalqı və heyvanları qılıncdan keçirin. ");
INSERT INTO azb_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Talan mallarının hamısını toplayıb meydanın ortasına yığın. Şəhəri və malların hamısını Allahınız Rəbb üçün tamamilə yandırın. Qoy bu şəhər əbədi olaraq viranəliyə çevrilsin və yenidən bərpa edilməsin. ");
INSERT INTO azb_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Məhv edilməyə həsr edilən mallardan heç nəyi özünüz üçün götürməyin. Onda Rəbbin qızğın qəzəbi yatar və atalarınıza and edib söz verdiyi kimi sizə rəhm edər və mərhəmət göstərərək sizi çoxaldar. ");
INSERT INTO azb_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Ona görə ki siz Allahınız Rəbbin sözünü dinləyirsiniz. Beləliklə, bu gün sizə buyurduğum əmrlərə əməl edib Rəbbin gözündə doğru olanı etmiş olacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Siz Allahınız Rəbbin övladlarısınız. Ölən üçün bədəninizi yaralamayın və saçınızın ön tərəfini qırxmayın. ");
INSERT INTO azb_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Axı siz Allahınız Rəbbin müqəddəs xalqısınız. Rəbb yer üzərində olan bütün xalqlar arasından sizi Özünə məxsus xalq olaraq seçdi. ");
INSERT INTO azb_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Murdar şeylər yeməyin. ");
INSERT INTO azb_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Bu heyvanların ətini yeyə bilərsiniz: öküz, qoyun, keçi, ");
INSERT INTO azb_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","maral, ceyran, xallı maral, dağ keçisi, geyik, cüyür, dağ qoyunu. ");
INSERT INTO azb_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Heyvanlardan qoşadırnaqlı, gövşəyən heyvanların hamısının ətindən yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Lakin gövşəyən yaxud qoşadırnaqlı olan bu heyvanların – dəvə, dovşan, qayadovşanının ətini yeməyin, çünki onlar gövşəyir, lakin qoşadırnaqlı deyil, buna görə sizin üçün haramdır. ");
INSERT INTO azb_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Donuz isə qoşadırnaqlı olsa da, gövşəmir, o sizin üçün haramdır. Onların nə ətini yeyin, nə də leşinə toxunun. ");
INSERT INTO azb_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Sularda yaşayan heyvanlardan üzgəcləri və pulcuqları olanların hamısını yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Amma üzgəcləri və pulcuqları olmayanların hamısı sizə haram sayılır, yeməyin. ");
INSERT INTO azb_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Bütün pak quşların ətindən yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Lakin bu quşların ətini yeməməlisiniz: qartal, keçələkərkəs, qaraquş, ");
INSERT INTO azb_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","çalağan, şahin, bütün çalağan cinsindən olanlar, ");
INSERT INTO azb_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","bütün qarğa cinsindən olanlar, ");
INSERT INTO azb_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","dəvəquşu, bayquş, qağayı, bütün qırğı cinsindən olanlar, ");
INSERT INTO azb_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","yapalaq, böyük bayquş, ağ bayquş, ");
INSERT INTO azb_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","qutan, leş kərkəsi, qarabatdaq, ");
INSERT INTO azb_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","leylək, bütün vağ cinsindən olanlar, şanapipik, yarasa. ");
INSERT INTO azb_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Bütün qanadlı qaynaşan heyvanlar sizin üçün haramdır, yeməyin. ");
INSERT INTO azb_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Qanadı olan pak heyvanların hamısını yeyə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Ölü halda tapılan heyvan ətindən yeməyin. Şəhərinizdə olan əcnəbiyə verə bilərsiniz ki, yesin yaxud da yadellilərə sata bilərsiniz. Siz isə Allahın müqəddəs xalqısınız. Oğlağı anasının südündə bişirməyin. ");
INSERT INTO azb_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","İlbəil tarlalarınızda bitən bütün məhsulların onda bir hissəsini mütləq ayırın. ");
INSERT INTO azb_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Daim Allahınız Rəbdən qorxmağı öyrənmək üçün taxılınızın, təzə şərabınızın, zeytun yağınızın onda bir hissəsini, mal-qaranızın, qoyun-keçilərinizin ilk balalarını Allahınız Rəbbin qarşısında, Öz isminə məskən seçdiyi yerdə yeyin. ");
INSERT INTO azb_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Allahınız Rəbbin Öz isminə məskən seçdiyi yer sizdən çox uzaqdadırsa, Allahınız Rəbbin sizə bərəkət verdiyi məhsulların onda bir hissəsini siz oraya apara bilməyəcək qədər yol uzundursa, ");
INSERT INTO azb_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","o zaman bunları satıb pula çevirin və bu pulu götürüb Allahınız Rəbbin seçəcəyi yerə gedin. ");
INSERT INTO azb_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Pulu ürəyiniz istəyəni almağa sərf edin: mal-qara, qoyun-keçi, şərab, başqa kefləndirici içki – ürəyiniz nə istəyirsə, alın. Siz və külfətiniz orada Allahınız Rəbbin qarşısında yeyib sevinin. ");
INSERT INTO azb_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Şəhərlərinizdə yaşayan Levililərə etinasız yanaşmayın, çünki onların sizinlə birgə payı və irsi torpağı yoxdur. ");
INSERT INTO azb_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Hər üç ilin sonunda – üçüncü ildə bitən bütün məhsulunuzun onda bir hissəsini çıxarıb şəhərlərinizdə toplayın. ");
INSERT INTO azb_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Sizinlə birgə payı və irsi torpağı olmayan Levililər, şəhərlərinizdə olan qəriblər, yetimlər və dul qadınlar qoy gəlib bundan doyunca yesinlər. Belə edin ki, Allahınız Rəbb sizə əlinizin bütün zəhmətinə xeyir-dua versin. ");
INSERT INTO azb_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Hər yeddi ilin sonunda sizə borclu olanları bağışlayın. ");
INSERT INTO azb_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Borcların bağışlanma işini belə edin: hər alacağı olan şəxs qonşusunun borcunu bağışlasın. Qonşusunu yaxud soydaşını borcunu geri qaytarmağa məcbur etməsin, çünki Rəbb tərəfindən borcların bağışlanma ili elan edilmişdir. ");
INSERT INTO azb_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Yadellilərdən borclarınızı geri ala bilərsiniz, lakin İsrailli soydaşlarınızın borclarını bağışlamalısınız. ");
INSERT INTO azb_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Onda aranızda kasıb olmaz. Əgər Allahınız Rəbbin sizə mülk olaraq almaq üçün verəcəyi torpaqda ");
INSERT INTO azb_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Onun sözünə tam itaət etsəniz, bu gün sizə buyurduğum əmrlərin hamısına diqqətlə əməl etsəniz, ");
INSERT INTO azb_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Allahınız Rəbb sizə vəd verdiyi kimi mütləq bərəkət verəcək. Siz bir çox millətlərə borc verəcək, lakin onlardan borc almayacaqsınız. Siz bir çox millətlərə hökmranlıq edəcəksiniz, onlar sizə hökmranlıq etməyəcək. ");
INSERT INTO azb_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Allahınız Rəbbin sizə verəcəyi torpağın hər hansı bir şəhərində yaşayan soydaşlarınızdan biri kasıbdırsa, daşürəkli olmayın. Kasıb soydaşınıza qarşı əliniz bağlı olmasın. ");
INSERT INTO azb_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Əksinə, əliaçıq olun, nəyə ehtiyacı varsa, ona lazımınca borc verin. ");
INSERT INTO azb_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Məbada “yeddinci il – borcların bağışlanma ili yaxındır” deyərək ürəyinizə pis fikirlər gətirəsiniz. Soydaşınız üçün xəsislik etməyin, ona kömək etməkdən boyun qaçırmayın. Yoxsa kasıb soydaşınız sizdən Rəbbə şikayət edər və günah qazanarsınız. ");
INSERT INTO azb_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Kasıba səxavətlə, könüllü surətdə yardım edin, çünki buna görə Allahınız Rəbb bütün əməyinizə, əl atdığınız hər işə bərəkət verəcək. ");
INSERT INTO azb_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Ölkədə həmişə kasıblar olacaq, buna görə mən sizə belə əmr edirəm: mütləq öz ölkənizdəki kasıb və möhtac soydaşınıza qarşı əliaçıq olun. ");
INSERT INTO azb_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Əgər İbrani soydaşlarınızdan bir kişi və yaxud qadın sizə qul kimi satılıbsa, bu qul altı il sizə qulluq edəndən sonra yeddinci il onu azad edin. ");
INSERT INTO azb_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Azad edərkən onları əliboş yola salmayın. ");
INSERT INTO azb_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Səxavət göstərib sürülərinizdən, taxılınızdan, şərabınızdan onlara verin. Allahınız Rəbb sizə necə bərəkət veribsə, siz də onlara elə verin. ");
INSERT INTO azb_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Misirdə kölə olduğunuzu, Allahınız Rəbbin sizi qurtardığını yada salın. Bu gün ona görə bu əmri verirəm. ");
INSERT INTO azb_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Əgər qulunuz sizi və külfətinizi sevirsə, sizinlə güzəranı xoşdursa və “sizdən ayrılmaq istəmirəm” deyirsə, ");
INSERT INTO azb_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","onda bir biz götürüb qulunuzun qulağından keçirərək qapıya batırın. Bundan sonra o ömrü boyu qulunuz olaraq qalacaq. Qarabaşlarınızla da bu cür rəftar edin. ");
INSERT INTO azb_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Qullarınızı azad etmək sizə çətin gəlməsin. Sizə qulluq etdiyi altı il ərzində muzdlu işçidən ikiqat artıq iş görmüşdür. Sizə Allahınız Rəbb hər işdə bərəkət verəcək. ");
INSERT INTO azb_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Mal-qara və qoyun-keçilərinizin ilk doğulan balalarından hər erkək heyvanı Allahınız Rəbb üçün təqdis edin. Öküzlərinizin ilk balalarını işlətməyin, qoyun-keçilərinizin ilk balalarını qırxmayın. ");
INSERT INTO azb_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Siz ailələrinizlə birgə hər il Allahınız Rəbbin önündə, Onun seçəcəyi yerdə bu heyvanların ətini yeyin. ");
INSERT INTO azb_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Bir heyvanın qüsuru varsa, axsaq yaxud kordursa, hansısa ciddi çatışmazlığı varsa, onu Allahınız Rəbbə qurban etməyin. ");
INSERT INTO azb_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Belə heyvanları kəsib şəhərlərinizdə yeyə bilərsiniz. Pak və yaxud murdar insan bu ətdən ceyran və ya maral əti yediyi kimi yeyə bilər. ");
INSERT INTO azb_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Qanını isə yeməyin, onu su kimi torpağa tökün. ");
INSERT INTO azb_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Aviv ayını qeyd edin və Allahınız Rəbbin Pasxa bayramını keçirin. Allahınız Rəbb sizi Misirdən Aviv ayında gecə ikən çıxartdı. ");
INSERT INTO azb_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Allahınız Rəbbin Öz isminə məskən seçəcəyi yerdə qoyun-keçilərinizdən, mal-qaranızdan Pasxa qurbanı kəsin. ");
INSERT INTO azb_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Qurban əti ilə birlikdə mayalı çörək yeməyin. Misirdən tələsik çıxdığınıza görə əziyyət içərisində yediyiniz çörək kimi yeddi gün mayasız çörək, yəni əziyyət çörəyi yeyin. Bununla ömür boyu Misirdən çıxdığınız günü yada salın. ");
INSERT INTO azb_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Ölkənizin heç bir yerində yeddi gün mayadan istifadə olunmasın. İlk gün axşam qurban kəsdiyiniz heyvanların əti səhərə qədər qalmasın. ");
INSERT INTO azb_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Pasxa qurbanlarını Allahınız Rəbbin sizə verəcəyi şəhərlərin heç birində kəsməyin, ");
INSERT INTO azb_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","ancaq Allahınız Rəbbin Öz isminə məskən seçəcəyi yerdə kəsin. Orada qurbanları axşam, gün batanda, Misirdən çıxdığınız saatlarda kəsin. ");
INSERT INTO azb_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Əti Allahınız Rəbbin seçəcəyi yerdə bişirib yeyin. Səhər açılanda isə oradan çıxıb çadırlarınıza qayıdın. ");
INSERT INTO azb_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Altı gün mayasız çörək yeyin. Yeddinci gün Allahınız Rəbb üçün təntənəli toplantı keçirin və heç bir iş görməyin. ");
INSERT INTO azb_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Əkinə oraq vurduğunuz ilk gündən yeddi həftə sayın və ");
INSERT INTO azb_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Allahınız Rəbbin sizə verdiyi bərəkətə görə könüllü təqdim verməklə Allahınız Rəbb üçün Həftələr bayramı keçirin. ");
INSERT INTO azb_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Allahınız Rəbbin qarşısında – Onun Öz isminə məskən seçəcəyi yerdə siz, oğullarınız, qızlarınız, qullarınız, qarabaşlarınız, şəhərlərinizdə yaşayan Levililər, aranızda yaşayan qəriblər, yetimlər və dul qadınlar birlikdə sevinəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Misirdə kölə olduğunuzu yada salın və bu qaydalara diqqətlə əməl edin. ");
INSERT INTO azb_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Xırmanınızdan, üzümsıxanınızdan məhsul götürəndən sonra özünüz üçün yeddi gün Çardaqlar bayramı keçirin. ");
INSERT INTO azb_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Bu bayramda siz, oğullarınız, qızlarınız, qullarınız, qarabaşlarınız, şəhərlərinizdə yaşayan Levililər, qəriblər, yetimlər və dul qadınlarla birlikdə sevinəcəksiniz. ");
INSERT INTO azb_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Allahınız Rəbbin seçəcəyi yerdə Rəbb üçün yeddi gün bu bayramı keçirin, çünki Allahınız Rəbb bütün məhsullarınıza, əllərinizin hər işinə xeyir-dua verib və siz tam sevinc içində yaşayacaqsınız. ");
INSERT INTO azb_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Bütün kişiləriniz ildə üç dəfə Mayasız Çörək bayramında, Həftələr bayramında, Çardaqlar bayramında Allahınız Rəbbin hüzurunda olmaq üçün Onun seçəcəyi yerə getsin. Heç kəs Rəbbin hüzuruna əliboş gəlməsin. ");
INSERT INTO azb_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Hər biriniz Allahınız Rəbbin sizə verdiyi bərəkətə görə bəxşiş götürməlisiniz. ");
INSERT INTO azb_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Allahınız Rəbbin sizə verəcəyi şəhərlərdə hər qəbiləniz üçün hakimlər və məmurlar seçin. Qoy onlar xalqa ədalətlə hakimlik etsinlər. ");
INSERT INTO azb_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Hökm çıxararkən haqsızlıq etməyin, heç kimin tərəfini saxlamayın. Rüşvət almayın, çünki rüşvət müdrik insanın belə, gözlərini kor edir və məhkəmədə məsum bir insana qarşı səhv qərara yol verir. ");
INSERT INTO azb_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Salehliyin, yalnız salehliyin ardınca gedin, onda həyat taparsınız və Allahınız Rəbbin sizə verəcəyi torpağı irs olaraq alarsınız. ");
INSERT INTO azb_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Allahınız Rəbb üçün quracağınız qurbangahın yanına ilahə Aşeranın surətində heç bir ağac sütunu qoymayın. ");
INSERT INTO azb_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Allahınız Rəbbin ikrah etdiyi daş sütun qoymayın. ");
INSERT INTO azb_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Hər hansı bir qüsuru və çatışmazlığı olan öküzü ya da qoyunu Allahınız Rəbbə qurban etməyin. Belə etmək Allahınız Rəbb üçün iyrəncdir. ");
INSERT INTO azb_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Allahınız Rəbbin sizə verəcəyi şəhərlərin birində aranızdan Onun əhdini pozub gözündə pis olanı edən hər hansı bir kişi və ya qadın çıxarsa, ");
INSERT INTO azb_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","əmrlərimin ziddinə gedib başqa allahlara sitayiş edərsə, bütlərə yaxud günəşə, aya yaxud səma cisimlərindən hər hansı birinə sitayiş və səcdə edərsə, ");
INSERT INTO azb_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","bu hadisədən xəbərdar olsanız, eşitdiklərinizi yaxşı-yaxşı araşdırın. Əgər bu xəbər doğrudursa və belə iyrənc halın İsraildə baş verdiyi sübuta yetərsə, ");
INSERT INTO azb_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","belə pis hərəkət edən kişini və ya qadını şəhərin darvazasına gətirib daşqalaq edərək öldürün. ");
INSERT INTO azb_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Ölümə məhkum olan adam iki yaxud üç nəfərin şahidliyi ilə öldürülməlidir. Tək bir nəfərin şahidliyi ilə öldürülməsin. ");
INSERT INTO azb_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","O adamı əvvəlcə şahidlər, sonra isə bütün xalq daşqalaq etsin. Beləliklə, aranızdan pisliyi atın. ");
INSERT INTO azb_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Əgər şəhərlərinizdə qatillik, dava və ya təcavüz barəsində qərar çıxarmaqda həll edə bilmədiyiniz çətinliklərə rast gəlsəniz, Allahınız Rəbbin seçəcəyi yerə gedin. ");
INSERT INTO azb_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","O dövrdə xidmət edən Levili kahinlərin və hakimlərin yanına gedib onlara müraciət edin. Qoy onlar araşdırıb məhkəmə qərarını sizə versinlər. ");
INSERT INTO azb_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Rəbbin seçəcəyi yerdən sizə deyilən qərara əməl edin. Sizə nə öyrətsələr, ona diqqətlə əməl edin. ");
INSERT INTO azb_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Öyrədilən təlimata və söylənilən hökmə görə rəftar edin. Əmr edilənlərdən nə sağa, nə də sola dönün. ");
INSERT INTO azb_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Orada Allahınız Rəbbin hüzurunda vəzifəsini icra edən kahinə yaxud hakimə qulaq asmamaq iddiasında olan şəxs öldürülsün. Beləliklə, aranızdan pisliyi atın. ");
INSERT INTO azb_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Bütün xalq bu xəbəri eşidib qorxacaq və bir daha bu iddiaya düşməyəcək. ");
INSERT INTO azb_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Allahınız Rəbbin sizə verəcəyi torpağa girib, oranı irs olaraq alanda və orada məskunlaşanda əgər “bütün ətraf ölkələrdəki kimi bizə hökm edəcək bir padşah təyin edək” desəniz, ");
INSERT INTO azb_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","mütləq Allahınız Rəbbin seçəcəyi adamı padşah qoyun. Padşah təyin etdiyiniz adam öz soydaşlarınızdan olmalıdır. İsrailli soydaşlarınızdan olmayan yadelli bir adamı padşah edə bilməzsiniz. ");
INSERT INTO azb_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Qoy padşah özü üçün at çoxaltmasın. İlxısını artırmaq üçün xalqı Misirə – geriyə qaytarmasın, çünki Rəbb sizə belə demişdi: “Bir də bu yoldan geri qayıtmayın”. ");
INSERT INTO azb_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Padşah çox arvad almasın, yoxsa ürəyi haqq yolundan dönər. O özü üçün çoxlu qızıl-gümüş yığıb onu çoxaltmasın. ");
INSERT INTO azb_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Padşah taxta çıxandan sonra Levili kahinlərin nəzarəti altında bu Qanundan bir surətini özü üçün kitaba köçürsün. ");
INSERT INTO azb_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Qoy o, Qanunun bu surətini yanında saxlayaraq ömrü boyu hər gün oxusun. Bununla da padşah Allahınız Rəbdən qorxmağı, bu Qanunun bütün sözlərinə və bu qaydalara diqqətlə əməl etməyi öyrənsin. ");
INSERT INTO azb_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Özünü soydaşlarından üstün tutmasın, əmrdən nə sağa, nə də sola dönsün. Onda İsraildə özünün və nəslinin padşahlıq dövrü uzun olar. ");
INSERT INTO azb_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Levili kahinlərin, bütün Levi qəbiləsinin digər İsraillilərlə birgə payı və irsi olmayacaq. Onlar Rəbbə verilən yandırma təqdimləri ilə doyacaqlar və bu onların irsi olacaq. ");
INSERT INTO azb_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Levililərin soydaşları arasında irsi torpaqları olmayacaq və Rəbbin onlara söz verdiyi kimi onların irsi Rəbb Özüdür. ");
INSERT INTO azb_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Xalq arasında öküz və qoyun qurbanı təqdim edən qol, çənə və içalatı kahinlərə pay versin. ");
INSERT INTO azb_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Taxılınızın, təzə şərabınızın, zeytun yağınızın nübarını və qoyunlarınızdan qırxdığınız ilk yunu kahinlərə verin. ");
INSERT INTO azb_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Allahınız Rəbb onları və övladlarını bütün qəbilələriniz arasından seçdi ki, daim Rəbbin adına xidmətdə dayansınlar. ");
INSERT INTO azb_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Əgər bir Levili yaşadığı İsrail şəhərlərinin birindən könüllü surətdə Rəbbin seçəcəyi yerə gedərsə, ");
INSERT INTO azb_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","orada Allahı Rəbbin qarşısında dayanan Levili soydaşları kimi Rəbbin naminə xidmət edə bilsin. ");
INSERT INTO azb_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","O, ata mülkünün satışından əldə etdiyi vəsaitdən əlavə, onlarla bərabər paydan da istifadə edə bilər. ");
INSERT INTO azb_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Allahınız Rəbbin sizə verəcəyi torpağa girdiyiniz zaman o millətlərin iyrənc adətlərini götürüb təqlid etməyin. ");
INSERT INTO azb_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Aranızda oğul və qızını oda qurban verən, falçı, gələcəyideyən, baxıcı, cadugər, ");
INSERT INTO azb_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ovsunçu, cindarlara və ruhçağıranlara müraciət edən yaxud ölüləriçağıran olmasın. ");
INSERT INTO azb_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Rəbb belə iş görənlərə nifrət edir. Elə bu iyrənc işlərə görə Allahınız Rəbb millətləri sizin qarşınızdan qovacaq. ");
INSERT INTO azb_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Allahınız Rəbbin gözü önündə kamil olun. ");
INSERT INTO azb_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Çünki torpaqlarını alacağınız millətlərin hamısı gələcəyideyənlərin və falçıların nəsihətlərinə qulaq asırlar. Amma Allahınız Rəbb sizin üçün buna izin vermir. ");
INSERT INTO azb_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Allahınız Rəbb sizin üçün aranızdan – öz soydaşlarınız içərisindən mənim kimi bir peyğəmbər yetirəcək. Ona qulaq asın. ");
INSERT INTO azb_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Çünki Xorevdə yığıldığınız gün Allahınız Rəbdən bunu diləmişdiniz: “Qoy bir də Allahımız Rəbbin səsini eşitməyək və bir daha bu böyük alovu görməyək, yoxsa ölərik”. ");
INSERT INTO azb_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Onda Rəbb mənə dedi: “Dedikləri doğrudur. ");
INSERT INTO azb_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Onlar üçün soydaşları arasından sənin kimi bir peyğəmbər yetirəcəyəm və sözlərimi onun dilindən eşidəcəksiniz. O əmr etdiyim hər şeyi sizə söyləyəcək. ");
INSERT INTO azb_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Mənim adımla söylədiyi sözlərə qulaq asmayan adamı ittiham edəcəyəm. ");
INSERT INTO azb_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Lakin hansı bir peyğəmbər ona əmr etmədiyim sözü Mənim adımdan danışmağa cürət edərsə yaxud başqa allahların adından danışarsa, o peyğəmbər öldürülsün”. ");
INSERT INTO azb_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","“Axı bu sözün Rəbdən olub-olmadığını necə bilək?” deyə düşünə bilərsiniz. ");
INSERT INTO azb_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Əgər bir peyğəmbər Rəbbin adından danışanda dediyi söz həyata keçməzsə yaxud düz çıxmazsa, bilin ki, onu Rəbb söyləməmişdir. O peyğəmbərin dediklərinin səlahiyyəti yoxdur. Ondan qorxmayın. ");
INSERT INTO azb_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","Allahınız Rəbb torpaqlarını sizə verəcəyi millətləri yox edəndə və siz onların mülkünü alıb şəhərlərində və evlərində yaşayanda ");
INSERT INTO azb_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","Allahınız Rəbbin mülk olaraq almaq üçün sizə verəcəyi torpağın mərkəzində özünüz üçün üç şəhər ayırın. ");
INSERT INTO azb_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","Bu şəhərlərə getmək üçün yollar çəkib Allahınız Rəbbin irs olaraq sizə verəcəyi ölkəni üç bölgəyə ayırın. Belə ki qətl edən bu şəhərlərdən birinə qaçsın. ");
INSERT INTO azb_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","Sağ qalmaq üçün oraya qaçan qatil haqqında – yəni qonşusu ilə əvvəlcədən ədavəti olmadan və bilmədən onu öldürən adam barədə belə bir qaydanız olsun. ");
INSERT INTO azb_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","Məsələn, odun kəsmək üçün qonşusu ilə meşəyə gedib ağac doğramaq üçün balta vuranda baltanın dəmiri sapından çıxıb qonşusuna dəyərsə və qonşusu ölərsə, ölümə bais adam bu şəhərlərdən birinə qaçıb canını qurtarsın. ");
INSERT INTO azb_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","Yoxsa qan qisasını alan qəzəblə qatilin izinə düşə bilər. Yol uzaq olarsa, çatıb onu öldürə bilər. Bu adamın öldürdüyü adamla əvvəllər heç bir ədavəti olmamışdı. Ona görə də ölüm hökmünə layiq deyil. ");
INSERT INTO azb_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Bunun üçün “özünüzə üç şəhər seçin” deyə əmr edirəm. ");
INSERT INTO azb_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","Allahınız Rəbbi sevmək və daim Onun yolları ilə getmək üçün bu gün sizə buyurduğum bütün bu əmrlərə diqqətlə əməl etdiyiniz üçün ");
INSERT INTO azb_vpl VALUES ("DT19_9","006_19_9","