﻿USE sofia;
DROP TABLE IF EXISTS sofia.ayz_vpl;
CREATE TABLE ayz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ayz_vpl WRITE;
INSERT INTO ayz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus Kristus hohos na to mfi fefo: Yesus Kristus tait ybam raa mana ro Daud, tna Daud ybam raa mana ro Abraham. ");
INSERT INTO ayz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Masmair rau to Abraham yabe Ishak, tna Ishak yabe Yakub, tna Yakub yabe Yehuda ysya yao na. ");
INSERT INTO ayz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tna Yehuda yasen yabe Peres ysya Zerah mbam fai Tamar. Tna Peres yabe Hezron. ");
INSERT INTO ayz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Tna Hezron yasen yabe Ram, tna Ram yabe Aminadab, tna Aminadab yabe Nahason, tna Nahason yabe Salmon. ");
INSERT INTO ayz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Tna Salmon yabe Boas ybam fai Rahab, tna Boas yabe Obed ybam fai Rut. Tna Obed yabe Isai. ");
INSERT INTO ayz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tna Isai yabe raja Daud, tna Daud yoo Uria yfain tna yabe Salomo. ");
INSERT INTO ayz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tna Salomo yabe Rehabeam, tna Rehabeam yabe Abia, tna Abia yabe Asa. ");
INSERT INTO ayz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Tna Asa yabe Yosafat, tna Yosafat yabe Yoram, tna Yoram yabe Uzia. ");
INSERT INTO ayz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Tna Uzia yabe Yotam, tna Yotam yabe Ahas, tna Ahas yabe Hizkia. ");
INSERT INTO ayz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Tna Hizkia yabe Manasye, tna Manasye yabe Amon, tna Amon yabe Yosia. ");
INSERT INTO ayz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tna wore wo raa mfot raa ro Yahudi makah mamoʼt Babel to, Yosia yabe Yekhonya ysya yao na. ");
INSERT INTO ayz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Raa ro Yahudi mamoʼt oo ro Babel to, Yekhonya yabe Sealtiel, tna Sealtiel yabe Zerubabel. ");
INSERT INTO ayz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tna Zerubabel yabe Abihud, tna Abihud yabe Elyakim, tna Elyakim yabe Azor. ");
INSERT INTO ayz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Tna Azor yabe Zadok, tna Zadok yabe Akhim, tna Akhim yabe Eliud. ");
INSERT INTO ayz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Tna Eliud yabe Eleazar, tna Eleazar yabe Matan, tna Matan yabe Yakub. ");
INSERT INTO ayz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tna Yakub yabe Yusuf ro yoo fai Maria, tna au mabe Yesus ro raa mtu Kristus tait. ");
INSERT INTO ayz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Maban Abraham raa mabe mamo snok Daud raa mabe to, biin beta trion 14 firwas wa. Tna maban Daud raa mabe mamo snok raa ro Yahudi raa mfot tna makah mamoʼt oo ro Babel to, biin trion 14 firwas ye. Tna maban tahun reto snok mam Kristus raa fnya mabe to biin 14 firwas wa ye. ");
INSERT INTO ayz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Masmair rau ro Yesus Kristus fai Maria mabe to fefo: Maria msya Yusuf mbewok mkir anya sai fares, menohe Maria mrok mhaf. Maria mhaf reto to, mbam Har ro Tuhan. Maria msya Yusuf mbewok mjin su fefares. ");
INSERT INTO ayz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tna Yusuf ynaut bait mam srau mato yawe yitsre Maria makus. Yusuf fi ait raa ro ja yno bo ro moof, tna ait ynaut yawe yno Maria masom mkair ma. ");
INSERT INTO ayz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yusuf ynaut bo reto kri-kri to, tna ait yjin smi. Ait smi ymat malaikatTuhan sau mbrah nenat kʼait tna mawe, “Yusuf, ku ro Daud yare: Waa ma. Noo Maria mamo nfain. Ku ro yhau kʼau mhaf retait tait ybam Har ro Tuhan meto. ");
INSERT INTO ayz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Meen Maria mabe Ku ro sme sait. Nafan Ku retait yasom Yesus. Ait oh mi meen yoo riof ro mase yee kʼraa wAit. Tna re Allah yyon iro wana to.” ");
INSERT INTO ayz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tuhan yno bo weto beta mamo mnan si bo ro tiwya ykyas kʼanu raa wia. Tiwya ybis nabi rAit sait yama ykyas bo weto matim. Ait yawe, ");
INSERT INTO ayz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ku sau ro ja mjin msya raa su fefares to, kbe mhaf tna mabe Ku sme sait. Tna kbe raa mtu Ku retait yasom Imanuel.” Yesaya 7:14 Imanuel mam mai ranu to 'Allah yatam anu'. ");
INSERT INTO ayz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf yrok yasen. Tna yno bo ro malaikatTuhan riwai mawe kʼait: Ait yoo Maria mamo yfain. ");
INSERT INTO ayz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Menohe Yusuf yjin su ysya au fee mamo snok mam ati ro au mabe Ku sme retait. Tna Yusuf yafan Ku retait ytu yasom Yesus. ");
INSERT INTO ayz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus fnya mabe mam remo ro Betlehem. Mam ti weto to Herodes yamo raja mam provinsi ro Yudea reto. Tna raa majus mama. Ana weto raa ro ja mhar bo. Ana mbam ati ro ayõ maut mama snok mam kota ro Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ana mtu sas mawe, “Fnya mabe Ku sait ro meen yamo Raja raa mana ro Yahudi. Ait yhau mam woyõ? Amu nmat sken rAit snok mam ati ro ayõ maut. Tna amu nwe nma nbaut Ait fo.” ");
INSERT INTO ayz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Raa ro Yerusalem mari feto tna mrok ktak sai. Tna fo raja Herodes yari feto tna yrok ktak ye. ");
INSERT INTO ayz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ait ytu raa manes ro Yahudi mama siret beta: Ait ytu imam manes wana msya guru agama wana beta mama mo kʼait. Ana beta mama. Tna Herodes ytu sas kʼana yawe, “Mesias, ro Allah ysok re kbe yoo riof ro mase yee kʼraa tait, kbe fnya mabe mam wore woyõ?” ");
INSERT INTO ayz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tna ana mawe, “Bokom ro Allah mkyas mawe kbe fnya mabe Ait mam remo ro Betlehem, provinsi ro Yudea. Reto mamyot bokom ro nabi ranu sait tiwya ykom: ");
INSERT INTO ayz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Remo ro Betlehem mam provinsi ro Yehuda to remo ro maku sau. Remo roto taro to maku ye. Menohe remo ro Betlehem to remo ro ati: Kbe mamo remo ro masom. Meen Raa sait fnya mabe mam Betlehem. Tna Ait yamo aban mana ro yase ybo raa ro Allah wAit. Meen Ait kmot raa ro Israel.’” ");
INSERT INTO ayz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Raa manes weto siret mkak. Tna fo Herodes yamo wai ytu raa majus weto mama mo kʼait. Tna ait ytu sas kʼana yawe, “Tija oh mi anu nmat sken reto frok to?” ");
INSERT INTO ayz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tna fo Herodes ybis ana yawe, “Nsen nmoʼt Betlehem. Nmo ntu sas bo ro Ku retait kaket. Tna soh nkai Ait to, hah ne nma nwe kʼjõ iti afo re jõ tamo tna tbaut Ait ye.” ");
INSERT INTO ayz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ana mari bo ro raja Herodes yawe kʼana tna masen mamo. Ana mamo tna mmat sken ro tiwya ana mmat mam ati ro ayõ maut. Sken reto mamo matim, tna ana kro mamo tis. Sken reto mamo mamo snok mam uu abyõ wore ro akut retait yhau. ");
INSERT INTO ayz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ati ro ana mmat sken reto to, ana simaut mase. ");
INSERT INTO ayz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ana mamoʼt amah reto tna twok mam mato. Ana mmat ku retait ysya yme Maria, tna ana maka mbaut Ait. Tna ana trah surah wiak wana beta tna moo bofan wana mafan Ku retait. Bo ro ana mafan to emas,kemenyan msya mur. ");
INSERT INTO ayz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tna Allah yinyam bo kʼana mkah bosmi yawe, “Hah ne nmo no kʼraja Herodes ma!” Tna ana mari feto tibyo hah me mamo iso roto mamo bana. ");
INSERT INTO ayz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Raa ro majus weto hah me mamo oh. Tna Yusuf yjin smi. Ait smi ymat malaikat ro Tuhan sau mawe, “Nasen fooh! Tubat Ku retait nsam nsya yme nmoʼt negri ro Mesir. Raja Herodes srau kair yawe yama saso ku retait yame. Namoʼt Mesir tna ste wea. Nhau mam beto mamo snok mam wore wo Jõ tbis anu nhah ne nma.” ");
INSERT INTO ayz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tibyo mti reto to, Yusuf yasen fooh, teta ku retait tna ysya yme msam mamoʼt Mesir. ");
INSERT INTO ayz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ana mamoʼt Mesir to, mhau mam beto mamo snok mam ti ro Herodes yhai. Ana mhar mawe Herodes yhai, tna ana hah me mamoʼt tabam rana. Ana mbam Mesir hah mama mnan si bo ro tiwya Tuhan ybis nabi rAit sait ykyas wia yawe, “Jõ ttu Ku aJõ yama ybam Mesir.” ");
INSERT INTO ayz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ati ro Herodes yhar he raa majus weto sioh ait to, ait kmo toni. Tna ait ybis raa wait mamo mame ku mkek ro sme. Ybis ana mame ku sme ro mhau mam Betlehem msya remo ro mhau kait mam beto sor to, majat beta. Ait ynaut yawe tiwya raa majus mama saso ku mkek sait ro umur tahun ewok mamo ti te fares. Feto Herodes ybis raa mame ku sme weto beta. ");
INSERT INTO ayz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bo reto mnan si bo ro tiwya Allah ybis nabi Yeremia ykyas wia yawe, ");
INSERT INTO ayz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ku mkek mam rabin ro Rama to marak beta. Tibyo fnya ro mhau mam beto sraujin tna mawia. Rahel mawia ku mkek wau. Tna au hawe raa mama mkyas bokyas moof msya au afo re kbe au sorni sraujin rau reto.” ");
INSERT INTO ayz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yusuf ysya Maria mhau mam negri Mesir fares tna raja Herodes yhai. Ti sau Yusuf yjin smi ymat malaikat ro Tuhan sau mama mawe kʼait mawe, ");
INSERT INTO ayz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Nasen oh! Tubat Ku retait tna ysya yme hah ne nmoʼt negri ro Israel. Tiwya Herodes yawe yame Ku retait. Menohe Herodes yhai oh.” ");
INSERT INTO ayz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusuf yrok yasen tubat Ku retait tna ysya yme hah me mamoʼt Israel. ");
INSERT INTO ayz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tna Yusuf yari he Arkhelaus yamo raja mam provinsi ro Yudea shauk yuk ro yaja Herodes. Feto tibyo Yusuf waa yamoʼt Yudea fee. Menohe Tuhan yerif bo kʼait mkah bosmi, tna ybis ait yamoʼt provinsi ro Galilea. ");
INSERT INTO ayz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ait yamo yhau mam remo ro Nasaret. Yhau mam Nasaret to, mnan si bo ro tiwya Allah ybis nabi wAit mama mkyas wia mawe, “Ait tait, kbe raa mtu mawe, ‘Ait raa ro Nasaret’ to.” ");
INSERT INTO ayz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yohanes ro ja baptis raa tait yamo ykyas bo ro Allah. Yamo yhau mam tabam ro riamo sau mam provinsi ro Yudea. Ait ykyas yawe, ");
INSERT INTO ayz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nashana fooh! Allah siwyan yamo Raja ytu raa wAit mama ybo fo.” ");
INSERT INTO ayz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanes oh mi tiwya nabi Yesaya ykyas wia yawe, “Meen raa sait kbe yama ykyas bo woJõ mam yuk ro riamo sau. Ykyas yawe, ‘Mbetrot iso mkah Tuhan yama! Nisoh iso kʼAit!’” ");
INSERT INTO ayz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes yyum ratan ro ja raa sne mbam unta mawyan. Tna ykyar hotom ro mbam kak marak ye. Ja ait yabo mo msya yata kum maya ro mbam safom sai. ");
INSERT INTO ayz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tna raa mbam kota ro Yerusalem, raa mbam remo makin mam provinsi ro Yudea reto ye, msya raa makin ro mhau mam aya maam ro Yordan to, ana weto sor mama mo kʼYohanes. ");
INSERT INTO ayz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ana mama mo kʼAit tna mras iro wana. Tibyo Yohanes baptis ana mam aya ro Yordan reto. ");
INSERT INTO ayz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Raa ro Farisi msya raa ro Saduki mawat mama mo kʼYohanes ye. Ana mawe ait baptis ana ye. Menohe ait yastako ana yawe, “Anu to, raa ro nmo wan-wan nfi aban kume! Awya ykyas bo kʼanu yawe Allah kmo tna meen yno bo ro mkair mbtek mai kʼanu? Awya ykyas feto tna re anu nhar nwe nsam nma saso riof kʼanu? ");
INSERT INTO ayz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nashana! Nno bo moof. Tna kbe raa mhar mawe anu nashana oh. ");
INSERT INTO ayz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","10","Soh anu nno feto to, anu nfi kake mara ro mros make mawat tna moof. Allah yatem ybo baam oh. Ait siwyan yfat ara. Kake mara ro make rau mkair to, kbe Ait yfat tna yoo beak mam tafoh makus mait. Anu ja nnaut nwe, ‘Amu fo kube ro Abraham wait renti. Feto to kbe Allah yno riof kʼamu fea!’ Menohe mfe; nnaut feto ma! Allah yatak haberek fraa wefo mamo kube renti ro Abraham wait ye! ");
INSERT INTO ayz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jõ baptis anu mkah aya sai. ⌞Reto mawe anu nashana oh.⌟ Jõ tama wia tatim. Tna Ait ro yase yiwer jõ sait kbe yama yrof jõ. Jõ fi raa ro taku sai. Kbe tbo sandal ro yse yaa rAit to fee. Jõ toof mnan si fee. Ait yama to, meen baptis anu mkah Har ro Tuhan. Tna Ait baptis anu mkah tafoh ye.” ");
INSERT INTO ayz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tna Yohanes yawe, “Ati ro raa sait ygi gandum rait to, ja ait yoo gandum makan rau yse hayah tna yoo marak rau to yse hayah ye. Tna gandum makan reto ybu mam gudang sau. Tna marak rau to, kbe yko mam tafoh. Tafoh reto raa mtai mikabuk fee. Mesias tait siwyan re kbe yno bo mfi feto kʼraa ye.” ");
INSERT INTO ayz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yohanes yhau mam aya Yordan fares to, Yesus ybam provinsi ro Galilea yama. Yesus yama yawe Yohanes baptis Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Menohe Yohanes yawe kʼYesus yawe, “Jõ hawe baptis Nyõ. Nyõ raa ro nase. Jõ fi raa kinyah sai. Maami Nyõ baptis jõ menohe Nyõ nawe jõ te baptis Nyõ fyi?” ");
INSERT INTO ayz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Menohe Yesus yawe, “Nnaut bo myum-yam ma. Nama sai baptis Jõ. Anu bno bo wefo mamo mnan si bo ro Allah ksoh beta oh meto.” Yohanes yari feto, tibyo baptis Yesus. ");
INSERT INTO ayz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yohanes baptis Yesus, tna Yesus frok ybam aya yaut. Frok si fo, ayoh twat. Tna Yesus ymat Har ro Tuhan haberek mnan fi ruu merpati sau. Ruu reto fru mama mroh abyõ kʼAit. ");
INSERT INTO ayz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tna raa mari mai sau mbam ayoh mawe, “Ait tait akut aJõ ro Jõ thafri. Ait tait, Jõ thaf mnan!” ");
INSERT INTO ayz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tna Har ro Tuhan yakah Yesus yamoʼt yuk ro riamo sau. Yamo re kbe kabes yabi (Iblis) yama sanet Ait. ");
INSERT INTO ayz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tna Yesus yhau bo yait ti trion 40 msya ayõ trion 40 ye. Tibyo yhai sre. ");
INSERT INTO ayz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tna kabes yabi ro ja sanet raa to yama sanet Ait yawe, “Soh Nyõ Ku ro Allah yare meto mi, sik nno fraa wefo haberek mamo roti re Nyõ nait.” ");
INSERT INTO ayz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Menohe Yesus yisboh kʼAit yawe, “Bokom ro Allah mawe, ‘Raa taro mhau to, mnaut boit ro mait sai yoyo. Menohe ro moof to, raa mhau mnaut Watum ro Allah yoyo tna mbo mno.’” ");
INSERT INTO ayz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tna fo kabes yabi yakah Yesus yamoʼt kota Yerusalem. (Ja raa mawe kota reto to, kota ro Allah rAit.) Ana mamoʼt Samu ro Allah tna kabes yabe yse Yesus yros abyõ mam timanaf rau, ro miyõ toni. ");
INSERT INTO ayz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tna yawe kʼYesus yawe, “Soh Nyõ fi Ku ro Allah yare meto mi, sik nitsre Nyõ mbtek namo nai mam tabam mte. Bokom ro Allah mawe, ‘Kbe Allah ybis malaikat wAit swiõ wea huwya mfot Nyõ abyõ sai. Ana kbe mfot Nyõ abyõ sai mkah matem wana re naa mai mam fraa fee.’” ");
INSERT INTO ayz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Menohe Yesus yawe, “Bokom ro Allah mawe ye mawe, ‘Tuhan Allah ro ja anu smot to, sanet Ait ma.’ Ulangan 6:16 Feto ye Jõ hawe kro bo ro nyõ nawe weto be kbe Jõ sanet Allah.” ");
INSERT INTO ayz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tna fo kabes yabi yakah Yesus yaut atu mana ro miyõ wer. Tna yerif bangsa ro arin aso beta fo kʼAit. Tna yerif bo mase ro bangsa weto kʼAit ymat ye. ");
INSERT INTO ayz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tna yawe, “Soh Nyõ naka mte nbaut jõ to, kbe too bo wefo beta tsan kʼNyõ.” ");
INSERT INTO ayz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Menohe Yesus yisboh kabes yabi yawe, “Bo ro nyõ nawe reto to, Jõ hawe bo tno ye. Nasen namo! Bokom ro Allah mawe yum mawe: ‘Nbaut Tuhan Allah yesait aran, tna bo ro Ait yesait aran yawe to, nbo nno.’” ");
INSERT INTO ayz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tna kabes yabi yasen sikba Yesus akus yamo. Tna fo malaikat baro mama matam Ait. ");
INSERT INTO ayz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yohanes, raa mfot mamo mbu mam bui oh. Yesus yari feto, tibyo hah yamoʼt provinsi ro Galilea. ");
INSERT INTO ayz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ait sikba remo ro Nasaret tna yamo yhau mam remo ro Kapernaum. Kapernaum mhau mam aya maam ro Galilea. Tiwya tinyi rabin reto tabam ro Zebulon ysya Naftali rana. ");
INSERT INTO ayz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus yhau mam rabin reto to, afo re yno mnan si bokyas ro tiwya Allah ybis nabi Yesaya yama ykyas wia yawe, ");
INSERT INTO ayz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tabam ro Zebulon ysya Naftali rana to, kene mam aya maam. Rabin reto to, mamo snok mam aya ro Yordan majoh to, ja raa mtu mawe rabin ro Galilea ye. Ana ro mhau mam rabin reto to, raa mana ro Yahudi fee. ");
INSERT INTO ayz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tiwya ana wase Allah. Ana mfi raa ro mhau mam amur yoyo sai. Tna ana mmat kek ro mase. Tna kek reto merif iso kʼraa ro mhau mam wore mamur to, re kbe ana masu mmat bo ye.” ");
INSERT INTO ayz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tna mam wore wo Yesus yamo yhau mam Kapernaum to, Ait yasen wosa yawe, “Nma fooh! Nashana! Allah siwyan yamo Raja tna re ybo anu. Ait ytu raa wAit mama fooh.” ");
INSERT INTO ayz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ati sau fo, Yesus yamo mam maru ro Galilea maam. Yamo tna ymat raa mabo ewok mse jala rana mam maru mfot syoh. Ana mbewok ja makam maru. Sait yasom Simon-Petrus tna ysya yao Andreas. ");
INSERT INTO ayz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tna Yesus ytu kʼana mbewok yawe, “Nma kro Jõ. Kbe Jõ tbis anu nmo nfot raa.” ");
INSERT INTO ayz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ana mbewok mari feto, tibyo masen fooh sikba jala wana makus. Tna mbewok kro Ait mamo. ");
INSERT INTO ayz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ana mamo tna mmat Yakobus ysya yao Yohanes. Ana bewok weto to ku ro bi Zebedeus wait. Ana mbewok msya maja rana hre mam wiak tna misoh jala wana. Tna Yesus ytu ana mbewok mama kro Ait. ");
INSERT INTO ayz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ana mari si to, mbewok masen sikba maja rana ysya wiak rana akus tna kro Yesus mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tna Yesus yamo yur mam provinsi ro Galilea beta. Yamo ykyas bo mam samu watum makin ro Yahudi. Ait wosa Bokyas ro Moof kʼana. Bokyas moof reto to, mkyas wore wo Allah yamo Raja ybo raa mana rAit. Tna Yesus yisoh raa ro kiyam moof beta ye. Tna ana ro ssafo fee; Ait yisoh tibyo ana metsu matak ye. ");
INSERT INTO ayz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bo ro Ait yno weto to, hahah mamo mur mtan mam provinsi ro Siria beta. Tibyo raa makah raa ro mafa bo ro knik-knak sor mama mo kʼAit. Ana weto taro to kabes mbo, tna taro to kiyam ro ruu mber, taro to maa msya matem mhai ye. Ana ro kiyam wofo fo Ait yisoh tibyo mrok moof beta. ");
INSERT INTO ayz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ait yno bo weto tibyo raa mawat kro Ait. Raa weto sor to, taro mbam provinsi ro Galilea, taro mbam rabin ro Dekapolis, taro mbam kota ro Yerusalem, taro mbam provinsi ro Yudea, tna taro ye mbam aya ro Yordan maam jaro ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus ymat raa mawat. Feto tibyo Ait yaut yamoʼt faut mana sau. Ait hre tna kuber wAit (murid-murid) mama mo kʼAit. ");
INSERT INTO ayz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tna Yesus huwya watum ana yawe, ");
INSERT INTO ayz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Raa taro mhar mawe ana raa ro soso sai tna ana msam wai kʼAllah. Ana kbe mhau simaut mase. Ana oh mi raa mana ro Ait yamo Raja ybo. ");
INSERT INTO ayz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Raa taro mnaut iro ro ana mno, tibyo sraujin toni. Kbe Allah yisoh ana mhaf tibyo mhau simaut mase. ");
INSERT INTO ayz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Raa taro to mhaf sneh. Ana oh mi kbe mhau simaut mase. Kbe Allah ysan tabam refo kʼana. ");
INSERT INTO ayz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Raa taro mhai sre msya mhai sbit mno bo ro Ait ksoh. Ana kbe mhau simaut mase ye. Kbe Ait yno ana mhaf mnan. ");
INSERT INTO ayz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Raa taro ja matmof raa anya. Ana kbe mhau simaut mase ye. Kbe Allah yatmof ana. ");
INSERT INTO ayz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Raa taro to mato mboh tna srau sau mno bo ro Ait ksoh yoyo. Ana kbe mhau simaut mase ye. Ana weto oh mi meen mmat Ait mam rabin rAit. ");
INSERT INTO ayz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Raa taro ja makah iranya mama. Ana kbe mhau simaut mase ye. Kbe Allah ytu ana yawe ku wAit. ");
INSERT INTO ayz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Raa taro ja mbo Watum rAit mno; tibyo raa roto sikowah ana. Ana kbe mhau simaut mase ye. Ana weto raa ro kbe Allah yamo Raja ybo to. Tna kbe mhau msya Ait mam sawro rAit ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Anu taro smot Jõ. Feto oh mi kbe raa mamus anu, tna mawe kair anu tna mno bo ro mkair btek mai kʼanu bo to. Kbe anu weto nhau simaut mase ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nnaut nabi na ro tiwya Allah ybis mkyas bo wAit to, nnaut nwe tiwya raa sikowah ana feto ye. Feto to, simaut mase sai. Meen Allah yoo boren ro mase mam sawro rAit tna yaren anu weto ye.” ");
INSERT INTO ayz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tna Yesus fret bo yawe, “Anu nfi haa kʼraa ro tabam refo beta. Haa to, ja mafah moof. Menohe mfi bo haa reto mafah fee; kbe raa mno fyi re kbe haberek mafah u? Mafer rau aro u fee. Haa reto raa moo mbeak mam iso. Tibyo raa ro mamo-me sor to, mber kait-kat sai. ");
INSERT INTO ayz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Anu nfi kek ro mram raa ro tabam refo beta. Kota ro mhau abyõ mam faut mana to, ja raa mne mmat kek reto. Kbe raa beta mmat tu oh! ");
INSERT INTO ayz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Feto ye, ja raa mbet tafoh (pelita) afo re ntara raa ro twok mam amah mato. Raa moo tafoh mse mte tna moo ember burut wa fee. Tafoh reto to, ja raa hero abyõ afo re kbe kek ntara tna raa ro mama twok mam amah mato reto mmat bo. ");
INSERT INTO ayz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nno bo ro moof kʼraa. Nno feto afo re raa mmat bo moof ro anu nno tibyo ana mbaut Bja ranu ro yhau mam sawro rAit.” ");
INSERT INTO ayz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tna Yesus yawe, “Tiwya Allah ybis Musa ysya nabi wAit mama mkom watum rAit. Tna Jõ tama re tbo tno bo ro Watum reto mbis. Tawe tno beta mnan si. Nnaut nwe Jõ tama re kbe beak Watum reto makus to ma. ");
INSERT INTO ayz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nri kaket: Mam wore wo ayoh msya tabam refo makyon rau sboh fefares to, Watum ro Musa reto kbe mabo beta tu oh. Watum reto to, maja rau sau ro maku to, kbe susre fee. ");
INSERT INTO ayz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Feto to, niwana Watum reto maja ro maku sau to ma. Nkyas kʼraa roto to, nbis ana miwana Watum reto msya anu to ma. Awya ro yiwana Watum ro Musa feto kbe mamo raa ro mase mam wore wo Allah yamo Raja ybo raa mana rAit to fee. Meen ait retait tait yaku kosion sai. Nbo Watum reto nno kaket. Tna nkyas kʼraa re ana mno kaket ye. Awya ro ybo Watum ro Musa matak feto, meen yase mam wore Allah yamo Raja ybo raa mana rAit. ");
INSERT INTO ayz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nri oh! Nnaut oh: Guru agama ro Yahudi msya raa ro Farisi to, ana mno bo ro Allah ksoh kaket fee. Soh anu nno bo mamyot bo ana ja mno to, meen anu nmo raa ro Allah yamo Raja ybo to fee. Soh anu nwe nmo raa ro Allah yamo Raja ybo to, nno bo ro Ait ksoh kaket. ");
INSERT INTO ayz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nri oh: Tiwya hohos na wanu mkyas Watum ro Musa kʼanu mawe: ‘Nme ajat ma.’ Keluaran 20:13 Awya ro yame ajat to, kbe raa mfot tna makah mamo mbu mam bui. ");
INSERT INTO ayz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Menohe Jõ tawe kʼanu tawe: Awya ro kmo raa roto to, kbe Allah ytu safo reto yari tu oh. Feto ye awya ro yawe kair raa roto yawe, ‘Namboi!’ to, kbe raa manes ro ja mtu srah ro Yahudi to, mtu srah reto mari ye. Tna awya ro yamus raa taro yawe, ‘Nyõ wase bo!’ to, kbe Allah yfot Ait beak yamo yait mam tafoh ro rabin kair ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Feto to, soh anu nbo bosan sau tna nmoʼt wohat (mezbah) nwe nsan bo reto kʼAllah to, nnaut wia. Nmo tna anu nnaut bo ro tii anu nno mkair mai kʼraa roto to, ");
INSERT INTO ayz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","noo bosan reto nse bris agus wia. Tna fo nmo nisoh niranya nsya raa retait wia. Tna ne hah ne nmo noo bosan ranu riwai reto nsan kʼAllah. ");
INSERT INTO ayz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mfi bo anu sait nsya raa sait kmo anya. Tna anu mbewok kbe nmoʼt amah ro raa mtu srah. Rau ro moof to, anu mbewok nisoh niranya fooh, tna nfot ntem anya mam iso maka. Soh mfe to, kbe sait yamo ysan sait kʼraa manes re mkyas safo reto. Tna fo raa manes mbis anu nmo no kʼait ro ytu srah yari. Tna fo bi ait ysan anu renti kʼait ro ja ybu raa mam bui mato. ");
INSERT INTO ayz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nri kaket: Kbe anu sait raa mbu mam bui mato mamo snok mam ayõ ro ait hrat bo raa ska wia. Tna fo ait frok ybam bui mato reto. ");
INSERT INTO ayz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Anu nhar watum ro tiwya Musa ykyas kʼanu hohos na. Ait yawe: ‘Nwyah ma.’ ");
INSERT INTO ayz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Menohe Jõ tawe kʼanu tawe: Awya sai ro ymat sas fnya re srau oot-oot to, ait retait ywyah ysya au reto mam yhaf mato oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Soh anu nsu makan ati ro tem ati misti re anu nno iro to, bo mkair. Ro moof to, tufrok nsu makan reto beak makus to. Soh anu nhau nkah nsu makan jaro mesait aran sai to, moof baro ye. Menohe soh anu nhau nkah nsu ro misti re anu nno iro to, kbe tis rau to anu fri kair sai. Kbe Allah tubat anu nkah netsu wanu, beak mam rabin ro arin kair reto (neraka). ");
INSERT INTO ayz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tna soh anu ntem ati misti re anu nno iro to, mkair meto. Ro moof to, sbi ntem reto beak war makus. Soh anu nhau nkah ntem jaro mesait aran sai to, moof baro ye. Menohe soh anu nhau nkah ntem ro misti re nno iro to, kbe Allah ybis anu netsu beta nmoʼt rabin ro arin kair reto. ");
INSERT INTO ayz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Anu nhar watum ro tiwya Musa ykyas kʼanu hohos na. Ait yawe: ‘Awya ro yako yfain makus to, yako hawe sai ait ykom aam sau yee kʼau mbo. Ykom yawe ait yako yfain.’ ");
INSERT INTO ayz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Menohe Jõ tawe kʼanu tawe: ‘Soh fai sau mwyahte fee; yako hawe sai raa yako fai au makus to ma. Soh ait bitsre au makus to, ait retait mi yisti re au mwyahte ye. Tna raa ro yoo fai reto riryõn to, ait ywyahte ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Anu nhar watum ro tiwya Musa ykyas kʼanu hohos na. Ait yawe: ‘Soh anu sait ytom Allah yasom afo re raa mhar mawe bo ro ait ykyas to, ait ykyas yaja bait oh, ykyas sioh fee; tna soh ait sumpah bo ytom Allah yasom feto; yako hawe sai kbe ait yno bo reto tu oh.’ ");
INSERT INTO ayz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Menohe Jõ tawe kʼanu tawe: Soh anu sumpah bo to, ntom Allah yasom ma! Allah hre abyõ mam sawro rAit tna ybo raa wAit. Feto to masi mawe anu sumpah bo ntom sawro rAit ye. Allah hre ybo raa wAit mbam tno. ");
INSERT INTO ayz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Feto ye sumpah bo ntom tabam refo masom to ma: Allah tait ybo tabam refo ye. Tna sumpah bo ntom kota ro Yerusalem masom to ma: Yerusalem to kota Raja ro Yase ybo ye meto. ");
INSERT INTO ayz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tna sumpah bo ntom nna to ma: Mfi bo anu nna mboh to, anu aro ntai ntak nno nna mawyan sau haberek mamo safe fee. Tna anu ntai nno ro safe sau haberek mamo mboh bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ati ro anu nkyas bo to, nwe ‘Ae’ sai. Tna nwe ‘Mfe’ sai. Soh anu nkyas bo niwer to, reto mbam kabes yabi (Iblis) oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Anu nhar watum ro tiwya Musa ykyas kʼanu hohos na. Ait yawe: ‘Nsu ska nsu, tna nbait ska nbait ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Menohe Jõ tawe kʼanu tawe: Raa ro mawe mno bo mkair mai kʼanu to, nno wa ma. Soh raa miban natni ranu jaro to, haberek noo natni ro ati jaro nee kʼana miban ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mfi raa sait yawe bomhaam wait mhau kʼnyõ. Soh ait yawe ytak ratan anyõ sau to, nee sai. Tna noo ratan anyõ roto taro ye niryõ nee kʼait. ");
INSERT INTO ayz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tna soh raa yama tna ybis anu nsom bo wait nmo iso kilo mara sau to, nno sai. Tna fo ne nsom soro nmo kilo mara sau naut. ");
INSERT INTO ayz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tna soh raa mayoh bo kʼanu to, noo nee sai. Feto ye soh raa mayoh bo kʼanu tna mawe kbe me misroh to, nee sai. Nbe ma. ");
INSERT INTO ayz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Anu nhar watum ro tiwya Musa ykyas kʼanu hohos na. Ait yawe: ‘Nksoh raa ro mno bo moof kʼanu. Tna knait raa ro mamo byoh kʼanu to.’ ");
INSERT INTO ayz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Menohe Jõ tawe kʼanu tawe: Natmof raa ro mamo byoh kʼanu. Skabuk raa ro sikowah anu ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nno feto afo re kbe anu nno bo mfi anu Nja ranu ro yhau mam sawro rAit to. Allah yno ayõ moo maut to, yno mkah raa ro ja mno bo mkair ye tna raa ro ja mno bo moof ye. Tna Allah yno oom mais to, yno mkah raa ro mno bo ro Ait ksoh ye tna mkah raa ro mno bo ro Ait knait ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Soh anu natmof raa ro ja matmof anu sai aran to, kbe Allah ymat tibyo yoo boren yaren anu aro fee. Raa ro ja moo namabyoh (pajak) to, ana ja matmof raa ro matmof ana feto ye. ");
INSERT INTO ayz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tna soh anu nmah meen kʼraa wanu mesait aran to, raa beta ja mno feto ye. Nno feto to, nyõ nno bo ro moof miwer ana oh meto fee. Ja raa ro wase Allah to, ana ja mno bo ro anu nno weto ye oh. ");
INSERT INTO ayz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Feto to, nno bo ro moof mnan si, mfi anu Nja ranu ro yhau mam sawro rAit ja yno to.” ");
INSERT INTO ayz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tna Yesus yawe, “Nno bo skabuk ranu mam wore wo raa mamo-me ma. Nno bo weto afo re raa mmat anu to ma. Soh anu nno bo moof afo re raa mmat anu sai, anu Nja ranu ro yhau mam sawro rAit to, kbe yoo bo aro yaren anu fee. ");
INSERT INTO ayz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Feto to, soh anu nsan bo kʼraa ro suawe to, tawyõ anu kʼraa afo re ana mmat nyõ to ma. Raa ro sioh ana sai ja mno feto. Ana ja mno feto mam samu watum tna mam iso mabi afo re raa mmat ana tna bibi ana. Jõ tawe kʼanu tawe, ana weto mkai boren wana beta oh. ");
INSERT INTO ayz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Menohe anu fo, ati ro anu noo bo nee kʼraa to, nee shait banu sai afo re raa roto mhar to ma. ");
INSERT INTO ayz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Natmof raa nfi feto afo re raa roto mhar bo ye ma. Nno feto tna anu Nja ranu ro yhau mam sawro rAit yesait aran yhar. Ait yesait aran yhar bo ro nyõ nno wai reto tna kbe Ait yisroh riryõn kʼanu. ");
INSERT INTO ayz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Anu skabuk to, skabuk kaket. Raa ro ja sioh ana sai to, ja skabuk ye. Ana ja ksoh skabuk mam samu watum wanu. Tna ana skabuk mam iso mabi mbra ye. Ana mno feto afo re kbe raa mmat ana, tna bibi ana. Ana weto mkai boren wana oh. Meen Allah yoo boren rouu yaren ana aro fee. Anu to, skabuk mfi feto ma. ");
INSERT INTO ayz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Soh anu nwe skabuk to, twok nmoʼt amah mato, tna nuut mato wa. Tna skabuk Nja ranu ro ja yhau wai. Tna kbe anu Nja ranu ymat bo anu skabuk wai feto, kbe yari anu ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Soh anu skabuk to, skabuk ntru nmo ne nfi raa ro wase Allah sai to ma. Bo skabuk rana to miyõ wer. Ana skabuk miyõ wer feto tna mnaut mawe reto oh mi kbe Allah yari. ");
INSERT INTO ayz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nno bo nnan fi ana mno feto ma. Anu nyoh bo fefares to, Nja ranu yhar bo ro anu nyoh weto oh. ");
INSERT INTO ayz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Feto skabuk fefo: Nyõ fi amu Nja ramu ro nhau mam sawro aNyõ. Nno re kbe raa mari tibyo bibi Nyõ nasom aNyõ. ");
INSERT INTO ayz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nasen namo Raja tna nama nbo raa woNyõ. Bo ro Nyõ ksoh to, ja raa mbo mno mam sawro aNyõ oh. Nno re raa ro mhau mam tabam refo mbo mno bo ro Nyõ ksoh mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ifo to, amu nyoh boit mbam kʼNyõ natem aNyõ re boit wamu to mabut fee. ");
INSERT INTO ayz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nyon iro wamu sor. Nyon iro wamu mnan fi amu nesait ne nhaf moof nsya raa anya ro mno bo ro mkair mai kʼamu ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tna nakah amu namo mam wore wo bosanet aro besruf amu to ma. Nama nitsnok amu frok nbam wore wo mkair-kar. Nyõ Allah ro nase. Nyõ natak nbo ayoh msya tabam refo. Kbe raa bibi Nyõ maban mfo refo mamo snok mam hame wajin ye. Amin: Mabo oh. ");
INSERT INTO ayz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Soh raa mno iro mai kʼanu to, nhau nhaf kair ma. Sorni bo mkair ro ana mno mai kʼanu weto sai. Ne nhaf moof u, tna kbe anu Nja ranu ro yhau mam sawro rAit tait, yatmof anu tna yyon iro wanu ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Menohe soh anu nhaf kair tna knait raa ro mno iro mai kʼanu to, kbe Nja yyon iro wanu fee ye.” ");
INSERT INTO ayz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ti aro raa mhau bo mait afo re ana skabuk kaket. Soh anu nhau bo niit feto to, nno nsu wanu mkair nfi raa ro ja sioh ana sai mno to ma. Ana mno masu mkair afo re raa mhar mawe ana mhau bo mait. Jõ tawe kʼanu tawe ana mkai boren wana beta oh. Kbe Allah yoo bo aro yaren ana fee. ");
INSERT INTO ayz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Menohe soh anu nhau bo niit afo re skabuk to, nyon nsu wanu, tna shat nna wanu ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Afo re raa aro wase bo anu nno nhau bo niit. Soh anu nno feto kbe anu Nja ranu ro yhau wai tait yesait aran yhar bo ro anu nno wai reto tna kbe Ait yoo boren yaren anu ye.” ");
INSERT INTO ayz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tna Yesus yawe, “Nme kta mam tabam refo ma, kbe bo mabat, hesik mait, tna raa mama mitrah amah msyõf kta wanu weto, makah mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Menohe nme kta wanu mam sawro ro Allah rAit wea. Mam sawro reto kbe bo mabat fee, hesik mait fee, tna raa ro mama msyõf bo to marak ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Soh anu nme kta wanu mam tabam refo fo, kbe nhaf wanu mnaut kta weto sai. Menohe soh anu nme kta wanu mam sawro ro Allah to, kbe anu nhaf nnaut sawro rAit yoyo ye. ");
INSERT INTO ayz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Anu nsu wanu to, mfi lampu ro ntara anu oh meto. Soh nsu moof to, mno netsu wanu mram. Tibyo nsu maah ye. Soh anu nri watum tna nbo nno to, anu nmo mam kek reto yoyo oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Menohe soh anu nri tna nbo nno fee; kbe anu nfi raa ro masu mti. Kbe anu nhau mam mamur sai. Tna soh anu nmo mam wore wo mamur to, feto kbe mamur reto to, mrok mamur htoh toni.” ");
INSERT INTO ayz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tna Yesus yawe, “Ja sryan sait yno bo ro bobot sait aran sai. Ait yno bo ro bobot mabo ewok brio-brio to fee. Kbe ait knait bi ait sait tna ksoh bi ait sait. Kbe ait yari bo ro bobot sait yawe, tna yiwana bo ro bobot sait yawe. Feto to tawe kʼanu tawe: Nno bo ro Allah wAit sai aran. Saso kta ro tabam refo ye ma. Anu raa ntai nkro iso ewok weto su fee.” ");
INSERT INTO ayz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tna Yesus yawe, “Feto to, Jõ tawe kʼanu tawe: Nnaut yyi bo ro tabam refo toni to ma. Nnaut nfos wanu to, nnaut nwe nfos wanu to bo ro ati. Tna nnaut yyi boit ro kbe anu niit to ma. Nnaut netsu wanu to, nwe bo ro ati to ma. Tna nnaut yyi ratan ro kbe anu nyum to ma. ");
INSERT INTO ayz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sik nmat ruu ro mfru mam ayoh to. Ruu to ja wase bo mkah. Tna wase bo siwyan boit ye. Tna wase sgi gudang ro moo boit mse ye. Menohe anu Nja ranu ro yhau mam sawro rAit tait, Ait siwyan boit kʼana mait. Tna anu raa fo, Ait ymat anu kaket miwer ruu to. ");
INSERT INTO ayz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Awya ro ytai yirenti yamos rait kebet naut? Anu nkin wefo fo, soh anu naut yyi bo ro tabam refo yoyo to, reto mafer marak. Allah oh mi Raa ro ybo anu nmos wanu. Allah yesait aran ytai yirenti raa mamos wana. ");
INSERT INTO ayz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tna bawya mno re anu nnaut yyi ratan ro nyum to. Sik nmat sas bosafom ro moo mam smok. Tafuf wau weto mesait moo sai. Tafuf weto mur-mur saso boit fee. Bosafom ja msui mfen ratan ro myum to fee. Menohe Allah yno bo weto moof toni. ");
INSERT INTO ayz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tiwya raja Salomo yyum ratan ro moof wer. Menohe Allah yno tafuf weto moof toni miwer. Raja Salomo, ratan rait moof mfi bosafom tafuf wau to fee. ");
INSERT INTO ayz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Allah yno re bosafom ro moo mam smok ifo moo boti waor sai. Menrabu to, raa mama mkah mkak. Mhau boti waor sai, menohe Allah fayir bosafom reto. Ait yno tafuf rau moof toni. Tawe, Allah ymat anu tna ksoh anu toni miwer bosafom reto. Feto to nnaut yyi ratan ro anu nyum to ma. Anu ja smot Allah matak fee! ");
INSERT INTO ayz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nnaut yyi bombra weto ma! Ja raa mawe: Bo ro anu niit msya aya ro nta bo to au miyo? Tna msya ratan bo ro anu nyum bo to au miyo? Nnaut yyi feto ma. ");
INSERT INTO ayz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Raa ro wase Allah mam tabam refo to, ana weto msui saso bo weto beta. Menohe anu fo, Nja ranu ro yhau mam sawro rAit yhar yoo boit yee kʼanu. Tna yhar bo yoo ratan yee kʼraa wAit ye. Yhar bombra weto beta. ");
INSERT INTO ayz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Feto to, ntomer re nmo raa ro Allah yamo Raja ybo. Ntomer nno bo ro Ait ksoh. Saso bi Ait wia matim feto, tibyo kbe Allah yoo bo weto beta ysan kʼanu. ");
INSERT INTO ayz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Feto to, nnaut yyi bo ro menrabu btek mai kʼanu to ma. Bo ro menrabu to, Allah yhar oh. Bo ro samyoh mam ti sau to maum oh mam ti reto.” ");
INSERT INTO ayz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nmat sas raa roto ma. Nnaut nwe raa roto mno bo ro mkair ma. Nhau nnaut feto ma be kbe Allah haberek ymat sas anu si, yawe anu weto nno bo mkair ye meto. ");
INSERT INTO ayz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bo maja ro anu nbo nwe raa roto mno bo mkair to, kbe Allah haberek bo maja reto yawe anu to nno bo mkair ye. Tna bo maja ro anu nbo nnit bo ro raa roto mno to, kbe Allah haberek ybo bo maja reto ynit bo ro anu nno to ye. ");
INSERT INTO ayz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Soh raa wanu sait yno bo ro mkair kebet baro sai to, reto mnan fi knuf ro maku mhau kʼait yasu. Anu nmat sas ait. Menohe knuf ro maboh mhau kʼanu nsu. Feto to anu nahni bo ro mkair-kar mase ja anu nesait nno. ");
INSERT INTO ayz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Fyi re anu nwe kʼait nwe, ‘Nama, jõ tmen knuf ro maku kʼnyo nasu mato to.’ Ja anu nesait nmat knuf ro mhau kʼanu nsu mato wanu fee! ");
INSERT INTO ayz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sioh anu to ma! Nisoh anu wia. Tna kbe nsu maah re kbe nmen knuf kʼait yasu mato to.” ");
INSERT INTO ayz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Bo ro moof toni to, noo beak mtah mait to ma; be kbe haberek mafit anu. Noo haban mutiara ro mabyoh maut toni to, beak fane mait to ma; kbe fane mau maut mber kait-kat makus.” ");
INSERT INTO ayz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tna Yesus yawe, “Nyoh bo tna kbe Allah yoo bo yee. Saso bo tna kbe anu ntru bo reto. Nii mato tna kbe mato reto Allah yitrah. ");
INSERT INTO ayz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Awya sai ro yayoh bo kʼAllah to, kbe Allah yoo yee. Awya sai ro saso bo to, kbe tru tu oh. Tna ro yai mato to, kbe Allah yitrah mato reto ye oh. ");
INSERT INTO ayz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mfi bo ku wanu sait yhai sre yawia boit yait to, kbe yaja yasen yoo fraa yee ku rait yait fee. ");
INSERT INTO ayz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mfi bo ku sait yawia yabo syoh to, kbe yaja yoo aban yee fee. ");
INSERT INTO ayz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anu raa to nimara mboh. Menohe anu nksoh noo bo ro moof nee ku wanu. Tna Nja ranu ro yhau mam sawro rAit to, ksoh yoo bo ro moof toni yee kʼanu ye. Soh raa mayoh bo kʼAit to, kbe Ait ksoh yoo bo reto yee kʼana ye fea!” ");
INSERT INTO ayz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bo bawya sai ro anu ksoh nwe raa mno kʼanu to, nno mfi feto kʼana ye. Watum ro tiwya Musa ysya nabi na mkom to, mabo rau oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mato sau ro mtit mhau. Ntomer ntwok mam mato ro mtit reto. Ntwok mam mato ro meya ma. Nmo mam iso mabi ma. Iso ro mabi reto to, iso ro rabin kair. Tna raa msis-sas kro iso reto. ");
INSERT INTO ayz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Menohe iso ro mamos mae to mtit. Tna mato rau to maku toni ye. Raa ro bito kro iso tna ntwok mam mato reto to kebet baro sai.” ");
INSERT INTO ayz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kaket anu: Kbe raa mama sioh mawe, ‘Amu fo, Allah ybis nmo nabi wAit. Amu ja nkyas bo wAit.’ He mfe. Ana weto, wan-wan mno bo moof mfi domba. Menohe ana ja safo mfi mtah serigala ye meto. ");
INSERT INTO ayz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nmat sas bo ro ana weto ja mno. Tna kbe anu nmat he ana mno bo ro mkair-kar. Feto kbe anu nhar nwe raa weto mbam kʼAllah fee. Raa taro mfi ara ro moof. Tna raa taro to, mfi abumun sai. Ja raa mryoh anggur make mbam abumun mara fee. Tna ja raa mryoh kake ro moof mbam hyoh muuf bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ara ro mara moof to, kbe make rau to moof yum. Tna kake mara ro moo kaket fee, kbe make rau to mkair ye. ");
INSERT INTO ayz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ara ro mara moof to, ja make rau to mkair fee. Feto ye ara ro mara mkair to, kbe make rau to moof fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tna kake mara ro mse make moof kaket fee, kbe raa mfat mkah war to. ");
INSERT INTO ayz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Feto ye mkah ana ro sioh mawe ana nabi ro Allah. Ana mawe Allah ybis ana makah watum rAit mama mkyas. He mfe, soh anu nmat sas bo mafer ro ana mno to, kbe anu nhar nwe ana mbam Allah mama fe mfe a. ");
INSERT INTO ayz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Raa ja mkyas bo kʼJõ tna mtom Jõ tasom mawe Jõ fi Tuhan rana. Menohe ana weto taro mamo raa woJõ fee. Ana kbe mamo raa ro Allah ybo yfi Raja fee. Jõ Taja yhau mam sawro rAit. Tna raa ro ja mno bo ro Ait ksoh sai oh mi kbe mamo raa wAit to. ");
INSERT INTO ayz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Meen mam ati ro Allah ysok raa ro mamo raa mana rAit to, kbe raa msis-sas mama mtu kʼJõ mawe, ‘Tuhan; tiwya amu oh mi nkah natak aNyõ nkah soo ro Allah nmo nkyas kʼraa sor. Tna amu nkah natak aNyõ ye nikyak kabes sor. Tna amu nno bo ro msai mawat taro sor mkah Nyõ natak aNyõ ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Menohe ati reto to, Jõ titbat tawe kʼana abyõ tawe, ‘Jõ wase anu saut! Anu raa ro ja nno bo kbik-kbak sai meto. Nmo fari tno!’” ");
INSERT INTO ayz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tna Yesus yawe, “Raa taro mari bo ro Jõ tkyas refo tna kbe mbo mno kaket. Ana weto mfi raa sait ro ja yhar bo sgi amah rait abyõ mam fraa to. ");
INSERT INTO ayz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ait sgi abyõ mam fraa to, tibyo amah rait matu fee. Oom mais mos, syar miyi mama, tna oof ye frok mama mfi to, menohe amah rait reto mros matak; matu fee. ");
INSERT INTO ayz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Raa taro mari bo ro Jõ tkyas refo tna mbo mno fee. Ana weto mfi raa sait ro ja wase bo. Ait retait sgi amah rait abyõ mam snyik mana. ");
INSERT INTO ayz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oom mais mos, syar miyi mama, tna oof ye frok mama mfi amah reto to, tibyo amah reto matu mai tabam.” ");
INSERT INTO ayz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesus ykyas watum reto matak toni. Menohe guruagama ro Yahudi to, ja bokyas wana matak kaket fee. Yesus watum bo mkak. Tibyo raa ro mari bokyas rAit reto mrok ktak beta. ");
INSERT INTO ayz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus yroh ybam faut mana si fo, tibyo raa makin mjor mama kro Ait. ");
INSERT INTO ayz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mam weto ye ait ro yafa kusta sait yama. Yama tna yjit yimna soh-soh kʼAit yawe, “Bobot, soh Nyõ ksoh meto mi, nisoh jõ re kusta refo marak.” ");
INSERT INTO ayz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tna Yesus yatem ybo ait tna yawe, “Jõ ksoh, tawe nyõ mbros oh!” Ayõ reto si fo, kusta reto mrok marak. ");
INSERT INTO ayz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tna Yesus yawe wa kʼait yawe, “Namo to, nkyas bo refo kʼraa ma. Namo nerif narak anyõ kʼimam ro Yahudi sait re ait ymat sas nyõ. Nyõ noof u tibyo noo bo nee kʼimam. Tna kbe ait ysan bo reto kʼAllah mamyot Watum ro Musa ykom yawe. Nno bo weto re kbe raa mhar mawe nyõ netsu moof u.” ");
INSERT INTO ayz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tna Yesus yamo snok mam remo ro Kapernaum. Tna raa sbe ro yase sait yama yo kʼAit. Raa sbe retait yamo aban mana ro ja ybo raa sbe ro Roma majin sau. Ait soh-soh Yesus yawe, ");
INSERT INTO ayz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bobot; sryan ajõ kiyam msai yhau mam amah. Tna kiyam reto mno tibyo ait yaa msya yatem yhai. Tibyo yakus yjin sai mam aam meu.” ");
INSERT INTO ayz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus yari feto tna yawe, “Jõ kbe tama tisoh ait re yoof.” ");
INSERT INTO ayz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Menohe aban mana ro sbe retait yawe, “Bobot, jõ fi raa ro ati fee tna Nyõ fi raa ro nase toni. Feto to tawe namo twok mam amah ajõ to ma. Naban nawe sai mam wefo tna kbe sryan ajõ retait kiyam rait marak. ");
INSERT INTO ayz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jõ thar tawe raa kinyah ja mari bo kʼraa mase ro mbo ana. Jõ tesait ja tari bo kʼraa ro mase woJõ ye. Tna raa sbe ro kinyah ja mari bo ro jõ tawe ye. Soh jõ tbis bo kʼraa sbe sait to, kbe ait yari tna yasen yamo tu oh. Tna soh jõ ttu raa sbe taro sait tawe yama to, kbe ait yasen yama ye. Tna soh jõ tbis bo kʼsryan ajõ tawe, ‘Nno bo reto.’ Kbe ait yari ybo yno tu oh! Tna Nyõ to nase toni niwrek jõ ye. Soh Nyõ nawe kiyam marak to, kiyam reto mari tibyo marak tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus yari bokyas rait reto tna yrok ktak. Raa mawat kro Ait mamo to, tna Ait yawe kʼana yawe, “Ja raa ro mhau mam tabam ro Israel fo, bosmot wana matak fee. Menohe Ait refi bosmot rait matak toni!” ");
INSERT INTO ayz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tna Jõ tawe kʼanu tawe, meen raa srim msis-sas mama mbam arin aso beta. Mama hre su msya Abraham, Ishak, ysya Yakub ye. Hre sohmaam bo su mam wore wo Allah yamo Raja ybo raa wAit to. ");
INSERT INTO ayz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tiwya tinyi Allah ymen raa ro Yahudi mawat mamo raa mana ro Ait ybo reto. He mfe, ana hawe bo mama. Meen Allah yikyak ana mhau bana mne mam wore wo mamur htoh toni. Mam wore reto to, kbe ana sraujin ana toni. Tibyo ana kbe mawia tna kakyah toni ye. ");
INSERT INTO ayz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tna Yesus yawe kʼbi yabi ro sbe retait yawe, “Hah ne namo oh, kbe sryan anyõ yoof mnan si bosmot anyõ ye oh.” Weto si oh to, sryan retait yrok yoof. ");
INSERT INTO ayz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tna Yesus yamo twok mam samu ro Petrus. Twok tna ymat Petrus snyim ro ano mjin sai. Au metsu mbe. ");
INSERT INTO ayz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus yamo ybo fai au matem. Tibyo kiyam reto mrok marak. Tna fai au masen saruk boit mee kʼana mait. ");
INSERT INTO ayz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tna mam wore arin knu-knu fo, raa mawat mama mo kʼYesus. Mama to, makah raa ro kabes mbo mawat ye. Tna Yesus yikyak kabes weto mkah ymai sau sai fo, tibyo kabes weto frok mamo. Tna raa ro kiyam weto beta to, kiyam wana marak ye. ");
INSERT INTO ayz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesus yisoh raa feto to, afo re yno mnan si bo ro tiwya Allah ybis nabi Yesaya yama ykyas wia. Yesaya ykyas yawe, “Anu ro ssafo fee, Ait yisoh re boof. Tna anu ro kiyam bo to, Ait yisoh re boof ye.” ");
INSERT INTO ayz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tna Yesus ymat he raa msis-sas mama mros mur mtan kʼAit. Tibyo Ait ybis kuber wAit maut wiak msya Ait afo re ana frit mamoʼt maru reto ati tino. ");
INSERT INTO ayz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tna guru agama ro Yahudi sait yama yo kʼAit. Yama tna ytu yawe, “Bi Guru; woyõ-woya sai Nyõ namo to, jõ ksoh kro Nyõ bmo ye.” ");
INSERT INTO ayz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tna Yesus yawe kʼait retait yawe, “Mtah serigala to, ja mabum mam wafyoh rau. Tna ruu to, ja mabum mam tafat wana ye. Menohe Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna samu ro Jõ tjin aro fee. ⌞Soh nyõ nawe kro Jõ to, kbe wore nyõ njin aro fee ye.⌟” ");
INSERT INTO ayz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tna kuber wAit sait yawe kʼAit yawe, “Tuhan; nbis jõ tamo wia sama hai ro taja tna fo tama kro Nyõ.” ");
INSERT INTO ayz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Menohe Yesus yawe si yawe, “Namo ma. Ana ro wase Allah to, kbe mesait sama hai wana rof. Menohe nyõ to, kro Jõ bmo.” ");
INSERT INTO ayz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus yaut wiak sau, tna kuber wAit kro maut ye. ");
INSERT INTO ayz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ana mamo mamo tna foos ro msai frok tubor mama mai wiak rana. Tna figyõm mase mai maut mam wiak mato ye tna mabo kait ana beta. Menohe Yesus yjin tu bait mam wiak mato. ");
INSERT INTO ayz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tibyo kuber wAit mti Ait mawe, “Tuhan; natmof anu be kbe anu bsu fo.” ");
INSERT INTO ayz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus yrok yasen tna yastako ana yawe, “Bosmot wanu matak fee! Anu waa bo bawya mefo?” Feto tibyo Ait yifau foos msya figyõm weto. Tibyo maru reto mrok mnem. ");
INSERT INTO ayz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yesus yno feto tibyo ana weto mrok ktak sai, tna mawe kʼanya mawe, “Bi Ait refi yatak yifau foos msya figyõm wefo mari. Bi Ait refi fi raa fe bawya mefi?” ");
INSERT INTO ayz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesus ysya kuber wAit frit maru reto snok mam rabin ro Gadara. Mam weto to, raa mabo ewok ro kabes mbo fo mama mo kʼYesus. Ana mbewok mama mbam isra mato ro ja raa mse hai to, mama. Mbewok reto ja safo toni. Tibyo raa sait bo ter-ter yamo kait mam iso ro ana mhau reto fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mbewok mama tna kakyah mawe kʼYesus mawe, “Ku ro Allah yare fi; Nyõ nama nno bawya kʼamu fo? Nyõ nama sikowah amu a? Makyon ro Nyõ sikowah amu to, mama fefares!” ");
INSERT INTO ayz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kene msya yuk reto ye fane mawat mau bana. ");
INSERT INTO ayz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tna kabes weto soh-soh kʼYesus mawe, “Soh Nyõ nbis amu nawe frok nmo meto mi, nbis amu nmo twok mam fane wore wono!” ");
INSERT INTO ayz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tna Yesus ybis yawe, “Nmo oh!” Tna kabes weto mari tna frok mamo twok mam fane weto. Tna fane weto mrok mker tna mhoh tbat mam rakak reto btek mam maru. Tna fane weto msu tibyo mhai beta mkak. ");
INSERT INTO ayz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Raa ro kmot fane weto mmat bo ro Yesus yno. Feto tibyo ana masen fooh mhoh mamo mkyas kʼraa mam remo rana. Tna mkyas ana mbewok ro kabes mbo to ye. ");
INSERT INTO ayz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Raa ro mhau mam remo reto mari bo weto, tibyo ana beta mama mo kʼYesus. Mama tna misobu Ait mawe Ait yasen yamo fooh sikba rabin rana. ");
INSERT INTO ayz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus yno bo weto mkak tna fo ye yaut wiak frit yamoʼt remo rAit. ");
INSERT INTO ayz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mam weto to, ait ro yaa mhai sait yjin mam sesa sai. Yjin mam sesa tna raa nkatar ait makah mama mo kʼYesus. Yesus ymat ana tna yhar yawe ana smot Ait matak. Tibyo Yesus yawe kʼait ro yaa mhai retait yawe, “Tao, sraujin ma! Iro wonyõ to, Jõ tyon oh.” ");
INSERT INTO ayz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Guru agama Yahudi baro hre mam weto ye. Ana mari bo ro Yesus yawe feto tna mnaut mawe, “Bo ro Ait yawe to berasi Allah! Ja Allah yesait aran ytai yyon iro.” ");
INSERT INTO ayz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Menohe Yesus yhar bo ro ana mnaut mam srau mato wana. Tna yawe kʼana yawe, “Fyi re anu nnaut bo ro mkair weto mam srau mato wanu? ");
INSERT INTO ayz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Soh Jõ tawe kʼait refi tawe ‘Iro wonyõ to, Jõ tyon oh.’ Bo ro msai fee: Kbe raa mahni bo reto mabo fe mfe a. Menohe tawe, ‘Nasen namo oh!’ Tawe feto afo re kbe raa mmat bo reto mabo. Mmat tna mhar mawe Jõ ttai tno bo ewok ye to. Ewok ye mnan-nan kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna bo ro Jõ tno fo, Jõ tno re kbe anu nhar nwe Jõ tatak tyon iro raa mam tabam refo.” Tna Yesus yawe kʼAit ro yaa mhai retait yawe, “Nasen, tubat sese anyõ, tna nasom namo bonyõ!” ");
INSERT INTO ayz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tibyo ait yasen yros kaket tna yamo bait amah rait. ");
INSERT INTO ayz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Raa makin ro mmat bo ro Yesus yno reto to, mrok miskawowo. Tibyo ana mbaut Allah ro yoo yatak rAit yee kʼraa to. ");
INSERT INTO ayz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus sikba yuk reto yamo. Yamo to, ymat raa ro ja yoo namabyoh (pajak) yee kʼpemerintah ro Roma sait. Yasom Matius. Bi ait hre mam kantor ro namabyoh rait. Tna Yesus ytu kʼait yawe, “Nama kro Jõ bmo!” Matius yari feto, tibyo ait yasen kro Yesus mamo. ");
INSERT INTO ayz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ti sau Yesus ysya kuber wAit mait boit mam amah ro bi Matius. Tna raa ro ja moo namabyoh msya raa ro ja mno iro bo mawat mama mait boit su msya ana ye. ");
INSERT INTO ayz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Raa ro Farisi mmat ana mait bo su feto, tibyo mtu bo kuber ro Yesus wAit. Ana mtu mawe, “Fyi re Guru ranu yait boit su ysya raa ro moo namabyoh tna msya raa ro ja mno iro weto?” ");
INSERT INTO ayz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus yari bo ro ana mawe feto, tna yawe kʼana yawe, “Raa ro metsu moof ja mamo saso dokter fee. Ja raa ro kiyam oh mi mamo saso dokter to. ");
INSERT INTO ayz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nsen nmo nmat sas bo ro Allah yawe mam bokom rAit yawe, ‘Anu noo bo wanu taro nsan kʼJõ to, reto moof. Menohe jõ ksoh tawe anu natmof raa anya; reto moof toni.’ Hosea 6:6 Jõ tama ttu raa ro mhaf moof to fee. Tama fo ttu raa ro mno iro.” ");
INSERT INTO ayz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kuber ro Yohanes mama mo kʼYesus tna mtu kʼAit mawe, “Fyi re amu nsya raa ro Farisi ja nhau bo niit. Menohe kuber woNyõ mhau bo mait to fee?” ");
INSERT INTO ayz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus ykyas bofret kʼana yawe, “Ati ro raa sait ymen fnya to, ja raa mno bo bawya? Ana mhau bo ro mait fe mfe a? Mfe! Ana makyõ bokyõ fea! Ana makyõ bokyõ wia. Tna fo raa moo ait makah mamo. Tna kbe mafoh wana sraujin tibyo mhau bo ro mait. Kuber woJõ mfi feto ye. Jõ thau tsya ana fares fo, ana sraujin fee. Menohe ati ro Jõ sikba ana to, kbe ana sraujin tibyo mhau bo ro mait ye.” ");
INSERT INTO ayz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tna Yesus ykyas bofret ewok naut kʼana yawe, “Mfi bo ratan matah ro hri-hra sau. Ja fnya maru ratan reto mkah hawee ftah mabuf ro tna to fee. Soh au mtin feto to, kbe tis mkair. Kbe hawee ftah mabuf reto mno tibyo ratan reto mrok mhah renti. Feto ye iso bose raa mabi ro Yahudi ja mamo to hayah. Tna iso tna ro Jõ terif refo fo hayah ye. Tna iso ewok reto srioh anya ye fee. ");
INSERT INTO ayz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Feto ye, Ja raa mror anggur maya ro tna mam baah marak ro matah fee. Kbe anggur maya reto mno baah marak reto matu mbua. Tna kbe anggur maya reto maus miyi mroh mamo mkak. Anggur maya ro tna to, ja raa moo mror mam baah marak ro tna sai. Tna re anggur maya reto msya baah reto bewok kbe mhau moof to.” ");
INSERT INTO ayz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus ykyas bo fares tna bi yabi sait yama yo kʼYesus. Ait yaka hartu Yesus, tna yawe, “Ku ajõ ro ano sau tna sai mhai oh. Nama noo natem niir ku au afo re au mrok masen.” ");
INSERT INTO ayz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus yari feto, tibyo yasen ysya kuber wAit kro bi ait retait mamo. ");
INSERT INTO ayz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ana mamo kri-kri fo, fai sau mama. Fai au mafa mees ro fnya yoyo tahun trion 12 oh. Fai au mnaut bau mam srau mato mawe, “Soh jõ trof tiir ratan rAit baro sai to, kbe kiyam ajõ refo marak.” Feto tibyo au nto miir ratan ro Yesus rAit makit. ");
INSERT INTO ayz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus haberek ymat fai au. Tna yawe kʼau yawe, “Ku aJõ, sraujin ma; nyõ smot Jõ tibyo kiyam anyõ reto marak.” Feto si fo, kiyam rau marak. ");
INSERT INTO ayz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tna Yesus yamo snok mam amah ro bi yabi retait. Ait ymat raa ro mfi oor msya raa msis-sas ro mawia tna mmai wer mam beto. ");
INSERT INTO ayz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tna Ait yawe kʼana yawe, “Frok nmo oh. Ku au reto mhai fee. Au mjin sai meto.” Menohe raa weto masah Ait sai. ");
INSERT INTO ayz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Raa weto frok tna Yesus twok yamoʼt amah hawar ro ku au refo mriyor. Ait ybo ku au matem, tibyo ku au masen mros. ");
INSERT INTO ayz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bo ro Yesus yno reto raa mkyas hahah mamo snok mam rabin reto beta. ");
INSERT INTO ayz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus yasen yamo renti naut. Tna raa ro masu mboh mabo ewok kro Ait mam tis. Ana mtu mawe, “Yesus; Ku ro Daud, natmof amu!” ");
INSERT INTO ayz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus yamo twok mam amah sau tna ana mbewok ro masu mboh reto mama mo kʼAit. Tna Ait yawe kʼana yawe, “Anu mbewok nnaut nwe Jõ tatak tno anu nsu maah fe mfe a?” Tna ana mawe kʼAit mawe, “Ae, bi Yabi, amu smot Nyõ. Amu nhar nwe Nyõ fi Raa ro natak.” ");
INSERT INTO ayz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tna Yesus yiir ana mbewok masu, tna yawe, “Anu nsu maah mamo mamyot si bosmot ranu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tibyo ana mbewok reto mrok masu maah. Tna Yesus yawe wa kʼana yawe, “Nmo nkyas bo ro Jõ tno kʼanu reto kʼraa roto ma!” ");
INSERT INTO ayz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Menohe ana mbewok frok mamo mkyas Ait yasom faram mam rabin reto beta ye. ");
INSERT INTO ayz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ana mbewok ro masu mboh reto frok mamo. Tna raa makah ait ro kabes mbo sait mama mo kʼYesus. Kabes mbo ait retait tibyo ymai marak sai. ");
INSERT INTO ayz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus yikyak kabes reto. Tibyo ait retait yrok ymai. Raa makin ro mmat bo ro Yesus yno reto mrok ktak tna mawe kʼanya mawe, “Anu ja bmat bo ro mnan fefo aro mam Israel fee.” ");
INSERT INTO ayz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Menohe raa ro Farisi baro mawe, “Kabes yabi (Iblis) oh mi yoo yatak rait yee kʼYesus re Ait yatak yikyak kabes sor to.” ");
INSERT INTO ayz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tna Yesus yamo yur mam kota makin msya remo makin beta ye. Ait yamo iti to, Ait watum raa ro Yahudi mam samu watum wana ro mhau mam beto sor. Tna Ait wosa Bokyas ro Moof (Injil) kʼana ye. Bokyas moof reto to, mkyas raa mana ro Allah yamo Raja ybo. Tna Yesus yisoh raa ro kiyam tibyo kiyam rana marak beta ye. Tna ana ro ssafo fee beta to, Ait yisoh tibyo ana matak ye. ");
INSERT INTO ayz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tna Yesus ymat raa makin weto yawe bo msuweni-wana mfi domba ro mhau akus. Raa ro kmot ana aro fee. Tibyo Ait yatmof ana. ");
INSERT INTO ayz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tna Yesus yawe kuber wAit yawe, “Raa makin weto mfi bo armato ro manes oh. Menohe raa ro matu bo to, mabo kebet baro sai; mnan fee. ");
INSERT INTO ayz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Feto to, nyoh kʼAllah ro armato rAit afo re Ait ybis raa mama matu bo mam armato reto.” ");
INSERT INTO ayz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ati sau to, Yesus ytu kuber wAit mabo 12 weto mama mo kʼAit. Tna Ait yoo yatak rAit yee kʼana re kbe ana mikyak kabes sor, tna misoh raa ro kiyam tna mafa bo sor, re kbe mrok moof ye, tna misoh raa ro ssafo fee to, mrok matak beta ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Raabis (rasul) mabo 12 reto masom wana sor to mefo: Ait ro tinyi tait yasom Simon-Petrus, ysya yao Andreas. Tna Yakobus ysya yao Yohanes. Ana mbewok to ku ro bi Zebedeus yare. ");
INSERT INTO ayz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Tna Filipus, Bartolomeus, Tomas, tna Matius ro ja yoo namabyoh (pajak), Yakobus ro Alfeus yare ysya Tadeus. ");
INSERT INTO ayz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Tna Simon raa ro Zelot. Tna Yudas ro besruf Yesus. ");
INSERT INTO ayz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus ybis kuber wAit mabo 12 reto yawe, “Nmo no kʼraa mana ro Israel sai. Nmoʼt kota raa ro Samaria ma. Nmo nkyas kʼraa mana roto ma. ");
INSERT INTO ayz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nmo no kʼraa ro Israel mesait aran sai. Ana to, raa ro mamo tit mfi domba ro mamo tit tna raa ro kmot ana marak. ");
INSERT INTO ayz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nkyas kʼana nwe, ‘Allah siwyan yamo Raja. Ait ytu raa wAit mama tna Ait ybo ana.’ ");
INSERT INTO ayz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tna nisoh kiyam rana. Nno re raa ro mhai mrok masen ye. Nisoh raa ro mafa kusta afo re ana moof ye. Tna nikyak kabes frok mbam raa ro kabes mbo to ye. Jõ too tatak aJõ tee sai kʼanu. Nayoh nwe raa moo bo mee si kʼanu ma. Nmo nno bo weto mkah nhaf ro ase sai. ");
INSERT INTO ayz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Nmo to, nfau pitis msya ratan mam yu wanu ma. Tna nse sandal bo to ma ye. Tna nbo armuk trion ewok ma. Nnaut: Raa ro mkah kahren raa to, kbe raa moo boren maren ana tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nmo snok mam kota msya remo. Tna saso raa ro yhaf moof sait, re ait yse anu njin mam amah rait. Tna nhau nsya ait mamo snok mam wore anu nsen sikba remo reto. ");
INSERT INTO ayz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Anu nmo twok mam amah raa to, nmah meen kʼana wia. ");
INSERT INTO ayz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tna soh raa ro amah reto mhaf moof tna re huwya moo anu mse mam amah rana to, skabuk raa weto nwe Allah yno bo moof kʼana. Soh ana mikyak anu to, skabuk feto ma. ");
INSERT INTO ayz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Soh anu twok mam remo taro tna raa mitrah amah wana kʼanu fee; tna soh raa hawe mari bokyas ro anu nkyas to, ati ro anu sikba amah reto msya remo reto nmo to, bes-bas bohasyaf ro mhau mam naa to akus sai. ");
INSERT INTO ayz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jõ tawe kʼanu tawe, ‘Meen ati ro tabam refo haberek to, kbe Allah ymat raa ro tiwya mhau mam kota ro Sodom msya Gomora tna yno bo ro maku sai mbtek mai kʼana. Menohe raa ro remo taro tii mikyak anu. Ana hawe bo mari bokyas aJõ. Tibyo bo ro meen mbtek mai kʼana weto to, kbe samyoh toni.’” ");
INSERT INTO ayz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tna Yesus yawe, “Nri oh. Anu fo raa ro nhaf sneh. Tna Jõ tbis anu nmo mam remo aro sor. Tna kbe anu nkai raa ro mkair-kar. Anu nfi domba ro mamo mam wore wo mtah serigala ja mhau. Nmo to, kaket anu nfi aban. Tna nhau nhaf moof yoyo ye, mfi ruu merpati. ");
INSERT INTO ayz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Siwyan anu be kbe raa mno anu. Kbe raa wanu ro agama Yahudi mfot anu makah mamo msan kʼraa manes wana. Tna kbe ana sikowah anu mam samu watum wana ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Anu fo kuber woJõ. Au oh mi kbe raa mfot anu makah mamo msan kʼgubernur taro msya raja na taro sor ye. Bo mkair weto meen mai kʼanu. Menohe mafer rau ro tis to moof. Jõ bitsre bo reto mai kʼanu afo re kbe anu nkyas Jõ tasom kʼraa ro mase weto ye, msya raa wana makin ro wase Allah ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Meen raa mfot anu, makah mamo msan kʼraa weto. Tna kbe raa manes mtu srah wanu. Menohe wa ma. Nnaut yyi bo ro kbe anu nkyas to ma. Kbe Allah besi bokyas moof kʼanu. Kbe Ait besi bokyas rAit tna anu ne nawe si bokyas reto kʼana. ");
INSERT INTO ayz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Anu nesait kar oh mi nkyas bo mam weto fee. Kbe Har ro Nja Allah oh mi besi bo ro anu nkyas to.” ");
INSERT INTO ayz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tna Yesus yawe, “Anu to, meen raa msan anu kʼraa mame. Tna raa msan mao na kʼraa mame. Tna bi sait kbe ysan kukek wait ye. Kukek na kbe masen mafa msya maja wana ye. Tna msan maja wana kʼraa mame ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Anu ro kro Jõ fo, kbe raa beta knait anu. Menohe awya ro bito kro Jõ snok mam tis rau to, kbe ait retait ykai riof ro mase. ");
INSERT INTO ayz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ati ro raa sikowah anu mam remo sau to, nsam nmoʼt remo roto taro. Jõ tawe kʼanu tawe, ‘Jõ fi “Ait ro Yroh Yama Yfi Raa Sai”.’ Kbe anu nmo nur ntan mam kota makin ro Israel. Nmo mkak fefares to, kbe Jõ tama. ");
INSERT INTO ayz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kuber sait ja yase yiwer guru rait fee. Tna sryan sait ja yase yiwer bobot rait fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Soh kuber sait yawe yasen ynan guru rait to, mnan oh. Feto ye soh sryan sait yawe yasen ynan bobot rait to, mnan ye oh. Jõ tfi raa yabi ro yno bo moof sait. Tna Jõ tase tbo raa ro mhau mam amah aJõ. Menohe raa baro sioh mawe Jõ tasom Beelzebul. Raa sioh mawe Jõ tfi kabes yabi (Iblis). Anu nfi ku woJõ. Feto kbe meen raa sioh mawe anu nfi kabes yabi ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Waa raa weto ma. Soh raa mno bo ro mkair aro, ja ana mmyõt bo reto. Ana mmyõt bo reto afo re raa mmat fee tna mhar fee. Menohe bo weto beta meen raa masbrer tu oh. Kbe raa mmat tna mhar. Bo ro raa mmyõt to, meen raa masbrah kʼraa tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tna bokyas ro Jõ tkyas kʼanu kar to, nmo nkyas abyõ afo re raa beta mari ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Soh raa mama mame anu to, waa ma. Raa matak mame anu netsu wanu sai. Ana matak re kbe mame anu nmos wanu fee. Menohe waa Allah. Ait Raa ro yatak yame raa metsu wana ye msya raa mamos wana ye mam tafoh ro mait mam rabin kair to. ");
INSERT INTO ayz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ruu mbas to, mabyoh rau mroh sai. Ruu mbas mana ewok to, raa moo mkah pitis mauf sau aran sai. Menohe Allah ja kmot ana kaket. Ait bitsre sau btek ni-nan bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Anu nbyoh ranu to, maut toni miwer ruu mbas mabyoh rau. Feto to waa ma. Nna mawyan wanu to, Ait ntuu beta mnan oh. Ait ymat anu kaket. Feto to waa ana ro mawe mame anu to ma. ");
INSERT INTO ayz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hrenaut Jõ ma. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Awya ro ykyas abyõ kʼraa roto yawe, ‘Jõ smot Yesus’ to, kbe meen Jõ tkyas ait abyõ kʼTaja ye. Tawe, ‘Ait retait raa aJõ oh metait.’ ");
INSERT INTO ayz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Menohe awya ro ywaar Jõ kʼraa roto yawe, ‘Jõ smot Yesus fee’, Meen Jõ twaar ait ye. Tkyas kʼTaja tawe, ‘Raa retait tait raa aJõ metait fee.’” ");
INSERT INTO ayz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nnaut nwe Jõ tamaʼt tabam refo re tisoh iranya raa msya raa anya to fee. Jõ tama tibyo raa taro mawe ana mban Jõ. Tna raa taro mamo byoh kʼJõ. Tisti raa mafa meto. ");
INSERT INTO ayz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Jõ tama fo, ‘betwat ku sait ybam yaja. Tna kbe ku sau ntwat mbam mme. Tna fai sau ntwat mbam snyim ro ano. ");
INSERT INTO ayz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ana ro mhau su mam amah ranu taro to, kbe masen mamo byoh kʼanu.’ ");
INSERT INTO ayz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tna awya ro yawyan marak yaja to, tna yawyan marak yme to, menohe ait yawyan marak Jõ toni fee; ait retait yatak yamo raa aJõ metait fee. Feto ye soh awya ro yawyan marak ku ro sme rait msya ku ro ano rait bo toni miwrek Jõ to; ait retait yatak yamo raa aJõ metait fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Awya ro yawe kro Jõ to, menohe hawe bo yasom bo fanes ro mama mai kʼait to fee ye; ait retait yatak yamo raa aJõ metait fee. Soh ait yasom ara warok rait reto ye tna ait kro Jõ ye; ait retait yamo raa aJõ. ");
INSERT INTO ayz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Raa taro mawe misoh metsu rana ai mam tabam refo. Ana saso riof rana mam tabam refo sai ai menohe ana mnaut mamos rana fee. Meen ana weto mhau hame wajin fee. Menohe raa taro mawe mhau saso riof rana ai mam tabam refo fee. Ana mawe mno bo woJõ. Ana saso Jõ tasom aJõ mam tabam refo. Ana weto oh mi kbe mkai riof kʼana. Ana kbe meen raa mame majat oto, menohe meen mkai riof ro hame wajin. ");
INSERT INTO ayz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Feto ye, awya ro yitrah yhaf rait kʼanu to, ait retait yitrah yhaf kʼJõ oh meto. Tna awya ro yitrah yhaf rait kʼJõ to, ait retait yitrah yhaf kʼAit ro ybis Jõ tama ye oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Awya ro huwya yiranya ysya nabi ro Allah wAit sait to, kbe boren rait mase, mfi boren ro nabi ye. Tna awya ro huwya yiranya ysya raa ro ja yno bo moof to, kbe boren rait mase ye mfi boren raa ro ja mno bo moof weto ye. ");
INSERT INTO ayz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tna awya ro ymat raa woJõ tibyo yatmof ana to, kbe Allah yoo boren yaren ait tu oh. Nnaut oh; Allah ymat bo bawya ro anu nno sai: Mfi bo raa kinyah aJõ sait yhai sbit to, awya ro ywyan aya yee kʼait yata to, kbe Allah yaren ait ye.” ");
INSERT INTO ayz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus ykyas bo kuber wAit mabo 12 weto mkak oh. Tna Ait yasen sikba yuk reto yamoʼt remo makin ro kene mam weto ye. Yamo ykyas Watum ro Allah tna wosa Bokyas Moof kʼraa makin ro mhau mam beto sor ye. ");
INSERT INTO ayz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohanes ro ja baptis raa tait yhau mam bui fares. Ait yari bo ro Kristus yno feto, tibyo Yohanes ybis kuber wait mamo mo kʼKristus tna mtu bo kʼAit mawe, ");
INSERT INTO ayz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Nyõ fi Mesias ro tiwya Allah ysi yawe kbe yama oh mefi, fe mfe a? Soh mfe, kbe amu ste raa roto sait hayah a?” ");
INSERT INTO ayz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Menohe Yesus yawe, “Hah ne nmo no kʼYohanes tna nkyas bo ro anu nmat tna nri kʼait. Nwe: ");
INSERT INTO ayz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Raa ro masu mboh to, mfo refo ana mmat bo. Raa ro maa mhai to, mfo refo ana masen mamo. Raa ro mafa kusta to, mfo refo ana mrok moof. Raa ro mimara mtuk to, mfo refo ana mari bo. Raa ro mhai to, ana mrok masen. Tna raa ro masu awe to, mari Bokyas Moof ro mbam kʼAllah.’ ");
INSERT INTO ayz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Raa taro mmat bo ro Jõ tno tna beroh smot Jõ. Ana mwaar Jõ fee. Kbe ana weto simaut mase.” ");
INSERT INTO ayz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kuber ro Yohanes wait hah mamo. Tna Yesus yasen ykyas Yohanes kʼraa msis-sas weto. Ykyas yawe, “Tiwya anu nmoʼt yuk ro riamo nwe nmat Yohanes. Nmo to, anu nnaut nwe nmat bawya meto? Anu nmo nmat nkrum ro foos mfi matu wewe mamo-me a? ⌞Mfe, Yohanes retait raa ro yros yatak. Ait raa ro sneh sai fee.⌟ ");
INSERT INTO ayz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tiwya anu nmo nmat ait mkah bawya? Anu nmo nmat bobot sait ro yyum ratan ro fyan-fyan fe mfe a? Mfe ye, bobot ro yyum ratan ro moof to, ja yhau bait mam amah ro moof mfi raja na ja mhau. ");
INSERT INTO ayz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tawe kʼanu u tawe; anu nmo saso bawya mam tabam ro riamo reto to? Anu nmo saso nabi ro Allah ybis yama fe mfe a? Ae! Yohanes tait nabi ro Allah ybis yama. Ait yase yiwer nabi na roto ye. ");
INSERT INTO ayz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohanes retait oh mi tiwya Allah ykyas mam Bokom rAit sau. Bokom reto mawe, ‘Meen Jõ tbis raa sait yama ykyas bo woJõ yatim wia tna Nyõ nrof. Kbe ait siwyan iso kʼNyõ.’ ");
INSERT INTO ayz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nnaut oh: Raa ro tabam refo aro mase miwrek Yohanes Pembaptis fee. Menohe raa mana ro Allah yamo Raja ybo to, ana ro kinyah to, ana beta mase miwer Yohanes. ");
INSERT INTO ayz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Maban ti tinyi rau wore wo Yohanes yama baptis raa, mamo snok mam mfo refo fo, raa byoh srau kair kʼraa mana ro Allah ybo. Raa byoh mawe masen mfot raa mana ro Allah rAit. He mfe, raa mana rAit mo mase renti. ");
INSERT INTO ayz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tiwya Watum ro Musa msya nabi sor ro Allah ybis mama oh mi mkyas bo ro Allah mawe kʼraa. Ana oh mi mkyas bo rAit mama snok mam mfo refo. Tna Yohanes yama. ");
INSERT INTO ayz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jõ tawe kʼanu tawe, ‘Yohanes tait Elia oh metait.’ Anu nri fe mfe a? Jõ sioh fee. ");
INSERT INTO ayz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Anu ro nri bokyas refo fo; nnaut kaket!” ");
INSERT INTO ayz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tna Yesus yawe, “Raa ro mhau mfo refo to, mfi awya? Jõ fret bo tawe anu fo nfi kukek: Anu nnan kukek ro hre mam pasar. Ana baro mawe kʼanya mawe, ");
INSERT INTO ayz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Riwai anu bsom-sam mnan fi anu bkyõ bokyõ: Amu nfi oor, tna nji howes ye, afo re kbe anu nsyoh bosyoh. Menohe anu nsyoh fee! Tna fo anu sioh bsom bfi raa ro mhai, menohe anu taro hawe bo nwia hai reto! Nsom nno fyi!’ ");
INSERT INTO ayz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohanes yama to, ait yhau bo yait msya bo yata ye. Tibyo raa mawe, ‘Kabes mbo ait’. ");
INSERT INTO ayz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tna jõ tama. Jõ fi, 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ tama tna tno bo tfi Yohanes fee. Jõ tama to, ja thau bo tait fee. Tna tata anggur maya ye. Menohe anu nwe kair Jõ nwe, ‘Ait retait yait boit yasmamo! Ait retait raa ro ja yata anggur maya bisir yoyo! Tna yafoh wAit to, raa ro ja mno iro msya raa ro ja mno bo ro mkair sor: Raa ro moo namabyoh (pajak) mee kʼpemerintah bo ye!’ Menohe Jõ tawe kʼanu tawe, ‘Nnaut bo moof ro Yohanes ysya Jõ nno to, tna kbe anu nhar nwe Allah oh mi ybis amu bewok nma to.’” ");
INSERT INTO ayz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesus yno bo ro msai mawat mam remo ro Khorazim msya remo ro Betsaida. Raa ro mhau mam remo weto mmat bo ro Ait yno. Menohe ana mashana fee. Feto to Ait kmo. ");
INSERT INTO ayz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ait yastako ana yawe, “Anu raa ro Khorazim nsya raa ro Betsaida: Meen ayoh mroh kʼanu! Tiwya Jõ tno bo ro msai mam remo wanu weto, menohe anu nashana fee. Soh tiwya Jõ tno bo ro msai weto mam remo ro Tirus msya Sidon, maami raa ro mhau mam beto mashana iro wana bose oh. Soh ana mmat bo ro Jõ tno weto to, ana sraujin tibyo myum ratan ro mkair tna mse boh ro tafoh mam mana wana abyõ. ");
INSERT INTO ayz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jõ tawe kʼanu tawe, ati ro Tuhan yoo safo mana ymit kʼraa to, kbe Ait ymat raa ro mhau mam remo weto tna yawe yno bo maku sai mbtek mai kʼana. Menohe anu niwana Ait tibyo bo ro kbe meen mbtek mai kʼanu to samyoh toni! ");
INSERT INTO ayz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tna anu ro nhau mam remo ro Kapernaum nnaut nwe meen anu beta nmoʼt sawro ro Allah rAit. He mfe, kbe meen anu nmoʼt sawro ro kabes! Tiwya Jõ tno bo ro msai mam kota ranu ro Kapernaum. Mfi bo tno bo ro msai weto mam kota ro Sodom, maami raa weto mmat tna mashana fea! Tna kota reto mhau fares ye. ");
INSERT INTO ayz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Menohe Jõ tawe kʼanu tawe; ati ro Allah yoo safo mana ymit kʼraa to, bo ro meen mai kʼraa ro Sodom to, mnan-an baro ye. Menohe bo ro meen btek mai kʼanu to samyoh toni.” ");
INSERT INTO ayz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tna Yesus skabuk yawe, “Taja, Nyõ fi Tuhan ro nase. Nyõ to, nbo sawro aNyõ msya tabam refo ye. Tna Nyõ nmyõt bo aro re raa wase maja wau weto. Bo weto to, raa ro ja mhar bo to, ro mkom bo to, ana srau fee. Ana mfot fee. Menohe bo weto to, nyõ nerif kʼraa kinyah re ana mfot tna mhar. Feto to, tayoh asik mase kʼNyõ. ");
INSERT INTO ayz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Taja; Nyõ nhar bo Nyõ oh. Tna ja nno bo ro Nyõ nhaf mnan sai.” ");
INSERT INTO ayz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tna Yesus yawe kʼraa wAit weto yawe, “Bombra beta to, Taja ysan kʼJõ tatem tbo oh. Raa wase Jõ. Taja yesait aran yhar Jõ. Tna raa wase Taja ye. Menohe Jõ tesait thar Ait. Tna raa ro Jõ tsok to, tkyas Ait kʼana weto re kbe ana mhar bi Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Anu taro nsom bo fanes tna hrowyõ nhai. Nma kro Jõ tna Jõ smyoh bo ro samyoh ro anu nsom weto sor. ");
INSERT INTO ayz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nmat sas bo ro Jõ tno tna nbo nno ye. Jõ fi Raa ro thaf moof tna thaf sneh ye. Feto to, kbe nmos wanu mhau tnok ye. ");
INSERT INTO ayz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bo ro Jõ tbis kʼanu nno to mnan-nan sai. Tna bo ro Jõ tse kʼanu nsom to samyoh fee ye.” ");
INSERT INTO ayz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ayõ ro Sabat to, ja raa ro agama Yahudi ntmoh. Tna ayõ ro Sabat sau to, Yesus ysya kuber wAit mamo mfrit iti mam armato ro gandum sau. Kuber wAit mhai sre, tibyo mryoh gandum make baro mait. ");
INSERT INTO ayz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Menohe raa ro Farisi mmat feto, tibyo mawe kʼYesus mawe, “Yesus! Nmat kuber woNyõ mno bo toto sai meto a? Ana mryoh gandum make mam ayõ ro raa wanu ntmoh to. Ana mno fyi meto? Mno bo reto to, ana miwer Watum ro agama ranu oh meto!” ");
INSERT INTO ayz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tna Yesus yawe, “Anu nsorni Bokom ro Allah fe mfe a? Bokom reto mkyas bo ro tiwya raja Daud yno. Tiwya ait ysya raa wait mhai awyah. ");
INSERT INTO ayz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tna ait twok mam Samu ro Allah mato. Tna yoo roti ro raa msan kʼAllah. Roti reto mbau. Menohe ait yoo yait. Roti reto ja imam na mesait aran mait. Menohe ait yoo tna yee kʼraa wait mait ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ja anu nmat Watum ro Musa fefares a? Watum reto mawe ye mawe, ‘Nno bo mam ayõ ro raa ntmoh to ma.’ Menohe imam ro Allah to, ana beroh mno bo mam Samu ro Allah, menohe Allah ymat bo ro ana mno reto to, tna yawe bo reto mkair fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Anu nhar nwe Samu ro Allah to moof tna yase ye. Menohe anu wase Ait sait ro yama yhau ysya anu. Ait retait yase toni yiwrek Samu ro Allah. ");
INSERT INTO ayz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bokom ro Allah mawe, ‘Noo bo wanu taro nsan kʼJõ to, reto moof. Menohe jõ ksoh tawe anu natmof raa anya; reto to moof toni.’ Hosea 6:6 Allah ymat kuber woJõ to yawe bo ro ana mno reto mkair fee. Soh anu nhar Bokom reto kaket to, maami anu nkyas bo mkair mai kuber woJõ fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jõ fi ‘Ait ro Yroh Yama Yfi Raa Sai.’ Jõ tatak tbo ayõ ro raa ntmoh ye. Feto to, nwe kuber woJõ wefo mno bo ro mkair to ma.” ");
INSERT INTO ayz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tna Yesus sikba wore weto tna yasen yamoʼt samu watum rana. ");
INSERT INTO ayz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tna raa sait ro yatem jaro mhai huwya mam beto ye. Ana ro Farisi baro mmat sas Yesus tna saso bo mkair ro Ait yno. Tibyo ana mtu bo kʼAit mawe, “Soh raa misoh raa kiyam moof mam ayõ ro raa ntmoh to, ana miwer Watum ro Musa ykom oh meto, fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Menohe Yesus yawe si yawe, “Mfi bo anu nkin wefo sait ymat domba rait sau btek kayah. Mbtek kayah mam ayõ ro raa ntmoh to, kbe raa retait sna ykuk maut fee mfe a? ");
INSERT INTO ayz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Raa to ati, tna domba to bo ro ati fee sai. Feto to, soh raa mno bo ro moof kʼraa roto mam ayõ ro raa ntmoh to, ait yiwer Watum ro agama ranu fee.” ");
INSERT INTO ayz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tna Yesus yawe kʼait ro yatem mhai retait yawe, “Betrot natem anyõ!” Raa retait betrot yatem rait. Tna yatem mrok moof mfi yatem jaro to ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Raa ro Farisi mmat feto tibyo masen frok mamo. Mamo saim bo mawe saso iso re kbe mame Yesus yajat. ");
INSERT INTO ayz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Menohe Yesus yhar raa ro Farisi mhaf wana, tibyo Ait yirenti yamoʼt rabin roto sau. Raa msis-sas kro Ait tna Ait yisoh ana ro kiyam. Tibyo kiyam wana marak beta ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tna fo Ait yawe wa kʼana yawe ana masbrah Ait kʼraa roto ma. ");
INSERT INTO ayz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ait yno bo weto to, afo re yno mnan si bokyas ro tiwya Allah ybis nabi Yesaya ykyas tinyi wia yawe: ");
INSERT INTO ayz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Raabis aJõ oh mefi. Jõ thafri Ait. Ait tait Jõ thaf mnan. Kbe too Har aJõ tse kʼAit. Tna bo ro Jõ ksoh to, kbe Ait wosa kʼraa makin ro wase Jõ fares ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kbe Ait ymak ysya raa fee. Kbe Ait safuk tawyõ Ait bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kbe Ait yhaf sneh kʼraa ro ssafo fee. Ana mfi krum ro foos mfi matu wewe. Kbe Ait yno feto mamo snok mam ati ro Ait yno bo ro Jõ ksoh mkak beta. ");
INSERT INTO ayz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mkah Ait yasom rAit to, raa ro bangsa sor kbe mhau mhaf minaut kʼAit mawe meen Ait yoo riof yee kʼana.” ");
INSERT INTO ayz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tna raa makah ait ro kabes mbo sait mama mo kʼYesus. Ait retait ymai marak tna yasu mboh ye. Tna Yesus yisoh ait yoof. Tibyo yrok ymai ye tna yasu maah ymat bo ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tibyo raa makin ro mros sor mam weto to, mrok ktak sai tna mawe, “Yesus fi Ku ro Daud fe mfe a? Ait ro tiwya Allah ysi rene mefi fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Menohe raa ro Farisi mari feto. Tna ana mawe kʼanya mawe, “Aha! Yesus yatak yikyak kabes sor mkah tak ro kabes Beelzebul rait. Kabes Beelzebul retait ja yase ybo kabes taro sor.” ");
INSERT INTO ayz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Menohe Yesus yhar bo ro ana mnaut reto tna yawe, “Soh raja ro rabin sait ybo raa wait, menohe ana mafa anya ai to, kbe rabin mros matak fee. Tna raa ro mhau su mam remo sau to, soh ana mafa anya ai to, kbe ana mros matak fee ye. Tna raa ro mhau mam amah sau su to, soh ana mafa anya ai to, kbe ana mros matak fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tna soh kabes yabi yikyak kabes wait taro to, kbe rabin ro kabes yabi yamo raja ybo to, kbe mros matak fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Anu sioh nwe, kabes Beelzebul (Iblis) yoo yatak rait yee kʼJõ oh mi Jõ tatak tikyak kabes weto sor. Menohe raa wonyõ taro ja mikyak kabes ye. Awya oh mi yoo yatak rait yee kʼana to? Anu nwe kair raa wanu meto ye! Kbe ana kmo anu mawe, ‘Mfe, Har ro Tuhan moo matak rAu mee kʼanu mefo!’ Feto to, bo ro anu nwe kʼJõ reto to, mkair sai meto. ");
INSERT INTO ayz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Har ro Tuhan oh mi moo matak rAu mee kʼJõ. Tibyo Jõ tatak tikyak kabes frok to. Allah ybis Jõ tama tbo raa mana rAit to. Feto to, Ait ro yase ybo raa wait yhau ysya anu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Jõ fret bo reto u tawe, Kabes yabi yfi raa ro yatak sait. Ja raa ter-ter twok mam amah rait fee tibyo ytak bo wait fee ye. Menohe soh raa make ait yaa yatem wia saah. Tna fo raa retait ytak bo ro mhau mam amah mato reto. ");
INSERT INTO ayz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Awya ro yhaf sau ysya Jõ fee; ait retait yamo byoh tna yno bo ro mkair mai kʼJõ. Awya ro ysya Jõ yno bo woJõ su fee; ait retait sbi hri bo ro Jõ tno ye oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Feto Jõ tawe kʼanu tawe, soh raa mno iro bawya sai to, kbe Allah yyon iro wana weto. Soh raa mamus Allah to, kbe Allah yyon iro wana weto ye. Menohe soh raa mamus Har ro Allah to, kbe Allah yyon iro wana fee yum. ");
INSERT INTO ayz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Soh raa sait yawe kair Jõ to, kbe Allah yyon iro rait reto. Menohe soh raa sait yawe kair Har ro Tuhan to, kbe Allah yyon iro rait reto fee yum. Kbe Allah yyon iro reto mam makyon refo fee, tna mam makyon ro meen mama fee ye.” ");
INSERT INTO ayz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tna Yesus ykyas kʼraa ro Farisi weto u yawe, “Kake mara ro moof to, kbe make rau to moof ye. Tna kake mara ro mkair to, kbe make rau to mkair ye. Ja make oh mi raa mhar mara rau to. ");
INSERT INTO ayz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Anu fo raa ro ja mno bo mkair mfi aban ro mafit raa majat! Anu nhaf mato wanu to mkair. Feto fyi re kbe anu nkyas bo ro moof to? Ja raa mkyas bo mamyot si mhaf wana. ");
INSERT INTO ayz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Raa ro yhaf moof to, ja bo ro moof mbam yhaf mato rait frok. Tibyo bo ro yno to moof. Tna bo ro ykyas to moof ye. Tna awya ro yhaf mkair to, ja bo ro mkair mbam yhaf mato rait frok ye. Ait yhaf mato mkair sai. Tibyo ja yno bo ro mkair tna ykyas bo ro mkair ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tna Jõ tawe kʼanu tawe: Ati ro Allah ytu srah to, kbe raa sait sait yros betoo bo ro tiwya ait ykyas-kas to beta. ");
INSERT INTO ayz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ati reto to, anu ro tiwya nkyas bo ro mkair-kar to, kbe safo makan reto btek mai kʼanu. Feto ye anu ro tiwya nkyas bo ro moof to, kbe safo makan reto btek mai kʼanu fee.” ");
INSERT INTO ayz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ati reto raa ro Farisi baro msya guru agama Yahudi baro mawe kʼYesus mawe, “Amu ksoh Nyõ nno bo ro msai sau re amu nmat.” ");
INSERT INTO ayz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tna Yesus yawe kʼana yawe, “Anu raa mana ro mfo nhau mam tabam refo fo, anu ja nber safo tna kro Allah kaket fee wofo! Anu nwe Jõ tno bo ro msai aro re kbe anu nhar nwe Jõ tbam kʼAllah tama fe mfe a. Menohe Jõ kbe tno bo ro msai sau aran sai re anu nmat tna nhar: Kbe anu nmat bo msai ro mnan fi tiwya Allah yno mkah nabi Yunus sai. ");
INSERT INTO ayz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tiwya Yunus yhau mam syoh ro mase sau mhaf rau ti trion tuuf. Feto ye mkah Jõ. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen Jõ thau mam yuk ro hai ja mhau to ti trion tuuf ye. ");
INSERT INTO ayz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ati ro meen Allah ytu srah to, raa ro tiwya tinyi mhau mam kota ro Niniwe to, kbe mrok masen ye msya anu raa mana ro mfo nhau mam tabam refo. Tna kbe ana weto mkyas bo mai kʼanu. Tiwya raa ro Niniwe mari bo ro Yunus ykyas reto. Tna ana mashana. Ait ro yhau mam befo fo, yase toni yiwrek Yunus ye. Menohe anu sor nashana fee! ");
INSERT INTO ayz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tiwya fnya manes (ratu) sau mhau mam rabin ro ati ti wayir sau. Tna au mbam rabin ro fari reto masen mamo mo kʼraja Salomo mawe mari bokyas rait. Raja retait tait raa ro yhar bo toni. Mfo refo, Raa sait ro yase yiwer Salomo retait yhau ysya anu. Menohe anu hawe bo nri bokyas rAit. Feto to meen fai au reto kbe masen mmit safo kʼanu raa ro nhau mfo wefo.” ");
INSERT INTO ayz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tna Yesus yawe, “Ati ro raa mikyak kabes sau frok mbam raa sait mamo to, kabes reto mamo ninya. Mamo ninya mam wore wo aya aro fee. Mawe sne hoh menohe kabes reto fri yuk ro moof aro fee. ");
INSERT INTO ayz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tibyo kabes reto mnaut mawe, ‘Jõ tawe thah te tamoʼt yuk ajõ ro wia rof, ro tiwya jõ sikba akus.’ Tna kabes hah me snok mam yuk reto u. Tna mmat he ‘amah’ reto raa misoh moof, tna raa aro satoh mama mhau mam beto wea fee. ");
INSERT INTO ayz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Feto tna kabes reto mawe hah mamo mhau. Tna mmen mafoh na mabo trion krema mama mhau msya au ye. Kabes trion krema weto to ja mno bo ro mkair-kar toni miwer kabes ro tinyi reto. Tna ana mama twok raa retait beta ye. Tna kbe ana mno ait retait ykair toni yiwrek kair ro ait ykai tinyi wia ye. Anu raa ro mfo nhau mam tabam refo tna nno safo to, kbe anu nfi feto ye.” ");
INSERT INTO ayz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus ykyas bo kʼraa makin taro kri-kri fo, yme msya yao na mama mros mne. Ana mawe mkyas bo msya Ait. ");
INSERT INTO ayz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tna raa sait yama yawe kʼYesus yawe, “Nme msya nao na mros ste Nyõ mne meu. Ana mawe mkyas bo msya Nyõ.” ");
INSERT INTO ayz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Menohe Yesus yawe si kʼait retait yawe, “Jõ tme to awya? Jõ tao na to awya?” ");
INSERT INTO ayz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tna Yesus yerif kuber wAit yawe, “Ana oh mi Jõ tme msya tao na mefo. ");
INSERT INTO ayz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Taja yhau mam sawro rAit. Tna awya ro ja yno bo ro Taja ksoh to, Jõ ttu tawe tao, tano, msya tme oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tna fo Yesus sikba amah reto tna yamoʼt maru maam. ");
INSERT INTO ayz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Raa msis-sas mama hre mur mtan kʼAit. Ait ymat feto, tibyo yasen yamo yaut hre mam wiak mato. Tna raa msis-sas weto ana mros sai mam aya maam. ");
INSERT INTO ayz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tna Yesus ykyas bo mawat kʼana mkah bofret yawe, “Raa sait yno armato rait sau. Tna ait yamo furere bobat manaf (benih). ");
INSERT INTO ayz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ait furere bo to, bo manaf taro mbtek mam iso. Tibyo bo manaf weto to, ruu mama mame mkak. ");
INSERT INTO ayz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tna taro to, mbtek abyõ mam tabam ro fraa mhau wa mte. Tna mtis mame tabam kaket fee. Tibyo bobat weto moo fooh sai. ");
INSERT INTO ayz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Menohe wore wo ayõ mo maut mafit to, bobat weto hroyoh. Mtis mo mame tabam kaket fee, tibyo samer. ");
INSERT INTO ayz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tna taro naut mbtek ye mam wore hyoh mana. Tna hyoh mana weto mo betru kait. ");
INSERT INTO ayz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tna taro mbtek mam tabam ro mamos. Tna mo maut. Tibyo make sarer toni: Bo manaf sau-sau to, make rau trion 30. Taro to, make rau trion 60 ye. Tna taro to, make rau trion 100 ye.” ");
INSERT INTO ayz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tna Yesus yawe, “Anu ro nri bokyas refo fo; nnaut kaket!” ");
INSERT INTO ayz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tibyo kuber wAit mama mtu bo kʼAit mawe, “Nyõ nkyas bo mkah bofret kʼana nno fyi?” ");
INSERT INTO ayz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tna Yesus yawe si kʼana yawe, “Raa mana ro Allah yamo Raja ybo to, maja wau baro to, raa wase fares. Raa ro ja hawe mari Jõ to, ja Jõ tkyas mkah bofret sai kʼana. Menohe Allah ksoh re anu nsrau nfot maja wau weto. ");
INSERT INTO ayz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Awya ro yawe yari tna ybo yno bo ro Allah yawe to, kbe Allah yoo bohar taro naut yiryõ kʼait ye. Kbe Allah yno re ait retait yasu maah. Tibyo kbe ait yhar bo ro Allah mawat. Menohe awya ro yari tna hawe yse mam yhaf kaket to, kbe Allah yno re bohar rait to mabuf sai. ");
INSERT INTO ayz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","14","Ana ro hawe mari Jõ to, ja Jõ tkyas bofret kʼana sai. Ana to raa ro Allah tiwya ybis nabi Yesaya ykyas tna ykom matim yawe, ‘Raa kbe mmat sas bo refo. Ana mmat sas menohe wase bo reto fares. Ana kbe mari bo refo. Ana mari, menohe srau fee ye. Ana mari yoyo, he mfe. Ana mmat sas bo yoyo, he mfe ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ana mhaf matak. Tna mimara mtuk sai. Ana masu mboh tibyo mmat bo fee. Ana hawe bo mashana hah me mama mo kʼJõ afo re tisoh ana tno ana masu mmat bo, re kbe mimara mari bo, tna re ana moo Watum aJõ mse mam mhaf wana.’” ");
INSERT INTO ayz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tna Yesus yawe kuber wAit yawe, “Tuhan yno re anu nsu maah nmat bo. Tna Ait yno nimara wanu moof nri bo kaket ye. Feto to kbe anu nhau simaut mase. ");
INSERT INTO ayz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jõ tawe kʼanu tawe: Tiwya nabi na mama mkyas bo ro Allah. Ana weto msya raa ro ja mno bo ro Allah ksoh to, ana mawat ksoh mawe mhar bo refo. Ana ksoh toni mawe kbe mmat bo ro anu nmat wefo ye, he mfe. Tna ana mhaf miyoh mari bo ro anu nri wefo ye, he mfe ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nri; Jõ betoo bofret raa ro furere bo manaf (benih) mam armato rait to, tkyas mabo rau mefo: ");
INSERT INTO ayz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","‘Bo manaf’ reto to bokyas ro mkyas wore wo Allah yamo Raja tna ybo raa wAit. Tna ‘bokyas’ reto ro btek mam iso to, mabo rau mefo. Bokyas reto raa taro mari, he mfe. Ana weto mfot bokyas reto kaket fee. Mari menohe kabes yabi (Iblis) yama tna safto bokyas mbam kʼana mhaf wana. ");
INSERT INTO ayz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tna tkyas bo manaf ro mbtek abyõ mam tabam ro fraa mhau wa mte: ‘Bo manaf’ weto to, mkyas raa ro mari Bokyas ro Allah si fo, simaut mase. ");
INSERT INTO ayz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Menohe Bokyas reto ana moo mse mhau mam mhaf mato wana waor sai. Ana mbo matak fee. Raa roto mmat bosmot wana tna sikowah ana. Feto tibyo ana mbtek mawe, tna smot Tuhan u fee. Ana weto taro to, bo ro samyoh mama mai kʼana to, tibyo ana mbtek mawe, tna smot Tuhan u fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","‘Bo manaf’ ro mbtek mam wore hyoh mana to, mkyas raa ro mari Bokyas ro Allah ye. Menohe ana mhau to, mnaut yyi. Tna ana mnaut bosatoh ro moof mam tabam refo sai. Tna ana nksoh mhau moof bana mam tabam refo sai. Bo weto moo ana mhaf re ana mnaut Bokyas ro Allah fee. Tibyo bosmot wana matak fee. Ana tufrok make aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tna tkyas bo manaf ro mbtek mam tabam ro mamos. Ana weto mari Bokyas ro Allah reto, tna mse kʼana mhaf. Tna tis rau to, kbe make mawat: Taro make rau trion 100. Tna taro make rau trion 60. Tna taro make rau trion 30.” ");
INSERT INTO ayz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tna Yesus ykyas bofret sau naut u yawe, “Allah yamo Raja ybo raa mana rAit to. Ait yfi bi sait yamo furere benihgandum ro moof mam armato rait. ");
INSERT INTO ayz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tna ti sau raa mjin beta fares to, ait ro yamo byoh sait yama. Ait yama furere bibit bosafom srioh benihgandum ro riwai bi ait ro armato rait furere wia. Ait ro byoh retait furere bibit bosafom tna ysam yamo bait yarak. ");
INSERT INTO ayz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gandum reto mo tna mse saker. Tna sryan bi yabi retait, baro mamo mmat armato rait reto. Ana mmat he gandum reto bosafom mo srioh ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tna ana mama mawe kʼait mawe, ‘Bi yabi; tiwya nyõ furere benihgandum ro moof mesait aran no? Menohe bosafom mo ye! Bosafom ro mo srioh ye reu mbam hayo meu?’ ");
INSERT INTO ayz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bi ait yawe, ‘Byoh sait yama yno meto!’ Tna sryan wait mtu kʼait mawe, ‘Fyi, amu nmo nfit bosafom weu beak fe mfe a?’ ");
INSERT INTO ayz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Menohe bi ait yawe wa yawe, ‘Mfe, nmo nfit ma! Kbe anu nfit sre mkah gandum taro u srot kro ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Betau bosafom reto mhau moo srioh gandum su. Tna ati ro gandum manes tna raa saraf to, kbe jõ tawe kʼraa ro saraf to tawe, “Nakrao bosafom kehamit nse mam wo sau ngkaat wia afo kbe raa mkah. Tna fo nsok gandum nse hayah. Tna nwia gandum nmo nbu mam amah ro jõ siwyan mkah bo tbu bo mafer sor to.”’” ");
INSERT INTO ayz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tna Yesus ykyas bofret kʼana u yawe, “Kbe Allah yamo Raja tna ybo raa mana rait. Reto mnan fi bo manaf (benih) ro maku sau. Bi sait yoo bo manaf reto yamo furere mam armato rait. ");
INSERT INTO ayz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bo manaf reto, maku koweh syok. Bo manaf roto taro to, makan rau to mase baro ye. Menohe bo manaf ro maku reto mo tna mrok mase miwrek bosafom roto taro sor. Tna mo maut mfi ara bo feto ye. Tibyo ruu mama tafat abyõ mam ara reto kre ye.” ");
INSERT INTO ayz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tna Yesus ykyas bofret roto sau kʼana naut yawe, “Raa mana ro Allah yamo Raja ybo to, mnan ragi. Tna fai sau moo ragi kebet baro, sryoh msya tepung mawat. Feto kbe adonan reto mrok mtar mase beta.” ");
INSERT INTO ayz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus ykyas bo weto beta kʼraa msis-sas weto mkah bofret sai. Ja ykyas bo roto kʼana fee. ");
INSERT INTO ayz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ait yno feto afo re yno bo mnan si bo ro tiwya Allah ybis nabi sait yama ykyas tinyi wia yawe, “Kbe Jõ tkyas bo mkah bofret. Bo refo ja raa wase. Tii oh oh, mam wore wo Allah yfen tabam refo, mamo snok mam mfo refo to, ja raa wase. Menohe Jõ tama tasbrer bo weto.” ");
INSERT INTO ayz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesus sikba raa msis-sas weto tna yamo twok mam amah. Tna kuber wAit mama mtu bo kʼAit mawe, “Sik betoo bofret ro gandum riwai Nyõ nkyas kʼamu.” ");
INSERT INTO ayz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tna Ait yawe si kʼana yawe, “Raa ro furere benih gandum ro moof tait 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ fi Ait oh mefi. ");
INSERT INTO ayz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tna armato reto mkyas tabam refo. Tna benihgandum weto, mkyas mawe raa mana ro Allah rait, mam wore wo Ait yamo Raja ybo ana. Tna bibit ro bosafom weto mkyas mawe raa ro kabes yabi (Iblis) ybo mamo raa wAit. ");
INSERT INTO ayz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tna ait ro furere bibit ro bosafom tait mkyas mawe kabes yabi (Iblis). Tna ati ro raa saraf to, mkyas mawe tabam refo makyon sboh rau. Tna ana ro saraf to, mkyas mawe malaikat. ");
INSERT INTO ayz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Tna bosafom ro raa khamit mkah mait tafoh to, mkyas mawe raa ro kro kabes yabi. Meen ati ro tabam refo sboh rau to, 'Ait ro Yroh Yama Yfi Raa Sai' kbe ybis malaikat wAit mama. Jõ oh mi Ait ro ybis malaikat weto mama mefi. Ana mama tna moo raa ro mno bo mkair-kar msya raa ro misti re raa roto mno iro ye to. Malaikat weto kbe tufrok raa ro mkair weto mbam raa mana rAit. Moo ana weto mse hayah. ");
INSERT INTO ayz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kbe malaikat mawah ana weto beta beak mamo mait mam tafoh ro mait warah toni. Tna mam beto to, meen ana mkai bo ro mkair-kar tibyo mawia kanasyah ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tna raa ro mno bo ro Allah ksoh to, Ait yamo ana Maja rana. Kbe ana mhau mam raa mana ro Ait yamo Raja ybo. Kbe Allah fayir ana moof kaket. Fayir ana mfi bo ja Ait fayir ayõ ro moo maut rabu to. Anu ro nri bokyas reto to; nnaut kaket!” ");
INSERT INTO ayz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Raa baro tomer mamo raa mana ro Allah yamo Raja ybo to. Bo moof ati meto. Reto mfi kta ro mabyoh maut. Tiwya raa mabah saa kta reto mam armato sau te. Kta reto mhau makus mmyõt bau sai. Tna raa sait ykah armato reto tna ykai kta reto. Menohe ait ye yabah saa mam kya u. Tibyo simaut mase yamo tna yasim bo manhai wait beta. Ait yoo mabyoh rau to, tna yate tabam reto. Tibyo yoo kta ro mabyoh maut reto kʼait. ");
INSERT INTO ayz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Raa mamo raa mana ro Allah yamo Raja ybo to, bo moof ati. Reto mfi raa ro ja yasim bo yoyo sait. Ait yamo saso haban mutiara ro moof baro. ");
INSERT INTO ayz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tna ait ykai haban mutiara ro mabyoh maut toni sau. Tibyo ait hah ye yamo yasim bo manhai wait beta ska. Tna ait yoo mabyoh rau tna fo hah ye yama yoo haban mutiara reto.” ");
INSERT INTO ayz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Tkyas oon ro Allah meen yamo Raja ybo raa mana rAit mabu rau. Mabu rau to, mfi jala sau ro maboh. Raa beak jala mam maru tna mfot syoh aro rau-rau. ");
INSERT INTO ayz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Syoh mami jala reto matot tna raa tubat jala makah maut mamoʼt mne. Tna hre skur syoh weto tna mse aro hayah-hayah. Ro ja raa mabo to, ana msok mse mam keranjang. Tna ro ja raa mabo fee, ana beak mam aya makus. ");
INSERT INTO ayz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Meen makyon ro tabam refo sboh rau to, malaikat kbe mno feto ye. Meen malaikat msok raa ro ja mno bo ro Allah ksoh to, mse hayah. Feto ye raa ro ja mno bo mkair-kar to, malaikat msok tna mse hayah ye. ");
INSERT INTO ayz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tna fo malaikat mawah ana weto beak mam tafoh ro mait warah toni. Ana weto kbe mkai bo ro mkair-kar tibyo mawia kanasyah mam beto.” ");
INSERT INTO ayz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus betoo maja rau kuber wAit mkak tna ytu kʼana yawe, “Anu srau nnaut tna nhar bo ro Jõ tkyas weto oh fe mfefares a?” Tna ana mawe, “Ae, amu nhar oh.” ");
INSERT INTO ayz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tna Yesus yawe, “Bokyas ro mkyas raa mana ro Allah yamo Raja ybo to, soh guru agama mfot to, ana weto mfi bobot ro ja srak mse kta ro tna msya ro bose ye.” ");
INSERT INTO ayz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus ykyas bofret weto mkak tna Ait yasen sikba yuk reto. ");
INSERT INTO ayz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ait hah ye yamoʼt remo rAit. Tna Ait watum bo mam samu watum rana. Raa ro mari bo ro Ait ykyas weto mrok ktak mawe, “Ait tait raa sei sai yfi anu ye mefo. Awya ro oh mi ykyas watum weu kʼAit u ee? Tna awya yoo yatak rait yee re Ait yno bo ro msai weto? ");
INSERT INTO ayz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ait yaja tait raa ro ja yfen ara a? Tna yme fai Maria, tna yao na sor: Yakobus, Yusuf, Simon, tna msya Yudas fe mfe a? ");
INSERT INTO ayz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tna Ait yano na beta mhau mam remo ranu refo ye. Ait fri bo yase reu mbam kʼawya yatak meu?” ");
INSERT INTO ayz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ana hawe mari bo ro Ait ykyas. Tna Yesus yawe, “Nabi ro Allah ybis yama to, ja raa mari ait mam woyõ-woya yamo sai. Menohe mam remo rait yesait to, ja raa hawe mari ait. Tna raa ro amah rait to, hawe bo mari ye.” ");
INSERT INTO ayz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ana smot Ait fee. Feto tibyo Ait yno bo ro msai mawat mam remo rAit fee. ");
INSERT INTO ayz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ati reto to, raja Herodes ro ybo provinsi ro Galilea tait, yari bo msai ro Yesus yno. ");
INSERT INTO ayz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tibyo Herodes yawe kʼraa wait yawe, “Yesus fi Yohanes Pembaptis ro tiwya yhai tna yrok yasen oh! Reto oh mi Yesus yatak yno bo ro msai weto to.” ");
INSERT INTO ayz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tiwya raja Herodes ytak fnya ro yao Filipus rait. Fai au masom Herodias. Yohanes yari feto, tibyo yastako raja Herodes yawe yber safo oh meto. Tibyo raja Herodes kmo Yohanes tna ybis raa wait mamo mfot Yohanes make. Mfot ait tna makah mamo mbu mam bui mato. ");
INSERT INTO ayz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tna raja Herodes yawe yame Yohanes yajat, menohe raa makin mhar mawe Yohanes tait nabi ro Allah ybis yama. Tibyo Herodes waa yame Yohanes yajat. ");
INSERT INTO ayz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tna ati reto to, raja Herodes yakyõ hwiat rait ro tiwya yme mabe ait. Ana makyõ bokyõ reto to, ku ano ro fai Herodias rau masen smar. Ymat feto tibyo ksoh. ");
INSERT INTO ayz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tibyo ait yasen yawe, “Ayoh, bo bawya sai ro nyõ nayoh to, kbe jõ too tee kʼnyõ tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tibyo fai Herodias, masen misbyõ ku rau tna ku rau mawe, “Jõ tayoh raa mamo mame Yohanes Pembaptis yajat. Sbi yana tna masyõ ait yana abyõ mam baki sau, moo mama mee kʼjõ.” ");
INSERT INTO ayz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Raja Herodes yari feto, tibyo ynaut yyi. Menohe riwai ait ysi bo kawi oh. Yafoh na mari wia oh no, tibyo ait ye yabe u fee. Tna ait yno bo ro ku au mawe sai. ");
INSERT INTO ayz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ait ybis raa sbe sait yamo mam bui tna ktan Yohanes yana. ");
INSERT INTO ayz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tna raa sbe retait yoo Yohanes yana yse abyõ mam baki, yasyõ yakah yama yee ku au reto. Tna ku au reto makah mamo mee kʼmme mmat ye. ");
INSERT INTO ayz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tna kuber ro Yohanes wait mama moo ajat ro Yohanes makah mamo sama. Tna ana mamo mkyas bo reto kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus yari feto, tibyo Ait yaut wiak yamoʼt oo ro mimon. Menohe raa makin msis-sas mari bo Ait yamo feto. Tibyo ana mbam remo wana sor to, mamo iso mne twat maryõt Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus yamo snok mam maru maam jaro, tna Ait ymat he raa msis-sas mros wea. Tibyo Ait yatmof ana tna yisoh ana ro kiyam sor afo re kiyam wana marak. ");
INSERT INTO ayz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hreha reto kuber wAit mama mo kʼAit mawe, “Yuk refo fo riamo. Mti oh. Nbis raa wefo masen mamo rof re kbe ana saso boit ro mait aro. Kbe ana mamo saso mam remo ro mhau kene mam wefo sor.” ");
INSERT INTO ayz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Menohe Yesus yawe si kʼana yawe, “Ana mhau sai, mamo ma. Anu nesait noo boit aro nee kʼana mait.” ");
INSERT INTO ayz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tna ana mawe, “Amu nse roti trion maat msya syoh mana ewok aran sai fo.” ");
INSERT INTO ayz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tna Yesus yawe, “Nkah bo weto nma nee kʼJõ.” ");
INSERT INTO ayz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tna Yesus ybis raa msis-sas weto hre mte beta. Tna Yesus yoo roti trion maat msya syoh mana ewok reto ybo. Tna heyut mam ayoh yayoh asik mase kʼAllah. Tna Ait haber roti weto tna yee kuber wAit yawe ana saim kʼraa ro hre weto. ");
INSERT INTO ayz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Raa weto moo mait tna mhaf matu beta. Menohe roti mabuf taro to msis mhau fares. Kuber ro Yesus wAit soo roti weto tna mfau mam keranjang trion 12 matot. ");
INSERT INTO ayz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ana ro mait boit mam ayõ reto to, raa sme mabo trion 5000. Raa ntuu fnya msya kukek ro mait to ye fee. ");
INSERT INTO ayz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ana mno bo weto mkak si fo, Yesus ybis kuber wAit maut wiak matim wea maru maam ati jaro. Ait yawe yesait yhau tna ybis raa msis-sas weto mamo bana. ");
INSERT INTO ayz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ait ybis ana mamo, tna mti knu-knu fo, Ait yesait aran yaut faut mana sau yamo skabuk. ");
INSERT INTO ayz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wiak ro kuber wAit maut fo, mamo susai mam aya masuf oh. Tna foos mfi mam ati ro ana miin mamo fo mama. Tibyo figyõm mai wiak rana. ");
INSERT INTO ayz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tna mam wore ayõ ro tuuf bo feto, Yesus yata abyõ mam aya mata yama yo kʼana. ");
INSERT INTO ayz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kuber wAit mmat feto, tibyo mrok waa. Tna ana mwohrarar mawe, “Bo mnat anu!” ");
INSERT INTO ayz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Menohe Yesus yawe kʼana yawe, “Knar oh, waa ma! Jõ mefi!” ");
INSERT INTO ayz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tna Petrus yawe kʼAit yawe, “Soh Nyõ Yesus metait mi, nbis jõ tata abyõ mam aya mata tama to kʼNyõ ye.” ");
INSERT INTO ayz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tna Yesus yawe kʼait yawe, “Ae, nama oh.” Tibyo Petrus yroh ybam wiak, tna yata abyõ mam aya mata yamo yo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Petrus yata mam aya mata abyõ yamo, menohe yari foos mfi tna yrok waa. Ait waa yawe yno sruf mam aya oh. Tna ytu kʼYesus yawe, “Tuhan; natmof jõ, fe kbe jõ tsu fo.” ");
INSERT INTO ayz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tibyo Yesus ybo Petrus yatem yayõ. Tna fo yastako Petrus yawe, “Nyõ smot Jõ kaket fee! Smot Jõ kaket!” ");
INSERT INTO ayz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ana mbewok maut mam wiak rana si fo, foos mrok mnem. ");
INSERT INTO ayz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tna kuber wAit ro mhau mam wiak mato sor maka smot Ait tna mawe, “Nyõ Ku ro Allah yare tu oh!” ");
INSERT INTO ayz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ana mamo snok mam aya maam jaro to, mroh mam rabin ro Genesaret. ");
INSERT INTO ayz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tna raa ro mhau mam rabin reto mmat he Yesus yama feto. Tibyo ana frok mamo mabah kʼraa makin beta. Tibyo raa makah raa ro kiyam sor to, mama mo kʼAit ye. ");
INSERT INTO ayz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tna ana soh-soh Ait mawe, “Amu niir ratan aNyõ makit sai mbau a?” Tna ana ro miir ratan rAit makit to, kiyam wana marak beta. ");
INSERT INTO ayz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tna raa ro Farisi msya guru agama Yahudi baro mbam Yerusalem mama mo kʼYesus. Tna ana mtu kʼAit mawe, ");
INSERT INTO ayz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kuber woNyõ mno bo mkair berhasyoh bo mafa ro ja hohos wanu tii mno to, mkah bawya! Soh kuber woNyõ mait boit to, ana myon matem wia fee!” ");
INSERT INTO ayz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Menohe Yesus yawe si kʼana yawe, “Anu nesait nno bo mkair toni: Anu ja nno bo mafa ro hohos wanu, menohe anu niwana watum ro Allah oh meto. Nno fyi meto! ");
INSERT INTO ayz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tiwya Allah yawe mam bokom rAit yawe, ‘Nmat nja msya nme na to kaket. Tna awya ro yawe kair yaja, yme bo to, kbe ait raa mame yajat tu oh.’ ");
INSERT INTO ayz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Menohe anu nno bo mkair: Anu nbis raa nwe matmof maja msya mme na to ma. Anu nwe, ‘Pitis ro anu nwe noo nee kʼana to, noo nee kʼAllah shauk ana oh.’ Feto to anu kro bo mafa ro hohos na wanu kaket tibyo berhasyoh Watum ro Allah oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Anu fo raa ro sioh anu sai! Tiwya Allah ybis nabi Yesaya ykyas anu ykom yawe anu nmo wan-wan sai. Mabo oh! Bokom reto mawe, ");
INSERT INTO ayz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Raa mana refo mbaut Jõ mkah masoh mabyõ sai. Menohe ana mhaf wana to hayah sai. ");
INSERT INTO ayz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ana maka smot Jõ mati sai. Tna watum ro ana mbo reto to watum ro mbam raa sai meto, mbam kʼJõ fee.’” ");
INSERT INTO ayz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus ytu raa msis-sas mama, tna ykyas bo kʼana yawe, “Nri bo ro Jõ tkyas kʼanu tna srau nnaut kaket: ");
INSERT INTO ayz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Raa ro Farisi ja mmat sas bo ro raa mait. Menohe boit ro ana mait reto mamoʼt mhaf mato wana sai. Boit aro mno wa iranya raa msya Allah to fee. Menohe Allah ymat sas bokyas mkair ro frok mbam raa mhaf mato. Bokyas weto oh mi mno wa iranya raa msya Allah to.” ");
INSERT INTO ayz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tna fo kuber wAit mama kʼAit mawe, “Bi yabi, bo ro Nyõ nkyas to, raa ro Farisi mari tna ana kmo meu.” ");
INSERT INTO ayz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Menohe Yesus yawe si kʼana yawe, “Jõ Taja yhau mam sawro rAit. Tna ja yso bo ro moof mam armato rAit sai. Mfi bo Ait ykah bo mam armato rAit to, kbe Ait yatu bosafom ro mkair to beak. Yatu mkah mtis ye. ⌞Tna raa ro Farisi mnan fi bosafom ro mkair reto.⌟ ");
INSERT INTO ayz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nri bo raa ro Farisi mkyas to ma. Ana to mfi guru ro ja masu mboh. Mfi bo guru ro yasu mboh sait, yawe yerif iso kʼait ro yasu mboh roto sait. Kbe ana mbewok mamo sre tna btek mam kayah mato.” ");
INSERT INTO ayz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tna Petrus ytu si kʼYesus yawe, “Sik ne betoo bo ro Nyõ nkyas mkah fret reto kʼamu wia.” ");
INSERT INTO ayz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tna Yesus yawe kʼana yawe, “Anu wase bofret reto maja rau fares a? ");
INSERT INTO ayz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bo ro raa mait mam masoh to, kbe mroh beta mamoʼt mhaf. Tna kbe haberek mamo syõ. Tna raa mamo msyõ mam sutet makus agus. ");
INSERT INTO ayz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Menohe soh raa mhaf mkair to, kbe bokyas mkair frok mbam raa masoh. Tna bokyas reto oh mi mno raa weto mkair. ");
INSERT INTO ayz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Raa ro mhaf mato mkair to, ja mnaut-nat bo ro mkair-kar, mame ajat, wyahte raa, mjah bo kbik-kbak, tna msyõf bo. Ana sioh raa anya, tna mamus raa anya ye. Bo weto beta to, frok mbam kʼraa mhaf mato ro mkair oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bo weto oh mi mno wa iranya raa msya Allah to. Menohe soh raa myon matem kaket fee tna mait bo to, Allah yawe bo reto to bo ati fee. Allah yawe raa ro mno bo feto to raa ro mkair to fee.” ");
INSERT INTO ayz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tna Yesus sikba yuk reto yamoʼt rabin ro Tirus msya Sidon. ");
INSERT INTO ayz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tna fai au ro Kanaan sau mbam rabin reto mama mo kʼYesus. Fai au mtu kʼAit mawe, “Yesus; Ku ro Daud yare, natmof jõ. Ku ano ajõ kabes mbo tibyo ku au mafa kiyam ro msai toni.” ");
INSERT INTO ayz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Menohe Yesus shait bait sai. Tna kuber wAit mawe kʼAit mawe, “Fai au mmai wer sai. Nbis fai au reto frok mamo.” ");
INSERT INTO ayz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tna Yesus yawe kʼfai au yawe, “Soh raa ro kmot domba marak to, kbe domba mamo tit. Raa ro Israel mfi domba ro mamo tit. Jõ Taja ybis Jõ tama to kʼraa ro Israel mesait aran sai. Tna nyõ fo, fnya ro Israel fee.” ");
INSERT INTO ayz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Menohe fai au reto mama kene kʼAit tna maka smot Ait. Tna soh-soh mawe, “Tuhan natmof jõ.” ");
INSERT INTO ayz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Menohe Yesus yisboh si kʼfai au yawe, “Ja raa moo boit mee kukek wana mait mhaf matu. Raa moo boit ro kukek mait reto to, beak mtah mait fee!” ");
INSERT INTO ayz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tibyo fai au mawe, “Tuhan; feto saah oh. Menohe makyõ-aka ro btek mbam ambar ro tuan mait to, ja mtah mait ye oh.” ");
INSERT INTO ayz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Feto tibyo Yesus yawe kʼfai au yawe, “Bosmot anyõ matak toni. Bo ro nyõ nayoh to, mabo mamyot bo ro nyõ nhaf ksoh oh.” Mam weto si fo, ku ro ano rau mrok moof. ");
INSERT INTO ayz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus sikba yuk reto, tna yamoʼt maru maam ro Galilea. Tna Ait yaut yamoʼt faut sau tna susu hre. ");
INSERT INTO ayz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tna raa msis-sas mama mo kʼAit. Ana makah raa ro maa maka, raa ro maa ssafo fee, raa ro masu mboh, raa ro mmai marak tna msya raa ro mafa bo roto taro sor to, mawat mama ye. Tna Yesus yisoh ana tibyo mrok moof beta. ");
INSERT INTO ayz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ana ro mmai marak to mrok mmai. Ana ro maa maka to maa wana mrok ntrot. Ana ro maa ssafo fee, maa wana mrok matak tibyo mber mamo ye. Tna ana ro masu mboh to, masu mrok maah tna mmat bo ye. Raa msis-sas mmat bo ro Yesus yno feto, tibyo mrok ktak sai, tna mbaut Allah ro Israel ye. ");
INSERT INTO ayz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tna Yesus ytu kuber wAit mama tna yawe, “Jõ tatmof raa msis-sas wefo. Ana mama mhau msya Jõ ti trion tuuf oh. Tna mfo wefo boit wana mkak ye oh. Soh Jõ tbis ana mkah hai sre hah me mamo to, kbe ana mhai awyah sne fefa mam iso maka.” ");
INSERT INTO ayz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tibyo kuber ro Yesus wAit mawe, “Fyi re anu bkai boit mnan mam yuk ro mimon refo? Raa ro mawe mait bo fo msis.” ");
INSERT INTO ayz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tna Yesus ytu kʼana yawe, “Anu nse roti jya meto?” Tna ana mawe, “Amu nse roti trion krema msya syoh kinyah baro sai mefo.” ");
INSERT INTO ayz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tna Ait ybis raa msis-sas weto hre mte beta. ");
INSERT INTO ayz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tna fo Yesus yoo roti krema reto msya syoh kinyah weto to, ybo tna yayoh asik mawat kʼAllah. Tna fo Ait haber roti weto ftah aro rau yee kuber wAit mbo saim kʼraa msis-sas weto beta. ");
INSERT INTO ayz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Raa msis-sas weto mait tna mhaf matu beta. Tna roti msya syoh ro mhau fares to, kuber ro Yesus wAit soo mawah mfau mam keranjang trion krema matot. ");
INSERT INTO ayz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Raa sme ro mait bo to mabo 4000. Tna raa ntuu fnya msya kukek ro mait boit weto ye fee. ");
INSERT INTO ayz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesus ybis raa msis-sas reto masen mamo bana, tna ait yaut wiak sau yamoʼt rabin ro Magadan. ");
INSERT INTO ayz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tna raa ro Farisi msya raa ro Saduki baro mama mo kʼYesus. Tna ana sanet Ait: Ana mayoh mawe Ait yno bo msai aro re kbe ana mmat. Mmat tibyo ana mhar mawe Ait ybam kʼAllah yama fe mfe a. ");
INSERT INTO ayz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Menohe Yesus yisboh si kʼana yawe, “Soh anu nmat ayõ twok hreha tna nmat iri majit to, anu nhar nwe, ‘Kbe menrabu arin moof.’ ");
INSERT INTO ayz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tna rabu momo to, soh anu nmat ayoh ngknu tna mkek ye to, anu nhar nwe, ‘Rere arin mkair.’ Anu ja nmat sas ayoh to, tna nhar nwe kbe oom mais. Tna nhar nwe kbe hwyõm. Anu nmat sas bombra ro Jõ tno sor ye. Menohe anu srau nnaut fee. ");
INSERT INTO ayz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anu raa mana ro mfo nhau mam tabam refo fo, anu ja nber safo tna kro Allah kaket fee! Anu nwe Jõ tno bo ro msai aro re kbe anu nhar nwe Jõ tbam kʼAllah tama fe mfe a. Menohe Jõ kbe tno bo msai sau aran sai re anu nmat tna nhar: Meen anu nmat bo msai sau ro mnan fi tiwya Allah yno mkah nabi Yunus sai.” Yesus ykyas bo weto mkak si fo, yasen sikba ana yamo. ");
INSERT INTO ayz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus ysya kuber wAit mamo snok mam maru maam jaro. Kuber wAit sorni roti ro kbe ana mait to akus. ");
INSERT INTO ayz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tna Yesus yawe wa kuber wAit yawe, “Kaket anu mkah ragi raa ro Farisi msya Saduki.” ");
INSERT INTO ayz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kuber wAit mari feto, tibyo mkyas kʼanya mawe, “Anu sorni roti ro kbe biit, au oh mi Yesus ykyas feto to.” ");
INSERT INTO ayz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Menohe Yesus yhar bo ro ana mkyas kʼanya feto. Tibyo Ait yastako ana yawe, “Anu smot Jõ kaket fee! Roti wanu marak to, nnaut nkyas nno fyi? ");
INSERT INTO ayz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anu wase Jõ tatak aJõ fares a? Anu sorni bo ro anu nmat oh fe mfe a? Tiwya anu nmat roti maat ro Jõ too saim kʼraa mabo trion 5000 mait to fe mfe a? Tna anu soo ro ntari mhau to, nfau keranjang ja meto? ");
INSERT INTO ayz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tna taa anu nmat bo Jõ too roti krema tee kʼraa mabo 4000 mait to, tna ro ntari mhau to, anu soo nfau keranjang ja ye meto? ");
INSERT INTO ayz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Riwai Jõ tawe, ‘Kaket anu mkah ragi raa ro Farisi msya Saduki.’ Reto to Jõ tawe bofret sai meto. Roti ro raa mait oh mi Jõ tawe meto fee.” ");
INSERT INTO ayz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus yawe bo feto, tibyo ana mfot mawe Ait yawe wa ana afo re ana kaket ana mkah ragi ro roti meto fee. Menohe Ait yawe wa ana yawe kaket ana mkah bo watum raa ro Farisi msya Saduki. ");
INSERT INTO ayz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ana mamo snok mam rabin ro kene mam kota ro Kaisarea Filipi. Tna Ait ytu bo kuber wAit yawe, “Raa mkyas mawe 'Ait ro Yroh Yama Yfi Raa Sai' tait, awya?” ");
INSERT INTO ayz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kuber wAit mawe, “Ana taro mawe kʼamu mawe, Nyõ fi Yohanes ro ja baptis raa. Tna taro mawe, Nyõ fi nabi Elia. Tna taro mawe, Nyõ fi nabi Yeremia soh mfe to, nabi ro Allah ybis roto sait.” ");
INSERT INTO ayz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tna Yesus ytu kʼana yawe, “Bonaut ranu nesait nwe to Jõ fi awya?” ");
INSERT INTO ayz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus yasen yawe, “Allah ro yaam tait, Nyõ fi Ku ro Ait yare. Nyõ fi Mesias!” ");
INSERT INTO ayz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tna Yesus yawe, “Simon, ku ro Yunus yare: Raa oh mi besi kʼnyõ re nkyas meto fee. Taja oh mi besi kʼnyõ re nkyas feto. Kbe nyõ nhau simaut mase. ");
INSERT INTO ayz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nyõ nfi fraa nes ro mros yum. Bosmot anyõ matak to. Kbe Jõ sgi raa mana woJõ abyõ kʼnyõ. Feto kbe nyõ nkyas watum aJõ kʼana. Tna kbe ana smot Jõ tibyo mamo raa mana woJõ ye. Kbe ana matak toni tibyo Kabes Yabi ytai yno ana btek bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kbe Jõ tbis nyõ nitrah mato re kbe raa mama truk mamo raa mana ro Allah yamo Raja ybo ye. Tna kbe bo ro Allah yawe mkair to, kbe nyõ nawe bo weto mkair mam tabam refo ye. Tna kbe bo ro Allah yawe moof to, kbe nyõ nawe bo weto moof mam tabam refo ye.” ");
INSERT INTO ayz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tna Yesus yawe wa kuber wAit yawe, “Nkyas kʼraa nwe Jõ fi Mesias to ma.” ");
INSERT INTO ayz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tna maban ati reto ⌞mamo snok mam mabo rau⌟ to, Yesus ykyas bo kuber wAit yawe, “Tako hawe sai, kbe Jõ tamoʼt Yerusalem. Tna mam beto to, kbe Jõ tkai bo ro samyoh mawat btek mai kʼJõ. Bo ro samyoh weto to, mbam kʼraa manes ro agama Yahudi: Raa mabi wana msya imam manes wana, tna msya guru agama wana ye. Jõ kbe raa mame tajat. Tna ti ro tuuf to, Taja yno Jõ trok tasen.” ");
INSERT INTO ayz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petrus yari bo ro Yesus ykyas feto, tibyo ykuk Yesus yamo kait kʼait yajoh jaro. Tna Petrus yastako Yesus yawe, “Tuhan; kbe Allah yatmof Nyõ tu oh. Bo samyoh reto kbe btek mai kʼNyõ fee saut.” ");
INSERT INTO ayz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Menohe Yesus haberek bhah Petrus yawe, “Petrus, namo fari tno. Nyõ nkyas bo ro kabes yabi (Iblis) ykyas meto! Nyõ nno wa Jõ to ma. Bo ro nyõ nkyas reto to, bonaut ro mbam kʼAllah fee. Bonaut reto to, mbam kʼraa sai meto.” ");
INSERT INTO ayz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tna Yesus yawe kuber wAit yawe, “Awya sai ro ksoh kro Jõ to, yako hawe sai kbe yno mfi fefo: Kbe yno bo rait u ma. Tna kbe ait yasom ara warok rait ye: Au oh mi yako hawe sai ait beroh yasom bo mase ro kbe mama mai kʼait. Tna beroh kro iso ro Jõ terif kʼait. ");
INSERT INTO ayz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Raa taro mawe misoh metsu rana ai mam tabam refo. Ana saso riof rana mam tabam refo sai ai, menohe mnaut mamos rana fee. Meen ana weto mhau hame wajin fee. Menohe raa taro ja saso riof rana ai mam tabam refo fee. Ana mawe mno bo woJõ. Ana saso Jõ tasom aJõ mam tabam refo. Ana weto oh mi kbe mkai riof. Ana kbe meen raa mame majat oto, menohe meen ana mkai riof ro hame wajin. ");
INSERT INTO ayz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mfi bo raa sait ykai kta mam tabam refo to beta, menohe ykai riof ro mase fee. Meen mafer rau to bawya? Ait ynaut yawe riof ro mase to, ja raa kwiyat mkah kta wana weto a? ");
INSERT INTO ayz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen Jõ tama u to, Jõ takah bo yase ro Taja ye. Tna malaikat wAit sor tayun Jõ mama ye. Tna kbe Jõ too boren raa sait-sait tna taren ana. Taren raa to, tno mamyot bo ro ana mno beta. Oon reto to kene oh. ");
INSERT INTO ayz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nri oh! Meen ‘Ait Ro Yroh Yama Yfi Raa Sai’ ye yama u. Yama u to, kbe yamo Raja ybo raa wAit. Ati ro Ait yama u to, anu wore siret mam wefo fo, meen anu baro nhau fares nmat Ait yama to. Ati reto to, nhai beta marak fefares.” ");
INSERT INTO ayz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ti trion ntamam firwas tna Yesus yakah Petrus, Yakobus ysya Yohanes ro Yakobus yao to, yamo. Ana maut mamoʼt atu ro miyõ sau. Ana mesait mamo kar mam yuk reto. ");
INSERT INTO ayz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tibyo Yesus yetsu haberek mam wore ana mros weto. Yasu ynaif to, mrok mawyah mfi ayõ. Tna ratan ro yyum to, mamo mboh fyok ye. ");
INSERT INTO ayz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tna ana mmat raa mabo ewok frok tubor mros msya Yesus. Ana mbewok weto to Musa ysya Elia. ");
INSERT INTO ayz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tna Petrus yawe kʼYesus yawe, “Guru; amu ye nhau mam yuk refo to moof toni. Soh Nyõ ksoh meto mi, kbe jõ ttor sbyah trion tuuf mam yuk refo: Sau kʼNyõ, sau kʼMusa, tna sau kʼElia ye.” ");
INSERT INTO ayz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus ykyas bo kri-kri fares fo, byõ ro mboh fyok mama mroh sro-sro ana kait. Tna ana mari Raa sait ymai mam byõ mato yawe, “Ait refi Ku aJõ ro Jõ tksoh. Ait tait Jõ thaf mnan. Nri bo kʼAit!” ");
INSERT INTO ayz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kuber wAit mabo tuuf reto mari feto tibyo ana mrok waa toni tna maka mabum mam tabam. ");
INSERT INTO ayz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Menohe Yesus yama yatem yiir ana, tna yawe, “Waa ma. Nsen nros oh.” ");
INSERT INTO ayz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ana mari tna misbat mana mmat menohe Yesus yesait aran sai. Musa ysya Elia marak. ");
INSERT INTO ayz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ana mroh mbam atu reto to, Yesus ysi bo kʼana. Ysi yawe, “Bo ro riwai anu nmat to, nkyas kʼraa roto to ma. Nhau sai mamo snok mam wore wo Jõ trok tasen wia. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'.” ");
INSERT INTO ayz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tna ana mtu bo kʼAit mawe, “Fyi re guru agama wanu ro Yahudi mawe, ‘Meen Elia yama wia tna fo Mesias yama yrof to?’” ");
INSERT INTO ayz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus yawe, “Ae, Elia meen yama yisoh bombra sor wia. ");
INSERT INTO ayz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jõ tawe kʼanu tawe, Elia tiwya yama oh. Menohe raa mhar ait fee. Tna raa sikowah ait mamyot ksoh rana sai. Tna meen ana mno bo mkair feto mai kʼJõ ye. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'.” ");
INSERT INTO ayz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tibyo kuber wAit srau mawe, “Ait ykyas Elia to, Ait ykyas Yohanes ro ja baptis raa oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wore wo Yesus ysya kuber wAit mabo tuuf hah me mama to, ana mkai raa msis-sas ro siret wea mam yuk reto. Tna bi sait yama yo kʼYesus, tna yjit yimna mam tabam tna soh-soh Ait yawe, ");
INSERT INTO ayz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tuhan; natmof ku ajõ! Ait tait, kiyam ro ruu mber reu msai toni. Ti aro to, kiyam reto mno ait ytek ybe mam tafoh. Tna ti taro to, btek mam aya ye. ");
INSERT INTO ayz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Jõ takah ait tamo tee kuber woNyõ. Menohe ana matak misoh ait yoof fee.” ");
INSERT INTO ayz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus yawe, “Anu wefo mfe saut! Anu wefo raa ro wyahte Allah, tna smot Jõ fee! Kbe thau tsya anu kait fares a? Jõ thaf sneh tsya anu kait ye fee oh!” Tna Yesus yawe kʼbi retait yawe, “Nbo ku retait nakah nama!” ");
INSERT INTO ayz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ana makah ku retait mama tna Yesus yikyak kabes ro mbo ku refi frok mamo. Tna mam weto si fo, ku retait yrok yoof. ");
INSERT INTO ayz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yesus yno bo weto mkak tna kuber wAit mama mo kʼAit yesait. Tna ana mtu kʼYesus mawe, “Bo bawya mno re amu ntak nikyak kabes reto frok fee?” ");
INSERT INTO ayz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Menohe Yesus yawe, “Bosmot wanu matak fee. Soh bosmot wanu maku sai, mnan fi makan (biji) ro maku sai to, kbe anu nwe kʼatu rno nwe susu mamoʼt tno. Nwe feto tna kbe atu reto susu mamo tu oh. Tna soh bosmot wanu mase mfi feto to, kbe anu ntak nno bo bawya sai ye.  ");
INSERT INTO ayz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Menohe kiyam ro kabes mnan feto to, ja raa mikyak sai fee. Raa skabuk tna mhau bo mait wia, re kbe mikyak kabes reto frok.” ");
INSERT INTO ayz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ati sau to, Yesus ysya kuber wAit mhau su mam provinsi ro Galilea. Tna Yesus yawe kʼana yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna kbe raa mfot Jõ tna msan kʼraa roto mbo. ");
INSERT INTO ayz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tna ana mame Jõ tajat. Tna ti ro tuuf to, kbe Taja yno Jõ trok tasen.” Ait ykyas bo weto, tibyo kuber wAit sraujin toni. ");
INSERT INTO ayz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus ysya kuber wAit mamo snok mam remo ro Kapernaum. Tna raa ro ja moo namabyoh (pajak) mkah misoh Samu ro Allah mama mo kʼPetrus. Ana mtu kʼait mawe, “Bi Guru ranu ja yoo pitis ro namabyoh Samu ro Allah yee, fee mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tna Petrus yawe, “Ae, bi Ait yoo yee.” Tna Petrus yamoʼt amah. Ait twok mam amah si fo, Yesus huwya yawe kʼait wia yawe, “Simon; raa ro mase mam tabam refo ja yoo pitis ro namabyoh. Nyõ nnaut fyi? Ja ana moo pitis reto mbam kʼawya? Mbam raa kinyah ro rabin rana tna msya raa ro srim ye fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tna Petrus yawe, “Ana moo pitis raa ro srim.” Tna Yesus yawe, “Feto to, raa kinyah ro ana mbo to, moo pitis ro namabyoh mee fee. Feto to, anu ro Allah ybo fo, anu boo namabyoh ro samu rAit to bee fyi? ");
INSERT INTO ayz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Menohe Jõ hawe bo ana kmo anu. Feto to, nasen namoʼt aya tna tawer syoh. Tna syoh ro nyõ nayo tinyi to, kbe nyõ nkai pitis mauf mam syoh reto masoh. Tna noo pitis weto namo nee mkah namabyoh wanu mbewok.” ");
INSERT INTO ayz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ati reto kuber ro Yesus wAit mama mo kʼAit tna mtu kʼAit mawe, “Awya ro oh mi yase mam raa mana ro Allah yamo Raja ybo to?” ");
INSERT INTO ayz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tibyo Yesus ytu ku maku sau mama mros susai tna yawe, ");
INSERT INTO ayz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Haberek nmo nfi ku maku refo. Soh mfe to, kbe anu nmo raa ro Allah ybo mam raa mana rAit to fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Awya ro yhaf sneh tna bonaut rait haberek yfi ku maku refo to, ait kbe yase mam raa mana ro Allah yamo Raja ybo ye. ");
INSERT INTO ayz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jõ ksoh anu nitrah nhaf wanu kʼraa ro mhaf sneh. Awya ro yitrah yhaf rait ku refo, ro yno feto mam Jõ tasom aJõ to, ait yno bo moof oh meto. Au oh mi; awya ro mmat raa ro mhaf sneh to, yno feto to mnan anya mfi ait yno bo ro moof reto kʼJõ ye oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","7","“Mam tabam refo fo, bo aro rau tko re raa mno iro. Bo weto mhau bau oh. Tibyo meen Allah yno bo ro samyoh btek mai tabam refo to. Menohe raa ro yisti re ku maku ro smot Jõ sau mno iro to, soh ait ysu mam aya yhai to, moof miwer bo ro meen Allah yno mai kʼait retait! Mfi bo raa moo fraa ro mase sau tna make mam yamyum rait tna mbeak ait mam aya sawan, tibyo ysu to, bo reto to moof miwer bo samyoh toni ro meen ait ykai. Tuhan kmo toni raa ro misti re raa roto mno iro to. ");
INSERT INTO ayz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tna soh anu ntem soh mfe naa jaro misti re anu nno iro to, sbi ntem msya naa reto noo beak makus. Anu nhau nsya Allah nkah ntem msya naa jaro sai to, reto bo ro moof. Menohe soh anu nhau nkah ntem ewok soh mfe naa ewok ro misti re nno iro to, bo ro mkair. Meen Allah yoo anu beak niit mam tafoh ro roon reto. ");
INSERT INTO ayz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Feto ye soh anu nsu jaro misti re anu nno iro to, tufrok nsu makan reto beak makus. Anu nhau nsya Allah nkah nsu jaro mesait aran sai to, reto bo moof. Menohe soh anu nhau nkah nsu ewok ro misti re nno iro to, bo ro mkair. Meen Allah yoo anu beak niit mam tafoh ro rabin kair reto. ");
INSERT INTO ayz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Feto ye, niwana ku kinyah wefi sait ma. Malaikat ro ja mhau msya Allah sor to, ja kmot ana ye.  ");
INSERT INTO ayz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ait ro Yroh Yama Yfi Raa sai yama mkah bo yoo riof yee kʼraa ro mamo tit.” ");
INSERT INTO ayz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Anu nnaut fyi? Mfi bo raa sait ysia domba wait mana trion 100. Tna domba weto mana sau marak. Kbe bi ait retait yno bawya? Kbe ait yasen yamo saso domba ro marak reto fe mfe a? Kbe ait sikba domba mana trion 99 reto agus mam faut mana. Tna ait yamo saso domba ro marak reto fea! ");
INSERT INTO ayz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Soh ait ykai domba ro marak reto to, kbe ait simaut mase. Menohe domba mana 99 ro mhau mam faut mana to, ait simaut mase fee. ");
INSERT INTO ayz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anu Nja ranu ro yhau mam sawro rAit to, Ait hawe bo raa kinyah wAit sait yarak feto ye.” ");
INSERT INTO ayz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus yawe kuber wAit yawe, “Soh raa wanu sait yno iro to, namo no kʼait tna betoo iro reto kʼait. Nkyas mam wore anu mbewok aran sai. Nkyas mam wore raa makin mmat ma. Tna soh ait yari bo ro nyõ nkyas reto to, ait retait ye yiranya u oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Menohe soh ait yari bo ro nyõ nkyas fee; namo nmen raa mabo sait atau ewok bo feto msya nyõ nmo no kʼait. Tna hre nkyas bo reto su. Watum ro Tuhan mawe, ‘Nko hawe sai raa mabo ewok, soh mfe tuuf mama tna hre su: Raa mabo ewok, soh mfe tuuf ro mesait mmat bo reto to, ntu ana mama. Tna ana weto kbe hre mkyas bo ro ana mmat. Soh ana beta mmat bo mnan anya, mawe raa retait yno bo ro mkair reto, feto tna fo raa moo srah mmit kʼraa retait.’ ");
INSERT INTO ayz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tna soh ait hawe yari bo ro anu nwe to, nmo nkyas bo reto nsya jemaat. Nkyas bo reto nsya raa ro ja msya anu skabuk su. Tna soh ait hawe yari bo ro anu beta nkyas to, niranya nsya ait ma. Nmat ait yfi raa ro wase Allah. Nmat ait yfi raa ro ja mno bo mkair-kar mnan fi ana ro ja moo namabyoh (pajak). ");
INSERT INTO ayz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jõ tawe kʼanu tawe: Bo ro Allah yawe mkair to, nwe mkair mam tabam refo ye. Tna bo ro Allah yawe moof to, nwe moof mam tabam refo ye. ");
INSERT INTO ayz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tna Jõ tawe kʼanu ye tawe: Soh anu ro smot Jõ nbo ewok ntu srah bawya sai su, tna anu nrok srau sau nwe srah reto mabo tna nkyas kʼTaja ro yhau mam sawro rAit to, kbe Ait yawe srah reto mabo ye. ");
INSERT INTO ayz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wore raa woJõ mabo ewok atau tuuf siret su re mtu srah mari to, kbe Jõ siret tsya ana mam weto ye.” ");
INSERT INTO ayz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tna Petrus yama yo kʼYesus tna ytu bo kʼAit yawe, “Tuhan; soh raa wanu sait yno bo ro mkair mai kʼjõ mun aro rau-rau to, kbe jõ te tfot yatem u muhrin jya bo feto? Muhrin krema fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Menohe Yesus yawe, “Mfe; muhrin krema sai fee, muhrin trion 490 bo feto. ");
INSERT INTO ayz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Allah yamo Raja ybo raa mana rAit to, mnan fi raja sait. Raja retait yawe ykyas pitis ro tiwya sryan wait mhe kʼait. ");
INSERT INTO ayz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Raja retait ykyas bomhaam ysya sryan wait kri-kri to, raa wait makah sryan ro bomhaam wait sait naut mama. Sryan retait tiwya yhe pitis ro bofyah mase toni. ");
INSERT INTO ayz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Menohe ait ytai yisroh bofyah wefo fee. Tibyo raja retait ybis raa mfot sryan retait ysya yfain, kukek wait, tna moo kta wait beta mamo masim afo re moo mabyoh rau to misroh bofyah wait. ");
INSERT INTO ayz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Menohe sryan retait yabum soh-soh raja retait yawe, ‘Bi yabi, natmof jõ! Nhau rere baro wia tna kbe tisroh pitis wonyõ beta.’ ");
INSERT INTO ayz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Raja retait yari feto, tibyo yatmof sryan retait tna yawe bofyah weto makus rof. Tna raja retait bitsre sryan retait yamo bait ye. ");
INSERT INTO ayz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Menohe sryan retait frok yamo tna ykai sryan roto sait ro tiwya yhe pitis bofyah kebet baro kʼait. Tna sryan ro riwai raja bitsre retait, yfot sryan roto refi bekon tna yastako yawe, ‘Nisroh pitis ro tiwya nyõ nhe kʼjõ to, fooh!’ ");
INSERT INTO ayz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Menohe sryan roto refi yabum soh-soh ait yawe, ‘Nhau rere baro wia tna kbe jõ tisroh tu oh!’ ");
INSERT INTO ayz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Menohe sryan retait hawe bo yari bo ro sryan roto refi yawe. Tibyo yfot sryan refi yamo ybu mam bui mamo snok mam wore meen ait yisroh bofyah wait wia tna fo frok. ");
INSERT INTO ayz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sryan roto taro mmat feto, mnaut mawe mkair toni. Tibyo ana mamo mkyas bo ro sryan retait yno reto kʼraja rana. ");
INSERT INTO ayz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Raja retait yari feto to, yrok kmo. Tibyo ait ytu sryan retait yama tna yawe, ‘Nyõ nno bo mkair toni! Taa nyõ soh-soh jõ, tibyo jõ tawe nyõ nisroh bofyah wojõ fee, makus sai rof. ");
INSERT INTO ayz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Rau ro moof to, nyõ natmof raa retait mfi bo tii jõ tatmof nyõ!’ ");
INSERT INTO ayz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tna raja retait kmo sryan retait, tibyo ybis raa wait mfot ait makah mamo mbu mam bui. Yhau mam beto tna raa sikowah ait mamo snok mam wore meen ait yisroh bomhaam wait beta wia tna fo frok.” ");
INSERT INTO ayz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Feto tna Yesus yawe, “Soh raa mno bo mkair mai kʼanu to, kmo ait ma. Nhaf mkair ma. Ne nhaf moof u. Soh anu nno feto fee, meen Taja ro yhau mam sawro rAit to, kbe yno bo ro mkair mai kʼanu sait-sait mfi raja retait yno to ye.” ");
INSERT INTO ayz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus ykyas bo weto mkak. Tna Ait sikba provinsi ro Galilea. Tna yasen yamoʼt provinsi ro Yudea. Yamoʼt aya ro Yordan maam jaro. ");
INSERT INTO ayz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Raa msis-sas mama kro Ait. Tna Ait yisoh raa wana ro kiyam ye. ");
INSERT INTO ayz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tna raa ro Farisi baro mama mo kʼAit. Tna mtu bo sanet Ait mawe, “Mfi bo fnya sau mno bo ro mkair aro fee; menohe au maa yako au makus sai. Soh ait yno feto to, ait yiwrek Watum ro Musa ykom oh meto fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Menohe Yesus yawe, “Anu wase Bokom ro Allah. Bokom rAit reto mkyas mawe: ‘Maban tiwya tinyi to, Allah yfen raa sme tna yfen fnya ye. ");
INSERT INTO ayz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Feto to, ku ro sme kbe sikba yaja ysya yme na tna yamo ysya yfain rait mhau su. Kbe ana mbewok mjin su, bonaut rana sau, mhaf rana sau, tna bewok mno bo wana su ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Feto ana to, raa mabo ewok u fee. Ana haberek mfi raa sait aran sai. Tna raa sme msya fnya ro Allah yse mrat su to, raa sait bo ye betwat ma.” ");
INSERT INTO ayz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Menohe raa ro Farisi me mtu kʼAit mawe, “Musa ybis yawe, soh raa sait yako yfain rait makus to, ait ykom aam ro mako au makus. Ykom tna yee kʼau wia, tna ait yako au. Bokyas aNyõ hayah tna Watum ro Musa to hayah ye. Nyõ nawe fyi meto?” ");
INSERT INTO ayz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Menohe Yesus yawe, “Allah hawe raa sait yako yfain rait. Menohe anu ja hawe nri Watum ro Allah. Tibyo Musa ykom watum reto. ");
INSERT INTO ayz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nri bo refo wia: Awya ro yfain wyahte ait fee, menohe ait yako au makus sai, tna yoo fnya ro mabyõ to, ait retait ywyahte oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tna kuber ro Yesus wAit mawe, “Soh feto to, ro moof to raa moo fnya ma.” ");
INSERT INTO ayz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Menohe Yesus yawe, “Bo ro anu nwe reto, Raa beta srau fee. Allah ykyas feto kʼraa taro re ana mse bokyas reto mam ana mhaf wana. ");
INSERT INTO ayz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Raa sme taro moo fnya fee. Ana taro to, tiwya fnya mabe to, metsu rana mkair. Ana kbe mjin msya fnya matak fee. Tna taro to, raa roto taro misti ana tibyo moo fnya fee. Tna taro to, mesait mawe mhau bana sai. Allah yamo Raja ybo ana oh. Tibyo ana mawe mhau bana sai afo re mrero mari bo ro Allah ybis ana. Mari tna kbe masen mamo mno sai. Awya ro yatak yari watum refo to yari oh.” ");
INSERT INTO ayz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tna raa baro makah kukek wana mama mo kʼYesus. Ana mama re kbe Ait yse yatem abyõ kukek wana tna skabuk ana. Kuber ro Yesus wAit mmat feto, tna ana mastako raa weto. ");
INSERT INTO ayz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Menohe Yesus ymat feto, tibyo bhah kuber wAit. Bhah ana yawe, “Nitsre ku kinyah weto mama mo kʼJõ. Nwe wa ana to ma! Raa ro mama mo kʼJõ mfi kukek wefo fo, mhaf wana to, Allah ksoh. Ana oh mi mamo raa mana ro Allah yamo Raja ybo to.” ");
INSERT INTO ayz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tna Yesus yse yatem abyõ kukek wana weto tna yasen yamo renti naut. ");
INSERT INTO ayz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ati sau to, bi sait yama yo kʼYesus tna ytu yawe, “Guru; kbe jõ tno bawya ro moof re kbe meen Allah yno jõ thau hame wajin?” ");
INSERT INTO ayz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tna Yesus yawe kʼait yawe, “Fyi re nyõ ntu bo bawya ro moof kʼJõ to? Ja Raa sait aran yoof. Soh nyõ nawe nhau hame wajin to, nari watum ntraa ro tiwya Allah ybis Musa ykom to, nbo nno.” ");
INSERT INTO ayz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Menohe bi retait ytu bo kʼAit yawe, “Watum ryo meto?” Tna Yesus yawe, “‘Nme ajat ma! Nwyah ma! Nsyõf bo to ma! Siroyõ ma! ");
INSERT INTO ayz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nmat nja msya nme na to kaket! Tna nhafri raa ro mhau kene msya anu to ye. Nhafri ana mnan fi anu nhafri netsu wanu nesait ai to.’” ");
INSERT INTO ayz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tna bi ait refi yawe, “Bo weto ja jõ tno beta oh. Bawya sai ro mhau fares?” ");
INSERT INTO ayz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tna Yesus yawe, “Soh nyõ nawe nno bo ro moof toni to, nno bo sau naut. Namo nasim kta wonyõ beta. Tna nsaim pitis weto kʼraa ro bo marak. Soh nno bo reto to, nyõ name kta mam sawro ro Allah oh meto. Tna fo nama nkro Jõ.” ");
INSERT INTO ayz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bobot retait yari bo ro Yesus yawe feto, tibyo hah ye yamo to sraujin toni. ");
INSERT INTO ayz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tna Yesus yawe kuber wAit yawe, “Raa ro bobot masen mamo raa ro Allah yamo Raja ybo to, min toni. ");
INSERT INTO ayz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kak unta maboh sau kbe mamo twok mam sii hren soo to, mnan-nan baro ye. Menohe raa ro bobot yamo raa ro Allah yamo Raja ybo to bo ro min toni.” ");
INSERT INTO ayz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kuber wAit mari feto, tibyo mrok ktak mawe, “Soh feto to, raa awya meen ykai riof?” ");
INSERT INTO ayz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus yasu ymat ana tna yawe, “Anu raa to, nesait ntai nno riof kʼanu fee. Menohe Allah yno riof kʼanu saah. Ait ytai yno bo bawya sai.” ");
INSERT INTO ayz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tna Petrus yawe, “Amu wefo nsen sikba bombra wanu beta afo re nma kro Nyõ oh. Tna kbe amu nkai bo bawya?” ");
INSERT INTO ayz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tna Yesus yawe, “Nri oh! Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen tabam refo kbe haberek mamo bo ro tna. Ati reto to, kbe Jõ hre mam ambar (tahta) ro mase toni. Kbe Jõ hre abyõ tbo raa woJõ. Tna mam weto ye to, anu nbo 12 fo, kbe hre mam ambar ro mase trion 12 ye. Kbe anu ntu srah kʼraa mana 12 ro Israel to, nri ye. ");
INSERT INTO ayz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tna Jõ tisti re raa taro sikba amah wana afo re kro Jõ. Taro to sikba mao na, mano na, maja msya mme na, kukek wana afo re kbe ana kro Jõ. Taro sikba armato wana bo to makus ye. Kbe ana beta mkai bo weto u muhrin trion 100. Tna meen ana mkai roon ro hame ye. ");
INSERT INTO ayz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Menohe raa mawat ro mfo refo masom wana matim wia to, meen masom haberek mee mamo tis. Tna ana ro mfo refo masom mhau tis to, meen masom haberek matim wia.” ");
INSERT INTO ayz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Allah yamo Raja ybo raa mana rAit to, mfi bi yabi sait frok rabu momo yamo saso raa baro. Yawe raa mama misoh armato ro anggur rait. Ana mkah bo rait tna ait yoo boren yaren ana. ");
INSERT INTO ayz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ait ykai raa baro tna ykyas boren mabyoh jya kbe ait yaren ana. Ana mkyas bo su. Tna ait yawe kbe ana mno bo wait mamo snok hreha tna ait yaren pitis dinar mauf sau kʼana. Tna ybis ana mamo mkah bo mam armato rait. ");
INSERT INTO ayz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tna baas ayõ moo maa matak bo feto to, bi ait retait frok yamo tna fri raa mabo baro mhau baas sai mam pasar. ");
INSERT INTO ayz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tibyo ait yawe kʼana yawe, ‘Nmo nisoh armato ro anggur ajõ. Tna kbe jõ too boren mnan si taren anu.’ Ana mari feto, masen mamo misoh ye. ");
INSERT INTO ayz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tna mam wore baas ayõ mros susai bo feto, ait frok yamo u. Ait fri raa baro mhau baas sai. Tna ykyas bo ysya ana, yawe mnan anya sai. Tna mam wore hreha ayõ hawer bo feto, ait frok yamo yno bo feto naut u ye. ");
INSERT INTO ayz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tna mam wore ayõ frut bo feto ye, ait frok yamo fri raa roto taro naut. Tna ytu kʼana yawe, ‘Riwai anu nhau baas sai nno fyi?’ ");
INSERT INTO ayz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Menohe ana mawe kʼait mawe, ‘Raa aro mbis amu nkah bo rait fee.’ Tibyo bi ait yawe, ‘Feto to, nmo nkah bo mam armato anggur ajõ.’ ");
INSERT INTO ayz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kene mam wore arin mti bo feto, tna bi yabi ro armato rait ybis aban mana ro ybo raa ro misoh armato rait yawe, ‘Namo ntu raa ro mkah bo mam armato ajõ to. Nawe ana mama re nyõ naren ana sait-sait. Naren raa ro mama mtis wia. Tna naren raa ro mama hreha. Tna naren ana ro matim rabu.’ ");
INSERT INTO ayz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ana ro mkah bo weto mama tna ait yaren ana ro mama mrof wore ayõ mfrut fo wia. Ait yaren ana sait-sait mkah pitis dinar mauf sau. ");
INSERT INTO ayz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Raa ro matim rabu mkah bo to, mmat feto tna mnaut mawe kbe ana raa maren boren mase miwrek ana ro mama mam tis to. Menohe mfe. Aban mana retait yaren ana mkah pitis dinar mauf sau aran sai ye. ");
INSERT INTO ayz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ana moo boren wana tna ntbur mawe, ‘Bi ro armato anggur retait yaren bo kaket fee sai a? ");
INSERT INTO ayz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Amu ro ntim rabu nkah bo wia ayõ mafit nhai to. Menohe boren ro ait yaren amu mnan anya sai mfi boren ro ait yaren kʼana ro mama mam tis! Yno fyi meto? Ana weto mkah bo ayõ sau aran sai!’ ");
INSERT INTO ayz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Menohe bi yabi retait yawe kʼana wetait sait yawe, ‘Tao; kmo ma. Jõ tno bo ro mkair aro mai kʼnyõ fee. Riwai anu bkyas bo su bwe anu nkah bo ti ro miyõ sau to, kbe jõ taren anu pitis dinar mauf sau no? ");
INSERT INTO ayz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Noo boren wonyõ tna namo oh. Jõ ksoh taren ana ro mama mam tis ye mnan anya mfi boren ro jõ taren kʼnyõ to ye. ");
INSERT INTO ayz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nyõ nawe jõ tno bo manhai wojõ mkah jõ ksoh ajõ sai to ma fe mfe a? Soh jõ thaf ase tna tatmof raa anya to, kbe nyõ nhaf mkair a?’” ");
INSERT INTO ayz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tna Yesus yawe, “Feto ye, raa ro masom makus mtis to, meen masom haberek matim mana wia. Tna ana ro masom matim mana wia to, meen haberek masom mamo mtis mrof.” ");
INSERT INTO ayz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus yawe yamoʼt Yerusalem. Tna Ait ytu kuber wAit mesait aran mama. Tna Ait ykyas bo kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Jõ fi ‘Ait ro Yroh Yama Yfi Raa Sai.’ Anu bmoʼt Yerusalem mefo. Mam beto to, kbe raa moo Jõ msan kʼimam manes msya guru agama ro Yahudi. Tna kbe ana mtu srah mari tibyo mawe safo makan btek mai kʼJõ. Tna mawe raa mame Jõ tajat. ");
INSERT INTO ayz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tibyo ana ro agama Yahudi to, kbe moo Jõ msan kʼraa ro wase Allah. Kbe ana mamus Jõ, moo too mmok-mak Jõ, tna kbe ana mame Jõ tajat mam ara warok. Tna ti ro tuuf to, kbe Taja yno Jõ trok tasen.” ");
INSERT INTO ayz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Bi Zebedeus yfain msya ku wau mabo ewok mama mo kʼYesus. Tna fai au mjit mimna ntmi mam tabam, tna soh-soh Ait. ");
INSERT INTO ayz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus ytu kʼfai au yawe, “Bo ro nyõ nayoh kʼJõ to bawya?” Tna fai au mawe, “Meen Nyõ namo Raja nbo raa mana aNyõ. Jõ tayoh kʼNyõ tawe, noo ku wojõ mabo ewok, nse mbewok hre msya Nyõ re ana mamo mase msya Nyõ ye. Nbis sait hre kʼNyõ mam ati ro natem ati. Tna nbis sait hre mam ati ro natem ta.” ");
INSERT INTO ayz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Menohe Yesus yawe kʼana yawe, “Anu wase bo ro anu nyoh: Fyi, kbe anu ntai nsom kair ro kbe mama mai kʼJõ fe mfe a?” Tna ana mawe, “Amu ntak ye.” ");
INSERT INTO ayz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tna Yesus yawe, “Bo ro mai kʼJõ to, saah meen anu nsom ye oh. Menohe awya ro hre mam ati ro tatem ati msya temta to, Jõ oh mi tsok to fee. Raa ro hre mam yuk reto to, meen Taja yesait ysok bo rAit oh.” ");
INSERT INTO ayz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kuber wAit mabo nsaa taro mari bo reto, tibyo ana mrok kmo ana mbewok ro mao kʼanya reto. ");
INSERT INTO ayz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Feto tibyo Ait ytu ana mama tna yawe kʼana yawe, “Raa ro wase Allah mam tabam refo to, anu nhar nwe raa ro mamo aban mana wana to, ja mberasi raa kinyah ro ana mbo. Tna raa mase ro mhre abyõ mam uu to, mberasi ana ro mamo aban mana weto ye. ");
INSERT INTO ayz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Menohe anu to, nno bo feto ma. Awya sai ro yawe yase kʼanu wefo to, ait yamo raabis ranu tna ait yno bo wanu ye tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tna awya ro yawe yatim yamo aban mana kʼanu to, ait yamo sryan tna yno bo wanu wia. ");
INSERT INTO ayz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ynan fi Jõ fo. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ tama fo, tawe tbis raa mno bo woJõ fee. Menohe Jõ tama fo re tno bo kʼraa. Tna tama re too tetsu ajõ tfes raa mawat. Tibyo kbe ana mkai riof ro mase” ");
INSERT INTO ayz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus ysya kuber wAit frok mbam Yerikho fo, raa msis-sas kro Ait. ");
INSERT INTO ayz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tna raa ro masu mboh mabo ewok hre wea mam iso maam weto. Ana mari mawe Yesus yamo frit iti feto, tibyo ana masen mtu kʼAit mawe, “Tuhan; Ku ro Daud, natmof amu!” ");
INSERT INTO ayz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Raa msis-sas sor weto kmo bhah ana mbewok mawe, “Shait!” Menohe ana mbewok reto beroh mtu fari renti mawe, “Ku ro Daud, natmof amu!” ");
INSERT INTO ayz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tna Yesus yari feto, tibyo susu yros. Yros tna ytu bo kʼana mbewok yawe, “Anu ksoh nwe Jõ tno bawya kʼanu?” ");
INSERT INTO ayz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ana mawe si kʼAit mawe, “Tuhan; amu nksoh nmat bo ye!” ");
INSERT INTO ayz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus yatmof ana tna yiir ana mbewok masu. Tibyo ana masu maah. Tna ana kro Ait mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus ysya kuber wAit mamo mam iso ro Yerusalem fares. Tna ana snok remo ro Betfage mam Faut ro Zaitun. Tna Ait ybis kuber wAit mabo ewok matim wia. Ait yawe, ");
INSERT INTO ayz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ntim wia, nmoʼt remo reto. Tna twok nmo to, kbe anu nkai keledai ro ano sau msya maku rau, raa mii mros wea mam weto. Nmo skur mana ewok ye nkuk nma nee kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Soh raa mtu bo kʼanu mawe, ‘Anu skur keledai weto mkah bawya?’ Nwe kʼana nwe, ‘Tuhan ybis yawe amu nma skur fo.’ Tibyo kbe raa retait bitsre anu skur nkah nma.” ");
INSERT INTO ayz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bo reto mabo mnan si bo ro tiwya Allah ybis nabi sait yama ykyas wia yawe, ");
INSERT INTO ayz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nwe kʼraa ro Yerusalem mam faut ro Sion nwe, ‘Nmat Raja ranu yama yo kʼanu. Ait yhaf sneh tna Ait yaut keledai ro tna sau ye.’” ");
INSERT INTO ayz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tna kuber wAit mabo ewok reto mamo mno bo mfi bo Yesus ysi kʼana feto. ");
INSERT INTO ayz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ana skur keledai reto mkah maku rau ye mkuk makah mama. Tna raa mrus jubah wana ro myum ntom mam keledai kbor abyõ tna Yesus yaut hre abyõ. ");
INSERT INTO ayz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Raa mawat mmat he Yesus yama. Tibyo ana mrus jubah wana ro myum tna tom tar-tar anya mam iso. Tna raa taro msot ara mawyan tom mam iso iti ye. ");
INSERT INTO ayz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Raa msis-sas ro matim msya raa ro kro mamo mtis sor to simaut mawe, “Hosana! Nyõ nase toni! Nyõ fi Ku ro Daud yare. Tuhan ybis Nyõ nama to. Anu ro nhau mam sawro ro Allah to; nbaut Ait ye.” ");
INSERT INTO ayz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesus twok mam Yerusalem tna raa ro mhau mam kota reto mrok mnin-nin. Ana mtu kʼanya mawe, “Bi awya meit ee?” ");
INSERT INTO ayz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Raa mawe, “Yasom rAit Yesus. Ait nabi ro Allah ybis sait. Ait ybam remo ro Nasaret, provinsi ro Galilea.” ");
INSERT INTO ayz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus twok mam Samu ro Allah. Ait ymat raa masim bo msya raa ro moo bo mam samu ro Allah mato reto. Ymat feto tna kmo yikyak-yak ana frok mamo. Raa taro hre masim pitis (penukar uang): Masim pitis Samu ro Allah kʼraa ro sriem. Tna raa mhre masim ruu merpati bo ye. Tna Yesus haberek-barak ambar wana ro masim bo weto. ");
INSERT INTO ayz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tna Ait yawe kʼana yawe, “Bokom ro Allah mawe, ‘Amah aJõ to amah ro mkah bo raa skabuk. Menohe anu nma nno amah reto haberek mfi amah ro raa ro msyõf bo ja mhau sai!’” ");
INSERT INTO ayz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tna fo raa ro masu mti msya raa ro maa maka taro sor mama mo kʼYesus mam Samu ro Allah reto. Tna Ait yisoh ana tibyo mrok moof. ");
INSERT INTO ayz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Imam manes ro agama Yahudi msya guru agama wana mros mmat bo reto ye. Ana mmat bo msai ro Ait yno ye tna mari bo kukek mbaut Ait ye mawe, “Hosana kʼNyõ, Ku ro bi Daud yare. Nyõ fi nase toni!” Raa manes ro Yahudi mmat feto, tibyo ana srau kair. ");
INSERT INTO ayz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ana mawe kʼYesus mawe, “Nyõ nari bo ro ana mawe to, fe mfe a?” Ait yawe, “Ae, Jõ tari to. Ja anu nmat Bokom ro Allah far-far refo fefares a? ‘Kbe Nyõ nno tibyo ku mkek msya ku mees ro mait sis mbaut Nyõ ye.’” ");
INSERT INTO ayz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesus ykyas bo weto mkak tna frok sikba kota reto yamoʼt remo ro Betania tna yjin mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Rabu ti ana hah me mamoʼt kota. Ana mamo mam iso maka iti to, Yesus yhai sre. ");
INSERT INTO ayz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tna Ait ymat ara mara sau mros mam iso maam. Ait yamo ymat sas he make aro fee, mata rioh sai. Tibyo Yesus kmo yawe kake reto yawe, “Nyõ meen ne nake u bo fee yum!” Tibyo kake reto mrok samer. ");
INSERT INTO ayz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kuber wAit mmat bo ro Ait yno feto, tibyo ana mrok ktak toni mawe, “Fyi sai oh mi kake reu mrok samer fooh sai u?” ");
INSERT INTO ayz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tna Yesus yawe kʼana yawe, “Soh bosmot wanu matak tna anu nnaut maut-mroh fee; kbe anu nno bawya sai mfi Jõ tno feto ye. Tna mfi bo anu nwe kʼatu rno nwe, ‘Atu rno; natu namo nsya mam aya sawan!’ Soh anu tane fee; kbe bo reto mabo tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tna bo bawya sai ro anu skabuk nyoh mkah bosmot ro matak to, kbe anu nkai tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus hah ye yamo twok mam Samu ro Allah. Ait watum bo mam beto to, imam manes msya raa mabi ro Yahudi mama. Ana mama tna mtu bo kʼAit mawe, “Awya oh mi ybis Nyõ, re Nyõ nama nno bo wefo fo? Tna awya oh mi yoo yatak rait yee kʼNyõ fo?” ");
INSERT INTO ayz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Yesus yawe, “Feto Jõ ttu si bo sau kʼanu ye, tawe: ‘Yohanes Pembaptis tait, ait retait raabis ro Allah fe mfe a?’ Nkyas si kʼJõ wia. Tna fo kbe Jõ tkyas awya ro yoo yatak yee kʼJõ afo re Jõ tno bombra weto sor fo.” Raa manes weto mkyas kʼanya mawe, “Soh bwe Allah oh mi ybis ait to, kbe Yesus yawe, ‘Feto tna fyi re anu ntu sioh bo ro Yohanes yawe?’ ");
INSERT INTO ayz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Raa wefo mnaut mawe Yohanes tait nabi ro Allah ybis yama. Feto soh anu bwe raa sai ybis ait to, kbe raa kmo anu.” ");
INSERT INTO ayz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Feto to ana mawe kʼYesus mawe, “Amu wase ye.” Tna Yesus yawe, “Feto Jõ ye te tkyas tatak aJõ ro tno bombra wefo kʼanu fee ye.” ");
INSERT INTO ayz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus yawe, “Bonaut ranu to nwe fyi? Bi sait yabe ku sme wait mabo ewok. Bi retait yamo yo ku rait ro yabi tna ybis yawe, ‘Ku ajõ; namo nkah bo mam armato anggur ranu.’ ");
INSERT INTO ayz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tna ku retait yawe, ‘Jõ hawe.’ Menohe tis rau ait ynaut myum-yam tibyo yasen yamo ykah bo mam armato reto. ");
INSERT INTO ayz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tna fo bi ait yamo ybis ku sme rait ro tis feto ye. Ku retait yawe, ‘Ae, kbe jõ tamo tisoh.’ Menohe ait yamo fee. Ait yhau sai. ");
INSERT INTO ayz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Feto sik anu nwe: Ku sme mabo ewok reto to, awya ro oh mi yno bo ro yaja ybis to?” Ana mawe, “Ait ro yabi.” Tna Yesus yawe, “Feto ye, anu meen nkus mtis agus. Tna raa ro ja moo namabyoh (pajak) msya fnya ro mwyah bo to, meen ana matim wia mamo raa ro Allah yamo Raja ybo. ");
INSERT INTO ayz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohanes yama yerif iso ro moof kʼanu menohe anu smot ait fee. Raa ro ja moo namabyoh to, msya fnya ro mwyah bo to, ana smot Tuhan oh tna haberek mno bo ro moof ye. Anu ye nmat iso ro moof reto menohe anu nashana tna smot Ait fee.” ");
INSERT INTO ayz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus yawe kʼana yawe, “Nri bofret sau refo naut: ‘Bobot sait yyum anggur mara mawat mam tabam rait. Tna ait yame tok yur ytan. Tna ait yabah kayah sau mkah kbe raa moo anggur make mse maut mberkait tna moo maya rau to. Tna ait sgi harit sau mkah kbe raa mjin kmot armato reto ye. Ait yno bo weto mkak tna fo ybis raa baro yawe ana mkah tna kmot armato anggur rait reto wea, kwiyat kʼana. Ait yawe kbe ana moo make rau to, saim taro hayah kʼait. Tna bobot retait yasen yamoʼt oo roto. ");
INSERT INTO ayz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ait yhau mam oo reto kait. Tna soo ro anggur mara wait weto make manes to, bobot retait ybis sryan wait hah mamoʼt tabam rait, mamo mo kʼraa ro kmot armato reto. Bobot retait ybis sryan wait yawe, “Nkyas kʼana ro kmot armato ajõ nwe ana mryoh anggur make aro moo mee kʼanu. Tna noo anggur make weto nkah nma nee kʼjõ.” ");
INSERT INTO ayz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tna sryan weto masen mamo. Ana mamo snok mam tabam ro bobot rait reto. Menohe raa ro kmot armato reto to huwya mfot sryan weto. Ana mmuk-mak sait, tna mame sait yajat ye, tna moo fraa mai sait naut ye. ");
INSERT INTO ayz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Feto tna bobot retait ybis sryan wait roto taro mawat mamo. Menohe raa huwya sikowah ana mfi sryan ro ait ybis matim wia to ye. ");
INSERT INTO ayz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mamo snok mam tis rau to, bobot retait ybis ku rait yesait ykah yabo yamo. Ait ynaut yawe, “Kbe ana waa ait tibyo mno bo moof kʼait to.” Tna ku ait yasen yamo. ");
INSERT INTO ayz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Menohe raa ro kmot armato anggur reto mmat he ku ait yama. Tna ana mkyas kʼanya mawe, “Ait ro meen shauk armato refo yama mefi! Ait refi yhau ma! Nma, anu bme ait yajat to, afo re meen armato refo mhau kʼanu!” ");
INSERT INTO ayz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tibyo ana mfot ait mkuk makah mamoʼt armato mne rau tna mame ait yajat.’” ");
INSERT INTO ayz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tna Yesus ytu yawe, “Ati ro Bobot ro armato rait retait hah yama to, kbe yno bo bawya kʼana ro kmot armato reto?” ");
INSERT INTO ayz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ana mawe, “Ait kbe yame raa ro mno bo mkair-kar weto. Tna ysan armato anggur reto kʼraa roto taro. Tna ati ro soo ro anggur make mama to, kbe raa weto mryoh to, tna moo taro mee kʼait.” ");
INSERT INTO ayz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tna Yesus yawe, “Ja anu nmat Bokom ro Allah to fe mfe fares a? Bokom reto mawe, ‘Raa saso fraa mawe sgi samu sau. Ana mmat fraa sau mawe mkair. Fraa reto to, ana hawe. Tibyo moo mbeak makus. Menohe ana wase bo fraa reto oh mi fraa ro ati. Tuhan oh mi yno bo reto mabo. Tna anu bnaut bwe bo reto moof toni.’ ");
INSERT INTO ayz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tna feto Jõ tawe kʼanu nbi ro Yahudi fo tawe, kbe anu ne kmot raa mana ro Allah rAit u fee. Kbe Ait yoo raa wAit ysan kʼraa roto kmot afo re kbe ana mno bo ro moof ye.  ");
INSERT INTO ayz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Awya ro btek yai abyõ mam fraa reto to, kbe sasyoh-sasah. Tna awya ro fraa reto btek mai to, kbe sari ye.” ");
INSERT INTO ayz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tna imam manes ro Yahudi msya raa ro Farisi mari bofret ro Yesus ykyas weto. Mari to, ana mhar mawe Ait ykyas bo weto mai kʼana. ");
INSERT INTO ayz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tibyo ana saim bo mawe mfot Ait. Menohe raa makin ro mhau mam weto mnaut mawe Yesus tait nabi ro Allah ybis yama sait. Tibyo raa manes ro Yahudi weto waa bo mfot Ait mam wore raa makin mmat. Ana mnaut mawe kbe raa weto kmo ana. ");
INSERT INTO ayz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tna Yesus fret bo u kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Allah yamo Raja ybo raa mana rAit. Reto mfi bawya? Raja sait yakyõ bokyõ ro ku sme rait ymen fnya tna to. ");
INSERT INTO ayz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Raja retait ybis sryan wait mbo taah mamo mmen raa mama makyõ bokyõ rait. Menohe raa weto hawe. Ana mama fee. ");
INSERT INTO ayz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Feto tna raja retait ybis sryan wait roto taro yawe, ‘Nmo nwe kʼana nwe, “Bo sohmaam ro bokyõ refo jõ siwyan wea oh. Jõ ktan sapi maboh wojõ ro moof sor. Tna msya bo sohmaam roto taro to, jõ siwyan bo ye oh. Ku sme ajõ yoo fnya, feto nma anu bkyõ bokyõ tna sohmaam bo su.”’ ");
INSERT INTO ayz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Menohe raa ro ait yoo taah yee sor to, ana mama fee ye. Sait yamoʼt armato rait. Tna ana taro msui mno bo wana sai. ");
INSERT INTO ayz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tna ana taro mfot sryan ro raja wait weto, sikowah tna mame ana majat ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Raja refi yari sryan wait bo raa mame feto, tibyo ait yrok kmo toni. Tna ait ybis raa ro sbe wait mamo mame raa ro taa mame sryan wait. Tna mbis ana mkah kota rana mait ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ana mno bo weto mkak oh, tna raja retait ytu sryan wait mama. Tna yawe, ‘Bo sohmaam ro bokyõ reto amu siwyan oh, menohe raa ro taa jõ too taah tee to, mama fee. Ana weto mkair tibyo kbe ana sohmaam bo su msya jõ fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Feto to, nsen frok nmoʼt iso krewe makin-akan sor. Tna awya sai ro anu nkai to, nmen ana beta mama sohmaam bo ro bokyõ refo.’ ");
INSERT INTO ayz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tibyo sryan weto mamo tna mmen raa makin-akan ro ana fri mam iso sor to mama beta. Raa ro ana mmen mama to, taro raa ro moof tna taro raa ro mkair ye. Raa msis-sas weto mama tna sohmaam bo su. ");
INSERT INTO ayz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tna raja retait yama ymat sas raa ro hre sohmaam bo su mam bokyõ reto. Ait ymat he raa sait yyum ratan rait ro mkair. Ait yyum ratan ro bokyõ fee. ");
INSERT INTO ayz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Raja ymat feto tna ytu bo kʼait retait yawe, ‘Nyõ namaʼt bokyõ ajõ menohe nyum ratan ro bokyõ to fee! Nno fyi meto?’ Ait retait yari feto menohe shait bait sai. ");
INSERT INTO ayz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tna fo raja ybis sryan wait yawe, ‘Nmo nfot ait retait nke yaa msya yatem tna nkah beak fari mne mam wore wo mamur hto toni to. Meen raa mkai bo ro mkair-kar tibyo mawia kanasyah bo ye mam beto.’” ");
INSERT INTO ayz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tna Yesus yawe, “Allah Ait ytu raa msis-sas mama. Menohe Ait ysok raa mabo kebet baro sai mamo raa wAit.” ");
INSERT INTO ayz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Raa ro Farisi frok mbam yuk reto tna mamo siret su. Tna saim bo mawe kbe ana mtu bo kʼYesus tna sanet Ait feto. ");
INSERT INTO ayz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tibyo ana mbis kuber wana msya raa ro raja Herodes wait baro mamo mtu bo kʼYesus. Ana masen mamo mtu mawe, “Bi Guru; amu nhar nwe Nyõ ja sioh fee. Tna Nyõ waa raa ro manes fee ye. Nyõ beroh nkyas bokyas ro Allah kʼawya sai. Tna iso ro Allah to, ja Nyõ nerif abyõ kʼraa to, nmyõt bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Feto to amu ntu bo kʼNyõ nwe: Allah ksoh yawe anu mbero namabyoh (pajak)kʼKaisar fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Menohe Yesus yhar yawe ana mhaf mkair. Tna yawe, “Anu nmo wan-wan tibyo sioh ntu bo sne mate kʼJõ to, nno fyi meto? ");
INSERT INTO ayz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Noo pitis mauf ro ja raa moo mee mkah namabyoh reto. Nee kʼJõ tmat wia.” Tna ana moo pitis dinar mauf sau mama mee kʼAit ymat. ");
INSERT INTO ayz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tna Ait yawe, “Nmat gambar refo: Raa mkom awya yasom rait mefo?” ");
INSERT INTO ayz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ana mawe, “Kaisar msya bokom rait meto.” Tna Yesus yawe, “Soh feto, bo bawya ro Kaisar rait to, noo nee Kaisar. Tna bo bawya ro Allah rait to, noo nee kʼAllah ye.” ");
INSERT INTO ayz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ana mari bo ro Ait yawe feto, tibyo mrok ktak sai, tna masen sikba Ait mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Rere to, raa ro Saduki baro mama mo kʼYesus. (Raa ro Saduki to raa ro agama Yahudi ye, menohe ana ja mnaut mawe raa ro mhai to, meen me mrok masen fee.) Ana mtu kʼAit mawe, ");
INSERT INTO ayz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Bi Guru; tiwya Musa ykom yawe, ‘Soh raa sait yhai tna ait sano. Semit reto kbe yao kro mkah yabe ku aro mkah shauk biin ait ro yhai retait.’ ");
INSERT INTO ayz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tna amu ntu bo kʼNyõ nwe: Mfi bo raa sme mabo ngkrema mao kʼanya mhau. Tna ro bum ymen fai sau, he ait sano tna yhai kba. Tibyo yao sait yama kro semit rana. ");
INSERT INTO ayz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ait kro menohe yabe ku aro fee ye. Feto ye yao ro tuuf yama kro semit rana naut menohe yabe ku aro fee ye. Feto ye mnan anya sai mamo snok ro ngkrema beta. ");
INSERT INTO ayz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ana ro mao na kʼanya mhai beta mkak. Tna fai au mhai mrof ye.” ");
INSERT INTO ayz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tna raa ro Saduki weto mamo ti te mtu Yesus mawe, “Meen ati ro hai mrok masen to, awya yfain fai reto? Tiwya ana mabo ngkrema ye mfain fai au reto ye fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Menohe Yesus yawe, “Bonaut ranu mkair meto. Anu wase Bokom ro Allah msya Ait yatak rAit ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Meen ati ro raa mrok masen to, raa moo fnya u fee tna fnya msya raa u fee ye. Malaikat sor ja moo fnya fee. Meen raa mhau sai mfi malaikat mam sawro ro Allah. ");
INSERT INTO ayz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Nnaut nwe Allah ykyas raa ro mhai tna meen mrok masen to yawe, ‘Jõ fi Allah ro Abraham, Ishak msya Yakub ja smot.’ Keluaran 3:6 Anu bhar bwe hohos wanu weto ro mhai ooh oh. Menohe Allah yawe feto tibyo anu bhar bwe ana mhai tibyo fee. Allah yawe ana mhau mam sawro rAit smot Ait fares to.” ");
INSERT INTO ayz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Raa msis-sas weto mari feto, tibyo ana mrok ktak bokyas ro Ait ykyas reto sai. ");
INSERT INTO ayz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Raa ro Farisi mari he Yesus ykyas bo kʼraa ro Saduki tna yno re ana mmai u fee. Feto to ana ro Farisi mamo mtu bo kʼYesus ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ana sait yamo guru agama Yahudi. Ait yawe sanet ytu bo kʼYesus yawe, ");
INSERT INTO ayz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Guru; watum ryo oh mi mase toni mam Watum ro Musa to?” ");
INSERT INTO ayz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus yawe, “Nhafri Tuhan Allah ranu mkah nhaf, srau wanu beta, tna mkah bohar ranu beta ye. ");
INSERT INTO ayz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Watum ro tinyi msya watum ro mase ye oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tna watum ro ewok mnan reto ye: ‘Nhafri raa ro mhau kene msya anu to ye. Nhafri ana mnan fi anu nhafri netsu wanu nesait ai to.’ ");
INSERT INTO ayz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Watum ro tiwya Musa ysya nabi na mkom to, masmair rau to mbam watum ewok refo ye.” ");
INSERT INTO ayz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Raa ro Farisi mkyas bo su wea, tna Yesus yama ytu kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Anu nnaut Mesias tait nwe fyi? Ait tait Ku ro bi awya yare?” Menohe ana mawe, “Mesias tait Kube ro Daud.” ");
INSERT INTO ayz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus yawe, “Tiwya Har ro Tuhan misbyõ bi Daud ybis ait ykyas Mesias to, menohe ytu Ait yawe, ‘Tuan ajõ’. Tiwya Daud yawe, ");
INSERT INTO ayz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tuhan yawe kʼTuan ajõ yawe, “Nama, hre nsya Jõ mam ati ro tatem ati; hroh ro mase reto. Hre wea. Tna raa ro byoh, raa ro srau kair kʼNyõ to, meen tno ana mbtek mam mte. Kbe Nyõ naa nber ana weto. Tna Nyõ nros natak abyõ, nbo ana.”’” ");
INSERT INTO ayz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yesus yawe u yawe, “Tiwya Daud ytu Mesias‘Tuan rait’ to, fyi re anu nkyas nwe Mesias tait Kube ro Daud?” ");
INSERT INTO ayz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Feto tibyo raa sait bo yatak ykyas bo si kʼAit fee. Tna raa aro ter-ter mtu bo kʼYesus u fee. ");
INSERT INTO ayz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesus ykyas kʼraa makin msya kuber wAit sor yawe, ");
INSERT INTO ayz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Guru agama Yahudi msya raa ro Farisi to, ana shauk hroh ro Musa. ");
INSERT INTO ayz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Feto to nri oh; Jõ ksoh anu nri watum rana. Tna nno bo bawya sai ro ana mbis kʼanu to. Menohe nno nfi ana ma: Ja ana mno bo ro ana mesait mkyas weto fee! ");
INSERT INTO ayz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ana mbis anu nno bo ro samyoh. Watum rana mfi bo samyoh ro ana make tubat tna mse kʼraa roto masom. Menohe ana mesait mbet raa weto msya ana masom su fee. ");
INSERT INTO ayz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Raa ro Farisi, ana mkom Watum ro Allah baro mam ratan ro ana myum. Tna ratan ro ana myum to, betau mafyan miyõ kro mamo snok mte ye. Bo ro ana mno weto beta to, ana mawe mno afo re raa mmat tna bibi ana ye. ");
INSERT INTO ayz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Soh ana mamoʼt bokyõ to, ja ana msok ambar ro moof tna hre. Tna soh mamoʼt samu watum to, ana ksoh hre mam ambar raa ro mase ja hre. ");
INSERT INTO ayz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ana ksoh bo raa hartu ana, mmah meen kʼana mam pasar tna mtu ana mawe, ‘Bi Guru’ to. ");
INSERT INTO ayz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nno feto ma. Guru ranu sait aran sai. Tna anu beta to nnan anya sai. Feto to, nwe raa mtu anu ‘guru rana’ to ma. ");
INSERT INTO ayz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tna Bja ranu tait sait aran. Ait yhau mam sawro rAit. Feto to, nwe raa ro yhau mam tabam ‘anu bja ranu’ to ma. ");
INSERT INTO ayz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mesias yesait aran oh mi yamo aban mana ranu to. Feto to, nwe anu aro nmo aban mana bo to ma. ");
INSERT INTO ayz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Awya ro yase ybo anu to, kbe ait yamo raabis ranu tna yno bo wanu wia. ");
INSERT INTO ayz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tna awya ro yawe, ‘Jõ fi raa ro tase.’ kbe Allah yno ait haberek yamo raabis ranu tna yno bo wanu ye. Tna awya ro kbor sneh yamo raabis ranu to, kbe Allah yno ait haberek yamo raa ro yase ye. ");
INSERT INTO ayz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Anu guru agama Yahudi nsya raa ro Farisi: Anu fo raa ro ja sioh-sah sai! Anu nmo raa ro Allah yamo Raja ybo to, fee. Tna soh raa roto mawe tomer mamo raa wAit to, anu ja nno wa. Feto to, meen kair mama mai kʼanu tu oh.  ");
INSERT INTO ayz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Anu guru agama nsya raa ro Farisi: Anu fo raa ro ja sioh-sah anu sai! Anu skabuk miyõ wer afo re raa mmat anu. Ana mmat feto tna mnaut mawe anu raa ro ja nno bo moof sai. Semit mnaut mawe anu raa ro ja nno bo ro moof ye menohe anu haberek sifuut ana, tna soyak amah wana no kʼanu. Feto to, meen bo ro mkair toni mama mai kʼanu tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Anu guru agama nsya raa ro Farisi: Anu fo raa ro sioh-sah anu sai! Anu safo triar nmo fari; anu frit sawan ye tna nmo iso mne ro miyõ mbra sor ye. Anu nmo to, nwe nno raa sait beak bosmot rait tna haberek kro bosmot ranu. Soh ait haberek tna kro agama ranu to, yamo kuber ranu to, kbe anu nber ait kaket fee. Anu nkyas watum ro mkair tibyo ait yamo yfi anu. Kbe ait raa ro sioh ait sai ye. Tis rau ykair-kar. Meen Allah yoo ait yse mam tafoh ro arin kair reto ye. Anu ja nber ait, nerif iso ro sre kʼait. Feto to meen bo ro mkair btek mai kʼanu tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Anu fo raa ro nerif iso kʼraa roto menohe anu nesait nsu mboh! Anu nesait wase iso nmo. Anu nwe, ‘Soh raa sumpah mtom Samu ro Allah to, kbe bo sumpah reto matak fee.’ Menohe anu nwe, ‘Soh raa sumpah mtom emas ro mhau mam Samu ro Allah to, kbe bo sumpah reto matak ye.’ Anu nkyas feto tibyo meen bo ro mkair btek mai kʼanu tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Anu fo raa ro wase bo tna nsu mboh! Bo ro moof to, au myo? Emas reto to, bo ro ati meto fee. Samu ro Allah oh mi mno re emas reto moof toni mnan si bo ro Allah rAit to. ");
INSERT INTO ayz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tna anu nwe, ‘Awya ro sumpah ytom wohat (mezbah) ro raa msan bo kʼAllah to, bo sumpah reto matak fee. Menohe soh raa sumpah ytom kak ro raa msan abyõ mam wohat reto to, kbe kak reto make bo sumpah reto matak ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Anu fo raa ro nsu mboh! Bo ro moof to, au miyo? Kak mesait reto bo ro ati meto fee. Menohe soh raa moo kak reto mse abyõ mam wohat tna msan kʼAllah to, wohat oh mi mno re kak reto moof mnan si re Allah ksoh to. ");
INSERT INTO ayz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Feto to, awya ro sumpah ytom wohat reto to, ait sumpah mkah bombra ro raa msan kʼAllah mam wohat abyõ ye oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tna awya ro sumpah ytom Samu ro Allah to, ait sumpah ytom samu reto, tna msya Allah ro yhau mam samu mato reto ye. ");
INSERT INTO ayz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tna awya ro sumpah ytom sawro ro Allah to, ait sumpah ytom Allah ro hre abyõ tna yhau mam sawro reto ye oh.” ");
INSERT INTO ayz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Anu guru agama Yahudi nsya raa ro Farisi to: Anu fo raa ro ja sioh-sah anu sai! Anu nwe ja anu nbo Watum ro Musa kaket. Tna re ja bombra bawya sai anu noo baro nsan kʼAllah. Feto tna bo saryoh kinyah ro ja anu nyum mam armato wanu mkah bo nfiat bo ro anu sohmaam to, anu noo baro nsan kʼAllah ye: Mfi selasih,adasmanis, msya jintan bo to, ja anu noo baro nsan kʼAllah ye (persepuluhan). Bo ro maku reto anu nno. Menohe ja anu niwana bo ro ati: Anu nno bo moof kʼraa fee. Anu natmof raa fee. Tna anu smot Allah kaket fee ye. Bo ro ati weto to, anu nbo nno fee! Feto to, meen kair mama mai kʼanu tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anu fo nnaut nwe anu nhar iso ro Allah kaket re nerif kʼraa roto ye. He mfe. Anu fo raa ro nsu mboh! Soh anu nmat bubaa mam hawereh mato to, anu noo beak. Menohe unta maboh ro mhau mam hawereh mato to, anu nta niya u mamoʼt nhaf mato! ");
INSERT INTO ayz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Anu guru agama nsya raa ro Farisi: Anu fo raa ro ja sioh-sah anu sai! Hawereh msya piring to, anu nyon mne rau moof kaket. Menohe mato rau to, mkair fares. Anu nesait nfi feto ye. Anu to noof mne sai. Menohe nhaf mato wanu to, mkair: Ja anu nasmamo tna ntak bo raa ye. Feto to, meen kair mama mai kʼanu tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Anu raa Farisi to, raa ro nsu mboh! Nyon hawereh marak msya piring ro anu nsyõ boit to, nyon mato moof wia. Nno feto afo re kbe mne to, moof ye. ");
INSERT INTO ayz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Anu guru agama nsya raa ro Farisi: Anu fo raa ro sioh-sah anu sai! Ja raa moo hai sama mam isra mato. Tna mawah cat mate isra mne rau. Mno feto tna kbe raa mmat moof toni. Menohe mato rau to, mkair: raa mtai msya afan bo mrek-rek yiis ye. Anu nesait nfi isra weto. Anu ja nno bo re kbe raa mmat tna mawe anu raa ro moof. Menohe anu nhaf mato ranu to, mkair. Feto to, meen kair mama mai kʼanu tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Anu guru agama nsya raa ro Farisi: Anu raa ro ja sioh-sah anu sai! Meen bo ro mkair btek mai kʼanu! ⌞Tiwya Allah ybis nabi na mama. Tna hohos ranu mame nabi weto majat.⌟ Mfo refo anu ja nisoh isra ro tiwya tinyi raa sama nabi weto. Tna raa ro tiwya mno bo ro Allah ksoh to, kubur wana to, ja anu fayir moof ye. Anu nno feto to, nnaut nwe anu nno bo moof miwrek hohos wanu. ");
INSERT INTO ayz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Anu sioh anu nwe, ‘Mfi bo tiwya tinyi amu nhau ye mam wore amu hohos na mhau weto to, maami amu aro nno bo nfi ana fee. Amu nme nabi weto fee.’ ");
INSERT INTO ayz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Menohe anu nesait nwe bo ranu ai oh nwe anu fo nbam raa mana ro tiwya mame nabi na sor to. ");
INSERT INTO ayz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Feto ye, kbe anu nme raabis ro Allah wAit mnan fi anu hohos na wanu tiwya tinyi mno wia to. ");
INSERT INTO ayz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Anu fo raa ro ja nno safo yoyo! Anu nfi abboh ro ja mafit raa majat to! Fyi re anu nwe nsam nmo sikba bo mkair-kar ro meen btek mai kʼanu mam rabin ro arin kair to? ");
INSERT INTO ayz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nri kaket: Kbe Jõ tbis nabi na woJõ, msya raa ro ja mhar bo kaket, msya guru taro ye mama mo kʼanu. Ana taro to, meen anu nme majat. Tna ana taro to, kbe anu nme majat mam ara warok ye. Tna taro to, kbe anu sikowah ana ye. Tna kbe anu nbo too nmok-mak ana mam samu watum wanu to. Meen anu nikyak raa woJõ taro nbam kota ranu tna anu saka ana msam mamo snok mam kota roto taro ye. ");
INSERT INTO ayz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tiwya raa ro ja mno bo ro Allah ksoh to, hohos na wanu nfot ana mame. Ana oh mi maban Habel mamo snok bi Zakharia (ro bi Berekhya yare tait. Anu hohos na mame Zakharia yajat susai mam Samu ro Allah jaro tna mam wohat (mezbah) jaro si masuf.) Safo weto beta to meen anu nsom isti tu oh. ");
INSERT INTO ayz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nri kaket; safo weto meen anu beta nsom tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Raa ro Yerusalem mame nabi ro Allah sor majat. Tna raa ro Allah ybis mamo mkyas bokyas rAit to, ja raa ro Yerusalem mame ana majat ye. Ana moo fraa mai raa weto tibyo majat. Muhrin aro rau-rau Jõ srau kero ana. Tawe tatmof ana tna takrao ana tse mam wo sau re kmot ana. Mfi kook mabi ro makrao maku tna maut mabum kait to ye. Menohe anu hawe ye. Feto to Jõ sraujin raa ro Yerusalem, bo ro meen mama mai kʼana: ");
INSERT INTO ayz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Allah kbe meen yatam ana ro mhau mam Yerusalem u fee. Ait sikba ana agus. ");
INSERT INTO ayz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kbe Jõ sikba tabam refo tna anu nmat Jõ u fee. Anu nmat Jõ fee mamo snok mam ati ro tabam refo haberek. Tna ati reto meen anu nanwaruk nwe, ‘Ait yase toni! Tuhan ybis Ait yama tu oh.’” ");
INSERT INTO ayz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus sikba Samu ro Allah yamo. Tna kuber wAit mama mo kʼAit tna merif koot ro Samu ro Allah mros to kʼAit. ");
INSERT INTO ayz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tna Yesus haberek yawe, “Nmat samu weto beta. Meen raa mitrah samu weto. Tna kbe tembok msya fraa sau bo mhau matak ntar-tar anya u fee. Kbe fraa weto sgik mbtek mai tabam beta.” ");
INSERT INTO ayz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus yaut yamo hre mam Faut ro Zaitun. Tna kuber wAit mama mkyas bo msya Ait yesait kar. Ana mtu bo kʼAit mawe, “Tija re bo ro Nyõ nkyas weto mabo to? Kbe amu nmat bo bawya re nhar nwe oon mabu ro Nyõ nama to? Tna amu nmat bo bawya re nhar nwe tabam refo kene sboh rau ye to?” ");
INSERT INTO ayz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus yawe, “Kaket anu! Nno be raa mama sioh besruf anu. ");
INSERT INTO ayz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Jõ fi Mesias sait aran. Menohe meen raa mawat mama tna sruf bo mawe ana Mesias ybam kʼAllah. Kbe raa mawat mari feto tna smot raa weto. ");
INSERT INTO ayz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kbe anu nri he raa rabin taro meanya tna mafa mnin-nin. Bo weto kbe mabo tu oh. Menohe waa ma: Bo weto kbe frok matim wia. Bo weto frok mama tna tabam refo ayõ rau ro haberek tetara fee. ");
INSERT INTO ayz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tna raa ro bangsa sau kbe masen mame anya msya raa ro bangsa roto taro. Tna raa ro raja sait ybo kbe masen mame anya msya raa ro raja roto taro mbo ye. Tna kbe hai awyah btek mai kʼraa, tna kbe iin frok mam wore aro rau-rau ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Menohe bo ro samyoh weto beta to makit rau sai fares meto. Wore wo anu nmat bo weto to, kbe anu nhar nwe oon reto mabo oh. Reto mfi fnya ro mhaf ja kborham wia, tna kbe mabe ku to. ");
INSERT INTO ayz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Anu nkro Jõ to, tibyo kbe raa mfot anu msan kʼraa sikowah tna mame anu njat ye. Tna raa bangsa ro tabam refo beta kbe knait anu. ");
INSERT INTO ayz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ati reto to, raa mawat ro tiwya smot Jõ wia to, kbe haberek. Tna kbe ana hren ksuk kʼanya ye tna knait anya ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tna kbe raa mawat mama sioh raa mawe, ana to nabi ro Allah ybis mama mkyas bo wAit. He mfe. Bo ro ana mkyas to, kbe raa mawat mari tna kro ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bo mkair-kar ro mfo wefo raa mno sor to, mrok msai renti. Tibyo raa mawat kbe miranya kaket u fee. ");
INSERT INTO ayz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tna awya ro bito smot Jõ matak mamo snok mam oon sboh rau to, meen ait ykai riof ro mase. ");
INSERT INTO ayz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tna bokyas moof ro mkyas raa mana ro Allah yamo Raja ybo to, kbe raa mkyas. Mkyas kʼraa ro bangsa makin mam arin aso refo beta mari. Mari wia tna fo oon rau sboh oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tna Yesus yawe, “Nmat bokom refo tna kbe anu nfot bo ro Jõ tawe kʼanu: Tiwya Allah ybis nabi Daniel ykyas yawe, ‘Meen bo sau ro mkair toni mama sikowah yuk ro mbau to.’ Daniel 9:27, 11:31, 12:11 Jõ tawe kʼanu tawe, ati ro anu nmat bo reto mabo to, anu nhar nwe kene mam wore wo tabam refo haberek. Ati ro anu nmat bo reto to, ");
INSERT INTO ayz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","anu ro nhau mam provinsi ro Yudea to; nsen nsam nmo nuut atu mana. ");
INSERT INTO ayz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Anu ro hre abyõ mam samu wanu kri-kri to; kbe nroh satoh bo wanu mbam amah mato nbo frok to ma! Bo weto makus rof. ");
INSERT INTO ayz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Anu ro nkah bo mam armato to; hah ne nmo noo ratan wanu ma. Nsam fooh nmo sai. ");
INSERT INTO ayz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wore weto to, fnya ro mhaf tna msya fnya ro mee sis ku mees wana fares to, ana mmof toni. Ana kbe matak msam fooh fee. ");
INSERT INTO ayz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Skabuk nyoh Tuhan afo re meen ati ro anu nsam to, nsam mam snyi ro ja oom maah mais to ma. Tna re meen anu nsam mam ayõ ro raa ntmoh (hari Sabat) bo to ma ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Meen wore weto to, arin mkair toni. Maban tiwya tinyi Allah sair tabam refo mamo snok mam mfo refo fo, raa mkai bo ro mfi feto aro fee. Tna bo ro mkair-kar mfi feto to, aro meen me btek mai kʼraa u fee. ");
INSERT INTO ayz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Oon ro samyoh reto to, oos mawe Allah yatmof raa sok wAit. Feto to yawe yisusu oon reto mabuf baro. Soh mfe to, raa sait bo meen ye yhau fee. Soh mfe to, raa beta mhai. ");
INSERT INTO ayz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Meen, ati reto to, raa ro mawe besruf anu to, kbe frok mama. Taro mawe ana to Mesias, he mfe. Tna taro mawe ana to nabi ro Allah ybis mama mkyas bo wAit. He mfe ye. Wore weto to ana sair bo ro hnah. Tna mno bo ro msai mawat ye. Ana mawe besruf raa beta. Ana tomer besruf raa sok ro Allah wAit ye he mfe. Feto to, soh raa sait yawe kʼanu yawe, ‘Nmat, Mesias yama mam ati rno mno!’ Soh yawe feto to, nri ait ma! Tna soh sait yawe kʼanu yawe, ‘Nmat, Mesias yama mam ati rau mau.’ Nri bo ro yawe to ma! ");
INSERT INTO ayz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nnaut bo ro tawe kʼanu fo. Jõ tkyas bo refo kʼanu wia wore wo bo weto frok mama fefares to. ");
INSERT INTO ayz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Soh raa mawe kʼanu mawe, ‘Nmat, Mesias yama oh mam tabam ro riamo yama oh!’ Soh raa mawe feto to, nri ana ma. Nmo teto ma. Tna soh raa mawe, ‘Mesias yama yhau mam amah rno hawar jaro oh!’ Soh raa mawe feto to, nri ana ma ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ati ro 'Ait ro Yroh Yama Yfi Raa Sai' yama to, kbe raa beta mmat tna mhar mawe Ait yama. Soh rir mrir mbukak abyõ mam ayoh to, ja raa mmat rir reto maban ati ro ayõ maut mamo snok mam ati ro ayõ twok to. Jõ te tama u to, kbe raa beta mmat tna mhar Jõ feto ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tna wore bo ro mhai mhau akus to, hofyoh yiis mhar ye oh. Tna ana mawat mama fru-fra mamo-me mam yuk reto ye.” ");
INSERT INTO ayz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Oon ro samyoh reto mkak wia, tna ayõ mrok mti mamur ye, tna snyi mrok mawyah fee ye, tna sken ro mhau abyõ mam ayoh to btek-tak ye, tna bombra ro mhau abyõ mam ayoh to mrok mnah-nah mamo mai jaro-jaro ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mam ayõ reto to, raa mmat ayoh. Ana mmat bo tna mhar mawe, 'Ait ro Yroh Yama Yfi Raa Sai' yama mefo. Raa bangsa beta mam tabam refo to, mmat bo reto. Mmat tibyo mrok mawyan surut ana mkak. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen ati reto to, raa mmat Jõ tbam ayoh mboh abyõ troh tama. Tama to, raa mmat tatak aJõ msya tase aJõ ro msai ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tna saa buk-buk mawia. Feto tna Ait ybis malaikat wAit mama msok raa sok wAit moo mbam arin aso wofo beta. ");
INSERT INTO ayz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bofret ro kake mara reto to, nnaut maja rau kaket: Soh nkre ro mo safom tna sne-sne moof to, feto to anu nhar nwe kene wore snyi ro hwyõm oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Feto ye, soh anu nmat bo weto beta mama to, anu nhar nwe oon ro Jõ tama u to, kene oh meto. ");
INSERT INTO ayz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nnaut: Ati ro bo wefo beta mama to, tawe biin reto to, kbe raa taro mhau fares. ");
INSERT INTO ayz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ayoh msya tabam refo kbe saef marak. Menohe bokyas aJõ kbe meen mhau mawyõs mamo snok mam hame wajin. ");
INSERT INTO ayz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ayõ ro Jõ tama u to, raa sait bo yhar fee. Malaikat ana wase ye. Jõ, Ku ro Allah yare fi twase ye. Taja yesait aran yhar bo rAit.” ");
INSERT INTO ayz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tna Yesus yawe, “'Ait ro Yroh Yama Yfi Raa Sai' meen hah ye yama. Ait hah ye yama to, kbe raa mhau mno bo wana mnan wore wo tiwya Nuh yhau: ");
INSERT INTO ayz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tiwya mam wore aya mabo betru tabam refo fefares to, ja raa mnaut mamos wana fee. Raa mait bo sai. Tna raa msya fnya moo anya sai. Raa mno bo weto mamo snok mam ati ro Nuh twok mam wiak aken rait to. ");
INSERT INTO ayz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ati reto raa mhau ninya sai. Tna aya mabo frok mama betru ana msu beta. Meen ati ro 'Ait ro Yroh Yama Yfi Raa Sai' yama to, arin to, mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ati reto to, raa mabo ewok mkah bo mam armato rana. Kbe malaikat woJõ mroh tubat sait tna sait yhau agus. ");
INSERT INTO ayz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tna fnya mabo ewok hre mmuk gandum make to ye. Kbe malaikat woJõ mroh tubat sau tna sau mhau agus ye. ");
INSERT INTO ayz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Anu ye wase oon ro Tuhan ranu yama. Feto to, hre byõ-abyõ sai. ");
INSERT INTO ayz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nnaut bofret refo kaket wia: Bi sait yhar yawe, ‘Mti fo, kbe raa ro ja ysyõf bo yama yitrah amah ajõ tna ysyõf bo wojõ.’ Soh ait yhar ayõ raa ro ysyõf bo retait ysaim to, kbe ait yjin fee. Yhau wan afo re raa ysyõf bo wait fee. ");
INSERT INTO ayz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Ait ro Yroh Yama Yfi Raa Sai' kbe meen yama u. Kbe hah yama u mam ayõ ro anu wase tna kbe nwof Ait fee. Feto to nhau siwyan Ait yoyo.” ");
INSERT INTO ayz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","Yesus yawe, “Bobot sait ysok sryan wait sait yamo aban mana ybo sryan wait roto taro. Tna ybis sryan retait yoo boit saim kʼsrian anya wait roto taro ye. Tna bobot retait yasen yamoʼt oo roto. Soh sryan retait mur-mur yno bo ro Bobot ybis to, ait tait sryan ro yhar bo. Tna ati ro bobot retait yhah ye yama to, soh ait ymat aban mana retait ja yno bo rait ro ybis kaket to, feto moof. ");
INSERT INTO ayz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nri kaket: Kbe bobot ysok sryan ro yari bo ro ait yawe retait yse kmot bombra wait beta. ");
INSERT INTO ayz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Menohe mfi bo sryan ro yamo aban mana retait tait yhaf rait mkair. Tna ynaut yawe, ‘Bobot ajõ yarak, kbe yhah yama fooh fee.’ ");
INSERT INTO ayz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Feto tna ait yno bo ro mkair: Ait yai sryan ro kinyah taro. Tna yasmamo yait boit, yata aya ysya raa ro ja bisir-basar sai. ");
INSERT INTO ayz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kbe bobot rait snok yama. Yama mam ayõ ro sryan ro yamo aban mana retait siwyan fee. Bobot rait snok yama tna ymat bo mkair ro sryan retait yno. ");
INSERT INTO ayz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tibyo bobot retait kmo. Kbe ait simoyot-mayat sryan retait. Tna ybis ait yamo yhau mam yuk ro kair. Tibyo yamo yhau mam weto su ysya raa ro ja sioh ana ai to. Mam weto to, kbe raa mawia tna kanasyah ye.” ");
INSERT INTO ayz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","⌞Yesus ksoh re raa siwyan ana mamo raa mana ro Allah yamo Raja ybo to.⌟ Tna Ait yawe kʼana yawe, “Oon ro Allah yamo Raja ybo raa mana rAit to, ⌞raa taro siwyan fee, kbe ntwok fee.⌟ Reto mfi ku ano mabo nsaa mbo pelita wana mamo mawe mtar ku sme ro siwyan yoo fnya ro tna. ");
INSERT INTO ayz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ana ro ano mabo nsaa reto to, mabo maat mhar bo, tna mabo maat wase bo. ");
INSERT INTO ayz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ana ro wase bo to, mbo pelita wana marak sai, minyak aro fee. ");
INSERT INTO ayz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tna ana ro mhar bo to, mbo pelita wana, tna mbo minyak wana mkah kusia ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tna ku sme ro ana ste retait yama fee kait sai. Tibyo ana mjin maka, tna mjin tu ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tna mam wore arin masuf raa sait ytu yawe, ‘Ait ro yoo fnya retait yama oh! Nsen ntar-tar ait!’ ");
INSERT INTO ayz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tna ku ano wefo mrok masen misoh pelita wana. ");
INSERT INTO ayz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ku ano ro wase bo, ana mayoh kʼana ro mhar bo mawe, ‘Pelita wanu minyak marak, tna kene wore mhai! Noo minyak wanu baro nee kʼamu.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Menohe ku ano ro mhar bo mawe, ‘Minyak wamu mnan amu oh. Fyi re amu noo baro nee kʼanu? Nmo no kʼraa ro masim minyak tna noo aro kʼanu!’ ");
INSERT INTO ayz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ku ano ro wase bo weto masen mamo saso minyak. Ana marak tna ku sme ro yoo fnya retait yama. Tna ana ro siwyan wea kro ait mamo twok mam amah ro raa makyõ bokyõ. Tna raa muut mato matak wa. ");
INSERT INTO ayz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tna ku ano mabo maat ro wase bo weto mama tna mtu mawe, ‘Bobot (Tuan), nitrah mato kʼamu.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Menohe ait yawe, ‘Jõ wase anu ye.’” ");
INSERT INTO ayz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesus ykyas bofret reto maum oh meto tna yawe, “Anu ye wase ayõ ro Tuhan ranu yama. Feto to, hre byõ-abyõ wea kaket.” ");
INSERT INTO ayz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tna Yesus yawe, “Allah yamo Raja ybo raa mana rAit to. Reto mfi bobot sait ro yawe yamoʼt rabin ro fari-fara sau. Tna ait ytu sryan wait mama tna ait ysan kta wait taro kʼana somya ha-hayah ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ait saim kta weto kʼana mamyot ana matak rana ro kbe ntho. Sryan sait to ait fyah pitis talenta trion maat. Tna ait sait naut fyah pitis talenta ewok ye. Tna sryan sait naut fyah pitis talenta sau sai. Bobot retait saim bo weto kʼana agus tna fo yasen yamo. ");
INSERT INTO ayz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sryan ro bofyah pitis maat retait yakah wait yamo somya renti, tna raa ntho. Tibyo maru amot maat naut miryõ. ");
INSERT INTO ayz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tna sryan ro bofyah pitis ewok yakah wait yamo somya renti tna raa ntho. Tibyo maru amot ewok naut miryõ ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Menohe ait ro bofyah pitis sau sai fi yakah wait yamo yabah tabam saa. ");
INSERT INTO ayz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ti mase firwas oh, tna bobot ro ysan kta wait hah ye yama. Tna ait ytu sryan ro bofyah wait weto to mama. Tna yawe kʼana yawe, ‘Tho bo wojõ oh!’ ");
INSERT INTO ayz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tibyo sryan ro ait fyah pitis wait maat reto yama tho pitis wait tna yaru amot maat naut yiryõ. Tna yawe, ‘Bobot, tiwya nyõ noo pitis wonyõ trion maat fyah jõ. Tna jõ te tho tibyo taru amot maat naut tiryõ. Tna pitis wonyõ fo nsaa beta oh mefo.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tna bobot yawe, ‘Nyõ nno bo ro moof to. Tiwya jõ too bo kebet sai tsan kʼnyõ. Menohe nyõ nisoh nbo nno kaket tibyo mrok mafer mawat ye. Nyõ mur-mur nno bo wojõ. Feto kbe jõ te tsan bo mase taro renti naut kʼnyõ nbo nno ye. Nama nhau nsya jõ. Bo yase wojõ anu bhaf bse su. Kbe anu simaut mase su.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tna fo sryan ro bobot fyah pitis wait trion ewok retait yama. Ait tho pitis bobot rait tna yaru amot ewok naut yiryõ. Tna sryan retait yawe, ‘Bobot, tiwya nyõ noo pitis wonyõ trion ewok fyah jõ. Tna jõ te tho tibyo taru amot ewok naut tiryõ. Tna pitis wonyõ trion jiit beta oh mefo.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tna bobot retait yawe, ‘Nyõ nno bo ro moof meto. Nyõ mur-mur nno bo wojõ. Feto kbe jõ te tsan bo mase taro renti naut kʼnyõ nbo nno ye. Nama nhau nsya jõ. Bo yase wojõ anu bhaf bse su. Kbe anu simaut mase su.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tna fo sryan ro tiwya bobot yoo pitis sau aran sai fyah tait yama. Tna ait yawe, ‘Bobot; Jõ thar tawe nyõ tait raa ro ja naya ma toni. Nyõ raa ro ja nryoh kake mam armato ro nyõ nyum fee. Tna nyõ soo bomafer mbam armato ro nyõ furere manaf to fee ye. Tiwya nyõ noo pitis wonyõ fyah kʼamu nawe amu nmo somya renti re makit mase kʼnyõ. ");
INSERT INTO ayz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Menohe jõ waa. Tibyo too pitis ro nyõ noo nee sau reto tamo tabah tabam saa sai. Pitis wonyõ oh mefo.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Menohe bobot retait yawe, ‘Nyõ nno bo mkair. Nyõ haweboh ye. Nyõ nhar nawe jõ raa ro tryoh kake mam armato ro jõ tyum fee. Tna jõ soo bomafer mbam armato ro jõ furere manaf to fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Feto to, rau ro moof to, tiwya nyõ nakah pitis wojõ namo nse mam bank sai. Afo re kbe jõ tama tna too mabo msya mabyoh rau ye fea!’ ");
INSERT INTO ayz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tna bobot yawe kʼraa wait yawe, ‘Tiwya ait ybo pitis weto yamo somya fee. Feto to, noo pitis weto namo niryõ kʼait ro ybo pitis trion nsaa tait. ");
INSERT INTO ayz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Awya ro yisoh bo wait kaket moof, kbe raa moo bo taro naut miryõ kʼait ye. Menohe awya ro hawe yisoh bo rait kaket to, kbe raa mrof moo bo rait ro yse weto. ");
INSERT INTO ayz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nfot sryan ro yno bo mkair retait nwah beak fari yamoʼt wore wo mamur htoh toni. Mam yuk reto to, meen raa mkai bo ro mkair-kar tna mawia, kanasyah ye.’” ");
INSERT INTO ayz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen Jõ tama to, tama tkah tase aJõ. Tna malaikat woJõ beta kro Jõ ntayun mama ye. Tna Jõ kbe tamo Raja hre abyõ mam yuk ro msai tbo raa beta ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tna malaikat weto kbe makrao raa ro bangsa beta makah mama mo kʼJõ. Tna Jõ kbe tsok ana betwat tse mam mkbair ewok hayah-hayah mfi raa ro ja msia hewan to. Ana ja msok domba mse mkbair sau hayah tna kambing mse mkbair sau hayah. ");
INSERT INTO ayz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Domba to, Jõ tsok tse hayah mam ati ro tatem ati. Tna kambing to, tse hayah mam ati ro tem ta ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tna fo Jõ tamo Raja tna tawe kʼana ro mhau mam tatem ati aJõ to, tawe, ‘Taja yno bo moof kʼanu. Nma nkai sawro ro Jõ tamo Raja tbo. Tiwya tinyi Tuhan sair tabam refo to, Ait ysok anu yawe meen nkai sawro rAit reto ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Anu nno bo ro moof tibyo nkai sawro rAit to. Tiwya Jõ thai sre to, anu noo boit nee kʼJõ tait. Tna Jõ thai sbit to, anu nwyan aya nee kʼJõ tata. Tna Jõ tsu srim ye mam remo ranu to, anu noo Jõ nse tjin mam amah ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tna ratan ro Jõ tyum marak to, anu noo ratan nee kʼJõ tyum ye. Tna Jõ kiyam to, anu nma kmot Jõ ye. Tna raa mbu Jõ mam bui to, anu nma nmat Jõ ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tna raa ro ja mno bo ro Allah ksoh weto meen mawe kʼAit mawe, ‘Tuhan; tiwya Nyõ nhai sre mam woyõ re amu noo boit nee kʼNyõ nait to? Tna mam woyõ oh mi amu nmat Nyõ nhai sbit re nwyan aya nee kʼNyõ nata to? ");
INSERT INTO ayz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tiwya amu nmat Nyõ nsu srim mam woyõ re amu noo Nyõ nse mam amah to? Tiwya amu nmat Nyõ ratan marak mam woyõ re amu noo ratan nee kʼNyõ nyum to? ");
INSERT INTO ayz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tiwya Nyõ kiyam mam woyõ re amu nma nmat Nyõ to? Tiwya Nyõ raa mfot mbu mam bui woyõ re amu nma nmat Nyõ to?’ ");
INSERT INTO ayz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jõ fi Raja retait. Meen Jõ tawe kʼana tawe, ‘Nri kaket: Bo bawya sai ro anu nno kʼraa kinyah wanu to, ro suawe sor to, bo weto anu nno kʼJõ oh meto.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tna Jõ tawe kʼana ro mhau mam tatem ta to tawe, ‘Nsen frok nbam wefo nmo oh! Kbe bo ro msai btek mai kʼanu. Anu kbe nmo niit mam tafoh roon ro Allah siwyan mkah bo ykah kabes yabi (Iblis) ysya malaikat wait sor. ");
INSERT INTO ayz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tiwya anu nno bo ro mkair, tibyo anu nmo niit mam tafoh reto. Tiwya Jõ thai sre to, menohe anu noo boit aro nee kʼJõ tait fee. Tna tiwya Jõ thai sbit to, menohe anu nwyan aya aro nee kʼJõ tata fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tna Jõ tsu srim to, anu noo Jõ nse mam amah wanu fee ye. Ratan ro Jõ tyum marak to, anu noo ratan aro nee kʼJõ tyum fee ye. Tna Jõ kiyam to, anu nma nmat Jõ fee ye. Tna raa mfot Jõ mbu mam bui to, anu nma nmat Jõ fee ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Menohe ana mawe si kʼJõ mawe, ‘Tuhan; tiwya Nyõ nhai sre, nhai sbit, nsu srim, ratan ro Nyõ nyum marak, Nyõ kiyam, tna Nyõ nhau mam bui mam woyõ re amu nmat Nyõ fee tna natmof Nyõ fee ye to?’ ");
INSERT INTO ayz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tna Ait yawe kʼana yawe, ‘Nri kaket: Soh anu nmat raa woJõ to, tna anu nnaut nwe ana raa ati fee; tibyo anu natmof ana bo fee ye to: Jõ tawe kʼanu tawe, “Bo bawya sai ro anu hawe nno kʼraa woJõ weto sait, bo weto anu hawe nno kʼJõ ye oh meto. Feto to anu natmof Jõ fee oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tna raa ro matmof raa anya fee; kbe raa mawah ana beak mam wore wo arin kair. Meen tafoh mait sikowah ana mamo snok mam hame wajin. Tna raa ro mno bo ro Allah ksoh to, meen mkai mamos mae ye.’” ");
INSERT INTO ayz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus ykyas bo weto kuber wAit mkak tna yawe, ");
INSERT INTO ayz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nnaut nwe, ti ewok naut tna raa makyõ korat ro Paskah. Raa makyõ korat reto to, tna kbe raa mfot Jõ msan kʼraa. Tna raa weto kbe mame Jõ tajat mam ara warok. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'.” ");
INSERT INTO ayz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ati reto imam manes msya raa mabi ro agama Yahudi to, ana siret su mam samu maboh (istana) ro Kayafas. Kayafas tait imam Yahudi ro yase. ");
INSERT INTO ayz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ana saim mawe mamo mfot Yesus wai mamo mame mam wore raa mahni. ");
INSERT INTO ayz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Menohe ana mawe kʼanya mawe, “Bo reto anu bno mam ati ro korat Paskah refo ma, be kbe bo reto mno raa makin mafa.” ");
INSERT INTO ayz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ati sau to, Yesus hre yait boit mam amah ro Simon mam remo ro Betania. Bi Simon tait, tiwya yafa kusta. ");
INSERT INTO ayz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesus hre yait bo kri-kri fo, tna fai sau twok mama. Mama mbo minyak wangi kusia sau. Minyak wangi to mabyoh maut toni. Mama mtu abyõ mam Yesus yana. ");
INSERT INTO ayz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kuber wAit mmat feto, tibyo mrok kmo mawe, “Au mno bawya meto ee? Fyi re minyak reto sikowah sai a? ");
INSERT INTO ayz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Rau ro moof to, raa masim tna moo mabyoh rau. Tna mabyoh ro mase reto kbe raa msan kʼraa kinyah ro mse bo fee. ");
INSERT INTO ayz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Menohe Yesus yhar bonaut rana oh tna yawe, ‘Nno wa au to ma. Fai au mno bo ro moof kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Raa kinyah to, ja mhau su msya anu yoyo. Menohe Jõ fo, kbe thau tsya anu yoyo fee. ");
INSERT INTO ayz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Fai au mtu minyakwangi kʼjõ tetsu refo fo, siwyan hai aJõ wia oh meto. Kebet baro naut kbe raa mame Jõ tajat tna sama hai aJõ to. ");
INSERT INTO ayz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nri kaket wia: Bokyas Moof ro mbam Allah refo, meen raa wosa mamo snok mam arin aso beta. Woyõ-woya raa mkyas to, bo moof ro fai au refo mno fo, kbe raa mnaut mkyas ye.’” ");
INSERT INTO ayz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tna Yudas Iskariot yasen yamo yo kʼimam manes ro Yahudi. Yudas tait, kuber ro Yesus wAit mabo 12 weto sait ye. ");
INSERT INTO ayz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yamo yo kʼana yawe, “Kbe anu noo bawya nee kʼjõ afo re jõ tsan Yesus kʼanu to?” Ana moo pitis mauf trion 30 maren Yudas wia. ");
INSERT INTO ayz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tna Yudas ywof ati ro moof re kbe besruf Yesus. ");
INSERT INTO ayz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti ro tinyi mam korat 'Roti ro Ragi Marak' to, kuber wAit mama mtu kʼYesus mawe, “Nyõ nksoh nawe amu siwyan bo sohmaam mam woyõ?” ");
INSERT INTO ayz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus yawe, “Nmoʼt kota no kʼraa sait ro Jõ tawe kʼanu tna nwe, ‘Bi Guru yawe ayõ ro raa mame Ait to kene oh. Ait yawe kbe yakyõ bokyõ ro Paskah su ysya kuber wAit mam samu anyõ.’” ");
INSERT INTO ayz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Feto tibyo kuber wAit masen mamo mno bo ro Yesus yawe reto. Tna ana siwyan bo sohmaam mkah makyõ bokyõ ro Paskah reto. ");
INSERT INTO ayz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mti reto Yesus yamoʼt amah reto tna hre sohmaam bo su ysya kuber wAit mabo 12 weto. ");
INSERT INTO ayz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ana hre sohmaam bo tna Yesus yawe, “Anu nkin wefo sait kbe hren ksuk Jõ.” ");
INSERT INTO ayz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ana mari feto, tibyo mrok sraujin toni. Tna ana wefo sait-sait saak ana mawe, “Guru; jõ fee!” ");
INSERT INTO ayz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus yawe, “Raa ro beru roti mam hawereh sau su ysya Jõ to, ait ro kbe hren ksuk kʼJõ oh metait. ");
INSERT INTO ayz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Kbe raa mame Jõ tajat tu oh. Mame Jõ to, mnan si mkah Watum ro Allah tiwya mawe wia yum oh. Menohe ait ro hren ksuk Jõ tait, meen safo maboh mai kʼait ye tu oh. Ro moof to, tiwya yme mabe ait fee sai.” ");
INSERT INTO ayz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tna Yudas ro kbe hren ksuk Yesus yawe, “Bi guru, jõ oh mi Nyõ nawe meto a?” Yesus yawe, “Eno, au oh nyõ nawe meto.” ");
INSERT INTO ayz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ana sohmaam bo nkri-kri fo, Yesus yoo roti sau. Yoo tna skabuk yayoh asik mase kʼAllah. Tna Ait haber roti reto yee kʼana beta mait. Tna yawe, “Nmat roti refo. Tetsu aJõ oh mefo. Noo niit oh.” ");
INSERT INTO ayz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tna Ait yoo hawereh sau. Yoo tna skabuk yayoh asik mase kʼAllah. Tna yee kʼana beta mata. Tna yawe, “Noo nta anggur maya refo. ");
INSERT INTO ayz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Anggur maya refo to, mees aJõ ro kbe miyi mkah riof kʼanu. Kbe raa mame Jõ tna Allah ysair bosi ro tna kʼanu oh meto. Tibyo Allah yyon iro ro raa mno to. ");
INSERT INTO ayz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jõ tawe kʼanu tawe, Jõ kbe tata anggur maya mam tabam refo u fee. Thau meen snok mam wore wo anu bhau su mam wore Allah yamo Raja ybo raa wAit. Wore weto kbe anu bta anggur maya ro tna su.” ");
INSERT INTO ayz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ana mji howes mkak, tna masen mamoʼt Faut ro Zaitun. ");
INSERT INTO ayz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tna Yesus yawe kuber wAit yawe, “Mti refo fo anu beta kbe nmat kair mai kʼJõ tibyo nsen nsam sikba Jõ nmo. Watum ro Allah mkyas feto mawe: ‘Jõ kbe tame raa ro kmot domba sait, tibyo domba wAit weto masen msam brir-brar mamo ye.’ ");
INSERT INTO ayz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Menohe kbe Taja yti Jõ trok tasen. Tna kbe Jõ tatim ste anu wea mam provinsi ro Galilea.” ");
INSERT INTO ayz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus yawe, “Soh kair mai kʼNyõ to, ana taro saah to, kbe masen msam sikba Nyõ to. Menohe Jõ kbe tasen tsam sikba Nyõ bo fee yum!” ");
INSERT INTO ayz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tna Yesus yawe, “Petrus, nari: Mti refo to, kook mara fefares to, kbe nyõ nwaar Jõ wia muhrin tuuf oh, nawe nyõ wase Jõ.” ");
INSERT INTO ayz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tna Petrus yawe, “Fyi feya sai, Jõ kbe twaar Nyõ fee! Raa mawe mame jõ tsya Nyõ bjat su to mi bewok bjat rof!” Tna kuber wAit taro mawe feto beta ye. ");
INSERT INTO ayz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus ysya kuber wAit masen mamoʼt yuk sau ro masom Getsemani. Tna Yesus yawe kʼana yawe, “Hre ste Jõ wea wefo tna Jõ tamo skabuk wia.” ");
INSERT INTO ayz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tna Ait yawe Petrus ysya ku ro Zebedeus yare mabo ewok kro Ait mamo ye. Mam weto to Yesus yhaf yyi tna ynaut srau mtit mjah toni. ");
INSERT INTO ayz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ait yawe, “Thaf fo nroon msai mfi bo tawe tno thai sai oh. Hre nwan nsya Jõ wefo.” ");
INSERT INTO ayz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesus serar yamo baro naut, tna yabum skabuk yawe, “Taja; tubat bo fanes ro btek mai kʼJõ refo fo, beak fari. Jõ tawe sai. Nno bo ro Jõ ksoh to ma. Nno bo mamyot Nyõ ksoh aNyõ sai.” ");
INSERT INTO ayz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesus skabuk mkak tna hah ye yama yo kʼana mabo tuuf weto. Tna ymat he ana beta mjin tu sai. Tna Ait yawe kʼPetrus yawe, “Anu bito hre nwan nsya Jõ ayõ sau sai fee! ");
INSERT INTO ayz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hre nwan tna skabuk re kbe bo ro tabam refo tko anu nno iro to ma. Anu nwe nno bo ro moof. Menohe anu netsu wanu matak mno to fee.” ");
INSERT INTO ayz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tna Yesus hah ye yamo skabuk naut u yawe, “Taja, soh Nyõ nawe bo ro samyoh refo Jõ tasom meto mi, Jõ tasom oh mamo mamyot si bo ro Nyõ ksoh sai.” ");
INSERT INTO ayz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ait skabuk mkak tna hah ye yama yo kʼana mabo tuuf reto u. Tna ymat he ana mjin maka toni, tibyo mjin tu bana sai. ");
INSERT INTO ayz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ait yawe bitsre ana mjin rof, tna hah ye yamo skabuk u. Bo skabuk ro muhrin tuuf reto mnan anya sai mfi bo riwai Ait skabuk wia to. ");
INSERT INTO ayz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yesus skabuk mkak tna hah ye yama yo kuber wAit. Tna yawe, “Anu njin fares a? Nsen oh! Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Ayõ ro raa yama besruf Jõ to, kene oh. Kbe ait besruf Jõ tna yoo Jõ ysan kʼraa ro ja mno iro mfot. ");
INSERT INTO ayz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nsen nma bmo oh! Ait ro besruf Jõ tait yama oh mefi!” ");
INSERT INTO ayz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wore Yesus yros ykyas bo reto, Yudas frok yama. Yudas tait, ait ybam kuber wAit mabo 12. Ait yama yatim tna raa sbe mawat nkro ye. Ana masom pedang wana msya hbat wana sor. Ana raa sbe weto to, raa mabi ro agama Yahudi mbis. Raa mabi weto to, imam manes wana, msya raa mabi wana ye. ");
INSERT INTO ayz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","(Ait ro besruf Yesus riwai yawe yerif Yesus kʼana yawe, “Kbe Jõ tamo hana raa sait to. Ait oh metait. Nfot Ait.”) ");
INSERT INTO ayz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tna mkah tetara Yudas yamo yo kʼYesus tna yawe, “Bi Guru; meen oh kʼNyõ!” Tna ait hana Yesus. ");
INSERT INTO ayz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus sesaban yawe, “Tafoh aJõ, reto oh mi nyõ nnaut nama fo a?” Feto tibyo raa majin reto sokraria mamo mbo Yesus tna mfot. ");
INSERT INTO ayz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kuber wAit sait ymat feto tibyo yayõ pedang rait. Yayõ pedang rait tna ysot sryan ro imam yase rait sait yimara. Tibyo ktos btek mai mam tabam. ");
INSERT INTO ayz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Menohe Yesus yastako kuber rAit retait yawe, “Nsuf pedang anyõ oh! Awya ro yame raa mkah pedang yajat to, kbe raa mame ait mkah pedang ye. ");
INSERT INTO ayz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nyõ nhar bo fe mfe a? Malaikat ro Taja wAit to msis toni syok. Jõ tatak tayoh kʼTaja ybis ana mama mame anya msya raa weto ye. ");
INSERT INTO ayz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Menohe Jõ hawe bo tayoh Taja ye. Bo ro Ait yawe mam Watum rAit to, kbe mabo tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tna Yesus yawe kʼana ro mama mfot Ait yawe, “Anu nbo pedang msya hbat nma nfot Jõ mfi bo Jõ raa ro syõf bo sai a? Ja rabu ti wawa Jõ hre betoo Watum ro Allah kʼanu mam Samu rAit to. Menohe anu nfot Jõ mam beto fee. ");
INSERT INTO ayz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Menohe bo wefo beta mabo, afo re mamo mnan si bokom ro tiwya Allah ybis nabi wAit mkom matim wia to.” Tna kuber ro Yesus wAit masen msam brir-brar beta sikba Ait akus. ");
INSERT INTO ayz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Raa mfot Yesus tna makah mamoʼt samu ro Kayafas. Kayafas tait imamagama Yahudi ro yase. Tna mam samu mato to, guru agama wana msya raa mabi wana hre siret wea. ");
INSERT INTO ayz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tna Petrus ybo rof-rof ana mtis. Yamo snok mam bohra ro imam yase. Tna ait fuu ye truk hre su ysya raa sbe ro ja kmot samu reto ye. Ait yawe hre ymat rof bo ro raa mno mai kʼYesus mamo snok sboh rau to. ");
INSERT INTO ayz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tna mam samu mato to, imam manes msya raa manes ro ja mtu safo raa ro Yahudi to, hre mkyas bo. Ana makin beta to, mawe mkyas bo mbesus mai kʼYesus afo re kbe ana mfot Ait mame. ");
INSERT INTO ayz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ana makin weto aro yasen yros sioh ykyas bo besus Yesus. Menohe bokyas ro ana mkyas to aro ykyas hayah-hayah sai. Tibyo ana mabo ewok masen mros tna mawe, ");
INSERT INTO ayz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Amu nri Yesus yawe, ‘Jõ fi tatak tihabah Samu ro Allah rAit tna Jõ tatak te sgi u mam ti trion tuuf sai.’” ");
INSERT INTO ayz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tna imam ro yase retait yasen yros. Ait yawe kʼYesus yawe, “Boun ro raa mawe maun Nyõ weto to, Nyõ nasen betoo fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Menohe Yesus shait bait sai. Tibyo imam ro yase yawe, “Feto sik sumpah ntom Allah ro yaam tait yasom, nawe Nyõ fi Mesias Ku ro Allah yare fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus yawe kʼait yawe, “Au oh nawe meto. Nri oh: Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen anu nmat Jõ hre tsya Allah ro yase. Kbe Jõ hre mam ati ro yatem ati; mam hroh ro mase reto. Tna kbe anu nmat Jõ troh tama abyõ mam ayoh mboh tama ye.” ");
INSERT INTO ayz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Imam ro yase yari feto, tibyo kmo ybo ratan rait yesait yhah-hah. Tna yawe, “Yesus yamus Allah meto! Yawe Ait Ku ro Allah yare. Bo mbau! Tna anu besait bri oh. Kbe anu saso raa roto mama maun Ait mkah bawya! Mfo refo anu besait bmit safo reto kʼAit! ");
INSERT INTO ayz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bonaut wanu to fyi?” Tna ana mawe, “Safo makan btek mai kʼAit oh. Raa mame yajat tu oh!” ");
INSERT INTO ayz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tibyo ana masen ntfeh oot kʼYesus, mmuk Ait, tna raa taro masen mai Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tna mtu kʼait mawe, “Mesias fi! Soh Nyõ to, Raa ro yhar bo meto mi, nawe kʼamu nawe, raa woyõ sor oh mi yai Nyõ meto?” ");
INSERT INTO ayz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrus hre mne mam bohra reto. Tna sryan ro ano sau mama tna mtu bo kʼPetrus mawe, “Nyõ ja nsya Yesus ro ybam provinsi ro Galilea fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Menohe Petrus ywaar kʼraa makin weto yawe, “Jõ wase, jõ thar bo ro fai au mtu reto fee.” ");
INSERT INTO ayz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tna Petrus yasen yirenti yamoʼt masa ro bohra reto, tna sryan ro ano roto sau mmat ait tna mawe kʼraa ro mhau ye mam weto mawe, “Bi ait retait taa ysya Yesus ro ybam Nazaret ye.” ");
INSERT INTO ayz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Menohe Petrus ywaar matak naut u. Tna yto bo yawe, “Jõ wase Ait ye.” ");
INSERT INTO ayz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Feto tibyo raa makin taro mama mawe kʼait mawe, “Nwaar ma! Nyõ fi nsya ana nbam Galilea ye! Amu nhar nyõ nmai sai.” ");
INSERT INTO ayz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrus yari feto tibyo ywaar yawe matak tna yto bo yawe, “Ayoh, jõ thar bi Ait retait fee!” Weto si fo kook mara. ");
INSERT INTO ayz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tna Petrus ynaut bo ro riwai Yesus yawe kʼait yawe, “Kbe nyõ nwaar Jõ muhrin tuuf wia tna kook mara.” Tna ait frok yamoʼt mne yawia sut-sut. ");
INSERT INTO ayz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rabu momo to, imam manes sor msya raa mabi ro Yahudi mawe safo btek mai kʼYesus. Tna mawe Yesus, kbe raa mame yum oh. ");
INSERT INTO ayz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ana make Yesus yatem, tna makah mamo msan Ait kʼPilatus ro yamo gubernur tait. ");
INSERT INTO ayz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas hren ksuk Yesus. Tna yari he safo mana raa mmit kʼYesus. Tna kbe raa mame Ait yajat. Yudas yari feto tna ait sraujin msai. Tibyo yoo pitis mauf 30 reto yamo yisya kʼimam manes msya raa mabi ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tna yawe, “Jõ fi tno iro kawi oh. Jõ besruf Yesus ro wase safo aro fee, tsan tibyo Ait raa mame.” Menohe ana mawe, “Bo reto bo ramu fee. Nyõ nesait nasom bo anyõ oh.” ");
INSERT INTO ayz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tibyo Yudas yawah pitis mauf weto yai mamoʼt Samu ro Allah mato tna yamo yi kro ait yajat. ");
INSERT INTO ayz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tna imam manes sor fo masen soo pitis mauf wefo. Tna mawe, “Pitis ro misti re raa mame ajat wefo to, Allah ybau. Feto to, noo pitis wefo betruk mam surah wiak Samu ro Allah to ma.” ");
INSERT INTO ayz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ana saim su tna moo pitis weto mate tabam. (Tabam reto ja raa mabah koh mfen kusia msya bo ro raa saruk bo sohmaam (tukang periuk).) Ana mate tabam reto mkah bo meen sama hai raa ro srim. ");
INSERT INTO ayz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Feto oh mi maban ati reto mamo snok mam mfo refo fo, tabam reto raa mtu masom mawe 'Tabam Mees Ajat'. ");
INSERT INTO ayz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bo ro raa mno weto mamo mnan si bo ro tiwya nabi Yeremia ykyas wia yawe, “Meen raa mana ro Israel ntho Ait mkah pitis mabyoh 30 sai. Tna fo raa manes weto moo pitis weto ");
INSERT INTO ayz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mate tabam. Tabam reto ja raa mabah koh mfen bo ro saruk bo sohmaam. Ana mno bo weto mnan si bosi ro tiwya Tuhan ysi kʼjõ.” ");
INSERT INTO ayz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ana msan Yesus tna yros sayõ gubernur ro ybo provinsi reto. Tna gubernur ytu kʼAit yawe, “Nyõ fi Raja ro Yahudi fe mfe a?” Tna Yesus yawe, “Au oh nyõ nawe meto.” ");
INSERT INTO ayz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tna imam manes msya raa mabi ro Yahudi maun Yesus, menohe Ait yawe bo aro si kʼana fee. ");
INSERT INTO ayz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tibyo Pilatus yawe kʼYesus yawe, “Nyõ nari boun rana ro maun Nyõ to fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Menohe Yesus shait bait sai, tibyo gubernur yrok ktak sai. ");
INSERT INTO ayz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ti reto raa ro Yahudi makyõ korat ro Paskah.Tahun aro rau-rau wore wo ana makyõ korat reto to, ja ana baro mamo mo kʼPilatus mayoh kʼait mawe ait tufrok raa ro ana mawe sait ybam bui. ");
INSERT INTO ayz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","(Ati reto to, raa sait ro yasom Yesus-Barabas yhau mam bui. Raa beta mhar mawe ait raa ro ja yno safo.) ");
INSERT INTO ayz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Raa makin sor mama siret su oh. Feto tna gubernur Pilatus ytu kʼana yawe, “Anu ksoh nwe jõ tufrok Yesus-Barabas soh mfe kbe tufrok Yesus ro raa mtu mawe Kristus a?” ");
INSERT INTO ayz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Pilatus yhar yawe raa manes ro Yahudi sor mhaf kair Yesus. Reto oh mi ana msan Yesus kʼait to. Yhar oh mi yawe feto.) ");
INSERT INTO ayz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus hre kri-kri mam ambar tna ytu srah reto yari. Tna yfain ntim soo mama mawe kʼait mawe, “Raa retait wase yber safo. Nsya srioh nkyas safo rAit ma. Ti sai jõ smi tmat tawe kbe bo ro mkair btek mai kʼanu fo.” ");
INSERT INTO ayz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Menohe imam manes msya raa mabi ro Yahudi bo msu bokyas kʼraa makin weto afo re ana mayoh Pilatus mawe ait tufrok Barabas tna mame Yesus yajat to. ");
INSERT INTO ayz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gubernur Pilatus ytu bo kʼana yawe, “Ana mbewok refo fo, anu ksoh nwe jõ tufrok awya?” Tibyo ana mawe, “Tufrok Barabas!” ");
INSERT INTO ayz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus ye ytu kʼana yawe, “Soh feto to, kbe jõ tno bo bawya mai kʼYesus ro raa mtu mawe Kristus tait?” Menohe ana beta mawe, “Name Ait yajat mam ara warok!” ");
INSERT INTO ayz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Menohe Pilatus ytu kʼana u yawe, “Fyi, Ait yber safo bawya?” Menohe ana bito mkah mmai ro mase mawe, “Name Ait yajat yum!” ");
INSERT INTO ayz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus ymat he bo ro ait yawe weto nsoso sai. Kbe raa mrok mnin-nin mawe mno mafa. Ymat feto tibyo ait yasen yoo aya yyon yatem. Yyon yatem mam wore raa masu makin mmat tna yawe, “Jõ fi tsya anu nsom safo ajat ro anu nber refo fee.” ");
INSERT INTO ayz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tna raa makin weto beta mawe, “Mbau a, safo ajat refo meen amu nsya kukek wamu nsom oh.” ");
INSERT INTO ayz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tna fo ait yitsre Barabas yamo yo kʼana, tna ysan Yesus kʼraa ro sbe wait yawe ana moo too mmok-mak Ait, tna mame Ait yajat mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tibyo raa sbe ro Pilatus wait makah Yesus twok mamoʼt samu ro bi gubernur. Tna ana mtu raa sbe majin rana beta mama mros mur mtan kʼait. ");
INSERT INTO ayz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ana mrus ratan ro Ait yyum, tna moo ratan roto ro mkek sau mse kʼait yyum riryõn. ");
INSERT INTO ayz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ana moo abumun baro mhas mnan watau sau mfi watau ro ja bobot na sbyõ to mse kʼAit sbyõ ye. Tna ana moo tbyor sau mee ybo mam yatem ati ye, tna ana sioh mbaut Yesus: Ana mjit mimna ntmi tabam tna sret Ait masah mawe, “Meen oh kʼNyõ, raja ro Yahudi fi!” ");
INSERT INTO ayz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ana tfeh oot kʼAit, tna mtak tbyor ro Ait ybo to, mai abyõ mam yana. ");
INSERT INTO ayz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ana sret Ait masah tna me mrus ratan ro mkek riwai ana mse kʼAit yyum. Tna me moo ratan rAit mse yyum u. Tna ana makah Ait frok mamo mawe mame Ait yajat mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Raa makah Yesus mamo mam iso ro frok kota ro Yerusalem. Ana mbam kota frok mamo to, tna ana fri raa srim sait yama. Ait ybam kota ro Kirene. Yasom Simon. Ait yawe yiwrek menohe raa sbe mfot ait, mkuk ait mawe yasom ara warok ro Yesus. ");
INSERT INTO ayz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ana mamo snok mam faut sau ro masom 'Yuk ro Hamana'. Mkah mai rana to, raa mawe 'Golgota'. ");
INSERT INTO ayz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tna ana moo anggur maya srioh mkah obat empedu mee kʼYesus yata. Ait sanet baro menohe Ait hawe bo yata ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Raa sbe mse Yesus mam ara warok. Tna ana moo undi tane re kbe mhar awya ro yoo ratan ro Yesus rAit. Tna saim kʼanya. ");
INSERT INTO ayz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tna ana hre mam weto kmot Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mam ara warok Yesus yana abyõ to, raa hero bokom sau. Bokom reto mawe bo ro Yesus yno re raa mame Ait to mefo: “Yesus fi, raja raa ro Yahudi.” ");
INSERT INTO ayz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ati reto raa mame raa ro ja msyõf bo mabo ewok mam ara warok ye. Ait sait raa mse mam ati ro Yesus yatem ati, tna sait mam ati ro yatem ta ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Raa ro mamo frit iti sor mam weto to, mmat Yesus raa mame mam ara warok. Tna ana mana mnah sai mamus Ait ye mawe, ");
INSERT INTO ayz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ti taa, Nyõ nawe nyõ natak nihabah Samu ro Allah tna sgi u mam ti ro tuuf sai no! Soh Nyõ Ku ro Allah meto mi, Nroh nbam ara warok reto oh afo re riof kʼNyõ.” ");
INSERT INTO ayz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tna raa manes ro agama Yahudi mros mmat ye: Imam manes, guru agama msya raa mabi wana ye. Tna ana sret Ait feto ye masah mawe, ");
INSERT INTO ayz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Raa roto saah Ait yno riof kʼana oh. Menohe Ait yesait yatak yno riof kʼAit ai fee! Soh Ait Raja ro Israel tu oh, meto mi sik yroh ybam ara warok reto tna fo kbe amu nmat tna smot Ait ye.” ");
INSERT INTO ayz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tna ana mawe, “Ait ja smot Allah tna yawe Ait tait Ku ro Allah yare. Feto to nma, anu bros ti bmat sai, kbe Allah yatmof skur Ait fee mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Raa ro ja msyõf bo weto to, ro raa mame mam ara warok su msya Ait ye mam weto to, ana mawe kair Ait feto ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Maban baas ayõ ro 12 to, oo reto beta mrok mamur mamo snok hreha ayõ ro tuuf to. ");
INSERT INTO ayz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ayõ ro tuuf bo feto, Yesus ytu mkah ymai ro mase yawe, “Eli,Eli; lamasabakhtani?” Mazmur 22:2 reto to yawe, “Allah aJõ, Allah aJõ; Nyõ sikba Jõ toni sai a?” ");
INSERT INTO ayz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ana makin ro mros weto sor to, baro mawe kʼanya mawe, “Ait ytu Elia oh meto!” ");
INSERT INTO ayz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tna ana sait yamo fooh yoo bo ro aya msuf sau tna beru mam anggur maya ro mano. Ait beru, tna yayõ tmi mam tbyor makit sau tna ytu maut kʼYesus yata. ");
INSERT INTO ayz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Menohe raa makin taro mawe, “Aha, nno feto ma, bhau bmat sai kbe Elia yama yno riof kʼAit fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus kakyah mkah ymai ro mase, tna yitsre yafos rAit tna yhai. ");
INSERT INTO ayz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tna tirai ro raa hero mam Samu ro Allah mato to, Allah yhah ftah ewok maban mam uu mamo snok mte. Tna iin frok sin tibyo fraa smut habah-habah ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tna isra ro tiwya raa sama hai to mrok masoh maa. Tna raa makin sor ro tiwya smot Allah tna mhai wia to, taro me mrok masen ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","(Ti ro tuuf to Yesus yrok yasen wia, tna fo ana frok mbam isra wana ye. Tna mamoʼt kota Yerusalem, kota ro Allah rAit to. Tna raa makin mmat ana.) ");
INSERT INTO ayz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bi yabi ro sbe ysya raa sbe wait ro kmot Yesus to mmat iin msya bo yase ro riwai frok mama to, ana mrok waa mawe, “Ae, bo mabo oh! Ait retait, Ku ro Allah yare tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Fnya taro mawat mros fari mmat bo weto beta ye. Ana weto to fnya ro kro Ait mbam provinsi ro Galilea. Ana weto ja kro Ait yno bo wAit ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Fnya makin weto to ana mabo tuuf oh mi, sau masom Maria Magdalena, tna ro ewok masom Maria ro Yakobus ysya Yusuf mme, tna ro tuuf to ku ro Zebedeus wait mme. ");
INSERT INTO ayz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ayõ ro hreha tna bobot sait ybam remo ro Arimatea yama. Ait yasom Yusuf. Ait ja kro Yesus bait soo ye oh. ");
INSERT INTO ayz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ait yamo yo kʼPilatus tna yayoh yawe Pilatus ybis ait yesait yoo ajat ro Yesus tna sama. ");
INSERT INTO ayz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pilatus ybis. Tibyo Yusuf yoo ajat reto, tna sro mkah hawee mabuf ro mfyan-fyan moof sau. ");
INSERT INTO ayz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yusuf tait, tiwya yabah isra ro tna sau mam fraa mana sau mkah bo meen raa moo hai mse. Feto tna ait tubat ajat ro Yesus yamo yse mam isra reto. Ait yoo ajat reto yse, tna fo bririk fraa maboh sau burut wa isra reto mato tna yamo. ");
INSERT INTO ayz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena msya Maria roto sau to, ana hre kene mam mato ro isra reto ye. ");
INSERT INTO ayz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti ro jumaat raa agama Yahudi siwyan bo mkah ayõ ro ana tmoh to. Tna rabu ti fo, imam manes ro agama Yahudi msya raa ro Farisi mamo mo kʼPilatus mawe, ");
INSERT INTO ayz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Bi yabi, Yesus retait raa ro ja siroyõ. Amu nnaut nwe tiwya wore Ait yhau fares to, yawe Ait yhai tna ti ro tuuf to, kbe Ait ye yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Feto to, nbis raa mamo kmot isra reto matak wa mamo snok mam ti ro tuuf to. Soh mfe to, kuber wAit kbe tbat mamo msyõf ajat rAit masom mamo. Msyõf ajat rAit tna sioh mawe kʼraa makin mawe Ait yhai menohe yrok yasen oh. Soh ana mno bo reto to, kbe arin mrok mkair renti.” ");
INSERT INTO ayz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus yawe, “Ae; noo raa sbe wefo nkah nmo oh! Jõ tbis ana kmot isra reto masa to kaket wa.” ");
INSERT INTO ayz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tna ana masen mamoʼt isra reto. Tna ana mse meterai ro Roma mam isra reto masa wa ye. Tna raa sbe weto hre kmot isra reto masa wa. ");
INSERT INTO ayz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayõ ro raa ntmoh (hari Sabat) mkak. Tna minggu rabu momo Maria Magdalena msya Maria roto sau, mamo mmat isra ro raa moo ajat ro Yesus mse fo. ");
INSERT INTO ayz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Malaikat ro Tuhan sau mbam ayoh mroh mama tna bririk fraa ro raa burut wa isra mato reto. Tibyo iin ro msai frok mama sin. Malaikat reto maut hre mam fraa reto abyõ. ");
INSERT INTO ayz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malaikat reto metsu rau mfi rir tna ratan ro myum to mboh fyok ye. ");
INSERT INTO ayz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tna raa sbe ro kmot isra reto to, waa tibyo tetet mhai. Tna smut mfi raa ro mhai. ");
INSERT INTO ayz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tna malaikat reto mawe kʼfnya weto mawe, “Waa ma. Jõ thar anu nma saso Yesus ro taa raa mame yajat mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ait yhau mam wefo fee. Riwai Allah yno Ait yrok yasen oh, mfi tiwya Yesus yawe wia to. Nma nmat yuk ro taa raa moo Ait mse bris to yarak meu. ");
INSERT INTO ayz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hah ne nmo fooh nwe kuber wAit nwe, ‘Yesus yrok yasen oh. Ait yatim wea oh mam provinsi ro Galilea. Nmoʼt Galilea tna kbe anu nmat Ait mam beto.’” ");
INSERT INTO ayz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ana frok mbam isra reto mkah waa. Tna ana simaut mase ye mamo. Ana mhoh fooh mamo mawe mabah bo reto kuber wAit ye. ");
INSERT INTO ayz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Menohe Yesus yrok brah nenat kʼfnya weto tna yawe, “Meen oh kʼanu.” Tibyo ana mamo kait mo kʼYesus tna maka mabum mbo Ait yaa tna mbaut Ait. ");
INSERT INTO ayz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tna Yesus yawe, “Waa ma! Nmo oh tna nwe kʼraa woJõ makin nwe, ana maryõt oh mam Galilea tna kbe ana mmat Jõ ye oh mam beto.” ");
INSERT INTO ayz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wore wo fnya weto mamo kri-kri fo, raa ro kmot isra ro ajat reto baro hah mamoʼt kota. Mamoʼt kota tna mamo mo kʼimam manes sor. Tna mabah bombra ro riwai ana mmat reto beta. ");
INSERT INTO ayz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Imam manes hre siret msya raa mabi ro Yahudi. Tna ana saim iso ro kbe mberkait bokyas reto. Ana saim bo su. Tna mawe moo pitis baro mee kʼraa ro sbe weto. ");
INSERT INTO ayz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Raa manes mawe kʼana mawe, “Nwe kʼraa nwe tisai anu njin tu tna kuber ro Yesus mama msyõf ajat rAit makah msam mamo. ");
INSERT INTO ayz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tna soh Gubernur yari bo reto, kbe amu nkyas bo nsya ait, afo re ait yno bo aro mai kʼanu fee.” ");
INSERT INTO ayz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Raa sbe moo pitis reto. Tna ana mkyas bo mamyot riwai raa manes weto msi kʼana to. Bokyas reto raa mkyas hahah kʼraa ro Yahudi mamo snok mam mfo refo fo. ");
INSERT INTO ayz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kuber ro Yesus wAit mabo 11 masen mamoʼt provinsi ro Galilea. Ana maut mamoʼt faut ro Yesus ykyas kʼana wia. ");
INSERT INTO ayz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ati ro ana mmat Ait, ana maka mbaut Ait. Menohe ana baro mhaf mko-ako smot Ait kaket fee ye. ");
INSERT INTO ayz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus yama kait yo kʼana tna yawe, “Allah ysan bombra ro ayoh msya ro tabam refo beta kʼJõ tbo. ");
INSERT INTO ayz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Feto to, nsen nmoʼt bangsa mam tabam arin aso refo beta. Nmo to, nno ana haberek mamo raa mana woJõ ye. Tna baptis ana mkah Taja yasom, mkah Ku rAit yasom, tna mkah Har rAit masom ye. ");
INSERT INTO ayz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tna nkyas kʼraa nwe, ‘Nri bo ro Yesus yawe to. Tna nbo nno ye.’ Nnaut nwe Jõ tatam anu yoyo mamo snok mam oon sboh rau.”");
INSERT INTO ayz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Bokyas Moof (Injil) ro mkyas Yesus Kristus, Ku ro Allah yare to, tinyi rau oh mefo: ");
INSERT INTO ayz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tiwya Allah ybis nabi Yesaya yama ykom bo ro Allah ykyas kʼYesus. Bokom reto to, Allah yawe kʼYesus yawe: “Meen Jõ tbis raa sait yama ykyas bo woJõ yatim wia tna Nyõ nrof. Kbe ait siwyan iso kʼNyõ. ");
INSERT INTO ayz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Meen ait yama ykyas bo woJõ mam yuk ro riamo sau. Ykyas yawe, ‘Mbetrot iso mkah Tuhan yama! Nisoh iso kʼAit!’” ");
INSERT INTO ayz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tna Yohanes ro ja baptis raa yama. Ait yhau mam yuk ro riamo sau, tna raa mama mari bokyas rait. Ait ykyas kʼana yawe, “Nashana fooh! Tna jõ baptis anu. Nashana tna Allah yyon iro wanu.” ");
INSERT INTO ayz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tna raa mbam kota ro Yerusalem, msya raa mbam remo makin provinsi ro Yudea reto to, ana weto sor mama mo kʼYohanes. Ana mama mo kʼAit tna mras iro wana. Tna Yohanes baptis ana mam aya ro Yordan. ");
INSERT INTO ayz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes ja yyum ratan ro raa sne mbam unta mawyan. Tna ykyar hotom ro mbam kak marak ye. Ja ait yabo mo msya yata kum maya ro mbam safom sai. ");
INSERT INTO ayz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tna ait yawe, “Jõ fi tatim wia. Tna Ait ro yase yiwer jõ sait kbe yama yrof. Tna jõ toof mkah bo taka skur sandal rAit to fee. ");
INSERT INTO ayz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jõ baptis anu mkah aya sai. Menohe kbe Ait baptis anu mkah Har ro Tuhan.” ");
INSERT INTO ayz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yohanes yhau mam aya ro Yordan fares to, Yesus ybam remo ro Nasaret mam provinsi ro Galilea yama. Yesus yama tna Yohanes baptis Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus frok ybam aya yaut si fo, Ait heyut ymat he ayoh ftah. Tna Har ro Tuhan haberek mnan fi ruu merpati sau. Tna fru mama mroh abyõ kʼAit.. ");
INSERT INTO ayz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tna raa mari mai sau mbam ayoh mawe, “Nyõ fi akut aJõ ro Jõ thafri. Nyõ fi Jõ thaf mnan!” ");
INSERT INTO ayz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tna si fo Har ro Tuhan mbis Yesus yasen yamoʼt yuk ro riamo sau. ");
INSERT INTO ayz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ait yamo yhau mam teto ti trion 40. Kak rbyoh ja mhau mam teto ye. Tna kabes yabi (Iblis) yama yawe sanet besruf Yesus. He mfe, Yesus yatak sai. Tna fo malaikat baro mama matam Ait. ");
INSERT INTO ayz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohanes, raa mfot mamo mbu mam bui oh. Tna Yesus hah yamoʼt provinsi ro Galilea. Yamo ykyas Bokyas Moof ro Allah (Injil). ");
INSERT INTO ayz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ait yawe, “Nma fooh! Allah siwyan yamo Raja ybo raa wAit. Feto to nashana. Bokyas Moof reto bo mabo. Ntu sioh bokyas rAit reto ma!” ");
INSERT INTO ayz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ati sau fo, Yesus yamo mam maru ro Galilea maam. Yamo tna ymat raa mabo ewok mse jala rana mam maru mfot syoh. Ana mbewok ja makam maru. Sait yasom Simon ysya yao Andreas. ");
INSERT INTO ayz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tna Yesus ytu kʼana mbewok yawe, “Nma kro Jõ. Kbe Jõ tbis anu nmo nfot raa.” ");
INSERT INTO ayz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ana mbewok mari feto, tibyo masen fooh sikba jala wana makus. Tna kro Ait mamo. ");
INSERT INTO ayz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ana mamo tna mmat Yakobus ysya yao Yohanes. Ana bewok weto to, ku ro bi Zebedeus wait. Ana mbewok hre mam wiak tna misoh jala wana. ");
INSERT INTO ayz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tna Yesus ytu ana mama kro Ait. Tna ana masen fooh sikba maja Zebedeus yhau akus mam wiak ysya sryan wait. Tna ana mbewok kro Yesus mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus ysya kuber wAit weto mamoʼt remo ro Kapernaum. Ayõ ro Sabat to, ja raa ro agama Yahudi ntmoh. Tna ayõ ro Sabat reto, Yesus twok mam samu watum rana tna ykyas Watum ro Allah. ");
INSERT INTO ayz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Allah yno re bokyas rAit matak toni. Menohe Guruagama wana ro Yahudi to, ja bokyas wana matak kaket fee. Tibyo raa ro mari bokyas rAit reto mrok ktak. ");
INSERT INTO ayz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ati reto raa ro kabes mbo sait hre mam samu watum reto ysya raa taro ye. Tna kabes sor ro mbo raa refi mawe, ");
INSERT INTO ayz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus; raa ro Nasaret; kbe Nyõ nno bawya kʼamu wefo! Nyõ nama name amu njat a? Jõ thar Nyõ; Nyõ fi Ait ro Allah Ybis Yama!” ");
INSERT INTO ayz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tna Yesus bhah kabes reto yawe, “Shait! Nfrok nbam kʼait!” ");
INSERT INTO ayz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kabes reto mbo raa retait simoyot tna wohrarar frok mbam kʼait. ");
INSERT INTO ayz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Raa beta mrok ktak tna mtu kʼanya mawe, “Bo bawya sai mefo? Watum refo matak toni! Ait ybis kabes frok, tna kabes sor mari Ait ye! Bo ro tna sau mefo!” ");
INSERT INTO ayz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tna raa mkyas Yesus yasom syohor fooh mam provinsi ro Galilea beta. ");
INSERT INTO ayz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus; Yohanes ysya Yakub frok mbam samu watum reto. Tna ana kro Simon ysya Andreas mamoʼt amah rana mbewok. ");
INSERT INTO ayz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ana snok mam amah reto tna raa mkyas Simon snyim ro ano kʼYesus. Au mjin amah sai tna metsu mbe toni. ");
INSERT INTO ayz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus yamo yo kʼfai au reto tna ybo matem teta masen. Tibyo kiyam rau marak. Tna fai au masen saruk boit mee kʼana mait. ");
INSERT INTO ayz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mti reto to, raa ro kiyam msya raa ro kabes mbo beta to, raa makah mama mo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Raa ro mbam kota reto beta mamaʼt bohra ro amah reto. ");
INSERT INTO ayz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ait yisoh raa mawat ro mafa bo knik-knak weto re moof. Tna yikyak kabes mawat frok ye. Kabes weto mhar mawe Ait tait Ku ro Allah yare. Menohe Yesus hawe kabes weto mkyas Ait. Tibyo yno wa kabes weto re shait bana sai. ");
INSERT INTO ayz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ana mjin tna rabu momo, ti mwamu fares, Yesus yrok yasen yamoʼt yuk ro riamo tna skabuk. ");
INSERT INTO ayz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Menohe Simon ysya yafoh na taro mama mrof saso Ait. ");
INSERT INTO ayz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ana fri Ait tna mawe, “Raa beta saso Nyõ.” ");
INSERT INTO ayz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tna Ait yawe, “Nma bmoʼt remo roto ro kene taro naut. Re kbe Jõ tkyas Watum ro Allah kʼraa ro mhau mam remo weto ana mari ye. Tkyas watum rAit reto kʼraa oh mi Jõ tama fo.” ");
INSERT INTO ayz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tna Ait yasen yamo yur mam provinsi ro Galilea beta. Yamo ykyas bo mam samu watum makin ro Yahudi. Tna Ait yikyak kabes frok mbam kʼraa ye. ");
INSERT INTO ayz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Raa ro yafa kusta sait yama yo kʼYesus. Yama tna yjit yimna soh-soh kʼAit yawe, “Soh Nyõ ksoh meto mi, nisoh jõ re kusta refo marak.” ");
INSERT INTO ayz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus yatmof raa retait tibyo Yesus yatem ybo ait tna yawe, “Jõ ksoh, nyõ mbros oh!” ");
INSERT INTO ayz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mkah wore weto si fo kiyam rait marak. ");
INSERT INTO ayz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus yawe wa kʼait yawe, ");
INSERT INTO ayz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Namo to, nkyas bo refo kʼraa ma. Namo nerif narak anyõ kʼimam ro Yahudi sait re ait ymat sas nyõ. Nyõ noof u, feto to noo bo nee kʼimam re ysan kʼAllah mamyot Watum ro Musa ykom yawe. Nno feto re kbe raa mhar mawe nyõ netsu to moof u.” ");
INSERT INTO ayz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Menohe raa retait yamo tna ykyas bo reto kʼawya sai ro ait fri mam iso. Tibyo raa msis-sas mbeak-ak anya mama mo kʼYesus mam woyõ-woya sai Ait yamo. Tibyo Ait twok yamoʼt remo mam wore raa mmat fee. Ait yhau wore mnem, menohe raa mbam tyo-teya sai mama mo kʼAit mam wore weto ye. ");
INSERT INTO ayz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ti baro firwas tna Yesus hah ye yamoʼt Kapernaum. Raa mkyas mawe Ait yhau mam samu mato. ");
INSERT INTO ayz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tna raa msis-sas mama mros mur mtan samu reto: Taro mros tabam, taro mros mam isit, tna amah mato matot mkah raa ye. Yesus ykyas bokyas ro Allah kʼana beta. ");
INSERT INTO ayz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mam weto to, raa baro naut mama. Tna ana mabo jiit nkatar ait ro yaa mhai sait mama. Mama mawe makah ait mama mo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","He raa mawat burut wa Yesus. Feto to ana makah ait maut abyõ mam ti manaf. Tna ana mitrah ti manaf reto baro mno hroh mam wore Yesus yros mte. Tna mruk ait mkah sese rait ye. Mruk mam ti samu mato. ");
INSERT INTO ayz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus ymat ana tna yhar yawe ana smot Ait matak. Tibyo Yesus yawe kʼait ro yaa mhai retait yawe, “Ku aJõ, iro wonyõ to, Jõ tyon oh.” ");
INSERT INTO ayz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Guru agama Yahudi baro hre mam weto ye. Ana mari bo ro Yesus yawe feto tna mnaut mawe, ");
INSERT INTO ayz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ait refi ykyas bo bawya meto? Bo ro Ait yawe to berasi Allah! Awya ytai yyon iro? Allah yesait aran sai!” ");
INSERT INTO ayz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Menohe Yesus yhar bo ro ana mnaut mam srau mato wana. Tna Ait yawe kʼana yawe, “Fyi re anu nnaut bo weto mam srau mato wanu to? ");
INSERT INTO ayz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Soh Jõ tawe kʼait refi tawe ‘Iro wonyõ to, Jõ tyon oh.’ Bo ro msai fee: Kbe raa mahni bo reto mabo fe mfe a. Menohe tawe, ‘Nasen, beah aam anyõ, tna namo bonyõ oh!’ Tawe feto afo re kbe raa mmat bo reto mabo. Mmat tna mhar mawe Jõ ttai tno bo ewok ye. Ewok ye mnan-nan kʼJõ sai. ");
INSERT INTO ayz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna bo ro kbe Jõ tno fo, Jõ tno re kbe anu nhar nwe Jõ tatak tyon iro raa mam tabam refo.” Tna Yesus yawe kʼAit ro yaa mhai retait yawe, ");
INSERT INTO ayz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nasen, tubat sese anyõ, tna nasom namo bonyõ oh!” ");
INSERT INTO ayz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tna ait yasen, tubat sese rait fooh, tna frok yamo. Raa beta mmat bo msai ro Yesus yno reto. Tibyo mrok ktak tna mbaut Allah mawe, “Anu ja bmat bo ro mfi fefo aro fefares sai!” ");
INSERT INTO ayz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus ybam Kapernaum hah ye yamoʼt maru maam ro Galilea u. Raa msis-sas mama mo kʼAit tna Ait ykyas bo kʼana. ");
INSERT INTO ayz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ait ykyas bo mkak, tna fo yamo. Ait yamo nkri-kri fo, ymat raa sait ro ja yoo namabyoh (pajak) yee kʼpemerintah ro Roma. Yasom Lewi, ku ro bi Alfeus yare. Bi ait hre mam kantor ro namabyoh rait. Tna Yesus ytu kʼait yawe, “Nama kro Jõ bmo!” Lewi yari feto, tibyo ait yasen kro Yesus mamo. ");
INSERT INTO ayz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ti sau fo, Yesus ysya kuber wAit mait boit mam amah ro bi Lewi. Tna raa ro ja moo namabyoh msya raa ro ja mno iro bo mawat to mama mait boit su msya ana ye. Ana weto mawat masen kro Yesus oh. ");
INSERT INTO ayz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Raa Farisi ro mamo guruagama baro mmat Yesus yait boit su ysya raa weto. Tna ana mtu kuber wAit mawe, “Fyi re Yesus yait boit su ysya raa ro moo namabyoh tna msya raa ro ja mno iro bo weto?” ");
INSERT INTO ayz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus yari bo ro ana mawe feto tibyo yawe kʼana yawe, “Raa ro metsu moof to, ja mamo saso dokter fee. Ja raa ro kiyam oh mi mamo saso dokter to. Jõ tama ttu raa ro mhaf moof to fee. Menohe Jõ tama ttu raa ro mno iro.” ");
INSERT INTO ayz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ati sau fo, kuber ro Yohanes Pembaptis wait msya raa ro Farisi mhau bo ro mait re skabuk kʼAllah kaket. Tna raa mama mo kʼYesus tna mtu kʼAit mawe, “Fyi re kuber ro Yohanes msya kuber ro Farisi mhau bo ro mait. Menohe kuber wonyõ mhau bo ro mait to fee?” ");
INSERT INTO ayz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus ykyas bofret kʼana yawe, “Ati ro raa sait ymen fnya to, ja raa mno bo bawya? Anu nwe kʼait yafoh wait ro mama to, nwe ana mhau bo ro mait sai a? Mfe! Ana makyõ bokyõ fea! Ana makyõ bokyõ wia. ");
INSERT INTO ayz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tna fo raa moo ait makah mamo. Ati reto to, kbe mafoh wana sraujin tibyo mhau bo ro mait. Kuber woJõ mfi feto ye. Jõ thau tsya ana fares fo, ana sraujin fee. Menohe ati ro Jõ sikba ana tamo to, kbe ana sraujin tibyo mhau bo ro mait ye.” ");
INSERT INTO ayz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tna Yesus ykyas bofret ewok naut kʼana yawe, “Mfi bo ratan matah ro hri-hra sau. Ja fnya moo hawee ftah mabuf ro tna to, maru ratan ro matah to fee. Soh au mtin feto to, kbe tis mkair. Kbe hawee ftah mabuf reto mno tibyo ratan reto mrok mhah renti. ⌞Feto ye iso bose raa mabi ro Yahudi ja mamo to, hayah. Tna iso tna ro Jõ terif refo fo hayah ye. Tna iso ewok reto srioh anya ye fee.⌟ ");
INSERT INTO ayz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Feto ye, Ja raa mror anggur maya ro tna mam baah marak ro matah fee. Anggur maya reto mno baah marak reto matu mbua. Tna kbe anggur maya reto maus miyi mroh mamo mkak. Anggur maya ro tna to, ja raa moo mror mam baah marak ro tna sai.” ");
INSERT INTO ayz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ayõ ro raa ntmoh (hari Sabat) sau to, Yesus ysya kuber wAit mamo frit iti mam armato ro gandum sau. Kuber wAit mhai sre, tibyo mryoh gandum make baro mait. ");
INSERT INTO ayz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Menohe raa ro Farisi mmat feto, tibyo mawe kʼYesus mawe, “Yesus fi, nmat kuber woNyõ mno bo toto sai meto a? Ana mryoh gandum make mam ayõ ro raa wanu ntmoh to. Ana mno fyi meto? Mno bo reto to, ana miwer Watum ro agama ranu oh meto!” ");
INSERT INTO ayz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tna Yesus yawe, “Anu nnaut Bokom ro Allah fe mfe a? Bokom reto mkyas bo ro tiwya raja Daud yno. Tiwya ait ysya raa wait mhai awyah tna mnaut bo ro mait. ");
INSERT INTO ayz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mam wore weto to bi Abyatar yamo imam agama Yahudi ro yase to. Ati sau to, Daud ysya raa wait hai sre. Tna ait twok mam Samu ro Allah mato. Tna yoo roti ro raa msan kʼAllah. Roti reto mbau. Menohe ait yoo yait. Roti reto to, ja imam na mesait aran mait. Tna ait yoo tna yee kʼraa wait mait ye. ");
INSERT INTO ayz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Menohe Allah yawe Daud yno bo mkair fee. Allah yatmof raa. Au oh mi yno ayõ ro raa ntmoh to. Yawe raa mhau baas kebet baro afo re mno ana metsu me mrok matak ye. Ait yawe ayõ ro raa ntmoh to, bo ro samyoh fee. ");
INSERT INTO ayz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Feto to, Jõ tawe kʼanu tawe, Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ tatak tbo ayõ ro raa ntmoh ye.” ");
INSERT INTO ayz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ayõ ro raa ntmoh roto sau to, Yesus yamo ykyas bo mam samu watum ro Yahudi. Tna raa ro yatem jaro mhai sait huwya mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tna raa ro Farisi baro huwya mam beto ye. Ana mros mmat rof bo ro Yesus yno. Tna ana saim bo mawe soh Yesus yisoh raa mam ayõ ro raa ntmoh to, kbe ana maun baun kʼAit mawe Ait yiwer Watum ro Musa oh meto. ");
INSERT INTO ayz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tna Yesus yawe kʼait ro yatem mhai retait yawe, “Nasen, nama nros susai mam wefo.” ");
INSERT INTO ayz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tna Yesus yawe kʼraa ro Farisi weto yawe, “Ja Watum ro agama ranu mawe anu bno bo bawya mam ayõ ro raa ntmoh? Ja bno bo ro moof, soh mfe bno bo ro mkair a? Bisoh raa, fe bme raa majat a?” Tna raa ro Farisi mhre shait sai. ");
INSERT INTO ayz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus ymat raa weto, yhar yawe ana mana mase. Tna yhar ana hawe smot Ait fee ye, tibyo Ait sraujin tna kmo ana ye. Tna Yesus yawe kʼait ro yatem mhai refi yawe, “Betrot natem anyõ oh!” Raa retait betrot yatem rait. Tna yatem mrok moof. ");
INSERT INTO ayz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Raa ro Farisi mmat bo ro Yesus yno tna frok sikba samu ro watum reto. Tna ana mamo siret su msya raa ro raja Herodes. Ana hre su saim bo mawe saso iso re kbe mame Yesus yajat. ");
INSERT INTO ayz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus ysya kuber wAit mayõ anya mamoʼt maru ro Galilea. Tna raa msis mbam provinsi ro Galilea, masen kro Yesus. Ana taro mawat mbam provinsi ro Yudea, ");
INSERT INTO ayz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mbam kota ro Yerusalem, mbam rabin ro Idumea, tna mbam aya maam ro Yordan jaro ati ro ayõ maut, tna mbam kota ro Tirus msya kota ro Sidon ye. Ana mari bo Yesus yno bo ro msai, tibyo ana mama mmat Ait. ");
INSERT INTO ayz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Raa ro mama weto to mawat tna Yesus ynaut yawe kbe ana beak-ak anya mama weto mber Ait. Tibyo Ait ybis kuber wAit mayõ wiak sau moo mse wea kait mkah Ait yaut. ");
INSERT INTO ayz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ait yisoh raa mawat ro mafa bo oh. Tibyo raa ro kiyam mawat mama mberkait-kat anya mama kait wore Ait yros tna mawe miir kʼAit. ");
INSERT INTO ayz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tna raa ro kabes mbo baro hre mam wore weto ye. Ati ro ana mmat Yesus to, kabes ro mbo ana mrok mhar Ait. Tibyo waa maka tna mbibi Ait ye, tna wahrarar mawe, “Nyõ Ku ro Allah yare oh!” ");
INSERT INTO ayz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Menohe Yesus yawe wa kabes yawe, “Anu nwe kʼraa roto nwe Jõ fi Ku ro Allah yare wia ma!” ");
INSERT INTO ayz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus yaut yamoʼt atu sau. Tna ytu raa ro Ait yhaf mnan mama kro Ait. ");
INSERT INTO ayz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ait ysok ana mabo 12 weto yawe, “Jõ tsok anu nmo raabis (rasul) woJõ. Re kbe anu ntam Jõ. Tna re Jõ tbis anu nmo nkyas Bokyas ro Moof (Injil). ");
INSERT INTO ayz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jõ too tatak tee kʼanu afo re anu ntak nikyak kabes frok.” ");
INSERT INTO ayz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Raabis mabo 12 weto oh mefo: Simon ro kbe Yesus yafan yasom Petrus, ");
INSERT INTO ayz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobus ysya yao Yohanes ku ro bi Zebedeus yare. Yesus yafan ana mbewok ytu masom Boanerges, feto to 'ku ro ayoh mji'. ");
INSERT INTO ayz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filipus, Bartolomeus, Matius, Tomas, Yakobus ku ro bi Alfeus yare, Tadeus, Simon raa ro Zelot, ");
INSERT INTO ayz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","msya Yudas Iskariot ro meen yoo Yesus ysan kʼraa ro Roma kbe mame Ait yajat. ");
INSERT INTO ayz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tna Yesus hah ye yamoʼt samu sau. Menohe raa mawat mamoʼt samu reto ye. Mno Yesus ysya kuber wAit msui tibyo mait boit fee. ");
INSERT INTO ayz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesus yme msya yao na mari bo reto tna mawe kʼanya mawe, “Ait yker oh!” Tibyo ana mamo mawe makah Ait hah mamoʼt remo rana. ");
INSERT INTO ayz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tna guru agama Yahudi baro mama mbam Yerusalem mros mam weto ye. Ana mmat bo ro Ait yno tna mawe, “Kabes Beelzebul ybo Yesus. Yesus yatak re yikyak kabes sor mkah tak ro kabes Beelzebul rait. Kabes Beelzebul retait ja ybo kabes sor.” ");
INSERT INTO ayz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tna Yesus ytu raa mawat weto mama yawe, “Bonaut rana reto to mkair! Ja kabes yabi yikyak kabes anya fee.” Tna Ait ykyas bofret baro kʼana re kbe ana mhar mawe kabes aro ja mikyak kabes roto fee. Ait yawe, ");
INSERT INTO ayz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Raja ro rabin sau ybo raa wait. Menohe soh raa wait mafa anya ai to, kbe rabin reto mros matak fee. ");
INSERT INTO ayz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tna raa ro mhau mam amah sau su to, soh ana mafa anya ai to, kbe ana matak fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Feto ye soh kabes yabi (Iblis) ysya kabes roto sor mafa anya to, kbe kabes yabi yros yatak fee ye. Yhau akus sai. ");
INSERT INTO ayz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jõ fret bo reto u tawe, Kabes yabi yfi raa ro yatak sait. Fyi re raa sait twok mam amah raa ro yatak sait tna ytak bo wait to? Soh raa make ait yaa msya yatem wia saah. Tna fo ait twok ytak bo ro mhau mam amah mato reto.” ");
INSERT INTO ayz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Jõ tawe kʼanu tawe: Raa mno iro bawya sai to, Allah yyon iro wana weto saah. Raa mamus Allah to, Allah yyon iro wana reto saah to ye. ");
INSERT INTO ayz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Menohe soh raa mamus Har ro Allah to, kbe Allah yyon iro wana bo fee yum. Meen raa weto mhau mkair sai mamo snok mam hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Riwai raa mawe Yesus tait kabes mbo to. Reto oh mi Ait yawe bo kʼana feto to.) ");
INSERT INTO ayz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesus yme msya yao na mama. Ana ste mne tna mbis raa ntwok mamo mmen Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Raa msis-sas hre mur mtan Yesus mam amah reto. Ana mawe kʼAit mawe, “Yesus; nme msya nao na ste Nyõ mne meu. Ana saso Nyõ!” ");
INSERT INTO ayz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Menohe Yesus yawe, “Jõ tme to awya? Jõ tao na to awya?” ");
INSERT INTO ayz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tna Ait ymat raa ro hre mur mtan wefo yawe, “Raa wefo oh mi Jõ tme msya tao na mefo. ");
INSERT INTO ayz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Awya ro ja yno bo ro Allah ksoh to, Jõ ttu tawe tao, tano, msya tme woJõ oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus ykyas bo mam maru ro Galilea u. Raa msis-sas mama mros mur mtan kʼait. Ymat feto, tibyo yaut hre mam wiak mato. Tna raa msis-sas weto mros mam maru maam mari bo ro Yesus ykyas. ");
INSERT INTO ayz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tna Ait ykyas bo mawat kʼana mkah bofret yawe, ");
INSERT INTO ayz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nri! Raa sait yno armato rait sau. Tna ait yamo furere bobat manaf (benih). ");
INSERT INTO ayz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ait furere bo to, bo manaf taro mbtek mam iso. Tibyo bo manaf weto to, ruu mama mame mkak. ");
INSERT INTO ayz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tna taro to, mbtek abyõ mam tabam ro fraa mhau wa mte. Tna mtis mame tabam kaket fee. Tibyo bobat weto moo fooh sai. ");
INSERT INTO ayz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Menohe ayõ mo maut mafit to, mrok hroyoh. Mtis moo mame tabam kaket fee, tibyo mrok samer. ");
INSERT INTO ayz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tna taro naut btek ye mam wore wo hyoh muuf. Tna hyoh muuf weto mo betru kait. Tibyo make fee. ");
INSERT INTO ayz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tna taro mbtek mam tabam ro mamos. Tna mo maut. Tibyo make sarer toni: Bo manaf sau-sau rau to, make trion 30 bo feto. Taro to, make rau trion 60 bo feto. Tna taro to, make rau trion 100 bo feto.” ");
INSERT INTO ayz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tna Yesus yawe, “Anu ro nri bokyas reto oh to, nnaut kaket!” ");
INSERT INTO ayz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesus yasen yamo. Tna raa ro ja kro Ait msya kuber wAit mabo 12 to, ana mama mo kʼAit. Tna mawe, “Bawya oh mi nyõ nkyas bofret reto to? Sik betoo maja rau.” ");
INSERT INTO ayz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tna Ait yawe kʼana yawe, “Anu to ja Jõ tkyas bo abyõ kʼanu. Raa mana ro Allah yamo Raja ybo to, maja rau baro to, raa wase fares. Maja rau weto, Allah ksoh re anu nhar kaket. Menohe raa ro mne ja hawe mari Jõ. Jõ tkyas bofret kʼana tna ana mfot bo ro tawe fee. ");
INSERT INTO ayz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jõ tkyas bo kʼraa makin mkah bofret sai afo re bo ro tiwya Allah yawe mai kʼana kbe mabo. Nabi Yesaya tiwya ykyas raa wefo ykom yawe: ‘Raa kbe mmat bo yoyo menohe ana wase bo ro ana mmat reto. Ana mari bo yoyo menohe ana mfot bo ro ana mari reto fee. Tibyo ana mashana fee, tna re Allah yyon iro wana fee ye.’” ");
INSERT INTO ayz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesus yawe kʼana yawe, “Anu nfot bofret reto fefares a? Fyi re kbe anu nsrau bofret roto to? Nri oh; Jõ betoo bofret maja rau kʼanu: ");
INSERT INTO ayz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bofret bi ro furere bo manaf (benih) to, mkyas Bokyas ro Allah. ");
INSERT INTO ayz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bo manaf ro mbtek mam iso to, mkyas mawe raa ro mama mari Bokyas ro Allah. Mari menohe kabes yabi (Iblis) yama tna safto bokyas mbam kʼana mhaf wana. ");
INSERT INTO ayz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tna tkyas bo manaf ro mbtek abyõ mam tabam ro fraa mhau wa mte: Bo manaf weto to, mkyas mawe raa ro mari Watum ro Allah si fo, simaut mase. ");
INSERT INTO ayz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Menohe Bokyas reto ana moo mse mhau mam mhaf mato wana waor sai. Ana mbo matak fee. Raa roto mmat bosmot wana tibyo sikowah ana. Feto tibyo ana mbtek mawe, tna smot Tuhan u fee. Ana weto taro to, bo ro samyoh mama mai kʼana to, tibyo ana mbtek mawe, tna smot Tuhan u fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bo manaf ro mbtek mam hyoh muuf to, mkyas raa ro mari Bokyas ro Allah ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Menohe ana mhau to, mnaut yyi. Tna ana mnaut bosatoh ro moof mam tabam refo sai. Tna ana nksoh mhau moof bana mam tabam refo sai. Bo weto moo ana mhaf re ana mnaut Bokyas ro Allah fee. Tibyo bosmot wana mrok matak fee. Ana tufrok make aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tna tkyas bo manaf ro mbtek mam tabam ro mamos: Ana weto to, raa ro mari Bokyas ro Allah reto tna mse kʼana mhaf. Tna tis rau to, kbe make mawat. Tna taro to, make rau trion 30. Tna taro to, make rau trion 60. Tna taro to, make rau trion 100.” ");
INSERT INTO ayz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tna Yesus yawe kʼana yawe, “Ja raa mbet tafoh (pelita) afo re ntara raa mam amah mato. Raa moo mse mte tna moo ember burut wa fee. Tna raa mmyõt wai mam ambar ro mjin mte to fee ye. Menohe tafoh reto to, ja raa hero abyõ afo re kbe kek ntara raa mam amah mato reto. ");
INSERT INTO ayz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bo bawya ro raa mmyõt to, meen raa masbrah. Tna soh raa mber bo ro mkair aro to, meen raa masbrer ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Awya ro yari bo ro Jõ tkyas refo, rau ro moof to, kbe srau ynaut ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nri oh! Soh anu nri bo wefo kaket to, kbe Allah yno anu srau nnaut bo kaket ye. Tna soh anu nri Jõ kaket fee, kbe Allah yno anu srau nnaut bo wefo kaket fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Awya ro yari tna ybo yno to, kbe Allah yno re ait retait yasu maah. Menohe awya ro yari tna hawe yse mam yhaf mato kaket to, kbe Allah yno re bohar rait to mabuf sai.” ");
INSERT INTO ayz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus yawe u yawe, “Allah yamo Raja ybo raa mana rAit to, yfi raa ro furere bo manaf (benih) mam armato rait. ");
INSERT INTO ayz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ait furere, tna mti to ait yjin, tna reen to ait yrok yasen. Ait kmot bo manaf weto yoyo fee. Kbe bo weto mesait mo ai sai tibyo mrok mase ye. Menohe raa retait wase maja ro bo manaf mo mesait tna mrok mase weto ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tabam mesait oh mi mno re bo make to. Tinyi rau to kmoh mo maut tna mse mata msya kre tna mse make. ");
INSERT INTO ayz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ati ro bo make weto manes to raa retait yryoh sai. Feto mnan fi Allah yama ybo raa wAit ati ro Ait ksoh sai.” ");
INSERT INTO ayz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tna Yesus yawe u yawe, “Raa mana ro Allah yamo Raja ybo to, kbe mnan fi bo bawya? Tkyas bofret bawya naut re kbe anu nhar bo maja rau? ");
INSERT INTO ayz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Raa mana ro Allah rAit to, mfi bo manaf (benih) ro maku sau. Tna bo manaf roto taro to, makan rau to mase baro ye. Tna raa sait yoo bo manaf ro maku reto tna furere mam armato rait. ");
INSERT INTO ayz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Menohe ati ro bo manaf reto mo to, mrok mase miwrek bosafom roto taro ye. Tibyo ruu ro mfru mam ayoh to, mama mbo mam ara reto kre ye.” ");
INSERT INTO ayz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus ykyas Watum ro Allah kʼana mkah bofret mawat. Ait yhar ana mtai mfot watum rAit beta fee. Feto to Ait ykyas bo kʼana mamo snok mam wore ana mari tna srau mnaut sai, tna fo Ait bitsre mam weto. ");
INSERT INTO ayz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ait ja ykyas kʼana mkah bofret sai. Tna Ait betoo bofret maja weto kuber wAit mesait kar mam yuk roto hayah. ");
INSERT INTO ayz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mam ayõ ro hreha reto to, Yesus yawe kuber wAit yawe, “Nma anu buut wiak frit bmoʼt maru refo ati tino.” ");
INSERT INTO ayz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tibyo ana msya Yesus maut wiak sau sikba raa makin weto mamo. Tna raa roto taro maut wiak roto baro to, kro mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ana mamo, mamo tna foos ro msai frok tubor mama mai wiak rana. Tna figyõm mase mai maut mam wiak mato ye, tna mabo kait ana beta. ");
INSERT INTO ayz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus Ait yjin tu mam wiak tis. Tna kuber wAit mti Ait mawe, “Guru; fyi kbe Nyõ sayõ anu bsu a?” ");
INSERT INTO ayz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus yrok yasen tna yifah foos msya figyõm weto yawe, “Nnem oh!” Tibyo foos reto mrok mnem. Tna maru reto mrok snef u. ");
INSERT INTO ayz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesus ytu kuber wAit yawe, “Fyi re anu waa to? Anu smot Jõ fe mfefares a?” ");
INSERT INTO ayz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ana mrok waa toni tna mtu kʼanya mawe, “Bi Ait refi yatak yifah foos msya figyõm wefo mari. Bi Ait refi fi awya mefi ee?” ");
INSERT INTO ayz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus ysya kuber wAit frit maru reto snok mam rabin ro Gerasa. ");
INSERT INTO ayz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ana frok tna Yesus yaut mne. Tna raa ro kabes mbo sait yama yo kʼYesus. Raa retait yama ybam isra mato ro ja raa mse hai to, yama. ");
INSERT INTO ayz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Ja ait yhau mam isra mato weto. Tiwya raa make ait yatem msya yaa mkah too. Menohe ait skur beak sai. Tna fo raa moo besi msya rantai make ait kaket. Menohe ait skur beak ye. Ait safo tibyo raa sait bo ytai ybo ait fee. Tna raa sait yros ter-ter yake ait u ye fee. ");
INSERT INTO ayz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rabu-reha to ait ysom yur bait mam wore ja raa sama hai. Tna ait ysom bait mam faut rno ye. Ait yisyah tna yoo fraa ywais ait yetsu ye. ");
INSERT INTO ayz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ait yhau fari ymat Yesus yama. Tibyo ait yhoh yama yo kʼYesus kait tna yaka tmi yimna tna heyut Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Tna Yesus yawe, “Kabes; nfrok nbam kʼait!” Kabes weto soh-soh kʼAit mkah mai ro mase mawe, “Yesus, Ku ro Allah yare fi; Nyõ Naja yase toni! Kbe Nyõ nno bawya kʼamu mefo? Amu nyoh kʼNyõ nwe, ‘Nyõ nawe mkah Allah yasom nawe kbe Nyõ sikowah amu ma!’” ");
INSERT INTO ayz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tna Yesus ytu kʼait yawe, “Nyõ nasom awya?” Tna raa retait yawe, “Amu ro nbo ait refi fi kabes nwat. Tibyo jõ tasom ‘Legion.’” ");
INSERT INTO ayz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tna ait soh-soh kʼYesus hri mun aro rau mawe, “Nbis amu frok nbam rabin refo ma!” ");
INSERT INTO ayz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kene msya yuk reto ye fane mawat mau bana mam faut sau. ");
INSERT INTO ayz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tna kabes weto soh-soh kʼYesus mawe, “Nbis amu frok nmo twok mam fane wore wono!” ");
INSERT INTO ayz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tna Yesus ybis yawe, “Nmo oh!” Tna kabes weto mari tna frok mamo twok mam fane weto. Tna fane weto mrok mker tna mhoh-hah tbat mam rakak reto tna mbtek mam maru. Tna fane weto msu tibyo mhai beta mkak. Fane weto mana 2000 bo feto saah. ");
INSERT INTO ayz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Raa ro kmot fane weto mmat bo ro Yesus yno. Feto tibyo ana masen fooh mhoh mamo mkyas kʼraa mam kota reto tna mkyas kʼraa ro mhau kene ye. Raa mawat mari bo ro ana mkyas weto tibyo ana mama mmat bo reto. ");
INSERT INTO ayz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mama mo kʼYesus, tna mmat he ait ro tiwya kabes mawat mbo retait hre mte. Ait yyum ratan. Tna srau yakit rait moof oh. Ana mmat feto tibyo mrok waa. ");
INSERT INTO ayz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Raa ro riwai mmat bo ro Yesus yno weto mkyas ait ro kabes mbo retait tna mkyas fane weto ye. ");
INSERT INTO ayz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tibyo raa weto makin misobu Ait mawe Ait yasen yamo fooh sikba oo rana. ");
INSERT INTO ayz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus yawe yaut mam wiak to, raa ro riwai yker retait soh-soh kʼAit yawe, “Jõ kro Nyõ bmo ye!” ");
INSERT INTO ayz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Menohe Yesus yawe kʼait yawe, “Nyõ kro ma. Namo no kʼraa wonyõ. Tna nkyas bo msai ro Tuhan yno kʼnyõ. Tna nkyas boatmof rAit, nawe Ait yatmof nyõ.” ");
INSERT INTO ayz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tibyo raa retait yasen yamoʼt oo ro Dekapolis. Tna ykyas bo msai ro riwai Yesus yno kʼait. Tibyo raa beta mrok ktak. ");
INSERT INTO ayz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus yaut mam wiak hah ye yamo snok maru maam jaro. Tna raa msis-sas mama mros mur mtan kʼAit mam wore aya maam weto ye. ");
INSERT INTO ayz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tna bi yabi ro ybo samu watum raa ro Yahudi sait yama. Ait retait yasom Yairus. Ait yama yaka heyut Yesus tna soh-soh kʼAit yawe, ");
INSERT INTO ayz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Yesus; ku ajõ ro ano sau kiyam, kerit wo mhai! Nama noo natem niir ku au afo re kiyam marak tna kbe au mhai fee.” ");
INSERT INTO ayz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tibyo Yesus ysya bi Yairus mamo. Tna raa msis-sas beak-ak anya kro Ait mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Raa msis-sas weto to, fai au sau mama ye. Fai au fo mafa mees ro fnya yoyo tahun trion 12 oh. ");
INSERT INTO ayz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tiwya raa mawat mama tkif fai au oh. Menohe raa ro mtai misoh au aro fee. Feto mamo snok tis rau to, pitis wau marak. Tna kiyam rau msai renti. ");
INSERT INTO ayz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Fai au mari he Yesus ja yno bo ro msai. Tibyo au mnaut mawe, “Soh jõ tiir ratan rAit sai to, kbe kiyam ajõ marak.” Tna mam wore raa mawat weto to, fai au mbito twok mamo mo kʼYesus mam ati ro ait kbor tna miir ratan rAit. ");
INSERT INTO ayz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Au miir ratan rAit si fo, tna mees rau reto mrok mnem. Au mari he kiyam rau marak oh. ");
INSERT INTO ayz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Au miir ratan rait si fo, Yesus yari he Ait yatak rAit baro frok mbam kʼAit. Tibyo Ait haberek ymat raa wefo tna ytu kʼana yawe, “Awya yatem miir ratan aJõ fo?” ");
INSERT INTO ayz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kuber wait mawe kʼAit mawe, “Yesus; nmat: Raa mawat beak-ak anya sai fo. Fyi re Nyõ ntu nawe awya yiir Nyõ a?” ");
INSERT INTO ayz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Menohe Yesus haberek saso raa ro miir Ait sai fares. ");
INSERT INTO ayz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fai au refo mhar bo metsu rau mbros. Au mrok waa tna tetet mhai ye. Tna au maka hartu Yesus, tna mbetoo bo ro au mno beta. ");
INSERT INTO ayz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tna Yesus yawe, “Ku aJõ; nyõ smot Jõ tibyo kiyam anyõ reto marak. Riof kʼnyõ oh. Nasen namo oh. Kbe nyõ nafa kiyam reto u fee.” ");
INSERT INTO ayz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus ykyas bo fares tna raa baro mama mbam samu bi Yairus mama. Tna mawe kʼYairus mawe, “Ku anyõ reto mhai oh. Nno bi Guru ysui aro u ma.” ");
INSERT INTO ayz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus yari bo ro raa weto mawe. Tibyo Ait yawe kʼYairus yawe, “Waa ma, smot Jõ sai. Smot Jõ nawe Jõ tatak tisoh au.” ");
INSERT INTO ayz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Petrus, Yakobus, ysya Yohanes ro Yakobus yao kro Yesus mamoʼt amah ro Yairus. Tna Yesus yawe kʼraa roto yawe ana kro Ait ye ma. ");
INSERT INTO ayz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ana mamo snok amah ro Yairus. Tna Yesus ymat he raa sraujin beta. Ana mawia mnin-nin. ");
INSERT INTO ayz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus twok tna yawe kʼana yawe, “Fyi re anu nwia mnin-nin fo? Ku au reto mhai fee. Au mjin sai meto!” ");
INSERT INTO ayz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ana masah Yesus. Ait yawe ana frok. Tna Ait yakah ku ro mhai refo maja, mme, msya kuber wait mabo tuuf aran tna twok mam amah hawar ro hai raa mse. ");
INSERT INTO ayz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesus ybo ku refo matem yawe, “Talitakum!” (Mkah mai rana reto mawe, ‘Ku ro ano, Jõ tawe kʼnyõ, nrok nasen!’) ");
INSERT INTO ayz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yawe mai weto si fo, ku au masen mros tna mamo ye. (Ku au reto umur 12 tahun.) Raa ro mmat bo msai reto to mrok miskawowo. ");
INSERT INTO ayz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Menohe Yesus yawe wa kʼana yawe, “Nmo nkyas bo msai ro tno reto renti kʼraa wia ma!” Tna yawe, “Noo boit nee ku au mait oh.” ");
INSERT INTO ayz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus sikba amah ro Yairus tna Ait ysya kuber wAit hah me mamoʼt remo rAit. ");
INSERT INTO ayz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Ayõ ro raa ntmoh (hari Sabat) to, Ait yamoʼt samu watum raa ro Yahudi. Tna Ait yasen ykyas bo kʼana. Raa ro mari bo ro Ait ykyas to, mrok ktak. Ana mawe, “Bi refi fi, raa ro ja yfen ara sai. Ait yoo watum refo mbam woyõ? Tna Ait yno bo ro msai fyi? Bi Ait refi fai Maria makut. Tna Yakobus, Yoses, Yudas, ysya Simon mao rana fe mfe a? Tna ja yano na mhau msya anu mam remo ranu ye!” Ana mhar Yesus yme, yano na tibyo ana smot Ait fee. Ana mnaut mawe Ait Mesias fee. Mawe ait besruf ana sai feto. Tibyo ana kmo Ait. ");
INSERT INTO ayz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tna Yesus yawe kʼana yawe, “Nabi ro Allah ybis yama to, ja raa mari ait mam woyõ-woya yamo sai. Menohe mam remo rait yesait to, ja raa hawe mari ait. Tna yaja, yme, yao, msya yano na ja hawe ye. Tna raa ro amah rait to, hawe ye.” ");
INSERT INTO ayz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Raa ro remo reto smot Ait to fee. Tibyo Ait yrok ktak. Tna Ait yno bo ro msai aro kaket mam remo rAit fee. Ait yatem ytor yisoh raa ro kiyam mabo baro sai. Tna Yesus yamo ykyas bo yamo yur mam remo roto taro naut. ");
INSERT INTO ayz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ati sau to, Yesus ytu kuber wAit mabo 12 weto mama mo kʼAit. Tna Ait yoo yatak rAit yee kʼana re kbe ana mikyak kabes ro mbo raa to sor. Tna Ait ybis ana mabo ewok-ewok masen mamo hayah-hayah. ");
INSERT INTO ayz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ait yawe kʼana yawe, “Nmo ntem marak sai, nbo yu mkah boit, msya pitis ye ma. Nbo armuk mesait aran sai. ");
INSERT INTO ayz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nse sandal mam naa sai, tna nbo ratan roto taro ro kbe nyum to ma. ");
INSERT INTO ayz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ati ro anu twok mam remo to, soh raa sait yoo anu yse mam amah rait to, nhau oh nsya ait mam beto mamo snok mam wore anu nsen sikba remo reto. ");
INSERT INTO ayz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ati ro anu twok mam remo taro to, soh raa mitrah amah wana kʼanu fee, tna hawe mari bokyas ro anu nkyas to, sikba remo reto nmo. Sikba remo reto nmo to, bes-baas bohasyaf ro mhau mam naa to akus sai. Nno feto afo re ana weto mhar mawe anu bitsre ana akus. Ana hawe bo mari bo ro anu nkyas. Feto tibyo ana mesait oh mi misti kair ro meen mama mai kʼana.” ");
INSERT INTO ayz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kuber ro Yesus wait mabo 12 weto masen mamo. Ana mamo wosa Watum ro Allah kʼraa mawe, “Nashana tna bitsre iro wanu.” ");
INSERT INTO ayz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ana mikyak kabes mawat frok mbam raa. Tna ana moo minyakzaitun maya ngkaru kʼraa ro kiyam mawat ye, tna kiyam rana marak. ");
INSERT INTO ayz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesus yno bo ro msai mawat tibyo raa mkyas Ait yasom faram mamo snok mam arin aso beta. Tna raja Herodes yari Yesus yasom ye. Raa mnaut mawe, “Ait refi fi Yohanes Pembaptis, Ait yrok yasen. Reto oh mi Ait yatak yno bo msai weto to!” ");
INSERT INTO ayz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Menohe raa taro mawe, “Ait tait Yohanes Pembaptis fee. Ait tait nabi Elia.” Tna raa taro mawe, “Ait tait Elia fee. Ait tait nabi ro Allah ybis sait mfi bo nabi na ro tiwya tinyi Ait ybis ye.” ");
INSERT INTO ayz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Raja Herodes yari feto tibyo yawe, “Raa refi yatak yno bo ro msai. Tiwya jõ tbis raa ktan Yohanes yana yajat ne. Ait yrok yasen oh metait!” ");
INSERT INTO ayz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Tiwya raja Herodes ytak fnya ro yao Filipus rait. Masom rau to fai Herodias. Yohanes yari feto, tibyo yastako raja Herodes yawe yber safo oh meto. Tibyo raja Herodes kmo Yohanes tna ybis raa mamo mfot Yohanes make. Ana mfot ait tna makah mamo mbu mam bui. ");
INSERT INTO ayz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bo ro Yohanes yawe reto mno re fai Herodias mhaf mkair. Tibyo au saso iso re kbe raa mame Yohanes yajat. He mfe. ");
INSERT INTO ayz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Raja Herodes kmot ait wa wea. Ait yhar yawe Yohanes ja yno bo ro Allah ksoh sai. Tna yhar yawe Yohanes tait raa ro Allah rAit ye. Tibyo Herodes waa, tna hawe yno bo ro mkair mai kʼYohanes. Ait ynaut yawe kbe Allah yno bo ro mkair mai kʼait riryõn. Tna raja Herodes ksoh yari Yohanes ykyas Watum ro Allah ye. Ait beroh hre yari, menohe bokyas weto mno ait miskawowo ye. ");
INSERT INTO ayz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Fai Herodias mhau ste ati ro raja Herodes yakyõ hwiat rait ro tiwya yme mabe ait. Raja Herodes yoo taah yee kʼraa mase sor mama. Ait ymen raa ro ja mbo provinsi ro Galilea, raa mase ro mbo raa sbe ye, tna msya raa manes ro mhau mam rabin reto taro ye. Ana mama sohmaam bo su mam bokyõ reto. ");
INSERT INTO ayz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ana makyõ bokyõ reto to, ku ano ro fai Herodias rau masen smar. Herodes ysya raa ro mamaʼt bokyõ fo, ana hre horit ku au reto bo smar. Herodes ksoh bo ymat ku au. Tibyo ait ytu ku au reto yawe, “Nyõ ksoh bo bawya? Nayoh sai. Kbe jõ too tee kʼnyõ tu oh! ");
INSERT INTO ayz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jõ tsioh fee; bawya sai ro nyõ nayoh to, kbe jõ too tee kʼnyõ. Soh nyõ nayoh rabin ajõ refo hariyah sau to, kbe jõ too tsan kʼnyõ sai!” ");
INSERT INTO ayz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ku au mari feto, tibyo frok mamo mtu kʼmme mawe, “Tme, kbe jõ tayoh bawya ee?” Mme mawe kʼau mawe, “Nayoh Yohanes Pembaptis yana!” ");
INSERT INTO ayz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ku au reto hah me mamo mo kʼbi Herodes mawe, “Jõ tayoh raa mame Yohanes Pembaptis yajat! Nno fooh tna sbi yana nasyõ ait yana abyõ mam baki sau, noo nama nee kʼjõ.” ");
INSERT INTO ayz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Raja Herodes yari feto, tibyo ynaut yyi. Menohe riwai ait ysi bo kawi oh. Yafoh na mari wia oh no, tibyo ait ye yabe u fee. ");
INSERT INTO ayz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Feto mam weto si fo, ait ybis raa sait yawe, “Namo sbi Yohanes yana nakah nama!” Tna raa ro ja yno feto yari tna yamoʼt bui ktan Yohanes yana. ");
INSERT INTO ayz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ait yoo Yohanes yana yse abyõ mam baki, yasyõ yakah yama yee ku au reto. Tna ku au reto makah mamo mee kʼmme mmat ye. ");
INSERT INTO ayz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kuber ro Yohanes wait mari feto, tibyo ana mama moo ajat ro Yohanes. Moo ajat tna makah mamo sama mam isra mato. ");
INSERT INTO ayz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Raabis ro tiwya Yesus ybis weto, ana hah me mama siret su msya Yesus. Ana hah mama tna mkyas kʼAit bo bawya ro ana mno msya bo ro ana mkyas kʼraa ye. ");
INSERT INTO ayz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ati reto raa msis-sas mamo-me mmat Yesus tibyo ana msui, hre mait boit fee. Tna Yesus yawe kuber wAit yawe, “Nma, anu bmo saso wore mimon aro afo re anu sne hoh, biit boit, tna bjin baro rere bo ye.” ");
INSERT INTO ayz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tibyo ana masen maut wiak mamoʼt yuk ro mimon sau. ");
INSERT INTO ayz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Menohe raa msis-sas weto mmat ana bo masen sikba yuk reto mamo. Tna ana weto mhar wore ana masen mamo ye. Tibyo raa ro mbam remo kene mam weto sor, ana mawat masen mamo iso snok wia mam yuk ro ana mamo reto. ");
INSERT INTO ayz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tna Yesus ysya kuber wait snok mam maru maam jaro. Ait ymat he raa msis-sas mros wea. Tna ynaut yawe, “Raa ro mkyas Watum ro Allah kʼraa wefo aro fee. Ana mfi domba ro mhau akus sai. Raa ro kmot ana aro fee.” Tibyo Ait yatmof ana tna ykyas bo mawat kʼana ye. ");
INSERT INTO ayz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hreha oh tna kuber ro Yesus wAit mama mo kʼAit mawe, “Mti oh. Tna yuk refo fo riamo. ");
INSERT INTO ayz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nbis raa wefo masen mamo rof, re kbe ana saso boit ro mait aro. Kbe ana saso mam remo msya kota ro mhau kene mam wefo sor.” ");
INSERT INTO ayz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Menohe Yesus yawe kʼana yawe, “Anu nesait noo boit aro nee kʼana mait.” Tna kuber wAit weto mawe kʼAit mawe, “Amu ntai fee! Soh amu noo boit mkah nee kʼraa msis-sas refo mait to, kbe pitis mabyoh maut toni! Pitis 200 dinar bo feto!” ");
INSERT INTO ayz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Menohe Ait yawe, “Anu nse roti jya meto? Sik nmo nmat wia.” Ana mamo mmat tna hah me mama mawe kʼYesus mawe, “Roti maat msya syoh mana ewok aran sai fo.” ");
INSERT INTO ayz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Tna Yesus ybis re raa hre mam bosafom ro moof weto. Tna ana taro mabo 50 hre kbair sau hayah-hayah. Tna taro mabo 100 hre kbair sau hayah-hayah ye. ");
INSERT INTO ayz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tna Yesus yoo roti trion maat msya syoh mana ewok reto ybo. Tna heyut mam ayoh yayoh asik mase kʼAllah. Tna Ait haber roti weto tna yee kuber wAit yawe ana saim kʼraa ro hre weto sor. Tna yiti syoh mana ewok reto saim kʼana beta ye. ");
INSERT INTO ayz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Raa weto mait tna mhaf matu beta. ");
INSERT INTO ayz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Menohe roti mabuf taro msya syoh to msis mhau fares. Kuber ro Yesus wAit soo boit weto tna mfau mam keranjang trion 12 matot. ");
INSERT INTO ayz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Raa sme ro mait bo weto mabo trion 5000 bo feto. ");
INSERT INTO ayz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ana mno bo weto mkak si fo, Yesus ybis kuber wAit maut wiak matim wea mamoʼt remo ro Betsaida. Yesait yhau yawe ybis raa msis-sas wefo mamo bana. ");
INSERT INTO ayz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ait bitsre raa mamo bana tna Ait yaut yamo skabuk mam faut mana sau. ");
INSERT INTO ayz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Arin mti oh. Wiak ro kuber wAit maut fo mamo oh mam maru masuf. Tna Yesus yhau akus fares mam maru maam. ");
INSERT INTO ayz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Foos mfi mama mbam ati ro kuber weto miin wiak mamo, tibyo ana miin wiak reto hrowyõ mhai. Mam wore ayõ ro tuuf bo feto, Yesus yata abyõ mam aya mata yama yo kʼana. Ana mmat Ait yama, yfi bo yama yiwrek ana iti yamo bo feto. ");
INSERT INTO ayz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Kuber wAit mmat he Ait yamo abyõ mam aya mata yama tibyo ana miskawowo, mwohrarar mawe, “Nmat, bo mnat anu!” Menohe Yesus yawe kʼana yawe, “Knar oh, waa ma! Jõ mefi!” ");
INSERT INTO ayz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ait yaut mam wiak rana si fo, foos mrok mnem. Kuber wAit mrok mtak mmat bo msai ro Yesus yno reto. ");
INSERT INTO ayz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ana mmat bo msai ro Yesus riwai yno msya roti weto. Menohe ana srau mnaut yatak rAit fefares. ");
INSERT INTO ayz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ana mamo snok mam aya maam jaro to, ana miti wiak rana mam oo ro Genesaret. ");
INSERT INTO ayz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ana mroh mbam wiak mato mam weto si fo, raa mmat he Yesus yama. ");
INSERT INTO ayz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tibyo raa beak-ak anya mhoh mamoʼt remo ro kene mam weto mbra. Tna katar raa ro kiyam sor fo mama mo kʼYesus. Soh raa mari Yesus yhau mam yuk sau to, kbe ana katar raa ro kiyam weto mama mo kʼAit mam yuk reto ye. ");
INSERT INTO ayz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Woyõ-woya sai Yesus yamo to; mam kota ye, mam remo ye, kbe raa msis-sas makah raa ro kiyam mama mo kʼAit ye. Ana mama mse raa ro kiyam weto mam pasar rana. Tna ana soh-soh kʼAit mawe, “Amu niir ratan aNyõ makit sai mbau a?” Tna ana ro miir ratan rAit makit fo, kiyam rana marak beta. ");
INSERT INTO ayz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ti sau fo, raa ro Farisi msya guru agama Yahudi baro mbam Yerusalem mama mo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ana mmat he kuber ro Yesus wAit mait boit to, ana myon matem wana wia fee. ");
INSERT INTO ayz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Raa mabi ro Yahudi mbis raa myon matem wana kaket wia mamyot bo mafa rana, tna kbe mait boit. Soh raa mait boit menohe hawe myon matem wana kaket wia to, raa mabi ro Yahudi mnaut mawe kbe Allah kmo ana weto. ");
INSERT INTO ayz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bo mafa wana roto taro mawat ye: Ati ro ana mbam pasar mama to, kbe ana hre mait boit fee. Ana mate aya myon metsu wana beta wia matim mamyot bo mafa wana. Tna kbe ana hre mait boit. Tna raa ro Yahudi ja myon hawereh msya bo ro saruk boit moof kaket feto ye.) ");
INSERT INTO ayz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Raa mabi ro Yahudi weto mmat he kuber ro Yesus wAit mno bo mafa wana weto fee. Tibyo ana kmo mtu kʼYesus mawe, “Yesus; fyi re kuber woNyõ mno bo mafa wamu fee? Ro moof to, ana myon matem kaket wia tna fo mait bo to!” ");
INSERT INTO ayz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Yesus yawe kʼana yawe, “Tiwya Allah ybis nabi Yesaya ykyas anu. Ait ykom yawe anu nmo wan-wan sai. Mabo oh! Bokom reto mawe, ‘Raa mana refo mbaut Jõ mkah masoh mabyõ sai. Menohe ana mhaf wana to hayah sai. Ana maka smot Jõ mati sai. Tna bo ro ana mkyas mam samu watum rana to taro watum raa sai, mbam kʼJõ fee.’” ");
INSERT INTO ayz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Yesus yawe u yawe “Anu nno bo mkair! Watum ro Allah to, anu nsorni, beak. Tna anu nno bo mafa ro mbam kʼraa sai to matak. ");
INSERT INTO ayz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tiwya Allah ybis Musa ykom yawe, ‘Natmof nja msya nme na. Keluaran 20:12 Awya ro yawe kair yaja yme bo to, kbe ait raa mame yajat tu oh.’ ");
INSERT INTO ayz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Menohe anu nno bo mkair nwe raa matmof maja msya mme na to ma. Anu nwe kʼana nwe, ‘Thar tawe bo ro anu bewok nse to mabuf. Tii tawe tatmof anu mbewok tawe too pitis tee kʼanu, he mfe. Pitis weto beta tsan kʼAllah oh.’ ");
INSERT INTO ayz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Anu nwe feto tna natmof nja, nme na fee. ");
INSERT INTO ayz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Anu nno bo mafa ro hohos wanu fares menohe miwer Watum ro Allah oh meto. Tna anu ja nno bo mkair mnan feto taro ye.” ");
INSERT INTO ayz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tna Yesus ytu raa msis-sas mama. Tna ykyas bo kʼana yawe, “Nri oh, nnaut oh: ");
INSERT INTO ayz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bo aro mno wa iranya raa msya Allah to. Bo aro ro twok mam raa mhaf mno feto fee. Menohe bo ro frok mbam raa mhaf mato oh mi mno wa iranya raa msya Allah to.  ");
INSERT INTO ayz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Anu ro nri bokyas reto oh to, nnaut kaket!” ");
INSERT INTO ayz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus sikba raa mawat weto tna yamo twok mam amah mato. Tna kuber wAit mayoh kʼAit mawe, “Nbetoo bofret reto maja rau kʼamu.” ");
INSERT INTO ayz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tna Yesus yawe kʼana yawe, “Anu fo nfot fee ye? Boit ro raa mait tna aya ro raa mata to mno wa iranya raa msya Allah to fee. Bo sohmaam ro twok mam raa mhaf mato to bo ati fee. ");
INSERT INTO ayz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bo weto twok mam raa masoh to, tna mroh beta mamoʼt raa mhaf. Tna kbe haberek mamo syõ. Tibyo raa mamo msyõ mam sutet makus akus. Feto to, boit mesait ja mno wa iranya raa msya Allah to fee.” (Mkah bokyas reto to, Yesus yawe boit aro mbau to fee.) ");
INSERT INTO ayz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tna Yesus yawe, “Soh raa mhaf mkair to, kbe ait yno bo ro mkair ye. ");
INSERT INTO ayz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Raa ro mhaf mkair to, ja mnaut-nat bo ro mkair-kar. Ana mjah bo kbik-kbak, tna msyõf bo raa. Ana mame ajat, ");
INSERT INTO ayz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mno bo wyahte, ana masmamo, tna mhaf mkair-kar kʼraa anya. Ana sioh raa anya, tna mno bo ro mti hrenaut. Ana mawe kair raa anya, tna tawyõ ana ai, tna mno bo ninya sai, mnaut tis fee. ");
INSERT INTO ayz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bo ro mkair weto beta frok mbam kʼraa mhaf mato ro mkair. Bo weto oh mi mno wa iranya raa msya Allah to.” ");
INSERT INTO ayz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus sikba remo reto tna yamoʼt rabin ro Tirus. Ait twok mam amah sau yawe ymyõt Ait wai. Menohe mfe; raa mhar Ait yama oh. ");
INSERT INTO ayz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Tna fai sau mari he Yesus yama si fo, au mama mo kʼYesus. Fai au reto to, fnya mana ro Yahudi fee. Fai au fnya mana ro Siro-Fenisia. Au mama maka soh-soh kʼAit mawe, “Nikyak kabes ro mbo ku ajõ ro ano, mbau a!” ");
INSERT INTO ayz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tna Yesus yawe, “Ja raa moo boit mee kukek wana mait mhaf matu wia matim. Raa moo boit ro kukek mait reto to, beak mtah mait fee!” ");
INSERT INTO ayz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Menohe fai au reto mawe, “Ae; menohe makyõ-aka ro btek mbam ambar to, ja mtah mait.” ");
INSERT INTO ayz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tna Yesus yawe kʼfai au yawe, “Bokyas anyõ reto moof toni. Feto to, hah ne namo bonyõ oh. Kabes ro mbo ku anyõ to, frok mamo oh.” ");
INSERT INTO ayz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Fai au reto hah mamo snok mam amah rau. Tna mmat he ku rau reto mjin maam knar sai wea. Kabes frok mbam ku au reto mamo marak oh. ");
INSERT INTO ayz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus sikba rabin ro Tirus, tna yasen yamo iti kota ro Sidon yamoʼt maru ro Galilea. Ait truk mam rabin ro Dekapolis. ");
INSERT INTO ayz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tna raa makah raa sait mama mo kʼYesus. Ait retait yimara mtuk msya ymai kair ye. Ana soh-soh kʼAit mawe, “Yesus; noo natem ntor abyõ kʼraa refi, mbau a.” ");
INSERT INTO ayz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus yakah raa retait yamo wore ana mbewok mros kar. Tna Yesus yoo yatem krem ysu kʼait yimara ewok. Tna Yesus tfeh oot yatem yiir kʼraa retait hrea ye. ");
INSERT INTO ayz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mam weto Yesus heyut ayoh yayõ yafos fari-fara yawe, “Efata!” (Efata to mai ro Aram mawe, 'maah oh'.) ");
INSERT INTO ayz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Raa retait yimara mrok moof yari bo, tna ymai mrok moof ykyas bo yasoh mnan-an ye. ");
INSERT INTO ayz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tna Yesus yawe wa kʼana yawe, “Nmo nkyas bo wefo kʼraa renti ma!” Menohe ana mrok mamo mkyas kʼraa renti sai. ");
INSERT INTO ayz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Raa mari he Yesus yno bo msai reto to, mrok ktak. Ana mawe, “Ait yno bombra beta moof sai! Raa ro mimara mtuk sai, msya raa ro mai kair fyi sai, Ait yisoh mrok moof beta.” ");
INSERT INTO ayz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wore weto raa msis-sas mama mo kʼAit u. Tna boit wana marak. Tibyo Yesus ytu kuber wAit mama tna yawe, ");
INSERT INTO ayz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Jõ tatmof raa msis-sas wefo. Ana mama mhau msya Jõ ti trion tuuf oh. Tna mfo wefo boit wana mkak ye oh. ");
INSERT INTO ayz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Raa weto taro mama mbam tabam wana ro fari-fara ye. Soh Jõ tbis ana mkah hai sre hah me mamo to, kbe ana mhai awyah sne fefa mam iso maka.” ");
INSERT INTO ayz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kuber ro Yesus wAit mawe, “Fyi re anu bkai boit mnan mam yuk ro mimon refo?” ");
INSERT INTO ayz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tna Yesus yawe, “Anu nse roti jya meto?” Tna ana mawe, “Amu nse roti krema.” ");
INSERT INTO ayz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tna Ait ybis raa msis-sas wefo hre mte beta. Ait yoo roti krema weto yayoh asik mawat kʼAllah. Tna Ait haber roti weto kinyah ftah aro hayah-hayah, yee kuber wAit saim kʼraa msis-sas weto beta mait. ");
INSERT INTO ayz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tna fo Yesus yoo syoh maku baro ro mse ye. Ait ybo yayoh asik mawat kʼAllah tna yoo yee kuber wAit saim kʼraa msis-sas weto beta mabo. ");
INSERT INTO ayz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tna raa msis-sas weto mait tna mhaf matu. Tna roti msya syoh ro mhau fares to, kuber ro Yesus wAit soo mawah mfau keranjang trion krema matot. ");
INSERT INTO ayz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Raa sme weto mabo trion 4000 bo feto. Raa mait bo mkak tna Yesus ybis ana masen mamo bana. ");
INSERT INTO ayz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tna Yesus ysya kuber wAit maut wiak mamoʼt rabin ro Dalmanuta. ");
INSERT INTO ayz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Raa ro Farisi mabo baro mama mtu bo kʼYesus mawe sanet Ait. Ana mawe Ait yno bo msai aro re kbe ana mmat tna mhar mawe Ait ybam kʼAllah yama fe mfe a. ");
INSERT INTO ayz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus ynifasa tna yawe kʼana yawe, “Anu raa mana ro mfo nhau mam tabam refo fo, fyi re anu nyoh kʼJõ nawe tno bo msai re anu nmat? Kbe Jõ tno fee.” ");
INSERT INTO ayz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tna Yesus ysya kuber wAit maut wiak mawe mamoʼt maru maam jaro. ");
INSERT INTO ayz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kuber ro Yesus wAit sorni roti ro kbe ana mait to akus. Roti rana sau aran sai mhau mam wiak. ");
INSERT INTO ayz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus yawe wa kuber wAit yawe, “Kaket anu mkah ragi raa ro Farisi msya bi Herodes.” ");
INSERT INTO ayz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kuber wAit mari feto, tibyo mkyas kʼanya mawe, “Anu sorni roti ro kbe biit, tibyo Yesus yawe bo feto to.” ");
INSERT INTO ayz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Menohe Yesus yhar bo ro ana mkyas kʼanya feto. Tibyo Ait yawe, “Roti wanu kebet reto to, nnaut nkyas nno fyi? Anu wase Jõ tatak aJõ fares a? Anu nfot fefares a? ");
INSERT INTO ayz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Anu nsu mti. Anu raa ro nimara mtuk. Anu sorni bo to! ");
INSERT INTO ayz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tiwya anu nmat roti maat ro Jõ too saim kʼraa mabo trion 5000 mait. Tna ati reto to, anu soo ro ntari mhau to, nfau keranjang jya meto?” Ana mawe, “Keranjang trion 12.” ");
INSERT INTO ayz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Tna feto ye, riwai Jõ too roti krema tee kʼraa mabo 4000 mait to, tna ro ntari mhau to, anu soo nfau keranjang jya ye meto?” Ana mawe, “Keranjang trion krema matot.” ");
INSERT INTO ayz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ait yawe, “Anu wefo wase tatak aJõ fares a?” ");
INSERT INTO ayz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus ysya kuber wAit snok mam aya maam jaro, tna mroh wiak mam remo ro Betsaida. Tna raa makah raa ro yasu mboh sait mama mo kʼYesus tna mayoh kʼAit mawe, “Natem niir raa ro yasu mboh refi afo re yasu moof.” ");
INSERT INTO ayz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tna Yesus ybo raa ro yasu mboh retait yatem, befatu ait yamo frok ybam remo reto. Ait tfeh oot bi retait yasu tna Yesus yoo yatem yse kʼait yasu ye. Tna ytu kʼait yawe, “Nyõ nmat bo aro oh, fe mfefares a?” ");
INSERT INTO ayz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Raa retait heyut ymat tna yawe, “Jõ tmat bo kaket fefares. Tmat raa mfi ara ro mamo me bo feto sai.” ");
INSERT INTO ayz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus yoo yatem yse kʼraa retait yasu naut u. Tna ait yasu maah. Ait ymat bo kaket. ");
INSERT INTO ayz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tna Yesus yawe kʼait yawe, “Namo bonyõ oh. Namoʼt remo reto nkyas iti ma!” ");
INSERT INTO ayz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus ysya kuber wAit masen mamoʼt remo sor ro mhau kene mam kota Kaisarea Filipi. Ana mamo kri-kri fo, tna Yesus ytu bo kuber wAit yawe, “Raa mnaut mawe Jõ fi awya?” ");
INSERT INTO ayz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kuber wAit mawe, “Ana taro mnaut mawe, Nyõ fi Yohanes ro ja baptis raa. Tna taro mawe, Nyõ fi nabi Elia soh mfe to, nabi ro Allah ybis nama roto sait.” ");
INSERT INTO ayz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tna Yesus ytu kʼana yawe, “Bonaut ranu nesait nwe Jõ fi awya?” Tna Petrus yasen yawe, “Nyõ fi Mesias.” ");
INSERT INTO ayz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tna Yesus yawe wa yawe, “Nkyas bo refo renti kʼraa ma!” ");
INSERT INTO ayz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tna Yesus betoo kuber wAit yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Kbe meen kair mawat mama mai kʼJõ. Raa manes ro agama Yahudi kbe mikyak Jõ: Raa mabi wana ye, imam manes wana ye, tna msya guru agama wana ye. Jõ kbe raa mame tajat. Tna ti ro tuuf to, kbe Jõ trok tasen.” ");
INSERT INTO ayz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ait ykyas bo ro meen mai kʼAit, yawe bo reto meen mabo tu. Tna Petrus ykuk Yesus yamo kait kʼait yajoh jaro. Tna Petrus yastako Yesus yawe, “Nawe bo feto ma!” ");
INSERT INTO ayz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Menohe Yesus haberek ymat kuber wAit tna bhah Petrus yawe, “Petrus, namo fari tno. Nyõ nkyas bo ro kabes yabi (Iblis) ykyas meto! Bo ro nyõ nkyas reto to, bonaut ro mbam kʼAllah fee. Bonaut reto to mbam kʼraa sai meto.” ");
INSERT INTO ayz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Raa msis-sas huwya mawe mari bokyas rAit. Tna Yesus ytu ana msya kuber wAit mama beta. Ait yawe kʼana yawe, “Anu awya sai ro ksoh kro Jõ to, nko hawe sai kbe nno mfi fefo: Nno bo wanu u ma. Menohe nsom ara warok wanu sait-sait: Au oh mi nko hawe sai beroh nsom bo samyoh ro kbe mama mai kʼanu. Tna beroh kro iso ro Jõ terif kʼanu. ");
INSERT INTO ayz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Raa taro mawe misoh metsu rana ai mam tabam refo. Ana saso riof rana mam tabam refo sai ai menohe mnaut mamos rana fee. Meen ana weto mhau hame wajin fee. Menohe raa taro mawe mhau saso riof rana ai mam tabam refo fee. Ana mawe kro Bokyas Moof aJõ (Injil) tna mno bo woJõ ye. Ana saso Jõ tasom aJõ mam tabam refo. Ana weto oh mi kbe mkai riof kʼana. Ana kbe meen raa mame majat oto, menohe meen mkai riof ro hame wajin. ");
INSERT INTO ayz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mfi bo raa sait ykai kta mam tabam refo beta menohe ykai riof mase to fee; meen mafer rau to bawya? ");
INSERT INTO ayz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Meen anu nhai beta, tna bo satoh wanu meen kwiyat namos wanu me u fee. ");
INSERT INTO ayz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen Jõ hah tama u. Tama tkah bo yase ro Allah rAit. Tama tsya malaikat wAit ye. Menohe mfo refo, wore wo raa mhau mam tabam refo fares to, raa mawat mno iro woyõ-woya sai. Ana mfi raa ro wyahte Jõ. Raa mawat hawe kro Jõ. Ana hrenaut mkyas Jõ tasom. Ana ro harenaut Jõ feto to, meen ati ro Jõ hah tama u to, kbe Jõ harenaut ana ye.” ");
INSERT INTO ayz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tna Ait yawe kʼana yawe, “Nri oh! Meen anu baro nmat raa mana ro Allah yamo Raja ybo to, mama frok tubor. Frok to, anu ro nros nsya Jõ mam befo to, meen anu baro nhau fares nmat to. Ati reto to, anu nhai beta marak fefares. Anu nmat Allah ybo raa wAit feto to, kbe anu nmat Allah yatak rAit ye.” ");
INSERT INTO ayz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ti trion ntamam firwas tna Yesus yakah Petrus, Yakobus ysya Yohanes ro Yakobus yao yamo. Ana maut mamoʼt atu ro miyõ sau. Ana mesait mamo kar mam yuk reto. Tna ana mmat Yesus yetsu haberek. ");
INSERT INTO ayz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ratan rAit mamo mboh fyok. Raa sait bo ja yyon ratan moof fyok mfi feto fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tna ana mmat raa mabo ewok frok tubor mros msya Yesus. Ana mbewok weto to, Elia ysya Musa. ");
INSERT INTO ayz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tna Petrus yawe kʼYesus yawe, “Guru; amu ye nhau mam yuk refo to moof toni. Kbe amu sgi sbyah trion tuuf mam yuk refo: Sau kʼNyõ, sau kʼMusa, tna sau ye kʼElia.” ");
INSERT INTO ayz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ana waa, tibyo Petrus ykyas feto sai tna ait wase bokyas rait reto.) ");
INSERT INTO ayz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tna byõ mama sro-sro ana kait. Tna ana mari Raa sait ymai mam byõ mato yawe, “Ait refi Ku aJõ ro Jõ tksoh. Nri bo kʼAit!” ");
INSERT INTO ayz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mai reto mkak si fo, ana mmat mur mtan wore ana mros weto. Mmat he Yesus yesait aran sai. Tna Elia ysya Musa marak. ");
INSERT INTO ayz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ana mroh mbam atu reto mamo, tna Yesus ysi bo kʼana. Ysi yawe, “Bo ro riwai anu nmat to, nkyas kʼraa roto to ma. Nkyas ma wia, mamo snok mam wore meen Jõ trok tasen wia. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'.” ");
INSERT INTO ayz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ana mari bo ro Ait ykyas reto tna mtu kʼanya mawe, “Bawya ro mi Ait yawe ‘Meen yrok yasen’ meto?” ");
INSERT INTO ayz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tna ana mtu kʼAit mawe, “Fyi re guru agama wanu ro Yahudi mawe, ‘Meen Elia yama wia tna fo Mesias yama yrof to?’” ");
INSERT INTO ayz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Tna Yesus yawe, “Ae, Elia yatim yisoh bombra sor wia. Menohe Jõ tawe kʼanu tawe, Elia hah ye yama oh. Tiwya raa sikowah ait mamyot ksoh rana sai. Bo reto mabo oh mnan si bokom ro nabi sait tiwya ykom ykyas Elia. Tna nabi sait tiwya ykyas Jõ ye. Ait ykom yawe, ‘'Ait ro Yroh Yama Yfi Raa Sai' tait, kbe Ait yasom bo ro samyoh mawat. Tna raa makin kbe hawe smot Ait ye.’ Anu nnaut nwe bokom reto mkyas Jõ fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kuber ro Yesus wAit taro mhau akus. Ana santri bo msya guruagama Yahudi mabo baro. Raa msis-sas mros horit ana. Tna Yesus ysya kuber wAit mabo tuuf hah me mama mo kuber ro mhau akus weto. ");
INSERT INTO ayz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Raa weto mmat Yesus yama tna ana simaut mase. Tibyo mhoh mamo mtar Ait. ");
INSERT INTO ayz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus ytu bo kuber wAit yawe, “Anu santri bawya nsya guru weto?” ");
INSERT INTO ayz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ati reto raa sait yama yawe, “Bi Guru; jõ takah ku ajõ tama to kʼNyõ. Kabes mbo ait tibyo ymai marak! ");
INSERT INTO ayz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ati ro ruu mber ait to, kabes ntubat yetsu rait mabyõ tabam. Yafyat myoh, ybait rkit kʼanya, tna yetsu marktor-ktar ye. Jõ tayoh kuber woNyõ re ana mikyak kabes frok. Menohe ana matak fee.” ");
INSERT INTO ayz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus yawe, “Anu wefo mfe saut! Anu wefo raa ro smot Jõ fee! Kbe thau tsya anu kait fares a? Jõ thaf sneh tsya anu kait ye fee oh!” Tna Yesus yawe kʼbi retait yawe, “Nbo ku retait nakah nama!” ");
INSERT INTO ayz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tna ana makah ku retait mama mo kʼYesus. Kabes reto mmat Yesus si fo, mbo ku retait simoyot. Tibyo btek yai tabam tna beririk-rarak ait, yafyat matot yasoh ye. ");
INSERT INTO ayz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus ytu bo ku retait yaja yawe, “Ait kiyam fefo tija ooh-oh fe mfe a?” Yaja yawe, “Maban tii ykek mamo snok mfo refo oh. ");
INSERT INTO ayz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kabes reto msuk ntubat ku retait mbeak mam tafoh. Tna msuk ntubat ait mbeak mam aya ye, mawe mame ait yajat. Soh Nyõ ntai nisoh ku ajõ to, natmof amu!” ");
INSERT INTO ayz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus yawe, “Nyõ nnaut nawe Jõ ttai tisoh ait fe mfe a? Jõ ttai tno bombra beta soh raa smot Jõ matak.” ");
INSERT INTO ayz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesus yawe feto si fo, bi refi soh-soh ymai mase yawe, “Tuhan; jõ smot Nyõ. Menohe bosmot ajõ fo kebet sai fares. Natmof jõ re bosmot ajõ matak.” ");
INSERT INTO ayz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus ymat he raa msis-sas mama fooh mros mur mtan kʼAit. Tna Ait yawe kabes reto yawe, “Kabes ro mno raa mimara mtuk tna mai marak; Jõ tikyak nyõ nfrok nbam ku refi! Nhah ne nama nbo ait u ma!” ");
INSERT INTO ayz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kabes reto wahrarar mbo ku refi yetsu simoyot tna frok mamo. Tna raa mmat ku ait yjin yfi raa ro mhai. Ana mawe, “Ait yhai oh!” ");
INSERT INTO ayz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Menohe Yesus ybo ait yatem tubat yasen. Tna ait yasen yros. ");
INSERT INTO ayz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Rere baro naut Yesus ysya kuber wAit mamo twok mam amah mato. Ana mesait hre su tna mtu bo kʼYesus mawe, “Bo bawya mno re amu ntak nikyak kabes reto frok fee?” ");
INSERT INTO ayz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus yawe, “Kabes ro mfi feto to, soh raa skabuk Allah wia, kbe ana mbis kabes reto mikyak frok to saah.” ");
INSERT INTO ayz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus ysya kuber wAit sikba yuk reto masen mamo frit provinsi ro Galilea. Mamo to, Ait hawe raa makin mmat Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ait ykyas bo kuber wAit mesait sai tna yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna kbe raa mfot Jõ msan kʼraa roto mbo. Kbe ana mame Jõ tajat. Tna ti ro tuuf to, Jõ trok tasen.” ");
INSERT INTO ayz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kuber wAit mari bokyas reto menohe ana wase bawya ro Ait ykyas reto. Tna ana waa bo mtu kʼAit ye. ");
INSERT INTO ayz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ana snok mam remo ro Kapernaum tna truk mam amah sau. Tna Yesus ytu bo kuber wAit yawe, “Riwai anu santri bawya mam iso to?” ");
INSERT INTO ayz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Riwai mam iso to, ana santri anya. Ana mawe ana to, awya ro yase. Ana hrenaut mkyas bo reto tibyo mhre shait sai. ");
INSERT INTO ayz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus hre tna ytu ana mabo 12 reto mama. Tna yawe, “Awya ro yawe kbe yamo raa ro yase meto to, ait ye yamo yfi raa kinyah wia. Tna yno bo raa makin. Tna meen Allah yno re raa retait yamo yase.” ");
INSERT INTO ayz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tna Ait yoo ku maku sau yse mros msya ana weto. Tna Ait saku ku refo ybaut tna yawe kuber wAit yawe, ");
INSERT INTO ayz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Jõ ksoh anu nitrah nhaf wanu kʼraa ro mhaf sneh mfi ku kinyah. Awya ro yitrah yhaf rait ku kinyah sau tna yno feto mam Jõ tasom aJõ to, ait yno bo moof oh meto. Reto mnan anya mfi ait yno bo ro moof reto kʼJõ ye oh meto. Allah oh mi tiwya ybis jõ tama fo. Tibyo awya ro yitrah yhaf rait kʼJõ tait, ait yitrah yhaf rait kʼbi Allah ye oh meto.” ");
INSERT INTO ayz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohanes yawe kʼYesus yawe, “Guru; amu nmat bi sait yikyak kabes frok tna yawe ait yno feto mkah natak aNyõ. Menohe amu wase raa retait. Tibyo amu nwe wa kʼait nwe, ‘Nno feto ma!’” ");
INSERT INTO ayz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Menohe Yesus yawe, “Nwe wa kʼait ma. Awya ro yno bo ro msai mkah tak ro Jõ tasom to, kbe ait yno Jõ tasom mkair fee. ");
INSERT INTO ayz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nwe wa kʼait ma. Awya ro beswan anu fee, ait yhau mam ati ranu ye. ");
INSERT INTO ayz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nnaut oh: Soh raa sait yhar yawe anu smot Jõ, nwe Jõ fi Mesias, tibyo yatmof anu to; meen Allah yoo boren rait yaren kʼait retait tu oh. Tna soh raa sait yari Jõ, tna yatmof anu tibyo ywyan aya yee kʼanu aro nta to, kbe Allah yaren ait tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Raa ro yisti re ku maku ro smot Jõ sau mno iro to, soh ait ysu mam aya yhai to, moof miwer bo ro meen Allah yno mai kʼait retait! Tuhan kmo raa ro misti re raa roto mno iro to. Feto to mfi bo raa mawah fraa ro mase sau make mam yamyum, tna mbeak ait mam aya sawan to, bo reto to moof miwer bo samyoh toni ro meen ait ykai. ");
INSERT INTO ayz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Soh anu ntem jaro misti re anu sait nno iro to, nsbi natem anyõ reto beak war makus. Anu nhau nkah ntem sau aran sai tna nmo twok mam sawro ro Allah to, bo ro moof. Menohe soh anu nhau nkah ntem ewok tna re nno iro to, bo ro mkair meto. Meen Allah yoo anu beak niit mam tafoh ro roon. Meen Allah yoo anu beak mam sawro ro kair reto (neraka).  ");
INSERT INTO ayz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tafoh ro roon reto mhai fee, meen mait yoyo sai mamo snok mam hame wajin. Tna afan ro mhreh-reh raa mhau mam tafoh reto to, mhai fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Soh anu naa sau misti re anu sait nber nmo nno iro to, nsbi naa reto beak war makus. Anu nhau nkah naa sau aran sai tna nmo twok mam sawro ro Allah to, bo ro moof. Menohe soh anu nhau nkah naa ewok tna re nno iro to, bo ro mkair meto. Meen Allah yoo anu beak mam sawro ro kair.  ");
INSERT INTO ayz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tafoh ro roon reto meen mhai fee, mait yoyo sai mamo snok mam hame wajin. Tna afan ro mhreh-reh raa mhau mam tafoh reto to, mhai fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Feto ye soh anu nsu jaro misti re anu sait nno iro to, tufrok nasu makan reto. Anu nhau nsya Allah nkah nsu sau aran sai to, reto bo moof. Menohe soh anu nhau nkah nsu ewok tna re nno iro to, bo ro mkair. Meen Allah yoo anu beak mam sawro ro kair. ");
INSERT INTO ayz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tafoh ro roon reto meen mhai fee, mait yoyo sai hame wajin. Tna afan ro mhreh-reh raa mhau mam tafoh reto to mhai fee ye.” ");
INSERT INTO ayz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tna Yesus ykyas bofret sau yawe, “Bo samyoh ro mnan fi tafoh kbe mai kʼraa beta. Tna bo ro samyoh reto kbe mno raa mrok moof. Reto mnan fi haa ye. Soh raa yoo haa ybyat mam boit rait to, kbe boit reto mafah moof. ");
INSERT INTO ayz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Haa to, ja mafer moof. Menohe soh haa mafah fee; reto mkair, kbe raa mtai mno haa reto maser u fee. Feto ye, nhau to, nno bo ro mafer mawat kʼraa roto ye. Tna nhau niranya nsya raa anya. Reto moof ye. Soh anu ja nno bo ro moof fee; kbe anu raa ro mafer marak.” ");
INSERT INTO ayz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus sikba remo ro Kapernaum tna yaut wiak frit aya ro Yordan. Tna yamoʼt provinsi ro Yudea. Raa msis-sas mama mo kʼAit. Tna Ait ykyas bo kʼana mnan fi ja Ait yno. ");
INSERT INTO ayz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tna raa ro Farisi baro mama mo kʼAit. Ana mawe mtu bo sanet Ait mawe, “Fyi; mfi bo raa sait yako yfain makus sai. Ait yiwer Watum ro Musa ykom oh meto, fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus ye ytu kʼana yawe, “Watum ro Musa reto mkyas mawe bawya?” ");
INSERT INTO ayz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tna ana mawe, “Musa yawe, ‘Soh raa sait yako yfain rait makus to, kbe ait ykom aam ro mako au makus. Ykom tna yee kʼau wia, tna ait yako au.’” ");
INSERT INTO ayz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tna Yesus yawe, “Allah hawe raa sait yako yfain rait. Menohe anu ja nna matak sai; anu hawe nri Watum ro Allah. Au oh meto Musa ykom watum reto. ");
INSERT INTO ayz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Menohe Bokom ro Allah mawe, ‘Maban tiwya tinyi to, Allah yfen raa sme ye tna yfen fnya ye.’ ");
INSERT INTO ayz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Feto oh mi kbe ku ro sme sikba yaja ysya yme na tna yamo ysya yfain rait mhau su. ");
INSERT INTO ayz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kbe ana mbewok mjin su tna mhaf sau su ye.’ Kejadian 2:24 Feto to, Ana mnan fi raa mabo ewok u fee. Ana haberek mfi raa sait aran sai. ");
INSERT INTO ayz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tna raa sme msya fnya ro Allah yse mrat su to, raa sait bo ye betwat ma.” ");
INSERT INTO ayz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesus ysya kuber wAit mamo truk mam amah mato tna kuber wAit mtu kʼYesus mawe, “Nkyas bo ro riwai reno u kʼamu.” ");
INSERT INTO ayz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tna Ait yawe, “Awya sai ro yako fnya rait makus tna yamo ymen fnya ro u to, ait retait raa ro ywyah oh meto. ");
INSERT INTO ayz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mfi bo fai sau mako maa tna msya raa roto to, fai au reto fnya ro mwyah ye meto.” ");
INSERT INTO ayz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tna raa baro makah kukek wana mama mo kʼYesus. Ana mama re kbe Ait yse yatem abyõ kukek wana. Kuber ro Yesus mmat feto, tna ana mastako raa weto. ");
INSERT INTO ayz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Menohe Yesus ymat feto, tna bhah kuber wAit. Bhah ana yawe, “Nitsre ku kinyah weto mama mo kʼJõ. Nwe wa ana ma! Raa ro mama mo kʼJõ mnan fi kukek wefo fo, mhaf wana to, Allah ksoh. Ana oh mi mamo raa mana ro Allah yamo Raja ybo to. ");
INSERT INTO ayz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Menohe, Jõ tawe kʼanu tawe: Awya ro hawe mama mo kʼJõ mfi kukek wefo fo, kbe ana mamo raa ro Allah yamo Raja ybo to fee.” ");
INSERT INTO ayz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesus yawe bo weto, tna Ait tubat kukek weto yse yatem abyõ kʼana tna skabuk re Allah yno bo ro moof kʼana. ");
INSERT INTO ayz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus yasen yamo, tna raa sait yhoh yama tna yjit yimna hartu Yesus. Tna ait yawe, “Guru; Nyõ fi raa ro nhaf moof! Jõ kbe tno bo bawya re kbe meen Allah yno jõ thau hame wajin?” ");
INSERT INTO ayz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tna Yesus yawe, “Fyi re nyõ nawe Jõ fi raa ro thaf moof? Raa aro mhaf moof fee. Allah yesait aran sai yhaf rAit moof. ");
INSERT INTO ayz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nyõ nhar watum ntraa wefo: ‘Nme ajat ma! Nwyah ma! Nsyõf bo to ma! Siroyõ ma! Besruf raa ma! Nmat nja msya nme na to kaket!’” ");
INSERT INTO ayz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bi retait yawe, “Guru; tiwya taban tkek fares to, tiwer bo weto aro fee.” ");
INSERT INTO ayz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus ymat bi retait tna yatmof ait yawe, “Bo sau nyõ nno fefares: Namo nasim kta wonyõ beta. Tna nsaim pitis weto kʼraa ro bo marak. Soh nno bo reto to, nyõ name kta mam sawro ro Allah oh meto. Tna fo nama nkro Jõ.” ");
INSERT INTO ayz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ait retait bobot toni. Tibyo yari bokyas ro Yesus reto to, ait srau hri yamo bait. ");
INSERT INTO ayz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus ymat kuber wAit tna yawe kʼana yawe, “Raa ro bobot masen mamo raa ro Allah yamo Raja ybo to, min toni.” ");
INSERT INTO ayz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kuber ro Yesus wAit mrok ktak mari bo ro Yesus yawe reto. Tna Yesus yawe u yawe, “Ku woJõ sor fo, raa mamo raa ro Allah yamo Raja ybo to, min toni. ");
INSERT INTO ayz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Unta maboh sau twok mam sii hroh to, mnan-nan baro ye. Menohe raa ro bobot yamo raa ro Allah yamo Raja ybo to min toni.” ");
INSERT INTO ayz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kuber ro Yesus wAit mari feto tibyo mrok ktak. Tna ana mtu kʼanya mawe, “Soh feto to, raa awya meen ykai riof?” ");
INSERT INTO ayz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus yasu ymat ana tna yawe, “Anu raa to, nesait ntai nno riof kʼanu fee. Menohe Allah yno riof kʼanu saah. Ait ytai yno bo bawya sai.” ");
INSERT INTO ayz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tna Petrus yawe, “Amu wefo nsen sikba bombra wanu beta afo re nma kro Nyõ oh.” ");
INSERT INTO ayz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus yawe, “Raa ro smot Jõ tna mamo mkyas Bokyas Moof ro Allah (Injil) to, taro to, sikba amah rana. Tna taro to, sikba mao msya mano na, maja msya mme na, kukek wana, tna armato wana bo sor to. ");
INSERT INTO ayz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kbe ana beta mkai bo weto beta aro naut u. Kbe ana mkai amah aro u, mao msya mano na, maja msya mme na, kukek wana, tna armato muhrin trion 100 naut u mam tabam refo. Menohe kbe raa sikowah ana weto ye. Tna meen raa weto kbe mkai roon ro hame ye. Bo wefo beta kbe mabo tu oh. ");
INSERT INTO ayz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Menohe raa mawat ro mfo refo matim wia to, meen mamo tis. Tna ana ro mfo refo mhau tis to, meen matim wia.” ");
INSERT INTO ayz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus ysya kuber wAit mamo mam iso maka kri-kri mamoʼt Yerusalem. Tna Yesus yatim wia. Kuber wAit mnaut yyi. Tna raa taro ro kro Ait mamo fo, ana waa ye. Yesus ytu kuber wAit mesait aran mama tna Ait ykyas bo ro kbe mai kʼAit yawe, ");
INSERT INTO ayz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Anu bmoʼt Yerusalem mefo. Mam beto to, kbe raa mfot Jõ msan kʼimam manes msya guru agama ro Yahudi. Tna kbe ana mbis raa mame Jõ tajat. Tna ana ro agama Yahudi weto, kbe moo Jõ msan kʼraa ro wase Allah. ");
INSERT INTO ayz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kbe ana mamus Jõ, tfeh oot kʼJõ, moo too mmok-mak Jõ, tna kbe ana mame Jõ tajat. Tna ti ro tuuf to, kbe Jõ trok tasen.” ");
INSERT INTO ayz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tna Yakobus ysya Yohanes mama mo kʼYesus. Ana mbewok ku ro bi Zebedeus wait. Tna ana mayoh kʼAit mawe, “Guru; amu nyoh re Nyõ nno bo bawya sai ro amu nyoh kʼNyõ fo.” ");
INSERT INTO ayz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus ytu si kʼana yawe, “Bo ro anu nyoh kʼJõ to bawya?” ");
INSERT INTO ayz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ana mawe kʼAit mawe, “Meen Nyõ namo nase nbo raa woNyõ to; amu nyoh kʼNyõ re amu bewok nmo nse nsya Nyõ ye. Nbis amu sait hre kʼNyõ mam ati ro natem ati. Tna nbis sait hre mam ati ro natem ta.” ");
INSERT INTO ayz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Menohe Yesus yawe kʼana yawe, “Anu wase bo ro anu nyoh: Meen bo ro samyoh mai kʼJõ. Fyi; kbe anu mbewok ntai nsom bo ro samyoh mnan Jõ feto ye, fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tna ana mawe, “Amu ntak ye.” Tna Yesus yawe, “Bo ro mama mai kʼJõ to, meen anu nsom ye to. ");
INSERT INTO ayz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Menohe awya ro hre mam ati ro tatem ati msya tatem ta to, Jõ oh mi tsok ana weto fee. Raa ro hre mam yuk reto to, meen Allah yesait ysok bo rAit oh.” ");
INSERT INTO ayz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kuber wAit mabo nsaa taro mari bo reto, tibyo ana kmo Yakobus ysya Yohanes. ");
INSERT INTO ayz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Feto tibyo Yesus ytu ana mama tna yawe kʼana yawe, “Nnaut nwe raa ro wase Allah mam tabam refo to: Raa ro mamo aban mana wana ja mberasi raa kinyah ro ana mbo. Tna raa ro mamo tuan, tna hre abyõ mam uu to, ja mbis-bas raa sai. ");
INSERT INTO ayz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Menohe anu to, nno bo feto ma. Awya sai ro yawe yase kʼanu wefo to, ait yamo raabis ranu tna ait yno bo wanu ye to. ");
INSERT INTO ayz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tna awya ro yawe yatim yamo aban mana kʼanu to, kbe ait yamo sryan kʼraa beta wia. ");
INSERT INTO ayz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ynan fi Jõ fo. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ tama fo, tawe tbis raa mno bo woJõ fee. Menohe Jõ tama fo re tno bo kʼraa. Tna tama re too tetsu ajõ tfes raa mawat. Tibyo kbe ana mkai riof ro mase.” ");
INSERT INTO ayz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus ysya kuber wAit mamo snok mam kota ro Yerikho. Ana mhau ti baro firwas tna masen mamo. Tna ati ro ana sikba kota reto to, raa msis-sas kro ana mamo ye. Mam weto to, raa ro yasu mboh sait hre mam iso maam jaro yayoh bo. Ait yasom Bartimeus, ku ro bi Timeus yare. ");
INSERT INTO ayz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ait yari raa mawe, “Yesus, ro ybam Nazaret tait yama!” Tibyo ait ro yasu mboh retait ytu yawe, “Yesus, Ku ro Daud; natmof jõ!” ");
INSERT INTO ayz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Raa mawat kmo bhah ait mawe, “Shait!” Menohe ait beroh ytu fari renti yawe, “Ku ro Daud, natmof jõ!” ");
INSERT INTO ayz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus susu yros tna yawe kʼana yawe, “Ntu ait yama!” Tna ana mtu bi ro yasu mboh retait mawe, “Yesus ytu nyõ, yawe nasen nama!” ");
INSERT INTO ayz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Raa ro yasu mboh retait bitsre ratan rait ro mne mhau akus. Tna yasen fooh yamo yo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus ytu bo kʼait yawe, “Nyõ nksoh nawe Jõ tno bo bawya kʼnyõ?” Ait yawe, “Bi Guru; jõ ksoh tmat bo ye!” ");
INSERT INTO ayz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus yawe, “Bosmot anyõ misoh nyõ nasu maah meto. Namo oh.” Mam weto si fo, raa retait yasu mmat bo tna ait kro Yesus mamo ye. ");
INSERT INTO ayz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus ysya kuber wAit mamo mam iso ro Yerusalem fares. Tna ana snok remo ro Betfage msya remo ro Betania. Remo weto mhau mam Faut ro Zaitun. Tna Yesus ybis kuber wAit mabo ewok matim wia. Ait yawe, ");
INSERT INTO ayz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ntim wia, nmoʼt remo reto. Tna twok nmo to, kbe anu nkai keledai maku sau raa mii mros wea mam weto. Keledai maku reto raa maut hre abyõ mam uu fefares. Nmo skur keledai reto tna nkuk nma. ");
INSERT INTO ayz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Soh raa mtu bo kʼanu mawe, ‘Anu mbewok skur keledai reto mkah bawya?’ Nwe kʼana nwe, ‘Tuhan ybis yawe nee kʼAit wia. Kbe baro fooh sai raa moo misya hah me.’” ");
INSERT INTO ayz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tibyo ana mbewok masen mamo. Tna ana fri keledai reto raa mi mam amah ro mhau iso maam sau, tna ana skur keledai reto. ");
INSERT INTO ayz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Raa ro mros sor mam weto mtu bo kʼana mawe, “Anu skur keledai reto nmo nno fyi meto?” ");
INSERT INTO ayz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Menohe ana mawe, “Tuhan ybis yawe nee kʼAit wia. Kbe baro fooh sai raa moo misya hah me.” Tibyo raa weto mhau mmat rof bo ana skur sai. ");
INSERT INTO ayz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ana mkuk keledai reto mamo mee kʼYesus. Tna mrus jubah wana mnin keledai kbor. Tna Yesus yaut hre abyõ. ");
INSERT INTO ayz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Raa msis-sas mrus jubah wana tna tom tar-tar anya mam iso. Tna raa taro msot ara mawyan tom mam iso iti ye. ");
INSERT INTO ayz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Raa msis-sas ro matim msya raa ro kro mamo tis sor to, simaut mase mawe, “Hosana! Nyõ nase toni! Nyõ raabis ro Tuhan. Nyõ nama nkyas Ait to. Nyõ fi Ku renti ro nbam raja Daud, hohos wamu. Oon ro Nyõ namo Raja nbo raa mana woNyõ to, kene wo mama.” ");
INSERT INTO ayz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus ysya kuber wAit mabo 12 snok mam Yerusalem tna ntwok mam Samu ro Allah. Ait ymat bombra mam weto beta, menohe arin kene wo mti oh, tibyo ana masen hah mamoʼt remo ro Betania. ");
INSERT INTO ayz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Menrabu Yesus ysya kuber wAit frok mbam remo ro Betania mamo. Mamo iti mam iso ro Yerusalem to, Yesus yhai sre. ");
INSERT INTO ayz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ait ybam fari ymat ara mara sau ro mata ntin toni. Ait yamo kait mam ara mair reto yawe ymat make aro fe mfe a. Ait yamo snok kait ymat menohe make aro fee, mata rioh sai. Reto soo ro kake make fefares. ");
INSERT INTO ayz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tna Yesus kmo ara mara reto nto yawe, “Kbe raa sait ye yait kake make anyõ u fee!” Kuber ro Yesus wAit ana mari bo ro Ait ykyas reto. ");
INSERT INTO ayz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ana mamo snok mam Yerusalem tna Yesus yamo twok mam bohra Samu ro Allah rAit. Ait ymat he raa miwana Samu ro Allah. Tibyo Ait kmo yikyak raa ro masim bo msya raa ro moo bo sor mam beto. Raa taro hre masim pitis (penukar uang): Masim pitis Samu ro Allah kʼraa ro sriem. Tna raa mhre masim ruu merpati bo ye. Tna Yesus haberek-barak ambar wana ro masim bo weto. ");
INSERT INTO ayz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tna yno wa raa ro frit iti mam Samu ro Allah. Yawe, “Niwana Samu ro Allah ma! Refo fo iso fee! Nsom bo wanu mam befo ma! Nmo-nma frit Samu ro Allah fo ma! Nmo twaat tno soh! ");
INSERT INTO ayz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bokom ro Allah mawe: ‘Amah aJõ fo, mkah awya sai ro ybam arin aso beta yama skabuk.’ Yesaya 56:7; Yeremia 7:11 Menohe anu niwana amah refo fo. Anu hre nno bo mfi raa ro ja msyõf bo mefo!” ");
INSERT INTO ayz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Imam manes ro agama Yahudi msya guru agama wana mari bo ro Yesus yno mam Samu ro Allah. Ana mhar mawe raa mari watum ro Yesus ykyas tna mrok ktak beta. Yesus yasom mase mam rabin reto tna raa manes weto ana mrok waa. Ana mhaf mkair tna saim iso re kbe mame Yesus yajat. ");
INSERT INTO ayz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kene wore mti oh tna Yesus ysya kuber wAit frok mamo sikba kota reto. ");
INSERT INTO ayz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Menrabu rabu fo Yesus ysya kuber wAit mhah me mamo frit u ara mara ro iis reto iti. Tna ana mmat he ara reto samer beta. ");
INSERT INTO ayz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tna Petrus ye ynaut bo ro iis Yesus yawe. Ait yawe kʼYesus yawe, “Guru; sik nmat! Ara mara rno iis Nyõ nbis nawe nsamer to, mabo oh!” ");
INSERT INTO ayz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus yawe si yawe, “Smot Allah! ");
INSERT INTO ayz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","24","Bo bawya sai ro anu skabuk nyoh kʼAllah to, nhar nwe kbe anu fri bo reto. Nnaut mamo-me ma. Feto kbe anu fri bo ro anu nyoh kʼAit reto. Mfi bo raa sait yawe, ‘Atu rno matu mamo mai mam aya sawan!’ Soh ait ynaut mamo-me fee; kbe Allah yno bo ro ait yawe reto mabo tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ati ro anu nros skabuk nkyas bo kʼAllah to, nmat sas anu nhaf wanu wia. Soh anu aro nhaf mkair to, nisoh nhaf moof wia. Au oh mi; sorni bo mkair ro tiwya raa mno mai kʼanu to. Kmo ana ma. Tna re anu Nja ranu ro yhau mam sawro rAit tait, kbe yatmof anu tna yyon iro wanu ye.  ");
INSERT INTO ayz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Menohe soh anu hawe nisoh iranya ranu nsya raa ro mno iro mai kʼanu to, anu Nja ranu ro yhau mam sawro rAit tait, kbe yyon iro wanu fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus ysya kuber wAit hah me mamoʼt Yerusalem. Ait yamo mam bohra Samu ro Allah to, raa manes ro agama Yahudi mama: Imam manes, guru agama, msya raa mabi wana ye. ");
INSERT INTO ayz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ana mama tna mtu bo kʼAit mawe, “Awya oh mi ybis Nyõ, re Nyõ nama nno bo wefo fo?” ");
INSERT INTO ayz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Yesus yawe, “Feto Jõ ttu si bo sau kʼanu ye, tawe: ‘Yohanes Pembaptis: Ait retait raabis ro Allah fe mfe a?’ Nkyas si kʼJõ wia. Tna fo kbe Jõ tkyas awya ro ybis Jõ tama tno bombra wefo sor.” ");
INSERT INTO ayz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Raa manes weto mkyas kʼanya mawe, “Soh bwe Allah oh mi ybis Yohanes to, kbe Yesus yawe, ‘Feto tna fyi re anu ntu sioh bo ro Yohanes yawe?’ ");
INSERT INTO ayz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Raa mnaut mawe Yohanes tait nabi ro Allah ybis yama. Feto soh anu bwe raa sai ybis ait to, kbe raa kmo anu.” ");
INSERT INTO ayz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Feto to ana mawe kʼYesus mawe, “Amu wase ye.” Tna Yesus yawe, “Feto Jõ ye te tkyas tatak aJõ ro tno bombra wefo kʼanu fee ye.” ");
INSERT INTO ayz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tna Yesus ykyas bofret baro kʼraa manes ro agama Yahudi weto yawe, “Bobot sait yyum anggur mara mawat mam tabam rait. Tna ait ywas ana yur ytan mam armato rait. Tna ait yabah kayah sau mkah bo kbe mbokait anggur make tna yoo maya rau to. Tna ait sgi harit sau mkah ait hre kmot wa. Ait yno bo weto mkak tna fo ybis raa baro yawe ana mkah tna kmot armato anggur rait reto weya, kwiyat kʼana. Ait yawe kbe ana moo make rau to, saim taro hayah kʼait. Tna bobot retait yasen yamoʼt oo roto. ");
INSERT INTO ayz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ait yhau mam teto kait. Yhau mamo snok soo ro anggur mara wait weto make manes. Tna bobot retait ybis sryan rait sait hah yamoʼt tabam rait, yamo yo kʼraa ro kmot armato reto. Bobot retait ybis sryan retait yawe, ‘Nkyas kʼana ro kmot armato ajõ nawe ana mryoh anggur make aro moo mee kʼnyõ. Tna noo anggur make weto nakah nama nee kʼjõ.’ ");
INSERT INTO ayz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tna sryan retait yasen yamo. Yamo snok mam tabam ro bobot rait reto. Menohe raa ro kmot armato weto to raa ro mhaf kair. Ana huwya mai sryan retait. Ana mikyak ait. Tibyo ait hah ye ybo anggur aro fee. ");
INSERT INTO ayz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Feto tna bobot retait ybis sryan rait roto sait u yamo. Sryan ro ewok retait yamo. Yamo snok mam tabam ro bobot rait reto tna raa ro kmot armato reto huwya mamus sryan refi ye tna mai ait yana rait ye. ");
INSERT INTO ayz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tna bobot retait ybis sryan rait roto sait yama naut. Menohe raa weno huwya mame ait yajat. Feto ye bobot retait ybis sryan wait taro mama naut. Menohe raa ro mhaf kair weto, ana huwya mai sryan weto taro, tna mame taro majat ye. ");
INSERT INTO ayz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Bobot ynaut yawe, ‘Kbe tbis awya naut u fo? Kbe ana mari ku ajõ tu oh!’ Tibyo ait ybis ku rait sait aran tum ro ait yawyan marak to yamo. Tna ku retait yasen yamo. ");
INSERT INTO ayz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Menohe raa ro kmot armato anggur weto mmat he ku ait yama. Tna ana mkyas kʼanya mawe, ‘Ait ro meen shauk armato refo yama mefi! Ait refi yhau ma! Nma, anu bme ait yajat to, afo re meen armato refo mhau kʼanu!’ ");
INSERT INTO ayz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Feto to ana mame ait yajat tna tubat ajat rait mbeak mam armato reto mne.” ");
INSERT INTO ayz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tna Yesus ytu yawe, “Bobot ro armato rait retait kbe yno bawya kʼana ro kmot armato reto? Kbe ait yama yame raa weto tu. Tna ysan armato anggur reto kʼraa roto taro. ");
INSERT INTO ayz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nsorni ma Bokom ro Allah far-far refo: ‘Raa saso fraa mawe sgi samu sau. Ana mmat fraa sau mawe mkair. Fraa reto to, ana hawe. Tibyo moo mbeak makus. Menohe ana wase bo fraa reto oh mi fraa ro ati. ");
INSERT INTO ayz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tuhan oh mi yno bo reto mabo. Tna anu bnaut bwe bo reto moof toni.’” ");
INSERT INTO ayz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Raa manes ro agama Yahudi weto mhar mawe Yesus ykyas bofret weto mai kʼana. Tibyo ana kmo saim mawe mfot Yesus. Menohe ana waa mfot Ait mam wore raa makin mmat. Ana mnaut mawe kbe raa weto kmo ana. Tibyo ana sikba yuk reto mamo. ");
INSERT INTO ayz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tna fo raa manes ro agama Yahudi mbis raa ro Farisi msya raa ro kro Herodes baro mamo mo kʼYesus. Mbis ana weto mawe ana mamo ti te kro Yesus tna mari bo ro yawe. ");
INSERT INTO ayz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tibyo raa weto mama mo kʼAit tna mtu bo kʼAit mawe, “Bi Guru; amu nhar nwe Nyõ ja sioh fee. Tna Nyõ waa raa ro manes fee. Nyõ beroh nkyas bokyas ro Allah kʼawya sai. Tna iso ro Allah to, ja Nyõ nerif abyõ kʼraa to, nmyõt bo fee ye. Feto to amu ntu bo kʼNyõ nwe: Allah ksoh yawe anu mbero namabyoh (pajak)kʼKaisar fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Menohe Yesus yhar yawe ana mamo wan-wan sai. Tna yawe, “Anu syoh ntu bo sanet Jõ mkah bawya? Noo pitis mauf sau nee kʼJõ tmat wia.” ");
INSERT INTO ayz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ana moo pitis mauf sau mee kʼAit. Tna Ait ytu kʼana yawe, “Gambar refo fo msya awya yasom rait mefo?” Ana mawe, “Kaisar.” ");
INSERT INTO ayz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tna Yesus yawe, “Soh feto, bo bawya ro Kaisar rait to, noo nee Kaisar. Tna bo bawya ro Allah rait to, noo nee kʼAllah.” Ana mari bo ro yawe feto tna mrok ktak. ");
INSERT INTO ayz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ati sau to, raa ro Saduki baro mama mo kʼYesus. (Raa ro Saduki to raa ro agama Yahudi ye. Menohe ana ja mnaut mawe raa ro mhai to, meen me mrok masen fee.) Ana mtu kʼAit mawe, ");
INSERT INTO ayz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bi Guru; tiwya Musa ykom yawe, ‘Soh raa sait yhai tna ait sano to, kbe yao kro semit reto mkah yabe ku aro mkah shauk biin ait ro yhai retait.’ ");
INSERT INTO ayz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tna amu ntu bo kʼNyõ nwe: Mfi bo raa sme mabo ngkrema mao kʼanya mhau. Tna ro bum ymen fai sau, he ait sano tna yhai kba. ");
INSERT INTO ayz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ait ro ytan yao ro yabi fi yasen kro semit rana menohe yabe ku aro fee. Tna ait yhai ye. Feto ye yao ro tuuf yama kro semit rana naut. Menohe yabe ku aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Feto ye mnan anya sai mamo snok ro ngkrema beta. Tna fo fai au reto mhai ye.” ");
INSERT INTO ayz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tna raa ro Saduki weto nti te mtu Yesus mawe, “Meen ati ro hai mrok masen to, awya yfain fai reto? Tiwya ana mabo ngkrema ye mfain fai au reto ye fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Menohe Yesus yawe, “Bonaut ranu mkair meto. Anu wase Bokom ro Allah msya Ait yatak rAit to ye. ");
INSERT INTO ayz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Meen, ati ro raa mrok masen to, raa moo fnya u fee. Tna fnya mamo msya raa fee ye. Malaikat ja moo fnya fee. Meen raa mhau sai mfi malaikat sor mam sawro ro Allah. ");
INSERT INTO ayz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bokom ro Musa mkyas raa ro mhai meen mrok masen to. Nnaut nwe tiwya Allah ykyas bo kʼMusa ybam tafoh ro mait ara sau. Tafoh mait ara reto sohabyoh fee, menohe mait mbane sai. Tna Allah yawe, ‘Jõ fi Allah ro Abraham, Ishak msya Yakub ja mbaut.’ ");
INSERT INTO ayz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Allah yawe feto tibyo anu bhar bwe hohos wanu weto ro mhai ooh oh, ana mhai tibyo fee. Menohe Allah yawe ana mhau mam sawro rAit mbaut Ait fares. Feto to tawe kʼanu raa ro Saduki to, anu susre: Maja sau riwai anu nkyas to mkair. Mabo fee.” ");
INSERT INTO ayz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesus santri bo ysya raa ro Saduki nkri-kri fo. Tna guru agama rana sait yama yros ymat rof. Ymat he Yesus yakit maan betoo bo raa ro Saduki mtu kʼAit. Tna ait ytu kʼYesus yawe, “Watum ro tiwya Musa ykom beta to, watum ryo oh mi moof miwrek watum taro beta to?” ");
INSERT INTO ayz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus yawe si yawe, “Watum ro moof ati oh mefo: ‘Raa mana ro Israel, nri; Tuhan Allah ranu tait, Tuhan ro sait yum. ");
INSERT INTO ayz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nhafri Tuhan Allah ranu mkah nhaf, srau ranu beta, mkah bohar ranu beta, tna mkah ntak ranu beta ye.’ ");
INSERT INTO ayz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Watum ro ewok oh mi, ‘Nhafri raa ro mhau kene msya anu to ye. Nhafri ana mnan fi anu nhafri netsu wanu nesait ai.’” ");
INSERT INTO ayz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tna guru retait yawe si kʼYesus yawe, “Guru; bokyas aNyõ to moof ati. Mbris oh: Tuhan Allah tait, Ait sait yum oh. Allah roto aro mhau fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Anu raa ro Yahudi ja bnaut bwe, ‘Raa moo bo msan kʼAllah to, bo ro ati syok.’ He mfe. Mfo refo Jõ tsrau tnaut tawe, anu bhafri Ait mkah bhaf, srau ranu beta, mkah bohar ranu beta, tna mkah btak ranu beta ye. Au oh mi bo ro ati syok meto.” ");
INSERT INTO ayz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus ymat he bi ait retait yakit maan. Tibyo yawe, “Mbris oh, nyõ kene wo namo raa ro Allah yamo Raja ybo.” Tna raa aro ter-ter mtu bo kʼYesus u fee. ");
INSERT INTO ayz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus ykyas bo nkri-kri mam bohra Samu ro Allah to, tna Ait ytu bo kʼraa yawe, “Fyi re guru agama wanu ro Yahudi mawe, ‘Mesias tait Kube ro bi Daud to?’ ");
INSERT INTO ayz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tiwya Har ro Tuhan mbesi bi Daud ybis ait ykom yawe: ‘Tuhan yawe kʼTuan ajõ yawe, “Nama, hre nsya Jõ mam ati ro tatem ati; hroh ro mase reto. Hre wea. Tna raa ro byoh, raa ro srau kair kʼNyõ to, meen tno ana mbtek mam mte. Kbe Nyõ naa nber ana weto. Tna Nyõ nros natak abyõ ana, nbo ana.”’” ");
INSERT INTO ayz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yesus yawe u yawe, “Tiwya Daud ytu Mesias‘Tuan rait’ to, fyi re anu nkyas nwe Mesias tait Kube ro Daud?” Raa msis-sas ro hre weto ana mari bo ro Ait ykyas to nksoh toni. ");
INSERT INTO ayz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus yawe wa ana yawe, “Guru agama wanu ro Yahudi to, kaket ana: Ana ksoh myum ratan ro moof tna mamo-me afo re raa mmat ana tna bibi ana. Tna ana ksoh mawe raa mmah meen kʼana mam wore wo mamo mam pasar bo. ");
INSERT INTO ayz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ati ro ana mamoʼt samu watum to, tna ati ro ana mamo makyõ bokyõ to, ja ana msok ambar ro moof tna mhre mam weto ye. ");
INSERT INTO ayz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ana skabuk miyõ wer afo re raa mmat ana. Raa mmat feto tna mnaut mawe ana raa ro ja mno bo moof sai. Semit mnaut mawe ana raa ro ja mno bo ro moof, tna ana miwro semit weto tna mtak amah wana ye. Feto to, meen bo ro mkair toni mama mai kʼana tu oh.” ");
INSERT INTO ayz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ati sau Yesus hre mam Samu ro Allah. Ait ymat rof raa ro masen mama moo pitis msan kʼTuhan. Raa ro bobot mawat makah pitis mase mama mbero ye. ");
INSERT INTO ayz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Menohe semit sau moo pitis mauf wau ewok mbero ye. Pitis ro mabyoh mroh sai meto. ");
INSERT INTO ayz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus ytu kuber wAit mama tna yerif fai au reto kʼana yawe, “Bris oh, fai au ro semit rno moo pitis wau mabyoh mroh sai. Feto tna mfo refo pitis wau ro mse mam amah rau fares to marak. Feto to Tuhan ynaut yawe bo ro au mbero to, mawat miwer raa ofo beta. ");
INSERT INTO ayz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pitis raa taro mbero to, baro sai mbam kta wana ro mase. Menohe semit refo, moo pitis wau ewok ro mse mkah boit mait weno oh mi bero beta mefo, tibyo mtai marak.” ");
INSERT INTO ayz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus frok sikba Samu ro Allah, tna kuber wAit sait yawe, “Bi yabi, sik nmat Samu wore wono wia: Fraa maboh wore raa sgi amah wono to moof toni!” ");
INSERT INTO ayz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus yawe kʼait yawe, “Nmat Samu ro mase wono sor wia: Meen raa mitrah Samu weto beta. Tna kbe tembok msya fraa sau bo mhau ntar-tar anya feto fee. Meen fraa weto skik mbtek mai tabam beta.” ");
INSERT INTO ayz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tna Yesus ysya kuber wAit maut mamo hre mam Faut ro Zaitun ro mros msyok si Samu ro Allah. Tna Petrus, Yakobus, Yohanes msya Andreas mtu bo kʼYesus yesait kar mawe, ");
INSERT INTO ayz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sik nyõ beto kʼamu bo ro riwai Nyõ nkyas to. Tija re bo ro Nyõ nkyas weto mabo to? Kbe amu nmat bo bawya re nhar nwe bo ro Nyõ nawe weto kene wo mabo?” ");
INSERT INTO ayz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus yawe, “Kaket anu! Nno be raa mama sioh besruf anu. ");
INSERT INTO ayz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jõ fi Mesias sait aran, menohe meen raa mawat mama to, sruf bo mawe ana Mesias ybam kʼAllah. Kbe raa mawat mari feto tna smot raa weto. ");
INSERT INTO ayz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kbe anu nri he raa rabin taro mame anya tna mafa mnin-nin. Bo weto kbe mabo tu oh. Menohe waa ma: Bo weto kbe frok matim wia. Bo weto frok mama tna tabam refo haberek fefares. ");
INSERT INTO ayz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tna raa ro bangsa sau kbe masen mame anya msya raa ro bangsa roto taro. Tna raa ro raja sait ybo to, kbe masen mame anya msya raa ro raja roto taro mbo ye. Tna iin frok mam wore aro rau-rau. Tna kbe hai awyah btek mai kʼraa ye. Ti ro bo samyoh weto mama to, tinyi rau sai fares meto. Wore wo anu nmat bo weto to, kbe anu nhar oon reto mama. Reto mfi fnya ro mhaf ja kborham wia, tna kbe mabe to. ");
INSERT INTO ayz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kaket anu: Anu ro smot Jõ to, meen raa mfot anu tna makah mamoʼt samu ro raa mtu safo. Tna kbe raa mai-a anu mam samu watum ro Yahudi ye. Anu smot Jõ tibyo raa mfot anu makah mamo msan kʼaban mana sor. Feto tna kbe anu nkyas Jõ tasom kʼraja bo ye. ");
INSERT INTO ayz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wore tabam haberek fefares to, Bokyas Moof ro Allah (Injil) meen raa wosa mam bangsa beta. Snok bangsa beta maka wia tna tabam haberek. ");
INSERT INTO ayz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tna ati ro raa mfot anu, makah mamoʼt samu ro ja raa mtu safo to, nnaut yyi ma. Nnaut yyi bokyas ro kbe anu nkyas si kʼraa to ma: Kbe Har ro Tuhan mbesi bokyas moof kʼanu, mti bonaut kʼanu. Feto kbe bo ro anu betoo kʼraa ro mhau susai reto to, bokyas ro mbam Har ro Moof sai. ");
INSERT INTO ayz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Meen raa ro tabam refo hren ksuk anya, kbe ana mame anya majat: Raa msya mao na kʼanya, tna raa msya kukek wana ye. Tna kbe kukek mari maja, mme na fee, menohe moo ana msan kʼraa mame ana majat. ");
INSERT INTO ayz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anu fo nkro Jõ to, tibyo kbe raa beta knait anu. Awya ro beroh yari Jõ mamo snok mam tabam haberek to, meen Allah yoo riof ro mase yee kʼraa retait.” ");
INSERT INTO ayz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tna Yesus yawe, “Nmat bokom refo tna kbe anu nfot bo ro Jõ tawe kʼanu: Tiwya Allah ybis nabi Daniel ykyas yawe: ‘Meen bo sau ro mkair toni mama sikowah yuk ro mbau to.’ Daniel 9:27, 11:31, 12:11 Jõ tawe kʼanu tawe, ati ro anu nmat bo reto mabo to, kbe anu nhar nwe kene mam wore wo tabam refo haberek. Ati ro anu nmat bo reto to, anu ro nhau mam provinsi ro Yudea beta to; nsen nsam nmo nuut atu mana. ");
INSERT INTO ayz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Anu ro hre abyõ mam samu wanu kri-kri to; kbe nroh satoh bo wonyõ mbam amah mato nbo frok to ma! Nsam fooh nmo ntem marak sai. ");
INSERT INTO ayz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Anu ro nkah bo mam armato to; hah ne nmo noo ratan wanu ma. Nsam fooh nmo sai. ");
INSERT INTO ayz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wore weto to, fnya ro mhaf tna msya fnya ro mee sis ku mees wana to, ana mmof toni. ⌞Ana kbe matak msam fooh fee.⌟ ");
INSERT INTO ayz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Meen wore weto to, arin mkair toni. Maban tiwya tinyi Allah sair tabam refo mamo snok mam mfo refo fo, raa mkai bo ro mfi feto aro fefares. Tna bo ro mkair-kar mfi feto to aro meen me btek mai kʼraa u fee. Feto to skabuk nyoh Tuhan afo re meen bo reto mabo mam ati ro oom maah to ma. ");
INSERT INTO ayz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Oon ro samyoh reto to, oos mawe Allah yatmof raa sok wAit. Feto to yawe yisusu oon reto mabuf baro. Soh mfe to, raa sait bo meen ye yhau fee. Soh mfe to, raa beta mhai. ");
INSERT INTO ayz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Ati reto to, raa ro mawe besruf anu to, kbe frok mama. Taro mawe ana to Mesias, he mfe. Tna taro mawe ana to nabi ro Allah ybis mama mkyas bo wAit. He mfe ye. Meen ana mama tna sair bo ro hnah msya bo ro msai taro mawat. Ana mno bo ro msai re kbe besruf anu. Ana tomer besruf raa sok ro Allah wAit ye he mfe. Feto to, soh raa sait yawe bo kʼanu yawe, ‘Nmat, Mesias yama mam ati rno mno!’ Soh raa yawe feto, nri ait ma! Tna soh sait yawe, ‘Nmat, Mesias yama mam ati rau mau.’ Nri bokyas rait reto ma! ");
INSERT INTO ayz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Feto kaket anu sai. Bo weto beta Jõ tawe kʼanu wia matim tna meen bo reto mabo. ");
INSERT INTO ayz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Oon ro samyoh reto mkak wia, tna ayõ ro ja mafit to, me mamur. Tna snyi ro mboh to, me mboh u fee. ");
INSERT INTO ayz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kbe sken btek-tak mbam ayoh. Tna bombra ro mhau mam ayoh beta to, mrok mbrir-brar. ");
INSERT INTO ayz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Ati reto to, raa mmat Jõ tbam ayoh mboh troh tama. Tama to, raa mmat tatak aJõ ro msai msya tase aJõ ye. ");
INSERT INTO ayz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jõ kbe tbis malaikat woJõ mama mtu raa sok woJõ mbam arin aso beta mama mo kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tawe tkyas bofret sau kʼanu nri: Soh anu nmat ara mara sau, tna nmat ngkre ro sne-sne moof to, feto to anu nhar oh nwe kene wore snyi ro hwyõm oh meto. Nfot bofret refo maja rau: ");
INSERT INTO ayz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Feto ye, soh anu nmat bo ro riwai tkyas weto mama to, anu nhar nwe oon ro Jõ tama u reto to, kene oh meto. ");
INSERT INTO ayz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nnaut: Ati ro bo weto beta mama to, tawe biin refo to, kbe raa taro mhau fares. ");
INSERT INTO ayz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ayoh msya tabam refo kbe saef marak. Menohe bokyas aJõ kbe meen mhau mawyõs mamo snok mam hame wajin. ");
INSERT INTO ayz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ayõ ro Jõ tama u to, raa sait bo yhar fee. Malaikat ana wase ye. Jõ, Ku ro Allah yare fi, wase ye. Taja yesait aran yhar bo rAit. ");
INSERT INTO ayz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Anu wase ayõ reto ye. Feto to siwyan anu kaket yoyo sai. ");
INSERT INTO ayz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jõ tkyas bofret kʼanu u: Bi sait sikba amah rait yamoʼt rabin ro fari. Ait ybis sryan wait kmot amah rait wea. Tna ybis bo ro ana kbe mno to kʼana sait-sait hayah ye. Tna ybis sryan sait yros mam ati ro masa. Hre byõ abyõ. ");
INSERT INTO ayz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tawe kʼanu tawe, ‘Hre byõ abyõ ye. Anu wase ayõ ro bi retait hah yamaʼt amah rait ye: Kbe yama hreha, arin masuf, fe yama rabu momo a? Anu wase ye. ");
INSERT INTO ayz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kaket anu! Meen Tuhan yama tubor. Nno be kbe Ait ymat bo anu njin fares!’ ");
INSERT INTO ayz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bo ro Jõ tawe kʼanu wefo fo, kbe Jõ tawe kʼraa beta afo re ana siwyan wea ye.” ");
INSERT INTO ayz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ti ewok naut tna raa ro Yahudi makyõ korat ro Paskah. Tna kbe ana makyõ korat 'Roti ro Ragi Marak' to ye. Imam manes wana msya guru agama wana to, ana saim wai mawe mamo mfot Yesus tna mame Ait yajat. ");
INSERT INTO ayz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Menohe ana mawe kʼanya mawe, “Bo reto anu bno mam ati ro korat Paskah refo ma, be kbe bo reto mno raa makin mafa.” ");
INSERT INTO ayz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ati sau to, Yesus hre yait boit mam amah ro Simon mam remo ro Betania. (Bi Simon tait, tiwya yafa kusta.) Yesus hre yait bo kri-kri fo, tna fai sau twok mama. Mama mbo minyak wangi kusia sau. Minyak wangi to mabyoh maut toni. Au mama mihabah kusia reto tna mtu abyõ mam Yesus yana. ");
INSERT INTO ayz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Raa taro hre mam weto ye. Ana baro mmat feto, tibyo mrok kmo mawe kʼanya mawe, “Au mno bawya meto ee? Fyi re minyak reto sikowah sai a? ");
INSERT INTO ayz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Rau ro moof to, au masim kʼraa tna moo mabyoh rau 300 dinar. Tna mabyoh ro mase reto kbe raa msan kʼraa kinyah ro mse bo fee.” Tna ana bhah fai au reto wa. ");
INSERT INTO ayz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Menohe Yesus yawe, “Bhah au ma! Nno wa au to ma. Fai au mno bo ro moof kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Raa kinyah to, ja mhau su msya anu yoyo. Meen ti tija sai to, nno bo moof kʼana. Menohe Jõ fo, kbe thau tsya anu yoyo fee. ");
INSERT INTO ayz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Fai au mtu minyakwangi kʼJõ tetsu refo fo, siwyan hai aJõ wia oh meto. Kebet baro naut kbe raa mame Jõ tajat tna sama hai aJõ to. Au mno bo ro moof kʼJõ oh meto. ");
INSERT INTO ayz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nri kaket wia: Bokyas Moof ro mbam kʼAllah to, meen raa wosa mamo snok mam arin aso beta. Woyõ-woya raa mkyas to, bo ro fai au reto mno fo, kbe raa mnaut tna mkyas ye.” ");
INSERT INTO ayz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tna Yudas Iskariot yasen yamo yo kʼimam manes ro Yahudi. Yudas tait, kuber ro Yesus wAit mabo 12 weto sait ye. Yamo saso iso ro kbe ait ysan Yesus kʼana. ");
INSERT INTO ayz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yudas yama yo kʼana to, ana weto nksoh toni. Tna ana mawe kʼYudas mawe kbe maren pitis kʼait. Tibyo ait yasen yamo. Tna ywof ati ro moof re kbe besruf Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ti ro tinyi korat Roti ro Ragi Marak to, ja raa ktan domba sau, ro kbe mabo mam bokyõ ro Paskah. Ti reto kuber ro Yesus wAit mama mtu bo kʼAit mawe, “Nyõ ksoh nawe amu siwyan bo sohmaam mam woyõ?” ");
INSERT INTO ayz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tna Yesus ybis raa mabo ewok mbam kʼana weto yawe, “Nmoʼt kota. Tna kbe anu fri raa sme ro yasom baah mkah aya sait. Kro ait nmoʼt ");
INSERT INTO ayz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","amah ro ait twok to. Tna nmo ntu kʼbi ro amah rait retait nwe, ‘Guru ranu ytu bo yawe, “Yuk ro kuber woJõ msya Jõ kbe nkyõ bokyõ ro Paskah mam woyõ?”’ ");
INSERT INTO ayz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kbe ait yerif amah hawar ro uu sau kʼanu. Amah hawar reto mase. Tna ambar bo mhau wea oh. Siwyan bombra mam beto.” ");
INSERT INTO ayz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tna ana masen mamo. Ana mmat he bo beta huwya mfi bo bawya ro Yesus riwai yawe kʼana. Tna ana siwyan bo sohmaam mkah makyõ bokyõ ro Paskah reto. ");
INSERT INTO ayz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tna mti reto Yesus ysya kuber wAit beta mamoʼt amah reto. ");
INSERT INTO ayz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ana hre sohmaam bo tna Yesus yawe, “Anu wore hre niit bo su nsya Jõ wefo fo, sait kbe hren ksuk yno bo ro mkair mai kʼJõ.” ");
INSERT INTO ayz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kuber ro Yesus wAit mari bo ro Ait yawe reto, tibyo ana mrok sraujin tna ana wefo sait saak-saak Ait wa mawe, “Guru; jõ fee!” ");
INSERT INTO ayz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus yawe kʼana yawe, “Anu nbo 12 ro niit boit nsya Jõ su fo, sait hren ksuk kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Kbe raa mame Jõ tajat tu oh. Mame Jõ to, mnan si mkah Watum ro Allah tiwya mawe wia yum oh. Menohe ait ro hren ksuk kʼJõ to, meen safo maboh mai kʼait ye tu oh. Ro moof to, tiwya yme mabe ait fee sai.” ");
INSERT INTO ayz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ana sohmaam bo kri-kri fo, Yesus yoo roti sau. Yoo tna skabuk yayoh asik mase kʼAllah. Tna Ait haber roti reto yee kʼana beta mait. Tna yawe, “Nmat roti refo. Tetsu aJõ oh mefo. Noo oh.” ");
INSERT INTO ayz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tna Ait yoo hawereh sau. Yoo tna skabuk yayoh asik mase kʼAllah. Tna yee kʼana beta mata. ");
INSERT INTO ayz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tna yawe, “Anggur maya refo to, mees aJõ ro kbe miyi mkah riof kʼraa mawat. Kbe raa mame Jõ tna Allah ysair bosi ro tna kʼanu oh meto. ");
INSERT INTO ayz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jõ tawe kʼanu tawe, Jõ kbe tata anggur maya mam tabam refo u fee. Thau meen snok mam wore wo Allah yamo Raja ybo raa wait. Wore weto kbe Jõ tata anggur maya ro tna.” ");
INSERT INTO ayz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ana mji howes mkak tna masen mamoʼt Faut ro Zaitun. ");
INSERT INTO ayz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tna Yesus yawe kʼana yawe, “Anu beta kbe nsen nsam sikba Jõ nmo. Watum ro Allah mkyas feto mawe: ‘Jõ kbe tame raa ro kmot domba sait, tibyo domba wAit to, masen msam brir-brar mamo ye.’ ");
INSERT INTO ayz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Menohe kbe Taja yno Jõ trok tasen. Tna kbe Jõ tatim ste anu wea mam provinsi ro Galilea.” ");
INSERT INTO ayz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Menohe Petrus yawe, “Mfe; ana taro saah to, kbe masen msam sikba Nyõ to. Menohe Jõ kbe tasen tsam sikba Nyõ bo fee yum.” ");
INSERT INTO ayz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tna Yesus yawe, “Petrus, nari: Mti refo to, kook mara muhrin ewok fefares to, kbe nyõ nwaar Jõ wia muhrin tuuf oh, nawe nyõ wase Jõ.” ");
INSERT INTO ayz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Menohe Petrus yatak yawe u yawe, “Fyi-fya sai, Jõ kbe twaar Nyõ fee! Raa mawe mame jõ tsya Nyõ bjat su to mi bewok bjat rof!” Tna kuber wAit taro mawe feto beta ye. ");
INSERT INTO ayz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesus ysya kuber wAit masen mamoʼt yuk sau ro masom Getsemani. Tna Yesus yawe kʼana yawe, “Hre ste Jõ wea wefo tna Jõ tamo skabuk wia.” ");
INSERT INTO ayz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tna Ait yawe Petrus, Yakobus ysya Yohanes mama nkro Ait mamo. Ait ynaut yyi tna srau mham toni. ");
INSERT INTO ayz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ait yawe, “Jõ sraujin toni mfi bo tawe thai sai oh! Nhau mam befo tna siwyan kaket ye.” ");
INSERT INTO ayz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesus serar yamo baro naut, tna yabum skabuk. Yhar yawe ayõ ro mkair toni mama. Ait yawe yayoh Yaja re Ait tru bo ro kbe mama mai kʼAit to fee. ");
INSERT INTO ayz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ait yawe, “Abba, Taja: Jõ thar tawe Nyõ ntai natak nno bombra beta. Feto Jõ ksoh Nyõ tubat bo ro samyoh tna nno wa re kbe bo weto mai kʼJõ ma. Menohe Jõ ksoh tno bo ro Nyõ nawe sai.” ");
INSERT INTO ayz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesus skabuk mkak tna hah ye yamo ymat he kuber wAit mabo tuuf weto mjin tu. Ait yti ana ytu Petrus yawe, “Simon, nyõ njin tu sai a? Nyõ bito hre nwan nsya Jõ ayõ sau sai fee! ");
INSERT INTO ayz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hre nwan tna skabuk re kbe bo ro tabam refo tko anu nno iro to ma. Anu nwe nno bo ro moof. Menohe anu netsu to matak fee.” ");
INSERT INTO ayz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tna Yesus hah ye yamo skabuk mun sau naut yayoh bo ro riwai Ait yayoh weto u. ");
INSERT INTO ayz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ait skabuk mkak tna hah ye yama yo kʼana mabo tuuf reto u. Tna ymat he ana mjin maka toni, tibyo mjin tu bana sai. Ait yti ana mrok masen. Tna ana hrenaut tibyo mnaut bo ro mawe si kʼAit aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ait yamo skabuk muhrin ro tuuf naut. Tna hah ye yama u yawe, “Anu njin fares a? Nsen oh! Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Ayõ ro raa sait yama besruf Jõ fo, kene oh. Kbe ait besruf Jõ tna yoo Jõ ysan kʼraa ro ja mno iro mfot. ");
INSERT INTO ayz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nsen nma bmo oh! Ait ro besruf Jõ yama oh mefi!” ");
INSERT INTO ayz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus yros ykyas bo refo tna Yudas frok yama. Yudas ybam kuber wAit mabo 12. Ait yama yatim tna raa sbe mawat nkro ait mama ye. Ana masom pedang wana msya hbat. Riwai raa manes ro agama Yahudi mbis ana msya imam manes, guru agama, msya raa mabi wana mamo mfot Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","(Yudas ro besruf Yesus fi, riwai yawe yerif Yesus kʼana yawe, “Kbe Jõ tamo hana raa sait to. Ait oh metait. Nfot Ait tna nbo Ait kaket tna nkah nmo.”) ");
INSERT INTO ayz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Feto tna mkah tetara Yudas yamo yo kʼYesus tna yawe, “Bi Guru; meen oh kʼNyõ!” Tna ait hana Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tna raa ro kro Yudas mfot Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kuber rAit sait ymat feto tibyo yayõ pedang rait. Yayõ tna ysot sryan ro imam yase rait yimara nktos. ");
INSERT INTO ayz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tna Yesus yawe kʼana ro mama mfot Ait yawe, “Anu nbo pedang msya hbat nma nfot Jõ mfi bo Jõ raa ro tsyõf bo sai a? ");
INSERT INTO ayz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rabu wawa Jõ betoo Watum ro Allah kʼanu mam Samu rAit to. Menohe anu nfot Jõ mam beto fee. Bris oh bo ro anu nno refo mabo oh mnan Bokom ro Allah oh.” ");
INSERT INTO ayz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tna kuber ro Yesus wAit masen msam brir-brar beta sikba Ait akus. ");
INSERT INTO ayz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ati reto mere sait ro yyan hawee ftah sai wamu ait wa to kro Yesus ye. Raa mawe mfot ait ye, ");
INSERT INTO ayz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","menohe mfe; raa mbo sre hawee ftah rait mhau akus kʼana matem tibyo ait ysam sro raa yamo. ");
INSERT INTO ayz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Raa mfot Yesus tna makah mamoʼt samu imam agama Yahudi ro yase rait to. Tna imam manes beta, msya raa mabi ro agama Yahudi, tna guru agama wana ye, hre siret mam beto. ");
INSERT INTO ayz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tna Petrus ybo rof-rof ana mtis. Ait yamo snok mam bohra ro imam yase. Tna ait fuu twok hre ye yni foos su ysya raa sbe ro ja kmot samu reto ye. ");
INSERT INTO ayz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tna mam samu mato to, imam manes msya raa manes ro ja mtu safo raa ro Yahudi to, hre mkyas bo. Ana makin beta to, mtu kʼanya mawe “Anu buun Yesus bwe Ait yno bo bawya afo kbe anu bme Ait yajat?” Menohe ana fri safo mana aro fee. ");
INSERT INTO ayz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Raa mawat mkyas bo mbesus kʼYesus. Menohe ana sioh sai tibyo bo ro ana mkyas to hayah-hayah sai, mnan anya fee. ");
INSERT INTO ayz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tna raa mabo baro masen mros mkyas bo mbesus mai kʼYesus. Ana sioh mawe, ");
INSERT INTO ayz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Amu nri Ait yawe, ‘Samu ro Allah to, tiwya raa sgi mkah matak rana sai. Kbe Jõ tihabah Samu reto. Tna kbe Jõ sgi Samu ro tna sau mam ti trion tuuf sai. Samu ro Allah ro tna reto, raa sgi mkah matak rana fee.’” ");
INSERT INTO ayz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Menohe bo ro ana mkyas sioh reto aro ykyas rait hayah-hayah sai. ");
INSERT INTO ayz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tna imam ro yase yasen yros sayõ raa weto. Tna ait ytu kʼYesus yawe, “Boun ro raa mawe maun Nyõ reto to, Nyõ nasen betoo fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus yari bokyas wana menohe Ait shait si bait sai. Imam ro yase retait ytu kʼYesus naut u yawe, “Nyõ fi Mesias, Ku ro Allah yare a?” ");
INSERT INTO ayz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus yawe si yawe, “Jõ oh mefi. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen anu nmat Jõ hre tsya Allah ro yase. Kbe Jõ hre mam ati ro yatem ati; hroh ro mase toni reto. Tna kbe anu nmat Jõ troh tama abyõ mam ayoh mboh tama ye.” ");
INSERT INTO ayz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Imam ro yase yari feto, tibyo kmo ybo ratan rait yesait yhah-hah. Tna yawe, “Anu besait bri oh. Ait yawe Ait Mesias! Ait yamus Allah oh meto! Kbe anu saso raa roto mama maun Ait mkah bawya! Tna anu nnaut nwe fyi? Kbe anu bno bo bawya mai kʼAit?” Menohe ana beta mawe, “Safo makan btek mai kʼAit oh. Raa mame yajat tu oh!” ");
INSERT INTO ayz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tna raa baro ntfeh oot kʼYesus. Ana moo hawe make Ait yasu tna mmuk Ait. Mmuk tna mawe, “Sgi nawe awya ymuk Nyõ metait?” Tna raa sbe mama makah Ait mamo mai ye. ");
INSERT INTO ayz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petrus yhau mam bohra reto tna sryan ro imam yase rait sau mama. ");
INSERT INTO ayz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Au mama mmat Petrus bo hre yni foos mam tafoh. Au mmat kaket mhar Petrus yasu tna mtu kʼait mawe, “Nyõ ye oh ja nkro Yesus, raa ro Nasaret retait to a?” ");
INSERT INTO ayz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Menohe Petrus ywaar yawe, “Jõ twase. Jõ thar bo ro nyõ nawe reto fee!” Tna ait yasen yamo yros mam ana mato. Si fo kook mara. ");
INSERT INTO ayz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sryan reto mmat Petrus yros mam weto tna mawe kʼraa ro mhau sor weto mawe, “Bi ait retait raa wana sait meit!” ");
INSERT INTO ayz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Menohe Petrus ywaar naut u. Mhau baro tna raa ro mros weto sor mawe kʼPetrus mawe, “Nyõ fi raa ro Galilea ye; feto amu nhar nwe nyõ fi kuber wAit sait to! Ne nwaar ma!” ");
INSERT INTO ayz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tna Petrus ywaar matak tna yto bo yawe, “Ayoh mjah wa, jõ twase Raa ro anu nwe retait ye!” ");
INSERT INTO ayz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mam weto si fo kook mara muhrin ro ewok. Petrus yari feto tna ynaut bo ro riwai Yesus yawe kʼait yawe, “Kbe kook mara muhrin ro ewok to, nyõ nwaar Jõ muhrin tuuf oh.” Tibyo Petrus yawia sut-sut. ");
INSERT INTO ayz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Rabu momo to, raa ro ja mtu safo kʼraa ro Yahudi to, hre mkyas bo reto fares: Imam manes wana, raa mabi wana msya guru agama wana ye. Ana saim mawe kbe ana mame Yesus yajat. Ana make Yesus yatem tna makah mamo msan kʼgubernur rabin reto ro ja mtu safo. Ait yasom Pilatus. ");
INSERT INTO ayz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus ytu kʼYesus yawe, “Nyõ fi Raja raa ro Yahudi a?” Tna Yesus yawe, “Au oh nyõ nawe meto!” ");
INSERT INTO ayz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Imam manes mbra mkyas bo mawat taro mbesus mai kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tibyo Pilatus ytu kʼYesus u yawe, “Nari a? Raa mkyas bo mawat mbesus mai kʼNyõ. Nyõ nnaut fyi re hawe nkyas bo si kʼana fee?” ");
INSERT INTO ayz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Menohe Yesus yawe bo aro si ye fee. Tibyo Pilatus yrok ktak bait sai. ");
INSERT INTO ayz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ti reto raa ro Yahudi makyõ korat ro Paskah.Tahun aro rau-rau wore wo ana makyõ korat reto to, ja ana baro mamo mo kʼPilatus mayoh kʼait mawe ait tufrok raa ro ana mawe sait ybam bui. ");
INSERT INTO ayz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","(Ati reto to raa sait ro yasom Barabas yhau mam bui. Ait ysya yafoh wait to raa ro marmtuk. Ana weto hawe raja rabin ro Roma mbo ana raa ro Yahudi. Tiwya ana mno raa mrok kmo tna mnin-nin. Tna mame raa majat. Feto tna raa mfot ait mbu mam bui.) ");
INSERT INTO ayz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Raa mawat siret su tna mayoh Pilatus re kbe ait tufrok raa sait ybam bui mfi ja yno soo to. ");
INSERT INTO ayz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilatus yhar yawe imam manes weto mhaf kair Yesus. Feto tna ait yawe, “Fyi; anu ksoh jõ tufrok Raja raa ro Yahudi yamo bait fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Menohe imam manes wefo mkyas bo wai wia kʼraa makin wefo sor mawe, “Nkyas kʼPilatus nwe amu ksoh bo kbe ait tufrok Barabas.” Feto to raa makin mawe si mawe, “Tufrok Barabas, Yesus ma!” ");
INSERT INTO ayz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Menohe Pilatus ye ytu kʼraa mawat wefo u yawe, “Feto kbe jõ tno bawya mai kʼAit ro anu ntu nwe ‘Raja raa ro Yahudi’ retait?” ");
INSERT INTO ayz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ana masen mtu mawe, “Name Ait yajat mam ara warok!” ");
INSERT INTO ayz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Menohe Pilatus yawe, “Ait yber safo tna yiwana watum rabin ro Roma to miyo?” Menohe ana mari bo ro Pilatus yawe feto fee. Ana masen mtu mkah mai ro mase mawe, “Name Ait yajat! Name Ait yajat oh!” ");
INSERT INTO ayz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus beroh yari bo ro raa weto mawe sai afo re kbe ana ksoh ait. Tibyo ait tufrok Barabas yamo yo kʼana. Tna Pilatus ybis raa moo too mmok Yesus tna msan Ait kʼraa mame yajat mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Raa ro sbe mbo Yesus mamo ntruk amah ro gubernur Pilatus, makah mamoʼt amah hawar ro ja raa mtu safo. Tna ana mtu raa ro sbe majin beta mama siret wo sau mam weto ye. ");
INSERT INTO ayz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tna ana moo ratan ro mkek mfi ja raja yyum sau mse kʼYesus yyum. Tna fo ana mse watau kʼAit yana sbyõ ye. (Watau reto mfi watau ro ja raja sbyõ abyõ mam yana, menohe ana mfen watau Yesus rAit mbam abumun. Mno feto mkah bo nsie Ait.) ");
INSERT INTO ayz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ana mno bo weto mkak tna ana sioh mbaut Yesus. Ana sret Ait masah mawe, “Meen oh kʼNyõ Raja ro Yahudi fi!” ");
INSERT INTO ayz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ana moo ara nkrem mai Yesus yana, tfeh oot kʼAit tna maka bibi Ait mati sai ye. ");
INSERT INTO ayz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ana sret Ait masah, tna ana mrus ratan ro mkek riwai mse kʼAit yyum. Tna me moo ratan wAit mse yyum u. Tna fo ana makah Ait mamo mkah bo mame mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Raa makah Yesus mamo mam iso ro frok kota ro Yerusalem. Ana mbam kota frok mamo to, tna ana fri raa sait ybam safom yama. Ait raa ro srim, ybam kota ro Kirene. Yasom Simon. (Aleksander ysya Rufus maja rana.) Ait yawe yiwrek menohe raa sbe mfot ait, mkuk ait mbis yasom ara warok ro Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesus raa makah mamoʼt faut sau ro masom 'Yuk ro Hamana'. Mkah mai rana to, raa mawe 'Golgota'. ");
INSERT INTO ayz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tna ana moo anggur maya srioh mkah obat mur mee kʼYesus yata. Menohe Ait hawe bo yata. ");
INSERT INTO ayz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Raa sbe mse Yesus mam ara warok. Tna ana moo undi tane re kbe mhar awya ro yoo ratan ro Yesus rAit. Tna saim kʼanya. ");
INSERT INTO ayz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesus raa make mam ara warok rabu ayõ ro krenjiit. ");
INSERT INTO ayz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Riwai raa mkom bokom sau mkyas bo ro Yesus yno re mno raa mame Ait. Raa mkom tna mse mam ara warok reto abyõ. Bokom reto mkom mawe: “Raa refi raja raa ro Yahudi.” ");
INSERT INTO ayz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ara warok reto ati jaro-jaro raa mame raa ro ja msyõf bo mabo ewok msya Yesus ye. Ait sait raa mse mam ati ro Yesus yatem ati tna sait mam ati ro yatem ta ye.  ");
INSERT INTO ayz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ait raa sikowah feto mnan bokom ro Allah tiwya nabi Yesaya ykom yawe, “Raa mnaut mawe Ait raa ro yber safo ye.” ");
INSERT INTO ayz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Raa ro mamo frit iti sor mam weto to, mmat Yesus raa mame mam ara warok. Tna ana mana mnah sai mamus Ait ye mawe, “Ti taa, Nyõ nawe nyõ natak nitrah Samu ro Allah tna sgi u mam ti ro tuuf sai no! ");
INSERT INTO ayz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sik ma nroh nbam ara warok reto tna nno riof kʼNyõ nesait!” ");
INSERT INTO ayz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Feto ye imam manes ro agama Yahudi msya guru agama wana to, ana sret Ait masah mawe kʼanya mawe, “Ait yatak yno riof kʼraa roto sai. Menohe Ait ytai yno riof kʼAit yesait fee!” ");
INSERT INTO ayz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tna mawe kʼYesus mawe, “Soh Nyõ fi Mesias,Raja raa ro Israel meto mi, sik ma nroh nbam ara warok reto. Nroh nbam ara warok afo re amu nmat. Tna kbe amu smot Nyõ!” Raa ro ja msyõf bo mabo ewok ro raa mame su msya Ait to, ana mamus Ait ye. ");
INSERT INTO ayz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Baas ayõ ro 12 to, arin mrok mamur betru rabin reto beta, mamo snok ayõ ro tuuf. ");
INSERT INTO ayz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ayõ ro tuuf bo feto, Yesus ytu mkah mai ro fari yawe, “Eloi, Eloi; lama sabakhtani?” Mazmur 22:2 (Mai reto mawe, “Allah aJõ, Allah aJõ; fyi re Nyõ sikba Jõ toni fefo fo?”) ");
INSERT INTO ayz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ana makin ro mros weto to, baro mawe kʼanya mawe, “Sik nri, Ait ytu Elia!” ");
INSERT INTO ayz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tna ana sait yamo fooh yoo bo mabat ro aya msuf sau, beru mam anggur maya ro mano. Ait yoo tmi mam ara maku makit tna yyum maut yse kʼYesus yata. Tna ait yawe, “Anu bhau bmat kbe Elia yama smyoh Ait yroh ybam ara warok abyõ fe mfe a.” ");
INSERT INTO ayz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus ysiah ymai fari, tna fo yrok yajat. ");
INSERT INTO ayz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","(Yesus yhai si fo tirai ro raa hero mam Samu ro Allah mburut wa yuk ro mbau to, Allah yhah susai ftah ewok maban uu mamo snok mam te.) ");
INSERT INTO ayz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Raa sbe yase ro yros kene mam ara warok weto ymat Yesus bo yhai tna yrok yawe, “Mabo oh, Ait refi fi Allah yare!” ");
INSERT INTO ayz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Fnya baro mros fari mmat bo weto ye. Maria Magdalena, msya Maria ro Yoses ysya yao Yakobus ana mme (Yakobus retait, ait ro yaku), tna msya Salome mros su msya fnya weto sor ye. ");
INSERT INTO ayz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Fnya weto beta tiwya kro Yesus mam provinsi ro Galilea. Tna fnya roto taro mamoʼt Yerusalem msya Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Hreha ayõ ro jiit bo feto tna Yusuf yamo yo kʼPilatus. Yusuf tait raa ro Arimatea. Ait yamo raa manes ro ytu safo raa ro Yahudi sait. Ait raa ro waa Allah. Tna ait ja ste oon ro Allah yamo Raja ybo raa mana rAit. Yusuf yamo yo kʼPilatus mam ayõ ro Jumat. (Feto to raa ro Yahudi siwyan bo wana ti sau wia mkah kbe ayõ ro raa tmoh to.) Kene wo ayõ mbtek to, Yusuf yamo fooh yo kʼPilatus. Ait waa fee. Yayoh yawe Pilatus ybis ait yesait yoo ajat ro Yesus tna sama. ");
INSERT INTO ayz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yusuf yawe kʼPilatus yawe, “Yesus yajat oh.” Tibyo Pilatus yrok ktak yawe, “Yesus yhai fooh sai a?” Tna ait ytu raa sbe ro yabi yama tna ytu kʼait yawe, “Fyi, Yesus yajat oh a?” ");
INSERT INTO ayz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Raa ro sbe refi yawe, “Ae, yajat oh.” Tibyo Pilatus ybis yawe Yusuf yoo ajat ro Yesus tna sama. ");
INSERT INTO ayz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusuf yasen yamo yoo hawee ro fyan-fyan sne moof sau. Tna yamo smyoh ajat ro Yesus mbam ara warok. Ait yoo hawee reto sro ajat rAit wa yakah yamo yse mam isra rait. Isra reto tiwya raa mabah mam atu mtkah. Ajat ro Yesus raa moo mse mam isra mato tna bririk fraa maboh sau mburut isra mato wa. ");
INSERT INTO ayz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena msya Maria ro Yoses yme ana mamo mmat yuk ro raa mse ajat ro Yesus. ");
INSERT INTO ayz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Hari Sabtu ayõ ntwok. Ati reto ayõ ro raa agama Yahudi ja ntmoh to, mkak oh. Feto tna Maria Magdalena, Maria ro Yakobus yme msya Salome masen mamo moo minyak ro sawer msya bombra taro ye. Ana mawe menrabu ana mamoʼt isra ro Yesus raa mse. Tna ayõ ro minggu rabu momo isi ntara to, ana mrok masen mbo bombra ro sawer wefo sor mamoʼt isra. Ana mawe ngkaru ajat ro Yesus mkah bombra wefo mamyot bo raa ro Ibrani ja mno. ");
INSERT INTO ayz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mam iso iti ana mtu kʼanya mawe, “Kbe awya serar fraa ro mhau wa isra mato reto re anu twok to?” ");
INSERT INTO ayz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ana mamo baro kait tna mmat he fraa maboh reto raa serar mhau mne oh. ");
INSERT INTO ayz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ana twok mamoʼt isra reto mmat he mere sait ro yyum ratan ro mboh moof toni hre wea mam ati ro tem ati. Ana mmat feto tibyo mrok waa. ");
INSERT INTO ayz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ait retait yawe, “Waa ma. Anu saso Yesus, Raa ro Nasaret, ro taa raa mame yajat. Ait yrok yasen oh! Ait aro yhau mam wefo fee. Nma nmat yuk wore taa Ait raa mse oh mefo. ");
INSERT INTO ayz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hah ne nmo nwe kuber wAit msya Petrus ye nwe, ‘Yesus yrok yasen yatim ste anu wea mam provinsi ro Galilea. Nmoʼt Galilea tna kbe anu nmat Ait mam weto mfi tiwya Ait yawe kʼanu to.’” ");
INSERT INTO ayz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ana mabo tuuf mari bo reto mrok mamboi tna frok msam mamo sikba isra reto. Ana waa tna mhoh hah me to, mkyas bo reto kʼraa fee ye.  ");
INSERT INTO ayz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Rabu momo ayõ ro minggu reto Yesus yrok yasen oh. Tna tinyi rau to yerif Ait wia kʼMaria Magdalena. (Tiwya Yesus yikyak kabes mabo krema frok mbam fai au.) ");
INSERT INTO ayz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ati reto kuber ro Yesus wAit ana hre mawia sor fo. Tna Maria Magdalena mama mawe kʼana mawe, “Nwia ma! Jõ tmat Yesus yrok yasen oh!” ");
INSERT INTO ayz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Menohe raa weto mtu sioh kʼau sai, mawe bo ro au mawe reto mabo fee. ");
INSERT INTO ayz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tna Yesus yerif Ait ye mkah yetsu roto baro kuber wAit mabo ewok ro mamo iso nkri-kri mbam Yerusalem mamoʼt rabin roto. ");
INSERT INTO ayz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ana mbewok hah me mamo mkyas bo ro riwai reto kuber wAit taro. Menohe ana mtu sioh sai kʼana mbewok ye mawe bo reto mabo fee ye. ");
INSERT INTO ayz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ti baro firwas tna kuber ro Yesus wAit mabo 11 hre mait bo nkri-kri. Tna Yesus frok tubor. Ait bhah ana yawe, “Fyi re bosmot wanu matak fefares to? Raa mmat Jõ tna mama mkyas kʼanu oh, menohe anu nri fee. Anu nna mase sai ntu sioh kʼana to.” ");
INSERT INTO ayz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","“Nsen nmoʼt arin aso beta tna wosa Bokyas Moof ro Allah (Injil) kʼraa beta. ");
INSERT INTO ayz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Raa ro smot Jõ to, tna mawe raa baptis ana to, ana weto meen mkai riof ro mase. Menohe raa ro smot Jõ fee, meen Allah yno safo mana ymit kʼraa weto beta. ");
INSERT INTO ayz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Raa ro smot Jõ to, kbe ana mno bo msai sor afo re raa mmat tna mhar Jõ tatak aJõ: Ana weto kbe mikyak kabes frok mkah tak ro Jõ tasom aJõ. Tna ana kbe mkyas mkah mai roto ro ana wase fares ye. ");
INSERT INTO ayz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Soh ana mbo aban to, tna aban mafit ana matem to, kbe ana majat fee. Soh raa mse bombau re swa ana to, kbe ana majat fee ye. Soh ana skabuk tna matem mtor raa ro kiyam to, kbe kiyam rait marak ye.” ");
INSERT INTO ayz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesus ykyas bo kʼana mkak, tna Allah tubat Ait yaut yamoʼt sawro rAit. Tna Ait hre su ysya bi Allah mam ati ro yatem ati; hroh ro mase reto. ");
INSERT INTO ayz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tna kuber ro Yesus wAit masen mamo mkyas Watum ro Allah mam woyõ-woya sai. Tna Allah yatam ana. Tna yoo yatak rAit yee; tibyo ana mno bo ro msai mawat. Feto to raa mhar mawe watum ro ana mkyas to mbam kʼAllah.");
INSERT INTO ayz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teofilus ro yoof, Raa mawat mkom bombra beta ro Yesus yno mam rabin ranu refo. ");
INSERT INTO ayz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bo ro Yesus yno weto, raa taro mmat mkah masu wana. Amu taro nesait nmat Ait fee, menohe amu nri bokyas rana ro tinyi weto. Tna amu nkyas bokyas reto renti. Tna raa mkom bo ro ana mari mbam kʼanu weto. ");
INSERT INTO ayz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jõ ttu sas bo weto beta maban tinyi rau. Feto to tawe tesait tkom bo ro Yesus yno weto. Tkom kaket ");
INSERT INTO ayz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","afo re nyõ nhaf smot bo ro nyõ nari weto to, nhar nawe bo mabo. ");
INSERT INTO ayz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiwya tinyi bi sait yasom Zakharia yamo imamagama ro Yahudi. Hohos rait tiwya mamo imam ye. Ana mbam imam mkbair ro masom Abia. Ait yfain to, masom Elisabet. Tna hohos wau to, tiwya mamo imam ye. (Ati ro ana mbewok mhau to, Herodes yamo raja mam provinsi ro Yudea.) ");
INSERT INTO ayz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Allah ymat ana mbewok yawe ana mbewok to, raa ro mhaf moof. Mbewok mari tna mbo mno bo beta ro Allah ybis kʼraa wAit to beta. Bo ro raa mkyas mai kʼana aro fee. ");
INSERT INTO ayz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet siban tibyo ana mbewok mabe ku aro fee. Tna bewok mabi ye oh. ");
INSERT INTO ayz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hari minggu sau fo, mabu rau snok oh, tna Zakharia ysya imam ro mbair wait to, mkah bo ro Allah rAit. Tibyo yamoʼt Samu ro Allah mam Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bo sau ro ana mno to, ana moo bo msan kʼAllah. Reto oh mi ana mko bo ro mfi aku. Mko bo reto tna wasi rau to, sawer moof. Ja imam sait aran sai twok mam yuk ro mbau reto mato tna yko bo reto. Ati reto to, imam weto hre tane bo, mfi bo ja ana mno soo. Feto ana msok imam awya ro kbe twok mam yuk ro mbau reto mato. Ana hre tane he maut Zakharia. ");
INSERT INTO ayz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ayõ ro imam yko bo ro sawer reto mama to, raa makin mama mam Samu ro Allah tna skabuk. Raa beta siret skabuk mam yuk ro mbau reto mam mne wea. ");
INSERT INTO ayz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tna bi Zakharia yko bo sawer reto kri-kri mam amah mato. Tibyo malaikat ro Tuhan sau frok tubor. Mama mros tubor mros mam ati ro tem ati wohat ro mko bo sawer reto. ");
INSERT INTO ayz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ait ymat malaikat reto to, yhaf miyõ tna waa. ");
INSERT INTO ayz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","He malaikat reto mawe, “Waa ma! Tama tawe kʼnyõ tawe: Allah yari boyoh wonyõ oh. Tna nfain, Elisabet to, kbe mabe ku ro sme sait. Tna ku retait kbe nyõ nafan yasom Yohanes. ");
INSERT INTO ayz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kbe nyõ nawyan marak ku retait tna simaut toni. Nfain mabe ku tait, tibyo raa makin-akan yok-yok ye. ");
INSERT INTO ayz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kbe Allah ymat ait yawe ait raa ro yase. Tna kbe ait yata jyõ anggur fee. Yata jyõ roto aro fee ye. Tna kbe Har ro Tuhan matam ait, mhau mam yhaf rait maban mam ti ro yme mabe ait. ");
INSERT INTO ayz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tna bokyas rait kbe mno raa mhaf moof re kbe raa ro Israel msis haberek tna kro Tuhan.Tuhan fi Allah ro kbe ana smot. ");
INSERT INTO ayz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kbe Har ro Tuhan mjin mam Yohanes yhaf rait tna Har moo matak rAu mee kʼait. Mno mnan fi tiwya Har ro Tuhan reto mjin mam nabi Elia yhaf rait ye, tna moo matak rAu mee kʼnabi retait ye to. Meen Tuhan yama. Tna Yohanes kbe siwyan raa mhaf wana wia afo re kbe ana mari watum ro Tuhan. Bokyas rait mno re raa sme haberek me miranya msya kukek wana u. Tna raa ro srau mkair to, yno re ana ksoh mamo raa ro moof.” ");
INSERT INTO ayz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tna Zakharia fi yawe kʼmalaikat refo yawe, “Fyi re jõ thar tawe bo reto meen mabo tu oh? Jõ fi tabi oh tna tfain to mabi ye oh.” ");
INSERT INTO ayz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tna malaikat reto mawe kʼait mawe, “Jõ tasom Gabriel. Jõ thau tmat Allah. Tna bi Ait yesait ybis jõ tama tkyas bokyas ro moof refo kʼnyõ. ");
INSERT INTO ayz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Menohe nyõ ntu sioh bo ro jõ tkyas reto. Feto tibyo kbe nmai marak tna nkyas bo fee mamo snok mam ati ro bo wefo mabo. Bo ro riwai tkyas to, meen snok mam makyon rau to.” ");
INSERT INTO ayz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Malaikat reto mkyas bo msya Zakharia fares, tna raa ro mros mam mne to, sne ait kait. Ana miskawowo mawe fyi re ait yhau kait mam yuk ro mbau reto mato. ");
INSERT INTO ayz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tna ait frok yama to, ymai marak. Ytai ykyas bo kʼraa ro mros mwof ait wea mne to, fee. Ait yerif bo mkah yatem sai. Tibyo ana mhar mawe riwai ait ymat bo ro Tuhan yno aro. ");
INSERT INTO ayz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tna Zakharia yhau mam Yerusalem mamo snok ayõ rait ro yno bo ro riwai yno mam Samu ro Allah reto mkak. Tna fo ait yhah ye yamo bait. ");
INSERT INTO ayz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tna fo Zakharia yfain Elisabet fo, mrok mhaf. Tna au mhau mam amah rau mato snyi marak trion maat. ");
INSERT INTO ayz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tna au mnaut mawe, “Tuhan yatmof jõ: Tiwya jõ siban. Tna saban ye. Menohe Ait yno tibyo jõ trok thaf. Raa ro mkyas kair jõ to, kbe aro me mkyas-kas jõ u fee.” ");
INSERT INTO ayz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet mhaf snyi trion ntamam oh. Tna Allah ybis malaikat ro masom Gabriel reto mamoʼt remo sau ro masom Nazaret, mam provinsi ro Galilea. ");
INSERT INTO ayz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ybis yawe mamo mo ku ro ano sau masom Maria. Au fo wase bo mjin msya raa sme fares. Tna raa sait yasom Yusuf yawe kbe yoo au. Ait retait kube ro raja Daud. ");
INSERT INTO ayz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaikat refo twok mam samu ro Maria tna mawe, “Meen oh kʼnyõ. Tuhan yno bo moof toni kʼnyõ. Bi Ait yatam nyõ.” ");
INSERT INTO ayz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria mari bokyas reto mrok mnaut bo reto myum-yam. Tna mnaut berun bau sai mawe, “Bo bawya oh mi malaikat reu mama tna mmah meen kʼjõ u?” ");
INSERT INTO ayz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tna malaikat refo mawe kʼMaria mawe, “Waa ma. Allah yno bo ro moof kʼnyõ. ");
INSERT INTO ayz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yawe nyõ kbe nhaf tna nabe Ku sme sait. Kbe nafan Ku Ait yasom Yesus. ");
INSERT INTO ayz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ku anyõ retait kbe yamo Raa ro yase. Meen raa mkyas Ait mawe Ait tait Ku ro Allah yare. Allah tait yase toni. Tuhan Allah kbe yno re meen Yesus yase ybo raa wAit yfi Raja. Kbe yase ybo raa wAit yfi hohos rAit raja Daud tii hre mam ambar tahta tna ybo raa wait mnan feto ye. ");
INSERT INTO ayz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yesus kbe yamo Raja ybo raa mana ro Yakub. Yamo Raja ybo raa wAit mamo snok mam hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria mawe kʼmalaikat refo mawe, “Bo refo kbe mabo fyi? Jõ fo tsya raa fefares.” ");
INSERT INTO ayz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaikat refo mawe, “Har ro Tuhan msya tak rAu kbe mama mo kʼnyõ. Tna Allah yatak rAit kbe matam nyõ ye. Tibyo kbe nyõ nabe Ku sait. Ku retait Allah yse hayah mkah bo yno bo rAit. Tna kbe raa mawe Ait tait Ku ro Allah yare. ");
INSERT INTO ayz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tna raa mana wonyõ sau to, nyõ ntmo anyõ Elisabet au mabi oh tna au mhaf ye. Tiwya raa mawe au fo siban. Menohe au mfo mhaf snyi trion ntamam oh. ");
INSERT INTO ayz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Allah ytai yno bo bawya sai. Bo ro samyoh aro mhau kʼAit fee.” ");
INSERT INTO ayz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tna Maria mawe, “Jõ fi sryan ro Tuhan oh. Bo ro Ait yawe yno kʼjõ reto to, yno rof oh fea!” Tna malaikat reto mamo sikba au mamo. ");
INSERT INTO ayz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Tna fo Maria masen mamo fooh mo kʼntmo rau, Elisabet, mam remo rau. (Elisabet mhau mam atu far-far mam provinsi ro Yudea.) Maria ntwok mam remo reto tna mamoʼt samu ro Zakharia ysya yfain Elisabet. Tna au mmah meen kʼElisabet. ");
INSERT INTO ayz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ati ro Elisabet mari meen reto si fo, ku ro yhau kʼau mhaf yrok sio. Tna Har ro Tuhan msuf au. ");
INSERT INTO ayz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Har ro Tuhan msuf au tibyo au mkyas fari mawe kʼMaria mawe, “Fnya to mawat, menohe Allah ysok nyõ tna yno bo ro moof kʼnyõ nesait aran miwer. Tna bi Ait yno bo ro moof ku ro yhau kʼnyõ nhaf retait ye! ");
INSERT INTO ayz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jõ fi awya oh mi Tuhan yme mama mmat jõ fo? ");
INSERT INTO ayz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jõ tari meen anyõ si fo, ku ro yhau mam thaf refi simaut tna yrok sio mam jõ thaf. ");
INSERT INTO ayz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tii nyõ smot Tuhan tna nawe bawya ro Ait ykyas reto to, kbe mabo. Ja nyõ nnaut maut-mroh fee. Tibyo Ait yno bo moof toni kʼnyõ re nyõ simaut toni.” ");
INSERT INTO ayz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tna Maria mawe, “Jõ tbaut Tuhan yase rait ro yno bo moof kʼjõ. ");
INSERT INTO ayz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Allah oh mi Raa ro yoo riof mase yee kʼjõ tibyo jõ simaut! ");
INSERT INTO ayz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jõ fi raa kinyah sai. Menohe Ait ymat jõ. Jõ fi sryan rAit. Tna maban mam ati refo fo, kbe raa arin aso beta mawe Tuhan yno bo moof kʼjõ. ");
INSERT INTO ayz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Allah tait Raa ro yatak. Yno bosair ro moof kʼjõ. Yasom rAit hayah. Raa roto mnan Ait fee. ");
INSERT INTO ayz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tna Allah yatmof raa beta ro waa Ait: Maban raa ro tinyi msya hohos wanu mamo snok ku renti ro meen anu bbe ye. ");
INSERT INTO ayz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bi Ait yatak tna yno bo mawat. Tna Ait sibrir-brar raa ro mnaut mawe ana weto raa ro mase. ");
INSERT INTO ayz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Raa ro mase ja mbo raa ro kinyah. Menohe Allah soyak ana mroh mbam yuk rana ro hre. Tna Ait tubat raa kinyah ro ja mhar mawe ana to, raa kinyah sai, maut hre mam uu riryõn. ");
INSERT INTO ayz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ait ysan bo ro moof kʼraa kinyah ro haisre. Menohe raa ro bobot to, Allah yno ana haberek ybis mamo raa sai. ");
INSERT INTO ayz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ait yatmof anu, sryan wAit ro bno bo wAit. Yatmof anu raa ro Israel mnan fi tiwya Ait yawe. Ait sorni anu fee. ");
INSERT INTO ayz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tiwya Ait yawe yno bo moof kʼAbraham ysya ku renti wait mamo snok mam hame wajin. Ana to, hohos ranu oh meto.” ");
INSERT INTO ayz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria mhau msya Elisabet mam amah rau snyi trion tuuf bo feto, tna mhah me mamoʼt remo rau. ");
INSERT INTO ayz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet mhaf mase oh, ayõ rau ro mabe to kene oh. Tna au mabe ku sme sait. ");
INSERT INTO ayz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Raa wana weto beta msya au mafoh na mari he Tuhan yatmof au toni. Tibyo ana beta msya au simaut. ");
INSERT INTO ayz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ku retait yhau masno ro krentuuf to, tna ana makah ait mamo mkom (sunat) tna mafan yasom. (Mno mnan fi bo mafa raa ro Yahudi ja mno.) Tna raa mama mmat Zakharia ysya Elisabet msya ku mees refi. Raa mawe mafan ku refi yasom Zakharia, kro som ro yaja. ");
INSERT INTO ayz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Menohe yme mawe, “Mfe! Ait yasom rait Yohanes.” ");
INSERT INTO ayz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ana mawe, “Fyi? Raa wonyõ aro masom Yohanes fee!” ");
INSERT INTO ayz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tna ana mtu bo reto kʼZakharia. Ana merif bo mkah matem sai tna mtu mawe mafan ku retait yasom awya. ");
INSERT INTO ayz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakharia yayoh bokom sau tna ykom yawe, “Ait yasom rait Yohanes.” Tibyo raa weto mrok ktak beta. ");
INSERT INTO ayz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ati reto fo Zakharia ymai snok u tna ait bibi Allah. ");
INSERT INTO ayz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tna ana mafoh na mrok waa. Tna raa ro mhau mam atu far-far ro Yudea to, beta mari bo reto. ");
INSERT INTO ayz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tna raa beta ro mari bo reto to, hre mnaut mawe, “Tuhan yatam ku retait to. Meen ku retait yasen yno bo bawya?” ");
INSERT INTO ayz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tna Har ro Tuhan msuf Yohanes yaja, Zakharia. Tibyo Zakharia ykyas bo ro mbam Allah. Ait yawe, ");
INSERT INTO ayz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nma bbaut Tuhan. Ait yama ymat raa ro Israel. Ait yama yfes raa wAit. Ait tait Allah ro anu smot. ");
INSERT INTO ayz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ait ybis Raa sait yama yoo riof ro mase yee kʼanu. Ait tait kube ro raja Daud. Tiwya raja Daud yamo sryan ro Tuhan rAit ye. ");
INSERT INTO ayz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nabi ro Allah ybis mamo mkyas bo wAit to, tiwya tinyi ana makin mhaf sau mkyas mawe: ");
INSERT INTO ayz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Raa taro mamo byoh kʼanu tna taro knait anu ye. Menohe Allah yatak re yno riof kʼanu. ");
INSERT INTO ayz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tiwya Ait ykyas Bosi rAit kʼhohos wanu to. Ait ynaut Bosi reto tibyo Ait yatmof ana. ");
INSERT INTO ayz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bosi ro Moof reto tiwya Ait ykyas kʼhohos ranu Abraham. ");
INSERT INTO ayz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Allah yno riof kʼanu re kbe anu bno bo rAit to, waa fee. Raa ro mamo byoh kʼanu to, Ait yno re ana matak mno amu fee. ");
INSERT INTO ayz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Anu boo anu bsan kʼAit re bno bo wAit sai. Tna bmo raa ro mhaf moof mamo snok mam hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tna Zakharia watum ku rait Yohanes yawe, “Nyõ to, kbe natim siwyan iso mkah Tuhan ranu ro kbe yama. Allah ro yase hre abyõ ybo bombra beta tait, kbe ybis nyõ namo nkyas bo wAit. Tibyo kbe raa mtu nasom, ‘nabi ro bi Yase ybis’. ");
INSERT INTO ayz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kbe nyõ nerif bo kʼraa wAit re kbe ana mhar iso ro mamo re mkai riof ro mase. Tuhan yyon iro wana. ");
INSERT INTO ayz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Allah tait yatmof raa. Tibyo ybis Mesias yama yno riof kʼanu. Ait retait kbe ybam Allah yama. Yama yfi ayõ ro ntara maut mam rabu momo. ");
INSERT INTO ayz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yama tna kek rAit mram raa ro wase Allah tna mhau mam amur hto. Yama yram raa ro waa bo mhai. Ait kbe sana anu bisoh iranya ranu bsya Tuhan.” ");
INSERT INTO ayz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tna Yohanes yabi. Tna bosmot rait matak. Ait yamo yhau mam yuk ro riamo sau mam Yudea. Yhau mamo snok mam ayõ rau ro ait snok. Tna fo ait yamo ykyas bo kʼraa ro Israel. ");
INSERT INTO ayz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wore wo tiwya Yohanes yme mabe to, Kaisar Agustus yamo raja ro yase. Ait yase ybo raja na sor mam rabin ro Roma beta. Tna ait ybis yawe raa beta ro mhau mam rabin weto sor to, mamo daftar masom wana. Daftar masom re kbe ana beta moo pitis mee namabyoh (pajak) wana kʼait. ");
INSERT INTO ayz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Ti reto to, Kirenius yamo Gubernur mam provinsi ro Siria. Tna ati reto to, ti tinyi rau ait yno daftar feto mam rabin rait.) ");
INSERT INTO ayz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yno daftar reto, ybis raa beta ro mhau mam rabin rait reto hah mamoʼt remo wana ha-hayah tna mkom masom. ");
INSERT INTO ayz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tna bi sait yasom Yusuf yhau mam remo ro Nazaret mam provinsi ro Galilea. Raja Daud tait hohos rait sait. Yusuf yari bobis reto tibyo yasen sikba Nazaret yawe yaut yamoʼt remo ro Betlehem mam provinsi ro Yudea. (Remo reto tiwya tinyi raja Daud yhau. Tibyo raa mkyas mawe remo reto to, “Remo ro Daud Yhau.”) ");
INSERT INTO ayz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tna Yusuf yasen yamo ysya fnya rait ro meen yoo. Yawe mamo daftar masom wana. Au masom Maria. Au fo mhaf. ");
INSERT INTO ayz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ana mbewok mamo, mamo, snok mam Betlehem. Tna Maria kborham. ");
INSERT INTO ayz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kbor ham tna mabe ku bum ro sme sait. Tna au moo hawe tna sro Ku retait. Yuk ro moof wore ana mjin to marak. Feto to ana mhau mam sbyah ro domba. Tna Maria moo ku rau mirya Ait yjin mam ambar sau; mam ambar ro ja raa mse bosafom re domba mabat. ");
INSERT INTO ayz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mti reto to, raa baro mhau mam smok kene wo Betlehem. Ana hre mwan tok tna kmot domba wana. ");
INSERT INTO ayz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tna malaikat ro Tuhan sau frok tubor kʼana susai. Tna ana mmat Tuhan yase rAit ro skentrat. Tibyo ana mrok waa toni. ");
INSERT INTO ayz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Menohe malaikat reto mawe kʼana mawe, “Waa ma. Jõ tama tkyas bokyas ro moof. Tna raa beta ro mari bokyas refo kbe simaut mase: ");
INSERT INTO ayz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tawe, ‘Riwai fo, fnya mabe Ku sait mam Betlehem, remo ro raja Daud. Meen Ait sotak iro wanu tna yoo riof ro mase yee kʼanu to. Ait tait Kristus tna yamo Tuhan. Feto to, kbe raa simaut mase.’ ");
INSERT INTO ayz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kbe anu nhar ku mees retait fefo: Saso ku sait ro yjin mam ambar sau; yuk ro ja raa mse bosafom re domba mabat. Yme sro Ait mkah hawe tna mirya ait yjin mam beto.” ");
INSERT INTO ayz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tna malaikat mawat taro naut mbam sawro ro Allah mama frok tubor ye. Ana bibi Allah mawe, ");
INSERT INTO ayz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Amu nbaut Allah ro yase toni; Allah ro yhau mam sawro rAit! Tna raa ro tabam refo to, ana ro Ait yhaf mnan to, kbe bi Ait yisoh iranya ro raa weto to, msya anya.” ");
INSERT INTO ayz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Malaikat weto sikba ana hah mamoʼt sawro ro Allah. Tna raa weto masen mawe kʼanya mawe, “Nma bmoʼt Betlehem re bmat bo mase ro Tuhan ybis malaikat mama mawe kʼanu reu!” ");
INSERT INTO ayz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ana masen fooh mamoʼt remo reto mawe saso ku mees retait. Tna fri Maria, Yusuf msya Ku mees retait ro yjin mam ambar sau; yuk ro ja raa mse bosafom re domba mabat. ");
INSERT INTO ayz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mama mmat Ku retait. Tna ana masen mamo mkyas bo weto kʼraa: Mkyas bo ro riwai malaikat reto mkyas Ku mees retait. ");
INSERT INTO ayz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tna raa beta ro mari bo ro raa wefo mkyas to, mrok ktak. ");
INSERT INTO ayz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Menohe Maria mari bokyas wana weto tna kbo srau tna mnaut berun sai mam mhaf mato. ");
INSERT INTO ayz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tna raa ro ja kmot domba weto hah me mamoʼt smok riwai to. Mamo tna mbaut Allah: Bo ro riwai ana mmat reto to, mabo mnan bo ro malaikat mawe kʼana. Tibyo ana bibi Allah. ");
INSERT INTO ayz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yasno ro krentuuf tna Ku retait raa mkom (sunat). Tna ana mafan ait yasom Yesus, mamyot som ro tiwya, malaikat mawe kʼMaria oh to, ati ro au mhaf fefares. ");
INSERT INTO ayz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Watum ro Tuhan ybis Musa ykom to, mawe: “Fnya ro mabe ku to, mhau ti baro tna masen mamo msan bo kʼAllah re Ait yyon ana mbewok tna ana mbewok moof u.” Imamat 12:6-8 Tna mawe: “Ku sme ro bum to, ku ro Tuhan rAit oh.” Keluaran 13:2, 12 Ti baro firwas tna ayõ rau snok oh. Feto to Maria msya Yusuf masen mamoʼt Yerusalem tna twok mam Samu ro Allah. Mam beto ana moo bosan rana mee kʼimam sait ysan kʼAllah. Tna ana mabe Ku Yesus mamo msan Ait kʼTuhan ye. ");
INSERT INTO ayz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ana mamo msan bouum rana mamyot Watum ro Musa mbis mawe, “Kbe raa moo ruu tekukur mana ewok soh mfe ruu merpati ro teta mana ewok to, msan kʼTuhan.” ");
INSERT INTO ayz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ti weto bi sait yasom Simeon yhau mam Yerusalem. Ait tait raa ro yhaf moof. Ait ja mur-mur skabuk Allah. Tna yhau ste Mesias yama. Mesias retait tii Allah ysi yawe yama yo kʼraa ro Israel tna yisoh mhaf wana. Har ro Tuhan mhau mam Simeon yhaf ye. ");
INSERT INTO ayz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Har ro Tuhan tii mawe kʼait oh mawe ait meen yhau ymat Mesias wia, tna fo ait yhai. ");
INSERT INTO ayz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Riwai ayõ reto Har ro Tuhan mbis ait yamoʼt Samu ro Allah. Ait yamo tna ati reto Yesus yme msya Yusuf makah Ku Ait mamoʼt Samu ro Allah ye. Ana mamo ntwok mam mato mawe mno mamyot Watum ro Musa mbis. ");
INSERT INTO ayz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tna Simeon yoo Ku retait taam. Tna ybaut Allah yawe, ");
INSERT INTO ayz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Tuhan; mfo refo Nyõ nno mnan si bosi aNyõ oh. Jõ tasu tmat Ku refi. Ait ybam kʼNyõ yama yoo riof ro mase yee kʼraa. Jõ tmat Ait tibyo mfo refo jõ siwyan tamo oh. Jõ fi sryan aNyõ. Nbis jõ thai tna trof raa wojõ ro tiwya mhai wia matim sor to. ");
INSERT INTO ayz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nyõ nbis Ku refi yama re kbe raa beta mmat Ait tna mhar mawe Ait yama sotak iro wana. ");
INSERT INTO ayz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ait tait raa mana ro Israel sait. Kbe Ait yno anu bmo raa mana ro masom. Kbe raa mawe anu raa ro Israel to, raa mana ro Nyõ nsok. Tna Ait ynan kek ro mram iso mkah raa mana roto beta ye.” ");
INSERT INTO ayz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesus yaja ysya yme miskawowo mari bokyas ro Simeon ykyas Ku mees rana retait. ");
INSERT INTO ayz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tna Simeon skabuk Tuhan yawe bi Ait yno bo ro moof kʼana mbewok. Tna yawe kʼMaria yawe, “Ku anyõ refi Allah ysok. Kbe raa mari bokyas rAit tna mmat bo ro Ait yno. Feto tna ana mhar mawe Ait oh mi Allah ysok. Bo ro yawe tna yno weto to, mno re raa ro Israel mawat mikyak Ait ye. Tibyo ana weto mbtek. Menohe raa mawat taro kbe mari bokyas rAit. Tibyo ana weto mros matak. ");
INSERT INTO ayz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Raa mmat Ait tna kbe bonaut wana to, mrok msasi. Tna meen nyõ srau mham toni mnan fi bo raa moo tfo takoh nyõ.” ");
INSERT INTO ayz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mam beto to, fai mabi sau masom Hana mros ye. Tiwya au msya raa tahun trion ngkrema, menohe maa yhai tibyo au mhau semit sai. Fai au to, bi Fanuel yare ye, mbam raa mana ro Asyer. Au to, mamo nabi ro ja Allah ybis mkyas bo wAit ye. ");
INSERT INTO ayz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tna mefo refo au 84 tahun. Au mamo skabuk mam Samu ro Allah yoyo; rabu reha to, mhau skabuk tna mhau bo ro mait ye ");
INSERT INTO ayz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bi Simeon ykyas bo mkak si fo, fai Hana mama tna mbaut Allah. Au masen faram Ku retait yasom kʼraa beta ro ste Mesias, kʼraa ro minaut mawe Mesias kbe yama. Au mawe Ku retait oh mi Raa ro yama yfes raa ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusuf ysya Maria mno bo mamyot Watum ro Musa mkak. Tna ana hah me mamoʼt remo rana, Nazaret mam provinsi ro Galilea. ");
INSERT INTO ayz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mhau tna Ku retait yabi renti tna yrok yatak renti. Ait yhar bo tna Allah yoo bouum yee kʼAit ye. ");
INSERT INTO ayz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ja tahun sau-sau firwas to, raa mabi ro Yesus mamoʼt Yerusalem makyõ korat ro Paskah. ");
INSERT INTO ayz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus tait 12 tahun oh, tna Ait ysya ana masen mamoʼt Yerusalem mfi bo ja ana mno soo oh. ");
INSERT INTO ayz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ana makyõ korat ro Paskah reto mkak. Tna ana masen mawe hah me mamoʼt remo rana ro Nazaret. Yusuf ysya Maria mamo, mamo menohe Yesus yhau akus fares mam Yerusalem. Tna ana wase ye. ");
INSERT INTO ayz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ana mnaut mawe ait kro raa wana makin ro mamo su msya ana. Tibyo ana mbewok mamo ti sau tna ana saso mtu Yesus kʼmao, mano wana msya mafoh wana ro msya ana mamo su. ");
INSERT INTO ayz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","He ana mkai Ait fee. Tibyo ana masen mhah mamoʼt Yerusalem u mawe saso Ait. ");
INSERT INTO ayz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ti trion tuuf ana saso, saso Ait. Tna mamoʼt Samu ro Allah. Ana twok mam Samu ro Allah tna fri Ait mam mato. Ait hre yari guru agama mkyas bo tna ytu bo kʼana ye. ");
INSERT INTO ayz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yesus tait srau bo ro ana mkyas weto. Tna raa beta mari bo ro Ait ykyas to, mrok miskawowo. ");
INSERT INTO ayz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tna raa mabi wAit ntwok tna mmat Ait hre susai ykyas bo ysya raa ro mase weto. Ana mnaut mawe, “Bawya meto?” Yme mawe kʼAit mawe, “Nyõ nno bawya meto? Amu mbewok saso nyõ nhai rowyõ nhai mefo!” ");
INSERT INTO ayz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Menohe Yesus yawe, “Anu nma saso Jõ a? Jõ tama thau mam samu ro Taja fo fea! Anu mbewok srau fea?” ");
INSERT INTO ayz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","He ana mfot bo ro Ait ykyas reto fefares. ");
INSERT INTO ayz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tna fo Ait yasen ysya ana mamoʼt Nazaret. Yesus tait ja yari bo ro ana mawe. Bo ro Ait yno weto to, Maria mnaut mam mhaf mato bau sai. ");
INSERT INTO ayz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus yabi tna yetsu matak renti, tna yhar bo ro ati ybo yno renti ye. Allah hasu Ait tna raa hasu ye. ");
INSERT INTO ayz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tahun baro firwas tna Kaisar Tiberius yamo raja ro yabi. Ait yase ybo raja na taro mam rabin beta ro kene mam Roma. Tiberius ybo tabam reto 15 tahun oh. Wore weto Pontius Pilatus yamo gubernur mam provinsi ro Yudea. Tna Herodes yamo raja ybo provinsi ro Galilea. Filipus (Herodes yao) yamo raja mam rabin ro Iturea msya Trakhonitis. Tna Lisanias yamo raja mam rabin ro Abilene. ");
INSERT INTO ayz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tna bi Hanas ysya bi Kayafas mamo imam mase ro agama Yahudi. Mam wore weto Zakharia yare, Yohanes, yhau mam yuk ro riamo. Tna Allah ykyas bo kʼait. ");
INSERT INTO ayz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tibyo ait yasen yamo ykyas bokyas ro mbam Allah reto. Ait yawe, “Nashana fooh! Tna jõ baptis anu. Jõ baptis anu re kbe raa mmat tna mhar mawe anu nashana oh tna nmo no kʼAllah. Tibyo bi Ait yyon iro wanu.” Yohanes yamo tyo-teya mam rabin aya Yordan yur beta ykyas bo reto. ");
INSERT INTO ayz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yohanes yamo ykyas bo feto to, yno mnan si bokyas ro tiwya Allah ybis nabi Yesaya yama ykom mam aam rait. Aam reto mawe: “Meen raa sait kbe yama ykyas bo woJõ mam yuk ro riamo sau. Ykyas yawe, ‘Mbetrot iso mkah Tuhan yama! Nisoh iso kʼAit! ");
INSERT INTO ayz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Naru mbetnen atu msya faut. Tna noo tabam nruk wo mbair beta matot! Tna iso ro mwak to nisoh mbetrot! Tna iso ro maut-mroh to, nisoh maru sneh! ");
INSERT INTO ayz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kbe raa ro arin aso beta mmat tna mhar mawe Allah yatak yoo riof ro mase yee kʼraa.’” ");
INSERT INTO ayz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Raa mawat mama mo kʼYohanes afo re ait baptis ana. Menohe ait ykyas kʼana yawe, “Anu to, raa ro nmo wan-wan nfi aban kume! Awya ykyas bo kʼanu yawe Allah kmo tna meen yno bo ro mkair mbtek mai kʼanu? Awya ykyas feto tna re anu nhar nwe nsam nma saso riof kʼanu? ");
INSERT INTO ayz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","9","Nashana! Nno bo moof. Tna kbe raa mhar mawe anu nashana oh. Soh anu nno feto to, anu nfi kake mara ro mros make mawat tna moof. Allah yatem ybo baam oh. Ait siwyan yfat ara. Kake mara ro make rau moof fee, kbe Ait yfat tna yoo beak mam tafoh yko makus mait. Anu ja nnaut nwe, ‘Anu fo kube ro Abraham wait renti. Feto to kbe Allah yno riof kʼanu fea!’ Mfe, nnaut feto ma! Allah yatak haberek fraa wefo mamo kube renti ro Abraham wait ye!” ");
INSERT INTO ayz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tna ana mawe, “Soh feto to, nawe kbe amu nno fyi?” ");
INSERT INTO ayz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tna Yohanes yawe, “Rau ro moof to, nno fefo: Awya ro yse ratan ewok to, ait yoo sau yee kʼana ro mse aro fee. Tna raa ro mse boit wana mawat to, ana moo boit aro saim kʼana ro boit marak.” ");
INSERT INTO ayz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Raa ro mkah bo ro pemerintah Roma taro mama mo kʼYohanes ye. Ana weto to, raa ro moo pitis ro namabyoh (pajak) mbam kʼraa. Ana mawe Yohanes baptis ana ye. Tna mtu kʼait mawe, “Guru; amu kbe nno bo bawya?” ");
INSERT INTO ayz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yohanes yawe, “Ati ro noo pitis raa to, noo pitis mabyoh rau ro pemerintah mawe sai to. Norot ma.” ");
INSERT INTO ayz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tna raa sbe ro pemerintah Roma taro mama ye. ⌞Ja ana mno bo ro mkair mai kʼraa afo re raa moo pitis mee kʼana.⌟ Ana mtu kʼYohanes mawe, “Guru fyi, amu kbe nno bo bawya?” Tna ait yawe, “Ntak bo raa ma. Sioh nuun boun kʼraa to ma. Tna ati ro pemerintah maren boren wanu to, nmai tis ma. Nbo pitis wanu sai nhaf mnan.” ");
INSERT INTO ayz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ti reto raa ntoni mtu kʼanya mawe, “Raa retait Mesias ro anu ste metait fe awya?” ");
INSERT INTO ayz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Menohe Yohanes yawe kʼana yawe, “Jõ fi raa ro baptis anu mkah aya sai. Menohe Raa sait ro kbe yama tait, yase toni yiwer jõ. Tna jõ toof mkah bo skur sandal rAit to fee. Ait yama to, meen baptis anu mkah Har ro Tuhan. Tna Ait baptis anu mkah tafoh ye.” ");
INSERT INTO ayz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tna Yohanes yawe, “Ati ro raa sait ygi gandum rait to, ja yoo gandum makan rau yse hayah tna yoo marak rau to, yse hayah ye. Tna gandum makan reto ybu mam gudang sau. Tna marak rau to, kbe yko mam tafoh. Tafoh reto raa mtai mikabuk fee. Kbe Mesias yno bo kʼraa to, mnan anya mfi feto ye.” ");
INSERT INTO ayz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanes ykyas watum roto aro kʼraa ye. Ait ykyas Bokyas ro Moof kʼana feto. ");
INSERT INTO ayz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tna Yohanes ykyas raja Herodes ro ybo rabin reto to ye. Raja Herodes ytak fnya ro yao Filipus rait. Au masom Herodias. Yohanes yari feto, tibyo yastako Herodes yawe yber safo meto. Tna safo beta ro Herodes yber oh to, Yohanes ykyas tna yastako Herodes ye. ");
INSERT INTO ayz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tibyo Herodes kmo Yohanes. Tna yfot ait betruk mam bui mato. (Yno bo reto to, safo sau naut ye oh meto.) ");
INSERT INTO ayz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wore wo Herodes yfot Yohanes ybu mam bui fefares to, Yohanes baptis raa mawat. Tna ait baptis Yesus ye. Ati ro ait baptis Yesus to, Yesus skabuk kri-kri fo, tna ayoh twat. ");
INSERT INTO ayz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tna Har ro Tuhan haberek mnan fi ruu merpati sau. Tna fru mama mroh abyõ kʼAit. Tna raa mari mai sau mbam ayoh mawe, “Nyõ fi akut aJõ ro Jõ thafri. Nyõ fi Jõ thaf mnan!” ");
INSERT INTO ayz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ati reto to, Yesus tait 30 tahun bo feto tna yaban yamo ykah bo ro Tuhan rAit. Wore weto to raa mnaut mawe Yesus tait Yusuf yare. Yusuf tait ku ro Eli. ");
INSERT INTO ayz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli tait ku ro Matat. Tna Matat tait ku ro Lewi. Tna Lewi tait ku ro Malkhi. Tna Malkhi tait ku ro Yanai. Tna Yanai tait ku ro Yusuf. ");
INSERT INTO ayz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Tna Yusuf tait ku ro Matica. Tna Matica tait ku ro Amos. Tna Amos tait ku ro Nahum. Tna Nahum tait ku ro Hesli. Tna Hesli tait ku ro Nagai. ");
INSERT INTO ayz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Tna Nagai tait ku ro Maat. Tna Maat tait ku ro Matica. Tna Matica tait ku ro Simei. Tna Simei tait ku ro Yosekh. Tna Yosekh tait ku ro Yoda. ");
INSERT INTO ayz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Tna Yoda tait ku ro Yohanan. Tna Yohanan tait ku ro Resa. Tna Resa tait ku ro Zerubabel. Tna Zerubabel tait ku ro Sealtiel. Tna Sealtiel tait ku ro Neri. ");
INSERT INTO ayz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Tna Neri tait ku ro Malkhi. Tna Malkhi tait ku ro Adi. Tna Adi tait ku ro Kosam. Tna Kosam tait ku ro Elmadam. Tna Elmadam tait ku ro Er. ");
INSERT INTO ayz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Tna Er tait ku ro Yesua. Tna Yesua tait ku ro Eleazer. Tna Eleazer tait ku ro Yorim. Tna Yorim tait ku ro Matat. Tna Matat tait ku ro Lewi. ");
INSERT INTO ayz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Tna Lewi tait ku ro Simeon. Tna Simeon tait ku ro Yehuda. Tna Yehuda tait ku ro Yusuf. Tna Yusuf tait ku ro Yonam. Tna Yonam tait ku ro Elyakim. ");
INSERT INTO ayz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Tna Elyakim tait ku ro Melea. Tna Melea tait ku ro Mina. Tna Mina tait ku ro Matata. Tna Matata tait ku ro Natan. Tna Natan tait ku ro Daud. ");
INSERT INTO ayz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tna Daud tait ku ro Isai. Tna Isai tait ku ro Obed. Tna Obed tait ku ro Boas. Tna Boas tait ku ro Salmon. Tna Salmon tait ku ro Nahason. ");
INSERT INTO ayz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Tna Nahason tait ku ro Aminadab. Tna Aminadab tait ku ro Admin. Tna Admin tait ku ro Arni. Tna Arni tait ku ro Hezron. Tna Hezron tait ku ro Peres. Tna Peres tait ku ro Yehuda. ");
INSERT INTO ayz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Tna Yehuda tait ku ro Yakub. Tna Yakub tait ku ro Ishak. Tna Ishak tait ku ro Abraham. Tna Abraham tait ku ro Terah. Tna Terah tait ku ro Nahor. ");
INSERT INTO ayz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Tna Nahor tait ku ro Serug. Tna Serug tait ku ro Rehu. Tna Rehu tait ku ro Peleg. Tna Peleg tait ku ro Eber. Tna Eber tait ku ro Salmon. ");
INSERT INTO ayz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Tna Salmon tait ku ro Kenan. Tna Kenan tait ku ro Arpakhsad. Tna Arpakhsad tait ku ro Sem. Tna Sem tait ku ro Nuh. Tna Nuh tait ku ro Lamekh. ");
INSERT INTO ayz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Tna Lamekh tait ku ro Metusalah. Tna Metusalah tait ku ro Henokh. Tna Henokh tait ku ro Yared. Tna Yared tait ku ro Mahalaleel. Tna Mahalaleel tait ku ro Kenan. ");
INSERT INTO ayz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Tna Kenan tait ku ro Enos. Tna Enos tait ku ro Set. Tna Set tait ku ro Adam. Tna Adam tait ku ro Allah yare. ");
INSERT INTO ayz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus raa baptis mam aya ro Yordan to, tna hah ye yamo. Tna Har ro Tuhan mroh mama mbo Yesus matak. Tna Har reto makah Ait mamoʼt yuk ro riamo sau. ");
INSERT INTO ayz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yhau mam teto tna kabes yabi (Iblis) yama yawe sanet besruf Ait. Sanet Ait ti trion 40. Tna wore weto to, Yesus yhau bo yait. Tibyo yhai sre. ");
INSERT INTO ayz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kabes yabi yama sanet Ait yawe, “Soh Nyõ Ku ro Allah yare meto mi, sik nno fraa refo haberek mamo roti re Nyõ nait.” ");
INSERT INTO ayz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Menohe Yesus yisboh kʼait yawe, “Bokom ro Allah mawe, ‘Boit mesait sai au oh mi mno re raa mhau to fee!’” ");
INSERT INTO ayz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tna fo kabes yabi yakah Yesus yaut mam atu mana ro miyõ sau. Tna fooh sai to, ait yerif bangsa ro arin aso beta fo kʼAit. ");
INSERT INTO ayz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tna kabes yabi yawe kʼAit yawe, “Jõ tase tbo bangsa wefo beta. Tna kta wana beta to, bo wojõ ye. Tna jõ tsan bo wefo beta kʼawya sai ro jõ ksoh tait. Nyõ nawe kbe too bo wefo beta tsan kʼNyõ fe mfe a? ");
INSERT INTO ayz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Soh Nyõ naka mte nbaut jõ to, kbe too bo wefo beta tsan kʼNyõ.” ");
INSERT INTO ayz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Menohe Yesus yisboh kabes yabi refi yawe, “Bokom ro Allah mawe yum mawe: ‘Nbaut Tuhan Allah yesait aran, tna bo ro Ait yesait aran yawe to, nbo nno.’” ");
INSERT INTO ayz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tna fo kabes yabi yakah Yesus yamoʼt Yerusalem. Tna yoo Yesus yse yros abyõ mam timanaf Samu Allah ro miyõ toni. Tna yawe kʼYesus yawe, “Soh Nyõ fi Ku ro Allah yare meto mi, sik nitsre Nyõ mbtek namo nai mam tabam mte. ");
INSERT INTO ayz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bokom ro Allah mawe: ‘Kbe Allah ybis malaikat wAit kmot Nyõ. Ana swiõ wea huwya mfot Nyõ abyõ sai. ");
INSERT INTO ayz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ana kbe mfot Nyõ abyõ sai mkah matem wana re naa mai mam fraa fee.’” ");
INSERT INTO ayz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Menohe Yesus yawe, “Bokom ro Allah mawe, ‘Tuhan Allah ro ja anu smot to, sanet Ait ma.’ Ulangan 6:16 Feto ye Jõ hawe kro bo ro nyõ nawe weto be kbe Jõ sanet Allah.” ");
INSERT INTO ayz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kabes yabi sanet sanet Yesus feto mkak tna yamo. Ait yamo tna ste ayõ roto afo re kbe hah ye yama sanet Yesus u. ");
INSERT INTO ayz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus hah ye yamoʼt provinsi ro Galilea. Tna Har ro Tuhan matak rAu mhau msya Ait. Tna raa ro mhau mam rabin reto beta mari Ait yasom. ");
INSERT INTO ayz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ait yamoʼt remo weto aro rau-rau to, yamoʼt samu watum raa ro agama Yahudi. Tna ykyas bo kʼraa mam samu weto. Tna raa weto beta bibi Ait. ");
INSERT INTO ayz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tna Ait yamoʼt Nazaret, remo rAit ye. Ayõ ro Sabat to, ja raa ro agama Yahudi ntmoh. Tna ayõ ro Sabat sau to, Ait yamoʼt samu watum rana mfi ja Ait yno soo oh. Tna Ait yasen yros baca Bokom ro Allah. ");
INSERT INTO ayz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tna raa moo bokom ro tiwya Allah ybis nabi Yesaya ykom to, mee kʼAit ymat. Ait betrat aam reto tna saso far-far sau. Ykai, tna baca yawe: ");
INSERT INTO ayz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tuhan ysok Jõ ybis yawe tamo tkyas Bokyas Moof kʼraa ro masu awe. Feto to yoo Har rAit yse kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tna ybis yawe Jõ tisoh raa ro masu mti to, tno re masu wana to maah ye. Tna raa ro mberasi raa taro sor to, Jõ tno re kbe ana bitsre raa ro ana sikowah weto. Tna tama tkyas tawe, ‘Tuhan Ait siwyan oh yawe yno riof kʼraa.’” ");
INSERT INTO ayz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus baca mkak tna bemut aam reto ye, yee yisia kʼraa retait. Tna Ait hre. Hre tna raa beta masu wana mberoh haberek mmat Ait ye. ");
INSERT INTO ayz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tna Yesus betoo yawe, “Mam ayõ refo fo, bokom far-far wefo mabo rau oh.” ");
INSERT INTO ayz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bokyas rAit moof ati. Tna raa beta mrok ktak mawe, “Ait retait Ku ro Yusuf, fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tna Yesus yawe kʼana yawe, “Kbe anu nkyas bofret refo mai kʼJõ fea! Nwe: ‘Dokter, nesait nisoh tkif Nyõ ai!’ Anu nri he taa Jõ tno bo ro msai mam Kapernaum. Tibyo anu nkyas bofret reto to, nwe Jõ tno mnan anya mfi feto mam remo aJõ feto ye. ");
INSERT INTO ayz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Menohe tkyas kʼanu tawe, ‘Nnaut: Nabi ro Allah ybis yama ykyas bo wAit to, soh yamoʼt remo rait yesait to, ja raa wait hawe mari ait.’ ");
INSERT INTO ayz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nnaut ayõ ro tiwya nabi Elia yhau. Wore weto to, tahun trion tuuf hariyah tna hwyõm mase: Oom aro mais fee mam rabin ro Israel. Tibyo raa beta mhai sre. Semit mawat mhai sre ye. ");
INSERT INTO ayz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Menohe Allah ybis nabi Elia yamo yo kʼsemit ro mhau mam Israel aro fee. Ait yamoʼt rabin roto yhau ysya semit sau aran mam rabin ro Sidon. Au fo mhau mam remo ro Sarfat. ");
INSERT INTO ayz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tna ti wore weto to, raa mawat mafa kusta mam rabin ro Israel. Menohe ait yisoh raa aro ro mhau mam rabin ro Israel fee. Ait yamoʼt tabam ro Siria tna yisoh raa sait ro yasom Naaman. Yisoh ait yesait aran.” ");
INSERT INTO ayz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Raa beta ro siret mam samu watum reto mari bokyas rAit reto tna mrok kmo toni. ");
INSERT INTO ayz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ana beta masen mikyak Yesus frok ybam remo rana. Ana mbo Ait mamoʼt howai rakak ro miyõ sau kene mam wore remo rana. Ana mawe mamo beak Yesus mam howai rakak reto. ");
INSERT INTO ayz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Menohe Yesus yamo fot wai mam raa mawat weto yamo bait. ");
INSERT INTO ayz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tna Yesus yroh yamo sia mam provinsi ro Galilea, yamoʼt remo ro Kapernaum. Ayõ ro raa agama Yahudi ja ntmoh (hari Sabat) to, Ait yamoʼt samu watum rana tna ykyas bo kʼana. ");
INSERT INTO ayz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Allah yno re bokyas rAit to matak toni. Tibyo raa ro mari bokyas rAit reto mrok ktak. ");
INSERT INTO ayz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tna raa ro kabes mbo sait hre mam samu watum reto ye. Tna raa retait ytu fari-fara yawe, ");
INSERT INTO ayz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesus ro nbam Nazaret; Nyõ nama nno fyi kʼamu mefo? Nama sikowah amu ma! Jõ thar Nyõ: Nyõ fi Ait ro Allah Ybis Yama!” ");
INSERT INTO ayz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus yastako kabes reto yawe, “Shait! Nfrok nbam kʼait!” Tna raa beta hre mmat he kabes refo safo toni tna mabyõ raa retait beak mte. Tna kabes reto frok mbam raa retait. Tna raa retait ykai yaaf aro fee. ");
INSERT INTO ayz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Raa beta mrok miskawowo tna mkyas kʼanya mawe, “Bokyas rAit to, msai toni. Ait yatak re ybis kabes frok. Kabes sor mari mai rAit tibyo frok sai!” ");
INSERT INTO ayz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tna raa faram Yesus yasom mam rabin reto beta. ");
INSERT INTO ayz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus sikba samu watum reto tna yamoʼt amah ro Simon. Ati reto to, Simon snyim ro ano au kiyam. Au to, metsu mbe toni. Tna raa soh-soh kʼYesus mawe, “Nama nmat fai au refo!” ");
INSERT INTO ayz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus yamo ymat he fai au refo mjin. Ait skabuk yikyak kiyam reto. Tibyo kiyam rau marak. Tna fai au masen saruk boit mee kʼana mait. ");
INSERT INTO ayz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ati ro ayõ hawer to, raa mawat mama mo kʼYesus. Mama mbo raa wana ro mafa kiyam aro rau-rau. Tna Ait yatem yse kʼana aro sait-sait. Tibyo ana mrok moof. ");
INSERT INTO ayz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tna kabes frok mbam raa mawat ye. Kabes weto mhar mawe Ait tait Mesias. Kabes weto frok to, mtu mawe, “Nyõ fi Ku ro Allah yare!” He Yesus yastako kabes weto yawe, “Shait!” ");
INSERT INTO ayz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nyah msan tna Yesus yasen sikba remo reto. Yamoʼt yuk ro riamo sau. Raa masen saso Ait tna mamo fri Ait u. Ana soh-soh kʼAit mawe “Sikba amu ma!” ");
INSERT INTO ayz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Menohe Ait yawe, “Tamo tkyas Bokyas Moof reto mam remo roto taro ye. Tkyas raa mana ro Allah yamo Raja ybo. Tkyas raa mana reto kʼraa oh mi Allah ybis Jõ tama to.” ");
INSERT INTO ayz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tna Yesus yasen sikba ana weto yamo renti mam provinsi ro Yudea. Yamo ykyas bo mam samu watum makin ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ti sau to, Yesus yros ykyas bo mam maru ro Genesaret. Tna raa mawat myar mama mawe mari bokyas rAit ro ykyas mbam kʼAllah. ");
INSERT INTO ayz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tna Ait ymat wiak trion ewok raa miti mam weto. (Raa ro wiak wana weto hre myon jala wana.) ");
INSERT INTO ayz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wiak sau to Simon rait. Tna Yesus yamo yaut hre mam wiak reto, tna ybis Simon yyum wiak reto kebet baro sai. Tna Yesus hre ykyas bo kʼraa. ");
INSERT INTO ayz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesus ykyas bo mkak tna yawe kʼSimon yawe, “Miin baro namoʼt wore wo uun wono. Tna mbeak jala re nfot syoh aro.” ");
INSERT INTO ayz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon yawe, “Guru; riwai ti ro miyõ refo amu nsafo beak jala saso syoh he nfot aro fee! Menohe Nyõ nbis feto to, jõ te beak jala refo u oh.” ");
INSERT INTO ayz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ana beak jala refo tna fo mkuk jala reto maut tna mmat menohe syoh mawat toni. Tna jala reto maja taro hri. ");
INSERT INTO ayz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tna ana mtu mafoh wana taro mama. Ana mama tna msya ana mkuk jala refo mkah syoh mawat toni, mbeak mam wiak wana weto mato. Tibyo wiak ewok reto matot toni maami wiak hoh. ");
INSERT INTO ayz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon yafoh na weto, sait yasom Yakobus tna sait yasom Yohanes. Ana mbewok to Zebedeus yare. Ana msya Simon-Petrus mmat syoh mawat tibyo mrok ktak. Tna Simon yamo yo kʼYesus yjit yimna. Tna yawe, “Tuhan; sikba jõ namo rof: Jõ fi raa kair!” Tna Yesus yawe kʼSimon yawe, “Waa ma! Maban wore wefo nyõ nfot syoh u fee. Kbe nyõ nfot raa.” ");
INSERT INTO ayz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ana mabo tuuf weto mkuk wiak wana mamoʼt mne. Tna sikba bo wana beta makus masen kro Yesus. ");
INSERT INTO ayz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ti sau Yesus yhau mam remo sau tna ymat raa ro yafa kusta ro mkair-kar toni sait. Raa retait ymat Yesus tna yjit yimna soh-soh kʼAit yawe, “Bobot, soh Nyõ ksoh meto mi, nisoh jõ re kusta refo marak.” ");
INSERT INTO ayz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tna Yesus yatem ybo ait tna yawe, “Jõ ksoh, tawe nyõ mbros oh!” Ayõ reto si fo, kusta reto mrok marak. ");
INSERT INTO ayz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tna Yesus yawe wa kʼait yawe, “Namo to, nkyas bo refo kʼraa ma. Namo nerif narak anyõ kʼimam ro agama Yahudi sait re ait ymat sas nyõ. Nyõ noof u tibyo noo bo nee. Nee kʼimam re ysan kʼAllah mamyot Watum ro Musa ykom yawe. Nno bo weto re kbe raa mhar mawe netsu anyõ to moof u.” ");
INSERT INTO ayz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Menohe Yesus yasom to, raa mkyas renti mam woyõ-woya sai. Tibyo raa myar mama mari bokyas rAit tna soh-soh kʼAit re yisoh ana re kiyam wana marak ye. ");
INSERT INTO ayz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tna mun aro to, Yesus yamo skabuk mam yuk ro mimon. ");
INSERT INTO ayz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ti sau Yesus ykyas bo kʼraa mam samu sau. Tna raa manes ro agama Yahudi baro hre mari ye: Raa ro Farisi msya guruagama ye. Ana mama mbam kota msya remo aro rau-rau mam provinsi ro Galilea, tna mbam kota Yerusalem msya remo roto taro sor mam provinsi ro Yudea. Tuhan yatak rAit yatam Yesus. Feto to Ait yisoh raa ro mafa kiyam. ");
INSERT INTO ayz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tna raa baro mama nkatar ait ro yaa mhai sait mam sese. Tna yafoh wait weto mawe makah raa retait twok mam samu reto mse re Yesus ymat. ");
INSERT INTO ayz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","He raa mawat burut wa Yesus. Feto to ana makah ait maut abyõ ti manaf. Tna ana mitrah ti manaf reto baro mno hroh tna mruk ait mkah sese rait ye. Mruk mam samu mato mam wore wo Yesus yros ysya raa mawat weto susai. ");
INSERT INTO ayz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus ymat ana tna yhar yawe ana smot Ait matak. Tibyo Yesus yawe kʼraa retait yawe, “Tao, iro wonyõ to, Jõ tyon oh.” ");
INSERT INTO ayz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Raa ro Farisi msya guruagama weto mari bo ro Yesus yawe feto tibyo kmo. Tna mnaut mawe, “Bi Ait refi yrok yawe Ait awya, re yawe yyon iro ro raa! Bo ro Ait yawe to berasi Allah! Awya ytai yyon iro? Allah yesait aran sai!” ");
INSERT INTO ayz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Menohe Yesus yhar bo ro ana mnaut weto oh. Tna ytu kʼana yawe, “Fyi re anu nnaut bo weto mam nsrau mato wanu to? ");
INSERT INTO ayz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Soh Jõ tawe kʼait refi tawe, ‘Iro wonyõ to, Jõ tyon oh.’ Bo ro msai fee: Kbe raa mahni bo reto mabo fe mfe a. Menohe tawe, ‘Nasen namo oh!’ Tawe feto afo re kbe raa mmat bo reto mabo. Mmat tna mhar mawe Jõ ttai tno bo ewok ye to. Ewok ye mnan-nan kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna bo ro kbe Jõ tno fo, Jõ tno re kbe anu nhar Jõ tatak tyon iro raa mam tabam refo.” Tna Yesus yawe kʼAit ro yaa mhai retait yawe, “Nasen, tubat sese anyõ, tna nasom namo bonyõ oh!” ");
INSERT INTO ayz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tna raa beta mmat he raa retait yasen yros fooh. Tna ait tubat sese rait yasom yamo. Yamo bait ybaut Allah yamo. ");
INSERT INTO ayz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ana beta miskawowo tna mbaut Allah. Ana mawe kʼanya mawe, “Ayõ refo anu bmat bo msai ro mase toni!” ");
INSERT INTO ayz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesus frok ybam amah reto yamo. Yamo tna ymat raa ro ja yoo namabyoh (pajak) yee kʼpemerintah ro Roma sait. Yasom Lewi. Bi ait hre mam kantor ro namabyoh rait. Tna Yesus ytu kʼait yawe, “Nama kro Jõ bmo!” ");
INSERT INTO ayz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi yari feto, tibyo ait yasen sikba bo beta, yamo kro Yesus mamo. ");
INSERT INTO ayz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ti sau fo, Lewi yakyõ bokyõ sau re yafoh wait mama fri anya msya Yesus. Tna raa msis mama hre mait boit su. Lewi yafoh weto taro mamo raa ro moo namabyoh ye. ");
INSERT INTO ayz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Raa Farisi ro mamo guruagama msya raa Farisi roto mmat he Yesus ysya raa wAit makyõ bokyõ su msya raa weto. Tna ana santri bo mawe kʼYesus kuber wAit (murid-murid) mawe, “Fyi re anu hre niit boit su nsya raa ro moo namabyoh tna msya raa ro ja mno iro bo weto?” ");
INSERT INTO ayz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tna Yesus yawe, “Raa ro metsu moof to, ja mamo saso dokter fee. Ja raa ro kiyam oh mi mamo saso dokter to. ");
INSERT INTO ayz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jõ tama ttu raa ro mhaf moof to fee. Tama fo ttu raa ro mno iro afo re kbe ana mashana.” ");
INSERT INTO ayz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Raa ro Farisi msya raa taro mawe kʼYesus mawe, “Kuber ro Yohanes msya kuber raa ro Farisi ja mhau bo mait ye tna skabuk ye. Menohe kuber woNyõ ja mhau bo mait to fee.” ");
INSERT INTO ayz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus ykyas bofret kʼana yawe, “Ati ro raa sait ymen fnya to, ja raa mno bo bawya? Anu nwe kʼait yafoh wait ro mama to, nwe ana mhau bo ro mait sai a? Mfe! Ana makyõ bokyõ fea! ");
INSERT INTO ayz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ana makyõ bokyõ wia. Tna fo raa moo ait makah mamo. Ati reto to, kbe mafoh wana sraujin tibyo mhau bo ro mait. Kuber woJõ mfi feto ye. Jõ thau tsya ana fares fo, ana sraujin fee. Menohe ati ro Jõ sikba ana to, kbe ana sraujin tibyo mhau bo ro mait ye.” ");
INSERT INTO ayz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tna Yesus ykyas bofret sau naut kʼana yawe, “Mfi bo ratan matah ro hri-hra sau. Ja fnya moo ratan ro ntfia tna ktan fee. Au moo ratan mabuf ro ntfia reto tna mtin kait mkah ratan rau ro matah fe mfe a? Soh au mno feto to, kbe mno ratan rau ro ntfia reto mkair. Tna raa mmat mawe ratan mabuf ro moof msya ro matah to, mmat mawe ewok reto mnan anya fee. ");
INSERT INTO ayz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Feto ye, Ja raa mror anggur maya ro tna mam baah marak ro matah fee. Anggur maya reto mno baah marak reto matu mbua. Tna kbe anggur maya reto maus miyi mroh mamo mkak. ");
INSERT INTO ayz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anggur maya ro tna to, ja raa moo mror mam baah marak ro tna sai. ");
INSERT INTO ayz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Raa ro mhar anggur maya to, ana nksoh rana ro matah to mata. Tna ana hawe mata anggur maya ro tna.” ");
INSERT INTO ayz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayõ ro raa ntmoh sau to, Yesus ysya kuber wAit mamo mfrit iti mam armato ro gandum sau. Kuber wAit mhai sre, tibyo mryoh gandum make baro. Ana msirori gandum weto mam matem wana tna mait. ");
INSERT INTO ayz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Menohe raa ro Farisi baro mmat ana tna mtu kʼYesus mawe, “Anu nryoh gandum make mam ayõ ro raa wanu ntmoh to. Anu nno fyi meto? Nno bo reto to, anu niwer Watum ro agama ranu oh meto!” ");
INSERT INTO ayz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tna Yesus yawe, “Anu nsorni Bokom ro Allah? Bokom reto mkyas bo ro tiwya raja Daud yno: Tiwya ait ysya raa wait mhai awyah. ");
INSERT INTO ayz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tna ait twok mam Samu ro Allah mato. Tna yoo roti ro raa msan kʼAllah. Roti reto mbau. Menohe ait yoo yait. Roti reto ja imam na mesait aran mait. Tna ait yoo tna yee kʼraa wait mait ye.” ");
INSERT INTO ayz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tna Yesus yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ tatak tbo ayõ ro raa ntmoh to ye.” ");
INSERT INTO ayz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ayõ ro raa ntmoh roto sau to, Yesus yamo ykyas bo mam samu watum ro Yahudi. Tna raa ro yatem ati mhai sait huwya mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tna guruagama na msya raa ro Farisi baro huwya mam beto ye. Ana mros mmat rof bo ro Yesus yno. Tna ana saim bo mawe soh Yesus yisoh raa mam ayõ ro raa ntmoh to, kbe ana maun baun kʼAit mawe Ait yiwer Watum ro Musa oh meto. ");
INSERT INTO ayz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Menohe Yesus yhar bonaut wana wia oh. Tna yawe kʼait ro yatem mhai retait yawe, “Nasen, nama nros susai mam wefo!” Tna raa retait yasen yama yros. ");
INSERT INTO ayz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tna Yesus ytu yawe, “Ja Watum ro agama ranu mawe anu bno bo bawya mam ayõ ro raa ntmoh? Ja bno bo ro moof, soh mfe bno bo ro mkair a? Bisoh raa fe sikowah raa anya a?” ");
INSERT INTO ayz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus yros yasu ymat ana beta yur. Tna yawe kʼait ro yatem mhai retait yawe, “Betrot natem anyõ oh!” Raa retait betrot yatem rait. Tna yatem mrok moof. ");
INSERT INTO ayz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Guru Agama na msya raa ro Farisi to, ana kmo toni. Tna ana saim bo ro mkair kbe ana mno mai kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti sau to Yesus yamo yaut mam faut sau tna yawe yamo skabuk. Tna hre skabuk Allah mam ti ro miyõ reto ");
INSERT INTO ayz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","mamo snok mam niah msan. Tna Ait ytu kuber wAit beta mama. Tna Ait ysok ana mabo trion 12 aran kbe ana mamo raabis (rasul) wAit. ");
INSERT INTO ayz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ana weto sait yasom Simon (ro kbe Yesus ytu yawe yasom Petrus ye), Andreas ro Simon yao, Yakobus ysya yao Yohanes, Filipus, Bartolomeus, ");
INSERT INTO ayz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Yakobus ro Alfeus yare, Simon (ro raa mtu mawe Zelot), ");
INSERT INTO ayz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas ro Yakobus yare, tna Yudas Iskariot ro kbe hren serek Yesus. ");
INSERT INTO ayz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus ysya raabis wAit mroh mbam faut reto. Tna Ait yamo yros mam tabam sneh. Tna raa mawat ro ja nkro Ait to, mama mawe mari bokyas rAit ye. Tna raa msis-sas mbam jaro-jaro sor mama ye: Raa mbam provinsi ro Yudea, mbam kota ro Yerusalem ye, tna raa ro mbam kota ro Tirus msya kota ro Sidon ye. Kota ewok refo mhau mam sawan maam ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Taro mama mawe mari bokyas ro Yesus. Tna ana taro ro kiyam mama mawe Yesus yisoh ana re kiyam rana marak ye. Ana ro kabes mbo to, mama tna Yesus yikyak kabes mbam kʼana weto ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesus yatak rAit yisoh ana beta moof. Tibyo raa mawat tomer mama miir Ait. ");
INSERT INTO ayz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus ymat kuber wAit tna yawe, “Anu ro mfo refo nsu awe to: Anu kbe nhau simaut mase. Anu oh mi raa mana ro Allah yamo Raja ybo. ");
INSERT INTO ayz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Anu ro mfo refo nhai sre to: Anu kbe nhau simaut mase. Meen anu nhaf matu tna nhai sre u fee. Anu ro mfo refo nwia to: Anu kbe nhau simaut mase. Meen anu nsen nsah. ");
INSERT INTO ayz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Tiwya tinyi Allah ybis nabi wAit mama mkyas bo wAit. Tna raa mno bo mkair mai kʼana. Menohe Allah siwyan boren ro mase meen yoo yaren nabi wAit weto mam sawro rAit. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna soh anu smot Jõ, tibyo kbe raa mno bo mkair mai kʼanu to: Anu kbe nhau simaut mase. Soh raa knait anu, tna raa mikyak anu, tna raa mamus mawe sie anu to, simaut mase. Meen Allah yoo boren ro mase mam sawro rAit yaren anu fo ye. Feto to nyok-yok, tna simaut mase ye oh.” ");
INSERT INTO ayz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tna Yesus yawe, “Anu raa ro bobot to: Mfo refo anu nhau moof to. Menohe bo ro mkair-kar kbe mama mai kʼanu. Tibyo kbe meen anu nhau noof fee. ");
INSERT INTO ayz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Anu ro mfo refo nhaf matu tna nhai sre fee to: Bo ro mkair-kar kbe mama mai kʼanu. Tibyo kbe meen nhaf matu fee, anu nhai sre. Anu ro mfo refo nsah to: Bo ro mkair-kar kbe mai kʼanu ye. Meen anu nwia tna sraujin toni ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tiwya tinyi to, raa baro sioh mawe ana to, nabi ro Allah ybis mama mkyas bo wAit. He mfe, sioh meto. Menohe anu hohos na makin tawyõ raa ro sioh raa weto. Feto to, soh raa beta tawyõ anu mfo refo to, kbe meen anu nkai bo ro mkair-kar.” ");
INSERT INTO ayz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Tna Yesus yawe, “Anu ro nri bokyas ro Jõ tkyas fo, tawe kʼanu tawe: ‘Natmof raa ro mamo byoh kʼanu. Tna nno bo moof kʼraa ro knait anu to ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Raa ro mamus anu to, nno bo ro moof kʼana sai. Tna raa ro mno bo mkair mai kʼanu to, skabuk ana ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Soh raa miban natni ranu to, noo natni ro ati jaro nee kʼana miban ye. Soh raa mtak ratan anyõ sau to, tna mawe mtak ratan roto taro ye to, nno wa ma. Noo ratan reto nee ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Awya sai mama mayoh bo kʼanu to, noo nee sai. Tna soh raa msyõf bo wanu to, nwe ana misya bo weto ma. ");
INSERT INTO ayz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bo ro anu ksoh nwe raa mno kʼanu to, nno mfi feto kʼana ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Soh anu natmof raa ro matmof anu sai aran to, kbe Allah ymat tibyo yoo boren yaren anu aro fee. Raa ro mno iro sai ja matmof raa ro matmof ana mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tna soh anu nno bo moof kʼraa ro ja mno bo moof kʼanu to, kbe Allah ymat tibyo yoo boren yaren anu aro fee. Raa ro mno iro sai ja mno bo moof kʼraa ro mno bo moof kʼana mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tna soh anu noo bo nee kʼraa ro mayoh bo kʼanu to, tna anu nhar nwe kbe ana moo bo aro mee kʼanu riryõn to, boren ro meen Allah yaren kʼanu to bo bawya? Raa ro mno iro sai ja moo bo mee kʼraa ro ana mnaut mawe kbe misya bo mnan anya feto ye.’ ");
INSERT INTO ayz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Menohe Jõ tawe kʼanu tawe, ‘Natmof raa ro mamo byoh kʼanu sai. Tna nno bo moof kʼana sai. Noo bo nee kʼraa ro mayoh bo kʼanu to. Ninaut nwe kbe ana misya bo aro kʼanu riryõn to ma. Soh anu nno feto to, meen boren ro Allah yaren kʼanu to mase toni. Tna kbe anu nmo ku ro Allah wAit. Ait fi Raa ro yase. Tna Ait yhaf ase, ja yno bo moof kʼraa ro wase bo yawe asik mase kʼAit. Tna Allah yno bo moof kʼraa ro ja mno bo mkair ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tna tawe natmof raa mnan fi Bja ranu ja yatmof raa feto ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nuun boun kʼraa ma. Tna meen raa maun boun kʼanu feto ye fee. Nmit srah kʼraa to ma. Tna meen raa mmit srah kʼanu feto ye fee. Tna soh raa mno bo ro mkair mai kʼanu to, kmo ana ma. Feto tna soh anu nno bo ro mkair mai kʼraa to, kbe ana kmo anu fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Noo bo nee kʼraa. Tna meen raa moo bo mee kʼanu ye. Kbe moo bo mninon mee kʼanu. Soh anu noo bo mase nee kʼraa to, meen ana moo bo mase mee kʼanu ye. Tna soh anu noo bo kebet sai nee kʼraa to, meen ana moo bo kebet sai mee kʼanu mfi feto ye.’” ");
INSERT INTO ayz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tna Yesus ykyas bofret kʼana yawe, “Raa ro yasu mboh sait ja yamo yatim tna ybo raa yasu mboh anya sait fee. Soh mamo su feto to, kbe ana mbewok mbtek mawe mam kayah mato ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kuber sait ja yase yiwer guru rait fee. Guru rait kbe yber ait mkak wia to. Tna fo ait yhar bo mnan anya yfi guru rait ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Soh knuf ro maboh sau mhau kʼnyõ nasu mato to, fyi re nyõ ksoh nmat knuf maku ro mhau kʼnafoh anyõ yasu mato rait? Menohe nyõ nwase knuf sau mhau kʼnyõ nasu anu ye. ");
INSERT INTO ayz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fyi re nyõ nawe kʼnafoh anyõ nwe, ‘Nama, jõ tmen knuf ro mhau kʼnyõ nasu mato to.’ Ja nyõ nesait nmat knuf ro mhau kʼnyõ nasu mato to fee. Sioh nyõ ma! Nmen knuf maboh ro mhau kʼnyõ nasu to wia. Tna fo nyõ nasu nmat bo kaket re kbe nmen knuf maku ro mhau kʼnafoh anyõ yasu rait to.” ");
INSERT INTO ayz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Tna Yesus ykyas yawe, “Ara ro mara moof to, kbe make rau to mkair fee. Tna ara ro mara mkair to, kbe make rau to moof fee. ");
INSERT INTO ayz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ara ro mros sau. Mfi bo raa wase ara reto masom to, kbe yamo ymat make rau. Tna yhar. Ja raa saso kake make mbam abumun mara to fee. Tna saso anggur make mbam hyoh to fee. ");
INSERT INTO ayz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tna awya ro yhaf moof to, ja bo ro moof mbam yhaf mato rait frok. Tibyo bo ro yno to moof. Tna bo ro ykyas to moof ye. Tna awya ro yhaf mkair to, ja bo ro mkair mbam yhaf mato rait frok ye. Ait yhaf mato mkair sai. Tibyo ja yno bo ro mkair tna ykyas bo ro mkair ye.” ");
INSERT INTO ayz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Anu ja ntu Jõ nwe Jõ Tuhan ranu, menohe anu nri bo ro Jõ tawe kʼanu to fee. ");
INSERT INTO ayz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Awya ro yama yo kʼJõ tna yari bo ro Jõ tkyas re ybo yno to, ait ynan fi raa ro yhar bo. ");
INSERT INTO ayz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ait ro yhar bo to, soh ait retait sgi amah to, ait yno pondasi wia matak kaket. Yabah kayah to miyõ mamo snok mam fraa, tna yno pondasi abyõ mam fraa reto. Tna fo ait sgi amah rait. Sgi mkak tna oom mais tibyo imabo mama. Menohe pondasi rau reto to, raa sgi abyõ mam fraa tibyo amah reto mros matak, matu fee. ");
INSERT INTO ayz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Raa taro mari bo ro Jõ tkyas menohe ana mbo mno fee. Ana weto mfi ait ro sgi amah rait tna yse pondasi wia mte fee. Ait retait sgi mkak tna oom mais tna imabo mama mayõ. Tibyo amah rait reto matu fooh tna sasi-sasa.” ");
INSERT INTO ayz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Raa makin mari Yesus ykyas bo weto beta to, mkak. Tna fo yasen yamo snok mam remo ro Kapernaum. ");
INSERT INTO ayz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tna raa sbe ro yase sait yhau mam Kapernaum. Ait retait yamo aban mana ro ja ybo raa sbe ro Roma majin sau. Ti reto to, sryan ro ja yisoh bo rait sait kiyam, kene wo yhai oh. Bi ait hasu sryan rait retait. ");
INSERT INTO ayz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ati ro aban mana retait yari raa mkyas Yesus, ait ytu raa manes ro agama Yahudi baro mama. Tna ybis ana yawe, “Nmo saso Yesus. Tna nwe Ait yama yisoh sryan ajõ ye!” ");
INSERT INTO ayz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Raa weto mari feto tna mamo mo kʼYesus. Ana soh-soh kʼAit mawe, “Aban mana retait tait, raa ro yhaf moof toni. Tna mfo refo sryan rait kiyam msai. Tna bi ait yawe Nyõ namo nisoh ait. ");
INSERT INTO ayz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Anu, raa mana ro Yahudi to, Ait hasu. Bi ait yatmof anu. Tii ait yoo pitis tna re sgi samu watum ranu to.” ");
INSERT INTO ayz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus yari feto tna yasen ysya ana mamo. Ana mamo kene mam samu ro aban mana rait to, tna bi ait yafoh na baro mama fri ana. Yafoh wait weto mawe kʼYesus mawe, “Aban mana retait yawe Nyõ namo ma! Mbau a. Yawe ait fi raa ro ati fee tna Nyõ fi raa ro nase toni. Feto to yawe Nyõ namo twok mam amah rait to ma. ");
INSERT INTO ayz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Feto oh mi aban mana retait yawe, ‘Jõ takah tabo tama to kʼNyõ fee.’ Yawe, ‘Nyõ nhau tore teto sai tna nawe sai. Nawe sai afo re sryan ajõ retait kiyam mrok marak.’ ");
INSERT INTO ayz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aban mana retait yawe, ‘Jõ thar tawe raa kinyah ja mari bo kʼraa mase ro mbo ana. Jõ tesait ja tari bobis ro mbam kʼraa ro mase woJõ ye. Tna raa sbe ro kinyah ja mari bo ro jõ tawe ye. Soh jõ tbis bo kʼraa sbe sait, ait kbe yari tna yasen yamo tu oh. Tna soh jõ ttu raa sbe taro sait tawe yama to, kbe ait yasen yama ye oh. Tna soh jõ tbis bo kʼsryan ajõ tawe, “Nno bo reto.” Kbe ait yari ybo yno tu oh! Tna Nyõ to nase toni niwrek jõ ye. Soh Nyõ nawe kiyam marak to, kiyam reto mari tibyo marak tu oh.’” ");
INSERT INTO ayz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus yari bokyas reto tna yrok ktak. Ait siur tna ymat raa mawat ro kro Ait yawe, “Ja raa ro mhau mam tabam ro Israel fo, bosmot wana matak fee. Menohe ait refi bosmot rait matak toni!” ");
INSERT INTO ayz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tna raa manes ro riwai aban mana rana ybis weto hah mamoʼt amah rait. Ana ntwok mamoʼt amah mato tna mmat he sryan retait kiyam rait marak oh tna yrok yoof oh. ");
INSERT INTO ayz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tna Yesus yasen yamoʼt remo sau ro masom Nain. Kuber wAit msya raa mawat taro mamo su kro Ait. ");
INSERT INTO ayz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ana mamo snok mam remo makit reto si fo tna raa ngkatar hai sau frok mama. Hai reto fai ro semit sau, ku sme rau sait aran yum sai. Raa ro remo reto mawat msya fai au ro semit reto mtar hai reto. ");
INSERT INTO ayz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tuhan Yesus ymat fai au ro semit reto tna yatmof au. Ait sraujin toni ye tna yawe, “Tme, nawia ma.” ");
INSERT INTO ayz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ait yamo kait yo kʼana tna ybo sese reto. Tibyo raa ro ngkatar sese reto mros. Tna Yesus yawe, “Akut, nasen oh!” ");
INSERT INTO ayz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mere retait yrok yasen hre ykyas bo. Tna Yesus ysan ait kʼyme. ");
INSERT INTO ayz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Raa beta mmat feto tna waa, tetet. Tibyo ana mbaut Allah mawe, “Allah ybis Nabi ro yase sait frok yama yo kʼanu oh! Allah yama ybet raa wAit oh!” ");
INSERT INTO ayz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bo msai ro Ait yno reto to, raa mkyas faram mamo snok mam provinsi ro Yudea beta msya rabin roto taro ye. ");
INSERT INTO ayz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kuber ro Yohanes mari bokyas reto ye tna mamo mkyas bo weto beta kʼYohanes. ");
INSERT INTO ayz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tna Yohanes ybis ana mabo ewok yawe, “Nmo no kʼYesus, tna ntu bo kʼAit nwe, ‘Nyõ fi Mesias ro tiwya Allah ysi yawe kbe yama oh mefi, fe mfe a? Kbe amu ne ste raa roto sait hayah a?’” ");
INSERT INTO ayz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kuber mabo ewok reto mamo mo kʼYesus tna mawe, “Yohanes ro ja baptis raa tait ybis amu nma fo. Ybis amu nma ntu bo kʼNyõ nwe, ‘Nyõ fi Mesias ro tiwya Allah ysi yawe kbe yama oh mefi, fe mfe a? Kbe amu ne ste raa roto sait hayah a?’” ");
INSERT INTO ayz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mam ati reto ana mmat Yesus yisoh raa ro kiyam mawat, tna yikyak kabes mawat, tna yatmof raa ro masu mboh tna yisoh ana re mmat bo. ");
INSERT INTO ayz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tna Ait yawe kʼana mbewok yawe, “Hah ne nmo no kʼYohanes tna nkyas bo ro anu nmat ye tna nri ye: Nwe, ‘Raa ro masu mboh to, mfo refo ana mmat bo. Raa ro maa mhai to, mfo refo ana masen mamo. Raa ro mafa kusta to, mfo refo ana mrok moof. Raa ro mimara mtuk to, mfo refo ana mari bo oh. Raa ro mhai to, Ait yawe sai to, tibyo ana mrok masen. Tna raa ro masu awe to, mari Bokyas Moof ro mbam kʼAllah.’ ");
INSERT INTO ayz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tawe kbe Tuhan yno bo ro moof kʼraa ro mmat bo ro Jõ tno tna beroh smot Jõ fares to.” ");
INSERT INTO ayz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kuber ro Yohanes wait hah mamo, tna Yesus yasen ykyas Yohanes kʼraa msis-sas weto. Ykyas yawe, “Tiwya anu nmoʼt yuk ro riamo nwe nmat Yohanes. Nmo to, anu nnaut nwe nmat bo bawya meto? Anu nmo nmat nkrum ro foos mfi matu wewe mamo-me to a? Mfe, Yohanes tait raa ro yros yatak. Ait raa ro sneh sai fee. ");
INSERT INTO ayz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tiwya anu nmo nmat ait re nmat bawya? Anu nmo nmat bobot sait ro yyum ratan ro sne rauk? Mfe ye, bobot ro myum ratan ro moof to, ja mhau bana mam amah ro moof sai. ");
INSERT INTO ayz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tawe kʼanu u tawe, anu nmo saso bawya mam tabam ro riamo reto to? Anu nmo saso nabi ro Allah ybis yama rauk? Ae! Yohanes tait nabi ro Allah ybis sait yama. Yama to, yase yiwer nabi na roto ye. ");
INSERT INTO ayz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohanes retait oh mi tiwya Allah ykyas mam Bokom rAit sau. Bokom reto mawe, ‘Meen Jõ tbis raa sait yama ykyas bo woJõ yatim wia tna Nyõ nrof. Kbe ait siwyan iso kʼNyõ.’” ");
INSERT INTO ayz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tna Yesus yawe, “Nnaut oh: Raa ro tabam refo aro mase miwrek Yohanes fee. Menohe mam raa mana ro Allah yamo Raja ybo to, raa ro kinyah to, ana mase miwer Yohanes ye.” ");
INSERT INTO ayz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Raa makin ro mros mari Yesus ykyas bo to, ana taro raa ro moo namabyoh (pajak) ye. Ana weto tiwya mari bokyas ro Yohanes ykyas ye. Tna Yohanes baptis ana ye. Tibyo ana weto waa Allah tna mari bo ro Yesus yawe. Mawe, “Esre.” ");
INSERT INTO ayz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Menohe raa ro Farisi msya guruagama ro Yahudi mawe Yohanes baptis ana ma. Tibyo ana hawe bo mari watum mbam Allah ro Yesus ykyas reto ye. ");
INSERT INTO ayz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tna Yesus yawe, “Raa ro mhau mfo refo to, mfi awya? Jõ fret bo tawe anu fo raa ro haberek nfi kukek: Anu nnan kukek ro hre mam pasar msom. Tna ana baro mawe kʼanya mawe, ");
INSERT INTO ayz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","‘Riwai anu sioh bsom-sam mnan fi anu bkyõ bokyõ: Amu nfi oor, tna nji howes ye, afo re kbe anu bsyoh, menohe anu nsyoh fee! Tna fo anu sioh bsom bfi raa ro mhai, menohe anu taro hawe bo nwia hai reto! Nsom nno fyi!’” ");
INSERT INTO ayz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tna Yesus yawe, “Tiwya Yohanes ro ja baptis raa yama. Anu nmat ait tibyo nkyas nwe, ‘Ait yhau bo yait tna yata anggur maya fee. Ait kabes mama mbo.’ ");
INSERT INTO ayz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tna Jõ fi, 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ tama to, tfi Yohanes fee. Jõ tama to, ja thau bo tait fee. Tna tata anggur maya ye. Menohe anu nwe kair Jõ nwe, ‘Ait retait yait boit yasmamo! Ait retait raa ro ja yata anggur maya bisir yoyo! Tna yafoh wAit to, raa ro ja mno iro msya raa ro ja moo namabyoh mee kʼpemerintah bo ye!’ ");
INSERT INTO ayz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Menohe Jõ tawe kʼanu tawe, bo moof ro Yohanes ysya Jõ nno to, merif kʼanu mawe Allah oh mi ybis amu nbewok nma to.” ");
INSERT INTO ayz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bi ro Farisi sait yasom Simon. Ait ymen Yesus yamo yait bo mam amah rait. Tna Yesus yamo hre yait boit ysya ait su. ");
INSERT INTO ayz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Menohe fai ro ja mno iro sau mhau mam remo reto ye. Au mari he Yesus yamo yait boit su ysya Simon. Tibyo fai au masen moo minyak wangi kusia sau ro au mse to, moo tna makah mamoʼt amah reto. ");
INSERT INTO ayz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Au mros manwaruk mam ati ro Yesus kbor tna mawia sut-sut. Mukan rau to mbtek mam Yesus yaa tna au skur mana mawyan rau moo ngkaru Ait yaa ye. Tna au maka hana Yesus yaa tna moo minyak wangi ro au mbo to, maas Ait yaa ye. ");
INSERT INTO ayz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tna Simon ymat sas bo ro au mno feto. Tibyo ait ynaut bait yawe, “Soh Ait refi nabi sait ro Allah ybis yama feto to, kbe Ait yhar yawe fai au ro mbo Ait reto ja mno iro.” ");
INSERT INTO ayz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tna Yesus yawe kʼbi ait, yawe, “Jõ tawe tkyas bo baro kʼnyõ.” Tna Simon yawe, “Guru; nkyas oh.” ");
INSERT INTO ayz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus yawe, “Mfi bo raa mabo ewok mamo mhe pitis kʼbi sait. Tna ait sait yhe pitis 500 dinar. Tna ait sait yhe 50 dinar. ");
INSERT INTO ayz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Snyi firwas snyi tna raa mbewok reto mtai misya pitis reto fee. Tna bi ro yoo pitis wait yee kʼana to yawe, ‘Pitis reto mhau oh.’” Tna Yesus ytu bo kʼSimon yawe, “Nnaut anyõ fyi? Raa mabo ewok reto to: Awya ro mi ksoh bi ait retait toni?” ");
INSERT INTO ayz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon yawe si yawe, “Tnaut tawe ait ro yhe pitis mase to ksoh bi ait miwer.” Tna Yesus yawe, “Ae, bokyas ro nyõ nkyas reto mabo oh.” ");
INSERT INTO ayz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ait haberek ymat fai au reto tna yawe kʼSimon yawe, “Nmat fai au reto. Riwai Jõ twok mam amah anyõ to, nyõ noo aya aro nee kʼJõ tyon taa fee. Menohe fai au mesait myon Jõ taa mkah mukan tna ngkaru mkah mana mawyan rau ye. ");
INSERT INTO ayz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tna nyõ aro hana Jõ fee. Menohe maban riwai Jõ twok si hre mam befo to, au hana Jõ taa to mswior fee. ");
INSERT INTO ayz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nyõ aro naas minyak mam Jõ tana fee. Menohe fai refo maas minyak wangi mam Jõ taa aJõ. ");
INSERT INTO ayz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Feto to Jõ tawe kʼnyõ tawe, ‘Fai au refo mhafri Jõ. Feto tibyo: Iro mawat ro au mno to, Jõ tyon beta oh. Menohe awya ro yno iro kebet sai to, tna raa yyon to, kbe ait ksoh raa ro yyon retait kebet sai.’” ");
INSERT INTO ayz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tna Yesus yawe kʼfai au refo yawe, “Iro wonyõ, Jõ tyon oh.” ");
INSERT INTO ayz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tna ana ro hre mait bo su msya Ait to mtu kʼanya mawe, “Ait fi awya oh mi yawe yyon iro raa anya to?” ");
INSERT INTO ayz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tna Ait yawe kʼfai au yawe, “Nyõ smot Jõ tibyo tawe riof kʼnyõ oh. Feto namo oh.” ");
INSERT INTO ayz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tna Yesus yasen yamoʼt kota msya remo roto taro sor. Yamo ykyas Bokyas ro Moof: Ykyas raa mana ro Allah yamo Raja ybo. Tna kuber wAit mabo 12 weto msya Ait mamo ye. ");
INSERT INTO ayz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tna fnya baro kro Ait mamo ye. Tiwya ana weto baro kiyam tna Yesus yisoh ana moof. Tna fnya weto taro to tii kabes mbo. Tna Ait yisoh ana moof ye. Sau masom Maria Magdalena. Tii Yesus yikyak kabes mabo ngkrema ro mbo au to, frok mamo. ");
INSERT INTO ayz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ana weto sau masom Yohana. (Au fo bi Khuza yfain. Ait yamo pegawai ro raja Herodes.) Tna sau masom Susana. Tna fnya roto taro naut mros mban Yesus ysya kuber wAit mam tis ye. ");
INSERT INTO ayz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Raa mbam remo tyo-teya sai myar mama mo kʼYesus. Raa mawat mama tna Ait ykyas bofret sau yawe: ");
INSERT INTO ayz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Raa sait yno armato rait sau. Tna ait yamo furere bobat manaf. Ait furere bo to, bo manaf taro mbtek mam iso. Tibyo bo manaf weto to, taro raa mber makus. Tna taro to, ruu mama mame mkak. ");
INSERT INTO ayz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tna bo manaf taro to, mbtek mam fraa abyõ. Bobat weto mo maut fooh. Menohe tabam ro mka mamos aro fee. Tibyo mtis rau samer tna mata hroyoh. ");
INSERT INTO ayz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tna taro naut btek mam wore hyoh muuf ye. Tna hyoh muuf weto mo betru kait. ");
INSERT INTO ayz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tna taro mbtek mam tabam ro mamos. Tna mo maut. Tibyo make sarer toni: Bo manaf sau-sau to, make rau trion 100 bo feto.” Yesus ykyas bofret reto mkak tna yawe kʼana yawe, “Anu ro nri bokyas reto oh to, nnaut kaket!” ");
INSERT INTO ayz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kuber wAit mtu mawe, “Bawya oh mi nyõ nkyas bofret reto to? Sik betoo maja rau.” ");
INSERT INTO ayz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tna Yesus yawe, “Raa mana ro Allah yamo Raja ybo to, maja wau baro to, raa wase fares. Maja wau weto to, Allah ksoh re anu nsrau nnaut kaket. Menohe raa taro to, ja Jõ tkyas bofret kʼana sai. ‘Raa kbe mmat sas bo refo. Ana mmat sas menohe wase bo reto fares. Ana kbe mari bo refo. Ana mari, menohe srau fee ye.’” ");
INSERT INTO ayz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tna Yesus betoo bofret reto kʼana yawe, “Bo manaf reto to, Bokyas ro Allah oh meto. ");
INSERT INTO ayz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bo manaf ro mbtek mam iso to, mkyas mawe raa ro mama mari Bokyas ro Allah. Mari menohe kabes yabi (Iblis) yama tna safto bokyas mbam kʼana mhaf wana. Tibyo ana smot Allah fee. Feto tibyo ana mkai riof ro mase fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bo manaf ro mbtek mam fraa abyõ to, mkyas mawe raa ro mama ksoh mari Bokyas ro Allah. Menohe Bokyas reto ana moo mse mhau mam mhaf mato wana waor sai. Ana mbo matak fee. Bo ro samyoh mama mai kʼana to, ana mbtek mawe, tna smot Tuhan u fee. ");
INSERT INTO ayz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bo manaf ro mbtek mam wore hyoh muuf to, mkyas raa ro mari Bokyas ro Allah ye. Menohe ana mhau to, mnaut yyi. Tna ana mnaut bosatoh ro moof mam tabam refo sai. Tna ana nksoh mhau moof bana mam tabam refo sai. Bo weto moo ana mhaf re ana mnaut Bokyas ro Allah fee. Tibyo bosmot wana matak fee. Ana tufrok make ro maku sai, tna bo make wana weto manes fee. ");
INSERT INTO ayz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bo manaf ro mbtek mam tabam ro mamos to, mkyas mawe raa ro mhaf reo mari Bokyas ro Allah. Mari tna mbo mse kaket mam mhaf mato wana. Tibyo ana weto kbe mberoh mros matak, tna tufrok make ro moof.” ");
INSERT INTO ayz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesus yawe, “Ja raa mbet tafoh (pelita) afo re ntara raa ro twok mam amah mato. Raa moo mse mte tna moo bo burut wa fee. Tna mmyõt wai mam ambar ro mjin mte to fee ye. Menohe tafoh reto to, ja raa hero abyõ afo re kbe kek ntara tna raa ro mama twok mam amah mato reto mmat. ");
INSERT INTO ayz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bo bawya ro raa mmyõt to, meen raa masbrer. Tna bo bawya raa mkyas kmun-kmun to, meen raa beta mari. ");
INSERT INTO ayz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Reto oh mi tawe nri tna nnaut bokyas aJõ kaket! Awya ro yari tna ybo yno to, kbe Allah yno re ait retait yasu maah. Menohe awya ro yari tna hawe yse mam yhaf kaket to, kbe Allah yno re bohar rait to mabuf sai.” ");
INSERT INTO ayz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesus yme msya yao na mama mo kʼAit. Menohe raa mawat tibyo ana mamo kene msya Ait fee. ");
INSERT INTO ayz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tna raa sait yama yawe kʼYesus yawe, “Nme msya nao na mros ste mne meu. Ana ksoh fri Nyõ.” ");
INSERT INTO ayz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Menohe Yesus yawe, “Raa ro mari Bokyas ro Allah, tna mbo mno kaket to, ana weto Jõ ttu tme msya tao na woJõ oh meto.” ");
INSERT INTO ayz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ti sau to, Yesus yawe kuber wAit yawe, “Nma anu buut wiak frit bmoʼt maru refo ati tino.” Tibyo ana maut wiak mamo. ");
INSERT INTO ayz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ana mamo mamo tna Yesus yjin tu mam wiak mato. Yjin tna foos frok tubor mama mai wiak rana. Tna figyõm mase mai maut mam wiak mato ye tna mabo kait ana beta. Wiak wana kene wo hoh. ");
INSERT INTO ayz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tna kuber wAit mti Yesus mawe, “Guru, guru, kbe anu bsu!” Yesus yrok yasen tna yifau foos msya figyõm ro safo weto yawe, “Nnem oh!” Tibyo foos msya figyõm reto mrok mnem. Tna maru reto mrok snef u. ");
INSERT INTO ayz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tna Ait ytu kuber wAit yawe, “Fyi re anu smot Jõ fee?” Ana mrok miskawowo tna waa. Tna mkyas kʼanya mawe, “Bi Ait refi yatak yifau foos msya figyõm wefo mari. Bi Ait refi fi awya mefi?” ");
INSERT INTO ayz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus ysya kuber wAit frit maru reto snok mam ati jaro. Ana riwai mbam provinsi ro Galilea tna frit mamoʼt rabin ro Gerasa. ");
INSERT INTO ayz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ana frok tna Yesus yaut mne. Tna raa ro kota reto sait yama tru Ait. Raa retait kabes mbo tibyo yyum ratan fee ti ooh oh. Tna ait yhau mam amah fee, ait ja yhau mam isra mato ro raa mse hai sai. ");
INSERT INTO ayz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tiwya kabes mama mbo raa retait ti aro rau-rau. Tibyo raa moo rantai make ait yatem msya yaa, tna kmot ait ye. Menohe kabes mno ait yatak tibyo yahri rantai beta hri. Yahri rantai reto tna ysam yamoʼt yuk ro riamo. Tna he Yesus yama. Ait ro yker ymat Yesus tibyo kakyah tna yama yo kʼAit kait tna yaka tmi yimna tna heyut Yesus. Tna Yesus yikyak kabes frok mbam ait yawe, “Snok oh!” Tna raa retait yawe, “Yesus; Nyõ fi Allah yare. Allah tait yase toni. Kbe Nyõ nno bawya kʼjõ? Jõ soh-soh kʼNyõ tawe sikowah jõ ma!” ");
INSERT INTO ayz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tna Yesus ytu kʼait yawe, “Nyõ nasom awya?” Tna raa retait yawe, “Kabes mawat mbo jõ. Tibyo jõ tasom ‘Legion.’” ");
INSERT INTO ayz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tna kabes weto soh-soh kʼYesus hri mun aro rau mawe, “Nbis amu frok nmoʼt sawro wore wo kabes ja mhau to ma!” ");
INSERT INTO ayz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kene msya yuk reto ye fane mawat mau bana mam faut sau. Tna kabes weto soh-soh kʼYesus mawe, “Nbis amu frok nmo twok mam fane wore wono!” Tna Yesus ybis yawe, “Nmo oh!” ");
INSERT INTO ayz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tna kabes weto mari tna frok mamo twok mam fane weto. Tna fane weto mrok mker tna mhoh tbat mam rakak reto btek mam maru. Tna fane weto msu tibyo mhai beta mkak. ");
INSERT INTO ayz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Raa ro kmot fane weto mmat bo ro Yesus yno. Feto tibyo ana masen fooh mhoh mamo mkyas kʼraa mam kota reto tna mkyas kʼraa ro mhau kene ye. ");
INSERT INTO ayz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tibyo raa masen myum mamo mmat. Ana mroh sia mamoʼt maru mne mo kʼYesus. Mamo tna mmat he raa ro yker retait hre mte ysya Yesus. Kabes frok marak oh. Ait yyum ratan. Tna srau yakit rait moof oh. Ana mmat feto tibyo mrok waa. ");
INSERT INTO ayz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Raa ro riwai mmat bo ro Yesus yno weto mkyas betoo kʼraa mawe Yesus yisoh raa ro kabes mbo retait yoof oh. ");
INSERT INTO ayz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Raa weto mari tna mrok waa. Tibyo ana ro mbam rabin ro Gerasa beta to, soh-soh mawe Yesus frok sikba rabin rana reto yamo. Tna Yesus yawe yaut wiak yamo. ");
INSERT INTO ayz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tna raa ro riwai yker retait soh-soh kʼYesus yawe, “Jõ kro Nyõ bmo ye!” Menohe Yesus yawe kʼait yawe, “Nyõ kro ma. ");
INSERT INTO ayz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Namo no kʼraa wonyõ. Tna nkyas bo msai ro Allah yno kʼnyõ.” Tibyo raa retait yamo ykyas bo msai ro Yesus yno kʼait reto. Ait yamo ykyas bo reto kʼraa ro mhau mam remo rait reto beta. ");
INSERT INTO ayz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus ybam maru maam tino hah ye yama tna raa beta ste Ait wea. Ana ksoh myum mama mtar Ait. ");
INSERT INTO ayz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tna bi yabi ro ybo samu watum raa ro Yahudi sait yama. Ait retait yasom Yairus. Ait yama yaka heyut Yesus tna soh-soh kʼAit yawe, “Guru; namaʼt amah ajõ. ");
INSERT INTO ayz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nama nisoh ku ajõ ye! Au fo ku ajõ tomu sai. Umur rau to tahun 12. Tna au kiyam, kerit wo mhai.” Yesus yari bo ro bi ait yawe feto tna yamo. Yamo mam iso maka menohe raa msis-sas beak-ak anya kro Ait mamo ye. ");
INSERT INTO ayz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Tna fai sau mama miir ratan ro Yesus rAit. Fai au fo mafa mees ro fnya yoyo tahun trion 12 oh. Tiwya raa mawat mama tkif fai au oh. Menohe raa ro mtai misoh au aro fee. Feto mamo snok tis rau to, pitis wau marak. Tna mees rau reto miyõ sai fares. Fai au mama kait mo kʼYesus mam tis tna miir ratan rAit makit sai. Au miir ratan rAit si fo, tna mees rau reto mrok mnem. ");
INSERT INTO ayz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tna Yesus yawe, “Awya oh mi miir Jõ fo?” Raa saak ana. Tna Petrus yawe, “Guru; nmat raa mawat beak-ak anya fefo! Fyi re Nyõ ntu feto?” ");
INSERT INTO ayz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Menohe Yesus yawe, “Tna sai Jõ tari he tatak aJõ frok mbam kʼJõ. Tibyo thar tawe raa miir Jõ.” ");
INSERT INTO ayz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Fai reto mhar mawe bo ro au mno reto raa mhar oh. Tna au tetet mhai mama mo kʼYesus. Au maka hartu Ait tna mkyas kiyam rau reto tna mawe, “Jõ au oh mi riwai tama tiir ratan aNyõ to. Tibyo kiyam ajõ mrok mnem buu.” Mkyas bo reto tna raa beta mari. ");
INSERT INTO ayz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tna Yesus yawe, “Ku aJõ, nyõ smot Jõ tibyo kiyam anyõ reto marak. Riof kʼnyõ oh. Nasen namo oh.” ");
INSERT INTO ayz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus ykyas bo fares tna raa sait ybam samu bi Yairus yama. Tna yawe kʼYairus yawe, “Ku anyõ reto mhai oh. Nno bi Guru ysui aro u ma.” ");
INSERT INTO ayz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Menohe Yesus yari bokyas reto to, yawe kʼYairus yawe, “Waa ma, smot Jõ sai. Smot Jõ nawe Jõ tatak tisoh au. Tna ku anyõ kbe mrok moof u.” ");
INSERT INTO ayz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ana mamo tna snok mam amah ro Yairus. Tna Yesus yawe kʼPetrus, Yohanes ysya Yakobus yawe, “Anu nbo tuuf sai kro Jõ twok mam amah mato. Anu nbo tuuf nsya ku au maja, mme sai twok mam amah. Raa taro beta mhau mne sai.” ");
INSERT INTO ayz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Raa beta ro mhau mne to, sraujin tna mawia hai reto. Menohe Yesus yawe, “Nwia ma! Ku reto mhai fee. Au mjin sai meto!” ");
INSERT INTO ayz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Menohe ana masah Yesus. Ana mhar mawe ku reto mhai tibyo oh. ");
INSERT INTO ayz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesus yamo yo ku au tna ybo matem sau yawe, “Ku aJõ, nasen oh!” ");
INSERT INTO ayz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ku reto mafos rau hah me si fo, tna au masen mros. Tna Yesus ybis raa moo boit mee kʼau mait. ");
INSERT INTO ayz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yairus ysya yfain ana mrok miskawowo toni. Tna Yesus yawe kʼana yawe, “Nkyas bo refo renti kʼraa ma!” ");
INSERT INTO ayz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ati sau to, Yesus ytu kuber wAit mabo 12 weto mama mo kʼAit. Tna Ait yoo yatak rAit yee kʼana re kbe ana mikyak kabes beta ro mbo raa, tna misoh raa ro kiyam ye. ");
INSERT INTO ayz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tna Ait ybis ana mamo misoh raa ro kiyam tna mkyas wore wo Allah yamo Raja ybo raa mana rAit. ");
INSERT INTO ayz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tna Yesus yawe kʼana yawe, “Nmo ntem marak sai, nbo armuk ma, krek yume ma, nbo boit ma, nbo pitis ma, tna nbo ratan roto taro ro kbe nyum to ye ma. ");
INSERT INTO ayz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ati ro anu twok mam remo to, soh raa sait yoo anu yse mam amah rait to, nhau oh nsya ait mam beto mamo snok mam wore anu nsen sikba remo reto. ");
INSERT INTO ayz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ati ro anu twok mam remo taro to, soh raa mitrah amah wana kʼanu fee, tna hawe bo mari bo ro anu nkyas to, feto ati ro anu sikba remo reto nmo to, bes-baas bohasyaf ro mhau mam naa to akus sai. Nno feto afo re ana weto mhar mawe anu bitsre ana akus. Ana hawe bo mari bo ro anu nkyas. Feto tibyo ana mesait oh mi misti kair ro meen mama mai kʼana reto.” ");
INSERT INTO ayz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tna ana mabo 12 weto masen mamo mno bo ro Yesus ybis kʼana. Ana mamo tiyo-teya sai mkyas Bokyas Moof reto tna misoh raa ro kiyam ye. ");
INSERT INTO ayz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Raja Herodes tii ybis raa mame Yohanes yajat. Tna ait yari bo ro Yesus ysya kuber wAit na mabo 12 mno to. Raa taro mkyas mawe Yesus tait, Yohanes ro tii yajat tna yrok yasen. Tibyo raja Herodes ynaut yyi ait. ");
INSERT INTO ayz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tna yari he raa taro mkyas mawe Yesus tait nabi Elia frok yama u. Tna taro mawe Yesus tait nabi roto sait ro tii yhai tna yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tna raja Herodes yawe, “Ait retait Yohanes fee: Tiwya jõ tbis raa ktan Yohanes yana yajat oh. Ait ro raa mkyas retait tait awya?” Tna raja Herodes yawe yamo ymat Yesus. ");
INSERT INTO ayz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ti baro firwas tna kuber ro Yesus wAit mabo 12 weto hah me. Tna ana mkyas kʼAit mawe bo ro ana mno beta. Tna Yesus ymen ana mesait kar mamoʼt kota ro Betsaida. ");
INSERT INTO ayz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Menohe raa mari he ana mamoʼt Betsaida. Tibyo ana mawat masen mamo mo kʼAit mam beto. Ait yawe ana mama rof oh tna yasen ykyas bo kʼana ye. Ait ykyas wore wo Allah yamo Raja ybo raa mana rAit. Tna yisoh raa ro kiyam to ye. ");
INSERT INTO ayz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","14","Ayõ kene hawer oh tna raa mawat mhau mari bo ro Yesus ykyas fares. (Raa sme mabo trion 5000 bo feto.) Tna kuber wAit mabo 12 weto mama mo kʼYesus mawe, “Yuk refo fo riamo. Nbis raa wefo masen mamo rof re kbe ana saso boit ro mait aro msya yuk ro mjin. Kbe ana saso mam remo msya kota ro mhau kene mam wefo sor.” Yesus yawe, “Anu nesait noo boit aro nee kʼana mait.” Menohe kuber wAit mawe, “Amu nse roti maat msya syoh mana ewok aran sai fo. Nyõ nawe amu nmo saso boit mkah nee kʼraa mawat wefo mait a?” Tna Yesus yawe, “Mfe. Nbis raa beta hre mte. Nwe ana mabo 50 bo feto hre kbair sau hayah-hayah.” ");
INSERT INTO ayz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kuber wAit mari tna mbis raa msis-sas weto hre mte. ");
INSERT INTO ayz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tna Yesus yoo roti maat msya syoh mana ewok reto ybo. Tna heyut mam ayoh yayoh asik mase kʼAllah. Tna Ait haber roti weto tna yiti syoh mana reto tna yee kuber wAit yawe ana saim kʼraa ro hre weto. ");
INSERT INTO ayz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Raa weto mait tna mhaf matu beta. Menohe roti mabuf taro to msis mhau fares. Kuber ro Yesus wAit soo roti weto tna mfau mam keranjang trion 12 matot. ");
INSERT INTO ayz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ti sau to, Yesus yesait skabuk kar. Tna kuber wAit mama mo kʼAit. Tna Ait ytu kʼana yawe, “Raa makin mnaut mawe Jõ fi awya?” ");
INSERT INTO ayz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kuber wAit mawe, “Ana taro mawe, Nyõ fi Yohanes ro ja baptis raa. Tna taro mawe, Nyõ fi nabi Elia. Tna taro mawe Nyõ fi nabi roto sait ro tii yhai tna yrok yasen fo.” ");
INSERT INTO ayz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tna Yesus ytu kʼana yawe, “Bonaut ranu nesait nwe Jõ fi awya?” Tna Petrus yasen yawe, “Nyõ fi Mesias ro nbam Allah nama.” ");
INSERT INTO ayz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tna Yesus yawe wa ana yawe, “Nkyas bo refo renti kʼraa to ma. ");
INSERT INTO ayz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Kbe meen Jõ tkai bo ro samyoh mawat btek mai kʼJõ. Raa ro agama Yahudi kbe mikyak Jõ: Raa mabi wana ye, imam manes wana ye, tna msya guru agama wana ye. Jõ kbe raa mame tajat, tna ti ro tuuf to, Taja yno tibyo Jõ trok tasen. ");
INSERT INTO ayz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Anu awya sai ro ksoh kro Jõ to, nko hawe sai kbe nno mfi fefo: Nno bo wanu u ma. Tna rabu wawa nwe nsom ara warok wanu sait-sait: Au oh mi nko hawe sai beroh nsom bo mase ro kbe mama mai kʼanu. Tna beroh nkro iso ro Jõ terif kʼanu. ");
INSERT INTO ayz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Raa taro mawe misoh metsu rana ai mam tabam refo. Ana saso riof rana mam tabam refo sai ai menohe mnaut mamos rana fee. Meen ana weto mhau hame wajin fee. Menohe raa taro mawe mhau saso riof rana ai mam tabam refo fee. Ana mawe mno bo woJõ. Ana saso Jõ tasom aJõ mam tabam refo. Ana weto oh mi kbe mkai riof kʼana. Ana kbe meen raa mame majat oto, menohe meen mkai riof ro hame wajin. ");
INSERT INTO ayz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mfi bo raa sait ykai kta mam tabam refo to beta menohe ykai riof mase fee. Meen mafer rau to bawya? ");
INSERT INTO ayz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen Jõ hah tama u. Tna raa mmat tase aJõ. Tna raa mmat bo yase ro Allah rAit msya malaikat wAit ye. Menohe mfo refo, wore wo raa mhau mam tabam refo fares to, raa taro to hawe kro Jõ. Mawe ana saban mkyas Jõ tasom. Ana ro hawe Jõ feto to, meen ati ro Jõ hah tama u to, kbe Jõ hawe ana ye. ");
INSERT INTO ayz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nri oh! Meen anu baro nmat raa mana ro Allah yamo Raja ybo to, mama frok tubor. Frok to, anu ro nros nsya Jõ mam befo to, meen anu baro nhau fares nmat to. Ati reto to, anu beta nhai marak fefares.” ");
INSERT INTO ayz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ti trion krentuuf firwas tna Yesus yamo yaut mam atu sau yawe skabuk. Ait ymen Petrus, Yohanes ysya Yakobus ana msya Ait mamo. ");
INSERT INTO ayz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ana mamo maut mam atu reto tna Yesus skabuk. Ait skabuk kri-kri fares to, yetsu rAit to haberek: Yasu ynaif roto, tna ratan rAit mrok ngkren toni. Ngkren mboh toni mnan fi rir ro mrir. ");
INSERT INTO ayz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tna ana mmat raa mabo ewok frok tubor mros msya Yesus. Ana mbewok weto to Musa ysya Elia. ");
INSERT INTO ayz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ana mbewok ngkren toni ye. Mbewok mkyas bo kʼYesus. Mkyas mawe ati ro kbe mame Yesus yajat mam Yerusalem to kene oh. ");
INSERT INTO ayz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Riwai Petrus ysya yafoh wait mjin maka, tibyo ana mjin tu. Tna fo ana mrok masen mmat Yesus yase rAit; yetsu rAit mawyah. Tna raa mabo ewok reto mros msya Ait mam wore weto ye. ");
INSERT INTO ayz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Musa ysya Elia masen mawe mikba yuk reto mamo. Tna Petrus yawe kʼYesus yawe, “Guru; amu ye nhau mam yuk refo to moof toni. Kbe amu sgi sbyah trion tuuf mam yuk refo: Sau kʼNyõ, sau kʼMusa, tna sau ye kʼElia.” (Petrus ykyas sai tna ait wase bokyas rait reto.) ");
INSERT INTO ayz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus ykyas fares tna byõ mama sro-sro ana kait. Tibyo ana waa. ");
INSERT INTO ayz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tna ana mari Raa sait ymai mam byõ mato yawe, “Ait refi Ku aJõ, ro Jõ tsok oh. Nri bo kʼAit!” ");
INSERT INTO ayz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mai reto marak, tna ana mmat Yesus yesait kar yros mam weto. Ti mawat firwas tna kuber wAit weto mkyas bo ro ana mmat reto kʼraa wia fee. ");
INSERT INTO ayz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Rabu ti fo Yesus ysya kuber wAit mroh mbam atu reto. Tna raa mawat myar mama mo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tna raa ro myar mama weto, sait yasen soh-soh Yesus ytu yawe, “Guru; nama nmat ku ajõ. Ait fi ku sme ajõ tomu sai! ");
INSERT INTO ayz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rabu wawa kabes mbo senteta ait. Tna ait wohrarar tna yrok ktor. Tna yafyat frok mam yasoh rait. Kabes reto simoyot-mayat ait, tna au hawe bo frok mbam kʼait ye! ");
INSERT INTO ayz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jõ soh-soh kuber woNyõ afo re mikyak kabes frok. Menohe ana matak fee.” ");
INSERT INTO ayz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus yawe, “Anu wefo mfe saut! Anu wefo raa ro wyahte Allah, tna smot Jõ fee! Kbe thau tsya anu kait fares a? Jõ thaf sneh tsya anu kait ye fee!” Tna Yesus yawe kʼbi retait yawe, “Nbo ku anyõ retait nakah nama!” ");
INSERT INTO ayz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Raa retait yakah ku rait yama fares to, menohe kabes mabyõ ku retait tna yetsu mrok ktor. Tna Yesus yikyak kabes reto, tna yisoh ku retait yoof. Tna fo yoo ku retait yee kʼyaja u. ");
INSERT INTO ayz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Raa beta mrok ktak mmat Allah yatak rAit ro mase reto. Raa ktak tna mkyas bo ro Yesus yno fares, tna Ait ykyas bo kuber wAit yawe, ");
INSERT INTO ayz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Nri oh! Tna nnaut oh: “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna kbe raa moo Jõ msan kʼraa roto mbo.” ");
INSERT INTO ayz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bokyas ro Yesus reto, Allah ymyõt maja rau afo re kuber wAit srau mnaut bokyas rAit reto wia fee. Tibyo kuber wAit wase bawya ro Ait ykyas reto. Tna ana waa bo mtu kʼAit ye. ");
INSERT INTO ayz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ti sau fo, kuber ro Yesus wAit santri bo kʼanya. Ana mkyas mawe kbe ana to, awya ro yase toni. ");
INSERT INTO ayz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus yhar bonaut wana wia oh. Tibyo Ait yoo ku maku sau yse ysya Ait mros mam ati jaro. ");
INSERT INTO ayz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tna Ait yawe kʼana yawe, “Jõ ksoh anu nitrah nhaf wanu kʼraa ro mhaf sneh. Awya ro yitrah yhaf rait ku refo, ro yno feto mam Jõ tasom aJõ to, ait yno bo moof oh meto. Au oh mi; awya ro ymat raa ro mhaf sneh to, yno feto to mnan anya mfi ait yno bo ro moof reto kʼJõ ye oh meto. Allah oh mi tiwya ybis jõ tama fo. Tibyo awya ro yitrah yhaf rait kʼJõ tait, yitrah yhaf rait kʼbi Allah ye oh meto.” Tna Yesus yawe, “Anu fo, awya ro yaku toni? Jõ tnaut tawe ait retait oh mi raa ro yase to.” ");
INSERT INTO ayz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanes yawe, “Guru; amu nmat raa sait yikyak kabes mkah tak ro Nyõ nasom aNyõ. Ait tait ja ysya anu bmo su fee. Tibyo amu nwe wa kʼait nwe, ‘Nno feto ma!’” ");
INSERT INTO ayz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tna Yesus yawe, “Nwe wa kʼait ma. Awya ro beswan anu fee, ait yhau mam ati ranu.” ");
INSERT INTO ayz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tna kene mam wore wo Allah tubat Yesus yamoʼt sawro rAit oh. Feto tna Yesus beroh yawe yamoʼt Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ait ybis raa baro matim wia mamoʼt remo sau mam iso maka. Yawe, “Nmo siwyan bombra wanu beta re kbe amu nma.” Remo reto mhau mam rabin ro Samaria. ");
INSERT INTO ayz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Menohe raa ro remo reto mhar mawe Yesus tait raa ro agama Yahudi tna yawe yamoʼt Yerusalem. Ja raa ro Samaria miranya msya raa ro Yahudi fee. Feto tibyo ana ro Samaria hawe bo Ait yhau mam remo rana reto. ");
INSERT INTO ayz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kuber wAit Yakobus ysya Yohanes mari bo weto to tibyo ana kmo mawe, “Tuhan; Nyõ nawe amu nbis tafoh mbam ayoh mroh mait raa weto fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Menohe Yesus siur ymat ana tna yastako ana yawe, “Nno feto ma!” ");
INSERT INTO ayz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tna ana masen mamoʼt remo roto. ");
INSERT INTO ayz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesus ysya kuber wAit kro iso sau mamo. Tna raa sait yawe kʼYesus yawe, “Wore Nyõ namo woyõ-woya sai to, jõ ksoh kro Nyõ bmo ye.” ");
INSERT INTO ayz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tna Yesus yawe kʼait retait yawe, “Mtah serigala to, ja mabum mam wafyoh rau. Tna ruu to, ja mabum mam tafat rau ye. Menohe Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ fi, wore tjin aro fee. Soh nyõ nawe kro Jõ to, kbe wore nyõ njin aro fee ye.” ");
INSERT INTO ayz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tna Yesus yawe kʼraa roto sait yawe, “Nasen nama kro Jõ.” Menohe raa retait yawe, “Tuhan; nbis jõ tamo wia sama hai ro taja tna fo tama kro Nyõ.” ");
INSERT INTO ayz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Menohe Yesus yawe, “Namo ma. Ana ro wase Allah to, kbe mesait sama hai wana rof. Jõ ksoh nyõ nasen namo nkyas bo kʼraa. Nkyas wore wo Allah yamo Raja ybo raa mana rAit.” ");
INSERT INTO ayz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Raa roto sait yawe, “Jõ tawe tama kro Nyõ menohe nbis jõ tamo tmah meen kʼraa wojõ wia.” ");
INSERT INTO ayz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tna Yesus ykyas bofret sau yawe, “Raa sait yasen yabah tabam mam ora rait mkah bajak. Yamo, yamo betruk bajak reto, menohe ymat matim fee, haberek ye ymat mam tis. Tibyo yabah tabam reto kaket fee. Feto ye, raa baro mawe masen mkah bo mam armato ro Allah rAit. Mkah bo menohe haberek me mmat tis. Ana weto to, siwyan mamo raa ro Allah yamo Raja ybo to fee.” ");
INSERT INTO ayz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tna fo Yesus ysok raa mabo 70 naut. Ait ybis ana mamoʼt kota msya remo wore kbe Ait yamo. Yawe ana mabo ewok-ewok matim wia. ");
INSERT INTO ayz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ait yawe kʼana yawe, “Raa makin weto mfi armato ro manes oh. Menohe raa ro matu bo to, mabo kebet baro sai; mnan fee. Feto to, nyoh kʼAllah ro armato rAit afo re Ait ybis raa mama matu bo mam armato reto. ");
INSERT INTO ayz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nsen nmo. Tna nnaut oh: Anu fo raa ro nhaf sneh. Tna Jõ tbis anu nmo mam wore wo raa ro mimara mboh mhau. Anu nfi domba maku ro mamo mam wore wo mtah serigala ja mhau. ");
INSERT INTO ayz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nmo to nbo surah wiak ma. Tna krek yume ro nfau bo to ma. Nbo sandal roto to ma ye. Tna ati ro anu nmo to, nros iti-iti to ma.” ");
INSERT INTO ayz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ati ro anu twok mam samu sau to, nmah meen kʼraa ro mhau mam samu reto nwe, ‘Riof oh kʼanu beta.’ ");
INSERT INTO ayz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Soh raa ro amah rait reto to, yawe yari riof ro anu nmah to, kbe Allah yno riof kʼait. Soh mfe to, kbe Allah yno riof reto mhau kʼait fee, riof reto hah me mama mhau kʼanu u. ");
INSERT INTO ayz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tna nhau mam amah reto sai aran. Nsen satoh nmoʼt amah roto ma. Nnaut: Raa ro mkah kahren raa to, kbe raa moo boren maren ana tu oh. Wore wo anu nhau mam samu reto tna nkah bo ro Allah rAit to, bo sohmaam ro anu sohmaam to mfi boren ro raa maren anu to. Feto to nsohmaam oh. ");
INSERT INTO ayz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ati ro anu ntwok mam remo sau to, soh raa ro remo reto masen mitrah amah wana kʼanu to, tna moo boit mee kʼanu niit to, tawe niit boit bawya ro ana moo mee kʼanu niit to. Tna nta aya ro ana moo mee kʼanu nta. ");
INSERT INTO ayz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tna nisoh kiyam wana moof mam remo reto ye. Tna nwe kʼana nwe, ‘Allah siwyan yamo Raja ytu raa wAit mama ybo fo.’ ");
INSERT INTO ayz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Menohe ati ro anu twok mam remo sau to, tna soh raa ro remo reto mikyak anu to, hah ne nmo mam iso tna nisbas bohasyaf ro mbam remo rana to akus. Tna nwe, ");
INSERT INTO ayz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Amu bes-baas koh ro mhau mrat kʼamu naa. Amu nno feto afo re anu nhar nwe amu nbes-baas anu akus. Anu hawe bo nri bo ro amu nkyas fee. Feto tibyo anu nesait oh mi nisti kair ro meen mama mai kʼanu.’ Nnaut: ‘Allah siwyan yama yamo Raja ybo raa mana rAit. He mfe, anu nhawe Ait ybo anu.’” ");
INSERT INTO ayz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tna Yesus yawe kʼraa wAit weto yawe, “Meen ati ro tabam refo haberek to, kbe Allah ymat raa ro tiwya mhau mam kota ro Sodom tna yno bo ro maku sai mbtek mai kʼana. Menohe raa ro remo refo tii mikyak anu. Ana hawe bo mari bokyas aJõ. Tibyo bo ro meen mbtek mai kʼana weto to, kbe samyoh toni.” ");
INSERT INTO ayz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tna Ait yastako ana yawe, “Anu raa ro Khorazim nsya raa ro Betsaida: Meen ayoh mroh kʼanu! Tiwya Jõ tno bo ro msai mam remo wanu weto, menohe anu nashana fee. Soh tiwya Jõ tno bo msai weto mam remo ro Tirus msya Sidon maami, raa ro beto mashana mbam iro wana to, bose oh. Tna sraujin tibyo myum ratan ro mjif hai tna mate boh ro tafoh mam mana wana abyõ. ");
INSERT INTO ayz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ati ro Tuhan yoo safo mana ymit kʼraa to, kbe Ait ymat raa ro mhau mam remo weto tna yawe yno bo maku sai mbtek mai kʼana. Menohe anu nikyak Ait tibyo bo ro kbe meen mbtek mai kʼanu to samyoh toni! ");
INSERT INTO ayz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tna anu ro nhau mam remo ro Kapernaum nnaut nwe meen anu beta nmoʼt sawro ro Allah rAit. He mfe, kbe meen anu nmoʼt sawro ro kabes!” ");
INSERT INTO ayz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tna Yesus yawe kʼraa wAit weto yawe, “Soh raa mari bo ro anu nwe to, ana weto mari Jõ ye oh meto. Tna raa ro mikyak anu to, ana mikyak Jõ ye oh meto. Tna raa ro mikyak Jõ to, ana mikyak bi Ait ro ybis Jõ tama ye oh meto.” ");
INSERT INTO ayz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ana mabo 70 weto mamoʼt kota msya remo sor tna hah mamo mo kʼYesus. Ana simaut toni tna mawe, “Tuhan; soh amu nikyak kabes mkah nyõ nasom anyõ, mkah tak aNyõ to, kabes weto beta mari oh ye tna msam!” ");
INSERT INTO ayz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tna Yesus yawe, “Ae, Jõ tmat kabes yabi (Iblis) ybam ayoh uu mbtek mnan fi rir ro mrir mbam ayoh uu! ");
INSERT INTO ayz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nnaut oh: Jõ tsan tatak aJõ kʼanu afo re anu ntak nber aban msya taitbai ye. Tna bo weto aro kbe sikowah anu fee. Tna kbe anu nros ntak abyõ kabes yabi (Iblis) ye. Tna ana aro kbe sikowah anu fee. ");
INSERT INTO ayz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Anu ntak nikyak kabes weto, menohe simaut bo weto toni to ma. Tawe nsom wanu to Allah ykom mam sawro rAit oh. Kbe anu nhau nsya Ait su mam beto. Au oh meto nsimaut toni oh!” ");
INSERT INTO ayz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tna ati reto ye to, Har ro Tuhan mno re Yesus yesait simaut mase. Tna Ait skabuk kʼAllah yawe, “Taja, Nyõ fi Tuhan ro nase. Nyõ to, nbo sawro aNyõ msya tabam refo ye. Tna Nyõ nmyõt bo aro re raa wase maja wau weto. Bo wefo fo, raa ro ja mhar bo to, ro mkom bo to, ana srau fee. Menohe bo wefo to, nyõ nerif kʼraa kinyah re ana mhar tna srau ye. Feto to, tayoh asik mase kʼNyõ. Taja; Nyõ nhar bo Nyõ oh. Tna ja nno bo ro Nyõ nhaf mnan sai.” ");
INSERT INTO ayz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tna Yesus yawe kʼraa wAit weto yawe, “Bombra beta to, Taja ysan kʼJõ tatem tbo oh. Raa wase Jõ. Taja yesait aran yhar Jõ. Tna raa wase Taja ye. Jõ tesait thar Ait. Tna raa ro Jõ tsok to, tkyas kʼana weto re kbe mhar bi Ait ye.” ");
INSERT INTO ayz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tna Yesus ymat kuber wAit tna yawe kʼana mesait aran yawe, “Tuhan yno bo ro moof kʼanu to. Ait yno re anu nmat bombra wefo to. ");
INSERT INTO ayz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jõ tawe kʼanu tawe: Tiwya nabi ro Allah ybis mama msya raja to, mawat mhaf miyoh bo. Mhaf miyoh bo mawe mmat bo ro anu nmat wefo ye, he mfe. Tna ana mhaf miyoh mari bo ro anu nri wefo ye, he mfe ye.” ");
INSERT INTO ayz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ti sau to, guruagama sait yasen yros tna sanet Yesus yawe, “Kbe jõ tno bo bawya re kbe thau hame wajin?” ");
INSERT INTO ayz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tna Yesus ytu bo kʼait yawe, “Watum ro Musa mkyas mawe bawya? Nyõ nmat bokom reto to, nnaut nawe fyi?” ");
INSERT INTO ayz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Guru retait yawe, “Nhafri Tuhan Allah ranu mkah nhaf, srau ranu beta, mkah ntak ranu beta, tna mkah bohar ranu beta ye. Ulangan 6:5 Tna nhafri raa ro mhau kene msya anu to ye. Nhafri ana mnan fi anu nhafri netsu wanu nesait ai to.” ");
INSERT INTO ayz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tna Yesus yawe, “Bokyas anyõ to moof mnan si! Soh nyõ nno bo weto kaket to, kbe meen nyõ nhau hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Menohe guru retait ksoh yawe raa mmat ait. Tibyo beroh ytu u yawe, “Raa ro mhau kene msya anu to; awya sor meto?” ");
INSERT INTO ayz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tna Yesus betoo yawe, “Raa sait ybam Yerusalem yroh yamoʼt Yerikho. Yamo mam iso maka kri-kri fo, raa ro marmtuk mfot ait mai. Tna ana mtak ratan msya bo wait beta. Tna ana sikba ait akus. Tibyo ait ykah yaaf bris akus kene wo yajat. ");
INSERT INTO ayz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yhau baro tna imam ro agama Yahudi sait yama mam iso reto ye. Tna ait ymat ait ro riwai raa mai retait bris. Menohe imam refi yatmof raa retait fee. Ait beroh yiwrek yamo sai tna sikba raa retait akus. ");
INSERT INTO ayz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tna raa Yahudi roto sait ybam raa mana ro Lewi yama ye mam iso reto. Yama tna ymat raa retait. Menohe yatmof raa retait ye fee. Ait beroh yiwrek sikba raa retait akus ye. ");
INSERT INTO ayz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tna fo raa roto ro ybam Samaria sait yama mam iso reto ye. Ait ymat raa retait, tibyo ait yrok sraujin tna yatmof raa retait. ");
INSERT INTO ayz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ait yama ymat sas raa refi yetsu o yaaf bo. Tna yoo minyak msya anggur maya karu yaaf wait weto. Tna yoo bo sro tna yake yaaf wait ye. Tna raa ro Samaria retait tubat raa ro ykai bo retait yse abyõ mam keledai rait tna yasyõ yamoʼt losmen sau. Tna yisoh ait kaket mam beto. ");
INSERT INTO ayz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tna rabu ti fo ait yoo pitis dinar trion ewok, tna yaren bi ro losmen retait tna yawe, ‘Nisoh kmot ait ro ykai bo refi kaket. Soh pitis weto mkak to, kbe jõ thah tama tisroh mabyoh wonyõ u.’” ");
INSERT INTO ayz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tna Yesus ytu bo kʼguru agama retait yawe, “Bonaut anyõ to nawe fyi? Ana mabo tuuf refo to, awya ro oh mi yno bo moof kʼraa ro tiwya raa mtak bo wait retait?” ");
INSERT INTO ayz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Guru agama yawe, “Ait ro yatmof raa retait, tna yisoh raa retait ye. Ait oh mi yhafri raa anya ye.” Tna Yesus yawe, “Namo tna nno mnan anya mfi ait yno feto ye.” ");
INSERT INTO ayz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus ysya kuber wAit mamo renti tna snok mam remo sau. Tna fai sau masom Marta mmen Yesus ysya kuber wAit mama mhau mam amah rau. ");
INSERT INTO ayz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta to mao sau masom Maria. Maria au hre mte kait msya Yesus mawe mari bokyas rAit. ");
INSERT INTO ayz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Menohe Marta to msui toni siwyan boit ro kʼana. Srau rau to makin-akan. Tna au mamo mo kʼYesus mawe, “Tuhan; Nyõ sayõ jõ tesait sui tno bo beta a? Tna Maria mabo hre sai a? Nbis au mama mbet jõ ye re!” ");
INSERT INTO ayz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesus yawe, “Marta, nyõ nnaut yyi bo aro rau-rau sai. ");
INSERT INTO ayz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Menohe bo ro ati to sau aran. Nao Maria, au fo msok bo ro ati mefo: Au ksoh hre mari bokyas aJõ. Jõ aro tawe wa kʼau fee.” ");
INSERT INTO ayz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mun sau Yesus skabuk. Ait skabuk mkak tna kuber rAit sait yawe, “Tuhan; tiwya Yohanes yerif kuber wait re ana mhar bo skabuk. Sgi nerif iso ro skabuk kʼamu ye.” ");
INSERT INTO ayz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tna Yesus yawe, “Soh anu skabuk to, nwe fefo: ‘Taja, nno re kbe raa mari tibyo bibi Nyõ nasom aNyõ. Nasen nama namo Raja tna nbo raa woNyõ. ");
INSERT INTO ayz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ifo yoyo to, amu nyoh boit mbam kʼNyõ natem aNyõ re boit wamu to mabut fee. ");
INSERT INTO ayz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Amu ja ne nhaf moof nsya raa anya ro mno bo ro mkair mai kʼamu. Feto to nyon iro wamu sor ye. Tna nitsre amu re bosanet aro besruf amu to ma.’” ");
INSERT INTO ayz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tna Yesus yawe, “Mti arin masuf tna bi sait ro ybam remo ro fari yama snok mam remo sau. Tna bi ait yamo yo kʼyafoh rait sait ro yhau mam remo reto yawe, ‘Tao, mti refo jõ tjin tsya nyõ.’ Yafoh retait yawe, ‘Jõ ksoh nyõ njin mam befo fea!’ Menohe ait ynaut yyi, yhar yawe boit marak. Tibyo ait yasen yamo yo kʼyafoh rait ro yhau kene mam amah rait. Yamo yayoh roti mabuf tuuf. ");
INSERT INTO ayz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yamo menohe yafoh rait yjin oh. Tibyo raa retait yawe, ‘Nasen natmof jõ oh: Riwai tafoh ajõ sait ybam fari yama yjin ysya jõ, menohe boit ro jõ tee kʼait yait aro fee!’ ");
INSERT INTO ayz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yayoh feto menohe yafoh rait yasen yitrah mato rait fee. Yawe, ‘Namo oh! Amah mato ajõ tuut oh, tna jõ tsya kukek wojõ beta njin oh! Jõ tasen too bo weto tee kʼnyõ fee!’” ");
INSERT INTO ayz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tna Yesus yawe kuber wait yawe, “Yafoh ro yama yti raa retait mam arin masuf tait yafoh rait fea. Menohe ait ro yjin oh hawe bo yasen yoo bo yee. Tna tis rau ait yasen tna yoo bo ye. Yafoh retait beroh sai yayoh. Au oh mi raa retait yasen yoo bawya ro yayoh to yee. ");
INSERT INTO ayz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Reto oh mi Jõ tawe, ‘Nyoh bo kʼAllah tna kbe Ait yoo bo yee. Saso bo tna kbe ntru bo reto. Nii mato tna kbe mato reto Allah yitrah. ");
INSERT INTO ayz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Awya sai ro yayoh bo kʼAllah to, kbe Allah yoo yee. Awya sai ro saso bo to, kbe tru tu oh. Tna ro yai mato to, kbe Allah yitrah mato reto ye oh.’ ");
INSERT INTO ayz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mfi bo ku sait yawia yabo syoh to, kbe yaja yoo aban yee fee. ");
INSERT INTO ayz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mfi bo ku retait yawia ruu mauf yait to, kbe yaja yoo taitbai yee fee. ");
INSERT INTO ayz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Anu raa fo nimara mboh. Menohe anu nksoh noo bo ro moof nee ku wanu. Tna Nja ranu ro yhau mam sawro rAit to, ksoh yoo bo ro moof toni yee kʼanu ye. Soh raa mayoh kʼAit to, kbe Ait ksoh yoo Har rAit yee kʼana ye fea!” ");
INSERT INTO ayz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ati sau to, Yesus yikyak kabes frok mbam raa ro ymai marak. Kabes reto frok tna raa retait yrok ymai. Raa mawat mmat tibyo mrok ktak. ");
INSERT INTO ayz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Menohe raa taro mawe, “Aha! Yesus yatak yikyak kabes sor fo, mkah tak ro kabes Beelzebul rait. Kabes Beelzebul retait ja ybo kabes sor.” ");
INSERT INTO ayz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Raa taro sanet Yesus mawe yno bo msai aro re kbe ana mmat. Mmat tibyo ana mhar mawe Ait ybam kʼAllah yama fe mfe a. ");
INSERT INTO ayz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Menohe Yesus yhar bonaut wana weto, tna Ait yawe, “Soh raja ro rabin sait ybo raa wait menohe mafa anya ai to, kbe rabin reto mnah. Tna raa ro mhau mam amah sau su to, soh ana mafa anya ai to, kbe ana matak fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anu taro nwe Jõ tikyak kabes sor mkah tak ro kabes Beelzebul. Fyi? Kabes yabi (Iblis) yamo raja ybo kabes taro sor. Tna soh kabes weto mafa anya ai to, kbe rabin ro kabes yabi yamo raja ybo to mros matak fee. ");
INSERT INTO ayz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Anu nwe Jõ tikyak kabes sor mkah tak ro kabes Beelzebul. Menohe kuber wanu ja mikyak kabes ye. Tibyo anu nnaut nwe ja kuber wanu mikyak kabes mkah matak ro awya rait? Tnaut tawe kuber wanu mesait kbe mawe bonaut ranu reto to sre. ");
INSERT INTO ayz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Allah oh mi yoo yatak rAit yee kʼJõ. Tibyo Jõ tikyak kabes frok to. Feto to, Allah ybis Jõ tama tbo raa mana rAit to. ");
INSERT INTO ayz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jõ fret bo tawe, ‘Soh raa ro yatak sait ybo sbe wait tna yhau kmot amah rait to, kbe raa aro ter-ter mama mtak kta wait to fee. ");
INSERT INTO ayz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Menohe mfi bo raa ro byoh yama to, soh byoh retait yatak toni to, kbe ytak sbe raa retait wait msya kta wait saah. Yoo kta weto tna ysaim kʼawya ro ait ksoh.’” ");
INSERT INTO ayz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tna Yesus yawe, “Awya sai ro hawe ysya Jõ nkah bo su to, ait retait ytoh Jõ. Tna awya sai ro hawe ysya Jõ ymen raa mama mo kʼAllah to, ait retait yfi raa ro yikyak raa somya ha-hayah.” ");
INSERT INTO ayz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tna Yesus yawe, “Ati ro raa mikyak kabes frok mbam raa sait mamo to, kabes reto mamo ninya. Mamo ninya mam wore wo aya aro fee. Mawe sne hoh menohe kabes reto fri yuk ro moof aro fee. Tibyo kabes reto mnaut mawe, ‘Jõ thah te tamoʼt yuk ajõ ro wia rof, ro tiwya jõ sikba akus.’ ");
INSERT INTO ayz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tna kabes hah me snok mam yuk reto. Tna mmat he yuk reto raa misoh moof ati. ");
INSERT INTO ayz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Feto tna kabes reto mawe hah mamo mhau. Tna mmen mafoh na mabo trion krema mama mhau msya au ye. Kabes trion krema weto to ja mno bo ro mkair-kar toni miwer kabes ro tinyi reto. Tna ana mama twok raa retait beta ye. Tna kbe ana mno ait refi ykair toni yiwrek bo ro tiwya ait ykai wia ye.” ");
INSERT INTO ayz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus ykyas bo reto to si fo, tna fai sau mtu mkah mai ro fari mawe, “Allah yno bo moof kʼfai au ro mabe Nyõ tna moo sis mee kʼNyõ nait!” ");
INSERT INTO ayz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Menohe Yesus yawe si yawe, “Allah yno bo moof toni kʼraa ro mari bokyas rAit tna mbo mno kaket to.” ");
INSERT INTO ayz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Raa mawat mama sifut kʼYesus. Tna Ait ykyas bo renti yawe, “Anu raa mana ro mfo nhau mam tabam refo fo, anu ja nber safo wofo. Anu nwe Jõ tno bo msai aro re kbe anu nhar nwe Jõ tbam kʼAllah tama fe mfe a. Menohe Jõ kbe tno bo myoh sau aran sai re anu nmat tna nhar: Kbe anu nmat bo msai sau ro mnan fi tiwya Allah yno mkah nabi Yunus sai. ");
INSERT INTO ayz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nnaut: Tiwya nabi Yunus yamoʼt Niniwe. Tna Allah yno bo msai re raa ro Niniwe mhar mawe Allah oh mi ybis Yunus yama. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna kbe Allah yno bo msai ro mnan anya afo re anu nhar nwe Allah oh mi ybis Jõ tama ye. ");
INSERT INTO ayz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Jõ tawe kʼanu tawe, tii ana ro mhau mam kota ro Niniwe weto to, mari bo ro nabi Yunus ykyas. Mari tibyo mashana. Mfo refo Raa ro yase yiwer Yunus tait yros susai ysya anu. Menohe anu fo hawe bo nashana. Meen, ati ro Tuhan yoo safo mana ymit kʼraa to, kbe raa ro tiwya mhau mam kota ro Niniwe to, msya anu ye mrok masen. Tna ana kbe masen mmit safo kʼanu raa ro nhau mfo wefo. Tiwya fnya manes (ratu) sau mhau mam rabin ro ati ti wayir sau. Tna au mbam rabin ro fari reto masen mamo mo kʼraja Salomo mawe mari bokyas rait. Raja retait tait raa ro yhar bo toni. Mfo refo Raa sait ro yase yiwer Salomo retait yros susai ysya anu. Menohe anu hawe bo nri bokyas rAit. Feto to meen fai au reto kbe masen mmit safo kʼanu raa ro nhau mfo wefo. Meen ati ro Tuhan yoo safo mana ymit kʼraa to, fai au msya anu ye kbe mrok masen. Tna fai au mmit safo kʼanu.” ");
INSERT INTO ayz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ja raa mbet tafoh (pelita) afo re ntara raa ro twok mam amah mato. Ja raa mmyõt tafoh fee. Raa moo mse mte tna moo ember burut wa fee ye. Menohe tafoh reto to, ja raa hero abyõ afo re kbe kek ntara tna raa ro mama twok mam amah mato reto mmat. ");
INSERT INTO ayz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Anu nsu wanu to, mfi tafoh ro ntara anu oh meto. Soh nsu moof to, mno netsu wanu mram. Tibyo nsu maah ye. Tna soh nsu wanu mti to, anu nhau mam mamur sai. ");
INSERT INTO ayz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Feto to, kaket anu re kek ro mhau mam kʼanu to mait mram kaket. Mram kaket afo re anu nmo mam mamur to ma. ");
INSERT INTO ayz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Soh anu netsu wanu mamur aro fee, tna anu nsu maah to, kbe anu nmat kek ro ati, tibyo mno anu nhau mam wore wo maah.” ");
INSERT INTO ayz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus ykyas bo reto mkak tna raa ro Farisi sait ymen Ait yamo yait boit mam amah rait. Tna Yesus yamo yait boit mam beto. ");
INSERT INTO ayz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Raa ro Farisi retait ymat he Yesus yno bo mafa raa ro agama Yahudi to wia fee; mi yyon yatem wia fee menohe hre yait boit sai. Mmat tibyo ana mrok ktak mawe, “Yesus; Nyõ nait boit to, nyon natem wia fea!” ");
INSERT INTO ayz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tna Yesus yawe, “Hawereh msya piring to, anu raa ro Farisi ja nyon moof mne sai kaket. Menohe mato rau to mkair fares. Anu nwe anu nhaf wanu moof oh, menohe ja anu safto bo raa tna nno bo mkair-kar toni fares. ");
INSERT INTO ayz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Anu wase bo! Allah yfen raa msya piring to, mne sai fee! Allah yfen mato wau weto ye! ");
INSERT INTO ayz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jõ tawe kʼanu tawe natmof raa kinyah ro suawe. Tna nsan boit mam piring wanu kʼana ye. Nno feto tna bo bawya ro anu nno to, kbe mrok moof mnan si bo ro Allah oh meto ye.” ");
INSERT INTO ayz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Tna Yesus yawe kʼraa ro Farisi weto yawe, “anu fo raa ro sioh anu sai. Anu ja ksoh noo bouum ro tinyi (persepuluhan) ro mbam armato wanu to, nsan kʼAllah. Ja anu noo bo knik-knak mnan fi bumbu msya bo taro sor ro maku nsan ye to. Menohe anu niwana bo ro ati sor ro Allah yawe: Ja anu nno bo ro moof kʼraa kaket fee. Tna anu hafri Allah kaket fee ye! Feto to, meen kair mama mai kʼanu tu oh. Rau ro moof to, anu nsan bouum ro tinyi wanu kʼAllah ye tna nno bo ro moof kʼraa ye, tna nhafri Allah kaket ye. ");
INSERT INTO ayz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ati ro anu nmoʼt samu watum to, ja anu ksoh hre mam ambar raa ro mase ja hre. Tna ati ro anu nmoʼt pasar to anu ksoh raa roto mmat anu tna mmah meen kʼanu tna hartu anu ye. Feto to meen bo ro mkair mama mai kʼanu. ");
INSERT INTO ayz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Soh raa mno kuburan moof fee, kbe raa mber kait-kat sai. Ana wase yuk reto to, hai mhau mam tabam. Tna anu raa ro Farisi fo nfi feto ye. Anu nhaf mato wanu mkair. Menohe raa mmat anu to, ana wase anu nhaf wanu to mkair. Feto to, meen kair mama mai kʼanu tu oh.” ");
INSERT INTO ayz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tna guruagama sait yawe, “Guru; nyõ nkyas bokyas weto to, nyõ namus amu wefo ye oh meto!” ");
INSERT INTO ayz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tna Yesus yawe kʼguru agama weto yawe, “Anu ja nbis raa wanu ro Yahudi bno bo ro samyoh toni. Anu bsom bo ro samyoh. Menohe anu ntubat bo weto mati fee. Feto to, meen Allah yno bo ro mkair mama mai kʼanu ye. ");
INSERT INTO ayz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Hohos wanu tii mame nabi na ro Allah ybis mama. Tna raa sama hai ro nabi weto mam isra mato. Tna anu, ku renti wana ro mame nabi na weto, ja anu nisoh isra weto. Anu nmo wan-wan oh meto! Nno feto mkyas mawe bo ro hohos wanu mno reto, anu nhaf mnan. Feto to meen Allah yno bo ro mkair mama mai kʼanu. ");
INSERT INTO ayz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Allah yhar bo rAit. Reto oh mi tiwya ykyas anu yawe, ‘Jõ kbe tbis nabi woJõ msya raabis (rasul) woJõ mamo mo kʼraa ro tabam refo. Tna ana ro Jõ tbis weto to, taro kbe raa mame tna taro kbe raa sikowah ye.’ ");
INSERT INTO ayz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Allah yno feto afo re anu nsom safo weto. Nabi na ro tiwya Allah ybis mamaʼt tabam refo to, raa mame majat beta. Raa mame menohe meen ymit safo reto kʼanu ro mfo wefo nhau mam tabam refo. Maban tiwya tinyi raa mame nabi na ro Allah ybis mama: Mbam tinyi wore wo nabi Habel yhau mamo snok mam ti ro nabi Zakharia yhau. (Tiwya bi Zakharia retait ykah bo ro Allah kri-kri mam Samu ro Allah jaro msya wohat ro bosan jaro (mezbah) masuf susai tna raa mame.) ");
INSERT INTO ayz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Anu guru agama Yahudi: Raa ro tomer mamo mam iso ro moof to, anu, ja nno wa ana weto. Tna anu nesait nmo mam iso ro ati reto ye fee. Feto to, meen kair mama mai kʼanu tu oh.” ");
INSERT INTO ayz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesus yasen sikba amah reto. Tna guruagama msya raa ro Farisi weto to, kmo wer. Ana mkyas kair Yesus tna hre su saim bo re kbe ana mtu bo aro rau mamo mam tite re sanet Ait. Ati ro ana mmat Ait u to, ana mtu bo bawya ro samyoh aro kʼAit. Ana mnaut mawe kbe Yesus ytu si bo ro mkair aro tibyo, mno re kbe raa kmo Ait. ");
INSERT INTO ayz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Raa msis-sas toni mama mmat Yesus. Ana myar mama sikait-kat anya. Tna Yesus ykyas bo kuber wAit wia yawe, “Anu kaket anu mkah ragi raa ro Farisi. Ana to, ja sioh-nat ana sai. Ana ja mawe ana mari bokyas ro Allah tna mbo mno, he mfe. Bo ro ana mno reto to, mnan ragi. Ja raa moo ragi kebet tna srioh msya tepung. Srioh tibyo raa mahni ragi reto. Tna raa ro Farisi mnaut mawe raa aro wase bo ana mari Allah kaket fee. Mnaut mawe kbe raa wase tna mawe ana raa ro ja sioh-nat to fee. ");
INSERT INTO ayz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Soh raa mno bo ro mkair aro, ja ana mber bo reto. Mber afo re raa anya mmat fee tna mhar fee. Menohe bo weto beta meen raa masbrer tu oh. Kbe raa mmat tna mhar. Bo ro raa mmyõt to, meen raa masbrah kʼraa tu oh. ");
INSERT INTO ayz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tna bo ro anu nkyas wore mti wai to, meen hahah baas tu oh. Tna bawya ro anu samoh wai kʼraa to, kbe raa mkyas abyõ kʼraa beta mari ye.” ");
INSERT INTO ayz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Tna Yesus yawe, “Tafoh woJõ: Soh raa mama mame anu to, waa ma. Raa matak mame anu netsu wanu sai. Tna fo ana matak mno bo aro naut mai kʼanu u fee. ");
INSERT INTO ayz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Menohe waa bi Allah. Ait oh mi yatak yame raa. Yatak yame raa tna fo yko mam tafoh ro meen mhau mait hame wajin ye. Feto to waa Ait yesait aran! ");
INSERT INTO ayz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ruu mbas mana maat, raa masim tna mabyoh rau to, pitis mauf ewok aran sai. Ruu mbas to, mabyoh mroh sai menohe Allah Ait sorni mana sau bo fee. ");
INSERT INTO ayz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anu nbyoh ranu to, maut toni miwer ruu mbas mabyoh rau. Feto to waa ma. Tna nna mawyan wanu to, Ait ntuu beta mnan oh. Ait ymat anu kaket. Feto to waa ma. ");
INSERT INTO ayz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jõ tawe kʼanu tawe, hrenaut Jõ ma. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Awya ro ykyas abyõ kʼraa roto yawe, ‘Jõ smot Yesus’ to, kbe meen Jõ tkyas ait abyõ kʼmalaikat ro Allah wAit weto. Tawe, ‘Ait retait raa aJõ oh metait.’ ");
INSERT INTO ayz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Menohe awya ro ywaar Jõ kʼraa roto yawe, ‘Jõ smot Yesus fee’, meen Jõ twaar ait ye. Kbe tkyas kʼmalaikat sor tawe, ‘Raa retait tait raa aJõ metait fee.’ ");
INSERT INTO ayz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Awya ro yamus Jõ to, Allah yyon iro rait reto saah. Menohe awya ro yamus Har ro Allah to, kbe Allah yyon iro rait reto fee yum. ");
INSERT INTO ayz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Anu smot nwe Jõ tbam Allah tama. Smot feto tibyo meen raa kmo anu, mawe anu nber safo oh meto. Kbe raa makah anu mamoʼt samu watum ro agama, mo kʼraa manes mam beto. Soh mfe ana makah anu mamo mo kʼraa ro pemerintah. Kbe ana mkyas bo maun anu to. Tna ati ro anu saak wa anu to, anu waa ma. ");
INSERT INTO ayz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mam ati reto to, Har ro Tuhan mesait kbe mbesi bokyas ro anu nkyas reto.” ");
INSERT INTO ayz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Raa makin mros mari bokyas ro Yesus mam beto. Tna raa sait yawe kʼYesus yawe, “Guru: Amu nja yhai kba amu. Nbis tao ajõ saim kta baro kʼjõ.” ");
INSERT INTO ayz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tna Yesus yawe kʼait yawe, “Jõ raa ro tros susai anu mbewok to fee. Jõ tamo hakim ro tmat sas bo ranu mbewok to fee ye.” ");
INSERT INTO ayz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tna yawe kʼraa makin yawe, “Nasmamo nme kta ma. Pitis msya bo bawya sor ro raa mse to, bo ro ati meto fee. Nnaut namos anyõ. Bo ro ati oh meto.” ");
INSERT INTO ayz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tna Yesus fret bo yawe, “Bobot sait ruf wait bombra mninon. ");
INSERT INTO ayz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bo wait mninon oh tna ynaut yawe, ‘Gudang ro tse bo mawat refo mnan fee. Kbe tno fyi mefo?’ ");
INSERT INTO ayz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bobot retait hre ynaut. Tna yawe, ‘Kbe tno fefo: Tbis raa mama mitrah gudang wojõ ro maku, tna sgi gudang sau ro mase renti. Tna kbe tbu gandum msya bo satoh wojõ beta mam gudang reto. ");
INSERT INTO ayz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tna tahun ro meen mama to, jõ thau baas sai. Jõ tse bo beta ro moof mninon oh. Kbe mhau bau masno snyi. Mfo refo thau tjin tna tasen sai. Thau sohmaam bo sai bojõ. Tna thau simaut mase sai!’ ");
INSERT INTO ayz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Menohe Allah ymat bobot retait yawe, ‘Nyõ wase bo! Mti refo Jõ too namos anyõ. Tna kta ro name reto to, kbe nyõ nuumto kʼawya yhaf yse riryõn?’ ");
INSERT INTO ayz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Raa ro ja tomer mame kta mam tabam refo, menohe ana tomer miranya msya Allah fee; raa weto to wase bo.” ");
INSERT INTO ayz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Tna Yesus yawe kuber wAit yawe, “Reto oh mi tawe kʼanu tawe: ‘Nnaut yyi bo ro tabam refo toni to ma. Nnaut nwe nfos wanu to bo ro ati. Tna nnaut yyi boit ro kbe anu niit to ma. Feto ye, nnaut netsu wanu to, nwe bo ro ati miwer ratan ro anu nyum. Feto tna nnaut yyi ratan ro kbe anu nyum to ma. ");
INSERT INTO ayz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nmat sas ruu ro fru to: Ruu to ja wase bo mkah. Tna wase bo siwyan boit ye. Tna wase sgi gudang ro moo boit mse ye. Menohe Allah siwyan boit kʼana. Tna anu raa fo, Ait ymat anu kaket miwer ruu to. ");
INSERT INTO ayz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Anu nkin wefo fo, awya ro ytai yirenti yamos rait kebet naut? Nnaut yyi bo ro tabam refo yoyo, he mfe. Allah oh mi Raa ro ybo anu nmos wanu. Allah yesait aran ytai yirenti mamos raa to. ");
INSERT INTO ayz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Raa mnaut yyi mamos wana mam tabam refo to, tna tis rau bonaut yyi mirenti mamos rana fee. Feto to nnaut yyi boit ro kbe anu niit msya ratan ro anu nyum to ma: Mafer marak. ");
INSERT INTO ayz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nmat sas bosafom ro moo mam smok. Tafuf wau weto mesait moo sai. Tafuf weto mur-mur saso boit fee. Bosafom to ja msui mfen ratan ro myum to fee. Menohe Allah yno bo weto moof toni. Tiwya raja Salomo yyum ratan ro moof wer. Menohe Allah yno ara tafuf weto moof toni miwer. Raja Salomo, ratan rait moof mfi bosafom tafuf wau to fee. ");
INSERT INTO ayz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Allah yno re bosafom ro moo mam smok ifo moo boti waor sai. Menrabu to, raa mama mkah mkak. Mhau boti waor sai, menohe Allah fayir bosafom reto. Ait yno tafuf rau moof toni. Tawe, Allah ymat anu tna ksoh anu toni miwer bosafom reto. Feto to nnaut yyi ratan ro anu nyum to ma. Anu ja smot Allah kaket fee! ");
INSERT INTO ayz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nnaut yyi boit ro niit ma! Nnaut yyi aya ro nta ma! Nnaut yyi bombra weto ma! ");
INSERT INTO ayz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Raa ro wase Allah mam tabam refo to, msui saso bo weto beta. Menohe anu fo ku ro Allah yare oh. Ait yhar bombra beta ro anu nnaut weto. ");
INSERT INTO ayz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Feto to, ntomer re Allah yamo Raja ybo anu to. Saso bi Ait wia matim feto, tibyo bo ro anu nnaut weto to, kbe Allah yoo ysan kʼanu.’” ");
INSERT INTO ayz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tna Yesus yawe, “Anu fo nfi domba woJõ ro tira. Anu nbo kebet sai; nwat to fee. Menohe waa ma. Nja ranu ksoh yoo anu yse mam sawro ro Ait yamo Raja ybo. ");
INSERT INTO ayz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nsim kta wanu tna noo mabyoh rau to, nsaim kʼraa kinyah ro suawe. Kta ro tabam refo kbe msaef marak. Soh anu nmat raa ro mse bo mabut to, tna natmof ana to, anu nme kta ro ati oh meto. Anu nme kta ro ati mam sawro ro Allah oh meto. Nno feto to, mnan fi anu nfau kta wanu mam surah wiak ro matak. Mam surah wiak reto kta wanu weto meen mkak fee, mhau mawyõs. Kta weto kbe raa msyõf fee, kbe bo mabat fee. ");
INSERT INTO ayz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Soh anu nme kta wanu mam tabam refo fo, kbe nhaf wanu mnaut kta weto sai. Menohe soh anu nme kta wanu mam sawro ro Allah to, kbe anu nhaf nnaut sawro rAit yoyo ye.” ");
INSERT INTO ayz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Tna Yesus fret bo yawe, “Bobot sait yamo yayõ boyõ mam tabam ro fari. Tna sryan wait mhau siwyan bobot retait hah yama: Ana mhau mwan, myum ratan wana fares, tna mbet lampu oh. Mhau tna bobot retait hah yamaʼt amah rait. Yama tna ymat he sryan weto, ana siwyan ana wea tna huwya mitrah mato re ait twok.” Tna Yesus yawe, “Kbe meen Jõ hah tama u. Feto to rabu wawa nhau siwyan anu nfi sryan weto. ");
INSERT INTO ayz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nnaut: Soh Bobot sait yama tna ymat he sryan wAit mros wea ste Ait yama; feto moof. Kbe ana simaut. Meen Bobot retait yesait yawe ana hre wia. Tna siwyan Ait, tna yesait yasyõ boit yama saim kʼana mait. ");
INSERT INTO ayz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mfi bo Bobot hah yama arin masuf, soh mfe kene wo reen to, tna soh ait ymat he sryan wAit mhau mwan fares; feto moof.” ");
INSERT INTO ayz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tna Yesus yawe, “Nnaut bofret refo kaket wia: Bi sait yhar yawe, ‘Mti fo, kbe ait ro ysyõf bo yama yitrah amah ajõ tna ysyõf bo.’ Soh ait yhar ayõ ro ait ro ysyõf bo retait ysaim yama to, kbe ait yjin fee. Yhau wan afo re raa msyõf bo wait fee. ");
INSERT INTO ayz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'Ait ro Yroh Yama Yfi Raa Sai' kbe meen yama u. Kbe hah yama u mam ayõ ro anu nhar wia nwof Ait to fee. Feto to nhau siwyan yoyo.” ");
INSERT INTO ayz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tna Petrus ytu bo yawe, “Tuhan; bokyas refo, Nyõ nkyas kʼamu nesait aran sai fe nkyas kʼraa beta a?” ");
INSERT INTO ayz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tuhan yawe, “Bo refo tkyas kʼawya sai ro yamo sryan ro mur-mur yno bo ro Allah yawe, tna ro yhar bo ye. Mfi bo bobot sait yawe yamoʼt oo roto. Ait ysok sryan wait sait yhau tna yno bo rait mam wore wo ait yarak wia. Ybis sryan retait yamo aban mana ybo sryan wait roto taro. Tna ybis sryan retait yoo boit saim kʼsrian anya wait roto taro ye. Tna bobot retait yasen yamoʼt oo roto. ");
INSERT INTO ayz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tna ati ro bobot retait yhah ye yama to, soh ait ymat aban mana retait ja yno bo rait ro ybis kaket to, feto moof. ");
INSERT INTO ayz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nri kaket: Kbe bobot ysok sryan ro yari bo ro ait yawe retait yse kmot bombra wait beta. ");
INSERT INTO ayz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Menohe mfi bo sryan ro yamo aban mana retait tait yhaf rait mkair. Tna ynaut yawe, ‘Bobot ajõ yarak, kbe yhah yama fooh fee.’ Tibyo ait yno bo ro mkair: Ait yai sryan ro kinyah taro. Yai ro ano msya ro sme ye. Tna yasmamo yait boit, yata aya, tibyo bisir yoyo. ");
INSERT INTO ayz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kbe bobot rait snok yama. Yama mam ayõ ro sryan ro yamo aban mana retait siwyan fee. Bobot rait snok yama tna ymat bo mkair ro sryan retait yno. Tibyo bobot retait kmo. Kbe ait simoyot-mayat sryan retait. Tna ybis ait yamo yhau mam yuk ro kair ysya raa ro ja hawe mari Allah. ");
INSERT INTO ayz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tawe kʼanu tawe, ‘Sryan ro yhar bonaut ro bobot rAit, he beswan yno fee, tna siwyan fee, kbe bobot retait kmo yahoh ait. ");
INSERT INTO ayz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Menohe sryan ro wase bonaut ro bobot rAit, tibyo yno bo rait kaket fee, tna siwyan fee; kbe bobot retait mok-mak ait kebet sai. Soh Allah yoo bo kebet sai yee kʼraa sait to, Ait ybis yawe raa retait yisoh bo weto tna mno bo kebet sai ye. Tna soh Allah yoo bo bombra mawat yee kʼraa taro, ybis raa retait yisoh bo weto tna yno bo mawat miwer ait ro yse bo kebet sai.’” ");
INSERT INTO ayz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tna Yesus yawe, “Jõ tama tawe too tafoh beak mroh mam tabam refo mait mawyah. Moof ati soh tafoh reto mait mawyah oh! ");
INSERT INTO ayz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Menohe tako hawe sai, meen raa mame Jõ tajat mam ara warok wia. Tna Jõ thaf aya mamo snok bo reto mkak oh! ");
INSERT INTO ayz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Anu nnaut nwe Jõ tama re tisoh iranya raa msya raa anya fe mfe a? Mfe, Jõ tama tibyo raa taro mawe ana mban Jõ. Tna raa taro mamo byoh kʼJõ. Tisti fa meto. ");
INSERT INTO ayz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tama tibyo raa mabo maat ro mhau mam samu su to, mabo tuuf mban Jõ tna mabo ewok mamo byoh kʼJõ. Tibyo mafa anya. Soh mfe; mabo ewok mban Jõ tna mabo tuuf mamo byoh kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kbe raa mafa anya: Ku ro sme yasen yafa ysya yaja. Tna yaja yasen yafa ysya ku ro sme rait retait. Tna ro ano mafa msya mme. Tna mme masen mafa msya ku rau reto. Tna fnya mafa msya snyim ro ano, tna fnya snyim ro ano mafa msya fnya ye.” ");
INSERT INTO ayz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tna Yesus yawe kʼraa msis fo yawe, “Anu nmat barmabyõ safe mam ati ro habeh to, ja anu nhar nwe, ‘Kbe oom mais.’ Tna kbe oom mais tu oh. ");
INSERT INTO ayz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tna soh foos mfi mama mbam ti wayir to, anu nwe, ‘Ifo fo hwyõm.’ Tna kbe hwyõm tu oh. ");
INSERT INTO ayz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Anu nwe anu raa ro nhar bo. Menohe anu fo raa ro nmo wan-wan sai! Anu nhar bo ro tabam msya bo ro mhau mam ayoh. Menohe bo ro Allah yno mam oon refo to, fyi re anu wase fares. ");
INSERT INTO ayz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ja anu nmat sas tna nnaut bo mam nhaf mato. Fyi oh mi anu nesait nnaut nwe bo reto moof soh mfe mkair a? ");
INSERT INTO ayz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mfi bo anu sait nsya raa sait kmo anya. Tna anu mbewok nmoʼt amah ro raa mtu srah to, rau ro moof to, anu mbewok nisoh niranya tna nfot ntem anya mam iso maka. Soh mfe to, kbe sait yamo ysan sait kʼraa manes re mkyas safo reto. Tna fo raa manes mbis anu nmo no kʼait ro ytu srah yari. Tna fo bi ait ysan anu renti kʼait ro ja ybu raa mam bui mato. ");
INSERT INTO ayz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tna anu sait raa mbu mam bui mato mamo snok mam ayõ ro ait hrat bo raa ska wia. Tna fo ait frok ybam bui mato reto.” ");
INSERT INTO ayz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","⌞Tiwya raa ro agama Yahudi baro mbam provinsi ro Galilea mamoʼt Yerusalem skabuk Allah. Ana moo binatang wana ro kbe msan to, mbo mamoʼt Samu ro Allah. Mamoʼt Samu ro Allah ktan binatang weto msan kʼAllah. Ana msan bosan wana weto kʼAllah kri-kri fo menohe raa sbe mama mame ana. Gubernur Pilatus ybis tibyo raa sbe wait weto masen mamo mame ana.⌟ Raa mabo baro mari bokyas reto tna mkyas kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus yari feto tna ytu bo kʼana yawe, “Anu nnaut nwe fyi? Ana weto to, raa mame majat, tna Allah ymat sayõ rof sai, fyi? Iro wana mawat miwer raa roto mbam Galilea oh mi ana raa mame meto a? ");
INSERT INTO ayz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mfe. Iro ro ana mno oh mi misti kair reto mai kʼana to fee. Menohe soh anu nashana fee tna nhai to, kbe Tuhan yoo safo mana ymit kʼanu mfi ymit kʼana weto ye. ");
INSERT INTO ayz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tiwya menara ro miyõ mam koot ro Siloam matu mai raa mabo 18 majat. Anu nnaut nwe fyi? Ana weto to, mno iro mawat miwer raa roto beta ro mhau mam Yerusalem a? ");
INSERT INTO ayz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mfe. Iro wana oh mi misti kair reto mai kʼana to fee. Menohe soh anu nashana fee tna nhai to, kbe Tuhan yoo safo mana ymit kʼanu ye.” ");
INSERT INTO ayz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tna Yesus ykyas bofret yawe, “Ara mara sau moo mam tain anggur ro bi sait rait yno. Tna mun sau ait yamo saso make rau mam mara. Menohe ait ykai kake reto make aro fee. ");
INSERT INTO ayz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tibyo yawe kʼait ro kmot tain reto yawe, ‘Tahun tuuf oh mi jõ tama saso ara refo make. Menohe jõ fri make aro fee! Feto to jõ tawe nyõ nfat makus sai. Mhau mros mati sai mam tain refo mkah bawya?’ ");
INSERT INTO ayz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Menohe ait ro kmot tain reto yawe, ‘Mhau ruman tahun sau naut wia. Kbe jõ tabah koh aro tber mair tna too boh aro bo beak ye. ");
INSERT INTO ayz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tna kbe tahun rouu make ye. Soh tahun rouu mawe make fee, feto to nyõ nbis jõ tfat makus rof.’” ");
INSERT INTO ayz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ayõ ro raa ntmoh(hari Sabat) sau to, Yesus watum bo mam samu watum ro agama Yahudi sau. ");
INSERT INTO ayz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Fai sau ro kabes sariya re kiyam tahun trion 18 oh to mama ye. Kabes reto mno tibyo fai reto kbor maka. Tna mros trot fee. ");
INSERT INTO ayz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus ymat fai au refo tna ytu au mama. Tna yawe, “Tme, kiyam anyõ reto tno marak oh.” ");
INSERT INTO ayz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tna yoo yatem yse kʼfai au abyõ si fo au mrok mros trot ye. Tna au masen mbaut Allah. ");
INSERT INTO ayz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bi yabi ro ybo samu watum reto ymat bo ro Yesus yno. Ynaut yawe Yesus yisoh raa ro kiyam mam ayõ ro raa ntmoh (hari Sabat) to, yawe Yesus yno iro oh meto. Tibyo ait kmo. Tna yawe kʼraa msis reto yawe, “Ti trion ntamam mkah anu nno bo wanu weto beta. Feto to soh anu aro nksoh nwe raa misoh anu to, nma mam ti makin weto sau. Nma mam ayõ ro raa wanu ntmoh to ma!” ");
INSERT INTO ayz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Menohe Tuhan yawe kʼbi retait yawe, “Anu fo raa ro sioh-sah sai. Bo ro anu nwe wa to, bo weto anu nesait ja nno! Anu nkin ja skur binatang wanu ro nsia mam ayõ ro raa ntmoh. Tna anu nkuk nmo nse mata aya fe mfe a! ");
INSERT INTO ayz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tnaut tawe kbe raa mno bo moof kʼfai au refo mam ayõ ro raa ntmoh to ye fea! Fai au fo, ku renti ro Abraham ye. Tahun trion 18 oh to, kabes yabi yno au tibyo kiyam to. Fyi, ja raa mikyak kabes frok ye mam ayõ ro raa ntmoh to, fe mfe a!” ");
INSERT INTO ayz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus ykyas bo reto tna raa ro kmo Ait to, mrok hrenaut tibyo saban beta. Menohe raa msis-sas nksoh bo ro Ait yno reto. Mnaut mawe bo ro Ait yno to bo ro msai. ");
INSERT INTO ayz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tna Yesus yawe, “Raa mana ro Allah yamo Raja ybo to mnan fi bo bawya? ");
INSERT INTO ayz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mfi bo manaf ro maku sau. Bi sait yoo bo manaf ro maku reto yamo furere mam armato rait reto. Menohe ati ro bo manaf reto moo to, moo maut mfi ara bo feto ye. Tibyo ruu ro mfru mam ayoh to, mama tafat abyõ mam ara reto kre ye.” ");
INSERT INTO ayz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tna Yesus yawe, “Raa mana ro Allah yamo Raja ybo to mfi bo bawya? ");
INSERT INTO ayz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Reto mnan ragi. Ja fai sau moo ragi kebet baro, sryoh mam tepung mawat. Mhau tna kbe adonan reto mrok mtar mase beta ye.” ");
INSERT INTO ayz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tna Yesus yamo renti mam iso maka, kbe yamoʼt Yerusalem. Yamo mam iso maka to, Ait ykyas bo kʼraa iti mam kota msya remo roto taro. ");
INSERT INTO ayz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mam remo sau to, raa sait ytu kʼAit yawe, “Raa kebet sai aran meen mkai riof ro mase fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesus yawe, “Mato sau ro mtit mhau. Ntomer ntwok mam mato ro mtit reto. Kbe raa msis tomer twok mam mato reto menohe ana mama rere. Tibyo mtai twok fee.” ");
INSERT INTO ayz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tna Yesus yawe, “Ati ro bi ro amah rait yasen tna yuut mato reto to, meen anu ro nros mam ati ro mato mne to ntu nwe, ‘Bobot (Tuan), nitrah mato kʼamu!’ Menohe kbe bi ait yawe, ‘Mfe. Jõ wase anu. Anu awya metait?’ ");
INSERT INTO ayz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tna anu nwe kʼait nwe, ‘Tiwya amu niit nta nsya nyõ oh. Tna nyõ tiwya nhau iti-iti nkyas bo mam remo wamu ye oh!’ ");
INSERT INTO ayz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Menohe bi ro amah rait retait kbe haberek yikyak anu yawe, ‘Jõ wase anu. Anu awya metait? Anu fo raa ro nber safo. Nsen fooh, nmo fari tno!’ ");
INSERT INTO ayz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kbe anu nmat Abraham, Ishak, Yakub msya nabi na ro Allah ybis mama beta. Ana weto hre mam sawro ro Allah yamo Raja ybo raa wAit. Menohe anu fo, Allah yikyak mne nhau banu. Kbe anu sraujin anu toni. Tibyo anu kbe nwia tna kanasyah toni ye. ");
INSERT INTO ayz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kbe raa mama mbam arin aso beta. Mama hre sohmaam bo su mam wore wo Allah yamo Raja ybo raa wAit to. ");
INSERT INTO ayz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tawe: Raa ro mfo refo mamo mtis to meen ana matim wia. Tna raa ro mfo refo matim wia to, meen ana hah me mamo mam tis.” ");
INSERT INTO ayz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tna raa ro Farisi baro mama mo kʼYesus tna mawe, “Nasen namo oh, be Raja Herodes saim yawe yame Nyõ!” ");
INSERT INTO ayz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Menohe Yesus yawe, “Ait tait ynan fi serigala. ⌞Ait ja hren ksuk tna yame raa.⌟ Nmo nwe kʼait nwe, ‘Yesus yawe ifo msya menrabu to, Ait yhau fares re yikyak kabes sor tna yisoh raa ro kiyam to. Tna ti ro tuuf to yno bo wAit mkak oh.’ ");
INSERT INTO ayz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tako hawe sai Jõ tamo iso aJõ refo renti. Ifo fo, menrabu tna fjah tamo renti tamoʼt Yerusalem. Nabi ro Allah sor to, soh raa mame ana majat to, ja raa mame mam Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Raa ro Yerusalem, tiwya ana ja mame nabi ro Allah majat. Tna raa ro Allah ybis mamo mkyas bokyas rAit to, ja raa ro Yerusalem mame ana majat ye. Moo fraa mai raa weto tibyo majat. Muhrin aro rau-rau Jõ srau kero ana. Tawe tatmof ana tna takrao ana tse mam wo sau. Mfi kook mabi ro makrao maku tna maut mabum kait to ye. Menohe ana to hawe ye. Feto to Jõ sraujin raa ro Yerusalem, bo ro meen mama mai kʼana: ");
INSERT INTO ayz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ana hawe Jõ oh mi Allah kbe meen yatam ana ro mhau mam Yerusalem to u fee. Ait sikba ana akus. Kbe Jõ sikba tabam refo tna ana mmat Jõ u fee. Ana mmat Jõ fee mamo snok mam ati ro tabam refo haberek. Tna ati reto ana manwaruk mawe, ‘Ait yase toni! Tuhan ybis Ait yama to.’” ");
INSERT INTO ayz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","3","Ayõ ro raa ntmoh (hari Sabat) sau to Yesus yamo yait bo mam samu raa ro Farisi sait. Ait retait raa ro yase. Tna raa ro Farisi roto baro msya guruagama baro hre mait boit su msya ana ye. Tna raa ro yafa kiyam sait twok yama. Kiyam reto mno tibyo ait yetsu beta mtun. Raa manes ro agama Yahudi weto mmat sas Yesus. Tna Yesus ytu bo kʼana yawe, “Watum ro agama ranu mbis mawe raa misoh kiyam mam ayõ ro raa ntmoh to, fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Menohe ana shait sai beta. Tibyo Yesus ybo ait ro kiyam retait tna yisoh ait. Yisoh yoof tna ybis ait yawe yamo bait. ");
INSERT INTO ayz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tna Yesus ytu bo kʼana yawe, “Fyi, mfi bo anu nkin wefo sait, ymat ku rait, soh mfe sapi rait mbtek kayah (sumur). Mbtek kayah mam ayõ ro raa ntmoh to, kbe ait yamo fooh tubat fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Menohe ana weto sait ykyas bo si fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tna ana beta mamo hre mait boit. Tna Yesus ymat he ana msok yuk ro moof wia hre. Tibyo yawe bofret kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Soh raa sait ymen fnya tna yawe anu sait yamoʼt bokyõ rait reto to, kbe nno bawya? Nyõ namo tna kbe hre mam woyõ? Ja nyõ nksoh hre mam ambar ro moof fe mfe a? Jõ tawe anu nmo hre mam ambar ro moof wia ma. Kbe raa manes sait yama bo to fyi? ");
INSERT INTO ayz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nno kbe ait ro yakyõ bokyõ rait to yama yawe, ‘Kmo ma, nasen namo hre mam yuk roto. Yuk refo mhau kʼraa ro ati ro yama refi.’ Tibyo nyõ saban tna nasen namo hre mam tis. ");
INSERT INTO ayz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Rau ro moof to, soh raa mawe anu sait yamoʼt bokyõ rait to, nno fefo: Nmo to, hre mam tis. Tna kbe ait ro yakyõ bokyõ rait reto to, yama yawe, ‘Tafoh ajõ, nasen namo hre mam ambar ro moof rno.’ Tibyo raa taro mmat tna mawe nyõ raa ro nase. ");
INSERT INTO ayz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tawe kʼanu tawe, ‘Awya ro bibi ait yesait to, kbe hah ye yfi bo raa ro maku. Tna awya ro susu hah ye yaku to, ait kbe yrok yase mam uu.’” ");
INSERT INTO ayz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tna Yesus yawe kʼait ro yakyõ bokyõ rait yawe, “Soh nakyõ bokyõ to, noo taah nee kʼnafoh wonyõ ma. Noo taah nee kʼnao wonyõ, nano wonyõ, tmo wonyõ, msya raa mana wonyõ ro bobot to ma. Kbe ana weto makyõ bokyõ to moo taah mee kʼnyõ riryõn. ");
INSERT INTO ayz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Soh nyõ nakyõ bokyõ to, nmen awe, nmen raa ro kinyah, raa kair, raa ro maa msya matem bo mhai, msya raa ro masu mboh bo to. ");
INSERT INTO ayz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ana weto kbe ska bo moof ro nyõ no kʼana reto fee. Menohe Allah kbe yno bo moof kʼnyõ to. Meen Ait yno re raa ro mhaf moof mrok masen. Tna mam wore weto to, kbe Allah yaren nyõ tu oh.” ");
INSERT INTO ayz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Raa sait sohmaam bo su ysya ana weto. Ait yari bokyas ro Yesus reto tna yawe, “Wore wo Allah yamo Raja ybo raa mana rAit to, raa meen hre sohmaam bo mam beto ye. Awya sai ro meen hre sohmaam bo mam beto to, kbe mhau simaut mase.” ");
INSERT INTO ayz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tna Yesus yawe bofret yawe, “Bobot sait ymah korat ro mase sau. Tna ait yoo taah yee kʼraa mawat. ");
INSERT INTO ayz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bo sohmaam beta raa saruk mkak. Tna bobot retait ybis sryan sait yamo yawe kʼraa weto, yawe, ‘Nma twok oh. Raa siwyan bo beta ye oh!’ ");
INSERT INTO ayz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Menohe ana mama fee. Sait yawe, ‘Kmo ma: Jõ tsui tna tama fee. Jõ kwiyat tabam baro tna fares, tna tawe mfo refo tamo tmat.’ ");
INSERT INTO ayz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tna sait yawe, ‘Kmo ma: Tna sai jõ too sapi mana nsaa. Tna tawe tamo tse kuk sanet tno sapi weto mkuk bajak wia. Feto to kbe jõ tama fee.’ ");
INSERT INTO ayz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tna raa sait yawe, ‘Jõ tmen fnya ajõ tna fares, kbe jõ tama fee.’ ");
INSERT INTO ayz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tna sryan retait hah yamo yawe bo weto kʼbobot rait. Tibyo bobot retait kmo yawe, ‘Feto to namo fooh namoʼt remo tna saso raa mam iso sai: raa ro suawe, raa ro kinyah, raa ro kair, raa ro maa msya matem wana mhai, maka, msya raa ro masu mboh to. Namo nmen ana nakah nama.’ ");
INSERT INTO ayz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sryan retait yno bo reto tna hah yama yawe, ‘Tno oh. Menohe ambar ro raa kbe mama hre mawat marak sai fares.’ ");
INSERT INTO ayz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tna bobot retait ybis u yawe, ‘Namo fari tna saso raa mam remo ro maku ye, mam iso krewe ye. Nawe kʼraa nawe mamaʼt samu ajõ refo afo re matot. ");
INSERT INTO ayz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tawe raa ro jõ too taah tee to, kbe mama mam korat ajõ fee saut tna sohmaam bo wojõ aro fee ye!’” ");
INSERT INTO ayz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Raa mawat mama kro msya Yesus mam iso ro Ait yamo to. Yesus ymat ana tna ykyas kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Raa mawat mawe kro Jõ. Ana mawat mhafri maja msya mme, mfain msya ku wana, mao na, mano na toni. Menohe mhafri Jõ kaket fee. Feto ana weto to, raa woJõ fee. Tna awya ro hasu ait yesait toni menohe hasu Jõ kaket fee, ait tait raa aJõ fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Awya ro yawe kro Jõ to, menohe kro fee, tna yasom bo fanes ro mama mai kʼait to fee ye, ait yamo raa aJõ fee ye. Soh ait yasom ara warok rait reto ye tna ait kro Jõ ye; ait retait yamo raa aJõ.” ");
INSERT INTO ayz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tna Yesus yawe, “Mfi bo anu nkin sait ksoh yawe sgi amah to; ait hre ntuu mabyoh rau to wia fea! Tna ymat pitis ro ait yse to wia afo re yhar yawe kbe sgi mkak fe mfe a? ");
INSERT INTO ayz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Soh yno bo reto wia fee, kbe ait ysair yno pondasi sai menohe sgi amah ska fee. Tibyo raa mmat tna sret ait masah tna mawe, ");
INSERT INTO ayz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Raa refi yawe sgi amah rait reto menohe ytai sgi mkak fee!’” ");
INSERT INTO ayz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tna Yesus yawe, “Mfi bo raja sait yawe yafa ysya raja roto sait to; ait hre ntuu raa sbe wait kaket wia. Tna ynaut mnan wia yawe, ‘Raa sbe wojõ mabo trion 10.000 sai. Tna raja roto tait raa sbe wait mabo trion 20.000. Kbe fyi? Raa wojõ mnan fe mfe a?’ ");
INSERT INTO ayz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Soh ynaut yawe matak to fee, kbe mam wore wo byoh mhau fari fares to, ait ybis raa mamo mo kʼraja ro yafa ysya ait. Ybis ana mamo mkyas bo su kʼait. Tna ati ewok weto mtu mari iso ro moof fyi re kbe ana miranya sai moof.” ");
INSERT INTO ayz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tna Yesus yawe, “Au oh meto: Soh raa mawe kro Jõ to, ana weto kbe mnaut bo mnan wia, tna fo kro. Awya ro hawe, ysan bo wait beta kʼAllah yatem to fee, ait retait yamo raa woJõ to fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Jõ fret bo tawe, ‘Haa to ja mafah moof. Menohe mfi bo haa reto mafah fee, kbe raa mno fyi re kbe haberek mafah u? Mafer rau to aro uu fee. Haa reto mno armato moo kaket mfi pupuk ja mno to fee. Mafer ro haa reto to, marak sai. Haa reto raa moo mbeak sai.’ Anu ro nri bokyas reto to, nnaut kaket!” ");
INSERT INTO ayz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Raa ro mno iro ye msya raa ro moo namabyoh (pajak) bo ye ja mama mo kʼYesus mari bokyas rAit. ");
INSERT INTO ayz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tibyo raa manes ro Yahudi mmai kinya. Raa ro Farisi msya guruagama mmai kinya mawe, “Ait yiranya ysya raa ro mno iro tna hre mait bo msya ana su ee?” ");
INSERT INTO ayz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tibyo Ait ykyas bofret kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mfi bo anu sait ysia domba mana 100. Tna domba weto mana sau marak. Kbe ait yno bawya? Kbe ait sikba domba mana trion 99 refo akus wia, tna hah yamo saso mana sau ro marak reto tibyo ait tru. ");
INSERT INTO ayz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tru tna simaut toni. Yasen tubat domba reto yasom abyõ mam kbek. ");
INSERT INTO ayz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tna hah yamoʼt amah. Snok si mam samu to, ait ymen yafoh na msya raa ro mhau kene msya ait tna yawe kʼana yawe, ‘Nma, bkyõ bokyõ! Domba ajõ ro marak reno no, jõ tru oh. Nma, anu simaut mase oh!’” ");
INSERT INTO ayz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tna Yesus yawe, “Soh raa sait ro ja yno iro yashana to, malaikat sor kbe simaut mase feto ye. Menohe mfi bo raa mabo 99 mnaut mawe, ‘Ja amu nhaf moof sai, kbe amu nashana fyi!’ Kbe malaikat sor ro mhau mam sawro ro Allah weto to, simaut raa weto fee.” ");
INSERT INTO ayz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tna Yesus yawe, “Soh fai sau mse pitis dirham trion nsaa. Tna soh sau mbtek marak to, kbe au mait tafoh mbo tna saso fea! Tna au moo sapu sabos kaket mam amah tibyo mkai pitis rau reto. ");
INSERT INTO ayz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tna au masen mawe kʼmafoh na msya raa ro mhau kene msya au mawe, ‘Pitis ajõ ro riwai marak reto to, jõ fri oh! Tibyo jõ simaut mase toni! Nma, anu bkyõ bokyõ!’ ");
INSERT INTO ayz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Taja, tme na tawe kʼanu tawe, ‘Raa sait ro ja yno iro to, soh ait yashana, kbe malaikat ro Allah sor simaut toni feto ye.’” ");
INSERT INTO ayz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tna Yesus ykyas bofret sau u yawe, “Raa sait tait yabe ku sme mabo ewok. ");
INSERT INTO ayz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tna ait ro tis fi yawe kʼyaja yawe, ‘Taja, saim kta wanu ro meen nyõ shauk to, noo baro nee kʼjõ mam wore wefo.’ Tna yaja yoo kta rait saim yee ku wait mabo ewok reto. ");
INSERT INTO ayz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ti baro firwas tna ku ro tis fi yoo bo wait msya kta ro yaja saim kʼait beta fo yasim. Yasim yoo pitis tna yasen yamoʼt oo ro fari sau. Ait yamo snok mam teto tna fo ait yno bo kbik-kbak sai. Tibyo sikowah pitis rait. Mrok marak. ");
INSERT INTO ayz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pitis rait reto marak beta tna fo haiawyah frok mama mai mam oo reto beta. Tibyo kair mama mai kʼait. ");
INSERT INTO ayz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tibyo yasen yamo yo kʼraa sait ro yhau mam oo reto. Yamo sryan yno bo rait. Tna bi ait ybis yawe yamo kmot fane bi wait. ");
INSERT INTO ayz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Menohe raa aro moo boit aro mee kʼait yesait yait fee. Tibyo ku ait retait hai sre tna yawe yait boit ro fane mait ye. ");
INSERT INTO ayz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ait hre ynaut bait tna yawe, ‘Sryan ro ja mhau msya taja to, ana mhau to boit mninon. Menohe Jõ thau mam befo thai awyah thai sai! ");
INSERT INTO ayz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Feto kbe tasen tamo to kʼtaja tna tawe kʼait tawe, “Taja, jõ tno iro mai kʼAllah tna mai kʼnyõ ye. ");
INSERT INTO ayz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jõ fi tno-na bo. Feto to nyõ ntu nawe jõ fi ku anyõ u fee. Tawe tamo sryan boh ro tno bo wonyõ sai.”’ ");
INSERT INTO ayz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tna ait yasen hah yamoʼt oo rait. Yamo yo kʼyaja. Ait yama fari fares to, yaja ymat ait yama oh. Tna yatmof ait. Tna yhoh yamo yo ku rait tibyo yake tna hana. ");
INSERT INTO ayz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tna ku retait yawe, ‘Taja, jõ fi tno iro mai kʼAllah ysya nyõ oh. Feto to ntu jõ nawe nare to ma.’ ");
INSERT INTO ayz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Menohe yaja yawe kʼsryan wait yawe, ‘Nmo noo ratan ro moof toni to, nkah nama fooh nse kʼait yyum. Tna noo cincin nse mam yatem. Tna noo sandal nse mam yaa. ");
INSERT INTO ayz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tna ktan sapi ro moof sau. Anu kbe bno bokyõ, tna anu sohmaam tna simaut mase! ");
INSERT INTO ayz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tnaut tawe kbe tmat ku ajõ refi u fee! Tiwya ait yarak menohe jõ tkai ait yama u!’ Feto to ana makyõ bokyõ. ");
INSERT INTO ayz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ku rait ro bum yhau fares mam armato. Tna hah ye yamaʼt amah. Yama kene oh mam samu tna ait yari he raa simaut tna msyoh. ");
INSERT INTO ayz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tna ku ro yabi refi ytu sryan sait yama tna ytu kʼait yawe, ‘Raa mno bawya re samu mnin-nin meto ee?’ ");
INSERT INTO ayz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Menohe sryan retait yawe, ‘Nao ro tiwya yamo tait, hah ye yama oh! Hah ye yama mkah riof. Tibyo naja ktan sapi ro moof sau.’ ");
INSERT INTO ayz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yari feto to, ku yabi fi, kmo tna hawe bo twok mam amah. Tibyo yaja frok mne tna soh-soh kʼait yawe, ‘Ntruk oh!’ ");
INSERT INTO ayz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Menohe ait yawe si kʼyaja yawe, ‘Ja jõ thau tsya nyõ tahun aro rau-rau tno bo wonyõ to. Tna jõ tiwana bo ro nyõ nawe to aro fee. Tna nyõ noo bo aro naren jõ fee. Nyõ nbis kambing sau kʼjõ fee ye re ktan takyõ bokyõ tsya tafoh wojõ na ye. ");
INSERT INTO ayz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tna nare ro tis retait tait yakah kta anyõ to, yamo. Yamo sikowah-kawah ysya fnya ro mwyah to, tna hah yama. Menohe nyõ ktan sapi sau nakyõ bokyõ ro mase naut kʼait u a!’ ");
INSERT INTO ayz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Menohe yaja yawe, ‘Tare, nyõ to ja nhau nsya jõ. Bombra ro jõ tse weto beta to, bo wonyõ oh meto. ");
INSERT INTO ayz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nyõ nao retait, tnaut tawe kbe tmat ait u fee! Tiwya yarak menohe anu be bkai u. Tibyo anu to simaut bkyõ bokyõ kʼait fea!’” ");
INSERT INTO ayz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tna Yesus yawe kuber wAit yawe, “Tkyas raa ro bobot sait. Ait ysok raa sait yamo bendahara, mkah ybo pitis wait tna yisoh bo wait beta. Ti baro firwas tna raa ro bobot retait yari he bendahara retait yisoh bo wait kaket fee, saka sikowah pitis rait. ");
INSERT INTO ayz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tibyo bi ro bobot retait ytu ait yama tna yawe, ‘Bo ro raa mkyas mai kʼnyõ fo mabo fe mfe a? Tawe tusnok nyõ. Jõ hawe bo nyõ nbo pitis wojõ u. Nasen namo nkom daftar sau. Tna nkom pitis ro tii jõ tsan kʼnyõ to mnan si. Tna nkom bo bawya ro nyõ noo mkah pitis wojõ weto beta. Tna fo daftar reto nakah nama nee kʼjõ tmat.’ ");
INSERT INTO ayz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bendahara refi yamo tna ynaut yyi yawe, ‘Bobot ro ybis jõ yawe jõ frok tno bo wait u fee. Kbe tno fyi? Raa taro ja mkah bo, menohe jõ fi ja ttai tkah bo fee. Tna jõ hawe bo tayoh pitis kʼraa. Kbe jõ hrenaut. ");
INSERT INTO ayz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jõ thar iso oh! Tafoh wojõ mawat. Tamo tno bo moof kʼana afo re kbe ati ro bobot ybis jõ tufrok to, kbe ana weto mitrah amah wana kʼjõ!’ ");
INSERT INTO ayz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Raa mawat mno taman kʼbobot retait. Tna bendahara retait ynaut yawe iso ro moof to, kbe ait yno bo ro moof kʼraa weto. Tibyo yno fefo: Ait ytu ana sait-sait yama. Tna yawe, ‘Taman ro bobot retait trion ja fares mhau kʼnyõ to?’ ");
INSERT INTO ayz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Raa ro yama tinyi tait yawe, ‘Taa jõ tayoh minyak zaitun 100 tempayan.’ Menohe bendahara refi yawe, ‘Noo aam ro taman refo tna hre nkom roto ro tna sau. Nkom minyak 50 tempayan sai.’ ");
INSERT INTO ayz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tna bendahara retait ytu kʼait ro ewok yawe, ‘Taman ro bobot retait to trion jya fares mhau kʼnyõ?’ Tna ait ro ewok yawe, ‘Gandum 100 pikul.’ Menohe bendahara retait yawe, ‘Aam ro taman refo, nkom 80 pikul sai.’ ");
INSERT INTO ayz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bendahara retait yno feto kʼraa beta ro mno taman kʼbobot retait. Yno afo re kbe ana weto ksoh ait tna kbe mse ait mam amah mato wana. Tna fo bendahara retait yoo daftar ro ykom reto yakah yamo yee kʼbobot retait ymat. Bobot retait ymat daftar reto tna yhar yawe bendahara retait sioh ait. Menohe bobot retait bibi bendahara retait yawe, ‘Nyõ nhar bo toni sai ee!’” Tna Yesus yawe kʼana yawe, “Raa ro wase Allah to, mhar mno bo ro tabam refo su msya raa anya. Menohe raa ro mhau mam kek to, taro wase bo siwyan ana afo re meen mamo mhau mam sawro ro Allah. ");
INSERT INTO ayz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jõ tkyas kʼanu tawe: ‘Pitis msya kta ro tabam refo to, noo nee kʼraa. Noo pitis msya kta wanu to, nno bo moof kʼraa re kbe ana ksoh anu. Bombra wanu weto mkak rof mam tabam refo. Mkak tna meen Allah yitrah amah rAit kʼanu tna kbe anu nhau nsya Ait mam sawro rAit mamo snok mam hame wajin.’” ");
INSERT INTO ayz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tna Yesus yawe, “Raa sait yoo bo wait kebet baro yee kʼyafoh sait. Tna yasen yamo. Yhau tna hah ye. Hah ye tna ymat he yafoh retait yisoh bo weto, kaket moof. Feto tibyo raa retait yhar yawe soh yoo bombra mawat yee kʼyafoh rait reto kmot, kbe yafoh retait yisoh bo mawat weto kaket moof ye. Feto ye; mfi bo raa sait yoo bo wait kebet baro yee kʼyafoh sait. Tna yasen yamo. Yhau tna hah ye. Hah ye, menohe ymat he yafoh retait yisoh bo weto kaket fee. Ait yno-na sai. Feto tibyo raa retait yhar yawe nno be ait yoo bombra mawat yee kʼyafoh rait reto, kbe yafoh retait yisoh bo mawat weto kaket fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Soh anu nse kta aro mam tabam refo, menohe nno-na kta wanu to, kbe meen raa moo kta ro moof ati aro mee kʼanu fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Soh anu nno-na bosatoh ro raa, kbe raa hawe bo msan bosatoh kʼanu nesait nse.” ");
INSERT INTO ayz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tna Yesus yawe, “Ja sryan sait yno bo ro bobot sait aran sai. Ait yno bo ro bobot mabo ewok brio-brio to fee. Kbe ait knait bi ait sait tna ksoh bi ait sait. Kbe ait yari bo kʼbobot sait kaket, tna yiwana bo ro bobot sait yawe ye. Feto to tawe kʼanu tawe: Awya ybah yno bo ro Allah wAit ye tna saso kta ro tabam refo ye. Anu raa ntai nkro iso ewok weto su fee.” ");
INSERT INTO ayz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Raa ro Farisi to ja masu mase mkah pitis. Ana mari bo ro Yesus ykyas weto beta tna ana sret Ait masah. ");
INSERT INTO ayz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tibyo Ait yawe kʼana yawe, “Anu nksoh nwe raa mmat bo moof ro anu nno. Mmat bo weto tna mnaut mawe anu raa ro nhaf moof. Menohe Allah yhar yawe anu nhaf mato wanu to mkair. Bo ro raa mbibi tna mnaut mawe moof to, Allah ynaut yawe bo weto mkair.” ");
INSERT INTO ayz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tna Yesus yawe, “Tiwya Allah ybis Musa ysya nabi na mama mkom Watum wAit. Mam oon ro tiwya reto mamo snok mam ati ro Yohanes yama to, raa mari Watum weto to, moof. Tna fo Yohanes yama ykyas yawe Allah yamo Raja ybo raa mana rAit. Tna Jõ tsya kuber woJõ mamo wosa Bokyas ro Moof reto. Tna raa mawat mari tibyo ntomer mamo raa ro Allah ybo yfi Raja rana. ");
INSERT INTO ayz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ja raa mnaut mawe ayoh msya tabam refo mhau yum. He mfe: Meen ayoh msya tabam refo saef marak sai. Menohe Watum weto oh mi mhau matak yum. Watum weto to, maja rau sau ro maku to, kbe susre fee. ");
INSERT INTO ayz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Awya sai ro yako fnya rait makus tna yamo ymen fnya rouu to, ait retait raa ro ywyah oh meto. Tna awya ro ymen fai ro raa roto sait yako oh to, ait retait raa ro ywyah ye.” ");
INSERT INTO ayz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tna Yesus ykyas yawe, “Bi ro bobot sait yhau yoof. Ja ait yyum ratan ro mabyoh maut toni. Ratan wait to ro ngknu msya sneh. Ayõ yoyo ait yhau to, ait simaut mkah bo ro ait yse mninon. ");
INSERT INTO ayz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tna raa ro kinyah sait yasom Lazarus yhau ye. Tna raa mse ait hre kene mam amah masa ro bobot refi. Lazarus tait yetsu mbra mabet sor. Tna ait hre yayoh bo sohmaam kʼraa ro mama. ");
INSERT INTO ayz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tna Lazarus haisre toni tibyo ynaut yawe ksoh yait boit makyõ ro mbtek mbam ambar ro bobot retait. Tna mtah mama mkas Lazarus yarak ro mabet ye. ");
INSERT INTO ayz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ti baro firwas tna Lazarus yhai. Tna malaikat sor makah ait mamo mse hre mam yuk ro moof ysya Abraham su. ");
INSERT INTO ayz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tna bobot retait yhai ye. Tna raa sama ait. Bobot retait tait yamoʼt sawro ro kair. Tna mam weto ykai bo ro samyoh. Ait heyut abyõ tna ymat fari, ymat he Lazarus hre ysya Abraham su mam yuk ro moof tno. ");
INSERT INTO ayz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tna bobot retait yawe kʼAbraham yawe, ‘Taja, natmof jõ! Tafoh refo fo, mafit jõ toni oh! Tna srau fo ngkaat oh. Nbis Lazarus beru yatem mam aya tna yama yse mam hrea ajõ!’ ");
INSERT INTO ayz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Menohe Abraham yawe kʼait yawe, ‘Tare, nnaut sai oh: Tiwya naam fares to, nyõ bobot tna nse bombra beta. Tna Lazarus fi ykai bo ro mkair. Reto oh mi mfo refo ait ye yhau moof, tna nyõ ne nhau mam wo mkair riryõn. ");
INSERT INTO ayz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tna bo weto mesait sai fee: Nyõ nhau mam yuk sau hayah tna amu nhau mam yuk sau hayah ye. Hwai mboh sau firwas wa anu. Tibyo raa ro mbam ati reto frit mamaʼt ati refo si fee. Tna raa ro mbam ati refo frit mamoʼt ati reto si fee ye.’ ");
INSERT INTO ayz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tna bobot refi soh-soh kʼAbraham yawe, ‘Feto to nbis Lazarus hah yamoʼt tabam. Nbis yamoʼt amah ro taja. ");
INSERT INTO ayz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tao na wojõ mabo maat mhau fares to. Nbis Lazarus yamo yo kʼana mabo maat weto tna yawe wa kʼana. Ykyas afo re ana misoh ana tna meen ana mamaʼt befo fee. Tna tru kair refo fee ye!’ ");
INSERT INTO ayz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Menohe Abraham yawe, ‘Watum ro tiwya Allah ybis Musa ysya nabi na mkom to mhau fares kʼana. Soh ana mari bo weto to, mnan sai oh.’ ");
INSERT INTO ayz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Menohe bobot retait yawe, ‘Taja, weto mnan fefares! Soh raa ro ja mhai aro mrok masen tna hah me mo kʼana to, tna mawe wa kʼana to, kbe ana mnaut iro wana tna mashana.’ ");
INSERT INTO ayz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Menohe Abraham yawe, ‘Soh ana hawe mari Watum ro tiwya Allah ybis Musa ysya nabi na mkom to, kbe ana mari bo ro raa mkyas to fee ye. Mfi bo ana mmat raa ro mhai mrok masen aro bo to, kbe ana mari raa reto fee ye.’” ");
INSERT INTO ayz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus yawe kuber wAit yawe, “Mam tabam refo fo, bo aro rau tko re raa mno iro. Menohe awya ro yisti re raa mno iro to, meen Allah yno bo ro mkair mama mai kʼait ro yisti retait. ");
INSERT INTO ayz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Meen ait ykai bo ro samyoh toni. Ait ro yisti re raa woJõ sait yno iro to, soh ait ysu mam aya yhai to, moof miwer bo ro meen Allah yno mai kʼait retait! Mfi bo raa mawah fraa ro maboh sau, tna make mam yamyum, tna mbeak ait mam sawan, tibyo ysu to, bo reto to, moof miwer bo samyoh toni ro meen ait ykai. ");
INSERT INTO ayz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Feto to kaket anu!” Tna Yesus yawe, “Soh nafoh sait yno iro to, nastako ait. Tna soh ait yashana to, nhaf ase tna kmo ait ma. ");
INSERT INTO ayz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tna soh yno iro mawat mai kʼnyõ to, tna fo hah ye yama yawe, ‘Riwai tno mkair. Tna tashana.’ Tna ait yfot yatem ysya nyõ to; kmo ait ma, nhaf kair kʼait ma. Soh ait yno iro mai kʼnyõ muhrin krema mam ti sau to, tna yama yawe, ‘Riwai tno mkair. Tna tashana.’ Soh yno feto muhrin krema ye to, kbe ne kmo ait ma.” ");
INSERT INTO ayz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tna kuber ro Tuhan Yesus wAit mawe kʼAit mawe, “Nisoh bosmot wamu re kbe matak.” ");
INSERT INTO ayz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tna Tuhan yawe, “Soh bosmot wanu maku sai, mfi bo makan ro maku sai, anu ntai nno bo ro msai. Kbe anu nwe kʼara sau nwe mamo mros mam sawan to, kbe mabo oh: Kbe ara reto mari tna mamo tu oh.” ");
INSERT INTO ayz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tna Yesus yawe, “Mfi bo bobot sait ysya sryan sait. Tna sryan retait ja ykah bo mam armato ro bobot rait, soh mfe ysia domba ro bobot wait mam smok. Hreha tna sryan retait hah yamaʼt amah to, kbe bobot yawe bawya kʼait? Kbe yawe, ‘Nama fooh, noo boit nait!’ fe mfe a? ");
INSERT INTO ayz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mfe. Kbe ybis yawe, ‘Saruk boit wojõ ro tait to wia, tna nyum ratan ro moof, tna noo boit ro jõ tait, nakah nama! Tait skak wia. Tna fo nyõ saruk boit ro nyõ nait to riryõn.’ ");
INSERT INTO ayz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sryan yno bo ro bobot ybis sai. Tibyo ja bobot yayoh asik mase fee tna ybaut ait fee! ");
INSERT INTO ayz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tawe anu nmo nno bo nfi sryan retait ye. Nri tna nno bo beta ro Allah ybis kʼanu. Tna nwe fefo sai, nwe, ‘Amu fo sryan boh ro Tuhan wAit. Amu nno bo ro Ait ybis kʼamu sai. ⌞Feto to bibi anu ai to ma, shait sai oh.⌟’” ");
INSERT INTO ayz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus yamoʼt Yerusalem. Tna iso ro yamo to, mamo mam rabin ro Samaria msya provinsi ro Galilea masuf. ");
INSERT INTO ayz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ait twok mam remo sau fo, raa sme mabo nsaa ro mafa kusta to masen mama mo kʼAit. Ana mama kene msya Ait fee. Ana mros fari ");
INSERT INTO ayz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tna mkah mai ro mase ana soh-soh kʼYesus mawe, “Guru; natmof amu!” ");
INSERT INTO ayz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus ymat ana tna yawe, “Nmo nerif netsu wanu kʼimam na re ana mha ninin anu netsu wanu wia. Ana mha ninin netsu wanu afo re ana mhar mawe anu nrok noof oh.” Tna ana mamo. Mamo sai mam iso fares fo, kusta wana mrok marak. Ana mrok moof beta. ");
INSERT INTO ayz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ana wefo sait, ati ro ymat he ait yoof to, ait hah ye yamo yo kʼYesus tna ybaut Allah mkah ymai ro mase. ");
INSERT INTO ayz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ait yama snok Yesus tna yaka mte hartu Ait. Tna yasu heyut yawe, “Asik mase kʼNyõ oh!” Ait retait raa ro ybam rabin ro Samaria. ");
INSERT INTO ayz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tna Yesus yawe, “Riwai Jõ tisoh raa mabo nsaa, fe mfe a? Ro mabo krenjiit taro to miyo? ");
INSERT INTO ayz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Fyi re raa ro srim refi yesait aran hah yama tna ybaut Allah? Ana mabo ngkrenjiit to miyo?” ");
INSERT INTO ayz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tna Yesus yawe kʼait refi yawe, “Bosmot anyõ misoh nyõ. Nasen nros tna namo oh. Riof kʼnyõ.” ");
INSERT INTO ayz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Raa ro Farisi baro masen mtu bo kʼYesus. Ana mtu bo oon ro meen Allah yamo Raja ybo raa mana rAit. Ana mtu fyi re kbe ana mhar oon reto mama oh meto. Tna Yesus yawe, “Raa baro mnaut mawe, kbe raa masu mmat bo ro msai toni aro frok mam ati ro oon reto mama. He mfe. ");
INSERT INTO ayz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tna kbe raa sioh mawe, ‘Oon rAit mama mefo!’, fee ye. Tna kbe raa sioh mawe, ‘Au mno!’, to, fee ye. Menohe nri oh! Jõ tama thau tsya anu raa oh mefo. Jõ oh mi siwyan iso re raa mamo mo kʼAllah tna Ait yamo Raja ybo ana to.” ");
INSERT INTO ayz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tna Yesus yawe kuber wAit yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen kair mama mai kʼanu. Feto to, mam oon ro mama to, kbe anu ninaut nwe, ‘Tija oh mi Ait hah ye yama fo?’ Menohe kbe anu nmat Jõ mam ati reto fee. ");
INSERT INTO ayz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ati ro raa mawe kʼanu mawe, ‘Nmat, Ait mefi!’ Soh mfe, ‘Ait mne!’ Nri ana ma! Nhoh nmo nmat ma! ");
INSERT INTO ayz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ati ro 'Ait ro Yroh Yama Yfi Raa Sai' hah yama to, hah yama yfi rir ro mrir mam ayoh. Kbe raa beta mmat, mnan mfi bo rir ro mrir skentrat mamo mai jaro-jaro. ");
INSERT INTO ayz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jõ fi meen hah tama u. Hah te tama mun ro ewok fefares to, Jõ thau mam tabam refo wia. Tna raa mno bo ro mkair-kar mawat mai kʼJõ. Tna raa ro mfo refo mhau to mikyak Jõ wia.” ");
INSERT INTO ayz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tna Yesus yawe, “'Ait ro Yroh Yama Yfi Raa Sai' meen hah ye yama. Ye yama to, kbe raa mhau mno bo wana mnan si wore wo tiwya Nuh yhau: ");
INSERT INTO ayz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ati reto to, raa sohmaam bo tna mmen fnya bo to, snok mam ati ro Nuh twok mam wiak aken rait to. Tna bo maboh mama tubor: Aya mabo mbetru ana msu beta. ");
INSERT INTO ayz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wore wo Jo hah tama to, kbe raa mhau mno bo wana to mnan si wore tiwya Lot yhau: Raa sohmaam bo, moo bo tna masim bo wana, mhais maso tna sawyah samu bo to. ");
INSERT INTO ayz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ati ro Lot frok ybam Sodom to, bo maboh mama tubor: Tafoh msya belerang mroh mbam ayoh, tna mait ana beta mam beto.” ");
INSERT INTO ayz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tna Yesus yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen Jõ hah tama to, kbe raa mhau mno bo wana mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tawe: Ati ro Jõ hah tama to, soh anu sait hre abyõ mam samu anyõ kri-kri to, kbe nroh satoh bo wonyõ mbam amah mato nbo frok to ma! Tna soh anu sait nkah bo mam armato kri-kri to, hah ne namoʼt samu anyõ to ma. ");
INSERT INTO ayz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nnaut bo ro Lot yfain mno! ");
INSERT INTO ayz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tawe kʼanu tawe: Raa taro tomer mawe mhau bana moof mam tabam refo. Tna ana kro Jõ fee. Ana weto meen mhau hame wajin fee. Menohe raa taro mhau bana moof fee. Ana kro Jõ. Ana kro Jõ ebokfi raa sikowah ana. Ana weto oh mi meen mhau hame wajin. ");
INSERT INTO ayz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Meen Jõ hah tama tabam refo to, mti reto to, raa mabo ewok mjin mam ambar sau. Kbe malaikat woJõ mroh tubat sait tna sait yhau akus. ");
INSERT INTO ayz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tna fnya mabo ewok hre mmuk gandum make su to ye. Kbe malaikat woJõ mroh tubat sau tna sau mhau akus ye.  ");
INSERT INTO ayz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Raa mabo ewok mhais bo to, kbe Ait tubat sait, tna sait yakus.” ");
INSERT INTO ayz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tna kuber wAit mawe, “Bo weto kbe mabo mam woyõ?” Tna Yesus yawe, “Yuk ro bo mhai tna mhau akus to, kbe ruu hofyoh fru mama hre mam weto ye. ⌞Tna mam wore wo raa mno bo mkair-kar toni to, kbe meen Allah ymit safo kʼana weto mam yuk reto ye.⌟” ");
INSERT INTO ayz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus ykyas bofret sau. Ykyas afo re ana mur-mur skabuk yoyo, yawe ana bitsre skabuk ma. ");
INSERT INTO ayz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ait yawe, “Bi yabi sait yhau mam remo sau. Ait yamo raa ro ja ytu srah. Bi ait retait wase Allah. Tna ait ymat raa anya to kaket fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tna semit sau mhau mam remo reto ye. Tna rabu wawa au mamo mo kʼait mawe, ‘Raa sait yno bo mkair mai kʼjõ. Nama nros nsya jõ tna saak safo ajõ.’ ");
INSERT INTO ayz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Menohe bi yabi retait yikyak au. Ti baro kait ait hawe bo yari au. Tna ti sau ait ynaut yawe, ‘Jõ waa Allah fee, tna ja tari bo kʼraa anya fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Menohe semit refo ja mama mkyas srah rau kʼjõ yoyo. Feto to jõ saak safo rau rof. Be kbe au mama mrit jõ yoyo to ma, tna mno jõ hrowyõ to ma.’” ");
INSERT INTO ayz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tna Yesus yawe, “Ait ro ytu srah retait ja yhaf moof fee. Menohe nri bo ro yawe: Yawe kbe ait saak safo rau. ");
INSERT INTO ayz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Nnaut oh: Kbe Allah yros ysya raa wAit, tna saak safo rana ye. Anu nnaut nwe kbe bi Ait hre kait tna hawe bo yari boyoh raa wAit fe mfe a? Mfe, ana mayoh bo kʼAit yoyo to, Ait ja yari boyoh wana weto fooh. Tna ttu bo kʼanu tawe, Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Kbe Jõ hah tama tabam refo u. Tama u to, kbe Jõ tkai raa ro beroh smot Jõ fares aro to fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Raa ro mros mari Yesus ykyas bo to, ana taro raa ro safuk mnaut mawe ana mesait aran mno bo ro moof. Ana ja miwana raa roto mnaut mawe, “Ana weto mno bo ro moof mnan si amu to fee.” Yesus ykyas bofret kʼraa weto yawe, ");
INSERT INTO ayz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Raa mabo ewok mamoʼt Samu ro Allah mawe skabuk. Ait sait raa ro Farisi tna sait raa ro yoo namabyoh (pajak). ");
INSERT INTO ayz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tna ait ro Farisi fi yros tna skabuk ait yesait yawe, ‘Jõ tayoh asik mawat kʼNyõ tawe jõ tnan fi raa ro mno bo mkair fee: Jõ tsyõf bo fee, jõ tno bo ro mkair fee, jõ raa ro twyah fee, tna jõ tfi ait ro yoo namabyoh refi fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hari minggu sau jõ tiyas boit ro tait muhrin ewok. Tna bombra ro jõ too to, tsan sepersepuluh kʼNyõ.’ ");
INSERT INTO ayz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Menohe ait ro ja yoo namabyoh retait yros bait fari tna yanwaruk, tna yai yatmato skabuk yawe, ‘Allah natmof jõ ye, jõ fi raa ro tno iro.’” ");
INSERT INTO ayz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tna Yesus yawe, “Ait ro ja yoo namabyoh retait skabuk mkak tna yasen yamo bait. Tna ait ro Farisi retait skabuk mkak tna yasen yamo bait ye. Tkyas kʼanu tawe: Allah ymat ait ro yoo namabyoh retait tna yawe ait raa ro yhaf moof. Menohe Allah ymat raa ro Farisi retait tna yawe ait raa ro yhaf moof to fee. Awya ro safuk yawe ait u kar to, kbe Allah yno ait haberek yamo raa kinyah. Tna awya ro yamo raa kinyah to, kbe Allah yno ait haberek yamo raa ro mase riryõn.” ");
INSERT INTO ayz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tna raa mbo kukek wana mama mo kʼYesus. Ana mama re kbe Ait yse yatem abyõ kukek wana tna skabuk re Allah yno bo ro moof kʼana. Kuber ro Yesus mmat feto, tna ana mastako raa weto. ");
INSERT INTO ayz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Menohe Yesus ytu kukek weto mama. Tna yawe kuber wAit yawe, “Nitsre ku kinyah weto mama mo kʼJõ. Nwe wa ana to ma! Raa ro mama mo kʼJõ mfi kukek wefo fo, mhaf wana to, Allah ksoh. Ana oh mi mamo raa mana ro Allah yamo Raja ybo to. ");
INSERT INTO ayz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Menohe, Jõ tawe, Awya ro hawe mama mo kʼJõ mfi kukek wefo fo, kbe ana masen mamo raa ro Allah yamo Raja ybo to fee.” ");
INSERT INTO ayz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bobot sait yamo raa manes, ja ybo raa mam remo rait. Tna ait ytu kʼYesus yawe, “Guru; Nyõ fi raa ro nhaf moof! Jõ kbe tno bo bawya re kbe meen Allah yno jõ thau hame wajin?” ");
INSERT INTO ayz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tna Yesus yawe, “Fyi re nyõ nawe Jõ fi raa ro thaf moof? Raa aro mhaf moof fee. Allah yesait aran sai yhaf rAit moof. ");
INSERT INTO ayz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nyõ nhar watum ntraa ro tiwya Allah ybis Musa ykom yawe raa wAit mari tna mno. Au oh mefo: ‘Nwyah ma! Name ajat ma! Nsyõf bo to ma! Siroyõ ma! Nmat nja msya nme na to kaket!’” ");
INSERT INTO ayz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Raa manes retait yawe, “Bosi weto tiwya taban tkek fares to, tno beta oh.” ");
INSERT INTO ayz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus yari feto tna yawe, “Bo sau nyõ nno fefares to: Namo nasim kta wonyõ beta. Tna nsaim pitis weto kʼraa ro bo marak. Soh nno bo reto to, nyõ name kta mam sawro ro Allah oh meto. Tna fo nama nkro Jõ.” ");
INSERT INTO ayz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ait retait bobot toni. Tibyo yari bokyas ro Yesus reto to, ait srau hri. ");
INSERT INTO ayz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus ymat ait tna yhar yawe ait sraujin. Tna yawe, “Raa ro bobot masen mamo raa ro Allah yamo Raja ybo to, min toni syok. ");
INSERT INTO ayz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kak unta maboh sau tomer twok mam sii hren soo to, mnan-nan baro ye. Menohe raa ro bobot tomer yamo raa ro Allah yamo Raja ybo to min toni.” ");
INSERT INTO ayz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tna raa ro mros mari bokyas ro Yesus ykyas reto mtu kʼAit mawe, “Soh feto to, raa awya meen ykai riof?” ");
INSERT INTO ayz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus yawe, “Anu raa nesait ntai nno riof kʼanu fee. Menohe Allah yno riof kʼanu saah. Ait ytai yno bo bawya sai.” ");
INSERT INTO ayz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tna Petrus yawe, “Amu wefo nsen sikba bombra wanu beta afo re nma kro Nyõ oh.” ");
INSERT INTO ayz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus yawe, “Ae, nnaut: Raa baro ntomer masen mamo raa ro Allah yamo Raja ybo. Ana mawe bo ro ati toni meto. Tna Allah ybis ana mamo mno bo wAit to, tibyo sikba samu rana, sikba mfain, mao, maja, mme, kukek wana bo to, Allah ymat. ");
INSERT INTO ayz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Kbe ana weto mkai bo weto mninon renti mam tabam refo, tna meen mkai roon ro hame ye.” ");
INSERT INTO ayz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus ytu kuber wAit mabo 12 weto, yawe ana mesait mama siret su. Tna yawe, “Tiwya Allah ybis nabi wAit mama mkom bombra ro kbe btek mai kʼJõ. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Anu bmoʼt Yerusalem mefo. Anu snok mam Yerusalem to, bo ro btek mai kʼJõ to, mnan si bo ro nabi na mkom wia weto. ");
INSERT INTO ayz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ana mkom mawe kbe raa moo Jõ msan kʼraa ro wase Allah. Kbe ana mamus Jõ, mno bo mkair kʼJõ, tfeh oot kʼJõ, ");
INSERT INTO ayz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tna moo too mmok-mak Jõ, tna kbe ana mame Jõ tajat ye. Tna ti ro tuuf to, kbe Jõ trok tasen.” ");
INSERT INTO ayz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bokyas rAit reto to, kuber wAit aro mhar kbet fee ye. Maja rau to Allah yno re ana mnaut fee. Ana wase mawe, “Ait ykyas bawya sai meto ee?” ");
INSERT INTO ayz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus yama kene snok mam kota ro Yerikho, tna raa ro yasu mboh sait hre mam iso yayoh bo. ");
INSERT INTO ayz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Raa retait yari he raa mawat frit tna ytu yawe, “Bawya meto?” ");
INSERT INTO ayz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tna raa mawe, “Yesus ro ybam Nasaret frit iti metait.” ");
INSERT INTO ayz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tibyo ait ro yasu mboh retait ytu yawe, “Yesus, Ku ro Daud; natmof jõ!” ");
INSERT INTO ayz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Raa ro mamo msya Yesus to kmo bhah ait mawe, “Shait!” Menohe ait beroh ytu fari renti yawe, “Ku ro Daud, natmof jõ!” ");
INSERT INTO ayz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tna Yesus yros tna ybis yawe raa mbo ait ro yasu mboh retait mbo mama mo kʼAit. Yama, tna Yesus ytu kʼait yawe, ");
INSERT INTO ayz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nyõ nksoh nawe Jõ tno bawya kʼnyõ?” Tna ait yawe, “Tuhan; jõ ksoh tmat bo ye!” ");
INSERT INTO ayz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tna Yesus yawe, “Soh feto; tbis tawe, ‘Nmat bo oh!’ Bosmot anyõ misoh nyõ meto.” ");
INSERT INTO ayz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mam weto si fo, ait yrok yasu maah tna ymat bo. Tna yasen kro Yesus yamo. Yamo tna bibi Allah. Tna raa mawat mmat bo reto ye. Tibyo ana bibi Allah ye. ");
INSERT INTO ayz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus ⌞ysya kuber wAit mamo kri-kri mam iso ro Yerusalem.⌟ Tna mam iso maka to, ana snok mam kota ro Yerikho. ");
INSERT INTO ayz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tna bobot sait yasom Zakheus yhau mam beto. Ait fi raa ro yamo pegawaipemerintah ro Roma tna ait aban mana pegawai taro sor ro moo namabyoh (pajak). ");
INSERT INTO ayz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ait fi raa ro yabuf. Raa mawat mama mmat Yesus. Tna bi Zakheus tomer yawe ymat Yesus ye. Menohe raa msis-sas mburut wa ait tibyo ymat Ait fee. ");
INSERT INTO ayz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tibyo ait yhoh yatim mam iso ro Yesus yamo reto, tna yaut mam ara sau tna hre abyõ mam uu. Ait hre abyõ mam uu tna ymat Yesus yamo mam te. ");
INSERT INTO ayz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus snok mam ara mair refo tna heyut ymat mam ara refo abyõ tna ymat Zakheus, tna yawe, “Zakheus, nroh fooh! Ayõ refo Jõ tawe tama hre iti mam amah anyõ.” ");
INSERT INTO ayz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakheus yroh fooh tna ymen Yesus yamoʼt amah rait. Ymen Yesus feto, Zakheus simaut mase. ");
INSERT INTO ayz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Menohe raa msis-sas weto mmat feto tibyo mmai kinya mawe, “Ait yhau mam amah raa ro ja yno iro rait!” ");
INSERT INTO ayz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ana mbewok hre mkyas bo tna Zakheus yawe yisoh bo mkair ro tii yno. Tibyo yasen yawe, “Tuhan; kta wojõ to, kbe jõ saim hariyah jaro tee kʼraa kinyah. Tna pitis namabyoh ro raa moo mee kʼpemerintah to, tiwya jõ too pitis hair to, jõ too mabyoh mnan si fee. Tawe kbe jõ tisya pitis reto kʼraa. Tisya tna too taro tur ye kʼraa weto muhrin jiit naut.” ");
INSERT INTO ayz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tna Yesus yawe kʼait yawe, “Ayõ refo raa ro mhau mam amah anyõ refo mkai riof ro mase. Nyõ fi nbam raa mana ro Abraham wait ye. ");
INSERT INTO ayz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tna Jõ tama saso raa ro mamo marak amo, tna tno re ana mkai riof ye.” ");
INSERT INTO ayz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tna Yesus hre iti mam amah ro Zakheus mam Yerikho fares. Yerikho to kene mam kota Yerusalem. Tna raa mnaut mawe oon ro Allah yamo Raja ybo raa mana rAit to, kbe mama fooh. Ana mnaut mawe ati ro Yesus yamoʼt Yerusalem to, kbe mabo rauk. Tibyo Yesus ykyas bofret sau afo re misoh bonaut wana ro sre meto. ");
INSERT INTO ayz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yawe, “Bobot sait ksoh yawe yamo gubernur ro ybo rabin rait. Feto to, ysaim yawe kbe yamoʼt oo ro fari yo kʼraja ro ybo rabin weto beta. Yamo yayoh kʼraja retait yawe afo re ybis ait yamo gubernur mam rabin rait ro ja yhau. Tna fo kbe hah ye yama ybo raa ro mhau mam rabin rait ro ja yhau. ");
INSERT INTO ayz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bobot retait yasen yamo fefares to, ait ytu sryan wait mabo trion nsaa mama mo kʼait. Tna yawe kʼana yawe, ‘Kbe jõ tamoʼt oo ro fari. Tamo tna thau kait baro mam teto. Wore wo jõ tarak fares to, tawe anu nhau nisoh bo wojõ kaket wea. Jõ too pitis trion nsaa refo tna saim sau kʼanu aro sait-sait. Tawe tfyah pitis wefo makit renti.’ Tna bobot retait yasen yamo. ");
INSERT INTO ayz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Menohe raa ro rabin rait ro ja yhau to, knait bobot retait. Tibyo ana mbis raa baro mamo mo kʼraja retait mam oo ro fari reto ye. Mbis raa weto mamo mawe soo kʼraja retait mawe, ‘Amu hawe bobot retait yamo gubernur!’ ");
INSERT INTO ayz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Menohe mam oo ro fari reto raja retait yari ana fee. Ait ybis yawe bobot retait yamo gubernur mam rabin rait reto. Bobot retait yhau kait mam teto tna yasen hah ye yamaʼt rabin rait ro ja yhau. Snok mam amah rait to, tna ytu sryan wait mabo trion nsaa weto mama mo kʼait. Tna ait ytu pitis ro tiwya ait fyah kʼana weto, yawe, ‘Anu tru amot mafer renti aro fe mfe a?’ ");
INSERT INTO ayz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sryan ro tinyi yama tna yawe, ‘Bobot, jõ fyah pitis anyõ reto, tna taru amot rau trion nsaa.’ ");
INSERT INTO ayz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bobot retait yawe, ‘Nyõ nno bo ro moof oh! Taa nyõ mur-mur nno bo wojõ ro maku to, nisoh nno moof. Feto to jõ teta nyõ namo raa ro nase nasen nbo kota trion nsaa.’ ");
INSERT INTO ayz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sryan ro ewok yama tna yawe, ‘Bobot, jõ fyah pitis anyõ reto tna tru amot rau trion maat.’ ");
INSERT INTO ayz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bobot retait yawe, ‘Moof. Feto to, jõ teta nyõ namo raa ro nase nasen nbo kota trion maat ye.’ ");
INSERT INTO ayz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tna sryan ro tuuf yama yawe, ‘Taja, pitis anyõ mefo. Tii jõ too hawee sau tna sro pitis anyõ, tse mam amah sai. Jõ te tamo tno mafer renti aro fee. ");
INSERT INTO ayz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jõ twaa kʼnyõ. Tnaut tawe nyõ fi raa ro ja safo triar. Nyõ safo triar tna noo baah raa tna naru amot mawat. Nno mkah bo manhai anyõ fee. Ja nyõ nryoh kake mam armato ro nyõ nyum fee.’ ");
INSERT INTO ayz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tna bobot retait kmo. Tna yawe kʼait yawe, ‘Bokyas anyõ reto mnan si. Mkah bawya nyõ hawe nisoh bo wojõ mamyot bo ro tawe! Nyõ nno mkair meto! Nyõ fi sryan ro nkair. Riwai nyõ nawe jõ saso amot mkah bo manhai ajõ fee. Tna nawe jõ tryoh ara make ro jõ tyum fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Menohe nyõ noo pitis ajõ nisoh re noo mafer mawat fee! Rau ro moof to, nyõ noo pitis ajõ reto nee kʼraa re ana misoh tna mafer mawat! Nno feto re kbe jõ tama tru pitis reto mkah amot rau!’ ");
INSERT INTO ayz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tna bobot retait yawe kʼraa ro mros mam weto yawe, ‘Ntak pitis ajõ mbam sryan retait yatem. Tna noo nee kʼsrian ro ybo pitis nsaa retait!’ ");
INSERT INTO ayz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Menohe ana ro mros mam weto mawe, ‘Bobot; raa retait ybo pitis nsaa oh!’ ");
INSERT INTO ayz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tna bobot retait ykyas kʼana yawe, ‘Tawe: Awya ro yisoh bo wait kaket moof, kbe raa moo bo taro naut miryõ kʼait ye. Menohe awya ro hawe yisoh bo rait kaket to, kbe raa mrof moo bo rait ro yse weto beta mkak. ");
INSERT INTO ayz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tna tawe nmo nfot raa ro mamo byoh, ro mawe ana hawe bo jõ tamo raja tbo ana to. Nmo nfot ana beta, nbo nma, tna nme ana mam befo re jõ tmat mkah tasu ajõ ye.’” ");
INSERT INTO ayz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus ykyas bo weto mkak, tna fo yasen yamo. Ait ysya kuber wAit mamo mam iso ro Yerusalem fares. ");
INSERT INTO ayz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tna ana snok remo ro Betfage msya remo ro Betania. Remo weto mhau mam Faut ro Zaitun. Tna Yesus ybis kuber wAit mabo ewok matim wia. Ait yawe, ");
INSERT INTO ayz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ntim wia, nmoʼt remo reto. Tna twok nmo to, kbe nkai keledai maku sau raa make mros wea mam weto. Keledai maku reto raa maut hre mam uu fefares. Nmo skur keledai reto tna nkuk nma. ");
INSERT INTO ayz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Soh raa mtu bo kʼanu mawe, ‘Anu skur keledai reto mkah bawya?’ Anu nwe kʼana nwe, ‘Tuhan ybis.’” ");
INSERT INTO ayz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tibyo ana mbewok mamo tna mmat mnan si bo bawya ro Yesus riwai ykyas kʼana. ");
INSERT INTO ayz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ana skur kri-kri fares, tna raa ro keledai rana mama mtu kʼana mawe, “Anu skur keledai ramu reto mkah bawya?” ");
INSERT INTO ayz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ana mawe, “Tuhan ybis.” ");
INSERT INTO ayz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ana mkuk keledai reto mamo mee kʼYesus. Tna mrus jubah wana mnin keledai kbor. Tna mse Yesus hre abyõ. ");
INSERT INTO ayz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ana mamo renti. Mamo mam iso tna raa tom jubah wana ntar-tar anya mam iso iti. Tna Yesus ykah keledai yber iti yamo yamo. ");
INSERT INTO ayz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kene wo frok mam Yerusalem to, iso ro ana mamo reto mroh mbam faut ro Zaitun. Tna raa mawat ro ja kro Ait mamo mtar Ait. Raa weto tii mmat bo msai sor ro Yesus yno. Tibyo ana bibi Allah mkah mai ro mase. Tna ana smar-smar mtar-tar Ait mamo ye. ");
INSERT INTO ayz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ana mawe kʼYesus mawe, “Nyõ nase toni! Nyõ fi Raja ro nama mkah Tuhan yatak rAit! Nyõ nama mam Tuhan yasom! Kbe Nyõ nisoh iranya raa msya Ait! Nbaut Allah ro yhau mam sawro rAit!” ");
INSERT INTO ayz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Raa ro Farisi baro ro mmat feto mawe, “Guru; nbis raa ro kro Nyõ weto shait!” ");
INSERT INTO ayz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Menohe Yesus yawe, “Soh tbis ana wefo shait to, kbe fraa wofo masen mmai. Mtu mawe, ‘Ait retait Raa ro yase! Nbaut Ait oh!’” ");
INSERT INTO ayz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus snok mam Yerusalem makit rau to, Ait sraujin tna yawia. ");
INSERT INTO ayz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tna yawe, “Jõ ksoh tawe anu ro nhau mam Yerusalem to nhar nwe Jõ tama afo re tisoh iranya wanu nsya Allah. Menohe anu hawe nri bo ro Jõ tawe. Tibyo kbe anu aro srau fee. Kbe anu nhar bo ro Jõ tno reto fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Raa ro mamo byoh kʼanu to meen mama. Mama mros mur mbusyit anu. Tna kbe masen frok sker mam jaro-jaro. ");
INSERT INTO ayz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kbe raa sbe mame anu msya kukek wanu. Tna ana misasi amah wanu. Tibyo bofir (tembok) ro amah wanu to, smut frut-frat beta; sau mhau mros fee. Allah yama yawe sotak iro wanu, menohe anu wase Ait. Tibyo bo ro mkair weto kbe mama mai kʼanu.” ");
INSERT INTO ayz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus yamoʼt Samu ro Allah. Ait twok Samu reto bohra rau, tna ymat he raa hre masim bo wana. Tna Ait yhaf aya yasen yikyak ana. ");
INSERT INTO ayz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yawe, “Bokom ro Allah mawe, ‘Samu aJõ fo mkah bo raa skabuk. Menohe anu nma sikowah Samu refo sai!’” ");
INSERT INTO ayz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Rabu wawa Yesus ykyas bo mam Samu ro Allah. Tna imam manes ro agama Yahudi, msya guruagama, msya raa mabi taro sor to, saim mawe mame Ait yajat. ");
INSERT INTO ayz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Menohe raa taro sor beta mari bokyas rAit tna kbo matak. Tibyo raa manes weto mkai iso ro mame Ait aro fee. Ana mnaut mawe kbe raa weto hafrah. Ana hawe bo mno raa kmo. ");
INSERT INTO ayz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ti sau Yesus betoo watum ro Tuhan tna ykyas Bokyas ro Moof (Injil) mam Samu ro Allah. Ykyas bo to, raa manes ro agama Yahudi mama: Imam manes, guru agama, msya raa mabi wana ye. Ana mama tna mtu bo kʼAit mawe, ");
INSERT INTO ayz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Awya oh mi ybis Nyõ, re Nyõ nama nno bo wefo fo? Tna awya oh mi yoo yatak rait yee kʼNyõ fo?” ");
INSERT INTO ayz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus yawe, “Feto Jõ ttu si bo sau kʼanu ye, tawe: ");
INSERT INTO ayz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes Pembaptis, Ait retait raabis ro Allah fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Raa manes weto mkyas kʼanya mawe, “Soh bwe Allah oh mi ybis ait to, kbe Yesus yawe, ‘Feto tna fyi re anu ntu sioh bo ro Yohanes yawe?’ ");
INSERT INTO ayz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Raa wefo mnaut mawe Yohanes tait nabi ro Allah ybis yama. Feto soh anu bwe raa sai ybis ait to, kbe raa makin kmo. Tibyo moo fraa mai anu bjat!” ");
INSERT INTO ayz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Feto to ana mawe kʼYesus mawe, “Amu wase ye.” ");
INSERT INTO ayz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tna Yesus yawe, “Feto Jõ ye te tkyas tatak aJõ ro tno bombra wefo kʼanu fee.” ");
INSERT INTO ayz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tna Yesus ykyas bofret kʼana yawe, “Bobot sait yyum anggur mara mawat mam tabam rait. Tna ait ybis raa baro yawe ana mkah tna kmot armato anggur rait reto wea, kwiyat kʼana. Ait yawe kbe ana moo make rau to, saim baro hayah kʼait. Tna bobot retait yasen yamoʼt oo roto. Ait yhau mam teto kait. ");
INSERT INTO ayz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tna soo ro anggur mara wait weto make manes to, bobot retait ybis sryan rait sait hah yamoʼt tabam rait, yamo yo kʼraa ro kmot armato reto. Bobot retait ybis sryan retait yawe, ‘Nkyas kʼana ro kmot armato ajõ nawe ana mryoh anggur make aro moo mee kʼnyõ. Tna noo anggur make weto nakah nama nee kʼjõ.’ Tna sryan retait yasen yamo. Yamo snok mam armato ro bobot rait reto. Menohe raa ro kmot armato weto to huwya mai sryan retait. Ana mikyak ait. Tibyo ait hah ye ybo anggur aro fee. ");
INSERT INTO ayz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Feto to bobot retait ybis sryan rait roto sait u yamo. Sryan ro ewok retait yamo. Yamo snok mam armato ro bobot rait reto tna raa ro kmot armato reto huwya mai ait ye. Ana mamus ait ye tna mikyak ait. Tibyo hah ye yamo tna ybo anggur aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tna bobot retait yasen ybis sryan rait ro tuuf yamo u. Menohe raa mai ait tna yakah yaaf. Tna ana kmo wer mikyak ait mnan ana mbewok ro tinyi ye mawe, ‘Hah namo tno!’ ");
INSERT INTO ayz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tna bobot retait ynaut yawe, ‘Kbe tno bawya u? Tnaut tawe tbis ku ajõ ro tksoh refi yesait yamo rof. Kbe ana waa ait tibyo mmat ait rauk.’ Tna ku ait yasen yamo. ");
INSERT INTO ayz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Menohe raa ro kmot armato anggur reto mmat he ku ait yama. Tna ana mkyas kʼanya mawe, ‘Ait ro meen shauk armato refo yama mefi! Ait refi yhau ma! Nma, anu bme ait yajat to, afo re meen armato refo mhau kʼanu!’ ");
INSERT INTO ayz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tibyo ana mfot ait mkuk makah mamoʼt armato mne tna mame ait yajat.” Tna Yesus ytu yawe, “Bobot ro armato rait retait kbe yno bawya kʼana ro kmot armato reto? ");
INSERT INTO ayz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kbe ait yama yame raa weto tu. Tna ysan armato anggur reto kʼraa roto taro.” Ana mabi ro agama Yahudi mari feto, tna mawe, “Aha! Mfe!” ");
INSERT INTO ayz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Menohe Yesus ymat ana tna yawe, “Nnaut Bokom ro Allah far-far refo: Fyi re Bokom ro Allah mkyas bo refo? ‘Raa saso fraa mawe sgi samu sau. Ana mmat fraa sau mawe mkair. Fraa reto to, ana hawe. Tibyo moo mbeak makus. Menohe ana wase bo fraa reto oh mi fraa ro ati.’ ");
INSERT INTO ayz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Awya ro mbtek yai abyõ mam fraa reto to, kbe sasyoh. Tna awya ro fraa reto mbtek mai to, kbe rarin-raran ye.” ");
INSERT INTO ayz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Guruagama msya imam manes weto mhar mawe Yesus ykyas bofret reto ykyas mai kʼana. Tibyo ayõ reto ana saim iso re kbe mfot Ait. Menohe ana waa mfot Ait mam wore raa makin mmat. Ana mnaut mawe kbe raa weto kmo ana. Tibyo mfot Ait tetara mam weto fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Raa manes ro agama Yahudi mmat tan bo ro Yesus yno. Mnaut mawe iso ro moof to, soh ana mari Ait ykyas bo aro ro sre to, kbe ana mamo misisi bo reto kʼgubernur.Gubernur retait, raa ro Roma, tna ait yase re kbe yoo safo mana ymit kʼYesus. Feto tna raa manes weto mbis raa baro, mawe ana mamo ti te kro Yesus tna mari bo ro yawe. Mbis mawe ana mamo wan-wan mfi raa ro mhaf moof tna mtu bo baro kʼAit. ");
INSERT INTO ayz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tibyo raa weto mamo mo kʼYesus mawe, “Bi Guru; amu nhar nwe bo beta ro Nyõ nkyas to, bo mabo. Nyõ nkyas bo ro Allah ybis yawe anu bno, nkyas mnan si. Tna Nyõ waa raa ro manes fee. Nyõ beroh nkyas bokyas ro Allah kʼawya sai. Tna iso ro Allah to, ja Nyõ nerif abyõ kʼraa to, nmyõt bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Feto to amu ntu bo kʼNyõ nwe: Allah ksoh yawe anu mbero namabyoh (pajak)kʼKaisar fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Menohe Yesus yhar yawe ana mamo wan-wan sai. Tna yawe, ");
INSERT INTO ayz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Noo pitis mauf sau nee kʼJõ tmat wia. Gambar refo fo msya awya yasom rait mefo?” Ana mawe, “Kaisar.” ");
INSERT INTO ayz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tna Yesus yawe, “Soh feto, bo bawya ro Kaisar rait to, noo nee Kaisar. Tna bo bawya ro Allah rait to, noo nee kʼAllah.” ");
INSERT INTO ayz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Raa mawat mros mari bo ro Yesus ykyas weto. Tna bo ro ykyas to, yweh kbet fee. Tibyo raa ro mamo byoh weto mrok shait sai tna miskawowo mari bokyas ro Yesus reto. ");
INSERT INTO ayz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tna fo raa ro Saduki baro mama mo kʼYesus. (Raa ro Saduki to raa ro agama Yahudi ye, menohe ana ja mnaut mawe raa ro mhai to, meen me mrok masen fee.) ");
INSERT INTO ayz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ana mtu kʼAit mawe, “Bi Guru; tiwya Musa ykom yawe, ‘Soh raa sait yhai tna ait sano. Semit reto kbe yao kro mkah yabe ku aro mkah shauk biin ait ro yhai retait.’ ");
INSERT INTO ayz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tna amu ntu bo kʼNyõ nwe: Mfi bo raa sme mabo ngkrema mao kʼanya mhau. Tna ro bum ymen fai sau, he ait sano tna yhai. ");
INSERT INTO ayz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tna ait ro ytan kro semit rana. Menohe ait sano tna yhai ye. ");
INSERT INTO ayz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Feto ye yao ro tuuf yama kro semit rana naut menohe yabe ku aro fee ye. Feto ye mnan anya sai mamo snok ro ngkrema beta. ");
INSERT INTO ayz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tna fai reto mhai ye.” ");
INSERT INTO ayz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tna raa ro Saduki weto nti te mtu Yesus mawe, “Meen ati ro hai mrok masen to, awya yfain fai reto? Tiwya ana mabo ngkrema ye mfain fai au reto ye fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus yawe, “Raa ro mhau mam tabam refo to, ja mmen fnya. ");
INSERT INTO ayz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Menohe meen raa mno feto fee. Allah ysok raa taro yno ana mrok masen. Mam makyon ro mama reto to, ana weto kbe mhau mam sawro ro Allah. Ana kbe moo fnya fee. Tna fnya weto kbe mamo msya raa fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kbe meen ana mnan fi malaikat sor. Tibyo meen mhai u fee. Allah yno ana mrok masen. Tibyo ana to ku ro Allah wAit. ");
INSERT INTO ayz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nnaut bokom ro Musa tiwya ykom: Ti sau Allah ykyas bo kʼMusa. Musa yari mai rAit mam ara kinyah-kanah sau. Ara reto smut mait warah. Tna Allah yawe, ‘Jõ fi Allah ro Abraham, Ishak msya Yakub ja mbaut.’ ");
INSERT INTO ayz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Allah yawe feto tibyo anu bhar bwe hohos wanu weto ro mhai ooh oh, ana mhai tibyo fee. Menohe Allah yawe ana mhau mam sawro rAit smot Ait fares to. Raa ro mhai oh, Allah yawe ana weto mhau fares.” ");
INSERT INTO ayz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tna guruagama baro mawe, “Bokyas aNyõ to moof ati.” ");
INSERT INTO ayz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tna raa aro ter-ter mtu bo kʼYesus u fee. ");
INSERT INTO ayz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tna Yesus ytu bo kʼana yawe, “Ja raa mawe kbe Mesias tait Kube ro Raja Daud. ");
INSERT INTO ayz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Menohe Raja Daud yesait, ati ro ykyas Mesias to, ytu Ait yawe, ‘Tuan ro ybo jõ.’ Mam aam ro Mazmur Daud ykom yawe: ‘Tuhan yawe kʼTuan ro ybo jõ yawe, “Nama, hre nsya Jõ mam ati ro tatem ati; hroh ro mase reto. Hre wea. ");
INSERT INTO ayz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tna raa ro byoh, raa ro srau kair kʼNyõ to, meen tno ana mbtek mam mte. Kbe Nyõ naa nber ana weto. Tna Nyõ nros natak abyõ ana, nbo ana.”’ ");
INSERT INTO ayz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mam bokom far-far reto to, Daud yesait ykyas Mesias yawe, ‘Ait fi Tuan ro ybo jõ’. Fyi re raa mawe Ait fi Kube ro Daud?” ");
INSERT INTO ayz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Raa beta hre mari bo ro Yesus ykyas fares. Tna Ait yawe kuber wAit yawe, ");
INSERT INTO ayz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kaket anu be kbe guru agama miwro anu! Ana ja hasu bo myum ratan ro moof tna hasu bo raa bibi ana tna ksoh mawe raa mmah meen kʼana wore mamo mam pasar bo. Ati ro ana mamoʼt samu watum soh mfe mamo sohmaam bo msya raa roto to, ana ja msok ambar ro moof tna mhre mam weto. ");
INSERT INTO ayz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ana skabuk miyõ wer afo re raa mmat ana. Raa mmat feto tna mnaut mawe ana raa ro ja mno bo moof sai. Semit mnaut mawe ana raa ro ja mno bo ro moof, tna ana miwro semit weto tna mtak amah wana ye. Feto to, meen bo ro mkair toni mama mai kʼana tu oh.” ");
INSERT INTO ayz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus ykyas bo mam Samu ro Allah fares. Tna ymat raa ro bobot baro mamo mbero pitis wana mam yuk ro raa msan bosan wana kʼTuhan. ");
INSERT INTO ayz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tna ymat semit sau ro suawe ye. Au mamo mbero pitis mauf rau ewok sai. ");
INSERT INTO ayz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tna Yesus yawe, “Nri oh: Semit refo mbero pitis rau mawat miwer raa roto beta. ");
INSERT INTO ayz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ana roto beta mbero kebet sai mbam kta wana ro mninon. Menohe semit refo mse bosatoh mawat fee. Au msan bo wau beta kʼTuhan.” ");
INSERT INTO ayz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Raa taro tawyõ Samu ro Allah tna mawe raa mfen fraa ro moof toni tna mse. Tna raa msan bo wana ro moof toni to, fayir Samu reto ye. Yesus yawe, ");
INSERT INTO ayz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Bo beta ro anu nmat wefo meen matu. Meen raa mitrah Samu reto. Tna kbe tembok msya fraa sau bo mhau ntar-tar anya feto fee. Meen fraa weto skik beta mbtek mai mam tabam.” ");
INSERT INTO ayz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ana mtu bo kʼYesus mawe, “Guru; tija re bo ro Nyõ nkyas weto mabo to? Kbe amu nmat bo bawya re nhar nwe bo ro Nyõ nawe weto kene wo mabo?” ");
INSERT INTO ayz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus yawe, “Kaket anu! Nno be raa mama sioh besruf anu. Jõ fi Mesias sait aran. Menohe meen raa mawat mama to, sruf bo mawe ana Mesias ybam kʼAllah. Tna kbe ana mawe, ‘Ayõ rau kene wo sboh oh!’ Nri ana ma! Kro ana ma! ");
INSERT INTO ayz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kbe anu nri he raa rabin taro mame anya tna mafa mnin-nin. Bo weto kbe mabo tu oh. Menohe waa ma: Bo weto kbe frok matim wia. Bo weto frok mama tna ayõ rau sboh fefares. ");
INSERT INTO ayz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tna raa ro bangsa sau kbe masen mame anya msya raa ro bangsa roto taro. Tna raa ro raja sait ybo kbe masen mame anya msya raa ro raja roto taro mbo ye. ");
INSERT INTO ayz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kbe iin ro mase toni frok. Tna haisre msya hayama kbe mai raa mam rabin jaro-jaro. Raa mawat kbe kiyam tna mhai. Tna kbe Tuhan yno bo ro mase mam ayoh abyõ. Raa beta kbe mmat tna waa. ");
INSERT INTO ayz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bo weto mama fefares to, kbe raa mama mfot anu. Anu fo kuber woJõ. Au oh mi kbe raa mfot tna sikowah anu. Kbe ana makah anu mamoʼt samu watum ro Yahudi. Tna fo ana mbo anu mamo mbu mam bui ye. Tna ana makah anu mamo msan kʼgubernur taro msya raja na taro sor ye. ");
INSERT INTO ayz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bo mkair weto meen mai kʼanu. Menohe mafer rau ro tis to moof. Jõ bitsre bo reto mai kʼanu afo re kbe anu nkyas Jõ tasom kʼraa ro mase weto. ");
INSERT INTO ayz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nnaut myum-yam bokyas ro kbe anu nkyas si kʼraa weto to ma: ");
INSERT INTO ayz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kbe Jõ tesait besi bonaut msya bokyas ro moof kʼanu, re kbe anu nkyas. Bokyas ranu reto kbe mnan si yum. Tibyo kbe raa byoh ro mhaf kair kʼanu to, aro matak mkyas bo si fee, ana shait sai. ");
INSERT INTO ayz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Meen nja, nme, nao, nno msya nfoh na wanu kbe hren ksuk anu. Anu aro kbe ana mame njat ye. ");
INSERT INTO ayz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Anu smot Jõ tibyo kbe raa beta knait anu. ");
INSERT INTO ayz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Menohe anu nna mawyan wanu kbe sau marak bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nros ntak tna beroh smot Jõ. Tna meen anu nkai riof ro mase.” ");
INSERT INTO ayz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tna Yesus yawe kuber wAit yawe, “Ati ro anu nmat raa byoh mbusyit Yerusalem to, anu nhar nwe kota reto mhau kait u fee. Baro feto bo ro mkair mama sikowah kota reto. ");
INSERT INTO ayz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ati ro anu nmat bo reto to, anu ro nhau mam provinsi ro Yudea to; nsen nsam nmo nuut atu mana. Tna anu ro nhau mam kota mato to; nsen nsam frok sikba kota reto. Tna anu ro nhau mam kota mne to; nmo twok mam kota reto mato ma! ");
INSERT INTO ayz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti weto to oon rau sboh oh. Tibyo Allah yno bo mai kʼraa mana ro Yahudi. Yno bo ska ana mnan si Bokom ro Allah tiwya raa mkom. ");
INSERT INTO ayz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wore weto to, fnya ro mhaf tna msya fnya ro mesis ku mees wana fares to, ana mmof toni. Ana kbe matak msam fooh fee. Bo ro mti kair kbe mbtek mai rabin refo. Tna Tuhan kbe kmo raa mana ranu refo. ");
INSERT INTO ayz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ana taro kbe raa mame majat. Taro ye kbe raa mfot tna mkuk makah mamoʼt bangsa raa makin. Tna raa ro wase Allah kbe mama mhau mam Yerusalem. Kbe ana mbo kota ranu refo snok mam ayõ ro Allah ybis yawe mnan. Tna makyon rau reto mkak.” ");
INSERT INTO ayz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Fyi re anu nhar nwe tabam kene wo haberek? Meen anu nmat ayoh to, nmat bo ro mase Tuhan yno mam ayoh; meen yno bo mai ayõ, snyi msya sken ye. Tna yno figyõm mase mai mam sawan ye; tibyo anu nri hmu rau mbam fari. Mam bangsa ro arin aso beta to, kbe raa mmat bo weto, tibyo waa tna mnaut yyi. Ana tetet miskawowo. ");
INSERT INTO ayz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Raa beta waa tetet mhai mmat bo beta ro mama mai. Meen bombra ro mhau mam ayoh skes to beta, Allah ybo sin. Tibyo raa mnaut yyi tru bo bawya ro kbe frok mama. ");
INSERT INTO ayz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen ati reto to, raa mmat Jõ tbam ayoh mboh abyõ troh tama. Tama to, raa mmat Jõ tatak aJõ ro msai tna mmat tase aJõ ye. ");
INSERT INTO ayz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bombra ro riwai Jõ tkyas weto, ati ro anu nmat bo weto mama to, nsen nros! Nsimaut mase nwe ayõ ro Allah yfes anu to, kene wo mama oh meu!” ");
INSERT INTO ayz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tna Yesus ykyas bofret refo kʼana yawe, “Nmat kake mara sor. ");
INSERT INTO ayz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mam tabam ranu refo, soh nmat masyoh rau teta frok feto to, anu nhar oh nwe kene wore snyi ro hwyõm oh meto. ");
INSERT INTO ayz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Feto ye, soh anu nmat bo weto mama to, anu nhar sai oh nwe oon reto kene oh meto. Allah siwyan yamo Raja ytu raa wAit mama ybo meto. ");
INSERT INTO ayz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nnaut: Ati ro bo wefo beta mama to, tawe biin reto to, kbe raa taro mhau fares. ");
INSERT INTO ayz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ayoh msya tabam refo kbe saef marak. Menohe bokyas aJõ kbe meen mhau mawyõs mamo snok mam hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tna Yesus yawe kuber wAit yawe, “Nhau kaket afo re anu siwyan ayõ ro meen Tuhan yama! Nno bokyõ wer ma. Nta jyõ wer to ma. Nsui bo ro tabam refo toni to ma. Ayõ rau reto snok tubor. Soh anu nhau siwyan anu to fee, kbe anu nrok. Anu nrok mfi bo kak mami sna; tibyo mrok. ");
INSERT INTO ayz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Raa beta ro mhau mam tabam refo kbe meen mkai ayõ reto tu oh. ");
INSERT INTO ayz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Kaket anu yoyo! Skabuk nyoh Tuhan afo re kbe anu nhau riof sai wore wo meen bombra wefo mbtek mai kʼraa. Tna meen mam sawro ro Taja to, Jõ ttu srah kʼraa beta to. Kbe anu nma tna nros si mam wore Jõ tasu ye. Skabuk re kbe, ati reto to, tmit safo kʼanu fee.” ");
INSERT INTO ayz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Baas to Yesus watum bo mam Samu ro Allah. Tna mti to, Ait yamo yjin mam faut ro Zaitun. ");
INSERT INTO ayz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tna rabu momo raa msis-sas masen mamoʼt Samu ro Allah mawe mari bokyas rAit. ");
INSERT INTO ayz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Korat 'Roti ro Ragi Marak' to kene oh. Korat reto ja raa mtu mawe masom Paskah ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tna imam manes ro agama Yahudi msya guruagama wana saso iso ro mame Yesus. Ana mawe mfot Ait wore wo raa makin mmat fee. Raa msis-sas hasu bo mari bokyas rAit. Tibyo raa manes weto waa raa makin mmat bo ana mfot Yesus, be kbe raa makin mrok mnin-nin. ");
INSERT INTO ayz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tna kabes yabi (Iblis) twok ybo Yudas Iskariot. Yudas tait, kuber ro Yesus wAit mabo 12 weto sait ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas yasen yamo tna hre saim bo ysya imam manes msya aban mana ro ja mbo raa sbe. (Raa sbe weto to raa ro Yahudi. Ana ja kmot Samu ro Allah.) Raa weto hre su msya Yudas tna saso iso ro kbe Yudas ysan Yesus kʼana. ");
INSERT INTO ayz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Riwai Yudas yama yo kʼana to, ana weto nksoh toni. Tna ana mawe kʼYudas mawe kbe maren pitis kʼait. ");
INSERT INTO ayz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas ksoh. Ait yasen yamo. Tna ywof ati ro moof re kbe besruf Yesus. Yawe kbe yno wore wo raa makin mmat fee. ");
INSERT INTO ayz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Raa makyõ korat 'Roti ro Ragi Marak'. Ti ro tinyi rau reto ja raa ktan domba sau ro kbe mabo mam bokyõ ro Paskah. ");
INSERT INTO ayz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tna Yesus ybis Petrus ysya Yohanes yawe, “Nmo siwyan bo sohmaam re kbe anu bkyõ bokyõ ro Paskah.” ");
INSERT INTO ayz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ana mtu bo kʼAit mawe, “Nyõ nksoh nawe amu siwyan bo sohmaam mam woyõ?” ");
INSERT INTO ayz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesus yawe, “Nmo ntwok mam Yerusalem. Tna kbe anu fri raa sme ro yasom baah mkah aya sait. Kro ait retait nmo twok mam samu ro kbe ait yatim twok to ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tna nwe kʼraa ro samu rait reto nwe, ‘Guru ranu ytu yawe, “Yuk ro kuber woJõ msya Jõ kbe nkyõ bokyõ ro Paskah mam woyõ?”’ ");
INSERT INTO ayz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kbe ait yerif amah hawar ro uu sau kʼanu. Amah hawar reto mase. Tna ambar bo mhau wea oh. Siwyan bombra mam beto.” ");
INSERT INTO ayz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tna ana mbewok masen mamo. Ana mmat he bo beta huwya mfi bo bawya ro Yesus riwai yawe kʼana. Tna ana siwyan bo sohmaam mkah makyõ bokyõ ro Paskah reto. ");
INSERT INTO ayz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bo beta raa siwyan oh. Tna mti reto Yesus ysya kuber wAit hre sohmaam bo su. ");
INSERT INTO ayz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tna Ait yawe kʼana yawe, “Tii ooh oh Jõ ksoh toni tawe hre takyõ korat ro Paskah refo tsya anu wia. Tna fo kbe bo ro mkair mama mai kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jõ kbe sohmaam korat ro Paskah u fee mamo snok mam meen anu bkai mabo rau mam wore wo Allah yamo Raja ybo raa mana rAit.” ");
INSERT INTO ayz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tna Yesus yoo hawereh sau tubat abyõ mam uu tna skabuk anggur maya reto yayoh asik mase kʼAllah. Tna Ait yawe kuber wAit yawe, “Anggur maya refo noo nsaim nee kʼanya nta. ");
INSERT INTO ayz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Jõ tesait kbe tata anggur maya u fee mamo snok mam oon ro Allah yamo Raja ybo raa mana rAit.” ");
INSERT INTO ayz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tna Yesus yoo roti sau. Yoo tna skabuk yayoh asik mase kʼAllah. Tna Ait haber roti reto yee kʼana beta mait. Tna yawe, “Nmat roti refo. Tetsu aJõ ro tsan mkah anu oh mefo. Niit oh. Tna kbe nno fefo u re nnaut Jõ.” ");
INSERT INTO ayz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ana sohmaam bo mkak tna Ait yoo hawereh reto tna yno mnan feto u yawe, “Anggur maya refo to mees aJõ ro kbe miyi mkah riof kʼanu. Kbe raa mame Jõ tajat tna Allah ysair Bosi ro Tna kʼanu oh meto.” ");
INSERT INTO ayz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Raa ro hren serek Jõ tait hre susai ysya anu mam wefo ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Kbe Jõ raa mame tajat mnan si bawya ro Allah yawe bait yum oh. Menohe bo ro mkair meen mama kʼait ro hren serek ysya Jõ retait.” ");
INSERT INTO ayz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tna kuber wAit mkyas kʼanya mawe, “Awya ro kbe hren serek fi?” ");
INSERT INTO ayz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tna kuber ro Yesus wAit mkyas renti tna santri anya mawe ana to awya kbe yase toni. ");
INSERT INTO ayz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tna Yesus yawe kʼana yawe, “Raa ro wase Allah to, raja wana ja mberasi raa wana ro mbo. Menohe raa ro mase weto, raa mtu mawe ‘raa ro mhaf ase’. He mfe. ");
INSERT INTO ayz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jõ tawe kʼanu tawe, ‘Nbo raa anya feto ma.’ Anu fo, awya ro yase, Jõ tawe yako hawe sai to ait haberek yamo ynan raa ro yaku. Tna ro aban mana to, Jõ tawe yako hawe sai ait yamo ynan sryan. ");
INSERT INTO ayz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Awya yase toni: Bobot ro hre yait boit, soh mfe ait ro siwyan boit tna yasyõ yee kʼbobot yait? Ja raa mawe bobot ro hre yait boit tait yase toni. Menohe Jõ tama tfi raa ro siwyan boit tna tasyõ tee kʼanu niit ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Anu wefo rabu wawa ja nhau su nrat nsya Jõ, ebokfi bo ro mkair aro mai kʼJõ to. Anu oh mi raa ro ja sikba Jõ fee. ");
INSERT INTO ayz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Taja ybis yawe Jõ tamo Raja tbo raa taro sor. Tna mfo refo Jõ tawe anu meen nbo raa taro ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tno bo reto afo re meen anu sait-sait yase tna ybo raa mana ro Israel trion 12 weto ye. Tna wore wo Jõ tamo Raja tbo raa woJõ to, meen anu nsya Jõ hre sohmaam bo su.” ");
INSERT INTO ayz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tna Yesus yawe kʼPetrus yawe, “Simon, nari oh: Kabes yabi (Iblis) yayoh kʼAllah, yawe bitsre ait yama sanet anu beta. Yawe yno anu smot Jõ fee. Yawe yno anu sikba Jõ nmo nhau hayah; mfi bo raa sait ja yoo gandum rait ysok makan rau tna yse hayah. Tna marak rau ait yitsre akus. ");
INSERT INTO ayz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","⌞Tna Allah ybis.⌟ Menohe Jõ skabuk nyõ oh, afo re bosmot anyõ matak sai. Tna nyõ nhah nama no kʼJõ. Nashana to, tna tawe nisoh nno nao na to, bosmot wana matak ye.” ");
INSERT INTO ayz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus yawe, “Tuhan; jõ kbe twok bui mato tna tajat su tsya Nyõ ye!” ");
INSERT INTO ayz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tna Yesus yawe, “Petrus, nari: Kbe nyõ nno feto fee. Jõ thar tawe kbe kook mara fefares mam mti refo to, kbe nyõ nwaar Jõ muhrin tuuf, nawe nyõ nwase Jõ.” ");
INSERT INTO ayz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tna Yesus yawe kuber wAit yawe, “Tiwya Jõ tbis anu tawe nmo nkyas Jõ tasom aJõ. Tna tawe anu nmo to nbo pitis ma. Tawe, krek yume ro nfau bo to ma. Nse sandal ma. Ati reto anu nbo bo aro mabut fe mfe a?” Tna ana mawe, “Mfe.” ");
INSERT INTO ayz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Tna Yesus yawe, “Bokom ro Allah far-far sau mkyas Jõ mawe, ‘Kbe raa mnaut mawe Ait tait Raa ro yber safo.’ Yesaya 53:12 Mfo refo bokom reto oon rau sboh oh mefo. Kbe bo reto mabo tu oh. Bo bawya-bawa sai kbe mno wa fee. Mfo refo tawe ati ro anu nmo to, kbe krek yume wanu, tna ro yse pitis to ybo weni, tna ro yse sbe aro fee to, kbe ait yasim ratan rait re kbe kwiyat sbe sau.” ");
INSERT INTO ayz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tna kuber wAit mawe, “Tuhan nmat, sbe trion ewok oh mefo.” Tna Yesus yawe, “Mnan oh.” ");
INSERT INTO ayz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus sikba Yerusalem tna yamoʼt faut ro Zaitun mnan ja yno soo oh. Tna kuber wAit kro Ait mamo ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ana snok mam yuk reto tna Ait yawe kʼana yawe, “Skabuk re kbe bo ro tabam refo tko anu nno iro to ma.” ");
INSERT INTO ayz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yesus yiserar yamo baro naut, tna hre tmi yimna skabuk yawe, ");
INSERT INTO ayz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Taja, Jõ tayoh kʼNyõ tawe Nyõ noo kair ro mama refo to, beak fari to. Nno re Jõ tru ma. He mfe: Nyõ nno mnan bonaut aNyõ sai.”  ");
INSERT INTO ayz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tna malaikat sau mbam sawro ro Allah mroh mama frok tubor. Mama misoh bosmot rAit. Tibyo Ait yatak. ");
INSERT INTO ayz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus yrok yhaf miyõ toni. Ait yhaf aya tibyo mur-mur skabuk kaket renti. Ait yimyoh frok mnan mees ro miyi tna mbtek-tak mam tabam. ");
INSERT INTO ayz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesus skabuk mkak tna hah yamo yo kuber wAit. Ait yama ymat menohe ana mjin beta. Riwai ana sraujin toni tibyo mhai rowyõ. ");
INSERT INTO ayz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tna Ait yawe kʼana yawe, “Fyi re anu njin to? Nsen tna skabuk. Skabuk re kbe bo ro tabam refo tko anu nno iro to ma.” ");
INSERT INTO ayz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus ykyas bo kri-kri fares, menohe raa majin sau mama. Yudas yatim wia yama yo kʼYesus tna hana Ait. (Yudas tait, kuber wAit mabo 12 sait.) ");
INSERT INTO ayz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","He Yesus yawe, “Yudas, Jõ oh mi 'Ait ro Yroh Yama Yfi Raa Sai'! Fyi ro nyõ nama hana Jõ mkah bo hren serek Jõ mefo?” ");
INSERT INTO ayz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ati ro kuber wAit taro mmat bo ro kbe Yesus tru reto ana mtu kʼAit mawe, “Tuhan fyi, amu nbo tfo nfa nsya ana fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tna kuber ro Yesus sait yasen ysot raa sait yimara ati ro yatem ati to hri. Raa retait tait sryan ro imam yase rait. ");
INSERT INTO ayz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Menohe Yesus yawe kuber wAit yawe, “Mnan oh!” Tna Yesus ybo sryan retait yimara tna yisoh mrok moof u mfi tinyi. ");
INSERT INTO ayz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tna Yesus yawe kʼana ro mama mfot Ait yawe, “Jõ fi raa ro ja hafrah pemerintah Roma fee. Jõ tko raa mrok mnin-nin fee. Anu nbo sogi msya hbat wanu tna nma nfot Jõ to, nno fyi? ");
INSERT INTO ayz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rabu wawa Jõ thau su tsya anu mam Samu ro Allah menohe anu nfot Jõ mam beto fee. Mfo to, ayõ ro mamur snok mama oh. Tna anu nma wefo fo nkah ntak ro mkair mbam kabes yabi. Tibyo anu nma nfot Jõ fo.” ");
INSERT INTO ayz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ana mfot Yesus tna makah mamoʼt samu sau. Samu reto imam agama Yahudi ro yase rait to. Tna Petrus ybo rof-rof ana mtis. ");
INSERT INTO ayz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Snok mam bohra ro samu reto tna raa mko tafoh susai. Tna Petrus ysya raa baro hre su. ");
INSERT INTO ayz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tna sryan sau ro ano mmat Petrus hre yni foos ye. Au mmat ait kaket tna mawe, “Raa refi ja ysya Yesus ye!” ");
INSERT INTO ayz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Menohe Petrus yawe, “Bokyas anyõ fyi meto? Jõ wase ye!” ");
INSERT INTO ayz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ti baro firwas tna Petrus hre fares. Tna raa sait ymat ait tna yawe, “Nyõ ja nsya Ait ye!” Menohe Petrus ywaar yawe, “Mfe, jõ fee!” ");
INSERT INTO ayz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ayõ sau naut tna raa roto sait yawe, “Ae, ait refi raa ro Galilea ye. Ait kuber ro Yesus sait tu oh!” ");
INSERT INTO ayz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","He Petrus yawe, “Bokyas anyõ fyi meto? Jõ wase ye!” Petrus ykyas fares si fo tibyo kook sau mara. ");
INSERT INTO ayz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tna Yesus siur tna ymat Petrus. Tna Petrus ynaut bokyas riwai Yesus yawe kʼait yawe, “Kook mara fefares to, kbe nyõ nwaar Jõ muhrin tuuf.” ");
INSERT INTO ayz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tna fo Petrus yasen frok yamo tna yawia sut-sut. ");
INSERT INTO ayz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Raa ro kmot Yesus mamus Ait. Ana moo hawee make Ait yasu tna mai Ait. Mai tna mtu kʼAit mawe, “Sgi nawe awya yai Nyõ metait?” ");
INSERT INTO ayz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bomus mawat raa mamus Ait. ");
INSERT INTO ayz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Rabu momo tna raa manes ro agama Yahudi, mama siret su. (Ana weto to imam manes wana msya guruagama wana ye. Ja ana siret su re mtu safo raa ro Yahudi.) Tna raa sbe ro kmot Yesus masen mbo Ait mamo mo kʼraa manes weto. ");
INSERT INTO ayz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ana mtu kʼYesus mawe, “Nyõ fi Mesias fe mfe a?” Menohe Yesus yawe, “Soh Jõ tawe feto kʼanu to, kbe anu smot ye fee. ");
INSERT INTO ayz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tna soh Jõ ttu bo kʼanu to, kbe anu nwe si fee ye. ");
INSERT INTO ayz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Menohe tawe kʼanu tawe: Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Maban tinyi rau mefo, kbe anu nmat Jõ hre tsya Allah ro yase. Kbe Jõ hre mam ati ro yatem ati; hroh ro mase reto.” ");
INSERT INTO ayz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tna ana beta mtu mawe, “Soh feto, Nyõ refi Allah yare a?” Tna Yesus yawe, “Ae; au oh nwe meto.” ");
INSERT INTO ayz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tna ana mawe, “Ait fi Raa sai. Menohe yesait yawe Ait fi Mesias! Yawe feto, Ait nto Allah oh meto! Tna anu besait bri oh. Kbe anu saso raa roto mama maun Ait mkah bawya! Mfo refo anu besait bmit safo reto kʼAit!” ");
INSERT INTO ayz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Raa manes ro ja mtu safo raa ro Yahudi weto, beta masen mros. Tna mbo Yesus mamo mo kʼPilatus. ");
INSERT INTO ayz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mamo mo kʼPilatus tna ana masen maun Yesus mawe, “Raa refi berasi watum ro Roma toni: Ro sau to, amu raa mana ro Yahudi to, Ait yiwro amu. Yawe amu nri bo ro pemerintah mawe to ma. Ro ewok to, Ait yawe wa yawe, ‘Noo namabyoh (pajak) wanu nee kʼKaisar to ma.’ Tna ro tuuf to, Ait yawe Ait yesait oh mi Mesias. Au oh mi yawe Ait yamo Raja.” ");
INSERT INTO ayz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tibyo Pilatus ytu bo kʼYesus yawe, “Nyõ fi Raja ro nbo raa ro Yahudi fe mfe a?” Yesus yawe, “Ae; bokyas anyõ reto mabo oh.” ");
INSERT INTO ayz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tna Pilatus yawe kʼimam manes weto msya raa taro sor ro mros mari bo ro ait yawe, “Jõ tnaut tawe Ait refi fi raa ro yisti safo ro mkair aro fee. Tmit safo aro kʼAit fee.” ");
INSERT INTO ayz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Menohe raa mberoh sai matak toni mawe, “Bokyas rAit yno raa ro Yudea mhaf wana beta mkair. Tinyi rau yno mam provinsi ro Galilea, tna mfo refo Ait yama ykyas bo rAit mam rabin ranu refo to ye!” ");
INSERT INTO ayz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus yari bokyas reto tna ytu yawe, “Ait refi ybam Galilea a?” ");
INSERT INTO ayz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Raa mawe, “Ae.” Tibyo Pilatus yawe, “Herodes oh mi ja ybo raa mam provinsi ro Galilea. Jõ fee.” (Ja bi Herodes yhau mam Galilea. Menohe ati reto ait yama iti yhau mam Yerusalem.) ");
INSERT INTO ayz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tibyo raa manes ro agama Yahudi weto mbo Yesus mamo mo kʼHerodes. Herodes ksoh ymat Yesus. Tiwya ooh oh ait yari raa mkyas mawe Yesus ja yno bosair msis toni. Tna ati reto ait yawe ymat Yesus yno bosair aro. ");
INSERT INTO ayz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes ytu bo msis kʼYesus. Menohe Yesus shait sai. ");
INSERT INTO ayz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Imam manes msya guruagama na mros su mam weto ye. Ana kmo tna mkyas besus-basas Ait, tna maun Ait. ");
INSERT INTO ayz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Riwai Yesus yawe Ait fi raja. Feto to raa sbe mawah ratan ro mfi raja na ja myum to, mse kʼAit yyum. Tna Herodes ysya ana sret Ait masah. Tna Herodes ybis raa sbe wait weto mbo Yesus hah mamo mo kʼPilatus u. ");
INSERT INTO ayz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","(Herodes ysya Pilatus ana mbewok ja soo mtoh anya, menohe ati reto ana mbewok me haberek miranya u.) ");
INSERT INTO ayz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesus raa makah hah mamo mo kʼPilatus. Tna Pilatus ytu imam manes, raa manes taro, msya raa beta yawe mama siret su. ");
INSERT INTO ayz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ana mama tna ait yawe, “Riwai anu nbo Raa refi nma no kʼjõ tna anu nuun Ait nwe ja yno raa mbeswan pemerintah ro Roma. Jõ ttu sas Ait tna tnaut tawe Ait yisti safo maku aro bo fee saut. Yno safo mnan boun ro anu nuun Ait weto ye fee. ");
INSERT INTO ayz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tna Herodes ynaut yawe Ait raa sai bait ja yno safo aro fee ye. Tibyo Herodes ybis Ait hah yama yo kʼamu. Anu nhar nwe Ait yisti safo ro mase aro fee. Safo ro Ait yisti re anu nme Ait to aro fee! ");
INSERT INTO ayz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jõ tbis raa mai mahoh Ait sai. Tna fo jõ bitsre Ait.”  ");
INSERT INTO ayz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tahun aro firwas-firwas korat ro Paskah mama tna Pilatus tufrok raa sait ybam bui yawe yamo bait. Korat Paskah reto to, ait yawe kbe bitsre Yesus. ");
INSERT INTO ayz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Menohe raa ro siret mam beto hawe. Beta masen mawe, “Mfe! Nme Ait yajat! Tufrok Barabas ybam bui!” ");
INSERT INTO ayz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Tiwya raa sait ro yasom Barabas yno raa ro Yerusalem mnin-nin. Tna ait yame raa sait yajat ye. Tibyo raa mbu ait mam bui.) ");
INSERT INTO ayz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Menohe Pilatus yawe bitsre Yesus. Tibyo yawe kʼraa weto u yawe ait ksoh rait to, bitsre Yesus yamo bait. ");
INSERT INTO ayz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Menohe raa weto mtu fari mawe, “Mfe, name Ait yajat mam ara warok!” ");
INSERT INTO ayz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tna Pilatus yasen yawe kʼraa weto mun tuuf u yawe, “Nwe nme Ait to, fyi? Ait Raa ro yisti safo bawya? Jõ tnaut tawe Ait yisti safo aro fee saut. Safo mase ro Ait yisti re anu nme Ait to, aro fee! Feto to tbis raa sbe mai Ait wia, tna bitsre Ait yamo bait.” ");
INSERT INTO ayz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Menohe raa kmo mawe renti mawe, “Yesus kbe raa mame tu!” Tibyo bokyas manta mati rana. Tna fo tis rau Pilatus yari. ");
INSERT INTO ayz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tibyo Pilatus ybis yawe raa mame Yesus mnan si bo ro ana mawe. ");
INSERT INTO ayz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tna ait bitsre Barabas ro ana mayoh retait. Tna Yesus raa msan mam ati rana. Tna ana mno mnan bo ro ana mawe sai. ");
INSERT INTO ayz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tna raa sbe mbo Yesus mamo frok amah reto, tna makah mamo mame Ait. Ana mamo mam iso tna fri raa sait ybam safom yama. Ait raa ro srim, ybam kota ro Kirene. Yasom rait Simon. Ana mfot ait tna mkuk ait yawe yasom ara warok ro Yesus. Tna Simon yasom ara warok reto kro Yesus mam tis. ");
INSERT INTO ayz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ana mamo to, tna raa mawat kro Yesus mamo ye, msya fnya baro ye. Fnya weto sraujin toni tna mawia Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus siur haberek yawe kʼfnya weto yawe, “Fnya ro nhau mam Yerusalem: Nwia Jõ ma. Nwia anu nesait tna nwia ku wanu sai. ");
INSERT INTO ayz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Meen arin mkair mama mai kʼraa ro mhau mam Yerusalem. Tibyo kbe raa mawe, ‘Fnya ro siban, fnya ro mabe ku fee, msya fnya ro moo sis mee ku mait fee to; kbe ana simaut mase!’ ");
INSERT INTO ayz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Arin mkair tibyo raa mayoh mawe bo mai ana majat. Mawe, ‘Rau ro moof to, atu mbra sor matu mama mnyien amu!’ Tna mawe, ‘Rau ro moof to, faut mama msyoh kait amu!’ ");
INSERT INTO ayz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jõ tno safo aro fee. Jõ tnan fi ara sau ro safom fares. Menohe raa mno bo mkair mai kʼJõ mnan fefo. Menohe anu, raa ro Yerusalem fo, nno iro mawat. Anu nnan fi ara ro samer. Meen raa mno bo bawya mai kʼanu?” ");
INSERT INTO ayz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Raa sme roto mabo ewok tiwya mno safo. Ana raa makah mamo re mame su msya Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ana mamo snok mam faut sau ro masom 'Yuk ro Hamana'. Mkah mai rana to, raa mawe 'Golgota'. Raa sbe mse Yesus mam ara warok sau. Tna mse raa ro marmtuk mabo ewok mam ara warok feto ye. Ana mse sait mam ati ro Yesus tem ati tna sait mam ati ro Yesus tem ta. ");
INSERT INTO ayz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tna Yesus skabuk raa sbe weto yawe, “Taja, nyon iro ro ana mno refo. Ana wase bo bawya ro ana mno.” Tna raa sbe weto moo bo tane re kbe mhar awya ro yoo ratan ro Yesus rAit. Tna saim kʼanya. ");
INSERT INTO ayz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Raa msis mros mam weto horit. Tna raa manes taro mamus Yesus mawe, “Ait yawe Ait tait Mesias ro Allah ybis yama. Yawe Ait tait Raa ro Allah ysok. Ait yno riof kʼraa roto. Sik yno riof kʼAit yesait ye!” ");
INSERT INTO ayz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Raa sbe mamus Yesus ye. Tna ana moo anggur maya ro mano mee kʼYesus yata. ");
INSERT INTO ayz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tna mawe, “Soh Nyõ fi Raja ro nbo raa ro Yahudi meto mi, sik nno riof kʼNyõ nesait ai.” ");
INSERT INTO ayz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Riwai raa mkom bokom sau mse mam ara warok reto abyõ. Bokom reto mkom mawe: “Raa refi raja raa ro Yahudi.” ");
INSERT INTO ayz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ait ro raa mame ysya Yesus sait yamus Yesus ye yawe, “Nyõ fi Mesias fe mfe a? Soh nyõ fi Mesias meto mi nno riof kʼamu mbewok nsya Nyõ nesait ye!” ");
INSERT INTO ayz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Menohe ait roto sait yastako ait retait yawe, “Nyõ ye raa mame su najat nfi Ait. Tibyo nyõ waa Allah fe mfe a? ");
INSERT INTO ayz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Anu bewok bber safo tibyo raa mame anu bewok. Menohe Ait refi yber safo aro fee!” ");
INSERT INTO ayz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tna yawe kʼYesus yawe, “Yesus; kbe namo Raja nbo raa woNyõ to, nnaut jõ ye!” ");
INSERT INTO ayz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tna Yesus yawe kʼait yawe, “Ae, ayõ refo ye kbe nyõ nsya Jõ bhau su mam yuk ro moof.” ");
INSERT INTO ayz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ayõ ro 12 baas bo feto, tna mti abut frok mama mfi bo mti. Mama mhau snok mam hreha ayõ ro tuuf. ");
INSERT INTO ayz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ayõ mo fee. Tna horden ro nkro mam Samu ro Allah reto mesait mhah ftah ewok. ");
INSERT INTO ayz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tna Yesus ytu fari yawe, “Taja, Jõ tsan tafos aJõ kʼNyõ sai!” Yawe feto tna yhai. ");
INSERT INTO ayz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Raa sbe ro yase yamo aban mana tait, ymat bo weto, tibyo yasen ybaut Allah tna yawe, “Mabo oh, Ait refi raa ro yno bo moof ati sai!” ");
INSERT INTO ayz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Raa mawat mros tna horit bo raa mame raa mam ara warok weto. Menohe ati ro mmat bo bawya ro snok weto beta, ana beta sraujin toni tna hah mamo bana. ");
INSERT INTO ayz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Menohe Yesus yafoh wAit msya fnya baro ro kro Ait mbam provinsi ro Galilea, mros fari mmat bo weto beta. ");
INSERT INTO ayz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Raa sait ro yasom Yusuf yros ymat ye. (Ait retait ybam remo ro Arimatea. Ait raa ro yhaf moof toni. Tna ait ja ste oon ro Allah yamo Raja ybo raa mana rAit. Ait raa manes ro agama Yahudi sait. Ana weto raa ro ja mtu safo raa ro Yahudi. Menohe Ait hawe bo raa saim mawe mamo mame Yesus.) ");
INSERT INTO ayz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yusuf ymat bo ro ana mno. Tna yamo yo kʼPilatus tna yayoh yawe ajat ro Yesus reto raa msan kʼait. Pilatus yawe, “Ae.” ");
INSERT INTO ayz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tibyo Yusuf yamo skur Yesus ybam ara warok reto. Tna sro ajat reto mkah hawee ro moof sau. Tna yamo yse mam isra sau. Ako reto raa kowak mam fraa ro faut sau mkah bo raa moo hai wana mse. Tna raa sama hai aro mam isra mato refo fefares. ");
INSERT INTO ayz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ayõ reto hari jumat hreha oh. Tna menrabu ayõ ro raa ntmoh (hari Sabat). Feto to mam hari jumat to, ja raa ro Yahudi siwyan bo mkah hari Sabtu. ");
INSERT INTO ayz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Raa makah ajat rAit reto tna mse mam isra mato. Tna fnya ro kro Ait mbam Galilea weto mrof mamo kro mam tis tna mmat. ");
INSERT INTO ayz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tna ana hah mamo siwyan minyak ro sawer msya botkif sor mkah kbe mamo ngkaru hai ro Yesus reto. Menohe mam ayõ ro raa ntmoh to, ana swior bo ro ana mno beta; ana kro bo mafa ro agama rana. ");
INSERT INTO ayz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ayõ ro minggu rabu momo toni, fnya weto mbo botkif wana ro ana siwyan beta oh tna mbo masen mamoʼt isra reto. ");
INSERT INTO ayz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Snok mam weto tna mmat fraa ro taa muut isra wa reto to, raa mririk oh. Tna isra mato maa sai. ");
INSERT INTO ayz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tibyo ana twok mam isra mato reto, he fri hai ro Tuhan Yesus reto fee. ");
INSERT INTO ayz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tibyo ana mros tna mnaut tna mtu kʼanya mawe, “Bawya mno mefo?” Menohe raa sme mabo ewok frok tubor mama mros kene msya ana. Raa weto myum ratan ro ngkren mboh fyok. ");
INSERT INTO ayz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Fnya weto waa toni mrok tetet. Tibyo maka mabum. Tna raa mabo ewok reto mawe kʼana mawe, “Fyi re anu saso Ait ro yhau yaam mam befo fo? Ako mato refo fo, yuk ro ja raa mse hai. ");
INSERT INTO ayz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ait yarak. Ait yrok yasen oh! Nnaut bawya ro tiwya Ait ykyas kʼanu mam ati ro anu nhau mam Galilea fares. ");
INSERT INTO ayz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tiwya Ait yawe, 'Ait ro Yroh Yama Yfi Raa Sai' retait tait, kbe raa msan kʼraa ro mno iro. Ana weto kbe mame Ait yajat mam ara warok. Tna kbe ti ro tuuf to, Ait yrok yasen.” ");
INSERT INTO ayz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Fnya weto mari bo reto tna mnaut bokyas ro Yesus reto. ");
INSERT INTO ayz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ana hah me mamo. Tna mkyas bo weto beta kuber wAit mabo 11 reto msya raa roto ro kro Ait beta. ");
INSERT INTO ayz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Fnya ro mkyas bo weto kʼraabis wAit to, ana masom sor oh mefo: Maria Magdalena, msya Yohana, msya Maria ro Yakobus yme, tna msya fnya roto ro riwai msya ana mamo mmat he Yesus yarak. ");
INSERT INTO ayz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Menohe kuber wAit weto mnaut mawe fnya weto sioh-sah sai. Ana mari bokyas ro fnya weto mawe fee. ");
INSERT INTO ayz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tna fo Petrus yasen yhoh yamo ymat isra mato reto. Ait yaka koyo ymat mam isra mato. He hawee ro raa sro Yesus mesait aran mbris mam weto. Tibyo Petrus hah ye yamo. Tna ynaut myum-yam yawe, “Bo bawya ro mno mefo.” ");
INSERT INTO ayz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ayõ reto ye kuber ro Yesus wAit mabo ewok mamoʼt remo sau ro masom Emaus. Mbam Yerusalem mamoʼt remo reto kilo mara 11 bo feto. ");
INSERT INTO ayz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ana mbewok mamo mam iso miyõ reto to, tna ana mbewok mkyas bo yase ro mnin-nin mam Yerusalem reto. ");
INSERT INTO ayz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ana mbewok mkyas bo weto nkri-kri tna mtu bo kʼanya si fo, tna Yesus yesait yama yo kʼana kait tna yamo su ysya ana. ");
INSERT INTO ayz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ana mmat Yesus, menohe bo sau mburut ana masu wa tibyo ana mhar Ait fee. ");
INSERT INTO ayz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tna Yesus yawe, “Anu nkyas bawya mefo?” Ana mbewok susu mros mkah masu ro sraujin. ");
INSERT INTO ayz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ana mbewok weto sait yasom Kleopas. Ait yawe kʼYesus yawe, “Nyõ nari bo aro fefares a? Nyõ nesait aran raa srim mam Yerusalem re wase bo yase ro mfo mnin-nin mam beto to fea!” ");
INSERT INTO ayz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesus ytu bo kʼana yawe, “Bawya meto?” Ana mawe, “Bo ro taa raa mno kʼYesus, raa ro ybam Nazaret retait. Ait tait nabi ro Allah ybis yama. Ait yhar bo ykyas watum ro mbam Allah to, ykyas kaket. Tna yatak yno bo ro msai ye. Raa ksoh Ait ye tna yno Allah yhaf mnan ye. ");
INSERT INTO ayz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Menohe Imam manes ro agama Yahudi msya raa mabi wamu to, moo Ait msan kʼraa mame yajat mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ti tuuf yhai. Menohe tiwya amu ninaut nwe Ait oh mi raa ro yama yfes raa ro Israel. Amu ninaut nwe Ait kbe yai raa ro mamo byoh kʼamu tna yno riof kʼanu. ");
INSERT INTO ayz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Tna rabu momo fo, fnya wamu baro mamoʼt isra wore raa mse ajat rAit reto. Mamo tna mmat he ajat reto marak! Ana hah me mawe kʼamu mawe ana mmat malaikat mabo baro sor. Tna malaikat weto mkyas bo kʼana mawe Yesus yrok yasen oh! ");
INSERT INTO ayz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tna raa wamu baro mamo mmat isra reto ye. Menohe mabo mfi bo ro riwai fnya mkyas weto ye. Mmat he ajat reto marak ye.” ");
INSERT INTO ayz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tna Yesus yawe kʼana yawe, “Anu raa ro wase bo! Tiwya Allah ybis nabi sor mama mkyas bo rAit. Menohe anu nhaf matak tna niwana bombra ro ana mkyas beta! ");
INSERT INTO ayz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yako hawe sai Mesias tru kair ro mnan feto wia, tna kbe Ait ykai bobot rAit ro mase to.” ");
INSERT INTO ayz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tna Yesus betoo Watum ro Allah kʼana mbam aam ro Musa ykom snok mam aam ro nabi aro sor mkom. Ait betoo bokom beta ro mkyas Ait kʼana re mhar ye. ");
INSERT INTO ayz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kene ye msya remo ro ana mbewok mamo reto to, Yesus yawe mfi bo yamo bait yiwrek sai yamo. ");
INSERT INTO ayz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Menohe ana mberoh toni wesi Ait mawe, “Hreha oh, ngkinine mti ye oh. Nhau nsya amu mam befo wia.” Tibyo Yesus yari feto tna twok yhau ysya ana. ");
INSERT INTO ayz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ati ro ana mbewok hre tna msya Ait mait boit su to, Yesus yoo roti ybo tna yayoh asik mase kʼAllah. Tna Ait haber roti reto saim kʼana mait. ");
INSERT INTO ayz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tibyo mam ati reto to, ana mrok mhar mawe Ait retait Yesus. Menohe Ait yrok yarak sai tubor. ");
INSERT INTO ayz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ana mkyas kʼanya mawe, “Riwai Ait betoo Bokom ro Allah kʼanu mam iso maka iti to, anu smut ksoh!” ");
INSERT INTO ayz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ayõ reto ye ana mbewok reto masen hah me mamoʼt Yerusalem. Mam beto tna ana fri kuber ro Yesus mabo 11 weto beta msya mafoh na makin taro sor hre kri-kri wea. ");
INSERT INTO ayz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ana weto mkyas bo mawe, “Mabo oh! Tuhan yrok yasen, tna fo yerif Ait kʼSimon-Petrus!” ");
INSERT INTO ayz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tna ana mbewok masen mkyas mawe Yesus yerif Ait kʼana mam iso tna yamo su ysya ana ye. Mkyas mawe ana wase Ait wea mam weto. Tna wore wo Ait haber roti re yee kʼana mait to, ana mbewok mhar Ait ye. ");
INSERT INTO ayz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ana hre mkyas bo kri-kri fares, menohe Yesus frok tubor yros susai ysya ana. Tna yawe, “Waa ma.” ");
INSERT INTO ayz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ana mnaut mawe berwanah oh mi snok tubor mawe bo kʼana meto. Tibyo ana mrok waa tna tetet. ");
INSERT INTO ayz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesus yawe kʼana yawe, “Fyi re anu waa to? Nnaut bo maut-mroh to ma! ");
INSERT INTO ayz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nmat ye tatem aJõ msya taa aJõ mefo. Sasas Jõ tna haninin ye. Anu nhar nwe ja berwanah to, kwiyan msya mtai aro ye mnan fi Jõ fefo fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesus ykyas feto tna yerif naat ro yaa rAit msya yatem rAit bo kʼana. ");
INSERT INTO ayz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ana simaut toni tna miskawowo fares. Tibyo ana mnaut mamo-me fares. Tna Ait yawe, “Anu nse boit aro mam befo fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ana masen moo syoh mabuf ro saruk sau mee kʼAit. ");
INSERT INTO ayz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tna Ait yoo yabo wore wo ana beta mmat ye. ");
INSERT INTO ayz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tna Yesus yawe, “Tiwya thau tsya anu fares to, tkyas tawe, ‘Mam Bokom ro Allah to, Musa ysya nabi na msya raa ro mkom aam ro Mazmur to, mkyas Jõ tasom. Tna bombra ro ana weto mkom oh to, beta kbe mabo mnan bo ro ana mkom to ye.’” ");
INSERT INTO ayz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tna Yesus yno ana makit wana maah afo re ana mhar Bokom ro Allah. ");
INSERT INTO ayz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ait yawe, “Bokom ro Allah mawe, ‘Mesias kbe ykai bo ro samyoh mai kʼAit, tna yhai ye. Tna mam ti ro tuuf kbe Allah yno Ait yrok yasen.’ ");
INSERT INTO ayz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tna Bokom ro Allah mkyas mawe ‘Mesias kbe ybis raa mamo mkyas Ait yasom.’ Ana weto kbe mawe kʼraa mawe, ‘Nashana tna kbe Allah yyon iro wanu.’ Bo refo kbe raa mkyas mam Yerusalem tinyi wia, tna fo mamo snok mam bangsa beta ye. ");
INSERT INTO ayz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Anu nmat bo samyoh weto ro mai kʼJõ oh, mnan Bokom ro Allah mkyas. Anu nmat mabo rau oh to. Anu nmat oh tna kbe nsen nkyas bo weto kʼraa. ");
INSERT INTO ayz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tiwya Allah ysi yawe kbe yatak rAit matam raa. Tna kbe tbis tak ro mbam Allah reto mama matam anu. Tawe nhau mam Yerusalem wea ste tak reto mama.” ");
INSERT INTO ayz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesus yakah ana weto yamo kene mam remo ro Betania. Mam beto tna Ait yitbat yatem rAit tna skabuk yawe Allah yno bo moof kʼana. ");
INSERT INTO ayz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Skabuk ana kri-kri fo, tna Allah tubat Ait yaut yamoʼt sawro rAit. ");
INSERT INTO ayz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ana mbaut Ait. Tna ana hah mamoʼt Yerusalem mkah simaut rana mase toni. ");
INSERT INTO ayz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ja rabu wawa ana mamoʼt Samu ro Allah tna ana bibi Ait yoyo.");
INSERT INTO ayz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tiwya tinyi tabam refo mkah bombra beta marak fares. Menohe Ait sait ro raa mtu 'Bokyas ro Allah' yhau soo bait wia oh. Ait yhau su ysya Allah, tna Ait fi Allah. ");
INSERT INTO ayz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tiwya tinyi Ait yhau su ysya Allah. ");
INSERT INTO ayz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ait tait raa mtu 'Bokyas ro Allah'. Ait tait yfen bombra beta ro mhau mam tabam refo to. Bo sau mbam iso roto aro fee. ");
INSERT INTO ayz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ait yafos rAit mhau sai yum. Ait yhau yroon yawyos. Ait fi ybo raa mafos wana msya bombra beta. Yafos ro mhau kʼAit to mnan fi kek. Tna yafos rAit reto mno raa mmat Kek reto. Mno masu maah. ");
INSERT INTO ayz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tiwya Kek reto mama tna mait mram amur. Tna amur reto to, matak mikabuk Kek reto fee. Mno tna Kek reto mhai fee. ");
INSERT INTO ayz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tna Allah ybis raa sait yama. Raa retait yasom Yohanes. ");
INSERT INTO ayz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ait yama mkah bo ykyas 'Kek' reto. Ait ykyas bo ro yesait ymat. Tna ait yama ykyas bo ro ymat reto afo re raa mhar mawe mabo oh. Afo re raa beta smot 'Ait ro ynan fi Kek.' ");
INSERT INTO ayz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanes fi Kek reto fee. Yohanes raa ro yama mkah bo ykyas Kek reto sai. ");
INSERT INTO ayz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kek ro ati refo mamaʼt tabam refo. Mama mram raa sait-sait. ");
INSERT INTO ayz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Raa ro Ynan fi Kek retait, tiwya yfen tabam refo. Tna yama yhau mam tabam refo ye. Menohe raa ro tabam refo wase Ait. ");
INSERT INTO ayz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yesus yfen tabam refo. Tibyo bombra beta to bo wAit. Raa wAit ro tii yfen to, Yesus yama yo kʼana. Menohe raa wAit weto to, ana mawat hawe bo mmat Ait. ");
INSERT INTO ayz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Menohe raa baro mmat Ait. Ana mmat tna smot Ait to. Yesus ykyas ana yawe, “Ana weto oh mi mamo ku ro Allah wAit.” ");
INSERT INTO ayz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Raa mamo ku ro Allah wAit to hayah. Tna iso ro fnya mabe ku to hayah ye. Mnan anya fee. Ku ro fnya mabe to, ana mbam raa sei sai. Menohe ku ro Allah yabe to mbam raa mana sau fee. Ja raa ksoh rana mabe kube aro. Tibyo ana mabe ku. Menohe ku ro Allah yabe to hayah. Ku weto to mbam raa ksoh wana to fee. Raa sme ja ksoh yawe yjin ysya fnya. Yno tna au mhaf tna au mabe ku. Menohe raa mamo ku ro Allah wAit to mnan feto fee. ");
INSERT INTO ayz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bokyas ro Allah reto haberek mamo raa. Raa retait yama yhau mam tabam refo su ysya anu. Tna amu nmat bo yase rAit oh. Ait tait Ku bum ro Allah yare. Ku rAit sait tomu. Tibyo Allah ysan bo yase rAit beta Ku retait. Ait yhar bo ro ati miwer. Tna Ait tait Raa ro yatmof raa miwer. ");
INSERT INTO ayz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes ykyas Yesus yasom kʼraa. Ykyas bo ro yesait ymat feto to, ait yhar yawe mabo oh. Mkah ymai fari Yohanes yawe, “Ait ro tiwya tkyas kʼanu to Ait oh mefi. Jõ tama tkyas Ait wia matim. Tna Ait yama. Menohe Ait fi yase yiwrek jõ. Tiwya fnya mabe jõ fefares to, Ait yhau tuu oh.” ");
INSERT INTO ayz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ait yatmof raa miwer tibyo yno bo moof kʼanu beta. Tna anu fri bo mafer mninon. ");
INSERT INTO ayz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Watum ranu ro agama Yahudi to, tiwya Allah ykyas kʼMusa. Tna Musa yoo yee kʼanu. Menohe mfo refo Allah ybis Yesus yama yo kʼanu. Ybis yama afo re yerif boatmof rAit. Tna ybis Ait yama afo re kbe raa mhar Allah yhaf, srau rAit. ");
INSERT INTO ayz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Raa aro ymat Allah fefares. Menohe Ku bum rAit yno re anu bhar Allah. Ait tait yesait aran Ku ro Allah yare. Tna Ait hre kut-kut ysya Yaja ");
INSERT INTO ayz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yohanes ykyas Yesus yasom. Ykyas bo ro yesait ymat feto to, yhar yawe mabo oh. Tna ti sau mam Yerusalem to, raa manes ro agama Yahudi mbis raa wana baro masen mamo mo kʼYohanes. Raa ro ana mbis to: Imam wana msya raa mana ro Lewi baro. Mbis ana mamo mtu bo kʼait mawe, “Nyõ fi awya?” ");
INSERT INTO ayz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Raa weto mama mo kʼYohanes. Tna mtu bo kʼait. Tna Yohanes yasen yawe abyõ si kʼana yawe, “Jõ fi Mesias ro ja anu nwof to fee.” ");
INSERT INTO ayz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tna ana mawe, “Feto to nyõ fi awya? Amu nwof nabi Elia hah yama u. Nyõ fi bi Elia fe mfe a?” Ait yawe “Mfe.” Tna ana mawe, “Allah yawe meen Ait ybis nabi roto sait yama ye. Nyõ fi nabi retait, fe mfe a?” Ait yawe, “Mfe.” ");
INSERT INTO ayz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ana mtu mawe, “Feto to nyõ fi awya? Kbe amu hah ne nmo nkyas kʼraa ro mbis amu nma to, tna kbe amu nkyas nwe bawya?” ");
INSERT INTO ayz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tiwya Allah ybis nabi Yesaya yama ykom bokom sau. Bokom reto mkyas raa sait ro meen yama. Tna Yohanes yawe, “Jõ fi ait ro tiwya nabi Yesaya ykyas yawe, ‘Kbe raa sait yamoʼt tabam ro riamo sau tna ykyas bo ro Allah matim wia. Ykyas yawe, “Mbetrot iso mkah Tuhan yama!”’” ");
INSERT INTO ayz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ana ro raa mbis weto to taro raa ro Farisi. ");
INSERT INTO ayz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tna ana mawe kʼYohanes mawe, “Nyõ fi Mesias fee, nabi Elia fee, tna nabi roto sait reto fee ye. Awya ybis re nyõ baptis raa fo?” ");
INSERT INTO ayz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ait yawe, “Jõ fi raa ro baptis anu mkah aya sai. Menohe raa roto sait yros su ysya anu wefo ye. Tna anu wase Ait fares. ");
INSERT INTO ayz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jõ tama tkyas Ait wia matim. Tna fo Ait yama. Ait retait yase toni yiwer Jõ. Tna jõ toof mkah bo skur sandal rAit to fee.” ");
INSERT INTO ayz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bo weto to, Yohanes ykyas mam Betania. Remo reto mhau mam Aya Yordan majoh ti brat, ti ayõ maut. Ait baptis raa mam beto. ");
INSERT INTO ayz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Rabu ti fo, Yohanes ymat he Yesus yama. Tna Yohanes yawe kʼraa ro hre mari ait yawe, “Nmat, Ait ro yama fi. Ait ynan fi domba maku ro Allah ybis yama. Ait tait Raa ro yama yyon iro wanu beta. ");
INSERT INTO ayz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ait oh mi riwai tkyas kʼanu tawe, ‘Jõ tama tkyas Ait wia matim. Tna fo Ait yama. Menohe Ait refi yase yiwer jõ. Tiwya fnya mabe jõ fefares to, Ait yhau bait wia oh.’ ");
INSERT INTO ayz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jõ tama baptis raa mkah aya afo re raa ro Israel mhar Ait. Tinyi rau to, jõ wase Ait ye. ");
INSERT INTO ayz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ati ro Allah ybis jõ baptis raa mkah aya to, jõ wase Ait fares. Menohe Allah yerif Ait kʼjõ yawe, ‘Soh nyõ nmat Har aJõ mroh mhau abyõ kʼRaa sait to, Ait oh metait kbe baptis raa mkah Har aJõ.’ Tna mabo oh. Tkyas bo ro jõ tmat kʼanu tawe: Tmat Har ro Tuhan haberek mnan fi ruu merpati sau. Tna fru mbam uu mama mroh abyõ kʼAit. ");
INSERT INTO ayz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bo refo tasu tmat tna tkyas tawe Ait tait Ku ro Allah yare.” ");
INSERT INTO ayz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tna rabu ti fo Yohanes ysya kuber (murid-murid) wait mabo ewok mros mam weto. ");
INSERT INTO ayz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tna Yohanes ymat he Yesus frit yamo tna yawe, “Nmat, Domba maku ro Allah yama oh metait.” ");
INSERT INTO ayz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kuber ro Yohanes mabo ewok reto mari bokyas reto tibyo sikba ait tna kro Yesus. ");
INSERT INTO ayz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus siur, ymat ana mbewok reto kro Ait mamo mam tis tna ytu kʼana yawe, “Anu mbewok saso bawya meto?” Tna ana mtu bo kʼAit mawe, “Guru; nyõ njin mam woyõ?” ");
INSERT INTO ayz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesus yawe, “Nma nmat.” Tibyo ana mbewok msya Ait mamoʼt amah ro Ait yhau. Ayõ ro jiit hreha bo feto. Tna ana hre mkyas bo su mamo snok mam ayõ hawer. ");
INSERT INTO ayz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kuber mabo ewok ro masen kro Yesus reto to, sait yasom Andreas. (Ait tait Simon-Petrus yao.) ");
INSERT INTO ayz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tna Andreas yamo fooh saso yao Simon tna yawe, “Amu tru Mesias oh!” (Reto oh mi Kristus.) ");
INSERT INTO ayz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tna ymen yao yakah yamo yo kʼYesus. Yesus yasu yrom Simon tna yawe kʼait yawe, “Nyõ fi ku ro Yunus yare. Kbe raa mtu nasom ‘Kefas’.” (Reto oh mi Petrus.) ");
INSERT INTO ayz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tna rabu ti fo Yesus yawe yamoʼt provinsi ro Galilea. Ait yamo saso Filipus tna yawe, “Nama kro Jõ.” ");
INSERT INTO ayz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipus tait raa ro Betsaida. Betsaida to remo ro Andreas ysya yao Petrus rana. ");
INSERT INTO ayz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tna Filipus yamo saso Natanael tna yawe kʼait yawe, “Amu nkai Ait ro tiwya Musa ykyas mam Watum ro Allah. Ait ro tiwya nabi na mkyas ye! Yasom Yesus. Ait retait tait Yusuf yare ybam remo ro Nazaret!” ");
INSERT INTO ayz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Menohe Natanael yawe, “Hemba! Feto to bo ro moof aro mbam Nazaret oto?” ");
INSERT INTO ayz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tna Filipus yawe, “Nama bmo tna kbe nyõ nesait nmat!” Ati ro Yesus ymat Natanael yama to yawe, “Ait retait raa Israel ro yhaf moof. Bosruf aro mhau kʼait fee. Ait ja yno bo mnan si raa Israel ro yoof.” ");
INSERT INTO ayz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael ytu bo kʼYesus yawe, “Fyi re Nyõ nhar jõ to?” Tna Yesus yawe, “Riwai Filipus ytu nyõ fefares to, Jõ tmat nyõ oh hre mam ara mair tno.” ");
INSERT INTO ayz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael yawe, “Bi Guru: Nyõ fi Ku ro Allah yare, Nyõ fi Raja ro nbo raa ro Israel.” ");
INSERT INTO ayz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus yawe kʼait yawe, “Riwai tawe tmat nyõ hre mam ara mair oh mi nyõ smot Jõ to? Bo sair reto maku sai. Jõ kbe terif bo ati ro mase aro hair kʼnyõ. ");
INSERT INTO ayz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kbe nmat ayoh mato nkro tna nmat malaikat na maut mroh abyõ kʼJõ. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'.” ");
INSERT INTO ayz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mam ti ro tuuf to, raa makyõ bokyõ mam remo ro Kana. Raa sait yoo fai sau. (Kana to mhau mam provinsi ro Galilea.) Yesus yme mamoʼt bokyõ reto ye. ");
INSERT INTO ayz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tna raa moo taah mee kʼYesus ysya kuber wAit ye. Tna ana mamoʼt bokyõ reto beta. ");
INSERT INTO ayz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Raa makyõ bokyõ reto tna anggur maya mkak. Tibyo Yesus yme mamo mo kʼAit mawe, “Yesus; anggur maya fo mkak oh.” ");
INSERT INTO ayz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Menohe Yesus ye yawe kʼau yawe, “Nyõ nama nawe bo reto kʼJõ fyi? Jõ tno bo ro mno raa mhar Jõ to fefares. Oon reto sboh fefares. Jõ thar bo woJõ.” ");
INSERT INTO ayz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Menohe yme masen mamo mkyas bo kʼsryan na. (Sryan baro mhau tna siwyan bo ro bokyõ reto.) Yesus yme mawe, “Bo bawya ro Ait ybis kʼanu nno to, nno oh.” ");
INSERT INTO ayz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yesus ymat baah marak (tempayan) ro mase trion ntamam mhau. (Baah weto to ja raa mse aya mkah bo raa myon matem wana mnan fi raa ro agama rana ja mno soo oh. Baah weto to ja raa mror aya 100 liter bo feto mam sau-sau.) ");
INSERT INTO ayz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tna Yesus yawe kʼsrian weto yawe, “Nmo nwyan aya nkah nma. Tna nror mam baah weto matot beta.” Sryan weto mari tna mamo mwyan aya mama tna mror matot. ");
INSERT INTO ayz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tna Yesus yawe kʼsryan weto yawe, “Tna nwyan aya reto kebet baro nror mam hawereh sau. Tna nbo nmo nee kʼbi ait ro yisoh bo sohmaam to, yata sanet yari wia.” Tibyo ana moo aya baro mamo mee kʼbi ait yata. ");
INSERT INTO ayz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","(Riwai Yesus yno aya mboh mam baah weto haberek mamo anggur maya.) Ana makah mamo mee tna bi retait yata baro sanet. (Ait wase anggur maya ro msu refo mbam mam woyõ. Sryan weto mesait mhar.) Bi retait sanet yari he aya reto msu. Anggur maya reto to, mafah rau to moof ati. Tna bi ait ytu kʼait ro ymen fnya retait yama. ");
INSERT INTO ayz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Tna yawe kʼait yawe, “Ja raa moo anggur maya ro msu mee kʼraa mata matim wia. Raa mata ro moof reto tibyo bisir. Tna kbe tis rau to, raa masyõ anggur maya ro mkair to mee kʼraa mata. Menohe riwai nyõ nabe anggur maya ro moof refo mamo snok mam wore mfo refo tna nyõ nasyõ nee kʼraa mata!” ");
INSERT INTO ayz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesus yno bo msai reto yerif yase rAit oh mefo. Bo msai ro tinyi reto Yesus sair mam Kana ro mhau mam provinsi ro Galilea. Tna kuber wAit smot Ait mawe Ait yase toni. ");
INSERT INTO ayz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tna fo Yesus ysya yme, yao na, msya kuber wAit mroh mamo sia mamoʼt remo ro Kapernaum. Tna mhau mam beto ti baro bo feto. ");
INSERT INTO ayz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Korat ro Paskah makyon rau to kine oh. Tna Yesus yaut yamoʼt Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ait yamo twok mam Samu ro Allah tna ymat he raa masim sapi,domba, msya ruu merpati bo. Tna ymat he raa taro hre mam ambar wana tna tukar pitis ye. Raa ro srim moo pitis wana mee kʼraa weto. Tna raa weto mee pitis mauf ro Yahudi kʼana si ye. ");
INSERT INTO ayz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesus ymat raa mno bo weto tibyo yoo too sau yfen mnan cambuk bo feto. Tna ybo ymok-mak sapi msya domba ro raa masim weto frok msam mbam Samu ro Allah mato. Tna Ait haberek-barak ambar ro raa hre mkah bo moo pitis mee si kʼraa. Tibyo pitis wana somya-meya. ");
INSERT INTO ayz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tna Ait yawe kʼana ro masim ruu merpati weto to yawe, “Anu nno bawya meto ee? Tubat ruu wanu wefo fo nkah nmo to! Samu ro Taja refo fo samu ro raa masim-asam bo to fee!” ");
INSERT INTO ayz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kuber wAit mmat bo ro yno to, mnaut mawe Bokom ro Allah, far-far sau mkyas mawe: “Tmat Samu aNyõ to thaf myoh!” ");
INSERT INTO ayz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tna raa ro Yahudi mastako Yesus mawe, “Nyõ nno bo feto mkah bawya! Awya ro ybis ee! Nyõ awya re nno bo feto to? Mfi bo Nyõ nawe Allah ybis Nyõ nama to, sik nno bo msai sau tna amu nmat. Nno bo ro merif Allah yatak rAit tna fo kbe amu smot Nyõ.” ");
INSERT INTO ayz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tna Yesus yawe kʼana yawe, “Soh anu nihabah samu refo to, kbe Jõ sgi te u to mkah ti tuuf sai.” ");
INSERT INTO ayz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tna ana mawe kʼAit mawe, “Amah refo tii raa sgi sgi tahun trion 46 wia tna mkak. Fyi re nyõ nawe sgi mkak mkah ti tuuf sai a?” ");
INSERT INTO ayz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Menohe ati ro Yesus yawe 'samu' reto to, Ait fret bo yawe Ait yetsu rAit yesait meen yajat tna mam ti ro tuuf to, ait yrok yasen. ⌞Reto to bo msai ro kbe yno re kbe raa mmat tna smot Ait.⌟ ");
INSERT INTO ayz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","(Meen Yesus yrok yasen tna fo kuber wAit mnaut bokyas ro tiwya Ait ykyas reto, tna ana srau wana mrok mbrah. Tibyo ana mhar yum oh mawe Bokom ro Allah msya bokyas ro Yesus reto sioh fee; bo mabo oh.) ");
INSERT INTO ayz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mam wore raa makyõ Korat ro Paskah to, Yesus yhau mam Yerusalem. Tna Ait yno bo msai mawat. Tibyo raa msis-sas smot Ait. ");
INSERT INTO ayz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Menohe Yesus yhar raa mhaf wana to. Yhar yawe kbe ana mros smot Ait tu fee. Tibyo Ait smot (percaya) ana toni fee. ");
INSERT INTO ayz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yesus yhar bo ro raa mnaut mam srau mato wana to. Yhar oh. Feto to ytu bo ro raa mnaut mam srau mato wana fee. ");
INSERT INTO ayz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Raa ro Farisi sait yasom Nikodemus. Ait tait raa manes ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mti oh tna ait yama yo kʼYesus tna yawe, “Guru; raa aro mno bosair mnan mfi Nyõ feto fee, soh Allah yatam ait fee. Tibyo amu nhar nwe Nyõ Allah ybis.” ");
INSERT INTO ayz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tna Yesus ykyas bofret yawe, “Soh raa sait yawe yamo raa mana ro Allah yamo Raja ybo to, kbe ait yhah ye yamo yfi ku mees u. ⌞Au oh mi ku ro fnya mabe fee, menohe ku ro Allah yesait yabe mkah Har rAit.⌟ Soh raa retait yamo ku ro Allah yabe fee, kbe yamo raa mana ro Allah yamo Raja ybo to fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus wase bofret ro Yesus ykyas reto tna yawe, “Fyi re raa ro mabi oh hah me tna fnya mabe u mun ro ewok?” ");
INSERT INTO ayz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus yawe, “Soh raa sait yawe yamo raa mana ro Allah yamo Raja ybo to fyi? Tawe fnya me mabe ait u fee. Tawe Allah oh mi yabe Ait. Yako hawe sai kbe ait yawe Allah yabe mkah aya ye tna mkah Har rAit ye. Bokyas ro ati oh mefo. ");
INSERT INTO ayz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ati ro fnya mabe ku to, mabe ku mees. Ku mees retait yetsu rait to metsu ro tna. Menohe riwai tawe, ‘Soh raa mawe mamo raa mana ro Allah wAit to, kbe yhah ye yamo yfi ku mees u.’ Bo fret reto to, tkyas tawe: Ati ro Allah yabe ku mkah Har rAit to, raa retait yhaf, srau rait haberek. Har ro Tuhan mno yhaf srau rait haberek mamo mnan Yaja Allah yhaf msya srau rAit. Feto tibyo yamos rait to yamos ro tna. ");
INSERT INTO ayz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Allah ‘yabe raa mun ro ewok u’ mkah Har rAit saah. Tibyo raa mhaf, srau wana haberek, mrok moof to. Nyõ ktak bo ro tkyas reto ma! ");
INSERT INTO ayz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Foos mfi to mamo tiyo-teya sai. Tna anu wase foos reto mbam woyõ. Anu bmat foos fee. Anu bri au hmu sai. Tna Har ro Tuhan mno raa mhaf, srau wana haberek to, anu bmat fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus yawe si kʼYesus yawe, “Bo reto mno fyi?” ");
INSERT INTO ayz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus yawe, “Nyõ namo guru tna raa ro Israel ja mari nyõ ye: Fyi re nyõ wase! ");
INSERT INTO ayz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nnaut: Amu nkyas bawya ro amu nhar. Tna amu nkyas bawya ro amu nmat oh. Menohe anu, raa manes ro Israel, ja hawe bo nri bokyas ramu. ");
INSERT INTO ayz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Riwai tkyas bo ro ja mabo mam tabam refo sai. Menohe anu srau fee. Anu nnaut bo weto mamo-me fares. Soh Jõ tkyas bo ro ja mabo mam sawro ro Allah to, kbe anu nfot fee ye. Feto to, tkyas bo maja ro Allah kʼanu fefares. ");
INSERT INTO ayz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Raa aro mamoʼt sawro rAit fefares. Menohe Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Jõ tbam sawro reto frok tama oh.” ");
INSERT INTO ayz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tna Yesus ykyas kʼNikodemus yawe, “Tiwya Musa yhau mam tabam ro riamo. Tna yoo tembaga yfen aban. Yfen tna yoo ara sau yse aban ro yfen mam ara reto makit uu abyõ. Tna yati mros. Nnaut aban reto. Tna nnaut bo ro kbe raa mno mai kʼJõ: Meen 'Ait ro Yroh Yama Yfi Raa Sai' tait, kbe raa mfot. Tna kbe ana moo Jõ mse mam ara abyõ uu mnan anya mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ait kbe raa teta abyõ afo re raa beta ro smot (percaya) Ait to, kbe ana mhau hame wajin. ");
INSERT INTO ayz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Allah yatmof raa ro tabam refo toni. Tibyo yasen ysan Ku rAit sait tomu yamaʼt tabam refo. Yno afo re awya sai ro smot tna msam wai kʼAit kbe mhau hame wajin. Kbe yhai fee. ");
INSERT INTO ayz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Allah ybis Ku rAit yroh yama re yoo safo mana ymit kʼraa ro tabam refo fee. Menohe Ku rAit yama afo re yno riof kʼraa. ");
INSERT INTO ayz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Awya ro smot tna msam wai kʼAit to, kbe bi Ait yoo safo mana ymit fee. Menohe awya ro smot Ait to fee, kbe safo mana mhau kʼait oh. Raa taro smot Ku ro Allah rAit sait tomu fee. Smot Ait fee tibyo ana mesait masom safo mana wana weto. ");
INSERT INTO ayz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Au oh meto: Kek reto mama tabam refo oh. Menohe raa hasu amur toni bana. Ana nksoh mno safo. Ana hawe kek reto. Feto tibyo Allah yoo safo ymit kʼraa weto. ");
INSERT INTO ayz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Awya ro yno safo to ait knait kek. Ait hawe bo yama kene mam kek. Ait waa re kbe kek reto ntara bo ro ait yno mkair tna raa mmat. ");
INSERT INTO ayz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Menohe awya ro kro iso ro ati reto to, ksoh yamaʼt wore wo kek. Yama re kbe raa mmat he bo ro ait yno weto mnan si bo ro Allah yawe, yno mkah tak ro Allah rAit.” ");
INSERT INTO ayz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesus ykyas bo weto mkak. Tna fo ysya kuber wAit masen mamoʼt yuk roto mam provinsi ro Yudea. Mhau mam beto tna Ait baptis raa. ");
INSERT INTO ayz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tna Yohanes ja baptis raa ye. Ati reto to, Yohanes yhau mam Ainon kene mam Salim. Mam beto to aya mawat. Tna raa mawat mama mo kʼait mawe ait baptis ana. ");
INSERT INTO ayz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ti reto Yohanes raa mfot mbu mam bui mato fefares.) ");
INSERT INTO ayz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tna kuber ro Yohanes wait mkyas bo msya raa ro Yahudi sait. Ana santri bo mkyas bo mafa raa ro agama Yahudi ja mno soo oh. Ana mkyas iso ro raa misoh ana moof afo re Allah ymat ana. ");
INSERT INTO ayz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kuber ro Yohanes weto mamo mo kʼait tna mawe, “Guru; Raa ro taa ysya nyõ mam aya ro Yordan tino tait, Ait ro nyõ nerif kʼamu to, Ait baptis raa ye. Tna raa msis-sas mamo mo kʼAit.” ");
INSERT INTO ayz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tna Yohanes yawe, “Allah ybis raa mno bo rAit. Tna Ait oh mi Raa ro yoo tak yee tibyo raa weto mtai mno bo rAit. Soh Allah ybis fee, kbe raa mno bo feto fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Taa anu nesait nri bo ro tkyas tawe kʼanu tawe, ‘Jõ fi Mesias fee. Jõ fi raa ro Allah ybis tama tatim wia.’” ");
INSERT INTO ayz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tna Yohanes fret bo yawe, “Mesias yama to yama yfi raa sait ro ymen fnya. Tna jõ tnan fi yafoh rait. Yafoh rait yhau siwyan bo re kbe raa makyõ bokyõ. Yafoh retait yhau siwyan bo mam remo ro fnya reto. Ait ro yoo fnya reto yama tna yafoh yari ait ymai to, yafoh retait ksoh toni. Ynaut yawe, ‘Fnya refo fo fnya ajõ fee; au sikba jõ mamo msya Ait retait, moof toni.’ Mesias yama tna raa msis-sas mamo mo kʼAit to, jõ simaut toni. Mfi bo raa moo fnya to, ja raa makyõ bokyõ. Jõ tnan fi ait sait ro ymen fnya yafoh rait. Yafoh retait siwyan bo beta. Tna huwya re kbe ait ro yoo fnya yama. Yari he ait yama tna simaut toni. Feto to jõ simaut mase tari he Yesus yama. ");
INSERT INTO ayz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mfo refo Ait yamo Raa ro ati. Tna yamo yase renti yiwer jõ. Jõ fi raa ro ati fee. Tna te taku renti ye. ");
INSERT INTO ayz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ait ro ybam sawro ro Allah yroh yama tait yase ybo raa beta. Menohe ait ro yama ybam tabam refo to, raa ro sei sai. Ykyas bo ro tabam refo sai. Ait ro yama ybam sawro ro Allah tait yase yiwrek raa beta. ");
INSERT INTO ayz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ait ro yroh yama retait yama ykyas bombra ro Ait ymat msya bo ro yari mam sawro ro Allah. Menohe raa aro mari bo ro Ait ykyas to fee. ");
INSERT INTO ayz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ana ro mari bokyas ro Ait ykyas to mhar mawe, ‘Allah tait ja ykyas bo ro mabo.’ ");
INSERT INTO ayz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Allah yoo Har rAit mnan si yee kʼMesias. Tna ybis Ait yama. Tibyo Ait tait ykyas bokyas ro mbam kʼAllah. ");
INSERT INTO ayz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yaja yhafri Ku rAit. Tna ysan bombra beta kʼAit ye. Yawe yamo Raja ybo bombra beta. ");
INSERT INTO ayz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Awya ro smot Ku rAit kbe yhau hame wajin. Menohe awya ro hawe bo yari Ku rAit to, ro yiwana bokyas rAit to, kbe ait fri kmo ro mbam kʼAllah mamo snok hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Yesus yber raa mawat tna baptis raa mawat miwer Yohanes. Yohanes baptis raa mabo kbet sai. (Yesus yesait baptis raa fee, kuber wAit oh mi ja baptis raa.) Raa ro Farisi mari he Yesus yber raa mawat. Feto tibyo Ait sikba provinsi ro Yudea hah yamoʼt provinsi ro Galilea. ");
INSERT INTO ayz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yesus yamoʼt Galilea to Ait yamo frit iti rabin raa ro Samaria. ");
INSERT INTO ayz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tna snok mam remo ro Samaria sau ro masom Sikhar. Sikhar mhau kene msya tabam ro tiwya Yakub ysan ku rait Yusuf. ");
INSERT INTO ayz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Mam weto aya mato sau ro tiwya Yakub yabah. Snok mam aya mato reto tna kuber ro Yesus mamo twok mam remo saso boit ro mait. Yesus yhai rowyõ iso ro yamo. Tibyo yhau bait mam aya mato reto hre sne hoh. Ayõ ro 12 baas bo feto. Yesus hre kri-kri fo, fai ro Samaria sau mama mwyan aya. Tna Yesus huwya yayoh aya kʼau yawe, “Noo aya baro nee kʼJõ tata.” ");
INSERT INTO ayz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Menohe au mawe kʼAit mawe, “Nyõ fi Raa ro Yahudi. Tna jõ fo fnya ro Samaria. Fyi re Nyõ nayoh aya tee kʼNyõ nata?” (Ja raa ro Yahudi msya raa ro Samaria miranya fee.) ");
INSERT INTO ayz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus yawe, “Soh nyõ nhar bouum ro Allah yawe yuumto kʼraa to, tna soh nhar awya oh mi yayoh aya kʼnyõ metait, kbe nyõ oh mi nayoh bo kʼJõ. Tibyo kbe Jõ too aya tee kʼnyõ nata to. Aya reto to mnan fi aya masu ro miyi yoyo.” ");
INSERT INTO ayz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Fai au reto mawe, “Bo ro Nyõ nbo re nwyan aya to marak. Tna aya mato refo miyõ mrit toni. Fyi re Nyõ ntru aya ro mnan fi aya masu ro miyi yoyo reto? ");
INSERT INTO ayz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Hohos ramu sait yasom Yakub. Tiwya yabah aya mato refo tna ysan kʼamu. Ait yesait ywyan aya mbam aya mato refo yata ye. Tna ku wait msya sapi wait ro ysia beta moo aya refo mata ye. Fyi, nawe Nyõ nase niwrek Yakub a?” ");
INSERT INTO ayz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus yawe, “Ja raa ro mata aya refo kbe mhai sbit u. ");
INSERT INTO ayz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Menohe aya ro Jõ too tee kʼraa to hayah. Awya ro yata aya ro Jõ too tee kʼait to, kbe yhai sbit u fee mamo snok mam hame wajin. Aya ro Jõ too tee kʼait yata reto to, haberek mamo aya masu mam kʼait yhaf mato frok. Tna aya ro Jõ too tee to, awya ro yata to, kbe yhau hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Fai reto mayoh kʼAit mawe, “Noo aya reto baro nee kʼjõ tata. Tna kbe thai sbit u fee. Tna meen thah tama twyan aya refo u fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus ybis kʼau yawe, “Namo ntu naa, tna hah nmaʼt wefo.” ");
INSERT INTO ayz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tna au mawe, “Jõ tsya raa aro fee.” Yesus yawe, “Bo ro nyõ nawe reto mabo oh. ");
INSERT INTO ayz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Raa mabo trion maat ro nyõ nsya. Tna mfo refo ro ysya nyõ yhau mam amah tait nyõ naa metait fee. Bokyas anyõ reto mabo to!” ");
INSERT INTO ayz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Au mawe, “Jõ tnaut tawe Nyõ fi Nabi ro Allah ybis nama fo. ");
INSERT INTO ayz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amu hohos wamu ro Samaria ja bibi Allah to, mamoʼt atu rno. Menohe raa wanu ro Yahudi to, mawe raa bibi Allah mam Yerusalem sai.” ");
INSERT INTO ayz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ait yawe, “Nari bo ro Jõ tawe fo: Ayõ ro meen mama to, anu kbe nhar Taja aJõ. Mam wore weto to, anu nbaut Ait mam atu rno u fee tna mam Yerusalem u fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Anu raa ro Samaria nbaut Ait ro anu wase. Menohe amu raa ro Yahudi nbaut Ait ro amu nhar. Riof ro mase mama mbam raa ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Menohe ayõ ro kbe mama to Har ro Tuhan kbe mkyas betoo bi Ait kʼraa re mhar bo mbaut Ait mkah mhaf ro ati. Feto kbe raa mhar bo mbaut Allah, tna mbaut Ait mam woyõ-woya sai. Allah ksoh bo raa mbaut Ait mfi feto. Tawe kʼanu tawe ayõ rau mama oh. Allah tait yfi raa fee: Yetsu marak. Allah tait har. Tibyo awya ro yawe ybaut Ait to, yako hawe sai kbe ybaut Ait mkah yamos rait ye tna tomer yhar yhaf rAit kaket ye.” ");
INSERT INTO ayz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tna au mawe, “Jõ thar tawe, Mesias (ro raa mtu mawe Kristus to) kbe yama. Yama, tna kbe betoo bombra refo beta kʼamu.” ");
INSERT INTO ayz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tna Yesus yawe, “Jõ fi Ait oh.” ");
INSERT INTO ayz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti reto kuber ro Yesus wAit hah me. Tna mmat he Yesus hre ykyas bo ysya fai sau. Tibyo mrok ktak. Ana mawe mtu bo bawya ro ana mbewok mkyas. Tna mawe mtu fyi re Ait ykyas bo ysya fai reto. He mfe, ana shait sai. ");
INSERT INTO ayz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Fai au sikba bo ro mwyan aya akus mam yuk reto, tna mhoh mamoʼt remo mawe kʼraa mawe, ");
INSERT INTO ayz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nma nmat raa ro riwai jõ tkai mam aya mato reto! Ait ykyas bo kʼjõ tna yhar bombra ro tiwya jõ tno beta. Ait retait Kristus fe awya?” ");
INSERT INTO ayz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ana mari bo ro au mkyas kʼana tna masen frok mbam remo reto mamo mmat Yesus. ");
INSERT INTO ayz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wore au marak to, kuber ro Yesus mawe kʼAit mawe, “Guru; noo boit baro nait!” ");
INSERT INTO ayz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Menohe Ait yawe, “Mfe, Jõ tse boit ro anu nhar fee. Boit reto to, tait oh.” ");
INSERT INTO ayz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tibyo ana mkyas kʼanya mawe, “Raa aro mayõ boit mama mee kʼAit yait oh a?” ");
INSERT INTO ayz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesus yawe, “Jo tari bo kʼAit ro ybis Jõ tama. Tna boit aJõ oh mefo: Tno bo ro yawe reto beta mkak.” ");
INSERT INTO ayz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tna Yesus yawe, “Ja raa mawe ‘Snyi jiit naut tna ora ro armato manes. Tna fo raa saraf.’ Menohe Jõ tawe kʼanu tawe bo ro armato Taja rAit make manes oh. Nesait nmat oh! ");
INSERT INTO ayz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Raa taro furere bo manaf (benih) mam armato ro Allah rAit wia oh. Mfo refo bo reto make manes. Tna anu fo raa ro mryoh bo ro armato rAit. Anu nryoh bo ro armato reto tibyo meen raa mhau hame wajin. Raa ro tiwya furere bo manaf tna ysya raa ro yryoh bo ro armato reto to, Allah yoo boren yaren ana mbewok ye. Tna mbewok ye simaut mase. ");
INSERT INTO ayz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ja raa mkyas mawe, ‘Raa sait furere bo manaf tna raa roto sait yama yryoh mafer rau.’ Mabo oh. ");
INSERT INTO ayz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jõ tbis anu nmo nryoh bo mam armato ro tii anu nkah fee. Raa roto mkah oh mimyoh mbtek, tna anu nmo nkai mafer rau reto sai.” ");
INSERT INTO ayz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Raa ro Samaria msis mari bo riwai fai reto mawe: “Ait yhar bombra ro tiwya jõ tno beta.” Tibyo ana smot Yesus mawe Ait fi Kristus. ");
INSERT INTO ayz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tna ana mawe mabe Yesus mawe yhau ysya ana. Tna Ait yhau mam remo rana reto ti ewok. ");
INSERT INTO ayz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ana ro Samaria mari bo ro Yesus ykyas tibyo raa msis u mama smot Ait mawe bo ro Ait ykyas to mabo oh. ");
INSERT INTO ayz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tna mawe kʼfai au mawe, “Riwai bo ro nyõ nkyas sai oh mi amu smot Ait. Mfo refo amu nesait nri bokyas ro Ait ykyas. Tna amu nhar nwe Ait oh mi Raa ro yama yoo riof ro mase yee kʼraa ro tabam refo.” ");
INSERT INTO ayz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","⌞Ybam provinsi ro Yudea Yesus hah yamoʼt provinsi ro Galilea fares fo. Yamo iso ro Sikhar.⌟ Yhau mam Sikhar ti ewok reto mkak tna fo yamo renti yamoʼt Galilea. ");
INSERT INTO ayz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tiwya raa ro rabin rAit hawe mari Ait. Feto to Yesus yawe, “Nabi ro Allah ybis yama ykyas bo wAit to, ja raa ro rabin rait yesait to, hawe mari ait.” ");
INSERT INTO ayz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Raa ro Galilea tiwya mamoʼt Yerusalem makyõ korat ro Paskah. Tna mam beto ana mmat bo Yesus yno bo ro msai. Tibyo ati ro Yesus hah yamo snok mam Galilea to, raa rabin reto ksoh mmat Ait. ");
INSERT INTO ayz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tna Ait hah yamoʼt remo ro Kana u mam Galilea. Taa Ait yno aya mboh haberek mamo anggur maya mam remo reto. Yhau mam Kana kri-kri fo, pegawai istana sait ku rait kiyam samyoh mam remo ro Kapernaum. ");
INSERT INTO ayz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bi retait yari he Yesus ybam Yudea hah yamaʼt Galilea. Yari feto, tibyo ait yamo yo kʼYesus tna soh-soh kʼAit yawe, “Bobot, nama nisoh ku ajõ ro kiyam msai tna kerit yhai!” ");
INSERT INTO ayz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus yawe kʼpegawai retait yawe, “Soh anu nmat Jõ sair bo ro hnah fee, tna nmat Jõ tno bo ro msai fee ye, anu aro kbe smot Jõ fee.” ");
INSERT INTO ayz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tna pegawai retait soh-soh u yawe, “Bobot, nama fooh be kbe ku ajõ kene wo yhai oh!” ");
INSERT INTO ayz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesus yawe, “Namo oh. Ku anyõ retait kiyam marak.” Pegawai retait smot bo ro Yesus yawe reto. Yhar yawe Ait yatak yisoh ku rait. Tna re ait yamo. ");
INSERT INTO ayz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ait yamo fares mam iso maka fo sryan wait mama mkai ait mawe, “Ku anyõ to kiyam marak oh!” ");
INSERT INTO ayz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tna pegawai retait ytu bo kʼana yawe, “Kiyam marak to riwai ayõ jya bo feto?” Tna ana mawe, “Iis mam ayõ ro sau baas bo feto kiyam marak.” ");
INSERT INTO ayz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tna ait yrok srau mbrah yawe, “Ae, iis ayõ reto oh mi Yesus yawe, ‘Ku anyõ yoof oh.’” Tibyo pegawai retait ysya fnya, kukek, raa wait beta smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesus ybam provinsi ro Yudea yamoʼt Galilea tna yno bo msai ro ewok refo mam beto. ");
INSERT INTO ayz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ti baro firwas tna raa ro agama Yahudi makyõ korat rana sau naut. Tna Yesus yaut yamoʼt Yerusalem u. ");
INSERT INTO ayz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kota ro Yerusalem to aya mbair sau mhau mam makit rau. Mhau kene mam Mato ro Domba. Mam mai ro Ibrani to, aya mbair reto masom Betesda. Tiwya raa mkait yuk trion maat ro mhau mur aya reto, mkah bo raa hre baas iti. ");
INSERT INTO ayz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Raa mawat ro mafa kiyam ja mjin mam yuk weto to: Raa ro kiyam, msya raa ro masu mboh msya ro maa maka msya ro matem maa bo mhai to ja mjin mam yuk reto. Raa weto beta hre mwof aya mata mnah-nah. ");
INSERT INTO ayz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Malaikat sau mroh tna mno aya reto mnah-nah. Tna awya ro yroh wia yatim mam aya reto to, raa retait kiyam mrok marak. ");
INSERT INTO ayz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mam yuk reto raa sait ro yafa bo tahun trion 38 bo feto yhau. ");
INSERT INTO ayz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tna Yesus yama tna ymat ait yjin mam beto. Yhar yawe ait tait kiyam ooh oh. Tibyo ytu kʼait yawe, “Nyõ ksoh bo noof fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Menohe ait yawe si kʼYesus yawe, “Tuhan; mam ati ro malaikat mno aya masu refo mata mnah-nah fo tesait ttai troh fee. Raa ro tubat jõ mse troh mam aya to marak. Tawe tamo troh menohe raa roto taro mroh wia oh.” ");
INSERT INTO ayz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus yawe kʼait yawe, “Beah aam anyõ tna nasen namo oh.” ");
INSERT INTO ayz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ayõ reto si fo raa retait yoof. Tna ait yasen beah aam rait ybo tna yamo. Yesus yisoh raa retait mam ayõ ro raa agama Yahudi ja ntmoh (hari Sabat). ");
INSERT INTO ayz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ait ro kiyam marak retait yamo to, tna fri raa manes ro Yahudi baro. Ana mmat he bi ait ybo aam rait yamo to. Ait yiwer Watum ro agama ranu oh meto. Tibyo ana mastako ait mawe, “Ayõ ro raa wanu ntmoh refo: Nasom aam anyõ namo to nno fyi?” ");
INSERT INTO ayz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ait retait ye yawe, “Bi Ait ro riwai yno re jõ kiyam marak retait oh mi ybis jõ yawe tubat aam ajõ tna tamo fo.” ");
INSERT INTO ayz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Awya oh mi ybis nyõ tubat aam anyõ namo fi?” ");
INSERT INTO ayz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","“Twase ye. Ait yarak mam raa makin wefo.” ");
INSERT INTO ayz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ti baro firwas tna Yesus fri ait retait mam Samu ro Allah mato. Tna yawe kʼait yawe, “Nyõ kiyam marak mefo to, ne nno iro u to ma. Soh nawe nno bo ro mkair-kar u to, kbe kiyam ro samyoh toni mama mai kʼnyõ u.” ");
INSERT INTO ayz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tna raa retait frok yamo ykyas kʼraa manes ro Yahudi yawe, “Yesus, Ait oh mi yno re jõ kiyam marak fo.” ");
INSERT INTO ayz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ana ro Yahudi hawe bo Ait yisoh raa mam ayõ ro raa ntmoh. Tibyo ana tomer mfot Yesus. ");
INSERT INTO ayz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Menohe Yesus yawe kʼana yawe, “Taja tait ykah bo rAit yoyo mamo snok mam ayõ refo. Feto to Jõ tkah bo ye.” ");
INSERT INTO ayz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Riwai Yesus yisoh raa mrok moof mam ayõ ro raa ntmoh ye, tna fo Ait yawe Allah tait Yaja rAit ye. (Feto Ait yawe ynan anya ysya Allah.) Tibyo raa ro Yahudi mhaf kek renti tna mawe saso fyi re mfot Yesus tna mame. ");
INSERT INTO ayz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesus ykyas Ait yesait kʼraa manes ro Yahudi yawe, “Nnaut: Bo bawya-bawa ro Ait retait ymat Yaja yno to, Ait yno ye. Tibyo Ait yesait yno bo aro kar fee. Ymat sas bo ro Yaja ybo yno. Tna Ait kro yno bo weto sai ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Allah yhafri Ku rAit. Tna yerif kʼAit bombra ro Ait yno beta. Tibyo Ait ytai yno bo ro Yaja yno ye. Kbe yerif bo ro msai toni miwrek weto ye. Tna anu nmat to nrok ktak. ");
INSERT INTO ayz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Taja yatak yno raa ro mhai mrok masen, tna yno raa maam ye. Feto ye Ku retait yatak ye yno raa maam ye. Yno kʼawya ro Ait ksoh sai. ");
INSERT INTO ayz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taja yesait ytu srah ro raa sait bo yari fee. Yawe Ku rAit ytu srah raa beta. ");
INSERT INTO ayz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Taja yno feto afo re kbe raa beta mmat Ku rAit, tna waa Ku rAit ye mfi bo ana mmat Ait, tna waa Ait ye. Awya ro ymat tna waa Ku rAit to fee, ait waa Taja ro ybis Ku rAit yama to fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nnaut: Awya ro yari bokyas aJõ, tna smot Ait ro ybis Jõ tama to, meen yhau hame wajin. Ait retait meen Allah yno safo mana ymit kʼait fee. Ait yisnak hai yamoʼt roon ro hame. ");
INSERT INTO ayz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Raa ro mhai oh kbe mari Ku ro Allah ymai. Tna raa ro mari kaket to, kbe maam. Makyon reto mama oh mefo. ");
INSERT INTO ayz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Taja Ait yafos rAit mhau tu mroon mawyõs. Raa aro mabe Ait fee. Yhau sai. Tna yno re Ku rAit, Ait yafos rAit mhau tu mroon mawyõs ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Tibyo Allah yoo tak yee kʼJõ yawe Jõ fi tros susai ttu srah raa ro tabam refo. Bokyas ro ati oh mefo. ");
INSERT INTO ayz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nri bo ro Jõ tawe to ktak ma. Ayõ rau meen mama to tna raa beta ro mhai oh kbe mari Ait ymai. ");
INSERT INTO ayz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ana weto raa sama oh, menohe kbe ana beta mrok masen: Ana ro tiwya mno bo ro moof to, mrok masen tna kbe mhau hame wajin. Ana ro tiwya mno bo ro mkair to, kbe mrok masen ye. Tna Jõ ttu srah ro ana mno. Tna too safo mana tmit kʼana weto ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jõ tesait ai ttu srah rana fee. Tesait tno bo sau kar fee. Jõ ttu srah tari to mnan bawya ro Allah ybis kʼJõ. Tna ja tno mnan si bo ro Ait yawe. Tno bo aro mkah ksoh aJõ tesait fee. Tno bo to tawe tno Taja yhaf mnan. ");
INSERT INTO ayz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mfi bo Jõ tesait aran tkyas tawe Jõ fi Ku ro Allah yare, kbe raa aro mari fee. Tna smot fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Menohe raa roto sait yhar Jõ tna ykyas Jõ ye. Tna thar tawe bokyas rAit reto to mabo tu oh.” ");
INSERT INTO ayz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tna Yesus ykyas kʼana ro Yahudi u yawe, “Anu nbis raa mamo mo kʼYohanes tna mtu bo kʼait oh. Ait ymat bo ro tno tna ykyas Jõ kʼanu. Ykyas bo mabo. ");
INSERT INTO ayz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ja tari bokyas mbam raa sai to fee. Menohe Jõ tkyas Yohanes bokyas rait afo re kbe anu nri ait tna nkai riof. ");
INSERT INTO ayz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tiwya Yohanes yama ynan kek ro mait. Yama tna ti baro to kek reto mram anu fo ye. Au oh mi ti reto to, anu nsu maah tna nksoh nri bokyas rait ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tawe Jõ fi Ku ro Allah yare to. Tna bombra ro Jõ tno merif mawe Taja oh mi ybis Jõ tama fo. Tama tno bo ro Ait ybis to tno fo. Yohanes ykyas yawe Jõ fi Ku ro Allah yare ye. Bokyas rait reto merif Jõ tasom aJõ kebet sai. Menohe bombra ro tno merif bo reto kaket re raa mhar mawe Allah oh mi Raa ro ybis Jõ tama. ");
INSERT INTO ayz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Taja ro ybis Jõ tama fo, yesait ykyas yawe Jõ fi Ku rAit. Menohe anu smot Jõ fee. Tibyo anu nri ymai fee. Tna anu nmat yasu rAit fee ye. Tna bokyas rAit anu nse mam nhaf mato wanu fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Anu ksoh nwe meen anu nhau hame wajin. Feto to anu ja hre nmat Bokom ro Allah. Nwe anu nmat tna nhar Bokom reto kaket. He mfe. Bokom ro Allah oh mi mkyas Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Menohe anu hawe bo nma no kʼJõ afo re meen nhau hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tna Yesus yawe kʼraa manes ro Yahudi yawe, “Jõ saso tasom aJõ fee. Reto bo ro ati fee. ");
INSERT INTO ayz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jõ thar anu. Thar tawe anu nhafri Allah mam nhaf mato wanu to fee. ");
INSERT INTO ayz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Allah yesait ybis Jõ tama tkyas yasom rAit kʼanu. Tibyo Jõ tama. Menohe anu nitrah nhaf wanu kʼJõ fee. Anu nri bo ro Jõ tkyas fee. Raa taro kbe mama mo kʼanu tna mkyas bonaut rana mesait sai. Fyi re anu nri ana? Ana mkyas masom rana mesait. Fyi re anu nitrah nhaf wanu kʼraa weto? ");
INSERT INTO ayz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Anu ksoh raa mmat anu tna bibi anu. Menohe anu sorni nwe Allah ymat anu to, bo ro ati. Tibyo anu ja nwe nno bo re kbe Ait bibi anu to fee. Nno fyi meto? Allah yesait aran Raa ro yase. Au oh mi anu hawe smot Jõ fea! ");
INSERT INTO ayz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Meen Jõ tamo to kʼTaja. Tamo tna taun boun kʼanu to fee. Bi Musa oh mi yaun baun kʼanu oh. Bo ro Musa ykom mesait maun boun kʼanu. Anu ninaut nwe, ‘Amu nri Musa msya Watum rait reto. Feto kbe amu nkai riof.’ He mfe. ");
INSERT INTO ayz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Watum ro Musa mkyas Jõ. Soh anu nfot Watum rait kaket to, maami anu kbe smot Jõ ye. ");
INSERT INTO ayz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Menohe anu nmat Watum ro Musa to, nbo nno kaket fee. Feto kbe anu niwana bo ro Jõ tkyas ye.” ");
INSERT INTO ayz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Ti baro firwas, tna Yesus hah yamoʼt provinsi ro Galilea. Tna snyi reto to, kene wo raa ro Yahudi makyõ korat ro Paskah. Tna Yesus yroh yamoʼt maru ro Galilea. Tna frit yamoʼt ati tino. (Maru reto raa mtu masom maru ro Tiberias ye.) Raa mhar mawe Yesus yatak yno bo msai yisoh raa ro kiyam sor. Tibyo raa mawat mjor mama kro Ait. Tna fo Yesus yaut yamoʼt atu sau. Tna hre su ysya kuber wAit. ");
INSERT INTO ayz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus ymat he raa msis-sas maut mamaʼt atu reto mo kʼAit. Ait yawe kʼFilipus yawe, “Raa mawat mam befo fo, kbe anu boo roti mam woyõ bee kʼana mait fo?” ");
INSERT INTO ayz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesus yawe ytu feto sanet bosmot ro Filipus. Yesus yesait yhar bo bawya ro kbe Ait yno oh.) ");
INSERT INTO ayz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipus yawe, “Pitis mabut mkah anu boo roti bee kʼana beta mait. Mfi bo pitis dinar trion 200 bo feto, kbe ana makin mait roti kebet-kebet sai to. Pitis mabut sai.” ");
INSERT INTO ayz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kuber ro Yesus rAit roto sait yasom Andreas. Andreas tait Simon-Petrus yao. Tna Andreas yawe, ");
INSERT INTO ayz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ku yaku sait yros mam befo. Tna ait yse roti trion maat msya syoh mana ewok. Menohe bo wait weto mabut ye. Raa msis-sas fo.” ");
INSERT INTO ayz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesus yawe, “Nbis raa weto hre mte.” Mam yuk reto bosafom moof. Tna raa weto beta hre mte. Raa sme wore weto beta to raa mabo trion 5000 bo feto. ");
INSERT INTO ayz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tna Yesus yoo roti weto, tna skabuk yayoh asik mase kʼAllah. Tna ybo saim kʼraa ro hre mam weto. Ana moo nksoh rana sai. Tna yoo syoh weto to, yno saim mnan anya ye. ");
INSERT INTO ayz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Raa beta sohmaam mhaf matu. Tna Yesus yawe kuber wAit yawe, “Noo keranjang nmo soo roti msya syoh mabuf ro mhau to nfau mam keranjang. Mbeak ma.” ");
INSERT INTO ayz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Riwai roti mabuf maat aran sai. Tna raa mait mhaf matu. Tna kuber wAit soo roti mabuf ro mhau fares to, mfau mam keranjang. Mfau keranjang trion 12 matot. ");
INSERT INTO ayz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Raa mmat bo msai reto tibyo mawe kʼanya mawe, “Mamo snok ayõ mfo refo anu bwof nabi ro Allah ybis sait yama. Amu nnaut nwe Ait refi fi nabi retait yroh yama tabam refo!” ");
INSERT INTO ayz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ana baro mnaut mawe mabe Yesus yhau ysya ana. Ana saim kʼanya mawe mikoh Ait yamo Raja rana. Yesus yhar yawe ana mnaut bo reto tna hawe. Tibyo Ait sesa Ait tna yesait yaut yamoʼt atu sau. ");
INSERT INTO ayz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mti knu-knu fo, kuber ro Yesus mroh mamoʼt maru. ");
INSERT INTO ayz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Arin mti oh to, tna Yesus yama yo kʼana fefares. Ana maut mam wiak rana mawe miin frit matim mamoʼt remo ro Kapernaum. ");
INSERT INTO ayz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ana miin mamo, mamo tna foos mase mama, figyõm mase mama mai ye. ");
INSERT INTO ayz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ana miin mamo kilo mara maat bo feto oh. Tna ana mmat he Yesus yama. Yama abyõ mam aya mata yo kʼana. Mmat tna ana waa. ");
INSERT INTO ayz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Menohe Ait yawe kʼana yawe, “Waa ma, Jõ mefi.” ");
INSERT INTO ayz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ana mari mai rAit tibyo ana beta simaut. Tna mawe, “Nama naut oh!” Yaut hre tna mam weto si oh to, ana mmat he wiak rana snok mam joh ro Kapernaum oh. ");
INSERT INTO ayz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Raa mawat mhau akus fares mam maru maam ati tino. ⌞Mam wore wo Yesus yoo roti yayoh asik mase kʼAllah tna yee kʼraa mait to.⌟ Tna rabu ti fo, ana mnaut mawe, “Iis wiak sau aran mros mam joh. Tna mam wiak reto kuber ro Yesus mesait aran maut mamo. Yesus fee. Feto to Ait yaut wiak ryo?” Mhau tna wiak roto baro mbam remo ro masom Tiberias mama msyoha mam joh reto ye. ");
INSERT INTO ayz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Raa ro mhau mam weto fares mmat he Yesus ysya kuber wAit marak. Feto tibyo ana maut wiak weto mamoʼt Kapernaum mawe saso Ait mam beto. ");
INSERT INTO ayz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Raa weto mkai Yesus mam maru tino. Tna mtu bo kʼAit mawe, “Guru; tija oh Nyõ snok wefo fo?” ");
INSERT INTO ayz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesus yawe, “Anu saso Jõ fyi? Anu nmat bo msai ro Jõ tno menohe bohar wanu to mabuf fares. Anu niit roti tna nhaf matu. Reto oh mi anu saso Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tomer nkah bo re nkai roti ro niit sai to ma. Roti to bo ro tabam refo sai. Rau ro moof to, anu nnaut nmos wanu. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Saso boit ro mbam kʼJõ oh. Boit ro Jõ too tee kbe mnis fee, kbe mkak fee. Boit reto to mno raa mhau hame wajin. Taja ykyas Jõ yawe, ‘Ait fi, Jõ thaf mnan.’” ");
INSERT INTO ayz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tna ana mtu kʼAit mawe, “Bo bawya sai ro kbe amu nno re Allah ksoh amu to?” ");
INSERT INTO ayz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tna Yesus yawe kʼana yawe, “Bo ro Allah ksoh anu nno to fefo: Smot tna nsam wai kʼAit ro Allah ybis yama to.” ");
INSERT INTO ayz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ana mawe, “Mfi bo Nyõ raa ro Allah ybis, tna nawe Nyõ nase niwer Musa to, sik nno bo msai sau naut u. Afo re amu nmat wia tna smot Nyõ. Kbe nno bo bawya? ");
INSERT INTO ayz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tiwya tinyi hohos wanu mhau mam yuk ro riamo. Tna Allah ysair boit manna ro ana mait. Bokom ro Allah mkyas mawe: ‘Boit mfi roti mroh mbam uu mbtek. Tna Musa yoo yee kʼana mait.’” ");
INSERT INTO ayz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Menohe Yesus yawe, “Musa fee. Nnaut: Taja oh mi tii yno roti mbtek mroh mbam uu to. Tna mfo refo yoo roti ro ati yee kʼanu niit. ");
INSERT INTO ayz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ait ro yroh yama ybam Allah tna yno raa ro tabam refo maam to, Ait retait tait roti ro ati ro mbam kʼAllah oh metait.” ");
INSERT INTO ayz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ana mayoh mawe, “Tuhan;roti reto, noo nee kʼamu niit yoyo oh.” ");
INSERT INTO ayz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus yawe, “Jõ refi fi roti reto. Tno raa mhau hame wajin. Awya ro yama yo kʼJõ tait yhai sre u fee. Tna awya ro smot Jõ to, kbe yhai sbit fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Riwai tawe, ‘Anu nmat Jõ menohe anu smot Jõ fefares.’ Mabo oh. ");
INSERT INTO ayz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Menohe Taja ykyas raa roto taro yawe, ‘Ana ro Jõ tsan kʼNyõ to, ana weto kbe mamo raa woNyõ.’ Ana weto beta kbe mama mo kʼJõ. Tna awya ro yama yo kʼJõ to, kbe Jõ tikyak ait fee. ");
INSERT INTO ayz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jõ tbam Allah troh tama tno bo ro Jõ tesait ksoh to fee. Menohe tama tno bo ro Taja yawe. ");
INSERT INTO ayz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Allah oh mi ybis Jõ tama to. Tna Ait ybis yawe Jõ kmot ana afo re ana beta beroh smot Jõ. Ana beta ro ysan kʼJõ to Ait ksoh yawe kbe sait yarak o yakus bo to fee. Tna meen tno re ana beta mrok masen mam ti ro tabam refo haberek u. ");
INSERT INTO ayz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Allah ksoh yawe awya sai ro ymat Ku rAit tna smot Ait to, meen yhau hame wajin. Tna meen Jõ tno ana beta mrok masen mam ti ro tabam refo haberek.” ");
INSERT INTO ayz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Riwai Yesus yawe, “Jõ refi fi roti ro mbam kʼAllah.” Tibyo raa ro Yahudi knot-knot Ait. ");
INSERT INTO ayz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mawe, “Menohe Ait tait Ku ro Yusuf yare sai! Anu bhar Ait yaja yme oh! Fyi re Ait yawe Ait yroh ybam Allah?” ");
INSERT INTO ayz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tna Yesus yawe, “Knot-knot ma. ");
INSERT INTO ayz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taja ybis Jõ troh tama tabam refo. Tna Ait oh mi ykuk raa taro mama mo kʼJõ. Tna soh Ait ykuk ana weto fee, ana mesait mtai mama mo kʼJõ fee ye. Tna meen Jõ tno ana beta mrok masen mam ti ro tabam refo haberek u. ");
INSERT INTO ayz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tiwya Allah ybis nabi rAit sait yama ykom bokyas rAit yawe, ‘Allah kbe yfi guru ykyas watum rAit kʼraa beta.’ Awya sai ro yari bo ro Allah yawe tna yse mam yhaf mato rait to, kbe ait retait yama yo kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Raa aro bo mmat Taja fee. Ait ro yama ybam Allah yesait aran ymat Taja oh. ");
INSERT INTO ayz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nnaut: Awya ro smot Jõ to, meen yhau hame wajin. ");
INSERT INTO ayz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jõ tno raa mhau maam hame wajin. Mnan fi roti ro mno re raa mhau maam mam tabam refo. ");
INSERT INTO ayz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Riwai anu nkyas nwe, ‘Anu hohos na tii mait manna ro mbam Allah mam yuk ro riamo.’ Mait fea! Menohe beta mhai. ");
INSERT INTO ayz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Roti ro mbam Allah oh mi Jõ mefi. Tna raa ro mait roti refo kbe mhai fee. ");
INSERT INTO ayz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jõ fi roti ro mama mbam kʼAllah. Awya ro yait roti refo kbe yhau hame wajin.Roti refo fo kwiyan aJõ. Tsan kwiyan aJõ afo re tno riof kʼraa ro tabam refo.” ");
INSERT INTO ayz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mari feto raa ro Yahudi santri anya mawe, “Fyi re raa refi yawe yoo kwiyan rAit yee kʼanu bbo?” ");
INSERT INTO ayz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesus yawe, “'Ait ro Yroh Yama Yfi Raa Sai' tait, Soh anu nbo kwiyan rAit fee, tna soh nta mees rAit fee ye, kbe nkai riof ro hame fee. Bokyas ro ati oh mefo. ");
INSERT INTO ayz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Awya ro yabo kwiyan aJõ tna yata mees aJõ to, meen yhau hame wajin. Tna jõ tno ait yrok yasen mam ti ro tabam refo haberek u to. ");
INSERT INTO ayz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwiyan aJõ to boit ro niit oh meto. Tna mees aJõ to aya ro nta oh meto. ");
INSERT INTO ayz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Awya ro yabo kwiyan aJõ tna yata mees aJõ to yhaf sau su ysya Jõ renti, tna Har aJõ mjin mam ait yhaf rait renti ye. ");
INSERT INTO ayz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Taja ro yawyos retait ybis Jõ tama. Tna Ait yno re Jõ thau tawyos ye. Feto ye awya ro yabo kwiyan aJõ to yhau yawyos ye. ");
INSERT INTO ayz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jõ fi roti ro mbam Allah. Hohos wanu tiwya mait manna. Tna beta mhai. Menohe roti ro Jõ tkyas refo mnan anya msya manna reto fee. Awya ro yait roti aJõ refo meen yhau hame wajin.” ");
INSERT INTO ayz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Bo wefo beta Yesus ykyas mam samu watum ro Kapernaum. ");
INSERT INTO ayz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mari bokyas ro Yesus reto, tna kuber ro Yesus wAit mawat mawe, “Bokyas refo samyoh toni. Kbe awya ro yari tna yse kʼait?” ");
INSERT INTO ayz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus yhar kuber wAit mmai kʼanya bokyas rAit reto. Tna yawe, “Anu kmo bokyas reto a? ");
INSERT INTO ayz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Meen Jõ hah u taut tamoʼt oo ro tii thau wia. Mfi bo meen anu nmat bo reto to, kbe anu ne nnaut nwe bawya? ");
INSERT INTO ayz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Har ro Tuhan mno raa ro tabam refo, mhaf, srau wana mrok haberek. Mno re ana weto moo ‘mamos ro tna’. Raa mesait tomer mno mhaf wana haberek to, mtai fee, mkai riof ro hame wajin fee. Menohe bokyas ro Jõ tkyas kʼanu to bokyas Har ro Tuhan rAu. Tna bokyas reto mno raa mkai riof ro hame wajin. ");
INSERT INTO ayz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Anu nkin wefo to, taro smot Jõ fee.” (Maban tinyi wore Ait yamo guru Yesus yhar wia oh awya ro smot Ait fee, tna awya ro kbe hren serek Ait.) ");
INSERT INTO ayz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tna Yesus yawe, “Reto oh mi Jõ tkyas kʼanu tawe soh Taja ybis wia to fee, kbe raa sait ytai yama yo kʼJõ fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tna ayõ reto kuber wAit mawat sikba Ait, hawe bo kro Ait u fee. ");
INSERT INTO ayz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tna Yesus ytu kuber wAit mabo 12 reto yawe, “Fyi, anu nwe sikba Jõ ye fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon-Petrus yawe kʼAit yawe, “Tuhan; amu kbe nmo no kʼawya u? Nyõ oh mi nkyas bokyas ro mno re raa mhau hame wajin. ");
INSERT INTO ayz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Amu smot Nyõ tna nhar nwe, Nyõ fi Ait ro Allah Ybis Yama.” ");
INSERT INTO ayz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tna Yesus yawe, “Anu nbo 12 refo Jõ tsok oh. Menohe anu wefo sait tait kabes mhau kait yhaf mato rait.” ");
INSERT INTO ayz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ait ykyas Yudas, ku ro Simon Iskariot yare. Ait ysya raa mabo 12 ja kro Yesus. Menohe kbe ait besruf Yesus kʼraa re mame yajat.) ");
INSERT INTO ayz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Raa manes ro Yahudi mawe mame Yesus yajat. Tibyo Ait hawe yamoʼt provinsi ro Yudea fee. Yamo yur mam provinsi ro Galilea sai. ");
INSERT INTO ayz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ti weto kene wo raa ro Yahudi ja mamoʼt Yerusalem makyõ korat rana sau. Korat refo masom Korat ro Sbyah. ");
INSERT INTO ayz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Tna Yesus yao na mawe kʼAit mawe, “Nyõ namo ye fea!” Ana smot Ait fefares ye. Tibyo mamus tna mbesre Ait mawe, “Nasen sikba befo. Namoʼt Yudea afo re raa ro kro Nyõ kbe mmat bo msai ro nno. Soh raa sait yawe yamo raa ro kbe masom to, ja ait ymyõt bo bawya ro yno to fee. Ja yno mam wore raa makin masu mmat. Soh Nyõ nno bo msai to, nno mam wore raa beta mmat tna mhar!” ");
INSERT INTO ayz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesus yawe kʼana yawe, “Jõ tamo fefares. Ayõ ro Jõ tamo to fefares. Ayõ rau snok fefares. Menohe anu fo, nmo ti woyõ-woya sai to moof. Bo ati fee. ");
INSERT INTO ayz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Raa ro wase Allah ja knait anu fee. Menohe Jõ tkyas bo ja raa mno to, tawe ana mno bo ro mkair-kar. Tibyo ana knait Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nesait nmoʼt korat reto oh. Jõ tamo fefares. Ayõ aJõ reto mama fefares.” ");
INSERT INTO ayz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesus ykyas bo feto tna yhau bait mam Galilea wea. ");
INSERT INTO ayz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesus yao na matim wia mamoʼt korat reto. Tna Ait yesait yamo yrof. Ait yasen yamo wai. Raa aro mhar fee. ");
INSERT INTO ayz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mam korat reto raa manes ro Yahudi saso Ait. Tna mtu kʼanya mawe, “Ait miya mefi?” ");
INSERT INTO ayz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Raa mawat mkyas Ait kmun-kmun kʼanya. Taro mawe, “Bi Ait tait Raa ro yoof.” He taro mawe, “Mfe, Ait besruf raa mawat.” ");
INSERT INTO ayz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Menohe ana waa raa manes ro Yahudi. Tibyo ana mkyas Ait fari fee. Mkyas rere kʼanya sai. ");
INSERT INTO ayz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Korat reto raa makyõ ti baro oh tna Yesus twok mam Samu ro Allah. Tna yasen ykyas bo. ");
INSERT INTO ayz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Raa manes ro Yahudi mari Ait ykyas bo moof kaket, tna ana mrok miskawowo. Ana mawe, “Raa refi yhar bo mnan si, menohe ykom bo ysya guru agama to fee! Ykom bo mam remo rAit sai.” ");
INSERT INTO ayz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus yawe, “Bo ro Jõ tkyas refo bokyas aJõ fee. Bokyas refo mbam kʼAit ro ybis Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Awya ro ksoh yari tna yno bo ro Allah yawe to, kbe yesait yhar yawe soh bokyas ro Jõ tkyas refo fo mbam Allah fe mfe a. ");
INSERT INTO ayz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Awya ro ykyas bokyas rait yesait to saso yasom rait yesait. Ait ksoh yawe raa mmat ait tna bibi ait. Menohe soh anu nmat raa sait ykyas bi roto taro yasom rait to, nri ait. Ait ro ykyas yasom bi ait ro ybis ait yama to, ait retait saso raa yasom rait sai. Ait retait oh mi raa ro ja ykyas bokyas ro ati. Bosruf aro mhau kʼait fee.” ");
INSERT INTO ayz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tna Yesus yawe, “Tii Musa yoo Watum ro Allah yee kʼanu fe mfe a? Fyi re anu wefo aro nri Watum reto nbo nno fee? Fyi re anu tomer nme Jõ?” ");
INSERT INTO ayz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tna raa msis weto mawe kʼYesus mawe, “Kabes mbo Nyõ a? Awya yawe yame Nyõ to?” ");
INSERT INTO ayz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus yawe, “Tiwya Jõ tno bo msai sau mam ayõ ro anu ntmoh to. Nmat bo msai reto tna anu nrok niskawowo. ⌞Tna anu kmo Jõ nwe tisoh raa ro kiyam mam ayõ ro anu ntmoh to ma. ");
INSERT INTO ayz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Menohe anu nesait nno bo mam ayõ ro anu ntmoh to ye.⌟ Tiwya Musa ysi bo kʼanu yawe anu nkom ku sme wanu (sunat). (Bo reto Musa sair fee, hohos ranu tiwya ysi bo reto kʼanu.) Bo reto ait ysi tibyo anu ja nno mam ayõ ro raa ntmoh to ye. ");
INSERT INTO ayz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ati ro anu nkom ku sme wanu mam ayõ ro ntmoh to, anu nnaut nwe nno feto afo re niwer Watum ro Musa reto fee. Feto to fyi re anu kmo Jõ? Jõ tisoh raa yetsu rait muuf mrok moof mam ayõ reto. ");
INSERT INTO ayz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Anu nsu nmat bo mam ti sau sai. Tna ja nuun boun fooh. Nno feto ma. Rau ro moof to, anu nmat ati ewok ye. Nmat sas tna nnaut bau mam nhaf mato wia matim. Tna kbe nhar kaket. Nno feto wia tibyo nhar tu oh nwe bo ro raa mno aro to mkair fe mfe a.” ");
INSERT INTO ayz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tna raa ro Yerusalem baro mawe, “Ait refi oh mi raa saso mawe mame mefi, fe mfe a? ");
INSERT INTO ayz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mfo refo Ait ykyas bo wore raa mawat mmat tna waa fee. Menohe raa aro mkyas bo mai kʼAit fee. Raa mabi wanu mhar mawe Ait fi Mesias a? ");
INSERT INTO ayz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","He mfe. Ait refi anu bhar Ait ybam rabin hayo yama. Meen Mesias yama to, kbe raa sait bo yhar Ait ybam hayo yama to fee.” ");
INSERT INTO ayz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus ykyas bo mam Samu ro Allah mato fares tna ykyas ymai fari yawe, “Anu saah nhar Jõ fi awya, tna nnaut nwe anu nhar nwe Jõ tbam rabin hayo tama. Menohe anu wase fares: Allah oh mi ybis Jõ tama fo. Jõ fi Raabis sai. Tna bo ro Ait yawe to mabo tu oh. Menohe anu wase Ait. ");
INSERT INTO ayz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tiwya thau su tsya Ait. Tna Ait oh mi ybis Jõ tama fo. Tibyo Jõ thar Ait.” ");
INSERT INTO ayz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesus yawe feto tibyo raa mawe mfot Ait. He mfe. Ayõ ro raa mfot Ait to sboh rau fefares. Tibyo raa sait bo yfot Ait fee. ");
INSERT INTO ayz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Raa weto to, mawat smot Yesus. Ana weto mawe, “Ati ro Mesias ro amu nwof yama to, kbe ysair bo ro hnah mawat miwer Raa refi fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Raa ro Farisi mari he raa mkyas bo reto. Tna fo imam manes msya raa ro Farisi mbis raa sbe ro kmot Samu ro Allah reto to, mawe mamo mfot Ait. ");
INSERT INTO ayz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tna Yesus yawe kʼraa mam Samu ro Allah yawe, “Thau boti sai tsya anu. Tna fo kbe hah tamo to kʼAit ro ybis Jõ tama. ");
INSERT INTO ayz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kbe anu saso Jõ. Menohe yuk ro thau to anu ntai nma fee. Tibyo kbe nkai Jõ fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Raa ro kro agama Yahudi weto mawe kʼanya mawe, “Kbe yamo tiyo tna re kbe anu bmat Ait u fee? Kbe yamoʼt rabin roto rauk? Tna yo kʼraa agama wanu ro mhau mam rabin reto? Yamo ykyas bo kʼana rauk? Soh mfe Ait yamo yo kʼraa ro wase agama ranu rauk? ");
INSERT INTO ayz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Riwai yawe, ‘Kbe anu saso Jõ. Menohe nkai Jõ fee.’ Tna yawe, ‘Yuk ro thau to anu ntai nma fee.’ Reto fyi oh meto?” ");
INSERT INTO ayz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Korat reto ayõ ro tis rau to ayõ ro ati. Tna Yesus yros ytu yawe, “Awya ro yhai sbit to, yama yo kʼJõ re yata aya!” ");
INSERT INTO ayz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","39","Yesus ykyas aya reto to, ykyas Har ro Tuhan. Tna yawe, “Awya ro smot Jõ to Bokom ro Allah refo mkyas ait retait. Mkyas bofret mawe, ‘Kbe ait yfi aya sau. Tna aya refo mbam ait miyi mamo. Aya reto mno re raa mhau hame wajin.’” (Meen Yesus raa mame yajat tna hah yamoʼt sawro ro Allah. Tna Yaja yoo bo yase rAit yee yno Yesus yrok yase toni. Tna fo ysan Har ro Tuhan mhau kʼraa ro smot Ait. Kbe mhau mam mhaf mato wana. Yesus yase toni fefares to, ysan Har ro Tuhan kʼraa wAit fefares ye.) ");
INSERT INTO ayz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Raa mari bo ro Yesus ykyas reto, tibyo taro mnaut mawe, “Ait refi fi nabi ro anu bwof Allah ybis yama tu oh mefi!” ");
INSERT INTO ayz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Taro mawe, “Mfe, Ait refi Mesias!” He taro mawe, “Ah, Mesias ybam Galilea fee! ");
INSERT INTO ayz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bokom ro Allah mawe Mesias ybam kube ro raja Daud. Tna kbe Ait yama ybam Betlehem, remo ro raja Daud tiwya fnya mabe.” ");
INSERT INTO ayz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tibyo raa mkyas Yesus to, ana mhaf sau fee tna santri anya. ");
INSERT INTO ayz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Raa taro mawe mfot Yesus, he mfe; ana sait bo yfot Ait fee. ");
INSERT INTO ayz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Riwai imam manes ro agama Yahudi msya raa ro Farisi to, mbis raa sbe wana mamo mfot Yesus. Raa sbe weto to ja kmot Samu ro Allah reto. Ana masen mamo mfot Yesus. He mfe. Ana hah me mama sai. Tna raa mabi ro agama Yahudi weto mtu bo kʼana mawe, “Fyi re anu nfot Ait nkah nma fee!” ");
INSERT INTO ayz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Raa sbe mawe, “Raa sait ja ykyas bo mnan mfi raa retait ykyas to fee!” ");
INSERT INTO ayz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Raa ro Farisi mawe, “Anu Ait besruf ye a? ");
INSERT INTO ayz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Raa manes aro smot Ait fee. Tna raa ro Farisi aro smot Ait fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ro smot Ait to, raa makin ro wase Watum ro Musa sai. Kbe ayoh mroh kʼana.” ");
INSERT INTO ayz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Bi Nikodemus tait raa manes sait ye. (Tiwya mti sau ait yamo ykyas bo ysya Yesus.) Mfo refo ait hre siret su ysya raa manes taro weto tna yawe kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ati ro anu, raa ro agama Yahudi, btu safo mana bmit raa to, anu ja bkyas safo reto, tna btu bo kʼait bri wia. Watum ranu mbis mawe anu bno feto. Bno feto afo re bhar bo ro raa retait yno kaket wia. Tna fo boo safo mana bmit kʼait retait. Ja anu bfot raa ninya tna bbu wia ma.” ");
INSERT INTO ayz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Raa manes taro mastako Nikodemus mawe, “Amu nnaut nwe nyõ raa ro Galilea ye! Nmat Bokom ro Allah! Amu nhar nwe Allah ybis nabi aro mbam Galilea fee!”  ");
INSERT INTO ayz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tna raa weto sait-sait hah yamoʼt amah rait-rait. ");
INSERT INTO ayz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Menohe Yesus yamoʼt faut ro Zaitun. ");
INSERT INTO ayz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Rabu momo Yesus hah yamoʼt Samu ro Allah. Tna raa mawat mama mo kʼAit. Yesus hre tna ykyas bo kʼana. ");
INSERT INTO ayz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hre ykyas bo tna guruagama Yahudi msya raa ro Farisi baro mama twok. Tna sai ana mfot fai ro mwyah sau tna makah mama. Mama mse au mros susai masuf raa mawat weto. ");
INSERT INTO ayz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tna guruagama msya raa ro Farisi weto mawe kʼYesus mawe, “Guru; fai au refo mwyah msya raa sait kri-kri tna amu nfot. ");
INSERT INTO ayz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Watum ro Musa mawe fnya ro mnan fefo kbe raa mawah fraa mai tibyo majat to! Tna amu ntu bo kʼNyõ: Nyõ nawe kbe amu nno bo bawya? Amu nme au fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(Ana mtu bo reto kʼYesus mawe sanet Ait. Soh Ait ykyas bo ro sre kbe ana maun Ait.) Yesus yari feto to shaitrun bait sai. Tna hre mte, yatem ykom bo bait mam tabam sai. ");
INSERT INTO ayz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Menohe ana beroh mtu mitan kʼAit. Tibyo Ait yasen yros yawe kʼana yawe, “Anu nkin wefo, soh awya ro yno iro fefares meto ee, yasen yama tinyi yoo fraa yai kʼau wia.” ");
INSERT INTO ayz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tna Yesus hre u tna yatem ykom mam tabam u. ");
INSERT INTO ayz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ana mari bo ro Yesus yawe reto tibyo ana sait-sait yamo sikba yuk reto marak. Sait yamo-yamo mbam kʼana ro mabi mamo snok mam ro tna beta. Tna Yesus ysya fai au refo mbewok aran mhau akus. ");
INSERT INTO ayz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesus yasen yros ytu kʼfai au reto yawe, “Raa ro mros wefo sor to, ana beta miyo? Raa aro mamus nyõ fee mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Fai au mawe, “Mfe. Raa aro fee.” Tna Yesus yawe, “Jõ ye tamus nyõ fee. Namo bonyõ. Tna maban mfo refo nno iro u ma.” ");
INSERT INTO ayz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ti baro firwas Yesus ykyas bo u kʼraa mawat. Yawe, “Jõ fi kek ro mno raa ro tabam refo to masu maah. Awya ro kro Jõ to, tafos aJõ mno re ait yasu maah. Tibyo ait yamo ninya mam amur u fee. Too tafos ro tna tee kʼait tna meen yhau hame wajin ye.” ");
INSERT INTO ayz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Raa ro Farisi mari bokyas rAit reto mawe, “Nyõ nesait nkyas Nyõ ai. Feto to bo ro Nyõ nkyas reto to, raa mari fee, kbe mtu sioh.” ");
INSERT INTO ayz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus yawe, “Jõ thar tawe Jõ tbam tiyo tama. Tna thar tawe kbe tamo tiyo ye. Tibyo tesait tkyas Jõ sai to, tna raa saah mhar tro mawe bokyas aJõ reto to, mabo bau yum oh. Menohe anu to wase wore Jõ tama tna wase wore kbe Jõ tamo ye. ");
INSERT INTO ayz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","16","Ati ro Jõ hre susai tna tse srah kʼraa to tno tesait kar fee. Jõ tsya Taja ro ybis Jõ tama to hre su. Tibyo soh Jõ tawe tse srah raa aro tari to, tno mnan si. Jõ tesait tmit safo kʼraa to fee. Menohe ati ro anu ntu srah raa nri to, anu ntu mamyot mfi bo ja raa sei sai mtu bo mari. ");
INSERT INTO ayz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ja anu nri Watum ro Musa. Tna Watum agama ranu reto mkyas mawe, ‘Soh raa mabo ewok mmat bo tna mros mkyas mnan anya to, raa mhar mawe bokyas reto mabo. Raa mtu sioh fee.’ ");
INSERT INTO ayz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Feto Jõ tesait tkyas Jõ ai tna Ait ro ewok to, Taja aJõ. Ait ro ybis Jõ tait ykyas Jõ ye.” ");
INSERT INTO ayz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tna ana mtu kʼYesus mawe, “Naja yhau mam tiyo?” Menohe Yesus yawe, “Anu wase Jõ tna wase Taja ye. Soh anu nhar Jõ to, anu nhar Taja ye.” ");
INSERT INTO ayz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Bo weto Yesus ykyas mam Samu ro Allah, kene wore yuk ro raa mama mruk pitis ro ana msan kʼAllah. Menohe ti ro Yesus yhau mam tabam refo mkak fefares. Ayõ rau snok fefares. Tibyo raa aro mfot Ait fee. ");
INSERT INTO ayz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus ykyas u yawe, “Jõ kbe tamo. Tna anu saso Jõ. Menohe iro ro nno mhau fares. Tibyo meen nhai. Tna yuk ro Jõ tamo to, anu kbe nmo fee.” ");
INSERT INTO ayz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ykyas feto tibyo raa ro Yahudi mtu kʼanya mawe, “Riwai Ait yawe ‘Yuk ro tamo to, anu kbe nma fee.’ Ykyas fyi meto? Kbe takoh Ait a?” ");
INSERT INTO ayz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tna Yesus yawe, “Anu nma nbam te. Tna Jõ fi troh tama tbam uu. Anu fo nbam tabam refo. Menohe Jõ fi tbam tabam refo fee. ");
INSERT INTO ayz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Riwai tawe, ‘Iro ro nno mhau fares tibyo meen nhai.’ Soh anu smot nwe Jõ fi ‘Ait ro Yroh Ybam Uu Yama’ to fee, kbe iro ro nno mhau fares tna meen nhai tu oh!” ");
INSERT INTO ayz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ana mtu kʼAit mawe, “Nyõ fi awya?” Yesus yawe, “Muhrin aro-aro Jõ tkyas betoo kʼanu oh, afo re anu nhar nwe Jõ fi awya. Menohe anu nri fee. ");
INSERT INTO ayz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Thar tawe iro msya bo mkair ro anu nno to mawat. Menohe Jõ tesait kar tmit safo kʼanu fee. Bi Ait sait ybis Jõ tama. Tna Ait oh mi ykyas kʼJõ yawe bo bawya ro Jõ tama tkyas kʼanu. Tkyas bo weto aran sai. Tna bo ro Ait yawe to mabo tu oh.” ");
INSERT INTO ayz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ana wase bo Yesus ykyas Yaja Allah kʼana. ");
INSERT INTO ayz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Feto to Yesus yawe, “Anu kbe tubat Jõ abyõ. Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Anu tubat Jõ abyõ tna fo anu nhar nwe Jõ fi awya. Ja tkyas bo kʼanu afo re anu nhar Jõ awya mefi. Tna kbe nhar nwe tesait kar tno bo aro fee. Menohe tkyas bo ro Taja ykyas kʼJõ to sai aran. ");
INSERT INTO ayz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ait ro ybis Jõ tama to yatam Jõ yoyo. Tna tno bo bawya ro Ait yhaf ksoh sai yoyo. Feto to kbe Ait sikba jõ akus to fee.” ");
INSERT INTO ayz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesus ykyas bo reto tna raa mawat mari tna smot (percaya) Ait. ");
INSERT INTO ayz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesus yawe kʼraa ro Yahudi ro smot Ait yawe, “Soh anu nri bokyas aJõ nbo matak nwe mabo oh to, anu fo kuber woJõ ro ati tu oh. ");
INSERT INTO ayz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kbe anu susit u fee. Kbe nhar nwe bo maja ro Allah to bo ro ati. Tna bohar reto kbe mno anu nros ntak tibyo. Bohar reto mno wa re kbe iro make anu matak u fee. Mno re anu nmo sryan boh u fee.” ");
INSERT INTO ayz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Menohe ana mawe, “Amu fo kube ro Abraham. Tiwya amu nmo sryan ro raa mbis fee. Nyõ nkyas bawya meto ee!” ");
INSERT INTO ayz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tna Yesus yawe, “Nnaut: Tkyas bofret, tawe awya ro yno iro to yfi sryan boh. Iro mbo ait matak. Tna yako hawe sai yno iro. ");
INSERT INTO ayz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Raa ro mamo sryan to, ja mhau tibyo mam amah ro bobot rait fee. Ait ynan fi raa ro amah mato rait reto fee. Menohe ku ro bobot retait yare wotur retait oh mi yhau ysya yaja tibyo. ");
INSERT INTO ayz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tna Bobot retait yawe Ku rAit retait oh mi yatak yno re anu nmo sryan u fee. Mabo oh: Ait yatak re yno wa bo mkair ro make anu matak. ");
INSERT INTO ayz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jõ thar tawe anu fo kube ro Abraham. Menohe anu hawe bo nri bokyas aJõ. Tibyo nwe nme Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Bo bawya ro Jõ tmat Taja yno oh mi tkyas kʼanu. Tna bo ro anu nno to, anu nri nja ranu ybis mfi feto ye.” ");
INSERT INTO ayz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ana mawe, “Abraham tait amu nja ramu!” Menohe Yesus yawe, “Soh anu fo kube ro Abraham wait to, kbe nno bo mnan fi bo ro Abraham tiwya yno ye. ");
INSERT INTO ayz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Menohe anu nwe nme Jõ. Jõ fi raa ro tkyas bo ro ati kʼanu. Bo ro tkyas weto to, tari mbam kʼAllah. Tiwya Abraham yno bo ro mnan fi anu nno reto fee! ");
INSERT INTO ayz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Anu nno bawya ro nja ranu ja yno.” Ana mawe, “Raa mwyah re mabe amu fee! Nja ramu Allah yesait aran!” ");
INSERT INTO ayz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus yawe, “Jõ fi tama tbam Allah. Ait oh mi ybis Jõ troh tama tabam refo. Ksoh aJõ tesait sai oh mi Jõ tama mefo fee. Soh Allah tait anu nja to, meto mi anu ksoh Jõ ye. ");
INSERT INTO ayz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Anu fo ntai nri tna nhar bokyas aJõ fee. Bo bawya mno re anu nri bo ro tkyas to fee? ");
INSERT INTO ayz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kabes yabi (Iblis) tait anu nja ranu. Anu fo raa wait. Ja anu nri bo ro ait ykyas. Mbam tinyi rau Kabes Yabi tait ja yame raa. Ait tait raa ro sioh. Tna ykyas bo ro mabo aro fee. Bo mafa ro ja yno to, ykyas bo sioh. Raa ro ja mkyas bo sioh to, kabes yabi tait maja rana. ");
INSERT INTO ayz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Anu ja nri bo sioh sai. Menohe Jõ tkyas bo ro mabo kʼanu. Tibyo anu nri Jõ fee, smot Jõ fee. ");
INSERT INTO ayz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Anu weto, awya yasu ymat Jõ tno iro? Menohe soh Jõ tkyas bo ro mabo to, fyi re anu smot Jõ fee? ");
INSERT INTO ayz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Awya ro yamo ku ro Allah rAit tait, yari bokyas rAit. Menohe anu fo ku ro Allah wAit fee. Tibyo anu nri bokyas rAit fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Raa ro Yahudi mawe kʼYesus mawe, “Amu nnaut nwe nyõ fi nnan raa ro Samaria. Tna kabes mbo Nyõ!” ");
INSERT INTO ayz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus yawe, “Jõ fi kabes mbo fee. Jõ fi waa Taja. Tari bo ro Ait yawe. Menohe anu fo nri Jõ fee tna waa Jõ fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Bi Ait sait ksoh yawe raa bibi Jõ. Jõ tesait oh mi tomer tno bo afo re kbe raa bibi Jõ fee. Tna bi Ait retait oh mi Raa ro kbe yros susai tna beah srah raa. ");
INSERT INTO ayz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Awya ro yari bokyas aJõ ybo matak to, meen yhai fee. Bokyas aJõ to bokyas ro mabo.” ");
INSERT INTO ayz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Raa ro Yahudi mawe, “Mfo refo amu nhar nwe kabes mbo Nyõ tu oh! Tiwya Abraham yesait yhai oh, tna nabi na sor ro tiwya Allah ybis mama to, mhai beta ye. Menohe Nyõ nawe, ‘Awya yari bokyas aJõ meen yhai fee.’ ");
INSERT INTO ayz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Fyi, Nyõ fi nawe nase niwer nja ramu Abraham a? Ait yhai oh, tna nabi na sor mhai ye. Nyõ fi awya?” ");
INSERT INTO ayz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus yawe, “Soh Jõ bibi Jõ ai to, mafer marak. Menohe Jõ Taja oh mi bibi Jõ. Tna anu nwe Ait retait tait Allah ro anu smot. ");
INSERT INTO ayz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Anu wase Ait. Menohe Jõ thar Ait. Mfi bo tawe Jõ wase Ait to, reto kbe Jõ raa ro sioh-nat tnan mfi anu fo ye! Jõ thar Ait tna bo ro Ait yawe to, tbo matak. ");
INSERT INTO ayz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hohos ranu, Abraham ksoh yinaut yawe kbe Jõ tama. Yhar yawe tama tna ait simaut.” ");
INSERT INTO ayz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tna raa ro Yahudi mawe, “Nyõ 50 tahun fefares! Tna re nawe Nyõ nmat Abraham oh a?” ");
INSERT INTO ayz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus yawe, “Abraham fnya mabe fefares to, Jõ fi ‘Raa ro thau yum boJõ oh.’” ");
INSERT INTO ayz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yawe feto tibyo raa Yahudi ro mros weto sor moo fraa mawe mai Yesus yajat. Menohe Ait ymyõt Ait wai, tna yamo sikba Samu ro Allah mato. ");
INSERT INTO ayz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus yamo tna ymat bi ro yasu mboh sait. Ait retait tii fnya mabe to, yasu mboh bait yum oh. ");
INSERT INTO ayz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tna kuber ro Yesus mtu kʼAit mawe, “Guru; fyi re bi refi fi, fnya mabe to yasu mboh feto? Ait yno iro fe mfe a? Yaja, yme mno iro a?” ");
INSERT INTO ayz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus yawe, “Ait yesait yno iro mi yasu mboh meto fee. Tna raa mabi wAit mno iro ro misti re yasu mboh meto fee ye. Ait yasu mboh afo re kbe raa mmat bo ro Allah yno tna mhar yatak rAit.” ");
INSERT INTO ayz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tna Yesus ykyas bofret kʼana yawe, “Baas fares fo, feto nma, anu bno bo rAit ro ybis Jõ. Kbe mti mama tna hawe sai to, raa aro mno bo fee. ");
INSERT INTO ayz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wore Jõ thau fares mam tabam refo to, Jõ fi kek ro mram tabam refo.” ");
INSERT INTO ayz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesus ykyas mkak tna fo tfeh oot mam tabam. Ait hre tna ysom tabam reto tna mka mfi hrotat. Ait yoo tabam reto karu mam bi ait retait yasu. ");
INSERT INTO ayz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yawe, “Nasen namo nyon nasu mam aya masu ro Siloam.” ('Siloam' mkah mai ro Ibrani to mawe 'raa mbis'. ) Raa retait yamo yyon yasu mam aya reto tna hah yamo to, yasu mrok moof oh. ");
INSERT INTO ayz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Raa mhar mawe ait tait raa ro yasu mboh tna ja hre yayoh bo kʼraa. Tna ana mmat ait yasu ymat bo yamo mam iso. Tibyo mtu kʼanya mawe, “Ait refi awya? Ait fi bi ro ja hre yayoh bo metait fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Taro mawe, “Ait oh metait.” He taro mawe, “Mfe, raa retait yasu ynaif ynan bi retait sai.” Tna ait yesait yisboh kʼana yawe, “Aha, jõ oh mefi.” ");
INSERT INTO ayz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ana mtu kʼait mawe, “Nyõ nno fyi re nasu moof to?” ");
INSERT INTO ayz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ait yawe, “Raa sait ro yasom Yesus yoo tabam kbet yno mka, tna karu mam tasu aJõ. Tna ybis jõ yawe, ‘Namo nyon nasu mam Siloam.’ Tibyo tamo tyon tasu. Tna fo tmat bo!” ");
INSERT INTO ayz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ana mtu mawe, “Raa retait miya?” Ait yawe, “Jõ twase ye.” ");
INSERT INTO ayz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ana weto makah ait ro riwai yasu mboh retait mamo mo kʼraa ro Farisi. ");
INSERT INTO ayz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ti ro Yesus yoo tabam yisoh raa ro yasu mboh retait to, yno mam ayõ ro raa ntmoh (hari Sabat). ");
INSERT INTO ayz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Feto to raa ro Farisi mtu sas kʼait refi ye mawe, “Fyi re Ait yisoh nyõ nasu moof?” Tna ait yawe, “Ait yoo tabam ro hrotat yse mam tasu ajõ. Tna ybis tamo tyon tasu, tna tasu ajõ maah.” ");
INSERT INTO ayz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Raa ro Farisi weto taro mawe, “Raa ro yno bo msai refi fi raa ro Allah ybis fee. Soh Ait Allah ybis meto mi Ait yiwer ayõ ro raa ntmoh feto fee.” Menohe raa taro mawe, “Mfe, raa ro mno iro ja mno bo msai mnan fefo fee!” Tibyo raa ro Farisi masen santri kʼanya feto. ");
INSERT INTO ayz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tna ana mtu kʼait ro riwai yasu mboh tait u mawe, “Nyõ oh mi riwai Ait yisoh. Nyõ nnaut nawe fyi? Ait tait awya metait?” Menohe ait yawe, “Raa retait tait nabi ro Allah ybis yama ykyas bo wAit.” ");
INSERT INTO ayz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Menohe raa ro Yahudi weto mtu sioh mawe tiwya ait retait yasu mboh fee, tna mfo yasu mrok moof to fee. Tibyo ana mtu raa mabi wait mama. ");
INSERT INTO ayz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tna mtu sas kʼana mbewok mawe, “Ait refi ku ranu bewok fe mfe a? Tna ati ro yme mabe to ait yasu mboh fe mfe a? Fyi oh mi mfo ait yasu ymat bo fo?” ");
INSERT INTO ayz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yaja ysya yme mawe, “Ait refi ku ramu. Tna amu nhar nwe ati ro yme mabe ait to yasu mboh yum bait oh. ");
INSERT INTO ayz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Menohe amu wase fyi re ait yasu moof. Tna amu wase awya ro yisoh ait yasu ye. Sik ma ntu kʼait yesait sai. Ait yabi oh tna yesait ykyas bo kʼanu.” ");
INSERT INTO ayz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ana mbewok mhar mawe taa raa ro Farisi mawe, “Awya ro smot Yesus yawe, ‘Ait tait Mesias’ to, kbe amu nikyak ait, nwe ait skabuk su ysya raa ro Yahudi u fee.” Tibyo yaja yme waa raa manes ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Reto oh mi ana mbewok mawe, “Ait yabi oh. Feto to ntu kʼait yesait sai.” ");
INSERT INTO ayz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tna raa ro Farisi mtu kʼait ro riwai yasu mboh refi mawe yama yo kʼana u. Yama tna ana mawe, “Amu nhar nwe Ait ro yasom Yesus retait tait Raa ro ja yno iro. Ait ytai yno re raa masu maah to fee! Nkyas nawe bi Allah yesait oh mi yisoh nyõ re nasu maah. Afo kbe raa bibi Allah.” ");
INSERT INTO ayz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tna ait retait yawe, “Ait retait raa ro ja yno iro fe mfe a? Jõ wase ye! Ro jõ thar to tiwya jõ tasu mboh. Tna mfo refo jõ tmat bo oh.” ");
INSERT INTO ayz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tna raa weto mtu kʼait u mawe, “Ait yno bawya kʼnyõ re nmat bo fo?” ");
INSERT INTO ayz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ait retait yawe, “Riwai jõ tkyas kʼanu oh to, he anu nri fee. Fyi re anu nwe nri u? Anu nwe kbe nmo nkro Ait ye a?” ");
INSERT INTO ayz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ana mari bo ait yawe reto tna mamus ait mawe, “Nyõ fi raa ro namo kuber Raa retait! Amu fo raa ro nri bo ro Musa ykom! ");
INSERT INTO ayz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amu nhar nwe Allah ykyas bo kʼMusa oh. He amu wase Raa retait ybam tiyo meto!” ");
INSERT INTO ayz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tna ait ro tii yasu mboh retait yasah yawe, “Ait yisoh jõ tasu mrok moof, tna anu wase nwe Ait retait ybam tiyo to fyi? ");
INSERT INTO ayz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Anu bhar bwe soh raa ja mno iro to, Allah kbe yari boyoh raa weto fee. Menohe bi Ait yari boyoh kʼraa ro ja mhau mrat msya Ait tna mno bo ro Ait yawe. ");
INSERT INTO ayz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Maban tiwya tinyi mamo snok mam mfo wefo to, raa sait bo yisoh raa ro masu mboh maban mam wore fnya mabe to fee. ");
INSERT INTO ayz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Soh Ait retait raa ro Allah ybis to fee, meto mi Ait ytai yno bo feto fee.” ");
INSERT INTO ayz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tna ana mawe kʼait mawe, “Nbam ti ro nme mabe nyõ to nyo nno iro oh. Tna nyõ fi nawe nama watum bo kʼamu a?” Tna ana mikyak ait mawe ait skabuk su ysya raa ro Yahudi u fee. ");
INSERT INTO ayz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus yari he ana mikyak ait ro yasu maah retait, tibyo yamo saso. Ykai tna ytu kʼait yawe, “Nyõ smot 'Ait ro Yroh Yama Yfi Raa Sai' tait fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bi ait ro yasu maah retait yawe, “Awya metait? Nawe kʼjõ ye re kbe jõ smot Ait ye.” ");
INSERT INTO ayz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tna Yesus yawe, “Ait nyõ nmat oh. Ait ysya nyõ mbewok nkyas bo ngkri to, Ait oh metait.” ");
INSERT INTO ayz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Raa retait yawe, “Tuhan; jõ smot Nyõ.” Tna ait yaka mte ybaut Ait. ");
INSERT INTO ayz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus yawe, “Jõ tamaʼt tabam refo mkah bo ttu srah raa tari. Tama afo re tno raa ro masu mboh to mmat bo. Tna ro masu mmat bo to, tno ana masu mti.” ");
INSERT INTO ayz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Raa ro Farisi mabo baro mros mam weto ye tna mari bo ro Yesus yawe reto. Tna ana mtu kʼYesus mawe, “Fyi? Nyõ nawe amu fo raa ro masu mboh ye a?” ");
INSERT INTO ayz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesus yawe, “Mfi bo anu nsu mboh meto mi safo makan mbtek mai kʼanu fee. Menohe anu nwe anu raa ro nmat bo. Feto to iro ro anu nno to mhau tu.” ");
INSERT INTO ayz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Yesus yawe, “Nnaut: Domba mana mawat mhau mam ana (kandang). Tna ana reto masa rau sau aran sai. Raa sait ja yhau kmot masa reto. Ait ywan tok. Soh raa ro ja ysia domba wait yama to, ait ro kmot masa reto yawe raa refi yama twok. Menohe mfi bo raa sait yama wai, ait twok mam masa rau to fee, ait yaut ana reto yroh ti mato to. Anu bhar bwe ait retait raa ro ysyõf domba. ");
INSERT INTO ayz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ait ro ysia domba yama tna raa ro ja kmot ana masa reto yhar ait yawe, ‘Ae, nama ntruk.’ Tna ait ro ysia domba ytu domba wait weto. Ytu domba weto masom wana tna domba weto kro ait mamo. Domba wait weto mari ait ymai tna fo kro ait mamo. ");
INSERT INTO ayz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ait yakah domba wait weto beta frok. Tna ait yamo. Yamo yatim tna domba weto mhar ait ymai tibyo nkro. ");
INSERT INTO ayz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Menohe soh raa srim sait yama ytu domba weto mama to; kbe domba weto hawe kro ait ye. Ana wase mai rait reto. Tibyo waa tna msam.” ");
INSERT INTO ayz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus fret bo reto kʼana menohe ana wase bo maja rau ro Ait ykyas reto. ");
INSERT INTO ayz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Feto to Yesus yawe kʼana yawe, “Jõ fi tamo masa ro domba twok. ");
INSERT INTO ayz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tiwya raa taro mama tna ksoh mawe raa kro ana. Ana sioh mawe soh raa kro ana to, kbe riof kʼana. He mfe. Raa ro tiwya mama, ti ro Jõ tarak fares to, ana beta raa ro msyõf bo sai. Tna domba mari ana mmai fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jõ fi tamo masa. Awya ro twok mam masa reto kbe ykai riof ro mase. Awya ro yama yo kʼJõ to, ait ynan fi domba ro ja mamo me mkai bosafom ro moof tna mabat. ");
INSERT INTO ayz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Raa taro to mnan fi raa ro mama mawe msyõf domba weto, tna mame domba weto, tna sikowah domba weto. Menohe Jõ tama afo re riof kʼana. Tama re kbe ana mhau bo mninon. Bokyas ro ati oh mefo.” ");
INSERT INTO ayz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","12","Tna Yesus yawe, “Jõ fi Raa ro tsia domba woJõ kaket. Ait ro ja ysia domba wait kaket to, soh ymat mtah rbyoh mama mafit domba wait re mabo to, ait waa fee. Ait yno wa re mtah reto mafit domba wait fee. Ysan yetsu rait mkah riof ro domba wait. Menohe ait ro kmot domba raa to, soh ait retait ymat mtah rbyoh mama mafit domba weto to, kbe ysam yamo sikba domba weto. Tibyo mtah mafit domba taro mabo, tna taro mamo brir-brar. ");
INSERT INTO ayz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Raa retait saso boren ro kbe raa maren sai. Au oh mi ait kmot domba weto. Ait ye ynaut domba weto fee. Ait yisoh ymat domba weto kaket fee. Tibyo ysam sikba domba weto sai. ");
INSERT INTO ayz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Menohe Jõ fi raa ro kmot domba woJõ kaket. Jõ thar domba woJõ sau-sau, tna ana mhar Jõ ye. ");
INSERT INTO ayz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Taja yhar Jõ tna Jõ thar Ait mfi feto ye. Tna Jõ bitsre Jõ tetsu aJõ raa mame afo kbe riof raa ro mnan fi domba woJõ. ");
INSERT INTO ayz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jõ kmot domba woJõ roto taro ye. Ana weto ja mberur su msya domba woJõ wefo fo fefares. Mhau hayah fares. Kbe takah domba weto nma. Kbe ana mari Jõ tmai tna kro Jõ ye. Meen tno re domba woJõ beta mberur su mamo domba mkbair sau. Tna kbe Jõ tesait aran kmot ana beta. ");
INSERT INTO ayz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jõ tsan tetsu aJõ mkah riof raa woJõ weto beta. Reto oh mi Taja yhafri Jõ. Meen tsan tetsu aJõ raa mame mkah domba woJõ tna kbe trok tasen. ");
INSERT INTO ayz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Raa sait bo ytak tetsu aJõ kʼJõ fee. Jõ ksoh aJõ sai oh too tsan. Taja yno Jõ tatak re too tafos aJõ tsan tna tatak re tesait trok tasen ye.” ");
INSERT INTO ayz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Raa ro Yahudi mari bokyas ro Yesus reto tibyo mhaf sau fee. Ana santri anya u. ");
INSERT INTO ayz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ana taro mawat mawe, “Ait refi fi kabes mbo tna yker meto! Nri Ait ma!” ");
INSERT INTO ayz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Menohe ana taro mawe, “Raa ro kabes mbo to ja mkyas bo feto fee! Ait kabes mbo fee. Raa ro kabes mbo to, ja ana misoh raa ro masu mboh to mno re masu mrok maah mfi feto fee.” ");
INSERT INTO ayz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mam soo ro arin ngkanam tna raa mfos to raa ro Yahudi ja makyõ korat sau ro masom 'PentahbisanBait Allah'. Tna ti reto to Yesus yamoʼt Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tna Yesus yamo-ama bait Samu ro Allah mam yuk ro masom 'Serambi Salomo'. ");
INSERT INTO ayz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Raa ro Yahudi mawat mama mur mtan Yesus. Tna mtu kʼAit mawe, “Snyi ja naut tna Nyõ nawe abyõ afo re amu nhar nwe Nyõ fi Mesias fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesus yawe, “Riwai Jõ tawe oh kʼanu to. Menohe anu nhar nwe Jõ fi Mesias fefares. Bo msai ro Jõ tno sor to Taja ybis, tibyo tno. Tno mkah Ait yatak rAit afo re anu nmat tna nhar nwe Jõ fi awya. ");
INSERT INTO ayz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Menohe anu wefo fo domba woJõ fee. Tibyo anu smot Jõ fee. ");
INSERT INTO ayz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Domba woJõ to ja mhar Jõ tmai. Tna Jõ thar ana. Tna ana kro Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jõ tno re ana meen mhau hame wajin. Meen ana mhai fee. Tna raa sait bo yatak ytak ana mam Jõ tatem bo fee saut. ");
INSERT INTO ayz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taja ro ysan ana kʼJõ retait tait yase ybo bombra beta. Tna raa aro matak re mtak ana mbam Ait yatem rAit fee. ");
INSERT INTO ayz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jõ tsya Taja to Raa sau aran sai: Amu mbewok fo nhaf, nkit msya srau sau aran.” ");
INSERT INTO ayz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesus ykyas bo reto tna raa ro Yahudi moo fraa u mawe mai Yesus yajat. ");
INSERT INTO ayz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tna Yesus yawe, “Jõ Taja ybis yawe tno bo ro msai. Bo msai ro Jõ tno weto to mawat oh. Tna tno bo msai ro ryo afo tibyo anu nwe nme Jõ?” ");
INSERT INTO ayz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Menohe ana mawe, “Bo ro nno fee. Nyõ fi raa tu sai menohe riwai nawe Nyõ nnan anya nsya Allah. Nyõ namus-amas Allah oh meto. Feto oh mi amu nwe nwah fraa nii Nyõ to.” ");
INSERT INTO ayz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tna Yesus yawe, “Menohe Watum ro Musa ja anu nri to mawe, ‘Tawe anu fo raa matak nfi “allah.”’ ");
INSERT INTO ayz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anu bhar bwe Bokom ro Allah to mhau bau yum. Tiwya Allah ykyas bo reto kʼraa baro. Soh Allah yawe ana weto mfi ‘allah’ to, ");
INSERT INTO ayz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tnaut tawe kbe Raa roto sait yfi ‘allah’ ye saah. Mabo oh: Allah ysok Raa sait tna yse Ait hayah. Ait yawe, ‘Ait tait Raa aJõ.’ Ait retait Allah ybis yroh yama tabam refo to. Tiwya Allah yawe feto. Tna Jõ tawe ‘Jõ fi Ku ro Allah yare.’ Fyi re anu nwe Jõ tamus-amas Allah oh meto? ");
INSERT INTO ayz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Soh Jõ tno bo ro mnan anya msya bo ro Taja ja yno to fee, smot Jõ ma. ");
INSERT INTO ayz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bo ro tkyas sai mno re anu smot Jõ fee rauk. Menohe nmat bo ro tno. Jõ tno bo ro mnan Taja aJõ ja yno. Tno afo re anu smot Jõ. Jõ tno re kbe anu srau nwe Jõ Taja yhaf, srau rAit sau su ysya Jõ. Tna Jõ thaf, srau sau tsya Ait ye.” ");
INSERT INTO ayz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yawe bo reto tna ana tomer u mawe mfot Ait. Menohe Ait frok yamo sikba ana. ");
INSERT INTO ayz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tna fo Yesus hah yamo frit aya ro Yordan yamoʼt majoh ro tiwya Yohanes baptis raa wia. Tna yhau. ");
INSERT INTO ayz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tna raa msis mama mo kʼAit. Tna mawe, “Tiwya Yohanes yno bo msai aro fee. Menohe ykyas Raa refi. Tna bo ro yawe to mabo mnan bo ro tii ait ykyas.” ");
INSERT INTO ayz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tibyo raa msis ro siret mam beto smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Raa sait yasom Lazarus yhau mam remo ro Betania. Yhau ysya yano na Maria msya Marta. (Yano Maria refo oh mi kbe moo minyak wangi karu Tuhan Yesus yaa rait tna mawah mana mawyan karu to.) Lazarus tait kiyam. ");
INSERT INTO ayz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kiyam tibyo yano mbewok reto tiim soo kʼYesus mawe, “Tuhan; amu nno ramu ro nyõ nhafri tait kiyam.” ");
INSERT INTO ayz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesus yari feto tna yawe, “Kiyam reto to misti ait yhai fee. Bo mno feto re raa bibi Allah. Ait kiyam afo re kbe raa bibi Ku ro Allah yasom rAit ye.” ");
INSERT INTO ayz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus yhafri Maria msya mao Marta msya mano Lazarus. ");
INSERT INTO ayz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesus yari soo ro raa mawe Lazarus ait kiyam. Menohe Ait beroh yhau mam beto ti ewok naut. ");
INSERT INTO ayz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tna fo yawe kuber wAit yawe, “Nma hah bmoʼt Yudea.” ");
INSERT INTO ayz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ana mawe, “Guru; taa sai raa ro Yahudi mam beto mawe moo fraa mai Nyõ! Tna re mfo nawe nhah namoʼt beto u a?” ");
INSERT INTO ayz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesus yawe, “Mbam rabu mamo snok hreha to, arin maah. Awya ro yamo ayõ ro maah to, kbe ait wasim fee. Kek ro mhau mam uu mno re tabam refo maah. ");
INSERT INTO ayz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Menohe soh yamo mamur to, kek aro fee, kbe ait wasim.” ");
INSERT INTO ayz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tna Yesus yawe, “Bfoh ranu, Lazarus, yjin oh. Tna Jõ tamo tti ait yrok yasen.” ");
INSERT INTO ayz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Menohe kuber ro Yesus mawe, “Tuhan; soh Lazarus yjin sai to, kbe kiyam marak.” ");
INSERT INTO ayz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","(Yesus yhar yawe Lazarus yhai oh. Riwai yawe 'yjin' to Ait fret bo sai. Menohe kuber wAit mnaut mawe ykyas yawe yjin mfi bo ja soo raa mno.) ");
INSERT INTO ayz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tibyo Yesus yawe kʼana abyõ yawe, “Lazarus yhai oh. ");
INSERT INTO ayz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","He Jõ tarak mam remo reto to, moof kʼanu. Soh anu nmat bo ro kbe tno to, kbe anu smot Jõ. Nma, anu bmo bmat ait.” ");
INSERT INTO ayz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tna Tomas, ro ja raa mtu yasom Didimus tait, yawe kuber roto yawe, “Nma bmo kro Ait tna soh raa mame Ait to, kbe anu bjat su bsya Ait rof!” ");
INSERT INTO ayz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ana mamo. Tna snok mam Betania to, tna raa mawe kʼYesus mawe Lazarus yhai tna raa mse mam isra mato yasno jiit oh. ");
INSERT INTO ayz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Remo reto to kene mam Yerusalem. Nmo to kilo mara tuuf bo feto. ");
INSERT INTO ayz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tna raa ro Yahudi mawat mama mbam Yerusalem mawe hre mawia msya Lazarus yano mabo ewok reto. ");
INSERT INTO ayz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta mari he Yesus yama. Tna au frok mamo mtar Ait mam iso. Tna Maria mhau mam amah. ");
INSERT INTO ayz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta mamo mo kʼYesus tna mawe, “Tuhan; Nyõ nama mam befo fooh mi tano ajõ yhai fee. ");
INSERT INTO ayz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Menohe jõ thar tawe bo bawya sai ro Nyõ nayoh kʼAllah to, kbe Ait yari.” ");
INSERT INTO ayz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus yawe, “Nano anyõ kbe yrok yasen.” ");
INSERT INTO ayz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta mawe, “Thar tawe meen tabam haberek u tna raa ro mhai kbe mrok masen. Feto meen Lazarus yrok yasen.” ");
INSERT INTO ayz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus yawe, “Jõ oh mi Raa ro yno re raa mrok masen. Tna tno re meen ana mhau hame wajin. Raa ro smot Jõ kbe mhai to, menohe mhai tibyo fee. ");
INSERT INTO ayz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Awya ro yhau smot Jõ to, kbe yhai fee. Nyõ nhar nwe bokyas aJõ refo bo mabo to, fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta mawe, “Ae Tuhan. Jõ smot Nyõ. Jõ thar yum oh tawe Nyõ fi Mesias. Nyõ fi Ku ro Allah yare. Nyõ fi Raa ro tiwya raa mkyas mawe, ‘Meen Allah ybis Raa sait yroh yamaʼt tabam refo.’” ");
INSERT INTO ayz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta mawe feto tna au hah mamoʼt amah. Tna samoh kʼmao Maria mawe, “Bi Guru yhau mam wono. Tna Ait ytu nyõ yawe namo.” ");
INSERT INTO ayz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria mari feto tna masen fooh tna frok mamo mo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ti reto Yesus twok remo reto fefares. Ait yhau fares mam yuk ro Marta riwai mkai Ait. ");
INSERT INTO ayz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Raa Yahudi ro hre mawia msya Maria mam amah to mmat he Maria masen tna frok fooh mamo. Ana mnaut mawe mamo mawia mam yuk ro isra wore raa mse Lazarus yetsu. Tibyo ana beta masen kro au. ");
INSERT INTO ayz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Menohe Maria mamo mo kʼYesus. Mmat Ait, tna mjit mimna mam wore Ait yros. Tna mawe, “Tuhan; ti ro Lazarus yhai to, soh Nyõ nhau mam wefo mi, tano ajõ yhai fee.” ");
INSERT INTO ayz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus ymat Maria mawia feto tna ymat raa ro Yahudi mama msya au to mawia ye. Ymat tibyo Ait srau mham ye. ");
INSERT INTO ayz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yawe, “Anu nse ait mam woyõ?” Tna ana mawe, “Nama nmat.” ");
INSERT INTO ayz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tna Yesus yawia. ");
INSERT INTO ayz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Raa ro Yahudi weto mmat he Yesus yawia tna mawe, “Ait yhafri Lazarus toni.” ");
INSERT INTO ayz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Menohe taro mawe, “Ait yisoh raa ro masu mboh to masu maah. Fyi re Ait ymat Lazarus fee, tna yisoh kiyam rait yno wa re yhai fee?” ");
INSERT INTO ayz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus sraujin toni u. Tna yamoʼt isra reto. (Tiwya raa moo Lazarus mse mam isra mato, tna muut mkah fraa mabi sau.) ");
INSERT INTO ayz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus yawe, “Niyaban fraa reto!” Menohe Lazarus yano, Marta mawe kʼYesus mawe, “Nno ma! Ait yhau mam isra mato masno jiit oh. Ynis oh!” ");
INSERT INTO ayz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesus yawe, “Tkyas kʼnyõ oh tawe, ‘Soh nyõ smot Jõ to, kbe nmat bo yase ro Allah rAit.’” ");
INSERT INTO ayz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tna ana miyaban fraa reto tna Yesus yasu heyut ayoh yawe, “Taja, Nyõ ja nari bo ro Jõ tkyas. Tibyo tayoh asik mase. ");
INSERT INTO ayz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Thar tawe Nyõ nari bo ro tkyas yoyo. Menohe tkyas bo refo afo re raa ro mhau mam wefo mari tna smot Jõ. Afo re ana mhar mawe Nyõ oh mi Raa ro nbis Jõ fo.” ");
INSERT INTO ayz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesus yawe feto, tna ytu mkah ymai fari yawe, “Lazarus, frok nama!” ");
INSERT INTO ayz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tibyo Lazarus yari tna frok yama. Ait frok menohe hawee ro taa raa moo sro yetsu to make ait matak fares. Tna hawee sau sro yasu ye. Tna Yesus yawe kʼraa ro mros mam weto yawe, “Skur hawee reto re mbitsre ait yamo.” ");
INSERT INTO ayz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Raa Yahudi mama hre mawia msya Maria tna ana masu mmat bo msai ro Yesus yno reto. Tibyo ana mawat smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Menohe ana taro mamo mo kʼraa ro Farisi tna mkyas bo ro Yesus yno reto. ");
INSERT INTO ayz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tibyo raa ro Farisi msya imam manes mtu raa manes taro ro ja mtu safo raa ro Yahudi to beta mama. Mama hre siret su tna ana mtu kʼanya mawe, “Anu bno fyi? Raa refi yno bo msai mawat! ");
INSERT INTO ayz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Soh anu bno bo aro fee, kbe raa beta smot Ait mawe Ait fi Mesias! Tna tis rau to, raa pemerintah ro Roma kbe mama soyak yuk refo. Yuk refo tiwya Allah ysan kʼanu, raa mana ro Yahudi. Mfo refo pemerintah ro Roma mbo anu, menohe mbis mawe bo ro agama ranu to, besait bno tna bbis fares. Anu waa kbe Raa refi mno raa mrok mnin-nin. Tna fo pemerintah mama mbo anu matak. Tna mawe besait bbo raa wanu u fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Raa weto sait yasom Kayafas. Tahun reto to, ait retait yamo imam agama Yahudi ro yase. Tna ait yawe, “Anu nhar bo aro fee! ");
INSERT INTO ayz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Rau ro moof to, raa sait yhai sai. Soh mfe, kbe raa mana ranu ro Yahudi majat beta.” ");
INSERT INTO ayz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafas yawe feto menohe bokyas reto mbam ait yesait fee. (Tahun reto ait oh mi yamo imam ro yase. Feto tibyo Allah oh mi ybis ait ykyas bo reto ynan fi nabi ro ykyas bokyas ro Allah.) Kayafas ykyas feto tna bonaut rait yesait yawe riof kʼraa mana ro Yahudi ⌞mam tabam refo. Menohe bo maja ro Allah ynaut yawe to: Yesus kbe yajat siwyan iso re raa mkai riof mase ro hame wajin.⌟ ");
INSERT INTO ayz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yajat afo re yno bo moof kʼanu ro Yahudi kar fee. Kbe yajat afo re yno bo ro moof ku ro Allah makus mbrir-brar sor mam tabam refo beta ye. Mfo refo ana mhau ha-hayah. Menohe kbe mhau su tna mamo mhaf srau sau su ye. ");
INSERT INTO ayz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Maban ayõ reto raa ro Yahudi saim mawe mame Yesus yajat. ");
INSERT INTO ayz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Feto to Yesus sikba Yudea. Yawe yamoʼt wore raa masu makin mmat Ait fee. Tibyo yamoʼt remo sau ro masom Efraim. Efraim to mhau kene wo tabam ro riamo. Tna ysya kuber wAit mamo mhau mam weto. ");
INSERT INTO ayz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Korat ro Paskah kene oh. Tibyo raa ro Yahudi mawat mbam remo aro sor mamoʼt Yerusalem. Mamoʼt Yerusalem mawe misoh ana siwyan mamyot bo mafa raa ro agama Yahudi ja mno ati ro makyõ korat ro Paskah fefares. ");
INSERT INTO ayz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Raa mawat mamoʼt Yerusalem tna mamoʼt Samu ro Allah. Ana saso Yesus he mkai fee. Tibyo mros mam Samu ro Allah mkyas kʼanya mawe, “Anu nnaut nwe kbe Yesus yamaʼt korat refo fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Taa imam manes msya raa ro Farisi msi bo kʼraa mawe, “Awya ro yhar yuk ro Yesus yhau mam woyõ to, kbe raa retait yama yawe kʼanu.” Mbis feto re kbe ana mamo mfot Ait. ");
INSERT INTO ayz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ti ntamam naut tna Korat ro Paskah. Tna Yesus yamoʼt Betania, remo ro Lazarus. Lazarus tait raa ro tiwya yhai tna Yesus yno yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesus yama tibyo raa siwyan bo sohmaam. Tna Lazarus, Yesus msya raa taro hre su tna Marta masyõ bo sohmaam reto. ");
INSERT INTO ayz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tna Maria moo minyak wangi ro mabyoh maut. Kusia reto liter hariyah bo. Moo minyak wangi reto mtu mam Yesus yaa. Tna ngkaru mkah mana mawyan rau. Minyak reto sawer fiyau mam amah mato reto beta. ");
INSERT INTO ayz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yudas Iskariot tait, kuber ro Yesus sait. (Ait oh mi ro kbe hren serek Yesus.) Ymat bo ro Maria mno tna hafrah yawe, ");
INSERT INTO ayz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nno bawya meto ee? Fyi re minyak reto sikowah sai a? Rau ro moof to, nasim kʼraa tna noo mabyoh rau 300 dinar. Tna mabyoh ro mase reto kbe raa msan kʼraa kinyah ro mse bo fee.” ");
INSERT INTO ayz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas ymat raa ro kinyah fee. Ait tait raa ro ybo pitis wana beta. Ait yasu mase ja ysyõf pitis wana baro. Au oh mi yawe feto. ");
INSERT INTO ayz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Menohe Yesus yawe, “Bhah au ma! Mno feto re mnaut ti ro kbe raa sama hai aJõ. ");
INSERT INTO ayz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Raa kinyah to, ja mhau su msya anu yoyo. Menohe Jõ fo kbe thau tsya anu yoyo fee.” ");
INSERT INTO ayz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Raa ro Yahudi mawat mari he Yesus yhau mam Betania. Tna ana masen mamoʼt beto. Mamo mawe mmat Yesus yesait ye, tna mamo mawe mmat Lazarus ro Yesus yno yrok yasen to ye. ");
INSERT INTO ayz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Feto tibyo imam manes ro agama Yahudi saim bo mawe mame Lazarus ye. ");
INSERT INTO ayz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mawe ait yaam tna bo reto misti re raa ro agama Yahudi mawat mawe kro Yesus tna smot Ait tna sikba bo ro ana mkyas. ");
INSERT INTO ayz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Korat ro Paskah kene oh. Tibyo raa ro Yahudi mawat mbam remo aro sor mamaʼt Yerusalem oh. Yesus sohmaam bo ysya Lazarus tna rabu ti fo yawe yamoʼt Yerusalem. Raa mawat mari he Yesus yamaʼt Yerusalem. Yama fares mam iso ");
INSERT INTO ayz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tna ana mama mtar Ait. Raa miji ara palem mata tna mbo mamo sikoyõ mtar Yesus mawe, “Hosana! Ait yase toni! Tuhan ybis Ait yama! Ait yamo Raja tna ybo raa ro Israel!” ");
INSERT INTO ayz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus tru keledai ro maku teta tna sau tna yaut hre abyõ. Bo reto yno mnan Bokom ro Allah mawe: ");
INSERT INTO ayz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Anu raa ro Yerusalem, ro mhau mam atu ro Sion; waa ma. Nmat, Raja ro ybo anu tait yama yo kʼanu. Ait yaut keledai ro tna sau yama.” ");
INSERT INTO ayz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ti reto kuber ro Yesus wAit mnaut bokom far-far reto fee. Ana srau bombra weto fefares. Menohe kbe Yesus yrok yasen tna fo ana mrok mnaut bo reto tiwya raa mkom oh mam Bokom ro Allah. Tna ana mrok mnaut mawe bo ro raa tiwya mno weto, ana mno kʼYesus mnan si Bokom reto. ");
INSERT INTO ayz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ti weto to, raa ro mhau mam Yerusalem to, ana mawat tiwya mmat Yesus yno Lazarus yrok yasen tna frok ybam isra mato reto. Tna ana weto mkyas bo reto renti. ");
INSERT INTO ayz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tibyo raa mawat mhar mawe Yesus yno bo msai reto. Feto tibyo ati ro Ait yamaʼt Yerusalem reto to, raa mawat mamo mtar Ait. ");
INSERT INTO ayz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Raa ro Farisi mmat he raa msis-sas mamo mo kʼAit tibyo mawe kʼanya mawe, “Raa arin aso beta mamo kro Yesus, tna anu bno bo aro u fee!” ");
INSERT INTO ayz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mam korat ro Paskah to, raa mawat mamo mbaut Allah mam Yerusalem. Ana ro mama makyõ korat reto to, ana baro raa ro Yunani ye. ");
INSERT INTO ayz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ana weto mamo mo kʼYesus kuber wAit sait yasom Filipus. (Filipus tait remo rait Betsaida mam provinsi ro Galilea.) Mamo mo kʼFilipus tna mawe, “Amu nwe ksoh nmat Yesus.” ");
INSERT INTO ayz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tna Filipus yamo yawe bo reto kʼAndreas. Tna ana mbewok mamo mawe kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tna Yesus yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Ayõ kene wo Jõ thai. Kbe bo mai kʼJõ tna raa mmat Jõ tase aJõ. ");
INSERT INTO ayz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nnaut: Tkyas gandum makan kʼanu tawe, ‘Ja gandum makan krioh mbam kayoh rau tna mbtek mai tabam. Tna mbrom-brom mhai. Tna fo kmoh frok. Tna mo maut. Tis rau to make. Make makan sarer. Soh gandum makan reto mbrom-brom mam tabam fee, kbe mhau makan sau yum. Soh mhai fee kbe make fee.’ ");
INSERT INTO ayz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Awya ro ksoh yhau mam tabam refo toni to, kbe ykai riof ro hame fee. Menohe awya ro yako yawe yhau mam tabam refo kait fee, meen ait retait yhau hame wajin. ");
INSERT INTO ayz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Awya ro yawe yno bo woJõ to, yako hawe sai yama kro Jõ. Wore wo thau to, kbe sryan aJõ yhau mam beto ye. Kbe Taja ymat sryan aJõ retait yawe ait yno bo ro moof.” ");
INSERT INTO ayz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tna Yesus yawe, “Mfo refo to tnaut yyi toni. Ayõ refo mama tna tkyas tawe bawya? Tayoh Taja tawe riof kʼJõ fe mfe a? Mfe. Bitsre bo ro samyoh refo mai kʼJõ. Jõ tsan tafos aJõ oh mi tama mam tabam refo to! ");
INSERT INTO ayz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tawe, ‘Taja bo ro tno refo, nno re raa mmat tibyo bibi Nyõ nasom aNyõ.’” Tna Allah ybam sawro rAit ykyas yawe, “Tno oh. Tna kbe tno u.” ");
INSERT INTO ayz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Raa ro mros mam weto to mawat. Ana mari mai reto tna taro mawe, “Barmabyõ mji!” Menohe taro mawe, “Mfe, malaikat sau mkyas bo kʼAit!” ");
INSERT INTO ayz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus yawe, “Mai reto anu nri ye a? Fyi re Allah ykyas kʼJõ feto? Yno afo re anu nri mai rAit ye. ");
INSERT INTO ayz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ayõ rau snok oh. Allah kbe ytu srah raa ro tabam refo. Yno tibyo kabes yabi (Iblis) ro ja ybo raa ro tabam refo to, Allah yikyak ait yamo. ");
INSERT INTO ayz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Menohe kbe raa tubat Jõ abyõ tna tajat. Feto kbe tkuk raa beta mama mo kʼJõ.” ");
INSERT INTO ayz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus yawe feto afo re raa mhar mawe kbe raa mame yajat mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Raa mawat mros mari bo ro Yesus ykyas. Ana mari bo ro yawe reto tna mawe, “Watum ro Musa mkyas mawe, ‘Mesias kbe yhau hame wajin.’ Fyi re Nyõ nawe, 'Ait ro Yroh Yama Yfi Raa Sai' tait, kbe raa mame yajat? 'Ait ro Yroh Yama Yfi Raa Sai' tait bi awya metait?” ");
INSERT INTO ayz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesus yawe, “Kek reto mhau su msya anu waor sai. Arin ro maah fo, nmat sas iso ro anu nmo. Kbe arin ro mti mama. Kbe nmo fyi-fya? Awya ro yamo mam amur wase iso ro ait yamo. ");
INSERT INTO ayz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Smot Kek reto wore mhau msya anu fares to. Smot Kek reto afo re kbe nhau mam arin ro maah.” Yesus ykyas bo reto mkak tna sikba yuk reto sesa Ait. ");
INSERT INTO ayz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesus yno bo msai mawat ro merif Allah yatak rAit. Yno re kbe raa ro Yahudi mmat. Menohe ana smot Ait fee. ");
INSERT INTO ayz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bo reto mamo mnan si bo ro tiwya Allah ybis nabi Yesaya ykyas yawe: “Tuhan; awya yari bokyas ramu tna yfot yse kʼait? Awya ymat yatak aNyõ?” ");
INSERT INTO ayz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ana mari watum aNyõ, menohe ana moo mse kʼana fee. Feto to nabi Yesaya ykyas u yawe: ");
INSERT INTO ayz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Allah yno ana masu mboh afo re mmat bo ma. Tna yno makit wana mbin afo re ana mnaut bo kaket ma. Mfi bo ana hah me mama mo kʼJõ maami tisoh ana.” ");
INSERT INTO ayz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tiwya tinyi Yesaya yhar Yesus yase rAit. Feto oh mi ykyas Ait feto. ");
INSERT INTO ayz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Feto sai, menohe raa mawat smot Ait tna msya raa manes ro Yahudi taro smot Ait ye. Menohe ana waa raa ro Farisi kbe mikyak ana. Waa kbe mawe ana skabuk su msya raa ro Yahudi mam samu watum rana u fee. Tibyo mawe abyõ fee. ");
INSERT INTO ayz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ana weto hasu bo raa bibi ana sai, menohe ana mrok mawe Allah bibi ana to bo ati fee. ");
INSERT INTO ayz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tna Yesus yawe, “Awya ro smot Jõ to, ait smot Jõ tesait sai meto fee. Ait smot bi Ait ro ybis Jõ ye oh meto. ");
INSERT INTO ayz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Awya ro ymat Jõ to, ymat bi Ait ro ybis Jõ ye. ");
INSERT INTO ayz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jõ tamaʼt tabam refo tnan kek. Tama afo re raa beta ro smot Jõ to, kbe mamo mam arin ro mamur u fee. ");
INSERT INTO ayz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Raa taro mari bokyas aJõ menohe mbo mno fee. Jõ too safo mana tmit kʼana weto to fee. Tama tabam refo mkah bo tmit safo kʼraa to fee. Tama tno riof kʼraa. ");
INSERT INTO ayz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","49","Raa taro to mikyak Jõ tna mse bokyas aJõ mam mhaf mato rana to fee. Ati ro tabam refo haberek u to, kbe awya yoo safo mana ymit kʼana? Raa fee: Meen bokyas ro Jõ tkyas oh to, mesait mmit safo mana kʼana weto. Tesait kar tkyas bo aro fee. Menohe tkyas bo ro Taja ykyas kʼJõ to sai. Tna Jõ betoo bo bawya ro Ait yawe Jõ betoo kʼanu. Tibyo mam ati ro tabam refo haberek to bokyas aJõ mesait oh mi meen mmit safo mana kʼana weto. ");
INSERT INTO ayz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bi Ait ysi bo, tna raa ro mari mno bo ro Ait ysi to meen mhau hame wajin. Feto to bo bawya ro tkyas to, bo reto mnan si msya bo ro Taja ysi kʼJõ yawe Jõ tkyas.” ");
INSERT INTO ayz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yesus ysya kuber wAit makyõ korat ro Paskah fefares tna Ait yhar yawe kbe Ait sikba tabam refo tna yamo yo kʼYaja. Ayõ rau to kene oh. Tna Yesus yno bo sau afo re ana mhar mawe Ait yhafri raa wAit ro mhau mam tabam refo. Ait yhafri ana toni syok. ");
INSERT INTO ayz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mti oh tna Yesus ysya kuber wAit huwya mait boit. (Ti reto to, kabes yabi (Iblis) yisbyo bonaut rait kʼYudas Iskariot oh. Tna Yudas yari yawe kbe besruf Yesus. Yudas tait Simon yare.) ");
INSERT INTO ayz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus yhar yawe Yaja ysan tak rAit kʼAit oh re yase ybo bombra beta. Tna yhar yawe Allah oh mi ybis Ait yama, tna kbe hah ye yamo yo kʼAllah u. ");
INSERT INTO ayz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yhar bo reto tibyo yasen tna yrus ratan miyõ rait. Tna yoo hawee ftah sau ybin mam yaka. ");
INSERT INTO ayz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tna ywyan aya yama. Tna fo hre yyon kuber wAit maa maban. Tna moo hawee reto karu. ");
INSERT INTO ayz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yno tna snok Petrus yawe yyon yaa. Menohe Petrus yawe wa yawe, “Tuhan; fyi re Nyõ ro nase nawe nyon jõ taa a?” ");
INSERT INTO ayz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus yawe, “Bo ro Jõ tno refo, mfo wefo fo nyõ wase fares. Menohe kbe meen nyõ nhar.” ");
INSERT INTO ayz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus yawe, “Nyon taa ajõ ma!” Tna Yesus yawe, “Soh Jõ tyon nyõ naa to fee, nyõ namo kuber woJõ fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon-Petrus yawe, “Soh feto, nyon taa mesait sai ma! Nyon tatem msya tana ye re toof!” ");
INSERT INTO ayz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus yawe, “Awya ro yate aya oh to yetsu rait moof oh. Ait yaa rait mesait aran kbe yyon u, tna yetsu beta moof oh. Anu sait aran yhaf moof fee, menohe anu beta taro nhaf moof oh.” ");
INSERT INTO ayz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yesus yhar oh awya ro kbe hren serek Ait. Reto oh mi Ait yawe, “Anu beta noof fee.”) ");
INSERT INTO ayz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesus yyon ana maa beta mkak. Tna fo yoo ratan rAit yyum u, tna yama hre u. Tna yawe, “Bo ro riwai tno to, anu nhar bo maja rau fe mfe fares a? ");
INSERT INTO ayz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ja anu ntu Jõ ‘bi Guru’ soh mfe nwe ‘Tuhan’. Mabo oh, anu ntu feto bo moof. ");
INSERT INTO ayz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jõ fi tamo Tuhan tna Guru ranu. Tna tyon anu naa to. Feto to tbis anu beta kbe nyon naa wanu kʼanya ye to. ");
INSERT INTO ayz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tno feto afo re anu nhar bo moof ro nno. Tawe anu ye nno bo moof kʼraa anya, mnan fi ja Jõ tno kʼanu to! ");
INSERT INTO ayz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nnaut: Sryan sait yase yiwer bobot rait fee. Tna raabis sait yase yiwer ait ro ybis fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Anu nhar bo ro tkyas kʼanu weto beta. Au oh mi nhaf sneh sai to. Nhau nfi sryan ro ja yno bo moof kʼraa anya. Soh anu nno bo feto to, kbe Allah yno bo ro moof kʼanu.” ");
INSERT INTO ayz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Tna Yesus yawe, “Riwai tawe, ‘Anu nhaf moof oh.’ Tawe bo reto menohe tkyas anu beta fee. Jõ thar awya ro Jõ tsok. Bokom ro Allah far-far sau mkyas mawe, ‘Ait sait ro hre yait boit su ysya Jõ oh mi kbe yamo byoh kʼJõ.’ Mazmur 41:9 Tawe bokom reto mabo fo. ");
INSERT INTO ayz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jõ tkyas bo refo kʼanu wia. Tkyas kʼanu wia matim afo re wore wo anu nmat bo refo mabo to, kbe anu smot Jõ. Tna kbe nhar nwe Jõ fi Mesias. ");
INSERT INTO ayz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nnaut: Awya ro ymat tna hartu raa ro Jõ tbis to, ait ymat tna hartu Jõ oh meto. Tna awya ro ymat tna hartu Jõ to, ait ymat tna hartu bi Ait ro ybis Jõ ye oh meto.” ");
INSERT INTO ayz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus ykyas bo refo mkak tna fo Ait sraujin. Tna bo ro yhar oh Ait ykyas abyõ yawe, “Anu nkin wefo sait kbe besruf Jõ.” ");
INSERT INTO ayz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kuber wAit mmat sas anya. Mnaut mawe awya mi Yesus yawe metait. ");
INSERT INTO ayz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kuber ro Yesus sait, ro Ait yhafri retait hre mam yajoh ti jaro. ");
INSERT INTO ayz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tna Simon-Petrus skabuk yasu kʼait re ait ytu kʼYesus awya mi Yesus yawe metait. ");
INSERT INTO ayz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tna kuber retait susu kene kʼYesus tna ytu yawe, “Awya oh mi Nyõ nawe metait?” ");
INSERT INTO ayz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus yawe, “Nmat: Too roti ftah kebet. Tna Jõ beru mam aya refo tee kʼait.” Tna Yesus yoo roti ftah sau beru mam aya reto tna yee kʼYudas. (Yudas tait ku ro bi Simon yare.) ");
INSERT INTO ayz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas yoo roti reto si fo, kabes yabi (Iblis) twok mam yhaf mato. Tna Yesus yawe kʼait yawe, “Bo ro kbe nno reto to, nno fooh oh!” ");
INSERT INTO ayz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Ana taro ro hre mait boit to wase mawe fyi re Yesus ykyas feto kʼYudas. ");
INSERT INTO ayz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas oh mi raa ro ja ybo pitis wana. Tibyo ana taro mnaut mawe Yesus ybis Yudas yamo yoo boit aro re kbe ana mait mam korat reto. Soh mfe ana mnaut mawe Yesus ybis ait yoo pitis aro yamo yee kʼraa ro masu awe.) ");
INSERT INTO ayz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas yoo roti reto si fo, ait frok. Arin mamur oh. ");
INSERT INTO ayz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas yamo. Tna Yesus ykyas bo kbe yhai tna yrok yasen. Yawe, “Jõ fi 'Ait ro Yroh Yama Yfi Raa Sai'. Fooh sai tna kbe raa mmat Jõ tase aJõ. Kbe raa mmat bo ro Jõ tno tibyo ana mbaut Allah. ");
INSERT INTO ayz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bo ro tno mno re kbe raa mbaut Allah. Feto to fooh re Allah yerif Jõ tase aJõ ye. ");
INSERT INTO ayz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kukek woJõ sor: Ayõ baro firwas tna Jõ kbe thau kait tsya anu u fee. Anu kbe saso Jõ, menohe yuk ro Jõ tamo to anu ntai nma fee. Taa tkyas bo refo kʼraa manes ro Yahudi ye. ");
INSERT INTO ayz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tbis bo ro tna sau kʼanu nbo nno. Jõ tatmof anu. Tna tawe, ‘Fyi-fya rau to anu natmof anya kaket mfi Jõ tatmof anu to!’ ");
INSERT INTO ayz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Soh anu natmof anya kaket to, kbe raa mmat tna mhar mawe anu fo kuber woJõ.” ");
INSERT INTO ayz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon-Petrus ytu yawe, “Tuhan; namo tiyo?” Yesus yawe, “Yuk ro Jõ tamo to, mfo refo nyõ kro fee. Kbe meen nyõ nama nrof.” ");
INSERT INTO ayz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus yawe, “Tuhan; fyi re jõ kro Nyõ mfo refo fee? Jõ waa fee. Jõ kbe raa mame tajat saah! Menohe tawe tsan tetsu ajõ afo re riof kʼNyõ.” ");
INSERT INTO ayz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tna Yesus yawe, “Petrus, nari: Nyõ nawe nsan netsu re riof kʼJõ to, nyõ nkyas niwer fe mfe a? Rere kook mara fefares to, kbe nyõ nwaar Jõ wia muhrin tuuf oh, nawe nyõ wase Jõ.” ");
INSERT INTO ayz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tna Yesus yawe kuber wAit yawe, “Waa ma. Sraujin ma. Smot Allah oh! Nsam wai kʼAit. Tna smot Jõ. Nsam wai kʼJõ ye. ");
INSERT INTO ayz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mam samu ro Taja yhau to yuk ro meen anu nhau to mawat. Jõ tamoʼt samu ro Taja re kbe siwyan yuk aro kʼanu kbe nma nhau. Soh samu reto marak to, Jõ tkyas kʼanu feto fee. ");
INSERT INTO ayz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tamo siwyan yuk ro anu kbe nhau to, tna hah tama tmen anu bmo. Tmen anu re kbe anu nhau nsya Jõ su mam beto. ");
INSERT INTO ayz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Anu ye nhar iso ro mamoʼt yuk reto.” ");
INSERT INTO ayz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Menohe Tomas yawe, “Tuhan; kbe Nyõ namo tiyo? Amu wase! Feto to amu wase iso reto ye!” ");
INSERT INTO ayz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tna Yesus yawe, “Jõ fi iso reto. Bokyas aJõ to mabo beta. Jõ oh mi tno re raa mhau hame wajin. Tna raa aro yamo yo kʼTaja mam iso roto to fee. Awya ro yawe yamo yo kʼTaja to, yako hawe sai kro Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Anu nhar Jõ oh to, anu nhar Taja aJõ ye. Mfo refo anu nhar Ait oh. Anu nmat Jõ mnan anya mfi anu nmat Ait ye oh.” ");
INSERT INTO ayz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipus yawe, “Tuhan; nerif Naja kʼamu re kbe amu nmat Ait kaket rof tna fo kbe amu nnaut yyi u fee.” ");
INSERT INTO ayz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesus yawe kʼFilipus yawe, “Thau tsya anu ooh oh, menohe nyõ wase Jõ fares a? Awya ro ymat Jõ to, ait retait ymat Taja ye oh meto. Fyi re nyõ nawe, ‘Nerif Naja kʼamu’? ");
INSERT INTO ayz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Jõ fi srau sau, thaf sau tsya Taja. Tna Taja srau sau, yhaf sau su ysya Jõ ye. Menohe nyõ wase bo reto fares a? Bo ro tkyas kʼanu to, tkyas bonaut aJõ sai fee. Taja oh mi yatam Jõ yoyo tna Jõ tkyas bo ro Ait yawe kʼJõ. Ait yesait yno re tno bo wefo beta. ");
INSERT INTO ayz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Smot Jõ. Tna nhar nawe bokyas aJõ refo mabo: ‘Jõ fi srau sau, thaf sau tsya Taja. Tna Taja srau sau, yhaf sau su ysya Jõ ye.’ Soh nyõ ntu sioh bokyas aJõ reto fares to, sik nmat bo msai ro Jõ tno mkah tak rAit to, afo re nyõ smot Jõ matak. ");
INSERT INTO ayz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nnaut: Awya ro smot Jõ to, kbe yno bombra mnan si bo ro Jõ tesait tno to ye. Tna tamo to kʼTaja. Tibyo kbe raa retait yno bo ro mase miwrek bo ro Jõ tno to ye. ");
INSERT INTO ayz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bo bawya sai ro anu nyoh to, kbe Jõ tno. Bo ro nyoh mkah tak ro Jõ tasom aJõ to, kbe tno yum. Tno afo re raa mbaut Taja. ");
INSERT INTO ayz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Soh anu weto nyoh bo sau kʼJõ mkah tak ro tasom aJõ to, kbe Jõ tari tno yum.” ");
INSERT INTO ayz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tna Yesus yawe, “Soh anu nhafri Jõ to, kbe nbo nno bo ro Jõ tbis kʼanu to ye. ");
INSERT INTO ayz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jõ tamo tayoh Taja afo re ybis Har rAit mama mhau matam anu mamo snok hame wajin. Bo ro nno to Har mban anu yoyo. Har reto ja mkyas bo ro mabo. ");
INSERT INTO ayz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Raa ro wase Allah to, ana mhar Har rAit fee. Srau Har rAit fee ye. Feto to raa weto to Har rAit mjin kʼana mhaf mato fee. Mako hawe sai ana mkai Har rAit fee. Menohe anu fo, Har ro Tuhan mhau mam nhaf mato wanu tna mhau matam anu yoyo. Feto to anu nhar Har rAit, srau Har rAit reto. ");
INSERT INTO ayz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jõ kbe sikba anu nhau nkus mnan fi kukraa to fee. Jõ kbe hah te to kʼanu u. ");
INSERT INTO ayz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mhau baro feto raa ro wase Allah kbe mmat Jõ u fee. Menohe anu fo kbe nmat Jõ u. Jõ fi raa ro tawyos. Tibyo anu meen nhau nawyos ye. ");
INSERT INTO ayz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ayõ reto to, kbe anu nhar nwe Jõ thaf sau su tsya Taja, tna anu nhaf sau nsya Jõ ye. Tna Jõ thaf sau tsya anu ye. ");
INSERT INTO ayz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Awya ro ybo yno bo ro Jõ tbis kʼait to, ait retait oh mi yhafri Jõ ye. Ait ro yhafri Jõ tait kbe Taja yatmof ait retait ye. Tna Jõ kbe tatmof raa retait tna tno re ait yhar Jõ to ye.” ");
INSERT INTO ayz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tna Yudas roto sait, (Iskariot fee,) ytu kʼYesus yawe, “Tuhan; Nyõ nno re amu nesait nhar Nyõ sai. Tna fyi mkah raa ro tabam refo, ana ro wase Allah ye?” ");
INSERT INTO ayz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus yawe, “Awya ro yhafri Jõ kbe yari bo ro tbis kʼait ybo yno ye. Tna Taja kbe yhafri ait. Tna Jõ tsya Taja kbe nma nhau su nsya ait retait ye. ");
INSERT INTO ayz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Awya ro yhafri Jõ fee kbe yari bo ro tbis kʼait fee, ybo yno fee ye. Bokyas ro tkyas refo fo bonaut aJõ tesait to fee. Tkyas bo ro Taja ykyas kʼJõ sai.” ");
INSERT INTO ayz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tna Yesus yawe, “Bo wefo beta Jõ tkyas kʼanu mam wore wo Jõ thau tsya anu fares fo. ");
INSERT INTO ayz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tna kbe Taja ybis Har rAit mama mo kʼanu. Har reto kbe mkyas watum kʼanu tna bo ro nno to, Au mban anu ye. Taja ybis Har mama shauk Jõ re kbe mno bo woJõ renti. Har reto kbe mamo guru ro betoo bombra beta kʼanu tna mno anu nnaut bombra ro Jõ tkyas kʼanu to beta. ");
INSERT INTO ayz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tawe tsan bo sau kʼanu. Jõ thau thaf tnok sai. Jõ tamo menohe tawe tno anu nhau nhaf tnok ye. Raa ro tabam refo mawe mno raa mhaf tnok ye. Menohe bo raa mno re mhaf wana tnok to hayah. Ana mhaf tnok mnan si Jõ thaf tnok to fee. Jõ tamo menohe tawe tno anu nhau nhaf tnok. Feto to waa ma. Sraujin toni ma. ");
INSERT INTO ayz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Riwai tawe, ‘Jõ tamo tna kbe thah te tama to kʼanu u.’ Taja tait yase yiwer Jõ. Tna tamo to kʼAit. Feto to sraujin ma. Rau ro moof to, soh anu nhafri Jõ to, kbe anu simaut bo nhar nwe tamo to kʼAit. ");
INSERT INTO ayz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jõ tkyas bo refo kʼanu wia. Tkyas kʼanu wia matim afo re kbe nmat bo refo mabo to, kbe anu smot Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ayõ rau kene oh, tna kabes yabi (Iblis) yama. Tibyo ayõ aro u fee re tkyas bo mawat tsya anu. Kabes retait yase ybo raa ro tabam refo. Menohe ait yase yiwer Jõ fee. ");
INSERT INTO ayz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Menohe Jõ sayõ bo ro yno afo re raa ro tabam refo mhar mawe Jõ thafri Taja. Afo re ana mhar mawe bombra ro tno to tno mnan si bo ro Taja ybis Jõ.” Tna Yesus yawe, “Nma, bsen bmo.” ");
INSERT INTO ayz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kuber ro Yesus wAit msya Yesus mamo. Tna Yesus ykyas bo renti. Ait fret bo yawe, “Jõ fi anggur mara ro moof. Taja oh mi yamo Raa ro mkah tna misoh armato anggur reto. ");
INSERT INTO ayz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Anggur mara fo, ngkre rau ro make fee, kbe Taja ysot. Tna kre rau ro make to, kbe yisoh srof re make mawat renti. ");
INSERT INTO ayz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Anu noof mfi anggur mara ro raa misoh oh. Bokyas ro anu nri kʼJõ reto mno re anu wefo nhaf moof. ");
INSERT INTO ayz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nhau nrat nsya Jõ tna Jõ thau trat tsya anu ye. Ngkre sau mesait kar kbe make fee. Soh ngkre sau mhau mrat msya mara rau fee, kbe make fee. Tna soh anu nhau nhaf, srau sau nsya Jõ to fee, kbe nke fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Jõ fi tnan fi anggur mara sau. Tna anu to nnan fi ngkre rau. Awya ro yhau yhaf sau ysya Jõ to, tna soh Jõ thau thaf sau tsya ait ye, kbe ait retait yake mawat. Soh anu nhaf sau su nsya Jõ to fee, kbe anu ntai nno bo aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Awya ro yhau yhaf sau ysya Jõ fee, ait retait ynan fi ara ngkre sau ro raa msot tna beak makus. Ara ngkre reto mhau ngkaat. Tna kbe raa moo ngkre weto makrao mam wo sau mbeak tna mko mam tafoh tna mait. ");
INSERT INTO ayz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Soh anu nhau nhaf sau su nsya Jõ tna soh bokyas aJõ anu nme mam nhaf wanu to ye, kbe anu nyoh bo bawya ro anu nksoh sai to tna kbe nkai. ");
INSERT INTO ayz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Soh anu make mawat to, kbe raa mmat tna mhar mawe anu fo kuber woJõ oh meto. Soh anu nno bo wefo kbe raa mbaut Allah.” ");
INSERT INTO ayz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tna Yesus yawe, “Taja yhafri Jõ. Tna Jõ thafri anu wefo mfi feto ye. Nhau nhafri Jõ wer. ");
INSERT INTO ayz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jõ tari bo ro Taja ybis kʼJõ tbo tno. Tibyo Ait yhafri Jõ wer. Soh anu nri bo ro tbis kʼanu, nbo nno to, kbe Jõ thafri anu wer mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Jõ simaut mase. Tna tkyas bo weto kʼanu afo re anu simaut mase ye. Jõ ksoh tawe anu simaut mase, mnan fi Jõ simaut mase; aro mabut fee. ");
INSERT INTO ayz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Bo ro Jõ tbis kʼanu oh mefo: Nhafri anya kaket. Nhafri anya kaket mnan fi Jõ thafri anu wefo ye. ");
INSERT INTO ayz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Soh raa sait yhafri yafoh wait to, ja ksoh yawe yno riof kʼana. Tna mfi bo raa mbis mawe raa retait ysan ait yetsu afo re riof kʼana to, kbe yawe, ‘Ae.’ Ait ro ysan yetsu rait feto to, kbe raa mmat tna mhar mawe ait retait yhafri yafoh wait toni miwer. ");
INSERT INTO ayz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Soh anu nno bo bawya ro Jõ tbis kʼanu to, anu fo Jõ tafoh woJõ. ");
INSERT INTO ayz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sryan sor to, ja wase bo ro bobot rana yno. Menohe bo bawya ro Jõ tari kʼTaja to, tkyas kʼanu. Tibyo ati ro Jõ tkyas anu to, ttu anu sryan woJõ u fee. Anu fo Jõ tafoh woJõ. ");
INSERT INTO ayz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Anu nsok Jõ to fee. Jõ oh mi tsok anu. Tna tbis anu nmo tna tufrok make: Make ro kbe mhau bau tibyo. Tna bo ro anu nyoh mkah tak ro Jõ tasom to, kbe Taja yoo yee kʼanu. ");
INSERT INTO ayz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bo ro tbis kʼanu oh mefo: Hafri anya kaket.” ");
INSERT INTO ayz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesus yawe kuber wAit yawe, “Raa ro tabam refo knait anu. Menohe ktak ma. Nnaut nwe ana weto tiwya knait Jõ wia oh. ");
INSERT INTO ayz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Raa ro tabam refo smot Jõ fee. Menohe anu fo nhaf sau nsya ana weto fee. Mfi bo anu nhaf sau su nsya ana weto meto mi kbe ana ksoh anu to! He mfe. Anu smot Jõ tibyo anu nhaf sau su nsya raa ro tabam refo fee. Jõ tsok anu afo re anu nmo raa woJõ. Anu fo raa ro tabam refo u fee. Au oh mi ana weto knait anu. ");
INSERT INTO ayz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nnaut bo ro riwai tkyas kʼanu tawe, ‘Sryan sait yase yiwer bobot rait fee.’ Jõ tnan fi bobot ranu. Tna ja raa sikowah Jõ. Feto kbe raa sikowah anu fo ye. Raa ro tabam refo ja mari bo ro Jõ tkyas kʼana to fee. Tna meen ana mari bo ro anu nkyas kʼana to ye fee. ");
INSERT INTO ayz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ana wase Allah ro ybis Jõ troh tamaʼt tabam refo. Tibyo raa weto kbe mno bo ro mkair mai kʼanu. Anu kro Jõ oh mi kbe ana mno bo ro mkair mai kʼanu to. ");
INSERT INTO ayz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mfi bo tama to kʼana fee tna tkyas bo kʼana fee, maami Allah ymit iro kʼana fee. Tna yawe ana masom iro wana to fee ye. He mfe, tama to kʼana oh. Tna ana mari bo ro Jõ tkyas kʼana fee. Tibyo kbe ana mesait masom iro wana yum. Kbe saak iro wana fee. ");
INSERT INTO ayz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Awya ro knait Jõ to, Ait retait knait Taja aJõ ye. ");
INSERT INTO ayz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mfi bo tama to kʼana fee tna tno bo ro msai aro fee, maami Allah ymit iro yawe ana masom to fee. He mfe, ana mmat bo msai ro Jõ tno, bo ro ja raa mno fee. Tna ana beroh knait Jõ tsya Taja ye. ");
INSERT INTO ayz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bo mkair ro ana mno reto to mnan si bo ro tiwya Musa ykyas. Watum ro agama rana reto mkyas ana matim wia. Au oh mi: ‘Jõ tno bo mkair aro fee menohe raa knait Jõ sai.’ Mazmur 35:19, 69:5 Bo ro tiwya Allah yawe to mhau rau oh.” ");
INSERT INTO ayz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Tna Yesus yawe, “Kbe tayoh kʼTaja re ybis Har rAit mama matam anu. Har reto kbe watum bo kʼanu. Tna bo ro nno to, kbe Har reto mban anu ye. Har reto mbam Allah mama to tna ja mkyas bo ro maja to sau sre fee. Mkyas bo ro mabo. Kbe mama tna mkyas Jõ tasom aJõ. ");
INSERT INTO ayz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tna anu fo tiwya kro Jõ bmo su maban tinyi wore wo Jõ tamo guru. Tibyo anu nkyas Jõ tasom aJõ kʼraa ye.” ");
INSERT INTO ayz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesus yawe kuber wAit yawe, “Riwai tkyas tawe, ‘Kbe raa ro tabam refo knait anu.’ Bo weto beta Jõ tkyas kʼanu wia matim afo re kbe nmat bo wefo mabo to, kbe anu beroh smot Jõ fares. Kbe anu btek nwe fee. ");
INSERT INTO ayz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Raa manes ro Yahudi kbe meen mikyak anu, mawe wa mawe anu skabuk su nsya raa ro Yahudi mam samu watum rana u fee. Tna kbe raa mame anu taro njat. Tna raa ro mame anu weto to mnaut mawe ana mno bo moof, mnaut mawe reto Allah yhaf mnan. ");
INSERT INTO ayz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ana weto wase Taja tna wase Jõ ye. Tibyo mno bo feto. ");
INSERT INTO ayz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kair weto mama mai kʼanu fe fares. Tiwya tinyi snok mfo refo thau tsya anu fares. Feto to tkyas bo mkair weto tna sai. Mfo refo Jõ tkyas bo wefo kʼanu wia matim. Tkyas wia re kbe meen, ati ro bo mkair weto mabo to, anu nnaut nwe bo weto tiwya tawe kʼanu oh.” ");
INSERT INTO ayz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Menohe ayõ baro firwas tna thah tamo to kʼAit ro tiwya ybis Jõ troh tama tabam refo. Menohe fyi re anu sait bo ytu kʼJõ fee yawe, ‘Nyõ namoʼt hayo meto?’ ");
INSERT INTO ayz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jõ tkyas bo wefo tibyo anu sraujin. ");
INSERT INTO ayz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Anu hawe bo Jõ sikba anu. Tamo tna kbe tbis Har ro Tuhan mama mo kʼanu. Har reto kbe mkyas watum kʼanu tna bo ro nno to, Au mban anu ye. Nnaut: Jõ tamo menohe tis rau to mafer moof kʼanu meto. Soh Jõ tamo fee; kbe Har reto mama mo kʼanu fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Meen Har ro Tuhan mama tna betoo bo kʼraa ro tabam refo. Mkyas kʼana ro hawe smot Jõ. Har rAit betoo iro ro ana ja mno to re mhar kaket. Tna Har rAit betoo bo ro Allah ksoh raa mno to ye. Raa ro tabam refo ja mnaut mawe ana mhar bo ro Allah ksoh ana mbo mno oh. He mfe. Kbe Har rAit betoo bo reto kʼana kaket. Tna raa ro tabam refo ja mros susai mtu sas safo raa to, mtu kaket fee ye. Kbe Har rAit betoo bo reto kʼana kaket ye. ");
INSERT INTO ayz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Raa ro tabam refo smot tna msam wai kʼJõ fee. Au oh mi Har rAit kbe betoo iro wana kʼana kaket. ");
INSERT INTO ayz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tamo to kʼTaja to tna kbe anu nmat Jõ u fee. Feto to tesait tkyas bo kʼraa ro tabam refo u fee. Au oh mi Har ro Tuhan kbe betoo bo ro Allah ksoh raa mno to. ");
INSERT INTO ayz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kabes yabi (Iblis) ja ybo raa ro smot Jõ fee. Menohe Allah yoo safo mana ymit kʼait oh. Au oh mi kbe Har rAit mama betoo iso ro Allah kbe yros susai ytu safo raa to. ");
INSERT INTO ayz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Tna Yesus yawe kuber wAit yawe, “Jõ tawe tkyas bo mawat kʼanu fares. Menohe tkyas bo weto beta fee. Bo ro samyoh meto tna mfo refo anu srau fefares. ");
INSERT INTO ayz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Menohe kbe Har ro Tuhan mama. Tna Har reto mkyas bo sioh fee. Mkyas bo ro Allah kʼanu re anu nhar bombra beta ro ati. Har reto mesait mkyas bonaut rau fee. Menohe mkyas bo ro mari kʼAllah. Tna mkyas bo ro meen mama ye. ");
INSERT INTO ayz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Har reto mari bo mbam kʼJõ tna mkyas bo reto kʼanu. Mno feto tna kbe raa mhar bo yase aJõ, tibyo bibi Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bombra ro Taja wAit msya bohar rAit weto beta to bo woJõ ye. Feto oh mi tawe kʼanu tawe, ‘Har reto kbe mkyas bombra ro Au mari mbam kʼJõ to mkyas kʼanu.’” ");
INSERT INTO ayz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Tna Yesus yawe, “Ayõ kbet baro sai tna kbe anu nmat Jõ u fee. Tna ayõ kbet sai naut tna anu nmat Jõ u.” ");
INSERT INTO ayz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tna kuber ro Yesus mtu kʼanya mawe, “Ykyas bawya meto ee? Ait yawe yamo yo kʼYaja tibyo ayõ kbet sai baro tna kbe bmat Ait u fee. Tna ayõ kbet sai naut tna anu bmat Ait u. ");
INSERT INTO ayz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bawya oh mi ykyas yawe, ‘Ayõ kbet sai?’ Anu wase bwe Ait ykyas bo bawya meto!” ");
INSERT INTO ayz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Menohe Yesus yhar yawe ana mawe mtu bo kʼAit. Tibyo yawe, “Riwai tawe, ‘Ayõ kbet sai baro tna kbe nmat Jõ u fee. Tna ayõ kbet sai naut anu nmat Jõ u.’ Reto oh mi anu ntu kʼanya meto a? ");
INSERT INTO ayz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nnaut: Anu kbe sraujin tna nwia. Menohe raa ro tabam refo kbe simaut renti. Anu kbe nwia wia matim. Menohe kbe simaut mrof. ");
INSERT INTO ayz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mfi bo fai sau ro mhaf kene wo mabe to, ayõ ro ngkine mabe to kborham toni. Tna ku frok. Tna au sorni bo riwai kborham reto. Ku rau frok yama oh tibyo au simaut. ");
INSERT INTO ayz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mfo refo anu fo sraujin. Menohe kbe anu simaut mase mfi feto ye. Kbe hah tama fri anu u. Tna raa sait bo yatak yno re simaut ranu reto marak fee. ");
INSERT INTO ayz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nnaut: Ti reto to, anu ntu bo aro kʼJõ u fee. Wore weto to, bo bawya sai ro anu nyoh mkah tak ro Jõ tasom aJõ to, kbe Taja ysan kʼanu. ");
INSERT INTO ayz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mamo snok mam mfo refo to, anu nyoh bo aro mkah tak ro Jõ tasom fefares. Nyoh re kbe anu tru. Tna kbe simaut mase.” ");
INSERT INTO ayz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tna Yesus yawe kuber wAit yawe, “Bo wefo beta Jõ tkyas kʼanu mkah bofret. Menohe meen tkyas bo maja ro Taja to, tkyas abyõ sai kʼanu. ");
INSERT INTO ayz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Ati weto to, kbe anu nesait nyoh bo kʼTaja mkah tak ro Jõ tasom. Jõ tayoh fee. Taja yesait yhafri anu. Tibyo anu nesait nyoh bo kʼAit. Anu nhafri Jõ tna smot Jõ to. Tna Anu nhar nwe Allah ybis Jõ tama. Feto tibyo Taja yesait yhafri anu to. ");
INSERT INTO ayz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tbam Taja troh tamaʼt tabam refo. Tna mfo refo Jõ sikba tabam refo hah tamo to kʼTaja.” ");
INSERT INTO ayz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tna kuber ro Yesus mawe, “Mfo refo Nyõ nkyas bo abyõ. Nyõ fret bo fee. ");
INSERT INTO ayz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nkyas feto to tna mfo refo amu nhar nwe Nyõ nhar bombra beta. Riwai Nyõ nhar bo ro amu nwe ntu kʼNyõ oh, menohe amu ntu bo reto fefares! Nyõ nkyas bombra beta mkak oh. Reto oh mi amu smot Nyõ tna nhar nwe Nyõ nama nbam Allah. Kbe amu ntu bo aro u kʼNyõ to fee.” ");
INSERT INTO ayz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tna Yesus yawe, “Mfo refo anu smot Jõ. ");
INSERT INTO ayz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Menohe kbe anu nsam. Anu aro yasen ysam yamoʼt samu rait-rait. Tna sikba Jõ tesait akus. Menohe Taja yatam Jõ tibyo tesait kar fee. ");
INSERT INTO ayz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Bo wefo beta tkyas kʼanu afo re nhaf tnok tna waa ma. Nhau nhaf sau, srau sau su nsya Jõ tna kbe nhaf wanu tnok tna waa ma. Anu nhau mam tabam refo fares tibyo kbe anu raa sikowah. Menohe sraujin toni ma, mbito ntak. Jõ tase tros tatak tbo ait ro ybo tabam refo.” ");
INSERT INTO ayz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus ykyas bo weto kuber wAit mkak. Tna fo heyut ymat ayoh tna yawe, “Taja, Jõ fi Ku aNyõ. Kene wo ayõ rau sboh oh. Nno re raa mmat Jõ tase aJõ. Raa mmat Jõ tase aJõ mi ana mmat Nyõ nase aNyõ oh meto. ");
INSERT INTO ayz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tiwya Nyõ noo tak nee kʼJõ tamo Raa ro tase tbo raa ro tabam refo beta. Nno feto afo re Jõ tatak tno raa mhau hame wajin. Nyõ nsok awya ro yamo raa woJõ, tna Jõ tno ana weto beta meen mhau hame wajin ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jõ ksoh re ana mhar Nyõ nhaf, srau aNyõ kaket, tna mhar mawe Nyõ fi Allah yesait aran tum. Tna Jõ ksoh re ana mhar mawe Jõ fi Yesus Kristus: Jõ fi Ait ro Nyõ nbis tama tabam refo. Soh ana mhar anu mbewok feto kbe ana mkai roon ro hame oh meto. ");
INSERT INTO ayz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tno bo ro Nyõ nbis kʼJõ to, beta tno mkak. Au oh meto tno re raa mmat bo yase aNyõ. ");
INSERT INTO ayz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tiwya tinyi thau tsya Nyõ su mam wore wo tabam refo raa mfen fefares. Bo yase wanu bewok to mninon. Mfo refo tayoh tawe Nyõ tubat Jõ hah te tamo to kʼNyõ, tna nno re tase mnan tii reto u. ");
INSERT INTO ayz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Taja, raa ro tabam refo to, taro mamo raa woNyõ. Tna Nyõ nawe raa weto to raa woJõ ye. Jõ tno re ana mhar Nyõ. Ana mari bo ro Nyõ nawe tna mbo mno. ");
INSERT INTO ayz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bo ro Nyõ noo nee kʼJõ oh, mfo refo raa woJõ weto, mhar mawe Nyõ oh mi Raa ro noo bombra wefo beta nee kʼJõ. ");
INSERT INTO ayz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bokyas ro Nyõ nawe kʼJõ to, Jõ tkyas kʼana oh. Tna ana mari tna moo mse kʼana oh. Ana mhar mawe Jõ tama tbam Nyõ. Ana mnaut maut-mroh fee. Ana smot Jõ tna mhar mawe Nyõ oh mi nbis Jõ tama. ");
INSERT INTO ayz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mfo refo Jõ skabuk ana. Skabuk raa ro tabam refo fee. Skabuk ana ro Nyõ nsan kʼJõ sai. Ana wefo fo raa woNyõ. ");
INSERT INTO ayz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Raa woJõ beta to raa woNyõ ye. Tna raa woNyõ beta to raa woJõ ye. Ana weto, bo ro mno to merif bo yase aJõ.” ");
INSERT INTO ayz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Taja, Nyõ nesait aran Raa ro nase. Thau mam tabam refo kait u fee tna Jõ tama to kʼNyõ. Menohe ana mhau mam tabam refo fares. Taja, Nyõ to Raa ro nase. Jõ tayoh kʼNyõ tawe kmot ana mkah natak aNyõ. Tak reto Nyõ nsan kʼJõ ye. Kmot ana re kbe ana mhau mhaf, srau sau, mnan fi Nyõ nsya Jõ bhaf sau to ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wore thau tsya ana fares to, Jõ kmot ana mkah natak aNyõ, tak ro Nyõ nsan kʼJõ reto. Jõ kmot ana tibyo ana beta beroh smot Jõ. Menohe Bokom ro aNyõ mawe ana sait kbe safe mkak. Reto tiwya nabi sait ykom tna kbe mabo mnan si Bokom reto.” ");
INSERT INTO ayz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tna Yesus skabuk yawe, “Ayõ baro firwas tna hah tama to kʼNyõ mam teto. Menohe thau mam tabam refo fares to, tkyas bo wefo beta afo re ana wefo simaut toni mnan fi Jõ to ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jõ tnan anya tsya raa ro tabam refo fee. Jõ tkyas bokyas aNyõ kʼana ro Nyõ nsan kʼJõ oh. Ana wefo mnan anya msya raa ro tabam refo fee. Tibyo raa ro tabam refo knait ana. ");
INSERT INTO ayz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jõ skabuk tawe Nyõ tufrok ana mbam tabam refo fee. He tayoh re Nyõ kmot ana re kbe kabes yabi (Iblis) yno ana ma. ");
INSERT INTO ayz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ana wefo mnan anya msya raa ro tabam refo fee; mnan fi Jõ tnan anya raa ro tabam refo fee ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bokyas aNyõ to bo ro ati. Bokyas aNyõ to bo ro mabo tu oh! Jõ tayoh tawe nno re ana mari bokyas aNyõ tna mbo mno. Feto oh mi Nyõ noo ana nbo mkah mno bo woNyõ. ");
INSERT INTO ayz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tiwya Nyõ nbis Jõ troh tama tabam refo. Tna tbis ana wefo mamo mo kʼraa ro tabam refo mfi feto ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tawe too Jõ tsan kʼNyõ re tno bo ro Nyõ nawe. Tno feto afo re mafer ro moof kʼana. Kbe ana beroh matak moo ana msan kʼNyõ re mno bo woNyõ to ye.” ");
INSERT INTO ayz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Tna Yesus yawe kʼYaja yawe, “Jõ skabuk ana wefo mesait aran fee. Meen ana mamo mkyas Jõ tasom aJõ renti. Tibyo kbe raa taro smot Jõ. Feto to Jõ skabuk raa weto ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tayoh re ana beta mhaf sau msya anya, mnan fi Nyõ nhaf sau nsya Jõ to ye. Tna mnan fi Jõ thaf sau tsya Nyõ ye. Jõ skabuk bo refo re kbe ana beta mhaf sau msya anu mbewok. Feto tibyo raa ro tabam refo mmat tna mhar mawe Nyõ oh mi Raa ro nbis Jõ troh tama tabam refo. ");
INSERT INTO ayz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tiwya Nyõ nsan bo yase aNyõ to kʼJõ. Tna Jõ tsan bo yase aNyõ reto kʼana ro smot Jõ. Afo re ana beta mhaf sau, mnan fi Anu bewok bhaf sau ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jõ fi thaf sau su tsya ana. Tna Nyõ fi nhaf sau su nsya Jõ. Tayoh re ana ro smot Jõ to beta mhaf sau su mnan si. Soh raa woJõ mhaf sau su to, kbe raa ro tabam refo mhar mawe Nyõ oh mi nbis Jõ. Tna raa ro tabam refo mhar mawe Nyõ nhafri Jõ tna Nyõ nhafri ana ro smot Jõ mnan anya ye.” ");
INSERT INTO ayz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tna Yesus skabuk renti yawe, “Taja, tiwya tabam refo Anu bfen fefares to, Nyõ hafri Jõ oh wia. Tibyo Nyõ nsan bo yase aNyõ kʼJõ. Jõ skabuk raa ro Nyõ nsan kʼJõ; raa beta ro kbe smot Jõ: Jõ ksoh tawe ana meen mhau su msya Jõ mam sawro aNyõ ye. Tna re ana mmat bo yase aJõ reto ye. ");
INSERT INTO ayz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taja: Nyõ fi raa ro nhaf mato moof ati. Raa ro tabam refo wase Nyõ. Menohe Jõ thar Nyõ. Tna kuber woJõ wefo mhar mawe Nyõ oh mi nbis Jõ sai. ");
INSERT INTO ayz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jõ tkyas Nyõ nasom aNyõ kʼana wefo oh. Tna kbe tno feto renti. Nyõ nhafri Jõ kaket. Tna tkyas nasom aNyõ kʼana afo re ana mhar bo hafri raa anya mnan fi Nyõ nhafri Jõ. Tno afo re Jõ tesait thaf sau tsya ana.” ");
INSERT INTO ayz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus skabuk mkak. Tna fo Ait ysya kuber wAit masen mamo. Ana frit aya ro Kidron mamoʼt maam jaro. Tna twok mam armato sau. ");
INSERT INTO ayz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","(Yesus ysya kuber wAit ja mamoʼt armato reto. Tibyo Yudas ro besruf Yesus, yhar yuk reto oh.) ");
INSERT INTO ayz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudas yerif iso ro mamoʼt armato reto kʼraa sbe ro Roma. Tna riwai imam manes ro agama Yahudi msya raa ro Farisi, mbis aban mana wana mesait baro mama ye. Feto to Yudas yakah raa mawat yama mbam Yerusalem: Raa sbe ro Roma majin sau, msya aban mana ro agama Yahudi baro mama ye. Ana mama nkro Yudas to, mbo lentera, tafoh, msya masom sbe wana to ye. ");
INSERT INTO ayz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus yhar bo ro kbe mai kʼAit wia oh. Tibyo Ait yasen yamo yo kʼraa weto yawe, “Anu saso awya?” ");
INSERT INTO ayz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ana mawe, “Yesus, raa ro Nazaret.” Tna Yesus yawe, “Jõ Ait oh mefi.” (Yudas, ro besruf Ait, yros ysya ana mam weto ye.) ");
INSERT INTO ayz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ati ro Yesus yawe, “Jõ Ait oh mefi.” to, ana susu mhah me tna mbtek mawe mam tabam. ");
INSERT INTO ayz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesus yawe u kʼana yawe, “Anu saso awya?” Ana mawe, “Yesus, raa ro Nazaret.” ");
INSERT INTO ayz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ait yawe, “Tkyas oh tawe Jõ oh mefi. Soh Jõ tesait oh mi anu saso to, bitsre ana wefo taro mamo rof.” ");
INSERT INTO ayz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Yesus yawe raa sbe weto bitsre kuber wAit mhau riof feto to, ykyas mnan fi bo ro riwai Ait skabuk wia matim yawe, “Raa ro Nyõ nsan kʼJõ to Jõ kmot ana tibyo ana beta beroh smot Jõ; sait bo kbe yarak fee.”) ");
INSERT INTO ayz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tna Simon-Petrus ybo krewan rait tna ysot raa ro yama yfot Yesus sait yimara. (Ait retait yasom Malkhus. Ait tait sryan ro imam yase rait.) Petrus ysot yimara rait ro tem ati ktos. ");
INSERT INTO ayz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tna Yesus yastako Petrus yawe, “Noo krewan anyõ reto srya mam tafat rau u! Taja ysi bo kʼJõ, yawe tasom bo ro samyoh ro mfo refo mama mai kʼJõ. Tna Jõ tawe tno bo beta mnan si bo ro Taja ybis oh!” ");
INSERT INTO ayz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tna raa sbe ro Roma majin reto msya aban mana ro yase ybo ana mfot Yesus. Ana msya raa ro ja kmot Samu Ro Allah tna msya raa manes ro agama Yahudi weto sor mfot Yesus tna make yatem. ");
INSERT INTO ayz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ana mbo Ait makah mamo mo kʼHanas. (Ti weto to bi Kayafas yamo imam agama Yahudi ro yase. Bi Hanas tait imam yase ro wia. Bi ait tait Kayafas snyim rait. ");
INSERT INTO ayz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas oh mi raa ro taa yawe kʼraa mabi ro agama Yahudi yawe, “Rau ro moof to, raa sait yhai sai. Soh mfe to, kbe raa wanu majat beta.”) ");
INSERT INTO ayz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Mbam armato reto, Simon-Petrus ysya kuber roto sait kro mam ttis mrof. Raa makah Yesus twok mam samu mato ro imam yase rait. Kuber roto retait, imam yase yhar oh. Tibyo ait kro Yesus mamo snok mam bohra reto. ");
INSERT INTO ayz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Menohe Petrus ste mne wea mam masa. Tna kuber roto retait yamo ykyas kʼsrian ro ano sau ro ja kmot masa, tna ymen Petrus twok mam bohra reto mato ye. ");
INSERT INTO ayz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Petrus twok tna sryan ro mros mam masa reto mtu kʼait mawe, “Nyõ refi kuber ro Raa retait ye, fe mfe a?” Petrus ywaar yawe, “Mfe.” ");
INSERT INTO ayz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Arin foos-foos tna sryan msya raa manes taro mros mam bohra mni foos. Tna Petrus yamo yros kene ysya ana mam tafoh reto yni foos ye. ");
INSERT INTO ayz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Imam yase ro wia yasom Hanas. Ait yhau mam amah mato tna ytu sas Yesus. Ytu yawe bo ro ja ykyas to bawya, tna raa ro ja kro Ait to awya. ");
INSERT INTO ayz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesus yawe, “Taja: Ja Jõ tkyas abyõ kʼraa mawat mari. Tkyas bo kʼraa ro Yahudi sor mam samu watum wana tna mam Samu ro Allah mam Yerusalem fo ye. Tkyas bo wai aro fee. ");
INSERT INTO ayz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Fyi re nyõ ntu bo kʼJõ? Ntu bo kʼana ro mari bokyas aJõ reto. Ana mhar bo ro Jõ tkyas reto.” ");
INSERT INTO ayz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus yawe feto tna raa manes sait yiban yasu. Tna yawe, “Nasoh moof sai! Nkyas bo feto kʼimam ro yase retait ma!” ");
INSERT INTO ayz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus yawe, “Soh Jõ tkyas bo ro mkair aro, feto nawe abyõ re raa mhar. Menohe soh Jõ tkyas bo ro ati to, fyi re nyõ niban Jõ?” ");
INSERT INTO ayz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesus yatem rait, riwai raa make mkah too. Tna Hanas ybis raa makah Yesus mamo mo Kayafas. (Ti reto to, bi Kayafas yamo imam ro yase.) ");
INSERT INTO ayz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mam bohra samu reto to, Petrus yros yni foos fares. Tna raa mtu kʼait mawe, “Nyõ fi kuber ro Yesus!” Menohe Petrus ywaar yawe, “Mfe!” ");
INSERT INTO ayz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sryan imam ro yase sait yros mam weto ye. Ait retait raa mana sau ysya sryan ro riwai Petrus ysot yimara retait. Tna yawe kʼPetrus yawe, “Jõ thar Nyõ. Nyõ oh mi riwai nsya Ait nmo su mam armato!” ");
INSERT INTO ayz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tna Petrus ywaar yawe, “Mfe!” Yawe feto si fo kook sau mara. ");
INSERT INTO ayz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Rabu momo raa ro Yahudi weto makah Yesus mbam samu ro Kayafas mamoʼt samu wore wo Gubernur Pilatus ja ytu srah yari. Menohe ana raa ro Yahudi tibyo ana mesait twok mam samu reto mato fee. Watum ro agama rana mawe samu raa ro agama roto to mbau kʼana. Tibyo ana kaket ana tna twok mam mato fee. Soh miwer watum reto kbe ana sohmaam bo msya raa wana mam korat ro Paskah to ma. ");
INSERT INTO ayz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Feto tibyo Pilatus frok yamoʼt mne yo kʼana tna ytu yawe, “Bo bawya ro anu nkyas mai kʼraa refi fo?” ");
INSERT INTO ayz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ana mawe, “Soh Ait yno safo fee, fyi re amu nfot Ait nkah nma no kʼnyõ!” ");
INSERT INTO ayz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus yawe, “Nbo Ait nmo oh! Nesait nmit safo kʼAit mnan si Watum ro agama ranu rof.” Ana mawe kʼPilatus mawe, “Amu nwe nno yasu marak menohe Pemerintah Roma mawe amu raa ro Yahudi ntu srah wamu tna nmit safo menohe mbis mawe anu nme raa majat mamyot si watum ranu fee!” ");
INSERT INTO ayz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bo refo ana mkyas mnan si bawya ro Yesus ykyas wia matim yawe iso ro kbe raa mame Ait yajat. ");
INSERT INTO ayz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus hah twok mam samu reto tna yawe Yesus kro Ait. Ait ytu bo kʼYesus yawe, “Nyõ fi Raja raa ro Yahudi fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tna Yesus yawe, “Bokyas reto mbam kʼnyo nesait sai a? Bo ro nyõ nawe reto mbam raa roto fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus yawe, “Jõ fi raa ro Yahudi fee! Raa woNyõ ro Yahudi msya imam manes wonyõ mesait oh mi msan Nyõ kʼJõ tatem fo. Nyõ nno bo bawya re ana msan Nyõ kʼjõ fo?” ");
INSERT INTO ayz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus yawe, “Wore wo Jõ tase tbo raa mnan fi Raja to, tno mam tabam refo fee. Mfi bo tawe tamo Raja mam tabam refo fo, maami raa ro kro jõ kbe mros tis kʼJõ. Soh feto to, kbe ana mafa tna mno wa afo re raa ro Yahudi mfot Jõ to ma. He mfe. Wore wo tbo raa mnan fi Raja to, tno mam tabam refo fee.” ");
INSERT INTO ayz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tna Pilatus yawe, “Soh feto, Nyõ fi Raja fe mfe a?” Yesus yawe, “Ae, Jõ fi Raja. Au oh mi fnya mabe Jõ tna troh tama tabam refo. Tama tabam refo mkah tno bo sau aran, au oh mi; tama tkyas bokyas ro ati. Tama afo re tkyas bo ro ati kʼraa. Tna awya ro yros tis bo ro ati mbam kʼAllah to, ait yari bo ro Jõ tkyas.” ");
INSERT INTO ayz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tna Pilatus ytu kʼAit yawe, “Bo ro ati to bawya meto?” Tna Pilatus frok yamo yo kʼraa ro Yahudi ro mros mam mne tna yawe, “Tkai bo ro Ait yno mkair aro fee. ");
INSERT INTO ayz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Menohe mfo refo anu nkyõ korat ranu ro Paskah. Tna bo mafa ro anu nno soo oh mi, ja tbis re raa ranu sait frok mbam bui tna yamo bait. Feto to anu ksoh nwe jõ kbe tufrok Raja ro Yahudi refi fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ana mawe, “Mfe! Bitsre Ait yamo bait ma! Bitsre Barabas kʼamu!” (Barabas tait raa ro tiwya yno safo tibyo pemerintah Roma mbu ait mam bui to.) ");
INSERT INTO ayz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tna Gubernur Pilatus yoo Yesus yee kʼraa nsaah Ait. ");
INSERT INTO ayz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tna raa sbe ro Roma weto moo bo ro maan mnan fi bmun hyoh tna ste watau sau. Tna mse Yesus sbyõ yana. Tna ana mawah ratan ro mkof ngknu sau, ro ja raa mase myum to, tna mse kʼAit yyum. ");
INSERT INTO ayz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tna ana mama mros mam Ait yasu tna sret Ait masah mawe, “Meen oh kʼNyõ, raja raa ro Yahudi!” Tna ana mai Ait yasu. ");
INSERT INTO ayz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tna Pilatus frok yamoʼt mne mun sau naut yo kʼraa ro Yahudi, tna ybis raa sbe makah Yesus frok. Ait yawe, “Jõ tsan Ait kʼanu re anu nhar nwe jõ tnaut tawe Ait yno safo sau bo fee. Jõ tmit safo aro kʼAit fee ye.” ");
INSERT INTO ayz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesus yyum ratan ro mkof tna sbyõ watau ro maan reto to, tna raa makah Ait mama. Tna Pilatus yawe, “Nmat Ait oh metait.” ");
INSERT INTO ayz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Imam manes msya raa wana ro mabi mmat Ait fo ana masen mawe, “Name Ait yajat oh!” Pilatus yawe kʼana yawe, “Nesait nkah Ait nme yajat. Jõ tkai bo ro mkair sau aro Ait yno fee.” ");
INSERT INTO ayz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Menohe raa ro Yahudi weto mawe, “Ait yawe Ait fi Ku ro Allah yare. Tna watum ro agama ranu mbis mawe, ‘Soh raa yawe bo feto to, kbe Ait raa mame yajat.’” ");
INSERT INTO ayz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus yari bo reto to, ait waa toni renti. ");
INSERT INTO ayz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tibyo Ait hah twok mam samu mato reto u. Tna raa sbe mbo Yesus twok ye. Tna Pilatus ytu kʼAit yawe, “Nyõ raa ro hayo?” Menohe Yesus yawe bo aro si kʼait fee. ");
INSERT INTO ayz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatus yawe, “Nyõ hawe nkyas bo nsya jõ a? Nyõ wase nawe jõ fi tatak tbis raa mbitsre Nyõ namo bo Nyõ. Tna soh jõ tbis feto to, kbe raa mbitsre. Tna soh tbis raa mame Nyõ to, kbe raa mame.” ");
INSERT INTO ayz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus yawe, “Allah oh mi Raa ro yoo tak reto yee kʼnyõ to. Soh Ait yoo yee fee maami nyõ natak fee ye. Feto to ait ro ysan Jõ kʼnyõ natem anyõ to iro rait reto msai miwer iro anyõ.” ");
INSERT INTO ayz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus yari bokyas ro Yesus reto tna yawe tomer bitsre Yesus. Menohe raa ro Yahudi mtu fari-fara mawe, “Bi yabi, soh nyõ bitsre Ait to, nyõ nafoh Kaisar fee! Awya ro yawe yamo raja to ait retait yamo byoh Kaisar!” ");
INSERT INTO ayz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Raa ro ytu srah to ja hre mam ambar sau. Ambar refo fo mhau mam yuk ro raa mtu mawe 'Litostrotos'. (Mai ro Ibrani to, raa mtu mawe 'Gabata'.) Pilatus yari bo raa ro Yahudi riwai mawe reto tna yamo hre mam ambar reto. Ait ybis raa sbe makah Yesus frok. ");
INSERT INTO ayz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","(Ti reto to, raa siwyan bo re menrabu mno korat ro Paskah. Ayõ ro 12 baas bo feto.) Tna Pilatus yawe kʼraa ro Yahudi weto yawe, “Raja ranu mefi!” ");
INSERT INTO ayz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Menohe ana mtu mawe, “Nkah Ait nmo oh! Nmo nme Ait yajat! Nme ait yajat mam ara warok!” Tna Pilatus yawe, “Nwe tbis raa mame raja ranu mam ara warok a?” Tna imam manes weto mawe, “Kaisar yesait aran yamo raja ramu!” ");
INSERT INTO ayz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tna Pilatus ysan Yesus kʼana re raa mame. Tna raa sbe ro Roma weto makah Yesus mamo. ");
INSERT INTO ayz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ana moo ara warok mse kʼYesus yasom. Tna mamoʼt yuk ro masom Hamana. (Mai ro Ibrani to raa mawe 'Golgota'.) ");
INSERT INTO ayz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mam beto raa mse Ait mam ara warok reto. Raa roto mabo ewok raa mame su msya Ait ye. Sait mam ti yatem ati, tna sait mam ti yatem ta, tna Yesus raa mse mam masuf. ");
INSERT INTO ayz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tna Pilatus ybis raa mkom bo refo: “Yesus fi raa ro Nazaret. Ait fi raja raa ro Yahudi.” Bokom refo raa moo mse mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yuk ro raa mame Yesus to kene sai mam kota. Tibyo raa ro Yahudi mawat mmat bokom reto. Bokom reto raa mkom mam mai trion tuuf: Ibrani, Latin msya mai ro Yunani. ");
INSERT INTO ayz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Menohe imam manes ro agama Yahudi weto hafrah. Ana mamo mo kʼPilatus mawe, “Nkom ‘raja raa ro Yahudi’ ma! Nkom: ‘Raa refi yawe ait raja raa ro Yahudi.’” ");
INSERT INTO ayz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Menohe Pilatus yawe, “Ro jõ tkom reto mhau yum oh.” ");
INSERT INTO ayz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Raa sbe ro Roma mse Yesus mam ara warok. Tna fo ana moo ratan rait saim ftah trion jiit. Aro yoo ftah sau-sau. Menohe jubah rAit to, tiwya raa mfen kaket moof. (Jubah reto to, raa mtin mnan fi ja raa mtin ratan to fee. Raa moo benang tna sne muuf. Mfen mbam uu snok mam te.) ");
INSERT INTO ayz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Feto to raa sbe mawe kʼanya mawe, “Anu bhah jubah rAit reto ma. Nma, anu tane mkah undi re merif awya ro kbe ykai jubah reto.” Tna ana mno feto re mnan si mkah Bokom ro Allah mawe: “Ana saim-sam ratan aJõ, tna jubah aJõ ana mno mkah botane.” ");
INSERT INTO ayz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Fnya mabo jiit mros kene mam ara warok mair ro Yesus. Ana oh mi: Yesus yme Maria, msya mao, msya Klopas yfain ro masom Maria ye, tna msya Maria Magdalena ye. ");
INSERT INTO ayz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesus ymat yme msya kuber wAit sait mros. Ait retait Yesus yhafri. Tna yawe kʼyme yawe, “Tme, ku anyõ retait.” ");
INSERT INTO ayz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tna yawe kuber rAit retait yawe, “Nme oh meto.” Ayõ reto ye kuber retait ymen Yesus yme yamo yse mam samu rait. ");
INSERT INTO ayz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tna fo Yesus yhar yawe bombra beta ro Yaja yawe kʼAit yno to, yno mkak oh. Tna yawe, “Thai sbit.” Yawe feto ykyas mnan si tiwya Allah ybis raa mkom mam Bokom rAit. ");
INSERT INTO ayz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Anggur maya ro mano baro mhau mam baah sau. Tna raa moo bo ro mmot aya mnan fi spon, make mam ara makit tna mberu mam anggur maya reto. Tna tubat mee kʼYesus yata. ");
INSERT INTO ayz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yata tna yawe, “Bo ro tama tno mam tabam refo, tno mkak oh!” Tna yanwaruk ysan yamos rAit kʼYaja tibyo yhai. ");
INSERT INTO ayz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ti reto to, ayõ ro jumat. Feto to, raa ro Yahudi siwyan bo mkah ayõ ro raa wana ntmoh (hari Sabat). Ana ro manes hawe bo ajat weto mhau nkro akus mam ara warok ayõ menrabu reto. Menrabu to ayõ ro mase. Au oh mefo ana baro mamo mo kʼPilatus mayoh re ybis raa sbe wait miji raa weto maa wana tna skur ajat weto mbam ara warok trion tuuf reto. ");
INSERT INTO ayz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilatus ybis. Raa mana ewok raa mame msya Yesus fo. Tna raa sbe weto miji maa wana wia. ");
INSERT INTO ayz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tna ana mawe miji Yesus yaa rAit, he Ait yajat wia oh. Tibyo miji Yesus yaa fee. ");
INSERT INTO ayz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Menohe raa sbe sait yawah sawya ysu yajoh. Tibyo mees msya aya miyi frok. ");
INSERT INTO ayz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ti reto to, raa sait yesait ymat bo reto. Tna ait oh mi ro ykom aam refo. Tna bo ro ykyas to mabo tu. Ykyas bo refo afo re anu nhar nwe bo wefo beta ait ykyas sioh fee. ");
INSERT INTO ayz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bo weto mabo feto afo re mnan si Bokom ro Allah mawe: “Ytai rAit sau kbe raa miji fee.” ");
INSERT INTO ayz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tna bokom far-far taro ye mawe: “Ana kbe heyut mrom Ait ro ana msu.” ");
INSERT INTO ayz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bi Yusuf tait raa ro Arimatea. Tna ait kuber ro Yesus wAit sait ye. Menohe ait waa raa manes ro Yahudi. Tibyo smot bait wai. Yesus yajat tna Yusuf yamo yo kʼPilatus tna yayoh yawe yoo ajat ro Yesus. Tna Pilatus ybis Yusuf yamo yoo. ");
INSERT INTO ayz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","(Nikodemus tait raa ro tiwya yamo yo kʼYesus mam wore arin mti sau.) Ati refo ait yama tna ysya Yusuf mbewok makah ajat reto mamo. Nikodemus yakah bo ro mnan fi gaharu. Bo reto raa srioh msya mur tna mabyoh maut toni. Samyoh rau to 34 kilo bo feto. ");
INSERT INTO ayz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ana mabo ewok reto makah lenan (hawee ro moof) ye. Moo bo reto tna ngkaru mam hawee reto tna sro ajat ro Yesus. Mbewok mno mnan si ja raa ro Yahudi mno hai wana. ");
INSERT INTO ayz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kene wo Golgota to armato ro moof sau. Tna wore weto to raa mabah isra mato mkah bo meen raa mse hai wana. Menohe mamo snok ayõ reto raa mse hai mam isra mato reto aro fefares. ");
INSERT INTO ayz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Menrabu ayõ ro raa ntmoh. Tna isra reto kene sai. Tibyo ana mbewok moo ajat reto sama mam isra mato ro armato reto. ");
INSERT INTO ayz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ayõ ro minggu, rabu ati reto to, arin maah fefares. Tna Maria Magdalena mamoʼt isra reto. Mamo snok yuk reto tna mmat he isra reto to, masoh maa wea. Au mmat he fraa ro raa muut wa isra masoh reto to, raa mririk oh. ");
INSERT INTO ayz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mmat feto tibyo mhoh fooh mamo saso Simon-Petrus ysya kuber ro Yesus yhafri retait. Mamo mo kʼana mbewok tna mawe, “Jõ tmat Tuhan yarak mam isra! Raa msyõf Ait oh! Amu wase raa mse Ait mam tiyo!” ");
INSERT INTO ayz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tibyo Petrus ysya kuber roto sait masen mamo mmat Ait mam isra reto. ");
INSERT INTO ayz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mbewok mhoh mamo, he kuber roto retait yhoh wia Petrus. Tna snok isra mato reto wia matim. ");
INSERT INTO ayz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ait retait yaka koyo ymat mam isra mato. Ymat he hawee lenan ro raa sro Yesus reto sai mbris akus. He ait twok isra mato reto fee. ");
INSERT INTO ayz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tna Simon-Petrus yama tis yrof ait snok mam yuk reto. Snok tna twok mam isra reto mato. Tna ait ymat hawee reto mbris akus mam weto. ");
INSERT INTO ayz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tna ymat hawee mabuf ro raa make Yesus yana. Hawee reto raa beah tna mse hayah baro. ");
INSERT INTO ayz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tna fo kuber ro riwai yhoh yatim wia Petrus fi yamo twok ye. Ymat tna ait yhar yawe Yesus yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Bokom ro Allah mawe Yesus kbe yrok yasen. Menohe ati reto to, ana mhar maja rau kaket fefares.) ");
INSERT INTO ayz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tna fo kuber mabo ewok weto to hah mamoʼt amah. ");
INSERT INTO ayz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Magdalena mros kait kene wo isra reto to, mawia. Mawia tna maka mmat isra mato. ");
INSERT INTO ayz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Menohe mmat he malaikat mabo ewok. Malaikat weto mbewok myum ratan ro mboh. Mbewok hre mam ati ro raa mse Yesus ajat rAit. Sau hre mam ati ro yana, tna sau hre mam ti yaa. ");
INSERT INTO ayz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malaikat weto mawe kʼau mawe, “Fyi re nyõ nawia fo?” Maria mawe, “Tuhan ajõ ro smot tait, ajat rAit raa moo mamo marak. Tna jõ wase raa mse mam woyõ.” ");
INSERT INTO ayz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mawe bo reto tna haberek mmat he Raa sait yros mam weto. Ait refi Yesus, menohe au wase Ait ye. ");
INSERT INTO ayz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus ytu kʼfai au yawe, “Fyi re nyõ nawia fo? Nyõ saso awya meto?” Maria mrok mawe Ait fi raa ro kmot armato reto. Tibyo mawe kʼAit mawe, “Taja, soh nyõ noo Ait meto mi, nerif wore wo nyõ nse afo re jõ tamo too Ait takah tamo.” ");
INSERT INTO ayz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tna Yesus yawe, “Maria!” Tibyo au msiur mmat Yesus tna mawe, “Rabuni!” (Mai ro Ibrani reto to, mawe 'Guru'.) ");
INSERT INTO ayz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tna Yesus yawe, “Nbo Jõ wia ma! Jõ hah te taut tamo to kʼTaja fefares. He namo no kʼtao woJõ na. Tna nkyas kʼana nawe mfo refo Jõ hah te tamo to kʼTaja aJõ. Ait fi anu Nja wanu ye. Ait fi Allah ro Jõ smot. Tna Ait fi Allah ro anu smot ye.” ");
INSERT INTO ayz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria mamo mo kuber ro Yesus wAit mawe, “Riwai jõ tmat Tuhan!” Tna mkyas kʼana bombra beta ro Ait yawe. ");
INSERT INTO ayz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ayõ ro minggu reto arin mti oh. Tna kuber ro Yesus wAit hre su mam amah sau. Ana waa raa Yahudi ro manes weto. Tibyo muut masa matak. Menohe Yesus yama yros tubor susai kʼana tna yawe, “Waa ma.” ");
INSERT INTO ayz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ait ykyas feto tna yerif yatem msya yatefau rAit kʼana. Ana mmat Tuhan u to, ana simaut mase. ");
INSERT INTO ayz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tna Yesus yawe u yawe, “Riof kʼanu oh! Tiwya Taja ybis Jõ tamo to kʼraa. Tna mfo refo tbis anu tawe nmo no kʼraa nfi feto ye.” ");
INSERT INTO ayz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tna fo Ait yfi yafos rAit kʼana tna yawe, “Tsan Har ro Tuhan kʼanu mefo. Noo oh! ");
INSERT INTO ayz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Soh anu nwe kʼraa nwe, ‘Jõ tawe, iro ro nno to marak oh.’ Feto kbe Allah yyon iro ro ana mno oh. Menohe soh anu nwe iro ro ana mno mhau fares to, iro ro ana mno mhau bau.” ");
INSERT INTO ayz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas, ro ja raa mtu yasom Didimus ye, tait kuber ro Yesus wAit sait ye. Ana to mabo 12. Ti ro Yesus yerif Ait reto to, Tomas hre su ysya kuber taro to fee. Ait yarak. ");
INSERT INTO ayz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yama tna kuber taro mkyas kʼait mawe, “Amu nmat Tuhan!” He Tomas yawe, “Soh jõ tmat yier ro paku mam yatem fee, tbo fee, tna tnit temkrem mam yhaf ate ro raa mame fefares to, jõ aro wase bokyas ranu reto bo mabo rau yum fee.” ");
INSERT INTO ayz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Minggu sau firwas tna kuber ro Yesus wAit hre su mam amah u. Tna Tomas hre ye. Mato beta raa muut matak. Menohe Yesus yama yros tubor susai ana tna yawe, “Riof kʼanu oh!” ");
INSERT INTO ayz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tna Ait yawe kʼTomas yawe, “Nmat tatem aJõ nbo. Natem nbo tatefau aJõ. Nnaut maut-mroh ma. Smot Jõ oh!” ");
INSERT INTO ayz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas yari yno tna yawe kʼYesus yawe, “Nyõ fi Tuhan ajõ! Nyõ fi Allah ro Jõ smot!” ");
INSERT INTO ayz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tna Yesus yawe kʼait yawe, “Nyõ nmat Jõ oh mi nyõ smot Jõ. Raa taro mmat Jõ fee, menohe kbe ana smot Jõ. Kbe ana weto mhau simaut mase.” ");
INSERT INTO ayz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Amu, kuber ro Yesus nmat bo msai ro yno mawat. Menohe jõ tkom bombra beta mam aam refo fee. ");
INSERT INTO ayz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bombra ro jõ tkom mam aam refo fo, tkom afo re anu nhar nwe Yesus tait Mesias. Ait fi Ku ro Allah yare. Tkom afo re anu smot Ait. Anu ro smot Ait msya nri bo ro Ait yawe to, kbe nkai riof ro hame. ");
INSERT INTO ayz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ti baro firwas tna Yesus yerif Ait kuber wAit mam maru ro Galilea. (Maru reto to, masom maru ro Tiberias ye.) Bo reto fefo: ");
INSERT INTO ayz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon-Petrus, Tomas (ro ja raa mtu yasom Didimus), Natanael (raa ro Kana mam provinsi ro Galilea), ku ro Zebedeus wait, tna msya kuber ro Yesus mabo ewok roto taro naut to ana hre su. ");
INSERT INTO ayz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tna Simon-Petrus yawe kʼana yawe, “Tamo takam syoh.” Tna ana mawe, “Amu kro ye.” Ana maut wiak tna saso sioh mti reto mamo snok rabu. He mfot syoh aro fee. ");
INSERT INTO ayz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Isi ntara Yesus yros maru maam. Menohe ana mhar mawe Yesus metait fee. ");
INSERT INTO ayz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tna Ait ytu kʼana yawe, “Tao na, nfot syoh aro fe mfe a?” Ana mawe, “Mfe!” ");
INSERT INTO ayz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yawe, “Sik beak pukat ranu ti ntem ati kbe tru sioh!” Ana mari mno feto tna mkai syoh mawat toni. Tibyo ana mtai tubat fee. ");
INSERT INTO ayz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kuber ro Yesus yhafri retait yawe kʼPetrus yawe, “Tuhan metait!” Petrus yari feto tna yasen yyum ratan ro riwai yrus. Tna tbat mam aya kni yamo yo kʼYesus. ");
INSERT INTO ayz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kuber taro mhau mam wiak mato tna miin mamo mrof. Miin mamo tna mkuk pukat reto msya syoh weto mamoʼt maru mne. (Mne reto mhau fari fee; 100 meter sai bo feto.) ");
INSERT INTO ayz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ana snok mne tna mroh mbam wiak. Tna ana mmat roti msya syoh baro raa konta mam tafoh masuf. ");
INSERT INTO ayz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tna Yesus yawe, “Sgi nbo syoh ro anu tru baro nma!” ");
INSERT INTO ayz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon-Petrus yaut mam wiak tna ykuk pukat reto mamaʼt mne. Syoh ro mabi ran trion 153 mhau mam pukat reto mato menohe hri fee. ");
INSERT INTO ayz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus yawe kʼana yawe, “Nma sohmaam bo.” Kuber weto mhar mawe Ait refi Tuhan tibyo ana beta waa mawe mtu kʼAit fee. Mtu mawe Ait awya fee. ");
INSERT INTO ayz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tna Yesus yoo roti reto saim kʼana. Yoo syoh weto yee kʼana mabo ye. ");
INSERT INTO ayz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","(Yesus yrok yasen tna ti ro yerif Ait kuber wAit reto to, muhrin tuuf oh meto.) ");
INSERT INTO ayz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ana sohmaam bo mkak. Tna Yesus yawe kʼSimon-Petrus yawe, “Yohanes yare: Fyi, nyõ nhafri Jõ toni niwer raa taro fe mfe a?” Tna Petrus yawe, “Ae, Tuhan, Nyõ nhar nawe jõ thafri Nyõ.” Yesus yawe, “Feto to nsia domba maku woJõ.” ");
INSERT INTO ayz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mun ro ewok u Yesus yawe kʼait yawe, “Yohanes yare: Fyi, nyõ nhafri Jõ kaket fe mfe a?” Tna Petrus yawe, “Ae, Tuhan, Nyõ nhar nawe jõ thafri Nyõ.” Yesus yawe, “Feto to kmot domba woJõ.” ");
INSERT INTO ayz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tna Yesus ytu ro mun tuuf u kʼait yawe, “Yohanes yare: Fyi, nyõ nhafri Jõ fe mfe a?” Yesus ytu bo reto mun tuuf tna Petrus yari feto tna sraujin yawe, “Ae, Tuhan, Nyõ nhar bombra beta. Tibyo nhar nawe jõ thafri Nyõ.” Yesus yawe, “Feto to nsia domba woJõ. ");
INSERT INTO ayz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nnaut: Ati ro nyõ mere fares to, nyõ nesait ntau hotom anyõ, tna namo tiyo-teya ro nyõ ksoh sai. Menohe ati ro nyõ nabi to, kbe nyum natem nee kʼraa roto mbo tna moo hotom anyõ mbo mtau mati kʼnyõ naka ye. Tna ana makah nyõ mamoʼt yuk ro nyõ hawe bo namo.” ");
INSERT INTO ayz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus yawe bo reto yerif iso ro meen Petrus yajat. (Meen Petrus smot Yesus matak tibyo raa mame ait yajat Raa mmat bo ro yno tna mbaut Allah.) Tna Yesus yawe kʼait yawe, “Nama, kro Jõ oh!” ");
INSERT INTO ayz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tna Petrus ymat he kuber ro Yesus yhafri retait kro ana mam tis. (Ait retait oh mi raa ro tiwya susu hre kene ysya Yesus tna ytu kʼAit yawe, “Tuhan; awya oh mi kbe besruf Nyõ to?”) ");
INSERT INTO ayz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus ymat kuber retait tna ytu kʼYesus yawe, “Fyi? Bo bawya ro kbe mai kʼait refi?” ");
INSERT INTO ayz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus yawe, “Mfi bo Jõ tawe ait yhau yroon snok mam ti ro Jõ tama u to, bo ro nyõ nsya nhar meto fee. He bo ro nyõ nno to, nyõ kro Jõ sai!” ");
INSERT INTO ayz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tibyo kuber weto taro mabah bokyas mawe kuber retait meen yhai fee. Ebokfi Yesus yawe feto fee. Ait yawe, “Soh Jõ ksoh tawe ait yhau yaam mamo snok mam ati ro Jõ thah tama u to, bo ro nyõ nsya nhar meto fee.” ");
INSERT INTO ayz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jõ oh mi kuber retait. Tmat bo ro Yesus yno weto tna tkom fo. Tna anu bhar bwe bawya ro jõ tkyas to beta mabo tu oh. ");
INSERT INTO ayz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bo ro Yesus yno taro to mawat fares, raa mkom beta fee. Mfi bo raa mkom beta beryum to, aam ro raa mkom weto to mninon. Tnaut tawe kbe yuk ro raa mse bokom reto mam tabam refo to mnan fee.");
INSERT INTO ayz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilus; tkom aam ro ewok refo tiim kʼnyõ. Tiwya tkom aam ro tinyi to, tkyas bombra ro tii Yesus yno tna msya bombra ro Ait watum ye. ");
INSERT INTO ayz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Mam aam ro tinyi reto to, jõ tkom tna tkyas tawe raa sikowah Yesus tna mame Ait yajat. Tna Ait yrok yasen. Tna yhau mam tabam refo ti 40 naut. Mam wore weto to, raabis ro tiwya Ait ysok mmat Ait muhrin aro-aro ye. Tna Ait yno bo ro msai mawat afo re ana mhar kaket mawe Ait yrok yasen tu oh. Tna Ait ykyas bo kʼana. Ykyas wore wo Allah yamo Raja ybo raa mana rAit to kʼana. Tna Ait ysya Har ro Allah mbewok mbis bo kʼana ye. Aam ro tinyi reto to, tkyas wore wo Yesus yhau mam tabam refo mamo snok mam ati ro Allah tubat Ait yaut yamoʼt sawro rAit. ");
INSERT INTO ayz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yesus yaut yamo fefares to, Ait ysya raabis rAit hre sohmaam bo su. Tna Ait yawe, “Nhau mam kota ro Yerusalem. Frok nbam kota refo wia ma. Nhau ste bo ro tiwya anu Bja ranu yawe kbe yoo yee kʼanu to. Bo reto tiwya Jõ tkyas kʼanu oh: ");
INSERT INTO ayz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tiwya Yohanes yama baptis raa mkah aya sai, menohe ti baro firwas to, kbe Allah baptis anu mkah Har rAit.” ");
INSERT INTO ayz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ati sau to, raabis ro Yesus wAit hre su msya Ait mam faut ro Zaitun. Tna ana mtu kʼAit mawe, “Tuhan; mfo refo Nyõ nasen nno bangsa Israel mros u fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Menohe Yesus yawe, “Anu Bja yesait yhar bo rAit. Yno bo reto mam ayõ ro meen wono naut. Menohe Ait ykyas ayõ reto kʼanu nhar fee. ");
INSERT INTO ayz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tkyas ti ro meen Har rAit mroh mbo anu. Ati reto to, kbe Ait yoo yatak rAit yee kʼanu. Tna bo ro tiwya anu nmat Jõ tno to, kbe anu nbo nkyas mam kota ro Yerusalem tna mam provinsi ro Yudea beta. Tna kbe nkyas mam rabin ro Samaria ye tna mamo snok mam tabam arin aso wefo beta ye.” ");
INSERT INTO ayz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesus ykyas bo weto kʼana mkak. Tna fo Allah tubat Ait yaut yamoʼt sawro rAit. Tna raa ro mros mam weto sor heyut mmat Ait yaut yamo. Tna ayoh mboh burut Ait wa tibyo ana mahni Ait. ");
INSERT INTO ayz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ana mhau mrom Ait yaut kri-kri fo, malaikat mabo ewok ro myum ratan mboh toni frok tubor. ");
INSERT INTO ayz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Malaikat mbewok mawe kʼana mawe, “Anu raa ro Galilea: Anu nros heyut nmat bawya meto? Yesus yaut yamoʼt sawro rAit. Tna meen Ait hah ye yama u. Meen Ait hah ye yama u mnan bo riwai anu nmat Ait yaut yamo feto.” ");
INSERT INTO ayz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kuber wAit mbam Faut ro Zaitun me mhah me mamoʼt Yerusalem. Mbam Zaitun mamoʼt Yerusalem to kilo sau bo feto. ");
INSERT INTO ayz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tna ana me mamoʼt amah ro ja ana mhau. Maut mamoʼt amah hawar ro uu. Ana weto to: Petrus ysya Yohanes, Yakobus ysya Andreas, Filipus ysya Tomas, Bartolomeus ysya Matius, tna Yakobus ro bi Alfeus yare ysya Simon (Simon tait ja knait raa ro Roma mbo raa ro Israel ma.) tna Yudas ro Yakobus yare, ");
INSERT INTO ayz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","fai Maria ro Yesus yme, Yesus yao na msya fnya baro ye. Ana beta to mhaf rana sau tna ana ja hre su skabuk yoyo. ");
INSERT INTO ayz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ati sau reto to, raa wana mabo 120 bo feto mama siret su msya ana. Tna Petrus yasen yros ykyas bo kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Raa wamu: Bo ro tiwya Allah yawe to, mhau rau oh. Tiwya Har rAit sobu raja Daud. Bokyas reto ait ykom mam aam ro Mazmur. Ykom yawe, ‘Ait yerif iso ro raa kbe mama mfot Yesus.’ Daud ykom bo reto tiwya ooh oh. ");
INSERT INTO ayz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tna anu nhar nwe Yudas tiwya ysya amu yamo raabis ro Yesus wAit ye. Yesus ysok ait tna yno bo ro Yesus ybis ysya amu wefo ye. ");
INSERT INTO ayz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Menohe Yudas yno bo ro mkair. ⌞Ait yasim Yesus.⌟ Mkah pitis ro raa maren ait to, Yudas yoo tabam. Tna ait btek yhaf mamo siya tna yhaf ntaba mfais yajat mam tabam reto. ");
INSERT INTO ayz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tna raa ro mhau mam Yerusalem beta to, mhar bo reto. Tibyo ana mkyas tabam reto to, mawe masom HakalDama.(‘HakalDama’ to, mai ranu mawe, ‘Tabam ro Mees’). ");
INSERT INTO ayz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Watum ro Allah tiwya Daud ykom mam aam ro Mazmur reto mawe, ‘Tabam ro yhau to, makus oh. Tna raa me mhau mam tabam reto u ma.’ Mazmur 69:26 ‘Hroh ro tiwya ait hre reto to, raa roto me shauk hre riryõn.’” ");
INSERT INTO ayz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Tna Petrus ykyas yawe, “Mamyot bokom reto tawe nma, anu bsok raa sait hre mam hroh ro Yudas. Anu bsok raa ro yhau ysya anu su mam wore wo tiwya Tuhan Yesus yhau su ysya anu fares to: ");
INSERT INTO ayz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Raa ro yhau ysya anu maban ati ro Yohanes baptis raa, mamo snok mam ati ro Yesus yaut yamoʼt sawro rAit sikba anu beta to. Kbe ait retait kro anu tna bkyas bo ro anu bmat: Bkyas bwe Yesus yrok yasen.” ");
INSERT INTO ayz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tna ana beta msok raa mabo ewok. Raa mabo ewok reto, sait yasom Yusuf (ja raa mawe yasom Barsabas ye tna yasom Yustus ye), tna msok ait sait yasom Matias. ");
INSERT INTO ayz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tna ana skabuk mayoh Tuhan mawe, “Tuhan; Nyõ nhar raa mhaf wana beta. Nerif kʼamu awya ro Nyõ ksoh nsok. ");
INSERT INTO ayz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Raa retait shauk hroh ro Yudas yamo raabis aNyõ. Kbe yno bo woNyõ ro nbis. Yudas btek tna sikba hroh reto. Yamo ykair, btek kayah.” ");
INSERT INTO ayz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tna ana hre tane, he maut Matias. Tibyo ait kro raabis ro Yesus tna ana beta mabo 12. ");
INSERT INTO ayz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mabu ro Pentakosta to, raa ro smot Yesus beta siret mam yuk sau. ");
INSERT INTO ayz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tna ana ro hre mam amah mato reto beta mari bo ro hmu sau. Hmu mfi foos ro msai toni mbam ayoh mama. ");
INSERT INTO ayz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tna ana mmat mfi bo tafoh mait feto. Tna tafoh reto mbet raa mana abyõ beta. ");
INSERT INTO ayz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tna Har ro Tuhan mbo ana matak. Tibyo ana masen mkyas bo mkah mai raa roto. Mkyas mamyot bo ro Har sobu ana. ");
INSERT INTO ayz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ja raa ro agama Yahudi mawat mama makyõ korat rana reto mam kota ro Yerusalem. Tna tahun reto ye raa agama Yahudi mbam rabin roto makin mamaʼt Yerusalem ye. Ana weto to raa ro ja mur-mur skabuk Allah. ");
INSERT INTO ayz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ati ro ana mari bo ro hmu reto to, raa mhoh mama mmat. Mama mari he raa Kristen weto mkyas bo: Ana makin mari bo ro ana mkyas mkah mai wana-wana tibyo ana beta mrok. ");
INSERT INTO ayz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ana mrok ktak toni tna mawe kʼanya mawe, “Ana ro mkyas bo weu beta raa mbam provinsi ro Galilea! ");
INSERT INTO ayz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Fyi sai re ana mkyas bo mkah mai wanu beta to? ");
INSERT INTO ayz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Anu fo raa ro bbam rabin ro Partia, rabin ro Media msya rabin ro Elam ye. Tna taro to raa ro mbam rabin ro Mesopotamia, provinsi ro Yudea, provinsi ro Kapadokia, provinsi ro Pontus, rabin ro Asia, ");
INSERT INTO ayz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","rabin ro Frigia, rabin ro Pamfilia, bangsa ro Mesir msya raa ro mbam bangsa ro Libia ro kene mam kota ro Kirene ye. Tna anu taro fo nbam kota ro Roma, tna taro to nbam sato ro Kreta, nsya rabin ro Arab bo. Anu beta fo raa bbam raa mana ro Yahudi ye tna bsya raa roto ro mrok kro agama Yahudi tna sai. Anu bri raa Kristen wefo mkyas bo yase ro Allah yno mkah mai wanu ro ja bmai soo.” ");
INSERT INTO ayz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ana ktak beta. Tna ana mtu kʼanya mawe, “Bo bawya ro mefo ee?” ");
INSERT INTO ayz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Menohe ana taro sret raa Kristen weto mawe, “Ana weto mata anggur ro msu tna bisir meto!” ");
INSERT INTO ayz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tibyo Petrus yasen yros ysya raabis mabo 11 refo tna ykyas bo mkah mai ro mase kʼraa weto beta yawe, “Anu raa ro Yahudi nsya raa ro nhau mam Yerusalem sor: Nri bo ro jõ tkyas kʼanu fo, tna nhar kaket: ");
INSERT INTO ayz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Raa ro mkyas bo mkah mai raa roto wefo fo, ana bisir mfi bo anu nwe to, fee! Rabu sai fares mefo. ");
INSERT INTO ayz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Menohe bo msai ro anu bmat refo oh mi bo ro tiwya Allah ybis nabi Yoel yama ykom mam aam rait yawe, ");
INSERT INTO ayz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Meen, kene mam sboh rau to, Jõ too Har aJõ tee kʼraa beta. Feto to ku ro sme wanu msya ku ro ano wanu bo to, kbe ana makah soo woJõ mamo mkyas kʼraa. Tna ku ro tna mmat bo ro Jõ terif kʼana ye. Tna raa mabi kbe smi mmat bo ro Jõ tkait kʼana ye. ");
INSERT INTO ayz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tna mam ati reto ye, sryan woJõ ro sme msya ro ano bo to, kbe Jõ too Har aJõ tee kʼana ye. Tna kbe ana makah soo woJõ mamo mkyas kʼraa ye. ");
INSERT INTO ayz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tna kbe Jõ tno bo ro msai mam ayoh. Tno bo msai mam tabam refo ye afo re raa mmat tna mhar Jõ tatak aJõ. Meen raa mmat mees, mmat tafoh msya wasi ro maun maut ye. ");
INSERT INTO ayz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tna kbe ayõ haberek mti mamur htoh, tna kbe snyi haberek mkek mfi mees wia, tna fo ayõ ro Tuhan to mama. Ayõ reto to, ayõ ro msai toni. ");
INSERT INTO ayz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tna awya ro ksoh kro Tuhan kbe ykai riof.’” ");
INSERT INTO ayz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tna Petrus yawe, “Raa ro Israel: Nri bo ro jõ tawe fo: Nnaut oh: Yesus raa ro Nasaret tait, tii yno bo ro msai. Ait sair bo ro hnah re kbe raa mmat tna mrok ktak tna waa. Bo weto beta Ait yno re kbe anu nmat tna nhar nwe yatak rAit to mbam Allah. ");
INSERT INTO ayz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tna Allah ysan Ait kʼanu, raa ro agama Yahudi, re anu nsan Yesus kʼraa ro wase Allah. Ana weto mame Ait yajat mam ara warok. Anu nesait oh mi nsom isti reto to. Bo weto beta mamo mamyot iso ro tiwya Allah yhar tna saim wia to. ");
INSERT INTO ayz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Menohe Allah yno Yesus yrok yasen. Yesus Raa ro yatak. Ait yhai tibyo fee. Allah yno Yesus yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","⌞Mam aam ro Mazmur⌟ Daud ykom ⌞bo ro Yesus yawe kʼTuhan Allah⌟ yawe, ‘Jõ tmat Tuhan yhau kait ysya Jõ yoyo. Allah yros mam ati ro Jõ tatem ati tna yban Jõ. Feto Jõ waa bo mkair kbe raa mno mai kʼJõ to fee. ");
INSERT INTO ayz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Kbe thai to, tna Tuhan Allah beak Jõ takus mam sawro ro hai fee. Jõ fi Ait ro Allah ybis yama. Hai aJõ, kbe Ait sayõ rof makus mnis fee. Feto oh mi Jõ simaut mase. Jõ bibi Nyõ yoyo ye. ");
INSERT INTO ayz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nyõ nerif iso kʼJõ re tamo tru roon ro hame wajin. Soh thau tsya anu to, kbe Jõ simaut mase.’” ");
INSERT INTO ayz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tna Petrus ybo ykyas renti yawe, “Raa wamu: Jõ thar tawe far-far ro riwai mkyas raja Daud fee. Anu hohos ranu Daud tiwya yhai oh. Tna raa moo hai rait sama mam isra mato. Tna anu bhar isra reto mhau tno fares. ");
INSERT INTO ayz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daud tait nabi ro Allah ybis yama ykyas bo wAit. Tna Allah ykyas bo kʼait yawe, ‘Meen Jõ tsok Raa sait ybam ku renti wonyõ. Tna Raa retait kbe Jõ tse hre shauk hroh anyõ mkah bo yamo Raja.’ ");
INSERT INTO ayz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daud yhar bo ro meen Allah yno. Feto oh mi ykyas yawe, ‘Mesias meen yhai tna yrok yasen. Kbe Allah sikba Mesias yakus mam sawro ro hai fee. Tna hai rAit mhau makus mnis bo fee ye.’ ");
INSERT INTO ayz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesus oh mi Allah yno re yrok yasen to. Tna amu, raabis wait beta, tii nmat Ait mkah nsu wamu. ");
INSERT INTO ayz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Allah tubat Yesus yse hre mam hroh ro mbe. Tna Ait yoo Har rAit yse kʼYesus mnan fi tiwya Ait yawe yno. Har rAit reto oh mi Yesus yoo yse kʼamu ye. Tibyo amu nkyas Ait yasom mkah mai aro rau-rau. Bo reto anu nmat tna nri kri-kri fo. ");
INSERT INTO ayz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Daud ykom bo ro Allah yawe kʼYesus: ‘Tuhan Allah yawe kʼTuan ajõ yawe: “Nama, hre nsya Jõ mam ati ro tatem ati; hroh ro mase reto. Tna raa ro byoh, raa ro srau kair kʼNyõ to, meen tno ana mbtek mam mte. Kbe nyõ naa nber ana weto. Tna Nyõ nros natak abyõ ana, nbo ana.”’ Mazmur 110:1 Anu bhar bwe Daud yesait yamoʼt sawro tna hre ysya Allah feto fee. ");
INSERT INTO ayz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Feto to tkyas kʼanu raa ro Israel beta, tawe: Nhar nwe Yesus ro anu nme yajat tait, Allah tubat Ait yse abyõ, yawe Yesus fi Tuhan. Yawe Yesus fi Mesias ye.” ");
INSERT INTO ayz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ana mari feto tna bokyas reto mroh mame kʼana mhaf. Tibyo ana mtu kʼPetrus ysya raabis (rasul) makin taro fo mawe, “Amu kbe nno bawya?” ");
INSERT INTO ayz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tna Petrus yawe kʼana yawe, “Nashana oh! Tna nbis raa baptis anu mkah Yesus yasom. Afo re Ait yyon iro wanu ye. Tna kbe Ait yoo Har ro Allah yse matam anu. ");
INSERT INTO ayz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tuhan Allah ranu kbe yoo Har ro rAit yse matam awya sai ro Ait ytu yama yo kʼAit: Yse kʼanu raa ro agama Yahudi bsya kukek wanu ye, tna msya raa roto ro wase Allah ye.” ");
INSERT INTO ayz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tna Petrus ykyas bo taro mawat ye: Ait yawe wa kʼana yawe, “Raa ro mfo wefo mhau mam tabam refo to, ja mno bo ro mkair-kar. Kbe meen Allah ymit safo kʼana. Snok nbam kʼana weto tna nmo no kʼAit re kbe nkai riof!” ");
INSERT INTO ayz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Raa ro mari bo ro Petrus ykyas tna mawe ana smot Yesus ye to, raa mabo 3000 bo feto. Ana mawe raa baptis ana. ");
INSERT INTO ayz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ana mari bo ro raabis mkyas to, mbo mno. Tna ana miranya kaket, tna makyõ Korat ro Mait Roti Su afo re ana mnaut Yesus ro yhai to. Tna ana skabuk su ye. Bo weto beta to, ana mno yoyo. ");
INSERT INTO ayz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Raabis ro Yesus mno bo ro msai. Ana mno bo ro msai tna re raa mmat tna mhar Allah yatak rAit. Tna raa beta mrok ktak tna waa Allah. ");
INSERT INTO ayz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Raa ro smot Yesus weto to, beta msuk siret su. Tna bo bawya sai ro ana mse to, bo wana su. ");
INSERT INTO ayz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ana moo bo wana masim tna moo mabyoh rau to saim kʼraa kinyah wana ro mse bo mabut. ");
INSERT INTO ayz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tna rabu ti wawa ana mhaf sau siret su mam Samu ro Allah. Ana siret makyõ Korat ro Mait Roti Su, tna mait boit su mam amah aro mamo-mamo ye. Ana simaut mase mno bo weto. Ana aro srau ewok fee. ");
INSERT INTO ayz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ana mbaut Allah yoyo. Tna raa beta ksoh ana ye. Rabu ti wawa to Allah yoo riof yee kʼraa taro u. Tibyo raa mkbair ro smot Yesus to mrok mase renti. ");
INSERT INTO ayz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ti sau fo, Petrus ysya Yohanes mbewok mamo skabuk mam Samu ro Allah. Ana mamo mam wore ayõ hawer bo feto. Ja raa ro Yahudi skabuk mam ayõ reto. ");
INSERT INTO ayz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ana mbewok mamo to, raa masom bi ro yaa mhai sait kri-kri mama ye. Ait retait yaa mhai. Yaban ykek to feto bait oh. Ti ro raa mabe ynan feto oh. Tna rabu ti wawa ja raa makah bi ait mama mse mam bohra makit Samu ro Allah reto. Ana mse ait hre mam masa ro masom 'Masa ro Moof'. Ja ait hre mam yuk reto yayoh pitis kʼraa ro mama twok mam Samu ro Allah. ");
INSERT INTO ayz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ait hre tna ymat Petrus ysya Yohanes mama twok mam bohra Samu ro Allah. Tna yayoh bo kʼana mbewok yawe, “Natmof jõ, noo pitis nee mbau a!” ");
INSERT INTO ayz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ana mbewok masu sayõ ait tna Petrus yawe kʼait yawe, “Nasu nmat amu wia!” ");
INSERT INTO ayz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tibyo ait yasu ymat ana tna ait ynaut yawe kbe ana moo pitis aro mee kʼait. ");
INSERT INTO ayz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Menohe Petrus yawe kʼait yawe, “Jõ tse pitis aro fee saut. Menohe bo ro jõ tatak tno fo, tno kʼnyo: Mkah Yesus Kristus ro Nasaret yatak rAit to, jõ tbis nyõ nasen namo oh!” ");
INSERT INTO ayz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tna Petrus ybo ait refi yatem ati ybo tubat yasen yros. Petrus yno feto si to, ait refi yaa masu mrok matak tna yaa beta mrok matak ye. ");
INSERT INTO ayz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ait yasen srot tna kro ana twok mamoʼt bohra Samu ro Allah. Ait simaut mase yamo tna tbat- tbat ybaut Allah. ");
INSERT INTO ayz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Raa beta mmat he raa retait yamo tna ybaut Allah feto. ");
INSERT INTO ayz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ana mhar mawe ait retait ro ja soo hre yayoh pitis mam 'Masa ro Moof'. Tna mrok ktak sai mawe, “Ait ro yaa mhai retait; yaa moof yasen yamo a?” ");
INSERT INTO ayz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ana mros mam Samu ro Allah amah hawar mase ro mne sau. Hawar reto masom Serambi ro Salomo. Ait ro riwai Petrus yisoh retait simaut tibyo yatem ybo Petrus ysya Yohanes matak fares fo. Tna raa beta mhoh beak-ak anya mama mo kʼana tna raa mmat bi ait bo yaa haberek moof to, ana ktak sai. ");
INSERT INTO ayz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tna Petrus ymat raa msis-sas refo tibyo yasen yawe kʼana yawe, “Raa ro Israel, anu nmat bo ro msai refo tna nrok ktak nno fyi? Anu nmat sas amu to, nrok nwe amu nkah ntak ramu oh mi nisoh ait refi re yoof yasen yamo to ma. Bo moof ro amu nno to, mno re amu ntak nisoh ait refi fo fee ye. ");
INSERT INTO ayz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Allah ro anu hohos na wanu Abraham, Ishak, ysya Yakub, ja smot to, Ait oh mi yno Yesus Sryan rAit yrok yase toni to. Yesus Ait oh mi tiwya anu nsan kʼPilatus. Tna Pilatus yawe bitsre Ait he mfe, anu nwe, ‘Bitsre Ait ma!’ ");
INSERT INTO ayz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesus, Ait yama yno bo ro Allah ybis sai, Ait yato mboh sai, menohe anu hawe Ait. Tna anu nyoh kʼPilatus nwe bitsre Barabas ro ja yame ajat riryõn kʼanu. ");
INSERT INTO ayz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tna Yesus oh mi sair iso ro raa mhau mae tinyi tait. Anu nme Ait yajat oh. Ait yajat menohe Allah yno Ait yrok yasen yaam u. Tna amu oh mi nsu nmat bo weto beta to. ");
INSERT INTO ayz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Anu beta nhar ait ro yaa mhai. Yesus yatak rAit oh mi mno ait refi yaa rait matak to. Amu smot Yesus. Amu nhar nwe Ait yasom rAit to matak toni. Tna bosmot reto oh mi misoh ait yaa moof matak. Anu nsu wanu beta nmat fo. ");
INSERT INTO ayz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Raa wamu; tiwya anu nsya raa mabi wanu wase nwe Yesus tait Mesias fee. Tna anu nme Ait yajat. Anu wase oh mi anu nno bo ro mkair reto. ");
INSERT INTO ayz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tna Allah sayõ anu nno feto rof. Yawe bo reto mabo mamo mnan si bokyas ro tiwya Ait ybis nabi wAit mama mkyas wia. Tiwya ana mawe, ‘Mesias tait meen ykai bo ro samyoh mai kʼAit wia tu.’ Mazmur 2:1-2, 22:1; Yesaya 53:7-8 Bo reto mabo rau oh mefo. ");
INSERT INTO ayz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nri beta! Tna nashana oh! Tna haberek ne nma no kʼAllah, afo re kbe Ait yyon iro wanu. ");
INSERT INTO ayz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tna Ait yno re anu nhaf simaut. Meen Tuhan Allah ybis Yesus hah yama u. Tiwya Ait ysok Yesus Kristus yamo Mesias ranu. ");
INSERT INTO ayz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mfo refo Yesus yhau mam sawro ro Allah wea. Ait yhau mam beto mamo snok oon ro tiwya Allah yawe. Tna ati reto to, meen Ait yisoh bombra beta mam arin aso mrok moof wea. Tiwya Allah ybis nabi na wAit mamo mkyas bo rAit. Ait ybis ana mkyas bo reto matim wia oh. ");
INSERT INTO ayz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tiwya Allah ybis nabi Musa yama ykyas yawe, ‘Tuhan Allah meen teta Nabi sait ybam raa wamu wefo yfi jõ. Tna bo ro Nabi retait yawe kʼanu beta to, nri kaket! ");
INSERT INTO ayz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tna raa ro hawe bokyas rAit to, kbe Allah tufrok ana mbam kʼraa wAit mamo mhau mne.’ ");
INSERT INTO ayz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nabi beta sor tiwya mkyas oon ro meen mama reto ye. Nabi Samuel ye, tna ysya nabi taro sor ro mrof ait to ye. Ana mkyas bo ro meen mabo mam wore weto to, mkyas matim wia. ");
INSERT INTO ayz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tna anu oh mi ku renti ro nabi na weto to. Bo ro Allah ysi kʼana yawe meen yno to, ykyas kʼanu ye. Nnaut bo ro tiwya Allah ysi kʼAbraham yawe fefo: ‘Ku renti wonyõ meen sait oh mi yno re Allah yno bo ro moof kʼraa ro tabam refo beta.’ ");
INSERT INTO ayz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tna au oh mi Allah ybis Yesus, Sryan rAit, yama yo kʼanu raa ro Yahudi wia, afo re Ait yno bo ro moof kʼanu. Bo moof ro Ait yno to oh mefo: Ait yno re anu sait-sait haberek kro Ait tna ne nmo iso ro mkair u fee.” ");
INSERT INTO ayz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrus ysya Yohanes mbewok mkyas bo kri-kri msya raa msis-sas weto fares. Tna raa mabi ro agama Yahudi baro mama mo kʼana mbewok. Ana ro mama to, imam ro Yahudi baro ye, raa ro Saduki baro msya aban mana raa sbe ro ja kmot Samu ro Allah ye. ");
INSERT INTO ayz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ana mbewok mkyas bo kʼraa weto mawe, “Yesus yrok yasen oh. Feto to, kbe raa ro mhai meen mrok masen maam u ye.” Raa mabi ro Yahudi weto mari bo ro ana mkyas reto. Tibyo mrok kmo ana mbewok. ");
INSERT INTO ayz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tibyo ana mfot ana mbewok tna makah mamo mbu mam bui mato. Menohe arin fo mti oh. Tibyo ana mbewok mhau mam bui mato reto snok mam ayõ ro menrabu. ");
INSERT INTO ayz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Raa makin ro riwai mari bo ro ana mbewok mkyas weto to, mawat mama smot Yesus. Ana weto msya raa ro smot Ait wia to, raa sme beta mabo trion 5000 bo feto. (Fnya msya kukek wana raa ntuu fee.) ");
INSERT INTO ayz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Rabu fo, raa manes ro agama Yahudi mama siret su mam Yerusalem: Raa mabi, msya guru agama ye hre siret beta. ");
INSERT INTO ayz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bi Hanas ro yamo imam yase, bi Kayafas, bi Yohanes ysya bi Aleksander tna msya raa ro mbam raa mana ro ja mamo imam mase wana to, ana beta mama siret ye. ");
INSERT INTO ayz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tna raa makah Petrus ysya Yohanes mamo mse mros susai mam wore ana siret fo, tna ana mtu bo kʼana mbewok mawe, “Iis anu mbewok nisoh raa retait mkah awya yasom? Iis anu nisoh ait mkah awya yatak rait?” ");
INSERT INTO ayz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tna Har ro Tuhan matam Petrus matak, tibyo ait yawe kʼraa weto yawe, “Anu raa manes ro Yahudi nsya raa mabi sor: ");
INSERT INTO ayz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mfo anu ntu srah refo kʼamu nri. Safo ro anu ntu oh mi amu mbewok nno bo moof kʼait ro kiyam sait to a? Tna anu ntu kʼamu nwe fyi oh mi amu nisoh raa retait re yoof to. ");
INSERT INTO ayz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Amu nkyas kʼanu beta nsya raa ro Israel beta ye afo re anu nhar bo refo kaket: Taa ait retait yaa mhai menohe mkah Yesus Kristus ro ybam Nasaret yatak rait oh mi amu nisoh raa retait. Yesus tait anu nme yajat tna Allah yno Ait yrok yasen. Ait retait oh mi yno re raa retait yrok yoof tna yros re anu nsu nmat beta to. ");
INSERT INTO ayz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bokom ro Allah mkyas Yesus mawe, ‘Raa sgi samu sau mkah fraa. Ana moo fraa sau sanet. He mfe, ana hawe fraa reto tibyo mawah beak makus to. Menohe fraa reto mrok mamo fraa ro moof.’ Mazmur 118:22 Yesus tait yfi fraa reto. Tna anu fo nikyak Ait wia tinyi nfi raa ro sgi samu reto. ");
INSERT INTO ayz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ait yesait aran yatak yoo riof ro mase yee kʼraa. Raa roto fee. Mam tabam refo fo, Allah yno Yesus yesait aran yatak yoo riof yee kʼraa.” ");
INSERT INTO ayz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tna raa ro siret weto mhar mawe ana mbewok to, raa ro tiwya mkom bo mam sekolah tinggi to fee. Tibyo ana mrok ktak sai mmat bo Petrus ysya Yohanes matak mros mkyas to. Ana mhar mawe ana mbewok to tiwya msya Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tna ana mmat bi ait ro iis Allah yisoh ye. Mmat ait retait yros yatak mam beto ysya ana ye. Tibyo ana mastako ana mbewok fee. Ana shait sai. ");
INSERT INTO ayz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Feto to ana mbis ana mbewok frok mbam siret reto wia, tna ana saim bo kʼanya mawe, ");
INSERT INTO ayz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Raa ro Yerusalem beta mhar mawe ana mno bo ro msai. Kbe anu btak bwaar bo reto fee ye. Feto to kbe anu bno bawya kʼana mbewok refo u? ");
INSERT INTO ayz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Anu hawe raa mabah msas bo refo be kbe raa beta mari. Feto to nma, anu bwe wa kʼana mbewok. Bwe ana mkyas bo mam Yesus yasom u ma.” ");
INSERT INTO ayz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tna fo raa manes weto mtu Petrus ysya Yohanes me mama twok u. Tna ana mawe wa kʼana mbewok mawe, “Ne nkyas Yesus yasom u kʼraa ma ee!” ");
INSERT INTO ayz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Menohe Petrus ysya Yohanes mbewok mawe si kʼana mawe, “Anu nesait nnaut nwe fyi? Ja Allah ksoh yawe amu mbewok nri bo ro awya yawe? Anu beta fe bo ro Allah yawe a? ");
INSERT INTO ayz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nko hawe sai amu bewok nkyas Yesus yasom renti. Bo ro amu nsu nmat msya bo ro amu nri oh to, kbe amu nbo nkyas yum!” ");
INSERT INTO ayz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Ana ro mtu srah weto mkai safo makan aro fee. Tna ana mhar mawe ait ro Yesus yisoh retait, umur 40 tahun bo feto. Raa makin mmat bo msai reto tna bibi Allah. Feto to raa manes weto waa mawe raa makin kbe kmo ana ye. Tibyo ana mawe wa kʼPetrus ysya Yohanes matak u ye. Tna fo bitsre ana mbewok mamo. ");
INSERT INTO ayz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Raa manes ro Yahudi bitsre Petrus ysya Yohanes. Tna ana mamo mo kʼmafoh na wana ro smot Yesus. Tna bo ro riwai imam manes msya raa mabi ro Yahudi mkyas kʼana to, ana mbewok mkyas beta. ");
INSERT INTO ayz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ana mafoh na wefo mari feto, tibyo ana skabuk mawe kʼAllah mawe, “Tuhan; Nyõ oh mi nfen ayoh, tabam, aya sawan msya bombra beta ye. ");
INSERT INTO ayz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Amu nnaut bi Daud, hohos ramu. Ait yamo sryan aNyõ. Tna ait ykyas yawe, ‘Raa mana makin mrok minin mno fyi? Tna ana hre saim bo mati sai mno fyi! Raja makin ro tabam refo siwyan mame anya oh. Tna raa manes sor berur mhau mam wo sau mno bo ro mkair mai kʼTuhan Allah ysya Mesias rAit ye.’ Mazmur 2:1-2 Bo ro tiwya Daud ykyas reto to, bokyas aNyõ. Bokyas ro Nyõ nkyas kʼait nkah Har aNyõ. ");
INSERT INTO ayz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tuhan: bo ro tiwya Nyõ nbis Daud ykom reto to, mabo oh. Bo reto oh mi Raja Herodes ysya gubernur Pontius Pilatus siret su msya raa mana ro Israel ye tna msya raa mana roto makin ye to. Ana siret su mam kota refo saim bo mawe mame Yesus yajat. Yesus tait sryan aNyõ ro Nyõ nesait nbis yama. Ait tait, Nyõ nbis yamo Mesias. ");
INSERT INTO ayz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Amu nhar nwe bo ro ana mno reto to, Nyõ nesait saim mamyot Nyõ natak anyõ msya ksoh aNyõ matim wia oh. Tna ana mame Yesus yajat. ");
INSERT INTO ayz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tuhan: Mfo wefo raa mabi ro Yahudi mawe kbe ana mno bo mkair-kar mai kʼamu ye. Feto to amu nma no kʼNyõ soh-soh nwe noo natak aNyõ nee kʼamu afo re amu nros ntak bito nkyas bokyas aNyõ. ");
INSERT INTO ayz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tna nisoh raa ro kiyam mrok moof. Nno bo ro msai, sair bo ro hnah re kbe raa makin mmat tna mhar natak aNyõ. Tna mhar mawe Yesus, sryan aNyõ ro Nyõ nesait nbis yama tait, yoo yatak rAit yee kʼamu afo re amu nno bo ro msai weto.” ");
INSERT INTO ayz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ana skabuk mkak si to, amah ro ana skabuk reto mrok mnah-nah. Tna Har ro Tuhan mbo ana matak beta, tibyo ana matak mkyas Watum ro Allah. Waa fee. ");
INSERT INTO ayz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mam wore weto to, raa makin ro smot Yesus weto to, ana mhaf sau. Tna bombra ro ana aro mse to, ana mawe bo rana mesait kar fee. Ana mawe bo wana beta. Tibyo raa aro mse bo mabut fee. Ana ro mse bo mnan to, mabe bo wana weto fee. Moo mee sai. ");
INSERT INTO ayz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tna Allah yoo yatak ro mase yee kʼraabis (rasul) wAit. Tibyo ana ja mkyas Yesus yasom kʼraa, mawe Allah yno Yesus yrok yasen yaam u. Tna Allah yoo bouum mawat yee re ana beta mhau matak mno bo wAit ye. ");
INSERT INTO ayz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ana aro mbo amah, tna aro mbo tabam. Ti aro-aro soh ana mmat raa Kristen taro mhau matem marak to, ana masen masim bo wana. Masim bo tna moo mabyoh rau to, mbo mama mee kʼraabis ro Yesus. Tna raabis weto saim kʼana ro ja mhau matem marak. Feto kbe bo wana mabut fee. Ana aro bo mhau matem marak u fee. ");
INSERT INTO ayz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ana sait yasom Yusuf. Ait ja raabis mtu yasom Barnabas ye. (Mam mai ramu to, mawe ‘raa ro ja ykyas bo moof re kbe raa sorni sraujin rana’). Ait to raa mana ro Lewi ybam sato ro Siprus. ");
INSERT INTO ayz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ait yasim armato rait tna yoo mabyoh rau to, yama ysan kʼraabis weto mbo tna saim kʼraa kinyah wana ye. ");
INSERT INTO ayz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ait sait yasom Ananias tna yfain masom Safira. Ana mbewok masim tabam wana baro ye. ");
INSERT INTO ayz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Menohe ait yabe mabyoh rau baro yse kʼana mesait wai. Tna yoo baro ysan kʼraabis yawe, “Mabyoh rau beta oh mefo.” Bo ro Ait yno reto to, yfain mhar ye oh. ");
INSERT INTO ayz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Menohe Petrus yawe kʼait yawe, “Kabes yabi (Iblis) mbo nyõ nhaf anyõ meto! Thar tawe nyõ nabe pitis reto jaro nse kʼnyõ. Nyõ nno safo meto! Sioh Har ro Tuhan to ma! ");
INSERT INTO ayz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ati ro nyõ nasim tabam reto fefares to, tabam reto tabam anyõ. Tna ati ro nyõ nasim to, pitis reto mhau kʼnyõ beta ye. Soh riwai nyõ ksoh nabe pitis beta mhau to, reto safo aro fee. Menohe nyõ sioh Allah oh meto! Nyõ sioh raa meto fee!” ");
INSERT INTO ayz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias yari feto tibyo yatu btek yai mam tabam yajat. Tna raa ro mari bo reto beta to, mrok waa toni. ");
INSERT INTO ayz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tibyo ku sme ro mere baro mama sro ajat refo, tna ana teta masom mamo sama. ");
INSERT INTO ayz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ayõ tuuf bo feto firwas, tna Ananias yfain mama twok. Au wase bo ro mai kʼau maa Ananias to, fefares ye. ");
INSERT INTO ayz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tna Petrus ytu kʼau yawe, “Sik ma nawe abyõ kʼjõ: Tabam ro anu nsim reto to, mabyoh rau beta oh mefo a?” Tna au mawe, “Ae, pitis beta oh meto.” ");
INSERT INTO ayz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Menohe Petrus yawe, “Anu mbewok saim kʼanya nwe sanet Har ro Tuhan meto a? Nmat mere ro mama fo. Riwai ana sama hai ro naa. Ana kbe teta hai anyõ makah mamo sama naut.” ");
INSERT INTO ayz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tibyo fai au matu mai mam tabam majat ye, kene kait mam wore Petrus yros to. Tna mere weto twok mmat he fai au majat. Tna ana teta ajat reto masom frok mamo sama ye mam ati ro kene maa yajoh jaro. ");
INSERT INTO ayz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tibyo raa mana ro smot Yesus msya raa roto ro mari bo reto to, mrok waa beta ye. ");
INSERT INTO ayz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tna raabis ro Yesus mno bo msai, tna sair bo hnah mawat ye afo re raa makin mmat tna mhar Allah yatak rAit. Tna raa ro smot Yesus to, mhaf sau. Ana beta ja mama siret su mam 'Serambi ro Salomo'. ");
INSERT INTO ayz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Raa roto taro waa mama berur su msya raa ro smot Yesus weto. Menohe raa ksoh ana ro smot Yesus weto tna mawe ana ja mno bo moof toni. ");
INSERT INTO ayz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tna rabu ti wawa raa msis-sas mama smot Tuhan Yesus tna mama kro ana miranya su ye. Ana ro mama weto to, raa sme taro tna msya fnya taro ye. ");
INSERT INTO ayz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Raa mmat raabis mno bo msai. Tibyo makah raa ro kiyam sor frok mama mse mam iso mabi. Ana taro raa mse mjin abyõ mam ambar tna taro mse mjin mam aam wana ye. Ana mno feto afo re soh Petrus yama frit iti to, yawyan mai ana tna kbe mno ana mrok moof ye. ");
INSERT INTO ayz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tna raa mbam remo ro mhau kene mam kota ro Yerusalem sor to, mama ye. Ana makah raa ro kiyam msya raa ro kabes mbo ye mama. Tna Allah yisoh ana mrok moof beta. ");
INSERT INTO ayz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Menohe imam agama Yahudi ro yase ysya raa wait ro Saduki mmat bo ro kuber ro Yesus wAit mno. Tna ana mrok mhaf kair toni. ");
INSERT INTO ayz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tna ana mbis raa mamo mfot raabis ro Yesus mbu mam bui. ");
INSERT INTO ayz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Menohe mti rau to malaikatTuhan sau mama mitrah masa ro bui reto sor tna tusnok ana frok. Tna malaikat reto mawe kʼana mawe, ");
INSERT INTO ayz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nmo nros mam Samu ro Allah tna nkyas bokyas ro mroon refo beta.” ");
INSERT INTO ayz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ana mari feto, tibyo rabu momo fo, ana mamo twok mam Samu ro Allah. Tna masen mkyas watum ro Yesus reto. Mam ati reto ye imam ro yase ysya raa wait hre mkyas bo ro iis. Tna ana mtu raa manes ro ja mtu safo raa ro Yahudi sor to, mawe mama siret su. Raa manes ro Israel beta hre su. Tna fo ana mbis raa mamo tufrok raabis ro Yesus mbam bui makah mama. ");
INSERT INTO ayz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tna raa weto mamoʼt bui. Mamo tna mmat he raabis weto marak. Tibyo raa weto me hah mamo mkyas kʼraa ro siret wea weto mawe, ");
INSERT INTO ayz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Amu nmoʼt bui, tna nmat mato matak wa fares tna raa ro kmot bui mros kmot sai fares. Menohe amu nitrah masa reto to, amu nkai raa sait bo yhau mam bui mato reto fee!” ");
INSERT INTO ayz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aban mana raa sbe ro ja kmot Samu ro Allah tait ysya imam manes mari bo ro raa mkyas feto. Mari tna ana mrok miskawowo. Tna mawe kʼanya mawe, “Bo bawya ro mabo mefo? Kbe meen sboh rau to fyi?” ");
INSERT INTO ayz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tna fo raa sait yama yo kʼraa manes ro Yahudi weto tna yawe, “Raa ro iis anu nfot nbu to, ana mros mkyas bo mam Samu ro Allah mno.” ");
INSERT INTO ayz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tibyo ait yabi ro ybo raa sbe ro ja kmot Samu ro Allah ysya aban mana wait mamo mbo raabis ro Yesus weto makah mama. Ana mbo raabis weto to, mno bo ma fee, ana waa bo kbe raa msis-sas refo mrok kmo mawah fraa mai ana majat. ");
INSERT INTO ayz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Raa sbe mbo raabis wefo makah mama mse mros mam wore ana ro ja mtu safo raa ro Yahudi to, hre siret wea. Tna imam rana ro yase ytu bo kʼraabis ro Yesus yawe, ");
INSERT INTO ayz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tiwya amu nwe wa anu nwe anu nkyas Yesus yatak rait u ma. Menohe anu nri fee sai, tibyo beroh nmo nkyas Yesus yasom kʼraa ro Yerusalem beta mari oh! Tna anu nkyas kʼraa nwe amu oh mi nsom mees ro Yesus rAit to.” ");
INSERT INTO ayz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Menohe Petrus ysya raabis makin taro fo mawe, “Amu nri bo ro Allah yawe tu oh. Soh raa mawe bo roto hayah to, amu nri ana to fee. ");
INSERT INTO ayz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Anu nme Yesus mam ara warok yajat. Tna Allah ro anu hohos na smot tait, yno ait yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ait oh mi Allah yse hre mam hroh ro mbe re yamo aban mana ro yoo riof ro mase yee kʼraa to. Yno feto afo re raa ro Israel mashana tna Ait yyon iro wana. ");
INSERT INTO ayz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amu nsya Har ro Tuhan ye oh mi nsu nmat bo weto beta. Allah ysan Har rAit kʼraa ro mari bo ro Ait yawe.” ");
INSERT INTO ayz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bo ro raabis weto mkyas to, mame kʼana mhaf tibyo ana kmo tna mnaut mawe mfot raabis wefo mame majat to. ");
INSERT INTO ayz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Menohe raa ro Farisi sait yasom Gamaliel yasen yros. Bi ait tait guru agama ro Yahudi. Tna ja raa makin mari bo ro ait yawe. Ait yasen yros tna ybis raa tufrok raabis weto mamoʼt mne rere wia. ");
INSERT INTO ayz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ana frok mamo wia tna fo ait yawe, “Raa wojõ: Nnaut kaket bo ro kbe anu nno kʼraa weu. ");
INSERT INTO ayz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Raa wefo mno bo mnan si mfi bo ro bi ait sait yasom Teudas tiwya yno. Teudas tait frok yama tna yawe ait raa ro yase. Tna raa mabo trion 400 mari kro ait ye. Menohe ait raa mfot mame tna fo raa ro ja kro ait weto mso-sa ha-hayah ye. Tis rau to, bo ro ait ykyas to, mabo fee. ");
INSERT INTO ayz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Teudas mkak tna fo mam ati ro Raja Kaisar yawe ntuu raa makin wait to, raa sait naut yasom Yudas frok ye. Ait retait ybam provinsi ro Galilea. Ait hawe bo raja Kaisar ybo rabin refo tna raa msis-sas mari kro ait ye. Menohe ait raa mame, tibyo raa ro kro ait weto mso-sa ha-hayah ye. ");
INSERT INTO ayz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Feto to jõ tawe kʼanu tawe, nme raa ro kro Yesus wefo majat ma. Anu kbe bhau bmat rof bo ro ana mno sai. Soh bo reto mbam kʼraa to, kbe mso-sa sai akus. ");
INSERT INTO ayz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Soh bo reto mbam kʼAllah to, kbe anu btai bno wa bo ro ana mno bo fee saut, tna kbe anu bfa bsya Allah yesait sai oh meto.” ");
INSERT INTO ayz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Raa weto srau sau mari bokyas reto. Tna ana mtu raabis weto twok. Tna ana mbis raa moo too mok-mak ana. Tna mawe wa kʼana mawe, “Nkyas Yesus yasom u to ma ee!” Tna raa manes ro Yahudi weto mitsre raabis ro Yesus frok mamo. ");
INSERT INTO ayz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Raabis weto sikba amah reto frok mamo mkah simaut ro mase. Ana mhar mawe bosmot wana kbe mno re ana mkai bo ro samyoh. Mawe, “Allah ymat amu yawe nhaf moof mnan si. Tibyo amu nkai bo reto.” Mnaut feto tna ana simaut mase. ");
INSERT INTO ayz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tna fo rabu ti wawa ana mamo mkyas Yesus yasom renti. Mawe, “Ait tait Mesias.” Ana mkyas Bokyas Moof (Injil) refo yoyo mam Samu ro Allah tna mam amah aro maut mroh ye. ");
INSERT INTO ayz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ti weto to raa taro mawat naut mama smot Yesus. Ana weto mbam raa mana ro Yahudi beta. Ana taro ja mkyas bo mkah mai ro Yunani, tna taro to, ja mkyas bo mkah mai ro Yahudi ye. Tna mkbair ro ja mkyas bo mkah mai ro Yunani weto mno mmai msya ana ro mkyas bo mkah mai ro Yahudi. Ana mawe, “Raa ro ja saim boit mee kʼraa soo to, ana saim mee kʼsemit wanu kaket fee.” ");
INSERT INTO ayz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Raabis mabo 12 reto mari bo raa weto mawe. Tibyo ana mtu raa jemaat beta mama hre su mkyas bo reto. Ana mawe, “Raa wamu, soh amu nesait sui saim boit nee kʼraa to, amu nrero re kbe nkyas Watum ro Allah kaket fee. Feto to mkair. ");
INSERT INTO ayz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nma, anu bsok raa wamu mabo krema tna bbis ana saim boit mee kʼsemit wanu. Kbe anu saso raa ro ja raa hartu, raa ro ja Har ro Tuhan mbo matak, tna ro mhar bo kaket ye. Anu bsok raa ro mfi feto. ");
INSERT INTO ayz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Anu bno feto afo re amu nrero mkah bo skabuk kʼAllah tna nkyas watum rAit kaket.” ");
INSERT INTO ayz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tna bo ro ana mawe reto to, raa beta ksoh. Tibyo ana msok Stefanus. Ait bosmot rait matak toni, tna Har ro Tuhan mbo ait matak ye. Tna msok Filipus, Prokhorus, Nikanor, Timon, Parmenas, msya Nikolaus ye. Nikolaus tait raa ro Antiokhia, ybam raa mana ro Yahudi fee. Menohe tiwya ait yrok kro agama Yahudi. ");
INSERT INTO ayz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Raa baro makah raa mabo krema refo makah mama mee kʼraabis (rasul) weto. Ana moo matem mtor kʼana abyõ skabuk ana, re kbe ana moo boit saim kʼraa kaket. ");
INSERT INTO ayz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tna Watum ro Allah to, syohor yoyo mamo. Tibyo rabu ti wawa raa ro mhau mam Yerusalem taro u mawat mama smot Yesus. Tna imam Yahudi mawat mama msan ana mhaf smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus tait, bouum (karunia) ro mbam kʼAllah mhau kʼait. Bi Ait ysan yatak rAit yee kʼStefanus ye. Tibyo Stefanus yno bo ro msai. Tna ysair bo ro hnah mawat ye afo re raa mmat tna mhar Allah yatak rAit. ");
INSERT INTO ayz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Stefanus ykyas Yesus yasom. Tna raa baro ro smot Yesus fee, masen besboh bo ro Stefanus yawe. (Ana to mbam samu skabuk ro Yahudi sau. Ana tiwya mamo sryan raa, tna bobot wana mitsre ana. Ana weto taro to, mbam kota ro Kirene msya raa ro mbam kota ro Aleksandria, tna taro to raa ro mbam provinsi ro Kilikia msya raa ro mbam rabin ro Asia taro ye.) ");
INSERT INTO ayz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ana weto santri bo ro Stefanus yawe. Menohe Stefanus ykyas mkah Har ro Allah matak rAu. Ait ykyas bo kaket. Tibyo ana weto mros matak santri bo msya Stefanus fee ye. ");
INSERT INTO ayz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ana mhaf kair Stefanus. Tibyo ana masen mamo wai tna msu bo kʼraa roto baro mbis ana mamo mkyas-kas Stefanus. Tna raa weto sioh mawe kʼraa makin mawe, “Amu nri Stefanus yamus Musa ysya Allah.” ");
INSERT INTO ayz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mkah iso reto ana misti re raa makin, raa mabi ro Yahudi msya guru agama Yahudi mrok kmo Stefanus. Tibyo ana mfot Stefanus makah mamo mee kʼraa manes ro mtu srah raa ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Menohe raa ro mhaf kair Stefanus mamo wai tna mbis raa masen mkyas bo sioh mawe, “Stefanus yiwana Samu ro Allah refo yoyo tna yiwana Watum ro Musa! ");
INSERT INTO ayz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Amu nri ait ykyas Yesus raa ro Nasaret. Yawe Yesus meen yama yihabah Samu ro Allah refo! Tna ait ykyas bo ro anu bno soo. Yawe Yesus ybis raa mno bo roto hayah ye. Ait ykyas Watum ro Musa kaket fee!” ");
INSERT INTO ayz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tna raa beta ro hre mam siret reto mmat Stefanus yasu rait. Mmat he yasu rait to ngkren moof, mfi malaikat masu to. ");
INSERT INTO ayz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tna imam agama Yahudi ro yase ytu kʼStefanus yawe, “Bo ro raa mkyas mai kʼnyõ wefo fo, bokyas ro ati fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tna Stefanus yawe, “Tafoh na nsya raa mabi wojõ: Nri, tkyas masmair rau mefo: Tiwya tinyi anu hohos ranu Abraham yamo yhau mam Haran fefares to, Allah ro yase toni tait yerif Ait kʼAbraham mam rabin ro Mesopotamia. ");
INSERT INTO ayz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tna Allah yawe kʼait yawe, ‘Nasen sikba rabin anyõ refo namo. Sikba raa mana wonyõ akus, tna namoʼt rabin sau ro kbe Jõ terif kʼnyõ.’ ");
INSERT INTO ayz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham yari feto, tibyo ait sikba rabin raa ro Kasdim tna yamo yhau mam remo ro Haran. Yhau tna yaja yhai. Tna fo, Allah ybis ait satoh ybam rabin reto yamoʼt rabin ro mfo anu nhau mam Kanaan refo fo. ");
INSERT INTO ayz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mam wore weto to, Allah ysan bo aro kʼait fee, tabam kebet baro bo fee. Tna Abraham ait yabe ku aro fefares ye, menohe Allah ysi bo kʼait yawe, ‘Meen Jõ tno rabin refo beta mhau kʼnyõ nsya ku renti wonyõ nbo ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tna meen ku renti wonyõ kbe mamo raa srim mam rabin raa roto. Tna raa ro rabin reto masen mbis ana mamo sryan wana tna mno bo ro samyoh mai kʼana ye mamo snok mam tahun trion 400. ");
INSERT INTO ayz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Raa ro mbo ku renti wonyõ weto to, kbe meen Jõ tno bo ro samyoh btek mai kʼana. Tna fo ku renti wonyõ frok mbam bangsa reto tna mama skabuk Jõ mam yuk refo.’ ");
INSERT INTO ayz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tna Allah ybis Abraham yawe, ‘Nyõ nsya raa sme wonyõ beta kbe nkom tohmi (sunat) afo re raa mhar mawe anu fo raa woJõ.’ Kejadian 21:2-4, 25:26, 29:31–30:24, 35:16-18 Abraham yabe Ishak tna ti ro krentuuf to ait ykom (sunat) Ishak. Ti baro firwas fo Ishak tait yabi tna ait yabe Yakub. Tna Yakub yabe anu hohos na wanu mabo trion 12 ro masom to. ");
INSERT INTO ayz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Tna ait sait ybam kʼana yasom Yusuf. Ait yao na mabo 11 to, mhaf kair ait. Tibyo ana moo ait masim mtai kʼraa ro Ismael. Tna raa weto moo ait makah mamoʼt rabin ro Mesir. Menohe Allah yatam ait. ");
INSERT INTO ayz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bombra ro mkair ro raa mno mai kʼait beta to, Allah yno riof kʼait. Tna Allah yno re raja Mesir ksoh ait. Ait ymat he Yusuf yhar bo kaket. Tibyo raja retait ysok Yusuf yamo gubernur ybo rabin ro Mesir msya ybo samu ro raja wait beta ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tna hai awyah frok mama mai rabin ro Mesir msya rabin ro Kanaan ye. Tibyo raa mkai bo ro samyoh toni. Tna anu hohos na, bo ro ana mait to mrok marak ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Menohe ati ro Yakub yari he Mesir to, boit gandum mhau fares to, ait ybis anu hohos na wanu masen mamoʼt Mesir. Tinyi rau ro ana mamoʼt Mesir oh meto. ");
INSERT INTO ayz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tna ana hah me mamo muhrin ewok to, Yusuf yasbrah ait kʼyao na. Tna ait yakah yao na wait weto yamo yerif kʼraja, re kbe ait yhar ana. ");
INSERT INTO ayz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tna Yusuf ybis raa mamo mtar yaja ysya raa wait mamaʼt Mesir. Tibyo raa mabo trion 75 satoh bo wana mamo mhau bana mam beto. ");
INSERT INTO ayz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakub yasen yamoʼt Mesir yhau ti baro, tna yhai mam beto. Tna anu hohos na ro masom to ana mhai mam Mesir ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tna ati ro hohos wanu frok mbam Mesir to, ana masen moo maja rana ytai mirenti mamo mse mam isra sau ro mhau mam tabam refo. Isra reto tiwya tinyi kukek ro bi Hemor ro mhau mam remo ro Sikhem to, masim kʼAbraham. ");
INSERT INTO ayz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tiwya Allah yawe kʼAbraham yawe, ‘Meen Jõ takah ku renti woNyõ frok sikba Mesir.’ Tiwya ana frok mbam Mesir fefares to, raa mana ranu mabe ku mawat hair. Tibyo ana ro Israel weto mrok msis toni. ");
INSERT INTO ayz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tna fo raja roto sait yasen ybo rabin ro Mesir reto riryõn. Raja retait wase Yusuf ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ait yasen sikowah raa mana ranu ro Israel reto. Yber kait anu hohos na tna ybis ana moo ku mees wana to, beak mne majat makus. ");
INSERT INTO ayz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti weto oh mi Musa fnya mabe ye to. Musa fnya mabe to, Allah ymat yawe Musa yoof toni tna yme mtos ait snyi tuuf mam amah ro yaja. ");
INSERT INTO ayz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Snyi tuuf weto mkak to, yme moo ait mse mam wiak maku sau yakus. Tna ku ro ano ro raja sau moo ait mtos mfi ku rau feto. ");
INSERT INTO ayz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tna Musa ykom bo mam Mesir. Yhar bo ro Mesir kaket. Tna ait yros yatak ykyas bo ye tna ait yatak yno bo ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Musa tait umur 40 tahun bo feto fo, ait yawe yamo ymat raa wait ro Israel. ");
INSERT INTO ayz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ait yamo, tna ati reto, ait ymat raa ro Mesir sait yai raa ro Israel sait. Musa ymat feto tibyo ait yban raa rait ro Israel retait tna yai ait ro Mesir retait yajat. ");
INSERT INTO ayz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa ynaut yawe, ‘Raa ro Israel ana mmat feto to, kbe mhar mawe Allah ysok jõ mkah tno riof kʼana.’ Menohe ana mhar fee. ");
INSERT INTO ayz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tna fo rabu ti ait frok yamo tna ymat he raa mana wait ro Israel mabo ewok mafa anya. Ait yawe yno re ana miranya. Ait bhah ana yawe, ‘Anu to raa mana sau sai, nfa ma!’ ");
INSERT INTO ayz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Menohe ait ro yno bo mkair kʼraa roto fi besre kʼMusa yawe, ‘Awya oh mi ysok nyõ yse nbo amu tna ntu srah ro ja amu nno fo? ");
INSERT INTO ayz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nyõ nawe name jõ mfi bo iis nyõ name raa ro Mesir sait yajat a?’ ");
INSERT INTO ayz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa yari feto tibyo waa. Tna yasen ysam yamoʼt rabin ro Midian tna yhau bait beto yfi raa srim sai. Tna ait yabe ku sme mabo ewok mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Musa yhau mam Midian tahun trion 40. Tna ait yamo kene mam atu ro Sinai. Tabam reto riamo. Yamo nkri-kri to, tna malaikat sau mbrah nenat mam tafoh ro mait mam hyoh mana sau fo. ");
INSERT INTO ayz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa ymat bo reto tibyo yrok ktak sai. Tna yamo kait ymat kaket. He Tuhan yawe kʼait yawe, ");
INSERT INTO ayz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Jõ fi Allah ro nyõ hohos na ja smot. Tiwya Abraham, Ishak, ysya Yakub ja smot Jõ ye.’ Musa yrok waa tetet tibyo ait yros ymat bo reto u fee. ");
INSERT INTO ayz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tibyo Tuhan yawe kʼait yawe, ‘Jõ tama terif Jõ kʼnyõ mam yuk refo fo tibyo yuk refo mbau. Feto to nrus sandal ro nyõ nse to. ");
INSERT INTO ayz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Jõ tmat bo samyoh ro mai kʼraa woJõ mam Mesir oh to. Jõ tari bo ro ana mawia ye. Jõ troh tama fo mkah bo too riof tee kʼana. Feto to mfo refo Jõ tbis nyõ nasen hah namoʼt Mesir.’ ");
INSERT INTO ayz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tiwya Raa ro Yahudi mikyak Musa mawe, ‘Awya oh mi ysok nyõ nbo amu tna ntu srah ro amu nno bo to?’ Menohe ait oh mi Allah ysok yamo aban mana ro yoo riof yee kʼana. Allah ybis malaikat rAit mama merif au kʼait mam hyoh mana to. ");
INSERT INTO ayz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa oh mi yakah raa ro Allah wAit snok ybam Mesir. Ait yno bo ro msai. Ait ysair bo ro hnah afo re raa mmat tibyo mhar Allah yatak rAit ye. Ait yno bo msai weto mam rabin ro Mesir, mam sawan ro masom 'Aya Mkek' tna mam tabam ro riamo wore wo ana mamo mur tahun trion 40 bo to ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa ykyas yawe kʼraa ro Israel yawe, ‘Meen Nabi sait yfi jõ, kbe Allah ysok ybam raa mana wamu tna ybis Ait yama yo kʼanu.’ ");
INSERT INTO ayz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Malaikat sau moo bokyas ro mroon to, mee kʼMusa mam atu ro Sinai. Tna Musa ykyas watum reto kʼanu hohos na mam tabam ro riamo tna ait ykom watum reto re kbe anu bmat tna bhar ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Menohe anu hohos na hawe mari bo ro ait yawe tna ana mikyak ait sai. Tna ana mnaut mam mhaf mato mawe ana hah me mamo bana Mesir u sai. ");
INSERT INTO ayz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","⌞Tna ti sau Musa yaut yamoʼt atu ro Sinai yhau baro kait tna hah ye fefares.⌟ Tna raa weto mawe kʼHarun mawe, ‘Musa ro tiwya ybo amu frok nbam Mesir tait, amu wase bo ro btek mai kʼait ye. Feto to nasen nfen dewa sau mkah bo mira iso kʼanu frok bbam tabam refo bmo. Bo weto kbe raa katar matim tna anu kro mam ttis.’ ");
INSERT INTO ayz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tibyo ana mfen dewa sau mfi sapi maku sau feto. Tna ana moo kak baro ktan mse mkah bo ro msan re kbe dewa reto mhaf moof. Ana mmat bo ro ana mesait mfen moof, tibyo ana simaut mase mbaut dewa reto ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tibyo Allah kmo tna haberek kbor rof re ana skabuk sken, snyi msya ayõ bo ye. Allah yno feto mamyot bokom ro tiwya Ait ybis nabi na mama mkom wia mawe, ‘Raa ro Israel; tiwya anu nhau mam tabam ro riamo tahun trion 40. Tna anu ktan kak nsan kʼJõ aro fee. ");
INSERT INTO ayz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Menohe anu skabuk smot bo ro anu nesait nfen sai. Tna anu sgi samu sahfra kabes Molokh tna anu bibi smot sken ro masom Refan ye. Feto to, kbe Jõ tawah anu beak, nmoʼt rabin ro Babel tino.’ ");
INSERT INTO ayz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tna Allah ybis Musa yfen Sbyah ro moof sau. Tna Allah yerif iso ro Musa yfen ye. Ja raa mmat Sbyah reto tna mhar mawe Allah yhau ysya ana. Tna Sbyah reto, anu hohos na wanu ja mitrah mbo makah mamo mam woyõ-woya sai ana mamo mam tabam ro riamo reto. ");
INSERT INTO ayz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tna anu hohos na wanu msya Yosua mbo Sbyah ro Allah reto makah mamaʼt rabin ro Kanaan refo fo ye. Ana mama twok to, Allah yatim yno raa mana makin ro ja mhau mam oo reto msam mbrir-brar mamo wia. Tna hohos wanu mbo Sbyah reto mamo mhau mam rabin reto riryõn. Tna Sbyah ro Allah reto mhau msya ana weto tahun firwas tahun mamo snok mam oon ro raja Daud ybo ana. ");
INSERT INTO ayz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tna Allah Ait yhaf ksoh Daud. Tna Daud yayoh kʼAllah yawe, ‘Nbis re jõ sgi amah sau mkah bo Nyõ nhau. Nyõ fi Allah ro tiwya Yakub smot.’ ");
INSERT INTO ayz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Menohe ku rait Salomo oh mi sgi amah ro mkah bo Allah yhau reto to. ");
INSERT INTO ayz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Menohe Allah ro yase toni tait ja yhau mam amah ro raa sgi fee. Tiwya ybis nabi rAit sait yama ykyas bo reto wia yawe, ");
INSERT INTO ayz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Jõ tbo raa beta ro mhau mam sawro aJõ msya raa ro mhau mam tabam refo beta ye. Sawro aJõ to mfi wore Jõ hre wefo tna jõ tawah taa skok mam tabam refo. Amah ro ma fyi kbe anu sgi kʼJõ thau to? Anu wefo ntai sgi samu mkah jõ tamo thau baas ye fee saut. ");
INSERT INTO ayz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Jõ tatem aJõ oh mi tno bombra wefo beta fo.’” ");
INSERT INTO ayz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tna Stefanus yawe kʼraa ro kmo ait weto yawe, “Anu nsya anu hohos na to, nnan anya sai. Anu nhaf matak tibyo hawe nri bo Har ro Tuhan mawe kʼanu. Anu nnan fi raa ro wase Allah tibyo nimara mtuk ja nri Ait fee! ");
INSERT INTO ayz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nabi na sor ro tiwya Allah ybis mama to, anu hohos na sikowah ana beta. Tna nabi weto baro mama mkyas Raa sait ro wase yber safo. Mawe kbe Ait retait yama. Menohe anu hohos na mame nabi weto majat ye. Tna fo Ait retait yesait yama. Menohe anu besruf Ait, tna nsan Ait kʼraa mame yajat to ye. Ait tait Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Watum ro malaikat mkyas kʼMusa ykom to, tiwya Musa ysan kʼanu menohe anu nri Watum reto nbo nno fee ye.” ");
INSERT INTO ayz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Raa manes ro Yahudi mari feto, tibyo ana mhaf mrok kmo toni. ");
INSERT INTO ayz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Menohe Har ro Tuhan mbo Stefanus matak. Tna ait heyut abyõ sawro ro Allah. Tna ymat bo yase ro Allah rAit. Tna ymat Yesus yros ysya Allah mam hroh ro mbe ye. ");
INSERT INTO ayz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tibyo Stefanus yawe, “Jõ tmat sawro ro Allah mato nkro, tna tmat 'Ait ro Yroh Yama Yfi Raa Sai'. Ait yros mam ati ro Allah yatem ati ye.” ");
INSERT INTO ayz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ana mari feto, tibyo kmo toni msyah tna burut wa mimara wana afo re mari bo ro ait ykyas fee. Tna ana beta masen mamo mfot Stefanus. ");
INSERT INTO ayz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mfot ait tna makah frok mamoʼt kota mne. Raa ro riwai mkyas bo mai kʼStefanus weto to, mrus ratan wana ro ja myum mne fo, mse kʼraa sait ybo kmot wea. Raa retait ait yasom Saulus. Tna ana moo fraa mai ait. ");
INSERT INTO ayz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ana mawah fraa mai Stefanus kri-kri fo, ait yawe, “Tuhan Yesus: Noo tafos ajõ!” ");
INSERT INTO ayz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tna ait sisya tmi yimna tna skabuk mkah ymai ro mase yawe, “Tuhan; noo iro refo nse kʼana masom to ma.” Ait ykyas bo weto mkak si fo tna yajat. ");
INSERT INTO ayz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Tna raa ro mhau mrat msya Allah baro mama sama hai ro Stefanus. Tna ana sraujin ait ye. Tna maban ti reto to, raa sikowah raa mana ro smot Yesus. Tibyo ana ro smot Yesus beta masen mso-sa mamoʼt remo aro-aro mam provinsi ro Yudea reto. Tna taro mamo mhau mam rabin ro Samaria ye. Raabis (rasul) ro Yesus wAit mesait aran mhau akus mam Yerusalem. Tna Saulus ait srau sau ysya ana ro mame Stefanus ye. ");
INSERT INTO ayz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tna ait tomer yno bo mkair mai kʼraa ro smot Yesus. Saulus twok mam amah aro frok-frok tna soh ykai raa ro smot Yesus aro to, ait ybis raa mfot ana weto. Ait yfot raa sme msya ro ano ye, makah mamo mbu mam bui. ");
INSERT INTO ayz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Raa ro smot Yesus frok mso-sa mamo mhau mam remo aro-aro. Mhau to, ana mkyas Bokyas Moof ro Yesus (Injil) mam woyõ-woya sai. ");
INSERT INTO ayz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ana sait ro yasom Filipus yasen yamoʼt kota sau mam rabin ro Samaria. Ait ykyas kʼraa ro mhau mam kota reto yawe, “Yesus tait oh mi Mesias.” ");
INSERT INTO ayz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Filipus ykyas Yesus yasom tna ysair bo ro hnah re kbe raa mmat tna mhar Allah yatak rAit. Raa msis-sas mari ait tna mmat bosair ro ait yno. Tibyo ana beta mari bo ro ait ykyas to, kaket ye. ");
INSERT INTO ayz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ait yikyak kabes frok mbam kʼraa mawat. Tna kabes weto frok mamo to, wohrarar mkah mai ro mase. Tna raa ro maa msya matem mhai to mawat. Filipus yisoh ana re maa, matem me moof. Tna raa ro maa maka to, ait yisoh tibyo ana mrok masen mamo ye. ");
INSERT INTO ayz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Raa ro kota reto mmat feto, tibyo mrok simaut mase toni. ");
INSERT INTO ayz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tna raa sait yasom Simon ja yno bo ro hnah mam kota reto soo oh. Tna raa ro Samaria mmat bo ro ait yno to mrok ktak sai. Tna bi ait ynaut ait yesait yawe ait tait raa ro ati toni. ");
INSERT INTO ayz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Raa kinyah msya raa ro bobot beta ja mari ait kaket tna mnaut mawe Allah yoo yatak rAit yee kʼbi ait refi. Mnaut mawe au oh mi ait yno bo ro hnah. Ja raa mtu Simon retait mawe, 'Bi Ait ro Yatak Toni'. ");
INSERT INTO ayz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Raa makin weto mmat ait yno bo ro hnah feto ti ooh-oh. Tibyo ana kro ait. ");
INSERT INTO ayz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Menohe Filipus yama ykyas Bokyas Moof ro Yesus Kristus. Ykyas raa mana ro Allah yamo Raja ybo. Raa mari mfot bo ro Filipus yawe feto tna smot Yesus. Smot Yesus tna raa baptis ana ro sme msya ro ano ye. ");
INSERT INTO ayz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tna Simon, ro ja yno bo hnah retait, yama smot Yesus ye. Tibyo raa baptis ait ye. Tna ait yhau kro Filipus yoyo. Tna Simon ymat bo Filipus yno bo ro msai mawat. Filipus ysair bo ro hnah re kbe raa mmat tibyo mhar Allah yatak rAit. Simon ymat bo weto beta tna yrok ktak sai. ");
INSERT INTO ayz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Raabis ro mhau mam Yerusalem mari bo raa ro Samaria smot bokyas ro Allah feto, tibyo ana mbis Petrus ysya Yohanes mbewok masen mamoʼt rabin reto. ");
INSERT INTO ayz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Tiwya raa makin weto raa baptis ana mkah Yesus yasom sai. Menohe Har ro Allah reto mroh matam ana fefares. Tna Petrus ysya Yohanes snok mam rabin reto to, ana mbewok skabuk re kbe Allah yoo Har rAit yee kʼana makin weto. ");
INSERT INTO ayz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ana mawah matem mse kʼraa weto, tibyo Allah yoo Har rAit yse kʼana. ");
INSERT INTO ayz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon ymat he raabis weto moo matem mtor abyõ kʼraa feto, tibyo Allah yoo Har rAit yse kʼraa weto. Simon ymat feto, tna ait yhaf myoh yawe yoo pitis yee kʼana mbewok. ");
INSERT INTO ayz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ait yayoh yawe, “Nasim tak reto kʼjõ ye, afo re awya sai ro jõ tawah tatem tse abyõ to, kbe Allah yoo Har rAit yse kʼana ye.” ");
INSERT INTO ayz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Menohe Petrus yastako Simon yawe, “Nyõ nnaut nawe Allah yatak to, ja raa moo mkah pitis a? Kbe nyõ nbo pitis wonyõ namoʼt rabin kair ro tafoh mait yoyo rno! ");
INSERT INTO ayz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nyõ srau ewok kʼAit oh meto ma! Kbe tak refo mhau msya nyõ ye fee saut. ");
INSERT INTO ayz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nashana oh! Nnaut nawe noo tak ro Allah rAit mkah pitis ma! Nyõ nno iro meto! Soh-soh Tuhan yyon iro ro nyõ nno reto. ");
INSERT INTO ayz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Thar tawe nyõ nhaf mkair toni. Kabes yabi ybo nyõ tna re ja nno iro mawat.” ");
INSERT INTO ayz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Menohe Simon yawe kʼana mbewok yawe, “Anu nesait soh-soh Tuhan afo re kbe bo ro anu nkyas kʼjõ weto to, btek mai kʼjõ ma.” ");
INSERT INTO ayz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petrus ysya Yohanes mbewok mkyas watum ro Tuhan msya bo ro tiwya ana mmat Yesus yno ye. Ana mkyas bo mkak tna fo hah me mamoʼt kota ro Yerusalem. Tna mam iso ro ana mamo to, ana mkyas Bokyas ro Moof (Injil) reto mam remo raa ro Samaria makin ro ana mamo iti to. ");
INSERT INTO ayz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tna malaikat ro Tuhan sau mbis Filipus mawe, “Nasen namo sia snok mam iso ro mroh mbam Yerusalem mamoʼt kota ro Gaza to.” Iso reto to, iso ro riamo sai. ");
INSERT INTO ayz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipus yari feto tibyo yasen yamo. Ait yamo tna ykai raa manes sait ro ybam bangsa ro Etiopia. Bi ait ja ybo pitis ro bangsa reto. Tna fai Kandake mamo ratu ro mbo bangsa ro Etiopia. Bi ait tiwya yamoʼt Yerusalem mkah bo skabuk. ");
INSERT INTO ayz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mfo refo hah ye yamoʼt Etiopia yamo. Bi ait hre mam asya rait yhoh yamo kri-kri to, ait baca aam ro tiwya Allah ybis nabi Yesaya ykom. ");
INSERT INTO ayz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tna Har ro Allah mbis Filipus mawe, “Namo oh teto, namo kene kait mam asya reto to.” ");
INSERT INTO ayz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tna Filipus yhoh yamo mam weto tna yari he bi ait baca aam ro nabi Yesaya ykom. Tibyo Filipus ytu kʼait yawe, “Nyõ nmat aam reto tna srau ye fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tna bi ait yawe, “Soh raa aro betoo bokom refo maja rau kʼjõ fee, fyi re kbe jõ thar to? Nama naut hre nsya jõ. ");
INSERT INTO ayz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bokom ro bi ait baca reto mkyas Yesus mawe, ‘Ait yfi domba ro ja raa mkuk makah mamo ktan mkah bo mabo to. Tna Ait ye yfi domba maku ro raa ktan mawyan menohe kwek fee, shait sai. Ait retait ykyas bo aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tna raa sikowah Ait mfi Ait raa kair sai. Raa mtu srah rAit to hayah sai, mfi srah ja raa mtu soo to fee. Ait yabe ku fefares to, raa mame yajat oh. Feto to raa aro bo mkyas ku renti wAit fee ye.’” ");
INSERT INTO ayz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tna bi ait retait ytu bo kʼFilipus yawe, “Bo ro nabi Yesaya ykom reto to, awya oh mi ait ykyas feto to? Nabi Yesaya ykyas ait yesait fe ykyas raa roto aro ye a?” ");
INSERT INTO ayz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tna Filipus betoo bokom ro nabi Yesaya ykom reto. Tna fo ykyas Bokyas Moof ro Yesus (Injil) kʼbi ait ye. ");
INSERT INTO ayz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ana mbewok mamo, mamo, tna snok mam aya sau. Tibyo bi ait yawe kʼFilipus yawe, “Aya saah mefo. Mfo refo nyõ baptis jõ fe mfe a?”  ");
INSERT INTO ayz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipus yawe, “Soh nyõ smot mkah nhaf anyõ kaket ee, kbe jõ baptis nyõ.” Tna bi ait yawe, “Jõ thar tawe, Yesus Kristus tait Ku ro Allah yare.” ");
INSERT INTO ayz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tibyo bi ait ro ybo pitis ro Etiopia retait yawe kʼait ro ybo asya rait reto yawe, “Nros! Jõ troh wia.” Tna Filipus ysya bi ait mbewok mroh mamo mros mam aya reto tna Filipus baptis bi refi mam aya reto. ");
INSERT INTO ayz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ana mbewok frok mbam aya maut mros mne to, Har ro Tuhan tubat Filipus makah mamo. Tna bi ait ymat Filipus u fee. Tna bi yabi refi yasen yamo renti mkah simaut ro mase. ");
INSERT INTO ayz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Har ro Tuhan makah Filipus mamoʼt remo ro Asdod. Tna ait yasen yamo renti. Yamo ykyas Bokyas Moof ro Yesus (Injil) mam remo beta ro mhau mam iso ro ait yamo iti. Tna ait snok mam kota ro Kaisarea. ");
INSERT INTO ayz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tii weto to, Saulus knait raa ro smot Tuhan Yesus. Tna ait saim bo yawe raa mame raa ro smot Yesus to majat. Tna ait yamo yo kʼimam agama Yahudi ro yase yawe, ");
INSERT INTO ayz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Taja; nkom aam baro kʼraa mabi ro Yahudi sor ro mhau mam kota ro Damsyik. Mam aam weto nkom nawe nyõ nbis jõ tama tfot raa ro kro Iso ro Tuhan Yesus to. Noo aam weto nee kʼjõ tna tamoʼt Damsyik tee aam weto kʼraa mabi mmat. Tna soh jõ tkai raa sme msya fnya ro smot Yesus sor to, kbe jõ tfot ana take takah tamoʼt Yerusalem.” ");
INSERT INTO ayz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Paulus yamoʼt Damsyik, tna wore ait yamo kene kait mam kota reto to, ait ymat bo sau mfi rir ro mrir mkek to. Bo reto mbam ayoh btek mama mame mur mam wore ait yros. ");
INSERT INTO ayz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ait yatu yai mam tabam, tna yari mai sau mawe, “Saulus; nyõ sikowah Jõ nno fyi meto?” ");
INSERT INTO ayz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Menohe Saulus ytu si yawe, “Tuhan; Nyõ fi awya metait?” Menohe Ait yawe si yawe, “Jõ fi Yesus ro ja nyõ sikowah tait. ");
INSERT INTO ayz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nasen oh! Tna namoʼt kota. Mam kota kbe raa sait ykyas bo ro tbis tawe meen nyõ nno.” ");
INSERT INTO ayz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Raa ro kro ait mamo su weto to, mrok shait bana sai. Riwai ana mari mai reto, menohe ana mmat raa ro ykyas bo reto aro fee ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulus yari mai reto tibyo yasen yros, menohe yasu mti. Tibyo ana ro kro ait mamo to, mbo yatem mamoʼt Damsyik. ");
INSERT INTO ayz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ti ro tuuf firwas to, ait ymat bo fefares ye. Ait yait bo fee ye, tna yata aya bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Raa sait ro smot Yesus yasom Ananias. Ait yhau mam kota ro Damsyik. Tna Tuhan yinyam bo kʼait mkah bosmi yawe, “Ananias!” Tna Ananias yawe, “Tuhan; jõ mefi!” ");
INSERT INTO ayz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tuhan ybis ait yawe, “Nasen namoʼt iso ro ja raa mtu masom ‘Iso ro Ntrot’ to. Tna ntu kʼraa ro mhau mam amah ro bi Yudas to, nawe nyõ saso raa sait yasom Saulus ro tiwya raa mabe mam kota ro Tarsus. Saulus tait mfo refo skabuk kri-kri meto. ");
INSERT INTO ayz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Riwai Jõ tinyam bo kʼSaulus tna ait ymat raa sait yasom Ananias twok yamaʼt amah mato reto. Tna ymat Ananias yawah yatem ytor kait abyõ afo re ait yasu mrok maah tna ymat bo ye.” ");
INSERT INTO ayz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tna Ananias yawe, “Tuhan; ait retait, tiwya jõ tari raa msis mkyas mawe ait yno bo ro mkair mai kʼraa woNyõ mam Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ait fi, Imam manes ro agama Yahudi mbis ait yamaʼt befo. Yama mkah bo yfot yake raa ro smot Nyõ beta meto.” ");
INSERT INTO ayz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Menohe Tuhan yawe, “Nasen namo no kʼait oh! Saulus tait raa ro Jõ tsok yno bo woJõ. Jõ tsok ait mkah bo ykyas Jõ tasom kʼraa mana ro Israel ye, tna kʼraa mana roto makin msya raja wana ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tna meen bo ro samyoh kbe btek mai kʼait ye. Bo weto, kbe Jõ tesait terif kʼait matim wia.” ");
INSERT INTO ayz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananias yari feto tibyo yasen yamo. Yamoʼt amah ro bi Yudas tna ykai Saulus. Tna Ananias yoo yatem ytor kʼSaulus tna yawe, “Saulus, tao ajõ; ti taa Tuhan Yesus yerif Ait kʼnyõ mam iso ro nyõ nama iti to. Ait ybis jõ tama to kʼnyõ afo re nyõ nasu mrok maah tna re Har ro Allah mama mbo nyõ matak ye.” ");
INSERT INTO ayz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananias yawe feto to, bo sau mfi syoh masin btek mbam kʼSaulus yasu. Tibyo ait yrok yasu maah. Ait yasen tna Ananias baptis ait. ");
INSERT INTO ayz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tna ait yait boit, tibyo yetsu matak u. Saulus yhau ti baro ysya raa ro smot Yesus mam kota ro Damsyik. ");
INSERT INTO ayz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tna mam weto si oh to, ait ja yamo wosa bokyas ro Yesus mam samu skabuk raa ro Yahudi sor yawe, “Yesus tait Ku ro Allah yare.” ");
INSERT INTO ayz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Raa ro mari bo ro ait ykyas to, mrok ktak beta tna mawe, “Ait refi oh mi tiwya yhau mam Yerusalem tna sikowah raa ro smot Yesus mam tno. Tna raa mawe ait yamaʼt befo mkah bo yfot raa weto yakah yamoʼt Yerusalem. Tna kbe ysan ana kʼimam manes ro Yahudi.” ");
INSERT INTO ayz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulus ykyas Yesus yasom kʼraa ro Yahudi ro mhau mam Damsyik. Ykyas kaket. Ait betoo kʼana yawe Yesus tait Mesias. Mbetoo mbe toni. Tibyo ana mrok mamboi tna ana matak msya ait santri bo fee ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ti mawat baro firwas tna raa ro Yahudi hre siret tna saim bo su mawe kbe ana mame Saulus yajat. ");
INSERT INTO ayz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Menohe Saulus yari bo ro ana saim reto. Baas mti bo to, raa ro Yahudi ste wa mam kota kitana re huwya mame ait yajat. ⌞Tiwya raa mana tembok muur kota reto mne.⌟ ");
INSERT INTO ayz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ana ro Yahudi ste wa Saulus feto, tibyo mti sau fo raa ro smot Yesus mse Saulus mam keranjang maboh sau. Tna mruk ait yroh wai mam tembok ti mne. ");
INSERT INTO ayz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ait yasen frok ybam Damsyik hah ye yamoʼt Yerusalem. Ait snok si mam Yerusalem fo, ait yawe yiranya ysya raa ro smot Yesus. He mfe. Ana waa mtu sioh kʼait mawe, “Ait refi sne mate kʼanu yawe ait smot Yesus, yawe feto to, ait sioh anu sai meto.” ");
INSERT INTO ayz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Menohe Barnabas yakah ait yamo tne kʼraabis ro Yesus tna ait ykyas kʼana yawe, “Saulus ro tiwya tinyi hawe kro Yesus tait, mfo refo haberek kro Yesus oh. Tuhan yerif Ait mam iso maka, tna ykyas bo kʼait ye. Tna fo ait yamoʼt Damsyik to. Mam Damsyik Ait yasen ykyas Yesus yasom kʼraa. Ait waa ana fee ye.” ");
INSERT INTO ayz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Feto to ana ksoh Saulus yhau mam Yerusalem ysya ana. Yhau mam Yerusalem tna ykyas Yesus yasom kaket mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ait ja santri bo ysya raa Yahudi ro ja mkyas bo mkah mai ro Yunani. Menohe ana mari Ait fee. Ana mawe mame ait yajat. ");
INSERT INTO ayz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","He mfe. Kuber ro Yesus wAit ana mari bo ro ana saim reto. Tibyo ana makah ait mamoʼt kota ro Kaisarea. Tna fo ana mbis ait yamo renti yamoʼt kota ro Tarsus. ");
INSERT INTO ayz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tna ti weto to, raa mkbair ro smot Yesus mam provinsi ro Yudea, provinsi ro Galilea msya rabin ro Samaria beta to, raa aro bo sikowah ana u fee ye. Ana bosmot wana mo matak renti. Mhau to waa Tuhan. Tna Har ro Allah mros tis ana, mban ana. Tna raa mawat ro smot Yesus fefares to, ana mama smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrus yamo yur ytan mam remo makin weto to, ait yamo sia yamo ymat raa ro Allah wAit mam remo ro Lida. ");
INSERT INTO ayz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mam beto to, ait ykai raa sait yasom Eneas. Eneas tait, yaa msya yatem bo to mhai ye, tibyo ja yakus yjin sai bait mam aam sai tahun trion krentuuf oh. ");
INSERT INTO ayz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus yawe kʼEneas yawe, “Eneas, Yesus Kristus yisoh nyõ noof oh. Nasen beah aam anyõ oh.” Petrus yawe feto, tibyo Eneas yasen buu yros. ");
INSERT INTO ayz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tna raa ro mhau mam Lida msya raa ro mhau mam Saron beta to, ana mmat Eneas yamo fo, feto tibyo mrok waa smot Tuhan Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tna fai sau ro smot Yesus mhau mam remo ro Yope. Fai au masom Tabita. (Tna mam mai ro Yunani to, raa mtu au masom Dorkas ye.) Au to ja mno bo moof tna matmof raa kinyah yoyo ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mam ati reto to, au kiyam tibyo mhai. Raa moo hai rau mse mate aya tna moo mse mam amah hawar ro uu. ");
INSERT INTO ayz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Remo ro Yope msya remo ro Lida to mhau kene sai. Tna raa mkbair ro smot Yesus tna ro mhau mam Yope mari he Petrus yhau iti mam Lida. Tibyo ana mbis raa mabo ewok masen mamo mawe kʼait mawe yama fooh. ");
INSERT INTO ayz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mamo, tna Petrus yari feto tibyo yasen kro ana mamoʼt Yope. Ait snok si fo ana makah ait mamoʼt amah hawar ro uu reto. Semit beta ro mhau mam beto to, hre mawia. Ana mama mo kʼPetrus tna merif ratan ro tiwya Dorkas mtin mee kʼana sor fo. ");
INSERT INTO ayz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus ybis ana ro mhau mam beto beta frok. Tna fo, ait yesait aran yhau mam amah hawar reto. Tna ait yaka tmi yimna mte tna skabuk. Tna ait haberek ymat hai reto tna yawe, “Tabita, nasen oh!” Tibyo au mrok mmat Petrus tna masen hre ye. ");
INSERT INTO ayz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petrus ybo au matem teta tna au masen mros. Tna fo ait ytu semit weto msya raa ro Allah wAit mama mmat fai Dorkas ro mrok masen. ");
INSERT INTO ayz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bo ro Petrus yno reto syohor mamo snok mam rabin reto beta. Raa mawat mari feto tibyo mama smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tna Petrus yhau mam Yope ti baro kait ye. Yhau mam amah ro bi Simon ro ja yfen bo ro mbam kak marak tait. ");
INSERT INTO ayz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Bi sait yhau mam kota Kaisarea to yasom Kornelius. Ait yamo aban mana ro ja ybo raa sbe majin sau. Raa sbe ro ybo weto mabo 100. Tna ana weto to raa mbam rabin ro Italia. ");
INSERT INTO ayz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornelius ja mur-mur skabuk Allah. Tna Kornelius, yfain, msya raa ro ja mhau mam amah rait to, beta waa Allah ye. Menohe ana to raa ro Yahudi fee. Ait ja yoo bo mawat yee kʼraa kinyah ro Yahudi, tna ait skabuk Allah yoyo ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Baas fares mam ayõ ro tuuf feto, ait ymat malaikat ro mbam Allah sau mama twok mam amah rait tna mawe kʼait mawe, “Kornelius fi!” ");
INSERT INTO ayz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ait ymat sas malaikat reto tna yrok waa yawe, “Tuhan; bo bawya mefo?” Tna malaikat reto mawe kʼait mawe, “Allah yari skabuk anyõ oh tna ymat bosan ro ja nyõ nsan kʼraa kinyah ye oh. Ait ymat feto mno yhaf mnan. ");
INSERT INTO ayz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nasen nbis raa baro mamo fooh mamoʼt remo Yope. Tna mmen Simon-Petrus yama. ");
INSERT INTO ayz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ait yhau mam amah ro bi Simon ro ja yisoh kak marak. Amah reto to mhau kene mam wore aya sawan maam kait.” ");
INSERT INTO ayz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tna malaikat reto sikba Kornelius mamo. Tna fo ait yasen ytu sryan wait mabo ewok msya raa sbe ro ja smot Allah kaket sait mama. Ana weto ja mhau mno bo ro Kornelius ybis sai. ");
INSERT INTO ayz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ana mama tna ait betoo bo ro ait ymat weto beta kʼana. Tna fo, ybis ana mamoʼt Yope tna mmen Petrus yama. ");
INSERT INTO ayz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Rabu ti fo ana masen mamo. Ayõ baas to ana mamo kene mam remo ro Yope. Tna mam weto to, Petrus yamo yaut abyõ mam amah tna skabuk ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Petrus yhai sre tna yawe yait boit. Boit raa siwyan kri-kri fo tna Allah yinyam bo sau kʼait. ");
INSERT INTO ayz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ait ymat ayoh mato maah, tna fo ait ymat bo sau mfi bo hawee mabuf ro maboh sau mroh mbam uu mama. Hawee reto kro mbam tuut trion jiit mroh snok mam tabam. ");
INSERT INTO ayz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ymat he binatang aro rau-rau beta mhau abyõ mam hawee reto. Binatang msya aban ro mton aro rau-rau, tna msya ruu aro rau-rau ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tna ait yari mai sau mawe, “Petrus: Nasen ktan bo weto nabo oh!” ");
INSERT INTO ayz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Menohe Petrus yisboh si yawe kʼTuhan yawe, “Mfe saut! Bo ro amu nbau weto to, ja jõ tabo bo weto mafa fee!” ");
INSERT INTO ayz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tna mai reto mkyas kʼait muhrin ro ewok mawe, “Allah yawe, ‘Mfo wefo to, tawe bo weto bo ro mbau fee. Nabo oh. Nbau bo weto u to ma.’” ");
INSERT INTO ayz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bo reto Allah yno muhrin tuuf, tna fo Allah tubat hawee ro riwai reto to, maut mamoʼt ayoh twok mamo marak. ");
INSERT INTO ayz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tna Petrus ynaut bo refo mam yhaf yawe, “Bo bawya ro jõ tmat mefo ee?” Ait ynaut feto, tna raa ro bi Kornelius ybis weto mama. Riwai ana snok mam remo ro Yope tna mtu sas amah ro bi Simon. Ana mros mam amah mato. ");
INSERT INTO ayz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tna mtu mawe, “Simon-Petrus metait a?” ");
INSERT INTO ayz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrus hre ynaut bo ro ymat fares. Tna Har ro Allah mawe kʼait mawe, “Nari, raa mabo tuuf saso nyõ mama fo. ");
INSERT INTO ayz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nasen tna nroh namoʼt te. Tna fo nsya ana nmo. Jõ oh mi tbis ana mama mmen nyõ to. Feto to namo sai.” ");
INSERT INTO ayz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tna Petrus yroh yamoʼt te tna yawe kʼana yawe, “Jõ ro anu saso oh mefi. Bo bawya ro anu nnaut nma fo?” ");
INSERT INTO ayz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tna ana mawe kʼait mawe, “Amu nma fo, bi Kornelius ybis. Ait tait aban mana raa ro sbe. Ait ja yno bo ro Allah ksoh tna smot Allah ye. Tna raa ro Yahudi beta mmat bo ro ait yno to, mawe ait tait raa ro ja yno bo moof. Iis malaikat ro Allah rAit sau mawe ait ybis amu nma nmen nyõ bmoʼt amah rait mam Kaisarea. Mawe nyõ namo no kʼait tna kbe ait yari bo ro nyõ nkyas kʼait.” ");
INSERT INTO ayz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petrus yari bo ro ana mawe feto. Tna yawe, “Nma njin nsya jõ oh mam befo. Tna menrabu rabu anu bmo.” Rabu fo, ana mabo jiit masen mamo sikba Yope tna kro iso ro mamoʼt Kaisarea. Tna raa ro Yope ro smot Yesus taro kro ana ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mam Kaisarea to, Kornelius ytu yao na msya yafoh na bo to mama hre su msya ait ste Petrus wea. Tna rabu ti fo, Petrus ysya raa wait wefo mamo snok mam Kaisarea. ");
INSERT INTO ayz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petrus yamo twok mam amah mato fo, Kornelius yama tna yaka yabum yawe hartu ait ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Menohe Petrus ymat feto ybo ait yasen tna yawe, “Nasen oh, jõ fi raa sai mefo. Tnan anya tsya nyõ sai.” ");
INSERT INTO ayz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petrus ykyas bo ysya bi ait kri-kri to, twok mam amah mato fo. Ait ymat he raa msis siret ste ait wea oh. ");
INSERT INTO ayz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tna ait yawe kʼana yawe, “Anu fo raa ro srim. Menohe anu nhar bo mafa ramu raa ro agama Yahudi to. Watum ranu mkyas mawe, ‘Anu raa ro Yahudi: Nmo niranya nsya raa mana roto ma! Tna twok mam amah wana bo to ma ye!’ Menohe taa, Allah yinyam bo kʼjõ yawe raa mana roto to, kbe mbau kʼamu, raa ro Yahudi u fee. Yawe, ‘Nnaut nwe raa mana roto to raa ro mkair ma!’ ");
INSERT INTO ayz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Feto oh mi ati ro anu ntu jõ tamaʼt befo to, jõ ksoh tama sai. Tna hawe fee. Mfo, jõ ksoh thar bo bawya ro mno re anu ntu jõ tamaʼt befo fo?” ");
INSERT INTO ayz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tna bi Kornelius yawe kʼait yawe, “Ti jiit mam wore ayõ hawer fefo fo, jõ skabuk mam amah. Jõ skabuk kri-kri fo, bi ro yyum ratan ro mboh kren toni sait yros tubor kene mam jõ tasu. ");
INSERT INTO ayz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tna yawe kʼjõ yawe, ‘Kornelius, bo ro nyõ skabuk kʼAllah to, Ait yari oh. Tna bombra ro nyõ ja nsan kʼraa kinyah to, Ait yhar oh. ");
INSERT INTO ayz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Feto to, nbis raa mamoʼt Yope mmen Simon-Petrus yama. Ait mfo yhau mam amah ro bi Simon ro ja yfen bo mkah kak marak tait. Amah reto to mhau kene mam aya sawan maam kait.’ ");
INSERT INTO ayz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jõ tari feto si to, tbis raa mamo fooh mmen nyõ tna nyõ nhaf moof kʼjõ nama fo. Tna mfo amu beta siret mam wore Allah yasu ymat refo, mkah bo nri bo ro Allah ybis nyõ nkyas kʼamu beta.” ");
INSERT INTO ayz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petrus ykyas bo kʼana yawe, “Mfo refo Jõ srau tnaut tawe Allah ysok raa mana sau yse hayah tna ysok raa mana roto taro yse hayah fee saut. Ait ymat beta yawe mnan anya sai. ");
INSERT INTO ayz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ja Ait ymat raa mana ryo sai to, awya sai ro waa Ait tna yno bo ro Ait ksoh to, Allah yoo ait yamo raa mana rAit ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bokyas riwai reto Allah ykyas kʼraa mana ro Israel: Ykyas yawe, ‘Yesus Kristus tait kbe yoo riof ro mase yee kʼraa beta.’ ");
INSERT INTO ayz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Anu nesait nhar bo beta ro tiwya mabo mam provinsi ro Yudea. Tinyi rau to, Yohanes ro ja baptis raa to, ykyas bo mam provinsi ro Galilea. ");
INSERT INTO ayz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tna fo Yesus ro ybam remo ro Nazaret yama. Allah yoo yatak yee kʼAit tna yoo Har rAit yse matam Ait ye. Allah yatam Yesus tibyo woyõ-woya sai Yesus yamo to, Ait ja yno bo moof tna raa ro kabes yabi (Iblis) ybo to Ait yisoh moof ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tna amu, raabis ro Yesus wait, nmat bo ro Ait yno beta mam kota Yerusalem msya rabin ro Yahudi to ye. Bo reto amu nbo nkyas. Tna raa mame Ait yajat mam ara warok. ");
INSERT INTO ayz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Menohe mam ti ro tuuf to Allah yno Ait yrok yasen. Tna yno re raa mmat Ait ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Raa makin beta fee. Menohe amu nmat Ait, tna amu hre niit boit nsya Ait su ye. Tiwya Allah ysok amu nesait re nmat tna nkyas Ait yasom kʼraa roto ye. ");
INSERT INTO ayz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ait ybis amu nmo nkyas Yesus yasom. Ybis amu nmo nkyas nwe, ‘Allah ysok Ait yamo Raa ro yhau susai ytu srah raa ro mhai msya raa ro mhau fares bo yari ye.’ ");
INSERT INTO ayz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tiwya nabi na beta mhaf sau mkyas Ait msya bo ro kbe Ait yno. Ana mawe awya sai ro smot Ait to, kbe Allah yyon iro wana beta ye.” ");
INSERT INTO ayz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tna Petrus ykyas bo wefo kri-kri fo, Har ro Tuhan mroh mama mbo Kornelius ysya raa wait ro mari bo ro Petrus ykyas fo beta. ");
INSERT INTO ayz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Tna ana mrok mkyas bo mkah mai roto ro ana wase fares, tna mbaut Allah ye. Tna raa ro Yahudi ro smot Yesus, ana ro riwai kro Petrus mama mbam Yope to, hre mmat. Ana ro Yahudi mmat Allah yoo Har rAit yuumto kʼraa mana roto ye to, ana mrok ktak toni. Tna Petrus yawe kʼana yawe, ");
INSERT INTO ayz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Allah yoo Har rAit yse mbo raa wefo oh. Yno mamyot mnan fi ro tiwya Ait yno kʼanu ye oh. Nma, anu baptis raa wefo mkah aya ye! Kbe raa aro mno wa fee.” ");
INSERT INTO ayz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tibyo Petrus ybis raa baptis ana mkah Yesus Kristus yasom. Tna ana mabe Petrus soh-soh ait mawe, “Nyõ namo wia ma. Nhau nsya amu ti baro wia rere!” ");
INSERT INTO ayz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tna raabis (rasul) ro Yesus msya raa ro smot Yesus mam rabin ro Yudea beta to, tiwya mbam raa mana ro Yahudi sai aran. Tna ana mari he raa mbam raa mana roto baro mama smot bokyas ro Allah ye. ");
INSERT INTO ayz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Tna Petrus yamoʼt Yerusalem. Mam beto to, raa Yahudi ro smot Yesus taro mastako ait mawe, ");
INSERT INTO ayz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Taa nyõ twok mam amah raa mana roto to, tna sohmaam bo nsya ana su ye. Feto Allah hawe!” ");
INSERT INTO ayz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Menohe Petrus betoo bo weto sau-sau kʼana kaket yawe, ");
INSERT INTO ayz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Taa jõ skabuk mam remo ro Yope kri-kri fo, Allah yinyam bo sau kʼjõ. Tna jõ tmat bo sau mfi bo hawee mabuf ro maboh sau mroh mbam uu. Hawee reto kro mbam tuut trion jiit, tna mroh snok mam tabam kene wore jõ hre. ");
INSERT INTO ayz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tna jõ thaninin, tmat he mato to matot mkah binatang ro mha, binatang ro rbyoh, aban ro mton, msya ruu ye. ");
INSERT INTO ayz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tna jõ tari mai sau mama mawe kʼjõ mawe, ‘Petrus; nasen ktan bo weto nabo oh!’ ");
INSERT INTO ayz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Menohe jõ tawe kʼTuhan tawe, ‘Mfe, bo ro amu nbau mefo, ja jõ tabo fee.’ ");
INSERT INTO ayz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Menohe tari mai ro mbam sawro reto muhrin ro ewok. Mkyas mawe, ‘Bo ro Allah yawe nyõ nabo to, ne nbau to ma!’ ");
INSERT INTO ayz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bo reto, Allah yno muhrin ro tuuf. Tna fo Allah tubat bo weto beta yakah yamoʼt ayoh twok marak. ");
INSERT INTO ayz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tna mam weto si to raa mabo tuuf snok mam amah ro amu nhau. Ana weto to, taa Kornelius ybis mbam kota ro Kaisarea yawe mama mo kʼjõ mam remo ro Yope. ");
INSERT INTO ayz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tibyo Har ro Allah mawe kʼjõ mawe, ‘Nasen nsya ana nmo su oh! Nnaut bo myum-yam ma!’ Tna raa wamu mabo ntamam refo masen kro jõ mamoʼt Kaisarea. Amu nmo twok mam amah ro bi Kornelius. ");
INSERT INTO ayz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tna ait yawe, ‘Taa malaikat sau frok tubor mam amah mato tna mkyas kʼjõ mawe jõ tbis raa mamoʼt Yope tna mmen Simon-Petrus yama. ");
INSERT INTO ayz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Malaikat reto mawe kbe amu nri bokyas ro Simon-Petrus ykyas afo re kbe Allah yoo riof ro mase yee kʼjõ tsya raa wojõ beta.’ ");
INSERT INTO ayz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tibyo jõ taban tkyas bo fo, Har ro Tuhan mroh mama mbo ana mfi bo ro tiwya tinyi rau mroh mama mbo anu wia oh mefo. ");
INSERT INTO ayz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tna jõ te tnaut bo ro tiwya Tuhan yawe, ‘Yohanes baptis raa mkah aya sai, menohe anu to, kbe Allah baptis anu mkah Har rAit.’ ");
INSERT INTO ayz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tiwya anu smot Tuhan Yesus Kristus tna Allah yoo Har rAit yee kʼanu. Tna jõ tmat tawe Allah yoo Har rAit yee kʼana ye. Ait yno mnan fi bo tiwya yno kʼanu ye to. Feto tna jõ thau sayõ bo ro Ait yno sai. Tnaut tawe jõ fi raa sei sai, kbe tno wa bo ro Allah yno reto to fee!” ");
INSERT INTO ayz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tna raa ro Yahudi mari bo ro Petrus betoo feto. Tibyo ana mastako ait u fee. Tna mbaut Allah mawe, “Allah yno iso ro moof afo re raa mbam raa mana roto mashana ye, tna meen ana mkai mamos mae ye.” ");
INSERT INTO ayz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Maban mam wore Stefanus tiwya raa mame to, raa sikowah raa ro smot Yesus. Tibyo ana msam somya mamo snok mam rabin ro Finisia, sato ro Siprus msya kota ro Antiokhia. Ana mamo to, mkyas Yesus yasom kʼraa ro Yahudi sai aran. ");
INSERT INTO ayz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Menohe ana makin ro somya weto to, ana taro raa ro mbam Siprus msya raa ro mbam kota ro Kirene. Ana weto mkyas Bokyas ro Moof (Injil) mamo snok mam kota ro Antiokhia. Tibyo mkyas Tuhan Yesus yasom kʼraa ro ja mkyas bo mkah mai ro Yunani ye. ");
INSERT INTO ayz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tna Tuhan yatam ana tibyo raa msis-sas mashana smot Ait. ");
INSERT INTO ayz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tna raa ro smot Yesus mam Yerusalem to, ana mari bo raa ro Yunani smot Yesus ye. Tibyo ana weto mbis Barnabas yasen yamoʼt Antiokhia. ");
INSERT INTO ayz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabas tait raa ro ja yno bo moof, tna Har ro Allah ja mbo ait matak. Tna bosmot rait matak ye. Barnabas yamoʼt kota ro Antiokhia. Tna ymat bo Allah yatmof raa ro rabin roto ye feto. Ait srau bo reto, tibyo yrok simaut mase. Tna ait ykyas bo moof kʼana yawe, “Nhau to, smot Tuhan kaket!” Tibyo, raa msis-sas mama smot Tuhan Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tna fo Barnabas yasen yamoʼt kota ro Tarsus saso Saulus. ");
INSERT INTO ayz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ait ykai Saulus, tna yakah ait hah yamoʼt Antiokhia. Ana mbewok mhau su msya raa ro smot Yesus mam beto to tahun sau. Ana mhau mam beto to mkyas, mbetoo bokyas ro Yesus kʼraa msis. Tna mam beto ye raa maban mtu raa ro smot Yesus weto, ja mtu mawe 'raa mana ro Kristen' to. ");
INSERT INTO ayz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ti weto to, nabi ro Allah ja ybis mkyas bo wAit to, baro mama mbam Yerusalem mamoʼt Antiokhia. ");
INSERT INTO ayz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tna nabi weto to, sait yasom Agabus. Har ro Tuhan ybis ait yasen yawe, “Meen hai sre ro msai sau btek mai rabin ro wefo beta.” (Bo ro ait yawe reto mabo mam ati ro raja Klaudius ro yase ybo rabin weto beta.) ");
INSERT INTO ayz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tna raa ro smot Yesus ro mhau mam Antiokhia to, ana mawe, “Boit wana ro mhau mam Yudea to mabut. Feto to bma, anu boo pitis wanu baro bee kʼana ro smot Yesus ro mhau mam beto.” Tibyo raa sait-sait yoo pitis rait yee mamyot bo ro ait yse. ");
INSERT INTO ayz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tna fo Barnabas ysya Saulus mbewok makah pitis weto mamo msan kʼmajelis ro mhau mam Yerusalem mkah bo ana saim kʼraa wana ro hai sre. ");
INSERT INTO ayz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mam ti weto to raja Herodes ybis raa wait mamo mfot raa ro Kristen baro afo re ait yno bo ro mkair btek mai kʼana. ");
INSERT INTO ayz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tna ait ybis raa sait yoo sogi yaru Yakobus ro Yohanes yao tait yajat. ");
INSERT INTO ayz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Raa ro Yahudi ksoh bo ro ait yno reto. Tibyo ait ybis raa mamo mfot Petrus. Yfot Petrus mam wore raa ro Yahudi makyõ Korat Roti ro Ragi Marak. ");
INSERT INTO ayz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Raa mfot Petrus tna raja Herodes ybis ana mbu ait mam bui tna ybis raa sbe mabo trion 16 kmot ait. Raja Herodes ynaut yawe kbe Raa ro Yahudi makyõ Korat ro Paskah mkak oh tna fo, ait kbe ytu srah rait mam wore raa masu makin mmat. ");
INSERT INTO ayz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Feto to Petrus, yhau mam bui fares, menohe raa ro Kristen mur-mur skabuk ait kʼAllah. ");
INSERT INTO ayz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Raa ro Yahudi makyõ Korat ro Paskah mkak. Tna Herodes yawe mhau rabu tna tufrok Petrus frok ybam bui reto. Tna mti rau fo, Petrus yjin. Raa sbe mabo ewok kmot ait. Rantai trion ewok make ait yatem tna mii kʼana matem ye. Tna Petrus yjin mam masuf. Tna raa sbe mabo ewok naut mros mam masa ro mne kmot bui reto. ");
INSERT INTO ayz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tna malaikat ro Tuhan sau frok mros tubor mam wore Petrus yjin. Tna kek sau mrok mait mram bui reto. Tna malaikat reto mti ait mawe, “Nasen fooh!” Tibyo rantai ro make ait yatem reto mrok ntras mbam ait yatem btek. ");
INSERT INTO ayz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tna malaikat reto mawe, “Noo ratan anyõ nyum tna noo sandal anyõ nse naa ye.” Petrus yari yno bo ro malaikat mawe reto. Tna fo malaikat mawe, “Noo jubah anyõ to nyum naut tna kro jõ bmo.” ");
INSERT INTO ayz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tna ait kro malaikat reto frok mamo. Mamo to mfi bo ait wase-wasa sai. Ynaut yawe yjin smi bo ymat malaikat reto. Ait wase yawe bo reto mabo tu oh, fe mfe a? ");
INSERT INTO ayz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tna ana mbewok frok miwrek raa sbe ro kmot bui reto, tna fo mamo miwrek raa sbe roto, tna ana snok mam masa besi ro muut snek reto wa. Masa reto to, mesait mato maa sai. Tna ana frok, tna mamo kro iso sau si fo, malaikat reto mrok marak sikba tubor sai mam weto. ");
INSERT INTO ayz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tna ait yrok yhar kaket yawe, “Bo refo mabo oh! Mfo refo jõ thar tawe Tuhan ybis malaikat rAit tna yno riof kʼjõ. Ait bitsre jõ tbam raja Herodes yatak rait tna mbam bo ro raa ro Yahudi saim mawe mno mai kʼjõ bo ye.” ");
INSERT INTO ayz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ait yrok srau feto tna fo, yamoʼt samu ro Maria ro Yohanes-Markus yme. Mam beto to, raa mawat siret tna hre skabuk. ");
INSERT INTO ayz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petrus yama yai masa ytu ana. Tna sryan ro ano sau masom Rode mama mros wane mari awya ro mii ytu mam ti masa meit. ");
INSERT INTO ayz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Au mari he Petrus ymai tna au simaut mase tibyo sorni mitrah masa reto kʼait. Au mamo fooh mamo mabah kʼana ro mhau mam amah mato reto mawe, “Petrus yama meit!” ");
INSERT INTO ayz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Menohe ana mawe si kʼau mawe, “Nyõ nker meto a?” Menohe au mawe, “Jõ tker fee. Bi ait yama meit!” Tibyo ana mawe, “Tna sai nyõ nmat malaikat ro ja kmot ait.” ");
INSERT INTO ayz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Menohe Petrus yros fares tna ytu u. Tna ana mitrah masa tna mmat he ait yesait yros. Tibyo mrok ktak sai. ");
INSERT INTO ayz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus yawe kʼana yawe, “Shait oh! Tuhan yakah jõ frok tbam bui reto. Jõ tkyas bo ro Tuhan yno wia. Tna fo nsen nmo nkyas bo weto kʼYakobus ysya raa wanu taro ye mari.” Ait ykyas bo weto mkak tna ymah meen kʼana akus tna frok yamoʼt yuk roto. ");
INSERT INTO ayz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Rabu fo, raa sbe wefo mrok mkyas mnin-nin mawe, “Wah, ait snok ybam woyõ? Ja weno anu ste matak to re ait frok yamo woyõ!” ");
INSERT INTO ayz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Raja Herodes yari bo reto, tibyo ybis raa sbe roto mamo saso Petrus menohe ana mkai ait fee. Tna Herodes ytu sas kʼraa sbe ro ti sai kmot Petrus weto tna ybis raa sbe roto mfot ana mame majat. Tna fo raja Herodes yasen frok ybam rabin ro Yudea yamoʼt kota ro Kaisarea tna ait yhau ti baro kait mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ti weto to raja Herodes kmo raa ro kota Tirus msya raa ro kota Sidon toni. Kota wana to ja mkai boit mbam oo ro raja retait ybo. Tna raa wana baro saim su tna mamo mkyas bo kʼait. Ana mamo tna mkai bi Blastus wia. Ait retait ja yisoh amah ro raja rait. Ana mawe kʼait mawe ana ksoh mrok miranya msya raja u. Blastus yari feto, tna yawe bo ro ana saso reto moof. Tibyo ait yamo ykyas kʼraja Herodes. ");
INSERT INTO ayz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tna Herodes ysok ti sau yse mkah ykyas bo kʼraa weto beta. Ti reto ait yyum ratan ro ja raja myum tna yaut hre mam ambar ro ja raja hre ye. Tna ykyas bo kʼana. ");
INSERT INTO ayz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ana mari bo ro yawe to, simaut mmai mnin mawe, “Mai reto mai ro mbam kʼallah sait meto tna mai reto raa meto fee.” ");
INSERT INTO ayz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tna raja Herodes sayõ ana mbaut ait sai. Ait ywaar bo ro ana mawe fee, tna ait ybaut Tuhan fee ye. Tibyo mam weto si oh to, malaikat ro Tuhan sau mno ait kiyam. Moo saba mse mkok ait. Tibyo yhai. ");
INSERT INTO ayz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tna watum ro Tuhan to syohor yum. Tibyo raa taro u mawat bo mari tna mama smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ysya Saulus mbewok mno bo ro raa mbis kʼana mam Yerusalem mkak. Tna fo, ana mbewok mhah mamoʼt Antiokhia tna mmen Yohanes ro ja raa mtu yasom Markus tait ysya ana mama ye. ");
INSERT INTO ayz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","2","Ati sau fo jemaat ro Antiokhia siret su. Ana skabuk kʼTuhan tna mhau bo ro mait afo re skabuk kaket. Ana fo nabi ro ja Allah ybis mamo mkyas bo wAit to baro msya guru baro ye. Ana weto to, sait yasom Barnabas tna sait yasom Simeon-Niger. Tna sait yasom Lukius ro ybam kota ro Kirene, tna sait yasom Menahem. (Menahem tait, Saulus ysya Herodes bo to ana tiwya raa mtos su.) Ana hre skabuk su to, Har ro Tuhan mawe kʼana mawe, “Jõ ksoh Barnabas ysya Saulus mamo mno bo woJõ.” ");
INSERT INTO ayz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Raa weto mhau bo ro mait tna moo matem mtor abyõ kʼana mbewok refo skabuk mayoh Allah yatam ana. Tna fo ana mmah meen akus tna bitsre ana mbewok mamo. ");
INSERT INTO ayz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Har ro Tuhan mbis, tibyo Barnabas ysya Saulus mbewok mamoʼt joh ro Seleukia. Tna ana mbewok mbam Seleukia maut kapal mamo snok sato ro Siprus. ");
INSERT INTO ayz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ana mhau mam remo ro Salamis to, ana mkyas Watum ro Allah. Mamo mkyas mam samu skabuk raa ro Yahudi sor. Tna mere sait yasom Yohanes-Markus kro ana mbewok ye mkah yno bo wana. ");
INSERT INTO ayz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ana mamo mur mtan mam sato reto, tibyo snok mam remo ro Pafos. Mam beto to, ana mkai raa ro Yahudi sait yasom Baryesus-Elimas. Ait tait raa ro ja yari botkif mafot kaket tna sioh yawe ait tait nabi ro Allah ybis yama ykyas bo wAit. ");
INSERT INTO ayz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ait ja yiranya ysya Gubernur ro sato reto. Gubernur retait yasom Sergius-Paulus. Ait raa ro yhar bo toni. Gubernur retait ja ksoh yari Watum ro Allah. Tibyo ait ytu Barnabas ysya Saulus mama. ");
INSERT INTO ayz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Menohe Baryesus-Elimas yno wa afo re Gubernur retait smot Yesus ma. ");
INSERT INTO ayz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Menohe Har ro Tuhan mbo Saulus matak. (Ja raa mtu ait yasom Paulus ye.) Mbo matak tna yasu sayõ Baryesus-Elimas tna yawe, ");
INSERT INTO ayz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Kabes yabi (Iblis) ybo nyõ matak to! Ja nyõ hawe bo ro moof tna nno bo kbik-kbak sai! Nyõ sioh raa yoyo tna iso moof ro Allah yerif kʼraa to, nyõ nno mkair sai. ");
INSERT INTO ayz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nyõ nno feto tibyo Tuhan kbe yno bo ro samyoh btek mai kʼnyõ ye. Mfo refo nasu mrok mboh! Ti baro firwas nyõ nmat bo fee ye.” Paulus yawe si feto fo, Elimas ait yrok yasu mti. Tna ait saso ninya wore yamo tna saso raa yawe ro mbo yatem re befatu mamo. ");
INSERT INTO ayz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gubernur retait ait ymat he Elimas yrok yasu mti tna ait yari bokyas ro Tuhan ana mbewok mkyas to yrok ktak. Tibyo ait yrok smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus ysya yafoh na sikba Pafos tna maut kapal tna mhoh mamoʼt remo ro Perga. Perga mhau mam provinsi ro Pamfilia. Mam Perga Yohanes-Markus sikba ana tna hah ye yamoʼt Yerusalem. ");
INSERT INTO ayz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tna mbam Perga ana mamo renti mam iso mne. Mamo tna snok mam kota Antiokhia ro mhau mam rabin ro Pisidia. Tna mam ayõ ro raa ntmoh (hari Sabat) to, ana mamo skabuk mam samu skabuk raa ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ana hre tna mari raa mbaca bokom ro Musa ykom baro msya bokom ro nabi na mkom baro ye. Mbaca mkak, tna raa mabi ro mbo samu skabuk reto to, mbis raa mamo mtu bo kʼPaulus ysya Barnabas. Mtu bo kʼana mbewok mawe, “Raa wamu: Anu ksoh nma nkyas bokyas baro kʼamu ye, fe mfe a? Soh nwe nkyas meto mi nkyas oh.” ");
INSERT INTO ayz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus yasen yros. Tna yawe, “Anu raa ro Israel nsya anu raa mbam rabin roto ro wa Allah bo nri ee: ");
INSERT INTO ayz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Allah ro anu raa ro Israel ja smot tait, tiwya tinyi ait ysok hohos wanu. Ana mamo raa srim mam Mesir. Mhau mam Mesir to, Ait yno ana mrok mriembes mase. Tna mkah Ait yatak rAit ro mase to, Ait ybo ana frok mbam Mesir mamo. ");
INSERT INTO ayz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tna tahun trion 40 firwas bo feto to, Ait yhau ymat tan bo ro ana mno mkair mam tabam ro riamo to. ");
INSERT INTO ayz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Anu hohos na mamo snok mam oo ro Kanaan tna mame anya msya raa ro mhau mam oo reto. Mame anya msya raa mana krema. Tna Allah yoo yatak yee kʼana re safto tabam wana shauk riryõn kʼraa wAit ro Israel. ");
INSERT INTO ayz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Allah yno bo weto beta to tahun trion 450 bo feto firwas wa. Mam wore wo ana mhau mam Kanaan Allah ysok raa ro ja yamo aban mana ybo ana. Aban mana weto to, aro sor mbo ana mamo snok mam wore wo nabi sait ro yasom Samuel yama ybo ana mtis naut u. ");
INSERT INTO ayz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tna anu hohos na mayoh kʼAllah mawe, ‘Noo raja sait nse ybo amu.’ Tibyo Allah yoo Saul yse yamo raja ro ybo ana. Saul tait ku bi Kisy yare. Raa wait beta to ku renti-renta bi Benyamin ro tiwya tinyi bi Yakub yare. Saul yamo raja tna ybo ana 40 tahun. ");
INSERT INTO ayz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tna Allah beak ait yakus. Allah yawe: ‘Jõ tmat sas Daud ku ro bi Isai yare tna ait yno Jõ thaf mnan. Ait raa ro kbe yno bo ro Jõ ksoh beta.’ 1 Samuel 13:14; Mazmur 89:21 Feto to Ait ysok Daud yse yamo raja riryõn shauk hroh ro Saul reto. ");
INSERT INTO ayz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mbam ku renti ro Daud yabe oh mi, Allah siwyan Raa sait mkah bo yoo riof ro mase yee kʼraa ro Israel. Ait retait yama oh. Yasom rAit Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesus yasom frok fefares to, raa sait ro yasom Yohanes yama. Yohanes ykyas kʼraa ro Israel makin yawe, ‘Nashana oh! Tna nma re kbe jõ baptis anu.’ ");
INSERT INTO ayz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohanes yno bo ro Allah ybis kʼait tna yawe, ‘Anu nnaut nwe jõ fi awya? Jõ fi Mesias fee. Ait retait kbe yama yrof jõ. Ait yase toni syok. Menohe jõ fi raa kair sai. Tibyo jõ trus sandal rAit fee.’” ");
INSERT INTO ayz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Tna Paulus ykyas bo renti naut yawe, “Raa wojõ; anu taro to ku renti ro bi Abraham yabe. Tna anu taro to raa rabin roto menohe anu waa Allah bo ye. Allah tiwya ykyas yawe Raa sait meen yoo riof ro mase yee kʼanu. Tiwya Allah ykyas Raa retait re kbe anu ro mfo refo bhau to bri tna kbe bkai riof. ");
INSERT INTO ayz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tiwya raa wase mawe Yesus tait Mesias. Raa ro mhau mam Yerusalem msya raa mabi wana mhar bo reto fefares. Bokom ro tiwya Allah ybis nabi na mkom mawe, ‘Meen raa mikyak Ait tna mame Ait yajat.’ Tna ana ro mhau mam Yerusalem to, ja mbaca bokom reto mam ayõ ro ana ntmoh (hari Sabat) soo oh. Tna ana mesait mikyak Yesus mnan si bo ro nabi na tii mkyas weto to, mhau rau oh. Menohe ana srau mnaut bo weto fee ye. ");
INSERT INTO ayz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yesus yno bo ro mkair aro fee. Menohe raa sioh mawe yno bo mkair. Mawe yno safo tibyo mamo mo kʼPilatus mawe, ‘Noo safo mana nmit kʼAit oh! Nbis raa wonyõ nawe mame Ait yajat!’ ");
INSERT INTO ayz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ana mno bo weto beta mamyot bo ro tiwya nabi na mkom wia matim oh. Ana mno bo weto mkak. Tna fo, ana skur ajat rAit mbam ara warok reto mamo sama Ait mam isra mato. ");
INSERT INTO ayz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Menohe Allah yno Ait yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tna raa mmat Ait u ye. Raa ro tiwya kro Ait mamo mbam Galilea mamo snok mam Yerusalem to, ana weto mmat Ait ti aro ye. Tna mfo refo ana weto ja mkyas bo ro ana mmat Ait yno to. Ana mkyas Yesus yasom kʼraa wamu ro Yahudi ye. ");
INSERT INTO ayz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mfo refo jõ tsya Barnabas nma nkyas bokyas refo kʼanu. Bokyas reto misti simaut kʼraa: Au oh mi bosi ro tiwya Allah ykyas ysi kʼhohos wanu. ");
INSERT INTO ayz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Bo ro tiwya ysi reto to, mfo refo mabo oh. Anu fo ku renti wana. Tna anu fo bmat: Allah yno Yesus yrok yasen. Yno mamyot mfi bokyas ro tiwya tinyi Raja Daud ykom mam Mazmur ro ewok to, yawe, ‘Nyõ tait Ku aJõ tna riwai Jõ tabe Nyõ oh.’ ");
INSERT INTO ayz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tna Allah ykyas Ku rAit Yesus yawe Ait kbe yno Yesus yrok yasen tna kbe ye yhai u fee. Allah yawe, ‘Tiwya tsi bo tawe tno bo moof ku renti ro Daud yabe sait to. Tna bo ro Jõ tesait tsi meto kbe mabo! Au oh mi; “Meen Ku renti rait sait yasen yamo Raja.”’ ");
INSERT INTO ayz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tna tiwya Daud yawe kʼAllah mam Mazmur far-far roto yawe, ‘Ait ro Nyõ Nbis Yama tait, meen Nyõ sayõ ajat rAit makus mnis fee.’” ");
INSERT INTO ayz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tna Paulus ykyas renti yawe, “Bokyas reto to, Daud ykyas ait yesait fee. Daud yno bo ro Allah ybis kʼait yno mam wore wo tiwya ait yhau fares to. Ait yno bo weto mkak tna ait yhai. Tna raa makah hai rait mamo sama mam yuk ro tiwya raa sama hohos na wait ye. Tna hai rait mrok mnis. ");
INSERT INTO ayz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Menohe hai ro Yesus mnis makus mfi Daud fee: Allah yno Yesus yrok yasen. ");
INSERT INTO ayz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Taja, tano na; nri oh. Nhar oh. Bo ro Yesus yno oh mi mno re Allah yyon iro raa to. ");
INSERT INTO ayz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tna awya ro smot Ait to, kbe Allah yyon iro wait beta. Tibyo Allah yawe ait retait raa ro yhaf moof ati. Menohe Watum ro Musa mno raa mhaf wana moof ati feto fee. ");
INSERT INTO ayz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Tiwya Allah ybis nabi wAit mama mkom mawe, ‘Meen, mam wore wo anu nhau to, kbe Jõ tno bo ro msai sau. Kbe raa betoo bo reto kʼanu. Menohe kbe anu nri tna nfot fee. Kbe anu nmus-amas Ait. Kbe anu nrok ntak ye. Tna kbe anu nhai beta.’” Habakuk 1:5 Nri smot Yesus be kbe bokyas reto mai kʼanu ye. ");
INSERT INTO ayz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulus ysya Barnabas mkyas bo mkak. Tna raa frok samu skabuk reto mamo. Mamo tna raa weto soh-soh ana mbewok mawe, “Amu ksoh anu mbewok ne nma nkyas bo reto u kʼamu. Nma nkyas mam ayõ ro raa ntmoh (hari Sabat) ro rouu ro mama naut.” ");
INSERT INTO ayz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Raa skabuk mkak. Tna raa mawat kro Paulus ysya Barnabas mamo. Ana weto to, raa ro Yahudi ye tna msya raa ro mbam rabin roto menohe ro kro agama ro Yahudi ye. Tna ana mbewok reto mkyas kʼana mawe, “Mkah tak ro Allah rAit to, nhau smot Ait yoyo.” ");
INSERT INTO ayz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ayõ ro raa ntmoh rouu to, raa ro kota reto beta mama siret mari bokyas ro Allah. ");
INSERT INTO ayz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Menohe raa ro Yahudi mmat raa msis weto mari bo ro Paulus ykyas to, ana hawe. Tna mrok mhaf mkair. Tibyo ana mamus ana mbewok. Tna besboh bo ro ana mawe. ");
INSERT INTO ayz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Menohe Paulus ysya Barnabas waa fee. Ana me mawe kʼana ro Yahudi weto mawe, “Allah ybis amu nkyas watum rAit kʼanu wia matim. Menohe anu hawe bo nri. Anu nnaut nwe anu noof mnan si, tibyo meen nkai nmos mae fe mfe a? Anu hawe bo nri Watum ro Allah feto to, kbe amu haberek kbor wamu tna nmo nkyas kʼraa mana roto. ");
INSERT INTO ayz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Feto ye Tuhan ybis amu yawe, ‘Jõ tsok nyõ mkah namo nnan nfi kek. Kbe nyõ nram iso kʼraa rabin roto makin. Re kbe nyõ nakah riof ro mase namo nee kʼraa ro mhau mam arin aso beta.’” ");
INSERT INTO ayz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Raa mbam raa mana roto mari feto, tibyo mrok simaut mase. Ana mawe bokyas ro Tuhan reto moof syok. Tna raa ro tiwya Allah ysok yawe meen mkai mamos mae to, ana mama smot Yesus beta. ");
INSERT INTO ayz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tna bokyas ro Tuhan, raa makah mamo mkyas mam rabin reto beta. ");
INSERT INTO ayz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Menohe raa ro Yahudi mkyas-kas Paulus ysya Barnabas. Ana mkyas kʼfnya manes ro mhau mam kota reto tna ro ja waa Allah ye. Tna mamus ana mbewok kʼraa ro mase ye. Tibyo fnya msya raa wefo sikowah Paulus ysya Barnabas tna mikyak ana mbewok frok mamo mbam oo rana ye. ");
INSERT INTO ayz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paulus ysya Barnabas ngkaru bohasyaf ro mhau kʼana mbewok maa to war feto. Tna mbewok masen mamoʼt remo ro Ikonium. ");
INSERT INTO ayz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Raa ro smot Yesus mam Antiokhia simaut mase tna Har ro Allah mbo ana matak ye. ");
INSERT INTO ayz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mam remo ro Ikonium Paulus ysya Barnabas mno bo ro ja ana mno soo oh: Ana mbewok twok mam samu skabuk ro raa Yahudi tna mkyas Yesus yasom. Mkyas bo kaket, tibyo raa ro Yahudi msya raa ro Yunani ye msis-sas mama smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Menohe raa ro Yahudi taro hawe smot Yesus. Ana weto mkyas-kas ana mbewok kʼraa ro wase Allah. Mno raa mrok kmo ana ro smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulus ysya Barnabas mbewok mhau ti mawat baro kait ye mam beto. Ana mbewok mkyas Tuhan yasom kʼraa. Ana waa fee. Ana mkyas boatmof ro Tuhan. Tna Ait yoo yatak rAit yee kʼana re mbewok mno bo ro msai. Ana sair bo ro hnah re kbe raa mmat tibyo mhar mawe ana mkyas bo ati, ana sioh fee. ");
INSERT INTO ayz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Raa ro mhau mam remo reto to, mhaf sau fee: Taro ksoh Paulus ysya Barnabas. Tna taro ksoh raa Yahudi ro hawe smot Yesus. ");
INSERT INTO ayz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ana ro hawe smot Yesus weto to taro raa ro Yahudi msya raa manes wana. Tna taro to, raa mana roto tna msya raa manes wana. Ana weto beta saim bo su mawe mfot ana mbewok afo re ana mno bo ro mkair mai kʼana. Mawe mawah fraa mai ana majat bo ye. ");
INSERT INTO ayz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Ana mbewok mari feto, tibyo ana msam mamoʼt rabin ro Likaonia. Ana mamoʼt remo ro Listra, remo ro Derbe msya tabam ro kene mam remo weto. Mamoʼt rabin ro Likaonia reto tna mkyas Bokyas Moof ro Yesus (Injil) renti. ");
INSERT INTO ayz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ana mamo snok mam remo ro Listra to, ait ro yaa mhai sait hre. Ait tait, tii tinyi fnya mabe to, yaa mhai oh. Tna ja yamo fefares. ");
INSERT INTO ayz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ait hre yari bo ro Paulus ykyas. Paulus yasu sayõ ait tna ynaut yawe bosmot rait matak. Bosmot rait matak re kbe Allah yisoh yaa rait moof matak. ");
INSERT INTO ayz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulus ymat feto, tibyo yawe mkah ymai ro mase yawe, “Nasen nros ntrot.” Tibyo ait retait yrok sontor yasen yros tna yamo ye. ");
INSERT INTO ayz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Raa msis-sas mmat bo ro Paulus yno feto. Tibyo masen mmai mnin. Ana mkyas mkah mmai rana ro Likaonia mawe, “Ana mbewok refo raa sai fee. Ana mbewok refo allah mefo. Ana haberek mamo mfi raa sai tna mbam sawro wana mama mo kʼanu oh mefo!” ");
INSERT INTO ayz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ja Barnabas ykyas bo kebet sai, tibyo ana mtu yasom Zeus mfi allah rana sait. Tna Paulus ja ykyas bo mawat tibyo ana mtu yasom allah Hermes. ");
INSERT INTO ayz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tna imam yanes sait yama ye. Imam retait tait, yoo tafuf fayir sapi ro sme baro. Fayir tna yakah sapi weto yamo frok remo kitana wore samu sahfra ro Zeus rait mhau. Ait ysya raa msis-sas mawe ktan sapi weto mee kʼPaulus ysya Barnabas. Mawe mee mkah bo mbaut ana mbewok. ");
INSERT INTO ayz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ana mbewok mari feto tna hawe. Hawe tibyo ana mbewok mhah ratan wana ro mesait myum mawe, “Raa wefo mnaut mawe amu fo mfi allah sor ro ja ana smot!” Tna ana mbewok mhoh mamo mbukak iti mam raa msis-sas wefo masuf susai tna mtu mawe, ");
INSERT INTO ayz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Anu nkin; nri oh! Nno bo refo nno fyi? Nhar nwe amu fo Allah fee. Amu fo raa sai, nnan anu ye. Bokyas Moof ro mkyas Yesus (Injil) to, amu nkyas kʼanu afo re anu sikba bosmot wanu ro mkair weto tna nma smot Allah ro yaam. Ait oh mi yfen ayoh msya tabam refo tna yfen aya sawan msya bombra ro mhau mam wore weto beta to. ");
INSERT INTO ayz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ti bose oh to, Ait yhau sayõ raa mana sau-sau beta mamo iso wana mamyot bo ro ana mhaf wana ksoh sai. ");
INSERT INTO ayz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ait sayõ raa mno feto to, menohe Ait sikba ana makus fee. Ait yerif Ait kʼraa mam bo moof msis-sas ro Ait yno kʼanu. Bo moof ro Ait yno kʼanu oh mefo: Ait yno oom mais mbam ayoh tna yno boit msya bobat moo moof mam armato wanu ye. Tna yoo boit yee kʼanu niit re nhaf mnan tna yno anu simaut mase ye.” ");
INSERT INTO ayz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ana mbewok mkyas feto re mno wa raa makin weto kbe mno bo reto ma tna mbaut ana feto ma. Raa weto mawe beroh msan bo kʼana mbewok menohe mfe. ");
INSERT INTO ayz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ti baro firwas, tna raa ro Yahudi baro mbam kota ro Antiokhia msya remo ro Ikonium mama. Mama, tna mkyas bo haberek hren msya myoh moo raa makin refo afo re ana haberek knait Paulus. Tibyo ana mai ait mkah fraa. Mai mkak oh tna ana mrok mawe ait yajat oh. Tibyo mkuk ajat rait frok mamo beak mam remo mne. ");
INSERT INTO ayz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Menohe raa ro smot Yesus mama mros mur mtan kʼait, tna ait yrok yasen tna twok mam remo reto u. Tna rabu ti fo ait ysya Barnabas mbewok masen frok remo reto mamo renti remo ro Derbe. ");
INSERT INTO ayz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulus ysya Barnabas ana mamoʼt remo ro Derbe, tna mkyas Bokyas Moof ro Yesus (Injil) mam beto. Tna raa msis mama smot Yesus. Tna ana mbewok mhah mamoʼt Listra, Ikonium msya Antiokhia mam rabin ro Pisidia ye. ");
INSERT INTO ayz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tna mam kota weto to, ana mkyas bo kʼraa ro smot Yesus mawe, “Nros natak nbo bosmot wanu matak. Soh anu ksoh bmo raa mana ro Allah yamo Raja ybo to, kbe anu bkai bo ro samyoh mawat.” ");
INSERT INTO ayz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tna mam jemaat sau-sau Paulus ysya Barnabas msok majelis taro mkah bo kmot raa ro smot Yesus mam kota wana. Ana mbewok mhau bo ro mait tna skabuk msan majelis weto kʼTuhan ro ana smot. Tna ait yayoh yawe Tuhan yatam majelis weto. ");
INSERT INTO ayz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ana mbewok mamo mur mam rabin ro Pisidia mkak, tna twok mam rabin ro Pamfilia. ");
INSERT INTO ayz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tna ana mkyas watum ro Tuhan mam remo ro Perga. Mkyas mkak, tna mamo siya snok mam remo ro Atalia. ");
INSERT INTO ayz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tna ana mbam beto maut kapal hah me mamoʼt kota ro Antiokhia mam provinsi ro Siria. (Tiwya jemaat ro mhau mam Antiokhia oh mi ro mbis Paulus ysya Barnabas mamo mkyas Yesus yasom mam rabin roto taro to. Tiwya ana skabuk mayoh Allah mawe Ait yatam ana mbewok wore woyõ-woya sai mamo. Tna mayoh mawe Allah yoo bouum ye kʼana mbewok, yno re raa mari bokyas ro ana mkyas, tibyo mama smot Yesus. Paulus ysya Barnabas mkyas Yesus yasom mam rabin roto mkak.) ");
INSERT INTO ayz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tna ana snok si mam kota ro Antiokhia. Ana mbewok mtu raa jemaat reto beta mama siret su. Tna fo ana mbewok mkyas bombra beta ro ana mno mkah tak ro Allah rAit. Tna mawe Allah yitrah amah rait tna yawe raa mbam raa mana roto ye mama smot Tuhan ye. ");
INSERT INTO ayz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tna fo ana mbewok mhau baro kait msya raa ro smot Yesus mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Raa baro mbam Yudea mamaʼt Antiokhia tna mkyas kʼraa Kristen ro mhau mam beto mawe, “Soh anu sunat fee mamyot watum ro Musa ykyas feto, kbe anu nkai riof fee ye.” ");
INSERT INTO ayz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Menohe Paulus ysya Barnabas ana mbewok hafrah bo ro ana mkyas reto. Ana masen santri bo msya raa weto. ⌞Tna jemaat ro Antiokhia wase kbe Allah yawe ana sunat ku sme wana fe mfe a?⌟ Wase, feto mnaut mawe ana mtu kʼraa ro mhar bo reto. Tna ana msok raa baro mbis ana mamoʼt Yerusalem. Mbis ana mamo mkyas bo reto su msya raabis (rasul) ro Yesus wAit msya raa manes roto. Tna ana msok Paulus ysya Barnabas msya raa baro mbam Antiokhia ye. Msok ana weto to, mbis mamoʼt Yerusalem tna mtu mawe, “Kbe anu, raa Kristen sunat ku sme wanu fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Raa Kristen ro Antiokhia to, ana mkyas bo reto mkak tna masen mamo betne Paulus ysya raa weto sor mamo snok kota rana reto makit. Paulus, Barnabas msya raa jemaat ro kro ana mamo iso rabin ro Fenisia msya provinsi ro Samaria. Mam iso maka iti to, ana fri raa Kristen ro mbam raa mana ro Yahudi baro. Paulus ysya raa ro kro ait mkyas bo kʼana mawe, “Raa ro mbam raa mana roto to, ana taro mashana tna smot Tuhan Yesus oh!” Raa Kristen mari feto tibyo simaut mase toni ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paulus ysya Barnabas msya raa Kristen ro mbam Antiokhia weto mamo snok mam Yerusalem. Tna raa Kristen ro mhau mam Yerusalem mmah meen kʼana. (Raa weto oh mi raabis ro Yesus wAit, raa ro majelis, msya raa Kristen taro ye.) Paulus ysya Barnabas mkyas bo ro Allah yno to. Mawe ja ana mamo mkyas Yesus yasom, tna raa rabin roto, ro Yahudi fee, ana to mawat mama smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Menohe raa ro Farisi baro ro smot Yesus mari bo reto ye. Ana mari feto tna masen mros mawe, “Raa ro Yahudi fee, ro mama smot Yesus ye oh to, sunat ana ye! Tna nbis ana kro Watum ro Musa ye!” ");
INSERT INTO ayz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Raabis weto msya raa majelis taro hre su mkyas bo reto mawe, “Allah yawe kbe raa beta sunat ku sme wana fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ana hre mkyas bo reto baro kait ye oh. Tna Petrus yasen yros yawe, “Taja nsya tao na; anu nhar nwe tiwya Allah ysok jõ tbam kʼanu mkah bo jõ tamo tkyas Bokyas ro Moof (Injil) kʼraa mana roto makin. Yno afo re ana mama smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Allah yhar raa mhaf mato beta. Tna Ait yawe Ait ksoh ana ye. Tna yoo Har rAit yse kʼana ye mnan fi Ait yse Har rAit yse kʼanu raa ro Yahudi to. Yno re kbe anu bhar bwe Ait ksoh ana weto ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Allah ysok anu hayah tna ana hayah fee. Ana smot Yesus tibyo Ait yisoh ana mhaf mato wana moof ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kaket anu! Sanet Allah ma! Anu besait bsya hohos wanu hrowyõ bhai kro bo mafa ranu kaket to. Fyi re anu nnaut nwe Ait ksoh raa rabin roto masom bo fanes reto ye? ");
INSERT INTO ayz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Riof ro anu bkai to mbam boatmof ro Tuhan Yesus Kristus rAit sai. Mbam bo mafa ramu to fee! Tna ana weto mkai riof mam iso ro bosmot ye mnan anya!” ");
INSERT INTO ayz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tna Paulus ysya Barnabas masen mkyas bo. Ana mkyas mawe “Allah yoo yatak rAit yee kʼamu mbewok re nno bo ro msai. Amu sair bo ro hnah re kbe raa mana roto mmat tna mhar Ait yase rait.” Raa ro siret weto hre shait sai mari. ");
INSERT INTO ayz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Paulus ysya Barnabas mkyas bo wana mkak. Tna fo Yakobus yasen yawe, “Taja nsya tao na; nri oh! ");
INSERT INTO ayz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon-Petrus riwai ykyas bo ro tna sai tinyi rau! Ait betoo yawe Allah yatmof tna ysok raa taro mbam raa mana roto mamo raa wAit ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Bo reto mamo mamyot bo ro tiwya Allah ybis nabi na mama mkom mawe, ");
INSERT INTO ayz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Meen Jõ thah te tama tisoh samu ro Daud rait. Samu rait reto tiwya matu tna kbe te sgi u. Bombra ro tiwya nsasi beta meen me mros matak. ");
INSERT INTO ayz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Jõ tno feto afo re raa ro Yahudi, tna msya raa ro rabin roto beta kbe saso Jõ. Ana weto tiwya wase Jõ. Menohe jõ ttu ana weto ye, tawe ana mamo ku woJõ to. Kbe meen ana saso Jõ ye. Tuhan Allah yesait ykyas bo reto. ");
INSERT INTO ayz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tiwya tinyi ykyas bo reto beta re kbe raa mhar.’” ");
INSERT INTO ayz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tna Yakobus yawe, “Feto to jõ tnaut tawe, raa ro rabin roto weto, anu bbis bwe ana kro bo mafa wanu beta ma, ana ksoh rana sai. Kbe anu bno bo ro nririt wa iso kʼana mama mo kʼAllah to ma. ");
INSERT INTO ayz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Jõ tnaut tawe anu bkom aam sau tee kʼana. Bkom aam bwe: 1. Sohmaam bo ro raa moo msan kʼberhala oh to ma. 2. Tna nwyah bo to ma ye. 3. Nbo kak kwiyan ro mees mhau fares to ma. 4. Nta mees ro kak raa ktan to ma. ⌞Soh ana kro bo mafa wanu weto sai to, kbe moof. Kbe anu ro Yahudi hrenaut fee. Tna kbe anu biranya moof sai.⌟ ");
INSERT INTO ayz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Watum ro Musa mkyas mawe bo weto beta raa ro Yahudi mbau. Mam woyõ-woya sai tiwya bose oh, ja raa wanu bkyas bo reto. Feto to raa mhar oh. Tna anu raa ro Yahudi bmat bokyas reto mam samu skabuk wanu ye. Anu bmat bokom reto mam ayõ ro raa ntmoh (hari Sabat) yoyo.” ");
INSERT INTO ayz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tna fo raabis ro Tuhan wAit, raa majelis msya raa ro ja smot Tuhan taro ye, ana beta hre mkyas bo su. Tna ana mawe msok raa mabo baro mbam ana makin weto tna mbis ana mamoʼt kota ro Antiokhia. Ana msok raa manes mabo ewok: Yudas-Barsabas ysya Silas. Tna mbis ana mbewok kro Paulus ysya Barnabas mhah me mamoʼt Antiokhia. ");
INSERT INTO ayz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tna ana weto sor mkom aam sau mee kʼYudas ysya Silas mbewok mbo makah mamo. Aam reto mkyas mawe, “Taja, tme, tao, tano na ro nbam raa mana roto; amu nkom aam refo nee kʼanu ro nhau mam Antiokhia, tna ro nhau mam remo taro mam provinsi ro Siria, msya provinsi ro Kilikia ye. Meen oh kʼanu beta. ");
INSERT INTO ayz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Amu nri raa mabo baro mama mo kʼanu, tna ana mkyas bo ro mno anu nrok susit ye. Amu aro nbis ana nwe ana mama mkyas bokyas feto fee. ");
INSERT INTO ayz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Riwai amu nhau mam Yerusalem to, siret su tna nkyas bo reto. Tna amu nsok Yudas-Barsabas ysya Silas tna nbis ana mbewok refo mama mo kʼanu. Ana kro Paulus ysya Barnabas, ro ja amu ksoh to, mama. ");
INSERT INTO ayz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yudas ysya Silas ja mros mana matim mno bo ro Tuhan ybis kʼana sai. ");
INSERT INTO ayz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Feto oh mi amu nbis ana mbewok mamo mo kʼanu to. Ana oh mi kbe mama mkyas watum ramu reto kʼanu kait mamyot si aam ro amu nkom refo fo. ");
INSERT INTO ayz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Amu hawe bo nbis anu nno bo ro samyoh. Tna Har ro Tuhan mkyas bo reto kʼanu ye mnan anya. Feto to amu nsi bo wefo kʼanu sai: 1. Sohmaam boit ro raa moo msan kʼberhala oh to ma. 2. Nta mees ro kak raa ktan to ma. 3. Nbo kak kwiyan ro mees mhau fares to ma. 4. Tna nwyah bo to ma ye. Bokom wamu kebet sai oh mefo, mkah bo watum anu afo re anu nberhasyoh raa ro Yahudi to ma. Meen oh kʼanu beta.” ");
INSERT INTO ayz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Raa Kristen ro mhau mam Yerusalem weto ana mmah meen kʼana mabo jiit reto. Tna fo ana masen mamoʼt Antiokhia. Raa mabo jiit reto snok mam Antiokhia. Tna ana mtu raa Kristen beta ro mhau mam beto sor mawe mama siret beta. Tna ana mbaca aam reto kʼana beta. ");
INSERT INTO ayz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Raa mari bokyas ro aam reto to, ana simaut mase. ");
INSERT INTO ayz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas ysya Silas to, mbewok nabi ro ja Allah ybis mkyas bo wAit to ye. Tna wore wo ana mhau mam beto to, ana mkyas bo kʼraa ro smot Yesus. Bo ro mbewok mkyas reto to, mno bosmot wana matak. ");
INSERT INTO ayz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ana mbewok mhau mam Antiokhia ti baro firwas. Tna ana masen mawe hah me mamoʼt Yerusalem. Tna raa Kristen mmah meen kʼana mbewok tna mawe kbe ana mbewok mmah meen kʼraa Kristen ro mhau mam Yerusalem ye. Tna mawe mayoh asik mase kʼraa ro mbis ana mbewok mama to ye.  ");
INSERT INTO ayz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Menohe Silas yawe ait yhau wia fares mam Antiokhia. ");
INSERT INTO ayz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus ysya Barnabas mhau mam Antiokhia ti baro naut mkah bo mkyas watum ro Tuhan kʼraa ro mhau mam beto ye. Tna raa Kristen mawat taro ye mkyas watum ro Tuhan mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mhau ti baro naut tna Paulus yawe kʼBarnabas yawe, “Anu mbewok hah be bmoʼt kota ro tiwya bkyas Tuhan yasom sor to no. Tawe anu be bmo bmat raa ro mama smot Yesus tna sor to. Feto kbe anu bhar soh ana mhau smot Yesus matak fe mfe a?” ");
INSERT INTO ayz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas ait ksoh ymen Yohanes ro ja raa mtu yasom Markus tait, kro ana mamo ye. ");
INSERT INTO ayz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tiwya Markus yasen sikba ana mam Pamfilia. Feto oh mi Paulus ait hawe bo ymen Markus kro ana mamo u fee. ");
INSERT INTO ayz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Feto tibyo Paulus ysya Barnabas kmo anya toni tibyo ana mbetne-tna anya: Sait yasen yamo hayah-hayah. Barnabas ait ymen Markus kro ait maut wiak (kapal) mamoʼt sato ro Siprus. ");
INSERT INTO ayz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Tna Paulus ymen Silas kro ait mamo ye. Tna raa ro Kristen weto skabuk Tuhan afo re bouum rait mhau matam ana mbewok. ");
INSERT INTO ayz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulus ysya Silas mbewok mamo mur mtan mam provinsi ro Siria msya provinsi ro Kilikia. Ana mkyas watum ro Tuhan reto kʼraa Kristen ro mhau mam rabin weto sor to, tibyo bosmot wana mrok matak ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus yasen yamoʼt remo ro Derbe tna fo yamoʼt remo ro Listra ye. Mam weto ait fri ku ro sme sait yasom Timotius. Timotius ja smot Yesus. Ait yme, fnya mbam fnya mana ro Yahudi. Tna fai au reto smot Yesus ye. Timotius, ait yaja ybam raa mana ro Yunani. ");
INSERT INTO ayz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Raa ro ja smot Yesus ro mhau mam Listra msya Ikonium to, ana ksoh Timotius, mawe ait raa ro ja yno bo moof ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus ksoh yawe Timotius kro ait mamo ye. Menohe raa mbam raa mana ro Yahudi ana mhar mawe Timotius yaja tait, ybam raa mana ro Yunani. Tna ana mhar mawe soh Timotius ynan anya ysya raa ro Yahudi, raa ro Yahudi kbe ksoh mari bo ro ana mkyas. Feto tibyo Paulus sunat Timotius wia. ");
INSERT INTO ayz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tna Paulus, Silas, ysya Timotius masen mamoʼt kota makin. Mamo mmat raa ro smot Yesus. Ana mbo aam raabis (rasul) ro Yesus msya majelis tiwya mkom mam Yerusalem. Tna mkyas aam reto kʼraa jemaat weto mawe, “Ana mbis mawe anu kro bo mafa raa ro Yahudi ja mno beta ma, kro bo ro raa mkom mam aam refo sai tna nbo nno ye.” ");
INSERT INTO ayz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tibyo raa ro smot Yesus sor fo, bosmot wana mrok matak. Tna rabu ti wawa to raa roto taro mama smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Har ro Tuhan mkyas kʼPaulus, Silas, ysya Timotius mawe, “Nmo nkyas Watum ro Allah mam rabin ro Asia ma!” Feto tibyo ana mamo twat sai mkyas Watum ro Allah mam rabin ro Frigia msya provinsi ro Galatia sai. ");
INSERT INTO ayz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ana mama snok mam kitana provinsi ro Misia tna ana sik twok mam provinsi ro Bitinia ye menohe Har ro Yesus mno wa mawe, “Ntwok mam provinsi reto ma!” ");
INSERT INTO ayz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Feto tibyo ana mamo miwrek provinsi ro Misia iti tna mamoʼt remo ro Troas. ");
INSERT INTO ayz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mti reto Paulus ait yjin smi ymat raa ro Makedonia sait yros tna soh-soh ait yawe, “Paulus: Nasen namaʼt provinsi ro Makedonia nmat amu ye!” ");
INSERT INTO ayz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulus ymat bo reto, tna amu srau nwe Allah ybis amu nsen nmo nkyas watum rAit kʼraa ro Makedonia ye. Feto tna amu siwyan bo wamu tna nsen nmoʼt Makedonia. ");
INSERT INTO ayz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Amu sikba remo ro Troas tna nuut kapal nhoh nmoʼt sato ro Samotrake. Tna rabu ti to amu nmo nuut kapal nmo renti nmoʼt remo ro Neapolis ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tna nbam Neapolis nsen nmoʼt Filipi, kota ro mase tinyi mam provinsi ro Makedonia reto. (Kota ro Filipi to, pemerintah Roma mbo.) Amu nhau ti baro mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ayõ ro raa ntmoh (hari Sabat) to, amu nsen nmoʼt aya sau ro kene mam kota reto makit. Amu nnaut nwe raa ro kro agama Yahudi ja mamo skabuk su mam yuk reto. Tibyo amu nmo hre su nsya fnya sor ro riwai mamo matim tna hre su mam yuk reto wea. Hre tna nkyas bo nsya ana. ");
INSERT INTO ayz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ana weto, sau masom Lidia. Fai au mbam remo ro Tiatira. Au ja mkah bo mtaus hawee ro mkek. Lidia ja smot Allah. Au hre mari Paulus ykyas Yesus yasom. Tna Tuhan yno au mrok mhaf smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidia msya raa ro amah rau mawe raa baptis ana. Tna au mawe kʼamu mawe, “Anu nhar nwe jõ smot Yesus. Soh feto to, nma, kbe anu njin mam samu ramu ye, mbau a.” Fai au matak sai mawe amu nma. Tibyo amu nmo nhau mam amah rau. ");
INSERT INTO ayz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ati sau amu nmoʼt yuk ro raa skabuk. Tna amu fri ku sau. Ku au reto raa awe. Awe reto ja kabes mbo tna au mkyas bo ro meen btek mai kʼraa. Tna ja raa mama mtu tane bo kʼau ye. Pitis ro raa moo mee reto, ku au mbo fee, moo mee kʼbobot wau. Awe reto ja moo pitis mawat mee kʼbobot wau ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ati reto to, awe reto kro Paulus ysya amu mam tis. Tna mmai wer mawe, “Raa wefo fo raabis Allah ro yase wAit! Ana mama merif iso ro kbe raa mamo tna mkai riof ro mase!” ");
INSERT INTO ayz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ti mawat ye oh ku au reto mno feto yoyo sai. Tna Paulus ynaif fasa yari bo ku au reto mtu feto. Tna ait haberek yawe kabes ro mbo au reto yawe, “Mkah Tuhan Yesus yasom: Jõ tikyak nyõ tawe nfrok nbam ku au reto namo!” Feto si to kabes reto sikba ku au, frok mamo. ");
INSERT INTO ayz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tna bobot ro ja mtos ku au sor to, kmo mawe, “Nno fyi meto! Wore kbe amu tru pitis aro u fee oh?” Tna ana mfot Paulus ysya Silas mamoʼt pasar msan ana mbewok kʼraa ro sbe. ");
INSERT INTO ayz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tna ana makah Paulus ysya Silas mamo msan renti kʼaban mana ro mbo kota reto. Ana sioh maun boun mawe, “Raa ro Yahudi wefo fo mno raa ro befo mrok mnin-nin. ");
INSERT INTO ayz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ana sobu mawe anu bno bo mafa wana. Mawe ksoh anu bno bo miwer watum ro Roma, miwer pemerintah ja mbis!” ");
INSERT INTO ayz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Raa ro berur su weto mari feto tna ana mrok mamus Paulus ysya Silas ye. Tna aban mana ro mbo kota reto mbis raa mhah ratan wana mbewok mbam ana metsu tna mbis raa moo too mok-mak ana mbewok ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ana mbewok raa mmok-mak mkak. Tna makah mamo mbu mam bui. Aban mana ro mbo kota mbis raa kmot ana mbewok matak toni. ");
INSERT INTO ayz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tibyo raa sbe ro kmot ana ybu ana mbewok mam amah hawar ro mhau masuf susai. Tna make ana mbewok maa ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Arin masuf to, Paulus ysya Silas mbewok skabuk tna mji howes ye kʼAllah. Tna raa taro sor mhau mam bui reto ye. Ana weto hre mari bo ana mbewok skabuk tna mji howes feto si fo ");
INSERT INTO ayz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","iin ro msai frok sin amah reto. Mato beta mrok masoh maa. Tna bo ro raa make to mrok hri-hra beta ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Raa sbe ro kmot ana yrok yasen. Tna ait ymat he mato ro bui reto mrok masoh maa beta. Ait ynaut yawe raa ro ait kmot weto beta frok msam mamo oh. Tibyo yayõ tfo rait yawe takoh ait. Ait ynaut yawe yhau ma kbe raja Kaisar ybis raa mame ait yajat ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Menohe Paulus ytu mkah ymai ro mase yawe, “Ntakoh nyõ ma! Amu beta nhau fares mefo!” ");
INSERT INTO ayz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tna raa sbe retait yayoh tafoh tna ybo yhoh yamoʼt bui mato. Yamo yo kʼPaulus ysya Silas to, ait tetet tna ysit yimna mam tabam. ");
INSERT INTO ayz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tna yasen yakah ana mbewok frok mne. Tna ytu yawe, “Jõ tno bawya re kbe jõ tkai riof ro mase?” ");
INSERT INTO ayz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paulus ysya Silas mawe, “Smot Tuhan Yesus afo re kbe nyõ nkai riof ro mase. Tna raa wonyõ ye: Soh ana smot Tuhan to, kbe ana mkai riof ro mase ye.” ");
INSERT INTO ayz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tna Paulus ysya Silas betoo Watum ro Tuhan kʼraa sbe retait ysya ana ro mhau mam amah rait beta. ");
INSERT INTO ayz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mti reto ye ait yyon tna yisoh yaaf wana ye. Tna ait ysya raa wait ro mhau mam amah rait beta mawe ana mbewok baptis ana ye. ");
INSERT INTO ayz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tna fo bi ait yakah Paulus ysya Silas yamoʼt amah rait, tna yasyõ boit yama yee kʼana mbewok mait ye. Ait ysya raa wait smot Yesus tibyo ana simaut mase toni syok. ");
INSERT INTO ayz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Rabu momo to aban mana kota ro Filipi sor mbis raa sbe wana mamoʼt bui tna tufrok Paulus ysya Silas re ana mamo bana. ");
INSERT INTO ayz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tna raa sbe ro kmot ana mbewok retait ykyas bo reto kʼPaulus yawe, “Aban mana ro kota refo sor riwai mbis mawe raa tufrok anu mbewok nmo. Feto to nmo oh. Tna meen oh kʼanu.” ");
INSERT INTO ayz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Menohe Paulus yawe si kʼraa sbe ro riwai mama weto yawe, “Amu mbewok fo raa ro Roma. Nmo nkyas bo reto kʼaban mana weto. Nwe ana mesait miwer watum ro pemerintah Roma: Taa ana mbis raa mmok-mak amu mam wore raa makin mmat. Tna mbu amu mam bui ye. Mno feto menohe mtu srah ranu mbewok fefares! Bo ro ana mno reto mkair toni! Tna mfo refo ana mawe mbis amu nmo shait sai a? Feto to amu hawe ye. Amu nwe kbe aban mana ro mbo kota refo mesait makah mabo kait mamaʼt befo afo re tufrok amu to saah.” ");
INSERT INTO ayz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Raa sbe weto hah me mamo mkyas bo weto kʼaban mana weto. Ana weto mari he Paulus ysya Silas ana warga negri Roma, feto tibyo aban mana weto mrok waa. ");
INSERT INTO ayz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tna mesait mamo mo kʼana mbewok mam bui. Tna makah ana mbewok frok mamo, tna soh-soh ana ye mawe, “Nmo frok nbam kota ramu oh!” ");
INSERT INTO ayz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tna fo Paulus ysya Silas mamoʼt amah ro fai Lidia rau. Ana fri raa ro smot Yesus taro ye mam beto. Ana mbewok mkyas bo moof kʼraa weto. Tna fo mbewok masen mamo renti. ");
INSERT INTO ayz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus ysya Silas masen mamo renti naut. Ana mamo iti snok mam remo ro Amfipolis msya remo ro Apolonia. Tna fo ana mbewok snok mam kota ro Tesalonika. Samu skabuk raa ro Yahudi sau mhau mam beto ye. ");
INSERT INTO ayz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Mam ayõ ro raa ntmoh (hari Sabat) to, Paulus ja yamoʼt samu skabuk reto, ykyas Bokom ro Allah. Tiwya yno bo reto mfi bo mafa ro ja ait yno sor to, yno muhrin tuuf oh. Tna mam ayõ reto ye Paulus yamoʼt samu skabuk ye. ");
INSERT INTO ayz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ait yasen betoo Watum ro Allah kʼraa ro Yahudi weto. Yawe, “Bokom ro Allah mkyas Mesias. Mkyas mawe kbe Ait ykai bo ro samyoh: Raa mame Ait yajat. Tna mam ti ro tuuf to, kbe Ait yrok yasen ye.” Ykyas Bokom ro Allah ro ana mhar oh reto. Tna betoo afo re ana srau mawe Yesus tait Mesias to. ");
INSERT INTO ayz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bokyas ro Paulus matak toni. Tibyo raa ro hre mari weto to, taro mama smot Yesus: Raa mbam raa mana ro Yahudi ye, raa ro ja smot Allah mbam raa mana ro Yunani mawat ye, msya fnya manes mawat ye. Ana mama smot Yesus tna kro Paulus ysya Silas ye. ");
INSERT INTO ayz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Menohe raa ro Yahudi ro hawe smot Yesus fee to, ana mmat feto tibyo mrok mhaf mkek. Tna ana mamoʼt pasar tna saso raa ro mkair. Saso raa ro ja mira mboh-bah sai. Tna mtu ana ro ja mamo-ama sai mama. Raa ro Yahudi weto mbis ana ro mkair weto mamo mno raa ro kota reto beta mrok mnin-nin. Tna fo raa mkbair reto mamo twok mam amah bi sait ro yasom Yason. Ana mawe saso Paulus ysya Silas re mfot tna makah mamo msan kʼraa. ");
INSERT INTO ayz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","He mfe, ana mbewok marak. Tibyo ana kmo mfot Yason ysya raa ro Kristen mabo baro ye. Mfot tna makah mkuk mamo msan kʼaban mana ro ja mbo kota ro Tesalonika reto. Raa ro berur su weto maun kair ana. Mkah mai ro mase mawe, “Raa weto ja mno bo ro mkair mam woyõ-woya sai! Tna ana mawe mama mno bo ro mkair mam kota ranu ye! ");
INSERT INTO ayz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason fi ja yiranya ysya ana weto. Tna yoo ana yse mam amah rait ye. Raa ro Kristen ana mno bo ro mkair miwana bo ro raja Kaisar yawe. Tna ana mkyas mawe Raa sait ro yasom Yesus yamo Raja ro yase.” ");
INSERT INTO ayz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Raa ro Yahudi weto mkyas feto mno raa mrok mnin-nin. Aban mana ro ja mbo kota reto kmo ye. ");
INSERT INTO ayz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tna ana mbis Yason ysya yafoh wait mabo ewok weto moo pitis aro mamo make safo reto. Tna fo raa bitsre ana mamo bana. ");
INSERT INTO ayz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Raa ro Kristen waa kbe raa mno bo ro mkair mai kʼPaulus ysya Silas. Feto to mti reto ana mberuk ana mbewok, mbis ana masen mamoʼt remo ro Berea. Paulus ysya Silas mamo snok mam Berea to, mbewok mamoʼt samu skabuk raa ro Yahudi. ");
INSERT INTO ayz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Raa ro Berea to ja mno bo ro moof. Ana mfi raa ro Tesalonika to fee. Raa ro Berea ksoh toni mari Paulus ysya Silas mkyas Yesus yasom. Rabu ti wawa to raa weto mmat Bokom ro Allah. Mawe mmat re kbe ana mhar bo ro Paulus ykyas to, mamyot mfi Bokom ro Allah fe mfe a. ");
INSERT INTO ayz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tna raa mbam raa mana ro Yahudi mawat mama smot Yesus. Tna raa manes mbam raa mana ro Yunani msya fnya manes wana taro mawat mama smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Menohe raa Yahudi ro mhau mam Tesalonika mari he Paulus ykyas Watum ro Allah mam remo ro Berea ye. Feto tibyo ana baro masen mamoʼt remo reto. Snok mam Berea ana mkyas kair Paulus. Ana mno raa kmo Paulus. Tna mawe kʼraa makin mawe, “Nri bokyas rait ma!” ");
INSERT INTO ayz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Raa mana ro Kristen mari feto tna sobu Paulus mawe, “Nasen nsam wai namoʼt Atena wia.” (Atena to kota sau ro mhau kene mam aya sawan maam.) Silas ysya Timotius mawe ana mbewok mhau akus mam Berea wea. ");
INSERT INTO ayz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tna raa betne Paulus yamo snok kota ro Atena tna Paulus yawe kʼana yawe, “Hah ne nmoʼt Berea nbis Silas ysya Timotius mama srot mrof jõ.” Tna ana ro riwai betne Paulus weto hah me mamoʼt Berea. ");
INSERT INTO ayz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wore Paulus ste ana wea mam Atena to, ait sraujin toni ymat bo raa ro kota reto ja smot berhala msis. ");
INSERT INTO ayz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tna re ait yamoʼt samu skabuk ykyas bo ysya raa ro Yahudi tna msya raa rabin roto ro ja smot Allah ye to. Tna rabu ti wawa Ait ykyas bo ysya raa ro ait fri mam pasar to ye. ");
INSERT INTO ayz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tna ait ykyas bo ysya guru ro ja kro bonaut ro bi Epikuros tna ysya guru ro ja watum bonaut wana mam samu sau ro masom Stoa ye. Paulus santri bo ysya raa ro kro bonaut weto to tna ana baro mawe kair ait mawe, “Bi ait refi yhar bo bawya ee? Ait yhar bo kebet baro sai menohe ait yasoh mase toni syok!” Ana taro mnaut mawe, “Ait ykyas kabes raa ro rabin roto taro meto.” (Paulus ykyas Yesus kʼana yawe Ait yrok yasen oh mi raa mkyas bo reto.) ");
INSERT INTO ayz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tna raa mfot Paulus makah mamo msan kʼraa ro beah srah mam Faut ro Areopagus. Mam weto ana mawe kʼait mawe, “Sik nkyas bokyas ro tna reto kʼamu re amu nri ye. ");
INSERT INTO ayz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Bo ro nyõ nkyas reto to, bokyas ro tna fares. Sik betoo maja rau afo re amu nri tna nhar.” ");
INSERT INTO ayz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Raa ro Atena beta msya raa srim ro mhau mam beto to ana ksoh mari tna mkyas bo ro tna rioh sai.) ");
INSERT INTO ayz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","23","Paulus yasen yros mam wore raa siret mam Faut ro Areopagus reto yawe, “Anu raa ro Atena; jõ tamo te mam kota ranu to, tna tmat berhala msis. Jõ trok tawe anu to raa ro mur-mur smot dewa sor. Tna jõ tmat wohat mkah bo anu nsan bosan kʼdewa weto ye. Tna mam wohat sau raa mkom: ‘Wohat refo fo mkah raa msan bosan kʼallah sau ro ja raa wase.’ Allah ro anu smot menohe wase fares retait oh mi mfo refo Jõ tkyas kʼanu nri mefo. ");
INSERT INTO ayz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Allah ro yase retait, Ait yase yfen arin aso msya bombra beta, Ait oh mi yase ybo tabam msya ayoh to. Ait yhau mam samu ro raa sgi fee! ");
INSERT INTO ayz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Bo rAit ro yse to aro mabut fee. Ait yayoh bo kʼraa sai fee. Ait oh mi yoo roon yee kʼraa. Ait oh mi yoo mafos rana yee kʼraa beta. Ait oh mi yoo bombra beta yee to. ");
INSERT INTO ayz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tiwya tinyi Allah yfen Adam wia. Tna mbam Adam Ait yfen raa mana beta. Yno ana betru tabam refo beta to. Ait oh mi ybis yawe anu raa sait-sait bhau mam makyon wore wo ait yme mabe ait. Tna yno raa mana mhau mam oo wana hayah-hayah wore ana mhau bo to. ");
INSERT INTO ayz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Allah yfen raa afo re kbe ana saso Ait. Ait ksoh yawe raa ro saso Ait to. Yawe anu raa bkai Ait saah. Raa tru Ait saah. Ait yros rit fee. ");
INSERT INTO ayz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ait oh mi yoo yatak rAit yee tibyo anu baam, anu bnah to. Tna yno re anu bhau bno bo wanu ye bo to. Tiwya raa wanu ro ja sair bomna baro mawe, ‘Anu wefo beta ku ro Allah wAit ye.’ ");
INSERT INTO ayz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Anu fo ku ro Allah wAit beta tna anu baam tna bnah-nah ye. Feto to jõ tkyas kʼanu tawe Allah, ro yare anu to, Ait raa ro yaam ye tu oh. Nnaut nwe Allah tait yfi berhala ro raa mfen mbam fraa, emas, msya perak bo ma. ");
INSERT INTO ayz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Raa ro tiwya tinyi wase Allah to, ana mno-na bo sai. Tna Allah yros sayõ. Menohe mfo refo Ait ybis raa ro tabam refo beta yawe ana mashana tna smot Ait beta oh. ");
INSERT INTO ayz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Allah ymah oon yawe meen ait yama ytu srah raa ro tabam refo beta. Raa sait ro tiwya Ait ysok to, meen yasen ytu srah yari. Ait retait yhar raa mhaf wana beta tna kbe yno bo rAit moof mnan si. Bi Ait retait tiwya yhau mam tabam refo. Tna raa mame yajat. Menohe Allah yno Ait retait yrok yasen. Yno Ait yrok yasen afo re raa beta kbe mhar mawe Ait retait Raa ro Allah ysok.” ");
INSERT INTO ayz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ati ro Paulus yawe raa retait yrok yasen feto, raa taro masah. Menohe ana taro mawe, “Amu ksoh nwe nyõ nama nkyas bo refo kʼamu u.” ");
INSERT INTO ayz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tna Paulus sikba ana yamo. ");
INSERT INTO ayz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Raa ro mari bo ro Paulus ykyas reto, baro kro bonaut rait tna ana mama smot Yesus ye. Ana wefo fo sait yasom Dionisius, (Ait retait raa manes ro ja mtu srah mam Faut ro Areopagus.) ysya fai au ro masom Damaris, tna raa baro naut msya ana ye. ");
INSERT INTO ayz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tna fo Paulus sikba kota ro Atena yamoʼt kota ro Korintus. ");
INSERT INTO ayz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mam weto ait fri raa ro Yahudi sait yasom Akwila. (Ait raa mabe mam provinsi ro Pontus.) Akwila ysya yfain Priskila raa srim. Ana mamaʼt Korintus mbam provinsi ro Italia. (Ati reto to, raja yase ro yasom Klaudius ybo Italia. Ait knait raa ro Yahudi tna ybis ana beta frok mbam kota Roma mamo. Kota ro Roma mhau mam rabin rait ro Italia ye.) Ti ro Paulus ybam Atena yama to, ait yamo yo kʼana mbewok. ");
INSERT INTO ayz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bo ro ja ana mbewok mkah to, ana mfen kemah mnan bo ja Paulus ykah ye. Feto to ait yhau ysya ana mbewok tna ana mkah bo su. ");
INSERT INTO ayz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tna mam ayõ ro raa ntmoh (hari Sabat) yoyo to, ja Paulus yamoʼt samu skabuk ykyas Yesus yasom. Raa ro Yahudi msya raa ro Yunani mama hre mari bo ro ait ykyas. Tna ait tomer yoo ana mhaf afo re ana smot Yesus ye. ");
INSERT INTO ayz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tna Silas ysya Timotius mbam Makedonia mama. Tna Paulus yitsre bo ro ja ykah. Yitsre bo yfen kemah tna ykyas Yesus yasom rabu ti wawa. Ait ykyas kʼraa ro Yahudi yawe, “Yesus tait Mesias.” ");
INSERT INTO ayz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Menohe ana ro mbam raa mana ro Yahudi hawe mari bokyas ro Yesus. Ana kmo tna mamus Paulus. Feto tibyo ait yasen yamo. Tna ait yitut bohasyaf mbam ratan rait reto. Yno feto re kbe ana mhar mawe ait yitsre yatem kʼana yawe, “Soh bo ro mkair btek mai kʼanu to kanyin sai oh! Jõ tasom isti reto fee. Mfo refo jõ tamo tkyas Yesus yasom kʼraa ro mbam raa mana roto makin.” ");
INSERT INTO ayz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tibyo Paulus frok sikba samu skabuk reto tna ykyas bo mam weto u fee. Tna ait yamoʼt samu ro Titus-Yustus ro yhau kene mam weto. Bi Titus-Yustus tait raa ro ja smot Allah. Menohe ait raa mana ro Yahudi fee. Tna Paulus ykyas Yesus yasom mam samu rait reto. ");
INSERT INTO ayz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Raa ro mhau mam Korintus, taro hawe smot Yesus. Menohe taro mawat ksoh mari bokyas ro Paulus ykyas reto. Ana weto mama smot Yesus tna mawe raa baptis ana ye. Ro mrok smot Yesus weto, raa sait yasom Krispus. Ait raa ro Yahudi. Tna ait yamo aban mana ro ja ybo samu skabuk ro agama Yahudi mam kota ro Korintus reto ye. Ait ysya raa ro mhau mam amah rait to, ana beta mama smot Yesus. ");
INSERT INTO ayz_vpl VALUES