﻿USE sofia;
DROP TABLE IF EXISTS sofia.awx_vpl;
CREATE TABLE awx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES awx_vpl WRITE;
INSERT INTO awx_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yakapde hikngä Anätutä kepkät yekäpkät yawän yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","U yawän yiwikin gwenune, kewu moyo wom yiwikut. Tiwän kupilä täkngatä yanggä gwende enetängä yiwikut. Tiwän Anätule Wawunggä yanggä unggwende enetängä kungapgut. ");
INSERT INTO awx_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tixäwik Anätutä using yakut. “Kwakäpä täknga tingalayok,” yawän, kwakäpä täknga tingalakut. ");
INSERT INTO awx_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Tiwän kwakäpä uläknganin kake, täke natäpgut. Tikengä kwakäpä täkngaxät kupilä täkngaxät matäkut. ");
INSERT INTO awx_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Matäke, kwakäpätäne umanä “kwakäpä” yang inikut. Tikengä kupilätäne umanä “kupilä” yang inikut. Tiwän täpduxu yakawu unggwenu tukwake kwakakut. ");
INSERT INTO awx_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Tiwänä Anätutä using yakut. “Yanggä matäwikge, wangga womdu yanggä bänäkängän tingalayok,” yawän, ");
INSERT INTO awx_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","inä u yakut using tike, uwomdä yanggä bänäkängän matäwän, yanggä käwutdu uwomde enetängä yiwän, käwutdu kematde yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tiwän wangga uwomu umanä “yekäp” yang inikut. Tiwän täpduxu 2 unggwenu tukwake kwakakut. ");
INSERT INTO awx_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Tiwänä Anätutä using yakut. “Yanggä yekäp gepbine yiwixaxu womdunekän täku yiwän, womdu koxolä yiwiyok,” yawän, inä u yakut using tikut. ");
INSERT INTO awx_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tiwän koxolä yiwikulu uwomu umanä “kep” yang inike, yanggä u päku yiwikulu umanä “yanggä gwen” yang inikut. Tikengä unin dayike, täke natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Tikengä hipdu using yakut. “Kep däkänetä songäsongä, pa, äwä nak yang alätnong. Tike salinä inäinäne alätnong,” yawän, inä u yakut using alakin. ");
INSERT INTO awx_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kep däkäne songäsongä, pa äwä nak yang doke, salinä inäinäne alakin. Tiwän unin dayike, täke natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Tiwän täpduxu 3 unggwenu tukwake kwakakut. ");
INSERT INTO awx_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Tiwänä Anätutä using yakut. “Kwakäpä täknga äwä kupilä täknga yang tuwängutningge, kakalä gwenggwenu yekäwune alätnong. Tikengä hopä täpduk, gusit täpduk, äwä täpduxu inulung gwenggwen yangu tuwängutning. ");
INSERT INTO awx_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Itä yekäwune yiwike, kep däkäle kwakäpä imining,” yäwan, inä u yakut using alakin. ");
INSERT INTO awx_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Anätutä kakalä inulungu gwenalä pahakut. Kakalänä inulung hikngä gwenu, kwakäpänele tahakut. Tikengä kakalänä mätekngä bimä gwenu, kupilänele tahake, kuminamkäyä pahakut. ");
INSERT INTO awx_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Tikengä kep däkäle kwakäpä imike, kupilä täknga kwakäpä täknga yang matäke daying yiwitningge, yekäwune pewän yiwikin. Tikengä unin dayike, täke natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Tiwän täpduxu 4 unggwenu tukwake kwakakut. ");
INSERT INTO awx_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Tiwänä Anätutä using yakut. “Yanggä gwenkätanu pis, hängä ulung pahanangäsä yangu meya yiwitnong. Tixawän kwäwitkäyä alake, enetängä wepmähikunong,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hängä inulung hikngä täpäläpä yanggä gwenkätan yiwixaying äwä hängä undä ulung tahake yanggä gwenkätanu meyä yiwixaying yangu, inäinäne pahakut. Tixäwik kwäwitkäyä inäinäne undä pahakut. Tikengä unin dayike, täke natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Tikengä hängä u pahakulu, wam gwalängu using yämikut. “Pisu duksäng sakngälake, yanggä gwenu yiwä dopsok. Tixawän kwäwitkäyä kewune meyä sakngälätnong,” yakut. ");
INSERT INTO awx_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Tiwän täpduxu 5 unggwenu tukwake kwakakut. ");
INSERT INTO awx_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Tiwänä Anätutä using yakut. “Kälawu kep däkäne nanä inäinäne alätnong. Kälawu songäne nanä, kälawu äminsak äwä gwakgwak yangu inäinäne alätnong,” yawän, hängä inä u yakut using alakin. ");
INSERT INTO awx_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Anätutä kälawu songäne nanä, kälawu äminsak, äwä gwakgwak yangu inäinäne pahake, unin dayike, täke natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tikengä using yakut. “Äminu nihä bimä pahanim. Tiwän itä hängäläpä yanggäne nanä, kwäwilu enetängä nanä, kälawu songäne nanä, kälawu äminsak, äwä hängäläpä undä kep däkäne nanä yang daying yiwitning,” yake, ");
INSERT INTO awx_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Anätutä äminu inä bimä pahakut. Wäwi mängälä yangu inä hikngä bimä pahakut. ");
INSERT INTO awx_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tikengä wam gwalängu using yämikut. “Engangu meyä dukngisol. Tiwän unetä sakngälake, kewune yiwitäke kuwä dopän, hänga undä daying yiwitnong. Tike pisu yanggäne nanä, äwä kwäwilu enetängä nanä, äwä kälawu kep däkäne nanä yangge kuhiläle yiwitnong,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Tikengä hipdu using yänikut. “Kätak natäpsol. Nätä naxu tämbam salin bimä, pa salin yangu undä naksäle daminggat. ");
INSERT INTO awx_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tiwän songäsongä undä kälap, kwäwit yanggä näningge yäminggat,” yawän inä u yakut using tikin. ");
INSERT INTO awx_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Tiwän Anätutä hängä undä u pahakulunin dayike, täke hikngä natäpgut. Tiwän täpduxu 6 unggwenu tukwake kwakakut. ");
INSERT INTO awx_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Anätutä kepkät yekäpkät pahake, hängäläpä undä inäinäne nomän hikngä pepulukut. ");
INSERT INTO awx_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tiwänä täpduxu 7 gwendä kwakawänu, puyä awahapulukutde, moyo yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tike täpduxu 7 gwenu wam gwaläng imike, tahawän takwän tikut, inale puyä awahapulukutde, täpduxu unggwenune, inä Anätu moyo yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Wamu aläknga kepkät yekäpkät yawän yiwikindäne. Anätu Yawetä kepkät yekäpkät pahakutkätanu, ");
INSERT INTO awx_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","naxu puyäne nanä kep däkäne dondopgin, inale Anätu Yawetä kep gomune hopä dolewän takut, tiwän äminu täpätu kep gomune doyiwike, puyä dowahakut. ");
INSERT INTO awx_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tiwändeyä yanggä kewunetä akoxäwik, kep däkä tänguxawä kwikakut. ");
INSERT INTO awx_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tiwänä Anätu Yawetä kewu päke, ämin kwätäluke, inä kwämanu käluk yiwitnangäsä täknga nomnä gwäk puyäpän, äminu uläpä käluk yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tiwänä Anätu Yawetä gusitdä akonggak käwulune, Idenkätan puyä womdu pahakut. Tikengä äminu uläpä kwätälukulu une tewän yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tixawän Anätu Yawetä pahawän, puyä ulängäne pa kepkätandä inäinäne meyä dopgin. Pa kayitä dayipä täkäningge äwä salinä alawä näningge yang pekut. Ile bänäkänkätanu pa däkäyalä. Däkätule salin nakengu käluk yiwitnangäsä, tiwän däkätule salin nakengu nomän bä wäyi yang natäpnangäsä pekut. ");
INSERT INTO awx_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Puyä ulängäle yanggä imikge, yanggä dupitu Idenkätandä tewän sipgut. Yanggä undupinetäkän upuke, inäinä sipmäke kukinu unekänu 4. ");
INSERT INTO awx_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Yakap dupi umanä Pison. Undupi asipmäke, ku Hawilale kewune kunggak. Kewu uwomu golu käyä. ");
INSERT INTO awx_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Golu uwomune nanä nomän. Tiwän uwomune pa inuxu käpängä gwälam hikngä äwä huwu gwälam hikngä umanä oniks yang yänikayingu käyä. ");
INSERT INTO awx_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Yanggä käwutdu dupi umanä Gihon. Undupi asipmäke, ku Käs kep womune kunggaxunin. ");
INSERT INTO awx_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Yanggä käwutdu 3 dupi umanä Taigris, Asutde gusitdä akonggak käwut sipmänggaxunin. Tiwän 4 dupi umanä Yupretis. ");
INSERT INTO awx_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Anätu Yawetä äminu uläpä puyä ulängä kang yiwikge une tekut. ");
INSERT INTO awx_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Teke wamu kitokngä hikngä täkngatu using inikut. “Gä pa salinu puyä alängäne nanä täkekän näyo. ");
INSERT INTO awx_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tiwändeyä pa nomän bä wäyi yang natäpnangäsä däkätäne salinä manäyo, inale änakengu, täpduxu inä unggwenunekän kupiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tikengä Anätu Yawetä “Äminu inäkän yiwänu nomänundo. Ge gatäkgatäkngäle notnä täpätu tahawit,” yake, ");
INSERT INTO awx_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","kepdä kälawu kewune nanä äwä kwäwilu enetängä nanä pahakut yangu “Äminu uläpätä dayike umanä dasingga yäniwik?” yake, päkapgut. Tiwän itä dayike, umanä dasingga yänikulu, umanä unin. ");
INSERT INTO awx_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Äminu uläpätä kälap, kwäwit äwä hängäläpä ämindä daying yiwitnangäsä yangu umanä undä yänikut. Tike teyä gatäkgatäkngäle äläwambän malikut. ");
INSERT INTO awx_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ge Anätu Yawetä tahawän, äminu uläpä däpmunä kupsä hikngä pekut. Awexawänä, äminu uläpäle täkäpulä täpätu täkengä, hipdu gupnätä tahang umukut. ");
INSERT INTO awx_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tikengä mängälä täpä äminu uläpäle täkäpulä täkutdä kwätälukut. Tikengä mängälä uläpä wäwi uläpätä käwikge täkapgut. ");
INSERT INTO awx_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Täkapän kakuläkaxäwik using yakut. “Ile kwätänu näle kwätän, tiwän ile guwu näle gup. Äminu uläpä wäwile tängänetä kwätälukut. Ge umanä ‘mängälä,’” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ge ile tiwän, wäwi nanämingä peke, mängätnäxät unekän gatäke yiwä, gupnä buläkänu däkngäkaying. ");
INSERT INTO awx_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wäwi uläpäxät mängätnäxälu belum yiwixäwik geyä, domäyäkakumäläk. ");
INSERT INTO awx_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Anätu Yawetä hängä dakngä käyä pahakutkätanu, gomoxu äminu kem yänikäxäluwikge nomän hikngä. Ge mängälä täpä yawänyaxu using inikut. “Anätutä ‘Pa salinu puyä alängäne nanä manahol,’ yangu hiyäkände hikngä danikut?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Iniwän mängälä täpätä using inikut. “Pa salinu alängäne nanä täke nahim. ");
INSERT INTO awx_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Tiwändeyä Anätutä using ninikut. ‘Pa puyä bänäkän nanä däkäle salinu manahol. Tike kätakgaxäyä malahol. Using tahakengu axumsimäläk,’ yang ninikut,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yawän gomokgä inikut. “Doxumsimäläk. ");
INSERT INTO awx_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Anätu using natäpgut. ‘Unin nakengu, kayi kakalä tining. Tiwän nina bimä däkngake, nomän bä wäyi yang natäpsimäläk,’ yang natäke usingu ile danikut,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mängälä täpätä pa undäkäle salinu kayitä dayipän, nomän tiwä, nänangäsä tikin. Tiwän unin napän, natädetdetnä käyä tiwikge natäpgut. Ge unin päke naxäwik, käwutdu ayäle imän nakut. ");
INSERT INTO awx_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Unin napät, natdetdetnä kakalawä, “Belum yiwixamäk,” yang natäpgumäläk. Tikengä pa “fixu” däkätule täm päke, gupnä wamäng umukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tukwatde kewu axwikaxawän, wäwi täpä äwä mängätnä yanggä natäxawälu, Anätu Yawe puyä tängäne apuhiwän kake, pa yäpuli däkändäkäxätan kohopikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tiwändeyä Anätu Yawetä wäwi täpä using inikut. “Adam, gä sandan?” yawän, ");
INSERT INTO awx_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","using yakut. “Puyäxätan apuhiwi kake, nä belum yiwitde änaxälake kohopinggat,” yakut. ");
INSERT INTO awx_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yawän Anätutä inikut. “Gä belum yangu imindä ganik? Pa salinu donapiläkge ganikumu imindä ganiwän naläk?” yawän, ");
INSERT INTO awx_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adamdä “Mängälä näxätde tekuläxu aläpätä pa salinu notnä anamän nat,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tiwän Anätu Yawetä mängälä uläpä “Uläknga inale tahaläk?” yang iniwän, mängälätä “Gomokgä kem naniwän nat,” yakut. ");
INSERT INTO awx_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yawänä Anätu Yawetä gomoxu using inikut. “Uläknga tahaläkge, tokngä wam yäwa, gä gikakän tokngä däkä päpiläk. Tike kälawu äminsak äwä songäne nanä yangu tokngä dowäning. Gä täpduktäpduk yiwiläxu, kep däkäne muhipdatä pengwähake tihikuxawi, muluwu mapdaxätan kopning. ");
INSERT INTO awx_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Tiwän nätä pahawa, gäxät mängälä täpäxät iwaliwalnä däkngahimäläk. Tiwän gäle bapuka mängälä täpäle bapunä yangkäyä usäkän yiwitäke kuning. Tiwän ile bapunätä kuhitda yayiwä, gätä bälängäne yähawiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Inikengä mängälä täpä using inikut. “Engangga tängäkane kaya tiwänu, meyä däkä gamit. Tiwän tokngämbam päxäwik, engangu dukngiwiläk. Tike teyä apdale natänggämätawi, itä kuhitdale yiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Inikengä, wäwi uläpä using inikut. “Mängätdale wam gwälamike, pa salinu donapiläkge kitokngä ganikumu naläk. Ge gäle tiwän, tokngä wam yäwa, kep däkä maliwik. Ge täpduk täpduxu yiwiläxu, tokngämbam päxäwik, kep däkä yamäpuke, puyä pahawiläk. ");
INSERT INTO awx_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tiwän unetäkänu kep däkäne songäsongä pälangänä käyä doke bupning. Tiwän kwätäl pahakengä, naxu puyäne nanä napiläk. ");
INSERT INTO awx_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Puyä mepgämän bulak pahawiyä, naxu alawä napiläk. Usinggän pahahika, hipduka kewune kuwiläk, inale gä unetä alakuläk. Gä kepdä kwätalukum. Ge hipduka kep däkäne kuwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamdä mängätnä “Äminbamu käluk yiwitning täpäläpäle apekngä däkngawik,” yake, umanä Iv yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Anätu Yawetä täwixu kälap gupdä Adamkät Ivkätde pahake yämikut. ");
INSERT INTO awx_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tikengä using yakut. “Wäwi aläpä nihä bimä andäkngake, nomän bä wäyi yangu anatäxak. Ge pa käluk yiwitnangäsä däkätäne salinä nake, käluxu iwikge yiwiyäk” yake, ");
INSERT INTO awx_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","puyä Idenkätanu ulängänetä täwakut. “Anätu Yawetä äminu uläpä kepdä kwätalukum. Ge äminu uläpä kewu undäkäne yamäpuke pahawik,” yake, ");
INSERT INTO awx_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","täwambän epuxukut. Tiwän puyä ulängä gusitdä akonggak käwutkätan, ängela kerup yang yänikaying täpäläpäxät gwäwäyä täpätuxät pewän kang yiwikin. Keruwu uläpäläpä kitokngänä kayä. Tiwän gwäwäyä uläpäne, däki ayähakoxawä kungapgut. Anätutä unin pewän, itä pa käluk yiwitnangäsä däkäle kahilu kang yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu mängätnä Ivkät yiwikumäläk. Tiwän tängene käyä tiwänä, wawakngä täpätu dukngikut. Tikengä “Yawetä gatängamän, wäwi täpätu kake tät,” yake, umanä Ken yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tikengä yiwitäke kuhika, Kende ulawu, Abel, dukngikut. Uläpäyalu inulung täpäyat tike, Abelu sipsip daying yiwixawän, Kenu nak puyä pahakakut. ");
INSERT INTO awx_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Gwendune Kendä naxu puyäne nanä päke, Yawele ofa tahakut. ");
INSERT INTO awx_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tixawän Abelu sipsip mätexu yakap pekin gwengwenu ofale päkut. Tikengä sipsip mätexu sipmäke matäke, gwaxu nomängän tahakut, ofanän. Unin imän, Yawetä Abelkät ofanäxätde täke natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tike Kenkät ofanäxätde mähe natäpgut. Ile tiwän Kenu tokngä hikngä natäpän, nomnä malikin. ");
INSERT INTO awx_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Tiwän Yawetä Kenu using inikut. “Tokngä inale natäxaläk? Nomda inale malikaying? ");
INSERT INTO awx_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nomän täknga tahawi gandupa, täke tiwik yangu donatäläk? Tike nomänu dolahawi, wäyi täknga angguwikge yämäkane yiwixak. Kuhitdale yiwikge natänggämatanggak. Tiwändeyä gäta yapmike, ile kuhiläle yiwike, wäyi täknga mawahayo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tiwänä Kendä ulapnä iniwän, songäxätan kukumäläk. Täku une tänguwän kumgut. ");
INSERT INTO awx_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tiwänä Yawetä Kenu using inikut. “Ulapda Abelu sandan?” yang iniwän, Kendä using inikut. “Doxat. Inale naninggaläk? Nä ile kula tahanggalunin?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Tiwän Yawetä using inikut. “Wäyi uläknga inale tahaläk? Natäpso. Ulapdale daxu kepkätandä kwänämu näle tikgak. ");
INSERT INTO awx_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Gätä notda tänguwi kupän, ile daxu kepkätan kuying. Ge tokngä wam yake, kewu awomunetä gäwämba kuwiläk. ");
INSERT INTO awx_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ku kewune puyä pahawi, naxu doalätning. Tiwän gä yotda wenä tiwän, kep gomune täwake tihikuwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tiwän Kendä yakut. “Meyä namiläxu inulung hikngä. Nätä pänangäsändo. ");
INSERT INTO awx_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kewu awomunetä gäle nomune doyiwitde anäwaxaläk. Yotna wenä tiwän, kep gomune tawake tihikuwa, imindäka nandukengu, anuwän kupit,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yawän Yawetä inikut. “Äminu täpätutä guwän kupi, meyä gäle gamilu ayapmike, meyä 7 inulung äminu uläpätä päpik,” yang inikut. Tikengä “Ämindä kake, tänguwä kumsäk,” yake, Kenu tuwäng tengämikut. ");
INSERT INTO awx_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tiwän Kenu Yawe äwä kewu Idenu uwom yang peke, gusitdä akonggak käwutkätan kewu womdu, umanä “Tihikuktihikuk” uwomune päku yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Tikengä mängätnäxät yiwihika, mängätnä tängene käyä tiwän, wawakngä Enok dukngikut. Tiwän Kendä yolu gäpanggu tahake, unggäpangu Enok yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Tiwänä yiwitäke kuhika, Enokgä wawakngä Irat towimbänä, Iratdä Mehujael towimbänä, Mehujaeldä Metusael towimbänä, Metusaeldä Lamek towikut. ");
INSERT INTO awx_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Tiwänä Lamexu mängätnä täpäyalä päkut. Täpätu umanä Ada, tiwän täpätu Sila. ");
INSERT INTO awx_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Jabal dukngikut. Tiwänä Jabalde bapunä mahande alakindä selyot päku kewu womduwomdu tapike yiwixäwik, kälawu äminsak towikakin. ");
INSERT INTO awx_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabalde ulawu umanä Jubal. Tiwänä Jubalde bapunä mahande alakindä gita sipmäxäwik, pipip puyäkakin. ");
INSERT INTO awx_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silaxäyä wawakngä dukngikut. Umanä Tubal-Ken. Itä hängä puyä pahanangäsä bä amäk pahanangäsa yangu ain äwä kapa yanggä pahakut. Tiwän haminäle umanu Nama. ");
INSERT INTO awx_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Gwendune Lamekgä mängätnä using yänikut. “Adaxät Silaxät, natäxasol. Mängätna, wamu nätä yäwa, mäläk pähol. Äminu täpätutä dak nuwänu, nätä äminu uläpä alänguwa kupik. Tike wawakdäkä täpätutä nä nuwänu, ixäyä kupsäle tänguwit. ");
INSERT INTO awx_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Äminu täpätutä Ken tängukengu, meyä 7 inulung päpik. Tiwändeyä äminu täpätu nä nukengu, meyä Kendäne ayapmike, inulung hikngä 77 päpik,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu mängätnäxät hipdu yiwikumäläk. Tiwänä mängätnätä wawakngä täpätu dukngike, “Kendä Abel tänguwän kumgutde, Anätutä engangu Abelde tangge namik,” yake, umanä Set yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Tiwänä yiwitäke kuhika, Selu wawakngä towike, umanä Enos yang inikut. Täpduxu unggwenggwenkätanu ämindä tumuxu Yawele käluk yakin. ");
INSERT INTO awx_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Wamu aläknga Adamde bapunä yiwitäkapgindäne temginunin. Anätutä ämin pahakengu, inä bimä pahakut. ");
INSERT INTO awx_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","U pahakulu wäwi, mängälä yang pahake, bänip kwikwik yämikut. Tikenga umanä “ämin” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tiwän Adamu krismasnä 130 yiwikengä, wawakngä inä hikngä bimä towikut. Towikengä umanä Set yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Tikengä krismasu 800 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Unekänu krismasnä 930 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tiwän Selu krismasnä 105 yiwikengä, Enosde nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Tikengä krismasu 807 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Unekänu krismasnä 912 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tiwän Enosu Krismasnä 90 yiwikengä, Kenande nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Tikengä krismasu 815 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Unekänu krismasnä 905 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tiwän Kenanu krismasnä 70 yiwikengä, Mahalalelde nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Tikengä krismasu 840 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Unekänu krismasnä 910 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tiwän Mahalalelu krismasnä 65 yiwikengä, Jaretde nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Tikengä krismasu 830 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Unekänu krismasnä 895 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tiwän Jarelu krismasnä 162 yiwikengä, Enokge nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Tikengä krismasu 800 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Unekänu krismasnä 962 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tiwän Enoxu krismansnä 65 yiwikengä, Metuselale nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Tikengä Anätuxät gatäke yiwikumäläxu, krismasu 300 yiwikut. Yiwixäwixu, wawak yäpanä une towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Unekänu krismasnä 365 yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Tiwänä Anätuxät gatäke yiwike, Anätutä täkut. Tiwän doxakin. ");
INSERT INTO awx_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tiwän Metusela krismasnä 187 yiwikengä, Lamekge nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Tikengä krismasu 782 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Unekänu krismasnä 969 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tiwän Lamexu krismasnä 182 yiwikengä, wawakngä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Dungikengä, using yakut. “Yawetä tokngä wam yake, kep tahawän malikutde, puyä kitokngä pahake, meyä päkamäng. Tiwändeyä mahande engangu aläpätä yiwitäkaxu äpme nimik,” yang yake umanä Noa yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Tikengä krismasu 595 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Unekänu krismasnä 777 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tiwän Noa krismasnä 500 yiwikengä, Sem, Ham, Jafet yangge nanä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Äminu kewune yupsänggän sakngälaxäwik, yäpanä dukngikin. ");
INSERT INTO awx_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tixawän Anätule wawak täpäläpätä äminde yäpa dayipä, gwälam hikngä tixawä, daying butaxäwik, mängätnäle päkin. ");
INSERT INTO awx_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tiwän Yawetä using yakut. “Äminu kitokngänä wenä. Ge käluk iwikiwixu dowewa yiwitning, kewunen. Tike krismasu 120-kän yiwixäwik kumning,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tiwän täpduxu uwomkätan äwä mahande yiwikin yangu Anätule wawakgä äminde yäpa päpä, ixät yiwike, engangä dukngikinu äminu äyapmike, inulung hikngä täpäläpä täkake, kitokngänä käyä tikin. Tiwän umanä käyä tikin. ");
INSERT INTO awx_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tiwän Yawetä dayipänu, äminbamu yiwiyiwikngä kekem hikngä tiwän, bäniyäne wäyi pahaninggekän natänggämätakin. ");
INSERT INTO awx_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Tiwän äminu kewune pahakutde, meyä hikngä natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Natäke yakut. “Äminu pahakumde, meyä natäxat. Ge äminu undä pahawa hopining. Hängä kewune yiwixaying äwä awepmäke tihikukaying yangu awahawa hopining,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tiwändeyä Noale bänip gwaläng natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noale wam. Noa äminomän täpä. Äminu kewu anggomune yiwikinkätanu Anätule kayine Noatäkän gutongänä wenä yiwikut, inale Anätuxät gatäke yiwikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noale wawaxu täpäyalä täpätu. Umanä Sem, Ham, Jafet yang. ");
INSERT INTO awx_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Anätule kayine äminbamu notnä sipmäxäwik, wäyi hikngä yiwixakin. ");
INSERT INTO awx_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tiwän Anätutä dayipänu, kewune nanä äminu gutongä hikngä yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tinggawän Anätutä Noa using inikut. “Äminbamu äminsipmäk täknga tahake yiwixaying. Ge hängä undä käluk yiwixayingu awahawa hopining. Hängä undä äwä kep gom yang pahawa hopining. ");
INSERT INTO awx_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Ge gä siwu gwendu pa nomän päke tahayo. Tikengä okopixätanu ämindä yiwitningge äwä kälapdä yiwitningge, inäinä matäke peyo. Tikengä yanggätä kopnäng yakengu, okopi käwut kepmän käwut yangu koltatä pahayo. ");
INSERT INTO awx_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“Sip gwenu using tahayo. Belakngänä 140 mita, kwalangänä 23 mita, tiwän dämnä 13.5 mita tahayo. ");
INSERT INTO awx_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tiwänä nomnäne gänangä mätekngä hap mita tewi kungapsok. Tiwän yolu gwenalä gwendu pahayo; yäpuline gwendu, bänäkänu gwendu, äwä nomnäne gwendu yang. Tikengä yämä däkä teyo. ");
INSERT INTO awx_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Nätä yanggä inulung tewa, kewu anggomu yiwikdoke pänguhiwik. Tiwän hängä kewune nanä käluk yiwixayingu undä pahawa hopining. Tiwän hängä undä käluk yiwixayingu axumning. ");
INSERT INTO awx_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","“Tiwändeyä nätä kontraknga gäle tahawa, sip gwenune kopiläk. Gä, wawakga, ile mängätnä, äwä gika mängät yang kopning. ");
INSERT INTO awx_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Gikaxät käluk yiwitningge, hängä haxalike tihikuke yiwixayingu ayä mängätnä yang päko peyo. ");
INSERT INTO awx_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Hängä kewune tihikukaying, awepmäke tihikukaying yangu ayä mängätnä yang gäle apning, käluk yiwitninggen. ");
INSERT INTO awx_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ge naxu gika äwä hängä uläkwäk yanggä naningge, inäinäne peyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Tiwän Noa Anätutä yakut using tawake pahakut. ");
INSERT INTO awx_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Täpdukngätä apän, Yawetä Noa inikut. “Äminu ayiwixayingkätanu, nätä gandupa, äminomänu gäkän. Ge gin yänggwälu undä sip gwenkätan kopnong. ");
INSERT INTO awx_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Gwaxu nomänu inäinä, äwä kwäwilu inäinä, mängälä 7, wäwi 7 yang päyo. Tikengu gwaxu nomänundo täpäläpä, mängälä gwendu, wäwi gwendu yanggän pätäke kuyo. Ge uläkwäkgäyä kewune sakngälawik. ");
INSERT INTO awx_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Anggwenunetä täpduxu 7 yiwikengä, hopä tewa, kwakäpäne kupiläne yang takuhixawän, ku täpduxu 40 apuxuwik. Tiwän hängäläpä kewu anggomune nina pekumu, undä pahawa hopining,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tiwän Yawetä u yakut using tawake pahakut. ");
INSERT INTO awx_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa krismasnä 600 yiwixawän, yanggätä kep gomu yiwikdoke pänguhikut. ");
INSERT INTO awx_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa, mängätnä, wawakngä, äwä wawakngäle mängät yang, “Yanggätä nihipsäk,” yake, sip gwenune kopgin. ");
INSERT INTO awx_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Gwaxu nomän, gwaxu nomänundo, äwä kwäwit yangu ayä mängätnä yang ");
INSERT INTO awx_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sip gwenune kopgin, Anätutä Noa inikut using. ");
INSERT INTO awx_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Täpduxu Anätutä yakut using 7 gwendä apän, yanggä une sipgin. ");
INSERT INTO awx_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa krismasnä 600 tixawän, yekäwu 2 gwende täpduxu 17 gwenune kep gomu gänanggänangäkän tixawä, yanggä undandä akopgin. Tixawän yekäpde yämäxäyä wangga tixawä, ");
INSERT INTO awx_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","hopä takuhixawän, ku täpduxu 40 apuxukut. ");
INSERT INTO awx_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Inä täpduxu unggwenunekänu, Noa, mängätnä, wawakngä äwä wawakngä uläkwäkge mängät yang siwune kopgin. ");
INSERT INTO awx_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tiwän hängä kewune alihikuke yiwixaying, awepmäke tihikukaying, inulung, mätekngä yang undä kopgin. ");
INSERT INTO awx_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Hängä undä mepme pexayingu gwenalänänäxäyä apä, sipkätan Noaxät using kopgin. ");
INSERT INTO awx_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anätutä Noa inikut using, hängä undä u kopginu, mangätnä ayä yang kopgin. Tiwänä Yawetä yämä däkä tahakuhikut. ");
INSERT INTO awx_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tiwänä yanggä kepkätandä akoxawä, hopä alakuhixawän, täpduxu 40 apuxukut. Yanggätä yiwikdoke, sip gwenu enen hikngä tängenakut. ");
INSERT INTO awx_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yanggätä inulung hikngä yiwitexäwik, sip gwenu täpän tayikut. ");
INSERT INTO awx_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tiwän unetäkän yanggä inulung hikngä yiwitexäwik, täwalu belakngä däkändäkä undä pänguhikut. ");
INSERT INTO awx_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Pänguhike, täwalu 7 mita ko yapmikut. ");
INSERT INTO awx_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tikengä hängä kewune tihikukaying, kwäwit, hängä inulung, mätekngä äwä ämin yangu undä pänguhiwän kumgin. ");
INSERT INTO awx_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Hängä täpä mepme pexäwik, kep däkäne tihikuke yiwixayingu, undä hikngä kumgin. ");
INSERT INTO awx_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tiwän hängäläpä kep däkäne nanä undä pahawän hopikin. Tike Noaxät siwune yiwikindäkän käluxu yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tiwän yanggä ayiwikut täkngane using yiwixawän, ku täpduxu 150 apgut. ");
INSERT INTO awx_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tixawän Anätutä Noa äwä hängäläpä ixät sipkätan yiwikinde natäke, kwämanu tewän puyäpän, yanggä teke pukukut. ");
INSERT INTO awx_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tiwän kep gomu gänanggänangä tiwä, yanggä akopginu gwätnakin. Tixawän yekäpde yämäxayä wangga tikinu apu umumbä, hopä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Yanggä wepdäwepdä teke pukuxawängän, täpduxu 150 apgut. ");
INSERT INTO awx_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tiwän yekäwu 7 gwende täpduxu 17 gwenune siwu täku, täwalu Alalatkätanu däkätune yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tixawän yanggä hipdu teke pukuxawän, yekäwu 10 gwende täpduxu 1 gwenune täwalde nomnä alanggämän tikin. ");
INSERT INTO awx_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ge täpduxu 40 apänä, Noa sipde windua sike, ");
INSERT INTO awx_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","käpämu gwendu tatewän kungu, yanggä doleke pukukutnä kake, enetängä wepmähikuxawän, yanggä gwenu teke pukukut. ");
INSERT INTO awx_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Tiwän Noa yiwän maliwän, yanggä ambä teke pukuk yake, kombunanangu gwendu tatewän, wepmäke kukut. ");
INSERT INTO awx_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Yanggätäkän yiwikutde, kombunanangu unggwenu ayiwitnangäsä wenä tiwän kake, hipdu wepmäke apän, tätekut. ");
INSERT INTO awx_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tikengä täpduxu 7 yiwike, kombunanangu unggwenu hipdu tatewän kukut. ");
INSERT INTO awx_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ku tihikuhika tukwatdeyä, pa “oliwu” däkätule tämu käluxu handu mayätä ihinggänggänuke, täkapän kakut. Unin kakengä, Noa “Yanggä gwenu aleke pukukngä tinggak,” yangu natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tikengä hipdu täpduxu 7 yiwike, kombunanangu tätewän kukengu, doapgut. ");
INSERT INTO awx_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa krismasnä 601 tixawän, yekäwu 1 gwende täpduxu 1 gwenune yanggä gwenu teke pukukut. Tiwän sip gwen tahangumukulunin wäsike, unetä kewu koxolä bimä alikutnä kakut. ");
INSERT INTO awx_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tixawänä yekäwu 2 gwende täpduxu 27 gwenune kep gomu koxolä hikngä tikut. ");
INSERT INTO awx_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tiwän koxotawänä, Anätutä Noa inikut. ");
INSERT INTO awx_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Gika, mängätda, wawakga, äwä wawakgale mängät yangu teke epuxuxut, sip gwenun. ");
INSERT INTO awx_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hängä undä gäxät yiwixayingu, kewune sakngälake yiwitäke kuwä dopikge, päke epuxuyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tiwän Noa, mängätnä, wawakngä, äwä wawakngäle mängät yangu siwu teke epuxukin. ");
INSERT INTO awx_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tixawän kälap, kwäwit, gwakgwak, undä uläpäläpähimkäyä teke epuxukin. ");
INSERT INTO awx_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tiwän Noatä alta tahake, gwaxu nomän äwä kwäwilu nomän yangu gwendu gwendu päke sipmäke, däkine Yawele hakut. ");
INSERT INTO awx_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Häwän, Yawetä ile käpängu gwälam tiwän natäke, bäniyäne using natäpgut. “Äpmanu ämindä yiwikmaliwä, kewu andäka tokngä wamu hipdu dohikngä yake tahawa maliwik. Engangunetä äminbamu wäyi täkngaläknga pahaninggekän natänggämätäkaying. Tiwändeyä mahande u pahawa malikin usingu, hängäläpä undä käluk yiwixayingu dowahawa malining. ");
INSERT INTO awx_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ge unin. Kewu anggomu using yiwixawängän, puyä dändän, bulä nak pänangäsä dändän, o gusit dändän, hopä dändän, kwakäpä bä kupilä yanggäkän apukaning,” yang yakut, Yawetän. ");
INSERT INTO awx_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Anätutä Noa, wawakngä yangu wam gwalängu using yämikut. “Ginu engangu meyä dukngitnong. Tiwän unetä sakngälake, kewune yiwitäke kuwä dopsok. ");
INSERT INTO awx_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tiwän kälawu undä kep däkäne nanä, kwäwilu enetängä nanä, äwä pisu yanggäne nanä yangu ginde kätaxune pexat. Ge gindä kuhiläle yiwä, itä dandung naxälatning. ");
INSERT INTO awx_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","“Naxu puyäne nanä tupä damikum usinggän, kälapkäyä using näningge daminggat. ");
INSERT INTO awx_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tiwändeyä gwaxu dakngäxälu manänong, inale käluk yiwitnangäsä täknga daxune yiwixak. ");
INSERT INTO awx_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Tike äminu täpätutä ämin notnä tänguwän kupänu, yäkwäle ile dakge nätä tokngä däkä imit. Tike kälawu täpätutä äminu täpätu tänguwän kupänu, ixäyä kupsäle tänguwit, ");
INSERT INTO awx_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","inale Anätutä äminu inä bimä pahakut. Ge imindäka äminu täpätu tänguwän kupänu, äminu uläpä ämin notnätä tänguwä kupik. ");
INSERT INTO awx_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Ginu, engangu meyä dukngitnong. Tiwän kewune äminu meyä yiwitning,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tikengä Anätutä Noa wawakngä yangu hipdu using yänikut. ");
INSERT INTO awx_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","“Nätä kontraknga gin, bapuhä mahande yiwitning, hängä undä ginkät yiwike siwunetä epuxuying, äwä kewune nanä undä mahande yiwitning yangge tahanggat. ");
INSERT INTO awx_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kontraknga using tahanggat. Hipdu hängä käluk yiwixayingu undä yanggätä doyäwa pahawän hopining. Tiwän kewu anggomkäyä yanggätä doyäwa tahawän maliwik,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yänike, unetäkänu using yänikut. “Kontraxu gin äwä hängäläpä käluk yiwixaying yangge tahake, tuwängu täkngatu texat. Ge kontraxu aläknga iwikge yiwixäwik. ");
INSERT INTO awx_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Kontraxu kewune nanäle tahanggalu uläkngale tuwängge, sawilakwäna mingädäkäne texat. ");
INSERT INTO awx_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yekawune mingändäkä pewa umumbä, sawilakwändä une alawänu, ");
INSERT INTO awx_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kontrakngale natäpit. Tikengä hängäläpä käluk yiwixayingu undä yanggätä hipdu dowahawa malining. ");
INSERT INTO awx_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Sawilakwänu mingändäkäne alawän kakengu, kontraxu iwikiwik yiwikge, ginu kep däkäne nanä undäle tahanggalu uläkngale natäpit. ");
INSERT INTO awx_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kontraxu kep däkäne nanä undäle tahat täkngale tuwängu uläknga texat,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noale wawaxu siwunetä epuxukinu, Sem, Ham, Jafet yang. Tiwänä Hamu wawakngä täpätu umanä Kenan. ");
INSERT INTO awx_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noale wawaxu aläkwäkgä äminu undä kep däkäne yiwixayingge bapunä däkngakin. ");
INSERT INTO awx_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa nak puyä pahakakut. Pahake yakapde itä wain puyä pahakut. ");
INSERT INTO awx_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Gwendune Noa wain tängoke datdawuke, täwikngä päpän epä, selyotnäne belum pekut. ");
INSERT INTO awx_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Tixawän Hamu Kenande nanä, selyolune ko, nanä belum pekgawän kake, epuxu notnä täpäyalu yänikut. ");
INSERT INTO awx_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Yäniwän Semkät Jafetkätdä täwixu kwämbätdu täke, gwälamnäne mehe käwut mapät epgut. “Nanit kähäm,” yake, mahatä täko, nanä omikngämikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa andatdawukulu wenä tiwä enake, wawakngä wasekngä täpätä u tahakulunin natäke, using inikut. ");
INSERT INTO awx_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“Kenanu tokngä däkä päpik. Notnäle gepbine yiwixäwik, ile puyä däkä pahangyämik,” yang inike, ");
INSERT INTO awx_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","unetäkänu using yakut. “Yawe, Semde Anätunä, ile uman yatängenatnim. Tiwän Kenanu Semde gepbine yiwixäwik, ile puyä däkä pahangämik. ");
INSERT INTO awx_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anätutä tahawän, Jafelu bapunä meyä tiwä, kewune yiwitäke kuning. Tiwän Jafetde bapunäxät Semde bapunäxälu unekän gatäke yiwitning. Tiwändeyä Kenanu Jafetde gepbine yiwixäwik, ile puyä däkäxäyä pahangämik,” yang yakut, Noatän. ");
INSERT INTO awx_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Yanggä gwendä yiwikdoke pänguhiwän, Noa krismasu 350 yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Unekänu krismasnä 950 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Kewu yanggätä yiwikdoke pänguhiwän, Noale wawaxu Sem, Ham äwä Jafet yanggä wawakngä towikindäne. ");
INSERT INTO awx_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafetde wawaxu umanä Gomer, Magok, Madai, Jawan, Tubal, Mesek, äwä Tiras yang. ");
INSERT INTO awx_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Tiwänä Gomerde wawaxu umanä Askenas, Ripat, äwä Togama yang. ");
INSERT INTO awx_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Tiwän Jawande wawaxu umanä Elisa, Tasis, äminu Saiprus nanä, äwä Dodan nanä yang. ");
INSERT INTO awx_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Unetä sakngälawän uhike, yanggä kwayimune päku, bapunäne, wamnäne ku kepnä päxäwik, kantrinä inäinä yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Tiwän Hamde wawaxu umanä Kus, Isip, Libia, äwä Kenan yang. ");
INSERT INTO awx_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Tiwänä Kusde wawaxu umanä Seba, Hawila, Sapta, Rama, äwä Sapteka yang. Tiwänä Ramale wawaxu umanä Seba äwä Dedan yang. ");
INSERT INTO awx_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Inä Kusde wawakgänu täpätu umanä Nimrot. Uläpä kitokngänä inulung tiwän, yolu gäpangguyine nanä äminu axu sipmäxäwik, kuhiläle yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yawetä Nimrotde natdetdelu nomän imän, kälawu buläkän sipmäkakut. Ile tiwän using yäkaying. “Yawele kayine äminu uläpä Nimrotdä bimä nomän sipmänggak,” yangun. ");
INSERT INTO awx_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Yolu yakapde pahake yiwikut gäpanggäpangu umanä Babilon, Erek, Akat äwä Kalne yang. Yolu unggapanggäpangu Babiloniale kewunekän yiwixakin. ");
INSERT INTO awx_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrotdä Babiloniale kep teke, ku Asiriale kewune taunu inulungu gäpangguyi pahakut. Umanä Niniwe, Rehobotir, Kala, ");
INSERT INTO awx_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","äwä Resen yang. Resenu Niniwe äwä Kala yolu inulung hikngä unggäpangatde bänäkängän yiwixakut. ");
INSERT INTO awx_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Isiwu äminu Lidia nanä, Anam nanä, Lehap nanä, Naptu nanä, Patrus nanä, Kaslu nanä, äwä Krit nanä yangge bapunä däkngakut. Filistia nanä Kaslutä towimbän, unetä sakngälakut, äminu unin. ");
INSERT INTO awx_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","Saidonu Kenande wawaxu yakap täpänin. Tiwän Kenanu Hit nanä, Jebus nanä, Amor nanä, Girgas nanä, Hiwi nanä, Arka nanä, Sini nanä, Arwat nanä, Semar nanä, äwä Hamat nanä yangge bapunä däkngakut. Kenan nanä unetä sakngälake, päku yolu inäinä yiwitäke kukin. ");
INSERT INTO awx_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tiwän Kenande kewu using päkin. Saidondä ku taun Gerar ku Gasa kukut. Tiwän unetä täpän täkwämbän, gusitdä akonggak käwut ku, taun Sodom, Gomora, Atma, Seboim yang kukut. Lasale kewune wäkngäsim, Seboimun. ");
INSERT INTO awx_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Äminu aläkwäxu Hamde bapunä. Bapunäne wamnäne upuke, kepnä äwä kantrinä yangu inäinä päke yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafetde ulawu Semkäyä wawakngä towikut. Tiwän Semde wawaxu unetä sakngälake dukngikinu bapunä täpätu Eber. Tiwänä Semu Eberunetä sakngälakin täkwäkge bapunä. ");
INSERT INTO awx_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semde wawaxu umanä Elam, Asur, Apasat, Lidia äwä Aram yang. ");
INSERT INTO awx_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Tiwänä Aramde wawaxu umanä Us, Hul, Geter äwä Mas. ");
INSERT INTO awx_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apasatde wawaxu Sela. Tiwänä Selale wawaxu Eber. ");
INSERT INTO awx_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberde wawaxu täpäyalä. Yakäp täpä umanä Pelek yang inikut. Ile täpdukätanu kewu inäinä upuke yiwikin, ge ile tiwän Pelek yangu inikut. Ile ulapnä umanä Joktan. ");
INSERT INTO awx_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktande wawaxu umanä Almodat, Selep, Hasamawet, Jera, ");
INSERT INTO awx_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO awx_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO awx_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila äwä Jobap yang. Äminu aläkwäxu undä Joktande wawak. ");
INSERT INTO awx_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kewu itä täke yiwikinu, Mesa unetä ku Sefar gusitdä akonggaxu täwal halak yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Äminu aläkwäxu Semde bapunä. Bapunäne wamnäne upuke, kepnä äwä kantrinä yangu inäinä päke yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Tiwän äminu aläkwäxu Noale wawaxunetä sakngälakinunin. Kewu yanggätä yiwikdoke pänguhiwänä, sakngälake, unetä upuke, päku kantrinä inäinä yiwitäke kukin. ");
INSERT INTO awx_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ämimbamu kep däkäne yiwikinu wamnä buläkän täknga yakin. ");
INSERT INTO awx_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tixäwik äminu gusitdä akonggak käwutkätan tihikuke, kewu kupi gwendu Babiloniaxätan kake, uwomune päku yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Päku yiwike, “Kep gämänu päke, däkine häna, yähakitokawä, blik däkngäning,” yang yakin. Yolu hup simen yanggä dowahakin, tike kolta tuliwä, blixu päpä kitokakin. ");
INSERT INTO awx_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Tiwän using yakin. “Inäinä domatäke, womdu womdu dowäku yiwihikunim,” yake, “Yolu gäpanggu tahake, yot bänäkängän yolu belakngä gwendu tahana, yekäwune kopik. Tiwän umaninu käyä tiwik,” yang yake, using pahakin. ");
INSERT INTO awx_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tixawändeyä Yawe äminu kewune nanätä yot gäpang, yolu belakngä gwen yang pahaxawä, unin dayipikge epgut. ");
INSERT INTO awx_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","“A! U äminu inä uninggän, tiwän wamnä buläkän täknga. Yakapde unin pahaying. Ge mahande dasingga pahaningge natäkengu, awahaningunin,” yake, ");
INSERT INTO awx_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","“Puku wamnä pängginungutnim. Tiwän wamnä yawä, notnätä donatäpning,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yake, Yawetä äminu womduwomdu petäke kuwän, yolu tahakinu dolahapulukin. ");
INSERT INTO awx_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ile tiwän yolu unggäpangu umanä Babel yang inikakin. Yolu unggäpangune Yawetä äminbamde wamnä pängginunguke, unetä petäke kuwän, päku kep däkäne womduwomdu yiwihikukin. ");
INSERT INTO awx_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semde bapunä. Yanggä gwendä yiwikdoke teke pukuwän, krismasu gwenalä apuxukut. Tiwän Semu krismasnä 100 yiwikengä, wawakngä Apasat towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ile mahene krismasu 500 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tiwän Apasalu krismasnä 35 yiwikengä, wakwakngä Sela towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ile mähene krismasu 403 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tiwän Sela krismasnä 30 yiwikengä, wawakngä Eber towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ile mähene krismasu 403 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Tiwän Eberu krismasnä 34 yiwikengä, wawakngä Pelek towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ile mähene krismasu 430 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Tiwän Pelexu krismasnä 30 yiwikengä, wawakngä Reu towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ile mähene krismasu 209 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Tiwän Reu krismasnä 32 yiwikengä, wawakngä Seruk towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ile mähene krismasu 207 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tiwän Seruxu krismasnä 30 yiwikengä, wawakngä Nahor towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ile mähene krismasu 200 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tiwän Nahor krismasnä 29 yiwikengä, wawakngä Tera towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ile mähene krismasu 119 yiwixäwixu, wawak yäpanä towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tiwän Tera krismasnä 70 yiwikengä, wawakngä Abram, Nahor, äwä Haran yang towikut. ");
INSERT INTO awx_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terale bapunä. Tera Abram, Nahor, Haran yangge nanä. Tiwän Haranu Lotde nanä. ");
INSERT INTO awx_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Nanä käluk yiwixawän, Haranu Ur Kaldia alakut womune kumgut. ");
INSERT INTO awx_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Tiwän Abramkät Nahorkät mängätnä päkumäläk. Abramde mängälu umanä Sarai, tiwän Nahorde mängälu umanä Milka, Harande yäpa. Haranu Milka äwä Iska yangge nanä. ");
INSERT INTO awx_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai engang hongge yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teratä wawakngä Abram, bapunä Lolu Harande wawak, bapunä Sarai Abramde mängät yang päpän, Ur yolu Kaldiaxätanu unggäpangu teke, Kenan kuningge kukindeyä, Haran yolu unggäpangune päku yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Yiwihika, Tera krismasnä 205 yiwixäwixu, une kumgut. ");
INSERT INTO awx_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Gwendune Yawetä Abramu using inikut. “Kantrika, notdambam, nangga yänggwät yang peke, kewu nätä ganiwa, uwomune kunggayo. ");
INSERT INTO awx_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nätä pahawa, bapuka sakngälake, kantri inätä täke yiwä, umanä käyä tiwik. Tiwän bänip kwikwik gamike, tahawa umanda inulung tiwik. Tiwän gäle natäke, äminbamu mahandexäyä bänip kwikwixu äpme yämit. ");
INSERT INTO awx_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ämindä gäle bänip kwikwik gamä, nätä yäkwäle ile bänip kwikwik yämit. Tike ämindä tokngä däkä gamä, nätä yäkwäle tokngä däkä yämit. Gäle tiwän, yotyolu kewune nanä undä bänip kwikwik päning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tiwän Abramu yotnä teke, Yawetä inikut using kukut. Lotkäyä ixät kukumäläk. Abramu krismäsnä 75 yiwikengä, Haranu teke kukut. ");
INSERT INTO awx_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Mängätnä Sarai, notnäle wawak Lot, hängäläpä äwä puyä äminu Haran päkin yangu undä päke, kewu Kenan uwomune kuningge kukin. Kuhika, Kenan kewu uwomune kundopgin. ");
INSERT INTO awx_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kundoke kuhika, Sekem päku, pa takwänu More undäkäne yiwikin. Täpduxu uwomkätanu kewu uwomune Kenan nanä ayiwixakin. ");
INSERT INTO awx_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Tiwän Yawetä apu, Abram using inikut. “Kewu awomu bapukale äpme yämit,” yang inikut. Yawetä ile apgutde, ile tiwän, Yawele alta gwenu uwomune tahakut. ");
INSERT INTO awx_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Tikengä Sekem teke kuhika, Betelde gusitdä akonggak käwutkätan päku, selyotnä täwal kemat tapike yiwikut. Uwäku yiwikulu, Betelde gusitdä akonggak käwut, tiwän Aile gusitdä pukunggak käwutde, bänäkängän päku yiwikut. Unexäyä alta gwendu tahake, Yawele uman tängenakut. ");
INSERT INTO awx_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Tikengä uwomu teke, päku womduwomduhim yiwitäke, Negepde kukut. ");
INSERT INTO awx_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kewu uwomkätanu gusit täpduk tiwän, naxu wenä hikngä tikut. Tiwän Abramu womduhimu Isip päpu yiwikge pukukut. ");
INSERT INTO awx_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Isip kundopningge kuxäwik, mängätnä Sarai using inikut. “Gä mängälä gwälam hikngä. ");
INSERT INTO awx_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isip nanätä ganduke ‘Ile mängät,’ yakengu, nä anuwä kungäxäwa, gä täning. ");
INSERT INTO awx_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ge ayäwä kakengu, ‘Hamina’ yang yäniyo. Tiwän gäle natäkengu, donuwä kupit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","U inikut using kuwäl, Isip nanätä mängätnä kawä, gwälam hikngä tikut. ");
INSERT INTO awx_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tiwän kingge puyä ämindä kake, ku kingu “Mängälä gwälam hikngä täpätu undan kamäng,” yang inikin. Tikengä Sarai kingge yolune täke kukin. ");
INSERT INTO awx_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tiwän kinggä Sarai täkutde tiwän, Abramde sipsip, towiyä gämän, donggi, kamel, puyä ämin yang imikut. ");
INSERT INTO awx_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tiwändeyä kinggä Abramde mängätnä täkutde, Yawetä iwalu wäyi hikngä king, äminu undä yotnäne yiwixakin yangge yämän dambätakin. ");
INSERT INTO awx_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Andambätake, kinggä Abram yawän apän, using inikut. “Usingu inale tahakuläk? ‘Mängätna’ yangu dasingge tiwän donanikuläk? ");
INSERT INTO awx_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘Hamina’ yangu kemu inale naniwi täkum? Wanin, mängätdan. Täke kunggä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Inike, puyä äminä yäniwän, itä Abram, mängätnä, yang yäningyäpiwä, hängä täpänä undä päke kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramdä Isip teke, mängätnä, hängä täpänä yang päke, hipdunä Negep kopgut. Notnäle wawaxu Lotkät using kopgumäläk. ");
INSERT INTO awx_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramu moningä silwa, gol, kälawu äminsak yangu meyä hikngä tiwäyä, päke kopgut. ");
INSERT INTO awx_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Täko yiwihika, Negep teke, womduwomduhim yiwitäke, Betel kukut. Täku Betelkät Aixätde bänäkän yiwikut, tupä selyotnä tapike yiwike, ");
INSERT INTO awx_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","alta gwenu Yawele tahakut womune. Une päku yiwike, hipdu Yawele tumuk takahut. ");
INSERT INTO awx_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Tixawän Lotkäyä sipsipnä, towiyä gämänä, äminu ixät kukin yangu meyä. ");
INSERT INTO awx_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abramkät Lotkätdäne kälapnä meyä hikngä tiwän, kewu uwomunekänu yiwitnangäsä dolikut. ");
INSERT INTO awx_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Äminu Abramde kälap daying yiwixakin äwä äminu Lotde kälap daying yiwixakin yanggä yanganikin. Tixawän uwomkätanu Kenan nanä Peres nanä yangu uwomunekän yiwäxakin. ");
INSERT INTO awx_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Puyä äminätä yanganiwä, Abramdä Lolu using inikut. “Puyä äminilu amäk wam yawä, täke dolinggak. Nilu u notnäxäluninggän. Ge amäk wamu teta. ");
INSERT INTO awx_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kayo. Kewu inulung. Ge inäinä matäke kuhim. Gä hiyä käwut kuwiläkge natäpi, nä kwänä käwut kuwit. Tike gä kwänä käwut kuwiläkge natäpi, nä hiyä käwut kuwit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Iniwän Lotdä Jodan kupi ku Soar kewu uwom kawänu, yanggänä käyä tikut, Yawele puyä bimä, äwä Isipde kupi bimä. (Yawetä Sodom Gomora yangu dosipmäxawän kakut.) ");
INSERT INTO awx_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kewu unin kake, Lotdä kupi undä gwen inäle tuwänguke, womduwomduhim yiwitäke, gusitdä akonggak käwulunele kukut. Tiwänä Abramkät Lotkälu matäke kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu Kenan yiwixawän, Lolu kupi unggwenune yolu gäpangguyi bänäkängän päku, selyotnä Sodomu kwayimune tapike yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Äminu Sodom nanä gutongä ämin. Yawele kayine wäyi hikngä pahakakin. ");
INSERT INTO awx_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lotdä Abramu teke kuwänä, Yawetä Abramu using inikut. “Anetä yiwike, kewu undä dayipso. Gusitdä akonggak käwut, gusitdä pukunggak käwut, not käwut, äwä saut käwut yangu dayipso. ");
INSERT INTO awx_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Kewu undä undayixaläxu nätä gäxät bapukaxätde gihäle tupäkände äpme damit. ");
INSERT INTO awx_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nätä tahawa, bapuka naxälä hikngä tike, haluhalu bimä tining. Äminu täpätutä haluhalu kendekengä, bapukaxäyä kendewik. Tiwän bapuka naxalä hikngä tiwän, kendetnangäsä doliwik. ");
INSERT INTO awx_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kuke, kewu awomdäne belakngänä däpinä yangu undä dayipso, inale gäle gamit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Iniwän Abramdä selyotnä wäsipäke, Hebron täku Mamrele pa takwän däkändäkäne selyotnä tapike, uwomune yiwikut. Une täku yiwike, alta gwenu Yawele tahakut. ");
INSERT INTO awx_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Täpduxu uwomune kingu malä nanä täpäyaläxät täpäyaläxätdä amäk äminä päpä, Kenan apä, amgin. Elamde king Kedorlaomer, Babiloniale king Amrapel, Elasarde king Ariok, äwä Goimde king Tidal, yanggä apä, kingu Kenan nanäxät amgin. ");
INSERT INTO awx_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Kingu Kenan nanä using: Sodomde king Bera, Gomorale king Birsa, Atmale king Sinab, Seboimde king Semeber, äwä Belale king. Bela äpmanu Soar yang inikaying. ");
INSERT INTO awx_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kenande kingu uläkwäxu amäk äminä päke, Sidim Kupi kukin, Sol Yanggä Gwende kwayimune. ");
INSERT INTO awx_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Using tupä Kenan nanä Kedolaomerde gepbine yiwixawä, krismasu 12 apuxuwän, krismasu 13 täpäne mähe natäke, wamnä donggwälamikin. ");
INSERT INTO awx_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ile tiwän krismasu 14 täpäne Kedolaomerxät king notnäxät amäk äminä päpä, Astoret Karnaim apu Repa nanä sipmäke, Ham apu Sus nanä sipmäke, Sawe Kiriataim apu Em nanä sipmäke, ");
INSERT INTO awx_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Seir täwal däkändäkäne apu Hor nanä sipmäke, Elparan nanä apu sipgin. Elparanu kepdän däkäle inälängändän. ");
INSERT INTO awx_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Unetä täpä täkwämbän, Enmispat, äpmanu Kades yang inikayingune ku, Amalek nanä sipmäke, kepnä unda päke, Amori nanä Hasason Tamar yiwäxakinkäyä sipmäke, kepnä unda päkin. ");
INSERT INTO awx_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Unin sipä, kingu Sodom nanä, Gomora nanä, Atma nanä, Seboim nanä äwä Bela nanä yanggä amäk äminä päpä, Sidim kupine päku ämningge tändäkngakin. ");
INSERT INTO awx_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elamde King Kedolaomer, Babiloniale King Amrapel, Elasarde King Ariok, äwä Goimde king Tidal, yanggä apä, ixät amgin. Amäk äminu 4 täkwäkgänetä apä, amäk äminu 5 täkwäkgänexät amgin. ");
INSERT INTO awx_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidim Kupi Gwenune, gänangä däkändäkä koltatäne käyä. Tiwän amänggawä täke doliwän, Sodomde amäk äminäxät Gomorale amäk äminäxät andatäkuningge tahake, notnä kolta gäpmane päpu sipän, notnä täwal däkändäkäne datäkukin. ");
INSERT INTO awx_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Datäkuwä iwalnätä päku, Sodomdäne Gomoratäne yang hängälapänä nakngä yang päkin. ");
INSERT INTO awx_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tixawän Abramde notnäle wawaxu Lot Sodom yiwäxakutde, amäk ämindä hängä täpänä Lot yang päke kukin. ");
INSERT INTO awx_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tiwänä äminu andatäkukinu täpätutä apu, Abram Hibru uläpä inikut. Äminu Amor nanä täpätu umanä Mamre, panä takwän däkändäkä käyä. Tiwän Abrahamu pa undäkändäkäle kwayimune yiwixakut. Eskol, Aner yangu Mamrele epänepän notnä. Tupä Abram, Mamre, Eskol, Aner yang gatäkgatäk tahaningge wamu aläkakut. ");
INSERT INTO awx_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramu wawakngä täkinde natäke, amäk äminä Abramde yolune alakinu 318 ämin yangyäwämbän, päku iwalnä yäwatäke kuhika, Dan yot gäpangune kukin. ");
INSERT INTO awx_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kupiläne Abramdä amäk äminä uhike pewän, iwälnä sipä datäkuxawä, yäwatäke kuhika, Hoba kukin, Damaskusde not käwutkätan. ");
INSERT INTO awx_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kuke hängäläpä iwalnätä päkinu, wawakngä Lot, Lotdäne hängäläpä äwä wäwi mängälä yang päkapgin. ");
INSERT INTO awx_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramdä King Kedolaomerxät king notnäxät sipmäke, hipdunä Sawe Kupi bä Kingge Kupi yang inikayingune apuxawän, Sodomde kingu Abramkät yiwik yähimäläkge apgut. ");
INSERT INTO awx_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Tiwänä Melkisedexu Salemde kingkäyä Abramde apgut. Täkapu bretkät wainkät imikut. Melkisedexu Anätu Enetängä Nanä Täpäle prisde yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Itä apu wam gwalängu using imikut. “Abram, Anätu Enetängä Nanä kepkät yekäpkät pahakut täpätä, gäle bänip kwikwixu äpme gamik. ");
INSERT INTO awx_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tiwän Anätu Enetängä Nanä Täpäle uman yatängenatnim, inale itä iwalda kätakgane pewän sipguläk,” yang inikut. Iniwän Abramdä hängäläpä upuke, 9-u inäle pexäwik, 1-u Melkisedekge imikut. ");
INSERT INTO awx_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tiwänä Sodomde kingu Beratä Abramu using inikut. “Hängä täpä gikale pexäwik, äminakän namiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tiwändeyä Abramdä using inikut. “Kätaknga tängenake, Yawe, Anätu Enetängä Nanä, kepkät yekäpkät pahakut täpäle umande wamu hiyäkän hikngä yänggat. ");
INSERT INTO awx_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Hängä täpätu gätäne dohikngä täpit. Täwikge tret bä bälängyayikge kätak yangu mätekngä. Tiwändeyä dowäpit. Using päpitnä, gätä ‘Nätä tahawa, Abramu hängänämbamgän tikin,’ yang yeyä. ");
INSERT INTO awx_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Hängä täpätu ninale doläpit. Tike hängä amäk äminatä anayingu unin. Tike Aner, Eskol, Mamre yangu näxat kukumäng. Ge hängä mätekngä itäkän päning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Abramdä awewelike kaxawän, Yawetä apu, wamu using inikut. “Manaxälayo. Nä tulungguka bimä. Tike bänip gwalängge hängä inulung gamit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tiwän Abramdä yäkwäle inikut. “Täkeläpä Yawe, hängä dasä bimä namiläk? Enganga wenä. Ge nätä kupa, Elieser Damaskas nanä täpätä näle tangge yiwike, hängäna päpik. ");
INSERT INTO awx_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Engangu donamikuläkge, puyä ämina täpätutä näle hängä päpik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Iniwän Yawetä wamu hipdu using inikut. “U. Gäle hängä äminu uläpätä dowäpik. Tike gika wawak hikngätä päpik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Inike kepmän täkepuke using inikut. “Yekäpkätan kake, kuminamu kendeyo. Kendetnangäsä tinggak? Bapuka using tining,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iniwän Abramdä Yawele bänip tiwän, Yawetä “äminomän” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Tiwänä hipdu Yawetä Abramu using inikut. “Nä Yawe. Nätä kewu awomunin gamitde Ur yolu Kaldiaxätanu unggäpangunetä täkapgum, gän,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tiwän Abramdä inikut. “Täkeläpä Yawe, dasing tahawi kakengä, hiyäkände yangu natäpit?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Iniwän yäkwäle inikut. “Towiyä gämän mängälä gwendu, meme mängälä gwendu, sipsiwu wäwi gwendu, undä krismasnä gwenalä gwendu, äwä kombunanang mätexu gwendu, päkalu gwendu yangu päkapu namiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iniwänä Abramdä undä Yawele päkapu, bänäkängän wehike, käwutdu pexäwik, käwutdu petäke kuwän, täkngayalä tikut. Tikengä kwäwilu dowehikut. Tike gwendu käwutdu täkngane teke, gwendu käwutdu täkngane tekut. ");
INSERT INTO awx_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Pewän dayike, käpämdä epu naninnge epä, Abramdä yäwambän datäkukin. ");
INSERT INTO awx_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tiwänä gusitdä pukuxawän, Yawetä natäpän, däpmunä kupsä hikngä pekut. Pexawän, kupilä täkngaxät naxälä täkngaxät apän naxälakut. ");
INSERT INTO awx_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tiwän Yawetä inikut. “Wamu ganiwa, hiyäkängän natäpso. Bapuka kewu womdune päku, apuyiwit däkngake, uwomune nanäle kematde yiwitning. Tiwän puyä kitokngä yämä pahaxawä, äminu sipmäxäwik pahawä malixawä, 400 krismas apuxuning. ");
INSERT INTO awx_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tiwän äminu gin pahawä maliningu, nätä tokngä däkä äpme yämit. Tiwän bapuka hängä täpänä naxälä päke, yolu uwomu teke kuning. ");
INSERT INTO awx_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tiwänä gän, yiwitäke kuhika, äminälake hikngä damänsim tike, bänip kwikwik täkngane kupi kwayining. ");
INSERT INTO awx_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Bapuka gwenu gwenaläxät gwenaläxät sakngäläxawänä, ane apning. Amor nanäle wäyinä inulung hikngä tiwän kakengä, anetä yäwämba epuxuning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Gusitdä pukuwän kupilä tiwänu, gäpma kupänä käyä gwenkät, aläkätäwu däkinä käyä täpäxätdä tingalake, kälawu wehike pekulune bänäkändekän apuxukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Täpduxu unggwenune Yawetä Abramu hiyäkän wam täknga using inikut. “Bapukale kewu awomunin yämit, Isipde yanggä dupinetä apuxu yanggä inulungu Yufrites dupine. ");
INSERT INTO awx_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ken, Kenis, Kadmon, ");
INSERT INTO awx_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit, Peres, Repa, ");
INSERT INTO awx_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor, Kenan, Girgas, äwä Jebus yangge sakngayile kewu undä bapukale yämit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, Abramde mängälu, engangu dondukngikut. Tiwändeyä mängälä täpätu Isip nanä puyä äminäle yiwikulu umanä Hagar. ");
INSERT INTO awx_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ge Saraitä Abram inikut. “Yawetä bänipna umumbän, engangu dondukngit. Ge kuyo. Tiwän puyä äminaxät däpmunu pesimäläk. Dasingga? Itä enganga äpmembä betangamik?” yang inikut. Iniwän Abramu täke natäpgut, Saraitä yawänun. ");
INSERT INTO awx_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abramu Kenan täku krismasu 10 yiwikut. Tiwänä, Saraitä puyä äminä Hagaru Abramde imikut. ");
INSERT INTO awx_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Tiwän Hagarxät yiwät, tängene käyä tikut. Tiwän kake, Hagaru inäle natäpänu axopgut. Tiwän towikngä Saraile natäpänu aepgut. ");
INSERT INTO awx_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tiwänä Saraitä Abramu using inikut. “Gätä tahawi, nä meyä pänggat. Puyä ämina uläpä nina gäle kätaxune tekum. Tiwändeyä Hagaru tängene käyä tiwän kake, itä nandupänu, kwakwakngä tinggak. Ge Yawetä gäxät näxälu äpme uhinggiwik,” yang inikut, Saraitä Abramun. ");
INSERT INTO awx_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Yawän yäkwäle Abramdä using inikut. “Täke. Gika puyä ämin. Gika dasingga tahawiläkge natäläxu, gika tängäne yiwixak,” yang inikut. Yawänä Saraitä mähemähe kaxäwik tahanggawän, Hagaru datäkukut. ");
INSERT INTO awx_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yawele angelätä kepgän gomune, Hagaru yanggä akondokayingune kakut. Yanggä akondokayingu unggwäxu Surde kähit kwayimune yiwixak. ");
INSERT INTO awx_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Tiwän ängelatä using inikut. “Hagar, Saraile puyä ämin, sänetä apuläkngä, säne kunggaläk?” yang inikut. Iniwän “Nä towiknga Saraile naxälake datängapunggat,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Iniwän Yawele ängelatä inikut. “Hipdu päku towikga Saraile gepbine yiwiyo,” yang inikengä, ");
INSERT INTO awx_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","unetäkänu using inikut. “Nätä tahawa, ayika sakngälawä meyä tiwän, kendetnangäsä doliwik. ");
INSERT INTO awx_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Gä äpmanu tängakane käyä. Ge engangu wäwi täpä dukngiwiläk. Tikengä umanä Ismael yang iniyo, inale kwänämu tiläxu, Yawetä anatäk. ");
INSERT INTO awx_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Wawakga uläpä donggi tuk bimä däkngake, äminbamde iwalnä däkngawik. Däkngawän yäkwäle iwalnä däkngawä, tahake yiwitning. Tikengä notnämbamkälu gupsängu doyiwitning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yawetä Hagaru wam inikutde, “Ananduxak Täpä axat,” yake, umanä täkngatu using inikut. “Anätu Ananduxaläk Täpänin” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ile tiwän yanggä akondokayingu unggwäxu umanä “Käluk Yiwäxäwik Nanduxak Täpäle Yanggä” yang inikin. Yanggä akondokayingu unggwäxu Kadeskät Beretkätde bänäkängän yiwäxak. ");
INSERT INTO awx_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tiwänä Hagardä Abramde wawak dukngiwän, Abramdä umanä Ismael yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramu krismasnä 86 yiwixawän, Hagardä Ismaelu une dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramu krismasnä 99 yiwixawän, Yawetä apu inikut. “Nä Anätu Kitokngäna Käyä Täpä. Näxät gatäke yiwixäwik, nomängän pahayo. ");
INSERT INTO awx_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kontraknga gäxät tahakumäxu aläpa kitokawän, tahawa bapuka meyä hikngä tiwik,” yang iniwän, ");
INSERT INTO awx_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramdä sopäsopä puke, kuhilä kewune täpu temgut. Tiwän Anätutä using inikut. ");
INSERT INTO awx_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Näle kontraxu using. Mahande kantri yiwitäke kuninggäne bapunä däkngawiläk. ");
INSERT INTO awx_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ile tiwän umanda Abram yangu dongganikaning. Tike umanda Abraham yang ganikaning, inale nätä pahawa, bapuka meyä sakngälake, kantrinä inäinä päke yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nätä tahawa, bapuka meyä dukngixäwik, kantri däkngake yiwitäke kuning. Tiwän bapuka täpätuyi kingge yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kontraknga hipdu täpa kitokawän, iwikge using yiwik, bapuka mahande alätninggexät. Nä gäle Anätuka, tiwän bapuka mahande alätningge Anätunä. ");
INSERT INTO awx_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gä Kenande kewune apuyiwitde päkapu yiwixaläk. Tiwändeyä kewu Kenandäne awomu undä gäxät bapuka mahande alätningkätde gihäle tupäkände damike, Anätunäle yiwit,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Tikengä unetäkänu using inikut. “Gäxät bapuka mahande alätningkälu näle kontrak tawake yiwitnong. ");
INSERT INTO awx_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Kontraknga uläknga using. Wäwi undä gität yiwixayingu, yämunäle gup matänong. ");
INSERT INTO awx_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kontrakngitde tuwängge gupnä matäkaningu uläkngatä yiwik. ");
INSERT INTO awx_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Wäwi gität yiwitning, engangu wäwi alake täpduxu 8 yiwitning, äwä malä nanä puyä äminsäle moninggä uhining yangu, undä gupnä matänong. Usäkän bapuka mahande alätningkäyä usinggän tahanong. ");
INSERT INTO awx_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Yotsäne alätning bä moninggä uhining yangu undä gupnä amatänong. Uläkngatä tuwängge yiwän, kontraknga iwikge yiwixäwik. ");
INSERT INTO awx_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tike wäwi täpätu iminda gupnä domatäwixu, näle kontraxu doläwämbik. Ge aläwämbä epuxuyok,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Täkngatu using inikut. “Mängätda Sarai yang inikakinu aleke, Sara yang ininong. ");
INSERT INTO awx_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nätä bänip kwikwik ima, wawakga dukngiwik. Unetäkänu nätä bänip kwikwik ima, yotyotde hawanä däkngawik. Tiwän ayinä täpätuyi kingge yiwitning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iniwän Abrahamdä sopäsopä puke, kuhilä kewune täpu temäke, using natäpgut. “Wäwi krismasnä 100 tiwänu, engangu äpme towimbik? Saraxäyä krismasnä 90. Ge engangu äpme dukngiwik?” yang natäpän, kwakwakngä tiwän mikut. ");
INSERT INTO awx_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tikengä Anätu using inikut. “Wamu yaläxu, Ismaelde täkembä imiläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tiwänä Anätutä inikut. “Ile donatäke yat. Tike mängätda hikngä, Saratä wäwi täpätu äpme dukngiwik. Tiwän umanä Aisak yang iniyo. Tiwänä kontraknga ixät tahake, täpa kitokawän, iwikge using yiwik, bapunä mahande alätninggexät. ");
INSERT INTO awx_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismaelde yaläxu anatät. Ge ixäyä bänip kwikwixu äpme ima, engangu meyä towimbik. Wawakngä 12 towimbän, uläkwäxu kuhiläle yiwike, kantrinä täke yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tiwändeyä kontraknga uläknga Aisakät tahahim. Äminu uläpä krismasu ende gwenuneyä Saratä kake täpik, täpduxu asawomune,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Wamu Abraham iniwän puluwänu, Anätu axukut. ");
INSERT INTO awx_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Täpduxu inä unggwenunekän Abrahamdä Ismael, wäwi inäxät yiwixakin, moninggä uhikut yangu wäwi undä gupnä Anätutä inikut using matäkut. ");
INSERT INTO awx_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamu krismasnä 99 tixawän, gupnä matäkin. ");
INSERT INTO awx_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Tike wawakngä Ismaelu krismasnä 13. ");
INSERT INTO awx_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Täpduxu inä unggwenunekän Abrahamkät Ismaelkätde guwu matäkin. ");
INSERT INTO awx_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abraham, wäwi inäxät yiwixakin, moninggä malä nanä uhikut yangu wäwi undä gupnä matäkin. ");
INSERT INTO awx_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahamu selyotnä Mamrele pa takwän däkändäkäle kwayimune täku tapikut. Ngä täpduxu gwendune gusilu tokngä tiwän, selyotnäle yämäne yiwixawän, Yawe apgut. ");
INSERT INTO awx_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahamu kuhilä kwayiwän enawän, äminu täpäyalä täpätu päkapu yiwikinä dayipgut. Unin dayikengu, selyotnä yämä däkänetä ihapmäke kuke, sopäsopä puke, kuhilä kep däkäne temgut. ");
INSERT INTO awx_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Temäke using yakut. “Bulämbam täpä, nä ilakngä nandukengu, puyä äminda manapmake kuyo. ");
INSERT INTO awx_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Puyä ämina iniwa, yanggä täkapu damän, bälängsä häluke, pa andäkale gepmäne yiwä täkanong. ");
INSERT INTO awx_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Näle apuyingge, naxu mätekngä hangdama, nakitokakengä, axunangge natäyingune kunong,” yawän, “Täke. Usingu täke tahawiläk,” yang yakin. ");
INSERT INTO awx_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tiwän Abrahamu yupsäng ihapmäke, selyotkätan kopgut, Sarale. Ko Sara using inikut. “Flawa gwälamu bulämbamu tupäyalä päke, bret hayo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Tikengä ihapmäke, towiyä gämände kukut. Ku towiyä gämän mätexu tänge ilakngäkänu gwendu täkapu, puyä äminä täpätule imän, itä yupsäng matäke hakut. ");
INSERT INTO awx_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tiwänä towiyä gämändäne mäm yanggä kälukät, äwä mäm yanggä awäke pewä kitokakinkät, towiyä gämän mätexu u hakinkät päkapu yämikut. Yämike, pa gepmä yiwike, daying yiwixawän, nakin. ");
INSERT INTO awx_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tikengä using inikin. “Mängätda Sara sandan?” yang yawä “Endesing. Selyotkätan,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tiwänä u yiwikinu täpätutä using yakut. “Täpduxu asämbimä gwenu krismasu endenggwenune apa, mängätda Sara engangu wäwi täpä kake täpik,” yang inikut. Wamu u yakinu, Sara selyolune yiwixäwik natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahamkät Saraxälu äminäläke hikngä tiwät, engangä dukngitnangäsä täpduxu ayapmikut. ");
INSERT INTO awx_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ge Sara using natäpgut. “Apnaxät nilu äminäläke alimäk. Engang äpme dukngiwik yake yänggak?” yang natäke, mipäkohopikut. ");
INSERT INTO awx_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tiwän Yawetä Abrahamu using inikut. “Sara inale mikgak? ‘Engangu kake tänangäsändo. Äminäläke alit,’ yangu inale yänggak? ");
INSERT INTO awx_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Hängä täkngatu Yawetä using tiwik yang natäpänu, doaläwik? Tiwän täpduxu angganit gwenune hiyäkände äpme apit. Tiwän engangu wäwi täpä kake täpik,” yawän, ");
INSERT INTO awx_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara anaxälake “Domit,” yawän, Yawetä “Hiyäkände. Amiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Äminu uläkwäxu Sodomde kuningge enawä, Abrahamkät kukin. Kuke päku kahitbänä yiwike, yot gäpangkätan kakin. ");
INSERT INTO awx_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yawetä using natäpgut. “Hängä tahawitde natälu, Abrahamu doxanghopike tahawit, ");
INSERT INTO awx_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","inale Abrahamu bapunä sakngälake, kantri inätä täke yiwä, kitokngänä käyä tiwik. Tiwän Abrahamde tiwän, kantri kewune nanä undä bänip kwikwik päning. ");
INSERT INTO awx_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Abrahamu, engangä, bapunä yang yänindämumbän, nomängän tahaxäwik, Yawele kahit täwaningge tuwängukum. Ge hiyäkän wamu Abraham inikumu, inä using pahawit,” yang natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tikengä Yawetä using inikut. “Sodom nanäxät Gomora nanäxät gutongä hikngä pahaxawä, kwänäm tixäwik, näle yayingu meyä hikngä. ");
INSERT INTO awx_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ge nina pukuke dayikengä, hängä wäyi pahawä wamu natäpgumu hiyäkän bä kem yangu natäpit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tiwänä äminu Yawexät kukin täpäyalu Sodomde kuxawät, Yawexät Abrahamkälu ayiwikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Yawetä yiwikulune inälängän ku, Abrahamdä using inikut. “Ngä dasing? Äminomänkät gutongä äminkät undä sipnangge tinggaläk? ");
INSERT INTO awx_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ngä äminomänu 50 tiwänu, ile butayä donatäxäwik, yolu undä gäpangu pahawi malining? ");
INSERT INTO awx_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Gätä gutongä ämin sipmäkengu, äminomänu dosipnangäsä, inale undä sipmäkengu, meyä usakän yämiläxunin. Kewu undä womde meyä uhinggikgaläxunin. Kekem usingu dolahanangäsä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tiwänu Yawetä using inikut. “Sodomkätanu äminomänu 50 dayikengu, butayä ile natäke, yolu undä gäpang tewa yiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tiwänä Abrahamdä hipdu using inikut. “Nä kep ämingän. Wamu yänangäsändo. Tiwändeyä hipdu yäwit. ");
INSERT INTO awx_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Äminomänu 5-u wenä tiwän, 45-kän tiwänu, dasing? Yolu undä gäpangu asipiläk?” yang iniwän, “45 dayikengu, dosipit,” yang inikut, Yawetän. ");
INSERT INTO awx_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Tiwänä hipdu using inikut. “Ngä 40-kän tiwänu, dasing?” yawän, “Äminu 40 uläkwäkge tiwänu, dosipit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iniwän hipdu “Täkeläpä, tokngä manandupso. Hipdu yänanggenggat. Ngä 30-kän tiwänu, dasingga?” yawän, “Dowahawit, 30-kän tiwikäyän,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iniwän hipdu inikut. “O, Täkeläpä, wamu hipdu angganinggat. Ayäwa kakengu, mähe manatängamiyo. Ngä undanu 20-kän tiwänu, dasing?” yawän, “20-kän dayikexäyä, dosipit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iniwänä “O Täkeläpä, wamu wäsekngä hikngä ganiwit. Dasing? Äwä undanu 10-gän dayikengun?” yawän “10-gän dayikexäyä, dosipit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Tiwänu wamu yakumäläxu, une using ku yiwikut. Tiwän Yawe teke kuxawän, Abrahamu yotnäle hipdu kukut. ");
INSERT INTO awx_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lolu taunu Sodomde yämä däkäne, wamu inulung wopwom yiwik yakakin womune puku yiwike yiwixawän, ängela uläpäyalu kupilä täkngaläknga kundopgumäläk. Kundopät dayikengu enake, ku sopäsopä uläpäyatde puke, kuhilä kep däkäne temgut. ");
INSERT INTO awx_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Bulämbam täpä, nä puyä äminsä. Ge yotnane apät kuna. Päku bälängsä häluwät, une petnim. Ge enakengä, gihä natämäläxune kuhol,” yang yänikut. Yäniwän yäkwäle using yakumäläk. “Ane, kekewune pesim,” yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tiwän Lotdä kitokawän, ile yolune kukin. Flawa yisnä wenä hangyämike, nakäyä meyä hake, yämän nakin. ");
INSERT INTO awx_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Yämän nake, awetningge däpi tixawän, wäwi Sodom nanä undä, wawakdäkä, äminäläke yang Lotde yolu yiwit täpän gwähawän, ");
INSERT INTO awx_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lotde yangoke yakin. “Äminu gäle apumäläxu, yawi epuxuwät tahakana,” yang yakin. ");
INSERT INTO awx_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tiwän Lotdä epuxuke, yämä mehene gupsäng tahake, yänikut. ");
INSERT INTO awx_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“O mäte notna. Wäyi täknga usingu malahanong. ");
INSERT INTO awx_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tike yäpana täpäyalä wäwixälu doyiwixayingu undan. Ge unin päkepu dama, gihä natäying täknga unuxät yiwitnong. Tike äminu aläpäyalu mawahawä malinong, inale näle yolunekän apumäläk,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yäniwän, “Kuke nipmit,” yang inikin. Inikengä yakin. “Lolu womdune nanä täpätä päkapu yiwike, ninu gutongä äminde nininggak,” yang yakin. Tikengä using inikin. “Meyä uläpäyatde natämäng täknga gäle tahana, meyämbamu gätä päpiläk,” yang yake, Lolu tekwätämapä kuxawän, yämä uputningge tahakin. ");
INSERT INTO awx_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tiwändeyä okupi yiwikumäläxu uläpäyatdä Lolu tulitämapät kopän, yämä gupsäng tahakuhikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tikengä kepmän yiwikinu uläkwäxu undä pahawät, kayi kupilawä, yämä däkä kanangäsä dolikut. ");
INSERT INTO awx_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Tiwänä uläpäyatdä Lolu using inikumäläk. “Yepmäka, wawakga, yäpaka, bä gikaxät nanä täpätuyi andanu käyä kakengu, päpi awomu teke kukanong, ");
INSERT INTO awx_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","inale yolu anggapangu awahata malining. Äminu ane nanätä gutongä pahaxawä, Yawele kwänäm tixäwik yayingu meyä hikngä tiwän, Yawetä niningyäpiwän, nitdä pahata maliningge apumäk. Ge notda päpi, yolu awomu teke kukanong,” yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Iniwät Lolu enake epuxuke, yepme yäpanä uläpäyat pähimäläkge tuwungukin täpäyatde kuke yänikut. “Yupsäng enake, yolu anggäpangu teke kukahol, inale Yawetä pahawän malinangge tinggak,” yang yäniwän, “Yamändetbä nininggak?” yang natäpgumuläk. ");
INSERT INTO awx_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Gusilu moyokän akondoxawän, ängelatä Lolu iningyäpikumäläk. “Mängätda yäpaka yang päke epuxunggayo. Tike yolu anggäpangkät pahata malinäng,” yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tiwändeyä Lolu hipnalä tahangyiwikut. Tinggawän ängelatä Lot mängätnä yäpanä yang kätakngäne päke, epu päke kukumäläk, inale Yawetä Lotde butayä natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Epu päke kuke, ängela täpätutä using yänikut. “Tupäkände datäkukanong. Päkungu kupi gwenune mayiwä täkanong. Tiwän maläpä täkwämbän kanong. Tupäkändekän täwalune datäkukanong. Tike dahipän kumnäng,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tiwändeyä Lotdä using yakut. “O, Bulämbam täpä, usingu mayawi tahanom. ");
INSERT INTO awx_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nä axumnangäsä tiwändeyä, gätä puyä äminda ilakngä nanduke, nandung yiwixawi, käluk yiwixat. Tiwän täwalu malä hikngä. Ge unele datäkuxätna, meyä uläkngatä apungu, anihipän kumnimunin. ");
INSERT INTO awx_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tike yolu atunggäpangsimu wäkngäsim. Tiwän mätekngä hikngä. Ge une täkembä datäkuke doxupit?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Iniwän ängelatä inikut. “Täke. Wamu u yänggaläxu using tahawit. Yolu unggäpangsimu dowahawa malining. ");
INSERT INTO awx_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tiwän yupsäng ihapmäke, datäkunggayo, inale yolu gäpangsimune doxuxawi, näta hängä täkngatu pahanangäsändo.” (Yolu unggäpangsimu Lotdä mätekngä yang inikutde, umanä Soar yang inikakin.) ");
INSERT INTO awx_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Gusilu moyokän ako apuxawän, Lolu Soar kundopgut. ");
INSERT INTO awx_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kundopän kakengä, Yawetä huwu tokngä yähakaying gwengwenu, yekäpkätandä pewän, hopätä epukaying bimä täknga epgin, Sodom Gomoraxätanun. ");
INSERT INTO awx_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tiwän Yawetä pahawän, ämin, yot, hängäläpä yangu kupi unggwenune yiwixayingu undä yähakukin. ");
INSERT INTO awx_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Unin ihiwän natäke, Lotde mängälu täpän täkwämbän kake, hup bimä däkngake, däm täpä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Yolu yähakuxawä, gwäsi hikngä Abrahamu Yawexät yakap yiwikumäläk womune täku yiwike, hapäpu, ");
INSERT INTO awx_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom, Gomora, kupi unggwen yang kaxawän, gwäha bulämbam hikngä kewu uwomkätandä mingändäkä bimä gwendä kopän kakut. ");
INSERT INTO awx_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Anätutä yot kupi unggwen yang pahawän malikin täpduxu, Abrahamde natäke, Lolu iniwän, andatäkuke meyä uläknga yapmikut. ");
INSERT INTO awx_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lolu Soar yiwitnanggengu anaxälake, yäpanä täpäyalu päpän, päko täwal däkäne hupgänangkätan yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Täpduxu gwendune päyenätä ulapnä inikut. “Nanilu äminäläke hikngä alinggak. Tiwän kewu anggomune mängälä ayä käyäkän. Tike kewu awomkätanu nit päke yiwitnangäsä wäwi wenä. ");
INSERT INTO awx_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ge nanilu wain imita, tängoke andatdawuwänä, unuxät petnim. Unetäyä engangu käyä tiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ge kupilä unggwenune nanä wain imät tängopgut. Tangopänä yäpanä yakap täpätä kuwän pekumäläk. Tiwändeyä nanä donatäpgut. ");
INSERT INTO awx_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kwepdätä päyenätä ulapnä inikut. “Kupilä anggwenune nankälu axuwa pemäk. Ge hipdu imita tängoke datdawuwik. Tiwänä kuwi pesimäläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ge kupilä unggwenune wainu hipdu tängoke datdawuxawänä, yäpanä mahan täpätä kuwän pekumäläk. Tiwändeyä nanä donatäpgut. ");
INSERT INTO awx_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Unin tahakengä nanätä yäpanäle engangmuhiwu pängyämikut. ");
INSERT INTO awx_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Tiwänä yäpanä yakäp täpä engangu wäwi täpa dukngike, umanä Moap yang inikut. Ile tiwän Moap nanä äpman yiwixayingu, Lotdä bapunä dakngawän yiwixaying. ");
INSERT INTO awx_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Inä usinggän yäpanä mahan täpäxäyän wawakngä dukngike, umanä Ben-Ammi yang inikut. Ile tiwän Amon nanä äpman yiwixayingu, Lotdä bapunä däkngawän yiwixaying. ");
INSERT INTO awx_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamu Mamrele pa gänang teke, Negep päku, Kadeskät Surxätde bänäkan yiwikut. Päku Geraru mätekngä wesim yiwixäwikngä, ");
INSERT INTO awx_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","mängätnäle “Hamina” yang yakut. Tiwänä Gerarle kingu Abimelekgä puyä äminä yäningyäpiwän, ku Sara täkapu imä, yotnäne tekut. ");
INSERT INTO awx_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tiwän kupilä gwendune Anätutä dambu tängäne apuke, Abimelexu inikut. “Gä axumnangge tinggaläk, inale gä mängälä uläpä täkuläxu ayä käyä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tiwändeyä Abimelexu Saraxät däpmunu dowekumäläk. Ge Abimelekgä using inikut. “Täkeläpä, äminu gutongänä wenä asipiläk? ");
INSERT INTO awx_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahamdä Sarale ‘Hamina,’ yawän, Saratäxayä ‘Hamina,’ yakut. ‘Ayä wenämbä,’ yake yäwa ku täkapgin. Tiwändeyä nätä gutongä täkngatu ile dolahakum. Ge undanu gutongä wenä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Iniwän Anätutä dambu tängäne inikut. “Hiyäkände. Gä donatäxäwik tahakuläk yangu anatät. Ile tiwän, nätä natäpa, mängälä uläpä doläke, wäyi täknga dolahakuläk, nälen. ");
INSERT INTO awx_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ge mängälä uläpä hipdu ayäle imiyo. Äminu uläpä profet. Ge aimi, itä gäle tumuk wam yawänu, gä doxupiläk. Tike doimiläxu, yäko! Gä äwä gikaxät nanä yangu undä axumning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kwepdätä gwäsi hikngä, Abimelekgä puyä äminä undä yangyäwämbän apä, meyä apgutdäne yäniwän, anaxälakin. ");
INSERT INTO awx_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Tiwänä Abraham yatäwämbän apän, inikut. “Gä ninde dasing tahanggaläk? Nätä gäle meyä täkngatu dolahakum. Tiwändeyä gä kem yake, meyä täknga ninde täkapunggaläk. Äminbamdä dowahakaying täknga, gätä ninde tahanggaläk. ");
INSERT INTO awx_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Yäpuli inale hikngä tahakuläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Tiwänä Abrahamdä inikut. “‘Ane nanä Anätule donaxäläke, nuke mängätna tänäng,’ yang natäpgum. ");
INSERT INTO awx_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tike ‘Hamina’ yangu hiyäkände yakum. Nanilu uläpäninggän. Tike mingilu inäinä. Tiwändeyä mängätnale täkum. ");
INSERT INTO awx_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tiwänä Anätutä natäpän, yotna teke, kewu womduwomdu tihikuxäwik, mängätna using inikum. ‘Gätä näle nomän tahaxawi, yotyotbä säneka kuhimu, näle gätä “Hamina” yang yäniyo,’ yang inikum,” yang yakut, Abrahamdän. ");
INSERT INTO awx_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tiwänä Abimelekgä Sara Abrahamde hipdu imikut. Imike towiyä gämän, sipsip, puyä ämin yang imikut. ");
INSERT INTO awx_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Imikengä Abrahamu using inikut. “Awomu näle kepgän. Gika sawomuneka yiwitnangge natäkengu, une yiwiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Inikengä Sara using inikut. “Nätä hamindale moningu silwa meyänä 1000 sekel imit, gutongä uläknga gäle tahakumden. Tiwän äminbamu gäxät yiwixayinggä using natäpning. ‘Gä gutongä täkngatu dolahakuläk,’ yang natäpning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Tiwänä Abrahamdä Anätule tumuk wam yakut. Tupä Abimelekgä Abrahamde mängät täpän, Yawetä mängälä undä Abimelekät nanä engang dayike pänangäsä bäniyä umukut. Tiwäna Abrahamdä ile tumuk wam yawän, Anätutä Abimelek, mängätnä, mängälä puyä äminä yang gatängyämän, hipdu engang dayike pänangäsä täke tikin. ");
INSERT INTO awx_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawetä Sarale natäke apuke, yakäp wamu hiyäkän täknga yakulu tahawän bulä tikut. ");
INSERT INTO awx_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abrahamu äminäläke aliwänä, Sara tängene käyä tiwän, täpduxu Anätutä yakut gwenune, engangu wäwi täpä kake täkut. ");
INSERT INTO awx_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Täpänä Abrahamdä umanä Aisak yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tixawän täpduxu 8 gwendä apän, Abrahamdä engangäle gup matäkut, tupä mämä wam täknga Anätutä yakut using. ");
INSERT INTO awx_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamu krismasnä 100 yiwixawän, Aisaxu alakut. ");
INSERT INTO awx_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saratä using yakut. “Anätutä bänip gwaläng täknga namän, axuläkake mikgat. Ge äminbamdä ile natäkengu, näxät axuläkake mitnim,” yang yakengä, ");
INSERT INTO awx_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","unetäkän yakut. “Tupä äminbamu ‘Abrahamde mängälu Sara engangä dombä kake täpik?’ yang natäpgin. Tiwändeyä Abrahamu äminäläke aliwänä, engangä kake tänggat,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisaxu bulämbam tike, mämu tewän kakengä, Abrahamdä naxu bulämbam gwen hawän nakin. ");
INSERT INTO awx_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tiwänä Saratä kaxawänu, wawakngä Aisaxu Abrahamdä Isip nanä mängälä Hagar uläpä täkutde wawakgä wäyi täkngaläknga inixäwik inimikut. ");
INSERT INTO awx_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kakengä Abrahamu inikut. “Mängälä puyä äminda uläpäxät wawakngäxälu yangyäwämbi kukakun. Axungwäxawi, puyä äminda uläpäle wawakgä hängä täpäka dowäpik. Tike näle wawaxu Aisakgäkän päpik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ismaelu Abrahamdä inä wawak. Ge ayangyäwämbikge yawänu, meyä päkut. ");
INSERT INTO awx_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tiwän Anätutä Abrahamu using inikut. “Wawakga Ismael äwä puyä äminda Hagar yangyäwämbiläkge, meyä mawäyo. Saratä dasingga yak using tahayo, inale ‘Bapukambamu meyä hikngä tiwik,’ yangu hiyäkän wam täknga ganikumu, wawakga Aisakge tiwän yakum. ");
INSERT INTO awx_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tike puyä ämindale wawakäyä tahawa, meyä sakngälake kantrinä inätä täke yiwitning, inale ixäyä wawakga,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kwepdätä gwäsi hikngä, Abrahamdä nak, yanggä kälap guwune uhike pekinunin yang päkapu, Hagarde gwälamune pekut, wawakngäxät. Pewän päke, Berseba kepgän womune päke tihikukut. ");
INSERT INTO awx_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yanggä kälap guwune päkulu alängopät puluwän, wawakngä pa mätekngä kwämbätsimde gepmä tekut. ");
INSERT INTO awx_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Teke “Wawaknga kayitä hikngä doxaxawa kupik,” yake, inäkän päku malähimsim yiwixäwik, kwänämnä tikut. ");
INSERT INTO awx_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Engängä kwänäm tiwän, Anätutä natäpgut. Tiwän Anätule ängelatä Hagaru yekäwunetä using inikut. “Hagar, inale tikgaläk? Engang täpä awexäwik tixu, Anätutä anatäk. Ge manaxälayo. ");
INSERT INTO awx_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ku kätakngäne täke täpi enawän, inale nätä tahawa ile engangu meyä sakngälake, kantrinä inätä täke yiwitning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tiwänä Anätutä tahawän, kayi kakalä tiwän, gäpma yanggäle kwayikinu däkätu kake, täku kälap guwu une tewän pukuwän dopän, täkapu wawakngä imän tängopgut. ");
INSERT INTO awx_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Wäwi mätexu uläpä aläkaxawän, Anätu ixät yiwikumäläk. Paran kepgän womune yiwixäwik, kwalemu mutnatäpgut. ");
INSERT INTO awx_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Tixawän mingätä mängätnä Isip nanä täkapu imikut. ");
INSERT INTO awx_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Täpduxu gwendune Abimelekät Fikol amäk äminäle kuhiläle yiwixakut uläpäxät ku, Abrahamu using inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","“Inaka pahaläxu, Anätutä gatänggaminggak. Ge Anätule umande wamu kitokngä hikngä naniyo. ‘Gä, wawakga, bapuka yangu kemu dondaniwit,’ yang niniyo. Nätä gäle nomän tahakum usinggän, gätäxäyä nä äwä kantri anggäpang apuyiwitde päkapu yiwixaläk yangge usinggän tahayo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iniwän Abrahamdä “Anätule umande kitokngä hikngä yänggat. U yänggaläk usingu äpme tahawit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tikengä using inikut. “Yanggä gäpma däkätu kwayikumu, puyä ämindatä kukäle inale täke towikngä däkngaying?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tiwändeyä Abimelekgä “Ngä, itä täkin yangu donatät. Moyokän tahawä donanikuläk. Ngä äpmangän yawi natäxat,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tiwänä Abrahamdä sipsip, towiyä gämän yang päkapu, Abimelekge imän, kontrak tahakumäläk. ");
INSERT INTO awx_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Unetäkän Abrahamdä sipsip mätexu mängälä 7 päkapu inätä pekut. ");
INSERT INTO awx_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Pewänä Abimelekgä Abrahamu using inikut. “Sipsip mätexu mängälä 7-u uläkwäxu, inätä yäpuli dasingge peläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iniwän “‘Yanggä gäpma unggwenu Abrahamdä kwayikut,’ yake, sipsip mätexu 7-u uläkwäxu näle kätaxune awäyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Äminu uläpäyatdä Anätule umande wamu kitokngä yakumäläkge, kewu uwomu umanä Berseba yang inikaying. ");
INSERT INTO awx_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Unin tahawät wenä tiwän, Abimelekät Fikol amäk äminäle kuhilä uläpä yangu hipdunä Filistia nanäle kewune kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Tixawän Abrahamu pa däkätu Berseba kwayike, Anätu Iwikge Yiwixak Täpäle tumuxu une yakut. ");
INSERT INTO awx_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Tikengä Filistia nanäle kewune belakngä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Berseba yiwixawängän Anätutä Abrahamde bänip yake kakut. “Abraham,” yawän, Abrahamdä “We!” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tiwänä Anätutä using inikut. “Abraham, wawakga Aisaxu buläkän hikngä uläpä bänipda yangu anatät. Tiwändeyä täpi Moria kewu uwomune kuhon. Tiwänä nätä täwalu däkätu yäwa kakengä, täku undäkäne tänguwi kupän, Aisaxu ofa näle hawi ihikuyok,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahamu kwepdätä gwäsi hikngä enake, hängäläpä donggi tängäne päko peke, puyä äminä täpäyalä äwä wawakngä yang päke kukut. Ku däki ofa häwikge wehike päke, kewu Anätutä inikut womune kukut. ");
INSERT INTO awx_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Axuxawän täpduxu gwenalä gwendu apän, kwayiwän enawänu, kep womu malätä kakut. ");
INSERT INTO awx_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kake puyä äminä uläpäyalu using yänikut. “Gilu donggixät ane yiwixätnong. Tixawän Aisakät nitdäkän täku, Anätule sopäsopä puke, tumuk wamu inikengä, hipdunit apsim,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Tikengä däki ofa hänangge päkulu, wawakngäle imän gwälamikut. Tiwänä inä däkixwäm äwä musuk yang päpän kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Äxuxäwik Aisakgä “Nan” yawän, nanätä “Ina?” yakut. Tiwänä Aisakgä “Ngä, däkixät däkixwämkälu awämäk. Tiwändeyä sipsip mätexu ina tänguke hahim?” yawän, ");
INSERT INTO awx_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","nanätä using inikut. “Anätutä inä äpme nimik,” yang inikut. Tiwän kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kuhika täwalu Anätutä inikutdäkäne kondoke, alta tahake, däki päko pekut. Peke wawakngä napdä wamäke, tako alta tängäne däki pekulune, enetängä tekut. ");
INSERT INTO awx_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Teke musuk täke, wawakngäle guläk matäwikge tändäkngakut. ");
INSERT INTO awx_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tiwändeyä Yawele ängelatä yekäwunetä using inikut. “Abraham, Abraham,” yawän, Abrahamdä “We! Nä ane,” yakut. Tiwänä ängelatä using inikut. ");
INSERT INTO awx_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Wawakga malänguyo. Tike hängä täkngatu ile malahayo. Gä Anätule naxälake, wamnä gwälamikgaläk yangu anatät, inale wawakga täpätukänu uläpä Anätule imiläkge doxotnaläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tiwänä Abrahamdä kwayiwän enawän tahakengu, sipsiwu wäwi gwendu songä gitnä tupätuhimune apän, komnäne tapiwän yiwixäwän kakut. Kake, wawakngäle tangge ku täkapu, unggwenunin tänguke, häwän ihikukut. ");
INSERT INTO awx_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Tiwän Abrahamdä kewu uwomu umanä “Yawetä äpme nimik,” yang inikut. Ile tiwän äpmasimkäyä “Yawele täwal däkäne äpme nimik” yang using yäkaying. ");
INSERT INTO awx_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Hipdu Yawele ängelatä yekäwunetä “Abraham” yake, using inikut. ");
INSERT INTO awx_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Abraham, Yawetä gäle using yak. ‘Wawakga täpätukän tiwändeyä doxotnaläkge, nina umande hiyäkände using yänggat. ");
INSERT INTO awx_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Nätä bänip kwikwik gama, bapuka kuminamu yekäwune nanä äwä haluhalu yanggäne nanä yang bimä meyä hikngä äpme tike, iwalnä sipmäke, iwalnäle taunu towikngä däkngake, päke, yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Gätä näle wam gwälamiläkge, bapukale tiwän, kantri kewune nanä undä bänip kwikwixu äpme päning,’ yang yak, Yawetän,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tiwänä Abrahamu Aisak täpän, hipdu puyä äminäle kuwät, hipdunä Berseba kukin. Täku une yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Womdu yiwixawänä, Abrahamu using inikin. “Ulapda Naholkät mängätnä Milkaxälu engangu andukngikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Yakap täpä Us. Tiwänä ulapnä Bus, Kemuel, ");
INSERT INTO awx_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Haso, Pildas, Jidla, äwä Betuel yang dukngikut,” yang inikin. Kemuelu Aramde nanä. ");
INSERT INTO awx_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Tiwänä Betuelu Rebekale nanä. Milka Naholde mängälu engangu using 8 dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Tiwän puyä äminä mängätnäle täkulu umanä Reuma. Ile wawaxu umanä Teba, Gaham, Tahas, äwä Maka yang. ");
INSERT INTO awx_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara krismasnä 127 yiwike kumgut. ");
INSERT INTO awx_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kenankätanu taunu womdu Hebron, uwomune kupän, Abrahamu butayä natäke, kwänäm tixäwik, gwäyäm yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Gwämyämde yiwikulunetä ku Hit nanä Hebron yiwixayingu using yänikut. ");
INSERT INTO awx_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nä apuyiwit bä malä nanä. Ge kewu womduhimu täkembä namining, tiwän uhike mängätna une kwayiwit?” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tiwän Hit nanätä yäkwäle using inikin. ");
INSERT INTO awx_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Abraham bulämbam täpä, gä nin bänäkänkätanu umanda käyä. Ge ninde mätmälu gwälam hikngä däkätu gika kake yawi, doxotnanim. Tiwän axungäk täpä mätmälu undäkäne kwayiyo,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tiwän Abrahamu enake, “Ginde natäpa konggak,” yang natäke, Hit nanä u yiwikinde kayine guläk puke, ");
INSERT INTO awx_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","using yänikut. “Mängätna kwayiwitde täke natäkengu, näle map päke, Efron Soharde wawaxu gindä täkembä inining? ");
INSERT INTO awx_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Tiwän Makpela Hupgänangu Efronde kep kwayimune yiwixak däkäle moning namba naniwän, mätmätnale uhiwit,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efronu Hit nanä uläpä notnäle bänäkänkätan yiwikutnä, notnä taunde yämä däkäne u päkapu yiwikinde kayine, Abrahamu using inikut. ");
INSERT INTO awx_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Bulämbam täpä, natäxayo. Notnambamde kayine using ganinanggenggat. Hupgänanggänu donggamit; tike kewu inä uwomkät gamit. Tiwän axungäk täpä kwayiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tiwän Abrahamu hipdu yot towixu u yiwikinde kayine guläk puke, ");
INSERT INTO awx_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Efronu using inikut. “Gätä täke natäkengu, moningge namba naniwi gama awäyo. Tiwän axungäk täpä une tewit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efrondä Abrahamu using inikut. ");
INSERT INTO awx_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Abraham bulämbam täpä, natäxayo. Moning namba kewu uwomdäne silwa meyänä 400 sekel usinggä uhinangäsä. Tiwändeyä nit bimäsäle moning namba undäkä bulämbamundo. Ge axungäk täpä täke kwayiwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Unin yawän natäpän take tiwän, Abrahamdä silwa Efrondä Hit nanäle kayine yakut using, bisnis ämindä uhikakindäkäne meyänä 400 sekeldä uhikut. ");
INSERT INTO awx_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Uhiwän, Hit nanä taunde yämäne päkapu yiwikinde kayine, Efrondä kepnä Makpela nanä uwosimu Abrahamde imikut. Kep, hupgänang, äwä pa uwomune nanä yangu undä inäle imikut. ");
INSERT INTO awx_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Imän mängätnä hupgänangu Makpela nanä undäkäne täku tekut. Makpelaxät Mamrexälu wäkngäsim wäkngäsim, tiwän Hebronkätan. Tiwänä Hebronu Kenankätan. ");
INSERT INTO awx_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hit nanätä kewu uwom äwä hupgänangu undäkä yangu mätmätnäle tupäkände inäle imikin. ");
INSERT INTO awx_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamdä inaka pahakulu, Yawetä bänip kwikwik yämän, nomängän tikin. Tixawän Abrahamu äminäläke hikngä damäsim tikut. ");
INSERT INTO awx_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Puyä äminde kuhiläle yiwixäwik hängä täpänä daying yiwixak täpä using inikut. “Wawaknga Aisaxu mängätnä ane Kenan nanä mayangämiyo. Tike kantrinane ku, mängälä ninaxät nanä täpätu täkapu imiläkge natät. Ge kätakga bakanale kematde täxäwik, Anätu Yawe kepkät yekäpkät pahakut täpäle umande ‘Usingu äpme tahawit,’ yangu hiyäkände hikngä naniyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tiwän puyä äminätä using inikut. “Ngä axu yäwa, mängäla täpätä ane apikge ämbitäwänu, dasing? Täkembä apu wawakga une täke kuwit?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iniwän Abrahamdä using inikut. “Wawaknga uwomune mahikngä täke kuyo. ");
INSERT INTO awx_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe Anätu yekäwune nanä täpätä naniwän, kepna äwä kepnotna yang peke ane apa, hiyäkän wamu using nanikut. ‘Bapukambamde kewu awomu äpme yämit,’ yang nanikut. Ge itä ängelanä gämäxu äpme iningyäpiwän kuxawänä kuwi, mängälä uwomune nana täpätutä ‘Täke’ yangu äpme yawän, wawakngale täkapiläk. ");
INSERT INTO awx_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mängälä täpä gäxät ane apsimäläkge ambitäwänu, hiyäkän wamu Anätule umande yäwiläkgä meyä manggamiyok. Tike wawaknga une maläke kuyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tiwänä puyä äminätä towikngä Abrahamde baki kematde katäkngätä täxäwik, “Wamu u yänggaläk using hikngä äpme tahawit yangu Anätule umande ganinggat,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Abrahamde puyä äminätä hängä gwälamgwälamu Abrahamdäne päke, kamelu Abrahamdäne 10 päke kukut. Kuhika, kewu Mesopotemia kuke, taunu Nahor kundopgut. ");
INSERT INTO awx_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kewu alukwäxawän kundoke, yanggä gäpma, taun kwayimune yiwixak däkäne kuke, kamelu ile inälängän yäniwän puku yiwikin. Täpduxu usä womune, mängälätä yanggä uhiningge kukakinunin. ");
INSERT INTO awx_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ge ile tiwän tumuk wamu using yakut. “O Yawe, gä towiknga Abrahamde Anätu. Abrahamu towiknga. Ge Abrahamde gwälam hikngä tahake, gatängamiyo. Tiwän puyä pahawa täke tiwik. ");
INSERT INTO awx_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nä yanggä gäpma andäkane yiwäxäwa, mängälä mätexu taunune nanä yanggä uhiningge aapukaying. ");
INSERT INTO awx_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ge mängälä täpätu apän, ‘Yanggälumändanetä yanggä uhike nami tängopa,’ yang iniwit. Iniwa mängälä uläpätä yäkwäle wamu ‘Tangop. Tiwän kameldalexäyä uhike yäma,’ yang yawänu, ‘Mängälä uläpä puyä äminda Aisakge tuwänguläxunin,’ yang natäke, ‘Gätä towiknga Abrahamde gwälam hikngä alahaläk,’ yang natäpit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tumuk wamu ayäxawänggän, Rebeka yanggälumänä gwälamike apgut. Mängälä uläpä Betuelde yäpa. Tiwän Betuelu Nahorkät Milkaxätde wawak. Tiwän Nahoru Abrahamde notnä. ");
INSERT INTO awx_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka nomnä däkä gwälam hikngä. Tiwän mängälä mätek. Wäwi täpätuxälu doyiwikumäläk. Rebeka yanggä gäpmane puku yanggälumänäne uhike, hipdu akopgut. ");
INSERT INTO awx_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Akopän Abrahamde puyä ämindä yupsäng ku using inikut. “Yanggä yanggälumändane täläxu täkembä nami tängopit?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Iniwän “Täke, bulämbam täpäna,” yang inike, yanggä anggwälamikulu yupsäng täkepuke imän tängopgut. ");
INSERT INTO awx_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Tiwän mängälä mätexu uläpätä using inikut. “Yanggä kameldalexäyä uhike yäma inä natäpning using tängopning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Inike yanggä yanggälumänune nanä kamelde gehanune yupsäng piwän yiwä, hipdu yanggä gäpmane ihapmäke täku uhipäkapu pingyäminggawän, kamelu undä tängopä, täke tikut. ");
INSERT INTO awx_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tixawänu puyä äminu uläpä wamu doyake axupitang yiwikut. Yiwixäwik “Nätä natäke apulu, Yawetä äpmembä tahawän, nomänu tiwän kawit,” yang natäxäwik kang yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tiwän kamelu tängopäyä, puyä ämindä nomtäpänäle goldä pahakinu gutonggu äwä kätahiwu goldä pahakinu gutongalä yangu yäkngänetä sikut. Nomtäpänäle goldä pahakinu unggutongu meyänä 5 grem. Tiwän kätahiwu goldä pahakinu unggutongalu meyänä 100 grem. Tiwän moningu inulunggä uhinangäsä. ");
INSERT INTO awx_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Sikengä using inikut. “Täkembä naniwiläk? Ngä gä iminde yäpa? Nanggale yotkätanu awetnangäsä käyä? Tiwänä äminu näxät apumängu une täke bä petnim?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iniwän “Nä Betuelde yäpa. Nana Betuelu Nahorkät Milkaxätde wawak,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Inike unetäkänu using inikut. “Kameldale nakngä äwä awetnangäsä yangu käyä. Tiwän yolu gindä petningge käyä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Iniwän puyä äminu uläpätä Yawele sopäsopä puke, däme kepkätan täpu temäke, tumuk wamu using yakut. ");
INSERT INTO awx_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Yawe towiknga Abrahamde Anätu uläpäle uman tängenäkgat. Yawetä towikngale iwikge natäxäwik, gwälam hikngä tahanggak. Ile tahanggak usinggän, näxäyä towikngale notnäle yolune hikngä nanitäkapuk,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tiwän mängälä mätexu uläpätä ihapmäke, mingäle yolune ku hängä dasingga apän kakulu undä yänikut. ");
INSERT INTO awx_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeka haminä täpätu käyä. Umanä Laban. Rebekatä apän, Labandä nomnäne nomtäpänäle tekut gutongkät kätahiwu kätakngäne pekut gutongatkät dayipgut. Tiwän Rebekatä “Äminu täpätutä using nanik,” yang yäniwän natäke, haminä Labanu äminu uläpäle yupsäng kukut. Kungu kamelnäxät yanggä gäpma däkäne inälängän yiwixäwä dayipgut. ");
INSERT INTO awx_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Dayike äminu uläpä using inikut. “Gä Yawetä bänip kwikwik gaminggaxunin. Kepmänu inale yiwixaläk? Yotna aländäkngake, kameldä petnangäsä womkäyä aländäkngat. Ge api kukana,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Iniwän äminu uläpä, puyä ämin notnä, kamel yangu Labande yolune kukin. Kuwä hängäläpä kamelune päko pekinu päkepu pekin. Tiwän kamelde nakngä, gras yang yämike, äminu uläpäxät puyä ämin notnäxätdä bälängä hälutningge yanggä päkapu yämikin. ");
INSERT INTO awx_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Tikengä naxu päkapu yämä, äminu uläpätä using yakut. “Nä naxu yupsängu donäpit. Tike wamu natälunin gämäk danikengä näpit,” yang yakut. Yawän Labandä “Täke niniwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tiwän äminu uläpätä using yakut. “Nä Abrahamde puyä ämin. ");
INSERT INTO awx_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawetä towiknga bänip kwikwik imän, hängänämbamgän tikut. Sipsip, towiyä gämän, silwa, gol, puyä äminu mängälä wäwi, kamel, donggi yang imikut. ");
INSERT INTO awx_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Towikngale mängälu Sara äminäläke hikngä alikengä, engangä wäwi täpätu dukngikut. Tiwänä towiknga Abrahamdä hängä täpänä undä wawakngä uläpälekän imikut. ");
INSERT INTO awx_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","“Tikengä wamu kitokngä hikngä täknga using nanikut. ‘Anätule umande “Usingu äpme tahawit,” yangu hiyäkände hikngä naniyo. Wawakngale mängälu ane Kenan nanä mayangämiyo. Tike nanale notnämbamde kuke, mängälä mätexu ninaxät nanä täpätu täkapu wawakngale imiyo,’ yang nanikut. ");
INSERT INTO awx_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Naniwän using inikum. ‘Ngä axu yäwa, mängäla täpätä ane apikge ambitäwänu, dasing tahawit?’ yang iniwa, using nanikut. ");
INSERT INTO awx_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“‘Nä Yawele wam gwälaminggatde, itä ängelanä äpme iningyäpiwän, ixät kuhimäläk. Tiwän itä gatänggamän, mängälä kepnotna tiwän ninaxät nanä hikngä täpätu äpme täkapu wawakngale imiläk. ");
INSERT INTO awx_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tike kepnotnale kuwi, axotnake mängälä täpätu donggamä kakengu, wamu Anätule umande hiyäkände hikngä u naninggaläk täkngatä meyä donggamik,’ yang nanikut,” yang yänikut, Abrahamde puyä ämindän. ");
INSERT INTO awx_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Unetäkänu using yänikut. “Äpmanu yanggä gäpma däkäne apukengu, Yawe using init. ‘O Yawe, towiknga Abrahamde Anätu. Malätä hikngä apunggat. Ge nätä ahikngä natäke apulu, gätä gatängamiyo. Tiwän puyä pahawilu nomän tiwik. ");
INSERT INTO awx_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nä yanggä gäpma andäkane yiwixawit. Tixawän mängälä mätexu täpätutä yanggä uhiwikge apänu, “Yanggälumändanetä yanggä uhike nami tängopa,” yang iniwit. ");
INSERT INTO awx_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Iniwa mängälä uläpätä yäkwäle wamu “Tängop. Tiwänä kameldalexäyä uhike yäma,” yang naniwänu, “Mängälä aläpä Yawetä towikngale wawakge tuwänguxunin,” yang natäpit,’ yang init. ");
INSERT INTO awx_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Tumuk wamu bänipnane ayäxäwakän, Rebeka yanggälumänä gwälamike apuk. Apuke yanggä gäpmane puku yanggälumänäne uhiwän, using init. ‘Yanggä täkembä nami tängopit?’ yang init. ");
INSERT INTO awx_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Iniwa yanggä anggwälamixu yupsäng täkepu namike, using nanik. ‘Tängop. Tiwän kameldalexäyä uhike yäma,’ yang nanik. Tiwän tängopa, kameldexäyä uhike yämän tängoying. ");
INSERT INTO awx_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Tiwänä ‘Gä iminde yäpa?’ yang init. “Iniwa ‘Nä Betuelde yäpa. Nana Betuelu Nahorkät Milkaxätde wawak,’ yang nanik. “Naniwän, nomnäne nomtäpänäle tengämike, kätakngäne kätahiwu pengämit. ");
INSERT INTO awx_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tikengä sopäsopä puke, dämäna kepkätan täpu temäke, Yawele tumuk tahat. Towiknga Abrahamde Anätu uläpäle uman yatängenat, inale itä towikngale daknotnäle yäpa nätä towikngale wawakge täku imitde nanitäkapuk,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Yänike using yänikut. “Ge gindä towikngale natäke, gwälam tahaningge natäkengu, täke nanining. Tike gwälamu dolahaningge natäkengu, ixäyä täke nanining. Tiwän nä dasingga tahawit yangu natäpit,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tiwänä Labankät Betuelkätdä yäkwäle wamu using inikumäläk. “Hängä aläknga Yawetä tahanggak. Ge nindä täke bä täkendo yangu yänangäsändo. ");
INSERT INTO awx_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Täke, täke täke kuwiläk. Yawetä natäk using, täku towikgale wawakge imi, mängätnäle täpik,” yang iniwät, ");
INSERT INTO awx_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","natäke Abrahamde puyä äminu uläpätä Yawele sopäsopä puke, däme kepkätan täpu temgut. ");
INSERT INTO awx_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tikengä hängä gol silwa yanggä pahakinu Rebekatä pahanangäsä äwä täwik yangu Abrahamde puyä ämindä yäkngänetä sike imikut. Imikengä bänip gwalängge haminäxät mingäxätde hängä moningu kopsä hikngätä uhikayingunin yämikut. ");
INSERT INTO awx_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Tiwänä äminu uläpäxät notnä apginkälu naxu nake, kupilä unggwenune däpmunä une pekin. Kwepdätä enake, äminu uläpätä using yakut. “Nä äpmanu towikngale täkembä kunggawit?” yang yäniwän, ");
INSERT INTO awx_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","mängälä uläpäle haminkät mingäxätdä yäkwäle wamu using yakumäläk. “Mängälä täpä nihäxät yiwixätna, täpduxu 10 usä apuxuwänä kunong,” yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Iniwät deyä using yänikut. “Nätä natäke apgumu, Yawetä gatängamän, puyä pahalu nomänu alik. Ge mananindäkngänong. Tewä tokwikngale kunggäwa,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yäniwän using inikumäläk. “Mängälä uläpä inina inä mapdä hikngä yäwik,” yang inike, ");
INSERT INTO awx_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebeka yatäwambät apän “Äminu aläpäxälu äpmanu axuhimäläk?” yang iniwät, “Täke. Äpme kuhim,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tiwänä Rebeka, mängälä Rebeka kang yiwixak täpä, äwä Abrahamde puyä äminä apgin yangu axuningge tahaxawä, ");
INSERT INTO awx_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rebeka wam gwalängu using imikin. “O Rebeka, gä engangu meyä hikgnäle apekngä däkngawiläk. Tiwän bapukambamdä enake, iwalnä sipmäke, yot gäpanggäpangu päning,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Iniwäyä Rebeka äwä mängälä puyä äminäle päpän pahangämikaying täkwäk yangu kamel tängäne päko yiwä, yolu uwomu teke, Abrahamde puyä äminätä gämäk kuxawän kukin. Abrahamde puyä äminu uläpä using tahake, Rebeka täke kukut. ");
INSERT INTO awx_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisaxu kewu Negep uwomune päku yiwikutnä, Käluk Yiwäxäwik Nanduxak Täpäle Yanggä teke, hipdu apgut. ");
INSERT INTO awx_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Gwendune tukwatde hikngä, songäxätan ku moyo tihikuhika, kwayiwän enawän tahakengu, kamelu apunggäwä kakut. ");
INSERT INTO awx_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tixawän Rebekaxäyä kwayiwän enawänu, Aisaxu tupäkände kakut. Kakengu kamel tängänetä pälängepuke, ");
INSERT INTO awx_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“Äminu ätuläpä nin nindupikge apunggaxu imin?” yang inikut, Abrahamde puyä äminun. Iniwänu “Näle towiknga, Aisak,” yang inikut. Tiwän Rebeka täwikngä täke, nomnä omik umukut. ");
INSERT INTO awx_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tiwänä Aisaxu puyä äminätä hängä dasinggä tahakulu, undä une inikut. ");
INSERT INTO awx_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tiwänä Aisakgä Rebeka mingä Sarale selyolune initäke koke, mängätnäle täkut. Täke Rebekale täke hikngä natäpgut. Mingätä kupänu butayä täkngane yiwikulu, Rebekatä apungä, Aisakge bäniwu tänguwän epgut. ");
INSERT INTO awx_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Sara kupänä, Abrahamu mängätnä hipdu täpätuxäyä äläkut. Umanä Ketura. ");
INSERT INTO awx_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Tiwän itä dukngikulu, wawakngä 6. Umanä Simran, Joksan, Medan, Midian, Isbak äwä Sua yang. ");
INSERT INTO awx_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksandä täkake, wawakngä itä towikulu Seba Dedan yang. Tiwänä Dedandä täkake Asu, Letus, äwä Leum yang towikut. Tiwän unetä sakngälake Asu, Letus, äwä Leum yangge bapunä yaxäwik yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Tixawänu Midianu, wawakngä 5 towikut. Umanä Epa, Eper, Hanok, Abida äwä Elda yang. Äminu aläkwäxu Abrahamde mängälu Ketulale ayinä. ");
INSERT INTO awx_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Abrahamu mängätnä Sarale mehene päkutde wawakge hängä bänip gwalängge doxungäxäwik uhike yämikut. Yämike Aisaxu inäkän yiwikge natäke yäningyäpiwän, uwomu teke, kewu gusitdä akonggak käwut päku yiwikin. Tiwänä hängänä undä wawakngä Aisakgekän pengämikut. ");
INSERT INTO awx_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamu krismasnä unekänu 175 yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Bänip kwikwixune krismasu naxälä yiwixäwik, äminäläke hikngä tikut. Tike kungäke, bapunä tupä kumginde kukut. ");
INSERT INTO awx_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Tiwänä wawakngä Aisakät Ismaelkätdä nanäle guwu täku, hupgänangu Makpela nanä däkäne tekumäläk. Makpeläxät Mamrexälu wäkngasim wäkngasim. Tiwän hupgänangu undäkä Epronde kewune yiwixakut. Epronu Hit nanä, tiwän Soharde wawak. ");
INSERT INTO awx_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Kep, hupgänangu undäkä yangu mängätnä Sara tewikge natäkengu, Abrahamdä Hit nanäle kätaxune tupä auhike, mängätnä Sara hupgänangu undäkäne tekut. Ge inä kupänkäyä, wawakngätä undäkänekän tekumäläk. ");
INSERT INTO awx_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahamu kupänä, wawakngä Aisaxu Anätutä bänip kwikwik imixawän, Käluk Yiwixäwik Nanduxak Täpäle Yanggäle wäkngäsim yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Wamu aläknga Abrahamkät Hagarkätde wawaxu Ismaelde wam. Hagaru Isip nanä uläpä Sarale puyä äminde yiwikulunin. ");
INSERT INTO awx_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Wawakngä Ismaelde wawakge umanu yakap täpänetä ku wasekngä täpäne using. Yakap täpä Nebaiot, ile mehene Kedar, ile mehene Adbel, ile mehene Mipsam, ");
INSERT INTO awx_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ile mehene Misma, ile mehene Duma, ile mehene Masa, ");
INSERT INTO awx_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ile mehene Hadad, ile mehene Tema, ile mehene Jetur, ile mehene Napis, tiwänä wäsekngä täpä Kedema. ");
INSERT INTO awx_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismaelde wawaxu 12 uläkwäxu yolu inäinä gäpanggäpang ku pahake yiwitäke kukin. Tikengä yolu unggäpanggäpang pahakinde kuhiläle inä yiwitäke kukin. Yolu u ku pahake yiwikin wopwomu bapunä mahande alake yiwikindä yot umanu bapunä yakawu u yiwikinde uman yänikin. ");
INSERT INTO awx_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelu krismasnä 137 yiwike kumgut. Kungäke bapunä tupä kumginde kukut. ");
INSERT INTO awx_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tixawän bapunä mahande alakindä kewu Hawilaxät Surkätde bänäkängän päku yiwikin. Hawila Sur yangu Isipkät Asurkätde bänäkän yiwikumäläk, tiwän Isipde wäkngäsim. Ismaelde bapunätä Aisakge bapunä tokngä dayipä yäkwälexäyä usinggän pahawä yiwixakin. ");
INSERT INTO awx_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Wamu alakngä Abrahamde wawaxu Aisakge wam. Abrahamdä wawakngä Aisak towimbän, ");
INSERT INTO awx_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisaxu krismasnä 40 yiwikengä, mängätnä Rebeka täkut. Rebekale nanäle umanu Betuel. Tiwän haminäle umanu Laban. Betuel yänggwälu Aram nanä. Tiwän kewu Mesopotemia yiwixakin. Ge ile yäpa Aisakgä täkut. ");
INSERT INTO awx_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Täkutnä engang hongge yiwän, mängätnäle natäke, Aisakgä Yawe tumuk wam inikut. Iniwän Yawetä gatängämän, tängene kayä tikut. ");
INSERT INTO awx_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebekale bäniwune engangu täpäyalatä yiwike, mingäle bänipkätan amgumälak. Tiwän “Usingu inaleka tinggak?” yake, Yawele yawänyak tahakut. ");
INSERT INTO awx_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Tahawänu Yawetä using inikut. “Tängäkane engangu täpäyalä. Tiwän uläpäyalu kantri gäpangalä äpme upuke yiwisimäläk. Tikengä gäpanggutä äpme kitokake, notnä yapmitning. Tiwän payänä ulapnäle gepbine äpme yiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ge täpduxu engang dayike päkut gwenune wawakngä ukgatäp dayike päkut. ");
INSERT INTO awx_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wawakngä yakap apgut täpäle guwu gämänä, tiwän dänggämnämbamgän. Tiwän umanä Iso yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tiwänä mahande apgulu payänäle bäläng tänggänggänuxäwik apän, umanä Jekop yang inikin. Aisaxu krismasnä 60 yiwixawän, mängätnä Rebekätä wawakngä uläpäyalu une dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tiwänä yiwitäke kuhika, wawakngä uläpäyalu inulung täpäyat tike, Iso songäne tihikuxäwik, kälawu buläkän sipmäkakut. Tixawän Jekowu selyot däkändäkäne säkge yiwixakut. ");
INSERT INTO awx_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisaxu kälaptuk näpikge täke hikngä nätäxakut. Ge wawakngä Isole ilakngä hikngä natängämikakut. Tixawänu Rebekatä Jekopde ilakngä hikngä natängämikakut. ");
INSERT INTO awx_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Gwendune Jekowu nak haxawän, Iso songänetä nakngäle hikngä tixawä apgut. ");
INSERT INTO awx_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Apu Jekowu using inikut. “Nakgnale hikngä tikaying. Ge gapek salinu gämänä uhanggaläxu notnä yupsäng nami nänggäwa,” yang inikut. (Ile tiwän Iso umanä täkngatu Idom yang inikin.) ");
INSERT INTO awx_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Iniwän Jekopdä using inikut. “Gätä gämäk alakuläk. Ge nanitdä kupänu, ile hängäläpä meyä päpiläxunin. Tike gätä ‘Hängä wawakngä yakap täpätä päkayingu gätä täke päpiläk,’ yang naniwi, naxu äpme gamit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iniwän Isotä inikut. “Nä nakngale hikngä tiwä axumnanggenggat. Hängä uläkwäkge inale natäpit?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iniwän Jekopdä using inikut. “‘Anätule umande wamu hiyäkände hikngä yänggat’ yang naniwiyä gamit,” yang iniwän, Isotä “Hängä uläkwäxu täke päpiläk,” yangu Anätule umande inikut. ");
INSERT INTO awx_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Iniwänä Jekopdä bret gapek salin yang imän naxäwik, yanggä tängopgut. Tikengä enake, teke kukut. Unin tahake, Iso wawaxu yakap täpätä pänangäsä hängä hapduke, ulapnätä päpikge inikut. ");
INSERT INTO awx_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kewu uwomkätanu gusit täpduk tiwän, naxu wenä hikngä tikut. Gusit täpduxu Abrahamdä yiwixawän tikut usinggän tikut. Tiwän Aisaxu kantri Filistiale kewune, taunu Gerar unggäpangune päku yiwikut. Täpduxu uwomune Fisilitia nanäle kingge Abimelekgä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tiwänä Yawetä apu Aisaxu using inikut. “Isiwu mawäpu yiwiyo. Tike kewu nätä ganiwit womune yiwiyo. ");
INSERT INTO awx_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Täpduxu womduhimu kewu awomune yiwixayo. Tixawän nä gäxät gatäke yiwixäwik, bänip kwikwik gamit. Wamu nina umande Abrahamu kitokngä inikumde, gä bapuka mahande alatning yangge kewu awopwomu undä äpme damit ");
INSERT INTO awx_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","5","Abrahamdä wamu imikum, mämä wamna imikum yangu undä hikngä täwakut. Ge ile natäke, nätä pahawa, bapuka kuminamu yekäwune nanä bimä meyä hikngä tiwä, kewu awopwomu undä damit. Tiwän bapuka mahande alatningge tiwänu, kantri kewune nanä undä bänip kwikwik päning,” yang iniwän, ");
INSERT INTO awx_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Asaixu Gerar yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tiwän äminu uwomune nanätä Rebeka kake, “Mängälä aläpä däsäka?” yang iniwä, Asaixu using natäpgut. “Rebeka gwälam hikngä. Ge ‘mängätna’ yäwa, Rebekale tahakengu, wäwi ane nanätä änuwä kungäxäwa täningunin,” yang natäke, “Hamina,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Tikengä Aisaxu uwomune belakngä womsim yiwikut. Ge gwendune Filistia nanäle kingu Abimelekgä winduane hapäpu kaxawänu, Aisakgä mängätnä Rebeka tänggäwän kakut. ");
INSERT INTO awx_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kake Abimelekgä Aisaxu yatäwämbän apän, “Mängälä uläpä mängätda tiwändeyä ‘Hamina’ yangu kemu inale yakuläk?’ yang inikut. Iniwän Aisakgä, “‘Rebekale tahake nutnäng,’ yake yakum,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Iniwän “Gä ninde usingu dasingge tahakuläk? Wäwi täpätutä mängätdaxälu äyiwikin gämu, gätä tahake meyä nimim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tikengä Abimelekgä äminbamde mämä wamu using yatewän kukut. “Äminu täpätutä wäwi aläpä bä mängätnä meyä imänu, uläpä kupsäle tängutning,” yakut. ");
INSERT INTO awx_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Kewu uwomune Aisakgä nak puyä pahakut. Tiwän Yawetä bänip kwikwik imän, krismasu unggwenu naxu meyä hikngä alakin. ");
INSERT INTO awx_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tiwän Aisaxu hängänämbamgän tiwä, hängänä meyä tinggäwä, hängänämbämgän hikngä tikut. ");
INSERT INTO awx_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aisakge towiyä gämän, sipsip, äwä puyä ämin yangu meyä hikngä tiwä, äminu Filistia nanätä “Hängä uläpäläpä nihä pänangäsä,” yang natäke, Aisaxu mähe natängämikin. ");
INSERT INTO awx_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mähe natängämixäwik, yanggä gäpma undä nanä Abrahamde täpduxune puyä äminätä kwayikin däkändäkä, Filistia nanätä kepdä kwayipänguhikin. ");
INSERT INTO awx_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tiwän Abimelekgä Aisaxu using inikut. “Gä kitokngäka inulung hikngä alik. Ge nipmake kunggayo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tiwän Aisaxu uwomu teke, Gerar Kupi päku selyotnä täpike yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tikengä yanggä gäpma nanä Abrahamde täpduxune kwayikinä, Abrahamdä kungäxawän, Filistia nanätä kwayipänguhikinu, Aisakgä hipdu kwayipäpän täkawä, umanä inäinä nanätä yänikut using yänikut. ");
INSERT INTO awx_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Tiwänä kupi unggwenune Aisakge puyä ämindä kep kwayike, yanggä akondokayingu däkätu kakin. ");
INSERT INTO awx_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tiwändeyä äminu Gerar nanä kälap daying yiwixaying äwä äminu Aisakge kälap daying yiwixaying yanggä yanganike, Gerar nanätä “Yanggä gäpma undäkä nindäne,” yang yakin. Ge Aisakgä yanggä gäpma undäkä umanä Esek yang inikut, inale ile tahake yanganikin. ");
INSERT INTO awx_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tiwänä hipdu yanggä gäpma däkätu kwayiwä teyä ilexäyä äyanganikin. Tiwän umanä Sitna yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Tikengä uwomu teke päku womdune yiwike, hipdu yanggä gäpma däkätu kwayiwä, undäkäle doyanganikin. Tiwän Aisakgä “Yawetä kewu wangga womdu animinggakngä, engangu meyä dukngitna sakngälatning,” yake, umanä Rehobot yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Tiwänä uwomunetä Berseba kopgut. ");
INSERT INTO awx_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tiwän Yawetä kupilä unggwenune apu inikut. “Nä nangga Abrahamde Anätu. Manaxälayo, inale nä gäxät yiwixamäk. Puyä ämina Abrahamde tiwän, äpme bänip kwikwik gama, bapuka meyä yiwitning,” yawän, ");
INSERT INTO awx_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aisakgä alta tahake, Yawele tumuk inikut. Inikengä selyotnä une tapikut. Tiwän puyä äminätä yanggä gäpma däkätu une kwayikin. ");
INSERT INTO awx_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Tixawänu King Abimelek, Ahusat inä kingge natändetdet iminggaxu uläpä, äwä Fikol amäk äminäle kuhiläle yiwixaxu uläpä yangu Gerar teke, Aisakge apgin. ");
INSERT INTO awx_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Apä Aisakgä “Näle mähe natäke, nawämbä apgum. Tiwändeyä näle inale apukaying?” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yäniwän, using yakin. “Yawe gäxat gatäke yiwimäläxu alänggämän hikngä kamäng. Ge using yamäng. Anätule umande hiyäkän wamu kitokngä yänim, nitkät, gäxälun. Kontrak tahana, ");
INSERT INTO awx_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","gindä ninu manihipnong. Nindäxäyä gä donggukumäng. Tike gäle täkekän tahake, bänip kwikwixune tena apguläk. Tiwän äpmanu Yawetä bänip kwikwik gaminggaxunin,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tiwänä Aisakgä naxu meyä hängyämän, naxu naxäwik, wainkät tängopgin. ");
INSERT INTO awx_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kwepdätä gwäsi hikngä, Abimelek Aisak yanggä “Amäxu dolahakahim” yangu Anätule umande yawät kitokakut. Tiwänä Aisakgä bänip kwikwixune pewän kukin. ");
INSERT INTO awx_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Täpduxu unggwenunekän, Aisaxu puyä äminätä apu yanggä gäpma kwayikindäne using inikin. “Gäpma kwayike yanggä axamäng,” yang iniwä, ");
INSERT INTO awx_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","umanä Siba yang inikut. Tiwän äpmasimkäyä taunu unggäpangu umanä Berseba. ");
INSERT INTO awx_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso krismasnä 40 yiwixäwixu, mängälä Hit nanä täpäyalä päkut. Beerile yäpa Judit äwä Elonde yäpa Basemat yang päkut. ");
INSERT INTO awx_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mängälä uläpäyatde tahake, Aisakät Rebekaxälu tokngä natäpgumäläk. ");
INSERT INTO awx_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisaxu äminäläke hikngä tiwän, kayi kupilakin. Tiwän, wawakngä yakap täpä Iso yatäwakut. Yatäwambän apän, “Wawaknga,” yang iniwän, Isotä “Nan, nä äna an. Inale yänggaläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tiwän Aisakgä “Natäpso. Nä äminäläke alit. Unggwenune kupit yangu donatät. ");
INSERT INTO awx_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ge kwälemdaxät käsimakaxälu päke, songäne ku, kälaptuk tängutäkapu namiyo. ");
INSERT INTO awx_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Alänguke täkapungu, naxu käxälä hikngä nätä näpitde natäxat using häke, päkapu nami näpit. Tikengä wam gwaläng gamikengä, kupit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Wamu Aisakgä wawakngä Iso inikulu Rebeka änatäng yiwixawän inikut. Ge Iso kälaptuk ku sipmäpäkapikge songäne kuhinggäwänä, ");
INSERT INTO awx_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekatä wawakngä Jekowu using inikut. “Natäpso. Nanggatä notda Iso using inihiwän kat. ");
INSERT INTO awx_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kälaptuk tänguke, naxu käxälä hikngä nätä näpitde häke, päkapu namiyo. Tiwän Yawele kayine wam gwaläng gämäk gamikengä kupit,’ yang inik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tikengä unetäkänu using inikut. “Wawaknga, kätak hikngä natäke, wamu angganiwit using hikngä tahayo. ");
INSERT INTO awx_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Meme dämänune ku, meme mätexu nomän hikngä gwenalä päkapu namiyo. Tiwän naxu käxälä hikngä nanggatä näpikge natäxak using hikngä hängämit. ");
INSERT INTO awx_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Tiwänä nanggatä näpikge täku imiyo. Tiwän wam gwalängu gamikengä, kupik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Iniwändeyä Jekopdä mingä Rebeka using inikut. “Notna Iso dänggämnämbamgän, tike nä usä wenä. ");
INSERT INTO awx_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nanatä gupna täpän tiwän, ‘Kem tahanggak,’ yake, wam gwaläng namikge pahawit deyä, wam wäyi namiyäk,” yang iniwän, ");
INSERT INTO awx_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","mingätä using inikut. “Wawaknga, meyä using täknga apänu, nätä täke täpit. Gä manaxälayo. Tike wamu ungganinggat using hikngä täwayo. Meme ku päkapu namiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tiwänä Jekopdä ku päkapu mingäle imän, itä naxu käxälä hikngä Aisakgä näpikge natäxak using hikngä hakut. ");
INSERT INTO awx_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Tikengä Rebekatä wawakngä yakap täpäle täwixu nomän hikngä kwämbälu yolune yiwikulu täke, wawakngä Jekopde pahangämikut. ");
INSERT INTO awx_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Pahangämike, Jekopde kätak guläkngä yangu meme gup päke, wamäng umukut. ");
INSERT INTO awx_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tikengä naxu käxälänä käyä häkut äwä brelu häkut yangu Jekopde kätaxune pekut. ");
INSERT INTO awx_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Tiwän Jekopdä nanäle ku “Nan,” yang iniwän, nanätä “Wawaknga, apunggaläk. Gä imin?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tiwän Jekopdä “Nä Iso, wawakga yakap täpänin,” yang inikut. “Wamu naniläxu awahat. Gwaxu ahake päkapulu enake nayo. Tikengä wam gwalängu namiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Iniwän “Wawaknga, yupsäng hikngä sipmäläk,” yang iniwän, “Anätuka, Yawetä gatängamän sipmät,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tiwänä Aisakgä using inikut. “Wawaknga, wäkngasim apso. Gä wawaknga Iso hikngämbä? Ge gupda tapa tiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tiwän Jekowu nanäle inälängän kuwän, nanätä kätakngä päke, “Guläkngä natäpa, Jekopde guläk tik. Tiwändeyä kätakngä päpa, Isole kätak tikaying,” yakut. ");
INSERT INTO awx_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Jekopde kätaxu dänggämnämbamgänu payänä Isole kätak bimä tiwä, nanätä “Wawaknga aläpä Jekop,” yangu doxatäpgut. Tixäwik wam gwalängu imikut. ");
INSERT INTO awx_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Wam gwalängu doimixäwixu yawänyaxu hipdu using inikut. “Wawaknga Iso, gika hikngä?” yang iniwän, Jekopdä “Nä unin,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tiwänä Aisakgä inikut. “Wawaknga, kälawu usipmäläxu käwutdu päkapu namiyo. Tiwän nake, wam gwalängu gamit,” yang yawän, päkapu imän nakut. Tixawän wainkät päkapän tängopgut. ");
INSERT INTO awx_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nakengä inikut. “Wawaknga, wäkngasim apu kis tahangamiyo,” yang iniwän, ");
INSERT INTO awx_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jekopdä apu kis tahangämikut. Tixawän Aisakgä täwixu Jekopdä tahakutde käpäng natäxäwik, wam gwalängu using imikut. “Hiyäkän. Wawakngale käpängu kewu Yawetä bänip kwikwik imikut womde käpäng bimä tinggak. ");
INSERT INTO awx_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Anätutä kepda yekäpiot imän, naxu meyä alatning. Tämbäm salin bimä äwä wainu käluk yangu meyä hikgnä gamik. ");
INSERT INTO awx_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Äminu kantri womduyine nanä puyä ämindale yiwitning. Äminbamdä sopäsopä gäle puke, kuhilä kep däkäne päpu yamning. Notdale bulämbam täpäle yiwi, minggale äyinätä sopäsopä gäle puke, kuhilä kep däkäne päpu yamning. Imin ämindäka tokngä däkä gaminingu, inäxäyä tokngä däkä päning. Tike äminu bänip kwikwik gaminingu, inäxäyä bänip kwikwik päning,” yang imikut, Aisakgä, wam gwalängun. ");
INSERT INTO awx_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisakgä wam gwalängu imipuluwänä, Jekowu nanä teke epuxukut. Tixawänu päyänä Iso kälapde kukulu apgut. ");
INSERT INTO awx_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Täkapu ixäyä naxu käxälä hikngä nanäle tändäkngake päkapgut. Päkapuke nanä using inikut. “Nan, gwaxu asipmäke hake päkapunggalu enake nayo. Tikengä wam gwalängu namiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tiwän nanätä “Gä imin?” yang iniwän, “Nä Iso, wawakga yakap täpänin,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Iniwän natäke, Aisaxu änaxäläxawän, kwätäläkwätälä duksäng yamuxawä, using inikut. “Kälawu imindä sipmäke päkapu namik? Gä ane doapuxawi nake, wam gwalängu äimit. Tiwän hiyäkände, hängä wam gwalängu imilu Anätutä pahawän bulä alawik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tiwänä Iso nanätä unin yawän natäke, butayä hikngä natäke, kwänämu bulämbam hikngä yangotikut. Yangotixäwik “Nana, näxäyä wam gwalängu änamiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Iniwän nanätä “Wenä. Notdatä kem yake, wam gwalängu gäle gamitde natälu awäk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tiwän Isotä using yakut. “Umanä Jekop yangu hiyäkände inikayingunin. Täpduxu gwenalä kem tahake, näle tängge yiwike, hängä nätäne päk. Nä wawaxu yakap täpänin, tiwändeyä kem tahake, wawaxu yakap täpä däkngakut. Ge hängä nätä pänangäsa, itä päpik. Ge äpmankäyä hipdu kem tahake, wam gwalängu nätäne itäkän päk. Nana, wam gwalängu täkngatu äleläkngä naminangge tinggaläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Iniwän Aisakgä wawakngä Iso using inikut. “Gäle bulämbam täpäle yiwän, notnämbamkäyä ile puyä ämin däknganingge ainit. Tiwän tämbam salin bimä wain yangu meyä päpikge wam gwalängu ile aimit. Ge wawaknga, gäle inaka gamit? Täkngatu wenä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iniwän Isotä using inikut. “Nana, wam gwalängu täkngatu käyä? Nälexäyä nam,” yang inike, kwänämu hipdu bulämbam tikut. ");
INSERT INTO awx_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tiwän nanätä using inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","“Kewu naxu meyä alakaying womune doyiwiläk. Kewu yekäpiyot epukaying womune doyiwiläk. Amäk tahakengä, naxu näpiläk. Notdale puyä äminde yiwiläk. Tiwändeyä mähe natäkengu, wamnä upukengä, gika kitoxune yiwike, ile gepbine doyiwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nanätä wam gwalängu Jekopde imikutde, Isotä notnä mähemähe kakut. Kake bäniyäne using yakut. “Nandä kupikge däpi alinggak. Ge kupän gwäyäm yiwitdäkngakengä, notna Jekowu älänguwa kupik,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tiwänä wamu wawakngä yakap täpä Isotä yakulu iniwä natäke, Rebekatä wawakngä Jekowu yatäwämbän apän, using inikut. “Notda Isotä gä kupsäle guwikge natäk. ");
INSERT INTO awx_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ge wamu angganiwit using pahayo. Yupsäng enake, hamina Labande Haran kunggayo. ");
INSERT INTO awx_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kuwi womduhimu ixät yiwixawät, notda bäniptoxu u natäxaxu bäniyä kwikawän, ");
INSERT INTO awx_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","gätä ile u pahaläkge bulämdawik. Tiwän wamu tewa kuwänä apiläk. Tike notdatä guwän kupi, täpduxu inä gwenunekänu täpäyale natäpitde mähe,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Tikengä Rebekatä Aisaxu using inikut. “Mängälä Hit nanä Isotä päkulu uläpäyatde mähe hikngä natäke, käluk yiwitdexäyä mähe natäxat. Tiwän Jekopkäyä mängälä Hit nanä ane yiwixayingu täpätu täpänu, yiwikyiwiknga wäyi hikngä tiwixunin,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tiwänä Aisakgä Jekowu yatäwämbän apän, wam gwaläng imike, mämä wamu using inikut. “Mängälä Kenan nanä mahikngä tayo. ");
INSERT INTO awx_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tike Mesopotemia minggale nanä Betuelde yolune kunggayo. Ku okga Labande yäpa täpätu mängätdale tayo. ");
INSERT INTO awx_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Anätu Kitokngänä Käyä Täpätä bänip kwikwik gamän, engangga naxälä towimbi, sakngälake, kantrinä inätä täke yiwitnong. ");
INSERT INTO awx_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Anätutä wam gwalängu Abrahamde imikulu, gä bapuka yangge damän, äminde kewu awom yiwixaläxu, gihäle täning. Kewu awomu Anätutä Abrahamde imikut. Ge unin täning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Inikengä Aisakgä Jekowu Labankät yiwisimäläkge Mesopotemia iningyäpiwän kukut. Labanu Aram nanä tiwän Betuelde wawak, tiwän Jekop, Iso yangge okngä. ");
INSERT INTO awx_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Jekowu kuxawänä, Iso using inikin. “Nansätä Jekowu wam gwaläng imike, mängätnä Mesopotemia nanä täpätu täpikge iniwän kuk. Tiwän wam gwaläng imixäwik, mämä wamu ‘Mängälä Kenan nanä malayo,’ yang inik. ");
INSERT INTO awx_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Tiwän Jekowu mingänanäle wam gwälamike, Mesopotemia axuk,” yang inikin, Ison. ");
INSERT INTO awx_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Unin iniwä Isotä “Nanu mängälä Kenan nanäle mähe hikngä natäxakngä tinggak” yang natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tikengä Isotä ku, Abrahamde wawaxu Ismaelde yäpa Mahalatkäyä, mängätnäle täkut. Mahalalu Nebaiotde hamin. ");
INSERT INTO awx_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Aisakgä Jekowu Mesopotemia kuwikge iniwän, Jekowu Berseba teke, Haran kuwikge kukut. ");
INSERT INTO awx_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kuhika, kewu womdune kundoke, gusilu awukukutde, une pewikge yiwikut. Tikengä petnä pewikge, huwu uwomune nanä gwendu täke, uwänenatnäle kuhiläne teke pekut. ");
INSERT INTO awx_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Peke dambu tike kaxawänu, bäläng yayixu kewunetä gäkngälunekänu kwämbätdune, Anätule ängelatä epuxäwik kopä kakut. ");
INSERT INTO awx_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tixawän Yawetä enetängä yiwike, using yakut. “Nä Yawe. Nä bapuka Abraham, nangga Aisak yangge Anätu. Nätä kewu awekgaläxu awomu, gikaxät bapukaxätde äpme damit. ");
INSERT INTO awx_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bapuka naxälä hikngä haluhalu bimä tining. Tixäwik uhike, gusitdä akonggak käwut, gusitdä pukunggak käwut, not käwut, äwä saut käwut yang päku yiwitning. Gäxät bapuxätde tiwän, yotyolu kewune nanä undä bänip kwikwik päning. ");
INSERT INTO awx_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Natäpso. Nä gäxät yiwike, sawomuneka kuwiläxu, anggandung yiwit. Tikengä kewu awomune gä hipdu täkapit. Gä donggäpmakuwit. Tike hiyäkän wamu ängganit usingu äpme pahawit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tiwänä Jekowu petnä pekulu enake, using natäpgut. “Hiyäkände, Yawe ane yiwixak. Tiwändeya nä usingbä yangu donatät,” yake, ");
INSERT INTO awx_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","anaxälake, “Kewu awomu inätä hikngä. Awomu Anätule yot, gäkngätde yämä hikngä,” yakut. ");
INSERT INTO awx_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kwepdätä gwäsi hikngä, huwu kupiläne uwänenatnäle kuhiläne tekut gwenu täke, mahande kaxäwik natäpningge däm täpän enawän, olip yanggätä huwu unggwenu pingyapmikut. ");
INSERT INTO awx_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tikengä kewu uwomu umanä Betel yang inikut. Tupä taunu ile wäkngäsim yiwixaxu unggäpangu Lus yang inikakin. ");
INSERT INTO awx_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Tikengä Jekopdä Anätule umande hiyäkän wamu using inikut. “Anätu, gä näxät yiwike, kahilu belakngä aläpä kuwilu, nandung yiwike, naxu änäpitde äwä täwixu äwahawitde yang namixawi, ");
INSERT INTO awx_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nä meyä dowäke, nanale yolune hipdu apitnä kakengu, Yawe, Anätunale gätä yiwiläk. ");
INSERT INTO awx_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tiwän huwu däm tängenake texalu anggwenu yotdale yiwik. Tiwän hängäläpä gätä namiläxu, nätä upuke 9-u ninale pexäwik, 1-u gäle gamit,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jekowu hipdu unetä enake kuhika, gusitdä akonggak käwut nanäle kewune kundopgut. ");
INSERT INTO awx_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kundokengu yanggä gäpma gwendu kakut. Sipsiwu yanggä unggwenunetä yämä tängokakin. Ge ile inälängänu sipsiwu täkwäkgu inätä pexawä, täkwäkgu inätä pexawä, täkwäkgu inätä pekgäwä dayipgut. Huwu yanggä unggwen tewä umukakulu kwälängä, tiwän meyä hikngä. ");
INSERT INTO awx_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ge sipsiwu undä unekän päkapukengä, huwu uhanu sipsip daying yiwixayinggä tekwämbä kuwän, sipsipde yanggä yämikakin. Tikengä hipdu tekwämbä apu umukakut. ");
INSERT INTO awx_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jekopdä sipsip daying yiwixaying äminu using yänikut. “Not, ginu säne nanä?” yang yäniwän, “Ninu Haran nanä,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Iniwä “Nahorde bapunä Labanu axäxayingunin?” yang yäniwän, “Hii, axäxamängunin,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Iniwä “Labanu domalik?” yang yäniwän, using inikin. “Hii, domalik. Ätuxa. Yäpanä Reselu sipsip päke ane aapunggak,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iniwä using yänikut. “Kanong. Gusilu dowukuk; bänäkängän yiwixak. Tiwän sipsiwu dämänäne päku penangäsä täpdukäyä dolik. Ge yanggänä yämike, hipdu päku pewä, nakngä näkänong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tiwändeyä using inikin. “U. Usingu tahanangäsändo. Tike sipsiwu undä päkapuke, hup hanu tekwämbä kuwänä, yanggä yäminim,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Tixawänu Reselu sipsip daying yiwixakutde, nanäle sipsip päke apundopgut. ");
INSERT INTO awx_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tiwän okngä Labande sipsip äwä yäpanä Resel yang dayike, Jekopdä ku, hup hanu yanggä gäpmale mawunetä tekwämbän kuwän, yanggä okngäle sipsipde yämikut. ");
INSERT INTO awx_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yämikengä Reselu kis tahangämike, kwänämnä initikut. ");
INSERT INTO awx_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tike “Nä nanggale haminu Rebekale wawak,” yang iniwän, Reseldä ihapmäke, ku nanä inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tiwän Labanu tälänä Jekopde yawän natäke, axäwikge ihapmäke kukut. Ku betake, kis tahangämike, yotnäne initäke kukut. Kuwän wamu undä Jekopdä natäpgulu inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Iniwän Labandä “Gä nina gup. Tiwän daknotna hikngä,” yang inikut. Jekowu Labande yolune kuwän, yekäwu gwendu une yiwikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yiwihika Labandä using inikut. “Hiyäkän, gä daknotna. Tiwändeyä puyä moyo dowahawiläk. Tike puyä pahaxawi, hängä inaka äpme gamit? Ge ‘Unin namiyo,’ yangu täke yäwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labanu yäpanä täpäyalä. Payänäle umanu Lea, tiwän ulapnäle umanu Resel. ");
INSERT INTO awx_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea kayi gwälam. Tiwän Reselu nomnä gupnä yangu gwälam hikngä. ");
INSERT INTO awx_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tiwän Jekowu Reselde täke hikngä natäke, Labanu yäkwäle wamu using inikut. “Krismasu 7 puyä ane pahaxäwa apik. Tiwän yäpaka wasekngä täpä Reselu, mängätnale namiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Iniwän Labandä “Womdune nanäle doyämit. Tike gäle täke. Ge näxät yiwisim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tiwän Jekowu Resel täpikge Labande puyä krismasu 7 pahakut. Jekowu Reselde hikngä natäpgutde, krismasu 7-de natäpänu, täpduxu gwenaläkän däpi hikngä bimä tikut. ");
INSERT INTO awx_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Krismasu 7 gwenu apuxuwänä, Jekopdä Labanu using inikut. “Täpduxu namikuläxu awahat. Ge mängätna namiyo, tiwän täpit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Iniwän Labandä naxu bulämbam hikngä gwen häke, äminu uwomune nanä undä yangyäwambän, apu nakin. ");
INSERT INTO awx_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tiwändeyä kupilä unggwenune, Labandä yäpanä Lea täkapu, Jekopde imän pekumäläk. ");
INSERT INTO awx_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Mängälä täpätuxäyä, umanä Silpa, Labandä Leale puyä äminäle imikut. ");
INSERT INTO awx_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kwepdätä tembänä enakengu, Lea kake, Jekopdä Labanu using ku inikut. “Gutongä uläknga näle inale tahakuläk? Puyäka Reselde natäke pahakum. Tiwändeyä kem yake, Lea namikuläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Iniwän Labandä yäkwäle wamu using inikut. “Ninu ane nanä, ulapnä gämäxu doyämikamängunin. Payänä gämäk yämikamängunin. ");
INSERT INTO awx_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Lea täkuläkge, sande anggwen yiwitna puluwänä, ulapnä Reselkäyä gaminim. Tiwänä ile yäkwäle krismasu 7-u hipdu pahawiläk,” yang inikut, Labandän. ");
INSERT INTO awx_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Tiwän Jekopdä täke yawän, sande unggwenu yiwä puluwän, Labandä yäpanä Reselu mängätnäle imikut. ");
INSERT INTO awx_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Imike Labandä Reseldexäyä mängälä täpätu umanä Bilha uläpä puyä äminäle yiwikge imikut. ");
INSERT INTO awx_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tiwän Jekowu Reselkät yiwike, Reselde täke hikngä natäpgut. Tike Leale using hikngä donatäpgut. Tikengä Labande puyä krismasu 7-u hipdu pahakut. ");
INSERT INTO awx_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jekopdä ilakngäkänu Reselde tahakut usingu, Leale dolahawän kake, Yawetä Lea gatängämike tahawän, engangu dukngikut. Tixawänu Reselu engang hongge yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea tängene käyä tiwän, wawakngä täpätu dukngikut. Dukngike “Yawetä meyä pälu axak. Ge äpmanu Jekopdä näle täke natäpik,” yake, umanä Ruben yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tiwänä hipdu tängene käyä tiwän, wawakngä täpätuxät dukngikut. Dukngike “Jekopdä näle täke donatäkge Yawetä natäke, wawaknga aläpäxäyä namik,” yake, umanä Simeon yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tiwänä hipdu tängene käyä tiwän, wawakngä täpätuxät dukngikut. Dukngike, “Wawakngilu täpäyalä täpätu dukngikgat. Ge Jekowu näxälu äpme gatäke yiwisim,” yake, umanä Livai yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tiwänä hipdu tängene käyä tiwän, wawakngä täpätuxät dukngikut. Dukngike, “Äpmanu Yawele uman yatängenäwit,” yake, umanä Juda yang inikut. Tikengä täpduxu womsimu engangu hipdu dondukngikut. ");
INSERT INTO awx_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Reselu inäle natäpänu, engangu dukngitnangäsä dolikut. Tiwän “Ninaxäyä engangu andukngitnangäsä,” yake, payänä mähemähe kakut. Kake Jekowu using inikut. “Engang namiyo. Tike donamiläxu axupit!” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Iniwän Jekopdä tokngä natäke, using inikut. “Nä Anätundo. Bänipda nätä umumba engangu dondukngiläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Iniwän Reseldä using inikut. “Puyä ämina Bilha äna an. Ixät peson, tiwän itä enganga äpme dukngiwik. Tiwän näxäyä engangge mingä däkngawit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Inikengä puyä äminä Jekopde imän, mängätnä däkngawän, ixät pekumäläk. ");
INSERT INTO awx_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tiwän Bilha tängene käyä tiwän, wawakngä dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Dukngike imän Reseldä using yakut. “Anätutä uhinggike nandupän, nä ämin nomän tiwän, tumuk wamu yäwa natäke, wawaknga namik,” yang yake, umanä Dan yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tiwänä puyä äminä Bilha hipdu tängene käyä tiwän, wawakngä täpätuxät dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Dukngike imän Reseldä using yakut. “Payänaxät amäxu bulämbam tahake, nätä yapmit,” yake, umanä Naptali yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea inäle natäpänu, engangu hipdu dukngitnangäsä dolikut. Tiwän puyä äminä Silpa Jekopde imän, mängätnä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Tikengä Silpatä wawakngä dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Dukngiwän kuläkake, Leatä “Näle usingu tinangäsändo teyä alinggak,” yake umanä Gad yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tiwänä Leale puyä äminä wawakngä täpätuxät hipdu dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Dukngiwän Leatä using yakut. “Axuläkänggat. Ge mängälä notnatä nandukengu ‘Axuläkänggaxunin,’ yang nanining,” yake, umanä Aser yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wit pänangäsä dändän tiwän, Rubendä songäne ku, songäsongä awäke napä tängäne kayä tikayingu kwämbätdule salin päke päkapu, mingä Leale imikut. Rubendä mingäle unin imän kake, Reseldä Lea using inikut. “Songäsongä salinu notnä täkembä namiläk?” yang iniwändeyä, ");
INSERT INTO awx_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","payänätä using inikut. “Äpna aläkuläxunekän, songäsongä salinu wawakngatä namikäyä täpiläkge yänggaläk?” yang inikut. Iniwän Reseldä using inikut. “Songäsongä salinu wawakgatä gamixu notnä namixawi, yäkwäle kupilä anggwenune pesimäläkge, Jekowu äpme gamit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tukwatde tiwän, Jekowu puyänetä apuxawän, Leatä ku using inikut. “Äpmanu gäxät yiwisim, inale gä songäsongä salinu wawakngatä namikgä auhit,” yang inikut. Ge kupilä unggwenune ixät pekumäläk. ");
INSERT INTO awx_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tiwän Anätutä Leale natäke tahawän, tängene käyä tiwän, wawakngä 5 täpä dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Dukngike using yakut. “Puyä ämina tupä apnale ima, ixät pekumäläkge, Anätutä ile natäke, yäkwäle wawaknga namik,” yang yake, umanä Isakar yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tikengä hipdu Lea tängene käyä tiwän, wawakngä 6 täpäxäyä dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Dukngikengä using yakut. “Anätutä bänip gwalängge hängä gwälam hikngä naminggak. Ge äpmanu Jekopdä natäpänu axopit, inale wawakngilu 6 dukngikgat,” yang yake, umanä Sebulun yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tikengä womduhim yiwihikangu, yäpanä täpätu dukngikut. Dukngike umanä Daina yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tiwänä Anätutä Reselde natäke, gatängämike tahawän, engang alätnangäsä täke tikut. ");
INSERT INTO awx_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tiwänä tängene käyä tiwän, wawakngä dukngike, using yakut. “Anätutä mayäkngä nätäne täknga awahawän hopikaying. ");
INSERT INTO awx_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ge wawaknga täpätuxäyä anamikge natäxat,” yang yake, umanä Josep yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Reseldä Josewu dukngiwänä, Jekopdä Labanu using inikut. “Nä kantrinane yotnane kunggäwitde natäxat. Ge yawi kunggäwa. ");
INSERT INTO awx_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mängätna enganga yangge natäke, puyä awahanggamit. Ge nami, päke kunggäwa, inale puyä bulämbam hikngä pahalu, gika änanduläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Iniwän Labandä yäkwäle wamu using inikut. “Nä ilakngä nanduxaläkngä kakengu, manäpmake kuyo. Gäle tiwän, Yawetä bänip kwikwixu namixu, tuwängune apä andayitapmät. Ge maxuyo. ");
INSERT INTO awx_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tike inaleka natäkengu, täke yäwiläk, tiwän inä using gamit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iniwän Jekopdä using inikut. “Puyä bulämbam hikngä pahaxäwik, kälapda daying yiwixäwa, nomängän yiwiyingu, gika änanduläk. ");
INSERT INTO awx_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nä ane doapuxäwa, kälapda mätekngä yiwikin. Tiwändeyä nätä ane apuke, kälapda sänesäneka päke tihikuxäwa, Yawetä bänip kwikwik gamixawän, kälapda meyä hikngä asakngälak. Ge äpmanu nä hängäläpä nihä yänggwätsimdäne daying yiwitnangäsä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Iniwän Labandä “Hängä ina bimä gamit?” yang inikut. Iniwän Jekopdä yäkwäle using inikut. “Nä hängä täpätu manamiyo. Tike gätä täke yawi, hipdu sipsipda daying yiwitäke kuwit. ");
INSERT INTO awx_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tewi nätä ku kälapda undä dayixäwik, sipsip mätexu dänggämnä kupilä äwä sipsip meme yangu dänggämnä tolokngä käyä yang dayike päke, ninale pewit. Puyä hipdu gäle u pahawitde bimä unin päpit. ");
INSERT INTO awx_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hiyäkände yatnä kakengu, mahande yupsäng katapiläk. Puyä pahakumde hängä u namiläxunin dayipiläkge apukengu, u namiläkätanu meme tolokngä wenä gwendu bä sipsip mätexu dänggämnä kwaxu gwendu kakengu, ‘Kukäle täkut,’ yang natäpso,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Iniwän Labandä “Täke. U yänggaläk using tahahim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Inike teyä, täpduxu inä unggwenunekän, Labandä meme wäwi tolokngä käyä, äwä meme mängälä tolokngä käyä, äwä sipsip mätexu dänggämnä kupilä yangu undä Jekopdä inäle päpikge yakutdeyä päke, wawakngätä daying yiwitningge yänikut. ");
INSERT INTO awx_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Tikengä unin päke, Jekowu une teke, kewu womdune kuxawä, täpduxu gwenalä gwendu apuxuwän, undan yiwikin. Tixawän sipsiwu notnä Labandäne peke kukinu, Jekopdä daying yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tixäwik Jekopdä pa gupnä kupilä däkätuyile kätaxu käluk matäke, gupnä matäwän amixawä, päpän enaxawä, gupnä käwutdu using pekut. Tiwän awäpän enakinu bäniyä kwak yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Tiwän pa uläpäläpä memetä yanggä tängokayingune apuke dayipningge yake, gehanune wäkngasim päkapu pekut, inale meme yanggä tängopningge apuxäwixu, wäwitä mängälä une yäwäxakin. ");
INSERT INTO awx_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ge meme mängälä, meme wäwitä pa uläpäläpäle inälängän yäwäxakinde, mätekngä pexakinu tolokngä käyä. ");
INSERT INTO awx_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Tiwän sipsip äwa meme yangu dayixäwik uhinggike, sipsiwu inätä peke, meme inätä petäke kukut. Tikengä meme dänggämnä kupilä äwä meme tolokngä käyä yangu uläkwäkge nomune sipsiwu pexawän, une tahakakin. Jekopdä meme sipsip yangu using pahanggäwän, meyä hikngä sakngälakakut. Tiwän kälawu inäle dayike pewän, inätä yiwä, Labande kälawu dayike, inätä pewän yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kälawu kitokngänä käyätä tahaxawä, Jekopdä pa uläpäläpä kälapde kayi tängän päkapu, gehanune wäkngasim pexawän, pa uläpäläpäle inälängän tahakakin. Ge engangä tolokngä käyä pexakin. ");
INSERT INTO awx_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tiwän kälawu kitokngänä wenätä tahaxawä, pa uläpäläpä ile kayi tängänu dowexakut. Ge engangä tolokngä wenä pexakin. Ge engangä kitokngänä wenä u pexakinu Labandäne, tiwän kälawu kitokngänä käyä Jekopdäne. ");
INSERT INTO awx_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jekowu using pahanggäwän, memenä sipsipnä yangu meyä tiwän, puyä äminä, kamelnä, äwä dongginä yangkäyä äwänggäwän, hängänämbamgän hikngä tikut. ");
INSERT INTO awx_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Labande wawakgä Jekopde using yakin. “Naninde hängäläpä undä hikngä Jekopdä päke pahawän, hängänämbamgän hikngä alik,” yang yäxawä, Jekowu natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Natäke Jekopdä kaxawänu Labanu tupä ilakngäkän pahakut usingu, dolahawän kakut. ");
INSERT INTO awx_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tiwänä Yawetä Jekowu using inikut. “Awomu teke enake, hipdu notdambamde nanggale kewune kuyo. Tiwän nä gäxät kuhim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tiwänä Jekopdä Reselkät Leaxälu sipsipnätä näkaying womune apät dayipikge natäke, wam täknga tewän kuwän, une apgumäläk. ");
INSERT INTO awx_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Une kuwät dayike, Jekopdä using yänikut. “Nansä tupä näle täke natäpgut deyä, äpmanu kawa, näle usingu donatäk. Tiwändeyä nanale Anätu näxät yiwixamäk. ");
INSERT INTO awx_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nansäle puyä pahake, kitokngäna mumba kuwä, gihä anandumäläk. ");
INSERT INTO awx_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tiwändeyä nansätä ‘Hängä usingusingu äpme gamit,’ yangu kem nanike, ayakulune hikngä donamikulu, täpduxu meyä. Tiwändeyä Anätutä dolewän tahawän malit. ");
INSERT INTO awx_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nansätä ‘Kälawu tolokngä käyä gäle gamit,’ yang naniwänu, mätekngä tolokngä käyäkän pekin. Tiwän ‘Kälawu guläkngä kwaxu gäle,’ yang naniwänu, mätekngä inä usäkän pekin. ");
INSERT INTO awx_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Using tahake, nansäle kälawu Anätutä päxäwik, nälekän namikut. ");
INSERT INTO awx_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Kälawu wäwitä mängälä yäwäxaying täpduxune peke, dambu täkngatu using kakum. Meme mängälä, wäwi tolokngä käyätäkän yäwakin. ");
INSERT INTO awx_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tixawän Anätule ängelatä dambu tängänekänu using yakut. ‘Jekop,’ yawän, ‘We!’ yäwa, using nanikut. ");
INSERT INTO awx_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","‘Dayixäyo. Meme mängälä, wäwi tolokngä käyä gwenggwendäkän yäwäxaying. Nätä using tahaningge tahat, inale wäyi täkngaläknga Labandä gäle u pahanggaxu andayit. ");
INSERT INTO awx_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nä Anätu, gäle Betel apgum täpänin. Uwomune huwu gwendu däm tängenake, olip yanggätä huwu unggwenu pingyapmike, näle gepbine yiwiläkge hiyäkän wam yakuläk. Ge kewu awomu teke, kewu alakuläk womune hipdu kuyo,’ yang nanikut,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yäniwän Reselkät Leaxätdä using inikumäläk. “Nanitdä hängä täpätu nitde hikngä niminangäsändo, ");
INSERT INTO awx_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","inale itä nindupänu, nilu malä nanä tinggaxunin. Nilu moningge pewän uhiwi, moningu u päkulu undä amumbän kukin. ");
INSERT INTO awx_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Hängä täpä undä nanitde kätaxune Anätutä päkulu, nit äwä engangit yangge hängä. Ge Anätutä dasingga ganikulu using tahayo,” yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Tiwän Jekowu tändäkngake, mängätnä engangä yangu päko kamel tängäne peke, ");
INSERT INTO awx_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","kälapnä äminsak, hängänä Mesopotemia päkut yangu undä yäning yäpiwän kuxawä, nanä Aisakge, Kenan kuningge kukin. ");
INSERT INTO awx_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labanu sipsip dänggäm matäwikge kuxawän, Labandä ‘anätuna’ yake ämindäkän kwätäluke yotnä pexakut täpäläpä, Reseldä kukäle päkut. ");
INSERT INTO awx_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jekopdä Laban Aram nanä uläpä axanghopike, “Using kukamäng” yangu doinixäwik, ");
INSERT INTO awx_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","hängä täpänä undä wepdäkän päke, Labanu teke, datäkuhika, ku Yanggä Yupretis Dupi yayike, Gileadkätanu täwalnä käyä womune kuningge kukin. ");
INSERT INTO awx_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Täpduxu gwenalä gwendu apuxuwän, “Jekowu using datäkukut,” yang iniwä natäke, ");
INSERT INTO awx_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Labandä notnämbam yapäpän, Jekowu täwäläke kukin. Kuxawä täpduxu 7 apuxuxawän, kungu Gileadkätanu täwalnä käyä uwomune kakin. ");
INSERT INTO awx_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tiwän kupiläne Labanu petnä peke, dambu tike kaxawän, Anätutä apu using inikut. “Yäko. ‘Jekowu tokngä wamu mainiyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jekopdä selyotnä Gileadkätanu täwalnä käyä uwomune täpikutnä kake, Labande notnämbamkäyä uwomunekän päkapu, selyotnä tapike yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Tiwän kwepdätä Labandä ku, Jekowu using inikut. “Amäk ämindä amäk tahake, iwalnä kalabusde päke kukaying usingu, yäpana inale nandunghopike päkapguläk? ");
INSERT INTO awx_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Wepdäkänu inale datängapguläk? Ananikuläk gämu, gita hikwak yang päke tayike kuläkake, galak wamu ganinayä apim. ");
INSERT INTO awx_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yäpana bapuna yangu kisu dolahangyämike, galak wamu doyänixäwa, päke apguläk. Wäyi täknga tahakuläk. ");
INSERT INTO awx_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nätä meyä täknga andaminangäsä. Tiwändeyä kupiläne nanggale Anätutä using nanik. “Yäko. Jekowu tokngä wamu mainiyo,” yang nanik. ");
INSERT INTO awx_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","‘Nanäle yolune kuwikge alahambänipdake kukut’, yangu anatät. Tike teyä anätuna kukäle inale päkapguläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Iniwän Jekopdä yäkwäle wamu using inikut. “‘Yäpanä inäle päyäk,’ yake naxälake, päke apgum. ");
INSERT INTO awx_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tike anätuka uläpäläpä imindäka päkutnä kakengu, uläpä axupik. Ge hängä gätäne näle hängä täpäxätan yiwixawä kakengu, notnitde kayine gikale päyo,” yang inikut. “Reseldä Labande anätu uläpäläpä awäkut,” yangu donatäxäwik yakut. ");
INSERT INTO awx_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tiwänä Labandä Jekopde selyot, Leale selyot, äwä mängälä puyä äminu uläpäyatde selyot yangune ko dengwäsike, yäwambän malikin. Tiwän Reselde selyolune kopgut. ");
INSERT INTO awx_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","35","Nanä Reselde selyolune doxoxawän, Reselu pilo kamel tängäne teke puku yiwixakulu, yotnäne täko tekutnä, anätu uläpäläpä ile kematkätan peke, ulängäne puku yiwikut. Ge nanätä ko yäwambänu, Reseldä nanä using inikut. “Bulämbam täpäna, tokngä manatängamiyo. Nä yekäp iwat titde, kayikane däm hikngä enatnangäsändo,” yang inike, ulängäne puku yiwixawän, yäwambän maliwä, teke epuxukut. ");
INSERT INTO awx_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tiwänä Jekowu tokngä natäke, Labanu using inikut. “Ngä nä mämä wamu dasä täknganin upukum? Ngä wäyi ina tahakumde näwäläkapguläk? ");
INSERT INTO awx_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Gätä näle hängäläpä undä hikngä dengwäsike dayiläk. Tikengu, gäle hängä täpätu undanu, ina bima kake täläk? Using kakengu, ane gäxät nanä äwä näxät nanä yangge bänäkän täkapu teng. Tiwän itä yanguhinggixut. ");
INSERT INTO awx_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Nä gäxälu krismasu 20 yiwikumäk. U yiwikumkätanu sipsiwu mängälä meyä dowäke, engangä täkekän pekin. Memexäyä usäkän. Tiwän gäle sipsiwu wäwi gwendu donäpa tikut. ");
INSERT INTO awx_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kälapda kälap tukgä sipginu, gäle dowäkapu tahawa dayipguläk. Tike ninane nanä päke ile tangge pekum. Tike kälapda kwakäpäne bä kupiläne päkindexäyä, usinggän yäxawi, tangäle gamikum. ");
INSERT INTO awx_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Using yiwikum. Kwakäpäne gusilu pälangä hikngä nahikakin. Tixawän kupiläne kwäman hikngä tixawä gäkäxäwik, petna dowekakum. ");
INSERT INTO awx_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Krismasu 20 gäxät yiwikumäxu using hikngä tahaxäwik yiwikum. Yäpaka päpitde, puyäka krismasu 14 pahanggamikum. Tikengä sipsip meme yang päpitde, krismasu 6 pahanggamikum. Tiwändeyä ‘Unin pahawi, usingusingu ämpe gamit,’ yang nanikuläxu, ayakuläxune donamikuläxu täpduxu meyä. ");
INSERT INTO awx_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Bapuna Abraham äwä nana Aisak yangge Anätu, Aisakgä änaxäläkakulu Anätu uläpä, näxälu doyiwixamäk gämu, gätä hängä täpätu donamixäwik, moyo anäwambi kuwam. Tiwändeyä tokngämbamu u päke, puyä kitokngä u pahakakumu, Anätutä andayipgut. Ge kupiläne ile tiwän, Anätutä ganinggämätak,” yang inikut, Jekopdän. ");
INSERT INTO awx_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tiwän Labandä Jekowu yäkwäle wamu using inikut. “Mängälä aläpäyalu, näle yäpa. Tiwän engangu aläkwäxu näle bapuna. Tiwän sipsip meme yangkäyä nätäne. Hängä andayixaläxu, undä nätänekän. Tiwändeyä yäpana, bapuna yangge, dasingga alahawa teyä, näxälu doyiwitnimnä tinggak. ");
INSERT INTO awx_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Using tiwänu kontrak tahahim. Ge mahande ile natäke, ‘Wamu kitokngä using yakumäk,’ yangu änatäpsim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tiwän Jekopdä huwu gwendu täke, däm täpän enakut. ");
INSERT INTO awx_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Tiwän, notnä hup päkapningge yänikut. Yäniwän huwu päkapu unekändäkä pekin. Peke une yiwike, naxu unekän nakin. ");
INSERT INTO awx_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Huwu unekändäkä u pekinu, Labandä umanä Jegar Sahaduta yang iniwän, Jekopdä Galet yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labandä “Huwu aläkwäxunin dayixäwik, ‘Labankät Jekopkätdä wamu kitokngä yakumäläkgäne’ yang natäpna kuwik,” yang yakut. Ile tiwän umanä Galet yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Umanä täkngatuxäyä Mispa yang inikin, inale Labandä using yakut. “Nilu nihänihä yiwisim tiwändeyä dasingga pahahimu, Yawetä äpme ninduxäwik. ");
INSERT INTO awx_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Gä yäpana päke päku, kätaxu dondaying yiwiläk, bä mängätda käluk täpämbä täpiläkge natäpiläk. Tike ‘Kepämindä donanduying,’ yang natäpiläk. Tiwändeyä Anätutä anindupik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Tikengä unetäkänu using inikut. “Dayipso. Huwu däm yiwixak gwen äwä huwu nit bänäkängän pelu aläkwäk yang dayipso. ");
INSERT INTO awx_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Huwu anggwen äwä huwu aläkwäk yangu, wamu kitokngä yäkamäk täkngale tuwängge yiwitning. Nätä huwu aläkwäxu doyapmike, ku tahawa maliwiläk. Tiwän gätäxäyä usinggän. Huwu aläkwäxu doyapmike, apu tahawi maliwit. ");
INSERT INTO awx_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahamde Anätu, Nahorde änätu, äwä ile nanäle anätu yanggäyä gäxat näxälu uhinggitning,” yang inikut. Tiwänä Jekowu wamu kitokngä Anätu nanä Aisakgä naxälakakulu uläpäle umande yakut. ");
INSERT INTO awx_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yake täwalu undäkäne kälap tänguke, käwutdu Anätule ofa tahake, käwutdu häke, notnämbamu yangyäwambän apä nakin. Tikengä täpduxu unggwenune däpmunä täwalu undäkäne pekin. ");
INSERT INTO awx_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Tiwän kwepdätä gwäsi hikngä enake, Labandä yäpanä bapunä yangu kis tahangyämike, galak wam yänikengä, äminu unuxät kukinu hipdu päpän, yotnäle kukin. ");
INSERT INTO awx_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Labanu yotnäle kuxawänu, Jekopkäyä äenake kukut. Kahit täpäne kuhikangu, Anätule ängela dayipgut. ");
INSERT INTO awx_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Dayike “Kewu awomu Anätule ämindä yotde äpmandähimdekän päkapu yiwixaying,” yang yake, kewu uwomu umanä Mahanaim yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Tikengä Jekopdä puyä äminä kantri Idomkätanu kewu Seir uwomune ku, payänä Iso yawä natäpikge yänikut. ");
INSERT INTO awx_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Using yänikut. “Bulämbam täpäna Iso wamu using ininong. ‘Puyä äminda Jekopdä using yak. Labankät yiwihika aapunggat. ");
INSERT INTO awx_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nä towiyä gämäna, donggina, sipsipna, memena äwä puyä ämina yangu käyä. Ge bulämbam täpäna, wamu aläknga gäle tewa apunggak, inale gätä bänip gwaläng natängamiläkge natät, yang ninik, tiwän apumäng,” yang ininong, Ison,” yang yänikut. Yänike yäning yäpiwän kukin. ");
INSERT INTO awx_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ku inike, Jekopde hipdu apgin. Apu using inikin. “Payäka Iso axu inikumäng. Tiwän änggandupikge, äminu 400 päpän ixät using apäyak.” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tiwän änaxälake, meyä hikngä päxäwikgän, äminu ixät kukin, sipsipnä, memenä, towiyä gämänä äwä kamelnä yang upuke, täkwäkgu inätä päku peke, täkwäkguxäyä inätä päku pekut, ");
INSERT INTO awx_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","inale using natäpgut. “Isotä apu yakap täkwäk sipänu, mahan yiwitning täkwäxu andatäkuwä, dosipik,” yang natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Tikengä tumuk wamu using yakut. “O Anätu bapuna Abraham äwä nana Aisak yanggäne, O Yawe, gätä using nanikuläk. ‘Kantrika alakuläk womune kuwi, nätä gatänggama, täkekän yiwiläk,’ yang nanikuläk. ");
INSERT INTO awx_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nä puyä äminda, tiwän umana wenä. Tiwändeyä gätä näle iwikge natäxäwik, gwälam hikngä tahanggaläxunin. Yanggä Jodan Dupi tupä yayike apgumkätanu, hängäna wenä; hiputnatäkän hanggike yayike apgum. Tiwändeyä äpmanu hangäna meyä hikngä tiwän, inäinä pet; täkwäkgu inätä peke, täkwäkgu inätä pet. ");
INSERT INTO awx_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ge gatängamiyo. Gatängamike, payäna Isole kätaxune maleyo. ‘Itä apu mängätna, enganga, äwä nina yangu undä nihipän kumnäm,’ yake naxäläkgat. ");
INSERT INTO awx_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wamu using nanikuläk. ‘Nätä äpme pahawa täkekän yiwiläk. Tikengä bapuka pahawa, meyä hikngä haluhalu bimä tiwä, kendetnangäsä doliwik,’ yang nanikuläk. Ge gatängamiyo, tiwän Isotä donihipik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Inike, kupilä uggwenune, une yiwikut. Une yiwixäwik, kälawu gwenduyi bänip gwalängge payänäle imikge tuwängukut. ");
INSERT INTO awx_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Using tuwängukut. Meme mängälä 200, meme wäwi 20, sipsiwu mängälä 200, sipsiwu wäwi 20, ");
INSERT INTO awx_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamelu engangä käyä 30xät engangäxät, towiyä gämänu mängälä 40, towiyä gämänu wäwi 10, donggi mängälä 20, äwä donggi wäwi 10 yang imikge tuwängukut. ");
INSERT INTO awx_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kälap tuwängukengu, inäinä upuke, puyä äminu täpätu täpätule kätaxune pekut. Peke puyä äminä using yänikut. “Gindä gämäk kunong. Axunanggengu, unekän hikngä maxunong. Täkwäkgutä gämäk kuwä, bänäkänu wangga äyiwiyok. Tiwänä täkwäkgu une. Tiwän une kuningkäyä, usinggän,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Tikengä puyä äminä yakäp kuwikge täpä using inikut. “Axuwi payäna Isotä ganduke, ‘Gä towikga imin? Kälawu imindäne yäwäxawi apukaying? Tiwän säne päke kunggaläk?’ yang bä ganiwän kayo. ");
INSERT INTO awx_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Tiwänu using iniyo. ‘Kälawu aläkwäxu puyä äminda Jekopdäne. Itä bulämbam täpänä Isole yake namän, bänip gwalängge gamikge päkapunggat. Tixäwixu inä Jekowu äpmäxälä apänak,’ yang iniyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tikengä puyä äminä kälawu yakap täpäle mehene päke kuwikge täpä, äwä uläpäle mehene päke kuwikge täpä, äwä une päke kuning ämin yangu usinggän yänikut. “Iso kakengu, ");
INSERT INTO awx_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","wamu undaninggat usinggän ininong. Tikengu using ininong. ‘Puyä äminda inä Jekopkäyä mahaninkätan apänak,’ yang ininong,” yang yänikut, Jekopdän, inale using natäpgut. “Hängä bänip gwalängge imitde pewa kuwä kakengu, bänip kwikwixu äpmembä natängamik. Ge nina kuwa nandukengu, äläkuläkawik,” yang natäke, ");
INSERT INTO awx_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","hängäläpä gämäk pewän päke kuxawä, kupilä unggwenu Jekowu yolu äpmandekän tahake yiwikut womune inäkän yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kupilä unggwenunekänu Jekopdä mängät täpäyatnä, mängälä puyä äminäle yiwixamäläxu uläpäyat, äwä wawakngä 11-u uläkwäk yang päpän, Yanggä Jabok Dupi ayayikaying womune yayike, käwutdu yänipäko pekut. ");
INSERT INTO awx_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Päko peke ako, hängä täpänäxäyä yawän, puyä äminä kukindä päke, atusikäwut päko pekin. ");
INSERT INTO awx_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tixawänu Jekowu käwutdu inäkän yiwikut. Tixawän äminu täpätutä apän, “Imindäka betake, kewune täpän pimapän?” yake usinggän pahaxawät, axwakawikge tikut. ");
INSERT INTO awx_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Using betäxäwik, äminu uläpätä kawänu, Jekowu yapmitnangäsä doliwän, yemiyiwilune tepän, golängä wakäwakälune dekut. ");
INSERT INTO awx_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tiwän äminu uläpätä Jekowu “Tewi kunggäwa. Axwakäwikge alinggak,” yang iniwändeyä, Jekopdä “Wam gwaläng gämäk namiyä, tewa kuwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tiwän äminu uläpätä “Ngä gä umanda imin?” yang iniwän, “Nä umana Jekop,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Iniwänu äminu uläpätä using inikut. “Gä umanda Jekop yangu dongganikaning. Tike umanda käluk täkgna Israel yang ganikaning, inale gä ämin äwä Anätu yangu amäke yapmiläk” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iniwän Jekopdä “Äwä gäle umanu täkembä naniwiläk?” yang iniwän, uläpätä “Umana ganiwitde inale hikngä yänggaläk?” yang inike, wam gwaläng imikut. ");
INSERT INTO awx_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Tiwän Jekopdä “Anätule nomu axake teyä doxungwät,” yake, kewu uwomu umanä Peniel yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Gusitdä akoxawänu, golängä andekutde, Peniel teke kukulu, amandotäke kukut. ");
INSERT INTO awx_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Jekopde yemiyiwilune tepän, golängä wakäwakälune dekutde, Israel nanä äpmandehimkäyä, kälap hakengu, hikngwämu goläng wakäwakälune nanä donäkayingunin. ");
INSERT INTO awx_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jekowu Peniel teke kuhika, kwayiwän enawänu, Iso äminä 400 päpän apunggäwä dayipgut. Dayike engangä upuke pekut. Leale engangu inä Leaxät peke, Reselde engangu inä Reselkät peke, puyä äminä uläpäyatde engangkäyä usinggän pahakut. ");
INSERT INTO awx_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Puyä äminä uläpäyatkät engangäxät gämäk pewän yiwä, ile mehene Leaxät engangäxät pewän yiwä, wäsekngä Reselkät wawakngä Josepkät pekut. ");
INSERT INTO awx_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tikengä inä Jekopdä gämäk täku Isole kayine kuhilä kep däkäxätan täpu temgut. Tikengä usinggän pahanggäwän, 7 tikut. ");
INSERT INTO awx_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tixawän Isotä ihapmäke, apu Jekowu betake, kis tahangämike, kwänämnä initiwän, kwänämnä une tikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tiwäl matäwän, Isotä hilakengu, mängälä engangä yang yiwikinä dayike, Isotä “Äminu aläkwäk yiwiyingu imindäne?” yang inikut. Iniwän Jekopdä “Näle engang aläkwäxun, Anätutä puyä ämindale näle bänip gwaläng natäke namikulunin,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tiwän puyä äminä uläpäyatkät engangäxätdä Isotä yiwikulune hikngä päku sopäsopä puke, kuhilä kep däkäxätan täpu yamgin. ");
INSERT INTO awx_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Tiwän ile mehene Lea engangä yanggä päku, sopäsopä puke, kuhilä kep däkäxätan täpu yamgin. Tiwän wäsekngä Josepkät mingä Reselkätdä päku, usinggän pahakumäläk. ");
INSERT INTO awx_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Tiwänä Isotä Jekowu using inikut. “Kälawu uläkwäxu dasingge päkapuläkngä dayit?” yang iniwän, Jekodpä using inikut. “Bulämbam täpäna, gätä ilakngä hikngä nandupiläkge, gäle tiwän päkaput,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tiwändeyä Isotä “Notna, nä usä käyä. Ge u gikale,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Iniwändeyä Jekopdä yäkwäle wamu using inikut. “Bulämbam täpäna, usingu mayäyo. Gätä ilakngä nanduläkngä kakengu, hängäläpä bänip gwalängge gamilu äwayo. Nätä nomda gandulu, Anätule nomune bima kat, inale gätä näle bänip kwikwik natäläk. ");
INSERT INTO awx_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Anätutä bänip gwaläng natängamike namikut. Tiwän nä hängänambamgän hikngä tikut. Ge hängäläpä bänip gwalängge päkapulu awäyo,” yake kitokänggawän, Isotä “Hii, täke,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Unetäkänu using inikut. “Nä ginkät kunim,” yang iniwändeyä, ");
INSERT INTO awx_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jekopdä using inikut. “Bulämbam täpäna, enganga kälapna yangu andayiläk. Enganga yupsängu kitokake kunangäsändo. Tiwän sipsip towiyä gämän yangkäyä usäkän. Engangä mämnä näkayingu yupsängu kunangäsändo. Äyäwämba ihapmäke, täpduxu gwendunekänu malä hikngä kuhikangu, kälawu undä axumning. ");
INSERT INTO awx_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ge bulämbam täpäna, gätä gämäk kunggayo. Tixawänä puyä äminda kälapkät engangkätdä wepdä älukukaying using kuxawä, apuhikangä, bulämbam täpänale, Seir uwomune apundopnim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tiwänä Isotä using inikut. “Gäxät apningge äminu näxät apumängu täpätuyi yäniwa yiwixakut,” yang iniwändeyä, Jekopdä “Usingu inale tahawiläk? Gätä nä ilakngä nandupiläkgekän natät,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tiwänä täpduxu inä unggwenunekän, Iso hipdu täpän täkwämbän, Seirle kukut. ");
INSERT INTO awx_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tiwändeyä Jekowu Iso doläwaläke kukut. Tike Sukot kukut. Täku yotnä tahake, kälapnäle gepmä pahakut. Ile tiwän kewu uwomu umanä Sukot yang inikaying. ");
INSERT INTO awx_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jekopdä Mesopotemia teke apgulu, meyä dowäxäwik apuhika, kewu Kenan uwomune taunu Sekem apundopgut. Täkapu selyotnä taunde wäkngäsim tapikut. ");
INSERT INTO awx_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tikengä kewu selyotnä tapikulu uwomde, moningu 100 silwa, Sekemde nanä Hamor yänggwätde yämikut. ");
INSERT INTO awx_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kewu uwomune alta Anätule tahake, umanä El-Elohe-Israel yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Gwendune Jekopkät Leaxätde yäpa Daina mängälä kewu uwomune nanä dayipikge kukut. ");
INSERT INTO awx_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamoru, Hiwi nanä uläpä kewu uwomune nanäle kuhiläle yiwixakut. Ile wawaxu Sekem. Uläpätä Daina kambutake, tänggänggänuke tahawän malikut. ");
INSERT INTO awx_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tiwän Dainale natänggämätake, wamu ilakngäkän inikut. ");
INSERT INTO awx_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tikengä Sekemdä nanä Hamoru using inikut. “Mängälä aläpä näle yängamiyo. Tiwän mängätnale täpit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jekopde wawaxu kälawu äminsak daying yiwitningge songäne päku yiwikin. Tixawän Jekowu “Sekemdä yäpaka Daina tahawän malikut,” yawä natäpgut. Tikengu wamu täkngatu doyakut. Tike wawakngäle yiwixakut. ");
INSERT INTO awx_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tixawän Hamor äwä wawakngä Sekem yangu Jekopkät wam yäningge, taun teke, Jekopde kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","“Hängä womdu using tahakin,” yangu yawä natäkengä, Jekopde wawaxu kewu uwom kukinu teke, hipdu yolune apgin. Sekemdä Daina tänggänggänuke tahawän malikulu, Israel yänggwätde kayine gutongä hikngä. Hängä dolahanangäsa täknga tahakut. Ge haminätä haminäle butayä natäke, Sekemde tokngä hikngä natäxäwik apgin. ");
INSERT INTO awx_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ge yolune apä, Hamordä Jekowu using inikut. “Wawaknga Sekemu yäpakale hikngä natäxak. Täkembä mängätnäle imining? ");
INSERT INTO awx_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tiwän mängälä ninkätan nanä damixätna, yäkwäle nimining? ");
INSERT INTO awx_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Tiwän ninkät gatäke using yiwitnim. Kewu sawomuneka yiwitningge natäkengu, gihä kake, kewu uwomune yiwitnong. Tixäwik kewu awomkätanu täkekän tihikuning. Tixäwik kewu nindäne womduyi täke päning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Tiwänä Sekemdä Dainale nanä äwä häminä yangu using yänikut. “Gindä wamu u yäwilu ‘Täke’ yaningä kakengu, inaleka naniningu äpme damit. ");
INSERT INTO awx_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mängälä uläpäle moningu dasingdasingga damitde natäkengu, täke tuwängutning. Hängä gwälamu dasäka damitde natakengu, täke yäning, tiwänu äpme damit. Inale mängälä uläpä ahikngä naminingge natäxat,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Haminä tahawän malikutde natäke, Jekopde wawakgä Sekemkät nanä Hamorkälu yäkwäle wamu kem yäniningge natäke, using yakin. ");
INSERT INTO awx_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Usingu dolahanim. Hamininu gupnä domatäkin äminde yäminangäsändo. Using tahakengu, mäyäkngä hikngä natäpnimunin. ");
INSERT INTO awx_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tike hängä täkngatukän alahangäsän. Nindä gupnin matäkumäng usinggän, ginkäyä wäwi undä gupsä matänong. Tiwänä ‘Täke,’ yangu daninim. ");
INSERT INTO awx_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tikengä mängälä mätexu damixätna, yäkwälexäyä nimining. Tiwän ninkät ginkälu u äminuninggän däkngake yiwitnim. ");
INSERT INTO awx_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tike gupsä matäningge ‘Täke’ yangu doyawä, hamininu äläke kunim,” yang yänikin. ");
INSERT INTO awx_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tiwän Hamorkät Sekemkätdä natäpälu, wamu uläknga täke tikut. ");
INSERT INTO awx_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tiwän wäwi mätexu uläpä Jekopde yäpale hikngä natäpgutde, wamu yänikin using yupsäng pahakut. Äminu taunune nanätä kawä, äminu Hamorde yolune yiwixayingkätanu, Sekemu bulämbam täpä tikakut. ");
INSERT INTO awx_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ge Hamorkät wawakngä Sekemkät taun yiwixaying notnä wam yänihimäläkge, taunde yämä däkäne kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ku using yänikumäläk. “Äminu uläkwäxu notnin däkngäningge tahakaying. Kewu awomu inulung. Ge täke pena, ane tihikuxäwik yiwitning. Tixawän mängälä itäne nanä päxätna, yäkwäle nindäne päning. ");
INSERT INTO awx_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tiwändeyä using niniying. ‘Nindä gupnin matäkumäng usinggän, ginkäyä wäwi undä gupsä matänong. Using tahawäyä, ninkät ginkälu u äminuninggän däkngake yiwitnim,’ yang niniying. ");
INSERT INTO awx_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ge using tahakengä, ile kälap äwä hängäläpä itäne yangu, ninkäyä towikngä däknganim. Ge ‘Täke’ yangu yänina. Tiwän ixät ninkät yiwitnim,” yang yänikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yawät äminu undä yämä däkäne yiwikinu ‘Täke’ yake, wäwi taunune nanä undä gupnä matäkin. ");
INSERT INTO awx_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Täpduxu 3 gwendä apän, wäwi undä tokngä däkä päke, ‘Ämindä ämbänihipning?’ yangu donatäke yiwixawä, Jekopde wawaxu, haminä Dainale natäke, Simeonkät, Livaixätdä sänggwanä päke, taunune ko, wäwi undä sipät kumgin. ");
INSERT INTO awx_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor, wawakngä Sekem yangkäyä sänggwatä matäwät kungäxawät, ko Daina Sekemde yolunetä täke, epuxukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Tiwänä Jekopde wawakgä using natäpgin. “Sekemdä hamininde gutongä täknga taunu anggäpangune tahakut,” yake, ko äminu axumginä dayike, taunune nanäle hängälapä undä päkin. ");
INSERT INTO awx_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sipsipnä, memenä, towiyä gämänä, dongginä äwä hängä undä taunune yiwikin, äwä songäne yiwikin yang päkin. ");
INSERT INTO awx_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Tixäwik hängä nomän täpäläpä, mängälä, engang, äwä hängä yotkätan yiwikinunin yangu undä päkin. ");
INSERT INTO awx_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tiwänä Jekopdä wawakngä Simeonkät Livaixälu using yänikut. “Gitdä meyä täknga namikamäläk. Peres nanä, Kenan nanä yangu kewu awomune yiwixayinggä nandupä, nä wäyi ämin tinanggenggak. Ninu äminu meyändo. Undätä anihipningge yanggatäke apungu, ninu undä nihipä kumnimunin,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tiwän yäkwäle using inikumäläk. “Haminilu Sekemdä kukäle täke tihikukulu täke?” yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Anätutä Jekowu using inikut. “Gä payäka Iso teke datäkuxawi, nä Anätu Betel apuke gandupgum. Ge awomu teke, une päko yiwixäwik, alta gwendu näle tahayo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tiwänä Jekopdä inäxät nana äwä ixät yiwixaying yangu undä using yänikut. “Hängä womdune nanätä ‘anätunin’ yake, ämindäkän kwätälukinä päkinu uläpäläpä amumbä kunong. Tiwän gutongä täkngaläknga teke, käluk däkngake, u tahaningge tuwängge, täwiksä käluk pahanong. ");
INSERT INTO awx_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tiwänä Betel kopnim. Ko alta Anätule tahawit. Sänesäneka tihikukumune, meyä päkum gwenggwenune yangu Anätu näxät tihikuxäwik, gatängamikut,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ge hängä womdune nanätä “anätunin” yake ämindäkän kwätälukinä päkinu uläpäläpä äwä mäläkäpä mäläkngäne pekin yangu undä, Jekopde imikin. Imä, Jekopdä pa kupäha bimä Sekemde wäkngäsim yiwixaxu undäkäle kematde kwayipekut. ");
INSERT INTO awx_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tikengä kewu uwomu teke kukin. Kuxawä Anätutä pahawän, äminbamu yotyolu uwomune nanä naxäla hikngä natäke, doxu yäwakin. ");
INSERT INTO awx_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Tixawän Jekop äwä äminu undä ixät kukin yangu kuhika, taunu Lus kondopgin. Lus taunu unggäpangu Kenankätan yiwikut. Äpmanu unggäpangu Betel yang inikaying. ");
INSERT INTO awx_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Lus taun kondoke, Jekopdä alta gwenu tahake, kewu uwomu umanä El-Betel, yang inikut, inale payänä teke datäkuxawänu, Anätu uwomune apän kakut. ");
INSERT INTO awx_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tiwänä Jekopde mingä Rebekale puyä äminu Debora une kupän, pa kupäha bimä Betelde amusikäwut yiwixak däkäne kwayikin. Kwayike pa undäkä umanä “Alon-Bakut” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jekowu Mesopotemia teke apänä, Anätutä hipdu apu, wam gwalängu using imikut. ");
INSERT INTO awx_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“Gä umanda Jekop. Tiwändeyä äpmanu Jekop yangu dongganikaning. Tike Israel yang ganikaning,” yang inikut. Using yake, umanä Israel yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Tikengä unetäkänu using inikut. “Nä Anätu Kitokngäna Käyä Täpä. Nätä äpme tahawa, gäle bapuka meyä sakngälake, kantri inäinä päke yiwitning. Tixäwik bapuka täpätuyi kingge yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tixawän kewu Abrahamkät Aisakätde yämitde yänikumu, gäle äpme gamit. Tikengä bapukalexäyä uwomuningänu äpme yämit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Inike, Jekowu wam inikulu uwomune yiwixawän, teke kukut. ");
INSERT INTO awx_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Tiwän kewu Anätutä wam inikulu uwomune, Jekopdä huwu belakngä gwendu täke, mahande kaxäwik natäpningge, däm täpän enakut. Täpän enawän, huwu unggwenu ofale wain yanggätä pingyapmike, olip yanggätäxäyä hipdu pingyapmikut. ");
INSERT INTO awx_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kewu Anätutä wam inikulu uwomu, Jekopdä umanä Betel yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Tiwänä Betel teke kuhika, taunu Eprat kuningge kukin. Kuxäwik Reselu engang kake täpikge tahawän malixawän, tokngä däkä päkut. ");
INSERT INTO awx_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tinggawän mängälä anggatängämikge yiwixak täpätä using inikut. “Manaxälayo. Wawakga täpätu dukngikgaläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tiwän Reselu axupikge tixäwik, mepme wäsekngä pexäwik, umanä Benoni yang inikut. Tiwändeyä nanätä umanä Bensamin yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Reselu axupän, Epratde kahit kwayimune kwayikin. (Eprat yangu Betlehemde umanu tupä nanä täknganin.) ");
INSERT INTO awx_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tiwän Reselde mätmälune, Jekopdä huwu gwendu däm täpän enakut. Huwu unggwenu Reselde mätmatde tuwängge äpmankäyä ayiwixak. ");
INSERT INTO awx_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israelu hipdu kuhika, Migdal-Eder ku yapmike täku, selyotnä tapike, une yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Kewu uwomune yiwihika, Rubendä nanäle puyä äminu mängälä Bilha uläpäxät kopän yiwikumäläk. Tiwänä Israelu yawä natäpgut. Jekopde wawaxu unekänu 12. ");
INSERT INTO awx_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leale wawaxu Ruben, Simeon, Livai, Juda, Isakar, äwä Sebulun yang. Jekopde wawaxu yakap täpä Ruben. ");
INSERT INTO awx_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Tiwän Reselde wawaxu Josepkät Bensaminkät. ");
INSERT INTO awx_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Tiwän Bilha, Reselde puyä äminde yiwikut täpäle wawaxu Dankät Naptalixät. ");
INSERT INTO awx_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Tiwän Silpa, Leale puyä äminde yiwikut täpäle wawaxu Gatkät Aserkät. Wawaxu aläkwäxu undä, Jekopdäne, Jekowu Mesopotemia yiwixäwik towikulunin. ");
INSERT INTO awx_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jekowu nanä Aisakge Mamre kukut, Abrahamkät Aisakät tupä yiwikumäläk womune. Mamre Kiriat Arba taunde wäkngäsim. (Kiriat Arba yangu taunu Hebronde umanu tupä nanä täknganin.) ");
INSERT INTO awx_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisaxu krismasnä 180 yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Äminäläke hikngä tikengä kungäke, bapunä tupä kungäke päku yiwixakinunekän kukut. Tiwän wawakngä Isoxät Jekopkätdä kwayikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Wamu aläknga Isole bapunätäne. Isole umanu täkngatu Idom. ");
INSERT INTO awx_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso mängätnä Kenan nanä päkut. Täpätu umanä Ada, Hit nanä Elonde yäpa. Tiwän täpätu umanä Oholibama, Anale yäpa tiwän Hiwi nanä Sibeonde bapunä. ");
INSERT INTO awx_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Tikengä Basemat, Ismaelde yäpa, tiwän Nebaiotde haminu mahandeyä täkut. ");
INSERT INTO awx_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adale wawaxu Elipas. Tiwän Basematde wawaxu Ruel. ");
INSERT INTO awx_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Tiwänä Oholibamale wawaxu Jeus, Jalam, äwä Kora yang. Wawakngä uläkwäxu, Isotä Kenan yiwixäwik towikulunin. ");
INSERT INTO awx_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isotä mängätnä, wawakngä, yäpanä, äwä ixät yiwixaying ämin, kälapnä äminsak, äwä hängäläpä Kenan kep womune yiwixäwik päkulunin yangu undä päke, notnä Jekowu teke, kewu malä womdune päku yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Isoxät Jekopkätde kälawu äminsaxu meyä hikngä tinggäwä, kewu itä yiwikumäläxu uwomu, songäsongä kälawu undätänetä nänangäsä dolikut. Tiwän kewu uwomunekänu yiwitnangäsä dolikut. ");
INSERT INTO awx_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tinggäwän Iso bä Idomu hängänä undä päke, Seirkätanu täwalnä käyä womune päku yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Wamu aläknga Isole bapunä kewu Seirkätanu täwalnä käyä uwomune alakin täkwäkgäne. Äminu uläkwäxu äpmanu Idom nanä yang yänikaying. ");
INSERT INTO awx_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Isole mängälu Adatä wawakngä Elipas dukngikut. Tiwänä Elifasde wawaxu Teman, Omar, Sepo, Gatam äwä Kenas yang. Elipasdä mängätnä täpätuxäyä hipdu täkut. Umanä Timna. Tiwän itä Amalek dukngikut. Isole mängälu Basematdä wawakngä Ruel dukngikut. Tiwänä Ruelde wawaxu Nahat, Sera, Sama äwä Misa yang. ");
INSERT INTO awx_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isole mängälu Oholibama, Anale yäpa, tiwän Sibeonde bapunä uläpätä wawakngä dukngikulu Jeus, Jalam, äwä Kora yang. ");
INSERT INTO awx_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Isole bapunä täpätuyi yakap äminde Idom yiwikinde wam. Elipasu Isole wawaxu yakap täpänin. Wawaxu itä towimbän, yakap äminde yiwikinu umanä Teman, Omar, Sepo, Kenas, Kora, Gatam, äwä Amalek, yang. Äminu aläkwäxu Isole mängälu Adale ayinä. ");
INSERT INTO awx_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isole wawaxu täpätu Ruel. Ile wawaxu yakap äminde Idom yiwikinu umanä Nahat, Sera, Sama, äwä Misa yang. Äminu aläkwäxu Isole mängälu Basematde ayinä. ");
INSERT INTO awx_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Isole mängälu Oholibamale wawaxu yakap äminde yiwikinu umanä Jeus, Jalam, äwä Kora yang. Oholibama Anale yäpa. ");
INSERT INTO awx_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Äminu aläkwäxu, Iso bä Idomde bapunä inäinäne yakap äminde yiwikin äminunin. ");
INSERT INTO awx_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Äminu kewu uwomune yakap yiwikinu, Seir Hor nanä uläpäle bapunä. Seirde wawaxu Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO awx_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser, äwä Disan yang. Seirde wawaxu uläkwäxu Idomkätanu inä bapunäle yakap äminde yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotande wawaxu Horixät Hemamkät. (Lotande haminu Timna.) ");
INSERT INTO awx_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalde wawaxu Alwan, Mahanat, Ebal, Sepo, äwä Onan yang. ");
INSERT INTO awx_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeonde wawaxu Aixät Anaxat. Ana uläpätä nanäle donggi songäsongä näningge päke kuke, yanggä tokngä akokayingu däkätu kakut. ");
INSERT INTO awx_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anale wawaxu Dison, tiwän yäpanä Oholibama. ");
INSERT INTO awx_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disonde wawaxu Hemdan, Esban, Itran, äwä Keran yang. ");
INSERT INTO awx_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eserde wawaxu Bilhan, Sawan, äwä Akan yang. ");
INSERT INTO awx_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disande wawaxu Uskät Arankät. ");
INSERT INTO awx_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ge Hor nanä uläpäle wawaxu Seirkätanu bapunä inäinäne yakap äminde yiwikinu, Lotan, Sobal, Sibeon, Ana, Dison, Eser, äwä Disan yang. ");
INSERT INTO awx_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel nanä kingge doyiwikin gwenggwenkätanu, Idom nanäle kingge yiwikinu umanä using. ");
INSERT INTO awx_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela Beorde wawakgä Idomde kingge yiwikut. Taunäle umanu Dinhaba. ");
INSERT INTO awx_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Yiwihika Belatä kungäxawänu, kingge Jobap Serale wawakgä yiwikut. Sera taunu Bosra nanä. ");
INSERT INTO awx_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobapdä kungäxawänu, kingge Husamu Teman nanä uläpätä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ge Husamdä kungäxawänu, kingge Hadat Bedatde wawakgä yiwikut. Hadalu Midian nanä Moap ku sipgut täpänin. Taunäle umanu Awit. ");
INSERT INTO awx_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ge Hadatdä kungäxawänu, kingge Samla, Masareka nanä uläpätä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ge Samlatä kungäxawänu, kingge Saul, taunu Rehobot nanä uläpätä yiwikut. Taun Rehobolu yanggä dupine inälängän. ");
INSERT INTO awx_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ge Sauldä kungäxawänu, kingge Balhanan, Akborde wawakgä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Balhananu, Akborde wawakgä kungäxawänu, kingge Hadardä däkngake taunu Pau yiwikut. Hadarde mängälu umanä Mehetabel. Mehetabelu Matretde yäpa. Matrelu Mesahapde yäpa. ");
INSERT INTO awx_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Isole bapunä sakngälake, kewu Idomkätanu inäinä päke yiwikin. Bapunä inäinä yakap äminde yiwikinu umanä using: Timna, Alwa, Jetet, Oholibama, Ela, Pinon, Kenas, Teman, Mapsa, Makdiel äwä Iram yang. Äpmanu äminu Idom nanä yang yänikayingu, Isole bapunä. ");
INSERT INTO awx_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jekowu kewu nanätä yiwikulune Kenan yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jekopde wawakge wam. Josewu krismasnä 17 using tixawän, Josepkät notnä täkwäkguxät nanäle sipsip daying yiwikin. Notnä uläkwäxu nanäle mängälu Bilha, Silpa yangge wawak. Tixäwik notnätä gutongä dasingga pahawä dayipgulu, nanä apu inikut. ");
INSERT INTO awx_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israelu äminälake alikengä, Josewu une towikutde, ile bänip gwaläng hikngä natäxäwik, täwixu gwälam hikngä kwämbätdu tahake imikut. Tike notnäle using hikngä donatäpgut. ");
INSERT INTO awx_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nanätä Josepdekän bänip gwaläng hikngä natäpän kake, notnätä Josewu mähemähe kaxäwik, wamu kätaxu doinikakin. ");
INSERT INTO awx_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Gwendune Josepdä dambu täkngatu tike enake, notnä yäniwän natäke, mähemähe hikngä une kakin. ");
INSERT INTO awx_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“Dambu täkngatu using tit,” yake using yänikut. ");
INSERT INTO awx_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Ninu undä puyä tängätune wit matäke wamähikanayä, nätä wamät tupä däm enake yiwän, gindä wamäyinggä apu, nätäne tupä yiwitäpä gwahawän, sopäsopä puke, däme kepkätan päpu yamäying,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tiwänä payänätä inikin. “Gä ninde yakapde yiwike, nindung yiwiläk?” yake, dambu ulike yänikutde, mähemähe hikngä kakin. ");
INSERT INTO awx_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Josewu dambu täkngatuxäyä hipdu tike, payänä using yänikut. “Äpmanu dambu täkngatu kaxäwa, gusit, yekäp äwä kuminamu täkwäkgu 11 yanggä näle sopäsopä puke, däme kepkätan päpu yamäying,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tiwänä nanätä natäke, “Ina dambu tiläk?” yake ininggämätake, “Mingga, nä äwä notda yanggä gäle apuke, sopäsopä puke, dämäninu kepkätan päpu yamnim?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tiwän payänä täkwäxu tokngä natäpgin. Tiwändeyä nanä dambu uläknga iwikge natäng yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Josepde payänä taunu Sekem uwomde wäkngäsim päku yiwixäwik, nanäle sipsip daying yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Tixawän Israeldä Josewu using inikut. “Payäka sipsiwu Sekem daying yiwayak. Ge une kuyo,” yawän, Josepdä “Hii, äpme kuwit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tiwän nanätä “Kuke dayipso. Payäka äwä sipsip yangu nomängänbä yiwayak. Tikengä apu naniwiläk,” yake ining yäpiwän, Hebron Kupi teke Sekem kukut. ");
INSERT INTO awx_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Une ku payänä yäwahikunggawän, äminu täpätutä kake, “Gä ina yäwäxaläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iniwän Josepdä “Nä payäna sipsiwu, säneka daying yiwayak yake yäwaxat. Ge gätä andayiläkngä kakengu, täkembä naniwiläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Iniwän “Dotande kuningge yawäxakumnä, ane yiwikinu aleke, une kukin,” yang inikut. Iniwän Josewu payänä yäwatäke ku, taunu Dotan uwomde wäkngäsim kuke dayipgut. ");
INSERT INTO awx_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Payänätä yiwikinune doxundoxawän, malä kuwän kake, kupsäle tängutningge wepdä wamu using yakin. ");
INSERT INTO awx_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Dambukän tinggaxu ane täpä aapunggak. ");
INSERT INTO awx_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ge tänguke, gäpma hopä yanggätä yiwikge kwayikinu däkätune mutna pukuwik. Tiwän ‘Kälaptukgä tänguke nakin,’ yang ku yänim. Tiwänä dambunä tikulu bulä ämbä alawä känim?” yang yakin. ");
INSERT INTO awx_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Unin yawä, payänä Rubendä anggatängämikge natäke, “U! Kupsäle hikngä dolängutnim,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Unetäkänu using yänikut. “Dolängutna kupik. Dolänguke tokngä däkäxäyä doiminim. Tike gäpma kewu moyo womune yiwäxayingu andäkaxätan mutna pukuwik. Tiwän tokngä däkäxäyä doiminim,” yang yänikut. U yänikulu Josep gatängämike, nanäle täke kuwikge natäke yänikut. ");
INSERT INTO awx_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ge Josewu inälängän apänu, alänggänggänuke, täwikngä gwälam hikngä uxwämbät tahakulu äläpä dopgut. ");
INSERT INTO awx_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Tiwän täke täku gäpma undäkäxätan mumbä pukukut. Gäpma undäkä yanggänä wenä. ");
INSERT INTO awx_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tikengä päku nakngä nake kaxawä, Ismael nanä äminu täkwäkgu Giliatkätandä apgin. Pa inuxu käpängänä käyä kamelu meyä gwenalune Isip päke kuningge päkapgin. ");
INSERT INTO awx_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tiwän Judatä notnä täkwäxu using yänikut. “Ina gwaläng pänimde uläpninu tängut täkohopinim? ");
INSERT INTO awx_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Undanä. Ismaelde bapunäle yäna, moning nimixäwik täxut, inale ulapninu uläpä daknotnin, tiwän nan notnin. Ge dolängutnim,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tixawänu Midian nanä une hikngä apä dayike, Josewu gäpmanetä tuliwä akopgut. Tiwän 20 sekel silwale yawä, Ismaelde bapunätä uhike, Isipde täke kukin. ");
INSERT INTO awx_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Täke kuxawäyä, Rubenu gäpma däkäne apu, Josewu wenä kake, butayä hikngä natäke, inä täwik wehikut. ");
INSERT INTO awx_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Tikengä apu notnä using yänikut. “Josewu wenä xat. Ngä nanu dasing täknganin ku iniwit?” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Yawän meme gwendu guläkngä matäwä, daxu apä, Josepde täwixu daxune täpä mahakut. ");
INSERT INTO awx_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Tikengä täwixu täpä mahakulu uxwämbälu nanäle täku imike, using inikin. “Täwixu axwämbät kake tämängu kätak kayo. Wawakgatänembä?” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iniwä täwixu uxwämbälunin kake “O, wawakngale täwik tinggak. Kälaptukgä alänguke yahandeke nakin,” yakut. ");
INSERT INTO awx_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yake Jekowu inä täwik wehike, täwixu butayä täkngatäne pahake, wawakngäle butayä natäxäwik, gwayamu belakngä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Tinggawän wawak yäpanä undä apu “Wamwambä inina, butayä täknga natäxu bulämdawik,” yake, wamwam inikin. Tiwändeyä “Dombulämdawit. Tike butayä natähika, ninaxäyä kungäke, axumgin amindä yiwäxayingune wawakngale kuwit,” yaxäwik, Jekowu wawakngäle kwänämu iwikge tikut. ");
INSERT INTO awx_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Tixawänu Midian nanätä Josewu Isip täke kukin. Täke kuwä, Potipatä uhikut. Potipa kingge kulä tahakaying äminde kuhiläle yiwäxakut. ");
INSERT INTO awx_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Täpduxu uwomkätanu Juda notnä peke, Adulam pukuwän, une nanä wäwi täpätu umanä Hira, ixät yiwikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Une yiwihika, Kenan mängälu täpätu kake täkut. Mängälä uläpäle nanä umanä Sua. Juda mängätnäxät yiwät, ");
INSERT INTO awx_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","tängene käyä tikut. Tiwän wäwi täpä dukngikut. Dukngiwän umanä Er yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Tiwän hipdu tängene käyä tiwän, wäwi täpä dukngike, umanä Onan yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tikengä wäwi täpätuxäyä Kesip yiwixäwik, dukngike, umanä Sela yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judatä wawakngä yakap täpä inulung tiwän, mängälä täpätu yangämikut. Mängälä uläpäle umanu Tema. ");
INSERT INTO awx_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tiwändeyä Judale wawaxu yakap täpä Yawele kayine gutongä hikngä pahakut. Pahawän Yawetä kupsäle tängukut. ");
INSERT INTO awx_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tiwänä Judatä wawakngä mahan täpä Onanu using inikut. “Payäkale natäke, kombätda pahangäming. Tiwän wawaxu yakap täpä payäkale nomde dukngiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Using iniwändeyä, Onanu “Engangu towimbilu ninanendo,” yang natäpgut. “Ge payänale kombätkät yiwixäwixu, engang aläyäk,” yake, yanggänä kewune moyo pexawän kukin. ");
INSERT INTO awx_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Unin pahawän, Yawetä kawän, gutongä hikngä tikut. Tiwän ixäyä kupsäle tängukut. ");
INSERT INTO awx_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tiwänä Judatä “Wawaknga Selaxäyä Tema täke kumsäk,” yang natäke, ayinä Tema kemu using inikut. “Ayina, nangga minggale yolune päku yiwixayo. Tikengu wäwi käluxu täpätuyi mawäyo. Tixawän wawaknga Sela inulung täpä tikengä täpik” yang iniwän, Tema nanä mingäle kuwän yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Belakngä womdu yiwihikangä, Judale mängälu Suale yäpa axumgut. Kupän Juda mängätnäle gwäyäm yiwikdäkngake, notnä Hira Adulam nanä uläpäxät Timna kopgumäläk. Timnä uwomune Judale puyä äminu sipsip dänggäm matäxawä kopgumäläk ");
INSERT INTO awx_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tixawänu Tema using inikin. “Bapuka sipsipnäle dänggäm matäwikge Timna kopänak,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tiwän natäke, kombätde täwixu pahanggaxu päpeke, täwixu kwämbätduhimdä kuhiläne wapän, nomnä epu umukut. Tikengä taunu Enaimde yämä däkäne kahilu Timnale kokaying täpäne täku puku yiwikut. Tema using natäpgut. “Sela inulung täpä alik. Nä itä täpän, engangu dukngitnangäsä. Tiwändeyä näle wamu doyak,” yang natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tixawän Judatä apu, nomnä umukulunin kake, “Mängälä aläpä yumdekän täke tihikukayingunimbä?” yang natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tikengä “Bapunambä?” yangu donatäxäwik, Tematä yiwikulune kuke, “Täkembä yiwisim?” yang inikut. Iniwän “Uyiwikengu, ina namiläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Tiwän Judatä “Meme mäteknga gwendu äpme gamit,” yang inikut. Iniwän Tematä “Hängäka täpätu äpmasimdekän äpme nami tengyiwixawa, meme mätexu namixäwikngä täpiläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Tiwänä Judatä “Ina hängä gamit?” yang inikut. Tiwän Tematä “Hängä umanda tuwängge matäkinä guläkgane mapi epunggaxu uläpä, napnä bulak namike, hiputdaxäyä namiyo,” yang inikut. Iniwän hängä inä natäpgut using uläpäyalu imänä yiwikumäläk. U yiwikumäläk gwende engang muhip päkut. ");
INSERT INTO awx_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Judaxälu yiwikengä, Tema täku, täwixu nomnä umukulu uxwämbälu utdoteke, kombät täwikngä hipdu tahakut. ");
INSERT INTO awx_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Tixawänu Juda meme mätexu gwendu mängälä uläpäle imixäwik, hängä täpänä hipdu päpikge natäke, notnä Adulam nanä täpäle imän, täke kukut. Täke kuke teyä mängälä uläpä aläwämbän malikut. ");
INSERT INTO awx_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tiwän Hiratä wäwi taunune yiwäxayingu using yänikut. “Mängälä yumdekän täke tihikukayingu, Enaimde kahit täpäne yiwikulu sändanda?” yawän, “Andanu mängälä using bimä tihikunggaxu täpätu wenä,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tiwän hipdunä apu, Juda using inikut. “Axu tawämba maliwän, wäwi taunune yiwixayinunin yäniwa, ‘Andanu mängälä using tahanggaxu wenä,’ yang naniying,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Iniwän Judatä using inikut. “Yahikukata ninimitnäng. Ge undanä. Hängäläpa nätäne päkulu, undanä peke yiwixäwik. ‘Wamu inikum using meme mätexu ambä imit,’ yake gama, täke ku tawämbi malik. Ge using kakengu, undanä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Yekawu gwenalä gwendu using yiwikengä, apu Juda using inikin. “Ayika Tema yumdekän täke tihikukinä, tängene käyä alik,” yang iniwä, Judatä using yakut. “Kepmän tulitäkepu däkine hawä ihikuyok,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Yawän tängutningge kepmän täke epuxuwä, Tematä bapunäle hängäläpä yämike, wamu using tewän kukut. “Nä hängä aläpäyatde towikngätä engang muhiwu namikut,” yake, unetäkänu using yakut. “Guläkngäne mapä epunggak äwä hiput yangu imindäneka? Ge kätak dayipso,” yang yäniwän, ku inikin. ");
INSERT INTO awx_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Iniwä Judatä hängä uläpäyalunin dayike, using yakut. “Gutongä nätä tahakum. Tike Tema gutongänä wenä, inale nätä kem inike, wawaknga Selale doimikum,” yawän, Tema dolängukin. Tiwänä hipdu doyiwikumäläk. ");
INSERT INTO awx_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Täpduxu engang kake täpikge natäpgut gwenune, “Ukgatäp tinggak,” yang natäpgin. ");
INSERT INTO awx_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Andayike päkut gwenune engangu täpätu kätakngä tewän epgut. Tiwän mängälä anggatängämikge yiwikut täpätä kake, “Andä gämäk apunggak,” yake, trelu gämänä täkngahimdä kätakngäne wamgut. ");
INSERT INTO awx_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tiwändeyä kätakngä hipdu tuliwän koxawänu, notnä täpätä gämäk apgut. Tiwän mängälä uläpätä kake “Waxang! Gätä gämäk kitokake apunggaläk?” yawän, umanä Peres yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Tiwänä notnä trelu kätakngäne wamgut täpä mahande apgut. Tiwän umanä Sera yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josewu Ismaelde bapunätä Isip täke pukukin. Tiwän Isipde kingge kulanä äminde kuhiläle yiwäxaxu Potipa uläpätä Ismaelde bapunäle kätaxune uhikut. ");
INSERT INTO awx_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Josewu Yawetä gatängämixawän, puyä towikngäle yolune pahaxawänu, nomängän tikin. ");
INSERT INTO awx_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potipatä kaxawänu, Yawe Josepkät yiwixäwik gatängämixawän, puyä nomängän pahakut. ");
INSERT INTO awx_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tiwän Potipatä Josewu ilakngä hikngä kake, gatäkgatäkngäle tuwänguke, puyä äminä äwä hängälapänä yangge kuhiläle yiwikge inikut. ");
INSERT INTO awx_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Täpduxu Potipatä Josepde puyä imikut gwenunetä, Yawetä Josepde natäke, Potipale hängäläpä bänip kwikwik yämikut. Potipale hängäläpä yolune nanä awä puyäne nanä yangu undä bänip kwikwik yämikut. ");
INSERT INTO awx_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tiwän hängä täpänä undä Josepdä daying yiwikge inikengu, Potipa dasingga donatäpgut. Tike teyä “Naxu gätä hangamiyo,” yangu doinikut. Josewu tänge täpä, nomnä yangu ilakngä hikngä yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Womsim yiwihikangä, Potipale mängätdä Josep kambutake, “Ai, api pekata,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Iniwän Josepdä “U. Usingu dolahawit,” yake using inikut. “Natäpso. Kuhitnale yiwixakgä nandupän, nä ämin nomän, tiwän hängänä nätä undä daying yiwitde nanikut. Tikengä hängä täpänäle meyä dowänggaxunin. ");
INSERT INTO awx_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Yolu anggwende kuhiläle yiwitde näkän tuwängukut. Tikengu “Hängä täkekän päke pahayo,” yake teyä, gäle usingu donanikut, inale gä mängätnä. Anätule kayine gutongä hikngä uläknga, dasing tahawitde yanggaläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tiwändeyä mängälä uläpätä kwep äpman iniinilikut. Tiwän Josewu ‘Täke,’ yangu doyake, ile wäkngasimkäyä doxukut. ");
INSERT INTO awx_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Gwendune puyä äminu okopi doxoxawä, Josewu puyä pahawikge kopgut. ");
INSERT INTO awx_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Tiwän Potipale mängätdä apu, täwikngäne tänggänggänuke, “Api pekata,” yang inikut. Inike, täwikngäkän täxawän, Josewu epu datäkukut. ");
INSERT INTO awx_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Täwikngäkän täxawän epu datäkuwän kakengä, ");
INSERT INTO awx_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","puyä äminä une pahakayingu yang yawämbän apä, kem wamu using yänikut. “Täwixu axwämbälu känong. Potipatä Hibru nanä ane täpä täkapu tekutdä tängänane wahike, mayakngä täknga nimikge tahawän, yangot. ");
INSERT INTO awx_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Anggatängaminingge yangopa natäke, täwikgnä nätä yiwilune teke, epu datäkuk,” yang yänikut, kemun. ");
INSERT INTO awx_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Yake Josepde täwixu teng yiwixawän, ayä une apän, ");
INSERT INTO awx_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","using inikut. “Puyä äminu Hibru nanä täpä täkapu tekuläkgä mayäkngä namikge tahak. ");
INSERT INTO awx_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tiwändeyä anggatängaminingge yangopa, täwikngä nätä yiwilune teke, epu datäkuk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“Puyä ämindatä näle using tahak,” yang iniwän, ayä tokngä hikngä natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Natäke, Potipatä Josewu kalabus yolu kingge puyä ämindä gutongä pahawä pexaying gwenune täku tekut. Tiwändeyä Josewu kalabusune yiwixawänu, ");
INSERT INTO awx_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yawe ixät gatäke yiwixäwik, ile nomän hikngä tahakut. Yawetä pahawän, kalabus ämin daying yiwixak täpätä Josewu ilakngä kakut. ");
INSERT INTO awx_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kake Josewu kalabus äminde kuhiläle tuwängukut. Tiwän kalabuskätanu inaka pahakinu, itä yäxawän pahakin. ");
INSERT INTO awx_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yawe Josepkät yiwike gatängämixawän, kalabuskätanu ina puyäka pahakulu nomängän tikin. Tiwän kalabus daying yiwixak täpätä puyä Josepde imikengu, meyä dowäkut. ");
INSERT INTO awx_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Josewu kalabusune yiwixawängän, täpduxu gwendune Isipde kingge wain pahake iminggak täpä äwä bret hängäminggak täpä yangu kingge kayine gutongä pahakumäläk. ");
INSERT INTO awx_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pahawät, Isipde kingu uläpäyatde tokngä hikngä natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Tikengä kalabus yolu Josepdä yiwixak gwenunekän päku, kalabus daying yiwixaying äminde kuhiläle yolune pekin. ");
INSERT INTO awx_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tiwän kuhiläle yiwixak täpätä Josepde imän, daying yiwikut. Kalabusune belakngä womdu yiwihikangä, ");
INSERT INTO awx_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","wain pahakakut täpä äwa bret hakakut täpä yangu dambu täpduxu inä unggwenunekän inäinä tikumäläk. Dambu ulikumäläxu yäpulinä inäinä. ");
INSERT INTO awx_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kwepdätä tembänä Josepdä apungu, anatänatälike yiwixawät dayipgut. ");
INSERT INTO awx_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Dayike “Gilu inale natänatälikamäläk?” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yäniwän, “Nilu dambu inäinä dayimäk. Tiwändeyä dambu ulimäkge yäpuli nininangäsä äminu wenä,” yang inikumäläk. Tiwän Josepdä “Dambule yäpuli Anätutäkän yäminggaxunin. Ge dambuhä undan yähon,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tiwän kingge wain pahakakut täpätä Josewu using inikut. “Dambu tängäne wainu täkngatu kat. ");
INSERT INTO awx_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Wainu uläknga kätakngä täkngayalä täkngatu. Tiwän gwäkgwäkngäne salinä yupsänggän alaxäwik galaying. ");
INSERT INTO awx_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tiwän kingge käwu nätä tätnä, unggalayingunin päke sasapa, kingge käwune pukuwä, inäle imit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Tiwän Josepdä “Dambu uläknga yäpuli using,” yake using inikut. “Katakngä täkngayalä täkngatu dayiläxu täpduxu gwenalä gwendu. ");
INSERT INTO awx_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Täpduxu gwenalä gwendu yiwikengu, gä kalabusde yiwiläxu, kinggä yawän epuxuwiläk. Tiwän puyä yakap pahakakuläk täknga hipdu äpme gamän, wainu pahaxäwik, kingge imiläk. ");
INSERT INTO awx_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","“Gäle using tahawän kakengu, gätä näle butayä natäpso. Natäke, kingu ainiyo. Tiwän kalabusunetä napmämbän epuxuwit. ");
INSERT INTO awx_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nä Hibrule kewunetä ämindäkän nanitäkapgin. Ngä anexäyä gutongä täkngatu dolahakum. Tiwändeyä kalabusde yumdekän täkapu napmambä yiwixat,” yang inikut, Josepdän. ");
INSERT INTO awx_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wain pahakakut täpäle dambu yawän natäke, Josepdä yäpuli nomän hikngä iniwän kake, bret hakakut täpäxäyä Josewu using inikut. “Näxäyä dambu täkngatu using tit. Baskelu bretnänäxäyä gwenalä gwendu kuhitnane gwäpit. ");
INSERT INTO awx_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Enetängä gwenune brelu inäinä kingge pät. Tiwändeyä anggwäpilune kwäwitdä apu päku naying,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yawänä Josepdä natäke “Dambu uläknga tiläxu yäpuli using. Baskelu gwenalä gwendu dayiläxu täpduxu gwenalä gwendu. ");
INSERT INTO awx_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Täpduxu 3 gwenune kinggä yawän, kalabusunetä epuxuwi, guläkga pahandäkngake, däki täpäne täko mapä wukuwi, kwäwitdä gupda näning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Täpduxu 3 ungggwenu kinggä alakutde täpduk. Ge kinggä naxu puyä äminäle kuhiläle inulung hängyämikut. Tikengä wain pahakakut täpä äwä bret hakakut täpä yangu kalabusunetä pewän epuxuke, puyä äminu uläkwäkge kayine kukumäläk. ");
INSERT INTO awx_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tiwän wain pahakakut täpä puyä tupä pahakakut using imän, kingge käwu hipdunä täke imikut. ");
INSERT INTO awx_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tiwänu bret hakakut täpä kinggä yawän, puyä äminätä täku, däki däkäne mapä pukukut. Hängä ulikulu inä dambu tike yawät, Josepdä yänikut using tikut. ");
INSERT INTO awx_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tiwändeyä wain pahakakut täpä puyänä hipdu täkengu, Josepdä iniwän kakutde bulämnä hikngä natäpgut. ");
INSERT INTO awx_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Krismasu gwenalä apuxuwänä, Isipde kingu dambu täkngatu using tikut. Yanggä Nail Dupine yiwike kaxawän, ");
INSERT INTO awx_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","towiyä gämänu 7 bulämbam, tiwän tänge ilakngäkän gwenggwenu yanggäxätandä akoxuke, songäsongä une nanä naxäwik yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tixawän towiyä gämänu tänge wenäxäyä 7 yanggäxatandä akoxuke, tänge käyä gwenggwendä yiwikinunekän päkapu yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tikengä tänge käyä gwenggwenu, tänge wenä uläkwäkgä apu yähake napulukin. Tiwän kingu unin kake naxälake enakut. ");
INSERT INTO awx_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tikengä hipdu peke, dambu täkngatuxäyä using tikut. Wilu dupitunetäkän bulä inulungu 7 alake galakin. ");
INSERT INTO awx_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tiwän dupituxäyä bulä 7 alawä, gusitdä akonggakätandä wawuwawungu tokngä täkngatutä apu ihiwän, bulä mätekngä hikngä tikin. ");
INSERT INTO awx_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Alake, wilu bulä inulung alakinu, mätekngä alakindä guläk päkin. Tiwän kingu unin kake naxälake enake teyä, dambu tikutnä kakut. ");
INSERT INTO awx_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tembänä enake, dambu ulikutde natänatälikut. Tikengä dambu natäke yäpuli yäkaying äminunin äwä natändetdet ämin yang undä yawän apä, dambu tikulu yänikut. Tiwändeyä u yiwikinu täpätutä dambu ulikutde yäpuli donatäke initapgin. ");
INSERT INTO awx_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tiwänä kingge wain pahanggak täpätä kingu using inikut. “King, gutongä tahakumu using ganiwit. ");
INSERT INTO awx_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Gätä näxät bret pahanggak täpäxätde tokngä natäke, kalabus daying yiwixayingge kuhiläle yolune kalabusde nipmakuläk. ");
INSERT INTO awx_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kupilä gwendune dambu inäinä tikumäk. Ulikumäxu yäpulinä inäinä. ");
INSERT INTO awx_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","King kang yiwixayingge kuhiläle puyä äminu wawakdäkä Hibru nanä täpätuxät yiwikumäng. Ngä dambu tikumäxunin inita natäke, yäpuli inäinä ninikut. ");
INSERT INTO awx_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tiwän hängä itä ninikut using hikngä tikin. Nä puyäna hipdu namixäwik, bret hakakut täpä tänguwä kumgut,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Iniwän kinggä puyä äminä yäniwän, Josewu kalabusune yiwikulu yupsäng täkapgin. Täkapä kuhit dänggämnä äwä gen dänggämnä yang matäke, täwixu käluk pahake, kingge kukut. ");
INSERT INTO awx_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Tiwänä kinggä Josewu using inikut. “Dambu täkngatu titnä yäniwa, äminu täpätutäkänkäyä yäpuli donanik. Tike gäle using yaying. ‘Dambu iniwä natäkengu, yäpuli nomängän yänggaxunin,’ yang naniying,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Iniwän Josepdä kingu using inikut. “King, hängä uläknga nätä dolahanggalunin. Tike gätä natäläxu, Anätutä äpme ganiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Iniwän kinggä Josewu inikut. “Dambu tängäne using kat. Yanggä Nail Dupile kwayimune yiwike kaxawa, ");
INSERT INTO awx_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","towiyä gämänu 7 bulämbam, tiwän tänge ilakngäkän gwenggwenu yanggäxätandä akoxuke, songäsongä une nanä naxäwik yiwiying. ");
INSERT INTO awx_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tiwän ile mähene towiyä gämänu 7 tänge wenä, tiwän wäyi hikngä gwenggwenkäyä yanggäxätandä akoxuying. Isipde kewune towiyä gämänu usä bimä gwendunekänkäyä dohikngä dayipgum. ");
INSERT INTO awx_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Akoxuke tänge wenä unggwenggwendä apu, tänge käyä yakap akoxuyingu yahake napuluying. ");
INSERT INTO awx_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tiwändeyä ämindä dayikengu, ‘Usingbä naying’ yangu natäpnangäsändo, inale tänge wenä. Tiwän yakap yiwiying usinggän yiwiying. Tiwän unin dayike enat. ");
INSERT INTO awx_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Tikengä hipdu peke, dambu täkngatuxäyä using tit. Wilu dupitunetäkän bulä inulungu 7 alake galaying. ");
INSERT INTO awx_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tiwän hipdu 7 alawä, gusitdä yähawän, mätekngä hikngä tiying. ");
INSERT INTO awx_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tike ako wilu inulung alayingu, mätekngä alayinggä guläk päying. Tiwän unin dayike enakengä, dambu natäke yäpuli yäkaying äminunin yäniwa, täpätutäkänkäyä yäpuli donanik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tiwänä Josepdä kingu using inikut. “Dambu tiläxu usäkän, tiwän yäpuli täkngatukän. Anätutä dasingga tahawikge natäxu, unin tahawän kaläk. ");
INSERT INTO awx_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Towiyä gämänu nomänu 7 dayiläxu krismasu 7. Tiwän wilu bulä nomänu 7 dayiläkäyä krismasu 7. Dambu uläkngayalu usäkän, tiwän yäpuli buläkän. Naxu meyä äpme alaxawä, krismasu 7 apik. ");
INSERT INTO awx_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","“Tiwän ile mähene towiyä gämänu tänge wenä, tiwän wäyi hikngä 7-u dayixawi akoyingkäyä, krismasu 7. Tiwän wilu gusitdä yähawän bulä 7-u wäyi alayingkäyä krismasu 7. Yäpulinä krismasu 7 nakge äpme dapmäke yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ayat usinggän Anätutä dasingga tahawikge natäxu, unin tahawän kaläk. ");
INSERT INTO awx_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Isipkätanu naxu meyä hikngä alaxawä, krismasu 7 apik. ");
INSERT INTO awx_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tiwänä ile mähene nakge dapmäke yiwixawä, krismasu 7 apik. Apän Isipkätanu naxu meyä hikngä yakap alatningge äpme bulämdaning, inale naxu wenä hikngä tixawän, kep gomu wäyi tiwik. ");
INSERT INTO awx_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Naxu wenä hikngä tiwän, naxu yakap alawä meyä näning gwenggwende äpme bulämdaning. ");
INSERT INTO awx_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Anätutä dambu uläkngayat gamixu, yäpulinä buläkän usingge gamik. Inä Anätutä ‘Using hikngä tahawit,’ yangu anatäkengä gamik. U natäk using hikngä tinanggenggak. ");
INSERT INTO awx_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ge äpmanu äminu natändetdetnä kayä, tiwän natändetdet wam yänggaxu täpätu tuwänguyo. Tiwän Isip kewu awomu itä kang yiwik. ");
INSERT INTO awx_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ile gepbine yiwitningge äminu täkwäkguxäyä tuwänguyo. Tiwän itä yiwike yäxawä, puyä pahaningune nanä undä, naxu 5 päningune nanä aupuke, 4 inäle pexäwik, 1-u puyä äminu uläkwäkge yämixawä pening. ");
INSERT INTO awx_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Krismasu naxu nomän alatning gwenggwenune nanä, wilu kingge umande päke, nak yolu taunune nanä gwengwenune mahande näningge peke daying yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Naxu uläkwäxu mähande Isip nanätä takgä yiwixäwik päke näningge pening. Ge kantri awomu nakge dondapning,” yang yänikut, Josepdän. ");
INSERT INTO awx_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Josepdä wamu uläknganin yawän, kingkät puyä äminäxätdä natäpä, nomän tikut. ");
INSERT INTO awx_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tiwän kinggä puyä äminä using yänikut. “Anätule wawungu äminu aläpäle tängäne yiwixak bimä käyä? Ngä uläpä tuwängutnim,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tikengä kinggä Josewu using inikut. “Wamu uläknga yaläxu, Anätutä gäle gamän yänggaläk. Tiwän natändetdet äminu gä bimä täpätu wenä. ");
INSERT INTO awx_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ge gä kantrinale kuhiläle yiwiläk. Tiwän äminu undä gäle wam gwälamike yiwitning. Tiwändeyä nä king. Ile tiwän, näle kematde yiwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kinggä Josewu using inikut. “Nätä gä bulämbam täpäle tuwänguwa, Isip kewu undä awomunin kang yiwiläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Inike ringu tuwängge matäkinä kinggä kätakngäne täpän pukukulu utdoke, Josepde kätaxune täpän pukungämikut. Tiwänä hipdu täwixu kwikwikngätä bupginu belakngä kwämbätdu imän tahakut. Imän tahawänä, uhixu täkngatu goldä tahakinu Josepde guläxune mapän pukukut. ");
INSERT INTO awx_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Tiwän kinggä Josewu äminbamde yakap täpäle tuwänguwän yiwikutde, kalisu kwämbätdu imän, une päko yiwike kukut. Kuxawän kingge puyä äminätä yakap kuxäwik, “Kundäkngake yapmitnong,” yang yakin. Kinggä Josepde using pahakut. Tiwän Isipde bulämbam täpäle yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Tiwän kinggä Josewu using inikut. “Nä king. Tiwändeyä using yänggat. Isipkätanu inaka yumdekänu dowahaning. Tike gätä ‘Using pahanong,’ yang yäxawikänä, pahaning,” yang inike, ");
INSERT INTO awx_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Josewu umanä käluk täknga Sapanet-Panea yang inikut. Tikengä Onde prisu umanä Potipela, tiwän yäpanä umanä Asenat uläpä, kinggä Josepde imän, mängätnäle täkut. Tikengä Isipde kewu undä tihikuke kakut. ");
INSERT INTO awx_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josewu krismasnä 30 using yiwixawän, Isipde kinggä puyä bulämbam däkä yawän täkut. Täke kingu teke, Isipde kewu undä tihikuke kakut. ");
INSERT INTO awx_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","“Krismasu 7 naxu meyä alatning,” yakut using, krismasu unggwenggwenu naxu meyä hikngä alakin. ");
INSERT INTO awx_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Isipkätanu naxu meyä alakin gwenggwenune Josepdä yawän, naxu undä taunu yiwixayingune äpmele inäinä petäke kukin. Naxu puyä taun kwayimune pahakinunin päxäwik, päku yämixawä, nak yolu taunune nanä gwenggwenune petäke kukin. ");
INSERT INTO awx_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Wilu duksäng päkapu pexawä, meyä hikngä haluhalu yanggä gwenune nanä bimä tikut. Tinggawän axendekinu kendetnangasändo tiwän, undan tekin. ");
INSERT INTO awx_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Krismasu nakge dapningge gwenggwenu doapuxawän, Josepde mängälu Asenat, Onde prisu Potipelale yäpatä wawakngä täpäyalä dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Tiwän Josepdä “Anätutä gatängamän, meyä apgin äwä yotna nanä yangge ambulämdat,” yake, engangä yakäp täpä umanä Manase yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Tikengä wawakngä maha täpä “Äminde kewune meyä bulak yiwit deyä, Anätutä tahawän, engangu towikggat,” yake, umanä Epraim yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Naxu meyä alakinu äalaxawäkän, krismasu 7 apuxuwän pulukut. ");
INSERT INTO awx_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Josepdä “Krismasu 7 nakge dapning” yakut using, krismasu yakap gwenu une apän, kepkewu sänesäneka yiwihikukayingu nakge undä dapgin. Tiwändeyä Isipkätanu naxu käyä tikut. ");
INSERT INTO awx_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Yiwihikangä Isip nanäxäyä nakge dapmäke, ku kingu nakngäle inikin. Tiwän kinggä using yänikut. “Josepde kuwä, itä dasingga pahaningge daniwänu, using pahanong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nakgäne täknga, kantri Isiwu undä gwen dapgin. Tiwänä Josepdä yolu wit pekin gwenggwenu yämä siwän, Isip nanätä apu, naxu moninggä uhikin, inale Isipkätanu naxu wenä hikngä tikut. ");
INSERT INTO awx_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kewu undä gwen naxu wenä hikngä tiwän, Isipgän apu, wilu Josepde tängäne moninggä uhikin. ");
INSERT INTO awx_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","“Isipkätanu wilu käyä,” yawä natäke, Jekopdä wawakngä yänikut. “Ginu ina nänimde nakge wamu doyake yiwixaying? ");
INSERT INTO awx_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isipkätanu wilu käyä yawäxakum. Ge une puku uhike päkakopnong. Tiwän unin nakengu, doxumnim,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tiwän Josepde payänä 10 täkwäkgäkän wit uhiningge Isip pukukin. ");
INSERT INTO awx_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tiwändeyä Josepde ulawu Bensaminu “Täke kuwä tängutnäng,” yake, nanätä äinindäkngakut. ");
INSERT INTO awx_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Äminu nakge dapmäke, wit uhiningge kuxawä, Israelde wawakäyä pukukin, inale Kenankätankäyä naxu wenä tikut. ");
INSERT INTO awx_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Isip kepkätanu Josewu kuhiläle yiwixawän, äminbamdä wilu ile tängäne apu uhixäwik, päke kukin. Tixawän payänäxäyä wit päningge apuke, Josepde nomune sopäsopä puke, däme päpu, kewune yamgin. ");
INSERT INTO awx_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Axuwä Josepdä dayikengu, “Payäna,” yangu anatäpgut. Tike teyä “Womdune nanä yäning,” yake, “Ginu sänetä apukaying?” yangu kitokngäkän yänikut. Tiwän “Ninu Kenandä nak uhinimde apumäng,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josepdä dayike, “Payäna,” yangu anatäpän deyä, payänä täkwäkgä “Äminu aläpä, Josepbä,” yangu donatäpgin. ");
INSERT INTO awx_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tixawänu dambu yakap tike dayipgut täkngale une natäpän kukut. Tiwän “Ginu amäk tahanangge wepdä apuke nindutapningge apuying. ‘Isipde yolu womduyi dämänu wenämbä,’ yang yake katapningge apuying,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yäniwän, payänätä “O bulämbam täpänin, usinggendo. Tike nak uhinimde apumäng. ");
INSERT INTO awx_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ninu täpätule wawakgän. Tiwän wamu hiyäkängän yäkamängunin. Ninu wepdä apuke dandutapnimde doapumäng,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iniwä Josepdä “Ginu kem yäkaying. ‘Isipde yolu womduyi dämänu wenämbä,’ yang yake katapningge apuying,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Tiwänä yäkwäle wamu using inikin. “Ninu Kenan yiwixamängunin. Tiwän ninu täpätule wawakgän. Nanindä ulapninu täpäyaläxät towikut. Tiwän ninu unekänu 12. Tiwändeyä ulapninu täpätu wenä. Tike wasekngä täpä naninkät yiwixawät apgumäng,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tiwän Josepdä using yänikut. “Ginu wepdä apuke, nindutapningge apuying yangu andanit. ");
INSERT INTO awx_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hiyäkändembä yäkayingge using tahake dandupit. Ane yiwixawäkän, ulapsä wasekngä täpä apik. Tike doapänu, kingu käluk yiwixakge umande, wamu kitokngä yänggat. Yolu awomu doleke kuning. ");
INSERT INTO awx_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ginu undä kalabusune pexawä, täpätutäkän ku ulapsä täkapsok. Tiwänä wamu hiyäkände yaying yangu natäpit. Tike wenä tiwänu, kingu käluk yiwixakge umande yänggat. Ginu wepdä apuke, nindutapningge apuying yang natäpit,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yake kalabus yolune päku pewän yiwixawä, täpduxu gwenalä gwendu tukwake kwakakut. ");
INSERT INTO awx_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Täpduxu 3 gwenune Josepdä using yänikut. “Nä Anätule anaxaläkgalunin. Ge nätä daniwit using tahakengu, doxumning. ");
INSERT INTO awx_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ginu hiyäkändekän yäkayingä kakengu, notsä täpätu kalabus yolune tewä yiwixawän, täkwäkgutäkän wilu yotsäle päke kunong, inale notsäbamu takgä yiwayak. ");
INSERT INTO awx_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tiwändeyä ulapsa wasekngä uläpähimu aläkapä kayot. Tikengä wamu hiyäkände yakinä tinggak yangu natäke, doyäwa dahipning,” yang yäniwän, “Uyänggaläk usingu äpme tahanim,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tikengä inäkänu using yiwikyakin. “Ulapnin tahana malikutde, äpmanu meyä nihä päkamäng. Kwänämkät tixäwik ‘Manutnong,’ yang yakwakäxawängän, tahana malikut. Itä päkut bimä, meyä nihä päkamäng,” yang yakin. ");
INSERT INTO awx_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Yawä Rubendä yänikut. “Nätä dasing danikum? ‘Josewu dolahana maliwik,’ yangu andanixawayä tahawäxakum. Unin tängutna kumgutde, ile yäkwäle täknga Anätutä meyä unin niminggak,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Josewu Isip wam yäxawän, puyä äminä täpätutä Hibru wamune päpän täkwaxawä, yänikut. Tiwän “Nihä wamu u yamängu dombä natäk,” yang natäpgin. Tiwändeyä wamu yakinu Josewu anatäpgut. ");
INSERT INTO awx_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Unin yawä natäke, Josewu kepmän täpu kwänämnä tiwän täkawänä, hipdu ako wamu yänikut. Tikengä puyä äminä yäniwän, Simion tänggänggänuke, bälängä äwä kätakngä yangu, notnä axang yiwixawäkän, napdä wamgin. ");
INSERT INTO awx_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tikengä Josepdä puyä äminä wepdäkän using yänikut. “Wit äwä naxu kahitde näningge yang inäinä kekngälukyäminong. Tikengä moningä inä päkapginu, wit kekngälutningunekän inäinä kekngälukyäminong,” yang yäniwän, inä u yänikut using kekngälukyämikin. ");
INSERT INTO awx_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tiwäna yäkngä donggi päkapu pekinune päko peke, päke kukin. ");
INSERT INTO awx_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Axuxawä tukwawän, awetningge yiwikin womune, notnä täpätutä dongginäle nak imikge yäkngäxätan sikengu, moningä hipdu yäkngäxätan kekngälukinä kakut. ");
INSERT INTO awx_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kake “Mäte kanong. Nä moninga hipdu yäkngaxätan kekngäluyingä tinggak,” yang yänikut. Yäniwän meyä hikngä natäxäwik, kwätälä yamuxawä, kawäkawän tahake, “Anätutä awomu dasingge tahanggak?” yang yakin. ");
INSERT INTO awx_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Tikengä ko nanä Jekowu Kenan yiwixawän, hängä Isip kuwä, dasingga pahakinu undä inikin. ");
INSERT INTO awx_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Using inikin. “Isip kewu uwomde kuhiläle yiwixak täpätä ‘Ginu amäk tahanangge wepdä apuke nindutapningge apuying,’ yang ninike, kitokngäkän ninikut. ");
INSERT INTO awx_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tiwän nindä using inikumäng. ‘Ninu wamu hiyäkängän yäkamängunin. Wepdä apuke dandutapnimde doapumäng. ");
INSERT INTO awx_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ninu Kenan yiwixamängunin. Tiwän ninu täpätule wawakgän. Nanindä ulapninu täpäyaläxät towikut. Tiwän ninu unekänu 12. Tiwändeyä ulapninu täpätu wenä. Tike wasekngä täpä naninkät yiwixawät, teke apgumäng,’ yang inikumäng. ");
INSERT INTO awx_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Tiwän kuhiläle yiwixak täpätä using ninikut. ‘Using tahawäyä, ginu hiyäkängän yäkaying äminunin yang natäpit. Notsä täpätu ane tewä yiwixawän, täkwäkgutäkän wilu yotsäle päke kunong, inale notsäbamu takgä yiwayak. ");
INSERT INTO awx_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tiwändeyä ulapsä wasekngä uläpähimu aläkapnong. Tiwän kawit. Kakengä ginu wepdä apuke nindutapningge doapuying, tike wamu hiyäkängän yäkaying äminunin, yang natäpit. Tikengä notsä ane yiwik täpä hipdu damit. Tiwän Isip kewu awomune täkekän tihikuning,’ yang ninikut,” yang inikin, nanän, Jekowun. ");
INSERT INTO awx_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Naxu päkinunin wälixäwixu, moningä wit uhiningge päke kukinu hipdu yäkmätekngäne inäinä kekngälukyämikinä dayipgin. Unin dayikengu, wawakngäxät nanäxät naxälakin. ");
INSERT INTO awx_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tiwän nanätä using yänikut. “Gindä pahawä, enganga täpäyalätä hikngä hopikamäläk. Josewu hopikutnä äwä Simionkäyä hopinggak. Tiwän Bensaminkäyä täke kuningge yäkaying? Gindä tahaxäwik, meyä däkä namikaying,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Yäniwän Rubendä nanä using inikut. “Bensaminu kätakngane teyo. Tiwän täke kuke, hipdu täkapit. Tike doläkapa kakengu, nina wawaxu uläpäyalu yäkwäle täke sipi kumsimäläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Iniwän nanätä using yakut. “Reseldä dukngikulu wawaknga uläpä ginkälu dowukuning, inale payänä axumgut, tiwän aläpähimdäkän yiwixak. Tiwän nä äminäläke alit. Ge axuxawä, kahit täpäne meyä täkngatu ile apänu, nä butayä täknga naminingunin. Tiwän nä butayä uläkngatä nuwän kupilunin,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kenan kepkätanu naxu wenä hikngä tikut. ");
INSERT INTO awx_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tiwän wilu Isipdä päkakopginu änänggäwä puluwän, Jekopdä wawakngä using yänikut. “Hipdu puku, naxu uhike päkakopnong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tiwänä Judatä nanä using inikut. “Äminu bulämbamu uläpätä yäko wamu using ninikut. ‘Ulapsä doläkapningä kakengu, ginde nomu dohikngä dandupit,’ yang ninikut. ");
INSERT INTO awx_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ge gätä täke yawi, ulapninkät pukukengu, naxu äpme uhike päkakopnim. ");
INSERT INTO awx_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tike ‘Ulapsä mäläke pukunong,’ yawi, ninu dowukunim, inale ‘Ulapsä doläkapningä kakengu, ginde nomu dohikngä dandupit,’ yang ninikut,” yang inikut, nanän. ");
INSERT INTO awx_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tiwänä Israeldä using yänikut. “Äminu bulämbamu uläpä ‘Ulapninu täpätu käyä’ yangu inale inikin? Using inikinde, meyä täknga namikaying,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yäniwänä wawakngätä using inikin. “Äminu uläpätä nihäle äwä ninkät nanäle ninikwayikut. ‘Nansä undan yiwixak?’ yake, ‘Äwä notsä täpätu käyä?’ yang ninikwayikut. Tiwän ‘ “Ulapsä aläkepnong,” yang niniyäk,’ yangu donatäxäwik, yäkwäle wamu ‘Hii, käyä,’ yang inikumäng,” yang yakin. ");
INSERT INTO awx_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Tiwänä Judatä nanä using inikut. “Iniwi, näle apän, yupsäng pukuna. Ge nak päkakopna nake, nin, gika, äwä wawakdäkänin yangu doxumnim. ");
INSERT INTO awx_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Wamu kitokngä using yänggat. Bensaminu nina äpme kang yiwit. Nätä ane gäle doläkapukengu, gutongä nätä gäle tahawit. Ge gutongä u tahawit täkngale, meyä täknga täke namiläk. Tiwän yiwikyiwiknga yiwilune, nina iwikge äpme päng yiwit. ");
INSERT INTO awx_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Gätä ‘Täke,’ yawi tupä pukukumäng gämu, awukuke akoke, hipduxäyä awukuke akopnam,” yang inikut, Judatän. ");
INSERT INTO awx_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tiwänä Israeldä using yänikut. “Using tiwänu, using tahanong. Hängä gwälamgwälamu kewu awomune nanä yäksäne kekngäluke pänong. Ge bänip gwalängge, äminu uläpäle unin imining. Pa inuxu käpängä gwälam, ingutbamdäne yanggäyi, äwä pa salinu anäkayingu kutan bimä unin yang pänong. ");
INSERT INTO awx_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Tikengä, moningu yakap päke kuwä ambäwäpahoke kengalutdamä päkapginkät, käluk päningkät unekän peke, ");
INSERT INTO awx_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ulapsäxät täpä päke, äminu uläpäle yupsäng pukunong. ");
INSERT INTO awx_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Anätu Kitokngänä Käyä Täpätä tahawän, äminu uläpätä ginde butayä natäke pewän, Simionkät Bensaminkälu päkapnong. Dasingga? Wawaknga wenä tiwänu, undanä. Butayä täkngane yiwixawit,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tiwänä Israelde wawaxu moning, bänip gwalängge hängä, äwä Bensamin yang päke, Isip pukukin. Päpu, Josepde kayine yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tiwän Josepdä Bensamin kake, puyä äminäle kuhitde yiwixak täpä using inikut. “Äminu aläkwäxu yotnane yänipäku peyo. Tikengä kälawu gwendu tänguke hanggayo. Ge nätä kepmä wom apa, naxu ixät nänim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tiwänä Josepdä inikut using, äminu uläkwäxu Josepde yolune yänipäke kukut. ");
INSERT INTO awx_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Josepde yolune päke kuxawän naxälaxäwik, using natäpgin. “Yakap apna, moningu yäknginune kekngäluknimä päke kukumängge natäke tahanggak. Ge anihipmäke, puyä äminäle päke pewän pahaxätna, dongginin päpikge tahanggak,” yang yaxäwik naxälakin. ");
INSERT INTO awx_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tikengä Josepde yolune yämä däkäne täku, puyä äminäle kuhiläle yiwixak täpä using inikin. ");
INSERT INTO awx_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“O, hiyäkän hikngä, bulämbam täpä. Yakawu ninu naxu ane uhinimde epgumäng. ");
INSERT INTO awx_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ngä axuxätna tukwawän awetnimde yiwikumäng womune yäkngin sikengu, moningu inä awäkumäng usinggän inäinä yäknginde mawune dayipgumäng. Ge hipdunin päkapukamäng. ");
INSERT INTO awx_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Moningu kälukäyä nak uhinimde awämäng. Tiwändeyä moningu äminu uläpätä hikngä kengäluknimik yangu donatapgumäng,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yawä “Täke un. Manaxälatnong, inale moningsä awäkum. Tiwändeyä Anätuhä, nansäle Anätutä hikngä hängä gwälamu yäksäne damikutnä tiwänak,” yang yänikut. Tikengä Simionu yawän, ku notnäle täkapgin. ");
INSERT INTO awx_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tiwän Josepde yolune päke koke, yanggä bälängä hälutningge yämike, dongginäle naxu yämikut. ");
INSERT INTO awx_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tiwän naxu une näning yang yawän kakinde, bänip gwalängge päkinu, Josepde kepmä wom apän iminingge tändäkngakin. ");
INSERT INTO awx_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tiwänä Josewu yolune apän, hängäläpä tändäkngakinu imike, sopäsopä puke, däme kep däkäne päpu yamgin. ");
INSERT INTO awx_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tiwänä Josepdä using yänikut. “Ginu iwalu dolike apuying? Nansä äminäläke yawäxakumu uläpä dasing? Täkekän yiwänak?” yang yäniwän ");
INSERT INTO awx_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","yäkwäle wamu using inikin. “Naninu gäle gepbine yiwixak täpä täkekän yiwänak,” yang inike, “Äminu aläpä bulämbam täpä,” yang natäke, sopäsopä hipdu puke, däme kep däkäne päpu yamgin. ");
INSERT INTO awx_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tiwän dayitäke kukengä, inä mingäle wawaxu Bensamin kake, using yänikut. “Ulapsä wasekngä täpä yawäxakumu, unin an?” yang yänikengä, Bensaminu using inikut. “Wawaknga, Anätutä gäle gwälam hikngä tahaxawän yiwitäke kuyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ulapnä Bensamin kawän, butayä hikngä tiwän, yupsäng hikngä peke, epu täku, yotnä inä yiwixakätan kohopike, kwänämnä tikut. ");
INSERT INTO awx_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tikyiwihikangä, kayi yanggänä yanggätä pahawän kuwä, apu dolikut wälä däkngake, puyä äminä “Naxu sixut,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Tiwänä sike, Josepde gwenu inätä imike, notnä täkwäkge inätä yämike, Isip nanä Josepde yolune nakayingu inätä sikyämikin. Isip nanätä naxu Hibru nanäxät näningge mähe hikngä natäxakin. Ge unekänu nänangäsändo. Ile tiwän inäinä sikyämikin. ");
INSERT INTO awx_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Notnä uläkwäxu alakin using, yakap täpänetä ku wasekngä täpäne yäxawä, yiwitäke kukin. Yiwitäke kuwä, “Krismasninu ämbä natäxak?” yake, kawäkawän tahakin. ");
INSERT INTO awx_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Naxu sikyämikinu, päyänä täkwäkge inäinä yämikin. Tike teyä Bensaminde sikin gwenu, äminu 5-dä nänangäsä gwen sikin. Naxu naxälä näxäwik, wainkäyä naxälä tängopgin. Tixäwik Josepkät kuläkake yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Naxu napä puluwänä, Josepdä puyä äminäle kuhitde yiwixak täpä wepdäkän using inikut. “Naxu yäkngäne meyä kekngälukyämi dopäyä, moningäxäyä yäk mawu inäinäne kekngalukyämiyo. ");
INSERT INTO awx_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tikengä silwa käpna ulapnä wasekngä täpäle yäk mawune moningu wit uhiwikge päkapgutkät kekngälukngämiyo,” yawän, inä Josepdä yakut using tahakut. ");
INSERT INTO awx_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kwepdätä tembänä hikngä gusilu akoxawän, Josepde puyä ämindä yäning yäpiwä, dongginä päke kukin. ");
INSERT INTO awx_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Taun teke kuwä, belakngä dolixawän, Josepdä puyä äminä inikut. “Äminu uläkwäxu yupsäng yäwaläke ku pänggänggänuke, using yäniyo. ‘Nindä ginde nomän tahana teyä, gindä ninde wäyi hikngä täknga inale hikngä tahaying? Bulämbam täpänale käwu kukäle inale täying? ");
INSERT INTO awx_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Käwu unggomune tängoxäwik, natändetdelu wepdä yiwixayingkäyä unggomune päxäwik yatapmänggaxunin. Ginu wäyi hikngä tahaying,’ yang yäniyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tiwän ku pänggänggänuke, wamu Josepdä yakut using yänikut. ");
INSERT INTO awx_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tiwänä using yakin. “O bulämbam täpä, dasingge hikngä natäke nininggaläk? Ninu hiyäkän hikngä yäkamäng. Usingu dohikngä tahamäng. ");
INSERT INTO awx_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Moningu yäknginune dayipgumängu, Kenandä hipdu äwäkapna dayipguläk. Ge ‘Silva bä gol kukäle päying,’ yangu inale natäke nininggaläk? ");
INSERT INTO awx_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ninu apumängu äminu täpätutä täkngä kakengu, täke tänguwä kungäxawän, äwä ninu dolämängu puyä ämin moyoyikale yiwitnim,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“Täke un. U yäkaying using tiwik. Imindäka täkngä kakengu, uläpä näle puyä ämin moyoyi däkngaxawän, ginu täkwäkgu meyä dowäning,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Yang yäniwän, yäkngä inäinä kewune yupsäng päkepu peke sikin. ");
INSERT INTO awx_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Sixawä Josepde puyä ämindä dayitäke kukut. Payänäle yäxunetä dayitäke kuhikangu, käp gomu Bensaminde yäxune kakut. ");
INSERT INTO awx_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tiwän unin kake, meyä hikngä natäke, inä täwik wehekin. Tikengä yäkngä donggi tängäne päko peke, hipdu taunde kukin. ");
INSERT INTO awx_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Josewu yotnäne yiwixawän, Judaxät notnä täkwäkälu “Asing tahana, ninde butayä äpmembä natäpik,” yake okopi päko, Josepde kayine pimakin. ");
INSERT INTO awx_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Tiwänä Josepdä using yänikut. “Ginu käpna kukäle inale täying? ‘Natändetdelu wepdä yiwixayingunin yatäpmänggaxunin,’ yangu donatäke tahaying?” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yäniwän, Judatä yäkwäle wamu using inikut. “O bulämbam täpänin, ‘Gutongä dolahamäng,’ yangu dasing ganinim? Anätutä wäyininu aläpän tapmäk. Nin äwä käp täkngä kaying täpä yangu undä puyä ämin moyoyika däknganim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tiwänä Josepdä using yakut. “Usingu dohikngä pewa pahaning. Käpna kukäle täk täpätäkän näle puyä ämin moyoyi däkngake yiwixawän, ginu nansäle bänip kwikwik täkngane kunong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tiwän Judatä täku, Josepdä yiwikulune inälängän yiwike, using inikut. “O bulämbam täpänin, wamu täkembä ganiwit? Kingkät gäxälu bulämbam täpäyat. Usäkän. Tike nä puyä ämindatä yäwa, tokngä manatängamiyo. ");
INSERT INTO awx_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tupä ninu using ninikuläk. ‘Ginu nansä ayiwänak? Tiwän notsä täpätu käyä?’ yang niniwi, ");
INSERT INTO awx_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","nindä using ganikumäng. ‘Hii, naninu äminäläke alikengä, ulapninu wasekngä täpä towikut. Ngä undan yiwälak. Mingätä wäwi täpäyaläkän dukngikut. Dukngikutnä payänä axumgut. Tixawän wawakngä wasekngä täpätäkän yiwixak. Uläpä naninde bänip,’ yang ganikumäng. ");
INSERT INTO awx_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Tiwän gätä using ninikuläk. ‘Aläkepnong tiwän käwit,’ yang niniwi, ");
INSERT INTO awx_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","nindä using ganikumäng, o bulämbam täpänin. ‘Wawakdäkä uläpä nanä teke epnangäsändo, inale aleke epänu, nanä axupixunin,’ yang ganikumäng. ");
INSERT INTO awx_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","“Tiwändeyä gätä puyä äminda using ninikuläk. ‘Ulapsä wasekngä täpä doläkepä, ginde nomu hipdu dondandupit,’ yang ninikuläk. ");
INSERT INTO awx_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tiwänä naninde hipdu kokengu, wamu uninikuläk usinggän inikumäng. ");
INSERT INTO awx_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Tiwänä nandä using yakut. ‘Hipdu puku naxu uhinong,’ yang niniwän, ");
INSERT INTO awx_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","nindä using yakumäng. ‘Ninu dowukunim, inale ulapninu wasekngä täpäxälu dowukuna, äminu uläpätä ninde nomu dohikngä nindupikge yakut. Tike ulapninu aapänu, täke äpme pukunim,’ yang inikumäng. ");
INSERT INTO awx_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Tiwänä nanindä using ninikut. ‘Ginu anatäxaying. Mängätnatä wawakngä täpäyaläkän hikngä dukngikut. ");
INSERT INTO awx_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Täpätu ahopikut. Tiwän nä doxakum. Dasingga? Kälap tukgämbä tänguke yahandekin? ");
INSERT INTO awx_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tiwän äpmanu aläpäxäyä aläke kunggäwä, kahit bänäkängän meyä päpänu, gindä näle butayä bulämbam hikngä naminingunin. Nä äminäläke alit. Ge nä butayä uläkngatä nuwän kupilunin,’ yang ninikut. ");
INSERT INTO awx_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Bulämbam täpä, nana wawakdäkä aläpä näxälu doxuta kakengu, axupixunin, inale wawakdäkä aläpä nandäne bäniyä hikngä. Naninu äminäläke hikngä damänsimu alik. Ge wawakdäkä aläpä ninkälu hipdu doxuna, nindä naninde butayä bulämbam hikngä iminimunin, tiwänu axupixunin. ");
INSERT INTO awx_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tiwänä unetäkänu, nätä wamu kitokngä hikngä täkngatu nanu using inikum. ‘Bensaminu nina äpme kang yiwit. Ge doläkapukengu, täpduk täpduxu yiwilu, meyä uläknga ninalekän yiwik,’ yang inikum. ");
INSERT INTO awx_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ge using kakengu, nä Bensaminde tangge täkembä gäle puyä ämin moyoyikale ane yiwixawa, wawakdäkä aläpä payänä täkwäkät hipdu kopning? ");
INSERT INTO awx_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tike wawakdäkä aläpä doxuwänu, nä nanale hipdu doxuwit, inale meyä nanale apik täknga kawitde mähe natäxat,” yang inikut, Judatän. ");
INSERT INTO awx_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josewu butayä hikngä natäke, kwänäm titnangäsä hikngä tikin. Tiwän puyä äminä Isip nanä “Ginu undä hikngä yolu anggwenu teke epuxunong,” yang yänikut. Inale puyä äminä une yiwixawä, notnä “Nä Josep,” yang yäniwikge donatäpgut. Tike inäkän yiwixawäyä yäniwikge natäput. ");
INSERT INTO awx_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ge puyä äminu teke epuxawäyä, Josewu kwänämu bulämbam hikngä yangotixawän, Isip nanä natäxawä, kingge yolune yiwäxaying äminkäyä “Josewu using tik,” yang ku yawä natäpgin. ");
INSERT INTO awx_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Tixawänä Josepdä notnä täkwäxu “Nä Josep. Nana undan ayiwänak?” yang yänikut. Tiwänä notnä täkwäxu anaxälake, yäkwäle wamu doinikin. ");
INSERT INTO awx_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Tiwänä Josepdä notnä using yänikut. “Ane inälängän hikngä apnong,” yawän, apgin. Tiwänä using yänikut. “Nä notsä Josep, tupä gindä Isip nanäle yämä uhikinunin. ");
INSERT INTO awx_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tiwändeyä äpmanu näle u tahakinde, bänipsäxätanu meyä mawänong. Bä tokngä täkngatu gihäle manatäpnong. Inale Anätutä ämin gatangyämikge natäke tewän, nätä gämäxu apgum. ");
INSERT INTO awx_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nak takgä yiwixätna, krismasu gwenalä apuxunggak. Tiwän nak puyä dowahake dowäke, krismasu 5-käyä äpme yiwitnim. ");
INSERT INTO awx_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Anätutä kahitnä inätä hikngä täkngatune gatängdamän, gindä yiwike, bapuha mahande sakngälawikge natäke tewän, nätä gämäxu apgum. ");
INSERT INTO awx_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Nä yolu awomune gindä dolahawä apgum. Tike Anätutä tewän apgum. Tiwänä Anätutä napmämbän, Isipde kingge natändetdet inixäwik, kingge yolune yiwixaying äminunin dayingyiwäxäwik, Isipde kuhiläle yiwixat. ");
INSERT INTO awx_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ge ginu yupsäng ko, nana using ininong. ‘Nä Josep dika wawakgä wamu aläknga tewa apunggak. Anätutä tahawän Isip kewu awomde bulämbam täpäle yiwixat. Ge mayiwiyo. Tike näle yupsäng hikngä epso. ");
INSERT INTO awx_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Päkepu nina wäkngasim, distrik Gosenu kewu uwomune yiwiläk. Ge wawakga, bapuka, towiyä gämända, sipsipda, hängä täpäka yangu ane päkepu peke yiwiläk. ");
INSERT INTO awx_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Äminbamu undä nakge dapmäxawä, krismasu 5 apixunin. Ge ane epnong. Tiwän nätä dandung yiwit. Tike dondanduyiwa, ginu undä nakge dapnäng,’ yak wawakga Josepdän,’ yang ininong. ");
INSERT INTO awx_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Nä Josepdä daninggat. Ginu undä nä nandukengu, anatäpnangäsä. Bensamin, gä ulapna hikngä. Gäxäyä näle anatäpnagäsä. ");
INSERT INTO awx_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ge ko nana ahikngä ininong. ‘Josewu kantili Isipkätanu, umanä bulämbam hikngä,’ yang inike, hängä ane inaka dayiyinggexät inike, yupsäng täkepnong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yänikengä Bensaminu täku betake, kwänämu initikut. Tiwän yäkwälexäyä Bensamindä betaxäwik initikut. ");
INSERT INTO awx_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Tiwän Josepdä notnä undä yänitixäwik, kis pahangyämitäke kukut. Tiwänä notnätä wamu une inikin. ");
INSERT INTO awx_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tiwänä “Josepde notnä aapuying,” yangu kingge yolune yatäke kuwä natäke, king äwä puyä äminäle kuhiläle yiwixaying yanggä täke hikngä natäpgin. ");
INSERT INTO awx_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tiwänä kinggä Josewu using inikut. “Notda using yäniyo. ‘Wilu donggihäne päko peke, Kenande hipdu kunong. ");
INSERT INTO awx_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ku nansä, gihäxät nanä yangu undä ane näle päkapnong. Tiwän Isipde kewu nomän hikngä womdu dama, une yiwitning. Yiwike pahawä, naxu nomängän alaxawä päke näning,’ yang yäniyo.” ");
INSERT INTO awx_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Yänike unetäkänu using tahaningge yäniyo. ‘Engangsä, mängätsä, nansä yang päkapningge, kalbimä bulämbamu Isip nanätäne gwenduyi päke kunong. ");
INSERT INTO awx_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Hängä täpähäle manatäpnong, inale hängä Isip nanä gwälamgwälamu äpme damit,’ yang yäniyo,” yang inikut, kinggän. ");
INSERT INTO awx_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tiwänä Israelde wawaxu using tahakin. Kinggä yakut using, Josepdä notnäle kal bimä bulämbamu gwenduyi yämike, naxu kahitde näninggexät yämikut. ");
INSERT INTO awx_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Unetäkänu täwik käluxu notnäle kwämbätdu kwämbätdu yämikut. Tikengä Bensaminde täwik käluxu 5 äwä moningu 300 silwa yang imikut. ");
INSERT INTO awx_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tike nanäle päku iminingge using pekut: Hängä gwälamgwälamu Isip nanä donggi 10-une päko peke, donggixät inäle pengämikut. Tikengä wit, bret, äwä naxu kahitde näpikge yangu donggi mängälä 10-une päko peke, donggixät inäle pengämikut. ");
INSERT INTO awx_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pengämike notnä yäning yäpiwän kuningge tahaxawä, using yänikut. “Kahit täpäne täkungu, mayanganinong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tiwänä notnä täkwäxu Isip teke, nanä Jekopde Kenan kopgin. ");
INSERT INTO awx_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ko nanä using inikin. “Josewu doxumgut. Ayiwäxak. Tiwän unetäkänu äpmanu Isipde kuhiläle yiwäxak,” yang inikin. Unin yawä, hatnäxäwik, “Hiyäkän yäkaying,” yangu donatäpgut. ");
INSERT INTO awx_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tiwän wamu Josepdä u yänikulu undä inikin. Tiwänä kalbimä bulämbamu Josepdä yämikut gwengwenunin dayike, nanäle bäniwu tangäne yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tikengä using yakut. “Hiyäkände hikngä. Wawaknga Josewu ayiwäxak. Ge pukuke kakengä kupit,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tiwän Israelu hängä täpänä undä päke, yotnä teke kukut. Kuhikangä Berseba kundopgut. Une kundoke, nanäle Anätunäle kälawu sipmäke hawän yähäkukin. ");
INSERT INTO awx_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Tiwän kupiläne Anätutä tahawän, dambu bimä tikut. Tixawän Anätutä “Jekop, Jekop” yang iniwän, Israeldä “We! Nä ane,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Iniwän Anätutä using yakut. “Nä Anätu. Bapukale Anätu, nä unin. Gä Isip kuwiläkge manaxälayo. Isipkätanu nätä äpme pahawa, gäle bapuka sakngälawän, kantri inulung hikngä dakngawän yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Isiwu gäxät pukunimunin. Tikengä hipdu Kenanu päkakopit. Gä Josepkät yiwixäwik kupiyä, itä kwayiwik. Ge Isip kuwiläkge, manaxälayo,” yang inikut, Anätutän. ");
INSERT INTO awx_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Tiwän Jekowu Berseba teke kukut. Wawakngä uläkwäkgä Jekop, mängätnä, engangä yangu kalbimä inulungu kinggä pewän kukinu unggwenggwenkätan päko peke, päke kukin. ");
INSERT INTO awx_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Unetäkänu kälawu äminsak äwa hängä täpänä Kenan päkin yangu undä unuxät pake kukin. ");
INSERT INTO awx_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jekopdä ixät nanä undä päke, Isip kukut. Wawakngä, yäpanä, bapunä wäwi, bapunä mängälä yang unda päke kukut. ");
INSERT INTO awx_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jekopde wawakngä, bapunä yangu Isip kukinu umanä using. Yakap täpä Ruben. ");
INSERT INTO awx_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Tiwänu Rubende wawaxu Hanok, Palu, Hesron, Karmi yang. ");
INSERT INTO awx_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Tiwänu Simeonde wawaxu Jemuel, Jamin, Ohat, Jakin, Sohar Saul yang. Saulde mingä Kenan nanä. ");
INSERT INTO awx_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Tiwänu Livaile wawaxu Gerson, Kohat, Merari yang. ");
INSERT INTO awx_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Tiwänu Judale wawaxu Er, Onan, Sela, Peres, Sera yang. Tiwändeyä Erkät Onankälu Kenan kumgumäläk. Judale wawaxu Peres, uläpäle wawaxu Hesron, Hamul yang. ");
INSERT INTO awx_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Tiwänu Isakarde wawaxu Tola, Pua, Jasup, Simron yang. ");
INSERT INTO awx_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Tiwänu Sebulunde wawaxu Seret, Elon, Jalel yang. ");
INSERT INTO awx_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Jekopde wawaxu uläkwaxu, mängätnä Lea itä Mesopotemia yiwixäwik dukngikut. Yäpanä täpätuxäyä andukngikut. Umanä Daina. Jekopde mängälu Leatä dukngikutkät bapunä uläkwäkälu unekänu 33. ");
INSERT INTO awx_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Tiwänu Gatde wawaxu Sifion, Hagi, Suni, Esbon, Eri, Arodi, Areli yang. ");
INSERT INTO awx_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Tiwänu Aserde wawaxu Imna, Isva, Isvi, Beria yang. Tiwänä haminä Sera. Aserde wawaxu Beria, uläpäle wawaxu Heber, Malkiel yang. ");
INSERT INTO awx_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Gat Aser yangu, Jekopkät Silpaxätde wawak. Silpa uläpä Labandä yäpanä Leale puyä äminäle imikulunin. Jekopkät Silpaxätdä dukngikumäläkät bapunä uläkwäkälu unekänu 16. ");
INSERT INTO awx_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jekopde mängälu Resel ile wawaxu Josep, Bensamin yang. ");
INSERT INTO awx_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josepde mängälu Asenatdä wawakngä Isip dukngikulu Manase, Epraim yang. Asenalu Potipera Onde prisu uläpäle yäpa. ");
INSERT INTO awx_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Tiwänu Bensaminde wawaxu Bela, Beker, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim, Art yang. ");
INSERT INTO awx_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jekopde mängälu Reseldä dukngikutkät bapunä uläkwäkälu unekänu 14. ");
INSERT INTO awx_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Tiwänu Dande wawaxu Husim. ");
INSERT INTO awx_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Tiwänu Naptalile wawaxu Jasel, Guni, Jeser, Silem yang. ");
INSERT INTO awx_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dan, Naptali yangu Jekopkät Bilhaxätde wawak. Bilha uläpä Labandä yäpanä Reselde puyä äminäle imikulunin. Jekopkät Bilhaxätdä dukngikumäläkät bapunä uläkwäkälu unekänu 7. ");
INSERT INTO awx_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Inä Jekopde wawak äwä bapunä yangu Kenan teke Isip kukinu unekänu 66. Wawakngäle mängät täkwäkäyä using kukin, tiwändeyä unuxälu doxendekin. ");
INSERT INTO awx_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tike Josepde wawaxu Isip alakumäläxu uläpäyatkät Jekopde wawak, bapunä Kenan teke Isip kukinu uläkwäkälu unekänu 70. ");
INSERT INTO awx_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Isiwu axundokengu, Jekopdä Josewu Gosen apu dayipikge natäke, Juda gämäk iningyäpiwän, Josepde kukut. Tiwänä Jekop yänggwälu Gosen kundoxawä, ");
INSERT INTO awx_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josepkäyä Gosen kuwikge kalisu inäne gwenu tändäkngake, täko yiwike, nanä Israel kawikge kukut. Ku nanä kake täku betaxäwik, belakngä initikut. ");
INSERT INTO awx_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Tiwänä nanätä Josewu using inikut. “Nina kayitä angganduke, ‘Käluk yiwixaläk,’ yangu anatäxat. Ge äpmanu axupitdekän,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tiwänä Josepdä notnä, nanä, äwä nanäxät nanä yangu using yänikut. “Kingu using ku iniwit. ‘Notna, nana, äwä nanaxät nanä yangu Kenan kewu uwomune yiwixayingu näle aapuying. ");
INSERT INTO awx_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Äminu uläkwäxu sipsip, towiyä gämän yang daying yiwäxayingunin. Ngä sipsipnä, towiyä gämänä, äwä hängä täpänä yangu undä päkapuying,’ yang iniwit. ");
INSERT INTO awx_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ge kinggä yawän kuwä, ‘Ginu ina puyä bimä pahakayingunin?’ yang daniwänu, using ininong. ");
INSERT INTO awx_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘O bulämbam täpänin, ninu tupä bapunindä pahakakin using pahakamängunin. Wawakdäkänetä sipsip, towiyä gämän yang daying yiwixakumängä, using daying yiwäxamäng,’ yang ininong. Using iniwä, kinggä Gosen kewu awomune äpme pewän yiwitning, inale Isip nanä sipsip dayingyiwäxaying äminde mähe natäxayingunin,” yang yänikut, Josepdän. ");
INSERT INTO awx_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Tiwänä Josepdä notnä 5 tuwänguwän, Gosen kep womu teke, kingge kukin. Kuke Josepdä kingu using inikut. “O king, nana, notna yangu sipsipnä, towiyä gämänä, äwä hängä täpänä undä päke, Kenanu aleke apuhika, Gosen kep womune aapuyingä undan yiwayak,” yang inikut. Inikengä notnä uläkwäxu yawän, kingge kayine kopgin. ");
INSERT INTO awx_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tiwän kinggä using yänikut. “Ginu ina puyä bimä pahakayingunin?” yang yänikut. Yäniwän yäkwäle wamu using yakin. “O bulämbam täpänin, ninu tupä bapunindä pahakakin usinggän, sipsip dayingyiwäxamängunin,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Unetäkänu using inikin. “Kenankätanu naxu wenä hikngä tiwän, sipsipdä nänangäsäxäyä wenä tinggäwä, mätekngä womsimu ane yiwitnimde apumäng. Ge gätä täkembä yawi, ninu Gosen yiwitnim?” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","6","Tiwänä kinggä Josewu using inikut. “Isip kewu awomu gätäne. Nangga äwä notda yangu gäle apuying. Tiwän Isipkätanu kewu nomän hikngä Gosendän. Ge une yawi yiwitnong. “Tiwänu notda uläkwäkätanu, iminimindäka kälawu nomängän daying yiwixayingä kakengu, u äminuningän tuwänguyo. Tiwän nätäne itä daying yiwitining,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Tiwänä Josepdä nanä Jekowu kingge kayine initäkapän, Jekopdä kingu wam gwaläng imikut. ");
INSERT INTO awx_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Imän kinggä “Gä krismasda dasingdasing?” yawän, ");
INSERT INTO awx_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","using inikut. “Kewu anggomune tihikuxäwik, krismasna 130 yiwixat. Tiwän u tihikukumu meyä bulak tihikukum. Bapunatä tihikuxäwixu, krismasu meyä ayiwikin. Tike näle krismasu mätekngä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Tikengä wam gwalängu hipdu imixäwixu, aepuxukut. ");
INSERT INTO awx_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Tiwänä kinggä inikut using, Josepdä nanä, notnä yangu Ramses Distrikätanu kewu womduhim yämän, une yiwikin. Isipkätanu Ramses Distrikge kewu nomän hikngä. ");
INSERT INTO awx_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Unetäkänu Josepdä nanä, notnä, nanäxät nanä, äwä engang yangge natäke, naxu ämin apmäng yämixawän, näxäwik yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Isip nanä, Kenan nanä yangu naxu wenä hikngä tinggawän, takgä yiwixäwä, kitokngänä wenä tikin. ");
INSERT INTO awx_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tiwänu moningu Isip nanätäne awä Kenan nanätäne yangu undä hikngä nakge tahaxäwik, Josepde imä päke, kingge yolune päku pekut. ");
INSERT INTO awx_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Isip nanä Kenan nanä yangu moningä undä mumbä pulukgäwä, Isip nanä undätä apu, Josewu using inikin. “Moninginu undä amutna puluying. Tiwändeyä gä inale nindung yiwixawi kumnangge tikamäng? Naxu niming,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Tiwänä Josepdä using yänikut. “Moningsä awulukge tiwänu, kälawu alowikayingunin päkapu namixawä, yäkwäle naxu äpme damit,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Yäniwän sipsip, meme, towiyä gämän, hos, äwä donggi yangu undä päkapu imikin. Tixawän yäkwäle nak yämän näxäwik, yiwixawä krismasu unggwenu apgut. ");
INSERT INTO awx_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Krismasu unggwenu apuxuwän puluwänä, hipdu apu Josewu using inikin. “Bulämbam täpänin, ‘Naxu nimiyo,’ yangu dongganinangäsä teyä, moningninu wenä. Tiwän kälawu äminsakäyä gäle undä anggamikumäng. Ge äpmanu hängä täpätu nakge gaminangäsä wenä. Tike nihäxät kepninkätgän. ");
INSERT INTO awx_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Gä inale nindung yiwixawi kungäxätna, kepninu moyo yiwitnanggenggak? Nihäxät kepninkät päxäwik, naxu nimiyo. Tiwän ninu kingge puyä ämin moyoyi däkngana, itä nihä äwä kepnin yangu towikngä däkngawik. Nak salin nimiyo. Tiwän unin pahana, kewu wäyi doliwik. Tiwän bulä alawä, unin päke nake, doxumnim,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Naxu wenä hikngä tiwän, Isip nanä undä kepnä pewä, Josepdä kewu undä kingge umande uhiwän, kinggä päke, towikngä däkngakut. ");
INSERT INTO awx_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josepdä kepnä uhiwän, äminu Isip nanä undä hikngä kingge puyä ämin moyoyi däkngakin. ");
INSERT INTO awx_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tike prisu moningu kinggä iwikge yämixawän, naxu uhingnäkakin. Ge nakge dondapmäke, kepnä dowewä päkut. ");
INSERT INTO awx_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Tiwänä Josepdä äminu Isip nanä using yänikut. “Äpmanu kingge umande kepsä, gihä yangu auhinggat. Ge nak salinu anin päku, puyäne pahanong. ");
INSERT INTO awx_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Itä bulä alawä päkengu, äupuke 1-u kingge imixäwik, 4 gihäle penong. Tikengu gihäle peningune nanä käwutdu sakngäyile pexäwik, käwutdu gihä, gihäxät nanä, äwä engangsä yang näningge, penong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yäniwän using inikin. “O bulämbam täpänin, ninu axumnangäsä teyä, gätä ilakngä ninduke, gatängnimitäkapunggawi, käluk yiwitnanggekamäng. Ge kingge puyä ämin moyoyile äpme yiwitnim,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tiwän Josepdä mämä wamu using tekut. “Isipkätanu kewu kinggänekän. Ge äminu undä naxu puyäne nanä päkengu, äupuke, 1-u kingge imixäwik, 4 inäle pening.” Mämä wamu uläknga äpmankäyä using yiwäxak. Kinggä äminbamde kewu awäke teyä, prisde kewu dowäkut. ");
INSERT INTO awx_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel yänggwälu Isip päku, Gosen kep womune yiwikin. Une yiwixäwik, kepnä pätäke kuke, engangu dukngixawä, meyä sakngälakut. ");
INSERT INTO awx_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jekowu Isip yiwixawän, krismasu 17 apuxukut. Unekänu krismasnä 147 yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","30","Täpduxu axupikge däpi tiwän, wawakngä Josewu yawän apän, using inikut. “Gätä ilakngä nanduxaläkngä kakengu, näle natäke, gwälam hikngä tahaxäwik, wamu ganiwilu kätakga bakanale kematde täxäwik, ‘Usingu äpme tahawit,’ yangu hiyäkände hikngä naniyo. Nätä kupa, Isipkätanu maxwayinong. Tike nätä kungäke bapunale kuwa, gupna Isipdä täke, bapuna kwayikin womune täku kwayinong,” yang inikut, Josewun. Iniwän “Usingu äpme tahawit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Tiwänä Jekopdä “Anätule umande hiyäkände hikngä naniyo,” yang iniwän, Anätule umande hiyäkände hikngä inikut. Tiwän Israelu däme däpmunä pekgak womune täpu temäke, Anätule eu wam yakut. ");
INSERT INTO awx_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Täpduxu womdu yiwihikangä, ämindä Josewu using inikin. “Nangga amalik,” yang iniwä, Josepdä wawakngä Manase Epraim yang yänipäke, nanäle kukut. ");
INSERT INTO awx_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kuwän “Wawakga gäle aapuk,” yawä, Israelu awekulu, kwätän hikngä tahake, enake yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Tikengä Josewu using inikut. “Nä Kenankätanu taunu Lus unggäpangune yiwixäwa, Anätu Kitokngänä Käyä Täpätä apu, wam gwalängu using namikut. ");
INSERT INTO awx_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘Nätä pahawa, gä engangu naxälä towimbi, meyä sakngälawik. Nätä pahawa, bapuka kantrinä inätä täke yiwitning. Tiwän kewu awomu, bapukale tupäkände äpme yämit,’ yang nanikut,” yang inikut, Josewun. ");
INSERT INTO awx_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Unetäkanu using inikut. “Nä ane gäle doapuxäwa, wawakga Isip alakumäläxu aläpäyalu nina wawak däkngakamäläk. Ruben Simeon yang towikum bimä, Epraim, Manase yangkäyä wawaknga däkgnakamäläk. ");
INSERT INTO awx_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tiwän engangu Epraim, Manase yangge mehene towimbiläxu, gikale. Tiwän näle wawakgä kewu Kenan uwomune päningu, Epraim, Manase yangkäyä awähimäläk. Tike ulapnä ile mehene alatningu payänäle kewune yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Wamu u yänggalu, mingga Reselde natäke yänggat. Kewu Mesopotemia uwom teke, Kenan kewu uwomune taunu Epratde wäkngäsim kuxäwik, Reselu kumgut. Tiwän butayä hikngä natäke, Epratde kahit kwayimune kwayikum,” yang inikut. (Epralu, äpmanu Betlehem yang inikaying.) ");
INSERT INTO awx_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tikengä Israeldä Josepde wawak dayike, “Aläpäyalu imin?” yang iniwän, ");
INSERT INTO awx_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josepdä yäkwäle wamu using inikut. “Aläpäyalu wawaknga Anätutä ane Isip yiwixäwa namikulunin,” yang inikut. Tiwän “Näle päkapso. Tiwän wam gwaläng yämit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israelu äminäläke tiwän, kayi kupilä tiwä, nomänu dondayipgut. Ge Josepdä wawakngä yänipäkapän, Israeldä bapunä päku betake, kis tahangyämikut. ");
INSERT INTO awx_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Betake Josewu using inikut. “Gäle nomu dombänggandupit yang natäxakum deyä, Anätutä pahawän, gikakänu donggandut. Tike wawakgaxät undä dandupa yiwimäng,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tiwäna Josepdä wawakngä Israelde bälängäne wäkngäsim yiwikumäläxu yäniwän, kwayimune päku yiwixawät, Josepdä sopäsopä nanäle nomune puke, däme kepkätan täpu temgut. ");
INSERT INTO awx_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josepde wawaxu uläpäyalu, yakap täpä Manase, tiwän ulapnä Epraim. Ge Josepdä Manase kätakngä dambunä hamändä täke, Epraimu kätakngä hiyänä hamändä täke, Israelde yänipäkapän, Manase Israelde hiyä käwut yiwän, Epraimu Israelde dambu käwut yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tiwändeyä Israeldä kätakngä hiyä hamändä Epraimde kuhilune täke, kätakngä dambu hamändä Manasele kuhilune täkut. Manasetä gämäk alakut deyä, kätakngä hiyä hamändä doläkut. ");
INSERT INTO awx_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Tixäwik wam gwalängu using yämikut. “Bapuna Abraham, nana Aisak yangu Anätule wam täwake, ile gepbine yiwikumäläk. Anätu uläpätä yiwikyiwiknga yiwitäkapulu, iwikge nandung yiwik. ");
INSERT INTO awx_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Meyä näle apginu nä axumnangäsä teyä, itä ängela däkngake gatängamixawän yiwitäkaput. Ge Anätu uläpätä wakwakdäkä aläpäyalu bänip kwikwixu äpme yämik. Ämindä wawakdäkä aläpäyatde uman yakengu, nina, bapuna Abraham, äwä nana Aisak yangge dombulämdäning. Tiwän wawakdäkä aläpäyalu engangu äpme towimbät, meyä sakngälawik, kewu anggomunen,” yang yakut, Jekopdän. ");
INSERT INTO awx_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nanätä kätakngä hiyä hamändä Epraimde kuhit täpän kake, Josepdä “Uhamänu Manasele kuhit tänangäsä tahanggak?” yang natäke, nanäle kätaxu uhamänu Manasele kuhiläne täku tewikge täxäwik, ");
INSERT INTO awx_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","using inikut. “Nan, usingundo. Yakawu aläpänin. Ge kätakga hiyä hamändä ile kuhit täyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tiwänä Jekopdä usingu dolahawikge natäke, using inikut. “Wawaknga, anatät. Ixäyä bapunä äpme meyä sakngälake, kantri inätä täke yiwitning. Tiwän umanä käyä tiwik. Tiwändeyä ulapnäle umanu bulämbam hikngä äpme tiwän, payänäle umanu yapmimbik. Tiwänä ulapnäle bapunä meyä sakngälake, kantrinä inäinä päke yiwitning,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tikengä täpduxu unggwenune Jekopdä wam gwalängu using yämikut. “Mahande Israel nanätä äminu wam gwaläng yäminingge natäkengu, gitde natäpä apän, using yänining. ‘Anätutä gwälam hikngä tupä Epraim, Manase yangge pahakut usingu, gälexäyä usinggän pahayok,’ yang yänining,” yang yänikut, Jekopdän. Wamu u yakulu, ulapnä Epraimde umanu yakapde yiwän, payänä Manasele umanu mahande yiwikut. ");
INSERT INTO awx_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Tiwänä Israeldä Josewu using inikut. “Nä axumnanggenggat. Tiwändeyä Anätu ginkälu äpme yiwixäwik, bapuhäle kewune hipdu danipäke kuwik. ");
INSERT INTO awx_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sekem nanäle kewu nomän hikngä. Tupä kwälemna, gwäwäyäna yang päke, Amor nanäxät amäke, kewu uwom täkumu notdale doyämit, tike gäle gaminggat,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jekopdä wawakngä yangyäwämbän apä, using yänikut. “Wäkngasim apnong. Tiwän mahande dasingga yiwitninggäne danitapit. ");
INSERT INTO awx_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ginu undä Jekopde wawak, ginu undä ane apnong. Nä nansä Israeldä yäwilu, apuke natäxätnong. ");
INSERT INTO awx_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, gä wawaknga yäkap täpä. Näle kitokngä, gätä päkuläk. Wawakdäkäne gä gämäk towikum. Umanda käyä. Kitokngäka käyä. ");
INSERT INTO awx_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tiwändeyä umanda wenä tiwik. Yanggä däkngake matäwä sipmäkayingbimä säkge doyiwixaläxunin. Nanggale mängätkät pekumäläk. Mängätnaxät peke, mayäkngä bulämbam hikngä namikuläk. Ge gä yakap täpäle doyiwiläk. ");
INSERT INTO awx_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeonkät Livaixälu yiwikyiwikngä usäkän. Hängä amäk pahanangäsätäne päke, äminsipmäk tahakamäläxunin. ");
INSERT INTO awx_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Wepdä wam yäxawälu, nä doxuwa yiwitnim. Wam yiwikyäxawälu, donggatängyäma yänim. Inale tokngä natäkengu, ämin sipmäkamäläxunin. Äminde towiyä gämände kendängalu yumdekän sipmändäkngawät tahandambätäkayingunin. ");
INSERT INTO awx_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bäniptoxu yupsäng natäke, tokngä natäxäwik, äminu tokngä däkä yumdekän yämikamäläxunin. U tahakamäläkge tokngä däkä inä pähimäläk. Tiwän bapunä unekänu donggatäke yiwitning. Tike Israelkätanu kewu notnätä päningune täpätu täpätu petäke kuwa yiwitning. ");
INSERT INTO awx_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, notdatä umanda tängetnatning. Iwalda gätäkän sipiläk. Tiwän nanggale wawakgä gäle sopäsopä putning. ");
INSERT INTO awx_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, gä laion bimä. Laiondä kälap ku sipmäke nake, hipdu päkapu pekyiwixawä, ämindä doxu pahangyäwäxayingbimä. ");
INSERT INTO awx_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","King puyä Judatä täpixu ämindä doläning. Inä bapunätä tätäke koxawä, towikngätä apungä puyä uläknga täpik. Täke kantri undä itä daying yiwik. ");
INSERT INTO awx_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Donggi wain puyäne äwamä pewä, wain salinu änäning. Tiwän täwikngäxäyä wain yanggätä ähälutning. Tiwändeyä wainu dowuluwik. ");
INSERT INTO awx_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ämindä wain tängokgäwä, kayi wain bimä dak tining. Kälawu äminsakge mämu ämindä päke tängokgäwä, mayä mämbimä kwak hikngä tining. ");
INSERT INTO awx_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulunu yanggä gwende kwayimune yiwik. Kewu uwomu nomän tiwän, sipdä päkapu yiwitningge nomän. Kewu Sebulundä täpixu täkungu taun Saidonde kewune yiwik. ");
INSERT INTO awx_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakalu donggi kitokngä gwendu bimä. Tiwändeyä meyä käwukäwut wamängämä, moyo päke pek yiwik. ");
INSERT INTO awx_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Isakalu kewu äyiwä täkaningge womdu kawän nomän hikngä tiwänu, moyo yiwän täkäning. Tike äminde puyä ämin moyoyi däkngake, meyä päpikge gwetakengu, puyä kitokngä hikngä pahawik. ");
INSERT INTO awx_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Danu äminä nomän daying yiwik. Israel notnätä daying yiwixaying using daying yiwik. ");
INSERT INTO awx_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Danu gomok bimä. Gomokgä kahitäpäne kohopike yiwixawä, äminu hos tängäne apä, hosde bäläng yähawä, hosdä hätnawä, äminu hos tängäne yiwixayingunin päkepu sipmäkaying using tahawik. ");
INSERT INTO awx_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yawe, gätä gatängamiläkge yiwixat. ");
INSERT INTO awx_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gatde yolu kukanananggä apu pahawä malining. Tiwändeyä Gatdä mähexätandä apu sipik. ");
INSERT INTO awx_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aserde kewune naxu nomän alätning. Tiwän naxu gwälam hikngä kingge yämik. ");
INSERT INTO awx_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptali meme tukgä inä natäk tihikuxäwik, engangä gwälam hikngä dukngikaying using tahawik. ");
INSERT INTO awx_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josewu nawu täkngatu bimä. Yanggä akondokayingune doke, salinä meyä hikngä aläxawä, kätakngä täpmäxäwik, dämän täpä täpä kopik. ");
INSERT INTO awx_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kwalemdä amäkaying ämindä tokngä natäke kwälemdä temningge pahakin. ");
INSERT INTO awx_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tiwändeyä Josewu kwälemnä päkulu, kätakngä doyamumbä, nomängän mukut, inale Jekopde Anätu kitokngänä käyä uläpätä gatängämikut. Anätu uläpä Israel daying yiwixak täpänin. Anätu uläpä Israelde hup. ");
INSERT INTO awx_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Bapukale Anätutä gatänggaminggaxunin. Anätu Kitokngänä Käyä Täpätä bänip kwikwik gaminggaxunin. U gamikgä pahawän, hopä enetängätä kepdane epning. U gamikgä pahawän, yanggä amälankätandä kepdane akopning. U gamikgä pahawän, mängälä gin yänggwätkätan nanä engangu meyä dukngitning. ");
INSERT INTO awx_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Wam gwalängu bapunatä näle namikinu, gäle gamitdä ayapmik. Wam gwalängu meyä hikngä anggaminggatdä täwalde nomu ayapmik. Wam gwalängu anggaminggalu gätä päpiläk. Notda täkwäkätanu äminu bulämbam däkngakuläkgä päpiläk. ");
INSERT INTO awx_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bensaminu homu tuxu kitokngäna käyä gwendu bimä. Kälawu tembänä ku sipmäke nänggaxunin. Ge kupiläne notnäle uhike yäminggaxunin,” yang yakut, Jekopdän. ");
INSERT INTO awx_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Wamu uläkwäxu Israelde wawaxu 12 uläkwäkge bapunä mahande dasingga yiwitninggäne yänikulunin. ‘Using yiwitning’ yangu u yänikulu, wawakngäle yiwikyiwikngä dayipän tixawä yänikut ");
INSERT INTO awx_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Wawakngä mahande dasingga yiwitninggäne yänikengä, Jekopdä wawakngä puyä wamu täkngatu using yänikut. “Nä axungwäke notna axumgin aminde kuwitde däpi alik. Ge axupa, gupna Kenan täke kunong. Täku hupgänangu bapuna, nana yang pekindäkäne tenong. Hupgänangu undäkä Makpelaxätan, Epron Hit nanä uläpäle kewune. Makpelaxät Mamrexälu wäkngäsim wäkngäsim. Hupgänangu undäkä kepkät Abrahamdä Epronde kätaxune mätmätde uhikut. ");
INSERT INTO awx_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham, mängätnä Sara yangu undäkäne pekin. Tiwän Aisak, mängätnä Rebeka yangkäyä unekän pekin. Ge Leatä kupäntäyä une tekum. ");
INSERT INTO awx_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kewu uwomkät, hupgänangu undäkäxälu Abrahamdä Hit nanäle kätaxune auhikut. Ge ninaxäyä axupa, gupna aläku, hupgänangu undäkänekän tenong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Puyä wamu wawakngä yänipulukengä, Jekowu bälängä awekgaxune päko peke kungäke, bapunä tupä kumginde kukut. ");
INSERT INTO awx_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nanatä kupän, Josewu butayä hikngä natäke, nanä betake initixäwik, kis tahangämikut. ");
INSERT INTO awx_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Tikengä “Gupnä bukatayäk,” yake, puyä äminä doktale yiwixaying täkwäxu yäniwän, nanäle guwu mäläsin pexäwik, täwikgä täpä kopgut. ");
INSERT INTO awx_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Puyä uläknga tahananggengu, täpduxu 40 tahakakin. Ge Israelde guwu using pahaxawä, täpduxu 40 apuxukut. Tixawän Isip nanä ile butayä natäke, kwänäm tixawä, täpduxu 70 apuxukut. ");
INSERT INTO awx_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Butayä täkngane yiwikinu puluwänä, Josepdä kingge puyä äminu umanä käyä täkwäxu using yänikut. “Näle täke natäkengu, kingu using ininong. ");
INSERT INTO awx_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Josewu nanatä using inikut. “Wamu uyäwilu, Anätule umande ‘Usingu äpme tahawit,’ yang naniyo,” inike “Nä axupitde däpi alinggak. Ge nätä kupa, mätmälu Kenen kep womune ninale kwayikum däkäne täku teyo,” yang iniwän, “Usingu äpme tahawit” yangu Anätule umande inikut. Ge täkembä tewi, nanä Kenan täko tekengä, hipdu apik?’ yang ininong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yäniwän king ku iniwä, Josepde wam natäke, kinggä using yakut. “Täke. Nanggatä yawän Anätule umande inikuläk using täko teyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tiwänä Josewu nanä kwayiwikge kopgut. Tiwän kingge puyä äminu umanä käyä kingge yolune pahakaying, puyä äminu umanä käyä Isipkätan pahakaying awä ");
INSERT INTO awx_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Josepkät nanä, payänä, ulapnä, nanäxät nanä yangu undä kopgin. Tixawän Gosenu engangä, sipsipnä, towiyä gämänä yanggäkän yiwikin. ");
INSERT INTO awx_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tixawän amäk äminu hos tängäne päko yiwike kukaying ämin, äwä karis bimälängäne päko yiwike kukaying ämin yangkäyä using kopgin. Äminu u kopginu meyä hikngä. ");
INSERT INTO awx_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Axuhika Atat nanätä witde dapäkdapäkngä uhinggikaying womune kundopgin. Atalu Yanggä Jodan Dupine wäkngäsim. Uwomune kundokengu, butayä hikngä natäke, kwänämu bulämbam gwen tikin. Tixäwik Josepdä nanäle natäke, butayä täkngane yiwixawän, täpduxu 7 apuxukut. ");
INSERT INTO awx_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Butayä täkngane yiwixawä dayike, Kenan nanä uwomune yiwixayinggä using yakin. “Isip nanä butayä hikngä natäxaying,” yang yakin. Ile tiwän, kewu Yanggä Jodan Dupine wäkngäsimu uwomu, umanä ‘Abel Misraim,’ yang inikaying. ");
INSERT INTO awx_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jekopde wawaxu inä yänikut using tahakin. ");
INSERT INTO awx_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nanäle guwu Kenan kewune täko, hupgänangu Makpela nanä däkäne tekin. Makpelaxät Mamrexälu wäkngasim wäkngasim. Hupgängangu undäkäxät kewu uwomkälu Abrahamdä mätmätnäle, Efron Hit nanä uläpäle kätaxune uhikut. ");
INSERT INTO awx_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Nanä kwayikengä Josep, notnä äwä äminu ixät kopgin yangu undä hipdu Isip kukin. ");
INSERT INTO awx_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nanä kwayikengä, Josepde päyänä täkwäxu using yakin. “Nanu alikut. Ge wäyi täkgnaläknga Josepde pahakumängge, yäkwäle Josepdä tokngä natäke, tokngä däkä nimiyäk,” yang yakin. ");
INSERT INTO awx_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Yake wamu Josepde using tewä kukut. “Nangga axupikge däpi tixawänu, using ninikut. ");
INSERT INTO awx_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Josewu using ininong. “Wäyi täkngaläknga payäkatä gäle pahake tokngä däkä gamikindeyä, gutongänä pahawi hopinong,” yang ininong,’ yang ninikut. Ninu nanggale Anätule gepbine yiwixamäng. Ge wäyininu täkembä pahawi hopining?” yang yawä ku inikin. Iniwä Josewu wamu uläknganin natäke, kwänämnä tikut. ");
INSERT INTO awx_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tiwänä payänä undä täkwäkgä täkapu, Josepde kayine pimake, “Ninu gäle puyä ämin moyoyi,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Iniwä using yänikut. “Manaxälatnong. Nä Anätundo, ngä nätä tokngä däkä damit. ");
INSERT INTO awx_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Gindä näle wäyi pahaningge natäpgin. Tiwändeyä Anätutä wäyi u pahakinunin täpän täkwämbän, nomän tik. Äminu meyä axumnangäsä teyä, Anätutä anggatängyämän, käluk yiwixaying. ");
INSERT INTO awx_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ge manaxälatnong. Gihäxät engangsäxälu äpme dandung yiwit,” yang yänikut, bänip kwikwik wamun. ");
INSERT INTO awx_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josewu notnä täkwäkät Isip yiwikin. Tixäwik Josewu krismasnä 110 tikut. ");
INSERT INTO awx_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Äyiwixawängän wawakngä Epraimde bapunä alawä, wawakngä Manasele wawaxu Makirde engangkäyä alawä, Josepdä inäle päkut. ");
INSERT INTO awx_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Tiwänä Josepdä notnä using yänikut. “Täpduxu axupitde däpi alik. Tiwändeyä Anätu änggatängdamikge äpme apik. Itä apungu, ginu kewu awomunetä, kewu Abraham, Aisak äwä Jekop yangge yämikge kitokngä hikngä yänikut womune danipäke kopik,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yake using yänikut. “Wamu daniwilu, ‘Usingu äpme tahanim’ yangu Anätule umande naninong. Anatutä änggatängdamikge apänu, gupna kewu awomunetä ähikngä täke kopnong,” yawän, “Usingu äpme tahanim,” yangu Anätule umande inikin. ");
INSERT INTO awx_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josewu krismasu 110 yiwike kumgut. Tiwänä gupnä mäläsin peke, bokskätan tekin.");
INSERT INTO awx_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Tupä Israel nanä kingu wenäne, Israel äminde kepkätanu gusit tiwän, naxu wenä tikut. Tiwän Juda nanä täpätu Betelehem yiwixakulu, mängätnä, wawakngä täpäyat yang päpän, Israelu teke, womsimu kantri Moap päku yiwitningge kukin. ");
INSERT INTO awx_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Wäwi uläpä umanä Elimelek, tiwän mängätnä Naomi, tiwän wawakngä uläpäyatde umanu Malon, Kilion yang. Uyänggwälu Efralunetä sakngälakin. Tiwänu taunä Betlehemu uwomu Judaxätan. Uwomu aleke päku Moap yiwikin. ");
INSERT INTO awx_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Päku yiwihika, Elimelexu aweke kungäxawän, Naomi wawakngä täpäyatkät inäkän yiwihika, ");
INSERT INTO awx_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","wawakngä mängätnä Moap nanä päkumäläk. Umanä Opa, Rut, yang. Moap päku, krismasu 10 yiwike, ");
INSERT INTO awx_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","wawakngä Malon Kilion yangkäyä undä kumgumäläk. Ayä wawakngä uläpäyat yangu undä teke kumgin, Naomin. ");
INSERT INTO awx_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Womsimu Moap yiwixawän, “Yawetä äminämbamu apu gatängyämike, naxu wuyäne nanä yäminggak,” yawä natäpgut. Tikengä Moap teke ayinä täpäyatkät hipdu kuningge tändäkngakin. ");
INSERT INTO awx_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Tike ayiwixakut womu teke, hipdu Juda kep womune kuningge kahit täpäne kukin. ");
INSERT INTO awx_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Täku kahitbäna ayinä yänikut, “Hipdu mingsä yot gihänggihä kukahon. Gitdä näxät, axumgin äminkätde tahakumäläk bimä täknga, Yawetä gitde gwälam hikngä pahayok. ");
INSERT INTO awx_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Yawetä gatängdamän, apsä päke, ile yolune gupsäng yiwison,” yake, kis pahangyämän, kwänämnä duksäng tikumäläk. ");
INSERT INTO awx_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Tixäwik, “Undanä. Nilu notdambamde gäxät kunim,” yang inikumäläk. ");
INSERT INTO awx_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Tiwän “Ayina hikngä, kukahon, yotsäle. Inale kunim, näxälun? ‘Wawakngä äpmembä dukngiwän itä pähimäläk,’ yang natäxamäläk?” yang yänikut Naomitän. ");
INSERT INTO awx_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","“Ayina hikngä, yotsä hipdu kukahon, inale nä äminäläke alit. Ge apna tänangäsändo. Nina natäpa wawak dukngitnangäsä tiwän, kupilä anggwenunekän apna täke, wawaknga dukngiwa, ");
INSERT INTO awx_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","gilu ile yiwixawät täkahimäläk? Bä wäwi täpätuyi dayikengu, apsäle doxuhimäläk? Ayina hikngä, undana. Meyä gitdä pämäläxu nätä pätdä ayapmik, inale Yawetä nä maha temängamikut,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Unin yäniwän, hipdu duksäng hikngä tikumäläk. Tike Opa hawanä kis tahangämike, yotnäle kukut. Tiwändeyä Rulu Naomixät gatäke kuhimäläkge natäpgut. ");
INSERT INTO awx_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Tiwän, Naomitä inikut. “Kayo. Notda mängälu notnämbamkät anätunäxätde hipdu axunggak. Gäxäyä kuwi kukahon,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Tiwändeyä Rutdä using inikut. “Anggapmambitde mananing yäpike, hipduna kuwitde mananing yäpiyo. Säneka kuwi, näxäyä axuwit. Säneka yiwi, näxäyä une yiwit. Gäle notdambamu näle notna. Gäle Anätuka näle Anätuna. ");
INSERT INTO awx_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Säneka kupi, näxäyä une kupa kwayining. Nilu kungäkgäkänä matäwik. Tike hängä täpätutä matäwänu, Yawetä meyä bulämbam hikngä namikge natäxat,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Tiwän Naomitä kawänu, Rulu ixät kuhimäläkge kitokakut. Tiwän axuwikge ining yäpikulu undan tekut. ");
INSERT INTO awx_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Tiwänä unetä kuhika, ku Betlehem kundopgumäläk. Kundopät Betlehem nanä undätä duksang kulakaxäwik, mängälatä “Naomimbä an?” yang yakin. ");
INSERT INTO awx_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Yawä “Naomi yangu mananinong. Mara yang naninong, inale Anätu Kitokngänä Käyä Täpätä yiwikyiwiknga alahawän wäyi hikngä tikut,” yang yänikut, Naomitän. ");
INSERT INTO awx_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Tikengä hipdu using yänikut. “Anetä teke kukumu, hängäna meyä. Tiwändeyä Yawetä hipdu moyo hikngä nanitäkapuk. Ge Naomi yangu inale nanining? Yawetä nä alahawän malit. Kitokngänä Käyä Täpätä meyä anamik,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Wamu uläknga Naomitä Moap kep teke, ayinä Rulu Moap nanä täpäxät hipdu kukumäläkgäne. Täpduxu uwomkätanu sänggum bimä bali yang yänikayingu moyokän matäxawä, Betlehemu kundopgumäläk. ");
INSERT INTO awx_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomile ayä Elimelekät nanä täpätu hängänämbamgän tiwän umanä käyä. Uläpä umanä Boas. ");
INSERT INTO awx_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Rut Moap nanä täpätä Naomi inikut. “Tewi wuyäne kuwa, imindäka ilakngä nandupänu, ile mehene kuxäwik, bali salinu itä matäxawän epningu butuwit,” yawän, “Ayina hikngä, kuyo,” yang inikut, Naomitän. ");
INSERT INTO awx_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tiwän Rulu axu, nak matäkakin äminde mehene yäwaxäwik, bali itä matäxawä epginu, bututäke kukut. Puyä ulängä kukulu, Boas Elimelekät nanä uläpätäne yangu äpmeyä katapgut. ");
INSERT INTO awx_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Awahaxawä, inä unggwenunekän Boasu Betlehemdä apu, nak matäkakin äminu “Yawexälu gikät,” yang yäniwän, yäkwäle “Yawetä pahawän nomändän yiwiläk,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Tiwänä Boasdä nak matäkin ämindäne kuhiläle tuwängukut täpä inikut. “Mängälämätexu aläpä imindäne?” yawän, ");
INSERT INTO awx_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","yäkwäle using inikut. “Uläpä Moap nanä, Moapdä Naomixät apgumäläxunin. ");
INSERT INTO awx_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Tembänä apu ‘Täkembä tewi nak matäkaying äminde mehene yäwaxäwik, bali awamäxawä däpäkngä epningu butuwit?’ yang nanike, bututäkapuk. Tiwändeyä gepmäne matekngä wesim yiwän täkaying,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Tiwänä Boasdä Rut inikut. “Kätak natäxayo. Bali wuyä awomu maleke ku, täpätuyitäne tängälängäne mambutuyo. Mängälämätexu wuyä alängäne pahakayinggä kuxawä kuxäwik butuyo. ");
INSERT INTO awx_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Wäwi säneka matäwayak yangu kätak dayixäwik, mängälämätexu ixät pahakayingu mehene yäwayo. Puyä ämina, ‘Malahawä maliyok,’ yangu kitokngä ayänit. Yanggäkalembä tiwä, axu itä uhike peningunin tangopso,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Tiwänä Rutdä sopäsopä puke, kuhilä kewune täpu temäke inikut, Boasun. “Nä malä nanä. Tiwändeyä ilakngä inale nanduxaläk? Näle inale natäxaläk?” yawänä, ");
INSERT INTO awx_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boasdä inikut. “Nä anatäpgum, apdatä kungaxawän, hawakale dasingga tahatäkapunggaläxun. Mingga, nangga, yotda yang peke, äminu tupä dondayixakuläkge apguläkge nä änatäpgum. ");
INSERT INTO awx_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ge u tahakuläkge yäkwäle, Yawetä gamiyok. Yawe Israel nanäle Anätuninu anggandung yiwikge apguläk täpätä hängäläpä meyä gamiyok,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Yawän, “Bulambam täpäna, gä näle ilakngäkänu usinggän nandupiläkge natäxat. Mängälämätexu gäle wuyäne pahakayingu umanä käyä, tiwän nä umana wenä. Geyä wam gwälangu gätä naniläkgä, meyä nätä pälu anggatängaminggak,” yang inikut, Rutdän. ");
INSERT INTO awx_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nak nänangäsä täpduk tiwän, Boasdä Rut inikut. “Ane apu, brelu päke, yanggä kaxalä täkngane pewi kaxalawä, nänggä,” yang inikut. Yawän, Rulu täkapu, bali matäkaying ämindä yiwikinune puku yiwikut. Tiwänä Boasdä sänggumde notnä puhäk hakinu imikut. Imän napän täke tiwän, naxu käwutdu ayiwikin. ");
INSERT INTO awx_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Anake, bali butuwikge enaxawänä, Boasdä wuyä äminä kitokngä yänikut. “Bali awamäpeningunembä päpän kakexäyä, mainiwä mayäkayok. ");
INSERT INTO awx_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Tike awamäpeningune nanä notnäxäyä aluliwä akopä pengäminong, tiwän butuwik. Tiwänu maininggämätanong,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ge ambutuxawän tukawän, bali u butukulu täku sipmäng yäwambän bulätäkän epä kawänu, meyänä 13 kilo bimä tikut. ");
INSERT INTO awx_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Tiwän bali päke, taun täku, dasingdasingga päkulu hawanä iniwän kakut. Tiwän anapän täke tiwän yiwikinkät sike imikut. ");
INSERT INTO awx_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Imän kake, “Äpmanu säne butuläk? Iminde wuyäne päläk? Äminu uläpä gandutewän päläxu, Yawetä pahawän nomändän yiwiyok,” yang inikut, Naomitän. Iniwän Rutdä, inikut, iminde wuyäneka pahakulun. “Puyä ulängä pätdäne towikngä umanä Boas,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Iniwän, “Boasu Yawetä pahawän nomändän yiwiyok. Yawetä axumgin äminkät käluk yiwixaying äminkätde gwälam hikngä pahanggaxu dolexak,” yake using inikut. “Wäwi uläpä apnitde notnä hikngä. Ge notnäle natäke nindung yiwitnangäsä täpätu,” yang inikut, Naomitän. ");
INSERT INTO awx_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Iniwän, Rut Moap nanä uläpätä inikut. “Täkngatuxayä using nanik. ‘Puyä äminaxät unekän gatäke kuxäwik butuyo. Tixawän sänggum bimä undä matäwä puluwik,’ yang nanik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Tiwän Naomitä Rut inikut. “Ayina hikngä, mängälämätexu Boasde wuyäne pahakayingkät kuningu täke. Inale äminu täpätule wuyäne ku päxawi, tahawä maliyä,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ge mängälämätexu Boasde wuyäne pahakakinkät gatäxäwik, bali pänggäwä puluwän, witkäyä pänggäwä pulukut. Unggwenggwenkätanu Rulu hawanäxät yiwikumäläk. ");
INSERT INTO awx_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Täpduxu gwendune hawanätä Rut inikut. “Ayina hikngä, nätä wäwi täpätu kake gama, itä mängätnäle täpän, yotsäne gupsäng yiwisimäläk. ");
INSERT INTO awx_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Boasde natäpso. Mängälämätexu ile wuyä pahaxawä ku butukuläxu uläpä apnitkät nanä. Äpmanu tukwatde bali sipmäng yäwäxawä bulätä epukaying womune däpäkdäpäkngä uhinggiwik. ");
INSERT INTO awx_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ge yanggäka häluke, hängä käpängänä käyä gupdane pahake, täwikga käluk pahake, uwomune kuyo. Tike nak yanggä yangu donapuluxawänu, alänggämänu maxuwi gandupsok. ");
INSERT INTO awx_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Awäku pewänu, une hikngä pekgak yangu kätak kayo. Ge awexawänä, ku täwixu aomipewixu, nomnä bälängä omimbik däkähimgän tängenake, bäläng kwayimnäne peyo. Tiwänu itä dasingga tahawiläkge äpme ganiwik,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Iniwän Rutdä inikut. “U yänggaläk usingu äpme undä pahawit,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Tikengä Rulu bali sipmäng yäwäxawä bulätä epukakin womune ku, hawanätä dasingga inikulu, undä täwake pahakut. ");
INSERT INTO awx_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boasu nakngäxät yanggänäxät napän, täke hikngä tinggawän, bänipgwälang natäke, bali pekinde kwayimune päku pekut. Pexawän, Rulu wepdäkän ku, täwixu bälängä pänguhikulu, nomnä däkähimu tängenake, bäläng kwayimnäne pekut. ");
INSERT INTO awx_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ge Boasdä kepdamände, dasingga tike enake, täpän täkwämbänu, mängälä täpätu bäläng kwayimnäne pekgawän kakut. ");
INSERT INTO awx_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Kake, “Gä imin?” yawänä, Rutdä, “O bulämbam täpäna, nä Rut. Gä apnale notnä. Ge mängätdale täyo,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Iniwän, “Yawele pahawän nomändän yiwiläk. Ge gwälam hikngä täknga äpmasim tahanggaläkgä, tupä hawakale tahakuläxu ayapmik. Wäwimätexu hängänämbamgänbä bä hängänä wenämbä unin ku apdale päpi yiwixätnangäsä teyä usingu dolahaläk,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","“Manatänatäliyo. Äminbamu taun yiwixayingu undä anatäxaying, gä mängälä nomän täpä yangun. Ge wamu u yaläxu undä äpme tawake pahawit. ");
INSERT INTO awx_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Hiyäkän. Nä apdale notnä. Tiwändeyä apdale notnä hikngä täpätu undan. Tike nä atumaha bimä. ");
INSERT INTO awx_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Kupiläne ane yiwiyo. Ge gwäsiyä katapnim. Dasingga, notnäle natäkengu, äpmembä mängätnäle täke gandung yiwik. Using tahawixu täke. Tike wenä tiwänu, Yawele umande yänggat. Nätä äpme täke gandung yiwit. Ge une pekgayo. Tixawän gwäsi tiwik,” yang inikut, Boasdän. ");
INSERT INTO awx_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Tiwänä bäläng kwayimnäne pexawän, axwakawikge tixawän, “Ämindä nandupnäng” yake enakut, inale “Mängälä täpätu bali sipmäng yäwäxawä bulätä epukaying womune kuk,” yang natäpnäng yakut, Boasdän. ");
INSERT INTO awx_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Tikengu unetäkän using inikut. “Kwäman täwikga täpi dopän täpi wäsiwän,” yang iniwän, using tahawän, 25 kilo bali wälikngämike, täko gwäpikngämike, hipdunä taunde kukut. ");
INSERT INTO awx_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Tixawän Rulu hawanäle kuwän, using inikut. “Ayina hikngä, kuwi dasing tahak?” yang iniwän, Boasdä ile dasingga pahakulu Rutdä undä inikut. ");
INSERT INTO awx_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Inike, unetäkänu using inikut. “‘Hawakale moyo hikngä maxuyo,’ yake bali 25 kilo namik,” yawänä, ");
INSERT INTO awx_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomitä inikut. “Ayina hikngä, wepdä yiwixayo. Tixawän dasingga tiwixu, äpme yawä natäpiläk. Inale wamu uläknga yawän nomätawikge, äpmanu Boasu doyiwän täkänanggekaying.” ");
INSERT INTO awx_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Tixawän Boasu taunde yämä däkäne, wamu inulung wopwom yiwik yäkakin womune päku, une puku yiwikut. Yiwixawänu, Elimelekge notnä Boasdä natäke yakut täpä une apgut. Apän, Boasdä inikut. “Notna, ane päkapu puku yiwit,” yawän, päku puku yiwikut. ");
INSERT INTO awx_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Tiwänä Boasdä kuhiläle taun yiwixakinu 10 using päke yawän, unuxäyä unekän päku puku yiwä, ");
INSERT INTO awx_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","itä notnä uläpä inikut. “Naomi hipdu Moapdä apgut täpätä kewu notnit Elimelekgäne moningge tek. ");
INSERT INTO awx_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ge ayäwa natäpiläkge natät. Ge gä notnitde natäke, ile kep kang yiwiläkge uhiwiläkge natäkengu, äminu ane puku yiwiyingu aläkwäk äwä notnambamde kuhiläle yiwixayingu aläkwäk yangge kayine uhing. Tike mehe natäkengu, nomän naniyo, tiwän natäpit. Inale, äminu täpätuyitä uhinangäsändo. Tike gäkän. Tiwänä nä unetä ätumaha bimä,” yawän, äminu uläpäta, “Näta äpme uhiwit,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Tiwänä Boasdä yakut. “Täke hikgnä. Gä kewu Naomile kätaxune uhikengu, usinggän Rut Moap nanä kombälu uläpäxäyä aläpiläk. Ge axumgut äminde hängäläpä umanä täknga yangu using ayiwitning,” yawänä, ");
INSERT INTO awx_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","notnä uläpätä yakut. “Using kakengu, nä uhinangäsändo, inale moningu engangale yäminangäsä, moyo mumba kunäng. Ge gika uhing. Douhiwit,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Täpduxu unggwenggwenkätanu Israel nanä hängä täpätu äminde yanguhiningge natäkengu, äminu täpätutä bäläng yayikngä utdoke, äminu auhiwikge natäxakut täpäle imikakut, wamu uläknga yawä nomätänanggengun. ");
INSERT INTO awx_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ge notnä uläpätä Boasu, “Gika uhing,” yang inikengu, bäläng yayikngä utdoke imikut. ");
INSERT INTO awx_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Tiwänä Boasdä kuhiläle yiwixakinu uläkwäk äwä äminu undä une yiwikin yangu using yänikut. “Ginu äpmanu ananduxawä, Elimelekät wawakngä Malon awä Kilion yangge hängäläpä undä hikngä Naomile kätaxune uhinggat. ");
INSERT INTO awx_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Unetäkän daniwilu, Rut Moap nanä Malonde kombälu uläpä nätä mängätnale tänggat, axumgut täpäle hängäläpä awä umanä täknga yangu usinggän yiwitningge. Ge bapunä gwende uman täknga itä teng yiwixäwik, Malonde notnäle uman yakengu, ile dombulämdäning, taunäxätanun. Ge ginu äpmanu ananduxawä uhinggat,” yang yanikut. ");
INSERT INTO awx_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Yawän, kuhiläle yiwixakin awä äminu undä yämä däkäne yiwikin yanggä yakin. “Hiyäkän, ninu angganduxätna uhinggalak. Yawetä mängätda yotdane kopixu uläpä tahawän, Reselkät Leaxätdä Jekopde engangu meyä dukngikumäläk bimä tiyok. Ge gä Efratkätanu hängäka meyä tiyok. Tixawän Betlehemkätanu umanda täknga yatäke kopnong. ");
INSERT INTO awx_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Yawetä engangu mängälä uläpäle imän dukngikgamixu, inä tahawän gin yänggwälu Juda Tema yangge wawaxu Peres yänggwät tikut bimä tike, umansä käyä tiyok,” yang inikin. ");
INSERT INTO awx_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Tiwänä Boasdä Rulu yotnäne täke kuwän, mängätnä däkngawän, yiwikumäläk. Tiwän Yawetä kitokngä imän, tängäne käyä tiwän, engangu wäwi täpätu dukngikut. ");
INSERT INTO awx_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Dukngiwän mängälätä Naomi inikin. “Yawele uman tängenatnim. Itä äpmanu anggandung yiwitnangäsä täpätu anggamik. Äpme Israelkätanu wawakdäkä uläpäle uman täknga yatäke kopnong. ");
INSERT INTO awx_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Tiwän itäyä yiwikyiwikga pahawän käluk tiwä, äminu täke tixawi, itä äpme gandung yiwik, inale ayikatä wawakga 7 itä tahanangäsä bimä täknga ayapmike, gäle butayä natäke, dukngikgaminggak,” yawä ");
INSERT INTO awx_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomitä engang käpä betäxäwik, kang yiwikut. ");
INSERT INTO awx_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Tiwän mängälä inalängän yiwixakindä umanä Obet yang inike, “Engangu wäwi uläpä Naomile dukngikngämik,” yang yakin, ämimbamun. Tiwänä Obelu Jesile nanä, tiwän Jesi Dewitde nanä. ");
INSERT INTO awx_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Peresde wawaxunetä sakngälatäke ku King Dewilune kukulu using. Peresde wawaxu Hesron. ");
INSERT INTO awx_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Tiwän Hesronde wawaxu Ram. Tiwän Ramde wawaxu Aminadap. ");
INSERT INTO awx_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Tiwän Aminadapde wawaxu Nason. Tiwän Nasonde wawaxu Salmon. ");
INSERT INTO awx_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Tiwän Salmonde wawaxu Boas. Tiwän Boasde wawaxu Obet. ");
INSERT INTO awx_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Tiwän Obetde wawaxu Jesi. Tiwän Jesile wawaxu Dewit.");
INSERT INTO awx_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Yawetä Jona Amitaile wawaxu using inikut. ");
INSERT INTO awx_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Gä Niniwe, taunu inulung hikngä unggäpangune kuyo. Ku duksäng yäninggämätayo. Inale nä andayit, itä gutongä hikngä yiwik maliyingun,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Tiwändeyä Jona Yawele wam hapduke, Tasisde datäkuwikge kukut. Yawe teke datäkuwikge, Jopa puku, siwu gwendu Tasisde kuwikge tahanggawän kake, moningu uhike, unggwenune koke, Tasisde kukut. ");
INSERT INTO awx_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Tiwändeyä sip gwenu axuxawän, kwämanu Yawetä tewän, yanggä gwenune inulung hikngä apuxawän, yanggä gwenkäyä naxälä täku temgut. Tinggäwän sip uputnangäsä tikut. ");
INSERT INTO awx_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Tiwän sipde wuyä äminu anaxälake, anätunäle inäinä tumuxu anggatängyäminingge yaxäwik, “Asing pahana, sip gwenu kwängä äpmembä tiwik?” yake, hängäläpä une pekinu päxäwik, yanggäxätan mumbä wukukin. Meyä uläknga apgulu, Jona siwu gälämnä gwenkätan täpu däpmunä pekbulämdaxawän apgut. ");
INSERT INTO awx_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Tixawän sipde kuhiläle yiwixak käpätä puku kake, “Meyä täknga apuxawän, gä inale pekgaläk? Enake, anätukale tumuxu yang. Tiwän itä butayä äpmembä ninduke nipmambän yiwitnim,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Tixawän sipde wuyä ämindä inäkän yakin. “Umaninu yamäke bekätan kekngälutnim. Tikengu iminde umanda täkengu ile meyäle apunggak yänim,” yake, using tahake, Jonale uman täkin. ");
INSERT INTO awx_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Tikengä Jona inikin. “Nining. Meyä ninde apunggaxu aläknga, iminde meyäle tiwän apunggak? Gä ina wuyä pahanggaläxunin? Tiwän säne nanä? Gä kantri sanggäpangune nanä? Gä äminu saläkwäkät nanä?” yang inikin. ");
INSERT INTO awx_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Iniwäyä, Jonatä using yänikut. “Nä Hibru uläkwäkät nanä. Nä sopäsopä Yawe Anätu yekäwune nanä, kep, yanggä gwen yang pahakut täpäle pukgalunin,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yakapkäyä Jonatä “Yawe teke datängapunggat,” yangu ayawän natäpginde, naxäla hikngä natäke, “Usingu inale tahaläk?” yang inikin. ");
INSERT INTO awx_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Yanggä gwenu hipdu aläku temgulu yapmike, meyämeyäkän täku temänggäwän, “Gäle dasing tahana, yanggä alinggaxu kupitang yiwik?” yang inikin. ");
INSERT INTO awx_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Iniwä yäkwäle Jonatä using yänikut. “Ginu näle wäyile tiwän, kwämanu inulungu aläkngatä apu pahawän malikaying. Ge nä yanggä gwenkätan täke mumbä pukuwa, ulinggaxu wenä äpme tiwik,” yang yänikut. ");
INSERT INTO awx_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Tiwän wuyä äminu, “Sipgwenu ämbä tahana, kwayimune kuwik?” yake, yanggä duksäng hikngä kwayikin. Tiwändeyä yanggä gwenu yakap täku temgulu ayapmike, duksäng hikngä täku temänggawän, tahawä täke dolikut. ");
INSERT INTO awx_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Tinggawän Yawele tumuk wamu using yakin. “Äminu aläpätä kupänu, manihipi kumnom. ‘Itä äminu nomän tängukaying,’ yangu manatängnimiyo, inale gä o Yawe, gika natäke pahaläk,” yake, ");
INSERT INTO awx_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Jona täke yanggä gwenkätan mumbä pukukut. Tiwän yanggä gwenu duksäng hikngä täku temgulu wepdä kupitang yiwikut. ");
INSERT INTO awx_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","U tahawän kake, wamu kitokngä yakin using, sipde wuyä äminu Yawele naxäla hikngä natäke, hikawu tänguke, ofale hawä ihikuxawän, tumuxu inikin. ");
INSERT INTO awx_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Jonä yanggä gwenkätan täke mumbä pukuwänu, Yawetä natäpän, pisu inulungu gwendutä apu Jona guläpäkut. Tiwän undan yiwixawän, täpduxu gwenalä gwendu apuxukin. ");
INSERT INTO awx_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jona pisde bänipkätan yiwixäwik, tumuk wamu Anätunä Yawele ");
INSERT INTO awx_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","using yakut. “Yawe, nä anaxälake yanggäwämba, nätä natäke yakumu gätä pahakuläk. Ämusing hikngä axumgin ämindä yiwixayingkätandä, tumuk wamu anggatängamiläkge yäwa, näle tumuxu anatäpguläk. ");
INSERT INTO awx_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Gätä mumbi, nä yanggä ämalan hikngä, yanggä bänipkätan epgum. Tiwän yanggätä täpän kopa, gäle yanggätä täku temäke pänguhikut. ");
INSERT INTO awx_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Tiwän using natäpgum. ‘Gätä gika nomdanetä anawaläk. Tiwändeyä gika takwän yotda hipdu axawit.’ ");
INSERT INTO awx_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Yanggätä täpän kopgum, tiwän pälä päkakopa hakin. Yanggä gäpmayi hikngä gwendä tängäna täpä undä hikngä täpän kopa, songäsongä yanggäne nanätä kuhitna gwenu wamgin. ");
INSERT INTO awx_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Nä täwan kemat hikngä aepgum. Kepdä yämä iwikiwik yiwitde alepän kuhingamikut. Tiwändeyä, Yawe Anätunatä gapmayinetä käluk täkako tewi yiwikum. ");
INSERT INTO awx_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nina natäpa, käluk yiwitnangäsä täknga wenä tinangge tiwän, Yawe, nä gäle natäke, tumuxu yäwa, yot takwändanetä anatäpguläk. ");
INSERT INTO awx_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Hängä kitokngänä wenä ämindäkän kwätäluke tumuxu ile tahakaying äminu uläkwäxu, gwälam hikngä gätä pahangyäminggaläxu maha yämikaying. ");
INSERT INTO awx_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Tiwändeyä nä kawu gäle tayixäwik, gäle uman täknga yatängenaxäwik, hikawu gäle tänguke häwa ihikuwik. Wamu kitokngä u yakumu undä pahawit. Axumnangäsä tiwändeyä, Yawetäkän käluxu nipmambän yiwixamängunin,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Tiwänä Yawetä pis gwenu iniwän, täku yanggä kwayimune watutekut, Jonan. ");
INSERT INTO awx_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Tiwänä Yawetä Jona hipdu using inikut. ");
INSERT INTO awx_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Gä Niniwe taunu inulung hikngä unggäpangune ku, wamu nätä ganinggalu yänitapso,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Tiwän Jona Yawele wam täwake, Niniwe kukut. Taunu unggäpangu inulung hikngä, ge axu wuyä une pahananggengu, täpduxu gwenalä gwendu pahanangäsä. ");
INSERT INTO awx_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ge täpduxu yakap gwenu, Jona taunu unggäpangune kopgut. Ko tihikuxäwik, using yänikut. “Täpduxu 40 apuxuwänu, Niniwe Yawetä alahawän maliwik,” yawän ");
INSERT INTO awx_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","natäke, Niniwe nanä Anätule wamde bänip tike, “Naxu dohikngä nake takgä yiwitnim,” yakin. Yake äminu undä, umanä käyä äwä umanä wenä yangu meyä natäke, täwixu meyä täkngatäne palapalangänä käyä däkändäkä pahakin. ");
INSERT INTO awx_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Niniwele kingu wamu uläknganin natäke, meyä päke, sia yiwixakut däkä teke epuke, täwixu belakngä kinggäne utdopeke, täwixu meyä täkngatäne palapalangänä käyä pahake, mulup däkäxätan puku yiwikut. ");
INSERT INTO awx_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Tikengä mämä wamu Niniwe nanäle kitokngä täknga yatewän kukut. Using yakut. “Wamu aläknga nä kuhitsäle yiwixatkät, wuyä äminaxätdä using yäkamäng. Ämin äwä hikawu ämindä daying yiwixaying, inulung matekngä yang undä hängä täpätu manapä tiyok. Nak, yanggä yangu mahikngä nanong. ");
INSERT INTO awx_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Ämin, hikawu ämindä towikaying yangu undä täwixu meyä täkngatäne palapalangänä käyä pahanong. Pahake äminbamu undä tumuk wamu Anätulekän kitokngä yänong. Yaxäwik wäyi hikngä täkngaläknga äwä äminsipmäk täknga yangu awenong. ");
INSERT INTO awx_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Tiwän dasingga, Anätu ninde tokngä hikngä natäxu äpmembä teke, bäniyä täpän täkwämbän ‘Asipit,’ yang natäk täknga teke donihipik?” yang wamu using tewän epuxukut. ");
INSERT INTO awx_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Tiwän unin pahake wäyi hikngä täkngaläknga pahakakinu Anätutä awekinä dayipgut. Dayike, awahawän maliningge yakulu, bäniyä täpän täkwämbän, dowahawän malikin. ");
INSERT INTO awx_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Anätutä Niniwe nanä dowahawän maliwä, “Asipnangäsä pewän yiwixaying?” yake, Jona tokngä hikngä natäpän, bäniyä däkitä bimä ihikut. ");
INSERT INTO awx_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Tokngä natäke, Yawele tumuk yakut. “Yawe, yotna yiwixäwixu, ‘Axu yäwa baniyä päpä täkwämbä dosipiläxunin,’ yangu dongganikum? Ile tiwän yakawu, Tasisde datäkuwitde tahakum. Nä anatäpgum, gä Anätu butayä ämin. Tokngä yupsängu donatäke, gwälam hikngä pahangyäminggaläxunin. Natändetdetda awäpi täkwämbä, dowahawi malikayingunin, yangun. ");
INSERT INTO awx_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ge, Yawe, tewi kungänggäwa. Na käluk yiwitde donatät. Axupitde natäxat,” yang inikut. ");
INSERT INTO awx_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Iniwän Yawetä inikut. “Gä tokngä inale natäxaläk?” yang inikut. ");
INSERT INTO awx_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Tiwän Jona yot gäpangu teke, gusitdä akonggak käwut päku gepmänä tahake, puku yiwixäwik, “Niniwe dasingga tiwän kawit?” yake kang yiwikut. ");
INSERT INTO awx_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Tiwän Anätu Yawetä “Jona gusitdä ihiyäk,” yake, nawu kwämbätduhimu Jonale gepma imikge natäpän alakut. Tiwän Jona nawu uxwambatde täke hikngä natäpgut. ");
INSERT INTO awx_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Geyä kwepdätä gwäsi hikngä Anätutä natäpän, nawu uxwämbälu gomokgomokgä matäwän kumgut. ");
INSERT INTO awx_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ge gusitdä akoxawänu, Anätutä wawuwawungu tokngä hikngä täknga gusitdä akonggakätandä natäpän apgut. Tiwänä gusitdä Jona kuhiläne ihinggäwän tahandambätakut. Axupikge natäke, “Nä käluk yiwitde donatät. Axupitde natäxat,” yang yakut. ");
INSERT INTO awx_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Tiwänä Anätutä inikut. “Nawu uxwämbätde tokngä inale natäxaläk?” yawänä, Jonatä yäkwäle using inikut. “Na tokngä täke natäxat. Tokngä hikngä natäke, axupitde natäxat,” yawänä, ");
INSERT INTO awx_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Yawetä inikut. “Nawu axwämbälu kwepdän alakutnä, äpmanu gwäsi kungäk. Gätä doxwayikuläk. Tike uxwämbätde gä wuyä täkngatu dowahakuläk, tiwändeya gä butayä ile natäxaläk. ");
INSERT INTO awx_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Äminu Niniwe nanä, hängä nomän bä gutongä yangu donatäxaying äminu 120,000 ayapmikut. Tiwän hikawu ämindä daying yiwixayingkäyä meyä hikngä. Dasingge tiwän taunu inulungu unggäpangge butayä donatäpit?” yang inikut, Anätutän.");
ALTER TABLE awx_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
