﻿USE sofia;
DROP TABLE IF EXISTS sofia.awk_vpl;
CREATE TABLE awk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES awk_vpl WRITE;
INSERT INTO awk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","WONTO ba kauwȧllo mankulla unnoa tara túġunbilliko ġurránto ġéen kinba, ");
INSERT INTO awk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yanti bo ġearun kin bara ġukulla, unnoa tara nakillikan kurri-kurri kabiruġ ġatun mankillikan wiyellikanne koba. ");
INSERT INTO awk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Murrȧrȧġ tia kȧtan yantibo, koito baġ ba tuiġ ko ġirouġ, Teopolo murrȧrȧġ ta, ");
INSERT INTO awk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ġurra-uwil koa bi tuloa, unnoa tara wiyatoara banuġ ba. ");
INSERT INTO awk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yanti-kȧlai ta Herod noa kakulla, Piriwȧl noa kakulla Iudaia ka, kakulla noa tarai hiereu Dhakaria yitirra, Abia-u̇mba konara: ġatun nukuġ ġikoúmba yinálkun koba Aaron-úmba, ġiakai bountoa yitirra Elidhabet. ");
INSERT INTO awk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Buloara bula kakulla murrȧrȧġ Eloi kin, mikan ta ġurraiyelléu̇n bula Yehóa-ko noa ba wiyellikanne yarakai ma korien. ");
INSERT INTO awk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Keawaran bula wonnai korien kulla, bountoa Elidhabet ġurrauwai; ġatun bula ba ġurróġbai kakulla. ");
INSERT INTO awk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ġatun yakita kakulla, umulliela noa ba Eloi kin makan ta, yirruġ ka ġikouġ kin hiereu koba, ");
INSERT INTO awk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yanti kiloa hiereu koba uman, yirruġ ka ġikoúmba ta upulliko bon porapora koiyuġ ko uwá noa ba nao koba Yehóa kai koba. ");
INSERT INTO awk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ġatun yanti bo yantinto konara ku̇ri wiyelliela warai ta yakita winelliela ba porapora. ");
INSERT INTO awk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ġatun paipéa noa aġelo Yehóa-úmba ġikouġ kin, ġarokilliela noa túġkaġkirri ka koiyuġ kón ta porapora ka. ");
INSERT INTO awk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ġatun nakulla bon noa ba Dhakaria ko, unma bon noa ba, kinta ġaiya noa ba kakulla. ");
INSERT INTO awk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wonto ba aġelo wiya noa, Kinta kora bi kauwa, Dhakaria; kulla ġurra ta wiyellikanne ġiroúmba, ġatun nukuġ ko ġiroúmba ko wonnai kȧnu̇n ġiroúmba, ġatun wiyȧnu̇n bi ġiakai yitirra Ioanne. ");
INSERT INTO awk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ġatun pitȧl bi kȧnu̇n, pitȧl kauwȧlkan kȧnu̇n pórkullinu̇n ġikouġ kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kauwȧl wal noa kȧnu̇n, mikan ta Yehóa kin, ġatun keawai wal noa wain pitȧnu̇n, keawai tarere, ġatun warakaġ wal noa witellinu̇n Marai yirriyirri kan biruġ ko, waraka biruġ tunkán ta biruġ. ");
INSERT INTO awk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ġatun noa wiyȧnu̇n wal barun kauwȧl-kauwȧl wonnai Ithȧrael-úmba Yehóa-kin ko Eloi ta barúnba. ");
INSERT INTO awk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ġatun wal noa uwȧnu̇n ġikouġ kin mikan ta kaiyu ka Marai ta Elia-uúmba, warbuġgulliko bu̇lbúl biyuġbai tara koba wonnai kolaġ, ġatun barun kinko tuloa kako; uma-uwil koa barun ku̇ri kurrikurri Yehóa kinko. ");
INSERT INTO awk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ġatun noa Dhakariako wiya bon aġelonuġ, Yakoai kan baġ ġurrȧnu̇n unni? kulla baġ ġurroġbai, ġatun nukuġ emmoúmba ġurróġ ġéen. ");
INSERT INTO awk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ġatun noa aġeloto wiya bon, Ġatoa Gabriel, ġakillin Eloi kin mikan ta; ġatun yuka tia wiyelliko ġirouġ, ġatun túġunbilliko ġali tara ko pitȧlmullikanne ko. ");
INSERT INTO awk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A! ġurrulla bi, ġóġ ko wal bi kȧnu̇n, ġatun kaiyu korien wal bi kȧnu̇n wiyelli ta, yaki-kȧlai tako purreȧġ kako unni tara kȧnún ba, kulla bi ba ġurra korien wiyellikanne emmoúmba, kabo kȧnu̇n wal unni tara. ");
INSERT INTO awk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ġatun bara ku̇ri ko mittia Dhakarianuġ, ġatun kotelliela minnuġ-bulliela noa tunkéa noa nao ka. ");
INSERT INTO awk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ġatun noa ba paikulléún warrai ta, kaiyu korien noa wiyelli ko barun; ġatun bara ġurra Marai noa nakulla nao ba; kulla noa wauwȧl-wauwȧl umá barun ġatun, ġarokilliela noa ġóġ ko. ");
INSERT INTO awk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ġatun kirun kabulla purreȧġ ġikoúmba umullikanne, waita ġaiya noa uwá kokerá ko ġikouġ ka tako. ");
INSERT INTO awk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ġatun yukita purreȧġ ka Elidhabet ġikoúmba nukuġ warakȧġ bountoa, ġatun yuropulléu̇n bountoa warán yellenna ka, wiyelliela bountoa, ");
INSERT INTO awk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yanti noa tia Yehóako umá nakulla noa tia ba purreȧġ ka, mankilliko barun ba béelmulli tin ku̇ri tin. ");
INSERT INTO awk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tarai-ta yellenna ka hek ka, Gabriel ta aġelo ta puntimai ta wiyabunbia bon Eloi kinbiruġ uwolliko, purrai kolaġ, Galilaia koba, ġiakai Nadharet, ");
INSERT INTO awk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mirrȧl lako wiyatoara ko, ku̇ri kako Yothep kinko yitirra ko, wonnai taro noa Dabidúmba; ġatun mirrȧl ġiakai yitirra Mari. ");
INSERT INTO awk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ġatun noa aġelo uwa bounnoun kin, ġatun wiyelliela, A! murrȧrȧġ umatoara bi Yehóa kȧtan ġirouġ katoa ba; murrȧrȧġ umatoara bi nukuġ ka. ");
INSERT INTO awk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ġatun bountoa ba nakulla bon, kinta bountoa kakulla wiyellita ġikouġ kin, ġatun kotelliela bountoa minariġ unni totóġ kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ġatun aġeloko wiya bounnoun, Kinta kora bi, Mari: kulla bin pitȧlmatoara Eloito noa. ");
INSERT INTO awk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A, ġurralia bi, warakáġ bi kȧnu̇n, wonnai kan ġirouġ kin pika ka, ġatun yinal pórkullinu̇n, ġatun bi ġiakai yitirra IETHU. ");
INSERT INTO awk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ġatun wal noa kauwȧl kȧnu̇n, ġatun wal bon wiyȧnu̇n ġia kai Yinal ta wokka ka ko; ġatun noa Yehóako Eloito gúnu̇n wa bon yellawollikanne biyuġbai koba Dabidúmba ġikoúmba: ");
INSERT INTO awk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ġatun noa wiyȧnu̇n wal yanti-katai barun Yakobúmba; ġatun ġikoúmba piriwȧlkanne keawai wal kȧnu̇n wirán. ");
INSERT INTO awk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wiya ġaiya bountoa bon aġelonuġ Mariko, Yakoai ke unni kȧnu̇n, kulla baġ ku̇ri korien? ");
INSERT INTO awk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ġatun noa aġeloko wiya bounnoun, Tanan wal noa uwȧnu̇n Maraikan murrȧrȧġkan ġirouġ kinko, ġatun kaiyuko wokka tinto wutinu̇n wal ġirouġ, koito ba unnoa ta murrȧrȧġ pórkullinu̇n ġirouġ kin; wiyȧnu̇n ġiakai yinal ta Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A, ġurralia, ġiroúmba wuġgunbai Elidhabet, warakaġ bountoa yinal ġurroġéen koba bounnoun ba; ġatun unni ta yellenna hek ta bounnoun-kai-kan wiyatoara ġurra-uwai. ");
INSERT INTO awk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kulla ġurakito ke noa Eloito kaiyukanto ke. ");
INSERT INTO awk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ġatun bountoa Mariko wiya, Kauwá yanti kámúnbilla tia wiya bi ba; ġatoa mankillikan Yehóa-u̇mba. Ġatun noa aġelo púntirkulléu̇n bounnoun kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ġatun bountoa Mari buġkulléu̇n unti-tara purreȧġ ka, ġatun uwa bountoa karakai bulkȧra kolaġ, kokerá ko Yuda kako; ");
INSERT INTO awk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ġatun bountoa uwa kokera ko Dhakaria-úmba kako, ġatun búġbúġ ka bounnoun Elidhabetnuġ. ");
INSERT INTO awk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ġatun yakita ġaiya ġurrá bountoa ba Elidhabetto pulli Mariúmba, tulutilléu̇n ġaiya wonnai bounnoun kin pika ka; ġatun warapál bounnoun ba Elidhabet kin Maraikanto murrȧrȧġko: ");
INSERT INTO awk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ġatun bountoa wiyelléu̇n pulli wokka wiyelliela, murrȧrȧġ umatoara bi nukuġ ba; ġatun murrȧrȧġ umatoara peil ġiroúmba pika koba. ");
INSERT INTO awk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ġatun minariġ tin tia unni, tanan uwa tunkan piriwȧl koba emmoúmba? ");
INSERT INTO awk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kullȧ baġ ba ġurrá pulli ġiroúmba ġurréuġ ka emmouġ kin, wonnai ġaiya tia tulutilléu̇n emmouġ kin pika ka pitȧl ko. ");
INSERT INTO awk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ġatun murrȧrȧġ umatoara bountoa ġurrá; kulla unnoa tara kȧnu̇n umatoara, wiyatoara bounnoun kin Yehóa kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ġatun Mariko bountoa wiya, “Maraito emmoúmba ko wiyan murrai bon Yehóanuġ, ");
INSERT INTO awk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ġatun maraito emmoúmba ko pitȧl umulléu̇n Eloi kin Miroma emmoúmba. ");
INSERT INTO awk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kulla noa nakulla mirrȧl bountoa ba umullikan ġikoúmba; A, unti biruġ yantinto tia wiyȧnu̇n murrȧrȧġ upatoara. ");
INSERT INTO awk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kulla noa tia kaiyukanto unnoa tara kauwȧl uma; ġatun yitirroa ġikoúmba murrȧrȧġ upatoara kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ġatun murrai ġikoúmba barun kinba kintakan bon kȧtan willuġġél ku̇ri kabiruġ tarai ku̇ri kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Túġunbilléu̇n noa kaiyukan turruġ ġikoúmba; wupéa noa barun ġaruġ ġara yaroyaro búlbúl ban kotellikanne. ");
INSERT INTO awk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Upéa noa barán parrán kaiyukan yellawolliġél labiruġ barúnba, ġatun wupéa noa barun mirrȧl wokka laġ. ");
INSERT INTO awk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ġukulla noa kapirrikan ko mu̇rrȧrȧġ ta, ġatun noa barun parólkan yuka mirrȧl ko. ");
INSERT INTO awk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Umulléu̇n noa ġikoúmba umullikan Ithȧraelnuġ, ġurrulli biruġ ġikouġ kinbiruġ murrai ta ġikoúmba; ");
INSERT INTO awk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yanti wiya noa ba barun biyuġbai to ġearúnba, Abȧramnuġ, ġatun barun wonnai tara ġikoúmba yanti katai.” ");
INSERT INTO awk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ġatun Mari bountoa kakulla bounnoun katoa ġoro ka yellenna ka, ġatun willuġ ba ġaiya bountoa bounnoun ka tako kokera ko. ");
INSERT INTO awk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yakita ġaiya Elidhabetúmba kakulla wonnai pórkullinu̇n; ġatun yinal bounnoun ba pórkulléu̇n. ");
INSERT INTO awk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ġatun ġurra bara kótita ko bounnoun bako, yanti Yehóako noa ba murrȧrȧġ umá bounnoun kin; ġatun bara pitȧl kakulla ġatun bountoa ");
INSERT INTO awk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ġatun yakita ġaiya purreȧġ ka, uwa ġaiya bara kullabulliko wonnai ko; ġatun bara wiya bon ġiakai Dhakaria, biyuġbai tin yitirra tin ");
INSERT INTO awk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ġatun tunkanto wiya bountoa, Yanoa; kulla bon wiyȧnu̇n ġiakai Ioanne. ");
INSERT INTO awk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ġatun bara bounnoun wiya, Keawaran ġiroúmba kótita wiya ba ġiakai unni yitirra ");
INSERT INTO awk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gatun bara túġa umulléu̇n bon biyuġbai ko ġikoúmba ko, wonnén noa bon yitirra wiyȧnu̇n? ");
INSERT INTO awk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ġatun noa wiya upulliġél ko, ġatun noa upa wiyelliela, Yitirra noa ġiakai Ioanne. Ġatun bara yantinto kota. ");
INSERT INTO awk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ġatun tanoa-kȧl-bo kurraka buġkulléu̇n ġikoúmba, ġatun bon ġikoúmba tállȧġ balbal kakulla, ġatun noa wiya, ġatun noa wiya murrai Eloinuġ. ");
INSERT INTO awk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ġatun bara kinta kakulla yantin ta untakȧl; ġatun unni tara wiyellikanne totóġ kakulla yantin ta kaloġ koa bulkaroa Yuda ka. ");
INSERT INTO awk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ġatun bara yantinto unnoa tara ġurra wúnkulla barun kin búlbúl la, wiyelliela, Yakoai unni ta wonnai kȧnu̇n! Ġatun mȧttȧra Yehóa-úmba ġikouġ kin kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ġatun noa Dhakaria ko biyuġbai ġikoúmba, warapal bon wupéa Marai to yirriyirri to, ġatun noa wiyelliela ġiakai, ");
INSERT INTO awk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kȧmu̇nbilla bon Yehóanuġ Eloinuġ Ithȧrael koba pitȧlliko; kulla noa uwa barun nakilliko, ġatun wirrilliko kúri ko ġikouġ kaiko. ");
INSERT INTO awk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ġatun bouġbuġġa noa nulka-nulka ġolomullikan ġearun, kokerá Dabid-úmba ka ġikoúmba mankillikan; ");
INSERT INTO awk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yanti noa ba wiya kurraka ko propet koba ko yirriyirrikan to yantin to, purrai yantin kurrikurri kabiruġ: ");
INSERT INTO awk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ġoloma-uwil koa ġearun ġearúnba bukka tukulla biru̇ġ, ġatun mȧttȧra biruġ barun kinbiruġ yantin tabiruġ yarakai willuġ kabiruġ, ");
INSERT INTO awk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Umulliko murrai ko wiyatoara barun kin biyuġbai ko ġearúnba, ġatun ġurrulliko ġikoúmba wiyatoara yirriyirri ta; ");
INSERT INTO awk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Pirral-man noa ġali wiyelliela bon Abȧramnuġ biyuġbai ġearúnba, ");
INSERT INTO awk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ġúwil koa ġearun noa, mankilliko ġearun mȧttȧra biruġ bukkakan tabiruġ ġearúnba, ġurra-uwil koa ġéen bon kinta korien ko, ");
INSERT INTO awk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yirriyirrikan ġatun murrȧrȧġkan mikan ta ġikouġ kin, yantin ta purreȧġ ka moron ġearúnba. ");
INSERT INTO awk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ġatun ġintoa, wonnai ta, wiyȧnu̇n bin yitirra propet ta wokka kako; kulla bi uwȧnu̇n ġanka mikan ta Yehóa kin, upulliko yapuġ ko ġikoúmba; ");
INSERT INTO awk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ġukilliko ġurrulliko moron ko ġikouġ kaiko ku̇ri ko, warewarekan yarakai barúnba, ");
INSERT INTO awk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Murrai tin kanwollin Eloi koba tin ġearúnba, ġurrakan wokka kabiruġ tanan uwa ġearun kinko, ");
INSERT INTO awk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ġukilliko purreȧġ barun ko yellawolli ta ba ko ġoroġorȧ ba ko, ġatun komirra kaba tetti koba, yutilliko tinna ko ġearúnba ko yapuġ koa pitȧl koba koa.” ");
INSERT INTO awk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ġatun wonnai poaikulléu̇n, ġatun ġuraki noa maraikan ko, kulla noa koruġ koa yakita ko purreȧġ kako paipéa noa ba Ithȧrael kinko. ");
INSERT INTO awk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","YAKITA purreȧġ ka, wiya noa Kaithariko Augútoko, upa-uwil koa barayantin ku̇ri murrapulliko. ");
INSERT INTO awk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ġatun unni murrapullikanne una yakita Kurinio noa ba kobȧna kakulla Thuria ka. ");
INSERT INTO awk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ġatun yantin bara uwa murrapulliko barun ka tako. ");
INSERT INTO awk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ġatun noa Yothep uwa wokka-laġ Ġalilaia kabiruġ, kokerá biruġ Nadharet tabiruġ, Iudaia kolaġ, kokera kolaġ Dabidúmba kolaġ, ġiakai yitirra Bethlehem; (kulla noa kokerá koba ġatun kotita koba Dabidúmba;) ");
INSERT INTO awk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Murrapulliko bon ġatun Mari bounnoun katoa, wiyatoara nukuġ ġikoúmba, wonnai kan bountoa warakaġ. ");
INSERT INTO awk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ġatun yakita kakulla, kakulla bara ba unta, purreȧġ ka kȧtan pórkulli koa bountoa ba wonnai. ");
INSERT INTO awk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ġatun bountoa pórbuġgulléún kurri-kurri yinal, ġatun bountoa muġgama bon kirikin to, ġatun bon wúnkulla takilliġélla buttikaġ koba ka; kulla wal tantullan kokera takilliġél. ");
INSERT INTO awk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ġatun bara éipu-kȧl untoa kakulléún, tumimillin wirrȧl barun ba tokoi ta ");
INSERT INTO awk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ġatun noa aġelo Yehóa-úmba tanan uwa barun kin, ġatun kullaburra Yehóa-úmba kakulla barun katoa; kinta ġaiya bara kakulla. ");
INSERT INTO awk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ġatun noa aġeloko wiya barun, Kinta kora; kulla nurun baġ wiyan murrȧrȧġ totóġ kakilliko pitȧl ko, kakilliko yantin ko ku̇ri ko. ");
INSERT INTO awk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kulla nurúnba pórkulléu̇n unni purreȧġ, kokerá Dabidúmba ka, Ġolomullikan ta, noa Kritht ta Piriwȧl ta. ");
INSERT INTO awk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ġatun unni túġa kȧnu̇n nurúnba; nanu̇n boboġnuġ ġamatoara kirikin taba, kakillin ba takilliġél laba ");
INSERT INTO awk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ġatun tanoa kal bo paipéa konara morokokȧl ġikouġ katoa aġelo katoa, murrȧrȧġ wiyellin bon Eloinuġ, ġiakai, ");
INSERT INTO awk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Wiyabunbilla bon murrȧrȧġ Eloinuġ wokka kaba moroko kaba, ġatun kȧmu̇nbilla pitȧl purrai tako, murrȧrȧġ umatoara barun ku̇ri ko. ");
INSERT INTO awk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ġatun kakulla ba, waita uwa bara ba, aġelo barun kinbiruġ moroko kolaġ, wiyellan bara éipu-kȧl taraikan-taraikan, Waita ġéen yakita Bethlehem kolaġ, na-uwil koa unnuġ tara kakulla ba, ġala Yehóako noa wiya ġéarun ");
INSERT INTO awk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ġatun bara uwa kurrakai, ġatun nakulla Marinuġ, ġatun boboġ pirikilliela takilliġél laba. ");
INSERT INTO awk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ġatun nakulla bara ba, wiyabu̇nbéa bara yantin ta purrai ta unnoa wiyellikanne wiyatoara barun wonnai tin. ");
INSERT INTO awk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ġatun bara yantinto ġurra, kotelliela unnuġ tara, wiya barun bara éipu-kȧl-lo. ");
INSERT INTO awk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wonto ba bountoa Mariko miromá unni tara, ġatun kota bountoa minki ka búlbúl-la bounnoun kin. ");
INSERT INTO awk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ġatun bara éipu-kȧl willuġ ba kakulla, murrȧrȧġ wiyellin ġatun pitȧlmullin bon Eloinuġ ġala biruġ natoara biruġ ġurratoara biruġ bara yantita wiyatoara ba barun kai. ");
INSERT INTO awk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ġatun purreȧġ ét ta kakulla ba, kullintiela ko túġa-witia wonnai, ġiakai bon wiya Iéthu, ġala ba wiya noa aġeloko kurrikurri noa ba pika ka kakulla kunto ka. ");
INSERT INTO awk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ġatun purreȧġ ka ġoloin ta killibinbin bounnoun ba, yanti Mothé-ko noa ba wiya, mankulla bara bon Hierothalem kolaġ, ġukilliko bon Yehóa kin; ");
INSERT INTO awk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Yanti wupa ba wiyellikanne ta Yehóa-úmba ġiakai, Yantin ku̇ri tara ġanka-ġanka pika kabiruġ yirri-yirri wal kȧnu̇n yitirroa Yehóa koba;) ");
INSERT INTO awk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ġatun ġukilliko ġutoara, ġala wupa ba wiyellikanne taba Yehóa-úmba, ġiakai, Buloara purrouġkan ġa keawai wuroġ buloara poppolameri. ");
INSERT INTO awk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A! ġatun kakulla noa tarai ku̇ri Hierothalem kaba, ġiakai noa yitirra Thimeon; ġatun unnoa ku̇ri wiyellikan tuloakan, ġatun ġurrullikan, mittillin pitȧl ko Ithȧrael-úmba ko; ġatun Marai yirri-yirri-kan kakulla ġikouġ kin. ");
INSERT INTO awk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ġatun bon wiyatoara Maraito yirri-yirri-kan-to, keawai noa nanu̇n tettibullikanne, na-uwil koa noa Krithtnuġ Yehóa-úmba. ");
INSERT INTO awk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ġatun noa uwa Marai toa hieron kako: ġatun bula ba porikullaito puruma wonnai Iethu kin, umulliko bon yanti ko upatoara ko wiyellikanne tako, ");
INSERT INTO awk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mankulla ġaiya bon noa ġikouġ kin turruġ ka, ġatun pitȧlma noa bon Eloinuġ, ġatun wiyelliela, ");
INSERT INTO awk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Wamu̇nbilla bi tia Yehóa yakita pitȧlkan, yanti wiya bi ba: ");
INSERT INTO awk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kulla baġ nakulla ġaikuġ ko ġolomullikan ġiroúmba, ");
INSERT INTO awk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ġali ko kakilliko ġintoa yantin ko kúri ko mikan tako; ");
INSERT INTO awk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kaibuġ kakilliko barun ethȧnékal ko, ġatun pitȧl kakilliko ku̇ri ko Ithȧrael ġiroúmba ko.” ");
INSERT INTO awk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ġatun bula Yothep ġatun Mari kotelliela unnoa wiyatoara ġikouġ kai. ");
INSERT INTO awk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ġatun Thimeon ta noa pitȧlma barun, ġatun wiyelliela Marinuġ tunkan ġikoúmba, “A! kȧtan noa unni wonnai kakilliko puntimulliko, ġatun bouġkulliko kauwȧl-kauwȧl barúnba Ithȧrael koba; ġatun túġa ko wiyéa kȧnu̇n; ");
INSERT INTO awk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(Kauwa, yirrako bin turȧnu̇n wal marai ġiroúmba kóti,) paipi-uwil koa kotatoara búlbúl labiruġ kauwȧl-kauwȧl labiruġ.” ");
INSERT INTO awk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ġatun kakulla wakȧl Anna, propetkun, yinálkun Panuel koba, konara koba Ather koba; bountoa ta ġurroġéen ġaġkakȧlin, ġatun kakulla bountoa poribai ta wunȧl la hepta ta, murrakin tabiruġ bountoa katalla; ");
INSERT INTO awk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ġatun bountoa maboġun kukulla wunȧl la éty-warra yantikalai tabiruġ, waita uwa korien bountoa hieron kabiruġ, wonto ba ġurrulliela Eloinuġ bon purreȧġ ka ġatun tokoi ta ta-korien. ");
INSERT INTO awk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ġatun bountoa uwolliela tanoa-kal-bo, wiyapaiyéȧn bon Yehóanuġ, ġatun wiyelliela yantin barun ġikouġ kin barun, nakillikan ġupaiyiko Hierothalem kako. ");
INSERT INTO awk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ġatun upá bara ba unni tara yanti wiyatoara Yehóa koba, willuġbo ġaiya bara kakulla Galilaia kako, barun ka tako kóti kako Nadharet tako. ");
INSERT INTO awk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ġatun wonnai poaikulléu̇n ġuraki noa maraikan kȧtan; ġatun pitȧlmatoara bon Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Waita uwa bula ġikoúmba tunkan ġatun biyuġbai Hierothalem kolaġ yanti-katai wunál la takilliġél lako kaiwitoara wokka koa. ");
INSERT INTO awk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ġatun noa ba wunȧl la dodeka ka, waita ġaiya uwa bara Hierothalem kolaġ wirikai ko takilli ko. ");
INSERT INTO awk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ġatun kirun kakulla purréȧġ, willuġbo bara ba, wonnai Iéthu noa minka willuġ ka Hierothalem ka; ġatun noa Yothepko ġatun tunkanto ġurra korien bula. ");
INSERT INTO awk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wonto bara ba punta bon barun kin konara, uwa purreȧġ ka wakȧl la; ġatun bara bon tiwa kóti ta ka. ");
INSERT INTO awk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ġatun bara na korien bon ba, willuġbo ġaiya bara katéakún Hierothalem kolaġ tiwolliko bon. ");
INSERT INTO awk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ġatun purreȧġ ka ġoro kulla, nakulla ġaiya bara bon murruġ ka hieron ka, yellawolliela willi ka barun kin didathkaloi ka, ġurrulliela barun wiyelliela barun wiyellikanne pulli. ");
INSERT INTO awk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ġatun yantinto bara bon ba, ġurra, kotelliela bara bon ġuraki ġatun wiyatoara ġikoúmba. ");
INSERT INTO awk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ġatun nakulla bara bon ba, unma ġaiya barun; ġatun tunkanto ġikoúmba-ko wiya bon, Nai, minariġ tin bi kakulla ġearun kai? a! biyuġ ta uwa bali, tiwolliela bali bin, minki-kan-to. ");
INSERT INTO awk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ġatun noa wiya barun, Minariġ tin nura tia tiwolliela? keawai nura ba ġurran-upa-uwil koa baġ pintunúmba-kan wiya noa tia ba? ");
INSERT INTO awk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ġatun bara ġurra korien unnoa wiyelli ta wiya noa ba barun, ");
INSERT INTO awk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ġatun noa uwa barun katoa barán Nadharet tako, ġatun ġurrullikan noa kakulla barun kin: wonto bountoa ba tunkan to ġikoúmba miromá unni tara wiyellikanne murruġ ka búlbúl la bounnoun kin. ");
INSERT INTO awk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ġatun noa Iéthuko poaikulléu̇n ġuraki kakilliko, ġatun kauwȧl kakilliko, ġatun pitȧlmulliko bon Eloito ġatun ku̇riko. ");
INSERT INTO awk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yakita kakulla wunȧl la pipátin ta piriwȧl koba Tiberio Kaithar koba, kobȧna noa Pontio Pilato Iudaia ka, ġatun tetrák noa Herod Galilaia ka, ġatun ġikoúmba kóti Pilip tetrák noa Ituréa ka, ġatun yantin tako Trakoniti ka, ġatun Luthanio tetrák noa Abiléné ka, ");
INSERT INTO awk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annath ġatun Kaiapath hiereu piriwál bula kakulla, wiyellianne Eloi koba uwa Ioanne kinko bon, yinal Dhakaria koba, koruġ kaba. ");
INSERT INTO awk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gatun noa uwa yantin toa purrai toa Iorȧdan toa, wiyelliela korimulliko kanumaiko, warekulliko yarakai; ");
INSERT INTO awk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yanti wupaitoara biblion ka wiyellikanne Ethaia koba propet koba, ġiakai, Pulli wakȧl koba wiyelléu̇n koruġ kaba, Yapuġ Yehóa koba murráráġ umulla nura, tuloa kakillikoyapuġ ġikoúmba. ");
INSERT INTO awk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yantin ta pilabai warapal upinún, ġatun yantin ta bulkȧra umȧnu̇n puntiġ; ġatun warin-warin ta umánún tuloa, ġatun yapuġ yarakai wolluġbiara umánún poitoġ; ");
INSERT INTO awk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Gatun yantinto nanún wal ġolomullikanne Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wiya ġaiya noa barun konara uwa bara korimulliko ġikouġ kinko, Ela béara! konara maiya kiloa nura! ġanto nurun wiya murralliko bukka tin tanan ba uwánún? ");
INSERT INTO awk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Koito nura ba umullia murrȧrȧġ minki kabiruġ; ġatun kota yikora nura kóti ka minki ka nurun kin wiyelliko, Abáram ġearun noa ġearúnba biyuġbai; kulla baġ wiyan nurun, Eloi noa kaiyukan kátan umulliko unti tara biruġ tunúġ kabiruġ wonnai kakilliko Abáram kinko. ");
INSERT INTO awk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ġatun yakita baibai wúnkulla kúlai ta wirrá ka; koito ba yantin kúlai keawai kátan murráráġ kólbúntillȧnún wal barán, warekulliko koiyuġ kako. ");
INSERT INTO awk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ġatun kúriko bon wiya, wiyelliela, Minnuġ banún ġaiya ġéen? ");
INSERT INTO awk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wiya noa barun, wiyelliela, Niuwoa kót-kan buloarakan ġikoúmba, ġumunbilla bon keawai ko; ġatun niuwoa kuntokan ġumúnbilla bon yanti kiloa. ");
INSERT INTO awk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Uwá ġaiya bara telóné korimulliko, ġatun wiya bon, Piriwál, minnuġ banún ġéen? ");
INSERT INTO awk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ġatun noa wiya barun, Manki yikora untoa-kȧl unnoabo mara wiyatoara nurúnba. ");
INSERT INTO awk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ġatun bara army-kanko wiya bon wiyelliela, Minnuġ banún ġéen? ġatun noa wiya barun, Bukkamai yikora yantin kúri, ġatun wiyéa-yemmai yikora ġakoyellaikan yantin kúri; ġatun murrai kauwa nura ġaloakan ġutoarakan nurúnba. ");
INSERT INTO awk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ġatun bara ba ku̇ri kotelliela, ġatun yantinto ku̇riko kotelliela murruġ ka ba ko, búlbúl la ba ko barun kin ba ko ġikóuġ Ioannenuġ, minariġ noa Kritht ta, mirka keawaran. ");
INSERT INTO awk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ioanneto noa wiya barun yantin ta, wiyelliela, Korimulliko baġ kȧtan nurun bato ko; wonto ba wakȧl kaiyukan kauwȧl-kau wȧlkan ġatoa kiloa uwȧnu̇n, murráráġ korien baġ poruġbuġgulliko tu̇ġganu̇ġ ko ġikoúmba ko; niuwoa ta korimanu̇n nurun Marai to yirri-yirri ko ġatun koiyuġ ko: ");
INSERT INTO awk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pituon ġikoúmba mankillin mȧttȧra ba, ġatun murkun noa umȧnu̇n bu̇nkilliġél laba ġikoúmba, ġatun noa ka-umȧnún wiet ġikoúmba tako kokerá ko; wonto ba tirri koiyuġ-banu̇n wal noa koiyuġ ka talokulli korien ta. ");
INSERT INTO awk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tarai ta yantin kauwȧl-kauwȧl wiya noa: ġatun wiyelli ta ba ko barun ku̇ri. ");
INSERT INTO awk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wonto noa ba Herodnuġ tetráknuġ piralma bon, noa boun noun kin Herodia kin nukuġ ka Pilip-úmba ġikou̇mba kóti koba, ġatun yantin yarakai noa ba uma Herodto, ");
INSERT INTO awk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yanti unni uma, wirriġbakulla bon noa Ioannenuġ jail ka. ");
INSERT INTO awk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yakita barunbo karima yantin ku̇ri, kakulla ġaiya korimulliela bon Iéthunuġ, ġatun wiyelliela, moroko ġaiya waruġkalléu̇n, ");
INSERT INTO awk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ġatun uwa barán Maraikan yirri-yirrikan murrin kiloa purrouġkan kiloa, ġikouġ kin; ġatun wakȧl pulli kakulla moroko tin, wiyelliela, Ġintoa ta emmoúmba yinal pitȧlmullikanne; pitȧlman baġġirouġ. ");
INSERT INTO awk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ġatun niuwoa bo Iéthu kakilliliela wunȧl la triakonta ka ġiko-úmba, puntelliela bon yinal Yothepúmba, wonto yinal Eli-úmba;....... ");
INSERT INTO awk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Wonto yinal Enoth-úmba, wonto yinal Thet-úmba, wonto yinal Adam-úmba, wonto yinal Eloi-úmba. ");
INSERT INTO awk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ĠATUN noa Iéthu warapȧlkan Maraikan yirri-yirri-kan, willuġbo kakulla Iorȧdan tabiruġ, ġatun bon yatéa Maraito koruġ kolaġ, ");
INSERT INTO awk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nupitoara bon purreȧġ ka tettarakonta ka diabollo. Ġatun unta tara purreȧġ ka keawai noa ta ba: ġatun ġoloin ba unta tara kakulla, kapirri ġaiya noa kakulla. ");
INSERT INTO awk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ġatun noa diabollo wiya bon, Wiya, bi ba yinal Eloi koba, wiyellia unni tunuġ ka-uwil koa kunto. ");
INSERT INTO awk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ġatun noa Iéthuko bon wiya, wiyelliela, Wupatoara ta, Keawai kúri kȧnún moron kunto kabiruġ, wonto ba Eloi koba pulli tabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ġatun noa diabollo yutéa bon waita bulkȧrȧ ko, nanunbéa bon yantin piriwȧl koba purrai ta ba tanoa-kȧl-bo kurrakai. ");
INSERT INTO awk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ġatun noa diabollo wiya bon, yantin kaiyu kako ġunu̇n bag ġirouġ, ġatun pitȧlmulliko ġali tara ko; koito ba ġukulla tia emmouġ; ġatun bag ġutan ganúmbo pitȧl bag ba kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ġintoa ba wiyȧnu̇n tia, kȧnu̇n bin yantin ġiroúmba. ");
INSERT INTO awk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ġatun noa Iéthuko wiya bon, Kauwa bi, Thátan, willuġ ka emmouġ kin; koito ba wupatoara, Wiyȧnu̇n wal bi Yehóanuġ ġiroúmba Eloinuġ, ġatun ġikouġ bo ġurrȧnu̇n wal bi. ");
INSERT INTO awk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ġatun noa bon yutéa Hierothalem kolaġ, ġatun wúnkulla bo búlwarra ka hieron ka, ġatun wiya bon, Yinalla bi ba unni Eloikoba, warekulla bi unti biruġ barán: ");
INSERT INTO awk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kulla ba wupatoara ta, Wiyȧnu̇n noa barun aġelo ko nakilliko ġirouġ, ġolomulliko ġirouġ; ");
INSERT INTO awk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ġatun bara bin manu̇n mȧttȧrró wokka lag, tinna koa ġirouġ pultéa-ku̇n tunuġ ko yantin ta. ");
INSERT INTO awk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ġatun Iéthuko, wiyelliela, wiya bon, Wiyatoara ta, Yanoa wal bi numa yikora bon Yehóanuġ Eloinuġ ġirou̇mba. ");
INSERT INTO awk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ġatun noa diabollo ġoloin kakulla unni tara nupatoara, waita ġaiya noa uwa ġikouġ kinbiruġ yakita ko. ");
INSERT INTO awk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ġatun noa Iéthuko willuġ ko kakulla, kaiyukan Maraikan, Galilaia kako: ġatun totóġ bon kakulla yantin ta purrai kariġ ka. ");
INSERT INTO awk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ġatun noa wiyelliela thunagóg ka barun ka ta, pitȧl wiyatoara bon yantinto. ");
INSERT INTO awk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ġatun noa uwa Nadharet tako, kakulla noa poaikulléu̇n unta; ġatun, yanti katai noa ba, uwa noa thunagóg kako purreȧġ ka thabbat, ġatun ġarokéa wokka laġ wiyelliko. ");
INSERT INTO awk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ġatun ġukulla bon biblion ta propet koba Ethaia koba: ġatun buġbuġġa noa ba biblion, nakulla ġaiya noa ġiakai upatoara, ");
INSERT INTO awk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Marai ta unni Yehóa koba emmouġ kinba, kulla noa tia putia wiyelliko Euagelion barun kin mirrȧl la; yuka noa tia turon umulliko minkikan ko, wiyelliko barun wúntoara ko wamunbilliko, ġatun na-uwil koa bara munmin to, buruġ buġgulliko barun búntoara, ");
INSERT INTO awk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wiyelliko * * * ġurrabunbilliko wunȧl la pitȧlmullikanne Yehóa koba. ");
INSERT INTO awk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ġatun noa wirriġ-buġġa biblion,ġatun noaġutéa kan bon umullikan ko, ġatun yellawa barán. Ġatun bara bon pimilliela ġaikuġ ko, yantin thunagóg ka ba ko. ");
INSERT INTO awk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ġatun noa barun tanoa bo wiya, Turin-pai-béa unni wiya upatoara nurun kin ġurréuġ ka unti purreȧġ ka. ");
INSERT INTO awk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ġatun yantinto bara ġurrulliela bon, ġatun kota bara pulli murrai kurraka kabiruġ ġikouġ kinbiruġ. Gatun bara wiya, Wiya, unni ta Yothepúmba yinal? ");
INSERT INTO awk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ġatun noa barun wiya, Nura ta wiyánu̇n tia unni wiyellikanne, Karákal, turon bi umulla gintoa bo; ġurra ġéen ba umatoara Kapernaum ka, umulla bi unti yantin ta purrai ta ġiroúmba ka. ");
INSERT INTO awk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ġatun noa wiya, Tuloa nurun bag wiyan, keawai propet ġurrá korien ġikouġ ka ta purrai ta kóti ka ");
INSERT INTO awk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wonto baġ ba nurun wiyan tuloa, kauwȧl-kauwȧl ta mabogun Ithȧrael kulléu̇n purreȧġ ka Elia-úmba ka, yakita wirriġbakulla moroko ta wunȧl ta ġoro ġatun yellenna hek ta, tara-wará kakulla yantin ta purrai kariġ ka; ");
INSERT INTO awk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Keawai Elianuġ yuka ba barun kinko, wonto ba Tbarepta kako Thidoni kako nukuġ kako mabogun tako. ");
INSERT INTO awk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Gatun kauwȧhkauwȧlkan leprokan Ithȧrael ka, yaki-kȧlai Eliéu koba propet koba; keawaran wakál barun kinbiruġ turon umatoara, wonto ba noa Naaman Thuriakȧl. ");
INSERT INTO awk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ġatun yantin bara kakulla thunagóg ka, ġurra bara unni tara, bukka kauwȧl kakulla ");
INSERT INTO awk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ġatun bouġkulleu̇n,ġatun yipa bon kokerá biruġ,ġatun bon yutéa pita kako bulkȧrá ko kokerá ko wittitoara ko, wareka uwil koa bara bon walluġgón barán. ");
INSERT INTO awk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wonto noa ba uwolliela Willi koa barun katoa, waita uwa. ");
INSERT INTO awk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ġatun noa uwa barán Kapernaum kako, kokerá ko Galilaia kako, ġatun wiyelliela barun purreáġ ka thabbat ka. ");
INSERT INTO awk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ġatun bara kota wiyellikanne tin ġikoúmba tin; kulla ġikoúmba pulli kaiyukan. ");
INSERT INTO awk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ġatun kakulla wakȧl ku̇ri thunagóg ka, ġikouġ kin minki ka marai kakulla diabol koba yarakai koba, ġatun noa kaipulléu̇n wokka, ");
INSERT INTO awk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Wiyelliela, Kȧmunbilla ġearun; minnuġ banu̇n ġéen bin ġintoa Iéthu Nadharetkȧl? uwa bi ġearun tetti-umulli kolaġ? ġimillin banuġ ġintoa ta; wakȧl bo ta yirri-yirri-kan Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ġatun bon Iéthuko koakulla, wiyelliela, Kaiyellia bi, ġatun paikulléa ġikouġ kinbiruġ. Ġatun bon ba wareka willi ka diabollo, paikulléu̇n noa ġikouġ kinbiruġ, ġatun keawai bon tetti búntima ba. ");
INSERT INTO awk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ġatun bara yantinto kota, ġatun wiyelliela barabo-barabo, Minariġ unni wiyellikanne! kulla noa wiya kaiyu-kan-to barun diabolnuġ yarakaikan, ġatun barun paikulléu̇n warrai tako. ");
INSERT INTO awk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ġatun totóġ ġikoúmba kakulla yantin toa purrai kariġ koa. ");
INSERT INTO awk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ġatun noa uwa thunagóg kabiruġ, ġatun polóġkulléún Thimon kinko kokerá ko. Ġatun tunkán Thimonúmba nukuġ koba munni kakulla karinkan; ġatun bon bara wiya bounnoun kai kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ġatun noa ġarokéa bounnoun kin turruġ ka, ġatun noa koakulla karin; ġatun wareka ġaiya bounnoun karinto; ġatun bountoa bouġkulléu̇n tanoa-kȧl-bo, ġatun umulliela barun kaiko. ");
INSERT INTO awk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ġatun punnȧl ba pulóġ-kulliléu̇n, yantin bara mankulla munni-munni-kan ġikouġ kinko; ġatun noa wunpilléu̇n barun kin mȧttȧra yantin ta, ġatun turon uma barun. ");
INSERT INTO awk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ġatun diabol kauwȧl-kauwȧl paikulléu̇n kauwȧl-kauwal labiruġ, kaibulliela, ġintoa ta Kritht ta, yinal ta Eloi-koba. Ġatun noa barun koakulla wiya korien; kulla wal bara ġimilléu̇n bon Kritht ta noa unnoa. ");
INSERT INTO awk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ġatun purreȧġ ba kakulla, waita noa uwa korariġ; ġatun bara kúriko tiwa bon, ġatun uwa ġikouġ kin, ġatun mima bara bon, keawai noa waita wapa barun kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ġatun noa wiya barun, Wiyȧnún bo ta wal bag piriwȧlġél la Eloi koba taraikan ta kokerá; kulla wal tia ġaliko yuka. ");
INSERT INTO awk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ĠATUN yakita kakulla, warapa bon ba bara kuriko, ġurrulliko wiyellikanne Eloi koba,ġarokéa noa pitta ka waraka Gennetharet ta, ");
INSERT INTO awk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ġatun nakulla buloara murrinauwai kakilliela wara ka; wonto ba bara makoroban waita uwa murrinauwai tabiruġ, ġatun bara umulliela pika mirkun. ");
INSERT INTO awk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ġatun noa uwa wakȧl la murrinauwai ta Thimon koba ka, ġatun wiya bon yóġyóġ umullia purrai tabiruġ. Ġatun noa yellawa barán, ġatun wiyelliella barun ku̇ri murrinauwai kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ġatun ġoloin noa ba wiya, wiya noa Thimónnuġ bon, Tuirkullia pirriko kako, ġatun wura pika nurúnba mankilliko. ");
INSERT INTO awk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ġatun Thimónto, wiyelliela, wiya bon, Piriwȧl, uma ġéen tokoi ta yanti-katai, ġatun man korien; kulla bi wiyán wupinu̇n wal baġ barán pika. ");
INSERT INTO awk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ġatun uma bara ba unni, kokoi-kokoi bara uma makoro katai kal, ġatun pika kilpaiya. ");
INSERT INTO awk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ġatun bara wokkaimulléu̇n barúnba tarai taba murrinauwai taba; wa-uwil koa barun wintamulliko. Ġatun bara uwa, ġatun warapál bara wupéa buloara murrinauwai, pillukulliela ġaiya bara. ");
INSERT INTO awk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nakulla noa ba Thimónto Peterko, puntimulléȧn noa Iéthu kin warómbuġ ka, wiyelliela, Ela Piriwȧl! yuriġ bi wolla emmouġ kinbiruġ; kulla baġ yarakairán ku̇ri kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kulla noa kota, ġatun yantin bara ġikouġ katoa ba, kauwȧllin makorrin mankulla bara ba. ");
INSERT INTO awk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ġatun yantibo bara Yakobo ġatun Ioanne, yinal ta Lebedaio koba, mankillai bula ba Thimon katoa. Ġatun Iéthako noa wiya bon Thimóunuġ, Kinta kora bi; yakita biruġ manún wal bi barun ku̇ri. ");
INSERT INTO awk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ġatun mankulla bara ba murrinauwai barán purrai tako, wúnkulla bara yantin, wirroba bon bara. ");
INSERT INTO awk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ġatun yakita kakulla, kakulla noa ba tarai ta kokerá, a! wakȧl kúri kauwȧl leprokan; nakilliela noa Iéthunuġ puntimulléu̇n ġoarrá ko, ġatun wiya bon, wiyelliela, Piriwȧl, wiya, bi ba kalyukan kȧnún, umȧnu̇n bi tia turon. ");
INSERT INTO awk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ġatun noa bon wupilléu̇n mȧttȧra ġikouġ kin, wiyelliela, Kauwá; turon bi kauwa. Ġatun tanoa-kȧl-bo leprota wareka ġikouġ kinbiruġ ko. ");
INSERT INTO awk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ġatun noa bon wiya, wiyéaku̇n koa noa barun ku̇ri; wonto ba yiruġ uwa tu̇ġunbilliko ġintoa bo hiereu kinko, ġatun ġu̇wa kulla bi turon umatoara, yanti to Mothé ka noa ba wiya, ġurrulliko kakilliko barun. ");
INSERT INTO awk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wonta ba yantin kakulla totóġ ġikouġ yantin toa purrai toa: ġatun kauwȧlko naro uwa ġurrulliko, ġatun turon kakilliko barun munni-munni ġikouġ kinbiruġ ko. ");
INSERT INTO awk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ġatun noa uwa koruġ kako, ġatun wiyelliela. ");
INSERT INTO awk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yakita kakulla tarai ta purreȧġ ka, wiyelliela noa ba, yellawa ba Parithaioi ġatun didathkaloi wiyellikanne koba, yantin tabiruġ kokerá biruġ Galilaia kabiruġ, ġatun Iudaia kabiruġ, ġatun Hierothalem kabiruġ; ġatun kaiynto Yehóa-úmba kakulla turon umulliko barun. ");
INSERT INTO awk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A! ġatun bara ku̇ri wakȧl ku̇ri kurréa pirrikilliġél la munnikan karál; ġatun numa bara bon kurrilliko kokerá kolaġ, ġatun wu̇nkilliko bon ġikouġ kinko mikan tako. ");
INSERT INTO awk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ġatun keawai bara napa wonnén kurrilliko murruġ kolaġ konara tin, uwa bara wokka laġ kokerá bu̇lwarra ka, ġatun wupéa bon barán kulla koa willi-willi kako pirrikilliġélkan Iéthu kin mikan ta. ");
INSERT INTO awk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ġatun nakulla noa ba kotellikanne barúnba, wiya noa bon, Ela ku̇ri, yarakai ġirou̇mba wareka ġirouġ kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ġatun bara gȧrammateu ġatun Parithaioi kota, wiyelliela, Ġan-ke unni wiyan ba yarakai? Ġanto kaiyu-kan-to warekulliko yarakai, wonto ba wakȧllo Eloito? ");
INSERT INTO awk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wonto noa ba Iéthuko ġurra kotatoara barúnba, niuwoa wiya wiyelliela barun, Minariġ tin nura kotelliela búlbúl lako nurun kin ba ko. ");
INSERT INTO awk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wonnén murrȧrȧġ wiyelliko,ġiroúmba ko yarakaito wareka ġirouġ kinbiruġ; ġa wiyelliko, Bouġkullia ġatun uwolliko? ");
INSERT INTO awk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wonto ba ġurra-uwil koa nura kaiyukan noa yinal ku̇ri koba purrai taba yarakai warekulliko (wiya noa munni karál), Wiyan banuġ, bouġkullia ġatun mara ġirou̇mba pirrikilliġél, ġatun waita unwolla ġirouġ ka tako kokerá ko. ");
INSERT INTO awk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ġatun tanoa-kȧl-bo bouġulléu̇n noa barun kin mikan ta, ġatun mánkulla unnuġ ġikoúmba pirrikéa noa ba, ġatun waita uwa ġikouġ ka tako kokerá ko koti kako, pitȧlmulliela bon Eloinuġ. ");
INSERT INTO awk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ġatun yantin bara kotelliela, ġatun bara ġaiya pitȧlma bon Eloinuġ, ġatun kinta laġ bara kauwál, kȧtan wiyelliela, Nakulla ġéen minariġ konéin buġgai. ");
INSERT INTO awk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ġatun yakita yukita waita uwa noa, ġatun nakulla wakál telónénuġ,ġiakai yitirra Lebi, yellawollin wu̇nkilliġél la; ġatun noa wiya bon, Yettiwolla tia. ");
INSERT INTO awk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ġatun noa wúnkulla yanti bo bouġkulléu̇n, ġatun noa bon yettiwa. ");
INSERT INTO awk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ġatun Lebiko bon noa upéa kauwȧl takillikanne ġikouġ ka ta koti ka kokerá: ġatun kauwál kakulla konara telónai ko ġatun tarai to yellawa barun katoa ");
INSERT INTO awk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wonto ba barúnba gárammateu ġatun Parithaioi koakillan bara barun wirrobullikan ġikoúmba, wiyelliela, Minariġ tin nura tatan ġatun pittan barun katoa telónai koa ġatun yarakai toa? ");
INSERT INTO awk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ġatun noa Iéthuko wiya barun, wiyelliela, Bara ba moron tai kátan keawai bara wiyan karákál; wonto ba bara munni kátan. ");
INSERT INTO awk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Uwa bag wiya korien ko murroġ taiko, wonto ba yarakai willuġ ko minki kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ġatun wiya bon bara, Minariġ tin bara mupai kátan murrinmurrin wirrobullikan Ioanne-úmba, ġatun wiyan wiyellikanne, ġatun yantibo bara Parithaioi koba; wonto ba ġiroúmba ko tatan ġatun pittan? ");
INSERT INTO awk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ġatun noa wiya barun, Wiya, nura kaiyukan mupai umulliko barun wonnai kakillaikanne, yakita-kȧlai poribai ba kátan barun katoa ba? ");
INSERT INTO awk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wonto ba purreȧġ kȧnu̇n wal, mánu̇n wal bon ba poribai barun kinbiruġ, ġatun yakita ġaiya bara mupai-kakillinún purreȧġ ka unta tara. ");
INSERT INTO awk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ġatun wiya noa barun wakȧl parabol ġiakai: Keawai ku̇ri ko wupillinu̇n buġgaikȧl korokȧl la; ġa ba, yanti buġgaikȧl yiirbuġganu̇n ġaiya wal, ġatun pontol buġgaikȧl labiruġ keawai korokȧl kiloa kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ġatun keawai kúri ko wupinu̇n buġgaikȧl wain pika ka korokȧl la; kulla buġgaikȧllo potopai-yanu̇n wal pika ka, ġatun kiroabullinu̇n, ġatun pika kȧnu̇n yarakai. ");
INSERT INTO awk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wonto ba buġgaikȧl wain wunu̇n wal buġgaikȧl la pika ka; ġatun buloara murrȧrȧġ kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ġatun keawai ku̇ri koba pittȧnu̇n korokȧl wain keawai noa mánu̇n buġgaikȧl wain, kulla noa wiyan korokȧl ta murrȧrȧġ. ");
INSERT INTO awk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ĠATUN yakita thabbat ka buloara, yukita thabbat ka kurri-kurri, uwa ġaiya noa murruġ koa yeaiġél loa; ġatun bara wirrobulli-kan-to ġikouġ ka to tittia wolluġ yeai, ġatun takulla mirro-mirromá mȧttȧra barun kin. ");
INSERT INTO awk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ġatun taraikanto Parithaioi koba wiya barun, Minariġ tin nura uman unnoa keawaran murrȧrȧġ umulliko unti tara purreȧġ ka thabbat ka? ");
INSERT INTO awk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ġatun noa Iéthoko wiya, wiyelliela, Wiya nura, wiya nura, wiya ba unni, Dabid-to noa ba upa, niuwoabo ba kapirri kakilla ġatun bara ġikouġ katoa; ");
INSERT INTO awk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Uwa noa ba kokerá kai Eloi koba, ġatun mankulla takulla nulai nakillilkanne, ġatun ġukulla barun ġikouġ katoa ba ko, keawaran murrȧrȧġ takilliko, wonto ba barúnba ko hiereu koba? ");
INSERT INTO awk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ġatun noa barun wiya, Yinal ta ku̇ri koba, piriwál noa kȧtan yantin ko thabbat ko. ");
INSERT INTO awk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ġatun yakita kakulla tarai ta thabbat ta, uwa ġaiya noa thunagóg ka ġatun wiyelliela: ġatun wakȧl kúri unta kakulla, mȧttȧra ġikoúmba túġkaġkeri tirrai kakulla. ");
INSERT INTO awk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ġatun bara gȧrammateuko ġatun Parithaioiko tumiméa bon, wiya bon noa ba turon umulla purreáġ ka thabbat ta; wiyayemma-uwil koa bara bon. ");
INSERT INTO awk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wonto noa ba kota barúnba ġurrulliela, wiya bon noa mȧttȧrakan tirraikan, Bouġkullia, ġatun ġarokilla Willi ka. Ġatun noa bouġkulléu̇n, ġatun ġarokéa. ");
INSERT INTO awk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Wiya ġaiya noa Iéthuko barun, Wiyánún wal bag nurun unni; wiya tuloa ta umulliko, murrárág ġa yarakai umulliko purreáġ, ka thabbat ta? moron umulliko, ġa warekulliko? ");
INSERT INTO awk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ġatun nakilliela kari-kari yantin barun, wiya bon noa, Tutullia bi mȧttȧra ġiroúmba. Gatun upulléu̇n ġaiya noa, ġatun mȧttȧra ġaiya bon turon uma yanti tarai ba. ");
INSERT INTO awk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ġatun bara warapalkan bukkakan kakulla; ġatun murrȧrȧg wiyellan barabo-barabo, minnuġ banún bara bon ba Iéthunuġ. ");
INSERT INTO awk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yakita unta purreȧġ ka, uwa noa bulkára kolaġ wiyelliko, yanti-katai noa tokoi ta wiyelliela bon Eloi-nuġ. ");
INSERT INTO awk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ġatun yakita purreȧġ ta, kaai ba noa barun wirrobullikan ġikoúmba; ġirimulléu̇n noa barun kinbiruġ dodeka niuwoa, barun wiya ġiakai yitirra apothol; ");
INSERT INTO awk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Thimónnuġ (wiya noa ġiakai yitirra Peternuġ), ġatun ġikou̇mba kurrakóġ Andrea, ġatun Yakobo ġatun Ioanne, ġatun Pilip ġatun Bátolomai, ");
INSERT INTO awk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mattaio ġatun Thoma, ġatun Yakobo Alpai-úmba, ġatun Thimon ġiakai wiya yitirra Dheloté, ");
INSERT INTO awk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ġatun Iudath kurrakóġ ta Yakobo-úmba, ġatun Iudath Ithȧkariot, ninwoa ġakoiyayé noa. ");
INSERT INTO awk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ġatun noa uwa barán barun katoa, ġatun ġarawan tako ġarokéa noa, ġatun konaró wirrobullikan ġikou̇mba, ġatun kauwȧl konara ku̇ri Iudaiakȧl, ġatun Hierothalemkȧl, ġatun korowȧtari Turokȧl ġatun Thidonikȧl, uwa bara ġurrulliko bon, ġatun turon umulliko barun ba munni; ");
INSERT INTO awk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ġatun bara wonkȧlman yarakai to marai to: ġatun barun umá turon. ");
INSERT INTO awk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ġatun yantinto konaró numulla bon bara; kulla murrȧrȧġ paibéa ġikouġ kinbiruġ, ġatun noa turon umá yantin barun. ");
INSERT INTO awk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gatun noa wokkalan nakulla ġaikuġ ko ġikoúmba wirrobullikan, ġatun wiya, Murrȧrȧg umatoara mirrȧlko; kulla nurun ba piriwȧlġél la Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Murrȧrȧg umatoara nura kapirrikan yakita: kulla nura warapan wal kakilliko. Murrȧrȧg umatoara nura túnkillin yakita, kulla nura kintellinu̇n wal. ");
INSERT INTO awk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Murrȧrȧg umatoara nura, yarakai umȧnu̇n ġaiya nurun ku̇ri ko, ġatun warekanu̇n nurun, ġatun yarakai wiyȧnu̇n nurun, ġatun warekanu̇n yitirra nuru̇nba yanti yarakai ba, ġikouġ kin biruġ yinal ku̇ri koba kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pitál nura kauwa ġatun úntellia unta purreáġ ka; kulla nurúnba ġukillikanne kauwȧl kátan moroko kaba; yanti umá bara biyuġbai tako barun ka to barun propetnuġ. ");
INSERT INTO awk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yapal nura porólkan kȧtan! kulla nura mankulla ta pitȧl nurúnba. ");
INSERT INTO awk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yapál nura warakan! kulla nura kapirrikȧnu̇n. Yapal nura kintellan yakita! kulla nura ġirellinun ġatun túnkillinu̇n. ");
INSERT INTO awk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Yapal nura, murrȧrȧg wiyȧnu̇n ba yantinto kuriko nurun! yantibo barúnba biyuġbai ta ko barun ġakoyaye propetnuġ. ");
INSERT INTO awk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ġiakai baġ wiyan nurun ġurrullikan, Pitȧlumulla barun yarakai willuġ nurúnba; murrȧrȧg umulla barun yarakai nurúnba uman, ");
INSERT INTO awk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Murrȧrȧg barun wiyella koatan nurúnba; ġatun wiyella bon Eloinuġ wiyella barun yarakai nurúnba uman. ");
INSERT INTO awk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ġatun bu̇nnu̇n ba wakȧl ġan kulló tarai to, tarai ġukillia; ġatun niuwoa manu̇n wurabil ġiroúmba, wiya yikora wiwi manki yikora unni doan. ");
INSERT INTO awk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ġuwa barun yantin ko wiyellinu̇n ba ġirouġ kin; ġatun niuwoa ba mankulla tullokán ġiroúmba wiya yikora kari bon. ");
INSERT INTO awk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ġatun unnoa la kotan nura la murrȧrȧg umulliko barun ku̇ri nurun, umulla nura yantibo ta barun. ");
INSERT INTO awk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kulla nura pitȧlman barun pitȧlman nurun, minariġko-ke unnoa? kulla bara yarakai-kan-to yantibo uman. ");
INSERT INTO awk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ġatun murrȧrȧg nura umȧnu̇n ba barun ġali murrȧrȧg nurun uman, minariġko-ke unnoa? kulla bara yarakai-kan-to yantibo uman. ");
INSERT INTO awk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ġatun mumbinu̇n nura ba barun kotan nura willuġbo upilliko barun, minariġko-ke unnoa? kulla bara yarakai willuġ mumbillan barun willuġbo upilliko yantibo. ");
INSERT INTO awk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wonto ba nura pitȧlumulla barun yarakai willuġ nurúnba; ġatun murrȧrȧġ umulla, ġatun mumbilla kotan keawai willuġbo upulliko; ġatun ġutoara kauwȧl kȧnu̇n nurúnba, ġatun nura wonnai kȧnu̇n wokka koba; kulla noa murrȧrȧġ uman barun wiyapaiye korien ġatun barun yarakai. ");
INSERT INTO awk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kauwa nura minkikan, yantibo Biyuġbai nurúnba minki kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kota yikora yarakai, ġatun keawai nurun kotȧnu̇n yarakai: pirriralmai yikora nura, ġatun keawai nurun pirriralmanún: warekilla nura, ġatun nurúnba warekȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ġuwa, ġatun ġunu̇n wal nurun; warapál, upulla barán, ġatun tolomulla kaumulliko, ġatun kiroabullin barȧn, ġunu̇n wal ku̇ri nurun ġielkaġ ka nurun kin. Kulla yantibo upitoara nura upullin, upéa kȧnu̇n nurun. ");
INSERT INTO awk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ġatun noa wiya barun wakȧl parabol; wiya, munminto yutinu̇n tarai munmin? wiya, wal bula-buloarabo warakullinu̇n barán kirun tako? ");
INSERT INTO awk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wirrobullikan ta keawaran noa kauwȧl korien ġikouġ kin piriwȧl la; wonto ba tuloa kȧtan, kȧnu̇n noa yanti piriwȧl ba ġikouġ ba. ");
INSERT INTO awk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ġatun minariġ tin bi natan moriġ ġirouġ ka ta ba ġaikuġ kaba kurrikóġ kaba, wonto ba na korien bi tulkirri ġaikuġ kaba ġirouġ kinba kóti kaba? ");
INSERT INTO awk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ġa, yakoai bi wiyan bon kurrikóġ ġirouġ ba, Biġgai, yakoai tia poruġbuġgabunbilla moriġ ġirouġ kinba ġaikuġ kaba, keawai bi ba nakillin tulkirri ġirouġ kaba? ġintoa ġakoiyaye! buruġbuġ ġala kurri-kurri tulkirri ġaikuġ kaba ġirouġ kinba kóti kaba, ġatun nanún ġaiya bi murra-murrȧrȧġ umulliko moriġ ġaikuġ kaba kurrikóġ kaba ġirouġ ka ta ba. ");
INSERT INTO awk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kulla ba kúlai murrȧrȧġ ta kȧtan, keawai yeai yarakai upin; ġa keawai ku̇lai yarakai ta kȧtan, yeai murrȧrȧġ upin. ");
INSERT INTO awk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wonto ba yantin ku̇lai ġimilliko kóti tin yeai tin; kulla bara ku̇ri mán korien kokuġ tulkirri-tulkirri tin, ġa titi korien bara botru maro tin. ");
INSERT INTO awk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Murrȧrȧgko noa ku̇riko wupillin noa murrȧrȧġ wunkilligél labiruġ minki kabiruġ búlbúl labiruġ ġikouġ kinbiruġ; ġatun noa yarakai wupullin noa yarakai wunkilliġel labiruġ yarakai ta biruġ minki kabiruġ búlbúl labiruġ ġikouġ kinbiruġ; kulla ġikoúmba ko kurraka ko wiyan kauwȧl labiruġ ko búlbúl labiruġ ko. ");
INSERT INTO awk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ġatun minariġ tin nura tia wiyan, Piriwȧl, Piriwȧl, ġatun uwa korien nura unnoa tara wiyan nurun baġ ba. ");
INSERT INTO awk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ġan tia ba uwȧnu̇n emmouġ kin, ġatun ġurran wiyellita emmoúmba, ġatun ġaloa uman, túġunbinu̇n baġ nurun ġan kiloa noa: ");
INSERT INTO awk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Niuwoa ba wakȧl yanti ku̇ri kiloa, wittia noa kokerá ġatun pinnia pirriko, ġatun wupéa tuġga tunuġ ka; ġatun poaikulléu̇n ba tunta-tunta, waiumbul murrá koribibi kokeroa, ġatun ġeawai tolomȧ pa; kulla wal wittia tunuġ ka. ");
INSERT INTO awk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wonto ba ġurran ġatun uma korien, ku̇ri kiloa noa wittia kokera tuġġa korien purrai ta: waiumbul murrá koribibi ġali, ġatun warakulléu̇n tanoa-kȧl-bo; kauwȧlla unnoa warakullin kokerá koba. ");
INSERT INTO awk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","WIYA noa ba ġoloin ġikou̇mba wiyellikanne, mikan ta yantin ta ku̇ri ka, uwá noa Kapernaun kako. ");
INSERT INTO awk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ġatun tarai koba kapȧtin koba umullikan munni kakilliela muluġkilliliela tetti, pitȧl umatoara noa ġikoúmba. ");
INSERT INTO awk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ġatun, ġurrá noa ba Iéthunuġ, wiyabunbéa noa barun ġarokȧl Hebȧraioi koba, wiyelliela bon uwa-uwil koa noa pirbuġgulliko ġikoúmba ko, umullikan ko. ");
INSERT INTO awk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ġatun uwá bara ba Iéthu kin, wiya ġaiya bon bara tanoa-kȧlbo wiyelliela, Murrȧrȧġ noa uma-uwil koa noa bon yanti: ");
INSERT INTO awk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kulla noa pitȧlman ġearúnba ku̇ri, ġatun noa wittia ġearun thunagóg. ");
INSERT INTO awk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Uwa ġaiya noa Iéthu barun katoa. Ġatun kaloġ korien ta noa ba kakulla kokerá kolaġ, yuka noa barun kapȧtinto kóti ta ġikouġ kin wiyelliela bon, Piriwȧl, yanoa bi; kulla bag keawaran murrȧrȧġ korien uwa-uwil koa bi emmouġ kin kokerá: ");
INSERT INTO awk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yaki tin baġ kota murrȧrȧġ korien bag uwolliko ġirouġ kinko; wonto ba wiyella wakȧl wiyellikanne, ġatun emmoúmba umullikan pirkullinu̇n wal. ");
INSERT INTO awk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kulla baġ ba kaiyukan wiyelliko, emmouġ kinba bara kakillin army-kan; ġatun baġ wiya wakȧl, Yuriġ, ġatun waita ġaiya noa uwa; ġatun tarai, Kaai, ġatun noa uwa tanan; ġatun emmoúmba umullikan, Umulla unni, ġatun umȧ ġaiya noa. ");
INSERT INTO awk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iéthuko noa ba ġurrá unni tara, kotelliela noa ġikouġ, ġatun warrakulléu̇n noa, wiya ġaiya noa barun wirroba bon ba, Wiyan baġ nurun, keawaran baġ na pa yanti ġurrullikanne kauwȧl, keawai yanti Ithȧrael la kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Gatun bara yukatoara, willuġbo uwolliela kokerá kolaġ, nakulla bon umullikan munni biruġ pirbuġgatoara. ");
INSERT INTO awk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gatun yakita purreáġ ka yukita, uwa noa kokeroa,ġiakai yitirra Nain; ġatun kauwȧl uwa ġikoúmba wirrobullikan ġatun taraikan kúri ġikouġ katoa. ");
INSERT INTO awk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ġatun uwa noa ba papai puloġkulliġél la kokerá kolaġ, ġa, tetti kulwon kurrilliela ku̇ri warai kolaġ, wakȧl bo ta yinal tunkán koba bounnoun ba, ġatun maboġun bountoa, ġatun kauwál-kauwál kúri kokerá biruġ uwa bounnoun katoa. ");
INSERT INTO awk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ġatun nakulla bounnoun noa ba Piriwȧllo, ġurrirra bounnoun noa kakulla, ġatun wiya ġaiya noa bounnoun, Túġki yikora. ");
INSERT INTO awk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ġatun uwa ġaiya noa, numa kurrilliġél; ġatun bara kurriá bon ba ġakéa korun. Gatun noa wiya, Wuġġurra, wiyan banuġ, Bouġkullia. ");
INSERT INTO awk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ġatun niuwoa tetti kabiruġ yellawa, ġatun tanoa-kál-bo wiya. Ġatun willuġbo bon noa ġukulla bounnoun kin ġikoúmba ka tunkán ta. ");
INSERT INTO awk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ġatun bara kakulla kinta yantin; ġatun bara bon pitȧlman Eloinuġ, wiyelliela, Kauwȧl propet ta paipéa ġearun kin, ġatun noa Eloito nakulla ġikoúmba ku̇ri. ");
INSERT INTO awk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ġatun unni totóġ ġikoúmba kakulla yantin to Iudaia koa, ġatun yantin toa purrai kariġ koa. ");
INSERT INTO awk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ġatun Ioanne-úmba-ko wirrobullikanto wiya bon unni tara. ");
INSERT INTO awk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ġatun noa Ioanneto wiya bulun wirrobullikan ġikoúmba, yuka bulun Iéthu kinko, wiyelliko, ġintoa ta uwȧnu̇n? ġa, na-téa kȧnu̇n ġéen taraikan? ");
INSERT INTO awk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Uwa bara ba kúri ġikouġ kinko wiya bara, Ioanneto korimullikanto ġearun yuká ġirouġ kinko, wiyelliko, ġintoa ta uwȧnún? ġa, na-téa kȧnún taraikan? ");
INSERT INTO awk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ġatun tanoa-kȧl-bo hora ka pirbuġġa noa kauwȧl-kauwȧl munni-munni, ġatun marai yarakaikan; ġatun kauwȧl-kauwȧl munmin umȧ noa barun nakilliko. ");
INSERT INTO awk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wiya ġaiya noa barun Iéthu, wiyelliela, Waita lag nura, ġatun wiyella bon Iȯannenuġ unni tara nakulla nura ba ġatun ġurra; munmin-tabiruġ-ko natan, wiirwiir-biruġ-ko uwan, wamun-wamun-tabiruġ turon kakulla, woġkȧl-labiruġ ġurran, tetti-kabiruġ bouġkulléu̇n, barun mirrȧl ko wiyan ta Euaġelion. ");
INSERT INTO awk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ġatun pitȧl-umatoara yantinto niuwara korien kȧnu̇n emmouġ kin. ");
INSERT INTO awk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ġatun waita ka ba bara ba puntimai Ioanne-úmba, wiya ġaiya noa barun ku̇ri Ioannenuġ bon, Minariġ tin nura koruġ kolaġ nakilliko? koġka toloman wibbi ko? ");
INSERT INTO awk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Minariġ ko nura uwa koruġ kolaġ nakilliko? wakȧl upulléu̇n ku̇ri poitoġ korikin to? A! bara upulléu̇n konéin to ġatun bara murrȧrȧġ kȧtan takilliko, yellawa bara piriwȧlġél la. ");
INSERT INTO awk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Minariġ ko nura uwa koruġ kolaġ nakilliko? wakȧl propet Kauwa, wiyan nurun baġ kauwȧllan noa ba propet kiloa. ");
INSERT INTO awk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ġali noa wiyatoara upa unni, A! yukan baġ puntimai emmoúmba ġirouġ kin mikan ta, umȧnun wal noa yapuġ ġirouġ. ");
INSERT INTO awk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kulla baġ wiyan nurun, Keawai propet kauwȧl kȧtan yanti Ioanne noa ba korimullikan porkullitoara nukuġ labiruġ: niuwoa waréa ta kȧtan piriwȧlġél la Eloi koba ka, kauwȧl noa kȧtan ninwoa kiloa. ");
INSERT INTO awk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ġatun yantinto ku̇riko ġurra bon, ġatun bara telónai, pitȧlma bon Eloi-nuġ, korimatoara kȧtan bara Ioanne kaibiruġ karimulli biruġ. ");
INSERT INTO awk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wonto ba bara Parithaioi ġatun bara nomikoi ġurramaiġa wiyellikanne Eloi koba barun kin, keawai korimatoara korien Ioanne kai. ");
INSERT INTO awk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ġatun noa Piriwȧllo wiya, Yakoai kiloa bara ku̇ri untikȧl willuġġél? ġatun minariġ kiloa bara? ");
INSERT INTO awk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bara yanti wonnai kiloa yellawollin ġukilliġél la, ġatun kaipullin taraikan, ġatun wiyellin, Tirkima ġéen nurun, ġatun keawai nura úntelli korien; minki ġéen kakulla nurun, ġatun keawai nura tuġkilli korien. ");
INSERT INTO awk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kulla noa Ioanne korimullikan uwa, keawai kunto ta pa, ġa wain keawai pitta pa; ġatun nura wiyan, diabol noa ġikouġ katoa ba. ");
INSERT INTO awk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yinal ta ku̇ri koba uwa takilliko ġatun pittelliko, ġatun nura wiyan, A! mataye ku̇ri unni, ġatun wain pittaye, kóti ta telónai koba ġatun yarakai willuġ koba! ");
INSERT INTO awk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wonto ba yautinto wonnaito ġuraki koba ko piralman bon ġuraki. ");
INSERT INTO awk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ġatun wakȧllo Parithaioi koba ko wiya bon ta-uwil koa noa ġikouġ katoa. Ġatun uwa noa kokerá Parithaio koba, ġatun yellawa noa barȧn takilliko. ");
INSERT INTO awk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ġatun, a! ġapal wakȧl yarakaikun bountoa ġurrá bountoa ba Téthunuġ bon yellawai takilli taba kokerá Parithaio koba ka, mankulla bountoa wu̇nkilliġél alabathro putillikanne, ");
INSERT INTO awk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ġatun ġarokéa bountoa tinna ka bulka ka ġikoung kin, túġkillin, ġatun bountoa puntia bounnoun ka to ġurrun to tinna ġikouúmba, ġatun pirripa bounnoun ka to kittuġ ko wolluġ koba ko bounnoun ka to, ġatun búġbúġka bon tinna ġikou̇mba, ġatun putia bon putilliġél lo. ");
INSERT INTO awk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yakita nakulla noa ba unni ġali Parithaio, wiya bon ba, wiyelléu̇n ġaiya noa ninwoabo minki ka, wiyelliela, Unni ku̇ri propet ba noa ġurra pa noa wonta-kan-to ka ġapallo numa bon; kulla bountoa yaraikan. ");
INSERT INTO awk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ġatun Iéthuko noa wiyayelléu̇n, wiyelliela bon, Thimón, wiya-uwil koa banuġ. Ġatun noa wiya, Piriwȧl, wiyellia. ");
INSERT INTO awk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tarai ta kakulla ġukillikan wakȧl buloara mumbitoara ġikoúmba; wakȧllo noa mumbilléu̇n pentakothioi denari, ġatun tarai ta pentékonta mumbilléu̇n. ");
INSERT INTO awk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ġatun keawai bula ġupaiye pa ba yaruġ ka bon, wareká ġaiya noa bulun ba. Wonta kin bulun kinbiruġ pitȧlmanu̇n kauwȧl bon! ");
INSERT INTO awk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Thimónto noa wiya, wiyelliella, Mirka ġikouġ wareka noa ba kauwȧl. Ġatun noa wiya bon, Kota bi tuloa. ");
INSERT INTO awk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ġatun noa warrakulléu̇n ġapal ko, ġatun wiya Thimónnuġ Natan bi unni ġapal? uwa baġ kokerá ko ġirouġ ka ta ko, keawai bi tia ġupa bato tinna ko; wonto bountoa ba puntia tia tinna bounnoun ka to ġurrun to, ġatun watia bounnoun ka to wolluġ kabiruġ ko kittuġ ko. ");
INSERT INTO awk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Keawai bi tia bu̇ġbúġ ka pa: wonto ba unni ġapal, búġbúġ-kulliela tia tinna yakita biruġ uwa baġ ba. ");
INSERT INTO awk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Keawai bi puti pa emmou̇mba wolluġ kipai to, wonto ba unni ġapal putia emmoúmba tinna kipai to. ");
INSERT INTO awk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ġiakai tin banuġ wiyan, Yarakai umatoara bounnoun ba kauwál ta warekatoara bounnoun ba; kulla bounnoun pitál-ma kauwál: kulla barúnba warekatoara waréa, pitál-ma bara warea. ");
INSERT INTO awk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ġatun noa bounnoun wiya, Wareká umatoara ġiroúmba yarakai. ");
INSERT INTO awk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ġatun bara yellawan ġikouġ kinba takilli taba, bara bo wiyatan minki ka, ġan-ke unni warekan noa yarakai. ");
INSERT INTO awk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ġatun noa bounnoun wiya, ġurrulli ta biruġ ġiroúmba moron bi kátan; yuruġ bi pitál kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ĠATUN yakita yukita uwa noa yantin toa purrai toa kokerá, wiyelliela ġatun túġunbilliela totóġ pitálmullikanne bathileia koba Eloi koba: ġatun bara dodeka ta ġikouġ katoa ba. ");
INSERT INTO awk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ġatun bara nukuġ taraikan, turon umatoara marai yarakai tabiruġ ġatun munni kabiruġ, Mari yitirra ġiakai Magdalakálin, bounnoun kinbiruġ paipéa diabol hepta ta, ");
INSERT INTO awk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ġatun Ioanna porikunbai Kutha-úmba, Herod-úmba umullikan, ġatun Thuhanna, ġatun taraikan kauwȧl, gala bara ġukulla bon untakȧl tullokan ba biruġ barun kai. ");
INSERT INTO awk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ġatun uwittillin bara ba ku̇ri kauwȧl-kauwȧl, ġatun uwa ġikouġ kinko, yantin tabiruġ kokerá biruġ, wiya noa unni parabol: ");
INSERT INTO awk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Upillikan noa uwa yeai ko upulliko ġikoúmba ko; ġatun upulliela noa ba, winta porkulléu̇n kaiyinkon ta yapuġ ka; ġatun waita-wa barán, ġatun tibbinto takulla moroko tinto. ");
INSERT INTO awk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ġatun winta porkulléu̇n tunuġ ka; ġatun poaikulléu̇n ba wokka lag tetti ġaiya kakulla, koito ba bato korien ta. ");
INSERT INTO awk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ġatun winta porkulléu̇n tulkirri-tulkirrá; ġatun poaikulléu̇n tulkirri-tulkirri matti, ġatun murruġkama. ");
INSERT INTO awk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ġatun tarai ta pórkulléu̇n purrai murrárȧġ purrai ta, ġatun poaikulléuu̇n wokka lag, ġatun yeai kurria hekaton ta. Ġatun noa ba wiya unni tara, kaaipulléu̇n ġaiya noa, Niuwoa ba ġurréuġ kan kȧtan ġurrulliko ġurrunbunbilla bon. ");
INSERT INTO awk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ġatun wirrobulli-kan-to ġikoúmba ko wiya bon, wiyelliela, Minariġ ke unni parabol? ");
INSERT INTO awk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ġatun noa wiya, ġutan ġurrulliko nurun pirriral bathileia koba Eloi-úmba; wonto barun tarai ta parabol la; natan bara keawai bara na pa, ġatun ġurran bara keawai bara ġimilli pa. ");
INSERT INTO awk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ġiakai ta unni parabol: Yeai ta wiyellikanne ta Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bara kaiyinkon taba yapuġ kaba ġurrullikan bara; uwa ġaiya noa diabol,ġatun mankulla wiyellikanne barun ba minki kabiruġ búlbúl labiruġ, ġurréa-kún koa bara ġatun moron koa bara katéa-ku̇n. ");
INSERT INTO awk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bara tunuġ kaba ġurra bara ba wiyellikanne pitálkan to; ġatun unni tara wirra korien kȧtan, kota bara waréa ba, ġatun yakita numullikanne ta waraka ġaiya bara. ");
INSERT INTO awk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ġatun unnoa tara pórkulléu̇n tulkirri-tulkirrá, bara ba ġurra, waita uwa ġaiya, ġatun murruġkanna umullikannéto ġatun porollo ġatun pirunto moron koba, ġatun yeai kurri korien murrȧrȧġ kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wonto ba unnoa murrȧraġ kaba purrai taba, bara ba ġurra wiyellikanne, tuloakan ġatun murrȧrȧġkan búlbúlkan, tuman bara, ġatun yeai kurrin murroi to. ");
INSERT INTO awk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Keawai kúriko wirroġbanu̇n kalbuġ, wutinu̇n ġaiya tenti ko, ġa wutinu̇n bara ka pinkilliġélla; wonto ba wupinu̇n kaibuġġél la, na-uwil koa bara uwollita ba ko kaibuġ. ");
INSERT INTO awk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kulla yantin ta ġetti biruġ ġurranu̇n wal kakilliko; ġatun yantin ta yuropatoara biruġ ġurranu̇n wal kakilliko, ġatun paipinu̇n wal. ");
INSERT INTO awk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yakoai nura ġurrulla; kulla ġikouġ kinba ġunu̇n wal ġikouġ kin; ġatun keawai noa ka korien, mantillinu̇n wal bon ġikouġ kinbiruġ unnoa ta paipitoara ġikouġ kinba. ");
INSERT INTO awk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ġatun tunkán ġikouġ kinko ġatun bara kóti ta ġikoúmba uwa, ġatun keawai bara wa pa ġikouġ kinko konarrin, kulla kauwȧl waitawollan. ");
INSERT INTO awk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wintako bon wiya ġiakai, Garokillin bara warrai taba ġikoúmba tunkán ġatun kóti ta, na-uwil koa bara ġirouġ. ");
INSERT INTO awk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ġatun noa wiyayelléu̇n barun, wiyelliela, Unni tara tia kȧtan emmoúmba tunkán ġatun kóti ta, ġurrullikan wiyellikanne Eloi koba ġatun umullikan. ");
INSERT INTO awk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ġatun yakita tarai ta purreȧġ ka, uwa noa murrinauwai ta ko ġikouġ katoa wirrobullikan toa ġikoúmba; ġatun noa barun wiya, Waita ġéen waiġa-uwil kaiyin kolaġ wara kolaġ. Ġatun bara tolka mureuġ kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wonto ba bara uwolliela, pirrikéa noa kóġóġ; ġatun wibbi kauwȧl kakulla wara ka; ġatun bara warapál, ġatun kinta kakilliela. ");
INSERT INTO awk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ġatun bara uwa ġikouġ kin, bouġbuġġa ġaiya bon, wiyellielia, Piriwȧl, piriwȧl, tetti kolaġ ġéen! Bouġkulléu̇n ġaiya noa, ġatun wiya noa wibbi, ġatun tulkun wombul koba; ġatun korun kakulla, ġatun yuraġ ġaiya kakulla. ");
INSERT INTO awk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ġatun noa wiya barun, Wonnuġ-ke nurun kotellita? Ġatun bara kinta kakulla, kotelliela, wiyalan taraikan-taraikan, Wontakan unni ku̇ri! kulla noa wiyan wibbi ġatun bato, ġatun ġurra ġaiya bon. ");
INSERT INTO awk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ġatun bara uwa purrai tako Gadarén tako, kaiyin taba Galilaia kaba. ");
INSERT INTO awk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ġatun noa ba yankulléu̇n purrai tako, nuġgurrawa bon wakállo ku̇riko kokerá biruġ ko, diabolkan noa katalla yuraki, ġatun keawai noa upillipa kirrikin to, keawai noa kȧtan kokerá, nikki ka noa kakulla. ");
INSERT INTO awk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nakulla noa ba Iéthunuġ, kaaibulléu̇n ġaiya noa, ġatun puntimulléu̇n ġikouġ kin mikan ta, ġatun wokka wiyelléu̇n wiyelliela, Minnuġ banu̇n ke bi tia, Iéthu, Yinal ta Eloi koba wokka kaba koba? Yanoa bi tia piralmai yikora. ");
INSERT INTO awk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Kulla noa wiya marai yarakaikan paikulliko kúri kabiruġ. Kulla bon mankulla murrin-murrin; ġatun wirria bon tibon ko; ġatun noa tiirbuġġa tibon, ġatun yuaipéa bon diabollo koruġ kolaġ). ");
INSERT INTO awk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ġatun Iéthuko noa wiya bon, wiyelliela, Wonnén bi yitirra? Gatun noa wiya, Léjun baġ; kulla kauwȧl-kauwȧl diabol uwa murrariġ ġikouġ kinko minki kako. ");
INSERT INTO awk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ġatun bara bon wiya, Yanoa, wiya yikora ġearun bi pirriko kolaġ kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ġatun kakulla untakȧl wirrul takilliela bulkȧra ba ko; ġatun bara wiya bon pulóġkulliko barun minki kako porȧk kako. Ġatun noa wamunbéa barun. ");
INSERT INTO awk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Uwa ġaiya bara waita diabol minki tabiruġ ku̇ri kabiruġ, ġatun pulógkulléu̇n porȧk ka koiro ka; ġatun wirrul murra barán karakai pirriko koba wara kako, kurrin to ġaiya bara. ");
INSERT INTO awk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nakulla bara ba tamunbéa unnoa tara umatoara, murra ġaiya bara, ġatun waita uwa kokerá kolaġ, ġatun ġoruġ kolaġ; wiya ġaiya ġaloa. ");
INSERT INTO awk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Uwa ġaiya bara nakilliko umatoara ko; ġatun uwa Iéthu kin, ġatun nakulla bara bon unnoa ku̇ri, paipitoara biruġ bara waita uwa, yellawolliela Iéthu ka ta tinna ka, kirrikinkan ġatun tuloa ġurrullikan; ġatun kinta bara kakulla. ");
INSERT INTO awk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yantinto nakulla unnoa wiya barun, yanti bon ba turon uma diabolkan kauwȧlkan. ");
INSERT INTO awk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ġatun yantinto konaró purrai tako Gadarén tako wiya gaiya bon waita uwolliko barun kinbiruġ; kulla bara kintakan kauwȧl kakulla. Ġatun noa uwa murrinauwai tako, ġatun wulluġbo kakulla. ");
INSERT INTO awk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ġatun unnoa ku̇ri kabiruġ diabol bara waita uwa, wiya bon ka-uwil koa noa ġikouġ katoa: wonto noa Iéthuko yuka bon waita, wiyelliela, ");
INSERT INTO awk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Willuġbo bi wolla ġirouġ ka tako kokerá ko, ġatun gurrabunbilliko unnoa tara uma noa ba Eloito ġirouġ. Ġatun noa waita uwa, ġatun wiya yantin toa kokeroa, yanti Iéthuko noa uma bon. ");
INSERT INTO awk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ġatun yakita kakulla, willuġbo noa ba Iéthu kakulla, pitȧl tara kakilliela ku̇ri, kulla bara bon mittilliela yantinto. ");
INSERT INTO awk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ġatun yakita uwa wakȧl ku̇ri tanan,ġiakai yitirra Yaeiro, wiyellikan noa thunagóg kako; ġatun noa puntimulléu̇n Iéthu kin tinna ka, ġatun wiya uwolliko ġikouġ kinko kokerá ko; ");
INSERT INTO awk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kulla bon wakȧl yinálkun kakulla, dodeka wunȧl ta bounnoun ba, ġatun bountoa pirrikilliela tetti kakilliela. Gatun uwa ġaiya noa, ku̇riko bon murruġkama. ");
INSERT INTO awk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ġatun wakál nukuġ, kumarakan dodeka wunȧl ta bounnoun ba, ġukilléu̇n bountoa kirun tullokan bounnoúnba karákȧl ko, keawai bara bounnoun turon uma pa, ");
INSERT INTO awk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uwa bountoa bulka kako, ġatun numa pita ġikoúmba kirrikin: ġatun tanoa-kȧl-bo kumara ġaiya kakulla korun. ");
INSERT INTO awk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ġatun noa Iéthuko wiya ġaiya, Ġanto tia numa? Yantinto wiya keawai, wiya ġaiya noa Peterko ġatun bara ġikouġ katoa, Piriwȧl, konaro bin murruġkama ġatun waita wa, ġatun bi wiyan, Ġanto tia numa? ");
INSERT INTO awk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ġatun noa Iéthuko wiya, Wakȧllo ta tia numa: kulla baġ ġurran waita ka ba kaiyu emmouġ kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ġatun bountoa ba nukuġko nakulla yuropa korien bountoa, uwa bountoa pulul-pulul, ġatun puntimulléu̇n ġikouġ kin mikan ta, wiya bon bountoa mikan ta yantin ta ku̇ri ka, minariġ tin bountoa numa bon, ġatun tanoa-kȧl-bo bountoa kakulla turon. ");
INSERT INTO awk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ġatun noa bounnoun wiya, Yinálkun, kauwa bi pitȧl; ġurrullito ġiroúmba-ko turon bin uma; yuriġ waita pitȧl kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ġatun wiyelliela noa ba, tanan uwa wakállo wiyellikan ta biruġ kokerá biruġ, wiyelliela bon, Ġiroúmba yinálkun tetti kakulla; yanoa, Piriwȧl pirriralmai yikora bon. ");
INSERT INTO awk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wonto noa ba Iéthuko ġurra, wiyayelléu̇n noa bon wiyelliela, Kinta kora bi; ġurrulla wal bi, ġatun turon ġaiya wal bountoa kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ġatun noa ba uwa kokerá ko ba murriraġ, keawai noa tarai kan wommumbi pa ġikouġ kin, wonto ba Peternuġ ġatun Yakobonuġ, ġatun Ioannenuġ, ġatun biyuġbai ġatun tunkán murrakin koba. ");
INSERT INTO awk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ġatun yantin tuġkilléu̇n ġatun minki kakulla bounnoun kai: wonto noa ba wiya, Tuġki yikora; keawaran bountoa tetti korien, wonto ba ġarabo kakillin. ");
INSERT INTO awk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ġatun bara bon béelma, nakilliela tetti bountoa kakulla. ");
INSERT INTO awk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ġatun noa kirun barun yipa warai tako, ġatun noa mankulla bounnoun muttȧrrin, ġatun wiya, Murrakin, bouġkullia. ");
INSERT INTO awk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ġatun bounnoun ba marai katéakan, ġatun bountoa bouġkulléu̇n tanoa-kȧl-bo: ġatun noa wiya bounnoun takilliko. ");
INSERT INTO awk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ġatun kintakan biyuġbai ġatun tunkán bounnoun ba: wonto noa ba wiya barun, yanoa wiya yikora taraikan ku̇ri unni umatoara. ");
INSERT INTO awk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","WIYA ġaiya noa barun dodeka ta ġikou̇mba kaumulliko, ġatun ġukulla barun kaiyu kakilliko ġatun wiyellikan kakilliko yantin ko diabol ko, ġatun turon umulliko yantin munnikan ko. ");
INSERT INTO awk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ġatun noa barun yuka wiyelliko bathileia Eloi koba, ġatun turon umulliko munni ko. ");
INSERT INTO awk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ġatun noa wiya barun, Manki yikora waita kolaġ, keawai tupa-tupa mánu̇n, keawai yinuġ, keawai kunto, keawai money, keawai buloara mánu̇n kirrikin taraiko-taraiko. ");
INSERT INTO awk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ġatun uwȧnu̇n nura ba tarai ta kokerá, tanoa kauwa, ġatun waita uwolla untoa biruġ. ");
INSERT INTO awk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ġatun bara keawai nurun wommunbi korien, waita nura ba uwȧnu̇n untoa biruġ kokerá biruġ, tirri-tirrillia yullo kabiruġ moriġ tinna kabiruġ nurun kinbiruġ, túġa kakilliko barun kinko. ");
INSERT INTO awk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ġatun waita bara uwa, ġatun uwa kokeroa Willi koa, wiyelliela Euaġelion, ġatun turon umulliela yantin ta purrai ta. ");
INSERT INTO awk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ġatun noa Herodto tetrákko ġurra unni tara umá noa ba; ġatun koteiliela niuwoa bo, kulla wiyatoara tarai-kan-to Ioanne noa bouġkulléa tetti kabiruġ; ");
INSERT INTO awk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ġatun winta ka, paipéa noa Elia; ġatun tarai-kan-to, wakȧl ġaġka-kȧl propet tabiruġ bouġkalléu̇n. ");
INSERT INTO awk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ġatun noa Herod wiya, Kolbu̇ntia baġ bon Iaonnenuġ wolluġ; ġan-ke unni ġurran baġ unni tara? ġatun noa na-uwil koa bon. ");
INSERT INTO awk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ġatun bara apothollo willuġbo bara ba kakulla, wiya ġaiya bon yantin unni tara uwa bara ba. Ġatun noa barun yutéa, ġatun kara uwa mirrulla ko, kokerá ko yitirra Betáthaida kako. ");
INSERT INTO awk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ġatun bara ku̇ri ġurra bara ba, wirropa bara bon; ġarokéa noa wiyelliko barun bathileia Eloi koba, ġatun umá barun turon kakilliko munnikan. ");
INSERT INTO awk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ġatun purreȧġ kakilliela yaréakȧl, uwa ġaiya bara dodeka ta, ġatun wiya bon, Yukulla barun konara waita laġ, uwa-uwil koa bara yantin toa purrai kariġ koa, yellawolliko, ġatun takilliko; kulla ġéen kȧtan unti mirrul la. ");
INSERT INTO awk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wonto noa ba barun wiya, Ġuwa barun ġaloa ko takilliko. Ġatun bara wiya, Keawai ġearu̇nba kulla unni pente kunto ġatun buloara makoro; wiya ġéen wirrilla barun ġali ko takilliko yantin ko ku̇ri ko. ");
INSERT INTO awk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kulla wal ku̇ri kauwȧl pentakikilioi ta. Ġatun noa wiya barun wirrobullikan, Yellawabunbilla barun konara kakilliko pentékonta tarai taba kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ġatun uma ġaiya bara yanti, ġatun yellawabunbéa barun yantin barán. ");
INSERT INTO awk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mankulla ġaiya noa unnoa tara kunto pente ġatun makoro buloara; ġatun nakilliela wokka laġ moroko koba, murroi wiyelliela unni tara, ġatun yiirbuġga, ġatun ġukulla barun wirrobullikan ko wunkilliko barun kin mikan ta konara. ");
INSERT INTO awk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ġatun takulla bara, ġatun warakan ġaiya bara kuttawan yantin; ġatun mankulla bara wanan dodeka ka wimbi ka wuntawai biruġ barun kai. ");
INSERT INTO awk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ġatun yakita wiyelliela noa ba niuwoa-bo púnbai, ġikoúmba wirrobullikan ġikouġ katoa; ġatun noa wiya barun, wiyelliela, Ġannuġ wiyan ku̇ri ko ġan baġ ba. ");
INSERT INTO awk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wiyayelléu̇n bara; wiyelliela, Ioanne ta bi korimullikan wonto ba taraito wiyan Elia ta ba; ġatun taraito wiyan wakȧl ġaġka-kȧl propet koba, bouġkulliakan katéa-kȧn. ");
INSERT INTO awk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wiya noa barun, ġanto tia nura wiyan ġan baġ ba? Peterko noa wiyayelléu̇n, wiyelliela, Kritht ta bi Eloi-úmba. ");
INSERT INTO awk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ġatun noa barun piralma, wiyéa-kȧn koa bara unnoa tara tarai ko ku̇ri ko; ");
INSERT INTO awk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wiyelliela, Yinal ta ku̇ri koba yarakai kauwȧl wal bon umȧnu̇n, ġatun warekȧnu̇n wal bon bara ġaġkakal ġatun bara hiereukan piriwȧl, ġatun bara gȧrammateukan, ġatun búnnu̇n wal tetti, ġatun bouġgánu̇n ġaiya bon tarai ta purreȧġ ġoro ka. ");
INSERT INTO awk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ġatun wiya noa barun yantin, Wanu̇n tia ba taraikan ku̇ri uwȧnu̇n, ġurrullia noa niuwoa-bo, ġatun mara-uwil koa noa taliġkabillikanne ġikoúmba yantin ta purreȧġ ka, ġatun wirrobulla tia. ");
INSERT INTO awk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ġanto ba miromȧnu̇n moron ġikoúmba, warekȧnu̇n wal noa? kulla noa warekȧnu̇n moron ġikoúmba emmouġ kin, ġaloa noa moron umȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wonnuġ-ke murrȧrȧġ ku̇ri ko, mankilliko purrai kariġ ko, ġatun noa tetti wal ġaiya kȧnu̇n niuwoa-bo, ġa warekȧnu̇n wal? ");
INSERT INTO awk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ġan tia ba koiyun kȧnu̇n emmouġ kai, ġatun wiyellikanne emmoúmba, Yinal ku̇ri koba koiyun ġikouġ kai, uwȧnu̇n noa ba killibinbinkan kóti ġikouġ kinba, ġatun Biyuġbai koba, ġatun aġelo yirri-yirri-kan koba barúnba. ");
INSERT INTO awk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kulla bag wiyan nurun tuloa, unni winta ġarokéu̇n ba, keawai bara tetti kȧnu̇n, kabo na-uwil koa bara bathileia-nuġ Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ġatun yakita kakulla purreȧġ ka ét ta yurika-ta unni tara wiyellikanne, yutéa noa barun Peternuġ, ġatun Ioannenuġ, ġatun Yakobonuġ, ġatun uwa wokka laġ bulkȧra kolaġ wiyelliko. ");
INSERT INTO awk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ġatun noa ba wiyelliela, takin bon tarai warrakulléu̇n, ġatun ġikoúmba kirrikin purrul kakulla, ġatun killibinbin kakulla. ");
INSERT INTO awk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ġatun wiyelliela bon ku̇riko Mothéko ġatun Eliako: ");
INSERT INTO awk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Paipéa bula killibinbin, ġatun wiya bula ġikoúmba (tetti?) tin ka-uwil koa Hierothalem ko. ");
INSERT INTO awk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wonto ba Peter noa ġatun bara ġikouġ katoa porrólkan bara birikéa kóġóġ; ġatun bara kakulla tiraġ, nakulla bara gikoúmba killibinbin, ġatun buloara bula ku̇ri ġarokéa ġikouġ katoa. ");
INSERT INTO awk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ġatun kakulla yakita bula ba waita uwolliela ġikouġ kinbiruġ, Peterko noa wiya bon Iéthunuġ, A! Piriwȧl, murrȧrȧġ ġearun unti ko kakilliko; ġatun umabunbilla ġoro kokerá; wakȧl bin, ġatun wakȧl Mothénuġ, ġatun wakȧl Elianuġ, ġurra korien minariġ noa wiya. ");
INSERT INTO awk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wiyelliela noa ba, yareil kakulla, ġatun wutéa barun; ġatun bara kinta kakulla, waita bara ba wolliela murrariġ yareil la. ");
INSERT INTO awk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ġatun pulli kakulla yareil labiruġ, wiyelliela, Unni ta emmoúmba kóti yinal pitȧlmullikan; ġurrulla bon. ");
INSERT INTO awk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ġatun pulli ba kakulla korun, Iéthu noa kakilliela pu̇nbai. Keawai bara unni tara wiya pa untatoara, natoara purreȧġ ka taraikan ta. ");
INSERT INTO awk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ġatun yakita kakulla purreȧġ ka tarai ta unta, uwa bara ba barán bulkȧra biruġ, kauwȧllo ku̇riko nuġgurra wa bon. ");
INSERT INTO awk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A! ġatun wakȧl ku̇ri konara koba kaaibulléu̇n, wiyelliela, Piriwȧl, kai bi, na-uwillia yinal emmoúmba; kulla noa emmou̇mba wakȧl wonnai. ");
INSERT INTO awk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A! ġatun maraito bon mankulla, ġatun ġaiya noa kaaibulléu̇n wokka; ġatun yiirbuġga bon, ġatun kurraġtoanbuġġa; ġatun búntoara noa, waita ġaiya ġikouġ kinbiruġ uwa. ");
INSERT INTO awk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ġatun baġ wiya barun wirrobullikan ġiroúmba warekulliko bon; keawai bara kaiyu korien. ");
INSERT INTO awk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ġatun noa Iéthuko wiya, wiyelliela, A! ġurra korien ġatun pirriral unni willuġ-ġél! Yakounta-laġ baġ kȧnu̇n nurun kin, ġatun wal baġ kȧmunbinu̇n nurun? Mara bon tanan ġiroúmba yinal unti ko. ");
INSERT INTO awk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ġatun uwolliela noa ba tanan diabollo bon puntima barán ġatun yiiryiir uma. Ġatun noa Iéthuko koakulla bon marai yarakai ka, ġatun bon wonnai turon uma, ġatun ġutéakan ġaiya bon biyuġbai ta ġikoúmba tin. ");
INSERT INTO awk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Gatun yantin bara kinta kakulla kaiyu tin kauwȧl lin Eloi koba tin; ġatun kotelliela bara ba yantin unni tara Iéthuko noa ba uma, wiya ġaiya noa barun wirrobullikan ġikoúmba, ");
INSERT INTO awk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Kȧmúnbilla unni tara wiyellikanne murriraġ ġurréuġ kako nurun kin; kulla noa Yinal ku̇ri koba wupinún wal bon mattȧra ku̇ri ka. ");
INSERT INTO awk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Keawai bara ġurra pa unni wiyellikanne, ġatun yuropa ġali barun kinbiruġ, keawai bara ġimilli korien; ġatun bara kinta kakulla wiyelliko bon ġali tin wiyellikanne tin. ");
INSERT INTO awk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yakita ġaiya bara wiyellan barabo-barabo, ġan-ke kȧnu̇n kauwȧl piriwȧl barun kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ġatun Iéthuko noa ġimilléu̇n kotatoara bu̇lbúl labiruġ barun kinbiruġ mankulla noa wonnai, ġatun yellawabunbéa bon ġikouġ kin taruġ ka, ");
INSERT INTO awk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ġatun noa barun wiya, Ġanto ba unni wonnai pitȧlmanu̇n kinba, pitȧl manu̇n ġaiya tia; ġatun ġanto ba tia pitȧlmanu̇n, pitȧlmanu̇n bon ġala yuka tia ba; ġatun niuwoa kȧtan waréa nurun kinba yantin taba, yantibo ta wal noa kauwȧl kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ġatun noa Ioanneto wiya, wiyelliela, Piriwȧl, nakulla ġéen wakȧllo paibuġgulliela barun diabol ġirouġ katoa biruġ yitirra biruġ; wiya ġéen bon yanoa, koito ba keawai noa wa pa ġearun katoa. ");
INSERT INTO awk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ġatun noa Iéthuko bon wiya, Wiwi yikora; koito noa ba keawai bukka korien ġearun, niuwoa ġearun katoa ba. ");
INSERT INTO awk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ġatun yakita kakulla purreaġ mánu̇n bon ba wokka kolaġ, pirral noa kakilliela waita Hierothalem kolaġ, ");
INSERT INTO awk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ġatun noa yuka barun puntimai ġikoúmba ġanka; ġatun bara uwa kokerá kolaġ Thamaria kako, umulliko ġikouġ. ");
INSERT INTO awk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ġatun bara bon keawai pitȧlma pa, kulla noa pirral kakulla wa pa Hierothalem kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ġatun bula wirrobullikan ġikoúmba, Yakobo ġatun Ioanne, nakulla bula unni, wiya bula, Piriwȧl, wiya bi, wiya-uwil koa ġéen koiyuġ koa kauwȧl barán moroko kabiruġ wina-uwil koa barun, yanti Elia noa ba unnoa? ");
INSERT INTO awk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wonto noa ba wakulléu̇n, koakulla ġaiya barun noa, ġatun wiya, Keawaran nura gimilli korien nurúnba kóti búlbúl. ");
INSERT INTO awk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Koito ba noa yinal kúri koba keawaran noa tanan wa pa, búnkilliko kúri ko barun, wonto ba murrin umulliko. Ġatun bara uwa tarai tako kokerá ko. ");
INSERT INTO awk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ġatun yakita kakulla, uwolliela bara ba yuriġ yapuġ koa, taraito bon wiya, Piriwál, wirrobuġbinu̇n banuġ, wontariġ bi ba uwȧllu̇n, ");
INSERT INTO awk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ġatun noa Iéthuko bon wiya, Murroġ-kai-ko kumiri barúnba, ġatun tibbin moroko ka koba kunta barúnba, wonto ba yinal kúri koba keawaran bon ġikoúmba birrikilli-ġél walluġ ko ġikoúmba ko. ");
INSERT INTO awk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ġatun noa tarai wiya, Wirrobulla tia. Wonta noa ba wiya, Piriwál, wamunbilla tia ġanka bapa-uwil koa baġ emmoúmba biyuġbai. ");
INSERT INTO awk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wiya bon noa Iéthuko, Bapabunbilla barun tetti-tetti barúnba; ġintoa yuriġ bi wolla wiyelliko piriwȧl koba Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ġatun taraito wiya, Piriwȧl, wirrobanún banuġ; wamunbilla tia ġanka wiyellikoa barun baġ unni emmouġ kinba kokerá ba. ");
INSERT INTO awk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ġatun noa Iéthuko bon wiya, Keawai tarai-kan-to upillinu̇n mȧttȧra purrai-ġél lo, ġatun willuġ-wuminún, keawaran noa murrȧrȧġ korien kakilliko piriwȧl ko Eloi koba ko. ");
INSERT INTO awk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","YAKITA ġaiya kakulla unni tara, Piriwȧllo noa ġearimulléu̇n thebenty taraikan ta, ġatun yuka barun buloara-buloara ġikouġ kin mikan ta, yantin tako kokerá ko uwȧnun noa ba niuwoa-bo. ");
INSERT INTO awk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ġatun noa barun wiya, Kauwȧl-lan unni nulai kȧtan, keawai bo katillikan ku̇ri kauwȧlkȧl; ġali tin wiyella nura bon, Piriwȧl nulai-ġél koba yuka-uwil koa noa barun katillikan nulai ko katilliko ġikouġ kaiko. ");
INSERT INTO awk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Waita nura yuriġ wolla: A! yukan nurun baġ waita kolaġ yanti kiloa waréa ta éipu barun kin murroġ ka ta. ");
INSERT INTO awk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kurri yikora yanoa munniġél, ġatun yinuġ, keawai tuġganuġ; ġatun yanoa wiya yikora yapuġ koa taraikan ku̇ri. ");
INSERT INTO awk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ġatun uwȧnu̇n nura ba kokerá ko taraikan tako, wiyella, kurri ġiakai, Pitȧl kauwa unni kokerá ba. ");
INSERT INTO awk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ġatun ba yinal koba pitál koba kánu̇n unta, nurúnba pitȧl kánu̇n ġaiya unta; keawai ba nurun kin katéa kánu̇n willuġbo. ");
INSERT INTO awk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ġatun yellawȧnu̇n nura unta kokerá, takilliko ġatun pittelliko,ġunu̇n bara ba nurun; kulla noa umulli-kan-to man ba ġutoara ġikoúmba. Uwai yikora kokerá kolaġ kokerá kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ġatun uwȧnu̇n nura ba yantin ta kokeroa, ġatun bara nurun pitȧlmanu̇n, ta-uwa untoa tara wunu̇n ba mikan ta nurun kin. ");
INSERT INTO awk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ġatun turon barun umulla unta tara; ġatun wiyella barun, Piriwȧl koba Eloi koba papai uwa nurun kinba. ");
INSERT INTO awk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Uwȧnu̇n nura ba tarai ta kokeroa, ġatun bara keawai pitȧlma korien nurun, uwéa ka nura warai tako yapuġ kako, ġatun wiyella, ");
INSERT INTO awk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Umulléún ġéen punul untikȧl ġearun kinba nurun kin; A! kotellia nura unni ta uwan ta papai kȧtan nurun kin piriwȧl koba Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Wiyan nurun baġ, murrȧrȧġ kȧnu̇n unta ta tarai ta purreȧġ, ka Thodom kako, keawaran ġala ko kokerá ko. ");
INSERT INTO awk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yapallun bi Koradhin! yapallun bi Betȧthaida! kulla umatoara ba kauwȧl-kauwȧl kaiyu biruġ ka pa Turo ka ġatun Thidoni ka uma ġirouġ kin, minki bara ka pa yuraki, yellawa pa bara pirral la kirrikin ta ġatun bonoġ ka. ");
INSERT INTO awk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Murrȧrȧġ buloara kȧnu̇n Turo ġatun Thidoni unta purreȧġ wiyellaikanne ta keawaran bi. ");
INSERT INTO awk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ġatun ġintoa, Kapernaum, wunkulla wokka laġ moroko ka, yuaipinu̇n wal barán pirri kako. ");
INSERT INTO awk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Niuwoa ġurran nurun ba, ġurran ta noa tia; ġatun niuwoa waitiman nurun ba, waitiman noa tia; ġatun niuwoa tia waitiman, waitiman noa bon yuka noa tia ba. ");
INSERT INTO awk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ġatun bara thebenty ta willuġbo kakulla pitȧlkan, wiyelliela, A Piriwȧl! ġurrullikan bara diabollo ġearun ġirouġ katoa yitirroa. ");
INSERT INTO awk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ġatun noa barun wiya, Nakulla bon baġ Thatannuġ puntimulléu̇n barán moroko tin yanti málma kiloa. ");
INSERT INTO awk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A! ġutan baġ nurun kaiyu waitawolliko maiya ko ġatun wuarai ko, ġatun yantin ko kaiyu bukkakan ko; ġatun keawai wal nurun yarakai umulliko. ");
INSERT INTO awk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pitȧl-mai yikora nura-nura,ġali tin ġurullikan tin bara marai nurun ba; unti biruġ pitȧlma nura, kulla yitirra nurúnba upatoara moroko ka ba. ");
INSERT INTO awk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yakita ta noa pitȧl-lan kakulla marai ta,ġatun wiyelliela, Kauwa tia yanti, Biyuġ, Piriwȧl ta moroko koba ġatun purrai koba, kulla bi ba unnoa tara yuropa ġali unti biruġ ġuraki ta biruġ, ġatun bi túġkaiya unnoa tara barun boboġ ko; kauwa yanti, Biyuġ, koito ba murrȧrȧġ ta ġirouġ kin kȧtan mikan ta. ");
INSERT INTO awk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yantin ta tia wupéa emmouġ kinko Biyuġbaito; ġatun keawai ku̇riko bon yinal ġimilli pa, wonto ba Biyuġbaito; ġatun Biyuġbai yinallo ġimilléu̇n, ġatun niuwoa yinallo tu̇ġunbinu̇n bon Biyuġbai. ");
INSERT INTO awk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ġatun noa willariġ kakulla ġikouġ kai koba wirrobullikan, koba, ġatun wiyelliela kara, Kauwa yanti murrȧrȧġ ta natan ġaikuġ ko unni tara natan nura ba: ");
INSERT INTO awk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kulla baġ nurun wiyan, kauwȧllo propetto ġatun piriwȧllo na pa unni tara natan nura ba, ġatun bara keawai na korien; ġatun ġurra pa unni tara ġurran nura ba, ġatun keawai ġurra korien. ");
INSERT INTO awk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A! tarai wakȧl nomiko ġarokéa wokka laġ, ġatun wiya bon, wiyelliela, Piriwȧl, minnuġ banu̇n baġ moron kakilliko yantikatai? ");
INSERT INTO awk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wiya bon noa, Minariġ upa wiyellikanne? yakoai bi wiyan? ");
INSERT INTO awk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ġatun noa wiyayelléu̇n, wiyelliela, Pitȧl kakilliko bi Piriwȧl ko Eloi ko ġiroúmba ko yantin to búlbuúl lo ġiroúmba ko, ġatun yantin to marai to ġiroúmba ko, ġatun yantin to kaiyu ko ġiroúmba ko, ġatun yantin to kotellitó ġiroúmba ko; ġatun kóti ta ġiroúmba yanti ġintoa bo ba. ");
INSERT INTO awk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ġatun noa wiya bon, ġintoa wiyayelléu̇n tuloa; unni ta umulla ġatun moron koa bi kauwȧl ");
INSERT INTO awk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wonto noa ba kotelliela tuloa ko ninwoa bo, wiya bon noa Iéthunuġ, Ġan-ke tia kóti ta emmoúmba? ");
INSERT INTO awk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ġatun noa Iéthuko wiya, Taraikan waita uwa barán Hierothalem kabiruġ Jeriko kako, ġatun nuġgurrawa mankiye, mantilléu̇n bon kirrikin, ġatun búnkulla, ġatun bara waita uwa wareka ġaiya bon bu̇ntoara. ");
INSERT INTO awk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yakita ġati uwa wakȧl hiereu barán yapuġ koa; ġatun nakulla bon noa ba, uwa noa taruġ koa kaiyin ta koa. ");
INSERT INTO awk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ġanti yanti kiloa wakál Lebikan kakulla noa ba unta, uwa nakulla ġaiya bon, ġatun noa uwa taruġ koa kaiyin ta koa. ");
INSERT INTO awk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wonto ba wakál ku̇ri Thamariakȧl uwolliela ba, uwa yapariġ kakilliela noa ba; ġatun nakulla bon noa ba, minki bon noa kakulla ġikouġ kai, ");
INSERT INTO awk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ġatun uwa ġikouġ kai koba, ġatun ġira bon búntoara ġikoúmba, kiroabulliela kipai ġatun wain, ġatun yellawabunbéa bon ġikouġ ka ta kóti ka buttikaġ, ġatun yutéa bon takilliġél lako, ġatun miroma bon. ");
INSERT INTO awk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ġatun tarai ta purreȧġ ka wakȧl la waita noa ba uwa, mankulla ġaiya noa buloara denari, ġatun ġukulla kokeratin ko, ġatun bon wiya, Golomulla bon; kirun bi ba upinún, uwéa kȧnu̇n baġ ba willuġbo, ġutéa kȧnu̇n ġaiya banuġ. ");
INSERT INTO awk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wonnuġ-ke kóti ta ġikoúmba nuġgurrawa mankiye unti biruġ ġoro kabiruġ ku̇ri kabiruġ, kotella bi? ");
INSERT INTO awk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ġatun noa wiya, Niuwoa ġoloma bon. Wiya noa bon Iéthu ko, Yuriġ, yanti kiloa umulla bi. ");
INSERT INTO awk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ġatun yakita kakulla, uwa bara ba, uwa noa murruġ koa kokeroa; ġatun taraito nukuġko, Marȧthako yitirra, wamunbéa bon bounnoun kin kokerá. ");
INSERT INTO awk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wúġgunbai bounnoun ba ġaiya kai, yitirra Mari, yellawa bountoa Iéthu kin yallo ka, ġatun ġurra bon wiyellita ");
INSERT INTO awk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Wonto ba Marȧtha kȧmullan buntoa marai-marai umullita, ġatun uwa bountoa ġikouġ kin, ġatun wiya, Piriwál, kora bi natan tia wareka tia wúġgunbai emmoúmba umulliko wakȧllo? wiyella bounnoun umulli koa bountoa tia. ");
INSERT INTO awk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ġatun noa Iéthako wiyelléún, ġatun wiya bounnoun, Ela! Marȧtha, Marȧtha, ġintoa kȧmullan marai-marai minnambo-minnambo ka; ");
INSERT INTO awk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wonto ba wakȧl murrȧrȧġ kȧtan: ġatun Mariko bountoa ġeremulléu̇n unnoa murrȧrȧġbo, keawai wal mantillinún bounnoun kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ĠATUN yakita kakulla, wiyelliela noa ba tarai ta purrai ta, kaiulléu̇n noa ba wiyelli ta, wakȧllo bon wiya ġikouġ-ka-to wirrobullikanto, Piriwȧl, wiyella ġearun bi wiyelliko, yanti kiloa Ioanneto noa wiya barun ġikoúmba wirrobullikan. ");
INSERT INTO awk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ġatun noa wiya barun, wiyȧnu̇n nura ba, ġiakai nura wiyanu̇n nura, Biyuġbai ġearúmba wokka ka ba moroko ka ba kȧtan, Kȧmu̇nbilla yitirra ġiroúmba yirri-yirri kakilliko. Paipibunbilla Piriwȧl koba ġiroúmba. Ġurrabunbilla wiyellikanne ġiroúmba, yanti moroko ka ba, yanti ta purrai ta ba. ");
INSERT INTO awk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ġuwoa ġearun purreȧġ ka takilliko. ");
INSERT INTO awk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ġatun warekilla ġearúnba yarakai umatoara, kulla ġéen yanti ta wareka yanti ta wiyapaiyeún ġearúnba. Ġatun yuti yikora ġearun yarakai umullikan kolaġ; miromulla ġearun yarakai tabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ġatun noa barun wiya, Ġan nurun kinbiruġ kóti ġikoúmba, ġatun uwȧnu̇n ġikouġ kin tokoi ta, ġatun bon wiyȧnu̇n, Ela! kóti, mumbilla tia wokkai to ġoro ko; ");
INSERT INTO awk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kulla noa emmoúmba kóti uwa kaloġ tin emmouġ kinko, ġatun keawai baġ wún korien ġikouġ kin mikan ta takilliko? ");
INSERT INTO awk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Niuwoa murruġ ka ba ko wiyánún, Wai tia wiyellan; kulla unni kurraka wirriġbakulla, kulla wonnai tara emmoúmba emmouġ katoa ba birrikilliġél laba; keawaran baġ bouġkulli korien ġukilliko ġirouġ. ");
INSERT INTO awk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wiyan nurun baġ, Keawai noa bouġkulli korien ġulliko bon, kulla noa ba ġikoúmba kóti; kulla wal noa bon pirriral-mulli tin bouġkullinún ġaiya noa ġulliko bon wiyellinún noa ba. ");
INSERT INTO awk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ġatun nurun baġ wiyan, Wiyella, ġatun ġunu̇n ġaiya nurun; ġatun tiwolla, ġatun karawollinun ġaiya nura; wirrillia, ġatun umanu̇n ġaiya nurun. ");
INSERT INTO awk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yantin ba wiyellinu̇n, manu̇n wal; ġatun noa tiwollinu̇n, karawollinu̇n ġaiya noa; ġatun ġikouġ wirrillinu̇n noa ba, umȧnu̇n ġaiya wal. ");
INSERT INTO awk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yinallo ba wiyȧnu̇n nulai yantin ta nurun kin, biyuġbai ta ba, wiya, noa ġunu̇n tunuġ? ġa makoro, wiya, noa maiya ġunu̇n makoró? ");
INSERT INTO awk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ga ba wiyellan noa ba yarro, wiya, noa bon ġupaiyinu̇n wuarai? ");
INSERT INTO awk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nura ba yarakaikan kȧtan, ġukilliko ġutoara murrȧrȧġ wonnai ko nurúnba ko; kauwa yanti ġunu̇n noa Biyuġbaito moroko ka ba ko Marai murrȧrȧġ barun wiya bon ba? ");
INSERT INTO awk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ġatun noa ba paibuġgulliela wakȧl diabol, ġatun noa ġoġo. Ġatun yakita ġaiya kakulla, waita ba uwa diabol, wiya ġaiya noa ġoġo kabiruġ ko; ġatun bara ku̇ri kotelliela. ");
INSERT INTO awk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wonto ba tarai-kan-to wiya, Paibuġġa noa barun diabol Béeldhebul kȧtan biruġ, piriwȧlloa biruġ diabol koba ko. ");
INSERT INTO awk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ġatun tarai-kan-to wiyelliela, wiya bon túġa moroko tin. ");
INSERT INTO awk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wonto noa ba ġimilléu̇n barúnba kotellikanne, wiya barun, Yantin piriwȧl koba ġaruġgara umulla barabo tetti bara kȧnu̇n; ġatun kokerá koba barabo warakullia bara. ");
INSERT INTO awk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Thatan noa ba ġaruġgara kȧnu̇n niuwoa-bo, yakoai ġikoúmba piriwȧl koba kȧnu̇n? kulla nura wiyan paibuġga bag ba barun diabol Béeldhebul katoa biruġ. ");
INSERT INTO awk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ġatun ġatoa ba paibuġgȧanu̇n barun diabol Béeldhebul biruġ, ġan katoa biruġ nurúnba-ko yinal-lo paibuġga? ");
INSERT INTO awk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gatoa paibuġgȧnu̇n mȧttȧrroa biruġ Eloi koba ko barun diabol, kauwa tuloa uwa ġaiya piriwȧl koba Eloi koba nurun kin ba. ");
INSERT INTO awk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ġolomȧnu̇n noa ba tarai ku̇ri mokȧl porrol ġikouġ kin kokerá, ġikoúmba tullokan murroi kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wonto ba tanan uwȧnun tarai mokȧl porrolkan kauwȧl kan ġikouġ kin, ġatun kéakéa-ma noa bon, mantillinu̇n ġaiya wal bon kirun mokȧl ġikoúmba pirriral-matoara; ġatun ġutillinu̇n noa mokȧl ġikoúmba. ");
INSERT INTO awk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Niuwoa keawai emmouġ katoa, niuwoa kȧtan kóti korien; ġatun noa keawai boa-ma korien emmouġ katoa, ware-ware-kan. ");
INSERT INTO awk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Paikullinu̇n ba marai yarakai ku̇ri kabiruġ, uwan noa yuriġ purroi toa tarawaroa, nakilliko korilliko; ġatun noa keawai na korien, wiyan noa, Willuġbanu̇n wal baġ willuġbo kokerá ko emmouġ ka ta ko, unta biruġ uwa baġ ba. ");
INSERT INTO awk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Gatun uwȧnún noa ba, nakulla ġaiya noa ba wiréa kiriiri ġatun konéin. ");
INSERT INTO awk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Uwan ġaiya noa ġatun yutéa taraikan theben ta marai yarakai kauwȧl yanti niuwoa ba; ġatun bara uwa murrariġ ġatun kakulla ġaiya bara unta; ġatun yarakai kauwȧl noa unnoa kȧtan yakita, kakulla noa ba kurri-kurri. ");
INSERT INTO awk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ġatun yakita kakulla, wiyelliela noa ba, kaaibulléu̇n tarai nukuġ ġali koba konara koba, ġatun wiya bon bountoa, Murrȧrȧg kauwa yanti pika kurréa bon ba, ġatun paiyil pitta bi ba. ");
INSERT INTO awk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wonto noa bo wiya, Kauwa yanti, murrȧrȧġ kauwȧl kȧtan bara ġurrullikan wiyellikanne Eloi koba, ġatun mirromulli-ko. ");
INSERT INTO awk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ġatun yakita kakulla, wittillan bara ba ku̇ri, wiya noa kurri-kurri, Unni ta yarakai kȧtan willuġġél; nakillin bara tu̇ġa; keawai wal barun ġunu̇n, unni bo ta wal tuúġa Iona-u̇mba propet koba. ");
INSERT INTO awk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yanti kiloa Iona túġa kakulla noa barun ku̇ri Ninebi ka, yanti bo ta wal kȧnu̇n noa yinal ku̇ri koba barun ġali ko willuġgél ko. ");
INSERT INTO awk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bouġkullinu̇n wal piriwȧl kirin pakai biruġ purreȧġ ka wiyelliġél la ku̇ri koa untikȧl loa willuġgél loa, ġatun pirralmanu̇n barun; kulla bountoa uwa kaloġ kabiruġ purrai tabiruġ wirán tabiruġ ġurrulli bon ġuraki ko Tholomón ko; A! kauwȧl kȧtan Tholomón kiloa unnibo. ");
INSERT INTO awk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bouġkullinu̇n wal bara ku̇ri Ninebikȧl purreȧġ ka wiyelliġél la ku̇ri koa untikȧl loa willuġgél loa, ġatun pirral-manu̇n barun; kulla bara minki kakulla wiyelli ta Iona-úmba ka; A! kauwȧl kȧtan Iona kiloa unnibo. ");
INSERT INTO awk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Keawai ku̇riko tarai-kan-to wirrouġ buġgȧnu̇n kaibuġ wunu̇n ġaiya ġati ta, keawai baria ka wimbi ka, wonto ba kaibugġél la, bara ba uwȧnu̇n na-uwil koa bara kaibuġ. ");
INSERT INTO awk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kaibuġ ta murrin koba ġaikuġ; wonto ba ġiroúmba ġaikuġ tuloa kȧtan, yantin bin kȧtan murrin kaibuġkan; wonto bin ba ġaikuġ yarakai, kȧnu̇n murrin bin warapa tokoi to. ");
INSERT INTO awk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yakoai bi, mirka unnoanuġ kaibuġ ġirouġ kinba tokoi ta ba kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kulla ba yantin ta ġiroúmba murrin ta ba warapan kaibuġ ko, keawai taraikan tokoi, kȧnu̇n yantinbo ta wal warapan kaibuġ ko, yanti kaibuġ koba wupin ġatun binkirréu̇n. ");
INSERT INTO awk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ġatun wiyelliela noa ba, taraito Parithaioko wiya bon tauwil koa noa ġikouġ katoa; ġatun noa uwa murrariġ ġatun yellawa takilliko. ");
INSERT INTO awk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ġatun noa ba Parithaioko nakulla, umulli korien noa bato ka kurri-kurri takilli kolaġ, kotelliela noa. ");
INSERT INTO awk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ġatun bon noa Piriwȧllo wiya, Yakita nura Parithaioiko umullia mirkun karai-ġon tunti ġatun pikirri; wonto ba nurúnba murrin warapan williró ġatun yarakai to. ");
INSERT INTO awk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Woġkȧl nura! yan ta noa uma unnoa yanti unnoa ba warrai ta ba, yantibo uma noa murruġ ka ba? ");
INSERT INTO awk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Guwa nura untoakȧl nurun kinbiruġ, ġatun yantin nurun ba tuloa ka kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yapal nura Parithaioi! kulla nura ġukillan wintakȧl mentha tabiruġ, ġatun ruta tabiruġ, ġatun yaki tara, ġatun ġurramaiġan tuloa ġatun pitȧlumullikanne Eloi koba: unni tara nura uma pa, ġatun keawai taraikan wareka pa uma korien. ");
INSERT INTO awk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yapal nura Parithaioi! kulla nura pitȧlman yellawollikanne wokka kaba thunagóg kaba, ġatun umullikanne ġukilliġél lako. ");
INSERT INTO awk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yapal nura ġarammateu ġatun Parithaioi, ġakoiyaye! kulla nura yanti tulmun kiloa paipi korien, ġatun bara ku̇ri uwan wokka laġ tulmun toa, keawaran bara na korien. ");
INSERT INTO awk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wiyayelléu̇n ġaiya wakȧllo nomiko-ko wiyelliela bon, Piriwȧl, ġiakai bi wiyan, pirralman bi ġearun. ");
INSERT INTO awk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ġatun noa wiya, Yapal nura nomikoi yantinbo! kulla nura wuntan ku̇ri ka porrol ta lo kauwȧl porrol kurrilliko, ġatun keawai nura unnoa porrol numa korien nurun ka to mȧttȧrró. ");
INSERT INTO awk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yapal nura! kulla nura ba wittiman tulmun barúnba propet koba, ġatun biyugbaito nurúnba-ko bunkulla barun tetti kulwon. ");
INSERT INTO awk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kauwa tuloa ta pirralman nura umatoara biyuġbai koba nurúnba; kulla bara yuna bo ta barun búnkulla tetti, gatun nura wittillin tulmun barúnba. ");
INSERT INTO awk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yaki tin wiya ġurakita Eloi koba ko, Yukȧnún wal baġ barun propet ġatun apothol barun kin, ġatun winta barun kinbiruġ búnnu̇n wal bara ġatun yarakai umȧnu̇n; ");
INSERT INTO awk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wiya-uwil koa ġoroġ yantin koba propet koba kiroabatoara yaki tabiruġ kurri-kurri tabiruġ purrai tabiruġ, unni barun willuġgél; ");
INSERT INTO awk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ġoroġ kabiruġ Abelúmba kabiruġ, ġoroġ kako Dhakariaúmba kako búntoara Willi ka bómo ta ġatun hieron; kauwa tuloa to wiyan nurun baġ, wiya-uwil koa unni barun willuġgél. ");
INSERT INTO awk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yapal nura nomikoi! kulla nura mankulla wirriġbakilliġél ġurakita koba; keawai nura wa pa, ġatun nura miya barun uwa bara ba. ");
INSERT INTO awk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ġatun wiya noa ba unni tara barun, pirriralma bon bara gȧrammateuto ġatun Parithaioiko, wiya-uwil koa noa minnambo wiyelliko; ");
INSERT INTO awk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mittillin bara bon, ġatun nakillin ġurrulliko ġikouġ kin ba ko kurraka ba ko, wiyayeún koa bara bon. ");
INSERT INTO awk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","YAKITA kakulla, wittillan bara ba yantibo konara kúri, wata-watawollan barabo, wiya noa kurri-kurri barun wirrobullikan ġikoúmba, Yakoai nura lebben barúnba Parithaioi koba,ġakoiyaye ta unnoa. ");
INSERT INTO awk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yantin ba wutéa ta túġunbinu̇n ġaiya wal; ġatun yantin yuropa ta namunbinu̇n ġaiya wal. ");
INSERT INTO awk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yaki tin, wiyellan nura tokoi ta ġurrabunbinún wal kaibuġ ka; ġatun unni ta wiya nura ba ġurréuġ ka waiyakan ta, wiyellinu̇n wal wokka ka kokera. ");
INSERT INTO awk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ġatun baġ nurun wiyan kóti ta emmoúmba, Kinta kora nura barun kin búnkillikan tin murrin tin, ġatun yukita tantoa bo ta wal bara kaiyukanto banu̇n. ");
INSERT INTO awk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Túġunbinún wal baġ nurun ġan-kai nura kinta wal kȧnu̇n: Kinta bon kauwa ġikouġ kai, yukita noa ba búnkulla kaiyukan noa warekulliko koiyuġ kako pirriko kako; kauwa wiyan baġ nurun, Kinta bon kauwa ġikouġ kai. ");
INSERT INTO awk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wiya, pente tibbin waréa ta ġupaiye ko buloara assari, ġatun keawai wakȧl unti biruġ woġgunti korien ġikouġ kin Eloi kin? ");
INSERT INTO awk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kulla yantin wolluġ kaba kittuġ murrapatoara kȧtan. Kinta kora nura ġali tin; kulla nura murrȧrȧġ kauwȧlkan kȧtan, keawaran ġali tarako tibbinko waréa-ta-ko kauwȧl-kauwȧl-ko. ");
INSERT INTO awk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Unni ta nurun baġ wiyan, Yantinto emmouġ wiyȧnu̇n mikan ta ku̇ri ka, ġikouġ wiyȧnu̇n noa Yinal ku̇ri koba mikan ta aġelo ka Eloi koba ko. ");
INSERT INTO awk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wonto ba niuwoa ġanbullinu̇n tia emmouġ mikan ta ku̇ri ka, ġanbullinu̇n wal bon mikan ta aġelo ka Eloi koba ka. ");
INSERT INTO awk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ġatun ġanto ba yarakai wiyȧnu̇n ġikouġ Yinal ku̇ri koba, kȧmunbinu̇n wal bon; wonto bon ba yarakai wiyellikan Maraikan yirri-yirri-kan, keawai bon kȧmunbinu̇n. ");
INSERT INTO awk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ġatun manu̇n nurun bara thunagóg kako ġatun wiyellikan tako, ġatun kaiyukan tako, kota yikora nura wonnuġ nura ba wiyayellinu̇n, ġa minnuġ nura wiyȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kulla nurun Marai-kan-to yirri-yirri-kan-to wiyȧnu̇n wal yakita bo ġaiya minnuġ wal nura wiyȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ġatun wiya bon wakȧllo konara biruġ ko, Piriwȧl, wiyella emmoúmba biġgainuġ,ġukulli koa noa purrai emmouġ kai. ");
INSERT INTO awk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ġatun noa bon wiya, Ku̇ri, ġanto tia uma wiyellikan, ġa ġukillikan ġirouġ kin? ");
INSERT INTO awk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ġatun noa barun wiya, Yakoai ġatun murroi kauwa williri koba; kulla moron ku̇ri koba ka korien ta kauwȧl-kauwȧl la tul lokan ka ġikouġ ka ta. ");
INSERT INTO awk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ġatun noa wiya barun unni parabol, wiyelliela, Purrai ta porrólkan koba poaikulléu̇n kauwȧl: ");
INSERT INTO awk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ġatun noa kotelléu̇n niuwoabo, wiyelliela, Minnuġ banu̇n baġ, kulla wal unni tuntan uwa, wiya wal baġ wonta wura-uwil unni tara emmoúmba? ");
INSERT INTO awk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ġatun noa wiya, Unni baġ umȧnu̇n; umȧnu̇n wal baġ barán wunkilliġél emmoúmba, ġatun wittia kȧnu̇n kauwȧl; ġatun unta baġ wunu̇n yantin emmoúmba nulai ġatun tullokan. ");
INSERT INTO awk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ġatun baġ wiyȧnún emmoúmba marai, A marai! Kauwȧl tullokan ġiroúmba wúnkulla kauwȧl lako wunȧl lako; yellawolla murroi bi, tauwa, pittella, ġatun pitȧl kauwa. ");
INSERT INTO awk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wonto ba Eloito bon wiya, Woġkȧl-lan bi! unti tokoi ta ġiroúmba marai mantillinu̇n wal ġirouġ, kinbiruġ; ġanto ġaiya unnoa tara tullokan manu̇n tuiġko bi ba uma? ");
INSERT INTO awk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yanti niuwoa ba wupéakan tullokan ġikoúmba ko, ġatun keawai porrol korien Eloi kai koba. ");
INSERT INTO awk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ġatun noa wiya barun wirrobullikan, Yaki tin wiyan baġ nurun, Yanoa, kota yikora nurúnba moron takilliko; ġa keawai murrin ko wupulliko. ");
INSERT INTO awk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Moron ta kauwȧl kȧtan murrȧrȧġ takillikanne keawaran, ġatun murrin ta kauwȧl kȧtan murrȧrȧġ kirrikin keawaran. ");
INSERT INTO awk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kotella wákun barun; koito bara ba keawai wupa korien, ġatun keawai kol bunti korien; keawai barúnba tuiġko wupilliġál, keawai barúnba kokera; ġatun noa Eloito ġiratiman barun; kauwȧl-kauwȧl nura kȧtan murrȧrȧġ tibbin bara keawaran. ");
INSERT INTO awk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ġatun ġan nurun kinbiruġ kotellita kȧnu̇n, uméa kȧnu̇n moron ġikoúmba waréa ka kakilliko kubit kako? ");
INSERT INTO awk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wiya nura ba kaiyu korien to umulliko unni waréa, minariġ tin nura kotellin unnoa tara? ");
INSERT INTO awk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kotella nura kenuku̇n turukin bara ba; keawai bara uma korien wupi korien bara; ġatun baġ wiyan nurun, Tholomón noa ba, konéinkan keawai bon wupa korien yanti kiloa wakȧl unti tara biruġ. ");
INSERT INTO awk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Upȧnu̇n noa ba Eloito woiyo yanti, yakita purreȧġ ka unta ba purrai ta kȧtan, ġatun kumba warekakin murruġ ka wollo ka; wiya, nurun noa upȧnu̇n, A! nura ġurrullikan waréakan? ");
INSERT INTO awk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ġatun na-ki yikora nura minariġ nurúnba takilliko ġatun pittelliko, ġa kota yikora nura minki ko. ");
INSERT INTO awk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Koito ba bara yantinto purrai ta ba ko natan yantin unni tara; ġatun nurúnba-to-Biyuġbai-to ġurran unni tara ġukillikanne nurun ba murrȧrȧġ kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wonto ba nura nauwa piriwȧl koba Eloi koba, ġatun yantin unni rara ġunun nurun kin. ");
INSERT INTO awk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kinta kora, wirrul waréa; kulla pitȧlman bon Biyuġbai nurúnba ġukilliko piriwȧl-ġél ta nurun kin. ");
INSERT INTO awk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ġukilléa nurúnba, ġatun ġuwa ġukillikanne: umulla nura yinuġ nurúnba, keawai koa korokȧl katéa-ku̇n, porrólkan ta moroko ka ba kakilliko ka korien kakilliko, keawai ba unta ko uwa korien mankiye, ġatun keawai ba yarakai puntaye. ");
INSERT INTO awk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wonnun ta nurúnba tullokan, untabo kȧnu̇n nurúnba búlbúl yantibo. ");
INSERT INTO awk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ġirullia nura winnal nurúnba, ġatun nurúnba kaibuġ winabunbilla; ");
INSERT INTO awk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ġatun nurabo yanti kiloa ku̇ri ba mittillin barúnba ko Piriwȧl ko willuġ-banu̇n noa ba mankilliġél labiruġ; uwȧnu̇n noa ba ba tanan ġatun wirrillinu̇n, umȧnu̇n ġaiya bon tanoa-kal-bo. ");
INSERT INTO awk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pitȧlmatoara kȧnu̇n bara unnoa tara mankillikan, yakita Piriwȧl noa ba uwȧnu̇n, noa ba barun kin nanún noa ba barun nakilli ta; wiyan bag tuloa nurun, ġirullinu̇n noa kótibo, ġatun yellawabumbéa barun takilli kolaġ, ġatun uwȧnu̇n noa ġukilliko barun. ");
INSERT INTO awk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ġatun tanan uwȧnún noa ba, yakita buloara nakillikan ta, yakita ġoro ka nakillikan ta, ġatun nanu̇n barun yantibo nakilli ta, pitȧlmatoara bara unnoa tara mankillikan. ");
INSERT INTO awk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ġatun ġurrulla unni, wiya noa ba kokera-tin-to ġurra pa, yakounta ba uwa pa mankiye na pa noa, keawai ġaiya kokera ġikoúmba potobunti pa. ");
INSERT INTO awk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yanti tin kauwa nura nakilliko; kulla noa Yinal ku̇ri koba uwȧnu̇n yakita kota korien nura ba. ");
INSERT INTO awk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wiya ġaiya noa bon Peterko, Piriwȧl, wiyan bi unni parabol ġearunbo, ġa ġearun yantin? ");
INSERT INTO awk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ġatun noa Piriwȧllo wiya, Gan-ke noa mankillikan murrȧrȧġ ġatun ġuraki, piriwȧllo noa umȧnu̇n bon wiyellikan kakilliko kokera ko ġikoug ka ta ko, ġu-uwil koa noa takilliko yakita ġukilliġél la? ");
INSERT INTO awk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pitȧlmatoara kȧtan unnoa mankillikan, umȧnu̇n noa ba ġikoúmba piriwȧl nanu̇n ġaiya noa bon umulli ta yanti. ");
INSERT INTO awk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wiyan baġ tuloa, umȧnu̇n bon noa wiyellikan kakilliko yantin tako. ");
INSERT INTO awk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wonto noa ba wiyȧnu̇n gala mankilli-kan-to, búlbúl la, Emmoúmba piriwȧl minkin uwa korien; ġatun ġaiya noa búnkilli kolaġ barun ku̇ri mankillikan ġatun ġapal, ġatun takilli kolaġ, ġatun pittelli kolaġ, ġatun kuttawai kolaġ; ");
INSERT INTO awk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Piriwȧl ġala koba mankillikan koba uwȧnún wal noa purreȧġ ka na korien ta, ġatun yakita ġaiya kota korien ta bon, ġatun bu̇nnu̇n bon buloarakan, ġatun ġunu̇n bon winta ġikouġ kai barun kin ġurra korien ta. ");
INSERT INTO awk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ġatun unnoa mankillikan ġurran noa kotelli ta piriwȧl koba ġikoúmba, ġatun keawai uma korien, keawai noa uma pa yanti kotelli ta ġikoúmba, búnnún wal ġaiya bon kauwȧl-kauwȧl. ");
INSERT INTO awk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wonto noa ba niuwoa ġurra korien, ġatun yarakai umatoara yaki tin bún ba bon, búnnún wal waréa. Kulla bon ġupa kauwȧl, wiyapaiyȧnu̇n wal kauwȧl ġikouġ kinbiruġ; ġatun kúriko ġukulla kauwȧl, wiyellia kȧnún bara ġaiya kauwȧl-kauwȧl ġikouġ kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Uwan ta baġ unni yukulliko koiyuġ ko purrai ta ko; minnuġ-bullinún baġ kauwa ba tanoa-kal-bo wirroġ-kulléa? ");
INSERT INTO awk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kulla tia korimullikanne emmouġ kinba korimulliko; ġatun yakoai baġ kȧtan ġoloin koa ka-uwil kakilliko! ");
INSERT INTO awk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kotan nura, uwa baġ ba pitȧl ġukilliko purrai ta ko? wiyan baġ ba, keawai; wonto ba ġurruġgurra kakilliko; ");
INSERT INTO awk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kulla wal unti biruġ kȧnu̇n kakilliko pente kokerá wakȧl la, ġurruġgurra biruġ, ġoro bulun kinbiruġ, ġatun buloara ġoro kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Biyuġbai ġurruġgurra kȧnu̇n yinal labiruġ, ġatun yinal biyuġbai tabiruġ; ġatun tunkan yinȧlkun tabiruġ, ġatun yinȧlkun tunkán tabiruġ, túnġaikun bounnoun ba kurrinanbai tabiruġ, ġatun kurrinanbai bounnoun ba túnġaikun tabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ġatun noa barun ku̇ri wiya, Nanún nura ba yareil wokka laġ punnȧl ba pulóġkulliġél lin, wiyȧnu̇n ġaiya nura koiwon tanan ba; ġatun kauwa yanti. ");
INSERT INTO awk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ġatun kareawuġ ba kȧnu̇n, wiyellinún ġaiya nura, karol kȧnu̇n; ġatun yanti ġaiya kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","A nura nakoiyaye! natan nura tarkin moroko koba ġatun purrai koba; minariġ tin koa nura na korien unti yakita? ");
INSERT INTO awk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kauwa, kora koa nura kota ba nurun kinbiruġ tuloa? ");
INSERT INTO awk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Uwȧnu̇n bi ba ġikouġ katoa bukkakan toa ġikouġ kinko wiyellikan tako, yapuġ koa nuiyellia bi bon, wamunbi-uwil koa biloa murroi kakilliko ġikouġ kinbiruġ; yutéa-ku̇n koa biloa wiyellikan kauwȧl lako, ġatun wiyellikanto kauwállo wamunbinu̇n biloa yarakan tako, ġatun yarakanto wupinún biloa jail kako. ");
INSERT INTO awk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wiyan banuġ, keawai bi waita uwa korien unta biruġ, ġukillinun bi ba lepton ta kirun waréa ta. ");
INSERT INTO awk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","KAKULLA bara unta yakita taraikan, wiya bon barun Galilaiakȧl, ġoroġ barúnba taroġkama Pilato-to thuhia barun barúnba. ");
INSERT INTO awk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ġatun noa Iéthuko wiyayelléu̇n, wiyelliela noa barun, Wiya, nura kotellin unnoa tara Galilaiakȧl yarakai bara kakulla kauwȧl barun kinbiruġ Galilaiakȧl labiruġ, kulla barun ba mankulla unnoa tara? ");
INSERT INTO awk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wiyan nurun baġ, Keawai; kulla nura keawai minki kȧtan, yantin ġaiya nura tetti tetti kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ga barun etin ta wunkulléún kokera barán, ġatun tetti-tetti barun wirria, wiya, nura kotellin barun yarakai bara ba kakulla kauwȧl barun ku̇ri kabiruġ kakillin Hierothalem ka? ");
INSERT INTO awk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wiyan nurun baġ, Keawai; kulla nura keawai minki kȧtan, yantin ġaiya nura tetti-tetti kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wiya noa unni yanti parabol: Taraikan ta ku̇riko wupéa yirriwilbin purrai ta ġikouġ ka ta; ġatun noa uwa yeai ko nakilliko, ġatun noa keawai ġaiya na pa. ");
INSERT INTO awk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wiya ġaiya noa bon upullikan, Ela! ġoro ka wunȧl la unti, uwa baġ nakilliko yeai ko unti biruġ ko yirriwiltabin tako, ġatun keawai ġaiya baġ na pa; kólbúntilla unnoa barán; minariġ, tin unnoa kȧtan purrai ta? ");
INSERT INTO awk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ġatun noa wiyayeléu̇n, wiyelliela bon, Piriwȧl, kȧmunbilla unnoa unti wunȧl la, pinni-uwil koa baġ untoakȧl ko, ġatun konuġ koa baġ wupi-uwil; ");
INSERT INTO awk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ġatun yeai ba kȧnu̇n, murrȧrȧġ ġaiya kȧnu̇n; ġatun ka korien ba, ġatun yukita ġaiya kólbúntinu̇n; wal bi unni barán. ");
INSERT INTO awk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ġatun noa wiyelliela wakȧl la thunagóg ka purreȧġ ka thabbat ka. ");
INSERT INTO awk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ġatun, a! kakulla unta wakȧl nukuġ munni-lan bountoa ba kauwȧl-kauwȧl wunȧl étin ta, ġatun woinu bountoa, ġatun keawai bountoa kaiyu korien wokka-lan kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ġatun nakulla noa ba Iéthuko bounnoun, kaaipa bounnoun noa, ġatun wiyelliela bounnoun, Nukuġ, ġintoa buruġ-kulléu̇n woinu kabiruġ ġirouġ kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ġatun noa upilléu̇n mȧtȧra bounnoun kin; ġatun tanoakal-bo bounnoun tuloa uma, ġatun bountoa pitȧlma bon Eloinuġ. ");
INSERT INTO awk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ga-tun piriwȧllo thunagóg kako, wiyayelléu̇n bukka-kan-to, kulla noa Iéthuko turon uma purreȧġ ka thabbat ka, ġatun wiya barun ku̇ri, Hek ta purréȧġ ka umilliko ku̇ri ko; unti tara purreȧġ ka tanan uwolla turon umullilo, ġatun keawai thabbat ta purreȧġ ka. ");
INSERT INTO awk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Piriwȧllo noa bon wiyayelléȧn ġatun wiyelliela, Ġintoa ġakoiyaye! wiya, yantinto nura buruġbuġgan ġikoúmba boo ġatun athino, purreȧġ ka thabbat ka, unta biruġ kokerá biruġ, yemmama-uwil koa kokoin kolaġ pittelliko? ");
INSERT INTO awk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ġatun keawai wal unni ġapal, yinálkun ta Abu̇ramúmba, ġiratoara bounnoun Thatánto noa unni tara étin ta wunȧl la, buruġbuġgulliko yanti biruġ, unti thabbat ta purreȧġ ka? ");
INSERT INTO awk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ġatun wiya noa ba unni tara, koiyun bara ġaiya kȧtan yantin bukkamaiye ġikouġ kai; ġatun yantin ku̇ri pitȧl kakulla yantin tin umatoarrin kauwȧl lin ġikouġ, biruġ. ");
INSERT INTO awk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Wiya ġaiya noa, Minariġ kiloa Piriwȧl koba Eloi koba? Ġatun yakoai kiloa paġgunbinu̇n? ");
INSERT INTO awk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yanti kiloa ta yeai ba mutard koba, mankulla ku̇riko, ġatun meapa purrai ta ġikouġ, kai ta; ġatun boaikulléu̇n wokka laġ, ġatun kakulla kauwȧl ku̇lai; ġatun tibbin moroko tin yellawa wiran ta. ");
INSERT INTO awk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ġatun noa wiyéa-ku̇n, Yakoai kiloa baġ tu̇ġunbinu̇n piriwȧl koba Eloi koba? ");
INSERT INTO awk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yanti lebben kiloa, mankulla ġapallo ġatun yuropa ġoro ka ġukilliġél la nulai ta, kakulla wal yantibo lebben kiloa. ");
INSERT INTO awk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ġatun noa uwa kokeroa ġatun kauwȧl loa kokeroa, wiyatin, ġatun uwollin Hierothalem kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wiya ġaiya bon wakȧllo, Piriwȧl, wiya, warai moron kakilliko? Ġatun noa wiya barun, ");
INSERT INTO awk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nuwolla pulóġkulli kolaġ tuloa tin yapuġ tin: kulla baġ nurun wiyan, kauwȧl-kauwȧllo nuwanu̇n murrȧraġ pulóġkulli kolaġ ġatun keawai wal kaiyu korien. ");
INSERT INTO awk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bouġkullinu̇n noa ba kokeratin wokka laġ, ġatun wirriġbakulla pulóġkulliġél, ġatun nura ġarokéa warrai ta, ġatun wirrilléu̇n toto pulóġkulliġél, wiyellin, Piriwȧl, Piriwȧl, umulla ġearun; ġatun noa wiyayellinu̇n ġatun wiyȧnu̇n, Keawaran baġ nurun ġimilli korien wonta biruġ wal nura: ");
INSERT INTO awk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wiyánu̇n ġaiya wal nura, Takéu̇n ġéen ġatun pittakéu̇n ġirouġ kin mikan ta, ġatun ġintoa wiyakéu̇n ġearun kin yapuġ ka. ");
INSERT INTO awk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wonto wal noa ba wiyȧnu̇n, Wiyan baġ nurun, keawaran baġ nurun ġimilli korien, wonta biruġ wal nura; yuriġ tia uwolla emmouġ kinbiruġ, yantin nura yarakai umullikan. ");
INSERT INTO awk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Unta ta wal tuġkillinu̇n ġatun tirra-ġatpuntullinu̇n, nanu̇n ġaiya nura ba barun, Abȧramnuġ, ġatun Ithȧknuġ, ġatun Yacóbnuġ, ġatun yantin propetnuġ, kakillin bara ba piriwȧl koba ka Eloi koba, ġatun nurunbo yuaipéa warrai tako. ");
INSERT INTO awk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ġatun bara uwȧnu̇n muriuġ tin, ġatun krai tin, ġatun kummari tin, ġatun pakai tin, ġatun yellawȧnu̇n wal piriwȧl koba ka Eloi koba ka. ");
INSERT INTO awk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ġatun, a! bara willuġ kȧtan, kabo wal bara ġanka kȧnu̇n ġatun bara ġanka kȧtan, kabo wal bara willuġ kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Unta purreȧġ ka winta uwa Parithaioi kabiruġ wiyellin bon, Yuriġ ba waita wolla unta biruġ, kulla noa Herodto biloa buúnnu̇n tetti. ");
INSERT INTO awk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ġatun noa barun wiyá, Yuriġ nura wolla, wiya-uwil koa bon unnoa alópék, A! paibuġgan baġ barun diabol, ġatun turon baġ uman buġgai ġatun kúmba, ġatun kúmba-ken-ta wal ġoloin tia kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yantin tin uwȧnu̇n wal baġ buġgai ġatun kúmba, ġatun kúmba-ken-ta; kulla wal keawaran wal wakȧl propet ka korien tetti Hierothalem kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yapallun Hierothalem, Hierothalem! búnkiye tetti wirriye barun propet, ġatun pintia barun tunuġ ko yupitoara ġirouġ kinko; murrin-murrin baġ kauma pa baġ barun wonnai tara ġiroúmba, yanti kiloa tibbinto ba kauma-uwil yirriġ ka bara ka bounnoun ba waréa tara, ġatun keawaran nura kauma korien. ");
INSERT INTO awk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A! nuru̇nba kokera kakillin mirrȧl kakilliko: ġatun baġ wiyan tuloa nurun, Keawai nura tia nanu̇n, yakita ko kȧnu̇n ba wiyȧnu̇n wal nura ba, Pitȧlkȧmunbilla bon uwan noa ba yitirroa Piriwȧl koba koa. ");
INSERT INTO awk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ĠATUN yakita kakulla, uwa noa ba murrariġ kokerȧ piriwȧl koba ka Parithaioi koba takilliko nulai ko purreȧġ ka thabbat ka, tumiméa ġaiya bon bara. ");
INSERT INTO awk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ġatun, a! ġaroka ba kakulla wakȧl ku̇ri kokoin-kan warakaġ. ");
INSERT INTO awk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ġatun Iéthuko noa wiyayelléu̇n wiya barun nomikoinuġ ġatun Parithaioinuġ, wiyelliela, Wiya, murrȧrȧġ turon umulliko purreȧġ ka thabbat ka? ");
INSERT INTO awk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ġatun bara tullama pulli. Ġatun noa bon turon uma, ġatun wamunbéa bon; ");
INSERT INTO awk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ġatun wiyayelléu̇n noa barun, wiyelliela, Ġanto nurun kinbiruġ-ko puntimanu̇n buttikaġ ba athino ba ġa boo ba nuru̇nba kirai ta, ġatun keawai ġaiya bon manu̇n wokka laġ purreȧġ ka thabbat ka? ");
INSERT INTO awk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ġatun keawai bara bon wiyayelli pa unni tara. ");
INSERT INTO awk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ġatun noa wiya wakȧl parabol barun ġala ko wiyatora ko, nakulla noa ba ġiriméa bara murrȧrȧġ waiyakan; wiyelliela barun, ");
INSERT INTO awk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Wiyȧnu̇n bin ba taraito ku̇riko uwa-uwil koa bi mankilli kolaġ nukuġ kolaġ, yellawa yikora wokka waiyakanto, mirka ta tarai ku̇ri piriwȧl wlyatoara ta; ");
INSERT INTO awk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ġatun noa ninwoa wiya biloa ġatun ġikouġ tanan uwolliko ġatun wiyelliko bin, Ġuwa bon ġali ko; ġatun ġintoa koiyun bi ba kȧnu̇n waita uwȧnu̇n waiyakan kolaġ bará ka bo. ");
INSERT INTO awk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wonto ba bin wiyȧnu̇n ba, yuriġ bi yellawolli ta ka barȧ kako waiyakan kako; ġatun uwȧnu̇n noa ba wiya biloa ba wiyȧnu̇n biloa, Kóti, yuriġ wokka laġ uwolla: yakita ġaiya pitȧlmȧnu̇n bin mikan ta barun kin tanu̇n ba kunto ġirouġ katoa. ");
INSERT INTO awk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ġan umullinu̇n ninwoa bo wokka kako, umȧnu̇n wal bon bará kako; ġatun ninwoa umullinu̇n niuwoa ba bará kako, umullinu̇n wal wokka kako. ");
INSERT INTO awk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wiya ġaiya noa ġala wiya bon noa ba, Ġunu̇n bi ba takilliko búlwára ka ġa yaréa ka, wiya yikora bi ġirou̇mba kóti, ġa kótita, ġa porrólkan; wiyéa kȧnu̇n bin ba bara, ġatun ġupaiyéa kȧnu̇n bin yaruġ ka. ");
INSERT INTO awk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wonto bi ba umȧnu̇n takilliko, wiyella barun mirrȧl-mirrȧlkan, ġatun munni-munni-kan, ġatun wiir-wiirkan, ġatun munminkan: ");
INSERT INTO awk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ġatun bin pitȧlmanu̇n; kulla bara keawai ġupaiye korien yaruġ ka; kulla bin ġupaiyéa kȧnu̇n yaruġ ka, yakita ba moron kȧnu̇n murrȧrȧġ-tai tetti-tetti kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ġatun wakȧl barun kinbiruġ yellawa ġikouġ kin takilliela,ġurra noa ba unni tara, wiya bon noa, Pitȧlmatoara noa tanu̇n wal kunto piriwȧl lako Eloi koba ka. ");
INSERT INTO awk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wiya ġaiya noa bon, Taraito ku̇riko wupéa kauwȧl takilliko yaréa ka, ġatun wiya barun kauwȧl-kauwȧl kuri: ");
INSERT INTO awk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ġatun yarea ka yuka noa bon ġikoúmba mankillikan, wiyelliko barun wiyatoara ko, Tanan; kulla yantin unnuġ tara wupea yakita. ");
INSERT INTO awk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ġatun bara yantin wiyellan wakȧl-wakȧl ġakoiyellan. Kurri-kurrito wakȧllo wiya ġikouġ, Ġukilléu̇n baġ winta purrai, ġatun waita wal baġ uwȧnu̇n nakilliko ġala ko; wiyan biloa wamunbilliko tia. ");
INSERT INTO awk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ġatun taraito wiyȧ, Ġukilléu̇n baġ pente tumba boo buttikaġ, ġatun baġ waita uwan numulliko barun; wiyan biloa wamunbilliko tia. ");
INSERT INTO awk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ġatun taraito wiyá, Mankulla baġ nukuġ emmoúmba, yaki tin keawai baġ uwa korien. ");
INSERT INTO awk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Uwa ġaiya noa unni mankillikan, ġatun wiya bon piriwȧl ġikoúmba unni tara. Wiya bon ġaiya noa kokeratinto bukka-kanto ġikou̇mba mankillikan, Yuriġ wolla kurrakai yapuġ koa kokeroa, ġatun yutilla barun tanan untiko mirrȧl-mirrȧl-kai, ġatun munni-munni-kai, ġatun wiir-wiir-kai, ġatun munmin-kai. ");
INSERT INTO awk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ġatun noa mankillikanto wiyȧ, Piriwȧl, upatoara ta yanti bi ba wiya, ġatun kauwȧl-kauwȧl lako ka untiko. ");
INSERT INTO awk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ġatun noa bon piriwȧllo wiya mankillikan, Yuriġ, uwolla yapuġ koa ġatun koruġ koa, ġatun pirriralmulla barun tanan uwolliko, emmoúmba koa kokera warapa-uwil. ");
INSERT INTO awk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kulla baġ wiyan nurun, Keawai wal bara untoakállo wiyatoara nutunún emmoúmba kunto. ");
INSERT INTO awk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ġatun ku̇ri kauwȧl-kauwȧl uwa ġikouġ katoa: ġatun noa willariġ, warkulléu̇n, ġatun wiya ġaiya barun, ");
INSERT INTO awk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Uwȧnún tia ba taraikan kúri emmou̇ġ kin, ġatun wareka korien ġikoúmba biyuġbai ġatun tunkan, ġatun nukuġ, ġatun wonnai tara, ġatun kóti tara, ġatun wuġgunbai, kauwa, ġikoúmba kata moron, keawai noa kȧnu̇n emmoúmba wirrobullikan. ");
INSERT INTO awk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ġanto-bo ba kurri korien ġikoúmba taliġ-kabillikanne, ġatun uwolla emmouġ katoa, keawai noa kȧnu̇n emmoúmba wirrobullikan. ");
INSERT INTO awk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ġanto nurun kinbiruġ-ko, kotellin wittimulliko kokera, wiya, noa yellawȧnu̇n kurri-kurri, ġatun tuiġko umulliko, mirka keawai ġoloin witti korien? ");
INSERT INTO awk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mirroma, yukita wupéa noa ba tuġġa, ġatun keawai noa kaiyu korien ġoloin wittilliko, yantinto ba nanu̇n béelmȧnu̇n ġaiya bon, ");
INSERT INTO awk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wiyellinún, Ġali ku̇riko nutéa wittimulliko, ġatun kaiyu korien noa ġoloin wittimulliko. ");
INSERT INTO awk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ġa, ġan piriwȧl uwȧnún noa ba wuruwai kolaġ, tarai ko piriwȧl ko, yellawa noa kurri-kurri, ġatun kotelliela, wiya, noa ba kaiyukan uwa-uwil koa dekem-millia to nuġgurrawa-uwil koa bon taimin to ke bith-dekem-millia to? ");
INSERT INTO awk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ġa ba, kaloġ ka ba noa piriwȧl taraito, yuka noa wakȧl puntima wiyelliko pitȧl koa kakillai. ");
INSERT INTO awk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yanti kiloa, yantinto nurun kinbiruġ-ko wareka korien noa yantin ġikoúmba, keawai noa kȧnu̇n emmoúmba wirrobullikan. ");
INSERT INTO awk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Pulli ta unni murrȧrȧġ; wonto ba pulli ka korien, yakoai kȧnu̇n upilliko! ");
INSERT INTO awk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Keawai murrȧrȧġ, korien ta purrai ko, ġa ba konuġġél ko; wareka ġaiya ku̇riko. Niuwoabo ġurréuġkan ġurrulliko, ġurrabilla bon. ");
INSERT INTO awk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","PAPAI ġaiya bara uwa ġikouġ kin yantin telónai ġatun yarakaiwilluġ, ġurrulliko bon. ");
INSERT INTO awk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ġatun koiya bara Parithaioiko ġatun ġarammateuko, wiyelliela, Unni ku̇ri murrȧrȧġ korien, noa uman barun yarakai-willuġ ġatun tatan noa barun katoa. ");
INSERT INTO awk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ġatun noa wiya barun unni parabol, wiyelliela, ");
INSERT INTO awk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ġan ku̇ri nurun kinbiruġ, hekaton ta ćipu ġikoúmba, wȧkȧl noa ba yuréa umȧmu̇n barun kinbiruġ, wiya, noa wunún barun nainty-nain ta koruġ ka, ġatun waita noa uwȧnu̇n na-uwil koa noa yuréa-matoara, kara-uwilli koa noa? ");
INSERT INTO awk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ġatun karawolléu̇n noa ba, wúnkilléu̇n ġaiya noa bamirruġ ka ġikoug kin, pitȧllo ba. ");
INSERT INTO awk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ġatun uwa noa ba ġura kako, wiya noa barun kótita ġatun taraikan wiyellin barun, Pitȧllia kanwa emmouġ katoa; kulla baġ karawolléu̇n ćipu ta emmoúmba unni, yuréa ba kakulla. ");
INSERT INTO awk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wiyan baġ nurun, yanti kiloa pitȧl kȧnȧn kauwȧllan moroko ka ba minki noa ba wakȧl yarakaikan, keawai barun kai murrȧrȧġ-tai tin nainty-nain ta tin, minki korien. ");
INSERT INTO awk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ġa wonnuġ-ke nukuġ púndol arguro ten ta bounnoun kinba, yuréa bountoa ba umȧnu̇n wakȧl púndol, wiya, bountoa wirroġ-banún kaipuġ ġatun wirrillinu̇n wirrillikanneto kirra-kirra-uwilli koa bountoa? ");
INSERT INTO awk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ġatun karawolléu̇n bountoa ba, wiya ġaiya bountoa ba kóti-ta ġatun taraikan tuiġko, wiyellin, Pitȧllia kauwa emmouġ katoa; kulla baġ karawolléu̇n yuréa bag ba umá. ");
INSERT INTO awk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yanti kiloa, wiyan baġ, nurun, unnuġ, ta pitȧl kȧtan mikan ta aġelo ka Eloi koba wakȧl lin ba yarakai-willuġ minki kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ġatun noa wiya, Taraito ku̇riko yinal bula-buloara ġikoúmba: ");
INSERT INTO awk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ġatan mittiko bulun kinbiruġ-ko wiya bon biyuġbai ġikoúmba, Biyuġ, ġuwa tia winta tullokan ka-uwil koa emmoúmba. Ġatun túnbilliela noa bulun tullokan. ");
INSERT INTO awk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ġatun keawai kauwȧl-kauwȧl, korien ta purreȧġ ka yukita, kauma noa mittiko yinallo, ġatun waita noa uwa kaloġ koba, ġatun unta noa wari-wareka tullokan ġikoúmba pittelliġél la. ");
INSERT INTO awk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ġatun wari-wareka noa ba kirun, kauwȧl kakulla unta kunto korien; ġatun tanoa-kȧl-bo kakulla ġaiya noa kapirrikan. ");
INSERT INTO awk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ġatun uwa ġaiya noa umulliko ku̇ri kako unta ko purrai ta ko; ġatun noa bon yuka ġikouġ, ka tako purrai tako ġiratimulliko buttikaġ, ko porȧk ko. ");
INSERT INTO awk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pitȧl ġaiya noa kakulla takilliko, ta-uwil ba buttikaġko: ġatun keawai ku̇riko bon ġupa. ");
INSERT INTO awk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ġatun noa kakilliela ba niuwoabo, wiyelliela ġaiya noa, Kauwȧl-kauwȧlla umullikan biyuġbai koba emmoúmba koba kunto kauwȧl barúnba takilliko ġatun ġukilliko, ġatun ġatoa kapirró wirribanbillin! ");
INSERT INTO awk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bouġkullinún wal baġ, waita biyuġbai tako, ġatun wiyȧnu̇n wal bon, Biyuġ, yarakai baġ umá mikan ta moroko ka, ġatun ġirouġ kin, ");
INSERT INTO awk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ġatun keawai baġ murrȧrȧġ korien wiya-uwil koa tia ġiroúmba yinal yitirra: umulla tia wakȧl yanti umullikan ġiroúmba. ");
INSERT INTO awk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ġatun noa bouġkulléu̇n, uwa ġaiya noa biyuġbai tako. Wonto noa ba kaloġ ka kauwȧl kakulla, nakulla noa bon biyuġbai-to ġikoúmba-ko, minki ġaiya noa kakulla, murrá ġaiya noa, puntimulléu̇n ġaiya noa ġikouġ kin wuroka, ġatun búmbúmbea-kan ġaiya bon. ");
INSERT INTO awk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ġatun noa bon yinallo wiyá, Biyuġ, yarakai baġ umulléu̇n mikan ta moroko ka ġatun ġirouġ kin, keawai bag murrȧrȧġ korien wiya-uwil koa tia ġiroúmba yinal yitirra. ");
INSERT INTO awk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wonto noa ba biyuġbaito wiya barun mankillikan ġiroúmba, Mara unnoa-unnuġ upilligél, ġatun upilla bon konéin kako, ġatun upilla riġ ġikouġ kin mȧttȧra, ġatun upilla bon tuġganoġ yulo ka ġikouġ kin: ");
INSERT INTO awk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ġatun mara tanan untiko buttikaġ italo ġiratimatoara kipai, ġatun turulla; tamunbilla ġearun, ġatun pitȧl koa ġéen kauwȧl: ");
INSERT INTO awk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Koito ba unni emmoúmba yinal tetti kakulla, yakita ġaiya noa moron kȧtan: ġarawatilléún noa, ġatun yakita bummilléu̇n ġaiya bon. Ġatun pitȧl bara kakilli kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Unta ta ġarro ġikoúmba kakilliela upulliġél la purrai ta; ġatun uwolliela noa ba papai kokerȧ koba, ġurra noa tekki ġatun untelli ta. ");
INSERT INTO awk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ġatun noa kaaipa wakȧl mankillikan, ġatun wiya minnuġ-ban ġali tara minariġ tin. ");
INSERT INTO awk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ġatun wiya bon noa, Unni ta uwan ġiroúmba biġgai; ġatun ġiroúmba-ko biyuġbaito tura ġiratimatoara buttikaġ italo kipai ta, kulla wal pitȧl noa ġikouġ kai moron tin kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ġatun noa niuwara kakulla, keawai noa murruġ kolaġ uwa pa; yaki tin noa biyuġbai ġikoúmba uwa ġatun pirriralma bon. ");
INSERT INTO awk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ġatun noa bon wiyayelliela ġikoúmba biyuġbai, Ela! kauwȧl-kauwȧlla wunȧlla umala baġ ġirouġ; keawai bag ġiroúmba wiyellikanne umá korien; ġatun keawai bi tia ġupa waréa buttikaġ kid, pitȧl koa tia ka-uwil baraj emmoúmba kótita: ");
INSERT INTO awk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wonto ba tanoa-bo ġiroúmba yinal uwa ġali, wari-wareka ġiroúmba tullokan yarakai-willuġ koa ko ġapal loa, tura ġaiya bi ġikouġ buttikaġ italo ġiratimatoara. ");
INSERT INTO awk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ġatun noa wiya bon, Yinal, yellawan bi emmouġ kin yantikatai, ġatun yantin unni tara emmoúmba ġirouġ kin kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Murrȧrȧġ ta kakulla takilliko ġatun pittelliko; koito ba unni ġiroúmba umbeara-kóġ tetti kakulla, ġatun moron katéakan; ġatun ġarawatilléún, ġatun bummilléún bon yakita. ");
INSERT INTO awk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ĠATUN noa wiya barun ġikoúmba wirrobullikan, Untoa ta tarai ta wakȧl kúri tullokan porrólkan, mankillan piriwȧl ġikoúmba; ġatun wiyayéma bon ġikouġ wareka noa ġikoúmba tullokan. ");
INSERT INTO awk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ġatun noa wiya bon, wiyelliela, Yakoa baġ ġurra ġirouġ kinba? wiyella bi tia minariġ bi ba umulliela; keawai bi kara kȧnún umullikan. ");
INSERT INTO awk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wiyelléu̇n ġaiya noa mankillikan niuwoabo, Minnuġ, banu̇n baġ? kulla wal lia piriwȧllo emmoúmba ko mantilléún keawai bag mankillikan kȧnu̇n; keawai baġ pinninu̇n; koiyun baġ poiyelliko. ");
INSERT INTO awk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ġali wal baġ umulliko, yipanu̇n tia ba emmoúmba mankilliġél labiruġ, wamunbi-uwil koa tia bara kóti ko kokerá ko. ");
INSERT INTO awk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yanti ba wiya noa barun wiyatoara piriwȧl koba ġikoúmba, ġatun noa wiya wakȧl kurri-kurri ka, Minnan ba wiyapaiyéu̇n emmoúmba piriwȧl koba? ");
INSERT INTO awk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ġatun noa wiya, Hekaton ta wimbi ka karauwa. Ġatun noa wiya bon, Mara bi unni, yellawa kurrakai, upulla pentékonta koa ka-uwil. ");
INSERT INTO awk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wiya ġaiya noa tarai, Minnan bi wiyapaiyéu̇n piriwȧl koba? Ġatun noa wiyá, Hekaton ta wimbi wiet. Ġatun bon noa wiyá, Mara bi unni, upulla éty koa ka-uwil. ");
INSERT INTO awk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ġatun noa piriwallo murrȧrȧġ bon wiya unnoa mankillikan yarakai ka, kulla noa umá ġurakito; kulla bara wonnai tara unti ko purrai tako barúnba willuġġél koba ġuraki bara, keawai bara wonnai kaibuġ koba. ");
INSERT INTO awk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ġatun ġatoa nurun wiyan, Umulla nura bo kótita kakilliko tullo-yarakai tabiruġ; tetti nura ba kȧnu̇n, wamunbilla ġaiya nurun kokerá yuraki ba kȧtan yanti-katai. ");
INSERT INTO awk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Niuwoa miroman ġali waréa ta, yanti miroman noa kauwȧl ġali ta; ġatun niuwoa yarakai-maye ġali waréa ta, yanti yarakaimaye ġali kauwȧl ta. ");
INSERT INTO awk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yaki tin keawai nura ba miroma pa tullo yarakai ta, ġanto wal nurun ġunu̇n tullo tuloa ta miromulliko? ");
INSERT INTO awk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ġatun keawai nura ba miroma pa tarai koba, ġanto wal ġunu̇n nurúnba kóti tako? ");
INSERT INTO awk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Keawai wal mankillikanto umȧnu̇n buloara-bulun piriwȧl bula; kulla noa yarakai umȧnu̇n wakȧl bon, ġatun murrȧrȧġ umȧnu̇n tarai; ġa ba kȧnu̇n noa wakálla, ġatun béelmȧnu̇n bon tarai. Keawai nura kaiyu korien umulliko Eloi ko ġatun tullokan ko yarakai ko. ");
INSERT INTO awk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ġatun unni tara bara ġurra Parithaioiko, willirrikan bara kȧtan, ġatun bon bara béelma. ");
INSERT INTO awk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ġatun noa barun wiyá, Kauwa murrȧrȧġ koa nura ka-uwil mikan ta barun kin ku̇ri ka; wonto noa ba Eloito ġurran nurúnba búlbúl la ba; kulla unni tara murrȧrȧġ ta kȧtan barun kinba kȧri ko, yakaran ta kȧtan mikan ta Eloi kin. ");
INSERT INTO awk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Wiyellikanne-ta ġatun bara propet kakulla loanne noa ba paipéa; yaki tabiruġ piriȧl koba Eloi koba wiyabunbéa,ġatun yantin ku̇ri waita-waitawolléu̇n murruġ kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ġatun moroko ta ġatun purrai ta kaiyukan kánu̇n waita kolaġ, keawai waréa ta wiyellikanne koba ka korien kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ġanto ba warekullinún porikunbai ġikouúmba ġatun tarai búmbéa ka, yarakai bu̇mbéa noa: ġatun ġanto ba buúmbinu̇n warekatoara poribal tabiruġ, yarakai búmbéa noa. ");
INSERT INTO awk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kakulla ta noa wakȧl porrólkan, upulléún noa ġoroġ-ġoroġ ko ġatun murrȧrȧġ ko kariġkareuġ ko, ġatun bon kakulla minnuġbo-minnuġbo kauwȧl takilliko ġatun pittelliko yantin ta pureȧġ ka: ");
INSERT INTO awk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ġatun kakulla ta wakȧl poiyaye ġiakai yitirra Ladharo, wúnkulla bon ba yapugġġél ġikouġ ka ta, warapál mita-mitaġ, ");
INSERT INTO awk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ġatun wiya bon ba mutuġ ko takilliko ġikouġ kai porroólbin tin takilliġél labiruġ; ġatun warikȧl uwa bara, woatȧ ġaiya bon mita-mitaġ. ");
INSERT INTO awk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yakita-kȧlai tetti kakulla poiyaye, ġatun kurriá bara bon aġelo-ko Abȧram kinko parraġ kako: tetti ġaiya noa porrólkan kakulla, ġatun bon núlká. ");
INSERT INTO awk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ġatun noa unta koiyuġ ka hell ka bouġkulléún ġikoúmba ġaikuġ, kakilliela tirriki ka, ġatun nakilliela bon Abȧramnuġ kaloġ ka, ġatun noa Ladharo parraġ ka kakilliela Abȧram kin. ");
INSERT INTO awk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ġatun noa kaaibulléu̇n, wiyelliela, Biyuġ Abȧram, ġurrara tia kauwa, ġatun yukulla bon Ladharonuġ, kurrimulli koa noa kokoin to, ġatun moiya koa tia tȧllȧġ wupi-uwil; kulla wal baġ kirrin kȧtan unti tirriki ka koiyuġ ka. ");
INSERT INTO awk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wonto noa ba Abaramko wiyá, Yinal, ġurrulla ġintoa yakita moron ta mantala murrȧrȧġ-tai ġiroúmba, wonto noa ba Ladharo yakaran mantala ġatun noa yakita pitȧl kȧtan, wonto bi ba kirrin kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ġatun yanti umni ba, ġearun kinba willika ba pirriko wún-kulla; keawai uwȧnu̇n untikȧl untoa kolaġ: keawai bara unta biruġ, uwȧnu̇n untiko ġearun kinko. ");
INSERT INTO awk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wiya ġaiya noa, Wiyan banuġ, Biyuġ, yuka-uwil koa bon bintun kinko kokerá kolaġ: ");
INSERT INTO awk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kulla wal lia emmoúmba kotita pente; wiya-uwil koa noa barun yanoa bara ba tanan uwánún unti kolaġ tirriki-tirriki kako. ");
INSERT INTO awk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abȧramko noa wiya bon, Mothé noa ġatun bara propet barun katoa ba; ġurrabunbilla barun. ");
INSERT INTO awk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ġatun noa wiyá, Keawaran, biyuġ Abȧram; wakȧl ba uwolla barun kin unta biruġ tetti kabiruġ,ġurrȧnu̇n ġaiya wal bara. ");
INSERT INTO awk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ġatun noa bon wiyá, Keawai bara ba ġurrȧnu̇n bon Mothénuġ ġatun barun propetnuġ; keawai wal bara ġurrȧnu̇n wakȧl ba paikullinún moron tetti kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","WIYA ġaiya noa barun wirrobullikan ġikoúmba, Kauwa yanti kȧnu̇n bo ta wal yarakai; yapalla noa ġikouġ kinbiruġ yarakai tabiruġ! ");
INSERT INTO awk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Murrȧi ka ba noa ġira-uwil kea kulleuġ koa bon tunuġ, ġatun wareka uwil koa bon korowa ka, unni noa yanoa yarakai umabunbi yikora unti tara biruġ wakȧl wonnai tara biruġ. ");
INSERT INTO awk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yakoai nura kauwa: Kótiko ba ġirouġ, yarakai umȧnu̇n ġirouġ ka to, wiyella bon; ġatun minki noa ba kȧnu̇n, kȧmunbilla bon. ");
INSERT INTO awk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ġatun kauwál-kauwȧl-la biloa ba yarakai umȧnu̇n wakȧl la purreȧġ ka, ġatun kauwál-kauwȧl-la biloa willariġ noa kȧnu̇n wakȧl la purreȧġ ka, wiyellinu̇n biloa, Minki baġ kȧtan; kȧmunbinu̇n wal binuġ. ");
INSERT INTO awk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ġatun bon bara apothol wiyá, Piriwȧl, kauwȧl koa ġearúnba ġurrulli-ta ka-uwil kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ġatun noa Piriwȧllo wiyá, Ka ba nuru̇nba ġurrulli-ta yanti kiloa mitti yeai mutard koba, wiyella wal nura ba unni ku̇lai thukamin, Wokka laġ bi kauwa wirrakan-bo, ġatun meapullia bi korowa ka; ġatun gala nurun ġurrȧnu̇n ġaiya wal. ");
INSERT INTO awk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ġan nurun kinbiruġ-ko upullin purrai nurun ka to mankillikan-to,ġa tamunbin buttikaġ, wiyȧnu̇n bon kabo, uwȧnu̇n noa ba upulliġġél labiruġ, Yuriġ bi wolla, yellawolliko ta-uwil koa? ");
INSERT INTO awk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ġatun wiya bon noa wiyȧnu̇n, Kurrakai umulla ta-uwil koa baġ, ġatun ġirullia bi ġintoabo, ġatun mara-uwil koa bi tia ta-uwil koa baġ ġatun pitta-uwil; ġatun willuġ ġaiya bi tanu̇n ġatun pittȧnu̇n? ");
INSERT INTO awk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wiya noa, wiyapaiyéu̇n bon mankillikan, koito noa ba uma unni tara wiya bon ba? Kotan baġ kearan. ");
INSERT INTO awk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yanti nura wiyella, umȧnu̇n nura ba yantin unni tara wiyatoara nurun, Umullikan ġéen murrȧrȧġ korien kȧtan; umá ta ġéen unni wiyatoara umulliko ġearun. ");
INSERT INTO awk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ġatun yakita kakulla, uwolliela noa ba Hierothalem kolaġ, uwa willi koa noa Thamaria koa ġatun Galilaia koa. ");
INSERT INTO awk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ġatun noa uwolliela ba tarai toa kokeróa, nuġgarawa bon bara ku̇ri ten ta purrul-wommun-wommun, ġarokéa kaloġ ka; ");
INSERT INTO awk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ġatun bara paibuġga pulli, ġatun wiya Iéthu, Piriwȧl, ġurrȧramulla ġearun. ");
INSERT INTO awk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ġatun nakulla noa barun, wiya barun noa, Yuriġ nura wolla, túġunbillia nura barun kin hiereu ko. Ġatun yakita kakulla, uwolliela bara ba, turon bara kakulla tanoa-kȧl-bo. ");
INSERT INTO awk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ġatun wakȧllo barun kinbiruġ-ko, nakilléu̇n noa ba turon noa kakulla, willuġbo noa uwa, ġatun kaaipulléu̇n noa wokka, pitȧlmulliela bon Eloinuġ, ");
INSERT INTO awk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ġatun puntimulléu̇n noa barán ġoara ko ġikouġ kin tinna ka, murrárȧġ noa bon wiyelléu̇n; ġatun noa Thamaria-kȧl. ");
INSERT INTO awk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ġatun noa Iéthuko wiyayelléu̇n, wiyelliela, Wiya, ten ta turon kakulla? ġa wonnuġ-ke bara taraikan nain ta? ");
INSERT INTO awk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Keawai bara willuġ pa ba pitȧlmulliko bon Eloinuġ, wakȧl ba noa unni ġowikan ko. ");
INSERT INTO awk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ġatun noa wiya bon, Bouġkullia, yuriġ bi wolla; ġirouġ ka ba ko ġurrulli biruġ ko turon bi kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ġatun wiya bon ba Parithaioiko, yakounta-ke paipinu̇n piriwȧl koba Eloi koba, wiyayelléu̇n noa barun, wiyelliela, Tanan uwan piriwȧl koba Eloi koba keawai na korien. ");
INSERT INTO awk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Keawai bara wiyȧnu̇n wal, A unni ta! ġa unta ta! kulla, a! piriwȧl koba Eloi koba murruġ kaba kȧtan nurun kinba. ");
INSERT INTO awk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ġatun noa wiya barun wirrobullikan, A! purreȧġ ta wal kȧnu̇n, na-uwil koa nura wakȧl purreȧġ Yinal koba ku̇ri koba, ġatun keawai wal nura nanu̇n. ");
INSERT INTO awk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ġatun bara nurun wiyȧnu̇n wal, Na-uwa unni; ġa, na-uwa unnuġ: yanoa barun uwa yikora, wirroba yikora. ");
INSERT INTO awk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yanti kiloa pirruġgun-to uwan tarai tabiruġ ko moroko biruġ ko, tarai ta kako moroko kako; kauwa yanti kiloa wal kȧnu̇n Yinal ku̇ri koba purreu̇g ka ġikouġ ka ta. ");
INSERT INTO awk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ġatun kurri-kurri ta bon umȧnu̇n minnuġbo-minnuġbo, ġatun warekatéa wal bon ġali koba willuġġél koba. ");
INSERT INTO awk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ġatun yakita ba kakulla purreȧġ ka Noe-úmba ka, yanti bo ta wal kȧnu̇n purreȧġ ka Yinal koba ku̇ri koba. ");
INSERT INTO awk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Takillala bara, pittellala bara, búmbillala bara nukuġ, ġukillala búmbilli ka, yakita purreȧġ ka kakulla noa ba Noe uwa murrariġ murrinauwai ka, ġatun tunta-tunta kakulla, ġatun kirun ġaipa barun nuropa. ");
INSERT INTO awk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ġatun yanti yakita ba kakulla purreȧġ ka Lot-úmba, takillala bara, pittellala bara, wirrilliala bara, ġukillala bara, meapala bara, wittiala bara; ");
INSERT INTO awk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wonto ba yakita unta purreȧġ ka Lot noa uwa Thodóm kabiruġ, patéa ġaiya koiyuġ-ko ġatun brimtón-ko wokka tin moroko tin, ġatun kiyupa barun yantin kirun tetti-tetti. ");
INSERT INTO awk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yanti kiloa kȧnu̇n yakita purreȧġ ka paipinu̇n noa ba Yinal ku̇ri koba. ");
INSERT INTO awk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Unta yakita purreȧġ ka kȧtan noa ba wokka kokerá, ġatun ġikoúmba tullokan murruġ kaba kokera ba, keawai bon uwabunbi yikora barán mankilliko tullokan ko; ġatun kȧtan noa ba upulliġél laba, keawai bon uwabunbi yikora willuġ, kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kotella bounnoun kai nukuġ Lot-úmba tin. ");
INSERT INTO awk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ġanto ba ġikoúmba moron miromȧnu̇n moron kakilliko, woġúntinún wal noa; ġatun ġanto ba woġúntinún ġikoúmba moron, kȧnu̇n wal moron kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wiya nurun baġ, yakita unta-unta tokoi ta buloara ta kȧnu̇n birrikilliġél la wakȧl la; manu̇n wal wakȧl, ġatun tarai ġaiya wunu̇n. ");
INSERT INTO awk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Buloara umullinún bula; mánún wal wakȧl, ġatun tarai ġaiya wunún. ");
INSERT INTO awk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Buloara katéa-kȧnu̇n upulliġél la; mánu̇n wal wakȧl, ġatun tarai ġaiya wunu̇n. ");
INSERT INTO awk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ġatun wiyelléu̇n bon bara, wiyelliela, Piriwȧl, wonnuġ-ke? Gatun noa wiya barun, Unta wonto ba katéa-kȧnu̇n murrin ta, unta kolaġ ba kautillinu̇n bara porowi. ");
INSERT INTO awk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ĠATUN noa wiya barun wakȧl parabol, wiya-uwil koa bon bara ku̇riko Eloinuġ, ġatun yari koa bara kaiyaléa-ku̇n; ");
INSERT INTO awk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wiyelliela, Unta ta kokerá tarai ta wakȧl wiyellikan piriwȧl kakulla, kinta korien kakulla noa bon Eloi kai, ġatun keawai noa tuma korien barun ku̇ri: ");
INSERT INTO awk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ġatun kakulla wakȧl mabogun unta kokerá; ġatun bountoa uwa ġikouġ kin, wiyelliela, Timbai kakillia tia emmoúmba bukkakaye. ");
INSERT INTO awk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ġatun keawai wal noa ġurra pa kabo kakullai tako; wonto noa ba yukita wiya ġikouġ kinko minki ka, Keawai baġ kinta korien bon Eloi kail kȧtan, ġa keawai ku̇ri tuman korien; ");
INSERT INTO awk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kulla bountoa tia unni mabogunto pirralman, ġatoa timbai kȧnu̇n bounnoun kin, murrin-murrin koa bountoa tia uwa-uwil kumburrobawanl bountoa tia. ");
INSERT INTO awk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ġatun noa Piriwȧllo wiya, Gurrulla bon unni yarakai wiyellikan piriwȧl wiyan ba. ");
INSERT INTO awk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ġatun wiya noa Eloito timbai katillinu̇n barun ġikoúmba ġirimatoara bara wiyan bon purreȧġ ka ġatun tokoi ta, ġurralin noa barun wiyelli ta kaloġ tinto? ");
INSERT INTO awk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wiyan nurun baġ, timbai wal noa katillinȧn barun kurrakai. Wonto noa ba uwȧnu̇n wal Yinal ku̇ri koba tanan, wiya, noa nanu̇n ġurrullikanne purrai taba? ");
INSERT INTO awk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ġatun noa wiya barun unni parabol tarai tako kotelléu̇n bara ba murrȧrȧġ-tai barabo, ġatun yarakai bara kotellin taraikan: ");
INSERT INTO awk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Buloara-bula ku̇ri uwa hieron kolaġ wiyelliko: wakȧl la noa Parithaio ġatun tarai ta teloné; ");
INSERT INTO awk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ġarokéa noa Parithaio ġatun noa yanti wiyelliela niuwoabo ġiakai: A Eloi! pitȧlman baġ ġirouġ, kulla baġ ka korien yanti tarai ba kȧtan, bara kau-maye, tuloa uma korien mankiye nukuġ ka, ġa ka korien bag yanti unni noa ba telóne: ");
INSERT INTO awk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ta korien baġ buloarakȧl kȧtan wakál la thabbat biruġ ka, ġutan baġ winta untikȧl emmouġ kai yantin tabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ġatun noa telóné ġarokilliela ba kaloġ ka, keawai noa ġaikuġ ka wokka laġ na pa moroko koba, wonto noa ba minki motilliela wiyelliela ba, A Eloi! miromulla bi tia, yarakai bag ba kȧtan. ");
INSERT INTO awk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Wiyan nurun baġ, unni noa kúri uwa barȧn kokerá koba ġikouġ ka tako ġurrȧmatoara, keawai tarai ta: kulla yantin bara piriwȧl-buntelliko, kȧnu̇n wal bara koiyun-barátoaro; ġatun niuwoa bo koai-koai korien bon, umȧnu̇n kauwȧl bon kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ġatun mankulla bara ġikouġ kinko wonnai tara numa-uwil koa barun noa: wonto ba nakulla bara ba wirrobullikanto, yipa bara barun. ");
INSERT INTO awk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wonto ba noa Iéthuko wiya barun, wiyelliela, Wamunbilla barun wonnai tara emmouġ kinko, ġatun yanoa barun yipai yikora; kulla barun-kai-kȧl katéa-kȧnu̇n piriwȧl koba Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wiyan baġ tuloa nurun, Ganto ba ġurra korien piriwȧl koba Eloi koba yanti wonnai waréa ba, keawai wal noa pulóġkullinu̇n unta kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ġatun taraito umullikanto piriwȧllo wiya bon, wiyelliela, Piriwȧl murrȧrȧġ-tai, minnuġ-bullinu̇n bag moron kakilliko yantikatai? ");
INSERT INTO awk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ġatun noa Iéthuko wiya bon, Minariġ tin bi tia wiyan murrȧrȧġ-tai emmouġ? keawai wal wakȧl murrȧrȧġ-tai, wonto noa ba wakȧlbo, Eloi ta. ");
INSERT INTO awk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ġurran bi yantin wiyellikanne, Yanoa manki yikora nukuġ taraikan koba, Yanoa búnki yikora tetti, Yanoa manki yikora, Yanoa nakoiya yikora, Ġurulla bon biyuġbai ġatun tunkán ġiroúmba. ");
INSERT INTO awk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ġatun noa wiya, ġurra bag unni tara wiyellikanne yakikalai tabiruġ, wonnai baġ ba kakulla. ");
INSERT INTO awk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ġatun yakita ġurra noa ba Iéthuko unnoa tara, wiya bon noa, Wakȧl unnoa-unnuġ uma korien bi ba; ġukillia yantin tullokan ġirou̇mba, ġu-uwil koa barun mirrȧl ko, ġatun tullokan ġiroúmba kȧnu̇n wal wokka ka moroko ka; ġatun kaai, wirroba-uwil koa bi tia. ");
INSERT INTO awk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ġatun ġurra noa ba unni, minki noa kakulla kauwȧl; kulla noa porrol kakulla kauwȧlkan. ");
INSERT INTO awk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ġatun noa ba Iéthuko nakulla bon minki noa ba kakulla kauwȧl-lan, wiya ġaiya noa, Pirral ta pulóġkulliko bara tullokan ta ba piriwȧl koba kako Eloi koba kako! ");
INSERT INTO awk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel noa kaiyukan kȧtan pulóġkakilliko tiġkuġkoa ko aku lako, keawai porrólkan pulóġkakilliko piriwȧl koba kako Eloi koba kako. ");
INSERT INTO awk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ġatun bara ba ġurrȧ, wiya bara, Ġan-ke wal moron kȧnu̇n kakilliko? ");
INSERT INTO awk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ġatun noa wiyá, Unni tara kaiyu korien ku̇ri ko umulliko, kaiyu-kan-to Eloito noa umulliko. ");
INSERT INTO awk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ġatun Peterko noa wiyá, Ela! wúnkulla ġéen yantin ta, ġatun wirroba ġéen bin. ");
INSERT INTO awk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Gatun noa wiya barun, Wiyȧnu̇n baġ tuloa, Niuwoa wareka kokera ġikoúmba, ġa biyuġbai, ġa tunkán, ġa ġapal, ġa wonnai, ġikouġ, kinko piriwȧl koba tin Eloi koba tin, ");
INSERT INTO awk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mȧnu̇n wal noa kauwál unti yakita, ġatun untoa tarai ta purrai ta tanan kakilliko, moron noa kánún yanti-katai. ");
INSERT INTO awk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mankulla ġaiya noa barun dodeka ta wirrobullikan,ġatua wiya barun, A! waita ġéen wokka kolaġ Hierothalem kolaġ, ġatun yantin tara wiyatoara propet to ġikouġ, kai Yinal lin kúri koba tin kȧnu̇n wal umatoara kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ġatun bon ġunu̇n wal barun kin ethȧnékȧl kinko, ġatun bon bukka-manu̇n wal, ġatun karaġkobinu̇n: ");
INSERT INTO awk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ġatun wélkorinún wal bara bon, ġatun wal bon wirrinu̇n; ġatun kúmba-ken-ta bouġkullinún ġaiya noa willuġbo. ");
INSERT INTO awk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ġatun keawai bara ġurrapa unni tara wiyatoara: ġatun unni wiyellikanne yuropa barun kai, keawai bara ġurrápa unni tara wiyatoara. ");
INSERT INTO awk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ġatun yakita kakulla, uwolliela noa ba papai Yeriko ka, wakȧl munmin ku̇ri yellawolliela yapuġ ka bitta ka, poiyelliela: ");
INSERT INTO awk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ġatun ġurrulliela noa barun konara yapuġ koa, wiya noa minariġ unni? ");
INSERT INTO awk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ġatun bara bon wiyá, Uwan noa Iéthu Nadharet-kȧl. ");
INSERT INTO awk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ġatun noa kaaipulléu̇n, wiyelliela, Ela Iéthu! yinal Dabidúmba, ġurrȧra-mulla bi tia. ");
INSERT INTO awk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ġatun bara uwa ġanka, wiya bon koiyelli koa noa: wonto noa ba butti paiyelléu̇n, Yinal Dabidúmba gintoa, ġurrȧra-mulla bi tia. ");
INSERT INTO awk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ġatun ġarokéa noa Iéthu, ġatun wiya bon yutilliko bon ġikouġ kinko; ġatun uwa noa ba papai, wiya bon noa, ");
INSERT INTO awk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Wiyelliela, Minnuġ-bulliko bi tia wiyan? Gatun noa wiyan, Piriwȧl, namunbilliko tia umulla. ");
INSERT INTO awk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ġatun noa Iéthuko wiya bon, Kȧmunbilla bin nakilliko; ġiroumba tin ġurrulli tin moron uma. ");
INSERT INTO awk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ġatun noa tanoa-kȧl-bo nakulla, ġatun bon noa wirropa, pitȧlmulliela bon Eloinuġ; ġatun yantin unni ku̇ri nakulla bara ba, pitȧlma bon Eloinuġ. ");
INSERT INTO awk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ĠATUN noa Iethu uwa Willi koa Yeriko koa. ");
INSERT INTO awk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ġatun kakulla untakȧl wakȧl ku̇ri ġiakai Dhakké yitirra, piriwȧl telónékȧl noa kakulla, ġatun noa porrólkan. ");
INSERT INTO awk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ġatun noa numéa nakilliko Iéthunuġ, ġan noa ba; ġatun noa keawai, kulla konaró núntima, kulla noa waréa ġoiyoġ. ");
INSERT INTO awk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ġatun noa murra ġanka, ġatun noa kulliwa wokka-laġ, ku̇lai tin nakilliko bon, kulla noa unta kolaġ uwolli kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ġatun Iéthu noa ba uwa untako, nakulla noa wokka-laġ, ġatun bon nakulla, ġatun bon wiyá, Ela Dhakké! tanan kurrakai tirabulla, kulla buġgai koa baġ yellawȧnu̇n ġirouġ ka ta kokerȧ. ");
INSERT INTO awk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ġatun tiraba noa kurrakai barán, ġatun pitȧl ma-uwa bon. ");
INSERT INTO awk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ġatun nakulla bara ba, wiyellan niuwarakan bara yantinto, wiyelliela, Waita noa uwa yarakai toa kóti kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ġatun noa Dhakké ġarokéa, ġatun wiya bon Piriwȧlnuġ, Ela Piriwȧl! winta baġ ġutan emmou̇mba tullokan kabiruġ mirrȧl kai ko; ġatun mankulla baġ ba tullokan taraikan tabiruġ yaki tin ġakoiyaye tin, wupinu̇n ġaiya bon baġ willuġbo warán tako. ");
INSERT INTO awk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ġatun noa Iéthuko bon wiyá, Tanan uwa moron unti buġgai purreȧġ ka unti ko kokera ko, kulla noa kȧtan yinal ta Abȧramuúmba. ");
INSERT INTO awk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kulla Yinal ku̇ri koba uwa tiwolliko ġatun tumulliko woġu̇ntitoara ko. ");
INSERT INTO awk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ġatun ġurra bara ba unni tara, wiyéakan butti noa ġatun wiya wakȧl parabol, kulla noa papai ta ba Hierothalem ka, ġatun kulla bara kota paipillinu̇n piriwȧl koba Eloi koba tanoa-kȧl-bo. ");
INSERT INTO awk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yaki tin noa wiyá, Tarai ta piriwȧl uwa tarai tako purrai tako kaloġ kako, mankilliko ġikouġbo piriwȧlkanne-ta, ġatun willuġbulliko. ");
INSERT INTO awk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ġatun wiya noa barun ġikoúmba mankillikan ten ta, ġatun ġukulla noa barun kin mina ta ten ta, ġatun wiya barun, Miromulla uwȧnu̇n baġ ba willuġbo. ");
INSERT INTO awk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wonto ba ġikou̇mba-ko konara niuwama bon, ġatun yuka bon puntimai ġikouġ, wiyelliela, Keawai wal noa unni piriwȧl katillinu̇n ġearun. ");
INSERT INTO awk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ġatun kakulla yakita, willuġ ba noa ba, mantoara piriwȧlkoba, wiya ġaiya noa barun unnoa mankillikan ġan kin noa ba ġukulla money, tanan ġikouġ kin, ġurra-uwil koa noa minnan barun kinba ġutoara ġukilli tabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tanan ġaiya uwa kurri-kurri wakȧl, wiyelliela, Ela Piriwȧl! ġiroúmba ta mina unni wittia kauwȧl ten mina ta. ");
INSERT INTO awk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ġatun bon noa wiyá, Kauwa yanti, ġintoa mankillikan murrȧrȧġ; kulla bi miroma unnoa waréa ta, kaiyukan bi kanwa ten ta kokera. ");
INSERT INTO awk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ġatun tarai uwa, wiyelliela, Ela Piriwȧl! ġiroúmba ta mina unni wittia kauwȧl pente mina ta. ");
INSERT INTO awk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ġatun noa wiya ġaiya bon, Kauwa bi kaiyukan pente ta kokera. ");
INSERT INTO awk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ġatun tarai uwa, wiyelliela, Ela Piriwȧl! na-uwa unni ta mina ġiroúmba, wúnkulla baġ ba koroka wurobilla: ");
INSERT INTO awk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kulla baġ kinta kakulla ġirouġ kai, kulla bi bukka kauwȧl; mantan bi wokka-laġ keawai bi ba wunpa barán, ġatun kólbúntia bi unnoa keawai bi ba meapa ba. ");
INSERT INTO awk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ġatun noa bon wiyá, ġirouġ kinbiruġ kóti ko kurraka ko wiyan pirriral-manu̇n banuġ, ġintoa ta mankillikan yarakai. Ġurra bi tia bukka kauwál baġ; mantillin wokka-laġ keawai baġ wunpa barán, ġatun kólbu̇ntillin unnoa keawai baġ ba meapa ba: ");
INSERT INTO awk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kora koa bi ġupa emmoúmba money ġukilliġél lako, marauwil koa baġ emmoúmba kóti ġatun kopatoara ta, emmouġ ka ta uwolli ta? ");
INSERT INTO awk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ġatun noa wiya barun ġarokilliela bara ba taruġ ka, Mantillia unnoa mina unti biruġ bon, ġatun ġuwa bon gala ko tenkan ko ġikouġ. ");
INSERT INTO awk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","(Gatun bara wiya bon, Piriwȧl, ten ta mina mantan noa). ");
INSERT INTO awk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wiyan nurun baġ, Yantinko barun mantan bara ba ġunu̇n wal butti; ġatun keawaran noa ba, unnoa ta mantan noa ba mantillinún wal bon ġikouġ, kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kulla bara unnoa emmoúmba niuwa-maye, keawai bara emmouġ kȧnu̇n bi ba piriwȧl barun, mara barun, bú-uwil koa barun emmouġ kin mikan ta ");
INSERT INTO awk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ġatun wiya noa ba unnoa, waita ġaiya noa ġanka uwa wokka-laġ Hierothalem kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ġatun kakulla yakita, uwa noa ba papai Bethȧbage tako ġatun Bethany tako, bulkȧra ta ġiakai yitirra Elaión ka la, yakunbéa noa buloara-bulun ġikoúmba wirrobullikan, ");
INSERT INTO awk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Wiyelliela, Yuriġ nura wolla kokeraá ko kaiyin tako; uwollinu̇n nura ba untariġ, nanu̇n ġaiya nura wirritoara waréa buttikaġ keawai yellawa pa kúri bulka ka: buruġbuġgulla unnoa, ġatun yemmamulla untiko. ");
INSERT INTO awk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ġatun tarai-kan-to ba wiyȧnu̇n, Minariġ tin nura unnoa ta buruġbuġgan? ġiakai nura wiyella bon, Kulla noa Piriwȧllo wiyá. ");
INSERT INTO awk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ġatun bara ba yukatoara, waita uwa, ġatun nakulla ġaiya bara yanti noa ba wiya barun ba. ");
INSERT INTO awk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ġatun buruġbuġgulliela bara ba unnoa waréa buttikaġ, ġikoúmba-ko wiya barun, Minariġ tin nura buruġbuġgan unni waréa buttikaġ? ");
INSERT INTO awk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ġatun bara wiyá, Piriwȧllo noa wiya ġala. ");
INSERT INTO awk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ġatun bara yemmama bon kinko: ġatun bara wupéa barun ba kirrikin bulka ka buttikaġ ka, ġatun wupéa bon bara Iéthunuġ wokka ka. ");
INSERT INTO awk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ġatun uwolliela noa ba, wupéa bara yapuġ ka kirrikinkan nurúnba. ");
INSERT INTO awk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ġatun uwa noa ba papai, bará ka Elaión ka ba koba bulkára koba, yantin konara wirrobullikan pitȧl ġaiya kakulla, ġatun pitȧlmulliela bon Eloinuġ kauwȧl lo pulli to, yantin tin kauwȧl Iin uma ba nakulla bara ba; ");
INSERT INTO awk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wiyelliela, Pitȧlmabunbilla bon Piriwȧl ta uwan noa ba Yehóa-úmba koa yitirroa: pital-kȧmunbilla moroko ka, ġatun killibinbin kȧmunbilla wokka ka. ");
INSERT INTO awk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ġatun winta-ko Parithaioi kabiruġ konara biruġ wiya bon, Piriwȧl, koawa bi barun ġiroúmba wirrobullikan. ");
INSERT INTO awk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ġatun noa wiyayelléún barun, wiyelliela, Wiyan nurun baġ, wiya, bara ba kaiyellinún mupai, kaibullinún wal ġaiya unni tara tunuġ tanoa-kȧl-bo. ");
INSERT INTO awk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ġatun uwa noa ba papai, nakulla noa kokera kariġ, ġatun noa tuġkillimilléu̇n ġaloa rin, ");
INSERT INTO awk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Wiyelliela, Ġurrapa bi ba, ġintoa ta, unti purreȧġ ka ġirouġ ka ta unni tara pitȧl-kakilliko ġiroúmba ko! wonto ba yakita yuropa ta ġirouġ, kai nakilli tin ġaikuġ tin. ");
INSERT INTO awk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kulla purreȧġ, ta kánún ġirouġ kin, bukka-kan-to ġirouġ wirrinu̇n wal bara kirrai kirai-karai ġirouġ, ġatun karai-karai wirrinún ġirouġ, ġatun mirrámanún bin willi ka yantin ta kaiyinkaiyin ta, ");
INSERT INTO awk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ġatun pirikibunpinún bin purrai ta, ġatun ġiroúmba wonnai tara murruġ kaba ġirouġ, kinba; ġatun keawai bara wupinu̇n tunuġ tarai ta wokka ka; kulla keawai bi ba ġurra pa yakita natala ba ġiroúmba. ");
INSERT INTO awk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ġatun noa uwa murrariġ kolaġ, ġatun yipa ġaiya noa barun ġukillikan, ġatun barun mankillikan unta biruġ; ");
INSERT INTO awk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wiyelliela barun, Upatoara unni, Emmoúmba kokera ta wiyelliġél kokera; wonto ba nura uma unni wollo kakilliko barun nankiye-ko. ");
INSERT INTO awk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ġatun wiyelliela noa purreȧġ ka yantin ta murruġ ka hieron ka. Wonto ba piriwȧl hiereu, ġatun bara ġȧrammateu, ġatun bara piriwȧl ku̇ri koba, numa bara bon búnkilli kolaġ; ");
INSERT INTO awk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yakoai bara ba umulliko ġatun keawai bara, kulla yantin ta ku̇ri pitȧl kakilliela ġurrulliko bon. ");
INSERT INTO awk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ĠATUN yakita kakulla, wakȧl la tarai ta purreȧġ ka, wiyelliela noa ba barun ku̇ri ka, ġatun wiyelliela euaġelion, uwa ġaiya bon bara piriwȧl ġatun bara gȧrammateu ġatun bara pȧrethbuteroi, ");
INSERT INTO awk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ġatun wiya bon, wiyelliela, Wiyella ġearun, minariġ tin kaiyu tin umullia bi unni tara? ġa ġanto-ke noa bin unni ta kaiyu ġukulla ġirouġ? ");
INSERT INTO awk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ġatun noa wiyayelléu̇n, ġatun wiyelliela barun, Ġatoa wiyȧnu̇n nurun unni ta wakȧl; ġatun wiyayelléa tia; ");
INSERT INTO awk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Korimullikanne-ta Ioanne-úmba, wiya, ta morokó kabiruġ, ġa ku̇ri koba? ");
INSERT INTO awk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ġatun bara wiyatan barabo, wiyelliela, Wiyȧnu̇n ġéen ba, Morokó kabiruġ ta; wiyȧnu̇n, ġaiya noa, Kora koa nura ġurrapa bon? ");
INSERT INTO awk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kulla ġéen wiyȧnu̇n ba, Ku̇ri koba ta; yantinto ġaiya ġearun ku̇riko pintinu̇n tunuġ ko: kulla bara kotan bon Ioannenuġ propet ta kakulla. ");
INSERT INTO awk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ġatun bara wiyá, keawai bara ġurrapa wonta biruġ ta. ");
INSERT INTO awk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ġatun noa barun Iéthuko wiya, Keawai baġ, wiyánu̇n nurun minariġ tin kaiyu tin uman baġ unni tara. ");
INSERT INTO awk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ġatun potopaiyá ġaiya non barun ku̇ri wiyelliko unni-ta parabol: Taraito ku̇riko meapa wain-ġel la, ġatun wu̇nkulla barun kin upullikan ta, ġatun uwa ġaiya noa kalog kolaġ, yuraki. ");
INSERT INTO awk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ġatun yakita poaikulléu̇n ba, yuka noa bon wakȧl umullikan barun kin upullikan ta, ġu-uwil koa bara bon yeai wainġél labiruġ; wonto bara ba bu̇nkulla bon, ġatun yuka bara bon waita yeai korien. ");
INSERT INTO awk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ġatun noa toanta yukéa-kan tarai umullikan: ġatun bara bon búntéa-kan yantibo, ġatun yarakai uma bara bon, ġatun bon bara yuka waita yeai korien. ");
INSERT INTO awk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ġatun noa toanta yukéa-kan ġoro-ta, ġatun bara bon mularéa-kan, ġatun wareka bara bon warrai tako. ");
INSERT INTO awk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Wiya ġaiya noa piriwállo wain-gél koba, Minnuġ banu̇n kan baġ? Yukȧnu̇n wal baġ emmoúmba yinal pitȧlmatoara; mirka bara bonġurránu̇n, nanu̇n bon bara ba. ");
INSERT INTO awk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wonto bara ba upulli-kan-to nakulla bon ba, barabo ġaiya wiyellan, wiyelliela, Unni ta wúġgurra piriwál: kaai ġéen bu̇wil bon, purrai koa ka-uwil ġearúnba. ");
INSERT INTO awk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yanti bon bara wareka wain-ġél labiruġ, ġatun búnkulla ġaiya bon tetti. Minnuġ banu̇n noa barun piriwállo wain-ġél koba ko? ");
INSERT INTO awk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Uwȧnu̇n wal noa tanan búnkilliko barun upillikan-ko, ġatu̇n ġunu̇n wal wain-ġél taraikan ko. Ġatun ġurra bara ba unni, wiya ġaiya bara, Kámunbi yikora Eloito. ");
INSERT INTO awk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ġatun noa barun nakilliela, ġatun wiyá, Minariġ-ke unni upatoara yanti, Tunuġ ta wareka wittilli-kán-to, unnoa ta katéakȧnu̇n wokka ka waiyakan ta wolluġ? ");
INSERT INTO awk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ġan-ba puntimullinún untoa tunuġ ka tiirpuntimullinún, wal; ġan kinba puntimullinún, minbinu̇n wal bon muta-mutan. ");
INSERT INTO awk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ġatun tanoa-kȧl-bo kota bara piriwállo hiereuko ġatun gȧrammateuko mankilliko bon; ġatun bara kinta kakulla konará tin; kulla bara ġurrá, wiya noa ba unni parabol barun kin. ");
INSERT INTO awk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ġatun bara bon tuminéa, ġatun yuka barun ġakoiyellikan, ġakoġkilliko barunbo ku̇ri murrarȧġ-tai, ġurra-uwil koa bara ġikoúmba wiyellikanne, yaki tin mara-uwil koa bara bon kaiyu kabo kobȧna kinko. ");
INSERT INTO awk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ġatun wiya bon bara, wiyelliela, Piriwȧl, ġurran ġéen wiyan bi ba tuloa, kinta kora bi kauwa taraikan tin ku̇ri kurriġ tin, wonto bi ba wiyan tuloa wiyellikanne Eloi koba: ");
INSERT INTO awk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wiya tuloa ta ġukilliko ġearun tullokan ġikouġ kin Kaithari kin, ġa keawai? ");
INSERT INTO awk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wonto noa ba ġurra ġakoiya baru̇nba, ġatun wiya barun, Yakoai nura tia numan? ");
INSERT INTO awk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Túġunbilla tia wakȧl denari. Gan kiloa unnoa ġoara ġatun upatoara unni ta? Wiyayelléu̇n bon bara ġatun wiyelliela, Kaitharúmba ta. ");
INSERT INTO awk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ġatun noa wiya barun, Koito Kaithari kinko ġuwa Kaitharúmba ta, ġatun Eloi kinko unnoa tara Eloi-úmba ta. ");
INSERT INTO awk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ġatun keawai bara man pa ġikoúmba wiyelli-ta mikan ta barun kin ku̇ri ka: ġatun mupai kakulla bara. ");
INSERT INTO awk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Uwa ġaiya taraikan barun kinbiruġ Thadukaioi kabiruġ bara ġurramaiġaye moron ta katéa-kȧnu̇n tetti kabiruġ; ġatun bara bon wiyá, ");
INSERT INTO awk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wiyelliela, Ela Piriwȧl Mothéto noa upa ġearun, Taraikan koba ba kóti tetti kȧnu̇n ba porikunbai ġikou̇mba ta, ġatun tetti noa ba kȧnu̇n, wonnai korien, mara-uwil koa ġikoúmba kóti bounnoun ġikoúmt porikunbai ka-uwil koa wonnai ġikoúmba koti koba. ");
INSERT INTO awk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yakita ġaiya warán kakulla kótita theben ta: ġatun kurri biruġ ko búmbéa porikunbai kakilliko, ġatun tetti kakulla, wonnai korien. ");
INSERT INTO awk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ġatun willi-kaba-ko deutero-to búmbéa bounnoun porikun bai kakilliko, ġatun tetti noa kakulla, wonnai korien. ");
INSERT INTO awk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ġatun willi-kaba-ko trito-to búmbéa bounnoun porikunbai kakilliko; ġatun yaki-bo thebento; ġatun bara keawai wimba wonnai, ġatun tetti bara kakulla. ");
INSERT INTO awk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Willuġ ta tetti ba bountoa nukuġ. ");
INSERT INTO awk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ġanúmba barun kinba unnoa porikunbai kȧnu̇n kakilliko moron ba katéa-kȧnu̇n tetti kabiruġ? kulla bara thebento bounnoun búmbéa porikunbai kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ġatun noa Iéthuko wiyayelléu̇n, wiyelliela barun, Wonnai ta untikȧl búmbillan porikunbai ġatun ġukillaiko búmbilliko: ");
INSERT INTO awk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wonto ba bara murrárȧġ-tai kȧnu̇n uwolliko unta kolaġ tanai tako purrai tako, ġatun moron kakilliko tetti kabiruġ, keawai bara búmbúmbillan, keawai ġukitan búmbilliko: ");
INSERT INTO awk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Keawai wal bara tetti banún yukita; kulla bara yanti kȧtan aġelo kiloa; ġatun wonnai tara kȧtan Eloi-úmba, kȧtan bara wonnai tara ġali koba moron kȧnu̇n tetti kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ġatun Mothéko noa ba túġaiya wakȧl la ku̇lai ta, bouġbuġga barun tetti-tetti kabiruġ, wiya noa ba bon Yehóanuġ, Eloi ta Abȧramúmba, ġatun Eloi ta Itháku̇mba, ġatun Eloi ta Yacobu̇mba. ");
INSERT INTO awk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Keawai noa Eloi ta barúnba tetti-tetti koba, wonto ba barúnba moron koba; kulla yantin moron kȧtan ġikouġ kin. ");
INSERT INTO awk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Taraito bara gȧrammateukȧllo wiya ġaiya, Piriwȧl, murrȧ rȧġ bi wiyan. ");
INSERT INTO awk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ġatun yukita keawai bara bon wiya pa kinta-kan-to. ");
INSERT INTO awk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ġatun noa barun wiyá, Yakoai bara wiya Kritht ta yinal ta Dabidúmba? ");
INSERT INTO awk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ġatun Dabidto noa niuwoabo wiyá, biblion kaba tehillim koba, Yehóako noa wiya bon Piriwȧl emmoúmba, Yellawolla bi túġkaġkeri ka emmouġ kin, ");
INSERT INTO awk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Uma-uwil koa baġ barun bukkakan ġikoúmba yuloġél ko kakilliko ġikouġ. ");
INSERT INTO awk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dabidto noa ba wiya bon Piriwȧl yitirra, yakoai ġaiya noa yinal ta ġikoúmba? ");
INSERT INTO awk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wiya ġaiya noa barun ġikoúmba wirrobullikan mikan ta yantin ta ku̇ri ka, ");
INSERT INTO awk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Yakoai nura barun kai gȧrammateu tin, pitȧl koa bara uwa-uwil kurrawitaikan, ġatun umulliko ġukilliġél laba ko, ġatun yellawolliġél la wokka ka thunagóg ka, ġatun piriwȧl-ġél takilliġél laba; ");
INSERT INTO awk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mantan bara kokera ba mabogun koba, ġatun umȧnu̇n wiyellikanne-ta kurra-uwai tu̇ġunbilliko: yaki tin bara kȧnu̇n kauwȧl tetti kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ĠATUN noa nakulla wokka-laġ, ġatun nakulla barun porrólkan wúnkilliela ġutoara baru̇nba wúnkilliġél la. ");
INSERT INTO awk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ġatun noa nakulla tarai mabogun mirrálkan wúnkilliela bountoa lepto buloara unta ko taroġ kako. ");
INSERT INTO awk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ġatun noa wiya barun, Wiyan baġ nurun tuloa, ġali mabogunto mirrȧllo wúnkulla kauwȧl ta bara yantin kearan. ");
INSERT INTO awk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kulla yantin ġali wúnkulla bara tullokan barúnba kauwȧl labiruġ ġutoara Eloi koba ko: wonto bountoa ba bounnoun kinbiruġ mirrál koba wúnkulla yantin tullokan bounnou̇nba. ");
INSERT INTO awk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ġatun winta koba wiyelliela hieron tin, umatoara unni korien tunuġ ko murrȧrȧġ ko ġatun ġutoara, wiya noa, ");
INSERT INTO awk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Unni tara natan nura ba, uwanȧn ta purreȧġ kariġ ka; korien ġaiya ba wakȧl tunuġ wokka-ka-wokka-ka, yantin wal warekullinún barán. ");
INSERT INTO awk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ġatun bara bon wiyá, wiyelliela, Piriwȧl, yakounta-ke unni tara kánu̇n? ġatun minariġ túġa kánún unni tara ba ġaiya kȧnu̇n? ");
INSERT INTO awk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ġatun noa wiyá, Yakoai nura, ġakoiya kora koa nura ka-uwil; kulla kauwȧl-kauwállo tanan uwánún emmouġ kin yitirra, wiyellinu̇n, ġatoa ta (Kritht ta); ġatun papai ta kakillin; yanoa uwa yikora nura barun. ");
INSERT INTO awk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ġurrȧnu̇n ġaiya nura ba wurawai kauwȧl ġatun koakillai ta ba, kinta kora nura: kulla unni tara kȧnu̇n wal kurri-kurri, kulla wirán keawai kȧnu̇n kabo. ");
INSERT INTO awk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wiya ġaiya noa barun, Bara ku̇riko wuruwai wal kȧnu̇n barun ku̇riko, ġatun bara piriwȧl koba barun piriwȧl koba ko: ");
INSERT INTO awk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ġatun purrai tako pulululu kakilliko winta ka bo, ġatun kunto korien ta ko, ġatun munni kauwȧlkan; ġatun kinta nakilli tara ġatun kauwȧl kȧnu̇n túġa morokó kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","W onto ba kurri-kurri ka unni tara ba kȧnu̇n, manu̇n wal bara mȧttȧrro nurun, ġatun yarakai nurun umánu̇n, ġumullinu̇n nurun thunagóg kako, ġatun jail ko, mantoaro nurun mikan ta ko piriwȧl lako, ġatun wiyellikan tako emmouġ kinko yitirra ko. ");
INSERT INTO awk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ġatun unni ta kȧnu̇n nurun túġa kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yanoa nura kota yikora minki ko, minariġ nura wiyayellinu̇n. ");
INSERT INTO awk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kulla baġ ġunu̇n nurun kurraka ġatun ġuraki kakilliko, keawai wal yantin bara nurúnba bukka-kan-to kaiyu kȧnu̇n wiyayelliko ġa pirriral umulliko. ");
INSERT INTO awk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ġatun nura ġakoiyellinún wal nurun biyuġbaito ġatun kóti tako kariġ ko, ġatun winta nurun kinbiruġ búnnu̇n wal tetti barun kai. ");
INSERT INTO awk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ġatun nurun yarakai umȧnu̇n yantinto, emmoúmba tin yitirra tin ");
INSERT INTO awk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wonto ba keawai wal wakȧl kittuġ ġikouġ, kinbiruġ wolluġ kabiruġ tetti kȧnúu̇n. ");
INSERT INTO awk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Murrȧi kakillikanne nurúnba ka, miromulla nura marai nurúnba? ");
INSERT INTO awk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ġatun nanu̇n nura ba Hierothalem kirrai-kirrai ta ba konara ba ġurrulla papai ta ba ġaiya wari-warekulli ta ba unnuġ. ");
INSERT INTO awk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Murrabunbilla ġaiya barun Iudaia kaba waita bulkȧrá kolaġ; ġatu uwabunbilla barun willi kaba waita warai tako; ġatun uwabunbi yikora barun tanan koruġ kaba untako. ");
INSERT INTO awk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kulla yakita unti tara purreȧġ ka bukka kakillikanne, kauwil koa yantin upatoara kȧnu̇n wal kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yapallun bara wonnaikun ġatun bara pittallikun, yakita ġaiya purreȧġ ka! kulla wal kȧnu̇n kauwȧl yarakai purrai ta, ġatun bukka unti yantin ta ku̇ri ka. ");
INSERT INTO awk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ġatun bara tetti kapaiyinu̇n yirrá biruġ, ġatun barun yutinu̇n wal mantoara kakilliko yantin tako purrai kariġ kako: ġatun Hierothalem wattawȧnu̇n barán bara ethȧnékȧl-lo, yakita kalai tako barúnba koba ġoloin kȧnu̇n ethȧnékȧl. ");
INSERT INTO awk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ġatun ġaiya kȧnu̇n wal túġa punnȧl la, ġatun yellana ka, ġatun mirri ka; ġatun purrai taba yarakai ta barun kin ku̇ri ka, ġatun kinta kauwȧl korowa ta ġatun bókkaloġ kólbilaġbullin; ");
INSERT INTO awk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ku̇ri koba búlbúllo kotan kinta-kan-to, ġatun nakilli tabiruġ ġaloa tara kotanan ba uwȧnu̇n purrai kolaġ; kulla wal barun tolomȧnu̇n wal kaiyukan ta moroko koba. ");
INSERT INTO awk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ġatun yakita ġaiya wal nanu̇n Yinal ta kúri koba tanan uwollillu̇n yareil loa kaiyu koa, ġatun killibinbin koa kauwȧl loa. ");
INSERT INTO awk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ġatun kȧnu̇n ba unni tara paipinún, na-uwa wokka-laġ, ġatun wokka-laġ kauwa kia-kia nurúnba wolluġ; kulla tanan uwȧnu̇n paipai nurúnba wommunbillikanne-ta. ");
INSERT INTO awk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ġatun noa wiya barun wakȧl parabol; Na-uwa kokuġ ta, ġatun yantin ku̇lai ta; ");
INSERT INTO awk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Paikullinu̇n bara ba, nanu̇n nura ġatun ġuurrȧnu̇n nura nurun kinbiruġ wunȧl kȧtan paipai taba. ");
INSERT INTO awk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yaki kiloa nura, nanu̇n nura ba unni tara paikulliko, ġurulla ġaiya nura piriwȧl koba Eloi koba kátan papai taba. ");
INSERT INTO awk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wiyan tuloa nurun baġ, Keawai unni willuġġél tetti-tetti kȧnu̇n, yakita-ko ġoloin ba kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Moroko ta ġatun purrai ta kánún wal waita uwȧnu̇n, wonto ba keawai wal emmoúmba wiyellikanne unni tara keawai wal waita uwȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ġatun yakoai nura nurabo, kauwa ba yantin ta nurúnba bu̇lbúl matayel koa katéa-ku̇n ġatun kuttawaiban koa katéa-ku̇n, ġatun umillikéu̇n koa katéa-ku̇n ġali koba moron koba, ġatun yanti ta purreȧġ ka paipinu̇n ġati nurun kin. ");
INSERT INTO awk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kulla pika kiloa yanti uwȧnu̇n untoa purreȧġ ka barun kin yellawan yintin ta yaki tin purrai ta. ");
INSERT INTO awk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tumimilla nura, ġatun wiyellia yanti-katai to, ka-uwil koa nura murrȧrȧġ kakilliko moron ko unti tara biruġ paikullinu̇n wal ġatun ġarokilliko mikan tako yinal lako ku̇ri koba ko. ");
INSERT INTO awk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ġatun purreȧġ ka wiyelliela noa murruġ ka hieron la; ġatun noa uwa waita tokoi ta, ġatun yellawa noa bulkȧra ġiakai yitirra Elaión ka la. ");
INSERT INTO awk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ġatun yantin bara ku̇ri uwa ġorokan ta ġikouġ kinko hieron lako, ġurrulliko bon. ");
INSERT INTO awk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","YAKITA kakulla papai takillikanne nulai lebben korien koba, ġiak yittira Pathak. ");
INSERT INTO awk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ġatun bara piriwȧl hiereuko ġatun ġȧrammateuko nukilliela búnkilli kolaġ bon tetti wirrilliko; kulla bȧra kinta kakulla ku̇ri tin ");
INSERT INTO awk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pulóġkulléu̇n noa Thatánto murruġ ka bon Iudathkin, tarai yitirra ġiakai Ithȧkariot, wakȧl noa dodeka kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gatun noa waita uwá, ġatun wiyelliela barun piriwál hiereunuġ ġat barun kapátin, yakoai noa ba ġakoyánún bon barun kin. ");
INSERT INTO awk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ġatun pitál kakulla, ġatun bara wiya ġukilliko bon arguro. ");
INSERT INTO awk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ġatun noa wiyai, ġatun mittilliela noa ġakomulliko bon barun kin, yakita bara ba konara waita ġaiya uwa. ");
INSERT INTO awk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kakulla ġaiya purreȧġ nulai lebben korien ta, yakita Pathak bunnu̇m wal ba tetti. ");
INSERT INTO awk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ġatun noa yuka Peternuġ ġatun Ioannenuġ, wiyelliela, Yuriġ uwolla umulliko Pathak ta, ta-uwil koa ġéen. ");
INSERT INTO awk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ġatun bara bon wiyá Wonta-ke ġéen umȧnu̇n? ");
INSERT INTO awk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ġatun noa barun wiyá, A! nauwa nura, yakita uwánún nura ba kokerá kariġ ka, unta ġaiya nurun wakȧllo ku̇riko wimbi-kaba-kan-to kokoin-kan-to nuġgurra uwȧnu̇n nurun; wirrobulla bula bon murruġ kolag kokerá kolaġ unta-ko pulóġkullinu̇n noa ba. ");
INSERT INTO awk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ġatun wiyȧnu̇n nura bon kokeratin, Piriwallo wiyan bin, Wonnuġ waiyakan takilliġél, untoa baġ ba tanun Pathak ta emmoúmba katoa wirrobullikan toa? ");
INSERT INTO awk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ġatun nurun túġkaiyȧnu̇n wal noa kauwȧl ta waiyakan wokka kaba wupitoara: unnuġ umulla. ");
INSERT INTO awk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ġatan bara waita uwa, ġatun nakulla bara unni tara yantin ba wiya barun: ġatun bara upéa Pathak ta. ");
INSERT INTO awk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ġatun yakita kakulla hóra ba, yellawa noa barán, ġatun dodeka ta apothol ta ġikouġ katoa. ");
INSERT INTO awk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ġatun noa barun wiyá, Kauwȧl ta emmoúmba kotatoara takilliko unni Pathak ta nurun katoa, ta-uwil koa kurri-kurri tetti kolaġ ke baġ: ");
INSERT INTO awk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kulla baġ wiyan nurun, Keawai wal baġ tanu̇n unta-kȧl kabo ba kȧnu̇n piriwȧl koba ka Eloi koba. ");
INSERT INTO awk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ġatun noa mankulla wimbi, ġatun pitȧlma ġaiya noa, wiyelliela, Mara unni ġukillai koa nurabo: ");
INSERT INTO awk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kulla baġ wiyan nurun, Keawai wal baġ pittȧnu̇n yeai tabiruġ ampelo tabiruġ, kabo koa uwa-uwil piriwȧl koba Eloi koba tanan. ");
INSERT INTO awk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ġatun noa mankulla arto ta, ġatun pitȧlma ġaiya noa, ġatun yiirbuġga, ġatun ġukulla barun, wiyelliela, Unni ta emmoúmba murrin ġutoara nurun kin: umulla unni yanti ġurrulliko tia. ");
INSERT INTO awk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yantibo wimbi takilli biruġ yaréa ka, wiyelliela, Unni wimbi ta wiyatoara ta buġgaikȧl emmouġ kinbiruġ ġoroġ kiroapa nurun kai. ");
INSERT INTO awk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","A! na-uwa, unni ta mȧttȧra ġikoúmba ġakoyelli-kan-to tia, emmouġ katoa ba takilliġél laba. ");
INSERT INTO awk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yuna bo ta wal noa uwȧnún Yinal ku̇ri koba, yanti wiyatoara; yapallun unnoa kúri ġakoyelli-kan-to bon ba! ");
INSERT INTO awk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ġatun bara wiyellan barabo, ġan-to barun kinbiruġ-ko umȧnu̇n ta unni. ");
INSERT INTO awk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ġatun koakillan bara barabo, ġan-ke kȧnu̇n piriwȧl barun kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ġatun noa wiya barun, Bara ta piriwȧl ethȧnékȧl koba katilléu̇n bara; ġatun bara ta katillikan ġiakai yitirra murroġ-tai. ");
INSERT INTO awk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wonto nura ba keawai yanti kȧnu̇n; wonto noa kurrikóġ nurun kinba, kȧmunbilla bon yanti mitti; ġatun noa piriwȧl kȧtan, yanti umullikan ta. ");
INSERT INTO awk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wonnuġ-ke kauwȧl unnuġ, niuwoa yellawan noa ba takilli ta, niuwoa umȧnún noa ba? wiya, unni ta noa yellawollin ba takilli taba? wonto baġ ba kȧtan nurun kinba yanti niuwoa ba umullikan ta. ");
INSERT INTO awk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nura ta emmouġ kin minkéa emmouġ ka ta numatoara: ");
INSERT INTO awk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ġatun ġutan nurun baġ kakilliko piriwȧlġél lako, yanti tia emmoúmba Biyuġbaito ġukulla tia; ");
INSERT INTO awk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ta-uwil koa nura ġatun pitta-uwil emmouġ ka ta takilliġél la emmouġ ka ta piriwȧlġél la, ġatun yellawa-uwil yellawolliġél la piriwȧl koba ka, wiyellin barun konara dodeka ta Ithȧrael koba. ");
INSERT INTO awk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ġatun noa piriwȧllo wiyá, Ela Thimon, Thimon! ġurrulla, Thantánto noa wiyan bin mankilliko kirrai-kirrai koa biloa uma uwil yanti wiet kiloa: ");
INSERT INTO awk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wonto baġ ba wiyelléu̇n ġirouġ kai ġurra-uwil koa bi; ġatun minki bi ba kȧnu̇n, pirralmulla ġaiya barun bi kóti ta ġiroúmba. ");
INSERT INTO awk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ġatun noa wiya bon, Piriwȧl, kȧtan baġ unni miriġil uwolli kolaġ ġikouġ katoa ko jail kolaġ ġatun tetti kakilli kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ġatun noa wiyá, Wiyan banuġ, Peter, keawai wal mukkaka ko tibbinto wiyȧnu̇n unti purreȧġ ka, kurri-kurri ka bi ba ġakoyȧnu̇n tia ġoro-ka ġimillin bi tia ba. ");
INSERT INTO awk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ġatun noa wiya barun, Yuka nurun baġ ba yinuġ korien, ġatun pika korien, ġatun tuġganóġ korien, wiya, nura minariġ lo? ġatun bara wiyá, Keawai. ");
INSERT INTO awk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wiya ġaiya noa barun, Wonto ba yakita unti, niuwoa ba yinuġkan, mamunbilla bon unnoa, ġatun yanti pika; ġatun niuwoa yirra korien, ġumunbilla kirrikin ġikoúmba, wakȧl koa noa ġukilli ko. ");
INSERT INTO awk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Wonto baġ ba wiyan nurum, unni ta upatoara ka-uwil koa emmouġ kin kakilliko ġiakai, Tumbitoara noa barun kin yarakai willuġ ka: kulla unni tara emmouġ kin ba kakillinu̇n ġoloin ko. ");
INSERT INTO awk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ġatun bara wiyá, Piriwu̇l, na-uwa unni tuloa buloara yirra. Ġatun noa wiya barun, Tantoa-bo-ta ");
INSERT INTO awk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ġatun noa uwa warrai koba, ġatun waita uwa uwolli kolaġ bulkȧra kolaġ Elaión ko la kako; ġatun ġikoúmba wirrobulli-kan wirroba bon. ");
INSERT INTO awk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ġatun uwa noa ba unta, wiya ġaiya noa barun, Wiyella, keawai koa nura pulóġkulli korien yarakai kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ġatun noa waita uwa barun kinbiruġ yanti kiloa tunuġ koba pintia, ġatun waroġbugko upullin barán, ġatun wiyá, ");
INSERT INTO awk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Wiyelliela, Biyuġ, wiya bi unni wimbi manu̇n emmouġ kinbiruġ: yanoa emmoúmba kotellikanne ġiroúmba ta kȧmunbilla kakilliko. ");
INSERT INTO awk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ġatun paipéa wakál aġelo moroko kabiruġ pirriralmullin bon. ");
INSERT INTO awk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ġatun kirrinkan noa kanwȧlkan, wiyelliela noa pirriral butti; ġatun ġikoúmba kurrol upulléu̇n barán purrai kolaġ yanti kiloa komonba kauwȧl ġoroġ koba. ");
INSERT INTO awk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ġatun bouġkulléún noa ba wiyelli tabiruġ, ġatun uwa ġikoúmba tako wirrobullikan tako, nakulla ġaiya noa barun birriki birriki minkikan, ");
INSERT INTO awk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ġatun noa wiya barun, Minariġ tin nura birrikin? Bouġkullia ġatun wiyella, uwéa-kun koa nura yarakai kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ġatun yakita wiyelliela noa ba, a! konara, ġatun noa yitirra ġiakai Iudath, wakȧl ta dodeka kabiruġ, uwa ġanka barun kin, ġatun uwa ġaiya noa papai Iéthu kin, búmbúmkakilliko. ");
INSERT INTO awk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wonto noa ba Iéthuko bon wiya, Ela Iudath! ġakoman binuġ Yinal ku̇ri koba búmbuġgullito? ");
INSERT INTO awk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nakulla bara ba ġikouġ kinba minnuġ-bulli kolaġ, wiyabon bara, Ela piriwal! wiya, ġéen búntan yirra ko? ");
INSERT INTO awk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ġatun wakȧl barun kinbiruġ kunbuntéa wakȧl umullikan hiereu koba piriwȧl koba, ġatun kunbuntéa bon túġkaġ-keri ġurréuġ. ");
INSERT INTO awk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ġatun Iéthuko noa wiyayelléu̇n, ġatun wiyelliela, Kamunbilla nura unni. Gatun bon noa numa ġurréuġ ġatun turon bon uméa-kan ");
INSERT INTO awk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wiya ġaiya Iéthuko barun piriwál hiereu koba, ġatun barun kapȧtin hieron koba, ġatun barun ġarrokȧl, uwa bara ġikouġ kin, Wiya, nura tia uwan yanti mankiye ko yarakaikan ta, yirrakan ġatun kotarakan? ");
INSERT INTO awk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kakulla baġ ba nurun kin yanti-katai purreȧġ ka hieron ka, keawai nura tia manpa mȧttȧrro: wonto ba unni yakita ta katan nurúnba ġatun kaiyukan tokoi tako. ");
INSERT INTO awk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mankulla ġaiya bara bon, ġatun yutéa bon, mankulla ġaiya bon kokera ko piriwȧl koba kako hiereu koba kako. Gatun Peterko noa wirroba kaloġ kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ġatun upilléu̇n bara ba koiyuġ ko willi ka kokera, ġatun yellawa yantin, Peter ġaiya noa yellawa barun kin. ");
INSERT INTO awk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ġatun taraito murrakinto nakulla bon, yellawa noa ba koiyuġ ka ġatun pimmilliela bon pirrallo, ġatun wiya, Unni noa ku̇ri kakulla ġikouġ katoa. ");
INSERT INTO awk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ġatun noa ġakoiya bon, wiyelliela, Ela murrakin! keawai bon baġ ġimilli korien. ");
INSERT INTO awk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ġatun toanta taraito bon nakulla, ġatun wiyelliela, Gintoa ta yanti bo barúnba. Gatun noa Peterko wiyá, Ku̇ri, keawaran baġ. ");
INSERT INTO awk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ġatun, yakita toanta, wakál hora ta yukita, taraito wiya pirralma wiyelliela, Yuna bo ta unni kuri kakulla ġikouġ katoa; kulla noa Galilaiakȧl. ");
INSERT INTO awk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ġatun noa Peterko wiyá, Ela ku̇ri! keawai baġ ġurran yakoai bi ba wiyan. Ġatun wiyelliela noa ba, tanoa-kal-bo muk-kaka-ko ġaiya wiya tibbinto. ");
INSERT INTO awk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ġatun noa Piriwȧl warkulléu̇n,ġatun nakilléu̇n bon Peternuġ. Ġatun Peterko noa ġurra wiyellita Piriwȧl koba, wiya bon noa ba ġiakai, Gikoyȧnu̇n wal bi tia kurri-kurri tibbinto mukkaka ko wiyȧnu̇n ġoro-ka. ");
INSERT INTO awk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ġatun Peter noa uwa warrai koba, ġatun tu̇ġkilléu̇n ġaiya noa kauwȧl. ");
INSERT INTO awk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ġatun bara ku̇riko mankulla bon Iéthunuġ béelma bon, ġatun bu̇nkulla bon. ");
INSERT INTO awk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ġatun munmin bara ba upéa bon, bu̇nkulla ġaiya bon bara ġoará, gatun wiya bon, wiyelliela, Wiyella bi, ġanto-ke bin búnkulla? ");
INSERT INTO awk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ġatun kauwȧl-kauwȧl taraikan yarakai wiya bara ġikouġ kin. ");
INSERT INTO awk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ġatun purreȧġ ba kakulla, kau-umullan ġaiya bara ġarrotai ku̇ri koba, ġatun bara piriwȧl hiereu koba, ġatun bara ġȧrammateu, ġatun yutéa ġaiya bon kau-umulliġél lako barúnba tako, ");
INSERT INTO awk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wiyelliela, Kritht ta bi unni? wiyella ġearun. Ġatun noa wiya barun, Wiyȧnu̇n nurun baġ ba, keawai ġaiya wal nura ġurrȧnu̇n: ");
INSERT INTO awk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ġatun wiyánún nurun baġ ba, keawai wal nura wiyaiyellinún tia, keawai wal nura tia wamunbinu̇n. ");
INSERT INTO awk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kabo noa Yinal ku̇ri koba yellawȧnu̇n túġkaġ ka kaiyukan ta Eloi koba ka. ");
INSERT INTO awk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wiya ġaiya bara yantinto, Yinal ta bi unni Eloi koba? Gatun noa wiya barun, Wiyan nura ġatoa ta unni. ");
INSERT INTO awk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ġatun bara wiya tantoa ta, Yanoa ġearun kin ġurrullikanto taraito? kulla ġéen ġurra ġéebo kurraka kabiruġ, ġikouġ kinbiruġ kóti kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ĠATUN bara yantin konara bouġkulléu̇n, ġatun yutéa bon Pilato kin. ");
INSERT INTO awk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ġatun bon bara pirralma, wiyelliela, Ġurra ġéen bon unni ġakoyelliela noa ba barun ku̇ri willuġġél, ġatun wiyelliela, yanoa ġuki yikora tullokan Kaitharinuġ, wiyelliela, niuwoa-bo-ta Kritht ta wakȧl ta Piriwȧl. ");
INSERT INTO awk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ġatun Pilato-to wiya bon, wiyelliela, Ġa ġintoa ta Piriwál kátan baru̇nba Iudaioi koba? Ġatun noa wiyayelléún bon, ġatun wiyá, Ġintoa ta wiyan. ");
INSERT INTO awk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wiya ġaiya noa Pilato-to barun piriwál hiereu ġatun barun ku̇ri, Keawai baġ ġurra pa yarakai unti ku̇ri ka. ");
INSERT INTO awk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ġatun bara bukka-buttibuġkéa, wiyelliela, Pirralman noa barun ku̇ri wiyellin, yantin ta Iudaia ka, Galilaia tinto unti kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ġurra noa ba Pilato-to Galilaia ka, wiya noa, Unni kúri Galilaiakȧl? ");
INSERT INTO awk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ġatun ġurra noa ba Herodúmba-kan noa wottaikan, yuka bon noa Herod kinko, yakita ġaiya niuwoabo kakulla Hierothalem ka. ");
INSERT INTO awk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ġatun nakulla bon noa ba Herodto Iéthunuġ, pitȧl ġaiya noa kȧtan kauwȧl, kulla noa natelli ba bon yuraki tabiruġ, kulla noa ġurra kauwȧllan ġikouġ kinba; ġatun nakilliko tarai umatoara ġikouġ kai. ");
INSERT INTO awk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wiya ġaiya bon noa wiyellikanne kauwȧl-kauwȧl; wonto noa ba keawai wiyelli pa bon. ");
INSERT INTO awk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ġatun bara piriwȧl hiereu ġatun bara ġȧrammateu ġarokilliela, ġatun pirralmulliela bon kauwȧl. ");
INSERT INTO awk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ġatun Herod katoa ba bara wuruwai koba ġurramaiġa bon bara, ġatun béelma bon, ġatun wuda bon konéin to kirrikin to, ġatun yukéa-kan bon Pilato kinko. ");
INSERT INTO awk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ġatun unta purreȧġ ka wakȧl la, Pilato ġatun Herod kóti bula umullan: yakita unta kakillan bula bukkakan bula-bo. ");
INSERT INTO awk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ġatun Pilato-to noa kau-wiya noa ba barun piriwȧl hiereu, ġatun barun piriwȧl, ġatun barun ku̇ri, ");
INSERT INTO awk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Wiya ġaiya barun, Mankulla nura bon unni ku̇ri eummouġ kinko yanti wakȧl noa ġakoya-uwil ba ku̇ri; ġatun, a! ġurulla, nuiya ta bon baġ unni mikan ta nurun kin keawai baġ ġurrapa yarakai ġikouġ kin, ġinoa-tara tin pirralma bon nura: ");
INSERT INTO awk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Keawaran, keawai Herodto: kulla baġ yuka nurun ġikouġ kin; ġatun nauwa, keawai ġali tin tetti korien noa kȧnu̇n. ");
INSERT INTO awk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wélkorinu̇n wal bon baġ, ġatun wamunbinún ġaiya bon. ");
INSERT INTO awk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Kulla noa buruġbuġgȧnu̇n wal wakȧl yakita ta takillikan ne ta.) ");
INSERT INTO awk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ġatun bara kaaibulléu̇n wakȧlla purawai, wiyelliela, Yuriġ unni kúri; ġatun buruġbuġgulla bon Barabbanuġ ġearun kinko: ");
INSERT INTO awk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ġali noa wakȧl wuruwai tin kokerá ġatun búnkilli tin tetti tin wúnkulla bon jail ka.) ");
INSERT INTO awk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Koito noa ba Pilato-to kotelliela buruġbuġgulliko bon Iéthunuġ, wiyéa ka barun. ");
INSERT INTO awk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wonto bara ba wiyá, wiyelliela, Buwa bon tetti, buwa bon tetti. ");
INSERT INTO awk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ġatun noa barun wiya yukita ġoro-ka, Minariġ tin? minariġ noa yarakai umá? keawai baġ ġurrapa taraikan ġikouġ kin ġaloa kolaġ búnkilli kolaġ tetti wirrilliko; wélkorinu̇n wal bon baġ, ġatun wamunbinu̇n bon. ");
INSERT INTO awk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ġatun bara tanoa-kȧl-bo pulli kakulla kauwȧl, wiyelliela, búwil koa bon tetti. Ġatun pulli baru̇nba ġatun barúnba piriwȧl hiereu pirral kakulla. ");
INSERT INTO awk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ġatun Pilato-to noa wiyá, ka-uwil koa yanti wiya bara ba. ");
INSERT INTO awk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ġatun noa bon buruġbuġga barun kin unni bon wuruwai tin ġatun bunkilli tin tetti tin wúnkulla bon jail ka wiyatoara barúnba; ġatun noa bon Iéthunuġ wamunbéa barun kin. ");
INSERT INTO awk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ġatun yutéa bon bara ba yuriġ, mankulla ġaiya bara wakál Thimónnuġ Kureniakȧl ta, tanan uwolliela koruġ tin, ġatun wupéa bara ġikouġ kin taliġkabillikanne, kurri-uwil koa noa willuġ tin Iéthu katoa. ");
INSERT INTO awk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ġatun wirroba bon bara kauwállo konaro, ġatun bara nukuġ-ko, túġkilliela ġatun minki kakilliela ġikouġ kai. ");
INSERT INTO awk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Wonto noa ba Iéthu warkulléu̇n barun kai koba, wiyá, Yinálkun Hierotilalemkȧlin, túġki yikora emmouġ kai, wonto ba túġkillia nura nurunbo, ġatun nurun kaiko wonnai tara ko. ");
INSERT INTO awk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","A! na-uwa, purreuȧġ kariġ tanan uwollinu̇n, yakita unta wiyȧnu̇n bara ba, Murrȧru̇ġ bara wonnai korien, ġatun unnuġ tara pika keawai pórkulli korien, ġatun paiyil keawai pittelliko. ");
INSERT INTO awk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yakita ġaiya bara wiyellan bulkȧra kariġ, Puntimullia ġearun kin, ġatun yúnko ko, Wutilla ġearun. ");
INSERT INTO awk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ġatun uwullinu̇n bara ba unni tara ku̇lai ta kiruġ ka, minnuġ banu̇n wal ku̇lai ta turrȧl la? ");
INSERT INTO awk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ġatun unnuġ bula taraikan yarakai willuġ, yutéa ġikouġ katoa wúnkilliko tetti wirrilliko. ");
INSERT INTO awk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ġatun uwa bara ba unta ko, ġiakai yitirra Kalȧbary, unta ġaiya bara búnkulla bon ġatun bulun yarakai bula, wakȧl ta túġkaġ-keri ka ġatun tarai ta wunto-keri ka. ");
INSERT INTO awk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Wiya ġaiya noa Iéthuko, Biyuġ, kȧmu̇nbilla barun, kulla bara keawai ġurra korien umulli ta. Ġatun toinbillan bara kirrikin ġikoúmba, ġatun wupillan woiyo. ");
INSERT INTO awk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ġatun bara nakilliela ġarokito. Ġatun bara piriwȧl yantibo barun katoa béelmulliela, wiyelliela, Miromá noa taraikan; miromabunbillia bon ġikouġ kóti, wiya noa ba Kritht ta, ġirimatoara Eloi-úmba. ");
INSERT INTO awk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ġatun bara militiko béelma bon, uwolliela ġikouġ kin, ġatun nupilliela bon aket, ");
INSERT INTO awk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ġatun wiyelliela, Wiya bi ba piriwál Iudaioi koba, miromullia bi ġintoabo kóti. ");
INSERT INTO awk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ġatun upulléu̇n wakȧl upatoara wokka ka ġikouġ kin pulli Hellenik koba, ġatun Latin koba, ġatun Hebȧraio koba, ġiakai, Unni ta Piriwál Iudaioi koba. ");
INSERT INTO awk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ġatun wakȧllo yarakai bulun kinbiruġ-ko, kakilliela ba ku̇lai ta, béelmulliela bon, wiyelliela, Wiya bi ba Kritht ta, miromullia bi ġintoabo ġatun ġearun. ");
INSERT INTO awk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wonto ba taraito wiyayelléuu̇n, koakilliela bon, wiyelliela, Keawai bi kinta korien Eloi kai, ġatun ġintoa ta kȧtan wakȧl la umatoara? ");
INSERT INTO awk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ġatun ġalin yakita murrȧrȧġ umá; yaki tin ġalin kai umatoara tin: wonto noa ba ġali ku̇riko, keawai noa yarakai umá pa. ");
INSERT INTO awk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ġatun noa wiya Iéthunuġ, Piriwȧl, ġurrulla bi tia, uwȧnu̇n ġaiya bi ba piriwȧlġél lako ġirouġ ka tako. ");
INSERT INTO awk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ġatun noa Iéthuko wiya bon, Yuna bo ta wal baġ wiyan ġirouġ, Unti buġgai purreȧġ ka kȧnu̇n bi tia emmouġ katoa Parȧdeith ka tako. ");
INSERT INTO awk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ġatun yakita kakulla hora ka hekto ta, tokoi ta kakulla yantin ta purrai ta katéa ka hóra kako nain tako. ");
INSERT INTO awk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ġatun punnȧl ta tokoi kakulla, ġatun kirrikin ta hieron kako yiirkulléu̇n búlwa koa. ");
INSERT INTO awk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ġatun noa ba Iéthuko kaaibulléu̇n wokka wiya noa, Biyuġ, wunu̇n baġ emmoúmba marai ġirouġ kin mȧttȧra; ġatun wiyelléu̇n noa ba unni, wu̇nkulla ġaiya noa marai ");
INSERT INTO awk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yakita ġaiya noa ba kenturionko nakulla unni umatoara, pitȧlma noa Eloinuġ, wiyelliela, Yuna bo ta wal murrȧrȧġ unni ku̇ri. ");
INSERT INTO awk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ġatun bara yantin ku̇ri uwa nakilliko ġala ko umatoara ko, wirrilléu̇n bara wapara, ġatun willuġbo bara uwa. ");
INSERT INTO awk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ġatun yantin ġikoúmba kóti ta, ġatun bara nukuġ wirroba bon Galilaia kabiruġ, ġarokéa kaloġ ka, nakilliela unni tara. ");
INSERT INTO awk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ġatun kakulla wakȧl ku̇ri, ġiakai yitirra Yothep, wiyellikan kȧtan; murrȧrȧġ kakillikan, ġatun tuloa kakillikan: ");
INSERT INTO awk_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ġali keawai noa pitȧl korien barúnba ko wiyellikanne ko ġatun barúnba umatoara ko; Arimathéakȧl noa, wakȧl ta kokera Iudaioi koba; niuwoa ba mittilliela piriwál lako Eloi koba kako. ");
INSERT INTO awk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Unni noa uwa Pilato kin, bon wiyelliko murrin ko Iéthu koba ko. ");
INSERT INTO awk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ġatun noa mankulla barán, ġatun muġgama kirrikin ta, ġatun wúnkulla tulmun ta umatoara tunuġ ta; keawai ba unta ku̇ri wúntelli ta. ");
INSERT INTO awk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ġatun unta purreȧġ ka tupoi-tupoi-kanne-ta, ġatun papai kakulla thabbat ta. ");
INSERT INTO awk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ġatun bara nukuġ uwa ġikouġ katoa Galilaia kabiruġ wirroba yukita, ġatun nakulla tulmun, yakoai ba wúnkulla murrin. ");
INSERT INTO awk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ġatun bara willuġbo, ġatun mankulla aromata ġatun mura; ġatun koréa purreȧġ ka thabbat ta, yaki tin wiyatoara tin. ");
INSERT INTO awk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","YAKITA kakulla puneȧġ ka yukita thabbat biruġ ka,ġoiokan ta, uwa bara unti ko tulmun tako, mankillin aromata umá bara ba, ġatun taraikan uwa barun katoa ");
INSERT INTO awk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ġatun bara nakulla tunuġ umatoara kurrai-kurrai biruġ kurraka ko tulmun tabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ġatun bara uwa murrariġ, ġatun keawai bara na korien murrin ta Piriwál koba Iéthu koba. ");
INSERT INTO awk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ġatun yakita kakulla, kotelliela bara ba ġe tin, a! buloara ku̇ri bula ġarokéa barun kin killibinbin kaba kirrikin taba, ");
INSERT INTO awk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ġatun bara ba kinta kakilliela, ġatun wu̇nkulliela barúnba ġoara baran purrai tako, wiya bula barun, Minariġ tin nura nakillin moron-kan ta unti tetti-tetti ka? ");
INSERT INTO awk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Keawai noa unti, kulla noa waita ka ba bouġkulléún: ġurrulla nura yanti wiya nurun noa ba, yakita noa ba kakulla Galilaia ka, ");
INSERT INTO awk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wiyelliela, Yinal ta ku̇ri koba wunu̇n wal bon mȧttȧra yarakai-willuġ koba ka, ġatun búnnu̇n wal tetti, ġatun purreȧġ ka tarai ka kúmba-ken bouġkullia kȧnu̇n noa. ");
INSERT INTO awk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ġatun ġaiya bara kotelliela ġikoúmba wiyelli tara, ");
INSERT INTO awk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ġatun willuġbo bara uwa tulmun tabiruġ, ġatun wiya unni tara barun kin dódeka ta, ġatun barun yantin ta. ");
INSERT INTO awk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ġala bountoa Mari-ko Magdalakȧlin-to, ġatun bountoa Ioanna-ko, ġatun bountoa Mari-ko tunkan-to Yacóbo-úmba-ko, ġatun taraikan-to bara nukuġ-ko barun katoa, wiya unni tara barun apotholnuġ. ");
INSERT INTO awk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ġatun bara ba wiyelli tara kakulla barun kin yanti kiloa ġakoyelli tara, ġatun bara keawai ġurraiyelli pa barun. ");
INSERT INTO awk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peter ġaiya noa ġarokéa, ġatun murra tulmun tako; ġatun woinkulliela barán, nakulla noa kirrikin wuntoara pitaka, ġatun waita noa uwa, kotelliela unni tara kátan ba. ");
INSERT INTO awk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ġatun yakita purreȧġ ka yantibo, buloara-bula barun kinbiruġ uwa kokerá kolaġ, ġiakai yitirra Emmaou, yakita kaloġ Hierothalem kabiruġ purloġ hekékonta ta. ");
INSERT INTO awk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ġatun bara wiyellan unni tara kakulla ba. ");
INSERT INTO awk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ġatun yakita kakulla, wiyelliela ba, ġatun kotelliela bara ba, Iéthu noa niuwoabo uwa papai barun kin, ġatun uwa barun katoa. ");
INSERT INTO awk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wonto ba ġaikuġ barúnba tullamá, ġimilli korien koa bara bon. ");
INSERT INTO awk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ġatun noa wiya barun, Minariġ, nura unni tara wiyellan, uwollin nura ba, ġatun minki kátan? ");
INSERT INTO awk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ġatun wakȧl bulun kinbiruġ, ġiakai noa yitirra Kleopa, wiyayelléu̇n, wiyelliela bon, Ġintoa bo ta wakȧl ġowikan Hierothalemkál, ġatun keawai unni tara ġurrapa kakulla ba unti tara purreȧġ ka? ");
INSERT INTO awk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ġatun noa wiya barun, Minariġ-ke unni wonnuġ? Gatun bon bara wiyá, Gikouġ kin Iéthu kin Nadharetkȧl unni kakulla propet ta kaiyukan umulliko ġatun wiyelliko mikan ta Eloi koba kin, ġatun yantin ta barun kin ku̇ri ka: ");
INSERT INTO awk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ġatun yakoai bara ba piriwál hiereu, ġatun ġearúnba piriwál kariġ wúnkulla bon wiyayelliko tetti kolaġ, ġatun bara bon búnkulla tetti. ");
INSERT INTO awk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wonto ġéen ba kota niuwoa miromulliko Ithȧraelnuġ: ġatun yantin unni tara ba, unni buġgai kúmba-ken-ta kȧtan unnoa tara umatoara biruġ ");
INSERT INTO awk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kauwa, tarai bara nukuġ ġearúnba konara biruġ kota bunbéa bala ġearun, bara ġoiokéen kȧtan tulmun ta: ");
INSERT INTO awk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ġatun keawai bara ba na pa ġikoúmba murrin, uwa ġaiya bara, wiyelliela, nakéu̇n bara natoara aġelo kariġ koba wiya moron noa kakulla. ");
INSERT INTO awk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ġatun taraikan barúnba ġearun kinba uwa tulmun kolaġ, ġatun nakulla yanti bara nukuġko wiya; keawai bon bara na korien. ");
INSERT INTO awk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wiya ġaiya noa barun, A! woġkȧl nura, ġatun pirriral búbúl ġurrulliko yantin ta wiyatoara bara ba propet to! ");
INSERT INTO awk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keawai noa Kritht kȧmu̇nġinbia ta umatoara ba unni tara, ġatun uwolliko kirrikin kolaġ ġikouġ ka tako? ");
INSERT INTO awk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ġatun kurri-kurri Mothe ko noa ba wiya, ġatun yantin to propet kariġ ko, ġurrabunéa ġaiya noa barun unnoa tara upatoara biruġ ġikouġ kai. ");
INSERT INTO awk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ġatun bara papai uwa unta kolaġ kokerá kolaġ, unta kolaġ bara: ġatun noa puntelliela kaloġ kolaġ. ");
INSERT INTO awk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wonto bara ba pirralma bon, wiyelliela, Kauwa ġearun katoa; kulla wal yaréa kakillilin, ġatun purreȧġ ta waita uwollilin. Ġatun noa uwa murrariġ kakilliko barun katoa. ");
INSERT INTO awk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ġatun yakita kakulla, yellawa noa ba barun katoa takilliko, mankulla noa arto, ġatun pitȧlma noa, ġatun yiirbuġga, ġatun ġukulla ġaiya barun. ");
INSERT INTO awk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ġatun ġaikuġ barúnba buġkulléu̇n, ġatun ġimilléu̇n ġaiya bara bon; noa ġati kakulla barun kinbiruġ. ");
INSERT INTO awk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ġatun bara wiyellan barabo, Wiya, ġearúnba búlbúl winna ba ġearun kinba ko murruġ kaba ko, wiyelliléu̇n noa ba ġearun katoa, ġatun ġurrabunbéu̇n noa ba ġearun upatoara ta? ");
INSERT INTO awk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ġatun bouġkulléu̇n tanoa-kȧl-bo ġatun willuġ ba kakulla Hierothalem kolaġ, ġatun nakulla barun hendeka ta, ġatun barun taraikan barun katoa, ");
INSERT INTO awk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Wiyelliela, Bouġkulléu̇n bo ta yuna Piriwȧl ta, ġatun paikulléu̇n Thimon kin. ");
INSERT INTO awk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ġatun bara wiya unni tara upatoara yapiġ koa, ġatun ġimilléu̇n bara bon yiirbuġgulliela noa ba arto. ");
INSERT INTO awk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ġatun bara ba wiyelliela, Iéthuko noa niuwoabo ġarokéa willi ka barun kin, ġatun wiya barun noa, Pitȧl nura kauwa. ");
INSERT INTO awk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wonto bara ba pulul-pulul kakulla ġatun kinta-kan, ġatun kotelliela bara marai ta bara nakulla. ");
INSERT INTO awk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ġatun noa wiya barun, Minariġ tin nura kinta kȧtan? ġatun minariġ tin nurúnba búlbúllo kotan? ");
INSERT INTO awk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nauwa tia máttára emmoúmba, ġatun yulo emmoúmba, Gatoa bo: numulla tia, ġatun nauwa; kulla keawai marai koba purriu̇ġ korien ġatun tibun korien, yanti nakulla nura tia ba emmoúmba. ");
INSERT INTO awk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ġatun wiya noa ba unni, túġumbéa barun noa ġikoúmba mȧttȧra ġatun yulo. ");
INSERT INTO awk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ġatun keawai bara ba ġurra pitȧl ko, ġatun kotelliko, wiya noa barun, Wiya, nuruúnba kunto unti? ");
INSERT INTO awk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ġatun bara bon ġukulla pundol koiyubatoara makoro biruġ, ġatun pundol nuparai kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ġatun noa mankulla, ġatun takulla barun kin mikan ta. ");
INSERT INTO awk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ġatun noa wiya barun, Unni tara wiyellikanne-ta wiya nurun baġ ba, kakulla baġ ba nurun katoa, yantin koa ka-uwil kakilliko upatoara wiyellikanne-ta Mothé-úmba, ġatun barun ba propet koba, ġatun tehillim kaba, emmouġ kai. ");
INSERT INTO awk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ġurrabunbéa ġaiya noa barun, ġurra-uwil koa bara upatoara ta; ");
INSERT INTO awk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ġatun wiya noa barun, Yaki upatoara, ġatun yaki murrȧraġ ta Kritht ko ġikouġ kakilliko tetti ko, ġatun bouġkulliko kúmba-ken-ta purreȧġ ka tetti kabiruġ: ");
INSERT INTO awk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ġatun wiyabunbi-uwil koa minkikanne-ta ġatun warekullikanne-ta yarakai umullikan ko ġikouġ katoa biruġ yitirra biruġ yantin ta konara, kurri-kurri kabiruġ Hierothalem kabiruġ. ");
INSERT INTO awk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ġatun nura nakillikan kȧtan ġali tara ko. ");
INSERT INTO awk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ġatun, ġurrulla, wupin baġ nurun kin wiyatoara emmoúmba koba Biyuġbai koba: wonto nura ba minkéa kokerá Hierothalem ka, kaiyu koa nurun kauwȧl búlwára tin. ");
INSERT INTO awk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ġatun yutéa noa barun kaloġ kolaġ Bethany ka bo, ġatun noa wupiléu̇n mȧttȧra ġikoúmba wokka-laġ, ġatun pitȧlma noa barun. ");
INSERT INTO awk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ġatun yakita kakulla, yaki pitȧlmulliela noa ba barun, mantilléu̇n ġaiya bon barun kinbiruġ, ġatun kurréa bon wokka-laġ moroko kako. ");
INSERT INTO awk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ġatun bara bon murrȧrȧġ koiyelliela, ġatun willuġ ba kakulla Hierothalem kolaġ kauwȧl-kan pitȧl-kan: ");
INSERT INTO awk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ġatun kakilliela murruġ hieron ka, murrȧrȧġ wiyelliela ġatun pitȧlmulliela bon Eloinuġ. AMEN. ");
ALTER TABLE awk_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
