﻿USE sofia;
DROP TABLE IF EXISTS sofia.awb_vpl;
CREATE TABLE awb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES awb_vpl WRITE;
INSERT INTO awb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sísa Karáhéne aigaqnaréh síwíqmari mahraue kéhre. Sísawe Tébíti kahnáhne. Tébítiwe Ébáráhma kahnáhne. ");
INSERT INTO awb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ébáráhmawe Áhísáhkine abowáe. Áhísáhkiwe Sékópane abowáe. Sékópawe Súrareh ábárahnahnahne sibowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Súrawe Pérésareq Sérareqne sibowáe. Mi aníténé sinowawé wenáwíq Támárie. Pérésawe Ésárónine abowáe. Ésáróniwe Árámine abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Árámiwe Ámínárápane abowáe. Ámínárápawe Násónine abowáe. Násóniwe Sámónine abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sámóniwe Póásine abowáe. Póásine anowawé wenáwíq Áráhpae. Póásiwe Óbétine abowáe. Óbétine anowa wenáwíq Árútie. Óbétiwe Sésine abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sésiwe Tébíti anotah wahnáhné abowáe. Tébítiwe Sórómónine abowáe. Sórómónine anowawé téhwe Úríane ahre míowe. ");
INSERT INTO awb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sórómóniwe Áréóbóámane abowáe. Áréóbóámawe Ábíyane abowáe. Ábíyawe Ásane abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ásawe Séhósápátine abowáe. Séhósápátiwe Séórámane abowáe. Séórámawe Úsíane abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Úsíawe Sótámane abowáe. Sótámawe Áhásane abowáe. Áhásawe Ésékíane abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ésékíawe Mánásene abowáe. Mánásewe Émónine abowáe. Émóniwe Sósáíane abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sósáíawe Séhóíákínireh ábárahnahnahne sibowáe. Mi tanáhráq Pábíróni marákóípéqté kégá Ísara ke táhtoqme meriqmera sene marakórapeq mórítówe. ");
INSERT INTO awb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pábíróni marákórápéq mórítówana Séhóíákíniwe Séátíérane abowáe. Séátíérawe Sérúbábérane abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sérúbábérawe Ábíútine abowáe. Ábíútiwe Éríákímane abowáe. Éríákímawe Ásórane abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ásórawe Sárókine abowáe. Sárókiwe Ékímane abowáe. Ékímawe Éríútine abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Éríútiwe Éréásane abowáe. Éréásawe Mátánine abowáe. Mátániwe Sékópane abowáe. ");
INSERT INTO awb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sékópawe Sósépane abowáe. Sósépawe Máhríane awehkawae. Máhríaga Sísa maqmarowara mi anímé Karáhée atowe. Karáhéwé áwahewé ite meirena kaweraitankeheéna Manikánka we omaq atowe. ");
INSERT INTO awb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ébáráhma míotaqtenue Tébítitaq seuwekue airápété itaréitaré ábáhnínáhnah míówe. Tébíti míotaqtenue Pábíróni marákórápéq mórítótaq seuwekue mó airápété itaréitaré ábáhnínáhnah míówe. Pábíróni marákórápéq mórítótaqtenue Karáhéga marakóipeq tutaq seuwekue mó 14 se ábáhnínáhnah míówe. ");
INSERT INTO awb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sísa Karáhé maqmaro ehwéh teiníboq íráhro. Wenano Máhría Sósépaga ahreyabéútaq Sósépareq íre nogúyataq Manikáne Awanka iwíáh atowana kía míowe. ");
INSERT INTO awb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sósépaga ahriahri peh kaweq sansánúwe. Wega meyanaú ahrégá kía mío ehwéh irena wega iwíáhéna, Mó wehreq nogoye éna Máhría ayehitéhneho éna wehuke míótaq íre ehweh atasa peh auwaníe íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mira íwíáhúwana Maniká itene Wahnah míéhrabeq íópeqté ánínká áónáh atena wensabé, Sósépao, Tébíti kahnáh áníno, írátíahno. Manikáne Awanka iwíáh atéhrana Máhría kía míéhre. Minayabe we meweyabe íre áhreúno. ");
INSERT INTO awb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","We animai maqmiahnana wega wehukene ahbabáq kaweraritena merirankéhe. Minayabe wenáwíq Sísae ato úwe. ");
INSERT INTO awb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Minayabe Manikánka iwíáh atowana wene ehweh irarú aninká mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Írátíáhro. Wehreq íre nogu ahrárígá kía ména animai maqmiahnara Émánúérae atagéhe úwe. Mi awíqmé Émánúérawé áwahewé Maniká itereq mía míai áwíre. ");
INSERT INTO awb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sósépaga áónáhéna irigútaq itene Wahnah míéhrabeq íópeqté ánínká teawu ehwéh sehgiena Máhría meyowe. ");
INSERT INTO awb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wega mewena Máhríaga ani íre maqmiotaq Sósépaga peh míowana animai maqmarowana Sísae áwíratowe. ");
INSERT INTO awb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Anotah wahnáh aní wenáwíq Éróti Súría marákórápéqté kéné wahnah míotaq Máhríaga Pétáríéma suwahpeq Sísa maqmiowe. Maqmiowara íó kiembogirabeqte ké ahtebia kégá Sarúsarama suwahpeq suwe. ");
INSERT INTO awb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Sega mibeqté kéyábé, Inahunahní Asiu kené anotah Wahnáh úkína anímé eheq míehro? Íó kiembogirabeq wehyoqka, Anotah Wahnáh maqmarehre sokigi aínsábé wensabé iwíáh íwíáh ataneheéq súne uwe. ");
INSERT INTO awb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Uwana Érótiga mi ehwéh irena wene arupipeq iwíáh kikirúwara moke Sarúsarama suwahpeqte kéné sirupipeq moq iwíáh kikiruwe. ");
INSERT INTO awb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Érótiga moke Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísiga sehgíóro ú ehweh síwáhnoro kereq síáhrabéna sensabé, Wehuke merirankeheéna Manikánka omaq ato aní eheq maqmianabo úwe. ");
INSERT INTO awb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Úwara sega wensabé, Súría marákórápéq Pétáríéma suwahpeq maqmianae éra minayabe Manikáne ehweh irarú aninká sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pétáríéma suwahpeqte kéo, Súría marákórápéq moke mó kehiná suwahpeq iteruwahpeq kiotaikiro? Írakaumo. Pétáríéma suwahpeq anotah aní maqmarahnana mi anínká néne animárí Ísara ke wahnahnéna kaweq ah sokigi arinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Érótiga íó kiembogirabeqte ké kopéq síáhrabúwara sega weba suwana sensabé, Téhwe mi wehyóq aneq tanáhráq ábóraragurairo kasenúwara teawúwe. ");
INSERT INTO awb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Teawúwana mi keyábé mahraréna, Mi karíq ánínsábé kawerue kogabaroro. Mi aní koábóraq máréhrataq íné moq koiwíáh íwíáh ataníboq sereníéro éna Pétáríéma suwahpeq eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Eqmaq suowara pokue ahtaqpeq míówana pópoqnah kiembogirabeq wehyoqka ebeq kure mi karíq ání mío nah kotaq abobóráhpeq kowara ");
INSERT INTO awb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tagéra sirupipeq anotahtaq eyoyóuwe. ");
INSERT INTO awb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nahupéq kibekéra mi karíq ánínseq wenano Máhríareq tagéra sirehunseraráq méra mi karíq ánínsábé iwíáh íwíáh atówe. Iwíáh íwíáh atera sene unahpípéqté péwe kóraakáq kaweq weríákáq kaweq kunkúni pahuráhákáq áwúwe. ");
INSERT INTO awb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Manikánka mi ke áónáh aritena sensabé, Érótiba íre seuwekoro aritowara sega mó ahtápéqtáq sensuwahpeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ahtebia kégá mitaq suera pokuwana itene Wahnah Maniká míéhrabeq íópipeqté ánínká Sósépa áónáh atena wensabé, Irigue mi karíq ánínseq wenanoreq Ísípi marákórápéq pehbeheráh meriqme mórito. Érótiga mi aní subiq suanieéna kabarinaire. Teawéna tanáhráq seuwekinkehboq mibeq kowíahno úwe. ");
INSERT INTO awb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Úwana Sósépaga irigéna inokáhpeq mitaq suena mi karíq ánínseq wenanoreq meriqmena pokue Ísípi marákórápéq pokúwe. Éróti íre pukú tanahráq Sósépareh karírónání Ísípi marákórápéq kowíówe. ");
INSERT INTO awb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Minayabe itene Wahnahnka wene ehweh irarú ani iwíáh atowana sehiranue mahraréna, Nénahni Ísípi marákórápéq míéhnsábé mitaq sue mahbeq súno atóge ire. Mi ehwéh aiq pútaraginkeheéna Manikánka Sósépansabé Ísípi marákórápéq kowíahno atowe. ");
INSERT INTO awb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ahtebia kégá Érótine ehweh íre sehgira mó ahtáqpéq pokue taqnobagunsabe Érótiga áyátó púana anotah abíáhnsánúwe. Anotah abíáhnsánéna Pétáríéma suwahpeqkakáq wahtote kehiná suwahpeqkakáq mó ke eqmaq suanaútaq sensabé, Moke náhtate karíq máígáú subiq súáhro aritowe. Ahtebia kégá wehyoq ehwéh teawú tanahráq Érótiga iwíáhéna, Mi anímé amahnága peh náh neh aníne éna moke náhtate karíq máígáú subiq súáhro aritowe. ");
INSERT INTO awb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Érótiga miraúnka Sérémáíane naho éhwéh aiq pútaragúwe. Manikánka wene ehweh irarú ani Sérémáía iwíáh atowana wega sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Áréma suwahpeqte kégá ibiséra áhnte ibítúnátúnánowara íráhwe. Áréséraga wene animárínsábé ibisehre. Moke subiq sutonsabé wenawahrahga wene arupipeq íre kaweratahráhowana peh ibisehre úwe. ");
INSERT INTO awb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sósépareh karírónání Ísípi marákórápéq míówana Éróti pukúwana íópeqté ánínká Sósépa áónáh atowe. ");
INSERT INTO awb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Áónáh atena wensabé, Irigue mi anínseq wenanoreq meriqme iteruwahrah Ísara kené marakórapeq seuwekúno. Mi aní subiq suanehe íwíáhuro ke aiq pukuro puah meriqme kouwekúno úwe. ");
INSERT INTO awb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kouwekúno úwana Sósépaga mi anínseq wenanoreq meriqmena Ísípi marákórápéq suena Ísara kené marakórapeq kouwekuwe. ");
INSERT INTO awb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Érótine ahninkáwá wenáwíq Ákéráúsae. Wega wenabone arambehri Súría marákórápéq Ísara keráq wahnah arámbéhrí awaq miowana Sósépaga minayabe irena mi marákórápéq pokéyabe áhreúwe. Manikánka Sósépa áónáh atena wensabé, Súría marákórápéq íre pokúno éna Kehrari marákórápéq kowíahno úwana meriqmena pokue Kehrari marákórápéq kowíowe. ");
INSERT INTO awb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kehrari marákórápéq kowéna Néhsara suwahpeq pokéna mitaq kaegaeúwe. Minayabe Manikánka wene ehweh iraru ke iwíáh aritowara Sísansabé sehiranue mahraréra, We Néhsara suwahpeqte áníne ataneherawoe éra sehiranuwe. ");
INSERT INTO awb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mi tanáhráq wání meri merini aní Sóniga Súría marákórápéq séna mibeqté úwórápéq ména weba su ke ehweh teri terinúwe. ");
INSERT INTO awb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wega mahraréna, Manikánka wahnah wahnahnirabeq aiq wahtotaq kéh púaq itene ahbabáq sansa sueq kaweqtaq míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Manikánka wene ehweh irarú ani wenáwíq Áísáía iwíáh atowana Sóni éhweh sehiranue mahraréna, We uworapeqté sawai sawaiéna mahraréna, Itene Wahnah sína ahmé aborisahro. Wene ah kaweraráhro ire úwe. ");
INSERT INTO awb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sóniga kéhma áyórate kogahnia aneraneratiowe. Áú arétí wene ayahbataq konahnatiowe. Tábahnkákáq sehenáhrabahnkakáq nówe. ");
INSERT INTO awb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sarúsarama suwahpeqte kéreq moke Súría marákórápéqté kéhíná suwahpeqte kéreq Sorana aroipéq wahtotaq kehiná suwahpeqte kéreqka Sóniba suwe. ");
INSERT INTO awb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Weba séra sene ahbabáqsabe Manikápa pahsúówana Sóniga Sorana aroipéq wání meriuwe. ");
INSERT INTO awb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Péhrasi kereq Sáyúsi kereqka wání meaneheéra Sóniba suwana wega sensabé, Itewe wehene animárí móe. Insega teínsábé áhreue ínéba seo? Manikánka kamah inehoéq ínéba se mino. ");
INSERT INTO awb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aiq pútaq kaweqtaq míaneheqmúne íwíáhirataq itene ahbabáq sansa sueq kaweq sansánoro. Mirairataq Manikánka tagéna, Ite amahnága kaweq sansánowe aitankéhe. ");
INSERT INTO awb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ébáráhma itene igaqna míéh púaq itewe Manikáne animárí méq kaweq ke míone éq iteitensabé iwíáh íwíáhiyeho. Manikánka mah ebáhmárítáté Ébáráhmane anahwaréh mirarahráhire. ");
INSERT INTO awb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wehukenínká awanká áwaheraq tehsúme maréhrana kaweq será íre íyéh áwánká moke apiwe ira parianawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sóniga mó mahraréna, Itene ahbabáq sansa aiq súáhnsábé wání mei meinuge. Íné peh wání mei meinugana íné kiotaiki aní inehe sinawire. Inehe si anímé anotah aní púana ínéga wene súu meweyabe íre awehrari aní múge. Wega Wenawa eqmarahnana wehukenínká ira kekínserah Wenawanka iteba tuinkéhe. ");
INSERT INTO awb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wehukega ayu siqmíáhtáq sega kaweq ayú sene nahtapeq sáharera atutu ira paríáhwe. Mira onserah Manikánka kaweqtaq míáh kéyábé, Néne mátaburapeq kiwíáhro aritena ahbabáq keyabé, Íre puinkorahi iraipéq pokoro aritanawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sóniga mi ehwéh pahsuqme teriuwana Sísaga Kehrari marákórápéqté sure Sorana aroipéq Sóniga wání meawinkeheéna weba súwe. ");
INSERT INTO awb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sísaga wání meanieéna weba súwana Sóniga ahqáho atena wensabé, Aneqsabé ínéga wání meninkeheé seno? Arega íné wání menínaraqmé aiq kawerinae úwana ");
INSERT INTO awb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sísaga wensabé, Amahnága arega wání meninkéhe. Minawé Maniká awahbeh arámbéhríe úwana Sóniga wene ehwehnsabé kowe atowe. ");
INSERT INTO awb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kowe atena Sísa wání meawuwana Sísaga wánípipeqté kiutaq sabona sawekúwana Manikáne Awanka tunse kiboki tahnsanéna Sísaba márunsurahúwana tagówe. ");
INSERT INTO awb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tagówana íópeqté éhwéhnká mahraréna, Are niruní nénáhní móne. Arensabé nirutaboiruge úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Manikáne Awanka Sísa abatapi móatowana owainawanka weba séna Sísaga ahbabárinkeheéna áhwárawe tagéna áwíoqnówe. ");
INSERT INTO awb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sísaga áhnte wehekáh, 40wehekáh tópah awehriúnsabe anotah arúpíbíúwe. ");
INSERT INTO awb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Anotah arúpíbíúwana owainawanka wensabé, Are Manikáne ahninkáwá míahna puah mah ebáhmárínsábé, Tópah úkúno ato úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Úwana Sísaga wensabé, Manikáne ehwehnka aiq mahraréna, Tópahnka wehuke íre oganúq sitahráhi nanere. Írakaumo. Peh morá Manikánka irari ehwéhnká oganúq sitahráhire ire úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Úwana owainawanka Sísa meqmena kaweq mapéq Sarúsarama suwahpeq Manikánsabe iwíáh íwíáh atáh náh nahnsorapéq móatena ");
INSERT INTO awb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","wensabé, Are Manikáne ahninkáwá míahna puah maraipéq ahkuagúno. Minayabe Manikáne ehwehnka aiq mahraréna, Manikánka wene íópeqté kéyábé are wahnahnatíáhro aritankéhe. Ebahtaq arene aigárá peraq míéhneho éra sene siyahnkaratáté are pankeragéhe ire úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Úwana Sísaga ahqáho atena wensabé, Manikáne ehwehnka mó mahraréna, Maniká arene anotah Wahnáh áhwárawe tagé áwíoqnéhneho ire úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Owainawanka Sísa mó meqmena anotah sawéhrápéq kiena moke mah kawéq márákóákáq moke kéh náneqmarínkákáq sokigi awuwe. ");
INSERT INTO awb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sokigi awena wensabé, Káuqmunue ínénsabe iwíáh íwíáh aintéhnaraqmé moke tagahna naneqmarí awiníe ");
INSERT INTO awb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","úwana Sísaga wensabé, Owainawano, íné nuwe pokúno. Manikáne ehwehnka mahraréna, Maniká itene Wahnahnsabé iwíáh íwíáh ateq webataq we awahbeh arámbéhrí miraoro ire úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Úwana owainawanka Sísa auwena pokúwara íópeqté kégá Sísaba séra séhréh atówe. ");
INSERT INTO awb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sóni karábúsiipéq atárówe u ehwéh irena Sísaga Kehrari marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pokéna Néhsara suwahpeq suena Kehrari kawéhú ayehráq Kápénéáma suwahpeq kowíowe. Mi marákówé Sébúrúna kahnáhnseq Nápátári kahnáhnseqka téhwe aborisowe. ");
INSERT INTO awb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sísaga mitaq pokúnka Manikáne ehwehme aiq pútaragúwe. Manikánka wene ehweh irarú ani Áísáía iwíáh atowana sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sorana aroipéq seberaebéq Kehrari kawéhú kéhrabeq Sébúrúna kahnáhnseq Nápátári kahnáhnseqne marakó kéhre. ");
INSERT INTO awb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mitaqté kéwé sunkíkírirabeq mía míao kegá téhreh tagagehe. Puké marákó sunkíkírirabeq téhrankehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mi tanáhráq Sísaga kaweq ehwéh síwáhnoré sansa áhwárówe. Wega mahraréna, Manikánka wahnah wahnahnime aiq wahtoni puaq itene ahbabáq sansa sueq kaweqtaq míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sísaga Kehrari kawéhú ayehrápéq nogena se ábárahré Ehntarureq Sáímónireq tagówe. Sáímóniwe mó awíq Pítae. Se pah meyóya aníté míóyansabé kahweraté wánípipeq uwe taga tagauyana tagówe. ");
INSERT INTO awb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tagéna sensabé, Íné séníráhtao. Amahnága itega kahweraté uwe taga tagaéta pah meyehye. Mina óyanserah wehuke ínéba meriqmeta sigehe. Minayabe íwáhnoriniboq séníráhtao úwe. ");
INSERT INTO awb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Séníráhtao úwara sene kahwe apubúue mitaq marera Sísa kéróye. ");
INSERT INTO awb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kéróyana Sísaga kure mó abáráhré, Sébérine ahninkáwáráré Sémísireq Sónireq tagówe. Tagówara sereq sibowá Sébérireqka sípiipéq méra sene kahwewarí kawerarówe. Kawerarówana Sísaga mi abáráhréyábé, Máhotao úwara ");
INSERT INTO awb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","sega apubúue sípiakáq sibowánkákáq suera Sísa kéróye. ");
INSERT INTO awb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sísaga moke Kehrari marákórápéq ah nogéna Asiu kené momiwí nahmárítápéq síwáhnoréna Maniká wahnah wahnahnirabeqte éhwéh teri terinéna moke náonkakáq kéreq awahre kereq kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sísa éhweh mitaq teri mahtaq terinuwara moke Síría marákórápéqté kégá írówe. Minayabe mi kegá moke awahre kereq owainawanka subiqmaq subiqmarú kereq iransá aruqaruru kereq aigárá soriqnah kereq meriqmera Sísaba mórítówana wega moke mi ke kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kehrari marákórápéqté kéreq Tékápórísa marákórápéqté kéreq Sarúsarama suwahpeqte kéreq Súría marákórápéqté kéreq Sorana aroipéq seberaebéqté kéreq, peh íregáritaq kegá Sísa kérówe. ");
INSERT INTO awb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sísaga mi ke tagéna sáwéhrapeq kiwéna tútuue míowaq ite we kérahwána kegá weba sewane. ");
INSERT INTO awb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sísaga íwáhnoréna mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Tabonah keo, itega Manikánsabe, Iteriahríáh íre miraorahúne éq séhréh aito íwíáhéra íópeq Manikánka wahnah wahnahnirabeq awaq miahráhonsabé iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Amahnága irupipeq umehiraq ibisah keo, Manikánka séhréh aitena itene iru ukiq itankéhe. Minayabe iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Íre píribahria peh uwaresa kéo, mah marákó márákó awaq miahráho puaq iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kaweqtaq mé sansa sehgieyabe suwahbeh keo, ite arupibii aní tahnsa móe. Wání tahbobói aní tahnsa móe. Manikánka ite tabonaho naneq náinkéhe. Minayabe iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mó keyábé irutaboirariteq séhréh arítáh kéo, Manikánka itensabé moq arutaboiraitena séhréh aitahna puaq iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Irupipeq kaweq iwíáh aruqaruro keo, Maniká tagahraho puaq iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Morá ké tahnsanue tobeh ehweho sansá sueq pehwehribeq míáhro íwíáho keo, Manikánka itensabé, néne animárí móe aitahna puaq iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Manikáne kaweq sansá sehgíónsábé mó kegá íwíoqnah keo, Manikánka wahnah wahnahnirabeq awaq miahráho puaq iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Néne animáríno, néne animárí míáh púara mó kegá íre kaweq ehwéh aitera íwíoqnéra péhepehe ehwéhnue íéhruruirataq iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sega miraonka íópeq itene ápeq anotah úki puaq iru eyoyóéq iwíáh íwíáhoro. Sega ite íwíoqnahnserah Manikáne ehweh iraru ke naho síwíoqnowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sísaga pabeqme ehwéh mó mahraréna, Itewe mah kehiná kéhínáné sóreq tahnsá móe. Sóreq auqmah naneq úkínaraqmé kaweraranéhnkono? Írakaumo. Auqmah soréq íre tei puara wehukega sigárátáté abasawe seraweh keragéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Sísaga mó pabéqmé éhwéh síwáhnoréna, Mah kehiná kéhínánká tagageheéq ite téhreh tahnsá ké wóe. Sáwéhrapeqté náhmárí kopípéq íre kahrahire. ");
INSERT INTO awb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mina inserah wehukega áráhmu keqmaráhtáq páhkétiraté íre akariaráhwe. Írakaumo. Peh tahberaq máráhwana téhráhnara moke nahupeq míáh kégá kawerue tagahrahowe. ");
INSERT INTO awb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wehukenínká áráhmu tahberaq máréhnserah wehukega tagehrataq kaweq sansánoro. Mó kegá itene kaweq sansá tagéra Maniká Iteribo íópeq míéh ánínsábé iwíáh íwíáh atagéhboq kaweq sansánoro úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sísaga mó mahraréna, Ínénsabewé Mósísiga sehgíóro ú ehwehnkákáq Manikáne ehweh iraru kené ehwehnkakáq sabiruanieéna sire íwíáhoo? Írakaumo. Íre sabiruanieéna suge. Peh mi ehwéh áwahe sokigi ainieéna suge. ");
INSERT INTO awb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Teí éhwéh ahtebagehboq íráhro. Íópeqkákáq mah marákó márákóákáq peh kahnaraq Mósísiga sehgíóro ú ehweh íre parabagia peh kagainae. Mi ehwéhmé pehgáriq íre parabagia peh moke kagainawire. Mi ehwéhnká moke aiq pútaragínana anehe íópeqkákáq mah marákó márákóákáq parabaginawire. ");
INSERT INTO awb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Minayabe wehukenínká mi ehwéh pehgáriq anteruena mó keyábé, Ínéga unserahnoro éna pagu pagunínaraq mi anímé Manikánka wahnah wahnahnirabeq pehgáriq aní míankehe. Mó anínká mi ehwéh sehgiena mó keyábé, Kawerue sehgíóro síwáhnorínaraq mi anímé Manikánka wahnah wahnahnirabeq anotah aní míankehe. ");
INSERT INTO awb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Teiníboq írátíáhro. Itega Manikáne sansá sehgironka Péhrasi kereq Mósísine ehweh síwáhnoro kereqne arambehri íre kiotaikínaraqmé Manikánka wahnah wahnahnirabeq kioráhoo? Írakaumo. Íre kioráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sísaga mó mahraréna, Naho naho síwáhnoruro kegá itene igaqnaréhyabe teríú ehweh itega aiq íráhwe. Sega síwáhnoréra, Wehukení subiq sueho. Subiq suahna anímé kotiorabeq móatagéhe uwe. ");
INSERT INTO awb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sega miraue iraruwana amahnága ínéga teiníboq írátíáhro. Wene iyahnabo anínsábé abiahnsa atahna anímé kotiorabeq móatagéhe. Wene iyahnabo anínsábé íre kaweq ehwéh atahna anímé kaunsíri kebá móatagéhe. Wene iyahnabo anínsábé múguwahgu uwoyansa aní móne atahna anímé iraipéq pokinae. ");
INSERT INTO awb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Manikánsabe iwíáh íwíáh atáh náhúpéqté táhbérápéq irigé, Mahna Maniká náwiníe íwíáhóne. Are mitaq irigé arene iyahnabo anínká arensabé abiahnsa atéhnsábé ahreraq matiahnawe ");
INSERT INTO awb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","arega awinieina naneq tahbe áwaheraq maro. Áwaheraq mare apubúue arene iyahnabo anípá pokue insahwé ato. Insahwé ate kouwekue mitaq marahna naneq mewe Maniká náwo úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Sísaga mó mahraréna, Mó anínká are ehweh atanieéna anotah sahsí móatanaínaraq ahtapeq kirataq apubúue insahwé ato. Kotiorabeq kirataq wega anotah sahsí are móatahnana wega párísiba móatahnana karábúsiipéq móatehnehboq apubúue insahwé ato. ");
INSERT INTO awb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Teiníboq írátíáhro. Karábúsiipéq móatahnara pehipi íre soraq auwagéhe. Ebeqme anotah apéq paiqmaréhnaraqmé anehe soraq auwagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sísaga mó mahraréna, Itega írátó ehwéhnká mahraréna, Mó aníné weh ahre abariiyeho ire. ");
INSERT INTO awb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mi ehwéh írátówana amahnága ínéga teiníboq írátíáhro. Arene auranka mó aníné ahre tagé, Íné mi iní abariéyabe níre íwíáhónawe arene arupipeq abarié ahbabáq aiq miraóne. ");
INSERT INTO awb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Minayabe arene auranka are ahbabáratana ínaraq mi aurá piruo. Peh morá áúránkákáq míéhnaraq pehgáriq íre kawerinae. Téhtaré áúránkákáq míéhnaraq kagai iraipéq pokinaraq anotah íre kawerinae. ");
INSERT INTO awb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Arene púpeqte áyáhnkáránká are ahbabáratana ínaraq mi ayáhnkárá kiraqsuo. Peh morá áyáhnkáránkákáq míéhnaraq pehgáriq íre kawerinae. Téhtaré áyáhnkáránkákáq míéhnaraq kagai iraipéq pokinaraq anotah íre kawerinae úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Sísaga mó mahraréna, Itega írátó ehwéhnká mahraréna, Arene ahre kaqsuaníe inaraqmé minayabe tíkéti pepáhq kowewe móawo úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Minayabe amahnága ínéga teiníboq írátíáhro. Arene ahrega mó wehreq ahbabárirataq mi tanáhráq kaqsuankéhe. Pehipi kaqsúéhnaraq wega mó wehkínaraq mi tanáhráq ahbabárinae. Mi iní meyahna anínká moq mi tanáhráq ahbabárinae. Minayabe arene ahre pehipi kaqsúéhneho uge úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Sísaga mó mahraréna, Itega mó ehwéh írátó ehwéhmé itene igaqnaréhyabe teríú éhwéhnká mahraréna, Arega iraré, Manikánka tagaríéhtáq ínéga teawú éhwéh mirainauge énawe péhenineho. Arene ehweh kawerue sehgio ire. ");
INSERT INTO awb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sega miraue iraruwana amahnága ínéga teiníboq írátíáhro. Arega mirainauge inaraq Manikánka tagaríéhtáq mirainauge íre úno. Íópeqmé Manikánka wahnah wahnahni puah, Íónka tagaríéhtáq mirainauge íre úno. ");
INSERT INTO awb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mah marákówé Manikáne tahbe tahnsá púah, Marakóga tagaríéhtáq mirainauge íre úno. Sarúsarama suwahpeqme itene anotah Wahnáhné mátabu púah, Sarúsaramaga tagaríéhtaq mirainauge íre úno. ");
INSERT INTO awb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Arega irarénaga peh morá arene tontonah ayáhránká pabusa ayáhrá íre úkorahi puah, Niyahqnonka tagaríéhtáq mirainauge íre úno. ");
INSERT INTO awb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Arega, Ahqáho. Íre mirainauge íwíáhónawe peh, Ahqáho úno. Arega, Kowe. Mirainauge íwíáhónawe peh, Kowe úno. Owainawanka ahbabáq ehweh atahnah áhnte irarinehboq peh morá ahqáhoakáq koweakáq irarúno úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sísaga mó mahraréna, Itega írátó ehwéhnká mahraréna, Mó anínká arene aura piauwahnah arega moq wene aura piruo. Mó anínká arene áwéh sehqauwahnah arega moq wene áwéh sehqauwo ire. ");
INSERT INTO awb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mi ehwéh írátówana amahnága ínéga teiníboq írátíáhro. Are áwíoqneh anímé íre ayahqmaro. Mó anínká are ahsuehinahwe éberiopéq pabeq suehnana ahsuehino. ");
INSERT INTO awb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mó anínká are ehweh atena síóti meaníe ínaraqmé arene síótiakáq arene sáhkétiakáq náwo. ");
INSERT INTO awb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wahnah anínká wene ménsámehnsá abaqme ákáhtaq wahtotaq morá kírómítá kúno atahnahwe ákáhtaq íre wahto téhtaré kírómítá mewe móato. ");
INSERT INTO awb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mó anínká arensabé aneqpopoq nánio ínahwe náwo. Mó naneq átáríaniboq nánio ínahwe náwo úwe. ");
INSERT INTO awb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Sísaga mó mahraréna, Itega írátó ehwéhnká mahraréna, Arene iyahnaboyabé arutaboiré arene naruoyabé íre arutaboiroro ire. ");
INSERT INTO awb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mi ehwéh írátówana amahnága ínéga teiníboq írátíáhro. Íre peh morá itene iyahnaboyabé irutaboiroro. Itene naruoyabé moq irutaboiroro. Íwíoqnah keyábé púrerarítáhro. ");
INSERT INTO awb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Íópeqté Ítéríbóné animárí méq ite íwíoqnah ke púrerarítáhro. Manikánka ahbabáq kereq kaweq kereqne marakóraq monseráhnue, Patahúno atéhre. Wega kaweqtaq míáh kéreq ahbabáq kereqne marakóraq monseráhnue, Ibonsúno atéhre. ");
INSERT INTO awb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Peh morá itensabé sirutaboiro keyábé irutaboirirataqmé Manikánka ápeq awinkéhbo? Írakaumo. Ahbabáq kereqka moq sensabé sirutaboiro keyábé sirutaboirowe. ");
INSERT INTO awb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Peh morá itene iyahnaboyabé mehweh arítéhrame anotah kawéq sánsápo? Írakaumo. Maniká íre tagaríáh kégá mi sansá mirao mino. ");
INSERT INTO awb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Íópeqté Ítéríbógá kaweqtaq mía míainserah ite moq kaweqtaq mía míaoro úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Sísaga mó mahraréna, Peh mó kegá itene kaweq arámbéhrí tagéra, Kaweq kee íwíáhigeheéq mi arámbéhrí ábóraq miraonsabé íre kawerowe. Mirairataq mókake íópeqté Ítéríbógá mi arámbéhríyábé ápeq íre náinawire. ");
INSERT INTO awb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Minayabe arega tabonah ke nárínaraq mó kegá tagagehboq ebeq pembíáh póbíéh ání íre eqmaro. Mó kegá momiwí nahtápéqkákáq wahba ahtápéqkákáq pembíáh póbíéh ání eqmarera anehe mitaq séra tabonah ke náríéwe. Tabonah keyabé íre sirutaboirue náriera péhepehe sansánowara mó kegá tagéra kaweq ke wóe íwíáh aitageheéra ábóraq náríéwe. Teiníboq írátíáhro. Mi sansáno kegá ábóraq náríé púara tagah kegá sensabé iwíáh íwíáh arítáhnsábé mókake mó apéq íre meyagéhe. Sega mira onserahniyeho. ");
INSERT INTO awb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Arega tabonah ke nárínaraqmé mó kegá tagehboq peh kopípéq nário. ");
INSERT INTO awb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kopípéq nárínaraqmé Iteriboga tagéna ápeq náwinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sísaga mó mahraréna, Táhmaro kegá ábóraq kaweq sansánéra peh kopípéqmé íre kaweq sansánéra kopéráhpéro ke wóe. Itega púrerirataqmé mi kegá púrero serahniyeho. Sega momiwí nahtápéqkákáq wahba áhtápéqkákáq mó kegá tagehrataq, Kaweq ke wóe íwíáh aritageheéra ábóraq iriwe méra púrerowe. Teiníboq írátíáhro. Mi sansáno kegá ábóraq púrerotaq tagah kegá sensabé iwíáh íwíáhonsabé mókake mó apéq íre meyagéhe. ");
INSERT INTO awb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Arega púrerinaraq arene paqnahipeq kibekue onsa paiqmare kopípéq mé púrerúno. Iteribo íre ábóraq míéh ánínéna moke kopípéq árámbéhrí tagehre. Minayabe kopípéq mé púrerinaraq mina tagéna arene púreq ehwéh irena náwinkéhe. ");
INSERT INTO awb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Maniká íre tagaríáh kégá iwíáhéra, Manikánka itene ehweh kawerue irankeheéra mónkakáq mónkakárue íre wahto ehwéh teawenéhe íwíáhowe. ");
INSERT INTO awb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sega mira onserahnue púreriyeho. Itega íre teawétáq Maniká Iteriboga ite tabonaho naneq tagaríéhre. ");
INSERT INTO awb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Minayabe púrerirataq mahraréq, Íópeqté Ítéríbóo, arenáwíq pankerone. ");
INSERT INTO awb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Arega mah kehiná kéhíná wahnah wahnahnaritahna tanáhráq apubúue ábóraragúno ato. Moke íópeqté ké are awahbeh sansánonserah mah marákóípéqté ké moq are awahbeh sansá miraoro aito. ");
INSERT INTO awb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ibora itene táhutahuq awehraq kirabo aito. ");
INSERT INTO awb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mó kegá ahbabáraitáhtáq itega mina íre iahreraq masa peh suone. Itega miraúnanserah itene ahbabáq moq íre ahreraq matiahno. ");
INSERT INTO awb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ahbabáqka ite saiqnariahrahirabeq íre móito. Owainawanka saiqnariahrahirabeqte meiqme móbeq móito. Arega ahriahri wahnah wahnahnaite págege kiotaikóna aní míahnaq arensabé iwíáh íwíáh atone. Aiq míre. Miraue púreroro úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sísaga mó mahraréna, Mó kegá ahbabáraitéhraq íre iahreraq matíéhrataqmé íópeqté Ítéríbógá itega onserahninkehe. Wega itene ahbabáq íre ahreraq matiankehe. ");
INSERT INTO awb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mó kegá ahbabáraitéhraq iahreraq matíáhnaraqmé íópeqté Ítéríbógá moq itene ahbabáq ahreraq matiankehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sísaga mó mahraréna, Itega táhutahuq awehriirataq péhepehe sansáno kegá abiah marera mirao serahniyeho. Mó kegá se tagéra, Kaweq ke wóe íwíáhigeheéra mi kegá awehriotaq abiah máráhwe. Teiníboq írátíáhro. Mi sansáno kegá awehriotaq tagah kegá sensabé iwíáh íwíáhonsabé mókake mó apéq íre meyagéhe. ");
INSERT INTO awb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Arega táhutahuq awehriinaraq arene auranabiah pabeq paberé arene ayahra kaweq komúúno. ");
INSERT INTO awb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mirainaraq are tagehra kegá táhutahuq awehrionayabé íre ahtebahrahowe. Iteribo íre ábóraq míéh ánínéna moke kopípéq árámbéhrí tagehnsabé ápeq náwinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sísaga mó mahraréna, Mah marákóípéq kaweq naneqmarínsábé irutaboiréq morábí sáhiyeho. Mah marákóípéq sáharáh náneq sósahbahrankírana abehq náneq ka sóirara aebó kégá aebóowe. ");
INSERT INTO awb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Peh morá íópeq kaweq naneqsabé irutaboiréq mitaq morábí sáharáhro. Mitaq íre sósahbahrankinae. Íre abehq náneq ka sóinae. Aebó kégá mitaq íre aebóorahowe. ");
INSERT INTO awb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Itene kaweq naneq morábí sáharáhrabeqsabé irutaboironeheqmóe úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sísaga mó mahraréna, Arene aurame arene anonkataq kéh áráhmú tahnsáne. Arene auranka kaweq naneq tagehnaraq arene arupipeq téhranae. Arene auranka ahbabárorahi naneq tagehnaraq arene arupipeq sunkíkírinae. ");
INSERT INTO awb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Arene arupipeqté téhrehme sunkíkíragínaraq kaweq sansá íre miraorahé peh ahbabáq sansanorahóne úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sísaga mó mahraréna, Arambehri anínká téhtaré wáhnáhné arambehri íre moráráq sehgioráhire. Wega mó wahnáhnsábé awahbéna mó wahnáhnsábé íre awahbanae. Wega mó wahnáhné arambehri kawerue sehgiena mó wahnáhné arambehri áhwára áhwárainae. Mina inserah itega Manikánsabe irutaboiro sansánkákáq móneyabé irutaboiro sansánkákáq íre moráráq sehgioráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Sísaga mó mahraréna, Teiníboq írátíáhro. Ite mah marákóípéq mé tanahráq itene táhutahuqkakáq itene inonkataq inerineré naneqkakáqsábé iwíáh kikiriyeho. Oga méwé íre peh morá tópah nahnagae. Itene inonkame íre peh morá inerineré naneq mire. ");
INSERT INTO awb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kabarane sánsá iwíáhue tagahro. Mi kanká ménsúmehnsú uqmarena nera kéhtáq koawaqmena nahupeq sahiro? Írakaumo. Íópeqté Ítéríbógá mi kansábé iwíáhéna pehipi kiraboire. Itewe wehuke puana Maniká Iteriboga itensabé anotahtaq iwíáhéna kawerue kirabo aitéh mino. ");
INSERT INTO awb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Arega arene oga mé tanahráqsábé iwíáh kikirinaraqmé ábátáq mérearahráhiro? Ahqáho. Írakaumo úwe. ");
INSERT INTO awb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sísaga mó mahraréna, Aneraneré naneqsabé aneqsabé iwíáh kikiroo? Uworapeqté árá íyéh náneqsabé iwíáhue tagahro. Uworapeqté náneqka íre arambehrire. Korósi íre kogahnire. ");
INSERT INTO awb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Anotah wahnáh ání Sórómóni naho ména we áhnte mensáméhnsá matawéna áhnte kawéq awahriq korósí matiowe. Uworapeqté kawéq árá íyéh náneqka moke Sórómónine kaweq awahriq naneq kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Uworapeqté náneq íre kagai naneq mire. Ibora íyéhrana ahbiah tahnsá kekírataq tagire. Manikánsabe pehgáritaq aiq pútare atáh kéo, Manikánka mi kawéq árá sukiwíéhnsábé wega ite moq sukitahráhi mino. ");
INSERT INTO awb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aneq nanehnkono? Né waní eheqte tuiro? Aneqtaté aneranerue míanehnkono éq iwíáh kikiriyeho. Ahqáho. ");
INSERT INTO awb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Maniká íre tagaríáh kégá minayabe iwíáh íwíáhéra sene sirupipeq iwíáh kikirowe. Iteriboga ite íre mationa naneq aiq tagaríéhre. ");
INSERT INTO awb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ahriahri Manikánka wahnah wahnahnirabeqte sánsánsábé irutaboiréq sehgíóro. Sehgieq we kaweqtaq míéhnserah ite moq kaweqtaq míaneheqmúne éq iwíáhoro. Mirairataq Manikánka ite íre mationa naneq náinkéhe. ");
INSERT INTO awb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ahbiah sína naneqsabé iwíáh kikiriyeho. Ahbiah sína naneqsabé mi tanáhráqsábé iwíáhigehe. Irupipeq umehorahi naneqsabé ibora aiq awehraq kéhranawe ahbiah sína naneqsabé iwíáh kikiriyeho úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sísaga mó mahraréna, Mó kené sánsá saraq siteq ahbabáq ke woe íre oro. Mirairataq Manikánka itene sánsá moq saraq itena ahbabáq ke woe aitankéhe. ");
INSERT INTO awb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Itega mó kené sánsá saraq sitáhnserah Manikánka itene sánsá moq saraq itankéhe. Itega mó kené sánsá saraqme náríénserah Manikánka moq mina tahnsanue saraqme náinkéhe. ");
INSERT INTO awb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Arenawahrah aníné aurapi pehgáriq átútú tagé arerene aurapi anotah sehikárá kéhnsábé aneqsabé arerene auransabé íre iwíáhono? ");
INSERT INTO awb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Arene aurapi anotah sehikárá kéhrahwe aneqsabé arenawahrah anínsábé, Arene aurapite átútú meauwanínkono eno? ");
INSERT INTO awb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Are ahbabáq kopéráhpéróna aní móne. Téhwe arerene aurapite séhíkárá merue anehemé arenawahrah aníné aurapite átútú kawerue tagé meauwahráhóne. ");
INSERT INTO awb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Manikánsabe suwahrieh kewé Manikáne epéqté éhwéh íre teríéro. Mirairataq ianká wehukení pehnserah sega ite íwíoqnagehe. Póéráhqka kaweq naneq segarúpípéq abasawe maisarúéhnserah sega mi ehwéh íre irasa peh awiréh aitaneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sísaga mó mahraréna, Itega púrerirataqmé náio ira naneq náinkéhe. Págegeue kabarirataq ábórarínaq taganeheqmóe. Onsaraq pako pakoirataq sitankéhe. ");
INSERT INTO awb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nánio i anínká meyankéhe. Kabari anínká ábóraq marankéhe. Onsaraq pakobakoi anímé Manikánka siatahnana nahupeq kibekinkehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sísaga mó mahraréna, Arenahninká arensabé, Tópah nánio ínaraqmé arega ebah náwiníbo? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wega, Paseh nánio ínaraqmé wehe náwiníbo? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ite sibowáréh ahbabároraho keéq itene animárí peh kaweq naneq nári nárino mino. Íópeqté Ítéríbógá wensabé, Nánio e kewé peh kaweq naneq nárinkéhe. ");
INSERT INTO awb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Mó kegá ite iuwahbeh sansánue ite kaweraitáhnserah itega moq mina tahnsanue se kawerarítáhro. Mi sansámé Mósísine ehwehnkakáq Manikáne ehweh iraru kené ehwehnkakáq áwahe wíre úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sísaga mó mahraréna, Sobuya méhpéhpéq kibekoro. Iraipéqté méhpéh anotah abáé méhpéh míre. Iraipéqté áh moq abae ah marapeq tunsíá áh kéhrara áhnte kegá mi ahtápéq poku pokuowe. ");
INSERT INTO awb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Oga mérapeqté méhpéhmé sobuya méhpéh míre. Oga mérapeqté áhmé moq sobuya ah senahpeq kiríéh áh kéhrara mibeq kieyabe umehi puara íre áhnte kegá mi ahtápéq kiegieowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sísaga mó mahraréna, Íre Manikáne ehweh peh seyene péhe éhwéh irare keyábé aiq pútare arítéhboq mi kené arambehri tagaríáhro. Ábóraq se sipisípiq tahnsá méra peh sirupipeqmé úrinsi iá tahnsa míáhwe. ");
INSERT INTO awb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sene arambehri kawerue tagarawéq sene sánsá ahtebahrahowe. Ógaranká inunara íre íyéhre. Káránkáránsáhnka pópo íre íyéhre. ");
INSERT INTO awb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kaweq awánkánká kaweq será íyéhranawe abehq áwánkánká íre kaweq será íyéhre. ");
INSERT INTO awb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kaweq awánkánká abehq sérá íre iyahráhire. Abehq áwánkánká kaweq será íre iyahráhire. ");
INSERT INTO awb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kaweq será íre íyéh áwánkámé apiwe ira paríéhre. ");
INSERT INTO awb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Minayabe péhe éhwéh irare kené arambehri tagarawéq sene sánsánsábé iwíáhorahowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sísaga mó mahraréna, Áhnte kegá ínénsabe, Néne Wahnah mone aintáhwe. Íre mi ehwéh irarenka Manikánka wahnah wahnahnirabeq kioráhowe. Írakaumo. Íópeqté Náníbó awahbeh arámbéhrí mirao kegá sebataq mitaq kioráhowe. ");
INSERT INTO awb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sainsuahna tanáhráq áhnte kegá ínénsabe, Néne Wahnah mone aintera, Arenáwírue Manikáne ehweh irarurauge. Arenáwírue owainawamarí kaqsuq kaqsururauge. Arenáwírue ótaq sansámárí miraurauge irarigehe. ");
INSERT INTO awb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Irarirataq ínéga sensabé, Itewe íre tagaríóge. Ite ahbabáq ke puaq íné nueq pokoro aritaníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Sísaga mó mahraréna, Néne ehweh irena sehgí ánímé ahtebia ání wene nah págege marákóráq pearéh ání tahnsane. ");
INSERT INTO awb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Págege marákóráq pearéh púana anotah ibónsirana wání períéhrana sóiririrana wene nah íre kúrugúruue sokogia peh págegeue kéhre. ");
INSERT INTO awb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Néne ehweh irena íre sehgí ánímé múguwahgu aní wene nah mareqmareq marákóráq pearéh ání tahnsane. ");
INSERT INTO awb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Anotah ibónsirana wání períéhrana sóiririrana wene nah kúrugúruue sokogire. Sokogirana moke íre kaweragire úwe. ");
INSERT INTO awb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sísaga mi ehwéh síwáhnorue parabaruowara író kega wene ehwehnsabé áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mósísine ehweh síwáhnoro kegá síwáhnorunserah Sísaga íre úwe. Wega ahtebia ánínká tahnsa síwáhnorú púara wene ehweh író kega áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sísaga sáwéhrapeqté tuwara peh íregáritaq kegá we kérówe. ");
INSERT INTO awb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kérówana anotah naonkákáq ánínká weba séna áhtenú púana arehunseraráq ména wensabé, Anotah aníno, are awahbáhnaraqmé kaweraintahráhóne úwe. ");
INSERT INTO awb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Úwana Sísaga ayahnkahkahrue wenaneq táhtorena wensabé, Aiq mirauge. Are awaho ani míahno atowana mina irarútaq wene náonaba apubúue wagúwana kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kaweragúwana Sísaga wensabé, Írátíahno. Mó ke teríneho. Írakaumo. Manikáne ehweh mibeq mahbeq aitéh ánípá pokue arene anonka móreawo. Are awaho ani úkire igehboq Mósísiga irarúnserahnue Manikánsabe titirúno úwe. ");
INSERT INTO awb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sísaga Kápénéáma suwahpeq sútaq 100 Aroma sontíá kéné kíápéténiga weba séna, Séhréh ainto éna, ");
INSERT INTO awb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Anotah aníno, néne arambehri aní néne nahtapeq ména anotah erirana íre nogoráhire úwe. ");
INSERT INTO awb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Úwana Sísaga wensabé, Ínéga arene nahtapeq kogawerataníe ");
INSERT INTO awb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","úwana kíápéténiga wensabé, Íné pehgáriq aní múge. Are anotah aní míahna puah néne nahtapeq íre súno. Peh mahtaq mé ehweh irarinana néne arambehri aní kaweragíno. ");
INSERT INTO awb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Íné moq wahnah sansá tagaríóge. Néne wahnah aiq míéhrana íné moq wahnah anínéna sóntía ke wahnahnuge. Ínéga mó sontíá ánínsábé, Pokúno atótáq wega apubúue pokire. Mó sontíá ánínsábé, Mahbeq súno atótáq wega apubúue ínéba sire. Néne arambehri ánínsábé, Miraúno atótáq wega apubúue miraire úwe. ");
INSERT INTO awb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Úwana Sísaga mi ehwéh irotaq áhtenéna we anehe su keyábé, Teiníboq írátíáhro. Mah anínká ínénsabe anotahtaq aiq pútare aintena ínéga mirainawire íwíáhire. Nánuwahrah Asíú kégá ínénsabe mina tahnsanue íre aiq pútare aintáhwe. ");
INSERT INTO awb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Teiníboq írátíáhro. Íó kiembogirabeqte kéreq íó tupekirabeqte kéreqka séra Manikánka wahnah wahnahnirabeq kibekéra tútuue méra Ébáráhmareh Áhísáhkireh Sékópareh moráráq táhutahurigehe. ");
INSERT INTO awb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Manikánka nánuwahrah Asíú kéyábé, Ínéga wahnah wahnahnurabeq máhoro irara sega ahqáho atonsabe máhpeq sunkíkírirabeq kaqsuankéhe. Kaqsuahnaraq sega mitaq uwo uwo éra ibisagehe. ");
INSERT INTO awb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Minayabe, Íráhro éna kíápéténinsabé, Arene nahtapeq pokúno. Arega aiq pútare aintahnanserah inkehe úwana mi tanáhráq wene arambehri aní kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sísaga Pítane nahupeq kibekúwana Pítane ahrahnawa osoro awáhrééna máhriqtaq míowana tagówe. ");
INSERT INTO awb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sísaga mi iníné ayahnkara táhtorowana wene awahre kaweragúwana irigéna táhutahuq tíwe náwuwe. ");
INSERT INTO awb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Íó tupekútaq wehukega owainawanka subiqmaq subiqmarú ke meriqmera Sísaba mórítówe. Mórítówana Sísaga peh ehweh irarúnka owainawamarí kaqsuena moke awahre ke kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kaweraritonsabe Manikáne ehweh aiq pútaragúwe. Wene ehwéh irarú ani Áísáíaga Manikáne púkuipéq naho sehiranue mahraréna, Wega moke itene awahre meyéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sísaga peh íregáritaq weba sáhuríó ke tagéna ite we kérahwána keyábé, Mah kawéhú seberaebéq pokonehe ");
INSERT INTO awb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","úwana Mósísine ehweh síwáhnorú anínká weba séna wensabé, Íwáhnoraníno, are poku pokuónarabeq kéraníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Úwana Sísaga wensabé, Úrinsi iá wene nahme ebahnarahpipeq kéhre. Kabarane nahme sehwerapeq kéhre. Íné wehukení úku aníné nahme íre kéhre ");
INSERT INTO awb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","úwana mó aní we kéro anínká wensabé, Ebeqme nánibo pukinana komaisarena anehe are kéraníe ");
INSERT INTO awb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","úwana Sísaga wensabé, Pusa kégá pukira ke maisaragéhboq íné séniro úwe. ");
INSERT INTO awb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sísareq ite we kérahwána kereqka sípiipéq kibekue kure kure ");
INSERT INTO awb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","káwehu ákáhtaq kowana Sísa sípiipéq sugowana apubúue anotah soirírúnka anotah nonaburóróúwana wánínka kiegambehgue sípi wánípipeq tupekinaúwe. ");
INSERT INTO awb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tupekinaútaq ite we kérahwána kega Sísa iriateq wensabé, Wánípipeq tupekue pukonehboq kaweraito ewanana ");
INSERT INTO awb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","wega itensabé, Aneqsabé áhreoo? Itega ínénsabe pehgáriqtaq aiq pútare aintáhwe éna irigéna sóiriqsabé, Táqnáigúno éna wánínsabe, Túbáh agúno úwana sóiriqka táqnáigúwana wánínka moq túbáh agúwe. ");
INSERT INTO awb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Túbáh agúwaq itega áhtenéq itete náhenéq, We aneq anípo? Sóiriqkakáq wánínkakaqká wene ehweh íréhre ewanae. ");
INSERT INTO awb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sísaga sípi kéwewena kure Kehrari kawéhú seberaebéq Kárára kené marakórapeq kúwe. Mitaq wehuke maisia ónápípéq kaegaeuya anítéreq piehgíúwe. Sirupipeq míó owáínáwámárínká mi aníté subiqmaq subiqmaru puara anotah uwóyánsá aruqaruruyara mó kegá sensabé áhreéra mi ahtápéq íre nogoráhúwe. ");
INSERT INTO awb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sega Sísa tagéra apubúue kareéra wensabé, Manikáne ahninkáwá wóne. Aneraitaníbo? Kamah aina tanáhráq íre sinsabé ite kamah ainie seno uye. ");
INSERT INTO awb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Se míórabeq ákáhtaq wahtotaq íregáritaq poeráhqmárínká uworapeq náwe sahtaqme nowe. ");
INSERT INTO awb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nonsabe owainawamarínká Sísansabé, Ite eqmaq íúwéhnaraqmé mi poeráhqmáríné sirupipeq eqmaq iuwo éra pagu pagunuwe. ");
INSERT INTO awb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pagu pagunuwana Sísaga sensabé, Pokurero aritowara sega mi aníté suera póéráhqmariné sirupipeq kowíówara mi kamárínká sáwéhrapeqté pehbeheráh tunse mentúpipeq tunse wánínkue pukuwe. ");
INSERT INTO awb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Póéráhqtaq wahnahnu kegá tagéra sensuwahpeq pehbeheráh pokéra owainawanka subiqmaq subiqmarú anité éhweh teriera moke tago naneqsabé éhwéh sensuwahrah teríúwe. ");
INSERT INTO awb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Teríúwara moke mibeqté kégá Sísaba kure wensabé, Itene marakó sue pokúno éra pagu pagunuwe. ");
INSERT INTO awb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sísaga sípiipéq kibekéna káwehu seberaebéq wenawahpeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mó kegá íre ah nogoráhú aní aiayah pukia ání wene máhriqkakáq sehitaqmaqme sehgiwera Sísaba móátówe. Sega iwíáhéra, Sísaga kaweratanawire íwíáhuwana Sísaga sene iwíáh tagéna aiayah pukia ánínsábé, Náníbáq móne. Arene ahbabáq aiq kawerató púah arene arupipeq eyoyóue míahno úwe. ");
INSERT INTO awb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Úwara Mósísine ehweh síwáhnoru kegá seye náhenéra, Mah anímé, Íné Maniká míóge íwíáhéna anotah ahbábárire uwe. ");
INSERT INTO awb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Uwana Sísaga sene iwíáh tagéna sensabé, Irupipeqmé aneqsabé ahbabáq iwiáho? ");
INSERT INTO awb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aiayah pukia ánínsábé aneq ehwéh teawinínkono? Arene ahbabáqsabe kaweratóge teawinínkono? Are irigue arene máhriq mewe ah nogo teawinínkono? Íre págege ehwéhmé ahnabo? ");
INSERT INTO awb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Íné wehukení úku anínká mah marákó márákó wehukene ahbabáq kaweraritahráhuge. Sokigi ainíboq tagaríáhro éna aiayah pukia ánínsábé, Irigue arene máhriq mewe arene nahtapeq pokúno úwana ");
INSERT INTO awb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","mi anínká irigue wene nahtapeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pokúwara tago kegá áhtenuwe. Manikánka wehukení págege atowana ótaq sansá miraúnsabe sega áhtenéra Manikánsabe iwíáh íwíáh atówe. ");
INSERT INTO awb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sísaga mitaq suena ahtaqpeq nogutaq táhkísi moné méyáhwa aní néníwíq Mátíyu íné tagówe. Tagówana íné táhkísi moné méyáhwarabeq néne ópísirapéq tútuue míáhwana tagéna ínénsabe, Íné séniro úwana irigue kéráhwae. ");
INSERT INTO awb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sísaga nahtapeq táhutahurútaq áhnte táhkísi moné meyó kereq mó ahbábáq kéreqka mitaq séra Sísareq ite we kérahwána kereq moráráq táhutahurowane. ");
INSERT INTO awb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Táhutahurowanara Péhrasi kegá mina tagéra ite Sísa kérahwána keyábé kasenéra, Ite íwáhnori anínká aneqsabé táhkísi moné aebóo kereq mó ahbábáq kéreq moráráq táhutahuriro uwe. ");
INSERT INTO awb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Uwana Sísaga mi ehwéh irena sensabé, Sótehga awaho ke máráhsíni íre náriasa peh morá awahre ke náríre. ");
INSERT INTO awb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mina inserah ínéwé kaweqtaq míáh ké siahrabéna séhréh aritanieéna íre suge. Peh ahbabáq ke siahrabéna kaweraritanieéna suge. Minayabe Manikáne ehwehnka mahraréna, Titiré sansansábé íre nuwahbena peh arutaboiré séhréh arite sansansábé nuwahbehre ire. Mi ehwéhmé iwíáhue tagéq ahtebahro úwe. ");
INSERT INTO awb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sóni kéró kega Sísaba séra wensabé, Itereq Péhrasi kereqka mó tanáhráq mó tanáhrárue táhutahuq awehriúnara árahinsabé are kéráh kégá táhutahuq íre awehrioo uwe. ");
INSERT INTO awb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Uwana Sísaga sensabé pabeqme ehwéh teriena, Pahuwirotaqmé o menáhwénká wene iyahnaboba míéhtáqmé sega íre ibisia peh iwíáh íwíáhowe. Mókake o menáhwé seba íre míahnaraqmé mi tanáhráq wene iyahnaboga wensabé sirutaboiréra táhutahuq awehrigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sísaga mó pabeqme ehwéh mahraréna, Wehukenínká nahonáh sáhkétí kawerinieéna o ambántáráté íre párúwe kawerire. Miraitaq tahirímé nahonáh sáhkétí mó subanki irino. ");
INSERT INTO awb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wehukenínká o nahníáq sera ano naho naho mémene áúyahwa antéhyápípéq íre ahkíre. Miraitaq tahirímé sera anonka muinaraq nahonáh ántéhyá tapoagirana sera ano marakóraq antigi irino. Wehukenínká o será ano o antéhyápípéq ahkíre. Wehukega ahkírataq mi tehtáré náneqme kawerue kanae. O será anome kawerue kanae. Antehyamé moq kawerue kanae úwe. ");
INSERT INTO awb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sísaga mi ehwéh síwáhnorútaq Asiu kené wahnah anínká Sísaba séna áhtónsabe arehunseraráq ména wensabé, Nániyahu peh amahnága putíéhre. Arene ayahnkaratáté koráhtoréhnaraq we oga úkinae ");
INSERT INTO awb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","úwana Sísaga irigue mi aní kérowaq ite we kérahwána kegá moq kérahwáne. ");
INSERT INTO awb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ahtapeq kowanana awahre iní, airápété téhtaré ópéq wene korahq íre taraqnagú inínká Sísa anehepeq kúwe. ");
INSERT INTO awb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Anehepeq kure wewe náhenéna, Íné peh wene korósi koráhtoráhnaraqmé kaweraintankéhe éna wene korósi ayehrápéq koráhtorowe. ");
INSERT INTO awb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Táhtorowana Sísaga pabeqme we tagéna wensabé, Arega ínénsabe aiq pútare aintahna puana aru ukiq atóge úwana mi tanáhráq mi iní awaho ini úkúwe. ");
INSERT INTO awb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sísaga pokue wahnah aníné nahtapeq kibekúwara pembíáhnu kereq ibitunátúnánu kereq míówana tagówe. ");
INSERT INTO awb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tagéna sensabé, Mi ahráríwé íre airaiq pukia peh sugéhre. Máhpeq túmíáhro úwara wensabé awiréh atówe. ");
INSERT INTO awb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Awiréh atówana wega moke míó ke kaqsuena mi ahráríné máhriqtapéq kowéna wene ayahnkara táhtorowana irigúwe. ");
INSERT INTO awb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Irigú ehweh mitaq teri mahtaq terinuwara moke mi marákórápéqté kégá írówe. ");
INSERT INTO awb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sísaga mitaq suena ahtapeq kútaq aura pira ánítégá we kérera wensabé, Tébítine anahwao, arutaboiraito uye. ");
INSERT INTO awb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sísaga nahupeq kibekúwara mi anítégá weba suyana Sísaga sensabé, Itene iura kaweraitahráhunsabé aiq pútare aintehyo úwara sega wensabé kowe atera, Are aiq miraorahóne uye. ");
INSERT INTO awb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Uyana Sísaga siura táhtoqme sensabé, Itega ínénsabe aiq pútare aintehyanserah mirainauge úwara ");
INSERT INTO awb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","mi tanáhráq siura tagahrahuye. Tagahrahuyana wega sensabé págegeue iraréna, Miraunsabé mó ke teríyeho aritowara ");
INSERT INTO awb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","sega wene ehweh íre sehgira Sísaga miraú ehweh teríúyana mi ehwéh moke mi kehiná suwahpeq abae agúwe. ");
INSERT INTO awb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mi anítégá pokuyataq mó kegá owainawanka subiqmaq subiqmarú ani, ehweh íre orahú ani meqmera Sísaba móátówe. ");
INSERT INTO awb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sísaga owainawa kaqauwowana mi anínká ehwehnúwara moke tago kegá áhtenéra, Ísara marákórápéq morá ibora mahna tahnsa tagóne uwe. ");
INSERT INTO awb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Uwara Péhrasi kegá mahraréra, Owainawamaríné wahnahnka Sísa págege atéhnsábé owainawamarí kaqsuahráhire uwe. ");
INSERT INTO awb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sísaga moke mi ke suwahpeqkakáq áhnte kehiná suwahpeqkakáq nogena Asiu kené momiwí nahmárítápéq Manikánka wahnah wahnahnirabeqte éhwéh síwáhnoréna moke awahre kereq kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sísaga sáhuríó ke tagéna sensabé arutaboiraritowe. Se íre wahnahnkakáq sípísípíq tahnsa méra kaweqtaq íre míahrahéra sirupipeq iwíáh kikiru puana sensabé arutaboiraritowe. ");
INSERT INTO awb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Minayabe ite we kérahwána keyábé mahraréna, Nera kéh táhútáhúq áhnte kéhnserah Maniká íre tagaríáh ké áhnte míáhwe. Táhutahuq koawaqmíáh ké peh táhmaro míáhnserah Manikáne ehweh koreríé ké peh táhmaro míáhwe. ");
INSERT INTO awb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Minayabe, Maniká Iteribonsabé, Arene sotápéq koawaqmiahráho ke eqmaq suo ue púreroro. ");
INSERT INTO awb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sísaga airápété téhtaré ké we kérahwána keyábé íáhrabéna owainawamarí kaqsuera moke awahre ke kaweraritageheéna págege aitowe. ");
INSERT INTO awb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ite eqmaq iuwo kewe iteíwíqmari mahraue Sáímóniwe mó awíq Pítae. Pítane ábáqkawawé Ehntarue. Se ábárahré Sébérine ahninkáwáráré Sémísireq Sónirere. ");
INSERT INTO awb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mó anímárí iteíwíqmari mahraue Pírípi, Pátórómíyu, Tómáhsi, íné Mátíyue. Sísa íre kérena íné Mátíyuwe táhkísi moné meyáhwa aní míáhwae. Mó eqmaq suo aníté sensíwíqmé Ápíásane ahninkáwá Sémísireq Táríásarere. ");
INSERT INTO awb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Mó eqmaq suo aní Kénáni marákórápéqté ání wenáwíq Sáímónie. Mó aní Sísane naruo koweriranaú aní wenáwíqtare Súrása Ísíkáríótie. Iteíwíqmé mirauee. ");
INSERT INTO awb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sísaga ite airápété téhraníté eqmaq iuwanaútaq itensabé mahraréna, Wáhnaupéqté kéné marakórapeqkakáq Sámáría ke suwahpeqkakáq íre pokoro. ");
INSERT INTO awb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Peh morá Ísara kebá pokoro. Se tanahraipéq tabanagi sipísípíq tahnsa kée. ");
INSERT INTO awb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Seba pokue mahraréq, Manikánka wahnah wahnahnime aiq wahtonagire teríéro. ");
INSERT INTO awb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Awahre ke kawerariteq pusa ké iririteq náonkakáq ké kawerariteq owainawamarí kaqsúáhro. Págege aitónsábé ápeq íre méyáhro. Pehipi séhréh ariteq kawerarítáhro. ");
INSERT INTO awb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Pokonehe irataq ebah monéákáq sehenáh monéákáq kahnaraq mitaq mareq pokoro. ");
INSERT INTO awb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Unah íre mewe pokoro. Téhtaré síótí súu pegiqnáhnkarankákáq íre mewe pokoro. Séhréh arítéh kégá arambehri aní awehraq apéq náwigéhe. Minayabe ite íre matíéhra naneq náigéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sísaga ite we kérahwána keyábé mó mahraréna, Mó ke suwahpeq kirataq Manikáne ehwehnsabé awahbeh aní kogabaroro. Ábóraq maréhrataq wega itensabé, Néne nahtapeq segáéro ínaraqmé wene nahtapeq kogáéro. Moke mi ke suwahpeq míéhra tanáhráq peh morá mitaq kaegaeoro. ");
INSERT INTO awb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wehukene nahtapeq kirataq mi karírónánínsábé, Manikánka iru ukiq itankéhe teríéro. ");
INSERT INTO awb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Terírataq sega ite mehweh aitéhrataq seba míáhro. Sega íre mehweh aitéhrataqmé mah ehwéhmé mewe mó kené nahtaqpeq pokoro. ");
INSERT INTO awb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mó anínká ite íre mehweh aitena itene ehwehnsabé iuwahriehre ínaraqmé wene nah sueq itene igárátáq kahna tanáhúq poruarueq pokoro. ");
INSERT INTO awb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Teiníboq írátíáhro. Sóróma suwahpeqte kéreq Kómóra suwahpeqte kéreqka naho ahbabáruwe. Manikánka ehweh aitahna tanáhráq mi kegá miraunka ákáhtaq kamah arinkéhe. Ite íre mehweh aitera itene ehwehnsabé iuwahriehre ira kegá mirairanka Manikánka anotahtaq kamah arinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sísaga itensabé mó mahraréna, Írátíáhro. Sipisípiqka úrinsi iápá míéhnserah íwíoqnehra kebá eqmaq iuwaníe. Wehe ahtebia ká míéhrana kiboki uwaresa ká míéhre. Mi katáré míehya serahnoro. Ahtebia ánímárí méq uwaresa ánímárí míáhro. ");
INSERT INTO awb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wehukega ite íre kaweraitéhboq kawerue auráq matíáhro. Sega ite kaunsíri ke kotiorabeq móitera sene momiwí nahtápéq áréti sahtáté iubigéhe. ");
INSERT INTO awb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Néne sánsá sehgíónsábé ákáhtaq wahnáh kéreq anotah wahnáh kéreqka ehweh aitageheéra seba móitagéhe. Mi tanáhráq sereq mó nahnsó kéreq néne ehweh terigéhe. ");
INSERT INTO awb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sega ehweh aitéhrarabeq móítéhrataq aneq ehwéh irarenehnkono éq árahue terienéhnkono éq iwíáh kikiriyeho. Írakaumo. Mi tanáhráq Manikáne Awanka iwíáh aitahnaq ehwéh irarero. ");
INSERT INTO awb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mi tanáhráq íre iteitene ehweh irarigehe. Manikáne Awanka iwíáh aitahna ehwéh irarigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Sísaga mó mahraréna, Mó anínká wenawah wenábáq kotiorabeq móritena sáhsi keyábé, Subiq suahro aritankéhe. Sibowáréhga moq sene animárínsábé mina tahnsanigehe. Sene animárínká sinoibone naruo úkéra mó keyábé subiq suahro aritagéhe. ");
INSERT INTO awb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Néne sánsá sehgíó púara ómi kegá itensabé iuwahriehre aitagéhe. Itega néne sánsá íre susa anehe tanahráqkákáq kawerue sehgírataq Manikánka meirena airaiq kaweraitankéhe. ");
INSERT INTO awb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mó ke suwahpeq íwíoqnehrataqmé mitaq sueq pehbeheráhnue pokue mó ke suwahpeq kowíáhro. Teiníboq írátíáhro. Ísara kené táhúnipéq itene arambehri íre parabarúéhrataq íné wehukení úku anínká kouwekinauge. ");
INSERT INTO awb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sigaru anínká wene tísa íre kiotaikire. Arambehri anínká wene wahnah íre kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sigaru anínká wene tísaba mía míairana arambehri aní wene wahnahpa mía míainserah itega ínéba mía míaowe. Mó kegá íné iteruwahnsabé owainawane wahnah wenáwíq Pésébúrie aintárónsabé sega ite ínéba mía míao ke moq íre kaweq ehwéh aitagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sísaga mó mahraréna, Íwíoqnah keyábé áhreiyeho. Amahnága moke kopípéq kéh náneq mókake ábóraraginae. Moke epéqté éhwéh ábóraraginae. ");
INSERT INTO awb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ite sunkíkírirabeq teiú éhwéh téhrehrabeq teríéro. Epéq íráh éhwéh nahnsorapéqté sawai sawaiue teríéro úwe. ");
INSERT INTO awb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sísaga mó mahraréna, Peh morá itene inonka subiq suahráho keyábé íre áhreoro. Mi kegá iteyuwa íre subiq suahráhowe. Írakaumo. Minayabe sensabé íre áhreoro. Peh morá Manikánsabe áhreoro. Wega ebeq itene inonka subiqmarena anehe iteyuwa iraipéq suahráhire. ");
INSERT INTO awb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Peh morá pabusa mónéráté téhtaré káriq kabárá máhkétirapéq paiqmaráhwe. Iteriboga moke kabaramarínsábé iwíáhue tagéna íre kowe atahnaraq mi karíq kábárá marakóraq pehipi íre márunsurahorahire. ");
INSERT INTO awb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mina inserah Maniká Iteriboga ahriahri itensabé iwíáhue tagehre. Itene iyahqnopeqte íyáhrámé sáhnsahwe tagaríéhre. ");
INSERT INTO awb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wega ite aiq moke tagaríéh púaq íre áhreoro. Itega kabaramarí kiotaiko puana Manikánka ite íre abitaruanae. ");
INSERT INTO awb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sísaga mó mahraréna, Wehukenínká mó keyábé, Sísane ani múge terinaraq mókake Nánibonsabé, Mi anímé néne ani míre teawiníe. ");
INSERT INTO awb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mó ke míáhtáq ínénsabe ahqáho aintéh ánímé ínéga mókake Nánibo míéhrabeq wensabé ahqáho ataníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ínéwé sainkue míáh ké insahwé aitanieéna marakóipeq tutaire íwíáhoo? Írakaumo. Peh sainsuanieéna tutauge. ");
INSERT INTO awb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Íné tutau puana ahninkáwágá abowánsábé abiahnsa atankéhe. Ayahunkawagá anowansabé abiahnsa atankéhe. Anahbukawagá ahrahnawansábé abiahnsa atankéhe. ");
INSERT INTO awb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wenawahrah anímárínká wene naruo úkigehe. ");
INSERT INTO awb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wenanoibonsabé anotahtaq arutaboiréna ínénsabe peh ákáhtaq arutaboiraintéh ánímé íre néne ani míahrahire. Wene ahninkáwáreq ayahunkawareqsabé anotahtaq arutaboiréna ínénsabe peh ákáhtaq arútábóíraintéh ánímé íre néne iyahnabo aní míahrahire. ");
INSERT INTO awb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nánibone arambehri miraunsabé íné awankátaq táhpawe nubiq suagéhe. Ínéga miraunserah miraue séníráhro. Minayabe néne arambehriraq túbáh agéna peh we awahbeh arámbéhrí sehgí ánímé íre néne ani míahrahire. ");
INSERT INTO awb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wewensabé arutaboiréna peh wewe awahbeh iwíáh mira aruqaruri anímé oga mérapeq íre awaq miahráhire. Néne sánsá sehginieéna wewe awahbeh iwíáh susuri anímé oga mérapeq awaq miankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sísaga mó mahraréna, Ite mehweh aitáh kégá íné moq mehweh aintáhwe. Ínénsabe mehweh aintáh kégá íné eqmaq núwéh ání moq mehweh atáhwe. ");
INSERT INTO awb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Manikáne ehweh irari anínká sitaq mó anínká iwíáhéna, We Manikáne ehweh irari aní púana séhréh ataníe ire. Séhréh ataníe éna mi anínsábé mehweh atena kiraboime kaweq sansánire. Manikánka wene ehweh irari aní ápeq awinanserah we mehweh atéh ání moq ápeq awinkéhe. Kaweqtaq mía míai anínká sitaq mó anínká iwíáhéna, We kaweqtaq mía míai aní púana séhréh ataníe ire. Séhréh ataníe éna mi anínsábé mehweh atena kiraboime kaweq sansánire. Manikánka kaweqtaq mía míai aní ápeq awinanserah we mehweh atéh ání moq ápeq awinkéhe. ");
INSERT INTO awb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Teiníboq írátíáhro. Pehgáriq aní íné séníréh ání míéh púana mó anínká né waní náwinana Manikánka mi aníné ápeqme íre tabanagia peh ahreraq kanawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sísaga moke mi ehwéh ite we kérahwána ke teiuwe. Wega ite airápété téhraníté we kérahwána keyábé itene arambehriyabé íwáhnoréna mitaq suena wahtotaq kehiná suwahpeq mó ke síwáhnorinieéna pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sóni wání meri merini aní karábúsiipéq ména Sísa Karáhéga miraú ehweh irena we kéróya anítégá Sísa kasenigeheéna weba eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Eqmaq suowara Sísaba kéra wensabé, Sóniga, Arewe Manikánka eqmaraníe ú anípo? Ite mó anínsábé áwénunonehnkono ire uye. ");
INSERT INTO awb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Uyana Sísaga sensabé, Irehya ehwéhnkákáq tagéhya naneqkakáq Sóni koreawétao. ");
INSERT INTO awb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ínéga miraunka aura pira kégá tagahwara aigárá soriqnah kega ah nogówara náonkakáq kéné náo wagirara ahre parosa kégá ehweh irahwe. Pusa ké iriwe oganúq sitena tabonah ke Manikáne kaweq ehwéh síwáhnoruge. ");
INSERT INTO awb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ínénsabe árahinabomo íwíáh íre iwíáhia peh ínénsabe kawerue aiq pútare aintéh ánímé aru ukiqme aní míéhre. Mah ehwéh Sóni koreawétao úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Úwara Sóni kéróya anítégá mitaq suera pokuyataq Sísaga weba sáhuríó ke Sóni éhweh teriuwe. Wega mahraréna, Sóniga uworapeq íwáhnoruraitaq koraganehe urotaqmé we inse wíre íwíáhuroo? Sóiririrana onega míu míu inserah Sóni mó iwíáh mó iwíáhi aní míre íwíáhéq koragaroo? Írakaumo. Sóniwe íre mina tahnsa ání míre. ");
INSERT INTO awb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Sóni koraganehe urotaqmé we inse wíre íwíáhéq koragaroo? Kaweq korósí aneraneria ání koragaroo? Írakaumo. We íre mina tahnsa ání míarairara kaweq korósí aneraneria kéwé uworapeq íre mía peh wahnah kené nahtapeq mía míaowe. ");
INSERT INTO awb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","We inse wíre íwíáhéq koragaroo? We Manikáne ehweh irari aníne íwíáhuroo? Aiq pútaq iwíáhowe. Írátíáhro. We Manikáne ehweh irari anínéna moke mó ke áwáhu ke kiotaikuraire. ");
INSERT INTO awb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sóni éhwehme Manikáne ehwehnka mahraréna, Néne ehweh korerina anímé ebeq eqmarahnana are sina ah kawerarankéhe ire úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sísaga mó mahraréna, Teiníboq írátíáhro. Sóni wání meri merini aní anotah anínirara moke mó kegá we íre kiotaikowe. Íre kiotaikowana Manikánka wahnah wahnahnirabeq íópipeq kibeki aní pehgáriq anínká Sóni kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sóniga ehweh iraruraitaqkakáq amahnágaákáq págege sansáno kegá íópeq Manikánka wahnah wahnahnirabeq kibekoneheqmúne éra sene págege sansánowe. ");
INSERT INTO awb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Manikáne ehweh iraru kereq Mósísireqka Manikánka wahnah wahnahnirabeqte éhwéh teiúwana Sóniga suraire. ");
INSERT INTO awb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sene ehweh aiq pútare arítáhmé kawerowe. Sega pabeqme ehwéh irarume Éráísa mónkakáq sinae ewe. Sóniga menah surainsabé sene ehweh aiq pútaraguraire. ");
INSERT INTO awb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Íre parosa áhréákáq kéo, írátíáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Sísaga mó mahraréna, Amahnága oga míáh kéwé ite aneq tahnsá kée teinínkono? Itewe káriq anímárínká máhkétirapéq ogi ogionserah tahnsá ké wóe. Mó anímárínká mó anímárínsábé abiahnsa aritera sensabé, ");
INSERT INTO awb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Igonkónúnaraq itega íre ábáhrowe. Ibitunántúnánúnaraq itega íre ibisahwe ewe. ");
INSERT INTO awb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sóniga suraitaq wega táhutahuq awehriéna náhníáq sera ano íre narainsabé sega abiahnsa atera, Owainawanka iwíáh atéh ání míre atárówe. ");
INSERT INTO awb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Íné wehukení úku anínká surautaq táhutahuqkakáq náhníáq sera anonkakaq pehipi nogara sega ínénsabe abiahnsa aintera mahraréra, We kobuq kahburi uwoyansa aní míre aintera táhkísi moné meyáh kéreq mó ahbábáq kéreqne iyahnabo aní míre aintáhwe. Sega ínénsabe mi ehwéh irarewara Maniká tagaríáh kégá ahtebé sansánirataq mó kegá tagéra, Se aiq pútaq sansánowe ewe úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sísaga mó kehiná suwahpeq áhnte otáq sánsánúwara tago kegá sene ahbabáq sansa íre súónsabe Sísaga mi keyábé ehweh aritowe. ");
INSERT INTO awb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Wega mahraréna, Kórásíni suwahpeqte kéreq Pétásáíra suwahpeqte kérero, kamah ainehboq kawerurero. Iteruwahpeq áhnte otáq sánsá miraurauge. Táíya suwahpeqte kéreq Sáíróna suwahpeqte kéreqka mina tagotaq tahirímé sene ahbabáq naho suera kaweqtaq míó irino. Sega mina tagotaq tahirímé sene ahbabáq aiq súónsabe Manikánka tagankeheéra nahonáh kórósí aneranerue tanah abaq marera sene ahbabáqsabe tútuue ibiso irino. ");
INSERT INTO awb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Teiníboq írátíáhro. Manikánka ehweh aitahna tanáhráq mi keyábé peh ákáhtaq kamáh arinkéhe. Mi tanáhráq ite Kórásíni suwahpeqte kéreq Pétásáíra suwahpeqte kéreq anotahtaq kamah ainawire. ");
INSERT INTO awb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kápénéáma suwahpeqte kéo, ite kaweq ke míone éq minayabe íópeqté mátábúrápéq kioneheqmúne íwíáhoo? Írakaumo. Mibeq íre kioneheqmóe. Peh iraipéq kowíáhro aitanawire. Ínéga págege otáq sánsá iteruwahpeq mirauraugaq tagarowe. Mirauraunserah Sóróma suwahpeq miraowataq tahirímé mi kegá sene ahbabáq sansa suera kaweqtaq míó irino. Sene ahbabáq súótaq tahirímé Manikánka sensuwahpeq íre kekira peh kéh irino. ");
INSERT INTO awb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amahnága teiníboq írátíáhro. Manikánka ehweh aitahna tanáhráq wega Sóróma suwahpeqte kéyábé arutaboiréna peh ákáhtaq kamáh arinkéhe. Mi tanáhráq ite anotahtaq kamah ainawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sísaga púrerue mahraréna, Nániboo, arega moke íópeqkákáq mah marákó márákóákáq wahnahnóne. Wehukene sánsá ahtebah kewé arene sánsá íre sokigi ariasa peh morá káriq aní tahnsa ké arene sánsá aiq sokigi aiene. Minayabe arensabé iwíáh íwíáh atóge. ");
INSERT INTO awb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nániboo, arerega iwíáhue aiq miraóne úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sísaga mitaq míó keyabé mó mahraréna, Nániboga moke náníre. Mó kegá íné Manikáne ahninkáwá íre tábúsoqme tagaríáhwana Nániboga webataq íné wenahni tagaríéhre. Mó kegá Nánibo íre tagaríáhwana ínébataq wenahninká we tagaríóge. Íné wenahninká sokigi aiéna kegá moq Maniká Iteribo tagariagehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Sísaga mó mahraréna, Págege arámbéhríéq irupipeq umehi keo, ínéba sero. Ínéba sirataq ahrenahro aitena iru ukiq itaníe. ");
INSERT INTO awb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Néne arambehri sehgieq néne sánsá ahtebahro. Íné uwaresa ánínéna pehwehrue mía míau aní púaq ínéba sirataq irupipeq ukiq itahnaq ahrenagehe. ");
INSERT INTO awb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Néne arambehriwe irupipeq íre págegeorahi arámbéhrí wíre. Mi arámbéhrí sehgírataq irupipeq eyoyó aitaníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mi tanáhráq ahrena ahrena wehekáh Sísareq ite we kérahwána kereqka páréti mirao naneq será sotápéq kótaikowanaraq irupibiúwaq itega mi será késabaríqme késabaríqme ue kure nahwane. ");
INSERT INTO awb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nahwanara Péhrasi kegá tagéra Sísansabé, Tagáhno. Are kéráh kégá ahrena ahrena wehekáh íre mirao naneq sansánowe. Minayabe sega ahbabárowe uwe. ");
INSERT INTO awb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Uwana Sísaga sensabé, Itewe Manikáne púkuipéqté séhírámé Tébítireq we kéró kereqka sirupibiútaq mirau sansámé íre sáhnsahwe ahtebaho? ");
INSERT INTO awb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tébítiga Manikánsabe iwíáh íwíáh atáh náhúpéq kibekéna Manikánka tagankeheéra máró parétí mewe nówara we kéró kega moq nowe. Nonsabe íre mirao naneq miraowe. Mósísine ehweh irarunka mi parétíwé pehipéqté kégá íre nah nanere. Peh morá Manikáne ehweh mibeq mahbeq arítáh kégá nahrahowe ire. ");
INSERT INTO awb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mósísine ehweh mibeq mahbeq arítáh kéné ehweh aiq sáhnsahona wino. Mi ehwéhnká teímé ahrena ahrena wehekáh sega Manikánsabe iwíáh íwíáh atáh náhtápéq arambehriuwana Manikánka íre abiahnsa aritowe ire. ");
INSERT INTO awb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Teiníboq írátíáhro. Íné mahtaq ména Manikánsabe iwíáh íwíáh atáh náhtápéq kiotaikuge. ");
INSERT INTO awb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Manikáne ehwehnka mahraréna, Titiré sansansábé íre nuwahbehrana peh arutaboiré sansa séhréh arite sansansábé nuwahbehre ire. Itega mi ehwéh ahtebahtaq tahirímé íné séníráh ké kaweqtaq míáh kéyábé, Ahbabárowe íre aritewáh irino. ");
INSERT INTO awb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Íné wehukení úku anínká ahrena ahrena wehekáh wahnah wahnahnuge úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sísaga mitaq suena Asiu kené momiwí nahtápéq kibekúwana ");
INSERT INTO awb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","sawenkahnia áyáhnkákáq ání míowe. Péhrasi kegá Sísa ehweh ataneheéra we kasenéra, Ahrena ahrena wehekáh wehuke kaweratewé Mósísine ehwehnka ahqáho atehro uwe. ");
INSERT INTO awb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Uwana Sísaga sensabé, Ahrena ahrena wehekáh itene ka íre wahto matáípéq tupekitaq mi ka tumeyáh mino. ");
INSERT INTO awb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wehukenínká ménkámehnká aiq kiotaiki mino. Minayabe ahrena ahrena wehekáh Mósísine ehwehnka kaweq sansánsábé íre ahqáho atéhre. ");
INSERT INTO awb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Íre ahqáho atéhre éna sawenkahnia áyáhnkákáq ánínsábé, Arene ayahnkara obariro úwana wene ayah obarirowana kaweragúwana ébeq ayáhnkárá tahnsa úkúwe. ");
INSERT INTO awb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Péhrasi kegá tueague sío síoéra, Sísawe árahue subiq suanéhnkono uwe. ");
INSERT INTO awb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Árahue subiq suanéhnkono u ehwéh Sísaga irena mitaq suena pokúwara áhnte kegá we kérówe. Áhnte kegá we kérówana moke awahre ke kaweraritena ");
INSERT INTO awb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","sensabé, Íné éhweh mó ke teriyeho aritowe. ");
INSERT INTO awb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sísaga áhnte awáhré ké kaweraritonsabe Manikáne ehweh irarú ani Áísáíaga sehiranú ehwehnká aiq pútaragúwe. Mi ehwéhmé Manikánka irarú ehweh wega sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Néne arambehri mirai aní ínéga omaq ató ání aiq míéhre. Wensabé nirutaboiréna wene arambehriyabé nuwahbehre. Ínéniwanka weba mía míaínana wega nahnso ke kaweq sansá terinkéhe. ");
INSERT INTO awb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wega íre ehwehinae. Wega íre anotahtaq ehwehninae. Ahtapeqté íre sawai sawaiinae. ");
INSERT INTO awb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wega mareqmareq sah íre airaiq piteruanae. Áráhmu pehgáriq téhráhnaraq íre puinsuanae. Ahqáho. Mirainaga kaweq sansánká ahbabáq sansa kiotaikinae. ");
INSERT INTO awb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nahnso kegá wene ehweh irera, Ite kaweraitankéhe íwíáhigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mó kegá aura pira ání, íre ehwehnorahú aní meqmera Sísaba móátówe. Wene arupipeq owainawa mío púana we íre ehwehnorahú aní, aura pira ání míowe. ");
INSERT INTO awb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sísaga mi aní kaweratowana ehwehnéna aura tagówe. Mina tago kegá áhtenéra seye náhenéra, Kaweratéh ánímé Tébítine anahwabómo uwe. ");
INSERT INTO awb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Péhrasi kegá kawerato ehweh irera, Pésébúri owainawane wahnahnka Sísa págege atena séhréh atéh púana Sísaga owainawamarí kaqsuahráhire éra seye náhenéra ehmuniq éhmúníruwe. ");
INSERT INTO awb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ehmuniq éhmúníruwana Sísaga sene iwíáh tagéna sensabé, Wahba márákórápéqté kégá seye ebehirataq sainkoneherawoe. Minayabe se págegeue morá ké íre míahrahowe. Sensuwahrahreq seye ebehirataq sainkoneherawoe. Minayabe se págegeue morá ké íre míahrahowe. ");
INSERT INTO awb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Owainawanseq wenawahrahreq ebehotaq tahirímé se sainkéra págegeue morá ké íre míahraho irino. ");
INSERT INTO awb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ínéga owainawa kaqsúótáq owainawane wahnahnka séhréh aintéhtáq tahirímé ite kéíráh kégá owainawa kaqsúáhtáq insega séhréh arítéh iripo? Ite kéíráh kégá itene ehwehnsabé íre tábúsoréhre aitáhwe. ");
INSERT INTO awb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Manikáne Awanka págege aintena séhréh aintéh púana owainawa kaqsuq kaqsuruge. Mina tagéq Manikánka wahnah wahnahni sansá iteba aiq sire éq tagaríáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Sísaga mó mahraréna, Wehukenínká ayahnsa kira wéhné ménsámehnsá meyanieéna wene nahupeq árahue kibekorahiro? Ebeqme ayahnsa kira wéh táhtoqme táhru táhruarena anehe wene nahtapeqté ménsáméhnsá pehipi meyahráhire úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Sísaga mó mahraréna, Wehukenínká íre néne iyahnabo aní míéhmé néne naruo aní míre. Wehukenínká ínéreq íre soruparítéhrataqmé wega wehuke karegaráh aruqarurire. ");
INSERT INTO awb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Peh morá Manikáne Awansabe abehq éhwéh atáh kéwé Manikánka mi ke íre insahwé aritankéhe. Mi ahbábáq peh ahreraq matiankehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Íné wehukení úku anínsábé níéhruru aintéh ánímé Manikánka insahwé atahráhire. Manikáne Awansabe éhruru atéh ánímé Manikánka amahnágaákáq mókakeakáq mi aní íre insahwé atena wene ahbabáq peh ahriahri ahreraq matiankehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sísaga Péhrasi keyábé mó mahraréna, Peh morá kaweq awánkánká kaweq será íyéhre. Íre kaweq awánkánká abehq sérá íyéhre. Wehukenínká awanká sera tagéna mi awánká ahtebehre. ");
INSERT INTO awb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Itewe wehene animárí móe. Itene irupipeq kéh náneq itene íwéhga irarerahire. Itene irupipeq íre kaweq iwíáh kéh púaq kaweq ehwéh íre irarerahowe. ");
INSERT INTO awb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaweq anímé wene arupipeq kaweq iwíáh kéh púana kaweq sansánire. Ahbabáq animé wene arupipeq ahbabáq iwiáh kéh púana ahbabáq sansanire. ");
INSERT INTO awb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Teiníboq írátíáhro. Ehweh aitahna tanáhráq Manikánka wehukene ehweh iwíáhue tagéna moke sene abehq éhwéhnsábé saraqmarankéhe. ");
INSERT INTO awb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kaweq ehwéh irare irareóna aníno, Kaweq aní móne atankéhe. Ahbabáq ehweh irare irareóna aníno, Ahbabáq ani móne atankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Táhmaro Mósísine ehweh síwáhnoro kereq Péhrasi kereqka Sísansabé, Íwáhnoraníno, itega Manikáne arambehri miraóna aní taganehboq arega ótaq sansánúno uwe. ");
INSERT INTO awb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Uwana Sísaga sensabé, Amahnága oga míáh kégá Manikánsabe íre iuwahbehraq ahbabáq ke míáhwe. Ótaq sansánúno ewo? Írakaumo. Wehukení wenáwíq Sónaga sóreq wanípípéq tupekútaq Manikánka ótaq sansá miraúwe. Peh morá mi sansá teienaq iwíáhue tagagehe. ");
INSERT INTO awb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sóna apahtáró wéhékáh anotah pahné arupipeq míonserah íné wehukení úku aní apahtáróráq marakóipeq míanie. ");
INSERT INTO awb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Níníbe suwahpeqte kégá ahbabáruwana Sónaga ehweh koreriutaq wene ehweh irera sene ahbabáq sansa suera kaweqtaq míówe. Minayabe Manikánka ehweh aitahna tanáhráq Níníbe suwahpeqte kégá iriwe méra ite amahnága oga míáh kéyábé, Íre kawerowe éra ehweh aitagéhe. Amahnága iteba míó ánímé Sóna kiotaiku aní múge. Níníbe suwahpeqte kégá Sónane ehweh írónserah árahinsabé néne ehwehme íre iraho? ");
INSERT INTO awb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sórómóniga Ísara ke wahnahnútaq wáhnaupéqté kéné wahnah inínká wene ahtebia éhwéh iranieéna íre wahtopeqte weba súwe. Teiníboq írátíáhro. Amahnága iteba míó ánímé Sórómóni kiotaiku aní múge. Mi inínká Sórómónine ahtebia éhwéh ironserahme árahinsabé néne ehweh íre iraho? Minayabe Manikánka ehweh aitahna tanáhráq mi inínká iriwe ména itensabé ehweh aitankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sísaga Mósísine ehweh síwáhnoro kereq Péhrasi kereqsabé mó mahraréna, Owainawanka wehukení auwena pokitaq wání íre kéhrabeq nogena ahrenahrahirabeq kabarire. Kabarirana írakauninsabé iwíáhéna, ");
INSERT INTO awb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ínéga súó náhtápéq seuwekinauge éna áúwátái wéhúkénípá kouwekire. Kouwekéna wene nah tagehrana aiq kabantáhwe kaweraréhre. ");
INSERT INTO awb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kawerarena mó abapete téhraníté áhnte ahbábáq ówáínáwámárí koweriréhre. Moke mi owáínáwámárí mi anípá kowíáhwe. Téhwe peh morá ówáínáwánká mi anípá míéhtáq íre kawerire. Anehemé áhnte owáínáwámárínká weba míáhnsábé anotahtaq íre kawerire. Mi aní íre kaweraginserah amahnága ite oga míáh áhbábáro ke íre kaweqtaq míaneheqmóe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sísaga nahupeq ména ehweh teriutaq wenanoreq wenábáqmarinseq máhpeq iriwe méra Sísareq ehwehnéyabe suwahbówe. ");
INSERT INTO awb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Suwahbówana mó anínká Sísansabé, Arenanoreq arenábáqmarinseq máhpeq iriwe méra arensabé áhrabowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Úwana Sísaga míó keyabé mahraréna, Náinowé insebo? Náníbáqsome inseréhbo éna ");
INSERT INTO awb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ite we kérahwána ke ayahnáwíqme mahraréna, Mah kewé náinoreq náníbáqmarinseq móe. ");
INSERT INTO awb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Íópeqté Náníbó awahbeh arámbéhrí sehgíó kéwé náníbáqmari móe. Náinahnoreh wóe. Náinoréh wóe úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mi wehekáh Sísaga nahtapeqté tueyokéna káwehu ayehráq tunse mitaq tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tútuue míowara íregáritaq weba sáhatíó púana Sísaga wánípipeq ko sipíípéq kibekue tútuue míowara moke míó kega arahwéraq iriwe míówe. ");
INSERT INTO awb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Míówana Sísaga áhnte pabeqme ehwéh síwáhnorúwe. Wega mahraréna, Ayu suitabeh anínká wene sotápéq ayu suitabanieéna pokire. ");
INSERT INTO awb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Suitabehtaq mó ayú ahtaq megirana kabaranka sésiq nehre. ");
INSERT INTO awb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mó ayú kiruraq megirana pehgáriq marákó kéhnsábé mi ayú apubúue kiapoue kíréhre. ");
INSERT INTO awb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Anotah patáhitaq tamurupague íre ánúq píéh púana ehyatagire. ");
INSERT INTO awb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mó ayú náwerarúítáq megirana náwe kirena kárígariirana sera íre íyéhre. ");
INSERT INTO awb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mó ayú kaweq marákóráq megirana kiapoue kirena áhnte será iratanire. Mó ayú 100 será íyéhrana mó ayú 60 será íyéhrana mó ayú 30 será íyéhre. ");
INSERT INTO awb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Íre parosa áhréákáq kéo, kawerue íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Síwáhnorúwaq ite we kérahwána kegá Sísaba séq wensabé, Mó ke síwáhnorónaraq aneqsabé pabeqme ehwéh terieno ewane. ");
INSERT INTO awb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ewanana Sísaga itensabé, Manikánka íópeq wahnah wahnahnirabeqte éhwéhmé menah wehukega íre írátíahrahurowe. Amahnága Manikánka mi ehwéh ite sokigi aíre. Peh mó ke íre sokigi aríre. ");
INSERT INTO awb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Manikánka wene ehweh kawerue íréh ání mó sokigi awinana áhnte ahtebanae. Wene ehwehnsabé anetaníbo i aní mó íre sokigi awinana we pehgáriq ahtebeh naneq abitaginae. ");
INSERT INTO awb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Minayabe wehuke pabeqme ehwéh teríúge. Sene siuranka tagéra íre tagaríáhwe. Sene siahrega irera íre írátíáh púana pabeqme ehwéh teríúge. ");
INSERT INTO awb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Minayabe Manikánka iwíáh atowana Áísáíaga sehiranú ehwehnká aiq pútaragire. Mi ehwéhmé Manikánka irarú ehweh wega sehiranue mahraréna, Itega ehweh ireq itene irupipeq íre írátíáhwe. Itega tagéq itene irupipeq íre tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mi kené sirupipeq íre ahtebahrahowe. Seyene siahre aiq parokire. Seyene siura aiq mútúgire. Sega íre miraotaq tahirímé sene siuranka tagéra sene siahrega irera sene sirupipeq ahtebéra sene ahbabáq suera íné níáhrabo irino. Sene ahbabáq suera íné níáhrabotaq tahirímé kawerarító irino úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sísaga ite we kérahwána keyábé mó mahraréna, Itene iuranka áhntetaq tagahnsabe itene iahrega áhntetaq íráhnsábé iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Teiníboq írátíáhro. Áhnte Manikáne ehweh iraru kereq kaweqtaq mía míau kereqka itega tagah naneq tagéyabe suwahbówara íre tagowe. Itega íráh éhwéhnsábé sega ireyabe suwahbówara íre írówe úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Sísaga itensabé, Ayu suitabé pabeqme ehwéh áwahe ahtebagehboq írátíáhro. ");
INSERT INTO awb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Manikánka wahnah wahnahnirabeqte éhwéh siahrega irera íre ahtebah kewé ahtapeq megi ayú tahnsane. Owainawanka sirupipeqté mi ehwéh apubúue seaebóire. ");
INSERT INTO awb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kiruraq megi ayúmé kiapoinserah wehukenínká Manikáne ehweh irena arupipeq eyoyóéna apubúue kowe atéhre. ");
INSERT INTO awb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Manikáne ehwehnka arupipeq íre ánú píéhnsábé pehgáriq tanáhráq sehgíre. Mi ehwéh sehgínsábé mó kegá áwíoqnahwana íre kaweq sunúq sire. Mi tanáhráq wega túbáh agéna Maniká áúwéhre. ");
INSERT INTO awb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Náwe tarúítáq megi ayúmé wehukenínká Manikáne ehweh irena sehginie íwíáhéna mah marákó márákóípéqté náneqsabé iwíáh íwíáhéna ménsámehnsánkakaq móneakáqsábé arutaboirire. Náwe soaginserah minawarinká saiqnaríéh púana wega Manikáne arambehri íre miraire. ");
INSERT INTO awb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kaweq marákóráq megi ayúmé wehukenínká Manikáne ehweh irena arupipeq tábúsoqme iwíáhire. Kaweq marákóráq kaweq será íyéhnserah wega mi ehwéh sehgiena Manikáne arambehri kawerue miraire. Kawerue miraéna mó anínká 100 tahnsá áhnte kaweq arámbéhríirana mó anínká 60 tahnsá kaweq arámbéhríirana mó anínká 30 tahnsá árámbéhríire úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sísaga mó pabeqme ehwéh mahraréna, Manikánka íópeqté wahnah wahnahnime wehukenínká wene sotápéq kaweq ayú uqmatainserahne. ");
INSERT INTO awb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Inokáhpeq wehuke sugé tanahráq wene naruo anínká sure kaweq ayú uqmataitaq náwe uqmarena pokuraire. ");
INSERT INTO awb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kaweq ayú kirena iyanauraitaq náweakáq kítáire. ");
INSERT INTO awb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","So abone arambehri anímárínká sure wensabé, Arene sotápéq peh kaweq ayú uqmatonawe mah nawé eheqte kirehro urowe. ");
INSERT INTO awb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Urowana sene wahnahnka sensabé, itene naruo anínká mi nawé uqmataire urairara sega wensabé, Náwe soranéhnkono urowana, ");
INSERT INTO awb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ahqáho. Náwe soréhrataq kaweq naneqkakáq pagorúéhboq moráráq kirankéhe. ");
INSERT INTO awb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Moráráq kirahnana nera kahnaraq ínéga arambehri keyábé, Téhwe mi nawé saue airíwe ira paríáhro. Anehe kaweq será isíwe néne ménsámehnsá kéh náhúpéq sáharáhro aritaníe uraire úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sísaga mó pabeqme ehwéh mahraréna, Manikánka wahnah wahnahnime pehgáriq ayú tahnsane. Mi ayúmé íre mó sotápéqté áyú tahnsane. Írakaumo. Mi ayúmé pehgáriq ayúne. ");
INSERT INTO awb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wehukenínká mi pehgáríq áyú wene sotápéq uqmatairana kirena anotah awánká úkéna moke mó mensáméhnsá kiotaikire. Anotah awánkánirana kabaramarínká séra ayahnaweraq sene nah píáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sísaga mó pabeqme ehwéh mahraréna, Tírí ínínká muoráhi naneq páráwahipéq maqme ayahnirana moke múíre. Manikánka íópeq wahnah wahnahnime mina páréti muoráhi naneq tahnsáne úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sísaga weba sáhuríó ke ehweh teriena sensabé íre pahsuqme teriasa peh pabeqme ehwéhmárí teriuwe. ");
INSERT INTO awb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Manikáne ehweh irarú aniné ehweh aiq pútaraginkeheéna Sísaga peh pabeqme ehwéh teriuwe. Mi pukúípéqté éhwéhnká mahraréna, Ehweh teriénaraq peh pabeqme ehwéh teriníe. Mah marákó márákó miraútaqkakáq menahnkákáq epéqté éhwéh káráirana amahnága teriníe ire. ");
INSERT INTO awb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sísaga weba sáhuríó ke suena nahupeq kibekúwaq ite we kérahwána kegá weba séq wensabé, Mi pabéqmé éhwéh náwe uqmatai ehwéhmé pahsuqme teio ewane. ");
INSERT INTO awb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ewanana Sísaga itensabé pahsuqme teiena, Kaweq ayú uqmatai anímé íné wehukení úku aníne. ");
INSERT INTO awb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Somé mah marákó márákóe. Kaweq ayúmé Manikánka wahnah wahnahnirabeq kioráho ke wóe. Náwewe owainawane anímárí móe. ");
INSERT INTO awb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Náwe uqmatai anímé owainawa mire. Nera kahna tanáhráqmé mah tanáhráq parabagínana Manikánka sainsuahna tanáhráq míre. Sera ísíra kewé íópeqté ké wóe. ");
INSERT INTO awb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Náwe sauwe ira paríáhnserah mah tanáhráq parabagínana Manikánka sainsuahna tanáhráq sinawire. ");
INSERT INTO awb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mi tanáhráq íné wehukení úku anínká íópeqté ké eqmaq suahnara Manikánka wahnah wahnahnirabeq kioráhira ke míéhrataq moke ínéhgíó kéreq mó ahbábáq kéreq sorupagehe. ");
INSERT INTO awb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sorupéra anotah iráípéq kaqsuehrara mitaq ibiséra uwo uwo oneherawoe. ");
INSERT INTO awb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mi tanáhráq Manikáne animárí Sensiboga wahnah wahnahnirabeq kaweqtaq méra patahi serahnigehe. Íre parosa áhréákáq kéo, kawerue íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sísaga mó mahraréna, Manikánka íópeq wahnah wahnahnime wehukenínká móne antéhyá wene sotápéq ubuqme kopéq suonserahne. Mó anínká mi antéhyá ábóraq marena áhnte moné mipipéq kéhnsábé mitaq mó akariaréhre. Wene arupipeq eyoyóirana móne paiqmianieéna moke wene ménsámehnsá paiqmarena mi moné mewena móne antéhyá kéh só kobaiqmáréhre úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Sísaga mó mahraréna, Manikánka íópeq wahnah wahnahnime ménsámehnsá paiqmaq paiqmari anínká kaweq pasésúq paiqmaranieéna kabari serahnire. ");
INSERT INTO awb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wega peh morá pásésúq áhnte kaweq pasésúq tagéna moke wene ménsámehnsá paiqmarena mi moné mewena mi pasésúq kobaiqmáréhre úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Sísaga mó mahraréna, Manikánka íópeq wahnah wahnahnime kahweraté uwe taga tagao serahnire. Wehukega káwehupípéq anotah kahwéráté uwe taga tagaéra áhnte mó naneq ka mó naneq kanue maqmíáhwe. ");
INSERT INTO awb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Maqmíáhtáq kahweipéq áhnte kéhrara arahwéraq tútuue méra pah siqmíáhwe. Siqmarera kaweq ka pah antéhyápípéq sáharera íre kaweq ka súáhwe. ");
INSERT INTO awb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mina onserah mah tanáhráq parabagínaraq íópeqté kégá sure kaweq ke míéhrarabeqte áhbábáq ké aiqme meriqmera ");
INSERT INTO awb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","anotah iráípéq tuparuehrara mitaq ibiséra uwo uwo oneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sísaga ite we kérahwána keyábé, Teiú éhwéh moke aiq iraho úwaq itega wensabé, Aiq irone ewane. ");
INSERT INTO awb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ewanana Mósísiga sehgíóro ú ehweh íráh kégá íné wahnah wahnahnu ehwéh aiq ahtebahwe. Mi kegá anotah nah matíéh ánínká mira inserahnowe. Anotah nah matíéh ánínká peh morá páqnáhípéq áhnte mensáméhnsá matíéhre. Wega mi paqnáhípéqté o mensáméhnsánkákáq nahonáh ménsáméhnsánkákáq mewe máhpeq tueyokire úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sísaga mi pabéqmé éhwéh teiena mitaq suena ");
INSERT INTO awb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","wenawahperurá pokúwe. Mitaq momiwí nahtápéq kibekéna síwáhnorúwara író kega, We árahue ahtebia ání úkurairo éra, Wega ótaq sansá árahue mirairo éra áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Áhtenéra, We peh nah píéh áníné ahninkáwá wíre. Wenanowé Máhría wire. Sémísiwe, Sósépawe, Sáímóniwe, Súrásawe, wenábáqmari móe. ");
INSERT INTO awb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wenanahnoreh mahtaqté ánímárí móe. Minayabe we árahue ahtebia ání úkurairo éra ");
INSERT INTO awb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","wensabé abiahnsa atówe. Abiahnsa atówana Sísaga sensabé, Manikáne ehweh irari anínsábé mó ke suwahpeqte kégá iwíáh íwíáh atáhwe. Peh morá wenawahpeqte kéreq wenawahrahreqka wensabé íre iwíáh íwíáh atáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Úwana sega wensabé íre aiq pútare ató púana mitaq áhnte otáq sánsá íre miraúwe. ");
INSERT INTO awb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sísa éhweh mitaq teri mahtaq terinuwana mi tanáhráq anotah wahnáh ání Érótiga irowe. ");
INSERT INTO awb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Irena wene arambehri keyábé mahraréna, Mah anímé Sóni wání meri merini aní míre. We pukéna mó oga úkurai puana amahnága págege otáq sánsánire úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Sóni oga míotaq wega Érótinsabé ehweh atena mahraréna, Arenábáqne ahre meronawe Mósísiga sehgíóro ú ehweh aiq anterutone úwe. Wenábáq Pírípine ahre Éróríása meyonsabe Sóniga ehweh atowana meyo inínká mi ehwéhnsábé ayehitónsabe Sóni abiahnsa atowe. Abiahnsa atowana Érótiga, Sóni táhtoqme karábúsiipéq móátáhro úwara táhtoqme karábúsiipéq móátówe. ");
INSERT INTO awb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Móátówana Érótiga, Sóni subiq suaníe íwíáhéna túbáh agúwe. Wehukega, Sóniwe Manikáne ehweh irari aní míre íwíáhunsabé sensabé áhreéna túbáh agúwe. ");
INSERT INTO awb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Érótine anowagá we maqmio ahreraq ko tanáhráq sútaq wereq máhoro ú kereqka táhutahuruwana Éróríásane ayahunkawagá mitaq ména ábáhrúwe. Ábáhrúwana Érótiga iwíáh íwíáhéna wensabé, ");
INSERT INTO awb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Arega nánio ina naneq náwiníe éna, Pópoqnahga tagaríéhtáq awinauge úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mi ahráríné anowagá Sóninsabé abiahnsa atena weniyahu pagu pagunúwana wega Érótinsabé, Íné Sóni wání meri merini aníné ayahqno kiraqsuq maqme kunubaipéq maqme ménio úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Úwana Érótiga mi ehwéh irotaq wene arupipeq umeh agúwe. Pópoqnahga tagaríéhtáq awinauge ú púana wene arupipeq iwíáh kikiruwe. Ínéreq táhutahuro kegá néne ehweh íráh púana niyehitéhneho éna, We awahbeh naneq náwéro úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","We awahbeh naneq náwéro úwana Érótiga eqmaq auwo aninká karábúsiipéq tunse Sónine ayahqno kiraqsuena kunubaipéq maqme mewe séna ");
INSERT INTO awb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mi ahrárí awuwana wenano móawuwe. ");
INSERT INTO awb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sóni kéró kega we subiq súó ehweh irera sure wene anonka sesehgiwera mómaisarera Sísa koreawúwe. ");
INSERT INTO awb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sóni subiq sutowana Sísaga irena mitaq suena sípi kéwewena kure abatapi pokinaúwe. Áhnte kegá, We seberaebéq pokire u irera sensuwahpeq suera peh marakóipeq pehbeheráh kure Sísa kinaúrabeq kuwe. ");
INSERT INTO awb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sísaga mitaq kure sípiipéqté arahwéraq tuegútaq áhnte wehekéq tagéna sensabé arutaboiraritena awahre ke kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Íó tupekinaútaq ite we kérahwána kegá Sísaba séq wensabé, Amahnága penkinaire. Mahtaq peh abatapi púah mah kegá mó ke suwahpeq sene táhutahuq kobaiqmaragéhboq eqmaq suo ewane. ");
INSERT INTO awb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ewanana Sísaga itensabé, Se aneqsabé pokigehbo? Itega táhutahuq kirabooro úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Úwaq, Ite íre áhnte tahutáhúq peh moberíáh párétíákáq téhtaré páhnkákáq matione ewanana ");
INSERT INTO awb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sísaga itensabé, Mina mewe sero úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mewe sero éna míó keyabé, Náweraq tútuue míáhro éna mi parétíákáq pahnkákáq mewena íópeq tagéna Manikánsabe, Kaweróne atowe. Kaweróne atena páréti keqme ite we kérahwána ke náiuwaq itega míó ke náriewáne. ");
INSERT INTO awb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Náriewánara ómiga nowana siyahbankirowe. Siyahbankirowara arahqmé airápété téhtaré páhsíkétí úsawe obenkíq márówe. ");
INSERT INTO awb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mi tahutáhúq no wehwé íregáritaq 5 táhúséni (5,000) weh wóe. Ani ahre áhnte míó púara íre sáhnsáhúwe. ");
INSERT INTO awb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sísaga ite we kérahwána keyábé, Sípiipéq kiasagoro seberaebéq ite nonótáh pokoro éna eqmaq iuwowe. Ite we kérahwána ke eqmaq iuwena anehe mó ke sensuwahpeq eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eqmaq suena púrerinieéna sáwéhrapeq kiuwe. Penkútaq Sísa webataq ména ");
INSERT INTO awb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","púrerúwaq ite we kérahwána ke sípiipéq káwehu ákáhpi míahwane. Anotah soírírúwana wánínka nonaburóróúwana mi sipí íre peheráh korahúwe. ");
INSERT INTO awb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ahyahbinkerotaq Sísaga wání abobóráhtaba iteba súwaq ");
INSERT INTO awb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","we tagéq anotah ahrééq, Wahnsa wíre íwíáhéq áhreéq kareowanae. ");
INSERT INTO awb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kareowanana Sísaga apubúue mahraréna, Pehitaq míáhro. Íné úge. Íre áhreoro úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Úwana Pítaga wensabé, Néne Wahnahno, aiq pútaq are inaraqmé ínénsabe, Wání abobóráhtaba noge ínéba súno ainto úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ínéba súno ainto úwana Sísaga wensabé, Máho úwana Pítaga sípiipéqté tuegue wánítaba Sísaba áhníbórá kúwe. ");
INSERT INTO awb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Áhníbórá kéna sóiriq tagéna áhreéna wánípipeq tupekinaútaq Sísansabé, Néne Wahnahno, íné séhréh ainto éna áwíahraq súwe. ");
INSERT INTO awb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Áwíahraq súwana Sísaga apubúue tubanantáwena wensabé, Arega ínénsabe íre kawerue aiq pútare aintahne. Aneqsabé árahinabomo íwíáhono úwe. ");
INSERT INTO awb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sega sípiipéq kiasaguyana sóiriq táqnáigúwe. ");
INSERT INTO awb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ite sípiipéq míahwana kegá Sísansabé iwíáh íwíáh ateq, Are aiq pútaq Manikáne ahninkáwá wóne atahwáne. ");
INSERT INTO awb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Itega sípiipéq seberaebéq kure Kénésáréti marákórápéq kowanara ");
INSERT INTO awb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","mitaq míó kega Sísa tagéra, we Sísae uwe. Sísae éra, Awahre ke mitaq meriq mahtaq merirue sero uwara moke awahre ke meriqmera Sísaba mórítówe. ");
INSERT INTO awb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Awahre kegá Sísansabé, Arene ambanta ayehrápéq táhtoranéhnkono éra wene ambanta táhtoró ke ómi kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Péhrasi kereq Mósísine ehweh síwáhnoro kereqka Sarúsarama suwahpeqte Sísaba sure wensabé, ");
INSERT INTO awb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Are kéráh kégá iteinahbúréhne sansámé aneqsabé anteruaho? Sene siyahnkara íre pabeq paberia peh náwíqkakaq síyáhnkárátáté táhutahuq nahwe uwe. ");
INSERT INTO awb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Uwana Sísaga sensabé, Itewe aneqsabé peh iteitene sánsá sehgioneheéq Manikánka sehgíóro ú ehweh anetaníbo éq anteruaho? ");
INSERT INTO awb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Manikáne ehwehnka mahraréna, Iteinoibone ehweh ireq se séhréh arítáhro ire. Mi ehwéhnká mó mahraréna, Wenanoibonsabé íre kaweq ehwéh arítéh ání subiq súáhro ire. ");
INSERT INTO awb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Manikáne púkuga miraue irariraq itega síwáhnoréq, Wehukenínká wenanoibo séhréh aritahráhi monébópoq mó naneqpopoq matawéna wenanoibonsabé mahraréna, Mahnawé Maniká íre áwátáutaq tahirímé náíú irino ire. ");
INSERT INTO awb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wehukenínká miraue irariraq itega, Mi anínká wenanoibonsabé anetaníbo ime aiq kawerire ewe. Wega se íre séhréh arítéhmé aiq kawerire ewe. Minayabe iteitene ehweh sehgiónsábé Manikánka sehgíóro ú ehweh anterúáhwe. ");
INSERT INTO awb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Itewe peh kopéráhpéro ahbabáq ke woe. Itega miraonsabé Manikáne ehweh irarú ani Áísáíaga naho sehiranú ehwehnká aiq pútaragire. Mi ehwéhmé Manikánka irarú ehweh Áísáíaga sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mah kegá ínénsabe síwéhrate iwíáh íwíáhéra peh sirupipeq ínénsabe íre suwahbehre. ");
INSERT INTO awb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sega peh wehukene sánsá síwáhnoréra, Mahnawé Manikáne sansá míre ewe. Minayabe sega ínénsabe péhepehe iwíáh íwíáh aintáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sísaga míó keyabé, Ínéba sewíáhro. Néne ehweh ireq iwíáhue tagahro. ");
INSERT INTO awb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wehukenínká táhutahurinka íre ahbabáratéhre. Írakaumo. Peh morá wehukeníné áwéhipeqté éhwéhnká ahbabáratéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ite Sísa kérahwána kegá weba séq wensabé, Arega iraréna ehwéhnká Péhrasi ke siyehitehme aiq tagahno ewanana ");
INSERT INTO awb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sísaga itensabé, Íópeqté Náníbógá íre uqmaréh náneqme pagoruankéhe. ");
INSERT INTO awb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Péhrasi kewé pehragarítáhro. Sega iwíáhéra, Ite siyahnkahrúna ke úne ewe. Írakaumo. Se peh aura pira ké míáhwe. Aura pira ánínká mó aurá pira ání ahnkahrínaraq mataipéq moráráq inahnsuboyeherawoye úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Úwana Pítaga Sísansabé, Mah pabéqmé éhwéh pahsuqme teio úwana ");
INSERT INTO awb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","wega sensabé, Wehukenínká táhutahurinka íre ahbabáratanae uge. Mi ehwéhnume ite moq íre írátíaho? ");
INSERT INTO awb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Táhutahuqka wehukeníné iwíáhipeq íre túíre. Peh ahmbiupipéq tunse tueagire. Minawé íre iraho? ");
INSERT INTO awb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wehukeníné áwéhipeqté éhwéhmé wene arupipeqté áhwárehre. Wene arupipeqté íwíáhgá ahbabáratanae. ");
INSERT INTO awb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wehukeníné arupipeqté ahbabáq iwiáh áhwárehre. Mó aní subiq suewé, mó aníné ahre weh abariéwé, aebówé, péhe éhwéhmé éhruruéwé, ");
INSERT INTO awb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","mahnawarinká wehukení ahbabáratéhre. Peh náwíqkakaq áyáhtáté nehnka wehukení íre ahbabáratéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sísaga mitaq suena Táíya suwahpeqte kéreq Sáíróna suwahpeqte kéreqne marakórapeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mibeqté Kénáni marákórápéqté ínímé íre Asiu anínká Sísaba séna wensabé, Tébítine anahwao, anotah aní móne. Owainawanka nániyahu subiqmaq subiqmarinsabé arutaboirainto úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Arutaboirainto úwana Sísaga peh ehiya míowaq ite we kérahwána kegá Sísansabé, Mi inínká inehe séna áhnte ehwéhninsabé kaqsuo éq pagu pagunowane. ");
INSERT INTO awb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pagu pagunowanana Sísaga mahraréna, Manikánka peh morá Ísara kebá eqmaq núwátáire. Ísara kewé tabanagi sipísípíq tahnsa kee úwana ");
INSERT INTO awb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","mi inínká Sísaba séna áhtónsabe wene aigárápí arehunseraráq ména, Anotah aníno, séhréh ainto úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Séhréh ainto úwana Sísaga wensabé, Animáríné táhutahuq mewe iamárípá tuparuewé íre kaweq sansáne úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Úwana wega Sísansabé, Anotah aníno, arega irarénawe aiq pútaróne. Iamárínká sibowáné tahbe tehnopeqte megi apípí mewe nahtaq sibowágá íre kaqsúéhre. Mina inserah séhréh ainto úwana ");
INSERT INTO awb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sísaga wensabé, Arega ínénsabe anotahtaq aiq pútare aintahna iní móne. Are awahbeh naneq mirainauge úwana mi tanáhráq wene ayahunkawa apubúue kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sísaga mitaq suena Kehrari kawéhú ayehráq kure sáwéhrapeq kiena mitaq tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tútuue míowara áhnte kegá aigárá soriqnah kereq aura pira kéreq sawenkahnia áíyáyáhnkákáq kéreq íre ehwehnorahu kereq áhnte mó awahre kereq meriqmera Sísaba suwana wega moke mi awáhré ké kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ehweh íre irarerahu kegá ehweh iraruwara sawenkahnia áíyáyáhnkákáq kégá awaho ke úkuwara soriqnah kega ah nogúwara aura pira kégá siura ebíúwara tago kegá áhtenuwe. Áhtenéra ite Ísara kené Manikánsabe iwíáh íwíáh atówe. ");
INSERT INTO awb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sísaga ite we kérahwána ke íáhrabéna itensabé, Mahtaq míáh kégá ínéba apahtáró wéhékáh méra amahnága se táhutahuq íre kéhnsábé sensabé nirutaboiruge. Íre kirabo aritasa pehipi eqmaq súáhnaraq ahtapeq siunúnkaq surahiyeho. Pehipi íre eqmaq suaníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Úwaq ite we kérahwána kegá wensabé, Mahtaq peh abatapinirara míáh ké peh íregáritaq míáhwe. Se awehraq tahutáhúq nagehboq árahue áhnte tahutáhúq meyahráhuno ewane. ");
INSERT INTO awb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ewanana Sísaga itensabé, Árahue parétí kehro úwaq itega wensabé, Abapete téhtaré párétíákáq táhmaro pehgáriq pahnkákáq kéhre ewane. ");
INSERT INTO awb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sísaga weba sáhuríó keyabé, Marakóraq tútuoro éna ");
INSERT INTO awb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","mi abápété téhtaré párétíákáq pahnkákáq mewena Manikánsabe, Kaweróne atena ite we kérahwána ke keqme iuwaq itega moke mó ke náriewáne. ");
INSERT INTO awb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Náriewánara ómiga nowana siyahbankirowe. Siyahbankirowara arahqmé abapete téhtaré páhsíkétí úsawe obenkíq márówe. ");
INSERT INTO awb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mi tahutáhúq no wehwé 4 táhúséni (4,000) weh wóe. Ani ahrewe peh áhnte míó púara íre sáhnsáhúwe. ");
INSERT INTO awb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Siyahbankirowana Sísaga mi ke eqmaq suena sípiipéq kiasague Mágára marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Péhrasi kereq Sáyúsi kereqka Sísaba séra wega ahbabárinkeheéra wensabé, Manikánka are séhréh atahna taganehboq íópeqté ótaq sansánúno uwe. Ótaq sansánúno éra áhwárawe tagowe. ");
INSERT INTO awb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Áhwárawe tagowana wega sensabé, Íó tupekitaq penehriraq tagéq íre ibonsinawire ewe. ");
INSERT INTO awb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ahbiahipeq ibo muqmuriraq tagéq iboramé ibonsinawire ewe. Íópeq tagéq ibone sánsá ahtebahwe. Mina aiq ahtebéq peh ínéga amahnága mirau arámbéhrí tagéq íre ahtebahwe. ");
INSERT INTO awb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Amahnága oga míáh kégá Manikánsabe íre iuwahbehraq ahbabáq ke míáhwe. Ótaq sansá sokigi aio ewo? Írakaumo. Sóna sóreq wanípípéq míotaq Manikánka ótaq sansá miraúwe. Peh morá mi sansá iahreraq itahnaq iwíáhue tagagehe. Mó otáq sánsá íre sokigi ainíe éna se suena pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ite Sísa kérahwána kegá káwehu seberaebéq pokowanaraq páréti ibitagúwaq íre meyahwáne. ");
INSERT INTO awb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sísaga itensabé, Tagaríáhro. Péhrasi kereq Sáyúsi kereqne páréti muoráhi naneq pehragahro úwe. ");
INSERT INTO awb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Úwaq itega iteite náhenéq, Itega páréti ibitaginsabé mi ehwéh teíre ewane. ");
INSERT INTO awb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ewanana Sísaga itene ehweh ahtebéna itensabé, Ite páréti íre kéh éhwéhmé aneqsabé sío síoo? Itega ínénsabe pehgáritaq aiq pútare aintáhwe. ");
INSERT INTO awb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Amahnága teiú éhwéh íre iraho? Ínéga 5 táhúséni (5,000) weh moberíáh párétí keqme kirabourautaq arahqmé áhnte matome íre iahreraq kehro? ");
INSERT INTO awb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Abapete téhtaré párétí keqme 4 táhúséni (4,000) weh kirabourautaq arahq áhnte matome íre iahreraq kehro? ");
INSERT INTO awb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Íné íre párétiyabé iraruge. Minayabe árahinsabé íre iahtebaho? Péhrasi kereq Sáyúsi kereqne páréti muoráhi naneq pehragahro úwe. ");
INSERT INTO awb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Úwaq ite we kérahwána kegá iwíáhéq, Íre páréti muoráhi naneqsabé peh Péhrasi kereq Sáyúsi kereqka síwáhnoro ehwéhnsábé irarire éq iahtebahwane. ");
INSERT INTO awb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sísaga Sésáría Pírípái suwahpeq wahtotaq kútaq ite we kérahwána keyábé kasenéna, Mó kegá íné wehukení úku anínsábé inse aintaho úwe. ");
INSERT INTO awb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Inse aintaho úwaq, Arensabé mó kegá, Sóni wání meri merini aní míre ewe. Mó kegá, Are Éráísa wire ewara mó kegá, Are Manikáne ehweh irarú ani wenáwíq Sérémáía wire ewe. Mó kegá, Are peh Manikáne ehweh irari aní míre ewe ewane. ");
INSERT INTO awb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ewanana Sísaga itensabé, Itega ínénsabe inse aintaho úwana ");
INSERT INTO awb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sáímóni Pítaga wensabé, Manikánka ite meirena kaweraitankeheéna omaq ato aní móne. Maniká mía míai anínirah are wenahni móne úwe. ");
INSERT INTO awb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Úwana Sísaga Pítansabé, Sónine ahninkáwá Sáímónio, arega irarénayabé iwíáh íwíáhúno. Arega irarénawe peh wehukega íre iwíáh atáhwah iraréne. Peh morá íópeqté Náníbógá iwíáh atéhre. ");
INSERT INTO awb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Teiníboq írátíáhro. Arenáwíq Pítae. Wehukega ebahtaq pearáh náh íre míu míuia peh págegeue kagainserah íné tagaríáh kéwé séhréh aitahnaq págegeue mía míaigehe. Íné tagaríáh kégá pukirataq iraipéq íre pokigehe. ");
INSERT INTO awb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Íópeq Manikánka wahnah wahnahnirabeqte ónsáráté kí áwúge. Arega mah marákóípéq ahqáho atehna naneq Manikánka mi naneqsabé moq íópeq ahqáho atanae. Arega mah marákóípéq kowe atehna naneq Manikánka mi naneqsabé moq íópeq kowe atanae. ");
INSERT INTO awb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kowe atanae éna ite we kérahwána keyábé, Ínéwé Manikánka omaq ato aní míre mó ke teríyeho úwe ");
INSERT INTO awb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mi tanáhráq Sísaga ite we kérahwána keyábé Sarúsarama suwahpeq pukinaú ehweh pahsuowe. Wega itensabé, Sarúsarama suwahpeq pokinauge. Mitaq mibeqté Asiu kené aboawah wehreq Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka níwíoqnéra nubiq suaneherawoe. Nubiq suehrana íné pukéna apahtáró wéhékáhtáq iriwe oga úkinauge úwe. ");
INSERT INTO awb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Úwana Pítaga Sísa meqmena móbeq móatena wensabé ehweh atena, Néne Wahnahno, arega iraréna ehwéhmé aiq pútaragínehboq Manikánsabe ahqáho ato inauge úwe. ");
INSERT INTO awb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Úwana Sísaga pabeqme Pítansabé, Owainawano, móbeq míahno atena, Arega iraréna ehwéhmé Manikánka íre iwíáh atéhre. Minawé peh wehukeníné iwíáh púah íné pokona ah parosúéhneho úwe. ");
INSERT INTO awb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sísaga ite we kérahwána keyábé mahraréna, Íné sénireyabe awahbeh aníno, arerene awahbeh iwíáh suo. Manikáne arambehri mira aruqarurunsabé sega íné awankátaq táhparagéhe. Ínéga miraunserah miraue séniro. ");
INSERT INTO awb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wewensabé arutaboiréna peh wewene awahbeh iwíáh mira aruqaruri anímé oga mérapeq íre awaq miahráhire. Néne sánsá sehginieéna wewe awahbeh iwíáh susuri anímé oga mérapeq awaq miankéhe. ");
INSERT INTO awb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wehukenínká moke mah marákóípéqté ménsáméhnsá matíéhtáq tahirímé oga mérapeq íre awaq miahnaraqmé mi mensáméhnsánká árahue séhréh atéh iripo? Oga mérapeq awaq meyabe aneqtaté paiqmarankéhbo? Ahqáho. Íre paiqmarahráhire. ");
INSERT INTO awb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nánibone patahga tahnsa téhreh naneqkakáq íné wehukení úku anínseq íópeqté kéreqka túónagake moke mah kehiná kéhínáné arambehri iwíáhue tagéna sainsuanauge. ");
INSERT INTO awb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Teiníboq írátíáhro. Táhmaro iriwe míona ke pehipi íre pukigehe. Ebeqme íné wehukení úku aní Wahnah aní míahnaq tagéq anehe pukigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sísaga síwáhnorúwana abapete morá wéhékáh parabagúwana wega Sémísireq Sónireq mi abárahré mó aní Pítarerue meriqmena anotah sawéhrápéq kiuwe. ");
INSERT INTO awb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kiuwara sega tagotaq Sísane auranabiah mó kugú kaweq kugú agúwe. Wene auranabiah patahga tahnsa agúwana wene korósi anotah tabérábé téhreh tahnsá úkúwe. ");
INSERT INTO awb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Téhreh tahnsá úkúwara Mósísireq Éráísareqka íópeqté tunse ábóraragéra Sísareq ehwehnuwe. ");
INSERT INTO awb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ehwehnuwana Pítaga Sísansabé, Itene Wahnahno, ite mahtaq míonayabé aiq kawerire. Are awahbáhnaraqmé ínéga apahtáró úqná pearaníe. Arene morá Mósísine morá Éráísane moráue pearaníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pearaníe útaq anotah tabérábé írábúyánká seubítíowana mipéqté éhwéhnká mahraréna, Mah anímé niruní nénáhní míre. Íné wensabé anotah nuwahbehre. Wene ehweh íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Úwara Sísa kéró anítógá anotah ahrééra sirehunseraráq méra siuranabiah marakóiperatíówana ");
INSERT INTO awb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sísaga seba séna se táhtotawéna sensabé, Íre áhreoro. Irigoro úwara ");
INSERT INTO awb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","sega awahnkanéra mó ke íre tagéra peh morá Sísa webataq tagowe. ");
INSERT INTO awb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sáwéhrapeqté tuegutaq Sísaga sensabé, Iteiyuwanka tageh naneq amahnága mó ke teríyeho. Íné wehukení úku aní pukéna iriwe oga úkonaraq terigéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Úwara we kéró anítógá Sísansabé kasenéra, Mósísine ehweh síwáhnoro kegá, Éráísa ebeq sínaraq anehe Manikánka omaq ato aní anehe sinae eme aneqsabé irareo uwe. ");
INSERT INTO awb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Uwana Sísaga sensabé, Éráísaga moke náneq kaweratanieéna suraire. ");
INSERT INTO awb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ínéga teiníboq írátíáhro. Éráísawe aiq suraire. Wega suraitaq we tagaro kegá, We Éráísa wire íre iwíáhia peh seye suwahbarai sansánurowe. Seye suwahbarai sansánéra we íre kaweratárówe. Sega we áwíoqnaronserah íné wehukení úku aní moq níwíoqnagehe ");
INSERT INTO awb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","úwara we kéró anítógá ahtebéra, Sísaga irarime Sóni wání meri merini anínsábé irarire uwe. ");
INSERT INTO awb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sega áhnte ke míópi tueguwana mó anínká Sísaba séna we áhtónsabe arehunseraráq ména wensabé, ");
INSERT INTO awb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Anotah aníno, nénahninsábé arutaboirate séhréh ato. We uwoyansanéna iraipéq tabiqme tabiqmeéna anotah erirana wánípipeq aguaguire. ");
INSERT INTO awb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Meqmena are kéráh kébá móátóge. Móátógarawe sega íre kaweratahráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Íre kaweratahráhowe úwana Sísaga míó keyabé, Ite íre aiq pútare ainteq saiyo ke wóe. Iteba mía míaume ahkake awehraq kanabo? Itega miraonsabé nirupipeq umehime ahkake parabaginabo? Ahkake parabaginabo éna abowansabé, Arenahni ínéba meqme súno úwana meqmena súwana ");
INSERT INTO awb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sísaga owainawansabé, We auwe pokúno atowana auwena pokútaq mi aní kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ite we kérahwána kegá itebataq Sísaba séq wensabé, Itewe árahinsabé owainawa íre kaqsuahráhuno kasenowane. ");
INSERT INTO awb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kasenowanana itensabé, Itega pehgáritaq aiq pútare aintáh púaq íre kaqsuahráhowe. Teiníboq írátíáhro. Manikánka séhréh aitahnaga miraorahúne íwíáhirataq wega séhréh aitéhnká miraorahowe. Téhwe mi iwíáh pehgáriq awánká ayu tahnsá kahnaraq itega sáwéhyabe, Móberagúno atéhrataq mirainawire. Mira íwíáhirataq áhnte pagégé sánsá miraorahowe. ");
INSERT INTO awb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ínéga kaqauwó ówáínáwá wehukega pehipi íre kaqsuahráhowe. Táhutahuq awehriéq púrerareq mina tahnsa owáínáwámárí kaqsuahráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sísareq ite we kérahwána kereqka Kehrari marákórápéq nowánaraq wega itensabé, Sega íné wehukení úku aní móintehrara nubiq suaneherawoe. ");
INSERT INTO awb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nubiq suehrana íné pukéna apahtáró wéhékáhtáq iriwe oga úkinauge úwaq ite we kérahwána kené irupipeq umehagúwe. ");
INSERT INTO awb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sísareq itereqka kure Kápénéáma suwahpeq kowanaraq Asiu kené momiwí nahtápéqté wáhnáhnká Pítaba séna wensabé, Ite íwáhnori anínká momiwí nahtápéq táhkísi moné awinkéhbo úwana ");
INSERT INTO awb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","kowe úwe. Kowe éna nahupeq kibekúwana Sísaga wensabé ebeq kasenéna, Sáímónio, mah marákóípéqté wáhnáh kégá inseréhne táhkísi moné meyaho? Sensuwahrahne móne meyaho? Mó kahnáhné móne meyaho? Inseréhne meyáhwe íwíáhono úwana ");
INSERT INTO awb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pítaga wensabé, Mó kahnáhné móne meyáhwe úwana Sísaga wensabé, Minayabe ite Maniká kahnah míoya puata wene momiwí nahtápéq kawerinkeheéta táhkísi moné íre náwéyataq tahirí aiq kaweri irino. ");
INSERT INTO awb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sega itensabé abiahnsa aitéhboq pehipi aweyéhe. Mi tahkísí móné meyankéhboq arega wání káwehutapeq pokue úku wánípipeq tuparuqme tagehnana téh pariahna pahné áwéhipeq tagé mipéq ebah moné tagankehe. Minawé arereq ínéreqne táhkísi moné awehraq kanae. Mina mewe táhkísi moné meyéh ání móawo úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mi tanáhráq ite we kérahwána kegá Sísaba séq wensabé, Íópeq Manikánka wahnah wahnahnirabeq kiotaiki anímé insebo ewane. ");
INSERT INTO awb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ewanana Sísaga káriq aní áhrabéna ite ákáhpi atena ");
INSERT INTO awb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","itensabé, Teiníboq írátíáhro. Itene píribahri sansá sueq káriq aní tahnsa úkirataq Manikánka wahnah wahnahnirabeq kioráhowe. ");
INSERT INTO awb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wewensabé íre iwíáh íwíáhi aní peh mah karíq ání tahnsa ména íópeq Manikánka wahnah wahnahnirabeq mó ke kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ínénsabe arutaboiraintena mahna tahnsa káríq ání séhréh atéh ánínká íné moq séhréh aintéhre. ");
INSERT INTO awb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Sísaga mó mahraréna, Wehukenínká ínénsabe aiq pútare aintéh ání ahbabáq sansa áúgi ínaraqmé anotahtaq íre kawerire. Áúgii anínká káriq aní áúgi ínaraqmé wene anuopi anotah ebáh táhru táhruue púrúrúia káwéhúpípéq tuparuahnana wánípipeq tupekitaq tahirímé aiq kaweri irino úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Síúgio kewé anotah ahbábárowe. Mah marákó márákóípéq ahbabárorahi sansá peh kagaire. Áúgi anímé ahbabáq áhwáreh puana Manikánka anotahtaq kamah awinawire. ");
INSERT INTO awb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Arene aiayahnka are ahbabáratana ínaraq mina kiraqsuo. Íre aiayahnkakaq oga mérapeq pokinaraq aiq kawerinae. Moke aiayahnkakaq ahriahri teh iráípéq kaqauwáhnaraqmé anotah íre kawerinawire. ");
INSERT INTO awb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Arene auranka are ahbabáratana ínaraq mina piruqme suo. Peh morá áúránkákáq oga mérapeq pokinaraq aiq kawerinae. Téhtaré áúránkákáq ahriahri teh iráípéq kaqauwáhnaraqmé anotah íre kawerinawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Sísaga mó mahraréna, Káriq anímárínsábé abehq náneq mire íwíáhiyehboq kawerurero. Teiníboq írátíáhro. Se wahnahno íópeqté kégá íópeq Nánibo míéhrabeq ahriahri mía míaowe. Íné wehukení úku anínká tabanago ke kaweraritanieéna suge úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sísaga mó mahraréna, Sipisípiq wahnahni anínká áhnte sipísípíq 100 sipísípíq matíéhtáq peh morá ká tabanagínaraq wega anerinkehbo? Aneq iwíáhoo? Wega íre tabanago kamárí 99 sipísípíqmárí uwaruntú sahtaqme nahrabeq sitena tabanagi ka kogabarinkehe. ");
INSERT INTO awb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi ka ábóraq marahnaraq iwíáh íwíáhinawire. Íre tabanagi kamárínsábé ákáhtaq iwíáh íwíáhéna ábóraq maréh kánsábé anotahtaq iwíáh íwíáhinawire. ");
INSERT INTO awb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sipisípiq wahnáhnká wene tabanagi kansábé arutaboirinserah íópeqté Ítéríbógá wene animárí tabanague iraipéq pokiyeho éna arutaboirire úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Sísaga mó mahraréna, Íné tagaríéh ánínká are ahbabáratahnaraq mó ke íre míéhrataq wene ahbabáqsabe koreawo. Wega arene ehweh irahnah aiq insahwé atankéhe. ");
INSERT INTO awb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Arene ehweh íre irahnaraqmé peh morá ánípópoq téhranítébópoq meriqme weba kúno. Itene ehweh irankéhboq se meriqme kúno. ");
INSERT INTO awb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wega arereq sereqne ehweh íre irahnaraqmé momiwíorabeq Maniká tagaríáh ké korerio. Wega moke sene ehweh íre irahnaraqmé we auwe nahnso aní, ahbabáq ani tahnsa peh áwé tagahro úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sísaga mó mahraréna, Teiníboq írátíáhro. Itega mah marákóípéq ahqáho atéhra naneq íópeq Manikánka mi naneq moq ahqáho atanae. Itega mah marákóípéq kowe atéhra naneq íópeq Manikánka mi naneq kowe atanae. ");
INSERT INTO awb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mó teiníboq írátíáhro. Ite téhranítégá mah marákóípéq mó naneqsabé moráénue púrerirataq íópeq Maniká Iteriboga irena mirainawire. ");
INSERT INTO awb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ite téhranítégábópoq apahránítógábópoq ínénsabe iwíáhoneheéq momiwíirataq íné itereq míanauge úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pítaga Sísaba séna wensabé, Néne Wahnahno, are tagaríéh ánínká íné mótaq mótarue ahbabáraintahnaraq árahue tanáhráq wene ahbabáq íre niahreraq matianinkono? Abapete téhtaréráq wene ahbabáq íre niahreraq matianinkono úwana, ");
INSERT INTO awb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ahqáho. Abapete téhtaréráq íre awehraq kéhre. Arega íre sáhnsahoráhóna tanáhráq wene ahbabáqsabe iwíáhineho. Wene ahbabáqmari íre ahreraq matiahno úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wene ahbabáqmari íre ahreraq matiahno éna, Teiníboq írátíáhro. Manikánka wahnah wahnahnirabeqte sánsámé mah marákóípéqté wáhnáhnká wene arambehrio ke miraurainserah sansáne. ");
INSERT INTO awb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mi wahnáhnká wene arambehrio kené sítáríarai moné kaweraritankehéna síáhraburaire. Anotah moné 10,000,000 Kína tahnsá átáríarai aní weba móátáráirana ");
INSERT INTO awb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","mi aníné átáríarai moné áhnte taqnobaguraire. Minayabe wene wahnahnka átáríarai moné meanieéna mahraréna, Moke we matíéh ménsáméhnsá paiqmareq mi moné náníéro. Mi anínseq wene ahrereq wene animárínseq paiqmareq mi moné náníéro urairana ");
INSERT INTO awb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","mi anínká weba séna áhreéna arehunseraráq ména, Ínénsabe arutaboirainte pehwehrue ainto. Arega íntáríahna moné moke awinauge urairana ");
INSERT INTO awb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","wene wahnahnka arutaboiratena mahraréna, Mi monéyábé anetaníbo éna, Pehipi soraq súáhro uraire. ");
INSERT INTO awb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Urairana mi anínká pokue áwáhu arámbéhrí ání wene móne táhmaro Kiná 10 Kína tahnsá átáríarai aní tagéna wene anuopi táhtotawéna wensabé, Ínéga átáríarau moné nánio uraire. ");
INSERT INTO awb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nánio urairana wega arehunseraráq ména, Ínénsabe arutaboirainte pehwehrue ainto. Arega íntáríahna moné mókake awinauge urairana ");
INSERT INTO awb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","mi ehwéh íre irasa karábúsiipéq móátáráire. Móatena, Moke nánínagake pugeq auwaníe uraire. ");
INSERT INTO awb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Urairara mó arámbéhrí kégá mina tagéra sirupipeq págege agurairara sega sene wahnah moke koreawátówe. ");
INSERT INTO awb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Koreawátówana sene wahnahnka wene arambehri anínsábé áhraburairana surairana wensabé, Arewe íre kaweq arámbéhrí ání móne. Arega ínénsabe arutaboirainto énana néne móneyabé anetaníbo éna íre ahreraq matíóge. ");
INSERT INTO awb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ínéga arensabé nirutaboiratónserah arewé árahinsabé áwáhu arámbéhrí ánínsábé íre arutaboiratahno éna anotah abíáhnsánuraire. ");
INSERT INTO awb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Abiahnsanéna mi aní meqmena karábúsiipéq móátáráire. Néne móne moke nánínagake pugeq auwaníe uraire úwe. ");
INSERT INTO awb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sísaga mah pabéqmé éhwéh parabaruena anehe Pítarehyabe, Íné tagaríéh ánínká ite ahbabáraitahnaraq itene irupipeq wene ahbabáq íre ahreraq matíáhro. Ahreraq matíéhrataq teawú wáhnáhnká miraurainserah íópeqté Náníbógá mina tahnsaninkehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sísaga mi ehwéh parabaruena Kehrari marákórápéq suena Sorana aroipéq seberaebéq Súría marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pokúwara áhnte kegá we kérówara mitaqté áwáhré ké kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Péhrasi kegá Sísaba séra wega ahbabáq ehweh irarinkeheéra áhwárawe tagéra kasenéra, Weh wewega iwíáhue wene ahre suewé mirao naneq sansápo uwe. ");
INSERT INTO awb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Uwana Sísaga sensabé, Manikáne ehwehnka mahraréna, Manikánka mah marákó márákó mirarotaq wega wehakaq ahreakáq mirarowe ire. ");
INSERT INTO awb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wene ehwehnka mó mahraréna, Minayabe o menáhwénká wenanoibone nahtapeq suena wene ahrereq moráráq mía míaigehe. Peh morá áníné áú tahnsa úkigehe ire. ");
INSERT INTO awb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Itega mi sehirámé íre sáhnsahwe tagaroo? Se peh morá ání tahnsa úkóyansabé se íre mó aní mó aní tahnsa méra peh morá ání tahnsa míagehe. Manikánka, Wehakaq ahreakáq moráráq mía míaotao aritonsabe wehga wene ahre súéhneho úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wene ahre súéhneho úwara Péhrasi kegá wensabé, Mósísine ehwehnka mahraréna, Wehga wene ahre kaqsuaníe ínaraqmé pépahqtaq sehiranue móawena kaqsuankéhe ire. Mósísiga mah ehwéh aneqsabé irarúwo uwe. ");
INSERT INTO awb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Uwana Sísaga sensabé, Itereq itene igaqnaréhreq saiyo ke míona puana Mósísiga mah ehwéh irarúwe. Manikánka téh wehuke mirarotaq mira íwíáh íre úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Teiníboq írátíáhro. Wene ahre íre ahbabáq ini míahnaraq awehkawagá pehipi kaqsuena mó ahré meyéhmé wega aiq ahbabárire úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ite we kérahwána kegá Sísansabé, Wehreq wene ahrereqsabé teienawe mahbiga ahre íre mera ahriahri peh míahnaraq aiq kawerire ewane. ");
INSERT INTO awb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ewanana Sísaga itensabé, Itega irare ehwéh moke mahbigaunká íre sehgioráhowe. Peh morá Manikánka omaq sitahna kegá sehgioráhowe. ");
INSERT INTO awb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mó mahbígáúnká ahre meyahráhowara mó mahbígáúnká ahre íre meyahráhowe. Móme sinowaréhga maqmíótaq sene sinonka íre kaweraguraire. Minayabe mi mahbígáúnká ahre íre meyahráhowe. Móme wehukega síwáhnta pirúáhwara ahre íre meyahráhowe. Mó mahbígáúnká iwíáhéra, Manikánka wahnah wahnahnirabeqte árámbéhrí kawerue sehgiunayabé amahnága ahre íre meyaneheqmúne ewe. Mah ehwéh sehgioráhi anínká irankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wene ayahnkaratáté táhtoqme púreraritankeheéra mó kegá káriq anímárí meriqmera Sísaba mórítówe. Mórítówaq ite we kérahwána kegá mórító keyabé suwehgu ariteq ahqáho aritahwánana ");
INSERT INTO awb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","mi karíq ánímárí ínéba sewíagehboq ahqáho arítého. Káriq anímárínká ínénsabe aiq pútare aintáh serahno kegá Manikánka wahnah wahnahnirabeq awaq miagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Awaq miagéhe éna Sísaga wene ayahnkaratáté mi karíq ánímárí táhtotawéna mitaq suena pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Peh morá wéhgá Sísaba séna wensabé, Íwáhnoraníno, oga mérapeq awaq mianíboq aneq kawéq árámbéhrí ininkono kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kasenúwana Sísaga wensabé, Aneqsabé ínénsabe kaweq sansánsábé kasenono? Peh morá ánínká webataq kaweqtaq mía míaire. Oga mía míainkehboq Manikánka sehgíóro ú ehweh sehgio úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Úwana wega Sísansabé, Aneq sehgíóro ú ehweh sehginínkono úwana Sísaga wensabé, Mó aní subiq súéhneho. Mó aníné ahre abariineho. Mó anínsábé péhe éhwéh atéhneho. ");
INSERT INTO awb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Iteinoibone ehweh ireq se séhréh arítáhro. Arerensabé arutaboirónanserah arene iyahnabo anínsábé moq arutaboirúno úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Úwana mi anínká Sísansabé, Moke mi ehwéh kawerue sehgíúge. Móme aneq arámbéhrí ininkono úwana ");
INSERT INTO awb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sísaga wensabé, Are kaweqtaq míankehboq pokue moke matiahna mensáméhnsá paiqmaqme móne mewe tabonah ke nário. Mirainaraqmé íópeq kaweq naneqmarí matiankehe. Tabonah ke moke nárie íné séniro úwana ");
INSERT INTO awb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","mi anínká irena áhnte mensáméhnsá ko púana wene arupipeq umeh agúwana pokúwe. ");
INSERT INTO awb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sísaga ite we kérahwána keyábé mahraréna, Áhnte mensáméhnsá matíáh kégá íópeq Manikánka wahnah wahnahnirabeq kieyabe anotah pagégéue mirao naneq mire. ");
INSERT INTO awb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Teiníboq írátíáhro. Kéhma anotah kane. Mi kanká wai abahrabahpipéq kéagínayabé págegeue mirai naneq mire. Mina inserah áhnte mensáméhnsá matíéh ánínká íópeq Manikánka wahnah wahnahnirabeq kinayabé anotah pagégéue mirai naneq mire úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Úwaq itega mi ehwéhnsábé anotah ahténéq Sísansabé, Minayabe insega oga mérapeq awaq miahráhiro ue kasenowane. ");
INSERT INTO awb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kasenowanana Sísaga ite ebitáwéna itensabé, Wehukega íre miraorahowe. Peh morá Manikánka moke miraorahire úwe. ");
INSERT INTO awb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Úwana Pítaga wensabé, Itega moke mationa naneq sueq are kérone. Minayabe itega aneq awaq mianéhnkono úwana ");
INSERT INTO awb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sísaga itensabé, Teiníboq írátíáhro. Mókake moke kéh náneq o naneq úkínaraq íné wehukení úku anínká págegeue anotah wahnáhnonarabeq tútuue ména wahnahninie. Mi tanáhráq itega wahnahnirarabeq tútuue méq airápété téhtaré Ísara ke káhnáhnsábé ehweh ariteq sainsuagéhe. ");
INSERT INTO awb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ínénsabe sirutaboiréra néne arambehri miraoneheéra sene nahme sene marakówé súáhmé amahnága áhnte mó nahmé marakówé awaq miagéhe. Mókake oga mérapeqkákáq awaq miagéhe. Néne arambehri miraoneheéra sinahnowarehwé siwahwarehwé sensibáqmarimé sensinoibowe sene animárímé súáhmé amahnága áhnte mó kegá sensuwahrah úkigehe. Mókake oga mérapeq moq awaq miagéhe. ");
INSERT INTO awb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amahnága áhnte ebeq se kegá mi tanáhráq sinehe kigehe. Sinehe se kegá ebeq kigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sísaga mó mahraréna, So wahnahnurai aní éhweh teiníe. Wega wahnahnurainserah Manikánka íópeq wahnah wahnahnire. So wahnahnurai anínká wene sotáq arambehrira ke ahbiahipeq kogabaréna ");
INSERT INTO awb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ábóraq marena sensabé, Néne sotápéq koarambehriirataq penahnaraq morá Kíná morá Kíná tahnsanue náiníe urairara kowe urowana wene sotápéq eqmaq súátáire. ");
INSERT INTO awb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pópoqnah ákáhtaq kiraitaq paiqnanátapeq kurairara táhmaro mó kegá mitaq peh míarowe. ");
INSERT INTO awb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Peh míarowana wega sensabé, Néne sotápéq koarambehriirataq penahnaraq awehraq apéq náiníe urairara ");
INSERT INTO awb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","kowe éra koarambehriurowe. ");
INSERT INTO awb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wéhékáhnabubunkakáq tunsoreráitaqkákáq wega mó ke ábóraq marena wene sotápéq eqmaq súátáire. ");
INSERT INTO awb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Íó tupekinauraitaq wega paiqnanátapeq kouwekurairara táhmaro ke mitaq peh míarowe. Peh míarowana wega sensabé, Aneqsabé moke wéhékáh peh míaho urairara, Mó anínká arambehri íre ínsábé peh míone urowana, Aiq míre. Néne sotápéq koarambehrioro arítáráire úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Koarambehrioro aritena petairabeq so aboga sotáq arambehrio kené wahnah anínsábé áhrabéna wensabé, Moke arambehrio ke síáhrabue ápeq nário. Arambehrirapéq sinehe se ke ebeq nárie ebeq se ke anehe nário uraire. ");
INSERT INTO awb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sinehe suro ke morá Kíná morá Kínáue síátáire. ");
INSERT INTO awb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Síátáirara ebeq suro kegá iwíáhéra, Wega métáq se ke morá Kíná morá Kínáue sínsábé ite anotah apéq meyaneheqmúne íwíáhurowe. Anotah apéq meyaneheqmúne íwíáhurowana se moq morá Kíná morá Kínáue síátáirara mewera ");
INSERT INTO awb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","so abonsabé abiahnsa atárówe. ");
INSERT INTO awb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Abiahnsa atera wensabé, Amahnága se kewé pehgáriq arámbéhríowe. Itewe moke wéhékáh arambehriúnana anotah patáhgá kamah aíre. Minayabe aneqsabé monseráh monseráhnue ápeq náiro urowe. ");
INSERT INTO awb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Úrowana so aboga sene ehweh irena peh morá ánínsábé, Néne iyahnabo aníno, arensabé íre ahbabáratóge. Ahbiahipeq, Néne sotápéq arambehri éwahnaraq morá Kíná awiníe ugah kowe aintahna wino. ");
INSERT INTO awb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Minayabe arene móne mewe pokúno. Are áwúnserahnue inehe se ke moq náríúge. ");
INSERT INTO awb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nénéne móne nárie sansá néne arambehri wire. Anehepeqte ké áhnte naríúnsábé ínénsabe abiahnsa aintahna mino uraire úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sísaga mó mahraréna, Pabeqme ehwéh teiúnserah sinehe se kegá ebeq kirarawe ebeq se kegá sinehe kigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sísaga Sarúsarama suwahpeqte áhtápéq kútaq ite we airápété téhtaré kérahwána ke itebataqsabé mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Teiníboq írátíáhro. Ite pokue Sarúsarama suwahpeq míáhnaraq peh morá ánínká íné wehukení úku aní Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqpa mónuankéhe. Mónuahnara sega íné, Subiq súáhro aritehrara ");
INSERT INTO awb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","nubiq suageheéra nahnso kebá mónuagéhe. Nahnso kegá niwiréh aintera sehikarankákáq áréti sahtáté nubiqmarera awankátaq táhparagéhe. Awankátaq táhparéhrataqmé íné pukonana apahtáró wéhékáhtáq iriwe oganúq intankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sébérine ahrega sene ahninkáwáráré meriqmena Sísaba séna arehunseraráq ména wensabé, Ínéga teawéna ehwéh miraúno úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Úwana Sísaga wensabé, Aneq ehwéh kehro úwana wega wensabé, Arega wahnah wahnahnónarabeq míéhnaraq nénahnité mó anímé arene ayah púpeq mó anímé arene ayahnaperue tútuue míagehe arito úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Úwana Sísaga mi abáráhréyábé, Itega mah ehwéhmé íre iwíáhóye. Íre iwíáhóye éna pabeqme ehwéh mahraréna, Ínéga no kahpúípéqté náneq itega moq nahrahoyo úwara sega, Aiq nahahúye uye. ");
INSERT INTO awb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Uyana Sísaga sensabé, Ínéga no kahpúípéqté náneq itega moq nayehetawoye. Peh néne niyah púpeqkakáq niyahnapeqkakáq tútuue míéhra ke omaq sitewé íre néne arambehri wire. Nániboga omaq sitéh ánítégá mitaq tútuue míayeherawoye úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Úwaq ite we kérahwána inayáhnkú kégá mah ehwéh ireq mi abáráhréyábé suwehgu aritahwáne. ");
INSERT INTO awb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Suwehgu aritahwánana Sísaga moke ite we kérahwána keyábé, Ínéba sewíáhro éna itensabé, Mah marákóípéqté sánsámé mó kegá sene ehweh sehgigeheéra wahnah kegá wahnahnarítáhwe. Sene anotah wehwárínká, Itene ehweh ireq séhgíóro éra págegeue wahnahnarítáhwe. Mi sansá aiq tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Itewe mi sansá íre oro. Ahqáho. Íné anotah aní míanie íwíáhi anínká wereq míáh ké séhréh aritankéhe. ");
INSERT INTO awb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Néne iyahnabone wahnah míanie íwíáhi anínká sene arambehriraq séhréh aritankéhe. ");
INSERT INTO awb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Íné wehukení úku anímé mó kegá íné séhréh aintageheéna tutaugo? Írakaumo. Ínéga mó ke séhréh aritanieéna tutauge. Áhnte ke oga míagehboq se merirena kaweraritanieéna pukinie úwe. ");
INSERT INTO awb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Itega Séríko suwahpeq suahwánara áhnte kegá Sísa kérówe. ");
INSERT INTO awb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kérówara aura pira ánítégá ahnayehráq tútuue méra Sísa kótaikire u irera anotah ehwéhnue mahraréra, Tébítine anahwao, arutaboiraito uye. ");
INSERT INTO awb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Uyara míó kega suwehgu aritera ehiya míáhtao arítówara sega íre túbáh agia peh mónkakáq anotahtaq iraréra, Tébítine anahwao, arutaboiraito uye. ");
INSERT INTO awb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Uyana Sísaga iriwe ména sensabé síáhrabéna, Aneraitanínkono úwara ");
INSERT INTO awb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","sega wensabé, Anotah aníno, iura kaweraito uyana ");
INSERT INTO awb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sísaga sensabé arutaboiraritena sene siura táhtorowara sega apubúue tagéra Sísa kéróye. ");
INSERT INTO awb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Itega Sarúsarama suwahpeq wahtotaq konehe owanaraq itega Óríwi sawéhrápéq kiowáne. Mi sawéhwé Páítápási suwahpeq wahtotaq kéhre. Mitaq kiowánaraq Sísaga we kéróya aníté eqmaq suanaútaq ");
INSERT INTO awb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","sensabé, Isebeq wahtotaq ke suwahpeq pokotao. Mitaq kirataq iyaráh kátáré, tónkiakáq wene áráhqkakaq tagéta pugeqme meqme setao. ");
INSERT INTO awb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pugeréhrataq mó anínká itensabé, Aneqsabé pugerehyo ínaraqmé, Itene Wahnah áhkokóue kinkeheéta meroye teawétao. Teawírataq wega apubúue, Meqme pokotao inkéhe éna eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Manikáne ehweh aiq pútaraginkeheéna Sísaga tónki kowerahtao éna eqmaq suowe. Manikáne ehweh irarú aninká naho sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Moke Sáíóna suwahpeqte ké korerieq mahrarero. Amahnága itene Wahnahnka iteba sire. We uwaresa ání míéhrana tónkiga áhkokóuena sire. We tónki áráhqne abobiahtaq tútuue míéhrana meqme sire koreríéro úwe. ");
INSERT INTO awb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mi aníté eqmaq suowara pokue Sísaga teriunserah ");
INSERT INTO awb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","mi katáré meriqme séra sene korósi mi kané abobiahtaq uwiq máróyana Sísaga mi tonkíné abobiahtaq kierútu agúwe. ");
INSERT INTO awb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Áhnte kegá Sísansabé iwíáh íwíáh ató púara sene korósi ahtapeq uwiqme abaeue móárówara mó kegá awanká ayahnawe apiwe ahtapeq awahrirarówe. ");
INSERT INTO awb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Awahrirarówara Sísareq moráráq ebeq ku kereq anehe ku kereqka anotah ehwéhnue mahraréra, Tébítine anahwansábé iwíáh íwíáh atone. Itene Wahnah áwírue si anínsábé iwíáh íwíáh atone. Maniká íópeq míéhraq wensabé iwíáh íwíáh atone uwe. ");
INSERT INTO awb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sísaga Sarúsarama suwahpeq kútaq ómi mibeqté kégá kurináhnéra áhnte ehwéhnéra, Mi anímé insebo uwara ");
INSERT INTO awb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sísareq su kegá, Mah anímé Manikáne ehweh irari aní wenáwíq Sísae. We Néhsara suwahpeqte Kehrari marákórápéqté áníne uwe. ");
INSERT INTO awb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq kibekéna mitaq paiqnanánu ke máhpeq kaqsuowe. Kaqsuena móne paiqnanánu kené wéhuwehu tahbéwárí pioruena kiboki paiqnanánu kené síahwarí paentárara aruowe. ");
INSERT INTO awb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Paentáruena sensabé, Manikáne ehwehnka mahraréna, Néne nahme púreré nahne ue áwíratagéhe ire. Itega miraonka mah nahmé aebó kégá mehwatíáhnserah nah úkire úwe. ");
INSERT INTO awb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aura pira kéreq soriqnah kereqka Manikánsabe iwíáh íwíáh atáh náhúpéq kibekéra Sísaba suwana kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kaweraritowara Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka Sísaga kawerarito arámbéhrí tagowe. Tagowara mibeqté káriq anímárínká mahraréra, Tébítine anahwansábé iwíáh íwíáh atone uwara irera mi kegá Sísansabé abiahnsa atówe. ");
INSERT INTO awb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Abiahnsa atera wensabé, Sega irare ehwéhmé aiq irahno uwara Sísaga sensabé, Aiq íróge. Manikáne ehwehnka mahraréna, Káriq anímárínseq inahunahnímárínseqka arensabé iwíáh íwíáh atáhwe ire. Itega mi ehwéhmé íre sáhnsahoo éna ");
INSERT INTO awb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","se suena Sarúsarama suwahpeq suena Pétáni suwahpeq kogauwe. ");
INSERT INTO awb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ahbiahipeq Sísaga Sarúsarama suwahpeq kouwekinaútaq ahtapeq ména arupibiúwana ");
INSERT INTO awb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","awanká tagówana awankánara sabátáhq koragówana íre serankakáq peh ánáh kowe. Awankánara írakaunúnsabe Sísaga mi awánkánsábé, Mókake sera íre iyaniewóne úwana mi awánká apubúue ehyatagúwe. ");
INSERT INTO awb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Apubúue ehyatagúwaq ite we kérahwána kegá tagéq kurináhnéq wensabé, Árahue apubúue ehyatagiro kasenowana ");
INSERT INTO awb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sísaga itensabé, Teiníboq írátíáhro. Itega árahinabomo íwíáh íre iwíáhia peh Manikánka mirainawire íwíáhirataq ínéga unserahnoneheqmóe. Íre peh morá mahna tahnsanigehe. Itega mi sawéhyábé teaweq, Saweho, arega mitaq sue anotah kawéhúpípéq kogahno teawírataqmé mirainawire. ");
INSERT INTO awb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Itega, Manikánka mirainawire íwíáhéq púrerirataq itega teawíra ehwéh irena mirainawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq kibekéna síwáhnorúwara Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqka weba séra kasenéra, Arega miraóna naneq árahinie miraono? Insega miraúno atáráiro? Teio uwe. Teio uwana Sísaga sensabé, Ínéga itensabé moq kaseninie. ");
INSERT INTO awb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ínéga kasenona ehwéh tenírataqmé ínénsabe miraúno aintárái aní teiníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Teiníe éna kasenéna, Sóniga wání meri merininkeheéna insega eqmaq áúwátáiro? Manikánka eqmaq áúwátáiro? Peh wehukega eqmaq áúwátóo? Teníéro úwe. Teníéro éna, Tenírataqmé ínénsabe miraúno aintárái aní teiníe úwara sega epéq sío síoéra, Anere teawenéhnkono? Manikánka Sóni eqmaq áúwátáire ue teawénaraqmé wega itensabé, Aneqsabé wene ehwehnsabé íre aiq pútare ataróo inae éra, ");
INSERT INTO awb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Itega wensabé, Wehukega Sóni eqmaq áúwátówe ue teawénaraqmé mahtaq sáhuríáh kégá, Sóniwe Manikáne ehweh irarurai aní míre íwíáho puara iubíyeho éra sío síouwe. ");
INSERT INTO awb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sío síoéra Sísansabé, Sóniwe insega eqmaq áúwátáiramo. Itega íre tagarione uwana Sísaga sensabé, Itega íné íre teníéwe. Minayabe ínéga moq ínénsabe miraúno aintárái aní íre teiníe úwe. ");
INSERT INTO awb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sísaga sensabé mó mahraréna, Ínéga teiéna ehwéh iwíáhue tagahro. Se ábárahréyábé teiníe. Sibowágá awahwánsábé, Iboramé néne sotápéq koarambehriúno atáráirana, ");
INSERT INTO awb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ahqáho. Nuwahriehre éna anehe mó iwíáhéna wenabone sotápéq koarambehriuraire. ");
INSERT INTO awb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sibowágá ábáqkawansábé monseráh éhwéh teawátáirana, Koarambehrinauge éna anehe íre koarambehriuraire. ");
INSERT INTO awb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mi abáráhrégá sibowá awahbarai iwíáh insega sehgirairo úwara sega wensabé, Awahwágáe uwe. Uwana Sísaga sensabé, Teiníboq írátíáhro. Aebó kéreq ahbabáq ininsónseqka Maniká awahbeh sansá sehgiera wega wahnah wahnahnirabeq ebeq kiraq ite sinehe kigehe. ");
INSERT INTO awb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sóni wání meri merini anínká iteba séna kaweqtaq mía míaorahi sansá sokigi aiátáiraq wensabé íre aiq pútare atárówe. Aebó kéreq ahbabáq ininsónseqka wene ehweh irera wensabé aiq pútare atera sene ahbabáq sansa sutowe. Sutowaq tagéq iteitene ahbabáq sansa íre susa mó iwíáh íre owe. Wensabé íre aiq pútare atárówe úwe. ");
INSERT INTO awb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sísaga sensabé mó mahraréna, Mó pabeqme ehwéh teiníboq írátíáhro éna, Anotah wehgá sonsoqme náhníáq sera ayu uqmarena wira arena wahnahnína uqná peataire. Pearena náhníáq sera ano kunubaipéq sarerankeheéna mata ubuqmarena mó keyábé, Néne sotáq wahnahnue náwe soqintewáhro aritena mitaq suena íre wahto wáhnaupéqté ké suwahqpeq pokuraire. ");
INSERT INTO awb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Náhníáq sera irái tanáhráq wene arambehri keyábé, Ákáhtaq koweyáhro éna se sotáq wahnahnuro kebá eqmaq súátáire. ");
INSERT INTO awb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Eqmaq súátáirara sotáq wahnahnuro kegá se táhtoqme mó aní subiqmarera mó aní subiq suera mó aní ebahnsa subiqme kaqsutowe. ");
INSERT INTO awb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kaqsutowana so aboga áhnte mó ke eqmaq sutairara sotáq wahnahnuro kegá téh eqmaq sutai ke íre kawerarítáró serahnurowe. ");
INSERT INTO awb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Anehe so aboga wenahni eqmataire. Eqmarena iwíáhéna, Nénahni púara sotáq wahnahnuro kegá wensabé áhtenéra wene ehweh iragéhe éna eqmataire. ");
INSERT INTO awb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Eqmatairana wahto kuraitaq sotáq wahnahnuro kegá we tagéra seye náhenéra, So abone ahninkáwá aiq sire. Mah so awaq mianéhboq we subiq suanéhe íwíáhéra ");
INSERT INTO awb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","we táhtoqme máhpeq móatera subiq sutowe. ");
INSERT INTO awb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Subiq sutonsabé so aboga sínaraq wene sotáq wahnahnuro ke anere aritankéhbo kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kasenúwara sega Sísansabé, So aboga kouwekínaraq mi ahbábáq ké kamah ariena subiq suanawire. Sera putáhnaraq wega kawerue náwíra ke wene sotáq wahnahnigeheéna eqsitankéhe uwe. ");
INSERT INTO awb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Uwana Sísaga sensabé, Manikáne ehwehnka ínénsabe mahraréna, Nah píáh kégá suto wahqká moke nahwiahnsanse kiotaikire. Itene Wahnahnka mirainsabé itega, Kaweq sansáne íwíáhúne ire. Ite Asiu kewé mi sehirá íre sáhnsahoo? ");
INSERT INTO awb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Teiníboq írátíáhro. Manikánka wahnah wahnahnirabeq itewe íre awaq mianeheqmóe. Wehukega so kawerue wahnahnéra kaweq tahutáhúq ísíwe sene wahnah áwíranserahnira kegá awaq miagéhe. ");
INSERT INTO awb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mi wahqtáq inahnsubíra kené siyahnsamé piteginae. Mi wahqká megue wehukení subinaraq wene ayahnsamé abiro abiro aginawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sísaga mah pabéqmé éhwéh irarúwara Manikáne ehweh mibeq mahbeq arítáh kéreq Péhrasi kereqka irera, Wega itensabé irarire uwe. ");
INSERT INTO awb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Uwara mitaq míó kega, Sísawe Manikáne ehweh irari aní míre íwíáhunsabé Péhrasi kereqka Sísa táhtoqme karábúsiipéq móataneheqmúne íwíáhéra míó keyabé áhreu puara túbáh aguwe. ");
INSERT INTO awb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sísaga mó pabeqme ehwéh mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Íópeq Manikánka wahnah wahnahnirabeq pokira sansámé anotah wahnáhnká miraurainserahne. Mi wahnáhné ahninkáwágá ahre meanauraitaq wenaboga wehekeq kiraboinieéna áhnte tahutáhúq kawerataire. ");
INSERT INTO awb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Táhutahuq kawerarena wene arambehri keyábé, Ínéga máhoro urau keyábé, Táhutahuq aiq téhre. Mahbeq sero koreríéro urairara koreríátówara sega íre surowe. ");
INSERT INTO awb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Íre suro puana wahnah anínká mó arámbéhrí kéyábé, Mi ke mónkakáq koreríéro. Sensabé mahrarue korerieq, Káhoakáq áráhqkakaq subiqmarena tirúgana aiq téhre. Moke táhutahuq amahnága aiq kawerunsabé peheráh sero ue koreríéro éna eqmaq sutaire. ");
INSERT INTO awb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Eqmaq sutairara koreríátówara sega mi ehwéhnsábé anetaníbo éra seyene ahwiminurowe. Mó anínká wene sotápéq pokurairana mó anínká wene paiqnaná nahtápéq pokurairara ");
INSERT INTO awb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","mó kegá wahnahne arambehrio ke táhtoqme íre kaweraritera subiq sutowe. ");
INSERT INTO awb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Subiq sutowana wahnah anínká anotah abíáhnsánéna wene sóntía ke eqmataire. Eqmatairara sóntía kegá subiq suto ke subiq suera sene nahmarí kekirutowe. ");
INSERT INTO awb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kekirutowana wahnah anínká mó arámbéhrío ke síáhrabéna sensabé, Nénahni ahre meyéhnsábé táhutahuq kawerarena síáhrabu kegá abehq sánsánonsabé ahqáho arítóge. ");
INSERT INTO awb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Minayabe wahba áhtápéq pokue moke tagehra keyábé, Táhutahuq kowe nagehboq máhoro arítáhro urairara ");
INSERT INTO awb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","wahba áhtápéq pokue moke tagaro ke meriqmera surowe. Kaweq kereq ahbabáq kereq meriqmera surowana wahnahne nah kígíuraire. ");
INSERT INTO awb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kígíurairana wahnah anínká meriro ke koragéna pahouwiuro awahriq ambántá íre awahriria surai aní tagówe. ");
INSERT INTO awb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tagéna wensabé, Árahinsabé awahriq ambántá íre aneranerue suria pehipi seno uraire. Urairana mi anínká íre ehwehnorahurairana ");
INSERT INTO awb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","wahnah anínká wene arambehri keyábé, Mah aníné aiayah táhru táhruue máhpeq sunkíkírirabeq tuparúáhro. Mitaq sunkíkírirabeq moke míáh kégá anotah ibiséra uwo uwo urowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sísaga mó mahraréna, Mah pabéqmé éhwéh áwahe íráhro. Manikánka íregáritaq keyábé, Máhoro irara áhnte kegá, Iuwahriehre e puana wega peh táhmaro omaq sitéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Úwara Péhrasi kegá móbeq pokue sío síoéra, Sísaga ahbabáq ehweh irarinkehboq áhwárawe tagéq aneq pagégé éhwéh kasenonehnkono éra iwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Iwíáhéra táhmaro se kéró kereq Éróti kahnáh kéreq Sísaba eqmaq suowara kure Sísansabé, Anotah aníno, ite tagarionawe arewe aiq pútaq ehwéh iraréna aní móne. Arega anotah kereq pehgáriq kereqsabé peh monseráh íwíáhóne. Arega wehuke íre ehnenia peh Manikáne sansá ahriahri tábúsoqme pahsuqme íwáhnoróne. ");
INSERT INTO awb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Minayabe ite iahtebanehboq teio. Aneq iwíáhono? Itega Aroma kené wahnah aní Sísáhri táhkísi moné awenéhnkono? Árahonehnkono? Arega iwíáhóna ehwéh teio uwe. ");
INSERT INTO awb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Teio uwana Sísaga sene sirupipeqté áhbábáq íwíáh tagéna sensabé, Itewe kopéráhpéro ke wóe. Aneqsabé áhwárawe tagéq níwíoqnaho? ");
INSERT INTO awb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Táhkísi ira moné teníéro úwara sega peh morá ébáh móné ábóraq márówe. ");
INSERT INTO awb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ábóraq márówana Sísaga sensabé, Mah monéráq píkísahakáq áwíqkakaq insene kehro úwara sega wensabé, ");
INSERT INTO awb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aroma kené wahnah aní Sísáhrinee uwe. Uwana Sísaga sensabé, Aroma kené wahnahne náneq wewe náwéro. Manikáne naneq wewe Maniká náwéro úwe. ");
INSERT INTO awb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Péhrasi kega wene ehweh írótaq áhtenéra we auwera pokuwe. ");
INSERT INTO awb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sáyúsi kewé pusa ké íre iriwe oganúq sitankéhe íwíáhu kee. Mi wehekáh táhmaro mi kegá Sísaba séra wensabé, ");
INSERT INTO awb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Íwáhnoraníno, Mósísine sehiranka maharéna, Íre aninkákáq wéh pukínaraq wenábáqka kéweiní meyankéhe. Mi inínká maqmarahna anímárí wenawahne animárí míageheéna meyankéhe ire. ");
INSERT INTO awb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Minayabe abapete téhraníté se ábárahnahnah iteba míarowe. Sensuwahga ahre mewena íre aninkákáq uraitaq pukuraire. ");
INSERT INTO awb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pukurairana náhmbáh 2 abaqkáwágá awahwáné kéweiní mewena íre aninkákáq uraitaq pukurairana náhmbáh 3 abaqkáwága moq monseráhnuraire. Moke mi abáráhnáhnahnka mi iní mótaq mótarue mewera íre aninkákáq urotaq orah animárí pukurowana ");
INSERT INTO awb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","sinehemé mi iní moq pukuraire. ");
INSERT INTO awb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Moke mi abáráhnáhnahnka mi iní meronsabé iriwe oganúq sitahnaraq insene ahre míanabo kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kasenuwana Sísaga sensabé, Itewe Manikáne púkuipéqté séhíránkákáq wega págegeue miraorahi sansánkákáq íre ahtebah puaq áhwára áhwára ahbabáq iwiáhowe. ");
INSERT INTO awb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Manikánka pusa ké iriwe oganúq sitahnaraq se peh íópeqté ké tahnsa mía míaigehe. Mi tanáhráq wehga ahre íre meyagéhe. Ahrega íre wehkigehe. ");
INSERT INTO awb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pusa ké iriwe oganúq sitahnayabé Manikáne púkuipéqté séhírámé íre sáhnsahoo? ");
INSERT INTO awb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Wene ehwehnka ite teiena, Íné Ébáráhmane Maniká múge. Íné Áhísáhkine Maniká múge. Íné Sékópane Maniká múge ire. Manikámé íre pusa kéné Manikáne. Írakaumo. We peh oga míáh kéné Maniká míre úwara ");
INSERT INTO awb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","mitaq sáhuríó kega mi ehwéh irera áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sísaga irarúnka Sáyúsi kegá ehiyansá aguwara Péhrasi kegá irera momiwíéra Sísaba suwe. ");
INSERT INTO awb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Suwana peh morá Péhrasi aní, Mósísine ehweh síwáhnoru anínká Sísaga ahbabáq ehweh irarinkeheéna áhwárawe tagéna kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Kasenéna, Íwáhnoraníno, sehgíóro ú ehwehmé aneq ehwéhnká mó ehwéh kiotaikiro úwana ");
INSERT INTO awb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sísaga wensabé, Kiotaiki ehwéh teaweníboq iro. Maniká itene Wahnahnsabé arutaboirúno. Moke arene arupipeqkákáq moke arenawankakáq moke arene iwíáhónaipéqkákáq Maniká itene Wahnahnsabé arutaboirúno. ");
INSERT INTO awb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mah ehwéhnká moke mó sehgíóro ú ehweh aiq kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mó kiotaiki ehwéh iro. Arerensabé arutaboirónanserah mó anínsábé moq arutaboirúno ire. ");
INSERT INTO awb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mah ehwéhtáré áwahe wíre. Moke Mósísine ehwehnkákáq Manikáne ehweh iraru kené ehwehnkakáqmé ábogehrapeqté éhwéh míre úwe. ");
INSERT INTO awb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Péhrasi kegá momiwíuwana Sísaga sensabé, ");
INSERT INTO awb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ite meirena kaweraintankeheéna Manikánka omaq ato anínsábé aneq iwíáhoo? We insene anahwa míanabo úwara, We Tébítine anahwa míanae uwe. ");
INSERT INTO awb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Uwana Sísaga sensabé kasenéna, Manikáne Awanka iwíáh atowana Tébítiga mi anínsábé, Néne Wahnahne atowe. Wega aneqsabé irarúwo? Manikáne Awanka Tébíti iwíáh atowana igonkó pukúípéq sehiranúwana mi ehwéhnká mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Maniká itene Wahnahnka néne Wahnahnsabé, Niyah púpeq tútuue míéhnaraq arene naruo saiqnariankehe atóge úwe ire. ");
INSERT INTO awb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Írátíáhro. Tébítiga mi anínsábé, Néne Wahnahne ato puana we árahue wene anahwa míanabo kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kasenúwara Péhrasi kegá Sísansabé mó ehwéh íre kasenuwe. Wensabé áhtenéra mó tanáhráq mó tanáhrárue mó ehwéh íre kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sísaga ite we kérahwána kereq weba sáhuríó kereqsabé mahraréna, ");
INSERT INTO awb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mósísiga naho síwáhnorúnserah wene ehweh ahtebah kereq Péhrasi kereqka wene ehweh íwáhnorowe. ");
INSERT INTO awb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Íwáhnorue teié éhwéh moke kawerue sehgíóro. Íwáhnoro ehwéh seyega íre sehgiro puaq sega mirao sansániyeho. Áhnte ehwéh iraréra seyega mi ehwéh íre sehgiro puaq mirao serahniyeho. ");
INSERT INTO awb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wehukenínká mó aní anotahtaq piahbiahratéhnserah Péhrasi kegá seyene íre sehgioráho ehwéh tei teinowe. Piahbiahratéh ánínká umehi naneq matíéh ání íre náwioréhnserah Péhrasi kegá teri terino ke íre séhréh aritasa peh áwé tagahwe. ");
INSERT INTO awb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kaweq sansá pehipi íre miraowe. Peh mó kegá tagageheéra miraowe. Manikáne ehweh pépahqtaq sehiranarera káriq pokísíípéq maqme mó kegá tagageheéra sene siyahnkaratáq sene siyehitaq táhpawe nogówe. Mó kegá tagéra sensabé iwíáh íwíáh aritageheéra íre wahto nahgáq sene korósiraq táhrarera aneranerue míáhwe. ");
INSERT INTO awb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sega táhutahururorabeq aboawah wehwárí tútuue míáhrabeq méyabe suwahbehre. Momiwí nahtápéq peh kaweqtapéq tútuue méyabe suwahbehre. ");
INSERT INTO awb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sega máhkétirapéq nogótáq mó kegá se mehweh ariteyabe suwahbehre. Mó kegá sensabé, Íwáhnoraníno ateyabe suwahbehre. ");
INSERT INTO awb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mó kegá itensabé, Íwáhnoro ke wóe aitého. Ite ábárahnahnah tahnsá míáhwana ite íwáhnori anímé peh morá áníne. ");
INSERT INTO awb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Marakóipeqté kéyábé, Nánibo wone arítého. Iteribo peh morá ánínéna íópeq míéhre. ");
INSERT INTO awb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mó kegá itensabé, Itene Wahnah mone aitého. Manikánka omaq into aní ínébataq itene Wahnah míóge. ");
INSERT INTO awb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ite míáhrabeqte kiotaiki anímé arene arambehri séhréh aitéh ání míankehe. ");
INSERT INTO awb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wenáwíq pankerena, Íné anotah aní múge i anímé pehgáriq aní míankehe. Wenáwíq íre pankerena peh uwaresa ání míahnaraqmé anotah aní míankehe. ");
INSERT INTO awb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Sísaga mó mahraréna, Mósísine ehweh síwáhnoro kereq Péhrasi kerero, kopéráhpéro ke míáh púana kamah ainawire. Mó kegá íópeq Manikánka wahnah wahnahnirabeqte áhtápéq kíyehoéq parosúáhwe. Ite mibeq kieyabe íre iuwahbehre. Peh mibeq kieyabe suwahbeh ke saiqnarítáhwe. ");
INSERT INTO awb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kopéráhpéro ke míáh púana kamah ainawire. Itega kéweinínsónsábé péhe éhwéh terieq sene ménsámehnsánkakaq sene nahnkakaq mewe meweowe. Mó kegá ite kaweqtaq míáh ké wóe igeheéq wehuke míáhtáq íre wahtotaq púreq aruqarurowe. Mirao puana Manikánka ehweh aritahna tanáhráq ite anotahtaq kamah ainawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Sísaga mó mahraréna, Mósísine ehweh síwáhnoro kereq Péhrasi kerero, kopéráhpéro ke míáh púana kamah ainawire. Peh morá ání ite kéíréh ání míankeheéq itega íre wahto ahtápéq pokue mó ke suwahpeq mó ke suwahperue pokue síwáhnoréq sóreq waní seberaebéq pokue síwáhnorurowe. Ite kéíréh ání úkitaq itega miraonka mi aníné ahbabáq itene ahbabáq kiotaikirana áhnte ahbábáq aruqarurire. Wereq itereq moráráq iraipéq pokoneheqmóe úwe. ");
INSERT INTO awb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Sísaga mó mahraréna, Itega mó ke ah sokigi aritaneheéq aura pira ké tahnsa míáhwe. Minayabe Manikánka kamah ainawire. Itega síwáhnoréq, Wehukenínká iraréna, Manikánsabe iwíáh íwíáh atáh náhnká tagaríéhtáq aiq pútaq mirainauge ínaraq anehe mi ehwéh íre sehginaraqmé anetaníbo ewe. Mi anínká iraréna, Manikánsabe iwíáh íwíáh atáh náhtápéq kéh mónégá tagaríéhtáq aiq pútaq mirainauge ínaraq anehe mi ehwéh íre sehginaraqmé we anotah ahbábárire ewe. ");
INSERT INTO awb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ite múguwahguo ke méq íre ireq peh aura pira ké tahnsa móe. Mi monéwé kaweqtapéq kéhnsábé kaweq naneq úkire. Minayabe Manikánsabe iwíáh íwíáh atáh náhnká mi moné aiq kiotaiki mino. ");
INSERT INTO awb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Itega mó síwáhnoréq, Wehukenínká iraréna, Titiré tahbégá tagaríéhtáq aiq pútaq mirainauge ínaraq anehe mi ehwéh íre sehginaraqmé anetaníbo ewe. Mi anínká iraréna, Titiré tahbéráq Maniká awe naneqka tagaríéhtáq aiq pútaq mirainauge ínaraq anehe mi ehwéh íre sehginaraqmé we anotah ahbábárire ewe. ");
INSERT INTO awb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ite íre ireq peh aura pira ké tahnsa móe. Titiré naneq kaweqtapéq kéhnsábé kaweq naneq úkire. Minayabe titiré tahbégá mitaq kéh náneq aiq kiotaiki mino. ");
INSERT INTO awb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Minayabe wehukenínká iraréna, Titiré tahbégá tagaríéhtáq aiq pútaq mirainauge ime wega íre peh morá mi tahbéyábé irarire. Wega moke tahberapeq kéh náneqsabéákáq irarire. ");
INSERT INTO awb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wehukenínká iraréna, Manikánsabe iwíáh íwíáh atáh náhnká tagaríéhtáq aiq pútaq mirainauge ime wega íre peh morá mi nahnsábé irarire. Manikánka mi nahtápéq mía míai puana wega irarime Manikánsabeákáq irarire. ");
INSERT INTO awb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wehukenínká iraréna, Íónka tagaríéhtáq aiq pútaq mirainauge ime íre peh morá íónsabe irarire. Manikánka mitaq íópeq tútuue ména wahnahni puana wega irarime wahnahni anínsábéákáq irarire úwe. ");
INSERT INTO awb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Sísaga mó mahraréna, Mósísine ehweh síwáhnoro kereq Péhrasi kerero, kopéráhpéro ke míáh púaq ite kamah ainawire. Moke itene sotápéqté ménsáméhnsá saraqme abapete itaréitaré tahnsa matawéq peh morá Manikáne arambehri mirao ke mewe síéwe. Kawerowe. Pehgáriq naneqmarí táwiomé, kímé, náwahbiame, moq saraqme síéwe. Kawerowe. Mi sansámé sehgieq íre súáhro. Peh kaweq sansámé mó keyábé irutaboirome Manikánsabe aiq pútare atáhmé mi sansámárí ite íre sehgíówe. Íre sehgíónsábé Manikánka kamah ainehboq mi sansámárínkákáq moq sehgíóro. ");
INSERT INTO awb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Itega, Mó ke ah sokigi aritaneheéq aura pira ké tahnsa míáhwe. Itega múguwahgui aní tahnsa míáhwe. Abehq náneq ka múguwahgui aníné né wanípípéq kéhrana wega anotahtaq éhnehéna mi pehgáríq ká súéhre. Mi pehgáríq ká suena anotah ka wenáwíq kéhma wene né wanípípéq kéhrana mi anotah kiotaiki ka íre tagéna pehipi nehre. Itega mi aní tahnsa míáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Sísaga mó mahraréna, Mósísine ehweh síwáhnoro kereq Péhrasi kerero, kopéráhpéro ke míáh púana kamah ainawire. Itega káhpuakáq párétahakáq pabeq paberotaq peh ábórapeq pabeq paberéq arupipeq íre pabeq paberowana peh náwíqkakaq mitaq kéhre. Mina onserah itene inonka pabeq paberowana itene irupipeqmé aebó íwíáhwé iteite iuwehbeh iwíáhwé peh mitaq kéhre. ");
INSERT INTO awb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Péhrasi keo, ite peh aura pira ké tahnsa móe. Káhpu arupipeq kawerue pabeq paberirataq mókake ábórapeqkákáq náwíq íre kanae úwe. ");
INSERT INTO awb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Sísaga mó mahraréna, Mósísine ehweh síwáhnoro kereq Péhrasi kerero, kopéráhpéro ke míáh púana kamah ainawire. Wehuke maisaráhtáq mó kegá kaweraráhwana kaweq matábú kéhrana peh maisia máípípéq wehukene ayahnsankakaq kambaresa náneqkakáq kéhre. Ite mina tahnsa ké míáhwe. ");
INSERT INTO awb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mó kegá ite tagéra, Kaweqtaq míáh ké wóe íwíáhowana peh itene irupipeq kopéráhpéq iwíáhákáq ahbabáq iwiáhákáq kéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Sísaga mó mahraréna, Mósísine ehweh síwáhnoro kereq Péhrasi kerero, kopéráhpéro ke míáh púana kamah ainawire. Itene igaqnaréhga Manikáne ehweh iraru ke subiq súówe. Subiq suera maisarówaq itega se maisarórabeq ebah mitaq pentabaráhwe. Kaweqtaq mía míauro ke maisarórabeq itega awahriraráhwe. ");
INSERT INTO awb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Itega mahraréq, Itene igaqnaréhga míótaq ite moq míahwanaraq tahirímé sega Manikáne ehweh iraru ke subiq súótaq se íre subiq suahwána irino ewe. ");
INSERT INTO awb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Itega mi ehwéh irareme Manikáne ehweh iraru ke subiq súó kene animárí múne ewe. ");
INSERT INTO awb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sene animárí méq itene igaqnaréhga áhwáro ahbábáq itega soruparowana anotah úkire. ");
INSERT INTO awb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wehene animáríno, ite moq wehemarí móe. Manikánka ehweh aitena sainsuahna tanáhráq, Iraipéqsábé iuwahriehre éq, Tabanagoneheqmúne íwíáhoo? Írakaumo. Mi tanáhráq ite íre tabanagorahowe. ");
INSERT INTO awb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Minayabe teiníboq írátíáhro. Manikáne ehweh irare kereq ahtebia kéreq íwáhnoro kereq iteba eqmaq suaníe. Eqmaq suahnara iteba sirataq itega táhmaro subiq sueq mó tahmáró awankátaq táhpareq mó tahmáró itene momiwí nahtápéq sahtáté subiqmareq kaqsueq mó ke suwahpeqte mó ke suwahpeqtenue kaqsuagéhe. ");
INSERT INTO awb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mirairataq kaweqtaq mía míaira ke subiq súéhra puana Manikánka kamah ainawire. Naho mío wehukéní Ábéri kaweqtaq mía míaúwana subiq suowana pukúwe. Pérékíane ahninkáwá Sékáráíae. Manikánsabe iwíáh íwíáh atáh náhúpéq titiré tahbé wahtotaq korabeq Sékáráía subiq súówana pukúwe. Téhwe Ábéri subiq suowara anehe áhnte mó ke subiq súówara sinehe Sékáráía subiq súówe. Moke mi ahbábáqmé iteba kagaire. ");
INSERT INTO awb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Teiníboq írátíáhro. Moke mi ahbábáq amahnága oga míáh kébá kagai puana minayabe kamah ainawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Sísaga mó mahraréna, Sarúsarama suwahpeqte kéo, itensabé nirutaboiraitóge. Itega Manikáne ehweh iraru ke subiq sueq Manikánka iteba eqmaro ke ebahnsatate subiq súówe. Kokórega wene áráhqmari arutaboiréna ahwirinserah áhnte tanáhráq ite wahnahnue séhréh aiteyabe nuwahbehraqme itega ahqáho aintáhwe. ");
INSERT INTO awb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Írátíáhro. Itega ahqáho aintáhnsábé Manikánka ite iuwena pokire. Iuwena poki puana iteruwahpeqme susa náh tahnsa kanae. ");
INSERT INTO awb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Teiníboq írátíáhro. Mókake itega íné pehipi íre tagagehe. Ebeqme mahraréq, Itene Wahnahne áwírue si anínsábé iwíáh íwíáh atone éq anehe íné tagagehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sísaga Manikánsabe iwíáh íwíáh atáh náhtáqté wíráípéqté tueyokúwaq ite we kérahwána kegá weba séq wensabé, Mah kawéq náhmárí tagáhno ewane. ");
INSERT INTO awb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ewanana wega itensabé, Amahnága itega moke mah kawéq náhmárímé aiq tahgahoo? Teiníboq írátíáhro. Mi peréhnéhnia ébáhmárí miraue moráráq íre kagainae. Peh moke paentárara aruaneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Óríwi sawéhrápéq Sísa tútuue míowaq ite we kérahwána kegá itebataq weba séq wensabé, Arega metaq irarénawe ahkake miraoneherabo? Mi tanáhráq itega ahtebanehboq mah marákó márákó parabagina ínaraq arega kiwekinie inaraqmé aneq ábóraraginabo kasenowane. ");
INSERT INTO awb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kasenowanana Sísaga itensabé, Mi tanáhráqsábé mó kené péhe éhwéhnsábé aiq pútare arítéhboq auráq matawéq tagaríáhro. ");
INSERT INTO awb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mi tanáhráq áhnte kegá mótaq mótarue néníwírue séra mahraréra, Manikánka wehuke merirena kaweraritankeheéna peh morá ání omaq atena eqmaq auwankéhe. Ínéwé mi aní múge irarirataq áhnte kegá sene péhe éhwéhnsábé aiq pútare aritagéhe. ");
INSERT INTO awb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi tanáhráq ebeho ehwéh ireq mó ebéhowe sóiriq ehwéh iragéhe. Íréhrataq íre áhreoro. Téhwe teiú náneq uméh ebeq sínana anehe tanahráqmé íre apubúue sinae. ");
INSERT INTO awb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mó kehinánseq mó kehinánseqka ebehoneherawoe. Mó wahnáhné awahrahreq mó wahnáhné awahrahrerue ebehoneherawoe. Mitaq mahtaq ehwehranae. Máríinae. ");
INSERT INTO awb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Moke minawarinká uwo uwoira tanáhráq áhwáranae úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Sísaga mó mahraréna, Mi tanáhráq mó kegá ite táhtoqme mó kegá subiq suageheéra meiqmera móitagéhe. Itega néne sánsá sehgíó púara mah kehiná kéhínánká itensabé íre suwahbanae. ");
INSERT INTO awb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mi tanáhráq áhnte kegá néne sánsá sinehepeq suera wensabé wensabé íre suwahbáhnaraq sene naruoba móruagéhe. ");
INSERT INTO awb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mi tanáhráq áhnte kegá, Íné Manikáne ehweh iraru aní múge éra péhenigehe. Péhe éhwéh irarirara áhnte kegá sene péhe éhwéhnsábé aiq pútare aritagéhe. ");
INSERT INTO awb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Miraue ahbabáq sansanká anotah ukína puara áhnte kegá sirutaboiré sansa suagéhe. ");
INSERT INTO awb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ite néne sánsá íre susa anehe tanahráqkákáq kawerue sehgírataq Manikánka ite meirena oga mérapeq móitankéhe. ");
INSERT INTO awb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ebeqme Manikánka wahnah wahnahnirabeqte kaweq ehwéh mah kehiná kéhínánká irageheéra síwáhnorirana anehemé anehe tanahráq sinkehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Sísaga mó mahraréna, Naho Manikáne ehweh irarú ani Táníériga anotah íre kaweq naneq ábóraraginae teiuwe. Anehe tanahráq Manikánsabe iwíáh íwíáh atáhrabeq mi naneq ábóraragínaq tagagehe. Mah sehirá sáhnsahwe tagah keo, iwíáhue tagahro. ");
INSERT INTO awb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mi tanáhráq Súría marákórápéq míéhrataq sáwéhrapeq pehbeheráh pokoro. ");
INSERT INTO awb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mi tanáhráq máhpeq míéhrataq itene ménsámehnsá kiweyaneheéq nahupeq kibekiyehboq pehbeheráh pokoro. ");
INSERT INTO awb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sotápéq míéhrataq itene korósi koweyaneheéq itene nahtapeq kowekiyehboq pehbeheráh pokoro. ");
INSERT INTO awb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mi tanáhráq kía míéhra inínsónseq inahunah inínsónseqka íre pehbeheráh pokorahi puaq sensabé irutaboiroro. ");
INSERT INTO awb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ahrena ahrena wehekáhtáqkákáq ah kariehínagakeakáq mi iré káwéq súnúq sínehboq púreroro. ");
INSERT INTO awb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mi tanáhráq anotah íre kaweq sunúq sinawire. Manikánka mah marákó márákó mirarotaqkakáq amahnágaákáq mina tahnsa sunúq íre kéhre. Mókake mó mina tahnsa sunúq íre sinae. ");
INSERT INTO awb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Íre sinae éna, Manikánka aiq iwíáhéna, Íné túbáh agonaraq mi sunúqká ómi mah kehiná kéhíná subiq suahráhire. Ómi subipáhraruehneho éna mi tanáhráq wahtonaraníe íwíáhúwe. Mira íwíáhúnsabe wega omaq sitéh kéyábé arutaboiri puana mi tanáhráq wahtonaruankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sísaga mó mahraréna, Mi tanáhráq mó kegá itensabé, Tagahro. Ite meirena kaweraintankeheéna Manikánka omaq ato anímé mahtaq míéhre irara mó kegá itensabé, Isebeq míéhre igehe. Sene péhe éhwéhnsábé aiq pútare arítého. ");
INSERT INTO awb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Péhe éhwéh irare kegá séra mahraréra, Íné Manikánka omaq intárái aní múge ue seneherawoe. Mó péhe éhwéh irare kegá, Íné Manikáne ehweh iraru aní múge ue seneherawoe. Sirataq ótaq sansánkákáq anotah pagégé sánsánkákáq miraoneherawoe. Áhnte kegá sene ótaq sansá tagéra sensabé aiq pútare aritageheéra mi sansá miraigehe. Manikánka omaq sitéh kégá moq sene péhe éhwéhnsábé aiq pútare aritageheéra miraigehe. ");
INSERT INTO awb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Moke teiú náneq mókake ábóraragínawire. ");
INSERT INTO awb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ábóraragína puara mó kegá itensabé íné éhweh teiera, Abatapi míéhre irataq mitaq íre koragahro. Sega itensabé, Nahupeq míéhre irataq mi ehwéhnsábé íre aiq pútare arítáhro. ");
INSERT INTO awb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sokaesúéhtáq apubúue mibeqté téhragu mahbeqté téhraguinserah íné wehukení úku anínká apubúue tuinauge. ");
INSERT INTO awb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pusa káné anonka kéhrabeq kúqnumarinká ínsínsíowe úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sísaga mó mahraréna, Íre kaweq sunúq sótaikínaraq pópoqnah íre patahinae. Inokáhpeq íre íónitanae. Wehyoqmarí íópeqté meginae. Íópeqté págege naneqmarí moke kúrugúruinae. ");
INSERT INTO awb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mi tanáhráq íné wehukení úku anínká tuinie onaraq íópeqté náneq ábóraragínara mah kehiná kéhínánká tagéra uwo uwo oneherawoe. Íné íópeqté piribirioyahnkakaq téhreh naneqkakáq págegeue írábúyápipeqté tuonara tagagehe. ");
INSERT INTO awb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Túónagake pembíáhnka anotah ehwéhnínaraq Manikánka wene íópeqté ké eqmaq suankéhe. Eqmaq suahnaraq wega omaq sitéh ké moke mah marákó márákóípéqté mitaqté kéweriqme mahtaqté kéweriqme ue ue sigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sísaga mó mahraréna, Awankánsabe iwíáhue tagéq ahtebahro. Awanká ayahnawe anonkakaq kahnana ánáh aunínaraq itega iwíáhéq, Ópeq áhníbórá sire aiq ahtebóne ewe. ");
INSERT INTO awb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mina onserah moke teiú náneq ábóraragínaq tagéq íné túóna tanáhráq aiq wahtotarire. Íné onsaraq míéhre igehe. ");
INSERT INTO awb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Teiníboq írátíáhro. Amahnága oga míáh kégá ómi pehipi íre pukigehe. Ebeqme moke teiú náneq ábóraragínaraq anehe pukigehe. ");
INSERT INTO awb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Íópeqkákáq mah marákó márákóákáq parabagínana néne ehwehmé íre parabagia peh ahriahri kagainawire úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Sísaga mó mahraréna, Íné túóna wehekáhnkákáq áhwahakáq ómiga íre ahtebahwe. Íópeqté kégá íre ahtebahwe. Íné Manikáne ahninkáwágá moq íre ahteboge. Peh morá Maniká Iteriboga webataq tagaríéhre. ");
INSERT INTO awb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Naho naho Nóah mío tanahráq wehukega ahbabáréra miraunserah íné wehukení úku anínká tuinie onaraq mi tanáhráq oga míéhra kegá miraigehe. ");
INSERT INTO awb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Anotah waní pianaú tanahráq wehukega ahbabáréra ahriahri miraunserahnéra táhutahuréra ábáhréra pahuiruwana Nóahga wene sípiipéq kibekúwana anotah ibónsúwana wání piowe. ");
INSERT INTO awb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sega mi tanáhráqsábé íre ahtebowana wání pewe subipáhraruowara pukuwe. Sega mi tanáhráq íre ahtebonserah íné wehukení úku anínká túónagake míéhra kegá monseráhnigehe. ");
INSERT INTO awb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mi tanáhráq téhraníté sotápéq arambehrirataq mó aní tumerena mó aní auwankéhe. ");
INSERT INTO awb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Téh inítégá tópah karo karoirataq mó iní tumerena mó iní auwankéhe. ");
INSERT INTO awb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Íné itene Wahnah túóna tanáhráq íre tagaríáh púaq níwénunéq kawerue auráq matíáhro. ");
INSERT INTO awb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Anotah wehgá aebó ánínká sína tanáhráq ahtebehtaq tahirímé wega áwénunue wahnahnurawéna aebó ánínká kibekina ínaraq tagéna kaqsúéh irino. ");
INSERT INTO awb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Minayabe iwíáhue tagahro. Íné wehukení úku anínká ite íre iwíáhira tanáhráq kouwekinauge. Minayabe íwéh panantágínaq níwénunoro úwe. ");
INSERT INTO awb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sísaga mó mahraréna, Ahtebia ání tábúsoqme arámbéhríi anímé insebo? Wene wahnahnka mi anínsábé, Mó arámbéhrío ke wahnahnarito atena táhutahuq tanáhráq tópah nário atéhre. ");
INSERT INTO awb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wene wahnahnka kouwekéna teawátái arámbéhrí tábúsoqme mirainsabé tagéna wene arambehri anínsábé, Kaweróne atankéhe. Kaweróne atéhnsábé arambehri aníné aru eyoyóinkehe. ");
INSERT INTO awb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Teiníboq írátíáhro. Wene arambehri anínká tábúsoqme arámbéhríi puana wene wahnahnka, Moke néne ménsámehnsátaq wahnahnúno atanae. ");
INSERT INTO awb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ahbabáq arambéhrí ánínká iwíáhéna, Néne wahnahnka íre apubúue kouwekinae íwíáhire. ");
INSERT INTO awb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mira íwíáhinsabé áwáhu arámbéhrío ke subiqmarena múguwahgu kereq táhutahuq néna píah naruq narurire. ");
INSERT INTO awb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wega íre iwíáhue áwénunína tanáhráq wene wahnahnka séna mina tagéna ");
INSERT INTO awb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","anotahtaq kamah awena ahbabáq kopéráhpéro keba móatanae. Mitaqte kégá ibiséra uwo uwo oneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sísaga mó mahraréna, Mi tanáhráq íópeq Manikánka wahnah wahnahnirabeqme teiú áhrárígáú tahnsane. Inayáhnkú áhrárígáúnká o menáhwé taganeheéra sene áráhmuwarí mewera pokurowe. ");
INSERT INTO awb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Moberíáh áhrárígáúmé múguwahgu urowara mó mobéríáh áhrárígáúmé peh ahtebia áhrárí míarowe. ");
INSERT INTO awb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Múguwahgu ahrárígáúnká peh sene áráhmu mewera káráhsíniakáq íre merowe. ");
INSERT INTO awb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ahtebia áhrárígáúnká obenkisa káráhsíní ántéhíyánkákáq áráhmuakáq mewera pokurowe. ");
INSERT INTO awb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pokurowana o menáhwé íre apubúue surainsabé mi ahrárígáú múkúqmahkuréra sugarowe. ");
INSERT INTO awb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Inokáhnabubu mó anínká sawai sawaiéna, O menáhwénká áhníbórá sire. Seragahro uraire. ");
INSERT INTO awb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Seragahro urairara moke mi ahrárígáúnká irigéra sene áráhmu keqmarówe. ");
INSERT INTO awb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Múguwahgu ahrárígáúnká ahtebia áhrárígáúnsábé, Itene áráhmu puinkinaire. ");
INSERT INTO awb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Káráhsíni náíéro urowara, Ahqáho. Itene káráhsíni íre awehraq kéhre. Káráhsíni paiqmaráh kébá kobaiqmáráhro urowe. ");
INSERT INTO awb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kobaiqmáráhro urowara múguwahgu ahrárígáúnká káráhsíni kobaiqmaraneheéra pokurowana o menáhwé aiq suraire. Wereq ahtebia áhrárígáúnseq táhutahuroneheéra nahupeq kibekéra onsa paiqmatowe. ");
INSERT INTO awb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Onsa paiqmatowara anehe mó ahrárígáúnká sure o menáhwénsábé, Onsa siito urowana ");
INSERT INTO awb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","o menáhwénká sensabé, Ahqáho éna, Ite íre tagaríóge uraire. ");
INSERT INTO awb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mina uronserahniyehboq íné túóna wehekáhnkákáq áhwahakáq itega íre tagaríáh púaq kawerue níwénunoro úwe. ");
INSERT INTO awb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sísaga mó mahraréna, Íné túónawe teiú wéhgá miraurainserahne. We anotah wahnáh ánínéna mó ke suwahpeq pokina uraitaq wene arambehri ke síáhrabéna móne átáríageheéna síátáire. ");
INSERT INTO awb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sene sánsánsábé iwíáhue tagéna síátáire. Mó aní 5 táhúséni (5,000) Kína awena mó aní 2 táhúséni (2,000) Kína awena mó aní 1 táhúséni (1,000) Kína awena se suena pokuraire. ");
INSERT INTO awb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pokurairana 5 táhúséni Kína átáríarai anínká apubúue mi monéráté paiqmaq paiqmarurainsabé mó 5 táhúséni Kína meraire. ");
INSERT INTO awb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mira urainserah 2 táhúséni Kína átáríarai anínká mi monéráté paiqmaq paiqmarurainsabé mó 2 táhúséni Kína meraire. ");
INSERT INTO awb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Merairana 1 táhúséni Kína átáríarai anínká wene wahnahne móne mewena marakó ubuqme mi moné maisawe kopéq sutaire. ");
INSERT INTO awb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Íre wahto tanahráq parabagurairana sene wahnahnka kouwekéna sega átáríaro moné kaweraranieéna síáhraburaire. ");
INSERT INTO awb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Síáhraburairana 5 táhúséni Kína merai anínká átáríarai monéákáq mó 5 táhúséni Kínaakáq mewena sure wene wahnahnsabé, Arene 5 táhúséni Kína átáríómé mi monéráté paiqmaq paiqmaruraunsabé mó 5 táhúséni Kína matíóge urairana ");
INSERT INTO awb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","wene wahnahnka wensabé, Kaweróne. Arewe kawerue tábúsoqme arámbéhríóna aní móne. Arega pehgáriq naneq tábúsoq marahnayabé, Áhntetaq wahnahnúno ataníe. Arereq ínéreq moráráq iwíáh íwíáhoyehe uraire. ");
INSERT INTO awb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Urairana 2 táhúséni Kína merai anínká átáríarai monéákáq mó 2 táhúséni Kínaakáq mewena sure wene wahnahnsabé, Arene 2 táhúséni Kína átáríómé mi monéráté paiqmaq paiqmaruraunsabé mó 2 táhúséni Kína matíóge urairana ");
INSERT INTO awb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","wene wahnahnka wensabé, Kaweróne. Arewe kawerue tábúsoqme arambehrióna aní móne. Arega pehgáriq naneq tábúsoq marahnayabé áhntetaq wahnahnúno ataníe. Arereq ínéreq moráráq iwíáh íwíáhoyehe uraire. ");
INSERT INTO awb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Urairana 1 táhúséni (1,000) Kína merai anínká sinehe sure wene wahnahnsabé, Arewe págege wahnáh ání móne. Íre arega uqmarahna naneq mewe meweóne. Íre arega suitabarahna naneq mewe meweóne. ");
INSERT INTO awb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Arene sánsá tagaríó púana arene mónewe marakó ubuqme maisawe kopéq sutauge. Umah. Arega níátóna moné meyo uraire. ");
INSERT INTO awb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Meyo urairana wene wahnahnka wensabé, Íre kaweróne. Arewe taoraho íre kaweq arámbéhríóna aní móne. Arega ínénsabe, Íre arega uqmarahna naneq mewe meweóne. Íre arega suitabarahna naneq mewe meweóne eno? ");
INSERT INTO awb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Néne sánsá tagariahna puah aneqsabé néne íntáríarona moné pénkiipéq íre matono? Mirauronaraq tahirímé kouwekutaq mi monéákáq pénkiraq wahnahno kegá áwíra monéákáq náiena irino uraire. ");
INSERT INTO awb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mi wahnáhnká wene arambehri keyábé, 1 táhúséni (1,000) Kína matíéh áníné móne moke mewe 10 táhúséni (10,000) Kína matíéh ání náwéro. ");
INSERT INTO awb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Áhnte matíéh ání mónkakáq awenana íregáritaq matiankehe. Tabonah aniné matíéh náneq meyaníe. ");
INSERT INTO awb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mah taoráhó árámbéhrí ánímé táhtoqme máhpeq sunkíkírirabeq átáhro. Mitaq moke míáh kégá ibiséra uwo uwo oneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sísaga mó mahraréna, Ínéga wehukení úku anínká téhreh naneqkakáq íópeqté kéreq túónaraq wahnahnérapeq tútuue págegeue wahnahninie. ");
INSERT INTO awb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tútuue wahnahnonaraq moke mah kehiná kéhíná niuranabiahtapeq seiriwe míagehe. Iriwe míéhrataq sainsuqme téhtaré túíná araníe. Ménkámehnkáne abowágá wene ka saraqme sipisípiq mó tuiná arena mémewe mó tuiná áréhnserah mah kehiná kéhíná mina tahnsanue saraqmaraníe. ");
INSERT INTO awb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sipisípiq wene ayah púpeq mó tuiná arena mémewe ayahnapeq mó tuiná áréhnserah mah kehiná kéhíná mina tahnsanue saraqmaraníe. ");
INSERT INTO awb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Saraqmarena íné anotah Wahnáh ánínká niyah púpeq míéhra keyábé, Nániboga kawerowe aitéh kéo, wega wahnah wahnahnirabeq kaweq matábúrápéq sewíáhro. Mah marákó márákó íre mirarotaq ite míageheéna mah matábú kawerarowe. ");
INSERT INTO awb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Íné nirupibiuraitaq itega kirabo aintárówe. Íné tahbobóuraitaq itega wání náníátówe. Íné wáhnaupéqté ání míarautaq itene nahtapeq mehweh aintárówe. ");
INSERT INTO awb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Íné ninerineré naneq íre káráitaq itega náníátówe. Íné nuwahreurautaq itega soberurowe. Íné karábúsiipéq míarautaq itega íné seragarowe teiníe. ");
INSERT INTO awb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mina kaweqtaq míéhra kegá ínénsabe, Itene Wahnahno, are arupibiuraitaq árahtaq kirabourauno? Are tahbobóuraitaq árahtaq wání náwátáuno? ");
INSERT INTO awb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Are wáhnaupéqté ání míaronaraq itene nahtapeq árahtaq mehweh atáráuno? Are aneraneré naneq íre káráitaq árahtaq náwátáuno? ");
INSERT INTO awb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Are awahreuronaraq itega árahtaq soberurauno? Are karábúsiipéq míaronaraq itega árahtaq koragarauno éq kasenigehe. ");
INSERT INTO awb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kasenirakake íné anotah Wahnáh ánínká mahrarinie. Teiníboq írátíáhro. Itega nánuwahrah aní pehgáriq aní mina tahnsa atárótaq itega íné moq mina tahnsa aintárówe inie úwe. ");
INSERT INTO awb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sísaga mó mahraréna, Anehe tanahráq ínéga niyahnapeq míéhra keyábé, Nániboga íre kawerowe aitéh kéo, íné nueq ahriahri teh iráípéq kowíáhro. Owainawanseq we kéráh íópeqté kéreq mitaq míageheéna Manikánka mi irá parearowe. Mitaq kowíáhro. ");
INSERT INTO awb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Íné nirupibiuraitaq itega íre kirabo aintárówe. Íné tahbobóuraitaq itega wání íre náníátówe. ");
INSERT INTO awb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Íné wáhnaupéqté ání míarautaq itene nahtapeq íre mehweh aintárówe. Íné inerineré náneq íre káráitaq itega íre náníátówe. Íné nuwahreurautaq itega íre soberurowe. Íné karábúsiipéq míarautaq itega íné íre seragarowe inie. ");
INSERT INTO awb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sega ínénsabe, Itene Wahnahno, are arupibiuraitaqmé tahbobóuraitaqmé wáhnaupéqté ání míaronaraqmé aneraneré naneq tabonahuronaraqmé awahreuronaraqmé karábúsiipéq míaronaraqmé itega are tagéq árahtaq íre séhréh atáráuno éra kasenigehe. ");
INSERT INTO awb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kasenirakake íné Wahnah anínká mahrarinie. Teiníboq írátíáhro. Itega nánuwahrah aní pehgáriq anínsábé ahqáho atárótaq itega íné moq ahqáho aintárówe teriníe. ");
INSERT INTO awb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Terienara mi kegá ahriahri teh iráípéq pokirara kaweqtaq míáh kégá oga mérapeq awaq miagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sísaga moke mah ehwéh síwáhnoraruena ite we kérahwána keyábé, ");
INSERT INTO awb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Téhtaré wéhékáh sótaikúwana apahtáróráq sótaikú iahreraq ko tánáhráq sinae. Minayabe ahtebahwe. Mi tanáhráq íné wehukení úku aní awankátaq táhparageheéra móintagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mi tanáhráq Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqka wahnah aní wenáwíq Káíyápásane nahtapeq momiwíuwe. Káíyápásawe Manikáne ehweh mibeq mahbeq arítáh kéné wahnahne. ");
INSERT INTO awb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mi kegá sío síoéra, Sísawe árahue epéq táhtoqme mósubiq suanéhnkono íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mira íwíáhéra, Áhnte wehekéqká táhutahurirataq ehwehéra tobehiyehboq Sísa pehraganehe uwe. ");
INSERT INTO awb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pétáni suwahpeqte ání Sáímóniwe anotah nao wagú anine. Minayabe mó kegá, Náonkakaq Sáímónie ue wéhuwehu áwíratówe. Sísaga Pétáni suwahpeq ména mi aníné nahtapeq ");
INSERT INTO awb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","táhutahurúwana peh morá ínínká áhnte moné tahnsa wérí ano antéhyá mewe sure Sísane ayahqnotaq antiatowe. ");
INSERT INTO awb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Antiatowara ite Sísa kérahwána kegá mina tagéq abiahnsanéq iteite náhenéq, Aneqsabé pehipi antiatehro? ");
INSERT INTO awb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Íre pehipi antiatéhtáq tahirímé mi werí paiqme áhnte moné mewena tabonah ke nárí irino ewane. ");
INSERT INTO awb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ewanana Sísaga itene ehweh irena itensabé, Aneqsabé mi inínsábé awehgu ataho? Wega mira aintéh sánsámé kaweq sansáne. ");
INSERT INTO awb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tabonah kewe ahriahri iteba mía míowe. Ínéwé ahriahri iteba íre mía míainie. ");
INSERT INTO awb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Íné maisarageheéna mi inínká ninonkataq wéri anti aintena kaweraintéhre. ");
INSERT INTO awb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Teiníboq írátíáhro. Kaweq ehwéh mah marákó márákó teri terinirataq wega amahnága mirai naneq ehwehnkákáq terigéhe. Terírataq íréhra kegá wéri abaq intéh ínínsábé iwíáhigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ite Sísa kérahwána ke airápété téhraníté míahwane. Itebaté ání wenáwíqtare Súrása Ísíkáríótie. Wega Manikáne ehweh mibeq mahbeq arítáh kébá pokue ");
INSERT INTO awb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","sensabé, Sísa iteba méáúwáhnaraqmé aneq nánianéhbo úwara wega mirainkeheéra sega 30 ebáh móné we náwúwe. ");
INSERT INTO awb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Náwúwana wega se Sísaba mórite tanahráqsábé iwíáhue kabarúwe. ");
INSERT INTO awb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Íre múí párétí né tanahráq súwe. Mi tanáhráq ebeqte wéhékáh ite we kérahwána kegá Sísaba séq wensabé, Sótaikú tanahráq iahreraq kéh táhútáhúq nankehboq eheq kogaweratanéhnkono ue kasenowane. ");
INSERT INTO awb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kasenowanana wega peh morá ánínsábé iwíáhéna itensabé, Sarúsarama suwahpeq teiátáu anípá pokue wensabé, Íwáhnori anínká mahraréna, Íné tanahráq aiq sire. Ínéreq íné séníráh kéreqka arene nahtapeq sótaikú tanahráq iahreraq kéh táhútáhúq nanehe ire koreawéro úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Koreawéro úwaq itega mi ehwéh sehgieq mitaq sótaikú tanahráq iahreraq ko tahutáhúq kawerarahwáne. ");
INSERT INTO awb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Íó tupekútaq Sísareq ite airápété téhraníté we kérahwána kereqka tútuue táhutahurowane. ");
INSERT INTO awb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Táhutahurowanaraq Sísaga itensabé, Teiníboq írátíáhro. Ite míáhrabeqte ánínká néne naruo kowerirankéhe úwaq ");
INSERT INTO awb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ite we kérahwána kegá ireq irupipeq umeh agúwe. Umeh agúwaq ite morání moránínkáue Sísansabé, Néne Wahnahno, arega ínénsabe irareno ue kasenowane. ");
INSERT INTO awb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kasenowanana Sísaga itensabé, Ínéreq moráráq páréti wahba parétáhípéq pámbáhúya anínká néne naruo kowerirankéhe. ");
INSERT INTO awb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kowerirahnaraq Manikáne ehwehnka aiq irarinserah íné wehukení úku aní pukinie. Néne naruo kowerirahna aní anotahtaq kamah awinawire. Wenanoga we íre maqmiotaq tahirímé aiq kaweri irino úwana ");
INSERT INTO awb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Súrása Sísane naruo koweriranaú anínká wensabé, Íwáhnoraníno, arega ínénsabe irareno úwana Sísaga wensabé, Arerega aiq iraréne úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Itega táhutahurowanaraq Sísaga páréti mewena Manikánsabe kaweróne atena keqme ite we kérahwána ke náiena itensabé, Mahnawé niwaq mire. Nahro úwaq nahwane. ");
INSERT INTO awb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nahwanana náhníáq sera ano ko kahpú mewena Manikánsabe kaweróne atena náiena itensabé, Itega ómiga moke nahro. ");
INSERT INTO awb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Néne korahq mire. Néne korahq tuinaga itereq áhnte mó kereq Manikánka insahwé aitena itene ahbabáq kaweraitankéhe. ");
INSERT INTO awb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Teiníboq írátíáhro. Náhníáq sera ano mahtaq mó íre nanie. Mókake Nániboga wahnah wahnahnirabeq itereq o será ano nanehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Itega Manikánsabe iwíáh íwíáh igonkónéq máhpeq tueyokéq Óríwi sawéhrápéq pokowane. ");
INSERT INTO awb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sísaga itensabé, Manikáne ehwehnka mahraréna, Ínéga sipisípiq Wahnáh subiq súáhnaraqmé moke sipisípiqmarínká kobeq séberigehe ire. Mi ehwéhnká irarinserah ibora ínókáhpéq ite ómiga íné nueq kobeq séberigehe. ");
INSERT INTO awb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Manikánka íné oganúq intahnaraq Kehrari marákórápéq ebeq konaq inehe sigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Úwana Pítaga Sísansabé, Ómiga are áúwéhrataqmé ínéga íre auwanauge úwana ");
INSERT INTO awb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sísaga wensabé, Teawiníboq írátíahno. Ibora ínókáhpéq kokórega ehwehnina ínaraq arega íné íre tagaríóge apahtáróráq irariniewóne úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Úwana Pítaga wensabé, Mó kegá arereq ínéreq iubiq íúwéhrataqmé ínéga, Are aiq tagaríóge atanauge úwaq moke ite Sísa kérahwána kegá Pítaga irarú serahnowane. ");
INSERT INTO awb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sísareq ite we kérahwána kereqka mitaq sueq Késémáni matábúráq pokowane. Sísaga itensabé, Ite mahtaq tútuue míehrana íné móbeq kobúrerono éna ");
INSERT INTO awb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pítareq Sébérine ahninkáwáráréreq móbeq móritowe. Móritena wene arupipeq anotah uméhue págege agúwana ");
INSERT INTO awb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","wega sensabé, Nirupipeq anotah uméhinka pukorahuge. Mahtaq tótuqméq tagaríáhro éna ");
INSERT INTO awb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","se suena wahtotaq móbeq pokéna marakóraq káuqmunue ména púrerúwe. Púrerue mahraréna, Nániboo, are awahbáhnaraqmé nirupipeq umehi naneq menuwahráhóne. Íre íné nuwahbeh sansá peh are awahbeh sansánúno ue púrerúwe. ");
INSERT INTO awb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Púreraruena we kéró anitóbá kouwekúwara sugówana tagówe. Wega Pítarehyabe, Pehgáriq tanáhráq árahinsabé íre tótuqméq tagariaho? ");
INSERT INTO awb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Iteiyuwanka kaweq sansánsábé suwahbehre. Peh itene inonka mareqmareréq íre miraorahowe. Owainawanka ahbabáq aitehnehboq tótuqméq púreroro úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Púreroro éna mónkakáq se suena kobúrerúwe. Púreréna mahraréna, Nániboo, nirupipeq umehi naneq íre menuwahnayabé are awahbeh sansá sehginie úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","We kéró anitóbá mó kouwekúwara anotah mukúqmáhkúru puara se peh sugówe. Sugówana tagéna ");
INSERT INTO awb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sísaga mónkakáq suena pokue apahtáróráq monseráhnue púrerúwe. ");
INSERT INTO awb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Púreraruena seba kouwekúwara sensabé, Ite peh ahrenaneheéq sugaho? Írátíáhro. Íné wehukení úku anípá ahbabáq ke kowerire tanahráq aiq sire. ");
INSERT INTO awb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pokonehboq irigoro. Tagahro. Néne naruo koweriréh ánínká aiq sire úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sísaga ehwehnútaq Súrása we kéro anínká súwe. Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqka áhnte mó ke eqmaq súówara sega pokamarinkákáq sahmárínkákáq Súrásareq moráráq suwe. ");
INSERT INTO awb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Seneherautaq koweriro anínká su ke teriena, Ínéga nánkóqnahna anímé Sísa wire. We táhtoráhro úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Minayabe Súrásaga Sísaba apubúue séna wensabé, Íwáhnoraníno, aiq míahno éna nánkóqnówe. ");
INSERT INTO awb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nánkóqnówana Sísaga wensabé, Néne iyahnabo aníno, arega mirainie íwíáhóna naneq apubúue miraúno úwara wereq su kegá Sísa ambubuue táhtotíówe. ");
INSERT INTO awb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Táhtotíówana Sísareq mío anínká wene poka mewena Manikáne ehweh mibeq mahbeq arítéh áníné arambehri aní apiwe wene ahre kiraq auwowe. ");
INSERT INTO awb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kiraq auwowana Sísaga wensabé, Arene poka sabiruo. Itega ebeho naneq mewe ebehirataq mó kegá mi naneqtaté iubiq suagéhe. ");
INSERT INTO awb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nánibonsabé, Séhréh ainto teawútáq tahirímé séhréh aintanieéna áhnte íópeqté ké ínéba eqmaq súéh irino. Minayabe íre ahtebaho? ");
INSERT INTO awb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ínéga mina tahnsanutaq tahirímé íné pukonayabé Manikáne ehwehnka árahue aiq pútaragi iripo úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sísaga weba su keyábé mahraréna, Aneqsabé aebó ání táhtoráhnserah pokankakaq sahnkákáq íné meniraneheéq seo? Mó wehekáh mó wehekáhnue Manikánsabe iwíáh íwíáh atáh náhtápéq tútuue íwáhnorurautaq mi tanáhráq itega íné íre táhtotiarowe. ");
INSERT INTO awb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Manikáne ehweh iraru kegá sehiranu ehwéh aiq pútaraginkeheéq miraowe úwaq ite we kérahwána kegá Sísa auweq pehbeheráh pokowane. ");
INSERT INTO awb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mi tanáhráq Manikáne ehweh mibeq mahbeq arítáh kéné wahnahme wenáwíq Káíyápásae. Mósísine ehweh síwáhnoro kereq Asiu kené aboawah wehreqka Káíyápásane nahtapeq momiwíue míówe. Momiwíue míówara Sísa táhtoró kega we meqmera Káíyápásane nahtapeq móátówe. ");
INSERT INTO awb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Se mótaq we mótarue Pítaga sinehe kaqme kure nahnoerápéqté mátábúráq párísiwarí máhpeq tútuue míórabeq kéna sega Sísa aneronehrabomo éna taganieéna tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sísa subiq suaneheéra Manikáne ehweh mibeq mahbeq arítáh kéreq moke mó kaunsírí kéreqka Sísansabé péhe éhwéh atéhra keyábé kabaruwe. ");
INSERT INTO awb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kabaruwara áhnte kegá iriwe méra péhe éhwéh teríúwe. Sega teríú ahbábáq Sísa íre subiq suahráhu ahbábáre. Sinehe mó anítégá iriwe méra mahraréra, ");
INSERT INTO awb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Mah anímé aiq mahraréna, Ínéga Manikánsabe iwíáh íwíáh atáh náh sokoruqme apahtáró wéhékáh mó pearahráhuge uraire uye. ");
INSERT INTO awb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Uyana Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka iriwe ména Sísansabé, Mi anítégá iraréya ehwéhmé arega íre terieráhono? Sene ehweh aiq pútaq ehwéhpo úwana ");
INSERT INTO awb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sísaga íre iraria peh ehiya míowe. Peh ehiya míowana wega Sísansabé, Maniká oga mía míai anínká tagaríéhtáq pahsuqme teio. Manikánka ite Asiu ke meirena kaweraitankeheéna peh morá ání omaq atowe. Arewe mi anípo? Arewe Manikáne ahninkáwábo? Pahsuqme teio úwana ");
INSERT INTO awb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sísaga wensabé, Arega aiq iraréne. Teiníboq írátíáhro. Íné wehukení úku aní Manikáne ayah púpeq tútuue ména íópeq írábúyápipeqté tuonaq tagagehe úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Úwana Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka mi ehwéh irotaq abiahnsanú púana wene korósi subansuena mahraréna, Manikánsabe íre kaweq ehwéh atéhre. Minayabe mó keyábé móme íre kasenoro. Ahqáho. Wega Manikánsabe íre kaweq ehwéh atéhraq íráhwe. ");
INSERT INTO awb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Minayabe aneratanéhnkono úwara sega wensabé, Wega ahbabáq ehweh aiq irari puaq subiq suo atanéhe uwe. ");
INSERT INTO awb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Táhmaro kegá Sísane auranabiah tehqni atera siyahtate subiqmárówe. Táhmaro míó kega we siyahpóra subera wensabé, ");
INSERT INTO awb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Are Manikánka omaq ato aníninaraqmé are subiqmaréh ání insebo? Teio uwe. ");
INSERT INTO awb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pítawe máhpeq mátaburapeq tútuue míowana arambehri ahrárígá weba séna wensabé, Are Kehrari marákórápéqté ání Sísareq míarone úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sísareq míarone úwana ómiga írátíótaq Pítaga ahqáho atena mi ahráríyábé, Arega iraréna ehwéhmé íre ahteboge éna ");
INSERT INTO awb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","mitaq suena ogesáh ogesáhraq kowíowe. Kowíowana mó arámbéhrí áhrárígá we tagéna wereq míó keyabé, Mah anímé Sísa Néhsara suwahpeqte ánínseq míaraire úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Úwana Pítaga mó ahqáho atena, Pópoqnahga tagaríéhtáq aiq pútariahnsanuge éna, Arega iraréna anímé íre tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mótaq tahnsa mitaq míó kega Pítaba séra wensabé, Arereq wereqne ehweh peh morá éhwéh púah are wenawahrah aní móne uwana ");
INSERT INTO awb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pítaga ehbonéna mahraréna, Pópoqnahga tagaríéhtáq itega irare anímé íné íre tagaríóge. Ínéga péhe éhwéh teawénaraqmé Manikánka íné nubiq suankéhe úwana kokórega ehwehnúwe. ");
INSERT INTO awb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kokórega ehwehnúwana Sísaga teawu ehwéh Píta ahreraq konsabe iwíáhúwe. Mi ehwéhnúmé, Kokórega ehwehnina ínaraq arega íné íre tagaríóge apahtáróráq irariniewóne úwe. Kokórega ehwehnútaq Pítaga mi ehwéh iwíáhéna máhpeq tueagéna anotahtaq ibisówe. ");
INSERT INTO awb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ahbiahipeq moke Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqka Sísa subiq súéhra ehwéh sío síoéra ");
INSERT INTO awb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","wene ayahnkaratáq nágáqtate táhru táhrue meqmera anotah wahnáh ání Páhírátiba móátówe. ");
INSERT INTO awb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Súrása Sísane naruo koweriro anínká mina tagéna, Íre kawerurauge íwíáhéna wega meyo moné, 30 ebáh móné mewena Manikáne ehweh mibeq mahbeq arítáh kéreq aboawah wehreqpa sure sensabé, ");
INSERT INTO awb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kaweqtaq mía míai aní ahbabáratewóge úwe. Úwara sega wensabé, Íre itereq wehgaq míre. Arerene wíre uwana ");
INSERT INTO awb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Súrásaga mi moné Manikánsabe iwíáh íwíáh atáh náhúpéq móruparuena tueyokue wewe móbáríkiriowe. ");
INSERT INTO awb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Manikáne ehweh mibeq mahbeq arítáh kégá mi moné mewera mahraréra, Mah monéwé wehukení subiq sueyabe móné púaq Manikánsabe iwíáh íwíáh atáh náhtápéqté mónéákáq moráráq íre maranéhe uwe. ");
INSERT INTO awb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sega sío síoéra wáhnaupéqté ké maisaraneheéra téh marakóráté párétah mirao marákó mi monéráté paiqmarówe. ");
INSERT INTO awb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sega paiqmárónsabe wehukega mi marákóyábé Korahq Marákóe ue áwírarówe. Amahnágaákáq mi awíq peh kéhre. ");
INSERT INTO awb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Manikáne ehweh irarú ani wenáwíq Sérémáíaga naho mahraréna, Ísara kegá wehukení paiqmaraneheéra 30 ebáh móné omaq matowe. ");
INSERT INTO awb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Maniká néne Wahnahnka tenínserah sega mi monéráté téh marakóráté párétah mirao marákó paiqmáráhwe úwe ");
INSERT INTO awb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sega Sísa anotah wahnáh ání Páhírátiba móátówana wega wensabé kasenéna, Arewe Asiu kené Wahnahpo úwe. Úwana Sísaga wensabé, Arega aiq iraréne úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqka Sísa ehweh atówana sene ehweh íre ayahqmarena peh ehiya míowe. ");
INSERT INTO awb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Peh ehiya míowana Páhírátiga wensabé, Sega ehweh atáh éhwéhmé íre irahno úwana ");
INSERT INTO awb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sísaga Páhírátine ehweh moq íre ayahqme teawuwe. Íre ayahqme teawunsabe Páhírátiga áhtenéna iwíáh kikirúwe. ");
INSERT INTO awb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Anotah tahutáhúro tanáhráq mó opéq mó opérue karábúsiipéqté ání Asiu kegá pugeqio teawú ani Páhírátiga pugesuaq pugesuarúwe. ");
INSERT INTO awb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mi tanáhráq ahbabáq ani wenáwíq Páréhba karábúsiipéq míowe. ");
INSERT INTO awb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Áhnte Asiu kegá Páhírátiba suwana wega sensabé, Páréhba pugeq auwanínkono? Sísa Manikánka omaq atena eqmaréhre e aní pugeq auwanínkono? Inse pugeq auwanínkono kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kasenéna iwíáhéna, Manikáne ehweh mibeq mahbeq arítáh kégá, Sísaga ite kiotaikíneho éra abiahnsa atáh púara ínéba meqme sewe íwíáhúwe. Mira íwíáhú púana wega sensabé, Inse pugeq auwanínkono úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Páhírátiga kotiorabeq wahnahnúwana wene ahrega ehweh eqmarena mahraréna, Asiu kegá ehweh atáh ánínsábé inokáhpeq áónáhéna nirupipeq áhnte uméhirana tagoge. Minayabe mina kaweqtaq mía míai aní pehragato úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqka míó keyabé pagu pagunéra, Mah ehwéh Páhíráti koreawéro. Wensabé teaweq, Páréhba pugeq auwe Sísa subiq suo ue koreawéro éra pagu pagunuwara míó kega, Páréhba pugeq auwo uwe. ");
INSERT INTO awb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Uwana Páhírátiga mónkakáq sensabé, Mah aníté inse pugeq auwanínkono úwara ómiga, Páréhba pugeqio uwana ");
INSERT INTO awb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Páhírátiga sensabé, Sísa Manikánka eqmaréhre e anímé aneratanínkono úwe. Aneratanínkono úwara sega wensabé, Awankátaq táhpawe subiq suo uwana ");
INSERT INTO awb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Páhírátiga sensabé, Aneqsabébo? We aneq ahbabáriro úwara sega ehweh kikiréra, Awankátaq táhpawe subiq suo uwe. ");
INSERT INTO awb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Uwana Páhírátiga iwíáhéna, Mahtaq míáh kégá néne ehweh íre irah púana anotah tobéhiyehboq túbáh aginie. Túbáh aginie éna wehukega tagaríótaq wání antehya mewe wene ayahnkara pabeq paberúwe. Pabeq paberaruena sensabé, Tagaríáhro. Mah aní subiq sue íwíáh íre néne peh iteitene iwíáh wíre úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Úwara moke míó kega mahraréra, We subiq súéhranka itereq itene animárínseq kamah ainawire uwe. ");
INSERT INTO awb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Minayabe Páhírátiga Páréhba pugeq auwena Sísa áréti sahtáté subóro aritena sóntía kegá awankátaq táhpawe subiq suageheéna siuwe. ");
INSERT INTO awb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Páhírátine sóntía kegá Sísa meqmera wahnah anínká ehwehúrabeq kibekue móatera ómi mó sontíá ké síáhrabuwara Sísaba momiwíuríówe. ");
INSERT INTO awb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Momiwíéra moke wene korósi ugurú auwera peh morá tautáúq korósí abaq atera ");
INSERT INTO awb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ógaratáté keborarera wene ayahqnotaq suki atówe. Suki atera wiahnókara wene ayah púpeq atera wene auranabiahtapeq sirehunseraráq méra wensabé péhepehe iwíáh íwíáh atera awiréh atówe. Awiréh atera wensabé, Aiq míahno? Arewe Asiu kené Wahnah mone éra ");
INSERT INTO awb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tehqni atera wiahnó sahtáté ayahqnotaq subiqmarera ");
INSERT INTO awb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","awiréh atówe. Awiréh atera abaq ató korósí akai auwera wewene korósi suki atera awankátaq táhparaneheéra meqmera pokuwe. ");
INSERT INTO awb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sóntía kegá Sísa meqmera awankátaq táhparanehera urabeq pokue Sáíríni marákórápéqté ání wenáwíq Sáímóni piehgíútaq saiqnatera, Sísa táhparéhra awánkámé abaqme kúno atónsabe abaq mena kúwe. ");
INSERT INTO awb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sega pokue Kógóta sawéhrápéq kíúwe. Mi sawéh áwíqmé áwahewé wehukení ayahqno tánúnsutapére. ");
INSERT INTO awb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mitaq sega íre érorahi kítabeh maráhsíní mewera náhníáq sera anopipéq sombirahue Sísa náwúwana nawe tagéna ahqáho éna íre nówe. ");
INSERT INTO awb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Íre nówara sega we meqmera awankátaq níriraté wene ayahnkaratáq subiqmaq aigárátáq subiqmarue táhparera awanká pankeqme marakóipeq pearówe. Pearera, Wene korósi insega meyanabomo éra saraq mianeheéra káhsiue saraqme meyówe. ");
INSERT INTO awb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Saraqme mewera tútuue méra Sísa awahnkanuwe. ");
INSERT INTO awb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ehweh átó ehweh kanehraq sehiranúwara wene ayahqno abobóráhpeq awankátaq táhparówe. Mi sehiránká mahraréna, Mah anímé Sísa Asiu kené Wahnahne úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sísa awankátaq táhparórabeq aebó áníté moq awankátareráq níri pewe táhparéra pankeqme ayehré ayehré pearówe. ");
INSERT INTO awb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pearówara mitaq sótaiku kegá Sísa tagéra awiréh atera sinuo kóbiq kóbiréra wensabé íre kaweq ehwéh atówe. ");
INSERT INTO awb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Íre kaweq ehwéh atera mahraréra, Manikánsabe iwíáh íwíáh atáh náh sokoruqme apahtáróráq mó pearahráhóna aníno, arere séhréhúno. Oga míankehboq marakóipeq tueagúno. Arewe aiq pútaq Manikáne ahninkáwá inaraqmé maraipéq tueagúno éra awiréh atówe. ");
INSERT INTO awb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Awiréh atówara Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereq Asiu kené aboawah wehreqka Sísansabé moq awiréh atówe. ");
INSERT INTO awb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Awiréh atera mahraréra, Wega mó ke kaweraritena peh wewe íre kawerorahire. Wega, Íné Asiu kené Wahnah muge íwíáhire. Wega marakóipeq tueagínaq tagéq wensabé aiq pútare atanéhe. ");
INSERT INTO awb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wega, Íné Manikáne ahninkáwá úge éna Manikánka séhréh aintankéhe íwíáhire. Manikánka wensabé arutaboirínaraq seséhréh atanae éra awiréh atówe. ");
INSERT INTO awb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aebó áníté awankátaq táhparó anitégá moq íre kaweq ehwéhnéra Sísansabé awiréh atóye. ");
INSERT INTO awb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wéhékáhnabubu moke mah marákó márákó sunkíkíragúwana íó tunsorerutaqkakáq peh sunkíkíratiowe. ");
INSERT INTO awb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tunsorerutaq Sísaga wewene ehwehtaq Wenabonsabé anotahtaq mahraréna, Írói, Írói, tahmah sabáhtahnie úwe. Mi ehwéhnúmé, Nániboo, Nániboo, aneqsabé íné nuwahno úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Úwara táhmaro iriwe míó kega irera mahraréra, Éráísansabé áhrabire uwe. ");
INSERT INTO awb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mibeqté ánínká pehbeheráh sehenáh tahnsa náneq mewena kítabeh nah naneqpipéq pámbáhue sehikaratáq maqme pankeqme Sísaga píbíra nankeheéna awuwe. ");
INSERT INTO awb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Awutaq mó kegá, Peh áwé tagahro éra, Éráísaga segaweratanabiramo. Taganeheqmúne uwana wenawa kieyokúwana ");
INSERT INTO awb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sísaga mónkakáq anotahtaq ehwehnéna wenawa Maniká awena putiowe. ");
INSERT INTO awb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Putiotaq Manikánsabe iwíáh íwíáh atáh náhtápéqté páráhnkéq tahnsa ónsá senahpeqté subame tunse téhtaré úkúwe. Téhtaré úkúwana máríúwana ebahmarí parebare agúwe. ");
INSERT INTO awb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Parebare agúwana maisaró oná sigúwe. Sigúwana Manikánsabe aiq pútare atera puku weh áhréné sinonka Manikánka iriritena oganúq sitowe. ");
INSERT INTO awb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Maisiapípéqté kie irigéra anehe Sísa oganúkútaq mi kegá Sarúsarama suwahpeq pokuwara áhnte mó kegá tagowe. ");
INSERT INTO awb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Máríúwara sóntía kereq sene kíápéténireqka minaakaq moke mó naneqmarínkákáq tagéra anotah ahrééra mahraréra, Mah anímé aiq pútaq Manikáne ahninkáwá wíre uwe. ");
INSERT INTO awb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sísa íre putiotaq Kehrari marákórápéq suena pokútaq áhnte mó inínsónká we séhréh ataneheéra kérówe. Sísa putiotaq mi ahrérónká móbeq iriwe méra awahnkanuwe. ");
INSERT INTO awb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mágára suwahpeqte íní wenáwíq Máhríae. Wenaogo Máhríáwé Sémísireq Sósépareqne sinowae. Mi inítéreq Sébérine ahninkawáráréné sinowareqka moq iriwe méra awahnkanuwe. ");
INSERT INTO awb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Árímátéa suwahpeqte ání wenáwíq Sósépae. We áhnte monéákáq ánínéna Sísansabé aiq pútare atowe. ");
INSERT INTO awb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Sísa pukú wehekáh íó tupekútaq Sósépaga Páhírátiba pokéna wensabé, Sísane anonka mewena mómaisaranínkono úwana kowe atena sóntía keyábé, Sísane anonka mah aní áwéro úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Áwéro úwara sega wene anonka áwúwana Sóséparehga Sísane anonka mewera íre wahto taberábe ambántáípéq úbíqme ");
INSERT INTO awb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sósépane o ubusa ónápípéq mómaisarówe. Maisarera anotah ebáh paentáwe kure maisaró mehpéh paiqmarera pokuwe. ");
INSERT INTO awb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mágára suwahpeqte íní Máhríareq mó wenaogo Máhríareqka mitaq tútuue méra awahnkanuye. ");
INSERT INTO awb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sísa maisaró wehekáhmé Asiu kene ahrena ahrena wehekáhné ménsámehnsá kawerare wehekáhne. Mi wehekáh parabagúwana mó wehekáh Manikáne ehweh mibeq mahbeq arítáh kéreq Péhrasi kereqka Páhírátiba kosoruparawéra ");
INSERT INTO awb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wensabé, Anotah aníno, péhepehenurai anínká oga míaraitaq mahraréna, Íné pukéna apahtáróráq mó oganúkinauge uraire. Itega mi ehwéhnúmé aiq iahreraq kéhre. ");
INSERT INTO awb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","We kétó kegá we maisatorabeqte wene anonka segiroqmera mó kopéq suera mó keyábé, We oganúkire teríyehboq arega sóntía keyábé mi maitáq apahtáróráq kowahnahnoro arito. Arega íre mirainaraq anehete péhe éhwéhnká ebeq piah péhe éhwéh kiotaikinae uwe. ");
INSERT INTO awb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Uwana Páhírátiga sensabé, Sóntía ke meriqmeq we maisatorabeq pokue mitaq óna paiqme págege atawéq kawerue wahnahnarito úwe. ");
INSERT INTO awb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kawerue wahnahnarito úwara sega sóntía ke meriqmera pokue méhpeh paiqmáró ébáh ónsá perahsarera mó kegá sirúého éra sóntía keyábé kawerue wahnahnoro arítówe. ");
INSERT INTO awb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ahrena ahrena wehekáh parabagúwana o wikí kowara ebeqte wéhékáh ahbiahipeq íó kiembogútaq Mágára suwahpeqte íní Máhríareq mó wenaogo Máhríareqka maisarorabeq tagayeheéra pokuye. ");
INSERT INTO awb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tagayeheéra pokuyana anotah maríúwana Manikáne íópeqté ánínká tunse méhpeh paiqmáró ebáh paentáwe móbeq marena mi ebáhtáq tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wene auranabiah sokeqsúéh tahnsa kúgú agúwana wene korósi anotah tabérábé píríbíríóyáh tahnsane. ");
INSERT INTO awb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mitaq wahnahnuríó sontíá kégá we tagéra anotah ahrééra iransánéra pusa ké tahnsa úkuwe. ");
INSERT INTO awb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Íópeqté ánínká mi inítéyábé, Íre áhreotao. Íné tagaríómé itega Sísa awankátaq táhpato aní seragéhye. ");
INSERT INTO awb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","We mahtaq íre míéhre. Wega irarurainserah oganúkire. Wene anonka matotaq seragahtao. ");
INSERT INTO awb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tagéta peheráh pokue we kétó ke koreríétao. We iriwe oganúkéna Kehrari marákórápéq ebeq kínaq we anehe kirataq Sísa mitaq tagagehe. Aiq teiúge. Koreríétao úwe. ");
INSERT INTO awb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Úwara mi inítégá áhreéra peh sene sirupipeq iwíáh íwíáhéra apubúue mitaq suera pehbeheráhnue ite Sísa kérahwána ke teieyeheéra pokuye. ");
INSERT INTO awb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pokue ahtapeq kuyataq Sísareq sereq piehgíúwe. Sísaga sensabé, Pehwehrue míáhtao úwara mi inítégá weba kure wene aigárá táhtoqme iwíáh íwíáh atóye. ");
INSERT INTO awb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iwíáh íwíáh atóyana Sísaga sensabé, Íre áhreotao. Nánuwahrahyabé korerieq, Kehrari marákórápéq pokoro. Mitaq íné tagagehe. Koreríétao éna eqmarowe. ");
INSERT INTO awb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Eqmarowara mi inítégá pokuyara maisarórabeqte sóntíá kégá Sarúsarama suwahpeq pokue Manikáne ehweh mibeq mahbeq arítáh ké moke tago naneq teríúwe. ");
INSERT INTO awb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Teríúwara Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqka momiwíue sío síoéra moráénéra sóntía kegá sene ehweh sehgigeheéra áhnte moné síúwe. ");
INSERT INTO awb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Móne siera mahraréra, Mó keyábé mahraue terieq, Inokáhpeq ite sugéwonayabé we kétó kegá sure wene anonka mewera eheqpopoq morúáhwe teríéro uwe. ");
INSERT INTO awb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Teríéro éra, Anotah wahnáh ánínká ite sugéwaro ehwéh irahnaraq itega mi ehwéh tábúsoqme teawenéhe. Teawénaraq wega ite íre kamahinae uwe. ");
INSERT INTO awb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Uwara sóntía kegá móne mewera mi pehe éhwéh sehgíúwe. Asiu kegá mi ehwéh Súría marákórápéq mitaq teri mahtaq terinuwara abae agúwe. Miraunsabé mi tanáhráqkákáq amahnágaákáq Asiu kegá mi ehwéhnsábé, Aiq pútaq ehwéhne atáhwe. ");
INSERT INTO awb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ite airápété morá ké Sísa kérahwána kegá pokue Kehrari marákórápéq Sísaga teiu sawéhrápéq kiowáne. ");
INSERT INTO awb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mitaq Sísa tagéq wensabé iwíáh íwíáh atahwáne. Peh táhmaroga sirupipeq téhtaré íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sísaga iteba wahtotaq séna itensabé, Maniká Nániboga íópeqkákáq mah marákó márákóákáq moke wahnahnúno aintena págege aintéhre. ");
INSERT INTO awb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Minayabe pokue mah kehiná kéhíná íné séníráh ké úkigehboq kosíwáhnororo. Nániboreq íné wenahninseq Manikáne Awanseq íwírue wání meríéro. ");
INSERT INTO awb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Moke teiátáu ehwéh tábúsoqme sehgigéhbo kawerue síwáhnororo. Kawerue írátíáhro. Amahnágaákáq mókakeakáq mah marákó márákó parabagína tanáhráqkákáq peh itereq mía míainauge úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sísa Karáhéwé Manikáne ahninkáwá wíre. Kaweq ehwéh áwahewé ");
INSERT INTO awb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Manikáne ehweh irarú ani wenáwíq Áísáíaga púkuipéq sehiranue mahraréna, Írátíáhro. Néne ehweh korerie anímé ah kawerinkeheéna ebeq eqmaróge. ");
INSERT INTO awb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","We abatapi ména sawai sawaiéna mahraréna, Itene Wahnah sína ahmé aborisahro. Wene ah kaweraráhro inkehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mah sehiránká irarinserah wání meri merini aní wenáwíq Sóni uworapeq ména ehweh teri terinéna, Manikánka itene ahbabáqsabe kaweraitankéhboq ahbabáq sansa sueq kaweqtaq míáhro. Itene ahbabáq sansa sueq kaweqtaq míéhrataqmé wání meiníe úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Súría marákórápéqté kéreq Sarúsarama suwahpeqte kéreqka ómiga weba suwe. Su kegá sene ahbabáqsabe Maniká teawúwana Sóniga Sorana aroipéq wání meriuwe. ");
INSERT INTO awb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sóniga kéhmane áyórate kogahnia aneraneratiowe. Áú arétí wene ayahbataq konahnatiowe. Tábahnkákáq sehenáhrabahnkakáq nówe. ");
INSERT INTO awb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Sóniga mahraréna, Inehe si anímé anotah aní ména íné kiotaiqme aní míre. We anotah aní púana ínéga nirehunseraráq ména wene súu nahníáq pugereyabe íre awehrari aní múge. ");
INSERT INTO awb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ínéga peh wání mei meinonana wega Manikáne Awa náinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mitaqkake Sísaga Néhsara suwahpeq Kehrari marakórápéqté súwana Sóniga Sorana aroipéq Sísa wání meawuwe. ");
INSERT INTO awb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Meawuwana Sísaga wánípipeqté kiutaq tagówana sabonah sawekúwana Manikáne Awanka tunse kiboki tahnsanéna Sísaba márunsurahúwe. ");
INSERT INTO awb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Márunsurahúwana íópeqté éhwéhnká mahraréna, Are niruní nénáhní móne. Arensabé nirutaboiruge úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Manikáne Awanka Sísa meqmena abatapi móatowe. ");
INSERT INTO awb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Áhnte wehekáh 40 wehekáh Sísa mitaq míowana owainawanka weba séna Sísaga ahbabárinkeheéna áhwárawe tagéna áwíoqnówe. Sísa ménkámehnká míórabeq míowara íópeqté kégá weba séra séhréh atówe. ");
INSERT INTO awb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mó kegá Sóni karábúsiipéq átówana Sísaga Kehrari marákórápéq pokéna Manikáne kaweq ehwéh teri terinúwe. ");
INSERT INTO awb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Teriena, Ibora awehraq tanáhráq míre. Manikánka wahnah wahnahnime aiq wahtoni puaq itene ahbabáq sueq kaweqtaq méq mah kawéq éhwéhnsábé aiq pútare aintáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sísaga Kehrari kawéhú ayehrápéq noguwara se ábárahré Ehntarureq Sáímónireq tagówe. Sáímóniwe mó awíq Pítae. Se pah meyóya aníté míóyansabé kahweraté wánípipeq uwe taga tagauyana tagówe. ");
INSERT INTO awb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tagéna sensabé, Íné séníráhtao. Amahnága itega kahweraté uwe taga tagaéta pah meyehye. Mina óyanserah wehuke ínéba meriqmeta sigehe. Minayabe íwáhnoriniboq séníráhtao úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Séníráhtao úwara sene kahwe apubúue mitaq marera Sísa kéróye. ");
INSERT INTO awb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kéróyana Sísaga kure mó abáráhré Sébérine ahninkáwáráré síwíqmé Sémísireq Sónireq sene sípiipéq méra kahwewarí kaweq kaweruyana tagówe. ");
INSERT INTO awb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tagéna Sísaga máhotao úwara mi abáráhrégá sibowáreq wereq arambehriu kereq sípiipéq suera Sísa kéróye. ");
INSERT INTO awb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sega Kápénéáma suwahpeq tunse ahrena ahrena wehekáh Sísaga momiwí nahtápéq kibekéna síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Síwáhnoréna Mósísiga sehgíóro ú ehweh síwáhnoro kegá síwáhnorunserah Sísaga íre miraúwe. Ahqáho. Wega págegeue síwáhnorú púara wene ehweh író kega áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Áhtenuwana owainawanka subiqmaq subiqmarú aní momiwí nahtápéq míowana owainawanka iwíáh atowana anotahtaq mahraréna ");
INSERT INTO awb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Sísao, are Néhsara suwahpeqte ání móne. Arega itewe aneraitaníbo? Iubiq iuanie seno? Are Maniká míéhrabeq kaweqtaq mía míaóna aní móne. Arewe aiq tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Úwana Sísaga owainawansabé awehgu atena wensabé, Ehiya mé we auwe pokúno atowe. ");
INSERT INTO awb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Auwe pokúno atowana owainawanka mi aní kúrugúru atena kareéna we auwena pokúwe. ");
INSERT INTO awb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pokúwara ómi míó kega anotah ahténéra ehmuniq éhmúníréra, Aneqpomo? O ehweh míre. Anotah wahnáh ánínká síwáhnori serahnéna Sísaga págege ehwéhnue owainawankákáqsábé, Miraoro i puara sega wene ehweh apubúue íráhwe uwe. ");
INSERT INTO awb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Moke Kehrari marákórápéq Sísa éhweh apubúue mitaq teri mahtaq terinuwara írówe. ");
INSERT INTO awb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sísareh Sémísireh Sónirehga Asiu kené momiwí nahtápéq suera kure Sáímónireq Ehntarureqne nahupeq kibekuwe. ");
INSERT INTO awb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sáímónine ahrahnawa osoro awahrééna máhriqtaq míowara míó kega Sísa apubúue teawúwe. ");
INSERT INTO awb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Teawúwana Sísaga weba séna ayahnkara táhtoqme iriatowana kaweragúwana táhutahuq tíwe náriuwe. ");
INSERT INTO awb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mi wehekáh íó tupekútaq wehekeqká ómi awahre kereq owainawanka subiqmaq subiqmarú kereq meriqmera Sísaba mórítówe. ");
INSERT INTO awb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mi kehiná suwahpeqte kégá ómi méhpeh sahuríówe. ");
INSERT INTO awb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sísaga áhnte awahreu ke kaweraritena áhnte owáínáwámárí kaqsuowe. Owainawamarínká Sísa tagaríó púana wega se ehiyansá aritowe. ");
INSERT INTO awb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ahyahbinkerotaq Sísaga iriwe ména mitaq suena abatapi kowéna Manikánsabe púrerúwe. ");
INSERT INTO awb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sáímónireq wene iyahnaboreqka koanebahréra ");
INSERT INTO awb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sísa tagéra wensabé, Ómi kegá arensabé anebahrowe teawúwe. ");
INSERT INTO awb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Teawúwana Sísaga sensabé, Mó ke suwahpeqkakáq ehweh teriníboq pokonehe. Terinieéna tumíóge úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sísaga moke Kehrari marákórápéq noginieéna pokéna Asiu kené momiwí nahmárítápéq ehweh teriena owainawamarí kaqsuowe. ");
INSERT INTO awb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Anotah naonkákáq ánínká Sísaba séna áhtenú púana arehunseraráq ména Sísansabé pagu pagunéna, Are awahbáhnaraqmé kaweraintahráhóne úwe. ");
INSERT INTO awb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Úwana Sísaga wensabé arutaboiratena ayahnkahkahrue wenaneq táhtorena wensabé, Aiq mirainauge. Are awaho ani míahno atowana ");
INSERT INTO awb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mina irarútaq wene náonaba apubúue wagúwana kaweragúwana ");
INSERT INTO awb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sísaga eqmaranaútaq wensabé, Írátíahno. ");
INSERT INTO awb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Mó ke teríneho. Írakaumo. Manikáne ehweh mibeq mahbeq aítéh ánípá pokue arene anonka móreawo. Are awaho ani úkire igehboq Mósísiga irarúnserahnue Manikánsabe titirúno éna apubúue eqmaq auwowe. ");
INSERT INTO awb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Eqmaq auwowana kaweragú aninká pokéna kawerato ehweh mitaq teri mahtaq terinúwara áhnte kegá írówe. Áhnte kegá író púana Sísaga mó ke suwahpeq íre korahúwe. Írakaumo. Peh abatapi kowíowara mó marákórápéqté kéreq mó marákórápéqté kéreq áhnte kegá mitaq weba suwe. ");
INSERT INTO awb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sísaga táhmaro wehekáh ména mitaq suena Kápénéáma suwahpeq kouwekúwara wene nahtapeq míéhre mitaq teri mahtaq terinuwara írówe. ");
INSERT INTO awb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Irera áhnte kegá weba sáhatíówara kígíúnsabe mó kegá méhpeh íre míahrahuwana Sísaga kaweq ehwéh teriuwe. ");
INSERT INTO awb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Itaréitaré ánítógá aiayah pukia ání sehgiwera weba suwe. ");
INSERT INTO awb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Séra ahtapeq kutaq áhnte wehekéqká nahupeq kígíúnsabe sega Sísaba íre kioráhéra nahnsorapéq kire Sísane ayahqnonsoraq abogéh piruqmarera abahrabahrútaq aiayah pukia ání wene máhriqkakáq sehitaqmaqme meqmera Sísa míorabeq márunátówe. ");
INSERT INTO awb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sega iwíáhéra, Sísaga kaweratanawire íwíáhuwana wega sene iwíáh tagéna aiayah pukia ánínsábé, Náníbáq móne. Arene ahbabáq aiq kaweratóge úwe. ");
INSERT INTO awb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Úwara Mósísiga sehgíóro ú ehweh síwáhnoro kegá tútuue méra sirupipeq iwíáhéra, ");
INSERT INTO awb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Mi ehwéhmé aneqsabé irariro? Manikánsabe íre kaweq ehwéh atéhre. Ahbabáqsabe insega kaweraritahráhiro? Manikánka webataq wehukene ahbabáqsabe kaweraritahráhire íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sísaga sene sirupipeqté íwíáh wene arupipeq tagéna sensabé, Itewe aneqsabé mira íwíáho? ");
INSERT INTO awb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aiayah pukia ánínsábé aneq ehwéh teawinínkono? Arene ahbabáqsabe kaweratóge teawinínkono? Are irigue arene máhriq mewe ah nogo teawinínkono? Íre págege ehwéhmé ahnabo? ");
INSERT INTO awb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Íné wehukení úku anínká mah marákó márákó wehukene ahbabáq kaweraritahráhuge. Sokigi ainíboq tagaríáhro éna aiayah pukia ánínsábé, ");
INSERT INTO awb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Teawiníboq iro. Irigue arene máhriq mewe arene nahtapeq pokúno úwe. ");
INSERT INTO awb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pokúno úwana irigue wene máhriq apubúue mewena pokúwara ómi míó kega tagéra áhtenue Manikánsabe íwíáh íwíáh atera, Mahna tahnsa morá ibora tagóne uwe. ");
INSERT INTO awb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sísaga Kehrari kawéhú ayehráq mó kúwara ómi míó kega weba sáhatíówana Manikáne ehweh síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sísaga mitaq suena ahtapeq nogutaq táhkísi moné meyo aní wenáwíq Áríwái tagówe. Áríwáiwe Ápíásane ahninkáwá táhkísi moné meyo nahtápéq tútuue míowana Sísaga wensabé, Íné séniro úwana Áríwáiga irigue kérowe. ");
INSERT INTO awb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Áhnte táhkísi moné meyó kereq mó ahbabáq kereqka Sísa kérónsabe Sísaga Áríwáine nahtapeq táhutahurútaq mi kegá Sísareq we kéró kereq táhutahuruwe. ");
INSERT INTO awb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Táhutahuruwara Mósísine ehweh síwáhnoru Péhrasi kegá minayabe tagéra Sísa kéró keyabé kasenéra, Sísawe aneqsabé táhkísi moné meyáh kéreq ahbabáq kereq moráráq táhutahuriro uwe. ");
INSERT INTO awb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Uwana Sísaga mi ehwéh irena sensabé, Sótehga awaho wehuké máráhsíni íre náriasa peh morá awahre ke náríre. Mina inserah ínéwé kaweqtaq míáh ké séhréh aritanieéna íre suge. Peh ahbabáq ke kaweraritanieéna suge úwe. ");
INSERT INTO awb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sóni kéró kereq Péhrasi kereqka táhutahuq awehriutaq wehukega Sísaba séra kasenéra, Sóni kéráh kéreq Péhrasi kéríráh kéreqka táhutahuq awehriowara aneqsabé are kéráh kégá íre awehrioo uwe. ");
INSERT INTO awb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Uwana Sísaga sensabé pabeqme ehwéh teriena, Pahuwirotaqmé o menáhwé wene iyahnabo ba míéhtáqmé táhutahuq awehrioo? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mókake o menahwé seba íre míahnaraqmé mi tanáhráq wene iyahnaboga sirutaboiréra táhutahuq awehrigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sísaga mó pabeqme ehwéh mahraréna, Wehukenínká nahonáh sáhkétí kawerinieéna o ambántáráté íre párúwe kawerire. Miraitaq tahirímé nahonáh sáhkétí subanki irino. ");
INSERT INTO awb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wehukenínká o nahníáq sera ano naho naho méméné áúyahwa antehyápípéq íre ahkíre. Miraitaq tahirímé sera anonka muinaraq nahonáh ántéhyá tapoagirana sera ano marakóraq antigi irino. Wehukenínká o será ano o antéhyápípéq ahkíre. Wehukega ahkírataq mi tehtáré náneqme kawerue kanae. O será anome kawerue kanae. Antehyamé moq kawerue kanae úwe. ");
INSERT INTO awb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ahrena ahrena wehekáh Sísareq we kéró kereqka páréti mirao naneq será sotápéq kótaikutaq we kéró kega mi será késabaríqme késabaríqmeue kuwe. ");
INSERT INTO awb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kuwara Péhrasi kegá Sísansabé, Are kéráh ké tagáhno. Ahrena ahrena wehekáh íre mirao sansámé sewe aneqsabé miraoo uwe. ");
INSERT INTO awb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Uwana Sísaga sensabé, Itewe Manikáne púkuipéqté séhírámé Tébítireq we kéró kereqka tabonahéra sirupibiútaq mirau sansámé íre sáhnsahwe ahtebaho? ");
INSERT INTO awb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wehukení wenáwíq Ábíátawe Manikáne ehweh mibeq mahbeq arito aní míotaq Tébítiga Manikánsabe iwíáh íwíáh atáh náhúpéq kibekéna Manikánka tagankeheéra máró parétí mewe néna we kéró ke náriuwara sega moq nowe. Mósísine ehweh irarunka mi parétíwé pehipéqté kégá íre nah nanere. Peh morá Manikáne ehweh mibeq mahbeq arítáh kégá nahrahowe ire. tega mi sehirá íre sáhnsahwe ahtebaho úwe. ");
INSERT INTO awb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sísaga Péhrasi keyábé mó mahraréna, Ahrena ahrena wehekáh ko púana Manikánka wehuke miraroo? Írakaumo. Wehuke míó púana ahrena ahrena wehekáh mirarowe. ");
INSERT INTO awb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Íné wehukení úku anínká ahrena ahrena wehekáhnkákáq wahnah wahnahnuge úwe. ");
INSERT INTO awb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sísaga Asiu kené momiwí nahtápéq mó kibekúwana sawenkahnia áyáhnkákáq ání míowe. ");
INSERT INTO awb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Míowara Péhrasi kegá Sísa ehweh ataneheéra ahrena ahrena wehekáh Sísaga mi aní kaweratanabiramo éra ebitíówe. ");
INSERT INTO awb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ebitíówana Sísaga sawenkahnia áyáhnkákáq ánínsábé, Ínéba sewíahno éna ebitíó keyabé, ");
INSERT INTO awb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mósísiga sehgíóro ú ehwehnkáwé ahrena ahrena wehekáhnsábé anere teiro? Wehuke kaweraritanéhnkono? Íre kaweraritanéhnkono? Wehuke séhréh aritanéhnkono? Subiq suanéhnkono úwara se ehiya míówe. ");
INSERT INTO awb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Se sawenkahnia áyáhnkákáq ánínsábé íre sirutaboiria sirupipeq págegeunsabe Sísane arupipeq umeh agúwe. Umeh agúwana wega se ebitáwéna abiahnsa aritena sawenkahnia áyáhnkákáq ánínsábé, Arene ayahnkara obariro úwana wene ayah obarirowana kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kaweragúwara Péhrasi kegá tueague Érótine iyahnaboreqka momiwíue sío síoéra, Sísawe árahue subiq suanéhnkono uwe. ");
INSERT INTO awb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sísareq we kéró kereqka mitaq suera káwehu ayehráq pokuwara áhnte Kehrari marákórápéqté kégá we kérówe. ");
INSERT INTO awb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kehrari marákórápéqté kéreq Súría marákórápéqté kéreq Sarúsarama suwahpeqte kéreq Írúméa marákórápéqté kéreq Táíya suwahpeqte kéreq Sáíróna suwahpeqte kéreq Sorana aroipéq seberaebéqté kéreqka áhnte kehinánká Sísaga miraúnsabe irera weba suwe. ");
INSERT INTO awb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Áhnte kegá sunsabe Sísaga we kéró keyabé, Áhnte kegá pagunúéhboq sípi wahtotaq mewe sero úwe. ");
INSERT INTO awb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Áhnte awahre ke kaweraritonsabe moke mó awáhré kégá Sísa táhtoraneheéra pehentáwe sunsabe Sísaga we kéró keyabé mi ehwéh teriuwe. ");
INSERT INTO awb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Owainawamarínká Sísa tagéra wensabé áhreu puara arehunseraráq méra anotahtaq mahraréra, Are Manikáne ahninkáwá wóne uwana ");
INSERT INTO awb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sísaga sensabé abiah matawéna, Íné éhweh irariyehboq ehiya míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sísaga sáwéhrapeq pokéna wega omaq siteyabe awahbó ke síáhrabúwara weba kíúwe. ");
INSERT INTO awb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kíúwana airápété téhraníté weba míageheéna omaq sitowe. Sensabé eqmaro kee síwíraritena mi kegá ehweh koreri terinigeheéna omaq sitowe. ");
INSERT INTO awb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Sega owainawamarí kaqsuageheéna págege atena omaq sitowe. ");
INSERT INTO awb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wega omaq sito kewe Sáímóniwe mó awíq Pítae ue áwíratena ");
INSERT INTO awb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","se ábárahré Sébérine ahninkáwáráré Sémísireq Sónireqsabé Póánégie ue síwíraritowe. Mi awíq áwahewé puruburu aníté tahnsane ue síwíraritowe. ");
INSERT INTO awb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ehntaru, Pírípi, Pátórómíyu, Mátíyu, Tómáhsi omaq sitena Sémísi Ápíásane ahninkáwá omaq atowe. Sáímóniwe we Kénáni marákórápéqté ánínseq Táríásareq omaq sitowe. ");
INSERT INTO awb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Súrása we mó awíq Ísíkáríóti Sísane naruo koweriranaú anínseq omaq sitowe. ");
INSERT INTO awb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sísaga nahupeq kibekúwara áhnte wehekéqká weba mó kiranéhnatíówe. Mitaq kígíunsabe Sísareq we kéró kereqka íre táhutahurorahuwe. ");
INSERT INTO awb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sísa awahrahga minayabe írótaq, We uwoyansa aní úkire éra we koweraneheéra suwe. ");
INSERT INTO awb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sarúsarama suwahpeqte Mósísine ehweh síwáhnoro kegá seye náhenéra, Pésébúri, owainawane wahnahnka Sísa págege atena séhréh atéh púana Sísaga owainawa kaqsuahráhire éra ehmuniq éhmúníruwe. ");
INSERT INTO awb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ehmuniq éhmúníruwana Sísaga sensabé, Ínéba sewíáhro éna pabeqme ehwéh mahraréna, Owainawanka wewe árahue kaqsuankéhbo? ");
INSERT INTO awb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wahba marákórápéqté kégá seye ebehirataq sainkoneherawoe. Minayabe se págegeue morá ké íre míahrahowe. ");
INSERT INTO awb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sensuwahrahreq seye ebehirataq sainkoneherawoe. Minayabe se págegeue morá ké íre míahrahowe. ");
INSERT INTO awb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Owainawanseq wenawahrahreq ebehotaq tahirímé se sainkéra págegeue morá ké íre míahraho irino. ");
INSERT INTO awb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wehukenínká ayahnsa kira wéhné ménsámehnsá meyanieéna wene nahupeq pehipi íre kibekorahire. Írakaumo. Ebeqme wega ayahnsa kira wéh táhtoqme táhru táhruarena anehe wene nahtapeqté ménsáméhnsá pehipi meyahráhire úwe. ");
INSERT INTO awb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sísaga mó mahraréna, Teiníboq írátíáhro. Ahbabáréra Manikánsabe abehq éhwéh atáh kéwé Manikánka mi ke kaweraritahráhéna mi ahbábáq íre ahreraq matiankehe. ");
INSERT INTO awb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Peh morá Manikáne Awansabe abehq éhwéh atéh ánímé Manikánka mi aní íre insahwé atankéhe. Mi ahbábáq peh ahreraq matiankehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sega, Owainawanka Sísa séhréh atéhre unsabe Sísaga mi ehwéh irarúwe. ");
INSERT INTO awb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sísane anowareq ábákawaréhreqka séra máhpeq iriwe méra mó keyábé, Sísansabé, Mahbeq tuo teawéro uwe. ");
INSERT INTO awb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Uwara áhnte wehekéq weba sáhatawéra wensabé, Arenanoreq arenábáqmarinseq máhpeq méra arensabé áhrabowe uwe. ");
INSERT INTO awb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Uwana Sísaga sensabé, Náinoreq náníbáqmarinseq inseréhbo éna ");
INSERT INTO awb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","weba sáhatíó ke tagéna, Itewe náinoreq náníbáqmarinseq móe. ");
INSERT INTO awb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maniká awahbeh arámbéhrí mirao kewé náníbáqmari móe. Náinahnoreh wóe. Náinoréh wóe úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sísaga káwehu ayehráq tunse mó síwáhnorúwe. Síwáhnorúwara íregáritaq weba sáhatíó púana wega wánípipeq ko sipíípéq kibekue tútuue míowe. Tútuue míowara moke míó kega arahwéraq míówana ");
INSERT INTO awb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","wega áhnte pabeqme ehwéh síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Síwáhnoréna, Teiníboq írátíáhro. Ayu suitabé aninká ayu suitabanieéna pokire. ");
INSERT INTO awb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Suitabehtaq mó ayú ahtaq megirana kabaranka sésiq nehre. ");
INSERT INTO awb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mó ayú kiruraq megirana pehgáriq marákó kéh púana mi ayú apubúue kiapoue kíréhre. ");
INSERT INTO awb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Anotah patáhitaq tamurupague ánúq píéh púana ehyatagire. ");
INSERT INTO awb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mó ayú náwe tarúítáq megirana náwe kirena kárígariirana íre kawerue kíréhre. Minayabe sera íre íyéhre. ");
INSERT INTO awb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mó ayú kaweq marákóráq megirana kiapoue kirena áhnte será íyéhre. Mó ayú 30 íyéhrana mó ayú 60 íyéhrana mó ayú 100 íyéhre. ");
INSERT INTO awb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Íre parosa áhréákáq kéo, kawerue íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Áhnte kegá íre míótaq airápété téhraníté Sísa kéró kereq mitaq míó kereqka pabeqme ehwéhnsábé áwahe kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kasenuwana Sísaga sensabé, Manikánka wahnah wahnahnirabeqte éhwéhmé áwahe ite sokigi aiena mó ke peh pabeqme ehwéh teri terinuge. ");
INSERT INTO awb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Minayabe mó kegá siuranka tagéra sirupipeq íre tagariahrahowe. Sene siahrega irera sirupipeq íre írátíahrahowe. Minayabe sene ahbabáq sansa peh kéhrana Manikánka sene ahbabáq íre kaweraritena peh ahreraq matiankehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sísaga sensabé mó mahraréna, Ite mah pabéqmé éhwéh íre iraho? Mó pabeqme ehwéhmé árahue iranéhbo? ");
INSERT INTO awb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ayume Manikáne kaweq ehwéhne. Ayu suitabé anínká mi kawéq éhwéh teri terinire. ");
INSERT INTO awb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ahtapeq megi ayúmé wehukega Manikáne ehweh íráhwana owainawanka sirupipeqté mi ehwéh apubúue seaebóire. ");
INSERT INTO awb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kiruraq megi ayúmé apubúue kiapoinserah wehukega Manikáne ehweh irera sirupipeq eyoyóéra apubúue kowe atáhwe. ");
INSERT INTO awb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Manikáne ehwehnka sirupipeq íre ánú píéhnsábé pehgáriq tanáhráq sehgíówe. Manikáne ehweh sehgíónsábé mó kegá síwíoqnahwana íre kaweq sunúq sire. Mi tanáhráq sega apubúue túbáh agéra Maniká áúwáhwe. ");
INSERT INTO awb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Náwe tarúítáq megi ayúmé wehukega Manikáne kaweq ehwéh irera sehgionehe íwíáhéra ");
INSERT INTO awb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mah marákó márákóípéqté náneqsabé iwíáh kikiréra sene áhnte matíáh ménsáméhnsánsábé sirutaboirowana mó mensáméhnsánsábé aigárá pabekire. Náwe soagirana sera íre íyéhmé mi kegá Maniká awahbeh sansá íre sehgiowe. ");
INSERT INTO awb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kaweq marákóráq megi ayúmé wehukega Manikáne ehweh irera sirupipeq tábúsoqme iwíáhowe. Kaweq marákóráq kaweq será íyéhnserah sega mi ehwéh sehgiera Manikáne arambehri kawerue miraowe. Kawerue miraéra mó kegá 30 tahnsá árámbéhríowara mó kegá áhnte 60 tahnsá kaweq arámbéhríowara mó kegá peh íregáritaq 100 tahnsá áhnte kaweq arámbéhríowe úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sísaga sensabé mó mahraréna, Áráhmu mewe setaq eheq maraho? Antehyatáté áráhmu íre akariaráhwe. Máhriq tahbé tehnopeq íre máráhwe. Írakaumo. Kaweruwe téhrankeheéq peh tahberapeq maráhwe. ");
INSERT INTO awb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Amahnága moke kopípéq kéh náneqme mókake ábóraq kanae. Moke akariuríéh náneq moq ábóraq kanae. ");
INSERT INTO awb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Íre parosa íáhréákáq kéo, kawerue íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sísaga sensabé mó mahraréna, Itega íréhra ehwéh iwíáhue íráhro. Itega mó ke náríranserah Manikánka mina tahnsanue náinkéhe. ");
INSERT INTO awb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Matíéh ání Manikánka mó náwinkéhe. Íre matíéh ánímé Manikánka wene pehgáriq naneq meyankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sísaga mó mahraréna, Manikánka wahnah wahnahnime wehukenínká ayu marakóipeq suitabehnserahne. ");
INSERT INTO awb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Inokáhpeq sugayugaéna ahbiahipeq irigéna wene arambehrirana ayume kiapoue kíréhre. Kiapoue kíréh sánsámé suitabeh anínká íre ahtebehre. ");
INSERT INTO awb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Marakóga mirainka ménsámehnsá kirena íyéhre. Ebeq ánáh kiapoue kirena anehe sera iyena nera kéhre. ");
INSERT INTO awb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ménsámehnsá nera kéhtáq pokatate serame apiwe meyáhwe. Nera kéh púara apiwe meyáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sísaga mó mahraréna, Manikánka wahnah wahnahnime aneq tahnsáne teinínkono? Minayabe aneq pabeqme ehwéh teinínkono? ");
INSERT INTO awb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Manikánka wahnah wahnahnime sotápéq uqmaréh ayu tahnsane. Mi ayúmé íre mó sotápéqté áyú tahnsane. Írakaumo. Mi ayúmé pehgáriq ayúne. ");
INSERT INTO awb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wehukenínká mi pehgáríq áyú wene sotápéq uqmatairana kirena anotah awánká úkéna moke mó mensáméhnsá kiotaikire. Awankánirana anotah ayáhnáwé kéhrara kabaramarínká ayahnaweraq surahéra sene nah mitaq áhpeq píáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sísaga áhnte mina tahnsa pabeqme ehwéhnue Manikáne ehweh teriuwe. Sirupipeq mi ehwéh iwíáhue irahráhunserahnue teriuwe. ");
INSERT INTO awb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","We kéró keyabé epéq moke pahsuqme síwáhnoréna peh mó keyábé pabeqme ehwéh teriuwe. ");
INSERT INTO awb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mi wehekáh tupekinaútaq Sísaga we kéró keyabé, Káwehu seberaebéq pokonehe úwara ");
INSERT INTO awb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","we kéró kega mibeq sáhuríó ke suera Sísa mío sipí kéwewera Sísa meqmera kuwe. Mó sipíwárínkákáq moráráq kuwe. ");
INSERT INTO awb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Anotah soírírúwana wánínka sípiipéq kiegambeh agu aguúwana sípiipéq wání obenkíkinaútaq ");
INSERT INTO awb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sísawe sípi ambarupéq ayahqno kunubaraq sugowe. Sugowara sega Sísa iriatera wensabé, Íwáhnoraníno, ite wánípipeq pukonehe únayabé anetaníbo íwíáhono uwe. ");
INSERT INTO awb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Uwana Sísaga irigéna sóiriqsabé, Táqnáigúno éna wánínsabe, Pehwehrue mé túbáh agúno úwana sóiriqka táqnáigúwana wánínka moq túbáh agúwe. ");
INSERT INTO awb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Túbáh agúwana wega sensabé, Aneqsabé áhreoo? Aneqsabé ínénsabe íre aiq pútare aintaho úwara ");
INSERT INTO awb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","sega anotahtaq áhreéra seye náhenéra, Mah anímé insebo? Sóiriqkakáq wánínkakaq wene ehweh íréhre uwe. ");
INSERT INTO awb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sísareq we kéró kereqka sípi kéwewera kure Kehrari kawéhú seberaebéq Kérása kené marakórápéq kuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sísa sípiipéqté tueagúwana mibeqté ánímé owainawanka subiqmaq subiqmarú aninká wehuke maisia ónámárípípéqté séna weba súwe. ");
INSERT INTO awb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mi anínká maisia ónámárípípéq kaegaeuwara wehukega wene aigárátáq ayahnkaratáq séniraté táhru táhru aruqaruruwana suraqsu suraqsurú púara íre saiqnariahrahuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wene ayahpite séní sabirue surasuq surasuréna wene aigárápíté séní piteruq piterurúwe. Sega táhtorótaq íre ambubu atiahrahuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Inokáhpeqkakáq wéhékáhnkakaq ahriahri we maisia ónámárípípéqté sáwéhrapeqté kare kareéna kenkawéhrate wene anonka amurúruqme kirasuq kirasurúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sísaga sípiipéqté kiuwana mi anínká móbeqte we tagéna pehbeheráh weba sure wensabé áhtó púana arehunseraráq sewíowe. ");
INSERT INTO awb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sewéna kareéna, Sísao, are íópeqté Manikáne ahninkáwá wóne. Aneraintaníbo? Íópeqté Manikánka tagaríéhtáq níéraníneho úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sísaga wensabé, Owainawano, we auwe pokúno atonsabe mi ehwéhnsábé kareúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kareúwana Sísaga wensabé, Arenáwíq tenio úwana mi anínká, Ite áhnte míonayabé néníwíq Íregáritare éna ");
INSERT INTO awb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sísansabé, Ite mahtaqté kaqme íre wahto eqmaq iuwehneho úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wahtotaq sáwéhrapeq íregáritaq poeráhqká náwe sahtaqme nowara ");
INSERT INTO awb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","owainawamarínká Sísansabé, Mi poeráhqmárípá eqmaq iuwo éra, Póéráhqne sirupipeq míanehboq ite pokoro aito éra pagu pagunuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pagu pagunuwana Sísaga kowe aritowara owainawamarínká wehukení auwera póéráhqmariné sirupipeq kowíówara 2táhúséni (2,000) póéráhqmárínká sáwéhrapeqté pehbeheráh tunse mentúpipeq wánínkuwe pukuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Póéráhqtaq wahnahnu kegá tagéra pehbeheráh pokue sotápéq míó kereq sene nahtapeq míó kereq koreríúwara seraganeheéra suwe. ");
INSERT INTO awb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sísaba suwana owainawamarí kaqauwo aninká kaweq iwíáhorahéna aneranerue tútuue míowara su kegá tagéra áhreuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Áhreuwara tago kegá kawerato ehweh su ke teriera póéráhqmari puku ehwéh teríúwara ");
INSERT INTO awb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","sega Sísansabé, Itene marakó sue pokúno éra pagu pagunuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sísa sípiipéq kiasague pokinaútaq owainawamarí kaqauwo anínká wensabé, Íné are kéraníe úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kéraníe úwana Sísaga ahqáho atena wensabé, Arenawahpeq pokue íné arene Wahnahnka arensabé nirutaboirue kawerató éhwéh arenawahrah korerio úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Úwana wega pokue Tékápórísa marákórápéq mó ke suwahpeq mó ke suwahperue Sísaga we kawerato ehweh koreri terinuwara moke író kega áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sísaga sípi kéwewena kure Kehrari kawéhú seberaebéq seuwekúwara áhnte wehekéq weba sáhuríówe. Káwehu ayehráq míówana ");
INSERT INTO awb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Asiu kené momiwí nahtápéqté wáhnáh ání Sáírúsaga mitaq séna Sísa tagéna áhtó púana wene aigárápí káuqmunue arehunseraráq ména wensabé, ");
INSERT INTO awb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nániyahu pukinaire. Wenaneq koráhtoréhnana kaweraginkehboq máho. Oga míankehboq máho éna pagu pagunúwana ");
INSERT INTO awb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sísaga we kérowe. We kérowara áhnte kegá moráráq kure Sísa kú ahtápéq we pehentáruq we pehentárurue kuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Awahre iní kure airápété téhtaré ópéq áhnte opéq wene korahq íre taraqnágia peh tuerueúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Peh tuerueúwana wega áhnte sotéh kébá poku pokuúwara sega we áhnte érawúwana wene móne sinsinue parabaruowana íre kaweragúwe. Írakaumo. Anotah íroke awáhréúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mi inínká Sísa éhweh irena áhnte kegá moráráq kutaq ");
INSERT INTO awb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","wewe náhenéna, Íné peh wene korósi koráhtoráhnaraqmé kaweraintankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Áhnte wehekéqká kígíuwana awahre inínká Sísa anehepeq sure wene korósi koráhtorowe. Koráhtorowana wene korahq apubúue taraqnágúwana wene arupipeq iwíáhéna, Íné aiq kaweraintéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Úwana Sísaga iwíáhéna, Ínéga inse kawerauwogo éna pabeqme, Néne korósi insega táhtorehro kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kasenúwara we kéró kega Sísansabé, Áhnte kegá are paguno púah aneqsabé, Néne korósi insega táhtorehro eno uwe. ");
INSERT INTO awb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Uwana Sísaga táhtoro aní taganieéna aurankaúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kawerato ininká, Íné aiq kaweraintéhre éna áhre iransánéna Sísaba sure arehunseráráq sewéna moke teawuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Teawuwana Sísaga wensabé, Náinahnoo, arega aiq pútare aintahnaga kaweratóge. Are awaho ani míaniewóne. Pehwehrue pokéwahno úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pehwehrue pokéwahno úwara wahnah aníné nahtapeqté táhmaro kegá sure abowansabé mahraréra, Areniyahu aiq pukire. Aiq puki puah síwáhnori anínká sinsabé ahqáho ato uwana ");
INSERT INTO awb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sísaga sene ehwehnsábé íre iwíáhia abowansabé, Íre áhreúno. Peh aiq pútare ainto éna ");
INSERT INTO awb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","áhnte we kéró keyabé, Mahtaq míáhro aritena peh morá téhq abáráhré Sémísireq Sónireq mó aní Pítareq meriqmena pokúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pokue mi wahnáhné nahtapeq sutaq irobibiu ke tagówara áhnte ibiséra anotah ibítúnátúnánuwe. ");
INSERT INTO awb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ibitunátúnánuwana Sísaga nahupeq kibekéna irobibiu keyábé, Aneqsabé áhnte ehwehnéq ibitunátúnánoo? Mah ahrárí íre airaiq pukia peh sugéhre úwara ");
INSERT INTO awb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","sega awiréh atówe. Awiréh atówana Sísaga ómi míó ke máhpeq kaqsuena mi ahráríné anoiboreq we kéró kereq meriqmena ahrarine máhriqtapéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pokéna wene ayahnkara táhtotawéna wewene ehwehtaq mahraréna, Tarita kumie úwe. Tarita kumie úmé, Ahrario, ínéga teawúge. Irigúno úwe. ");
INSERT INTO awb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Irigúno úwana wega apubúue irigéna ah noguwe. Mi ahráríné ópeqme airápété téhtaré ópéq míotaq pukuwana Sísaga iriatowe. Iriatowara tago kegá áhtenuwana ");
INSERT INTO awb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sísaga sensabé, Mó kegá íréhboq íre teríéro éna wenanoibonsabé, Iteriyahu táhutahuq náwétao úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sísaga mitaq suena wenawahpeq pokúwara we kéró kega kérówe. ");
INSERT INTO awb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ahrena ahrena wehekáh Sísaga Asiu kené momiwí nahtápéq síwáhnorúwara áhnte író kega áhtenuwe. Áhtenéra mahraréra, Wega irari ehwéhmé eheqte ehwéhpo? We árahue ahtebia ání úkurairo? Wega ótaq sansámárí árahue mirairo? ");
INSERT INTO awb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","We peh nah pe tagaríéh ání míre. We Máhríane ahninkáwá wíre. We Sémísireh Sósépareh Súrásareh Sáímónirehne siwahwá wíre. Wenanahnoreh mahtaqté ánímárí móe éra wensabé abiahnsa atówe. ");
INSERT INTO awb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Abiahnsa atówana Sísaga sensabé, Manikáne ehweh irari anínsábé mó ke suwahpeqte kégá iwíáh íwíáh atáhwe. Peh morá wenawahpeqte kéreq wenawahrahreq wene nahtapeq kaegaeo kereqka wensabé íre iwíáh íwíáh atáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mibeqté kégá wensabé íre aiq pútare ató púana wega mitaq ótaq sansá íre áhnte miraorahúwe. Peh táhmaro awahré ké táhtorena kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wensabé íre aiq pútare atónsabe Sísaga áhtenúwe. Sísaga mó kehiná suwahpeq mó kehiná suwahperue kosíwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wega we kéró ke airápété téhranítéyábé síáhrabéna mó mi aníté mó mi anítéue eqmaq suowe. Eqmaq suanaútaq owainawamarí kaqsuageheéna wega págege aritena ");
INSERT INTO awb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","sensabé, Ite ahtapeqsabé tópahme unahmé mónewe íre meyáhro. Peh morá pegiqnáhnkara meweq ");
INSERT INTO awb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","súu sukiwe pokoro. Téhtaré síótí íre sukíóro. ");
INSERT INTO awb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ite mó ke suwahpeq kirataq peh morá áníné nahupeq kaegaeoro. ");
INSERT INTO awb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wehukega ite íre mehweh aitera itene ehwehnsabé iuwahriehre irataq sene nah sueq itene igárátáq kahna tanáhúq poruarueq pokoro úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Úwara eqmaq suo kega pokue mó kehinánsábé mahraréra, Kaweraitankéhboq itene ahbabáq sansa sueq kaweqtaq míáhro teri terinuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sega áhnte owáínáwámárí kaqsuera awahre ke óríwi awánká sérá ano abaq sitera kawerarítówe. ");
INSERT INTO awb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sísa éhweh mitaq teri mahtaq terinuwana anotah wahnáh ání Érótiga irowe. Táhmaro kegá iraréra, Sóni wání meri merini aní pukéna mó oga úkurai puana amahnága págege otáq sánsánire uwe. ");
INSERT INTO awb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Uwara mó kegá, We Éráísa wire uwara mó kegá, We Manikáne ehweh irari anímé naho Manikáne ehweh iraru ke tahnsa aní míre uwe. ");
INSERT INTO awb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Uwana Érótiga Sísa éhweh irena mahraréna, Ínéga ayahqno kiraq áúwátáu anímé Sóni we mó oga úkuraire úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sóni oga míotaq wega Érótinsabé ehweh atena mahraréna, Arenábáqne ahre meronawe Mósísiga sehgíóro ú ehweh aiq anterutone úwe. Érótíga wenábáq Pírípine ahre Éróríása meyonsabe Sóniga wensabé ehweh atowana meyo inínká mi ehwéhnsábé ayehitónsabe Sóni abiahnsa atowe. Abiahnsa atowana Érótiga sóntía keyabé, Sóni táhtoqme karábúsiipéq móátáhro úwara táhtoqme karábúsiipéq móátówe. ");
INSERT INTO awb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Móátówana mi iní Éróríásaga Sóninsabé abiahnsa atataú púana Sóni subiq suaníe íwíáhúmé íre miraorahúwe. ");
INSERT INTO awb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Érótiga Sóninsabé áhtenéna iwíáhéna, We íre ahbabáq ani peh kaweqtaq mía míai aní míre éna, Pehragahro únsabe mó kegá Sóni íre subiq suahráhuwe. Érótiga Sónine ehweh irotaq iwíáh kikiréna peh Sónine ehweh ireyabe awahbówe. ");
INSERT INTO awb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Érótine anowagá we maqmio ahreraq ko tanáhráq sútaq wega anotah tahutáhúq kawerarena wahnah wehwárínseq sóntía wahnáh wéhwárínseq Kehrari marákórápéqté áhnte moné ko wehwárínseq kirabo aritowe. ");
INSERT INTO awb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Éróríásane ayahunkawagá seba séna ábáhrúwara Érótireq weba táhutahuru kereqka ábáhrúnsabe áhnte iwíáh íwíáhuwe. Minayabe Érótiga mi ahráríyábé, Arega nánio ina naneq náwiníe. ");
INSERT INTO awb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pópoqnahga tagaríéhtáq aiq pútariahnsanuge. Arega nánio ina naneq náwiníe. Wahnahnu naneqsabé ákáhtaq nánio inaraqmé náwiníe úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Úwana ayahunkawagá tueyokue wenanonsabe, Aneq nánio ininkono úwana wenanoga, Sóni wání meri merini aníné ayahqno nánio úno úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Úwana wega pehbeheráh kibekéna Érótinsabé, Íné Sóni wání meri merini aníné ayahqnonsabe níre. Amahnága kunubaipéq maqme nánio úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nánio úwana Érótiga mi ehwéh irotaq wene arupipeq áhnte umeh agúwe. Pópoqnahga tagaríéhtáq awinauge ú púana wene arupipeq iwíáh kikiruwe. Ínéreq táhutahuro kegá néne ehweh íráh púana niyehitéhneho éna, Mi ahráríyábé íre ahqáho atahráhúwe. ");
INSERT INTO awb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Minayabe wega sóntía anínsábé, Sónine ayahqno kogiraqme mewe súno éna apubúue eqmaq suowana tunse karábúsiipéq Sónine ayahqno kiraq suowe. ");
INSERT INTO awb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kiraqme kunabaipéq maqme mewe séna mi ahrárí awuwana wenano móawuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sóni kéró kega we subiq súó ehweh irera sure wene anonka sesehgiwera maisia ónápípéq móárówe. ");
INSERT INTO awb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sísaga eqmaq suo kega weba kouwekéra sega mirau ehwéhnkákáq síwáhnoru ehwéhnkákáq moke teawúwe. ");
INSERT INTO awb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Íregáritaq kéra séra unsabe Sísareq we kéro kereqka íre táhutahurorahu puana Sísaga sensabé, Máhoro. Ahrenagehboq itebataq abatapi pokonehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Minayabe sípi kéwewera kure sebataq abatapi pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pokuwara áhnte kegá sípi tagéra, Sísareq we kéró kereq aiq tagóne éra sensuwahpeq suera peh marakóipeq pehbeheráh kure Sísa kinaúrabeq kuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sísaga koráwégútaq áhnte wehekéq tagéna sensabé arutaboiraritowe. Íre wahnahnkakáq sípísípíq tahnsa míó púana sensabé arutaboiraritena áhntetaq síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Íó tupekinaútaq we kéró kega Sísaba séra wensabé, Mótaq penkinae. Mahtaq peh abatapi púah ");
INSERT INTO awb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","mah kegá so kéh márákóráq wahtotaq kehiná suwahpeq táhutahuq kobaiqmaragéhboq eqmaq suo uwe. ");
INSERT INTO awb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Uwana Sísaga sensabé, Itega mah ke táhutahuq kirabooro úwara sega wensabé, Ite áhnte moné 200 Kína meweq páréti kobaiqmaqme kiraboonehnkono uwe. ");
INSERT INTO awb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Uwana wega sensabé, Páréti árahue kehro? Koragahro úwara sega kosáhnsahera Sísansabé, Párétiwe moberíáh kéhre. Pahme téhtaré kéhre uwe. ");
INSERT INTO awb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Uwana Sísaga míó keyabé, Narunarunitaq isepí kiria mahpi kiriaue tútuue míáhro úwara sega miraue tútuue míówe. ");
INSERT INTO awb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Áhnte ke 100 wehekéq morabí isepí tútuue mía 50 wehekéq morábí mahpi tútuue míauwe. Miraue kiranéhnue tútuue míówe. ");
INSERT INTO awb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sísaga mi moberíáh párétíákáq téhtaré páhnkákáq mewena íópeq tagéna Manikánsabe, Kaweróne atena páréti keqme we kéró kega kiraboigeheéna náriuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Náriuwara ómiga nowana siyahbankirowe. ");
INSERT INTO awb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Siyahbankirowara páréti arahqkakaq pah arahqkakaq airápété téhtaré páhsíkétí úsawe obenkíq márówe. ");
INSERT INTO awb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mi tahutáhúq no wehwé íregáritaq 5táhúséni (5,000) weh wóe. ");
INSERT INTO awb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Míówana Sísaga we kéró keyabé, Sípiipéq kiasagoro. Seberaebéq ite nonótáh Pétásáíra suwahpeq pokoro éna apubúue eqmaq suena míó keyabé, Iteruwahpeq pokoro éna ");
INSERT INTO awb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","mitaq suena púrerinieéna sáwéhrapeq kiuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Penkútaq we kéró kega sípiipéq káwehu ákáhpi míówana Sísaga webataq marakóipeq míowe. ");
INSERT INTO awb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Míowara siuratapeqté anotah soirírúnsabe awankátate wání subame kéra ahyanahyanuwana sóiriqka saiqnówana tagówe. Ahyahbinkerotaq Sísaga wání abobóráhtaba seba kure kótaikinaútaq ");
INSERT INTO awb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","sega we tagéra, We wahnsa wíre íwíáhéra kareuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ómiga we tagéra anotah ahrééra kareuwana Sísaga sensabé, Pehitaq míáhro. Íné úge. Íre áhreoro úwe. ");
INSERT INTO awb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sísaga sípiipéq kiasagéna sereq kiwíowana sóiriq táqnáigúwara sega anotah ahténuwe. ");
INSERT INTO awb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Áhtenéra páréti keqme kiraboúnsabe sirupipeq íre iwíáhia peh íre irasa míówe. ");
INSERT INTO awb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sega sípiipéq kure seberaebéq kéráwégue Kénésáréti marákórápéq kure mitaq sípi arahwéraq móárówe. ");
INSERT INTO awb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Móárówara míó kega tagéra, Sísa wire éra ");
INSERT INTO awb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","pehbeheráh sensuwahrahba pokue, Sísa míéhre mitaq teri mahtaq terinuwara awahre ke sene máhriqkakáq meriqmera weba mórítówe. ");
INSERT INTO awb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sísaga moke mi ke suwahpeqkakáq moke táhúnipéqkákáq úpeqkakáq nogutaq sega awahre ke máhkétirapéq mórítówe. Móritera Sísansabé pagunera, Awahre ke arene korósi aiq táhtoragéhe uwara wene korósi táhtoró ke moke kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Péhrasi kereq Mósísine ehweh síwáhnoro kereqka Sarúsarama suwahpeqte sure Sísaba sáhatíówara ");
INSERT INTO awb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","we kéró kega siyahnkara íre pabeq paberia pehipi nowara tagowe. ");
INSERT INTO awb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Péhrasi kereq moke mó Asiu kereqka sinahbúwáréhne sansá sehgiro puara ahriahri ebeq siyahnkara pabeq paberaruera anehe táhutahuq aruqaruruwe. ");
INSERT INTO awb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Máhkétirapéqté séyéutaq sega ebeq mósosuera anehe táhutahuruwe. Sega sinahbúwáréhne sansá áhnte mó sansá miraéra káhpuwe antehyamé tíniwe pabeq pabeq aruqaruruwe. ");
INSERT INTO awb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Péhrasi kereq Mósísine ehweh síwáhnoro kereqka Sísansabé kasenéra, Iteinahbúréhne sansámé are kéráh kégá aneqsabé anteruera peh náwíqkakaq síyáhnkárátáté táhutahuq naho uwe. ");
INSERT INTO awb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Uwana Sísaga sensabé, Itewe peh kopéráhpéro ke wóe. Manikáne ehweh irarú ani Áísáíaga naho Manikáne ehwehnka mahraréna, Mah kegá néníwíq síwéhrate pankerera peh sirupipeq ínénsabe íre suwahbehre. ");
INSERT INTO awb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sega wehukega sehgíóro e ehwéh síwáhnoréra, Mahnawé Manikáne sansáne ewe. Minayabe sega ínénsabe péhepehe iwíáh íwíáh aintáhwe úwe. Itega miraonsabé púkuipéqté éhwéhnká aiq irarire. ");
INSERT INTO awb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Itega Manikánka sehgíóro ú ehweh sueq peh wehukene sánsá ambubu atawéq sehgirowe úwe. ");
INSERT INTO awb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sísaga mó mahraréna, Iteitene sánsá sehgioneheéq Manikánka sehgíóro ú ehwehnsábé anetaníbo éq anterúáhwe. ");
INSERT INTO awb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mósísiga naho mahraréna, Iteinoibone ehweh ireq se séhréh arítáhro úwe. Wega mó mahraréna, Wenanoibonsabé íre kaweq ehwéh arítéh ání subiq súáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Manikáne púkuga miraue irariraq itega síwáhnoréq, Wehukenínká wenanoibo séhréh aritahráhi monébópoq mó naneqpopoq matawéna wenanoibonsabé mahraréna, Mahnawé Maniká íre áwátáutaq tahirímé náíyú irino ire. ");
INSERT INTO awb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wehukenínká miraue irariraq itega, Mi anínká wenanoibonsabé anetaníbo ime aiq kawerire. Wega se íre séhréh arítéhmé aiq kawerire ewe. ");
INSERT INTO awb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Minayabe iteitene ehweh sehgíónsábé Manikánka sehgíóro ú ehweh anterúáhwe. Mahna tahnsa sánsá áhntetaq mira aruqaruréq mó keyábé, Itene sánsá sehgíóro arítáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sísaga mónkakáq mitaq míó keyabé, Ínéba sewíáhro. Ite ómiga néne ehweh ireq iwíáhue tagahro. ");
INSERT INTO awb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wehukenínká táhutahurinka íre ahbabáratéhre. Írakaumo. Peh morá wene arupipeqté íwíáhgá ahbabáratahráhire. ");
INSERT INTO awb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ahreakaq kéo, mah ehwéh írátíáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sísaga weba sáhatíó ke suena nahupeq kibekúwara we kéró kega mi pabéqmé éhwéhnsábé kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kasenuwana wega sensabé, Ite moq íre írátíaho? Wehukenínká táhutahurinka íre ahbabáratéhre. Minayabe íre iraho? ");
INSERT INTO awb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Táhutahuqka wehukeníné iwíáhipeq íre túíre. Peh ahmbiupipéq tunse tueagire úwe. Sísaga mah ehwéh irarúmé, Moke táhutahuq nah naneq mire úwe. ");
INSERT INTO awb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sísaga mó mahraréna, Wehukeníné arupipeqté íwíáhgá ahbabáratéhre. ");
INSERT INTO awb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wehukeníné arupipeqté, wene iwíáhipeqté, ahbabáq iwiáh áhwárehre. Íre kaweq iwíáhwé, mahbi ahrari abariéwé, aebówé, wehuke subiq suewé, ");
INSERT INTO awb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mó aníné ahre weh abariéwé, mó aníné ménsámehnsánsabe aigárá pabekime, íre kaweq sansámé, péhepehenéwé, íre mirao naneq miraime, mó anínsábé íre kaweq iwíáh atewé, éhruruéwé, píribahriéwé, saiyoéwé, ");
INSERT INTO awb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","moke mah ahbábáqmé, wehukeníné arupipeqté áhwárehre. Mahnawarinká wehukení ahbabáratéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sísaga mitaq suena Táíya suwahpeqte kéné marakórapeq pokúwe. Pokéna nahupeq kiena, Íné mahtaq míónsábé mó ke teríyeho úwanawe we kopípéq íre míahrahúwe. Írakaumo. ");
INSERT INTO awb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Owainawanka wene ayahunkawa subiqmaq subiqmarú inínká Sísa míéhre u irena apubúue sure Sísansabé áhtó púana wene aigárátáq arehunseraráq sewíowe. ");
INSERT INTO awb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","We mitaqté náhnsó ínínéna Káríki ehwéh iro iní míre. Wega Sísansabé, Nániyahu subiqmaq subiqmari owáínáwá segasuo teawuwe. ");
INSERT INTO awb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Teawuwana Sísaga wensabé, Ebeqme animárínká táhutahurigehe. Sene táhutahuq mewe iamárípá tuparuewé íre kaweq sansáne. ");
INSERT INTO awb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Úwana wega Sísansabé, Anotah aníno, arega irarénawe aiq pútaróne. Iamarínká animáríné siyahpite megi apípí tahbe tehnopeqte mewe nahtaq sibowágá íre kaqsúéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Úwana Sísaga wensabé, Arega irarénayabé seuwekúno. Owainawanka areniyahu aiq auwena pokire. ");
INSERT INTO awb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aiq auwena pokire úwana wene nahtapeq pokue tagówana owainawa kaqauwo aní aiq auwowana wene máhriqtaq awahoraq míowana tagówe. ");
INSERT INTO awb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sísaga Táíya suwahpeq suena Sáíróna suwahpeq kótaikéna Tékápórísa marákórápéq tuena Kehrari kawéhútáq kúwe. ");
INSERT INTO awb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mó kegá ahre parosa ání íre kaweq ehwéhnú ani Sísaba meqmera suwe. Sega Sísansabé, Kaweraginkehboq arene ayahnkaratáté táhtoro uwe. ");
INSERT INTO awb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Uwana Sísaga mi aní meqmena mipi sáhuríó ke suena móbeq pokue wene ayahnobeqtaté mi aníné ahreipeq paroqmatawéna anehe wene ayahnobeqtaq tehqniarena mi aníné anehbíraq marena ");
INSERT INTO awb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","íópeq tagéna ahyanahyanéna ahre parosa ánínsábé mahraréna, Épátae úwe. Mi ehwéhnúmé, Ahre sio úwana ");
INSERT INTO awb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","wene ahre siatowana wene anehbí kaweragúwana wega kaweq ehwéhnúwe. ");
INSERT INTO awb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sísaga sensabé, Mó ke teríyeho úwara sega mó ke teriúnsabe wega teríyeho uge úwara sega áhnte mó ke teri terinuwe. ");
INSERT INTO awb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mi ehwéh író kega anotah ahténéra mahraréra, Wega moke kawerue miraire éra ahre parosa ání iro atéhre. Íre ehwehnorahi aní ehwehnúno atéhre uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mitaqkake áhnte kegá Sísaba sáhatíówana se táhutahuq íre konsabe Sísaga we kéró keyabé síáhrabéna sensabé, ");
INSERT INTO awb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Mahtaq míáh kégá ínéba apahtáró wéhékáh míáhnsábé amahnága se táhutahuq íre kéh púana sensabé nirutaboiruge. Íre kirabo aritasa pehipi eqmaq súáhnaraq ahtapeq siunúnkaq surahiyeho. Pehipi íre eqmaq suaníe. ");
INSERT INTO awb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sene nahtapeq eqmaq súáhnaraqmé sirupibiyabé ahtapeq siunúnkaq márunsurahoneherawoe. Táhmaro míáh kégá íre wahtopeqte surowe úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Úwara we kéró kega wensabé, Mahtaq peh abatapi míre. Mah ke awehraq tahutáhúq nagehboq árahue áhnte tahutáhúq meyahráhuno uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Uwana Sísaga sensabé, Árahue parétí kehro úwara abapete téhtaré kéhre uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sísaga weba sáhuríó keyabé, Marakóraq tútuoro éna mi abápété téhtaré párétí mewena Manikánsabe, Kaweróne atena páréti keqme we kéró kega míó ke kiraboigeheéna siuwara sega moke míó ke náríúwe. ");
INSERT INTO awb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sega táhmaro káriq pah kowana Sísaga Manikánsabe kaweróne atena we kéró keyabé, Minaakaq kirabooro úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kirabooro úwara míó kega nowana siyahbankirowe. Siyahbankirowara arahqmé abapete téhtaré páhsíkétí úsawe obenkíq márówe. ");
INSERT INTO awb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Peh íregáritaq wehuké 4 táhúséni (4,000) ke míówe. Sísaga mi ke eqmaq suena ");
INSERT INTO awb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","sípiipéq apubúue kiasagéna wereq we kéró kereq kure Tárámánúta marákórápéq pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Péhrasi kegá Sísaba séra wensabé ehweh atera, Manikánka are séhréh atahna taganehboq íópeqté ótaq sansánúno uwe. Ótaq sansánúno éra we áhwárawe tagowe. ");
INSERT INTO awb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Áhwárawe tagowana Sísane arupipeq págege agúwana wega mahraréna, Amahnága oga míáh kégá aneqsabé ótaq sansá tagéyabe suwahbehro? Teiníboq írátíáhro. Sega ótaq sansá íre tagagehe. Ahqáho. Írakaumo úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Írakaumo éna Péhrasi ke suena sípi kéwewena kéráwégue seberaebéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","We kéró kega páréti meweyabe sibitagúwara peh morá párétí sípiipéq kowe. ");
INSERT INTO awb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sísaga sensabé págegeue mahraréna, Tagaríáhro. Péhrasi kereq Érótireqne páréti muoráhi naneq pehragahro úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Úwara sega seye náhenéra, Ite páréti íre kéhnsábé Sísaga mi ehwéh teíre uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Uwana Sísaga sene ehweh ahtebéna sensabé kasenéna, Ite páréti íre kéh éhwéhmé aneqsabé sío síoo? Amahnága teiú éhwéh íre iraho? Itene irupipeq íre ahtebaho? ");
INSERT INTO awb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Itene iurame kéhraq íre tagariaho? Itene iahrewé kéhraq íre írátíaho? Ínéga mirauraume ite íre iahreraq kehro? ");
INSERT INTO awb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ínéga 5 táhúséni (5,000) weh moberíáh párétí keqme kirabourautaq arahqmé árahue unáh úsawe obenkíq matoo úwara sega wensabé, Airápété téhtarée uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Uwana Sísaga sensabé, Mó ke 4 táhúséni (4,000) weh abapete téhtaré párétí keqme kirabourautaq arahqmé árahue unáh úsawe obenkíq matoo úwara sega wensabé, Abapete téhtarée uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Uwana wega sensabé, Minayabe ite amahnágaákáq íre iraho úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sega Pétásáíra suwahpeq suwara mó kegá aura pira ání Sísaba meqme séra wensabé, Mah aní kaweraginkehboq arene ayahnkaratáté táhtoro uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Uwana Sísaga aura pira ání ayahtaq ahmboqmena ahnansahrapeq pokéna wene aura tehqni atena ayahnkaratáté táhtorena wensabé, Aiq tagahno úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Úwana wega tagéna, Ínéga nogó ké tagogana se awanká tahnsa nogówana tagoge úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Úwana Sísaga ayahnkaratáté wene aurapi mó táhtorowana wega ebitáwéna wene aura kaweragúnsabe kawerue tagówe. ");
INSERT INTO awb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kawerue tagówana Sísaga wensabé, Mah kehiná suwahpeq amahnága kouwekineho éna wene nahtapeq eqmaq auwowe. ");
INSERT INTO awb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sísaga we kéró kereq meriqmena Sésáría Pírípái suwahpeq mitaq wahtotaq mó kehiná suwahpeqtaq pokinaúwe. Ahtapeq kutaq wega sensabé kasenéna, Mó kegá ínénsabe inse aintaho úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Úwara, Arensabé mó kegá, Sóni wání meri merini aní míre ewara mó kegá arensabé, Éráísa wire ewara mó kegá arensabé, Manikáne ehweh irari aní míre ewe uwe. ");
INSERT INTO awb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Uwara Sísaga sensabé kasenéna, Itega ínénsabe inse aintaho úwana Pítaga wensabé, Manikánka ite meirena kaweraitankeheéna omaq ato aní móne úwana ");
INSERT INTO awb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sísaga sensabé minayabe mó ke teríyeho úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sísaga we kéró ke síwáhnoréna, Íné wehukení úku aní níwíoqnaneherawoe. Asiu kené aboawah wehreq Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka ínénsabe, Iuwahriehre éra nubiq suaneherawoe. Nubiq suehrana íné pukéna apahtáró wéhékáhtáq iriwe oga úkinauge úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sísaga mah ehwéh pahsuqme irarúwana Pítaga we meqmena móbeq móatena wensabé awehgu atena, Arega iraréna ehwéhmé aiq pútaragineho úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Úwana Sísaga pabeqme we kéró ke tagéna Pítansabé awehgu atena wensabé, Owainawano, móbeq míahno atena, Arega iraréna ehwéhmé Manikánka íre iwíáh atéhre. Minawé peh wehukene iwíáh wíre úwe. ");
INSERT INTO awb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sísaga we kéró kereq moke míó kereqsabé, Ínéba sewíáhro éna, Íné sénireyabe awahbeh aníno, arerene awahbeh iwíáh suo. Manikáne arambehri mira aruqarurunsabé sega íné awankátaq táhparagéhe. Ínéga miraunserah miraue séniro. ");
INSERT INTO awb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wewensabé arutaboiréna peh wewene awahbeh iwíáh mira aruqaruri anímé oga mérapeq íre awaq miahráhire. Néne kaweq ehwéh koreriena néne sánsá sehginieéna wewe awahbeh iwíáh susuri anímé oga mérapeq awaq miankéhe. ");
INSERT INTO awb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wehukenínká moke mah marákóípéqté ménsáméhnsá matíéhtáq tahirímé oga mérapeq íre awaq miahnaraqmé mi mensáméhnsánká árahue séhréh atéh iripo? ");
INSERT INTO awb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Oga mérapeq awaq meyabe aneqtaté paiqmarankéhbo? Ahqáho. Írakaumo. Íre paiqmarahráhire. ");
INSERT INTO awb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Amahnága oga míáh kégá Manikánsabe íre suwahbehrara peh ahbabáq aruqarurowe. Mah tanáhráq ínénsabeákáq néne ehwehnsabéákáq ayehiteh anímé íné wehukení úku anínká túónagake mi anínsábé moq niyehitanawire. Nánibone patahga tahnsa téhreh naneqkakáq íné wehukení úku anínseq Manikáne íópeqté kéreqka túónagake mi anínsábé niyehitáhnana ahqáho ataníe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sísaga mó mahraréna, Teiníboq írátíáhro. Táhmaro iriwe míona ke pehipi íre pukigehe. Ebeqme Manikánka págegeue wahnah wahnahnínaq tagéq anehe pukigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sísaga síwáhnorúwana abapete morá wéhékáh parabagútaq wega Pítareh Sémísireh Sónireh sebataq meriqmena anotah sawéhrápéq kiuwe. Kiuwara mó kegá íre míowara sega tagotaq Sísane auranabiah mó kugú kaweq kugú agúwe. ");
INSERT INTO awb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wene korósi patahga tahnsanue anotah tabérábé agúwe. Mina tahnsa tabérábéwé mah marákóípéqté ambanta pabeq paberi anínká íre miraorahire. ");
INSERT INTO awb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Éráísareq Mósísireqka íópeqté tunse ábóraragéra Sísareq ehwehnuwe. ");
INSERT INTO awb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ehwehnuwana Pítaga Sísansabé, Íwáhnoraníno, ite mahtaq míonayabé aiq kawerire. Apahtáró úqná pearanéhe. Arene morá, Mósísine morá, Éráísane moráue pearanéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Se anotah ahréu puana Pítaga íre iwíáhia pehipi irarúwe. ");
INSERT INTO awb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Irarútaq írábúyánka seubítíowana mipéqté éhwéhnká mahraréna, Mah anímé niruní nénáhní míre. Wene ehweh íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Úwara Sísa kéró kega apubúue aurankahnkaue tagowara mi aníté íre míóyana peh morá Sísa webataq sereq míowara tagowe. ");
INSERT INTO awb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sáwéhrapeqté tuegutaq Sísaga sensabé, Itega tagéq irewáh éhwéh amahnága mó ke teríyeho. Íné wehukení úku anínká pukéna oga úkonaraq terigéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Únsabe sega mó ke íre teriasa peh oga úkona ehwéhnsábé seyega iwíáhue kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kasenéra, Mósísine ehweh síwáhnoro kegá, Éráísa ebeq sinaraq anehe Manikánka omaq ato aní anehe sinae eme aneqsabé irareo uwe. ");
INSERT INTO awb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Uwana Sísaga sensabé, Éráísaga moke kawerinieéna ebeq suraire. Mó kegá íné wehukení úku aní níwíoqnéra niwiréh aintagéhe. Minayabe Manikáne púkuipéqté séhíránká aiq teí mino? ");
INSERT INTO awb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ínéga teiníboq írátíáhro. Éráísa aiq suraire. Púkuipéqté séhíránká aiq irarinserah mó kegá seye suwahbarai sansánéra we íre kaweratárówe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sísareq apahranító we kéró kereqka mó Sísa tagaríáh kébá túwara áhnte mó kegá seba sáhuríówara Mósísine ehweh síwáhnoro kereqka se ehwehuwe. ");
INSERT INTO awb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ómi mitaq sáhuríó kega Sísa tagotaq áhtenéra pehbeheráh weba séra mehwehuwe. ");
INSERT INTO awb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mehwehuwana Sísaga sensabé kasenéna, Itereq sereq aneq ehwéhnoo úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Se míórabeqte wéhgá Sísansabé, Íwáhnoraníno, nénahni areba meqme suge. Owainawanka we subiqmaq subiqmarinsabé wega ehweh íre irahráhire. ");
INSERT INTO awb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Owainawanka we subiqmaq subiqmaritaq marakóraq tontehriparéhrana arehya kiobinue áwéhraq nankiq nánkírirana wene anonka tawiróbana atia atiaire. Are kéráh kéyábé, Owainawa kaqauwáhro ugarawe sega íre miraorahowe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Íre miraorahowana Sísaga míó keyabé, Ite íre aiq pútare ainteq saiyo ke wóe. Iteba mía míaume ahkake awehraq kanabo? Itega miraonsabé nirupipeq umehime ahkake parabaginabo? Mi anímáí ínéba meqme sero úwara ");
INSERT INTO awb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","meqmera móátówe. Meqmera móátówana owainawanka Sísa tagótaq mi anímáí kúrugúru atowana we marakóraq márunsurahéna tabenoráhbénoue arehya kiobinúwe. ");
INSERT INTO awb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sísaga mi aníné abowánsábé kasenéna, Arenahnimé téhwe ahkake miraurairo úwe. Úwana abowágá, Pehgáriq aní míaraitaq mirauraire. ");
INSERT INTO awb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Owainawanka we subiq suanieéna iraipéq áhntetaq susuréna wánípipeq áhntetaq susurire. Arega miraorahónawe arutaboiraite miraúno úwana ");
INSERT INTO awb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sísaga wensabé, Arega miraorahónawe ono? Manikánsabe aiq pútare atéh ánínká moke miraorahire úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Úwana abowágá apubúue mahraréna, Aiq pútare atóge. Arensabé aiq pútare atómé íre awehraq kéhnsábé séhréh ainto úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Úwana áhnte mó ke weba peheráh sure mipi sewíówana Sísaga se tagéna owainawansabé awehgu atena wensabé, Íre ehwehnia ahre parosa owáínáwáno, mah aní auwe pokúno. Weba mó íre súno úwana ");
INSERT INTO awb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","owainawanka ehwehnabaéna kúrugúru atena auwena pokúwe. Pokúwana mi anímáí pusa ání tahnsa míonsabe áhnte míó kega, We aiq putíéhre uwana ");
INSERT INTO awb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sísaga wene ayahnkara táhtoqme iriatowana irigúwe. ");
INSERT INTO awb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Irigúwana Sísaga nahupeq kibekúwara we kéró kega wensabé, Itewe árahinsabé owainawa íre kaqsuahráhuno kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kasenuwana Sísaga sensabé, Mina tahnsa pehipi íre kaqsuahráhowe. Peh púrerirataq kaqsuahráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sísareq we kéró kereqka mitaq suera Kehrari marákórápéq ákáhpi kíúwe. Kíúwana we kéró ke síwáhnorinieéna mó kegá íné míónsábé írého úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","We kéró ke síwáhnorú púana áhnte ke míórabeq íre pokúwe. We puké tanahráqsábé síwáhnoréna, Íné wehukení úku aní móintehrara nubiq suaneherawoe. Nubiq suehrana íné pukena apahtáró wéhékáhtáq oga úkinauge úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Úwara sene sirupipeq wene ehweh íre irera kasenéyabe áhreuwe. ");
INSERT INTO awb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sega Kápénéáma suwahpeq kure nahupeq kibekuwe. Sísaga sensabé kasenéna, Ahtapeqmé aneq ehwéh sío síoéwaho úwara ");
INSERT INTO awb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","sega ehiya míówe. Ahtapeq nogútaq mó anínká mó anínkáue, Íné anotah aní ite kiotaiqme aní múge iraréra ehwehu puara ehiya míówe. ");
INSERT INTO awb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sísaga tútuue ména airápété téhraníté we kéró keyabé, Ínéba sewíáhro éna anotah aní míanie íwíáhi anínká pehgáriq aní tahnsa míankehe. Wega moke mó ke séhréh aritankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Séhréh aritankéhe éna káriq aní meqme se ákáhpi iriatena sawiwena sensabé, ");
INSERT INTO awb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ínénsabe arutaboiraintena mahna tahnsa káríq ání séhréh atéh ánínká íné moq séhréh aintéhre. Íné séhréh aintéh ánínká íre peh morá ínébataq séhréhire. Íné eqmaq núwéh ání moq séhréh atéhre úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sóniga Sísansabé, Íwáhnoraníno, mó anínká arenáwírue owainawamarí kaqsúéhraq tagéq ahqáho atone. Wega ite íre séíréhnsábé ahqáho atone úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Úwana Sísaga wensabé, Íre ahqáho atáhro. Néníwírue irarinsabé ótaq sansá mirai anínká abehq éhwéh íre apubúue irare intahráhire. ");
INSERT INTO awb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Íre itene naruo aní míéh ánímé itene iyahnabo aní míre. ");
INSERT INTO awb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Teiníboq írátíáhro. Ite Manikánka eqmaq núwéh áníné animárí míáhnsábé mó anínká ite né waní náinaraqmé mi aníné ápeqme íre tabanagia peh ahreraq kanawire úwe. Manikánka mi aníné náwéna apéqmé ahreraq kanawire úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sísaga mó mahraréna, Wehukenínká ínénsabe aiq pútare aintéh ání ahbabáq sansa áúgi ínaraqmé anotahtaq íre kawerire. Áúgi anínká káriq aní áúgi ínaraqmé wene anuopi anotah ebáh táhru táhruue púrúrúia káwéhúpípéq tuparuahnana wánípipeq tupekitaq tahirímé aiq kaweri irino. ");
INSERT INTO awb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Arene ayahnkaranká are ahbabáratana ínaraq mina kirasuo. Are peh morá áyáhnkáránkákáq oga mérapeq pokinaraq aiq kawerinae. Are téhtaré áyáhnkáránkákáq ahriahri iraipéq kaqauwáhnaraqmé anotah íre kawerinawire. ");
INSERT INTO awb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mitaq sene sinonka ahriahri ábe soinae. Mitaq íre puinkorahi iráípére. ");
INSERT INTO awb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Arene aigáránká are ahbabáratana ínaraq mina kirasuo. Are peh morá áígáránkákáq oga mérapeq pokinaraq aiq kawerinae. Are téhtaré áígáránkákáq ahriahri iraipéq kaqauwahnaraqmé anotah íre kawerinawire. ");
INSERT INTO awb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mitaq sene sinonka ahriahri ábe soinae. Mitaq íre puinkorahi iráípére. ");
INSERT INTO awb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Arene auranka are ahbabáratana ínaraq mina piruo. Peh morá áúránkákáq Manikánka wahnah wahnahnirabeq pokinaraq aiq kawerinae. Téhtaré áúránkákáq ahriahri iraipéq kaqauwahnaraqmé anotah íre kawerinawire. ");
INSERT INTO awb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mitaq sene sinonka ahriahri ábe soinae. Mitaq íre puinkorahi iráípére úwe. ");
INSERT INTO awb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sísaga mó mahraréna, Wehukenínká táhutahuqtaq sóreq ahbiorahnanserah Manikánka ómi irobinataté ahbioqmarankéhe. ");
INSERT INTO awb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sóreq kaweq nanere. Sóreq auqmah naneq úkínaraqmé itega árahue kaweraranéhbo? Írakaumo. Sóreqka táhutahuq teorahi nanere. Mina inserah itene iyahnabo anímárí míáhrabeq pehwehrue méq kaweq soréq tahnsanue míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sísaga mitaq suena Sorana aroipéq seberaebéq Súría marákórápéq pokúwara áhnte wehekéqká weba sáhatíówana wega ahriahri miraúnserahnue síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Péhrasi kegá Sísaba séra wega ahbabáq ehweh irarinkeheéra áhwárawe tagéra kasenéra, Wehga wene ahre suewé mirao sansápo uwana ");
INSERT INTO awb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sísaga sensabé, Mósísine ehwehnka anereiro úwara ");
INSERT INTO awb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","sega wensabé, Mósísine ehwehnka mahraréna, Wehga wene ahre kaqsuaníe ínaraqmé pépahqtaq sehiranue móawena kaqsuankéhe ire uwe. ");
INSERT INTO awb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Uwana Sísaga sensabé, Ite saiyoéq itene irupipeq págege onsabé, Mósísiga mi ehwéh sehiranúwe. ");
INSERT INTO awb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wene ehweh íráhro. Wene ehwehnka mahraréna, Manikánka téh mah marákó márákó mirarotaq wega wehakaq ahreakáq mirarowe. ");
INSERT INTO awb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Minayabe wehga wenanoibone nah suena wene ahrereq moráráq mía míaigehe ire. ");
INSERT INTO awb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Se peh morá áníné áú tahnsa úkigehe. Minayabe se íre mó aní mó aní tahnsa méra peh morá ání tahnsa míagehe. ");
INSERT INTO awb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Manikánka wehakaq wene ahreakáq moráráq mía míaotao aritonsabe wehga wene ahre súéhneho úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sísareq we kéró kereqka nahupeq kibekutaq sega mónkakáq ahre sue sansansábé kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kasenuwana wega sensabé, Wehga wene ahre suena mó ahré meyahnaraqmé wega ebeq piah ahré ahbabáratena we íre kaweratéhre. ");
INSERT INTO awb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ahrega wenawehq auwena mó anítáq wehkínaraq wega ebeq piah weh ahbabáratena we íre kaweratéhre. ");
INSERT INTO awb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sísaga káriq anímárí táhtorankeheéra mó kegá meriqmera mórítówara we kéró kega mórító keyabé suwehgu aritera ahqáho arítówe. ");
INSERT INTO awb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ahqáho arítówana Sísaga mina tagéna abiahnsa aritena sensabé, Mi karíq ánímárí ínéba sewíagehboq ahqáho arítého. Káriq anímárínká ínénsabe aiq pútare aintáh serahno kegá Manikánka wahnah wahnahnirabeq awaq miagéhe. ");
INSERT INTO awb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Teiníboq írátíáhro. Káriq anímárínká Manikánka wahnah wahnahnirabeqsabé sirutaboirowe. Peh morá sega onserahno kegá mibeq kioráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sísaga mi karíq ánímárí sawiwena wene ayahnkaratáté táhtoqme Manikánsabe, Kawerarite séhréh arito ue púrerúwe. ");
INSERT INTO awb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sísaga ahtapeq pokinaútaq wehga peheráh séna arehunseraráq ména wensabé kasenéna, Íwáhnoraníno, arewe kaweq aní míahne. Oga mérapeq awaq mianíboq anerininkono úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Uwana Sísaga wensabé, Aneqsabé kaweq aníne aintahno? Manikánka webataq kaweqtaq mía míaire. ");
INSERT INTO awb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sehgíóro ú ehwehmé aiq ahtebáhne. Mi ehwéhmé mahraue kéhre. Mó aní subiq súého. Mó aníné ahre weh abariiyeho. Aebóiyeho. Mó keyábé péhe éhwéh arítého. Péhe éhwéhnue mó kené ménsámehnsá meyého. Iteinoibone ehweh ireq se séhréh arítáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uwana wega Sísansabé, Íwáhnoraníno, íné pehgáriq mahbi míarau tanáhráqkákáq amahnágaákáq moke mina kawerue sehgíúge úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Úwana Sísaga we tagéna arutaboiratena wensabé, Peh morá náneq íre miraóne. Are pokue moke matiahna mensáméhnsá paiqmaqme móne mewe tabonah ke nário. Mirainaraqmé íópeq kaweq naneqmarí matiankehe. ");
INSERT INTO awb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tabonah ke nárie íné séniro úwana mi anínká irena áhnte mensáméhnsá ko púana wene arupipeq umeh agúwana pokúwe. ");
INSERT INTO awb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sísaga pabeqme we kéró ke tagéna sensabé, Áhnte mensáméhnsá matíáh kégá Manikánka wahnah wahnahnirabeq kieyabe anotah pagégéue mirao naneq mire úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Úwara we kéró kega mi ehwéhnsábé áhtenuwana Sísaga mó mahraréna, Náníbáqmarino, ménsámehnsánsabe iwíáh íwíáho kegá Manikánka wahnah wahnahnirabeq kíransabé anotah pagégéue mirao naneq mire. ");
INSERT INTO awb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kéhma anotah kane. Mi kanká wai abahrabahpipéq kéagínayabé págegeue mirai naneq mire. Mina inserah áhnte mensáméhnsá matíéh ánínká Manikánka wahnah wahnahnirabeq kinayabé anotah pagégéue mirai naneq mire úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Úwara sega mi ehwéhnsábé anotah ahténéra Sísansabé, Minayabe insega oga mérapeq awaq miahráhiro uwe. ");
INSERT INTO awb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Uwana Sísaga se ebitáwéna sensabé, Wehukega íre miraorahowana Manikánka miraorahire. Peh morá Maniká wewega moke miraorahire úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Úwana Pítaga wensabé, Itega moke mationa naneq sueq are kérone úwana ");
INSERT INTO awb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sísaga mahraréna, Teiníboq írátíáhro. Ínénsabe sirutaboiréra kaweq ehwéh teriera néne arambehri miraoneheéra sene nahme, sene marakówé súáhmé amahnága Manikánka áhnte mó 100 mó nárinkéhe. Nárinara sega áhnte nahmé, marakówé matiagehe. Néne arambehri miraoneheéra sinahnowarehwé siwahwarehwé sensibáqmarimé sensinoibowe sene animárímé súáhmé ");
INSERT INTO awb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","amahnága áhnte mó kegá sensuwahrah úkigehe. Síbákawaréhwé, sinahnowáréhwé, sinowaréhwé, animárímé áhnte úkigehe. Mah tanáhráq kaweq ehwéhnsábé suwahríáhna kegá se síwíoqnagehe. Mókake oga mérapeq awaq miagéhe. ");
INSERT INTO awb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amahnága áhnte ebeq se kegá mi tanáhráq sinehe kigehe. Sinehe se kegá ebeq kigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sísareq we kéró kereqka ahtapeq méra Sarúsarama suwahpeq kure Sísaga ebeq kúwara sega áhtenuwe. Anehe ku kegá áhreuwe. Sísaga airápété téhraníté we kéró keyabé síáhrabéna sensabé mó kegá we miraoneherau ehwéh mónkakáq teriuwe. ");
INSERT INTO awb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Teriena, Írátíáhro. Ite Sarúsarama suwahpeq pokonaraq sega íné wehukení úku anímé Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqpa mónuankéhe. Mónuwehrara sega íné, Subiq súáhro aritera nahnso kebá mónuwehrara ");
INSERT INTO awb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","sega niwiréh aintera tehqni aintera sehikarankákáq árétí sáhtáté nubiq marera nubiq suagéhe. Nubiq súéhrana íné pukéna apahtáró wéhékáhtáq oga úkinauge úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sémísireq Sónireq Sébérine ahninkáwárárégá Sísaba séra wensabé, Íwáhnoraníno, ite iuwahbeh naneq, itega teawéya naneq, miraúno uye. ");
INSERT INTO awb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Uyana wega sensabé, Aneq miraitanínkono úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Úwara sega wensabé, Arega wahnah wahnahnónarabeq íópeq míéhnagake ite mó anímé arene ayah púpeq mó anímé arene ayahnaperue tútuue míagehe aito uye. ");
INSERT INTO awb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Uyana Sísaga mi abáráhréyábé, Itega tenieya ehwéhnsábé íre iwíáhóye. Íre iwíáhóye éna pabeqme ehwéh mahraréna, Ínéga no kahpúípéqté náneq itega moq nahrahoyo? Mó kegá íné núwéhrarabeq sénirahráhoyo úwara sega wensabé, ");
INSERT INTO awb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Itega miraorahúye uye. Uyana Sísaga sensabé, Ínéga no kahpúípéqté náneq itega moq nayehetawoye. Mó kegá íné núwéhranserah ite moq iuwaneherawoe. ");
INSERT INTO awb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Peh néne niyah púpeqkakáq niyahnapeqkakáq tútuue míéhra ke omaq sitewé íre néne arambehri wire. Manikánka omaq sitéh ánítégá mitaq tútuue míayeherawoye úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Úwara inayáhnkú we kéró kega mah ehwéh irera Sémísireq Sónireqsabé suwehgu arítówe. ");
INSERT INTO awb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Suwehgu arítówara Sísaga moke we kéró keyabé, Ínéba sewíáhro éna sensabé, Mah marákóípéqté sánsámé mó kegá sene ehweh sehgigeheéra wahnah kegá wahnahnarítáhwe. Sene anotah wehwárínká, Itene ehweh ireq sehgíóro éra págegeue wahnah arítáhwe. Mi sansá aiq tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Itewe mi sansá íre oro. Ahqáho. Íné anotah aní míanie íwíáhi anínká wereq míáh ké séhréh aritankéhe. ");
INSERT INTO awb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Néne iyahnabone wahnah míanie íwíáhi anínká sene arambehriraq séhréh aritankéhe. ");
INSERT INTO awb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Íné wehukení úku anímé mó kegá íné séhréh aintageheéna tutaugo? Írakaumo. Ínéga mó ke séhréh aritanieéna tutauge. Áhnte ke oga míagehboq se merirena kaweraritanieéna pukinie úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sísareq we kéró kereqka Séríko suwahpeq kuwe. Sega Séríko suwahpeq suaneherautaq áhnte mó kegá kérówe. Aura pira ání wenáwíq Pátíméúsi ahnayehráq tútuue ména ineh inehuwe. We Tíméúsine ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wega tútuue ména, Sísa Néhsara suwahpeqte ánínká kouwekire u irena anotahtaq mahraréna, Sísao, Tébítine anahwao, ínénsabe arutaboirainto úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Úwara áhnte kegá wensabé awehgu atera, Ehiya míahno uwana wega íre túbáh agia peh anotahtaq mó mahraréna, Tébítine anahwao, ínénsabe arutaboirainto úwe. ");
INSERT INTO awb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Úwana Sísaga mitaq kowéna, Mahbeq súno teawéro úwara sega aura pira ánínsábé áhrabéra, Iwíáh íwíáhé irigúno. Arensabé áhrabire uwana ");
INSERT INTO awb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","wene káhq ambántá akairuena apubúue kie irigue Sísaba súwana ");
INSERT INTO awb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","wega wensabé, Aneq mira atanínkono úwana aura pira ánínká wensabé, Íwáhnoraníno, íné taganiboq néne niura kawerainto úwana ");
INSERT INTO awb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sísaga wensabé, Pehwehrue pokéwahno. Ínénsabe aiq pútare aintahnaga aiq kaweratóge úwana wene aura apubúue kaweragúwana ahtapeq Sísa kérowe. ");
INSERT INTO awb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sísareq we kéró kereqka Sarúsarama suwahpeq wahtotaq kíútaq sega Óríwi sawéhrápéq kíúwe. Mi sawéhwé Páítápási suwahpeq Pétáni suwahpeq wahtotaq kéhre. Mi sawéhráq kíútaq Sísaga we kéróya aníté eqmaq suanaútaq ");
INSERT INTO awb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","sensabé, Isebeq wahtotaq ke suwahpeq pokotao. Mitaq kirataq iyaráh ká tónki áráhq wehuke íre áhkokóue nogí ká tagéta pugeqme meqme setao. ");
INSERT INTO awb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pugeréhrataq mó anínká itensabé, Aneqsabé pugerehyo ínaraq wensabé, Itene Wahnah áhkokóue kinkeheéta meroye. Wega mótaq tónki eqmarahnana kéna sinkehe teawétao éna eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eqmaq suowara pokue anotah ahtápéq onsa kéhrabeq iyaro tonkí áráhq tagéra pugeróye. ");
INSERT INTO awb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pugeróyataq mitaq iriwe míó kega sensabé, Aneroyo? Tónkiwe aneqsabé pugerehyo uwara ");
INSERT INTO awb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","sega Sísaga teriu ehweh teríúyara sega sensabé, Meyáhtao uwe. ");
INSERT INTO awb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Meyáhtao uwara tónki áráhq Sísaba seweqmera sene korósi mi kané abobiahtaq uwiq máróyana Sísaga mi tonkíné abobiahtaq kierútu agúwe. ");
INSERT INTO awb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Áhnte kegá Sísansabé iwíáh íwíáh ató púara sene korósi ahtapeq uwiqme abaeue móárówara mó kegá uworapeqté áwánká ánáhakaq áyáhnáwé apiwe ahtaqpeq awahrirarówe. ");
INSERT INTO awb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sísareq moráráq ebeq ku kereq anehe ku kereqka anotahtaq mahraréra, Itene Wahnah áwírue si anínsábé iwíáh íwíáh atone. ");
INSERT INTO awb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tébíti iteriboga naho wahnah wahnahnúnserah kawerue wahnah wahnahnína anínsábé iwíáh íwíáh atone. Maniká íópeq míéhraq wensabé iwíáh íwíáh atone uwe. ");
INSERT INTO awb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sísaga Sarúsarama suwahpeq kiena Manikánsabe iwíáh íwíáh atáh náhúpéq kibekéna mitaq moke ko naneq aurankaue tagówe. Penkinaúnsabe wereq we kéró kereq airápété téhranítégá mitaq suera Pétáni suwahpeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ahbiah tahnsá sega Pétáni suwahpeq suera ahtapeq sutaq Sísa arupibiúwe. ");
INSERT INTO awb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Arupibiúwana ánáhakaq áwánká móbeq tagéna awankánara sabátáhq koragówana íre serankakáq peh ánáh kowe. Sera íre iyo tanahráq púana sera írakaunúwe. ");
INSERT INTO awb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Írakaunúwana Sísaga mi awánkánsábé ehweh teawena, Mókake sera íre íyéhna puara mó kegá arene sera íre íséwe naneherawoe úwara we kéró kega wene ehweh írówe. ");
INSERT INTO awb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sísareq we kéró kereqka Sarúsarama suwahpeq kíútaq Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq kibekéna mitaq paiqnanánu ke máhpeq kaqsuowe. Kaqsuena móne paiqnanánu kené wéhuwehu tahbéwárí pioruena kiboki paiqnanánu kené síahwarí pioruena paetárara aruowe. ");
INSERT INTO awb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Paetáruena sensabé, Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéqmé itene ménsámehnsá íre mewe nógóro aritowe. ");
INSERT INTO awb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Íre mewe nógóro aritena síwáhnoréna, Manikáne ehwehnka mahraréna, Néne nahme mah kehiná kéhínánká púreré nahne áwíratagéhe ire. Itega miraonka mah nahmé aebó kégá mehwatíáhnserah nah úkire úwe. ");
INSERT INTO awb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Úwara ómi mitaq sáhuríó kega Sísane ehwehnsabé áhtenu puara Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka tagéra Sísansabé áhreéra, We árahue subiq suanéhnkono éra sío síouwe. ");
INSERT INTO awb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Íó tupekútaq Sísareq we kéró kereqka Sarúsarama suwahpeq suera pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ahbiahipeq sega Sarúsarama suwahpeq kouwekoneherautaq ehyatagú awanká tagowana aiq moke ehyatagúwe. ");
INSERT INTO awb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ehyatagúwana Sísaga mi awánká teawu ehwéhmé Pítaga ahreraq matawéna Sísansabé, Íwáhnoraníno, tagáhno. Inokáh arega ehweh teawátóna awánká aiq ehyatagire úwana ");
INSERT INTO awb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sísaga sensabé, Manikánsabe aiq pútare atáhro. ");
INSERT INTO awb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Teiníboq írátíáhro. Wehukenínká sáwéhyabe teawena, Sáwého, arega mitaq sue anotah kawéhúpípéq kogahno teawinaraqmé mirainawire. Wega teawina ehwéhnsábé árahinabomo íwíáh íre ínaraq peh ínéga iraru ehwéh aiq pútaraginawire íwíáh ínaraqmé mirainawire. ");
INSERT INTO awb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Teiníboq írátíáhro. Ite púrerirataq aiq pútaq náinawire íwíáhirataq náinawire úwe. ");
INSERT INTO awb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sísaga mó mahraréna, Are iriwe púrerina tanáhráq mó anínsábé abiahnsa atéhnaraq wene ahbabáqsabe íre iwíáhue ahreraq matiahno. ");
INSERT INTO awb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Íópipeq míéh Ítéríbógá arene ahbabáqsabe íre iwíáhinkeheé abiahnsa atéh áníné ahbabáqsabe íre iwíáhue ahreraq matiahno úwe. ");
INSERT INTO awb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sega Sarúsarama suwahpeq mó sure Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq nogutaq Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereq Asiu kené aboawah wehreqka weba séra ");
INSERT INTO awb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kasenéra, Arega miraóna naneqme árahinie miraono? Insega miraúno atéhnsábé miraono? Teio uwe. ");
INSERT INTO awb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Teio uwana Sísaga sensabé, Ínéga itensabé moq kaseninie. Kasenona ehweh tenírataqmé ínénsabe miraúno aintárái aní teiníe. ");
INSERT INTO awb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Teiníe éna Sóniga wání meri merininkeheéna insega eqmaq áúwátáiro? Manikánka eqmaq áúwátáiro? Peh wehukega eqmaq áúwátóo? Teníéro úwe. ");
INSERT INTO awb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Teníéro éna, Tenírataqmé ínénsabe miraúno aintárái aní teiníe úwara sega epéq sío síoéra, Anere teawenéhnkono? Manikánka eqmaq áúwátáire teawénaraqmé wega itensabé, Aneqsabé wene ehwehnsabé íre aiq pútare atáró inae. ");
INSERT INTO awb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ite wehukega Sóni eqmaq áúwátówe moq íre teaweráhúne uwe. Ómi mó kegá, Sóni aiq pútaq Manikáne ehweh irari aní míre íwíáhunsabé sega mi keyábé áhreu puara ");
INSERT INTO awb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sísansabé, Sóniwe insega eqmaq áúwátáiramo. Ite íre tagarione uwana Sísaga sensabé, Itega íné íre teníéwe. Minayabe ínéga moq ínénsabe miraúno aintárái aní íre teiníe úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sísaga Asiu keyábé pabeqme ehwéh mahraréna, Wehga sonsoqme náhníáq sera ayu uqmarena wirarena wahnahnína uqná peataire. Pearena náhníáq sera ano kunubaipéq sarerankeheéna mata ubuqmarena mó keyábé, Néne sotáq wahnahnue náwe soqintewáhro aritena mitaq suena íre wahto wáhnaupéqté ké suwahpeq pokuraire. ");
INSERT INTO awb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Náhníáq sera irai tanáhráq ákáhtaq koweankeheéna wene arambehri aní sotáq wahnahnuro kebá eqmataire. ");
INSERT INTO awb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eqmatairara sotáq wahnahnuro kegá we táhtoqme sera íre náwasa subiqmarera kaqsúówe. ");
INSERT INTO awb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kaqsúówana so aboga mó arámbéhrí ání seba eqmatairara sega wene ayahqnotaq subiq marera íre kaweq sansá atárówe. ");
INSERT INTO awb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Íre kaweq sansá atárówana so aboga mó aní eqmatairara sega we subiq sutowana mó wene arambehri ke eqmaq sutairara sega mó tahmáró subiqme kaqsuera mó tahmáró subiq sutowe. ");
INSERT INTO awb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Subiq sutowana peh morá mó aní míaraire. Mi wehné arunáwí áhnínkáwá míarairana wega iwíáhéna, Nénahni púara sega wensabé áhtenéra wene ehweh iragéhe éna anehe wenahni eqmataire. ");
INSERT INTO awb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Eqmatairara wahto kuraitaq sotáq wahnahnuro kegá we tagéra seye náhenéra, So abone ahninkáwá aiq sire. Mah so awaq mianéhboq we subiq suanéhe íwíáhéra ");
INSERT INTO awb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","we táhtoqme sopípéq subiq suera wene anonka máhpeq tuparutowe. ");
INSERT INTO awb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Wenahni subiq sutonsabé so aboga mi ke anere aritankéhbo? Teiníboq írátíáhro. So aboga wene sotápéq séna wahnahnuro ke subiq suanawire. Subiq suena wene so mó ke kawerue wahnahnigeheéna eqsitankéhe. ");
INSERT INTO awb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Eqsitankéhe éna, Minayabe Manikáne ehwehnka íné éhweh mahraréna, Nah píáh kégá suto wahqká moke nahwiahnsanse kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Itene Wahnahnka mirainsabé itega, Kaweq sansáne íwíáhúne ire. Itewe mi sehirá íre ahtebaho úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Úwara wene ehweh irera seye náhenéra, Sísaga mah pabéqmé éhwéhnue itepi parobehre íwíáhuwe. Mira íwíáhu puara sío síoéra, We táhtoqme karábúsiipéq móatanéhe éra peh mitaq sáhuríó keyabé áhreunsabe mó iwíáhéra Sísa auwera pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Asiu wahnah kegá táhmaro Péhrasi kereq táhmaro Érótine iyahnaboreqsabé, Sísaga áhwára áhwára ehwéh irarinkehboq áhwárawe tagéq pokue págegeue kogasenoro éra eqmaq súówe. ");
INSERT INTO awb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eqmaq súówara kure Sísansabé, Íwáhnoraníno, ite tagarionawe arewe aiq pútaq ehwéh iraréna aní móne. Arega anotah kereq pehgáriq kereqsabé peh monseráh íwíáhóne. Arega wehuke íre ehnenia peh Manikáne sansá tábúsoqme pahsuqme íwáhnoróne. Minayabe teio. Aneq iwíáhono? Itega Aroma kené wahnahme Sísáhri táhkísi moné awenéhnkono? Árahonehnkono uwe. ");
INSERT INTO awb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Árahonehnkono uwana Sísaga sene epéráhpéru iwíáh tagéna sensabé, Aneqsabé íné áhwárawe tagéq níwíoqnaho? Ebah moné taganiboq mewe sero úwara ");
INSERT INTO awb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","sega peh morá ébáh móné ábóraq márówe. Ábóraq márówana wega sensabé, Mah monéráq insene píkísahakáq áwíqkakaq kehro úwara sega wensabé, Aroma kené wahnah aní Sísáhrine uwe. ");
INSERT INTO awb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Uwana wega sensabé, Aroma kené wahnahne náneq wewe náwéro. Manikáne naneq wewe Maniká náwéro úwara sega wene ehwehnsabé áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sáyúsi kewé pusa ké íre iriwe oganúq sitankéhe íwíáhu kee. Táhmaro mi kegá Sísaba séra wensabé, ");
INSERT INTO awb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Íwáhnoraníno, Mósísine sehiranka maharéna, Íre aninkákáq wéh pukínaraq wenábáqka kéweiní meyankéhe. Mi inínká maqmarahna anímárí wenawahne animárí míageheéna meyankéhe ire. ");
INSERT INTO awb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Minayabe abapete téhraníté se ábárahnahnah míarowe. Siwahwágá ahre mewena íre aninkákáq uraitaq pukuraire. ");
INSERT INTO awb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pukurairana náhmbáh 2 abaqkáwágá awahwáné kéweiní mewena íre aninkákáq uraitaq pukurairana náhmbáh 3 abaqkáwágá moq monseráhnuraire. Moke mi abáráhnáhnahnka mi iní mótaq mótarue mewera íre aninkákáq urotaq orah animárí pukurowe. ");
INSERT INTO awb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Moke mi abápéqté téhraníté se ábárahnahnah mótaq mótarue mi kewéíní mewera íre aninkákáq urotaq orah animárínká pukurowana sinehemé mi iní moq pukuraire. ");
INSERT INTO awb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Moke mi abáráhnáhnahnka mi iní meronsabé iriwe oganúq sitahnaraq insene ahre míanabo kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kasenuwana Sísaga sensabé, Itewe Manikáne púkuipéqté séhíránkákáq wega págegeue miraorahi sansánkákáq íre ahtebah puaq áhwára áhwára ahbabáq iwiáhowe. ");
INSERT INTO awb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Manikánka pusa ké iriwe oganúq sitahnaraq se peh íópeqté ké tahnsa mía míaigehe. Mi tanáhráq wehga ahre íre meyagéhe. Ahrega íre wehkigehe. ");
INSERT INTO awb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pusa ké oganúq sitahnayabé Mósísiga sehgíóro ú sehira íre sáhnsahoo? Uworapeqté káriq awanká irarehnsabé sehiramé Manikánka Mósísinsabé mahraréna, Íné Ébáráhmane Maniká múge. Íné Áhísáhkine Maniká múge. Íné Sékópane Maniká múge úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Manikámé íre pusa kéné Manikáne. Írakaumo. We peh oga míáh kéné Maniká míre. Minayabe itega íre tábúsoqme iwíáhowe úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mósísiga sehgíóro ú ehweh síwáhnori aní mitaq súwara Péhrasi kegá ehwehuwana irowe. Sísaga Sáyúsi kené kase ehwehnsabé tábúsoqme teriu púana wega Sísansabé kasenéna, Sehgíóro ú ehwehmé aneq ehwéhnká mó ehwéh kiotaikiro úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Úwana Sísaga wensabé, Kiotaiki ehwéh teaweníboq iro. Ísara keo, írátíáhro. Maniká itene Wahnah peh morá ání míéhre. ");
INSERT INTO awb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Maniká itene Wahnahnsabé irutaboiroro. Moke itene irupipeqkákáq moke iteiwankakáq moke itene iwíáhopipéqkákáq moke itene págege inónkánkákáq Manikánsabe irutaboiroro. Mah ehwéhmé moke mó sehgíóro ú ehweh aiq kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mó kiotaiki ehwéh iro. Arerensabé arutaboirónanserah mó anínsábé moq arutaboirúno. Mó sehgíóro ú ehwehnká mah ehwéhtáré íre kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Úwana síwáhnori anínká Sísansabé, Íwáhnoraníno, arega aiq tábúsoqme iraréne. Manikámé peh morá áníne. Peh morá webatare. Arega aiq pútaróne. ");
INSERT INTO awb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Itega Manikánsabe moke itene irupipeqmé, moke itene iwíáhipeqmé, moke itene págege inónkámé irutaboirúnawe, anotah kawéq sánsáne. Iteitensabé irutaboirúnanserah mó anínsábé moq irutaboirúnawe anotah kawéq sánsáne. Wehukega ménkámehnká subiqme agewe Manikánsabe titiraruqarurowe. Arutaboiré sansanká moke titiré sansa kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Úwana Sísaga we ahtebeh ehwéh irena wensabé, Manikánka wahnah wahnahnirabeq arewe wahtotaq míahne úwara míó ke síáhtónsabe mó ehwéh íre kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq síwáhnoréna míó keyabé, Mósísine ehweh síwáhnoro kegá, Manikánka omaq ato aní koweriréh ánímé we peh Tébítine anahwa wíre ewe. Mi ehwéhmé aneqsabé irareo kasenéna ");
INSERT INTO awb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Manikáne Awanka Tébíti iwíáh atowana igonkó pukúípéq sehiranúwana mi ehwéhnká mahraréna, Maniká itene Wahnahnka néne Wahnahnsabé, Niyah púpeq tútuue míéhnaraq arene naruo saiqnariankehe atóge úwe ire. ");
INSERT INTO awb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tébítiga mi anínsábé, Néne Wahnahne ato puana we árahue wene anahwa míanabo kasenúwe. Kasenúwara áhnte wehukégá wene ehweh irera anotahtaq iwíáh íwíáhowe. ");
INSERT INTO awb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sísaga síwáhnorútaq mahraréna, Mósísine ehweh síwáhnoro kegá mira onserahniyeho. Mó kegá se tagéra sensíwíq pankerageheéra íre wahto korósí úbíqmera nogówe. Sega máhkétirapéq nogótáq mó kegá se mehweh ariteyabe suwahbehre. ");
INSERT INTO awb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Momiwí nahtápéq pokotaq peh kaweqtapéq tútuue méyabe suwahbehre. Táhutahurorabeq aboawah wehwárí tútuue míáhrabeq méyabe suwahbehre. ");
INSERT INTO awb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sega kéweinínsónsábé péhe éhwéh teriera sene ménsámehnsánkakaq sene nahnkakaq mewe meweowe. Mó kegá ite kaweqtaq míáh ké wóe igeheéq wehuke míáhtáq íre wahtotaq púreq aruqarurowe. Mirao puana Manikánka ehweh aritahna tanáhráq se anotahtaq kamah arinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wehukega Maniká móne náwúrabeq Sísaga wahtotaq tútuue míowara áhnte kegá séra sene móne mitaq náwúwana tagówe. Tagówara áhnte monéákáq kégá áhnte moné náwúwe. ");
INSERT INTO awb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Náwúwana tabonah kewéínínká séna káriq monéráré náwuwe. Mi monéráré peh morá ákáhtaq pabusa móné tahnsane. ");
INSERT INTO awb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sísaga we kéró keyabé, Ínéba sewíáhro éna teiníboq írátíáhro. Mah tabónáh kéwéínínká náwí mónégá moke mó kegá náwé móné kiotaikire. ");
INSERT INTO awb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sega sene pehipi matíáh móné náwéwana mah tabónáh kéwéínínká moke wene matíéh mónéwé aiq náwíre. Aiq náwí púana amahnága táhutahuq paiqmarahna moné íre kéhre. Minayabe wega náwí mónégá moke mó kegá náwé móné kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sísaga Manikánsabe iwíáh íwíáh atáh náhtáqté wíráípéqté tueyokútaq we kéro anínká wensabé, Íwáhnoraníno, tagáhno. Nah kéh ébáhmé áhnte kaweq ebáhne. Áhnte kaweq ebáh náhmárí tagáhno úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Úwana Sísaga wensabé, Amahnága mi anótáh náhmárí aiq tagahno? Mi peréhnéhnia ébáhmárí miraue íre moráráq kagainae. Peh moke paentárara aruaneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Manikánsabe iwíáh íwíáh atáh náh korabeq seberiopéq Óríwi sawéhrápéq Sísa tútuue míowara Pítareh Sémísireh Sónireh Ehntarurehga weba séra kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kasenéra, Arega métáq irarénawe ahkake miraoneherabo? Miraonehera irataq aneq ábóraraginabo uwe. ");
INSERT INTO awb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Uwana Sísaga sensabé, Mi tanáhráqsábé mó kené péhe éhwéhnsábé aiq pútare arítéhboq auráq matawéq tagaríáhro. ");
INSERT INTO awb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Áhnte kegá mótaq mótarue néníwírue séra, Ínéwé Manikánka eqmaq núwéh ání múge irarirataq áhnte kegá sene péhe éhwéhnsábé aiq pútare aritagéhe. ");
INSERT INTO awb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mi tanáhráq ebehowe ira ehwéh ireq mó ebehowe sóiriq ehwéh íréhrataqmé íre áhreoro. Téhwe teiú náneq ebeq sínana anehe tanahráq íre apubúue sinae. ");
INSERT INTO awb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mó kehinánseq mó kehinánseqka ebehoneherawoe. Mó wahnáhné awahrahreq mó wahnáhné awahrahrerue ebehoneherawoe. Mitaq mahtaq máríinae. Ehwehranae. Minawarinká uwo uwoira tanáhráq áhwáranae úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Sísaga mó mahraréna, Kawerue auráq matíáhro. Sega ite kaunsíri ke kotiorarabeq móitera sene momiwí nahtápéq áréti sahtáté iubigéhe. Néne sánsá sehgíónsábé ákáhtaq wahnáh kéreq anotah wahnáh kéreqka ehweh aitageheéra seba móitagéhe. Mi tanáhráq néne ehweh terigéhe. ");
INSERT INTO awb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Téhwe kaweq ehwéh moke mah kehíná kéhíná teri terinigehe. ");
INSERT INTO awb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sega ehweh aitageheéra táhtoqme meiqmera móíúwéhrataq itega irarira ehwéhnsábé iwíáh kikiriyeho. Írakaumo. Mi tanáhráq Manikáne Awanka iwíáh aitahna ehwéh irarero. Mi tanáhráq íre iteitene ehweh irarigehe. Manikáne Awanka iwíáh aitahna ehwéh irarigehe. ");
INSERT INTO awb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Subiq suageheéra siwahwáréhga síbákawaréh móruehrara síbákawaréhga siwahwáréh móruagéhe. Subiq súáhro aritagéhe. Sibowáréhga monseráhnue sene animárí móruagéhe. Animárínká sinoibonsabé abiahnsa aritera subiq súáhro aritagéhe. ");
INSERT INTO awb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Néne sánsá sehgíó púara ómi kegá itensabé íre suwahbanae. Néne sánsá íre susa anehe tanahráqkákáq peh kawerue sehgírataq Manikánka ite meirena oga mérapeq móitankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Sísaga mó mahraréna, Íre kaweq ahbábárorahi naneq Manikánsabe iwíáh íwíáh atáhrabeq maragéhe. Mitaq órira kahnara tagagehe. Mah sehirá tagah keo, iwíáhue tagahro. Mi tanáhráq Súría marakórápéq míéhrataq sáwéhrapeq pehbeheráh pokoro. ");
INSERT INTO awb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mi tanáhráq máhpeq míéhrataq itene ménsámehnsá kiweyaneheéq nahupeq kibekiyehboq pehbeheráh pokoro. ");
INSERT INTO awb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sotápéq míéhrataq itene korósi koweyaneheéq itene nahtapeq kouwekiyehboq pehbeheráh pokoro. ");
INSERT INTO awb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mi tanáhráq kía míéhra inínsónseq inahunah ínínsónseqka íre pehbeheráh pokorahi puaq sensabé irutaboiroro. ");
INSERT INTO awb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ah áhnte karíéhínagake mi iré káwéq súnúq sínehboq púreroro. ");
INSERT INTO awb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mitaqkake anotah íre kaweq sunúq sinawire. Manikánka mah marákó márákó mirarotaqkakáq amahnágaákáq mina tahnsa sunúq íre kéhre. Mókake mó mina tahnsa sunúq íre sinae. ");
INSERT INTO awb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Íre sinae éna, Manikánka aiq iwíáhéna, Íné túbáh agonaraq mi sunúqká ómi mah kehiná kéhíná subiq suahráhire. Ómi subipáhraruehneho éna mi tanáhráq wahtonaraníe íwíáhúwe. Mira íwíáhúnsabe wega omaq sitéh kéyábé arutaboiri puana mi tanáhráq wahtonaruankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sísaga mó mahraréna, Mi tanáhráq mó kegá itensabé, Tagahro. Ite meirena kaweraintankeheéna Manikánka omaq ato anímé mahtaq míéhre irara mó kegá itensabé, We isebeq míéhre igehe. Sene péhe éhwéhnsábé aiq pútare arítého. ");
INSERT INTO awb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Íné Manikánka omaq intárái aní múge irarira kereq íné Manikáne ehweh iraru aní múge irarira kereq péhepehe ehwéhnue seneherawoe. Sega sirataq ótaq sansánkákáq anotah pagégé sánsánkákáq miraigehe. Áhnte kegá sene ótaq sansá tagéra sensabé aiq pútare aritageheéra mi sansá miraigehe. Manikánka omaq sitéh kégá moq sene péhe éhwéhnsábé aiq pútare aritageheéra miraigehe. ");
INSERT INTO awb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Moke teiú náneq mókake ábóraragína puaq auráq matawéq tagaríáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sísaga mó mahraréna, Mitaqkake íre kaweq sunúq sótaikínaraq pópoqnah íre patahinae. Inokáhpeq íre íónitanae. ");
INSERT INTO awb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wehyoqmarí íópeqté meginae. Íópeqté págege naneqmarí moke kúrugúruinae. ");
INSERT INTO awb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mi tanáhráq íné wehukení úku anínká piribirioyahnkakaq téhreh naneqkakáq págegeue tuonara tagagehe. ");
INSERT INTO awb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Túónagake pembíáhnka anotah ehwéhnínaraq Manikánka wene íópeqté ké eqmaq suankéhe. Eqmaq suena wega omaq sitéh kéyábé, Moke mah marákó márákórápéqté mitaqté kéweriqme mahtaqté kéweriqme ue ue meriqme sero inkehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sísaga mó mahraréna, Awankánsabe iwíáhue tagéq iahtebahro. Awanká ayahnawe anonkakaq kahnana ánáh aunínaraq itega iwíáhéq, Ópeq áhníbórá sire aiq ahtebóne ewe. ");
INSERT INTO awb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mina onserah moke teiú náneq ábóraragínaq tagéq íné túóna tanáhráq aiq wahtotarire igehe. ");
INSERT INTO awb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Teiníboq írátíáhro. Amahnága oga míáh kégá ómi pehipi íre pukigehe. Ebeqme moke teiú náneq ábóraragínaq tagéq anehe pukigehe. ");
INSERT INTO awb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Íópeqkákáq mah marákó márákóákáq parabagínana ínéga teiú éhwéhmé íre parabagia peh ahriahri kagainawire. ");
INSERT INTO awb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sísaga mó mahraréna, Íné túóna wehekáhnkákáq áhwahakáq ómiga íre ahtebahwe. Íópeqté kégá íre ahtebahwe. Íné Manikáne ahninkáwágá moq íre ahteboge. Peh morá Maniká Iteriboga webataq mi wehekáh tagaríéhre. ");
INSERT INTO awb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Túóna tanáhráq ite íre tagaríáh púaq níwénunéq kawerue auráq matíáhro. ");
INSERT INTO awb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Íné túónaraqmé wehga íre wahto ah nógínserahne. Wega wene nahtapeq suena pokinaitaq wene arambehri ke wahnah arámbéhríráq sítéhre. Mó aní mó arámbéhríráq mó aní mó arámbéhrírárue sítéhre. Ahnansahraq wahnah atéh ánínsábé, Kawerue auráq matiahno éna pokire. ");
INSERT INTO awb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mina inserah íné anotah Wahnáh túóna tanáhráq íre tagaríáh púaq kawerue auráq matíáhro. Íó tupekínaraqpópoq inokáhnabubupopoq kokórega téh ehwehnínaraqpópoq ahbiahipeqpópoq tuinauge. ");
INSERT INTO awb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Apubúue túónaraq ite sugéhboq peh kawerue auráq matíáhro. ");
INSERT INTO awb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Itensabé teiú éhwéh ómi mah kehiná kéhíná teríúge. Níwénunéq kawerue auráq matíáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ahrina tahnsá sótaikú iahreraq ko tanahráq íre múí párétí né tanahráq wahtonútaq Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka sío síoéra, Sísawe árahue epéq táhtoqme mósubiq suanéhnkono íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mira íwíáhéra, Áhnte wehekéqká táhutahurirataq ehwehéra tobehiyehboq Sísa pehraganehe uwe. ");
INSERT INTO awb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pétáni suwahpeqte ání Sáímóniwe anotah nao wagú anine. Minayabe mó kegá, Náonkakaq Sáímónie ue wéhuwehu áwíratówe. Sísaga Pétáni suwahpeq ména mi aníné nahtapeq táhutahurúwana peh morá ínínká áhnte moné tahnsa wérí ántéhyá mewe súwe. Mewe séna mi antéhyá piteruqme Sísane ayahqnopeq wéri antiatowe. ");
INSERT INTO awb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Antiatowara táhmaro míó kega abiahnsanéra seye náhenéra, Mi weríwé aneqsabé pehipi antiatehro? ");
INSERT INTO awb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Íre pehipi antiatéhtáq tahirímé mi werí paiqmarena 300 moné mewena mi moné tabonah ke nárí irino éra mi inínsábé awehgu atówe. ");
INSERT INTO awb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Awehgu atówana Sísaga sensabé, Mi iní pehragatáhro. Aneqsabé awehgu ataho? Wega mira aintéh sánsámé kaweq sansáne. ");
INSERT INTO awb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tabonah kewe ahriahri iteba mía míaowaq ite iuwahbáhnagake séhréh aritahráhowe. Ínéwé ahriahri iteba íre mía míainie. ");
INSERT INTO awb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mi inínká aiq miraorahi sansá aiq miraire. Íné maisarageheéna mi inínká ninonka abaq intéhre. ");
INSERT INTO awb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Teiníboq írátíáhro. Mah marákó márákó kaweq ehwéh teri terinirataq wega amahnága mirai naneq ehwehnkákáq terigéhe. Terírataq íréhra kegá wéri abaq intéh ínínsábé iwíáhigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sísa kéró ke airápété téhraníté míówe. Sebaté ání wenáwíqtare Súrása Ísíkáríótie. Wega Manikáne ehweh mibeq mahbeq arítáh kébá pokue sensabé, Sísa iteba méauwaníe úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Méauwaníe teriuwara iwíáh íwíáhéra móne awenéhboq miraúno uwana Súrásaga kowe aritena se Sísaba mórite tanáhráqsábé iwíáhue kabarúwe. ");
INSERT INTO awb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Íre múí párétí né tanahráq ebeqte wéhékáh sótaikú iahreraq ko tanahráq sútaq Asiu kegá sipisípiq áráhq subiqme titiru tanahráq súwe. Mi tanáhráq we kéró kega Sísaba séra wensabé, Sótaikú tanahráq iahreraq kéh táhútáhúq nankehboq eheq kogaweratanéhnkono ue kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kasenuwana Sísaga we kéróya aníté eqmaq suanaútaq sensabé, Wahtotaq kehiná suwahpeq pokotao. Obenkisa wání ántéhíyánkákáq ánínseq piehgírataq kéráhtao. ");
INSERT INTO awb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","We kibekína nahtápéqté ábówánsábé mahraréta, Íwáhnori anínká mahraréna, Ínéreq íné séníráh kéreqka sótaikú tanahráq iahreraq kéh táhútáhúq nanehboq mi paqnáhípéq teio ire teawetao. ");
INSERT INTO awb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Teawírataqmé wega ménsámehnsá aiq kaweria páqnáhípéq teinkéhe. Mitaq itene táhutahuq kaweraráhtao éna eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eqmaq suowara mi anítégá mi ke suwahpeq pokue Sísaga teriunserah tagéra mitaq sótaikú tanahráq iahreraq ko tahutáhúq kaweraróye. ");
INSERT INTO awb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Íó tupekútaq Sísareq airápété téhraníté we kéró kereqka mitaq séra ");
INSERT INTO awb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","tútuue táhutahurutaq Sísaga sensabé, Teiníboq írátíáhro. Ite míáhrabeqte ání ínéreq moráráq nóya anínká néne naruo kowerirankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Úwara sene sirupipeq umeh agúwara morá ání morá ánínkáue Sísansabé, Arega ínénsabe irareno ue kasenuwe. ");
INSERT INTO awb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kasenuwana Sísaga sensabé, Airápété téhraníté omaq sitórabeqte ánínká ínéreq morá párétáhípéq páréti pámbáhúya anímé we wire. ");
INSERT INTO awb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Manikáne ehwehnka aiq irarinserah íné wehukení úku aní pukinie. Néne naruo kowerirahna aní anotahtaq kamah awinawire. Wenanoga we íre maqmiotaq tahirímé aiq kaweri irino úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sega táhutahurutaq Sísaga páréti mewena Manikánsabe kaweróne atena keqme náriena sensabé, Mahnawé niwaq mire. Náhro úwara nowe. ");
INSERT INTO awb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nowana wega náhníáq sera ano kahpú mewena Manikánsabe kaweróne atena náriuwara ómiga nowe. ");
INSERT INTO awb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sísaga sensabé, Mahnawé néne korahq mire. Néne korahq tuinaga itereq áhnte mó kereq Manikánka insahwé aitena itene ahbabáq kaweraitankéhe. ");
INSERT INTO awb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Teiníboq írátíáhro. Náhníáq sera ano mahtaq mó íre nanie. Mókake Manikánka wahnah wahnahnínarabeq míáhnaraq o sera ano nanie úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sega Manikánsabe iwíáh íwíáh igonkónéra máhpeq tueyokéra Óríwi sawéhrápéq pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sísaga sensabé, Manikáne ehwehnka mahraréna, Ínéga sipisípiq Wahnáh subiq súáhnaraqmé moke sipisípiqmarínká kobeq séberigehe ire. Mi ehwéhnká irarinserah ite ómiga íné nuweq kobeq séberigehe. ");
INSERT INTO awb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Manikánka íné oganúq intahnaraq Kehrari marákórápéq ebeq konaq inehe sigehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Úwana Pítaga Sísansabé, Ómiga are áúwéhrataqmé ínéga íre auwanauge úwana ");
INSERT INTO awb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sísaga wensabé, Teawiníboq írátíahno. Ibora inókáhpéq kokórega téhtaréráq ehwehnina ínaraq arega íné íre tagaríóge apahtáróráq irariniewóne úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Úwana Pítaga mi ehwéhnsábé anotahtaq ahqáho éna Sísansabé, Mó kegá arereq ínéreq iubiq súéhrataqmé ínéga are aiq tagaríóge atanauge úwara sega moke wega irarúnserahnuwe. ");
INSERT INTO awb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sísareq we kéró kereqka mitaq suera mátabu áwíq Késémáni pokuwe. Sísaga sensabé, Ite mahtaq tútuue míehrana íné kobúrerono éna ");
INSERT INTO awb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pítareh Sémísireh Sónireh móbeq móritowe. Móritena wene arupipeq anotah uméhue págege agúwana ");
INSERT INTO awb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","wega sensabé, Nirupipeq anotah uméhinka pukorahuge. Mahtaq tótuqméq tagaríáhro éna ");
INSERT INTO awb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","se suena wahtotaq móbeq pokéna marakóraq káuqmunue ména púrerúwe. Púreréna íre kaweq sunúq weba sínehoéna púrerúwe. ");
INSERT INTO awb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Púrerue mahraréna, Nániboo, arega moke miraorahóne. Mah iré káwéq súnúq móruo. Íre íné nuwahbeh sansá peh are awahbáhna sansánúno ue púrerúwe. ");
INSERT INTO awb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Púreraruena wega Pítarehba kouwekéna tagówara sugówe. Sugówana wega Pítansabé, Sáímónio, aneqsabé sugahno? Pehgáriq tanahráq árahinsabé íre tótuqmé níwénunorahoo? ");
INSERT INTO awb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Iteiyuwanka kaweq sansánéyabe iuwahbehre. Peh itene inonka mareqmarero puaq íre miraorahowe. Minayabe owainawanka ahbabáq aitehnehboq tótuqméq púreroro éna ");
INSERT INTO awb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","mónkakáq kobúrerúwe. Métáq púrerúnserahnue mó púreréna ");
INSERT INTO awb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pítarehba mó kouwekéna tagówara se anotah mukúqmáhkúru puara se peh sugówe. Sugówana Sísaga iriritowara siyehitónsabe ehiya míówe. ");
INSERT INTO awb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sísaga apahtáróráq kéna séna ú púana sensabé, Ite peh ahrenaneheéq sugaho? Aiq míre. Íné wehukení úku aní ahbabáq ke kowerire tanahráq aiq sire. ");
INSERT INTO awb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pokonehboq irigoro. Tagahro. Néne naruo koweriréh ánínká aiq sire úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sísaga mi ehwéh irarútaq Súrása we kéro anínká apubúue súwe. Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísiga miraoro ú ehweh síwáhnoro kereq Asiu kené aboawah wehreqka áhnte mó ke eqmaq súówara sega pokamarinkákáq sahmárínkákáq Súrásareq moráráq suwe. ");
INSERT INTO awb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Seneherautaq koweriro anínká su ke teriena, Ínéga nánkóqnahna anímé Sísa wire. Táhtoqme kawerue meqme móáúwáhro úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Minayabe Súrásaga sútaq Sísaba apubúue séna wensabé, Íwáhnoraníno éna nánkóqnówe. ");
INSERT INTO awb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nánkóqnówara sega Sísa táhtoqme ambubuue táhtotíówe. ");
INSERT INTO awb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Táhtotíówana mó anínká wene poka mewena Manikáne ehweh mibeq mahbeq arítéh áníné arambehri aní apiwe wene ahre kiraq auwowe. ");
INSERT INTO awb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kiraq auwowana Sísaga sensabé, Aneqsabé aebó ání táhtoráhnserah pokankákáq sahnkákáq íné meniraneheéq seo? ");
INSERT INTO awb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mó wehekáh mó wehekáhnue Manikánsabe iwíáh íwíáh atáh náhtápéq áhnte wehekáh itereq ména íwáhnorurautaq mi tanáhráq itega íné íre táhtotiarowe. Manikáne ehwehnka irarinserah aiq pútaraginkeheéq miraowe úwara ");
INSERT INTO awb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","we kéró kega Sísa auwera pehbeheráh pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pokuwana káriq mahbígá peh taberábe ambántá úbíqmena Sísa anehe kaqmena kérowe. Kérowara míó kega we táhtorówana ");
INSERT INTO awb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wene ambanta kesuena pehrákora pehbeheráh pokúwe. ");
INSERT INTO awb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sega Sísa meqmera Manikáne ehweh mibeq mahbeq arítáh kéné wahnahpa pokuwara moke Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereq Asiu kené aboawah wehreqka mitaq momiwíuwe. ");
INSERT INTO awb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Se mótaq we mótarue Pítaga sinehe kaqme kure Manikáne ehweh mibeq mahbeq arítáh kéné wahnahne nahnoerápéqté mátábúráq kúwe. Kure mitaqté párísíréhreq tútuue méra iraraq totoruwe. ");
INSERT INTO awb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Manikáne ehweh mibeq mahbeq arítáh kéreq moke mó kaunsírí kéreqka Sísa subiq suanéhboq wega ahbabáruraime insega tagarairo éra kabaruwara íre pahsúówe. ");
INSERT INTO awb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sísaga miraúnsabe áhnte kegá péhe éhwéhnéra íre morá éhwéh iraruwe. ");
INSERT INTO awb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Táhmaro kegá irigue péhe éhwéh atera mahraréra, ");
INSERT INTO awb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Itega wene ehweh írátáúne. Wega iraréna, Manikánsabe iwíáh íwíáh atáh náh wehukega pearó nah sokoruqme apahtáró wéhékáh mó nah pearaníe. Íre niyahnkaratáté pearaníe uraire éra ");
INSERT INTO awb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","sene ehwehme peh úbíráhbíq ehwehnéra íre morá éhwéh iraruwe. ");
INSERT INTO awb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka irigue ákáhpi kowéna Sísansabé kasenéna, Mah kegá arensabé irare ehwéhmé arega íre terieráhono? Sene ehweh aiq pútaq ehwéhpo úwana ");
INSERT INTO awb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sísaga íre iraria peh ehiya míowe. Peh ehiya míowana wega Sísansabé, Manikánka ite Asiu ke meirena kaweraitankeheéna peh morá ání omaq atowe. Arewe mi anípo? Arewe Manikáne ahninkáwábo kasenúwana ");
INSERT INTO awb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sísaga wensabé, Íné we uge. Íné wehukení úku anínká Manikáne ayah púpeq tútuue ména íópeq írábúyápipeqté tuonaq tagagehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Úwana Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka mi ehwéh irotaq abiahnsanú púana wene korósi subansuena mahraréna, Wega aiq irarinsabé mó keyábé móme íre kasenoro. Ahqáho. ");
INSERT INTO awb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wega Manikánsabe íre kaweq ehwéh atéhraq íráhwe. Minayabe aneratanéhnkono úwara sega moke mahraréra, Wega ahbabáq ehweh aiq irari puaq subiq suo atanéhe uwe. ");
INSERT INTO awb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Táhmaro kegá Sísa tehqni atera wene auranabiah ambantaraté akariatawéra subiqmarera, Insega are subiqmarehro? Teio uwara párísirehga Sísa meqmera mósubúwe. ");
INSERT INTO awb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pítaga nahnoerápéqté mátábúráq tumíowana Manikáne ehweh mibeq mahbeq arítéh áníné arambehri ahrárígá súwe. ");
INSERT INTO awb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Súwana Pítaga iraraq totorúwana mi ahrárígá we tagéna ebitáwéna wensabé, Are Sísa Néhsara suwahpeqte ánínseq míarone úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Úwana Pítaga ahqáho atena, Arega iraréna ehwéhmé íre ahteboge. Aneq ehwéhnono éna mitaq suena méhpehpeq pokúwana kokórega téh ehwehnúwe. ");
INSERT INTO awb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mi ahrárígá méhpehpeq Píta mó tagéna míó keyabé, Mah anímé Sísa awahrahní míre úwe. ");
INSERT INTO awb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Úwana Pítaga mó ahqáho atowe. Pehgáriq motáq tahnsa mitaq míó kega Pítansabé, Are Kehrari marákórápéqté ání púah are wenawahrahní móne uwe. ");
INSERT INTO awb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Uwana Pítaga ehbonéna mahraréna, Manikánka tagaríéhtáq aiq pútariahnsanuge. Itega irare anímé íné íre tagaríóge. Ínéga péhe éhwéh teawénaraqmé Manikánka íné nubiq suankéhe úwana ");
INSERT INTO awb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","kokórega mó ehwéhnúwe. Mó ehwéhnútaq Sísaga teawu ehwéh Píta ahreraq kowe. Mina teawu ehwéhmé, Kokórega téhtaréráq ehwehnina ínaraq arega apahtáróráq íné íre tagaríóge irariniewóne úwe. Pítaga mi ehwéh ahreraq kowana wene arupipeq umehúwana anotahtaq ibisówe. ");
INSERT INTO awb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ahbiahipeq Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreq Mósísine ehweh síwáhnoro kereq moke mó kaunsírí kéreqka momiwíue Sísa subiq súéhra ehwéh sío síoéra wene ayahnkaratáq nágáqtate táhru táhrue meqmera anotah wahnáh ání Páhírátiba móátówe. ");
INSERT INTO awb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Móátówana Páhírátiga wensabé, Arewe Asiu kené wahnahpo kasenúwana wega wensabé, Arega aiq iraréne úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Úwara Manikáne ehweh mibeq mahbeq arítáh kégá Sísa áhnte ehwéh atówe. ");
INSERT INTO awb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ehweh atówana Páhírátiga Sísansabé, Sega arensabé áhnte ehwéh atáhwe. Minayabe arega ehweh íre terieráhono kasenúwana wega peh ehiya míowe. ");
INSERT INTO awb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Peh ehiya mío púana Páhírátiga iwíáhue tagéna áhtenúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Anotah tahutáhúro tanáhráq mó opéq mó opérue karábúsiipéqté ání Asiu kegá pugeqio teawú ani Páhírátiga pugesuaq pugesuarúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wehukení wenáwíq Páréhbae. Wereq mó kereq ebehutaq Páréhbaga wehukení subiq suonsabe karábúsiipéq míowe. ");
INSERT INTO awb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Karábúsiipéq míowara áhnte kegá kire Páhírátinsabé, Are ahriahri mira aruqarurona serahnúno uwe. ");
INSERT INTO awb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Uwana Páhírátiga sensabé, Asiu kené anotah Wahnáh pugeq inínkono kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kasenéna iwíáhéna, Manikáne ehweh mibeq mahbeq arítáh kégá, Sísaga ite kiotaikíneho éra abiahnsa atáh púara ínéba meqme sewe íwíáhúwe. Mira íwíáhú púana wega sensabé, Asiu kené anotah Wahnáh pugeq inínkono kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kasenúwara Manikáne ehweh mibeq mahbeq arítáh kégá míó keyabé pagu pagunéra, Mah ehwéh Páhíráti koreawéro. Wensabé teaweq, Páréhba pugeqauwe Sísa subiq súáhro arito koreawéro éra pagu pagunuwara míó kega, Páréhba pugeqio uwe. ");
INSERT INTO awb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Uwana Páhírátiga sensabé mó kasenéna, Itega ite Asiu kené Wahnahne ue áwíratáh ánímé aneratanínkono úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aneratanínkono úwara sega ehweh kikiréra, Awankátaq táhpawe subiq suo uwana ");
INSERT INTO awb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Páhírátiga sensabé, Aneqsabébo? We aneq ahbabáriro kasenúwara sega mó anotah ehwéhnabaéra, Awankátaq táhpawe subiq suo uwe. ");
INSERT INTO awb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Uwana Páhírátiga míó kene sirupipeq eyoyóigeheéna Páréhba pugeq auwena Sísa áréti sahtáté subóro aritena sóntía kegá awankátaq táhpawe subiq suageheéna siuwe. ");
INSERT INTO awb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sóntía kegá Sísa meqmera wahnah anínká ehwehúrabeq kibekue móatera ómi mó sontíá ké síáhrabuwara momiwíuríówe. ");
INSERT INTO awb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Momiwíéra peh morá tautáúq korósí abaq atera ógaratáté keborarera wene ayahqnotaq suki atówe. ");
INSERT INTO awb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Suki atera wensabé, Aiq míahno? Arewe Asiu kené Wahnah mone éra ");
INSERT INTO awb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","wiahnó sahtáté ayahqnotaq subiqmarera tehqni atera sirehunseraráq méra Sísansabé péhepehe iwíáh íwíáh atera ");
INSERT INTO awb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","awiréh atówe. Awiréh atera abaq ató korósí akai auwera wewene korósi suki atera awankátaq táhparaneheéra meqmera pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sóntía kegá Sísa meqmera pokuwana Sáíríni marákórápéqté ání wenáwíq Sáímóni ahtapeq sure Sarúsarama suwahpeq pokinieéna sótaikinaúwe. We Árékásántareq Árúpareqne sibowá míowe. Sóntía kegá we saiqnatera, Sísa táhparéhra awánkámé abaqme kúno atónsabe abaqmena kúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sísa meqmera Kógóta sawéhrápéq kíúwe. Mi sawéh áwíqmé áwahewé wehukení ayahqno tánúnsutapére. ");
INSERT INTO awb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mitaq sega íre érorahi kítabeh maráhsíní mewera náhníáq sera anopipéq sombirahue Sísa náwúwana ahqáho éna íre nowe. ");
INSERT INTO awb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Íre nowara sega we meqmera awankátaq níriraté wene ayahnkaratáq subiqmaq aigárátáq subiqmarue táhparera awanká pankeqme marakóipeq pearówe. Pearera, Wene korósi insega meyanabomo éra saraqmianeheéra káhsiue saraqme meyówe. ");
INSERT INTO awb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wéhékáh íó ákáhtaq kiutaq awankátaq táhparówe. ");
INSERT INTO awb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ehweh átó ehweh kanehraq sehiranúwara wene ayahqno abobóráhpeq awankátaq táhparówe. Mi sehíránká mahraréna, Asiu kené Wahnahne úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Sísa awankátaq táhparórabeq aebó áníté moq awankátareráq níri pewe táhparéra pankeqme ayehré ayehré pearówe. ");
INSERT INTO awb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pearówara mitaq sótaiku kegá Sísa tagéra awiréh atera sinuo kóbiq kóbiréra wensabé íre kaweq ehwéh atówe. Íre kaweq ehwéh atera mahraréra, Manikánsabe iwíáh íwíáh atáh nah sokoruqme apahtáróráq mó pearahráhóna aníno, ");
INSERT INTO awb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","arere séhréhúno. Oga míankehboq marakóipeq tueagúno éra awiréh atówe. ");
INSERT INTO awb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Awiréh atówara Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka moq awiréh atera mahraréra, Wega mó ke kaweraritena peh wewe íre kawerorahire éra ");
INSERT INTO awb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","wega, Íné áhnte wehuké merirena kaweraritankeheéna Manikánka omaq intowe íwíáhire. Íné Ísara kené Wahnah aní múge íwíáhire. Wega maraipéq tueagínaq tagéq wensabé aiq pútare atanéhe éra awiréh atówe. Awankátaq táhparó anitégá moq íre kaweq ehwéhnéra Sísansabé awiréh atóye. ");
INSERT INTO awb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wéhékáhnabubu moke mah marákó márákó sunkíkíragúwana íó tunsorerutaqkakáq peh sunkíkíratiowe. ");
INSERT INTO awb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tunsorerutaq Sísaga wewene ehwehtaq Wenabonsabé anotahtaq mahraréna, Írói, Írói, tahmah sabáhtahnie úwe. Mi ehwéhnúmé, Nániboo, Nániboo, aneqsabé íné nuwahno úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Úwara táhmaro iriwe míó kega irera mahraréra, Íráhro. Éráísansabé áhrabire uwe. ");
INSERT INTO awb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mibeqté ánínká pehbeheráh sehenáh tahnsa náneq mewena kítabeh nah naneqpipéq pámbáhue sehikaratáq maqme pankeqme Sísaga píbíra nankeheéna awuwe. Awena mahraréna, Éráísaga marakóipeq atanabiramo. Taganeheqmúne úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Úwana Sísaga anotahtaq ehwehnéna putiowe. ");
INSERT INTO awb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Putiotaq Manikánsabe iwíáh íwíáh atáh náhtápéqté páráhnkéq tahnsa ónsá senahpeqté subame tunse téhtaré úkúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sóntía kené kíápéténiga Sísane auranabiahtapeq ména we putionsabe tagarawéna mahraréna, Mah anímé aiq pútaq Manikáne ahninkáwá wíre úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sísa putiotaq ahreronká mobeq iriwe méra awahnkanuwe. Mágára suwahpeqte íní wenáwíq Máhríae. Sémísi anehe piah anínseq wenawah Sósépareqne sinowa wenáwíq moq Máhríae. Mó iní wenáwíq Sárómie. ");
INSERT INTO awb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sísaga Kehrari marákórápéq síwáhnorútaq mi inítógá we kérera wene táhutahuq tíátówe. Mi inítáróreq mó Sarúsarama suwahpeqte su ahrérónseqka mobeq iriwe méra awahnkanuwe. ");
INSERT INTO awb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ahbiah tahnsá ahrena ahrena wehekáh ibora táhnsá táhutahuq kaweq kaweré wehekáh íó tupekútaq Sósépaga Páhírátiba pokúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Sósépawe Árímátéa suwahpeqte ánínúwara mó kegá, We kaweq abóáwáh wéh wíre íwíáhuwe. We Manikánka wahnah wahnahni tanáhráq áwénunue taga tagaú aní míre. We íre áhreia Páhírátiba pokéna wensabé, Sísane anonka mewena mómaisaranínkono úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Úwana Páhírátiga, We putiehramo íwíáhéna kíápéténine wahnah áhrabéna, Aiq putiehro éna kasenúwe. ");
INSERT INTO awb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kasenúwana, Aiq putíéhre úwana Páhírátiga Sósépansabé, Wene anonka meyo úwe. ");
INSERT INTO awb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Úwara Sóséparehga íre wahto taberábe ambántá paiqmarera Sísane anonka kiwewe marakóraq márumarera ambantaipéq úbíqme mewera ubusa onápípéq mómaisarówe. Maisarera ebah ubusa ónápípéq marera anotah ebáh paentáwe kure maisiaró mehpéh paiqmarera pokuwe. ");
INSERT INTO awb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mágára suwahpeqte ínínseq mó wenaogo Máhría Sósépane anowareqka Sísa maisarórabeq tagoye. ");
INSERT INTO awb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ahrena ahrena wehekáh parabagúwara Mágára suwahpeqte íní Máhríareq Sárómireq Sémísine anowa mó Mahríáreqka Sísane anonka abaq ataneheéra kaweq kunkúni werí paiqmárówe. ");
INSERT INTO awb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Paiqmárówana o wikí kowara ebeqte wéhékáh ahbiahipeq íó kiembogútaq mi inínsónká maisiaró onápípéq pokéra ahtapeq kure ");
INSERT INTO awb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","seye náhenéra, Méhpeh paiqmáráh ébáhmé insega paentáwe méreitanabomo uwe. ");
INSERT INTO awb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Uwana anotah ebáhnaba kowara sega tagowana méhpehtaq íre paisa peh móbeq kowara tagowe. ");
INSERT INTO awb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tagéra maisiaró onápípéq kibekuwana íre wahto taberábe korósíákáq máhbí éberiopéq tútuue míowara tagéra áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Áhtenuwana wega sensabé, Íre áhtenoro. Ite Sísa Néhsara suwahpeqte ání awankátaq táhpato aní seragahwe. We oganúkéna mahtaq íre míéhre. We maisatotaq tagahro. ");
INSERT INTO awb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","We kéró kereq Pítareq korerieq, Wega Kehrari marákórápéq ebeq kínaq itega mitaq kirataq tagagehe. Wega teiátáinserah itega mitaq we tagagehe koreríéro úwe. ");
INSERT INTO awb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Úwana mi inínsónká tueyokéra iransánue áhtenunsabe pehbeheráh kure áhreu puara ahtapeq sótaiku ke íre teriasa peh ehiya méra pehbeheráh kótaikuwe. ");
INSERT INTO awb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ebeqte wehekáh o wikí ahbiahipeq Sísa oganúkéna wega Mágára suwahpeqte íní Máhríaba ebeq súwe. Wega mó tanáhráq abapete téhtaré ówáínáwánsábé, Máhría auweq pokoro arito iní míre. ");
INSERT INTO awb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sísaga mi iníbá ebeq súwana mi inínká pokue Sísa kéró keba pokúwara Sísa pukúnsabe wensabé sirutaboiréra ibisowana Máhríaga koreriena, ");
INSERT INTO awb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sísa oga míéhrana tagoge úwe. Úwara wene ehwehnsabé íre aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Anehe téhranítégá uworapeqté áhtápéq nogúyataq Sísaga mó aní tahnsa úkue seba súwe. ");
INSERT INTO awb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Súwara sega kouwekéra moke Sísa kéró ke koreríúyara sene ehwehnsabé moq íre aiq pútare arítówe. ");
INSERT INTO awb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Anehe we kéró ke peh abapete morá ké méra táhutahurutaq Sísaga seba súwe. Sirupipeq págege éra we oganúkú ehwehnsábé íre aiq pútare arítónsabe sensabé siwehguúwe. ");
INSERT INTO awb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sensabé, Moke mah marákó márákó pokue mah kehiná kéhíná kaweq ehwéh koreríéro. ");
INSERT INTO awb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ínénsabe aiq pútare aintera wání meyéhra kewé Manikánka oganúq sitankéhe. Ínénsabe íre aiq pútare aintéhra kewé ehweh aritankéhe. ");
INSERT INTO awb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ínénsabe aiq pútare aintéhra kegá teiéna otáq sánsá miraigehe. Néníwírue owainawamarí kaqsuagéhe. Kambare ehwéhnigehe. ");
INSERT INTO awb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ayahtate wehe táhtoragéhe. Pukorahi naneq nehrataq íre pukigehe. Siyahnkaratáté awahre ke táhtoréhrataq kaweraginkehe úwe. ");
INSERT INTO awb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sísa itene Wahnahnka aiq teriuwana Manikánka we íópeq tumerowana wene ayah púpeq tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","We kéró kega pokue mah marákó márákó áhnte kehiná kaweq ehwéh teri terinuwe. Itene Wahnahnka se séhréh aritonsabe sega ótaq sansá mirauwara író kega tagéra, Mah ehwéhmé aiq pútaq Manikáne ehwéhne uwe. ");
INSERT INTO awb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tíópírása anotah wahnáh áníno, ite míaraunarabeq áhnte kegá Manikánka miraurai naneqsabé iwíáhéra sehiranurowe. ");
INSERT INTO awb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sehiranuro kegá Manikáne ehweh teri terinera wega miraurai naneq tagaro kené ehweh irera teníátówe. ");
INSERT INTO awb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Téhwe tago kereq sehiranuro kereqsabé kasenéna sene ehweh iwíáhue tagarauge. Anehe ínéga moq mi ehwéhnsábé tábúsoqme sehiranéna areba eqmarahnah sáhnsahinkéhe. Tíópírása kaweq aníno, ");
INSERT INTO awb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","arega aiq pútaq ehwéh irankeheéna sehiranue teawúge. ");
INSERT INTO awb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Súría marákórápéq wahnahnú aní Érótiga wahnahnútaq Manikáne ehweh mibeq mahbeq arítéh ání wenáwíq Sékáráía ména we Ábíya kahnáh mibeq mahbeq arito ani míowe. Wene ahre Áróni kahnáh íní ména wenáwíqmé Érísábétie. ");
INSERT INTO awb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mi akéqká kaweqtaq méra Manikánka sehgíóro ú ehwehnkákáq wene sánsánkákáq moke tábúsoqme sehgíúye. ");
INSERT INTO awb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Se orení ákéq méra Érísábéti orahini puara se íre aninkákáq míóye. ");
INSERT INTO awb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","We kahnáhnká arambehriutaq Sékáráíaga Manikáne ehweh mibeq mahbeq arito ani ména arambehriúwe. ");
INSERT INTO awb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","We kahnáhnká sene sánsánéra Manikánsabe iwíáh íwíáh atáh náhtápéq kaweq kunkúni naneq pariankeheéra Sékáráía eqmarówe. ");
INSERT INTO awb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pare tanahráq áhnte kegá máhpeq méra púreruwana Sékáráíaga webataq nahupeq kibekéna mi kawéq kúnkúni naneq tahberapeq pariowe. ");
INSERT INTO awb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pariowana Maniká míéhrabeq íópeqté ánínká ábóraragéna tahbe ayehrápéq iriwe míowana ");
INSERT INTO awb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sékáráíaga we tagéna kurináhnéna iwíáh kikiréna áhreúwe. ");
INSERT INTO awb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Áhreúwana íópeqté ánínká wensabé, Sékáráíao, íre áhreúno. Manikánka arega púreróna ehwéhmé aiq íréhnsábé arene ahre Érísábétiga animai maqmiankéhe. Maqmiahnaraq arenahninsábé Sónie ue áwírato. ");
INSERT INTO awb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Maqmiahnaraqmé arene arupipeq eyoyóue iwíáh íwíáhinkehe. Áhnte mó kegá moq iwíáh íwíáhigehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Iwíáh íwíáhigehe éna, Maniká itene Wahnahnka wensabé, Are anotah aní míahno atanawire. Ahriahri we náhníáq sera anonkakaq píahakáq awehriinkehe. Wenanone arupipeq míahnaraq ahriahri Manikáne Awanka wereq mía míainkehe. ");
INSERT INTO awb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wereq mía míairana wega Manikáne ehweh teri terinínaraq áhnte Ísara kegá Maniká itene Wahnahne sánsá kawerue sehgigéhe. ");
INSERT INTO awb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Éráísa Manikáne ehweh irarú ani marakóipeq míotaq anotah aní ména págegeue síwáhnorúnserah itene Wahnahnka sinaitaq arenahninká ebeq séna síwáhnorinkehe. Minayabe sibowáréhreq sene animárínseq insahwé aritankéhe. Itene Wahnah sína tanáhráq áwénunigehboq ahbabáq kega arenahniné ehweh irera sene ahbabáq suera kaweqtaq míagehe teawuwe. ");
INSERT INTO awb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Íópeqté ánínká mi ehwéh Sékáráía teawuwana Sékáráíaga wensabé, Íné ore úkugana néne ahre moq orení míéhre. Minayabe arega iraréna ehwéhmé árahue aiq pútaraginabo úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Úwana íópeqté ánínká wensabé, Néníwíq Kébárie. Íné Manikáne auranabiahtapeq iriwe mía míau aní múge. Mah kawéq éhwéh teawinkeheéna wega, Koreawo éna eqmaq núwéhre éna, ");
INSERT INTO awb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Írátíahno. Arewe néne ehweh íre aiq pútare aintahne. Minayabe mókake are ehweh íre irarerahóne. Ínéga teawú éhwéh aiq pútaragínaraq arega ehweh irarerahóne úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Máhpeq míó kega Sékáráía áwénunéra iwíáhéra, We aneqsabé íre wahto tanáhráq Manikánsabe iwíáh íwíáh atáh náhúpéq peh míehro uwe. ");
INSERT INTO awb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Uwana wega tueyokútaq we ehweh íre irarerahúwe. Ehweh íre irarerahéna wene ayahnkaratáté áwíqme teriena ehwehnurá íre irarerahúwe. Máhpeq míó kega miraú tagéra, Manikánsabe iwíáh íwíáh atáh náhúpéq míéhtáq wenawanka tagehre íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iwíáhuwana we ehweh íre irarerahéna wene arambehri tanáhráq parabagútaq wene nahtapeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mi tanáhráq parabagúwana wene ahre Érísábéti kía ména moberíáh íó wene nahtapeq peh míowe. ");
INSERT INTO awb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mitaq ména mahraréna, Íné orahini míarautaq áhnte niyehitaraire. Manikánka ínénsabe arutaboiraintena séhréh aintárái puana amahnága íné íre niyehitehre úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Érísábéti abapete morá íó kía míowana Manikánka íópeqté ání wenáwíq Kébári Kehrari marákórápéq Néhsara suwahpeq eqmarowe. ");
INSERT INTO awb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Eqmarowana wega Máhría Néhsara suwahpeqte áhráríbá tuwe. Máhríawe mó weh mahbíreq íre nogu ahrárí wíre. Tébíti kahnáh máhbí wenáwíq Sósépa míowana Máhríaga we kéranaútaq Kébáriga weba tuwe. ");
INSERT INTO awb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Weba tuena wensabé, Aiq míahno éna Maniká itene Wahnahnka arensabé anotahtaq arutaboiratena arereq míéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Úwana Máhríaga mi ehwéh iwíáhue tagéna wewe náhenéna, Aneq ehwéhpómo. Íre niahteboge éna iwíáh kikirúwe. ");
INSERT INTO awb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Iwíáh kikirúwana íópeqté ánínká wensabé, Máhríao, íre áhreúno. Manikánka arensabé anotah arútábóíratéhre. ");
INSERT INTO awb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Minayabe are kía míaniewóne. Are kía mé animai maqmíéhnaraq Sísae ue áwírato. ");
INSERT INTO awb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","We anotah aní míahnara áhnte kegá wensabé, Maniká Iteribone ahninkáwá wíre ataneherawoe. Maniká itene Wahnahnka wensabé, Tébíti arene aigaqnaga Ísara ke wahnahnúnserah arega moq se wahnahniniewóne atankéhe. ");
INSERT INTO awb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","We Sékópa kahnáh ánímárí ahriahri wahnahnaritena wene wahnahné tanáhráq íre parabaginawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Íópeqté ánínká teawuwana Máhríaga wensabé, Íné íre wehreq nogú ání púana árahue kía míaninkono úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Úwana íópeqté ánínká wensabé, Manikáne Awanka areba tuena nonahwega marakó akariuríéhnserah areba moq akariuriankehe. Manikánka págege atena kawerue auráq matiankehe. Minayabe mó kegá arega maqmíéhna anínsábé, Kaweqtaq mía míai aní míre éra we Manikáne ahninkáwá wíre ataneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Íópeqté ánínká mó mahraréna, Mó kegá arenawahrah iní wenáwíq Érísábétinsabé, Orahinine atárówana we orenínéna amahnága kía míéhre. We abapete morá íó kía ména animai maqmiankéhe. ");
INSERT INTO awb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Manikánka moke miraorahi mino úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Úwana Máhríaga wensabé, Íné Manikáne arambehriu ahráríúge. Arega aiq irarénanserah Manikánka mirainkehe úwana íópeqté ánínká we auwena pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mi tanáhráq Máhríaga Érísábéti koraganieéna apubúue sokahuena pokue Súría marákórápéq áhnte sawéh korabeq kiuwe. ");
INSERT INTO awb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kiena Sékáráíane nahupeq kibekéna Érísábéti mehweh atowe. ");
INSERT INTO awb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mehweh atowana irotaq wene arupipeq mío anínká anotah kabau kabauúwe. Kabau kabauúwana Manikáne Awanka Érísábétiba séna iwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Iwíáh atowana Érísábétiga anotahtaq mahraréna, Máhríao, Manikánka mó inínsónsábé arutaboiréna peh arerensabé anotahtaq arutaboiratéhre. Manikánka arega maqmíéhna anínsábé anotahtaq arutaboiratéhre. ");
INSERT INTO awb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Íné pehgáriq iní múge. Néne Wahnahne anowagá aneqsabé ínéba seno? ");
INSERT INTO awb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Írátíahno. Amahnága arene ehweh írótaq ínéga maqmíáhna aníné arupipeq eyoyói puana nirupipeq kabau kabauire. ");
INSERT INTO awb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Arega Manikánka eqmatai aníné ehwehnsabé aiq pútaraginawire íwíáhuronayabé Manikánka arensabé, Kaweróne atéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Máhríaga mahraréna, Néniwanka itene Wahnahnsabé iwíáh íwíáh atéhre. ");
INSERT INTO awb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Manikánka íné kaweraintéh ánínsábé iwíáh íwíáh atóge. ");
INSERT INTO awb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ínéwé pehgáriq inínéna Manikáne arambehriu iní míóganawe wega íné tagéna ínénsabe arutaboiraintéhre. Mókake ómi kehinánká ínénsabe iraréra, Manikánka ínénsabe anotahtaq arutaboiratéhre igehe. ");
INSERT INTO awb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Maniká peh anotah pagégé ánínéna íné áhnte séhréh aintáráirara sega mirarue irarigehe. Manikámé anotah kawéq áwíqkakaq aní míéhre. ");
INSERT INTO awb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Manikánka mó tanáhráq mó tanáhrárue ahriahri wensabé áhteno keyábé arutaboirarítéhre. ");
INSERT INTO awb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wewene ayahtate págege sansánue sokigi aíre. Mó kegá, Itewe anotah anímárí múne íwíáhéra píribahriowana Manikánka mi ke kaqsúéhrara kobeq séberagowe. ");
INSERT INTO awb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wega anotah wahnáh ánímárí wahnahnorabeqte kaqsuena pehrápeqte ánímárínsábé wahnahnoro arítéhre. ");
INSERT INTO awb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wega sirupibii ke kaweq naneqmarí náriena áhnte kéh ké íre náriasa pehipi kaqsúéhre. ");
INSERT INTO awb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Manikánka Ébáráhmareq wene anahwareq itene igaqnaréhreqsabé, Ahriahri nirutaboiraitanauge ire. Wega mi ehwéh ahreraq matawéna wene arambehri anímárí Ísara keyábé arutaboiraritena séhréh arítéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Máhríaga mi ehwéh iraréna apahtáró íótáq kaegaeéna Érísábétine nah suena wene nahtapeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wene maqmare tanáhráq sútaq Érísábétiga animai maqmarowe. ");
INSERT INTO awb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Manikánka wensabé anotahtaq arutaboiratéhre éhwéhnuwara wene iyahnaboreq wenawahrahreqka irera wereq moráráq iwíáh íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Iwíáh íwíáhéra mi aní abapete apahtáró wéhékáh míotaq sega wene áú amurúruaneheéra séra mahraréra, Wenabo áwíq Sékáráía wire. Mah karíq ánínsábé moq abowá áwíq Sékáráíae atanéhe uwana ");
INSERT INTO awb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","wenanoga, Ahqáho aritena, Sónie ue áwíratayehetauye úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Úwara sega wensabé, Mi awíqmé íre arenawahrah síwíq míre éra ");
INSERT INTO awb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","wenabonsabé siyahnkaratáté áwíqme kasenéra, Arenahninsábé arega inse ataníbo uwe. ");
INSERT INTO awb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Uwana Sékáráíaga ayahnkaratáté awirena, Pépahq menio úwara pépahq áwúwana wega sehiranéna, Wenáwíq Sónie ue sehiranúwara áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Áhtenuwana Sékáráíane áwéh kaweragúwana wega apubúue irarerahéna Manikánsabe pahsuqme iwíáh íwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mibeqté kégá mi otáq sánsá tagéra áhre aguwara Súría marákórápéqté kégá sáwéhrapeqté mitaq teri mahtaq terinuwara moke írówe. ");
INSERT INTO awb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mi ehwéh író kega sirupipeq iwíáhue tagéra, Mah aní mókake aneq mirainkehbo éra Manikánka we págegeue séhréh atanawire íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Manikáne Awanka mi aníné abowá Sékáráíaba sure iwíáh atowana wega kahna naneqsabé mahraréna, ");
INSERT INTO awb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Maniká itene Wahnahnka Ísara ke meirena kaweraitanieéna si puaq iwíáh íwíáh atone. ");
INSERT INTO awb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wega anotah aní ite kaweraitahna aní omaq atéhre. Mi anímé Tébíti kahnáh áníne. ");
INSERT INTO awb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Minayabe Manikánka wene ehweh iraru ke naho íwíáh aritowara teiúwe. ");
INSERT INTO awb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Itensabé iuwahrieh ke itene naruoga ite saiqnaríáhnsábé sega iubíyehoéna wega meirena kaweraitankéhe. ");
INSERT INTO awb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Manikánka omasa éhwéh aiq ahreraq matawéna itene igaqnaréhyabe arutaboiraritena séhréh aritowe. ");
INSERT INTO awb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wega itene igaqna Ébáráhma mirainauge ú ehweh teawena, ");
INSERT INTO awb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Itene naruoga saiqnaríáhtáq koweiraníe úwe. Minayabe íre áhreia peh wene arambehri miraonehqmúne. ");
INSERT INTO awb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Moke itene ogamé tanahráq Maniká awahbeh sansánéq kaweqtaq méq wene arambehri tábúsoqme miraoneheqmúne úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Manikáne Awanka mó iwíáhatowana Sékáráíaga wenahni Sóninsabé mahraréna, Nénahnino, mó kegá arensabé, Maniká itene kiotaiqme Wahnáhné ehweh iraréna aní móne ataneherawoe. Itene Wahnahne ah kawerarankéhboq arega ebeq pokinkehe. ");
INSERT INTO awb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Manikánsabe áwíahraqso ke oganúq sitankéhboq se merirena sene ahbabáqsabe kaweraritankéhe ue terinkéhe. ");
INSERT INTO awb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Manikámé áhnte arútábóíraitéh ání mía míaire. Pópoqnahga áhníbórá kiembogina inserah Manikánka ite áhníbórá kaweraitanaire. ");
INSERT INTO awb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sunkíkírirabeq pukoraho ke tagagehboq Manikánka ahtapeq téhraitankéhe. Minayabe wega iahnkahrínaq ite iru ukiq ítéh áhtápéq nogoráhúne úwe. ");
INSERT INTO awb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Manikáne Awanka iwíáh atowana Sékáráíaga mi ehwéh wenahni Sóni teawuwe. Mi aní anonurena Maniká awahbeh sansánsábé arutaboiréna sehgiuwe. Wega Ísara ke ehweh terie tanáhráq íre suriotaq peh abatapi úpeq kaegaeúwe. ");
INSERT INTO awb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mi tanáhráq anotah wahnáh ání wenáwíqtare Sísáhri Ógáhsátu moke Aroma keráq wahnahnatiowe. Wega moke wehuke síwíqmari púkuipéq sehiranoro aritowe. ");
INSERT INTO awb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mi tanáhráqmé Aroma kegá ebeq síwíq sehiranu tanáhráre. Wehukení wenáwíq Kúwíríníáhsi Síría marákórápéqté kéné wahnah míotaq sehiranue meyowe. ");
INSERT INTO awb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aroma wahnáh kégá moke síwíqmari meyaneheéra ómiga sensuwahpeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sósépawe Tébíti kahnáh ání ména Néhsara suwahpeq Kehrari marákórápéq suena Súría marákórápéq Pétáríéma suwahpeq Tébíti kahnáh suwahpeq kíuwe. ");
INSERT INTO awb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sensíwíq terieyeheéra Sósépareq wene ahre arárí Máhríareq Néhsara suwahpeq kíúye. Máhríawe anotah kia míowe. ");
INSERT INTO awb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sega Néhsara suwahpeq kíúyataq we ani maqme tanahráq wahtonúwe. ");
INSERT INTO awb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Páhsíntía nahmárí máhriq íre ko púara sega káhone nahtapeq káúye. Mitaq Máhríaga wene ebeq piah anímáí maqmarena ambanta ánáhnkiwe mi kané táhutahuq kunúbáípéq suge atowe. ");
INSERT INTO awb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mi ke suwahpeqte áhnánsáhrápéq sipisípiq wahnáh ánímárí uworapeq méra sene kamarítáq wahnahnuwe. ");
INSERT INTO awb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wahnahnuwana íópeqté ánínká ábóraragúwana Maniká itene Wahnahne téhreh naneqka anotahtaq téhrówara sega anotah ahré aguwe. ");
INSERT INTO awb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Íópeqté ánínká sensabé, Íre áhreoro. Írátíáhro. Mah kawéq éhwéh teinieéna suge. Teiú éhwéhnká ómi kehináné sirupipeq anotahtaq eyoyó aritankéhe. ");
INSERT INTO awb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tébíti kahnáh suwahpeq ite meirena kaweraitahna aní inokáhpeq maqmíéhre. Manikánka we omaq atowana we anotah Wahnáh ání ména ite meirena kaweraitahna aní míre. ");
INSERT INTO awb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aniné ambanta ánáhnkiwe káhone táhutahuq kunúbáípéq míéhre tagéq we wire ue ahtebagehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Úwara peh íregáritaq íópeqté kégá ábóraragéra Manikánsabe iwíáh íwíáh atera mahraréra, ");
INSERT INTO awb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Maniká kiotaiqme aníniraq wensabé iwíáh íwíáh atone. Mah marákó márákóípéq Maniká awahbeh sansá sehgíra ke siru ukiqsitankéhe uwe. ");
INSERT INTO awb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Íópeqté kégá se suera íópipeq tuekutaq sipisípiqtaq wahnahnu kegá seye náhenéra, Manikánka teí ánínsábé Pétáríéma suwahpeq koraganehboq pokonehe uwe. ");
INSERT INTO awb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pokonehe éra pehbeheráh pokue anebahruwana mi aní káhone táhutahuq kunúbáípéq sugowara Máhríareq Sósépareq míóya tagowe. ");
INSERT INTO awb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tagéra pokue íópeqté áníné ehweh mitaq teri mahtaq terinuwe. ");
INSERT INTO awb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Terinuwara író kegá sipisípiq wahnáhmáríné ehwehnsabé iwíáhue tagéra, Aneq ehwéhpómo íwíáhéra áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Máhríaga moke mi ehwéh ahreraq matawéna wene arupipeq iwíáh atawéna tagówe. ");
INSERT INTO awb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipisípiq wahnáh kégá kouwekéra sega író ehwéhnkákáq tago naneqsabéákáq Manikánsabe iwíáh íwíáh atówe. Iwíáh íwíáh atera, Íópeqté ánínká teínserah aiq pútaragire uwe. ");
INSERT INTO awb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Máhría íre kía míotaq íópeqté ánínká wensabé, Are ani maqmíéhnaraq Sísae ue áwírato úwe. Minayabe mi aní maqmarowara abapete apahtáró wéhékáh míotaq sega wene áú amurúruera Sísae ue áwíratówe. ");
INSERT INTO awb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mósísiga sehgíóro ú ehwehnká irarinserah sene wánítapeq mósosue tanahráq parabagútaq Sósépareq Máhríareqka Sísa Sarúsarama suwahpeq meqmera Manikánsabe, Arene ani míankehe uye. ");
INSERT INTO awb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Minayabe itene Wahnahne ehwehnka mahraréna, Itene ebeq piah anímáígáú ómi meriqme Maniká ménáwéro ire. ");
INSERT INTO awb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Itene Wahnahne ehwehnka mó mahraréna, Téhtaré kíbókíráré náwétao. Kiboki írakaunínaraq téhtaré píná áráhqtáré náwétao ire. Sega mi ehwéh sehgioyeheéra Sísa meqmera kíúye. ");
INSERT INTO awb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sarúsarama suwahpeqte kóré wenáwíq Símíónie. Wega Maniká awahbeh sansánsábé arutaboiréna kaweqtaq mía míaéna Ísara ke kawerarite tanáhráqsábé áwénunúwe. Áwénunúwana Manikáne Awanka wereq mía míaéna ");
INSERT INTO awb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ehweh teawena, Arewe pehipi íre pukiniewóne. Írakaumo. Ebeqme ite meirena kaweraitankeheéna itene Wahnahnka omaq ato aní tagé anehe pukinkehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Manikáne Awanka mi koré iwíáh atowana wega Manikánsabe iwíáh íwíáh atáh náhúpéq kibekúwara Sísane anoibo akéqká Mósísiga sehgíóro ú ehweh sehgioyeheéra Sísa meqmera mitaq kíúye. ");
INSERT INTO awb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kíúyana Símíóniga tagéna Sísa sawiwena Manikánsabe iwíáh íwíáh atena mahraréna, ");
INSERT INTO awb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Néne Wahnahno, arene arambehri aní míóge. Arega eqmarahna anímé ite meirena kawaraitahna anímé néne niuranka amahnága aiq tagoge. Minayabe arega aiq teníátóna ehwéh aiq pútaraginkehboq niru ukiq intehnana pukono. ");
INSERT INTO awb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ómi kehiná míáhrabeq arega kaweraitahna aní eqmarahne. ");
INSERT INTO awb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wega téhrehnka inserahnínaraq nahnsonka kaweq ah tagagehe. We míéhnsábé Ísara ke arenawahrahga iwíáh íwíáhigehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Símíóniga Sísa éhweh mahrarúwara Sísane anoibo akéqká mi ehwéhnsábé áhtenéra áhnte iwíáhuye. ");
INSERT INTO awb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Iwíáhuyana Símíóniga sensabé, Pehwehrue míáhtao éna wenano Máhríansabé mahraréna, Mah anínká áhnte Isárá ké séhréh aitankeheéna Manikánka we omaq atéhre. Séhréh aitahnaraq mó kegá we sinehepeq suehrara mó kegá wensabé aiq pútare atagéhe. Wega Manikáne sansá sokigi ínaraq áhnte tagehra kegá wensabé éhruru atehrana ");
INSERT INTO awb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sirupipeqté áhbábáq ábóraq aginawire. Minayabe sogiqka agaréq áwítáq anotah erinserah arene arupipeq anotah eragínah pukorahuge íwíáhiniewóne úwe. ");
INSERT INTO awb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Manikáne ehweh irarú iní wenáwíq Áhna mitaq míowe. We Pánúérine ayahunkawa ména Áséra kahnáh íní ména naho kóréní míowe. We wehkútaq abapete téhtaré ópéq wenawehqseq míowana ");
INSERT INTO awb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","wenawehq pukúwana íregáritaq opéq peh kéweiní ména we 84 opéq míowe. Wega Manikánsabe iwíáh íwíáh atáh náhúpéq íre suena peh mitaq mía míaéna Manikánsabe iwíáh íwíáh atotaq wega táhutahuq awehriéna púreq aruqarurúwe. Wega mitaq wéhékáhnkakaq inokáhpeqkakáq Manikánsabe iwíáh íwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mi tanáhráq wega Sísa tagéna Manikánsabe iwíáh íwíáh atena Sarúsarama suwahpeqte ké merirena kaweraritahna anínsábé áwénunu ke Sísa éhweh teriuwe. ");
INSERT INTO awb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wenanoibo akéqká moke Mósísine ehweh sehgiera mitaq suera sensuwahpeq Kehrari marákórápéq Néhsara suwahpeq kouwekuye. ");
INSERT INTO awb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kouwekuyana mitaq Sísa anonurena págege ahtébíá ání úkúwana Manikánka wensabé arutaboiréna séhréh ata ataúwe. ");
INSERT INTO awb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sísane anoibo akéqká mó opéq mó opérue sótaikú siahreraq ko tánáhráq Sarúsarama suwahpeq táhutahuroyeheéra poku pokuye. ");
INSERT INTO awb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sísa anotah anímáí úkútaq airápété téhtaré opéq míotaq wereq wenanoibo akéqseqka Sarúsarama suwahpeq pokuwe. Sega Asiu kené sánsá sehgioneheéra pokuwe. ");
INSERT INTO awb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Táhutahuq tanahráq parabagúwara mi akéqká mitaq suera sensuwahpeq kouwekuyana Sísaga Sarúsarama suwahpeq kowíowara wenanoibo akéqká minayabe íre íróye. Sega íre irera, We itene iyahnabo anímárínseq nogíre íwíáhéra peh morá wéhékáh nogúye. ");
INSERT INTO awb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wega seba íre súwara wensabé anebahréra sensuwahrahreq sene iyahnabo anímárínseqsabé, Sísa tagaho ue kasenuye. ");
INSERT INTO awb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Anebahruyana we íre ábóraq míonsabe sega Sarúsarama suwahpeq anebahroyeheéra kiwekuye. ");
INSERT INTO awb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sega anebahréra téhtaré wéhékáh íre ábóraqmarera apahtáróráq Manikánsabe iwíáh íwíáh atáh náhúpéq anebahréra Sísa mitaq tagoye. Tagoyana Sísaga íwáhnoru kené ehweh iranieéna sereq tútuue ména wega iwíáhú ehweh kasenúwe. ");
INSERT INTO awb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kasenúwana moke wene ehweh író kega iwíáhéra, Mah anímé áhnte ahtébíá áníne. Wega peh ahtebia éhwéh pahsúéhre íwíáhuwara ");
INSERT INTO awb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","wenanoibo akéqká mina tagéra áhtenuye. Wenanoga wensabé, Nénahnino, arenaboreq ínéreqka are áhnte anébáhréta irupipeq anotahtaq págegeúye. Aneqsabé itensabé íre iwíáhia miraono úwe. ");
INSERT INTO awb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Úwana Sísaga sensabé, Aneqsabé ninebahroyo? Nánibone nahtapeq míahrahume íre tagariehyo úwe. ");
INSERT INTO awb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Úwara sega mi ehwéh áwahewé íre ahteboye. ");
INSERT INTO awb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sísaga Néhsara suwahpeq se kérirena sene ehweh kawerue sehgiuwana wenanoga minayabe moke ahreraq matawéna iwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sísa mó anonurena anotah aní ahtebia ání míowara Manikánka wensabé arutaboirúwara wehukega wensabé iwíáh íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Anotah wahnáh ání wenáwíqtare Sísáhri Táíbéríúsa míowe. Wega 15 opéq wahnahnúwana mó wahnáh ání wenáwíqtare Póntíása Páhíráti ména Súría marákórápéq wahnahnúwe. Mi tanáhráq Érótiga Kehrari marákórápéq wahnahnúwana wenábáq wenáwíq Pírípi ména Ítúría marákóákáq Tárákóníti marákóákáq wahnahnúwe. Wahnahnúwana mó wahnáh ání wenáwíq Árísánía ména Ábíréni marákórápéq wahnahnúwe. ");
INSERT INTO awb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wahnahnúwara Ánásareq Káíyápásareqka Manikáne ehweh mibeq mahbeq arítáh kéráq wahnahnuye. Mi tanáhráq Sékáráíane ahninkáwá wenáwíq Sóni abatapi míowana Manikánka terie arámbéhrí atowe. ");
INSERT INTO awb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Terie arámbéhrí atowana Sóniga moke Sorana aroipéq wahtotaq ko marákórápéq kure ehweh teriuwe. Teriena, Manikánka itene ahbabáqsabe kaweraitankéhboq ahbabáq sansa sueq kaweqtaq míáhro. Itene ahbabáq sansa sueq kaweqtaq míéhrataqmé wání meiníe úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Minayabe Manikáne ehweh irarú ani wenáwíq Áísáíaga naho púkuipéq sehiranue mahraréna, We uworapeqté sawai sawaiéna mahraréna, Itene Wahnah sína ahmé aborisahro. Wene ah kaweraráhro. ");
INSERT INTO awb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mi ah obarirankeheéq nonsuwewarí akariaruqme anotah sawéhwárínkákáq káriq sawéhwárínkákáq apansuqme mi ah tábúsoq maráhro. Aesa áh obaríqme sabahro. Ebah masahpawe kaweroro. ");
INSERT INTO awb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Manikánka kaweraitahna arámbéhrí mah kehiná kéhínánká tagagehe ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Áhnte wehekéqká wání meyaneheéra Sóniba suwana wega sensabé, Itewe wehene animárí móe. Manikánka anotahtaq kamah ainehboq pehbeheráh pokoro insega teiro? ");
INSERT INTO awb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Itene ahbabáqmari sueq kaweq sansánoro. Mirairataq Manikánka tagéna ite amahnága mó sansánowe íwíáhinkehe. Ébáráhma itene igaqna míéh púaq itewe kaweq ke míone éq iteitensabé irariyeho. Manikánka mah ebáhmárítáté Ébáráhmane anahwaréh mirarahráhire. ");
INSERT INTO awb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wehukenínká awanká áwaheraq tehsúme maréhrana kaweq será íre íyéh áwánká moke apiwe ira pariankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sóniba su kegá wene ehweh irera wensabé, Aneronehnkono uwe. ");
INSERT INTO awb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aneronehnkono uwana wega sensabé, Téhtaré síótí matíéh ánínká íre síótiakáq ání peh morá síótí náwo. Áhnte topáh matíéh ánínká tabonah ke wehwehúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Táhkísi moné meyáh kégá wání meyaneheéra Sóniba séra wensabé, Íwáhnoraníno, ite aneronehnkono uwe. ");
INSERT INTO awb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aneronehnkono uwana sensabé, Wehukene móne pehipi meyéhboq peh morá táhkísí móné meyáhro úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sóntía kegá wensabé, Itewe aneronehnkono kasenuwana wega sensabé, Mó kené ménsámehnsá meyaneheéq wehuke subiqmareq pehipi meyého. Sensabé péhe éhwéh ariteq sene ménsámehnsá pehipi meyého. Itene arambehriyabé meyáhna apéq awehraq kéhre íwíáhoro úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Manikánka Asiu ke merirena kaweraritankeheéna peh morá ání omaq atowara Asiu kegá we áwénunuwe. Asiu kegá Sónine ehweh irera éhnehéra iwíáhéra, Sóniwe itega áwénunúna anípómo uwe. ");
INSERT INTO awb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Uwana Sóniga sensabé ayahqme teriena, Inehe si anímé anotah aní ména íné kiotaiqme aní míre. We anotah aní púana ínéga wene súu nahníáq pugereyabe íre awehrari aní múge. Wega Manikáne Awa iteba eqmarankéhe. Wehukenínká uworapeq kekiaréhrana anotah irárehnserah Manikáne Awanka iteba tuinkéhe. ");
INSERT INTO awb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wehukega ayu siqmíáhtáq sega kaweq ayú sene nahtapeq sáharera íre kaweq ayú iraipéq súáhwe. Mira onserah Manikánka eqmaréh ánínká kaweqtaq míáh kéyábé, Néne mátaburapeq kiwíáhro aritena ahbabáq keyabé, Íre puinkorahi iráípéq mía míaoro aritankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sónine ehweh író kega iwíáhigeheéna wega áhnte mó mina tahnsa éhwéh pahsuena oga mé ehweh teri terinúwe. ");
INSERT INTO awb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Érótiga wenábáqne ahre Éróríása meyowana Sóniga minaakaq wene mó ahbábáqkákáqsábé abiahnsa atena íre kaweróne atowe. ");
INSERT INTO awb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Íre kaweróne atowana Érótiga sóntía keyábé, Sóni táhtoqme karábúsiipéq móátáhro úwara táhtoqme karábúsiipéq móátówe. Minayabe Érótine ahbabáq áhnte agúwe. ");
INSERT INTO awb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sóniga áhnte ke wání meriena Sísa moq wání meyawuwana púrerútaq sabona sawekúwana ");
INSERT INTO awb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Manikáne Awanka tunse kiboki tahnsanéna Sísaba márunsurahúwe. Marunsurahúwana íópeqté éhwéhnká mahraréna, Are niruní nénáhní móne. Arensabé nirutaboiruge úwe. ");
INSERT INTO awb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sísaga wene arambehri áhwárótaq we 30 opéq marakóipeq míowe. Wehukega iwíáhéra, Sísawe Sósépane ahninkáwáe uwe. Sósépawe Érine ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ériwe Mátátine ahninkáwáe. Mátátiwe Áríwáine ahninkáwáe. Áríwáiwe Mékine ahninkáwáe. Mékiwe Sánáine ahninkáwáe. Sánáiwe mó Sosépáne ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sósépawe Mátátíásane ahninkáwáe. Mátátíásawe Émósine ahninkáwáe. Émósiwe Náhúmane ahninkáwáe. Náhúmawe Ésárine ahninkáwáe. Ésáriwe Nágáine ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nágáiwe Matane ahninkáwáe. Matawe Mátátíásane ahninkáwáe. Mátátíásawe Séménane ahninkáwáe. Séménawe Sósékane ahninkáwáe. Sósékawe Sórane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sórawe Sóánánane ahninkáwáe. Sóánánawe Árésane ahninkáwáe. Árésawe Sérúbábérane ahninkáwáe. Sérúbábérawe Séátíérane ahninkáwáe. Séátíérawe Néríne ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Néríwe Mékine ahninkáwáe. Mékiwe Éráine ahninkáwáe. Éráiwe Kósámane ahninkáwáe. Kósámawe Émárámane ahninkáwáe. Émárámawe Éane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Éawe Sósúane ahninkáwáe. Sósúawe Éríésárane ahninkáwáe. Éríésárawe Sórímane ahninkáwáe. Sórímawe Mátátine ahninkáwáe. Mátátiwe Áríwáine ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Áríwáiwe Símíónine ahninkáwáe. Símíóniwe Súrane ahninkáwáe. Súrawe Sósépane ahninkáwáe. Sósépawe Sónámune ahninkáwáe. Sónámuwe Éríákímane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Éríákímawe Méríane ahninkáwáe. Méríawe Ménane ahninkáwáe. Ménawe Mátátane ahninkáwáe. Mátátawe Nétánine ahninkáwáe. Nétániwe Tébítine ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tébítiwe Sésine ahninkáwáe. Sésiwe Óbétine ahninkáwáe. Óbétiwe Póásine ahninkáwáe. Póásiwe Sámónine ahninkáwáe. Sámóniwe Násónine ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Násóniwe Ámínárápane ahninkáwáe. Ámínárápawe Átínine ahninkáwáe. Átíniwe Áránine ahninkáwáe. Árániwe Ésárónine ahninkáwáe. Ésáróniwe Pérésane ahninkáwáe. Pérésawe Súrane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Súrawe Sékópane ahninkáwáe. Sékópawe Áhísáhkine ahninkáwáe. Áhísáhkiwe Ébáráhmane ahninkáwáe. Ébáráhmawe Térane ahninkáwáe. Térawe Náhórane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Náhórawe Sérúkane ahninkáwáe. Sérúkawe Áréune ahninkáwáe. Áréuwe Pérékane ahninkáwáe. Pérékawe Ébérane ahninkáwáe. Ébérawe Sérane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sérawe Káínane ahninkáwáe. Káínawe Ápásátine ahninkáwáe. Ápásátiwe Síémane ahninkáwáe. Síémawe Nóahne ahninkáwáe. Nóahwe Árámékane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Árámékawe Métúsárane ahninkáwáe. Métúsárawe Ínókune ahninkáwáe. Ínókuwe Sárétane ahninkáwáe. Sárétawe Máhrárárine ahninkáwáe. Máhráráriwe Káínánane ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Káínánawe Énósane ahninkáwáe. Énósawe Sétine ahninkáwáe. Sétiwe Éhrámane ahninkáwáe. Éhrámawe Manikáne ahninkáwáe. ");
INSERT INTO awb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Manikáne Awanka Sísareq mía míaúwana Sísaga Sorana aroipéq suena pokúwana Manikáne Awanka abatapi móatowe. ");
INSERT INTO awb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Móatowana abatapi ména áhnte wehekáh 40 wehekáh mitaq míowana owainawanka weba séna Sísaga ahbabárinkeheéna áhwárawe tagéna áwíoqnówe. Mi tanáhráq Sísaga táhutahuq awehriéna 40 wehekáh parabagútaq anotah arúpíbíúwe. ");
INSERT INTO awb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Anotah arúpíbíúwana owainawanka wensabé, Are Manikáne ahninkáwá míahna puah mah ebáhmárínsábé tópah úkúno ato úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Úwana Sísaga wensabé, Manikáne ehwehnka aiq mahraréna, Tópahnka wehuke íre oganúq sitahráhi nanere ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Úwana owainawanka Sísa meqmena moke mah marákó márákóípéqté wáhnáhné arambehri apubúue sokigi atena ");
INSERT INTO awb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","wensabé, Ínéwé iwíáhue omaq atáhna anínká moke tagáhna ke wahnahninkehe. Mina omaq ate arámbéhrí peh ínénéne arambehri wire. ");
INSERT INTO awb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Arega ínénsabe arehunseraráq mé iwíáh íwíáh aintehnana arega moke tagáhna ke wahnahnúno ataníe úwana ");
INSERT INTO awb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sísaga wensabé, Manikáne ehwehnka aiq mahraréna, Maniká itene Wahnahnsabé iwíáh íwíáh ateq webataq we awahbeh arámbéhrí miraoro ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Úwana owainawanka Sísa meqmena Sarúsarama suwahpeq Manikánsabe iwíáh íwíáh atáh náh nahnsorapéq móatena wensabé, Are Manikáne ahninkáwá míahna puah maraipéq ahkuagúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ahkuagúno éna wega minayabe Manikáne ehwehnka aiq mahraréna, Manikánka wene íópeqté kéyábé are wahnahnatíáhro aritankéhe. ");
INSERT INTO awb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ebahtaq arene aigárá peraq míéhneho éra sene siyahnkaratáté are pankeragéhe ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Úwana Sísaga ahqáho atena wensabé, Manikáne ehwehnka mó mahraréna, Maniká arene anotah Wahnáh áhwárawe tagé áwíoqnéhneho ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Úwana owainawanka mi tanáhráq mó íre áhwárawe tagéna peh túbáh agúwe. Sísaga anotahtaq ahqáho atonsabe owainawanka iwíáhéna, Mó tanáhráq kouwekinie éna we auwena pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Manikáne Awanka Sísa págege atowana wega Kehrari marákórápéq kouwekúwara we éhweh mitaq teri mahtaq terinuwe. ");
INSERT INTO awb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mirauwana we Asiu kené momiwí nahmárítápéq síwáhnorúwara ómiga wensabé iwíáh íwíáh atówe. ");
INSERT INTO awb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sísaga wenawahpeq Néhsara pokéna ahrena ahrena wehekáh wene sánsánéna Asiu kené momiwí nahtápéq kibekúwe. Kibekéna Manikáne ehweh sáhnsahinieéna iriwe míowe. Iriwe míowara ");
INSERT INTO awb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","mitaqté kégá Áísáíaga sehiranú pukú Sísa áwúwana mi pukúípéq kabarue mah ehwéh kotaq sáhnsahuwe. ");
INSERT INTO awb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Wega sáhnsahwe mahraréna, Manikáne Awanka ínéba ména págege aintena, Tabonah ke néne kaweq ehwéh korerio éna eqmaq núwéhre. Saiqnaríéh kéyábé sabirue ehweh korerio. Aura pira kéyábé siura ebioráho ehwéh korerio. Síwíoqnahwara sirupipeq umehi keyábé sabirue ehwéh korerio. ");
INSERT INTO awb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Manikánka kaweraritahna tanáhráqsábé korerio éna eqmaq núwéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sísaga aiq sáhnsahwe parabaruena mi pukú wahnah aní awena tútuue míowara moke mitaq míó kega we ebitíówe. ");
INSERT INTO awb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ebitíówana wega sensabé, Ínéga sáhnsáhú éhwéh íráhtáq ibora mi ehwéh aiq pútaragire úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Úwara moke míó kega wene ehwehnsabé iwíáh íwíáhéra seye náhenéra, Kaweq ehwéhne éra áhtenuwe. Áhtenéra árahue mi kawéq éhwéh irarerahiro éra mah anímé peh Sósépane ahninkáwá míéh mino uwe. ");
INSERT INTO awb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Uwana Sísaga sensabé, Iteriborehga mah pabéqmé éhwéh iraréra, Are sóteh aní míahna puah arerene awahre kawerúno ewe. Itega ínénsabe, Arega Kápénéáma marákórápéq ótaq sansá miraónaq irone íwíáhéq arega mitaq mirauronanserah mahtaq arenawahpeqkakáq moq miraúno íwíáhoo? ");
INSERT INTO awb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Teiníboq írátíáhro éna, Wenawahrahga Manikáne ehweh irari anínsábé, Are íre Manikáne ehweh iraréna aní móne ata ataowe. ");
INSERT INTO awb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aiq pútaq ehwéh teiníe. Naho Manikáne ehweh irarú ani Éráísa marakóipeq míowana apahtáró ópéq mó opéq ákáhtaq íre ibonsúnsabe moke mi marákóráq anotah ehwéhrówe. Mi tanáhráq áhnte kewéínínsó Ísara kené marakórapeq míówana ");
INSERT INTO awb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Manikánka Éráísa seba eqmaroo? Írakaumo. Manikánka we nahnso kewéíní Sárépáta suwahpeq Sáíróna marákórápéqté ínípá eqmarowe. ");
INSERT INTO awb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Manikáne ehweh irarú aní Érísa oga míotaq áhnte Ísara ke anotah naonkákáq ké míówe. Manikánka Érísa séhréh atehrana wega áhnte kaweraritoo? Írakaumo. Peh morá Síría marákórápéqté náhnsó wéh ání wenáwíq Néáma anotah naonkákáq míowana kaweratowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Úwara moke mitaq momiwíu kegá irera anotah abíáhnsá atówe. ");
INSERT INTO awb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Abiahnsa atónsabe iriwe méra Sísa táhtoqme sensuwahpeqte áhnánsáhrápéq abariwe móátówe. Mitaq mentú kowara sega Sísa mentúpipeq pagunsuaneheéra móátówana ");
INSERT INTO awb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","wega mi wehekéq ákáhpitaq kure pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sísaga pokéna Kehrari marákórápéq Kápénéáma suwahpeq tunse ahrena ahrena wehekáh Asiu kené momiwí nahtápéq síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Págegeue síwáhnorú púara sega áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Áhtenuwana owainawanka subiqmaq subiqmarú aní Asiu kené momiwí nahtápéq míowana owainawanka iwíáh atowana anotahtaq mahraréna, ");
INSERT INTO awb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Sísao, are Néhsara suwahpeqte ání móne. Arega itewe aneraitaníbo? Iubiq iuanie seno? Arewe Maniká míéhrabeq kaweqtaq mía míaóna aní móne. Arewe aiq tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Úwana Sísaga owainawansabé awehgu atena, Ehiya mé we auwe pokúno atowana owainawanka wehekeq ákáhpi mi aní aunúnkaq márunsurahúwana íre subisa pehipi auwena pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pokúwara ómi míó kega anotah ahténéra seye náhenéra, Aneq pagégé éhwéhpo? Anotah wahnáh ánínká síwáhnorinserahnéna Sísaga pokúno éhwéh págegeue teriuwara owainawamarínká mi aní auwera pokowe uwe. ");
INSERT INTO awb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sísa éhweh mitaq teri mahtaq terinuwara ómi mi marákórápéqté kégá írówe. ");
INSERT INTO awb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sísaga Asiu kené momiwí nahtápéq suena Sáímónine nahtapeq pokúwana Sáímónine ahrahnawa osoro awáhréúwara míó kega Sísansabé, Kawerato uwe. ");
INSERT INTO awb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Uwana Sísaga awahre inípá kure wene máhriqtaq iriwe ména iraró awáhréyábé, Túbáh agúno atowana kaweragúwana mi inínká apubúue irigéna táhutahuq tíwe náriuwe. ");
INSERT INTO awb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Íó tupekútaq awahre kené iyahnabo anímárínká se sehgiwera Sísaba mórítówe. Mórítówana Sísaga wene ayahnkaratáté moke awahre ke moraní moranínue táhtorowana sene awahre kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kaweragúwara owainawamarínká mó ke suanaútaq ehwehnabaéra Sísansabé, Are Manikáne ahninkáwá wóne éra mi ke suera pokuwe. Pokutaq Sísaga sensabé, Ehiya míahro aritowe. Owainawamarínká, Sísawe Manikánka wehuke kaweraritankeheéna omaq ato aní míre éra sirupipeq we tagaríónsabe Sísaga ehiyansá aritowe. ");
INSERT INTO awb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ahyahbinkerotaq Sísaga mitaq suena abatapi pokúwe. Mibeqté kégá we anebahrue kure tagéra wensabé, Pokinehboq iteba sewíahno atówe. ");
INSERT INTO awb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Atówana Sísaga sensabé, Ínéwé mó kehiná suwahpeqkakáq Manikánka wahnahnirabeqte éhwéh wene kaweq ehwéh koreriníe. Manikánka, Korerio éna eqmaq núwátáire úwe. ");
INSERT INTO awb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sísaga Súría marákórápéq Asiu kené momiwí nahmárítápéq mi ehwéh koreri terinúwe. ");
INSERT INTO awb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sísaga Kénésáréti kawéhú áhnopeq iriwe ména síwáhnorútaq su kegá Manikáne ehweh iraneheéra weba kowíórabeq áhnte ke soruparíó puana mitaq kígíúwe. ");
INSERT INTO awb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pahnsábátáhru kegá sene sípiraré áhnopeq marera arahwéraq sene kahwewarí pabeq paberuwana Sísaga mi sipíráré tagówe. ");
INSERT INTO awb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Su kegá pagu pagununsabé Sísaga Sáímónine sípiipéq kie irigue wensabé, Mahtaq sue móbeq móatiahno úwe. Úwara sípiipéqté kégá wene ehweh sehgíúwana wega mi sipíípéq tútuue ména áhnopeq míó keyabé síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Síwáhnorú ehweh parabagútaq wega Sáímónirehyabe, Pah meyagéhboq púrúrúia káwéhútápéq pokue kahwe tuparuqme uwe tagahro úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Úwana Sáímóniga Sísansabé, Anotah aní móne. Itega inokáhpeq uwe taga tagaéwonana írakaunire. Peh arega tenienayabé mó uwe taganie úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sega sene kahwewarí tuparuqme uwera áhnte pah maqmíówe. Peh íregáritaq pah maqmíówana sene kahwewarí surakinaúnsabe ");
INSERT INTO awb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","sega mó sipíípéq míó íyáhnábó ánímárínsábé siyah sahnupéra seséhréh aitáhro uwara sure mi sipíráréípéq pah márówana umehúnsabe sípiraré wánínkorahúwe. ");
INSERT INTO awb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sáímóniwe we mó awíq Pítae. Wega mina tagéna Sísane auranabiahtapeq arehunseraráq ména wensabé, Néne Wahnahno, ínéwé áhnte ahbábáq ání míó púah arega nue pokúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Se áhnte pah maqmíónsabe Pítareq wereq míó kereqka anotah ahténuwe. ");
INSERT INTO awb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pítane iyahnabo aníté sensíwíq Sémísireq Sónireqme Sébérine ahninkáwáráré míóye. Pítarehga iwíáhunserah sega moq mira íwíáhuye. Sísaga Pítansabé, Íre áhreúno. Ibora arega kahweipéq pah maqmiahnanserah mókake wehuke ínéba meriqme sinkehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Úwara sega sene sípi áhnopeq arahwéraq abariue marera moke suera Sísa kérówe. ");
INSERT INTO awb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sísaga mó ke suwahpeq míotaq anotah naonkákáq ánínká we tagéna áhtenú púana arehunserarárue wene ayahqno káuqmunurawéna Sísansabé pagu pagunéna, Anotah aní móne. Are awahbáhnaraqmé kaweraintahráhóne úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Úwana Sísaga ayahnkahkahrue wenaneq táhtorena wensabé, Aiq mirauge. Are awaho ani míahno atowana mina irarútaq wene náonaba apubúue wagúwana kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kaweragúwana Sísaga wensabé, Are kaweratónsábé mó ke teríneho. Írakaumo. Manikáne ehweh mibeq mahbeq aitéh ánípá pokue arene anonka móreawo. Are awaho ani úkire igehboq Mósísiga irarúnserahnue Manikánsabe titirúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Úwara Sísaga miraú ehweh mitaq teri mahtaq terinuwara áhnte kegá wene ehweh iraneheéra suwe. Awahre kegá, Sísaga kaweraitankéhe íwíáhéra weba suwe. Áhnte kegá weba suwana ");
INSERT INTO awb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","wega ahriahri miraúnserahnéna púrerinieéna abatapi pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sísaga síwáhnorútaq Péhrasi kereq Mósísine ehweh síwáhnoru kereqka mitaq tútuue méra írówe. Sega sensuwahpeqme Sarúsarama suwahpeqkakáq moke Kehrari marákórápéqté ké suwahpeqkakáq Súría marákórápéqté ké suwahpeqkakáq sensuwahpeq suera Sísane ehweh iraneheéra suwe. Manikánka Sísa págege atena séhréh atowana wega awahre ke kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mó kegá aiayah pukia ání wene sehitaq Sísaba móataneheéra sehgiwera suwe. Sísa míéh náhtápéq móatanehe íwíáhéra ");
INSERT INTO awb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","áhnte wehekéq nahupeq kígíunsabe sega íre kioráhuwe. Íre kioráhéra nahnsorapéq kire abogéh piruqmarera abahrabahrútaq aiayah pukia ání wene máhriqkakáq sehitaqmaqme wehuke míópi Sísane auranabiahtapeq márunátówe. ");
INSERT INTO awb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sega iwíáhéra, Sísaga kaweratanawire íwíáhuwana Sísaga sene iwíáh tagéna aiayah pukia ánínsábé, Náníbáq móne. Arene ahbabáq aiq kaweratóge úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Úwara Péhrasi kereq Mósísine ehweh síwáhnoru kereqka seye náhenéra, Mah anímé Manikánsabe íre kaweq ehwéh atéhre. Ahbabáqsabe insega kaweraritahráhiro? Manikánka webataq wehukene ahbabáq kaweraritahráhire uwe. ");
INSERT INTO awb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Uwana Sísaga sene iwíáh irena sensabé, Itene irupipeqmé aneqsabé mira íwíáho? ");
INSERT INTO awb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aiayah pukia ánínsábé aneq ehwéh teawinínkono? Arene ahbabáqsabe kaweratóge teawinínkono? Are irigue ah nogo teawinínkono? Íre págege ehwéhmé ahnabo? ");
INSERT INTO awb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Íné wehukení úku anínká mah marákó márákó wehukene ahbabáq kaweraritahráhuge. Sokigi ainíboq tagaríáhro éna aiayah pukia ánínsábé, Teawiníboq iro. Irigue arene máhriq mewe arene nahtapeq pokúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Úwana ómi ke míótaq mi anínká apubúue irigéna wene máhriq mewena Manikánsabe anotahtaq iwíáh íwíáh atena wene nahtapeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pokúwara tago kegá anotahtaq áhtenéra Manikánsabe iwíáh íwíáh atera seye náhenéra, Iboramé ótaq sansá tagóne uwe. ");
INSERT INTO awb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sísaga tuekúwana táhkísi moné meyo ani wenáwíq Áríwái tagówana wega táhkísi moné meyorabeq tútuue míowana tagéna Sísaga wensabé, Íné séniro úwana ");
INSERT INTO awb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","wega irigue moke mitaq ko naneq suena Sísa kérowe. ");
INSERT INTO awb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Áríwáiga wene nahtapeq Sísa kiraboúwara áhnte táhkísi moné meyó kereq mó kereqka Sísarehreq táhutahuruwe. ");
INSERT INTO awb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Táhutahuruwara Péhrasi kereq Mósísine ehweh síwáhnoru kereqka mina tagéra Sísa kéró keyabé kasenéra, Táhkísi moné meyáh kéreq mó ahbábáq kéreqme itewe aneqsabé moráráq naho éra abiahnsa arítówe. ");
INSERT INTO awb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sísaga sene ehweh irena sensabé, Sótehga awaho ke máráhsíni íre náriasa peh morá awahre ke náríre. ");
INSERT INTO awb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mina inserah ínéwé kaweqtaq míáh ké séhréh aritanieéna íre suge. Peh ahbabáq ke kaweraritanieéna suge úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wehukega Sísansabé, Sóni kéráh kégá mó wehekáh mó wehekáhnue kawerue púreroneheéra táhutahuq awehriowe. Awehriowara Péhrasi ke kéríráh kégá moq mira aruqarurowe. Peh are kéráh kégá íre awehriéra pehipi nahwe uwana ");
INSERT INTO awb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sísaga pabeqme ehwéh teriena, Pahuwirotaqmé o menáhwé míéhtáqmé itega wene iyahnaboyabé, Táhutahuq awehrioro terieráho? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mókake o menáhwé seba íre míahnaraqmé mi tanáhráq wene iyahnaboga táhutahuq awehrigehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sísaga mó pabeqme ehwéh mahraréna, Wehukenínká nahonáh sáhkétí kawerinieéna o sahkétí subansuqmaqme mi subánsátáté párúwe nahonáh sáhkétí kawerinabo? Írakaumo. Miraitaq tahirímé nahonáh sáhkétí mó subanki irino. ");
INSERT INTO awb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wehukenínká o nahníáq sera ano naho naho méméné áúyahwa antéhyápípéq íre ahkíre. Miraitaq tahirímé sera anonka muinaraq nahonáh ántéhyá tapoagirana sera ano marakóraq antigi irino. ");
INSERT INTO awb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wehukenínká o será ano o antéhyápípéq ahkíre. Wehukega ahkírataq mi tehtáré náneqme kawerue kanae. O será anome kawerue kanae. Antehyamé moq kawerue kanae úwe. ");
INSERT INTO awb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Naho sérá ano neh anínká iwíáhime, Naho sérá ano áhnte tei puana mi anónká o será ano kiotaikire íwíáhire úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ahrena ahrena wehekáh Sísareq we kéró kereqka páréti mirao naneq será sotápéq kótaikutaq we kéró kega mi será késabaríqme késabaríqmeue kure ayahnue ái poruwe nowe. ");
INSERT INTO awb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nowara Péhrasi kegá sensabé, Ahrena ahrena wehekáh íre mirao naneq sansá míre. Aneqsabé miraoo uwe. ");
INSERT INTO awb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Uwana Sísaga sensabé, Itewe Manikáne púkuipéqté séhírámé Tébítireq we kéró kereqka sirupibiútaq mirau sansámé íre sáhnsahwe ahtebaho? ");
INSERT INTO awb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wega Manikánsabe iwíáh íwíáh atáh náhúpéq kibekue Manikánka tagankeheéra máró parétí mewe néna we kéró ke náriuwara sega moq nowe. Mósísine ehweh irarunka mi parétíwé pehipéqté kégá íre nah nanere. Peh morá Manikáne ehweh mibeq mahbeq arítáh kégá nahrahowe ire. ");
INSERT INTO awb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sísaga sensabé, Íné wehukení úku anínká ahrena ahrena wehekáh wahnah wahnahnuge úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mó ahrena ahrena wehekáh Sísaga Asiu kené momiwí nahtápéq kibekue síwáhnorúwana mitaq sawenkahnia áyáhnkákáq ání míowe. ");
INSERT INTO awb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mósísine ehweh síwáhnoro kereq Péhrasi kereqka mitaq méra Sísa ehweh ataneheéra ahrena ahrena wehekáh wehukení kaweratanabiramo éra ebitíówe. ");
INSERT INTO awb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ebitíówana Sísaga sene sirupipeqté íwíáh aiq tagéna ómi kegá tagotaq sawenkahnia áyáhnkákáq ánínsábé, Iriwe míahno úwana we irigue míowe. ");
INSERT INTO awb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Irigue míowana Sísaga míó keyabé, Itensabé kaseninie. Mósísine ehwehnkawé ahrena ahrena wehekáhnsábé anere teiro? Kaweq sansá miraonéhnkono? Íre kaweq sansá miraonehnkono? Wehuke kaweraritaneheéq séhréh aritanéhnkono? Íre kaweratanéhnkono éna ");
INSERT INTO awb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","míó ke aurankaue tagéna sawenkahnia áyáhnkákáq ánínsábé, Arene ayahnkara obariro úwana wene ayah obarirowana kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kaweragúwara mi kegá tagéra anotah abíáhnsánéra sío síoéra, Sísawe aneronehnkono uwe. ");
INSERT INTO awb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mitaqkake Sísaga púrerinieéna sáwéhrapeq kiwéna moke mi inókáhpéq mitaq púrerúwe. ");
INSERT INTO awb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Púreréna ahbiahipeq we kéró ke síáhrabéna airápété téhraníté omaq sitowe. Sensabé eqmaro kee ue síwíraritowe. ");
INSERT INTO awb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Omaq sito ke síwíqmarimé mahraue Sáímóninsabé Pítae atowe. Pítane ábákawawé Ehntarue. Mó anímárí síwíqmarimé mahraue Sémísi, Sóni, Pírípi, Pátórómíyu, ");
INSERT INTO awb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mátíyu, Tómáhsi, Ápíásane ahninkáwá Sémísi, Sáímóni Séróti kahnáh ání, ");
INSERT INTO awb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mó Sémísine ani Súrása, mó aní téhtaré áwíqkákáq ání Súrása Ísíkáríóti miraue omaq sitowe. Súrása Ísíkáríótiwe anehe Sísane naruo koweriro aníne. ");
INSERT INTO awb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sega sáwéhrapeqté tútaq ukisatáq míówara áhnte we kéró kereq mó kereq míówe. Súría marákórápéqté kéreq Sarúsarama suwahpeqte kéreq nahmbísi marákórápéq Táíya suwahpeq Sáíróna suwahpeq mibeqté kéreq suwe. ");
INSERT INTO awb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mi kegá Sísane ehweh iraneheéra séra sene awahre kaweraitankeheéra weba suwe. Owainawanka subiqmaq subiqmarú kega moq weba suwana Sísaga kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sísane anepeqte págege arítéh náneqka wereq wahtotaq míó ke kaweraritonsabe ómiga we táhtoqnaneheéra suwe. ");
INSERT INTO awb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sísaga we kéró ke tagéna síwáhnoréna, Tabonah keo, Manikánka wahnah wahnahnirabeq awaq miahráhonsabé iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amahnága irupibii keo, mókake iyahbankiranae. Minayabe iwíáh íwíáhoro. Amahnága umehiraq ibisah keo, mókake wíréh wíréhigehe. Minayabe iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Íné wehukení úku aní séníráhnsábé mó kegá itensabé suwahrianae. Ite kaqiuwaneherawoe. Ite íéhruruoneherawoe. Ite íre kaweq anímárí móe aitaneherawoe. Íné séníráhnsábé mina tahnsa sánsámárí mirairataq iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sega mirairanka íópeq itene ápeq anotah úkinae. Minayabe sega mirairataq ábáhrue iru eyoyóéq iwíáh íwíáhoro. Sega ite íwíoqnehranserah sene sigaqnaréhga Manikáne ehweh iraru ke moq naho síwíoqnowe. ");
INSERT INTO awb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amahnága áhnte mensáméhnsá matíáh kéo, kamah ainawire. Itega iuwahbeh naneq aiq merowe. ");
INSERT INTO awb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Amahnága iyahbankiréh kéo, mókake irupi kamah ainawire. Amahnága wíréh wírého keo, mókake ibitunatúnánue ibisagehe. ");
INSERT INTO awb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ómi kegá ite kaweq ke wóe irataq iwíáhue kawerurero. Irare kené sigaqnaréhga mina unserahnéra péhe éhwéh teríú keyabé kaweq ke wóe arítówe úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sísaga mó mahraréna, Néne ehweh íráh kéo, teiníboq írátíáhro. Itene naruoyabé irutaboiroro. Itensabé suwahrieh ke kawerarítáhro. ");
INSERT INTO awb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Íéhruruo keyábé Manikánsabe teaweq, Mi ke kawerarito ue teawéro. Íwíoqnah keyábé púrerarítáhro. ");
INSERT INTO awb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mó anínká are ahsuehinahwe éberiopéq pabeq suehnana ahsuehino. Arene sáhkéti meyahnaraq síóti meyaníe ínaraq íre ahqáho ato. ");
INSERT INTO awb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mó anínká arensabé aneqpopoq nánio ínahwe náwo. Mó anínká arene ménsámehnsá meyehtaq wensabé, Néne meyahna naneq apubúue menio íre irarúno. ");
INSERT INTO awb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mó kegá ite iuwahbeh sansánue ite kaweraitáhnserah itega moq mina tahnsanue se kawerarítáhro úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sísaga mó mahraréna, Itega peh morá itensabé sirutaboiro keyábé irutaboirirataqmé inseréhga, Ite kaweq ke wóe íwíáhigehbo? Írakaumo. Ahbabáq kega moq sensabé sirutaboiro keyábé sirutaboiro mino. ");
INSERT INTO awb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Itega peh morá ite kaweraitáh ké kawerarítáh sánsánirataq inseréhga, Ite kaweq ke wóe íwíáhigehbo? Írakaumo. Ahbabáq kega moq mina tahnsa mirao mino. ");
INSERT INTO awb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Itega peh morá ite náieráho ke nárírataq inseréhga, Ite kaweq ke wóe íwíáhigehbo? Írakaumo. Ahbabáq kega iwíáhéra, Meyáh kégá mókake ite moq náigéhe éra sene ahbabáq iyahnabo nárieráho mino? ");
INSERT INTO awb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Itene naruoyabé irutaboirue kawerarítáhro. Nárírataqmé mókake náigéhe íwíáhiyehboq pehipi náríéro. Mirairataqmé Maniká Iteriboga anotah apéq inkéhe. Itega wene animárí míagehe. Maniká Iteribo anotah aní mía míaéna íre peh morá we kaweratáh kéyábé arutaboirarítéhre. Wensabé íre iwíáh íwíáhia peh ahbabáq keyabé moq arutaboirire. ");
INSERT INTO awb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Maniká Iteriboga ómi keyábé arutaboirinserah itega moq irutaboirarítáhro úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sísaga mó mahraréna, Mó kené sánsá saraq siteq ahbabáq ke woe arítého. Mirairataq Manikánka moq itene sánsá saraq itena ahbabáq ke woe aitanawire. Mó kegá ahbabáraitó íwíáh íre iahreraq mareq súáhro. Súéhrataqmé Manikánka moq itene ahbabáq íre ahreraq marena suankéhe. ");
INSERT INTO awb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nárírataq Maniká Iteriboga moq náinawire. Wega tasu tasue obenkíqme náinkéhe. Itega saraqme náríranserah wega moq mina tahnsanue náinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sísaga mah pabéqmé éhwéh mahraréna, Aura pira ánínká mó aurá pírá ání ahmboqme ah sokigi atahráhiro? Írakaumo. Miraóyataq tahirímé mi anítégá mataipéq inahnsuboya irino. ");
INSERT INTO awb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Áwáhnorirana íréh ánínká we áwáhnori aní íre kiotaikorahire. Moke ahtebawiahnaraq we áwáhnori aní tahnsa míankehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sísaga mó pabéqmé éhwéh mahraréna, Arenawahrah aníné aurapi pehgáriq atútú tagé arerene aurapi anotah sehikárá kéhnsábé aneqsabé arerene auransabé íre iwíáhono? ");
INSERT INTO awb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Arene aurapi anotah sehikárá kéhrahwe arega íre tagahne. Minayabe aneqsabé arenawahrah anínsábé, Arene aurapite átútú meauwanínkono eno? Are ahbabáq kopéráhpéróna aní móne. Téhwe arerene aurapite séhíkárá merue anehemé arenawahrah aníné aurapite átútú kawerue tagé meauwahráhóne úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sísaga mó mahraréna, Kaweq awánkánká abehq sérá íre íyéhre. Abehq áwánkánká kaweq será íre íyéhre. ");
INSERT INTO awb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wehukenínká awanká sera tagéna mi awánká ahtebehre. Wehukenínká wisuraqte pópo íre isioráhéna káránkáránsáhtaqte kombahtóq íre isioráhire. ");
INSERT INTO awb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kaweq anínká wene arupipeq kaweq iwíáh kéh púana kaweq sansánire. Ahbabáq aninká wene arupipeq ahbabáq iwiáh kéh púana ahbabáq sansanire. Wehukeníné arupipeq iwíáh obenkítíéh púana wene áwéhga mi iwíáh irarerahire úwe. ");
INSERT INTO awb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sísaga mó mahraréna, Néne ehweh íre sehgironsabé aneqsabé néne Wahnah mone aintaho? ");
INSERT INTO awb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ínéba séna néne ehweh irena sehgí ánímé aneq tahnsa anípo? Teiníe. ");
INSERT INTO awb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Néne ehweh irena sehgí ánímé nah píéh ánínká marakó íre wahto ubuqme nahwiahnsanse págege marákóráq pearéh ání tahnsane. Págege marákóráq kawerue pearéh púana anotah ibónsirana wání píéhtáq wene nah íre kúrugúruue sokogia peh págegeue kéhre. ");
INSERT INTO awb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Néne ehweh irena íre sehgí ánímé aneq tahnsá ánípo? Teiníe. Néne ehweh irena íre sehgí ánímé págege marákó íre ubuqme pehipi wene nah pearéh ání tahnsane. Anotah ibónsirana wání píéhtáq mi nah kúrugúruue sokogire. Sokogirana moke íre kaweragire úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sísaga mah ehwéh síwáhnoréna mitaq suena Kápénéáma suwahpeq mátabuipeq kéagúwe. ");
INSERT INTO awb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mitaq 100 Aroma sontíá kéné kíápéténiga ména wene arambehri aní anotah arútábóíratowana mi aní anotah awáhrééna pukinaúwe. ");
INSERT INTO awb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sísa iteruwahpeq míéhre u irena kíápéténiga Asiu kené aboawah wehyábé, Néne arambehri aní segawerato koreawéro ue eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Eqmaq suowara Sísaba séra, Máho ue pagu pagunéra Sísansabé, Kíápéténiwe áhnte kawéq ání púah awahre aní segawerato. ");
INSERT INTO awb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kíápéténiga ite Asiu keyábé áhnte arútábóíraitena itene momiwí nah pearena eqitáráire éra pagu pagunuwe. ");
INSERT INTO awb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pagu pagunuwana Sísaga se kéríqme mi aníné nah wahtotaq kútaq kíápéténiga mó eqmaro kereq piehgíúwe. Sega Sísansabé, Anotah aníno, kíápéténiga teí éhwéhmé iro. Wega arensabé mahraréna, Íné pehgáriq aní míó púah néne nahupeq íre súno. ");
INSERT INTO awb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Are anotah aní míahna puana areba íre koragoge. Arega peh ehweh irarinana néne arambehri aní kaweragíno. ");
INSERT INTO awb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Íné moq wahnah sansá tagaríóge. Néne wahnah aiq míéhrana íné moq wahnah aní ména sóntía ke wahnahnuge. Ínéga mó sontíá ánínsábé, Pokúno atótáq wega apubúue pokire. Mó sontíá ánínsábé, Mahbeq súno atótáq wega apubúue ínéba sire. Néne arambehri anínsábé, Miraúno atótáq wega apubúue miraire. Kíápéténiga aiq irarire uwana ");
INSERT INTO awb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sísaga mi ehwéh irena áhtenéna pabeqme weba míó keyabé, Teiníboq írátíáhro. Mi anínká ínénsabe anotahtaq aiq pútare aintéhre. Nánuwahrah Asíú kéga mina tahnsanue íre aiq pútare aintáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Úwara eqmaq suo kega kíápéténine nahtapeq kouwekue sutaq mi awáhré ání kaweragúwana awaho ani míowara kéragowe. ");
INSERT INTO awb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mó tanáhráq Sísareq we kéró kereq áhnte mó kereqka Náíni suwahpeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kuriraq wahtotaq sutaq mibeqté kégá pusa ání mómaisaneheéra sehgiwera suwe. Pukú aníné anowagáwé peh morá mi aní maqmarena kéweiní míowara áhnte wenawahrahreq suwe. ");
INSERT INTO awb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sísaga pukú aníné anowa tagéna wensabé arutaboiratena mahraréna, Íre ibisáhno éna ");
INSERT INTO awb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","sehiq koráhtorowara sehgiwe su kegá mitaq iriwe míówe. Sísaga pusa ánínsábé mahraréna, Káriq mahbío, irigúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Irigúno úwana pusa ánínká iriwe tútuue ména ehwehnúwe. Ehwehnúwana Sísaga mi aní anowabá atowara ");
INSERT INTO awb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","tago kegá áhtenéra Manikánsabe iwíáh íwíáh atówe. Iwíáh íwíáhatera mahraréra, Manikáne ehweh irari anínká iteba sire. Manikánka wene animárí séhréh aitanieéna aiq sire uwe. ");
INSERT INTO awb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Súría marákórápéqté kéreq móberiopéqté kéreq Sísaga miraú ehweh mitaq teri mahtaq terinuwara írówe. ");
INSERT INTO awb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sóni kéró kega moke mi ehwéh teawúwana Sóniga téhraníté omaq sitena ");
INSERT INTO awb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Sísansabé ehweh kasenigeheéna eqmaq suowe. Eqmaq suanaútaq mi anítéyábé, Sísansabé kogasenéta, Arewe Manikánka eqmaraníe ú anípo? Ite mó anínsábé áwénunonehnkono kogasenotao úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Úwara sega Sísaba kéra wensabé, Wání meri merini aní Sóniga eqmaq íúwéhrata súye. Wega ite eqmaq iuwanauraitaq mahraréna, Arewe Manikánka eqmaraníe ú anípo? Ite mó anínsábé áwénunonehnkono uraire uye. ");
INSERT INTO awb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mi tanáhráq Sísaga áhnte awáhré kéreq owainawanka subiqmaq subiqmarú kereq aura pira kéreq kaweraritena ");
INSERT INTO awb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sóniga eqmaq suo anítéyábé, Irehya ehwéhnkákáq tagéhya naneqkakáq Sóni koreawétao. Ínéga miraunka aura pira kégá tagahwara aigárá soriqnah kega ah nogowara náonkakáq kéné náo wagirara ahre parosa kégá ehweh íráhwe. Pusa ké iriwe oganúq sitena Manikáne kaweq ehwéh tabonah ke síwáhnoruge. ");
INSERT INTO awb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ínénsabe árahinabomo íwíáh íre iwíáhia peh ínénsabe kawerue aiq pútare aintéh ánímé aru ukiqme aní míéhre. Mah ehwéh Sóni koreawétao úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sóniga eqmaq suo aníté pokuyataq Sísaga weba sáhuríó ke Sóni éhweh teriuwe. Wega mahraréna, Sóniga uworapeq íwáhnoruraitaq koraganeheraurotaqmé we inse wíre íwíáhéq koragaroo? Sóiririrana onega míu míu inserah Sóni mó iwíáh mó iwíáhi aní míre íwíáhéq koragaroo? Sóniwe íre mina tahnsa ání mire. Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","We inse wíre íwíáhéq koragaroo? Kaweq korósí aneraneria ání koragaroo? Írakaumo. We íre mina tahnsa ání míarairara ménsámehnsá áhnte kéh ké siwahriria kéwé uworapeq íre mía peh wahnah kené nahtapeq mía míaowe. ");
INSERT INTO awb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","We inse wíre íwíáhéq koragaroo? We Manikáne ehweh irari aníne íwíáhuroo? Aiq pútaq iwíáhowe. Írátíáhro. We Manikáne ehweh irari anínéna moke mó áwáhu ke kiotaikuraire. ");
INSERT INTO awb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sóni éhwehme Manikáne ehwehnka aiq mahraréna, Néne ehweh korerina anímé ebeq eqmarahnana are sina ah kawerarankehe ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sísaga mó mahraréna, Teiníboq írátíáhro. Sóniwe anotah anínirara moke mó kegá we íre kiotaikowe. Íre kiotaikowana Manikánka wahnah wahnahnirabeq íópipeq kibeki aní pehgáriq anínká Sóni kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Úwara táhkísi moné mewe meweu kereq áhnte mó kereqka mi ehwéh irera iwíáhéra, Manikáne sansá aiq kaweq sansáne uwe. Sóniga se wání merinie únsabe mira íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Péhrasi kereq Mósísine ehweh síwáhnoro kereqka Sónine wání íre meyónsabe Manikáne kaweq sansánsábé iuwahriehre íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sísaga mó mahraréna, Amahnága oga míáh kéwé ite aneq tahnsá kée teinínkono? ");
INSERT INTO awb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Itewe káriq anímárínká máhkétirapéq ogi ogionserah tahnsá ké wóe. Mó anímárínká mó anímárínsábé abiahnsa aritera sensabé, Igonkónúnaraq itega íre ábáhrowe. Ibitunátúnánúnaraq itega íre ibisahwe ewe. ");
INSERT INTO awb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wání meri merini aní Sóniga suraitaq wega táhutahuq awehriéna náhníáq sera ano íre narainsabé itega abiahnsa ateq, Owainawanka wene arupipeq míéh ání míre atárówe. ");
INSERT INTO awb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Íné wehukení úku anínká surautaq táhutahuqkakáq náhníáq sera anonkakaq pehipi nogaq itega ínénsabe abiahnsa ainteq mahraréq, Tagaríáhro. We uwoyansa kobuq kahburi aní áhnte nahníáq sera anonkakaq pehipi neh aní míre. We táhkísi moné aebó kéreq mó ahbábáq kéreqne iyahnabo aní míre aintáhwe. ");
INSERT INTO awb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Itega ínénsabe mi ehwéh irarewara Maniká tagaríáh kégá ahtebé sansánirataq mó kegá tagéra, Se aiq pútaq sansánowe ewe úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Peh morá Péhrásí ánínká Sísansabé, Ínéreq táhutahuroyehboq máho úwana Sísaga kérena wene nahtapeq ména táhutahurúwe. ");
INSERT INTO awb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mi ke suwahpeqte íní we ahbabáq ini míowe. Mi inínká Sísa mitaq míéhre u irena áhnte kawéq kúnkúni werí motóreipéq mewe súwana ");
INSERT INTO awb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sísa míowana mi inínká wene anehepeq sure wene aigárátáq tútuue ména we áhnte ibisó púana wene aqnu Sísane aigárátáq tabagu tabaguúwe. Miraúnsabe mi inínká wene íre wahto áyáhrátáté Sísane aigárátáq sorahruena wene aigárátáq nánkóqnéna wéri abaq atowe. ");
INSERT INTO awb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Abaq atowana Sísansabé máho ú Pehrásí ánínká miraú tagéna wene arupipeq iwíáhéna, Mi inímé ahbabáq ini puana Sísa Manikáne ehweh irari aní míéhtáq tahirímé we táhtoréh íní peh ahbabáq ini míre íwíáh irino úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sísaga wene iwíáh irena wensabé, Sáímónio, pehgáriq ehwéh teawiníboq írátíahno úwana, Íwáhnoraníno, tenio úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Úwana Sísaga mahraréna, Peh morá ánínká téhraníté móne síátáire. Mó aní 100 Kína mó aní peh 10 Kína ue átáríageheéna síátáire. ");
INSERT INTO awb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Anehe mi anínká sensabé, Ínéga íátáu moné náníétao urairara mi anítégá móne tabonahuroya puara íre aweráhuroye. Íre aweráhuroyansabé móne síátái anínká sensabé, Ínéga íátáu monéwé mó náníyehboq anetaníbo. Túbáhagotao teríátáire. Minayabe aneq iwíáhono? Móne síátái anínsábé ah anínká anotahtaq arutaboirire íwíáhono úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Úwana Sáímóniga Sísansabé, Áhnte moné merai anínká áwátái anínsábé anotahtaq arutaboirire. Áwátái anínká wéhuwa nániewé anetaníbo atárái puana anotahtaq arutaboirire úwe. Úwana Sísaga, Arega aiq iraréne éna ");
INSERT INTO awb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","pabeqme mi iní tagéna Sáímóninsabé, Arewe mi iní aiq tagahno? Arene nahtapeq sutaq nigárá pabeq paberé waní íre nániene. Mi inínká wene aqnuraté nigárá pabeq paberaintena wene ayahrataté sobaruqnúéhre. ");
INSERT INTO awb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Arega íné íre nánkóqnáhne. Mi inínká áhntetaq nigárá nánkóq nánkórire. ");
INSERT INTO awb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Arega niyahqnopeq wéri íre abaq intahne. Mi inínká nigárátáq kaweq kunkúni werí abaq intéhre. ");
INSERT INTO awb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Minayabe teawiníboq írátíahno. Mi inínká ínénsabe áhnte arútábóíraintéh púana wene áhnte ahbábáq kaweratóge. Peh táhmaro ahbábárirana Manikánka kawerato anínká wensabé pehgáritaq arutaboiratéhre éna ");
INSERT INTO awb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","mi inínsábé, Arene ahbabáq aiq kaweratóge úwe. ");
INSERT INTO awb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Úwara mó táhutahuru kegá seye náhenéra, Arene ahbabáq aiq kaweratóge irari anímé árahue mirainkehbo uwana ");
INSERT INTO awb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sísaga mi inínsábé arega ínénsabe aiq pútare aintahnaga arene ahbabáqmari aiq kaweratóge. Pehwehrue pokéwahno úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mó tanáhráq Sísaga anotah matábúrápéqkákáq mó kehiná mó kehiná suwahpeqkakáq ah nogena Manikánka wahnah wahnahnirabeqte éhwéh mi kawéq éhwéh síwáhnorúwe. Airápété téhraníté we kéró ke kérówara ");
INSERT INTO awb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kawerarito inínsónseqka moq kérówe. Menah se awahreuwara owainawamarínká se síwíoqnówana Sísaga sene awahre kaweraritena owainawamarí kaqsuowe. Mi inínsó síwíqmarimé mó iní wenáwíq Máhríae. Wene iyahnaboga wensabé Mágára iníne ue áwíratówe. Menah Sísaga mi iníné arupipeqté airápété téhtaré ówáínáwá kaqauwowe. ");
INSERT INTO awb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mó iní Kúsane ahre wenáwíq Sóánae. Wenawehqka Érótine arambehri keraq wahnahnú aníne. Mó iní wenáwíq Súsánae. Sereq áhnte mó inínsónseqka Sísareq we kéró kereq séhréh aritera kirabo arítówe. Sísaga ehweh síwáhnorinieéna ah noguwara mi inínsónká séhréh aritaneheéra kérówe. ");
INSERT INTO awb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mó tahunírápéqté ké mó tahunírápéqté kéue íregáritaq kegá séra Sísaba sáhuríówe. Áhnte kegá momiwíuríótaq Sísaga mah pabéqmé éhwéh mahraréna, ");
INSERT INTO awb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ayu suitabeh anínká ayu suitabanieéna pokire. Suitabehtaq mó ayú ahtapeq megirana wehekeqká abasaráhwana kabaranka sésiq nehre. ");
INSERT INTO awb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mó ayú kiruraq megirana kiapoue kirena mi marákó íre tantani puana ehyatagire. ");
INSERT INTO awb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mó ayú náwerarúítáq megirana náwe kirena kárígariirana íre kawerue kirena sera íre íyéhre. ");
INSERT INTO awb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mó ayú kaweq marákóráq megirana kiapoue kirena áhnte será iratanire úwe. Sísaga mah pabéqmé éhwéh teriena anehe mi keyábé, Íre parosa áhréákáq kéo, kawerue íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sísa kéró kega wensabé, Mah pabéqmé éhwéhmé áwahe teio uwe. ");
INSERT INTO awb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Uwana Sísaga sensabé, Manikánka wahnah wahnahnirabeqte éhwéhmé áwahe ite sokigi aiena mó peh pabeqme ehwéh teri terinuge. Minayabe ínéga pabeqme ehwéh irarutaq mó kegá siuranka tagéra peh morá sirupipeq íre tagariahrahowe. Sene siahrega irera peh morá sirupipeq íre írátíahrahowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Sísaga mó mahraréna, Mah pabéqmé éhwéh áwahe ahtebagehboq teiníe. Ayume Manikáne kaweq ehwéhne. ");
INSERT INTO awb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ahtapeq megi ayúmé wehukega Manikáne ehweh íráhwana owainawanka sirupipeqté mi kawéq éhwéh seaebóire. Sega mi ehwéhnsábé aiq pútare atehrana kawerarítéhneho éna aebóire. ");
INSERT INTO awb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kiruraq megi ayú kiapoinserah wehukega Manikáne ehweh irera sirupipeq eyoyóéra apubúue kowe atáhwe. Manikáne ehwehnka sirupipeq íre ánú píéhnsábé pehgáriq tanáhráq sehgíówe. Áhwárawe tageh tanáhráq sega túbáh agéra Maniká áúwáhwe. ");
INSERT INTO awb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Náwe tarúítáq megi ayúmé wehukega Manikáne ehweh irera, Sehgionehe íwíáhéra mó tanáhráqmé sene arambehriyabé iwíáh kikiréra ménsámehnsánsabe sirutaboiréra seyega sirutaboiro naneqmarínsábé iwíáh íwíáhowe. Náwe soaginserah minawarinká saiqnaríéh púana sega Manikáne arambehri íre miraorahowe. ");
INSERT INTO awb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kaweq marákóráq megi ayúmé wehukega Manikáne ehweh irera sirupipeq ambubu atawéra tábúsoqme iwíáhowe. Kaweq marákóráq kaweq será íyéhnserah sega Manikáne arambehri kawerue miraowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sísaga mó pabeqme ehwéh síwáhnoréna, Wehukega áráhmu keqmaráhtáq párétahraté íre akariaráhwe. Máhriq tahbé tehnopeq íre máráhwe. Írakaumo. Nahupeq kira kegá kawerue tagageheéra tahberapeq máráhwe. ");
INSERT INTO awb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Moke kopípéq kéh náneqme mókake ábóraq kanae. Kopípéq mirao sansá mókake téhráhnarabeq ábóraragínara tagagehe. ");
INSERT INTO awb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Matíéh ání Manikánka mó náwinkéhe. Íre matíéh ánímé Manikánka wene pehgáriq naneq meyankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sísane anowareq ábákawaréhreqka weba séra nah kígíunsabe íre kioráhuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Minayabe mó anínká Sísansabé, Arenanoreq arenábáqmarinseq máhpeq méra are tagéyabe suwahbehre úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Úwana Sísaga mitaq míó keyabé, Manikáne ehweh irera sehgíó kéwé náinoreq náníbáqmarinseq móe úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mó wehekáh Sísaga we kéró keyabé, Seberaebéq pokonehe úwara sípi kéwewera pokuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sísa sípiipéq sugowana anotah soirírúwe. Anotah soirírúwana nonaburóróúwana wánínka sípiipéq kiegambeh agu aguúwana sípi wánípipeq tupekinaúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Minayabe we kéró kega Sísa iriatera wensabé, Itene Wahnahno, ite pukoneheúne uwana Sísaga irigéna sóiriqsabé, Táqnáigúno éna wánínsabe, Túbáh agúno úwana sóiriqka táqnáigúwana wánínka túbáh agúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Túbáh agúwana Sísaga we kéró keyabé, Aneqsabé íre aiq pútare aintaho úwara sega áhtenue áhreéra seye náhenéra, Mah aní insebo? Wega sóiriqkakáq wánínkakaqsábé ehweh atéhrana wene ehweh íréhre uwe. ");
INSERT INTO awb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sísarehga sípi kéwewera kure Kehrari kawéhú seberaebéq Kérása kené marakórápéq kuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sísaga áhnopeq kútaq mibeqté ání owainawanka subiqmaq subiqmarú anínseq piehgíúye. Íre wahto tanáhráq pehrákora mía míaéna nahtapeq íre kaena peh wehuke maisia ónápípéq kaegaeúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mi anínká Sísa tagotaq kareéna arehunseraráq ména ehwehnabaéna, Sísao, are íópeqté Manikáne ahninkáwá wóne. Aneraintaníbo éna kamah aníneho úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Úwana Sísaga owainawansabé, Auwe pokúno atonsabe wega aneraintaníbo úwe. Ahriahri owainawanka mi aní subiqmaq subiqmarúnsabe uwoyansa aní úkúwara wehukega táhtoqme séniraté wene ayahnkaratáq aigárátáq táhru táhruarówe. Táhru táhruarówana sení suraqsuq suraqsurúwana owainawanka mi aní abatapi kaqsuq kaqsurúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Anehe Sísaga wensabé, Arenáwíq insebo úwana néníwíqmé Íregáritare úwe. Áhnte owáínáwámárínká wene arupipeq míónsabe mi ehwéh irarúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Owainawamarínká Sísansabé, Íre ambarúnkákáq mátáípéq eqmaq iuwehneho éra pagu pagunuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Íregáritaq poeráhqmárínká wahtotaq sáwéhrapeq náwe sahtaqme nowara owainawamarínká Sísansabé, Póéráhqmariné sirupipeq eqmaq iuwo éra pagu pagunuwana kowe aritowe. ");
INSERT INTO awb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kowe aritowara owainawamarínká mi aní auwera póéráhqmariné sirupipeq kowíówara moke mi kamárí sáwéhrapeqté pehbeheráh tunse mentúpipeq wánínkue pukuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Póéráhqtaq wahnahnu kegá tagéra pehbeheráh pokue sotápéq míó kereq sene nahtapeq míó kereq koreríúwara ");
INSERT INTO awb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","seraganeheéra suwe. Sísaba suwana owainawamarí kaqauwo anínká kaweq iwíáhorahéna aneranerue Sísane aigárátáq tútuue míowara su kegá tagéra áhreuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Áhreuwara tago kegá kawerato ehweh su ke teríúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Teríúwara moke Kérása marákórápéqté kégá Sísaga miraúnsabe áhreu puara wensabé itene marakórapeq sue pokúno atówe. Atówana Sísaga sípiipéq kiasague pokinaútaq ");
INSERT INTO awb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","owainawamarí kaqauwo anínká wensabé, Are kéraníe úwana Sísaga ahqáho atowe. ");
INSERT INTO awb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ahqáho atena wensabé, Arenawahpeq pokue Manikánka kaweratéh éhwéh moke korerio úwana wega pokue moke wenawahpeqte ké Sísaga kawerato ehwéh koreriuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sísaga mó seberaebéq seuwekúwara mitaq míó kega we áwénunu puara wega súnsabe iwíáh íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Asiu kené momiwí nahtápéqté wáhnáh ání Sáírúsaga Sísaba séna Sísane aigárápí káuqmunue arehunseraráq ména wensabé, Nániyahu pukinainsabé néne nahtapeq segawerato éna pagu pagunúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mi ahráríwé wene peh morá ánínéna anotah ahrárí airápété téhtaré ópéq ména pukinaúwe. Pukinaúwana Sísaga abowá kérowara áhnte mó kegá kígíue moráráq ahtapeq kuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ahtapeq kuwana awahre iní airápété téhtaré ópéq wene korahq íre taraqnágia peh tuerueúwe. Sóteh kegá íre kawerarahráhu puana mi awáhré peh kowe. ");
INSERT INTO awb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wega Sísa anehepeq sure wene korósi ayehrápéq koráhtorotaq wene korahq apubúue taraqnágúwe. ");
INSERT INTO awb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sísaga, Néne korósi insega táhtorehro úwara ómi míó kega, Írakaumo uwana Pítaga wensabé, Néne Wahnahno, áhnte kegá are pagume se mino úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Úwana Sísaga, Íné tagaríómé mó anínká íné táhtoréhre. Néne págege mó anípá pokirana tagoge úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Úwana kawerato inínká, We aiq tagaríéhre éna weba sure iransánéna káuqmunurawéna Sísaga apubúue kawerato ehwéh irarúwara ómi kegá írówe. ");
INSERT INTO awb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Írówana Sísaga wensabé, Arega aiq pútare aintahnaga kaweratóge. Pehwehrue pokéwahno úwe. ");
INSERT INTO awb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pehwehrue pokéwahno teawutaq wahnah aníné nahtapeqté ánínká sure abowánsábé, Areniyahu aiq pukinsabé síwáhnori aní mó íre pagu pagunúno teawuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Teawuwana Sísaga sene ehweh irena wahnah ánínsábé, Íre áhreúno. Peh aiq pútare aintehnana we kaweraginawire éna ");
INSERT INTO awb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","wahnah aníné nahtapeq kútaq ómi mó keyábé, Máhpeq míáhro aritowe. Peh morá Pítareq Sónireq Sémísireq ahrarine anoiboreq meriqmena nahupeq kibekuwe. ");
INSERT INTO awb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Áhnte kegá mi ahráríyábé ibiséra ibitunátúnánuwana Sísaga sensabé, Íre ibisahro. We íre airaiq pukia peh súgéhre úwara, ");
INSERT INTO awb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","we airaiq pukire íwíáhu puara Sísansabé awiréh atówe. ");
INSERT INTO awb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Awiréh atówana Sísaga wene ayahnkara táhtotawéna wensabé, Ahrario, irigúno atowana ");
INSERT INTO awb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","oga úkéna apubúue iriwe míowe. Apubúue iriwe míowana Sísaga wenanoibonsabé, Táhutahuq náwétao aritowara ");
INSERT INTO awb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","sega áhtenuyana Sísaga sensabé págegeue teriena, Mahnayabe mó ke teríyeho úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sísaga we kéró ke airápété téhranítéyábé síáhrabéna sega owainawamarí kaqsuera awahre ke kaweraritageheéna págege aritena mi arámbéhrí miraoro aritowe. ");
INSERT INTO awb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Miraoro aritena sensabé, Manikánka wahnah wahnahnirabeqte éhwéh síwáhnoréq awahre ke kawerarítáhro aritowe. ");
INSERT INTO awb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wega mó mahraréna, Ah nogoneheéq mewe nógó náneq íre meyáhro. Pegiqnáh karamé unahmé táhutahuqme mónewe mó siotíwé íre meyáhro. ");
INSERT INTO awb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Itega Manikáne ehweh síwáhnoroneheéq mó ke suwahpeq kirataq peh morá áníné nahupeq kaegaeéq arambehri parabaruéhrataqmé mitaq sueq mó ke suwahpeq pokigehe. ");
INSERT INTO awb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mó kehiná suwahpeqte kégá íre mehweh aitéhrataq sega íre kaweq sansá miraonsabé ahtebageheéq sega tagehrataq igárátáq kahna tanáhúq poruarúáhro úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Úwara we kéró kega pokue mó kehiná suwahpeq mó kehiná suwahperue síwáhnoroneheéra poké aguwe. Sega moke mi kehíná kéhíná suwahpeq Manikáne kaweq ehwéh teri terinéra awahre ke kawerarítówe. ");
INSERT INTO awb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Anotah wahnáh ání Érótiga Sísa éhweh irena áhnte iwíáhúwe. Áhnte iwíáhúwara mó kegá Sísansabé, We wání meri merini aní Sónie. Sóni pukéna oga úkéna amahnága míéhre uwara ");
INSERT INTO awb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","mó kegá, We Éráísae. Éráísa amahnága ábóraragire uwara mó kegá, We Manikáne ehweh irarú anine. We naho pukú aní iriwe oganúkuraire uwe. ");
INSERT INTO awb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Uwana Érótiga sene ehweh irena wega mahraréna, Sóni ínéga ayahqno kiraq áwátáu aní aiq pukuraire. Minayabe amahnága sega mó arámbéhri mó arámbéhríue miraire e anímé insebo úwe. Insebo éna Sísa taganie íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sísa kéró kega weba kouwekéra moke mirau arámbéhrí teawúwe. Teawúwana Sísaga Pétásáíra suwahpeq sebataq míaneheéna se meriqmena pokúwe. ");
INSERT INTO awb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Áhnte mó kegá, Sísa Pétásáíra suwahpeq pokire uwara irera we anehe kaqmera pokuwe. Pokéra weba suwana Sísaga se mehweh aritena Manikánka wahnah wahnahnirabeqte éhwéh teriena awahre ke kaweraritowe. ");
INSERT INTO awb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Íó tupekinaútaq Sísa kéró kega weba séra wensabé, Mahtaq abatapi púah mah ke kaweqtapéq kogaera táhutahuq meyageheé wahtotaq kehiná suwahpeq eqmaq suo uwe. ");
INSERT INTO awb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Uwana Sísaga sensabé, Itewe mi ke kirabooro úwe. Kirabooro úwara wensabé, Ite peh moberíáh párétíákáq téhtaré páhnkákáq mationa puaq moke mah kegá nehransabé táhutahuq kobaiqmaranéhnkono uwe. ");
INSERT INTO awb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Áhnte 5 táhúséni (5,000) weh míónsabe sega mi ehwéh iraruwe. Sísaga we kéró keyabé, Saime mó ke mópi tútuue míehrara mó ke mópi tútuue míáhro arítáhro úwara ");
INSERT INTO awb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","sega mirauwara moke míó kega tútuue míówe. ");
INSERT INTO awb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sísaga mi mobéríáh párétíákáq téhtaré páhnkákáq mewena íópeq tagéna Manikánsabe, Kaweróne atena mi tahutáhúq keqme we kéró kega kiraboigeheéna náriuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Náríúwara ómiga nowana siyahbankirowe. Siyahbankirowara arahqmé airápété téhtaré páhsíkéti úsawe obenkíq márówe. ");
INSERT INTO awb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mó tanáhráq Sísaga webataq púrerúwara we kéró kega weba suwana wega sensabé kasenéna, Mó kegá ínénsabe inse aintaho úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Úwara, Arensabé mó kegá, Sóni wání meri merini aní míre ewe. Mó kegá arensabé, Éráísa wire ewe. Mó kegá arensabé, Manikáne ehweh naho iraré oga úkurona aní móne ewe uwe. ");
INSERT INTO awb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Uwana Sísaga sensabé, Itega ínénsabe inse aintaho úwana Pítaga wensabé, Arewe Manikánka ite meirena kaweraitankeheéna omaq ato aní móne úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sísaga we kéró keyabé, Ínéwé Manikánka omaq ato aní míre mó ke teríyeho úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Teríyeho éna mó mahraréna, Íné wehukení úku aní níwíoqnaneherawoe. Asiu kené aboawah wehreq Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka ínénsabe, Iuwahriehre éra nubiq suaneherawoe. Nubiq suehrana íné pukéna apahtáró wéhékáhtáq iriwe oga úkinauge úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sísaga mó ite we kérahwána keyábé mahraréna, Íné sénireyabe awahbeh aníno, arerene awahbeh iwíáh suo. Manikáne arambehri mira aruqarurunsabé sega íné awankátaq táhparagéhe. Ínéga miraunserah miraue séniro. ");
INSERT INTO awb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wewensabé arutaboiréna peh wewene awahbeh iwíáh mira aruqaruri anímé oga mérapeq íre awaq miahráhire. Néne sánsá sehginieéna wewe awahbeh iwíáh susuri anímé oga mérapeq awaq miankéhe. ");
INSERT INTO awb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wehukenínká moke mah marákóípéqté ménsáméhnsá matíéhtáq tahirímé oga mérapeq íre awaq miahnaraqmé mi mensáméhnsánká árahue séhréh atéh iripo? ");
INSERT INTO awb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ínénsabeakáq néne ehwehnsabéákáq ayehiteh aní íné wehukení úku anínká túónagake wensabé moq niyehitanawire. Íópeqté kéreq Nániboreq ínéreqne patahga tahnsa téhreh naneqkakáq túónagake mi anínsábé niyehitanawire. ");
INSERT INTO awb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Teiníboq írátíáhro. Táhmaro ite iriwe míona ke pehipi íre pukigehe. Ebeqme Manikánka wahnah wahnahní tagéq anehe pukigehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sísaga síwáhnorúwana abapete morá wéhékáh parabagúwana wega sáwéhrapeq púrerinieéna Pítareh Sónireh Sémísireh meriqmena kiuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wega púrerútaq wene auranabiah mó kugú, kaweq kugú agúwana wene korósi téhreh naneq tahnsánue anotah tabérábé agúwe. ");
INSERT INTO awb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Anotah tabérábé agúwara Mósísireq Éráísareqka íópeqté tunse ábóraragéra Sísareq ehwehnuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mi anítégá Manikáne téhreh naneqtaté awahrirue méra Sísa Sarúsarama suwahpeq pukinaú ehwéh iraruye. ");
INSERT INTO awb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Iraruyara Pítarehga surahpeq méra irigéra Sísane patahga tahnsani naneq tagéra Sísareq míóya aníté tagowe. ");
INSERT INTO awb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mi anítégá Sísa auwera pokoyeherauyataq Pítaga Sísansabé, Íwáhnoraníno, ite mahtaq míonayabé aiq kawerire. Apahtáró úqná pearanéhe. Arene morá Mósísine morá Éráísane moráue pearanéhe úwe. Pítaga mi ehwéhnsábé íre iwíáhia pehipi irarúwe. ");
INSERT INTO awb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Irarútaq írábúyánka seúbítáwéna Sísa kéró anító akariuriowara sega áhreuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Áhreuwana írábúyápipeqté éhwéhnká mahraréna, Mah anímé nénahni míre. We omaq atóge. Wene ehweh íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wene ehweh íráhro úwana Sísa webataq míowara tagowe. Sísa kéró anítógá minayabe ehiya méra mi tanáhráq se tago naneq mó ke íre teríúwe. ");
INSERT INTO awb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ahbiah tahnsá sega sáwéhrapeq suera túwara áhnte kegá Sísareq piehgíúwe. ");
INSERT INTO awb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Se míórabeqte wéhgá anotah ehwéhnue mahraréna, Íwáhnoraníno, nénahnimé peh morá ání míéhre. We tagáhno. ");
INSERT INTO awb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Owainawanka we subiqmaréhtáq kare aruqarurire. Owainawanka áwíoqneh puana iransá iransánéna wene áwéhipeqté arehya kíobi aruqarurire. Wega áhnte subiqmaq subiqmaréna íre apubúue soraq áúwéhre. ");
INSERT INTO awb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Are kéráh kéyábé, Kaqauwáhro éna pagu pagunugarawe sega íre miraorahowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Íre miraorahowe úwana Sísaga míó keyabé, Ite íre aiq pútare ainteq saiyo ke wóe. Iteba mía míaume ahkake awehraq kanabo? Itega miraonsabé nirupipeq umehime ahkake parabaginabo éna abowansabé, Arenahni ínéba meqme súno úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Úwana abowágá wenahni meqme sútaq owainawanka we subiqmarena kúrugúru atowana Sísaga owainawansabé, Auwe pokúno atena mi aní kaweratena wenaboba atowe. ");
INSERT INTO awb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Manikánka Sísa págegeue séhréh atowara tago kegá minayabe áhtenuwe. Sísaga moke miraú naneqsabé tago kegá áhtenutaq wega we kéró keyabé, ");
INSERT INTO awb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ínéga teiéna ehwéh iwíáhue tagahro. Íné wehukení úku aní móintagéhe úwara ");
INSERT INTO awb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","sega mi ehwéh íre ahtebowe. Mi tanáhráq mi ehwéh áwahewé sirupipeq íre iwíáhuwe. Minayabe se íre ahtebéra kasenéyabe áhreuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sísa kéró kega mó anínká mó anínkáue, Íné anotah aní ite kiotaiqme aní múge iraréra ehwehuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sísawe sene sirupipeqté íwíáh tagéna káriq aní meqmena we míorabeq iriwe atena ");
INSERT INTO awb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","sensabé, Ínénsabe arutaboiraintena mahna tahnsa káríq ání séhréh atéh ánínká íné moq séhréh aintéhre. Íné séhréh aintéh ánínká íné eqmaq núwéh ánínseq séhréh atéhre. Íné pehgáriq aní múge íwíáhi anínká anotah aní ména mó ke kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sóniga Sísansabé, Íwáhnoraníno, mó anínká arenáwírue owainawamarí kaqsúéhraq tagéq ahqáho atone. Wega ite íre séíréhnsábé ahqáho atone úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Úwana Sísaga wensabé, Íre ahqáho atáhro. Íre itene naruo aní míéh ánímé itene iyahnabo aní míre úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Manikánka Sísa íópeq tumeranaína tanáhráq wahtonúnsabe Sísaga, Sarúsarama suwahpeq pokinauge íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sega káénarabeq kaweraitageheéna Sísaga wehuke Sámáría suwahpeq eqmaq suowara sega kaweraritaneheéra mibeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mibeqté kégá, Sísa Sarúsarama suwahpeq pokinawire u író púara wensabé íre mehweh atówe. ");
INSERT INTO awb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Íre mehweh atówara Sémísireq Sónireqka minayabe irera Sísansabé, Itene Wahnahno, íópeqté sokaeqsuahnaga mah ke tabipáhrue anehinsagigeheéq tabipáhraruo irareyehnkoyo uye. ");
INSERT INTO awb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Uyana Sísaga ebeq kéna pabeqme se tagéna, Ahqáho. Íre kaweq ehwéhnóye úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sega mitaq suera mó kehíná suwahpeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sega ahtapeq pokue mó anínká Sísansabé, Are pokónarabeq kéraníe úwana ");
INSERT INTO awb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sísaga wensabé, Úrinsi iáné nahme ebahnarahpipeq kéhre. Kabarane nahme sehwerapeq kéhre. Íné wehukení úku anímé néne nahme íre kéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sísaga mó anínsábé, Séniro úwana, Ebeqme nánibo pukinana komaisarena anehe kéraníe úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Úwana Sísaga wensabé, Pusa kégá pukira ke maisaragéhboq arewe Manikánka wahnah wahnahnirabeqte éhwéh kosíwáhnorúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mó anínká Sísansabé, Anotah aníno, íné are kéraníe éna téhwe nánuwahrahyabé iroro koaritanínkono úwana ");
INSERT INTO awb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sísaga wensabé, Soberi anínká anehepeq pabeqme taga tagaínaraqmé Manikánka wahnah wahnahnirabeqte árámbéhrí íre miraorahire úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mó tanáhráq Sísaga 72 wehekéq omaq sitena téhraníté téhranítéue moke mó kehiná suwahpeqkakáq sene marakóakaq we mótaq pokinaúrabeq eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Eqmaq suanaútaq wega pabeqme ehwéh mahraréna, Sotápéqté ménsáméhnsá moke nera kéhrara íre áhnte kegá koawaqmianeheéra pokowe. Minayabe sotápéqté wáhnáhnsábé, Arene nera kéh ménsáméhnsá arambehri kegá koawaqmiageheéq eqmaq sueq púreroro. ");
INSERT INTO awb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sipisípiq áráhqmarinká úrinsi iámárínká nogórabeq nogónserah ite subiq suahráho ke míáhrabeq eqmaq suaníe. ");
INSERT INTO awb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Móne unáhmé unahnúrámé súwe íre meyáhro. Ahtapeq mó ke piehgírataq íre mehweh arítáhro. ");
INSERT INTO awb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nahupeq kibekirataq mibeqté kéyábé pehwehrue míáhro arito. ");
INSERT INTO awb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Uwaresa ání nahupeq míéhnaraq itene ehweh irankéhe. Uwaresa ání íre míéhrataq itene kaweq ehwéhnká iteba kowekinkehe. ");
INSERT INTO awb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Manikáne arambehri mirao puaq itega kibekira nahtápéq kaeareq sega náíra tahutáhúq pehipi nahro. Peh morá mi nahupéq kaegaeoro. Séhréh arítéh kégá arambehri aní awehraq apéq náwigéhe. Minayabe ite íre matíéhra naneq náigéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Náigéhe éna, Itega mó ke suwahpeq kirara mehweh aitera náíra tahutáhúq pehipi nahro. ");
INSERT INTO awb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mitaqté áwáhré ké kawerariteq sensabé, Manikánka wahnah wahnahnirabeq iteba wahtotaragire. ");
INSERT INTO awb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mó ke suwahpeq kirara sega íre mehweh aitéhrataq mibeqté wahba áhtápéqmé iriwe méq mahraréq, ");
INSERT INTO awb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Itewe ahtebageheéq mahtaqté tánáhúq, igárátáq kéh tánáhúq poruaruanehe oro. Manikánka wahnah wahnahnirabeq iteba wahtotarire. Minayabe iahreraq matíáhro teríéro. ");
INSERT INTO awb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Teiníboq írátíáhro. Manikánka ehweh aritahna tanáhráq Sóróma suwahpeqte áhbábáq kéwé ákáhtaq kamah arinkéhe. Itega tanahuq poruarueq mi ehwéh teríé kéwé anotahtaq kamah arinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sísaga mó mahraréna, Kórásíni suwahpeqte kéreq Pétásáíra suwahpeqte kérero, kamah ainehboq kawerurero. Iteruwahpeq áhnte otáq sánsá miraurauge. Táíya suwahpeqte kéreq Sáíróna suwahpeqte kéreqka mina tagotaq tahirímé sene ahbabáq naho suera kaweqtaq míó irino. Sega mina tagotaq tahirímé sene ahbabáq aiq súónsabe Manikánka tagankeheéra nahonáh kórósí aneranerue tanah abaq marera sene ahbabáqsabe tútuue ibiso irino. ");
INSERT INTO awb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Minayabe Manikánka ehweh aitahna tanáhráq mi keyábé peh ákáhtaq kamáh arinkéhe. Mi tanáhráq ite Kórásíni suwahpeqte kéreq Pétásáíra suwahpeqte kéreqme anotahtaq kamah ainawire. ");
INSERT INTO awb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kápénéáma suwahpeqte kéo, ite kaweq ke míone éq minayabe íópeqté mátábúrápéq kioneheqmúne íwíáhoo? Írakaumo. Mibeq íre kioneheqmóe. Peh iraipéq kowíáhro aitanawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sísaga eqmaq suanaú keyabé mó mahraréna, Itene ehweh íráh kéwé néne ehweh moq íráhwe. Itensabé ahqáho aitáh kéwé ínénsabe moq ahqáho aintáhwe. Ínénsabe ahqáho aintáh kéwé íné eqmaq núwéh ánínsábé moq ahqáho atáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sísaga omaq sitena eqmaq suo kega sirupipeq eyoyóue weba kouwekéra wensabé, Itene Wahnahno, arenáwírue owainawamarínsábé pokurero aritonara apubúue poku pokuowe uwe. ");
INSERT INTO awb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Uwana Sísaga sensabé, Sokaeqsúéhnká téhrehnserahnue owainawamaríné wahnah wenáwíq Séténi íópeqté tunse inahsubuwana tagahwae. ");
INSERT INTO awb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Írátíáhro. Ínéga págege aitó púaq itega wehenkakáq tobinahránkakaq abasawe itene naruo aní owainawa kiotaikigehe. Mó naneqka ite íre ahbabáraitahráhire. ");
INSERT INTO awb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Itega owainawamarínsábé miraoro e ehwéh íráhnsábé íre iwíáh íwíáhoro. Peh íópeq Manikánka iteíwíq wene púkuipéq aiq sehiranurainsabé iwíáh íwíáhoro úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mi tanáhráq Manikáne Awanka Sísane arupipeq eyoyó atowana mahraréna, Nániboo, arega íópeqkákáq mah marákó márákóákáq wahnahnóne. Wehukene sánsá ahtebah kewé arene sánsá íre sokigi ariasa peh morá káriq aní tahnsa ké arene sánsá aiq sokigi ariene. Minayabe arensabé iwíáh íwíáh atóge. Nániboo, arerega iwíáhue aiq miraóne. ");
INSERT INTO awb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aiq miraóne éna mitaq míáh keyabé, Nániboga moke aiq náníre. Mó kegá íné Manikáne ahninkáwá íre tábúsoqme tagaríáhwana Nániboga webataq íné wenahni tagaríéhre. Mó kegá Nánibo íre tagaríáhwana ínébataq wenahninká we tagaríóge. Íné wenahninká we sokigi aiéna kegá moq Maniká Nánibo tagariagehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sísaga pabeqme we kéró keyabé epéq teriena, Itene iuranka áhntetaq tagahnsabe iwíáh íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Teiníboq írátíáhro. Áhnte Manikáne ehweh iraru kereq anotah wahnáh kéreqka itega tagah naneq tagéyabe suwahbówara íre tagowe. Sega itega íráh éhwéhnsábé ireyabe suwahbówara íre írówe úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mósísine ehweh síwáhnori anínká séna Sísaga ahbabáq ehweh irarinkeheéna áhwárawe tagéna kasenúwe. Kasenéna, Íwáhnoraníno, oga mérapeq awaq mianíboq anerininkono úwana ");
INSERT INTO awb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sísaga wensabé, Mósísiga sehgíóro ú ehwehnká anereiro? Minawé arene arupipeq aiq ahtebahno úwana ");
INSERT INTO awb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","mi anínká mahraréna, Maniká itene Wahnahnsabé anotahtaq arutaboirúno. Moke arene arupipeqkákáq moke arenawankakáq moke arene iwíáhónaipéqkákáq Manikánsabe arutaboirúno. Arerensabé arutaboirónanserah arene iyahnabo anínsábé moq arutaboirúno ire úwana ");
INSERT INTO awb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sísaga wensabé, Arega aiq tábúsoqme iraréne. Tenienanserah mirainaraqmé oga mía míainiewóne úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mi anínká iwíáhéna, Sísaga íné Mósísine ehweh íre kawerue íréhre íwíáhineho éna wega Sísansabé, Néne iyahnabo aní insebo kasenúwe. ");
INSERT INTO awb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kasenúwana Sísaga wensabé, Wehga Sarúsarama suwahpeq suena Séríko suwahpeqte áhtápéq tutairara aebó kégá mehwatawéra táhtoqme subiqmarera wene ménsámehnsá moke sabiwera pokurowe. Anotahtaq subiqmato puana pukinauraitaq we íre nogoráhéna peh ahnayehráq tahperuriaraire. ");
INSERT INTO awb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tahperuriarairana Manikáne ehweh mibeq mahbeq arítéh ánínká tunse mi aní tagéna ébeq ayéhrápéqtáq sótaikue pokuraire. ");
INSERT INTO awb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mina urainserah Asiu kené sánsá mirai aní we Áríwái kahnáh ánínká kire mi aní tagéna we moq ébeq ayéhrápéqtáq sótaikue pokuraire. ");
INSERT INTO awb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sámáría suwahpeqte ánínká kire Asiu weh tagéna we ahnayehráq tahperuriarainsabé arutaboiréna ");
INSERT INTO awb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","weba sure mayawenkakaq náhníáq sera anonkakaqtáté puramburanútaq abaq atena airí atena mi weh pankeqmaqme wene tónkine abobiahtaq tútu atowana mi kanká áhkokóuwena pokuraire. Sámáría suwahpeqte ánínká mi weh meqmena páhsíntía nahtápéq móatena mitaq wahnahnuraire. ");
INSERT INTO awb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ahbiahraq mi nahtápéqté wáhnáh téhtaré móné náwena wensabé, Subiqmato aní kawerue wahnahnatawéwahno éna, Íné kouwekonaraq áwú móné íre awehraq kahnaraq mó awiníe uraire úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sísaga mi ehwéh aiq teawena Mósísine ehweh síwáhnori anínsábé, Apahránítógá ahnayehráq subiqmato aní tagaronsabé wene iyahnabo aní insebo kasenúwe. ");
INSERT INTO awb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kasenúwana mi anínká Sísansabé, Wene iyahnabo anímé wensabé arutaboiratena séhréh atéh áníne úwana Sísaga wensabé, Arega pokue séhréh atárái anínká miraurai serahnúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sísareq we kéró kereqka pokue mó ke suwahpeq kuwana mibeqté íní wenáwíq Máhtaga Sísa mehweh atena wene nahtapeq meqmena móatowe. ");
INSERT INTO awb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Máhtane ónánahwá wenáwíq Máhríae. Máhríaga Sísane ehweh iranieéna wene aigárápi tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tútuue míowana Máhtaga táhutahuq kawerinieéna áhnte ahwímínú púana wene arupipeq iwíáh kikirúwe. Iwíáh kikiréna Sísaba séna wensabé, Néne Wahnahno, nénónánahga núwéhrana áhnte ahwímínunsabé arega anetaníbo íwíáhono? Íné séhréh ato teawo úwe. ");
INSERT INTO awb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Teawo úwana Sísaga wensabé, Máhtao, arega áhnte ahwímínónayabé arene arupipeq iwíáh kikiróne. ");
INSERT INTO awb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Peh morá náneqsabé iwíáhúno. Máhríaga mina kiotaiki naneqsabé arutaboiréna aiq omaq maréhraq itega we íre saiqnariayehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mó tanáhráq Sísaga móbeq ména púreréna parabagúwana we kéro anínká wensabé, Itene Wahnahno, Sóniga we kéráh kéyábé púreq ehwéh síwáhnorurainserah íwáhnorúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Úwana Sísaga sensabé, Púrerirataq mahrarero. Iteriboo, arenáwíq pankerone. Arega mah kehiná kéhíná wahnah wahnah aritahna tanáhráq apubúue ábóraragúno ato. ");
INSERT INTO awb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mó wehekáh mó wehekáhnue itene táhutahuq awehraq kirabo aito. ");
INSERT INTO awb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mó kegá ahbabáraitáhmé itega minayabe íre ahreraq masa peh suone. Itega miraúnanserah itene ahbabáq moq íre ahreraq matiahno. Ahbabáqka ite saiqnariahrahirabeq íre móito. Miraue púreroro úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sísaga we kéró keyabé mó mahraréna, Mó kehiná suwahpeqte arene iyahnabo anínká inokáhnabubu sínah are tópah tabonahinaraqmé anerinibo? Mi tanáhráq arenawahrah aníné nahtapeq pokue áhrabé, Irigue tópah nánio ue ineh inehinkehe. Ineh ineheé, ");
INSERT INTO awb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Néne iyahnabo anínká amahnága íre wahtopeqte sirana tópah tabonahunsabé iriwe tópah náninana kiraboono teawinkéhe. ");
INSERT INTO awb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Teawinana arenawahrah anínká wene máhriqpeqté iraréna, Ahqáho. Onsa aiq paiqmarena néne animárínseq sugonayabé túbáh agúno éna, Íre iriwe aweráhuge teawinkéhe. ");
INSERT INTO awb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Teawena, Inehi anímé nánuwahrah aní míéhsábé anetaníbo. Inokáhpeq puana íre náwiníe íwíáhínaraqmé túbáh agineho. Túbáh aginehboq peh píribahriue, Nánio. Nánio úno. Nánio inaraqmé arenawahrah anínká mó iwíáhéna are íre kéh náneqmarí irigue náwinkéhe. Mina inserah púrerirataqmé apubúue túbáh agiyehboq peh mótaq mótarue teawéro. ");
INSERT INTO awb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Teiníboq írátíáhro. Itega púrerirataqmé náiyo ira naneq náinkéhe. Págegeue kabarirataq ábórarínaq taganeheqmóe. Onsaraq pakobakoirataq siitankéhe. ");
INSERT INTO awb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nánio i anínká meyankéhe. Kabari anínká ábóraq marankéhe. Onsaraq pakobakoi anímé Manikánka siatahnana nahupeq kibekinkehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sísaga mó mahraréna, Arenahninká arensabé, Paseh nánio ínaraqmé arega wehe náwiníbo? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wega, Iyah oyérá nánio ínaraqmé tobinahrá náwiníbo? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ite sibowáréh ahbabároraho keéqmé itene animárí peh kaweq naneq nári nárino mino. Íópeqté Ítéríbógá íre ahbabárorahi aní ména Wenawa eqmaranae. Minayabe wensabé, Arenawa ínéba eqmaro irarinaraq areba eqmaranawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Owainawanka wehukení subiqmaq subiqmarú púana we ahriahri íre ehwehnorahúwe. Íre ehwehnorahúwana Sísaga mi owáínáwánsábé pokúno atowana pokúwana mi anínká ehwehnúwara áhnte tago kegá áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Áhtenuwara mó kegá mahraréra, Owainawamaríné wahnah wenáwíq Pésébúríga Sísa págege atena séhréh atéh púana wega owainawamarí kaqsuáhráhire éra seye náhenéra ehmuniq éhmúníruwe. ");
INSERT INTO awb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ehmuniq éhmúníruwara mó kegá Sísaga ahbabárinkeheéra áhwárawe tagéra sega wensabé, Manikánka séhréh atahnaraqmé íópeqté íre tagariona naneq sokigi aio uwe. ");
INSERT INTO awb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Uwana Sísaga sirupipeqté íwíáh tagéna sensabé, Wahba márákórápéqté kégá seye ebehirataq sainkoneherawoe. Minayabe se sainkéra págegeue morá ké íre míahrahowe. Sensuwahrahreq seye ebehirataq sainkoneherawoe. Minayabe se moq págegeue morá ké íre míahrahowe. ");
INSERT INTO awb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Owainawanseq wenawahrahreq ebehotaq tahirímé se sainkéra árahue págegeue míagehbo? Írakaumo. Íre págegeue míahrahowe. Itega péhe éhwéh mahraréq, Owainawamaríné wahnahnka íné séhréh aintéh púana owainawamarí kaqsuahráhuge ewe. ");
INSERT INTO awb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ínéga owainawa kaqsúótáq owainawane wahnahnka séhréh aintéhtáq tahirímé ite kéíráh kégá owainawa kaqsúáhtáq insega séhréh arítéh iripo? Ite kéíráh kégá itene ehwehnsabé íre tábúsoréhre aitáhwe. ");
INSERT INTO awb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Manikáne Awanka págege aintena séhréh aintéh púana owainawamarí kaqsuq kaqsuruge. Mina tagéq Manikánka wahnah wahnahni sansá iteba aiq sire éq tagaríáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sísaga mó mahraréna, Ayahnsa kira wehgá wene pokankakaq iqkakaq sokah sokah atawéna wene nahtapeq wahnahnínaraq wene ménsámehnsá peh kaweqtaq kanae. ");
INSERT INTO awb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mó ayahnsa kira wehgá weba séna wahnahni weh subiqme kaqsuena wene ebeh naneqmarí mewena wene ménsámehnsá saraqme meyankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sísaga mó mahraréna, Wehukenínká íre néne iyahnabo aní míéhmé néne naruo aní míre. Wehukenínká ínéreq íre soruparítéhrataqmé wega wehuke karegaráh aruqarurire úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sísaga mó mahraréna, Owainawanka wehukení auwena pokitaq wání íre kéhrabeq nogena ahrenahrahirabeq kabarire. Kabarirana írakauninsabé iwíáhéna, Ínéga súó náhtápéq seuwekinauge éna ");
INSERT INTO awb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","áúwátái wehukénípá kouwekire. Kouwekéna wene nah tagehrana aiq kabantáhwe parabaruena aiq kaweraréhre. ");
INSERT INTO awb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kawerarena mó abapete téhraníté áhnte ahbábáq ówáínáwámárí koweriréhre. Moke mi owáínáwámárí mi anípá kowíáhwe. Téhwe morá ówáínáwánká mi anípá míéhtáq íre kawerire. Anehemé áhnte owáínáwámárínká weba míáhnsábé anotahtaq íre kawerire úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sísaga mahrarútaq wene ehweh iro inínká anotahtaq mahraréna, Arenanoga are maqmarena náh náwunsabe Manikánka wensabé kaweróne atéhre úwana ");
INSERT INTO awb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sísaga wensabé, Náinoga maqintonsabe Manikánka kaweróne atena peh wene ehweh irera sehgíó kéyábé anotahtaq kawerowe arítéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Áhnte wehukégá Sísaba sáhuríówana wega sensabé, Ite amahnága oga míáh kéwé áhnte ahbábáq kée. Itega iraréq, Manikánka are aiq pútaq séhréh atéhre tagarianeheéq ótaq sansánúno teni teninowe. Sónaga sóreq wanípípéq tupekútaq Manikánka ótaq sansá miraúwe. Peh morá mi sansá teienaq iwíáhue tagagehe. Ínéga ótaq sansá mó íre sokigi ainíe. ");
INSERT INTO awb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Níníbe suwahpeqte kégá Sóna tagéra Manikánka miraú otáq sánsá tagowe. Amahnága oga míáh kégá íné wehukení úku aní tagéra Manikánka miraína ótáq sánsá tagagehe. ");
INSERT INTO awb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sórómóniga Ísara keráq wahnahnútaq wáhnaupéqté kéné wahnah inínká wene ahtebia éhwéh iranieéna íre wahtopeqte weba súwe. Teiníboq írátíáhro. Amahnága iteba míó ánímé Sórómóni kiotaiku aní múge. Mi inínká Sórómónine ahtebia éhwéh ironserahme árahinsabé néne ehweh íre iraho? Minayabe Manikánka ehweh aitahna tanáhráq mi inínká iriwe ména itensabé ehweh aitankéhe. ");
INSERT INTO awb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Níníbe suwahpeqte kégá ahbabáruwana Sónaga ehweh koreriutaq wene ehweh irera sene ahbabáq sansa suera kaweqtaq míówe. Minayabe Manikánka ehweh aitahna tanáhráq Níníbe suwahpeqte kégá iriwe méra ite amahnága oga míáh kéyábé, Íre kawerowe éra ehweh aitagéhe. Amahnága iteba míó ánímé Sóna kiotaiku aní múge. Níníbe suwahpeqte kégá Sónane ehweh írónserahme árahinsabé néne ehweh íre iraho? ");
INSERT INTO awb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sísaga mó mahraréna, Wehukenínká áráhmu keqmaréhtáq kopípéq tahbe tehnopeq íre máréhre. Páhkétiraté íre akariaréhre. Írakaumo. Nahupeq kibeko kegá kawerue tagageheéna áráhmu tahberapeq máréhre. ");
INSERT INTO awb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Arene aurame arene anonkataq kéh áráhmú tahnsáne. Arene auranka kaweq naneq tagehnaraq arene arupipeq téhranae. Arene auranka ahbabárorahi naneq tagehnaraq arene arupipeq sunkíkírinae. ");
INSERT INTO awb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Arene arupipeqté téhrehme sunkíkírínehboq áwéh panantágínaq tagaríáhro. ");
INSERT INTO awb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Itene iwíáhopipéq íre sunkíkíria peh moke téhráhnaraq áráhmuga moke nahupeq téhrehnserah itene iwíáhopipéqté téhrehnka itene inonka moke téhranae úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sísane ehweh parabagúwana Péhrasi anínká wensabé, Néne nahtapeq táhutahuroyehboq máho úwana Sísaga we kérena táhutahuq nanaúwe. ");
INSERT INTO awb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sísaga wene ayahnkara íre pabeq paberia pehipi nónsabe mi anínká áhtenúwe. ");
INSERT INTO awb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Áhtenúwana Sísaga wensabé, Itega káhpuakáq párétahakáq pabeq paberotaq peh ábórapeq pabeq paberéq arupipeq íre pabeq paberowana peh náwíqkakaq mitaq kéhre. Mina onserah itene inonka pabeq paberowana itene irupipeqmé aebó íwíáhwé áhnte ahbábáq íwíáhwé mitaq kéhre. ");
INSERT INTO awb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ite múguwahgu saiyo animárí móe. Manikánka íre peh morá ábóraq kéh náneq miraia kopípéqté náneqmarínkákáq miraro mino. ");
INSERT INTO awb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ite matíáh náneq mó ke wehwehue nárieq séhréh arítáhro. Mirairataqmé moke matíáh náneq peh kaweqtaq kanae úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Sísaga mó mahraréna, Péhrasi keo, moke itene sotápéqté ménsáméhnsá saraqme abapete itaréitaré matawéq peh morá mewe Manikáne arambehri mirao ke síéwe. Kawerowe. Pehgáriq naneqmarí táwiomé kímé náwahbiame moq saraqme síéwe. Kawerowe. Mi sansá sehgieq íre súáhro. Peh kaweqtaq mé sansamé Manikánsabe irutaboirome mi sansátáré íre sehgíówe. Íre kawerowe. Mi sansánkákáq sehgíóro. Íre miraonsabé Manikánka kamah ainehboq tábúsoqme sansánoro úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Sísaga mó mahraréna, Péhrasi keo, ite Asiu kené momiwí nahtápéq kaweqtapéq méyabe iuwahbeh ke wóe. Ite máhkétirapéq nogótáq mó kegá ite mehweh aiteyabe iuwahbeh ke wóe. Minayabe Manikánka kamah ainehboq tábúsoqme sansánoro. ");
INSERT INTO awb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pusa ké maisia máíq kéhrabeq mó kegá íre tagia mitaq pehipi nogówe. Mina inserah itene iwíáhipeq kambaresa náneq tahnsá kéhrara mó kegá íre tagahwe. Minayabe itewe pusa ké maisia máíq tahnsa móe. Manikánka kamah ainehboq tábúsoqme sansánoro úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mósísiga sehgíóro ú ehweh síwáhnorú anínká Sísansabé, Arega irarénawe itensabé moq ehweh aitahne úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Úwana Sísaga mahraréna, Mósísine ehweh síwáhnoro keo, Manikánka ite moq kamah ainehboq tábúsoqme sansánoro. Mósísine ehweh áhnte pagégé éhwéh púaq itega síwáhnorowara íráh kégá íre sehgioráhowe. Sega íre sehgioráhonsabé itega mi ke pehgáritaq íre séhréh arítáhwe. ");
INSERT INTO awb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Itene igaqnaréhga Manikáne ehweh iraru ke subiq súówe. Subiq suera maisarówaq ite maisarórabeq itega ebah pentabaráhwe. ");
INSERT INTO awb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Itega miraome aneq sansánoo? Itene igaqnaréhga kaweq ke subiq súónsabe itega sene ahbabáqsabe, Kaweq sansáne éq anehe mi kawéq ké maisarórabeq ebah pentabaráhwe. ");
INSERT INTO awb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Minayabe Manikánka tábúsoqme iwíáhéna mahraréna, Néne ehweh irare kereq síwáhnoro kereq seba eqmaq suanauge. Eqmaq suahnara sega táhmaro síwíoqnéra mó táhmaro subiq suaneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sísaga mó mahraréna, Sega Manikáne ehweh iraru ke subiq súówe. Manikánka mah marákó márákó mirarotaq téh subiq súótaqte mi ahbábáq amahnága oga míáh kéné ahbabáq úkire. Minayabe Manikánka kamah ainawire. ");
INSERT INTO awb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sega wehukení wenáwíq Ábéri ebeq subiq súówe. Anehemé wehukení wenáwíq Sékáráía Manikánsabe iwíáh íwíáh atáh náhtápéq míowara subiq súówe. Mi anítéreq moke ákáhpi subiq súó kereqne korahq tunsabe Manikánka amahnága oga míáh ké kamah ainawire. ");
INSERT INTO awb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mósísine ehweh síwáhnoro keo, itega ahtebah onsárápété kí kopéq súáhwe. Itewe mibeq íre kibekia mibeq kibekonehe e keyábé ahqáho arítáhwe. Minayabe Manikánka kamah ainehboq tábúsoqme sansánoro úwe. ");
INSERT INTO awb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sísaga mitaq suena máhpeq tuegúwara Mósísine ehweh síwáhnoro kereq Péhrasi kereqka wensabé abiahnsa atera áhnte ehwéh kasenuwe. ");
INSERT INTO awb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sísaga ahbabáq ehweh irarinkeheéra sega mó ehwéh mó ehwéhnue kasenéra áhwárawe tagowe. ");
INSERT INTO awb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Peh íregáritaq kegá sáhuríó púara mó kené sigárá músúríówana Sísaga ebeq we kéró keyabé síwáhnoréna, Péhrasi kegá kopéráhpéro sansá pehragahro. ");
INSERT INTO awb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Amahnága moke kopípéq kéh náneq mókake ábóraraginae. Moke epéqté éhwéh ábóraraginae. ");
INSERT INTO awb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Itega sunkíkírirabeq iraruro ehwéh mó kegá téhrehrabeq iragéhe. Itega nahupeq ehmuniq éhmúnírue irarira ehwéhmé mó kegá irera nahnsorapéqté sawai sawaiue irarigehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sísaga mó mahraréna, Néne iyahnabo anímáríno, teiníboq írátíáhro. Peh itene inonka subiq suahráho keyábé íre áhreoro. Mi kegá iteyuwa íre subiq suahráhowe. Írakaumo. Minayabe sensabé íre áhreoro. ");
INSERT INTO awb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Teiníboq írátíáhro. Peh morá Manikánsabe áhreoro. Wega ebeq itene inonka subiqmarena anehe iteyuwa iraipéq suahráhi puaq wensabé anotahtaq áhreoro. ");
INSERT INTO awb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Káriq kabárá máhkétirapéq téhtaré pabusa monéráté moberíáh kábárá paiqmarahráhire. Mina tahnsa káríq kábárá Maniká Iteriboga íre abitarúéhre. ");
INSERT INTO awb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maniká Iteriboga moke itene iyahqnopeqte íyáhrámé sáhnsahwe tagaríéhre. Wega ite aiq moke tagaríéh púaq íre áhreoro. Itega kabaramarí kiotaiko puana Manikánka ite íre abitarúéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sísaga mó mahraréna, Teiníboq írátíáhro. Wehukenínká mó keyábé, Sísane ani múge terinaraq mókake íné wehukení úku anínká íópeqté ké míéhrataq Maniká Iteribonsabé, Néne ani míre teawiníe. ");
INSERT INTO awb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Arega mó ke míáhtáq ínénsabe, Ahqáho. Íné íre tagaríóge aintéhnaraq mókake Maniká Iteribo míéhrabeq ínéga arensabé ahqáho atena are íre tagaríóge atanauge úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sísaga mó mahraréna, Íné wehukení úku anínsábé níéhruru aintéh ánímé Manikánka insahwé atena íre ahreraq matianawire. Peh morá Manikáne Awansabé éhrurui anímé Manikánka íre insahwé atanawire. Ahqáho. Peh ahreraq matiankehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Sísaga mó mahraréna, Mó kegá ite táhtoqme ehweh aitanehera irataq itene irupipeq iwíáh kikiriyeho. Sega ite meiqmera Asiu kené momiwí nahtápéqté wáhnáhpápópoq wahba wáhnáhpápópoq mó anotah anípápópo móítéhrataq itega, Aneq ehwéhnonehnkono éq áhreiyeho. ");
INSERT INTO awb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mi tanáhráq Manikáne Awanka irarína ehwéh sokigi ainkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Peh íregáritaq kegá sáhuríówana mitaqté ánínká Sísansabé, Íwáhnoraníno, nániboga pukurairana wene ménsámehnsá nánuwahga moke meraire. Mi mensáméhnsá ákáhtaq náninkéhboq nánuwahnsabé ákáhnsaime náwo teawo úwana ");
INSERT INTO awb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sísaga wensabé, Íné ménsámehnsá saraqme nári nárinkeheéna insega omaq intáráiro? ");
INSERT INTO awb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Insega omaq intáráiro éna mitaq míó keyabé mahraréna, Ménsámehnsánsabe igárá pabekínehboq kawerurero. Íre sene áhnte kéh ménsáméhnsánsábé wehuke oga míahrahowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sísaga mah pabéqmé éhwéh mahraréna, Anotah wehné so áhnte mensáméhnsá iráirana ");
INSERT INTO awb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","wewe náhenéna, Áhnte mensáméhnsá matíónsábé eheq saharanínkono uraire. ");
INSERT INTO awb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Eheq saharanínkono íwíáhéna, Íné mahrainie éna néne ménsámehnsá kéh náhmárí sokoruqme mó anotah nahmárí pearena néne áhnte mensáméhnsá mipéq sáharaníe. ");
INSERT INTO awb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mipéq sáharáhnaraq mahra íwíáhinie. Néne matíó ménsáméhnsá áhnte opéq awehraq kanae. Minayabe amahnága túbáh aginie. Táhutahurinie. Iwíáh íwíáhéna ábáhrinie íwíáhuraire. ");
INSERT INTO awb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iwíáhurairana Manikánka wensabé, Múguwahgu saiyo aní móne. Ibora penahnaraq are pukiniewóne. Minayabe are áhnte matiahna mensáméhnsámé inseréhga awaq miagéhbo uraire. ");
INSERT INTO awb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Maniká Iteribonsabé íre sirutaboiria peh sene ménsámehnsánsabe sirutaboiro kewé teawú ání tahnsa ké wóe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sísaga we kéró keyabé mahraréna, Teiníboq írátíáhro. Mah marákóípéq mé tanahráqsábé itene irupipeq iwíáh kikiriyeho. Aneq naninkono? Aneq korósí sukiwianínkono íre iwíáhoro. ");
INSERT INTO awb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Oga méwé íre peh morá tópah nahnagae. Itene inonkame íre peh morá aneraneré naneq mire. ");
INSERT INTO awb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kúqnu tagéq ahtebahro. Mi kanká ménsúmehnsú íre uqmaréhre. Sene táhutahuq tahbé íre kéhre. Minayabe nera kéhtáq íre koawaqmena méáréhre. Manikánka mi kansábé iwíáhéna pehipi kiraboire. Itewe wehuke puana Maniká Iteriboga itensabé anotah iwíáhéna kawerue kirabo aitéhre. ");
INSERT INTO awb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Arega arene oga mé tanahráqsábé iwíáh kikirinaraqmé ábátáq mérearahráhiro? Ahqáho. Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Itene oga mé tanahráq ábátáq mérearahráh íre únayabé mó naneqmarínsábé aneqsabé iwíáh kikironehbo? ");
INSERT INTO awb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Uworapeqté náneq kirena kaweq ará íyéh tagéq ahtebahro. Uworapeqté náneqka íre arambehrire. Korósi íre kogahnire. Anotah wahnáh ání wenáwíq Sórómóni naho ména we áhnte mensáméhnsá matawéna anotah kawéq áwáhríq kórósí matiowe. Uworapeqté kaweq ará íyéh náneqka Sórómónine kaweq awahriq naneq kiotaikire. ");
INSERT INTO awb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Uworapeqté náneq íre kagai naneq mire. Ibora íyéhrana ahbiah tahnsá kekírataq taginae. Manikánsabe pehgáritaq aiq pútare átáh kéo, Manikánka mi kawéq árá sukiwíéhnsábé wega ite moq sukitahráhi mino. ");
INSERT INTO awb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aneq nanehnkono íwíáhéq irupipeq áhnte iwíáh kikiriyeho. ");
INSERT INTO awb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Maniká íre tagaríáh kégá minayabe iwíáh íwíáhéra sene sirupipeq iwíáh kikirowe. Iteriboga ite íre mationa naneq aiq tagaríéhre. ");
INSERT INTO awb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Minayabe Manikánka wahnah wahnahnirabeqte sánsánsábé irutaboiréq sehgíóro. Sehgírataq wega ite íre mationa naneq náinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sísaga mó mahraréna, Ite sipisípiq nansó táhnsá kéo, íre áhreoro. Maniká Iteriboga wahnah wahnahnirabeq awaq miageheéna aiq omaq itéhre. ");
INSERT INTO awb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Itene ménsámehnsá paiqmaqme mi moné tabonah ke náríéro. Mirairataqmé kagaorahi mensáméhnsá íópeq mitaq sáharagéhe. Mitaq aebó ánínká íre aebóorahire. Mitaq wenuqka íre nahrahi puana itene kagaorahi mensáméhnsá peh mitaq kagainawire. ");
INSERT INTO awb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Itene kaweq naneq morábí sáharáhrabeqsabé irutaboironeheqmóe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Sísaga pabeqme ehwéh mahraréna, Itene korósi sukiareq áréti konahnareq áráhmu keqme tagaríáhro. ");
INSERT INTO awb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sene wahnahnka pahuwirorabeq suena sína tanáhráqsábé wene arambehri anímárí áwénuno serahnoro. Wega sure onsa pakobakoínaraq sega apubúue onsa sioneherawoe. ");
INSERT INTO awb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Se tótuqméra sene wahnahnsabé áwénuno anímárínsábé, Kawerowe aritankéhe. Teiníboq írátíáhro. Sene wahnahnka we áwénuno keyábé iwíáh íwíáhéna áréti konahnuwena sensabé, Tútuoro aritena kirabo aritankéhe. ");
INSERT INTO awb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wega inokáhnabubupopoq tueina ínaraqpópoq sínaraqmé íre sugia peh wensabé áwénuno keyábé anotahtaq, Kawerowe aritankéhe. ");
INSERT INTO awb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anotah wehgá aebó ánínká sína tanáhráq ahtebehtaq tahirímé wega áwénunue wahnahnurawéna aebó ánínká kibekina ínaraq tagéna kaqsúéh irino. ");
INSERT INTO awb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Minayabe iwíáhue tagahro. Íné wehukení úku anínká ite íre iwíáhira tanáhráq kouwekinauge. Minayabe íwéh panantágínaq níwénunoro úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pítaga Sísansabé, Itene Wahnahno, arega mah pabéqmé éhwéhmé peh morá itensabé teieno? Mó keyábéákáq terieno kasenúwe. ");
INSERT INTO awb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kasenúwana Sísaga mahraréna, Ahtebia ání tábúsoqme arámbéhríi anímé insebo? Wene wahnahnka mi anínsábé, Mó arámbéhrío keráq wahnahnarito atena táhutahuq tanáhráq tópah nário atéhre. ");
INSERT INTO awb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wene wahnahnka kouwekéna teawátái arámbéhrí tábúsoqme mirainsabé tagéna wene arambehri anínsábé, Kaweróne atankéhe. Kaweróne atéhnsábé arambehri aníné aru eyoyóinkehe. ");
INSERT INTO awb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Teiníboq írátíáhro. Wene arambehri anínká tábúsoqme arámbéhríi puana wene wahnahnka, Moke néne ménsámehnsátaq wahnahnúno atanae. ");
INSERT INTO awb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ahbabáq arambéhrí ánínká iwíáhéna, Néne wahnahnka íre apubúue kouwekinae íwíáhire. Mira íwíáhinsabé mó arámbéhrí wéh áhré subiqmarena múguwahgu kereq táhutahuq néna píah naruq narurire. ");
INSERT INTO awb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wega íre iwíáhue áwénunína tanáhráq wene wahnahnka séna mina tagéna anotahtaq kamah awena ehweh íre íráh ké míáhrabeq móatankehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sísaga mó mahraréna, Arambehri anínká wene wahnahne iwíáh irena íre miraínaraq wene wahnahnka anotahtaq kamah awinkéhe. ");
INSERT INTO awb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Arambehri anínká wene wahnahne iwíáh íre ahtebéna mina ahbabárínana wene wahnahnka pehgáritaq kamah awinkéhe. Wehukenínká anotah apéq meyahnaraq anotah apéq awinanao. Mina inserah Maniká Iteriboga wehukení áhnte awena págege atena séhréhínaraq mi anínká Sísane arambehri anotahtaq mirainanao úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sísaga mó mahraréna, Abe kekinai anínká téh kekiaréhrana tawe abae agire. Mina inserah néne ehwehnka abae aginkeheéna marakóipeq tumíarauge. Ira abae aginserah néne ehwehme apubúue abae agéyabe nuwahbehre. ");
INSERT INTO awb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sega mótaq íné íre kaweraintéhra puana amahnága nirupipeq áhnte uméhime mókake kaweraginae. ");
INSERT INTO awb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ínéwé sainkue míáh ké insahwé aitanieéna marakóipeq tutaire íwíáhoo? Írakaumo. Peh sainsuanieéna tutauge. ");
INSERT INTO awb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mó karírónání moberíáh méra apahránítógá néne ehweh sehgíówara mó téhranítégá íre sehgioya puara sainkue míáhwe. ");
INSERT INTO awb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mó mapéq abowáreq wenahninseq sainkue míehye. Mó mapéqmé anowareq ayahunkawareq sainkue míehye. Mó mapéqmé ahrahnawareq anahbukawareq sainkue míehye úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sísaga weba míó keyabé mó mahraréna, Ibonuqna kéhtáq ibonsinae irarewana ibonsire. ");
INSERT INTO awb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Áúnorahntáh kéhtáq patahinae irarewana patahire. ");
INSERT INTO awb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kopéráhpéro keo, itega ibonuqnankákáq áúnorahntáhnkakaq ahtebéqmé aneqsabé ínéga amahnága mirau arámbéhrí íre ahtebahrahoo úwe. ");
INSERT INTO awb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sísaga mó mahraréna, Kaweq sansámé aneqsabé íre iwíáhue mirao? ");
INSERT INTO awb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mó anínká are ehweh atanieéna anotah wahnáhbá meqme kinaraq ahtapeq kirataq we insahwé ato. Ehwehorabeq kirataq wega are anotah sahsí móatahnaraq wega párísiba móatahnana sega are karábúsiipéq móatéhboq insahwé ato. ");
INSERT INTO awb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Teiníboq írátíáhro. Karábúsiipéq móatahnara íre apubúue soraq auwaneherawoe. Ebeqme anotah apéq paiqmarehnaraqmé anehe soraq auwagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mi tanáhráq táhmaro míó kega Páhírátiga miraú ehweh Sísa teawúwe. Kehrari marákórápéqté kégá Sarúsarama suwahpeq Manikánsabe titiruwana Páhírátiga se subiq súáhro aritowe. Subiq súáhro aritowara subiqmárówara pukutaq sene korahqkakáq titiro naneq kané korahqkakáq moráráq mitaq kowe. ");
INSERT INTO awb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Páhírátiga miraú ehweh Sísa teawúwana wega sensabé, Pukuro kené ahbabáq moke mó Kehrari marákórápéqté kéné ahbabáq aiq kiotaiki puara mina tahnsa pukurowe íwíáhoo? ");
INSERT INTO awb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Írakaumo. Teiníboq írátíáhro. Iteitene ahbabáq sansa íre súéhrataqmé ite moq moke pukoneheqmóe. ");
INSERT INTO awb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Síróáma marákóráq íre wahto íópeq pewe kiríá ébáh náh sokoguraitaq 18 wehuké pukurowe. Pukuro kené ahbabáq moke mó Sarúsarama suwahpeqte kéné ahbabáq aiq kiotaiki puara mina tahnsa pukurowe íwíáhoo? ");
INSERT INTO awb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Írakaumo. Teiníboq írátíáhro. Iteitene ahbabáq sansa íre súéhrataqmé ite moq moke pukoneheqmóe úwe. ");
INSERT INTO awb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sísaga mah pabéqmé éhwéh mahraréna, Wehne sotápéq nah naneq será íyéh áwánká kíréhrana wega sera sabátáhrurairana írakaunuraire. ");
INSERT INTO awb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Írakaunurairana wene sotáq arambehri anínsábé, Apahtáró ópéq ínéga mah awánká sera sabátáhruraugana írakaunuraire. Apiruo. Aneqsabé néne marakóraq pehipi kehro urairana ");
INSERT INTO awb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","sotáq arambehri anínká wensabé, Amahnága pehragéna sera iyankéhboq ínéga áwahipeq ubuqme káhone seq maisarahnana ");
INSERT INTO awb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","mó opéq iyahnaraqmé kawerinae. Íre iyahnaraqmé apiruankéhe uraire úwe. ");
INSERT INTO awb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ahrena ahrena wehekáh Sísaga Asiu kené momiwí nahtápéq síwáhnorúwana ");
INSERT INTO awb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","abobia káuqmunia íní mitaq míowe. Owainawanka 18 opéq mi iní áwíoqnó púana we taebewe nogena íre iriwe nogoráhú iní míowe. ");
INSERT INTO awb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sísaga mi iní tagéna wensabé, Mahbeq súno éna arene awahre kaweratóge éna ");
INSERT INTO awb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","wene ayahnkaratáté táhtoqnówana apubúue irigéna Manikánsabe iwíáh íwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sísaga mi iní ahrena ahrena wehekáh kaweratonsabe mibeqté wáhnáh ánínká abiahnsanéna míó keyabé, Arambehri wehekáhmé abapete morá wéhékáh míre. Mó anínká arene awahre kawerateyabe awinaraqmé arambehrié wehekáh sero. Ahrena ahrena wehekáh awahre kaweraiteyabewé íre sero úwana ");
INSERT INTO awb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sísaga mina tahnsa íwíáho keyábé, Kopéráhpéro keo, ahrena ahrena wehekáh itene kamarí wání nageheéq wiraipeqté meriqmeq wánítapeq mórítáh mino? ");
INSERT INTO awb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mah inímé Ébáráhma kahnáh ínínirana owainawanka íregáritaq opéq 18 opéq áwíoqnehrana ínéga ahrena ahrena wehekáh kaweratómé aiq kaweq sansánu mino úwe. ");
INSERT INTO awb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Úwara mi ehwéhnúnka sene sirupipeq pó púara wene naruo anotah siyehitówara áhnte mó kegá Sísaga miraú arámbéhrí tagéra iwíáh íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sísaga mah pabéqmé éhwéh mahraréna, Manikánka wahnah wahnahnime aneq tahnsáne ue teinínkono? Anere pábéqmé éhwéh teinínkono? ");
INSERT INTO awb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Manikánka wahnah wahnahnime awanká ayu pehgáriq ayú tahnsane. Wehukenínká mi pehgáríq áyú wene sotápéq uqmatairana kirena anotah úkéna moke mó mensáméhnsá kiotaikire. Awankánirana kabaramarínká séra ayahnaweraq sene nah píáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sísaga mó mahraréna, Manikánka wahnah wahnahnime anere pábéqmé éhwéh teinínkono? ");
INSERT INTO awb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tírí ínínká muoráhi naneq páráhwaipéq maqme ayahnirana moke múíre. Manikánka íópeq wahnah wahnahnime mina páréti muoráhi naneq tahnsáne úwe. ");
INSERT INTO awb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sísaga Sarúsarama suwahpeq pokinie íwíáhéna pokue moke táhúnipéqkákáq anotah matábúrápéqkákáq síwáhnorinieéna pokúwe. Pokéna síwáhnorue kure kure Sarúsarama suwahpeq koragúwe. ");
INSERT INTO awb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Koragúwana mó anínká wensabé, Wahnah aníno, oga mérapeq awaq míéhra kewé peh táhmaroga awaq mianeherabo kasenúwe. Kasenúwana Sísaga míó keyabé, ");
INSERT INTO awb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tauntahunue sobuya méhpéhpéq kibekoro. Teiníboq írátíáhro. Áhnte kegá nahupeq kibekonehe íwíáhéra íre kioráhowe. ");
INSERT INTO awb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mibeqté Wáhnáhnká onsa paiqmarahnaraq itega méhpeh iriwe méq onsaraq subírataq wensabé, Itene Wahnahno, onsa siito igehe. Onsa siito irana wega itensabé, Ite eheqte kébo? Ínéga ite íre tagaríóge inawire. ");
INSERT INTO awb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ite íre tagaríóge ínaq itega wensabé, Arereq moráráq táhutahururauna wino. Arega iteruwahpeq íwáhnorurona wino irana ");
INSERT INTO awb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","wega itensabé, Itewe íre tagaríóge. Ite eheqte kébo? Ite moke ahbabáq ke puaq íné nueq pokoro aitanawire. ");
INSERT INTO awb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ébáráhmareq Áhísáhkireq Sékópareq moke Manikáne ehweh iraru kereqka Manikánka wahnah wahnahnirabeq míéhraq tagéq peh máhpeq míéhra puaq uwo uwo éq abuyoraneheqmóe. ");
INSERT INTO awb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Íó kiembogirabeqte kéreq íó tupekirabeqte kéreq ébeq ayópéqté mó ébeq ayópéqté kéreqka sure Manikánka wahnah wahnahnirabeq tútuue méra táhutahurigehe. ");
INSERT INTO awb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Írátíáhro. Amahnága anotah ke ebeq míáh kéwé mókake Manikánka wahnah wahnahnirabeq anehepeq pehgáriq ke úkoneherawoe. Amahnága anehepeqte kégá ebeq anotah ke úkigehe. ");
INSERT INTO awb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mi tanáhráq Péhrasi kegá Sísaba séra wensabé, Érótiga are subiq suaníe íwíáhinsabé mahtaq sue pokúno uwana ");
INSERT INTO awb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sísaga sensabé, Mi urínsí íá táhnsá ánínsábé koreaweq mahrarero. Iborankákáq ahbiahakáq owainawamarí kaqsuena awahre ke kaweraritaníe. Apahtáróráq néne arambehri parabaruaníe. ");
INSERT INTO awb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Manikáne ehweh iraru ke peh morá Sarúsarama suwahpeq míówara subiqmaq subiqmaruwara puku pukuuwe. Íné moq Manikáne ehweh iraru anínéna iborankákáq ahbiahakáq ahrinaakáq ínéga iwíáhu ahtápéq pokue arambehrinauge. ");
INSERT INTO awb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sarúsarama suwahpeqte kéo, itensabé nirutaboiraitóge. Itega Manikáne ehweh iraru ke subiq sueq Manikánka iteba eqmaro ke ebahnsatate subiq súówe. Kokórega wene áráhqmari arutaboiréna ahwirinserah áhnte tanáhráq ite wahnahnue séhréh aiteyabe nuwahbehraqme itega ahqáho aintáhwe. ");
INSERT INTO awb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Írátíáhro. Ahqáho aintáhnsábé iteruwahpeqme mókake íre kaweraitahnana peh susa náh kanae. Teiníboq írátíáhro. Mókake itega íné pehipi íre tagagehe. Ebeqme mahraréq, Itene Wahnahne áwírue sína anínsábé iwíáh íwíáh atone éq anehe íné tagagehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ahrena ahrena wehekáh Sísaga Péhrasi wahnáh áníné nahtapeq táhutahurinieéna pokúwara mibeqté kégá we awahnkanuwe. ");
INSERT INTO awb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wene aiayah mu anínká weba míowana ");
INSERT INTO awb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sísaga mi aní tagéna Mósísine ehweh síwáhnoro kereq Péhrasi kereqsabé kasenéna, Ahrena ahrena wehekáh awahre ke kaweraritewé kaweq sansápo úwe. ");
INSERT INTO awb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Úwara íre ehwehnia peh ehiya míówana Sísaga mi awáhré ání kaweratena eqmarowe. ");
INSERT INTO awb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eqmarena míó keyabé mahraréna, Ahrena ahrena wehekáh itene anipópoq póéráhqpópoq mataipéq tupetiahnaraqmé mi wehekáh pankeqme meruaneherabo kasenúwe. ");
INSERT INTO awb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kasenúwara íre teawasa peh ehiya míówe. ");
INSERT INTO awb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Táhmaro táhutahuroneherao kegá kabaréra kaweqtapéq eheq tútuue míanehnkono uwana Sísaga mina tagéna mah pabéqmé éhwéh teriuwe. ");
INSERT INTO awb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Teriena mó anínká arensabé, Máho ínahwe arega anotah tahutáhúrirarabeq pokirataq anotah weh tútuue míéhrarabeq íre tútuue míahno. Arensabé máho urai anínká mó aní are kiotaiqme anínsábé máho urairamo. ");
INSERT INTO awb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Anotah anínká sínaraq máho urai anínká arensabé, Móbeq míahno. Mó anínká mahtaq tútuue míankehe ínaraq are anotah ayéhítanawire. ");
INSERT INTO awb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Arensabé máho ínaraq ayehrápéq korútuue míahno. Miraínaraq arensabé máho urai anínká tagéna arensabé, Irigue mahbeq kaweqtapéq serútuue míahno atanae. Wega miraínaraq tagehra kegá arensabé iwíáh íwíáh atagéhe. ");
INSERT INTO awb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wewega, Íné anotah aní múge íwíáhínaraqmé Maniká Iteriboga wensabé, Pehgáriq aní míahno atankéhe. Wewega, Íné pehgáriq aní tahnsa míanie íwíáhínaraqmé Maniká Iteriboga wensabé, Anotah aní míahno atankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sísaga máho ato aninsábé mahraréna, Arega anotah tahutáhúq kaweraréhna tanáhráq peh morá arene iyahnabo arenawahrah áhnte monéákáq kéyábé máhoro íre úno. Mó tanáhráq sega arensabé, Máho atera táhutahuq náwigéhe. Mina tahnsanue arene ápeq meyankéhe. ");
INSERT INTO awb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Arega anotah tahutáhúq kaweraréhna tanáhráq tabonah kereq sawenkahnia kéreq aigárá soriqnah kereq aura pira kéreqsabé máhoro arito. ");
INSERT INTO awb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sega are mó naneq íre náweráho puara Manikánka kaweróne atankéhe. Mókake wega kaweqtaq míáh ké iriritahna tanáhráq ápeq awinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sísareq moráráq táhutahurú aninká mi ehwéh irena wensabé, Manikánka wahnah wahnahnirabeq táhutahurira kewé sirupipeq áhnte eyóyó aginkehe úwana ");
INSERT INTO awb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sísaga wensabé pabeqme ehwéh mahraréna, Wehga íregáritaq wehekéq kiraboinieéna áhnte tahutáhúq kawerataire. Kaweraréna mi keyábé, Máhoro uraire. ");
INSERT INTO awb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Awehraq tanahráqmé wene arambehri aní teawena máhoro urau keyábé, Táhutahuq tanáhráqmé aiq awehraq mire. Amahnága máhoro korerio éna eqmataire. ");
INSERT INTO awb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Eqmatairana, Máhoro urairara íre serahúne éhwéh mó anínká mó anínkáue teawátówe. Mó anínká wensabé, Marakó paiqmataunsabé mina koraganau puana íre korahuge urairana ");
INSERT INTO awb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","mó anínká wensabé, Íné arambehriéyabe inayáhnkú káho paiqmataunsábé mi kamárí áhwárawe taganau puana íre korahuge urairana ");
INSERT INTO awb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","mó anínká wensabé, Íné ahre meyó púana íre korahuge uraire. ");
INSERT INTO awb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mi arámbéhrí ánínká kouwekue sene ehweh wene wahnah teawátáirana anotah abíáhnsánuraire. Anotah abíáhnsánéna wensabé, Anotah ahtápéqkákáq pehgáriq ahtápéqkákáq peheráh pokue tabonah kereq sawenkahnia kéreq aura pira kéreq soriqnah kereq koweriqme súno uraire. ");
INSERT INTO awb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Urairana wene arambehri anínká miraéna kouwekéna wene wahnahnsabé, Aiq miraugarawe sira kewé íre awehraq míáhwe urairana ");
INSERT INTO awb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","wene wahnahnka wensabé, Néne táhutahuq áhnte nagehboq sotápéqkákáq tanahraipéqkákáq wehuke kogabarue koweriqme súno. ");
INSERT INTO awb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Teiníboq írátíáhro. Téh máhoro urau kegá néne táhutahuq pehgáriq naneq íre naneherawoe uraire úwe. ");
INSERT INTO awb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sísaga pokúwara peh íregáritaq kegá kérówana wega pabeqme sensabé, ");
INSERT INTO awb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Wehukega íné pehipi íre séniragéhe. Wenanoiboreq wene ahrereq wene animárínseq wenábáqmarinseq wenanahnorehreq suahnaraqmé íné sénirankéhe. Wewe awahbeh iwíáh suahnaraqmé íné séníréh ání míankehe. ");
INSERT INTO awb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nánibone arambehri miraunsabé íné awankátaq táhpawe nubiq suagéhe. Ínéga miraunserah miraue séníráhro. Minayabe néne arambehriraq túbáh agéna peh we awahbeh arámbéhrí sehgí ánímé né séníréh ání íre míahrahire. ");
INSERT INTO awb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nah pianaína anínká ebeqme iwíáhue tagankehe. Nah pe naneqmarínkákáq wene móneakáq awehraq kahnaraqmé anehe pearankéhe. ");
INSERT INTO awb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ebeq íre iwíáhi anínká nahwiahnsanse pearena anehe néne móneakáq íre awehraq kéhre éna mi nah íre pera suankéhe. Tagehra kegá susa náhwíáhnsánsé tagéra mi anínsábé awiréh atera, ");
INSERT INTO awb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wega áhwáreh arámbéhrí íre parabaruahráhire oneherawoe. ");
INSERT INTO awb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wahnah anínká mó wahnáh ánínseq wene ebeh kereq ebehue subiq suanéhe íwíáhéna ebeq tútuue ména kawerue iwíáhinkehe. We peh 10 táhúséni (10,000) ebehira ke míéhrataq wene naruo peh íregáritaq 20 táhúséni (20,000) ebehira ke míéhrataq kaweq iwíáhi wahnáhnká íre apubúue koebehinkehe. ");
INSERT INTO awb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Itene naruo íre subipáhraruahráhúne íwíáhinaraqmé sene naruo míéhrataq ahnsaní eqmarankéhe. Itega íre ebehoneheqmúne. Kaweqtaq míanehboq póqsuanéhe terio éna eqmarankéhe. ");
INSERT INTO awb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mina inserah íné séniraníe íwíáhóna anínká ebeqme iwíáhue tagankehe. Peh morá wewene matíéh náneqsabé, Anetaníbo moke suaníe íwíáhi anínká íné séníréh ání míankehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sísaga mó mahraréna, Sóreqme kaweq nanere. Sóreq auqmah úkínaraq árahue kaweraranéhnkono? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Auqmah soréqmé peh abehq úki puaq sotápéq kíréh náneq íre séhréh atahráhire. Sotápéq kawerue kirankéhboq seqkákáq auqmah soréq ayahnue sotápéq maranéhnkono? Írakaumo. Auqmah soréq peh máhpeq suaneheqmúne. Minayabe iahreakaq ké kawerue íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Táhkísi moné meyáh kéreq ahbabáq kereqka Sísane ehweh iraneheéra weba suwara ");
INSERT INTO awb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Péhrasi kereq Mósísine ehweh síwáhnoro kereqka ehmuniq éhmúníréra, Mah anínká ahbabáq sansano ke mehweh aritena sereq moráráq táhutahurire uwe. ");
INSERT INTO awb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Uwana Sísaga mi ehwéh irena mah pabéqmé éhwéh mahraréna, ");
INSERT INTO awb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Iteruwahrah anínká áhnte ka 100 sipísípíq wahnahnirana peh morá ká tabanagínaraq wega anerinabo? Wega íre tabanago kamárí 99 sipísípíq uwaruntú sahtaqme nahrabeq sitena tabanagi ka kogabarue ábóraq marankéhe. ");
INSERT INTO awb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ábóraq marahneyabé iwíáh íwíáhéna mi ka sawiwena ");
INSERT INTO awb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","wene nahtapeq pokue wenawahrahreq wene iyahnaboreqsabé síáhrabue sensabé, Néne tabanagi ka ábóraq marónsábé iwíáh íwíáhonehe inkehe. ");
INSERT INTO awb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mina inserah íópeqté kégá 99 kaweqtaq míáh kéyábé peh ákáhtaq iwíáh íwíáhowe. Peh morá áhbábáq ánínká wene ahbabáq suena Manikáne ani ukítaq íópeqté kégá anotahtaq iwíáh íwíáhowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sísaga mó pabeqme ehwéh mahraréna, Mó inínká nayáhnkú móné matíéhrana peh morá móné tabanagínaraq wega anerinabo? Wega áráhmu keqmarena nahupeq kabantáhinkéhe. Kawerue kabarue ábóraq marankéhe. ");
INSERT INTO awb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ábóraq marena wenawahrahreq wene iyahnaboreqsabé síáhrabue sensabé, Tabanagi moné ábóraq marónsábé iwíáh íwíáhonehe inkehe. ");
INSERT INTO awb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mina inserah peh morá áhbábáq ánínká wene ahbabáq suena Manikáne ani ukínaraq Maniká míéhrabeqte íópeqté kégá ahbabáq súéh ánínsábé anotahtaq iwíáh íwíáhigehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sísaga mó mahraréna, Peh morá wéhreq wene ahninkáwáráréreq míarowe. ");
INSERT INTO awb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ábákawagá wenabonsabé, Nániboo, amahnága arene ménsámehnsá saraqme náio urairana sibowágá wene ménsámehnsá saraqme náríátáire. ");
INSERT INTO awb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Náríátáirana ábákawagá táhmaroraq mitaq ména wene ménsámehnsá sokah sokahue íre wahto wáhnaupéqté ké suwahpeq pokéna mitaq míaraitaq wega ahbabáq sansa mira aruqarurainsabé wene móne apubúue parabaguraire. ");
INSERT INTO awb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","We tabonah ani ukurairana mitaq anotah ehwéhrarairana we arupibiuraire. ");
INSERT INTO awb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Arupibiurainsabé wega mibeqté áníné arambehri aní úkurairana wene wahnahnka, Uworapeq néne póéráhqtaq kowahnahnúno atáráire. ");
INSERT INTO awb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","We áhnte arúpíbíurairana póéráhqka narotaq sene táhutahuq nahrahurairara mó kegá we íre náwátówe. ");
INSERT INTO awb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Minayabe wene múguwahgu iwíáh suena tábúsoqme iwíáhéna, Nánibone arambehrio ke áhnte topáh kéhranawe íné mahtaq nirupinsabé pukorahuge. ");
INSERT INTO awb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Íné mahtaq suena nánuwahpeq pokue nánibonsabé mahrarinie. Nániboo, ahbabárurautaq arereq Manikánseq ahbabáraitáráuge. ");
INSERT INTO awb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ahbabáraitáráunsabé mókakewe ínénsabe, Nénahnine íre ainto. Peh arene arambehri aní míankeheé arambehriúno ainto teawiníe éna ");
INSERT INTO awb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","mitaq suena wenaboba pokuraire. We áhníbórá suraitaq wenaboga tagéna arutaboirue pehbeheráh weba kure kogáhkoue nánkóqnarairana ");
INSERT INTO awb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","wenahninká wensabé, Nániboo, ahbabárurautaq arereq Manikánseq ahbabáraitáráuge. Mókakewe ínénsabe, Nénahnine íre ainto uraire. ");
INSERT INTO awb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Urairana abowágá wene arambehrio keyábé síáhrabéna sensabé, Kaweq káhq ambántá apubúue mewe suki atáhro. Wene ayahnkarapí kera suki ateq wene aigárápí súu suki atáhro. ");
INSERT INTO awb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kaweq kaho áráhq subiqme moráráq táhutahuréq iwíáh íwíáhonehe. ");
INSERT INTO awb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nénahni pukuraime amahnága oga míéhre. We taqnobaguraime amahnága ábóraq míéh púaq iwíáh íwíáhonehe uraire. Sega táhutahuq kawerarera iwíáh íwíáhurowe. ");
INSERT INTO awb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Iwíáh íwíáhurowana awahwágá wene sotápéqté séna ábáhruro irena ");
INSERT INTO awb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","arambehri anínsábé, Aneroo kasenuraire. ");
INSERT INTO awb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kasenurairana, Arenábáq séna awaho ani míéhnsábé arenaboga káho áráhq subiqme nanehe uraire. ");
INSERT INTO awb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Urairana awahwágá anotah abíáhnsánéna nahupeq íre kibekurairana wenaboga tueyokue wensabé, Máho ue áhrabéna, Aru ukiqmewé kiinsahwé aito uraire. ");
INSERT INTO awb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Urairana awahwágá wenabonsabé, Ínéwé áhnte opéq arene arambehri mira aruqaruruge. Arene ehweh íre anterutauge. Ínéreq néne iyahnaboreqka ábáhrigeheé arega méme áráhqmé íre níátóne. ");
INSERT INTO awb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Arenahninká ahbabáq ininsónseq arene ménsámehnsá parabaruena sirah arega káho áráhq subiqme náwene uraire. ");
INSERT INTO awb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Urairana abowágá wensabé, Are nénahni móne. Arereq ínéreq moráráq mía míaúye. Moke matíó ménsáméhnsámé areneákáq matioye. ");
INSERT INTO awb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Arenábáq pukuraime amahnága oga míéhre. We taqnobaguraime amahnága ábóraq míéh púaq itega iwíáh íwíáhue ábáhrúnawe ábérehre uraire úwe. ");
INSERT INTO awb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sísaga we kéró keyabé mó pabéqmé éhwéh mahraréna, Áhnte monéákáq wéhné ménsámehnsátaq arambehri anínká auráq átáríaraire. Átáríarairara mó kegá wene wahnahnsabé, Arene arambehri anínká íre kawerue wahnahnire urowe. Urowana wene wahnahnka irena ");
INSERT INTO awb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","mi anínsábé áhrabue kasenéna, Arene áhwára áhwára sansánsábé teniémé aiq pútaq ehwéhpo? Tenio. Arega néne ménsámehnsá moke kawerare mókake minawari íre wahnahninkehe uraire. ");
INSERT INTO awb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Urairana mi anínká wewe náhenéna, Néne wahnahnka kaqnuahnaraqmé aneq arámbéhrí ininkono? Íné nonáwehq ube arámbéhrí íre miraorahuge. Móneyabé ineh ineheyabé áhnte niyehitehre. ");
INSERT INTO awb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Íné iwíáhume tínáhuakáq kégá néne iyahnabo úkigehboq sene tínáhu maratarinie. Miraonaraqmé mókake néne arambehri íre kahnaraq sega íné mehweh aintera sene nahtapeq máho aintera kirabo aintagéhe íwíáhuraire. ");
INSERT INTO awb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wega mira íwíáhéna tínáhuakáq ké síáhrabéna ebeq surai anínsábé, Néne wahnahne tínáhuue árahue kehro uraire. ");
INSERT INTO awb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Árahue kehro urairana, Obenkisa óéri antéhyá 100 antéhyá merauge urairana, Mah pepáhqtáq mahraue sehiranúno éna ínéga 50 obenkisa óéri antéhyá awinauge ue sehiranúno teawátáire. ");
INSERT INTO awb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Anehe surai anínsábé, Néne wahnahne tínáhue árahue kehro urairana, Wítiwe 100 ambékí merauge urairana, Mah pepáhqtáq mahraue sehiranúno éna ínéga wítiwe 80 ambékí awinauge ue sehiranúno teawátáire. ");
INSERT INTO awb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Wega mina tahnsa urainsabé wene wahnahnka wensabé iwíáh íwíáhéna, We ahtebia áníne uraire. Mah marákóípéqté kégá mah marákóípéqté sánsá aiq ahtebahwe. Minayabe ménsámehnsá paiqmaráhnsábé sene sánsánká téhrehrabeq nogó kéné sánsá kiotaikowe. ");
INSERT INTO awb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Teiníboq írátíáhro. Áhnte ke itene iyahnabo míagehboq mah marákóípéqté ménsáméhnsá náríéro. Mina parabagína tanáhráq oga mérapeq sega mitaq mehweh aitagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sísaga we kéró keyabé mó mahraréna, Pehgáriq arámbéhrí kawerue mirai anínká anotah arámbéhrí moq kawerue mirainkehe. Pehgáriq naneq pehipi meyéh ánínká anotah naneq moq aebóorahire. ");
INSERT INTO awb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Arega mah marákóípéqté ménsáméhnsá íre kawerue wahnahninaraqmé árahue oga mía mía arámbéhrí mirainibo? ");
INSERT INTO awb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mó aníné ménsámehnsá íre kawerue wahnahninaraqmé arega wahnahninkeheéna insega ménsámehnsá airaiq awinkéhbo úwe. ");
INSERT INTO awb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sísaga mó mahraréna, Arambehri anínká téhtaré wáhnáhné arambehri íre moráráq sehgioráhire. Wega mó wahnáhnsábé awahbéna mó wahnáhnsábé íre awahbanae. Wega mó wahnáhné arambehri kawerue sehgiena mó wahnáhné arambehri áhwára áhwárainae. Mina inserah itega Manikánsabe irutaboiro sansánkákáq móneyabé irutaboiro sansánkákáq íre moráráq sehgioráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sísaga mah ehwéh mahrarúwara Péhrasi kegá irera móneyabé sirutaboiro puara wensabé awiréh atáhwe. ");
INSERT INTO awb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Awiréh atáhwana wega sensabé, Mó kegá, Ite kaweq ke wóe aitageheéra arambehriowe. Manikánka itene kopípéq irupipeqté íwíáh tagaríéhre. Wehukega iwíáh íwíáh atáh náneqme Manikánka mi naneqsabé abehq náneq mire atéhre. ");
INSERT INTO awb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Wání meri merini aní Sóniga íre sútaq Mósísine ehwehnkakáq Manikáne ehweh iraru kené ehwehnkakáq kowe. Kowana Sóniga suraitaq Manikánka wahnah wahnahnirabeqte kaweq ehwéh tei teinúne. Teinúnara ómi kegá págegeue mitaq kioráhúne íwíáhowe. ");
INSERT INTO awb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Íópeqkákáq mah marákó márákóákáq mókake tabanaginae. Peh Manikánka sehgioro i ehwéhmé mi ehwéh pehgáriq íre tabanagorahire. ");
INSERT INTO awb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wene ahre kaqsuena mó ahré meyéh ánínká aiq ahbabárire. Sutai ahré meyéh ánínká moq ahbabárire úwe. ");
INSERT INTO awb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sísaga Péhrasi keyábé mó mahraréna, Menah áhnte mensáméhnsánkákáq wéhgá kaweq ambántámárí aneranerue ména ahriahri kaweq tahutáhúq naruq narururaire. ");
INSERT INTO awb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wega miraurairana tabonah náonkakáq ání wenáwíq Árásárúsi áhnte mensáméhnsánkákáq wéhné ogesáh ogesáhrapeq tútuue ména ");
INSERT INTO awb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","mi wehné táhutahuq apipi nanieéna mitaq míarairana iamárínká séra wene náo wana wananurowe. ");
INSERT INTO awb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tabonah ani pukurairara íópeqté kégá wenawa meqmera Maniká míéhrabeqte aní Ébáráhmaba móátárówana áhnte mensáméhnsánkákáq wéh moq pukurairara maisiarówe. ");
INSERT INTO awb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Maisarówana wenawanka iraipéq ména anotah erurairana kamahuraire. Wega senahpeq tagarairara íre wahtopeq irerebeq Ébáráhmareq Árásárúsireq moráráq míaroyana tagaraire. ");
INSERT INTO awb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tagéna Ébáráhmansabé áwíahraqséna, Ébáráhma nániboo, ínénsabe arutaboirainte Árásárúsi eqmarehnana wene ayahnkara wánípipeq pámbáhue ninehbíraq tabaintahnana titiríno. Mah iráípéq anotahtaq níérire uraire. ");
INSERT INTO awb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Níérire urairana Ébáráhmaga wensabé, Náníbáre. Are oga míarona tanáhráqmé áhnte kawéq náneqkakáq míaronana Árásárúsi tabonah ani míaraire. Minayabe iwíáhue tagáhno. Amahnága we mahtaq kaweqtaq míéhrah arewe mitaq kamahóne. ");
INSERT INTO awb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Móme ite ákáhpi mentú kéhnsábé mahbeqté kégá mibeq íre tuoráhúnara mibeqté kégá mahbeq íre kioráhowe uraire. ");
INSERT INTO awb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Urairana wega Ébáráhmansabé, Nániboo, Árásárúsi nánibone nahtapeq eqmaro. ");
INSERT INTO awb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mitaq náníbáqmari moberíáh míáhwe. Mah iráípéq anotah érirabeq se moq siyehboq Árásárúsiga sensabé, Itene ahbabáq sansa sueq kaweqtaq mía míaoro korerinkéhe uraire. ");
INSERT INTO awb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Urairana Ébáráhmaga wensabé, Sega Mósísireq Manikáne ehweh iraru kereqne ehweh matíáhwe. Mina iragéhe uraire. ");
INSERT INTO awb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Urairana, Ahqáho. Sega mina íre iragéhe. Pukia anínká oganúkéna korerinaraqmé se irera sene ahbabáq sansa suaneherawoe uraire. ");
INSERT INTO awb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Urairana Ébáráhmaga wensabé, Sega Mósísireq Manikáne ehweh iraru kereqne ehweh anetaníbo íwíáhirataqmé pukia ánínká oganúkéna terinaraq sega wene ehwehnsabé moq anetaníbo íwíáhéra kaweq ke íre ukoneherawoe uraire úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sísaga we kéró keyabé mahraréna, Síúgio kewé anotah ahbábárowe. Mah marákó márákóípéq ahbabárorahi sansá peh kagaire. Áúgii anímé ahbabáq áhwáreh puana Manikánka anotahtaq kamah awinawire. ");
INSERT INTO awb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wehukenínká ínénsabe aiq pútare aintéh ání ahbabáq sansa áúgi ínaraqmé anotahtaq íre kawerire. Áúgii anínká káriq aní áúgi ínaraqmé wene anuopi anotah ebáh táhru táhruue púrúrúia káwéhúpípéq tuparuahnana wánípipeq tupekitaq tahirímé aiq kaweri irino. Iteite kawerurero úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sísaga mó mahraréna, Arene iyahnabo anínká ahbabárínaraq ehweh ato. Ehweh atéhnaraq wega arensabé, Íre kaweruge. Móme íre mirainie ínaraqmé insahwé ate wene ahbabáqsabe mó íre iwíáhúno. ");
INSERT INTO awb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wega peh morá wéhékáh abapete téhtaré tánáhráq are ahbabárue ue anehe wega, Íre kaweruge. Mi ahbábáq suaníe ínaraqmé wene ehwehnsabé aiq pútare ate wene ahbabáqsabe íre iwíáhúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","We kéró kega Sísansabé, Itega kaweqtaq aiq pútare atanéhboq séhréh aito uwe. ");
INSERT INTO awb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Séhréh aito uwana wega sensabé, Arene iwíáhwé awanká ayu pehgáriq ayú tahnsa kahnaraq itega anotah awánkánsábé, Are sawikue móbeq sóreq waní káwehupípéq kogahno irataq mi awánkánká itene ehweh sehginawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sísaga mó mahraréna, Wahnah korégá wene arambehri anínsábé, Néne sipisípiqtaq wahnahnúno anehe néne sotápéq koarambehriúno atéhrana tupekinaínara wega sotápéqté árámbéhrí suena wene wahnahne nahtapeq sinae. Wene wahnahnka wensabé, Aiq míre. Sewe náhno inabo? ");
INSERT INTO awb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Írakaumo. Wahnah korégá wensabé, Néne táhutahuq tíare tahberapeq mewe ménánio éna ínéga nawe parabarúáhnaraq arene táhutahuq nankehe inae. ");
INSERT INTO awb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Minawé peh arambehri aniné arambehri puana wega miraitaq wahnah korégá kaweróne inabo? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mina inserah Maniká itene Wahnahne ehweh sehgíóro. Kawerue sehgieq parabarueq iwíáhéq ite íre kaweq arámbéhríúna anímárí múne. Itega miraúnawe peh itene arambehri wire oro úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sísaga Sarúsarama suwahpeq pokinaútaq wega Sámáría marákóákáq kótaikue Kehrari marákóákáq kótaikue ");
INSERT INTO awb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","mó ke suwahpeq kúwara inayáhnkú ké anotah naonkákáq kégá weba suwe. Mó ke insoq sitéhneho éra sega móbeq iriwe méra ");
INSERT INTO awb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","áhrabéra, Sísao, are anotah aní móne. Arutaboiraito uwana ");
INSERT INTO awb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sísaga se tagéna sensabé, Manikáne ehweh mibeq mahbeq arítáh kébá pokue itene náo kaweraginsabé sokigi aríéro úwara pokue ahtapeq kutaq sene náo kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Peh morá ánínká wene náo kaweragú tagéna kouwekue Manikánsabe anotahtaq iwíáh íwíáh atena ");
INSERT INTO awb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sísane aigárápí abiah maraipérue káúqmunue iwíáh íwíáh atena kaweróne atowe. Mi anímé íre Asiu aníne. We Sámáría marákórápéqté áníne. ");
INSERT INTO awb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sísaga we kasenéna, Inayáhnkú kaweraitóge. Mó abapete itaréitaré ánímárí eheq míaho? ");
INSERT INTO awb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aneqsabé peh morá wáhnaupéqté ánínká kouwekéna Manikánsabe iwíáh íwíáh atehro éna ");
INSERT INTO awb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","wensabé, Irigue pokúno. Aiq pútare aintahnaga kaweratéhre úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Péhrasi kegá Sísaba séra wensabé, Manikánka wahnah wahnahnína tanáhráq ahkake sinabo uwana wega sensabé, Manikánka wahnah wahnahnína tanáhráq wehukega siuratate íre tagahrahowe. ");
INSERT INTO awb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wehukega, Mahtaq kéhre. Mitaq kéhre íre irarerahowe. Manikánka wahnah wahnahnime amahnága ite míáhrabeq ábórarire úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sísaga we kéró keyabé mó mahraréna, Mókake itega íné wehukení úku aní túóna tanáhráq níwénunue irutaboiréq íre tagagehe. ");
INSERT INTO awb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mi tanáhráq sinaínaraq mó kegá, Mitaq koragahro. Mahtaq seragahro teírataq sene ehweh íre aiq pútare arítáhro. ");
INSERT INTO awb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sokeqsúéhrana apubúue moke íópeq téhrehnserah íné wehukení úku aní túóna tanáhráq tuinauge. ");
INSERT INTO awb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Téhwe mah tanáhráq wahnahno kegá ínénsabe, Iuwahriehre aintera kamah aniera nubiq suagéhe. ");
INSERT INTO awb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Naho naho Nóah mío tanáhráq wehukega ahbabáréra miraunserah íné wehukení úku anínká tuinie onaraq mi tanáhráq oga míéhra kegá miraigehe. ");
INSERT INTO awb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Anotah waní pianaú tanahráq wehukega ahbabáréra ahriahri miraunserahnéra táhutahuréra ábáhréra pahuiruwana Nóahga wene sípiipéq kibekúwana anotah ibónsúwana wání pionka moke subipáhraruowe. ");
INSERT INTO awb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mó aní wenáwíq Árótae. We wáhnaupéqté ké suwahpeq Sóróma suwahpeq míotaq mi kegá íre irasa ké méra táhutahuréra paiqnanánéra ayu uqmarera nah pearówana ");
INSERT INTO awb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","wega mitaq suena pokútaq íópeqté irobina tuwara mi ke moke tabikue pukuwe. ");
INSERT INTO awb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mina unserah íné wehukení úku anínká tuinaona tanáhráq wehukega táhutahuréra seyene arambehri miraéra ahwiminirataq tuinauge. ");
INSERT INTO awb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mi tanáhráq sinaraq máhpeq míéhrataq itene ménsámehnsá meyaneheéq nahupeq kibekiyeho. Mina inserah sotápéq míéhrataq itene nahtapeq kouwekiyeho. ");
INSERT INTO awb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Manikánka Árótane ahre kamah awunsabe ahreraq matíáhro. ");
INSERT INTO awb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wehukenínká peh wewensabé arutaboiréna peh wewe awahbeh iwíáh mira aruqaruri anímé oga mérapeq íre awaq miahráhire. We awahbeh iwíáh suqsuri anímé oga mérapeq awaq miankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sísaga mó mahraréna, Íne wehukení úku anínká túónaraq mi tanáhráq inokáhpeq téhraníté morá máhríqtáq sugéhrataq Manikánka mó aní merena mó aní mitaq auwanae. ");
INSERT INTO awb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Téhrinítégá aboyanirataq mó iní merena mó iní mitaq auwanae. ");
INSERT INTO awb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Téhtaré wéhgá sotapéq arampehrirataq mó weh merena mó weh mitaq auwanae úwe. ");
INSERT INTO awb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Úwara we kéró kega wene ehweh irera Sísansabé, Itene Wahnahno, eheqpo uwana wega sensabé, Pusa káné anonka kéhrabeq kúqnumarinká ínsínsíowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sísaga we kéró kega púreré sansansábé anetaníbo íwíáhéq túbáh agiyehboq peh ahriahri púrerigeheéna mah pabéqmé éhwéhmé teriuwe. ");
INSERT INTO awb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mó kené koti ehwéh iwíáhue irena sene koti kawerarítéh wéhgá wenawahpeq ména Manikánsabe íre áhreia mó keyábé íre iwíáh íwíáhuraire. ");
INSERT INTO awb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mi ke suwahpeq kéweiní ména mi wehbá séyééna wensabé, Níwíoqneh aní túbáh aginkehboq ehweh ato teawa teawanuraire. ");
INSERT INTO awb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Téh séyéuraitaq mi weh ánínká wene ehweh íre irena ahqáho atáráire. Anehemé wega mó iwíáhéna, Ínéwé Manikánsabe íre áhreia wehukeyabé íre iwíáh íwíáhuge. ");
INSERT INTO awb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Peh mi inínká ínéba séyééna pagu pagu aintéhnsábé wene ehweh sehginíe. Íre sehgiónaraq wega mó séyééna pagu pagu aintahnaraq nuwahqsoreqninae uraire úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sísaga mó mahraréna, Mi wehgá íre kaweqtaq ména mi iwíáhuraime íráhro. ");
INSERT INTO awb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wega miraurainsabé Maniká tagaríáh kégá ahriahri púreq aruqarurirataq Manikánka íre séhréh aritanabo? Wega íre wahto tanáhráq peh túbáh aginabo? Írakaumo. ");
INSERT INTO awb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Teiníboq írátíáhro. Wega se apubúue séhréh aritanae. Íné wehukení úku anínká mah marákóípéq kiwekona tanahráq mah kegá ínénsabe aiq pútare aintaneherabomo úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mó kegá iwíáhéra, Itebataq kaweq ke míone éq, Mó keyábé iuwahriehre uwana Sísaga mah pabéqmé éhwéh mi ke teriuwe. ");
INSERT INTO awb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Péhrasi anínká púrerinieéna Manikánsabe iwíáh íwíáh atáh náhtápéq kirairana táhkísi moné merai anínká moq púrerinieéna mitaq kiraire. ");
INSERT INTO awb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Péhrasi anínká iriwe ména wewensabé iwíáh íwíáhéna mahraréna, Manikáno, íné mó ke tahnsa ání íre míónsábé arensabé iwíáh íwíáh atóge. Ínéga aebówé, ahbabáqmé, mó kené ahre abariéwé íre mirau aní múge. Íné íre mahna táhkísi moné meyéh ání tahnsa ání múge. ");
INSERT INTO awb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ínéga mó wikíráq mó wikírárue arensabé iwíáhéna téhtaré wéhékáh táhutahuq awehriuge. Moke meyó náneqme saraqme abapete itaréitaré matawéna mó morá are náwa náwanuge uraire. ");
INSERT INTO awb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Péhrasi anínká mahna tahnsa púrerurairana táhkísi moné meyéh ánínká móbeq iriwe ména wene ahbabáqsabe ayehitarairana ibiséna aura marakóiperurawéna púreréna, Manikáno, íné ahbabáq ani míónsábé arutaboirainte kawerainto uraire. ");
INSERT INTO awb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sísaga mó mahraréna, Teiníboq írátíáhro. Manikánka táhkísi moné merai aní kaweratáráirana wene nahtapeq pokéna kaweqtaq míarairana Manikánka mó aní peh áwé tagarairana wene ahbabáqkakaq mewena pokuraire. Aneqsabébo? Wewensabé iwíáh íwíáhi anímé Manikánka mi anínsábé, Pehgáriq aní míahno atankéhe. Íné pehgáriq aní múge íwíáhi anímé Manikánka mi anínsábé, Anotah aní míahno atankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sísaga káriq anímárí táhtorankeheéra mó kegá meriqmera mórítówara we kéró kega mórító keyabé suwehgu aritera ahqáho arítówe. ");
INSERT INTO awb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ahqáho arítówana Sísaga mi karíq ánímárínsábé, Máhoro éna we kéró keyabé, Mah karíq ánímárí ínéba sewíagehboq ahqáho arítého. Sega mira onserahno kegá Manikánka wahnah wahnahnirabeq awaq miagéhe. ");
INSERT INTO awb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Teiníboq írátíáhro. Mah karíq ánímárínká Manikánka wahnah wahnahnirabeqsabé sirutaboirowe. Peh morá sega mira onserahno kegá mibeq kioráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wahnah anínká Sísansabé, Íwáhnoraníno, arewe kaweq aní míahne. Oga mérapeq awaq mianíboq anerininkono úwana ");
INSERT INTO awb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sísaga wensabé, Aneqsabé kaweq aníne aintahno? Maniká webataq kaweqtaq mía míaire. ");
INSERT INTO awb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sehgíóro ú ehwehmé aiq ahtebáhne. Mi ehwéhnká mahraréna, Mó aníné ahre weh abariiyeho. Mó aní subiq súého. Aebóiyeho. Mó keyábé péhe éhwéh arítého. Iteinoibone ehweh ireq se séhréh arítáhro ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Úwana mi anínká Sísansabé, Káriq aní míarautaqkákáq amahnágaákáq mi ehwéh sehgíúge úwana ");
INSERT INTO awb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sísaga mi ehwéh irena wensabé, Peh morá náneq íre miraóne. Moke matiahna mensáméhnsá paiqmaqme móne mewe tabonah ke nário. Mirainaraqmé íópeq kaweq naneqmarí matiankehe. Tabonah ke moke nárie íné séniro úwana ");
INSERT INTO awb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","mi anínká irena áhnte mensáméhnsá ko púana wene arupipeq umeh agúwe. ");
INSERT INTO awb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sísaga mi weh tagéna mahraréna, Áhnte mensáméhnsá matíáh kégá Manikánka wahnah wahnahnirabeq kieyabe anotah pagégéue mirao naneq mire. ");
INSERT INTO awb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kéhma anotah kane. Mi kanká wai abahrabahpipéq kéagínayabé págegeue mirai naneq mire. Mina inserah áhnte mensáméhnsá matíéh ánínká Manikánka wahnah wahnahnirabeq kinayabé anotah pagégéue mirai naneq mire úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Úwara író kega kasenéra, Minayabe insega oga mérapeq awaq miahráhiro ue kasenuwana ");
INSERT INTO awb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sísaga sensabé, Wehukega íre miraoraho naneq Manikánka miraorahire úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pítaga wensabé, Iteruwahpeqkakáq moke mationa naneqkakáq sueq kérone úwana ");
INSERT INTO awb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sísaga sensabé, Teiníboq írátíáhro. Manikánka wahnah wahnahnirabeqte árámbéhrí miraoneheéra sene nah súáhmé amahnága áhnte mó nahmárí awaq miagéhe. Mi arámbéhrí miraoneheéra sene ahreromé, sensibáqmarimé, sensinoibowe, sene animárímé súáhmé ");
INSERT INTO awb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","áhnte mó kegá sensuwahrah úkigehe. Mókake oga mérapeq moq awaq miagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sísaga moke we kéró ke móbeq sitena sensabé, Íráhro. Manikáne ehweh iraru kegá íné wehukení úku anínsábé naho sehiranuwe. Itega Sarúsarama suwahpeq pokonaraq sega sehiranunserahnue mó kegá miraigehe. ");
INSERT INTO awb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nánuwahrah Asíú kégá nahnso kebá móintagéhe. Sega niwiréh aintera abehq éhwéh aintera tehqni aintera ");
INSERT INTO awb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nubiq marera nubiq suagéhe. Nubiq suehrana íné pukéna apahtáró wéhékáhtáq oga úkinauge úwara ");
INSERT INTO awb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","we kéró kega mi ehwéh íre ahtebowe. Mi ehwéh áwahe kopípéq ko púara sirupipeq íre írówe. ");
INSERT INTO awb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sísaga Séríko suwahpeq wahto kútaq aura pira ánínká ahnayehráq tútuue ména ineh inehúwe. ");
INSERT INTO awb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Áhnte kegá sótaikuwana mi anínká irena sensabé, Aneroo úwara ");
INSERT INTO awb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","sega wensabé, Néhsara suwahpeqte ání Sísa sotaikire teawúwe. ");
INSERT INTO awb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Teawúwana wega anotahtaq mahraréna, Sísao, Tébítine anahwao, ínénsabe arutaboirainto úwara ");
INSERT INTO awb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ebeq ku kegá wensabé awehgu atera, Ehiya míahno atówana wega íre túbáh agia peh anotahtaq mó mahraréna, Tébítine anahwao, ínénsabe arutaboirainto úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Arutaboirainto úwana Sísaga mitaq kowéna, Níyáhrabi aní meqme sero úwara meqmera suwe. Suwana Sísaga wensabé, ");
INSERT INTO awb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Aneratanínkono úwana wega, Néne Wahnahno, íné tagéyabe nuwahbehre úwana ");
INSERT INTO awb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sísaga wensabé, Arega aiq pútare aintahnaga aiq kaweratóge. Tagáhno úwe. ");
INSERT INTO awb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tagáhno úwana apubúue tagéna Sísa kérena Manikánsabe iwíáh íwíáh atowara mina tago kegá moq iwíáh íwíáh atówe. ");
INSERT INTO awb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sísaga Séríko suwahpeq kure kótaikinaúwana ");
INSERT INTO awb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","táhkísi moné meyó kene wahnah wenáwíq Sákíási míowe. We áhnte monéákáq ánínéna, ");
INSERT INTO awb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sísa taganie íwíáhéna áhnte kegá kígíunsabe we egahq aní púana Sísa íre tagahrahúwe. ");
INSERT INTO awb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Minayabe wega pehbeheráh wehuke kótaikue Sísa taganieéna we sína ahtápéqté áwánkátápéq kire kirútuue míowe. ");
INSERT INTO awb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tútuue míowana Sísaga wahtotaq séna aura pankeqme Sákíási tagéna wensabé, Sákíásio, arene nahtapeq kowíaniboq are apubúue maraipéq tueagúno úwe. ");
INSERT INTO awb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tueagúno úwana Sákíásiga apubúue tueague aru eyoyóéna Sísa mehweh atena wene nahtapeq móatowe. ");
INSERT INTO awb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mina tago ke ómiga abiahnsanéra áhnte ahbábáq áníné nahtapeq pokinsabé íre kawerire uwe. ");
INSERT INTO awb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sákíásiga wene nahtapeq iriwe ména Sísansabé, Néne Wahnahno, néne ménsámehnsá saraqme tabonah ke ákáhtaq náriníe. Menahmé ínéga mó keyábé péhe éhwéh teriena sene móne pehipi merauge. Amahnága merau moné itaréitaréráq meraunserahnue mi ke náriníe úwe. ");
INSERT INTO awb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Úwana míó kega írótaq Sísaga wensabé, Arene ahbabáq sansa suahnayabé iboramé ite mi karírónání kaweraitóge. Arewe amahnága aiq pútaq Ébáráhma kahnáh ání míahne. ");
INSERT INTO awb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Íné wehukení úku anínká ahbabáq ke kabarue kawerinieéna tumíóge úwe. ");
INSERT INTO awb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sega ahtapeq kure Sarúsarama suwahpeq wahto kutaq wereq nogú kega iwíáhéra, Manikánka wahnah wahnahnirabeq ábóraq aginaire unsabe Sísaga mah pabéqmé éhwéh teriuwe. ");
INSERT INTO awb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Teriena, Anotah wehgá íre wahto wáhnaupéqté kéné marakóraq pokinauraire. Mi wehgá iwíáhéna, Pokinaurabeqte wáhnáh ánínká ínénsabe, Arenawahpeq pokue arenawahrah kowahnahnúno teninkeheéna pokinauge íwíáhuraire. ");
INSERT INTO awb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pokinauraitaq wene arambehri ke nayáhnkú ké síáhrabéna 20 Kína 20 Kína ue sítáráwéna sensabé, Íné pokona tanáhráq mah moné matawéq paiqme arambehriéwehrana kouwekono éna pokuraire. ");
INSERT INTO awb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pokurairara wenawahrahga wensabé íre suwahbéna wáhnaupéqté wáhnáh ánínsábé, Areba ki anínká itetaq wahnahnéyabe iuwahriehre koreawéro éra mó ke we anehe eqmaq súátówe. ");
INSERT INTO awb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pokurai wehgá mi wahnáh árámbéhrí mewena wenawahpeq kouwekéna wene arambehri ke móne átáríaro keyábé síáhraburaire. Síáhrabéna sensabé, Íátáu moné árámbéhrí árahuroo kasenuraire. ");
INSERT INTO awb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Árahuroo kasenurairana ebeq surai anínká wensabé, Anotah weh wóne. Arega níátóna moné mi 20 Kínáráté áhnte paiqmaqme amahnága arene móne íregáritaq Kiná 200 Kína úkire urairana ");
INSERT INTO awb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","wahnah korégá wensabé, Kaweróne. Are kaweq arámbéhríóna aní móne. Pehgáriq arámbéhrí tábúsoq marahna puah mókakewe arega nayáhnkú kéhíná suwahpeq wahnahninkehe uraire. ");
INSERT INTO awb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mó arámbéhrí ánínká séna wensabé, Anotah weh wóne. Arega níátóna moné mi 20 Kínáráté paiqmaqme amahnága arene móne 100 Kína úkire urairana ");
INSERT INTO awb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","wahnah korégá wensabé, Arewe moberíáh kéhíná suwahpeq wahnahninkehe uraire. ");
INSERT INTO awb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Urairana mó arámbéhrí ánínká séna wensabé, Anotah weh wóne. Arega níátóna moné meyo. Ínéga ambantaraté úbíqme kopéq matauge. ");
INSERT INTO awb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Íre arega arambehrióna naneq mewe meweóne. Íre arega uqmatona naneq naruq naruróne. Are págege wahnáh ání míahnayabé áhreéna arene móne kopéqmarena pehipi áwúge uraire. ");
INSERT INTO awb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Urairana wahnah korégá wensabé, Arewe íre kaweq arámbéhríóna aní móne. Arega iraréna ehwéhnsábé ehweh atanauge. Íre ínéga arambehriu naneq mewe meweuge éna wino. Íre ínéga uqmatau naneq naruq naruruge éna wino. Íné págege wahnáh ání míó púah ");
INSERT INTO awb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","aneqsabé néne móne pénkiipéq íre matono? Mirauronaraq tahirímé amahnága áwátáu monéákáq pénkiipéqté mónéákáq meyó irino éna ");
INSERT INTO awb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","mitaq míaro keyábé, Túbáh agurai aníné móne meweq áhnte kiná 200 kína matíéh ání náwéro uraire. ");
INSERT INTO awb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Urairara sega wensabé, We amahnága 200 Kína matíéh mino urowana ");
INSERT INTO awb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","wahnah korégá sensabé, Teiníboq írátíáhro. Áhnte matíéh ání mónkakáq awiníe. Pehgáriq matíéh ání mina meyahnana we tabonah ani míankehe uraire. ");
INSERT INTO awb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wahnah korégá mó mahraréna, Néne naruowe ínénsabe itene wahnah aní méyabe iuwahriehre uro kewé meriqme sure ínéga tagahnaq subiq súáhro uraire úwe. ");
INSERT INTO awb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sísaga mah pabéqmé éhwéh teriena ahtapeq ebeq kure Sarúsarama suwahpeq pokinaúwe. ");
INSERT INTO awb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wega Páítápási suwahpeq Pétáni suwahpeq wahtotaq kútaq Óríwi sawéhrápéq kiuwe. Sísaga we kéróya aníté eqmaq suanaútaq ");
INSERT INTO awb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","sensabé, Isebeq wahtotaq kehiná suwahpeq pokotao. Mitaq kirataq iyaráh ká tónki aráhq wehuke íre áhkokóue nogí ká tagéta pugeqme meqme setao. ");
INSERT INTO awb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pugeréhrataq mó anínká itensabé, Aneqsabé pugerehyo ínaraq wensabé, Itene Wahnah áhkokóue kinkeheéta meroye teawétao éna eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eqmaq suowara pokue Sísaga teriunserah iyaro tonkí áráhq tagéra pugeróye. ");
INSERT INTO awb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pugeróyataq mi kané sibowáréhga, Aneqsabé pugerehyo uwara ");
INSERT INTO awb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","sega sensabé, Itene Wahnah áhkokóue kinkeheéta meroye uyana sega, Meqme pokotao uwara ");
INSERT INTO awb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","mi ka meqme Sísaba seweqmera sene korósi mi kané abobiahtaq uwiq máróyana Sísaga mi tonkíné ahbobiahtaq kierútu agúwe. ");
INSERT INTO awb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tónkiga Sísa áhkokóue pokútaq wereq ku kegá Sísansabé iwíáh íwíáh ató púara sene korósi ahtapeq uwiqme awahrirarówe. ");
INSERT INTO awb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mi ah Óríwi sawéhrápéqté tutaq Sarúsarama suwahpeqsabé wahtotaq kútaq áhnte we kéró kega Sísaga págegeue miraú otáq sánsámárínsábé iwíáhue tagéra Manikánsabe iwíáh íwíáh atówe. ");
INSERT INTO awb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sega anotahtaq mahraréra, Itene Wahnah áwírue si aní anotah anínsábé iwíáh íwíáh atone. Manikánka iru pehwehrue aitena we íópeq míéhraq wensabé iwíáh íwíáh atone uwe. ");
INSERT INTO awb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Uwara Péhrasi kegá Sísansabé, Are kéráh kégá túbáh agiyehboq ehweh arito uwana ");
INSERT INTO awb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sísaga sensabé, Teiníboq írátíáhro. Sega túbáh agotaq tahirímé ebahmarínká anotahtaq iwíáh íwíáh aintáh irino úwe. ");
INSERT INTO awb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sísaga Sarúsarama suwahpeq wahtotaq kútaq mitaq tagéna mibeqté kéyábé arutaboiréna ibisówe. ");
INSERT INTO awb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ibiséna mahraréna, Ibora itewe Manikánka insahwé aitéh sánsá ahtebahtaq tahirímé nirupipeq eyoyó irino. Amahnágawé itega íre tagariahrahowe. ");
INSERT INTO awb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mókakewe itene naruoga iteba séra ite abugéqnáhnue moke itene ahmari paitáwéra wahnahnigehe. ");
INSERT INTO awb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sega itene nahmarí sokoruera itereq itene animárínseq subipáhraruagéhe. Sega moke perehnehnia ebáhtáté miraia naneq sokoruagéhe. Manikánka ite kaweraite tanahráq íre ahtebónayabé mókake itene naruoga miraigehe éna arutaboiraritowe. ");
INSERT INTO awb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq kibekéna mitaq paiqnanánu ke máhpeq kaqsuena ");
INSERT INTO awb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","sensabé, Manikáne ehwehnka mahraréna, Néne nahme púreré nahne ue áwíratagéhe ire. Itega miraonka mah nahmé aebó kégá mehwatíáhnserah nah úkire úwe. ");
INSERT INTO awb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sísaga mó wehekáh mó wehekáhnue mitaq síwáhnorúwara Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereq mibeqté wáhnáhmárínseqka Sísa subiq suanéhboq aneq ehwéh atanéhnkono éra sío síouwe. ");
INSERT INTO awb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sísaga síwáhnorútaq áhnte mó kegá wene ehweh ireyabe suwahbó púara we subiq suanehe íwíáhu kegá íre suboráhuwe. ");
INSERT INTO awb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sísaga mó wehekáh Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq síwáhnoréna kaweq ehwéh teriuwara Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereq mibeqté Asiu kené ábóáwáh wéhreqka weba séra ");
INSERT INTO awb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kasenéra, Arega miraóna naneqme árahinie miraono? Insega miraúno atáráinsabé miraono? Teio úwe. ");
INSERT INTO awb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Teio uwana Sísaga sensabé, Ínéga moq itensabé kaseninie. ");
INSERT INTO awb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sóniga wání meri merininkeheéna insega eqmaq áúwátáiro? Manikánka eqmaq áúwátáiro? Peh wehukega eqmaq áúwátóo? Teníéro úwe. ");
INSERT INTO awb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Teníéro úwara sega epéq sío síoéra, Anere teawenéhnkono? Manikánka Sóni eqmaq áúwátáire teawénaraqmé wega itensabé, Aneqsabé wene ehwehnsabé íre aiq pútare atáróo inae. ");
INSERT INTO awb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wehukega Sóni eqmaq áúwátówe teawénaraqmé mahtaq sáhuríáh kégá, Sóniwe Manikáne ehweh irarurai aní míre íwíáho puara ebahnsa tuparuqme iubíyeho éra sío síouwe. ");
INSERT INTO awb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sío Síoéra Sísansabé, Sóniwe insega eqmaq áúwátáiramo. Ite íre tagarione uwana ");
INSERT INTO awb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sísaga sensabé, Itega íné íre teníéwe. Minayabe ínéga moq ínénsabe, Miraúno aintárái aní íre teiníe úwe. ");
INSERT INTO awb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sísaga mi keyábé mah pabéqmé éhwéh mahraréna, Wehga sonsoqme náhníáq sera ayu uqmarena mó keyábé, Néne sotáq wahnahnue náwe soqintewáhro aritena mitaq suena íre wahto wáhnaupéqté ké suwahpeq kowéna íre wahto tanáhráq mitaq míaraire. ");
INSERT INTO awb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Náhníáq sera irái tanáhráq wene arambehri anínsábé, Ákáhtaq koweyo éna sotáq wahnahnuro kebá eqmatairara sotáq wahnahnuro kegá náhníáq sera íre náwasa subiqmarera kaqsutowe. ");
INSERT INTO awb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kaqsutowana so aboga mó arámbéhrí ání eqmatairara sega we moq subiqmarera íre kaweq sansá atera sera íre náwasa kaqsutowe. ");
INSERT INTO awb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kaqsutowana so aboga mó aní eqmatairara sega we anotahtaq subiqmarera so wírá máhpeq tuparutowana ");
INSERT INTO awb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","so aboga wewe náhenéna, Anerininkono éna niruní nénáhní eqmaraníe. Nénahni púara sega wensabé áhtenéra wene ehweh iragéhe éna wenahni anehe eqmataire. ");
INSERT INTO awb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Eqmatairara we wahto kuraitaq sotáq wahnahnuro kegá we tagéra seye náhenéra, So abone ahninkáwá aiq sire. Mah so awaq mianéhboq subiq suanéhe íwíáhéra ");
INSERT INTO awb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","táhtoqme máhpeq móatera subiq sutowe. Sega mirauronsabé so aboga mi ke anere aritankéhbo? Teiníboq írátíáhro. ");
INSERT INTO awb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","So aboga wene sotápéq séna wahnahno ke subiq suanawire. Wene sotáq mó kegá kawerue wahnahnigeheéna eqsitankéhe úwe. Eqsitankéhe úwara sega wene ehweh irera mahraréra, Éhneh. Sotáq wahnahnuro kegá miraurome íre kawerurowe uwe. ");
INSERT INTO awb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Uwana Sísaga se ebitáwéna sensabé, Manikáne ehwehnka aiq mahraréna, Nah píáh kégá suto wahqká moke nahwiahnsanse kiotaikire ire. Mah ehwéh áwahewé aiq ahtebaho kasenúwe. ");
INSERT INTO awb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kasenúwana mó mahraréna, Mi wahqtáq inahnsubíra kené siyahnsamé piteginae. Mi wahqká megue wehukení subinaraq wene ayahnsamé abiro abiro aginawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Úwara Mósísine ehweh síwáhnoro kereq Manikáne ehweh mibeq mahbeq arítáh kéreqka seye náhenéra, Sísaga mi pabéqmé éhwéhnue itepi parobehre íwíáhuwe. Mira íwíáhu puara sío síoéra, We táhtoqme karábúsiipéq móatanéhe éra peh mitaq sáhuríó keyabé áhreu puara íre miraorahuwe. ");
INSERT INTO awb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mósísine ehweh síwáhnoro kereq Manikáne ehweh mibeq mahbeq arítáh kéreqka Sísa táhtore tanáhráqsábé áwénunowara mó keyábé, Sísaba pokue péhe éhwéh teaweq, Arene ehweh ireyabe iuwahbehre oro. Wega ahbabáq ehweh irarinkehboq págegeue kasenéq áhwárawe tagahro. Ahbabáq ehwehnínaraq táhtoqme anotah wahnáhpá móatanéhe éra péheno ke eqmaq súówe. ");
INSERT INTO awb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eqmaq súówara kure Sísansabé, Íwáhnoraníno, ite tagarionawe arega iraréna ehwéhmé tábúsoqme ehwéhnóne. Arega anotah kereq pehgáriq kereqsabé peh monseráh íwíáhé peh Manikáne sansá ahriahri tábúsoqme pahsuqme íwáhnoróne. ");
INSERT INTO awb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Minayabe teio. Aneq iwíáhono? Itega Aroma kené wahnah aní Sísáhri táhkísi moné awenéhnkono? Árahonehnkono uwe. ");
INSERT INTO awb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Uwana Sísaga sega epéráhpéru iwíáh tagéna sensabé, ");
INSERT INTO awb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ebah moné taganiboq ábóraq maro éna, Mah monéráq píkísahakáq áwíqkakaq insene kehro úwara ");
INSERT INTO awb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","sega wensabé, Aroma kené wahnah anímé Sísáhrinee uwe. Uwana Sísaga sensabé, Aroma kené wahnahne náneq wewe náwéro. Manikáne naneq wewe Maniká náwéro úwe. ");
INSERT INTO awb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Úwara Sísane ehwehnsábé áhtenéra wehuke míópi Sísaga áhwára áhwára ehwéh íre irarúnsabe túbáh agéra ehiya míówe. ");
INSERT INTO awb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sáyúsi kewé pusa ké íre iriwe oganúq sitankéhe íwíáhu kee. Táhmaro mi kegá Sísaba séra wensabé, ");
INSERT INTO awb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Íwáhnoraníno, Mósísine sehiranka maharéna, Íre aninkákáq wéh pukínaraq wenábáqka kéweiní meyankéhe. Mi inínká maqmarahna animárí wenawahne animárí míageheéna meyankéhe ire. ");
INSERT INTO awb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Minayabe abapete téhraníté se ábárahnahnah míarowe. Siwahwágá ahre mewena íre aninkákáq uraitaq pukuraire. ");
INSERT INTO awb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pukurairana náhmbáh 2 abakáwágá awahwáné kéweiní mewena íre aninkákáq uraitaq pukurairana ");
INSERT INTO awb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","náhmbáh 3 abakáwága moq monseráhnuraire. Moke mi abáráhnáhnahnka mi iní mótaq mótarue mewera íre aninkákáq urotaq orah animárí pukurowana ");
INSERT INTO awb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","sinehemé mi iní moq pukuraire. ");
INSERT INTO awb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Moke mi abáráhnáhnahnka mi iní meronsabé iriwe oganúq sitahnaraq insene ahre míanabo kasenuwe. ");
INSERT INTO awb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kasenuwana Sísaga sensabé, Mah marákó márákóípéqté wéhgá ahre meyáhwara ahreronká wehkowe. ");
INSERT INTO awb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Manikánka iriwe oganúq sitahna kegá ahre íre meyagéhe. Ahrega íre wehkigehe. ");
INSERT INTO awb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Se íópeqté kégá mía mía onserah puara mó íre pukigehe. Manikánka se iriwe oganúq sitahna puara peh wene animárí mía míaigehe. ");
INSERT INTO awb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pusa ké iriwe oganúq site ehweh Mósísine sehiranka teíre. Uworapeqté káriq awánkánsábé íre tagia peh téhrówana irobinapipéqté éhwéhnká mahraréna, Íné Ébáráhmane Maniká múge. Íné Áhísáhkine Maniká múge. Íné Sékópane Maniká múge úwe. ");
INSERT INTO awb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mi ehwéhnká sokigi aiímé Manikámé íre pusa kéné Manikáne. Írakaumo. We peh oga míáh kéné Maniká míre. Wega tagehme ómi oga míáhwe úwara ");
INSERT INTO awb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","táhmaro Mósísine ehweh síwáhnoro kegá Sísansabé, Íwáhnoraníno, arega tábúsoqme iraréne éra ");
INSERT INTO awb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","áhtenéra mó íre kasenuwe. ");
INSERT INTO awb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sísaga sensabé kasenéna, Manikánka merirankeheéna omaq ato aní we Tébítine anahwa wíre ewe. Mi ehwéhmé aneqsabé irarewo? Maniká itene Wahnahnka néne Wahnahnsabé, Niyah púpeq tútuue míéhnaraq arene naruo wahnahnarítáríahno ire. ");
INSERT INTO awb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Manikáne Awanka Tébíti iwíáh atowana igonkó pukúípéq sehiranúwana mi ehwéhnká mahraréna, Maniká itene Wahnahnka néne Wahnahnsabé, Niyah púpeq tútuue míéhnaraq ");
INSERT INTO awb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","arene naruo saiqnariankehe atóge úwe ire. ");
INSERT INTO awb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Írátíáhro. Tébítiga mi anínsábé, Néne Wahnahne ato puana we árahue wene anahwa míanabo úwe. ");
INSERT INTO awb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ómi míó kega írótaq Sísaga we kéró ke teriena, ");
INSERT INTO awb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mósísine ehweh síwáhnoro kegá mirao serahniyeho. Mó kegá se tagéra sensíwíq pankerageheéra íre wahto korósí úbíqmera nógówe. Sega máhkétirapéq nogótáq mó kegá se mehweh ariteyabe suwahbehre. Momiwí nahtápéq pokotaq kaweqtapéq tútuue méyabe suwahbehre. Táhutahurorabeq aboawah wehwárí tútuue míáhrabeq méyabe suwahbehre. ");
INSERT INTO awb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sega kéweinínsónsábé péhe éhwéh teriera sene ménsámehnsánkakaq sene nahnkakaq mewe meweowe. Ite kaweqtaq míáh ké wóe igeheéq wehuke míáhtáq íre wahtotaq púreq aruqarurowe. Mirao puana Manikánka ehweh aritahna tanáhráq se anotahtaq kamah arinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wehukega séra Maniká móne náwúrabeq áhnte monéákáq kégá mitaq móne náwúwana Sísaga tagówe. ");
INSERT INTO awb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tabonah kewéínínká séna káriq pabúsá móné náwuwana tagéna ");
INSERT INTO awb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","mahraréna, Teiníboq írátíáhro. Mi tabónáh kéwéínínká náwí mónégá moke mó kegá náwé móné kiotaikire. ");
INSERT INTO awb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sega sene pehipi matíáh móné náwéwana mah tabónáh kéwéínínká moke wene matíéh mónéwé aiq náwíre. Aiq náwí púana amahnága táhutahuq paiqmarahna moné íre kéhre. Minayabe wega náwí mónégá moke mó kegá náwé móné kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Táhmaro kegá Manikánsabe iwíáh íwíáh atáh náhtápéq tagéra mahraréra, Mah nahtáqmé áhnte kawéq ébáhmárí awahriq naneqmarí kéhre uwana Sísaga minayabe mahraréna, ");
INSERT INTO awb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Itega tagah naneqme mókake paentárara aruaneherawoe. Mi peréhnéhnia ébáhmárí miraue moráráq íre kagainae. Peh moke paentárara aruaneherawoe úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sega Sísansabé, Íwáhnoraníno, arega irarénawe ahkake miraoneherabo? Miraonehera irataq aneq ábóraraginabo? Miraonehera irataq itega ahtebanehboq ebeqme aneq ábóraragínaq taganehnkono kasenuwe. ");
INSERT INTO awb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kasenuwana Sísaga mahraréna, Mi tanáhráqsábé mó kené péhe éhwéhnsábé aiq pútare arítéhboq auráq matawéq tagaríáhro. Mi tanáhráq áhnte kegá mótaq mótarue néníwírue séra péhenéra, Íné Manikánka eqmaq núwéh ání múge éra, Anehe tanahráq aiq wahtonire igehe. Mina tahnsanira ke íre kéríráhro. ");
INSERT INTO awb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mi tanáhráq mah marákó márákó ebehowe ira ehwéh ireq íre ahreoro. Íre iransánoro. Téhwe teiú náneq ebeq sínana anehe tanahráq íre apubúue sinae úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sísaga anehe tanahráqsábé mó mahraréna, Mó kehinánseq mó kehinánseqka ebehoneherawoe. Mó wahnáhné awahrahreq mó wahnáhné awahrahrerue ebehoneherawoe. ");
INSERT INTO awb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mi tanáhráq anotah maríinae. Mitaq mahtaq ehwehráhnara áhnte ke awahreoneherawoe. Mi tanáhráq íópeqté náneqmarí tagéq anotahtaq áhreoraho naneqmarí tagagehe. ");
INSERT INTO awb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mi tanáhráq itensabé suwahrieh kegá ite táhtoqme íwíoqnéra momiwí nahtápéq ehweh aitera karábúsiipéq móitagéhe. Itega néne sánsá segíónsábé anotah wahnáh kéreq ákáhtaq wahnáh kéreqka ehweh aitageheéra seba móitagéhe. ");
INSERT INTO awb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mirairataq íné éhweh terigéhe. ");
INSERT INTO awb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mi tanáhráq, Aneq ehwéh irarenehnkono ue iwíáh kikiriyeho. ");
INSERT INTO awb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ínéga kaweq iwíáh aitahnaq ahtebia éhwéh irarirataq itene naruoga mi ehwéhnsábé íre ahqáho aitahráhowe. ");
INSERT INTO awb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Iteinoiboreq iteribáqmarinseq iteruwahrahreq itene iyahnabo anímárínseqka ite wahnah kebá móitehrara sega ite táhmaro iubiq iuagéhe. ");
INSERT INTO awb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Néne sánsá sehgíó púara ómi kegá itensabé iuwahriehre aitagéhe. ");
INSERT INTO awb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Itene iyahqnopeqte peh morá íyáhrá íre sáúqkinae. ");
INSERT INTO awb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Néne sánsá íre susa anehe tanahráqkákáq kawerue sehgírataq oga mérapeq awaq miagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sísaga anehe tanahráqsábé mó mahraréna, Ebehira kegá Sarúsarama suwahpeq abugéqnáhnuriehra tagehrataq áhníbórá mi ke aipáhrue subiq suera nahmarí kekigahki aruaneherawoe tagariagehe. ");
INSERT INTO awb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mi tanáhráq Súría marákórápéq míéhrataq sáwéhrapeq pehbeheráh pokoro. Sarúsarama suwahpeq míéhrataq mitaq sueq móbeq pokoro. Ahpeq nogírataq Sarúsarama suwahpeq kouwekiyeho. ");
INSERT INTO awb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mi tanáhráqmé anotah kamáh aina tanáhráre. Manikáne ehwehnka kamah ainawire ime aiq pútaraginawire. ");
INSERT INTO awb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mi tanáhráq kía míéhra ininsónseq inahunahnínkákáq ínínsónseqka íre pehbeheráh pokorahi puaq sensabé irutaboiroro. Manikánka mi ke anotahtaq kamah arinkéhe. ");
INSERT INTO awb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nahnso kegá mó ke pokatate kiraqme subiq suera mó ke meriqmera moke wáhnaupéqté ké suwahpeq móruagéhe. Nahnso kegá Sarúsarama suwahpeq áhnte opéq wahnahnigehe. Nahnso kegá wahnahné tanahráq parabagínaraq sega mitaq mó íre wahnahnigehe. ");
INSERT INTO awb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Sísaga mi tanáhráqsábé mó mahraréna, Mi tanáhráqmé pópoqnahwe, íómé, wehyoqmarímé ótaq sansánagínaq tagagehe. Sóreq wanínká mueq muerue sóyáh agína puara moke wehukene sirupipeq umeh agínara anotahtaq áhreoneherawoe. ");
INSERT INTO awb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Íópeqté náneqmarínká kúrugúruínaraq wehukega, Anerirapómo éra iwíáh kikiréra anotahtaq áhreoneherawoe. ");
INSERT INTO awb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mi tanáhráq íné íópeqté piribirioyahnkakaq téhreh naneqkakáq págegeue írábúyápipeqté tuonara tagagehe. ");
INSERT INTO awb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Teiú náneqmarí tagehrataq iriwe méq íwéh panantágínaq taganeheqmóe. Manikánka tumeirahna tanáhráq aiq wahtonire úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sísaga mah pabéqmé éhwéh mahraréna, Éntuankakáq mó awánkánkákáqsábé iwíáhue tagéq ahtebahro. ");
INSERT INTO awb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Awanká ánáh aunínaraq itega iwíáhéq, Ópeq áhníbórá sire aiq ahtebóne ewe. ");
INSERT INTO awb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mina onserah teiú náneq ábóraragínaq tagéq Manikánka wahnah wahnahni tanáhráq aiq wahtotarire igehe. ");
INSERT INTO awb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Teiníboq írátíáhro. Amahnága oga míáh kégá ómi pehipi íre pukigehe. Ebeqme moke teiú náneq ábóraragína tagéq anehe pukigehe. ");
INSERT INTO awb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Íópeqkákáq mah marákó márákóákáq parabagínana ínéga teiú éhwéhmé íre parabagia peh ahriahri kagainawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sísaga mi tanáhráqsábé mó mahraréna, Kaweqtaq méq kawerurero. Itega abehq wání néq múguwahguiyeho. Ménsámehnsánsabe iwíáh kikiriyeho. Mirairataq ite íre iwíáhirataq mi tanáhráq apubúue sinae. Kahnkapi wah paríéhnserah ");
INSERT INTO awb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","mi tanáhráq moke mah marákó márákóípéq míáh ké parianeherawoe. ");
INSERT INTO awb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ahriahri níwénunéq kawerue auráq matíáhro. Mi tanáhráq sínaraq teiú náneqmarínká kamah ainehoéq Manikánsabe, Págege ainte séhréh ainto ue púreroro. Mirairataq íné wehukení úku aníné niuranabiahtapeq seiriwe míagehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Moke wéhékáh Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéq síwáhnoréna tupekinaútaq mitaq suena Óríwi sawéhrápéq kigaegaeúwe. ");
INSERT INTO awb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ahbiahipeq áhnte kegá wene ehweh iraneheéra Manikánsabe iwíáh íwíáh atáh náhtápéq séyéuwe. ");
INSERT INTO awb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Asiu kené sótaikú siahreraq ko tanahráq íre múí párétí no tanahráq wahtonútaq ");
INSERT INTO awb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka sío síoéra, Sísawe árahue subiq suanéhnkono uwe. Sega mó keyábé áhreu puara ábóraq íre táhtorahráhuwe. ");
INSERT INTO awb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sísa kéró ke airápété téhraníté míówe. Sebaté ání Súrása Ísíkáríótie. Owainawanka Súrásane arupipeq kowena iwíáh atowana ");
INSERT INTO awb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","pokue Manikáne ehweh mibeq mahbeq arítáh kéreq Manikánsabe iwíáh íwíáh atáh náhtápéqté wáhnáh kéreqpa kure sensabé, Sísa owinahwinonaq subóro úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Úwara iwíáh íwíáhéra móne awenéhboq miraúno uwana ");
INSERT INTO awb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Súrásaga kowe aritena wehuke íre míéhrataq se Sísaba mórite tanáhráqsábé iwíáhue kabarúwe. ");
INSERT INTO awb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Asiu kené sótaikú siahreraq ko tanahráq íre múí párétí né tanahráq sútaq Asiu kegá sipisípiq áráhq subiqme titiru tanahráq súwe. ");
INSERT INTO awb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mi tanáhráq Sísaga Pítareq Sónireqsabé, Sótaikú tanahráq ahreraq kéh táhútáhúq nanehboq kogaweraráhtao úwara ");
INSERT INTO awb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","sega wensabé, Eheq kogawerarayéhnkoyo ue kasenuyana ");
INSERT INTO awb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sísaga sensabé, Íráhtao. Wahto kehiná suwahpeq pokue obenkisa wání ántéhyánkákáq ánínseq piehgírataq we kéanehenotao. We pokína nahtápéq kieráhtao. ");
INSERT INTO awb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mibeqté ábóáwáh wéhyábé, Íwáhnori anínká mahraréna, Ínéreq íné séníráh kéreqka sótaikú iahreraq kéh tánáhráq táhútáhúq nanehboq mi paqnáhípéq sokigi aio ire etao. ");
INSERT INTO awb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wega ménsámehnsá aiq kaweria anotah paqnáhípéq sokigi ínaraq mitaq itene táhutahuq kaweraráhtao éna eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eqmaq suowara pokue Sísaga teriunserah tagéra mitaq sótaikú tanahráq siahreraq ko tahutáhúq kaweraróye. ");
INSERT INTO awb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Táhutahuq tanahráq sinaútaq Sísareq we kéró kereqka táhutahuq naneheéra pokue tútuue míówe. ");
INSERT INTO awb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sísaga sensabé, Níéraníra tanáhráq aiq wahtonire. Ebeqme mina sótaikú tanahráq iahreraq kéh táhútáhúq itereq moráráq naneheéna iwíáh íwíáhuge. ");
INSERT INTO awb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Teiníboq írátíáhro. Mah tahutáhúq nahnaraq mah marákóípéq míó tánáhráq mó íre nanie. Manikánka wahnah wahnahnirabeq míáhnaraq mitaq nanauge úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wega náhníáq sera anonkakaq káhpú mewena Manikánsabe, Kaweróne atena sensabé, Umah. Moranínká moranínkáue nahro. ");
INSERT INTO awb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Íné mah marákóípéq míó tánáhráq náhníáq sera ano mó íre nanie. Manikánka wahnah wahnahnirabeq míáhnaraq mitaq nanie éna ");
INSERT INTO awb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","páréti mewena Manikánsabe kaweróne atena keqme náriena sensabé, Mahnawé niwaq mire. Nehrataqmé ínénsabe iahreraq matíáhro éna ite séhréh aitanieéna pukinie úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sega mi tahutáhúq parabagútaq Sísaga náhníáq sera ano mónkakáq mewe páréti náriunserahnue siena sensabé, Mahnawé néne korahq mire. Ite séhréh aitanieéna néne korahqka tuinawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sísaga mó mahraréna, Tagahro. Néne naruo koweriranai ani itereq moráráq míéhre. ");
INSERT INTO awb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Manikánka aiq irarinserah íné wehukení úku aní pukinie. Néne naruo koweriranai anímé anotahtaq kamah awinawire úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Úwara we kéró kega sío síoéra, Insega mirainabo ue kasenuwe. ");
INSERT INTO awb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sísa kéró kega seye ehwehéra, Ínéga ite kiotaiku aní múge éra mó anínká mó anínkáue mira íwíáhéra ehwehuwe. ");
INSERT INTO awb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ehwehunsabe Sísaga sensabé, Mah marákóípéqté kéráq págege wahnáhno ke míáhwe. Págege wahnáhno ke méra sensuwahrahraq wahnahnéra, Ite kawerue séhréh aitáh wáhnáhne ewe. ");
INSERT INTO awb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Itega mina tahnsa íre oro. Ite míáhrabeqte ání anotah anímé iteríbáq tahnsa míahno. Wahnah aní míanie íwíáhina anímé arambehri aní méq we séhréh atehoro. ");
INSERT INTO awb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tútuue táhutahuri anímé anotah aníne íwíáhowe. Wene arambehri aní wene táhutahuq kaweraréh ánímé pehgáriq aníne íwíáhowe. Íné iteba míó ánímé arambehri aní tahnsanéna séhréh aita aitauge. ");
INSERT INTO awb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Níwíoqnah tanáhráq itega íné íre nuwasa ínéba mía míaonsabé ");
INSERT INTO awb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nániboga ínénsabe wahnahnúno aintéhserah ínéga itensabé moq wahnahnoro aitóge. ");
INSERT INTO awb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ínéga wahnah wahnahnonarabeq itega mitaq tútuue méq táhutahurigehe. Ísara kahnáh airápété téhtaré míáhwe. Itega wahnah kené tahberaq tútuue méq mi kahnáhné ehweh iwíáhue tagéq tábúsoq sitagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sísaga Pítansabé mahraréna, Sáímónio, Sáímónio, írátíahno. Owainawanka iwíáhéna, Ahreronká námúq sibinsibinonserahnue ite abehq náneq tahnsá úkigeheéna íwíoqnanie ire. ");
INSERT INTO awb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amahnága arega ínénsabe aiq pútare ainte néne sánsá ambubu atiahne. Néne sánsá súéhneho éna arensabé púreratóge. Arene ahbabáq sue íné séraníe íwíáhinaraqmé arereq morá árámbéhrí ké séhréh arito úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Úwana Pítaga Sísansabé, Néne Wahnahno, are kérónsábé karábúsiipéq móintaneherabomo nubiq suaneherabomo. Anetaníbo. Kéraníe úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Úwana Sísaga wensabé, Teawiníboq írátíahno. Ibora kokórega ehwehnina ínaraq arega íné íre tagaríóge apahtáróráq irariniewóne úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sísaga sensabé, Mónewe, unahmé, súwe meyého ue eqmaq íúwátáutaq ite aneq tabonahuroo kasenúwara sega wensabé, Írakaumo uwana ");
INSERT INTO awb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","wega sensabé, Amahnága móneakáq unahnkákáq matíéhrataqmé mina mewe nogóro. Poka íre matíéhrataq sáhkétiraté móne meweq mi monéráté poka paiqmaráhro. ");
INSERT INTO awb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aneqsabé teiugo? Manikáne ehwehnka aiq mahraréna, Wereq ahbabáq kereq morábí sáharitagéhe ire. Teiníboq írátíáhro. Sega íné mirairansabé mi ehwéhnká aiq pútaraginawire úwara ");
INSERT INTO awb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","we kéró kega wensabé, Itene Wahnahno, tagáhno. Ite téhtaré pókánkákáq míone uwana wega sensabé, Mina aiq awehrare úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sísaga mitaq suena Óríwi sawéhrápéq poku pokuúnserahnue pokúwara we kéró kega kérówe. ");
INSERT INTO awb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sísaga mitaq kéna sensabé, Ahbabáq aitehnehboq púreroro éna ");
INSERT INTO awb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","se suena wahtotaq móbeq pokéna marakóraq káuqmunue ména púrerúwe. ");
INSERT INTO awb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Púrerue mahraréna, Nániboo, are awahbáhnaraqmé nirupipeq umehi naneq menuahráhóne. Íre íné nuwahbeh sansá peh are awahbáhna sansánúno ue púrerúwe. ");
INSERT INTO awb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Púrerúwana íópeqté ánínká weba tuena págege atowe. ");
INSERT INTO awb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Págege atowana wene arupipeq áhnte umehúwana mónkakáq págegeue púrerúwe. Págegeue púrerú púana áhnte munsínsínká tuwe. Munsinsínka korahq tahnsánue marakóipeq tabagúwe. ");
INSERT INTO awb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Púrerúrabeqte irigue we kéró ke koragówara sirupipeq umehúnsabe sugówe. ");
INSERT INTO awb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wega sensabé, Aneqsabé sugaho? Owainawanka ahbabáq aitehnehboq iriwe púreroro úwara áhnte wehuké weba suwe. ");
INSERT INTO awb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sísaga ehwehnútaq we kéro aní Súrásareq áhnte mó kereq weba suwe. Súrásaga ebeq séna weba wahtotaq sewéna we nánkóqnanaútaq ");
INSERT INTO awb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sísaga wensabé, Súrásao, íné wehukení úku aní mónuwanieé nánkóqnanibo úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Su kegá Sísa táhtoraneherautaq we kéró kega tagéra wensabé, Itene Wahnahno, pokatate apiaranéhnkono uwe. ");
INSERT INTO awb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Uwana peh morá kéro anínká wene pokatate Manikáne ehweh mibeq mahbeq arítéh áníné arambehri aní apiwe wene púpeqte áhré kiraq auwowe. ");
INSERT INTO awb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ahre kiraq auwowana Sísaga sensabé, Aiq míre. Túbáh agoro éna kiraq auwo aníné ahre táhtoqme kaweratowe. ");
INSERT INTO awb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Manikáne ehweh mibeq mahbeq arítáh kéreq Manikánsabe iwíáh íwíáh atáh náhtápéqté wáhnáh kéreq Sarúsarama suwahpeqte ábóáwáh wéhreqka táhtoranehera utaq wega sensabé, Aneqsabé aebó ání táhtoráhnserah pokankakaq sahnkákáq íné meniraneheéq seo? ");
INSERT INTO awb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mó wehekáh mó wehekáhnue Manikánsabe iwíáh íwíáh atáh náhtápéq iteba míarautaq itega íné íre táhtotiarowe. Amahnága iteitene tánáhrárirana sunkíkírirabeqte sánsánká aiq kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sega Sísa táhtoqme meqmera kure se mótaq we mótarue Pítaga sinehe kaqme kure sega Manikáne ehweh mibeq mahbeq arítáh kéné wahnahne nahtapeq kuwe. ");
INSERT INTO awb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mi matábúráq ira parewe tútuue míówana Pítaga mitaq kowéna tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tútuue míowana ira kawerue téhrówana mibeqté árámbéhrí áhrárígá Píta ebitáwéna mahraréna, Mah anímé Sísaba mía míai aníne úwana ");
INSERT INTO awb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pítaga ahqáho éna wensabé, We íre tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Úwana mótaq tahnsa mó wehgá Píta tagéna wensabé, Are moq mi kahnáh ání móne úwana Pítaga, Íné írakaumo úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Anehe mó wehgá págegeue mahraréna, Mah aní Kehrari marákórápéqté ání púana wereq mía míai aní míre úwana ");
INSERT INTO awb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pítaga wensabé, Arega irarénawe íné íre tagaríóge úwe. Pítaga mi ehwéh irarútaq kokórega ehwehnúwana ");
INSERT INTO awb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sísaga pabeqme Píta tagówe. Tagówana Sísane ehweh ahreraq matawéna iwíáhúwe. Mi ehwéhnúmé, Kokórega ehwehnina ínaraq arega íné íre tagaríóge apahtáróráq irariniewóne únsabe Pítaga iwíáhéna ");
INSERT INTO awb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","kéirigue móbeq pokéna anotahtaq ibisówe. ");
INSERT INTO awb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sísa auráq matíó kega wensabé awiréh atera subiqmarówe. ");
INSERT INTO awb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sega ambantataté wene aura akariue táhrarera we subiqmarera kasenéra, Insega subiq marehro? Teio uwe. ");
INSERT INTO awb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Teio éra sega wensabé áhnte íre kaweq ehwéhnatówe. ");
INSERT INTO awb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ahbiahipeq Asiu kené aboawah wehwárínseq Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka momiwíuríówara Sísa meqmera mi kaunsírí kébá móátówe. ");
INSERT INTO awb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Móátówara sega wensabé, Manikánka ite meirena kaweraitankeheéna peh morá ání omaq atowe. Arewe mi anípo? Pahsuqme teio uwana Sísaga sensabé, Ínéga teiénaraqmé itega íre aiq pútare aintaneheqmóe. ");
INSERT INTO awb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ínéga itensabé kasenonaraqmé íre tenieneheqmóe. ");
INSERT INTO awb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wahtotaq tanáhráq íné wehukení úku anínká Maniká Iteribone ayah púpeq tútuue mía míainauge úwe. ");
INSERT INTO awb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Úwara sega wensabé, Are Manikáne ahninkáwábo kasenuwana wega sensabé, Itega aiq irarewe. Íné werahu mino úwara ");
INSERT INTO awb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","seye náhenéra, Iteitega wene ehweh aiq ironayabé mó kegá kasenéyabe anetaníbo uwe. ");
INSERT INTO awb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Minayabe Sísansabé ehweh ató kega we meqmera Páhírátiba kure ");
INSERT INTO awb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","mitaq mó ehwéh atera mahraréra, Iteruwahrah moke íre kaweraruanieéna péhe éhwéh síwáhnorire. Wega, Aroma kené wahnah aní Sísáhri táhkísi moné íre náwéro aitáráire. Wega, Íné Asiu ke kaweraranieéna su aní múge uraire. Íné anotah Wahnáh ání múge uraire ue ehweh atówe. ");
INSERT INTO awb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ehweh atówana Páhírátiga Sísansabé, Arewe Asiu kené wahnahpo kasenúwana wega wensabé, Arega aiq iraréne úwana ");
INSERT INTO awb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Páhírátiga Manikáne ehweh mibeq mahbeq arítáh kéreq momiwíuríó kereqsabé, Mah aníné ahbabáq íre ahteboge úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Úwara sega págegeue mahraréra, Mi anínká síwáhnoréna pagu paguninsabé wene ehweh íráh kégá ahbabárorahi iwíáhowe. Téhwe Kehrari marákórápéq síwáhnoréna moke Súría marákórápéq síwáhnoréna amahnága mahtaq síwáhnorire uwe. ");
INSERT INTO awb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Páhírátiga mi ehwéh irena sensabé, Mah aní Kehrari marákórápéqté ánípo kasenúwara, ");
INSERT INTO awb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ee. We mibeqté áníne teawúwe. Páhírátiga mi ehwéh irena, Érótiwe mibeqté wáhnáhne íwíáhéna mi tanáhráq we moq Sarúsarama suwahpeq míonsabe Sísareq we ehweh ató kereq Érótiba eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Érótiga Sísa éhweh mó tanáhráq mó tanáhrárue irena, Wega ótaq sansá miraína tagéyabe níre íwíáhéna íre wahto tanáhráq Sísa tagéyabe awahbéna sega Sísa meqmera sutaq wene arupipeq anotahtaq eyoyóúwe. ");
INSERT INTO awb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wega Sísa áhntetaq kasenúwana íre ehwehnia peh ehiya míowe. ");
INSERT INTO awb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Manikáne ehweh mibeq mahbeq arítáh kéreq Mósísine ehweh síwáhnoro kereqka mitaq iriwe méra Sísansabé págegeue ehweh atówe. ");
INSERT INTO awb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Érótireq wene sóntía kereqka Sísansabé awiréh atera abehq éhwéh atówe. Sega kaweq karósí Sísa suki atera eqmarówara Sísa meqmera Páhírátiba kouwekuwe. ");
INSERT INTO awb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nahomé Érótireq Páhírátireqka seye abiahnsa aruqaruruye. Anehemé mi wehékáh insahwé ue míóye. ");
INSERT INTO awb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Páhírátiga Manikáne ehweh mibeq mahbeq arítáh kéreq mibeqté aboawah wehwárínseq míó kereqsabé, Íráhro éna ");
INSERT INTO awb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","sensabé, Ínéba méátáh ánínsábé ehweh ateq mahraréq, Wega péhe éhwéh síwáhnorire ewe. Itega irare atáh éhwéhnsábé ite míáhtáq kasenéna we íre ahbabáq anine íwíáhuge. ");
INSERT INTO awb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Érótiga moq wene ahbabáqsabe kasenue tagéna ahbabáq íre kéhre íwíáhire. Mah anímé itega we subiq suahráhúna ahbábáq íre kéhre. ");
INSERT INTO awb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Minayabe áréti sahtáté subóro aritena anehe pugeq iníe úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Asiu kené sótaikú siahreraq ko tánáhráq Páhírátiga mó opéq mó opérue karábúsiipéqté peh morá ání pugeq suaq pugeq suarúwe. ");
INSERT INTO awb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Páhírátiga Sísa pugeqiníe úwara ómi míó kega ehweh kikiréra, Ahqáho. Sísa subiq sue Páréhba pugeqio uwe. ");
INSERT INTO awb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Páréhbareq Aroma kereq ebehutaq wega mó aní subiq suonsabe Aroma kegá we karábúsiipéq móátówe. ");
INSERT INTO awb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Páhírátiga, Sísa pugeq auwanuage íwíáhéna míó keyabé, Páréhba íre pugeqiníe. Sísa pugeqiníe úwara ");
INSERT INTO awb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","sega anotah ehwéhnabaéra, Ahqáho. Awankátaq táhpawe subiq suo. Awankátaq táhpawe subiq suo uwana ");
INSERT INTO awb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Páhírátiga sensabé anehe mó kasenéna, Aneqsabébo? We aneq ahbabáriro? We subiq suahráhúna ahbábáq íre kéhre. Íre kéh púaq áréti sahtáté subóro aritena anehe pugeq iníe úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Úwara sega mi ehwéhnsábé anotahtaq ahqáho atera anotah ehwéhnéra, Awankátaq táhpawe subiq suo uwe. Sene ehwehnka Páhírátine ehweh kiotaikúwe. ");
INSERT INTO awb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Minayabe Páhírátiga sensabé, Itega irarenserah mirainie úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aroma kereq ebehú anínká mó aní subiq suonsabe sóntía kegá karábúsiipéq móátó ani pugeq auwowe. Pugeq auwena Sísa awankátaq táhpawe subiq suo irare kegá sene iwíáh sansa miraigeheéna sóntía kebá móatowe. ");
INSERT INTO awb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sóntía kegá Sísa meqmera pokuwana ahtapeq piehgíú ani, Sáíríni marákórápéqté ání wenáwíq Sáímóni, sure Sarúsarama suwahpeq pokinaúwe. Pokinaúwara sega we saiqnatera Sísa táhparéhra awánká we abaq atera, Sísa kéro atówe. ");
INSERT INTO awb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Áhnte kegá sinehe kure mibeqté ínínsónká Sísansabé arutaboiréra ibisowe. ");
INSERT INTO awb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Minayabe Sísaga pabeqme sensabé, Ínénsabe íre ibisahro. Itereq itene anímárínseqsabé ibisahro. ");
INSERT INTO awb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mókake Sarúsarama suwahpeqte ké kamah aríéna tanáhráq sega mahraréra, Orahinínsómé, inahunahní íre maqmíáh ínínsómé, náh íre náríé ínínsómé, sega iwíáh íwíáhigehe irarigehe. ");
INSERT INTO awb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mi tanáhráq, Mi kegá anotah sawéhwárínkákáq pehgáriq sawéhwárínkákáqsábé, Ite apubúue pukonehboq me mewe ite akariúno igehe. ");
INSERT INTO awb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Íné o awánká tahnsa míahnara sega íné miraonehera onsabé mókakewe ite ehyatia awánká tahnsa míéhra puara mó kegá aneq miraoneherabo úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sóntía kegá ahbabáq anité Sísareq subiq suaneheéra meriqmera kuwe. ");
INSERT INTO awb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sega sáwéh áwíq Ayahqno Tánúnsutapéq kíútaq mitaq Sísa awankátaq níriraté wene ayahnkaratáq subiqmaq aigárátáq subiqmarue táhparera awanká pankeqme marakóipeq pearówe. Ahbabáq anité moq awankátareráq níri pewe táhparéra pankeqme ayehré ayehré pearówe. ");
INSERT INTO awb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pearówana Sísaga púrerue mahraréna, Nániboo, mah kegá mirao naneq sega íre ahtebahwe. Minayabe mi ahbábáqsábé íre iwíáhúno úwe. Sóntía kegá, Wene korósi insega meyanabomo éra saraqmianeheéra káhsiue saraqme meyówe. ");
INSERT INTO awb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mitaq momiwíu kegá iriwe awahnkanuwara Asiu kené wahnahmarínká Sísansabé awiréh atera mahraréra, Wega mó ke kawerarítáráire. We wehuke merirena Manikáne arambehri mirainkeheéna omaq atéh ánínínaraqmé wewe moq kawerarahráhire uwe. ");
INSERT INTO awb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sóntía kegá moq awiréh atera weba séra kítabeh nahníáq sérá ano pankeqme awera, Náhno éra ");
INSERT INTO awb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","arewe aiq pútaq Asiu kené Wahnah aníninaraqmé arerene anonka kawerúno uwe. ");
INSERT INTO awb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kanehraq sehiranúwara wene ayahqno abobóráhpeq awankátaq táhparówe. Mi sehiránká mahraréna, Mah anímé Asiu kené Wahnahne úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Awankátaq táhparó ahbábáq ánínká moq Sísansabé awiréh atena, Arewe Manikánka omaq ato anípo? We inaraqmé arere séhréhé ite moq séhréh aito úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Séhréh aito úwana mó ahbábáq ánínká ebeq irarú aninsábé ehweh atena, Arewe Manikánsabe íre áhreono? Sega ite awankátaq táhpawe subiq súáhro aitáhwe. ");
INSERT INTO awb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Arereq ínéreqme ahbabáq anité púara iubówe. Mi anímé we íre ahbabáq aninirarawe pehipi subiq súáhwe éna ");
INSERT INTO awb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sísansabé, Sísao, arega wahnahninagake ínénsabe ahreraq matiahno úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Úwana Sísaga wensabé, Teawiníboq írátíahno. Iboramé Manikáne kaweq matábúrápéq ínéreq míankehe úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wéhékáhnabubu moke mah marákó márákó sunkíkíragúwana íó tunsorerutaqkakáq peh sunkíkíratiowana ");
INSERT INTO awb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","pópoqnah mi tanáhráq íre téhrówe. Manikánsabe iwíáh íwíáh atáh náhtápéqté páráhnkéq tahnsa ónsá senahpeqté subame tunse téhtaré úkúwe. ");
INSERT INTO awb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sísaga anotahtaq mahraréna, Nániboo, néniwa arene ayahpi máróge éna putiowe. ");
INSERT INTO awb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Putiowana sóntía kené kíápéténiga tagéna Manikánsabe iwíáh íwíáh atena mahraréna, Mah anímé íre ahbabária peh kaweqtaq míéh áníne úwe. ");
INSERT INTO awb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Úwara mitaq taganeheéra awahnkanu kegá we putio tagéra sene sirupipeq umeh agúwara mitaq suera sene nahtapeq abae aguwe. ");
INSERT INTO awb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Moke Sísane iyahnaboreq Kehrari marákórápéqté we kéró ininsónseqka moberue iriwe méra moke minawari tagowe. ");
INSERT INTO awb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Súría marákórápéq Árímátéa suwahpeqte wéh wenáwíq Sósépa míowe. We aboawah wehéna kaweqtaq mía míaúwe. ");
INSERT INTO awb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mó abóáwáh wéhwárínká, Sísa subiq suo atótaq wega íre kowe aritowe. Manikánka wahnah wahnahni tanáhráq áwénunue taga tagaúwe. ");
INSERT INTO awb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wega Páhírátiba kure wensabé, Sísane anonka mewena mómaisaranínkono úwana kowe atowana ");
INSERT INTO awb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sóséparehga Sísane anonka kiwewe marakóraq márumarera íre wahto taberábe ambántáípéq úbíqme mewera ubusa onápípéq mómaisarówe. Mitaq mó aní íre maisia peh o oná kowe. ");
INSERT INTO awb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Táhutahuq kaweré tanáhráq pehnkinaútaq Asiu kené ahrena ahrena wehekáh sinaútaq maisarówe. ");
INSERT INTO awb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kehrari marákórápéqté Sísareq su inínsónká Sósépareh kérirera mi oná tagéra Sísa mitaq maisaró tagowe. ");
INSERT INTO awb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tagéra mitaq suera se káúrabeq kure kaweq kunkúni naneqkakáq wériakáq kawerarówe. Mósísine ehwehnka irarúnserah sega ahrena ahrena wehekáh túbáh aguwe. ");
INSERT INTO awb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ahrena ahrena wehekáh parabagúwara ahbiahipeq íó kiembogútaq mi inísónká kaweq kunkúni naneq mewera Sísa maisarórabeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wahtotaq kutaq óna méhpeh paiqmáró ebáh móbeq kowara tagéra ");
INSERT INTO awb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ónapipéq kibekue tagowana sene Wahnah Sísane anonka íre kowara tagowe. ");
INSERT INTO awb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tagéra sirupipeq iwíáh kikiruwara anotah tehró ambántánkákáq áníté ábóraragéra mitaq iriwe míóyara tagowe. ");
INSERT INTO awb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tagéra mi inínsónká anotah ahrééra marakóipeq káuqmunuríówara ábóraraguya anítégá sensabé, Pusa aní matorabeqme aneqsabé oga míéh ánínsábé kabaroo? ");
INSERT INTO awb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","We irigi puana mahtaq íre míéhre. We Kehrari marákórápéq míaraitaq teiátái ehwéh iwíáhue tagahro. ");
INSERT INTO awb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wega mitaq ména mahraréna, Sega íné wehukení úku aní ahbabáq keba móintehrara awankátaq táhpawe nubiq suehrana apahtáróráq iriwe oganúq intankéhe uraire uye. ");
INSERT INTO awb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Uyara mi inínsónká wene ehweh siahreraq matawéra ");
INSERT INTO awb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","maisarórabeqte kouwekue airápété morá we kéró kereq mó kereqsabé moke koreríúwe. ");
INSERT INTO awb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mi inínsómé, apahq ínító síwíqmé Sóánawe, Mágára suwahpeqte íní wenáwíq Máhríawe, mó Máhría we Sémísine anowae. Sereq mó inínsónseqka mi ehwéh eqmaro ke teríúwara ");
INSERT INTO awb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","sega iwíáhéra, Mi inínsónká irare ehwéhmé peh múguwahgu ehwéhne éra íre aiq pútare arítówe. ");
INSERT INTO awb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pítaga mi ehwéh irena pehbeheráh maisarórabeq pokue káuqmunue mitaq tagówana peh maisaró ambántámárí mitaq kowana tagéna kaurabeq kouwekue wene arupipeq iwíáh kikirue tagówe. ");
INSERT INTO awb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mi inínsónká maisarórabeq pokuro wehekáhmé mó weh anítégá Sarúsarama suwahpeq suera íre wahtotaq 11kírómíta Éméása suwahpeq koyehe éra ");
INSERT INTO awb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sísa pukú ehwehnsábé iwíáhéra iraruye. ");
INSERT INTO awb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mi anítégá ahtapeq nogera ehweh iraruyataq Sísaga sinehe kure moráráq nogúwe. ");
INSERT INTO awb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Sega we tagéra sirupipeq Sísa wire íwíáh íre orahuye. ");
INSERT INTO awb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Íre orahuyana wega sensabé, Aneq ehwéh mirareyo úwara sega mitaq kowéra sirupipeq umehúnsabe abiah máróye. ");
INSERT INTO awb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mó morá ání wenáwíq Kíópaga Sísansabé, Mah tanáhráq áhnte kegá Sarúsarama suwahpeq sure míahnah arebataq mirauro naneq íre ahtebahno kasenúwana ");
INSERT INTO awb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sísaga sensabé, Aneq mirauro naneqpo úwe. Úwara sega wensabé, Sísa Néhsara suwahpeqte ání éhwehne éra we Manikáne ehweh irarurai aní ména págege sansánéna págegeue íwáhnorurai puaq Manikánseq ite Asiu kereqka págege aní míre atáráúne. ");
INSERT INTO awb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iteribo iteruwah wehwárínseq Manikáne ehweh mibeq mahbeq arítáh kéreqka subiq súáhro arito urowara awankátaq táhpawe subiq sutowe. ");
INSERT INTO awb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Íre subiq sutotaq itega iwíáhéq, Wega ite Ísara ke kaweraitankéhe íwíáhuraune. Subiq sutotaqté ibora apahsoq kire. ");
INSERT INTO awb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iteruwahrah inínsónká miraonsabé áhtenéwone. Sega ahbiahipeq we maisatorabeq koragéra, ");
INSERT INTO awb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Wene anonka mitaq íre kéhre ewe. Sega iteba kouweéwótaq mahraréra, Maisatotaq iteiyuwanka tagehtaq íópeqté áníté tagóne. Mi anítégá itensabé, We aiq oga míéhre teieye ewe. ");
INSERT INTO awb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Minayabe mó iteruwahrah kegá koragéra mi inínsónká irarenserah tagéra pusa áníné anonka íre tagahwe uye. ");
INSERT INTO awb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mi anítégá mi ehwéh teawúyana Sísaga sensabé, Itewe múguwahgu iwíáhóye. Manikáne ehweh iraru kegá teié éhwéhnsábé íre apubúue aiq pútare aritoye. ");
INSERT INTO awb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Manikáne ehweh iraru kegá mahraréra, Wehuke merirena kaweraritankeheéna Manikánka omaq ato aní ebeq anotah érue pukéna anehemé téhráhnarabeq kinkéhe uwe. Minayabe ite íre ahtebehyo? Íre ahtebehyo éna Manikáne púkuipéqté éhwéh síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","We pukú ehwehnsábé Mósísiga sehgíóro ú ehwehnkákáq Manikáne ehweh iraru kegá sehiranu ehwéhnkákáq ebeq síwáhnoréna anehe moke mó pukúípéqté éhwéh síwáhnorue teriuwe. ");
INSERT INTO awb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mi anítégá pokoyeherauya ke suwahpeq wahtotaq kuyataq Sísaga mi aníté suena móbeq pokinaútaq ");
INSERT INTO awb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","sega we saiqnatera wensabé, Penkinainsabé itereq kaenéhe. Itereq kaenéhe uyana wega kowe éna nahtapeq kérirowe. ");
INSERT INTO awb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sega táhutahuroneheéra moráráq tútuue míówe. Sísaga páréti mewena Manikánsabe kaweróne atena páréti keqme náriuwe. ");
INSERT INTO awb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Náriuwara sega, We Sísa wire íwíáhuyana Sísawe tabanagúwe. ");
INSERT INTO awb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tabanagúwara seye náhenéra, Itega ahtapeq súnaraq wega Manikáne ehweh teiena íwáhnoritaq itene irupipeq áhnte eyóyóéwéhre uye. ");
INSERT INTO awb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sega apubúue irigue Sarúsarama suwahpeq kouwekéra airápété morá we kéró kereq momiwíuríó kereq tagoyara ");
INSERT INTO awb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","sega mi anítéyábé, Itene Wahnah aiq pútaq iriwe oganúkire. Oganúkirana Sáímóniga aiq tagehre uwe. ");
INSERT INTO awb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aiq tagehre uwara mi anítégá ahtapeq kutaq irarú ehweh teríúye. Teríéra, Páréti keqme náriutaq itega, Sísa wire úye teríúye. ");
INSERT INTO awb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","We kéró kega mi ehwéhnsábé ehwehnutaq Sísaga seba ákáhpi seiriwe ména sensabé, Pehwehribeq míáhro úwara ");
INSERT INTO awb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","sega anotah ahrééra, We wahnsa wíre íwíáhuwana ");
INSERT INTO awb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","wega sensabé, Aneqsabé áhreoo? Irupipeqmé aneqsabé iwíáh kikiroo? ");
INSERT INTO awb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Íné wíre ahtebagehboq niyahnkarankákáq nigáránkákáq tagahro. Wahnsawé íre anonkankakáq ayahnsankakaq áníne. ");
INSERT INTO awb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Íné wíre ahtebagehboq íné sosanoro éna wene ayahnkarankákáq aigáránkákáq sokigi ariuwe. ");
INSERT INTO awb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sokigi ariuwara áhtenéra iwíáh íwíáhéra Sísa oga míonsabe íre aiq pútare atahráhuwana wega sensabé, Táhutahuq mahtaq kehro úwara ");
INSERT INTO awb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","sega tira páh áwúwana ");
INSERT INTO awb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mewena sega tagotaq nówe. ");
INSERT INTO awb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sísaga we kéró keyabé, Mósísine ehwehnkakáq Manikáne ehweh iraru kegá sehiranu ehwéhnkákáq púkuipéqté ígónkónkákáq íné éhwehme aiq pútaraginawire. Menah iteba mía míaurautaq mina teiátáuge úwe. ");
INSERT INTO awb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Teiátáuge éna Manikáne ehweh kawerue irageheéna ahtebé iwíáh aritena ");
INSERT INTO awb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","sensabé, Manikáne ehwehnka mahraréna, Manikánka wehuke merirena kawerinieéna omaq ato anímé ebeq anotahtaq érue pukínana apahtáróráq iriwe oganúq atankéhe ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sísaga mó mahraréna, Wene púkuga mó mahraréna, Wenáwírue Manikánka kawerarítéh éhwéh ebeq Sarúsarama suwahpeq koreriera anehe mah kehiná kéhíná korerigéhe. Mi ehwéh irera sene ahbabáq súáh kéwé Manikánka kaweraritankéhe ire úwe. ");
INSERT INTO awb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sísaga mó mahraréna, Mi sehiránká aiq pútaragínaq tagagehe. ");
INSERT INTO awb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Manikánka itensabé, Néniwa eqmaraníe uraire. Ínéga kieqmarahnana iteba tuinkéhe. Mahtaq iteruwahpeq méq áwénunoro. Wega iteba tuena págege aitankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sísaga we kéró ke meriqmena Sarúsarama suwahpeq suena wahtotaq Pétáni suwahpeq kiuwe. Mitaq kowéna wene ayahnkara pankeqme Manikánsabe, Mah ke kawerarito úwe. ");
INSERT INTO awb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kawerarito éna se suowana Manikánka we íópeq tumerowe. ");
INSERT INTO awb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Íópipeq móatowara tago kegá Sísansabé sirehunseraráq méra iwíáh íwíáh atera sirupipeq anotahtaq eyoyóúwara Sarúsarama suwahpeq kouwekuwe. ");
INSERT INTO awb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kouwekéra Manikánsabe iwíáh íwíáh atáh náhtápéq kibekéra mitaq Manikánsabe iwíáh íwíáh ata atauwe. ");
INSERT INTO awb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Áwahewé Manikáne Ehweh ména we Maniká Iteriboba ména Maniká míowe. ");
INSERT INTO awb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Naho naho téhwe wereq Maniká Iteriboreq moráráq míóye. ");
INSERT INTO awb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mah Ehwéhnká moke ménsámehnsánkakaq ménkámehnkánkakaq wehukeakáq mirarowe. Pehipi íre kowe. Mó anínká íre mirarowana peh webataq wega moke mirarowe. ");
INSERT INTO awb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","We oga mía míai aní púana we wehuke míáhrabeq téhrehnka inserahni aní míre. ");
INSERT INTO awb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sunkíkírirabeq kánéqka téhrehnserah wega wehukega ahbabárorabeq kaweqtaq mía míaire. Sunkíkírinka kánéq íre puinsuahráhire. Mina inserah sene ahbabáronka wene kaweq arámbéhrí íre sabiruahráhowe. ");
INSERT INTO awb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Manikánka wehukení wenáwíq Sóni eqmarowe. ");
INSERT INTO awb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mó ke ehweh terinkeheéna eqmarowe. Kaweq arámbéhrí ání téhrehnka inserahni anínsábé terinkeheéna eqmarowe. Téhrehnka inserahni anínsábé ómiga aiq pútare atageheéna teriuwe. ");
INSERT INTO awb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sóniwe we íre mi aní míowe. Téhrehnka inserahni anínsábé terinieéna Sóniga súwe. ");
INSERT INTO awb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ómi kegá tagageheéna téhrehnka inserahni aní marakóipeq tumíowe. ");
INSERT INTO awb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mah marákó márákó miraro anínká mah marákóípéq tumíowara míó kega we íre tagaríówe. ");
INSERT INTO awb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wenawahrahba súwara sega we íre semehwehue kaweria peh áwé tagarúówe. ");
INSERT INTO awb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Peh morá Sísansabé aiq pútare atera áhrabo kegá Manikáne animárí úku úkuowe. ");
INSERT INTO awb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Íre iteinoibone korahq itene inonkapipéq kéh púaq Manikáne animárí míone. Íre iteitene iwíáhga Manikáne animárí míone. Íre iteriborehga maqmaranéhe íwíáhonka Manikáne animárí míone. Írakaumo. Peh morá Manikánka oganúq ítéhraq wene animárí míone. ");
INSERT INTO awb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Manikáne Ehwehnka wehukení úkue iteba tumíowe. We aiq pútari aní ména itensabé anotah arútábóírire. Wenaboga webataq wenahni téhreh naneqkakáq págegeakáq atowaq tagaraune. ");
INSERT INTO awb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sóniga Sísa sinaú ehweh teiena, Itensabé teiewómé mah anínsábé teiewóge. Íné íre míáhwataq we mía míaú ani púana inehe si anímé íné kiotaiqme aní mía míaire úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wene arupipeq peh kaweq iwíáhi aní púana itensabé arutaboiréna itene irupipeq eyoyó aitéhre. ");
INSERT INTO awb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Manikánka sehgíóro ú ehweh Mósísiga teiuwana Sísa Karáhé tuména itensabé arutaboiraitena aiq pútaq ehwéh teíre. ");
INSERT INTO awb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iuranka Maniká Iteribo íre tagahrahune. Peh morá wenahni abowáreq mía míai anínká abowáné sánsá tei teinire. ");
INSERT INTO awb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sarúsarama suwahpeqte Asiu kegá Manikáne ehweh mibeq mahbeq arítáh kéreq Áríwái kereqsabé, Sóni kogasenoro éra eqmaq súówe. Eqmaq súówara Sóniba séra kasenéra, Are insebo uwe. ");
INSERT INTO awb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Are insebo ue kasenuwana Sóniga pahsuqme teriuwe. Pahsuqme teriena, Manikánka ite meirena kaweraitankeheéna peh morá ání omaq atowe. Ínéwé íre mi aní úge úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Úwara sega wensabé, Árahinsabébo? Are insebo? Are Manikáne ehweh irarú ani wenáwíq Éráísabo uwana Sóniga, Írakaumo úwe. Írakaumo úwara, Are áwénunúna aní, Manikáne ehweh iraréna anípo uwana, Írakaumo úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Írakaumo úwara sega wensabé mó kasenéra, Are insebo? Ite eqmaq íúwéhnarabeq ehweh terienéhboq teio. Arewe aneq aní múge íwíáhono uwe. ");
INSERT INTO awb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Uwana Sóniga sensabé, Áísáíaga naho mirarúnserah íné uworapeqté sawai sawaiu aní múge. Wahnah sína ahmé obaríráhro u aní múge úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Péhrasi kegá eqmaq súówara su kegá Sóninsabé mó kasenéra, ");
INSERT INTO awb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Manikánka ite meirena kaweraitankeheéna peh morá ání omaq atowe. Arewe íre mi aní móne. Arewe íre Éráísa wone. Arewe íre áwénunúna aní, Manikáne ehweh irari aní móne. Minayabe árahinsabé wání meri merinono uwe. ");
INSERT INTO awb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Uwana Sóniga sensabé, Ínéga peh wání meriú aní múge. Inehe si aní, itega íre tagaríáh ánímé ite míáhpí ákáhpi iriwe míéhre. ");
INSERT INTO awb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Inehe si anímé anotah anínéna íné kiotaiqme aní míre. Minayabe íné inehe si aníné súu nahníáq pugereyabe íre awehrari aní múge. ");
INSERT INTO awb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Marakó áwíq Pétánie. Mi marákóráq Sorana aroipéq seberaebéq kéhrana Sóniga mitaq wání meriena mi ehwéh teriuwe. ");
INSERT INTO awb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ahbiah tahnsá Sísaga Sóniba súwana tagéna mahraréna, Tagaríáhro. Manikáne Sipisípiq Áráhqka mah kehiná kéhínáné ahbabáq meyankéhe. ");
INSERT INTO awb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mah anínsábé teiewarauge. Íné íre míáhwataq we mía míaú aní púana inehe si aní íné kiotaiqme aní mía míaire. ");
INSERT INTO awb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ínéwé we mía míai aníne ue íre tagariarauge. Ísara kegá we mía míai aníne ue tagariageheéna wání meri merinuge úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sóniga mó mahraréna, Manikáne Awanka tunse kiboki táhnsánuena weba márunsurahurairana tagarauge. ");
INSERT INTO awb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Téhwe ínéga we íre niahtebarauge. Ínéga wání meri merininkeheéna eqmaq núwátái anínká teniena, Manikáne Awanka weba tumíarai anínká wewega Manikáne Awa inkéhe uraire. ");
INSERT INTO awb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Íné mina aiq tagéna teiúge. We Manikáne ahninkáwá wíre úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ahrina tahnsá Sónireq we kéróya anítéreq mó iriwe míówe. ");
INSERT INTO awb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sísa noguwana Sóniga tagéna mahraréna, Tagaríáhtao. We Manikáne Sipisípiq Áráhq míre úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Úwara Sóni kéróya anítégá wene ehweh irera Sóni auwera Sísa kéróye. ");
INSERT INTO awb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sísa kéróyana wega pabeqme se tagéna sensabé, Aneq sahroyo úwe. Aneq sahroyo úwara sega wensabé Árábáio, are ahbeq kaegaeono uye. Mi áwíq Árábáiwé áwahewé Íwáhnoraníne. ");
INSERT INTO awb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Uyana wega sensabé, Seragahtao úwara sega we kérera Sísa kaegaeúrabeq tagoye. Íó tunsorerutaq sega weba mitaq míóye. ");
INSERT INTO awb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sónine ehweh irera se Sísa kéróya aníté mó aní áwíq Ehntarue. We Sáímóni Pítane ábákawae. ");
INSERT INTO awb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ehntaruga mitaq auwena wenawah Píta anebahréna tagéna wensabé, Manikánka omaq ato anímé Mésáía míéhrana aiq tagoge úwe. Mésáíawe áwahewé ite meirena kaweraitankeheéna Manikánka omaq ato aní míre. ");
INSERT INTO awb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aiq tagoge éna wenawah meqmena Sísaba móatowe. Sísaga Píta ebitáwéna wensabé, Are Sáímónie. Are Sónine ahninkáwá wóne. Mó kegá mó awíq Sípásie áwíratagéhe úwe. Sípásiwe Pítawe peh morá éhwéhnéna áwahewé ebah mire. ");
INSERT INTO awb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mó ahrina tahnsá Sísaga iwíáhéna, Íné Kehrari marákórápéq pokinie íwíáhéna wehukení wenáwíq Pírípi tagéna wensabé, Séniro úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pírípiwe Pétásáíra suwahpeqte áníne. Ehntarureq Pítareq moq mibeqté ánítée. ");
INSERT INTO awb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pírípiga Nátáníéri koragéna wensabé, Mósísiga sehgíóro ú ehwehnká tei teinu anímé Manikáne ehweh iraru kega sehiranue tei teinu anímé míéhraq tagóne. We Sósépane ahninkáwáe. We Néhsara suwahpeqte ání wenáwíq Sísae úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Úwana Nátáníériga wensabé kasenéna, Néhsara suwahpeqte kaweq anímé serahiro úwana Pírípiga wensabé, Seragáhno úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nátáníériga Sísaba súwana we tagéna mahraréna, We aiq pútaq kaweq Ísara aníne. Wene arupipeq íre péhe íwíáhi aníne úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Úwana Nátáníériga Sísansabé, Arewe árahue íné tagariahno úwana Sísaga wensabé, Pírípiga arensabé íre áhrabirana tagoge. Are awanká nona míahnana tagoge úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Úwana Nátáníériga Sísansabé, Íwáhnoraníno, are Manikáne ahninkáwá wóne. Are Ísara kené anotah wahnáh ání móne úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Úwana Sísaga wensabé, Are awanká nona míahnana tagoge teawu púah aiq pútare aintahno? Pehgáriq otáq sánsá amahnága mirauge. Mókake anotah otáq sánsá tagankehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sísaga wensabé mó mahraréna, Kawerue írátíahno. Mókake íópeq sawekínaraq tagankehe. Íópeq sawekínaraq Maniká míéhrabeq íópeqté kégá íné wehukení úku anípá we kiotaiq we tuotairira tagankehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ahrina tahnsá Kéána suwahpeq Kehrari marákórápéq pahuwiraritórabeq taganieéna Sísane anowa mitaq míowe. ");
INSERT INTO awb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Sísareq ite we kérahwána kereqsabé, Pauarítáhrabéq tagagehboq máhoro úwaq sewane. ");
INSERT INTO awb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mibeqté náhníáq sera ano parabagútaq Sísane anowagá wensabé, Sera ano aiq parabagire úwe. ");
INSERT INTO awb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Úwana Sísaga wensabé, Minawé íre itereq wehgaq mire. Ínéga ótaq sansá mirau tanáhráq íre suríéhre úwe. ");
INSERT INTO awb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Úwana Sísane anowagá arambehri keyábé, Wega miraoro ína ehwéh kawerue sehgíóro úwe. ");
INSERT INTO awb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Abapete morá wání ántéhyá mitaq kowe. Anotah antéhyámárí kéna Asiu kegá sene pabeq pabeq sansa miraigeheéna mitaq kowe. ");
INSERT INTO awb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sísaga sensabé, Antehyamárípípéq wání obenkíq máráhro úwara obenkíq márówe. ");
INSERT INTO awb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Obenkíq márówana Sísaga sensabé, Uwe táhutahuq wahnáh mewe móáwéro úwana wánínka náhníáq sera ano úkúwe. ");
INSERT INTO awb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sega uwera mewera móáwúwana táhutahuq wahnáhnká mi será ano nawe tagéna áhtenúwe. Wání antéhyá obenkíq márótaq táhutahuq wahnáhnká íre tagariowara peh morá arambehri kegá tagaríówe. Táhutahuq wahnáhnká náhníáq sera ano nawe tagéna o menáhwé áhrabúwe. ");
INSERT INTO awb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Áhrabéna wensabé, Kiraboo kene sánsámé sene kaweq nahníáq sera ano ebeq nárigéhe. Nehra kegá siyahbankirahnaraq íre tei será ano nárigéhe. Arega mina onserah íre miraóne. Arega áhnte tei será ano matawé anehe náiene úwe. ");
INSERT INTO awb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Minawé Sísaga ebeqte ótáq sánsá Kéána suwahpeq Kehrari marákórápéq miraúwe. Wega ótaq sansá miraúwara míó kega tagéra áhtenuwe. Mitaq ite we kérahwána kegá wensabé aiq pútare atahwáne. ");
INSERT INTO awb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sísareq wenanoreq wenábáqmarinseq ite we kérahwána kereqka mitaq sueq Kápénéáma suwahpeq pokue táhmaro wehekáh mitaq kowíahwane. ");
INSERT INTO awb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ite Asiu kené sótaikú iahreraq ko tánáhráq wahtotarútaq Sísaga Sarúsarama suwahpeq kiuwe. ");
INSERT INTO awb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kiena Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq kibekúwara sipisípiqkakáq káhoakáq kibokiakaq móneakáq paiqnanánu ke tútuue míówe. ");
INSERT INTO awb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tútuue míówana Sísaga susa náhgáqtáté pawa kíráwe mi nahgáqtáté moke paiqmáró keakáq sene ménkámehnkánkakaq máhpeq kaqsuowe. Kaqsuena móne paiqnanánu kené móne paentáruena sene wéhuwehu tahbéwárí pioruowe. ");
INSERT INTO awb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pioruena pina paiqmáró keyabé, Minawari mewe móáráhro éna Nánibone nahtapeqté mátábúrápéq paiqnanániyeho úwe. ");
INSERT INTO awb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Úwaq ite we kérahwána kegá minawarí tagéq Manikáne sehira iahreraq kowe. Mi sehiránká mahraréna, Arene nahnsabe anotahtaq iwíáh íwíáhéna peh kawetaq kankeheéna págege sansá mirauge ire. ");
INSERT INTO awb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Asiu kegá Sísansabé, Árahinsabé kaqsuahno? Arega kaqsuahnayabé ótaq sansá sokigi aio uwe. ");
INSERT INTO awb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Uwana Sísaga sensabé, Mah nah Manikánsabe iwíáh íwíáh atáh náh sokoruehrana ínéga apahtáróráq mó pearaníe úwe. ");
INSERT INTO awb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Úwara Asiu kegá wensabé, Mah nah pe arámbéhríwé áhnte opéq 48 opéq arambehriue pearówe. Arega peh apahtáró wéhékáhmé árahue pearanibo uwe. ");
INSERT INTO awb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sísaga íre nahnuransabé peh wene anonkansabé irarúwe. ");
INSERT INTO awb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sísa pukúwana oganúq atotaq ite we kérahwána kegá mi ehwéh iahreraq matiahwane. Iahreraq matiahwanayabé itega Manikáne sehirankakaq Sísaga teiu ehwéhnkákáqsábé aiq pútare aritahwáne. ");
INSERT INTO awb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ite Asiu kené sótaikú iahreraq ko táhútáhúq tánáhráq Sísaga Sarúsarama suwahpeq míowe. Míotaq wega ótaq sansá miraúnsabe áhnte kegá wensabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sísaga ómi mi kehináné sirupipeq tagario púana sensabé íre aiq pútare aritowe. ");
INSERT INTO awb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mó kegá Sísa íre teawúwana peh wewega wehukene sirupipeq tagariowe. ");
INSERT INTO awb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Péhrasi aní wenáwíq Níkóríma anotah Asiu aní ména ");
INSERT INTO awb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","inokáhpeq Sísaba séna wensabé, Íwáhnoraníno, are Maniká míéhrabeqte ání móne. Aiq tagaríóge. Arereq Manikánseq moráráq mía míaóya puah arega ótaq sansá miraóne úwe. ");
INSERT INTO awb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Úwana Sísaga wensabé, Kawerue írátíahno. Peh morá wenanoga maqmaréhnsábé íre awehraq kéhre. Manikánka wahnah wahnahnirabeq kioráhi aní mónkakáq maqmarankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Úwana Níkórímaga Sísansabé, Árahiro? Anonusa áníné anowagá mónkakáq íre maqmarahráhire. Wenanoga árahue mónkakáq maqmarankéhbo úwe. ");
INSERT INTO awb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Úwana Sísaga wensabé, Kawerue írátíahno. Arenanoga maqatáráinsabé íre awehraq kéhre. Peh morá Manikáne Awanka maqmaréh ánínká Manikánka wahnah wahnahnirabeq kioráhire. ");
INSERT INTO awb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wehukenínká peh mó áwáhu wehukéní maqmarahráhire. Manikáne Awanka webataq o awá maqmarahráhire. Maqmarena inkéhe. ");
INSERT INTO awb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Arenanoga maqatáráinsabé íre awehraq kéhre. Peh morá Manikáne Awanka maqmaréh ánínká Manikánka wahnah wahnahnirabeq kioráhire teawúnsábé íre áhtenúno. ");
INSERT INTO awb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sóiriqka pehipi sirah tagáhne. Sóiriq eheqte sirapómo? Eheq pokirapómo? Are íre tagariahne. Mina inserah Manikáne Awanka o awá maqmarena inkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Úwana Níkórímaga Sísansabé, Minayabe árahiro ");
INSERT INTO awb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","úwana Sísaga wensabé, Are Asiu ke síwáhnoróna aní móne. Minawé árahinsabé íre irahno? ");
INSERT INTO awb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kawerue írátíahno. Íné író éhwéh iraréna íné tagonsabé teawúgah arega néne ehwehnsabé íre aiq pútare aintahne. ");
INSERT INTO awb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Marakóipeqté teawú náneqmarí arega íre aiq pútare aintahnayabé Maniká míéhrabeqte éhwéh teawenah árahue aiq pútare aintaníbo? ");
INSERT INTO awb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mó anínká Maniká míéhrabeq íre kíre. Peh morá wehukení úku anínká ínébataq mitaq mía míaéna marakóipeq tumíarauge. ");
INSERT INTO awb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mósísiga káhpahraté miraro wehe uworapeq awankátaq táhparena pankeqme pearonserah sega íné wehukení úku aní pankeragéhe. ");
INSERT INTO awb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ínénsabe aiq pútare aintáh kégá oga mérapeq aiq awaq míáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Manikánka mah kehiná kéhínánsábé anotah arútábóíri puana webataq wenahni eqmarowe. Wenahninsábé aiq pútare atáh ké íre toráh agia peh oga mérapeq awaq mianehrawoe. ");
INSERT INTO awb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wenahninká mah kehiná kéhíná ehweh aritankeheéna eqmaroo? Írakaumo. Mah kehiná kéhíná kaweraritankeheéna eqmarowe. ");
INSERT INTO awb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Manikánka wenahninsábé aiq pútare atáh ké íre ehweh arítéhre. Manikánka wenahninsábé íre aiq pútare atáh ké ehweh arítéhre. Webataq wenahninsábé íre aiq pútare atáh púana ehweh aritena anotah abíáhnsá arita aritaire. ");
INSERT INTO awb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Téhrehnka inserahni anínká marakóipeq tumíowe. Mahbeqté kégá ahbabáq aruqaruronsabé sunkíkírirabeqsabé suwahbéna téhrehrabeqsabé íre suwahbówe. Minayabe ehweh arítéhre. ");
INSERT INTO awb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ómi ahbabáq kega téhrehrabeqsabé suwahriehnsabé mitaq íre séyéowe. Mó kegá sene ahbabáqmari tagehoéra téhrehrabeq íre séyéowe. ");
INSERT INTO awb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Peh kaweqtaq mía míao kegá téhrehrabeq séyéowe. Manikánka págege arítéhrara mirao arámbéhrí mó kegá tagageheéra téhrehrabeq séyéowe. ");
INSERT INTO awb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sísareq ite we kérahwána kereqka Sarúsarama suwahpeq sueq Súría marákórápéq pokowane. Sísaga iteba mitaq ména mó ke wání meriuwe. ");
INSERT INTO awb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Sóniga Serima suwahpeq wahtotaq Inona arahno korabeq míowara áhnte waní ko púara mó kegá mitaq suwana Sóniga wání meriuwe. ");
INSERT INTO awb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mi tanáhráq mó kegá Sóni íre karábúsiipéq móátówe. ");
INSERT INTO awb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Asiu anínseq Sóni kéró kereqka wání sosue sansánsábé ehwehéra Sóniba suwe. ");
INSERT INTO awb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sóniba séra wensabé, Íwáhnoraníno, arereq Sorana aroipéq seberaebéq mitaq teiátóna anímé wega mahtaq ména wání merírara ómiga are auwera weba pokowe uwe. ");
INSERT INTO awb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Uwana Sóniga sensabé, Manikánka webataq itene arambehri tei teinire. ");
INSERT INTO awb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Manikánka ite meirena kaweraitankeheéna peh morá ání omaq atowe. Ínéwé íre mi aní úge teiátáu mino. Manikánka íné ebeq eqmaq núwátáire teiátáu mino. ");
INSERT INTO awb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ibehinínká wenawehqpa pokinserah amahnága ómiga Sísaba poku pokuowe. O menáhwéné iyahnabo anínká mitaq ména wene ehweh irena wene arupipeq eyoyóinserah amahnága ómiga íné nuera weba pokonsabé nirupipeq eyoyóire. ");
INSERT INTO awb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","We anotah aní úkínana íné pehgáriq aní úkono úwe. ");
INSERT INTO awb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Maniká míéhrabeqte tutai aní peh anotah aní ména moke mó ke kiotaikire. Marakóipeqté ání peh mahtaqté ání púana peh mahtaqté sánsánéna mahtaqté éhwéh tei teinire. Maniká míéhrabeqte tutai aní peh anotah aní ména moke mó ke kiotaikire. ");
INSERT INTO awb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","We anotah aní ména wega tagaríéh náneq írátíéh náneq ehwéh teíraq itega íre íráhwe. ");
INSERT INTO awb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wene ehweh kawerue íráh kégá, Maniká aiq pútaq aní míre atáhwe. ");
INSERT INTO awb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Manikánka eqmaro aninká Manikáne ehweh kawerue tei teinire. Manikáne Awanka weba mía míai puana peh kawerue tei teinire. ");
INSERT INTO awb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Manikánka wenahninsábé arutaboiréna moke auráq matiahno atéhre. ");
INSERT INTO awb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wenahninsábé aiq pútare atáh kégá oga mérapeq aiq awaq míáhwe. Wenahniné sánsánsábé suwahrieh ke oga mérapeq íre awaq miowana Manikánka anotah abíáhnsá arita aritaire úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mó kegá Péhrasi keyábé, Peh táhmaro kegá Sóniba suwana wání meríátáire. Áhnte kegá Sísaba suwana wání meríátáire uwe. ");
INSERT INTO awb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Írakaumo. Sísaga wání íre meriuwaq peh morá ite we kérahwána kegá meriewáne. ");
INSERT INTO awb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sísaga mi ehwéh irotaq wereq itereq Súría marákórápéq sueq Kehrari marákórápéq mónkakáq kouwekowane. ");
INSERT INTO awb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Itega Sámáría marákó kótaikoneheowane. ");
INSERT INTO awb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sámáría marákó kótaikowanaraq Sáíka suwahpeq koneheowane. Koneheowanaraq Sékópaga wenahni Sósépa awu marákórápéq kowane. ");
INSERT INTO awb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sékópaga ubuqmaro matáípéqté wání mitaq kowe. Kowana Sísaga íre wahto nogu púana tawa tawanéna wéhékáhnabubu mitaq tútuue míowe. ");
INSERT INTO awb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ite Sísa kérahwána kegá Sáíka suwahpeq tópah sahq kowanaraq Sámáría inínká wání sabatáhq súwe. Sísaga wensabé, Wání nánio úwana ");
INSERT INTO awb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sámáría inínká wensabé, Íné Sámáría iní múge. Are Asiu aní míahna puah aneqsabé wání nánio eno úwe. Sámáría kegá néu antéhyápíté Asiu kegá íre néunsabe kasenúwe. ");
INSERT INTO awb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sísaga wensabé, Arega Manikánka aweráhi naneq íre tagariahne. Wání nánio teawú ání íre tagariahne. Arega tagariahnaraq tahirí oga mé waní nánio énana náwú irino úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Úwana mi inínká wensabé, Mi matáípéqté wání íre wahto mire. Are antehya íre matiahne. Oga mé wanímé eheqte uwe nániníbo? ");
INSERT INTO awb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iteinahbú Sékópaga mi matáípéqté wání iuwe. Sékópareh karírónánínseq wene ménkámehnkámarinseqka mitaq nowe. Arega ínénsabe, Íné oga mé waní aweráhu aní múge énayabé arewe Sékópa kiotaiqme míahna anípo úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Úwana Sísaga wensabé, Mipéqté wání nehra ke mótaq mó tahbobóoneherawoe. ");
INSERT INTO awb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Náwéna waní nehnaraq mó íre tahbobóinawire. Írakaumo. Náwéna waní nehnaraq arupipeq oga mía mía aráhnó tahnsa tuerueinae úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Úwana mi inínká peh mataipéqté wánínsábé wíre íwíáhéna wensabé, Mahtaq séyéyabe nuwahriehre. Mó tahbobóínehboq teniena waní nánio úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Úwana Sísaga wensabé, Arenawehq koweqme setao úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Úwana, Íné íre nánuwehqkakaq ání múge úwana Sísaga wensabé, Íné íre nánuwehqkakaq ání múge tenienayabé aiq pútaróne. ");
INSERT INTO awb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Arega mó weh mewe mipinsuq mó weh mewe mipinsurue moberíáh wéh mewe sutona wino. Amahnága kérahna wehwé íre arenawehrurá míre. Minayabe aiq pútaróne úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Úwana mi inínká wensabé, Are moke íné éhweh írátíahna puah íné iwíáhume are Manikáne ehweh iraréna aní móne. ");
INSERT INTO awb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Itene igaqnaréhga mah sawéhráq Manikánsabe iwíáh íwíáh ata atauwe. Arenanahbúréhga iwíáhéra, Sarúsarama suwahpeq Manikánsabe iwíáh íwíáh ata ataoro ewe. Manikánsabe ahbeq íwíáh íwíáh atanéhnkono úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Úwana Sísaga wensabé, Aiq pútare ainto. Mókakewe íre peh mi sawéhrápéqkákáq Sarúsarama suwahpeqkakáq wehukega Manikánsabe iwíáh íwíáh ataneherawoe. ");
INSERT INTO awb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ite Sámáría kegá iwíáh íwíáh atáh náneq íre írátíáhwe. Ite kaweraitahna aní Asiu aní púaq Asiu kegá iwíáh íwíáh aintáh ání tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mókakeakáq amahnágaákáq Manikáne Awanka págege arítéh kégá aiq pútaq sansánéra Manikánsabe iwíáh íwíáh atéhrataq sebataq Iteribonsabé kawerue iwíáh íwíáh atáhwe. Iteriboga mina tahnsa ké wensabé iwíáh íwíáh atáhnsábé awahbehre. ");
INSERT INTO awb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Maniká íre áúakaq anínéna peh Wenawanka mía míaire. Minayabe kawerue iwíáh íwíáh atagéhboq iteiuwanka Manikánsabe iwíáh íwíáh ateq aiq pútaq sansánoro úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Úwana mi inínká wensabé, Íné írátíómé ite meirena kaweraitankeheéna Mésáía, Manikánka omaq ato anínká sinawire. We sínagake moke teinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Úwana Sísaga wensabé, Arega iraréna anímé íné úge úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Úwaq ite Sísa kérahwána kegá kouwekowane. Sísareq mi inínseqka ehwehnuyansabé áhtenowane. Áhtenéq Sísansabé, Árahono? Aneqsabé ehwehnoyo íre iraria peh ehiya míahwane. ");
INSERT INTO awb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mi inínká wene wání antehya mitaq marena wenawahpeq pokéna wenawahrahyabé, ");
INSERT INTO awb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Máhoro. Peh morá ání íné íre tagarai anínká moke ínéga mirau naneqmarí pahqnúéhre. We seragahro. We Manikánka omaq ato anípómo. Seragahro úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Úwara sega sensuwahpeq suera Sísaba suwe. ");
INSERT INTO awb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sámáría kegá áhníbórá sutaq ite Sísa kérahwána kegá wensabé, Íwáhnoraníno, táhutahurúno ewanana ");
INSERT INTO awb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","wega itensabé, Íné itega íre tagaríáh táhútáhúq kéhre úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Úwaq iteite náhenéq, Mó anínká táhutahuq awirápómo ehmuniq éhmúníqtaq irarewane. ");
INSERT INTO awb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sísaga itensabé, Íné eqmaq núwátái aníné arambehriwe néne táhutahuq mire. Mina mirainauge. ");
INSERT INTO awb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Itaréitaré íó parabagínaraq onkiyonsá nera kéh tánáhráre iyeho. Amahnága tagaríáhro. Onkiyonsá áhnte nera kéhnserah Maniká Iteribo íre tagaríáh ké áhnte míáhwe. ");
INSERT INTO awb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Onkiyonsá nera kéhrara mirauwíáhnserah oga mérapeq wehuke mórítáhro. Móriteq oga mía mía apéq meyagéhe. Manikáne ehweh teri terino kereq wehuke mórítáh kéreqne irupipeq eyoyóinkehboq mórítáhro. ");
INSERT INTO awb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iteinahbúréhga mahraréra, Mó kegá ayu uqmatowara mó kegá onkiyonsá mirauwíáhwe uwe. Mina unserah mó kegá Manikáne ehweh teri terinowara mó kegá wehuke meriqmera mórítáhwe. Sega mahraru ehwéh aiq pútaragire. ");
INSERT INTO awb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ínéreq mó kereqka Manikáne ehweh teri terinonaq ite wehuke meriqmeq Iteriboba móritageheéna eqmaq íúwóge. Teri terinúnayabé ite áhnte meriqmeq móritagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mi inínká, Moke miraú naneqmarí teníre únsabe áhnte Sáíka suwahpeqte Sámáría kegá Sísansabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aiq pútare atera Sísaba séra wensabé, Máho. Iteruwahpeq sewíahno uwana Sísaga téhtaréráq sensuwahpeq kowíowe. ");
INSERT INTO awb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sísaga mitaq síwáhnorúnsabe áhnte mó kegá aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aiq pútare atera mi inínsábé, Íre peh morá arega teienayabé aiq pútare atone. Ite wene ehweh kawerue ironayabé wensabé aiq pútare atone. We aiq pútaq mah kehiná kéhíná meirena kaweraitéh ání míre atone uwe. ");
INSERT INTO awb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sísaga mitaq téhtaréráq ména suena Kehrari marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sísaga naho mahraréna, Manikáne ehweh irari aní mó ke suwahpeqte kégá iwíáh íwíáh atáhwe. Peh morá wenawahrahga wensabé íre iwíáh íwíáh atáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sísaga Kehrari marákórápéq pokútaq mibeqté kégá eyoyóue mehweh atówe. Sega Sarúsarama suwahpeq táhutahuq notaq Sísaga miraú arámbéhrí aiq tagaríówe. Menah miraú arambehri tagaríó púara eyoyóue mehweh atówe. ");
INSERT INTO awb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sísaga Kéána suwahpeq Kehrari marákórápéq wánítate náhníáq sera ano mirarorabeq mónkakáq pokúwe. Kápénéáma suwahpeqte wáhnáh wenawahpeq míowana wenahni anotah awáhréúwe. ");
INSERT INTO awb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mi wahnáh ánínká Sísaga Súría marákó suena Kehrari marákórápéq sire u ehwéh irena Sísaba pokue wensabé, Nénahni pukinaire. Arega nánuwahpeq segawerato éna pagu pagunúwe. ");
INSERT INTO awb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sísaga wensabé, Arega ótaq sansá tagéyabe awahbehre. Pehipi íre aiq pútare aintahne úwe. ");
INSERT INTO awb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Úwana wega Sísansabé, Nénahni pukínehboq peheráh súno úwana ");
INSERT INTO awb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sísaga wensabé, Pokúno. Arenahni oga míanawire úwana mi wehgá Sísane ehwehnsabé aiq pútare atena pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ahbiah tahnsá wene nahtapeqsabé séwotaq wene arambehri kereq ahtapeq piehgíúwe. Sega wensabé, Arenahni kaweragirana oga míéhre teawúwe. ");
INSERT INTO awb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Teawúwana wega sensabé, Aneq tanáhráq kaweragiro úwara sega wensabé, Inokáh tunsoreráitaq kaweraguraire uwe. ");
INSERT INTO awb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Uwana abowágá iwíáhéna, Sísaga, Arenahni oga míanawire teníátái tanáhráq peh monseráh tánáhráre úwe. Minayabe moke mi karírónánínká Sísansabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sísaga menah Súría marákó suena Kehrari marákórápéq séna anehe mi otáq sánsá Kéána suwahpeq miraúwe. ");
INSERT INTO awb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mó tanáhráq Asiu kegá Sarúsarama suwahpeq táhutahuq norabeq Sísaga koraganieéna pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sarúsarama suwahpeq kurirapéqté ónsá áwíq Sipisípiq Onsáe. Onsarapéqté kégéu ah ayehrápéq wání káwehu kowe. Íbaru ehwéh, Asiu kené ehwehme mi kawéhú áwíqmé Pétésárae. Mi kawéhú ayehrápéq moberíáh atataia náhmárí kowe. ");
INSERT INTO awb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mitaq áhnte awáhré ké íre sugia peh surahpeq míówe. Aigárá soriqnahnu kereq aura pira kéreq ah íre nogoráhu kereq mitaq míówe. ");
INSERT INTO awb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Maniká míéhrabeqte íópeqté ánínká mó tanáhráq mó tanáhrárue mi waní áwíoq áwíorúwe. Áwíoq áwíorútaq ebeq tu awáhré áníné anepeq wánínka tabagúwana wene awahre suansúá kaweragúwe. Minayabe áhnte awáhré kégá kaweraginkeheéra káwehu ahtáq sáhuríówe. ");
INSERT INTO awb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Peh morá ánínká peh íregáritaq opéq 38 opéq awahreúwe. ");
INSERT INTO awb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","We surahpeq míowana tagéna we áhnte opéq awahreúmé Sísaga tagariowe. Tagarawéna wensabé, Awaho ani méyabe awiro úwe. ");
INSERT INTO awb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Úwana mi anínká Sísansabé, Wánínka aroroitaq mó anínká wánípipeq íre meniqmena máruníntéhre. Íné tue tueutaq mó anínká ebeq tubaiqme tubaiqmeowe úwe. ");
INSERT INTO awb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Úwana Sísaga wensabé, Irigúno. Arene máhriq mewe pokúno úwana ");
INSERT INTO awb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","we suansúá kaweragúwana kie irigue wene máhriq mewena pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Minayabe Asiu kegá kawerato aninsábé, Iboramé ahrena ahrena wehekáh míre. Arene máhriq mewe nogíneho uwe. ");
INSERT INTO awb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Uwana wega sensabé, Íné kaweraintéh ánínká, Arene máhriq mewe pokúno teníre úwe. ");
INSERT INTO awb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Úwara sega wensabé, Arene máhriq mewe pokúno teawí ánímé inseboue kasenuwe. ");
INSERT INTO awb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Áhnte wehekéqká paitíó púana Sísa íre ábóraq míowe. Íre ábóraq míonsabe kawerato anínká sensabé, Kaweraintéh ánímé íre tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Anehetaq Sísa Manikánsabe iwíáh íwíáh atáh náhtápéqté mátábúrápéq ména kawerato aní tagéna wensabé, Amahnága awaho ani míahne. Mó awahreurona serahninehboq móme íre ahbabárúno úwe. ");
INSERT INTO awb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kawerato anínká pokue Asiu ke tagéna sensabé, Íné kaweraintéh ánímé Sísae teriuwe. ");
INSERT INTO awb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sísaga ahrena ahrena wehekáh mi aní kaweratonsabe Asiu kegá Sísa áwíoqnowe. ");
INSERT INTO awb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Áwíoqnowana Sísaga Asiu keyábé, Nániboga ahriahri arambehrii puana ínégaakáq arambehriuge úwe. ");
INSERT INTO awb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sísaga ahrena ahrena wehekáh arambehriúnsabe Asiu kegá abiahnsanéra subiq suanéhe íwíáhuwe. Sísaga Manikánsabe, Nániboe atowe. Manikánsabe, Nániboe atonsabe Asiu kegá mahraréra, Wega, Ínéreq Manikánseq monseráh áníté úye irarime anotahtaq íre kawerire éra suboneheqmúne íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sísaga sensabé, Kawerue írátíáhro. Íné wenahninká pehipi íre miraorahuge. Nánibone arambehri tagéna wega mirainserah íné wenahninká mirauge. ");
INSERT INTO awb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nániboga íné wenahninsábé arutaboiraintena wene sánsá moke teni teninire. Wega mó kiotaiqme arámbéhríákáq sokigi aintankéhe. Minayabe itega áhtenigehe. ");
INSERT INTO awb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nániboga puko ke iriwe oganúq sítéhnserah íné wenahninká iwíáhu ke oganúq sitahráhuge. ");
INSERT INTO awb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nániboga mah kehiná kéhíná íre ehweh arítéhre. Ehweh arámbéhríwé moke íné wenahninsábé, Ehweh arito aintéhre. ");
INSERT INTO awb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nánibo áwíq pankerera iwíáh íwíáhonserah íné wenahni níwíq ómiga pankerera iwíáh íwíáh aintageheéna ehweh arito aintéhre. Íné wenahninsábé suwahrieh kegá eqmaq núwéh ání Nánibonsabé íre iwíáh íwíáh atáhwe. ");
INSERT INTO awb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kawerue írátíáhro. Néne ehweh irera íné eqmaq núwéh ánínsábé aiq pútare atáh ké oga mérapeq aiq awaq míáhwe. Ínéga se íre ehweh aritaníe. Pukia ánímárí tahnsa méra oganúkue mía míaowe. ");
INSERT INTO awb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kawerue írátíáhro. Amahnágaákáq mókakeakáq pusa kégá íné Manikáne ahninkáwáné ehweh iragéhe. Irera oga mía míaigehe. ");
INSERT INTO awb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nániboga oganúq itahráhinserah íné wenahninká moq oganúq itahráhuge. Nániboga oganúq sito aintéhre. ");
INSERT INTO awb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nániboga ínénsabe, Are wehukení úkóna aní míahna puah ahbabáq keyabé ehweh arito aintéhre. ");
INSERT INTO awb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Mókake ómi pukia ké maisaráhrabeqte kégá néne ehweh iragéhe. Íréhrataq kie irigigehe. Kaweqtaq mía míao keyábé, Oga mérapeq pokoro aritaníe. Ahbabáq aruqaruro keyábé ehweh aritena, Iraipéq pokoro aritaníe. Ínéga iraru ehwéhnsábé íre áhtenoro úwe. ");
INSERT INTO awb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sísaga mó mahraréna, Ínébataq íre miraorahuge. Íre peh morá ínénéne iwíáhe. Íné eqmaq núwéh áníné iwíáh írátíó púana kawerue wahnahnarítóge. ");
INSERT INTO awb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Néne sánsánsábé ínébataq teiútáq tahirímé íre aiq pútare aintáhro teiú irino. ");
INSERT INTO awb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Néne arambehriyabé Nániboga teíre. Néne sánsánsábé irari ehwéh aiq pútaq ehwéhne. Mina aiq írátíóge. ");
INSERT INTO awb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Itega wehuke Sóniba eqmaq sutowana wega aiq pútaq ehwéh iraréna néne sánsánsábé teríátáire. ");
INSERT INTO awb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Íre peh wehukene ehweh írátíóge. Ite oga mía míaigeheéna mah ehwéh teiúge. ");
INSERT INTO awb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ah tagageheéna áráhmuga téhrehnserah itega íné tagariageheéna Sóniga kaweq ehwéh teiátáire. Mi tanáhráq wene ehwehnka itene irupipeq eyoyó aitáráire. ");
INSERT INTO awb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nániboga miraúno i arámbéhrí mira aruqaruruge. Minayabe Nániboga eqmaq núwéhraq tagaríáhwe. Néne arambehriga Sóniga teí éhwéh kiotaikire. ");
INSERT INTO awb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Íné eqmaq núwéh ání Nániboga néne sánsánsábé aiq teiátáire. Wene ehweh ite íre írátíáhwe. Wene auranabiahtapeq íre tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Itega íné eqmaq núwéh ánínsábé íre aiq pútare aintáh púana wene ehweh itene irupipeq íre kagaire. ");
INSERT INTO awb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ite oga mérapeq awaq mianeheéq Manikáne sehira sáhnsahwe taga tagowe. Mi sehiránká íné éhweh aiq teíre. ");
INSERT INTO awb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Aiq teíraq itega ínéba íre séyéonsabé árahue oga mérapeq awaq mianéhbo? ");
INSERT INTO awb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Íné anotah niwíq wehukebate íre meanieéna iraruge. ");
INSERT INTO awb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Itega Manikánsabe íre irutaboiratáhwe. Minawé aiq tagaríóge. ");
INSERT INTO awb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nániboga íné eqmaq núwéhrana sugaqme ite íre mehweh aintáhwe. Mó aní peh wenáwíqtaq si aní mehweh atáhwe. ");
INSERT INTO awb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mó kegá itensabé iwíáh íwíáh aitáhnsábé iuwahbehre. Manikánka kaweróne aitahnayabé íre arutaboiro puaq árahue ínénsabe aiq pútare aintanéhbo? ");
INSERT INTO awb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ínéga Maniká míéhrabeq ite ehweh aitanae íwíáhiyeho. Mósísiga ite séhréh aitankéhe íwíáhiyeho. Írakaumo. Wene ehwehnka ehweh aitankéhe. ");
INSERT INTO awb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mósísiga néne sánsánsábé sehiranue teiuwe. Minayabe itega wensabé aiq pútare atáhtáq tahirímé ínénsabe aiq pútare aintáh irino. ");
INSERT INTO awb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mósísiga teiu sehiránsábé íre aiq pútare atáhnsábé ínéga teíú éhwéh árahue aiq pútare aintanéhbo úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mó tanáhráq Sísaga Kehrari kawéhútáq sípi kéwewena kure seberaebéq pokúwe. Kehrari kawéhúmé mó awíq Táíbéría kawéhúne. ");
INSERT INTO awb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mitaq Sísaga awahre ke kawerarito púara áhnte kegá tagéra ótaq sansáne éra we kérówe. ");
INSERT INTO awb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sísareq ite we kérahwána kereqka sáwéhrapeq kire mi sawéhráq tútuue míahwane. ");
INSERT INTO awb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ite Asiu kené sótaikú iahreraq ko tánáhráq táhutahuq né tanáhráq wahtonúwe. ");
INSERT INTO awb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Áhnte kegá Sísaba kíúwana tagéna Sísaga Pírípinsabé, Sira kegá tópah nehransabé árahue paiqmaranéhnkono úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sísaga miraína arámpéhri aiq iwíáhéna peh Pírípinsabé áhwárawe tagéna wensabé, Árahue paiqmaranéhnkono éna kasenúwe. ");
INSERT INTO awb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pírípiga wensabé, Áhnte monéráté 200 Kína tópah paiqme pehgáritarue sararáhna íre awehraq kanawire úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sísa kéro aní áwíq Ehntaru, Pítane ábákawagá Sísansabé, ");
INSERT INTO awb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Mahtaqté ánímáí we moberíáh párétíákáq téhtaré páhnkákáq matíéhre. Áhnte ke míáh púana mina abehq náneq tahnsáne úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sísaga ite we kérahwána keyábé, Tútuoro teríéro úwe. Mitaq áhnte ahpépáhq kotaq tútuue míówe. Se peh íregáritaq wehuké 5 táhúséni (5,000) wehuké míówe. ");
INSERT INTO awb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sísaga mi parétí mewena Manikánsabe, Kaweróne atena keqme tútuue míó ke náriuwe. Páréti náriunserahnue pahnkákáq moq náriuwe. Sega táhutahuqsabé suwahbónserahnue náriuwe. ");
INSERT INTO awb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ómiga siyahbankirowana Sísaga ite we kérahwána keyábé, Arahq súéhboq morábí sáharáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Úwaq itega moberíáh párétí arahqmé airápété téhtaré páhsíkétí úsawe obenkíq marahwáne. ");
INSERT INTO awb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Míó kega mi otáq sánsá tagéra mahraréra, Marakóipeq tuména Manikánka naho néne ehweh irarína aní eqmaraníe ú anímé Sísa wire uwe. ");
INSERT INTO awb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sísaga iwíáhéna, Sega íné táhtorera ínénsabe, Amahnága itene anotah wahnáh ání míahno ainteho éna taqnobague webataq sáwéhrapeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Íó tupekútaq ite Sísa kérahwána kegá káwehu waní áhkórapeq tunse ");
INSERT INTO awb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","sípi kéweweq kure seberaebéq Kápénéáma suwahpeq koneheowane. Penorabeq Sísaga iteba íre súwe. ");
INSERT INTO awb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Anotah soirírúnka nonaburóróúwe. ");
INSERT INTO awb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sípiipéq kéq awanká karatáté wání subame kure peh ákáhtaq wahtó kowanana Sísaga iteba wání abobóráhtaba súwaq tagéq áhreowane. ");
INSERT INTO awb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Áhreowanana Sísaga itensabé, Íné úge. Íre áhreoro úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Itene irupipeq eyoyóéq wensabé, Máho ewanana Sísaga sípiipéq kiasague kirútuue míowe. Kirútuue míotaq ite pokonehe owanarabeq sípiipéq apubúue kowane. ");
INSERT INTO awb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ahbiah tahnsá seberaebéqté kégá iwíáhéra, Inokáh peh morá sípí karáirana Sísa mipéq íre pokuraire. We kéró kega sebataq mewera pokurowe uwe. ");
INSERT INTO awb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Táíbéría marákórápéqté sípíwárí kéwewera suwe. Tópah norabeq Sísaga Manikánsabe kaweróne atorabeq mi sipíwárí wahtotaq kéwewera suwe. ");
INSERT INTO awb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Suwara míó kega Sísansabé anebahréra wereq ite we kérahwána kereq íre míahwanayabé sega Sísa koraganeheéra mi sipíwárí kéwewera Kápénéáma suwahpeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sega seberaebéq Sísa tagéra wensabé, Íwáhnoraníno, arahtaq seno uwe. ");
INSERT INTO awb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Uwana Sísaga sensabé, Kawerue írátíáhro. Ótaq sansánuraunsabé íre sewe. Peh tópah náíátáugana iyahbankítáinsabé sewe. ");
INSERT INTO awb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Karekorahi tahutáhúqsábé íre arambehrioro. Peh oga mía mía tahutáhúqsábé arambehrioro. Mi tahutáhúqmé íné wehukení úku anínká náiníe. Maniká Nániboga omaq intena kaweróne aintéhre úwara ");
INSERT INTO awb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","sega wensabé, Manikáne arambehriwe aneq miraonehnkono uwe. ");
INSERT INTO awb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Uwana Sísaga sensabé, Nániboga íné eqmaq núwéh ánínsábé aiq pútare aintáhmé minawé Manikáne arambehri wire úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Úwara sega wensabé, Itega arensabé aiq pútare atanéhboq aneq otáq sánsá mirainibo? ");
INSERT INTO awb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Manikáne ehwehnka mahraréna, Sega nageheéna wega íópeqté tópáh náriuwe ire. Mina únserah iteinahbúréhga uworapeq pehipi ko topáh nowe. Minayabe arega aneq otáq sánsá mirainibo uwe. ");
INSERT INTO awb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Uwana Sísaga sensabé, Kawerue írátíáhro. Mósísiga íópeqté tópáh íre náriuwe. Nániboga aiq pútaq íópeqté tópáh náíre. ");
INSERT INTO awb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Manikáne tópah, íópeqté tópáh márunáíúnká mah kehiná kéhíná oga míahrahowe úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Úwara sega wensabé, Mi topáh nái náinúno uwe. ");
INSERT INTO awb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Uwana Sísaga sensabé, Íné oga mía mía topáh múge. Ínéba sira kewé mó íre sirupibiinawire. Ínénsabe aiq pútare aintáh kéwé mó íre tahbobóoneherawoe. ");
INSERT INTO awb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Itega íné tagéq ínénsabe íre aiq pútare aintáhwe teiewóge. ");
INSERT INTO awb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nániboga nánina kegá ómi ínéba sigehe. Ínéba sira kewé íre kaqsuaníe. ");
INSERT INTO awb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Íre ínénéne iwíáh peh íné eqmaq núwéh áníné awahbeh árámbéhrí mirainieéna íópeqté tumíóge. ");
INSERT INTO awb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Íné eqmaq núwéh ánínká teniena, Náwéna ke taqnobagiyehboq kawerue wahnahnatawéwahno. Anehe tanahráqmé náwéna ke iriwe oganúq sito ire. ");
INSERT INTO awb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nániboga teniena, Are nénahni tagéra aiq pútare atáh kéwé oga mérapeq awaq miagéhe ire. Tenínsábé mi kewé anehe tanahráq iriwe oganúq sitanauge úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sísaga, Íné íópeqté tumíó tópáh múge únsabe Asiu kegá sibiahnsa atera seye ehmuniq éhmúníruwe. ");
INSERT INTO awb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ehmuniq éhmúníréra, Ehweh teí ání wenáwíq Sísa wire. We Sósépane ahninkáwá wíre. Wenanoibo tagariona akéq móye. Amahnága wega, Íné íópeqté tumíóge irarime árahinsabébo uwe. ");
INSERT INTO awb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Uwana Sísaga sensabé, Iteite abiahnsanue ehmuniq éhmúníriyeho. ");
INSERT INTO awb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wehukega pehipi ínéba íre sigehe. Peh Nánibo íné eqmaq núwéh ánínká sabiri kegá ínéba sigehe. Mi kewé anehe tanahráq iriwe oganúq sitaníe. ");
INSERT INTO awb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Manikáne ehweh iraru kene sehiranka mahraréna, Manikánka ómi síwáhnorinkehe ire. Nániboga síwáhnori ehwéh íráh kégá ómi ínéba sewe. ");
INSERT INTO awb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mah kehiná kéhínánká Nánibo íre tagahwe. Íné, Maniká míéhrabeqte ánínká ínébataq Nánibo tagarauge. ");
INSERT INTO awb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kawerue írátíáhro. Ínénsabe aiq pútare aintáh ké oga mérapeq aiq awaq míáhwe. ");
INSERT INTO awb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Íné oga mía mía topáh múge. ");
INSERT INTO awb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pehipi ko topáhmé iteinahbúréhga uworapeq méra naruera íre oga mía pehipi pukuwe. ");
INSERT INTO awb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Íópeqté tópáh tumíónsábé nehra kegá íre pukigehe. ");
INSERT INTO awb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Íné íópeqté oga mía mía topáh múge. Íné nehra kegá oga mía míaigehe. Mah kehiná kéhíná oga mía míaigeheéna íné pukinie. Minayabe náíéna topáhmé néne niwaq mire úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Asiu kegá seyensabé ehwehéra, Mah aníné awaqme árahue náinkéhbo uwana ");
INSERT INTO awb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sísaga sensabé, Kawerue írátíáhro. Íné wehukení úku aníné korahqkakáq niwaqkakáq peh áwé tagah kegá oga mérapeq íre awaq míáhwe. ");
INSERT INTO awb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Néne korahqkakáq niwaqkakáq nah kegá oga mérapeq aiq awaq míáhwe. Mi kewé anehe tanahráq iriwe oganúq sitaníe. ");
INSERT INTO awb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Oga mía mía tahutáhúqmé néne korahqkakáq niwaqkakáq míre. ");
INSERT INTO awb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Néne korahqkakáq niwaqkakáq nah kegá ínéba mía míaowe. Ínéga seba mía míauge. ");
INSERT INTO awb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Íné eqmaq núwéh ání, Nánibo oga mía míai puana íné moq oga mía míauge. Íné oga mía míaunserah íné nehra kegá oga mía míaigehe. ");
INSERT INTO awb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Íné íópeqté tú tópáh íre iteinahbúréhga no naneq tahnsáne. Sega pehipi ko topáh naruera íre oga mía míaowe. Íópeqté tú tópáh nehra kegá oga mía míaigehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sísaga mi ehwéh Kápénéáma suwahpeq Asiu kené momiwí nahtápéq síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Áhnte we kéró kega mi ehwéh irera seye náhenéra, Minawé anotah pagégé éhwéh míre. Inseréhga iragéhbo uwe. Inseréhga iragéhbo éra ehmuniq éhmúníruwana ");
INSERT INTO awb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sísaga wene arupipeq sene ehweh irena sensabé, Amahnága teiú éhwéhnsábé iuwahriehro? ");
INSERT INTO awb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Íné wehukení úku anínká túrabeq mó kionaq tagéq aneq iwíáhonehbo? ");
INSERT INTO awb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Manikáne Awanka oganúq ítéhre. Peh wehukega íre miraorahowe. Teiú éhwéhnsábé Manikáne Awanka oganúq ítéhre. ");
INSERT INTO awb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ite mó kegá aiq pútare aintáhwaqme mó kegá íre aiq pútare aintáhwe úwe. Sísaga wene arupipeq wensabé íre aiq pútare átó kereq wene naruo koweriranaú anínseq tagario púana mi ehwéh irarúwe. ");
INSERT INTO awb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sísaga sensabé, Minayabe mah ehwéh teiewómé wehukega pehipi ínéba íre sigehe. Peh Nániboga sabiri kegá ínéba sigehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Úwara áhnte we kéró kega Sísa auwera mó íre kérówe. ");
INSERT INTO awb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sísaga ite airápété téhraníté kérahwána keyábé, Ite moq nuweq pokonehbo úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Úwana Sáímóni Pítaga wensabé, Itene Wahnahno, inseba pokonehnkono? Arene ehwehnka oganúq itahráhire. ");
INSERT INTO awb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Are Maniká míéhrabeqte kaweqtaq mía míaóna aní móne. Aiq tagarione. Minayabe aiq pútare atone úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Úwana Sísaga itensabé, Ite airápété téhraníté omaq itáráuge. Ite míáhrabeqte ání owainawane anine úwe. ");
INSERT INTO awb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","We Sáímóni Ísíkáríótine ahninkáwá Súrásansabé irarúwe. We airápété téhraníté míórabeqte ánínká Sísane naruo weba koweriranaúwe. ");
INSERT INTO awb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Asiu kegá Sísa subíyehoéna wega Súría marákórápéq íre kuríá peh Kehrari marákórápéq mó ke suwahpeq mó ke suwahperue ah noguwe. ");
INSERT INTO awb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Asiu kegá saqmaq saqmaq nahmarí pearera táhutahuru tanáhráq áhníbóránúwe. ");
INSERT INTO awb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wenábáqmarinká Sísansabé, Ómi are kéráh kégá arene arambehri taganehboq mahtaq sue Súría marákórápéq pokúno. ");
INSERT INTO awb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Arega anotah aní míankehboq kopípéq arambehriinehboq ábóraq arambehriúno. Arega ótaq sansá mirainaraq mah kehiná kéhíná kosokigiúno uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Wenábáqmarinká Sísansabé íre aiq pútare ató púara mi ehwéh iraruwe. ");
INSERT INTO awb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sísaga sensabé, Amahnága íné anotah aní míó tánáhráq íre suríéhre. Ahriahriwe itene tanáhráre. ");
INSERT INTO awb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ahbabáq kehinánká itensabé suwahbehre. Sene ahbabáqsabe teriu púana ínénsabe suwahriehre. ");
INSERT INTO awb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Iteite táhutahurorabeq pokurero. Íné anotah aní mé tanáhráq íre suríéh púana táhutahurorabeq amahnága íre pokinie ");
INSERT INTO awb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","éna Kehrari marákóráq peh mitaq míowe. ");
INSERT INTO awb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Táhutahururabeq wenábáqmarinká kuwana Sísaga epéráhpérue mitaq suena Sarúsarama suwahpeq táhutahururabeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sísansabé anebahréra Asiu kegá táhutahururabeq mó kebá mó kebánue kasenéra, Sísa eheq míehro éra kasenuwe. ");
INSERT INTO awb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Míó kega Sísane sánsánsábé ehmuniq éhmúníréra mó kegá, We kaweq aní míre uwara mó kegá, Írakaumo. We péhe ání míre uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Se Asiu kené wahnahmarínsábé áhreu puara Sísa éhweh íre pahsúówe. ");
INSERT INTO awb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Táhutahuru tanáhráq ákáhtaq parabagútaq Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq kibekéna síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Síwáhnorúwara Asiu kegá áhtenéra mahraréra, Íre sigarue tagaríéh ání míre. Árahue ahtebia ání úkurairo uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Uwana Sísaga sensabé, Ínéga íwáhnoru ehwéhmé íre ínébataq néne iwíáhe. Mina íné eqmaq núwéh áníné íwíáh wíre. ");
INSERT INTO awb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ínéga íwáhnoru ehwéhmé Manikáne iwíáhbópoq peh ínébataq néne iwíáhbópoq teiúge íwíáho? Manikáne arambehriyabé arutaboiréna mirainauge íwíáhi anínká néne ehwehme íre peh ínénéne iwíáh peh Manikáne iwíáh wíre ue tagariankehe. ");
INSERT INTO awb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wewene ehweh síwáhnori ánínká wewensabé iwíáh íwíáhire. Eqmaq núwéh ánínsábé iwíáh íwíáh atónsábé íre péhenia peh aiq pútariahnsanuge. ");
INSERT INTO awb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Manikánka sehgíóro ú ehweh Mósísiga naho teiu mino. Mi ehwéh ite íre íráhwe. Amahnága íné nubiq sueyabe ite aneqsabé iuwahbehro úwe. ");
INSERT INTO awb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Úwara míó kega wensabé, Owainawanka arene arupipeq míéh púah wega inserahni iwíáhóne. Are subiq suaneheme inseréhga irareo uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Uwana Sísaga sensabé, Ahrena ahrena wehekáhtáq íné peh morá ótaq sansánunsabé ite iwíáh kikirowe. ");
INSERT INTO awb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mósísiga naho káriq anímáígáúné síú amurúrue sansa teiuwe. Íre Mósísiga peh iteinahbúréhga mi sansá áhwárarówe. Ite ahrena ahrena wehekáh mi sansámé mira aruqarurowe. ");
INSERT INTO awb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mósísiga sehgíóro ú ehweh anterúéhneho éq itega mi sansá ahrena ahrena wehekáhnkákáq mira aruqarurowe. Mira aruqarurome ínéga ahrena ahrena wehekáh wehukení kaweratáráunsabé árahinsabé abiahnsa aintaho. ");
INSERT INTO awb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Apubúue tagéq íre kaweq iwíáhéq ehweh aintaho. Peh tábúsoqme iwíáhue tagéq irarero úwe. ");
INSERT INTO awb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Táhmaro Sarúsarama suwahpeqte kégá kasenéra, Sega subiq suaneherao anímé mah anípo? ");
INSERT INTO awb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wega mahtaq ábóraq síwáhnorirara wahnah kegá peh túbáh agowe. Túbáh agonsabé mah anímé wehuke merirena kaweraritankeheéna Manikánka omaq ato aní míre íwíáhowapómo. ");
INSERT INTO awb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mi aní wenawahpeq aiq tagarione. Manikánka omaq ato anínká sínaraq wenawahpeq ómiga íre tagariagehe uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Uwana Manikánsabe iwíáh íwíáh atáh tápéqté mátábúrápéq Sísaga síwáhnorena anotahtaq mahraréna, Itega íné tagarione éq nánuwahpeq tagaríáhwe. Íné tutaume íre ínébataq néne iwíáhga tutauge. Íné eqmaq núwéh ání we aiq pútaq aní míéhraq itega we íre tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","We míéhrabeqte tutaugana wega íné eqmaq núwéh púana ínéga we aiq tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Uwara sega wene ehweh irera iwíáhéra, We táhtoranéhe uwe. Sísa pukú tanahráq íre surio púara sega peh áwé tagowe. ");
INSERT INTO awb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Áhnte míó kega, Sísansabé aiq pútare atówe atera mahraréra, Sísaga áhnte otáq sánsá mirai puana Manikánka omaq ato anínká sínaraq wega miraína sansánká Sísaga miraurai otáq sánsá kiotaikinabo uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Soruparíó kega Sísane arambehriyabé ehmuniq éhmúníruwara Péhrasi kegá írówe. Manikáne ehweh mibeq mahbeq arítáh kéreq Péhrasi kereqka Sísa táhtoraneheéra sene párísiwarí eqmaq súówe. ");
INSERT INTO awb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sísaga mahraréna, Iteba wahto tanahráq ména anehe íné eqmaq núwéh ánípá pokinie. ");
INSERT INTO awb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Itega íné ninebahrirataqmé íre taganeheqmóe. Íné pokonarabeq ite íre kioráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Úwara Asiu kegá seye mahraréra, We eheq pokinabo? Ite anebahréq we íre tagahrahúnarabeq eheqpo? Mó nahnsó suwahpeqte Asiu kébá pokinabo? Káríki ehwéhno ke suwahpeq pokue síwáhnorinabo? ");
INSERT INTO awb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ite íné ninebahrirataqmé íre taganeheqmóe ire. Wega irarime íre iahtebóna ehwéhne. Íné pokonarabeq ite íre kioráhowe ire. Wega irarime íre iahtebóna ehwéhne. Mi ehwéhmé aneq ehwéhpómo uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mi tahutáhúré tanáhráq anehete wehekáh tánáhráq anotah tanáhráre. Mi wehekáh Sísaga iriwe ména anotahtaq mahraréna, Ite tahbobóínaraq ínéba sure sewe nahro. ");
INSERT INTO awb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ínénsabe aiq pútare aintáh kéné sirupipeq oga mía mía aráhnó tueruenawire. Manikáne ehwehnka irarinserah sirupipeq oga mía mía aráhnó tueruenawire úwe. ");
INSERT INTO awb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mah ehwéhnúmé Sísaga Manikáne Awansabé irarúwe. Sísaga Maniká míorabeq íre kirio púana Manikáne Awa íre eqmarowe. Sísaga iwíáhéna, Nániboba pokonaraq ínénsabe aiq pútare aintáh kébá Manikáne Awa kieqmaranie íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Míó kega wene ehweh irera táhmaroga mahraréra, Manikánka naho néne ehweh irarína aní eqmaraníe ú anímé we wire uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mó kegá mahraréra, Manikánka ite meirena kaweraitankeheéna peh morá ání omaq atowe. We mi aní míre uwara mó táhmaroga mahraréra, Manikánka omaq ato aní íre Kehrari marákórápéqté ání míre. ");
INSERT INTO awb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Manikáne ehwehnka mahraréna, Manikánka omaq ato anímé Tébíti kahnáh ání míre. We Tébítine marakórapeqté Pétáríéma suwahpeqte ání míre ire. Manikáne sehiranka aiq mahrari mino uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sísansabé mó kegá mó iwíáhuwara mó kegá mó iwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Táhmaro kegá táhtoranéhe íwíáhéra íre táhtosa pehragowe. ");
INSERT INTO awb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Eqmaq súó parísíwárínká Manikáne ehweh mibeq mahbeq arítáh kéreq Péhrasi kereqpa kouwekuwe. Kouwekuwara sega sensabé, Aneqsabé Sísa íre meqmeq seo uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Uwara párísiwarínká sensabé, Wega irari éhwéhnká moke mó kené ehweh kiotaikire uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Uwara Péhrasi kegá párísiwarínsábé, Itega moq wene péhe éhwéhnsábé aiq pútare ataho? ");
INSERT INTO awb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wahnah kereq ite Péhrasi kereqka wensabé íre aiq pútare atona wino. ");
INSERT INTO awb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Manikáne sansá íre írátíáh kégá sebataq Sísansabé aiq pútare atáhwe. Mi ke iraipéq pokoneherao ke wóe uwe. ");
INSERT INTO awb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Níkóríma, menah tanahráq Sísaba sú aninká we Péhrasi anínéna wenawahrah Péhrasi keyábé mahraréna, ");
INSERT INTO awb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Manikánka sehgíóro ú ehwehnká anereiro? Wehukení pehipi ehweh ato iro? Írakaumo. Ebeqme wehukeníné ehweh ireq wene arambehri tagaríáhro. We ahbabárínaraq anehemé ehweh ato ire úwe. ");
INSERT INTO awb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Úwara sega wensabé, Are moq Kehrari marákórápéqté ánípo? Manikáne ehweh púkuipéq kabarue tagáhno. Manikáne ehweh irare kegá Kehrari marákórápéqté íre séyéowe ");
INSERT INTO awb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","éra sene nahtapeq abae aguwe. ");
INSERT INTO awb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sísaga Óríwi sawéhrápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ahbiahipeq Sísaga Manikánsabe iwíáh íwíáh atáh náhúpéq kibekúwe. Kibekúwara ómi míó kega weba suwana wega tútuue ména síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mósísiga sehgíóro ú ehweh síwáhnoro kereq Péhrasi kereqka ahbabáq ini sabiruera meqmera wehekeq ákáhpi móátówe. ");
INSERT INTO awb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Móátéra Sísansabé, Íwáhnoraníno, mah iní mó wehgá abariiraq tagéq táhtoqme meqme súne. ");
INSERT INTO awb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mósísiga sehgíóro ú ehwehnká mina tahnsa ahbabáq ininsó ebahtaté tuparuqme subiq súáhro ire. Arewe aneq iwíáhono uwe. ");
INSERT INTO awb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sísaga íre tábúsoqme irarinaraqmé wensabé ehweh ataneheéra áhwárawe tagéra kasenuwe. Kasenuwana Sísaga taebewe ayahnkaratáté obe marákóráq sehiranúwe. ");
INSERT INTO awb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sega mó kasenaq mó kasenaruwana Sísaga iriwe ména sensabé, Íre ahbabári anínká ebeqte ébáh mewe tuparuankéhe ");
INSERT INTO awb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","éna mó taebewe ayahnkaratáté marakóraq sehiranúwe. ");
INSERT INTO awb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mitaq míó kega wene ehweh irera aboawah weh ebeq mótaq mótarue pokuwe. Ómiga Sísa auwera pokuwana Sísaga tútuue míorabeq peh morá mi inínká iriwe míowe. ");
INSERT INTO awb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sísaga iriwe ména mi inínsábé, Are meqmera se ke eheq míaho? Sega íre ehweh ataho úwana, ");
INSERT INTO awb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Írakaumo úwe. Írakaumo úwana Sísaga wensabé, Ínéga moq íre ehweh ataníe. Pokéwahno. Mó ahbábárinehboq kaweqtaq míahno úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sísaga sensabé mó mahraréna, Mah kehiná kéhíná míáhrabeq téhrehnka inserahnu aní múge. Íné séníréh ánínká íre sunkíkírirabeq nogena peh kaweqtapéq téhrehrabeq noginkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Úwara Péhrasi kegá wene ehweh irera wensabé, Arerensabé iraréne. Arene ehweh íre aiq pútaq ehwéhne uwana ");
INSERT INTO awb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sísaga sensabé, Néne sánsánsábé irarume aiq pútaq ehwéhnuge. Íné tutaurabeqkakáq íné pokinieurabeqkakáq tagaríó púana aiq pútaq ehwéhnuge. Íné tutaurabeqkakáq íné pokinieurabeqkakáq íre tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wehukenínká iwíáhinserah íwíáhéq ehweh aintáhwe. Ínéga amahnága moke wehukeyabé íre ehweh aitóge. ");
INSERT INTO awb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ínéga ehweh aitáhnaraq tábúsoqme ehwéh aitaníe. Nánibo íné eqmaq núwéh ánínká ínéba mía míai puana íné íre ahbabáq iwiáhorahéna peh tábúsoqme ehweh aitaníe. ");
INSERT INTO awb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Itega, Manikáne ehweh sehgiune eme mi ehwéhnká mahraréna, Téhranítégá morá éhwéhnóyana sene ehweh aiq pútaq ehwéhne ire. ");
INSERT INTO awb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Néne sánsánsábé teiúgana Nánibo, íné eqmaq núwéh ánínká moq néne sánsánsábé teíre úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Úwara sega wensabé, Arenabo eheq míehro uwana Sísaga sensabé, Ínéreq Nániboreq íre tagaríáhwe. Íné tagaríáhtáq tahirímé Nánibonkakáq tagaríáh irino úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mi ehwéh Manikánsabe iwíáh íwíáh atáh náhtápéq sene móne maqmaru paqnáh wahtotaq Sísaga síwáhnorúwe. Íre we puké tanahráq púara mó kegá we íre táhtoqmera móátówe. ");
INSERT INTO awb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sísaga Péhrasi keyábé mó mahraréna, Íné pokinie. Itega íné ninebahréq itene ahbabáqkakaq pukoneheqmóe. Íné pokinieurabeq itega íre kioráhowe úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Úwara Asiu kegá seye náhenéra, Íné pokinieurabeq itega íre kioráhowe ire. Árahinsabé mi ehwéh irariro? Wewega wewe subiqmena pukinabirapómo uwe. ");
INSERT INTO awb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Uwana Sísaga sensabé, Ite mahtaqté ké wóe. Íné íópeqté ání múge. Ite mah marákóípéqté ké wóe. Íné íre mah marákóípéqté ání múge. ");
INSERT INTO awb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Itene ahbabáqkakaq pukoneheqmóe teiúge. Ínénsabe áwahe aní míreue íre aiq pútare aintéhrataq itene ahbabáqkakaq pukoneheqmóe úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Úwara sega wensabé, Are insebo uwe. Are insebo uwana Sísaga sensabé, Íné tei teinu aní múge. ");
INSERT INTO awb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Itega miraonsabé áhnte ehwéh kéhre. Áhnte ehwéh aitahráhuge. Íné eqmaq núwéh ání aiq pútaq aní mía míai puana mah kehiná kéhíná wega teni tenini ehwéh teiúge úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sísaga Maniká Wenabonsabé teriuwara míó ke íre írówe. ");
INSERT INTO awb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sísaga sensabé, Itega íné wehukení úku aní awankátaq táhpawe pankeréhrataq íné wenahni míre éq ahtebagehe. Íre ínénéga iwíáhéna iraruge. Peh Nániboga teninsábé teiúge. Minaakaq ahtebagehe. ");
INSERT INTO awb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Íné eqmaq núwéh ánínká ínéba mía míaire. Ínéga we awahbeh arámbéhrí kawerue mira aruqarurunsabé wega íre nuwena pokire úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mi ehwéh irarúnsabe áhnte míó kega wensabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wene ehwehnsabé, Aiq pútaq ehwéhne atówana Sísaga sensabé, Itega néne ehweh págegeue ambubu atíéhrataqmé peh mi tanáhráq aiq pútaq íné séníráh ké míagehe. ");
INSERT INTO awb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Íné séníréhrataq aiq pútaq ehwéh ahtebehrana mi ehwéhnká soraq iuwankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Úwara sega wensabé, Ite Ébáráhma kahnáh míonara mó kegá náhgáqtate íre iyarówe. Minayabe ite soraq iuwankéhe irarenawe árahinsabé irareno uwe. ");
INSERT INTO awb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Uwana Sísaga sensabé, Kawerue írátíáhro. Ahbabáq aruqaruro ke sene ahbabáqka iyaréhre. ");
INSERT INTO awb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ahbabáqka iyaréh kégá Nánibone nahtapeq íre míahrahowe. Írakaumo. Peh morá wene animárínká mía míaowe. ");
INSERT INTO awb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Íné Manikáne ahninkáwágá pugeq iuwáhnaraq ahbabáqka mó íre iyarahráhire. ");
INSERT INTO awb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Íné tagaríómé ite Ébáráhma kahnáh míáhwe. We kahnáh méq itene irupipeq néne ehwehnka íre kagai puaq itega íné nubonehe íwíáhowe. ");
INSERT INTO awb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nániboga íné sokigi anínsábé teiúge. Itewe iteriboga íwáhnori sansá mira aruqarurowe úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Péhrasi kegá Sísansabé, Ébáráhma iteribo wire uwe. Uwana Sísaga sensabé, Ite Ébáráhmane animárí míáhtáq tahirí wene sánsá mirao irino. ");
INSERT INTO awb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aiq pútaq ehwéh Nániboga teni tenini ehwéh teiúgaq itega íné nubonehe íwíáhowe. Itega mira onserah Ébáráhmaga íre miraúwe. ");
INSERT INTO awb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Iteriboga mira aruqarurinserah miraowe úwara sega wensabé, Iteinoréh ahbabáq ininsó míáhwe íwíáhono? Iteribo íre áhnte, peh morá Manikáne uwana ");
INSERT INTO awb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sísaga sensabé, Maniká Iteribo iraq tahirímé ínénsabe irutaboiraintáh irino. Maniká míéhrabeqte tumíóge. Íre néne iwíáhga tumíóge. Manikánka eqmaq núwátáirana tumíóge. ");
INSERT INTO awb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Néne ehweh árahinsabé íre iraho? Itega néne ehweh iuwahrieh puaq íre íráhwe. ");
INSERT INTO awb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ite owainawane animárí móe. Owainawanka ahbabáq sansansábé awahbehnserah itega wene sánsá miraéyabe iuwahbehre. Áwahewé we mó ke subiq suo ani míowe. We íre aiq pútari aní míéh púana péhe éhwéh tei teinire. Wega péhe ání ména péhe sánsá áhwáró púana péhe éhwéh tei teinire. Wene sánsáne. ");
INSERT INTO awb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Íné aiq pútaq ehwéh teiúnsábé itewe íre aiq pútare aintáhwe. ");
INSERT INTO awb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Íné ahbabáq ani míre irarénawe insega irariro? Íné aiq pútaq ehwéh teiúmé aneqsabé íre aiq pútare aintaho? ");
INSERT INTO awb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Manikáne animárínká wene ehweh íráhwe. Ite íre wene animárí míáh púaq wene ehweh íre íráhwe úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Asiu kegá wensabé, Are Sámáría marákórápéqté ání míahnana owainawanka arene arupipeq míéhre. Aiq pútaq ehwéh irarúne uwana ");
INSERT INTO awb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sísaga sensabé, Nirupipeq owainawa íre míéhre. Nánibonsabé iwíáh íwíáhugaq itega ínénsabe íre kaweq ehwéh aintáhwe. ");
INSERT INTO awb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Anotah aní míómé íre ínénéne iwíáhe. Nánibo mah kehíná kéhíná saraqmarahna aninká wewega anotah aní míahno aintéhre. ");
INSERT INTO awb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kawerue írátíáhro. Néne ehweh irera néne sánsá sehgíra kewé íre pukigehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Úwara Asiu kegá wensabé, Owainawanka arene arupipeq míéhraq amahnága aiq tagarione. Néne ehweh irera néne sánsá sehgíra kewé íre pukigehe eno? Ébáráhmareq Manikáne ehweh iraru kereq ómi puku mino. ");
INSERT INTO awb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ébáráhma iteribo pukúnsabe arega, Íné Ébáráhma kiotaiqme aní míóge íwíáhono? Are iwíáhónawe inseúge íwíáhono uwe. ");
INSERT INTO awb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Uwana Sísaga sensabé, Ínéga ínénénsabe iwíáh íwíáhutaq tahirímé mina abehq náneq úki irino. Nániboga ínénsabe iwíáh íwíáh aintéhre. Nánibo itene Manikáne eme ");
INSERT INTO awb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","itega we íre tagaríáhwe. Ínéga we tagaríóge. Ínéga we íre tagaríóge teiútáq tahirímé íné ite tahnsá péhe ání míó irino. Ínéwé we aiq tagaríóge. Wene ehweh irena wene sánsá mira aruqaruruge. ");
INSERT INTO awb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Iteinahbú Ébáráhmaga íné tanáhráqsábé iwíáhue níwénunéna iwíáh íwíáhúwe. Anehe íné tagéna wene arupipeq eyoyóúwe úwara ");
INSERT INTO awb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Asiu kegá wensabé, Are íre aboawah weh míahna puah Ébáráhmawe árahue tagariahno uwe. ");
INSERT INTO awb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Uwana Sísaga sensabé, Kawerue írátíáhro. Ébáráhmawe íre míotaq míáhwa aní múge úwe. ");
INSERT INTO awb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mi ehwéh irera sega ebahtaté tuparuqme subiq suaneheéra mi ebáh kabarue meyówe. Meyówana Sísaga taqnobague Manikánsabe iwíáh íwíáh atáh náhtápéqté tueyokúwe. ");
INSERT INTO awb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sísaga ah nogutaq aura pira ání, ítaq mahbí tagówe. ");
INSERT INTO awb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wenanoga maqmiotaq aura pira ání maqmarowe. Ite we kérahwána kegá Sísansabé, Íwáhnoraníno, wenanoga aura pira ání maqmaronsabe insega ahbabárúo? Aura pira ánínká ahbabárúo? Wenanoiboga ahbabáruyao? Insega ahbabárúo kasenowane. ");
INSERT INTO awb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kasenowanana Sísaga itensabé, Íre wereq wenanoiboreqne ahbabáqsabe aura pira ání míéhre. Itega Manikáne arambehri tagageheéna we aura pira ání míéhre. ");
INSERT INTO awb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Íné eqmaq núwéh áníné arambehri téhrehtaq miraonehe. Penkínaraq ómiga íre arambehriorahúne. ");
INSERT INTO awb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ínéwé mah marákó márákó mé tanahráqmé mah kehiná kéhíná míáhrabeq téhrehnka inserahnu aní múge úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Miraréna marakóraq tehqniarena wene ayahnkaratáté marakó abiroúwana seraweh úkúwe. Mi seráwéhráté aura pira áníné aurátaq abaq marena ");
INSERT INTO awb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","wensabé, Síróáma kawéhúpípéq móbabeq paberúno úwe. Sene ehwehme Síróámawe eqmaréh ání míre. Móbabeq paberúno úwana wega pokue móbabeq paberúwana wene aura kaweragúwana kouwekúwe. ");
INSERT INTO awb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","We aura pira ání míotaq ineh inehúwara wenawahrahreq mó kereqka taga tagauwe. Wega kouwekútaq mi kegá aura kaweragú aní tagéra mahraréra, Mi anímé tútuue ména ineh inehi anímé webo kasenuwe. ");
INSERT INTO awb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mó kegá, We wire uwara mó kegá, Írakaumo. Peh we tahnsá ání míre uwe. Uwana mi anínká mahraréna, Ite irare anímé íné úge úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Úwara sega wensabé, Arene aura árahue kaweragiro uwana ");
INSERT INTO awb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","wega sensabé, Sísae ue áwírató anínká serawehraté niurapi abaq intena ínénsabe, Síróáma kawéhúpípéq móbabeq paberúno tenírana móbabeq paberugana niura kaweragire úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Úwara sega wensabé, We eheq míehro uwana, Íné íre tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sega aura kaweragú aní meqmera Péhrasi kebá móátówe. ");
INSERT INTO awb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sísaga seraweh mirarena wene aura kawerato tanáhráq ahrena ahrena wehekáhne. ");
INSERT INTO awb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Péhrasi kegá aura kaweragú anínsábé kasenéra, Arene aura árahue kaweragiro uwana wega sensabé, Serawehraté niurapi abaq intéhrana pabeq paberugana amahnága niura kaweragire úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Úwara mó Péhrasi kegá mahraréra, We ahrena ahrena wehekáhté sánsá anetaníbo íwíáhi puana we íre Manikánka eqmaréh ání míre uwe. Uwara mó kegá mahraréra, We ahbabáq ani tahirímé mina tahnsa ótáq sánsá árahue mirai iripo uwe. Mó kegá mó iwíáhuwara mó kegá mó iwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sega aura kaweragú anínsábé mó kasenéra, Arene aura kaweratéh ánínsábé, Arega aneq iwíáhono uwana, We Manikáne ehweh irari aní míre úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sísaga aura pira ání kaweratonsabe Asiu kegá íre aiq pútare ató púara wenanoibo akéqsábé síáhrabue kasenuwe. ");
INSERT INTO awb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kasenéra, Mah aní itenahnipo? Maqmíónaraq aura pigúo? Amahnága wene aura árahue kaweragiro uwe. ");
INSERT INTO awb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Uwara wenanoiboga sensabé, We itenahni míre. Teh maqmarahwáyataq aura pira ání maqatahwáye. Mina aiq tagarioye. ");
INSERT INTO awb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amahnága we tagahrahinsabé íre tagarioye. Wene aura kaweratéh ání íre tagarioye. Wensabé kaseniranao. We anonani púana irarerahire uye. ");
INSERT INTO awb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wenanoibo akéqká Asiu keyábé áhreuya puara mi ehwéh iraruye. Wene aura íre kaweragútaq Asiu kegá sío síoéra, Sísawe aiq pútaq ite meirena kaweraitankeheéna Manikánka omaq ato aní míre atáh ké momiwí nahtápéqté kaqsuanéhe uwe. ");
INSERT INTO awb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Minayabe wenanoibo akéqká Asiu keyábé, We anonani míre. Kaseniranao uye. ");
INSERT INTO awb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Asiu kegá aura kawerato anínsábé mó áhrabéra wensabé, Peh morá Manikánsabe iwíáh íwíáh ato. Ite tagarionawe arega iraréna anímé ahbabáq ani míre uwe. ");
INSERT INTO awb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Uwana wega sensabé, We ahbabáq anipómo. Íné íre tagaríóge. Íné aura pira ání mía míaugana amahnága néne niura kaweraintéhre. Peh mina aiq tagaríóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Úwara sega wensabé, Wega aneq miratehro? Arene aura árahue kaweratehro uwe. ");
INSERT INTO awb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Uwana wega sensabé, Métáq teiúgaqme íre íráhwe. Mónkakáq aneqsabé teinínkono? Ite moq we kéranéhbo úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Úwara wensabé ehweh atera, Are we kérahna aní míahnaq ite Mósísi kérona anímárí múne. ");
INSERT INTO awb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Manikánka Mósísi ehweh teawuwaq aiq írátíone. Arega iraréna anímé eheqte anípómo. Ite íre tagarione uwe. ");
INSERT INTO awb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Uwana wega sensabé, Wenawahpeq íre tagaríáh ánínká niura kaweraintéhnsábé áhtené sansane. ");
INSERT INTO awb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Manikánka ahbabáq kene ehweh íre íréhre. Manikánsabe iwíáh íwíáh atáh kéwé Maniká awahbeh arámbéhrí sehgíó kéwé Manikánka mi kené ehweh íréhre. Mina aiq tagarione. ");
INSERT INTO awb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Naho mó kegá aura pira áníné aura íre kaweratowe. ");
INSERT INTO awb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Néne niura kaweraintéh ání Manikánka eqmaréh áníne. We peh wehukení tahirímé niura íre kaweraintahráhi irino úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Úwana sega wensabé, Are ahbabárorabeqte ání móne. Árahue íwáhnorinibo éra we momiwí nahtápéqté kaqsúówe. ");
INSERT INTO awb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sísaga we kaqsue ehweh irena mi aní tagéna wensabé, Wehukení úku anínsábé aiq pútare aintahno úwana ");
INSERT INTO awb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","wega Sísansabé, Are wehukení úkóna anípo? Arensabé aiq pútare ataníboq tenio úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Úwana Sísaga wensabé, Arega íné wehukení úkurau aní aiq tagáhne. Amahnága ehweh teawú ání íné úge úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Íné úge úwana wega Sísansabé, Néne Wahnah mone. Arensabé aiq pútare atóge éna iwíáh íwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sísaga mahraréna, Wehuke saraqmaranieéna marakóipeq tumíarauge. Tumíaraunsabé aura pira kégá tagariagehe. Ite aiq tagarione íwíáho ke íre tagariahraho ke úkigehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Úwara Sísareq míó Péhrasi kegá wene ehweh irera wensabé, Ite moq íre tagariahrahúna keabuno uwe. ");
INSERT INTO awb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Uwana Sísaga sensabé ite aura pira ké míáhtáq tahirímé itene ahbabáq íre kaga irino. Itega tagarione ensabé itene ahbabáq peh kagaire úwe. ");
INSERT INTO awb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sísaga mó mahraréna, Kawerue írátíáhro. Sipisípiqmarí kaegaeorabeqte ónsárápéq íre ségia móbeq séogesáhago kewé se aebó kééra subónehboq náio e ke wóe. ");
INSERT INTO awb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Onsarapéq séyéi anímé we sipisípiqmaríné wahnah mire. ");
INSERT INTO awb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sipisípiqmarínká wene ehweh íráhwana méhpehte wáhnáhnká onsa siaréhre. Sene wahnahnka wene sipisípiqmarínsábé sensíwírue síáhrabéna ebeq túírara anehe tueráhwe. ");
INSERT INTO awb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wene sipisípiqmarí máhpeq moke tuegue we ebeq pokirara wene ehweh íráh púara anehe kaqme kéráhwe. ");
INSERT INTO awb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Se mó aní íre kéráhwe. Wene ehweh íre íráh púara áhreéra kobeq séberowe úwe. ");
INSERT INTO awb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sísaga mi pabéqmé éhwéh síwáhnorúwara míó kega mi ehwéhnsábé íre ahtebowe. ");
INSERT INTO awb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sísaga mó mahraréna, Kawerue írátíáhro. Íné sipisípiqmarí kaegaeorabeqte ónsá uge. ");
INSERT INTO awb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Íné mahtaq íre míáhwataq su kewé se aebó ké éra subónehboq náio e ke wóe. Sipisípiqmarínká sene ehweh íre írówe. ");
INSERT INTO awb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Íné onsa uge. Manikánka ínébansabé kira ke kaweraritankéhe. Kaweraritahnara méhpehpeq kierueue táhutahuq nagehe. ");
INSERT INTO awb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Aebó kégá aebóoneheéra sewe. Subiq suaneheéra sewe. Moke íre kaweraruaneheéra sewe. Ínéwé ite oga mía míaigeheéna tumíarauge. Oga mía mía sansánká itene irupipeq obenkítíankeheéna tumíarauge. ");
INSERT INTO awb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Íné sipisípiqmaríné kaweq Wahnáh múge. Kaweq wahnáhnká sipisípiqmarí séhréh aritankehéna pukorahire. ");
INSERT INTO awb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mó anínká íre sene wahnahnurá peh arambehri aní púana sipisípiqmarítáq íre kaweq wahnáhnarítéhre. Wega wahnahnirana úrinsi iá sirana tagéna we péhnehoéna áhre pehbeheráh pokire. Íre wene sipisípiqmarí púana suena pokire. Pokirana úrinsi iánká sipisípiqmarí subipáhqnahpahrirara kobeq séberowe. ");
INSERT INTO awb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","We peh arambehri ání míéh púana sipisípiqmarínsábé anetaníbo íwíáhéna suena pokire úwe. ");
INSERT INTO awb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Sísaga mó mahraréna, Ínéga Nánibo tagaríógana wega íné tagaríéhre. Itega tagarioyanserah néne sipisípiqmarí tagaríógara sega íné tagaríáhwe. Íné sipisípiqmaríné kaweq Wahnáh múge. Sipisípiqmarí oga mía míaigeheéna pukinie. ");
INSERT INTO awb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Íre peh morá mahtaqté sípísípíq wahnahnatíóge. Mó sipísípíqkákáq wahnahninauge. Sega néne ehweh iragéhe. Mi tanáhráq sipisípiqmarí moke peh morá sípísípíq nansó tahnsa míagehe. Ínébataq sene Wahnah míanauge. ");
INSERT INTO awb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Íné mó oga úkinieéna pukinie. Minayabe Nániboga ínénsabe arutaboiraintéhre. ");
INSERT INTO awb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Íre mó kegá iwíáhue nubiq suagéhe. Peh ínénéga iwíáhue pukinie. Íné iwíáhu tanáhráq pukéna mó oga úkinauge. Minayabe Nániboga, miraúno aintáráire úwe. ");
INSERT INTO awb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sísane ehwehnsabé mó Asiu kegá mó iwíáhuwara mó Asiu kegá mó iwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Íregáritaq míó kega iraréra, Owainawanka wene arupipeq míéhnsábé we uwoyansa aní úkire. Wene ehweh aneqsabé iraho uwe. ");
INSERT INTO awb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Uwara mó kegá iraréra, Owainawanka wene arupipeq míéh ánínká mahna tahnsa éhwéh íre íwáhnororahi mino. Owainawanka aura pira ání íre kaweratahráhi mino uwe. ");
INSERT INTO awb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Manikánsabe iwíáh íwíáh atáh náhtápéq onsa sie iahreraq ko táhútáhúq tánáhráq Sísa Sarúsarama suwahpeq míowe. Mi tanáhráq ehbiehbeq tanáhráre. ");
INSERT INTO awb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sísaga Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéq noguwe. Mi mapéq Sórómóni, anotah wahnáh ánínká pearowe. Sísaga mitaq noguwara ");
INSERT INTO awb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Asiu kegá weba sáhatawéra wensabé, Págege ehwéh iuwahriehre. Árahtaq pahsuaníbo? Ite meirena kaweraitankeheéna Manikánka omaq ato anímé arewe webo? Pahsuqme teio uwe. ");
INSERT INTO awb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Uwana Sísaga sensabé, Teiátáugaqme ite íre aiq pútare aintáhwe. Nánibo awahbeh arámbéhríunka néne sánsá tei teinire. ");
INSERT INTO awb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ite íre néne sipisípiqmarí míáh púaq ínénsabe íre aiq pútare aintáhwe. ");
INSERT INTO awb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Néne sipisípiqmarínká néne ehweh irera séníráhwe. Séníráhwana se tagarawéna oganúq sítóge. ");
INSERT INTO awb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Oganúq sítógara se ahriahri íre taqnobagia niuráq matíó púara mó kegá se néne niyahpite íre merirahráhowe. ");
INSERT INTO awb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nániboga ínéba sewíáhro arítéhrara ínéba sewíáhwe. Nániboga moke kiotaiqme aní míéh púana wega auráq matíéh púara mó kegá se wene ayahpite íre merirahráhowe. ");
INSERT INTO awb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nániboreq ínéreq monseráh áníté úye úwe. ");
INSERT INTO awb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Asiu kegá Sísa subiq suaneheéra ebahmarí mónkakáq sirówe. ");
INSERT INTO awb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sísaga sensabé, Nániboga kaweq arámbéhríúno tenínsábé, Wehuke kawerinieéna kaweq arámbéhríugaq tagahwe. Ah arámbéhríunsabé ebahnsatate nubonehe ewo úwe. ");
INSERT INTO awb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Úwara Asiu kegá wensabé, Are kaweq arámbéhríónayabé íre subiq suanéhe. Arega Manikánsabe éhruruónayabé subiq suanéhe. Are peh wehukení méwé Maniká múge énayabé suboneheqmúne uwe. ");
INSERT INTO awb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Uwana wega sensabé, Manikáne ehwehnka mahraréna, Ínéga itensabé, Ite manikámari móe atoge ire. ");
INSERT INTO awb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wene ehweh író keyabé, manikámari móe aritowe. Ite tagarionawe Manikáne ehweh ahriahri aiq pútaq ehwéhne. ");
INSERT INTO awb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Manikánka omaq intena mah marákó márákóípéq eqmaq núwátáire. Íné Manikáne ahninkáwá úge irarunsabé aneqsabé abiahnsa ainteq Manikánsabe éhruru atahne irareo? ");
INSERT INTO awb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Íné Nánibone arambehri íre mirautaq tahirímé néne ehwehnsabé anetaníbo íwíáhonsabé aiq kaweri irino. ");
INSERT INTO awb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ínénsabe íre aiq pútare aintáhwe. Kaweq arámbéhríu puaq mi arámbéhríyábé aiq pútare atáhro. Nániboga ínéba mía míairana ínéga Nániboba mía míauge. Minayabe itega kawerue iragéhboq néne arambehriyabé aiq pútare aintáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sega we mó táhtoraneheéra uwana Sísaga se suena pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sísaga Sorana aroipéq seberaebéq Sóniga wání meriurabeq mó pokue kowíowe. ");
INSERT INTO awb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kowíowara áhnte kegá weba séra seye náhenéra, Sóniga ótaq sansá íre miraire. Minayabe anetaníbo. Mah anínsábé Sóniga moke irarurai ehwéh aiq pútaq ehwéhne uwe. ");
INSERT INTO awb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mitaq áhnte kegá Sísansabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wehukení wenáwíq Árásárúsi awahreúwe. Wene anahnowáráré sensíwíq Máhríareq Máhtarere. Se Pétáni suwahpeqte se ayobioqnáhnahne. ");
INSERT INTO awb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mó tanáhráq Máhríawe Sísane aigárátáq wéri abaq marena wene ayahrataté abaearowe. Weniyoq Árásárúsi awahreúwe. ");
INSERT INTO awb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Árásárúsi awahreú púara wenanahnorarégá mó aní Sísaba eqmaróye. Eqmaróya anínká Sísansabé, Arega arutaboiratahna anímé anotah awáhréire teawuwe. ");
INSERT INTO awb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sísaga mi ehwéh irena mahraréna, Íre puké awáhré wíre. Mókake Manikánseq íné wenahninseqsabé iwíáh íwíáh aitageheéna amahnága we awahreire úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sísaga se ayobioqnáhnahnsabé arutaboiraritena ");
INSERT INTO awb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Árásárúsi awahreire ú irena téhtaréráq mitaq míowe. ");
INSERT INTO awb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Téhtaréráq ména ite we kérahwána keyábé, Súría marákórápéq mó pokonehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Úwaq itega wensabé, Íwáhnoraníno, menah Asiu kegá ebahnsatate are subonehe íwíáhurowe. Arega mitaq mó pokinibo ewane. ");
INSERT INTO awb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ewanana Sísaga itensabé, Pópoqnah kiembogi tanáhráqmé, wéhékáh tanahráqmé, tunsorerí tánáhráqmé, mina moke téhreh tanáhráre. Mi tanáhráq nogó ké íre inahnsubówe. Téhreh puara ah nogómé íre inahnsubówe. ");
INSERT INTO awb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Inokáhpeq tanáhráqmé sunkíkíri puara ah nogómé inahnsubówe úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sísaga itensabé mó mahraréna, Itene iyahnabo aní Árásárúsi aiq sugéhre. Sugéh púana koiri auwaníe úwaq ");
INSERT INTO awb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","itega wensabé, Itene Wahnahno, amahnága we sugéhnsábé mókake kaweraginae ewane. ");
INSERT INTO awb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sísaga wewene arupipeq tagariomé Árásárúsi aiq pukire íwíáhúwe. Iwíáhéna Árásárúsi sugéhre teiuwe. Ite we kérahwána kegá mi ehwéh ireq Árásárúsi peh sugéhre íwíáhowane. ");
INSERT INTO awb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sísaga itensabé pahsuqme teiena, Árásárúsiwe aiq pukire. ");
INSERT INTO awb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Itega aiq pútare aintageheéna íné íre míónsábé pukime aiq kawerire. Puki aní koraganehboq máhoro úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tómáhsi wene wéhuwehu áwíqmé Tírímásie. Wega itensabé, Sísa subiq súéhrataq ite moq subiq suagéhboq kéranéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sísaga Pétáni suwahpeq áhníbórá súwana mó anínká weba séna wensabé, Árásárúsi maisatówana itaréitaréráq kéhre úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pétáni suwahpeq Sarúsarama suwahpeq wahto kowara ");
INSERT INTO awb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","áhnte Asiu kegá Máhtareq Máhríareqne siyoqkawa aiq pukire u irera se ónanahne siru ukiq sitaneheéra Pétáni suwahpeq seba suwe. ");
INSERT INTO awb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Máhriawe nahtapeq míowana Máhtaga Sísa áhníbórá sire u irena Máhría auwena Sísa koweranieéna ahtapeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pokéna Sísaba séna wensabé, Néne Wahnahno, are mahtaq míaronaraq tahirímé iteriyoq íre pukurai irino. ");
INSERT INTO awb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Íné iwíáhume amahnágaákáq arega Manikánsabe miraúno inaraqmé mirainkehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Úwana Sísaga Máhtansabé, Iteriyoq mó kieiriginkehe úwana ");
INSERT INTO awb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Máhtaga wensabé, Íné iwíáhume anehe tanahráq we mó kie iriginkehe úwana ");
INSERT INTO awb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sísaga wensabé, Íné pusa ké irigoro aritahráhu aní múge. Íné oganúq sitahráhu aní múge. Ínénsabe aiq pútare aintáh kégá pukéra mó oga úkuwe mía míaigehe. ");
INSERT INTO awb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ínénsabe aiq pútare aintáh kégá oga méra íre airaiq pukigehe. Minayabe aiq pútare aintahno úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Úwana Máhtaga Sísansabé kowe atena, Are Manikáne ahninkáwá wóne. Arewe ite meirena kaweraitankeheéna Manikánka omaq ato aní móne. Minayabe aiq pútare atóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aiq pútare atóge éna Máhtaga pokue Máhríaba kéna epéráhpéréna, Íwáhnori aní séna arensabé áhrabire úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Arensabé áhrabire ú irena Máhríaga apubúue kie irigue Sísaba pokúwe. ");
INSERT INTO awb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sísaga se ónanahne nahtapeq íre séna Máhtaga kowerorabeq míowe. ");
INSERT INTO awb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Asiu kegá Máhríane aru ukiq ataneheéra wene nahtapeq míówe. Míówana Máhríaga apubúue kieirigue pokúwara tagéra kérówe. Árásárúsi maisarórabeq ibisanieéna pokire íwíáhéra kérówe. ");
INSERT INTO awb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Máhríaga Sísa míorabeq séna we tagéna wene aigárátáq arehunseraráq sewéna wensabé, Are mahtaq míaronaraq tahirímé iteriyoq íre pukurai irino úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Máhríareq we kéró Asiu kereqka ibisowana Sísaga tagéna sensabé anotah arútábóíraritena wene arupipeq págegeúwe. ");
INSERT INTO awb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Sísaga sensabé, Eheq maisatoo úwara sega wensabé, Itene Wahnahno, seragáhno uwe. ");
INSERT INTO awb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Uwana Sísaga ibisówe. ");
INSERT INTO awb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wega ibisónsabe Asiu kegá iraréra, Tagahro. Pukurai anínsábé anotah arútábóíratéhre uwe. ");
INSERT INTO awb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Táhmaro míó kega mahraréra, Aura pira ání kaweratárái puana Árásárúsi pukinauraitaq wega aneqsabé íre segaweratáráiro uwe. ");
INSERT INTO awb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Sísane arupipeq anotahtaq umeh aguwana maisarórabeq pokéna Árásárúsi maisia máíqtáq ebah kowana tagéna ");
INSERT INTO awb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","sensabé, Ebah meruáhro úwe. Úwana Máhta pukú aníné anahnowágá wensabé, Itene Wahnahno, itaréitaré wéhékáh kéh púana amahnága anotah karésá kúnkúninawire úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Úwana Sísaga wensabé, Arega aiq pútare ainte Maniká míéhrabeqte ótáq sánsá tagankehe teawú mino úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Úwara sega ebah merúówana Sísaga íópeq tagéna Manikánsabe, Nániboo, néne ehweh irahnayabé kaweróne atóge. ");
INSERT INTO awb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Íné írátíómé néne ehweh ahriahri aiq irahne. Arega eqmaq núwátónayabé moke mahtaq iriwe míáh kégá aiq pútare atageheéna mah ehwéh teawúge úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Teawúge éna Sísaga anotahtaq áhrabéna, Árásárúsio, máhpeq tueyokúno úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Úwana pukú anínká tueyokúwe. Maisarówana wene aigárá ayahnkara úbíqmáró ambántánkákáq tueyokúwe. Moke wene auranabiahnkakaq ambantataté úbíqme maisarówana minawarinkákáq tueyokúwe. Sísaga sensabé, Ambantamarí pugeq áúwáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Áhnte Asiu kegá Máhríareq siru ukiqsitaneheéra oganúq atonsabe tagéra Sísansabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Peh táhmaro tago kegá Péhrasi kebá pokue Sísaga miraúnsabe teríúwe. ");
INSERT INTO awb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Manikáne ehweh mibeq mahbeq arítáh kéreq Péhrasi kereqka mó kaunsírí ké síáhrabéra momiwíue sío síoéra, Aneronehnkono? Mi anínká áhnte otáq sánsá mira aruqarurire. ");
INSERT INTO awb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Itega pehragahnaraq wega mó mina inserahninawire. Minayabe ómiga wensabé aiq pútare atagéhe. Mirairataq Aroma kegá séra itega Manikánsabe iwíáh íwíáh atona nah sokoruera itereq iteruwahrahreq íre kaweraitagéhe. ");
INSERT INTO awb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mi tanáhráq Manikáne ehweh mibeq mahbeq arítáh kéné wahnah wenáwíq Káíyápásaga sensabé, Ite íre íráh ké wóe. ");
INSERT INTO awb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iteruwahrah ómi pukiyehboq peh morá ánínká iteruwahrah kaweraitanieéna pukinkehe. Mina aiq kawerire. Árahinsabé íre iraho úwe. ");
INSERT INTO awb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Káíyápásaga wewega íre iwíáhue irarúwe. Mi tanáhráq we Manikáne ehweh mibeq mahbeq arítáh kéné wahnah mío púana Manikáne Awanka wene arupipeq iwíáh atowana mi ehwéh irarúwe. ");
INSERT INTO awb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Íre peh morá Asiu ke kaweraritanieéna pukinkehe. Moke Manikáne animárí peh mahnana míáhnsábé morábí míageheéna pukinkehe. ");
INSERT INTO awb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mi tanáhráqté sío síoéra, Sísawe árahue subiq suanéhnkono íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Minayabe Sísaga Asiu ke míórabeq íre ábóraq noguwe. Wega mitaq suena Épáráíma suwahpeq anotah uwórápéq wahto kowana mitaq pokúwe. Wereq ite we kérahwána kereqka mitaq kowíahwane. ");
INSERT INTO awb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ite Asiu kené sótaikú iahreraq ko tánáhráq wahtotarútaq áhnte Asiu kegá Sarúsarama suwahpeq mósosuaneheéra pokuwe. ");
INSERT INTO awb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Sega Sísansabé anebahréra Manikánsabe iwíáh íwíáh atáh náhtápéq míótaq seyensabé, Aneq iwíáho? Mah tahutáhúrúnarabeq Sísa íre sinawire íwíáho uwe. ");
INSERT INTO awb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Manikáne ehweh mibeq mahbeq arítáh kéreq Péhrasi kereqka ómiyabé, Sísa karábúsi aranéhboq tagehrataq sereíéro uwe. ");
INSERT INTO awb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ite Asiu kené sótaikú iahreraq ko tánáhráq áhníbóránútaq abapete morá wéhékáh kotaq Sísaga Pétáni suwahpeq Árásárúsi, iriato ani nawahpeq kúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sega penahnarabeqsabé táhútáhúq áwúwe. Máhtaga tíwe náriuwara Árásárúsireq mó kereq Sísarerue moráráq táhutahuruwe. ");
INSERT INTO awb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Máhríaga kaweq werí áhnte moné tahnsa wérí Sísane aigárátáq antiarena wene íre wahto ayáhrátáté sobarúq auwowe. Mi werí kaweq kunkúni werí púana nahupeq moke kaweq kungúnúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sísa kéro aní, wene naruo koweriranaú aní wenáwíq Súrásae. We mó awíq Ísíkáríótie. ");
INSERT INTO awb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Wega Sísansabé, Mi werí áhnte moné tahnsa wéríe. Aneqsabé mi werí 300 móne paiqmarena mi moné tabonah ke íre náriro úwe. ");
INSERT INTO awb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mi ehwéhmé Súrásaga tabonah keyabé íre arutaboiraritasa pehipi irarúwe. We aebó ání púana irarúwe. Itene morábí móné únáhtáq wahnahnéna mi moné aebó mewe paiqna paiqnaúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sísaga sensabé, Mi iní pehragatáhro. Íné maisaréhrataqsábé mi werí abaq intéhre. ");
INSERT INTO awb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tabonah kewe ahriahri iteba mía míowe. Ínéwé ahriahri iteba íre mía míainie úwe. ");
INSERT INTO awb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Áhnte Asiu kegá Pétáni suwahpeq Sísa míéhre u irera mitaq suwe. Íre peh morá Sísa tagéyabe suwe. Árásárúsi Sísaga oganúq ato aninseq taganeheéra suwe. ");
INSERT INTO awb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Manikáne ehweh mibeq mahbeq arítáh kégá Árásárúsi moq subiq suanehe éra sío síouwe. ");
INSERT INTO awb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Árásárúsi oganúq atonsabe tagéra áhnte Asiu kegá Manikáne ehweh mibeq mahbeq arítáh ké suera Sísansabé aiq pútare ató púara Árásárúsi moq subiq suanehe íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ahbiah tahnsá táhutahururabeqsabé su ke áhnte kegá Sísa Sarúsarama suwahpeq sinawire u irera ");
INSERT INTO awb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ahtapeq koáwénunuwe. Áwénunéra awanká ayahnawe mewera anotahtaq mahraréra, Manikánsabe iwíáh íwíáh atone. Maniká áwírue si anínsábé iwíáh íwíáh atone. Ísara kené Wahnahnsabé iwíáh íwíáh atone uwe. ");
INSERT INTO awb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Manikáne ehwehnka irarinserah Sísaga tónki meqme mi kane abobiahtaq kierútu agúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mi ehwéhnká mahraréna, Sáíóna suwahpeqte kéo, íre áhreéq tagaríáhro. Itene Wahnahnka iteba sirana tónki áráhqka áhkokóuwena sire ire. ");
INSERT INTO awb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Minayabe mi tanáhráq ite we kérahwána kegá íre iahtebahwane. Sísa oganúkéna Maniká míorabeq pokútaq ite mi ehwéh iahreraq matawéq iwíáhéq, Mi ehwéhnká irarinserah aiq miraurowe ewane. ");
INSERT INTO awb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Menah tahnsa Sísaga Árásárúsi maisarórabeqte áhrabue oganúq atowara tago kegá mitaq teri mahtaq terinuwe. ");
INSERT INTO awb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tago kegá mi otáq sánsá mitaq teri mahtaq terinu puara áhnte kegá irera ahtapeq Sísa koáwénunuwe. ");
INSERT INTO awb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Péhrasi kegá abiahnsanéra seye náhenéra, Aiq tagaho? Ite iuwahbeh arámbéhrí íre miraorahúne. Ómi mah kehinánká we kéráhwe uwe. ");
INSERT INTO awb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Káríki ehwéhnkákáq kéreq Manikánsabe iwíáh íwíáh ataneheéra táhutahururabeq kowíówe. ");
INSERT INTO awb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Sega Pírípi, we Pétásáíra suwahpeq Kehrari marákórápéqté ánípá séra wensabé, Ite Sísa taganeheéq súne uwana ");
INSERT INTO awb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pírípiga Ehntaru koreawuwe. Mi anítégá Sísa teawúyana ");
INSERT INTO awb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sísaga sensabé, Íné wehukení úku anímé anotah aní úké tanáhráq awehraq tanáhráre. ");
INSERT INTO awb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kawerue írátíáhtao. Ayu pehipi kahnaraq íre iyanae. Mi ayú marakóipeq megue mugurúqme kirahnaraq áhnte mó será iyanae. ");
INSERT INTO awb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Seyene iwíáhyabe sirutaboiro kewé oga mérapeq íre awaq míáhwe. Mah marákóípéq mé tanahráq seyene iwíáhyabe suwahrieh kewé oga mérapeq awaq míáhwe. ");
INSERT INTO awb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Néne arambehri miraéyabe inaraqmé séníráhro. Íné míáhnarabeq néne arambehrira kereq mía míaonehe. Néne arambehrira keyábé Nániboga kawerowe aritankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sísaga mó mahraréna, Nirupipeq anotah uméhínsábé Nánibonsabé aneq ehwéh teawinínkono? Nániboo, mi tanáhráq sineho teawinínkono? Írakaumo. Wehukene ahbabáqsabe pukinieéna tumíarauge. ");
INSERT INTO awb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nániboo, áhnte kegá arenáwíq pankeráhro arito úwe. Úwana íópeqté éhwéhnká mahraréna, Néníwíq aiq pankeráhro arítóge. Mónkakáq mirainauge úwe. ");
INSERT INTO awb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Soruparíó kega mi ehwéh írówe. Mó kegá, Puruburuire uwara mó kegá, Íópeqté ánínká ehweh teawíre uwe. ");
INSERT INTO awb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Uwana Sísaga sensabé, Íre ínénsabe peh itega irageheéna mi ehwéh irarire. ");
INSERT INTO awb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ahbabáq kehiná kéhínánsábé ehweh arite tanáhráq amahnága awehrarire. Ahbabáq kehiná kéhínáné wahnah kaqsue tanahráq amahnága awehrarire. ");
INSERT INTO awb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sega íné marakóipeqté pankeréhrataq ómi ínéba sabirinie úwe. ");
INSERT INTO awb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","We pukína sansá sokigi ariena we pankeréhransabé irarúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Soruparíó kega Sísansabé, Ite írátíonawe Manikáne ehwehnka mahraréna, Ite meirena kaweraitankeheéna Manikánka omaq ato aní ahriahri mía míainkehe ire. Minayabe sega wehukení úki aní awankátaq táhparera pankerageheénawe árahinsabé irareno? Wehukení úki anímé insebo uwe. ");
INSERT INTO awb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Uwana Sísaga sensabé, Íné téhrehnka inserahnu aní iteba wahto tanáhráq míanie. Sunkíkírirabeq míáh kégá ah íre tagahrahéra aiq nogunapómo íwíáhowe. Minayabe amahnága íné téhrehnka inserahnu anípá míáhro. Sunkíkírirabeq míehboq ínéba míáhro. ");
INSERT INTO awb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iteba míótáq téhrehnka inserahninkehboq íné téhrehnka inserahnu anínsábé aiq pútare aintáhro úwe. Sísaga mah ehwéh iraréna mitaq suena kopéragúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sísaga áhnte otáq sánsámárínúwara tago kegá wensabé íre aiq pútare atera peh anetaníbo uwe. ");
INSERT INTO awb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Minayabe Manikáne ehweh irarú ani Áísáíaga irarú ehwehmé aiq pútaragúwe. Wega mahraréna, Itene Wahnahno, itega teriuna ehwéhmé sega íre aiq pútare aitáh mino. Itene Wahnahne ótaq sansámárímé tagéq anetaníbo íwíáho mino úwe. ");
INSERT INTO awb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Minayabe sega íre aiq pútare atahráhowe ire. Áísáíaga mó mahraréna, ");
INSERT INTO awb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Manikánka siura mútúritena sirupipeq págege arítéhre. Minayabe sene siura íre ebioráhowe. Peh mútúrawéra sirupipeq íre ahtebowe. Sega ínéba íre sewe. Minayabe sene ahbabáq íre kawerarítóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Áísáíaga Sísansabé iwíáhéna anotah aní míéhre éna ahtebéna mi ehwéh irarúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Áísáíaga irarúnserah áhnte Asiu kegá Sísansabé íre aiq pútare atówara mó áhnte Asiu kereq sene wahnahmarínseqka Sísansabé aiq pútare atera Péhrasi keyábé áhreu puara mó ke íre teríúwe. Momiwíu nahtápéq Péhrasi kegá kaqíúwéhoéra mó ke íre teríúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Manikánka kawerowe aritonsabe peh ákáhtaq sirútábóíréra wehukega kawerowe arítónsabe anotah sirútábóírúnsabe mó ke íre teríúwe. ");
INSERT INTO awb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sísaga anotahtaq mahraréna, Ínénsabe aiq pútare aintáh ké íre ínébataq ínénsabe aiq pútare aintáhwe. Íné eqmaq núwéh ánínsábéákáq aiq pútare atáhwe. ");
INSERT INTO awb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Íné tagah kewé íné eqmaq núwéh ánínkákáq tagahwe. ");
INSERT INTO awb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mah kehiná kéhíná míáhrabeq téhrehnka inserahnuge. Ínénsabe aiq pútare aintáh kégá sunkíkírirabeq íre mía míaigeheéna tumíarauge. ");
INSERT INTO awb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Néne ehweh siahrega irera anetaníbo íwíáho keyábé íre ehweh aritoge. Mah kehiná kéhínánsábé ehweh aritanieéna íre tumíarauge. Peh sene ahbabáqsabe kaweraritanieéna tumíarauge. ");
INSERT INTO awb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ínénsabe suwahrieh kewé néne ehweh íre íráh kéwé néne ehwehnka anehe tanahráq ehweh aritankéhe. ");
INSERT INTO awb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Íre ínénéne iwíáh ehweh irare irareuge. Nánibo íné eqmaq núwéh ánínká iwíáh aintena mahrarúno éna niahreraq intéh éhwéh tei teinuge. ");
INSERT INTO awb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Íné írátíómé wene ehweh sehgironka oganúq sitankéhe. Minayabe Nániboga terio i ehwéh tei teinuge úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ite Asiu kené sótaikú iahreraq ko tánáhráq ahbiah tahnsá Sísaga iwíáhéna, Amahnága íné mah marákó suena Nániboba poké tanáhráq awehrarire úwe. Sísaga mah marákó márákóípéqté we tagaríáh kéyábé ahriahri arutaboiraitena pukinaú tanahráqkákáq anotahtaq arutaboiraitowe. ");
INSERT INTO awb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Owainawanka Sáímóni, Ísíkáríótine ahninkáwá Súrásane arupipeq Sísane naruo koweriro íwíáh atowe. Iwíáh atowaq ite we kérahwána kegá penorabeq Sísareq moráráq táhutahurowane. ");
INSERT INTO awb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sísaga iwíáhéna, Íné niyahtebome Nániboga moke náníre éna Maniká míéhrabeqte tuena mébeq tuekinauge éna ");
INSERT INTO awb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","táhutahururabeqte irigéna wene káhq ambántá akairuena táhúri úbíqmiowe. ");
INSERT INTO awb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Táhúri úbíqmena wání antehyapípéq ahkiwena peh nahupeqte árámbéhrí ání tahnsanéna ite we kérahwána kené igárátáq pabeq paberaitena úbíqmatio tahuríráté sobarúq iuwowe. ");
INSERT INTO awb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sobarúq iuwena Pítaba súwana Pítaga wensabé, Néne Wahnahno, nigárá pabeq paberaintaníbo úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Úwana Sísaga wensabé, Amahnága miraunsabé are íre tagariahne. Mókake tagariankehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Úwana Pítaga wensabé, Amahnágaákáq mókakeakáq arega nigárá pabeq paberaintanie énawe ahqáho ataníe úwana Sísaga wensabé, Ínéga íre pabeq paberatáhnaraqme arega íné íre sénirahráhóne úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Úwana Pítaga wensabé, Néne Wahnahno, minayabe íre peh morá nigárá pabeq paberainto. Moke niyahnkakaq niyahqnonkakaq pabeq paberainto úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Úwana Sísaga wensabé, Sinonka pabeq pabero ke peh morá náwíbagi sigárá pabeq paberowe. Sinonka íre náwíbagi puara mó íre pabeq paberigehe. Ite íre náwíbagiraq míáhwanawe peh morá ání náwíbagire úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sísaga wene naruo koweriranaú aní tagario púana mahraréna, Ite íre náwíbagiraq míáhwanawe peh morá ání náwíbagire úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sísaga sigárá pabeq paberarito parabagúwana wene káhq ambántá abaqme tútuue ména sensabé, Ínéga miraitónsábé iahtebaho? ");
INSERT INTO awb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Itega ínénsabe, Íwáhnoraníne aintáhwe. Itega moq itene Wahnahne aintáhwe. Itega irare intáhwana aiq míóge. ");
INSERT INTO awb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Íné itene Wahnah, ite íwáhnoru anínká itene igárá pabeq paberaitónsábé itega wene wene aigárá pabeq paberatéhoro. ");
INSERT INTO awb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ínéga sokigi aiú serahnoro. ");
INSERT INTO awb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kawerue írátíáhro. Arambehri anínká wene wahnah íre kiotaikire. Poki anínká we eqmaq áúwéh ánímé íre kiotaikire. ");
INSERT INTO awb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Minayabe ite tagaríáh púaq irupipeq eyoyóinkehboq we séhréh atéhoro. ");
INSERT INTO awb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Íre ite ómiyabé mi ehwéh iraruge. Ínéga omaq itáráu anímárí tagaríóge. Manikáne ehwehnka mahraréna, Moráráq táhutahururauya anínká néne naruo aní úkire ire. Mi sehirá aiq pútaraginawire. ");
INSERT INTO awb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mirainie insabé teiúge. Mótaq mirainkehe. Mi tanáhráq sehiranka ínénsabe irarime aiq pútare atageheéna amahnága teiúge. ");
INSERT INTO awb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kawerue írátíáhro. Mó kegá ínéga eqmaq sutau ke mehweh arítáhtáq ínénkakaq mehweh aintáhwe. Íné mehweh aintáh kégá íné eqmaq núwéh ánínkákáq mehweh atáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sísaga mi ehwéh iraréna wene arupipeq págegeúnsabe mahraréna, Teiníboq írátíáhro. Ite míáhrabeqte ánínká néne naruo kowerirankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kowerirankéhe únsabe ite we kérahwána kegá wenku ebiqsúéheéq irupipeq iwíáhéq insensabebómo ewane. ");
INSERT INTO awb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Íné Sísaga arutaboiraintéh ánímé wereq ínéreq moráráq tútuue míahwaye. ");
INSERT INTO awb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pítaga ínénsabe aonáh sabiq suena, Wega irari aní insensabebo kaseninanao úwana ");
INSERT INTO awb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ínéga Sísane anepeq mósaqmaqme ména, Néne Wahnahno, we inseboue kasenowae. ");
INSERT INTO awb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kasenowana Sísaga ínénsabe, Ínéga táhutahuq pámbáhue náwéna aní we wire éna táhutahuq pámbáhue Súrásawe, Sáímóni Ísíkáríótine ahninkáwá náwuwe. ");
INSERT INTO awb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Súrásaga mi tahutáhúq meyotaq owainawanka wene arupipeq ahbabáq iwiáh atowe. Sísaga Súrásansabé, Arega mirainie inaraq amahnága komiraúno úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Úwaq ómi ite táhutahurowanarabeqte kégá mi ehwéh ireq iwíáhéq, Árahinsabé irariro ewane. ");
INSERT INTO awb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Súrásaga itene morábí matiahwana moné únáhtáq wahnahnú púaq táhmaro ite iwíáhéq mó tahutáhúq kobaiqmaro íwíáhénabopoq eqmaréhre. Tabonah ke nário íwíáhénabopoq eqmaréhre íwíáhowane. ");
INSERT INTO awb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Súrásaga mi tahutáhúq mewena máhpeq tueyokúwe. Máhpeq tueyokúmé inokáhpere. ");
INSERT INTO awb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Súrásaga máhpeq tueyokúwana Sísaga mahraréna, Amahnága íné wehukení úku aní néníwíq pankeragéhe. Ínénsabe iwíáhéra Maniká áwíq pankeragéhe. ");
INSERT INTO awb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Maniká áwíq pankeráhwana wega néníwíq pankerankéhe. Wega amahnága pankerankéhe. ");
INSERT INTO awb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Néne animáríno, Pehgáriq tanáhráq iteba míanie. Pokonaraq itega íné ninebahrigehe. Ínéga Asiu ke teríátáunserah teiníe. Ínéga pokonarabeq itega amahnága íre kioráhowe. ");
INSERT INTO awb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Néne o sansa miraigehboq teiníe. Itega wensabé wensabé irutaboiratéhoro. Ínéga itensabé nirutaboirunserah itega wensabé wensabé irutaboiratéhoro. ");
INSERT INTO awb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Itega wensabé wensabé irutaboiratéh irataqmé ómi kegá íné séníráh ké wóe aitagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sáímóni Pítaga Sísansabé, Néne Wahnahno, eheq kinibo úwana Sísaga wensabé, Íné pokinieurabeq amahnága íre sénirankéhe. Mókake sénirankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Úwana Pítaga wensabé, Néne Wahnahno, amahnága aneqsabé íre kéranínkono? Sega nubiq suaneherabomo. Anetaníbo. Are éhnehinauge úwe. ");
INSERT INTO awb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Úwana Sísaga wensabé, Arega níéhnehinkehboq ínéreq pukoyehe íwíáhono? Teawiníboq írátíahno. Kokórega ehwehnina ínaraq arega íné íre tagaríóge apahtáróráq irariniewóne úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sísaga mó mahraréna, Itene irupipeq iwíáh kikiriyeho. Manikánsabe aiq pútare ateq ínénsabeákáq aiq pútare aintáhro. ");
INSERT INTO awb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nánibone nahtapeq áhnte paqnáh kéhre. Íre kéhtáq tahirímé métáq teiú irino. Itene máhriq kigawerinieéna pokinauge. ");
INSERT INTO awb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kawerarena kiwekue tumeiranauge. Íné míórabeq mía míaigeheéna tumeiranauge. ");
INSERT INTO awb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Íné pokinieurabeqte áh tagaríáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Úwana Tómáhsiga wensabé, Itene Wahnahno, are pokinie énarabeqme íre tagarione. Mi ah árahue tagarianehnkono úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Úwana Sísaga wensabé, Íné Maniká míéhrabeqte áhne. Íné aiq pútaq ehwéh áwahe aní múge. Íné oganúq itahráhu aní múge. Nánibo míéhrabeqte áh múge. Íre mó ahnkákáq ínébataq ah múge. ");
INSERT INTO awb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Itega íné tagaríáhmé Nánibonkakáq tagaríáhwe. Amahnágaákáq mókakeakáq Nánibonsabé itene irupipeq iwíáhue tagarawéq itene iuranka tagahwe úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Úwana Pírípiga Sísansabé, Itene Wahnahno, Iteribo taganehboq sokigi aio. Sokigi aínaraq aiq awehraq kanae úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Úwana Sísaga wensabé, Pírípio, ínéga itereq íre wahto tanáhráq míarauge. Árahinsabé íné íre tagariahno? Íné tagah kegá Nánibo moq tagahwe. Iteribo taganehboq sokigi aio énawe árahinsabé irareno? ");
INSERT INTO awb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ínéga Nániboba mía míaugana wega ínéba mía míaire. Minayabe íre aiq pútare aintahno? Íné teiú éhwéh íre ínénéga iwíáhugana Nániboga ínéba mía míaéna wewega arambehrire. ");
INSERT INTO awb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ínéga Nániboba mía míaugana wega ínéba mía míaire teienaq mi ehwéhnsábé aiq pútare aintáhro. Mi ehwéhnsábé itega íre aiq pútare atéhrame ínéga sokigiona arámbéhríyábé aiq pútare aintáhro. ");
INSERT INTO awb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kawerue írátíáhro. Ínénsabe aiq pútare aintáh kégá ínéga miraona arámbéhrí miraigehe. Nániboba pokinau puana sene arambehriga néne arambehri kiotaiqme kanae. ");
INSERT INTO awb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Néníwírue tenírataq mirainie. Íné wenahninká mirau arámbéhrí Nánibo áwíq pankerageheéna mirainie. ");
INSERT INTO awb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Néníwírue teníra ehwéhmé moke mirainie úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sísaga mó mahraréna, Itega ínénsabe iuwahbáhnaraqmé néne sánsá sehgigéhe. ");
INSERT INTO awb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nánibo teawenana wega mó séhréhína aní iteba mía míainkeheéna eqmarankéhe. ");
INSERT INTO awb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Aiq pútari aní Manikáne Awa iteba mía míainkeheéna eqmarankéhe. Ahbabáq kehinánká Manikáne Awa íre tagéra sirupipeq íre tagaríáh púara wereq íre mía míaorahowe. Itega we tagaríáhwana iteba mía míaéna irupipeq mía míainkehe. ");
INSERT INTO awb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ite íre airaiq iuwaníe. Ite íre ehneranimárí tahnsa míageheéna mókake iteba kiwekinauge. ");
INSERT INTO awb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mótaq ahbabáq kehinánká íné mó íre tagagehe. Itega íné tagagehe. Íné oga mía míau puaq ite moq oga mía míaigehe. ");
INSERT INTO awb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mi tanáhráq sínaraqmé ínéga Nániboba mía míaonaq tagariagehe. Itega ínéba mía míairana ínéga iteba mía míaonaq tagariagehe. ");
INSERT INTO awb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Néne ehweh irena kawerue sehgí ánímé ínénsabe awahbehre. Ínénsabe awahbeh anímé Nániboga wensabé arutaboiratankéhe. Ínéga wensabé nirutaboiratena néne sánsá sokigi awinauge úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Íre Súrása Ísíkáríóti peh mó Suráságá Sísansabé, Itene Wahnahno, árahinsabé ahbabáq ke íre sokigi ariasa peh morá ite arene sánsá sokigi aieno úwe. ");
INSERT INTO awb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Úwana Sísaga wensabé, Ínénsabe awahbeh anínká néne sánsá mirainkehe. Néne sánsá miraínaraq Nániboga wensabé arutaboiratankéhe. Nániboreq ínéreqka weba séta wereq mía míaoyehetauye. ");
INSERT INTO awb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ínénsabe suwahrieh kegá néne ehweh íre sehgigéhe. Ínéga teiú éhwéhmé íre ínébataq néne ehwehne. Minawé Nánibo íné eqmaq núwéh áníné ehwehne. ");
INSERT INTO awb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Iteba mía míautaq mah ehwéh teiúge. ");
INSERT INTO awb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nániboga séhréhi aní Manikáne Awa néníwírue eqmarahnana ite moke íwáhnorinkehe. Ínéga moke teiéna ehwéh Manikáne Awanka ahreraq itankéhe. ");
INSERT INTO awb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Íné niru ukiqme míónserah ite moq iru ukiqme míáhro aitóge. Ínéga aitónserah ahbabáq kehinánká íre miraorahowe. Itene irupipeq iwíáh kikiréq áhreiyeho. ");
INSERT INTO awb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Iuwena pokéna iteba kiwekinie teiewógaq íráh mino. Itega ínénsabe irutaboiraintáhmé itene irupipeq eyoyóire. Nániboga íné kiotaiqme míéh ání míre. Ínéga weba pokinaunsabé itene irupipeq eyoyóoro. ");
INSERT INTO awb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mótaq sína tanáhráqsábé teiúge. Mi tanáhráq sínaraq itega néne ehwehnsabé aiq pútare aintageheéna amahnága teiúge. ");
INSERT INTO awb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Amahnága ahbabáq kehiná kéhínáné wahnahnka sínana íre áhntetaq teiníe. Wega íné íre saiqnaríéhre. ");
INSERT INTO awb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nánibonsabé nirutaboirume mah kehiná kéhínánká tagariageheéna wega tení árámbéhrí mirauge éna ite we kérahwána keyábé, Pokonehboq irigoro úwe. ");
INSERT INTO awb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Sísaga mó mahraréna, Íné náhníáq tahnsanugana Nániboga náhníáq sera sotaq wahnahni aní míéhre. ");
INSERT INTO awb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Néne niyahnawe sera íre íyéhmé Nániboga apirúéhre. Sera íyéh níyáhnáwéwé áhnte mó será iyankeheéna apiruqme kaweq kaweraréhrana áhnte será íyéhre. ");
INSERT INTO awb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mina inserah ínéga teiú éhwéhnká itene irupipeq kaweraitéhre. ");
INSERT INTO awb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Itega ínéba mía míairana ínéga iteba mía míaono. Pehipi kéh áyáhnáwéwé sera íre iyahráhire. Mina inserah itega móbeq míéhrataqmé íre serankakáq míaneheqmóe. ");
INSERT INTO awb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Íné náhníáq tahnsanugaq ite náhníáq ayahnawe tahnsá móe. Itega ínéba mía míairana ínéga iteba mía míainie. Ínéba mía míaira kewé áhnte serankakáq mía míaoneheqmóe. Peh itebataq mía míairataq iteriahríáh mó naneq íre miraorahowe. ");
INSERT INTO awb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Antegi áyáhnáwé súéhrana ehyataginserah ínéba íre mía míao kewé mina tahnsanowe. Mi ayáhnáwé sorupawe mewena iraipéq móruahnana taginawire. ");
INSERT INTO awb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Itega ínéba mía míaéq ínéga teiú éhwéh íréhrataqmé iwíáhue teníéro. Tenirana mirainie. ");
INSERT INTO awb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ite áhnte será íyéhrara tagah kegá Maniká áwíq pankeráhwe. Áhnte será íyéh púaq ite íné séníráh ké míáhwe. ");
INSERT INTO awb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nániboga ínénsabe arutaboirinserah ínéwé itensabé nirutaboiruge. Ínéga itensabé nirutaboiru puaq ínéba mía míaoro. ");
INSERT INTO awb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ínéga Nánibone sánsá sehgíúnsábé wega ínénsabe arutaboiraintéhrana weba mía míauge. Weba mía míaunserah itega néne ehweh sehgírataq ínéga itensabé nirutaboiraitahnaq itega ínéba mía míaigehe. ");
INSERT INTO awb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Irupipeq eyoyó aitanieéna mah ehwéh teiúge. Peh irupipeq anotah eyóyóinkeheéna mah ehwéh teiúge úwe. ");
INSERT INTO awb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sísaga mó mahraréna, Néne sánsámé ínéga itensabé nirutaboirunserah itega wensabé wensabé irutaboiratéhoro. ");
INSERT INTO awb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wene iyahnabo kaweraritanieéna minayabe pukinaína anímé anotah arútábóíri aní míre. Moke mó sirutaboiro kegá mi aní íre kiotaikorahowe. ");
INSERT INTO awb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Néne ehweh sehgíó kéwé néne iyahnabo woe. ");
INSERT INTO awb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Arambehri anímárí íre úqitaníe. Arambehri aní wene wahnahne náneq íre ahtebeh púana itensabé arambehri anímárí íre úqitaníe. Nániboga tení éhwéh moke teiú púana néne iyahnabo anímárí úqítóge. ");
INSERT INTO awb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Itega íné íre omaq intárówana ínéga ite omaq itáráuge. Náhníáq ayahnawe áhnte será íyéhnserah ite néne niyahnawe méq áhnte será iwe kagainkeheéna omaq itáráuge. Áhnte será kéhnsábé itega néníwírue Nánibonsabé teawírataqmé wega mirainkehe. ");
INSERT INTO awb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ínéga teiúmé wensabé wensabé irutaboiratéhoro úwe. ");
INSERT INTO awb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sísaga mó mahraréna, Ahbabáq kehiná kéhínánká itensabé suwahríáhnaraq téhwe ínénsabe suwahriehre íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ite ahbabáq kehiná míáhtáq tahirímé mó ahbábáq kéhínánká sensuwahrahyabé sirutaboironserah itensabé moq sirutaboiro irino. Ínéga ite omaq itáráugaq ahbabáq sansa sueq kaweq ke úkuro puara ahbabáq kega itensabé suwahriehre. ");
INSERT INTO awb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Arambehri anínká wene wahnah íre kiotaikire teiewónsábé ahreraq matíáhro. Ahbabáq kega íné níwíoqnah puara itenkakáq moq íwíoqnagehe. Sega néne ehweh íráhtáq tahirímé itene ehwehnkakáq íráh irino. ");
INSERT INTO awb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ite néne animárí míáh púara sega ite íwíoqnagehe. Sega íné eqmaq núwéh ání íre tagaríáhnsábé íwíoqnagehe. ");
INSERT INTO awb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Íné íre sena ehweh íre teríútáq tahirímé sene ahbabáq peh kopípéq kéh irino. Ínéga teríúnsábé sene ahbabáq amahnága ábóraq kéhrara sega, Itega árahue ahbabáruno íre irarerahowe. ");
INSERT INTO awb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ínénsabe suwahrieh kegá Nánibonsabé moq suwahriehre. ");
INSERT INTO awb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Néne ótaq sansámárí se íre sokigi aríútáq tahirímé sene ahbabáq peh kopípéq kéh irino. Néne ótaq sansámárí tagahnsabé sene ahbabáq ábóraq kéhrara ínéreq Nániboreqsabé suwahriehre. ");
INSERT INTO awb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Manikáne ehwehnka mahraréna, Sega ínénsabe pehipi suwahriehre ire. Mi sehiránká aiq pútaragire. ");
INSERT INTO awb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ínéga Nánibo míéhrabeqte séhréhi aní, aiq pútari aní, Manikáne Awa iteba eqmaraníe. Wega tuinaraq néné arambehriakáq néne sánsánkákáq pahsuankéhe. ");
INSERT INTO awb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Téhwe itega séníráh púaq itega moq néne ehweh terigéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sísaga mó mahraréna, Mókake itega ínénsabe anetaníbo éq nuwanéhe íwíáhiyeho éna amahnága mah ehwéh teiúge. ");
INSERT INTO awb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sega ite momiwío nahtápéqté kaqiuwagéhe. Mó tanáhráq ite iubiq suaneherao kegá iwíáhéra, Ínénsabe aiq pútare atáh ké subiq suonawe mina Manikáne arambehrie igehe. ");
INSERT INTO awb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sega Nániboreq ínéreq íre tagaríáh púara mina tahnsa oneherawoe. ");
INSERT INTO awb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sega miraira tanáhráq sínaraq itega néne ehweh ahreraq matiageheéna mah ehwéh teiúge úwe. Sísaga mó mahraréna, Iteba mía míau puana mah ehwéh íre teiátáuge. ");
INSERT INTO awb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Íné eqmaq núwéh ánípá pokinieu puana amahnága teiúge. Itebaté mó morá ánínká ínénsabe, Eheq pokono ue íre kasenire. ");
INSERT INTO awb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ínéga mah ehwéh teiúnká itene irupipeq anotah uméhire. ");
INSERT INTO awb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Teiníboq írátíáhro. Íné pokinie ume aiq kawerire. Ite séhréh aitanieéna pokinie. Íné mahtaq míáhnaraqmé ite séhréhína anínká iteba íre tuoráhire. Íné pokonaraq iteba we eqmaq auwaníe. ");
INSERT INTO awb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Eqmaq auwáhnaraq Manikáne Awanka iteba tuinagake ite mah kehiná kéhínáné ahbabáqsabe kaweqtaq méyabe íwáhnorinkehe. Manikánka ehweh aritahnayabé moq íwáhnorinkehe. ");
INSERT INTO awb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Sega ínénsabe íre aiq pútare aintáhnsábé minawé ahbabáq míre éna íwáhnorinkehe. ");
INSERT INTO awb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nániboba pokonaq íné íre tagehra puana kaweqtaq méyabe íwáhnorinkehe. ");
INSERT INTO awb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Manikánka ahbabáq kehiná kéhínáné wahnah aiq ehweh atéh púana ehweh aritahnayabé íwáhnorinkehe. ");
INSERT INTO awb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ehweh teiénawe áhnte kéhraqme ite amahnága íre irahráhowe. ");
INSERT INTO awb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aiq pútari aní Manikáne Awanka tuinaraq ite moke íwáhnorinkehe. Íre wewene iwíáh iraréna peh wega írátíéh éhwéh teinkéhe. Mókake sína tanáhráqkákáqsábé teinkéhe. ");
INSERT INTO awb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Néne ehweh íwáhnorína puara áhnte kegá néníwíq pankeragéhe. ");
INSERT INTO awb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Moke Nánibone sánsámárímé wereq ínéreqne sánsáne. Minayabe ínéga teiú éhwéhmé Manikáne Awanka íwáhnorinkehe teiúge úwe. ");
INSERT INTO awb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sísaga mó mahraréna, Pehgáriq tanáhráqmé itega íné mó íre tagagehe. Anehe pehgáriq mó tanáhráqmé itega íné tagagehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Úwara táhmaro we kéró kega seye náhenéra, Mi ehwéhmé íre irone. Aneq ehwéhpo? Wega teiena, Pehgáriq mó tanáhráqmé itega íné mó íre tagagehe. Anehe pehgáriq mó tanáhráqmé itega íné tagagehe ire. Wega mó teiena, Nániboba pokinieu puaq itega íné íre tagagehe ire. ");
INSERT INTO awb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Anehe pehgáriq tanáhráre ime aneq ehwéhpómo? Minawé ite íre irone éra seye náhenuwe. ");
INSERT INTO awb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Seye náhenuwana Sísaga iwíáhéna, Sega ínénsabe kasenonehe éna wega sensabé, Ínéga métáq mahraréwóge. Pehgáriq tanáhráqmé itega íné mó íre tagagehe. Anehe pehgáriq mó tanáhráqmé itega íné mó tagagehe éwóge. Minayabe itene irupipeq iwíáhéq kasenoo? ");
INSERT INTO awb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Teiníboq írátíáhro. Itene irupipeq anotah uméhínaq ibisagehe. Ibisehrara ahbabáq kega sene sirupipeq eyoyóínara wíréh wíréhigehe. Ebeqme itene irupipeq umehue págege ínana anehepeqme itene irupipeq eyoyó aginawire. ");
INSERT INTO awb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ani maqmianaitaq uwo uwoinsabé mi iníné arupipeq éri puana anotah uméhire. Maqsuena wene ani míéh púana wene arupipeq eyoyóirana éréwéhnsábé mó íre iwíáhire. ");
INSERT INTO awb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mina inserah amahnága itene irupipeq umehirana ínéga ite mó tagahnagake itene irupipeq eyoyóinkehe. Itene irupipeq eyoyóínara mó kegá mina íre kaqiuwahráhowe. ");
INSERT INTO awb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mi tanáhráqmé itega ínénsabe mó ehwéh íre tenigéhe. Teiníboq írátíáhro. Nánibonsabé néníwírue iwíáhue teawírataq wega mirainkehe. ");
INSERT INTO awb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Menahmé itega íre néníwírue teawátówe. Itene irupipeq anotah eyóyóinkehboq Manikánsabe teawéro. Teawírataq wega mirainkehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Sísaga mó mahraréna, Pabeqme ehwéhnue tei teinurauge. Mi tanáhráq pabeqme ehwéh mó íre teiasa peh Nánibo éhweh pahsuqme teiníe. ");
INSERT INTO awb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mi tanáhráq itega néníwírue wensabé teawigéhe. Nánibonsabé, Ite séhréh arito ue íre teawiníe. ");
INSERT INTO awb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ahqáho. Iteitega we teawigéhe. Maniká wewega itensabé arutaboiraitéhre. Itega ínénsabe irutaboiraintáh púana Nániboga itensabé arutaboiraitéhre. Maniká míéhrabeqte tumíaraunsabé aiq pútare ainteq ínénsabe irutaboiraintáh púana Nániboga itensabé arutaboiraitéhre. ");
INSERT INTO awb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nánibo míéhrabeqte mah marákó márákóípéq tumíarauge. Tuména amahnága mah marákóípéq suena Nániboba tuekinie úwe. ");
INSERT INTO awb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Úwaq ite we kérahwána kegá Sísansabé, Aiq irone. Arega amahnága íre pabeqme ehwéhnia peh tábúsoqme pahsuqme teiene. ");
INSERT INTO awb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Itega amahnága tagónawe arega moke ahtebawe tagariahne. Minayabe arega Maniká míéhrabeqte túnayabé aiq pútare atone. Arensabé mó kasenéyabe anetaníbo. Aiq pútare atone ewane. ");
INSERT INTO awb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ewanana Sísaga itensabé, Amahnága aiq pútare aintaho? ");
INSERT INTO awb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aiq pútare aintáhmé mótaqmé amahnága itega íné nuweq iteruwahpeq kobeq séberoneheqmóe. Íné nuwehrana ínébataq míanie. Nániboga ínéba mía míai puana íre ínébataq míanie. ");
INSERT INTO awb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ite ínéba mía míaonsabé iru ukiq itanieéna mah ehwéh teiúge. Mah marákóípéqmé mó tanáhráq mó tanáhrárue íre kaweq sunúq sinae. Ínéwé íre kaweq sunúqmé aiq kiotaiqme míó púaq iwíáh íwíáhoro úwe. ");
INSERT INTO awb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sísaga mi ehwéh irareruena íópeq tagéna Manikánsabe, Nániboo, íné pukona tanáhráq aiq awehrarire. Íné arenahninká arenáwíq pankeraníboq arega néníwíq pankero. ");
INSERT INTO awb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Arega moke mah kehiná kéhíná wahnahnúno aintáróne. Arega ínéba eqmaq suahna ke oganúq sito aintahne. ");
INSERT INTO awb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Arebataq aiq pútaq Manikáne. Arega íné Sísa Karáhé eqmaq núwátóne. Arereq ínéreqsabé aiq pútare aitáh kégá oga mérapeq aiq awaq míáhwe. ");
INSERT INTO awb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Arega teniena arámbéhrí miraue parabarúónsábé are págege aní mé anotah aní míahnara mah marákóípéqté kégá tagahwe. ");
INSERT INTO awb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Naho mah marákó márákó íre kotaq ínéga areba míáhwataq arereq ínéreq anotah aníté míahwaye. Nániboo, naho ite míahwayanserah amahnága mirainto. ");
INSERT INTO awb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Arega mah marákóípéqté ké ínéba eqmaq suahne. Mi kewé arene sánsá sokigi arítóge. Téhwe mi ke arene animárí mé ínéba eqmaq súátóne. Sega arene ehweh irera sehgíówe. ");
INSERT INTO awb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Arega moke níátóna naneqme peh arerenee. Minawé ínéba eqmaq suahna kegá aiq tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Arega teníátóna ehwéhmé moke teríátáugara íráhwe. Ínéwé are míahnarabeqte ánínugara aiq pútaq tagaríáhwe. Arega íné eqmaq núwátónayabé aiq pútare atáhwe. ");
INSERT INTO awb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Arega eqmaq suahna keyábé púrerarítóge. Amahnága moke mah marákóípéqté kéyábé íre púrerarítóge. Peh ínéba eqmaq suahna keyábé arene animárí púana púrerarítóge. ");
INSERT INTO awb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Moke arene animárímé néne animáríne. Moke néne animárímé arene animáríne. Mó kegá eqmaq suahna ke tagéra néníwíq pankeráhwe. ");
INSERT INTO awb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Amahnága areba kiníe. Íné mah marákó márákóípéq íre míáhnaraq eqmaq suahna kegá mahtaq míagehe. Nániboo, kaweqtaq mía míaóne. Arene págege awíq níátóne. Arega ínéba eqmaq suahna ke arene págege awíqtaq wahnahnarito. Arereq ínéreqka moráráq mía míaúyanserahnigehboq kawerue wahnahnarito. ");
INSERT INTO awb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ínéba eqmaq suahna kebá mía míaurautaq arenáwírue kawerue wahnahnarítáráuge. Kawerue wahnahnarítáráugara se íre taqnobagowe. Peh morá ání iraipéq tabikinai aní taqnobagire. Manikáne ehweh aiq pútaraginkeheéna taqnobagire. ");
INSERT INTO awb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Amahnága areba kiníe. Ínéba eqmaq suahna kené sirupipeq eyoyó aritanieéna mah marákóípéq ména mah ehwéh iraruge. ");
INSERT INTO awb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Arene ehweh aiq teríúge. Ahbabáq kehiná kéhínánká ínéba eqmaq suahna keyábé suwahriehre. Íné ahbabáq kene sánsá íre miraunserah ínéba mía míao kegá moq peh míáhwe. Minayabe ahbabáq kega sensabé suwahriehre. ");
INSERT INTO awb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Se mah marákó márákóípéqté meriqme mórítáhro íre teawúge. Peh owainawanka se ahbabáq aritehnehboq kawerue wahnahnarito teawúge. ");
INSERT INTO awb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Íné ahbabáq kene sánsá íre miraugara ínéba eqmaq suahna kegá moq ínéga unserahnéra ahbabáq sansansábé suwahriehre. ");
INSERT INTO awb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Arene ehwehme aiq pútaq ehwéhne. Se kaweqtaq mía míaigehboq arene aiq pútaq ehwéhtáté sirupipeq págege arito. ");
INSERT INTO awb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Arega íné mah marákóípéq eqmaq núwátónanserah ínéga se mah kehiná kéhíná suwahpeq eqmaq suaníe. ");
INSERT INTO awb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sega aiq pútaq arene animárí mía míaigeheéna íné arereq mía míainauge. ");
INSERT INTO awb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ínéba eqmaq suahna kewé íre sebataqsabé púrerarítóge. Sega mó ke terirara irera ínénsabe aiq pútare aintageheéna mi keyábéákáq púrerarítóge. ");
INSERT INTO awb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Sereq ínéba eqmaq suahna kereq peh morá íwíáhigeheéna púrerarítóge. Nániboo, arereq ínéreqka moráénúyanserah se ómi peh morá íwíáhigeheéna púrerarítóge. Arega íné eqmaq núwátónayabé mah kehiná kéhínánká aiq pútare atagéhboq peh morá íwíáh arito. ");
INSERT INTO awb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Arega íné págege ainte néníwíq pankerahnanserah ínéga se págege aritena sensíwíq pankeróge. Arereq ínéreqka moráénúyanserah sega morá íwíáhigeheéna sensíwíq pankeróge. ");
INSERT INTO awb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Eqmaq suahna ke moráénigeheéna sereq míóge. Are ínéreq míahne. Minayabe sega peh moráénirataq mah kehiná kéhínánká arega íné eqmaq nuwahna ehwéhnsábé aiq pútare atagéhe. Arega ínénsabe arutaboiraintahnanserah sensabé moq arutaboiraritahne. Wega peh morá íwíáhirataq mah kehiná kéhínánká mina tagéra arega arutaboiraritahna ehwéhnsábé aiq pútare atagéhe. ");
INSERT INTO awb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nániboo, ínéba eqmaq suahna kegá íné míáhnarabeq ínéreq sereq méyabe nuwahbehre. Mah marákó márákó íre kotaq ínénsabe arutaboiré néníwíq pankeróne. Are néníwíq pankerónayabé sega minaakaq anotahtaq téhreh naneqkakáq tagageheéna ínéreq méyabe nuwahbehre. ");
INSERT INTO awb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Naniboo, ínéga are aiq tagaríóge. Kaweqtaq mía míaóne. Ahbabáq kehiná kéhínánká are íre tagaríáhwe. Arega íné eqmaq nuwahnana sunsabé eqmaq suahna kegá aiq tagaríáhwe ");
INSERT INTO awb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ínéga arene sánsánsábé se sokigi arítóge. Mó sokigi arita aritainie. Arega ínénsabe arutaboiraintahnanserah sega mó keyábé sirutaboirigeheéna sokigi arítóge. Íné sereq mía míainieéna sokigi arita aritauge úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sísaga Manikánsabe mi ehwéh teawena pokúwe. Wereq ite we kérahwána kereqka Kirona aroipéq seberaebéq pokowane. Mitaq kaweq matábú kowaq itega mitaq kowíahwane. ");
INSERT INTO awb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Súrása, Sísane naruo koweriranaú anínká moq mi matábú tagariowe. Sísareq ite we kérahwána kereqka mitaq áhnte tanáhráq momiwíowanayabé tagaríówe. ");
INSERT INTO awb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Manikáne ehweh mibeq mahbeq arítáh kéreq Péhrasi kereqka Manikánsabe iwíáh íwíáh atáh náhtápéqté párísíwárínseq sóntía kereq eqmaq súówe. Eqmaq súó kereq Súrásaga meriqmena mi matábúráq súwe. Sega sahmárínkákáq áráhmuakáq kánéqkakaq mewera suwe. ");
INSERT INTO awb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sísaga sega miraoneherau naneq wene arupipeq moke tagarawéna su ke taganieéna pehrápeq kowíowe. Kowéna sensabé, Insensabe anebahroo úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Insensabe anebahroo úwara sega wensabé, Sísa Néhsara suwahpeqte ánínsábé anebahrúne uwana Sísaga sensabé, Íné we uge úwe. Súrása, Sísane naruo koweriro anínseq mitaq iriwe míówe. ");
INSERT INTO awb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iriwe míowana Sísaga, Íné we uge teriutaq sega sinehepeqte atárue inahsubúwe. ");
INSERT INTO awb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sísaga mónkakáq kasenéna, Insensabe anebahroo úwara sega, Sísa Néhsara suwahpeqte ánínsábé anebahrúne uwe. ");
INSERT INTO awb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Uwana Sísaga sensabé, Íné we uge teiú mino. Ínénsabe ninebahrirataq mah anímárí pehragariteq pokoro arítáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sísaga métáq tahnsa Manikánsabe mahraréna, Kawerue wahnahnarítáráugara se íre taqnobagowe úwe. Mi ehwéh aiq pútaraginkeheéna mah anímárí pehragariteq pokoro arítáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sáímóni Pítaga wene poka matawéna Manikáne ehweh mibeq mahbeq arítáh kéné wahnahne arambehri aní wenáwíq Mákúsa apiwe wene púpeqte áhré kiraq auwowe. ");
INSERT INTO awb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kiraq auwowana Sísaga Pítansabé, Poka unahpí úsaro éna, Nánibone níérorahi arámbéhrí nirupipeq umehorahi arámbéhrí mirainau mino úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Úwara sóntía kereq sene wahnah anínseq párísiwarínseqka Sísa táhtoqme táhru táhruuwe. ");
INSERT INTO awb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Téhwe sega Sísa meqmera wehukení áwíq Ánásaba móátówe. Ánásawe Káíyápásane awarénawae. Sísa pukinaú opéq Káíyápásawe Manikáne ehweh mibeq mahbeq arítáh kéné wahnah míowe. ");
INSERT INTO awb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Káíyápásaga menah tahnsa Asiu ke teriena, Iteruwahrah ómi pukiyehboq peh morá ánínká kaweraitankéhboq pukinkehe. Mina aiq kawerire úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ite Sísa kérahwáya aníté Sáímóni Pítareq ínéreqka Sísa kérahwáye. Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka íné tagariowe. Wega íné tagarionsabe wene nahtapeqté mátábúrápéq Sísa kéráhwae. ");
INSERT INTO awb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pítaga méhpehpeqté ónsáráq kowíowe. Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka íné tagario púana ínéga onsarapéqté wáhnáh áhráríyábé, Onsa sio koreawéwae. Onsa sio teawena Píta meqmena mátaburaq móátáhwae. ");
INSERT INTO awb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mi ahrárígá Pítansabé, Are moq mah aní kérahna anípo úwana, Írakaumo. We íre kéróge úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Titirúnsabe arambehri kereq párísiwarínseqka ira parewe totorue míówana Píta moq iriwe ména totorúwe. ");
INSERT INTO awb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka Sísansabé we kéró keakáq wega síwáhnorú ehwehnkákáqsábé kasenúwe. ");
INSERT INTO awb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Sísaga wensabé, Íné íre epéráhpéria ahriahri peh ábóraq áhnte wehekéq míáhrabeq teri terinuge. Itene momiwío nahtápéqkákáq Manikánsabe iwíáh íwíáh atáh náhtápéqté wíráípéqkákáq síwáhnoruge. Íre epéráhpéria síwáhnoruge. ");
INSERT INTO awb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ínénsabe aneqsabé kasenaintaho? Néne ehweh teríú ké írátíáhwe. Seba kogaseninanao úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Úwana mibeqté iriwe mío anínká ayahpóra Sísa subiqmarena wensabé, Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnsabé mina tahnsa éhwéh atéhneho úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Úwana Sísaga wensabé, Íné ahbabáq ehweh teawénaraqmé tenio. Íre ahbabáq ehweh teawúge. Árahinsabé nubono úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Úwana Ánásaga Sísa íre pugeq auwasa Manikáne ehweh mibeq mahbeq arítáh kéné wahnah Káíyápásaba eqmaq auwowe. ");
INSERT INTO awb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pítaga iraraq ména pabesuq tehesurue totorúwara míó kega wensabé, Are moq we kérahna anípo uwana Pítaga sensabé, Ahqáho. We íre kéróge úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Manikáne ehweh mibeq mahbeq arítáh kéné wahnahne arambehri anínká Pítansabé, Sísareq arereq mátaburapeq míehyana tagéwó mino úwe. Mi ehwéh irarú animé we Pítaga ahre apiaro aní awahrah aníne. ");
INSERT INTO awb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tagéwó mino úwana Pítaga mónkakáq ahqáho úwana kokórega ehwehnúwe. ");
INSERT INTO awb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ahbiahiperura sega Sísa meqmera Káíyápásane nahtapeq suera anotah nahtápéq ehweh aruqaruro nahtápéq Sísa móátówe. Sótaikú tanahráq no tahutáhúq wéhékáh mi nahtápéq kiewé órira púara Asiu kegá íre kíúwe. ");
INSERT INTO awb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mibeqté wáhnáh ání áwíq Páhírátiga máhpeq tueyokéna sensabé, Itega méáúwáh ánímé aneq ahbabáriro úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Úwara sega wensabé, Mah aní íre ahbabáq ani tahirí túbáh agúna irino uwe. ");
INSERT INTO awb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Uwana Páhírátiga sensabé, Iteitega we meqmeq iteitene sánsánue iwíáhue ehweh atáhro úwe. Úwara sega wensabé, Wehukení subiq sueyabe ite Aroma kegá ahqáho aitárówe uwe. ");
INSERT INTO awb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Menah Sísaga, Sega íné pankeragéhe irarúmé amahnága aiq pútaq aginkeheéra mi ehwéh teawúwe. ");
INSERT INTO awb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Páhírátiga nahupeq kibekéna Sísa meqme seroue wensabé, Arewe Asiu kené wahnahpo úwana ");
INSERT INTO awb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sísaga wensabé, Arega irarénawe arerene iwíáhbo? Íné éhweh mó anínká teawiro úwana ");
INSERT INTO awb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Páhírátiga wensabé, Íné Asiu anínabugo? Arenawahrahreq itene wahnahmarínseqka are meqmera ínéba méáúwáhwe. Aneq ahbabárurono úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Úwana Sísaga wensabé, Íné wahnah wahnahnurabeqme íre mah marákó márákóípére. Mah marákó márákóípéq wahnahnutaq tahirímé Asiu kegá íné táhtoráhtáq íné séníráh kégá ebeho irino. Íné wahnah wahnahnurabeqme íre mah marákó márákóípére úwana ");
INSERT INTO awb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Páhírátiga Sísansabé, Are anotah Wahnáh ání míahno kasenúwana Sísaga wensabé, Arega aiq iraréne. Aiq pútaq ehwéhnsábé síwáhnorinieéna mah marákóípéq tuména wehukení úkurauge. Aiq pútaq ehwéhnsábé suwahbeh kegá néne ehweh íráhwe úwana ");
INSERT INTO awb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Páhírátiga wensabé, Aiq pútaq ehwéhmé aneqpomo úwe. Páhírátiga wensabé, Aiq pútaq ehwéhmé aneqpomo éna máhpeq tueyokéna Asiu keyábé, Íné iwíáhume we íre ahbabáq ani míre. ");
INSERT INTO awb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sótaikú iahreraq ko tanáhráq ahriahri peh morá karábúsiipéqté ání pugeq íúwóge. Mi sansá mira aruqaruruge. Minayabe Asiu ke itene Wahnah pugeqínínkono úwe. ");
INSERT INTO awb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Úwara sega anotah ehwéhnabaéra, Mi anímé pehragé Páréhba pugeqio uwe. Páréhbawe wehukení subena aebó ání míowe. ");
INSERT INTO awb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Páhírátiga sóntía keyábé, Sísa meqmeq áréti sahtáté subóro aritowara sega meqmera mósubúwe. ");
INSERT INTO awb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mósubera ógaratáté keborarera wene ayahqnotaq suki atera peh morá táútáúq kórósí abaq atówe. ");
INSERT INTO awb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mó anínká mó anínkáue Sísaba séra wensabé, Are Asiu kené wahnahpo éra awiréh atera siyahpóra subúwe. ");
INSERT INTO awb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Páhírátiga máhpeq mó tueyokéna soruparíó keyabé, Írátíáhro. Íné iwíáhume we íre ahbabáq anine. Minayabe tagariageheéna iteba máhpeq ataníe úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Úwana Sísaga ógaratáté keboria náneqkakáq tautáúq korósíákáq máhpeq tueyokúwe. Tueyokúwana Páhírátiga sensabé, Mah aní tagahro úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Manikáne ehweh mibeq mahbeq arítáh kéreq wahnah kereqka Sísa tagéra áhnte ehwéh kíkíréra, Awankátaq táhpawe subiq súáhro éra pagu pagunuwe. Pagu pagunuwana Páhírátiga sensabé, We íre ahbabáq anine íwíáhúnsabe iteitega meqmeq awankátaq táhpawe subiq súáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Úwara Asiu kegá wensabé mahraréra, Wega, Íné Manikáne ahninkáwá úge urainsabé itene sánsá sabiúéhre. Sabiúéhmé puko nanere uwe. ");
INSERT INTO awb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Uwana Páhírátiga mi ehwéh irena anotah ahré agúwe. ");
INSERT INTO awb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wega koti nahtápéq mó kibekéna Sísansabé, Arewe eheqte anípo úwana Sísaga ehweh íre iraria peh ehiya míowe. ");
INSERT INTO awb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Páhírátiga Sísansabé, Aneqsabé ehweh íre tenieno? Ínéga are soraq auwahráhuge. Ínéga are awankátaq táhparahráhuge. Mahnawé aiq irahno úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Úwana Sísaga wensabé, Peh morá Manikánka arega wahnahnúno atáráinsabé arega íné awankátaq táhparahráhóne. Minayabe areba móíntéh áníné ahbabáqka arene ahbabáq kiotaikire úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Páhírátiga mi ehwéh irena, Pugeq auwaníe íwíáhúwe. Iwíáhúwara Asiu kegá anotahtaq mahraréra, Arega we pugeq auwéhnaraqme are íre Sísáhri, Aroma kené wahnahne iyahnabo aní móne. Íné Asiu kené Wahnah muge iraréna anímé Sísáhrine naruo aní míre uwe. ");
INSERT INTO awb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Páhírátiga mi ehwéh irena Sísa máhpeq márunatena wahnah anínká ehweh atorabeq tútuue míowe. Mibeq áwíq Ebah Ahtápére. Íbaru ehwéhmé mitaq Kábátae ue áwíratówe. ");
INSERT INTO awb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ahbiah tahnsá ite Asiu kené sótaikú iahreraq ko tánáhráre. Ibora tahnsa wéhékáhnabubu wahtotarútaq Páhírátiga Asiu keyábé, Itene Wahnah tagahro úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Úwara sega ehwehnabaéra, We meqme mósubiq suo. Awankátaq táhpawe subiq suo pagu pagunuwe. Pagu pagunuwana Páhírátiga sensabé, Itene anotah Wahnáh awankátaq táhparáhro ininkono úwe. Úwara Manikáne ehweh mibeq mahbeq arítáh kégá wensabé, Aroma kené wahnahme webataq itene wahnahne uwe. ");
INSERT INTO awb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Uwana Sísa awankátaq táhparageheéna Páhírátiga móatowara sega Sísa meqmera pokuwe. ");
INSERT INTO awb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sega Sísa meqmera pokuwana Sísaga wewe táhparéhra awánká abaqmena kúwe. Kire kire sáwéh áwíq Ayahqno Tánúnsutapéq pokuwe. Íbaru ehwéhmé mi sawéh áwíq Kógótae ue áwíratówe. ");
INSERT INTO awb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Sega Sísa awankátaq níriraté wene ayahnkaratáq subiqmaq aigárátáq subiqmarue táhparera awanká pankeqme marakóipeq pearówe. Pearera mó aníté mó awánkátáréráq táhparera pankeqme pearówe. Sísa ákáhpi pearera mi aníté ayehré ayehré pearówe. ");
INSERT INTO awb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Páhírátiga, Kanehraq sehiranue táhparáh áwánkátáq táhparáhro aritowara táhparówe. Kanehraté séhíránká mahraréna, Néhsara suwahpeqte ání Sísawe Asiu kené Wahnahne úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mi kanéhráq sehirania apahtáró kéhínáné ehwehtaq sehiranéna Íbaru ehwéh Asiu kené ehwehnkakáq Aroma kené ehwehnkakáq Káríki kené ehwehnkakáq sehiranúwe. Sísa táhparótaq Sarúsarama suwahpeq wahtotaq puara áhnte Asiu kegá tagéra mi sehirá sáhnsáhúwe. ");
INSERT INTO awb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Asiu kené Manikáne ehweh mibeq mahbeq arítáh kégá Páhírátinsabé, Asiu kené wahnahne íre sehiranúno. Peh mi anínká, Íné Asiu kené Wahnah muge ire. Minawé sehiranúno uwe. ");
INSERT INTO awb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Uwana Páhírátiga sensabé, Íné sehiranéwó náneq aiq sehiranue parabarúóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sóntía kegá Sísa awankátaq táhparera wene korósi mewera itaréitaréráq saraqmarera meyówe. Wene káhq ambántá anehe mewera íre parura peh táránkaq kowe. ");
INSERT INTO awb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Peh táránkaq konsabe subansúéhneho íwíáhéra, Insega meyanabomo éra káhsiuwana peh morá ánínká meyowe. Miraunsabé Manikáne ehwehme aiq pútaragúwe. Mi ehwéhnká mahraréna, Sega néne korósi saraqmera káhq ambántá káhsiue meagehe ire. ");
INSERT INTO awb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kárópane ahre áwíq Máhríae. Mágára suwahpeqte mó iní wenáwíq moq Máhríae. Sereq Sísane anowareq wene ónánahwáreq awankátaq táhparórabeq wahtotaq kowíówe. ");
INSERT INTO awb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kowíówana Sísaga íné, we kéráhwa anínsábé arutaboiraintéh ánínseq wenanoreq míahwayana wega ite tagéna wenanonsabe, Areba míéh ání arenahni míankehe éna ");
INSERT INTO awb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","wega ínénsabe, Náinowé arenano míankehe úwe. Teniunsabe wenanoga néne nahtapeq kaegaeúwana kirabo atáhwae. ");
INSERT INTO awb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sísaga iwíáhéna, Néne arambehri aiq moke parabagire éna Manikáne ehwehnka aiq pútaraginkeheéna wega, Íné tahbobóire úwe. ");
INSERT INTO awb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kítabeh nahníáq sérá ano obenkisa ántéhyá mitaq kowara sehenáh tahnsa náneqtaté antehyapípéq pámbáhue sehikaratáq marera wene áwéhipeq atówe. ");
INSERT INTO awb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Atówana Sísaga néna, Aiq parabagire úwe. Aiq parabagire éna wene anuo píntéráhéna wenawa soraq suena putiowe. ");
INSERT INTO awb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ahbiah tahnsá ite Asiu kené ahrena ahrena wehekáhne. Mi tanáhráq itene sótaikú iahreraq kéh tánáhráq púara Asiu wahnáh kégá iwíáhéra, Putianeherao kené sinonka ahrena ahrena wehekáh awankátaq kehneho uwe. Minayabe sega Páhírátiba pokéra wensabé, Putianeherao ke apubúue pukigeheé siwiah anteruo úno. Putíéhrataq awanká soriwe mewe maisaragéhe uwe. ");
INSERT INTO awb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sóntía kegá pokue Sísareq awankátaq táhparó aníténé siwiah anterúówe. ");
INSERT INTO awb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sega Sísaba séra tagowana aiq putio púara sega wene awiah íre anterúówe. ");
INSERT INTO awb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Peh morá sóntíá ánínká wene sehsabe karatáté Sísane aroganabí sehsabiowe. Sehsabiotaq korahqkakáq wánínkakaq súwe. ");
INSERT INTO awb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nénéne niuranka tagahwae. Íné aiq pútariahnsanuge. Itega aiq pútare atageheéna teiúge. ");
INSERT INTO awb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Manikáne ehwehnka mahraréna, Wene ayahnsa íre anterigéhe ire. ");
INSERT INTO awb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Manikáne ehwehnka mó mahraréna, Sehsabearáh ání tagagehe ire. Miraue mi ehwéhtáré aiq pútaragúwe. ");
INSERT INTO awb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Árímátéa suwahpeqte ání Sósépaga Sísansabé aiq pútare atena Asiu keyábé áhreú púana Sísa oga míotaqme we íre ábóraq kérowe. Sósépaga Páhírátinsabé, Sísane anonka mewena mómaisaranínkono úwana Páhírátiga wensabé kowe atowana máhpeq tueyokue Níkórímareqka tumeyóye. ");
INSERT INTO awb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Níkórímawe menah tahnsa Sísaba inokáhpeq sena niginka tahnsa kaweq kunkúni naneqmarí áhnte 30 kíro mewena súwe. ");
INSERT INTO awb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sósépareq Níkórímareqka Sísane anonka mewera kaweq kunkúni naneqmarínkákáq wene anonkankakáq kaweq íre wahto ambántátáté úbíq máróye. Mi sansámé Asiu kené wehukení maisare sansane. ");
INSERT INTO awb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sísa táhparówana maisaró matábú wahto kowe. Mi matábúráq o ubuqmaró oná kowe. Mipéq mó aní íre maisarówe. ");
INSERT INTO awb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ahbiah tahnsá Asiu kené ahrena ahrena wehekáh púara mó oná kabareyabe íre miraorahuye. Minayabe mi oná wahto ko púara sega Sísa mitaq maisaróye. ");
INSERT INTO awb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mó wikíné ebeqte wéhékáh tanahráq tuekinaútaq Máhría, Mágára suwahpeqte ínínká Sísa maisarórabeq súwe. Méhpehtaq paiqmáró ebáh íre paisa peh móbeq kowana tagówe. ");
INSERT INTO awb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tagéna we Sáímóni Pítareq íné, Sísaga arutaboiraintéh ánínseqpa pehbeheráh séna itensabé, Itene Wahnahne anonka ónapipéqté mewera eheqpopoq máráhwe úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Úwata Pítareq ínéreqka Sísa maisaróyarabeq koragayeheéta pehbeheráh pokowaye. ");
INSERT INTO awb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pehbeheráh ínéga Píta kótaikue Sísa maisaróyarabeq ebeq kowae. ");
INSERT INTO awb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mitaq ebeq kéna taebewe maisia ónápípéq tagahwana Sísane anonka úbíqme maisaróya ambántá mitaq kowana tagahwae. Íné mibeq íre tueagia peh taebewe tagahwae. ");
INSERT INTO awb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Peh tagahwana Sáímóni Pítaga mitaq séna maisaróyarabeq kobekue tagówe. Taberábe maisaróya ambántá mitaq kowana tagówe. ");
INSERT INTO awb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sísane ayahqno úbíq máróya ambántá mobeq kowe. Ayahqno úbíq máróya ambántámé maisia ámbántá korabeq íre kowe. Peh sabaráwe móbeq kowana tagówe. ");
INSERT INTO awb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tagówana íné maisaróyarabeq ebeq kowa anínká moq kobekue tagahwae. Tagéna, Sísa aiq irigire éna aiq pútare atáhwae. ");
INSERT INTO awb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Manikáne ehwehme, We pukéna iriginkehe séhírá kowata mi tanáhráq mah sehirá íre iahtebahwaye. ");
INSERT INTO awb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tagéta ite kaegaeowayarabeq kouwekowaye. ");
INSERT INTO awb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kouwekowayana Máhríaga maisaróyarabeq mó séna máhpeq iriwe ména ibisówe. Ibiséna wega maisia ónápípéq taebewe tagówe. ");
INSERT INTO awb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Íre wahto taberábe ambántánkákáq áníté íópeqté áníté Sísane anonka kéworabeq tútuue míóyana Máhríaga tagówe. Mó aní Sísane ayahqno kéworabeq mó aní wene aigárá kéworaberue tútuue míóyana tagówe. ");
INSERT INTO awb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tagówara sega mi inínsábé, Aneqsabé ibisahno uye. Uyana wega sensabé, Néne Wahnah ínéga íre tagaríórabeq mórúáhnsábé ibisoge éna ");
INSERT INTO awb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","wega pabeqme tagówana Sísa iriwe míowe. Míowana mi iníné arupipeq Sísa wire ue íre iwíáhue tagówe. ");
INSERT INTO awb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Íre iwíáhue tagówana Sísaga wensabé, Are aneqsabé ibisahno? Insensabe anebahrono úwana mi inínká iwíáhéna, Kaseni aní we mah matábúráq wahnahni aníne íwíáhéna wensabé, Wene anonka mearáhnawe eheq marahno? Koweaníboq tenio úwana ");
INSERT INTO awb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sísaga wensabé, Máhríao úwana mi inínká weba pabeqme tagéna Asiu kené ehwehtaq, Árábónáio úwe. Mi ehwéh áwahewé Íwáhnoraníno úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Úwana Sísaga wensabé, Nániboba íre pokurio puah ninonkataq táhtoréhnehboq néne iyahnabo korerio. Maniká Nániboba tuekinauge. Mí ehwéh korerio úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Úwana Máhría, Mágára suwahpeqte ínínká ite Sísa kérahwána kebá séna itensabé, Ínéga Sísa aiq tagoge éna Sísaga teawu ehwéh teiuwe. ");
INSERT INTO awb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Penorabeqte mó wikíné ebeqte wéhékáh tanahráq ite Sísa kérahwána kegá soruparawéq Asiu keyábé áhreowana puaq itene nahupeqte ónsá paiqmareq míahwane. Míahwanana Sísaga ákáhpi seiriwe ména itensabé, Pehwehrue iru ukiqme míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iru ukiqme míáhro éna wene ayahnkarankákáq wene aroganabínkákáq sokigi aiuwaq itega we tagéq itene irupipeq anotah eyóyóúwe. ");
INSERT INTO awb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sísaga mónkakáq itensabé, Pehwehrue iru ukiqme míáhro. Nániboga eqmaq núwátáinserah ínéga moq ite eqmaq íúwóge úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eqmaq íúwóge éna wene euq ahusaiena, Manikáne Awa íúge úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Manikáne Awa íúge éna wehukeníné ahbabáq soraq súéhrataq íre kagainae. Wehukeníné ahbabáq íre soraq súéhrataq sene ahbabáq seba kagainae úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sísaga iteba sú tanahráq peh morá we kéro aní, Tómáhsiga íre míowe. Tómáhsine wéhuwehu áwíq Tírímásie. ");
INSERT INTO awb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sísa mó kérahwána kegá Tómáhsinsabé, Itene Wahnah oga míéhraq tagóne teawewáne. Teawewánana Tómáhsiga itensabé, Pehipi íre aiq pútare aitaníe. Sísane ayahnawarutaq níri subisa ábí tagéna niyahnkaratáté wene aroganabí sehsaberapí táhtoráhnaraqmé aiq pútare aitaníe úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Abapete téhtaré wéhékáh sótaikúwaq Tómáhsireq ite Sísa kérahwána kereq nahupeq míahwane. Onsawárí áróki pareq míahwanana Sísaga ákáhpi seiriwe ména itensabé, Pehwehrue iru ukiqme míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iru ukiqme míáhro éna Tómáhsinsabé, Néne niyahnkara sosanue tagáhno. Ayahnkahkahrue néne niroganabí táhtoro. Íre aiq pútare aintéhnehboq aiq pútare ainto úwana ");
INSERT INTO awb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tómáhsiga Sísansabé, Néne Wahnah mone. Néne Maniká móne atowe. ");
INSERT INTO awb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Atowana Sísaga wensabé, Arega íné tagáhnayabé aiq pútare aintahno? Sene siuratate íné íre tagéra pehipi ínénsabe aiq pútare aintáh kégá iwíáh íwíáhigehe úwe. ");
INSERT INTO awb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mah pukúípéqté séhírá moke Sísane ótaq sansánsábé íre teiúge. Wega áhnte mó miraúwaq ite we kérahwána kegá tagahwane. ");
INSERT INTO awb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sísawe ite meirena kaweraitankeheéna Manikánka omaq ato aninéna we Manikáne ahninkáwá wíre. Minayabe aiq pútare atageheéna mah ehwéh sehiranue teiúge. Sísansabé aiq pútare atéhrataqmé wenáwírue oga mía míaigehe. ");
INSERT INTO awb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Peh morá káwéhúnsábé téhtaré áwíq kéhre. Kehrari kawéhúne. Mó awíqmé Táíbéría kawéhúne. Mó tanahráq mi kawéhú ayehráq Sísaga ite we kérahwána kebá ábórarúwe. Wega mahraue ábórarúwe. ");
INSERT INTO awb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ite abapete téhraníté kérahwána ke sesorupawe míahwane. Tómáhsiwe wene wéhuwehu awíq Tírímásie. Wereh Sáímóni Pítareh Kéána suwahpeq Kehrari marákórápéqté ání Nátáníérireh ite Sébérine ahninkáwáráréreq téhraníté mó keróya anítéreq sesorupawe míahwane. ");
INSERT INTO awb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sáímóni Pítaga itensabé, Íné pah sábátáhrinauge úwaq itega wensabé, Ite moq are kéranéhe ewane. Itega sípi kéweweq pokue moke penkútaq uwe taga tagaowane. Pah íre maqmera pehipi uwe taga tagaowane. ");
INSERT INTO awb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ahbiahipeq Sísaga káwehu áhnopeq súwaq itega we íre tagariahwane. ");
INSERT INTO awb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sísaga itensabé, Nanuwahraho, pahmé aiq maqmiaho úwaq, Írakaumo ewane. ");
INSERT INTO awb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ewanana Sísaga itensabé, Sípiipéqté éberiopéq uwe tagéq meyagéhe úwaq itega itene kahwe éberiopéq uwe tagéq áhnte pah meyahwáne. Áhnte pah meyahwánayabé kahwe íre pankerahráhowane. ");
INSERT INTO awb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Íné, Sísaga arutaboiraintéh ánínká Pítansabé, Áhnopeq míéh ání itene Wahnahne teawéwae. Sáímóni Pítaga pehrákora ména arambehriúnsabe, Ítene Wahnahne teawéwana apubúue wene ambanta úbíq mena káwehupípéq ahkuagúwe. ");
INSERT INTO awb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pah kahweipéq kowaq mó ite Sísa kérahwána kegá kahwe sabirue meweq sípi kéweweq áhnopeq pokowane. Áhnopeq wahtotaq ko púaq itega kahwe sabirue meweq pokowane. ");
INSERT INTO awb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ite áhnopeq kowanaraq ira paríówana taigowaq tagahwane. Tairáq pahnkákáq párétiakáq kowe. ");
INSERT INTO awb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sísaga itensabé, Ite matíáh páh táhmaro mewe sero úwana ");
INSERT INTO awb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sáímóni Pítaga sípiipéq kire pahnkákáq káhwé sabirue áhnopeq méarowe. Kahweipéq anotah pahmárí íregáritaq 153 pahmárí míówana kahwe íre surakúwe. ");
INSERT INTO awb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sísaga itensabé, Sewe nahro úwe. Itene Wahnah tagariahwanayabé itega, Are inseboue íre kasenowane. ");
INSERT INTO awb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sísaga párétiakáq pahnkákáq mewena ménáiuwe. ");
INSERT INTO awb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sísa oganúq atowana wega ite we kérahwána kebá apahtáróráq ábórarúwe. Teiúmé apahtáró tánáhráre. ");
INSERT INTO awb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Táhutahuq nahwanana parabagútaq Sísaga Sáímóni Pítansabé kasenéna, Sáímóni, Sónine ahninkáwáo, Arega mah keyábé ákáhtaq arutaboirarite ínénsabe anotah arútábóíraintahno úwe. Úwana Pítaga wensabé, Kowe. Are tagariahnawe arensabé nirutaboiruge úwana Sísaga wensabé, Néne sipisípiq áráhqmari kirabo ainto úwe. ");
INSERT INTO awb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sísaga we mó kasenéna, Sáímóni, Sónine ahninkáwáo, ínénsabe arutaboiraintahno úwana Pítaga wensabé, Kowe. Are tagariahnawe arensabé nirutaboiruge úwana Sísaga wensabé, Néne sipisípiqmarímé wahnahnainto úwe. ");
INSERT INTO awb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sísaga anehe mó kasenéna, Sáímóni, Sónine ahninkáwáo, ínénsabe arutaboiraintahno úwe. Apahtáróráq kasenú púana Pítane arupipeq umeh agúwana Pítaga wensabé, Néne Wahnahno, arega moke tagariahne. Are tagariahnawe ínéga arensabé nirutaboiruge úwana Sísaga wensabé, Néne sipisípiq kirabo ainto. ");
INSERT INTO awb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kawerue írátíahno. Are mahbi míaronaraq arene áréti sabirare arega awahbarairabeq pokurone. Are ore úkínaraq arene ayahnkara pankeréhnaraq mó kegá ahmboqme meqmera are íre awahbáhnarabeq móatagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Mah ehwéhmé Sísaga Píta pukína ehwéh teawuwe. We pukína tanáhráq Píta íre áhreínayabé tagehra kegá Maniká áwíq pankeragéhe. Mah ehwéh teawena Sísaga Pítansabé, Séniro úwe. ");
INSERT INTO awb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pítaga pabeqme íné, Sísaga arutaboirainto aní tagówe. Sísa pukinaúwara táhutahurowanaraq ínéga Sísane anepeq mósaqmaqme ména wensabé, Néne Wahnahno, arene naruo kowerirahna anímé insebo kasenowae. ");
INSERT INTO awb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pítaga íné tagéna Sísansabé, Néne wahnahno, mah aní anerinkehbo úwana ");
INSERT INTO awb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sísaga wensabé, Íné nuwahbéhnaraqmé kiwekona tanáhráq we peh oga míanawire íwíáhinabugamo. Arereq wehgaqpo? Arerega séniro únsabe ");
INSERT INTO awb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","mi ehwéh író kega mó Sísa kéró keyabé, Íné Sóni íre pukinkehe mitaq teri mahtaq terinuwe. Sísaga Pítansabé, Íné Sóni peh mía míankehe íre irarúwe. Wega Pítansabé peh miraue teawena, Íné kiwekonaraq we peh oga míanae íwíáhinabugamo. Arereq wehgaqpo úwe. ");
INSERT INTO awb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Íné Sísa kéráhwa anínká mah ehwéh iraruge. Mah ehwéh aiq pútaq ehwéh púana sehiranue teiúge. ");
INSERT INTO awb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sísaga íre peh morá teiú árámbéhrí mirauwe. Wega áhnte mó arámbéhríúwe. Wehukega wene ehwehnkakáq wene arambehriakáq moke sáhnsahwe sehiranutaq tahirímé púkuwarínká mah marákó márákó kígí agirana marakó íre awehraq kéh irino. ");
INSERT INTO awb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tíópírásao, néne sehiramé kawerue sáhnsahwe iro. Menah tanáhráq mó pahsí sehiranue áwátáuge. Mi pahsíípéq moke Sísaga miraúnsabe sehiranue teawena wega íwáhnorúnsabeakáq teawátáuge. ");
INSERT INTO awb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Wene arambehri áhwárótaqkakáq íópeq kiu tanáhráqsábéákáq teawátáuge. Wega marakóipeq míotaq wehuke eqmaq suanieéna omaq sitowe. Manikáne Awanka Sísa iwíáh atowana wega íópeq kinaútaq omaq sito ke síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Téhwe Sísa awankátaq táhpague pukéna anehe oga úkéna mó wehekáh mó wehekáhnue omaq sito keba séyééna wewe sokigi aritowara tagowe. Tagowana 40 wehekáh miraéna Manikánka wahnah wahnahnirabeqte éhwéh teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mi tanáhráq sega momiwíuríótaq Sísaga mahraréna, Sarúsarama suwahpeq apubúue sueq pokiyehboq Nániboga eqmarahna aní tuinayabé wensabé áwénunoro. Menah Nániboga eqmarahna aní éhweh teíyátáuge. ");
INSERT INTO awb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Naho Sóniga wání meriuwana Manikáne Awanka áhníbórá tunse iteba mía míainkehe úwe. ");
INSERT INTO awb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mó tanáhráq eqmaro kega momiwíuríótaq sega Sísansabé kasenéra, Ísara ke iteitene marakóraq amahnága wahnahnoro aitaníbo uwe. ");
INSERT INTO awb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Uwana Sísaga sensabé, Nániboga moke mi tanáhráqkákáq wéhékáhnkakaq wahnahnire. Minawé íre iteitene arambehri puaq itega mi tanáhráqkákáq wéhékáhnkakaq íre tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Minawé íre tagarawéq mahraue tagariagehe. Manikáne Awanka iteba tuinaraq ite págege aitahnaq itega íné éhweh mah kehiná kéhíná korerigéhe. Sarúsarama suwahpeqte kéreq moke mó Súría marákórápéqté kéreq Sámáría marákórápéqté kéreq moke mah kehiná kéhíná korerigéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mah kehiná kéhíná korerigéhe úwana eqmaro kega tagotaq Sísa tumerowana íópeq kire írábúyápipeq kibekúwe. ");
INSERT INTO awb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kibekúwara sega íópeq awahnkanue tagaríówara taberábe korósíákáq ánítégá iriwe míóye. ");
INSERT INTO awb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Iriwe méra sensabé, Kehrari marákórápéqté kéo, aneqsabé iriwe méq íópeq ebitiaho? Sísaga ite iuwena íópeq pokiraq tagahwe. We amahnága pokinserah mókake tuinawire uye. ");
INSERT INTO awb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Uyara eqmaro kega Óríwi sawéhrápéqté tunse Sarúsarama suwahpeq wahtotaq tueaguwe. ");
INSERT INTO awb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tueagéra sega kaegaeu nah abobóráhpeq kíúwe. Sensíwíqmarimé mahraue Píta, Sóni, Sémísi, Ehntaru, Pírípi, Tómáhsi, Pátórómíyu, Mátíyu, Ápíásane ahninkáwá wenáwíq Sémísi, ebeh ehwéh iriaréh ání wenáwíq Sáímóni, mó Sémísine ani wenáwíq Súrása mirauega kíúwe. ");
INSERT INTO awb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sereq Sísane ábákawaréhreq wenanoreq mó inínsónseqka sirupipeq peh morá íwíáhue moráráq púreq aruqaruruwe. ");
INSERT INTO awb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mó wehekáh sega mirautaq 120 ke áhnte Sísa tagaríáh kégá momiwíuríówe. Pítaga iriwe ména mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nánuwahraho, naho Manikáne Awanka Tébíti iwíáh atowana Súrása éhweh sehiranúwe. Súrásaga Sísane naruo kowerironsabe mi sehirá aiq pútaraguraire. ");
INSERT INTO awb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sísaga Súrása omaq atowaq Súrásareq itereqka moráráq arambehriuraune úwe. ");
INSERT INTO awb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Súrásaga Sísane naruo kowerironsabe móne meyowara mi monéráté marakó paiqmárówe. Súrásaga sáwéhrapeqté ayahqno maraipérue surahúwana wene ayahba tapoagúwe. Wene ayahba tapoague wene ayamárí pehrápeq sahagúwe. ");
INSERT INTO awb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wega miraúnsabe moke Sarúsarama suwahpeqte kégá irera mi marákóyábé áwírume sene ehweh Ákérámae atówe. Mi awíqmé Korahq Marakóe atówe. ");
INSERT INTO awb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pítaga Súrása éhweh mó mahraréna, Buk Songipeqté éhwéhnká aiq mahraréna, Wene mátabu susa matábú kanae. Mó kegá mitaq íre míáhro arito ire. Mi ehwéhnká mó mahraréna, Mó anínká wene arambehri awaq miankéhe ire. ");
INSERT INTO awb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Sóniga Sísa wání meawátáitaq táhmaro kegá Sísa kétówe. Sega kékérue Sísaga oga úkuraitaqkákáq íópeq kiraitaqkákáq tagarowe. Mó ke Sísa éhweh terigeheéq mina tahnsa Sísa kékéri aní iwíáhue omaq atanéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pítaga mi ehwéh teriuwara sega téhraníté omaq sitówe. Mó aní wenáwíq Máhtíásae. Mó aní wenáwíq Sósépae. Sósépawe we mó awíq Pásábae. We mó awíq Sásátae. ");
INSERT INTO awb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Sega mahrarue púreréra, Itene Wahnahno, arega ómi kehináné sirupipeqté íwíáhwé aiq tagariahne. Arega eqmatona arámbéhrí Súrásaga aiq suena ahbabárorabeq pokuraire. Wene arambehri mirainkeheé arega omaq atahna aní sokigi aio éra púreruwe. ");
INSERT INTO awb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Manikánka omaq ato aní taganeheéra sega káriq ebáh tuparuqme tagéra Máhtíásawe Súrásane arambehri mirainkehe atówara we Sísa kéró ke, airápété morá kéreq arambehriúno átówe. ");
INSERT INTO awb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Asiu kené siahreraq ko tanahráq áwíq Péntíkósie. Ebeqte wehekáh sutaq Sísa tagaríáh kégá moke peh morábí sáhuríówe. ");
INSERT INTO awb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sáhuríówana íópeqté éhwéhnká anotah soíríqká uu inserahnúwara ómi nahupeq tútuue míó kega apubúue írówana ");
INSERT INTO awb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","anehbí irobina tahnsá náneqmarí ábóraragúwara tagowe. Tagowara irobina abae ague mó anípá mó anípánue abae agúwe. ");
INSERT INTO awb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Manikáne Awanka sirupipeq tuména iwíáh arito púara sega mó kehináné kambare ehweh iraruwe. ");
INSERT INTO awb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mi tanáhráq áhnte Asiu ke mó kehiná mó kehiná suwahpeqte Sarúsarama suwahpeq sewíówe. Mi ke Manikánsabe iwíáh íwíáh atáh ké wóe. ");
INSERT INTO awb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sega mi ehwéh irera sega morábí sáhurawéra írówarawe Sísa tagaríáh kégá mó kehiná mó kehináné ehweh iraruwe. ");
INSERT INTO awb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iraruwara seyene ehweh irarunsabé író kega áhtenéra, Árahue irareo éra iwíáhue tagowe. Sega áhtenéra mahraréra, Iteitene ehweh irare kewé se peh morá Kehrari marákórápéqté ké wóe. ");
INSERT INTO awb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sega iteitene ehwehmarí irarewaq irone. Sega itene ehweh árahue irareo? ");
INSERT INTO awb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ite Pátía kewé Míría kewé Érámi kewé Mésópótémía marákórápéqté kéwé Súría marákórápéqté kéwé Kápárósía marákórápéqté kéwé Póntúsa marákórápéqté kéwé Esia marákórápéqté kéwé itene ehweh irarewaq irone. ");
INSERT INTO awb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Párígía marákórápéqté kéwé Pámbíría marákórápéqté kéwé Ísípi marákórápéqté kéwé Áríbía marákórápéqté kéwé Sáíríni suwahpeq wahtotaq mi kewé Aroma suwahpeqte náhnsó kéwé itene ehweh irarewaq irone. ");
INSERT INTO awb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mi kewé Aroma suwahpeqte náhnsó kéwé táhmaro Asiu keúrá míáhwe. Mó mitaqté ké Asiu kené sánsá mero ke míáhwe. Kíríti marákórápéqté kéwé Árébía marákórápéqté kéwé moke mi kegá itene ehweh irarewaq irone. Manikánka págege arámbéhríinsabé sega irarewaq irone. Moke iteruwahrahga irarewanserah itene ehwehmarí irarewaq irone uwe. ");
INSERT INTO awb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sega áhtenéra sene sirupipeq iwíáh kikiréra, Itene ehwehmarí árahue irarewapómo? Aneq sansápómo uwara ");
INSERT INTO awb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","mó kegá siwiréh aritera, Sega peh píah nah puara múguwahgu ehwéh irarewe uwe. ");
INSERT INTO awb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Uwara Pítareq airápété moráue eqmaro kereqka iriwe míówe. Pítaga mipi sáhuríó keyabé anotahtaq teriena, Sarúsarama suwahpeq kaegaeo kereq moke mó Asiu kerero, ehweh teiníboq írátíáhro. ");
INSERT INTO awb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abehq wání nah puara múguwahgu ehwéh irarewe eme írakaumo. Amahnága pópoqnah peh ákáhtaq kéhrana íre píah né tanahráre. ");
INSERT INTO awb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mó kené ehweh irarensabé Manikáne ehweh irarú ani, Sóériga mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Manikánka iraréna, Anehe tanahráq Néniwa mah kehiná kéhínápá eqmaq auwaníe. Néniwanka néne ehweh iwíáh aritahnara itenahnimáhqsonseq iteriyahumáhqsonseqka ehwéh irarigehe. Itene mahbigauné siwanka tagagehe. Orerónká áónáh tagagehe. ");
INSERT INTO awb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mi tanáhráq néne arambehri mirao weh áhrébá néniwa eqmaq auwaníe. Néniwanka néne ehweh iwíáh aritahnara ehweh irarigehe. ");
INSERT INTO awb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Íópeqté íre tagaríáh náneq sokigi ainíe. Marakóipeqté moq págege sansá sokigi ainíe. Korahqkakáq iraakáq áúnínaakáq tagagehe. ");
INSERT INTO awb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pópoqnah sunkíkíraginae. Íótaq korahq tahnsa tautáúraginae. Miraínagake anotah Wahnáh ánínka págegeue wahnahnína tanáhráq áhníbóránire. ");
INSERT INTO awb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Are néne Wahnah míahno ue níáhrabira kewé kaweraritanauge ire úwe. ");
INSERT INTO awb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pítaga mó mahraréna, Ísara keo, mó ehwéh kawerue írátíáhro. Sísa Néhsara suwahpeqte ání éhweh teiúge. Wega Manikáne arambehri mirainkeheéna Manikánka Sísa omaq atowe. Minayabe tagariageheéna Manikánka págege atáráire. Págege atáráirana wega íre tagaríáh náneqkakáq págege arámbéhríákáq sokigi aitáráire. Itene iuranka tagahnsabé aiq ahtebahwe. ");
INSERT INTO awb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Naho Manikánka iwíáhue tagarionserah menah itega Sísa táhtoqme ahbabáq ke móríátówara sega awankátaq táhpatowana putiaraire. ");
INSERT INTO awb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sísa íre airaiq pusa ání míahrahurai puana Manikánka érorahirabeqte iriatena oganúq atáráire. ");
INSERT INTO awb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Naho naho Tébíti, Sísane aigaqnaga íre wewensabé irarena peh Sísansabé teiena, Néne Wahnahnka ínéreq mía míaime tagaríóge. We néne niyah púpeq mía míai puana íre áhreúge. ");
INSERT INTO awb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Minayabe nirupipeq eyoyóire. Néne níwéhrate iwíáh íwíáh atóge. Íné pukonaraq arega oganúq intaniewóne íwíáhuge. ");
INSERT INTO awb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Íné pukonarabeq arega néniwa íre nuwankéhe. Peh oganúq intankéhe. Arene kaweq aníné ninonka íre karekinawire. ");
INSERT INTO awb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Arega oga mía mía ahtápéq sokigi aníátóne. Arereq mía míaúya puana nirupipeq eyoyóinawire úwe. Mi ehwéhmé Tébítiga teiuwe. ");
INSERT INTO awb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pítaga mó mahraréna, Nánuwahraho, itene igaqna Tébíti éhweh pahsuqme teiníe. We naho putiowara maisarówana wene kárékú anónká amahnága maisia máíq mahtaq kéhre. Minayabe íre wewensabé iraréna peh Sísansabé irarúwe. ");
INSERT INTO awb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tébítiwe Manikáne ehweh irarú ani ména Manikánka mirainauge ú ehweh írátíowe. Manikánka naho Tébíti teawena, Amahnága arega wahnahnónanserah mókake arenanahga wahnahninkehe. Peh aiq pútariahnsanuge únsabe ");
INSERT INTO awb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Manikánka mirainaú arámbéhríyábé Tébítiga ahtebówe. Ahtebéna we aiq tagariomé Manikánka ite meirena kaweraitankeheéna omaq ato aní oganúq atanawire. We pukirabeq íre auwanawire. Wene anonka íre karekinawire. Peh oganúq atanawire tagariowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pítaga mó mahraréna, Manikánka Sísa iriatena oganúq atowaq ite moke tagarawéq teiune. ");
INSERT INTO awb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Manikánka Sísa wene ayah púpeq atowana anotah Wahnáh ání míaraire. Míarairana Manikánka teawátáinserah Wenawa Sísaba eqmatairana Sísaga Manikáne Awa iteba eqmaréhre. Minayabe itega amahnága aiq tagaríáhwe. Itega íráh éhwéhmé Manikáne Awanka iwíáh aitéh éhwéhne. ");
INSERT INTO awb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tébíti pukútaq wene anonka íópeq íre kiuwe. Minayabe íre wewene anonkansabé peh Sísa íópeq kiunsabe irarúwe. Wega mahraréna, Itene anotah Wahnáhnká néne Wahnahnsabé, Niyah púpeq kiwíahno. ");
INSERT INTO awb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mókake arene naruoakáq wahnahnarito ataníe irarire úwe. ");
INSERT INTO awb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pítaga mó mahraréna, Ísara keo, ite ómi kawerue iragéhboq írátíáhro. Itega Sísa awankátaq táhpareq subiq sutowe. Manikánka mi anínsábé, Are ínéga omaq ató ání móne. Anotah Wahnáh ání míahno atáráuge úwe. ");
INSERT INTO awb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Morábí kiranéhnuríó kega írówana mi ehwéhnká sirupipeq pówe. Sirupipeq pówara sega Pítareq mó eqmaro kereqsabé kasenéra, Iteruwahraho, aneq miraonehnkono ");
INSERT INTO awb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","úwana Pítaga sensabé, Itene ahbabáq kaqiuwankéhboq itene ahbabáq sansa sueq Sísansabé áhraboro. Sísansabé áhrabéq wání meyáhro. Mirairataq Manikánka itene ahbabáq kaweraitena Wenawa iteba eqmarankéhe. ");
INSERT INTO awb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Itereq itene animárínseq íre wahtopeqte kéreq ómi mirairataq Wenawa iteba eqmarankéhe. Maniká itene Wahnahnka ómi omaq sito kega mirairataq Manikánka Wenawa iteba eqmarankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pítaga mi keyábé áhnte mó págege ehwéh pahsuqme teriena, Manikánka kaweraitankéhboq mó kegá ahbabárorabeq sueq kaweqtaq míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Áhnte író kega wene ehwehnsabé aiq pútare atówara wání meríúwe. Wání meríúwara mi wehekáh sega Pítarehba kobaritawe míówe. Peh íregáritaq wehekéq 3 táhúséni (3,000) wehekéqká kobaritawe míówe. ");
INSERT INTO awb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Seba méra Pítareq mó eqmaro kereqka síwáhnoru ehwéh irera peh morá íwíáhuwe. Peh morá íwíáhéra sene tópah mewe moráráq néra moráráq púreq aruqaruruwe. ");
INSERT INTO awb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Manikánka págege aritowara Pítarehga áhnte otáq sánsá mirauwe. Mirauwara moke tago kegá áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Moke Sísansabé aiq pútare ató kega moráráq méra sene ménsámehnsánsabe peh morá íwíáhuríówe. ");
INSERT INTO awb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Sega sene ménsámehnsátate méyó moné mewera Sísa tagaríáh tábónáh ké náríúwe. ");
INSERT INTO awb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mó wehekáh mó wehekáhnue sega Manikánsabe iwíáh íwíáh atáh náhtápéq séyéuwe. Séyééra pokue sene nahmarítápéq táhutahuq moráráq naruq narurowe. Sirupipeq eyoyóúwara táhutahuq moráráq naruq naruruwe. ");
INSERT INTO awb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Sega Manikánsabe iwíáh íwíáhuwara moke tago kegá iwíáhéra, Kaweq kee uwe. Mó wehekáh mó wehekáhnue áhnte mó kegá Sísansabé aiq pútare atówe. Aiq pútare atówana Manikánka se kaweraritowara Sísansabé aiq pútare ató ke áhnte aguwe. ");
INSERT INTO awb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tunsorerutaq Asiu kegá púreq aruqarurotaq Pítareq Sónireq Manikánsabe iwíáh íwíáh atáh náhtápéq seyeherauye. ");
INSERT INTO awb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mi nah méhpeh áwíq Kaweq Mehpéhne. Mitaq soriqnah ani tútuue míowe. Wenanoga maqmarotaq soriqnah ani maqmarowe. Mó wehekáh mó wehekáhnue wene iyahnabo anímárínká meqmera mi mehpéh móata móatauwe. Nahupeq kíra keyábé ineh inehinkeheéra meqmera móátówe. ");
INSERT INTO awb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wega Pítareq Sónireq nahupeq kibekoyehera uyataq tagéna, Náníétao úwe. ");
INSERT INTO awb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Náníétao úwana Pítaga we ebitáwéna wensabé, Ite tagáhno úwe. ");
INSERT INTO awb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Úwana wega se tagéna iwíáhéna, Aneqpopoq nánigéhe íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Iwíáhúwana Pítaga wensabé, Íné íre móneakáq ání múge. Mirainieu naneq teawiníe. Néhsara suwahpeqte ání Sísa Karáhé áwírue teawúge. Iriwe nogo atóge úwe. ");
INSERT INTO awb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Miraréna wene púpeqte áyáhnkárátáq táhtoqme iriatowe. Iriatowana wene aiaurankakaq aigáránkákáq apubúue págege agúwe. ");
INSERT INTO awb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Págege agúwana mi anínká suansúá keirigue nogena nahupeq kierirowe. Kierirena wega nogena ahkuagu ahkuaguéna Manikánsabe iwíáh íwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Manikánsabe iwíáh íwíáh atowara ómi nahupeq míó kega we tagéra, ");
INSERT INTO awb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","we Kaweq Mehpéhtáq tútuue ineh inehéwéh ání míre uwe. Wene aigárá kaweragúnsabe, Éhneh. Aiq kaweragire éra áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kaweragú aninká Pítareq Sónireq táhtorowara ómi tago kegá áhtenéra pehbeheráh seba suwe. Anotah wahnáh wenáwíq Sórómóni Asiu kené wahnah míotaq pearó owewéhpéhtápéq suwe. ");
INSERT INTO awb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Suwana Pítaga tagéna sensabé, Ísara keo, we kaweraginsabé aneqsabé áhtenoo? Itewe aneqsabé ebitiaho? Ite págege aníté méta kaweratehye íwíáho? Manikánka itensabé, Kaweq aníté wóye aitéhnsábé kaweratehye íwíáho? Írakaumo. Íre itegae. ");
INSERT INTO awb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Manikámé we Ébáráhmareh Áhísáhkireh Sékópareh itene igaqnaréhne Maniká ména wewega mah aní kaweratéhre. Áhnte kegá wene arambehri awahbeh ani Sísawe, Anotah aní míéhre atageheéna kaweratéhre. Sísa marakóipeq míaraitaq sega we subigeheéq itega táhtoqme naruo kebá meqmeq móátárówe. Wahnah aní wenáwíq Páhírátiga, Sísa íre ahbabáq ani púana pugeq auwaníe íwíáhurairaq itega ahqáho atárówe. ");
INSERT INTO awb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Manikánsabe arutaboiri anímé kaweqtaq mía míaurai anímé itega ahqáho atárówe. Peh mó ke subiq sutai aní pugeqio urowe. ");
INSERT INTO awb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Oganúq itahráhi aní subiq sutowe. Itega Sísa subiq sutowana Manikánka iriatáráire. Minayabe Sónireq ínéreqka itene iuranka tagéta teiuye. ");
INSERT INTO awb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sísansabé aiq pútare ateta wenáwírue áhrabúya puana wega mi aní kaweratéhre. We awaho ani míéhraq tagahwe. Sísansabé aiq pútare atoyanka mi aní kaweratéhraq tagahwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pítaga mó mahraréna, Nánuwahraho, itereq itene wahnahmarínseqka Sísa subiq sutotaq we Manikáne ahninkáwá míéhnsábé itega íre ahtebarowe. Íre ahtebéq pehipi subiq sutowe. Minayabe aiq tagaríóge. ");
INSERT INTO awb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Manikánka wene ehweh iraru ke iwíáh aritowara ómiga mahraréra, Manikánka omaq ato anínká pukina ínaraq anotah érinawire uwe. ");
INSERT INTO awb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Minayabe Manikánka itene ahbabáq kaqiuwankéhboq itene ahbabáq sansa sueq wensabé áhraboro. ");
INSERT INTO awb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mirairataq Manikánka itene irupipeq eyoyó aitankéhe. Sísa Karáhé itene Wahnah míankeheéna Manikánka omaq atowe. ");
INSERT INTO awb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Amahnága Sísa íópeq mía míaire. Manikánka wene ehweh iraru ke iwíáh aritowara naho mahraréra, Mókake Manikánka moke kawerinkehe uwe. Amahnága Sísa íópeq ména mi tanáhráqsábé áwénunire. ");
INSERT INTO awb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mósísiga itene igaqnansabe naho mahraréna, Maniká itene Wahnahnka wene ehweh irarinkeheéna itereq míonarabeqte ání eqmarankéhe. Ínéga mirauraunserah eqmarahna anínká mirainkehe. We sínaraq irarína ehwéh moke kawerue íráhro. ");
INSERT INTO awb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wega irarína ehwéh íre íréhra kewé pukigehe. Manikáne animárí míéhrarabeqte kaqsuahnaraq pukigehe úwe. ");
INSERT INTO awb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Manikáne ehweh irarú ani Sáhmúériga Sísa tutai tanáhráqsábé irarúwe. Moke we anehe su anímárí, Manikáne ehweh iraru anímárínseqka moq amahnága tánáhráq, Sísa tutai tanáhráqsábé iraruwe. ");
INSERT INTO awb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Manikáne ehweh iraru kewé itene igaqnaréh wóe. Íre peh morá itene igaqnaréhyabe iraruwe. Moke itensabéákáq iraruwe. Manikánka itene igaqna Ébáráhmansabé naho teawena, Arenahninká mah marákó márákóípéq mó kahnáh mó kahnáhnue kaweraritankéhe teawuwe éna ");
INSERT INTO awb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Manikánka wenahni wene arambehri awahbeh aní iriatena ebeq ite Asiu keba eqmataire. Itene ahbabáq kaqiuwankeheéna wenahni eqmataire úwe. ");
INSERT INTO awb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pítareq Sónireqka Manikánsabe iwíáh íwíáh atáh náhúpéq míó keyabé síwáhnoruye. Síwáhnoruyataq Manikáne ehweh mibeq mahbeq arítáh kéreq Manikánsabe iwíáh íwíáh atáh náhtápéqté wáhnáh párísíreq Sáyúsi kéreqka suwe. ");
INSERT INTO awb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pítararégá síwáhnoréra, Sísa oga úkurainsabé mókake pukira ke mó oga úkoneherawoe uyara mina su kegá írówe. Irera sene ehwehnsabé anotah abíáhnsánéra ");
INSERT INTO awb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pítararébá sure táhtoqme meriqmera karábúsiipéq mórítówe. Íó tupekútaq puara ahbiahipeq kotiigeheéra mórítówe. ");
INSERT INTO awb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mi wehékáh áhnte író kega Sísansabé aiq pútare atówe. Peh íregáritaq wéh 5 táhúséni (5,000) wehgá aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ahbiahipeq Asiu wahnáh kéreq Asiu kené aboawah wehreq Mósísine ehweh síwáhnoru kereq Sarúsarama suwahpeq sáhuríówe. ");
INSERT INTO awb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Sáhuríówana Manikáne ehweh mibeq mahbeq arítáh kéné wahnah wenáwíq Ánása míowe. Ánása wenawahrah sensíwíq Káíyápásareh Sónireh Árékásántareh mó wenáwáhráhreqka moráráq sáhuríówe. ");
INSERT INTO awb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mitaq sáhurawéra, Meriqme sero uwana Pítareq Sónireq meriqmera seba mórítówe. Mórítówara mipi sáhuríó kega kasenéra, Insega págege aitáráiraq mi soríqnáh ání kaweratáróyo? Inse áwírue kaweratáróyo uwe. ");
INSERT INTO awb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Uwana Manikáne Awanka Píta págege atena iwíáh atowana Pítaga sensabé, Wahnah kereq aboawah wehrero, Írátíáhro. ");
INSERT INTO awb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Soriqnah ani séhréh atáráuyansabé inse áwírue kaweratáróyo kasenoo? ");
INSERT INTO awb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Itereq moke Ísara kereq iragéhboq írátíáhro. Itega Sísa Karáhé Néhsara suwahpeqte ání awankátaq táhpatowana putiaraire. Putiarairana Manikánka iriwe oganúq atáráire. Sísa Karáhé págege aní míéh púana wénáwíq áhraburauyansabé soriqnah ani kaweratáráire. Kaweratáráirana ite míáhrabeq we amahnága awaho ani míéhre. ");
INSERT INTO awb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nah pearáh kégá wahq awanká tagéra, Iroke awankáne éra sutowana anehe mi wahq anotah kawéq wáhq úkire. Mina inserah itega Sísansabé ahqáho atárówana we anotah Wahnáh ání úkuraire. ");
INSERT INTO awb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Peh morá Sísaga webataq itene ahbabáq kaweraitahráhire. Peh morá Sísa áwírue ahrabo ke wega kaweraritankéhe. Mah marákó márákóípéqmé mó morá ánínká itene ahbabáq íre kaweraitahráhire úwe. ");
INSERT INTO awb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pítareq Sónireqka míó keyabé íre áhreia ehweh pahsúóyansabé wahnah kereq aboawah wehreqka író kega áhtenuwe. Áhtenéra iwíáhéra, Se íre sigaruuroya aníté peh wahba arámbéhríráté áníté wóye íwíáhuwe. Iwíáhéra, Sewe Sísa kétóya aníté wóye uwe. ");
INSERT INTO awb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wene aigárá kawerato aninká Pítararébá míowara tagéra mó ehwéh mi tanáhráq íre irarerahuwe. ");
INSERT INTO awb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Íre irarerahunsabe wahnah kereq aboawah wehreqka Pítararé kaunsíri kegá momiwíurabeqte máhpeq sitera sío síouwe. ");
INSERT INTO awb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Sío síoéra, Mi aníté aneraruanéhnkono? Sega ótaq sansá aiq pútaq mirauroyara moke Sarúsarama suwahpeqte kégá tagaríáhwe. Sega kaweratóya ehwéh itega íre epéq suahráhúne. ");
INSERT INTO awb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mi ehwéh abae agínehboq págegeue ehiya míáhtao aritanéhe. Mó ke Sísa áwírue síwáhnoriyeho ue terianéhe uwe. ");
INSERT INTO awb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Terianeheéra Pítararé síáhrabéra sensabé, Sísa áwírue mónkakáq síwáhnoréta teríyehboq túbáh agotao ue teríúwe. ");
INSERT INTO awb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Teríúwara Pítareq Sónireqka sensabé, Manikáne ehweh sueta itene ehweh íréhyataq Manikánka itensabé kaweróye aitankéhbo? Írakaumo. Minayabe iteitega iwíáhue tagahro. ");
INSERT INTO awb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Itega tagéta írátáuya ehwéh íre ehiya míahrahúye. Peh teri terinoyehetauye uye. ");
INSERT INTO awb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Soriqnah ani kaweratonsabe ómi kegá Manikánsabe iwíáh íwíáh atówe. Minayabe wahnah kegá iwíáhéra, Mó kegá itensabé sibiahnsa aitehboq Pítararé pehragaritanehe uwe. Sega Pítararéyábé, Subónehboq Sísane ehweh mónkakáq íre teríétao éra kaqsúówe. ");
INSERT INTO awb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kaweragú aní 40 opéq peh soriqnah ani míowe. ");
INSERT INTO awb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kaqsúówara Pítararégá sensuwahrahba pokuye. Pokéra Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnseq Asiu kené aboawah wehreqne ehweh teríúye. ");
INSERT INTO awb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Teríúyara irera Manikánsabe moráráq púreréra mahraréra, Itene anotah Wahnáhno, arega íópeqkákáq mah marákó márákóákáq sóreq wanínkákáq miraróne. Moke mahnana kéh náneqkakáq miraróne. ");
INSERT INTO awb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Arene arambehriú ani, itene igaqna Tébíti Arenawanka iwíáh atowana sehiranue mahraréna, Nahnso kewé aneqsabé anotah abíáhnsánoo? Aneqsabé ehweh pehipi moraenoo? ");
INSERT INTO awb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mah marákó márákóípéqté wáhnáhmárínseq anotah anímárínseq ebehoneheéra sokah sokahowe. Manikánseq wega wehuke merinkeheéna omaq ato anínseqsabé kotioneheéra morábí sáhuríáhwe úwe éra púreruwe. ");
INSERT INTO awb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sega mó púreréra, Tébítiga naho sehiranúmé amahnága iteruwahpeq Sísa suboneheéra sorupariarowe. Kaweq arénáhní arega eqmarahna aní Sísa suboneheéra sorupariarowe. Érótireq Póntíása Páhírátireq wáhnaupéqté kéreq Ísara kereqka Sísa suboneheéra sorupariarowe. ");
INSERT INTO awb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Arega naho págege iwíáhue miraóna iwíáh anehe kaqme miraurowe. Arerega mina íwíáhóna puara sega menah miraurowe. ");
INSERT INTO awb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Anotah aníno, amahnága sega itensabé, Subónehboq túbáh agotao eme aiq irahne. Ite arene arambehriúna anímárí múne. Minayabe ite íre áhreia peh arene ehweh págegeue irarenehboq séhréh aito. ");
INSERT INTO awb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Arene ehweh irarenaraq awahre ke kaweragigehboq arene ayahtate táhtoro. Sísa arene arambehriyabé awahbeh aní áwírue áhrabonaraq ótaq sansámárí miraúno éra púreruwe. ");
INSERT INTO awb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Púreruwana momiwí nah míu míuúwana Manikáne Awanka sene sirupipeq tunse séhréh arito púara moke sega íre áhreia Manikáne ehweh págegeue iraruwe. ");
INSERT INTO awb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Moke Sísansabé aiq pútare atáh kégá peh morá íwíáhéra sene ménsámehnsá morábí matíówe. Mahna peh morá néne wíre íre iraria peh morábí matíówe. ");
INSERT INTO awb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Eqmaro kega Sísa oga úkú ehweh anotah pagégéue irare irareuwana Manikánka séhréh aritowe. ");
INSERT INTO awb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sísa tagaríáh kébáté mó morá tabonah ani íre míowe. Sega iwíáhutaq sene ménsámehnsá paimaq paiqmaréra meyó moné mewera ");
INSERT INTO awb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","eqmaro ke náríúwara eqmaro kega tabonah ke saraqme náríúwe. Minayabe tabonah ke íre míówe. ");
INSERT INTO awb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Wehukení wenáwíq Sósépa míowara eqmaro kega mó awíq Páhnábásae átówe. Mi awíq Páhnábásawe áwahewé séhréhi aníne áwíq míre. We Sáípára marákórápéqté ánínéna Áríwái káhnáh áníne. ");
INSERT INTO awb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wene marakó peh ákáhtaq éberiopéq paiqmarena meyó moné mewe eqmaro ke siuwe. Sega tabonah ke saraq miageheéna Páhnábásaga siuwe. ");
INSERT INTO awb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mó akéqká iwíáhue mó sansánuye. Wehukení wenáwíq Ánáníási wene ahre áwíq Sapairae. Sene marakó peh ákáhtaq éberiopéq paiqmarera móne meyóye. ");
INSERT INTO awb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ánáníásiga mi moné saime ebeqtaq kopéqmarowana wene ahrega tagówe. Tagówana wega mó akáhtáq mewe eqmaro keyabé péhenue peh ákáhtaq moné náriuwe. ");
INSERT INTO awb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Náriuwana Pítaga wensabé, Ánáníásio, owainawanka iwíáh atéhrah aneqsabé mira íwíáhono? Arene marakó paiqmarahna moné ákáhtaq kopéqsuahnayabé Manikáne Awansabé péhe éhwéh teawene. ");
INSERT INTO awb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Arene marakó íre paiqmarahnaraq tahirí peh arerene kagai iripo? Arene marakórate paiqmatona moné peh arerene matiarona wino. Arega, Móne ákáhtaq kopéqsue péhe éhwéh teriníe íwíáhóna wino. Arene arupipeq aneqsabé ahbabáq iwiáhono? Íre peh wehukeyabé Manikánsabe moq péhe éhwéh teawene úwe. ");
INSERT INTO awb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Úwana Ánáníásiga mi ehwéh irena aunúnkaq márunsurahue putiowe. Putionsabe író kega anotah ahténéra áhre aguwe. ");
INSERT INTO awb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mibeqté máhbígáúnká séra pukú aniné anonka ambantataté úbíqme sehgiwera mómaisarówe. ");
INSERT INTO awb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ánáhkawagá wenawehq putíéhre u ehwéh íre irena apahtáró áhwáh sótaikúwana suwana ");
INSERT INTO awb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pítaga wensabé, Marakó paiqmarehyame mahraue moné meyehyo úwana kowe miraue meyoye úwe. ");
INSERT INTO awb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Úwana Pítaga wensabé, Itega iwíáhétawe Manikáne Awa áhwárawe tagayehe íwíáhewoyo? Arenawehq maisaráh máhbígáúnká amahnága kouwekue méhpehnsah seuríáhwe. Sega arenkakáq sehgiwera pokigehe úwe. ");
INSERT INTO awb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sehgiwera pokigehe útaq mi iní aunúnkaq Pítane aigárátáq márunsurahue putiowe. Putiowara mahbigaunká nahupeq kire putio iní tagéra sehgiwera awehkawa maisarórabeq mómaisarówe. ");
INSERT INTO awb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Moke Sísa tagaríáh kéreq mó kereqka putíóya ehwéh irera anotah ahténéra áhreuwe. ");
INSERT INTO awb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Eqmaro kega wehuke míópi áhnte otáq sánsámárí mirauwe. Asiu kené wahnah aní Sórómóni míotaq pearó oewéhpéhpéq Sísa tagaríáh kégá mitaq sáhuria uriauwe. ");
INSERT INTO awb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sáhuríówara mó kegá iwíáhéra, Sísa tagaríáh kéwé peh kaweqtaq míáh ké wíre íwíáhéra áhtenéra mibeq seba íre suwe. ");
INSERT INTO awb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Áhnte weh áhrégá mó wehekáh mó wehekáhnue Sísansabé aiq pútare atera mó Sísa tagaríáh kébá sáharuqarurowe. ");
INSERT INTO awb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Eqmaro kega áhnte otáq sánsá miraunsabé awahre kegá iwíáhéra, Pítane mánkánahnka iteba sótaikínaraq itene awahre kaweraginkehe íwíáhuwe. Mira íwíáhunsabé sene iyahnaboga meriqmera ahtapeq máhriqtaq mórítówe. ");
INSERT INTO awb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sarúsarama suwahpeq wahtote kereqka awahre kereq owainawanka síwíoqnó kereq meriqmera mórítówara moke kaweragúwe. ");
INSERT INTO awb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnseq wereq míó ke, Sáyúsi kereqka iwíáhéra, Ótaq sansá mirao kegá ite kiotaikiyehboq aneraritanéhnkono uwe. Aneraritanéhnkono éra eqmaro keyabé anotah abíáhnsánéra ");
INSERT INTO awb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","se táhtoqme wahba karábúsíípéq mórítówe. ");
INSERT INTO awb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Inokáhpeq Maniká míéhrabeqte íópeqté ánínká karábúsiipéqté ónsá siwe eqmaro ke máhpeq sitowe. ");
INSERT INTO awb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Máhpeq sitena sensabé, Manikánsabe iwíáh íwíáh atáh náhtápéq kowéq moke náneqmarí oga mía mía ehwéh koreríéro úwe. ");
INSERT INTO awb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Úwara sega ahbiahiperura pokue íópeqté ánínká inokáhpeq koreríéro aritonserah Manikánsabe iwíáh íwíáh atáh náhtápéq kosíwáhnoruwe. Kosíwáhnoruwara Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnseq wereq míó kereqka Asiu kené aboawah wehreq mó kaunsírí kéreqsabé síáhrabuwe. Síáhrabuwara sure morábí méra párísiwarínsábé, Karábúsiipéq mórítáráu ke koweriráhro uwe. ");
INSERT INTO awb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Uwara párísiwarínká pokue karábúsiipéq koragowara eqmaro ke íre míówe. Íre míówara kouwekue sene wahnahnsabé, ");
INSERT INTO awb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Itega tagónawe karábúsiipéqté ónsá paisa tagóne. Karábúsiipéqté wáhnáhmárínká onsarapéq máhpeq iriwe wahnahnatíáhwaq tagóne. Sega wahnahnatíáhwaq onsa siunaraq kabarúna ke íre míáhwe uwe. ");
INSERT INTO awb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uwara Manikánsabe iwíáh íwíáh atáh náhtápéqté párísíwáríné wahnahnseq Manikáne ehweh mibeq mahbeq arítáh kéné wahnahmarínseqka mi ehwéh irera áhtenéra, Árahiro? Se eheragowamo íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Se eheragowamo íwíáhuwana sú aninká sensabé, Itega karábúsiipéq sítáró kegá Manikánsabe iwíáh íwíáh atáh náhtápéq amahnága iriwe síwáhnorowe teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Teriuwara Manikánsabe iwíáh íwíáh atáh náhtápéqté párísíwárínseq sene wahnahnseqka pokue Pítareh kowerirera áhreéra, Mó kegá ebahtaté subíyeho éra pehwehrue kowerirówe. ");
INSERT INTO awb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Koweriqmera kaunsíri kebá mórítówe. Mórítówana Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnka Pítarehyabe ehweh aritowe. ");
INSERT INTO awb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ehweh aritena, Sísane ehweh mónkakáq síwáhnoriyeho teiátáu mino. Teiátáume íre ireq síwáhnoronsabé áhnte Sarúsarama suwahpeqte kégá Sísane ehweh íráhwe. Itega Sísa subitáúna ehwéh aneqsabé teri terinoo úwe. ");
INSERT INTO awb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aneqsabé teri terinoo úwara Pítarehga mahraréra, Manikáne ehweh anterúéhnehboq wehukene ehwehme árahue iranéhnkono? ");
INSERT INTO awb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Itega Sísa awankátaq táhpareq subiq sutowe. Subiq sutowana itereq itene igaqnaréhne Manikánka iriatena oganúq atáráire. ");
INSERT INTO awb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Oganúq atena wensabé, Niyah púpeq míahno atena wehuke kawerarito urairana Sísa mitaq ména ite Ísara ke kaweraitéh ání míéhre. Itene ahbabáq súéhrataq wega kaweraitankéhe. ");
INSERT INTO awb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Manikánka miraurai naneq tagarionayabé teiune. Íre itebataq teiasa Manikáne Awanka mó teíre. Manikáne sansá mirao kebá Wenawa eqmaréhre uwe. ");
INSERT INTO awb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Uwara anotah Asíú wéhwárínká Pítarehne ehweh irera sensabé anotah abíáhnsánéra, Subiq suanehe íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Iwíáhuwana mibeqté káúnsírí ání wenáwíq Kámáría we Péhrasi aní míowe. We Mósísiga sehgíóro ú ehweh síwáhnorú ani míowara mó kegá, We ahtebia ání míre íwíáhuwe. Wega iriwe ména, Mi ke wéhuwa máhpeq sito úwara máhpeq sítówe. ");
INSERT INTO awb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Máhpeq sítówana wega momiwíu keyábé, Ísara keo, mi kegá miraira naneq irareneheqmé kawerue iwíáh atawéq irarero. ");
INSERT INTO awb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Menah wehukení wenáwíq Téúrása ména, Íné anotah aní múge urairara áhnte wehuké 400 wehuké we kétówe. Kétówara mó kegá we subiq sutowara we kétó kega wene arambehri auwera abae ague sene nahtapeq sáh poké agurowe. Poké agurowana wene arambehri parabaguraire. ");
INSERT INTO awb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","We subiq sutowara anehe Kehrari marákórápéqté ání wenáwíq Súrása míaraire. Wahnah kegá wehuke síwíq merotaq mi tanáhráq Súrásareq we kétó kereqka kámáhni wahnáh ké subiq suanehe éra ite kámáhni wahnáh ké míaneheqmúne urowara kámáhni wahnáh kégá Súrása subiq sutowana pukuraire. Pukurairara we kétó kegá moq abae ague sene nahtapeq sáh poké agurowe. ");
INSERT INTO awb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Minayabe teiníboq írátíáhro. Pehwehrue míáhro. Máhpeq míáh ké pehragarítáhro. Mi ehwéh peh seyene iwíáhwé pehipi túbáh agoneherawoe. ");
INSERT INTO awb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Manikánka sene sirupipeq mi iwíáh arítéhmé itega íre ahqáho aritahráhúne. Manikánka itene naruo aní úkínehboq pehwehrue míáhro úwe. ");
INSERT INTO awb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Úwara momiwíu kegá Kámáríane ehweh irera Pítareh síáhrabuwara suwe. Suwara sega subiqmaro atowara wiahnó karatáté subiqmarowara, Sísane ehweh mónkakáq síwáhnoriyeho teriera kaqsúówe. ");
INSERT INTO awb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kaqsúówara Pítarehga kaunsíri ke suera máhpeq pokuwe. Sísane arambehri miraunsabé wahnah kegá subiqmáró púara sene sirupipeq eyoyóuwara pokuwe. ");
INSERT INTO awb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Sega mó wehekáh mó wehekáhnue Manikánsabe iwíáh íwíáh atáh náhtápéqkákáq wehukene nahtapeqkakáq mahrarue síwáhnoréra, Manikánka eqmaraníe ú aní, ite kaweraitahráhi anímé we Sísa wire ue síwáhno aruqaruruwe. ");
INSERT INTO awb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mi tanáhráq Sísansabé aiq pútare ató ke áhnte úkuwe. Káríki ehwéh iraru Asiu kegá peh morá Asiu kené ehweh író keyabé abiahnsanuwe. Abiahnsanéra ehmuniq éhmúníréra, Wahnah kegá táhutahuq mó wehekáh mó wehekáhnue saraqmaráhtáq peh morá Asiu kené ehweh író kene kéweinínsó áhnte náriera itene kéweinínsó pehgáriq nári nárinowe uwe. ");
INSERT INTO awb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Úwara mi airápété téhraníté eqmaro kega mó Sísa tagaríáh kéyábé momiwíoneheqmúne ue síáhrabuwara suwe. Suwara sensabé, Táhutahuq kawerue sararaneheéq ite Manikáne ehweh síwáhnoré arámbéhrí suewé anotah íre kawerire. ");
INSERT INTO awb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Minayabe íráhro. Iteruwahraho, mi arámbéhrí miraigehboq itega ite míonarabeqte abapete téhraníté omaq sítáhro. Mó kegá, Kaweqtaq mía míowe e ke omaq sítáhro. Manikáne Awanka sereq mía míai ke méra kaweq iwíáho ke omaq sítáhro. ");
INSERT INTO awb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ite eqmaq íúwátái kegá peh púrerue Manikáne ehweh íwáhnoroneheqmúne uwe. ");
INSERT INTO awb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Uwara moke író kega, Mi ehwéhmé kaweq ehwéhne íwíáhéra wehukení wenáwíq Sítíbéni omaq atówe. Sítíbéniga Sísansabé kawerue aiq pútare ato aní míowana Manikáne Awanka wene arupipeq mía míaéna séhréh atowe. Mó ke sensíwíq Pírípi, Pókóra, Níkánóri, Tímóni, Páménása, Níkóra miraue omaq sitowe. Níkórawe we Ántíóka suwahpeqte áníne. Téhwe we wáhnaupéqté ání ména anehemé we Asiu kené sánsá miraúwe. ");
INSERT INTO awb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mi ke omaq sitera eqmaro kene siuranabiahtapeq mórítówe. Mórítówara táhutahuq saraqme arámbéhrí miraigeheéra eqmaro kega siyahnkaratáté táhtoqme púrerarítówe. ");
INSERT INTO awb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Manikáne ehweh áhnte síwáhnoru puara Sarúsarama suwahpeq íregáritaq kegá irera Sísansabé aiq pútare atówe. Áhnte Manikáne ehweh mibeq mahbeq arítáh kéreqka mi ehwéh irera Sísansabé aiq pútare atówana Manikáne ehwehnka abae agúwe. ");
INSERT INTO awb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Manikánka Sítíbéni séhréh atena págege ato púana wehuke míórabeq anotah otáq sánsámárí miraúwe. ");
INSERT INTO awb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Miraúwara Sáíríni suwahpeqte Asiu kereq Árékásántáría suwahpeqte Asiu kereqka Sarúsarama suwahpeq momiwíuwe. Sene momiwí nahtápéqsábé Pugeq Súó Kene Nahne ue áwíratówe. Mi kereq Sírísía marákórápéqté kéreq Esia marákórápéqté kéreqka Sítíbéniba pokue ehwehuwe. ");
INSERT INTO awb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ehwehuwana Manikáne Awanka Sítíbéni págege ato púana wega ahtebia éhwéh irarúnsabe mi kegá íre ehweh atahráhuwe. ");
INSERT INTO awb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Íre ehweh atahráhunsabé sega mó keyábé epéráhpéréra, Sítíbéni péhe éhwéh átéhrataq móne náienéhe. Péhe éhwéh mahrarero. Sítíbéniga Mósísireq Manikánseqsabé síéhruru arítáráiraq írátáune ero uwara sega móne mewera mi pehe éhwéh teriúwe. ");
INSERT INTO awb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mi pehe éhwéh teriúnsabe író kereq Asiu kené aboawah wehreq Asiu kené sánsá síwáhnoru kereqne sirupipeq págegeue abiahnsanuwe. Sega Sítíbéniba pokue táhtoqme kaunsíri kebá móátówe. ");
INSERT INTO awb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Móatera péhe kégá mahraréra, Mi anínká Manikánsabe iwíáh íwíáh atáh náhtápéqkákáq Mósísine sánsánkákáqsábé abehq éhwéhne arítáráire. ");
INSERT INTO awb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sísa Néhsara suwahpeqte ánínká Manikánsabe iwíáh íwíáh atáh náh sokoruankéhe uraire. Mósísiga teiu sansamé Sísaga sabi iuaníe urairaq írátáune uwe. ");
INSERT INTO awb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Uwara moke kaunsíri ke tútuue méra Sítíbéni tagowana wene aru ukiqme míonsabe wene auranabiah íópeqté áníné auranabiah tahnsa ágúwe. ");
INSERT INTO awb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Manikáne ehweh mibeq mahbeq arító kene wahnahnka Sítíbéninsabé kasenéna, Sega irare ehwéhmé aiq pútaqpo úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Úwana Sítíbéniga mahraréna, Nánuwahraho, kawerue írátíáhro. Naho naho itene igaqna Ébáráhmaga Áráni suwahpeq íre pokútaq Mésópótémía marákórápéq míowana Maniká anotah pagégé ánínká íópeq auwena Ébáráhmaba séna ");
INSERT INTO awb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","wensabé ehweh teawena, Arene marakówé arenawahrahwe sue teawéna marakórápéq pokúno teawuwe. ");
INSERT INTO awb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Teawuwana Ébáráhmaga Káría kené marakórapeq suena pokue Áráni suwahpeq kowíowana mitaq wenabo pukúwe. Pukúwana Manikánka ite amahnága míona marákórápéq Ébáráhma eqmarowe. ");
INSERT INTO awb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Eqmarowana súwana Manikánka Ébáráhma mahtaqté márákó íre eqatowe. Pehgáriq marákó íre eqatasa peh teawena, Mókake arereq arenanahréhreq iníe úwe. Mi ehwéh teawu tanahráq Ébáráhma íre wenahninkákáq ání míowe. ");
INSERT INTO awb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Manikánka we mó teawena, Arenanahréh mókake wáhnaupéqté kéné marakórapeq míagehe. Mi kegá arambehriraq saiqnaritera subiqmarera áhnte opéq 400 opéq síwíoqnagehe. ");
INSERT INTO awb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Síwíoqnehra ke kamah arinauge. Kamah ariénaraq arenanahréhga mitaq suera mahtaqté márákóráq ínénsabe iwíáh íwíáh aintagéhe teawuwe. ");
INSERT INTO awb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Teawu ehwéh ahreraq kankeheéna Manikánka Ébáráhmansabé, Áú amurúrue sansa miraúno úwe. Úwana Ébáráhmaga animai wenáwíq Áhísáhki maqatowana abapete apahtáró wéhékáh ména wenahniné áú amurú auwowe. Áhísáhki weh úkéna animai wenáwíq Sékópa maqatowe. Maqatowana Sékópaga airápété téhtaré anímáí masitowara wene ahninkáwáréh itene igaqnaréh úkuwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Sítíbéniga mó mahraréna, Sékópane ahninkáwáréh airápété téhraníté méra se ábárahnahnahnka sensíbáq Sósépa abiahnsanéra wáhnaupéqté ké eqsitera móne meyówe. Wáhnaupéqté kégá Sósépa meqmera Ísípi marákórápéq móátówana Manikánka wereq mía míaéna ");
INSERT INTO awb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mó kegá we íre kawerató tanahráq séhréh atowe. Ísípi marákórápéqté wáhnáhnká Sósépa áhrabútaq Manikánka kaweq iwíáh atowana Sósépaga ahtebia éhwéh irarúwe. Ahtebia éhwéh irarúwana Ísípi wahnáhnká, Mah anímé kaweq iwíáhire éna Sósépansabé, Arega moke Ísípi marákóákáq néne nahtapeqté ménsáméhnsánkákáq wahnahnúno atowe. ");
INSERT INTO awb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mi tanáhráq Ísípi marákórápéqkákáq Kénáni marákórápéqkákáq anotah ehwéhrótaq áhnte kene sirupipeq umeh aguwara moq itene igaqnaréh táhutahuq íre kowe. ");
INSERT INTO awb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Íre kowana Sékópaga Ísípi marákórápéq táhutahuq kéhre u ehwéh irena wenahnimáhq táhutahuq sabatáhq Ísípi marákórápéq téh eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Eqmaq suowara Ísípi marákórápéq pokéra táhutahuq mewera sene nahtapeq kouwekuwe. Mi tahutáhúq parabagúwara se Ísípi marákórápéq mó pokutaq Sósépaga wenawahrehyabe, Íné iteríbáq múge ue pahsuqme teriuwe. Pahsuqme teriuwana Ísípi wahnáhnká moq Sósépane awahwáréh ahtebówe. ");
INSERT INTO awb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ahtebówana Sósépaga wene awahwáréhyabe, Nánibo Sékópa meqmeq sero éna eqmaq suowe. Eqmaq suowara awahwáréhga sensibo koweqmera áhnte wehekéq 75 wehekéq weba suwe. ");
INSERT INTO awb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sékópaga Ísípi marákórápéq tuména mitaq pukúwara anehe itene igaqnaréh moq mibeq pukuwe. ");
INSERT INTO awb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ébáráhmaga naho maisaró marakó áwíq Sékéma ebah monéráté paiqmarowe. Ámórine ahninkáwáréhga, Maisia marákó meyo atówana paiqmarowe. Itene igaqnaréhga pukuwara sene animárínká sene ayahnsa mewera mina maisaró marakórápéq ónapipéq móárówe úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sítíbéniga mó mahraréna, Itene igaqnaréhga Ísípi marákórápéq mía míaéra peh íregáritaq aguwe. Manikánka Ébáráhmansabé marakó iníe teawu ehwéh áhníbórá mirainaútaq itene igaqnaréhga íregáritaq aguwe. ");
INSERT INTO awb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Íregáritaq aguwana Sósépa pukúwana Ísípi marákórápéq we íre tagario anínká wahnah aní úkúwe. ");
INSERT INTO awb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mi anínká wahnahnéna itene igaqnaréhyabe péhe aritena síwíoqnówe. Sene animárínká pukigeheéna wega sensabé, Ani maqmaréhrataq mewe máhpeq súáhro aritowe. ");
INSERT INTO awb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mi tanáhráq wenanoga Mósísi maqmarowana Manikánka, Aiq kaweq aníne íwíáh atowe. Apahtáró ío sega wenabone nahtapeq kopípéq kirabo atówe. ");
INSERT INTO awb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Apahtáró íó parabagútaq subíyeho éra máhpeq kopípéq áúwówe. Kopípéq áúwówana Ísípi marákórápéqté wáhnáhné ayahunkawagá we tagéna, Kaweq aníne íwíáhéna meqmena wewene ani tahnsa kirabo atowe. ");
INSERT INTO awb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kirabo atowara Ísípi kegá Mósísi áwáhnoruwana we moke Ísípi kené sánsá ahtebówe. Ahtebéna we págege ahtébíá ání úkéna wene ehwehnkakáq wene arambehriakáq págegeue miraúwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Sítíbéniga mó mahraréna, Mósísi 40 opéq ména, Nánuwahrah Ísara kebá koraganie íwíáhéna koragówe. ");
INSERT INTO awb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Peh morá Ísípi anínká Ísara aní subutaq Mósísiga tagéna wenawahrah aní éhnehéna mi Isípí ání subiq suowe. ");
INSERT INTO awb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Subiq suena iwíáhéna, Manikánka ínénsabe, Arenawahrah séhréh arito éna omaq intowe. Omaq intonsabé nánuwahrahga aiq tagaríáhwe íwíáhúwara wenawahrahga íre tagaríówe. ");
INSERT INTO awb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mó wehekáh wenawahrah aníté tobehuyataq Mósísiga tagéna ayositanieéna sensabé, Ite morá káhnáh móye. Aneqsabé tobehoyo úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Úwana ahbabárato aninká Mósísi pagunsuena wensabé, Insega wahnahnarito teawátáiro? ");
INSERT INTO awb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Inokáh Ísípi aní subiq sutonanserah íné moq nubiq suaníbo úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Úwana Mósísiga mitaq suena pehbeheráh pokue wáhnaupéqté kéné marakó áwíq Míríána marákórápéq kowíowe. Nahnso aní kowéna mibeqté áhré meyowana téhtaré ánímáíráré maqmarowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Sítíbéniga mó mahraréna, Mósísiga mitaq 40 opéq míowe. Sáwéh áwíq Sáínái wega mitaq wahtotaq abataq marákórápéq noguwe. Mitaq noguwana káriq awánká irarówana íópeqté ánínká mi iráípéqté ábóraragúwe. ");
INSERT INTO awb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ábóraragúwana Mósísiga tagéna áhtenéna, Wahtotaq koraganie íwíáhéna sútaq Manikánka teawena, ");
INSERT INTO awb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Íné arene aigaqnaréhne Maniká múge. Íné Ébáráhmareh Áhísáhkireh Sékóparehne Maniká múge úwe. Úwana Mósísiga iransánéna áhreú púana aura íre pankeqme tagówe. ");
INSERT INTO awb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Íre pankeqme tagówana Manikánka wensabé, Íné míó púah arega órira marákórápéq iriwe míahne. Minayabe arene súu ugurúruqme pehipi iriwe míahno. ");
INSERT INTO awb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ísípi marákórápéqté kégá Ísara ke néne animárí síwíoqnahtaq tagaríóge. Sega uwo uwo aruqarurotaq íróge. Ínéga mibeqté meriqmena móbeq móritanieéna tumíóge. Mósísio, are Ísípi marákórápéq eqmaróge. Pokúno teawuwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Sítíbéniga mó mahraréna, Mósísi ítaq mahbí míotaq Ísara kegá wensabé ahqáho atera, Insega wahnahnarito teawátáiro uwe. Mina ahqáho ató ánímé Manikánka arenawahrah amahnága Ísípi marakóráq míówah kowahnahnue meriqme mérito atena eqmarowe. Mósísi abatapi míowana káriq awánká irarowana íópeqté ánínká mi iráípéqté ábóraragútaq Manikánka Mósísi eqmarowe. ");
INSERT INTO awb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Eqmarowana Mósísiga Ísípi marákórápéq ótaq sansá miraéna mi marákó suena wání aroipéq áwíq Káhtore Waní ayehráq móritowe. Móritena mitaq mó otáq sánsá miraéna abatapi móritena mitaq mó otáq sánsá miraúwara 40 opéq míówe. ");
INSERT INTO awb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mósísiga Ísara keyábé, Manikánka ínénsabe, Néne ehweh korerio éna eqmaq nuwonserah mókake mó wene ehweh terí ání iteruwahrahní eqmarankéhe teniátáire úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mirarena mi tanáhráq Ísara ke abatapi míówana Mósísi seba míowana íópeqté ánínká Sáínái sawéhráq Mósísi ehweh teawuwe. Teawuwana Mósísiga itene igaqnaréh mi ogá mé ehweh teriuwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Sítíbéniga mó mahraréna, Itene igaqnaréhga Mósísine ehweh anteruera wensabé íre iuwahbehre éra Ísípi marákórápéqsábé sirutaboiruwe. ");
INSERT INTO awb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ísara kegá Mósísine awahwá Áróninsábé, Arenábáq Mósísi ite Ísípi marákórápéqté meitái aní aiq taqnobagire. We eheq míehrapómo. Ite ebeq itáh máníkámárí míagehboq arene ayahnkaratáté maniká tahnsa náneqmarí miraúno uwe. ");
INSERT INTO awb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Miraúno éra itene igaqnaréhga káho áráhq tahnsa náneq mirarówe. Mirarera minayabe titirarera sene siyahtate miraró naneqsabé iwíáh íwíáh atówe. ");
INSERT INTO awb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iwíáh íwíáh atówana minayabe Manikánka se suowara sega íópeqté náneqmarínsábé iwíáh íwíáh atówe. Minayabe Manikáne ehweh irarú aninká naho sehiranúwana wene ehwehnka mahraréna, Ísara keo, itega 40 opéq abatapi méq itega ménkámehnká subiqmareq titirurowe. Íre ínénsabe iwíáhéq subiqme titiraintárówe. ");
INSERT INTO awb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Péhepehe maníká Móríkine sériraté pearó wehuwéhú nahtapéq móateq mi nahnkákáq sehgieq poku pokuurowe. Itega wehyoq tahnsá náneq mirareq wenáwíq Árépánie ateq itene manikáne atarówe. Iwíáh íwíáhoneheéq itega mi pehepéhé máníkámárí mirarurowe. Miraruronsabé Pábíróni marákórápéq seberaebéq eqmaq iuwanauge ire úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sítíbéniga mó mahraréna, Itene igaqnaréhga abatapi míótaq Manikánka Mósísinsabé, Ínénsabe iwíáh íwíáh aintéhna sériraté wéhuwehu nah mahraue pearo úwe. Manikánka Mósísi sokigiúnserah itene igaqnaréhga mirarówe. ");
INSERT INTO awb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Itene igaqnaréh pukuwara sene animárínká mi seríráté pearó wehuwéhú náh sehgiwera wehukení wenáwíq Sósúa kérówe. Manikánka itene igaqnaréh séhréh aritena sene naruo kaqsuowe. Kaqsuowara itene igaqnaréhga sene naruone marakó meyówe. Mewera mi seríráté pearó wehuwéhú náh sehgiwera kowíówe. Mi nah áhnte opéq kagaúwana Tébíti Asiu kené wahnah úkéna ");
INSERT INTO awb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","kaweqtaq mía míaúnsabe Manikánka wensabé arutaboirúwe. Arutaboirúwana Tébítiga iwíáhéna, Nigaqna Sékópane Maniká kaweq nahupéq míankehboq pearaníe íwíáhéna Manikánsabe, Arene nah pearaníe úwana Manikánka ahqáho atowe. ");
INSERT INTO awb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ahqáho atowana wenahni Sórómóniga Manikáne nahtapeq pearowe. ");
INSERT INTO awb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pearowana Manikánka anotah aní mía míai puana wega íre peh morá wehukega pearáh náhtápéq mía míaire. Minayabe wene ehweh irarú aninká mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Itene Wahnahnka mahraréna, Íópeqmé néne wahnahnu síáh tahnsane. Mah marákó márákówé néne nigúnúbá tahnsane. Minayabe íné moke íópeqkákáq mah marákó márákóákáq wahnah wahnahnuge. Minayabe aneq nah peintanéhbo? Íné íre ahreno aní múge. ");
INSERT INTO awb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ínébataq ínéga moke mah marákó márákórápéqté náneq miraráhwa mino ire úwe teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Teriena Sítíbéniga mó mahraréna, Ite saiyoue píribahri ke wóe. Itene irupipeq íre irasa, ahre parosa ké wóe. Ite Manikáne Awansabé ahqáho atáh ké wóe. Itene igaqnaréhga miraunserah itega amahnága miraowe. ");
INSERT INTO awb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Itene igaqnaréhga Manikáne ehweh iraru ke moke síwíoqno mino. Íre áwíoqno aní insebo? Naho Manikáne ehweh iraru kegá mahraréra, Mókakewe kaweqtaq mía míai aní mahtaq tumíanawire uwara itene igaqnaréhga mina iraru ke subiq súówe. Sega miraunserah itega moq miraurowe. Kaweqtaq míéh ání tumíowaq itega táhtoqmeq móateq subiq sutowe. ");
INSERT INTO awb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Íópeqté kégá Manikánka sehgíóro ú ehweh teiéwaq itega íre ireq mi ehwéh anteruq anteruro mino úwana wene ehweh aiq parabagúwe. ");
INSERT INTO awb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sítíbénine ehweh parabagúwara író kega anotah abíáhnsánéra sirupipeq págege aguwe. Sega Sítíbéninsabé anotah abíáhnsá atówana ");
INSERT INTO awb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Manikáne Awanka wene arupipeq ména séhréhue págege atowe. Séhréhue págege atowana Sítíbéniga íópeq ebitáwéna Manikáne téhreh naneqkakáq tagówe. Sísawe Manikáne ayah púpeq iriwe míowana tagéna ");
INSERT INTO awb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","mahraréna, Tagahro. Íópeq sawekirana wehukení úkurai anínká Manikáne ayah púpeq iriwe míéhrana tagoge úwe. ");
INSERT INTO awb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Úwara sega kareéra ahre parotáwéra moráráq peheráh kure Sítíbéni táhtoqme ");
INSERT INTO awb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","panantáwera ahnansahrapeq móatera sene káhq ambántámárí mitaq marówe. Mitaq marówana wehukení wenáwíq Soraga mi ambántámárítáq wahnahnúwara ebahnsa tuparuqme subiq súówe. ");
INSERT INTO awb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sega ebahnsa tuparuqme subiq súótaq Sítíbéniga púrerue mahraréna, Sísao, are néne Wahnah mone. Néniwa meyo éna ");
INSERT INTO awb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","arehunseraráq ména anotah ehwéhnue púreréna, Néne Wahnahno, sene ahbabáqsabe íre ayahqmaro ue púreréna putiowe. ");
INSERT INTO awb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Putiowana Soraga iwíáhéna, We pukime aiq kawerire úwe. Mi wehekáh mó kegá Sarúsarama suwahpeq Sísa tagaríáh ké anotahtaq síwíoqnowe. Síwíoqnowara sega pokue Súría marákórápéqkákáq Sámáría marákórápéqkákáq abae aguwe. Ómi Sísa tagaríáh kégá abae aguwara peh morá Manikánka eqmaro kega Sarúsarama suwahpeq mitaq míówe. ");
INSERT INTO awb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Táhmaro kaweq kegá Sítíbéni mómaisarera wensabé sirutaboirera anotahtaq ibisowe. ");
INSERT INTO awb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ibisowana Soraga Sísa tagaríáh ké anotahtaq síwíoqnéna mó nahtápéq mó nahtápérue kiena weh ahre táhtoqme panantáwena karábúsiipéq móritowe. ");
INSERT INTO awb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abae agu kegá poku pokuurabeq Sísane ehweh teri terinuwe. ");
INSERT INTO awb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pírípiga Sámáría ke suwahpeq mó anotah matábúrápéq tunse, Sísawe Manikánka omaq ato aní míre éna Sísa Karáhéne ehweh teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Áhnte kegá wene ehweh irera ótaq sansámárí tagéra wene ehweh kawerue írówe. ");
INSERT INTO awb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mi otáq sánsámé Pírípiga owainawamarí áhnte wehukéné sirupipeqté kaqsuowara íre kaweq karéaruera poké aguwe. Wega sinonka mareqmareragú kereq soriqnah kereq kaweraritowe. Minayabe ómiga tagéra wene ehweh kawerue írówe. ");
INSERT INTO awb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Minayabe Sámáría kené sirupipeq eyoyóúwe. ");
INSERT INTO awb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Peh morá áhgórá ání wenáwíq Sáímóni mitaq míowara ómi Sámáría kegá anotahtaq áhtenuwe. Sáímóniga menahmé págege sansánéna, Íné anotah aní múge íwíáhúwara ");
INSERT INTO awb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ómi anotah kereq íre síwíqkakaq kéreqka wene ehweh kawerue irera wensabé, Maniká págege anínéna wega mi aní págege atéhnsábé we anotah pagégé áníne atówe. ");
INSERT INTO awb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mi ahgórá ánínká íre wahto tanáhráq ótaq sansá mira aruqaruru púara moke áhtenéra wene ehweh kawerue irera we kérówe. ");
INSERT INTO awb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","We kérówana Pírípiga Sísa Karáhé áwíqsabe teriena mó kawéq éhwéh Manikánka wahnah wahnahni ehwéh teriuwara weh ahrega mi ehwéhnsábé aiq pútare atówe. Aiq pútare atówana wání meriuwana ");
INSERT INTO awb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","mi ahgórá ání Sáímóniga moq aiq pútare atowana wání meawuwe. Pírípiga ótaq sansámárí miraútaq Sáímóniga anotahtaq áhtenéna kérowe. ");
INSERT INTO awb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Sámáría suwahpeqte kégá Manikáne ehwehnsabé aiq pútare atáhwe teríúwara Sarúsarama suwahpeq eqmaro kega írówe. Írótaq sega Pítareq Sónireq Sámáría marákórápéq eqmaq súówe. ");
INSERT INTO awb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Eqmaq súówara mitaq séra Manikáne Awanka mi kené sirupipeq tumíankeheéra siyahnkaratáté táhtoqme púreruye. ");
INSERT INTO awb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Pítararégá íre suyataq mó kegá itene Wahnah Sísa áwírue wání meriútaq Manikáne Awanka sene sirupipeq íre tumíowe. ");
INSERT INTO awb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Minayabe Pítararégá siyahnkaratáté táhtorera púreruyana Manikáne Awanka Sámáría kené sirupipeq tumíowana ");
INSERT INTO awb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sáímóniga mina tagówe. Tagéna móne mewe séna Pítararéyábé, ");
INSERT INTO awb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Niyahnkaratáté mó ke táhtoráhnaraqmé Manikáne Awanka sene sirupipeq tumíankehboq págege aintáhtao úwe. ");
INSERT INTO awb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Úwana Pítaga wensabé, Arene móneakáq arenkakáq toráh aginiewóne. Manikánka pehipi awina naneq íre paiqmarahráhóne. Arega mira íwíáhóna puah iraipéq toráh aginiewóne. ");
INSERT INTO awb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Itega miraúya arámbéhrí arereq wehgaqpo? Manikánka arene arupipeq tagaríéhre. Arene arupipeq íre kaweq iwíáhóna puah arega itene arambehri íre miraorahóne. ");
INSERT INTO awb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Arene ahbabáq iwiáh sue mahraue púreré, Nirupipeqté áhbábáq íwíáh kawerainto úno. ");
INSERT INTO awb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Arene arupipeq tagome ahbabáqka kírágírá atíéhre úwe. ");
INSERT INTO awb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Úwana Sáímóniga Pítansabé, Arega iraréna ehwéh aiq pútaragínehboq púrerainto úwe. ");
INSERT INTO awb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pítareq Sónireqka mi ke suwahpeq méra, Sísaga ite anotahtaq séhréh aitáráire éra Sísane ehweh teriuye. Teriera mitaq suera Sámáría marákórápéq mó mapéq mó mapérue kaweq ehwéh teriera Sarúsarama suwahpeq kouwekuye. ");
INSERT INTO awb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Manikáne íópeqté ánínká Pírípinsabé, Sokah sokahue Sarúsarama suwahpeqte Kása suwahpeq kuríéh áh abatapité áhtápéq pokúno úwe. ");
INSERT INTO awb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pokúno úwana sokah sokahuena pokúwe. Pokéna mi ahtápéq kútaq Ítíópía aní tagówe. Naho mó kegá sene íre kaweq sansá miraéra mi Itíópíá áníné awahnta pirúówe. Mi anímé Ítíópía marákórápéqté wáhnáh íní wenáwíq Kántásine móneraq wahnah wahnahnú aníne. We Sarúsarama suwahpeq Manikánsabe iwíáh íwíáh atórabeq kéna kouwekúwe. ");
INSERT INTO awb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kouwekéna we óserarégá sabirue nogí káhréípéq tútuue ména Manikáne ehweh irarú ani Áísáíaga sehiranaro ehwéh sáhnsahuwe. ");
INSERT INTO awb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sáhnsahuwana Manikáne Awanka Pírípinsabé, Mi aníné káhreraq wahtotaq kowíahno úwe. ");
INSERT INTO awb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Úwana Pírípiga pehbeheráh weba kútaq Áísáíaga sehiranú ehwéh sáhnsahuwana irowe. Irena wega kasenéna, Arega sáhnsahona ehwéh aiq ahtebahno úwe. ");
INSERT INTO awb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Úwana, Mó anínká íre níwáhnorinsabé árahue ahtebaninkono? Arega mah kahréípéq ínéba mahbeq kieague kirútuúno úwe. ");
INSERT INTO awb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ítíópía anínká sáhnsahu ehweh, Manikáne ehwehnka mahraréna, Sipisípiq suboneheéra meráhtáq sipisípiqka ehiya míéhre. Mina inserah wega ehiya míéhre. Sipisípiq áyó kiraqsúéhtáq sipisípiqka íre kureq kurerire. Mina inserah wega íre ehwehnire. ");
INSERT INTO awb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Sega we ehweh atáhtáq íre aiq pútaq ehwéh irarewe. Subiq súáhnsábé we mah marákóípéq íre míéhre. Sega wene oga mé tanahráq parabarúáhwe. Wene animárí íre míáh púara wehukega se éhweh íre terieráhowe ire. ");
INSERT INTO awb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ítíópía anínká Pírípinsabé, Iraníboq tenio. Manikáne ehweh irarú aninká insensabe irarúwo? Wewensabé irarúwo? Mó anínsábé irarúwo kasenúwe. ");
INSERT INTO awb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kasenúwana Pírípiga mi ehwéhtárue Sísane kaweq ehwéh teawuwe. ");
INSERT INTO awb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sega wání aroipéq suyataq mi anínká Pírípinsabé, Tagáhno. Wání mahtaq kéhre. Arega wání meniníbo kasenúwe. ");
INSERT INTO awb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kasenúwana, Arene arupipeq Sísansabé aiq pútare atéhnaraq wání meawiníe úwe. Úwana mi anínká, Sísa Karáhé Manikáne ahninkáwáe. Minayabe aiq pútare atóge úwe. Aiq pútare atóge éna ");
INSERT INTO awb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","óseraréyábé, Túbáh agotao aritowe. Sega wání aroipéq túyana Pírípiga wání meawuwe. ");
INSERT INTO awb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wání aroipéq suera kíúyataq Manikáne Awanka Pírípi meawuwana Ítíópía anínká we mónkakáq íre tagéna ahtapeq pokútaq wene arupipeq anotah eyóyóúwe. ");
INSERT INTO awb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Eyoyóúwana Pírípiga Ásáróta suwahpeq ábóraq kéna mó natáq mó natárue wega Sísane ehweh teri terinúwe. Teri terinéna Sésáría suwahpeq kúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Soraga Sísa tagaríáh kéyábé anotah ehwéh aritena, Mi ke síwíoqnéna subiq suaníe íwíáhéna Manikáne ehweh mibeq mahbeq arítáh kéné wahnahpa pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Pokéna wensabé, Sísa tagaríáh ké weh ahre tagéna táhtoqme koweriqmena Sarúsarama suwahpeq méritaníboq páhsiwarí nánio. Támákása suwahpeqte Asiu kené momiwí nahmárítápéqté ké sokigi ariniboq páhsiwarí nánio úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Úwana mi anínká páhsiwarí sehiranue awuwana Soraga mewena Támákása suwahpeq pokue wahtotaq kútaq apubúue íópeqté Manikáne téhrehnka anotahtaq téhrówe. ");
INSERT INTO awb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Téhrówana wega marakóipeq múrunsurahúwana íópeqté éhwéhnká iraréna, Sorao, Sorao, aneqsabé níwíoqnahno úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Úwana Soraga iraréna, Anotah aníno, are insebo úwana, Íné Sísa uge. Íné arega níwíoqnáhna aní múge. ");
INSERT INTO awb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Irigue mi ke suwahpeq pokúno. Mitaq arega mirainieóna arámbéhrí éhwéh peh morá ánínká teawinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Úwara Sorareq nogú kega mi ehwéh irera wehuke íre tago puara peh ehiyansá síwéh panantágúwara míówe. ");
INSERT INTO awb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Soraga irigue aura pankeqme ebiena tagótaq íre tagahrahúwe. Íre tagahrahúnsabe wereq nogú kega wene ayahtaq panantáwera Támákása suwahpeq móátówe. ");
INSERT INTO awb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Móátówana apahtáróráq wene aura íre tagahrahéna wánínkakaq táhutahuqkakáq awehriúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Awehriúwana Támákása suwahpeqte ání Sísa tagaríéh ánínéna wenáwíq Ánáníásie. Ánáníásine awanka tagówana Manikánka áhrabéna, Ánáníásio úwe. Ánáníásio úwana, Mahna míóge úwana ");
INSERT INTO awb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Manikánka wensabé, Wehukení wenáwíq Súrásae. Irigue wene nahtápéqté áh áwíq Obarisa áhtápéq pokúno. Wene nahtapeq Tahsa suwahpeqte ání wenáwíq Sora ména amahnága púrerire. ");
INSERT INTO awb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Métáq wenawanka tagéwéhtáq wene aura ebieyabe arega weba sure táhtorahnana wene auranka tagehre. Weba koragáhno úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Úwana Ánáníásiga mahraréna, Áhnte kegá arega iraréna aníné ahbabáqsabe teníátówe. Sarúsarama suwahpeqte Sísa tagaríáh ké wega íre kawerarítáráire. ");
INSERT INTO awb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Moke arenáwírue áhrabo ke karábúsiipéq móritanieéna sire. Manikáne ehweh mibeq mahbeq arítáh kéné wahnahmarínká páhsi awera pokue komiraúno átárówe úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Úwana Manikánka wensabé, Pokurio. Néne arambehri mirainkeheéna omaq atáráuge. Wega Ísara kereq wáhnaupéqté kéreq sene wahnahmarínseq néne ehweh korerinkéhe. ");
INSERT INTO awb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Néne arambehri miraínayabé mó kegá we anotahtaq áwíoqnagehe. Minayabe sokigi awinauge úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Úwana Ánáníásiga pokue Sora mío nahupéq kibekéna wene ayahtate táhtorena wensabé, Sorao, are náníbáq móne. Arega ahtapeq séwaronaraq itene Wahnah areba séwíarai ani wenáwíq Sísaga eqmaq núwéhre. Arega mó tagehnana Manikáne Awanka arene arupipeq sewíankeheéna eqmaq núwéhre úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Úwana Sorane aura ahra tahnsá akariatio naneq apubúue megúwana tagéna irigúwana wání meawuwe. ");
INSERT INTO awb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wání meawuwana táhutahuq nówana wene anonka págege agúwe. Táhmaro wehekáh Soraga Sísa tagaríáh kébá Támákása suwahpeq ména ");
INSERT INTO awb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","apubúue Asiu kené momiwí nahtápéq kiwéna Sísa éhweh teriena, Sísawe Manikáne ahninkáwáe úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Úwara wene ehweh író kega moke áhtenéra mahraréra, Irari anínká Sarúsarama suwahpeq ména Sísa áhrabo ke síwíoqnéna karábúsiipéq sitárái mino. Mahtaqkákáq mirainieéna surai mino. Wega Sísa áhrabo ke táhtoqme táhruue Manikáne ehweh mibeq mahbeq arítáh kéné wahnahpa móritanieéna surai mino uwe. ");
INSERT INTO awb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Uwana Soraga págege ehwéh irarú ani úkue kaweq tábúsoqme ehweh teriena, Mah marákó márákóípéq sína aní, Manikánka omaq ato anímé Sísa wire ue tábúsoqme síwáhnorúwe. Tábúsoqme síwáhnorú púara Támákása suwahpeqte Asiu kegá mó íre irarerahowe. ");
INSERT INTO awb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Áhnte wehekáh sótaikúwara Asiu kegá momiwíue sío síoéra, Sora subiq suanéhe íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Subiq suanéhe íwíáhéra moráénuwana mó anínká sene ehweh irena Sora koreawuwe. Koreawuwara sega suboneheéra Támákása suwahpeqte áhnánsáhrápéqté áhtápéq wéhékáhnkakaq inokáhpeqkakáq wahnah wahnahnuwe. ");
INSERT INTO awb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Wahnahnuwara inokáhpeq Soraga anotah pahsíkétíípéq tútuue míowara we kéró kega méatera náhníáqtate páhsíkétiraq iwe panantáwe tunse ebah kuri pera máhpeq márunátówe. ");
INSERT INTO awb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Soraga Sarúsarama suwahpeq pokéna, Sísa tagaríáh kébá kowíanauge íwíáhúwara sega wensabé áhreéra, We íre aiq pútaq Sísa tagaríéh ání míre íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Iwíáhuwana Páhnábásaga Sora meqmena eqmaro keba móatowe. Móatena sensabé, Mah anínká ahtapeq itene Wahnah tagarairana wega ehweh teawátáire. Teawátáirana wega Támákása suwahpeq Sísa éhweh págegeue síwáhnoruraire úwe. ");
INSERT INTO awb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Úwana Soraga Sísa tagaríáh kébá mía míaéna Sarúsarama suwahpeq íre áhreia peh mó minatáq mó mahnatárue Sísa éhweh págegeue síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Síwáhnorúnsabe wereq Káríki ehwéh iraru Asíú kéreqka ehwehuwe. Mi kegá, Sora subiq suaneheqmúne íwíáhuwara ");
INSERT INTO awb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sísa tagaríáh kégá mina irera Sora meqmera Sésáría suwahpeq márunatera mibeqté Tahsa suwahpeq eqmarówe. ");
INSERT INTO awb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Eqmarówara mi tanáhráq mó kegá Súría marákóákáq Kehrari marákóákáq Sámáría marákóákáq Sísa tagaríáh ké íre síwíoqnia peh míówe. Peh míówara sirupipeq Sísane sánsá ahtebéra kawerue mirauwe. Manikáne Awanka págege aritena sirupipeq kaweq iwíáh aritowara íregáritaq mó wehekéqká Sísansabé aiq pútare atera kawerue kérówe. ");
INSERT INTO awb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pítaga Sísa tagaríáh ké míó nahmárítápéq poku pokuúwe. Pokéna Áríra suwahpeqte Sísa tagaríáh kéreqpa tuwe. ");
INSERT INTO awb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mi ke suwahpeq mío aní wenáwíq Áíníae. Wega abapete apahtáró ópéq wene máhriqtaq ména ah íre nogoráhúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ah íre nogoráhúwana Pítaga we tagéna wensabé, Áíníao, Sísa Karáhéga amahnága kaweratéhre. Irigue arene máhriq sabaráwe sokah sokahúno úwana wega apubúue irigúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","We kaweragúnsabe moke Áríra suwahpeqte kéreq Sáróna suwahpeqte kéreqka tagéra Sísansabé aiq pútare atera, Wene sánsá sehgionéhe íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sópa suwahpeq mío iní wenáwíq Tábítae. We Sísa tagaríéh ání míowara Káríki ehwéh iraru kegá Tókásie ue áwíratowe. We kaweq arámbéhrí íní ména íre arambehrioraho ke séhréh aruqarurúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Píta Áríra suwahpeq míotaq mi iní anotahtaq awahreue pukúwe. Pukúwara wene anonka pabeq paberue abobóráhpeqte náhtápéq átówe. ");
INSERT INTO awb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Sópa suwahpeq Áríra suwahpeq wahtotaq kowara Sísa tagaríáh kégá Pítawe Áríra suwahpeq míéhre u írówe. Irera téhraníté Pítaba eqmaq suera, Pehbeheráh súno koreawétao éra eqmaq súówe. ");
INSERT INTO awb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eqmaq súówara pokue koreawúye. Koreawúyana Pítaga se kérirowe. Eqmaq súó keba suwara sega meqmera abobóráhpeqte nahtapéq móátówara mibeqté kéwéínínsónká Pítaba iriwe méra ibisowe. Ibiséra Tókási oga míotaq miraro korósí Píta sokigiue teawúwe. ");
INSERT INTO awb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pítaga se moke máhpeq kaqsuena arehunseraráq ména púrerúwe. Púreréna pabeqme putio anínsábé, Tábítao, irigúno úwe. Irigúno úwana wene auranka tagéna Píta tagótaq máhriqtaq kirútuue míowe. ");
INSERT INTO awb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Míowana Pítaga wene ayahnkara táhtoqme pankeq auwowe. Pankeq auwena kéweinínsónseq mó Sísa tagaríáh kéreqsabé síáhrabéna sensabé, Seragahro. Oga úki aní tagahro éna sokigi ariuwe. ");
INSERT INTO awb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Moke Sópa suwahpeqte kégá oga úkú ehweh irera áhnte kégá Sísansabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pítaga áhnte wehekáh Sópa suwahpeq ména ménkámehnkáne áú kaweraqari aní wenáwíq Sáímónine nahtapeq kaegaeúwe. ");
INSERT INTO awb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sésáría suwahpeq mío weh wenáwíq Kóníríae. We áhnte Aroma sontíá ké 100 Ítári marákórápéqté sóntíá kéné kíápéténí míowe. ");
INSERT INTO awb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","We Maniká awahbeh sansa sehgiu aníne. Mi karírónánínká Manikánsabe iwíáh íwíáhéra wene sánsá sehgíúwe. We íre arambehrioraho ke nári nárinena Manikánsabe púreq aruqarurúwe. ");
INSERT INTO awb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Íó tunsorerutaq wenawanka tagówana Manikáne íópeqté ánínká weba súwana kawerue togówana wensabé, Kóníríao úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Úwana we ebitáwéna áhreéna wensabé, Árahono úwe. Árahono úwana íópeqté ánínká wensabé, Arega púreq aruqarurónawe Manikánka irena arega tabonah ke nári nárinónawe wega tagéna arensabé kaweróne atéhre. ");
INSERT INTO awb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wehukení wenáwíq Sáímóni we mó awíq Pítae. We Sópa suwahpeqte koweragéhboq wehuke eqmaq suo. ");
INSERT INTO awb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Pítaga ménkámehnkáne áú kaweraqari aníné nah sóreq waní áhkórapeq kéh náhpípéq kaegaeire. ");
INSERT INTO awb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","We koweragéhboq wehuke amahnága eqmaq suo éna pokúwe. Pokúwana Kóníríaga wene arambehriuya anítéreq peh morá sóntíá ánínseq síáhrabúwe. Mi sontíá ání Maniká awahbeh sansa sehgí ání ména Kóníría séhréhú ani míowe. ");
INSERT INTO awb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Síáhrabéna su ke íópeqté áníné ehweh moke teriena Sópa suwahpeq eqmaq suowe. ");
INSERT INTO awb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mó wehekáh se ahtapeq Sópa suwahpeq áhníbórá kutaq Pítaga nah abogéhrapeq wehekáhnabubu púrerinieéna kiuwe. ");
INSERT INTO awb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Púreréna arupibiúwana, Tópahnsabé níre úwe. Mó kegá táhutahuq tíátótaq wenawanka tagówe. ");
INSERT INTO awb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tagówana íópeq sawekúwana mipeqté anotah paráhnkéq tahnsa náneq tuwe. Ébeq ayéhráq ébeq ayéhrárue pagume we míorabeq mewerúwe. ");
INSERT INTO awb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mi paráhnkéqpípéq áhnte menkáméhnkánkákáq karahrabahnkakáq kabarankakáq míówe. ");
INSERT INTO awb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Míówana íópeqté éhwéhnká mahraréna, Pítao, irigue mi kamárí subiqme tíwe náhno úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Subiqme tíwe náhno úwana Pítaga anotah ahqáho éna, Anotah Wahnáh áníno, ite Asiu kegá íre nona naneq kamárí púana órirane. Naho íre narauge. Amahnága moq íre nanauge úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Úwana íópeqté éhwéhnká mó mahraréna, Manikánka kaweraréh náneqsabé órirane atéhneho úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Apahtáróráq ménkámehnká parahnkeqpipeq sáhue mewena márumarena tuekéna úwana íópeqté éhwéhnká mó apahtáróráq irarúwana íópipeq tumeyowe. ");
INSERT INTO awb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Wenawanka tagónsabe Pítaga áhtenéna, Néniwanka aneq tagehramo íwíáhúwe. Mira íwíáhútaq Kóníríaga eqmaq suo kega Sáímónine nah kabarue ábóraq marera ogesáh ogesáhrapeq iriwe míówe. ");
INSERT INTO awb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Iriwe méra anotahtaq kasenéra, Sáímóni mó awíq Píta mahtaq kaegaeiro kasenuwe. ");
INSERT INTO awb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Wenawanka tagónsabe Pítaga iwíáhútaq Manikáne Awanka wensabé, Sáímónio, írátíahno. Apahránítógá arensabé anebahrowe. ");
INSERT INTO awb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Iriwe tutagáhno. Ínéga se eqmaró púah iwíáh kikirinehboq pehipi kériro úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Úwana Pítaga seba tutagéna sensabé, Itega kabaro anímé íné úge. Aneqsabé seo úwara ");
INSERT INTO awb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","sega wensabé, Sóntía kené kíápéténi wenáwíq Kóníríaga eqmaq íúwátáire. We kaweqtaq mía míai aní ména Manikánsabe áhtenuwe. Moke Asiu kegá iwíáhéra, Kóníríawe peh kaweqtaq tabasíwe míéh áníne íwíáhuwe. Maniká míéhrabeqte íópeqté ánínká wensabé, Pítaga ehweh teinkéhboq siqmarehnara arene nahtapeq koweráhro uraire uwe. ");
INSERT INTO awb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Uwana Pítaga sensabé, Nahupeq kíóro éna inokáhpeq kirabo aritowe. Ahbiahipeq Pítareq we seweró kereqka pokuwara mó mibeqté Sísa tagaríáh kégá kérówe. ");
INSERT INTO awb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mó wehekáh Pítarehga Sésáría suwahpeq kuwe. Kóníríaga wenawahrahreq wene iyahnabo anímárínseq síáhrabúwara sega wene nahtapeq sure momiwíue Píta áwénunuwe. ");
INSERT INTO awb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pítaga nahupeq kinautaq Kóníríaga weba séna wene aigárátáq arehunseraráq ména wensabé iwíáh íwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Iwíáh íwíáh atowana Pítaga wensabé, Irigúno. Íné moq peh wehukení múge úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pítareq wereq ehwehnéra nahupeq kíúyara áhnte wehuké mitaq sáhuríówe. ");
INSERT INTO awb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mitaq sáhuríówana Pítaga sensabé, Asiu kené sánsámé nahnso ke momiwíotaqmé Asiu kegá mibeq pokéyabe órira míre éq íre pokorahúne. Minayabe tagaríáhwe. Manikánka sokigiue teniena, Mó ke peh abehq ké wóe íwíáhineho uraire. ");
INSERT INTO awb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Minayabe itega níáhraburowana pehipi surauge. Aneqsabé níáhraburoo? Teníéro úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kóníríaga Pítansabé, Mó mahsenahrí amahnága tahnsa tanáhráq tunsoreráitaq nahtapeq púrerurauge. Púreruraugana patahga inserah téhreh ambántánkákáq ánínká íné míarautaq ábóraruraire. ");
INSERT INTO awb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ábóraréna ínénsabe, Kóníríao, Manikánka arega púreróna ehwéh íréhre. Arega nári nárinóna sansá tagaríéhre. ");
INSERT INTO awb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Minayabe wehukení wenáwíq Sáímóni we mó awíq Píta kowero. We Sópa suwahpeqte kiweragéhboq wehuke eqmaq suo. Mó aní wenáwíq Sáímóni ménkámehnkáne áú kaweraqari aníne nah sóreq waní áhkórapeq kéh náh Pítaga kaegaeire uraire. ");
INSERT INTO awb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Urainsabé are kiwerageheéna apubúue wehuke eqmaq súátáuge. Eqmaq súátáugah arega suronawe kaweróne. Ite ómiga Manikáne aurátaq sewíone. Minayabe Manikánka korerio urai ehwéh amahnága moke teio úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kóníríaga, Moke teio úwana Pítaga sensabé mahraréna, Íné amahnága tagaríómé Manikánka aiq pútaq moke mah kehiná kéhínánsábé monseráhnue arutaboirire. ");
INSERT INTO awb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wensabé áhtenéra kaweqtaq mía míao keyábé arutaboirire. Íre peh morá Asiu keyábé moke mah kehiná kéhínánsábé arutaboirire. ");
INSERT INTO awb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Manikánka ite Ísara ke teiu ehwéhmé itega írátíáhwe. Mi ehwéhmé Sísa Karáhéwé mah kehiná kéhíná wahnahnarítéhre. Wene kaweq ehwéhnsábé aiq pútare atáh ké peh morá ké tahnsa úkowe. ");
INSERT INTO awb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Sóniga Kehrari marákórápéq kaweq arámbéhrí áhwáréna ehweh teriena wání meriuwe. Anehe ite moke Ísara kehiná suwahpeq mirauro sansá aiq tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Manikánka Sísa Néhsara suwahpeqte ánípá Wenawa eqmatairana Wenawanka Sísa séhréh atena págege atáráire. Sísaga mó ke suwahpeq mó ke suwahperue pokue kaweq arámbéhrí arítáráire. Manikánka Sísaba mía míai puana owainawanka síwíoqneh ke kawerarítáráire. Ínéga teiú éhwéhmé aiq íráhwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Pítaga mó mahraréna, Asiu kené marakórápéqkákáq Sarúsarama suwahpeqkakáq Sísaga moke mirarurai arámbéhrí ínéreq mó we kéró kereqka tagaraune. Ísara kegá Sísa awankátaq táhparera subiq sutowe. ");
INSERT INTO awb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Subiq sutowana pukúwana apahtáró wéhékáhtáq Manikánka Sísa iriwe oganúq atáráirana wega iteba suraire. ");
INSERT INTO awb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Íre ómi kehinápá peh iteba surairaq tagaraune. We oganúq kuraitaq tagéq itereq wereq moráráq táhutahururaune. ");
INSERT INTO awb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Manikánka itensabé, Mah kehiná kéhíná koreríéro. Sísa ínéga omaq ató ánínká mókake moke oga míáh kéreq pusa kéreq ehweh aritankéhe. Mi ehwéh tábúsoqme koreríéro uraire. ");
INSERT INTO awb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Moke Manikáne ehweh iraru kegá mahraréra, Mi aní áwíq áhrabéra wensabé aiq pútare atáh kéwé Manikánka sene ahbabáq kaweraritankéhe uwe teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pítaga mi ehwéh teriutaq Manikáne Awanka író kene sirupipeq tumíowara ");
INSERT INTO awb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","sega kambare ehwéh iraréra Manikánsabe iwíáh íwíáh atówe. Iwíáh íwíáh atówara Sísansabé aiq pútare atáh Ásíú ké Pítareq su Asiu kegá irera áhtenuwe. Áhtenéra irarera, Manikáne Awanka íre peh morá iteba tumíéhre. Nahnso keba moq tumíéhre uwe. ");
INSERT INTO awb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Uwana Pítaga mahraréna, Manikáne Awanka itene irupipeq tumíarainserah mah kené sirupipeq moq tumíéhre. Minayabe wání merieyabe insega ahqáho aitahráhiro úwe. ");
INSERT INTO awb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Insega ahqáho aitahráhiro éna Sísa Karáhé áwíqtaq wání meríéro úwara mi ke wání meriúwe. Wání meriúwara sega Pítansabé, Táhmaro wehekáh mahtaq míahno uwe. ");
INSERT INTO awb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nahnso kegá Manikáne ehwehnsabé aiq pútare atárówe uwara Súría marákórápéqté eqmaro kereq mó Sísa tagaríáh kéreqka írówe. ");
INSERT INTO awb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Írówana Pítaga Sarúsarama suwahpeq kiutaq mibeqté síú amurúrúó kegá ehweh atówe. ");
INSERT INTO awb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ehweh atera, Íre Asiu kené nahtapeq árahinsabé pokue táhutahururono uwe. ");
INSERT INTO awb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Uwana Pítaga Kóníríane nahtapeq pokú ehweh mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Íné Sópa suwahpeq púrerurautaq néniwanka tagaraire. Tagarairana íópeqté anotah paráhnkéq tahnsa náneq tutaire. Ébeq ayéhráq ébeq ayéhrárue íné míaraurabeq mewe tutaire. ");
INSERT INTO awb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Íné ebitáwéna ménkámehnkánkakaq karahrabahnkakáq kabarankakáq mi paráhnkéqpípéq míaraire. ");
INSERT INTO awb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Míarairana íópeqté éhwéhnká iraréna, Pítao, irigue mi kamárí subiqme tiwe náhno uraire. ");
INSERT INTO awb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Urairana ínéga anotah ahqáho éna, Íre nóna naneq kamárí púana naho íre narauge. Amahnága moq íre nanauge urauge. ");
INSERT INTO awb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Uraugana íópeqté éhwéhnká mó mahraréna, Manikánka kaweraréh náneqme íre no naneq kane atéhneho uraire. ");
INSERT INTO awb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mi ehwéh apahtáróráq irarurairana mi paráhnkéqkákáq íópeq tuekuraire. ");
INSERT INTO awb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tuekuraitaq Sésáría suwahpeqte ánínká, Íné koweniro únsabe apahránítógá íné koweniraneheéra kaeurau nahtápéq suwe. ");
INSERT INTO awb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Suwana Manikáne Awanka ínénsabe, Iwíáh kikirinehboq pehipi kériro urairaq ínéreq abapete morá mó Sísa tagaríáh kéreqka se kérítáúne. Kérireq itega mi wehné nahtapeq kure kiraune. ");
INSERT INTO awb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kiraunana wene nahtapeq íópeqté tutai aníné ehweh teiátáire. Teiena, Íópeqté tutai anínká ínénsabe mahraréna, Wehukení wenáwíq Sáímóni we mó awíq Píta Sópa suwahpeq míéhre. We kiweragéhboq wehuke eqmaq suo. ");
INSERT INTO awb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","We sínaraq arereq arenawahrahreqsabé oga úké ehweh teinkéhe ire uraire. ");
INSERT INTO awb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kóníríaga mi ehwéh teníátáirana ínéga Sísa éhweh áwaheue teríátáuge. Sísa éhweh áwaheue teríátáutaq Manikáne Awanka sene sirupipeq tumíaraire. Téhwe itene irupipeq tumíarainserahnue tumíaraire. ");
INSERT INTO awb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","We marakóipeq míaraitaq Sísaga mahraréna, Sóniga wání meri merinínana Manikáne Awanka itene irupipeq tumíankehe uraire. ");
INSERT INTO awb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Manikáne Awanka sene sirupipeq tumíarairana mi ehwéh niahreraq káráire. Itega Sísa Karáhénsabe aiq pútare atárówana Manikáne Awanka itene irupipeq tumíaraire. Itene irupipeq tumíarainserah sene sirupipeq moq tumíaraire. Manikánka wewega miraruraire. Íné peh wehukení míó púana Manikánsabe árahue ahqáho atanínkono úwe. ");
INSERT INTO awb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Úwara sega Pítane ehweh irera túbáh aguwe. Túbáh agéra Manikánsabe iwíáh íwíáh atera, Nahnso keakáq sene ahbabáq súáhnsábé Manikánka oganúq sítéhre uwe. ");
INSERT INTO awb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sítíbéni subiq súó tanahráq sega Sísa tagaríáh ké síwíoqnowe. Síwíoqno puara sega Sarúsarama suwahpeq suera abae aguwe. Abae ague mó kegá Pónísía marákórápéq pokuwara mó kegá Sáípára marákórápéq pokuwara mó kegá Ántíóka suwahpeq pokuwe. Poké agurabetaq peh morá Asiu ke Sísa éhweh teríúwe. ");
INSERT INTO awb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Táhmaro Sísa tagaríáh kéwé Sáípára marákórápéqté kéreq Sáíríni marákórápéqté kéreqka Ántíóka suwahpeq pokue Káríki ke Sísa itene Wahnah éhweh teríúwe. ");
INSERT INTO awb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Wene ehweh teríú ke Manikánka séhréh arito púara áhnte kegá Sísansabé aiq pútare atera, Wene sánsá sehgionéhe íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Sarúsarama suwahpeqte Sísa tagaríáh kégá irera Páhnábása Ántíóka suwahpeq eqmarówe. ");
INSERT INTO awb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Eqmarówana Ántíóka suwahpeq séna Manikánka wehuke séhréh arito tagéna wene arupipeq eyoyóúwe. Eyoyóéna sensabé túbáh agiyehboq Sísane sánsá kawerue sehgíóro úwe. ");
INSERT INTO awb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Páhnábása kaweqtaq mía míaú aní ména Sísansabé kawerue aiq pútare atowana Manikáne Awanka séhréh atowe. Séhréh atowara áhnte kegá Sísansabé aiq pútare atera, Sísane sánsá sehgioneheqmúne íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Páhnábásaga Sora anebahrinieéna Tahsa suwahpeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pokéna Sora tagéna koweqmena Ántíóka suwahpeq kouwekúwe. Sega peh morá ópéq mitaq méra Sísa tagaríáh kérerue momiwíue áhnte ke síwáhnoruye. Mitaq mó kegá Sísa tagaríáh kéyábé Kárísítíni kee ue téh síwírarítówe. ");
INSERT INTO awb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mi tanáhráq Manikáne ehweh iraru kegá Sarúsarama suwahpeq suera Ántíóka suwahpeq túwe. ");
INSERT INTO awb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Peh morá sú ani wenáwíq Ágábúsaga iriwe míowana Manikáne Awanka iwíáh atowana irarúwe. Iraréna, Anotah ehwéhráhna tanáhráq mah marákó márákó sinae úwe. Wehukení wenáwíqtare Káróríúsa Sísáhri anotah wahnáh ání míotaq mi ehwéh aiq pútaragúwe. ");
INSERT INTO awb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aiq pútaragúwara Ántíóka suwahpeqte Sísa tagaríáh kégá iwíáhéra, Súría marákórápéqté Sísa tagaríáh ké táhutahuq paiqmarageheéq móne nárienéhe. Náriníe ú aninká wewega iwíáhue náriuwe. ");
INSERT INTO awb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mina tahnsa sene móne morábí soruparówara Páhnábásareq Sorareqka mi moné mewera Súría marákórápéq pokuye. Mitaq Sísa tagaríáh ábóáwáh wéhgá nárigeheéra móríúye. ");
INSERT INTO awb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mi tanáhráq Asiu kené anotah wahnáh ání wenáwíq Érótiga Sísa tagaríáh ké síwíoqnówe. ");
INSERT INTO awb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Síwíoqnéna, Sónine awahwá wenáwíq Sémísi subóro aritowara pokatate kiraqme subiq súówe. ");
INSERT INTO awb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Subiq súónsabe Asiu kegá Érótinsabé kaweróne atówe. Kaweróne atówana Érótiga Píta karábúsiipéq móátáhro úwara táhtoqme móátówe. Sótaikú siahreraq ko tánáhráq karábúsiipéq móátówe. ");
INSERT INTO awb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Móátówana Érótiga áhnte sontíá kéyábé wahnahnatíáhro aritowe. Mó sontíá ké itaréitaré ké mipi sorupawe mía mó sontíá ké itaréitaré ké mipi sorupawe míaue 16 sontíá ké míówe. Érótiga iwíáhéna, Sótaikú siahreraq kéh tánáhráq parabagínaraq wehuke míáhpí kotiinie íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iwíáhúwara Píta karábúsiipéq míotaq Sísa tagaríáh kégá Píta pugeq auwageheéra púrerata atauwe. ");
INSERT INTO awb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Érótiga Píta Asiu kebá móatanaútaq Pítaga inokáhpeq karábúsiipéq sugowe. Píta taqnobagineho éra téhtaré séníráté táhrarera sóntía anítárégá ébeq ayéhráq ébeq ayéhrárue wahnahnuyara mó sontíá ánítárégá méhpehtapéq wahnahnatíóyana sugowe. ");
INSERT INTO awb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sugowana Maniká míéhrabeqte ánínká ábóraragútaq karábúsiipéq téhragúwe. Téhragúwana íópeqté ánínká Pítane ahwíraq subiq subirue iriatena wensabé, Apubúue irigúno úwe. Úwana wene ayahpite séníráré megúwe. ");
INSERT INTO awb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Megúwana íópeqté ánínká wensabé, Arene ambanta sábirue úbíqme arene súu sukio úwana Pítaga wene ehweh irena miraúwana, Arene korósi aneranerue íné séniro úwe. ");
INSERT INTO awb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Íné séniro úwana Pítaga we kérena iwíáhéna, Íópeqté ánínká tumeniréhnsábé aiq pútaqpomo peh néniwanka tagehrapómo íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Sóntía anínká wahnahnúrabeq sótaikéra mó sontíá ánínká wahnahnúrabeq sótaikéra wahba áhtápéq séagoyeheéra anotah kahpáh ónsá korabeq suye. Mi onsá pehipi sigúwara sega máhpeq séaguye. Séagéra ahnanahq sótaikuyataq íópeqté ánínká Píta auwena taqnobagúwe. ");
INSERT INTO awb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Taqnobagúwana Pítaga iwíáhéna, Íre néniwanka tagehrana amahnága aiq niahteboge. Érótireq Asiu kereqka nubíyehoéna Manikánka íópeqté ání eqmaréhre. Íné tumenirankeheéna eqmaréhre íwíáhéna ");
INSERT INTO awb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Máhkane anowa Máhríane nahtapeq pokúwe. Máhkawe mó awíq Sónie. Mi nahtápéq áhnte Sísa tagaríáh kégá momiwíue méra púreruwana ");
INSERT INTO awb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pítaga máhpeqte ónsáráq pakobakoúwana ahrari wenáwíq Áróraga onsarapéq tuirowe. ");
INSERT INTO awb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tuirena, Ehweh irari aní Pítae íwíáhéna wene arupipeq eyoyóúwe. Eyoyóúnsabe wega onsa íre siatasa peh nahupeq pehbeheráh kibekue, Píta méhpehtapéq iriwe míéhre teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Teriuwara sega wensabé, Are uwoyansa ani úkóne uwana mi ahrárígá, We míéhre. Peh aiq pútariahnsanuge úwara sega wensabé, Peh íópeqté ání Píta wahnahnatéh ánípómo uwe. ");
INSERT INTO awb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Uwana Pítaga mó pakobakoúwara sega onsa siatera Píta tagéra áhtenuwe. ");
INSERT INTO awb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Áhtenuwana se túbáh agigeheéna Pítaga ayahnka saiqnéna Manikánka karábúsiipéqté tumero ehwéh teriuwe. Teriena sensabé, Sémísireq mó Sísa tagaríáh kéreq koreríéro éna mitaq suena móbeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ahbiahipeq Píta karábúsiipéqté taqnobagúnsabe sóntía kegá, Eheragiro éra sirupipeq iwíáh kikiruwe. ");
INSERT INTO awb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Érótiga sóntía keyábé, Píta koanebahroro úwara koanebahruwe. Anebahruwana Píta íre ábóraq míonsabe Érótiga Píta wahnahnuro sontíá ké ehweh aritena mó sontíá kéyábé, Mi ke subiq súáhro aritowe. Subiq súáhro aritena Érótiga Súría marákórápéq suena Sésáría suwahpeq kowíowe. ");
INSERT INTO awb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Érótiga Táíya suwahpeqte kéreq Sáíróna suwahpeqte kéreqsabé abiahnsanúwe. Abiansanúwara Érótiga wahnahnú marákórápéqté táhútáhúq paiqmaq paiqmaru puara sega weba suwe. Érótine arambehri kené wahnahnú ani wenáwíq Párásátae. Moráráq su kegá wensabé, Érótiga itensabé ahqáho aitehnehboq are itene ehweh mibeq mahbeq aní míahno uwe. Insahwé oneheéra Érótiba suwe. ");
INSERT INTO awb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Érótiga iwíáhú wehekáh wene wahnah awáhríq náneqmarí sukiwena wahnah siáhráq tútuue ména ehweh teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Teriuwara író kega anotah ehwéhnabaéra, Teí ání íre wehukení míre. We Maniká míre uwana ");
INSERT INTO awb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Érótiga, Ahqáho. Íné íre Maniká múge. Peh wehukení múge íre iraria peh ehiya míowe. Minayabe íópeqté ání Maniká míéhrabeqte ánínká apubúue, Awahreúno atowana wene arupipeq awiria sóagúwana putiowe. ");
INSERT INTO awb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Putiowara mó ke suwahpeq mó ke suwahperue áhnte kegá Manikáne ehweh irera Sísansabé aiq pútare átówe. ");
INSERT INTO awb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Páhnábásareq Sorareqka sene mibeqté árámbéhrí parabaruera Máhka mó awíq Sóni meqmera Sarúsarama suwahpeq suera Ántíóka suwahpeq kouwekuye. ");
INSERT INTO awb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ántíóka suwahpeq Sísa tagaríáh ké míórabeq Manikáne ehweh iraru kereq síwáhnoru kereq míówe. Mi anímárí síwíqmé Páhnábása, Símíóni we mó awíq Naisa, Sáíríni marákórápéqté ání Árúsía, Sora, Mánái miraue míówe. Mánáireq anotah wahnáh ání Érótireq animairare míóyataq motakakiah áníté míóye. ");
INSERT INTO awb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sega kawerue púreroneheéra táhutahuq awehriuwe. Mi tanáhráq sega Manikánsabe iwíáh íwíáh atótaq Manikáne Awanka sensabé, Páhnábásareq Sorareqka teriena arámbéhrí miraigehboq eqmaq súáhro úwe. ");
INSERT INTO awb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Úwara sega táhutahuq awehriéra púreréra mi aniténé sinonka táhtoqme púreraritera eqmaq súówe. ");
INSERT INTO awb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Manikáne Awanka siqmarowara Sorareq Páhnábásareqka pokue Sérúsía suwahpeq túye. Mitaq suera sípi kéwewera kure Sáípára marákórápéq pokuye. ");
INSERT INTO awb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pokéra Sárámísi suwahpeq sutaq sega Asiu kené momiwí nahmárítápéq Manikáne ehweh teri terinuyana Máhkaga seba ména séhréh aritowe. Máhkawe mó awíq Sónie. ");
INSERT INTO awb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Sega moke Sáípára marákórápéq nogera Pápósa suwahpeq suwe. Mitaqté ání wenáwíq Páhsísae. We Asiu aní ména ahgora aní míowe. Wega, Íné Manikáne ehweh iraru aní múge úmé péhepehenúwe. ");
INSERT INTO awb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wega Pápósa suwahpeqte wáhnáh áníbá míowe. Mi wahnáhné áwíqtare Ségía Pórásae. We áhnte ahtébíá ání ména Manikáne ehweh irankeheéna Sorararéyábé mahbeq sewéta Manikáne ehweh teníétao úwe. ");
INSERT INTO awb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mi ahgórá ání áwíq mó awíqmé Erimae. Erimaga Sorararéné ehwehme abehq éhwéhne aritowe. Mitaqté wáhnáh ánínká Sísane ehwehnsabé aiq pútare inehoéna wega Sorararéné ehwehnsabé abehq éhwéhne aritowe. ");
INSERT INTO awb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sorawe we mó awíq Porae. Manikáne Awanka we págege atena séhréh atowana wega Erima págegeue ebitáwéna wensabé, ");
INSERT INTO awb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Are owainawane ani móne. Are kaweqtaq méyabe awahrieh aní móne. Are péhe ánímé ahbabáqsabe áwí ání móne. Arega Manikáne ehweh íre tábúsoqme teriasa aeqme síwáhnoróne. ");
INSERT INTO awb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Írátíahno. Manikánka amahnága kamah awinah are aura pira ání míankehe. Áhnte wehekáh téhreh íre tagahrahóne úwana wene aura apubúue pigúwana we íre tagahrahúwe. Íre tagahrahúnsabe mó anínká wene ayahnkaratáq ahmboqme ah sokigi aninkeheéna kabaq kabarúwe. ");
INSERT INTO awb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wahnah anínká mina tagéna Sísane ehwehnsabé áhtenu puana aiq pútare atowe. ");
INSERT INTO awb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Porarehga Pápósa suwahpeq suera sípi kéwewera kure Péríga suwahpeq Pámbíría marákórápéq kuwe. Mitaq Máhkaga Porareh suena wenawahpeq Sarúsarama suwahpeq seuwekúwe. ");
INSERT INTO awb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Seuwekúwara Porarehga Péríga suwahpeq suera Ántíóka suwahpeq Písíría marákórápéq kuwe. Mitaq kéra ahrena ahrena wehekáh Asiu kené momiwí nahtápéq kire tútuue míówe. ");
INSERT INTO awb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tútuue míówara mibeqté wáhnáh kégá Mósísiga sehgíóro ú sehirankákáq Manikáne ehweh iraru kené sehirankakaq sáhnsahera sega Porarehyabe, Itene irupipeq séhréhorahi ehwéh kahnaraqmé teiéro uwe. ");
INSERT INTO awb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Uwana Poraga irigéna se túbáh agigeheéna ayahnka saiqnéna mahraréna, Ísara kereq Manikánsabe áhteno kerero, írátíáhro. ");
INSERT INTO awb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Maniká Iteribo ite Ísara kené Manikáne. Wega itene igaqnaréh omaq sitena séhréhúnsabe sega Ísípi marákórápéq íregáritaq aguwe. Manikánka págegeue séhréh aritena Ísípi marákórápéqté meriqmena móbeq móritowe. ");
INSERT INTO awb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sega 40 opéq abataq marákórápéq míówe. Míówana mi tanáhráq Manikánka se peh áwéragówe. ");
INSERT INTO awb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","We abapete téhtaré Kénáni marákóráq míó kehiná kaqsuowe. Kaqsuo kene marakó itene igaqnaréh eqsitowe. ");
INSERT INTO awb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mi arámbéhrí miraúmé peh íregáritaq opéq 450 opéq sótaikúwe. Sotaikúwana wega ehweh kaweraritageheéna wahnah ke omaq sitowe. Anehe Sáhmúéri wene ehweh irari aní omaq atowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Poraga mó mahraréna, Itene igaqnaréhga Manikánsabe, Íregáritaq wahnáh kéyábé iuwahriehre. Peh morá anotah págege wahnáh ánínká ite wahnahnaitankeheé omaq ato uwe. Uwana Manikánka Pénsámíni kahnáh ání Kisine ahninkáwá wenáwíq Sora omaq atena itene igaqnaréh wahnahnarito atowe. Soraga 40 opéq wahnahnúwe. ");
INSERT INTO awb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wahnahnúwana Manikánka Soransabé, Arega wahnahnurona tanáhráq aiq parabagire éna Tébíti sene anotah wahnáh ání míankeheéna omaq atowe. Omaq atena mahraréna, Sésine ahninkáwá tagaríóge. We niruní ání míre. Wega moke nuwahbeh sánsá mirainkehe úwe. ");
INSERT INTO awb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Manikánka irarúnserah Tébítine anahwagá ite Ísara ke kaweraitankeheéna Manikánka omaq atowana aiq tutaire. Tutai ani wenáwiq Sísae. ");
INSERT INTO awb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sísaga tuina uraitaq Sóniga Ísara keyábé mahraréna, Itene ahbabáq sansa sueq kaweqtaq míéhrataqmé wání meiníe uraire. ");
INSERT INTO awb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sóniga wene arambehri parabaruana uraitaq wega mó mahraréna, Íné inse wíre íwíáhoo? Íné ite áwénunúna anímé íre we úge. Írátíáhro. Íné inehe si aníné súu nahníáq pugereyabe íre awehrari aní múge uraire úwe. ");
INSERT INTO awb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Poraga mó mahraréna, Nánuwahraho, Ébáráhma kahnáhné animárínseq Manikánsabe áhteno kerero, írátíáhro. Itega oga mía míaonayabé mi ehwéh Manikánka aiq teíre. ");
INSERT INTO awb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sarúsarama suwahpeqte kéreq sene wahnah anímárínseqka Sísa tunsabe we íre siahtabarowe. Sega ahrena ahrena wehekáh Manikáne ehweh iraru kené sehira sáhnsahwe taga tagaéra mi ehwéhnsábé íre kawerue iwíáhurowe. Íre kawerue iwíáhéra Manikáne ehweh iraru kegá sehiranunserah sega Sísa ehweh atera subiq suanéhe atówe. ");
INSERT INTO awb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Sega, Sísa áhnte ahbabáruraire íre irarerahéra sega pehipi Páhírátinsabé, Subiq suo ato ue teawátówe. ");
INSERT INTO awb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Manikáne sehiranka irarúnserah sega subiq sutowe. Subiq sutowara awanká soriwe táhparó ani sehgiwera maisé onápípéq mómaisarówe. ");
INSERT INTO awb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mómaisarówana Manikánka iriatena oganúq atáráire. ");
INSERT INTO awb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Oganúq atáráirana Kehrari marákórápéqté Sarúsarama suwahpeq we kétó keba suraire. Surairara sega áhnte wehekáh we taga tagauronsabé sega amahnága mó ke teri terinowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Poraga mó mahraréna, Anotah kawéq éhwéh mahrarue teiune. Manikánka itene igaqnaréhyabe, Kaweraitahna aní iteba eqmaraníe aiq irarúwe. ");
INSERT INTO awb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Eqmaraníe aiq iraréna Sísa iriatena oganúq atáráinsabé wega irarú ehweh aiq pútaraguraire. Itene igaqnaréhne animárínká aiq tagariaraune. Wega iriatena oganúq atáráinsabé Buk Songipeqté éhwéhnká mahraréna, Are nénahni móne. Íné Arenabo uge ire. ");
INSERT INTO awb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Manikánka iriatena oganúq ato puana wene anonka mókake marakóipeq íre karekorahire. Minayabe Manikáne ehwehnka mahraréna, Ínéga Tébíti omasa éhwéh teawúnserah mókake ite kawerarena áhnte kaweq naneq iníe ire. ");
INSERT INTO awb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Manikáne ehweh mó mahraréna, Arega miraónayabé arene arambehri miraéyabe omaq ato aníné anonka íre karekinawire ire. ");
INSERT INTO awb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tébítiga oga mío tanáhráq Manikáne arambehri kawerue miraéna wene arambehri parabaruotaq putiowara itene igaqnaréh maisarórabeq maisarówe. Maisarówana Tébítine anonka kárékúwana ");
INSERT INTO awb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Manikánka iriatena oganúq atárái aníné anonka íre kárékuraire. ");
INSERT INTO awb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Minayabe teiníboq írátíáhro. Sísaga miraurainsabé itene ahbabáq kaqiuwahráhire. ");
INSERT INTO awb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mósísiga sehgíóro ú ehwehnká itene ahbabáq íre kaqiuwahráhire. Sísansabé aiq pútare atonayabé itene ahbabáq moke kaqiuwahráhire úwe. ");
INSERT INTO awb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Poraga mó mahraréna, Naho sáíyó ké tahnsa míyehboq néne ehweh kawerue írátíáhro. Mi keyábé Manikáne ehweh irarú aninká naho sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Íre aiq pútare ainteq peh niwirého keo, tagaríáhro. Ite áhtenéq pukoneheqmóe. Ite míéhra tanáhráq anotah pagégé árámbéhrí mirainauge. Wehukega mi arámbéhrí teiétáq tahirímé itega sensabé íre aiq pútare arítáh irino úwe teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Porane ehweh parabagútaq wereq Páhnábásareqka Asiu kené momiwí nahtápéqté tueyokuye. Tueyokuyara mibeqté kégá sensabé, Mó ahrena ahrena wehekáh arega teiena ehwéh mahtaq mónkakáq sereiyo uwe. ");
INSERT INTO awb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Momiwí nahtápéqté kégá abae agutaq áhnte Asiu kereq Asiu kené sánsá mirau kereqka Porareq Páhnábásareq kérírówe. Kérírówara Porararégá ehweh teriera, Manikánka ite séhréh aitankeheéq wene sánsá kawerue sehgíóro uye. ");
INSERT INTO awb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mó ahrena ahrena wehekáh mi ke suwahpeqte ké peh íregáritaq kegá Manikáne ehweh iraneheéra momiwíuríówe. ");
INSERT INTO awb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sísansabé íre aiq pútare atáh Ásíú kégá áhnte wehekéq momiwíuríówara tagotaq sene sirupipeq págegeéra abiahnsanuwe. Minayabe sega Poransabé awiréh atera, Arega iraréna ehwéh íre aiq pútaq ehwéhne atówe. ");
INSERT INTO awb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Atówara Porareq Páhnábásareqka íre áhreia peh pahsuqme teríúye. Teriera, Itega Asiu ke míáh púata téh itega teiuye. Itega, Manikáne ehwehnsabé iuwahriehre éq oga mérapeqsábé íre iuwahbehnsabé ite iwueta mó ke nahnso ke korerieyéhe. ");
INSERT INTO awb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Manikáne ehwehnka irarinserahnue mahraréna, Nahnso ke sunkíkírirabeq kawerue nogigéhboq kánéq keráhnserahnue itega kaweq ehwéh koreríéro. Mah kehiná kéhíná irageheéna eqmaróge ire uye. ");
INSERT INTO awb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Uyara nahnso kegá mi ehwéh írótaq iwíáh íwíáhéra, Manikáne ehweh aiq kaweq ehwéhne íwíáhuwe. Oga mía míaigeheéna Manikánka omaq sito kega Sísansabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sísansabé aiq pútare ató kega mitaq teri mahtaq terinuwara áhnte mibeqté kégá írówe. ");
INSERT INTO awb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mibeqté Asiu kegá Porararéyábé abiahnsanéra kaweq abóáwáh ínínseq mi ke suwahpeqte ábóáwáh wéhreq eqmaq súówe. Eqmaq súówara sega Porareq Páhnábásareq síwíoqnéra sensuwahpeqte káqsúówara ");
INSERT INTO awb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Porararégá sene sigárátáté tánáhúq aiyápóranirue poruaruóye. Itega aiq teriuyansabé amahnága mirao sansá seyene ahbabáre íwíáhéra sene sigárátáté tánáhúq poruaruera Áíkónía suwahpeq pokuye. ");
INSERT INTO awb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pokuyana Manikáne Awanka mitaq Sísa tagaríáh kéné sirupipeq ména séhréh aritowara sega iwíáh íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Porareq Páhnábásareqka Áíkónía suwahpeq pokuyataq sene sánsánéra Asiu kené momiwí nahtápéq kibekuye. Kibekéra Sísane ehweh tábúsoqme síwáhnoruyansabé áhnte Asiu kereq Káríki kereqka Sísansabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Íre aiq pútare ató Asíú kégá nahnso keyábé, Porararéné ehwehme peh abehq éhwéhne uwara mi nahnsó kégá aiq pútare arító keyabé abiahnsanarítówe. ");
INSERT INTO awb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Porararégá íre wahto tanáhráq mitaq méra íre áhreia Manikáne ehweh síwáhnoruye. Mi ehwéh págegeue síwáhnoruyataq Manikánka sirupipeq págege aritowara sega ótaq sansámárí mirauye. ");
INSERT INTO awb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mi ke suwahpeqte kégá íre morá íwíáhuwe. Mó kegá Porararéné ehweh aiq pútaq ehwéhne íwíáhuwara mó kegá, Írakaumo. Peh Asiu kené sánsá aiq pútaq sansáne uwe. ");
INSERT INTO awb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Asiu kereq nahnso kereq sene wahnahnseqka momiwíéra, Porararé síwíoqnéra ebahnsatate tuparuqme subonéhe íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Iwíáhuwara Porararégá mi ehwéh íróyataq apubúue mitaq suera Áríkíónía marákórápéq Árísáta suwahpeq Tébi suwahpeq pokuye. Mitaqkákáq mó ayéhrápéqté ké suwahpeqkakáq teriáqme nogúye. ");
INSERT INTO awb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mi marákórápéqté ké Sísane kaweq ehwéh teriáqme nogúye. ");
INSERT INTO awb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Peh morá soriqnah ani Árísáta suwahpeq tútuue míowana wenanoga soriqnah ani maqmaronsabe íre nogoráhúwe. ");
INSERT INTO awb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Poraga síwáhnorútaq mi anínká kawerue irowe. Irena, Sísaga íné kaweraintahráhire íwíáhúwana Poraga we ebitáwéna wene iwíáh tagéna anotahtaq teawena, ");
INSERT INTO awb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Irigue nogo úwana wega apubúue iriwe noguwe. ");
INSERT INTO awb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Noguwara mibeqté kégá Poraga miraú tagéra anotah ehwéhnabaéra Áríkíónía marákórápéqté kéné ehweh mahraréra, Manikátaregá wehukeníté úkéra iteba tumíéhye uwe. ");
INSERT INTO awb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tumíéhye éra Páhnábásansabé sene maniká áwíq Súsie ue áwíratówe. Poransabé sene maniká áwíq Érémísie ue áwíratówe. Poraga áhnte ehwéhnúnsabe, We Érémísi tahnsá áníne éra Érémísie ue áwíratówe. ");
INSERT INTO awb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sene maniká Súsinsabé iwíáh íwíáh ató nah sensuwahpeq ahnansahrapeq kowe. Súsine ehweh mibeq mahbeq arítéh ánínká káhoakáq awanká aramarínkákáq ogesáh ogesáhrapeq mewena súwe. Sega, Porareq Páhnábásareqsabé manikátare wóye íwíáhéra titironeherauwe. ");
INSERT INTO awb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Titironehera uwara íre mirao sansá miraonehera unsabé mi kegá túbáh agigeheéra Porararégá sene ambanta subansúóye. Subansuera wehuke míórabeq pehbeheráh pokue anotahtaq ehwehnéra, ");
INSERT INTO awb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Aneqsabé miraoo? Peh ite tahnsá wéhúké míoye. Íre miraoro. Itega kaweq ehwéh teieyeheéta súye. Írátíáhro. Maniká we oga mía míai aní míre. Wega íópeqkákáq mah marákó márákóákáq sóreq wanínkákáq moke kéh náneqmarínkákáq mirarowe. Péhepehe maníkánsábé iwíáh íwíáho sansá sueq Manikánsabe áhraboro. ");
INSERT INTO awb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Naho wehukega seyene mirau sansánuwana Manikánka pehragaritowe. ");
INSERT INTO awb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Íópeqté ibonsúno atéhrana ibonsirana ménsámehnsá kawerue kíréhre. Kawerue kíréhrana iyahbankirehraq itene irupipeq eyoyóire. Minayabe wega ite kaweraitena aiq pútaq míóge éna aiq sokigi aíre uye. ");
INSERT INTO awb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mi ehwéh iraruyara titironehe íwíáhu ke ebeq sene ehweh íre írówe. Íre írówara Porararégá anotahtaq págegeue ahqáho aritoyara mi kegá, Aiq mire. Itene titironehe íwíáh suanehe éra súówe. ");
INSERT INTO awb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ántíóka suwahpeqte Asiu kereq Áíkónía suwahpeqte Asiu kereqka mitaq séra mó ehwéh teríúnsabe mitaqté kégá sene ehweh meyówe. Mewera ebahnsatate tuparuqme Pora subúwana we marakóipeq aunúnkaq surahúwara sega, Aiq putíéhre íwíáhéra abariue ahnansahrapeq márówe. ");
INSERT INTO awb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Márówara Sísa tagaríáh kégá weba sáhuríótaq Poraga irigéna mi ke suwahpeq kouwekúwe. Ahbiah tahnsá Porareq Páhnábásareqka mitaq suera Tébi suwahpeq pokuye. ");
INSERT INTO awb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Sega Sísane kaweq ehwéh Tébi suwahpeqte ké teríúyara áhnte kegá Sísansabé aiq pútare atówe. Aiq pútare atówara Porararégá mitaq suera Árísáta suwahpeqkakáq Áíkónía suwahpeqkakáq Ántíóka suwahpeqkakáq kouwekuye. ");
INSERT INTO awb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kouwekéra Sísa tagaríáh ké págegeue míageheéra síwáhnoruye. Síwáhnoréra, Túbáh agiehboq Sísa kawerue kéráhro éra Sísane ah íre mareqmareq ahne. Ebeq mó kegá íwíoqnehraq anehe Manikánka wahnah wahnahnirabeq pokoneheqmúne uye. ");
INSERT INTO awb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sísa tagaríáh kéráq wahnahnigeheéra Porararégá mó mapéq mó mapérue aboawah weh omaq sitóye. Omaq sitera táhutahuq awehriue mahraue púreréra, Maniká Iteriboo, síósirapéq wahnahnira kegá arensabé aiq pútare atáhwe. Arega se págege arite wahnahnarito ue púreruye. ");
INSERT INTO awb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Porararégá mitaq suera Písíría marákórápéq kotaikue Pámbíría marákórápéq pokuye. ");
INSERT INTO awb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Mitaq Péríga suwahpeq Sísane ehweh teriera suera Átáría suwahpeq pokuye. ");
INSERT INTO awb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mitaq suera sípi kéwewera kure Ántíóka suwahpeq kouwekuye. Mitaqté Sísa tagaríáh kégá eqmaq suanehe íwíáhéra púreruwe. Manikánka Porararé séhréh aritankeheéra púreréra eqmaq súówe. Eqmaq súówara sega Sísane ehweh kawerue teriera sene arambehri parabarúóyansabé Ántíóka suwahpeq seuwekuye. ");
INSERT INTO awb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Seuwekuyataq sega Sísa tagaríáh ké momiwí arítóye. Momiwí aritera Manikánka séhréh arito ehwehnkákáq áhnte nahnsónká Sísansabé aiq pútare ató ehwehnkákáq teríúye. ");
INSERT INTO awb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Teriera sega íre wahto tanáhráq mi ke suwahpeq Sísa tagaríáh kébá mía míauye. ");
INSERT INTO awb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Táhmaro Súría marákórápéqté kégá Ántíóka suwahpeq tuera Sísa tagaríáh ké síwáhnoruwe. Síwáhnoréra, Peh morá Mósísine sánsá sehgíó ké sene síú amurúrúáh kégá oga mérapeq awaq miahráhowe uwe. ");
INSERT INTO awb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Uwara Porareq Páhnábásareqka mi ehwéhnsábé anotah ahqáho arítóye. Minayabe sereq tú kereqka anotah ehwéhuwe. Anotah ehwéhuwara Ántíóka suwahpeqte Sísa tagaríáh kégá Porareq Páhnábásareq táhmaro mó kereq omaq sitera Sarúsarama suwahpeq pokoro arítówe. Sarúsarama suwahpeq Manikánka eqmaro kereq Sísa tagaríáh ábóáwáh wéhreqsabé mi ehwéh tábúsoq marageheéra Porareh pokéwáhro arítówe. ");
INSERT INTO awb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Sísa tagaríáh kégá pokéwáhro arítówara sega Pónísía marákóákáq Sámáría marákóákáq kótaikuwe. Kótaikutaq mitaqté Sísa tagaríáh ké teriera, Nahnso ke Sísansabé aiq pútare atówe ue teríúwe. Teríúwara moke sirupipeq iwíáh íwíáhéra eyoyóuwe. ");
INSERT INTO awb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Porarehga Sarúsarama suwahpeq sutaq mibeqté eqmaro kereq Sísa tagaríáh ábóáwáh wéhreq moke Sísa tagaríáh kéreqka mehweh arítówe. Mehweh arítówara Porarehga Manikánka séhréh aritena moke miraú naneqkakaq teríúwe. ");
INSERT INTO awb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Teríúwara táhmaro Sísansabé aiq pútare ató ke Péhrasi kené sánsá mirao kegá irigéra mahraruwe. Mahraréra, Nahnso kegá oga mérapeq awaq miagéhboq Mósísine áú amurúruto sansá miraoro terio. Mósísiga sehgíóro ú ehweh anterúéhboq kawerue sehgíóro terio uwe. ");
INSERT INTO awb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Eqmaro kereq Sísa tagaríáh ábóáwáh wéhreqka mi ehwéhnsábé iwíáhoneheéra momiwíéra sío síouwana ");
INSERT INTO awb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pítaga irigéna sensabé, Nanuwahraho, ite tagariarome naho nahnso kegá kaweq ehwéh irera aiq pútare atageheéna Manikánka ite míaraunarabeq omaq intáráire. Omaq intena, Korerio aintáráire. ");
INSERT INTO awb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Manikánka wehukene sirupipeq tagaríéhre. Wenawa iteba eqmaq áúwátáinserah nahnso keba moq eqmaq áúwátáire. ");
INSERT INTO awb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wega íre peh morá ite Asiu keyábé arutaboirire. Wega nahnso keyábé moq arutaboirire. Sega Sísansabé aiq pútare atáró puara sene sirupipeq kawerarítáráire. ");
INSERT INTO awb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Aneqsabé Maniká áwíoqnaho? Mósísiga sehgíóro ú ehweh sehgie sansa anotah pagégé sánsáne. Itene igaqnaréhreq itereqka mi sansá íre tábúsoqme sehgioráhúne. Minayabe itega aneqsabé nahnso ke mi pagégé sánsá sehgíóro terieo? ");
INSERT INTO awb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Íre mi sansá sehgiunaga oga mérapeq awaq miahráhúne. Peh morá itereq nahnso kereq Sísansabé aiq pútare atonaga oga mérapeq awaq miahráhúne úwe. ");
INSERT INTO awb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pítaga mi ehwéh irarue parabaruowara Porareq Páhnábásareqka momiwíuríó ke ehweh teríúyara ehiya míówe. Porararégá nahnso ke míópi Manikánka séhréh aritena ótaq sansámárí miraurai ehwéh teríúye. ");
INSERT INTO awb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Teríúyana sene ehweh parabagútaq Sémísiga mahraréna, Nánuwahraho, néne ehweh íráhro. ");
INSERT INTO awb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Manikánka nahnso ke we kahnáh míageheéna omaq sitáráire. Wega téh miraurainsabé Sáímóniga aiq teíre. ");
INSERT INTO awb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Manikáne ehweh iraru kegá minayabe aiq monseráh éhwéh teiúwana Manikáne ehwehnka aiq mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Itene anotah Wahnáhnká mahraréna, Nah sokogi inserah Tébíti kahnáhmé ahbabárowe. Íné kouwekutaq sokogi nah pankeráhnserah íné Tébíti kahnáh kaweraritaníe. Sokogi nah pankeráhwana o nah tahnsa kéhnserah íné we kahnáh kaweraritaníe. ");
INSERT INTO awb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mó kegá íné sene Wahnahnsabé ninebahrigeheéna kaweraritaníe. Ómi ínéga omaq sitó náhnsó kégá ínénsabe ninebahréra iwíáh íwíáh aintagéhe ire. ");
INSERT INTO awb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Naho itene anotah Wahnáhnká áwahewé sína naneq aiq teiuwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Sémísiga mó mahraréna, Íné iwíáhume Manikánsabe áhrabo nahnsó kégá Maniká kéráh sánsá sene sirupipeq umeh agínehboq ahqáho ariteho. ");
INSERT INTO awb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Peh mahrarue páhsi sehiranue terienéhe. Terieq, Péhepehe maníkánsabe iwíáh íwíáhoneheéra titirirataq náíra naneq íre nahro. Mó kené ahrewe ahrariwe wehwe mahbiwe íre abarioro. Wehukenínká awio páríkí náneq ka íre nahro. Korahq íre nahro. Mahraue páhsiipéq sehiranue terienéhe. ");
INSERT INTO awb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mósísine ehweh ahrena ahrena wehekáh Asiu kené momiwí nahmárítápéq ahriahri sáhnsáhówe. Wene ehweh moke mi kehiná suwahpeq síwáhnorowe. Minayabe wene ehweh író kega abiahnsaniyeho éra peh morá teiú náneqmarínsábé awehrioro ue páhsiipéq sehiranue terienéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Eqmaro kereq Sísa tagaríáh ábóáwáh wéhreq moke mó Sísa tagaríáh kéreqka Ántíóka suwahpeqte ké korerigeheéra kaweq ke omaq sitanéhe íwíáhuwe. Sega itebaté téhtaré áníté Sáírásareq Súrása we mó awíq Pásábareq omaq sitowe. ");
INSERT INTO awb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Omaq sitera mi anítéreq Porareq Páhnábásareq mi pahsí siera eqmaq súówe. Páhsiipéqté éhwéhnká mahraréna, Síría marákórápéqté kéreq Sírísía marákórápéqté kéreq Ántíóka suwahpeqte kérero, ite nahnso ke owanawé Sísa tagaríáh púaq iteruwahrah úkowe. Ite eqmaro kereq aboawah wehreqka mah pahsí sehiranue teiune. ");
INSERT INTO awb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ite írátáúnawe menah táhmaro mahtaqté kégá iteba kure íwáhnorurowe. Mi ke íre eqmaq súátáunara peh seyega iwíáhue iteba pokue íwáhnorurowe. Itega sene ehwéh aiq pútaq ehwéhpómo éq iwíáh kikirurowe. ");
INSERT INTO awb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Minayabe itega sío síoéq iteba Porararé moráráq iteba eqmaq súáhna aníté omaq sitone. Porareq Páhnábásareq itene kaweq iyáhnábó áníté méq sensabé irutaboirúne. ");
INSERT INTO awb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Sereq itene Wahnah Sísa Karáhé éhweh terieyeheéra wehuke suboráho ke suwahpeq poku pokuóye. ");
INSERT INTO awb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Mó aníté síwíq Súrásareq Sáírásareq míehye. Sega sehiranu ehwéh moq teigéhe. ");
INSERT INTO awb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Manikáne Awanka iwíáh aitéhraq itega págege sansámárí íre teieq peh mahraue miraoro teiune. ");
INSERT INTO awb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Péhepehe maníkámárínsábé iwíáh íwíáhoneheéra titiré náriu naneq íre nahro. Korahq íre nahro. Wehukenínká awio páríkí náneq ka íre nahro. Mó kené ahrewe ahrariwe wehwe mahbiwe íre abarioro. Itega mahna irarúna ehwéh íréhrataqmé kaweqtaq míagehe. Pehénáe. Mah pahsí aiq parabagire. Iroro uwe. ");
INSERT INTO awb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Eqmaq suowara sega pokue Ántíóka suwahpeq tuera sega Sísa tagaríáh ké momiwí aritera páhsi náríúwe. ");
INSERT INTO awb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Náríúwara sáhnsahera mi pahsíípéqté éhwéhnká sirupipeq eyoyó aritowe. ");
INSERT INTO awb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Súrásareq Sáírásareq Manikáne ehweh iraruya aníté méra Sísa tagaríáh ké págegeue míageheéra sega áhnte ehwéhnue síwáhnoruye. ");
INSERT INTO awb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Síwáhnoréra táhmaro wehekáh mitaq méra seuwekoyehe íwíáhuyara pehwehrue pokéwáhtao éra eqmaq súówe.  ");
INSERT INTO awb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sáírásaga mó iwíáhéna íre pokia peh mitaq míowe. ");
INSERT INTO awb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Porareq Páhnábásareqka Ántíóka suwahpeq kauye. Sereq áhnte mó kereqka Sísane ehweh teriera síwáhnoruwe. ");
INSERT INTO awb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Táhmaro wehekáh sótaikútaq Poraga Páhnábásansabé, Sísane ehweh síwáhnorurauya ke suwahpeqtaq seuwekoyehe. Sísa tagaríáh ké kaweqtaq míahwapómo moke sensuwahpeq koragayehe úwe. ");
INSERT INTO awb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Úwana Páhnábásaga, Sóni we mó awíq Máhkaga sénirahnata pokoyehe úwe. ");
INSERT INTO awb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Úwana Poraga ahqáho atena, Itega Pámbíría marákórápéq pokurauyataq Máhkaga mitaq ite iuwena tabanaguraire. Mi tanáhráq wene arambehri íre parabarusa pehipi taqnobagurainsabé wega mó íre séirankéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mira íwíáhuyansabé sega ehwehuye. Minayabe Páhnábásaga Pora auwena Máhka meqmena sípi kéwewena Sáípára marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pokúwana Poraga Sáírása omaq atowara Sísa tagaríáh kégá monseráh íwíáhéra, Pokéwáhtao éra mahrarue púreruwe. Púreréra, Maniká Iteriboo, arega mah anítéyábé arutaboiróna puah kawerue págege arite séhréh arito uwe. ");
INSERT INTO awb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Uwara Porareq Sáírásareqka pokue Síría marákóákáq Sírísía marákóákáq Sísa tagaríáh ké momiwíurabeq págege aritayeheéra síwáhnoruye. ");
INSERT INTO awb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Porararégá Tébi suwahpeq kótaikéra Árísáta suwahpeq suyana mibeqté Sísa tagaríéh ání wenáwíq Tímóti míowe. Wenano Sísa tagaríéh Asiu iní míowana wenabo Káríki aní míowe. ");
INSERT INTO awb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Árísáta suwahpeqte Sísa tagaríáh kégá Tímóti kaweq aníne uwara Áíkónía suwahpeqte Sísa tagaríáh kéreqka moq monseráh íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Poraga iwíáhéna, Tímóti ite séirankéhe íwíáhúwe. Ómi mibeqté Asiu kegá tagaríómé Tímótine abowá peh Káríki aní míowe. Káríki aní mío púana Poraga iwíáhéna, Tímóti ite séireyabe Asiu kegá abiahnsa aitého éna Tímóti meqmena wene áú amurú auwowe. ");
INSERT INTO awb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Porareq Sáírásareq Tímótireqka mó ke suwahpeq mó ke suwahperue pokue Sísa tagaríáh ké síwáhnoruwe. Síwáhnoréra Sarúsarama suwahpeqte eqmaro kereq Sísa tagaríáh ábóáwáh wéhreqne páhsi teri terinuwe. Teriera, Mah ehwéh kawerue iwíáhéq sehgíóro uwe. ");
INSERT INTO awb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Minayabe Sísa tagaríáh kégá Sísane sánsá kawerue ahtebéra sehgíówe. Mó wehekáh mó wehekáhnue mó kegá Sísansabé aiq pútare atera Sísane sánsá sehgíówe. ");
INSERT INTO awb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Porarehga, Itega Esia marákórápéq Sísa éhweh korerienéhe íwíáhuwana Manikáne Awanka ahqáho aritowe. Ahqáho aritowara sega Párígía marákóákáq Kárétía marákóákáq kótaikuwe. ");
INSERT INTO awb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kótaikéra Mísía marákórápéq wahtotaq kéra, Pítínía marákórápéq Sísa éhweh korerienéhe íwíáhuwe. Iwíáhuwana Sísane Awanka mó ahqáho aritowara ");
INSERT INTO awb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mísía marákórápéq kótaikuwe. Kótaikéra Tóása suwahpeq sóreq waní ayehrápéq túwe. ");
INSERT INTO awb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mitaq inokáhpeq Porane awanka tagówana Másérónía marákórápéqté ánínká ábóraragúwe. Ábóraragéna iriwe ména Poransabé, Másérónía marákórápéq séhréh aitagéhboq máhoro éna pahibahirúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Porane awanka tagónsabe itega iwíáhowame Manikánka mitaq Sísa éhweh koreríéro aitéhre. Aiq teiátáinsabé ireq ite Másérónía marákórápéq pokoneheqmúne íwíáhéq apubúue sokah sokahowane. ");
INSERT INTO awb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Itega Tóása suwahpeq sueq sípi kéweweq Sámótési marákórápéq pokowane. Mitaq séq mó wehekáh sueq sípi kéweweq Néápórísi suwahpeq kowane. ");
INSERT INTO awb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mitaq sípi sueq Pírípái suwahpeq kiowáne. Aroma kegá Pírípái suwahpeq téh nah aborisowe. Mitaq anotah matábú kéna moke Másérónía marákórápéqté mátábú kiotaiqme matabu kowe. Itega táhmaro wehekáh mitaq kowíahwane. ");
INSERT INTO awb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ahrena ahrena wehekáh itega ahnansahrapeq wání aroipéq pokowane. Ite iwíáhowanawe, Mahtaq ibora wehukega púrerowe íwíáhéq tunse áhnopeq tútuue míahwane. Mibeqté momiwíuríó ininsó Sísa éhweh teriewáne. ");
INSERT INTO awb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Peh morá íní wenáwíq Áríríaga itene ehweh irena we Táíyátáíra suwahpeqte íní ména wene arambehriwe tautáúq ámbántámárí paiqmaq paiqmarúwe. We Manikánsabe iwíáh íwíáh ato iníne. Poraga ehweh irarútaq we kawerue irankeheéna Manikánka mi iní séhréh atowe. ");
INSERT INTO awb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Séhréh atowana irowaq itega wereq wene nahtapeq kaegaeu kereq wání meriewáne. Meriewánana mi inínká itensabé, Íné Sísansabé aiq pútare atóge íwíáhirataq néne nahtapeq segaegaeoro úwe. Segaegaeoro únsabe itega wene nahtapeq kogaegaeowane. ");
INSERT INTO awb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Itega wehuke púrerorabeq pokowanaraq mó kené arambehri ahráríreq ahtapeq piehgiowáne. Wene arupipeq mío owáínáwánká mókake aiq pútaragína ehwéh iwíáh atowana mi ahrárígá irarúwe. Irarúnsabe mó kegá móne náwa náwanuwana wene wahnah anímárí nári nárinúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wega Porareq itereq séirena sawai sawaiéna, Mah kewé Manikáne arambehri ke wóe. Manikámé anotah págege aní míre. Sega Manikáne oga mía mía ehwéh teri terinowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Áhnte wehekáh mi ahrárígá ite séirena mi ehwéh irare irareúwe. Minayabe Poraga iwíáh kikiréna wega pabeqme owainawansabé, Sísa Karáhé áhrabu puah mi ahrárí auwe pokúno atoge úwe. Úwana mi tanáhráq owainawanka mi ahrárí apubúue auwena pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mi ahráríné wahnahmarínká iwíáhéra, Owainawa kaqauwéhrana poki puaq ite mókake mó moné íre meyahráhune éra abiahnsanuwe. Abiahnsanéra sega Porareq Sáírásareq táhtoqme abariuera mi ke suwahpeqte wáhnáhmárípá máhkétirapéq mórítówe. ");
INSERT INTO awb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Móritera wahnah keyábé, Mi aníté Asiu aníté méra iteruwahpeq ahbabáq sansanóye. Seyene sánsá miraoro éyame íre kaweróye. ");
INSERT INTO awb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ite Aroma ke míona puaq sene sánsá íre miraúna sansáne uwe. ");
INSERT INTO awb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Uwara mitaq momiwíu kereqka ehweh arítówara wahnah kegá Porararéné korósi keqsúówe. Keqsuera, Morahri sahtáté subóro arítówara subúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Anotahtaq subera karábúsiipéq móritera mibeqté wáhnáhnsábé, Kawerue wahnahnúno atówe. ");
INSERT INTO awb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kawerue wahnahnúno atówana wega se meriqmena karábúsi nahtápéq ákáhpite máhrípípéq móritowe. Móritera sene sigárátáré awanká abahrabahriapipéq sukiwe táhparówe. ");
INSERT INTO awb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Táhparówara inokáhnabubu Porareq Sáírásareqka púreréra igonkónéra Manikánsabe iwíáh íwíáh atóyara mó karábúsíípéq míó kega tótuqméra írówe. ");
INSERT INTO awb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Írówana anotah maríúwana karábúsi nah míu míuúwana moke onsawárí apubúue pehipi siraragúwe. Siraragúwana ómi karábúsi kené séniwarí wewega pugetara agúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Karábúsi wahnáhnká sugorabeqte irigéna onsawárí siraragú tagówe. Tagéna, Karábúsi ke moke taqnobagowe íwíáhúwe. Mira íwíáhú púana wene poka mewena apubúue pukinieéna néne ninonka sehsabianíe íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Sehsabianaútaq Poraga anotahtaq áhrabéna, Arene anonka sehsabíéhnehboq túbáh agúno. Íte moke míone úwe. ");
INSERT INTO awb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Úwana karábúsi wahnáhnká wene arambehri anínsábé, Kánéq keqme súno éna pehbeheráh karábúsiipéq kibekúwe. Kibekéna áhreú púana Porararéné paqnahipeq pokue iransánéna arehunseraráq míowe. ");
INSERT INTO awb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wega Porararé máhpeq márunsitena sensabé, Árahonaga oga mía míaininkono ue kasenúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kasenúwara sega wensabé, Sísansabé aiq pútare atéhnaraqmé oga mía míainkehe. Arenawahrahreq moq oga mía míaigehe uye. ");
INSERT INTO awb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Porararégá wereq wene nahtapeq kaegaeu kereqsabé itene Wahnah Sísa éhweh teríúye. ");
INSERT INTO awb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Teríúyana mi tanáhráq karábúsiipéqté wáhnáh Porararé meriqmena puramburanagú pabeq paberaritowe. Pabeq paberaritowara Porararégá wereq wene kárironanínseq wání náríúye. ");
INSERT INTO awb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wání náríúyana mi wahnáhnká Porararé wene nahupeq meriqmena táhutahuq náriuwe. Wereq wene kárironanínseqka Sísansabé aiq pútare atónsabe sene sirupipeq eyoyóúwe. ");
INSERT INTO awb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ahbiahipeq mi ke suwahpeqte wáhnáhmárínká párísireh síáhrabéra sensabé, Karábúsiipéq mórítáró aníté pugeq suo koreawéro uwe. ");
INSERT INTO awb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Koreawéro uwara karábúsiipéqté wáhnáh koreawúwana Pora mi ehwéh teawuwe. Teawena wensabé, Wahnah kegá siqmaráh párísíwárínká, Ite pageqsuo aiq teníéwe. Minayabe tueyokue pehwehrue pokéwáhtao úwe. ");
INSERT INTO awb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Úwana Poraga párísiwarínsábé, Ite íre peh Asiu anité úye. Ite moq Aroma marákórápéqté áníté úye. Sega íre tábúsoqme ehwéh aitasa pehipi iubiq marera karábúsiipéq móítárówe. Sega amahnága kopípéq kaqiuwagéhbo? Ahqáho. Seyega séra ite pugeqme máhpeq iuwagéhe uye. ");
INSERT INTO awb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Uyara párísiwarínká wahnah keba kouwekue mi ehwéh teríúwe. Teríúwara wahnah kegá ite Aroma marákórápéqté áníté úya ehwéh írónsabe áhreuwe. ");
INSERT INTO awb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Áhreéra Porararébá sure sensabé, Ite Aroma marákórápéqté áníté míehyame íre írátíaraune. Minayabe íre kaweruraune éra máhpeq márunsitera sensabé, Mahtaq sueta pokotao uwe. ");
INSERT INTO awb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Uwara Porararégá karábúsiipéq suera Áríríane nahtapeq pokuye. Pokéra mitaq Sísa tagaríáh kéyábé kaweq ehwéh iraréra sensabé, Sísane sánsá kawerue sehgíóro aritera pokuye. ");
INSERT INTO awb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Porarehga pokue Ámbípóri suwahpeq sótaikéra Ápórónía suwahpeq sótaikéra Tésárónáíka suwahpeq kéra mitaq Asiu kené momiwí nahtápéq kuwe. ");
INSERT INTO awb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ahrena ahrena wehekáh Poraga wene sánsánéna mi nahpípéq kibekue síwáhnorúwe. Asiu kené ahrené wehekáh apahtáró áhréná áhréná wéhékáh kibekue Manikáne púkuipéqté séhírá síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Síwáhnoréna, Mó kegá Manikánka omaq ato aní áwíoqnéra subiq sutowana pukéna mó oga úkuraire. Manikáne ehwehnka minayabe aiq irarire. Manikánka omaq ato anímé íné teiú ání wenáwíq Sísa wire úwe. ");
INSERT INTO awb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Úwara táhmaro Asiu kegá mi ehwéhnsábé aiq pútare atera Porareq Sáírásareq kobaritawe míówe. Manikánsabe áhteno Káríkí kéreq áhnte aboawah inínsónseqka moq kobaritawe míówe. ");
INSERT INTO awb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Minayabe íre aiq pútare ató Asiu kegá abiahnsanuwe. Abiahnsanéra ahbabáq ke pehipi máhkétirapéq nogó ké meriqmera momiwíue anotahtaq ehwehuwe. Porararé wehuke momiwíurabeq móritankeheéra wehukení wenáwíq Sésónine nahtapeq pehbeheráhnue pokuwe. Pokue wene nahtapeqté ónsá subiqme sueruera Porararéyábé sinebahruwara íre míóye. ");
INSERT INTO awb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Íre míóyansabé sega Sésónireq mó Sísa tagaríáh kéreq abariuera mi ke suwahpeqte wáhnáh kébá mórítówe. Móritera ehwehéra, Moke mah nahnsó ke ahbabárarítóya anítégá suroyataq ");
INSERT INTO awb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Sésóniga wene nahtapeq mehweh aritowe. Mi anítégá itene anotah wahnáh ání Sísáhrine sánsá íre mirauroye. Íre miraia peh iraréra, Mó Wahnáh ání Sísae iraruye uwe. ");
INSERT INTO awb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Uwara mi ke suwahpeqte kéreq sene wahnah kereqka mi ehwéh írótaq kurináhnéra abiahnsanuwe. ");
INSERT INTO awb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Sega Sésónirehyabe, Kotiyabé ite móne paiqmáráhro éra sene móne mewera kaqsúówe. ");
INSERT INTO awb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Íó penkúwara mibeqté Sísa tagaríáh kégá Porareq Sáírásareq Péría suwahpeq eqmaq súówe. Eqmaq súówara Péría suwahpeq suyataq Asiu kené momiwí nahtápéq kibekéra síwáhnoruye. ");
INSERT INTO awb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Síwáhnoruyara mibeqté Asiu kegá irera Manikáne ehwehnsabé kawerue iwíáhue tagowe. Sene iwíáhgá Tésárónáíka suwahpeqte kéné iwíáh kiotaikúwe. Sega Porane ehweh írótaq sirupipeq eyoyóue Manikáne sehira mó wehekáh mó wehekáhnue sáhnsahwe iwíáhue tagéra, Porane ehweh aiq pútaqpomo éra iwíáhue tagowe. ");
INSERT INTO awb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Minayabe áhnte Asiu kegá aiq pútare atówe. Sereq mó áhnte ke, Káríki anotah weh áhrégá moq aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Poraga Manikáne ehweh Péría suwahpeqkakáq teríre uwara Tésárónáíka suwahpeqte Asiu kegá írówe. Irera Péría suwahpeq séra mibeqté kéyábé, Porane ehwehnsabé aiq pútare atehboq íre íráhro ue pagu pagunuwe. ");
INSERT INTO awb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pagu pagunuwara mibeqté Sísa tagaríáh kégá Pora apubúue sóreq waní ayehrápéq eqmaq áúwówe. Eqmaq áúwówara Sáírásareq Tímótireqka peh mitaq míóye. ");
INSERT INTO awb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Míóyara ah tagaríáh kégá Pora meqmera Áténi suwahpeq márunátówe. Márunátówana wega sensabé, Sáírásareq Tímótireqsabé, Peheráh setao teríéro úwara pokuwe. ");
INSERT INTO awb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Poraga Áténi suwahpeq síwénunútaq mibeqté kégá áhnte péhepehe maníkáne atah naneq kowana tagéna wene arupipeq págege agúwe. ");
INSERT INTO awb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Minayabe Poraga Asiu kené momiwí nahtápéqté kéreq Manikánsabe iwíáh íwíáh ató kereqsabé ehwehnuwe. Máhkétirapéq mó wehekáh mó wehekáhnue su kereq moq ehwehnuwe. ");
INSERT INTO awb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Táhmaro mibeqté síwáhnoru kegá Porareq piehgiera áhnte ehwéh kíkírue ehwehnuwe. Mibeqté su kegá táhmaro Épíkúríane sánsá ahtebowara mó tahmáró kégá Sítóíkine sánsá ahtebowe. Táhmaro kegá seye náhenéra, Áhnte ehwéhnkákáq ání aneq ehwéhnkákáq ánípo uwe. Poraga Sísa oga úkú ehweh teriunsabe mó kegá, We wáhnaupéqté máníkámárí éhweh tei teinire uwe. ");
INSERT INTO awb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Sega Pora meqmera Áréópágúsa sawéhráq ahtebia kégá momiwíurabeq móátówe. Móatera wensabé, Arega síwáhnoróna ehwéh peh o ehwéh míre. Mi ehwéh teio. ");
INSERT INTO awb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Arega iraréna ehwéh áwánáh éhwéh míre. Mi ehwéhmé áwahe ahtebanehboq kawerue teio uwe. ");
INSERT INTO awb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Áténi suwahpeqte kéreq mibeq wáhnaupéqté sewíó kereqka ahriahri o ehwéh irera mi ehwéhnsábé irare irareuwe. Seyene sánsáne. ");
INSERT INTO awb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Poraga Áréópágúsa sawéhráq ahtebia kégá momiwíurabeq iriwe ména mahraréna, Áténi suwahpeqte wého, ínéga iwíáhume itene manikámarinsabé áhnte iwíáh íwíáho ke wóe. ");
INSERT INTO awb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Iteruwahpeq nogewótáq itega iwíáh íwíáhorabeq tagéwómé peh morá táhbérápéq kéh séhírámé sáhnsahwe tagéwóge. Mi sehiránká mahraréna, Mah tahbé íre tagariona manikáné tahbe wire ire. Itega íre tagarawéq pehipi iwíáh íwíáh atáhnsábé minawé teiúge. ");
INSERT INTO awb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Teiúge éna mó mahraréna, Manikánka moke mah marákó márákóípéq kéh náneqkakáq mah marákó márákóákáq mirarowe. We mah marákó márákóákáq íópeqkákáq wahnahnatíéh ání míre. Minayabe wega wehukega pearáh náhúpéq íre kaegaei aní míre. ");
INSERT INTO awb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","We íre akahrákáhri aní míre. Wewega moke wehukene irupipeqté éúqkákáq moke kéh náneqkakáq nái náinire. Minayabe wehukega we íre séhréh atáhráhowe. ");
INSERT INTO awb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mah kehiná kéhínáné igaqna peh morá áníne. Manikánka mi aní téh mirarena itene ogamé tanahráq iwíáh aitéhre. Mah marákó márákórápéq mó kehiná mó kehinánsábé, Míáhro aitéhre. ");
INSERT INTO awb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Itega Manikánsabe kabarigeheéna mira íwíáh aitéhre. We tagarianeheéq kabarúne. Ite ómi kehiná míonarabeq we wahtotaq míéhre. ");
INSERT INTO awb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Maniká ména mira aruqaruri puaq itega oga míahrahúne. Iteba sehira tagaríéh ánínká aiq mahraréna, Ite moke wene animáríne ire. ");
INSERT INTO awb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ite Manikáne animárí míona puaq we peh wehukega iwíáhue mirao naneq mire íwíáhiyeho. We íre ebahtaté miraia aníne. We íre móneraté miraia áníne. ");
INSERT INTO awb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Naho wehukega Maniká íre tagaríówe. We íre tagariarera, We peh wehukega iwíáhue mirao naneq mire íwíáhuwe. Mi tanáhráq Manikánka mi kewé peh áwé tagówe. Amahnága wega mah kehiná kéhínánsábé, Itene ahbabáq sansa súáhro ire. ");
INSERT INTO awb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Manikánka peh morá ání omaq atena wega iwíáhína tanáhráq mi anínká mah kehiná kéhíná tábúsoqme ehweh aritankéhe. Minayabe mah kehiná kéhínánká tagariageheéna Manikánka mi aní iriatena oganúq atáráire úwe. ");
INSERT INTO awb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Míó kega oganúq atárái ehwéh írówe. Táhmaro kegá awiréh atówara mó kegá Poransabé, Arene ehweh mókake mónkakáq iranéhe uwe. ");
INSERT INTO awb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Uwana Poraga mitaq suena pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pokúwara táhmaro wehwárínká we kerera wene ehwehnsabé aiq pútare atówe. Peh morá ání aiq pútare ato aní wenáwíq Tíónísíae. Wereq mó ahtebia kéreq Áréópágúsa sawéhráq momiwíue aruqaruruwe. Peh morá íní wenáwíq Támárísae. Wereq mó kereqka Pora kerera wene ehwehnsabé aiq pútare atówe. ");
INSERT INTO awb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Poraga Áténi suwahpeq suena Kórína suwahpeq pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Póntúsa marákórápéqté ání wenáwíq Ákúíra míowana wene ahre awíq Párísírae. Se Asiu akéq menah Ítári marákórápéq míóyana mibeqté wáhnáh áníné áwíqtare Káróríúsa Sísáhrie. Mi wahnáhnká moke Aroma suwahpeq míó Asiu keyábé, Pokoro aritena kaqsuowara Ákúíra akéqká Aroma suwahpeq suera Kórína suwahpeq kowíóye. Poraga mitaq se tagéna sene iyahnabo aní úkúwe. ");
INSERT INTO awb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Wereq sereq peh morá árámbéhríuwe. Sene arambehriwe wéhuwehu nahmárí piageheéra sériwarí kogahnue kawerarówe. Wereq sereqne arambehri peh monseráh púana seba kobaritawe míowe. Wereq sereqka moráráq arambehriuwe. ");
INSERT INTO awb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Moke ahrena ahrena wehekáh Poraga Asiu kené momiwí nahtápéq Asiu kereq Káríki kereqsabé Sísa éhweh terinieéna poku pokuúwe. ");
INSERT INTO awb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sáírásareq Tímótireqka Másérónía marákórápéq suera Pora míorabeq suye. Sega suyataq Poraga Manikáne ehweh Asiu ke teri terinéna, Manikánka omaq ato anímé Sísae úwe. ");
INSERT INTO awb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Úwara író kega mi ehwéhnsábé ahqáho atera íre kaweq ehwéh atówana wega sensabé, Aiq mire. Ínéga aiq teiúge éna wene ambanta suruparuena teriuwe. Itega iraipéq pokirame iteitene irupipeqté íwíáhgáe. Íné aiq pútaq ehwéh aiq teiúge. Itega ahqáho aintáhnsábé nahnso ke korerinauge úwe. ");
INSERT INTO awb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Manikánsabe iwíáh íwíáh ato aní wenáwíqtare Títía Sásátae. Wene nah Asiu kené momiwí nahtápéq wahtotaruwana Poraga momiwí nahtápéq suena mi aníné nahtapeq kowíowe. ");
INSERT INTO awb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Asiu kené momiwí nahtápéqté wáhnáh ání wenáwíq Kárísápae. Wereq mi karírónánínseqka Sísansabé aiq pútare atówe. Áhnte mó Kórína suwahpeqte kégá Porane ehweh irera aiq pútare atera wání meyówe. ");
INSERT INTO awb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Inokáhpeq Porane awanka tagówana Sísaga wensabé, Íre áhreúno. Túbáh aginehboq néne ehweh pahsuo. ");
INSERT INTO awb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ínéga areba míó púara mó kegá are íre subigéhe. Kórína suwahpeqte kéwé áhnte kegá ínénsabe aiq pútare aintagéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Minayabe Poraga Kórína suwahpeq peh morá ópéq mó opéq ákáhtaq ména Manikáne ehweh síwáhnorúwe. ");
INSERT INTO awb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wehukení wenáwíq Káríoe. We Ákáía marákórápéqté wáhnáh míotaq Asiu kegá momiwíéra Pora táhtoqme ehwehurabeq móátówe. ");
INSERT INTO awb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Sega Káríonsabe, Mah anínká itega Manikánsabe iwíáh íwíáh atona sansá sueq mó sansánoro tei teinire úwe. Wega o teí sánsámé Mósísiga íre miraoro ú sansáne uwe. ");
INSERT INTO awb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Uwana Poraga ehweh irarinaútaq Káríoga Asiu keyábé mahraréna, Asiu keo, mi anínká ahkaragáraéna anotah ahbábáritaq tahirímé ínégá itene ehweh kawerue író irino. ");
INSERT INTO awb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Peh iteitene ehwehnkakáq wehukene síwíqkakaqsabé iteitene sánsánkákáqsábé iteitega iwíáhue miraoro. Íre néne arambehri puana túbáh aginauge éna ");
INSERT INTO awb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","se moke ehwehurabeqte kaqsúáhro aritowe. ");
INSERT INTO awb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kaqsúáhro aritowara Asiu kené momiwíurabeqte náhtápéqté wáhnáh wenáwíq Sósáténi táhtoqme máhpeq subúwe. Subútaq Káríoga se peh áwé tagowe. ");
INSERT INTO awb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Poraga Kórína suwahpeq áhnte mó wehekáh ména Sénkáría suwahpeq pokúwana wene ayahra káúqauwowe. Pehipi íre káúqauwowana Asiu kené sánsánéna Poraga Manikánsabe ehweh teawunsabe káúqauwowe. Káúqauwowana Sísa tagaríáh ké mitaq suena Párísírareq wenawehq Ákúírareq meriqmena sípi kéwewena Síría marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Sega sípi kéwewera Épésa suwahpeq kuwe. Mitaq Poraga Párísírareq Ákúírareq suena Asiu kené momiwí nahtápéq kibekéna wereq Asiu kereqka ehwehnuwe. ");
INSERT INTO awb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mi kegá Poransabé, Mahtaq míahno uwana ahqáho éna ");
INSERT INTO awb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Épésa sensuwahpeq suanieútaq sensabé, Manikánka kouwekúno íwíáh aintahnaraq kouwekinie úwe. Kouwekinie éna Épésa suwahpeq suena sípi kéwewena pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sípiga Sésáría suwahpeq sútaq Poraga sípi suena kire Sísa tagaríáh ké mehweh aritanieéna Sarúsarama suwahpeq kiuwe. Mehweh aritena Sarúsarama suena Ántíóka suwahpeq tuwe. ");
INSERT INTO awb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Táhmaro ió Ántíóka suwahpeq ména mitaq suena pokúwe. Wega Sísa tagaríáh kéné sirupipeq kaweq iwíáh aritanieéna Kárétía marákóákáq Párígía marákóákáq mó mapéq mó mapérue nogena pokue teríáqme noguwe. ");
INSERT INTO awb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Peh morá ání, Árékásántáría suwahpeqte ánínká Épésa suwahpeq séna wenáwíq Ápóroe. We Manikáne sehira ahtebia ání ména kawerue teri terinú ani míowe. ");
INSERT INTO awb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mó kegá we Manikáne sansá áwáhnoruwana wega mó ke págegeue síwáhnorúwe. Peh morá Sísa éhweh ákáhtaq ahtebéna tábúsoqme teri terinéna Sóniga wání meriu ehweh moke ahtebówe. ");
INSERT INTO awb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Épésa suwahpeq Asiu kené momiwí nahtápéq págegeue síwáhnorúwe. Wega síwáhnorútaq Párísírareq Ákúírareqka wene ehweh irera móbeq meqmera we íre ahtebó ehweh, Manikáne sansá tábúsoqme áwáhnoruye. ");
INSERT INTO awb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ápóroga, Íné Ákáía marákórápéqté ké kosíwáhnorinie íwíáhúwara Épésa suwahpeq Sísa tagaríáh kégá wensabé, Kaweróne. Kosíwáhnorúno éra mibeqté Sísa tagaríáh kégá we mehweh atageheéra páhsi sehiranue áwúwe. Manikánka áhnte Ákáía marákórápéqté ké séhréh aritowara Sísansabé aiq pútare atówe. Anehe Ápóroga mitaq séna mi ke anotahtaq séhréh aritowe. ");
INSERT INTO awb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wega Manikáne sehira sáhnsahena, Manikánka omaq ato anímé Sísae teriuwe. Wehuke míópi págegeue teri terinúnsabe wene ehweh Asiu kené ehweh kiotaikúwe. Minayabe wega Sísansabé aiq pútare atáh ké anotahtaq séhréh aritowe. ");
INSERT INTO awb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ápóro Kórína marákórápéq míotaq Poraga sáwéhrapeq kótaikéna Épésa suwahpeq tuwara táhmaro Sísa tagaríáh ké míówe. ");
INSERT INTO awb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Míówana Poraga sensabé, Itega Sísansabé aiq pútare atárótaq Manikáne Awanka itene irupipeq aiq tutairo ue kasenúwe. Kasenúwara sega wensabé, Ahqáho. Manikáne Awa éhweh íre írátáúne uwana ");
INSERT INTO awb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Poraga sensabé, Aneq waní meroo ue kasenúwe. Kasenúwara sega wensabé, Sóniga wání meríátáinserah mó kegá mina tahnsa wání meraune uwe. ");
INSERT INTO awb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Uwana Poraga sensabé, Sene ahbabáq sansa sutonsabé Sóniga wání meríátáire. Meriena mahraréna, Inehe sína anínsábé aiq pútare atáhro. Wenáwíq Sísae uraire úwe. Sóniga irarú ehweh Poraga teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Teriuwara írówana itene Wahnah Sísa áwírue wání náriuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Poraga sensinetaba wene ayahnkaratáté táhtorotaq Manikáne Awanka sene sirupipeq tuwara sega kambare ehwéh iraréra Manikáne Awanka iwíáh arito ehweh iraruwe. ");
INSERT INTO awb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mirau kewé airápété téhranítée. ");
INSERT INTO awb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Poraga Asiu kené momiwí nahtápéq kibekéna Manikánka wahnah wahnahnirabeqte éhwéh págegeue teriuwe. Teriuwara Asiu kegá wene ehwehnsabé áhntetaq kasenéra iwíáhuwe. Iwíáhuwana apahtáró íótáq miraúwara ");
INSERT INTO awb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","táhmaro író kega wene ehwehnsabé íre aiq pútare atera saiyouwe. Saiyoéra momiwíurabeq Sísane sánsánsábé íre kaweq ehwéh atówana Poraga se suena Sísansabé aiq pútare atáh ké meriqmena pokúwe. Sigarurapéqté wáhnáh ání wenáwíq Tíránásae. Poraga Sísansabé aiq pútare atáh ké meriqmena Tíránásane sigaru nahpípéq mó wehekáh mó wehekáhnue síwáhnoréna ehwehnúwe. ");
INSERT INTO awb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Poraga téhtaré ópéq mi sigárúráq síwáhnorúwara moke Esia marákórápéqté Asiu kereq Káríki kereqka Manikáne ehweh írówe. ");
INSERT INTO awb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Manikánka págegeue séhréh atowana Poraga anotah otáq sánsámárí miraúwe. ");
INSERT INTO awb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Minayabe mó kegá Poraga táhtoro ambántámárí meyówe. Mi ambántámárí awahre kebá móríúwara sene suwahre kaweragúwara owainawamarínká se suera pokuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Táhmaro Asiu ahgórá kéwé nahnso suwahpeqtaq kégaeyaq tuegaeyaréu anímárí méra owainawa kaqsuq kaqsurowe. Mi kegá itene Wahnah Sísa áwírue owainawamarí kaqsuanéhe íwíáhéra Poraga kaqsuonserah itega moq kaqsuanéhe íwíáhuwe. Minayabe sega mahraréra, Owainawano, Poraga teri terini aní, Sísa áwírue wehukení auwe pokúno teawune uwe. ");
INSERT INTO awb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Abapete téhtaré Asiu anímárínká owainawamarínsábé mina tahnsa éhwéhnuwe. Manikáne ehweh mibeq mahbeq arítéh ání wenáwíq Síkéba sibowá míowe. Wene anahwaréhga mó wehékáh mi ehwéhnuwana ");
INSERT INTO awb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","owainawanka sensabé, Sísa aiq tagaríóge. Pora moq aiq tagaríóge. Itewe inseréhbo úwe. ");
INSERT INTO awb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Úwana owainawa wene arupipeq mío anínká seba ahkuagéna sene korósi moke subansuena subiqmaq subiqmarúwara korahq tabagu tabaguúwara se pehrákora méra nahupeq suera máhpeq pehbeheráhnue pokuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Asiu kereq Káríki kereq peh moke Épésa suwahpeqte kéreqka mi ehwéh irera áhtenuwe. Minayabe mi kegá itene Wahnah Sísa áwíq pankerera iwíáh íwíáh atowe. ");
INSERT INTO awb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mi tanáhráq áhnte Sísa tagaríáh kégá sure sene ahbabáq sansa pahsuqme teríúwe. ");
INSERT INTO awb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ahgora tagaríó kega sene ahbabáq pukúwárí mewera ómi wehukega tagaríótaq ira paríówe. Sega mi irá paríó pukúwárí árahue kehramo éra sáhnsáhúwe. Sáhnsahera, Peh íregáritaq 50 táhúséni (50,000) moné tahnsa púkúwárí ira parione íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Púku ira parearónsabe Manikáne ehwehnka áhnte kene sirupipeq pówara sega págege anímárí úkéra wene ehweh mitaq teri mahtaq terinuwana mi ehwéhnká abae agúwe. ");
INSERT INTO awb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Anehe Poraga iwíáhéna, Másérónía marákórápéqkákáq Ákáía marákórápéqkákáq pokinie. Mibeq Sísa tagaríáh ké koragéna sótaikue Sarúsarama suwahpeq pokinie. Mibeq Sísa tagaríáh ké koragéna sótaikue Aroma suwahpeq pokinie íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","We kéróya aníté Tímótireq Érásátireq míóye. Poraga mi aníté Másérónía marákórápéq eqmaq suena we Esia marákórápéq pehgáriq tanáhráq míowe. ");
INSERT INTO awb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mi tanáhráq áhnte kegá Sísansabé aiq pútare atónsabe mó kegá áhnte abíáhnsánéra ehwehuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wehukení wenáwíq Témítíúsie. Wene arambehriwe káhpah tahnsa náneqtaté pehgáriq píkísah tahnsá náneq mira aruqarurúwe. Mi ke suwahpeqte kéné péhepehe maníká wenáwíq Átémísie. Témítíúsireq mó kereqka Átémísine píkísah tahnsá náneq miraera paiqme áhnte moné meyówe. ");
INSERT INTO awb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Témítíúsiga moke mi arámbéhrí mirau ke momiwí aritowe. Wega sensabé, Itega maniká tahnsa náneq miraonsabé áhnte moné meweúne. ");
INSERT INTO awb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Itega Porane sansá aiq tagarawéq wene ehweh aiq írátíáhwe. Wehukega mirao naneq íre aiq pútaq Manikáne tei teinire. Minayabe áhnte kegá itega mirao naneqsabé anetaníbo íwíáhowe. Íre peh morá Épésa suwahpeqte kégá áhnte Esia marákórápéqté kéreqka moq mira íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Minayabe anotah íre kawerire. Itene arambehri íre kaweragíneho. Mó kegá itene maniká Átémísine nahnsabe, Peh abehq náneq nahne íwíáhiyeho. Esia marákórápéqté kéreq mah kehiná kéhínánseqka amahnága Átémísinsabé, Ano iní míáhne éra iwíáh íwíáh atáhwe. Poraga wene ehweh síwáhnorinsabé mó kegá Átémísinsabé íre iwíáh íwíáh atera peh anetaníbo íwíáhiyeho úwe. ");
INSERT INTO awb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Úwara moke arambehriu kega mi ehwéh írótaq anotah abíáhnsánéra ehwehnabauwe. Ehwehnabaéra, Átémísiwe Épésa suwahpeqte kéné maniká anotah iníne uwe. ");
INSERT INTO awb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Minayabe mi kegá anotahtaq ehwehnéra kéyéuwe. Téhraníté Másérónía marákórápéqté áníté sensíwíq Káíúsireq Árísátákirere. Poraga ahpeq nogutaq sega we kéróye. Kéyéu kegá mi aníté táhtoqme koti matábúrápéq abariuera mórítówe. ");
INSERT INTO awb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Poraga, Íné wehuke momiwíorabeq pokinie úwara Sísa tagaríáh kégá ahqáho atówe. ");
INSERT INTO awb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Táhmaro Esia marákórápéqté wáhnáh kégá Porane iyahnabo anímárí míówe. Sega mó anínsábé, Pora ehweh koreawo. Mahraue koreawe, Wehuke momiwíorabeq pokínehboq mitaq míahno ato éra eqmarówana koreawuwe. ");
INSERT INTO awb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Momiwíurabeqte kégá áhnte ehwéhnéra íre peh morá íwíáhuwe. Mó kegá mó ehwéhnuwara mó kegá mó ehwéhnuwe. Áhnte kegá iwíáhéra, Aneqsabé momiwíuno uwe. ");
INSERT INTO awb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wehukení wenáwíq Árékásántae. Asiu kegá we pagunera, Irigue ehweh terio uwana wega ehwéh terinieéna ayahnka saiqnówe. ");
INSERT INTO awb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Saiqnówara sega we tagéra, We Asiu aní míre éra ehwehnabauwe. Sega íre wahto tanáhráq téhtaré áhwáh moráráq ehwehnue mahraréra, Átémísi ite Épésa suwahpeqte kéné maniká anotah iní míre uwe. ");
INSERT INTO awb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mibeqté kúsíkúsíqká momiwíurabeqte kéyábé ehweh saiqnaruowe. Saiqnaritena sensabé, Épésa suwahpeqte wého, áraho? Írátíáhro. Itene anotah maníká Átémísie. Itewe Épésa suwahpeqte kégá wensabé iwíáh íwíáh atona nahtápéq wahnah wahnahnúne. Wene íópeqté ébáh tahnsa píkísáh wahnah wahnahnúne. Minayabe ómi kehinánká aiq tagaríáh mino. ");
INSERT INTO awb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mó kegá péhenóne íre irarerahowe. Minayabe ahbabáriyehboq tabasíwe míáhro. ");
INSERT INTO awb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Itega abariue mórítáh ánítégá Átémísiwe íre ahbabáratehye. Sega wensabé íre abehq éhwéh atehye. ");
INSERT INTO awb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Témítíúsireq wene arambehrio kereqka ehweh kahnaraq sega koti orabeq koreriuwara mitaq kamahni kegá ehweh aritagéhe. ");
INSERT INTO awb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Itega mó ehwéh kahnaraq wahba kégá koti orabeq koreríéro. Sega iwíáhue teigéhe. ");
INSERT INTO awb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Anotah wahnáh kégá itensabé, Ibora aneqsabé tobeho kasenirataq itega aneq ehwéh terianéhnkono? Írakaumo. Ite ehweh íre kéhre. ");
INSERT INTO awb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Minayabe pehwehrue pokéwáhro éna kúsíkúsiqka se kaqsuowe. ");
INSERT INTO awb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Momiwíurabeqte éhwéh parabagútaq Poraga Sísa tagaríáh ké síáhrabéna, Ínéba sero úwara suwe. Suwana sirupipeq kaweq iwíáh aritanieéna Poraga ehweh teriuwe. Teriena mehweh aritena mitaq suena Másérónía marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Poraga Másérónía marákórápéq pokue mó mapéq mó mapérue Sísa tagaríáh kégá págegeue kéranéhe íwíáhigeheéna ehweh teriuwe. Teriena Másérónía marákórápéq suena Káríki marákórápéq pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Káríki marákórápéq kiena apahtáró íó mitaq ména sípi kéwewena Síría marákórápéq pokinaútaq Asiu kegá, Pora suboneheqmúne uwe. Uwana Poraga mó iwíáhéna, Másérónía marákórápéq kouwekinie úwe. ");
INSERT INTO awb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Másérónía marákórápéq kouwekinie úwara mó kegá, Are kéranéhe íwíáhuwe. Pírúsine ahninkáwá Péría suwahpeqte ánínéna wenáwíq Sópátae. Tésárónáíka suwahpeqte áníté sensíwíq Árísátákireq Sékúntareq míóye. Tébi suwahpeqte ání wenáwíq Káíúsi míéhre. Esia marákórápéqté áníté sensíwíq Tíkíkúsireq Tárópímareq míóye. Moke mi kereq Tímótireqka ");
INSERT INTO awb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tóása suwahpeq pokue mitaq itensabé íwénunuwe. ");
INSERT INTO awb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Íre muoráhi parétí né tanahráq parabagútaq íné Árúkareq Porareqka Pírípái suwahpeq sueta sípi kéweweta pokowaye. Itaréitaréráq sípiipéq méta moberíáhtáq Tóása suwahpeq íwénunu kebá sewaye. Seba séta abapete téhtaréráq mitaq míahwaye. ");
INSERT INTO awb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mó wikí ebeqte wéhékáh itega táhutahuq keqme moráráq naneheéq momiwíue míahwane. Mi tanáhráq Poraga ehweh teriuwe. Ahbiah pokinie íwíáhéna inokáhnabubu wene ehweh íre parabarusa peh irarúwe. ");
INSERT INTO awb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Abobóráhpeqte náhúpéq momiwíue míahwanana áhnte aráhmúgá mitaq téhrówe. ");
INSERT INTO awb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Peh morá máhbí wenáwíq Íyútíkae. Wega abobóráhpeqte náh áwáhnkúráq tútuue míowe. Poraga íre wahto ehwéh teriu púana mi mahbí sugekúwe. Sugekú púana máhpeq inahnsubuwara tueyokue tagowe. Tagéra tuiriatómé putiowe. ");
INSERT INTO awb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Putiowana Poraga moq tueyokue tagéna tutaebewe mi mahbí saiqnawe káhkoue míoye. Poraga míó keyabé, Íre ibisahro. We amahnága oga míéhre úwe. ");
INSERT INTO awb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Poraga tuekue kiutaq itega táhutahuq keqme moráráq nahwane. Poraga áhnte mó ehwéh teriena tuekutaq ahbiahipeq mitaq suena pokúwe. ");
INSERT INTO awb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Oga úkú mahbíné awahrahga we meqmera awaho ani mío púara sirupipeq eyoyóéra sene nahtapeq pokuwe. ");
INSERT INTO awb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Poraga pokinaútaq itensabé, Ásósa suwahpeq íwénuninauge éna iuwena ahtapeq pokúwe. Pokúwaq itega sípi kéweweq Ásósa suwahpeq Pora sípiipéq koweraneheéq pokowane. ");
INSERT INTO awb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Itega Ásósa suwahpeq Porareq piehgiowánaraq sípi kéweweq Mítíríni suwahpeq pokowane. ");
INSERT INTO awb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Itega mitaq sueq sípi kéweweq mó wehekáh Kíósa suwahpeq marakó kowaq kótaikowane. Mó wehekáh Sámósa suwahpeq sewane. Mitaq sueq mó wehekáh Mírétúsi suwahpeq sewane. ");
INSERT INTO awb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Asiu kené siahreraq ko tanahráq áwíq Péntíkósie. Poraga iwíáhéna, Péntíkósi tanahráq íné Sarúsarama suwahpeq méyabe nuwahbehre. Minayabe amahnága Esia marákórápéq suena sípi kéwewena apubúue Sarúsarama suwahpeq pokinieéna Épésa suwahpeq íre kowíanauge. Peh kótaikinie íwíáhúwe. ");
INSERT INTO awb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Poraga Mírétúsi suwahpeq míotaq Épésa suwahpeq Sísa tagaríáh ábóáwáh wéh kiwerirankeheéna eqmarowe. ");
INSERT INTO awb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Épésa suwahpeqte Sísa tagaríáh ábóáwáh wéhwé Poraba sutaq wega sensabé mahraréna, Íné Esia marákórápéq téh surautaqkákáq amahnágaákáq itereq mía míaugaq néne sánsá tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Anotah aní méyabe nuwahriarairana peh Manikáne arambehriéyabe nuwahbarairana mira aruqaruruge. Ite tagaríáhmé Asiu kegá áhntetaq moraénue níwíoqnarutowana áhnte tanáhráq ibisarauge. ");
INSERT INTO awb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Wehuke momiwíurotaqkákáq mó natáq mó natárue ite séhréhorahi ehwéh pahsuqme tei teinurauge. ");
INSERT INTO awb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Asiu kereq Káríki kereqsabé, Itene ahbabáq sansa sueq Manikánsabe áhraboro. Itene Wahnah Sísa Karáhénsabe aiq pútare atáhro tei teinuraugaq tagaríáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Poraga mó mahraréna, Manikáne Awanka pokúno aintáráinsabé íné amahnága Sarúsarama suwahpeq pokinie. Mitaq sega nubiq suaneherabowamo. Árahoneherabowapómo. Íné íre tagaríóge. ");
INSERT INTO awb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Peh morá íné niahtebome Sarúsarama suwahpeqte kégá níwíoqnéra karábúsiipéq móintagéhe. Mó mapéq mó mapérue séyéurautaq Manikáne Awanka mó ke iwíáh aritowara mira éhwéh teni teninowe. ");
INSERT INTO awb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sega nubiq súéhransabé íre áhreuge. Minayabe anetaníbo. Itene Wahnah Sísa Karáhéga teníátái arámbéhrí parabarueyabe nuwahbehre. Manikánka ite séhréh aitena kaweraitéh éhwéh teri terinéyabe nuwahbehre úwe. ");
INSERT INTO awb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Poraga mó mahraréna, Manikánka wahnahni ehwéh ite míáhrabeq tei teinurauge. Íné tagaríómé amahnága pokonaraq mókake íné mó íre tagagehe. ");
INSERT INTO awb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ibora pahsuqme teiníboq írátíáhro. Iraipéq pokira kegá ínénsabe íre abiahnsa aintahráhowe. ");
INSERT INTO awb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Íné íre túbáh agia Manikáne sansá moke pahsuqme íwáhnorurau puara íre abiahnsa aintahráhowe. ");
INSERT INTO awb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Manikáne Awanka ite omaq itena, Wahnahnúno aitáráire. Wahnahnúno aitárái puaq sipisípiq wahnáhnká wene kamarí wahnahninserah itega moke Sísa tagaríáh ké moq kawerue wahnahnarítáhro. Kawerue wahnahnariteq Sísaga mi kené ahbabáqsabe wene korahqtaté paiqmataire íwíáhoro. ");
INSERT INTO awb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Sísane sánsá íre tábúsoqme miraéra peh mó sansá miraigeheéra íné pokona tanáhráq mó kegá séra péhe éhwéh íwáhnorigehe. Úrinsi iánká sipisípiq subínserah sega ite morábí méra íre kaweraitagéhe. ");
INSERT INTO awb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Sísa tagaríáh kégá wehukene sánsá miraigeheéra ite míáhrabeqte kégá moq péhe éhwéh íwáhnorigehe. ");
INSERT INTO awb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Minayabe íwéh panatágínaq uqmatíáhro. Apahtáró ópéq wéhékáhnkakaq inokáhpeqkakáq itensabé nirutaboiréna kawerue íwáhno aruqaruruge. Minayabe iahreraq matíáhro úwe. ");
INSERT INTO awb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Poraga mó mahraréna, Manikánka séhréh aitéh éhwéh anotah pagégé éhwéhne. Mi ehwéh íréhrataq itega kaweqtaq míahrahowe. Mi ehwéh íréhrataq itega kaweqtaq méq oga mía míaira kereq moráráq míagehe. Minayabe Manikáne ehweh kawerue ireq wene sánsá miraoro. ");
INSERT INTO awb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Iteba míarau tanáhráq mó aníné korósiakáq móneakáqsábé íre nirutaboirurauge. ");
INSERT INTO awb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ínéreq séhréh aintáh kéreq táhutahuroneheéna ínénéga arambehriurauge. Minayabe tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Itega mareqmarero ke séhréh aritaneheéq kawerue arambehrioro. Ínéga aiq mira aruqarurunserah arambehrioro. Itene Wahnah Sísaga mahraréna, Mó anínká are náwí tánáhráq are iwíáh íwíáhóne. Arega mó aní náwena tanáhráq anotah iwíáh íwíáhóne uraire. Mi ehwéhnsábé iahreraq matíáhro úwe. ");
INSERT INTO awb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Poraga mi ehwéh aiq teriutaq wereq aboawah wehreqka sirehunseraráq méra púreruwe. ");
INSERT INTO awb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Púreq ehwéh parabagútaq sega Pora káhkoue mehwehéra ibisowe. ");
INSERT INTO awb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Poraga, Mókake íné mó íre tagagehe únsabe sirutaboiréra ibiséra we sípiipéq meqmera móauwera kowekuwe. ");
INSERT INTO awb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Itega Épésa suwahpeqte ábóáwáh wéh sueq sípi kéweweq obaríqme kure Kósa marákórápéq pokowane. Mó wehekáh itega Árórésa marákórápéq kéq mitaq sueq Pátára suwahpeq pokowane. ");
INSERT INTO awb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mitaq séq Pónísía marákórápéq pokína sipí kabarue tagéq mi sipí kéweweq pokowane. ");
INSERT INTO awb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sáípára marákórápéq ábóraq kowanaraq tagéq marakó ayehrápéq kótaikowane. Kótaikéq Síría marákórápéq tagéq Táíya suwahpeq korahowane. Mó kegá sípiipéqté ménsáméhnsá mewe marakóipeq sáharótaq ");
INSERT INTO awb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","itega Táíya suwahpeqte Sísa tagaríáh kébá kowíahwane. Kowéq abapete téhtaré wéhékáh seba kowíahwane. Seba míahwanaraq Manikáne Awanka se iwíáh aritowara sega Pora teawera, Wehukega are subiq súéhboq Sarúsarama suwahpeq pokineho uwe. ");
INSERT INTO awb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mi tanáhráq parabagútaq itega pokonehe íwíáhéq kaegaeowanarabeq suahwáne. Suahwánaraq moke mibeqté kéreq sene kárironanínseqka meiqmera ahnansahrapeq méíúwówe. ");
INSERT INTO awb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Itega arahwéraq irehunseráráq méq púreréq iriwe mehwehowane. Mehweh ariteq sípiipéq kiasagowanara tagéra sene nahtapeq seuwekuwe. ");
INSERT INTO awb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Itega Táíya suwahpeq sueq sípi kéweweq pokue Tórémési suwahpeq pokowane. Mibeqté Sísa tagaríáh kéreq mehwehéq peh morá wéhékáh seba kowíahwane. ");
INSERT INTO awb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mó wehekáh itega mitaq sueq Sésáría suwahpeq pokowane. Mitaq Pírípine nahtapeq kaegaeowane. Eqmaro kega abapete téhtaré wéhúké omaq sitótaq Pírípi omaq atówe. Pírípi Sísa éhweh teri terinu aní míowe. ");
INSERT INTO awb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wene ayahunkawaréh itaréitaré ítaq ahrárígáú míówe. Manikáne Awanka iwíáh aritowara se wene ehweh iraru ahrárígáú míówe. ");
INSERT INTO awb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Itega Sésáría suwahpeq kaegaeowanaraq táhmaro wehekáh parabagútaq wehukení wenáwíq Ágábúsaga Súría marákórápéqté tuwe. Manikáne Awanka iwíáh atowana wega wene ehweh irarerahúwe. ");
INSERT INTO awb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Wega iteba séna Porane áréti pugeqme mewena minarate wewene aigárá ayahnkara táhru táhruúwe. Táhru táhruéna mahraréna, Ínéga táhru táhruunserah Sarúsarama suwahpeqte Asiu kegá mah arétí abo moq táhru táhruigehe. Táhru táhruera nahnso kebá móatagéhe. Mah ehwéhmé Manikáne Awanka aiq irarire úwe. ");
INSERT INTO awb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Mi ehwéh irahwánaraq itereq mitaq míó kereqka Poransabé, Sarúsarama suwahpeq íre pokúno éq saiqnahwane. ");
INSERT INTO awb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Saiqnahwanana Poraga itensabé, Nirupipeq umehínehboq aneqsabé saiqnéq ibisaho? Karábúsiyabé íre áhreuge. Itene Wahnah Sísane arambehri miraunsabé Sarúsarama suwahpeq nubiq suaneherabowapómo. Anetaníbo úwe. ");
INSERT INTO awb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Anetaníbo úwaq wega itene ehweh íre ironsabe túbáh agéq, Maniká awabeh sansá mirainkehe ewane. ");
INSERT INTO awb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mi tanáhráq parabagúwaq ménsámehnsá sokahueq Sarúsarama suwahpeq pokowane. ");
INSERT INTO awb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sésáría suwahpeqte Sísa tagaríáh ké táhmaro kegá ite kie irówe. Wehukení wenáwíq Násónie. We Sáípára marákórápéqté ánínéna íre wahto tanáhráq Sísa tagariowe. Kie iró kega Násónine nahtapeq kaigeheéra móítówe. ");
INSERT INTO awb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Itega Sarúsarama suwahpeq kowanaraq mibeqté Sísa tagaríáh kégá sirupipeq eyoyóéra mehweh aitówe. ");
INSERT INTO awb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mó wehekáh Porareq itereqka Sémísiba pokowanara ómi Sísa tagaríáh ábóáwáh wéh míówe. ");
INSERT INTO awb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Poraga sereq mehwehéna Sísa éhweh nahnso ke moke teriunsabe Manikánka miraú arámbéhrí sáhnsahwe teriuwe. ");
INSERT INTO awb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Poraga miraú arámbéhrí sáhnsahwe teriuwara aboawah wehgá írótaq Manikánsabe iwíáh íwíáh atera we anotah aní míre íwíáhuwe. Sega Poransabé, Iteribáq móne. Áhnte, peh íregáritaq Asiu kegá Sísansabé aiq pútare atáhwe. Sega Mósísiga sehgíóro ú ehwehnsábé iwíáh íwíáh atáhwe. ");
INSERT INTO awb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wene ehweh iwíáh íwíáh atáhwara arega miraurona sansámé mó kegá se péhepehe ehwéh teríátówara aiq írátówe. Mi pehe éhwéh mahraréra, Arega nahnso ke míáhrabeqte Asiu keyábé, Mósísiga sehgíóro ú ehwehnsábé anetaníbo. Itene aniné áú amurúrúáhro ú sansánkákáq mó Asiu kené sánsánkákáq íre miraoro teri terinire ewe. ");
INSERT INTO awb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Itega tagarionawe arega aiq sire u ehwéh Asiu kegá iraneherawoe. Minayabe amahnága aneronehnkono? ");
INSERT INTO awb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Aneronehnkono éra sega mó mahraréra, Asiu kega túbáh agigehboq itega teawéna ehwéh miraúno. Mahbeqté itaréitaré wéhúkégá Manikánsabe, Itene omasa éhwéh miraoneheqmúne teawéwe. ");
INSERT INTO awb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Arereq mósosuagéhboq mi anímárí meriqme Manikánsabe iwíáh íwíáh atáh náhtápéq mórito. Titironeherau ka paiqmaro. Anehe sene siyahra káúqsuagéhe. Mirairataq ómi kegá tagarianeheéra Mósísiga sehgíóro ú ehweh anteruahnayabé íre aiq pútare atagéhe. Peh Mósísine ehweh kawerue sehgione íwíáhigehe uwe. ");
INSERT INTO awb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Sísa tagaríáh ábóáwáh wéhgá mó mahraréra, Sísansabé aiq pútare atáh náhnsó ké páhsi iwíáhue sehiranue síátóne. Mi pahsígá mahraréna, Péhepehe maníkánsábé iwíáh íwíáhoneheéra titirirataq náíra naneq íre nahro. Korahq íre nahro. Wehukenínká awio páríkí náneq ka íre nahro. Mó kené ahrewe ahrariwe wehwe mahbiwe íre abarioro ire. Peh miraue iwíáhue sehiranue teríátáúne uwe. ");
INSERT INTO awb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Uwana Poraga kowe éna omasa éhwéh miraoneheqmúne u animárí móritowe. Mó wehekáh wereq sereqka sosúó sansa áhwáréra Manikánsabe iwíáh íwíáh atáh náhúpéq kibekuwe. Sosúó sansa parabagína tanáhráq mibeq mahbeq arítáh ké terieneheéra kibekuwe. Teriera, Mi tanáhráq parabagínaraq itega Manikánsabe iwíáh íwíáh ateq titironehe uwe. ");
INSERT INTO awb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Sosúó sansamé abapete téhtaré wéhékáh parabaginaútaq Esia marákórápéqté Asiu kegá Pora tagowe. We Manikánsabe iwíáh íwíáh atáh náhúpéq míowara tagéra abiahnsanuwe. Sega Pora táhtoqme ");
INSERT INTO awb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","nahtapeq míó kega ehwehnabaéra mahraréra, Ísara keo, séhréh aitáhro. Mah anínká ómi mah kehiná kéhínánsábé ite Asiu ke íre kaweq ke wóe síwáhnoréna Mósísiga sehgíóro ú ehweh anterúáhro ue síwáhnorire. Mah nahnsábé anetaníbo ue síwáhnorire. Wega mó ahbabáritéhmé Káríki ke Manikánsabe iwíáh íwíáh atáh náhúpéq móárítéhre. Móárítéh púana wega mah kawéq náhnsábé íre kaweratéhre uwe. ");
INSERT INTO awb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Épésa suwahpeqte ání wenáwíq Tárópímae. Menah Asiu kegá wereq Porareq Sarúsarama suwahpeqte áhtápéq nogúyataq tagowe. Mitaq tagonsabe sega péhe íwíáhéra, Poraga Manikánsabe iwíáh íwíáh atáh náhúpéq nahnso aní meqme surainsabe órira mire uwe. Meqme móátáráire ume péhe éhwéhne. ");
INSERT INTO awb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Minayabe ehwehnabaéra ómiga abiahnsanéra pehbeheráh seyeue sorupera Pora Manikánsabe iwíáh íwíáh atáh náhúpéqté táhtoqme abariuera máhpeq márunatera onsawárí paiqsúówe. ");
INSERT INTO awb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Sega Pora suboneherautaq Aroma sontíá kéné anotah wahnáhnká ómi Sarúsarama suwahpeqte kégá aiq tobehowe u irowe. ");
INSERT INTO awb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Irena wega apubúue sóntía keákáq sene wahnah animárínkákáq meriqmena pehbeheráh túwe. Túwara Pora subu kegá mi ke tagéra túbáh aguwe. ");
INSERT INTO awb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Sóntía kené wahnahnka Poraba tuena táhtoqme téhtaré séníráté táhraráhro úwe. Táhraráhro éna, We insebo? Aneq ahbábáriro kasenúwe. ");
INSERT INTO awb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kasenúwara áhnte kegá míó púara ehwehnabaéra mó kegá mó ehwéhnuwara mó kegá mó ehwéhnuwe. Áhnte ehwéhnu puara wega íre kawerue irahráhúnsabe sóntía keyábé, Ite kaegaeo nahupéq móátáhro úwe. ");
INSERT INTO awb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Kaegaeo nahupéq kibekoneherautaq se kéró kega paentáwe kéra ehwehnabaéra, Subiq súáhro. Subiq súáhro uwe. Subiq súáhro unsabe Pora subíyehoéra sóntía kegá we sawiwera nogúwe. ");
INSERT INTO awb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Sega we nahupeq móataneherautaq Poraga Káríki ehwéhtáq sóntía kené wahnahnsabé, Ehweh teawinínkono kasenúwe. Kasenúwana mi anínká éhnehéna, Are Káríki ehwéhmé aiq írátíahne éna, ");
INSERT INTO awb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Menah peh morá Ísípi marákórápéqté ánínká kámáhni ke ebehinkeheéna áhnte ke 400 subiq suahráho ke meriqmena uworapeq pokuraire. Íné iwíáhume, Arewe we wone íwíáhuge úwe. ");
INSERT INTO awb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Úwana Poraga, Íné Asiu aní múge. Íné Sírísía marákórápéq Tahsa suwahpeqte ání múge. Tahsa suwahpeq áhnte nahnsó ké míáhwe. Íné mahtaq míáh ké ehweh terinie úwe. ");
INSERT INTO awb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Úwana, Terio únsabe Poraga awahsahniataq méwotate irigéna míó kega ehiyansá agigeheéna ayahnkaratáté saiqnówe. Saiqnówara túbáh aguwana Poraga Asiu kené ehwehtaq mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Náníbáqmari móe. Nániboreh wóe. Nánuwahraho, néne ehweh íráhro. Íné íre ahbabáq anine ue iahtebagehboq néne ehweh íráhro úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Wega Asiu kené ehweh irarúwara irera ehiyansá aguwe. Ehiyansá aguwana Poraga mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Íné Asiu aní múge. Náinoga Sírísía marákórápéq Tahsa suwahpeq maqinténa Sarúsarama suwahpeq méintowana mahtaq anonúkowae. Anotah síwáhnori aní Kámáríaga iteriborehne sansá irankeheéna kawerue níwáhnoruraire. Ibora itega Manikáne arambehri mira onserah ínéga moq mira aruqarururauge. ");
INSERT INTO awb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Menah ínéga Sísansabé aiq pútare atáh ké pukigeheéna síwíoqnarauge. Weh ahre táhtoqme táhru táhruena karábúsiipéq mórítáráuge. ");
INSERT INTO awb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Manikáne ehweh mibeq mahbeq arítáh kéné wahnahnseq aboawah wehreqka minayabe tagéra teieráhowe. Sega Támákása suwahpeqte Asiu ke páhsi sinkeheéra sehiranue níátówe. Íné Támákása suwahpeq pokurauge. Mibeqté Sísa tagaríáh ké táhru táhruue Sarúsarama suwahpeq móritanieéna pokurauge. Se kamah ariníe íwíáhurauge úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Poraga mó mahraréna, Íné ahtapeq pokue Támákása suwahpeq kinaurauge. Kinauraugana wéhékáhnabubu íné kuraurabeq apubúue íópeqté anotahtaq téhraguraire. ");
INSERT INTO awb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Téhragurairana marakóipeq márunsurahéna ehweh írátáuge. Mi ehwéhnká mahraréna, Sorao, Sorao, aneqsabé níwíoqnahno uraire. ");
INSERT INTO awb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Urairana ínéga, Anotah aníno, are insebo urauge. Uraugana wega ínénsabe, Íné Sísa Néhsara suwahpeqte ání arega níwíoqnáhna aní múge uraire. ");
INSERT INTO awb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Íné sénító kegá téhragurai tagéra peh teníátái ehwéh íre írátówe. ");
INSERT INTO awb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ínéga, Néne Wahnahno, anerininkono kasenurauge. Kasenuraugana wega ínénsabe, Irigue Támákása suwahpeq pokúno. Mitaq arega moke miraina arámbéhrí teawiníe uraire. ");
INSERT INTO awb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Anotah téhrarainsabé íné íre tagahrahurauge. Íre tagahrahurau puara íné sénító kegá niyahtaq ahmboqmera Támákása suwahpeq móíntárówe úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Poraga mó mahraréna, Mibeqté ání wenáwíq Ánáníásie. We Mósísiga sehgíóro ú ehweh kawerue írátái aníne. Moke wenawahrah Asiu kegá, We aiq kaweq aníne íwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ánáníásiga ínéba séna iriwe ména ínénsabe, Sorao, náníbáq móne. Arega tagahrahóne urairana niura apubúue kaweragurairana we tagarauge. ");
INSERT INTO awb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","We tagaraugana wega ínénsabe, Itene igaqnaréhne Manikánka wene sánsá ahtebankeheéna are omaq atéhre. Wene kaweq ahnínkáwá tagé wene ehweh irankeheéna are omaq atéhre. ");
INSERT INTO awb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Arega wene ehweh ómi kehinánsábé terinkéhe. Arega tagé írátóna ehwéh terinkéhe. ");
INSERT INTO awb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Amahnága túbáh aginehboq iriwe mé wání meyo. Arene ahbabáq kaqauwankéhboq Sísansabé áhrabúno uraire úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Poraga mó mahraréna, Íné Sarúsarama suwahpeq seuwekurauge. Mibeqté Manikánsabe iwíáh íwíáh atáh náhúpéq púrerurautaq néniwanka ");
INSERT INTO awb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Sísa tagarauge. Tagaraugana wega ínénsabe, Mahtaqté kégá arene ehweh íre aiq pútare atéhra puah Sarúsarama suwahpeq apubúue sue móbeq pokúno uraire. ");
INSERT INTO awb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Urairana ínéga wensabé, Néne Wahnahno, Asiu kené momiwí nahmárítápéq arensabé aiq pútare atáró ke subiqme karábúsiipéq sítáráuge. Minayabe mahtaqté kégá tagaríáhwe. ");
INSERT INTO awb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sítíbéni arene ehweh teríátái anímé Asiu kegá ebahnsatate subitótaq ínéga wahtotaq iriwe ména we pukime aiq kawerire éna subitó kené káhq ambántámárítáq wahnahnurauge teawátáuge. ");
INSERT INTO awb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Teawátáugana wega ínénsabe, Nahnso suwahpeq íre wahto marákórápéq eqmaraníe. Arega nahnso ke néne ehweh korerinkéhboq pokúno teníátáire úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Poraga teriu ehwéh sega kawerue írówe. Írówana Poraga nahnso keyábé irarútaq sega ehwehnabaéra mahraréra, We oga míéhmé anotah íre kawerire. Subiq súáhro uwe. ");
INSERT INTO awb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Porane ehweh íre suwahbó púara sega ehwehnabaéra sene ambantamarí ugurue tuperúpeéra tanahuqkakaq mewe tuperúpeuwe. ");
INSERT INTO awb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Sega mirauwana sóntía kené wahnahnka, Mi aní nahupeq móátáhro úwe. Móátáhro éna, Asiu kegá aneqsabé abiahnsanéra áhnte ehwéhnoo íwíáhúwe. Iwíáhéna, Teninkéhboq mah aní áréti sahtáté subóro aritowe. ");
INSERT INTO awb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Sega we subiqmaraneheéra wene aiayah táhru táhruuwana Poraga weba wahtotaq iriwe mío wahnáh ánínsábé, Íné Aroma aní múge. Aneqsabé ehweh íre aintasa pehipi nuboneheo? Mi sansá aiq mirao sansánoo úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Úwana kíápéténiga irotaq anotah wahnáh ánípá pokue wensabé, Itega suboneheú aní Aroma aní míéhnsábé anerinibo úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Úwana wega Poraba séna wensabé, Are Aroma anípo? Tenio úwana, Kowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kowe úwana anotah wahnáh ánínká wensabé, Íné áhnte moné paiqmataunsabé Aroma aní úkurauge úwe. Úwana Poraga wensabé, Náinoga maqintotaq Aroma aní maqintowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Úwara Pora suboneherau kegá irera apubúue auwera peh tagowe. Anotah wahnáh ánínká iwíáhéna, Mah aní Aroma aní míéhrana táhru táhruéwómé íre kaweruge. Íre kaweruge éna wega moq áhreúwe. ");
INSERT INTO awb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Áhreéna arupipeq iwíáhéna, Asiu kegá aneqsabébópoq we ehweh atáhwe. Iraníe íwíáhéna mó wehekáh wega, Pora táhraró nahgáq pugeq áúwáhro aritena, Manikáne ehweh mibeq mahbeq arítáh kéreq mó kaunsírí kéreqsabé, Momiwíoro aritowe. Momiwíoro aritena, Pora meqme momiwíurabeq móátáhro aritowe. ");
INSERT INTO awb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Poraga kaunsíri ke ebitáwéna mahraréna, Nánuwahraho, Manikánka nirupipeq tagaríéhre. Menahnkákáq amahnágaákáq kaweqtaq mía míauge úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Peh morá wáhnáh ání Ánáníásiga Manikáne ehweh mibeq mahbeq arítáh ké wahnahnúwe. Wega Poraba iriwe míó keyabé, Wene áwéh suranóro aritowe. ");
INSERT INTO awb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Aritowana Poraga wensabé, Awisúitagi wirá áwánká taberábe pentí abaq máráhwara awisúitagi awánká íre tagahrahowe. Mina inserah are kaweq ambántá úbíq miahnawe arene arupipeq peh awisúitagi wirá áwánká tahnsane. Arega íné áwéh suranóro aritahnaga Manikánka are mina tahnsaninkehe. Arega mitaq tútuue Mósísiga sehgíóro ú ehweh iwíáhé ehweh aintahne. Minayabe aneqsabé níwéh suranóro aritahno? Miraónaga Mósísine ehweh aiq anteruahne úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Úwara Poraba iriwe míó kega wensabé, Manikáne ehweh mibeq mahbeq aitáh kéné wahnahnsabé aneqsabé ehweh atahno uwe. ");
INSERT INTO awb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Uwana Poraga sensabé, Manikáne ehwehnka mahraréna, Itene wahnahnsabé abehq éhwéh atéhneho ire. We Manikáne ehweh mibeq mahbeq aitáh kéné wahnah tagaríótáq tahirímé mi ehwéh íre iraru irino úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kaunsíri kewé mó akáhtáq Sáyúsi ke míówara mó akáhtáq Péhrasi ke míówe. Minayabe Poraga se tagéna iwíáhue momiwíuríórabeqte kéyábé anotahtaq mahraréna, Nánuwahraho, íné Péhrasi aní múge. Nániboreh Péhrasi kené sánsá mirau ke míówe. Manikáne omasa éhwéhnsábé aiq pútare atena wega mókake pusa ké oganúq sitankéhe iraruraunsabé ehweh aintáhwe úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Péhrasi kegá mó iwíáhuwara Sáyúsi kegá mó iwíáhuwe. Íre morá íwíáhunsabé seye ehwehuwe. ");
INSERT INTO awb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Péhrasi kegá iwíáhéra, Mókake Manikánka pusa ké oganúq sitankéhe. Sega íópeqté kéreq Maniká míéhrabeqte kéreqsabé aiq pútaq míáhwe íwíáhuwe. Sáyúsi kegá minayabe íre aiq pútare arítówe. Sega iwíáhéra, Manikánka pusa ké íre oganúq sitanawire íwíáhuwe. Minayabe se mó iwíáh mó iwíáhu puara seye ehwehuwe. ");
INSERT INTO awb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Anotah ehwéhutaq táhmaro Péhrasi sansá síwáhnoro kegá iriwe méra mahraréra, Itega iwíáhúnawe mah anímé íre ahbabáq anine. Íópeqté ké, Maniká míéhrabeqte kégá ehweh teawátówapómo. Itewe íre tagariahrahúne uwe. ");
INSERT INTO awb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Unsabe seye áhnte ehwéhnabaunsabe sóntía kené wahnahnka, Asiu kegá Pora abariwe subíyeho íwíáhéna, Sóntía keyábé, Mi aní tutáhtoqme sabiwe meqmeq itega kaegaeorabeq móátáhro aritowe. ");
INSERT INTO awb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mó penórábéq Sísaga Poraba sebatawe ména wensabé, Íre áhreúno. Íné éhweh arega Sarúsarama suwahpeq teríátónanserah mókake Aroma suwahpeq moq terinkéhe úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mó wehekáh Asiu kegá sío síoéra moráénéra, Manikánka tagaríéhre. Wánínkakaq táhutahuqkakáq pehipi íre naneheqmúne. Ebeq Pora subiq sueq anehe táhutahuq nanehe uwe. ");
INSERT INTO awb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Áhnte weh 40 wehgá miraue sío síoéra moráénue iwíáhuwe. ");
INSERT INTO awb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Sega Manikáne ehweh mibeq mahbeq arítáh kéreq Asiu kené aboawah wehreqpa pokue sensabé teriera, Manikánka tagaríéhre. Itega wánínkakaq táhutahuqkakáq pehipi íre naneheqmúne. Ebeq Pora subiq sueq anehe táhutahuq nanehe. ");
INSERT INTO awb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Minayabe itereq mó kaunsírí kéreqka sóntía kené wahnahnsabé péhe éhwéh mahrarero. Mahraréq, Itega Pora éhweh tábúsoqme iranéhboq iteba meqme súno ero. Itega ahtapeq wahnahnurawéq wega sinaraq suboneheqmúne uwe. ");
INSERT INTO awb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Uwana Porane anahnowáné ahninkáwágá mina mehwaró ehweh irowe. Irena sóntía kegá kaegaeurabeq kibekue Pora teawuwe. ");
INSERT INTO awb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Teawuwana Poraga kíápéténinsabé áhrabéna mahraréna, Mah mahbígá arene wahnah aní ehweh teawinkéhboq meqme móato úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Úwana wega meqmena anotah wahnáhpá móatena wensabé mahraréna, Mah mahbígá ehweh teawinkeheéna meqmena suge. Karábúsiipéqté ání wenáwíq Poraga níáhrabue we meqme areba móato teníre úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Úwana anotah wahnáh ánínká mahbine ayahtaq panantáwe meqmena kopípéq mógasenúwe. Kasenéna, Aneq ehwéh teniníbo úwana ");
INSERT INTO awb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","mahbiga wensabé, Asiu kegá moráénéwáhwe. Sega arensabé, Ahbiah Porawe kaunsíri kebá meqme súno teawigéhe. Pora éhweh tábúsoqme iranéhboq iteba meqme súno teawigéhe. ");
INSERT INTO awb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Minayabe aiq pútare arítéhnehboq 40 kegá mehwatíáhwe. Sega aiq mahraréra, Manikánka tagaríéhre. Itega wánínkakaq táhutahuqkakáq pehipi íre naneheqmúne. Ebeq Pora subiq sueq anehe táhutahuq nanehe ewe. Sega amahnága sokah sokahue míáhwe. Peh arene ehwehnsabé áwénunowe úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Úwana anotah wahnáhnká mi mahbíyábé, Arega tenienawe mó ke teríneho. Pehwehrue pokéwahno éna eqmaq auwowe. ");
INSERT INTO awb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Eqmaq auwena téhtaré kíápéténi síáhrabúwe. Síáhrabéna sensabé, Inokáhpeq wehuke sugé tanahráq Pora Sésáría suwahpeq meqmeta móátáhtao. Áhnte sontíá ké 200 sontíá kéreq 70 oségá káhkokóawíáh sóntíá kéreq mó áhnte 200 sehsabekara matíáh sóntíá kéreq sokah sokah arítáhtao. ");
INSERT INTO awb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pora moq óseraq tútuue míahnaraq anotah wahnáh ání Péríkiba kawerue meqmeta móátáhtao úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Móátáhtao éna Péríkine páhsi sehiranue mahraréna, ");
INSERT INTO awb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Péríkio, are anotah kawéq wáhnáh ání móne. Íné Káróríúsa uge. Mó niwíqmé Árísíása uge. Néne páhsi sáhnsahwe tagáhno. ");
INSERT INTO awb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Asiu kegá mah aní táhtoqme subitótaq we Aroma aníne urairana írátáuge. Írátáútaq ínéreq sóntía kereqka pehbeheráh tueq tumetáune. ");
INSERT INTO awb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Wega aneq ahbabárirapómo éna iranieéna sene kaunsíri kebá móátáráuge. ");
INSERT INTO awb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Sega seyene sánsánsábé ehweh atówana wega íre anotah ahbábárire. Mi ahbábáqmé íre suboráhi ahbábáq míre. Íre karábúsiipéq móatahráhi ahbabáq míre. ");
INSERT INTO awb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Asiu kegá mah aní suboneheqmúne uro irena apubúue areba eqmaq áúwóge. Wensabé ehweh atáh kéyábé areba pokue mi ehwéh koreawéro atóge úwe. Páhsiipéqté éhwéhnká aiq irarúwe. ");
INSERT INTO awb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sene wahnahnka teriunserah sóntía kegá Pora meqmera inokáhpeq Ántípáti suwahpeq móátówe. ");
INSERT INTO awb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mó wehekáh óseakáq kégá Pora meqmera Sésáría suwahpeq pokuwe. Pokuwara mó sontíá kégá sene nahtapeq tuekuwe. ");
INSERT INTO awb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tuekuwara óseakáq sóntíá kégá pokue Sésáría suwahpeq kéra anotah wahnáh ání Péríkiba Pora móatera páhsiakáq móátówe. ");
INSERT INTO awb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Móátówana wega páhsi sáhnsahena Poransabé, Are eheqte ánípo kasenúwana, Íné Sírísía marákórápéqté ání múge úwe. ");
INSERT INTO awb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Úwana, Arensabé ehweh atéhra ke túírataq arene ehweh iraníe úwe. Wega sóntía keyábé, Érótine anotah nahtápéq ateq mitaq wahnahnoro aritowe. ");
INSERT INTO awb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Manikáne ehweh mibeq mahbeq arítáh kéné wahnah wenáwíq Ánáníásie. Moberíáh wéhékáh parabagútaq wereq táhmaro Asiu kené aboawah wehreqka peh morá págegeue ehweh aritahráhi aní wenáwíq Tétúra meqmera túwe. Sega Aroma kené anotah kamáhní ání Péríki Pora éhweh teawanehe úwe. ");
INSERT INTO awb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Péríkiga, Pora meqmeq sero úwara meqmera móátówe. Móátówana Tétúraga mahraréna, Péríkio, are anotah kawéq wáhnáh ání móne. Arega wahnahnónayabé ite Asiu ke pehwehrue mía míaorahúne. Arega kawerue iwíáhónawe séhréh aitaníe é itene marakó kaweraitahne. ");
INSERT INTO awb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Minayabe itega iwíáh íwíáh ateq kaweróne atone úwe. ");
INSERT INTO awb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Tétúraga mó mahraréna, Áhnte ehwéh íre irarinie. Pehgáriq ehwéh teawiníboq iro. ");
INSERT INTO awb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ite iwíáhúnawe mah anímé ahbabáq aruqaruri aníne. Wega mah marákó márákóípéq mó ke suwahpeq mó ke suwahperue Asiu keyábé pagu pagunurairara áhnte kegá tobehéra ebehowe. Wega itene sánsá suena Néhsara suwahpeqte áníné sánsá meyáh ké wahnahnire. ");
INSERT INTO awb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Wahnahnéna wega Manikánsabe iwíáh íwíáh atáh náhtápéq íre kawerina uraitaq itega táhtotiaraune. Itene sánsá anterutainsabé ehweh ateq parabaruanehe íwíáhuraune. ");
INSERT INTO awb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Iwíáhuraunaraq itega Pora ehweh atanéhe uraunaraq sóntía kené wahnah wenáwíq Árísíásarehga tuera ite págegeue iubera Pora meqmera móbeq móátárówe. Árísíásaga itensabé, Pora ehweh atagéhboq anotah aní míéhrabeq pokue mitaq ehweh atáhro uraire. ");
INSERT INTO awb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Moke ehweh atéhra ehwéhnsábé wewega teawinkéhboq kaseninanao úwe. ");
INSERT INTO awb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Úwara moke wereq su Asíú kégá wega irarú ehwéhnsábé kowe at