﻿USE sofia;
DROP TABLE IF EXISTS sofia.avu_vpl;
CREATE TABLE avu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES avu_vpl WRITE;
INSERT INTO avu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tã âfõ-âfõ Yésũ Krístõ rî ạ́ꞌbı̣́yạ́ yí kâ rî rĩꞌá nõô. Yésũ rĩꞌá kúmú Dạ̃wúdı̣̃ rî ózõwá ꞌî. Gõꞌdá Dạ̃wúdı̣̃ íyíkâ Ãbãrãyámã rî ózõwá ꞌî. Ózõwá gólĩyî îtõlé bê Ãbãrãyámã rú sĩ cãlé bũúũ kúmú Dạ̃wúdı̣̃ rú rî rĩꞌá ĩyî õzõ nõô ꞌbá yí kâtí. ");
INSERT INTO avu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ãbãrãyámã tı̣̂ Ĩsákã. Gõꞌdá Ĩsákã tı̣̂ íyíkâ Yãkóbã. Gõꞌdá Yãkóbã tı̣̂ íyíkâ Yúdạ̃ yî ậdrúpı̣̃ lâ yí bê. ");
INSERT INTO avu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Gõꞌdá Yúdạ̃ tı̣̂ Pẽrézẽ yî Zérã bê, gõꞌdá ândrê lâ yî Támã ĩꞌdî. Gõꞌdá Pẽrézẽ tı̣̂ íyíkâ Ẽzẽrónẽ. Gõꞌdá Ẽzẽrónẽ tı̣̂ íyíkâ Rámã. ");
INSERT INTO avu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Gõꞌdá Rámã tı̣̂ íyíkâ Ãmĩnãdábã. Gõꞌdá Ãmĩnãdábã tı̣̂ íyíkâ Nãsónõ. Gõꞌdá Nãsónõ tı̣̂ íyíkâ Sãlãmónã. ");
INSERT INTO avu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Gõꞌdá Sãlãmónã tı̣̂ íyíkâ Bõꞌázã. Gõꞌdá Bõꞌázã rî ândré íyíkâ Rãhábã. Gõꞌdá Bõꞌázã tı̣̂ íyíkâ Óbẽdẽ. Gõꞌdá Óbẽdẽ rî ândré íyíkâ Rútạ̃. Gõꞌdá Óbẽdẽ tı̣̂ íyíkâ Yésẽ. ");
INSERT INTO avu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Gõꞌdá Yésẽ tı̣̂ íyíkâ kúmú Dạ̃wúdı̣̃. Gõꞌdá nĩngá sĩ, ózõwá gólĩyî îtõlé bê kúmú Dạ̃wúdı̣̃ rú sĩ cãlé bũúũ kậyı̣̂ gólâ õjílã Ĩsĩrãꞌélẽ kâ trõzó âjílí ꞌbạ̃drı̣̃ lídí ꞌá Bãbĩlónã ꞌálâ rî sĩ rî rĩꞌá õzõ nõô rî ꞌbá yî tí. Kúmú Dạ̃wúdı̣̃ tı̣̂ Sólõmõ. Gõꞌdá Sólõmõ rî ândré íyíkâ Ũrı̣́yạ̃ rî ạ̃yı̣́zı̣́ rú bê Bãtẽsébã rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Gõꞌdá Sólõmõ tı̣̂ íyíkâ Rẽhõbówã. Gõꞌdá Rẽhõbówã tı̣̂ íyíkâ Ãbíjã. Gõꞌdá Ãbíjã tı̣̂ íyíkâ Ásã. ");
INSERT INTO avu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Gõꞌdá Ásã tı̣̂ íyíkâ Yõsãpátã. Gõꞌdá Yõsãpátã tı̣̂ íyíkâ Yẽhõrámã. Gõꞌdá Yẽhõrámã tı̣̂ íyíkâ Ũzı̣́yạ̃. ");
INSERT INTO avu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Gõꞌdá Ũzı̣́yạ̃ lôfõ íyíkâ Yõtámã. Gõꞌdá Yõtámã tı̣̂ íyíkâ Ãházã. Gõꞌdá Ãházã tı̣̂ íyíkâ Ẽzẽkíyã. ");
INSERT INTO avu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Gõꞌdá Ẽzẽkíyã tı̣̂ íyíkâ Mãnásẽ. Mãnásẽ gõ tı̣̂ íyíkâ Ãmónã. Gõꞌdá Ãmónã tı̣̂ íyíkâ Yõsíyã. ");
INSERT INTO avu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Gõꞌdá Yõsíyã tı̣̂ íyíkâ Yẽhõyãkínĩ yî ậdrúpı̣̃ lâ yí bê. Ótrõ gólĩyî trá ndrô gólâ õjílã ãwã drí õjílã Ĩsĩrãꞌélẽ kâ ûrúzó ạ̃jú ꞌásĩ âjílí ꞌbạ̃drı̣̃ lídí ꞌá Bãbĩlónã ꞌálâ rĩlí tólâ ndrô dũû sĩ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Gõꞌdá ózõwá gólĩyî îtõlé ndrô gólâ õjílã Ĩsĩrãꞌélẽ kâ rũzó âjílí Bãbĩlónã ꞌálâ rî vósĩ rî cãlé bũúũ ndrô Yésũ rî tı̣̃zó rî ꞌá rî rĩꞌá ĩyî õzõ nõô rî ꞌbá yî tí. Yẽhõyãkínĩ tı̣̂ Sẽyãlẽtélẽ. Gõꞌdá Sẽyãlẽtélẽ tı̣̂ íyíkâ Zãrãbãbálã. ");
INSERT INTO avu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Gõꞌdá Zãrãbãbálã tı̣̂ íyíkâ Ạ̃bı̣̃yúdạ̃. Gõꞌdá Ạ̃bı̣̃yúdạ̃ tı̣̂ íyíkâ Ẽlĩyãkímõ. Gõꞌdá Ẽlĩyãkímõ tı̣̂ íyíkâ Ãzórã. ");
INSERT INTO avu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Gõꞌdá Ãzórã tı̣̂ íyíkâ Zãdókã. Gõꞌdá Zãdókã tı̣̂ íyíkâ Ãkímã. Gõꞌdá Ãkímã tı̣̂ íyíkâ Ẽlı̣̃yúdạ̃. ");
INSERT INTO avu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Gõꞌdá Ẽlı̣̃yúdạ̃ tı̣̂ íyíkâ Ẽlẽyázã. Gõꞌdá Ẽlẽyázã tı̣̂ íyíkâ Mãtánã. Gõꞌdá Mãtánã tı̣̂ íyíkâ Yãkóbã. ");
INSERT INTO avu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yãkóbã tı̣̂ íyíkâ Yõsépã. Yõsépã ꞌdĩ íyíkâ Mãríyã rî ágó ró rî ĩꞌdî. Mãríyã íyíkâ Yésũ gólâ âꞌdó ꞌbá ꞌdíyî pã ꞌbá ró rî ândré ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ĩtí rî, gõꞌdá îtõlé Ãbãrãyámã rú sĩ cãlé bũúũ kúmú Dạ̃wúdı̣̃ rú rî, ózõwá ândâ rû trá mûdrı̣́-drı̣̃-lâ-ngâ-sû. Gõꞌdá kpá îtõlé Dạ̃wúdı̣̃ rú sĩ cãlé bũúũ kậyı̣̂ õjílã Ĩsĩrãꞌélẽ kâ trõzó Bãbĩlónã ꞌálâ rî, ózõwá ândâ rû kpá trá mûdrı̣́-drı̣̃-lâ-ngâ-sû. Gõꞌdá îtõlé ndrô õjílã Ĩsĩrãꞌélẽ kâ trõzó Bãbĩlónã ꞌálâ rî ꞌá cãlé bũúũ Yésũ Krístõ rî tı̣̃rı̣̃ ꞌá rî, ózõwá ândâ rû kpá trá mûdrı̣́-drı̣̃-lâ-ngâ-sû. ");
INSERT INTO avu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tã gólĩyî rû ꞌẽ ꞌbá Yésũ Krístõ rî tı̣̃tı̣̃ tãsĩ rî âꞌdô trá nõtí, gólâ rî ândré Mãríyã óndrê trá ꞌẽꞌá gĩlâ õkó ró Yõsépã drí. Gõꞌdá drẽ ãkpãkãꞌdã Yõsépã yî drí rĩ ãkó Mãríyã bê võ ãlô ꞌá õzõ ágó yî drí rĩrĩ rĩlí õkó bê rî kâtí rî, Mãríyã ûsû võ lâ trá kĩ, yí ꞌbã rû trá mvá bê mbârâkã Líndrí Tãndí Ôvârí kâ rî kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gõꞌdá Yõsépã nı̣̃ bê trá kĩꞌá nĩ rî, Mãríyã trá cú õtô bê ĩtí rî, gólâ lẽé kô ãnyĩ lôgõlé Mãríyã drı̣̃ı̣̂. Gólâ ı̣̂sũ tã trá ꞌẽzó Mãríyã rî âyélé ı̣̃nı̣́nı̣̂ ró võ lâ ûsú ãkó, tãlâ gólâ rĩꞌá ãgô tãndí ꞌî. ");
INSERT INTO avu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Gõꞌdá Yõsépã õtírĩ rĩî tã rî ꞌdĩ ı̣̂sũlı̣́ ꞌẽꞌá ꞌẽlâ rî, nyĩî ró, mãlãyíkã Ôvârí kâ drí rû âꞌdázó gólâ drí âbĩ-âbĩ ꞌá tã âtálé gólâ drí kĩ, “Yõsépã, Dạ̃wúdı̣̃ rî ózõwá, ní ꞌê ũrı̣̃ kô Mãríyã rî trõlé ánî õkó ró, tãlâ gólâ ꞌbã rû mvá bê ꞌdĩ mbârâkã Líndrí Tãndí Ôvârí kâ rî kâ sĩ. Âꞌdó kô ãgô ãzâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gólâ âꞌdô mvá ágó tı̣̃ꞌá, gõꞌdá ní âꞌdô rú lâ zı̣̃ꞌá Yésũ, tãlâ gólâ âꞌdô õjílã íyíkâ pãꞌá tã õnjí gólĩyíkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Gõꞌdá Yõsépã njı̣̃ bê lı̣̃fı̣́ ậꞌdú ꞌásĩ rî, drílâ gõzó tã rî ꞌdĩ ꞌẽlé, té õzõ mãlãyíkã drí âtálé ꞌdĩ kâtí. Gólâ drí Mãríyã rî trõzó íyî õkó ró, gõꞌdá gólâ ậyı̣́ Mãríyã bê õkó ró kô cãlé bũúũ kậyı̣̂ Mãríyã drí mvá tı̣̃zó rî ꞌá. Gõꞌdá útı̣̂ bê mvá rî ꞌdĩ rî, Yõsépã drí rú lâ zı̣̃zó Yésũ. Tã Yésũ rî tı̣̃ kâ ꞌê rû ĩtí ꞌdĩ, tãlâ tã gólâ Ôvârí drí âtálé trá ạ̃kû ró nã ꞌbá yî sĩ tã ậngũ ꞌbá íyíkâ Ĩsáyã sı̣́ rî ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró kĩꞌá nĩ rî, “Ízámvá gólâ tã ãgô kâ nı̣̃ ꞌbá drẽ kô rî âꞌdô ꞌẽꞌá rû ꞌbãlé ꞌâ bê. Gólâ âꞌdô ꞌẽꞌá mvá ágó tı̣̃lı̣́, áâꞌdô rú lâ zı̣̃ꞌá Ĩmánõwẽlẽ.” Ĩsáyã 7.14 Rú Ĩmánõwẽlẽ ꞌdĩ, tã ífí lâ kĩ, Ôvârí bê rĩꞌá ãmá bê. ");
INSERT INTO avu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Útı̣̂ Yésũ Bẽtẽlémẽ ꞌá ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ ꞌá. Ndrô gólâ rî tı̣̃zó ꞌdĩ ꞌá rî, Ẽródẽ ĩꞌdî kúmú ạ́ngı̣́ ꞌî ꞌbạ̃drı̣̃ rî ꞌdĩ drı̣̃lı̣́. Gõꞌdá Yésũ rî tı̣̃tı̣̃ vósĩ rî, tã nı̣̃ ꞌbá ãzâ ꞌbá yî gólĩyî rĩ ꞌbá tã ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ drí rĩꞌá âꞌdálâ rî nı̣̃lı̣́ rî drí ângázó ânĩlí võ jẽjẽ ꞌásĩ ómvórẽ lésĩ âcálé Yẽrõsãlémã ꞌá, tãlâ ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ ãzâ drı̣̃ gólĩyî trá jạ̃rı̣́bạ̃ rî ꞌdĩ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Gõꞌdá gólĩyî câ bê tólâ rî, drílĩyî rĩzó tã îjílí kĩ nĩ rî, “Mvá gólâ tı̣̃lı̣́ nõngá ꞌbạ̃drı̣̃ nô ꞌá ꞌẽ ꞌbá âꞌdólé kúmú ạ́ngı̣́ ró ãnî õjílã Yúdạ̃ yí kâ drı̣̃lı̣́ rî bê ángô lé ró yã? Ãmâ drí ꞌbãzó drẽ ómvórẽ ꞌálâ rî, ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ ãzâ âfõ trá tã âꞌdálé ãmâ drí kĩ, úũtı̣̂ kúmú ạ́ngı̣́ trá ꞌbạ̃drı̣̃ nô ꞌá. Ĩꞌdî ãmâ drí ânĩzó nõ gólâ rî ı̣̂njı̣̃lı̣́.” ");
INSERT INTO avu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Gõꞌdá tã ꞌdî ꞌdê bê kúmú ạ́ngı̣́ Ẽródẽ bı̣́lı̣́ rî, drílâ âꞌdózó tã ı̣̂sũ ró rõô, tãlâ gólâ ı̣̂sũ tã trá kĩ nĩ rî, kúmú óꞌdí ꞌdĩ ãꞌdô trá ânĩꞌá kũmũ trõlé yí drı̣́gạ́ sĩ. Gõꞌdá tã ꞌdî drí õjílã dũû Yẽrõsãlémã ꞌá rî ꞌbãzó kpá âꞌdólé tã ı̣̂sũ ró. ");
INSERT INTO avu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tã rî ꞌdĩ tãsĩ rî, kúmú ạ́ngı̣́ Ẽródẽ drí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ậzı̣́zó gõꞌdá kpá lãꞌbí îmbá ꞌbá yí bê ndrĩ ꞌdó ânĩlí yí ngálâ. Drílâ gólĩyî îjízó kĩ, “Úlı̣́ tã ậngũ ꞌbá Ôvârí kâ rî ꞌbá yí kâ vó ró rî, áâꞌdô kúmú ꞌẽ ꞌbá âꞌdólé ꞌdíyî pã ꞌbá ró rî tı̣̃ꞌá ángô lé yã?” ");
INSERT INTO avu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gõꞌdá drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó kúmú Ẽródẽ drí kĩ, “Ôvârí kĩ, áâꞌdô gólâ rî tı̣̃ꞌá Bẽtẽlémẽ ꞌá ꞌbạ̃drı̣̃ ãmákâ Yũdạ́yạ̃ kâ ꞌá nõngá, õzõ tã ậngũ ꞌbá Míkã drí tã lâ îgĩlí trá ạ̃kû ró rî kâtí kĩꞌá nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bẽtẽlémẽ ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ ꞌá, ní âꞌdô kpálé jạ̃rı̣́bạ̃ fínyáwá ró rî, tã áníkâ lậvũ trá gạ̃rạ̃ jạ̃rı̣́bạ̃ ãzí drı̣̃ı̣̂ sĩ, tãlâ áâꞌdô kúmú ạ́ngı̣́ lôfõꞌá ní ꞌásĩ. Gólâ âꞌdô ꞌẽꞌá ꞌbãlé lôkí ꞌbá ró õjílã ámákâ Ĩsĩrãꞌélẽ kâ drı̣̃lı̣́.’ ” ");
INSERT INTO avu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Gõꞌdá nĩngá sĩ rî, kúmú Ẽródẽ drí tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yî ậzı̣́zó ânĩlí yí ngálâ ı̣̃nı̣́nı̣̂ ró, tãlâ gólâ lẽ kậyı̣̂ sı̣́sı̣́ gólâ ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ drí âfõzó ꞌá lâ rî nı̣̃lı̣́ gólĩyî tı̣́ sĩ, tãlâ yí ũnı̣̃ ró kậyı̣̂ mvá rî ꞌdĩ tı̣̃zó ꞌá lâ rî bê. ");
INSERT INTO avu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Gõꞌdá tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yî lôgõ tã-drı̣̃ tã îjî gólâkâ ꞌdĩ kâ gólâ drí bê rî, gólâ drí gólĩyî âdózó kĩ nĩ rî, “Nĩ nĩ mvá ꞌdĩ lôndãlé. Õzõ nĩ ũûsû gólâ trá rî, nĩ lôgõ tã lâ má drí, má nĩ ró bê kpá gólâ rî ı̣̂njı̣̃lı̣́.” Gõꞌdá Ẽródẽ drí tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yî jõzó nĩlí Bẽtẽlémẽ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nĩngá sĩ, gólĩyî drí rĩrĩ nĩlí Bẽtẽlémẽ ꞌálâ rî sĩ rî, gólĩyî drí kpá ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ ãlô-ãlô drílĩyî ndrẽlé trá ómvórẽ ꞌálâ rî ndrẽzó óꞌdí. Gõꞌdá gólĩyî ndrê ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ ꞌdĩ bê rî, gólĩyî drí âꞌdózó ãyĩkõ ãmbá sĩ. Ị̃ꞌbı̣̂ꞌbı̣̂wạ́ rî ꞌdĩ drí ꞌdẽzó gólĩyî drí sı̣́sı̣́, gõꞌdá nĩzó âdrélé té võ mvá bê rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gõꞌdá gólĩyî câ bê tólâ rî, drílĩyî fĩzó jó mvá bê rî ꞌá mvá ûsúlı̣́ ândrê lâ Mãríyã bê. Gõꞌdá drílĩyî ꞌãꞌî tı̣̃zó vũdrı̣́ mvá ꞌdĩ ı̣̂njı̣̃zó. Drílĩyî ngá fẽfẽ ĩyíkâ âꞌdó ꞌbá dáãbõ ró, dõ rúꞌbạ́ kâ zı̣̃lı̣́ múrạ̃, gõꞌdá kpá ngá tãndí ạ̃jı̣́ bê rî ꞌbá yí bê lôfõzó fẽlé mvá ꞌdĩ drí. Ngá fẽfẽ ꞌdî ꞌbá yî lâgî lâ lậvũ gạ̃rạ̃. ");
INSERT INTO avu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gõꞌdá tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yî ꞌê bê gõlé ꞌbạ̃drı̣̃ ĩyíkâ ꞌálâ rî, Ôvârí drí gólĩyî lı̣̃fı̣́ îmbázó âbĩ-âbĩ ꞌá kĩ nĩ rî, gólĩyî õgõ ĩyî kô kôrô Ẽródẽ drı̣̃ı̣̂ sĩ, tãlâ gólĩyî õzó mvá ꞌdĩ võ lâ âꞌdá Ẽródẽ drí kô. Gõꞌdá gólĩyî drí ngãzó gõlé ĩyî drí ꞌbạ̃drı̣̃ ꞌálâ lạ́tı̣̂ ngĩî ãzâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gõꞌdá gõgõ tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yí kâ rî vósĩ rî, mãlãyíkã Ôvârí kâ drí rû âꞌdázó kpá óꞌdí Yõsépã drí âbĩ-âbĩ ꞌá tã âtálé gólâ drí kĩ, “Ní ngâ ꞌwãâ ûrû mvá ꞌdĩ trõlé ândrê lâ bê, nĩ râ ró ĩꞌdí bê lâ ꞌbạ̃drı̣̃ Mạ́sı̣̃rı̣̃ kâ ꞌálâ, tãlâ Ẽródẽ rĩꞌá mvá ꞌdĩ lôndãꞌá ꞌẽꞌá fũlâ! Ĩtí rî, nĩ nĩ rĩlí Mạ́sı̣̃rı̣̃ ꞌá tólâ, té õzõ má ãâtâ tã trá ãnî drí rî, nĩ gõ ró bê âgõlé.” ");
INSERT INTO avu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gõꞌdá Yõsépã drí tã ꞌdî ꞌẽzó té õzõ mãlãyíkã drí âtálé trá gólâ drí rî kâtí. Ngạ́cı̣̂ rî gógó ꞌdĩ sĩ rî, gólâ drí ngãzó mvá ꞌdĩ trõlé ândrê lâ bê rãzó Mạ́sı̣̃rı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Gõꞌdá drílĩyî rĩzó Mạ́sı̣̃rı̣̃ ꞌá tólâ cãlé bũúũ ndrô kúmú Ẽródẽ drí drãzó rî sĩ. Tã ꞌdî ꞌê rû ĩtí ꞌdĩ, tãlâ úlı̣́ Ôvârí drí âtálé trá tã ậngũ ꞌbá íyíkâ sĩ kĩꞌá nĩ rî, “Má ậzı̣̂ ámâ mvá âfõlé Mạ́sı̣̃rı̣̃ ꞌásĩ” rî ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gõꞌdá nĩngá sĩ rî, kúmú Ẽródẽ nı̣̃ bê trá kĩꞌá nĩ rî, tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yî ꞌé tã yí drí ꞌbãlé gólĩyî drí rî kôꞌdáwá rî, gólâ drí ꞌbãzó õmbã ró rõô. Gõꞌdá nĩngá sĩ rî, drílâ tã ꞌbãzó ạ̃jú ꞌbũ ꞌbá íyíkâ rî ꞌbá yî drí kĩ, “Nĩ nĩ ꞌdĩyímvá õnyíkõ ágó ró îtõlé gólĩyî cã ꞌbá drẽ ndrô ãlô kô rî ꞌbá yî rú sĩ cãlé bũúũ gólĩyî ndrô lâ yî drí cãlé rı̣̃ rî ꞌbá yî rú rî ûfúlı̣́ Bẽtẽlémẽ ꞌá gõꞌdá kpá võ âꞌdó ꞌbá ãnyî Bẽtẽlémẽ lạ̃gạ́tı̣́ rî ꞌbá yî ꞌásĩ ndrĩ.” Gólâ ꞌbã tã ꞌdî ĩtí ꞌdĩ rî, tãlâ kậyı̣̂ sı̣́sı̣́ gólâ ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ ꞌdĩ drí âfõzó ꞌá lâ tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yî drí âꞌdálé gólâ drí rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gõꞌdá ĩzã gólâ tã ậngũ ꞌbá Yẽrẽmíyã drí âtálé trá ạ̃kû ró jạ̃rı̣́bạ̃ Rámã kâ tãsĩ rî drí rû ꞌẽzó ĩtí Bẽtẽlémẽ ꞌá ꞌdĩyímvá ꞌdĩ ꞌbá yî ûfû-ûfû lâ yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Gólâ kĩ, “Áârî ãwó lúlũ bê Rámã ꞌálâ. Õkó Ĩsĩrãꞌélẽ kâ rî ꞌbá yî rî ĩyî nĩ ãwó ngõlé mvá lâ yî ôdrã ꞌbá trá rî tãsĩ. Gõꞌdá gólĩyî lẽé kô ãwô ngõngõ ꞌdî âyélé mvá lâ yî ôdrã ꞌbá rî ꞌbá yî tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gõꞌdá kúmú ạ́ngı̣́ Ẽródẽ drã bê rî, nyĩî ró, mãlãyíkã Ôvârí kâ drí rû âꞌdázó Yõsépã drí Mạ́sı̣̃rı̣̃ ꞌálâ âbĩ-âbĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Drílâ tã âtázó Yõsépã drí kĩ, “Ní ngâ, ní trõ mvá ꞌdĩ ândrê lâ bê, nĩ nĩ ró gõlé gólĩyí bê ꞌbạ̃drı̣̃ Ĩsĩrãꞌélẽ kâ rî ꞌálâ, tãlâ õjílã gólĩyî lẽ ꞌbá mvá ꞌdĩ fũlı̣́ rî ꞌbá yî ôdrã ĩyî trá ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gõꞌdá úlı̣́ mãlãyíkã drí âtálé ꞌdĩ drí sĩ rî, Yõsépã drí ngãzó mvá ꞌdĩ trõlé ândrê lâ bê gõzó gólĩyí bê ꞌbạ̃drı̣̃ Ĩsĩrãꞌélẽ kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gõꞌdá Yõsépã õtírĩ tã ârí kĩꞌá nĩ rî, kúmú Ẽródẽ rî mvá rú bê Ãrĩkẽlásã rî õrî trá kúmú ró átá lâ rî võ ꞌá ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ drı̣̃lı̣́ rî, gólâ drí âꞌdózó ũrı̣̃ ró nĩꞌá gõlé tólâ. Gõꞌdá Ôvârí drí lı̣̃fı̣́ lõmbâ fẽzó Yõsépã drí âbĩ-âbĩ ꞌá, gólâ õnĩ kô gõlé ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ rî ꞌálâ. Tã rî ꞌdĩ tãsĩ rî, gólâ drí ngãzó nĩlí ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ĩtí rî, gõꞌdá Yõsépã yî drí nĩzó rĩlí jạ̃rı̣́bạ̃ Nãzãrétã kâ ꞌálâ. Tã ꞌdî ꞌê rû trá ĩtí ꞌdĩ, tãlâ úlı̣́ gólĩyî tã ậngũ ꞌbá ãzâ drí âtálé trá ạ̃kû ró ꞌdíyî pã ꞌbá tãsĩ kĩꞌá nĩ rî, áâꞌdô gólâ rî zı̣̃ꞌá Nãzãrétã lé ꞌbá ró rî, ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gõꞌdá Yésũ mbâ bê âcálé ãgô ạ́ngı̣́ ró rî, Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî drí âcázó õmã ꞌálâ ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ ꞌá. Gólâ drí îtõzó rĩꞌá tã pẽlé õjílã drí kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nĩ âjâ drı̣̃ vólé tã õnjí ãníkâ rî ꞌbá yî ꞌásĩ, tãlâ ꞌdíyî pã ꞌbá gólâ Ôvârí drí tã lâ ꞌbãlé âjólé rî trá ãnyî ꞌẽꞌá âcálé âꞌdólé kúmú ró ãnî drı̣̃lı̣́.” ");
INSERT INTO avu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yõwánĩ ĩꞌdî õjílã tíbê tã ậngũ ꞌbá Ĩsáyã drí tã lâ ậngũlı̣́ ạ̃kû ró nã sĩ kĩꞌá nĩ rî, “Õjílã ãzâ bê õmã ꞌálâ, rĩꞌá tã îyáꞌá ngbạ́lạ́-ngbạ́lạ́ kĩ, ‘Nĩ êdê lạ́tı̣̂ njãâ Kúmú ãníkâ drí ânĩzó ꞌálâ sĩ. Nĩ êdê lạ́tı̣̂ lâ ꞌdĩ ãꞌdô ró mbı̣̂ drílâ lậmúzó ꞌálâ sĩ rî.’ ” ");
INSERT INTO avu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yõwánĩ rî ꞌdĩ ítá drílâ rĩꞌá sõlâ rî éêdê trá gámẽlẽ ꞌbí ꞌásĩ. Gõꞌdá gásĩ gólâ drí rĩꞌá ômbélâ íyî ı̣́pı̣́tı̣́kû ꞌá rî éêdê trá ínyíríkó ꞌásĩ. Gõꞌdá gólâ rî ômbí nyãlé ĩꞌdî ápé õgó kâ bê. ");
INSERT INTO avu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Gõꞌdá nĩngá sĩ rî, õjílã dũû ârî tã bê tã pẽpẽ Yõwánĩ kâ fạ́fạ̃ áyágá Jõrõdénĩ kâ rî ꞌálâ rî tãsĩ rî, drílĩyî ngãzó rĩꞌá ĩyî ânĩlí Yõwánĩ ngáá tólâ. Õjílã rî ꞌdĩ ꞌbá yî ũrûkậ lâ yî ânĩ trá Yẽrõsãlémã lésĩ, gõꞌdá ãzâ ꞌbá yî ânĩ trá võ ãzâ ꞌbá yî ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ rî kâ ꞌásĩ, gõꞌdá ãzâ ꞌbá yî ânĩ ĩyíkâ trá ꞌbạ̃drı̣̃ gólâ ãnyî áyágá Jõrõdénĩ rî lạ̃gạ́tı̣́ rî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gõꞌdá õjílã ꞌdî ꞌbá yî ârî ĩyî úlı̣́ Yõwánĩ kâ ꞌdĩ bê rî, drílĩyî tã õnjí ĩyíkâ lôfõzó. Ĩtí rî, gõꞌdá Yõwánĩ drí bãbãtízĩ ꞌẽzó gólĩyî drí áyágá Jõrõdénĩ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kậyı̣̂ nã ꞌbá yî sĩ rî, õjílã gólĩyî zı̣̃lı̣́ Pạ̃rúsı̣̃ ró rî ꞌbá yî gõꞌdá kpá gólĩyî zı̣̃lı̣́ Sạ̃dúsı̣̃ ró rî ꞌbá yí bê, drílĩyî ânĩzó Yõwánĩ ngálâ, tãlâ Yõwánĩ ĩîbábátízã ró ĩyî bê. Gõꞌdá Yõwánĩ nı̣̃ âꞌdô-âꞌdô gólĩyíkâ trá. Gólâ drí tã âtázó drílĩyî kĩ, “Ãnî rĩꞌá nyé õzõ ı̣̃nı̣̃ gólĩyî rĩ ꞌbá rãlé vólé lạ̃sı̣́ ũrı̣̃ drí sĩ rî ꞌbá yí kâtí. Nĩ ı̣̂sũ ãníkâ bê rî, nĩ âꞌdô ꞌẽꞌá ngá pãlé õmbã Ôvârí kâ ꞌásĩ cé bãbãtízĩ sĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Õzõ nĩ õlẽ trá ngá pãlé rî, ꞌdõvó nĩ âjâ drı̣̃ vólé tã õnjí ãníkâ ꞌásĩ. Ĩtí rî, tã ꞌẽꞌẽ tãndí ãníkâ âꞌdô âꞌdóꞌá õzõ lõꞌwâ tãndí kâtí, tãlâ áâꞌdâ ró bê kĩ pạ̃tı̣́ı̣̃ nĩ âjâ drı̣̃ trá vólé tã õnjí ãníkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Gõꞌdá nĩ âyê tã ı̣̂sũ ãníkâ kĩꞌá nĩ rî, nĩ ãꞌdô ꞌẽꞌá ãnî nyãányâ pãlé õmbã Ôvârí kâ ꞌásĩ, tãlâ ãnî rĩꞌá Ãbãrãyámã rî ózõwá yî ĩꞌdî rî. Tã ꞌdî îcá kô ãnî pãlé. Nĩ ârî drẽ, Ôvârí rĩꞌá mbârâkã bê kúnı̣́ mvá nõ ꞌbá yî ôjázó Ãbãrãyámã rî ózõwá yî ró ãnî võ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ãnî rĩꞌá õzõ fê ı̣̂ꞌdı̣́lı̣́ rî kâtí ı̣̃nyạ́kú nõ drı̣̃ı̣̂. Ôvârí ꞌbã ôlówá trá njãâ fê gólĩyî ꞌwã ꞌbá kô rî yî âgãzó vũdrı̣́. Ôvârí âꞌdô ngá-ạ̃rú gólâ ꞌwã ꞌbá kô rî zãꞌá õzõ tõtõ kâtí lạ̃sı̣́ gólâ rĩ ꞌbã vẽlé ạ̃dũkũ ãkó rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Gõꞌdá Yõwánĩ drí kpá tã îyázó õjílã drí ndrĩ kĩ, “Má rî bãbãtízĩ ꞌẽlé ãnî drí cé lũmvû sĩ, ꞌdĩî ãâꞌdâ ró tã bê kĩ, nĩ âjâ drı̣̃ trá vólé tã õnjí ãníkâ ꞌásĩ. Gõꞌdá õjílã ãzâ bê ꞌẽ ꞌbá âcálé má vósĩ. Ãmbã õjílã rî ꞌdĩ kâ lậvũ gạ̃rạ̃ ámákâ rî drı̣̃ı̣̂ sĩ. Má âꞌdó kô tãndí ró îcálé káꞌbókã gólâkâ trõlé. Gólâ âꞌdô bãbãtízĩ ꞌẽꞌá õjílã drí Líndrí Tãndí Ôvârí kâ sĩ gõꞌdá kpá lạ̃sı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gólâ trá njãâ ꞌẽꞌá ạ̃drúgú íyíkâ cãlé. Ĩtí rî, gólâ âꞌdô ạ̃drúgú ífí tãndí rî ꞌbá yî êléꞌá ꞌbãlé ẽró ꞌá. Gõꞌdá gólâ âꞌdô ạ̃drúgú kúrũmû êꞌbéꞌá vẽlé lạ̃sı̣́ ꞌá zãâ bạ̃dı̣̃.” ");
INSERT INTO avu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nĩngá sĩ rî, Yésũ drí ngãzó jạ̃rı̣́bạ̃ íyíkâ Gãlĩláyã ꞌá rî âyélé nĩzó cãlé áyágá Jõrõdénĩ rî ꞌálâ, tãlâ Yõwánĩ õꞌê ró bãbãtízĩ bê yí drí. ");
INSERT INTO avu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Gõꞌdá Yõwánĩ ârî tã Yésũ drí lẽlé yí drí ꞌẽlé rî bê rî, gólâ lẽé kô Yésũ rî îbábátízãlé, tãlâ ãmbã Yésũ kâ lậvũ gạ̃rạ̃ ãmbã gólâkâ rî drı̣̃ı̣̂ sĩ. Gólâ kĩ Yésũ drí rî, “Ní ânĩ má drí bãbãtízĩ ꞌẽzó ní drí ãꞌdô tãsĩ yã? Ní âꞌdô bãbãtízĩ ꞌẽꞌá bê-rî nĩ má drí.” ");
INSERT INTO avu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó Yõwánĩ drí kĩ, “Ní ꞌê bãbãtízĩ nĩ má drí, tãlâ mã ꞌê ró tã mbı̣̂ gólâ Ôvârí drí lẽlé ãmâ drí ꞌẽlé rî ꞌbá yî bê.” Gõꞌdá Yõwánĩ ârî úlı̣́ Yésũ kâ ꞌdĩ bê rî, gólâ drí tã-drı̣̃ lẽzó Yésũ rî îbábátízãzó. ");
INSERT INTO avu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gõꞌdá Yõwánĩ îbábátízã Yésũ bê rî, Yésũ õtírĩ íyî drı̣̃ îngá lı̣̃mvû ꞌásĩ rî, gõꞌdá kôrô ꞌbũû drí rû njı̣̃zó, gõꞌdá Yésũ drí Líndrí Tãndí Ôvârí kâ ndrẽzó ânĩrĩ ꞌá õzõ ạ̃túꞌbú kâtí ꞌdẽlé yí drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gõꞌdá gbórókõ drí ậꞌúzó ûrú lésĩ úlı̣́ âtâ-âtâ bê kĩ nĩ rî, “Nõô ámâ mvá gólâ má drí lẽlé tákányĩ rî ĩꞌdî. Gólâ rî tã sû trá má rú rõô.” ");
INSERT INTO avu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gõꞌdá nĩngá sĩ rî, Líndrí Tãndí Ôvârí kâ drí Yésũ rî trõzó âjílí õmã ꞌálâ, tãlâ Sãtánã ũûjũ ró gólâ bê. ");
INSERT INTO avu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Gólâ drí rĩzó õmã ꞌá tólâ kậyı̣̂ nyâꞌdî-rı̣̃ ı̣̃tú sĩ gõꞌdá kpá ngạ́cı̣̂ sĩ ꞌálé ꞌãꞌí sĩ. Tã rî ꞌdĩ tãsĩ rî, lõfó ꞌê gólâ trá rõô. ");
INSERT INTO avu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gõꞌdá ꞌdĩî vósĩ rî, Sãtánã drí ânĩzó Yésũ rî ûjũlı̣́ kĩ, “Õzõ ní ãꞌdô fí Ôvârí rî mvá ꞌî rî, ꞌdõvó ní ꞌbã tã kúnı̣́ mvá nõ ꞌbá yî õjâ ró rû bê ãmbãtã ró ní drí nyãlé lõfó drí sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó Sãtánã drí kĩ, “ꞌÉꞌẽ, tã îgĩ Ôvârí kâ âtâ tã trá kĩ, ‘Õjílã ĩîcá kô rĩlí cé ngá nyãnyã sĩ. Ngá ãzâ lậvũ ꞌbá ngá nyãnyã drı̣̃ı̣̂ sĩ kôrô rî kpá bê, rĩꞌá tákõ ĩꞌdî úlı̣́ ndrĩ gólĩyî Ôvârí drí âtálé õjílã drí rî ꞌbá yî ĩꞌdî.’ ” ");
INSERT INTO avu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Gõꞌdá nĩngá sĩ rî, Sãtánã drí kpá Yésũ rî âtrõzó õmã lésĩ âjílí jạ̃rı̣́bạ̃ Ôvârí kâ Yẽrõsãlémã rî ꞌá. Gõꞌdá Sãtánã drí mbãzó gólâ bê jó ạ́ngı̣́ Ôvârí kâ rî ãpírĩ lâ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Gõꞌdá Sãtánã drí kpá tã âtázó Yésũ drí kĩ, “Õzõ ní ãꞌdô fí Ôvârí rî mvá ꞌî rî, ꞌdõvó ní wã drẽ jó nõ drı̣̃ı̣̂ sĩ ꞌdẽlé vũdrı̣́ ꞌálâ, ãâꞌdâ ró kĩ nĩ rî, Ôvârí lôkî nî trá rõô, tãlâ íîgĩ trá búkũ Ôvârí kâ ꞌá kĩ nĩ rî, ‘Ôvârí ꞌbã tã trá mãlãyíkã íyíkâ yî drí ánî tãsĩ rĩzó ánî vó ndrẽlé. Gólĩyî âꞌdô ánî lôkóꞌá ĩyî drı̣́gạ́, tãlâ ngá ãzãkã õzó ánî rúꞌbạ́ dõô kô, gbõ lé ánî pá mvá õzó kpá rû sı̣̃ı̣̂ kúnı̣́ mvá rú kô.’ ” ");
INSERT INTO avu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Gõꞌdá Yésũ drí kpá tã-drı̣̃ lôgõzó Sãtánã drí kĩ, “Gõꞌdá íîgĩ kpá trá búkũ Ôvârí kâ ꞌá kĩ, ‘Ní ũûjũ Kúmú áníkâ Ôvârí kô.’ Tã ꞌBãꞌbã Ândâ 6.16 Ĩtí rî, má ûjũú Ôvârí kô.” ");
INSERT INTO avu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gõꞌdá nĩngá sĩ rî, Sãtánã drí Yésũ rî trõzó âjílí kpá únı̣́ ạ́ngı̣́ ãpírĩ ꞌálâ. Gõꞌdá Sãtánã drí ꞌbạ̃drı̣̃ ãmbá ãngó nõ ꞌá nõngá nõ ꞌbá yî âꞌdázó Yésũ drí âꞌdô lâ tãndí ró rî bê. ");
INSERT INTO avu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Gõꞌdá Sãtánã drí gõzó tã âtálé Yésũ drí kĩ, “Ngá gólĩyî ndrĩ ãngó nõ ꞌá nõngá nõ ꞌbá yî, mâ ĩꞌdî lı̣́pı̣̂ lâ ꞌî. Õzõ ní ũtı̣̃ ꞌãꞌî trá má ândrá ámâ ı̣̂njı̣̃zó kúmú ró rî, má âꞌdô ngá ꞌdĩ ꞌbá yî fẽꞌá ndrĩ ní drí.” ");
INSERT INTO avu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó Sãtánã drí kĩ, “Sãtánã, ní âyê mâ! Íîgĩ trá búkũ Ôvârí kâ ꞌá kĩ, ‘Kúmú Ôvârí ĩꞌdî cé Ôvârí pạ̃tı̣́ı̣̃ ãníkâ ãnî drí ı̣̂njı̣̃lı̣́ rî ĩꞌdî, gõꞌdá nĩ ı̣̂ꞌbũ rû cé gólâ drí.’ ” ");
INSERT INTO avu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nĩngá sĩ, Sãtánã lôndã lạ́tı̣̂ bê trá kpı̣̃ı̣̂ Yésũ rî pẽzó rî, gólâ drí ngãzó nĩlí Yésũ rî âyélé. Gõꞌdá kôrô mãlãyíkã drí ânĩzó gólâ rî pãlé. ");
INSERT INTO avu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Gõꞌdá nĩngá sĩ, gõgõ Yésũ kâ õmã ꞌásĩ rî vósĩ rî, gólâ drí tã ârízó kĩ, Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî óõꞌbã trá gạ̃nı̣́mạ̃ ꞌá. Gõꞌdá nĩngá sĩ rî, Yésũ drí ngãzó gõlé ꞌbạ̃drı̣̃ Gãlĩláyã kâ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gólâ rí kô jạ̃rı̣́bạ̃ íyíkâ Nãzãrétã rî ꞌálâ. Gõꞌdá drílâ ngãzó lậvũlı̣́ nĩꞌá rĩlí jạ̃rı̣́bạ̃ zı̣̃lı̣́ Kãpẽrãnómã rî ꞌálâ, tíbê âꞌdó ꞌbá ãnyî lı̣̃mvû ândrê Gãlĩláyã kâ rú rî. ꞌDĩî ꞌbạ̃drı̣̃ ꞌbạ̃súrú zı̣̃lı̣́ Zạ̃bũlạ́nạ̃ gõꞌdá Nãfãtálĩ bê rî ꞌbá yî drí rĩzó ꞌá lâ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","17","Gõꞌdá Yésũ câ bê Gãlĩláyã ꞌá tólâ rî, gólâ drí îtõzó tã âtî-âtî tãndí Ôvârí kâ îmbálé õjílã drí. Gólâ kĩ, “Nĩ âjâ drı̣̃ vólé tã õnjí ãníkâ rî ꞌbá yî ꞌásĩ, tãlâ Ôvârí njı̣̃ lạ́tı̣̂ trá ãnî drí rĩzó kũmũ íyíkâ zẽlé õjílã íyíkâ ró.” Yésũ ꞌê tã rî ꞌdĩ tólâ ĩtí ꞌdĩ, tãlâ úlı̣́ gólĩyî tã ậngũ ꞌbá Ĩsáyã drí âtálé trá ạ̃kû ró rî ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró kĩꞌá nĩ rî, “ꞌBạ̃drı̣̃ gólâ ꞌbạ̃súrú zı̣̃lı̣́ Zạ̃bũlạ́nạ̃ gõꞌdá Nãfãtálĩ yí bê drí rĩzó ꞌá lâ ꞌbạ̃súrú ãzâ ꞌbá yî gólĩyî âꞌdó ꞌbá kô õjílã Yúdạ̃ yí kâ ró rî ꞌbá yí bê rî, ꞌbạ̃drı̣̃ Gãlĩláyã kâ ꞌdĩ îtõ áyágá Jõrõdénĩ rî ꞌásĩ nĩꞌá cãlé bũúũ lı̣̃mvû ândrê zı̣̃lı̣́ Mẽdĩtẽrénĩ rî rú. Gõꞌdá õjílã gólĩyî rĩ ꞌbá ı̣́nı̣́rı̣́kúwạ́ ꞌá ndrô dũû sĩ tólâ nã ꞌbá yî, gólĩyî âꞌdô ngá îꞌĩ ạ́ngı̣́ ndrẽꞌá. Õjílã gólĩyî rĩ ꞌbá ngá lậnjı̣̃ õdrã kâ zẽlé ꞌdĩ ꞌbá yî, ngá îꞌĩ rî ꞌdĩ âꞌdô võ îwáꞌá gólĩyî drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kậyı̣̂ ãzâ sĩ rî, Yésũ rĩꞌá nĩꞌá lı̣̃mvû ândrê Gãlĩláyã kâ gãrã drı̣̃ lâ ꞌásĩ. Gõꞌdá gólâ drí nĩzó ı̣̃ꞌbı̣̂ ꞌbẽ ꞌbá ãzâ ꞌbá yî ûsúlı̣́ rı̣̃, Sĩmónã Pétẽrõ gõꞌdá ậdrúpı̣̃ lâ Ãndĩríyã bê, gólĩyî vũ îmbá trá lı̣̃mvû ꞌá ı̣̃ꞌbı̣̂ rũzó. ");
INSERT INTO avu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kĩ, “Nĩ ânĩ ꞌdẽlé má vósĩ rî, gõꞌdá má âꞌdô ãnî ꞌbãꞌá âꞌdólé õjílã ãzí âsé ꞌbá ró, tãlâ gólĩyî ãꞌdô ró bê õjílã ámákâ ró, õzõ ãnî drí rĩrĩ ı̣̃ꞌbı̣̂ âsélé rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Gõꞌdá nĩngá sĩ, kôrô drílĩyî îmbá ĩyíkâ âyézó ꞌdẽzó Yésũ vósĩ lãjóꞌbá gólâkâ ró. ");
INSERT INTO avu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Gõꞌdá nĩngá sĩ, Yésũ yî drí ngãzó lậvũlı̣́ ạ̃tı̣́ ꞌálâ. Gólĩyî drí nĩzó Zẽbẽdáyõ rî mvá ágó rı̣̃ Yãkóbã yî ûsúlı̣́ ậdrúpı̣̃ lâ Yõwánĩ bê. Gólĩyî rĩꞌá kõlóngbõ ꞌá átá lâ yí bê îmbá ĩyíkâ lı̣̃fı̣́ lâ êdéꞌá. Gõꞌdá Yésũ drí gólĩyî ậzı̣́zó ânĩlí ꞌdẽlé yí vósĩ. ");
INSERT INTO avu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gõꞌdá ꞌwãâ ró, drílĩyî ngãzó átá lâ yî âyélé kõlóngbõ ꞌá ꞌdẽzó Yésũ vósĩ lãjóꞌbá gólâkâ ró. ");
INSERT INTO avu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nĩngá sĩ rî, Yésũ yî drí nĩzó ậcı̣́ tõ bê jạ̃rı̣́bạ̃ mvá Gãlĩláyã kâ rî ꞌbá yî ꞌásĩ. Gõꞌdá võ rî ꞌdĩ ꞌbá yî ꞌásĩ rî, gólâ rî trá nĩꞌá õjílã lı̣̃fı̣́ îmbá bê tã âtî-âtî tãndí kũmũ Ôvârí kâ rî kâ tãsĩ jó tã Ôvârí kâ ârî kâ rî ꞌásĩ. Gõꞌdá gólâ nĩ kpá trá õjílã gólĩyî ngá lãzé tı̣̂ ngĩíngî bê rî êdé bê ngá lãzé gólĩyíkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tã rî ꞌdĩ tãsĩ rî, mbârâkã Yésũ kâ rĩzó ngá lãzé ꞌbá êdélé ꞌdĩ tã lâ drí lậꞌbúzó ꞌbạ̃drı̣̃ Sírĩyã kâ ꞌásĩ ndrĩ. Ĩtí rî, gõꞌdá õjílã Sírĩyã kâ rî ꞌbá yî drí õjílã gólĩyî ngá lãzé tı̣̂ ngĩíngî bê rî ꞌbá yî âjízó dũû Yésũ ngálâ. Gõꞌdá Yésũ êdê õjílã gólĩyî ngá lãzé lâ drí lâzélé rõô rî ꞌbá yî trá ngá lãzé gólĩyíkâ ꞌdĩ ꞌbá yî ꞌásĩ. Gõꞌdá gólâ lâdrô líndrí õnjí kpá trá õjílã gólĩyî líndrí õnjí drí ômbélé trá rî ꞌásĩ. Gõꞌdá gólâ êdê õjílã gólĩyî ngbãꞌó bê rî ꞌbá yî trá. Gõꞌdá gólâ êdê gólĩyî pá lâ yî drí drãlé trá ậcı̣́ tõ ꞌbá kô rî yî kpá trá, drílĩyî ậcı̣́ tõzó. ");
INSERT INTO avu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gõꞌdá tã rî ꞌdĩ ꞌbá yî tãsĩ rî, õꞌbí ãmbá ânĩ trá Yésũ ngálâ võ ngĩíngî ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî ꞌásĩ, kpá jạ̃rı̣́bạ̃ gólĩyî mûdrı̣́ lı̣̃mvû ândrê Gãlĩláyã kâ gãrã drı̣̃ lâ ãzâ rî lésĩ, Yẽrõsãlémã lésĩ gõꞌdá kpá võ ãzâ ꞌbá yî Yũdạ́yạ̃ kâ rî ꞌbá yî ꞌásĩ, gõꞌdá võ ãzâ ꞌbá yî áyágá Jõrõdénĩ ꞌdĩ ꞌáꞌá lé drı̣̃ lâ lésĩ rî ꞌásĩ. Gólĩyî ânĩ trá ndrĩ ꞌdẽlé Yésũ vósĩ. ");
INSERT INTO avu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gõꞌdá Yésũ ndrê bê õjílã õꞌbí ꞌdĩ ꞌbá yî rî, drílâ nĩzó rĩlí vũdrı̣́ únı̣́ pá ꞌálâ. Gõꞌdá tã ârí ꞌbá yî drí nĩzó kpá únı̣́ pá ꞌá tólâ õꞌbí ꞌdĩ ꞌbá yí bê, drílĩyî nĩzó rû êꞌbélé gbãâ Yésũ rú sĩ. ");
INSERT INTO avu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Gõꞌdá Yésũ drí îtõzó õjílã ꞌdî ꞌbá yî îmbálé kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Õzõ nĩ ũnı̣̃ trá kĩꞌá nĩ rî, rĩꞌá Ôvârí ĩꞌdî gólâ îcá ꞌbá mbârâkã fẽlé ãnî drí tãlâ nĩ rî mbârâkã ãkó tã gólâkâ ꞌẽlé rî, tã ãníkâ âꞌdô sũꞌá gólâ rú. Ĩtí rî, nĩ âꞌdô rĩꞌá Ôvârí bê ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Õzõ nĩ ãꞌdô ĩzã ró tã õnjí tãsĩ rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, Ôvârí âꞌdô ĩzã ãníkâ ndrẽꞌá, gõꞌdá gólâ drí ãnî pãzó ĩzã ãníkâ ꞌdĩ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Õzõ nĩ õrî cú ĩtí ãnî nyãányâ ꞌbã ãkó sı̣́sı̣́ ꞌálâ rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, Ôvârí âꞌdô ãnî ꞌbãꞌá âꞌdólé cú drı̣́-ãcê bê ãmbá. ");
INSERT INTO avu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Õzõ nĩ õlẽ tákányĩ tã mbı̣̂ Ôvârí kâ ꞌẽlé rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, Ôvârí âꞌdô mbârâkã fẽꞌá ãmbá ãnî drí tã mbı̣̂ íyíkâ ꞌẽzó ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Õzõ nĩ õrî õjílã ãzí âyélé tã õnjí drílĩyî ꞌẽlé trá ãnî rú rî ꞌásĩ rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, Ôvârí âꞌdô kpá ãnî âyéꞌá tã õnjí ãníkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Õzõ nĩ õrî tã ı̣̂sũ tãndí bê ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, nĩ âꞌdô rĩꞌá võ ãlô ꞌá Ôvârí bê gólâ rî nı̣̃lı̣́ dódó. ");
INSERT INTO avu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Õzõ nĩ õrî õjílã gólĩyî âꞌdó ꞌbá õmbã bê ĩyî lãfálé ꞌásĩ rî ꞌbá yî pãlé tã gólĩyî lãfálé ꞌásĩ rî ậꞌdı̣́lı̣́ tã tãndí sĩ rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, Ôvârí âꞌdô ãnî zı̣̃ꞌá íyî mvá yî ró. ");
INSERT INTO avu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Õzõ nĩ õrî zãâ tã mbı̣̂ Ôvârí kâ ꞌẽlé kậyı̣̂ õjílã drí lâŋõ fẽzó ãnî drí tã lâ tãsĩ rî ꞌá rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, ngá gólĩyî Ôvârí drí tã lâ ꞌbãlé ꞌẽꞌá fẽlâ õjílã íyíkâ drí rî, nĩ âꞌdô kpá ûsúꞌá lâ. ");
INSERT INTO avu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Nĩ ndrê drẽ, õzõ õjílã õlôꞌdâ ĩyî ãnî ngãtá gólĩyî õfẽ ĩyî lâŋõ ãnî drí ngãtá ãâdô ĩyî õnjõ ꞌî ãnî rú, gólĩyî drí gõzó rĩlí tã õnjí ꞌdĩ ꞌbá yî ꞌẽlé ãnî drí tãlâ ãnî rĩꞌá tã ârí ꞌbá ámákâ ĩꞌdî rî drí sĩ rî, nĩ ı̣̂sũ tã kó kô. ꞌDĩî rî kpá lâŋõ tã ậngũ ꞌbá Ôvârí kâ sı̣́sı̣́ rî ꞌbá yî drí ûsúlı̣́ rî ĩꞌdî. Õzõ nĩ ũnjû Ôvârí rî rú lûyı̣́lı̣́ fĩî ậtũ-ậtũ sĩ tã ꞌdî ꞌbá yî tãsĩ rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, nĩ âꞌdô drı̣́-ꞌâ ạ́ngı̣́ ûsúꞌá ûrú ꞌálâ Ôvârí ngálâ.” ");
INSERT INTO avu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Gõꞌdá nĩngá sĩ rî, Yésũ drí îtõzó tã ârí ꞌbá dũû ꞌdĩ ꞌbá yî îmbálé úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Ãnî nyãányâ, tã ꞌẽꞌẽ ãníkâ ãꞌdô nyé õzõ ꞌạ̃ꞌı̣́-nyá drí âꞌdórẽ tãndí ró ngá nyãnyã drí rî kâtí. Gõꞌdá õzõ nĩ ãâyê tã tãndí ꞌẽꞌẽ trá rî, ãnî drí gõzó âꞌdólé nyé õzõ ꞌạ̃ꞌı̣́-nyá gólâ âsó ꞌbá kô pẽtẽkẽ rî kâtí. Îcá kô ꞌbãlâ drílâ âsózó dódó óꞌdí, tãlâ îzã rû trá. Ĩtí rî, áâꞌdô dãꞌá lâ vũdrı̣́. ");
INSERT INTO avu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ãnî rĩꞌá kpá nyé õzõ ngá îꞌĩ gólâ võ îwá ꞌbá õjílã drí ndrĩ rî kâtí, tãlâ gólĩyî õndrê ró bê tã gólĩyî Ôvârí drí lẽlé gólĩyî drí ꞌẽlé rî bê. Kpá ĩtí, ãnî rĩꞌá nyé õzõ jạ̃rı̣́bạ̃ gólâ ꞌdı̣̃lı̣́ lũtú drı̣̃ı̣̂ ndrẽlé tõ lậpı̣́lı̣́ kô rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nĩ ndrê drẽ, õjílã ãzâ îꞌĩí lámbã íyíkâ kô ꞌbãlé jó ꞌá drı̣̃ lâ âkólé límvó sĩ. Gólâ âꞌdô ꞌbãꞌá lâ ûrû tãrãbízã drı̣̃ı̣̂ ĩîꞌĩ ró võ bê õjílã drí võ ndrẽzó dódó. ");
INSERT INTO avu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gõꞌdá kpá rĩꞌá ĩtí, nĩ ꞌbã tã ꞌẽꞌẽ ãníkâ ãâꞌdô sũsũ ró õjílã ãzí lı̣̃fı̣́ drı̣̃ ꞌá, tãlâ õzõ gólĩyî õndrê tã sũsũ ãnî drí rĩꞌá ꞌẽlâ ꞌdĩ ꞌbá yî trá rî, gólĩyî âꞌdô âꞌdóꞌá ãyĩkõ ró, gõꞌdá gólĩyî âꞌdô ãnî átá ûrú ꞌálâ rî lûyı̣́ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Gõꞌdá Yésũ drí kpá tã îmbázó tã ꞌbãꞌbã Ôvârí kâ rî tãsĩ kĩ, “Nĩ ı̣̂sũ tã kô kĩ nĩ rî, má ânĩ tã ngĩî îmbálé tã ꞌbãꞌbã Ôvârí drí fẽlé Músạ̃ sĩ gõꞌdá tã îmbâ tã ậngũ ꞌbá íyíkâ rî kâ bê rî îzãlé. Má ânĩ, tãlâ tã pạ̃tı̣́ı̣̃ tã îmbâ gólĩyíkâ ꞌdĩ ꞌbá yí kâ âꞌdálé õjílã drí. ");
INSERT INTO avu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, tã gólĩyî ndrĩ îgĩlí trá búkũ Ôvârí kâ ꞌá rî, tã îgĩ rî ꞌdĩ ꞌbá yî íîcá kô jãlâ âꞌdólé tã îgĩ ngĩî ãzâ ró úlı̣́ Ôvârí kâ drı̣̃ı̣̂ sĩ. Âꞌdô rĩꞌá ĩtí cãlé bũúũ kậyı̣̂ ạ̃dũkũ ãngó nõ kâ ꞌá. Gõꞌdá tã rî ꞌdĩ ꞌbá yî âꞌdô rû ꞌẽꞌá ĩtí, té õzõ Ôvârí drí ꞌbãlé trá rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Gõꞌdá õjílã tíbê tã ꞌbãꞌbã Ôvârí kâ ꞌbãlé ꞌẽlé rî gã ꞌbá trá dó ꞌẽzó lâ kô ngãtá drílâ õjílã ãzí îmbázó tã ꞌẽlé õzõ gólâ kâtí yã rî, Ôvârí âꞌdô kpá õjílã rî ꞌdĩ gãꞌá dó, îcá kô gólâ rî lậgúlı̣́ õjílã íyíkâ ró kũmũ íyíkâ võ ûrú ꞌálâ rî kâ ꞌá. Gõꞌdá gólâ rĩ ꞌbá tã ꞌbãꞌbã Ôvârí kâ ꞌẽlé ndrĩ gõꞌdá drílâ rĩzó õjílã ãzí îmbálé tã ꞌẽlé õzõ drílâ rĩrĩ tã rî ꞌdĩ ꞌbá yî ꞌẽlé ꞌdĩ kâtí rî, Ôvârí âꞌdô gólâ rî lậgúꞌá õjílã íyíkâ ró kũmũ íyíkâ võ ûrú ꞌálâ rî kâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nĩ ndrê drẽ, Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá rî ꞌbá yí bê, gólĩyî rî trá tã ꞌbãꞌbã Ôvârí kâ ꞌẽlé dódó. Gõꞌdá õzõ nĩ õrî kô tã gólĩyî âꞌdó ꞌbá mbı̣̂ rî ꞌẽlé lậvũlı̣́ gạ̃rạ̃ tã mbı̣̂ gólĩyî Pạ̃rúsı̣̃ yî gõꞌdá lãꞌbí îmbá ꞌbá yí bê drí rĩꞌá ꞌẽlé rî ꞌbá yî drı̣̃ı̣̂ sĩ rî, nĩ îcá kô cãlé kũmũ Ôvârí kâ võ ûrú ꞌálâ rî kâ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gõꞌdá nĩngá sĩ rî, Yésũ drí îtõzó tã îmbálé tã ngãngã kâ ạ̃wạ̃ ró rî tãsĩ. Gólâ kĩ, “Nĩ ârî tã gólâ âtálé trá ãmâ ạ́ꞌbı̣́yạ́ yî drí ạ̃kû ró Músạ̃ sĩ kĩꞌá nĩ rî, ‘Ní fû õjílã ãzí kô’ rî trá. Gõꞌdá áâtâ kpá trá kĩ, ‘Õzõ õjílã ãzâ ũfû õjílã ãzí trá rî, áâꞌdô tã kĩꞌá õjílã rî ꞌdĩ rú.’ ");
INSERT INTO avu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gõꞌdá má âtâ ãnî drí õzõ õjílã ãzâ õngâ trá ạ̃wạ̃ ró íyî ãzí-ãzí bê rî, áâꞌdô tã kĩꞌá õjílã rî ꞌdĩ rú. Gõꞌdá õzõ õjílã ãzâ ãâtâ úlı̣́ õnjí trá íyî ãzí-ãzí rú rî, tã kĩ ꞌbá yî âꞌdô tã kĩꞌá õjílã rî ꞌdĩ rú. Gõꞌdá õzõ õjílã ãzâ ũzı̣̂ íyî ãzí-ãzí trá lîfõ-lîfõ ró rî, rĩꞌá mbı̣̂ õjílã rî ꞌdĩ vũzó lạ̃sı̣́ Ôvârí drí êdélé trá Sãtánã yî drí rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Gõꞌdá ĩtí rî, nî ãzâ, õzõ ní ãânĩ trá ꞌẽꞌá ngá fẽfẽ áníkâ fẽlé Ôvârí drí võ rĩzó ngá fẽfẽ ꞌbãlé rî ꞌá rî, gõꞌdá õzõ ánî ãzí-ãzí ãꞌdô cú tã ãzâ bê ní rú rî, õzõ tã rî ꞌdĩ ãâgâ trá ní drı̣̃ı̣̂ rî, ní fẽ ngá fẽfẽ rî ꞌdĩ drẽ kô. ");
INSERT INTO avu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ní âyê ngá fẽfẽ rî ꞌdĩ ãkpã võ tã rî ꞌdĩ drí âgázó ní drı̣̃ı̣̂ ꞌdĩ ꞌá nĩngá. Mí nĩ ánî ãzí-ãzí ꞌdĩ ngálâ, nĩ êdê ró tã ãnî lãfálé ꞌásĩ ꞌdî zãlô sı̣́sı̣́, ní gõ ró bê âgõlé nĩꞌá ngá fẽfẽ áníkâ ꞌdĩ fẽlé Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Gõꞌdá õzõ õjílã ãzâ ãꞌdô cú tã bê ní rú rî, gõꞌdá õjílã rî ꞌdĩ õlẽ trá ánî âjílí kúmú ândrá tã áníkâ kĩlí rî, ní ngâ ꞌwãâ nĩlí gólâ ngálâ, nĩꞌá tã ãnî lãfálé ꞌá gólâ bê ꞌdĩ êdélé drẽ ãkpãkãꞌdã gólâ drí ánî âjí ãkó kúmú ândrá. Gõꞌdá õzõ ní ẽêdê tã rî ꞌdĩ kô rî, gólâ õtrõ nî trá nĩꞌá âjílâ kúmú ândrá rî, kúmú âꞌdô tã áníkâ kĩꞌá õnjí ró, gólâ âꞌdô ánî fẽꞌá drı̣̃-ꞌbá gạ̃nı̣́mạ̃ kâ drı̣́gạ́. Ĩtí rî, gólâ âꞌdô ánî trõꞌá ꞌbãlé gạ̃nı̣́mạ̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Má âtâ ní drí tã pạ̃tı̣́ı̣̃ ró, ní âꞌdô rĩꞌá gạ̃nı̣́mạ̃ ꞌá tólâ cãlé bũúũ ậdı̣̂ kúmú drí ꞌbãlé ní drí fẽlé rî fẽꞌá zãlô gõzó ánî lôfõlé gạ̃nı̣́mạ̃ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nĩngá sĩ, Yésũ drí kpá tã âtázó kĩ, “Nĩ ârî tã gólâ ꞌbãlé trá ạ̃kû ró ãmâ ạ́ꞌbı̣́yạ́ yî drí Músạ̃ sĩ kĩꞌá nĩ rî, ‘Nĩ ꞌbã õkó gólĩyî âꞌdó ꞌbá kô ánî õkó ró ngãtá ãgô gólĩyî âꞌdó ꞌbá kô ãnî ágó ró rî kô ãnî ũgúlı̣́ ậyı̣́zó ĩꞌdí bê lâ’ rî trá. ");
INSERT INTO avu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gõꞌdá má âtâ tã ãnî drí, õzõ ãgô ãzâ õndrê õkó ãzâ trá lôvó sĩ ậꞌdú kõzó ĩꞌdí bê lâ rî, gólâ ꞌê ꞌdĩ tã õnjí ꞌî íyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá õkó ꞌdĩ rú. ꞌDĩî kpá rĩꞌá nyé õzõ ãgô ꞌdî ꞌê tã rî ꞌdĩ trá rî kâtí. Gõꞌdá kpá rĩꞌá ĩtí õkó tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gõꞌdá âꞌdô bê trá ĩtí rî, nî ãzâ, õzõ ánî lı̣̃fı̣́ drı̣́-ágó lésĩ rî õꞌbã nî tã õnjí ꞌẽlé rî, ní ângî gólâ trúwạ́ vólé. Rĩꞌá tãndí ró ní drí cãzó võ ûrú ꞌálâ rî ꞌá cé lı̣̃fı̣́ ãlô bê, gõꞌdá ní drí cãzó lı̣̃fı̣́ bê rı̣̃ nĩꞌá vẽlé lạ̃sı̣́ gólâ Ôvârí drí êdélé Sãtánã yî drí rî ꞌá rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Gõꞌdá kpá rĩꞌá ĩtí, õzõ ánî drı̣́-ágó õꞌbã nî tã õnjí ꞌẽlé rî, ní gâ ánî drı̣́ rî ꞌdĩ njíyá vólé. Rĩꞌá tãndí ró ní drí cãzó võ ûrú ꞌálâ rî ꞌálâ cé drı̣́ ãlô bê, gõꞌdá ní drí cãzó drı̣́ bê rı̣̃ nĩꞌá vẽlé lạ̃sı̣́ gólâ Ôvârí drí êdélé Sãtánã yî drí rî ꞌá rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Gõꞌdá Yésũ îmbâ tã trá tã õkó îngâ kâ tãsĩ kĩ nĩ rî, “Nĩ ârî kpá tã gólâ âtálé trá Músạ̃ sĩ tã õkó îngâ kâ tãsĩ kĩꞌá nĩ rî, ‘Õzõ õjílã ãzâ õlẽ trá íyî õkó rî îngálé rî, gólâ õfẽ wárãgã õkó îngâ kâ õkó rî ꞌdĩ drí’ rî trá. ");
INSERT INTO avu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Gõꞌdá mâ rî gógó, má âtâ ãnî drí, õzõ õjílã ãzâ ũûsû õkó lâ kô ậyı̣́rı̣̃ ꞌá ãgô ãzâ bê rî, gõꞌdá gólâ drí õkó lâ ꞌdĩ îngázó cú ĩtí tã õnjí ꞌdĩ ꞌẽ ãkó rî, gõꞌdá õzõ õkó ꞌdĩ õnĩ trá nĩꞌá ãgô ãzâ trõlé rî, gólâ ꞌbã õkó ꞌdĩ trá tã õnjí ꞌẽlé. Ĩtí rî, ãgô rî gógó õkó ꞌdĩ trõ ꞌbá ꞌdĩ, gólĩyî kpạ̃rạ̃tı̣́ õkó rî ꞌdĩ bê, gólĩyî ꞌê tã õnjí trá Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Gõꞌdá Yésũ îmbâ tã kpá trá tã õjílã drí ꞌbãlé ꞌẽlé Ôvârí ândrá rî tãsĩ, gólâ kĩ, “Nĩ ârî tã gólâ âtálé trá ãmâ ạ́ꞌbı̣́yạ́ yî drí kĩꞌá nĩ rî, ‘Nî ãzâ, õzõ ní õꞌbã tã trá Ôvârí ândrá tã ãzâ ꞌẽzó rî, ní ꞌê tã rî ꞌdĩ té ĩtí. Õzõ ní õꞌê tã rî ꞌdĩ kô rî, rĩꞌá õnjí ró.’ ");
INSERT INTO avu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Gõꞌdá mâ rî gógó, má âtâ ãnî drí, nĩ îtrî lãtrítrí kô tã gólĩyî ãnî drí ꞌẽꞌá ꞌẽlâ rî ꞌbá yî tãsĩ. Ĩtí rî, nĩ îtrî lãtrítrí kô ꞌbũû sĩ, tãlâ ꞌbũû ꞌdĩ rĩꞌá rĩ-võ Ôvârí kâ rĩzó rĩlí kúmú ạ́ngı̣́ ró ngá drı̣̃lı̣́ ndrĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gõꞌdá nĩ îtrî lãtrítrí kpá kô ı̣̃nyạ́kú drı̣̃ sĩ, tãlâ ı̣̃nyạ́kú drı̣̃ ꞌdî rĩꞌá pá tõ võ Ôvârí kâ rĩzó kúmú ạ́ngı̣́ ró ãngó nõ drı̣̃lı̣́ rî ĩꞌdî. Gõꞌdá nĩ îtrî lãtrítrí kpá kô jạ̃rı̣́bạ̃ Yẽrõsãlémã kâ rú lâ sĩ, tãlâ ꞌdĩî kpá rĩꞌá jạ̃rı̣́bạ̃ gólâ Ôvârí drí rĩzó õjílã íyíkâ drı̣̃lı̣́ kúmú ạ́ngı̣́ ró rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gõꞌdá nĩ îtrî lãtrítrí kpá kô ãnî drı̣̃ sĩ, tãlâ ãnî nyãányâ îcá kô drı̣̃-ꞌbí ãlô rî lârâkô lâ jãlé âꞌdólé mvẽêmvê ró ngãtá nı̣̃ı̣̂nı̣̂ ró. ");
INSERT INTO avu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ĩtí rî, nĩ âtâ tã cé kĩ, ‘Ãwô, pạ̃tı̣́ı̣̃ mã âꞌdô ꞌẽꞌá lâ’, õzõ nĩ õlẽ trá ꞌẽlâ rî. Õzõ nĩ õlẽ ꞌẽlâ kô rî, gõꞌdá nĩ âtâ kpá cé kĩ, ‘ꞌÉꞌẽ, mã îcá kô ꞌẽlâ’, tãlâ úlı̣́ õjílã ãzâ drí âtálé tã ꞌdî ꞌbá yî drı̣̃ı̣̂ sĩ rî, tã âꞌdálé kĩ, tã õjílã ꞌdî drí âtálé ꞌdĩ rĩꞌá tã Sãtánã kâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Gõꞌdá Yésũ drí kpá tã îmbázó tã tã-võ lôgõ kâ tãsĩ kĩ, “Nĩ ârî úlı̣́ gólâ âtálé ạ̃kû ró nã sĩ rî trá kĩꞌá nĩ rî, ‘Õzõ õjílã ãzâ õcâ íyî ãzí-ãzí rî lı̣̃fı̣́ ãlô rî trá kpạ̃ạ́cũ rî, áâꞌdô kpá õjílã rî ꞌdĩ lı̣̃fı̣́ lâ cãꞌá õzõ drílâ íyî ãzí-ãzí rî lı̣̃fı̣́ cãrẽ ꞌdî kâtí’ rî trá. Gõꞌdá ‘õzõ õjílã ãzâ õcâ íyî ãzí-ãzí rî sı̣́ trá ŋõlé kãálĩ rî, áâꞌdô kpá õjílã rî ꞌdĩ sı̣́ lâ cãꞌá ŋõlé õzõ drílâ íyî ãzí-ãzí rî sı̣́ ŋõrẽ ꞌdî kâtí’ rî kpá trá. ");
INSERT INTO avu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gõꞌdá ngbãângbânõ rî, má âtâ ãnî drí, nĩ lôgõ tã õnjí kô tã õnjí ãzí sĩ õjílã gólâ tã õnjí ꞌẽ ꞌbá trá ãnî rú rî drí. Õzõ õjílã ãzâ õsâ ánî ạ́yạ́ꞌbú drı̣́-ágó lésĩ rî, gõꞌdá ní jâ kpá ánî ạ́yạ́ꞌbú drı̣́-lı̣̃jı̣́ lésĩ rî, gólâ õsâ ró bê. ");
INSERT INTO avu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gõꞌdá õzõ õjílã ãzâ ãâjî nî võ tã kĩ kâ ꞌálâ, ãꞌdô ró bê tã-vó áníkâ kĩzó ítá áníkâ ãlô rî trõzó rî, ní ôcî tı̣̂ kô tã rî ꞌdĩ ꞌá, gõꞌdá ní âyê gólâ õtrõ ró kpá ãzâ. ");
INSERT INTO avu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ĩtí rî, gõꞌdá õzõ ạ̃jú ꞌbũ ꞌbá õꞌbã ĩyî nî mbârâkã sĩ ngá ĩyíkâ njı̣̃lı̣́ nĩzó ĩꞌdí bê lâ áyágá drı̣̃ mbãlé ãlô rî, ní mbã áyágá drı̣̃ zãlô rı̣̃ ngá gólĩyíkâ ꞌdĩ bê. ");
INSERT INTO avu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Õzõ õjílã ãzâ ũzı̣̂ ngá trá ní tı̣́ sĩ rî, ní fẽ ngá rî ꞌdĩ drílâ. Gõꞌdá õzõ õjílã ãzâ õlẽ ngá ậmúlı̣́ ní drı̣́gạ́ sĩ rî, ní fẽ ngá rî ꞌdĩ drílâ, ní lôgâ kô.” ");
INSERT INTO avu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gõꞌdá Yésũ drí tã âtázó tã ngá lẽlẽ kâ tãsĩ kĩ, “Nĩ ârî tã gólâ âtálé ạ̃kû ró nã sĩ kĩꞌá nĩ rî, ‘Nĩ lẽ ãnî rû-lẽ-ãzí yî, gõꞌdá nĩ ꞌbã ãnî ạ̃jú-ꞌbá-ãzí yî lôvó kô’ rî trá. ");
INSERT INTO avu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Gõꞌdá ngbãângbânõ rî, má âtâ tã ãnî drí, nĩ lẽ ãnî ạ̃jú-ꞌbá-ãzí yî. Gõꞌdá nĩ ꞌê rãtáã õjílã gólĩyî rĩ ꞌbá lâŋõ fẽlé ãnî drí rî ꞌbá yî tãsĩ, Ôvârí õpâ ró gólĩyî bê. ");
INSERT INTO avu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Õzõ nĩ õꞌê trá ĩtí rî, ꞌdĩî ãâꞌdâ ró bê kĩ, pạ̃tı̣́ı̣̃ ãnî rĩꞌá ãnî átá Ôvârí ûrú ꞌálâ rî mvá lâ yî ĩꞌdî. Tãlâ Ôvârí rî rĩꞌá tã tãndí ꞌẽlé õjílã drí ndrĩ, gólâ rî nĩ ı̣̃tú ꞌbãlé rĩꞌá võ îꞌĩlí õjílã gólĩyî tãndí rî ꞌbá yî drí kpãkã ãlô õjílã gólĩyî õnjí rî ꞌbá yí bê. Gõꞌdá gólâ rî kpá nĩ ôzê ꞌbãlé ꞌdı̣̃lı̣́ õjílã gólĩyî rĩ ꞌbá tã mbı̣̂ rî ꞌẽlé rî ꞌbá yî drí, gõꞌdá kpá õjílã gólĩyî rĩ ꞌbá tã õnjí ꞌẽlé rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gõꞌdá õzõ nĩ õrî cé õjílã gólĩyî rĩ ꞌbá tã tãndí ꞌẽlé ãnî drí rî lẽlé ĩꞌdî rî, Ôvârí âꞌdô drı̣́-ꞌâ fẽꞌá ãnî drí ãꞌdô tãsĩ yã? Tãlâ gbõ lé õjílã õnjí rĩ ꞌbá ĩyî ậdı̣̂ ômbê gĩ kâ ûꞌdúlı̣́ rî ꞌbá yî, gólĩyî rî kpá cé õjílã gólĩyî ĩyî lẽ ꞌbá rî lẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Õzõ nĩ õrî cé nĩꞌá nî-bê-yã fẽ bê ãnî rû-lẽ-ãzí yî drí ĩꞌdî rî, nĩ ı̣̂sũ ãníkâ bê rî, nĩ ꞌê ꞌdĩ tã tãndí ꞌî Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá yã? Õjílã gólĩyî gbõ lé Ôvârí rî nı̣̃ ꞌbá kô rî ꞌbá yî rî ĩyî kpá ꞌẽlâ ĩtí. ");
INSERT INTO avu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ĩtí rî, ãnî nyãányâ, nĩ rî tã gólĩyî âꞌdó ꞌbá mbı̣̂ pạ̃tı̣́ı̣̃ rî ꞌẽlé ĩꞌdî kárá, õzõ ãnî átá ûrú ꞌálâ rî drí rĩrĩ tã mbı̣̂ ꞌẽlé rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ drí îtõzó kpá rĩꞌá õꞌbí ꞌdĩ ꞌbá yî îmbálé tã tã tãndí ꞌẽzó ı̣̃nı̣́nı̣̂ ró rî tãsĩ, gólâ kĩ, “Õzõ nĩ õlẽ trá tã tãndí ꞌẽlé rî, nĩ ꞌê tã rî ꞌdĩ dódó lı̣̃fı̣́ lõmbâ sĩ, ãâꞌdô kô õjílã lı̣̃fı̣́ drı̣̃ ꞌá, tãlâ gólĩyî õzó ndrẽlâ kô. Gõꞌdá õzõ nĩ õꞌê tã ꞌdî trá õjílã lı̣̃fı̣́ drı̣̃ ꞌá ãnî tã lôngózó bê rî, nĩ îcá kô drı̣́-ꞌâ ãzâ ûsúlı̣́ ãnî átá ûrú ꞌálâ rî drı̣́gạ́ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Bê trá ĩtí rî, õzõ nĩ õtírĩ rĩî ngá fẽlé õjílã gólĩyî ĩzã bê rî pãzó rî, nĩ îyâ tã lâ kô, õzõ õjílã gólĩyî âꞌdó ꞌbá lómbé-lómbéwá ꞌbá ró rî ꞌbá yî drí rĩrĩ ꞌẽlâ rî kâtí. Õzõ gólĩyî õfẽ ngá trá õjílã ãzí pãzó rî, gólĩyî rî tã lâ îyálé ûrû ngbạ́lạ́-ngbạ́lạ́ jó tã Ôvârí kâ ârî kâ rî ꞌbá yî ꞌásĩ gõꞌdá kpá lạ́tı̣̂ drı̣̃ı̣̂ sĩ. Gólĩyî rî tã ꞌdî ꞌẽlé ĩtí ꞌdĩ, cé tãlâ õjílã õndrê ró ĩyî bê, gõꞌdá gólĩyî ũlûyı̣̂ ró ĩyî kpá bê. Má âtâ ãnî drí, gólĩyî îcá kô drı̣́-ꞌâ ûsúlı̣́ Ôvârí drı̣́gạ́ sĩ, drı̣́-ꞌâ gólĩyíkâ ꞌẽꞌá ûsúlâ rî trá cé ĩꞌdî gólĩyî lûyı̣̂-lûyı̣̂ sĩ ꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gõꞌdá nî ãzâ, õzõ ní õtírĩ rĩî ngá fẽlé õjílã gólâ ĩzã bê rî pãzó rî, ní ꞌbã õjílã ãzâ kô tã ní drí rĩꞌá ꞌẽlé ꞌdĩ võ lâ ûsúlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ní ꞌê tã rî ꞌdĩ ı̣̃nı̣́nı̣̂ ró cé ãnî lãfálé ꞌásĩ õjílã rî ꞌdĩ bê. Õzõ ní õꞌê trá ĩtí rî, gõꞌdá Ôvârí ánî átá ûrú ꞌálâ gólâ rĩ ꞌbá tã gólĩyî rĩꞌá ꞌẽlâ ı̣̃nı̣́nı̣̂ ró rî nı̣̃lı̣́ ndrĩ rî âꞌdô tã ní drí ꞌẽlé ꞌdĩ ndrẽꞌá. Ĩtí rî, gólâ âꞌdô drı̣́-ꞌâ tãndí fẽꞌá ní drí.” ");
INSERT INTO avu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gõꞌdá nĩngá sĩ, Yésũ drí ngãzó kpá rĩꞌá õꞌbí ꞌdĩ ꞌbá yî îmbálé tã rãtáã ꞌẽꞌẽ kâ tãsĩ. Gólâ kĩ, “Õzõ nĩ õtírĩ rĩî rãtáã ꞌẽlé Ôvârí drí rî, nĩ ꞌê kô õzõ õjílã gólĩyî âꞌdó ꞌbá lómbé-lómbéwá ꞌbá ró rî ꞌbá yî drí rĩrĩ ꞌẽlâ rî kâtí. Gólĩyî lẽ tã rõô âdrélé ûrû jó tã Ôvârí kâ ârî kâ ꞌásĩ gõꞌdá kpá lạ́tı̣̂ rû ûsûmậ ꞌásĩ ĩyî nyãányâ âꞌdálé, õjílã ãzí õndrê ró ĩyî bê yĩ õtírĩ rĩî rãtáã ꞌẽlé rî. Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, gólĩyî îcá kô drı̣́-ꞌâ ûsúlı̣́ Ôvârí drı̣́gạ́ sĩ, drı̣́-ꞌâ gólĩyíkâ ꞌẽꞌá ûsúlâ rî trá cé ĩꞌdî gólĩyî lûyı̣̂-lûyı̣̂ sĩ ꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ĩtí rî, õzõ nĩ õtírĩ rĩî rãtáã ꞌẽlé Ôvârí drí rî, nĩ fî jó ãníkâ ꞌá, nĩ âꞌbã ró ạ́tı̣̃ ãníkâ, nĩ gõ ró bê rãtáã ꞌẽlé ı̣̃nı̣́nı̣̂ ró ãnî átá gólâ ãnî drí ndrẽlé kôꞌdáwá rî drí. Ĩtí rî, rãtáã gólâ ãnî drí ꞌẽlé ı̣̃nı̣́nı̣̂ ró ꞌdĩ, gólâ âꞌdô âríꞌá lâ, gõꞌdá gólâ âꞌdô drı̣́-ꞌâ fẽꞌá ãnî drí tã lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ĩtí rî, nĩ ãâꞌdô trá rãtáã ꞌẽꞌá Ôvârí drí rî, nĩ rî kô ꞌẽlâ õzõ õjílã gólĩyî Ôvârí rî nı̣̃ ꞌbá kô rî ꞌbá yî drí rĩrĩ ꞌẽlâ rî kâtí. Gólĩyî rî rĩꞌá rãtáã ꞌẽlé ãcê úlı̣́ tã ífí ãkó rî ꞌbá yí bê dũû. Gólĩyî rî ĩyíkâ tã ányâ ı̣̂sũlı̣́ kĩ, rãtáã ĩyíkâ rĩꞌá ꞌẽlâ ãcê ꞌdĩ, Ôvârí âꞌdô âríꞌá lâ. ");
INSERT INTO avu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nĩ rî kô rãtáã ꞌẽlé ĩtí tã ífí ãkó, õzõ gólĩyî drí rĩrĩ ꞌẽlâ rî kâtí. Gõꞌdá âꞌdó kô îcâ-îcâ ró ãnî drí rãtáã ꞌẽzó ãcê, tãlâ ãnî átá Ôvârí nı̣̃ ngá gólĩyî ãnî drí lẽlé yí drı̣́gạ́ sĩ rî trá cú ĩtí ãnî drí íyî îjí ãkó. ");
INSERT INTO avu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gõꞌdá õzõ nĩ õtírĩ rĩî rãtáã ꞌẽlé rî, nĩ ꞌê rãtáã õzõ nõô rî tí. ‘Ãmâ átá ûrú ꞌálâ rî, ánî rú ãꞌdô ı̣̂njı̣̃lı̣́ ı̣̂njı̣̃. ");
INSERT INTO avu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kũmũ áníkâ rî ãâcâ, tã ní drí lẽlé rû ꞌẽlé rî õꞌê rû ı̣̃nyạ́kú drı̣̃ı̣̂, õzõ drílâ âꞌdórẽ ûrú ꞌálâ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ãndrõ nô, ní âfẽ ngá nyãnyã ãmákâ kậyı̣̂ vósĩ cé rî ãmâ drí. ");
INSERT INTO avu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ní âyê ãmâ tã õnjí ãmákâ rî ꞌbá yî ꞌásĩ, õzõ ãmâ drí gólĩyî tã õnjí ꞌẽ ꞌbá trá ãmâ rú rî yî âyérẽ kâtí. ");
INSERT INTO avu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ní âjî ãmâ kô lôfílí tã ûjũ-ûjũ ꞌá, gõꞌdá ní pâ ãmâ Sãtánã drı̣́gạ́ sĩ.’ ");
INSERT INTO avu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Õzõ nĩ ãâyê õjílã gólĩyî rĩ ꞌbá tã õnjí ꞌẽlé ãnî drí rî yî trá tã õnjí gólĩyíkâ rĩꞌá ꞌẽlâ ꞌdĩ ꞌásĩ rî, gõꞌdá Ôvârí ãnî átá ûrú ꞌálâ rî âꞌdô kpá ãnî âyéꞌá tã õnjí ãníkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gõꞌdá õzõ nĩ ãâyê gólĩyî kô tã õnjí gólĩyíkâ rĩꞌá ꞌẽlâ rî ꞌásĩ rî, Ôvârí ãnî átá ûrú ꞌálâ rî âyé ãnî kpá kô tã õnjí ãníkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nĩngá sĩ rî, Yésũ drí õꞌbí ꞌdĩ ꞌbá yî îmbázó kĩ, “Õzõ nĩ ãâꞌdô trá tı̣̂ ꞌbĩꞌá rĩzó ꞌálé ꞌãꞌí sĩ ngá nyã ãkó rãtáã ꞌẽlé Ôvârí drí rî, nĩ ı̣̂njı̣̂ lı̣̃fı̣́ kô, õzõ õjílã gólĩyî âꞌdó ꞌbá lómbé-lómbéwá ꞌbá ró rî ꞌbá yî drí rĩrĩ ꞌẽlâ rî kâtí. Gólĩyî rî ĩyî nyãányâ âꞌdálé õjílã ãzí õndrê ró bê kĩ, ĩyî rĩꞌá tı̣̂ ꞌbĩꞌá. Tã gólĩyíkâ rĩꞌá ꞌẽlâ ĩyî tã lôngózó ꞌdĩ tãsĩ rî, má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, gólĩyî îcá kô drı̣́-ꞌâ ûsúlı̣́ Ôvârí drı̣́gạ́ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Õzõ nĩ ãâꞌdô trá tı̣̂ ꞌbĩꞌá rĩzó ꞌálé ꞌãꞌí sĩ rãtáã ꞌẽlé Ôvârí drí rî, nĩ jĩ ãnî lı̣̃fı̣́ ngbángbá ãnî ꞌbãzó âꞌdólé ãyĩkõ ró, ");
INSERT INTO avu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tãlâ õjílã ãzí õzó nı̣̃lâ kĩꞌá nĩ rî, ãnî rĩꞌá tı̣̂ ꞌbĩꞌá. Ãnî átá tíbê ãnî drí ndrẽlé kôꞌdáwá rî âꞌdô nı̣̃ꞌá lâ cé nĩ. Ĩtí rî, rãtáã gólâ ãnî drí ꞌẽlé tı̣̂ ꞌbĩꞌbĩ sĩ ı̣̃nı̣́nı̣̂ ró ꞌdĩ, Ôvârí âꞌdô âríꞌá lâ, gõꞌdá drílâ tã-drı̣̃ lâ jãzó.” ");
INSERT INTO avu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nĩngá sĩ, Yésũ drí kpá tã âtázó kĩ, “Nĩ êꞌbê ngá-tı̣̂ ãngó nõ ꞌá nõ ꞌbá yî kô cé tı̣̂tı̣̂ ꞌdó ãnî nyãányâ drí, ꞌbãlé võ tíbê ngá ạ̃sũkũꞌdũ yí kâtí gõꞌdá ûjúrúkú yí bê rî yî drí ꞌẽzó fĩlí îzãlâ rî ꞌá, ngãtá võ ngá gólĩyî ậdı̣̂ ꞌásĩ rî ꞌbá yî drí ꞌẽzó lâkálé rû îzãlé rî ꞌá, gõꞌdá kpá võ gólâ ũgú yî drí îcálé ạ́tı̣̃ ŋõlé ngá ûgũzó ꞌálâ sĩ rî ꞌá kô. ");
INSERT INTO avu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gõꞌdá nĩ lậpı̣̂ bê-rî ngá-tı̣̂ tãndí ãnî nyãányâ drí võ ûrú ꞌálâ rî ꞌá. Tãlâ tólâ rî, ngá ạ̃sũkũꞌdũ yí kâtí ûjúrúkú yí bê rî îcá kô fĩlí ngá-tı̣̂ tãndí ꞌdĩ ꞌbá yî îzãlé, gõꞌdá ngá-tı̣̂ ꞌdĩ ꞌbá yî rúꞌbạ́ lâ yî îcá kô lâkálé gõꞌdá rû îzãlé, gõꞌdá ũgú îcá kpá kô fĩlí ngá-tı̣̂ ꞌdĩ ꞌbá yî ûgũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tãlâ tã ı̣̂sũ ãníkâ âꞌdô ꞌbãꞌá nyé võ gólâ ãnî drí ngá tã lâ drí lâzélé ãnî rú kôrô rî ꞌbãzó ꞌá lâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nĩ ndrê drẽ, ãnî lı̣̃fı̣́ rĩꞌá nyé õzõ lámbã kâtí võ îꞌĩlí ãnî rúꞌbạ́ drí tã ndrĩ ndrẽzó dódó. Gõꞌdá õzõ ãnî lı̣̃fı̣́ õndrê võ dódó rî, ãnî rúꞌbạ́ âꞌdô ꞌbãꞌá kpá ngá îꞌĩ ró tã pạ̃tı̣́ı̣̃ Ôvârí kâ ꞌẽzó. Âꞌdô rĩꞌá ĩtí ãnî drí õzõ nĩ õrî rĩlí ngá ãlô ró Ôvârí bê rî. ");
INSERT INTO avu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Gõꞌdá õzõ ãnî lı̣̃fı̣́ õndrê võ kô dódó tã gólĩyî mbı̣̂ Ôvârí kâ ndrẽzó rî, Gõꞌdá õzõ nĩ õrî kô ãnî lı̣̃fı̣́ ꞌbãlé Ôvârí drı̣̃ı̣̂ tã gólâkâ ꞌẽlé rî, ãnî rúꞌbạ́ âꞌdô ꞌbãꞌá kpá ı̣́nı̣́rı̣́kúwạ́ ró tã ányâ rî ꞌbá yî ꞌẽlé ĩꞌdî. Gõꞌdá ngá gólĩyî ãnî drí rĩꞌá ndrẽlâ ı̣́nı̣́rı̣́kúwạ́ ró rî ꞌbá yî, õzõ nĩ ı̣̃ı̣̂sũ kĩꞌá nĩ rî, ꞌdĩî ãꞌdô ngá îꞌĩ ꞌî ãnî drí tã mbı̣̂ ꞌẽzó ĩꞌdî sĩ lâ rî, tã ı̣̂sũ ãníkâ ꞌdĩ rĩꞌá ányâ ró ãnî âdólé ngbá. ");
INSERT INTO avu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nĩ ndrê drẽ, îcá kô õjílã ãlô drí rû ı̣̂ꞌbũzó kúmú rı̣̃ drí ꞌdó ı̣̃tú-pá ãlô ꞌá. Gõꞌdá gólâ îcá kô kúmú ngĩíngî rı̣̃ ꞌdî ꞌbá yî lẽlé ndrĩ ꞌdó. Gólâ âꞌdô tã kúmú ãlô rî kâ lẽꞌá ĩꞌdî, gõzó ãzâ rî gãlé dó. Âꞌdólé bê trá ĩtí rî, õzõ nĩ õlẽ trá lı̣̃fı̣́ ꞌbãlé ngá-tı̣̂ dũû ûsúlı̣́ ãnî nyãányâ drí ĩꞌdî rî, nĩ âꞌdô îcáꞌá rû ı̣̂ꞌbũlı̣́ Ôvârí drí pı̣̃pı̣̂sı̣́lı̣́ ãlô rî sĩ ángô tí yã? ꞌDĩî îcá kô ãlôwálâ. Nĩ ı̣̂ꞌbũ rû cé Ôvârí drí ĩꞌdî!” ");
INSERT INTO avu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nĩngá sĩ, Yésũ drí õꞌbí ꞌdĩ ꞌbá yî îmbázó kĩ, “Ngá gólĩyî ãnî drí lẽlé rĩzó ãngó nõ ꞌá rî tãsĩ rî, má âtâ tã ãnî drí kĩ, nĩ âꞌdô kô tã ı̣̂sũ ró ngá gólĩyî ꞌẽ ꞌbá ãnî ꞌbãlé rĩlí lédrẽ-lédrẽ ró ngá nyãnyã kâtí ngá mvũmvũ bê, ngãtá ítá ãnî drí sõlé ãnî rúꞌbạ́ ꞌá rî tãsĩ. Nĩ ndrê drẽ, tã ngá nyãnyã kâ ítá sõsõ bê rî lậvũú kô gạ̃rạ̃ lôvó-lôvó drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ꞌDõvó nĩ ı̣̂sũ drẽ ãríwá tã. Gólĩyî ꞌwãá ạ́mvú kô, gõꞌdá êꞌbé ĩyî kpá ngá-ĩyínyâ ạ́mvú ꞌásĩ ꞌbãlé ẽró ꞌá kô. Gbõ lé ĩtí rî, Ôvârí ãnî átá ûrú ꞌálâ rî, rî nĩ rĩꞌá ngá nyãnyã fẽlé gólĩyî drí rĩꞌá nyãlâ. Gõꞌdá ãnî tã lâzê gạ̃rạ̃ Ôvârí rú ãríwá drı̣̃ı̣̂ sĩ. Ĩtí rî, gólâ îcá kô tã ãníkâ ı̣̂vı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gõꞌdá nĩ ı̣̂sũ ãníkâ bê rî, lı̣̃fı̣́ lôꞌbê-lôꞌbê ãníkâ ngá ꞌdĩ ꞌbá yî tãsĩ rî âꞌdô kậyı̣̂ ãníkâ rĩ kâ ãngó nõ ꞌá rî lôpéꞌá âꞌdólé ãcê yã? ");
INSERT INTO avu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Gõꞌdá tãlâ ãꞌdô ꞌî ãnî drí rĩzó lı̣̃fı̣́ lôꞌbélé ítá sõlé rúꞌbạ́ ꞌá rî tãsĩ yã? ꞌDõvó nĩ ndrê drẽ lạ́tı̣̂ gólâ fê fõô õmã ꞌálâ rî drí rĩzó mbãlé rî. Gólĩyî lôsé ítá kô gõꞌdá ꞌé ĩyî lôsĩ kpá kô ítá ûsúzó ĩyî nyãányâ drí. ");
INSERT INTO avu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gõꞌdá Ôvârí ꞌbã gólĩyî trá âꞌdólé lârâkô bê sũsũ ró rõô. Gõꞌdá ĩtí rî, ítá lârâkô Ôvârí drí ꞌbãlé drílĩyî rî sû lậvũlı̣́ kôrô ítá lârâkô kúmú Sólõmõ drí sõlé kũmũ kâ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gõꞌdá nĩ ndrê drẽ, Ôvârí ꞌbã ngá-ạ̃rú nĩ âꞌdólé lârâkô bê sũsũ ró gólĩyî rĩ ꞌbá mbãlé rĩlí cé kậyı̣̂ dã sĩ gõꞌdá ândrálé ꞌĩlí vẽlé vólé õmã bê mîlí sĩ rî. Õzõ gõꞌdá Ôvârí ĩîcâ trá ngá-ạ̃rú ꞌbãlé âꞌdólé lârâkô bê sũsũ ró rî, gõꞌdá gólâ îcá íyíkâ ítá fẽlé ãnî drí kô yã? Ĩtí rî, nĩ rí kô tã lẽlẽ sĩ Ôvârí ꞌá pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ ãꞌdô tãsĩ yã? Ãnî tã lậvũ gạ̃rạ̃ Ôvârí drí ngá-ạ̃rú ꞌdĩ ꞌbá yî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Gõꞌdá ĩtí rî, nĩ lôꞌbê lı̣̃fı̣́ kô kĩ, ‘Óõ, mã âꞌdô nõ kó ãꞌdô nyãꞌá ĩꞌdî yã?’ ngãtá ‘Óõ, mã âꞌdô nõ kó ãꞌdô mvũꞌá ĩꞌdî yã?’ ngãtá ‘Óõ, mã âꞌdô ítá ûsúꞌá sõlé nõ kó ãꞌdô ꞌásĩ yã?’ ");
INSERT INTO avu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tã ꞌdî ꞌbá yî tãsĩ rî, õjílã gólĩyî rĩ ꞌbá tã ı̣̂sũlı̣́ ĩtí ꞌdĩ ꞌbá yî, ꞌdĩî õjílã gólĩyî tã lẽ ꞌbá drẽ Ôvârí ꞌá kô rî ꞌbá yî ĩꞌdî. Ôvârí ãnî átá ûrú ꞌálâ rî nı̣̃ ngá gólĩyî ãnî drí âꞌdózó ĩzã lâ bê rî trá. ");
INSERT INTO avu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tã lı̣̃fı̣́ lôꞌbê-lôꞌbê kâ ngá ãngó nõ ꞌá rî tãsĩ rî võ lâ ꞌá rî, nĩ rî zãâ kũmũ Ôvârí kâ zẽlé, gõꞌdá nĩ ꞌbã ró tã ı̣̂sũ ãníkâ bê tã gólĩyî Ôvârí drí lẽlé ãnî drí ꞌẽlé rî ꞌbá yî drı̣̃ı̣̂ ĩꞌdî. Õzõ nĩ õꞌê tã rî ꞌdĩ ꞌbá yî trá ĩtí rî, Ôvârí âꞌdô ngá gólĩyî ãnî drí âꞌdózó ĩzã bê tã lâ tãsĩ rî ꞌbá yî âfẽꞌá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gõꞌdá âꞌdô bê trá ĩtí rî, nĩ lôꞌbê lı̣̃fı̣́ kô ãndrõ nô tã gólĩyî ꞌẽ ꞌbá âꞌdólé ı̣̃drú rî ꞌbá yî tãsĩ, tãlâ nĩ nı̣̃ı̣́ drẽ tã gólĩyî ꞌẽ ꞌbá rû ꞌẽlé kậyı̣̂ ı̣̃drú rî ꞌá rî kô. Kậyı̣̂ ndrĩ rĩꞌá lâŋõ ngĩíngî ĩyíkâ bê ãlô-ãlô. Rĩꞌá îcâ-îcâ ró ãnî drí cé lâŋõ kậyı̣̂ ãlô rî kâ njı̣̃zó ĩꞌdî, ãnî drí lâŋõ kậyı̣̂ ndrĩ kâ njı̣̃zó rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Gõꞌdá Yésũ drí kpá tã îmbázó tã tã-vó kĩkĩ kâ ányâ ró ãzí-ãzí rú rî tãsĩ kĩ, “Nĩ kî tã õjílã ãzí kâ kô tã gólĩyî drí rĩꞌá ꞌẽlâ ányâ ró rî ꞌbá yî tãsĩ, tãlâ Ôvârí õzó kô kpá tã-vó ãníkâ kĩî õnjí ró. ");
INSERT INTO avu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nĩ ndrê drẽ, Ôvârí âꞌdô ꞌẽꞌá tã-vó ãníkâ kĩlí kpá té õzõ ãnî drí tã-vó ãnî ãzí-ãzí yí kâ kĩrĩ kâtí, gõꞌdá gólâ âꞌdô ãnî ꞌẽꞌá kpá té õzõ ãnî drí rĩrĩ õjílã ãzí ꞌẽlé rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Õzõ nĩ õlẽ kô ꞌdásí ꞌẽlé ãzí-ãzí rú rî, nĩ âtâ tã ãzí-ãzí drí kĩꞌá nĩ rî, gólĩyî âꞌdó õnjí rî kô. Nĩ õꞌê trá ĩtí rî, ãnî cú tı̣̂ ãcê bê. Tõtõ ãnî drí ạ̃ꞌdı̣́-drı̣̃ ꞌá rî, nĩ kũ zãlô, nĩ gõ ró tõtõ ãnî ãzí-ãzí yí kâ rî tã lâ âtálé. Nĩ ndrê tã ꞌẽꞌẽ ãníkâ rî zãlô, nĩ gõ ró ãnî ãzí-ãzí yí kâ rî tã lâ âtálé.” ");
INSERT INTO avu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã îmbázó kĩ, “Õzõ nĩ õrî úlı̣́ Ôvârí kâ îmbálé õjílã drí gõꞌdá õjílã rî ꞌdĩ ꞌbá yî õrî ĩyî ãnî lôꞌdálé lôꞌdâ úlı̣́ Ôvârí kâ ꞌdĩ ꞌbá yî tãsĩ rî, nĩ âyê gólĩyî, nĩ îmbâ gõꞌdá úlı̣́ Ôvârí kâ kô drílĩyî, tãlâ gólĩyî âꞌdô ꞌẽꞌá vólé gãlé dó úlı̣́ Ôvârí kâ ꞌdĩ ârílí gõꞌdá kpá tã lâ ꞌẽlé. Gólĩyî rĩꞌá nyé õzõ õké lîfõ tíbê ãnî drí ngá nyãnyã fẽzó drílâ, gõꞌdá drílâ rû jãzó ãkpã ãnî ôcílí dró ngá nyãnyã tãndí ãníkâ fẽlé drílâ ꞌdĩ drı̣̃lı̣́ rî kâtí. Gõꞌdá gólĩyî kpá rĩꞌá õzõ ngbíkpí ꞌbã kâ gólâ ngá sũsũ ꞌdíyî lôꞌĩ kâ ãnî drí fẽlé trá drílâ rî tõ ꞌbá pá sĩ ũlútrạ́ ꞌá rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Gõꞌdá Yésũ drí kpá tã îmbázó tã rãtáã ꞌẽꞌẽ kâ tãsĩ kĩ, “Õzõ nĩ ĩîjî ãnî átá ûrú ꞌálâ rî ngá gólĩyî ãnî drí âꞌdózó ĩzã lâ bê rî ꞌbá yî tãsĩ rî, gólâ âꞌdô âfẽꞌá lâ ãnî drí. Gõꞌdá õzõ nĩ õrî lôndãlâ rî, nĩ âꞌdô ûsúꞌá lâ. Gõꞌdá õzõ nĩ õgâ ạ́tı̣̃ rî, áâꞌdô njı̣̃ꞌá lâ ãnî drí. Nĩ ndrê drẽ, Ôvârí âꞌdô rãtáã ãnî drí ꞌẽlé drílâ rî âríꞌá trá. Gólâ âꞌdô ngá gólĩyî ãnî drí âꞌdózó ĩzã bê tã lâ tãsĩ ꞌdî ꞌbá yî fẽꞌá trá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ĩtí rî, ꞌdõvó nĩ ı̣̂sũ drẽ ãnî nyãányâ tã, ãnî mvá rî átá yî, õzõ ãnî mvá yî ĩîjî ãmbãtã tã ãnî tı̣́ sĩ nyãlé rî, nĩ âꞌdô kúnı̣́ mvá âtrõꞌá ĩꞌdî fẽlé gólĩyî drí ãmbãtã ꞌdî võ lâ ꞌá yã? ");
INSERT INTO avu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngãtá õzõ ãnî mvá yî ĩîjî ı̣̃ꞌbı̣̂ tã ãnî tı̣́ sĩ nyãlé rî, ní âꞌdô ı̣̃nı̣̃ âtrõꞌá ĩꞌdî fẽlé gólĩyî drí yã? ");
INSERT INTO avu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Õzõ ãnî gólĩyî âꞌdó ꞌbá tã õnjí ꞌbá ró rî ĩîcâ trá ngá tãndí fẽlé ãnî mvá yî drí rî, ĩtí rî, Ôvârí ãnî átá ûrú ꞌálâ rî âꞌdô îcáꞌá kó ngá tãndí fẽlé ãnî drí. Gólâ rĩꞌá njãâ ngá tãndí fẽlé ãnî drí lậvũlı̣́ gạ̃rạ̃ ãnî drí fẽlé ãnî mvá yî drí rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Tã gólâ Ôvârí drí lẽlé lậvũ ꞌbá gạ̃rạ̃ rî ĩꞌdî nõ. Nĩ rî tã gólĩyî âꞌdó ꞌbá tãndí rî ꞌbá yî ꞌẽlé ĩꞌdî õjílã ãzí drí. Tã tãndí gólĩyî ãnî drí lẽlé õjílã drí ꞌẽlé ãnî drí rî ꞌbá yî, nĩ rî kpá ꞌẽlâ ĩꞌdî õjílã ãzí drí. ꞌDĩî tã Ôvârí drí ꞌbãlé ãmâ drí ꞌẽlé tã îgĩ-îgĩ íyíkâ ꞌá rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Gõꞌdá Yésũ drí tã îmbázó tã fĩfĩ kâ cãlé ãngó Ôvârí kâ ꞌálâ rî tãsĩ kĩ, “Lạ́tı̣̂ gólâ fĩzó cãlé ãngó Ôvârí kâ ꞌálâ rî, jó tı̣́lı̣́-tı̣̂ lâ rĩꞌá ngbãâ ꞌbílíwá ĩtí. Lạ́tı̣̂ fĩzó cãlé tólâ rî, rĩꞌá lạ́tı̣̂ âmbâ-âmbâ ꞌî. Õjílã ꞌẽ ꞌbá fĩlí ꞌálâ sĩ rî âꞌdô ꞌbãꞌá cé dã. Gõꞌdá õjílã gólĩyî fĩ ꞌbá tólâ rî âꞌdô ĩyî lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá. Gõꞌdá lạ́tı̣̂ nĩzó võ lạ̃sı̣́ kâ Ôvârí drí êdélé trá Sãtánã yî drí rî ꞌálâ rî, jó tı̣́lı̣́-tı̣̂ lâ rĩꞌá ậvû-ậvû ró. Lạ́tı̣̂ fĩ kâ tólâ rî âꞌdó kô âmbâ-âmbâ ró. Õjílã ãmbá âꞌdô ĩyî nĩꞌá ꞌálâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gõꞌdá Yésũ drí drı̣́-mbílí sõzó õjílã õꞌbí ꞌdĩ ꞌbá yî lı̣̃fı̣́ tã õjílã gólĩyî tã âmã ꞌbá kĩꞌá nĩ rî, yĩ ãꞌdô tã Ôvârí kâ îmbâ ꞌbá ꞌî rî kâ tãsĩ kĩ, “Ãnî lı̣̃fı̣́ õmbâ ãnî rú tã îmbá ꞌbá gólĩyî âꞌdó ꞌbá õjílã âdó ꞌbá ró rî tãsĩ. Gólĩyî lêndrê õzõ kạ́bı̣̃lı̣́kı̣̃ mvá kâtí, gõꞌdá tã ı̣̂sũ gólĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî rĩꞌá õzõ kíâkêlówá gólâ rĩ ꞌbá kõrõnyã ãzí fũlı̣́ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Õzõ nĩ õrî tã îmbá ꞌbá ꞌdĩ ꞌbá yî ndrẽlé mãnísĩ rî, nĩ âꞌdô gólĩyî âꞌdô-âꞌdô nı̣̃ꞌá tã ꞌẽꞌẽ gólĩyíkâ ꞌásĩ. Nĩ âꞌdô kpá nı̣̃ꞌá lâ ngãtá tã gólĩyî drí rĩꞌá îmbálâ ꞌdĩ pạ̃tı̣́ı̣̃ tã Ôvârí kâ ꞌî ngã âꞌdó kô tã Ôvârí kâ ꞌî yã rî. Tã ꞌẽꞌẽ gólĩyíkâ âꞌdâ gólĩyî trá õzõ fê lõꞌwâ drí fê lâ âꞌdárẽ kâtí. Ạ̃kû lâ sĩ, ólófí fê ꞌwâ lõꞌwâ bê kạ̃nı̣́kı̣̃ ró yã? Ngãtá púrũcı̣́ fê ꞌwâ lõꞌwâ bê kãnágõwá ró yã? ");
INSERT INTO avu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Fê gólâ tãndí ró rî ꞌwâ íyíkâ té lõꞌwâ tãndí ĩꞌdî, gõꞌdá fê gólâ õnjí ró rî ꞌwâ íyíkâ kpá té lõꞌwâ õnjí ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ĩtí rî, fê gólĩyî tíbê lõꞌwâ tãndí ꞌwã ꞌbá kô rî, áâꞌdô gãꞌá lâ vólé vũdrı̣́ zãlé lạ̃sı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kpá ĩtí rî, nĩ âꞌdô tã îmbá ꞌbá rĩ ꞌbá õjílã âdólé rî ꞌbá yî nı̣̃ꞌá tã gólĩyî drí rĩꞌá ꞌẽlâ rî ꞌbá yî ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gõꞌdá Yésũ drí gõzó tã îmbálé tã õjílã drí ꞌẽzó cãlé ãngó Ôvârí kâ ûrú ꞌálâ rî ꞌá rî tãsĩ kĩ, “Õjílã ndrĩ gólĩyî rĩ ꞌbá ámâ zı̣̃lı̣́ kúmú, kúmú rî, gólĩyî îcá kô ndrĩ cãlé ãngó Ôvârí kâ ûrú ꞌálâ rî ꞌá. Gõꞌdá gólĩyî rĩ ꞌbá tã ámâ átá Ôvârí ûrú ꞌálâ rî drí lẽlé ꞌẽlé rî ꞌbá yî ꞌẽlé rî, gólĩyî âꞌdô cãꞌá cé nĩ. ");
INSERT INTO avu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gõꞌdá kậyı̣̂ gólâ Ôvârí drí ꞌẽzó tã-vó õjílã ndrĩ kâ kĩlí rî tú rî, õjílã dũû âꞌdô ĩyî ânĩꞌá má ngálâ tã âtálé kĩ, ‘Kúmú, mã îmbâ tã áníkâ trá õjílã drí.’ Gõꞌdá ãzâ ꞌbá yî âꞌdô ĩyî tã âtáꞌá kĩꞌá nĩ rî, ‘Kúmú, mã rî trá rĩꞌá líndrí õnjí lâdrólé õjílã ꞌásĩ ánî rú sĩ.’ Gõꞌdá ãzâ ꞌbá yî âꞌdô ĩyî tã âtáꞌá kĩꞌá nĩ rî, ‘Kúmú, mã ꞌê tã lârâkô tı̣̂ drí ậꞌdı̣́zó rî ꞌbá yî trá dũû ánî rú sĩ.’ ");
INSERT INTO avu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Gõꞌdá má âꞌdô tã lôgõꞌá drílĩyî kĩ, ‘Mĩ nĩ vólé má lạ̃gạ́tı̣́ sĩ, ãnî tã õnjí ꞌbá yî! Má nı̣̃ı̣́ ãnî kô!’ ” ");
INSERT INTO avu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Gõꞌdá Yésũ drí kpá tã âtázó õjílã gólĩyî íyî vó lôbẽ ꞌbá rî yî tãsĩ kĩ, “Õjílã gólâ úlı̣́ ámákâ ârí ꞌbá gõꞌdá tã lâ ꞌẽzó rî, gólâ rĩꞌá õzõ tã nı̣̃ ꞌbá gólâ jó íyíkâ ꞌdı̣̃ ꞌbá gá lũtú drı̣̃ı̣̂ ı̣̃nyạ́kú tãndí ꞌá rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tã ꞌdî tãsĩ rî, gbõ lé ôzê ũꞌdı̣̂ trá kạ̃gũmạ́ạ̃ bê rõô rî, gõꞌdá lı̣̃mvû drí tı̣̃zó rõô rî, jó ꞌdĩ îcá kô ꞌdẽlé vũdrı̣́, tãlâ úꞌdı̣̂ trá gá lũtú drı̣̃ı̣̂ ı̣̃nyạ́kú tãndí ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Gõꞌdá õjílã tíbê úlı̣́ ámákâ ârí ꞌbá cé ârî gõꞌdá ꞌẽ ꞌbá lâ kô rî, gólâ rĩꞌá õzõ tã nı̣̃ ãkó lé ꞌbá gólâ jó íyíkâ ꞌdı̣̃ ꞌbá võ ãlólẽ ꞌá rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ĩtí rî, gõꞌdá õzõ ôzê ũꞌdı̣̂ trá kạ̃gũmạ́ạ̃ bê rõô rî, gõꞌdá lı̣̃mvû drí tı̣̃zó rõô rî, jó ꞌdĩ âꞌdô ꞌẽꞌá ꞌdẽlé, drílâ rû îzãzó.” ");
INSERT INTO avu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Gõꞌdá Yésũ ndẽ bê tã îmbâ íyíkâ ꞌdĩ ꞌbá yî rî, õꞌbí gólĩyî tã ꞌdî ꞌbá yî ârí ꞌbá ꞌdĩ tı̣̂ lâ ĩyî drí ậꞌdı̣́zó tã îmbâ gólâkâ ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gõꞌdá gólĩyî nı̣̃ ĩyî trá kĩ, gólâ rí kô tã îmbálé õzõ tã lãꞌbí kâ îmbá ꞌbá rî ꞌbá yî drí rĩrĩ tã îmbálé rî kâtí. Gólâ cú rĩꞌá drı̣́-ãcê bê. ");
INSERT INTO avu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nĩngá sĩ rî, Yésũ yî drí ngãzó nĩlí lũtú ꞌdĩ âyélé, gõꞌdá õꞌbí ãmbá drí kpá ꞌdẽzó zãâ gólĩyî vósĩ. ");
INSERT INTO avu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Gõꞌdá ãgô ãzâ ngá lãzé ãrí kâ bê rî drí ânĩzó ꞌãꞌî tı̣̃lı̣́ vũdrı̣́ Yésũ ândrá, gõzó rúꞌbạ́ lôꞌbãlé Yésũ drí kĩ, “Óõ kúmú, õzõ ĩîcâ trá ní lı̣̃fı̣́ ní drí ámâ pãzó ngá lãzé nõ ꞌásĩ rî, ní êdê ámâ rúꞌbạ́ nõ âꞌdólé ngbángbá.” ");
INSERT INTO avu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ĩtí rî, Yésũ drí íyî drı̣́ îjõzó ãgô ꞌdĩ rúꞌbạ́ lâ dõlé. Gõꞌdá gólâ drí tã âtázó kĩ, “Ãwô, má lẽ trá ánî êdélé ngá lãzé áníkâ ꞌdĩ ꞌásĩ. ꞌDõvó ánî rúꞌbạ́ ẽêdê rû ngbángbá.” Gõꞌdá kôrô ãgô ꞌdĩ rúꞌbạ́ lâ drí rû êdézó dódó ngá lãzé íyíkâ ꞌdĩ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ĩtí rî, Yésũ drí tã âtázó ãgô rî ꞌdĩ drí kĩ, “Tã gólâ rû ꞌẽ ꞌbá ní drí nõ, ní âtâ tã lâ kô õjílã ãzâ drí ãlôlâ. Ní nĩ drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ ngálâ lãꞌbí ꞌdíyî êdê kâ ãrí ꞌásĩ rî ꞌdãlé zãlô, tãlâ gólâ õndrê ró bê kĩ, pạ̃tı̣́ı̣̃ ngá lãzé áníkâ ndẽ rû trá ngbángbá, ní gõ ró kõrõnyã lı̣̃lı̣́ ngá fẽfẽ ró Ôvârí drí, õzõ Músạ̃ drí tã lâ ꞌbãlé trá rî kâtí.” Gõꞌdá ãgô ꞌdĩ drí nĩzó tã ꞌdî ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Gõꞌdá nĩngá sĩ, Yésũ yî drí ngãzó nĩlí cãlé jạ̃rı̣́bạ̃ gólâ zı̣̃lı̣́ Kãpẽrãnómã rî ꞌálâ. Gõꞌdá gólĩyî câ bê tólâ rî, ãgô ãzâ drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá Rómã kâ ró rî drí ânĩzó Yésũ ngálâ. Gõꞌdá drílâ ngãzó tã âtálé Yésũ drí rúꞌbạ́ lôꞌbã-lôꞌbã sĩ kĩ, ");
INSERT INTO avu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ãmbá, rû ı̣̂ꞌbũ ꞌbá ámákâ rĩꞌá ngá lãzé ró ãnyî ꞌẽꞌá drãlé. Ngá lãzé ꞌdĩ lâzê trá rõô gólâ rú, gólâ mbârâkã ãkó íyî jãzó. Ní pâ gólâ!” ");
INSERT INTO avu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Gõꞌdá Yésũ drí tã âtázó drı̣̃-ꞌbá ꞌdĩ drí kĩ, “Tãndí ró, má âꞌdô nĩꞌá rû ı̣̂ꞌbũ ꞌbá áníkâ ꞌdĩ pãlé.” ");
INSERT INTO avu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gõꞌdá drı̣̃-ꞌbá ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “ꞌÉꞌẽ ãmbá, ãmbã ámákâ rî îcá kô ánî ꞌbãlé âcálé bũúũ má drí ꞌbã ꞌálâ. Gõꞌdá õzõ ní ãâtâ kó cé tã drı̣́-ãcê áníkâ sĩ rî, má nı̣̃ trá, rû ı̣̂ꞌbũ ꞌbá ámákâ âꞌdô ngãꞌá ngá lãzé ꞌdĩ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ní ndrê drẽ, ãmbá, mâ kpá rĩꞌá drı̣́-ãcê drı̣̃-ꞌbá ámákâ gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yí kâ zẽlé. Gõꞌdá mâ kpá cú rĩꞌá drı̣́-ãcê bê tã ꞌbãzó õjílã má zẽlé rî ꞌbá yî drí tã má drí lẽlé rî ꞌbá yî ꞌẽzó. Õzõ má ãâtâ tã trá ạ̃jú ꞌbũ ꞌbá ámákâ ãlô rî drí kĩ, gólâ õnĩ nĩꞌá tã ãzâ ꞌẽlé rî, drílâ nĩzó ꞌẽlâ. Gõꞌdá õzõ má ạ̃ậzı̣̂ ạ̃jú ꞌbũ ꞌbá ãlô rî trá kĩ, gólâ ãânĩ rî, drílâ ânĩzó ꞌwãâ. Gõꞌdá má õkĩ kpá rû ı̣̂ꞌbũ ꞌbá ámákâ ãlô rî drí, ‘Ní ꞌê tã nõ’ rî, drílâ ꞌẽzó lâ, té õzõ má drí âtálé ꞌdĩ kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Gõꞌdá Yésũ ârî tã drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ꞌdĩ drí âtálé bê rî, gólâ rî tı̣̂ drí ậꞌdı̣́zó ậꞌdı̣̂. Gõꞌdá drílâ ngãzó tã âtálé õjílã gólĩyî rĩ ꞌbá ꞌdẽlé gólâ vósĩ ꞌdî ꞌbá yî drí kĩ, “Má âtâ ãnî drí, tã pạ̃tı̣́ı̣̃ ró, má ûsú drẽ õjílã ãzâ õrĩ ãmákâ Ĩsĩrãꞌélẽ kâ ꞌásĩ âꞌdó ꞌbá tã lẽlẽ bê rõô õzõ ãgô ãwã nõ kâtí rî kô. ");
INSERT INTO avu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gõꞌdá má âtâ ãnî drí nõtí. Kậyı̣̂ ạ̃dũkũ ãngó nõ kâ tú rî, õjílã gólĩyî âꞌdó ꞌbá kô õjílã Yúdạ̃ yí kâ ró rî ꞌbá yî âꞌdô ânĩꞌá ꞌbạ̃drı̣̃ ꞌásĩ ndrĩ rĩlí võ ãlô ꞌá ãngó Ôvârí kâ ûrú ꞌálâ rî ꞌá kãrámã nyãlé ãmâ ạ́ꞌbı̣́yạ́ Ãbãrãyámã yî Ĩsákã gõꞌdá kpá Yãkóbã yí bê. ");
INSERT INTO avu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gõꞌdá õjílã Yúdạ̃ yí kâ tíbê Ôvârí drí njĩlí âꞌdólé õjílã íyíkâ ró rî ꞌbá yî, Ôvârí âꞌdô õjílã dũû gólĩyî lãfálé ꞌásĩ rî gãꞌá dó, tãlâ gólĩyî gâ vólé trá dó tã lẽlé má ꞌá. Áâꞌdô gólĩyî vũꞌá ı̣́nı̣́rı̣́kúwạ́ ꞌá, lạ̃sı̣́ Ôvârí drí êdélé trá Sãtánã yî drí rî ꞌá. Tólâ rî, gólĩyî âꞌdô ãwó ngõꞌá sı̣́-gílí nyãnyã bê ngá lâzê-lâzê lạ̃sı̣́ kâ drí sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nĩngá sĩ, Yésũ drí gõzó tã âtálé drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ꞌdĩ drí kĩ, “Mí nĩ gõlé ꞌbã ꞌálâ pı̣̃pı̣̂sı̣́lı̣́ ạ̃ꞌdı̣́ sĩ, tãlâ tã gólâ ní drí lẽlé rî ꞌê rû trá ní drí tã lẽlẽ áníkâ má ꞌá rî sĩ.” Gõꞌdá kôrô rû ı̣̂ꞌbũ ꞌbá gólâkâ nã drí rû êdézó ngá lãzé íyíkâ ꞌdĩ ꞌásĩ ı̣̃tú-pá ãlô-ãlô ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Gõꞌdá Yésũ yî drí ngãzó nĩlí Pétẽrõ drí ꞌbã ꞌálâ. Gõꞌdá drílĩyî Pétẽrõ rî ãdrá rî ûsúzó ngá lãzé ró ậyı̣́ꞌá gbãrãkã drı̣̃ı̣̂. Rúꞌbạ́ lâ ndrĩ âmê-âmê ró tílí-tílí. ");
INSERT INTO avu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gõꞌdá Yésũ drí ngãzó drı̣́ lâ dõlé. Gõꞌdá kôrô ngá lãzé ꞌdĩ drí rû ndẽzó. Ĩtí rî, Pétẽrõ rî ãdrá ꞌdĩ drí ngãzó ûrû gbãrãkã drı̣̃ı̣̂ sĩ ngá nyãnyã âtrõlé âfẽlé Yésũ yî drí nyãlé lãjóꞌbá gólâkâ rî ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gõꞌdá câ bê lạ̃njạ́túlı̣́ sĩ rî, õjílã ãzâ ꞌbá yî drí õjílã gólĩyî líndrí õnjí drí ômbélé trá rî ꞌbá yî âtrõzó âjílí Yésũ ngálâ. Gõꞌdá Yésũ drí líndrí õnjí ꞌdĩ ꞌbá yî lâdrózó õjílã ꞌdî ꞌbá yî ꞌásĩ cé úlı̣́ âtâ-âtâ sĩ. Gõꞌdá gólâ drí õjílã gólĩyî ndrĩ ngá lãzé bê rî ꞌbá yî îngázó ngá lãzé ĩyíkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yésũ ꞌê tã ꞌdî ĩtí ꞌdĩ, tãlâ úlı̣́ gólâ tã ậngũ ꞌbá Ĩsáyã drí âtálé trá ạ̃kû ró kĩꞌá nĩ rî, gólâ trõ ngá lãzé trá vólé ãmâ rú sĩ, gõꞌdá gólâ êdê ngá lãzé ãmákâ trá rî, ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nĩngá sĩ rî, õjílã dũû drí rĩzó ĩyî ꞌdó ânĩlí Yésũ ngálâ lı̣̃mvû ândrê Gãlĩláyã kâ ꞌdĩ gãrã drı̣̃ lâ ꞌá, tãlâ mbârâkã gólâkâ rĩzó tã lârâkô ꞌdĩ ꞌbá yî ꞌẽlé ꞌdĩ tãsĩ. Gõꞌdá Yésũ ndrê bê õjílã yí lạ̃gạ́tı̣́ dũû ꞌdĩ ꞌbá yî rî, drílâ tã âtázó lãjóꞌbá íyíkâ drí, gólĩyî ẽêdê ró kõlóngbõ njãâ, tãlâ yĩ õmbã ró gólĩyí bê ꞌáꞌá lé drı̣̃ lı̣̃mvû ândrê ꞌdĩ kâ ãzâ lésĩ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ĩtí rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî õtírĩ rĩî kõlóngbõ êdélé rî, gõꞌdá kôrô lãꞌbí îmbá ꞌbá ãzâ drí ânĩzó Yésũ ngálâ. Gõꞌdá drílâ tã âtázó Yésũ drí kĩ, “Tã îmbá ꞌbá, mâ rĩꞌá njãâ ánî vó bẽlé võ gólâ ní drí ꞌẽzó nĩlí ꞌálâ rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yésũ drí tã-drı̣̃ lôgõzó drílâ kĩ, “Õbá yî cú rĩꞌá ꞌbú ĩyíkâ bê rĩzó ꞌá lâ, gõꞌdá ãríwá yî kpá rĩꞌá jó ĩyíkâ ậꞌdú kõ kâ bê. Gõꞌdá mâ rî gógó gólâ Ôvârí drí âjólé ûrú lésĩ rî rĩꞌá võ ãkó rĩzó ꞌá lâ gõꞌdá kpá võ ậꞌdú kõ kâ ãkó.” ");
INSERT INTO avu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nĩngá sĩ rî, ãgô ãzâ gólâ rĩ ꞌbá úlı̣́ Yésũ kâ ârílí rî drí kpá ânĩzó tã âtálé Yésũ drí kĩ, “Kúmú, má lẽ fí trá nĩlí ánî vó bẽlé rî, gõꞌdá má drẽ rĩꞌá tãkõ ámâ átá rî tẽlé ꞌbãlé zãlô ꞌbú ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó ãgô rî ꞌdĩ drí kĩ, “Ní âyê õjílã gólĩyî âꞌdó ꞌbá ãvõ ró rî ꞌbá yî õꞌbã ãvõ ãzí ĩyíkâ. Gõꞌdá ní ânĩ ꞌdẽlé má vósĩ.” ");
INSERT INTO avu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ꞌDĩî vósĩ rî, Yésũ yî drí ngãzó mbãlé kõlóngbõ ꞌá lãjóꞌbá íyíkâ yí bê nĩlí lı̣̃mvû ândrê Gãlĩláyã kâ ꞌdĩ drı̣̃ lâ mbãlé. ");
INSERT INTO avu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gõꞌdá gólĩyî õtírĩ rĩî nĩlí rî, gõꞌdá nyĩî ró, kạ̃gũmạ́ạ̃ ândrê drí îtõzó rĩꞌá sı̣̃lı̣́ õnjí ró. Ĩtí rî, kạ̃gũmạ́ạ̃ ꞌdĩ drí rĩzó kõlóngbõ îyálé mbârâkã sĩ kãgbã-kãgbã. Gõꞌdá kạ̃gũmạ́ạ̃ rî ꞌdĩ drí lı̣̃mvû vı̣̃zó dũû kõlóngbõ ꞌá, gõꞌdá kõlóngbõ drí ꞌẽzó rû îrílí lı̣̃mvû ꞌá. Tã ꞌdî ꞌbá yî õtírĩ rĩî rû ꞌẽlé ꞌdĩ rî, Yésũ rĩꞌá ậꞌdú kõꞌá kõlóngbõ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ĩtí rî, ũrı̣̃ drí fĩzó lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî ꞌá. Gõꞌdá drílĩyî ngãzó nĩꞌá gólâ rî ôlólé ậꞌdú ꞌásĩ ôtrê-ôtrê bê kĩ “Kúmú, ní ngâ ûrû ãmâ pãlé. Ãmâ trá ꞌẽꞌá drãlé nõ.” ");
INSERT INTO avu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Ãnî ũrı̣̃ ró ãꞌdô tãsĩ yã? Tã lẽlẽ ãníkâ má ꞌá rî cé fínyáwá ĩtí ãꞌdô tãsĩ yã?” Gõꞌdá gólâ drí ngãzó âdrélé ûrû tã ꞌbãlé kạ̃gũmạ́ạ̃ ândrê rĩ ꞌbá sı̣̃lı̣́ gõꞌdá lı̣̃mvû rĩ ꞌbá rû îyálé ꞌdĩ bê ãâdrê ró bê. Gõꞌdá kôrô kạ̃gũmạ́ạ̃ ândrê ãmbá rĩ ꞌbá sı̣̃lı̣́ gõꞌdá lı̣̃mvû gólâ rĩ ꞌbá kõlóngbõ îyálé rî bê drí âdrézó. ");
INSERT INTO avu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ĩtí rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ndrê tã gólâ rû ꞌẽ ꞌbá ꞌdĩ bê rî, gólĩyî tı̣̂ drí ậꞌdı̣́zó ndrúndrú. Gõꞌdá drílĩyî ngãzó tã âtálé ĩyî võ ꞌásĩ kĩ, “Ãgô gólâ kạ̃gũmạ́ạ̃ drí tã ꞌbãꞌbã gólâkâ ârízó lı̣̃mvû ãmbá rĩ ꞌbá kõlóngbõ îyálé rî bê nõ íyíkâ ãgô lârâkô ángô rî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gõꞌdá Yésũ yî mbã bê lı̣̃mvû ândrê ꞌdĩ drı̣̃ lâ rî, drílĩyî nĩzó cãlé võ gólâ zı̣̃lı̣́ Gẽrãgésã rî ꞌálâ. Gõꞌdá võ rî ꞌdĩ ꞌá tólâ rî, drílĩyî nĩzó rû ûsúlı̣́ ãgô ãzâ ꞌbá yî rı̣̃ líndrí õnjí ạ̃bạ̃bạ̃ kâ bê rî yí bê. Ãgô rı̣̃ ꞌdî ꞌbá yî rî ĩyî rĩlí ũgı̣́ lóꞌdé kâ rĩzó õjílã ꞌbạ̃drı̣̃ ꞌdî kâ ôdrã ꞌbá rî yî ꞌbãlé ꞌá lâ rî ꞌá. Gõꞌdá líndrí õnjí ꞌdĩ ꞌbá yî ꞌbã ãgô ꞌdĩ ꞌbá yî trá âꞌdólé ạ̃wạ́lạ́kạ́ ró rõô. Tã rî ꞌdĩ tãsĩ, õjílã âꞌdô trá ũrı̣̃ ró ậcı̣́ tõlé lạ́tı̣̂ rî ꞌdĩ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gõꞌdá ãgô ꞌdĩ ꞌbá yî ûsû võ lâ bê kĩꞌá nĩ rî, ꞌdĩî ãꞌdô Yésũ ĩꞌdî rî, líndrí õnjí gólĩyî ꞌá rî ꞌbá yî drí ngãzó rĩꞌá ôtrélé kĩ, “Ôvârí rî mvá, ní lẽ ãꞌdô ꞌî ãmâ drı̣́gạ́ sĩ yã? Ní ânĩ trá lâŋõ fẽlé ãmâ drí drẽ ãkpãkãꞌdã ı̣̃tú gólâ Ôvârí drí ꞌbãlé lâŋõ fẽzó ãmâ drí rî drí âcá ãkó yã?” ");
INSERT INTO avu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ãnyî võ rî ꞌdĩ lạ̃gạ́tı̣́ sĩ rî, ngbíkpí õtólõꞌbĩ rĩꞌá ĩyî ngá nyãꞌá gĩâ nãtí. ");
INSERT INTO avu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gõꞌdá líndrí õnjí ꞌdĩ ꞌbá yî drí ngãzó rúꞌbạ́ lôꞌbãlé Yésũ drí kĩ, “Õzõ ní õlẽ trá ãmâ drõlé vólé rî, ní jô ãmâ nĩꞌá fĩlí õtólõꞌbĩ ngbíkpí nã ꞌbá yí kâ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Gõꞌdá Yésũ drí tã ꞌbãzó líndrí õnjí ꞌdĩ ꞌbá yî drí kĩ, “ꞌDõvó, nĩ âfõ!” Gõꞌdá drílĩyî ngãzó âfõlé, nĩꞌá kôrô fĩlí ngbíkpí ꞌdĩ ꞌbá yî ꞌá. Ĩtí rî, õtólõꞌbĩ ngbíkpí ꞌdĩ ꞌbá yí kâ drí ngãzó ĩyî ndrĩ rãlé ãlólẽ gólókõ lı̣̃mvû ândrê ꞌdĩ kâ ꞌá. Drílĩyî lôꞌdézó lı̣̃mvû ꞌá lı̣̂mvúlı̣́ ôdrãlé ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gõꞌdá ꞌdĩî vósĩ rî, õjílã rĩ ꞌbá ngbíkpí ꞌdĩ ꞌbá yî vó lâ yî ndrẽlé rî ꞌbá yî drí ngãzó ĩyî rãlé jạ̃rı̣́bạ̃ ꞌálâ, nĩꞌá tã ndrĩ Yésũ drí ꞌẽlé líndrí õnjí drõzó ãgô ꞌdĩ ꞌbá yî ꞌásĩ gólĩyî drí ndrẽlé rî tã lâ ngĩlí õjílã tólâ nã ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gõꞌdá õjílã jạ̃rı̣́bạ̃ ꞌdî kâ ꞌdĩ ꞌbá yî ârî ĩyî tã Yésũ drí ꞌẽlé ꞌdĩ bê rî, gólĩyî drí ꞌbãzó ạ̃wạ̃ ró Yésũ rú. Tã ꞌdî tãsĩ rî, drílĩyî ngãzó nĩlí Yésũ ngálâ tã âtálé drílâ rúꞌbạ́ lôꞌbã-lôꞌbã sĩ kĩ, “Ní ngâ fõlé vólé ꞌbạ̃drı̣̃ ãmákâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí mbãzó kõlóngbõ ꞌá lãjóꞌbá íyíkâ yí bê. Drílĩyî ngãzó nĩlí kôrô lı̣̃mvû ândrê Gãlĩláyã kâ ꞌdĩ drı̣̃ı̣̂ sĩ, nĩꞌá gõlé jạ̃rı̣́bạ̃ ĩyî nyãányâ kâ Kãpẽrãnómã rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Gõꞌdá gólĩyî câ bê Kãpẽrãnómã ꞌálâ rî, õjílã ãzâ ꞌbá yî drí ãgô ãzâ gólâ pá lâ yî drí drãzó trá rî âtrõzó gbãrãkã drı̣̃ı̣̂ âjílí Yésũ ngálâ, gólâ ĩîngâ ró ãgô ꞌdĩ bê. Gõꞌdá Yésũ ndrê tã õjílã ꞌdî ꞌbá yî drí ꞌẽlé ãgô ꞌdĩ âtrõzó âjízó yí ngálâ ꞌdĩ bê rî, gólâ drí nı̣̃zó lâ kĩ, gólĩyî lẽ tã trá mbârâkã íyíkâ rĩzó õjílã îngálé ngá lãzé ꞌásĩ rî ꞌá. Gõꞌdá drílâ ngãzó tã âtálé ãgô rî gógó ꞌdĩ drí kĩ, “Ámâ rû-lẽ-ãzíyã, ní ꞌê ũrı̣̃ kô. Áâyê nî trá tã õnjí áníkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Gõꞌdá lãꞌbí îmbá ꞌbá ãzâ ꞌbá yî bê rĩꞌá ĩyî võ rî ꞌdĩ ꞌá tólâ. Gõꞌdá gólĩyî ârílí bê úlı̣́ Yésũ kâ âtálé ãgô rî ꞌdĩ drí rî, drílĩyî îtõzó rĩꞌá tã âtálé ĩyî lãfálé ꞌásĩ kĩ, “Ãgô ꞌdĩ rî úlı̣́ âtálé ĩtí ꞌdĩ ãꞌdô tãsĩ yã? Gólâ ı̣̂sũ íyíkâ bê rî kĩ, yí ãꞌdô Ôvârí ꞌî yã? Ôvârí rî cé nĩ rĩꞌá tã õnjí õjílã kâ âyélé.” ");
INSERT INTO avu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Gõꞌdá Yésũ nı̣̃ tã ı̣̂sũ gólĩyíkâ ányâ ró yí rú ꞌdĩ trá tõ. Yésũ drí gõzó tã âtálé drílĩyî kĩ, “Nĩ rî tã ı̣̂sũlı̣́ má rú ányâ ró ĩtí ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","7","Mâ gólâ âjólé ûrú lésĩ rî cú rĩꞌá drı̣́-ãcê bê ãngó nõ ꞌá tã õnjí âyézó. Âꞌdô ꞌbãꞌá cú ĩtí lâŋõ ãkó má drí tã õnjí õjílã kâ âyézó cé úlı̣́ âtâ-âtâ sĩ. Gõꞌdá õzõ má ĩîngâ ãgô pá lâ drí drãlé nõ trá ûrû ậcı̣́ tõlé cé úlı̣́ âtâ-âtâ sĩ rî, ꞌdĩî âꞌdô âꞌdálâ kĩ, mâ cú rĩꞌá drı̣́-ãcê bê tã õnjí gólâkâ âyézó.” Gõꞌdá ĩtí rî, Yésũ drí ngãzó tã âtálé ãgô pá lâ drí drãlé ꞌdĩ drí kĩ, “Ní ngâ ûrû!” Gõꞌdá kôrô ãgô ꞌdĩ pá lâ drí âmbázó âcálé tãndí ró, gõꞌdá drílâ ngãzó âdrélé ûrû. Gõꞌdá Yésũ drí tã âtázó gólâ drí kĩ, “Ní njı̣̃ gbãrãkã áníkâ nĩzó gõlé ꞌbã ꞌálâ.” Nĩngá sĩ, ãgô ꞌdĩ drí gbãrãkã íyíkâ njı̣̃zó nĩzó gõlé yí drí ꞌbã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gõꞌdá õjílã õꞌbí tólâ nã ꞌbá yî ndrê ĩyî tã lârâkô Yésũ drí ꞌẽlé ꞌdĩ bê rî, gólĩyî tı̣̂ drí ậꞌdı̣́zó ndrúndrú. Gõꞌdá drílĩyî îtõzó rĩꞌá Ôvârí rî lûyı̣́lı̣́, tãlâ gólâ âfẽ mbârâkã trá ãmbá Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Gõꞌdá nĩngá sĩ, Yésũ yî âyê võ ꞌdî bê rî, drílĩyî ngãzó nĩlí ậcı̣́ ĩyíkâ ꞌá. Gõꞌdá drílĩyî nĩzó ãgô ãzâ bélé-bélé ûꞌdú ꞌbá ró rú bê Mãtáyõ rî ûsúlı̣́ rĩꞌá võ íyíkâ bélé-bélé ûꞌdû kâ ꞌá. Gõꞌdá Yésũ ndrê gólâ bê rî, Yésũ drí tã âtázó drílâ kĩ, “Ní ânĩ ámâ vó bẽlé lãjóꞌbá ámákâ ró.” Gõꞌdá kôrô Mãtáyõ drí ngãzó ûrû ꞌdẽlé Yésũ vósĩ. ");
INSERT INTO avu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kậyı̣̂ ãzâ sĩ, Mãtáyõ drí Yésũ yî ậzı̣́zó lãjóꞌbá gólâkâ yí bê yí drí ꞌbã ꞌálâ ngá nyãlé yí bê. Gõꞌdá gólâ drí kpá íyî rû-lẽ-ãzí yî bélé-bélé ûꞌdú ꞌbá ró rî ꞌbá yî gõꞌdá kpá õjílã ãzâ ꞌbá yî gólĩyî Pạ̃rúsı̣̃ yî drí rĩꞌá ndrẽlâ tã õnjí ꞌbá ró rî yí bê ậzı̣́zó ânĩlí ngá nyãlé Yésũ yí bê. ");
INSERT INTO avu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Gõꞌdá Pạ̃rúsı̣̃ ãzâ ꞌbá yî nı̣̃ ĩyî bê tã Yésũ yî drí ngá nyãzó bélé-bélé ûꞌdú ꞌbá yí bê gõꞌdá õjílã tíbê gólĩyî drí rĩꞌá ndrẽlâ tã õnjí ꞌbá ró rî ꞌbá yí bê ꞌdĩ rî, drílĩyî ngãzó ânĩlí lãjóꞌbá Yésũ kâ rî ꞌbá yî ngálâ tã âtálé Yésũ rú ạ̃wạ̃ sĩ kĩ, “Tãlâ ãꞌdô ꞌî tã îmbá ꞌbá ãníkâ drí rĩzó ngá nyãlé võ ãlô ꞌá õjílã õnjí ĩtí ꞌdĩ ꞌbá yí bê yã?” ");
INSERT INTO avu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Gõꞌdá Yésũ ârî tã Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí âtálé ꞌdĩ bê rî, drílâ gõzó tã âtálé Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ, “Õjílã gólâ ngá lãzé ãkó rî nĩí kô ãlókõ ꞌbá ngálâ, cé gólĩyî ngá lãzé ró rî ꞌbá yî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nĩ ârî drẽ gõꞌdá nĩ ı̣̂sũ drẽ úlı̣́ gólâ Ôvârí drí âtálé búkũ íyíkâ ꞌá rî, tã lâ kĩꞌá nĩ rî, ‘Tã gólâ lậvũ ꞌbá gạ̃rạ̃ tã kõrõnyã zã kâ ngá fẽfẽ ró má drí rî drı̣̃ı̣̂ rî sĩ ĩꞌdî nõ, nĩ âꞌdô ngá lẽlẽ bê õjílã ãzí drí.’ Gõꞌdá má ânĩí kô tã mbı̣̂ ꞌbá pãlé, má ânĩ tã õnjí ꞌbá ậzı̣́lı̣́, tãlâ ópâ ró gólĩyî bê tã õnjí gólĩyíkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nĩngá sĩ, tã ârí ꞌbá Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî kâ ãzâ ꞌbá yî drí ânĩzó ĩyî Yésũ ngálâ tã îjílí gólâ tı̣́ kĩ, “Ãmâ tã ârí ꞌbá Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî kâ rî ꞌbá yî gõꞌdá tã ârí ꞌbá Pạ̃rúsı̣̃ kâ rî ꞌbá yí bê, kậyı̣̂ ãzâ ꞌbá yî sĩ, mã rî tı̣̂ ꞌbĩlí rĩzó ꞌálé ꞌãꞌí sĩ rãtáã ꞌẽlé Ôvârí drí. Gõꞌdá lãjóꞌbá áníkâ rî ꞌbá yî rí ĩyî kô tı̣̂ ꞌbĩlí ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Âꞌdô âꞌdóꞌá íyíkâ ángô tí ró ũmú drí tı̣̂ ꞌbĩzó ĩzã âꞌdálé võ kãrámã kâ ꞌá õdrógô drí ꞌbãrẽ drẽ bê gólĩyî lãfálé ꞌá rî yã? ꞌDĩî îcá kô. Gõꞌdá ı̣̃zạ́tú rî, kậyı̣̂ âꞌdô âcáꞌá õdrógô drí âꞌdózó yû gólĩyî lãfálé. Gõꞌdá kậyı̣̂ rî ꞌdĩ sĩ, gólĩyî drí gõzó rĩlí ꞌálé ꞌãꞌí sĩ tı̣̂ ꞌbĩlí ĩzã drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Gõꞌdá nĩ ı̣̂sũ drẽ kpá tã ítá ạ̃kû gólâ sĩ ꞌbá trá rî tã lâ. Õzõ õjílã ãzâ õŋõ ítá óꞌdí lôsélé ũpı̣̃ ítá ạ̃kû gólâ sĩ ꞌbá trá ꞌdĩ kâ rú gõzó jĩlâ lı̣̃mvû sĩ rî, ítá gólâ óꞌdí ꞌdĩ âꞌdô íyîngá ôróꞌá ânjólé vólé ítá ạ̃kû ꞌdĩ rú sĩ, ũpı̣̃ lâ drí rĩzó hõwéẽ ậvû-ậvû ró lậvũlı̣́ gạ̃rạ̃ sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Gõꞌdá âꞌdó kô tãndí ró õjílã ãzâ drí õdrá óꞌdí lôrózó mõrá gólâ ạ̃kû mbârâkã ãkó rî ꞌá. Gólâ õꞌê trá ĩtí rî, gõꞌdá õdrá õtírĩ ângá rî, mõrá ạ̃kû ꞌdĩ âꞌdô pı̣̃ꞌá, õdrá ꞌdĩ drí lâsózó vũdrı̣́ rû îzãlé. Ĩtí rî, órî õdrá óꞌdí lôrólâ mõrá gólâ tãndí ró rî ꞌá. Tã ꞌdî tãsĩ rî, âꞌdô rĩꞌá dódó cú ĩtí rû îzã ãkó. Gõꞌdá tã îmbâ ámákâ ꞌdĩ rĩꞌá tã îmbâ óꞌdí gólâ îcá ꞌbá kô ônjálé lãꞌbí ạ̃kû bê rî ĩꞌdî, rĩꞌá õzõ ítá óꞌdí ꞌdĩ gõꞌdá õdrá óꞌdí ꞌdĩ bê rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gõꞌdá nĩngá sĩ, Yésũ drẽ rĩꞌá tã âtáꞌá tã ârí ꞌbá Yõwánĩ kâ ꞌdĩ ꞌbá yî drí rî, gõꞌdá ãgô ãzâ gólâ âꞌdó ꞌbá jó tã Ôvârí kâ ârî kâ vó lâ ndrẽ ꞌbá ró rî drí ânĩzó Yésũ ngálâ ꞌãꞌî tı̣̃lı̣́ vũdrı̣́ gólâ ândrá rúꞌbạ́ lôꞌbãlé drílâ kĩ, “Óõ kúmú, ámâ mvá ãnjó drã trá ngbãângbânõ. Gõꞌdá õzõ ní ãânĩ gólâ ngálâ drı̣́ ꞌbãlé rúꞌbạ́ lâ ꞌá rî, gólâ âꞌdô lîdríꞌá óꞌdí õdrã ꞌásĩ rĩlí lédrẽ-lédrẽ ró.” ");
INSERT INTO avu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ĩtí rî, kôrô Yésũ yî drí ngãzó nĩlí lãjóꞌbá íyíkâ yí bê ꞌdẽlé ãgô ꞌdĩ vó lâ bẽlé. ");
INSERT INTO avu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Gõꞌdá gólĩyî õtírĩ ꞌbãâ rĩꞌá nĩꞌá lạ́tı̣̂ ꞌásĩ rî, õkó ãzâ drí ânĩzó. Õkó ꞌdĩ rĩꞌá cú ngá lãzé párá kâ bê. Ngá lãzé rî ꞌdĩ ꞌê õkó ꞌdĩ trá ndrô mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ sĩ. Drílâ ânĩzó Yésũ ũgúlı̣́ lésĩ ró, ânĩꞌá ítá tı̣̂ Yésũ kâ dõlé kírî ró. ");
INSERT INTO avu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gólâ ı̣̂sũ tã trá yí ꞌá kĩ, õzõ yí õdõ kó cé ítá tı̣̂ Yésũ kâ ꞌdĩ ĩꞌdî rî, yí ãâꞌdô rû êdéꞌá ngá lãzé íyíkâ ꞌdĩ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Gõꞌdá Yésũ ûsû tã õkó ꞌdĩ drí ꞌẽlé ꞌdĩ võ lâ bê rî, drílâ gõzó íyî jãlé võ ndrẽlé õkó ꞌdĩ ngálâ, gõꞌdá drílâ tã âtázó kĩ, “Ámâ îzó, ánî pı̣̃pı̣̂sı̣́lı̣́ ạ̃ậꞌdı̣̂. Tã lẽlẽ áníkâ má ꞌá rî êdê nî trá ngá lãzé ꞌdĩ ꞌásĩ.” Gõꞌdá kôrô ãrí rĩ ꞌbá rãlé õkó ꞌdĩ rú sĩ rî drí âdrézó. ");
INSERT INTO avu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Gõꞌdá Yésũ yî drí ngãzó lậvũlı̣́ nĩꞌá cãlé ãgô drı̣̃-ꞌbá ró ꞌdĩ drí ꞌbã ꞌálâ ãgô rî gógó ꞌdĩ yí bê. Gõꞌdá gólĩyî câ bê tólâ rî, gólĩyî drí õjílã dũû ûsúzó rĩꞌá ĩyî kángá yî võꞌá gûnı̣́yạ́ yí bê, gõꞌdá ãzâ ꞌbá yî rĩꞌá ĩyíkâ ãwó ngõꞌá. Võ trá bárábányá ró. ");
INSERT INTO avu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nĩngá sĩ, Yésũ drí gõzó tã âtálé õjílã ꞌdî ꞌbá yî drí kĩ, gólĩyî õfõ ndrĩ ĩví ꞌálâ jó mvá ãvõ bê ꞌdĩ ꞌásĩ. Gólâ kĩ gólĩyî drí rî, “Ízá ꞌdĩ drãá kô. Gólâ rî ꞌdĩ íyîngá ậꞌdú kõꞌá.” Gõꞌdá õjílã ꞌdî ꞌbá yî ârî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, drílĩyî ngãzó rĩꞌá Yésũ rî gũlı̣́ gbõ gũgũ. ");
INSERT INTO avu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gõꞌdá õjílã ꞌdî ꞌbá yî fõ ĩyî bê ĩví ꞌálâ rî, Yésũ drí ngãzó fĩlí jó gólâ mvá ãvõ bê ꞌdĩ ꞌá. Gõꞌdá drílâ ízámvá ꞌdĩ drı̣́ lâ rũzó, gõꞌdá kôrô ízámvá ꞌdĩ drí ngãzó ûrû lédrẽ-lédrẽ ró. ");
INSERT INTO avu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gõꞌdá nĩngá sĩ rî, tã lârâkô Yésũ drí ꞌẽlé ꞌdĩ tã lâ drí lậꞌbúzó ndrĩ ꞌbạ̃drı̣̃ ꞌdî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ngãzó võ ꞌdî âyélé nĩzó zãâ ậcı̣́ ĩyíkâ ꞌá ạ̃tı̣́ ꞌálâ. Gólĩyî õtírĩ rĩî nĩlí lạ́tı̣̂ ꞌásĩ rî, ãgô ãzâ ꞌbá yî rı̣̃ lı̣̃fı̣́ ãkó lé ꞌbá ró rî ꞌbá yî drí ꞌdẽzó Yésũ yî vósĩ. Gõꞌdá drílĩyî ngãzó trẽlé ûrû lạ̃zı̣́ zı̣̃zı̣̃ bê kĩ nĩ rî, “Yésũ Dạ̃wúdı̣̃ rî ózõwá, ní ndrê ãmâ ĩzã! Ní pâ ãmâ!” ");
INSERT INTO avu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Gõꞌdá Yésũ yî drí ngãzó kũlı̣́ ãgô rı̣̃ ꞌdî ꞌbá yí bê ꞌbã gólĩyî drí rĩzó ꞌálâ lãjóꞌbá íyíkâ bê rî ꞌá. Gõꞌdá Yésũ drí ãgô lı̣̃fı̣́ ãkó lé ꞌbá ꞌdĩ ꞌbá yî îjízó kĩ, “Nĩ lẽ tã trá kĩ, má âꞌdô îcáꞌá ãnî lı̣̃fı̣́ êdélé yã?” Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ãwô kúmú, mã lẽ tã trá.” ");
INSERT INTO avu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ĩtí rî, Yésũ drí gólĩyî lı̣̃fı̣́ dõzó tã âtâ-âtâ bê kĩ, “ꞌDõvó ãnî lı̣̃fı̣́ ẽêdê rû tãlâ tã lẽlẽ ãníkâ má ꞌá ꞌdĩ tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Gõꞌdá kôrô, gólĩyî lı̣̃fı̣́ drí rû njı̣̃zó võ ndrẽlé ngbángbá. Nĩngá sĩ rî, Yésũ drí drı̣́-mbílí sõzó gólĩyî lı̣̃fı̣́ kĩ, “Tã lârâkô gólâ rû ꞌẽ ꞌbá ãnî drí ꞌdĩ, nĩ âtâ tã lâ kô õjílã ãzãkã drí ãlôwálâ.” ");
INSERT INTO avu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Gbõ lé Yésũ âtâ tã bê ĩtí rî, ãgô rî ꞌdĩ ꞌbá yî drí nĩzó tã Yésũ drí gólĩyî lı̣̃fı̣́ êdézó ꞌdĩ tã lâ âtá bê õjílã drí. Ĩtí rî, tã rî ꞌdĩ drí lậꞌbúzó ndrĩ ꞌbạ̃drı̣̃ ꞌdî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gõꞌdá ãgô gólĩyî Yésũ drí lı̣̃fı̣́ lâ yî êdélé trá ꞌdĩ ꞌbá yî lậvũ ĩyî bê rî, õjílã ãzâ ꞌbá yî drí ãgô ãzâ líndrí õnjí drí rĩꞌá ômbélé gõꞌdá gólâ rî ꞌbã ꞌbá úlı̣́ âtálé kô rî âtrõzó âjílí Yésũ ngálâ. ");
INSERT INTO avu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Gõꞌdá Yésũ drí líndrí õnjí ꞌdĩ drõzó vólé ãgô ꞌdĩ ꞌásĩ, gõꞌdá kôrô ãgô ꞌdĩ drí ngãzó rĩꞌá úlı̣́ âtálé. Ĩtí rî, õjílã dũû gólĩyî tã ꞌdî ndrẽ ꞌbá rî yî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó ndrúndrú. Gõꞌdá drílĩyî ngãzó tã âtálé kĩ, “Mã ndré drẽ tã lârâkô nõtí nõ kó kô rû ꞌẽrẽ ꞌá ꞌbạ̃drı̣̃ Ĩsĩrãꞌélẽ kâ ꞌá nõngá.” ");
INSERT INTO avu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gõꞌdá Pạ̃rúsı̣̃ ãzâ ꞌbá yî kpá bê tólâ. Gõꞌdá gólĩyî ndrê bê ãgô ꞌdĩ úlı̣́ âtárẽ ꞌá gõꞌdá kpá ârî úlı̣́ õjílã ꞌdî ꞌbá yí kâ bê rî, drílĩyî ngãzó tã âtálé Yésũ rú kĩ, “Mbârâkã gólâ Yésũ drí rĩzó tã lârâkô ꞌẽlé ĩꞌdî sĩ lâ ꞌdĩ, drı̣̃-ꞌbá líndrí õnjí kâ Sãtánã fẽ mbârâkã ꞌdî nĩ Yésũ drí líndrí õnjí ꞌdĩ lôfõzó ãgô ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ngãzó nĩꞌá lậmú bê lãjóꞌbá íyíkâ yí bê jạ̃rı̣́bạ̃ Gãlĩláyã kâ rî ꞌbá yî ꞌásĩ ndrĩ gõꞌdá kpá võ mvá õnyíkõ Gãlĩláyã ꞌá rî ꞌbá yî ꞌásĩ ndrĩ. Võ rî ꞌdĩ ꞌbá yî ꞌásĩ cé tı̣̂tı̣̂, Yésũ rî trá õjílã lı̣̃fı̣́ îmbá bê jó tã Ôvârí kâ ârî kâ ꞌásĩ. Gõꞌdá gólâ rî kpá trá nĩꞌá tã âtî-âtî tãndí pẽ bê õjílã drí, tãlâ gólĩyî õjâ ró ĩyî nyãányâ ꞌbãlé kũmũ Ôvârí kâ zẽlé õjílã gólâkâ ró. Gõꞌdá gólâ drí kpá rĩzó õjílã ndrĩ gólĩyî ngá lãzé bê rî ꞌbá yî îngálé ngá lãzé gólĩyíkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gõꞌdá Yésũ ndrê bê õꞌbí rû êꞌbé ꞌbá yí lạ̃gạ́tı̣́ rĩ ꞌbá tã îmbâ íyíkâ ârílí ꞌdĩ ꞌbá yî rî, gólâ drí âꞌdózó tã ı̣̂sũ ró gólĩyî tãsĩ, tãlâ gólĩyî rĩꞌá lâŋõ bê ãmbá, õjílã ãzâ yû gólĩyî pãlé. Gólĩyî rĩꞌá nyé õzõ kạ́bı̣̃lı̣́kı̣̃ gólĩyî âꞌdó ꞌbá lôkí ꞌbá ãkó rî kâtí gólâ rî lı̣̃fı̣́ drı̣̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nĩngá sĩ, Yésũ drí gõzó tã âtálé lãjóꞌbá íyíkâ yî drí õjílã dũû gólĩyî âꞌdó ꞌbá lâŋõ bê ãmbá ꞌdĩ ꞌbá yî tãsĩ kĩ nĩ rî, “Nĩ ndrê drẽ, ngá-ĩyínyâ ạ́mvú ꞌá rî rĩꞌá ãmbá, trá njãâ ꞌẽꞌá lôsĩ lâ ꞌẽlé, gõꞌdá õjílã gólĩyî ꞌẽ ꞌbá lôsĩ lâ ꞌẽlé rî rĩꞌá cé dã. ");
INSERT INTO avu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tã ꞌdî tãsĩ rî, nĩ ꞌê rãtáã Ôvârí gólâ ạ́mvú lı̣́pı̣̂ ró rî drí, gólâ ãâjô ró bê õjílã dũû ânĩlí lôsĩ ꞌẽlé ạ́mvú gólâkâ ꞌdĩ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ drí lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yî ậzı̣́zó yí ngálâ. Gõꞌdá drílâ drı̣́-ãcê fẽzó drílĩyî, tãlâ gólĩyî õnĩ ró ĩyî líndrí õnjí lâdró bê õjílã ꞌásĩ, gõꞌdá kpá õjílã gólĩyî ngá lãzé bê rî ꞌbá yî îngá bê ngá lãzé tı̣̂ ngĩíngî gólĩyíkâ rî ꞌbá yî ꞌásĩ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lãjóꞌbá Yésũ kâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yî rú lâ ĩyî ĩꞌdî nõ, Sĩmónã gólâ kpá rĩꞌá zı̣̃lâ Pétẽrõ rî, ậdrúpı̣̃ lâ Ãndĩríyã, Zẽbẽdáyõ rî mvá yî Yãkóbã yî Yõwánĩ bê, ");
INSERT INTO avu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fílĩpõ, Bãtõlõméyõ, Tómã, Mãtáyõ bélé-bélé ûꞌdú ꞌbá ró rî, Yãkóbã Ãlõpáyã rî mvá, Tãdéyõ, ");
INSERT INTO avu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sĩmónã gólâ ạ̃kû ró âsĩ ꞌbá trá ạ̃jú ꞌbũlı̣́ mı̣́rı̣̃ Rómã kâ bê rî, gõꞌdá Yúdạ̃ Ĩsĩkãrĩyótã gólâ ꞌẽ ꞌbá Yésũ rî drı̣́-bã fẽlé fũlı̣́ rî. ");
INSERT INTO avu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Gõꞌdá Yésũ drí gõzó tã âtálé lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî drí ậcı̣́ gólĩyíkâ ꞌẽꞌá tõlâ ꞌdĩ tãsĩ kĩ, “Mĩ nĩ kô õjílã gólĩyî âꞌdó ꞌbá kô õjílã Yúdạ̃ yí kâ ró rî ꞌbá yî ngálâ gõꞌdá kpá õjílã gólĩyî âꞌdó ꞌbá Sãmárĩyã lé ꞌbá ró rî ꞌbá yî ngálâ. ");
INSERT INTO avu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mĩ nĩ bê-rî cé õjílã ãmákâ Ĩsĩrãꞌélẽ kâ gólĩyî âꞌdó ꞌbá õzõ kạ́bı̣̃lı̣́kı̣̃ gólĩyî kũ ꞌbá trá lạ́tı̣̂ mbı̣̂ ꞌásĩ rî ꞌbá yí kâtí rî ꞌbá yî ngálâ, nĩ pẽ ró úlı̣́ Ôvârí kâ bê gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gõꞌdá võ cé tı̣̂tı̣̂ ãnî drí ꞌẽzó nĩlí ꞌálâ sĩ rî ꞌbá yî ꞌásĩ rî, nĩ pẽ tã õjílã drí kĩ nĩ rî, ‘Kậyı̣̂ gólâ Ôvârí drí ꞌbãlé õjílã drí ꞌẽzó rĩlí kũmũ íyíkâ zẽlé rî âbí ꞌẽꞌá âcálé ꞌwãâ ró.’ ");
INSERT INTO avu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Õzõ nĩ ũûsû gólĩyî ngá lãzé bê rî ꞌbá yî trá rî, nĩ îngâ gólĩyî ngá lãzé ĩyíkâ ꞌásĩ. Gõꞌdá nĩ îngâ gólĩyî ôdrã ꞌbá trá rî yî õdrã ꞌásĩ. Gólĩyî ngá lãzé ãrí kâ bê rî ꞌbá yî, nĩ êdê gólĩyî ngá lãzé gólĩyíkâ ꞌdĩ ꞌásĩ. Gõꞌdá gólĩyî líndrí õnjí bê rî ꞌbá yî, nĩ lâdrô líndrí ꞌdĩ ꞌbá yî vólé gólĩyî ꞌásĩ. Nĩ ꞌê tã ꞌdî ꞌbá yî tãkó cú ĩtí ngá ãzãkã zı̣̃ ãkó gólĩyî tı̣́ sĩ, tãlâ má fẽ drı̣́-ãcê trá ãnî drí tãkó ĩtí tã lârâkô ꞌdĩ ꞌbá yî ꞌẽzó. ");
INSERT INTO avu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gõꞌdá ĩtí rî, nĩ trõ ậdı̣̂ ãzãkã kô ãní bê ậcı̣́ ãnî drí ꞌẽꞌá tõlâ ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gõꞌdá nĩ trõ jõráã ítá ꞌbã kâ kpá kô ãní bê. Gõꞌdá nĩ trõ ítá, ngãtá káꞌbókã, ngãtá pı̣̃drı̣́gú ãzâ kpá kô ãní bê. Nĩ ndrê drẽ, rĩꞌá mbı̣̂ õjílã drí ngá ãnî drí âꞌdózó ĩzã lâ bê tã lâ tãsĩ lôsĩ Ôvârí kâ ꞌẽzó rî ꞌbá yî fẽzó ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Õzõ nĩ õcâ trá jạ̃rı̣́bạ̃ ãzâ ꞌá ngãtá võ mvá ãzâ ꞌá yã rî, õzõ nĩ ũûsû õjílã tãndí gólâ njãâ ꞌẽ ꞌbá ãnî lậgúlı̣́ yí drí ꞌbã ꞌá ũmú ró rî trá rî, nĩ rî ꞌbã rî ꞌdĩ ꞌá nĩngá cãlé bũúũ kậyı̣̂ gólâ ãnî drí ꞌẽzó võ ꞌdî âyélé lậvũzó ạ̃tı̣́ ꞌálâ rî tú. ");
INSERT INTO avu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gõꞌdá õzõ nĩ õfî trá ꞌbã ãzâ ꞌá rî, nĩ âtâ tã kĩ, Ôvârí ãâꞌdô õjílã ꞌbã rî ꞌdĩ kâ rî ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Õzõ gólĩyî õlậgû ãnî trá rî, Ôvârí âꞌdô âꞌdóꞌá gólĩyí bê. Gõꞌdá õzõ gólĩyî õgâ vólé trá dó ãnî lậgúlı̣́ rî, nĩ âyê ꞌbã rî ꞌdĩ, nĩ lậvũ vólé nĩngá sĩ. Ĩtí rî, Ôvârí îcá kô âꞌdólé gólĩyí bê. ");
INSERT INTO avu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gõꞌdá õzõ õjílã jạ̃rı̣́bạ̃ ãzâ ꞌbá yí kâ ngãtá õjílã ꞌbã ãzâ ꞌbá yí kâ õlậgû ĩyî ãnî kô rî, gõꞌdá gólĩyî õgâ vólé trá dó úlı̣́ Ôvârí kâ ãnî drí pẽlé rî ârílí rî, nĩ âyê võ rî ꞌdĩ. Nĩ õtírĩ võ rî ꞌdĩ âyé rî, nĩ îyâ tạ̃pı̣́lı̣́ndrı̣́ võ rî ꞌdĩ kâ vólé ãnî pá ágálé ꞌásĩ lãmbé lãtrí kâ ró gólĩyî rú. ");
INSERT INTO avu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, kậyı̣̂ gólâ Ôvârí drí ꞌẽzó tã-vó õjílã ndrĩ kâ kĩlí rî tú rî, lâŋõ gólâ Ôvârí drí ꞌẽꞌá fẽlâ õjílã gólĩyî vólé gã ꞌbá tã ãníkâ ârílí ꞌdĩ ꞌbá yî drí rî, âꞌdô lậvũꞌá gạ̃rạ̃ lâŋõ gólâ Ôvârí drí fẽlé trá ạ̃kû ró õjílã Gõmórã kâ gõꞌdá Sõdómõ kâ bê rî ꞌbá yî drí rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nĩngá sĩ, Yésũ drí tã âtázó lãjóꞌbá íyíkâ drí lâŋõ gólĩyî drí ꞌẽꞌá ûsúlâ rî tãsĩ kĩ nĩ rî, “Nĩ ârî drẽ! Mâ ꞌẽꞌá ãnî jõlé úlı̣́ Ôvârí kâ pẽlé õjílã gólĩyî tã ámákâ lẽ ꞌbá kô rî ꞌbá yî drí. Õjílã rî ꞌdĩ ꞌbá yî rĩꞌá nyé õzõ ápápá gólâ rĩ ꞌbá ꞌạ̃ꞌú mvá lôkólé rî kâtí. Gólĩyî âꞌdô ꞌẽꞌá lâŋõ fẽlé ãnî drí. Ĩtí rî, ãnî lı̣̃fı̣́ õmbâ ãnî rú õzõ kákárá lı̣́mú lı̣̃fı̣́ drí mbãrẽ rî kâtí. Nĩ ꞌbã ãnî âꞌdólé nyé õzõ ạ̃túꞌbú kâtí, tã õnjí ãzâ ꞌẽ ãkó gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ãnî lı̣̃fı̣́ õmbâ ãnî rú, tãlâ õjílã Yúdạ̃ yí kâ ãzâ ꞌbá yî âꞌdô ĩyî ꞌẽꞌá ãnî rũlı̣́ cãlé ônjóróꞌbí sĩ jó gólĩyíkâ tã Ôvârí kâ ârî kâ ꞌá. Gõꞌdá õjílã âꞌdô ãnî trõꞌá âjílí tã kĩ ꞌbá ândrá võ tã kĩ kâ ꞌá tã ãníkâ kĩlí. ");
INSERT INTO avu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Õjílã âꞌdô ãnî trõꞌá kpá âjílí drı̣̃-ꞌbá ạ́ngı̣́ ꞌbạ̃drı̣̃ kâ rî ꞌbá yî ândrá tã ãníkâ kĩlí, tãlâ ãnî bê rĩꞌá lãjóꞌbá ámákâ ró rî drí sĩ. Õzõ gólĩyî ãâjî ãnî trá tã kĩ ꞌbá ꞌdĩ ꞌbá yî ândrá rî, ꞌdĩî trá ândrâ-tãndĩ gólâ ãnî drí ꞌẽzó tã ámákâ âꞌdálé gólĩyî drí, gõꞌdá kpá õjílã ãzâ ꞌbá yî gólĩyî âꞌdó ꞌbá kô õjílã Yúdạ̃ yí kâ ró rî ꞌbá yî drí rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gõꞌdá õzõ áãâtrõ ãnî trá âjílí tã kĩ ꞌbá ândrá tã-vó ãníkâ kĩlí rî, nĩ ꞌê ũrı̣̃ kô tã gólĩyî ãnî drí ꞌẽꞌá âtálâ gólĩyî drí rî ꞌbá yî tãsĩ, tãlâ áâꞌdô tã gólĩyî ãnî drí ꞌẽꞌá âtálâ rî fẽꞌá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nĩ ndrê drẽ, Líndrí Tãndí ãnî átá Ôvârí kâ rî âꞌdô úlı̣́ gólĩyî ãnî drí ꞌẽꞌá âtálâ rî ꞌbá yî âꞌdáꞌá nĩ ãnî drí âtálé. Úlı̣́ ꞌdĩ ꞌbá yî âꞌdó kô ãnî nyãányâ kâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Õjílã âꞌdô rû jãꞌá tã lẽ ꞌbá má ꞌá rî ꞌbá yî rú. Õjílã ãzâ ꞌbá yî âꞌdô rû jãꞌá ĩyî ậdrúpı̣̃ yî drı̣́-bã fẽlé fũlı̣́ ũrı̣̃ drí sĩ, gõꞌdá mvá rî átá yî âꞌdô kpá rû jãꞌá ãkpã mvá lâ yî drı̣́-bã fẽlé fũlı̣́, gõꞌdá ꞌdĩyímvá yî âꞌdô kpá rû jãꞌá ãkpã átá lâ yî gõꞌdá ândrê lâ yí bê drı̣́-bã lâ yî fẽlé fũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Õjílã gólĩyî tã lẽ ꞌbá má ꞌá kô rî ꞌbá yî âꞌdô rû jãꞌá ãnî rú. Gólĩyî ꞌbãá ãnî lôvó kô tãlâ tã lẽlẽ ãníkâ âꞌdózó õjílã ámákâ ró ꞌdĩ tãsĩ. Gólĩyî ndrĩ tíbê tã lẽlẽ ĩyíkâ má ꞌá rî ậtı̣̃ ꞌbá gạ́gạ́ rĩzó zãâ ĩꞌdî bê lâ rî, gólĩyî âꞌdô ngá pãpã ûsúꞌá. ");
INSERT INTO avu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Õzõ õjílã õfẽ ĩyî lâŋõ trá ãnî drí jạ̃rı̣́bạ̃ ãlô rî ꞌá rî, nĩ âyê jạ̃rı̣́bạ̃ rî ꞌdĩ. Nĩ râ tã ámákâ pẽlé õjílã jạ̃rı̣́bạ̃ ãzâ kâ rî ꞌbá yî drí. Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, nĩ îcá kô lôsĩ ãníkâ tã pẽpẽ kâ ndẽlé jạ̃rı̣́bạ̃ Ĩsĩrãꞌélẽ kâ dũû rî ꞌbá yî ꞌásĩ ndrĩ, drẽ ãkpãkãꞌdã mâ rî gógó Ôvârí drí âjólé ûrú lésĩ nõ drí âgõ ãkó. ");
INSERT INTO avu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Má âtâ ãnî drí, ı̣́ı̣̂njı̣̃ı̣́ tã ârí ꞌbá kô lậvũlı̣́ gạ̃rạ̃ tã îmbá ꞌbá gólâkâ drı̣̃ı̣̂ sĩ. Gõꞌdá ı̣́ı̣̂njı̣̃ı̣́ rạ̃gı̣́ı̣̃ kpá kô lậvũlı̣́ gạ̃rạ̃ gólâ rî lı̣́pı̣̂ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Gõꞌdá ãnî lãjóꞌbá ámákâ rî ꞌbá yî, õzõ õjílã õrî ĩyî tã ꞌẽlé ãnî drí õzõ drílĩyî ꞌẽrẽ lâ mâ tã îmbá ꞌbá ãníkâ ró rî drí rî tí rî, nĩ âꞌdô ãyĩkõ ró. Ãnî gólĩyî rạ̃gı̣́ı̣̃ ró rî ꞌbá yî kpá rĩꞌá ĩtí. Nĩ nı̣̃ trá kĩ, rĩꞌá mbı̣̂ õjílã drí rĩzó tã ꞌẽlé ãnî drí, õzõ drílĩyî ꞌẽlé mâ ãnî lı̣́pı̣̂ ró rî drí rî kâtí. Ĩtí rî, mâ gólâ âꞌdó ꞌbá drı̣̃-ꞌbá ꞌbã-tı̣̂ Ôvârí kâ rî kâ ró rî, áâtâ úlı̣́ ꞌdásí kâ trá má rú kĩ, Sãtánã õrî nĩ rĩꞌá mbârâkã fẽlé má drí. Âꞌdô bê trá ĩtí rî, âꞌdô îcáꞌá íyíkâ úlı̣́ ꞌdásí kâ âtázó ãnî gólĩyî âꞌdó ꞌbá ꞌbã-tı̣̂ Ôvârí kâ rî ꞌbá yî rú õnjí ró lậvũlı̣́ gạ̃rạ̃ úlı̣́ ꞌdásí kâ gólâ õjílã drí âtálé má rú rî drı̣̃ı̣̂ sĩ kô yã? ");
INSERT INTO avu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Gõꞌdá nĩ ꞌê ũrı̣̃ kô õjílã gólĩyî ꞌẽ ꞌbá lâŋõ fẽlé ãnî drí rî ꞌbá yî drí sĩ. Tã ndrĩ gólĩyî lậpı̣́lı̣́ lậpı̣̂ rî ꞌbá yî, Ôvârí âꞌdô lôfõꞌá lâ võ ngbángbá ꞌá. Gõꞌdá tã gólĩyî õjílã drí rĩꞌá ꞌẽlé kírî võ lâ ûsú ãkó rî ꞌbá yî áâꞌdô lôfõꞌá lâ õjílã drí nı̣̃lı̣́ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gõꞌdá kpá ĩtí, ngbãângbânõ rî, tã ndrĩ gólĩyî má drí âtálé ãnî lãjóꞌbá drí ı̣̃nı̣́nı̣̂ ró rî ꞌbá yî, nĩ lôfõ ndrĩ õjílã drí võ ngbángbá ꞌá. Gõꞌdá tã ndrĩ gólĩyî má drí âtálé ãnî bı̣́-ꞌbálé ꞌá ãyãyã sĩ rî ꞌbá yî, nî îyâ tã rî ꞌdĩ ꞌbá yî õfõ ró kôrô jó-drı̣̃ ãpírĩ ꞌásĩ õjílã drí ârílí. ");
INSERT INTO avu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nĩ ꞌê ũrı̣̃ kô õjílã gólĩyî ꞌẽ ꞌbá ãnî fũlı̣́ tã ámákâ tãsĩ rî ꞌbá yî drí sĩ. Nĩ rî tã ámákâ ꞌẽlé, tãlâ gólĩyî îcá kô ãnî líndrí fũlı̣́ cé ãnî rúꞌbạ́ ĩꞌdî. Nĩ ûrı̣̃ cé Ôvârí gólâ ꞌẽ ꞌbá õjílã líndrí îzãlé rúꞌbạ́ ı̣̃nyạ́kú bê lạ̃sı̣́ gólâ êdélé trá Sãtánã yî drí rî ꞌá rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Gõꞌdá nĩ ı̣̂sũ tã ãríwá mvá gólĩyî njúwạ̃ ró rĩ ꞌbá õjílã bê ꞌbã ꞌá rî ꞌbá yî tã lâ. Órî rĩꞌá gólĩyî ndrẽlé ngá fínyáwá ró. Gbõ lé ĩtí rî, ãlô rî îcá kô âꞌdélé vũdrı̣́ drãlé cú ĩtí Ôvârí drí võ lâ ûsú ãkó. Ôvârí rî nĩ rĩꞌá gólĩyî vó ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Gõꞌdá ãnî nyãányâ nĩ ı̣̂sũ tã kô. Ôvârí lẽ ãnî trá rõô lậvũlı̣́ gạ̃rạ̃ ãríwá mvá ꞌdĩ ꞌbá yî drı̣̃ı̣̂ sĩ. Gólâ nı̣̃ tã ãníkâ trá ndrĩ dódó. Gbõ lé drı̣̃-ꞌbí ãnî drı̣̃ı̣̂ ꞌdĩ, gólâ lâ trá ãlô-ãlô ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Gõꞌdá õjílã gólĩyî ndrĩ âdré ꞌbá tã lẽlẽ ĩyíkâ má ꞌá rî sĩ ũrı̣̃ ãkó õjílã ãzí ândrá tã âtálé kĩ, yĩ ãꞌdô õjílã ámákâ ĩꞌdî tã lẽlẽ ĩyíkâ má ꞌá rî âyé ãkó rî, má âꞌdô kpá tã âtáꞌá ámâ átá ûrú ꞌálâ rî ândrá kĩ, gólĩyî ꞌdĩ ꞌbá yî rĩꞌá pạ̃tı̣́ı̣̃ õjílã ámákâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gõꞌdá õjílã gólĩyî tíbê tã lẽlẽ ĩyíkâ má ꞌá rî âyé ꞌbá ũrı̣̃ drí kậyı̣̂ lâŋõ kâ sĩ gõꞌdá ámâ tı̣̂ gã ꞌbá dó õjílã ãzí ândrá gõꞌdá tã âtá ꞌbá kĩꞌá nĩ rî, yĩ âꞌdó kô õjílã ámákâ ĩꞌdî rî, má âꞌdô kpá gólĩyî tı̣̂ gãꞌá ámâ átá ûrú ꞌálâ rî ândrá kĩ, gólĩyî âꞌdó kô õjílã ámákâ ĩꞌdî, má nı̣̃ı̣́ gólĩyî kô.” ");
INSERT INTO avu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Gõꞌdá Yésũ drí kpá tã âtázó kĩ, “Nĩ ı̣̂sũ tã kô kĩ nĩ rî, má ãânĩ tã ạ̃ꞌdı̣́ âjílí õjílã ãngó nõ kâ lãfálé. Ânĩ-ânĩ ámákâ sĩ rî, õjílã gólĩyî tã lẽ ꞌbá drẽ má ꞌá kô rî ꞌbá yî âꞌdô ĩyî ꞌbãꞌá ạ̃jú-ꞌbá-ãzí ró ãnî gólĩyî tã lẽ ꞌbá trá má ꞌá rî ꞌbá yî rú. ");
INSERT INTO avu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Ânĩ-ânĩ ámákâ õjílã ậzı̣́lı̣́ má ngálâ rî âꞌdô ꞌẽꞌá lãfálé cãcã âjílí õjílã drí. Tã ꞌdî tãsĩ rî, gólĩyî ạ̃jú-ꞌbá-ãzí yî âꞌdô ꞌbãꞌá ãkpã õjílã ꞌbã-tı̣̂ gólĩyî nyãányâ kâ rî ꞌbá yî ꞌásĩ. ‘ꞌDĩyímvá âꞌdô ngãꞌá ꞌdẽlé ạ̃wạ̃ bê átá lâ yî drı̣̃ı̣̂ tã lẽlẽ átá lâ yí kâ má ꞌá rî tãsĩ. Gõꞌdá õkó mvá âꞌdô kpá ngãꞌá ꞌdẽlé ạ̃wạ̃ bê ândrê lâ yî drı̣̃ı̣̂ tã lẽlẽ ândrê lâ yí kâ má ꞌá rî tãsĩ. Gõꞌdá mvạ́zı̣́ yî âꞌdô ĩyî kpá tã rî ꞌdĩ ꞌbá yî ꞌẽꞌá ĩtí ãdrá lâ yî drí tã lẽlẽ ãdrá lâ yí kâ má ꞌá rî tãsĩ.’ ");
INSERT INTO avu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ãnî gólĩyî ãnî átá yî lẽ ꞌbá ãnî ândrê yí bê ĩꞌdî lậvũlı̣́ gạ̃rạ̃ ámâ lẽlé drı̣̃ı̣̂ sĩ rî, nĩ îcá kô âꞌdólé tã ârî ꞌbá ámákâ ró. Gõꞌdá ãnî gólĩyî âꞌdó ꞌbá mvá rî átá yî ró rî ꞌbá yî kpá rĩꞌá ĩtí, õzõ nĩ õrî ãnî mvá yî lẽlé ĩꞌdî lậvũlı̣́ gạ̃rạ̃ ámâ lẽlé drı̣̃ı̣̂ sĩ rî, nĩ îcá kpá kô âꞌdólé tã ârí ꞌbá ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Õzõ õjílã ãzâ õlẽ trá ámâ vó bẽlé âꞌdólé tã ârí ꞌbá ámákâ ró rî, gólâ ãâꞌdô njãâ lâŋõ ûsúlı̣́ tã lẽlẽ gólâkâ má ꞌá rî tãsĩ, õzõ õjílã gólâ ꞌẽ ꞌbá fê lậlı̣̂-lậlı̣̂ íyíkâ njı̣̃lı̣́ gõzó nĩꞌá gólâ rî îpálé drı̣̃ lâ, drílâ lâŋõ ûsúzó rî kâtí. Gõꞌdá õzõ õjílã rî ꞌdĩ ĩîcâ kô tã rî ꞌdĩ ꞌẽlé ĩtí rî, gólâ îcá kô âꞌdólé tã ârí ꞌbá ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Õjílã gólâ tíbê rĩ ꞌbá tã gólĩyî íyî pã kâ ãngó nõ ꞌá rî ꞌẽlé cé ĩꞌdî gõzó lạ́tı̣̂ ámákâ âyélé rî, gólâ îcá kô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúlı̣́. Gõꞌdá gólâ tíbê âꞌdó ꞌbá njãâ íyî nyãányâ fẽlé lâŋõ ûsúlı̣́ ámâ tãsĩ rî, gólâ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nĩngá sĩ, Yésũ drí tã âtázó õjílã gólĩyî lãjóꞌbá íyíkâ rî ꞌbá yî drí ꞌẽꞌá ûsúlâ ậcı̣́ gólĩyíkâ ꞌá rî tãsĩ kĩ, “Õzõ õjílã ãzâ õlậgû ãnî trá ũmú ró yí drí ꞌbã ꞌá rî, õjílã rî ꞌdĩ lậgû ꞌdĩ mâ ĩꞌdî, gõꞌdá kpá Ôvârí gólâ ámâ âjólé bê rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Gõꞌdá õzõ õjílã ãzâ õlậgû ãnî gólĩyî nĩ ꞌbá úlı̣́ Ôvârí kâ âtá bê tãlâ ãnî rĩꞌá úlı̣́ Ôvârí kâ âtá ꞌbá ró rî, Ôvârí âꞌdô drı̣́-ꞌâ gólâ îcá ꞌbá rî fẽꞌá õjílã rî ꞌdĩ drí, õzõ drílâ ꞌẽꞌá fẽlâ ãnî drí rî kâtí. Gõꞌdá õzõ õjílã ãzâ õlậgû ãnî trá tã tãndí ꞌẽ ꞌbá ró rî, Ôvârí âꞌdô kpá drı̣́-ꞌâ tíbê ꞌẽꞌá fẽlâ tã mbı̣̂ ꞌbá drí rî fẽꞌá ĩꞌdî gólâ drí. ");
INSERT INTO avu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nî ãzâ, õzõ ní õpâ õjílã ãzí trá gbõ kó cé lı̣̃mvû ạ̃ꞌdı̣́ fẽzó ĩꞌdî õjílã rî ꞌdĩ drí mvũlı̣́ tãlâ gólâ tã ârí ꞌbá ámákâ ĩꞌdî, gbõ lé ndrẽlé ngá tãkó ró rî, tã tãndí áníkâ ꞌdĩ tãsĩ rî, Ôvârí âꞌdô drı̣́-ꞌâ fẽꞌá ní drí.” ");
INSERT INTO avu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ ndẽ bê tã îmbâ drílâ âꞌdálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí ꞌẽlé ꞌdĩ ꞌbá yî rî, gõꞌdá drílâ ngãzó nĩlí jạ̃rı̣́bạ̃ ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî ꞌbá yî ꞌásĩ, nĩꞌá õjílã lı̣̃fı̣́ îmbá bê tã Ôvârí kâ sĩ, gõꞌdá kpá tã pẽ bê. ");
INSERT INTO avu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Gõꞌdá óꞌbã Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî bê gạ̃nı̣́mạ̃ ꞌá rî, Yõwánĩ drí tã lârâkô Yésũ drí rĩꞌá ꞌẽlâ rî ꞌbá yî tã lâ ârízó. Ĩtí rî, drílâ ngãzó võrã ꞌbá íyíkâ ãzâ ꞌbá yî jõlé Yésũ ngálâ, nĩꞌá Yésũ rî îjílí, ãꞌdô ró bê yí drí tã gólâ rî nyãányâ tãsĩ rî nı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Gõꞌdá võrã ꞌbá ꞌdĩ ꞌbá yî câ ĩyî bê Yésũ rî ûsúlı̣́ rî, drílĩyî Yésũ rî îjízó kĩ, “Nî õjílã gólâ ꞌẽꞌá âjólâ ꞌdíyî pã ꞌbá ró rî ĩꞌdî, ngãtá mã õtẽ drẽ õjílã ãzâ ngĩî lâ ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, “Nĩ gõ tã gólĩyî ãnî drí ndrẽlé trá gõꞌdá kpá ârílí trá ámâ tãsĩ rî ꞌbá yî âtálé Yõwánĩ drí. ");
INSERT INTO avu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Má ꞌbã õjílã lı̣̃fı̣́ ãkó lé ꞌbá trá võ ndrẽlé ngbángbá, õjílã gólĩyî õŋõ ró rî ꞌbá yî trá ậcı̣́ tõlé tãndí ró, gõꞌdá õjílã ãrí bê rî ꞌbá yî rúꞌbạ́ lâ êdê rû trá ngbángbá, õjílã bı̣́-ꞌbálé lâ drí ậsı̣̃lı̣́ rî trá tã âríꞌá, õjílã drã ꞌbá rî ꞌbá yî ngâ ĩyî trá õdrã ꞌásĩ, gõꞌdá tã âtî-âtî tãndí Ôvârí kâ áâꞌdô trá rĩꞌá pẽꞌá lâ õjílã gólĩyî ĩzã ꞌbá ró rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nĩ ndrê drẽ, gbõ lé tã gólĩyî má drí ꞌẽlé rî ꞌbá yî õꞌbã õjílã dũû nĩ ámâ gãlé dó rî, Ôvârí âꞌdô õrẽ fẽꞌá õjílã gólĩyî ámâ gã ꞌbá kô tã ꞌdî ꞌbá yî tãsĩ rî ꞌbá yî drí. Ĩtí rî, nĩ âtâ tã Yõwánĩ drí, gólâ õrî zãâ tã lẽlé má ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gõꞌdá võrã ꞌbá Yõwánĩ kâ ꞌdĩ ꞌbá yî lậvũ ĩyî bê nĩꞌá gõlé rî, Yésũ drí îtõzó rĩꞌá tã âtálé õjílã dũû gólĩyî rĩ ꞌbá yí bê rî ꞌbá yî drí Yõwánĩ rî tãsĩ kĩ, “Kậyı̣̂ gólâ ãnî drí nĩzó õmã ꞌálâ tã Yõwánĩ kâ ârílí rî ꞌá rî, nĩ ndrê ãꞌdô ngá ꞌî tólâ yã? Nĩ ndrê õjílã gólâ mbârâkã ãkó õzõ õmã ĩlî drí ꞌẽꞌá bı̣̃lâ vũdrı̣́ rî kâtí rî ĩꞌdî yã? ꞌÉꞌẽ, âꞌdó ĩtí kô. ");
INSERT INTO avu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngãtá nĩ ı̣̂sũ ãníkâ bê-rî kĩ, nĩ ãꞌdô õjílã gólâ ítá tãndí sũ ꞌbá rî ûsúꞌá ĩꞌdî õmã ꞌá tólâ yã? ꞌÉꞌẽ âꞌdó ĩtí kô. Õjílã gólĩyî rĩ ꞌbá ítá tãndí sũlı̣́ rî ꞌbá yî, rî ĩyî rĩlí jó ạ́ngı̣́ ạ́ngı̣́ ꞌá jạ̃rı̣́bạ̃ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nĩ âꞌdâ drẽ ngá gólâ ãnî drí nĩꞌá ndrẽlâ kậyı̣̂ ãnî drí nĩrĩ Yõwánĩ ngálâ tólâ rî sĩ rî má drí. Õzõ nĩ õnĩ tã ậngũ ꞌbá ndrẽlé rî, ꞌdĩî tã pạ̃tı̣́ı̣̃ ꞌî. Yõwánĩ rĩꞌá tã ậngũ ꞌbá ꞌî, ãmbã gólâkâ rî lậvũ gạ̃rạ̃ tã ậngũ ꞌbá ãzâ ꞌbá yí kâ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yõwánĩ ĩꞌdî õjílã gólâ Ôvârí drí tã âtázó gólâ rî tãsĩ tã îgĩ íyíkâ ꞌá kĩꞌá nĩ rî, yí âꞌdô lãjóꞌbá íyíkâ âjóꞌá sı̣́sı̣́, ãânĩ ró bê lạ́tı̣̂ êdélé má drí ânĩ-ânĩ ámákâ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Má âtâ nõ ãnî drí tã pạ̃tı̣́ı̣̃ ró, ãmbã Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî kâ rî lậvũ gạ̃rạ̃ ãmbã õjílã gólĩyî tı̣̃lı̣́ ndrĩ ãngó nõ ꞌá bũúũ ãndrõ nô rî ꞌbá yí kâ drı̣̃ı̣̂ sĩ. Gõꞌdá õjílã ndrĩ gólĩyî âꞌdó ꞌbá õjílã Ôvârí kâ ró tã lẽlẽ gólĩyíkâ má ꞌá ꞌdíyî pã ꞌbá ró rî tãsĩ rî ꞌbá yî lãfálé ꞌásĩ rî, õjílã gólâ ãmbã lâ drí âꞌdólé cé fínyáwá rî, ãmbã gólâkâ lậvũ gạ̃rạ̃ ãmbã Yõwánĩ kâ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Îtõlé kậyı̣̂ gólâ Yõwánĩ drí îtõzó tã Ôvârí kâ pẽlé rî sĩ, âcálé bũúũ ãndrõ nô, õjílã ạ̃wạ́lạ́kạ́ ró rî ꞌbá yî rĩꞌá lâŋõ fẽꞌá õjílã Ôvârí kâ drí. Õjílã rî ꞌdĩ ꞌbá yî rî ĩyî tã rî ꞌdĩ ꞌẽlé õnjí ró mbârâkã sĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Drẽ ãkpãkãꞌdã Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî âjó ãkó âcálé bũúũ kậyı̣̂ gólâ drí rĩzó tã Ôvârí kâ pẽlé rî sĩ, tã gólĩyî ꞌẽ ꞌbá rû ꞌẽlé rî, tã ậngũ ꞌbá yî ndrĩ tã îgĩ Músạ̃ kâ yí bê âtâ ĩyî tã trá tã rî ꞌdĩ ꞌbá yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Õzõ nĩ õlẽ tã trá úlı̣́ tã ậngũ ꞌbá yí kâ ꞌdĩ ꞌá rî, nĩ âꞌdô nı̣̃ꞌá lâ kĩ, Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî ĩꞌdî tã ậngũ ꞌbá gólâ Ôvârí drí tã lâ ꞌbãlé trá ꞌẽꞌá âjólâ õzõ tã ậngũ ꞌbá Ẽlíyã kâtí rî. ");
INSERT INTO avu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Õzõ ãnî bı̣́-ꞌbálé ãârî tã bê rî, ꞌdõvó nĩ ârî drẽ úlı̣́ nõ ꞌbá yî. ");
INSERT INTO avu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“Õjílã kậyı̣̂ nõ ꞌbá yí kâ gólĩyî vólé gã ꞌbá dó tã lẽlé tã Ôvârí kâ ꞌá nõ ꞌbá yî, áâꞌdô gólĩyî ı̣̂ꞌbı̣̃ꞌá õzõ ãꞌdô kâtí yã? Gólĩyî rĩꞌá nyé õzõ ꞌdĩyímvá gólĩyî vólé gã ꞌbá dó lâvílí ãzí-ãzí lâ yí bê võ ãlô ꞌá rî kâtí. Õzõ ꞌdĩyímvá õcâ ĩyî lậrı̣́ trá rĩzó ậndú tõlé rî, gõꞌdá ãzâ ꞌbá yî õgã trá dó ậndú tõlé rî, drílĩyî tã âtázó kĩ nĩ rî, ‘Mã câ lậrı̣́ ậndú tõzó, gõꞌdá nĩ lẽé ậndú tõlé ãmá bê kô ãꞌdô tãsĩ yã?’ Gõꞌdá õzõ gólĩyî õngô gbõ ãwó lôngó drílĩyî ãwó ngõzó rî, gõꞌdá ãzâ ꞌbá yî õgã kpá dó ãwó ngõlé gólĩyí bê rî, drílĩyî tã âtázó kĩ nĩ rî ‘Nĩ lẽé kpá ãwó ngõlé ãmá bê kô ãꞌdô tãsĩ yã?’ ");
INSERT INTO avu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nĩ ndrê drẽ, Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî âcâ bê rî, gólâ nyá ngá nyãnyã tãndí kô, gõꞌdá gólâ mvú õdrá kpá kô. Tã rî ꞌdĩ tãsĩ rî, nĩ âtâ kĩ nĩ rî, gólâ cú líndrí õnjí bê yí ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gõꞌdá mâ gólâ Ôvârí drí âjólé ûrú lésĩ rî âcâ bê rî, má nyâ ngá nyãnyã tãndí trá, gõꞌdá má mvû kpá õdrá trá. Tã ꞌdî tãsĩ rî, áâtâ tã ámâ tãsĩ kĩ nĩ rî, ‘Mĩ ndrê, nõô rĩꞌá ꞌálé kõ ꞌbá ꞌî gõꞌdá kpá õdrá mvũ ꞌbá ꞌî. Gõꞌdá gólâ trõ õjílã õnjí ãzâ ꞌbá yî trá âꞌdólé gólâ rî rû-lẽ-ãzíyã yî ró.’ Gõꞌdá má kĩ nĩ rî tã ãzâ ĩꞌdî nõ, ãnî õjílã gólĩyî úlı̣́ Yõwánĩ kâ ârí ꞌbá úlı̣́ ámákâ rî bê rî âꞌdô ĩyî nı̣̃ꞌá lâ tã pạ̃tı̣́-pạ̃tı̣̃ ró. Úlı̣́ má drí rĩꞌá âtálâ nõ rî Ôvârí kâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gõꞌdá nĩngá sĩ rî, Yésũ drí tã âtázó õjílã gólĩyî rĩ ꞌbá rĩlí jạ̃rı̣́bạ̃ gólĩyî gólâ drí rĩzó tã lârâkô ãmbá tı̣̂ drí ậꞌdı̣́zó tã lâ sĩ rî ꞌbá yî ꞌẽlé ꞌálâ sĩ rî ꞌá rî ꞌbá yî rú, tãlâ õjílã rî ꞌdĩ ꞌbá yî lẽé ĩyî kô drı̣̃ âdĩlí tã õnjí ĩyíkâ rî ꞌbá yî ꞌásĩ tã lẽzó gólâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Gólâ kĩ, “Ãnî õjílã jạ̃rı̣́bạ̃ Kõrázã kâ rî kâ rî ꞌbá yî gõꞌdá ãnî õjílã jạ̃rı̣́bạ̃ Bẽtãsédã kâ rî kâ rî ꞌbá yí bê, lâŋõ õnjí tẽtẽ âꞌdô ꞌẽꞌá ꞌdẽlé ãnî drı̣̃ı̣̂, tãlâ nĩ gâ vólé dó tã lẽlé má ꞌá. Nĩ ı̣̂sũ drẽ tã jạ̃rı̣́bạ̃ Tírã kâ rî kâ gõꞌdá Sĩdónã kâ bê. Ôvârí îzã jạ̃rı̣́bạ̃ ꞌdî ꞌbá yî trá ạ̃kû ró tã õnjí õjílã gólĩyî rĩ ꞌbá tólâ nã ꞌbá yí kâ tãsĩ. Gõꞌdá tí õjílã jạ̃rı̣́bạ̃ ꞌdî ꞌbá yí kâ ꞌdĩ ꞌbá yî õró ĩyî tã lârâkô gólĩyî má drí rĩꞌá ꞌẽlâ ãnî lãfálé ꞌá rî ꞌbá yî ndrẽê cú ĩyî lı̣̃fı̣́ sĩ rî, tí gólĩyî sõ ítá lı̣́rı̣́kũ ĩzã kâ trá ĩyî rú gõzó ófó fõlé ĩyî drı̣̃ı̣̂, ꞌdĩî ãâꞌdâ ró bê kĩ, pạ̃tı̣́ı̣̃ gólĩyî âdĩ drı̣̃ trá ꞌwãâ tã õnjí ĩyíkâ rî ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mã âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, ãnî õjílã Kõrázã kâ gõꞌdá Bẽtãsédã kâ bê rî, kậyı̣̂ gólâ Ôvârí drí ꞌẽzó tã-vó õjílã ndrĩ kâ kĩlí rî tú rî, lâŋõ gólâ ꞌẽꞌá fẽlâ ãnî drí rî âꞌdô ꞌẽꞌá lậvũlı̣́ gạ̃rạ̃ lâŋõ gólâ Ôvârí drí ꞌẽꞌá fẽlâ õjílã Tírã yí kâ Sĩdónã bê ꞌdĩ ꞌbá yî drí rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Gõꞌdá ãnî õjílã Kãpẽrãnómã kâ rî ꞌbá yî, nĩ ı̣̂sũ ãníkâ bê-rî kĩ, Ôvârí ãâꞌdô ãnî lậgúꞌá yí ngálâ ûrú ꞌálâ yã? Gólâ âꞌdô ãnî vũꞌá lạ̃sı̣́ gólâ êdélé Sãtánã yî drí rî ꞌá. Gólâ îcá kô ãnî lậgúlı̣́, tãlâ nĩ gâ vólé trá dó tã lẽlé má ꞌá. Gõꞌdá nĩ ı̣̂sũ drẽ tã Sõdómõ kâ tíbê Ôvârí drí îzãlé trá õjílã íyíkâ bê ạ̃kû ró tã õnjí gólĩyíkâ tãsĩ rî tã lâ. Gõꞌdá tí tã lârâkô gólĩyî ãnî õjílã Kãpẽrãnómã kâ drí ndrẽlé rî ꞌbá yî óõró ꞌẽlâ Sõdómõ ꞌálâ rî, tí õjílã lâ yî âdĩ drı̣̃ trá tã õnjí ĩyíkâ rî ꞌbá yî ꞌásĩ, gõꞌdá tí Ôvârí îcá jạ̃rı̣́bạ̃ ꞌdî îzãlé kô, âꞌdô ꞌbãꞌá drẽ bê rĩꞌá zãâ âcálé bũúũ ãndrõ nô. ");
INSERT INTO avu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, ãnî õjílã Kãpẽrãnómã kâ rî ꞌbá yî, kậyı̣̂ gólâ Ôvârí drí ꞌẽzó tã-vó õjílã ndrĩ kâ kĩlí rî tú rî, lâŋõ gólâ ꞌẽꞌá fẽlâ ãnî drí rî âꞌdô ꞌẽꞌá lậvũlı̣́ gạ̃rạ̃ lâŋõ gólâ Ôvârí drí ꞌẽꞌá fẽlâ õjílã Sõdómõ kâ ꞌdĩ ꞌbá yî drí rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gõꞌdá nĩngá sĩ rî, Yésũ drí îtõzó rĩꞌá Ôvârí rî lûyı̣́lı̣́ kĩ nĩ rî, “Tátá, ní rî trá võ ûrú ꞌálâ rî ꞌá gõꞌdá kpá ãngó nõ drı̣̃lı̣́ kúmú ró, má lûyı̣̂ nî, tãlâ ní lậpı̣̂ tã pạ̃tı̣́ı̣̃ áníkâ rî trá õjílã gólĩyî tã ı̣̂sũ ꞌbá kĩꞌá nĩ rî, ĩyî lı̣̃fı̣́ õmbâ rõô gõꞌdá yĩ ũnı̣̃ tã kpá rõô rî ꞌbá yî drí sĩ. Ĩtí rî, ní âꞌdâ tã rî ꞌdĩ ꞌbá yî trá trậ õjílã gólĩyî ĩyî nyãányâ lôgõ ꞌbá õzõ ꞌdĩyímvá kâtí rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tátá, sû trá ní rú tã rî ꞌdĩ ꞌbá yî drí rû ꞌẽzó ĩtí ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Gõꞌdá Yésũ drí tã âtázó kĩ, “Ámâ átá âfẽ drı̣́-ãcê trá má drí âꞌdózó ngá ndrĩ drı̣̃lı̣́. Ĩtí rî, õjílã ãzãkã îcá kô ámâ nı̣̃lı̣́ Ôvârí rî mvá ró, ámâ átá Ôvârí nı̣̃ mâ cé nĩ. Gõꞌdá õjílã ãzãkã îcá kpá kô ámâ átá rî nı̣̃lı̣́. Gõꞌdá mâ rî gógó gólâ rî mvá ró rî nı̣̃ gólâ cé nĩ, gõꞌdá õjílã gólĩyî má drí njĩlí ámâ átá rî âꞌdázó drílĩyî rî ꞌbá yí bê.” ");
INSERT INTO avu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Gõꞌdá Yésũ drí tã âtázó kĩ, “Ãnî gólĩyî âꞌdó ꞌbá lâŋõ ngá lậnjı̣̃ kâ bê rî, nĩ ânĩ má ngálâ, tãlâ má fẽ ró mbârâkã bê ãnî drí. Má âꞌdô ãnî ꞌbãꞌá lôvólé pı̣̃pı̣̂sı̣́lı̣́ ạ̃ꞌdı̣́ sĩ kậyı̣̂ lâŋõ kâ rî ꞌbá yî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nĩ ꞌbã ãnî nyãányâ drı̣́-ãcê ámákâ zẽlé rû ı̣̂ꞌbũ ꞌbá ámákâ ró. Nĩ ârî tã gólĩyî má drí rĩꞌá âtálâ ãnî drí rî ꞌbá yî, nĩ gõ ró tã rî ꞌdĩ ꞌbá yî ꞌẽlé ĩꞌdî, tãlâ má âꞌdó kô sı̣́ lõmbâ ꞌbá ꞌî. Tã ámákâ rĩꞌá mãnísĩ, âꞌdó kô mbârâkã sĩ. Õzõ nĩ õꞌê tã rî ꞌdĩ ꞌbá yî trá ĩtí rî, nĩ âꞌdô lôvô-lôvô ûsúꞌá ãnî nyãányâ drí. ");
INSERT INTO avu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tã gólĩyî má drí lẽlé ãnî drí ꞌẽlé rî ꞌbá yî, má âꞌdô mbârâkã fẽꞌá ãnî drí ꞌẽzó lâ lâŋõ ãkó. Ĩtí rî, ngá gólĩyî má drí lẽlé ãnî drí njı̣̃lı̣́ rî rĩꞌá tẽlẽfẽ ĩtí, âꞌdó kô ngá lậnjı̣̃-lậnjı̣̃ ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kậyı̣̂ rãtáã kâ sĩ, Yésũ yî drí ngãzó nĩlí lãjóꞌbá íyíkâ yí bê kôrô ạ́mvú ạ̃drúgú lı̣̂njı̣́ ꞌbá trá rî kâ ꞌásĩ. Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî trá rĩꞌá lõfó ró. Ĩtí rî, gólĩyî õtírĩ rĩî lậvũlı̣́ ạ̃drúgú ꞌdĩ ꞌbá yî rú sĩ rî, drílĩyî rĩzó ạ̃drúgú ôsĩlí nyãlé. ");
INSERT INTO avu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nĩngá sĩ, Pạ̃rúsı̣̃ ãzâ ꞌbá yî õtírĩ lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ndrẽê tã ꞌdî ꞌẽrẽ ꞌá rî, drílĩyî tã âtázó Yésũ drí kĩ, “Lãjóꞌbá áníkâ ꞌdĩ ꞌbá yî rî ĩyî tã gólâ ãmâ drí âyélé kô ꞌẽlé lãꞌbí ãmákâ vó ró rî ꞌẽlé ĩtí kậyı̣̂ rãtáã kâ sĩ ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, “Nĩ zı̣́ tã gólâ îgĩlí kúmú ạ́ngı̣́ Dạ̃wúdı̣̃ rî tãsĩ búkũ Ôvârí kâ ꞌá rî kô yã? Kậyı̣̂ gólĩyî drí ꞌbãzó lõfó ró ạ̃jú ꞌbũ ꞌbá íyíkâ yí bê rî ꞌá rî, gólĩyî ꞌê ãꞌdô ꞌî yã? ");
INSERT INTO avu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gólĩyî fî trá jó Ôvârí kâ ꞌá ãmbãtã fẽlé trá ngá fẽfẽ ró Ôvârí drí rî nyãlé. Nĩ nı̣̃ trá tãndí ró kĩꞌá nĩ rî, cé drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî ꞌbá yî áâyê ĩꞌdî ngá nyãnyã rî ꞌdĩ nyãlé. Gbõ lé Dạ̃wúdı̣̃ yî nyâ bê ngá nyãnyã rî ꞌdĩ rî, úzı̣́ gólĩyî kô lãꞌbí îzã ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Gõꞌdá nĩ zı̣́ tã ꞌbãꞌbã gólĩyî îgĩlí búkũ Ôvârí kâ ꞌá drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî ꞌbá yî tãsĩ rî kô yã? Gólĩyî rî lôsĩ ꞌẽlé jó ạ́ngı̣́ Ôvârí kâ ꞌá kậyı̣̂ rãtáã kâ sĩ. Gõꞌdá úzı̣́ gólĩyî kô lãꞌbí îzã ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Má âtâ ãnî drí tã pạ̃tı̣́-pạ̃tı̣̃ ró, ngá ãzâ bê nõngá, ãmbã gólâkâ lậvũ gạ̃rạ̃ ãmbã jó ạ́ngı̣́ Ôvârí kâ rî kâ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gõꞌdá nĩ ı̣̂sũ drẽ tã gólâ îgĩlí búkũ Ôvârí kâ ꞌá kĩꞌá nĩ rî, ‘Tã gólâ má drí lẽlé lậvũ ꞌbá gạ̃rạ̃ tã kõrõnyã zãzã kâ má drí rî drı̣̃ı̣̂ sĩ rî ĩꞌdî nõ, nĩ ndrê ĩzã õjílã ãzí kâ.’ Úlı̣́ ꞌdĩ ꞌbá yî, mĩ nı̣̃ı̣́ tã ífí lâ kô. Tí nĩ õró tã ífí lâ nı̣̃ı̣̂ rî, tí nĩ îcá kô tã kĩlí õjílã gólĩyî rĩ ꞌbá kô tã ꞌẽlé ányâ ró rî ꞌbá yî rú. ");
INSERT INTO avu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gõꞌdá mâ gólâ âjólé ûrú lésĩ rî rĩꞌá cú drı̣́-ãcê bê kậyı̣̂ rãtáã kâ drı̣̃lı̣́.” ");
INSERT INTO avu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ngãzó võ ꞌdî âyélé nĩzó fĩlí jó tã Ôvârí kâ ârî kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gõꞌdá jó ꞌdĩ ꞌá tólâ rî, Yésũ drí ãgô ãzâ drı̣́ lâ drí ôgólé ôgô rî ûsúzó. Gõꞌdá Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá ãzâ ꞌbá yí bê kpá bê rĩꞌá ĩyî tólâ. Gólĩyî ndrê ãgô gólâ drı̣́ lâ drí ôgólé ôgô ꞌdĩ bê rî, gólĩyî ı̣̂sũ tã trá kĩ, ngãtá Yésũ âꞌdô ãgô ꞌdĩ êdéꞌá yã rî. Gõꞌdá drílĩyî ngãzó Yésũ rî îjílí kĩ, “Ãꞌdô lãꞌbí ãmákâ vó ró rî, rĩꞌá tãndí ró õjílã ngá lãzé bê rî êdélé kậyı̣̂ rãtáã kâ sĩ yã?” Gólĩyî rî ꞌdĩ Yésũ rî mãndĩkã lôꞌbãꞌá, õzõ gólâ õꞌê tã ányâ trá rî, ókî ró tã gólâkâ bê õnjí ró. ");
INSERT INTO avu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, “Õzõ õjílã ãzâ ãlô ãnî lãfálé sĩ ãꞌdô kạ́bı̣̃lı̣́kı̣̃ íyíkâ bê ãlô, gõꞌdá kạ́bı̣̃lı̣́kı̣̃ gólâkâ ꞌdĩ õꞌdê trá ꞌbú ạ́ngı̣́ ꞌá kậyı̣̂ rãtáã kâ ꞌá rî, áâyé gólâ kô lôfõlâ vólé ꞌbú ꞌásĩ yã? Gólâ âꞌdô kạ́bı̣̃lı̣́kı̣̃ ꞌdî âséꞌá. ");
INSERT INTO avu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lãꞌbí ãmákâ âyê ãmâ tã tãndí ꞌẽlé kõrõnyã ꞌbã kâ pãlé kậyı̣̂ rãtáã kâ sĩ. Gõꞌdá nĩ ı̣̂sũ drẽ tã õjílã mvá kâ. Õjílã mvá tã lâzê gạ̃rạ̃ kạ́bı̣̃lı̣́kı̣̃ tã drı̣̃ı̣̂ sĩ. Ĩtí rî, lãꞌbí ãmákâ âyê ãmâ tã tãndí ꞌẽlé õjílã ãzí pãlé kậyı̣̂ rãtáã kâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gõꞌdá Yésũ drí gõzó tã âtálé ãgô drı̣́ lâ drí ôgólé ꞌdĩ drí kĩ, “Ní îjõ ánî drı̣́.” Gõꞌdá ãgô ꞌdĩ drí íyî drı̣́ îjõzó mbı̣̂. Gõꞌdá gólâ rî drı̣́ drí rû êdézó âꞌdólé tãndí ró, õzõ drı̣́ lâ ãzâ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nĩngá sĩ, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ngãzó nĩlí võ ꞌdî âyélé tã ı̣̂ꞌbı̣̃lı̣́ Yésũ rú, tãlâ yĩ ûsû ró lạ́tı̣̂ bê gólâ rî fũzó. ");
INSERT INTO avu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gõꞌdá Yésũ nı̣̃ tã ı̣̂sũ Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yí kâ ꞌẽzó íyî fũlı̣́ ꞌdĩ bê rî, drílâ ngãzó nĩlí vólé võ ꞌdî ꞌásĩ. Nĩngá sĩ, õꞌbí dũû võ ãzâ ꞌbá yî ꞌásĩ drí ngãzó ꞌdẽlé gólâ rî vó bẽlé. Gõꞌdá õjílã gólĩyî ndrĩ ngá lãzé tı̣̂ ngĩíngî bê rî ꞌbá yî, gólâ drí gólĩyî êdézó ngá lãzé ĩyíkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Gõꞌdá Yésũ êdê õjílã gólĩyî ngá lãzé bê ꞌdĩ ꞌbá yî bê rî, gólâ drí drı̣́-mbílí sõzó gólĩyî lı̣̃fı̣́ tã âtâ-âtâ bê kĩ, “Nĩ lôfõ ãmâ tã kô kĩ má ãâꞌdô ãꞌdî ĩꞌdî yã õjílã ãzãkã drí.” ");
INSERT INTO avu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tã ꞌdî ꞌê rû trá ĩtí ꞌdĩ, tãlâ tã gólâ Ôvârí drí âtálé trá tã ậngũ ꞌbá Ĩsáyã tı̣́ ạ̃kû ró nã rî ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró. Gólâ kĩ, ");
INSERT INTO avu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nõô gólâ tíbê má drí njĩlí âꞌdólé rû ı̣̂ꞌbũ ꞌbá ámákâ ró rî ĩꞌdî. Gólâ ĩꞌdî tíbê má drí lẽlé rõô rî. Gõꞌdá gólâ rî tã sû trá má rú tákányĩ. Má âꞌdô Líndrí Tãndí ámákâ âjóꞌá mbârâkã sõlé gólâ ꞌá, tãlâ gólâ õpẽ ró tã ngá pãpã kâ mbı̣̂ rî bê õrĩ ndrĩ õjílã kâ ãngó ꞌásĩ rî drí. ");
INSERT INTO avu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Õzõ gólâ õtírĩ rĩî tã îmbálé rî, gólâ rí kô lâwãlé ngãtá ôtrélé. Ĩtí rî, õjílã gólĩyî rĩ ꞌbá lạ́tı̣̂ drı̣̃ı̣̂ rî ꞌbá yî ârí gólâ kô ôtrérẽ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lómí gólâ tõlé pá sĩ rî, gólâ îcá kô ŋõlâ, gõꞌdá gólâ îcá kpá kô lámbã gólâ rĩ ꞌbá kõlé õcĩkã ró rî âdrãlé, cãlé bũúũ kậyı̣̂ gólâ drí ꞌẽzó lạ́tı̣̂ ngá pãpã kâ njı̣̃lı̣́ õjílã pãzó rî tú. ");
INSERT INTO avu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tã ꞌdî tãsĩ rî, õjílã ꞌbạ̃súrú ndrĩ kâ âꞌdô ĩyî lı̣̃fı̣́ ꞌbãꞌá gólâ drı̣̃ı̣̂ ꞌdíyî pã ꞌbá ró.” ");
INSERT INTO avu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Gõꞌdá nĩngá sĩ, ãgô ãzâ líndrí õnjí drí rĩꞌá ômbélé ômbê rî âtrõzó âjílí Yésũ ngálâ. Líndrí õnjí rî ꞌdĩ ꞌbã ãgô ꞌdĩ trá úlı̣́ âtá ãkó gõꞌdá kpá võ ndrẽ ãkó. Gõꞌdá Yésũ drí líndrí õnjí ꞌdĩ drõzó vólé ãgô ꞌdĩ ꞌásĩ. Gõꞌdá gólâ lôfõ líndrí õnjí ꞌdĩ bê rî, ãgô ꞌdĩ drí ngãzó rĩꞌá úlı̣́ âtálé, gõꞌdá kpá lı̣̃fı̣́ lâ drí rû njı̣̃zó võ ndrẽlé dódó. ");
INSERT INTO avu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ĩtí rî, õꞌbí ꞌdĩ ꞌbá yî ndrê ĩyî tã Yésũ drí ꞌẽlé ꞌdĩ bê rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó ndrúndrú. Gõꞌdá gólĩyî drí tã îjízó ĩyî lãfálé ꞌásĩ kĩ, “Ãgô nõ âꞌdô ꞌbãꞌá Dạ̃wúdı̣̃ rî ózõwá gólâ Ôvârí drí ꞌẽꞌá âjólâ ꞌdíyî pã ꞌbá ró rî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gõꞌdá Pạ̃rúsı̣̃ ãzâ ꞌbá yî ârî ĩyî úlı̣́ õꞌbí ꞌdĩ ꞌbá yî drí âtálé ꞌdĩ bê rî, gólĩyî drí ngãzó tã âtálé Yésũ rú kĩ nĩ rî, “Mbârâkã gólâ Yésũ drí rĩzó tã lârâkô ꞌẽlé ĩꞌdî sĩ lâ ꞌdĩ, drı̣̃-ꞌbá líndrí õnjí kâ Sãtánã õrî nĩ rĩꞌá mbârâkã ꞌdî fẽlé gólâ drí rĩzó tã ꞌdî ꞌbá yî ꞌẽlé ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gõꞌdá Yésũ nı̣̃ tã Pạ̃rúsı̣̃ ꞌdî ꞌbá yî drí rĩꞌá ı̣̂sũlâ ꞌdĩ trá. Gõꞌdá drílâ gõzó tã âtálé gólĩyî drí úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Õzõ õjílã ꞌbạ̃drı̣̃ ãlô kâ õcâ ĩyî lãfâ trá ạ̃jú ꞌbũlı̣́ ãkpã ĩyî võ ꞌásĩ rî, ꞌbạ̃drı̣̃ ꞌdî âꞌdô ꞌdẽꞌá, drílâ rû îzãzó. Õzõ gõꞌdá õjílã jạ̃rı̣́bạ̃ ãlô kâ ngãtá ꞌbã-tı̣̂ ãlô kâ õcâ ĩyî lãfâ rû fũlı̣́ ãkpã ĩyî võ ꞌásĩ rî, âꞌdô ĩyî ꞌdẽꞌá drílâ rû lâpẽzó. ");
INSERT INTO avu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Gõꞌdá õzõ Sãtánã õrî ãkpã nĩ líndrí õnjí íyíkâ lâdrólé õjílã gólĩyî líndrí õnjí bê rî ꞌásĩ rî, ꞌdĩî gólĩyî câ lãfá trá ãkpã ĩyî võ ꞌásĩ. Ĩtí rî, kũmũ gólâkâ âꞌdô ꞌẽꞌá ꞌbãlé âmbâ-âmbâ ró mbârâkã bê rî íyíkâ ángô tí ró yã? ");
INSERT INTO avu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gõꞌdá õjílã ãníkâ rî ĩyî bê líndrí õnjí lâdrólé õjílã ꞌásĩ rî, ãꞌdî fẽ mbârâkã ꞌdî nĩ gólĩyî drí yã? ꞌDõvó nĩ ı̣̂sũ drẽ tã ꞌdî vó lâ dódó, nĩ gõ ró tã-vó ámákâ kĩlí mbı̣̂mbı̣̂. Tã-vó gólĩyíkâ âꞌdô tã âꞌdáꞌá ãnî drí kĩ, îcá kô má drí líndrí õnjí lâdrólé õjílã ꞌásĩ mbârâkã drı̣̃-ꞌbá líndrí õnjí ꞌdĩ ꞌbá yí kâ rî kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Gõꞌdá õzõ pạ̃tı̣́ı̣̃ Líndrí Tãndí Ôvârí kâ õfẽ mbârâkã nĩ má drí rĩzó líndrí õnjí lâdrólé rî, Ôvârí âꞌdâ tã trá kĩ, yí âjô mâ trá ꞌdíyî pã ꞌbá ró, tãlâ õjílã ndrĩ õrî ró bê kũmũ íyíkâ zẽlé.” ");
INSERT INTO avu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Gõꞌdá Yésũ drí úlı̣́ mãnĩgõ ãzâ âtázó kĩ, “Ũgú îcá kô fĩlí õjílã gólâ fãfã bê rî drí ꞌbã ꞌá, nĩꞌá ngá gólâkâ ûgũlı̣́ jó ꞌásĩ. Îcâ trá ũgú rî ꞌdĩ fãfã lâ drí lậvũzó gạ̃rạ̃ fãfã ꞌbã-lı̣́pı̣̂ ꞌdĩ kâ drı̣̃ı̣̂ sĩ gólâ drí ꞌbã-lı̣́pı̣̂ ꞌdĩ ômbézó zãlô sı̣́sı̣́ rî, gólâ õró gõ îcálé fĩlí nĩꞌá ngá ꞌbã-lı̣́pı̣̂ ꞌdĩ kâ ûgũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Má âtâ ãnî drí, õzõ õjílã ãzâ ãâꞌdô kô má bê ngá ãlô ró rî, õjílã rî ꞌdĩ rĩꞌá ámâ ạ̃jú-ꞌbá-ãzí ꞌî. ");
INSERT INTO avu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ õjílã ãzâ õꞌê tã õnjí ãzâ ꞌbá yî trá Ôvârí rú ngãtá ãâtâ úlı̣́ õnjí Ôvârí rú rî, áâꞌdô îcáꞌá tã õnjí gólâkâ âyélé. Gõꞌdá õzõ õjílã ãzâ ãâtâ úlı̣́ õnjí mâ rî gógó Ôvârí drí âjólé ûrú lésĩ ꞌdíyî pã ꞌbá ró nõ rú rî, áâꞌdô kpá tã õnjí õjílã rî ꞌdĩ kâ âyéꞌá. Gõꞌdá õzõ õjílã ãzâ ãâtâ úlı̣́ õnjí trá Líndrí Tãndí Ôvârí kâ rú rî, Ôvârí îcá kô tã õnjí õjílã rî ꞌdĩ kâ âyélé, ngbãângbânõ cãlé bũúũ ı̣̃zạ́tú.” ");
INSERT INTO avu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gõꞌdá Yésũ drí kpá tã âtázó kĩ nĩ rî, “Õzõ nĩ õrî úlı̣́ âtálé rî, nĩ ı̣̂sũ vó lâ dódó. Õzõ nĩ õlẽ fê lõꞌwâ tãndí rî ûsúlı̣́ rî, ní âꞌdô ûsúꞌá lâ fê tãndí drı̣̃ı̣̂. Õzõ gõꞌdá fê rî ꞌdĩ ãꞌdô fê gólâ õnjí rî ĩꞌdî rî, nĩ âꞌdô lõꞌwâ õnjí rî ûsúꞌá ĩꞌdî fê rî ꞌdĩ drı̣̃ı̣̂. Tã ꞌdî tãsĩ rî, nĩ âꞌdô fê nı̣̃ꞌá lõꞌwâ lâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gõꞌdá ãnî Pạ̃rúsı̣̃ yî, ãnî rĩꞌá nyé õzõ ı̣̃nı̣̃ kâtí, tã ı̣̂sũ ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî rĩꞌá õnjí ró. Nĩ âꞌdô îcáꞌá tã tãndí âtálé íyíkâ ángô tí ró yã? Nĩ ndrê drẽ, õjílã rî íyíkâ fí té tã íyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî âtálé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gõꞌdá õjílã gólĩyî tãndí ró rî, rî ĩyíkâ tã tãndí ı̣̂sũlı̣́ ĩꞌdî. Tã ꞌdî tãsĩ rî, gólĩyî rî úlı̣́ tãndí lôfõlé ĩꞌdî ĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌásĩ. Gõꞌdá ĩtí rî, õjílã gólĩyî õnjí rî ꞌbá yî, gólĩyî rî ĩyíkâ tã õnjí ı̣̂sũlı̣́ ĩꞌdî. Tã ꞌdî tãsĩ rî, gólĩyî rî tã õnjí lôfõlé ĩꞌdî ĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Gõꞌdá má âtâ ãnî drí, kậyı̣̂ gólâ Ôvârí drí ꞌẽzó tã-vó õjílã ndrĩ kâ kĩlí rî tú rî, Ôvârí âꞌdô ꞌẽꞌá tã-vó ãníkâ kĩlí úlı̣́ gólĩyî ndrĩ ãnî drí âtálé vó lâ ı̣̂sũ ãkó rî vó ró. ");
INSERT INTO avu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ĩtí rî, úlı̣́ ãníkâ ãzâ ꞌbá yî âꞌdô âꞌdálâ kĩ, nĩ ꞌê tã mbı̣̂ ꞌî, gõꞌdá úlı̣́ ãzâ ꞌbá yî âꞌdô âꞌdálâ kĩ, nĩ ꞌê tã ányâ ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Gõꞌdá nĩngá sĩ rî, lãꞌbí îmbá ꞌbá ãzâ ꞌbá yî gõꞌdá Pạ̃rúsı̣̃ yí bê drí Yésũ rî ûjũzó kĩ, “Tã îmbá ꞌbá, ní ꞌê tã lârâkô gólâ tı̣̂ drí ậꞌdı̣́zó rî ãmâ drí, tãlâ mã nı̣̃ ró bê kĩ, pạ̃tı̣́ı̣̃ Ôvârí âjô nî nĩ.” ");
INSERT INTO avu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Gõꞌdá Yésũ drí ngãzó tã lôgõlé õjílã ꞌdî ꞌbá yî drí tã lẽ ãkõ gólĩyíkâ yí ꞌá rî drí kĩ, “Ãnî õjílã kậyı̣̂ nõ ꞌbá yí kâ nõ rĩꞌá õjílã õnjí ꞌî. Nĩ ró Ôvârí kô. Nĩ rî ámâ îjílí tã lârâkô ꞌẽlé ãnî drí ndrẽlé ãꞌdô tãsĩ yã? Tã lârâkô gólâ ãnî drí ꞌẽꞌá ndrẽlâ má sĩ rî âꞌdô ꞌbãꞌá cé õzõ tã lârâkô gólâ Ôvârí drí ꞌẽlé trá ạ̃kû ró tã ậngũ ꞌbá Yónã drí rî kâtí rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ạ̃kû ró nã ꞌbá yî sĩ, ı̣̃ꞌbı̣̂ ândrê tê Yónã bê rî, gólâ rî trá ı̣̃ꞌbı̣̂ ândrê nã ꞌá ı̣̃tú nâ gõꞌdá ngạ́cı̣̂ kpá nâ. Âꞌdô ꞌbãꞌá kpá ĩtí ámâ tãsĩ. Mâ gólâ Ôvârí drí âjólé ûrú lésĩ ꞌdíyî pã ꞌbá ró rî âꞌdô ꞌẽꞌá rĩlí ı̣̃nyạ́kú ꞌá ı̣̃tú nâ gõꞌdá ngạ́cı̣̂ kpá nâ. ");
INSERT INTO avu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ꞌDõvó nĩ ı̣̂sũ drẽ õjílã Nínĩvẽ kâ tã lâ. Yónã pẽ úlı̣́ Ôvârí kâ bê gólĩyî drí rî, drílĩyî tã lẽzó ꞌá lâ, gõꞌdá gólĩyî âdĩ drı̣̃ trá tã õnjí ĩyíkâ ꞌásĩ. Ãmbã ámákâ lậvũ gạ̃rạ̃ ãmbã Yónã kâ drı̣̃ı̣̂ sĩ. Nĩ lẽé tã kô úlı̣́ ámákâ ꞌá ãꞌdô tãsĩ yã? Ãnî õjílã kậyı̣̂ nõ ꞌbá yí kâ nõ, nĩ ndrê drẽ, kậyı̣̂ gólâ ꞌẽzó tã-vó õjílã kâ kĩlí rî tú rî, õjílã Nínĩvẽ kâ âꞌdô ĩyî ícícíyá ꞌẽꞌá ãnî rú Ôvârí ândrá, tãlâ nĩ gâ vólé trá dó tã lẽlé úlı̣́ ámákâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gõꞌdá nĩ ı̣̂sũ drẽ kpá kúmú ạ́ngı̣́ gólâ õkó ró âꞌdó ꞌbá ꞌbạ̃drı̣̃ Sébã kâ drı̣̃lı̣́ rî tã lâ. Gólâ rĩꞌá õkó tã nı̣̃nı̣̃ ꞌbá ꞌî. Gólâ ângâ trá ânĩlí ꞌbạ̃drı̣̃ íyíkâ jẽjẽ ró nã lésĩ, nĩꞌá kúmú ạ́ngı̣́ Sólõmõ rî ndrẽlé, tãlâ gólâ ârî tã nı̣̃nı̣̃ kúmú Sólõmõ kâ rõô ꞌdĩ tã lâ trá, ĩꞌdî gólâ drí ângázó ânĩlí, tãlâ Sólõmõ ĩîmbâ ró yî bê tã nı̣̃nı̣̃ íyíkâ ꞌdĩ sĩ. Ãmbã ámákâ lậvũ gạ̃rạ̃ kúmú Sólõmõ kâ drı̣̃ı̣̂ sĩ. Má âtâ ãnî drí, ãnî õjílã kậyı̣̂ nõ ꞌbá yí kâ nõ, kậyı̣̂ gólâ Ôvârí drí ꞌẽzó tã-vó õjílã kâ kĩlí rî tú rî, õkó ꞌdĩ âꞌdô ícícíyá ꞌẽꞌá ãnî rú Ôvârí ândrá, tãlâ nĩ gâ vólé dó tã lẽlé má ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã âtázó kĩ, “Õzõ óõdrô líndrí õnjí trá õjílã ꞌásĩ rî, líndrí õnjí ꞌdĩ âꞌdô nĩꞌá lậmú bê võ ãgângbêlẽ ꞌásĩ, nĩꞌá võ lôndã bê rĩzó ꞌá lâ. Õzõ gõꞌdá gólâ ũûsû võ kô rĩzó lôvólé ꞌá lâ rî, ");
INSERT INTO avu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","gólâ âꞌdô tã âtáꞌá íyî nyãányâ drí kĩ, ‘Má âꞌdô nĩꞌá gõlé õjílã má drí âfõzó ꞌálâ sĩ rî ꞌá.’ Õzõ õjílã ꞌdî ạ̃ậzı̣̂ Líndrí Tãndí Ôvârí kâ kô rĩlí íyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî, líndrí õnjí ꞌdĩ âꞌdô õjílã ꞌdî pı̣̃pı̣̂sı̣́lı̣́ lâ ûsúꞌá drẽ zãâ tãkó ĩtí. Úkũ ꞌâ lâ trá ngbángbá, gõꞌdá éêdê trá tãndí ró. ");
INSERT INTO avu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gõꞌdá líndrí õnjí ꞌdĩ âꞌdô nĩꞌá líndrí õnjí õnjĩ lâ drí lậvũlı̣́ gạ̃rạ̃ gólâkâ drı̣̃ı̣̂ sĩ rî ꞌbá yî ậdrı̣̃lı̣́ njı̣̂-drı̣̃-lâ-rı̣̃, drílĩyî ânĩzó fĩlí õjílã ꞌdî ꞌá. Ĩtí rî, líndrí õnjí ꞌdĩ ꞌbá yî âꞌdô õjílã ꞌdî ꞌẽꞌá õnjí tẽtẽ ró rõô lậvũlı̣́ gạ̃rạ̃ gólâ sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ. Âꞌdô âꞌdóꞌá kpá ĩtí õjílã kậyı̣̂ nõ ꞌbá yí kâ gólĩyî vólé gã ꞌbá dó tã lẽlé má ꞌá rî ꞌbá yî drí.” ");
INSERT INTO avu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Gõꞌdá Yésũ õtírĩ rĩî drẽ zãâ tã âtálé õꞌbí ꞌdĩ ꞌbá yî drí rî, ândrê lâ yî ậdrúpı̣̃ lâ yí bê, drílĩyî âcázó ânĩꞌá gólâ rî lôndã bê. Drílĩyî âdrézó ãkpã ĩví ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gõꞌdá drílĩyî õjílã ãlô jõzó fĩlí jó ꞌálâ, nĩꞌá tã âtálé Yésũ drí kĩ nĩ rî, “Ánî ândré yî ánî ậdrúpı̣̃ yí bê, gólĩyî bê ĩví ꞌálâ, gólĩyî kĩ nĩ rî, ní õnĩ ĩyî ngálâ, tãlâ yĩ lẽ tã âtálé ní bê.” ");
INSERT INTO avu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó kĩ nĩ rî, “Ámâ ândré íyíkâ ãꞌdî ĩꞌdî ámâ ậdrúpı̣̃ yí bê yã?” ");
INSERT INTO avu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Gõꞌdá Yésũ drí íyî drı̣́ îjõzó tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî âꞌdálé, gõꞌdá drílâ ngãzó tã âtálé kĩ nĩ rî, “Nĩ ndrê drẽ, nõ ꞌbá yî rĩꞌá ámâ ândré yî ĩꞌdî ámâ ậdrúpı̣̃ yí bê. ");
INSERT INTO avu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ĩtí rî, õjílã gólĩyî rĩ ꞌbá tã gólâ ámâ átá ûrú ꞌálâ rî drí lẽlé õjílã drí ꞌẽlé rî ꞌbá yî ꞌẽlé ĩꞌdî rî, gólĩyî ĩꞌdî ámâ ậdrúpı̣̃ yî, ámâ îzó yî, gõꞌdá ámâ ândré yí bê.” ");
INSERT INTO avu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kậyı̣̂ ãlô-ãlô ꞌdĩ sĩ rî, Yésũ yî drí ngãzó ꞌbã ꞌdî âyélé nĩzó lı̣̃mvû ândrê Gãlĩláyã kâ tı̣́ ꞌálâ, tãlâ yí nĩ ró bê rĩlí tólâ õjílã îmbálé. ");
INSERT INTO avu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gõꞌdá õjílã drí îtõzó rĩꞌá ânĩlí Yésũ ngálâ. Gõꞌdá gólâ ndrê õjílã ꞌdî ꞌbá yî bê rû êꞌbéꞌá âcálé dũû yí lạ̃gạ́tı̣́ rî, drílâ ngãzó mbãlé kõlóngbõ ꞌá rĩlí vũdrı̣́. Gõꞌdá õjílã õꞌbí ꞌdĩ ꞌbá yî drí âdrézó ĩyíkâ lı̣̃mvû ândrê ꞌdĩ gãrã drı̣̃ lâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gõꞌdá Yésũ drí îtõzó rĩꞌá tã ãmbá ãzâ ꞌbá yî îmbálé õꞌbí ꞌdĩ ꞌbá yî drí úlı̣́ mãnĩgõ yî sĩ íꞌdígówá yí bê. Gólâ kĩ nĩ rî, “Kậyı̣̂ ãzâ sĩ, ạ́mvú ꞌwã ꞌbá ãzâ drí ngãzó nĩlí yí drí ạ́mvú ꞌálâ nĩꞌá órĩ rĩlí. ");
INSERT INTO avu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Gõꞌdá gólâ õtírĩ rĩî órĩ rĩlí rî, órĩ ãzâ ꞌbá yî lôꞌdê ĩyíkâ trá pávó tı̣̂ ꞌá. Gõꞌdá ãríwá ânĩ trá ûꞌdúlâ nyãlé. ");
INSERT INTO avu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gõꞌdá órĩ ãzâ ꞌbá yî lôꞌdê ĩyíkâ võ gólâ rõvõ bê ı̣̃nyạ́kú lâ drí âꞌdózó cé fínyáwá rî ꞌá. Gõꞌdá ĩtí rî, órĩ lâ drí âfõzó mbãlé ꞌwãâꞌwâ, tãlâ ı̣̃nyạ́kú âꞌdó kô fĩfĩ ró. ");
INSERT INTO avu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gõꞌdá ı̣̃tú âfõ bê kãlé gbílí-gbílí rî, drílâ ngá-ạ̃rú ꞌdĩ zãzó, drílâ ândrázó ꞌĩlí, gõꞌdá drílâ drãzó, tãlâ índrĩgó lâ fí kô dódó ı̣̃nyạ́kú ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gõꞌdá órĩ ãzâ ꞌbá yî lôꞌdê ĩyíkâ ãsõpá ngbũkpũ rî ꞌbá yî lãfálé ꞌá. Ĩtí rî, drílĩyî âfõzó mbãlé tãndí ró. Gõꞌdá ãsõpá ꞌdĩ ꞌbá yî drí ngá-ạ̃rú ꞌdĩ ꞌbá yî võzó, drílĩyî drãzó. ");
INSERT INTO avu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gõꞌdá órĩ ãzâ ꞌbá yî lôꞌdê ĩyíkâ ı̣̃nyạ́kú tãndí ꞌá. Drílĩyî mbãzó tãndí ró lõꞌwâ ꞌwãlé cõkpõ-cõkpõ. Gõꞌdá ãzâ ꞌbá yî drí lõꞌwâ ꞌwãzó kámá-ãlô, ãzâ ꞌbá yî ꞌwâ ĩyíkâ nyâꞌdî-nâ, gõꞌdá ãzâ ꞌbá yî ꞌwâ ĩyíkâ nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́. ");
INSERT INTO avu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gõꞌdá õzõ nĩ ãârî tã bê rî, ꞌdõvó nĩ ârî úlı̣́ ꞌdĩ ꞌbá yî dódó ꞌbãlé ãnî drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nĩngá sĩ, tã ârí ꞌbá Yésũ kâ rî ꞌbá yî drí ânĩzó ĩyî gólâ ngálâ tã îjílí gólâ tı̣́ kĩ, “Tãlâ ãꞌdô ꞌî ní drí rĩzó tã îmbálé õjílã drí úlı̣́ mãnĩgõ sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, “Ónyĩ ãnî nyãányâ trá, tãlâ tã Ôvârí kâ gólâ drí lậpı̣́lı̣́ õjílã ãzâ ꞌbá yî drí sĩ tã tíbê gólâ drí õjílã ꞌbãzó rĩlí kũmũ íyíkâ zẽlé rî tãsĩ rî áâꞌdâ ró bê ãnî drí. Gõꞌdá rĩꞌá âmbâ-âmbâ ró õjílã ãzâ ꞌbá yî drí tã ꞌdî ꞌbá yî nı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nĩ ndrê drẽ, õjílã gólĩyî tã Ôvârí kâ drí fĩzó gólĩyî drı̣̃ı̣̂ rî, áâꞌdô gólĩyî îmbáꞌá rõô tã Ôvârí kâ sĩ. Gólĩyî âꞌdô ꞌbãꞌá tã nı̣̃nı̣̃ bê ãmbá. Gõꞌdá gólĩyî tã ámákâ drí fĩzó gólĩyî drı̣̃ı̣̂ kôꞌdáwá rî, tã Ôvârí kâ fínyáwá gólĩyî drí nı̣̃lı̣́ ꞌdĩ îcá kô gólĩyî pãlé, âꞌdô ꞌbãꞌá cú ĩtí lôsĩ ãkó. ");
INSERT INTO avu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Má rî tã îmbálé úlı̣́ mãnĩgõ sĩ íꞌdígówá bê, tãlâ tã gólĩyî má drí rĩꞌá ꞌẽlâ rî, õjílã ãmbá gólĩyî rĩ ꞌbá ndrẽlâ rî ꞌbá yî âmbê ĩyî lı̣̃fı̣́ kpạ̃ạ́kũ, tãlâ ĩyî õzó kô îcá ndrẽlâ. Ĩtí rî, gólĩyî îcá kô tã ífí lâ nı̣̃lı̣́. Gõꞌdá tã má drí rĩꞌá âtálâ rî, ârî ĩyî bê rî, gólĩyî jâ ĩyî bı̣́ vólé, tãlâ ĩyî õzó kô îcá ârílâ. Ĩtí rî, tã lâ fí kpá kô gólĩyî drı̣̃ı̣̂. ꞌDĩî tã ífí gólâ má drí rĩzó gólĩyî îmbálé úlı̣́ mãnĩgõ sĩ íꞌdígówá bê rî ĩꞌdî ꞌdĩ. ");
INSERT INTO avu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ĩtí rî, tã gólâ tã ậngũ ꞌbá Ĩsáyã drí âtálé trá ạ̃kû ró gólĩyî tãsĩ rî rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî, kĩꞌá nĩ rî, ‘Nĩ âꞌdô úlı̣́ ámákâ âríꞌá, gõꞌdá tã lâ îcá kô fĩlí ãnî drı̣̃ı̣̂. Nĩ âꞌdô tã gólâ má drí rĩꞌá ꞌẽlâ rî ndrẽꞌá, gõꞌdá nĩ îcá kô tã ífí lâ nı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tí õjílã ꞌdî ꞌbá yî drı̣̃ lâ yî õró ꞌbãâ kô âmbâ-âmbâ ró, gõꞌdá gólĩyî õró ĩyî bı̣́-ꞌbálé ậsı̣̃ı̣̂ kô kpạ̃ạ́kũ, gõꞌdá õró ĩyî kpá lı̣̃fı̣́ âmbé kpạ̃ạ́kũ kô rî, tí lı̣̃fı̣́ lâ yî ndrê tã nô trá, tí bı̣́-ꞌbálé lâ yî ârî tã nô trá, tí tã ámákâ fî nõ trá gólĩyî drı̣̃ı̣̂. Gõꞌdá gólĩyî âjâ drı̣̃ nô trá âgõlé má ngálâ, má pâ ró gólĩyî bê.’ ");
INSERT INTO avu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ãnî tã ârí ꞌbá ámákâ rî ꞌbá yî, ãnî rĩꞌá ândrâ-tãndĩ bê, tãlâ nĩ njı̣̃ ãnî lı̣̃fı̣́ trá tã ámákâ ndrẽlé dódó, gõꞌdá nĩ njı̣̃ ãnî bı̣́-ꞌbálé kpá trá tã ámákâ ârílí dódó gõzó ꞌẽlâ tãndí ró. ");
INSERT INTO avu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, tã ậngũ ꞌbá dũû gólĩyî âꞌdó ꞌbá ạ̃kû ró nã ꞌbá yî gõꞌdá tã mbı̣̂ ꞌbá dũû Ôvârí kâ ãzâ ꞌbá yí bê, gólĩyî lẽ ĩyî trá tákányĩ tã gólĩyî ãnî drí rĩꞌá ndrẽlé ngbãângbânõ ãnî lı̣̃fı̣́ sĩ nõ ꞌbá yî ndrẽlé, gõꞌdá gólĩyî îcá kô ndrẽlâ. Gólĩyî lẽ trá kpá tã gólĩyî ãnî drí rĩꞌá ârílâ ngbãângbânõ rî ârílí ĩyî bı̣́ sĩ, gõꞌdá gólĩyî îcá kpá kô ârílâ.” ");
INSERT INTO avu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gõꞌdá Yésũ drí îtõzó íꞌdígówá órĩ rĩ ꞌbá kâ ꞌdĩ tã ífí lâ âꞌdálé. Gólâ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Nĩ ârî drẽ, órĩ gólĩyî ꞌdẽ ꞌbá lạ́tı̣̂ ꞌá rî, ꞌdĩî õjílã gólĩyî tã âtî-âtî tãndí kũmũ Ôvârí kâ rî tãsĩ rî ârí ꞌbá, gõꞌdá tã lâ fí gólĩyî drı̣̃ı̣̂ dódó kô. Ĩtí rî, Sãtánã drí ânĩzó úlı̣́ gólĩyî drí ârílí ꞌdĩ trõlé vólé gólĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Gõꞌdá órĩ gólĩyî ꞌdẽ ꞌbá ı̣̃nyạ́kú rõvõ bê rî ꞌá rî, ꞌdĩî rĩꞌá õjílã gólĩyî tã âtî-âtî tãndí ꞌdĩ ârí ꞌbá dódó, gõꞌdá drílĩyî tã lẽzó ꞌá lâ ãyĩkõ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Gõꞌdá tã lẽlẽ gólĩyíkâ âꞌdó kô cú mbârâkã bê rõô. Ĩtí rî, úlı̣́ gólĩyî drí ârílí ꞌdĩ ꞌbá yî îcá kô rĩlí zãâ gólĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá. Gõꞌdá õzõ kậyı̣̂ ĩzã kâ ãâcâ trá rî, ngãtá õzõ óõfẽ lâŋõ õnjí tẽtẽ trá gólĩyî drí tã lẽlẽ gólĩyíkâ tãsĩ rî, drílĩyî tã lẽlẽ ĩyíkâ ꞌdĩ âyézó ꞌwãâ ró. ");
INSERT INTO avu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Órĩ gólâ ꞌdẽ ꞌbá ãsõpá ngbũkpũ lãfálé ꞌá rî, ꞌdĩî rĩꞌá õjílã gólĩyî tã âtî-âtî tãndí Ôvârí kâ ꞌdĩ ârí ꞌbá dódó gõzó tã lẽlé ꞌá lâ. Gbõ lé ĩtí rî, gólĩyî rĩꞌá tã ı̣̂sũ bê rõô ngá gólĩyî ãngó nõ ꞌá nõ ꞌbá yî tãsĩ. Ĩtí rî, gólĩyî lẽ âꞌdólé ngá-drı̣̃ ãmbá bê. Tã ı̣̂sũ gólĩyíkâ ꞌdĩ âꞌdô gólĩyî âdóꞌá. Ĩtí rî, tã lẽlẽ gólĩyíkâ Ôvârí ꞌá ꞌdĩ drí âꞌdózó cú ĩtí lõꞌwâ ãkó. ");
INSERT INTO avu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Órĩ gólâ ꞌdẽ ꞌbá ı̣̃nyạ́kú tãndí ꞌá rî, ꞌdĩî rĩꞌá õjílã gólĩyî tã âtî-âtî tãndí Ôvârí kâ ꞌdĩ ârí ꞌbá drílĩyî tã lẽzó ꞌá lâ pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ rî ꞌbá yî ĩꞌdî. Ĩtí rî, ãzâ ꞌbá yî drí lõꞌwâ ꞌwãzó âcálé kámá-ãlô tã ꞌẽꞌẽ tãndí gólĩyíkâ sĩ, ãzâ ꞌbá yî ꞌwâ ĩyíkâ nyâꞌdî-nâ, gõꞌdá ãzâ ꞌbá yî ꞌwâ ĩyíkâ nyâꞌdî-ãlô-drı̣̃-lâ-ngâ-mûdrı̣́.” ");
INSERT INTO avu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Gõꞌdá nĩngá sĩ, Yésũ drí îtõzó íꞌdígówá ãzâ âtálé õꞌbí ꞌdĩ ꞌbá yî drí kĩ, “Tã gólâ Ôvârí drí ꞌẽzó õjílã gólĩyî rĩ ꞌbá ĩyî kũmũ íyíkâ zẽlé rî vó lâ yî ndrẽlé rî rĩꞌá nõtí. Ãgô ãzâ drí ạ́mvú íyíkâ ꞌwãzó, gõꞌdá drílâ ĩfó órĩ tãndí rĩzó ạ́mvú íyíkâ ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gõꞌdá ngạ́cı̣̂ ãzâ sĩ, õjílã õtírĩ ꞌbãâ ĩyî ndrĩ ậꞌdú kõꞌá rî, ạ̃jú-ꞌbá-ãzí ạ́mvú lı̣́pı̣̂ ꞌdĩ kâ drí ânĩzó kírî ró írírí ífí rĩlí dró ĩfó gólâkâ rĩlí ꞌdĩ ꞌbá yî lãfálé sĩ. Gõꞌdá drílâ íyîngá ngãzó lậvũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gõꞌdá ĩfó ꞌdĩ ꞌbá yî õtírĩ ꞌbãâ âfõꞌá mbãlé lõꞌwâ ꞌwãlé rî, gõꞌdá írírí ꞌdĩ ꞌbá yî drí kpá âfõzó mbãlé ꞌdũwạ̃ ĩfó ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ạ́mvú lı̣́pı̣̂ ꞌdĩ kâ ꞌdĩ ꞌbá yî ndrê ĩyî írírí rĩ ꞌbá âfõlé ĩfó lãfálé sĩ ꞌdî ꞌbá yî bê rî, drílĩyî ngãzó nĩlí ạ́mvú lı̣́pı̣̂ ꞌdĩ îjílí kĩ, ‘Ãmbá, ákĩ, ní rî fí cé ĩfó órĩ ĩꞌdî ạ́mvú áníkâ ꞌdĩ ꞌá kô yã? Gõꞌdá írírí âfõ ꞌbá ꞌá lâ rõô ꞌdĩ ꞌbá yî ûsû rû ĩyíkâ ángô lésĩ yã?’ ");
INSERT INTO avu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gõꞌdá ạ́mvú lı̣́pı̣̂ ꞌdĩ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, ‘Ạ̃jú-ꞌbá-ãzí rî ĩyî írírí ꞌdĩ ꞌbá yî nĩ.’ Ĩtí rî, rû ı̣̂ꞌbũ ꞌbá gólâkâ ꞌdĩ ꞌbá yî drí gólâ rî îjízó kĩ, ‘Ãꞌdô bê ĩtí rî, ní lẽ tã-drı̣̃ trá ãmâ drí nĩzó írírí ꞌdĩ ꞌbá yî ôngílí vólé yã?’ ");
INSERT INTO avu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Gõꞌdá ĩtí rî, ạ́mvú lı̣́pı̣̂ ꞌdĩ drí kpá tã-drı̣̃ lôgõzó drílĩyî kĩ, ‘ꞌÉꞌẽ, nĩ ôngî drẽ kô ngbãângbânõ, tãlâ nĩ õzó gõꞌdá kô ĩfó ôngí kpãâ gólĩyí bê. ");
INSERT INTO avu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nĩ âyê drẽ írírí ꞌdĩ ꞌbá yî õmbâ ró ĩyî ꞌdũwạ̃ ĩfó ꞌdĩ ꞌbá yí bê cãlé bũúũ párá rĩzó ĩfó ŋõlé rî ꞌá. ꞌDĩî vósĩ rî, má âꞌdô tã âtáꞌá lôsĩ ꞌẽ ꞌbá ámákâ rî ꞌbá yî drí, gólĩyî õôngî ró ĩyî drẽ írírí ꞌdĩ ꞌbá yî sı̣́sı̣́, gólĩyî õômbê ró tũ võ ãlô ꞌá zãlé lạ̃sı̣́ sĩ, gõꞌdá gólĩyî õgõ ró ĩfó ŋõlé ꞌbãlé ẽró ꞌá.’ ” ");
INSERT INTO avu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Gõꞌdá Yésũ drí úlı̣́ mãnĩgõ ãzâ âtázó rı̣̃ õjílã gólĩyî ꞌẽ ꞌbá âꞌdólé õjílã Ôvârí kâ ró rî ꞌbá yî tãsĩ. Gólâ kĩ, “Lạ́tı̣̂ gólâ Ôvârí drí ꞌẽzó õjílã dũû ꞌbãlé lîzólé âꞌdólé õjílã íyíkâ ró rî rĩꞌá õzõ ãgô ãzâ gólâ líꞌbá ífí ı̣̂ꞌdı̣́ ꞌbá ạ́mvú íyíkâ ꞌá rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gbõ lé líꞌbá ífí ꞌdĩ rĩꞌá fínyáwá ĩtí rî, gõꞌdá õtírĩ âfõô rî, âꞌdô mbãꞌá âcálé fê ạ́ngı̣́ ró. Ĩtí rî, ãríwá âꞌdô ĩyî rĩꞌá gárá lâ ꞌdĩ ꞌbá yî drı̣̃ı̣̂. Âꞌdô âꞌdóꞌá kpá ĩtí õjílã dã gólĩyî rĩ ꞌbá ámâ vó lôbẽlé rî ꞌbá yî drí, gólĩyî âꞌdô ꞌẽꞌá lîzólé dũû ĩtí ı̣̃zạ́tú.” ");
INSERT INTO avu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gõꞌdá nĩngá sĩ rî, Yésũ drí kpá úlı̣́ mãnĩgõ ãzâ âtázó tã ãlô-ãlô ꞌdĩ tãsĩ. Gólâ kĩ, “Lạ́tı̣̂ gólâ Ôvârí drí ꞌẽzó õjílã íyíkâ ꞌbãlé lîzólé dũû rî kpá rĩꞌá õzõ õkó ãzâ gólâ lẽ ꞌbá ãmbãtã íyíkâ ạ̃kú sĩ rî ꞌbẽlé rî kâtí. Gólâ âꞌdô ꞌạ̃ꞌı̣́-ãrá âtrõꞌá ãmbá gõzó ạ̃kú âtrõlé fínyáwá ĩtí dãlé ꞌá lâ. Ĩtí rî, ạ̃kú fínyáwá ꞌdĩ drí ꞌạ̃ꞌı̣́-ãrá ꞌdĩ ꞌbãzó ậpı̣̃lı̣́ ãmbá.” ");
INSERT INTO avu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Yésũ rí kô õꞌbí îmbálé cú ĩtí úlı̣́ mãnĩgõ ãkó íꞌdígówá bê. Gólâ rî gólĩyî îmbálé úlı̣́ mãnĩgõ sĩ íꞌdígówá bê ꞌdĩ, tãlâ úlı̣́ gólâ tã ậngũ ꞌbá Ôvârí kâ drí âtálé trá ạ̃kû ró Yésũ rî tãsĩ rî nã ꞌbá yî ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró. Úlı̣́ rî ꞌdĩ ꞌbá yî kĩ, “Má âꞌdô tã âtáꞌá ãnî drí úlı̣́ mãnĩgõ sĩ íꞌdígówá bê. Má âꞌdô tã gólĩyî lậpı̣́lı̣́ kírî îtõ võ ãngó nõ kâ ꞌásĩ rî ꞌbá yî âꞌdáꞌá ãnî drí úlı̣́ mãnĩgõ sĩ íꞌdígówá bê.” ");
INSERT INTO avu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nĩngá sĩ, Yésũ yî drí ngãzó õꞌbí ꞌdĩ ꞌbá yî âyélé tã ârí ꞌbá íyíkâ yí bê nĩzó gõlé ꞌbã ꞌálâ. Gõꞌdá gólĩyî câ bê ꞌbã ꞌálâ rî, tã ârí ꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ânĩzó ĩyî gólâ rî îjílí kĩ, “Ní âꞌdâ drẽ íꞌdígówá áníkâ írírí ífí kâ rĩlí ạ́mvú ĩfó kâ ꞌá ꞌdĩ ĩtõ lâ ãmâ drí.” ");
INSERT INTO avu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Gõꞌdá Yésũ drí ngãzó íꞌdígówá ꞌdĩ tã ífí lâ âꞌdálé drílĩyî. Gólâ kĩ, “Ãgô gólâ órĩ ĩfó kâ rĩ ꞌbá ạ́mvú íyíkâ ꞌá ꞌdĩ mâ gólâ Ôvârí drí âjólé ûrú lésĩ nõ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gõꞌdá ạ́mvú rî gógó íyíkâ ãngó nõ ĩꞌdî. Gõꞌdá órĩ ĩfó kâ ꞌdĩ íyíkâ õjílã gólĩyî ꞌẽ ꞌbá âꞌdólé õjílã Ôvârí kâ ró rî ꞌbá yî ĩꞌdî. Gõꞌdá órĩ írírí kâ ꞌdĩ íyíkâ õjílã gólĩyî Sãtánã kâ ró rî ꞌbá yî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Gõꞌdá ạ̃jú-ꞌbá-ãzí gólâ órĩ õnjí írírí kâ rĩ ꞌbá ꞌdĩ íyíkâ Sãtánã ĩꞌdî. Kậyı̣̂ ĩfó ŋõ kâ ꞌdĩ íyíkâ kậyı̣̂ ạ̃dũkũ ãngó nõ kâ rî ĩꞌdî. Gõꞌdá lôsĩ ꞌẽ ꞌbá ngá gólĩyî ạ́mvú ꞌá rî ŋõlé rî ĩyíkâ mãlãyíkã Ôvârí kâ rî ꞌbá yî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Õzõ írírí êꞌbérẽ tũ võ ãlô ꞌá zãlé lạ̃sı̣́ ꞌá rî kâtí, âꞌdô rû ꞌẽꞌá kpá ĩtí kậyı̣̂ ạ̃dũkũ ãngó nõ kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gõꞌdá má âꞌdô mãlãyíkã ámákâ âjóꞌá. Gólĩyî âꞌdô ânĩꞌá õjílã gólĩyî rĩ ꞌbá õjílã ãzí ꞌbãlé tã õnjí ꞌẽlé rî ꞌbá yî êꞌbélé ndrĩ ãngó Ôvârí drí ꞌbãlé nõ ꞌásĩ, gõꞌdá kpá gólĩyî ndrĩ rĩ ꞌbá tã õnjí ãzâ ꞌbá yî ꞌẽlé rî ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gõꞌdá mãlãyíkã ꞌdî ꞌbá yî âꞌdô gólĩyî trõꞌá vũlı̣́ lạ̃sı̣́ rạ̃ꞌdạ̃ êdélé Sãtánã yî drí rî ꞌá vẽlé tólâ ngbá. Gólĩyî âꞌdô ãwó ngõꞌá sı̣́-gílí nyãnyã bê, ngá lãzé-lãzé õnjí ꞌdĩ drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Gõꞌdá õjílã gólĩyî rĩ ꞌbá tã mbı̣̂ Ôvârí kâ ꞌẽlé rî ꞌbá yî, gólĩyî âꞌdô lậgúꞌá lậgû õzõ ı̣̃tú kâtí ãngó óꞌdí gólĩyî átá Ôvârí kâ rî ꞌálâ. Õzõ nĩ ãꞌdô bı̣́ bê rî, ꞌdõvó nĩ ârî drẽ úlı̣́ ámákâ ꞌdĩ ꞌbá yî dódó.” ");
INSERT INTO avu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Gõꞌdá nĩngá sĩ, Yésũ drí úlı̣́ mãnĩgõ ãzâ âtázó rı̣̃ tã âꞌdô-âꞌdô õjílã Ôvârí kâ ró rî kâ tãsĩ. Gólâ kĩ, “Tã âꞌdô-âꞌdô õjílã Ôvârí kâ ró rî kâ rĩꞌá nyé õzõ ãgô ãzâ gólâ nĩ ꞌbá ngá gólâ lâgî lâ drí âꞌdózó rõô õzõ dáãbõ kâtí lậpı̣́lı̣́ trá võ ạ́mvú kâ ꞌá rî ûsúlı̣́ rî kâtí. Gõꞌdá gólâ ndrê ngá rî ꞌdĩ bê rî, drílâ lậpı̣́zó lâ kpá óꞌdí võ rî ꞌdĩ ꞌá. Gõꞌdá drílâ ngãzó nĩꞌá gõlé yí drí ꞌbã ꞌálâ, nĩꞌá ngá íyíkâ ꞌbã kâ lậzı̣́lı̣́ gĩlí ndrĩ vólé, ãꞌdô ró yí drí âꞌdózó lãfâ bê dũû âgõzó ạ́mvú võ ꞌdî gĩlí, ãꞌdô ró bê íyî nyãányâ kâ ró, gõꞌdá ngá gólâ õzõ dáãbõ kâtí ꞌdĩ, yí trõ ró bê yí drí. ");
INSERT INTO avu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Gõꞌdá âꞌdô-âꞌdô õjílã Ôvârí kâ ró rî kpá rĩꞌá õzõ ngá lậzı̣́ ꞌbá gólâ nĩ ꞌbá ngá ꞌdíyî lôꞌĩ kâ sũsũ ró zı̣̃lı̣́ pérẽlẽ rî lôndã bê gĩlí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gõꞌdá drílâ pérẽlẽ ãzâ sũsũ ró lâgî lâ drí lậvũlı̣́ gạ̃rạ̃ rî ûsúzó. Gõꞌdá gólâ ûsû pérẽlẽ ꞌdî bê rî, drílâ nĩzó ngá íyíkâ lậzı̣́lı̣́ gĩlí ndrĩ vólé, gõꞌdá drílâ pérẽlẽ ꞌdî gĩzó yí drí.” ");
INSERT INTO avu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Gõꞌdá nĩngá sĩ, Yésũ drí kpá úlı̣́ mãnĩgõ ãzâ âtázó kĩ, “Tã Ôvârí drí ꞌẽzó õjílã íyíkâ êpẽlé trõlé ûrú ꞌálâ rî rĩꞌá nyé õzõ ı̣̃ꞌbı̣̂ ꞌbẽ ꞌbá ãzâ ꞌbá yî nĩ ꞌbá ı̣̃ꞌbı̣̂ ꞌbẽlé áyágá ꞌálâ îmbá sĩ gõꞌdá drílĩyî ı̣̃ꞌbı̣̂ tı̣̂ ûrúzó dũû îmbá ĩyíkâ ꞌdĩ ꞌá rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gõꞌdá drílĩyî gõzó îmbá ꞌdĩ âsélé ĩvĩ ángálángâ drı̣̃ ꞌálâ. Gõꞌdá drílĩyî ı̣̃ꞌbı̣̂ gólĩyî tãndí rî yî êpẽzó ꞌbãlé bâgã ꞌá, gõꞌdá ngá lédrẽ-lédrẽ õnjí rî ꞌbá yî êpẽzó vũlı̣́ vólé. ");
INSERT INTO avu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Âꞌdô ꞌẽꞌá rû ꞌẽlé kpá ĩtí kậyı̣̂ ạ̃dũkũ ãngó nõ kâ sĩ. Mãlãyíkã Ôvârí kâ âꞌdô ĩyî ânĩꞌá õjílã gólĩyî õnjí rî ꞌbá yî lãfálé lâ cãlé õjílã gólĩyî tãndí rî ꞌbá yî rú sĩ. ");
INSERT INTO avu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ĩtí rî, áâꞌdô õjílã õnjí ꞌdĩ ꞌbá yî trõꞌá vũlı̣́ lạ̃sı̣́ ꞌá. Tólâ gólĩyî âꞌdô ãwó ngõꞌá sı̣́-gílí nyãnyã bê ngá lãzé-lãzé lạ̃sı̣́ kâ ꞌdĩ drí sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Gõꞌdá Yésũ drí tã îjízó tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî tı̣́ kĩ, “Tã ꞌdî ꞌbá yî fî trá ãnî drı̣̃ı̣̂ yã?” Gõꞌdá drílĩyî tã ꞌdî drı̣̃ lâ kõzó kĩ, “Ãwô, tã ꞌdî ꞌbá yî fî trá ãmâ drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gõꞌdá Yésũ drí kpá tã âtázó drílĩyî kĩ nĩ rî, “Rĩꞌá tãndí ró õzõ ãꞌdô trá ĩtí rî, tãlâ lãꞌbí îmbá ꞌbá gólâ tã Ôvârí kâ ı̣̂lı̣́ ꞌbá gõꞌdá drílâ gõzó rĩlí kũmũ Ôvârí kâ zẽlé rî, gólâ rĩꞌá nyé õzõ ꞌbã-lı̣́pı̣̂ gólâ ngá tãndí óꞌdí íyíkâ lôfõ ꞌbá ngá tãndí ạ̃kû bê võ gólâ drí lậpı̣́zó lâ rî ꞌásĩ tã tãndí ꞌẽzó ĩꞌdî sĩ lâ yî rî kâtí. Gólâ âꞌdô tã Ôvârí drí âꞌdálé ạ̃kû ró rî ꞌbá yî ı̣̂lı̣́ꞌá tã Ôvârí drí âꞌdálé ngbãângbânõ rî ꞌbá yí bê.” ");
INSERT INTO avu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nĩngá sĩ, Yésũ ndẽ bê tã îmbâ íyíkâ úlı̣́ mãnĩgõ sĩ ꞌdî ꞌbá yî rî, drílâ ngãzó nĩlí vólé nĩngá sĩ. ");
INSERT INTO avu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gõꞌdá nĩngá sĩ rî, Yésũ drí ngãzó nĩꞌá gõlé jạ̃rı̣́bạ̃ íyî nyãányâ kâ Nãzãrétã rî ꞌálâ. Gõꞌdá gólâ câ bê tólâ rî, drílâ nĩzó fĩlí jó tã Ôvârí kâ ârî kâ ꞌálâ, rĩꞌá õjílã îmbálé. Ĩtí rî, õjílã ârî ĩyî tã gólâ drí rĩꞌá îmbálâ ꞌdĩ ꞌbá yî bê rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó. Gõꞌdá drílĩyî ngãzó tã âtálé Yésũ rú kĩ, “Ãgô nõ ûsû íyíkâ tã nı̣̃nı̣̃ rõô mbârâkã bê rĩzó tã lârâkô ꞌẽlé nõ ãꞌdô ꞌásĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mã nı̣̃ gólâ trá tãndí ró. Gólâ ĩꞌdî ãgô gólâ rĩ ꞌbá ngá êdélé fê ꞌásĩ rî mvá lâ ĩꞌdî. Ândrê lâ Mãríyã ĩꞌdî. Gõꞌdá ậdrúpı̣̃ lâ yî ĩꞌdî Yãkóbã, Yõsépã, Sĩmónã gõꞌdá kpá Yúdạ̃. ");
INSERT INTO avu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gõꞌdá îzó lâ yî ndrĩ ꞌdó rĩꞌá ĩyî ãmá bê nõngá. Gõꞌdá gólâ âꞌdô rû jãꞌá âꞌdólé tã nı̣̃nı̣̃ ꞌdî ꞌbá yí bê rõô gõꞌdá kpá mbârâkã bê rõô ꞌdĩ íyíkâ ángô tí ró yã?” ");
INSERT INTO avu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ĩtí rî, õjílã ꞌdî ꞌbá yî drí âꞌdózó ạ̃wạ̃ ró Yésũ bê, Gõꞌdá drílĩyî Yésũ rî gãzó dó lı̣̃fı̣́ îmbá ꞌbá ró. Gõꞌdá ĩtí rî, Yésũ drí ngãzó tã âtálé drílĩyî kĩ, “Órî tã ậngũ ꞌbá ı̣̂njı̣̃lı̣́ ı̣̂njı̣̃ võ ꞌásĩ ndrĩ. Gõꞌdá cé õjílã ꞌbạ̃drı̣̃ gólâ rî nyãányâ kâ rî ꞌbá yî gõꞌdá õjílã ꞌbã-tı̣̂ gólâkâ rî kâ rî ꞌbá yí bê ı̣̂njı̣̃ı̣́ ĩyî gólâ kô.” ");
INSERT INTO avu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tãlâ tã lẽ ãkõ õjílã ꞌdî ꞌbá yí kâ tãsĩ rî, gólâ ꞌé tã tı̣̂ drí ậꞌdı̣́zó rî ꞌbá yî kô ãmbá ꞌbạ̃drı̣̃ íyíkâ ꞌdĩ ꞌá nĩngá. ");
INSERT INTO avu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kậyı̣̂ nã ꞌbá yî sĩ rî, Ẽródẽ Ãnĩtípã ĩꞌdî kúmú ạ́ngı̣́ ꞌî ꞌbạ̃drı̣̃ Gãlĩláyã kâ drı̣̃lı̣́. Gõꞌdá drílâ rĩzó tã lârâkô Yésũ drí rĩꞌá ꞌẽlâ rî ꞌbá yî tã lâ yî ârílí. ");
INSERT INTO avu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Gõꞌdá Ẽródẽ ârî tã lârâkô ꞌdĩ ꞌbá yî tã lâ bê rî, gólâ drí tã âtázó Yésũ rî tãsĩ tã lôgõ ꞌbá íyíkâ rî ꞌbá yî drí kĩ, Yésũ ãâꞌdô pạ̃tı̣́ı̣̃ Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî ĩꞌdî. Gólâ õlîdrî trá óꞌdí õdrã ꞌásĩ mbârâkã bê. Ĩꞌdî gólâ drí âꞌdózó cú mbârâkã bê rĩzó tã lârâkô ꞌdĩ ꞌbá yî ꞌẽlé ꞌdĩ. ");
INSERT INTO avu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Nĩ ndrê drẽ, tã gólâ õdrã pá âsé ꞌbá Yõwánĩ drı̣̃ı̣̂ rî ĩꞌdî nõ. Sı̣́sı̣́ rî, kúmú Ẽródẽ drí ậdrúpı̣̃ lâ Fílĩpõ rî õkó rú bê Ẽrõdíyã rî drı̣̃ îzãzó. Gõꞌdá drílâ õkó ꞌdĩ pãzó ậdrúpı̣̃ lâ drı̣́gạ́ sĩ trõlé yí drí õkó ró. Gõꞌdá Yõwánĩ ndrê tã Ẽródẽ drí ꞌẽlé ꞌdĩ bê rî, gólâ drí gõzó tã lôgõlé Ẽródẽ drı̣̃ı̣̂ kĩ, “Âꞌdó kô tã mbı̣̂ ró ní drí õkó pãzó ánî ậdrúpı̣̃ drı̣́gạ́ sĩ.” Gõꞌdá Ẽródẽ ârî tã Yõwánĩ drí âtálé yí drí ꞌdĩ bê rî, drílâ ngãzó ạ̃wạ̃ ró Yõwánĩ bê ꞌẽzó gólâ rî fũlı̣́. Gõꞌdá Ẽródẽ ꞌê bê Yõwánĩ rî fũlı̣́ rî, gólâ drí âꞌdózó ũrı̣̃ ró tã ı̣̂sũ õjílã Yúdạ̃ yí kâ rî ꞌbá yí kâ tãsĩ, tãlâ gólâ nı̣̃ trá kĩ, õjílã Yúdạ̃ yí kâ rî ꞌbá yî nı̣̃ ĩyî trá kĩ Yõwánĩ ãꞌdô rĩꞌá tã ậngũ ꞌbá ꞌî. Tã ꞌdî tãsĩ rî, gólâ ꞌbãá tã kô Yõwánĩ rî fũzó, gõꞌdá gólâ drí tã ꞌbãzó Yõwánĩ rî ậrúzó ômbélé ꞌbãlé gạ̃nı̣́mạ̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nĩngá sĩ, kậyı̣̂ Ẽródẽ rî tı̣̃zó ꞌá lâ rî âcâ bê rî, gólâ drí kãrámã ạ́ngı̣́ ꞌẽzó. Gõꞌdá gólâ drí õjílã ạ́ngı̣́ ạ́ngı̣́ ậzı̣́zó dũû ânĩlí kãrámã ꞌdî ꞌá. Gõꞌdá drílâ tã ꞌbãzó Ẽrõdíyã rî mvá ãnjó drí ậndú tõzó ũmú ꞌdĩ ꞌbá yî ândrá. Gõꞌdá ízámvá ꞌdĩ drí ậndú tõzó sũsũ ró lậvũlı̣́ kôrô gólĩyî ândrá. Ậndú gólâkâ tõlé ꞌdĩ tã lâ drí sũzó kúmú Ẽródẽ rú rõô. ");
INSERT INTO avu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tã rî ꞌdĩ tãsĩ rî, kúmú Ẽródẽ drí lãtrítrí îtrízó ízámvá ꞌdĩ drí kĩ, ngá tíbê gólâ drí zı̣̃lı̣́ yí tı̣́ sĩ rî, yí âꞌdô ngá rî ꞌdĩ fẽꞌá gólâ drí. ");
INSERT INTO avu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gõꞌdá Ẽródẽ rî õkó drí gõzó ngá íyî mvá drí ꞌẽꞌá zı̣̃lâ Ẽródẽ tı̣́ ꞌdĩ âꞌdálé íyî mvá drí. Gõꞌdá ízámvá ꞌdĩ drí gõzó tã âtálé Ẽródẽ drí kĩ, “Ónĩ nĩꞌá Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî drı̣̃ lâ âgálé njíyá ꞌbãlé tạ́bı̣́gạ́ drı̣̃ı̣̂ âjílí má drí nõlé.” ");
INSERT INTO avu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Gõꞌdá Ẽródẽ ârî úlı̣́ ꞌdĩ ꞌbá yî bê rî, gólâ drí gõzó âꞌdólé tã ı̣̂sũ ró úlı̣́ ꞌdĩ ꞌbá yî tãsĩ. Gõꞌdá lãtrítrí gólâ drí îtrílí ũmú ꞌdĩ ꞌbá yî ândrá ꞌdĩ tãsĩ rî, drílâ tã-drı̣̃ lẽzó ngá ízámvá ꞌdĩ drí lẽlé ꞌdĩ fẽzó drílâ. ");
INSERT INTO avu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nĩngá sĩ rî, Ẽródẽ drí ạ̃jú ꞌbũ ꞌbá íyíkâ rî ꞌbá yî jõzó nĩꞌá gạ̃nı̣́mạ̃ ꞌálâ Yõwánĩ rî drı̣̃ âgálé njíyá, drı̣̃ lâ âtrõlé tạ́bı̣́gạ́ drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Gõꞌdá gólĩyî âgâ Yõwánĩ rî drı̣̃ bê rî, drílĩyî âtrõzó lâ tạ́bı̣́gạ́ drı̣̃ı̣̂, ânĩꞌá fẽlâ ízámvá ꞌdĩ drí. Gõꞌdá ízámvá ꞌdĩ drí trõzó lâ nĩꞌá fẽlâ ândrê lâ drí. ");
INSERT INTO avu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ꞌDĩî vósĩ rî, tã ârí ꞌbá Yõwánĩ kâ rî ꞌbá yî drí ânĩzó ĩyî Yõwánĩ rî ãvõ ạ̃lı̣́ ꞌdĩ trõlé nĩꞌá ꞌbãlâ ꞌbú ꞌá. Gõꞌdá drílĩyî nĩzó kpá nĩꞌá tã lâ âtálé Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Gõꞌdá Yésũ ârî bê Yõwánĩ rî õdrã tã rî, drílâ ngãzó nĩlí mbãlé kõlóngbõ ꞌá nĩꞌá lı̣̃mvû ândrê Gãlĩláyã kâ ꞌdĩ drı̣̃ lâ mbãlé, tãlâ yí nĩ ró bê võ gólâ õjílã ãkó rî ûsúlı̣́ rĩzó ꞌá lâ. Gõꞌdá õjílã ârî ĩyî tã bê kĩꞌá nĩ rî, Yésũ ngâ trá ꞌẽꞌá nĩlí kõlóngbõ sĩ rî, drílĩyî ngãzó jạ̃rı̣́bạ̃ ĩyíkâ âyélé lậvũzó sı̣́sı̣́ ꞌálâ pá sĩ lı̣̃mvû ândrê ꞌdĩ gãrã drı̣̃ lâ ꞌásĩ, nĩꞌá võ gólâ Yésũ drí ꞌẽzó nĩlí ꞌá lâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Gõꞌdá Yésũ câ bê tólâ rî, drílâ âfõzó kõlóngbõ ꞌásĩ. Drílâ õꞌbí tı̣́lı̣́lı̣́ ndrẽzó. Gõꞌdá gólâ ndrê õꞌbí ꞌdĩ ꞌbá yî bê rî, gólĩyî ĩzã drí gãzó gólâ rú, gõꞌdá drílâ gólĩyî ngá lãzé bê rî ꞌbá yî êdézó ngá lãzé ĩyíkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gõꞌdá câ bê lạ̃njạ́túlı̣́ bê rî, lãjóꞌbá Yésũ kâ drí ânĩzó Yésũ ngálâ tã îjílí gólâ tı̣́ kĩ, “Nõô gõꞌdá trá võ ãgângbêlẽ ꞌî nõ, ı̣̃tú gõꞌdá trá ꞌẽꞌá fĩlí. Ní jô õꞌbí nõ ꞌbá yî ãkpã nõtí, õnĩ ró ĩyî bê, nĩꞌá ngá nyãnyã lôndãlé võ mvá ãzâ ꞌbá yî õjílã bê rî ꞌásĩ ĩyî drí nyãlé.” ");
INSERT INTO avu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Gõꞌdá Yésũ drí gõzó tã-drı̣̃ lôgõlé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Âꞌdó kô îcâ-îcâ ró drílĩyî nĩzó ngá nyãnyã lôndãlé ĩyî drí nyãlé. Ãnî nyãányâ, nĩ fẽ ngá nyãnyã gólĩyî drí nyãlé.” ");
INSERT INTO avu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ãmâ kó cé rĩꞌá ãmbãtã bê njı̣̂ gõꞌdá ı̣̃ꞌbı̣̂ mvá bê kpá rı̣̃.” ");
INSERT INTO avu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nĩngá sĩ, Yésũ drí tã âtázó drílĩyî kĩ, “Nĩ âjî ngá nyãnyã rî gógó ꞌdĩ ꞌbá yî má ngáá nõlé.” Gõꞌdá drílĩyî trõzó lâ fẽlé Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Gõꞌdá ĩtí rî, Yésũ drí tã âtázó õꞌbí ꞌdĩ ꞌbá yî drí kĩ nĩ rî, gólĩyî õrî vũdrı̣́ õmã drı̣̃ı̣̂. Gólĩyî rî bê vũdrı̣́ rî, gólâ drí ãmbãtã njı̣̂ ꞌdĩ trõzó ı̣̃ꞌbı̣̂ rı̣̃ ꞌdî bê yí drı̣́gạ́ gõꞌdá võ ndrẽzó ꞌbũû ꞌálâ, drílâ rãtáã ꞌẽzó Ôvârí drí ngá nyãnyã ꞌdî ꞌbá yî tãsĩ. Gõꞌdá drílâ ãmbãtã ꞌdî ꞌâ lâ pı̣̃zó ı̣̃ꞌbı̣̂ ꞌdĩ ꞌbá yí bê. Nĩngá sĩ, drílâ trõzó lâ fẽlé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drı̣́gạ́, gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí trõzó lâ lânjílí õꞌbí ꞌdĩ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Drílĩyî nyãzó lâ, ngá nyãnyã ꞌdî drí gólĩyî îcázó. Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí ngá nyãnyã ạ̃mbúkũ lâkí ꞌbá rî êꞌbézó ívõ ꞌásĩ dũûdû zãlô mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃. ");
INSERT INTO avu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ĩtí rî, õjílã gólĩyî ngá ꞌdĩ ꞌbá yî nyã ꞌbá rî rĩꞌá ĩyî kútũ-njı̣̂. ꞌDĩî ólã cé ãgô ĩꞌdî. Gõꞌdá ólãá õkó ꞌdĩyímvá bê kô. ");
INSERT INTO avu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gõꞌdá kôrô tã ꞌdî vósĩ rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, gólĩyî õmbã kõlóngbõ ꞌá lậvũlı̣́ sı̣́sı̣́ ꞌálâ, nĩꞌá gõlé ꞌáꞌá lé drı̣̃ lı̣̃mvû ândrê ꞌdĩ kâ ãzâ lésĩ rî ꞌá. Yî drẽ rĩꞌá tãkõ, tãlâ yí lẽ õꞌbí ꞌdĩ ꞌbá yî jõlé zãlô sı̣́sı̣́, gólĩyî õnĩ ró bê gõlé ĩyî drí ꞌbã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Gõꞌdá Yésũ jô õꞌbí ꞌdĩ ꞌbá yî bê ndrĩ, nĩꞌá gõlé ĩyî drí ꞌbã ꞌásĩ rî, drílâ gõzó mbãlé únı̣́ drı̣̃ ꞌálâ, nĩꞌá rãtáã ꞌẽlé. Gólâ drí rĩzó élê únı̣́ drı̣̃ ꞌá tólâ rãtáã ꞌẽlé ngạ́cı̣̂ ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî õtírĩ nĩî jẽjẽ ró lı̣̃mvû ândrê ꞌdĩ ító ꞌâ lâ ꞌá rî, kạ̃gũmạ́ạ̃ ândrê drí îtõzó rĩꞌá ậsı̣̃lı̣́ õnjí ró. Ĩtí rî, kạ̃gũmạ́ạ̃ ꞌdĩ drí rĩzó lı̣̃mvû ândrê ꞌdĩ drı̣̃ lâ îyálé kãgbã-kãgbã. Lı̣̃mvû rĩ ꞌbá rû îyálé ꞌdĩ drí rĩzó rû sı̣̃lı̣́ kõlóngbõ rú. Drílâ rĩzó kõlóngbõ îyálé õnjí tẽtẽ ró. ");
INSERT INTO avu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Gõꞌdá õtírĩ cãâ ꞌbõlõwá ãwó sĩ rî, Yésũ drí ngãzó rĩꞌá nĩlí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî ngálâ lı̣̃mvû drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî ndrê ĩyî gólâ bê rĩꞌá ânĩꞌá lı̣̃mvû drı̣̃ı̣̂ sĩ rî, ũrı̣̃ drí gãzó gólĩyî rú. Gõꞌdá drílĩyî ngãzó trẽlé tã âtá bê kĩ, “Wúûwú, ꞌdĩî ãvõ líndrí ꞌî rĩ ꞌbá ânĩlí ꞌdĩ!” ");
INSERT INTO avu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yésũ ârî tã gólĩyíkâ âtálé ꞌdĩ bê rî, gõꞌdá kôrô drílâ ngãzó tã âtálé drílĩyî kĩ nĩ rî, “Nĩ ꞌê ũrı̣̃ kô. Nõô mâ Yésũ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Gõꞌdá Pétẽrõ drí gõzó tã-drı̣̃ lôgõlé Yésũ drí kĩ nĩ rî, “Kúmú, õzõ ꞌdĩî ãꞌdô fí pạ̃tı̣́ı̣̃ nî ĩꞌdî rî, ꞌdõvó ní zı̣̂ mâ nĩlí ní ngálâ lı̣̃mvû drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Gõꞌdá Yésũ drí tã âtázó Pétẽrõ drí kĩ nĩ rî, “ꞌDõvó ní ânĩ.” Gõꞌdá Pétẽrõ drí ârízó kõlóngbõ ꞌásĩ nĩlí Yésũ ngálâ lı̣̃mvû drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gõꞌdá Pétẽrõ õtírĩ rĩî nĩlí rî, gólâ drí lı̣̃fı̣́ jãzó võ ndrẽlé gãrã drı̣̃ı̣̂. Ĩtí rî, gólâ ûsû kạ̃gũmạ́ạ̃ rĩ ꞌbá lı̣̃mvû drı̣̃ îyálé ꞌdĩ võ lâ bê rî, kôrô ũrı̣̃ drí gãzó gólâ rú. Gõꞌdá drílâ îtõzó rĩꞌá lêtélé nĩꞌá lı̣̃mvû zẽ ꞌálâ. Gõꞌdá drílâ ngãzó trẽlé kĩ, “Kúmú, ní pâ mâ!” ");
INSERT INTO avu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gõꞌdá kôrô Yésũ drí íyî drı̣́ îjõzó ꞌwãâ Pétẽrõ rî lôkózó âsélé gólâ õzó lêté kô. Gõꞌdá drílâ ngãzó tã âtálé Pétẽrõ drí kĩ, “Tã lẽlẽ áníkâ má ꞌá rî cé fínyáwá ĩtí ãꞌdô tãsĩ yã? Ní rî tã ı̣̂sũlı̣́ rı̣̃ rı̣̃ ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Gõꞌdá Pétẽrõ yî Yésũ bê drí ngãzó ĩyî mbãlé kõlóngbõ ꞌá. Ĩtí rî, gólĩyî fî bê kõlóngbõ ꞌá rî, kôrô kạ̃gũmạ́ạ̃ ꞌdĩ drí âdrézó. ");
INSERT INTO avu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gõꞌdá lãjóꞌbá gólĩyî ndrĩ kõlóngbõ ꞌdî ꞌá ꞌdĩ ꞌbá yî ndrê ĩyî tã gólĩyî rû ꞌẽ ꞌbá ꞌdĩ ꞌbá yî bê rî, drílĩyî ngãzó Yésũ rî ı̣̂njı̣̃lı̣́ úlı̣́ âtâ-âtâ bê kĩ, “Pạ̃tı̣́ı̣̃ nõô rĩꞌá Ôvârí rî mvá ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nĩngá sĩ, Yésũ yî mbã bê lı̣̃mvû ândrê ꞌdĩ drı̣̃ lâ rî, drílĩyî nĩzó cãlé ꞌbạ̃drı̣̃ gólâ zı̣̃lı̣́ Gẽnẽsãrétẽ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gõꞌdá õjílã tólâ nã ꞌbá yî ârî ĩyî tã bê kĩꞌá nĩ rî, Yésũ ãâcâ trá rî, drílĩyî ngãzó tã lâ ꞌbãlé õjílã gólĩyî võ ꞌdî kâ ꞌdĩ ꞌbá yî drí ârílí ndrĩ, gólĩyî ãâjî ró õjílã gólĩyíkâ ngá lãzé bê rî ꞌbá yî Yésũ ngálâ. ");
INSERT INTO avu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gõꞌdá áâjílí bê õjílã gólĩyî ngá lãzé bê ꞌdĩ ꞌbá yî Yésũ ngálâ rî, õjílã gólĩyî õjílã ngá lãzé bê ꞌdĩ ꞌbá yî âjí ꞌbá rî yî drí gõzó rúꞌbạ́ lôꞌbãlé Yésũ rú kĩ, “Ní âyê õjílã ngá lãzé bê ꞌdĩ ꞌbá yî õdõ ĩyî cé ítá tı̣̂ áníkâ ĩꞌdî, ngá lãzé gólĩyíkâ âꞌdô rû ndẽꞌá.” Gõꞌdá Yésũ drí tã gólĩyíkâ ꞌdĩ drı̣̃ lâ lẽzó. Ĩtí rî, gólĩyî ndrĩ ítá tı̣̂ Yésũ kâ dõ ꞌbá rî yî, ngá lãzé gólĩyíkâ drí rû ndẽzó. ");
INSERT INTO avu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Gõꞌdá nĩngá sĩ rî, Pạ̃rúsı̣̃ ãzâ ꞌbá yî gõꞌdá lãꞌbí Yúdạ̃ yí kâ îmbá ꞌbá ãzâ ꞌbá yí bê drí ânĩzó Yẽrõsãlémã lésĩ, ânĩꞌá ícícíyá ꞌẽlé Yésũ rú. Gõꞌdá drílĩyî tã îjízó Yésũ tı̣́ kĩ, ");
INSERT INTO avu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Lãjóꞌbá áníkâ rî ꞌbá yî rí ĩyî kô lãꞌbí ãmâ ạ́ꞌbı̣́yạ́ yí kâ ꞌẽlé ndrĩ ãꞌdô tãsĩ yã? Ní ndrê drẽ, gólĩyî õlẽ trá ngá nyãlé rî, gólĩyî rí kô ĩyî drı̣́ jĩlí lạ́tı̣̂ mbı̣̂ sĩ lãꞌbí ãmákâ rî vó ró.” ");
INSERT INTO avu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, “Tãlâ ãꞌdô ꞌî ãnî drí rĩzó tã ꞌbãꞌbã Ôvârí kâ ꞌẽlé kô tã lãꞌbí ãníkâ rî ꞌbá yí kâ ꞌẽꞌẽ lâ sĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nĩ ndrê drẽ, Ôvârí ꞌbã tã trá kĩ nĩ rî, ‘Ní ı̣̂njı̣̃ ánî átá yî ánî ândré bê. Gõꞌdá õzõ õjílã ãzâ õꞌê ꞌdásí átá lâ rú ngãtá ândré lâ rú yã rî, áâꞌdô õjílã rî ꞌdĩ fũꞌá vólé.’ ");
INSERT INTO avu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Gõꞌdá nĩ rî tã îmbálé kĩ nĩ rî, õzõ õjílã ãzâ ãâꞌdô ngá ãzâ ꞌbá yí bê îcálé fẽlé íyî átá rî pãzó íyî ândré bê gõꞌdá sı̣́sı̣́ gólâ âtâ tã trá ngá ꞌdĩ ꞌbá yî âꞌdô trá fẽlé ngá fẽfẽ ró Ôvârí drí rî, ĩtí rî, îcá gõꞌdá kô gólâ drí ngá rî ꞌdĩ fẽzó íyî átá yî drí íyî ândré bê. Ĩtí rî, lãꞌbí ꞌdĩ ꞌẽꞌẽ lâ sĩ rî, nĩ njı̣̃ lạ́tı̣̂ trá gólâ drí átá lâ rî ı̣̂njı̣̃zó kô ândré lâ bê. Tã ꞌdî tãsĩ rî, nĩ njâ tã ꞌbãꞌbã Ôvârí kâ rî trá ãnî drí gõzó tã lãꞌbí ãnî nyãányâ kâ rî kâ ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ãnî gólĩyî âꞌdó ꞌbá tã ı̣̂sũ bê rı̣̃ nô ꞌbá yî, úlı̣́ gólâ Ôvârí drí âtálé tã ậngũ ꞌbá Ĩsáyã sĩ ãnî tãsĩ rî, rĩꞌá mbı̣̂. ");
INSERT INTO avu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Gólâ kĩ, ‘Õjílã nô ꞌbá yî rî ĩyî ámâ ı̣̂njı̣̃lı̣́ cé ĩyî tı̣̂ sĩ, gõꞌdá gólĩyî lẽé kô tã ámákâ ꞌẽlé ĩyî pı̣̃pı̣̂sı̣́lı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gólĩyî rî ámâ ı̣̂njı̣̃lı̣́ tã ífí ãkó, tãlâ gólĩyî rî lãꞌbí ĩyíkâ õjílã mvá kâ rî îmbálé ĩꞌdî tã ꞌbãꞌbã ámákâ Ôvârí kâ rî võ lâ ꞌá.’ ” ");
INSERT INTO avu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gõꞌdá nĩngá sĩ rî, Yésũ drí õꞌbí gólĩyî rû êꞌbé ꞌbá gólâ lạ̃gạ́tı̣́ rî ꞌbá yî ậzı̣́zó ânĩlí yí ngálâ. Gõꞌdá drílâ tã âtázó gólĩyî drí kĩ, “Nĩ ârî úlı̣́ má drí ꞌẽꞌá âtálâ ãnî drí nõ, gõꞌdá tã lâ õfî ãnî drı̣̃ı̣̂ dódó. ");
INSERT INTO avu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngá gólâ fĩ ꞌbá õjílã sı̣́-ꞌbálé ꞌásĩ rî, rí kô õjílã ꞌbãlé âꞌdólé õnjí ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá. Gõꞌdá ngá gólâ rĩ ꞌbá zãâ lậpı̣̂-lậpı̣̂ ró õjílã pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî, rî nĩ rĩꞌá õjílã ꞌbãlé âꞌdólé õnjí ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nĩngá sĩ, lãjóꞌbá Yésũ kâ rî ꞌbá yî drí rû êsézó ãnyî gólâ lạ̃gạ́tı̣́. Gõꞌdá drílĩyî tã îjízó gólâ tı̣́ kĩ, “Ní nı̣̃ trá kĩꞌá nĩ rî, úlı̣́ ní drí âtálé ꞌdĩ ꞌbá yî ꞌbã Pạ̃rúsı̣̃ yî trá âꞌdólé ạ̃wạ̃ ró ní bê yã?” ");
INSERT INTO avu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî úlı̣́ mãnĩgõ sĩ kĩ, “Ngá-ạ̃rú ndrĩ gólĩyî ámâ átá ûrú ꞌálâ rî drí ı̣̂ꞌdı̣́lı̣́ nĩ kôꞌdáwá rî, áâꞌdô ângíꞌá lâ vólé õmvórẽ lâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nĩ âyê drẽ Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî. Gólĩyî rĩꞌá õzõ õjílã gólĩyî lı̣̃fı̣́ ãkó lé ꞌbá tíbê rĩ ꞌbá ĩyî ãzí-ãzí yî lı̣̃fı̣́ ãkó lé ꞌbá ró rî ꞌbá yî sẽlé rî kâtí. Âꞌdô îcáꞌá fí trá õjílã gólâ lı̣̃fı̣́ ãkó rî drí íyî ãzí-ãzí rî sẽzó yã? Îcá kô. Õzõ gólâ õsê íyî ãzí-ãzí trá rî, gólĩyî kpạ̃rạ̃tı̣́ âꞌdô ꞌdẽꞌá ĩyî ꞌbú ândrê fĩfĩ ró rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Gõꞌdá Pétẽrõ drí gõzó tã âtálé Yésũ drí kĩ nĩ rî, “Ní âꞌdâ drẽ úlı̣́ mãnĩgõ ngá gólâ rĩ ꞌbá õjílã ꞌbãlé âꞌdólé õnjí ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî tãsĩ rî tã ífí lâ ãmâ drí.” ");
INSERT INTO avu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ĩtí rî, Yésũ drí tã lôgõzó âmbâ-âmbâ ró lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Tã nô fí drẽ zãâ ãnî drı̣̃ı̣̂ kô yã? ");
INSERT INTO avu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nĩ nı̣̃ı̣́ kô kĩꞌá nĩ rî, ngá gólâ fĩ ꞌbá õjílã tı̣̂ ꞌásĩ rî, rî íyíkâ nĩlí õjílã ꞌâ ꞌá, gõꞌdá drílâ âfõzó vólé rúꞌbạ́ ꞌásĩ yã? Ngá gólâ õjílã drí nyãlé rî îcá kô gólâ rî îzãlé Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Gõꞌdá ngá gólâ âfõ ꞌbá õjílã tı̣̂ ꞌásĩ rî, ꞌdĩî ngá gólâ âfõ ꞌbá tã ı̣̂sũ gólâkâ ꞌásĩ rî ĩꞌdî. ꞌDĩî ngá gólâ rĩ ꞌbá õjílã îzãlé Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nĩ ndrê drẽ, tã ı̣̂sũ õnjí gólâ rĩ ꞌbá õjílã ãzâ ꞌbãlé õjílã ãzí fũlı̣́, ngãtá gólâ rî ꞌbãlé ậyı̣́lı̣́ ꞌdãzí rî õkó bê ngãtá ꞌdãzí rî ágó bê, ngãtá gólâ rî ꞌbãlé ãvẽ ꞌẽlé, ngãtá gólâ rî ꞌbãlé ngá õjílã ãzí kâ ûgũlı̣́, ngãtá gólâ rî ꞌbãlé õnjõ âdólé õjílã ãzí rú, ngãtá gólâ rî ꞌbãlé úlı̣́ õnjí âtálé õjílã ãzí rú yã rî, tã ı̣̂sũ õnjí ꞌdĩ ꞌbá yî rî âfõlé õjílã rî ꞌdĩ pı̣̃pı̣̂sı̣́lı̣́ lâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ꞌDĩî ngá gólĩyî rĩ ꞌbá õjílã ꞌbãlé âꞌdólé õnjí ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî ꞌbá yî ĩꞌdî. Ĩtí rî, ngá nyãnyã drı̣́ jĩjĩ lạ́tı̣̂ mbı̣̂ ꞌásĩ rî ãkó rî ꞌbãá õjílã kô âꞌdólé õnjí ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ngãzó võ ꞌdî âyélé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê nĩzó ꞌbạ̃drı̣̃ gólâ ãnyî jạ̃rı̣́bạ̃ Tírã kâ Sĩdónã kâ bê rî lạ̃gạ́tı̣́ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Gõꞌdá gólĩyî câ bê tólâ rî, õkó ãzâ õrĩ Kãnánã kâ ꞌásĩ gólâ rĩ ꞌbá ꞌbạ̃drı̣̃ ꞌdî ꞌá rî drí ânĩzó ãwó ngõlé Yésũ drí rúꞌbạ́ lôꞌbã-lôꞌbã sĩ kĩ, “Kúmú Yésũ, Dạ̃wúdı̣̃ rî ózõwá, ní ndrê ámâ ĩzã! Mvá ãnjó ámákâ, gólâ cú rĩꞌá líndrí õnjí bê. Líndrí õnjí ꞌdĩ rî gólâ rî îkpókpólõlé rõô. Ní pâ gólâ!” ");
INSERT INTO avu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gõꞌdá Yésũ lôgõó tã õkó ꞌdĩ kâ ꞌdĩ drı̣̃ lâ kô. Gólâ drí íyîngá rĩzó tı̣́tı̣́. Nĩngá sĩ, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí ânĩzó tã âtálé gólâ drí rúꞌbạ́ lôꞌbã-lôꞌbã sĩ kĩ, “Ní drô õkó lídí ꞌdĩ vólé ãmâ lạ̃gạ́tı̣́ sĩ, gólâ õzó rĩî kô ãmâ îkpókpólõlé ôtrê-ôtrê sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ĩtí rî, Yésũ drí ngãzó tã-drı̣̃ lôgõlé kĩ, “Ôvârí âjô mâ ânĩlí nõngá nõ cé õjílã Yúdạ̃ yí kâ gólĩyî ậvı̣̃ ꞌbá trá õzõ kạ́bı̣̃lı̣́kı̣̃ kâtí rî ꞌbá yî lôndãlé.” ");
INSERT INTO avu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Gõꞌdá õkó ꞌdĩ drí ngãzó ânĩlí Yésũ rî ı̣̂njı̣̃lı̣́. Gõꞌdá drílâ ngãzó tã âtálé kĩ, “Kúmú, ní pâ mâ!” ");
INSERT INTO avu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Gõꞌdá Yésũ drí kpá tã-drı̣̃ lôgõzó gólâ drí úlı̣́ mãnĩgõ sĩ kĩ, “Âꞌdó kô tãndí ró ngá nyãnyã trõzó ꞌdĩyímvá drı̣́gạ́ sĩ fẽlé õké drí nyãlé.” ");
INSERT INTO avu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ĩtí rî, õkó ꞌdĩ drí ngãzó tã âtálé Yésũ drí kĩ nĩ rî, “Ãwô kúmú, ꞌdĩî rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî. Gõꞌdá õké rî ngá ĩdíkõ rĩ ꞌbá lôꞌdélé íyî lı̣́pı̣̂ drı̣́gạ́ sĩ rî ꞌbá yî ûꞌdúlı̣́ ĩꞌdî nyãlé.” ");
INSERT INTO avu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó õkó ꞌdĩ drí kĩ, “Nî rĩꞌá õkó gólâ âꞌdó ꞌbá tã lẽlẽ bê gạ̃rạ̃ má ꞌá rî ĩꞌdî. Tã gólâ ní drí lẽlé rî âꞌdô rû ꞌẽꞌá ní drí.” Gõꞌdá kôrô líndrí õnjí rĩ ꞌbá mvá ãnjó lâ ꞌdĩ îkpókpólõlé ꞌdĩ drí âfõzó vólé. Ĩtí rî, mvá ãnjó gólâkâ ꞌdĩ rúꞌbạ́ lâ drí rû êdézó. ");
INSERT INTO avu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ꞌbạ̃drı̣̃ ꞌdî âyézó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. Drílĩyî ngãzó nĩlí, nĩꞌá cãlé lı̣̃mvû ândrê Gãlĩláyã kâ tı̣́. Gõꞌdá drílĩyî nĩzó zãâ lı̣̃mvû ândrê ꞌdĩ gãrã drı̣̃ lâ ꞌásĩ, nĩꞌá cãlé únı̣́ ãzâ rú. Gõꞌdá drílĩyî mbãzó únı̣́ gãrã drı̣̃ lâ ꞌá rĩlí vũdrı̣́. ");
INSERT INTO avu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nĩngá sĩ, õꞌbí dũû drí ngãzó ĩyî rĩꞌá ânĩlí Yésũ ngálâ. Gólĩyî drí ngá lãzé ꞌbá gólĩyî õŋõ ró ậcı̣́ tõ ꞌbá kô rî ꞌbá yî, gólĩyî lı̣̃fı̣́ ãkó lé ꞌbá ró rî ꞌbá yî, gólĩyî kõrõkpó ró rî ꞌbá yî, gólĩyî úlı̣́ âtá ꞌbá kô rî ꞌbá yî, gõꞌdá gólĩyî ngá lãzé tı̣̂ ngĩíngî bê rî ꞌbá yî âtrõzó âjílí Yésũ ngálâ. Gõꞌdá drílĩyî õjílã gólĩyî ngá lãzé ró ꞌdĩ ꞌbá yî lôꞌbãzó Yésũ ândrá. Gõꞌdá Yésũ drí gólĩyî êdézó ngá lãzé gólĩyíkâ ꞌdĩ ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ĩtí rî, õꞌbí ꞌdĩ ꞌbá yî ndrê ĩyî õjílã gólĩyî úlı̣́ âtá ꞌbá kô rî ꞌbá yî bê trá rĩꞌá úlı̣́ âtáꞌá, gólĩyî kõrõkpó ró rî ꞌbá yî pá lâ yî lôtô rû bê trá âcálé mbı̣̂mbı̣̂, gólĩyî õŋõ ró rî ꞌbá yî gõꞌdá bê trá ậcı̣́ tõꞌá, gólĩyî lı̣̃fı̣́ lâ yî drí võ ndrẽlé kô rî ꞌbá yî bê trá võ ndrẽꞌá dódó rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó ndrúndrú. Ĩtí rî, drílĩyî ngãzó ĩyî rĩꞌá Ôvârí gólâ õjílã Ĩsĩrãꞌélẽ kâ drí rĩꞌá ı̣̂njı̣̃lâ rî lûyı̣́lı̣́ tã gólâ rû ꞌẽ ꞌbá ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gõꞌdá nĩngá sĩ rî, Yésũ drí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî ậzı̣́zó ânĩlí yí ngálâ. Gõꞌdá drílâ tã âtázó drílĩyî kĩ, “Mâ rĩꞌá tã ı̣̂sũ ró õꞌbí nõ ꞌbá yî tãsĩ, tãlâ gólĩyî rî trá má bê nõngá kậyı̣̂ nâ, gõꞌdá ngbãângbânõ rî, gólĩyî trá rĩꞌá ngá ãzâ ãkó nyãlé. Má lẽé kô gólĩyî jõlé nĩꞌá gõlé ĩyî drí ꞌbã ꞌálâ lõfó sĩ, gólĩyî lı̣̃fı̣́ õzó ậnı̣́ kô lạ́tı̣̂ ꞌá lõfó drí sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó gólâ drí kĩ, “Mã âꞌdô ngá nyãnyã ûsúꞌá võ ꞌbã ãkó nõ ꞌá õꞌbí nõ ꞌbá yî îcálé ãꞌdô ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gõꞌdá Yésũ drí tã îjízó gólĩyî tı̣́ kĩ, “Ãnî rĩꞌá ãmbãtã bê nõngá tạ̃sı̣̂ yã?” Drílĩyî tã-drı̣̃ lôgõzó kĩ, “Ãmâ cé rĩꞌá ãmbãtã bê njı̣̂-drı̣̃-lâ-rı̣̃ gõꞌdá kpá ı̣̃ꞌbı̣̂ bê dã.” ");
INSERT INTO avu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nĩngá sĩ, Yésũ drí gõzó tã âtálé õꞌbí ꞌdĩ ꞌbá yî drí kĩ, gólĩyî õrî vũdrı̣́ ı̣̃nyạ́kú drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Gõꞌdá drílâ ãmbãtã njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdî ꞌbá yî trõzó yí drı̣́gạ́ ı̣̃ꞌbı̣̂ dã ꞌdî bê. Drílâ ãwô-ĩtí ꞌẽzó Ôvârí drí ngá ꞌdĩ ꞌbá yî tãsĩ. Gõꞌdá drílâ ꞌâ lâ yî ûpı̣̃zó, gõꞌdá trõzó lâ fẽlé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drı̣́gạ́. Gõꞌdá drílĩyî trõzó lâ lânjílí õꞌbí ꞌdĩ ꞌbá yî drí nyãlé. ");
INSERT INTO avu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ĩtí rî, õꞌbí ꞌdĩ ꞌbá yî ndrĩ drí ngá nyãzó. Ngá nyãnyã drí gólĩyî îcázó. Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí ngá nyãnyã ạ̃mbúkũ lâkí ꞌbá rî ûꞌdúzó êꞌbélé ívõ ꞌásĩ dũûdû njı̣̂-drı̣̃-lâ-rı̣̃. ");
INSERT INTO avu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Õjílã ndrĩ gólĩyî ngá ꞌdĩ nyã ꞌbá rî yî rĩꞌá kútũ-sû. ꞌDĩî ólã cé ãgô ĩꞌdî. Gõꞌdá ólãá õkó ꞌdĩyímvá bê kô. ");
INSERT INTO avu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Gõꞌdá ꞌdĩî vósĩ rî, Yésũ drí õꞌbí ꞌdĩ ꞌbá yî jõzó, nĩꞌá gõlé ĩyî drí ꞌbã ꞌásĩ. Gõꞌdá gólâ jô õꞌbí ꞌdĩ ꞌbá yî bê vólé rî, drílĩyî ngãzó mbãlé kõlóngbõ ꞌá lãjóꞌbá íyíkâ yí bê nĩlí ꞌbạ̃drı̣̃ mvá gólâ zı̣̃lı̣́ Mãgãdánã rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kậyı̣̂ ãzâ sĩ, Pạ̃rúsı̣̃ ãzâ ꞌbá yî gõꞌdá Sạ̃dúsı̣̃ ãzâ ꞌbá yí bê drí ânĩzó ĩyî Yésũ rî ûjũlı̣́. Ĩtí rî, drílĩyî Yésũ rî îjízó kĩ, “Ní ꞌê tã lârâkô tı̣̂ drí ậꞌdı̣́zó rî ꞌbá yî, tã âꞌdálé kĩ, pạ̃tı̣́ı̣̃ Ôvârí âjô nî nĩ ûrú lésĩ.” ");
INSERT INTO avu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî ngá gólĩyî drí rĩꞌá ndrẽlâ rĩ ꞌbá rû âꞌdálé lãmbé sĩ rî ꞌbá yî tãsĩ kĩ, “Õzõ ı̣̃tú õtírĩ ꞌẽê nĩꞌá fĩlí rî, võ lı̣̃fı̣́ õlîkâ trá lîkâ kãâkâ ró rî, nĩ rî tã âtálé kĩ nĩ rî, ı̣̃drú ꞌbũû lı̣̃fı̣́ âꞌdô ꞌbãꞌá ngbángbá. ");
INSERT INTO avu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Õzõ gõꞌdá nĩ õndrê ꞌbũû lı̣̃fı̣́ âꞌdô trá mũkũkũ ró cı̣̃ı̣́nó rî, nĩ rî tã âtálé kĩ nĩ rî, ôzê âbí ꞌẽꞌá ꞌdı̣̃lı̣́. Nĩ rî lãmbé ngá gólĩyî rĩ ꞌbá rû ꞌẽlé ꞌbũû ꞌálâ rî ꞌbá yí kâ ndrẽlé ãnî drí tã ífí lâ âꞌdázó. Gõꞌdá lãmbé kậyı̣̂ nõ ꞌbá yí kâ gólâ âꞌdó ꞌbá tã má drí rĩꞌá ꞌẽlâ rî ró nõ, nĩ îcá kô tã ífí lâ âꞌdálé. ");
INSERT INTO avu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Õjílã kậyı̣̂ nõ ꞌbá yí kâ nõ rĩꞌá õjílã õnjí ꞌî. Gólĩyî ró Ôvârí kô. Gólĩyî rî rĩꞌá ámâ îjílí lãmbé tã lârâkô tı̣̂ drí ậꞌdı̣́zó rî ꞌbá yí kâ ꞌẽlé ĩyî drí ndrẽlé ãꞌdô tãsĩ yã? Tã lârâkô gólâ gólĩyî drí ꞌẽꞌá ndrẽlâ má sĩ rî âꞌdô ꞌbãꞌá cé õzõ tã lârâkô gólâ Ôvârí drí ꞌẽlé tã ậngũ ꞌbá Yónã drí rî kâtí rî ĩꞌdî.” Nĩngá sĩ, Yésũ drí ngãzó gólĩyî âyélé nĩzó vólé. ");
INSERT INTO avu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nĩngá sĩ rî, Yésũ yî drí mbãzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê ꞌáꞌá lé drı̣̃ lı̣̃mvû ândrê ꞌdĩ kâ ãzâ lésĩ rî ꞌá. Gõꞌdá gólĩyî mbã bê lı̣̃mvû ꞌdĩ drı̣̃ lâ rî, lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí võ lâ ûsúzó kĩ, ãmbãtã tã jâ trá ĩyî drı̣̃ı̣̂ sĩ trõlé kpãâ ĩyí bê. ");
INSERT INTO avu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gõꞌdá Yésũ drí lı̣̃fı̣́ lõmbâ fẽzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Ãnî lı̣̃fı̣́ õmbâ ãnî rú ạ̃kú Pạ̃rúsı̣̃ yí kâ Sạ̃dúsı̣̃ yí bê rî tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ gólâkâ ꞌdĩ bê rî, tã ífí lâ fí gólĩyî drı̣̃ı̣̂ dódó kô. Gõꞌdá drílĩyî ngãzó rĩꞌá tã âtálé ĩyî lãfálé ꞌásĩ kĩ, “Yésũ âtâ úlı̣́ ĩtí ꞌdĩ, tãlâ ãmbãtã tã drí jãzó ãmâ drı̣̃ı̣̂ sĩ âtrõlé kpãâ ãmá bê rî drí sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gõꞌdá Yésũ nı̣̃ tã gólĩyî drí rĩꞌá ı̣̂sũlâ ꞌdĩ bê rî, drílâ gõzó tã âtálé kĩ, “Nĩ rî ãmbãtã ãnî drí ꞌẽꞌá nyãlâ rî tã lâ ı̣̂sũlı̣́ ãꞌdô tãsĩ yã? Tã lẽlẽ ãníkâ má ꞌá rî rĩꞌá cé fínyáwá ĩtí ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tã gólâ má drí ngá nyãnyã fẽzó õꞌbí kútũ-njı̣̂ drí nyãlé ãmbãtã njı̣̂ sĩ rî, tã lâ fí ãnî drı̣̃ı̣̂ kô yã? Gõꞌdá ngá nyãnyã ạ̃mbúkũ lâkí ꞌbá ãnî drí ûꞌdúlı̣́ êꞌbélé dũûdû ívõ ꞌásĩ rî tạ̃sı̣̂ yã? Tã ꞌdî âgá ãnî drı̣̃ı̣̂ kô yã? ");
INSERT INTO avu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Gõꞌdá nĩ ı̣̂sũ drẽ tã má drí ngá nyãnyã fẽzó õꞌbí kútũ-sû drí ãmbãtã njı̣̂-drı̣̃-lâ-rı̣̃ sĩ rî tã lâ, ngá nyãnyã ạ̃mbúkũ lâkí ꞌbá rî nĩ ûꞌdû êꞌbélé ívõ ꞌásĩ dũûdû tạ̃sı̣̂ yã? ");
INSERT INTO avu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nĩ rî tã ı̣̂sũlı̣́ kĩꞌá nĩ rî, má rî drı̣́-mbílí sõlé ãnî lı̣̃fı̣́ ngá nyãnyã tãsĩ rî ãꞌdô tãsĩ yã? Má rí kô tã ngá nyãnyã kâ tã lâ âtálé ãnî drí, ãnî lı̣̃fı̣́ õmbâ ãnî rú ạ̃kú Pạ̃rúsı̣̃ yí kâ Sạ̃dúsı̣̃ yí bê rî tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nĩngá sĩ, úlı̣́ Yésũ kâ ꞌdĩ tã ífí lâ drí gõzó fĩlí lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drı̣̃ı̣̂ dódó. Gólĩyî nı̣̃ trá kĩ nĩ rî, Yésũ rí kô lı̣̃fı̣́ lõmbâ fẽlé ĩyî drí ꞌdĩ ạ̃kú gólâ rĩzó ãmbãtã ꞌbẽlé rî tãsĩ. Gólâ rî lı̣̃fı̣́ lõmbâ fẽlé ĩyî drí ꞌdĩ tã îmbâ ányâ Pạ̃rúsı̣̃ yí kâ Sạ̃dúsı̣̃ yí bê gólâ îcá ꞌbá tã ı̣̂sũ õjílã kâ îzãlé rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Gõꞌdá nĩngá sĩ, Yésũ yî drí nĩzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê cãlé võ gólâ ãnyî jạ̃rı̣́bạ̃ zı̣̃lı̣́ Sẽsãréyã Fı̣̃lı̣́pı̣̃ rú rî ꞌálâ. Gõꞌdá gólĩyî câ bê tólâ rî, Yésũ drí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îjízó kĩ, “Mâ gólâ âjólé ûrú lésĩ nô, õjílã ı̣̂sũ ĩyî tã bê ámâ tãsĩ rî, gólĩyî kĩ nĩ rî, mâ ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Õjílã ãzâ ꞌbá yî ı̣̂sũ ĩyíkâ kĩ nĩ rî, ní ãꞌdô Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró gólâ drã ꞌbá trá rî ĩꞌdî. Gõꞌdá õjílã ãzâ ꞌbá yî ı̣̂sũ ĩyíkâ kĩ nĩ rî, ní ãꞌdô tã ậngũ ꞌbá Ẽlíyã gólâ âꞌdó ꞌbá bê ạ̃kû ró gõꞌdá ꞌẽ ꞌbá âgõlé ãngó nõ ꞌá rî ĩꞌdî. Gõꞌdá ãzâ ꞌbá yî ı̣̂sũ ĩyíkâ kĩ nĩ rî, ní ãꞌdô tã ậngũ ꞌbá Yẽrẽmíyã âꞌdó ꞌbá kpá bê ạ̃kû ró rî ĩꞌdî. Gõꞌdá ãzâ ꞌbá yî ı̣̂sũ ĩyíkâ tã kĩ nĩ rî, ngãtá ní ãꞌdô ꞌbãꞌá ãlô tã ậngũ ꞌbá ãzí yî lãfálé sĩ rî ĩꞌdî yã rî.” ");
INSERT INTO avu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nĩngá sĩ, Yésũ drí gõzó tã îjílí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî tı̣́ kĩ nĩ rî, “Ãnî nyãányâ nĩ ı̣̂sũ ãníkâ bê rî, mâ ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Gõꞌdá Sĩmónã Pétẽrõ drí ngãzó tã-drı̣̃ lôgõlé kĩ, “Nî rĩꞌá ꞌdíyî pã ꞌbá gólâ âjólé ûrú lésĩ rî ĩꞌdî, nî Ôvârí gólâ lédrẽ-lédrẽ ró rî mvá lâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ĩtí rî, Yésũ drí tã-drı̣̃ lôgõzó Pétẽrõ drí kĩ nĩ rî, “Sĩmónã Yónã rî mvá, Ôvârí fẽ õrẽ tã nı̣̃nı̣̃ kâ trá ní drí. Úlı̣́ ꞌdĩ ámâ átá gólâ ûrú ꞌálâ rî âꞌdâ nĩ ní drí.” ");
INSERT INTO avu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gõꞌdá Yésũ drí tã âtázó Pétẽrõ drí tã ꞌbãꞌbã ró kĩ nĩ rî, “Nî Pétẽrõ, má âtâ tã ní drí, nî rĩꞌá õzõ kúnı̣́ kâtí. Má âꞌdô kạ̃nı̣́sạ̃ ámákâ ꞌdı̣̃ꞌá kúnı̣́ nõ drı̣̃ı̣̂. Gõꞌdá mbârâkã õdrã kâ îcá kô kạ̃nı̣́sạ̃ ꞌdî pẽlé. ");
INSERT INTO avu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tã ꞌdî tãsĩ rî, má âꞌdô drı̣́-ãcê võ ûrú ꞌálâ rî kâ fẽꞌá ní drí. Õzõ ní õlôgâ tã ãzâ trá dó âꞌdólé ı̣̃nyạ́kú drı̣̃ı̣̂ nõngá rî, ꞌdĩî rî tã âꞌdálé kĩ, Ôvârí lôgâ tã ꞌdî kpá trá dó ûrú ꞌálâ. Gõꞌdá õzõ ní õlẽ tã-drı̣̃ trá tã drí rû ꞌẽzó ı̣̃nyạ́kú drı̣̃ı̣̂ nõngá rî, ꞌdĩî rî tã âꞌdálé kĩ, Ôvârí lẽ tã ꞌdî kpá trá drílâ rû ꞌẽzó ûrú ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nĩngá sĩ, Yésũ drí ngãzó drı̣́-mbílí sõlé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî lı̣̃fı̣́ kĩ nĩ rî, gólĩyî ãâꞌdâ ĩyî tã kô õjílã ãzãkã drí kĩ, yí âꞌdô ꞌdíyî pã ꞌbá gólâ Ôvârí drí âjólé ûrú lésĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gõꞌdá tã ꞌdî ꞌbá yî vósĩ rî, Yésũ drí îtõzó tã gólĩyî ꞌẽ ꞌbá rû ꞌẽlé yí drí rî ngĩlí ngbálí-ngbálí lãjóꞌbá íyíkâ rî ꞌbá yî drí. Gólâ kĩ, “Îcâ trá má drí nĩzó Yẽrõsãlémã ꞌálâ. Tólâ má âꞌdô lâŋõ ûsúꞌá rõô drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yî drı̣́gạ́ sĩ, gõꞌdá kpá gólĩyî lãꞌbí îmbá ꞌbá ró rî ꞌbá yí bê. Áâꞌdô ámâ fũꞌá. Gõꞌdá kậyı̣̂ nâ sĩ, má âꞌdô lîdríꞌá õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Gõꞌdá Pétẽrõ ârî úlı̣́ Yésũ drí âtálé ꞌdĩ bê rî, drílâ Yésũ rî drı̣́ rũzó sẽlé gbíyá gãrã drı̣̃ı̣̂ ãzí-ãzí lâ yî rú sĩ. Gõꞌdá drílâ tã lôgõzó Yésũ drı̣̃ı̣̂ kĩ nĩ rî, “Kúmú, tã ꞌdî ꞌbá yî õꞌé rû kô ní drí, Ôvârí õpâ nî tã ꞌdî ꞌbá yî ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gõꞌdá Yésũ drí rû jãzó tã âtálé Pétẽrõ drí âmbâ-âmbâ ró kĩ, “Pétẽrõ, ní âyê mâ tã ı̣̂sũ áníkâ Sãtánã kâ ꞌdĩ ꞌásĩ. Lạ́tı̣̂ Ôvârí drí ꞌbãlé trá má drí rî, ní lẽ âꞌbãlâ ãꞌdô tãsĩ yã? Tã ı̣̂sũ áníkâ ꞌdĩ rĩꞌá tã ı̣̂sũ ánî nyãányâ kâ ꞌî, ꞌdĩî âꞌdó kô tã ı̣̂sũ tãndí Ôvârí kâ rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Nĩ ârî drẽ, õzõ õjílã ãzâ õlẽ trá ꞌdẽlé má vósĩ tã ârí ꞌbá ámákâ ró rî, gólâ ãâyê tã gólâ drí lẽlé íyî nyãányâ drí rî ꞌbá yî, gõꞌdá gólâ ãꞌdô njãâ fê lậlı̣̂-lậlı̣̂ íyíkâ njı̣̃lı̣́, ânĩzó ꞌdẽlé má vósĩ tã ârí ꞌbá ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nĩ ndrê drẽ, õzõ õjílã ãzâ õlẽ trá íyî nyãányâ pãlé õdrã ꞌásĩ ámâ gãgã dó rî sĩ rî, gólâ îcá kô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúlı̣́. Gõꞌdá õjílã gólâ íyî nyãányâ fẽ ꞌbá rû îzãlé gõꞌdá kpá drãlé ámâ tãsĩ rî, gólâ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá. ");
INSERT INTO avu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Âꞌdô âꞌdóꞌá ángô tí õzõ õjílã ãꞌdô cú ngá-drı̣̃ ãmbá ãngó nõ ꞌá nõ bê ndrĩ rî, gõꞌdá õzõ gólâ ı̣̃ı̣̂vı̣̃ lạ́tı̣̂ lédrẽ-lédrẽ ạ̃dũkũ ãkó rî kâ trá rî yã? Ĩtí rî, gólâ âꞌdô îcáꞌá ngá ãzâ gĩlí lédrẽ-lédrẽ ạ̃dũkũ ãkó rî võ lâ lôgõzó yã? ");
INSERT INTO avu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tã ꞌdî tãsĩ rî, mâ gólâ âjólé ûrú lésĩ nô âꞌdô ꞌẽꞌá âgõlé kpá óꞌdí mbârâkã ámâ átá kâ bê gõꞌdá kpá mãlãyíkã ámákâ yí bê. Gõꞌdá má âꞌdô ꞌẽꞌá tã-vó õjílã ndrĩ kâ kĩlí âꞌdô tã gólĩyî drí ꞌẽlé rî vó ró. ");
INSERT INTO avu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Má âtâ ãnî drí nõ tã pạ̃tı̣́ı̣̃ ró, ãnî gólĩyî âꞌdó ꞌbá ngbãângbânõ nõngá nõ ꞌbá yî lãfálé sĩ rî, õjílã ãzâ ꞌbá yî îcá kô drãlé cãlé bũúũ kậyı̣̂ gólĩyî drí ꞌẽzó ámâ ndrẽlé âgõrẽ ꞌá rĩlí kúmú ạ́ngı̣́ ró ãngó nõ drı̣̃lı̣́ rî tú.” ");
INSERT INTO avu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gõꞌdá kậyı̣̂ njı̣̂-kázíyá vósĩ rî, Yésũ drí Yãkóbã yî drı̣̃zó ậdrúpı̣̃ lâ Yõwánĩ bê, gõꞌdá kpá Pétẽrõ bê nĩzó mbãlé únı̣́ ãzâ drı̣̃ lâ ꞌá rĩlí cé gólĩyí bê ĩyî drı̣̃ı̣̂ sĩ tólâ. ");
INSERT INTO avu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gõꞌdá Yésũ õtírĩ ꞌbãâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê únı̣́ ꞌdĩ drı̣̃ ꞌá tólâ rî, nyĩî ró, Yésũ rî lârâkô drí rû jãzó âꞌdólé lậgû-lậgû ró, nı̣̃lı̣́ lâ drí gõzó lậgúlı̣́ kạ̃ꞌdậ-kạ̃ꞌdậ õzõ ı̣̃tú kâtí. Gõꞌdá ítá gólâkâ drí rû jãzó kpá âꞌdólé lậgû-lậgû ró rõô õzõ ngá îꞌĩ kâtí. ");
INSERT INTO avu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Gõꞌdá nyĩî ró, Músạ̃ yî drí âgázó Ẽlíyã bê gólĩyî ândrá, rĩꞌá ĩyî úlı̣́ âtálé Yésũ bê. ");
INSERT INTO avu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nĩngá sĩ, Pétẽrõ drí ngãzó tã âtálé Yésũ drí kĩ nĩ rî, “Kúmú, rĩꞌá tã tãndí ꞌî ãmâ drí âꞌdózó ãní bê nõngá. Õzõ ní õlẽ rî, má âꞌdô gũgũ gãꞌá nõngá nâ, ãlô ní drí, ãlô Músạ̃ drí, gõꞌdá ãlô Ẽlíyã drí.” ");
INSERT INTO avu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Gõꞌdá Pétẽrõ õtírĩ ꞌbãâ drẽ zãâ rĩꞌá úlı̣́ âtáꞌá rî, ꞌwãâ ró, mbãrãsãsã mvẽêmvê drí ânĩzó ûrú lésĩ ânĩꞌá gólĩyî rúꞌbạ́ lîmólé. Gõꞌdá gbórókõ drí ậꞌúzó úlı̣́ âtâ-âtâ bê mbãrãsãsã ꞌdî ꞌásĩ kĩ, “Nõô ámâ mvá gólâ má drí lẽlé rõô rî ĩꞌdî. Nĩ ârî tã gólâkâ.” ");
INSERT INTO avu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ĩtí rî, lãjóꞌbá Yésũ kâ nâ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ ꞌdĩ bê rî, gólĩyî drí âꞌdózó ũrı̣̃ ró, gõꞌdá drílĩyî ngãzó ꞌdẽlé ĩyî lı̣̃fı̣́ âkólé vũdrı̣́ ı̣̃nyạ́kú drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Gõꞌdá Yésũ drí ânĩzó drı̣́ dõlé gólĩyî rú, gõꞌdá drílâ ngãzó tã âtálé gólĩyî drí kĩ nĩ rî, “Nĩ ꞌê ũrı̣̃ kôꞌdáwá. Nĩ ngâ ûrû!” ");
INSERT INTO avu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Gõꞌdá gólĩyî õtírĩ ĩyî drı̣̃ îngá võ ndrẽlé rî, gólĩyî ndrê gbõ cé Yésũ ĩꞌdî élê. ");
INSERT INTO avu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nĩngá sĩ rî, Yésũ yî õtírĩ ꞌbãâ âríꞌá únı̣́ drı̣̃ lésĩ rî, gólâ drí ngãzó tã âtálé ngbálí-ngbálí lãjóꞌbá íyíkâ nâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Tã lârâkô gólâ ãnî drí ndrẽlé ꞌdĩ, nĩ âtâ tã lâ kô õjílã ãzãkã drí ãlôwálâ cãlé bũúũ kậyı̣̂ gólâ mâ gólâ âjólé ûrú lésĩ rî drí ꞌẽzó lîdrílí õdrã ꞌásĩ rî tú.” ");
INSERT INTO avu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí gólâ rî îjízó kĩ, “Tãlâ ãꞌdô ꞌî lãꞌbí îmbá ꞌbá rî ꞌbá yî drí tã âtázó kĩ nĩ rî, rĩꞌá îcâ-îcâ ró Ẽlíyã drí âgõzó zãlô sı̣́sı̣́ ãngó ꞌá nõngá ꞌdíyî pã ꞌbá drí gõzó âcálé yã?” ");
INSERT INTO avu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó kĩ nĩ rî, “Úlı̣́ gólĩyî drí âtálé ꞌdĩ rĩꞌá tã mbı̣̂ ꞌî. Rĩꞌá îcâ-îcâ ró Ẽlíyã drí âcázó sı̣́sı̣́ lạ́tı̣̂ êdélé njãâ ꞌdíyî pã ꞌbá drí ânĩzó ꞌálâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gõꞌdá má âtá ãnî drí kĩ, Ẽlíyã âcâ trá nõngá. Gõꞌdá drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî nı̣̃ı̣́ ĩyî gólâ kô. Gõꞌdá gólĩyî lôꞌê gólâ rî lârâkô trá õnjí ró, õzõ gólĩyî drí lẽlé rî kâtí. Gõꞌdá kpá rĩꞌá ĩtí, mâ gólâ âjólé ûrú lésĩ rî, gólĩyî âꞌdô ꞌẽꞌá lâŋõ fẽlé má drí rõô.” ");
INSERT INTO avu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ĩtí rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ Yésũ drí âtálé ꞌdĩ bê rî, úlı̣́ Ẽlíyã rî tãsĩ ꞌdî tã ífí lâ drí gõzó fĩlí gólĩyî drı̣̃ı̣̂ dódó. Gõꞌdá gólĩyî drí nı̣̃zó lâ kĩ, Yésũ õrî ꞌdĩ tã Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî kâ tã lâ âtálé ĩꞌdî ĩyî drí ꞌdĩ. ");
INSERT INTO avu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Gõꞌdá Yésũ yî âcâ ĩyî bê únı̣̃ ꞌdî pálé lâ ꞌá lãjóꞌbá íyíkâ nâ ꞌdĩ ꞌbá yí bê rî, gólĩyî drí õꞌbí dũû ûsúzó, rĩꞌá ĩyî gólĩyî tẽꞌá. Nĩngá sĩ, ãgô ãzâ drí ânĩzó nĩꞌá ꞌãꞌî tı̣̃lı̣́ Yésũ ândrá. ");
INSERT INTO avu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Gõꞌdá gólâ drí ngãzó tã âtálé Yésũ drí kĩ, “Kúmú, ámâ mvá ãgô ró rî rĩꞌá cú líndrí õnjí tíbê rĩ ꞌbá gólâ rî ꞌẽlé õnjí ró rî bê. Líndrí õnjí ꞌdĩ rî gólâ rî âsélé âsê. Kậyı̣̂ ãzâ ꞌbá yî sĩ rî, líndrí õnjí ꞌdĩ rî gólâ rî vũlı̣́ lạ̃sı̣́ ꞌá, gõꞌdá kậyı̣̂ ãzâ ꞌbá yî sĩ rî, rî gólâ rî vũlı̣́ lı̣̃mvû ꞌá. Ní ndrê gólâ rî ĩzã! Ní pâ gólâ! ");
INSERT INTO avu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Má âjî gólâ bê lãjóꞌbá áníkâ rî ꞌbá yî ngálâ rî, gõꞌdá gólĩyî îcá kô gólâ rî êdélé.” ");
INSERT INTO avu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Gõꞌdá Yésũ ârî úlı̣́ ãgô ꞌdĩ drí âtálé ꞌdĩ bê rî, drílâ ngãzó tã âtálé kĩ, “Ãnî õjílã kậyı̣̂ nõ ꞌbá yí kâ nõ, ãnî rĩꞌá tã lẽlẽ ãkó Ôvârí ꞌá. Tã ı̣̂sũ ãníkâ rĩꞌá ányâ ró. Má âꞌdô ꞌẽꞌá rĩlí ãní bê ĩtí ꞌdĩ bũúũ ángô tú yã? Má âꞌdô fĩî ậtũꞌá rĩzó ãní bê ĩtí ꞌdĩ bũúũ ángô tú yã? Áâjî mvá líndrí õnjí bê ꞌdĩ má ngáá nõlé.” ");
INSERT INTO avu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Gõꞌdá áâjî mvá ꞌdĩ bê Yésũ ngálâ rî, gólâ drí tã ꞌbãzó drı̣́-ãcê sĩ líndrí õnjí ꞌdĩ drí kĩ, “Ní âfõ!” Gõꞌdá kôrô líndrí õnjí ꞌdĩ drí âfõzó vólé. Ĩtí rî, kôrô mvá ꞌdĩ drí rû êdézó ı̣̃tú-pá ãlô-ãlô ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Gõꞌdá tã rî ꞌdĩ vósĩ rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí ngãzó nĩꞌá Yésũ rî îjílí gólĩyî drí ꞌbãrẽ ĩyî drı̣̃ı̣̂ sĩ rî ꞌá. Gólĩyî kĩ, “Mã îcá kô líndrí õnjí ꞌdĩ drõlé ágámvá ꞌdĩ ꞌásĩ ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, “Nĩ îcá kô líndrí õnjí ꞌdĩ drõlé, tãlâ tã lẽlẽ ãníkâ Ôvârí ꞌá rî rĩꞌá cé fínyáwá ĩtí. Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, tí nĩ õró ꞌbãâ tã lẽlẽ bê Ôvârí ꞌá cé fínyáwá õzõ ạ́nú ífí rî kâtí rî, nĩ âꞌdô îcáꞌá cú tã âtálé únı̣́ nõ drí kĩ, gólâ ẽêsê rû võ íyíkâ ꞌdĩ ꞌásĩ rî, únı̣́ ꞌdĩ âꞌdô rû êséꞌá. Ngá ãzâ îcá kô ãnî ndẽlé.” ");
INSERT INTO avu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Gõꞌdá Yésũ drí tã âtázó kĩ, “Líndrí õnjí lârâkô bê ĩtí ꞌdĩ îcá kô âfõlé, õzõ nĩ õꞌbĩ tı̣̂ kô rĩzó rãtáã ꞌẽlé Ôvârí drí tã lâ tãsĩ rî.”) ");
INSERT INTO avu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yésũ yî âgõ bê lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê âcálé ꞌbạ̃drı̣̃ Gãlĩláyã kâ ꞌá rî, kậyı̣̂ ãzâ sĩ, gólâ drí ngãzó tã âtálé gólĩyî drí kĩ, “Áâꞌdô trá ꞌẽꞌá mâ gólâ âjólé ûrú lésĩ rî drı̣́-bã lâ fẽlé õjílã drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ĩtí rî, áâꞌdô ámâ fũꞌá. Gõꞌdá kpálé ĩtí rî, kậyı̣̂ nâ sĩ, má âꞌdô lîdríꞌá õdrã ꞌásĩ.” Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ gólâ drí âtálé ꞌdĩ bê rî, gólĩyî drí gõzó âꞌdólé ĩzã ró rõô. ");
INSERT INTO avu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gõꞌdá nĩngá sĩ, Yésũ yî drí nĩzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê cãlé jạ̃rı̣́bạ̃ Kãpẽrãnómã kâ rî ꞌálâ. Tólâ rî, bélé-bélé ûꞌdú ꞌbá gólĩyî rĩ ꞌbá bélé-bélé ûꞌdúlı̣́ jó ạ́ngı̣́ Ôvârí kâ ꞌá rî ãzâ ꞌbá yî drí ânĩzó ĩyî Pétẽrõ rî îjílí kĩ, “Tã îmbá ꞌbá ãníkâ, Yésũ rî bê bélé-bélé rĩꞌá fẽlâ jó ạ́ngı̣́ Ôvârí kâ ꞌá rî fẽlé yã?” ");
INSERT INTO avu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Gõꞌdá Pétẽrõ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ nĩ rî, “Ãwô, gólâ rî bê fẽlâ.” Nĩngá sĩ, Pétẽrõ drí ngãzó gõlé ꞌbã ꞌálâ, nĩꞌá tã ꞌdî âtálé Yésũ drí. Drẽ ãkpãkãꞌdã Pétẽrõ îtõó drẽ tã ꞌdî ngĩlí sı̣́sı̣́ Yésũ drí kô rî, kôrô Yésũ drí Pétẽrõ rî îjízó kĩ, “Sĩmónã, ní âꞌdâ drẽ tã ı̣̂sũ áníkâ tã bélé-bélé fẽ kâ tãsĩ rî má drí. Tã ı̣̂sũ áníkâ ꞌá rî, õzõ kúmú ꞌbạ̃drı̣̃ kâ rî ꞌbá yî õlẽ trá bélé-bélé ûꞌdúlı̣́ rî, gólĩyî rî ûꞌdúlâ ãꞌdî yî drı̣́gạ́ sĩ yã? Gólĩyî rî ûꞌdúlâ ãkpã mvá ĩyíkâ rî ꞌbá yî drı̣́gạ́ sĩ ngãtá õjílã ãzâ ꞌbá yî drı̣́gạ́ sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Gõꞌdá Pétẽrõ drí tã-drı̣̃ lôgõzó kĩ nĩ rî, “Õjílã ãzâ ꞌbá yî rî ĩyî nĩ fẽlâ.” Gõꞌdá Yésũ drí tã âtázó kĩ, “ꞌDĩî rĩꞌá mbı̣̂. Ĩtí rî, îcá kô mvá kúmú ꞌdĩ ꞌbá yí kâ drí bélé-bélé fẽzó. ");
INSERT INTO avu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gõꞌdá ĩtí rî, mã ꞌbã bélé-bélé ûꞌdú ꞌbá ꞌdĩ ꞌbá yî kô âꞌdólé ạ̃wạ̃ ró ãmá bê. Ní ngâ nĩlí ı̣̃ꞌbı̣̂ ꞌbẽlé lı̣̃mvû ândrê ꞌálâ. Õzõ ní ãâsê ı̣̃ꞌbı̣̂ drı̣̃-káká trá rî, ní njı̣̃ ı̣̃ꞌbı̣̂ rî ꞌdĩ sı̣́-ꞌbálé lâ. Ní âꞌdô ậdı̣̂ ûsúꞌá sı̣́-ꞌbálé lâ ꞌdĩ ꞌá, gõꞌdá ní trõ ró ậdı̣̂ rî ꞌdĩ nĩꞌá fẽlâ bélé-bélé ûꞌdú ꞌbá ꞌdĩ ꞌbá yî drí ãmâ ômbê gĩzó ní bê.” Gõꞌdá Pétẽrõ drí tã ꞌdî ꞌẽzó té õzõ Yésũ drí âtálé ꞌdĩ kâtí. Ĩtí rî, drílâ ậdı̣̂ ûsúzó, drílâ nĩzó âjílâ bélé-bélé ûꞌdú ꞌbá ꞌdĩ ꞌbá yî drí ĩyî ômbê gĩzó Yésũ bê. ");
INSERT INTO avu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Gõꞌdá nĩngá sĩ rî, lãjóꞌbá Yésũ kâ rî ꞌbá yî drí ânĩzó ĩyî tã îjílí gólâ tı̣́ kĩ nĩ rî, “Õjílã gólĩyî rĩ ꞌbá kũmũ Ôvârí kâ zẽlé rî ꞌbá yî lãfálé sĩ rî, õjílã gólâ ãmbã gólâkâ drí lậvũlı̣́ gạ̃rạ̃ ãzí-ãzí drı̣̃ı̣̂ sĩ rî íyíkâ ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Gõꞌdá Yésũ ârî bê tã îjî lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí kâ ꞌdĩ rî, gólâ drí mvá fínyáwá ãzâ ậzı̣́zó ꞌbãlé âdrélé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî ândrá. ");
INSERT INTO avu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Gõꞌdá Yésũ drí gõzó tã âtálé drílĩyî kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ nĩ õlôgõ ãnî nyãányâ kô âꞌdólé õzõ mvá fínyáwá nõ kâtí rî, nĩ îcá kô cãlé ãngó Ôvârí kâ võ ûrú ꞌálâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tã ꞌdî tãsĩ rî, õjílã gólâ ãmbã lâ drí âꞌdólé gạ̃rạ̃ õjílã rĩ ꞌbá kũmũ Ôvârí kâ zẽlé rî ꞌbá yî lãfálé sĩ rî, rĩꞌá õjílã gólâ tíbê íyî nyãányâ lôgõ ꞌbá áyábálá ró õzõ mvá fínyáwá nõ kâtí rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gõꞌdá õzõ õjílã ãzâ õlậgû gbõ cé mvá fínyáwá nõtí nõ ĩꞌdî tã lẽlẽ gólâkâ má ꞌá rî tãsĩ rî, õjílã rî ꞌdĩ lậgû kpá mâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gõꞌdá Yésũ drí kpá tã âtázó tã õjílã ãzí âdô-âdô kâ tãsĩ. Gólâ kĩ, “Õzõ õjílã ãzâ ãâdô õjílã gólĩyî âꞌdó ꞌbá tã lẽlẽ bê õzõ ꞌdĩyímvá fínyáwá kâtí rî trá, ãꞌdô ró bê drílĩyî tã lẽlẽ ĩyíkâ má ꞌá rî âyézó rî, lâŋõ gólâ Ôvârí drí ꞌẽꞌá fẽlâ õjílã rî ꞌdĩ drí rî âꞌdô ꞌẽꞌá ꞌbãlé õnjí tẽtẽ ró lậvũlı̣́ gạ̃rạ̃ lâŋõ õjílã gólâ kúnı̣́ úngû kũlũtũtũ rî ômbézó ômbê lâ ꞌá trõlé vũlı̣́ gạ́lı̣́ ꞌá drãlé vólé rî kâ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gõꞌdá kpá ĩtí, lâŋõ bê rĩꞌá ãmbá õjílã ãngó nõ kâ rî ꞌbá yî drí, tãlâ ngá gólĩyî rĩ ꞌbá õjílã âdólé tã õnjí ꞌẽlé rî ꞌbá yî bê dũû. Ngá ꞌdĩ ꞌbá yî âꞌdô rĩꞌá rû ꞌẽlé zãâ ĩtí. Gõꞌdá gólĩyî rĩ ꞌbá õjílã ãzí âdólé ꞌdĩ ꞌbá yî, lâŋõ gólâ Ôvârí drí ꞌẽꞌá fẽlâ gólĩyî drí rî âꞌdô ꞌẽꞌá ꞌbãlé õnjí tẽtẽ ró. ");
INSERT INTO avu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Gõꞌdá nî ãzâ õzõ ánî drı̣́ ngãtá ánî pá õrî nĩ ánî ꞌbãlé tã õnjí ꞌẽlé rî, ní gâ ánî drı̣́ rî ꞌdĩ njíyá vólé ngãtá ánî pá ꞌdĩ vólé. Rĩꞌá tãndí ró ní drí cãzó võ ûrú ꞌálâ rî ꞌá cé drı̣́ bê ãlô ngãtá pá bê ãlô, ní drí cãzó drı̣́ bê rı̣̃ ngãtá pá bê rı̣̃, nĩꞌá vẽlé lạ̃sı̣́ gólâ Ôvârí drí êdélé Sãtánã yî drí rî ꞌá rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Gõꞌdá õzõ ánî lı̣̃fı̣́ õꞌbã nî nĩ tã õnjí ꞌẽlé rî, ní ângî gólâ vólé. Rĩꞌá tãndí ró ní drí cãzó ûrú ꞌálâ võ lédrẽ-lédrẽ ạ̃dũkũ ãkó rî kâ ꞌá cé lı̣̃fı̣́ bê ãlô, ní drí cãzó lı̣̃fı̣́ bê rı̣̃, nĩꞌá vẽlé lạ̃sı̣́ gólâ Ôvârí drí êdélé Sãtánã yî drí rî ꞌá rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó lãjóꞌbá íyíkâ rî ꞌbá yî drí kĩ nĩ rî, “Nĩ ndrê õjílã gólĩyî rĩ ꞌbá ꞌdẽlé má vósĩ õzõ ꞌdĩyímvá kâtí rî ꞌbá yî kô õzõ ngá tãkó kâtí. Má âtâ ãnî drí, tã lâ yî lâzê rõô Ôvârí rú. Ĩtí rî, mãlãyíkã gólĩyî rĩ ꞌbá gólĩyî vó ndrẽlé rî ꞌbá yî bê ámâ átá ûrú ꞌálâ rî ândrá gólĩyî tã âꞌdálé gólâ drí. ");
INSERT INTO avu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Nĩ ndrê drẽ, mâ rî gógó ânĩ ꞌbá ûrú lésĩ nô, Ôvârí âjô mâ ãngó nõ ꞌá nõ õjílã gólĩyî ậvı̣̃ ꞌbá trá rî ꞌbá yî lôndãlé, tãlâ má pâ ró gólĩyî bê.) ");
INSERT INTO avu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ꞌDõvó nĩ ı̣̂sũ drẽ tã kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá kâ. Õzõ gólâ ãꞌdô kạ́bı̣̃lı̣́kı̣̃ íyíkâ bê nyâꞌdî-njı̣̂ rî, gõꞌdá õzõ kạ́bı̣̃lı̣́kı̣̃ ãlô kạ́bı̣̃lı̣́kı̣̃ gólâkâ ꞌdĩ ꞌbá yî lãfálé ꞌásĩ ạ̃ậvı̣̃ trá rî, gólâ âꞌdô ãꞌdô ꞌẽꞌá ĩꞌdî yã? Gólâ âꞌdô kạ́bı̣̃lı̣́kı̣̃ lâkí ꞌbá nyâꞌdî-sû-drı̣̃-lâ-gâ-mûdrı̣́-drı̣̃-lâ-gâ-njı̣̂-drı̣̃-lâ-sû ꞌdĩ ꞌbá yî âyéꞌá ngá nyãrẽ ꞌá lũtú pálé nĩngá, gõzó nĩlí gólâ ãlô ậvı̣̃ ꞌbá trá rî lôndãlé. ");
INSERT INTO avu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ gólâ ũûsû kạ́bı̣̃lı̣́kı̣̃ íyíkâ ãlô ậvı̣̃ ꞌbá ꞌdĩ trá rî, gólâ âꞌdô ꞌbãꞌá ãyĩkõ ró rõô lậvũlı̣́ gạ̃rạ̃ ãyĩkõ gólâ drí âꞌdózó ĩꞌdí bê lâ kạ́bı̣̃lı̣́kı̣̃ gólâkâ nyâꞌdî-sû-drı̣̃-lâ-gâ-mûdrı̣́-drı̣̃-lâ-gâ-njı̣̂-drı̣̃-lâ-sû ậvı̣̃ ꞌbá kô ꞌdĩ ꞌbá yî tãsĩ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gõꞌdá kpá rĩꞌá ĩtí, ãnî átá ûrú ꞌálâ rî lẽé õjílã gólĩyî rĩ ꞌbá ꞌdẽlé má vósĩ õzõ ꞌdĩyímvá õnyíkõ kâtí nõ ꞌbá yî ãlô rî drí ậvı̣̃lı̣́ kôꞌdáwá lạ́tı̣̂ íyíkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gõꞌdá Yésũ drí kpá tã îmbázó lãjóꞌbá íyíkâ rî ꞌbá yî drí kĩ nĩ rî, “Nî ãzâ, õzõ tã lẽ ꞌbá ãzí ãzâ õꞌê tã õnjí trá ní drí rî, ní nĩ gólâ ngálâ nĩꞌá tã õnjí gólâkâ ꞌdĩ âꞌdálé gólâ drí. Nĩ ꞌê tã rî ꞌdĩ cé rı̣̃ ãnî lãfálé ꞌásĩ gólâ bê. Õzõ gólâ ãârî tã áníkâ trá rî, ní pâ gólâ trá tã õnjí gólâkâ ꞌdĩ âyélé. ");
INSERT INTO avu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Gõꞌdá õzõ õjílã rî ꞌdĩ õgâ vólé trá dó tã áníkâ ârílí rî, ní drı̣̃ õjílã ãzâ ãlô ngãtá rı̣̃ yã rî nĩzó kpá óꞌdí õjílã ꞌdî ngálâ, tãlâ áãâtâ ró tã ꞌdî bê õjílã ꞌdî ꞌbá yî lı̣̃fı̣́ drı̣̃ lâ ꞌá, tãlâ tã ndrĩ ãnî drí âtálé gólâ bê rî, õjílã ꞌdî ꞌbá yî ãârî ró ĩyî bê dódó. ");
INSERT INTO avu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Gõꞌdá õzõ õjílã rî ꞌdĩ õgâ vólé kpá trá dó tã õjílã ꞌdî ꞌbá yí kâ ârílí rî, nĩ âtâ tã lâ õjílã kạ̃nı̣́sạ̃ kâ drí. Gõꞌdá õzõ gólâ õgâ vólé kpá trá dó tã õjílã kạ̃nı̣́sạ̃ kâ kâ ârílí rî, nĩ ꞌê gólâ õzõ õjílã tã lẽ ꞌbá Ôvârí ꞌá kô rî kâtí, gõꞌdá kpá tã õnjí ꞌbá ró õzõ bélé-bélé ûꞌdú ꞌbá gólĩyî rĩ ꞌbá ậdı̣̂ nyãlé rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ nĩ õgã tã ãzâ trá dó rû ꞌẽlé ãngó nõ ꞌá nõngá rî, ꞌdĩî kpá tã gólâ Ôvârí drí gãlé trá dó rû ꞌẽlé ûrú ꞌálâ rî ĩꞌdî. Gõꞌdá õzõ nĩ ãâyê tã ãzâ trá rû ꞌẽlé ãngó nõ ꞌá nõngá rî, ꞌdĩî kpá tã gólâ Ôvârí drí âyélé trá rû ꞌẽlé ûrú ꞌálâ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Gõꞌdá má âtâ kpá ãnî drí nõtí, õzõ õjílã rı̣̃ õlẽ ĩyî tã-drı̣̃ trá ngá ãzâ ꞌẽzó ãngó nõ ꞌá nõngá rî, nĩ ꞌê rãtáã Ôvârí ãmâ átá ûrú ꞌálâ rî drí ngá rî ꞌdĩ tãsĩ. Gólâ âꞌdô ngá rî ꞌdĩ ꞌẽꞌá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ĩtí rî, õzõ õjílã ẽêꞌbê ĩyî rû trá rı̣̃ ngãtá nâ võ ãlô ꞌá ámâ rú sĩ rî, má âꞌdô âꞌdóꞌá gólĩyî lãfálé ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Gõꞌdá nĩngá sĩ rî, Pétẽrõ drí ânĩzó tã îjílí Yésũ tı̣́ kĩ nĩ rî, “Kúmú, õzõ ámâ ãzí-ãzí ãzâ õrî trá zãâ rĩꞌá tã õnjí ꞌẽlé má drí ândálé ândálé rî, má ãâyê gólâ tã õnjí gólâkâ ꞌdĩ ꞌbá yî ꞌásĩ ândâlâ tạ̃sı̣̂ yã? Rĩꞌá tãndí ró má drí gólâ rî âyézó ândâlâ njı̣̂-drı̣̃-lâ-rı̣̃ yã?” ");
INSERT INTO avu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó Pétẽrõ drí kĩ, “ꞌÉꞌẽ, ní âyê gólâ kô cé ândâlâ njı̣̂-drı̣̃-lâ-rı̣̃. Ní âyê gólâ nyâꞌdî-nâ-drı̣̃-lâ-mûdrı̣́ ândâlâ njı̣̂-drı̣̃-lâ-rı̣̃.” ");
INSERT INTO avu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gõꞌdá Yésũ drí tã âtázó tã kũmũ Ôvârí kâ rî kâ tãsĩ. Gólâ kĩ, “Âꞌdô-âꞌdô kũmũ Ôvârí kâ rî kâ rî rĩꞌá õzõ kúmú ạ́ngı̣́ ãzâ gólâ âꞌdó ꞌbá lôsĩ ꞌẽ ꞌbá íyíkâ bê rî kâtí. Lôsĩ ꞌẽ ꞌbá gólâkâ ꞌdĩ ꞌbá yî, ãzâ ꞌbá yî trõ ĩyî ậdı̣̂ trá gólâ drı̣́gạ́ sĩ ꞌẽꞌá lôgõlâ ạ̃tı̣́ ꞌá tólâ. Gõꞌdá kậyı̣̂ ãzâ sĩ, gólâ drí lôsĩ ꞌẽ ꞌbá gólâkâ ꞌdĩ ꞌbá yî ậzı̣́zó ânĩlí ậdı̣̂ íyíkâ ꞌdĩ ꞌbá yî lôgõlé. ");
INSERT INTO avu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ĩtí rî, lôsĩ ꞌẽ ꞌbá ãlô kúmú ꞌdĩ kâ tíbê ậdı̣̂ trõ ꞌbá gólâ drı̣́gạ́ sĩ rî âjízó lâ kúmú ꞌdĩ ândrá. Ậdı̣̂ rî ꞌdĩ rĩꞌá ậdı̣̂ õjílã dũû lôsĩ ndrô dũû kâ rî kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nĩngá sĩ, lôsĩ ꞌẽ ꞌbá kúmú ꞌdĩ kâ ꞌdĩ îcá kô ậdı̣̂ ꞌdĩ võ lâ lôgõlé, tãlâ ậdı̣̂ ꞌdĩ rĩꞌá ậdı̣̂ ãmbá ꞌî. Tã ꞌdî tãsĩ rî, kúmú ꞌdĩ drí tã ꞌbãzó óõgî ró gólĩyî bê vólé rạ̃gı̣́ı̣̃ ró õkó lâ bê mvá lâ yí bê gõꞌdá kpá ngá gólâkâ ꞌbã kâ rî yí bê ndrĩ vólé, gólâ îcâ ró bê ậdı̣̂ íyíkâ ꞌdĩ võ lâ lôgõlé. ");
INSERT INTO avu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Gõꞌdá lôsĩ ꞌẽ ꞌbá ꞌdĩ ârî tã ꞌdî bê ĩtí rî, drílâ âꞌdózó tã ı̣̂sũ ró, gõꞌdá drílâ ngãzó ꞌãꞌî tı̣̃lı̣́ vũdrı̣́ kúmú ꞌdĩ ândrá rû lôꞌbãlé gólâ drí kĩ, ‘Óõ kúmú, ní ndrê ámâ ĩzã, ánî ꞌâ ạ̃ậꞌdı̣̂ má rú. Ní êsê kậyı̣̂ gbíyá má drí sı̣́sı̣́ ꞌálâ, má âꞌdô ậdı̣̂ áníkâ ꞌdĩ võ lâ lôndãꞌá ânĩzó lôgõlâ ndrĩ ní drí.’ ");
INSERT INTO avu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gõꞌdá lôsĩ ꞌẽ ꞌbá kúmú ꞌdĩ kâ ꞌdĩ, ĩzã lâ drí gãzó gólâ rú. Ĩtí rî, drílâ ậdı̣̂ ꞌdĩ âyézó drílâ, gõꞌdá gólâ drí lôsĩ ꞌẽ ꞌbá gólâkâ ꞌdĩ âyézó nĩlí drı̣̃-bạ́lạ́yı̣̂ ró. ");
INSERT INTO avu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nĩngá sĩ, lôsĩ ꞌẽ ꞌbá gólâ âyélé nõ drí nĩzó ĩyî rû ûsúlı̣́ ãzí-ãzí lâ ãzâ ậdı̣̂ fínyáwá trõ ꞌbá gólâ drı̣́gạ́ sĩ kpá ꞌẽꞌá lôgõlâ ạ̃tı̣́ ꞌálâ rî bê. Gõꞌdá gólĩyî ûsû rû bê ãzí-ãzí lâ ꞌdĩ bê rî, gõꞌdá kôrô drílâ ngãzó ꞌdẽlé ômbê lâ rũlı̣́ ạ̃ngbũ rĩꞌá îzálâ. Gõꞌdá drílâ ngãzó tã âtálé ãzí-ãzí lâ ꞌdĩ drí kĩ, ‘Ní âfẽ ậdı̣̂ ámákâ tíbê ní drí trõlé má drı̣́gạ́ sĩ rî ngbãângbânõ!’ ");
INSERT INTO avu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Gõꞌdá ãzí-ãzí lâ ꞌdĩ drí ngãzó ꞌãꞌî tı̣̃lı̣́ vũdrı̣́ lôsĩ ꞌẽ ꞌbá ãzí lâ ꞌdĩ ândrá rû lôꞌbãlé gólâ drí kĩ, ‘Óõ ámâ ãzí-ãzí, ní ndrê ámâ ĩzã, ánî ꞌâ ạ̃ậꞌdı̣̂ má rû! Ní êsê kậyı̣̂ gbíyá má drí sı̣́sı̣́ ꞌálâ. Má âꞌdô ậdı̣̂ áníkâ ꞌdĩ võ lâ lôndãꞌá ânĩzó fẽlâ ndrĩ ní drí.’ ");
INSERT INTO avu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Gõꞌdá lôsĩ ꞌẽ ꞌbá gólâ sı̣́sı̣́ kúmú drí gólâ rî âyélé ậdı̣̂ íyíkâ tãsĩ nô rî, gâ vólé trá dó ãzí-ãzí lâ ậdı̣̂ fínyáwá trõ ꞌbá gólâ drı̣́gạ́ sĩ rî âyélé. Bê-rî, gólâ drí lôsĩ ꞌẽ ꞌbá ãzí gólâkâ ꞌdĩ trõzó ꞌbãlé gạ̃nı̣́mạ̃ ꞌá rĩlí tólâ, té gólâ ãâfẽ ró ậdı̣̂ íyíkâ ꞌdĩ bê zãlô. ");
INSERT INTO avu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ĩtí rî, lôsĩ ꞌẽ ꞌbá kúmú ꞌdĩ kâ ãzâ ꞌbá yî ndrê tã rû ꞌẽ ꞌbá ꞌdĩ bê rî, gólĩyî drí âꞌdózó tã ı̣̂sũ ró rõô. Gõꞌdá drílĩyî ngãzó nĩlí tã ꞌdî âtálé kúmú ĩyíkâ ꞌdĩ drí. ");
INSERT INTO avu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Gõꞌdá kúmú ꞌdĩ ârî bê tã ꞌdî ĩtí rî, drílâ lôsĩ ꞌẽ ꞌbá íyíkâ gólâ ãzí-ãzí lâ rî ꞌbã ꞌbá gạ̃nı̣́mạ̃ ꞌá ꞌdĩ ậzı̣́zó. Gõꞌdá gólâ âcâ bê rî, kúmú drí ngãzó tã âtálé drílâ kĩ, ‘Nî rĩꞌá lôsĩ ꞌẽ ꞌbá õnjí ꞌî! Ní lôꞌbã rúꞌbạ́ bê má drí ậdı̣̂ ní drí trõlé má drı̣́gạ́ sĩ rî tãsĩ rî, má âyê nî té õzõ ní drí îjílí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gõꞌdá ní ꞌê tã ánî ãzí-ãzí drí ĩtí ãꞌdô tãsĩ yã? Tí ní âꞌdô ánî ãzí-ãzí rî ĩzã ndrẽꞌá kpá õzõ má drí ánî ĩzã ndrẽrẽ rî kâtí!’ ");
INSERT INTO avu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gõꞌdá kúmú ꞌdĩ drí ꞌbãzó ạ̃wạ̃ ró tã ꞌdî tãsĩ. Drílâ lôsĩ ꞌẽ ꞌbá ꞌdĩ jõzó ꞌbãlé gạ̃nı̣́mạ̃ ꞌá, tãlâ óõfẽ ró lâŋõ bê gólâ drí, té ậdı̣̂ íyíkâ gólâ drí trõlé rî, gólâ õlôgõ ró bê ndrĩ zãlô.” ");
INSERT INTO avu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Gõꞌdá Yésũ ngî bê íꞌdígówá ꞌdĩ ndẽlé rî, gólâ kĩ, “Õzõ nĩ ãâyê tã õnjí ãnî ãzí-ãzí kâ kô ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌásĩ rî, ãnî ãlô-ãlô ndrĩ, ámâ átá ûrú ꞌálâ rî âꞌdô kpá ꞌẽꞌá ãnî ꞌẽlé té õzõ ꞌdĩî rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Gõꞌdá Yésũ ndẽlé bê tã îmbâ íyíkâ tã õnjí âyê-âyê tãsĩ rî, drílĩyî ngãzó ꞌbạ̃drı̣̃ Gãlĩláyã kâ âyélé lãjóꞌbá íyíkâ bê. Drílĩyî nĩzó mbãlé ꞌáꞌá lé drı̣̃ áyágá Jõrõdénĩ kâ ãzâ lésĩ rî ꞌá. Drílĩyî nĩzó zãâ áyágá Jõrõdénĩ kâ ꞌdĩ ꞌáꞌá lé drı̣̃ lâ lésĩ. Gõꞌdá drílĩyî mbãzó kpá gõlé ꞌáꞌá lé drı̣̃ ãzâ rî lésĩ cãlé ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gõꞌdá gólĩyî câ bê ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ ꞌdĩ ꞌá tólâ rî, õjílã õꞌbí dũû drí îtõzó ꞌdẽlé gólĩyî vósĩ. Õjílã gólĩyî ngá lãzé bê rî ꞌbá yî, Yésũ drí gólĩyî êdézó ndrĩ ngá lãzé ĩyíkâ ꞌdĩ ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nĩngá sĩ, Pạ̃rúsı̣̃ ãzâ ꞌbá yî drí ânĩzó ĩyî Yésũ rî ûjũlı̣́, ngãtá gólâ âꞌdô úlı̣́ ányâ âtáꞌá yã rî. Drílĩyî tã îjízó gólâ tı̣́ kĩ nĩ rî, “Tã ꞌbãꞌbã Ôvârí drí fẽlé ãmâ drí ꞌẽlé Músạ̃ sĩ rî vó ró rî, rĩꞌá tãndí ró õjílã ãzâ drí õkó lâ rî îngázó, õzõ õkó rî ꞌdĩ õꞌê tã ányâ ãzâ trá rî yã?” ");
INSERT INTO avu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ zı̣́ tã gólâ îgĩlí búkũ Ôvârí kâ ꞌá rî kô kĩꞌá nĩ rî, îtõ võ ãngó kâ ꞌásĩ rî, Ôvârí ꞌbã õjílã mvá bê rî, gólâ ꞌbã ãgô yî trá õkó yí bê yã? ");
INSERT INTO avu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tã ꞌdî tãsĩ rî, Ôvârí âtâ tã trá kĩ nĩ rî, ‘Ãgô âꞌdô átá lâ rî âyéꞌá ândré lâ bê âꞌdózó õkó lâ bê ngá ãlô ró. ");
INSERT INTO avu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gólĩyî rı̣̃ ꞌdî âꞌdó ngá ngĩíngî ꞌî kô. Ĩtí rî, ãgô yî õkó bê gólĩyî rĩꞌá ngá ãlô ꞌî. ꞌDõvó ngá gólâ Ôvârí drí êbẽlé trá ngá ãlô ró rî, õjílã ãzâ õcâ gólĩyî lãfálé kô.’ ” ");
INSERT INTO avu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Gõꞌdá Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí Yésũ rî îjízó kpá óꞌdí kĩ, “Ní kĩ nĩ rî, âꞌdó kô tãndí ró ãmâ drí õkó îngázó rî, gõꞌdá tãlâ ãꞌdô ꞌî Músạ̃ drí tã ꞌbãzó ãmâ drí kĩ, õzõ mã õlẽ trá õkó îngálé rî, mã ĩîgĩ wárãgã õkó îngâ kâ fẽlé õkó rî ꞌdĩ drí yã?” ");
INSERT INTO avu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Músạ̃ îgĩ tã ꞌdî ãnî drí ĩtí ꞌdĩ, tãlâ ãnî drı̣̃ rĩꞌá âmbâ-âmbâ ró, tãlâ tã ãꞌdô trá ãnî lãfálé ꞌásĩ ãnî õkó yí bê rî nĩ îcá kô tã rî ꞌdĩ êdélé. Gõꞌdá tã ꞌbãꞌbã Ôvârí kâ âꞌdó kô ĩtí îtõ võ ãngó kâ ꞌásĩ. Sı̣́sı̣́ rî, Ôvârí ꞌbãá tã ꞌbãꞌbã õkó îngâ kâ kô. ");
INSERT INTO avu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Má âtâ ãnî drí, âꞌdó kô tãndí ró õjílã ãzâ drí õkó lâ rî îngázó cú ĩtí tã ífí ãzâ ãkó, õzõ õkó rî ꞌdĩ õꞌê tã õnjí ãzâ kô gõꞌdá ãgô rî ꞌdĩ drí nĩzó õkó ãzâ trõlé ậyı̣́zó ĩꞌdí bê lâ rî, gólâ ꞌê ꞌdĩ tã õnjí ꞌî Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá, âyê fí ãlô, õzõ õjílã rî ꞌdĩ ũûsû õkó lâ trá ậyı̣́rı̣̃ ꞌá ĩyî ãgô ãzâ bê rî ĩꞌdî, gólâ õró gõ õkó lâ ꞌdĩ îngálé.” ");
INSERT INTO avu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ Yésũ drí âtálé ꞌdĩ bê rî, gõꞌdá drílĩyî gõzó tã âtálé gólâ drí kĩ nĩ rî, “Õzõ tã ãgô yî lãfálé ꞌá õkó bê rî ãâꞌdô âmbâ-âmbâ ró ĩtí rî, rĩꞌá tãndí ró ãgô drí rĩzó cú ĩtí õkó trõ ãkó.” ");
INSERT INTO avu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Õjílã dũû îcá ĩyî kô tã ı̣̂sũ ãníkâ õkó tãsĩ ꞌdî ꞌẽlé. Âꞌdô ꞌbãꞌá cé õjílã îcá ꞌbá rĩlí õkó trõ ãkó rî ꞌbá yî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tã ꞌdî tãsĩ rî, tã ífí bê rĩꞌá ngĩíngî õjílã ãzâ ꞌbá yî drí õkó trõzó kô ꞌá lâ rî. Útı̣̂ õjílã ãzâ ꞌbá yî trá ĩtí ꞌbáŋá ró, gõꞌdá õjílã ãzâ ꞌbá yî õjílã ãzí lîsî gólĩyî nĩ, gõꞌdá õjílã ãzâ ꞌbá yî lẽé ĩyî õkó gĩlí kô, tãlâ gólĩyî fẽ ĩyî nyãányâ trá cé lôsĩ Ôvârí kâ ꞌẽlé ĩꞌdî. Õjílã gólâ îcá ꞌbá trá tã rî ꞌdĩ ꞌẽlé rî, ꞌdõvó gólâ õꞌê.” ");
INSERT INTO avu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gõꞌdá nĩngá sĩ, õjílã ãzâ ꞌbá yî drí ꞌdĩyímvá õnyíkõ âtrõzó âjílí Yésũ ngálâ, tãlâ Yésũ õꞌbã ró drı̣́ bê gólĩyî drı̣̃ı̣̂ õrẽ fẽzó drílĩyî, gõꞌdá kpá rãtáã ꞌẽzó bê gólĩyî tãsĩ. Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí õjílã ꞌdî ꞌbá yî lôgázó dó ânĩlí ꞌdĩyímvá ꞌdĩ ꞌbá yî bê Yésũ ngálâ. ");
INSERT INTO avu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gõꞌdá Yésũ drí ngãzó tã âtálé kĩ nĩ rî, “Nĩ âyê ꞌdĩyímvá ꞌdĩ ꞌbá yî ãânĩ ró ĩyî má ngálâ, nĩ lôgâ gólĩyî kô, tãlâ õjílã rĩ ꞌbá kũmũ Ôvârí kâ zẽlé rî ꞌbá yî rĩꞌá õjílã gólĩyî ĩyî nyãányâ lôgõ ꞌbá õzõ ꞌdĩyímvá õnyíkõ nõtí nõ ꞌbá yí kâtí rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nĩngá sĩ rî, drílâ íyî drı̣́ ꞌbãzó ꞌdĩyímvá ꞌdĩ ꞌbá yî drı̣̃ı̣̂ sĩ ãlô-ãlô, gõꞌdá drílâ õrẽ fẽzó drílĩyî. Gõꞌdá drílĩyî ngãzó nĩlí võ ꞌdî âyélé lãjóꞌbá ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Gõꞌdá nĩngá sĩ rî, ágámvá ãzâ ngá-tı̣̂ ãmbá bê rî drí ânĩzó tã îjílí Yésũ tı̣́ kĩ nĩ rî, “Tã îmbá ꞌbá, õzõ má õlẽ lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúlı̣́ rî, má âꞌdô tã tãndí ángô rî ꞌẽꞌá ĩꞌdî sũlı̣́ Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá ûsúzó lâ yã?” ");
INSERT INTO avu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílâ kĩ, “Tãlâ ãꞌdô ꞌî ní drí ámâ îjízó tã gólâ âꞌdó ꞌbá tãndí ró rî tãsĩ yã? Ôvârí cé ĩꞌdî rĩꞌá tãndí ró. Õzõ ní õlẽ trá lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúlı̣́ rî, ní ı̣̂njı̣̃ tã ꞌbãꞌbã Ôvârí kâ rî ĩꞌdî ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ĩtí rî, ágámvá ꞌdĩ drí Yésũ rî îjízó kĩ, “Má âꞌdô tã ꞌbãꞌbã ángô rî ꞌẽꞌá ĩꞌdî yã?” Ĩtí rî, Yésũ drí gõzó tã-drı̣̃ lôgõlé drílâ kĩ, “Ní fû õjílã ãzí kô. Ní ꞌbã õkó gólâ âꞌdó ꞌbá kô ánî õkó ró rî kô ní ũgúlı̣́ ậyı̣́zó ĩꞌdí bê lâ. Ní ûgũ ngá kô. Ní âdô õnjõ kô õjílã ãzí rú. ");
INSERT INTO avu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ní ârî ánî átá yî tı̣̂-võ ánî ândré bê, tãlâ ní ı̣̂njı̣̃ ró gólĩyî bê. Ní lẽ õjílã ãzí õzõ ní drí ánî nyãányâ lẽrẽ kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nĩngá sĩ, ágámvá ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Tã ꞌbãꞌbã ꞌdî ꞌbá yî, má ꞌê trá ndrĩ. Gõꞌdá tã ãzâ kpá bê drẽ zãâ má drí ꞌẽlé yã?” ");
INSERT INTO avu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílâ kĩ, “Õzõ ní õlẽ trá âꞌdólé tã mbı̣̂ ꞌẽ ꞌbá ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî, ní gõ nĩlí ngá-tı̣̂ ãmbá áníkâ ꞌdĩ ꞌbá yî lậzı̣́lı̣́ gĩlí ndrĩ vólé, ní fẽ ró ậdı̣̂ lâ õjílã gólĩyî ĩzã bê rî ꞌbá yî drí, gõꞌdá ní gõ ró bê ânĩlí ꞌdẽlé ámâ vó bẽlé tã ârí ꞌbá ámákâ ró. Õzõ ní õꞌê tã ꞌdî trá ĩtí rî, ní âꞌdô ꞌbãꞌá ngá-tı̣̂ tãndí bê dũû ûrú ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gõꞌdá ágámvá ꞌdĩ ârílí bê úlı̣́ Yésũ drí âtálé ĩtí ꞌdĩ rî, kôrô rúꞌbạ́ lâ drí âdãzó. Gõꞌdá drílâ âꞌdózó tã ı̣̂sũ ró rõô, tãlâ gólâ lẽé kô ngá íyíkâ ãmbá ꞌdĩ ꞌbá yî lậzı̣́lı̣́ gĩlí vólé. Gõꞌdá drílâ ngãzó nĩlí vólé. ");
INSERT INTO avu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nĩngá sĩ, Yésũ drí gõzó tã âtálé tã ârí ꞌbá íyíkâ rî ꞌbá yî drí kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, rĩꞌá âmbâ-âmbâ ró õjílã gólĩyî ngá-tı̣̂ ãmbá bê rî ꞌbá yî drí âꞌdózó õjílã Ôvârí kâ ró gólĩyî drí îcázó rĩlí kũmũ gólâkâ zẽlé tã gólâkâ rî ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Âꞌdô ꞌbãꞌá âmbâ-âmbâ ró gólĩyî drí lậvũlı̣́ gạ̃rạ̃ tã âmbâ-âmbâ ĩnjígó drí ꞌẽꞌá ûsúlâ ûjũrı̣̃ fĩlí kôrô lı̣́bı̣̃rạ̃ ꞌbú ꞌásĩ rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gõꞌdá tã ârí ꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ gólâ drí âtálé ꞌdĩ bê rî, tı̣̂ lâ yî drí ậꞌdı̣́zó rõô úlı̣́ ꞌdĩ ꞌbá yî drí sĩ. Gõꞌdá drílĩyî Yésũ rî îjízó kĩ, “Õzõ ãꞌdô trá ĩtí rî, õjílã gólĩyî Ôvârí drí ꞌẽꞌá pãlâ rî âꞌdô ꞌbãꞌá ĩyíkâ õjílã ángô rî ꞌbá yî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yésũ drí lı̣̃fı̣́ jãzó võ ndrẽlé gólĩyî ngálâ ró, gõꞌdá drílâ gõzó tã âtálé kĩ, “Ngá gólĩyî õjílã mvá drí îcálé kô ꞌẽlâ rî, Ôvârí îcâ trá ꞌẽlâ ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nĩngá sĩ rî, Pétẽrõ drí ngãzó tã âtálé Yésũ drí kĩ nĩ rî, “Ní ndrê drẽ, ãmâ lãjóꞌbá áníkâ rî ꞌbá yî, mã âyê ngá ãmâ nyãányâ kâ rî ꞌbá yî trá ndrĩ ânĩzó ꞌdẽlé ní vósĩ tã ârí ꞌbá áníkâ ró. Ĩtí rî, tã tãndí gólâ ãmâ drí ꞌẽꞌá ûsúlâ Ôvârí drı̣́gạ́ sĩ ı̣̃zạ́tú rî íyíkâ ãꞌdô ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, mâ gólâ Ôvârí drí âjólé trá ûrú lésĩ nô, kậyı̣̂ gólâ má drí ꞌẽzó ngá ndrĩ ꞌbãlé óꞌdí ı̣̃zạ́tú rî sĩ rî, má âꞌdô ꞌẽꞌá rĩlí kı̣́tı̣̃ ámákâ drı̣̃ı̣̂ kúmú ạ́ngı̣́ ró drı̣́-ãcê bê. Gõꞌdá ãnî lãjóꞌbá ámákâ mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ rî ꞌbá yî âꞌdô ꞌẽꞌá rĩlí má bê kı̣́tı̣̃ mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ rî ꞌbá yî drı̣̃ı̣̂ kúmú ró tã-vó õrĩ õjílã Ĩsĩrãꞌélẽ kâ rî kâ mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ rî ꞌbá yí kâ kĩlí. ");
INSERT INTO avu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Gõꞌdá õjílã ndrĩ gólĩyî ꞌbã ĩyíkâ âyé ꞌbá, átá lâ yî, ândrê lâ yî, mvá lâ yî, ậdrúpı̣̃ lâ yî, îzó lâ yî, ngãtá ạ́mvú yí bê âyé ꞌbá ꞌdẽzó má vósĩ tã ârí ꞌbá ámákâ ró rî, ngá gólĩyî drí ꞌẽꞌá ûsúlâ ámâ átá Ôvârí drı̣́gạ́ sĩ ı̣̃zạ́tú rî âꞌdô ꞌẽꞌá lậvũlı̣́ gạ̃rạ̃ ândâlâ kámá-ãlô ngá gólĩyî drí âyélé rî drı̣̃ı̣̂ sĩ. Gõꞌdá gólĩyî âꞌdô kpá lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá. ");
INSERT INTO avu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Gõꞌdá ĩtí rî, õjílã dũû tíbê ngbãângbânõ ndrẽlé ĩyî õjílã ãmbâ-ãmbâ ró rî ꞌbá yî, ı̣̃zạ́tú rî, gólĩyî âꞌdô âꞌdóꞌá õjílã tãkó ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá, gólĩyî âꞌdô gõꞌá vólé ꞌálâ. Gõꞌdá õjílã gólĩyî dũû gólĩyî ngbãângbânõ rĩꞌá ndrẽlâ ĩyî õjílã tãkó ró rî ꞌbá yî, ı̣̃zạ́tú rî, gólĩyî âꞌdô âꞌdóꞌá õjílã ãmbâ-ãmbâ ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá, gólĩyî âꞌdô ꞌbãꞌá sı̣́sı̣́ ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ drí îtõzó tã îmbálé úlı̣́ mãnĩgõ sĩ tã ârí ꞌbá íyíkâ rî ꞌbá yî drí lạ́tı̣̂ gólâ Ôvârí drí ꞌẽzó drı̣́-ꞌâ fẽlé õjílã íyíkâ drí ı̣̃zạ́tú rî tãsĩ. Gólâ kĩ, “Lạ́tı̣̂ gólâ Ôvârí drí ꞌẽzó drı̣́-ꞌâ fẽlé õjílã íyíkâ drí rî rĩꞌá nyé õzõ ãgô ãzâ ạ́mvú lı̣́pı̣̂ ró rî kâtí. Kậyı̣̂ ãzâ sĩ, ãkpã cı̣̃ı̣́nó, gólâ drí ngãzó nĩlí võ ngá lậzı̣̂ kâ gĩlí rî ꞌálâ, nĩꞌá õjílã lôndãlé ãânĩ ró ĩyî lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌá ậdı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Gõꞌdá ạ́mvú lı̣́pı̣̂ ûsû õjílã bê lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌá rî, gólâ drí tã ı̣̂ꞌbı̣̃zó gólĩyí bê ậdı̣̂ tãndí kậyı̣̂ ãlô kâ fẽlé drílĩyî ndrĩ îcâ-îcâ ró. Gõꞌdá drílĩyî tã-drı̣̃ lâ lẽzó. Nĩngá sĩ rî, ạ́mvú lı̣́pı̣̂ drí gólĩyî jõzó nĩꞌá lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nĩngá sĩ, ı̣̃tú-pá njı̣̂-drı̣̃-lâ-sû cı̣̃ı̣́nó ꞌdĩ kâ rî sĩ, ạ́mvú lı̣́pı̣̂ ꞌdĩ drí nĩzó gõlé kpá óꞌdí võ ngá lậzı̣̂ kâ gĩlí ꞌdĩ ꞌálâ. Gõꞌdá drílâ nĩzó õjílã ãzâ ꞌbá yî ûsúlı̣́, rĩꞌá ĩyî âdréꞌá tólâ tãkó ĩtí. ");
INSERT INTO avu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gõꞌdá drílâ tã âtázó drílĩyî kĩ nĩ rî, ‘Nĩ nĩ kpá nĩꞌá lôsĩ ꞌẽlé má drí ạ́mvú ꞌálâ, má âꞌdô ậdı̣̂ mbı̣̂ lôsĩ ãnî drí ꞌẽlé má drí kậyı̣̂ ãndrõ nô kâ sĩ rî fẽꞌá ãnî drí.’ Gõꞌdá drílĩyî ngãzó nĩlí lôsĩ ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Gõꞌdá ı̣̃tú-pá câ bê mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ ı̣̃tú-ạ̃yı̣́ sĩ rî gõꞌdá kpá ı̣̃tú-pá nâ lạ̃njạ́túlı̣́ bê rî, ạ́mvú lı̣́pı̣̂ ꞌdĩ drí kpá tã ãlô-ãlô ꞌdĩ ꞌẽzó. Drílâ nĩzó kpá óꞌdí võ ngá lậzı̣̂ kâ gĩlí rî ꞌálâ, nĩꞌá õjílã lôndãlé ânĩꞌá lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Gõꞌdá câ bê lạ̃njạ́túlı̣́ bê ı̣̃tú drí ꞌbãrẽ ꞌẽꞌá nĩꞌá fĩlí rî ꞌá rî, ạ́mvú lı̣́pı̣̂ ꞌdĩ drí nĩzó gõlé kpá óꞌdí võ ngá lậzı̣̂ kâ gĩlí rî ꞌálâ. Drílâ nĩzó õjílã ãzâ ꞌbá yî ûsúlı̣́ rĩꞌá âdréꞌá ĩyî tãkó tólâ võ ngá lậzı̣̂ kâ ꞌdĩ ꞌá. Gõꞌdá drílâ tã îjízó gólĩyî tı̣́ kĩ, ‘Nĩ rî âdrélé nõngá ı̣̃tú kạ̃ạ́lũ tãkó lôsĩ ꞌẽ ãkó ãꞌdô tãsĩ yã?’ ");
INSERT INTO avu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó kĩ nĩ rî, ‘Õjílã ãzãkã yû lôsĩ fẽ ꞌbá ãmâ drí ꞌẽlé.’ Gõꞌdá ạ́mvú lı̣́pı̣̂ drí gõzó tã âtálé drílĩyî kĩ nĩ rî, ‘ꞌDõvó nĩ nĩ kpá lôsĩ ꞌẽlé má drí ạ́mvú ꞌálâ.’ Gõꞌdá drílĩyî nĩzó kpá lôsĩ ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Gõꞌdá câ bê võ drí ꞌẽrẽ ậnı̣́lı̣́ rî ꞌá rî, ạ́mvú lı̣́pı̣̂ drí tã âtázó drı̣̃-ꞌbá íyíkâ lôsĩ kâ drí kĩ, ‘Ní ậzı̣̂ lôsĩ ꞌẽ ꞌbá ꞌdĩ ꞌbá yî, ní fẽ ró ậdı̣̂ gólĩyî drí. Ní îtõ ậdı̣̂ fẽlé õjílã gólĩyî lôsĩ îtõ ꞌbá ꞌẽlé lạ̃njạ́túlı̣́ bê rî ꞌbá yî rú sĩ, cãlé gólĩyî lôsĩ îtõ ꞌbá ꞌẽlé ãkpã cı̣̃ı̣́nó rî ꞌbá yî rú.’ ");
INSERT INTO avu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gõꞌdá õjílã gólĩyî lôsĩ îtõ ꞌbá ꞌẽlé lạ̃njạ́túlı̣́ ꞌásĩ rî ꞌbá yî ânĩ ĩyî bê ậdı̣̂ ĩyíkâ trõlé rî, drı̣̃-ꞌbá lôsĩ kâ fẽ gólĩyî drí ậdı̣̂ lôsĩ kậyı̣̂ ãlô kâ rî kâ ĩꞌdî. Kpá ĩtí, õjílã gólĩyî ndrĩ ạ́mvú lı̣́pı̣̂ drí ậzı̣́lı̣́ ânĩꞌá lôsĩ ꞌẽlé rî ꞌbá yî, drı̣̃-ꞌbá lôsĩ kâ fẽ kpá ậdı̣̂ lôsĩ kậyı̣̂ ãlô kâ rî kâ ĩꞌdî gólĩyî drí ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Gõꞌdá õjílã gólĩyî lôsĩ îtõ ꞌbá ꞌẽlé ãkpã cı̣̃ı̣́nó rî lésĩ rî ꞌbá yî ânĩ ĩyî bê ậdı̣̂ ĩyíkâ trõlé rî, gólĩyî ı̣̂sũ tã trá kĩ nĩ rî, áãꞌdô ậdı̣̂ fẽꞌá ĩyî drí lậvũlı̣́ gạ̃rạ̃ ậdı̣̂ fẽlé õjílã gólĩyî lôsĩ îtõ ꞌbá ꞌẽlé lạ̃njạ́túlı̣́ bê rî ꞌbá yî drí rî drı̣̃ı̣̂ sĩ. Gõꞌdá ófẽ kpá ậdı̣̂ lôsĩ kậyı̣̂ ãlô kâ rî kâ ĩꞌdî gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Gõꞌdá gólĩyî trõ ậdı̣̂ ĩyíkâ bê rî, drílĩyî îtõzó rĩꞌá lôzólé úlı̣́ ngũrũ-ngũrũ bê ạ́mvú lı̣́pı̣̂ ꞌdĩ rú. ");
INSERT INTO avu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Gõꞌdá drílĩyî ngãzó tã âtálé ạ́mvú lı̣́pı̣̂ drí kĩ, ‘Õjílã gólĩyî lôsĩ îtõ ꞌbá ꞌẽlé lạ̃njạ́túlı̣́ ꞌásĩ rî ꞌbá yî ꞌê ĩyî lôsĩ cé dã ĩtí. Gõꞌdá ãmâ rî gógó ãmákâ lôsĩ ꞌẽ ꞌbá ı̣̃tú kạ̃ạ́lũ ı̣̃tú ãmé drı̣̃ı̣̂ sĩ nô rî ꞌbá yî, áâꞌdô ậdı̣̂ fẽꞌá ãmâ drí îcâ-îcâ ró õjílã gólĩyî lôsĩ îtõ ꞌbá ꞌẽlé vólé lésĩ rî ꞌbá yí bê ángô tí ró yã?’ ");
INSERT INTO avu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Gõꞌdá ạ́mvú lı̣́pı̣̂ drí gõzó tã âtálé lôsĩ ꞌẽ ꞌbá ãlô gólĩyî lãfálé ꞌásĩ rî drí kĩ, ‘Ámâ rû-lẽ-ãzíyã, nĩ lẽ tã-drı̣̃ trá ậdı̣̂ kậyı̣̂ ãlô kâ ꞌẽꞌá fẽlâ ãnî drí rî tãsĩ. Má âdó ãnî kô. ");
INSERT INTO avu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nĩ trõ ậdı̣̂ ãníkâ, nĩ nĩ gõlé ãnî drí ꞌbã ꞌásĩ. Má lẽ kpá ậdı̣̂ fẽlé îcâ-îcâ ró õjílã gólĩyî lôsĩ îtõ ꞌbá vólé lésĩ rî ꞌbá yî drí õzõ má drí fẽlé ãnî drí ꞌdĩ kâtí. ");
INSERT INTO avu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ní ı̣̂sũ áníkâ bê-rî, âꞌdó kô rĩꞌá mbı̣̂ má drí tã gólâ má drí lẽlé ꞌẽlé rî ꞌẽzó ậdı̣̂ ámákâ sĩ õzõ má drí lẽlé rî kâtí yã? Gõꞌdá tãlâ ãꞌdô ꞌî ãnî drí âꞌdózó ạ̃wạ̃ ró má bê yã? Ãnî rĩꞌá ạ̃wạ̃ ró má bê tãlâ tã gólâ má drí ꞌẽlé tãndí ró õjílã pãlé rî tãsĩ yã? Má âꞌdô îcáꞌá tã gólâ má drí lẽlé ꞌẽlé rî ꞌẽlé õzõ má drí lẽlé rî kâtí ậdı̣̂ ámákâ sĩ.’ ” ");
INSERT INTO avu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Gõꞌdá Yésũ ndẽlé bê úlı̣́ mãnĩgõ lạ́tı̣̂ gólâ Ôvârí drí ꞌẽzó drı̣́-ꞌâ fẽlé õjílã íyíkâ drí rî tãsĩ rî, drílâ gõzó tã âtálé kĩ nĩ rî, “Õjílã dũû tíbê ngbãângbânõ ndrẽlé ĩyî õjílã ãmbâ-ãmbâ ró rî ꞌbá yî âꞌdô ĩyî âꞌdóꞌá ı̣̃zạ́tú õjílã tãkó ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá, gólĩyî âꞌdô gõꞌá vólé ꞌálâ. Gõꞌdá õjílã dũû gólĩyî ngbãângbânõ rĩꞌá ndrẽlâ ĩyî õjílã tãkó ró rî ꞌbá yî, ı̣̃zạ́tú rî, gólĩyî âꞌdô âꞌdóꞌá õjílã ãmbâ-ãmbâ ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá, gólĩyî âꞌdô ꞌbãꞌá sı̣́sı̣́ ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Gõꞌdá nĩngá sĩ, Yésũ yî drí ngãzó nĩlí Yẽrõsãlémã ꞌálâ tã ârí ꞌbá íyíkâ rî ꞌbá yí bê. Gõꞌdá gólĩyî õtírĩ rĩî nĩlí lạ́tı̣̂ ꞌásĩ rî, drílâ ngãzó lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ rî ꞌbá yî drı̣̃lı̣́ gbíyá lạ́tı̣̂ gãrã drı̣̃ ꞌá tã ârí ꞌbá ꞌdĩ ꞌbá yî lãfálé sĩ, tãlâ yĩ ãꞌdô ró bê cé ĩyî drı̣̃ı̣̂ sĩ. Gõꞌdá Yésũ drí tã gólĩyî ꞌẽ ꞌbá rû ꞌẽlé yí drí Yẽrõsãlémã ꞌálâ rî tã lâ âtázó gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Gólâ kĩ, “Nĩ ârî drẽ, ãmâ trá ꞌẽꞌá nĩlí Yẽrõsãlémã ꞌálâ nõ. Mâ gólâ âjólé ûrú lésĩ nô, áâꞌdô ꞌẽꞌá ámâ drı̣́-bã fẽlé drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî drı̣́gạ́ gõꞌdá kpá lãꞌbí îmbá ꞌbá rî ꞌbá yí bê. Gólĩyî âꞌdô ꞌẽꞌá tã-vó ámákâ kĩlí ányâ ró, tãlâ úfû ró mâ bê. ");
INSERT INTO avu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Gõꞌdá gólĩyî âꞌdô ĩyî ámâ drı̣́-bã fẽꞌá õjílã ãtrâ Rómã kâ rî ꞌbá yî drı̣́gạ́. Ĩtí rî, gólĩyî âꞌdô ámâ lârâkô lôꞌéꞌá. Gólĩyî âꞌdô ámâ cãꞌá ônjóróꞌbí sĩ, gõꞌdá gólĩyî âꞌdô ámâ îpáꞌá fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ má drí drãzó. Gõꞌdá kậyı̣̂ nâ sĩ, má âꞌdô lîdríꞌá kpá óꞌdí õdrã ꞌásĩ.” Gõꞌdá Yésũ âtâ úlı̣́ ꞌdĩ ꞌbá yî bê lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí rî, drílĩyî ngãzó gõlé tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî lãfálé. ");
INSERT INTO avu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gõꞌdá nĩngá sĩ rî, Zẽbẽdáyõ rî õkó drí ngãzó mvá lâ yî rı̣̃ Yãkóbã yî Yõwánĩ bê drı̣̃lı̣́ âfõzó gólĩyí bê lãjóꞌbá ꞌdĩ ꞌbá yî lãfálé sĩ. Drílĩyî nĩzó cãlé Yésũ lạ̃gạ́tı̣́. Gõꞌdá câ ĩyî bê Yésũ lạ̃gạ́tı̣́ rî, õkó rî gógó drí ngãzó ꞌãꞌî tı̣̃lı̣́ vũdrı̣́ Yésũ ândrá tã ı̣̂njı̣̃ sĩ. Gõꞌdá drílâ tã îjízó Yésũ tı̣́ íyî mvá ꞌdĩ ꞌbá yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gõꞌdá Yésũ ârî úlı̣́ gólâkâ ꞌdĩ bê rî, drílâ tã îjízó õkó ꞌdĩ tı̣́ kĩ nĩ rî, “Ní lẽ má õꞌê ãꞌdô ĩꞌdî ní drí yã?” Gõꞌdá õkó ꞌdĩ drí ngãzó tã âtálé Yésũ drí rúꞌbạ́ lôꞌbã-lôꞌbã sĩ kĩ nĩ rî, “Ị̃zạ́tú kậyı̣̂ gólâ ní drí ꞌẽzó rĩlí kúmú ạ́ngı̣́ ró ãngó nõ drı̣̃lı̣́ rî tú rî, ní ꞌbã ámâ mvá nõ ꞌbá yî rĩlí ní bê, ãlô rî õrî íyíkâ ánî drı̣́-ágó drı̣̃ lésĩ ró gõꞌdá ãzâ rî õrî íyíkâ ánî drı̣́-lı̣̃jı̣́ drı̣̃ lésĩ rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Gõꞌdá Yésũ drí tã âtázó Yãkóbã yî drí Yõwánĩ bê kĩ, “Tã gólâ ãnî drí tã lâ îjílí má tı̣́ sĩ ꞌdî rî, nĩ nı̣̃ı̣́ tã ífí lâ kô. Nĩ âꞌdô îcáꞌá cú ngá mvũlı̣́ ĩgã mvá lâŋõ kâ gólâ má drí ꞌẽzó ngá mvũlı̣́ ꞌá lâ sĩ rî ꞌásĩ má bê yã?” Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Ãwô, ãmâ rĩꞌá njãâ ngá mvũlı̣́ ĩgã mvá lâŋõ kâ ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Nĩ âꞌdô ngá mvũꞌá trá cú ĩgã mvá lâŋõ kâ ꞌdĩ ꞌásĩ. Gõꞌdá mâ rĩꞌá drı̣́-ãcê ãkó õjílã gólĩyî ꞌẽ ꞌbá rĩlí ámâ gãrã drı̣̃ ꞌá rî ꞌbá yî njĩzó. Ámâ átá êdê võ ꞌdî ꞌbá yî trá õjílã gólĩyî gólâ drí ꞌẽꞌá njĩlâ nĩ rĩlí ꞌá lâ rî ꞌbá yî drí.” ");
INSERT INTO avu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gõꞌdá lãjóꞌbá ạ̃mbúkũ Yésũ kâ mûdrı̣́ ꞌdĩ ꞌbá yî ârî ĩyî tã Yãkóbã yî Yõwánĩ bê ândré lâ yî drí îjílí Yésũ tı̣́ gólĩyî tãsĩ ꞌdî tã lâ bê rî, drílĩyî âꞌdózó ạ̃wạ̃ ró Yãkóbã yî rú Yõwánĩ bê. ");
INSERT INTO avu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tã ꞌdî tãsĩ rî, Yésũ drí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî ậzı̣́zó ndrĩ ânĩlí yí lạ̃gạ́tı̣́. Gõꞌdá drílâ tã âtázó gólĩyî drí kĩ, “Mĩ nı̣̃ trá kĩ nĩ rî, kúmú ꞌbạ̃súrú kâ rî ꞌbá yî rî rĩlí ꞌbạ̃súrú íyíkâ rî ꞌbá yî drı̣̃lı̣́ mbârâkã sĩ. ");
INSERT INTO avu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gõꞌdá ãnî lãjóꞌbá ámákâ rî ꞌbá yî lãfálé ꞌá rî, nĩ ꞌé ĩtí kô. Gólâ tíbê lẽ ꞌbá âꞌdólé ãmbá ró ãnî lãfálé ꞌásĩ Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî, gólâ ı̣̃ı̣̂ꞌbũ rû íyî ãzí-ãzí yî drí ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Õjílã ãnî lãfálé sĩ gólâ tíbê lẽ ꞌbá âꞌdólé ãmbá ró sı̣́sı̣́ íyî ãzí-ãzí yî drı̣̃ı̣̂ sĩ Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî, gólâ ãâꞌdô rạ̃gı̣́ı̣̃ ró rû ı̣̂ꞌbũlı̣́ ãzí-ãzí lâ yî drí ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tã ꞌdî tãsĩ rî, mâ rî gógó âjólé ûrú lésĩ nô, má ânĩí kô ãâꞌdô ró bê rû ı̣̂ꞌbũzó má drí. Má ânĩ rû ı̣̂ꞌbũlı̣́ ãzí-ãzí yî drí gõꞌdá kpá ámâ nyãányâ fẽlé drãlé õjílã dũû tãsĩ, tãlâ má înjî ró gólĩyî bê tã õnjí ĩyíkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ngãzó nĩlí zãâ ậcı̣́ ĩyíkâ ꞌá lãjóꞌbá íyíkâ rî bê, nĩꞌá Yẽrõsãlémã ꞌálâ. Gõꞌdá drílĩyî ânĩzó âcálé jạ̃rı̣́bạ̃ gólâ zı̣̃lı̣́ Yérĩkõ rî ꞌá. Gõꞌdá gólĩyî õtírĩ jạ̃rı̣́bạ̃ ꞌdî âyé rî, õjílã õꞌbí dũû drí ngãzó ꞌdẽlé gólĩyî vósĩ. ");
INSERT INTO avu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Gõꞌdá tólâ rî, Yésũ yî õtírĩ ꞌbãâ lậvũꞌá lạ́tı̣̂ ꞌásĩ rî, ãgô lı̣̃fı̣́ ãkó lé ꞌbá ró ãzâ ꞌbá yî bê rĩꞌá rı̣̃ lạ́tı̣̂ gãrã drı̣̃ ꞌá. Gõꞌdá gólĩyî ârî ĩyî tã bê kĩꞌá nĩ rî, ꞌdĩî ãꞌdô Yésũ ĩꞌdî rĩꞌá lậvũꞌá rî, drílĩyî ngãzó trẽlé lạ̃zı̣́ bê kĩ nĩ rî, “Yésũ, ní ꞌbã ãmâ ĩzã õgâ ní drı̣̃ı̣̂, nî ĩꞌdî tíbê Ôvârí drí tã lâ âtálé kĩꞌá nĩ rî, âꞌdô ânĩꞌá ãmâ pãlé nõ, ní pâ ãmâ.” ");
INSERT INTO avu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nĩngá sĩ, õꞌbí ꞌdĩ ꞌbá yî ârî ĩyî bê ôtrê-ôtrê lı̣̃fı̣́ ãkó lé ꞌbá ꞌdĩ ꞌbá yí kâ rî, drílĩyî tã lôgõzó gólĩyî drı̣̃ı̣̂ mbârâkã sĩ kĩ, “Nĩ ôtrê kô, nĩ rî tı̣́tı̣́.” Gõꞌdá gbõ lé ĩtí rî, lı̣̃fı̣́ ãkó lé ꞌbá ꞌdĩ ꞌbá yî drí ngãzó rĩꞌá ôtrélé lậvũlı̣́ gạ̃rạ̃ sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ kĩ nĩ rî, “Nî ĩꞌdî tíbê Ôvârí drí tã lâ âtálé kĩꞌá nĩ rî, âꞌdô ânĩꞌá ãmâ pãlé nõ, ní ndrê ãmâ ĩzã! Ánî ꞌâ ạ̃ậꞌdı̣̂ ãmâ rú! Ní pâ ãmâ!” ");
INSERT INTO avu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gõꞌdá Yésũ drí âdrézó lı̣̃fı̣́ ãkó lé ꞌbá ꞌdĩ ꞌbá yî ậzı̣́lı̣́ ânĩlí yí ngálâ. Gõꞌdá gólĩyî âcâ bê Yésũ lạ̃gạ́tı̣́ rî, Yésũ drí tã îjízó gólĩyî tı̣́ kĩ nĩ rî, “Nĩ lẽ má drí ãꞌdô ꞌẽlé ãnî drí yã?” ");
INSERT INTO avu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Kúmú, ní njı̣̃ ãmâ lı̣̃fı̣́, tãlâ mã ndrê ró võ bê!” ");
INSERT INTO avu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ĩtí rî, gólĩyî ĩzã drí gãzó Yésũ rú. Gõꞌdá Yésũ drí gólĩyî lı̣̃fı̣́ dõzó. Gõꞌdá gólâ dõlé bê gólĩyî lı̣̃fı̣́ rî, kôrô gólĩyî lı̣̃fı̣́ drí rû njı̣̃zó võ ndrẽlé dódó. Nĩngá sĩ rî, drílĩyî ngãzó ꞌdẽlé Yésũ vósĩ. ");
INSERT INTO avu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Gõꞌdá nĩngá sĩ, Yésũ yî nĩ ĩyî bê tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yí bê ãnyî ꞌẽꞌá cãlé Yẽrõsãlémã rú rî, drílĩyî cãzó ꞌbạ̃drı̣̃ mvá zı̣̃lı̣́ Bẽtẽfágẽ rî ꞌálâ únı̣́ gólâ fê dõ kâ zı̣̃lı̣́ õlívĩ rî bê yí drı̣̃ı̣̂ rî lạ̃gạ́tı̣́. Gõꞌdá nĩngá sĩ rî, Yésũ drí tã ârí ꞌbá íyíkâ rı̣̃ rî ꞌbá yî ậzı̣́zó jõlé nĩlí sı̣́sı̣́ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Gõꞌdá Yésũ drí tã âtázó drílĩyî kĩ, “Nĩ nĩ fĩlí ꞌbạ̃drı̣̃ mvá Bẽtẽfágẽ ãmâ ágá ꞌálâ nã ꞌá. Õzõ nĩ õcâ trá tólâ rî, nĩ âꞌdô dõngí ândrê ûsúꞌá mvá lâ bê ólôꞌĩ trá. Ĩtí rî, nĩ âtĩ gólĩyî âjílí má drí nõlé. ");
INSERT INTO avu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Gõꞌdá õzõ õjílã ãzâ ĩîjî ãnî trá kĩꞌá nĩ rî, nĩ rî dõngí ꞌdĩ ꞌbá yî âtĩlí ãꞌdô tãsĩ yã rî, nĩ âtâ kĩ nĩ rî, ‘Kúmú ãmákâ lẽ nĩ, gólâ âꞌdô lôgõꞌá lâ ꞌwãâ vólé.’ ” ");
INSERT INTO avu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yésũ âtâ tã tã ârí ꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ĩtí ꞌdĩ, tãlâ úlı̣́ gólâ tã ậngũ ꞌbá Zẽkãríyã drí âtálé trá ạ̃kû ró nã rî âꞌdô rû ꞌẽꞌá té õzõ drílâ ậngũlı̣́ trá rî kâtí kĩꞌá nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nĩ âtâ tã õjílã Yẽrõsãlémã kâ drí kĩ, ‘Nĩ ndrê drẽ, kúmú ãníkâ rĩꞌá ânĩꞌá ãnî ngálâ. Gólâ lôgõ íyî nyãányâ trá vũdrı̣́, gólâ mbã trá dõngí drı̣̃ı̣̂, gólâ rĩꞌá ânĩꞌá dõngí mvá drı̣̃ı̣̂.’ ” ");
INSERT INTO avu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ĩtí rî, tã ârí ꞌbá rı̣̃ ꞌdî ꞌbá yî drí nĩzó tã ꞌdî ꞌẽlé té õzõ Yésũ drí âtálé ꞌdĩ kâtí. ");
INSERT INTO avu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gólĩyî drí dõngí ândrê ꞌdĩ âtrõzó mvá lâ bê âjílí Yésũ drí. Gõꞌdá drílĩyî ítá ĩyíkâ âtrõzó, ânĩꞌá ꞌbãlâ dõngí ꞌdĩ ꞌbá yî drı̣̃ı̣̂. Gõꞌdá Yésũ drí mbãzó rĩlí dõngí mvá ꞌdĩ drı̣̃ı̣̂, tãlâ yí nĩ ró bê fĩlí drı̣̃ lâ Yẽrõsãlémã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nĩngá sĩ rî, õꞌbí dũû drí ítá ĩyíkâ âtrõzó ꞌbẽlé vũdrı̣́ lạ́tı̣̂ drı̣̃ı̣̂ sĩ. Gõꞌdá õjílã ãzâ ꞌbá yî gólĩyî lãfálé sĩ rî ôŋõ ĩyíkâ mbı̣́rạ́ bı̣́ ĩꞌdî lôꞌbélé vũdrı̣́ lạ́tı̣̂ drı̣̃ı̣̂ sĩ, tãlâ Yésũ õnĩ ró dõngí ꞌdĩ bê drı̣̃ lâ ꞌásĩ. Gólĩyî ꞌê tã ꞌdî ĩtí ꞌdĩ Yésũ rî ı̣̂njı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gólĩyî õtírĩ ꞌbãâ rĩꞌá nĩꞌá rî, õjílã õꞌbí gólĩyî rĩ ꞌbá nĩlí Yésũ yí bê ꞌdĩ ꞌbá yî, gólĩyî ꞌdẽ ꞌbá sı̣́sı̣́ rî ꞌbá yî gõꞌdá gólĩyî ꞌdẽ ꞌbá vólé lésĩ rî ꞌbá yí bê, drílĩyî ngãzó rĩꞌá Yésũ rî lûyı̣́lı̣́ kĩ nĩ rî, “Mã lûyı̣̂ nî kúmú gólâ ꞌbãlé trá ꞌdíyî pã ꞌbá ró rî. Ôvârí õfẽ õrẽ ní drí, nî tíbê ânĩ ꞌbá mbârâkã gólâkâ bê rî. Ôvârí ꞌbũû ꞌálâ rî, rú lâ ãꞌdô lûyı̣́lı̣́ lûyı̣̂ rõô.” ");
INSERT INTO avu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Gõꞌdá Yésũ yî câ bê Yẽrõsãlémã ꞌálâ rî, õjílã ndrĩ jạ̃rı̣́bạ̃ Yẽrõsãlémã kâ ꞌá ꞌdĩ ꞌbá yî drí âꞌdózó lârõ-lârõ ró. Gõꞌdá drílĩyî tã îjízó ĩyî võ ꞌásĩ kĩ nĩ rî, “Ãgô nõ íyíkâ ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gõꞌdá õꞌbí gólĩyî ânĩ ꞌbá Yésũ yí bê ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Nõô Yésũ Nãzãrétã ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî lésĩ, gólâ Ôvârí drí tã lâ ꞌbãlé ꞌẽꞌá âjólâ tã ậngũ ꞌbá ró rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Gõꞌdá nĩngá sĩ rî, Yésũ drí ngãzó nĩlí fĩlí ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌálâ. Gõꞌdá gólâ fî bê tólâ rî, drílâ ngá lậzı̣́ ꞌbá gõꞌdá kpá ãmámõ lậzı̣́ ꞌbá ngá fẽfẽ ró Ôvârí drí rî ꞌbá yî ûsúzó ngá ĩyíkâ lậzı̣́ꞌá lâgî õnjí sĩ. Gõꞌdá gólâ drí kpá õjílã gólĩyî rĩ ꞌbá ậdı̣̂ õrĩ ngĩíngî ı̣̂kúrạ̃lé ậdı̣̂ õrĩ ãzâ ꞌbá yí kâ sĩ rî ûsúzó. Gõꞌdá Yésũ ûsû tã ꞌdî bê ĩtí rî, gólâ drí ngãzó õmbã ró õjílã ꞌdî ꞌbá yí bê. Gólâ drí ngãzó tãrãbízã rĩzó ậdı̣̂ ı̣̂kúrạ̃lé drı̣̃ lâ ꞌá rî drı̣̃ lâ âkólé ndrĩ vũdrı̣́. Gõꞌdá Yésũ drí kpá gbáꞌdá õjílã gólĩyî rĩ ꞌbá ãmámõ ꞌdî ꞌbá yî lậzı̣́lı̣́ gĩlí rî ꞌbá yí kâ drı̣̃ lâ âkózó vũdrı̣́. Nĩngá sĩ, Yésũ drí ngãzó õjílã ꞌdî ꞌbá yî lâdrólé ndrĩ vólé ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌdĩ ꞌásĩ úlı̣́ âtâ-âtâ bê kĩ, ");
INSERT INTO avu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Íîgĩ trá búkũ Ôvârí kâ ꞌá kĩ nĩ rî, ‘Jó ámákâ rĩꞌá võ gólâ rĩzó rãtáã ꞌẽlé má drí ꞌá lâ rî ĩꞌdî.’ Ĩsáyã 56.7 Gõꞌdá nĩ jâ jó ámákâ ꞌdĩ trá âꞌdólé võ ũgú yî drí rĩzó ngá ĩyíkâ lậpı̣́lı̣́ ꞌá lâ rî kâ ró.” ");
INSERT INTO avu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nĩngá sĩ rî, õjílã gólĩyî lı̣̃fı̣́ ãkó lé ꞌbá ró rî ꞌbá yî gõꞌdá gólĩyî õŋõ ró rî ꞌbá yí bê, drílĩyî ânĩzó Yésũ ngálâ ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌdĩ ꞌá. Gõꞌdá Yésũ drí õjílã ꞌdî ꞌbá yî êdézó âcálé dódó ngá lãzé gólĩyíkâ ꞌdĩ ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá kpá lãꞌbí îmbá ꞌbá rî ꞌbá yí bê, ndrê ĩyî tã lârâkô Yésũ drí ꞌẽlé ꞌdĩ ꞌbá yî bê, gõꞌdá gólĩyî ârî ꞌdĩyímvá bê rĩꞌá ĩyî ôtréꞌá Yésũ rî lûyı̣̂-lûyı̣̂ bê kĩ nĩ rî, “Mã lûyı̣̂ nî gólâ kúmú, Dạ̃wúdı̣̃ rî ózõwá ró” rî, drílĩyî âꞌdózó ạ̃wạ̃ ró Yésũ rú. ");
INSERT INTO avu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ĩtí rî, drílĩyî Yésũ rî îjízó kĩ, “Ní ârî tã ꞌdĩyímvá ꞌdĩ ꞌbá yî drí rĩꞌá âtálâ ꞌdĩ trá yã? Gólĩyî rî rĩꞌá ánî lûyı̣́lı̣́ ĩtí ꞌdĩ ãꞌdô tãsĩ yã?” Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Ãwô, má ârî tã gólĩyíkâ ꞌdĩ trá. Nĩ zı̣́ tã gólâ Dạ̃wúdı̣̃ drí âtálé Ôvârí drí kĩꞌá nĩ rî, ‘Ní ꞌbã ꞌdĩyímvá õnyíkõ trá ꞌdĩyímvá õdé bê ánî lûyı̣́lı̣́ ĩyî tı̣̂ sĩ’ rî kô yã?” ");
INSERT INTO avu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nĩngá sĩ, Yésũ drí ngãzó drı̣̃-ꞌbá ꞌdĩ ꞌbá yî âyélé. Drílâ fõzó vólé Yẽrõsãlémã ꞌásĩ. Drílâ nĩzó jạ̃rı̣́bạ̃ Bẽtánĩ kâ rî ꞌálâ. Gõꞌdá drílâ ậꞌdú kõzó ãkpã tólâ. ");
INSERT INTO avu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gõꞌdá nĩngá sĩ, kậyı̣̂ drı̣̃zõ lâ ãzâ rî sĩ ãkpãkãꞌdã cı̣̃ı̣́nó, Yésũ yî drí ngãzó nĩꞌá gõlé lãjóꞌbá íyíkâ yí bê Yẽrõsãlémã ꞌálâ. Gõꞌdá lạ́tı̣̂ drı̣̃ı̣̂ sĩ rî, gólâ gõꞌdá trá lõfó ró. ");
INSERT INTO avu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Gõꞌdá gólâ drí kãnágõwá fê ndrẽzó lạ́tı̣̂ gãrã drı̣̃ ꞌá bı̣́ bê ngbũkpũ. Gõꞌdá drílâ nĩzó kãnágõwá fê ꞌdĩ lõꞌwâ lâ ndrẽlé, ãꞌdô ró bê yí drí nyãlé lõfó drí. Gõꞌdá gólâ ûsú lõꞌwâ lâ kô. Gólâ ûsû cé bı̣́ lâ ĩꞌdî. Tã ꞌdî tãsĩ rî, Yésũ drí kãnágõwá fê ꞌdĩ trĩzó kĩ, “Ní îcâ áníkâ lõꞌwâ ãzãkã ꞌwãlé kó kô.” Gõꞌdá kôrô fê ꞌdĩ drí ândrázó drãlé. ");
INSERT INTO avu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ĩtí rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ndrê ĩyî bê tã gólâ rû ꞌẽ ꞌbá ꞌdĩ ĩtí rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó ndrúndrú. Gõꞌdá drílĩyî tã îjízó Yésũ tı̣́ kĩ nĩ rî, “Fê ꞌdĩ ândrâ ꞌwãâ drãlé ĩtí ꞌdĩ ángô tí ró yã?” ");
INSERT INTO avu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ nĩ ãꞌdô cú tã lẽlẽ bê Ôvârí ꞌá gõꞌdá tã ı̣̂sũ ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî ãꞌdô kô rı̣̃ rı̣̃ rî, nĩ âꞌdô îcáꞌá cú tã gólâ má drí ꞌẽlé fê nõ drí nõ ꞌẽlé, gõꞌdá nĩ âꞌdô îcáꞌá cú tã ãzâ ꞌbá yî ꞌẽlé gạ̃rạ̃ nõô drı̣̃ı̣̂ sĩ. Õzõ nĩ ãâtâ tã únı̣́ ạ́ngı̣́ drí kĩ, ‘Ní ngâ nĩꞌá ꞌdẽlé lı̣̃mvû ândrê ꞌá’ rî, tã rî ꞌdĩ âꞌdô rû ꞌẽꞌá, õzõ ãnî drí âtálé ꞌdĩ kâtí. ");
INSERT INTO avu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Õzõ nĩ ãꞌdô cú tã lẽlẽ bê ĩtí rî, ngá gólâ ãnî drí tã lâ îjílí Ôvârí tı̣́ rãtáã sĩ rî, nĩ âꞌdô ûsúꞌá lâ.” ");
INSERT INTO avu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Gõꞌdá nĩngá sĩ rî, Yésũ drí nĩzó gõlé kpá óꞌdí ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌdĩ ꞌá Yẽrõsãlémã ꞌálâ. Drílâ îtõzó rĩꞌá õjílã îmbálé. Gólâ õtírĩ ꞌbãâ tã îmbáꞌá rî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá gólĩyî âꞌdó ꞌbá sı̣́sı̣́-lésĩ ró rî ꞌbá yí bê rî drí ânĩzó ĩyî tã îjílí Yésũ tı̣́ kĩ, “Ní ûsû áníkâ drı̣́-ãcê tã nô ꞌbá yî ꞌẽzó ãꞌdô ꞌásĩ yã? Ãꞌdî fẽ drı̣́-ãcê nĩ ní drí rĩzó tã gólĩyî ní drí rĩꞌá ꞌẽlâ ꞌdĩ ꞌbá yî ꞌẽlé yã?” ");
INSERT INTO avu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ĩtí rî, Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Õzõ nĩ õlẽ trá nı̣̃lâ kĩꞌá nĩ, ãꞌdî fẽ drı̣́-ãcê nĩ má drí tã ꞌdî ꞌbá yî ꞌẽzó yã rî, má lẽ ãnî îjílí tã îjî ãzâ sĩ, õzõ nĩ õlôgõ tã îjî ámákâ ꞌdĩ drı̣̃ lâ trá rî, má drí gõzó gólâ tíbê drı̣́-ãcê fẽ ꞌbá má drí rî âꞌdálé ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nĩ âꞌdâ drẽ tã má drí, tã Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî kâ tãsĩ, ãꞌdî fẽ drı̣́-ãcê gólâ drí rĩzó bãbãtízĩ ꞌẽlé õjílã drí rî nĩ, Ôvârí fẽ nĩ ngãtá õjílã mvá fẽ nĩ yã?” Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ârî ĩyî tã Yésũ drí îjílí ꞌdĩ bê rî, drílĩyî ngãzó rĩꞌá tã ôjálé ĩyî võ ꞌásĩ kĩ, “Õzõ mã ãâtâ tã kĩ nĩ rî, Ôvârí õfẽ drı̣́-ãcê nĩ Yõwánĩ drí rî, Yésũ âꞌdô ãmâ îjíꞌá kĩ, mã lẽé tã kô tã Yõwánĩ drí pẽlé rî ꞌá ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gõꞌdá õzõ mã ãâtâ kĩ nĩ rî, õjílã mvá õfẽ drı̣́-ãcê nĩ Yõwánĩ drí rî, ãmâ rĩꞌá ũrı̣̃ ró tã õjílã drí ꞌẽꞌá ꞌẽlâ ãmâ drí rî tãsĩ, tãlâ gólĩyî âꞌdô ngãꞌá ạ̃wạ̃ ró ãmá bê. Gólĩyî ndrĩ nı̣̃ ĩyî trá kĩ nĩ rî, Yõwánĩ rĩꞌá tã ậngũ ꞌbá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Mã nı̣̃ı̣́ kô ãꞌdî fẽ drı̣́-ãcê nĩ Yõwánĩ drí yã rî.” Gõꞌdá Yésũ drí kpá tã âtázó drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Má îcá kpá kô âꞌdálâ ãnî drí ngãtá ãꞌdî fẽ drı̣́-ãcê nĩ má drí yã rî.” ");
INSERT INTO avu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Gõꞌdá nĩngá sĩ rî, Yésũ drí ngãzó íꞌdígówá ãgô ãzâ mvá bê rı̣̃ rî kâ ngĩlí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí. Gólâ kĩ, “Ãgô ãzâ bê rĩꞌá mvá ágó bê rı̣̃. Drílâ ngãzó tã âtálé íyî mvá sı̣́sı̣́ rî drí kĩ, ‘Ámâ mvá, ní nĩ ãndrõ nĩꞌá ngá ꞌwãlé má drí ạ́mvú ꞌálâ.’ ");
INSERT INTO avu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Gõꞌdá mvá ꞌdĩ drí tã-drı̣̃ lôgõzó íyî átá drí kĩ nĩ rî, ‘ꞌÉꞌẽ, má lẽé kô.’ Gõꞌdá tã ꞌdî vósĩ rî, drílâ gõzó tã ı̣̂sũ íyíkâ jãlé, drílâ gõzó nĩlí ngá ꞌwãlé. ");
INSERT INTO avu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gõꞌdá ãgô ꞌdĩ drí kpá tã ãlô-ãlô ꞌdĩ âtázó íyî mvá ạ̃dũ rî drí. Gõꞌdá mvá ạ̃dũ rî drí tã-drı̣̃ lôgõzó átá lâ drí kĩ, ‘Ãwô, tátá, má âꞌdô nĩꞌá ngá ꞌwãlé.’ Gõꞌdá gólâ nĩí kô.” ");
INSERT INTO avu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gõꞌdá Yésũ drí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî îjízó kĩ, “ꞌDĩyímvá rı̣̃ ꞌdî ꞌbá yî lãfálé sĩ rî, mvá gólâ ángô rî ꞌê tã átá lâ drí lẽlé rî nĩ yã?” Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Mvá gólâ sı̣́sı̣́ rî ĩꞌdî.” Gõꞌdá Yésũ drí tã âtázó drílĩyî kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, bélé-bélé ûꞌdú ꞌbá õnjí rî ꞌbá yî gõꞌdá õkó gólĩyî ãgô kpã ꞌbá ró rî ꞌbá yí bê, gólĩyî ãnî drí ndrẽlé tã õnjí ꞌbá ró rî âꞌdô ĩyî rû jãꞌá nĩ sı̣́sı̣́ ãnî drí sĩ tã lẽlé Ôvârí ꞌá âꞌdózó õjílã Ôvârí kâ ró. ");
INSERT INTO avu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gõꞌdá tã âꞌdálâ ĩꞌdî nõ, Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî ânĩ bê lạ́tı̣̂ mbı̣̂ âꞌdálé ãnî drí âꞌdózó tã mbı̣̂ ꞌẽ ꞌbá ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî, nĩ gâ vólé trá dó tã lẽlé úlı̣́ Ôvârí kâ gólâ drí pẽlé rî ꞌá. Gõꞌdá bélé-bélé ûꞌdú ꞌbá yî gõꞌdá õkó gólĩyî ãgô kpã ꞌbá ró rî yí bê, gólĩyî lẽ tã trá tã Yõwánĩ drí pẽlé ꞌdĩ ꞌá. Gõꞌdá nĩ ndrê tã gólĩyî drí ꞌẽlé ꞌdĩ bê rî, nĩ gâ vólé trá dó drı̣̃ âjálé tã õnjí ãníkâ ꞌásĩ tã lẽzó úlı̣́ Ôvârí kâ Yõwánĩ drí pẽlé ãnî drí ꞌdĩ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Gõꞌdá nĩngá sĩ rî, Yésũ drí úlı̣́ mãnĩgõ ãzâ âtázó drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí. Gólâ kĩ, “Nĩ ârî drẽ, ãgô ãzâ bê rĩꞌá ạ́mvú ạ́ngı̣́ íyíkâ bê. Gólâ drí fê õzõ âlâꞌbâ kâtí gólâ rĩzó õdrá ꞌẽlé lõꞌwâ lâ ꞌásĩ rî ı̣̂ꞌdı̣́zó dũû ạ́mvú íyíkâ ꞌdĩ ꞌásĩ. Gõꞌdá drílâ ndõgõ gãzó dîrî gbãâ ạ́mvú íyíkâ ꞌdĩ rú sĩ, tãlâ ũgú gõꞌdá kõrõnyã bê õzó lạ́tı̣̂ ûsú âfízó ạ́mvú íyíkâ ꞌdĩ ꞌá kô. Gõꞌdá ạ́mvú lı̣́pı̣̂ ꞌdĩ drí võ ãzâ êdézó gũạ̃lı̣̃-gũạ̃lı̣̃ kúnı̣́ ꞌá, tãlâ rĩzó õdrá ꞌdĩ zãlé ꞌá lâ. Gõꞌdá drílâ kpãrá êdézó ãcê ûrû, tãlâ õjílã gólâ rĩ ꞌbá ạ́mvú íyíkâ ꞌdĩ vó lâ ndrẽlé rî drí mbãzó rĩlí drı̣̃ lâ ꞌá rĩꞌá võ lôndrélé. Nĩngá sĩ, ạ́mvú lı̣́pı̣̂ ꞌdĩ drí ạ́mvú ꞌwã ꞌbá ãzâ ꞌbá yî ậzı̣́zó ânĩꞌá lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌá nĩngá. Gõꞌdá drílĩyî tã ı̣̂ꞌbı̣̃zó ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yí bê fê ạ́mvú íyíkâ ꞌá ꞌdĩ ꞌbá yî lõꞌwâ lâ yî lãfálé lâ cãlé gólĩyí bê. Nĩngá sĩ, ạ́mvú lı̣́pı̣̂ ꞌdĩ drí ngãzó nĩlí ậcı̣́ íyíkâ ꞌá jẽjẽ ró ꞌbạ̃drı̣̃ ãzâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gõꞌdá kậyı̣̂ fê lõꞌwâ ꞌdĩ ꞌbá yî drí kãzó rĩzó ôkílâ rî âcâ bê rî, ạ́mvú lı̣́pı̣̂ drí lãjóꞌbá íyíkâ ãzâ ꞌbá yî jõzó ạ́mvú ꞌwã ꞌbá íyíkâ ꞌdĩ ꞌbá yî ngálâ, nĩꞌá fê lõꞌwâ gólâ íyíkâ ró rî âtrõlé âjílí yí drí. ");
INSERT INTO avu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî câ ĩyî bê ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ rî, ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí ngãzó ꞌdẽlé lãjóꞌbá ꞌdĩ ꞌbá yî drı̣̃ı̣̂. Drílĩyî lãjóꞌbá ãlô rî rũzó cãlé, gõꞌdá drílĩyî lãjóꞌbá ãzâ rî fũzó, gõꞌdá drílĩyî lãjóꞌbá ãzâ nâ lâ ró rî lûvũzó kúnı̣́ mvá sĩ. ");
INSERT INTO avu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Gõꞌdá ạ́mvú lı̣́pı̣̂ ꞌdĩ ârî tã õnjí ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí ꞌẽlé ꞌdĩ bê rî, drílâ gõzó kpá óꞌdí lãjóꞌbá íyíkâ ãzâ ꞌbá yî jõlé lậvũlı̣́ gạ̃rạ̃ lãjóꞌbá gólâ drí jõlé sı̣́sı̣́ rî ꞌbá yî drı̣̃ı̣̂ sĩ. Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî câ ĩyî bê ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ rî, ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí tã gólĩyî drí ꞌẽlé lãjóꞌbá ạ́mvú lı̣́pı̣̂ kâ âjólé sı̣́sı̣́ rî ꞌbá yî drí rî ꞌẽzó kpá lãjóꞌbá âjólé ꞌdĩ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Gõꞌdá ạ́mvú lı̣́pı̣̂ ꞌdĩ ârî tã gólâ rû ꞌẽ ꞌbá lãjóꞌbá íyíkâ jõlé ꞌdĩ ꞌbá yî drí rî bê rî, gólâ drí tã ı̣̂sũzó kĩ nĩ rî, ‘Má âꞌdô ámâ mvá nyãányâ rî jõꞌá ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ. Ãzângá sĩ, gólĩyî âꞌdô gólâ rî ı̣̂njı̣̃ꞌá.’ Gõꞌdá ạ̃dũkũ lâ ró, ạ́mvú lı̣́pı̣̂ drí gõzó íyî mvá rî jõlé gólĩyî ngálâ. ");
INSERT INTO avu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gõꞌdá ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ndrê ĩyî ạ́mvú lı̣́pı̣̂ rî mvá bê rĩꞌá ânĩꞌá ĩyî ngálâ rî, drílĩyî tã ı̣̂ꞌbı̣̃zó ĩyî võ ꞌásĩ kĩ, ‘ꞌDĩî ạ́mvú lı̣́pı̣̂ rî mvá ĩꞌdî ꞌẽ ꞌbá ngá nõ ꞌbá yî trõlé ndrĩ drı̣́-vó ró yí drí rî. Ãꞌdô ĩtí rî, mã fû gólâ vólé, tãlâ mã trõ ró bê ạ́mvú ꞌẽ ꞌbá âꞌdólé drı̣́-vó gólâkâ ró nõ ngá ndrĩ ꞌá lâ nõ ꞌbá yí bê ãmâ nyãányâ drí.’ ");
INSERT INTO avu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gõꞌdá ạ́mvú lı̣́pı̣̂ ꞌdĩ mvá lâ âcâ bê gólĩyî ngálâ rî, drílĩyî gólâ rî rũzó sẽlé lôfõlé vólé ạ́mvú ꞌásĩ. Gõꞌdá drílĩyî gólâ rî fũzó.” ");
INSERT INTO avu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nĩngá sĩ, Yésũ drí tã îjízó drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî tı̣́ kĩ nĩ rî, “Tã ı̣̂sũ ãníkâ ꞌá rî, õzõ ạ́mvú lı̣́pı̣̂ ãâgõ trá âcálé rî, gólâ âꞌdô ãꞌdô tã ꞌẽꞌá ĩꞌdî ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí yã?” ");
INSERT INTO avu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Ạ́mvú lı̣́pı̣̂ ꞌdĩ âꞌdô õjílã õnjí tẽtẽ ꞌdî ꞌbá yî ûfúꞌá. Gõꞌdá drílâ gõzó ạ́mvú ꞌwã ꞌbá tãndí gólĩyî ꞌẽ ꞌbá lõꞌwâ íyíkâ ró rî fẽlé yí drí mbı̣̂ kậyı̣̂ fê lõꞌwâ ꞌdĩ ôkî-ôkî kâ sĩ ãzâ ꞌbá yî ậzı̣́lı̣́, ânĩꞌá lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌá nĩngá.” ");
INSERT INTO avu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Gõꞌdá Yésũ drí tã âtázó drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Tã ãnî drí lôgõlé má drí ꞌdĩ rĩꞌá tã mbı̣̂ ꞌî. ꞌDõvó nĩ ı̣̂sũ drẽ ãnî nyãányâ tã.” Gõꞌdá Yésũ drí gõzó tã îjílí gólĩyî tı̣́ kĩ, “Nĩ zı̣́ tã gólâ îgĩlí búkũ Ôvârí kâ ꞌá ámâ tãsĩ rî kô kĩꞌá nĩ rî, ‘Jó ậjû gólâ jó ꞌdı̣̃ ꞌbá yî drí gãlé trá dó rî, gólâ trá ĩꞌdî ậjû tãndí jó kâ tã lâ drí lâzélé gạ̃rạ̃ rî ró, tãlâ gólâ ĩꞌdî mbârâkã jó-drı̣̃ kâ ꞌî. Ôvârí ꞌê tã rî ꞌdĩ nĩ âꞌdólé ĩtí. Tã rî ꞌdĩ rĩꞌá tã gólâ ãmâ tı̣̂ drí ậꞌdı̣́zó tã lâ tãsĩ rî ĩꞌdî.’ ” ");
INSERT INTO avu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Gõꞌdá Yésũ drí tã âtázó drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí kĩ, “Tãlâ nĩ gâ vólé trá dõ tã lẽlé má ꞌá rî drí sĩ rî, ândrâ-tãndĩ gólâ Ôvârí drí ꞌẽꞌá fẽlâ ãnî drí âꞌdózó õjílã íyíkâ ró rî, Ôvârí âꞌdô ꞌẽꞌá trõlâ vólé ãnî drı̣́gạ́ sĩ fẽlé õjílã ãzâ ꞌbá yî gólĩyî tíbê ꞌẽ ꞌbá ĩyî tã gólâ Ôvârí drí lẽlé ꞌẽlé rî ꞌbá yî drí, ãꞌdô ró bê drílĩyî lõꞌwâ tãndí ꞌwãzó Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ĩtí rî, õzõ õjílã ãzâ ũsı̣̃ íyî pá trá jó ậjû ꞌdĩ rú rî, gólâ rî pá âꞌdô ŋõꞌá. Gõꞌdá õzõ jó ậjû ꞌdĩ ãâꞌdê õjílã rî ꞌdĩ drı̣̃ı̣̂ rî, âꞌdô gólâ rî ôŋõꞌá cĩnyí-cĩnyí.” ");
INSERT INTO avu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ârî ĩyî úlı̣́ mãnĩgõ gólĩyî Yésũ drí âtálé ꞌdĩ ꞌbá yî bê rî, gólĩyî nı̣̃ trá kĩ nĩ rî, Yésũ rî úlı̣́ ꞌdĩ ꞌbá yî âtálé ꞌdĩ ĩyî rú. ");
INSERT INTO avu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ĩtí rî, drílĩyî rĩzó lạ́tı̣̂ lôndãlé ꞌẽzó Yésũ rî rũlı̣́. Gõꞌdá gólĩyî îcá kô tã rî ꞌdĩ ꞌẽlé ꞌwãâ ró, tãlâ gólĩyî rĩꞌá ũrı̣̃ ró õꞌbí ꞌdĩ ꞌbá yî drí sĩ, tãlâ õꞌbí ꞌdĩ ꞌbá yî nı̣̃ ĩyî trá kĩ nĩ rî, Yésũ rĩꞌá tã ậngũ ꞌbá Ôvârí kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ drí kpá íꞌdígówá ãzâ ngĩzó õjílã Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã õjílã drí ꞌẽzó rĩlí kũmũ Ôvârí kâ zẽlé rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Gólâ kĩ, “Tã rĩrĩ kâ kũmũ Ôvârí kâ zẽlé rî rĩꞌá õzõ kúmú ạ́ngı̣́ ãzâ kãrámã lãgĩ kâ êdé ꞌbá mvá lâ drí rî kâtí. Gõꞌdá kúmú ꞌdĩ êdê kãrámã lãgĩ kâ ꞌdĩ bê njãâ rî, gólâ âtâ tã trá õjílã dũû ãânĩ ró ĩyî kãrámã rî ꞌdĩ ꞌá ũmú ró. ");
INSERT INTO avu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Gõꞌdá kậyı̣̂ gólâ ꞌẽzó kãrámã lãgĩ kâ ꞌdĩ ꞌẽlé rî âcâ bê rî, kúmú ꞌdĩ drí rû ı̣̂ꞌbũ ꞌbá íyíkâ jõzó nĩꞌá tã âtálé õjílã gólĩyî yí drí ậzı̣́lı̣́ rî ꞌbá yî drí, gólĩyî ãânĩ ró ĩyî kãrámã ꞌdî ꞌá. Gõꞌdá õjílã gólĩyî ậzı̣́lı̣́ ꞌdĩ ꞌbá yî lẽé ĩyî kô ânĩlí kãrámã rî ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Gõꞌdá õjílã ậzı̣́lı̣́ ꞌdĩ ꞌbá yî lẽé ĩyî bê kô ânĩlí rî, gõꞌdá kúmú ꞌdĩ drí rû ı̣̂ꞌbũ ꞌbá íyíkâ ãzâ ꞌbá yî jõzó kpá óꞌdí võrã bê tã âtálé õjílã gólĩyî gólâ drí ậzı̣́lı̣́ sı̣́sı̣́ ꞌdĩ ꞌbá yî drí ãlô-ãlô kĩ, ‘Nĩ ndrê drẽ, má fû ı̣́tı̣́ trá dũû. Má êdê ngá trá ndrĩ njãâ, nĩ ânĩ ꞌwãâ kãrámã nyãlé.’ ");
INSERT INTO avu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Gõꞌdá õjílã võrã jõzó gólĩyî vó ꞌdĩ ꞌbá yî drí vólé gãzó dó tã rû ı̣̂ꞌbũ ꞌbá jõlé ꞌdĩ ꞌbá yí kâ ârílí, tãlâ gólĩyî rî ĩyîngá trá lôsĩ ĩyî nyãányâ kâ ꞌẽlé ĩꞌdî. Ãzâ ꞌbá yî nĩ ĩyîngá trá ngá ꞌwãlé ĩꞌdî ĩyî drí ạ́mvú ꞌálâ. Gõꞌdá ãzâ ꞌbá yî nĩ ĩyîngá trá võ ĩyíkâ lôsĩ kâ ãzâ ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gõꞌdá õjílã gólĩyî ậzı̣́lı̣́ ꞌdĩ ꞌbá yî lãfálé ꞌásĩ rî, ãzâ ꞌbá yî drí ngãzó ꞌdẽlé rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drı̣̃ı̣̂ gólĩyî rũlı̣́ cãlé õnjí tẽtẽ ró, gõꞌdá drílĩyî rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî ũrûkậ ꞌbá yî ûfúzó. ");
INSERT INTO avu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gõꞌdá kúmú ꞌdĩ ârî tã rû ꞌẽ ꞌbá ꞌdĩ bê ĩtí rî, gólâ drí âꞌdózó ạ̃wạ̃ ró rõô. Gõꞌdá drílâ ngãzó ạ̃jú ꞌbũ ꞌbá íyíkâ rî ꞌbá yî jõlé, nĩꞌá õjílã ꞌdî ꞌbá yî ûfúlı̣́ gõꞌdá kpá jạ̃rı̣́bạ̃ gólĩyíkâ lôzãlé vólé. ");
INSERT INTO avu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“ꞌDĩî vósĩ rî, kúmú ꞌdĩ drí rû ı̣̂ꞌbũ ꞌbá gólâkâ ũrûkậ lâ âgõ ꞌbá ꞌdĩ ꞌbá yî ậzı̣́zó ânĩlí yí ngálâ, gõꞌdá drílâ tã âtázó drílĩyî kĩ, ‘Nĩ ndrê drẽ, õjílã gólĩyî má drí ậzı̣́lı̣́ sı̣́sı̣́ rî ꞌbá yî rĩꞌá õjílã õnjí ꞌî. Gólĩyî âꞌdó kô õjílã tãndí îcálé ậzı̣́lı̣́ rî yî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tã ꞌdî tãsĩ rî, nĩ ngâ nĩlí lạ́tı̣̂ rû ûsûmậ ꞌásĩ, õjílã gólĩyî tíbê ãnî drí ûsúlı̣́ rî, nĩ ậzı̣̂ gólĩyî ãânĩ ró ĩyî bê kãrámã ámákâ nõ ꞌá.’ ");
INSERT INTO avu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí nĩzó ĩyî tã ꞌdî ꞌẽlé õzõ kúmú ꞌdĩ drí âtálé trá gólĩyî drí ꞌdĩ kâtí. Drílĩyî nĩzó õjílã gólĩyî drí ûsúlı̣́ tãndí ró rî ꞌbá yî, gõꞌdá kpá õnjí ró rî ꞌbá yí bê êꞌbélé ậdrı̣̃lı̣́ ânĩzó gólĩyí bê võ kãrámã kâ ꞌá. Ĩtí rî, jó gólâ kãrámã kâ ꞌdĩ drí âꞌdózó ũmú bê dũû. ");
INSERT INTO avu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Gõꞌdá nĩngá sĩ rî, kúmú kãrámã lı̣́pı̣̂ ró ꞌdĩ drí ngãzó fĩlí jó kãrámã kâ ꞌdĩ ꞌá, nĩꞌá nî-bê-yã ꞌẽlé ũmú íyíkâ ꞌdĩ ꞌbá yî drí. Gólâ fî bê tólâ rî, gólâ drí ũmú ãzâ gólâ ítá lãgĩ kâ sõ ꞌbá kô rî ûsúzó ũmú ꞌdĩ ꞌbá yî lãfálé ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nĩngá sĩ, kúmú kãrámã lı̣́pı̣̂ ró ꞌdĩ drí tã îjízó ũmú rî gógó ꞌdĩ tı̣́ kĩ nĩ rî, ‘Ámâ rû-lẽ-ãzíyã, ní âfî nõngá cú ĩtí ítá lãgĩ kâ ãkó nõ ángô tí ró yã?’ Gõꞌdá ãgô ꞌdĩ îcá kô tã lôgõlé kãrámã lı̣́pı̣̂ ꞌdĩ drí. Gólâ rî trá tı̣́tı̣́ ró. ");
INSERT INTO avu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Gõꞌdá kúmú ꞌdĩ drí tã ꞌbãzó rû ı̣̂ꞌbũ ꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, ‘Nĩ ômbê pá lâ yî drı̣́ lâ yí bê, nĩ vũ ró gólâ ĩví ꞌálâ ı̣́nı̣́rı̣́kúwạ́ ꞌá. Tólâ gólâ âꞌdô ãwó ngõꞌá sı̣́-gílí nyãnyã bê.’ ” ");
INSERT INTO avu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Gõꞌdá ạ̃dũkũ lâ ró, Yésũ drí tã âtázó kĩ nĩ rî, “Nĩ ndrê drẽ, Ôvârí ậzı̣̂ õjílã trá dũû âꞌdólé õjílã íyíkâ ró. Gõꞌdá gólâ njĩ õjílã trá cé dã âꞌdólé õjílã íyíkâ ró. ꞌDĩî õjílã gólĩyî ꞌẽ ꞌbá tã gólâkâ ꞌẽlé rî ꞌbá yî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Gõꞌdá nĩngá sĩ rî, Pạ̃rúsı̣̃ yî drí nĩzó rû êꞌbélé võ ãlô ꞌá tã ı̣̂ꞌbı̣̃lı̣́, ãꞌdô ró bê ĩyî drí lạ́tı̣̂ lôndãzó Yésũ rî ûjũlı̣́ ngãtá gólâ âꞌdô úlı̣́ ányâ âtáꞌá yã rî. ");
INSERT INTO avu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nĩngá sĩ, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí õjílã ĩyíkâ ãzâ ꞌbá yî jõzó õjílã kúmú Ẽródẽ kâ ãzâ ꞌbá yí bê, nĩꞌá Yésũ rî ûjũlı̣́ tã îjî sĩ. Gõꞌdá gólĩyî câ bê Yésũ ngálâ rî, drílĩyî tã îjízó Yésũ tı̣́ kĩ nĩ rî, “Tã îmbá ꞌbá, mã nı̣̃ trá, ı̣́ı̣̂njı̣̃ nî trá tã mbı̣̂ ꞌẽ ꞌbá ró. Ní rî tã gólĩyî mbı̣̂ Ôvârí kâ rî îmbálé ĩꞌdî õjílã drí ꞌẽlé. Ní âꞌdó kô ũrı̣̃ ró tã ı̣̂sũ õjílã kâ ányâ ró tã îmbâ áníkâ rú rî tãsĩ. Ní rí kô lı̣̃fı̣́ ꞌbãlé ãmbã gólĩyíkâ drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ní âꞌdâ drẽ tã ı̣̂sũ áníkâ rî ãmâ drí. Rĩꞌá mbı̣̂ ãmâ drí ômbê gĩzó kúmú ạ́ngı̣́ Rómã kâ drí, ngãtá âꞌdó kô rĩꞌá mbı̣̂ yã?” ");
INSERT INTO avu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Gõꞌdá Yésũ nı̣̃ tã ı̣̂sũ Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yí kâ gõꞌdá õjílã Ẽródẽ kâ rî ꞌbá yí bê drílĩyî ꞌẽzó íyî mãndĩkã lôꞌbãlé ꞌdĩ bê rî, gólâ drí ngãzó tã âtálé drílĩyî mbârâkã sĩ kĩ nĩ rî, “Ãnî gólĩyî âꞌdó ꞌbá tã ậnjú ꞌbá ró nõ ꞌbá yî, nĩ lẽ ámâ ûjũlı̣́ ámâ mãndĩkã lôꞌbã-lôꞌbã ꞌdî sĩ ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nĩ âꞌdâ drẽ ậdı̣̂ tíbê ãnî drí ꞌẽzó ômbê gĩlí ĩꞌdî sĩ lâ ꞌdĩ ãlô rî má ndrê ró bê.” Gõꞌdá drílĩyî ậdı̣̂ rî ꞌdĩ ãlô rî âtrõzó fẽlé Yésũ drí ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Gõꞌdá Yésũ drí gólĩyî îjízó kĩ, “Nõô ãꞌdî rî líndrí ꞌî ậdı̣̂ ífí nõ rú, gõꞌdá rú îgĩlí rú lâ ꞌá nõ bê yã?” ");
INSERT INTO avu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “ꞌDĩî rĩꞌá kúmú ạ́ngı̣́ Rómã kâ Sízã rî líndrí ꞌî gõꞌdá rú lâ bê ꞌdĩ.” Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kĩ, “Õzõ ãꞌdô ĩtí rî, gólâ ĩꞌdî lãfâ ꞌdĩ lı̣́pı̣̂ lâ ꞌî, nĩ lôgõ lãfâ ꞌdĩ vólé gólâ drí ômbê gĩgĩ sĩ. Gõꞌdá ãnî rî gógó ífífí lâ ãnî lı̣́pı̣̂ rĩꞌá Ôvârí ĩꞌdî, nĩ fẽ ãnî nyãányâ gólâ drí tã gólâ drí lẽlé ãnî drí ꞌẽlé rî ꞌẽzó.” ");
INSERT INTO avu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gõꞌdá gólĩyî ârî ĩyî tã Yésũ drí âtálé ꞌdĩ bê rî, gólĩyî tı̣̂ drí ậꞌdı̣́zó ndrúndrú, gõꞌdá drílĩyî ngãzó lậꞌbúlı̣́ Yésũ rî âyélé. ");
INSERT INTO avu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gõꞌdá kậyı̣̂ ãlô-ãlô ꞌdĩ sĩ rî, Sạ̃dúsı̣̃ ãzâ ꞌbá yî drí kpá ânĩzó ĩyî Yésũ rî ûjũlı̣́ tã îjî sĩ tã lîdrî-lîdrî kâ õdrã ꞌásĩ rî tãsĩ. Sạ̃dúsı̣̃ ꞌdĩ ꞌbá yî tã ı̣̂sũ gólĩyíkâ ꞌá rî, gólĩyî kĩ nĩ rî, õzõ õjílã õdrã trá rî, gólâ îcá kô lîdrílí kpá óꞌdí õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Gõꞌdá drílĩyî tã îjízó Yésũ tı̣́ kĩ, “Tã îmbá ꞌbá, tã îmbâ Músạ̃ kâ ꞌbãlé ãmâ drí rî rĩꞌá nõtí, ‘Õzõ nî ãzâ ánî ậdrúpı̣̃ õdrã trá õkó lâ rî âyélé cú ĩtí mvá ãkó rî, nî ậdrúpı̣̃ lâ ꞌdĩ âꞌdô ạ̃yı̣́zı̣́ ꞌdĩ trõꞌá, ãꞌdô ró bê mvá tı̣̃zó ánî ậdrúpı̣̃ ạ̃ꞌdı̣́ ró ꞌdĩ võ lâ ꞌá.’ ");
INSERT INTO avu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ãꞌdô ĩtí rî, mã lẽ tã ı̣̂sũ áníkâ nı̣̃lı̣́ tã nô tãsĩ. Õjílã ãzâ ꞌbá yî bê rĩꞌá ĩyî njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdó ậdrúpı̣̃ ró õjílã ãmákâ lãfálé sĩ. Gõꞌdá gólĩyî ậdrúpı̣̃ sı̣́sı̣́ rî drí õkó trõzó, gõꞌdá drílâ drãzó drẽ ãkpãkãꞌdã tı̣́ ĩyî mvá kô õkó lâ ꞌdĩ bê. Gõꞌdá ậdrúpı̣̃ gólâ ꞌdẽ ꞌbá sı̣́sı̣́ rî vó rî drí ạ̃yı̣́zı̣́ ꞌdĩ trõzó ãꞌdô ró bê mvá tı̣̃zó ậdrúpı̣̃ lâ ꞌdĩ võ lâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Gõꞌdá drílâ kpá drãzó drẽ ãkpãkãꞌdã tı̣́ ĩyî mvá kô ạ̃yı̣́zı̣́ ꞌdĩ bê. Gõꞌdá tã ãlô-ãlô ꞌdĩ drí kpá rû ꞌẽzó ậdrúpı̣̃ gólâ nâ lâ ró rî drí, gõꞌdá kpá ậdrúpı̣̃ ạ̃mbúkũ ꞌdî ꞌbá yî drí ndrĩ ĩtí, gólĩyî drí ạ̃yı̣́zı̣́ ꞌdĩ trõzó gõꞌdá gólĩyî tı̣́ mvá ĩꞌdí bê lâ kpá kô. ");
INSERT INTO avu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Gõꞌdá ạ̃dũkũ lâ ró, õkó ạ̃yı̣́zı̣́ ró ꞌdĩ drí kpá drãzó. ");
INSERT INTO avu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ĩtí rî, õjílã gólĩyî âꞌdó ꞌbá njı̣̂-drı̣̃-lâ-rı̣̃ ậdrúpı̣̃ ró ꞌdĩ ꞌbá yî trõ ĩyî õkó ꞌdĩ trá ndrĩ ĩyî drí õkó ró. Õzõ ãꞌdô bê trá ĩtí rî, kậyı̣̂ gólâ õjílã drí ꞌẽzó lîdrílí õdrã ꞌásĩ rî tú rî, õkó ꞌdĩ âꞌdô ꞌbãꞌá ậdrúpı̣̃ ángô rî õkó lâ ꞌî ậdrúpı̣̃ gólĩyî njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdî ꞌbá yî lãfálé sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Nĩ rî ãnî nyãányâ âdólé tã lîdrî-lîdrî kâ õdrã ꞌásĩ rî tãsĩ, tãlâ mĩ nı̣̃ı̣́ tã gólâ îgĩlí búkũ Ôvârí kâ ꞌá rî kô, gõꞌdá mĩ nı̣̃ı̣́ mbârâkã Ôvârí kâ kpá kô. ");
INSERT INTO avu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tã îjî ãnî drí îjílí ꞌdĩ tãsĩ rî, kậyı̣̂ gólâ õjílã drí ꞌẽzó lîdrílí õdrã ꞌásĩ rî tú rî, õjílã trõó õkó kô. Gólĩyî âꞌdô ꞌbãꞌá õzõ mãlãyíkã ûrú ꞌálâ rî ꞌbá yí kâtí. ");
INSERT INTO avu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Tã lîdrî-lîdrî kâ õdrã ꞌásĩ rî tãsĩ rî, nĩ zı̣́ tã gólâ Ôvârí drí âtálé ãnî drí búkũ íyíkâ ꞌá rî kô yã? ");
INSERT INTO avu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Gólâ kĩ, ‘Mâ Ôvârí tíbê Ãbãrãyámã drí rĩꞌá rõlâ rî, mâ kpá ĩꞌdî Ôvârí tíbê Ĩsákã drí rĩꞌá rõlâ rî, kpá Ôvârí Yãkóbã drí rõlé rî ĩꞌdî.’ Âfõ-âfõ 3.6 Rĩꞌá õjílã lédrẽ-lédrẽ ró gólĩyî îcá ꞌbá Ôvârí rî rõlé. Îcá kô ãvõ drí Ôvârí rî rõzó. Ĩtí rî, gbõ lé Ãbãrãyámã yî ôdrã bê trá ạ̃kû ró nã rî, gólĩyî líndrí bê rĩꞌá lédrẽ-lédrẽ ró Ôvârí ngálâ ûrú ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ĩtí rî, õjílã gólĩyî rû êꞌbé ꞌbá tã Yésũ drí rĩꞌá âtálâ Sạ̃dúsı̣̃ yî drí ꞌdĩ ârílí rî ꞌbá yî ârî tã Yésũ drí âtálé ꞌdĩ bê rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó úlı̣́ gólâkâ ꞌdĩ ꞌbá yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Gõꞌdá nĩngá sĩ, Pạ̃rúsı̣̃ yî ârî tã bê kĩꞌá nĩ rî, Yésũ õpẽ Sạ̃dúsı̣̃ ꞌdĩ ꞌbá yî trá rî, drílĩyî ngãzó rû êꞌbélé tã ı̣̂ꞌbı̣̃lı̣́, ãꞌdô ró lạ́tı̣̂ ãzâ lôndãzó, tãlâ ĩyî drí Yésũ rî ûjũzó bê kpá óꞌdí. ");
INSERT INTO avu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ꞌDĩî vósĩ rî, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ânĩzó Yésũ ngálâ. Gõꞌdá ãlô gólĩyî lãfálé sĩ gólâ tíbê tã ꞌbãꞌbã Ôvârí kâ nı̣̃ ꞌbá trá dódó rî, gólâ drí Yésũ rî ûjũzó tã îjî ãzâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Gólâ kĩ, “Tã îmbá ꞌbá, tã ꞌbãꞌbã gólĩyî ndrĩ Ôvârí drí âfẽlé ãmâ drí ꞌẽlé Músạ̃ sĩ rî ꞌbá yî lãfálé sĩ rî, tã ꞌbãꞌbã gólâ lậvũ ꞌbá gạ̃rạ̃ rî íyíkâ ángô rî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílâ kĩ, “ ‘Ní lẽ Yãkóvã Ôvârí áníkâ ánî pı̣̃pı̣̂sı̣́lı̣́ sĩ ndrĩ, ánî líndrí sĩ ndrĩ, gõꞌdá kpá tã ı̣̂sũ áníkâ sĩ ndrĩ.’ ");
INSERT INTO avu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ꞌDĩî rĩꞌá tã ꞌbãꞌbã sı̣́sı̣́ gólâ lậvũ ꞌbá gạ̃rạ̃ tã ꞌbãꞌbã ãzí drı̣̃ı̣̂ sĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gõꞌdá tã ꞌbãꞌbã ãzâ rı̣̃ lâ ró gólâ lậvũ ꞌbá kpá gạ̃rạ̃ rî rĩꞌá ĩꞌdî nõ. ‘Ní lẽ õjílã ãzí õzõ ní drí ánî nyãányâ lẽrẽ kâtí.’ ");
INSERT INTO avu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tã ꞌbãꞌbã gólĩyî ndrĩ Ôvârí drí âfẽlé ãmâ drí ꞌẽlé Músạ̃ sĩ rî ꞌbá yî gõꞌdá tã îmbâ tã ậngũ ꞌbá yí kâ bê rî, ólôgõ trá cé ĩꞌdî rı̣̃ ꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Gõꞌdá nĩngá sĩ rî, Pạ̃rúsı̣̃ yî drẽ bê rĩꞌá ĩyî zãâ võ ãlô ꞌá Yésũ yí bê rî, Yésũ drí tã îjízó gólĩyî tı̣́ kĩ, ");
INSERT INTO avu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tã ı̣̂sũ ãníkâ ꞌá rî, ꞌdíyî pã ꞌbá gólâ Ôvârí drí tã lâ ꞌbãlé âjólé rî íyíkâ ãꞌdî ĩꞌdî yã? Gólâ rĩꞌá ãꞌdî rî ózõwá ĩꞌdî yã?” Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Gólâ rĩꞌá kúmú Dạ̃wúdı̣̃ rî ózõwá ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Gõꞌdá Yésũ drí tã îjízó gólĩyî tı̣́ kĩ, “Õzõ ꞌdíyî pã ꞌbá ãꞌdô Dạ̃wúdı̣̃ rî ózõwá ꞌî rî, gõꞌdá tãlâ ãꞌdô ꞌî Dạ̃wúdı̣̃ drí gólâ rî zı̣̃zó kúmú ró yã? Nĩ ndrê drẽ, Dạ̃wúdı̣̃ âtâ úlı̣́ Ôvârí kâ nõ ꞌbá yî trá ꞌdíyî pã ꞌbá tãsĩ mbârâkã Líndrí Tãndí Ôvârí kâ rî kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Gólâ kĩ, ‘Kúmú Ôvârí âtâ tã trá kúmú ámákâ drí kĩ nĩ rî, “Ní rî ámâ drı̣́-ágó drı̣̃ lésĩ ró drı̣́-ãcê bê. Má âꞌdô ánî ạ̃jú-ꞌbá-ãzí yî ꞌbãꞌá ánî pá zẽlé.” ’ ” ");
INSERT INTO avu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gõꞌdá Yésũ drí tã îjízó gólĩyî tı̣́ kĩ, “Õzõ Dạ̃wúdı̣̃ ũzı̣̂ ꞌdíyî pã ꞌbá trá kúmú íyíkâ ró rî, ĩtí rî, âꞌdô âꞌdóꞌá íyíkâ ángô tí ró ꞌdíyî pã ꞌbá drí âꞌdózó gólâ rî ózõwá ró yã?” ");
INSERT INTO avu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nĩngá sĩ rî, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ Yésũ drí lôgõlé gólĩyî drí ꞌdĩ bê rî, õjílã ãzãkã yû gólĩyî lãfálé sĩ gólâ îcá ꞌbá tã îjî Yésũ kâ ꞌdĩ ꞌbá yî tã-drı̣̃ lâ lôgõlé rî. Ĩtí rî, îtõlé kậyı̣̂ ꞌdĩ sĩ nĩꞌá ạ̃tı̣́ ꞌálâ õjílã ãzãkã yû lẽ ꞌbá Yésũ rî îjílí tã îjî ãzâ ꞌbá yî sĩ, tãlâ gólĩyî trá ndrĩ ũrı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ rî ꞌbá yî drí õjílã gólĩyî rû êꞌbé ꞌbá úlı̣́ gólâkâ ârílí rî ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Gólâ kĩ, “Lãꞌbí îmbá ꞌbá yî gõꞌdá Pạ̃rúsı̣̃ yí bê, gólĩyî cú rĩꞌá drı̣́-ãcê bê tã ꞌbãꞌbã Ôvârí drí âfẽlé Músạ̃ sĩ rî ꞌbá yî âꞌdázó õjílã drí. ");
INSERT INTO avu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gõꞌdá nĩ ı̣̂sũ tã kĩ nĩ rî, rĩꞌá mbı̣̂ ãnî drí tã ndrĩ gólĩyî drí âtálé rî ꞌbá yî ꞌẽzó yã? Nĩ ndrê tã gólĩyî drí rĩꞌá ꞌẽlâ rî ꞌbá yî! Gõꞌdá nĩ ꞌê tã kô õzõ gólĩyî drí rĩꞌá ꞌẽlâ rî kâtí, tãlâ tã gólĩyî drí rĩꞌá îmbálâ ãnî drí ꞌẽlé ꞌdĩ ꞌbá yî, gólĩyî nyãányâ rí ĩyî kô tã rî ꞌdĩ ꞌbá yî ꞌẽlé té ĩtí. ");
INSERT INTO avu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nĩ ndrê drẽ, gólĩyî âtrõ tã ꞌbãꞌbã ĩyî nyãányâ kâ ãzâ ꞌbá yî trá dró ꞌbãlé tã ꞌbãꞌbã Ôvârí kâ drı̣̃ı̣̂. Tã ꞌbãꞌbã rî ꞌdĩ ꞌbá yî ndrĩ gõꞌdá trá rĩꞌá ngá lậnjı̣̃ ró õjílã drí ꞌẽlé. Gõꞌdá drílĩyî gõzó õjílã ꞌbãlé rĩꞌá tã rî ꞌdĩ ꞌbá yî ꞌẽlé mbârâkã sĩ. Gbõ lé ĩtí rî, gólĩyî nyãányâ lẽé kô õjílã pãlé ngá lậnjı̣̃ rî ꞌdĩ ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Gõꞌdá gólĩyî rî úlı̣́ Ôvârí kâ îgĩlí ínyíríkó ậvû-ậvû ró rî drı̣̃ı̣̂, tãlâ ólêndrê ró bê dódó. Gõꞌdá drílĩyî gõzó ômbélâ ĩyî ándrá-gạ́-sı̣́lı̣́ ꞌásĩ, gõꞌdá drílĩyî sõzó lâ kpá ĩyî drı̣́ ꞌásĩ. Gólĩyî ꞌê ꞌdĩ rĩzó rãtáã ꞌẽlé ĩꞌdî sĩ lâ. Gõꞌdá gólĩyî cú rĩꞌá ítá ãzâ rĩꞌá âkólâ ĩyî ũwû ꞌá rî bê. Gólĩyî drí kẽlẽlẽ lôsézó dũû ítá rî ꞌdĩ tı̣́ sĩ ãcê-ãcê ĩtí. Gólĩyî rî tã ꞌbãꞌbã Ôvârí kâ lãlé kẽlẽlẽ rî ꞌdĩ ꞌbá yî sĩ, gólĩyî õtírĩ rĩî rãtáã ꞌẽlé rî. Gólĩyî rî tã ꞌdî ꞌbá yî ꞌẽlé ĩtí ꞌdĩ, tãlâ õjílã ũnı̣̃ ró bê kĩꞌá nĩ rî, yĩ rî tã ꞌbãꞌbã Ôvârí kâ ꞌẽlé ndrĩ dódó. ");
INSERT INTO avu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gõꞌdá gólĩyî õnĩ trá võ kãrámã kâ ꞌásĩ gõꞌdá jó tã Ôvârí kâ ârî kâ ꞌásĩ rî, gólĩyî lẽ ĩyî nyãányâ ꞌbãlé rĩlí rĩ-võ õjílã ãmbâ-ãmbâ kâ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gõꞌdá õzõ gólĩyî õtírĩ nĩî võ ngá lậzı̣̂ kâ gĩlí rî ꞌbá yî ꞌásĩ rî, gólĩyî lẽ õjílã drí nî-bê-yã ꞌẽlé ĩyî drí tã rõrõ sĩ, gõꞌdá gólĩyî lẽ õjílã ı̣̃ı̣̂njı̣̃ ró ĩyî bê ı̣̂njı̣̃, gõꞌdá úzı̣̂ ró ĩyî bê “‘ãmbá”’ ró. ");
INSERT INTO avu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Nĩ ꞌbã õjílã ãzí kô ãnî zı̣̃lı̣́ “‘ãmbá”’, ãnî rĩꞌá tã îmbá ꞌbá bê cé ãlô, tãlâ ãmbã ãníkâ rĩꞌá ꞌdó ãlô, ãnî ndrĩ rĩꞌá ậdrúpı̣̃ ãzí ró. ");
INSERT INTO avu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gõꞌdá kpá ĩtí, nĩ zı̣̂ õjílã ãzí ãngó nõ ꞌá nõngá nõ kô “‘átá”’, tãlâ ãnî átá rĩꞌá cé ãlô Ôvârí ĩꞌdî ꞌbũû ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nĩ ꞌbã õjílã kô ãnî zı̣̃lı̣́ “‘kúmú”’ ró, tãlâ Kúmú ãníkâ cé Krístõ ꞌdíyî pã ꞌbá ró rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gõꞌdá õjílã ãnî lãfálé sĩ gólâ lẽ ꞌbá âꞌdólé ãmbá ró rî, gólâ ãâꞌdô rû ı̣̂ꞌbũ ꞌbá ró íyî ãzí-ãzí yî drí. ");
INSERT INTO avu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Gõꞌdá õjílã tíbê íyî nyãányâ ꞌbã ꞌbá âꞌdólé ãmbá ró rî, Ôvârí âꞌdô gólâ rî lôgõꞌá vũdrı̣́. Gõꞌdá õjílã gólâ tíbê íyî nyãányâ lôgõ ꞌbá âꞌdólé ngá tãkó ró rî, Ôvârí âꞌdô gólâ rî ꞌbãꞌá âꞌdólé õjílã ãmbá ró.” ");
INSERT INTO avu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Gõꞌdá nĩngá sĩ, Yésũ drí ngãzó tã âtálé drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí lâŋõ gólâ Ôvârí drí ꞌẽꞌá fẽlâ gólĩyî drí rî tãsĩ. Gólâ kĩ, “Ãnî lãꞌbí îmbá ꞌbá yî Pạ̃rúsı̣̃ yí bê, nĩ rî trá ãnî nyãányâ âdólé. Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí, tãlâ nĩ âꞌbã ạ́tı̣̃ fĩzó võ ûrú ꞌálâ rî ꞌá rî trá kpạ̃ạ́kũ õjílã drí, tã ꞌbãꞌbã dũû ãnî drí ꞌbãlé õjílã drí ꞌẽlé rî ꞌbá yî sĩ. Gõꞌdá ãnî nyãányâ îcá kô fĩlí, tãlâ nĩ rí kô tã ꞌbãꞌbã ãnî drí rĩꞌá îmbálâ õjílã drí rî ꞌbá yî ꞌẽlé. Gõꞌdá õjílã gólĩyî lẽ ꞌbá fĩlí rî, nĩ njı̣̃ı̣́ ạ́tı̣̃ kô gólĩyî drí fĩzó. ");
INSERT INTO avu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ãnî drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ nõ ꞌbá yî, ãnî rĩꞌá mãnĩ ꞌbá ꞌî. Nĩ rî ạ̃yı̣́zı̣́ âdólé rĩzó ậdı̣̂ gólĩyî drí ꞌẽꞌá fẽlâ jó drílĩyî rĩzó ꞌá lâ rî lı̣́pı̣̂ lâ yî drí rî trõlé drı̣́gạ́ lâ yî nyãlé vólé. Gõꞌdá nĩ rî kpá rãtáã ꞌẽlé ãcê, tãlâ Ôvârí ãꞌdô ró bê ãyĩkõ ró ãní bê. Tã ꞌdî tãsĩ rî, Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí.) ");
INSERT INTO avu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ãnî drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rĩ ꞌbá ãnî nyãányâ âdólé nõ ꞌbá yî, Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí, tãlâ nĩ rî nĩꞌá ꞌbạ̃drı̣̃ ãzâ ꞌbá yî ꞌásĩ jẽjẽ ró õjílã lôndã bê âꞌdólé tã ârí ꞌbá ãníkâ ró, gõꞌdá nĩ rî kpá nĩꞌá lı̣̃mvû ândrê drı̣̃ mbã bê, nĩꞌá õjílã lôndã bê âꞌdólé kpá tã ârí ꞌbá ãníkâ ró. Gõꞌdá õzõ nĩ ũûsû gólĩyî trá rî, tã îmbâ ãníkâ lãꞌbí ndrĩ ꞌẽꞌẽ tãsĩ ꞌdî âꞌdô gólĩyî ꞌbãꞌá âꞌdólé õnjí ró lậvũlı̣́ gạ̃rạ̃ ãnî nyãányâ drı̣̃ı̣̂ sĩ. Ĩtí rî, nĩ ꞌbã gólĩyî trá ꞌẽꞌá nĩꞌá vẽlé lạ̃sı̣́ gólâ Ôvârí drí êdélé Sãtánã yî drí rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ãnî drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ, ãnî rĩꞌá lı̣̃fı̣́ ãkó lé ꞌbá gólĩyî rĩ ꞌbá ĩyî ãzí-ãzí yî sẽlé rî ꞌbá yî ĩꞌdî, tãlâ nĩ rî tã ányâ îmbálé ĩꞌdî õjílã drí. Nĩ rî trá tã îmbálé kĩ nĩ rî, õzõ õjílã ãzâ ĩîtrî lãtrítrí trá ngá ãzâ ꞌẽzó jó ạ́ngı̣́ Ôvârí kâ rú lâ sĩ rî, gõꞌdá õzõ gólâ õꞌê ngá rî ꞌdĩ kô rî, ꞌdĩî âꞌdó kô tã õnjí ꞌî. Gõꞌdá õzõ õjílã rî ꞌdĩ ĩîtrî lãtrítrí trá ngá ãzâ ꞌẽzó dáãbõ jó ạ́ngı̣́ Ôvârí kâ ꞌá ꞌdĩ rú lâ sĩ rî, gõꞌdá îcâ trá gólâ drí tã rî ꞌdĩ ꞌẽlé. ꞌDĩî rĩꞌá tã îmbâ ányâ ꞌî. Tã ꞌdî tãsĩ rî, Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ãnî rĩꞌá lı̣̃fı̣́ ãkó lé ꞌbá gólĩyî tã nı̣̃nı̣̃ ãkó rî ꞌbá yî ĩꞌdî. Ĩtí rî, tã ı̣̂sũ ãníkâ ꞌá rî, ngá ángô rî ĩꞌdî tã lâ drí lậvũlı̣́ gạ̃rạ̃ rî, dáãbõ jó ạ́ngı̣́ Ôvârí kâ ꞌá ꞌdĩ ĩꞌdî ngãtá jó ạ́ngı̣́ Ôvârí kâ gólâ dáãbõ ꞌdî ꞌbã ꞌbá âꞌdólé tãndí ró Ôvârí drí ꞌdĩ ĩꞌdî yã? ");
INSERT INTO avu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gõꞌdá nĩ rî kpá tã îmbálé kĩ, õzõ õjílã ãzâ ĩîtrî lãtrítrí trá võ rĩzó kõrõnyã zãlé fẽlé Ôvârí drí ngá fẽfẽ ró rî rú lâ sĩ ngá ãzâ ꞌẽzó rî, gõꞌdá õzõ gólâ õꞌê ngá rî ꞌdĩ kô rî, ꞌdĩî âꞌdó kô tã õnjí ꞌî. Gõꞌdá õzõ õjílã ãzâ ĩîtrî lãtrítrí trá ngá gólĩyî fẽlé Ôvârí drí ngá fẽfẽ ró ꞌdĩ rú lâ sĩ ngá ãzâ ꞌẽzó rî, îcâ trá gólâ drí ngá rî ꞌdĩ ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ãnî rĩꞌá õjílã gólĩyî lı̣̃fı̣́ ãkó lé ꞌbá ró rî yî ĩꞌdî. Tã îmbâ ãníkâ ꞌdĩ rĩꞌá ányâ ró. Gõꞌdá tã ı̣̂sũ ãníkâ ꞌá rî, ngá ángô rî ĩꞌdî tã lâ drí lậvũlı̣́ gạ̃rạ̃ rî, ngá gólĩyî fẽlé trá Ôvârí drí ngá fẽfẽ ró ꞌdĩ ꞌbá yî ĩꞌdî ngãtá võ gólâ ngá ꞌdĩ ꞌbá yî ꞌbãzó drı̣̃ lâ ꞌá tíbê ngá fẽfẽ ꞌdî ꞌbá yî ꞌbã ꞌbá âꞌdólé tãndí ró Ôvârí drí rî ĩꞌdî yã? ");
INSERT INTO avu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tã ꞌdî tãsĩ rî, õjílã gólâ tíbê lãtrítrí îtrí ꞌbá trá võ rĩzó kõrõnyã zãlé fẽlé Ôvârí drí ngá fẽfẽ ró rî rú lâ sĩ rî, gólâ îtrî lãtrítrí kpá trá ngá fẽfẽ gólĩyî drı̣̃ lâ ꞌá ꞌdĩ ꞌbá yî rú lâ sĩ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Gõꞌdá õzõ õjílã ãzâ ĩîtrî lãtrítrí trá jó ạ́ngı̣́ Ôvârí kâ rú lâ sĩ rî, gólâ îtrî lãtrítrí ꞌdĩ kpá trá Ôvârí gólâ rĩ ꞌbá jó ꞌdĩ ꞌá ꞌdĩ rú lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Gõꞌdá õzõ õjílã ãzâ ĩîtrî lãtrítrí ꞌbũû rú sĩ rî, gólâ îtrî lãtrítrí trá kı̣́tı̣̃ Ôvârí drí rĩzó rĩlí drı̣̃ lâ ꞌá kúmú ró rî rú lâ sĩ gõꞌdá kpá Ôvârí gólâ tíbê rĩ ꞌbá kı̣́tı̣̃ rî ꞌdĩ drı̣̃ı̣̂ rî bê. ");
INSERT INTO avu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Gõꞌdá nĩ rî trá ãlô mûdrı̣́ ꞌásĩ trõlé ngá gólĩyî ãtó drí âsózó drí lâ sĩ, õzõ ꞌạ̃ꞌı̣́-nyá yí kâtí, dõ yí kâtí, gõꞌdá kpá õzõ ꞌạ̃ꞌı̣́-tĩtĩ kâtí rî ꞌbá yí bê, fẽlé Ôvârí drí ngá fẽfẽ ró. Tã ꞌdî ꞌbá yî, nĩ rî ꞌẽlâ ndrĩ tãndí ró, gõꞌdá nĩ rí kô tã ꞌbãꞌbã Ôvârí kâ lậvũ ꞌbá gạ̃rạ̃ rî ꞌbá yî ꞌẽlé. Nĩ rí kô tã-vó õjílã kâ kĩlí mbı̣̂, gõꞌdá nĩ rí kpá kô õjílã gólĩyî ĩzã bê rî ꞌbá yî pãlé, gõꞌdá nĩ rí kpá kô rĩlí zãâ tã gólĩyî mbı̣̂ Ôvârí drí lẽlé ãnî drí ꞌẽlé rî ꞌbá yî ꞌẽlé. Tã ꞌdî tãsĩ rî, Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí.” ");
INSERT INTO avu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gõꞌdá Yésũ drí úlı̣́ mãnĩgõ ãzâ âtázó tã ꞌdî tãsĩ drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí kĩ, “Ãnî rĩꞌá õzõ lı̣̃fı̣́ ãkó lé ꞌbá yí kâtí. Ãnî rĩꞌá nyé õzõ õjílã gólĩyî nyạ̃ạ́múrúwạ́ drí ꞌdẽzó ngá mvũmvũ gólĩyíkâ ꞌá ndrẽlé tõ drílĩyî âpẽzó lâ vólé gõꞌdá ĩnjígó ândrê gólâ ꞌdẽ ꞌbá ngá mvũmvũ ꞌdî ꞌá ꞌdĩ ndrẽzó lâ kô gõꞌdá drílĩyî gõzó ĩnjígó ꞌdĩ mvũlı̣́ tẽlé nyé ĩyî ꞌâ ꞌá rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ãnî drı̣̃-ꞌbá Yúdạ̃ yí kâ nõ ꞌbá yî, tã ꞌẽꞌẽ ãníkâ rî ꞌbá yî rĩꞌá rı̣̃ rı̣̃. Nĩ rî ĩgã mvá ãníkâ gõꞌdá tạ́bı̣́gạ́ ãníkâ bê rî ꞌbá yî rúꞌbạ́ lâ ĩví lésĩ rî jĩlí cé ĩꞌdî ngbángbá, gõꞌdá ãnî drí ꞌálé lâ yî âyézó ĩyíkâ ı̣̃ndı̣̂ ró, tãlâ ngá gólĩyî ãnî drí rĩꞌá ûsúlâ rî ꞌbá yî, nĩ rî rĩꞌá ûsúlâ õjílã âdô-âdô sĩ, gõꞌdá nĩ lẽ ngá dũû ndrĩ ãnî nyãányâ drí. Nĩ ꞌbã ãnî nyãányâ âꞌdólé õjílã tãndí ró, gõꞌdá ãnî pı̣̃pı̣̂sı̣́lı̣́ rĩꞌá õnjí ró. Tã ꞌdî tãsĩ rî, Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ãnî rĩꞌá õjílã gólĩyî lı̣̃fı̣́ ãkó lé ꞌbá ró rî yî ĩꞌdî. ꞌDõvó nĩ jĩ drẽ ĩgã mvá ãníkâ ꞌâ lâ zãlô sı̣́sı̣́, gõꞌdá nĩ gõ ró bê rúꞌbạ́ lâ ĩví lésĩ rî jĩlí, tãlâ ãꞌdô ró bê ngbángbá. ");
INSERT INTO avu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ĩtí rî, ãnî drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî, ãnî kpá rĩꞌá nyé õzõ lóꞌdé gólĩyî rúꞌbạ́ lâ bẽlé dódó õlêndrê ró bê ĩví lésĩ sũsũ ró rî kâtí. Gõꞌdá lóꞌdé rî ꞌdĩ ꞌálé lâ ꞌá tólâ rî, áâꞌdô õjílã ãvõ fã ûsúꞌá ĩꞌdî, gõꞌdá kpá ngá õnjî-õnjî ãzâ ꞌbá yí bê dũû. Tã ꞌdî tãsĩ rî, Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gõꞌdá ãnî kpá rĩꞌá ĩtí. Nĩ ꞌbã ãnî nyãányâ trá âꞌdólé õjílã ãzí lı̣̃fı̣́ drı̣̃ ꞌá tã mbı̣̂ ꞌẽ ꞌbá ró. Gõꞌdá ãnî pı̣̃pı̣̂sı̣́lı̣́ rĩꞌá õnjí ró tã ı̣̂sũ bê rı̣̃ rı̣̃. ");
INSERT INTO avu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ãnî drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî, ãnî rĩꞌá tã ôjá ꞌbá ꞌî. Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí tã nô ꞌbá yî tãsĩ. Nĩ rî trá lóꞌdé tã ậngũ ꞌbá Ôvârí kâ ôdrã ꞌbá trá rî yí kâ rúꞌbạ́ lâ êdélé dódó, gõꞌdá nĩ rî kpá trá rĩꞌá lóꞌdé tã mbı̣̂ ꞌbá Ôvârí kâ ôdrã ꞌbá trá rî yí kâ rúꞌbạ́ lâ êdélé sũsũ ró njõrókõ bê, tãlâ ãꞌdô ró bê ãnî drí rĩzó gólĩyî ı̣̂njı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nĩ rî tã âtálé kĩ nĩ rî, ‘Tí mã õró ꞌbãâ bê kậyı̣̂ ạ̃kû ró gólâ ãmâ ạ́ꞌbı̣́yạ́ yî drí rĩzó tã ậngũ ꞌbá Ôvârí kâ ûfúlı̣́ nã ꞌbá yî sĩ rî, tí mã îcá kô tã-drı̣̃ lẽlé rû êꞌbélé gólĩyí bê tã ậngũ ꞌbá ꞌdĩ ꞌbá yî ûfúzó.’ ");
INSERT INTO avu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Úlı̣́ gólâ ãnî drí âtálé ãnî tı̣̂ sĩ ꞌdî rî âꞌdâ tã trá kĩ nĩ rî, õjílã tã ậngũ ꞌbá Ôvârí kâ ûfú ꞌbá nã ꞌbá yî, ãnî rĩꞌá gólĩyî ózõwá yî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bê trá ĩtí rî, tã õnjí ãnî ạ́ꞌbı̣́yạ́ yî drí îtõlé ꞌẽlé rî, nĩ trõ kpá ĩꞌdî ꞌẽlé cãzó bê bũúũ ạ̃dũkũ lâ ꞌá, tãlâ ãnî rĩꞌá nyé õzõ gólĩyí kâtí. ");
INSERT INTO avu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ãnî rĩꞌá ı̣̃nı̣̃ cú gĩî bê rî ꞌbá yî ĩꞌdî, nĩ âꞌdô îcáꞌá ãnî pãlé lâŋõ lạ̃sı̣́ kâ Ôvârí drí ꞌẽꞌá fẽlâ ãnî drí rî ꞌásĩ ángô tí ró yã? ");
INSERT INTO avu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Tã gólâ ꞌẽ ꞌbá tã ꞌdî ꞌbá yî âꞌdálé ãnî tãsĩ rî ĩꞌdî nõ. Má âꞌdô tã Ôvârí kâ âtá ꞌbá ãzâ ꞌbá yî tã nı̣̃ ꞌbá ãzâ ꞌbá yí bê gõꞌdá kpá tã îmbá ꞌbá ãzâ ꞌbá yí bê âjóꞌá ãnî ngálâ. Nĩ âꞌdô ũrûkậ ꞌbá yî îpáꞌá fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂, gõꞌdá nĩ âꞌdô ꞌẽꞌá ũrûkậ ꞌbá yî ûfúlı̣́ lạ́tı̣̂ ngĩíngî ꞌásĩ. Gõꞌdá nĩ âꞌdô ꞌẽꞌá ãzâ ꞌbá yî cãlé ônjóróꞌbí sĩ jó tã Ôvârí kâ ârî kâ ꞌásĩ. Gõꞌdá nĩ âꞌdô nĩꞌá lârá bê jạ̃rı̣́bạ̃ ꞌásĩ, nĩꞌá ãzâ ꞌbá yî gólĩyî lãfálé ꞌásĩ rî lôndã bê lâŋõ fẽzó drílĩyî. ");
INSERT INTO avu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tã õnjí ãnî drí ꞌẽꞌá ꞌẽlâ ꞌdĩ ꞌbá yî tãsĩ rî, tã mbı̣̂ ꞌbá Ôvârí kâ ãnî ạ́ꞌbı̣́yạ́ yî drí ûfúlı̣́ trá ạ̃kû ró nã ꞌbá yî, lâŋõ lâ âꞌdô âgõꞌá ãkpã ãnî drı̣̃ı̣̂, îtõlé õdrã tã mbı̣̂ ꞌbá Ôvârí kâ Ábẽlẽ rú sĩ bũúũ âcálé õdrã tã ậngũ ꞌbá rú bê Zẽkãríyã kâ rî rú gólâ tíbê âꞌdó ꞌbá Bẽrẽkíyã rî mvá ró ãnî ạ́ꞌbı̣́yạ́ yî drí fũlı̣́ jó ạ́ngı̣́ Ôvârí kâ ꞌá, võ tíbê Ôvârí drí rĩzó ꞌá lâ rî lãfálé ꞌá võ rĩzó kõrõnyã zãlé fẽlé Ôvârí drí ngá fẽfẽ ró rî bê. ");
INSERT INTO avu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, tã õnjí gólĩyî ꞌẽlé tã mbı̣̂ ꞌbá Ôvârí kâ ûfúzó ạ̃kû ró nã ꞌbá yî, lâŋõ lâ âꞌdô ꞌdẽꞌá ãnî õjílã kậyı̣̂ nõ ꞌbá yí kâ nõ drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Gõꞌdá nĩngá sĩ rî, Yésũ drí tã âtázó õjílã Yúdạ̃ yí kâ Yẽrõsãlémã ꞌálâ rî ꞌbá yî drí kĩ, “Ãnî õjílã Yẽrõsãlémã kâ, nĩ ûfû tã ậngũ ꞌbá Ôvârí kâ âjólé ãnî ngálâ rî ꞌbá yî trá, gõꞌdá nĩ lûvũ lãjóꞌbá gólĩyî Ôvârí drí âjólé ãnî ngálâ rî ꞌbá yî kpá trá kúnı̣́ mvá sĩ. Gbõ lé ĩtí rî, mâ rĩꞌá zãâ ngá lẽlẽ bê ãnî tãsĩ. Gõꞌdá má ûjũ trá kpı̣̃ı̣̂ ãnî êꞌbélé võ ãlô ꞌá sũzó ãnî rú, õzõ ꞌạ̃ꞌú ândrê drí mvá lâ yî êꞌbérẽ íyî úfú zẽlé sũzó gólĩyî rú rî kâtí. Gõꞌdá nĩ gã lõvõ ámákâ ãnî drí ꞌdĩ trá dó. ");
INSERT INTO avu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nĩ ndrê drẽ, jạ̃rı̣́bạ̃ ãníkâ gõꞌdá jó ạ́ngı̣́ ãnî drí rĩzó Ôvârí rî ı̣̂njı̣̃lı̣́ ꞌá lâ rî bê âꞌdô rû îzãꞌá, gõꞌdá drílâ rĩzó cú ĩtí õjílã ãzãkã ãkó, tãlâ Ôvârí âyê trá. ");
INSERT INTO avu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, nĩ îcá kô ámâ ndrẽlé óꞌdí nõngá cãlé bũúũ kậyı̣̂ gólâ má drí ꞌẽzó âgõlé rĩlí kúmú ró ãngó nõ drı̣̃lı̣́ rî tú. Kậyı̣̂ ꞌdĩ ꞌá rî, õzõ õjílã õndrê ĩyî mâ trá rî, gólĩyî âꞌdô ꞌẽꞌá tã âtálé kĩ nĩ rî, Ôvârí õfẽ õrẽ mâ gólâ ânĩ ꞌbá drı̣́-ãcê gólâkâ bê kúmú ró rî drí.” ");
INSERT INTO avu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ngãzó jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ âyélé lãjóꞌbá íyíkâ rî ꞌbá yí bê. Gõꞌdá gólĩyî õtírĩ ꞌbãâ lậvũꞌá jó ạ́ngı̣́ ꞌdĩ rú sĩ rî, lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ngãzó jó ạ́ngı̣́ ꞌdĩ ꞌbá yî bẽbẽ lâ sũsũ lâ ꞌdĩ ꞌbá yí bê âꞌdálé gólâ drí. ");
INSERT INTO avu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kĩ, “Nĩ ndrê jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ trá yã? Tã pạ̃tı̣́ı̣̃ ró, jó ãnî drí ndrẽlé sũsũ ró ꞌdĩ áâꞌdô ûfúꞌá lâ ndrĩ, gõꞌdá kúnı̣́ mvá ãlô îcá kô lâkílí jó ꞌdĩ drı̣̃ı̣̂, âꞌdô lôꞌdéꞌá ndrĩ vũdrı̣́.” ");
INSERT INTO avu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí nĩzó cãlé únı̣́ gólâ fê dõ kâ bê rî drı̣̃ ꞌálâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. Gõꞌdá drílĩyî mbãzó únı̣́ ꞌdĩ drı̣̃ı̣̂, gólĩyî cé ĩyî drı̣̃ı̣̂ sĩ. Gõꞌdá Yésũ drí ngãzó rĩlí vũdrı̣́. Nĩngá sĩ, lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí rû êsézó ãnyî gólâ lạ̃gạ́tı̣́. Drílĩyî tã îjízó gólâ tı̣́ kĩ, “Kúmú, tã jó ạ́ngı̣́ Ôvârí kâ ûfû kâ ꞌdĩ âꞌdô ꞌẽꞌá rû ꞌẽlé ángô tú yã? Tã gólĩyî ꞌẽ ꞌbá rû ꞌẽlé tã âꞌdâ ró kậyı̣̂ âgõ-âgõ áníkâ ãngó nõ ꞌá rî kâ âꞌdálé ãmâ drí rî âꞌdô ꞌbãꞌá ãꞌdô ꞌî yã? Gõꞌdá kpá tã gólĩyî ꞌẽ ꞌbá kậyı̣̂ ạ̃dũkũ ãngó nõ kâ âꞌdálé ãmâ drí rî âꞌdô ꞌbãꞌá ãꞌdô ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Ãnî lı̣̃fı̣́ õmbâ ãnî rú, nĩ âyê õjílã ãzãkã kô ãnî âdólé âgõ-âgõ ámákâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tãlâ õjílã dũû âꞌdô ĩyî ânĩꞌá tã âmãlé kĩ, yĩ ãâꞌdô ꞌdíyî pã ꞌbá gólâ Ôvârí drí âjólé ûrú lésĩ rî ĩꞌdî. Tã ꞌdî tãsĩ rî, gólĩyî âꞌdô ꞌẽꞌá õjílã dũû âdólé, drílĩyî tã lẽlẽ ĩyíkâ má ꞌá rî âyézó. ");
INSERT INTO avu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Gõꞌdá nĩ âꞌdô kpá ạ̃jú ạ̃yı̣́ âríꞌá ãnyî, gõꞌdá nĩ âꞌdô kpá ạ̃jú gólĩyî jẽjẽ ró rî ꞌbá yî tã lâ âríꞌá. Tã ꞌdî ꞌbá yî âꞌdô rû ꞌẽꞌá ndrĩ sı̣́sı̣́ tã Ôvârí drí lẽlé rî vó ró. Ĩtí rî, nĩ ꞌê ũrı̣̃ kô, tãlâ ꞌdĩî âꞌdá tã kô kĩ nĩ rî, ꞌdĩî trá ạ̃dũkũ ãngó nõ kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gõꞌdá õjílã ꞌbạ̃drı̣̃ ãlô kâ âꞌdô ngãꞌá ꞌdẽlé ạ̃jú bê õjílã ꞌbạ̃drı̣̃ ãzâ kâ rî drı̣̃ı̣̂. Gõꞌdá ạ̃jú ꞌbũ ꞌbá kúmú ãzâ rî kâ âꞌdô ngãꞌá nĩlí ꞌdẽlé ạ̃jú bê ạ̃jú ꞌbũ ꞌbá kúmú ãzâ kâ rî drı̣̃ı̣̂. Gõꞌdá lõfó õnjí tẽtẽ âꞌdô ꞌẽꞌá ꞌdẽlé õjílã drı̣̃ı̣̂, gõꞌdá ạ̃gbı̣̃gbı̣̃ âꞌdô ı̣̃nyạ́kú drı̣̃ îyáꞌá võ ꞌásĩ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tã ꞌdî ꞌbá yî âꞌdô ꞌbãꞌá, nyé õzõ mvá lâzê-lâzê âꞌdó ꞌbá sı̣́sı̣́ õkó gólâ ꞌẽ ꞌbá mvá tı̣̃lı̣́ rî drí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Õjílã âꞌdô ĩyî ãnî rũꞌá fẽlé ãnî ạ̃jú-ꞌbá-ãzí gólĩyî ꞌẽ ꞌbá lâŋõ fẽlé ãnî drí rî ꞌbá yî drı̣́gạ́. Gólĩyî âꞌdô ãnî ꞌbãꞌá gạ̃nı̣́mạ̃ ꞌá. Gõꞌdá gólĩyî âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá ãnî drí. Gõꞌdá gólĩyî drí kpá ãnî ûfúzó. Ĩtí rî, õjílã cé tı̣̂tı̣̂ ꞌbãá ĩyî ãnî lôvó kô, tãlâ ãnî rĩꞌá tã ârí ꞌbá ámákâ ĩꞌdî rî drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tã rî ꞌdĩ ꞌbá yî õtírĩ rĩî rû ꞌẽlé rî, õjílã dũû âꞌdô ĩyî tã lẽlẽ ĩyíkâ má ꞌá rî âyéꞌá, gõꞌdá gólĩyî âꞌdô ĩyî ãzí-ãzí yî drı̣́-bã fẽꞌá ạ̃jú-ꞌbá-ãzí lâ yî drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tã ậngũ ꞌbá dũû tã âmã ꞌbá kĩꞌá nĩ rî, ĩyî ãꞌdô tã ậngũ ꞌbá Ôvârí kâ ĩꞌdî rî, âꞌdô ĩyî ânĩꞌá õjílã dũû âdólé õnjõ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tã õnjí gólĩyî ꞌẽ ꞌbá rû ꞌẽlé ãngó nõ ꞌá rî ꞌbá yî âꞌdô lı̣̂tı̣́ꞌá rõô lậvũlı̣́ gạ̃rạ̃ sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ. Tã ꞌdî tãsĩ rî, ꞌdĩî trá kậyı̣̂ gólâ õjílã ãmbá drí ꞌẽzó âꞌdólé ngá lẽlẽ ãkó ĩyî ãzí-ãzí yî drí rî trá ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gbõ lé ĩtí rî, õjílã gólâ tã lẽlẽ íyíkâ má ꞌá rî ậtı̣̃ ꞌbá gạ́gạ́ âyé ꞌbá lâ kô cãzó bũúũ ạ̃dũkũ lâ ꞌá rî, gólâ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá. ");
INSERT INTO avu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Gõꞌdá áâꞌdô tã âtî-âtî tãndí kũmũ Ôvârí kâ tãsĩ nô rî pẽꞌá zãlô sı̣́sı̣́ õjílã õrĩ ndrĩ kâ ãngó nõ ꞌásĩ rî ꞌbá yî drí, tãlâ gólĩyî ãârî ró ĩyî tã pạ̃tı̣́ı̣̃ ꞌdĩ bê. Gõꞌdá ꞌdĩî vósĩ, ạ̃dũkũ ãngó nõ kâ õró gõ âcálé. ");
INSERT INTO avu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tã gólâ ꞌẽzó Yẽrõsãlémã rî îzãlé rî tãsĩ, kậyı̣̂ âꞌdô ꞌẽꞌá âcálé ãnî drí ngá tã ậngũ ꞌbá Dãnĩyélẽ drí tã lâ âtálé trá ạ̃kû ró nã rî ndrẽzó. Nĩ ârî drẽ úlı̣́ ngbạ́ngậ nõ. Gólâ kĩ, ‘Ị̃zạ́tú nĩ âꞌdô ngá õnjí gólâ ꞌẽ ꞌbá ãnyĩ âjílí rî ndrẽꞌá. Gõꞌdá áâꞌdô ngá rî ꞌdĩ âtrõꞌá ꞌbãlé jó ạ́ngı̣́ Ôvârí kâ ꞌá. Ngá rî ꞌdĩ âꞌdô jó Ôvârí kâ ꞌdĩ ꞌbãꞌá âꞌdólé ı̣̃ndı̣̂ ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá.’ ” ");
INSERT INTO avu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Gõꞌdá Yésũ drí kpá tã âtázó lãjóꞌbá íyíkâ drí kĩ, “Õjílã Yũdạ́yạ̃ kâ rî ꞌbá yî, õzõ gólĩyî õndrê tã ãnyĩ kâ ꞌdĩ trá rû ꞌẽrẽ ꞌá rî, gólĩyî õrâ vólé ꞌwãâꞌwâ, nĩꞌá ĩyî lậpı̣́lı̣́ únı̣́ lãfálé ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Õjílã gólâ rĩ ꞌbá lôsĩ ꞌẽlé jó íyíkâ drı̣̃ı̣̂ rî, gólâ ãârî rãlé vólé ꞌwãâꞌwâ, gólâ õlîpî kô kpá fĩlí jó ꞌálâ nĩꞌá ngá íyíkâ jó kâ rî ꞌbá yî âtrõlé. ");
INSERT INTO avu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gõꞌdá õjílã gólâ rĩ ꞌbá lôsĩ ꞌẽlé yí drí ạ́mvú ꞌá kậyı̣̂ rî ꞌdĩ sĩ rî, gólâ õgõ kô ꞌbã ꞌálâ nĩꞌá ítá íyíkâ âtrõlé. Gólâ õlîpî kô, gólâ õrâ nĩꞌá íyî lậpı̣́lı̣́. ");
INSERT INTO avu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gõꞌdá kậyı̣̂ ꞌdĩ sĩ rî, õkó gólĩyî rû ꞌbã ꞌbá mvá bê rî ꞌbá yî âꞌdô ĩyî ꞌẽꞌá ꞌbãlé lâŋõ õnjí tẽtẽ bê gõꞌdá kpá õkó gólĩyî mvá õdé bê ĩyî drı̣́gạ́ rî ꞌbá yí bê, tãlâ rãrã ꞌdî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Õzõ kậyı̣̂ lâŋõ rî ꞌdĩ kâ ãâcâ trá rî, îcâ trá ãnî drí rãlé ꞌwãâꞌwâ. Tã ꞌdî tãsĩ rî, nĩ ꞌê rãtáã Ôvârí drí kậyı̣̂ rî ꞌdĩ õzó âcá kô ôzê lı̣̃mvû sĩ gõꞌdá kậyı̣̂ lôvô-lôvô kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lâŋõ gólâ ꞌẽ ꞌbá âꞌdólé kậyı̣̂ ꞌdĩ ꞌá rî, âꞌdô lậvũꞌá gạ̃rạ̃ lâŋõ gólĩyî rû ꞌẽ ꞌbá îtõ võ ãngó nõ ꞌbãrẽ kâ ꞌásĩ âcálé bũúũ ãndrõ nô rî kâ drı̣̃ı̣̂ sĩ. Gõꞌdá ạ̃tı̣́ ꞌálâ rî, lâŋõ ãzâ îcá kô lậvũlı̣́ gạ̃rạ̃ lâŋõ ꞌdî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gólâ lôgõ kậyı̣̂ rî ꞌdĩ trá ngbãâ kútúwạ́, tãlâ yí pâ ró õjílã yí drí njĩlí trá âꞌdólé õjílã íyíkâ ró rî ꞌbá yî bê. Tí gólâ õró gõ kậyı̣̂ rî ꞌdĩ ꞌbãlé ãcê rî, õjílã âꞌdô ĩyî ôdrãꞌá ndrĩ. Gólĩyî îcá kô ngá pãlé. ");
INSERT INTO avu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Gõꞌdá kậyı̣̂ ꞌdĩ ꞌbá yî sĩ, õzõ õjílã ãzâ ãâtâ tã trá ãnî drí kĩ, ‘Nĩ ndrê drẽ, ꞌdíyî pã ꞌbá rĩꞌá nõ’, ngãtá ‘gólâ rĩꞌá nã’ yã rî, ní lẽ tã gólâkâ ꞌdĩ kô. ");
INSERT INTO avu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tãlâ õjílã dũû rĩꞌá gólĩyî ꞌẽ ꞌbá ĩyî tã âmãlé kĩꞌá nĩ rî, ĩyî ãꞌdô ꞌdíyî pã ꞌbá Ôvârí drí âjólé rî ꞌbá yî ĩꞌdî. Gõꞌdá tã ậngũ ꞌbá õjílã âdó ꞌbá ãzâ ꞌbá yí bê, gólĩyî âꞌdô kpá ânĩꞌá ĩyî tã lârâkô ãmbá õjílã tı̣̂ drí ậꞌdı̣́zó drílâ sĩ rî ꞌbá yî ꞌẽlé, tãlâ ãꞌdô ró bê ĩyî drí lạ́tı̣̂ lôndãzó õjílã gólĩyî Ôvârí drí njĩlí âꞌdólé õjílã íyíkâ ró rî ꞌbá yî âdózó, tí õzõ yĩ ũûsû lạ́tı̣̂ lâ trá rî. ");
INSERT INTO avu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nĩ ârî drẽ, má âtâ tã ꞌdî ꞌbá yî ãnî drí sı̣́sı̣́, tãlâ ãnî lı̣̃fı̣́ õmbâ ró bê ãnî rú drẽ ãkpãkãꞌdã tã ꞌdî ꞌbá yî drí rû ꞌẽ ãkó. ");
INSERT INTO avu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Gõꞌdá õzõ õjílã ãzâ ãâtâ tã trá ãnî drí kĩ nĩ rî, ‘Nĩ ndrê drẽ, ꞌdíyî pã ꞌbá âꞌdô bê rĩꞌá võ ãgângbêlẽ ꞌá’ rî, nĩ nĩ kô tólâ gólâ rî lôndãlé. Ngãtá õzõ áãâtâ tã trá kĩꞌá nĩ rî, gólâ õlậpı̣̂ yî trá rĩꞌá jó ꞌá nõ rî, nĩ lẽ tã gólâkâ ꞌdĩ kpá kô. ");
INSERT INTO avu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kậyı̣̂ gólâ mâ âjólé ûrú lésĩ ꞌdíyî pã ꞌbá ró rî drí ꞌẽzó âgõlé kpá óꞌdí ãngó nõ ꞌá rî tú rî, õjílã ndrĩ âꞌdô ĩyî ámâ ndrẽꞌá õzõ ngá îꞌĩ gólâ võ îꞌĩ ꞌbá kãꞌdâ-kãꞌdâ ómvórẽ lésĩ bũúũ lạ̃njı̣́ ꞌálâ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kậyı̣̂ gólâ má drí ꞌẽzó âgõlé ãngó nõ ꞌá rî tú rî, õjílã ndrĩ âꞌdô ndrẽꞌá lâ õzõ drílĩyî lõgónõ ndrẽrẽ lôꞌdérẽ kõrõnyã ãvõ drı̣̃ı̣̂ rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Gõꞌdá Yésũ drí kpá tã âtázó kĩ nĩ rî, “Gõꞌdá kôrô lâŋõ kậyı̣̂ ꞌdĩ ꞌbá yí kâ vósĩ rî, ngá gólĩyî âꞌdó ꞌbá ꞌbũû ꞌálâ rî ꞌbá yî âꞌdô ĩyî rû îyáꞌá ndrĩ, îcá ĩyî kô lôsĩ ꞌẽlé dódó. Gõꞌdá ı̣̃tú lı̣̃fı̣́ âꞌdô îkánágõꞌá ı̣́nı̣́rı̣́kúwạ́ ró, îcá kô võ îwálé. Gõꞌdá párá îcá kpá kô võ îwálé. Gõꞌdá ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ âꞌdô ĩyî lôꞌdéꞌá ndrĩ vũdrı̣́ ꞌbũû lésĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ꞌDĩî vósĩ rî, ngá gólâ ꞌẽ ꞌbá âgõ-âgõ mâ gólâ âjólé ûrú lésĩ nô kâ âꞌdálé rî, âꞌdô rû âꞌdáꞌá ꞌbũû ꞌálâ. Ĩtí rî, õjílã õrĩ ndrĩ kâ âꞌdô ĩyî ꞌẽꞌá ámâ ndrẽlé ânĩrĩ ꞌá mbãrãsãsã bê. Õzõ gólĩyî õndrê mâ trá rî, õjílã ãmbá ãꞌdô ĩyî ãwó ngõꞌá ũrı̣̃ drí sĩ, tãlâ má âꞌdô ꞌẽꞌá ânĩlí cú mbârâkã ạ́ngı̣́ bê gõꞌdá kpá ãmbã Ôvârí kâ bê. ");
INSERT INTO avu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Má âꞌdô ꞌẽꞌá mãlãyíkã yî ậzı̣́lı̣́ gûnı̣́yạ́ sĩ. Áâꞌdô ꞌẽꞌá gûnı̣́yạ́ võlé, gõꞌdá mãlãyíkã yî âꞌdô ĩyî rû êꞌbéꞌá ndrĩ võ ãlô ꞌá. Ôvârí âꞌdô gólĩyî jõꞌá ãngó ꞌásĩ ndrĩ, nĩꞌá õjílã ndrĩ gólĩyî yí drí njĩlí õjílã íyíkâ ró rî ꞌbá yî êꞌbélé võ ꞌásĩ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nĩ ârî drẽ úlı̣́ mãnĩgõ gólâ fê bı̣́ tãsĩ nõ, ĩîmbâ ró ãnî bê. Õzõ nĩ õndrê gárá lâ ꞌdĩ ꞌbá yî trá ârõꞌá bı̣́ bê cãrõ rî, nĩ âꞌdô nı̣̃ꞌá lâ kĩ nĩ rî, ôzê lı̣̃mvû trá ãnyî ꞌẽꞌá âcálé. ");
INSERT INTO avu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Âꞌdô ꞌẽꞌá âꞌdólé kpá ĩtí âgõ-âgõ ámákâ tãsĩ. Õzõ nĩ õndrê tã gólĩyî ndrĩ má drí âtálé ꞌdĩ ꞌbá yî trá rû ꞌẽrẽ ꞌá rî, nĩ âꞌdô nı̣̃ꞌá lâ kĩ nĩ rî, kậyı̣̂ má drí ꞌẽzó âgõlé rî trá ãnyî. ");
INSERT INTO avu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, tã ꞌdî ꞌbá yî âꞌdô ꞌẽꞌá rû ꞌẽlé sı̣́sı̣́ drẽ ãkpãkãꞌdã õjílã kậyı̣̂ nõ ꞌbá yí kâ ôdrãá ĩyî kô ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Õzõ ãngó nõ õndẽ gbõ lé ꞌbũû bê rî, úlı̣́ ámákâ îcá kô rû ndẽlé.” ");
INSERT INTO avu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Gõꞌdá Yésũ drí kpá tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí tã âgõ-âgõ íyíkâ ãngó nõ ꞌá rî kâ tãsĩ. Gólâ kĩ, “Kậyı̣̂ má drí ꞌẽzó âgõlé ãngó nõ ꞌá rî, õjílã ãzãkã îcá kô nı̣̃lâ, gbõ lé mãlãyíkã gólĩyî ûrú ꞌálâ rî ꞌbá yî (gõꞌdá mâ rî gógó Ôvârí rî mvá ró nõ bê) nı̣̃ı̣́ ĩyî kậyı̣̂ rî ꞌdĩ kpá kô. Ámâ átá nı̣̃ kậyı̣̂ rî ꞌdĩ cé nĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kậyı̣̂ gólâ má drí ꞌẽzó âgõlé tã-vó õjílã kâ kĩlí ãngó nõ ꞌá rî tú rî, âꞌdô ꞌbãꞌá nyé õzõ kậyı̣̂ gólâ Nówã kâ ạ̃kû ró nã sĩ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Gõꞌdá drẽ ãkpãkãꞌdã Ôvârí âjó lı̣̃mvû tı̣̃tı̣̃ kô ânĩꞌá õjílã ûfúlı̣́ tã õnjí ĩyíkâ tãsĩ rî, õjílã nã ꞌbá yî rî ĩyîngá drı̣̃-bạ́lạ́yı̣̂ ró tã ı̣̂sũ ãkó kĩꞌá nĩ rî, lâŋõ ãꞌdô ꞌẽꞌá ânĩlí ꞌdẽlé ĩyî drı̣̃ı̣̂. Gólĩyî rî trá ngá nyãlé, ngá mvũlı̣́, gõꞌdá ãgô rî ĩyî trá õkó gĩlí cãlé bũúũ kậyı̣̂ gólâ Nówã yî drí fĩzó kõlóngbõ ândrê ꞌá ĩyî nyãányâ pãlé rî tú. Gõꞌdá gólĩyî nı̣̃ı̣́ ĩyî kĩꞌá nĩ rî, ôzê trá ânĩꞌá ꞌdı̣̃lı̣́ rî kô, cãlé bũúũ kậyı̣̂ gólâ lı̣̃mvû tı̣̃tı̣̃ drí ânĩzó gólĩyî ûfúlı̣́ rî tú. Âꞌdô rû ꞌẽꞌá kpá ĩtí kậyı̣̂ mâ gólâ âjólé ûrú lésĩ rî drí ꞌẽrẽ âgõlé ãngó nõ ꞌá rî tú. Âgõ-âgõ ámákâ âꞌdô ꞌẽꞌá gólĩyî îrõlé îrõ. ");
INSERT INTO avu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Gõꞌdá kậyı̣̂ rî ꞌdĩ tú rî, õzõ ãgô rı̣̃ ãꞌdô ĩyî trá rĩꞌá ngá ꞌwãꞌá ạ́mvú ꞌá rî, áâꞌdô ãlô rî trõꞌá, gõzó ãzâ rî âyélé. ");
INSERT INTO avu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Gõꞌdá õzõ õkó ãꞌdô ĩyî rı̣̃ rĩꞌá ngá ꞌı̣̃ꞌá kúnı̣́ ngá ꞌı̣̃ kâ drı̣̃ı̣̂ rî, áâꞌdô kpá ãlô rî trõꞌá ĩꞌdî, gõzó ãzâ rî âyélé. ");
INSERT INTO avu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nĩ rî rĩlí tã mbı̣̂mbı̣̂ rî ꞌẽꞌẽ lâ sĩ âgõ-âgõ ámákâ tẽlé, tãlâ mĩ nı̣̃ı̣́ kậyı̣̂ gólâ má drí ꞌẽzó âgõlé rî kô. Ĩtí rî, nĩ rî ngíyá ró. ");
INSERT INTO avu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gõꞌdá nĩ ı̣̂sũ drẽ tã nô, tí ꞌbã-lı̣́pı̣̂ õró gõ ı̣̃tú-pá ngạ́cı̣̂ kâ gólâ ũgú drí ꞌẽzó ânĩlí ngá gólâkâ ûgũlı̣́ ꞌá lâ rî nı̣̃ı̣̂ rî, tí gólâ âꞌdô rĩꞌá ngíyá ró, gólâ îcá kô ũgú ꞌdĩ âyélé âfílí ngá gólâkâ ûgũlı̣́ gólâ drí jó ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gõꞌdá kpá rĩꞌá ĩtí âgõ-âgõ ámákâ tãsĩ. Nĩ rî rĩlí ngíyá ró, tãlâ mĩ nı̣̃ı̣́ kậyı̣̂ gólâ má drí ꞌẽzó âgõlé ꞌá lâ rî kô. Má âꞌdô âgõꞌá nyĩî ró.” ");
INSERT INTO avu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Gõꞌdá nĩngá sĩ rî, Yésũ drí kpá tã îmbázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí tã rû ı̣̂ꞌbũ ꞌbá tãndí rî kâ tãsĩ. Gólâ kĩ, “ꞌBã-lı̣́pı̣̂ âꞌdô ãꞌdô ꞌẽꞌá ĩꞌdî rû ı̣̂ꞌbũ ꞌbá gólâ tã nı̣̃nı̣̃ bê lı̣̃fı̣́ ꞌbãzó drı̣̃ lâ ꞌá rî drí yã? Õzõ gólâ õtírĩ ꞌẽê nĩlí ậcı̣́ íyíkâ ꞌá rî, gólâ âꞌdô ꞌẽꞌá rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbãlé ãzí-ãzí lâ yî vó ndrẽlé mbı̣̂mbı̣̂ lôsĩ lânjî-lânjî sĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Gõꞌdá õzõ ꞌbã-lı̣́pı̣̂ rî ꞌdĩ ãâgõ trá âcálé rû ı̣̂ꞌbũ ꞌbá gólâkâ ꞌdĩ ûsúlı̣́ tã ꞌdî ꞌẽrẽ ꞌá tãndí ró ĩtí rî, gólâ âꞌdô ꞌbãꞌá ãyĩkõ ró rû ı̣̂ꞌbũ ꞌbá ꞌdĩ bê. ");
INSERT INTO avu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, ꞌbã-lı̣́pı̣̂ ꞌdĩ âꞌdô rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbãꞌá ngá íyíkâ ꞌbã kâ ndrĩ rî ꞌbá yî vó lâ ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gõꞌdá õzõ rû ı̣̂ꞌbũ ꞌbá gólâ ꞌbãlé ãzí-ãzí lâ yî vó ndrẽlé ꞌdĩ ãꞌdô rû ı̣̂ꞌbũ ꞌbá õnjí ꞌî rî, õzõ ꞌbã-lı̣́pı̣̂ ꞌdĩ õnjã trá ậcı̣́ gólâkâ ꞌdĩ ꞌá rî, rû ı̣̂ꞌbũ ꞌbá ꞌdĩ âꞌdô tã ı̣̂sũꞌá kĩ nĩ rî, ꞌbã-lı̣́pı̣̂ íyíkâ ꞌdĩ njã trá rõô, gólâ îcá kô âgõlé ꞌwãâ. ");
INSERT INTO avu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ꞌdĩ drí ngãzó rĩꞌá rû ı̣̂ꞌbũ ꞌbá ãzí ꞌdĩ ꞌbá yî ꞌẽlé õnjí ró, rĩꞌá gólĩyî cãlé, gõꞌdá drílâ rĩzó cé ngá nyãlé ĩꞌdî gõꞌdá kpá õdrá mvũlı̣́ õdrá mvũ ꞌbá ãzí lâ yí bê. ");
INSERT INTO avu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Gõꞌdá õzõ ꞌbã-lı̣́pı̣̂ rû ı̣̂ꞌbũ ꞌbá ꞌdĩ kâ õtírĩ âgõô âcálé rî, gólâ âꞌdô âcáꞌá nyĩî ró, ı̣̃tú gólâ rû ı̣̂ꞌbũ ꞌbá ꞌdĩ drí nı̣̃lı̣́ kôꞌdáwá rî sĩ. ");
INSERT INTO avu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ꞌBã-lı̣́pı̣̂ âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá drílâ, õzõ lâŋõ ꞌẽꞌá fẽlâ tã õnjí ꞌẽ ꞌbá drí rî kâtí, gõꞌdá âꞌdô gólâ rî vũꞌá võ lâŋõ kâ rî ꞌá, tólâ gólâ âꞌdô ãwó ngõꞌá sı̣́-gílí nyãnyã bê ngá lâzê-lâzê drí sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ drí îtõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îmbálé âgõ-âgõ íyíkâ ãngó nõ ꞌá kúmú ró rî tãsĩ. Gólâ kĩ, “Âgõ-âgõ ámákâ kúmú ró ãngó nõ ꞌá rî âꞌdô gõꞌdá âꞌdóꞌá õzõ õkó mvá mûdrı̣́ gólĩyî rĩ ꞌbá õdrógô drı̣̃ tẽlé rî kâtí. Gólĩyî trõ lámbã ĩyíkâ trá nĩzó õdrógô drı̣̃ tẽlé. ");
INSERT INTO avu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Õkó mvá njı̣̂ rî ꞌbá yî rĩꞌá tã nı̣̃ ꞌbá ꞌî, gõꞌdá gólĩyî ãzâ njı̣̂ rî ꞌbá yî rĩꞌá tã nı̣̃ ãkó lé ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gõꞌdá õkó mvá gólĩyî njı̣̂ tã nı̣̃ ãkó lé ꞌbá ró rî ꞌbá yî trõ lámbã ĩyíkâ bê rî, gólĩyî trõó dõ ạ̃lı̣́pı̣̂ kpãâ kô ĩyí bê. ");
INSERT INTO avu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Gõꞌdá õkó mvá gólĩyî tã nı̣̃ ꞌbá rî yî trõ lámbã ĩyíkâ bê rî, gólĩyî trõ dõ ạ̃lı̣́pı̣̂ kpãâ ĩyí bê mãlãngĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Gõꞌdá õdrógô drílĩyî rĩꞌá tẽlâ rî âcá kô ꞌwãâ, gõꞌdá ậꞌdú drí îtõzó rĩꞌá gólĩyî ꞌẽlé, gólĩyî trá lûsû-lûsû ró ậꞌdú drí sĩ, gõꞌdá drílĩyî ngãzó ậꞌdú kõlé. ");
INSERT INTO avu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Gõꞌdá câ bê ãꞌbí ító ꞌá rî, õkó mvá gólĩyî mûdrı̣́ ꞌdĩ ꞌbá yî drí ôtrê-ôtrê ârízó kĩ nĩ rî, ‘Nĩ ndrê drẽ, õdrógô bí ânĩꞌá! Nĩ âfõ ꞌwãâꞌwâ gólâ rî lậgúlı̣́!’ ");
INSERT INTO avu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gõꞌdá õkó mvá mûdrı̣́ ꞌdĩ ꞌbá yî drí lı̣̃fı̣́ njı̣̃zó ậꞌdú ꞌásĩ, gõꞌdá drílĩyî îtõzó rĩꞌá lámbã ĩyíkâ ꞌdĩ ꞌbá yî bãgó lâ êdélé. ");
INSERT INTO avu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gõꞌdá õkó mvá gólĩyî njı̣̂ tã nı̣̃ ãkó lé ꞌbá ró rî ꞌbá yî ûsû ĩyî võ lâ bê trá kĩ, dõ lámbã ĩyíkâ ꞌá rî bê trá ꞌẽꞌá rû ndẽlé rî, õkó mvá njı̣̂ ꞌdĩ ꞌbá yî drí tã âtázó õkó mvá gólĩyî tã nı̣̃ ꞌbá ró rî yî drí kĩ nĩ rî, ‘Nĩ âfẽ dõ ạ̃lı̣́pı̣̂ ãmâ drí, tãlâ dõ ãmákâ trá ꞌẽꞌá rû ndẽlé.’ ");
INSERT INTO avu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Gõꞌdá õkó mvá tã nı̣̃ ꞌbá ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó õkó mvá gólĩyî tã nı̣̃ ãkó lé ꞌbá ró rî ꞌdĩ ꞌbá yî drí kĩ, ‘Dõ nô îcá ãmâ drí ãní bê kô, nĩ nĩ dõ gĩlí dõ lậzı̣́ ꞌbá ngálâ.’ ");
INSERT INTO avu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Gõꞌdá õkó mvá gólĩyî tã nı̣̃ ãkó lé ꞌbá ró ꞌdĩ ꞌbá yî drí ngãzó nĩlí võ dõ gĩ kâ ꞌálâ. Gõꞌdá gólĩyî õtírĩ lậvũû rî, õdrógô drí íyîngá âcázó. Õkó mvá gólĩyî njı̣̂ lámbã ĩyíkâ êdé ꞌbá njãâ rî ꞌbá yî drí fĩzó õdrógô bê jó kãrámã kâ ꞌálâ, gõꞌdá ódrí ạ́tı̣̃ âꞌbãzó. ");
INSERT INTO avu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ꞌDĩî vósĩ rî, õkó mvá gólĩyî tã nı̣̃ ãkó lé ꞌbá ró ꞌdĩ ꞌbá yî drí âgõzó âcálé võ dõ gĩ kâ rî lésĩ. Gõꞌdá gólĩyî âgõ bê âcálé rî, áâꞌbã ạ́tı̣̃ trá kpạ̃ạ́kũ. Gõꞌdá drílĩyî lạ̃zı̣́ zı̣̃zó kĩ nĩ rî, ‘Kúmú, kúmú, ní njı̣̃ ạ́tı̣̃ ãmâ drí!’ ");
INSERT INTO avu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Gõꞌdá õdrógô drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, ‘Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, má nı̣̃ı̣́ ãnî kô.’ ” ");
INSERT INTO avu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ạ̃dũkũ lâ ró, Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ rî njãâ âgõ-âgõ ámákâ tẽlé, tãlâ mĩ nı̣̃ı̣́ kậyı̣̂ gólâ má drí ꞌẽzó âgõlé ꞌá lâ rî kô. Má âꞌdô âgõꞌá âcálé nyĩî ró.” ");
INSERT INTO avu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Gõꞌdá nĩngá sĩ rî, Yésũ drí íꞌdígówá ãzâ ngĩzó drı̣́-ꞌâ drílâ ꞌẽꞌá fẽlâ õjílã íyíkâ drí lôsĩ íyíkâ ꞌẽzó rî tãsĩ kậyı̣̂ drílâ ꞌẽzó âgõlé kúmú ró rî sĩ. Gólâ kĩ, “Tã drı̣́-ꞌâ Ôvârí drí ꞌẽꞌá fẽlâ õjílã íyíkâ drí lôsĩ íyíkâ ꞌẽzó rî tãsĩ rî rĩꞌá õzõ kúmú ãzâ ꞌẽ ꞌbá nĩlí ậcı̣́ íyíkâ ꞌá jẽjẽ ró rî kâtí. Gõꞌdá drẽ ãkpãkãꞌdã gólâ nĩí kô ậcı̣́ íyíkâ ꞌdĩ ꞌá rî, gólâ drí rû ı̣̂ꞌbũ ꞌbá íyíkâ nâ rî ꞌbá yî ậzı̣́zó, gõꞌdá drílâ tã âtázó drílĩyî kĩ nĩ rî, ‘Nĩ ndrê ngá ámákâ nõ ꞌbá yî vó lâ dódó.’ ");
INSERT INTO avu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gõꞌdá kúmú ꞌdĩ drí ậdı̣̂ fẽzó drílĩyî, âꞌdô mbârâkã gólĩyíkâ sũzó ngá rú rî vó ró, tãlâ gólĩyî ũlı̣̂pı̣̃ ró ậdı̣̂ íyíkâ ꞌdĩ bê. Gõꞌdá rû ı̣̂ꞌbũ ꞌbá sı̣́sı̣́ rî drí rî, gólâ drí ậdı̣̂ fẽzó kísĩ njı̣̂, gõꞌdá rû ı̣̂ꞌbũ ꞌbá rı̣̃ lâ ró rî drí, gólâ drí ậdı̣̂ fẽzó kísĩ rı̣̃, gõꞌdá rû ı̣̂ꞌbũ ꞌbá nâ ró rî drí, gólâ drí ậdı̣̂ fẽzó kísĩ ãlô. Nĩngá sĩ, kúmú ꞌdĩ drí ngãzó nĩlí ậcı̣́ íyíkâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá gólâ sı̣́sı̣́ ậdı̣̂ fẽzó drílâ kísĩ njı̣̂ rî, gólâ drí nĩzó lôsĩ ãzâ ꞌẽlé ậdı̣̂ ꞌdĩ sĩ, tãlâ ậdı̣̂ ꞌdĩ ũlı̣̂pı̣̃ ró bê. Gõꞌdá drílâ ậdı̣̂ ãzâ ûsúzó kpá kísĩ njı̣̂ lôsĩ ꞌẽꞌẽ sĩ. Ậdı̣̂ gólâkâ ꞌdĩ drí lı̣̂pı̣̃zó âcálé kísĩ mûdrı̣́. ");
INSERT INTO avu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá gólâ ậdı̣̂ fẽzó drílâ kísĩ rı̣̃ rî drí kpá nĩzó lôsĩ ꞌẽlé ậdı̣̂ fẽlâ gólâ drí ꞌdĩ sĩ. Gõꞌdá drílâ ậdı̣̂ ãzâ ûsúzó kpá kísĩ rı̣̃ lôsĩ ꞌẽꞌẽ sĩ. Ậdı̣̂ gólâkâ drí lı̣̂pı̣̃zó âcálé kísĩ sû. ");
INSERT INTO avu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá gólâ ậdı̣̂ fẽzó drílâ kísĩ ãlô rî drí nĩzó ꞌbú ꞌdı̣̃lı̣́ ậdı̣̂ kúmú gólâkâ ꞌdĩ kâ lậpı̣́zó ꞌá lâ, tãlâ yí drí sũzó bê ậdı̣̂ ꞌdĩ rú kúmú drí. ");
INSERT INTO avu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Gõꞌdá kậyı̣̂ dũû vósĩ, kúmú ꞌdĩ drí âcázó âgõlé yí drí ꞌbã ꞌá. Gólâ âgõ bê rî, gólâ drí rû ı̣̂ꞌbũ ꞌbá íyíkâ ꞌdĩ ꞌbá yî ậzı̣́zó yí ngálâ, tãlâ gólĩyî âꞌdâ ró lôsĩ gólĩyî drí ꞌẽlé ậdı̣̂ íyíkâ ꞌdĩ sĩ rî bê yí drí. ");
INSERT INTO avu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá gólâ ậdı̣̂ fẽzó drílâ kísĩ njı̣̂ rî drí ậdı̣̂ gólâ drí ûsúlı̣́ ndrĩ rî âtrõzó âjílí kúmú drí. Gõꞌdá drílâ ngãzó tã âtálé kĩ nĩ rî, ‘Ãmbá, ní ndrê drẽ, ậdı̣̂ ní drí fẽlé má drí kísĩ njı̣̂ sı̣́sı̣́ rî ĩꞌdî rĩꞌá nõ. Gõꞌdá má ûsû ậdı̣̂ ãzâ kpá kísĩ njı̣̂ ậdı̣̂ rî ꞌdĩ drı̣̃ı̣̂, ậdı̣̂ lâ ĩꞌdî rĩꞌá nõ!’ ");
INSERT INTO avu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Gõꞌdá kúmú drí rû ı̣̂ꞌbũ ꞌbá ꞌdĩ lûyı̣́zó kĩ nĩ rî, ‘Ní rĩꞌá rû ı̣̂ꞌbũ ꞌbá ámákâ tãndí ró má drí lı̣̃fı̣́ ꞌbãzó drı̣̃ lâ ꞌá rî ĩꞌdî. Tãlâ ní ndrê ậdı̣̂ fínyáwá má drí fẽlé ní drí rî vó lâ trá tãndí ró, má âꞌdô ánî ꞌbãꞌá ngá ámákâ ãmbá rî ꞌbá yî vó lâ ndrẽlé. Ní ânĩ, mã ꞌê ró ãyĩkõ ní bê.’ ");
INSERT INTO avu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Gõꞌdá rû ı̣̂ꞌbũ ꞌbá gólâ ậdı̣̂ fẽzó drí lâ kísĩ rı̣̃ rî drí kpá ậdı̣̂ gólâ drí ûsúlı̣́ rî âtrõzó âjílí kúmú drí. Gõꞌdá drílâ tã âtázó kĩ nĩ rî, ‘Ãmbá, ní ndrê drẽ, ậdı̣̂ ní drí fẽlé má drí kísĩ rı̣̃ rî rĩꞌá nõ. Má ûsû ậdı̣̂ ãzâ kpá kísĩ rı̣̃ ậdı̣̂ rî ꞌdĩ drı̣̃ı̣̂, ậdı̣̂ lâ ĩꞌdî rĩꞌá nõ!’ ");
INSERT INTO avu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Gõꞌdá kúmú drí kpá rû ı̣̂ꞌbũ ꞌbá íyíkâ ꞌdĩ lûyı̣́zó kĩ nĩ rî, ‘Nî rĩꞌá rû ı̣̂ꞌbũ ꞌbá ámákâ tãndí ró má drí lı̣̃fı̣́ ꞌbãzó drı̣̃ lâ ꞌá rî ĩꞌdî. Tãlâ ní ndrê ậdı̣̂ fínyáwá má drí fẽlé ní drí rî vó lâ trá tãndí ró, má âꞌdô ánî ꞌbãꞌá ngá ámákâ ãmbá rî ꞌbá yî vó lâ ndrẽlé. Ní ânĩ, mã ꞌê ró ãyĩkõ ní bê.’ ");
INSERT INTO avu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Gõꞌdá rû ı̣̂ꞌbũ ꞌbá gólâ ậdı̣̂ fẽzó drílâ kísĩ ãlô rî drí ngãzó ậdı̣̂ fẽlé gólâ drí rî lôgõlé kúmú drí. Gõꞌdá drílâ tã ı̣̂sũ íyî nyãányâ kâ âtázó kúmú drí kĩ nĩ rî, ‘Ãmbá, má nı̣̃ trá kĩ nĩ rî, nî rĩꞌá sı̣́ lõmbâ ꞌbá ꞌî, tãlâ ậdı̣̂ ánî nyãányâ kâ rî ậpı̣̃lı̣́ lôsĩ rû ı̣̂ꞌbũ ꞌbá áníkâ rî ꞌbá yí kâ sĩ, gõꞌdá ní rî kpá ngá ĩyínyâ tíbê ánî nyãányâ drí ı̣̂ꞌdı̣́lı̣́ nĩ kôꞌdáwá rî ꞌbá yî êꞌbélé ánî nyãányâ drí. ");
INSERT INTO avu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ĩtí rî, mâ rĩꞌá ũrı̣̃ ró ậdı̣̂ áníkâ ꞌdĩ îzãlé. Tã ꞌdî tãsĩ rî, ĩꞌdî má drí nĩzó ꞌbú ꞌdı̣̃lı̣́ ậdı̣̂ ꞌdĩ lậpı̣́zó ꞌá lâ. Ní ndrê, ậdı̣̂ rî ĩꞌdî rĩꞌá nõ.’ ");
INSERT INTO avu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Gõꞌdá kúmú drí tã-drı̣̃ lôgõzó rû ı̣̂ꞌbũ ꞌbá ꞌdĩ drí kĩ nĩ rî, ‘Nî rĩꞌá rû ı̣̂ꞌbũ ꞌbá õnjí ꞌî, rû ı̣̂ꞌbũ ꞌbá gólâ õvó ró rî ĩꞌdî. Mí nı̣̃ trá kĩ nĩ rî, má rî ậdı̣̂ ûsúlı̣́ rû ı̣̂ꞌbũ ꞌbá ámákâ rî ꞌbá yî drı̣́gạ́ sĩ. Gõꞌdá má rî kpá ngá ĩyínyâ tíbê ámâ nyãányâ drí ı̣̂ꞌdı̣́lı̣́ nĩ kôꞌdáwá rî ꞌbá yî êꞌbélé má drí. ");
INSERT INTO avu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ní lậpı̣̂ ậdı̣̂ ámákâ ãꞌdô tãsĩ yã? Tí âꞌdô âꞌdóꞌá tãndí ró ní drí ậdı̣̂ ꞌdĩ fẽzó õjílã ãzâ drí lôsĩ ꞌẽzó ĩꞌdî sĩ lâ, ãꞌdô ró bê gólâ drí ậdı̣̂ ãzâ ûsúzó fínyáwá gá drı̣̃ lâ ꞌá, tãlâ má õtírĩ âgõô rî, má ũûsû ró bê ậdı̣̂ rî ꞌdĩ cú drı̣̃ bê.’ ");
INSERT INTO avu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Nĩngá sĩ, kúmú drí tã ꞌbãzó rû ı̣̂ꞌbũ ꞌbá íyíkâ ãlô rî drí kĩ, ‘Ní trõ ậdı̣̂ ꞌdĩ vólé rû ı̣̂ꞌbũ ꞌbá õnjí ꞌdĩ drı̣́gạ́ sĩ, fẽlé rû ı̣̂ꞌbũ ꞌbá gólâ ậdı̣̂ ûsú ꞌbá kísĩ mûdrı̣́ rî drí.’ ");
INSERT INTO avu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gõꞌdá kúmú drí tã âtázó kĩ nĩ rî, ‘Õjílã gólâ âꞌdó ꞌbá ngá bê rî, áâꞌdô ꞌẽꞌá ngá fẽlé gólâ drí ãmbá lậvũlı̣́ gạ̃rạ̃ ngá gólâ drí ûsúlı̣́ rî drı̣̃ı̣̂ sĩ. Gõꞌdá õjílã gólâ âꞌdó ꞌbá ngá ãkó rî, gbõ lé ngá fínyáwá gólâ drí ûsúlı̣́ rî, áâꞌdô trõꞌá lâ vólé gólâ drı̣́gạ́ sĩ.’ ");
INSERT INTO avu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gõꞌdá kúmú drí tã âtázó kĩ nĩ rî, ‘Rû ı̣̂ꞌbũ ꞌbá gólâ lôsĩ ꞌẽ ꞌbá kô nõ, ótrõ gólâ vũlı̣́ ĩví ꞌálâ ı̣́nı̣́rı̣́kúwạ́ ꞌá, võ gólâ Ôvârí drí êdélé Sãtánã yî drí rî ꞌá, võ gólâ õjílã drí ꞌẽzó ãwó ngõlé sı̣́-gílí nyãnyã bê rî ꞌá.’ ” ");
INSERT INTO avu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Gõꞌdá nĩngá sĩ rî, Yésũ drí tã âtázó âgõ-âgõ íyíkâ ãngó ꞌá nõngá tã-vó õjílã kâ kĩlí rî tãsĩ. Gólâ kĩ, “Kậyı̣̂ tíbê mâ gólâ âjólé ûrú lésĩ rî drí ꞌẽzó âgõlé ãngó nõ ꞌá rî sĩ, má âꞌdô âgõꞌá mbârâkã ãkĩ bê, mãlãyíkã ámákâ rî ꞌbá yî âꞌdô ĩyî ꞌbãꞌá ndrĩ má bê. Má âꞌdô rĩꞌá kúmú ró kı̣́tı̣̃ ámákâ drı̣̃ı̣̂ drı̣́-ãcê bê tã-vó õjílã kâ kĩlí. ");
INSERT INTO avu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gõꞌdá õjílã õrĩ ndrĩ kâ ãngó ꞌásĩ rî ꞌbá yî âꞌdô ĩyî rû êꞌbéꞌá ndrĩ má ândrá. Má âꞌdô gólĩyî lãfá cãꞌá rı̣̃, õzõ kạ́bı̣̃lı̣́kı̣̃ lãfá cãrẽ ı̣̃ndrı̣̂ rú sĩ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Má âꞌdô õjílã tã mbı̣̂ ꞌbá rî ꞌbá yî ꞌbãꞌá ámâ drı̣́-ágó drı̣̃ lésĩ ró, gõꞌdá má âꞌdô õjílã tã õnjí ꞌbá ró rî ꞌbá yî ꞌbãꞌá ĩyíkâ ámâ drı̣́-lı̣̃jı̣́ lésĩ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Gõꞌdá mâ gólâ rĩ ꞌbá kúmú ró rî âꞌdô tã âtáꞌá õjílã gólĩyî ámâ drı̣́-ágó drı̣̃ lésĩ rî ꞌbá yî drí kĩ nĩ rî, ‘Ãnî õjílã gólĩyî ámâ átá drí õrẽ fẽzó drílĩyî rî ĩꞌdî, nĩ ânĩ ngá tãndí gólĩyî Ôvârí drí êdélé ãnî õjílã íyíkâ ró rî ꞌbá yî drí îtõ võ ãngó nõ kâ sĩ rî trõlé ãnî drí drı̣́-ꞌâ ró. ");
INSERT INTO avu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tãlâ má âꞌdô bê lõfó ró rî, nĩ âfẽ ngá nyãnyã trá má drí nyãlé. Gõꞌdá lı̣̃mvû lôvó ꞌê mâ bê rî, nĩ âfẽ lı̣̃mvû trá má drí mvũlı̣́. Gõꞌdá nĩ ndrê mâ bê õjílã lídí ró rî, nĩ lậgû mâ trá ãnî drí ꞌbã ꞌá ũmú ró. ");
INSERT INTO avu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Gõꞌdá nĩ ndrê mâ bê ítá ĩzã bê rî, nĩ âfẽ ítá trá má drí sõlé. Gõꞌdá má âꞌdô bê ngá lãzé ró rî, nĩ ndrê ámâ vó trá tãndí ró. Gõꞌdá óꞌbã mâ bê gạ̃nı̣́mạ̃ ꞌá rî, nĩ ânĩ trá ámâ lômílí.’ ");
INSERT INTO avu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Gõꞌdá õjílã tã mbı̣̂ ꞌbá âꞌdô ĩyî tã-drı̣̃ lôgõꞌá má drí kĩ nĩ rî, ‘Kúmú, mã ndrê nî lõfó ró ãmâ drí ngá nyãnyã fẽzó ní drí nyãlé rî ángô tú yã? Mã ndrê nî lı̣̃mvû lôvó bê ãmâ drí lı̣̃mvû fẽzó ní drí mvũlı̣́ rî ángô tú yã? ");
INSERT INTO avu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mã ndrê nî õjílã lídí ró ãmâ drí ánî lậgúzó ãmâ drí ꞌbã ꞌá ũmú ró rî ángô tú yã? Gõꞌdá mã ndrê nî ítá ĩzã bê ãmâ drí ítá fẽzó ní drí sõlé rî ángô tú yã? ");
INSERT INTO avu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gõꞌdá mã ndrê nî ngá lãzé ró ngãtá gạ̃nı̣́mạ̃ ꞌá ãmâ drí nĩzó ánî ndrẽlé rî ángô tú yã?’ ");
INSERT INTO avu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Gõꞌdá mâ kúmú ró rî âꞌdô tã-drı̣̃ lôgõꞌá drílĩyî kĩ nĩ rî, ‘Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ nĩ õpâ õjílã ámákâ ãlô rî trá rî, gbõ lé óõndrê õjílã rî ꞌdĩ ngá tãkó ró rî, nĩ pâ ꞌdĩ kpá mâ ĩꞌdî.’ ");
INSERT INTO avu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Gõꞌdá má âꞌdô rû jãꞌá tã âtálé õjílã gólĩyî ámâ drı̣́-lı̣̃jı̣́ drı̣̃ lésĩ rî ꞌbá yî drí kĩ nĩ rî, ‘Ãnî gólĩyî Ôvârí drí trĩlí nõ ꞌbá yî, nĩ nĩ vólé má lạ̃gạ́tı̣́ sĩ, nĩꞌá lạ̃sı̣́ gólâ rĩ ꞌbá vẽlé ạ̃dũkũ ãkó tíbê Ôvârí drí êdélé Sãtánã yî drí mãlãyíkã gólâkâ rî ꞌbá yí bê rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tãlâ nĩ ndrê mâ bê lõfó ró rî, nĩ âfẽé ngá nyãnyã kô má drí nyãlé, gõꞌdá nĩ ndrê mâ bê lı̣̃mvû lôvó bê rî, nĩ âfẽé lı̣̃mvû kô má drí mvũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gõꞌdá nĩ ndrê mâ bê õjílã lídí ró rî, nĩ lậgú mâ kô ãnî drí ꞌbã ꞌá. Gõꞌdá nĩ ndrê mâ bê ítá ĩzã bê rî, nĩ âfẽé ítá kô má drí sõlé. Gõꞌdá má âꞌdô bê ngá lãzé ró rî, nĩ ndré ámâ vó kô. Gõꞌdá óꞌbã mâ bê gạ̃nı̣́mạ̃ ꞌá rî, nĩ ânĩí kô ámâ ndrẽlé.’ ");
INSERT INTO avu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Gõꞌdá õjílã rî ꞌdĩ ꞌbá yî âꞌdô ĩyî tã-drı̣̃ lôgõꞌá kĩ nĩ rî, ‘Kúmú, mã ndrê nî lõfó ró rî ángô tú yã, ngãtá lı̣̃mvû lôvó bê rî ángô tú yã, ngãtá õjílã lídí ró rî ángô tú yã, ngãtá ítá ĩzã bê rî ángô tú yã, ngãtá ngá lãzé ró rî ángô tú yã, ngãtá gạ̃nı̣́mạ̃ ꞌá rî ángô tú ãmâ drí ánî pãzó kô rî yã?’ ");
INSERT INTO avu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Gõꞌdá má âꞌdô tã-drı̣̃ lôgõꞌá drílĩyî kĩ, ‘Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ nĩ õgâ vólé trá dó õjílã ámákâ ãlô rî pãlé rî, gbõ lé óõndrê õjílã rî ꞌdĩ ngá tãkó ró rî, nĩ gâ vólé ꞌdĩ kpá trá dó ãmâ pãlé.’ ");
INSERT INTO avu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Gõꞌdá Ôvârí âꞌdô õjílã õnjí ꞌdĩ ꞌbá yî jõꞌá võ gólâ lâŋõ ạ̃dũkũ ãkó rî kâ rî ꞌá. Gõꞌdá tã mbı̣̂ ꞌbá âꞌdô ĩyî nĩꞌá cé nĩ rĩlí Ôvârí bê zãâ gbạ́dú ạ̃dũkũ ãkó.” ");
INSERT INTO avu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ ndẽlé bê tã îmbâ íyíkâ ꞌdĩ ꞌbá yî ndrĩ rî, drílâ gõzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, ");
INSERT INTO avu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nĩ nı̣̃ trá kĩ, kậyı̣̂ ꞌẽzó kãrámã lậvũ-lậvũ kôrô kâ ꞌẽlé rî âꞌdô ꞌẽꞌá îtõlé kậyı̣̂ rı̣̃ vósĩ. Mâ rî gógó âjólé ûrú lésĩ nõ, áâꞌdô ámâ drı̣́-bã fẽꞌá ámâ ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́. Gólĩyî âꞌdô ámâ îpáꞌá fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Gõꞌdá kậyı̣̂ Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí ꞌdĩ sĩ, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá õjílã sı̣́sı̣́-lésĩ rî ꞌbá yí bê, gólĩyî êꞌbê ĩyî rû trá drı̣̃-ꞌbá drı̣̃-ꞌbá ãzí rî ꞌbá yî drı̣̃lı̣́ rú bê Kãyífã rî drí ꞌbã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Gólĩyî êꞌbê rû tólâ ꞌdĩ, tãlâ tã ı̣̂ꞌbı̣̃lı̣́ ĩyî võ ꞌásĩ Yésũ rî rũzó bê kírî ró gólâ rî fũzó vólé. ");
INSERT INTO avu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Gõꞌdá gólĩyî ı̣̂sũ tã trá kĩ nĩ rî, âꞌdó kô tãndí ró ĩyî drí Yésũ rî rũzó kậyı̣̂ kãrámã lậvũ-lậvũ kôrô kâ ꞌdĩ sĩ, tãlâ õjílã dũû âꞌdô ngãꞌá ạ̃wạ̃ ꞌẽlé ĩyí bê. ");
INSERT INTO avu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kậyı̣̂ ꞌdĩ ꞌbá yî sĩ rî, Yésũ yî rî rĩlí jạ̃rı̣́bạ̃ zı̣̃lı̣́ Bẽtánĩ rî ꞌálâ, ãgô ãzâ gólâ drí êdélé ngá lãzé ãrí kâ ꞌásĩ rú bê Sĩmónã rî drí ꞌbã ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Gõꞌdá Yésũ yî õtírĩ ꞌbãâ ngá nyãꞌá Sĩmónã drí ꞌbã ꞌá tólâ rî, õkó ãzâ drí dõ gólâ ạ̃jı̣́ bê tũrũ-tũrũ rî âtrõzó mãlãngĩ gólâ êdélé kúnı̣́ zı̣̃lı̣́ ãlãbãsétã rî ꞌásĩ rî ꞌá, ânĩꞌá ûtúlâ Yésũ drı̣̃ı̣̂. Lâgî dõ rî ꞌdĩ kâ lậvũ gạ̃rạ̃ dõ ãzí drı̣̃ı̣̂ sĩ. Õkó ꞌdĩ ꞌê tã ꞌdî ĩtí ꞌdĩ tãlâ Yésũ rî ı̣̂njı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ndrê ĩyî tã õkó ꞌdĩ drí ꞌẽlé ꞌdĩ bê rî, tã ꞌdî ꞌbãá gólĩyî gõꞌdá kô âꞌdólé ãyĩkõ ró. Drílĩyî rĩzó tã âtálé ĩyî lãfálé ꞌásĩ kĩ, “ꞌDĩî rĩꞌá tã ngá îzã-îzã kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tí âꞌdô âꞌdóꞌá tãndí ró õzõ óõꞌbã dõ ꞌdî gĩlí vólé ậdı̣̂ ãmbá sĩ, gõzó ậdı̣̂ lâ fẽlé ngá ãkó lé ꞌbá rî ꞌbá yî pãzó rî.” ");
INSERT INTO avu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Gõꞌdá Yésũ nı̣̃ tã ı̣̂sũ lãjóꞌbá ꞌdĩ ꞌbá yí kâ ꞌdĩ bê rî, gólâ drí ngãzó tã âtálé drílĩyî kĩ nĩ rî, “Nĩ rî õkó ꞌdĩ îkpókpólõlé ĩtí ãꞌdô tãsĩ yã? Gólâ ꞌê ꞌdĩ tã tãndí ꞌî má drí. Tã gólâkâ ꞌdĩ sû trá má rú tákányĩ. ");
INSERT INTO avu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ngá ãkó lé ꞌbá ró rî ꞌbá yî âꞌdô ĩyî ꞌbãꞌá ãní bê nõngá kậyı̣̂ vósĩ cé. Gõꞌdá má îcá kô rĩlí zãâ ãní bê nõngá. ");
INSERT INTO avu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dõ õkó ꞌdĩ drí ûtúlı̣́ má drı̣̃ı̣̂ ꞌdĩ, tã ífí lâ kĩ, gólâ êdê ꞌdĩ ámâ rúꞌbạ́ ãvõ ꞌî ꞌbãlé ꞌbú ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, õzõ óõtírĩ tã âtî-âtî tãndí Ôvârí kâ pẽê ãngó ꞌásĩ õjílã ꞌbạ̃súrú ndrĩ kâ rî drí rî, áâꞌdô tã tãndí õkó ꞌdĩ drí ꞌẽlé ꞌdĩ tã lâ âtáꞌá õjílã drí, tãlâ gólâ rî tã ı̣̂sũzó bê.” ");
INSERT INTO avu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Gõꞌdá nĩngá sĩ rî, lãjóꞌbá ãlô Yésũ kâ rú bê Yúdạ̃ Ĩsĩkãrĩyótã rî drí ngãzó nĩlí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ngálâ, tãlâ Yésũ rî drı̣́-bã fẽzó gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Gõꞌdá Yúdạ̃ drí tã îjízó gólĩyî tı̣́ kĩ nĩ rî, “Õzõ nĩ õlẽ tã-drı̣̃ trá má drí Yésũ rî drı̣́-bã fẽzó ãnî drí rî, nĩ âꞌdô ậdı̣̂ fẽꞌá má drí tạ̃sı̣̂ yã?” Gõꞌdá drílĩyî tã îjî Yúdạ̃ kâ ꞌdĩ drı̣̃ lâ lôgõzó. Gólĩyî drí ậdı̣̂ ífí lãzó nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́ sílĩvã ꞌásĩ fẽlé Yúdạ̃ drí. ");
INSERT INTO avu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Gõꞌdá îtõlé kậyı̣̂ rî ꞌdĩ ꞌásĩ rî, Yúdạ̃ drí îtõzó rĩꞌá lạ́tı̣̂ lôndãlé, tãlâ yí fẽ ró Yésũ rî drı̣́-bã bê gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gõꞌdá nĩngá sĩ, kậyı̣̂ drı̣̃-káká kãrámã ãmbãtã ạ̃kú ãkó rî kâ rî kâ âcâ bê rî, lãjóꞌbá Yésũ kâ rî ꞌbá yî drí ânĩzó tã îjílí gólâ tı̣́ kĩ nĩ rî, “Ní lẽ ãmâ drí nĩlí kãrámã lậvũ-lậvũ kôrô kâ êdélé ãmâ drí nyãlé ángô lé yã?” ");
INSERT INTO avu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Nĩ ngâ nĩlí fĩlí jạ̃rı̣́bạ̃ ạ́ngı̣́ Yẽrõsãlémã kâ nã ꞌálâ. Õzõ nĩ õcâ trá tólâ rî, nĩ âꞌdô ãgô ãzâ ûsúꞌá. Nĩ âtâ tã gólâ drí kĩ, ‘Tã îmbá ꞌbá ãmákâ kĩ nĩ rî, kậyı̣̂ gólâ Ôvârí drí ꞌbãlé yí drí rî trá ãnyî ꞌẽꞌá âcálé. Yí âꞌdô ânĩꞌá kãrámã lậvũ-lậvũ kôrô kâ nyãlé ní drí ꞌbá ꞌá ãmâ lãjóꞌbá íyíkâ yí bê.’ ” ");
INSERT INTO avu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí nĩzó ĩyî tã ꞌdî ꞌẽlé té õzõ Yésũ drí âtálé gólĩyî drí ꞌdĩ kâtí. Drílĩyî ngá nyãnyã kãrámã kâ êdézó ãgô ꞌdĩ drí ꞌbã ꞌá nĩngá. ");
INSERT INTO avu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gõꞌdá câ bê lạ̃njạ́túlı̣́ bê rî, Yésũ yî drí rû êꞌbézó võ ãlô ꞌá lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yí bê kãrámã ꞌdî nyãlé. ");
INSERT INTO avu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Gólĩyî õtírĩ ꞌbãâ rĩꞌá ngá nyãꞌá rî, Yésũ drí ngãzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, lãjóꞌbá ãlô ãnî lãfálé sĩ âꞌdô ámâ drı̣́-bã fẽꞌá ámâ ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́.” ");
INSERT INTO avu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ârî ĩyî úlı̣́ gólâ drí âtálé ꞌdĩ bê rî, gólĩyî drí âꞌdózó ndrĩ tã ı̣̂sũ ró rõô. Gõꞌdá drílĩyî ngãzó rĩꞌá ĩyî âꞌdálé Yésũ drí ãlô-ãlô kĩ, “Kúmú, õjílã ꞌẽ ꞌbá ánî drı̣́-bã fẽlé rî âꞌdô âꞌdóꞌá mâ ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Õjílã ãlô ãnî lãfálé ꞌásĩ gólâ ngbãângbânõ rĩ ꞌbá drı̣́ sõlé má bê sãánĩ ãtó kâ ãlô ꞌá rî âꞌdô ámâ drı̣́-bã fẽꞌá nĩ. ");
INSERT INTO avu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Áâꞌdô mâ gólâ âjólé ûrú lésĩ nô fũꞌá, õzõ tã lâ îgĩlí trá búkũ Ôvârí kâ ꞌá rî kâtí. Gõꞌdá õjílã gólâ ꞌẽ ꞌbá ámâ drı̣́-bã fẽlé ꞌdĩ, Ôvârí âꞌdô lâŋõ õnjí tẽtẽ fẽꞌá drílâ. Tí âꞌdô âꞌdóꞌá tãndí ró õzõ úũtı̣̂ õjílã rî ꞌdĩ kô.” ");
INSERT INTO avu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yúdạ̃ gólâ tíbê ꞌẽ ꞌbá Yésũ rî drı̣́-bã fẽlé rî drí tã îjízó gólâ tı̣́ kĩ nĩ rî, “Tã îmbá ꞌbá, âꞌdô âꞌdóꞌá ãꞌdî ĩꞌdî yã? Mâ ĩꞌdî yã?” Yésũ drí tã-drı̣̃ lôgõzó drílâ kĩ nĩ rî, “Ãwô, nî ĩꞌdî!” ");
INSERT INTO avu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Gõꞌdá Yésũ yî õtírĩ rĩî ngá nyãlé rî, gólâ drí ãmbãtã trõzó. Drílâ rãtáã ꞌẽzó Ôvârí drí ãmbãtã ꞌdî tãsĩ. Drílâ ãmbãtã ꞌdî ꞌâ lâ ûpı̣̃zó, gõꞌdá drílâ trõzó lâ fẽlé lãjóꞌbá íyíkâ yî drí tã âtâ-âtâ bê kĩ nĩ rî, “Nĩ trõ, nĩ nyâ, nõô rĩꞌá ámâ rúꞌbạ́ ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gõꞌdá Yésũ drí kpá ĩgã õdrá âlâꞌbâ kâ trõzó. Drílâ rãtáã ꞌẽzó Ôvârí drí tã lâ tãsĩ. Gõꞌdá drílâ fẽzó lâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí mvũlı̣́ tã âtâ-âtâ bê kĩ nĩ rî, “Ãnî ndrĩ, nĩ mvû! ");
INSERT INTO avu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nõô rî ámâ ãrí tã-drı̣̃ lẽlẽ óꞌdí êdézó Ôvârí yî lãfálé õjílã íyíkâ yí bê rî ĩꞌdî, tíbê rã ꞌbá tã õnjí õjílã kâ âyê-âyê kâ tãsĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Má âtâ ãnî drí, má îcá kô õdrá nõ mvũlı̣́, cãlé bũúũ kậyı̣̂ gólâ má drí ꞌẽzó mvũlâ ãní bê kpá óꞌdí kậyı̣̂ ámâ átá drí ámâ ꞌbãzó kúmú ró õjílã drı̣̃lı̣́ rî tú.” ");
INSERT INTO avu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nĩngá sĩ rî, Yésũ yî drí lôngó Ôvârí rî lûyı̣̂ kâ ngõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. ꞌDĩî vósĩ rî, drílĩyî nĩzó únı̣́ fê dõ kâ bê yí drı̣̃ı̣̂ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Gõꞌdá nĩngá sĩ rî, Yésũ drí tã lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí ꞌẽzó rãlé yí rú sĩ rî tã lâ âtázó gólĩyî drí. Gólâ kĩ, “Má âtâ ãnî drí, ngạ́cı̣̂ nõ sĩ, nĩ âꞌdô rãꞌá ndrĩ ámâ âyélé, tãlâ Ôvârí âtâ tã trá tã îgĩ íyíkâ ꞌá kĩ nĩ rî, ‘Má âꞌdô kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá fũꞌá, gõꞌdá kạ́bı̣̃lı̣́kı̣̃ gólâkâ âꞌdô ĩyî rû lâpẽꞌá ndrĩ vólé.’ ");
INSERT INTO avu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Má âꞌdô lîdríꞌá õdrã ꞌásĩ. ꞌDĩî vósĩ rî, má âꞌdô lậvũꞌá sı̣́sı̣́ ãnî ândrá Gãlĩláyã ꞌálâ. Nĩ âꞌdô nĩꞌá ámâ ûsúlı̣́ tólâ.” ");
INSERT INTO avu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Gõꞌdá Pétẽrõ drí ngãzó tã-drı̣̃ lôgõlé Yésũ drí kĩ nĩ rî, “Ámâ ãzí-ãzí yî õlậꞌbû gbõ lé ndrĩ ánî âyélé rî, má îcá kô ánî âyélé.” ");
INSERT INTO avu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Gõꞌdá Yésũ drí tã âtázó Pétẽrõ drí kĩ, “Pétẽrõ, má âtâ ní drí tã pạ̃tı̣́ı̣̃ ró, ngạ́cı̣̂ nõ sĩ, drẽ ãkpãkãꞌdã ꞌạ̃ꞌú-lúgú drí cı̣́rı̣̃ ꞌbẽ ãkó rî, ní âꞌdô tı̣̂ gãꞌá má rú sĩ ândâlâ nâ. Ní âꞌdô tã âtáꞌá kĩ nĩ rî, yí nı̣̃ı̣́ mâ kô.” ");
INSERT INTO avu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Gõꞌdá Pétẽrõ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Má îcá kô tı̣̂ gãlé ní rú sĩ. Õzõ ãꞌdô õdrã ꞌî rî, mã âꞌdô drãꞌá ní bê.” Gõꞌdá lãjóꞌbá ãzí ꞌdĩ ꞌbá yî drí kpá tã âtázó õzõ Pétẽrõ drí âtálé ꞌdĩ kâtí. ");
INSERT INTO avu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí nĩzó cãlé võ gólâ zı̣̃lı̣́ Gẽtẽsẽmánĩ rî ꞌálâ. Gólĩyî câ bê tólâ rî, Yésũ drí ngãzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ rî nõngá. Mâ drẽ nĩꞌá gbíyá ạ̃tı̣́ ꞌálâ rãtáã ꞌẽlé.” ");
INSERT INTO avu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Gõꞌdá Yésũ drí Pétẽrõ yî, Zẽbẽdáyõ rî mvá rı̣̃ Yãkóbã yî Yõwánĩ bê rî ꞌbá yî drı̣̃zó kpãâ yí bê. Gõꞌdá Yésũ drí âꞌdózó ĩzã ró gõꞌdá kpá tã ı̣̂sũ ró rõô. ");
INSERT INTO avu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Gõꞌdá gólâ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ámâ pı̣̃pı̣̂sı̣́lı̣́ trá tã ı̣̂sũ ró rõô. Tã ı̣̂sũ ꞌdî ꞌê trá ámâ fũlı̣́. Nĩ rî nõngá lı̣̃fı̣́ ngbậ ró tãlâ rãtáã ꞌẽlé má bê.” ");
INSERT INTO avu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nĩngá sĩ, Yésũ drí ngãzó nĩlí gbíyá ạ̃tı̣́ ꞌálâ, gõꞌdá drílâ íyî lâlãzó vũdrı̣́ ı̣̃nyạ́kú drı̣̃ı̣̂ rãtáã ꞌẽlé kĩ, “Tátá, õzõ ĩîcâ trá ní lı̣̃fı̣́ rî, ní trõ ĩgã mvá lâŋõ gólâ ꞌẽ ꞌbá ámâ ꞌẽlé rî kâ nõ vólé. Gõꞌdá ní ꞌê tã gólâ ní drí lẽlé ꞌẽlé rî ĩꞌdî, âꞌdó kô tã gólâ má drí lẽlé rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gõꞌdá Yésũ drí ngãzó gõlé lãjóꞌbá íyíkâ nâ ꞌdĩ ꞌbá yî ngálâ. Gólâ drí gólĩyî ûsúzó rĩꞌá ĩyî ậꞌdú kõꞌá. Gõꞌdá gólâ drí ngãzó tã âtálé Pétẽrõ yî drí kĩ, “Nĩ îcá kô rĩlí lı̣̃fı̣́ ngbậ ró rãtáã ꞌẽlé má bê cãlé cé ı̣̃tú-pá ãlô ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nĩ rî lı̣̃fı̣́ ngbậ ró rãtáã ꞌẽlé, tãlâ Sãtánã õzó ãnî ûjũû kô ámâ âyélé. Ãnî pı̣̃pı̣̂sı̣́lı̣́ lẽ tã tãndí ꞌẽlé, gõꞌdá ãnî rúꞌbạ́ rĩꞌá cú ĩtí mbârâkã ãkó tã rî ꞌdĩ ꞌẽzó.” ");
INSERT INTO avu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gõꞌdá Yésũ drí gõzó kpá óꞌdí nĩꞌá rãtáã ꞌẽlé. Gólâ kĩ, “Tátá, õzõ ĩîcâ kô ní drí ĩgã mvá lâŋõ kâ nõ trõlé vólé má drí mvũ ãkó lâ rî, má âꞌdô ꞌẽꞌá lâ õzõ ní drí lẽlé rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nĩngá sĩ, Yésũ drí ngãzó gõlé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî ngálâ. Gõꞌdá gólâ drí kpá gólĩyî ûsúzó rĩꞌá lûsúꞌá ậꞌdú drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gõꞌdá drílâ ngãzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî âyélé, nĩzó rãtáã ândâlâ nâ lâ ꞌẽlé. Gõꞌdá drílâ kpá rãtáã ãlô-ãlô ꞌdĩ ꞌẽzó ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gõꞌdá Yésũ drí gõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî ngálâ. Gólâ ûsû gólĩyî rĩꞌá ậꞌdú kõꞌá. Gõꞌdá gólâ drí tã âtázó drílĩyî kĩ, “Ãnî drẽ zãâ rĩꞌá ậꞌdú kõꞌá yã? Nĩ ndrê drẽ, ı̣̃tú-pá âcâ trá ngbãângbânõ ꞌẽzó mâ gólâ âjólé ûrú lésĩ nô drı̣́-bã lâ fẽlé tã õnjí ꞌbá yî drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nĩ ngâ ûrû, mã nĩ ró bê! Nĩ ndrê õjílã gólâ ꞌẽ ꞌbá ámâ drı̣́-bã fẽlé rî rĩꞌá ânĩꞌá nã!” ");
INSERT INTO avu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Gõꞌdá nĩngá sĩ, Yésũ õtírĩ rĩî drẽ zãâ tã âtáꞌá lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí rî, kôrô lãjóꞌbá gólâkâ ãlô Yúdạ̃ rî drí âcázó õjílã õꞌbí bê dũû. Õjílã rî ꞌdĩ ꞌbá yî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yí bê rî âjô gólĩyî nĩ lı̣́gú mbẽlẽsó-mbélésô bê gõꞌdá kpá pı̣̃drı̣́gú ạ́ngı̣́ ạ́ngı̣́ yí bê ĩyî drı̣́gạ́ sĩ, ânĩꞌá Yésũ rî rũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yúdạ̃ âꞌdâ lạ́tı̣̂ yí drí ꞌẽzó Yésũ rî drı̣́-bã fẽlé rî trá ạ̃kû ró õjílã ꞌdî ꞌbá yî drí. Gólâ kĩ, “Õjílã gólâ má drí ꞌẽꞌá nĩꞌá âmvólâ bı̣́-ꞌbálé lâ võlé rî, nĩ rû gólâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gõꞌdá gólĩyî ânĩ bê âcálé rî, Yúdạ̃ drí nĩzó mbı̣̂ Yésũ ngálâ, nĩꞌá nî-bê-yã fẽlé Yésũ drí, gólâ kĩ, “Tã îmbá ꞌbá, nî bê yã?” Gólâ drí Yésũ rî âmvózó bı̣́-ꞌbálé lâ võlé. ");
INSERT INTO avu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Gõꞌdá Yúdạ̃ ꞌê nî-bê-yã bê Yésũ drí rî, Yésũ drí tã âtázó gólâ drí kĩ nĩ rî, “Ámâ rû-lẽ-ãzíyã, ní ꞌê tã ní drí ânĩꞌá ꞌẽlâ rî.” Gõꞌdá kôrô õjílã ꞌdî ꞌbá yî drí ngãzó ndrõlé ạ̃ngbũ Yésũ drı̣̃ı̣̂. Gõꞌdá drílĩyî Yésũ rî rũzó. ");
INSERT INTO avu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gõꞌdá lãjóꞌbá ãlô lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî lãfálé ꞌásĩ drí lı̣́gú mbẽlẽsõ íyíkâ ângízó fókã lâ ꞌásĩ. Gõꞌdá kôrô drílâ rû ı̣̂ꞌbũ ꞌbá drı̣́-ꞌbá drı̣́-ꞌbá Yúdạ̃ yí kâ rî ꞌbá yî rî kâ rî kâ bı̣́ lâ gãzó njíyá vólé vũdrı̣́. ");
INSERT INTO avu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá gólâ rû ı̣̂ꞌbũ ꞌbá ꞌdĩ bı̣́ lâ gã ꞌbá ꞌdĩ drí kĩ nĩ rî, “Ní sõ lı̣́gú áníkâ ꞌdĩ lôgõlé vólé fókã lâ ꞌá. Õjílã gólĩyî rĩ ꞌbá ạ̃wạ̃ ꞌẽlé lı̣́gú mbẽlẽsó-mbélésô rî ꞌbá yî sĩ rî, áâꞌdô kpá gólĩyî fũꞌá lı̣́gú mbẽlẽsó-mbélésô sĩ. ");
INSERT INTO avu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mí nı̣̃ı̣́ kô kĩ nĩ rî, má âꞌdô îcáꞌá ámâ átá Ôvârí rî zı̣̃lı̣́ mãlãyíkã âjólé ânĩꞌá ámâ pãlé yã? Gólâ âꞌdô îcáꞌá mãlãyíkã âjólé dũûdû. ");
INSERT INTO avu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gõꞌdá õzõ Ôvârí ãâjô mãlãyíkã trá ânĩꞌá ámâ pãlé rî, tã gólâ îgĩlí búkũ Ôvârí kâ ꞌá ꞌẽ ꞌbá rû ꞌẽlé ámâ tãsĩ rî âꞌdô rû ꞌẽꞌá ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Gõꞌdá Yésũ drí ngãzó tã âtálé õjílã õꞌbí ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ânĩ ámâ rũlı̣́ lı̣́gú mbẽlẽsó-mbélésô bê gõꞌdá kpá pı̣̃drı̣́gú ạ́ngı̣́ ạ́ngı̣́ yí bê õzõ õjílã gólâ tã õnjí ꞌẽ ꞌbá mı̣́rı̣̃ rú rî kâtí ãꞌdô tãsĩ yã? Má rî trá tã îmbálé kậyı̣̂ vósĩ cé ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌá. Nĩ rú mâ kô tólâ ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tã gólĩyî ndrĩ ãnî drí rĩꞌá ꞌẽlâ ꞌdĩ ꞌbá yî, ꞌê rû ĩtí ꞌdĩ, tãlâ úlı̣́ gólĩyî tã ậngũ ꞌbá yî drí îgĩlí búkũ Ôvârí kâ ꞌá rî ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró.” Nĩngá sĩ rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí lârázó ndrĩ Yésũ rú sĩ, gólâ rî âyélé élê. ");
INSERT INTO avu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Gõꞌdá nĩngá sĩ rî, õjílã gólĩyî Yésũ rî rũ ꞌbá rî yî drí gólâ rî trõzó âjílí ãmbá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yí kâ rú bê Kãyífã rî drí jó ꞌálâ. Tólâ lãꞌbí îmbá ꞌbá yî gõꞌdá õjílã gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yí bê êꞌbê ĩyî rû trá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ãzâ ꞌbá yí bê, tãlâ ĩyî drí tã-vó Yésũ kâ kĩzó bê. ");
INSERT INTO avu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Gõꞌdá Pétẽrõ drí ngãzó ꞌdẽlé nĩlí Yésũ yî vósĩ jẽjẽ ró vólé lésĩ. Drílâ ânĩzó âcálé ạ̃ꞌdı̣́-drı̣̃ drı̣̃-ꞌbá ạ́ngı̣́ Kãyífã kâ rî ꞌá. Gólâ câ bê tólâ rî, drílâ fĩzó nĩꞌá rĩlí võ ãlô ꞌá lómígówá gólĩyî rĩ ꞌbá ạ̃ꞌdı̣́-drı̣̃ ꞌdî vó lâ ndrẽlé rî ꞌbá yí bê, tãlâ yí ndrê ró tã gólâ ꞌẽ ꞌbá rû ꞌẽlé Yésũ drí rî bê. ");
INSERT INTO avu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Gõꞌdá jó Yésũ rî lôfízó ꞌálâ ꞌdĩ ꞌá tólâ rî, tã kĩ ꞌbá ꞌdĩ ꞌbá yî ndrĩ õjílã gólĩyî rû êꞌbé ꞌbá tólâ nã ꞌbá yí bê, drílĩyî rĩzó õjílã gólĩyî ꞌẽ ꞌbá tã âꞌbãlé Yésũ rú õnjõ sĩ rî lôndãlé, tãlâ ĩyî drí gólâ rî fũzó bê. ");
INSERT INTO avu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Gbõ lé õjílã dũû âfõ ĩyî bê tã âtálé Yésũ rú õnjõ sĩ rî, úûsú tã õnjí Yésũ drí ꞌẽlé rî kô. Ạ̃dũkũ lâ ró rî, ãgô ãzâ ꞌbá yî rı̣̃ drí ngãzó âfõlé âdrélé tã kĩ ꞌbá ꞌdĩ ꞌbá yî ândrá tã âꞌbãlé Yésũ rú õnjõ sĩ kĩ, ");
INSERT INTO avu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ãgô nõ kĩ nĩ rî, yí âꞌdô îcáꞌá jó ạ́ngı̣́ Ôvârí kâ ûfúlı̣́, gõꞌdá yí drí bẽzó lâ óꞌdí võ lâ ꞌá kậyı̣̂ nâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gõꞌdá ãmbá drı̣̃-ꞌbá ạ́ngı̣́ ꞌdĩ ꞌbá yí kâ ꞌdĩ ârî úlı̣́ ãgô ꞌdĩ ꞌbá yî drí âtálé ꞌdĩ bê rî, drílâ ngãzó ûrû tã âtálé Yésũ drí kĩ nĩ rî, “Ní ârî úlı̣́ ãgô ꞌdĩ ꞌbá yî drí âtálé ní rú ꞌdĩ trá yã? Nî cú tã ãzâ bê lôgõlé tã gólĩyî drí âtálé ní rú ꞌdĩ vó lâ ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Gõꞌdá Yésũ drí rĩzó tı̣́tı̣́ úlı̣́ âtá ãkó. Nĩngá sĩ, ãmbá ꞌdĩ drí tã âtázó Yésũ drí kĩ nĩ rî, “Má ꞌbã ní drí lãtrítrí îtrílí Ôvârí gólâ rĩ ꞌbá lédrẽ-lédrẽ ró rî rú lâ sĩ, ní âꞌdâ ãmâ drí õzõ ní ãꞌdô pạ̃tı̣́ı̣̃ ꞌdíyî pã ꞌbá, Ôvârí rî mvá ĩꞌdî rî.” ");
INSERT INTO avu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó kĩ nĩ rî, “Rĩꞌá õzõ ní drí âtálé ꞌdĩ kâtí. Gõꞌdá má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, ı̣̃zạ́tú rî, nĩ âꞌdô mâ gólâ âjólé ûrú lésĩ nô ndrẽꞌá rĩrĩ ꞌá Ôvârí mbârâkã ãkĩ rî drı̣́-ágó drı̣̃ lésĩ ró. Nĩ âꞌdô ámâ ndrẽꞌá âgõrẽ ꞌá mbârâkã bê ꞌbũû lésĩ mbãrãsãsã bê.” ");
INSERT INTO avu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gõꞌdá ãmbá ꞌdĩ ârî úlı̣́ Yésũ drí âtálé ꞌdĩ bê rî, gólâ drí âꞌdózó õmbã ró, gõꞌdá drílâ ítá íyíkâ sĩzó õmbã sĩ. Gõꞌdá drílâ tã âtázó tã kĩ ꞌbá ꞌdĩ ꞌbá yî drí kĩ, “Ãnî ndrĩ, nĩ ârî úlı̣́ gólâ drí âtálé Ôvârí rî ꞌdãzó ꞌdĩ trá. Gólâ âmã tã trá kĩ nĩ rî, yí ãꞌdô ꞌdíyî pã ꞌbá Ôvârí rî mvá ĩꞌdî. Mã lẽé gõꞌdá õjílã ãzãkã kô ânĩꞌá tã âtálé gólâ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Gõꞌdá tã ı̣̂sũ-ı̣̂sũ ãníkâ ángô tí tã ãgô ꞌdĩ kâ tãsĩ yã?” Gõꞌdá drílĩyî ngãzó tã kĩlí Yésũ rú kĩ nĩ rî, “Gólâ âtâ úlı̣́ õnjí trá Ôvârí rú. Úfû gólâ vólé.” ");
INSERT INTO avu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nĩngá sĩ, drílĩyî Yésũ rî lı̣̃fı̣́ âmbézó kpạ̃ạ́kũ ítá sĩ. Gõꞌdá lómígówá ãzâ ꞌbá yî drí tũ lûwúzó gólâ rî lı̣̃fı̣́ ꞌá. Gõꞌdá ãzâ ꞌbá yî drí gólâ rî sı̣̃zó drı̣́ sĩ. Gõꞌdá ãzâ ꞌbá yî drí ĩyíkâ gólâ rî lı̣̃fı̣́ sãzó. ");
INSERT INTO avu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Gõꞌdá drílĩyî rĩzó ꞌdásí ꞌẽlé Yésũ rú tã îjî sĩ kĩ, “ꞌDíyî pã ꞌbá, ní âꞌdâ drẽ õjílã ánî sı̣̃ ꞌbá ꞌdĩ ãmâ drí.” ");
INSERT INTO avu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Gõꞌdá Yésũ õtírĩ ꞌbãâ drẽ âdréꞌá lãkíkã ꞌá tã kĩ ꞌbá ꞌdĩ ꞌbá yî ândrá gõꞌdá Pétẽrõ drẽ kpá zãâ ạ̃ꞌdı̣́-drı̣̃ ꞌdî ꞌá rî, ízámvá ãzâ rû ı̣̂ꞌbũ ꞌbá ró rî drí Pétẽrõ rî ndrẽzó. Drílâ ânĩzó tã âtálé Pétẽrõ drí kĩ, “Ákĩ, nî fí ĩꞌdî gólâ rĩ ꞌbá lậmúlı̣́ Yésũ gólâ Gãlĩláyã lé ꞌbá ró rî bê rî!” ");
INSERT INTO avu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gõꞌdá Pétẽrõ ârî tã ízámvá ꞌdĩ drí âtálé gólâ drí ꞌdĩ bê rî, drílâ tı̣̂ gãzó õjílã gólĩyî drí rĩzó gólĩyí bê ꞌdĩ ândrá kĩ nĩ rî, “Má nı̣̃ı̣́ tã áníkâ rĩꞌá âtálé ꞌdĩ kô!” ");
INSERT INTO avu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Gõꞌdá Pétẽrõ ní drí ngãzó nĩlí võ ꞌdî ꞌásĩ gõlé ạ́tı̣̃ ndõgõ ꞌdî kâ rî tı̣́ ꞌálâ. Ạ́tı̣̃ tı̣́ tólâ rî, õjílã ãzâ ꞌbá yî kpá bê rĩꞌá ĩyî âdréꞌá nĩngá. Gõꞌdá ízámvá ãzâ rû ı̣̂ꞌbũ ꞌbá ró rî drí kpá Pétẽrõ rî ndrẽzó. Ízámvá ꞌdĩ drí gólâ rî âꞌdázó õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, “Ãgô nõ õjílã ãlô gólâ rĩ ꞌbá lậmúlı̣́ Yésũ gólâ Nãzãrétã lé ꞌbá ró rî yí bê rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Gõꞌdá Pétẽrõ ní ârî úlı̣́ ꞌdĩ bê rî, ní drí tı̣̂ gãzó ândálé kpá óꞌdí. Gõꞌdá ní drí lãtrítrí îtrízó gõꞌdá tã âtázó kĩ nĩ rî, “Má nı̣̃ı̣́ ãgô ꞌdĩ kó kô!” ");
INSERT INTO avu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gõꞌdá ı̣̃tú-pá dã vósĩ rî, õjílã ãzâ ꞌbá yî gólĩyî rĩ ꞌbá âdrélé tólâ nã ꞌbá yî drí ânĩzó ĩyî tã âtálé Pétẽrõ drí kĩ, “Pạ̃tı̣́ı̣̃, nî õjílã ãlô gólâ rĩ ꞌbá lậmúlı̣́ Yésũ yí bê rî ĩꞌdî! Mã nı̣̃ nî úlı̣́ âtâ-âtâ áníkâ ꞌásĩ, ní rî úlı̣́ âtálé nyé õzõ Gãlĩláyã lé ꞌbá kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Gõꞌdá Pétẽrõ ní drí lãtrítrí îtrízó kĩ nĩ rî, “Õzõ má ãꞌdô fí ãlô õjílã Yésũ kâ ꞌásĩ rî ĩꞌdî rî, ngá ãzâ õꞌê mâ! Má nı̣̃ı̣́ ãgô ꞌdĩ kô!” Úlı̣́ Pétẽrõ kâ ꞌdĩ vósĩ rî, kôrô ꞌạ̃ꞌú-lúgú drí cı̣́rı̣̃ ꞌbẽzó. ");
INSERT INTO avu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gõꞌdá Pétẽrõ ârî ꞌạ̃ꞌú-lúgú ꞌdĩ cı̣́rı̣̃ lâ bê rî, kôrô úlı̣́ Yésũ drí âtálé gólâ drí kĩꞌá nĩ rî, “Drẽ ãkpãkãꞌdã ꞌạ̃ꞌú-lúgú ꞌbé cı̣́rı̣̃ kô rî, ní âꞌdô tı̣̂ gãꞌá má rú sĩ ândâlâ nâ” rî drí âgázó gólâ drı̣̃ı̣̂. Gõꞌdá úlı̣́ Yésũ kâ ꞌdĩ ꞌbá yî âgâ bê Pétẽrõ drı̣̃ı̣̂ rî, drílâ ngãzó fõlé ĩví ꞌálâ ạ̃ꞌdı̣́-drı̣̃ ꞌdî ꞌásĩ, gõꞌdá drílâ ngãzó rĩꞌá ãwó ngõlé ngbạ́lạ́-ngbạ́lạ́ ı̣̃lı̣́ndrı̣̂ bê tã õnjí íyíkâ ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gõꞌdá nĩngá sĩ, cı̣̃ı̣́nó rî sĩ, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ndrĩ gõꞌdá gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yí bê drí rû êꞌbézó võ ãlô ꞌá tã ı̣̂ꞌbı̣̃lı̣́, ãꞌdô ró bê ĩyî drí Yésũ rî fũzó. ");
INSERT INTO avu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gõꞌdá gólĩyî drí Yésũ rî âmbézó drı̣̃lı̣́ âjílí Pĩlátõ gólâ mı̣́rı̣̃ Rómã kâ drí ꞌbãlé kúmú ró ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ drı̣̃lı̣́ rî ândrá, tãlâ Pĩlátõ õkî ró tã gólâkâ bê. ");
INSERT INTO avu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gõꞌdá Yúdạ̃ gólâ Yésũ rî drı̣́-bã fẽ ꞌbá rî ârî tã bê kĩꞌá nĩ rî, óõkî tã trá ꞌẽzó Yésũ rî fũlı̣́ rî, gólâ drí âꞌdózó tã ı̣̂sũ ró tã õnjí gólâ drí ꞌẽlé ꞌdĩ tãsĩ. Gõꞌdá drílâ ngãzó ậdı̣̂ ífí sílĩvã ꞌásĩ fẽlé gólâ drí nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́ ꞌdĩ trõlé nĩꞌá lôgõlâ vólé drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî drí gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yí bê ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Gõꞌdá Yúdạ̃ drí ngãzó tã âtálé gólĩyî drí kĩ, “Má ꞌê tã õnjí trá, má drí ãgô tã õnjí ꞌẽ ꞌbá kô nõ drı̣́-bã lâ fẽzó ãnî drí õnjõ sĩ fũlı̣́.” Gõꞌdá drı̣̃-ꞌbá ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó Yúdạ̃ drí kĩ, “ꞌDĩî rĩꞌá tã áníkâ ĩꞌdî, gõꞌdá âꞌdó kô tã ãmákâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yúdạ̃ ârî úlı̣́ drı̣̃-ꞌbá ꞌdĩ ꞌbá yí kâ ꞌdĩ bê rî, drílâ ậdı̣̂ ꞌdĩ trõzó vũlı̣́ vũdrı̣́ ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ kâ ꞌá. Gõꞌdá gólâ drí ngãzó nĩlí vólé íyî ômbê ꞌĩlí, gõꞌdá drãzó. ");
INSERT INTO avu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí ngãzó ậdı̣̂ ꞌdĩ trõlé. Gõꞌdá drílĩyî tã âtázó kĩ, “Tã ꞌbãꞌbã ãmákâ vó ró rî, âꞌdó kô mbı̣̂ ãmâ drí ậdı̣̂ nõ ꞌbãzó võ gólâ rĩzó ậdı̣̂ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌbãlé ꞌá lâ rî ꞌá, tãlâ ꞌdĩî rĩꞌá ậdı̣̂ õjílã ãrí kâ ꞌî, ófẽ Yésũ rî fũzó.” ");
INSERT INTO avu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Gõꞌdá drı̣̃-ꞌbá ꞌdĩ ꞌbá yî drí tã ı̣̂ꞌbı̣̃zó tã gólĩyî drí ꞌẽꞌá ꞌẽlâ ậdı̣̂ ꞌdĩ sĩ rî tãsĩ. Drílĩyî tã-drı̣̃ lẽzó võ gĩzó ậdı̣̂ rî ꞌdĩ sĩ. Gõꞌdá drílĩyî võ rî ꞌdĩ gĩzó límvó rũ ꞌbá ãzâ drı̣́gạ́ sĩ, ãꞌdô ró bê võ lóꞌdé kâ ró rĩzó õjílã lídí ró rî ꞌbá yî ãvõ lâ yî lôꞌbãlé ꞌá lâ. ");
INSERT INTO avu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tã ꞌdî tãsĩ rî, gõzó võ ꞌdî rú lâ zı̣̃lı̣́ “‘Võ Ãrí kâ”’ âcálé bũúũ ãndrõ nô. ");
INSERT INTO avu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tã ꞌdî ꞌê rû trá ĩtí ꞌdĩ, tãlâ úlı̣́ gólâ tã ậngũ ꞌbá Yẽrẽmíyã drí âtálé trá ạ̃kû ró nã rî ãꞌdô ró bê tã pạ̃tı̣́ı̣̃ ró. Gólâ kĩ, “Gólĩyî drí ậdı̣̂ ífí sílĩvã ꞌásĩ rî trõzó nyâꞌdî-trá-drı̣̃-lâ-mûdrı̣́. ꞌDĩî rĩꞌá ậdı̣̂ õjílã Ĩsĩrãꞌélẽ kâ drí tã-drı̣̃ lẽzó trõlé fẽlé õjílã drı̣́-bã fẽzó fũlı̣́ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Gõꞌdá gólĩyî drí ậdı̣̂ ꞌdĩ trõzó võ gĩzó ĩꞌdî sĩ lâ límvó rũ ꞌbá drı̣́gạ́ sĩ. Tã ꞌdî ꞌê rû trá õzõ Ôvârí drí tã lâ ꞌbãlé trá má drí rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gõꞌdá Yésũ õtírĩ rĩî âdrélé kúmú ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ drı̣̃lı̣́ Pĩlátõ ândrá rî, Pĩlátõ drí Yésũ rî îjízó kĩ, “Nî ĩꞌdî kúmú ạ́ngı̣́ gólâ rĩ ꞌbá rĩlí õjílã Yúdạ̃ yí kâ drı̣̃lı̣́ rî ĩꞌdî yã?” Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó kĩ, “Rĩꞌá õzõ ní drí âtálé nĩ ꞌdî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nĩngá sĩ, drı̣̃-ꞌbá Yúdạ̃ yí kâ ndrĩ ꞌdî ꞌbá yî drí rĩzó ĩyî ícícíyá ꞌẽlé Yésũ rú. Gõꞌdá gólĩyî rî bê ícícíyá ꞌẽlé Yésũ rú rî, gólâ drí rĩzó tı̣́tı̣́ ró tã ãzãkã âtá ãkó. ");
INSERT INTO avu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gõꞌdá Pĩlátõ drí ngãzó tã âtálé Yésũ drí kĩ, “Tã ãmbá rĩꞌá âtálé ní rú ꞌdĩ ꞌbá yî, ní ârí kô yã?” ");
INSERT INTO avu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Gõꞌdá Yésũ drí rĩzó tı̣́tı̣́ ró tã-drı̣̃ lôgõ ãkó Pĩlátõ drí. Tã ꞌdî tãsĩ rî, Pĩlátõ rî tı̣̂ drí ậꞌdı̣́zó ndrúndrú. ");
INSERT INTO avu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Rĩꞌá ndrô vósĩ cé, kậyı̣̂ kãrámã lậvũ-lậvũ kôrô kâ rî sĩ, kúmú Rómã kâ âꞌdó ꞌbá ndrô rî ꞌdĩ sĩ ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ drı̣̃lı̣́ rî drí õjílã ꞌbãlé gạ̃nı̣́mạ̃ ꞌá rî ãlô rî ꞌbá yî ãlô lâ yî lôfõzó vólé gạ̃nı̣́mạ̃ ꞌásĩ drı̣̃-bạ́lạ́yı̣̂ ró. ꞌDĩî rî rĩꞌá õjílã gólâ õꞌbí Yúdạ̃ yí kâ drí njĩlí lôfõlé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kậyı̣̂ ꞌdĩ ꞌbá yî sĩ rî, gạ̃nı̣́mạ̃ lé ꞌbá ãzâ rú bê Bãrábã tíbê rú lâ drí lậꞌbúlı̣́ õjílã drí tã õnjí ꞌẽꞌẽ gólâkâ drí sĩ rî bê rĩꞌá gạ̃nı̣́mạ̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gõꞌdá õjílã õꞌbí êꞌbê ĩyî rû bê âcálé dũû Pĩlátõ ândrá rî, Pĩlátõ drí õꞌbí ꞌdĩ ꞌbá yî îjízó kĩ, “Nĩ lẽ má drí õjílã ángô rî înjílí ĩꞌdî ãnî drí gạ̃nı̣́mạ̃ ꞌásĩ kậyı̣̂ ãmbá nõ tú yã? Má ĩînjî Bãrábã ĩꞌdî ngãtá Yésũ gólâ zı̣̃lı̣́ ꞌdíyî pã ꞌbá ró rî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pĩlátõ îjî tã ꞌdî ĩtí ꞌdĩ, tãlâ gólâ nı̣̃ trá dódó kĩ nĩ rî, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ꞌálé lâ yî âdrã trá Yésũ rú drı̣́-ãcê gólâkâ tãsĩ. Ĩꞌdî gólĩyî drí Yésũ rî trõzó âjílí gólâ ândrá. ");
INSERT INTO avu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nĩngá sĩ, kúmú Pĩlátõ drẽ zãâ rĩꞌá kı̣́tı̣̃ íyíkâ tã kĩ kâ ꞌdĩ drı̣̃ı̣̂ rî, õkó lâ drí tã âtízó ânĩꞌá âtálâ drílâ kĩ, “Ní ꞌê tã õnjí ãzãkã kô ãlôwálâ ãgô tã õnjí ꞌẽ ꞌbá kô ꞌdĩ drí, tãlâ má âbĩ trá õnjí ró tã gólâkâ tãsĩ ngạ́cı̣̂ ậgı̣́ rî kâ sĩ. Gõꞌdá âbĩ-âbĩ rî ꞌdĩ îkpókpólõ mâ trá rõô.” ");
INSERT INTO avu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nĩngá sĩ rî, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí rĩzó tã sõlé õjílã õꞌbí ꞌdĩ ꞌbá yî ꞌá kĩ nĩ rî, “Nĩ âtâ tã Pĩlátõ drí kĩ, ‘Mã lẽ ólôfõ Bãrábã ĩꞌdî ãmâ drí, gõꞌdá úfû Yésũ ĩꞌdî vólé.’ ” ");
INSERT INTO avu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gõꞌdá Pĩlátõ drí tã îjízó kpá óꞌdí õꞌbí ꞌdĩ ꞌbá yî tı̣́ kĩ nĩ rî, “Õjílã rı̣̃ nô ꞌbá yî lãfálé sĩ rî, nĩ lẽ má ĩînjî õjílã ángô rî ĩꞌdî ãnî drí yã?” Drílĩyî tã-drı̣̃ lôgõzó kĩ, “Ní înjî Bãrábã ĩꞌdî!” ");
INSERT INTO avu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Gõꞌdá Pĩlátõ drí tã âtázó gólĩyî drí kĩ, “Õzõ má ĩînjî Bãrábã trá rî, má õꞌê ãꞌdô ĩꞌdî Yésũ gólâ zı̣̃lı̣́ ꞌdíyî pã ꞌbá ró rî drí yã?” Drílĩyî tã-drı̣̃ lôgõzó ôtrê-ôtrê sĩ kĩ nĩ rî, “Íĩîpâ gólâ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ drãlé vólé!” ");
INSERT INTO avu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gõꞌdá Pĩlátõ drí tã îjízó õjílã õꞌbí ꞌdĩ ꞌbá yî tı̣́ kĩ, “Nĩ lẽ má drí ãgô nõ fũlı̣́ ãꞌdô tãsĩ yã? Tã gólâ drí ꞌẽlé õnjí rî ãꞌdô ꞌî yã?” Õjílã ꞌdî ꞌbá yî ârî ĩyî tã Pĩlátõ drí îjílí ꞌdĩ bê rî, drílĩyî ngãzó trẽlé tã bê ngbạ́lạ́-ngbạ́lạ́ kĩ nĩ rî, “Íîpâ gólâ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ õdrã ró vólé!” ");
INSERT INTO avu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gõꞌdá Pĩlátõ cê rû bê trá kpı̣̃ı̣̂ tã ı̣̂sũ õjílã ꞌdî ꞌbá yí kâ jãlé rî, gólâ îcá kô tã rî ꞌdĩ ꞌẽlé. Tãlâ õzõ gólâ õrî zãâ tã îjílí Yésũ rî tãsĩ rî, õjílã ꞌdî ꞌbá yî âꞌdô ĩyî ngãꞌá ạ̃wạ̃ ró rõô gólâ bê. Gõꞌdá Pĩlátõ ndrê tã ꞌdî bê ĩtí rî, drílâ ngãzó lı̣̃mvû âtrõlé íyî drı̣́ jĩzó õꞌbí ꞌdĩ ꞌbá yî ândrá tã âꞌdâ ró. Gõꞌdá drílâ ngãzó tã âtálé kĩ, “Mâ tã ãzãkã ãkó õdrã ãgô nõ kâ tãsĩ. ꞌDĩî rĩꞌá tã ãníkâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Gõꞌdá õꞌbí ꞌdĩ ꞌbá yî ndrĩ drí ngãzó tã âtálé Pĩlátõ drí kĩ, “Õdrã ãgô ꞌdĩ kâ, lâŋõ lâ õgõ ãmâ drı̣̃ı̣̂ ãmâ mvá yí bê.” ");
INSERT INTO avu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nĩngá sĩ, Pĩlátõ drí Bãrábã rî înjízó gạ̃nı̣́mạ̃ ꞌásĩ fẽlé õꞌbí ꞌdĩ ꞌbá yî drí. Gõꞌdá drílâ tã ꞌbãzó Yésũ rî cãzó ônjóróꞌbí sĩ, gõꞌdá Yésũ rî fẽzó, nĩꞌá îpálâ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ drãlé. ");
INSERT INTO avu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gõꞌdá nĩngá sĩ rî, ạ̃jú ꞌbũ ꞌbá kúmú Pĩlátõ kâ rî ꞌbá yî drí Yésũ rî trõzó, nĩꞌá âjílâ võ ĩyíkâ rĩzó rî ꞌá ꞌbã ạ́ngı̣́ Pĩlátõ kâ rî ꞌálâ. Gõꞌdá tólâ rî, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí ĩyî ãzí-ãzí yî ậzı̣́zó ndrĩ ânĩꞌá rû êꞌbélé dîrî Yésũ rú sĩ. ");
INSERT INTO avu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gõꞌdá drílĩyî ítá Yésũ drí sõlé rî ângízó vólé gólâ rú sĩ. Gõꞌdá drílĩyî ítá bı̣́ ạ̃kû kãâkâ ró kũmũ kâ rĩꞌá âkólâ rî âtrõzó ĩꞌdî âkólé gólâ rú, ãꞌdô ró bê ꞌdásí ꞌẽzó gólâ rú. ");
INSERT INTO avu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Gõꞌdá drílĩyî púrũcı̣́ gárá êdézó ạ́pạ̃ ró âkólé ãtrã Yésũ drı̣̃ı̣̂. Drílĩyî pı̣̃drı̣́gú trõzó ꞌbãlé Yésũ rî drı̣́-ágó lésĩ rî ꞌá, ãꞌdô ró bê õzõ pı̣̃drı̣́gú kũmũ kâ rî kâtí. Gõꞌdá drílĩyî ậndı̣̃zó Yésũ ândrá, rĩꞌá ꞌdásí ꞌẽlé gólâ rú kĩ nĩ rî, “Kúmú ạ́ngı̣́ gólâ rĩ ꞌbá õjílã Yúdạ̃ yí kâ drı̣̃lı̣́ rî, mã lûyı̣̂ nî, ní rî zãâ gbạ́dú ró.” ");
INSERT INTO avu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nĩngá sĩ, gólĩyî drí rĩzó tũ lûwúlı̣́ Yésũ rî lı̣̃fı̣́ ꞌá. Gõꞌdá gólĩyî drí pı̣̃drı̣́gú drílĩyî fẽlé gólâ drí rî trõzó gólâ drı̣́gạ́ sĩ, rĩzó gólâ rî cãlé drı̣̃ ꞌá ĩꞌdî sĩ lâ ândálé ândálé. ");
INSERT INTO avu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Gõꞌdá gólĩyî lôꞌê ĩyî Yésũ rî lârâkô bê trá mãní mãní îcálé rî, drílĩyî gõzó ítá kúmú kâ gólĩyî drí âkólé gólâ rú rî ângízó vólé, gõꞌdá drílĩyî ítá gólâkâ rî sõzó ĩꞌdî lôgõlé gólâ rú. Gõꞌdá nĩngá sĩ, gólĩyî drí Yésũ rî ꞌbãzó fê lậlı̣̂-lậlı̣̂ ꞌẽzó gólâ rî îpálé drı̣̃ lâ ꞌá rî njı̣̃lı̣́, nĩzó võ ꞌẽzó nĩꞌá gólâ rî îpálé rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Gõꞌdá gólĩyî õtírĩ ꞌbãâ rĩꞌá nĩꞌá lạ́tı̣̂ ꞌásĩ rî, drílĩyî nĩzó rû ûsúlı̣́ ĩyî ãgô ãzâ rú bê Sĩmónã rî bê. Gólâ rî íyîngá ânĩlí jạ̃rı̣́bạ̃ gólâ zı̣̃lı̣́ Kĩrénẽ rî lésĩ. Gólĩyî ûsû rû bê lạ́tı̣̂ ꞌá rî, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí ãgô rî ꞌdĩ ꞌbãzó mbârâkã sĩ fê lậlı̣̂-lậlı̣̂ Yésũ kâ ꞌdĩ njı̣̃lı̣́ nĩzó ĩꞌdí bê lâ. ");
INSERT INTO avu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gõꞌdá drílĩyî nĩzó cãlé võ gólâ zı̣̃lı̣́ Gõlõgótã rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Võ rî ꞌdĩ ꞌá tólâ rî, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí õdrá gólâ ônjálé ãlókõ ãzâ gĩgĩ lâ ró rî sĩ rî âtrõzó fẽlé Yésũ drí mvũlı̣́, ãꞌdô ró ngá lâzê-lâzê gólâ rú ꞌdĩ sı̣́ lâ ậꞌdı̣́lı̣́. Gõꞌdá Yésũ âmbê õdrá ꞌdĩ bê rî, gólâ drí vólé gãzó dó mvũlâ. ");
INSERT INTO avu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","38","Nĩngá sĩ rî, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí Yésũ rî îpázó fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂. Gõꞌdá gólĩyî ndẽ Yésũ rî îpâ-îpâ bê rî, drílĩyî tã gólâ îgĩlí trạ̃kũ tã âꞌbã-âꞌbã ró Yésũ rú fê kpẽkẽrẽ drı̣̃ı̣̂ rî îpázó ûrû Yésũ drı̣̃lı̣́. Tã âꞌbã-âꞌbã îgĩlí ꞌdĩ rĩꞌá nõô. NÕÔ YÉSŨ GÓLÂ ÂꞌDÓ ꞌBÁ KÚMÚ Ạ́NGỊ́ RÓ ÕJÍLÃ YÚDẠ̃ YÍ KÂ DRỊ̃LỊ́ RÎ ĨꞌDÎ Gõꞌdá drílĩyî kpá ngá ôpá ꞌbá rı̣̃ ãzâ ꞌbá yî îpázó fê lậlı̣̂-lậlı̣̂ ãzâ drı̣̃ı̣̂ Yésũ rî gãrã drı̣̃ ꞌá, íîpâ ãlô rî gõlé Yésũ rî drı̣́-ágó drı̣̃ lésĩ ró, gõꞌdá ãzâ rî îpázó íyíkâ gõlé Yésũ rî drı̣́-lı̣̃jı̣́ drı̣̃ lésĩ ró. ꞌDĩî vósĩ rî, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí ítá Yésũ kâ lãfálé lâ cãzó ĩyî võ ꞌásĩ. Gõꞌdá drílĩyî gõmárĩ vũzó ĩꞌdî, tãlâ ngãtá ítá tãndí ãzâ Yésũ kâ rî âꞌdô ꞌdẽꞌá ãꞌdî drí yã rî. Nĩngá sĩ, drílĩyî ngãzó rĩlí vũdrı̣́ rĩꞌá Yésũ rî ndrẽlé ûrû fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ lómígówá ró. ");
INSERT INTO avu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nĩngá sĩ, õjílã gólĩyî rĩ ꞌbá lậvũlı̣́ lạ́tı̣̂ ꞌásĩ rî ꞌbá yî ndrê ĩyî Yésũ bê rî, drílĩyî rĩzó drı̣̃ îyálé gõꞌdá kpá Yésũ rî lôꞌdâ-lôꞌdâ bê kĩ, ");
INSERT INTO avu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ní âtâ tã nĩ kĩ nĩ rî, yí ãâꞌdô jó ạ́ngı̣́ Ôvârí kâ ûfúꞌá gõzó bẽlâ óꞌdí kậyı̣̂ nâ sĩ, õzõ ní ãꞌdô fí Ôvârí rî mvá ꞌî rî, ní pâ ánî nyãányâ, ní ârî vũdrı̣́ fê lậlı̣̂-lậlı̣̂ ꞌdĩ drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî, lãꞌbí îmbá ꞌbá yî, gõꞌdá gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yí bê drí rĩzó ĩyî kpá Yésũ rî gũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Drílĩyî tã âtázó kĩ, “Nî gólâ rĩ ꞌbá õjílã ãzí pãlé rî, ní pá ánî nyãányâ kô ãꞌdô tãsĩ yã? Õzõ ní ãꞌdô fí kúmú ạ́ngı̣́ gólâ rĩ ꞌbá ãmâ õjílã Ĩsĩrãꞌélẽ kâ drı̣̃lı̣́ rî ĩꞌdî rî, ꞌdõvó ní ârî vũdrı̣́ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ sĩ, tãlâ mã lẽ ró tã bê ní ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ní âtâ tã trá kĩ, yí ꞌbã lı̣̃fı̣́ trá Ôvârí drı̣̃ı̣̂, gõꞌdá kpá kĩ nĩ rî, yí âꞌdô Ôvârí rî mvá ꞌî. Gõꞌdá õzõ Ôvârí õlẽ trá ánî pãlé rî, gólâ õpâ nî ngbãângbânõ.” ");
INSERT INTO avu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Gõꞌdá ngá ôpá ꞌbá gólĩyî îpálé Yésũ bê fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ rî drí kpá Yésũ rî ꞌdãzó lãꞌdá ãlô-ãlô ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gõꞌdá nĩngá sĩ rî, ı̣̃tú õtírĩ cãâ ı̣̃tú-pá mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ı̣̃tú-ạ̃yı̣́ sĩ rî, ı̣́nı̣́rı̣́kúwạ́ drí ꞌbạ̃drı̣̃ ꞌdî lîmózó ndrĩ cãlé bũúũ ı̣̃tú-pá nâ lạ̃njạ́túlı̣́ sĩ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gõꞌdá câ bê ı̣̃tú-pá nâ lạ̃njạ́túlı̣́ kâ ꞌdĩ ꞌá rî, Yésũ drí ngãzó trẽlé ûrû ngbạ́lạ́-ngbạ́lạ́ Ãrãmáyã tı̣̂ sĩ kĩ nĩ rî, Ẽlóyĩ, Ẽlóyĩ, lámã sãbãkãtánĩ? Tã ífí lâ kĩ, “Ôvârí ámákâ, Ôvârí ámákâ, ní âyê mâ ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gõꞌdá õjílã ãzâ ꞌbá yî rĩ ꞌbá âdrélé tólâ nã ꞌbá yî ârî ĩyî trẽtrẽ Yésũ kâ ûrû ꞌdĩ bê rî, gólĩyî ı̣̂sũ ĩyíkâ tã kĩ nĩ rî, Yésũ õrî ꞌdĩ tã ậngũ ꞌbá Ẽlíyã rî zı̣̃ꞌá ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Gõꞌdá ãlô õjílã ꞌdî ꞌbá yî lãfálé ꞌásĩ rî drí rãzó ꞌwãâ, nĩꞌá ngá ãzâ cõfõ-cõfõ rî âtrõlé sõlé õdrá ạ̃ꞌdı̣́ ꞌá. Drílâ ngá rî ꞌdĩ ômbézó fê mvá sı̣́lı̣́, ânĩꞌá ꞌbãlâ Yésũ tı̣́ gólâ ũnjû ró lı̣̃mvû lâ ꞌdĩ bê. ");
INSERT INTO avu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Gõꞌdá õjílã ũrûkậ ꞌbá yî âtâ ĩyíkâ tã kĩ nĩ rî, “Óꞌbã drẽ õdrá ꞌdĩ Yésũ tı̣́ kô. Mã ndrê drẽ ngãtá tã ậngũ ꞌbá Ẽlíyã âꞌdô ânĩꞌá gólâ rî pãlé yã rî.” ");
INSERT INTO avu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Gõꞌdá Yésũ drí trẽzó kpá óꞌdí ûrû, gõꞌdá drílâ lôvó-lôvó âyézó. ");
INSERT INTO avu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ị̃tú-pá gólâ Yésũ drí lôvó-lôvó âyézó ꞌdĩ ꞌá rî, ítá gólâ ꞌĩlí jó ạ́ngı̣́ Ôvârí kâ ꞌá, jó mvá ãzâ zı̣̃lı̣́ “‘võ ngîngî lâ Ôvârí drí”’ ꞌálé lésĩ rî jó tı̣́lı̣́-tı̣̂ lâ ꞌá rî, ítá ꞌdĩ ꞌâ lâ drí sĩzó kpẽérẽ rı̣̃ ûrú lésĩ âcálé bũúũ vũdrı̣́. Gõꞌdá ı̣̃nyạ́kú drı̣̃ drí rû îyázó kı̣̃gbı̣̃-kı̣̃gbı̣̃, gõꞌdá kúnı̣́ drí ûfũzó lôꞌdélé ngĩíngî võ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gõꞌdá lóꞌdé drí rû njı̣̃zó hûwậ ı̣̃nyạ́kú drı̣̃ rû îyá ꞌbá ꞌdĩ drí sĩ, gõꞌdá tã mbı̣̂ ꞌbá dũû Ôvârí kâ ôdrã ꞌbá trá ạ̃kû ró rî ꞌbá yî drí lîdrízó ĩyî õdrã ꞌásĩ âꞌdólé lédrẽ-lédrẽ ró. ");
INSERT INTO avu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gõꞌdá drílĩyî âfõzó ĩyî lóꞌdé ꞌásĩ. Gõꞌdá Yésũ rî lîdrî-lîdrî õdrã ꞌásĩ rî vólé drı̣̃ lâ ꞌásĩ rî, drílĩyî nĩzó jạ̃rı̣́bạ̃ Ôvârí kâ Yẽrõsãlémã ꞌá rî ꞌálâ. Tólâ rî, õjílã dũû drí gólĩyî ndrẽzó. ");
INSERT INTO avu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gõꞌdá drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá Rómã kâ rî kâ gõꞌdá ạ̃jú ꞌbú ꞌbá gólâkâ gólĩyî rĩ ꞌbá ĩyî Yésũ rî lômílí rî ꞌbá yí bê ndrê ĩyî ạ̃gbı̣̃gbı̣̃ gólâ ı̣̃nyạ́kú drı̣̃ îyá ꞌbá ꞌdĩ bê gõꞌdá tã gólĩyî rû ꞌẽ ꞌbá ꞌdĩ ꞌbá yí bê rî, gólĩyî drí âꞌdózó ũrı̣̃ ró rõô. Gõꞌdá drílĩyî ngãzó tã âtálé kĩ, “Pạ̃tı̣́ı̣̃, nõô rĩꞌá Ôvârí rî mvá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Õkó dũû gólĩyî rĩ ꞌbá Yésũ rî pãlé rî ꞌbá yî, ânĩ ꞌbá ĩyî Yésũ yí bê Gãlĩláyã lésĩ rî yî drí âdrézó jẽjẽ ró, rĩꞌá ĩyî Yésũ rî ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gólĩyî lãfálé ꞌá rî, Mãríyã Mãgãdálã, gõꞌdá Mãríyã gólâ âꞌdó ꞌbá Yãkóbã yî Jósẽ bê ândrê ró rî, gõꞌdá kpá Zẽbẽdáyõ rî õkó gólâ âꞌdó ꞌbá Yãkóbã yî Yõwánĩ bê rî ândrê lâ ró rî bê, gólĩyî bê nĩngá. ");
INSERT INTO avu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Gõꞌdá câ bê lạ̃njạ́túlı̣́ bê rî, ãgô ãzâ ngá-tı̣̂ ãmbá ꞌbá ró gólâ âꞌdó ꞌbá Ãrãmãtáyã lé ꞌbá ró rú bê Yõsépã rî drí ngãzó nĩlí Pĩlátõ ngálâ, nĩꞌá Yésũ rî ãvõ tã îjílí, yí trõ ró bê nĩꞌá ꞌbãlâ. Yõsépã rî ꞌdĩ, gólâ rĩꞌá tã ârí ꞌbá Yésũ kâ ĩꞌdî. Gõꞌdá Pĩlátõ drí tã ꞌbãzó Yésũ rî ãvõ ꞌdî âyézó Yõsépã drí trõlé. ");
INSERT INTO avu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nĩngá sĩ, Yõsépã yî drí Yésũ rî ãvõ ꞌdî âtrõzó êdélé, gõꞌdá drílĩyî Yésũ rî ãvõ gõzó ítá óꞌdí ngbángbá ró rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","61","Gõꞌdá drílĩyî Yésũ rî ãvõ ꞌdî trõzó, nĩꞌá ꞌbãlâ ꞌbú Yõsépã drí êdélé óꞌdí ró ũgı̣́ ró íyî nyãányâ drí rî ꞌá. Mãríyã Mãgãdálã yî Mãríyã ãzâ rî bê tíbê rĩ ꞌbá âdrélé ĩyî Yésũ rî ndrẽlé fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ rî, gólĩyî drí nĩzó Yõsépã yî âjílí ꞌbú gólâ ꞌẽzó Yésũ rî ãvõ ꞌbãlé ꞌá lâ rî drı̣̃ ꞌálâ. Gõꞌdá Yõsépã yî ꞌbã Yésũ rî ãvõ bê rî, drílĩyî kúnı̣́ úngû ạ́ngı̣́ lîlízó, gõꞌdá drílĩyî ũgı̣́ ꞌdĩ tı̣̂ lâ âꞌbãzó kpạ̃ạ́kũ ĩꞌdî sĩ lâ. Gõꞌdá drílĩyî nĩzó vólé nĩngá sĩ. Gõꞌdá õkó ꞌdĩ ꞌbá yî drí rĩzó ĩyíkâ ãkpã lóꞌdé gãrã drı̣̃ ꞌá tólâ, rĩꞌá võ ndrẽlé lóꞌdé drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gõꞌdá drı̣̃zõ ãzâ rî sĩ, ꞌdĩî rĩꞌá kậyı̣̂ õjílã Yúdạ̃ yí kâ drí rĩzó rãtáã ꞌẽlé ꞌá lâ rî ĩꞌdî. Kậyı̣̂ rî ꞌdĩ ꞌá rî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá Pạ̃rúsı̣̃ yí bê drí ngãzó nĩlí Pĩlátõ ngálâ tã âtálé Yésũ rî ãvõ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gólĩyî kĩ, “Ãmbá, ní ndrê drẽ, õnjõ ꞌbá ꞌdĩ âtâ tã trá kĩ nĩ rî, õzõ yí õdrã trá rî, kậyı̣̂ nâ sĩ, yí âꞌdô lîdríꞌá õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tã ꞌdî tãsĩ rî, mã ânĩ nõ tã îjílí ní tı̣́, âꞌdô âꞌdóꞌá tãndí ró, õzõ ní õꞌbã ạ̃jú ꞌbũ ꞌbá ãzâ ꞌbá yî lóꞌdé drı̣̃ ꞌdî lômílí dódó cãlé bũúũ kậyı̣̂ nâ sĩ rî, tãlâ lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî õzó ânĩî ĩyî kô gólâ rî ãvõ ûgũlı̣́ gõzó tã âtálé kĩ nĩ rî, gólâ õlîdrî trá õdrã ꞌásĩ. Õnjõ ꞌdî âꞌdô õjílã âdóꞌá dũû lậvũlı̣́ gạ̃rạ̃ õnjõ Yésũ drí âdólé sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Gõꞌdá Pĩlátõ drí tã-drı̣̃ lẽzó drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí kĩ, “Tãndí ró, nĩ trõ ạ̃jú ꞌbũ ꞌbá ámákâ ãzâ ꞌbá yî ꞌbãlé, õndrê ró ĩyî lóꞌdé ꞌdĩ võ lâ bê dódó.” ");
INSERT INTO avu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Gõꞌdá drílĩyî nĩzó lóꞌdé ꞌdĩ tı̣̂ lâ bẽlé íꞌdá sĩ, gõꞌdá drílĩyî ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî ꞌbãzó tólâ lómígówá ró. ");
INSERT INTO avu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gõꞌdá nĩngá sĩ rî, kậyı̣̂ Yúdạ̃ yí kâ rãtáã kâ vósĩ rî, kậyı̣̂ Gímã kâ sĩ ãkpãkãꞌdã cı̣̃ı̣́nó, Mãríyã Mãgãdálã yî drí ngãzó nĩlí Mãríyã ãzí lâ bê lóꞌdé drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gõꞌdá gólĩyî câ bê tólâ rî, mãlãyíkã Ôvârí kâ ãzâ drí âcázó ûrú lésĩ. Nyĩî ró, ạ̃gbı̣̃gbı̣̃ ândrê drí îtõzó ı̣̃nyạ́kú drı̣̃ îyálé rõô, tãlâ âcâ-âcâ mãlãyíkã ꞌdî kâ ꞌdĩ drí sĩ. Mãlãyíkã ꞌdî âcâ bê rî, drílâ kúnı̣́ úngû ꞌbãlé ũgı̣́ Yésũ rî ãvõ ꞌbãzó ꞌá lâ rî tı̣́ ꞌdĩ lîlízó vólé, drílâ gõzó rĩlí gá kúnı̣́ rî ꞌdĩ drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gõꞌdá mãlãyíkã ꞌdî ándrá-gạ́-sı̣́lı̣́ lâ rĩꞌá lậgû-lậgû ró õzõ ngá îꞌĩ-îꞌĩ kâtí, gõꞌdá ítá gólâkâ rĩꞌá mvẽêmvê ró kpírí-kpírí. ");
INSERT INTO avu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ĩtí rî, ạ̃jú ꞌbũ ꞌbá gólĩyî ꞌbãlé rĩꞌá ĩyî Yésũ rî lóꞌdé vó ndrẽlé ꞌdĩ ꞌbá yî ndrê ĩyî mãlãyíkã ꞌdî bê rî, ũrı̣̃ drí gãzó gólĩyî rú rõô. Gólĩyî rúꞌbạ́ drí rĩzó lẽlé ũrı̣̃ drí sĩ, gõꞌdá drílĩyî lôꞌdézó ndrĩ vũdrı̣́ rû îꞌwã ãkó õzõ ãvõ kâtí. ");
INSERT INTO avu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Gõꞌdá mãlãyíkã ꞌdî drí ngãzó tã âtálé õkó ꞌdĩ ꞌbá yî drí kĩ, “Nĩ ꞌê ũrı̣̃ kô! Má nı̣̃ trá, nĩ rî Yésũ gólâ îpálé fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ rî lôndãlé. ");
INSERT INTO avu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gólâ yû nõngá. Gólâ lîdrî trá, õzõ gólâ drí tã lâ âtárẽ trá ãnî drí rî kâtí. Nĩ ânĩ võ gólâ rî ãvõ lâlãzó ꞌá lâ rî ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nĩ nĩ ꞌwãâ, nĩꞌá tã lâ âtálé lãjóꞌbá gólâkâ rî ꞌbá yî drí kĩ, gólâ lîdrî trá õdrã ꞌásĩ. Gólâ âꞌdô lậvũꞌá sı̣́sı̣́ ãnî ândrá nĩlí Gãlĩláyã ꞌálâ. Nĩ âꞌdô nĩꞌá gólâ rî ndrẽlé tólâ. ꞌDĩî tã má drí âtílí ãnî drí nĩꞌá âtálé rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ĩtí rî, õkó ꞌdĩ ꞌbá yî drẽ zãâ ũrı̣̃ ró, gõꞌdá gólĩyî drí kpá âꞌdózó ãyĩkõ ãmbá bê tã tãndí âtílí gólĩyî drí ꞌdĩ tãsĩ. Gõꞌdá drílĩyî nĩzó ꞌwãâꞌwâ tã mãlãyíkã ꞌdî drí âtílí gólĩyî tı̣́ ꞌdĩ âtálé lãjóꞌbá Yésũ kâ rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Gólĩyî õtírĩ ꞌbãâ nĩꞌá rî, nyĩî ró, Yésũ rî gógó nyãányâ lâ drí ânĩzó rû ûsúlı̣́ gólĩyí bê lạ́tı̣̂ ꞌá. Yésũ drí nî-bê-yã ꞌẽzó drílĩyî. Gõꞌdá drílĩyî rãzó nĩꞌá rû ûtúlı̣́ Yésũ drı̣̃ı̣̂, gõꞌdá drílĩyî Yésũ rî pá âmvózó gólâ rî ı̣̂njı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Gõꞌdá Yésũ drí tã âtázó drílĩyî kĩ, “Nĩ ꞌê ũrı̣̃ kô! Nĩ nĩ tã âtálé ámâ rû-lẽ-ãzí yî drí, gólĩyî õnĩ Gãlĩláyã ꞌálâ. Gólĩyî âꞌdô ámâ ndrẽꞌá tólâ.” ");
INSERT INTO avu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nĩngá sĩ rî, õkó ꞌdĩ ꞌbá yî drí ngãzó lậvũlı̣́ ậcı̣́ ĩyíkâ ꞌá, nĩꞌá lãjóꞌbá Yésũ kâ rî ꞌbá yî ngálâ. Gõꞌdá drẽ ãkpãkãꞌdã gólĩyî drí cã ãkó rî, ạ̃jú ꞌbũ ꞌbá ũrûkậ ꞌbá yî gólĩyî rĩ ꞌbá Yésũ rî lóꞌdé drı̣̃ lômílí rî ꞌbá yî drí ngãzó nĩlí ĩyî Yẽrõsãlémã ꞌálâ, nĩꞌá tã gólĩyî rû ꞌẽ ꞌbá ꞌdĩ ꞌbá yî tã lâ âtálé drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ârî ĩyî tã ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí âtálé ꞌdĩ bê rî, drílĩyî ngãzó rû êꞌbélé võ ãlô ꞌá õjílã sı̣́sı̣́-lésĩ rî ꞌbá yí bê tã ı̣̂ꞌbı̣̃lı̣́ tã gólĩyî rû ꞌẽ ꞌbá ꞌdĩ ꞌbá yî tãsĩ. Gõꞌdá drílĩyî ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî lı̣̃fı̣́ lâ yî gĩzó ậdı̣̂ ãmbá sĩ, tãlâ gólĩyî ãâdô ró õnjõ bê tã ꞌdî ꞌbá yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã âtázó ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí kĩ, “Õzõ íĩîjî ãnî trá rî, nĩ âtâ tã kĩ nĩ rî, ‘Mã õtírĩ ꞌbãâ ậꞌdú kõꞌá ngạ́cı̣̂ bê rî, lãjóꞌbá Yésũ kâ rî ꞌbá yî drí ânĩzó gólâ rî ãvõ ûgũlı̣́ ũgı̣́ ꞌásĩ.’ ");
INSERT INTO avu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gõꞌdá õzõ úlı̣́ ꞌdĩ õꞌdê trá kúmú Pĩlátõ bı̣́lı̣́ rî, mã âꞌdô âdréꞌá ãní bê. Mã âꞌdô tã âtáꞌá gólâ drí kĩ nĩ rî, úlı̣́ ãnî drí âtálé ꞌdĩ rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî. Ĩtí rî, gólâ îcá kô lâŋõ fẽlé ãnî drí.” ");
INSERT INTO avu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nĩngá sĩ, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí tã-drı̣̃ lẽzó. Drílĩyî ậdı̣̂ fẽlé ĩyî drí ꞌdĩ trõzó nĩzó tã gólâ âtálé gólĩyî drí kĩꞌá nĩ rî, lãjóꞌbá Yésũ kâ ũûgũ ĩyî Yésũ rî ãvõ nĩ ꞌdî tã lâ âtálé õjílã drí. Gõꞌdá tã ꞌdî drí lậꞌbúzó õjílã Yúdạ̃ yí kâ rî ꞌbá yî lãfálé sĩ, âcálé bũúũ ãndrõ nô. Ĩtí rî, õjílã Yúdạ̃ yí kâ lẽé ĩyî tã kô kĩꞌá nĩ rî, Yésũ õlîdrî trá õdrã ꞌásĩ rî. ");
INSERT INTO avu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gõꞌdá nĩngá sĩ, lãjóꞌbá Yésũ kâ mûdrı̣́-drı̣̃-lâ-ngâ-ãlô ꞌdĩ ꞌbá yî ârî ĩyî tã Yésũ drí âtílí õkó ꞌdĩ ꞌbá yî tı̣́ ânĩꞌá âtálâ ĩyî drí ꞌdĩ bê rî, drílĩyî ngãzó nĩlí Gãlĩláyã ꞌálâ únı̣́ gólâ Yésũ drí tã lâ âtálé kĩꞌá nĩ rî, gólĩyî ãꞌdô nĩꞌá íyî ûsúlı̣́ drı̣̃ lâ ꞌálâ rî drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gólĩyî câ bê tólâ rî, drílĩyî Yésũ rî ûsúzó, gõꞌdá drílĩyî gólâ rî ı̣̂njı̣̃zó. Gõꞌdá kpálé gólĩyî ndrélé bê Yésũ rî, tã ârí ꞌbá ũrûkậ ꞌbá yî, tã ı̣̂sũ gólĩyíkâ drẽ zãâ rĩꞌá rı̣̃ rı̣̃ tã lẽlé kĩ, ꞌdĩî ãꞌdô pạ̃tı̣́ı̣̃ Yésũ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gõꞌdá Yésũ drí rû êsézó ãnyî lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî lạ̃gạ́tı̣́, gõꞌdá drílâ ngãzó tã âtálé drílĩyî kĩ, “Ôvârí fẽ drı̣́-ãcê ngá gólĩyî ndrĩ ꞌbũû ꞌálâ rî ꞌbá yí kâ gõꞌdá ngá gólĩyî ndrĩ ãngó nõ ꞌá rî ꞌbá yí bê rî kâ trá má drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tã ꞌdî tãsĩ rî, nĩ ngâ lậꞌbúlı̣́ võ ꞌásĩ ndrĩ tã âtî-âtî tãndí ámákâ nõ pẽlé õjílã õrĩ ndrĩ ãngó ꞌásĩ rî kâ drí, gólĩyî ãꞌdô ró bê tã ârí ꞌbá ámákâ ró. Gõꞌdá gólĩyî tã lẽ ꞌbá trá rî, nĩ îbábátízã gólĩyî Átá rî rú sĩ, Mvá rî rú sĩ, gõꞌdá kpá Líndrí Tãndí rî rú sĩ. ");
INSERT INTO avu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gõꞌdá nĩ îmbâ gólĩyî kpá tã ndrĩ má drí âꞌdálé ãnî drí rî ꞌbá yî ꞌẽlé. Má âꞌdô rĩꞌá ãní bê kậyı̣̂ vósĩ cé, cãlé bũúũ kậyı̣̂ ạ̃dũkũ ãngó nõ kâ rî tú.” Ĩꞌdî ꞌdĩ.");
INSERT INTO avu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tã âtî-âtî tãndí Yésũ Krístõ gólâ Ôvârí rî mvá rî tãsĩ rî rĩꞌá nõtí. ");
INSERT INTO avu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tã Yésũ kâ îtõ rû trá õzõ tã ậngũ ꞌbá Ĩsáyã drí îgĩlí trá ạ̃kû ró nã sĩ rî kâtí, Ôvârí âtâ íyî mvá drí kĩ nĩ rî, “Ní ndrê drẽ, má âꞌdô lãjóꞌbá ámákâ jõꞌá ạ̃tı̣́ ꞌálâ, ãꞌdô ró lạ́tı̣̂ êdélé ní drí ânĩzó. ");
INSERT INTO avu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lãjóꞌbá rî gógó ꞌdĩ âꞌdô rĩꞌá õmã ꞌá. Gólâ âꞌdô tã îyáꞌá ûrû âkĩꞌá nĩ rî, ‘Ãnî õjílã, kúmú ãmákâ ãâꞌdô bí ꞌẽꞌá âcálé. Ĩtí rî, nĩ êdê lạ́tı̣̂ ãníkâ njãâ gólâ drí. Nĩ êdê lạ́tı̣̂ rî ꞌdĩ dódó mbı̣̂mbı̣̂ ró, ãꞌdô ró bê gólâ drí ậcı̣́ tõzó drı̣̃ lâ ꞌásĩ.’ ” ");
INSERT INTO avu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Lãjóꞌbá gólâ Ôvârí drí tã lâ pẽlé ꞌdĩ Yõwánĩ ĩꞌdî. Gólâ rî õmã ꞌá, gõꞌdá drílâ rĩzó õjílã ậzı̣́lı̣́ ânĩlí, yí dã ró lũmvû gólĩyî drı̣̃ı̣̂ bãbãtízĩ ró. Gólâ âtâ úlı̣́ gólĩyî drí kĩ nĩ rî, “Nĩ âjâ drı̣̃ tã õnjí ꞌásĩ Ôvârí rî rõlé. Õzõ nĩ õꞌê tã ꞌdî ĩꞌdî rî, Ôvârí âꞌdô ãnî âyéꞌá tã õnjí ãníkâ ꞌásĩ. Gõꞌdá nĩ ânĩ má dã ró lũmvû ãnî drı̣̃ı̣̂ bãbãtízĩ ró.” ");
INSERT INTO avu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nĩngá sĩ, õjílã dũû drí ngãzó nĩlí Yõwánĩ ngálâ õmã ꞌálâ. Õjílã rî ꞌdĩ ꞌbá yî ũrûkậ lâ ânĩ ĩyî Yẽrõsãlémã lésĩ, gõꞌdá ãzâ ꞌbá yî ânĩ ĩyî võ ãzâ ꞌbá yî lésĩ Yũdạ́yạ̃ ꞌá. Nĩngá sĩ, drílĩyî úlı̣́ Yõwánĩ drí pẽlé ꞌdĩ ârízó ĩyî. Vólé drı̣̃ lâ ꞌásĩ rî, drílĩyî ngãzó tã õnjí ĩyíkâ lôfõlé. Gõꞌdá nĩngá sĩ, Yõwánĩ drí ngãzó lũmvû dãlé gólĩyî drı̣̃ı̣̂ lı̣̃mvû áyágá zı̣̃lı̣́ Jõrõdénĩ rî ꞌá bãbãtízĩ ró. ");
INSERT INTO avu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yõwánĩ rî ꞌdĩ, éêdê ítá gólâkâ trá gámẽlẽ ꞌbí ꞌásĩ. Gásĩ gólâkâ íyî ı̣́pı̣́tı̣́kû ꞌá rî íyíkâ ínyíríkó ꞌásĩ, gõꞌdá ngá nyãnyã gólâkâ rî íyíkâ ômbí ĩꞌdî gbõ ápé õgó kâ bê. ");
INSERT INTO avu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yõwánĩ îyâ tã âtî-âtî tãndí ꞌdĩ kĩ, “Õjílã ãzâ âbí ânĩꞌá má vó, ãmbã gólâkâ gạ̃rạ̃ ámákâ rî drı̣̃ı̣̂ sĩ. Ãmbã ámákâ îcá kô. Má îcá kô ậndı̣̃lı̣́ káꞌbókã gólâkâ ângílí. ");
INSERT INTO avu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mâ rî gógó Yõwánĩ nô ꞌê bãbãtízĩ õjílã drí cé lũmvû sĩ. Gõꞌdá gólâ rî gógó âꞌdô bãbãtízĩ ꞌẽꞌá õjílã drí Líndrí Tãndí Ôvârí kâ rî sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nĩngá sĩ, Yésũ drí ngãzó Nãzãrétã gólâ ꞌbạ̃drı̣̃ zı̣̃lı̣́ Gãlĩláyã rî ꞌá rî lésĩ nĩlí Yõwánĩ ngálâ. Nĩngá sĩ, Yõwánĩ drí ngãzó gólâ rî îbábátízãlé áyágá zı̣̃lı̣́ Jõrõdénĩ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Gõꞌdá nĩngá sĩ, Yésũ õtírĩ rĩî âfõlé lı̣̃mvû ꞌdĩ ꞌásĩ rî, gólâ drí ꞌbũû ndrẽzó rû njı̣̃rı̣̃ ꞌá, gõꞌdá Líndrí Tãndí Ôvârí kâ drí âꞌdézó drı̣̃ lâ õzõ ạ̃túꞌbú kâtí. ");
INSERT INTO avu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gõꞌdá úlı̣́ drí ậꞌúzó ꞌbũû lésĩ Yésũ drí kĩ nĩ rî, “Nî nõ ámâ mvá ífífí má drí lôvó lâ ꞌbãlé kôrô rî ĩꞌdî. Ánî tã sû trá má rú rõô.” ");
INSERT INTO avu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tã ꞌdî vólé drı̣̃ lâ ꞌásĩ, Líndrí Tãndí Ôvârí kâ ꞌdĩ drí Yésũ rî jõzó vólé õmã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tólâ õmã ꞌálâ, Yésũ ꞌê kậyı̣̂ rĩꞌá nyâꞌdî-rı̣̃ kõrõnyã õnjí õmã kâ lãfálé. ꞌDĩî Sãtánã íyíkâ rĩꞌá gólâ rî ûjũꞌá kpı̣̃ı̣̂. Gõꞌdá mãlãyíkã Ôvârí kâ rî ꞌbá yí bê, rĩꞌá ĩyî Yésũ rî gógó lôkíꞌá. ");
INSERT INTO avu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yõwánĩ gólâ bãbãtízĩ ꞌẽ ꞌbá rî ômbérẽ gạ̃nı̣́mạ̃ ꞌá rî vólé drı̣̃ lâ ꞌásĩ rî, Yésũ drí ngãzó gõlé Gãlĩláyã ꞌálâ. Tólâ gólâ lậmû võ ꞌásĩ nĩlí nĩꞌá tã âtî-âtî Ôvârí kâ pẽ bê. ");
INSERT INTO avu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Gólâ kĩ nĩ rî, “Ôvârí njı̣̃ lạ́tı̣̂ trá ãnî drí rĩzó kũmũ íyíkâ zẽlé õjílã íyíkâ ró. Âꞌdô bê trá ĩtí rî, nĩ âjâ drı̣̃ tã õnjí ãníkâ ꞌásĩ, nĩ gõ ró tã lẽlẽ ãníkâ ꞌbãlé tã âtî-âtî tãndí Ôvârí kâ ꞌdĩ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kậyı̣̂ ãlô sĩ, Yésũ õtírĩ rĩî nĩlí lı̣̃mvû ândrê Gãlĩláyã kâ rî tı̣́ sĩ rî, drílâ nĩzó ı̣̃ꞌbı̣̂ ꞌbẽ ꞌbá ãzâ ꞌbá yî ûsúlı̣́ rı̣̃, Sĩmónã Pétẽrõ gõꞌdá ậdrúpı̣̃ lâ Ãndĩríyã bê. Gólĩyî rĩꞌá îmbá ĩyíkâ ı̣̃ꞌbı̣̂ kâ vũꞌá lı̣̃mvû ꞌá. Sĩmónã yî Ãndĩríyã bê rĩꞌá ĩyî kpạ̃rạ̃tı̣́ ı̣̃ꞌbı̣̂ ꞌbẽ ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nĩngá sĩ, Yésũ drí ngãzó tã âtálé gólĩyî drí kĩ nĩ rî, “Nĩ ânĩ ꞌdẽlé má vósĩ, tãlâ má ꞌbã ró ãnî bê õjílã âsé ꞌbá ró má drí, gólĩyî ãꞌdô ró õjílã ámákâ ró, õzõ ãnî drí âꞌdórẽ ı̣̃ꞌbı̣̂ âsé ꞌbá ró sı̣́sı̣́ rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Gõꞌdá nĩngá sĩ, drílĩyî ngãzó ꞌwãâ îmbá ĩyíkâ âyélé ꞌdẽzó Yésũ vósĩ lãjóꞌbá gólâkâ ró. ");
INSERT INTO avu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gõꞌdá drílĩyî ngãzó nĩlí ạ̃tı̣́ ꞌálâ fínyáwá. Nĩngá sĩ, Yésũ drí Zẽbẽdáyõ yî ûsúzó mvá lâ yí bê rı̣̃, rú lâ yî Yãkóbã yî Yõwánĩ bê. ꞌDĩî gólĩyî rĩꞌá kõlóngbõ ꞌá îmbá ĩyíkâ lı̣̃fı̣́ lâ êdéꞌá. ");
INSERT INTO avu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gõꞌdá nĩngá sĩ, Yésũ ndrê gólĩyî bê rî, drílâ ngãzó ꞌwãâ Yãkóbã yî ậzı̣́lı̣́ Yõwánĩ bê âꞌdólé lãjóꞌbá íyíkâ ró. Nĩngá sĩ, drílĩyî ngãzó átá lâ yî âyélé kõlóngbõ ꞌá ꞌdẽzó Yésũ vósĩ lãjóꞌbá gólâkâ ró. ");
INSERT INTO avu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ꞌDĩî vósĩ, Yésũ yî drí ngãzó nĩlí lãjóꞌbá íyíkâ bê jạ̃rı̣́bạ̃ zı̣̃lı̣́ Kãpẽrãnómã rî ꞌálâ. Kậyı̣̂ rãtáã kâ sĩ rî, Yésũ yî drí ngãzó fĩlí ĩyî jó tã Ôvârí kâ ârî kâ ꞌá. Tólâ Yésũ drí ngãzó rĩꞌá tã Ôvârí kâ îmbálé õjílã drí. ");
INSERT INTO avu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gõꞌdá nĩngá sĩ rî, õjílã ꞌdî ꞌbá yî tı̣̂ lâ yî drí ậꞌdı̣́zó tã Yésũ drí rĩꞌá îmbálâ ꞌdĩ drí sĩ. Tã îmbâ Yésũ kâ rî âꞌdó õzõ lı̣̃fı̣́ îmbá ꞌbá ãzâ ꞌbá yî gólĩyî rĩ ꞌbá rĩlí lãꞌbí Ôvârí kâ âꞌdálé rî ãzâ ꞌbá yí kâtí kô ãlôwálâ, tãlâ Yésũ rî gógó nyãányâ lâ îmbâ tã íyíkâ cú drı̣́-ãcê kúmú kâ rî sĩ. ");
INSERT INTO avu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yésũ õtírĩ rĩî drẽ tã îmbálé rî, ãgô ãzâ bê rĩꞌá líndrí õnjí ạ̃bạ̃bạ̃ Sãtánã kâ rî kâ bê, ômbê gólâ trá vũdrı̣́. Gõꞌdá ạ̃trũ kũꞌdũ ró, ãgô rî ꞌdĩ drí ngãzó rĩꞌá ôtrélé lạ̃zı̣́ zı̣̃zı̣̃ bê úlı̣́ líndrí õnjí yí ꞌá ꞌdĩ ꞌbá yí kâ sĩ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Má nı̣̃ nî trá dódó, Yésũ õjílã Nãzãrétã kâ ró. Nî õjílã ndı̣̂ndı̣̂ ꞌî pạ̃tı̣́ı̣̃ Ôvârí kâ rî ĩꞌdî. Ní lẽ ãꞌdô ꞌẽlé má rú yã? Ní ânĩ nô mâ líndrí õnjí ró ãgô nõ ꞌá nõ fũlı̣́ yã?” ");
INSERT INTO avu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ drí ꞌálé ãdrã sĩ, “Ní rî tı̣́tı̣́, ní âfõ vólé ãgô nõ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Gõꞌdá nĩngá sĩ, líndrí õnjí ạ̃bạ̃bạ̃ kâ rĩ ꞌbá ãgô ꞌdĩ ꞌá ꞌdĩ drí rĩzó ãgô rî ꞌdĩ îyálé kĩíkĩí mbârâkã sĩ, drílâ ãgô ꞌdĩ ꞌbãzó ôtrélé ngbạ́lạ́-ngbạ́lạ́, gõꞌdá drílâ ngãzó drı̣́ înjílí vólé ãgô rî ꞌdĩ rú sĩ. ");
INSERT INTO avu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gõꞌdá nĩngá sĩ, õjílã tı̣̂ drí ậꞌdı̣́zó ndrĩ tã ꞌdî drí sĩ. Nĩngá sĩ, drílĩyî ngãzó rĩꞌá tã îjílí ĩyî võ ꞌásĩ kĩ nĩ rî, “Ngá nõtí nõ ãꞌdô ꞌî? Gólâ rî tã âtálé drı̣́-ãcê Ôvârí kâ rî sĩ, tãlâ líndrí õnjí ꞌdĩ ãârî ró kpá tã gólâ drí rĩꞌá rãlâ rî ꞌbá yî bê.” ");
INSERT INTO avu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nĩngá sĩ, õjílã ꞌdî ꞌbá yî drí ngãzó nĩlí ꞌbã ꞌálâ tã Yésũ drí líndrí õnjí ꞌdĩ drõzó ꞌdĩ âtálé õjílã ãzâ ꞌbá yî drí. Ĩtí, tã ꞌdî ꞌbã Yésũ rî rú âꞌdólé lı̣̂kû-lı̣̂kû ró ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî ꞌásĩ dîrî kạ̃ngbû. ");
INSERT INTO avu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ꞌDĩî vósĩ, Yésũ yî drí ngãzó nĩlí vólé jó tã Ôvârí kâ ârî kâ rî ꞌásĩ. Gólĩyî Sĩmónã, Ãndĩríyã, Yãkóbã, gõꞌdá Yõwánĩ yí bê. Gólĩyî nĩ kôrô mbı̣̂ Sĩmónã Pétẽrõ yî drí ꞌbã ꞌálâ ậdrúpı̣̃ lâ Ãndĩríyã bê. ");
INSERT INTO avu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tólâ Sĩmónã rî ãdrá rĩꞌá ậyı̣́ꞌá vũdrı̣́ gbãrãkã drı̣̃ı̣̂ jó ꞌá. Rúꞌbạ́ lâ âmê trá tílí-tílí. Nĩngá sĩ, ꞌwãâ ngá lãzé gólâkâ ꞌdĩ ódrí tã lâ pẽzó Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yésũ drí ngãzó fĩlí õkó rî ꞌdĩ ngálâ jó ꞌálâ. Nĩngá sĩ, Yésũ drí drı̣́ lâ rũzó sẽlé, tãlâ gólâ õngâ ró bê ûrû. Kôrô ꞌwãâ õkó rî ꞌdĩ rúꞌbạ́ lâ âmé ꞌbá ꞌdĩ drí ậꞌdı̣́zó, gõꞌdá drílâ ngãzó nĩlí ngá nyãnyã lâꞌdílí gólĩyî drí nyãlé. ");
INSERT INTO avu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ị̃tú õtírĩ fĩî rî, õjílã drí ngãzó rĩꞌá ngá lãzé ꞌbá gõꞌdá kpá gólĩyî líndrí õnjí Sãtánã kâ drí ômbélé trá rî ꞌbá yí bê âtrõlé âjílí Yésũ ngálâ. ");
INSERT INTO avu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gõꞌdá nĩngá sĩ, õjílã jạ̃rı̣́bạ̃ ꞌdî ꞌásĩ rî drí ĩyî ômózó tı̣́lı̣́lı̣́ ró jó tı̣́lı̣́ jó Yésũ drí rĩzó rĩlí rî tı̣́. ");
INSERT INTO avu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nĩngá sĩ, Yésũ drí ngãzó rĩꞌá õjílã dũû ngá lãzé tı̣̂ lârâkô ngĩíngî bê rî ꞌbá yî pãlé ngá lãzé ĩyíkâ ꞌásĩ. Drílâ kpá líndrí õnjí ꞌdĩ ꞌbá yî lâdrózó vólé õjílã gólĩyî âꞌdó ꞌbá ĩꞌdí bê lâ rî ꞌbá yî ꞌásĩ. Gólâ âyé líndrí õnjí ꞌdĩ ꞌbá yî kô tı̣̂ njı̣̃lı̣́ lãndrâ drı̣̃ı̣̂ sĩ, tãlâ gólĩyî nı̣̃ trá kĩ, gólâ ãꞌdî ĩꞌdî yã. Gõꞌdá ĩtí rî, Yésũ lẽé drẽ kô gólĩyî drí íyî tã ꞌbãlé lậꞌbúlı̣́ ꞌwãâ õjílã drí. ");
INSERT INTO avu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cı̣̃ı̣́nó rî ꞌdĩ sĩ, Yésũ drí ngãzó jó ꞌdĩ ꞌásĩ ãkpã võ drẽ pạ̃nı̣̃-pạ̃nı̣̃ nĩlí võ õjílã ãkó rî ꞌá tólâ nĩlí tı̣̂ îrátãlé Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Gõꞌdá Yésũ bê trá yûꞌdạ́wạ́ rî, Sĩmónã yî íyî ãzí-ãzí yí bê drí ngãzó nĩlí Yésũ rî lôndãlé. ");
INSERT INTO avu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Gõꞌdá gólĩyî ûsû Yésũ bê rî, drílĩyî ngãzó tã âtálé drílâ kĩ nĩ rî, “Õjílã ndrĩ ꞌdó rĩꞌá ánî lôndãꞌá, ní ãâgõ ró ĩyî pãlé!” ");
INSERT INTO avu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ nĩ rî, “Nĩ ꞌdê, mã nĩ ró võ ãzâ ꞌbá yî âꞌdó ꞌbá ãnyî rî ꞌbá yî ꞌálâ, tãlâ má lẽ kpá úlı̣́ Ôvârí kâ pẽlé õjílã gólĩyî võ ꞌdî ꞌbá yî ꞌá ꞌdĩ yî drí, tãlâ ꞌdĩî ngá ꞌẽꞌẽ má drí ânĩꞌá ꞌẽlâ nõngá rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ĩtí ró rî, gólĩyî drí lậmúzó dîrî võ Gãlĩláyã kâ rî ꞌásĩ ndrĩ. Võ rî ꞌdĩ ꞌbá yî ꞌá rî, Yésũ drí nĩzó úlı̣́ Ôvârí kâ pẽ bê õjílã drí jó tã Ôvârí kâ ârî kâ rî ꞌbá yî ꞌásĩ. Gõꞌdá gólâ lâdrô líndrí õnjí kpá õjílã líndrí ꞌdĩ ꞌbá yî drí rĩzó ꞌá lâ yî rî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ị̃tú ãzâ sĩ, ãgô ãzâ ãrí ꞌbá ró drí ânĩzó ꞌãꞌî tı̣̃lı̣́ ı̣̃nyạ́kú drı̣̃ı̣̂ Yésũ ândrá. Drílâ ngãzó rúꞌbạ́ lôꞌbãlé Yésũ drí kĩ nĩ rî, “Õzõ ĩîcâ trá ní lı̣̃fı̣́ ãꞌdô ró bê ámâ êdézó rî, ꞌdõvó ní êdê mâ ngbángbá ngá lãzé ámákâ nõ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nĩngá sĩ, ãgô rî ꞌdĩ ĩzã lâ drí gãzó Yésũ drí. Gõꞌdá Yésũ drí ngãzó drı̣́ ꞌbãlé gólâ drı̣̃ı̣̂, gõzó tã âtálé kĩ nĩ rî, “Ãwô, má lẽ tã trá ánî pãzó âꞌdólé rúꞌbạ́ bê ngbángbá.” ");
INSERT INTO avu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nĩngá sĩ, kôrô ãrí ꞌdĩ drí rû ndẽzó vólé ãgô ꞌdĩ rúꞌbạ́ lâ ꞌásĩ. Gõꞌdá ãgô rî ꞌdĩ rúꞌbạ́ lâ drí âꞌdózó lúwạ́-lúwạ́. ");
INSERT INTO avu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Gõꞌdá nĩngá sĩ, Yésũ drí ngãzó ãgô rî ꞌdĩ âtílí ngbílí-ngbílí kĩ nĩ rî, “Ní ârî dódó, ní âtâ tã kô tã rî nõ tãsĩ õjílã ãzãkã drí. Ní ꞌdâ lãꞌbí rúꞌbạ́ drí rû êdézó ãrí ꞌásĩ rî ĩꞌdî. Ní nĩ cú nî, ánî nyãányâ âꞌdálé drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî drí, ní gõ ró kõrõnyã lı̣̃lı̣́ ngá fẽfẽ ró Ôvârí drí, õzõ tã âtâ Músạ̃ kâ ꞌbãlé ãrí ꞌbá ãꞌdô ró ngbángbá rî kâtí, tãlâ ní ꞌê ró ãwô-ĩtí ãmbá Ôvârí drí. Õzõ ní õꞌê tã rî ꞌdĩ trá ĩtí rî, õjílã ndrĩ âꞌdô nı̣̃ꞌá lâ ĩyî kĩ nĩ rî, ngá lãzé áníkâ ãrí ró ꞌdĩ õndẽ rû trá ní rú sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yésũ âtâ bê tã ꞌdî kpálé ĩtí ãgô rî ꞌdĩ drí rî, ãgô rî ꞌdĩ cí tı̣̂ tã Yésũ drí pẽlé yí drí ꞌdĩ drı̣̃ı̣̂ kô. Gólâ ngâ íyîngá nĩꞌá tã rî ꞌdĩ âtá bê õjílã drí ârílí ndrĩ, gõꞌdá tã rî ꞌdĩ drí lậꞌbúzó fãã võ ꞌásĩ cé tı̣̂tı̣̂. Ĩtí lâ ꞌdĩ drí rî, Yésũ îcá gõꞌdá kô nĩꞌá fĩlí jạ̃rı̣́bạ̃ ãzâ ꞌbá yî ꞌásĩ, õjílã tı̣́lı̣́lı̣́ õzó ĩyî gólâ rî ômó kô rõô. Ĩꞌdî ĩtí, Yésũ lãjóꞌbá íyíkâ rî ꞌbá yí bê drí gõzó rĩlí ĩyî õmã ꞌá. Kpálé Yésũ yî rĩrĩ õmã ꞌá ꞌdĩ sĩ rî, õjílã dũû ĩyíkâ zãâ ânĩꞌá ĩyî gólâ ngálâ võ drı̣̃ ꞌásĩ cé tı̣̂tı̣̂. ");
INSERT INTO avu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kậyı̣̂ fínyáwá vólé drı̣̃ ꞌásĩ, Yésũ drí ngãzó gõlé vólé Kãpẽrãnómã ꞌálâ. Áâtâ ókĩ nĩ rî, Yésũ bê ꞌbã gólâ drí rĩzó rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gõꞌdá õjílã ârî ĩyî bê úlı̣́ rî ꞌdĩ rî, õjílã ı̣́tı̣́lı̣́lı̣́ drí ngãzó rû êꞌbélé dũû jó ꞌá Yésũ ngálâ bũúũ ạ̃ꞌdı̣́-drı̣̃ ꞌásĩ ndrĩ. Gõꞌdá Yésũ drí ngãzó rĩꞌá tã Ôvârí kâ âtálé gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nĩngá sĩ, Yésũ õtírĩ rĩî úlı̣́ âtálé rî, õjílã sû drí ãgô ãzâ pá lâ drí ôdrãlé trá kpạ̃rạ̃tı̣́ rî ậnjı̣̃zó ânĩzó ĩꞌdí bê lâ gbãrãkã sĩ Yésũ ngálâ, tãlâ Yésũ õpâ ró gólâ bê âꞌdólé ndı̣̂ndı̣̂ ró. ");
INSERT INTO avu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nĩngá sĩ, gólĩyî âcâ bê ꞌbã rî ꞌdĩ ꞌá rî, gólĩyî îcá gõꞌdá kô ãgô pá lâ drí ôdrãlé trá kpạ̃rạ̃tı̣́ ꞌdĩ lôfílí Yésũ ngálâ jó ꞌálâ, tãlâ õjílã trá rĩꞌá ĩyî ngbạ̃ꞌũ rõô. Gõꞌdá nĩngá sĩ, õjílã gólĩyî ãgô pá lâ drí ôdrãlé trá ꞌdĩ ậnjı̣̃ ꞌbá ꞌdĩ ꞌbá yî drí ngãzó mbãlé ũpı̣̃ lõlé jó-drı̣̃ lésĩ gõzó gbãrãkã ãgô pá lâ drí ôdrãlé ꞌdĩ bê ꞌdĩ âꞌĩzó bãgó sĩ îrílí kôrô ũpı̣̃ rî ꞌdĩ ꞌásĩ jó ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gõꞌdá Yésũ ndrê tã rî ꞌdĩ ĩtí bê rî, drílâ nı̣̃zó lâ kĩ nĩ rî, ãgô ꞌdĩ ꞌbá yî rĩꞌá ĩyî tã lẽlẽ ạ́ngı̣́ bê mbârâkã íyíkâ õjílã pã kâ rî ꞌá. Ĩtí ró rî, Yésũ drí ngãzó tã âtálé ãgô pá lâ drí ôdrãlé trá ꞌdĩ drí kĩ nĩ rî, “Ámâ rû-lẽ-ãzíyã, áâyê nî trá tã õnjí áníkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nĩngá sĩ rî, gólĩyî lãꞌbí îmbá ꞌbá rî ꞌbá yî kpá rĩꞌá ĩyî tólâ Yésũ bê. Gõꞌdá gólĩyî ârî úlı̣́ Yésũ kâ ꞌdĩ bê rî, drílĩyî ngãzó tã ı̣̂sũlı̣́ ĩyî ꞌá kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","íyíkâ kô ángô tí ró ãgô nõ drí rĩzó úlı̣́ âtálé nõtí nõ yã? Gólâ trá ꞌẽꞌá Ôvârí rî mbârâkã âmãlé yí drí. Cé Ôvârí ĩꞌdî îcá ꞌbá ró tã õnjí õjílã kâ âyélé. ");
INSERT INTO avu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nĩngá sĩ, Yésũ drí ꞌwãâ tã ı̣̂sũ-ı̣̂sũ gólĩyíkâ ꞌdĩ nı̣̃zó, gõꞌdá drílâ gólĩyî îjízó kĩ nĩ rî, “Nĩ rî tã ı̣̂sũlı̣́ ĩtí lâ ꞌdĩ ró má rú ãꞌdô tãsĩ? ");
INSERT INTO avu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mâ ꞌdíyî pã ꞌbá Ôvârí ngá lésĩ rî ĩꞌdî cú mbârâkã bê õjílã âyézó tã õnjí gólĩyíkâ ꞌásĩ. Gõꞌdá má îcâ trá tã ꞌdî âtálé cú ĩtí lâŋõ ãkó. Tã ꞌẽ ꞌbá âꞌdálâ kĩꞌá nĩ rî, pạ̃tı̣́ı̣̃ má âꞌdô âꞌdóꞌá mbârâkã ꞌdî bê rî, rĩꞌá nõtí, má âꞌdô ãgô nõ pá lâ yî ꞌbãꞌá âꞌdólé tãndí ró. ");
INSERT INTO avu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngbãângbânõ, má âꞌdô úlı̣́ âtáꞌá, tãlâ mĩ nı̣̃ ró bê kĩꞌá nĩ rî, mâ gólâ Ôvârí drí âjólé trá ûrú lésĩ rî rĩꞌá cú mbârâkã tã õnjí âyê kâ bê ãngó nõ ꞌá nõngá.” Nĩngá sĩ, Yésũ drí tã âtázó ãgô pá lâ drí ôdrãlé trá kpạ̃rạ̃tı̣́ rî drí kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Má ꞌbã tã ní drí kĩ nĩ rî, ní ngâ ûrû, ní trõ gbãrãkã áníkâ ꞌdĩ nĩzó ꞌbã ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nĩngá sĩ, õjílã ꞌdî ꞌbá yî lı̣̃fı̣́ drı̣̃ lâ ꞌá ndrĩ ãgô ꞌdĩ drí ngãzó ꞌwãâ kôrô âdrélé ûrû, drílâ gbãrãkã íyíkâ ꞌdĩ trõzó gõzó ngãlé fõlé ĩꞌdí bê lâ ĩví ꞌálâ. Tã lârâkô ꞌdĩ tãsĩ rî, õjílã ꞌdî ꞌbá yî tı̣̂ lâ yî drí ậꞌdı̣́zó. Gõꞌdá nĩngá sĩ, drílĩyî ngãzó Ôvârí rî lûyı̣́lı̣́ kĩ nĩ rî, “Ị̃tú ãmâ tı̣̃zó rî sĩ rî, mã ndré drẽ tã ꞌdî rî kâtí rî drẽ kó kô. Mã nı̣̃ı̣́ kô kĩ, Ôvârí ãâfẽ mbârâkã trá ãmbá Yésũ drí.” ");
INSERT INTO avu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tólâ sĩ, Yésũ yî drí ngãzó gõlé vólé lı̣̃mvû ândrê tı̣́ ꞌálâ tã ârí ꞌbá íyíkâ rî ꞌbá yí bê. ꞌDĩî õjílã ı̣́tı̣́lı̣́lı̣́ rõô bê rĩꞌá ânĩꞌá tã Yésũ kâ ârílí. Nĩngá sĩ rî, Yésũ drí ngãzó tã îmbálé gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Gõꞌdá ꞌdĩî vósĩ rî, Yésũ yî rĩꞌá lậmúꞌá rî, drílĩyî Mãtáyõ Ãlõpáyã rî mvá rî ûsúzó rĩꞌá võ íyíkâ bélé-bélé ûꞌdû kâ rî ꞌá. Nĩngá sĩ rî, Yésũ drí ngãzó tã âtálé gólâ drí kĩ nĩ rî, “Ní ngâ ꞌdẽlé má vósĩ âꞌdólé lãjóꞌbá ámákâ ró.” Nĩngá sĩ, Mãtáyõ drí ngãzó ꞌwãâ ꞌdẽlé gólâ vósĩ lãjóꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ꞌDĩî vósĩ, Mãtáyõ drí Yésũ yî ậzı̣́zó yí drí ꞌbã ꞌálâ. Yésũ yî õtírĩ rĩî ngá nyãlé Mãtáyõ rí ꞌbã ꞌálâ rî, bélé-bélé ûꞌdú ꞌbá gõꞌdá gólĩyî lãꞌbí Yúdạ̃ yí kâ rî ꞌdã ꞌbá kô rî ꞌbá yí bê rĩꞌá ĩyî dũû, tãlâ õjílã õzõ gólĩyí kâtí ꞌdĩ ꞌbá yî trá rĩꞌá dũû ꞌdó Yésũ rî vó lôbẽ ꞌbá ró. Yésũ yî lãjóꞌbá íyíkâ rî ꞌbá yí bê rî ĩyî rĩꞌá ngá nyãꞌá gólĩyí bê tólâ. ");
INSERT INTO avu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nĩngá sĩ, lãꞌbí îmbá ꞌbá âꞌdó ꞌbá ĩyî Pạ̃rúsı̣̃ ró rî ꞌbá yî drí ngãzó ânĩlí Yésũ rî ûsúlı̣́ lãjóꞌbá íyíkâ bê rĩꞌá ĩyî ngá nyãꞌá bélé-bélé ûꞌdú ꞌbá ꞌdĩ ꞌbá yí bê gõꞌdá kpá gólĩyî lãꞌbí îzã ꞌbá rî ꞌbá yí bê. Nĩngá sĩ, drílĩyî ngãzó tã îjílí lãjóꞌbá Yésũ kâ rî ꞌbá yî tı̣́ kĩ nĩ rî, “Yésũ rî rĩꞌá ngá nyãlé tã õnjí ꞌbá ꞌdĩ ꞌbá yí bê võ ãlô ꞌá ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nĩngá sĩ, Yésũ ârî bê tã îjî gólĩyíkâ ꞌdĩ rî, drílâ ngãzó tã-drı̣̃ lôgõlé kĩ nĩ rî, “Ngá lãzé ãkó lé ꞌbá lôndãá ójó kô, cé ngá lãzé ꞌbá lôndã ójó nĩ ĩyî pãlé. Gõꞌdá má ânĩí kô tã mbı̣̂ ꞌbá pãlé, má ânĩ tã õnjí ꞌbá ậzı̣́lı̣́, tãlâ ópâ ró gólĩyî bê tã õnjí gólĩyíkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nĩngá sĩ, tã ârí ꞌbá Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî kâ gõꞌdá kpá Pạ̃rúsı̣̃ kâ bê rî ĩyî trá tı̣̂ ꞌbĩlí rĩzó ꞌálé ꞌãꞌí ró rãtáã ꞌẽlé Ôvârí drí lãꞌbí Yúdạ̃ yí kâ vó ró. Nĩngá sĩ, õjílã ãzâ ꞌbá yî drí ngãzó Yésũ rî îjílí kĩ nĩ rî, “Tã ârí ꞌbá Yõwánĩ bãbãtízĩ ꞌbá ró rî kâ kpạ̃rạ̃tı̣́ tã ârí ꞌbá Pạ̃rúsı̣̃ kâ bê, rî ĩyî tı̣̂ ꞌbĩlí rĩzó ꞌálé ꞌãꞌí ró rãtáã ꞌẽlé Ôvârí drí. Gõꞌdá ãꞌdô tãsĩ gólĩyî tã ârí ꞌbá ánî nyãányâ kâ ró rî ꞌbá yî rí kô tı̣̂ ꞌbĩlí rĩzó ꞌálé ꞌãꞌí ró õzõ gólĩyí kâtí yã?” ");
INSERT INTO avu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Õdrógô bê rĩꞌá nõngá ãnî lãfálé ꞌá. Âꞌdô âꞌdóꞌá íyíkâ ángô tí ró ũmú gólâkâ drí rĩzó tı̣̂ ꞌbĩlí, gõꞌdá õdrógô drí âꞌdózó kpá bê lãfálé lâ yî ꞌá ãyĩkõ õnõ-võ kâ ꞌẽlé gólĩyí bê rî yã? Îcá kô âꞌdólé ĩtí lâ ꞌdĩ ró, tãlâ õdrógô bê gólĩyî lãfálé. ");
INSERT INTO avu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gõꞌdá ı̣̃zạ́tú rî, ı̣̃tú âꞌdô ậwúꞌá trá õdrógô trõzó vólé gólĩyî lãfálé sĩ. Gõꞌdá ı̣̃tú rî ꞌdĩ tú rî, gólĩyî âꞌdô rĩꞌá trá ꞌálé ꞌãꞌí ró ĩzã drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Úlı̣́ mãnĩgõ ãzâ bê rı̣̃ tã îmbâ óꞌdí ámákâ rî tãsĩ, gólĩyî rĩꞌá nõtí. Ólôsé ítá óꞌdí ró rî kô kpạ̃ạ́kũ ítá ạ̃kû ôsĩ ꞌbá trá rî rú, tãlâ ítá óꞌdí ꞌdĩ õzó ôró ânjólé vólé ítá ạ̃kû ꞌdĩ ũpı̣̃ lâ âyélé hõwéẽ ậvû-ậvû ró lậvũlı̣́ gạ̃rạ̃ sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Gõꞌdá âꞌdó kô tãndí ró õjílã ãzâ drí õdrá óꞌdí lôrózó mõrá gólâ ạ̃kû mbârâkã ãkó rî ꞌá. Gólâ õꞌê trá ĩtí rî, gõꞌdá õdrá õtírĩ ângá rî, mõrá ạ̃kû ꞌdĩ âꞌdô pı̣̃ꞌá, õdrá ꞌdĩ drí lâsózó vũdrı̣́ rû îzãlé. Ĩtí rî, órî õdrá óꞌdí lôrólâ mõrá gólâ tãndí ró rî ꞌá. Tã ꞌdî tãsĩ rî, âꞌdô rĩꞌá dódó cú ĩtí rû îzã ãkó. Ĩtí rî, îcá kô tã îmbâ óꞌdí ámákâ rî ônjálé lãꞌbí ạ̃kû rî bê.” ");
INSERT INTO avu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kậyı̣̂ rãtáã kâ sĩ, Yésũ yî lãjóꞌbá íyíkâ rî ꞌbá yí bê rĩꞌá ĩyî nĩꞌá kôrô ạ́mvú ạ̃drúgú lı̣̂njı̣́ ꞌbá trá rî kâ ꞌásĩ. Ạ́mvú rî ꞌdĩ ꞌá nĩngá rî, drílĩyî ngãzó rĩꞌá ạ̃drúgú vũlı̣́ rĩꞌá nyãlâ lõfó drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nĩngá sĩ, õjílã Pạ̃rúsı̣̃ kâ ârî ĩyî tã ꞌdî bê rî, drílĩyî ngãzó Yésũ rî îjílí kĩ nĩ rî, “Lãjóꞌbá áníkâ rî ĩyî cú ĩtí lãꞌbí ãmákâ rî ꞌdã ãkó ãꞌdô tãsĩ yã? Drílĩyî rĩzó rĩꞌá lôsĩ ꞌẽlé kậyı̣̂ rãtáã kâ rî sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Nĩngá sĩ, Yésũ drí ngãzó tã ꞌdî drı̣̃ lâ lôgõlé gólĩyî drí kĩ nĩ rî, “Nĩ zı̣́ tã kúmú ạ́ngı̣́ Dạ̃wúdı̣̃ rî tãsĩ búkũ Ôvârí kâ ꞌá rî kô yã? Ị̃tú Ãbĩyãtárã drí âꞌdózó drẽ ãmbá drı̣̃-ꞌbá lãꞌbí ꞌẽ ꞌbá rî ꞌbá yí kâ ró, gõꞌdá Dạ̃wúdı̣̃ yî drí âꞌdózó ạ̃jú ꞌbũ ꞌbá íyíkâ rî ꞌbá yí bê lõfó ró kôrô rî. Gõꞌdá drílĩyî ngãzó fĩlí jó Ôvârí kâ ꞌá ãmbãtã fẽlé trá ngá fẽfẽ ró Ôvârí drí rî nyãlé rî. Nĩ nı̣̃ trá tãndí ró kĩ nĩ rî, cé drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî ꞌbá yî áâyê ĩꞌdî ngá nyãnyã rî ꞌdĩ nyãlé. Ãꞌdô kpálé ĩtí rî, Dạ̃wúdı̣̃ yî nyâ ngá nyãnyã rî ꞌdĩ ạ̃jú ꞌbũ ꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. Gõꞌdá áâtá kô kĩ nĩ rî, gólĩyî lãꞌbí îzã ꞌbá ꞌî tã gólĩyî drí ꞌẽlé trá ꞌdĩ tãsĩ, tãlâ lõfó mbârâkã lậvũ kôrô tã lãꞌbí ꞌdã ꞌbá kâ rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nĩngá sĩ, Yésũ âtâ tã ãzâ kpá trá gólĩyî drí kĩ nĩ rî, “Ôvârí ꞌbã ı̣̃tú rãtáã kâ ꞌdĩ âꞌdólé õjílã drí lôvózó ꞌá lâ. Gõꞌdá ꞌbãá õjílã kô lãꞌbí kậyı̣̂ rãtáã kâ lậnjı̣̃ lâ trõlé. ");
INSERT INTO avu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mâ gólâ Ôvârí drí âjólé trá ûrú lésĩ rî, ĩꞌdî kậyı̣̂ rãtáã kâ drı̣̃lı̣́.” ");
INSERT INTO avu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kậyı̣̂ rãtáã kâ ãzâ sĩ, Yésũ yî drí ngãzó nĩlí fĩlí jó tã Ôvârí kâ ârî kâ rî ꞌálâ. Jó rî ꞌdĩ ꞌá tólâ rî, ãgô ãzâ bê rĩꞌá. Ãgô rî ꞌdĩ drı̣́ lâ rĩꞌá ôgô-ôgô ró. ");
INSERT INTO avu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Gõꞌdá Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá ãzâ ꞌbá yí bê kpá bê rĩꞌá ĩyî tólâ. Gólĩyî lẽ Yésũ rî ạ̃lı̣̃ âŋõlé tã õnjí ꞌbá ró. Gólĩyî rĩꞌá Yésũ rî mãndĩkã lôꞌbãꞌá ngãtá Yésũ rî âꞌdô ãgô gólâ drı̣́ lâ drí ôgólé ôgô ꞌdĩ pãꞌá yã rî, ãꞌdô kpálé kậyı̣̂ rãtáã kâ rî ĩꞌdî rî. ");
INSERT INTO avu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nĩngá sĩ, Yésũ drí ngãzó ãgô ꞌdĩ zı̣̃lı̣́ kĩ nĩ rî, “Ní ngâ ûrû, gõꞌdá ní ânĩ ró âdrélé õjílã lãfálé ꞌá nõlé.” Ĩtí rî, ãgô rî ꞌdĩ drí tã ꞌdî ꞌẽzó té ĩtí. ");
INSERT INTO avu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ꞌDĩî vósĩ rî, Yésũ drí ngãzó tã pẽlé õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, “Kậyı̣̂ rãtáã ꞌẽzó rî sĩ rî, tã mbı̣̂mbı̣̂ ꞌẽlé rî íyíkâ kó ãꞌdô ꞌî yã? Ĩtí rî, tã ꞌbãꞌbã ãmákâ ꞌẽlé rî ꞌbã ãmâ õjílã ꞌâ ậmúlı̣́ ngãtá ꞌâ ậmúlı̣́ kô yã? Tã ꞌbãꞌbã rî gógó ãlôlâ ãmákâ ꞌdĩ ꞌbã ãmâ bê õjílã pãlé ngãtá õjílã âyélé drãlé yã?” Nĩngá sĩ rî, õjílã ꞌdî ꞌbá yî drí rĩzó ĩyî njũrũ tã ꞌdî drı̣̃ lâ lôgõ ãkó. ");
INSERT INTO avu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Gõꞌdá ĩtí rî, Yésũ drí võ ndrẽzó gólĩyî drı̣̃ı̣̂ sĩ lı̣̃fı̣́ ı̣̂njı̣̂-ı̣̂njı̣̂ õmbã kâ rî sĩ. Gólâ gõꞌdá kpá ĩzã ró gólĩyî tãsĩ, tãlâ gólĩyî drı̣̃ rĩꞌá âmbâ-âmbâ ró ĩzã ngá lãzé ꞌbá kâ nı̣̃lı̣́. Ĩꞌdî ĩtí, Yésũ drí ngãzó tã pẽlé ãgô drı̣́ bê kõgõꞌdõ ꞌdî drí kĩ nĩ rî, “Ní êjẽ ánî drı̣́ ꞌdĩ, tãlâ ẽêjẽ ró rû bê mbı̣̂mbı̣̂ ró.” Nĩngá sĩ, ãgô ꞌdĩ drí tã ꞌdî ꞌẽzó té õzõ âtálé ꞌdĩ kâtí, gõꞌdá kôrô drı̣́ lâ ꞌdĩ drí rû êjẽzó âcálé mbı̣̂mbı̣̂ dódó. ");
INSERT INTO avu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tã rî ꞌdĩ vólé drı̣̃ lâ ꞌásĩ, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ngãzó nĩlí õjílã gólĩyî kúmú ạ́ngı̣́ zı̣̃lı̣́ Ẽródẽ rî kâ rî ꞌbá yî ngálâ nĩlí nĩꞌá tã ı̣̂ꞌbı̣̃lı̣́, ãꞌdô ró bê Yésũ rî fũzó vólé. ");
INSERT INTO avu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Tólâ sĩ, Yésũ yî drí ngãzó tã ârí ꞌbá íyíkâ rî ꞌbá yí bê nĩlí õjílã õꞌbí ꞌdĩ ꞌbá yî âyélé nĩzó lı̣̃mvû ândrê zı̣̃lı̣́ Gãlĩláyã rî tı̣́ ꞌálâ. Gõꞌdá õjílã dũû drí ânĩzó ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî lésĩ ꞌdẽlé gólĩyî vósĩ. Õjílã dũû ãzâ ꞌbá yî fî kpá dró dũû ꞌdẽlé gólĩyî vó, tãlâ gólĩyî ârî tã ạ́ngı̣́ Yésũ drí rĩꞌá ꞌẽlâ rî trá. Õjílã ãzâ ꞌbá yî ânĩ ĩyî ĩyíkâ Yẽrõsãlémã lésĩ, kpá võ ãzâ ꞌbá yî lésĩ Yũdạ́yạ̃ ꞌá. Ãzâ ꞌbá yî ânĩ ĩyî ꞌbạ̃drı̣̃ Ị̃dũmı̣́yạ̃ kâ rî lésĩ, ũrûkậ ꞌbá yî gõꞌdá ĩyíkâ kpá áyágá Jõrõdénĩ rî ꞌáꞌá lé drı̣̃ lâ lésĩ, gõꞌdá gólĩyî jạ̃rı̣́bạ̃ zı̣̃lı̣́ Tírã Sĩdónã bê rî gãrã drı̣̃ lâ lésĩ. ");
INSERT INTO avu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tãlâ õjílã ı̣́tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî tãsĩ rî, Yésũ drí ngãzó tã âtálé tã ârí ꞌbá íyíkâ rî ꞌbá yî drí kõlóngbõ mvá âsélé ãnyî mbãzó ꞌá lâ, õzó ĩyî íyî lôzé kô. ");
INSERT INTO avu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yésũ ꞌê ĩtí ró, tãlâ õjílã ngá lãzé ꞌbá ndrĩ ꞌdó rû fũꞌá ĩyî ânĩlí gólâ rî dõlé, tãlâ yĩ pâ ró ngá bê kpá ngá lãzé ĩyíkâ rî ꞌbá yî ꞌásĩ, tãlâ gólĩyî nı̣̃ trá kĩ, sı̣́sı̣́ Yésũ pâ õjílã ngá lãzé ꞌbá trá rõô. ");
INSERT INTO avu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Õjílã líndrí õnjí drí ômbélé rî ꞌbá yî tãsĩ, õzõ gólĩyî õtírĩ Yésũ rî ndrẽê rî, kôrô líndrí õnjí gólĩyíkâ ꞌdĩ drí gólĩyî lûvũzó ı̣̃nyạ́kú drı̣̃ı̣̂ ôtrê-ôtrê bê ûrû kĩ nĩ rî, “Nî ĩꞌdî Ôvârí rî mvá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yésũ drí tã ꞌbãzó líndrí õnjí ꞌdĩ ꞌbá yî drí, tãlâ gólĩyî õzó íyî tã lôfõô. ");
INSERT INTO avu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Nĩngá sĩ, Yésũ yî drí ngãzó tã ârí ꞌbá íyíkâ yí bê nĩlí únı̣́ ꞌálâ. ꞌDĩî vósĩ rî, drílâ ngãzó ãgô mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ yí drí lẽlé rî ꞌbá yî ậzı̣́lı̣́ âꞌdólé lãjóꞌbá íyíkâ ró. Gõꞌdá nĩngá sĩ, drílĩyî ngãzó ânĩlí gólâ ngálâ. Gólâ njĩ gólĩyî ꞌdĩ, tãlâ gólĩyî õrî ró bê yí bê, gõꞌdá kpá tãlâ yí lâjô ró gólĩyî bê nĩlí úlı̣́ íyíkâ pẽ bê, ");
INSERT INTO avu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","gõꞌdá gólĩyî ãꞌdô ró bê cú mbârâkã drı̣́-ãcê kâ bê líndrí õnjí lâdrózó õjílã gólĩyî líndrí õnjí drí ômbélé rî ꞌbá yî ꞌásĩ, tãlâ líndrí õnjí ãâfõ ró vólé gólĩyî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nõô yî rĩꞌá ãgô Yésũ drí njĩlí mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yî rú lâ yî ĩꞌdî, Sĩmónã gólâ drí zı̣̃lı̣́ kpá Pétẽrõ rî, ");
INSERT INTO avu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zẽbẽdáyõ rî mvá yî Yãkóbã yî Yõwánĩ bê gólĩyî Yésũ drí rú lâ yî zı̣̃lı̣́ kpạ̃rạ̃tı̣́ “‘Mõgbárá Mvá”’ rî, ");
INSERT INTO avu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Gólâ njĩ kpá Ãndĩríyã, Fílĩpõ, Bãtõlõméyõ, Mãtáyõ, Tómã, Yãkóbã Ãlõpáyã rî mvá, Tãdéyõ, Sĩmónã gólâ fĩ ꞌbá õmã ꞌá õmbã ꞌẽlé ꞌbạ̃drı̣̃ tãsĩ rî ĩꞌdî, ");
INSERT INTO avu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","gõꞌdá Yúdạ̃ Ĩsĩkãrĩyótã gólâ ꞌẽ ꞌbá Yésũ rî gĩlí fũlı̣́ rî. ");
INSERT INTO avu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ꞌDĩî vósĩ, Yésũ yî drí ngãzó nĩlí tã ârí ꞌbá íyíkâ yí bê gõlé ꞌbã ĩyî drí rĩzó rî ꞌálâ. Gólĩyî cãcã gõlé ꞌbã ꞌálâ rî vósĩ, õjílã drí rû êꞌbézó óꞌdí ngbạ̃ꞌũ dîrî Yésũ yî rú sĩ lậvũlı̣́ kôrô, tãlâ Yésũ yî õzó îcá nyãsá nyãlé kô. ");
INSERT INTO avu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tã Yésũ drí rĩꞌá ꞌẽlâ ꞌdĩ drí lûꞌúzó áró lâ yî bı̣́lı̣́, gõꞌdá drílĩyî ngãzó ânĩlí, tãlâ yĩ õtrõ ró gólâ bê vólé, tãlâ áâtâ trá ókĩ nĩ rî, “Yésũ ãꞌdô õjílã lîfõ ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gõꞌdá kpá lãꞌbí îmbá ꞌbá ãzâ ꞌbá yî ânĩ ꞌbá ĩyî Yẽrõsãlémã lésĩ rî, ânĩꞌá tã Yésũ kâ rĩꞌá ꞌẽlâ rî ꞌbá yî ndrẽlé ĩyî lı̣̃fı̣́ sĩ, âtâ ĩyî tã mbârâkã Yésũ kâ rî tãsĩ kĩ nĩ rî, “Sãtánã õfẽ mbârâkã nĩ Yésũ drí. ꞌDĩî kúmú líndrí õnjí kâ rî nĩ rĩꞌá mbârâkã fẽlé drílâ líndrí õnjí lâdrózó ĩꞌdî sĩ lâ vólé õjílã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gõꞌdá ĩtí, Yésũ ârî tã ꞌdî bê rî, drílâ ngãzó gólĩyî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî ậzı̣́lı̣́ yí ngálâ. Nĩngá sĩ, drílâ ngãzó rĩlí tã âtálé gólĩyî drí kĩ nĩ rî, “Ĩtí rî, Sãtánã âꞌdô îcáꞌá íyî nyãányâ drõlé vólé õjílã ꞌásĩ ꞌdî ángô tí ró yã? Tã ı̣̂sũ ãníkâ ámâ tãsĩ ányâ ró. ");
INSERT INTO avu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tã âꞌdálâ bê rı̣̃: Õzõ ꞌbã-tı̣̂ õrî rû lônyĩ-lônyĩ ró ạ̃wạ̃ ꞌẽlé rî, ꞌbã-tı̣̂ rî ꞌdĩ îcá kô âdrélé ạ̃wạ̃ ꞌdî ꞌẽlé té õzõ gólĩyî drí fĩî ômbérẽ ãlô rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Gõꞌdá kpá õzõ õjílã ạ̃ꞌdı̣́-drı̣̃ ãlô rî kâ õlônyĩ ĩyî lãfálé lônyĩ-lônyĩ rû fũzó ãzí-ãzí bê rî, ꞌdĩî ạ̃ꞌdı̣́-drı̣̃ ꞌdî njãá kô zı̣̃ rû fũfũ rî ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kpá ĩtí ró, õzõ Sãtánã õfẽ fí mbârâkã trá má drí líndrí õnjí drõzó rî, ꞌdĩî gólâ ngâ trá ạ̃jú ꞌbũlı̣́ íyî nyãányâ bê gõꞌdá gólâ rĩꞌá rû lônyĩ-lônyĩ ró, gõꞌdá gólâ âꞌdô mbârâkã gólâkâ îzãꞌá ꞌwãâ. ");
INSERT INTO avu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Gõꞌdá mĩ nı̣̃ trá, ũgú îcá kô fĩlí jó õjílã gólâ fãfã bê rî kâ ꞌá cú ĩtí õjílã rî ꞌdĩ ômbé ãkó njírí-njírí. Îcá trá fãfã õjílã ꞌdî kâ drí âꞌdólé lậvũlı̣́ kôrô fãfã ꞌbã lı̣́pı̣̂ ꞌdĩ kâ drı̣̃ı̣̂ sĩ. Õzõ óõômbê gólâ trá rî, ũgú drí gõzó fí fĩlí ngá ꞌẽꞌá ûgũlâ rî ûgũlı̣́. Ĩtí rî, fãfã ámákâ lậvũ trá kôrô fãfã Sãtánã kâ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nõô má âtâ tã pạ̃tı̣́-pạ̃tı̣̃ ꞌî ãnî drí, tã tı̣̂ õnjí õjílã úlı̣́ âtá ꞌbá õnjí Ôvârí rú rî, âꞌdô îcáꞌá cú Ôvârí drí tã õnjí gólĩyíkâ ꞌdĩ ꞌbá yî âyélé. ");
INSERT INTO avu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gõꞌdá õjílã úlı̣́ õnjí âtá ꞌbá Líndrí Tãndí Ôvârí kâ rú rî, îcá kô tã õnjí gólĩyíkâ âyélé ãlôwálâ. Gõꞌdá âꞌdô íyíkâ lậnjı̣̃ tã õnjí ꞌdĩ kâ njı̣̃ꞌá zãâ bạ̃dı̣̃ ạ̃dũkũ ãkó.” ");
INSERT INTO avu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yésũ âtâ úlı̣́ ꞌdĩ ĩtí, tãlâ õjílã ꞌdî ꞌbá yî ꞌê ꞌdásí trá Líndrí Tãndí Ôvârí kâ rú úlı̣́ gólĩyíkâ sĩ kĩ nĩ rî, Yésũ âꞌdô líndrí õnjí zẽlé. ");
INSERT INTO avu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","ꞌDĩî õjílã dũû trá rĩꞌá ĩyî dîrî gbãâ Yésũ rú sĩ. Nĩngá sĩ rî, Yésũ rî ândré gõꞌdá Yésũ rî ậdrúpı̣̃ yí bê drí âcázó. Gólĩyî âcâ bê rî, drílĩyî rĩzó tãkõ ĩví ꞌálâ, tãlâ îcá kô gólĩyî drí âcázó fĩlí kôrô jó ꞌálâ õjílã õꞌbí ꞌdĩ ꞌbá yî tãsĩ. Gõꞌdá drílĩyî tã âtízó jó ꞌálâ Yésũ drí, Yésũ rî ậzı̣́lı̣́ ânĩlí ĩyî ngálâ ĩví ꞌálâ. Nĩngá sĩ, õjílã rĩ ꞌbá jó ꞌálâ ꞌdĩ ꞌbá yî drí tã âtázó Yésũ drí kĩ nĩ rî, “Ní ndrê drẽ, ánî ândré ánî ậdrúpı̣̃ yí bê rĩꞌá ĩyî ĩví ꞌálâ, gõꞌdá gólĩyî lẽ nî âfõlé ĩyî ngálâ.” ");
INSERT INTO avu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nĩngá sĩ, Yésũ drí ngãzó tã lôgõlé kĩ nĩ rî, “Ámâ ândré ámâ ậdrúpı̣̃ yí bê ĩyíkâ ãꞌdî ĩꞌdî yã? Õjílã ãzâ ꞌbá yî kpá ámâ áró ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ĩtí, drílâ ngãzó võ ndrẽlé dîrî õjílã rĩ ꞌbá pạ̃rạ̃-pạ̃rạ̃ gólâ rú sĩ gbãâ ꞌdĩ ꞌbá yî drı̣̃ı̣̂ sĩ, gõꞌdá drílâ tã âtázó kĩ nĩ rî, “Nĩ ndrê, nõô ámâ ândré yî ĩꞌdî ámâ ậdrúpı̣̃ yí bê ámâ îzó yí bê. ");
INSERT INTO avu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gólĩyî tã Ôvârí drí lẽlé rî ꞌẽ ꞌbá rî, gólĩyî rĩꞌá ámâ ậdrúpı̣̃ yî ĩꞌdî, ámâ îzó yî ĩꞌdî, ámâ ândré yî ĩꞌdî. Má lẽ gólĩyî rõô.” ");
INSERT INTO avu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nĩngá sĩ, Yésũ drí ngãzó kpá óꞌdí rĩꞌá lậmúlı̣́ lı̣̃mvû ândrê Gãlĩláyã kâ rî tı̣́ sĩ. Nĩngá sĩ, drílâ ngãzó rĩꞌá õjílã îmbálé. Õjílã tı̣́lı̣́lı̣́ drí âvázó mậndrı̣̃ dũû. Tãlâ õjílã õꞌbí ꞌdĩ ꞌbá yî lôzê rû trá ãnyî Yésũ rú, Yésũ drí ngãzó mbãlé cú kõlóngbõ ꞌá nĩlí lı̣̃mvû ꞌálâ fínyáwá, drílâ gõzó rĩlí kõlóngbõ ꞌdî ꞌá. ꞌDĩî õjílã ãmbá âvá ꞌbá rû êꞌbélé ngbạ̃ꞌũ ꞌdî ꞌbá yî rî ĩyíkâ gõlé ángálángâ drı̣̃lı̣́ lésĩ ró. ");
INSERT INTO avu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ĩtí, Yésũ drí rĩzó rĩꞌá tã âꞌdálé gólĩyî drí úlı̣́ mãnĩgõ sĩ. Úlı̣́ mãnĩgõ ãlô sĩ rî, drílâ ngãzó tã âtálé nõtí, ");
INSERT INTO avu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nĩ ârî drẽ úlı̣́ má drí ꞌẽꞌá âtálâ ãnî drí nõ. Ị̃tú ãzâ sĩ, ạ́mvú ꞌwã ꞌbá ngâ trá nĩlí órĩ rĩlí yí drí ạ́mvú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Gõꞌdá gólâ rî bê rĩꞌá órĩ ꞌdî rĩlí rî, órĩ ãzâ ꞌbá yî lôngâ lôꞌdélé gĩâ pávó ꞌá ẽsê-drı̣̃. Ĩtí rî, ãríwá drí âꞌdézó ûꞌdúlâ nyãlé vólé. ");
INSERT INTO avu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Nĩngá sĩ, gõꞌdá órĩ ãzâ ꞌbá yî lôꞌdê ĩyíkâ ı̣̃nyạ́kú âꞌdó ꞌbá rõvõ drı̣̃ı̣̂ rî ꞌá. Ĩtí rî, ı̣̃nyạ́kú rî ꞌdĩ âꞌdó kô njı̣̃njı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Gõꞌdá ngá-ạ̃rú drí âfõzó mbãlé ꞌwãâꞌwâ. Lé ĩtí rî, õzõ ı̣̃tú ãâcâ trá lété-lété lâ ꞌá rî, ngá-ạ̃rú âfõ ꞌbá trá ꞌdĩ âꞌdô ândráꞌá vẽlé vólé háwô, tãlâ índrĩgó lâ yî fí drẽ kô dódó ı̣̃nyạ́kú ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Gõꞌdá órĩ ífí ũrûkậ ꞌbá yî ꞌdê ĩyíkâ ãsõpá kãrãnyã rî ꞌá. Nĩngá sĩ, ãsõpá rî ꞌdĩ drí lı̣̂pı̣̃zó ạ́ngı̣́ ró, gõꞌdá drílâ ngá-ạ̃rú âfõ ꞌbá ꞌdĩ ûfúzó tílílí ngá ífí ãzâ ûsú ãkó ngá-ạ̃rú ꞌdĩ ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gõꞌdá nĩngá sĩ, órĩ ãzâ ꞌbá yî lôngâ ꞌdẽlé ĩyíkâ ı̣̃nyạ́kú tãndí drı̣̃ı̣̂, gõꞌdá drílĩyî mbãzó tãndí ró lõꞌwâ ꞌwãlé cõkpõ-cõkpõ. Gõꞌdá ãzâ ꞌbá yî drí lõꞌwâ ꞌwãzó ândâlâ nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́, gõꞌdá ãzâ ꞌbá yî õzõ ândâlâ nyâꞌdî-nâ kâtí, nĩngá sĩ, ãzâ ꞌbá yî ĩyíkâ ândâlâ nyâꞌdî-njı̣̂ kâtí.” ");
INSERT INTO avu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ãꞌdô trá ĩtí, Yésũ drí úlı̣́ mãnĩgõ íyíkâ vó lâ âtízó õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, “Gõꞌdá õzõ nĩ ãârî tã bê rî, ꞌdõvó nĩ ârî úlı̣́ ꞌdĩ ꞌbá yî dódó ꞌbãlé ãnî drı̣̃.” ");
INSERT INTO avu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Gõꞌdá ꞌdĩî vósĩ, Yésũ yî lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yí bê õtírĩ rĩî rĩlí õjílã ũrûkậ ꞌbá yí bê ĩyî drı̣̃ı̣̂ sĩ rî, lãjóꞌbá rî ꞌdĩ ꞌbá yî õjílã ũrûkậ ꞌdĩ ꞌbá yí bê drí ngãzó Yésũ rî îjílí, ãꞌdô ró bê gólâ drí úlı̣́ mãnĩgõ ífí gólâ drí âtálé trá ꞌdĩ lôfõzó ĩyî drí trạ̃ậtrậ. ");
INSERT INTO avu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bê trá ĩtí rî, Yésũ drí ngãzó tã-drı̣̃ lôgõlé gólĩyî drí kĩ nĩ rî, “Ạ̃kû ró Ôvârí âꞌdá tã kô ngbálí-ngbálí õjílã drí pávó yí drí õjílã ꞌbãzó âꞌdólé õjílã íyíkâ ró rî tãsĩ. Gõꞌdá ngbãângbânõ, má âꞌdô âꞌdáꞌá lâ ngbálí-ngbálí ãnî drí. Gõꞌdá õjílã gólĩyî lẽ ꞌbá kô Ôvârí rî nı̣̃lı̣́ rî ꞌdĩ ꞌbá yî tãsĩ, nõô má rã tã trá ãkí ãkó gólĩyî drí úlı̣́ mãnĩgõ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tã rî ꞌdĩ âꞌdô âꞌdóꞌá, õzõ tã ậngũ ꞌbá drí îgĩlí trá gólĩyî tã lẽlẽ ãkó rî tãsĩ ạ̃kû ró ạ̃kû ró nã sĩ rî kâtí. ‘Ĩtí rî, gólĩyî âꞌdô tã Ôvârí kâ ndrẽꞌá té ĩyî lı̣̃fı̣́ sĩ cú ĩtí ĩtõ lâ nı̣̃ ãkó. Gõꞌdá gólĩyî âꞌdô kpá Ôvârí rî gbórókõ âríꞌá ĩyî bı̣́ sĩ cú ĩtí tã ífí lâ nı̣̃ ãkó. Õzõ gólĩyî õndrê tã ꞌdî trá ârî-ârî lâ bê rî, gólĩyî drí gõzó drı̣̃ âjálé tã õnjí ĩyíkâ ꞌásĩ, tãlâ õgõ ró bê tã õnjí ĩyíkâ ꞌdĩ âyélé ĩyî drí.’ ” ");
INSERT INTO avu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bê trá ĩtí rî, Yésũ drí ngãzó lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî îjílí kĩ nĩ rî, “Tã ífí úlı̣́ mãnĩgõ ı̣̃nyạ́kú tı̣̂ lârâkô tãsĩ ꞌdî fî trá ãnî drı̣̃ yã? Õzõ gõꞌdá óõfî ãnî drı̣̃ı̣̂ kôꞌdáwá rî, nĩ âꞌdô îcáꞌá gõꞌdá ángô tí ró úlı̣́ mãnĩgõ ãzâ ꞌbá yî tã ífí lâ yî nı̣̃lı̣́ yã? ꞌDõvó bê trá ĩtí rî, úlı̣́ mãnĩgõ lâ tã ífí lâ ĩꞌdî nõtí. ");
INSERT INTO avu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Órĩ rĩrĩ ꞌdî rĩꞌá õzõ tã âtî-âtî Ôvârí kâ pẽrẽ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gõꞌdá õjílã ãzâ ꞌbá yî tãsĩ rî, âꞌdô trá õzõ órĩ gólâ lôngá ꞌbá ꞌdẽlé pávó ꞌá ẽsê-drı̣̃ rî kâtí. Õzõ áãâtâ tã âtî-âtî Ôvârí kâ trá gólĩyî drí rî, gólĩyî ı̣̂njı̣̃ı̣́ kô, tãlâ kôrô Sãtánã âtrõꞌá lâ vólé gólĩyî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Gõꞌdá úlı̣́ ꞌdĩ ârí ꞌbá ãzâ ꞌbá yî tãsĩ rî, gólĩyî ĩyíkâ âꞌdóꞌá õzõ órĩ gólâ lôngá ꞌbá ꞌdẽlé ı̣̃nyạ́kú gólâ rõvõ drı̣̃ı̣̂ rî ꞌá rî kâtí. Gólĩyî ꞌdĩ ꞌbá yî ârî ĩyî tã âtî-âtî Ôvârí kâ trá rî, gõꞌdá drílĩyî trõzó lâ ꞌwãâ ãyĩkõ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gõꞌdá gólĩyî rĩꞌá õzõ ngá-ạ̃rú índrĩgó lâ drí fĩlí kôꞌdáwá rî tí, gólĩyî rî cé fínyáwá ĩtí tã lẽlẽ sĩ Ôvârí ꞌá. Gõꞌdá nĩngá sĩ, õzõ lâŋõ ꞌdíyî ûfû kâ ãâꞌdê trá gólĩyî drı̣̃ı̣̂ tãlâ tã âtî-âtî ꞌdĩ tãsĩ rî, gólĩyî drí âyézó lâ kôrô ꞌwãâ. ");
INSERT INTO avu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gõꞌdá õjílã ãzâ ꞌbá yî tãsĩ rî, ĩyíkâ õzõ órĩ gólâ lôngá ꞌbá ꞌdẽlé ãsõpá kãrãnyã rî lãfálé ꞌá rî kâtí. Gólĩyî ꞌdĩ ꞌbá yî ârî ĩyíkâ fí tã âtî-âtî Ôvârí kâ trá. ");
INSERT INTO avu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Gõꞌdá gólĩyî rĩꞌá pı̣̃pı̣̂sı̣́lı̣́ bê rı̣̃, tãlâ tã ı̣̂sũ ngá ãngó nõ kâ rî kâ fî trá gólĩyî ꞌá, ngãtá gólĩyî âyê lãfâ trá ĩyî âdólé, gólĩyî lẽ âꞌdólé cú ngá-tı̣̂ bê dũû. Tã ꞌdî ꞌbá yî tãsĩ rî, tã âtî-âtî ꞌdĩ gõꞌdá já gólĩyî kô Ôvârí rî rõlé dódó. ꞌDĩî rĩrĩ gólĩyíkâ rî rĩꞌá cú ĩtí lõꞌwâ ãkó. ");
INSERT INTO avu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nĩngá sĩ, õjílã ãzâ ꞌbá yî kpá bê rĩꞌá ĩyî õzõ órĩ gólâ lôngá ꞌbá ꞌdẽlé ı̣̃nyạ́kú tãndí drı̣̃ı̣̂ rî kâtí. Gólĩyî rĩꞌá pı̣̃pı̣̂sı̣́lı̣́ ãlô bê, gõꞌdá gólĩyî ârî ĩyíkâ tã âtî-âtî Ôvârí kâ gõzó kpá tã-drı̣̃ lâ lẽlé, gõꞌdá kpá lõꞌwâ lâ lôfõzó rĩrĩ gólĩyíkâ tãndí rî sĩ, ândâlâ nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́, nyâꞌdî-nâ, gõꞌdá kpá nyâꞌdî-njı̣̂, gạ̃rạ̃ órĩ gólâ tíbê rĩlí trá rî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Drẽ Yésũ zãâ rĩꞌá úlı̣́ pẽꞌá õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí rî, drílâ kpá tã âtázó kĩ nĩ rî, “Õzõ õjílã ãzâ ĩîꞌĩ lámbã íyíkâ trá ngạ́cı̣̂ sĩ rî, gólâ trõ fí bê ꞌbãlé gõzó drı̣̃ lâ âkólé límvó sĩ yã? Ĩtí rî, gólâ âꞌdô trõꞌá lâ lậpı̣́lı̣́ gbãrãkã íyíkâ zẽlé yã? ꞌDĩî îcá kô âꞌdólé ĩtí lâ ꞌdĩ ró. Gólâ trõ lámbã rî ꞌdĩ ꞌbãlé gá tãrãbízã drı̣̃ı̣̂, tãlâ võ îwálé. ");
INSERT INTO avu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Õzõ lámbã drí âꞌdórẽ kâtí, tã âtî-âtî pạ̃tı̣́ı̣̃ lậpı̣́lı̣́ ngbãângbânõ rî, îcá trá âtrõlâ âꞌdálé ndrĩ lı̣̃fı̣́ drı̣̃ ꞌá ı̣̃zạ́tú. Gõꞌdá îcâ kpá trá õjílã drí tã îmbâ-îmbâ ámákâ nı̣̃lı̣́ ı̣̃zạ́tú. ");
INSERT INTO avu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Õzõ ãnî ãꞌdô bı̣́ bê rî, nĩ ârî tã ꞌdî tãndí ró.” ");
INSERT INTO avu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã âtázó gólĩyî drí kĩ nĩ rî, “Nĩ îgâ bı̣́ dódó tã má drí âtálé ãnî drí nõ ârízó. Ĩtí rî, nĩ âꞌdô Ôvârí rî nı̣̃ꞌá dódó. Õzõ nĩ ãârî tã trá dódó ꞌẽlé rî, nĩ âꞌdô tã nı̣̃ꞌá Ôvârí rî tãsĩ kpá dódó lậvũlı̣́ kôrô. ");
INSERT INTO avu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Õzõ nĩ ĩîcâ trá tã Ôvârí kâ rî ꞌbá yî ârílí rî, ꞌdĩî âꞌdô ãnî ꞌbãꞌá tã gólâkâ rî ꞌbá yî ârílí kôrô. Õzõ nĩ õgã trá ârílâ rî, tã nı̣̃nı̣̃ tã Ôvârí kâ rî ꞌbá yî tãsĩ rî âꞌdô ậvı̣̃ꞌá ãnî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nĩngá sĩ, Yésũ âtâ úlı̣́ mãnĩgõ ãzâ kpá kĩ nĩ rî, “Ôvârí ꞌê õjílã kó ángô tí ró âꞌdólé õjílã íyíkâ ró yã? ꞌDĩî âꞌdô õzõ órĩ mbã ꞌbá rî kâtí. Õjílã ngâ órĩ rĩlí ĩꞌdî sı̣́sı̣́ yí drí ạ́mvú ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ꞌDĩî vósĩ, õjílã rî ꞌdĩ drí rĩzó ậꞌdú kõlé ngạ́cı̣̂ vósĩ cé, gõzó ngãlé rĩꞌá ngá ꞌẽꞌẽ ãzâ ꞌẽlé cı̣̃ı̣́nó vósĩ kpá cé. Gólâ õtírĩ rĩî ngá ãzâ ꞌbá yî ꞌẽlé rî, órĩ ꞌdî drí võ lûtúzó ĩvĩ mbãlé. ꞌDĩî gólâ nı̣̃ı̣́ kô kĩꞌá nĩ rî, ngá rî ꞌdĩ ꞌê rû ĩtí ꞌdĩ ángô tí ró yã. ");
INSERT INTO avu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ôzê ꞌê órĩ nĩ võ lûtúlı̣́ cú ĩtí. Sı̣́sı̣́ ngá-ạ̃rú pá fã âfõ nĩ mbãlé, vó lâ ꞌásĩ, drílâ ngãzó fõô ꞌbãlé, gõꞌdá lı̣̃fı̣́ lâ drí lı̣̂njı̣́zó drı̣̃ lâ ꞌá ạ̃dũkũ lâ ró. ");
INSERT INTO avu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Õzõ ạ̃drúgú ũlı̣̂njı̣̂ trá rî, gõzó tõlâ vũdrı̣́, ꞌdĩî trá tı̣̂ lâ îtónãrẽ ꞌî ạ́mvú lı̣́pı̣̂ drí.” ");
INSERT INTO avu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","31","Yésũ îjî kpá õjílã, gólâ kĩ nĩ rî, “Lạ́tı̣̂ gólâ Ôvârí drí ꞌẽzó õjílã dũû ꞌbãlé lîzólé âꞌdólé õjílã íyíkâ ró rî rĩꞌá õzõ ãꞌdô tã kâtí yã? ꞌDĩî rĩꞌá õzõ ãgô ãzâ gólâ líꞌbá ífí ı̣̂ꞌdı̣́ ꞌbá ạ́mvú íyíkâ ꞌá rî kâtí. Líꞌbá ífí rĩꞌá cíkírĩnyáwá ĩtí. ");
INSERT INTO avu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Õzõ ãꞌdô kpálé ĩtí lâ ꞌdĩ kâtí rî, õzõ ı̣́ı̣̃ı̣̂ꞌdı̣̂ líꞌbá ífí rî ꞌdĩ trá rî, drílâ âfõzó mbãlé fê ândrê ró gạ̃rạ̃ cú gárá bê ngbũkpũ ãríwá drí rĩzó ꞌdẽlé lôvólé drı̣̃ lâ ꞌá. Âꞌdô âꞌdóꞌá kpá ĩtí õjílã dã gólĩyî rĩ ꞌbá ámâ vó lôbẽlé rî ꞌbá yî drí, gólĩyî âꞌdô ꞌẽꞌá lîzólé dũû ĩtí ı̣̃zạ́tú.” ");
INSERT INTO avu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yésũ ngî íyî tı̣̂-võ õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí kpá úlı̣́ mãnĩgõ ãzâ ꞌbá yî sĩ õzõ drílâ ngĩlí ꞌdĩ ꞌbá yí kâtí. Gólâ ngî úlı̣́ mãnĩgõ ꞌdî ꞌbá yî tã nı̣̃nı̣̃ õjílã ꞌdî ꞌbá yí kâ vó ró. ");
INSERT INTO avu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gólâ ngî tã õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí cé úlı̣́ mãnĩgõ sĩ cú ĩtí ĩtõ lâ yî lôfõ ãkó. Gõꞌdá õzõ gólĩyî ãꞌdô trá ĩyî drı̣̃ı̣̂ sĩ tã ârí ꞌbá íyíkâ bê rî, drílâ tã ꞌdî ꞌbá yî ĩtõ lâ lôfõzó ndrĩ tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lạ̃njạ́túlı̣́ bê kpá ı̣̃tú rî ꞌdĩ sĩ, Yésũ drí ngãzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ꞌdê mã ngâ ró nĩlí lı̣̃mvû ândrê mbãlé ꞌáꞌá tólâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ĩtí, lãjóꞌbá rî ꞌdĩ ꞌbá yî drí ngãzó mbãlé fĩlí kõlóngbõ Yésũ drí âꞌdózó ꞌá lâ ꞌdĩ ꞌá. ꞌDĩî gólĩyî âyê õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî trá ãkpãkãꞌdã ꞌáꞌá lé drı̣̃ ãzâ lésĩ rî ꞌá, drílĩyî gõzó Yésũ rî âjílí kõlóngbõ sĩ ꞌáꞌá ꞌálâ. ꞌDĩî gõꞌdá kõlóngbõ ãzâ ꞌbá yî kpá bê kpãâ gólĩyî vó. ");
INSERT INTO avu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nĩngá sĩ, Yésũ yî õtírĩ rĩî lı̣̃mvû ândrê ꞌdĩ mbãlé kõlóngbõ sĩ rî, nyĩî ró, kạ̃gũmạ́ạ̃ drí ngãzó vı̣̃lı̣́ õnjí lâ ró. Drílâ lı̣̃mvû drı̣̃ ônjázó kpũrú-kpũrú kõlóngbõ drí rĩzó rû îkándãlé ngãâlõ-ngãâlõ. Gõꞌdá lı̣̃mvû drí fĩzó kõlóngbõ ꞌá ꞌẽꞌá kõlóngbõ îcálé dũû. ");
INSERT INTO avu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ꞌDĩî Yésũ bê rĩꞌá ậꞌdú kõꞌá vólé lésĩ kõlóngbõ rî ꞌdĩ ꞌá. Gólâ ꞌbã íyî drı̣̃ gá ngá drı̣̃-ậdrı̣̃ kâ drı̣̃ı̣̂. Nĩngá sĩ, lãjóꞌbá gólâkâ rî ꞌbá yî drí ânĩzó gólâ rî ôlólé kĩ nĩ rî, “Wáâwá, lı̣̃fı̣́ îcí ꞌbá, ní pâ ãmâ, tí nõtí nõ lı̣̃mvû ûfû ãmâ trá ngbá cú ĩtí ní drí võ lâ ûsú ãkó. Ĩtí rî, ãmâ tã njı̣̃ı̣́ ní drı̣̃ı̣̂ kô, õzõ mã õdrã trá rî yã? Ní ndré lâŋõ ãmâ drí âꞌdózó ꞌá lâ nõ kô yã?” ");
INSERT INTO avu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ĩtí rî, Yésũ drí ngãzó tã âtálé kạ̃gũmạ́ạ̃ ꞌdĩ drí âdrézó tı̣́ı̣́. Gólâ kĩ nĩ rî, “Kạ̃gũmạ́ạ̃, ní âdrê tı̣́ı̣́. Lı̣̃mvû, ní âdrê.” Gõꞌdá ĩtí kôrô kạ̃gũmạ́ạ̃ drí âdrézó, võ ạ̃yı̣́ drí vı̣̃zó yĩî, kpá lı̣̃mvû drí âdrézó lẽẽ. ");
INSERT INTO avu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nĩngá sĩ, Yésũ drí ngãzó tã âtálé lãjóꞌbá íyíkâ drí kĩ nĩ rî, “Ãnî ũrı̣̃ ró ãꞌdô tãsĩ yã? Tã lẽlẽ ãníkâ má ꞌá rî âꞌdô drẽ cé fínyáwá ĩtí ãꞌdô tãsĩ yã? Má âꞌdô ãnî ậtı̣̃ꞌá gạ́gạ́.” ");
INSERT INTO avu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ĩtí rî, gõꞌdá lãjóꞌbá gólâkâ drí ngãzó rĩꞌá gólâ rî rõlé kôrô, tãlâ gólâ rî mbârâkã tãsĩ. Nĩngá sĩ, gólĩyî drí tã âtázó ĩyî lãfálé ꞌásĩ kĩ nĩ rî, “Ãgô rî nõ íyíkâ cú rĩꞌá mbârâkã Ôvârí kâ bê! Ĩꞌdî kạ̃gũmạ́ạ̃ gõꞌdá lı̣̃mvû bê drí tã gólâkâ ârízó nõ!” ");
INSERT INTO avu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tã ꞌdî ꞌbá yî vósĩ, Yésũ yî lãjóꞌbá íyíkâ âꞌdó ꞌbá kõlóngbõ ꞌá rî ꞌbá yí bê drí ngãzó lı̣̃mvû ândrê zı̣̃lı̣́ Gãlĩláyã rî mbãlé ꞌáꞌá ãzâ rî lésĩ. Drílĩyî cãzó võ tãkó ꞌálâ Gẽrãgésã rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Drẽ gólĩyî õtírĩ rĩî âfõlé kõlóngbõ ĩyíkâ ꞌásĩ rî, drílĩyî ãgô ãzâ ûsúzó, líndrí õnjí ạ̃bạ̃bạ̃ kâ Sãtánã vá lésĩ rî ômbê gólâ trá vũdrı̣́. Ãgô rî ꞌdĩ ngâ trá rãlé ũndú ró Yésũ ngálâ ũgı̣́ ꞌásĩ cãlé Yésũ rî ûsúlı̣́. ");
INSERT INTO avu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Gólâ ânĩ trá rĩlí lóꞌdé ũgı̣́ ró rî yî lãfálé ꞌá ạ̃kû ró. Õjílã rî trá rĩꞌá gólâ rî ômbélé nyãrĩ yî sĩ ândâlâ dũû. Ãꞌdô kpálé ĩtí rî, ı̣̃tú vósĩ cé, õzõ óõômbê gólâ trá rî, gólâ drí rĩzó nyãrĩ ꞌdî ꞌbá yî ôkílí tú tú vólé. Ĩtí rî, îcá gõꞌdá kô gólâ rî ômbézó, ãꞌdô kpálé ômbélé nyãrĩ sĩ rî. Õjílã ãzâ ꞌbá yî mbârâkã lâ îcá kô gólâ rî ậtũzó. ");
INSERT INTO avu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gólâ rî trá lậmúlı̣́ ı̣̃tú kárá ngạ́cı̣̂ gı̣̃rı̣̃ lóꞌdé ũgı̣́ ró rî ꞌbá yî lãfálé sĩ gõꞌdá kpá kúnı̣́ lãfálé sĩ. Gólâ rî kárá rĩꞌá ôtrélé gõꞌdá kpá rĩꞌá íyî ậdı̣̃lı̣́ kúnı̣́ mvá sĩ, tãlâ yí ũûsû ró lãzé bê. Ĩzã ꞌê gólâ kó trá rõô. ");
INSERT INTO avu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Rû ûsû-ûsû ãgô rî ꞌdĩ kâ Yésũ bê rî âꞌdô trá nõtí. Gólâ ndrê Yésũ bê rî, drílâ ngãzó nĩꞌá Yésũ ngálâ. Gõꞌdá gólâ câ bê Yésũ ngálâ rî, drílâ ngãzó ꞌdẽlé ꞌãꞌî drı̣̃ı̣̂ Yésũ ândrá rúꞌbạ́ lôꞌbãlé gólâ drí. ");
INSERT INTO avu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ĩtí, Yésũ ndrê ãgô rî ꞌdĩ bê rî, Yésũ drí ngãzó tã âtálé líndrí õnjí ạ̃bạ̃bạ̃ kâ gólâ ꞌá ꞌdĩ drí kĩ nĩ rî, “Líndrí õnjí, ní âfõ vólé ãgô nõ ꞌásĩ.” Gõꞌdá nĩngá sĩ, ãgô rî ꞌdĩ drí ngãzó trẽlé ûrû kĩ nĩ rî, “Yésũ, Ôvârí ãmbá rî mvá, ní lẽ ãꞌdô ngá ꞌî má drı̣́gạ́ sĩ yã? Má lôꞌbã rúꞌbạ́ ní drí Ôvârí rî rú sĩ, ní îkpókpólõ ãmâ kôꞌdáwá.” ");
INSERT INTO avu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ĩtí, Yésũ drí ngãzó gólâ rî îjílí kĩ nĩ rî, “Ánî rú ãꞌdî ĩꞌdî yã?” Gõꞌdá nĩngá sĩ, ãgô rî ꞌdĩ drí tã-drı̣̃ ꞌdî lôgõzó Yésũ drí kĩ nĩ rî, “Ámâ rú Õꞌbígó, tãlâ ãmâ rĩꞌá dũû líndrí õnjí bê.” ");
INSERT INTO avu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nĩngá sĩ, ãgô rî ꞌdĩ drí rúꞌbạ́ lôꞌbãzó rõô Yésũ drí, tãlâ Yésũ õzó líndrí õnjí ꞌdĩ ꞌbá yî lâdró vólé ꞌbạ̃drı̣̃ ꞌdî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","13","ꞌDĩî rî, ngbíkpí õtólõꞌbĩ ꞌbã kâ bê rĩꞌá ĩyî ãnyî võ rî ꞌdĩ ꞌá zãlô kútũ-rı̣̃ gólĩyî rĩꞌá ânyáꞌá lũtú gãrã ꞌá. Gõꞌdá líndrí õnjí ãgô ꞌdĩ ꞌá ꞌdĩ ꞌbá yî drí ngãzó rúꞌbạ́ lôꞌbãlé Yésũ drí kĩ nĩ rî, “Ní drô ãmâ fĩlí ngbíkpí ꞌbã kâ gólĩyî rĩ ꞌbá ĩyî ânyálé nã yî ꞌá.” Ĩtí, Yésũ drí tã lẽzó drílĩyî fĩzó ngbíkpí ꞌdĩ ꞌbá yî ꞌá. Nĩngá sĩ, líndrí õnjí rî ꞌdĩ ꞌbá yî ndrĩ drí âfõzó ãgô rî ꞌdĩ ꞌásĩ nĩlí ĩyî fĩlí ngbíkpí ꞌbã kâ ꞌá, õzõ Yésũ drí lẽlé trá rî kâtí. Gõꞌdá ꞌwãâ ngbíkpí ꞌbã kâ ꞌdĩ ꞌbá yî drí ngãzó rãlé ãlólẽ lũtú pá lâ gólókõ nã ꞌá zãâ lôꞌdélé lı̣̃mvû ꞌálâ, gõꞌdá drílĩyî lı̣̂mvúzó ôdrãlé ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nĩngá sĩ, ngbíkpí ꞌdĩ ꞌbá yî lôkí ꞌbá lâ yî ndrélé bê ĩyî tã ꞌdî ꞌbá yî rî, drílĩyî ngãzó rãlé vólé tã lâ âꞌdálé õjílã gólĩyî ꞌbạ̃drı̣̃ ꞌdî kâ âꞌdó ꞌbá ĩyî õmã ꞌásĩ gõꞌdá kpá jạ̃rı̣́bạ̃ ꞌásĩ rî ꞌbá yî drí. Tãlâ tã gólĩyî drí âꞌdálé ꞌdĩ tãsĩ rî, õjílã dũû drí ngãzó ânĩlí ĩyî tã rû ꞌẽ ꞌbá trá ꞌdĩ ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Gõꞌdá gólĩyî âcálé bê Yésũ ngálâ rî, drílĩyî ãgô líndrí õnjí dũû drí ômbélé trá gõꞌdá Yésũ drí drõlé trá ꞌdĩ ndrẽzó, gólâ trá gõꞌdá rĩꞌá tı̣́tı̣́ drı̣̃ tãndí sĩ, gõꞌdá kpá trá cú ítá bê yí rú. Gólĩyî ndrê bê kĩꞌá nĩ rî, líndrí õnjí ạ̃bạ̃bạ̃ kâ âfõ ĩyî trá ãgô rî ꞌdĩ ꞌásĩ rî, drílĩyî âꞌdózó ndrĩ ꞌdó ũrı̣̃ ró tákányĩ. ");
INSERT INTO avu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tã ꞌdî vólé drı̣̃ lâ ꞌásĩ, gólĩyî líndrí õnjí ndrẽ ꞌbá trá âfõrẽ ꞌá rî yî drí tã ãgô ꞌdĩ ꞌẽ ꞌbá ꞌdĩ ngĩzó õjílã ũrûkậ ꞌbá yî drí ârílí. ꞌDĩî gólĩyî ngî tã ngbíkpí ꞌẽ ꞌbá lôꞌdélé ndrĩ lı̣̃mvû ꞌá ôdrãlé rî kpá trá õjílã ũrûkậ ꞌdĩ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nĩngá sĩ, õjílã ꞌdî ꞌbá yî drí rúꞌbạ́ lôꞌbãzó Yésũ rú, tãlâ Yésũ ãâyê ró ꞌbạ̃drı̣̃ ĩyíkâ. ");
INSERT INTO avu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bê trá ĩtí rî, Yésũ yî drí ngãzó mbãlé kõlóngbõ ꞌá kpá óꞌdí gõlé lı̣̃mvû ândrê ãlôlâ ꞌdĩ drı̣̃ı̣̂ sĩ ꞌáꞌá ꞌálâ. Gólâ mbâ bê kõlóngbõ ꞌá rî, ãgô líndrí õnjí yî drí âfõzó trá ꞌálâ sĩ ꞌdî drí ngãzó rúꞌbạ́ lôꞌbãlé Yésũ rú kĩ nĩ rî, “Yésũ, má lẽ nĩlí ní bê.” ");
INSERT INTO avu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Gõꞌdá nĩngá sĩ, Yésũ drí gãzó dó. Gólâ kĩ ãgô ꞌdĩ drí rî, “ꞌDõvó ní ngâ gõlé ní drí ꞌbã ꞌálâ õjílã áníkâ ꞌbã ꞌá rî yî ngálâ, ní ngî ró bê tã Ôvârí drí ꞌẽlé ní drí tãndí ró ꞌdĩ gólĩyî drí. Ní ngî gólĩyî drí, ní kĩ, Ôvârí ndrê ánî ĩzã ꞌî, gõꞌdá drílâ ánî pãzó ꞌálâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nĩngá sĩ, ãgô rî ꞌdĩ drí ngãzó nĩlí jạ̃rı̣́bạ̃ ꞌbạ̃drı̣̃ ꞌdî kâ mûdrı̣́ rî ꞌbá yî ꞌásĩ. Drílâ tã Yésũ drí ꞌẽlé yí drí rî ngĩzó õjílã drí. Gõꞌdá õjílã ndrĩ tã ꞌdî ârí ꞌbá rî tı̣̂ lâ yî drí ậꞌdı̣́zó ndrú tã lârâkô ꞌdĩ drí. ");
INSERT INTO avu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tólâ sĩ, Yésũ yî drí âmbãzó kõlóngbõ sĩ âgõlé lı̣̃mvû ândrê ꞌdĩ ꞌáꞌá lé drı̣̃ ı̣̃tú drí fĩrĩ ꞌálâ rî ãzâ rî lésĩ. Gõꞌdá gólĩyî âcâ bê lı̣̃mvû tı̣́ rî, õjílã ı̣́tı̣́lı̣́lı̣́ drí rû êꞌbézó Yésũ lạ̃gạ́tı̣́. ");
INSERT INTO avu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yésũ yî bê drẽ ãkpã lı̣̃mvû ândrê tı̣́ ꞌálâ rî, ãgô ãzâ rú lâ Yáĩrõ drí âcázó. Gólâ jó tã Ôvârí kâ ârî kâ vó lâ ndrẽ ꞌbá ꞌî. Gólâ âcâ bê gõꞌdá drílâ Yésũ rî ndrẽzó rî, drílâ ꞌãꞌî tı̣̃zó vũdrı̣́ gõzó drı̣̃ âsõlé Yésũ ândrá. ");
INSERT INTO avu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nĩngá sĩ, drílâ rúꞌbạ́ lôꞌbãzó Yésũ rú rõô kĩ nĩ rî, “Ámâ mvá õkó mvá ró rî ꞌê trá ãnyî drãlé. ꞌDõvó ní ânĩ drı̣́ ꞌbãlé drı̣̃ lâ, tãlâ gólâ õpâ ró ngá bê. Ní pâ gólâ, tãlâ gólâ õzó drãâ kô.” ");
INSERT INTO avu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ĩtí rî, Yésũ drí tã-drı̣̃ lẽzó nĩlí Yáĩrõ bê. Nĩngá sĩ, Yésũ yî õtírĩ rĩî nĩlí Yáĩrõ bê Yáĩrõ drí ꞌbã ꞌálâ rî, õjílã dũû drí ngãzó kpá ꞌdẽlé gólĩyî vósĩ. Gõꞌdá nĩꞌá ĩyî lôꞌbé bê Yésũ rú sĩ. ");
INSERT INTO avu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nĩngá sĩ, õkó ãzâ nî áníkâ bê gólĩyí bê nĩngá. Nî rĩꞌá cú ãrí bê lâsóꞌá ní rú sĩ párá ró. Rúꞌbạ́ rî ꞌdĩ rî trá rĩꞌá gólâ rî ꞌẽlé ndrô mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ꞌDĩî gólâ lậmû trá kpı̣̃ı̣̂ ójó ngálâ. Nĩngá sĩ, ójó ꞌdĩ ꞌbá yî îcá kô õkó ꞌdĩ ꞌbãlé âꞌdólé tãndí ró. Tíkó ãꞌdô ró bê õkó rî ꞌdĩ ꞌbãzó âꞌdólé tãndí ró rî, gõꞌdá rúꞌbạ́ gólâ rú ꞌdĩ lậnjı̣̃ íyîngá ạ̃tı̣́ ꞌálâ. Gõꞌdá lãfâ ĩdíkõ gólâ drı̣́gạ́ rî ꞌbá yî ndẽ rû trá ndrĩ ójó drí. ");
INSERT INTO avu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Gõꞌdá õkó ꞌdĩ ârî bê Yésũ rî tã rî, gõꞌdá gólâ gõ ndrélé bê Yésũ rî, gólâ drí ngãzó ꞌdẽlé kpãâ õjílã õꞌbí ꞌdĩ ꞌbá yí bê Yésũ vósĩ. Gólâ ı̣̂sũ íyíkâ yí drı̣̃ı̣̂ rî kĩ nĩ rî, õzõ yí õdõ cé ítá tı̣̂ Yésũ kâ ꞌdĩ ĩꞌdî rî, íyî rúꞌbạ́ âꞌdô âgõꞌá võ lâ ꞌá tãndí ró. Gõꞌdá tólâ sĩ, gólâ drí ânĩzó ítá Yésũ kâ dõlé kírî ró. ");
INSERT INTO avu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ĩtí rî, ꞌwãâ ãrí rĩ ꞌbá lâsólé gólâ rú sĩ ꞌdî drí kĩzó vólé. Gõꞌdá gólâ drí nı̣̃zó lâ kĩ nĩ rî, yí êdê rû trá ndrĩ dódó. ");
INSERT INTO avu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gõꞌdá nĩngá sĩ, ꞌwãâ Yésũ ní drí nı̣̃zó lâ kĩ, mbârâkã áníkâ êdê õjílã trá. Gõꞌdá ĩtí rî, ní drí âdrézó rû pĩlí gbãâ tã îjílí õjílã õꞌbí ꞌdĩ ꞌbá yî tı̣́ kĩ nĩ rî, “Ãꞌdî dõ ítá ámákâ kírî ró nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gõꞌdá lãjóꞌbá gólâkâ drí tã-drı̣̃ lôgõzó kĩ nĩ rî, “Ní îjî tã kĩ, ãꞌdî dõ ítá áníkâ nĩ yã ꞌdî ãꞌdô tãsĩ yã? Ní ndré áníkâ õjílã nô ꞌbá yî rĩ ꞌbá rĩꞌá rû îfílí ní rú nõ kô yã?” ");
INSERT INTO avu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Gõꞌdá bê kpálé ĩtí rî, Yésũ drẽ zãâ rĩꞌá võ ndrẽꞌá dîrî gbãâ tãlâ gólâ ítá íyíkâ dõ ꞌbá trá ꞌdĩ ûsúzó. ");
INSERT INTO avu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nĩngá sĩ, õkó ítá Yésũ kâ dõ ꞌbá trá ꞌdĩ drí ngãzó ânĩlí Yésũ ngálâ lẽlẽ ró kpã kpã kpã ũrı̣̃ bê, tãlâ gólâ nı̣̃ trá kĩ, íyî rúꞌbạ́ êdê rû trá. Ĩtí, drílâ íyî âdãzó ạ̃drũ Yésũ ândrá gõzó ngãlé tã pạ̃tı̣́ı̣̃ rî âtálé Yésũ drí kĩ, “Má dõ ítá áníkâ mâ kírî ró.” ");
INSERT INTO avu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Vó lâ sĩ, Yésũ drí tã âtázó kĩ nĩ rî, “Ámâ îzó, ní êdê rû trá tã lẽlẽ áníkâ má ꞌá rî tãsĩ. Ní ngâ gõlé ꞌbã ꞌálâ rúꞌbạ́ ạ̃ꞌdı̣́ sĩ. Ní âꞌdô kô tã ı̣̂sũ-ı̣̂sũ ró rúꞌbạ́ ní rú âꞌdó ꞌbá trá ꞌdĩ tãsĩ. Rúꞌbạ́ áníkâ ꞌdĩ kî trá zãâ gbạ́dú.” ");
INSERT INTO avu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Gõꞌdá Yésũ yî õtírĩ rĩî úlı̣́ ꞌdĩ âtálé õkó rî ꞌdĩ bê rî, õjílã ũrûkậ ꞌbá yî drí ngãzó âcálé Yáĩrõ mvá lâ drí ꞌbãlé ngá lãzé ró rî drí ꞌbã lésĩ võrã bê Yáĩrõ drí kĩ nĩ rî, “Yáĩrõ, ánî mvá drã trá. Ní rî gõꞌdá lı̣̃fı̣́ îcí ꞌbá rî îjílí ânĩlí ní drí ꞌbã ꞌálâ kô.” ");
INSERT INTO avu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lé ĩtí rî, Yésũ gã tã õjílã ꞌdî ꞌbá yî drí âtálé Yáĩrõ drí ꞌdĩ dó. Gõꞌdá gólâ kĩ Yáĩrõ drí rî, “Ánî líndrí õꞌbê kô dı̣̃. Ní rî tã lẽlẽ sĩ Ôvârí ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tã ꞌdî vósĩ, Yésũ lẽé gõꞌdá õjílã õꞌbí ꞌdĩ ꞌbá yî kô ꞌdẽlé yí vósĩ nĩlí Yáĩrõ drí ꞌbã ꞌálâ. Lãjóꞌbá gólâkâ lãfálé sĩ, cé Pétẽrõ, gõꞌdá Yõwánĩ ậdrúpı̣̃ lâ Yãkóbã bê âjî ĩyî Yésũ nĩ. ");
INSERT INTO avu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Gõꞌdá nĩngá sĩ, gólĩyî õtírĩ âcá Yáĩrõ drí ꞌbã ꞌálâ rî, võ trá bárábányá, gõꞌdá õjílã dũû trá ꞌdó ãwó ngõꞌá rõô ĩzã ró, gõꞌdá lúlũ ângbâ ĩyíkâ trá káwó-káwó. ");
INSERT INTO avu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nĩngá sĩ, Yésũ yî drí fĩzó jó ãwó kâ rî ꞌálâ, gõꞌdá Yésũ drí tã âtázó ãwó ãnjó ꞌbá drí ãgô bê kĩ nĩ rî, “Nĩ rî rĩꞌá ãwó ngõlé ngbạ́lạ́-ngbạ́lạ́ nõ ãꞌdô tãsĩ yã? Nĩ rî rĩꞌá tã gólâ bárábányá ró nõtí nõ ꞌẽlé ãꞌdô tãsĩ yã? Mvá nõ drãá kô. Gólâ rî íyîngá ậꞌdú kõꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nĩngá sĩ, õjílã ãwó ꞌá ꞌdĩ ꞌbá yî drí Yésũ rî gũzó gbõ gũgũ. Gõꞌdá nĩngá sĩ, Yésũ drí tã ꞌbãzó õjílã gólĩyî jó ãvõ kâ rî ꞌálâ rî ꞌbá yî drí âfõlé ĩví ꞌálâ. Gõꞌdá drílâ ngãzó mvá ꞌdĩ ândré lâ yî, átá lâ bê gõꞌdá kpá lãjóꞌbá íyíkâ nâ ꞌdĩ ꞌbá yí bê zı̣̃zó fĩlí yí bê jó ãvõ ꞌbãzó ngbạ́ngbạ́ drı̣̃ı̣̂ ꞌdĩ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gõꞌdá gólĩyî âfî bê rî, Yésũ drí ízámvá rî ꞌdĩ drı̣́ lâ rũzó. Gõꞌdá drílâ ngãzó tã âtálé Ãrãmáyã tı̣̂ sĩ kĩ nĩ rî, Tãlítã gúmı̣̃. Ĩtõ lâ kĩ nĩ rî, “Ízámvá, ní ngâ ûrû.” ");
INSERT INTO avu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Ĩtí rî, ꞌwãâ ízámvá ꞌdĩ drí kôrô ngãzó ûrû, gõꞌdá drílâ gõzó rĩꞌá lậmúlı̣́ dîrî. Âꞌdô bê trá ĩtí rî, õjílã kậkậrậ ndrĩ gólâ rî ndrẽ ꞌbá trá rî yî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó ꞌdó ậꞌdı̣̂-ậꞌdı̣̂ ndrú. Gõꞌdá nĩngá sĩ, Yésũ drí tã ꞌbãzó gólĩyî drí, tãlâ gólĩyî õzó tã ꞌdî pẽê kô õjílã drí ãlôlâ. Gõꞌdá gólâ drí kpá tã âtázó kĩ, óõfẽ ngá nyãnyã ízámvá rî ꞌdĩ drí nyãlé. Ízá rî ꞌdĩ ndrô lâ trá rĩꞌá mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃. ");
INSERT INTO avu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tólâ sĩ, Yésũ yî drí ngãzó lãjóꞌbá íyíkâ rî ꞌbá yí bê võ nã âyélé nĩzó jạ̃rı̣́bạ̃ Yésũ rî lı̣̃fı̣́ drí cĩzó ꞌá lâ ãgô ró rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ĩtí, gõꞌdá kậyı̣̂ rãtáã ꞌẽ kâ Ôvârí drí rî âcâ bê rî, Yésũ drí ngãzó nĩlí fĩlí jó tã Ôvârí kâ ârî kâ rî ꞌálâ. Jó rî ꞌdĩ ꞌá tólâ rî, drílâ ngãzó rĩꞌá õjílã lı̣̃fı̣́ îmbálé. Nĩngá sĩ, õjílã dũû gólĩyî Yésũ rî úlı̣́ ârí ꞌbá trá rî yî tı̣̂ lâ yî drí ậꞌdı̣́zó ndrú. Gõꞌdá gólĩyî drí tã âtázó kĩ nĩ rî, “Ãgô rî gólâ nõ ûsû íyíkâ tã nı̣̃nı̣̃ ạ́ngı̣́ rî nõ ꞌbá yî ángô lésĩ ró yã? Gõꞌdá gólâ rî ꞌbã ꞌbá kpá âꞌdólé cú mbârâkã bê rĩzó tã lârâkô ꞌẽlé nõ ãꞌdô ꞌásĩ yã? ");
INSERT INTO avu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Gólâ âꞌdó kô cé õjílã rĩ ꞌbá ngá êdélé fê ꞌásĩ ãmâ drí nı̣̃lı̣́ trá nõ ĩꞌdî kô yã? Gólâ âꞌdó kô Mãríyã rî mvá ágó ró rî ĩꞌdî yã? Ĩtí rî, mã nı̣̃ ậdrúpı̣̃ lâ yî trá. Gólĩyî ĩꞌdî Yãkóbã, Yõsépã, Yúdạ̃ gõꞌdá kpá Sĩmónã. Gõꞌdá gólâ rî îzó yî âꞌdó kô ãmá bê nõngá yã? Âꞌdô îcáꞌá gólâ drí tã îmbázó tã nı̣̃nı̣̃ sĩ ãmâ drí ángô tí yã?” Bê trá ĩtí rî, drílĩyî Yésũ rî gãzó dó lı̣̃fı̣́ îmbá ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nĩngá sĩ, Yésũ drí ngãzó tã-drı̣̃ lôgõlé gólĩyî drí úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Tã pạ̃tı̣́-pạ̃tı̣̃ ró, gõꞌdá cé õjílã ꞌbạ̃drı̣̃ gólâkâ rî ꞌá rî ꞌbá yî ı̣̂njı̣̃ı̣́ ĩyî kô gólâ rú. Ĩtí lâ ꞌdĩ ró, ãnî ndrĩ ꞌdó ꞌbãá lậnjı̣̃ má rú kô.” ");
INSERT INTO avu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Yésũ rî tı̣̂ drí ậꞌdı̣́zó, tãlâ õjílã ꞌdî ꞌbá yî rĩꞌá cú ĩtí tã lẽlẽ ãkó gólâ ꞌá. Tã rî ꞌdĩ tãsĩ rî, îcá kô Yésũ drí tã lârâkô ãmbá ꞌẽzó ĩyî drí ꞌbạ̃drı̣̃ ꞌá tólâ. Gólâ ꞌbã drı̣́ trá cé ngá lãzé ꞌbá ũrûkậ ꞌbá yî drı̣̃ı̣̂, tãlâ gólĩyî ãꞌdô ró bê tãndí ró. ꞌDĩî ꞌbá yî ngá Yésũ drí ꞌẽlé võ gólâ rî lı̣̃fı̣́ drí cĩzó ãgô ró rî ꞌálâ rî ĩꞌdî. Tólâ sĩ, Yésũ yî drí ngãzó nĩlí lậmú bê gbãâ jạ̃rı̣́bạ̃ ãzâ ꞌbá yî ꞌásĩ õjílã lı̣̃fı̣́ îmbá bê. ");
INSERT INTO avu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ị̃tú ãzâ sĩ, Yésũ drí ngãzó lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yî ậzı̣́zó yí ngálâ, yí jô ró gólĩyî tı̣̂ sú ãzí ró rı̣̃ rı̣̃ nĩlí tã âtî-âtî íyíkâ pẽ bê õjílã drí. Gólâ fẽ mbârâkã gólĩyî drí líndrí õnjí lâdrózó ĩꞌdî sĩ lâ vólé. ");
INSERT INTO avu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yésũ ꞌbã tã lãjóꞌbá rî ꞌdĩ ꞌbá yî drí ậcı̣́ gólĩyíkâ ꞌdĩ tõzó drı̣́-drı̣́ı̣̃ ró. Gólâ kĩ gólĩyî drí rî, “Nĩ trõ ngá nyãnyã kô. Nĩ trõ jõráã ítá ꞌbã kâ kô, gõꞌdá nĩ trõ lãfâ kpá kô. Nĩ trõ cé pı̣̃drı̣́gú mvá ĩꞌdî ãnî drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nĩ sõ káꞌbókã ĩꞌdî ãnî pá. Gõꞌdá nĩ âkpã ítá kô zãlô rı̣̃ ãnî rú.” ");
INSERT INTO avu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nĩngá sĩ, Yésũ drí tã âtázó lãjóꞌbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Jạ̃rı̣́bạ̃ ãnî drí nĩzó fĩ bê ꞌálâ sĩ cé tı̣̂tı̣̂ ꞌdĩ ꞌá rî, õzõ nĩ õcâ trá ꞌbã ãzâ ꞌá ũmú ró rî, nĩ rî ậꞌdú kõlé cé ꞌbã rî ꞌdĩ ꞌá té bũúũ kậyı̣̂ ãnî drí jạ̃rı̣́bạ̃ rî ꞌdĩ âyézó rî tú. ");
INSERT INTO avu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nĩ õcâ trá võ ũrûkậ ꞌbá yî ãnî lậgúzó ꞌá lâ sĩ kô rî ꞌá rî, gõꞌdá õzõ óõgã trá dó úlı̣́ ãníkâ ârílí rî, nĩ rî kô ꞌá lâ tólâ. Gõꞌdá õzõ nĩ õngâ trá nĩlí ꞌá lâ ꞌásĩ vólé rî, nĩ yâ ró tạ̃pı̣́lı̣́ndrı̣́ lâ vólé ãnî pá ágálé ꞌásĩ. Nĩ ꞌê ꞌdĩ, ãâꞌdâ ró bê tã gólĩyî rú lãmbé ró kĩ nĩ rî, Ôvârí âꞌdô lâŋõ fẽꞌá gólĩyî drí.” ");
INSERT INTO avu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Vólé drı̣̃ lâ ꞌásĩ, lãjóꞌbá ꞌdĩ ꞌbá yî drí ngãzó nĩlí ĩyî õzõ tã Yésũ drí âtálé trá rî kâtí. Gólĩyî pẽ tã õjílã drí kĩ nĩ rî, õjílã ãâdĩ drı̣̃ tã õnjí ĩyíkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gólĩyî nĩ trá líndrí õnjí lâdró bê õjílã ꞌásĩ. Gõꞌdá gólĩyî lôbẽ dõ kpá trá ngá lãzé ꞌbá ándrá-gạ́-sı̣́lı̣́ ꞌásĩ rãtáã ꞌẽꞌẽ sĩ gõꞌdá ngá lãzé drí ndẽzó gólĩyî rú sĩ. ");
INSERT INTO avu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kúmú ạ́ngı̣́ ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî rú lâ Ẽródẽ Ãnĩtípã. Gólâ ârî tã lârâkô dũû Yésũ drí ꞌẽlé ꞌdĩ ꞌbá yî trá ndrĩ, tãlâ Yésũ rî rú lı̣̂kû trá rõô. Gõꞌdá õjílã ũrûkậ ꞌbá yî âtâ ĩyî tã kĩ nĩ rî, “Ãꞌdô Yõwánĩ bãbãtízĩ ꞌbá ró drã ꞌbá trá rî ĩꞌdî. Ĩtí rî, óꞌê gólâ kpá trá lîdrílí óꞌdí. Tãlâ ĩꞌdî, ngbãângbânõ, gólâ drí âꞌdózó cú mbârâkã ãmbá ĩtí ꞌdĩ bê tã lârâkô ꞌẽzó.” ");
INSERT INTO avu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ãzâ ꞌbá yî kĩ ĩyíkâ rî, “Yésũ ãꞌdô tã ậngũ ꞌbá Ẽlíyã ĩꞌdî. Ôvârí ãâjô gólâ trá ûrú lésĩ, õzõ yí drí ꞌbãlé rî kâtí.” Gõꞌdá ãzâ ꞌbá yî âtâ ĩyíkâ kpá kĩ nĩ rî, “Gólâ ãꞌdô cé tã ậngũ ꞌbá ãzâ ꞌî, õzõ tã ậngũ ꞌbá âꞌdó ꞌbá trá ạ̃kû nã ꞌbá yí kâtí.” ");
INSERT INTO avu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gõꞌdá nĩngá sĩ, kúmú ạ́ngı̣́ Ẽródẽ ârî bê tã õjílã drí rĩꞌá âtálâ, gõꞌdá kpá ı̣̂sũlâ Yésũ rî tã ꞌá rî, gólâ rî nyãányâ drí ngãzó tã ı̣̂sũlı̣́ cú nĩ kĩ nĩ rî, “Gólâ ꞌdĩ Yõwánĩ má drí ômbê lâ gãlé trá njíyá vólé rî ĩꞌdî. Gólâ lîdrî nõ gõꞌdá kpá trá lîdrî õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Tã gólâ õdrã pá âsé ꞌbá Yõwánĩ drı̣̃ı̣̂ rî ĩꞌdî nõ. Sı̣́sı̣́ õkó ãzâ rú lâ Ẽrõdíyã âꞌdô trá Ẽródẽ rî ậdrúpı̣̃ Fílĩpõ rî õkó ꞌî. Gõꞌdá Ẽródẽ ní drí ngãzó õkó rî ꞌdĩ drı̣̃ lâ îzãlé vólé ánî ậdrúpı̣̃ Fílĩpõ drı̣́gạ́ sĩ âꞌdólé nî rî gógó drí õkó ró. Gõꞌdá Yõwánĩ ndrê tã ꞌdî bê rî, drílâ ngãzó tã pẽlé Ẽródẽ drí kĩ nĩ rî, “Âꞌdó kô tã mbı̣̂ ró ní drí ánî ậdrúpı̣̃ rî õkó rî trõzó âꞌdólé ní drí õkó ró.” Tãlâ tã ꞌdî tãsĩ rî, õkó rî gógó Ẽrõdíyã drí ngãzó tã ômbélé ngóló yí ꞌá Yõwánĩ rú. Gólâ lôndã pávó yí drí Yõwánĩ rî fũzó ꞌá lâ sĩ rî kpı̣̃ı̣̂. Gõꞌdá ĩtí rî, Ẽródẽ âyé gólâ kô tã rî ꞌdĩ ꞌẽlé, tãlâ Ẽródẽ rî gógó ı̣̂njı̣̃ Yõwánĩ trá rõô. Gólâ nı̣̃ trá kĩ, Yõwánĩ õjílã tãndí mbı̣̂ rî ĩꞌdî Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá. Ĩtí rî, Ẽródẽ rî lı̣̃fı̣́ drí mbãzó Yõwánĩ drı̣̃ı̣̂ Ẽrõdíyã drı̣́gạ́ sĩ. Ĩꞌdî Ẽródẽ drí Yõwánĩ rî ômbézó ꞌbãlé gạ̃nı̣́mạ̃ ꞌá. Ẽródẽ rî kpá zãâ nĩlí úlı̣́ Ôvârí kâ Yõwánĩ drí rĩꞌá ngĩlâ rî ꞌbá yî ârílí gạ̃nı̣́mạ̃ ꞌálâ. Úlı̣́ Yõwánĩ kâ ꞌdĩ ãꞌdô kpálé gólâ rî drı̣̃ lîjãꞌá rî, gólâ rî kpá zãâ gõlé ârílâ, tãlâ úlı̣́ rî ꞌdĩ ꞌbá yî rĩꞌá tãndí ró kôrô. ");
INSERT INTO avu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Gõꞌdá kậyı̣̂ ãzâ sĩ, Ẽrõdíyã drí ngãzó lạ́tı̣̂ ûsúlı̣́ Yõwánĩ rî fũzó. Kậyı̣̂ rî ꞌdĩ kậyı̣̂ Ẽródẽ rî tı̣̃zó ꞌá lâ rî ĩꞌdî. Ĩtí, kậyı̣̂ rî ꞌdĩ tú, Ẽródẽ yî drí kãrámã ândrê ꞌbãzó. Gõꞌdá Ẽródẽ drí ngãzó tã âtílí õjílã ãmbâ-ãmbâ kũmũ íyíkâ zẽlé rî yî drí, drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá yí kâ gõꞌdá kpá ꞌdó õjílã ãmbâ-ãmbâ Gãlĩláyã ꞌálâ rî yî drí, tãlâ gólĩyî ânĩ ró ĩyî kãrámã rî ꞌdĩ nyãlé yí ngálâ. ");
INSERT INTO avu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nĩngá sĩ, kãrámã rî ꞌdĩ tú rî, Ẽrõdíyã rî mvá ãnjó ró rî drí ngãzó fĩlí ậndú tõlé lậvũlı̣́ gạ̃rạ̃. Ĩtí rî, ậndú tõtõ gólâkâ ꞌdĩ drí Ẽródẽ yî ũmú ĩyíkâ rî ꞌbá yí bê ꞌbãzó âꞌdólé ndrĩ ãyĩkõ ró lậvũlı̣́ kôrô. Tãlâ ậndú ízámvá ꞌdĩ drí tõlé ꞌdĩ tãsĩ rî, Ẽródẽ drí tã âtázó drílâ kĩ nĩ rî, “Õzõ ní ĩîjî mâ rî, má âꞌdô ngá ní drí lẽlé rî fẽꞌá ní drí.” ");
INSERT INTO avu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Gõꞌdá nĩngá sĩ, Ẽródẽ drí ngãzó tã âtálé lãtrítrí ró kĩ nĩ rî, “Má âꞌdô ngá ní drí lẽlé rî fẽꞌá ní drí. Õzõ ní õlẽ rî, má âꞌdô ꞌbạ̃drı̣̃ ámákâ lãfálâ nyĩꞌá rı̣̃ gõzó ãzâ rî fẽlé ní drí.” ");
INSERT INTO avu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tólâ sĩ, ízámvá ꞌdĩ drí ngãzó nĩlí ândré lâ Ẽrõdíyã rî îjílí kĩ nĩ rî, “Má âꞌdô ngá ángô rî zı̣̃ꞌá ĩꞌdî Ẽródẽ tı̣́ sĩ âfẽlé má drí yã?” Gõꞌdá ândré lâ drí tã-drı̣̃ lôgõzó drílâ kĩ nĩ rî, “Ní âtâ Ẽródẽ drí, gólâ õjô õjílã nĩꞌá Yõwánĩ bãbãtízĩ ꞌbá ró rî ômbê lâ gãlé njíyá, áâtrõ ró drı̣̃ lâ ꞌdĩ tạ́bı̣́gạ́ ꞌá âjílí ní drí, tãlâ má nı̣̃ ró kĩ nĩ rî, gólâ drã trá.” ");
INSERT INTO avu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ĩtí rî, ízámvá ꞌdĩ drí ngãzó rãlé ꞌwãâꞌwâ pá drı̣̃ kâ sĩ gõlé Ẽródẽ ngálâ. Gõꞌdá drílâ tã âtázó Ẽródẽ drí kĩ nĩ rî, “Má lẽ úfû Yõwánĩ bãbãtízĩ ꞌbá ró rî, ógâ ômbê lâ njíyá vólé, óꞌbã ró drı̣̃ lâ ꞌdĩ tạ́bı̣́gạ́ ꞌá âtrõlé âjílí má drí nõlé.” ");
INSERT INTO avu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nĩngá sĩ, Ẽródẽ drí âꞌdózó tã ı̣̂sũ ró, tãlâ lãtrítrí gólâ drí îtrílí trá ízámvá ꞌdĩ drí rî tãsĩ. Õzõ gólâ õgã dó tã ízámvá ꞌdĩ kâ lẽlé ꞌdĩ ꞌẽlé rî, ãnyĩ âꞌdô gãꞌá gólâ drı̣̃ı̣̂ ũmú gólâkâ ꞌdĩ ꞌbá yî ândrá. ");
INSERT INTO avu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Gõꞌdá bê trá ĩtí rî, Ẽródẽ drí gbõ tã-drı̣̃ lẽzó óõgâ ró Yõwánĩ rî ômbê njíyá vólé. Gõꞌdá Ẽródẽ drí tã ꞌbãzó ạ̃jú ꞌbũ ꞌbá íyíkâ ãlô rî drí, õnĩ ró bê Yõwánĩ rî drı̣̃ âgálé âtrõlé âgõzó ĩꞌdí bê lâ. Gõꞌdá ạ̃jú ꞌbũ ꞌbá Ẽródẽ kâ ꞌdĩ drí ngãzó nĩlí gạ̃nı̣́mạ̃ ꞌálâ. Gólâ câ bê tólâ rî, drílâ Yõwánĩ rî ômbê gãzó njíyá vólé. ");
INSERT INTO avu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nĩngá sĩ, drílâ ngãzó âgõlé Yõwánĩ rî drı̣̃ bê tạ́bı̣́gạ́ ꞌá âjílí fẽlé ízámvá ꞌdĩ drí. Gõꞌdá gólâ âcâ bê ĩꞌdí bê lâ rî, ízámvá ꞌdĩ drí ngãzó drı̣̃ rî ꞌdĩ trõlé âjílí ândré lâ drí. ");
INSERT INTO avu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nĩngá sĩ, tã ârí ꞌbá Yõwánĩ kâ rî ꞌbá yî ârî ĩyî tã ꞌdî bê ĩtí rî, drílĩyî ngãzó nĩlí gạ̃nı̣́mạ̃ ꞌálâ Yõwánĩ rî ãvõ ạ̃lı̣́ ꞌdĩ njı̣̃lı̣́ nĩzó ĩꞌdí bê lâ ꞌbãlé ꞌbú ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tólâ sĩ, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí âgõzó ĩyî ậcı̣́ ĩyíkâ tõlé nã ꞌásĩ Yésũ ngálâ. Gõꞌdá drílĩyî rĩzó tã rû ꞌẽ ꞌbá ậcı̣́ ĩyî drí tõlé nã ꞌbá yî ꞌásĩ rî ngĩlí Yésũ drí kpá ꞌdó ndrĩ tã drílĩyî îmbálé trá õjílã drí rî yí bê. ");
INSERT INTO avu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ị̃tú rî nã ꞌbá yî sĩ, õjílã dũû rî ĩyî trá ânĩlí kárá Yésũ rî ndrẽlé. Ĩtí rî, ânĩ-ânĩ gõꞌdá õjílã ꞌdî ꞌbá yí kâ ꞌdĩ ꞌbãá Yésũ yî kô ngá nyãlé dódó gõꞌdá kpá lôvólé tãndí ró. Gõꞌdá tã rî ꞌdĩ tãsĩ rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ngâ, mã nĩ ró võ õjílã ãkó rî ndãlé ûsúlı̣́, ãꞌdô ró ãmâ nyãányâ drí lôvózó ꞌá lâ tãkõ.” ");
INSERT INTO avu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nĩngá sĩ, drílĩyî ngãzó fĩlí kõlóngbõ ꞌá, gõzó lı̣̃mvû ândrê ꞌdĩ drı̣̃ lâ mbãzó nĩlí võ õjílã ãkó rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gõꞌdá tólâ sĩ, õjílã dũû ndrê ĩyî Yésũ yî trá nĩrĩ ꞌá kõlóngbõ sĩ. Drílĩyî võ Yésũ yî drí rĩzó nĩlí ꞌálâ ꞌdĩ nı̣̃zó téké, gõꞌdá drílĩyî ngãzó ndrĩ nĩlí ꞌwãâꞌwâ rû êꞌbélé jạ̃rı̣́bạ̃ ꞌásĩ ndrĩ. Nĩngá sĩ, drílĩyî ngãzó nĩlí ꞌwãâꞌwâ pá sĩ lı̣̃mvû ândrê ꞌdĩ tı̣́ ꞌálâ, gõꞌdá cãlé võ õjílã ãkó ꞌdĩ ꞌá sı̣́sı̣́ Yésũ yî drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Gõꞌdá nĩngá sĩ, Yésũ yî câ bê võ rî nã ꞌá gõzó ꞌẽꞌá ârílí kõlóngbõ ꞌásĩ rî, drílĩyî õjílã õꞌbí ndrẽzó êꞌbê rû ĩyî trá ngbạ̃ꞌũ Yésũ rî tẽlé. Gõꞌdá Yésũ ndrê gólĩyî bê trá ĩtí rî, ĩzã lâ yî drí gólâ rî ꞌẽzó. Õjílã ꞌdî ꞌbá yî lêndrê ĩyî Yésũ rî lı̣̃fı̣́ drı̣̃ ꞌá õzõ kạ́bı̣̃lı̣́kı̣̃ âꞌdó ꞌbá ĩyî lôkí ꞌbá ãkó rî kâtí. Nĩngá sĩ, Yésũ drí ngãzó gólĩyî îmbálé tã dũû sĩ. Yésũ âꞌdâ tã trá gólĩyî drí cãlé bũúũ lạ̃njạ́túlı̣́ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nĩngá sĩ, lạ̃njạ́túlı̣́ ãlô ꞌdĩ sĩ, lãjóꞌbá Yésũ kâ rî ꞌbá yî drí ngãzó ânĩlí Yésũ rî gógó ngálâ tã âtálé gólâ drí kĩ nĩ rî, “Ní ndrê drẽ, Kúmú, nõô ı̣̃tú trá ꞌẽꞌá fĩlí. Gõꞌdá õjílã ãmbá ꞌdĩ ꞌbá yî trá ĩyî ndrĩ lõfó ró, gõꞌdá ꞌbã kpá yûꞌdạ́wạ́ võ rî nõ ꞌá gólĩyî drí ngá nyãnyã ûsúzó. ");
INSERT INTO avu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ní îcâ drẽ gólĩyî âyélé, tãlâ õnĩ ró ĩyî bê ngá nyãnyã ndãlé gĩlí ĩyî drí nyãlé võ mvá ãzâ ꞌbá yî õjílã bê rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Gõꞌdá nĩngá sĩ, Yésũ drí tã lôgõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ãnî rî gógó, nĩ fẽ ngá nyãnyã õjílã rî ꞌdĩ ꞌbá yî drí nyãlé kẽ.” Nĩngá sĩ, lãjóꞌbá ꞌdĩ ꞌbá yî drí ngãzó tã îjílí kĩ nĩ rî, “Mã âꞌdô ꞌẽꞌá lâ ángô tí ró yã? Ngá ꞌdĩ lẽ íyíkâ cú lãfâ ãmbá ngá nyãnyã ndrô ãlô rî kâ gĩzó ĩꞌdî dũû îcálé fẽlé õjílã rî nõ ꞌbá yî drí ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Gõꞌdá nĩngá sĩ, Yésũ drí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îjízó kĩ nĩ rî, “Ãmbãtã ãnî drı̣́gạ́ õꞌbí ꞌdĩ ꞌbá yí bê tạ̃sı̣̂ yã? Nĩ ngâ drẽ ndrẽlâ.” Ĩtí, lãjóꞌbá ꞌdĩ ꞌbá yî drí ngãzó nĩlí ngá nyãnyã ndrẽlé õꞌbí ꞌdĩ ꞌbá yî drı̣́gạ́ sĩ. Gõꞌdá gólĩyî ûsû ãmbãtã cé njı̣̂ gõꞌdá ı̣̃ꞌbı̣̂ mvá bê rı̣̃. Nĩngá sĩ, lãjóꞌbá ꞌdĩ ꞌbá yî drí gõzó ngá nyãnyã ꞌdî bê âꞌdálé Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Võ ꞌdî ꞌá tólâ rî, õmã ạ̃rú dı̣̂rı̣̂ bê rĩꞌá ı̣̃nyạ́kú drı̣̃ı̣̂ kpạ̃ạ́kũ. Nĩngá sĩ, Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí, tãlâ gólĩyî õlônyĩ ró õꞌbí ꞌdĩ ꞌbá yî lãfálé lâ rĩlí õmã ạ̃rú ꞌdî drı̣̃ı̣̂ võ ꞌásĩ tũ tũ ngĩíngî. ");
INSERT INTO avu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ĩtí, õꞌbí ꞌdĩ ꞌbá yî drí rĩzó ĩyî vũdrı̣́ võ ꞌásĩ tũ tũ. ꞌDĩî rî, õjílã ũrûkậ ꞌbá yî võ ãlô ꞌá kámá-ãlô gõꞌdá ãzâ ꞌbá yî rĩꞌá nyâꞌdî-rı̣̃-drı̣̃-lâ-ngâ-mûdrı̣́. ");
INSERT INTO avu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nĩngá sĩ, Yésũ drí ãmbãtã njı̣̂ gõꞌdá ı̣̃ꞌbı̣̂ rı̣̃ ꞌdî bê âtrõzó. Drílâ võ ndrẽzó ꞌbũû ꞌálâ, gõꞌdá drílâ ãwô-ĩtí ꞌẽzó Ôvârí drí tãlâ ngá nyãnyã ꞌdî tãsĩ. Nĩngá sĩ, drílâ ãmbãtã ꞌdî ꞌbá yî ꞌâ lâ ûpı̣̃zó õnyí ró. Gõꞌdá drílâ fẽzó lâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drı̣́gạ́ sĩ, tãlâ gólĩyî õlânjî ró ndrĩ õꞌbí ꞌdĩ ꞌbá yî drí nyãlé. Gólâ ꞌê ı̣̃ꞌbı̣̂ rı̣̃ ꞌdî ꞌbá yî kpá té õzõ drílâ ãmbãtã ꞌẽrẽ kâtí lânjílí õꞌbí ꞌdĩ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ĩtí rî, õꞌbí ꞌdĩ ꞌbá yî drí ngá nyãzó dũûdû. Ngá nyãnyã drí gólĩyî pẽzó. ");
INSERT INTO avu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vólé drı̣̃ lâ ꞌásĩ, lãjóꞌbá ꞌdĩ ꞌbá yî drí ngãzó ngá nyãnyã ạ̃mbúkũ lâkí ꞌbá trá rî ꞌbá yî êꞌbélé. Ĩtí rî, ngá nyãnyã ạ̃mbúkũ gólĩyî drí êꞌbélé ꞌdĩ îcâ trá cú ívõ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌásĩ dũûdû. ");
INSERT INTO avu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Gõꞌdá ãgô ndrĩ ngá ꞌdĩ nyã ꞌbá trá rî yî rĩꞌá kútũ-njı̣̂. ꞌDĩî rî, ólãá õkó kô ꞌdĩyímvá bê. ");
INSERT INTO avu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nĩngá sĩ, Yésũ drí ngãzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí, tãlâ gólĩyî õmbã ró ꞌwãâ kõlóngbõ ꞌá, ãꞌdô ró bê gólĩyî drí lậvũzó ạ̃tı̣́ ꞌálâ jạ̃rı̣́bạ̃ zı̣̃lı̣́ Bẽtãsédã rî ꞌálâ gõlé lı̣̃mvû ândrê ꞌdĩ ꞌáꞌá lé drílâ ı̣̃tú drí fĩrĩ ꞌálâ ró rî lésĩ. Gõꞌdá gólâ rî gógó âꞌdô íyíkâ lâkíꞌá tãkõ, tãlâ õꞌbí ꞌdĩ ꞌbá yî jõlé gõlé ꞌbã ꞌálâ. Nĩngá sĩ, lãjóꞌbá ꞌdĩ ꞌbá yî drí tã Yésũ drí âtálé ꞌdĩ ꞌẽzó té ĩtí. ");
INSERT INTO avu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Gõꞌdá õꞌbí ꞌdĩ ꞌbá yî lậvũlı̣́ bê trá gõlé ĩyî drí ꞌbã ꞌásĩ rî, Yésũ drí ngãzó nĩꞌá mbãlé únı̣́ drı̣̃ ꞌálâ rãtáã ꞌẽlé Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Vó lâ sĩ, võ drí ậnı̣́rı̣̃ ꞌá ꞌdĩ, kõlóngbõ tíbê lãjóꞌbá bê yí ꞌá ꞌdĩ trá lı̣̃mvû ândrê ító ꞌâ ꞌá. ꞌDĩî Yésũ rî gógó íyíkâ élêwálâ lı̣̃mvû ândrê gãrã drı̣̃ ãzâ rî lésĩ únı̣́ drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Gõꞌdá nĩngá sĩ, kạ̃gũmạ́ạ̃ ândrê drí ngãzó rĩꞌá ậsı̣̃lı̣́ rĩí rĩí rĩí lı̣̃mvû ândrê drı̣̃ı̣̂ sĩ. Bê trá ĩtí rî, lãjóꞌbá ꞌdĩ ꞌbá yî drí lâŋõ ândrê ûsúzó kõlóngbõ ꞌdî zẽrẽ ꞌá vólé kạ̃gũmạ́ạ̃ ꞌdĩ drí sĩ. Gólĩyî ûjũ kpı̣̃ı̣̂ kõlóngbõ ꞌdî zẽlé sı̣́sı̣́ ꞌálâ ró fê sĩ. Gõꞌdá Yésũ ndrê bê rî, lãjóꞌbá íyíkâ trá lâŋõ ândrê ꞌá. Ị̃tú-pá sû ngá drí ậwúrı̣̃ sĩ, drílâ gõzó ngãlé nĩꞌá lı̣̃mvû ândrê ꞌdĩ tı̣́ ꞌálâ. Tólâ gólâ drí ngãzó rĩꞌá nĩlí lı̣̃mvû drı̣̃ı̣̂ sĩ, nĩꞌá lãjóꞌbá íyíkâ kõlóngbõ ꞌá ꞌdĩ ꞌbá yî ngálâ. ");
INSERT INTO avu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî ndrê gólâ bê rĩꞌá ânĩꞌá lı̣̃mvû drı̣̃ı̣̂ sĩ ĩyî ngálâ rî, drílĩyî ngãzó trẽlé ûrû kĩ nĩ rî, “Wúûwú, nĩ ndrê drẽ ngá ꞌbã ꞌbá ânĩꞌá nã, ãvõ líndrí ꞌî, rĩꞌá ânĩꞌá nã.” ");
INSERT INTO avu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gõꞌdá gólĩyî ndrê gólâ bê ĩtí lâ ꞌdĩ ró rî, líndrí lâ yî drí lôꞌbézó dı̣̃ı̣̃ ũrı̣̃ drí. Ĩtí rî, kôrô Yésũ drí ngãzó tã âtálé gólĩyî drí kĩ nĩ rî, “Nĩ âꞌdô kô ũrı̣̃ ró. Nĩ ậtũ ãnî fĩî, nõô mâ rî gógó Yésũ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Vó lâ ꞌásĩ, drílâ ngãzó mbãlé fĩlí kõlóngbõ ꞌálâ gólĩyí bê. Gõꞌdá kôrô ĩlî ândrê ꞌdĩ drí âdrézó. Nĩngá sĩ, lãjóꞌbá ꞌdĩ ꞌbá yî tı̣̂ lâ ĩyî drí ậꞌdı̣́zó, gõꞌdá sı̣́-ꞌbálé drí rĩzó kãꞌdã. Tã ı̣̂sũ gólĩyíkâ kĩ, “ꞌÁ! Nõtí nõ ãꞌdô tã ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gólĩyî tı̣̂ ậꞌdı̣̂ trá, tãlâ mbârâkã Yésũ drí ãmbãtã njı̣̂ fẽzó õꞌbí drí rî, tã lâ fí gólĩyî drı̣̃ı̣̂ kô. ");
INSERT INTO avu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tólâ sĩ, Yésũ yî drí lı̣̃mvû ândrê ꞌdĩ drı̣̃ lâ mbãzó kõlóngbõ sĩ, gõzó cãlé ꞌbạ̃drı̣̃ zı̣̃lı̣́ Gẽnẽsãrétẽ rî ꞌálâ. Gõꞌdá mbã ĩyî lı̣̃mvû ândrê ꞌdĩ bê rî, drílĩyî ngãzó kõlóngbõ ꞌdî sẽlé ômbélé gạ́ lı̣̃mvû tı̣́. ");
INSERT INTO avu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Gõꞌdá nĩngá sĩ, gólĩyî õtírĩ kõlóngbõ ꞌdî âyé rî, õjílã tólâ nã, drílĩyî kôrô Yésũ rî nı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Gõꞌdá nĩngá sĩ, drílĩyî ngãzó lậꞌbúlı̣́ nĩlí ꞌwãâꞌwâ ĩyî drí ꞌbã ꞌásĩ tã pẽlé õjílã drí ndrĩ kĩ, Yésũ âcâ trá. Gõꞌdá ꞌbạ̃drı̣̃ ꞌdî ꞌásĩ ndrĩ, õjílã drí ngãzó ngá lãzé ꞌbá ĩyíkâ ậnjı̣̃lı̣́ gbãrãkã sĩ ânĩzó âjílâ ĩyî Yésũ ngálâ. ");
INSERT INTO avu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jạ̃rı̣́bạ̃ ꞌásĩ gõꞌdá kpá ꞌbạ̃drı̣̃ ꞌásĩ ndrĩ, õzõ Yésũ ãâcâ trá rî, órî ngá lãzé ꞌbá âtrõlé âjílí võ rĩzó ngá lậzı̣́lı̣́ rî ꞌá. Tólâ rî, ngá lãzé ꞌbá rî ĩyî rúꞌbạ́ lôꞌbãlé Yésũ drí kĩ nĩ rî, “ꞌDõvó mã dõ cé ítá tı̣̂ áníkâ ĩꞌdî, tãlâ mã ngâ ró ngá lãzé ꞌásĩ.” Gõꞌdá ngá lãzé ꞌbá ndrĩ kậkậrậ ítá tı̣̂ Yésũ kâ sõlé rî dõ ꞌbá trá rî drí ngãzó ngá lãzé ꞌásĩ âꞌdólé ndı̣̂ndı̣̂. ");
INSERT INTO avu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ị̃tú ãzâ sĩ, Pạ̃rúsı̣̃ Yẽrõsãlémã lé ꞌbá ró rî ꞌbá yî drí ânĩzó Yésũ ngálâ gólĩyî tã lãꞌbí kâ îmbá ꞌbá ãzâ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Gólĩyî ndrê tã ârí ꞌbá Yésũ kâ ãzâ ꞌbá yî trá ngá nyãnyã nyãꞌá ĩyî cú ĩtí ĩyî drı̣́ jĩ ãkó tãndí ró bũúũ drı̣́ kûlúgûsú ꞌásĩ. Âꞌdô lãꞌbí gólĩyíkâ vó ró rî, gólĩyî drı̣́ drẽ ꞌdó ı̣̃ndı̣̂ ró. ");
INSERT INTO avu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nĩ ndrê trá Pạ̃rúsı̣̃ yî gõꞌdá õjílã õrĩ Yúdạ̃ yí kâ ãzâ ꞌbá yí bê drẽ zãâ ndrĩ lãꞌbí ĩyî ạ́ꞌbı̣́yạ́ yí kâ ꞌdãꞌá. Lãꞌbí ꞌdĩ âꞌdâ gólĩyî drí lạ́tı̣̂ mbı̣̂mbı̣̂ ꞌî gólĩyî drí ĩyî drı̣́ jĩzó drẽ ãkpãkãꞌdã sı̣́sı̣́ ngá nyãnyã nyã ãkó rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Gõꞌdá kpá õzõ Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî õgî ngá nyãlé rî yî trá rî, gólĩyî jĩ zãlô sı̣́sı̣́ drẽ gólĩyî drí nyã ãkó lâ. Lãꞌbí gólĩyíkâ ꞌdĩ âꞌdâ gólĩyî drí kpá lạ́tı̣̂ tãndí ngá ãzâ ꞌbá yî ngá nyãnyã tãsĩ õzõ ĩgã yî, límvó yî, sãánĩ yî, gõꞌdá kpá kõjõrónĩ yî tí rî jĩjĩ âꞌdólé ngbángbá ı̣̃ndı̣̂ ãkó rî tãsĩ, tãlâ Ôvârí õzó ĩyî ndrẽê ı̣̃ndı̣̂ ꞌbá ró kô. ");
INSERT INTO avu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tãlâ lãꞌbí ãmbá ꞌdĩ ꞌbá yî tãsĩ rî, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî gõꞌdá gólĩyî tã lãꞌbí kâ îmbá ꞌbá ꞌdĩ ꞌbá yí bê drí ngãzó Yésũ rî îjílí kĩ nĩ rî, “Tã ârí ꞌbá áníkâ ꞌdĩ ꞌbá yî ꞌdá ĩyî lãꞌbí ãmâ ạ́ꞌbı̣́yạ́ yí kâ lôpélé ãmâ drí rî kô ãꞌdô tãsĩ yã? Gólĩyî jĩí ĩyî drı̣́ kô bũúũ drı̣́ kûlúgûsú ꞌásĩ drẽ ãkpãkãꞌdã ngá nyã ãkó. Õzõ gólĩyî õnyâ ngá trá rî, gólĩyî drı̣́ âꞌdó kô ngbángbá lãꞌbí ãmákâ rî vó ró.” ");
INSERT INTO avu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Gõꞌdá nĩngá sĩ, Yésũ drí tã ꞌdî drı̣̃ lâ lôgõzó kĩ nĩ rî, “Ãnî rĩꞌá ãndõtô kâtí drı̣̃ bê rı̣̃ Ôvârí rî tãsĩ. Tã ậngũ ꞌbá Ĩsáyã îgĩ tã pạ̃tı̣́ı̣̃ trá ãnî tãsĩ ạ̃kû ró kĩ nĩ rî, ‘Õjílã nô ꞌbá yî ı̣̂njı̣̃ ĩyî mâ cú ĩtí ĩyî tı̣̂ sĩ, gõꞌdá gólĩyî ꞌbãá ámâ lôvó kô ĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gólĩyî ı̣̂njı̣̃ ĩyî mâ cú ĩtí tı̣̂ sĩ, tãlâ tã drílĩyî rĩꞌá îmbálâ rî ꞌbá yî âꞌdó kô mâ Ôvârí ngá lésĩ. Tã drílĩyî rĩꞌá îmbálâ ꞌdĩ ꞌbá yî rĩꞌá cé lãꞌbí õjílã mvá kâ ꞌî.’ ");
INSERT INTO avu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nĩ âyê tã Ôvârí drí ꞌbãlé rî yî trá vólé gõꞌdá nĩ rî trá cé ãnîngá lãꞌbí õjílã mvá kâ âꞌdálé ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nĩngá sĩ, Yésũ âtâ úlı̣́ ãzâ kpá gólĩyî drí kĩ nĩ rî, “Pạ̃tı̣́ı̣̃ nĩ ı̣̂sũ ãníkâ bê rî, ꞌdĩî âꞌdô rĩꞌá tã tãndí ꞌî yã? Gõꞌdá ãnî drí rĩzó tã Ôvârí drí ꞌbãlé rî gãlé dó, gõzó rĩlí lãꞌbí ãnî nyãányâ kâ rî ꞌbá yî ꞌdãlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Músạ̃ kĩ nĩ rî, ‘Ní ı̣̂njı̣̃ ánî átá ánî ândré bê.’ Âfõ-âfõ 20.12 Gõꞌdá ‘Õzõ õjílã ãzâ ãâtâ úlı̣́ õnjí trá átá lâ rú ngãtá ândré lâ rú yã rî, áâꞌdô gólâ rî fũꞌá vólé.’ ");
INSERT INTO avu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ꞌDĩî tã Ôvârí drí âtálé trá rî ĩꞌdî. Gõꞌdá nĩ ró úlı̣́ rî ꞌdĩ kô, tãlâ lãꞌbí ãníkâ zı̣̃lı̣́ Kõrõbánĩ ꞌdĩ tãsĩ. Âꞌdô lãꞌbí Kõrõbánĩ kâ vó ró rî, õjílã ãzâ âtâ tã trá nõtí, ‘Ngá nõ ꞌbá yî ndrĩ Ôvârí kâ ĩꞌdî.’ Gõꞌdá ꞌdĩî vósĩ rî, tã ꞌbãꞌbã gólâkâ Ôvârí drí rî tãsĩ, îcá kô drílâ ngá ꞌdĩ ꞌbá yî fẽlé íyî átá yî drí íyî ândré bê. ");
INSERT INTO avu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Lãꞌbí rî ꞌdĩ tãsĩ, ãnî Pạ̃rúsı̣̃, nĩ âyé gólĩyî lãꞌbí Kõrõbánĩ kâ ꞌdã ꞌbá ꞌdĩ ꞌbá yî kô ngá ãzãkã ꞌẽlé ĩyî átá yî drí ĩyî ândré yí bê, tãlâ ngá ĩyíkâ ndrĩ âꞌdô trá Ôvârí kâ. ");
INSERT INTO avu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lãꞌbí rî ãnî drí rĩꞌá lôpélâ ạ̃tı̣́lı̣́ ạ̃tı̣́lı̣́ ãnî ózõwá yî drí ꞌdĩ ꞌbá yî ꞌê úlı̣́ Ôvârí drí ꞌbãlé trá rî âꞌdólé ãyõ ró ífí ãkó. Gõꞌdá nĩ rî kpá trá tã ányâ ãzâ ꞌbá yî îmbálé õzõ ꞌdĩî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nĩngá sĩ, Yésũ drí ngãzó õjílã ậzı̣́lı̣́ dũû ânĩlí úlı̣́ íyíkâ ârílí. Gólâ kĩ gólĩyî drí rî, “Ãnî ndrĩ, nĩ ârî úlı̣́ ámákâ nõ ꞌbá yî õfî ró ãnî drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngá rĩ ꞌbá õjílã îzãlé Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî íyíkâ ãꞌdô ꞌî yã? Âꞌdó kô ngá gólâ fĩ ꞌbá õjílã ꞌâ kôrô sı̣́-ꞌbálé ꞌásĩ rî ĩꞌdî, íyîngá ngá gólâ rĩꞌá lậpı̣́lâ zãâ pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ĩtí rî, ãnî cú bı̣́ bê yã? ꞌDõvó nĩ ârî úlı̣́ ámákâ nõ ꞌbá yî ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nĩngá sĩ, Yésũ yî drí ngãzó tã ârí ꞌbá íyíkâ rî ꞌbá yí bê õꞌbí dũû ꞌdĩ ꞌbá yî âyélé ngãzó fĩlí jó ꞌálâ. Jó ꞌdĩ ꞌá tólâ rî, tã ârí ꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí ngãzó Yésũ rî îjílí úlı̣́ mãnĩgõ tã õjílã îzã ꞌbá rî kâ ĩtõ lâ lôfõlé ĩyî drí. ");
INSERT INTO avu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nĩngá sĩ, Yésũ drí ngãzó drı̣́-mbílí sõlé gólĩyî lı̣̃fı̣́ úlı̣́ âtâ-âtâ sĩ kĩ, “Tã nô fí drẽ zãâ ãnî drı̣̃ı̣̂ kô yã? Nyãsá gólâ ãnî drí nyãlé rî îzãá ãnî kô, ");
INSERT INTO avu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tãlâ nyãsá rî gógó ꞌdĩ lậpı̣́ rû ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌá kô. Nyãsá rî ꞌdĩ fî rĩlí õjílã fĩî ꞌá, gõꞌdá drílâ lậꞌbúzó rúꞌbạ́ ꞌásĩ.” Úlı̣́ nõ ꞌbá yî sĩ, Yésũ âꞌdâ tã ꞌî kĩ nĩ rî, ngá õjílã drí rĩꞌá nyãlâ rî ꞌbá yî ndrĩ tãndí ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nĩngá sĩ, Yésũ drí tã rĩ ꞌbá õjílã îzãlé rî ꞌbá yî lôfõzó nõtí, “Tã ı̣̂sũ-ı̣̂sũ õnjí õjílã kâ ꞌálé lésĩ ró rî ĩꞌdî rĩ ꞌbá gólâ rî îzãlé rî. ");
INSERT INTO avu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Tã õnjí ꞌdĩ ꞌbá yî ndrĩ âfî tã ı̣̂sũ-ı̣̂sũ õnjí õjílã kâ rî ꞌásĩ, õkó zı̣̃zı̣̃, ãgô ndãndã, ûgũ, õjílã fũfũ, ãvẽ, ngá õjílã kâ lôvó lâ ꞌbãꞌbã, tã õnjí ꞌẽꞌẽ ãzí-ãzí drí, âdômâ, tã õnjí lôvó tã õnjí ꞌẽzó, õjílã ndrı̣̃ndrı̣̃, õjílã ꞌdãꞌdã, ạ́rú-ạ́rúwạ́, tã õfô ꞌẽꞌẽ. ");
INSERT INTO avu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tã õnjí ꞌdĩ ꞌbá yî ndrĩ ꞌdó rî âfõlé õjílã ꞌásĩ. Gõꞌdá tã rî ꞌdĩ ꞌbá yî ĩꞌdî rĩ ꞌbá õjílã îzãlé rî.” ");
INSERT INTO avu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tólâ sĩ, Yésũ drí ngãzó nĩlí ꞌbạ̃drı̣̃ ãnyî jạ̃rı̣́bạ̃ zı̣̃lı̣́ Tírã rî lạ̃gạ́tı̣́ rî ꞌálâ. Gõꞌdá gólâ câ bê tólâ rî, drílâ fĩzó jó ãzâ ꞌá kírî rĩlí tı̣́ õjílã drí sĩ, tãlâ gólâ lẽé kô õjílã drí võ yí drí rĩzó ꞌá lâ rî nı̣̃lı̣́. Tákõ gólâ lậpı̣̂ rû bê kpálé õjílã drí sĩ rî, õjílã ûsû gólâ rî võ trá. ");
INSERT INTO avu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Gõꞌdá võ rî ꞌdĩ ꞌá rî, õkó ãtrâ ãzâ bê rĩꞌá ꞌbạ̃súrú Gı̣̃rı̣́kı̣̃ kâ ꞌásĩ. Útı̣̂ gólâ trá võ zı̣̃lı̣́ Sírĩyã rî ꞌálâ rî. Õkó rî ꞌdĩ cú mvá ãnjó bê, líndrí õnjí rî trá ômbélâ. Nĩngá sĩ, õkó rî ꞌdĩ drí tã ârízó kĩ nĩ rî, Yésũ âcâ trá. Drílâ ânĩzó kôrô íyî âdãlé ạ̃drũ ı̣̃nyạ́kú drı̣̃ı̣̂ Yésũ ândrá rúꞌbạ́ lôꞌbã-lôꞌbã sĩ Yésũ drí kĩ nĩ rî, gólâ õlôfõ líndrí õnjí nã vólé íyî mvá ãnjó ró nã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Gõꞌdá Yésũ drí ngãzó tã-drı̣̃ lôgõlé drílâ úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Ní âyê má fẽ ró ngá nyãnyã sı̣́sı̣́ ámâ mvá yî nyãányâ rî yî drí. Âꞌdó kô rĩꞌá mbı̣̂ ngá nyãnyã ꞌdĩyímvá sı̣́lı̣́ sĩ rî âtrõzó vólé fẽlé ãnî õké drí nyãlé.” ");
INSERT INTO avu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nĩngá sĩ, õkó rî ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Kúmú, õzõ ãꞌdô kpálé ĩtí rî, ꞌdĩî rĩꞌá úlı̣́ mbı̣̂ ꞌî, gõꞌdá õké gólĩyî vũ ꞌbá tãrãbízã zẽlé rî îcâ ĩyî kpá trá ngá nyãnyã lôꞌdé ꞌbá ꞌdĩyímvá drı̣́gạ́ sĩ rî nyãlé.” ");
INSERT INTO avu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nĩngá sĩ, úlı̣́ õkó ꞌdĩ kâ lôgõlé ꞌdĩ drí sũzó Yésũ bı̣́lı̣́ tákányĩ. Gõꞌdá Yésũ drí ngãzó tã âtálé õkó ꞌdĩ drí kĩ nĩ rî, “Tãlâ úlı̣́ ní drí âtálé trá ꞌdĩ tãsĩ rî, líndrí õnjí nã ódrô trá vólé ánî mvá ãnjó nã ꞌásĩ. ꞌDõvó ní ngâ gõlé ꞌbã ꞌálâ gólâ rî ndrẽlé.” ");
INSERT INTO avu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tólâ sĩ, õkó ꞌdĩ drí ngãzó gõlé ꞌbã ꞌálâ. Drílâ íyî mvá ãnjó ꞌdĩ ûsúzó ậyı̣́ꞌá gbãrãkã drı̣̃ı̣̂. Tã pạ̃tı̣́ı̣̃ ró, líndrí õnjí ꞌdĩ fõ trá gólâ ꞌásĩ vólé. ");
INSERT INTO avu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tólâ sĩ, Yésũ drí ngãzó nĩlí kôrô võ ãnyî Tírã rú rî ꞌásĩ. Gólâ nĩ lậvũlı̣́ ꞌdĩ kôrô jạ̃rı̣́bạ̃ zı̣̃lı̣́ Sĩdónã rî rú sĩ. Nĩngá sĩ, drílâ nĩzó lậmúlı̣́ dîrî lı̣̃mvû ândrê zı̣̃lı̣́ Gãlĩláyã rî rú sĩ bũúũ drílâ cãzó ꞌbạ̃drı̣̃ gólâ jạ̃rı̣́bạ̃ bê mûdrı̣́ rî ꞌá rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tólâ rî, õjílã drí ngãzó ãgô ãzâ bı̣́-ꞌbálé ãkó rî âtrõlé âjílí Yésũ ngálâ, gólâ õpâ ró ãgô rî ꞌdĩ drı̣́ ꞌbãꞌbã sĩ drı̣̃ lâ. Ãgô rî gógó ꞌdĩ îcá kpá kô úlı̣́ âtálé kpĩyã-kpĩyã ró. ");
INSERT INTO avu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nĩngá sĩ, Yésũ drí ãgô ꞌdĩ âtrõzó élêwálâ õjílã dũû ꞌdĩ ꞌbá yî lãfálé ꞌásĩ. Drílâ ngãzó íyî drı̣́-mvá sõlé ãgô rî ꞌdĩ bı̣́-ꞌbálé lâ ꞌá. Nĩngá sĩ, Yésũ drí tũ wũzó íyî drı̣́-mvá ꞌá, gõꞌdá drílâ bẽzó lâ ãgô ꞌdĩ lãndrâ lâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gõꞌdá nĩngá sĩ, Yésũ drí võ ndrẽzó ûrú ꞌálâ ꞌbũû ꞌálâ. Nĩngá sĩ, drílâ lôvózó kẽfẽẽ mbârâkã ûsúzó ngá pãpã ꞌẽzó ĩꞌdî sĩ lâ. Gólâ âtâ tã trá íyî tı̣̂ sĩ ãgô ꞌdĩ bı̣́-ꞌbálé lâ tãsĩ gólâ rî lãndrâ bê kĩ nĩ rî, Éfãtã. Ĩtõ lâ kĩ, “‘Nĩ njı̣̃ rû”’. ");
INSERT INTO avu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ĩtí rî, ãgô ꞌdĩ bı̣́-ꞌbálé lâ drí rû njı̣̃zó, drílâ tã ârízó. Gõꞌdá kpá lãndrâ lâ drí rû înjízó úlı̣́ âtálé ngbạ́lạ́-ngbạ́lạ́ dódó. ");
INSERT INTO avu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Vó lâ sĩ, Yésũ drí ãgô ꞌdĩ âtrõzó lôgõlé vólé õjílã dũû ꞌdĩ ꞌbá yî válâ. Gõꞌdá nĩngá sĩ, Yésũ drí tã ꞌbãzó gólĩyî drí ngbílí-ngbílí kĩ nĩ rî, “Nĩ pẽ tã lârâkô nõ tã lâ kô õjílã ãzâ drí ãlôwálâ.” Gõꞌdá bê kpálé ĩtí rî, õjílã ꞌdî ꞌbá yî ârí ĩyî úlı̣́ Yésũ kâ ꞌdĩ kô. Gõꞌdá drílĩyî ngãzó nĩlí tã lâ pẽ bê õjílã drí ãkí ãkó. ꞌDĩî Yésũ íyíkâ zãâ rĩꞌá tã pẽꞌá õjílã drí, tãlâ gólĩyî õzó tã tã lârâkô ꞌdĩ kâ ꞌbãâ lậꞌbúlı̣́ fãã. Gõꞌdá gólĩyî ĩyîngá gbõ zãâ tã ꞌdî lôpéꞌá õjílã ãzâ ꞌbá yî drí ạ̃tı̣́ ꞌálâ, tãlâ tã rî ꞌdĩ õlậꞌbû ró bê õjílã drí ârílí ndrĩ kậkậrậ. ");
INSERT INTO avu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ĩtí rî, gólĩyî tã rî ꞌdĩ ârí ꞌbá trá rî yî, tı̣̂ lâ yî drí ậꞌdı̣́zó ndrúndrú. Gõꞌdá nĩngá sĩ, drílĩyî tã âtázó Yésũ rî tãsĩ kĩ nĩ rî, “Gólâ ꞌê tã trá ndrĩ dódó. Tã gólâkâ ꞌdĩ tã ạ́ngı̣́ ꞌî. Gõꞌdá gólâ êdê ãgô bı̣́-ꞌbálé ãkó ꞌdĩ trá tã ârílí, gõꞌdá gólâ êdê ãgô ũdũrũdú ró rî kpá trá úlı̣́ âtálé kpĩyã-kpĩyã dódó.” ");
INSERT INTO avu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ị̃tú ãzâ sĩ, õjílã tı̣́lı̣́lı̣́ ãzâ ꞌbá yî drí ngãzó ĩyî êꞌbélé ꞌdẽlé Yésũ vó. Gólĩyî ꞌê trá Yésũ yí bê kậyı̣̂ nâ. Gõꞌdá nĩngá sĩ rî, ngá nyãnyã gólĩyíkâ ndẽ rû trá. Tã rî ꞌdĩ tãsĩ rî, Yésũ ní drí ngãzó lãjóꞌbá áníkâ rî ꞌbá yî ậzı̣́lı̣́ ní ngálâ, gõꞌdá ní drí tã âtázó gólĩyî drí kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mâ rĩꞌá ĩzã ró õjílã tı̣́lı̣́lı̣́ nõ ꞌbá yî tãsĩ. Mã rî trá gólĩyí bê kậyı̣̂ nâ, gõꞌdá ngbãângbânõ rî, gólĩyî trá cú ĩtí ngá ãzâ ãkó ĩyî drı̣́gạ́ nyãlé. ");
INSERT INTO avu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Õzõ má õjô gólĩyî nĩlí gõlé ĩyî drí ꞌbã ꞌásĩ cú ĩtí ngá nyãnyã fẽ ãkó sı̣́sı̣́ gólĩyî drí rî, gólĩyî lı̣̃fı̣́ âꞌdô ậnı̣́ꞌá lạ́tı̣̂ ꞌá lõfó drí sĩ, tãlâ gólĩyî ãzâ ꞌbá yî ânĩ ĩyî trá võ jẽjẽ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nĩngá sĩ, lãjóꞌbá gólâkâ rî ꞌbá yî drí ngãzó úlı̣́ ꞌdĩ drı̣̃ lâ lôgõlé gólâ drí kĩ nĩ rî, “Nõô rĩꞌá võ ngbángbá ꞌãꞌí ꞌî ꞌbã ãzãkã ãkó. Gõꞌdá trá ĩtí rî, mã âꞌdô îcáꞌá trá ngá nyãnyã ûsúlı̣́ võ rî nõ ꞌá fẽlé õjílã rî tı̣́lı̣́lı̣́ ró nõ ꞌbá yî drí yã?” ");
INSERT INTO avu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bê trá ĩtí rî, Yésũ drí ngãzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îjílí kĩ nĩ rî, “Ãnî ndrĩ ꞌdó õjílã ꞌdî ꞌbá yí bê rî, ãmbãtã bê ãnî drı̣́gạ́ tạ̃sı̣̂ yã?” Gõꞌdá lãjóꞌbá drí tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Bê rĩꞌá njı̣̂-drı̣̃-lâ-rı̣̃.” ");
INSERT INTO avu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ĩtí rî, Yésũ drí ngãzó tã âtálé õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí kĩ, gólĩyî õrî vũdrı̣́. Vó lâ sĩ rî, drílâ ngãzó ãmbãtã njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdî ꞌbá yî âtrõlé. Drílâ gõzó ãwô-ĩtí ꞌẽlé Ôvârí drí tã lâ sĩ. Nĩngá sĩ, drílâ ãmbãtã ꞌdî ꞌbá yî ꞌâ lâ ûpı̣̃zó gõzó trõlâ fẽlé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí lânjílí õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí. Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí ꞌẽzó lâ té gólâ drí âtálé rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ꞌDĩî rî, ı̣̃ꞌbı̣̂ õnyí kpá bê cé dã ĩtí. Nĩngá sĩ, Yésũ drí ngãzó âtrõlâ, gõꞌdá drílâ ãwô-ĩtí ꞌẽzó kpá Ôvârí drí tã lâ sĩ, gõzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí, õtrõ ró ĩyî kpá ı̣̃ꞌbı̣̂ õnyí ꞌdĩ ꞌbá yî lânjílí õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gõꞌdá nĩngá sĩ, õjílã ꞌdî ꞌbá yî drí ngá nyãzó dũûdû. Gõꞌdá ngá nyãnyã ꞌdî vólé drı̣̃ lâ ꞌásĩ rî, lãjóꞌbá drí ãmbãtã ạ̃mbúkũ ı̣̃ꞌbı̣̂ yí bê lâkí ꞌbá ꞌdĩ ûꞌdúzó lôꞌbãlé dũûdû ívõ ãmbá ãmbá zãlô njı̣̂-drı̣̃-lâ-rı̣̃ rî ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ãgô ngá nyãnyã rî ꞌdĩ nyã ꞌbá rî yî ólã gólĩyî rĩꞌá kútũ-sû. ꞌDĩî rî, ólãá õkó kô ꞌdĩyímvá bê. Tã rî ꞌdĩ vósĩ, Yésũ drí ngãzó õjílã ꞌdî ꞌbá yî jõlé vólé. ");
INSERT INTO avu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nĩngá sĩ, kôrô Yésũ yî drí nĩzó mbãlé kõlóngbõ ꞌá lãjóꞌbá íyíkâ yí bê. Drílĩyî gõzó lı̣̃mvû drı̣̃ mbãlé nĩlí ꞌbạ̃drı̣̃ mvá zı̣̃lı̣́ Dãlãmãnótã rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nĩngá sĩ, Pạ̃rúsı̣̃ ũrûkậ ꞌbá yî drí ngãzó ânĩlí úlı̣́ ngĩlí Yésũ bê, tãlâ gólĩyî lẽ trá Yésũ rî ûjũlı̣́. Ĩtí rî, drílĩyî Yésũ rî îjízó tã lârâkô gólâ tã âꞌdá ꞌbá kĩꞌá nĩ rî, Ôvârí âjô gólâ nĩ rî, âꞌdálé ĩyî drí. Gólĩyî ı̣̂sũ tã kĩ, îcá kô Yésũ drí tã lârâkô ꞌẽzó. ");
INSERT INTO avu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bê ĩtí rî, Yésũ drí ngãzó zõlé tãlâ tã lẽ ãkõ gólĩyíkâ tãsĩ, gõzó úlı̣́ âtálé kĩ nĩ rî, “Ãnî õjílã rĩ ꞌbá ãndrõ nô ꞌbá yî, tãlâ ãꞌdô ꞌî ãnî drí ngãzó rĩꞌá tã tã lârâkô kâ îjílí ndrẽlé, tã âꞌdálé ãnî drí kĩ, Ôvârí âjô mâ nĩ yã? Má âtâ trá ãnî drí, nĩ ndré tã lârâkô ãzãkã tı̣̂, tı̣̂ drí ậꞌdı̣́zó rî gbõ kó kô ãlôwálâ.” ");
INSERT INTO avu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nĩngá sĩ, drílĩyî ngãzó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî âyélé gõzó mbãlé fĩlí kõlóngbõ ꞌá lãjóꞌbá íyíkâ bê óꞌdí. Gõꞌdá Yésũ yî drí ꞌẽrẽ lı̣̃mvû ândrê drı̣̃ mbãlé nĩzó ꞌáꞌá ãzâ rî ꞌálâ rî, ");
INSERT INTO avu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","16","Yésũ drí drı̣́-mbílí sõzó lãjóꞌbá íyíkâ rî ꞌbá yî lı̣̃fı̣́ úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Nĩ ndrê ãnî vó ạ̃kú ódrí ꞌbãlé ãmbãtã ꞌá rî drí sĩ Pạ̃rúsı̣̃ yî drı̣́gạ́ sĩ gõꞌdá kpá õjílã ꞌdẽ ꞌbá Ẽródẽ vó rî ꞌbá yí bê.” Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî nı̣̃ı̣́ ĩyî úlı̣́ mãnĩgõ ꞌdî ífí lâ kô. Drílĩyî rĩzó rĩꞌá úlı̣́ Yésũ kâ ꞌdĩ ngĩlí ĩyî lãfálé ꞌásĩ kĩ nĩ rî, “Gólâ âtâ úlı̣́ rî ꞌdĩ kó ĩtí lâ ꞌdĩ ró, tãlâ ãmâ rĩꞌá ãmbãtã ãkó rî drí.” ");
INSERT INTO avu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ꞌDĩî Yésũ nı̣̃ tã gólĩyíkâ rĩꞌá âtálâ kírî ró ꞌdĩ trá. Gõꞌdá âꞌdólé bê ĩtí rî, Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Nĩ rî tã ãnî drí âꞌdózó ãmbãtã ãkó rî âtálé ãnî lãfálé ꞌásĩ ãꞌdô tãsĩ yã? Tã fí drẽ zãâ ãnî drı̣̃ı̣̂ kô yã? ");
INSERT INTO avu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ãnî rĩꞌá cú lı̣̃fı̣́ bê, ngã nĩ ndré võ kô ãꞌdô tãsĩ yã? Ãnî rĩꞌá cú bı̣́ bê, ngã nĩ ârí tã kô ãꞌdô tãsĩ yã? Ãnî rĩꞌá tã má drí ꞌẽlé trá rî ꞌbá yî ı̣̂sũꞌá yã? ");
INSERT INTO avu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Má õtírĩ ãmbãtã njı̣̂ rî ûpı̣̃ı̣̂ fẽlé õjílã kútũ-njı̣̂ drí nyãlé rî, ívõ lâkí ꞌbá ĩyî dũûdû ngá nyãnyã ạ̃mbúkũ bê ãnî drí ûꞌdúlı̣́ rî tạ̃sı̣̂ yã?” Nĩngá sĩ, drílĩyî tã-drı̣̃ lôgõzó kĩ nĩ rî, “Ívõ dũûdû mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃.” ");
INSERT INTO avu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã îjízó gólĩyî tı̣́ kĩ nĩ rî, “Ngã gõꞌdá má ûpı̣̃ bê ãmbãtã njı̣̂-drı̣̃-lâ-rı̣̃ rî trá fẽlé õjílã kútũ-sû drí nyãlé rî, ívõ ândrê dũûdû ngá nyãnyã ạ̃mbúkũ bê ãnî drí ûꞌdúlı̣́ trá rî rĩꞌá tạ̃sı̣̂ yã?” Gõꞌdá drílĩyî tã lôgõzó kĩ nĩ rî, “Njı̣̂-drı̣̃-lâ-rı̣̃.” ");
INSERT INTO avu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nĩngá sĩ, Yésũ drí tã lôgõzó gólĩyî drí kĩ nĩ rî, “Tã ndrĩ ꞌdî ꞌbá yî ꞌásĩ rî, zãâ tã mbârâkã ámákâ kâ ngá nyãnyã fẽzó ãnî drí õjílã bê rî fí drẽ ãnî drı̣̃ı̣̂ kô yã?” ");
INSERT INTO avu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nĩngá sĩ, Yésũ yî drí nĩzó kõlóngbõ sĩ cãlé jạ̃rı̣́bạ̃ zı̣̃lı̣́ Bẽtãsédã rî ꞌálâ. Tólâ õjílã ãzâ ꞌbá yî drí ãgô ãzâ lı̣̃fı̣́ ãkó rî âtrõzó âjílí Yésũ ngálâ. Gõꞌdá drílĩyî rúꞌbạ́ lôꞌbãzó Yésũ drí, gólâ õꞌbã ró drı̣́ ãgô lı̣̃fı̣́ ãkó ꞌdĩ drı̣̃ı̣̂, tãlâ ãgô rî ꞌdĩ õndrê ró võ bê. ");
INSERT INTO avu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nĩngá sĩ, Yésũ drí ãgô ꞌdĩ drı̣́ lâ ậrúzó âsélé nĩzó ĩꞌdí bê lâ vólé jạ̃rı̣́bạ̃ ꞌásĩ. Gõꞌdá drílâ tũ wũzó pẽ pẽ ãgô ꞌdĩ lı̣̃fı̣́ lâ ꞌá. Drílâ drı̣́ ꞌbãzó kpá lı̣̃fı̣́ lâ ꞌá. Vó lâ sĩ, Yésũ drí gõzó gólâ rî îjílí kĩ nĩ rî, “Nî bí ngá ãzãkã ndrẽꞌá yã?” ");
INSERT INTO avu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gõꞌdá ãgô ꞌdĩ drí võ ndrẽzó dîrî, gõꞌdá drílâ tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Ãwô, mâ bí ngá ndrẽꞌá mãnã-mãnã. Má ndrê õjílã lậmúꞌá má lı̣̃fı̣́ õzõ fê gárá ĩlî drí rĩꞌá îyálâ rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nĩngá sĩ, Yésũ drí drı̣́ ꞌbãzó ãgô ꞌdĩ lı̣̃fı̣́ lâ ꞌá kpá óꞌdí. Gõꞌdá ꞌdĩî vósĩ rî, ãgô ꞌdĩ drí võ ndrẽzó rárá. Pạ̃tı̣́ı̣̃ lı̣̃fı̣́ lâ éêdê trá âꞌdólé sı̣́sı̣́ rî kâtí dódó óꞌdí. ");
INSERT INTO avu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nĩngá sĩ, Yésũ drí ãgô rî ꞌdĩ jõzó mbı̣̂ ꞌbã ꞌálâ, gõꞌdá tã âtázó drílâ kĩ nĩ rî, “Ní gõ vólé kôrô jạ̃rı̣́bạ̃ ꞌásĩ kô, tãlâ tã ánî lı̣̃fı̣́ drí rû êdézó trá dódó ꞌdĩ õzó kô lậꞌbú õjílã drí.” ");
INSERT INTO avu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tólâ sĩ, Yésũ yî lãjóꞌbá íyíkâ rî ꞌbá yí bê drí ngãzó ĩyî nĩlí ꞌbạ̃drı̣̃ mvá ãnyî jạ̃rı̣́bạ̃ zı̣̃lı̣́ Sẽsãréyã Fı̣̃lı̣́pı̣̃ rú rî ꞌálâ. Ãkpãkãꞌdã drẽ lạ́tı̣̂ drı̣̃ı̣̂, Yésũ drí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îjízó kĩ nĩ rî, “Nĩ âtâ drẽ má drí, õjílã kĩ má ãâꞌdô ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nĩngá sĩ, lãjóꞌbá drí tã îjî Yésũ kâ ꞌdĩ drı̣̃ lâ lôgõzó kĩ, “Õjílã ı̣̂sũ tã kĩ, ní ãâꞌdô õjílã ạ̃kû gólâ âgõ ꞌbá ûrú lésĩ rî ĩꞌdî. Õjílã ũrûkậ ꞌbá yî kĩ nĩ rî, ní ãâꞌdô Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî ĩꞌdî. Gõꞌdá õjílã ãzâ ꞌbá yî kĩ nĩ rî, ní ãâꞌdô Ẽlíyã tã ậngũ ꞌbá ró ạ̃kû nã ãâgõ nĩ ûrú lésĩ. Nĩngá sĩ, ãzâ ꞌbá yî kĩ ĩyíkâ, ní ãâꞌdô ãlô tã ậngũ ꞌbá ạ̃kû ró rî yî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ĩtí rî, Yésũ drí ngãzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îjílí kĩ nĩ rî, “Ngã gõꞌdá ãnî, nĩ kĩ ãníkâ rî, má ãâꞌdô ãꞌdî ĩꞌdî yã?” Nĩngá sĩ, Pétẽrõ drí tã îjî Yésũ kâ ꞌdĩ drı̣̃ lâ lôgõzó kĩ nĩ rî, “Nî ꞌdíyî pã ꞌbá gólâ Ôvârí drí âjólé rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ĩtí rî, Yésũ drí tã ꞌbãzó lãjóꞌbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, gólĩyî ãâtâ tã pạ̃tı̣́ı̣̃ gólâ rî tãsĩ ꞌdî kô õjílã ãzâ drí ãlôwálâ. ");
INSERT INTO avu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Vó lâ sĩ, Yésũ drí ngãzó rĩꞌá lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî lı̣̃fı̣́ lâ ĩyî îmbálé kĩ nĩ rî, “Mâ Ôvârí drí âjólé ûrú lésĩ rî íyíkâ kó ĩzã ꞌẽlé tákányĩ. Ĩtí rî, gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yî gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yí bê, gõꞌdá kpá gólĩyî lãꞌbí îmbá ꞌbá rî ꞌbá yí bê âꞌdô ĩyî ámâ gãꞌá dó. Gõꞌdá drílĩyî ámâ fũzó, gõꞌdá kậyı̣̂ nâ sĩ, má âꞌdô lîdríꞌá õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yésũ pẽ úlı̣́ trá trậ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí, gólĩyî ãârî ró ĩyî tã ꞌdî bê dódó. Nĩngá sĩ, Pétẽrõ drí ngãzó Yésũ rî drı̣̃lı̣́ gbíyá vólé ãzí-ãzí ꞌásĩ, gõꞌdá ngãzó rĩꞌá tã lôgõlé Yésũ drí kĩ nĩ rî, “Ní âtâ úlı̣́ ꞌdĩ ꞌbá yî kô. Úfú nî kô.” ");
INSERT INTO avu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Gõꞌdá nĩngá sĩ, Yésũ drí íyî jãzó võ ndrẽlé lãjóꞌbá íyíkâ ngálâ gõzó tã lôgõlé Pétẽrõ drı̣̃ı̣̂ kĩ nĩ rî, “Ní âyê mâ úlı̣́ áníkâ Sãtánã kâ ró ꞌdĩ ꞌásĩ. Tã ní drí âtálé ꞌdĩ âꞌdó kô Ôvârí kâ. ꞌDĩî tã ı̣̂sũ ánî nyãányâ kâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Gõꞌdá nĩngá sĩ, Yésũ drí õjílã dũû ꞌdó tã ârí ꞌbá íyíkâ bê ꞌdĩ ꞌbá yî ậzı̣́zó kpãkã ãlô gõzó tã âtálé gólĩyî drí kĩ nĩ rî, “Õzõ õjílã ãlô ãzâ õlẽ trá ꞌdẽlé má vó tã ârí ꞌbá ró rî, ꞌdõvó gólâ ãâyê tã lôvókô íyî nyãányâ kâ, gõꞌdá gólâ ãꞌdô kpá njãâ drãlé, õzõ õjílã fê lậlı̣̂-lậlı̣̂ íyíkâ njı̣̃ ꞌbá ãꞌdô ró íyî îpázó drı̣̃ lâ rî kâtí. ꞌDõvó gólâ õꞌdê má vósĩ zãâ tã ârí ꞌbá ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Õzõ õjílã ãzâ ãâyê mâ õdrã ũrı̣̃ drí sĩ rî, gólâ trõó lédrẽ-lédrẽ ạ̃dũkũ ãkó rî kó kô. Õzõ tã ârí ꞌbá õrî zãâ tã ámákâ ꞌẽlé tã âtî-âtî Ôvârí kâ bê rî, úũfû gólâ kpálé rî, gólâ âꞌdô rĩꞌá zãâ lédrẽ-lédrẽ ạ̃dũkũ ãkó rî bê. ");
INSERT INTO avu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nĩ ı̣̂sũ tã ãnî lédrẽ-lédrẽ tãsĩ. Õzõ nĩ õlậzı̣̂ ãnî lédrẽ-lédrẽ nyãányâ trá gĩlí vólé, tãlâ lãfâ ndrĩ ꞌbạ̃drı̣̃ nô ꞌá rî ûsúzó rî, nĩ âꞌdô âꞌdóꞌá trá ãyĩkõ ró lãfâ rî ꞌdĩ bê yã? Ĩtí kô, ꞌdĩî nĩ ı̣̂vı̣̃ ngá tã lâ drí ꞌdẽlé kôrô rî trá. ");
INSERT INTO avu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngá ãzâ bê rĩꞌá tólâ õjílã drí íyî lédrẽ-lédrẽ âgízó lôgõlé vólé ĩꞌdî sĩ lâ yã? Ngá ãzãkã yûꞌdạ́wạ́. ");
INSERT INTO avu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ĩtí rî, õzõ õjílã ãzâ õgã mâ trá dó tã má drí rĩꞌá îmbálâ gõꞌdá âtálâ rî ꞌbá yí bê õjílã õnjí ãngó nõ kâ ândrá rî, ĩtí rî, ı̣̃tú tã õnjí kĩ kâ sĩ, mâ gólâ Ôvârí drí âjólé ûrú lésĩ rî âꞌdô kpá gólâ rî gãꞌá dó ı̣̃tú gólâ má õtírĩ âgõô rî ꞌá. Ị̃tú rî ꞌdĩ tú rî, má âꞌdô âgõꞌá cú âꞌdô lânjã Ôvârí kâ bê, gõꞌdá kpá mãlãyíkã tãndí ãkĩ gólâkâ rî ꞌbá yí bê.” ");
INSERT INTO avu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nĩngá sĩ, Yésũ drí kpá úlı̣́ âtázó gólĩyî drí kĩ nĩ rî, “Tã ꞌdî õjâ ãnî drı̣̃ sĩ kô. Õjílã ũrûkậ ꞌbá yî nõngá âꞌdô ꞌbãꞌá ĩyî drẽ zãâ lédrẽ-lédrẽ ró, Ôvârí õtírĩ mbârâkã ạ́ngı̣́ íyíkâ rî âꞌdá ãngó nõ ꞌá rî.” ");
INSERT INTO avu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kậyı̣̂ njı̣̂-kázíyá vósĩ, Yésũ yî drí ngãzó nĩlí. ꞌDĩî gólĩyî Pétẽrõ, Yãkóbã gõꞌdá Yõwánĩ yí bê. Yésũ drí gólĩyî drı̣̃zó nĩzó únı̣́ ãzâ drı̣̃ ꞌálâ ngĩî õjílã ũrûkậ ꞌbá yî ꞌásĩ. Gõꞌdá únı̣́ ꞌdĩ drı̣̃ ꞌá tólâ rî, Yésũ rî lârâkô drí rû ôjázó Pétẽrõ yî lı̣̃fı̣́ drı̣̃ ꞌá Yãkóbã gõꞌdá Yõwánĩ yí bê. ");
INSERT INTO avu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ítá Yésũ kâ drí ngãzó lậgúlı̣́ kạ̃ꞌdậ-kạ̃ꞌdậ, gõꞌdá drílâ rû jãzó mvẽêmvê ró kpírí-kpírí gạ̃rạ̃ ítá gólâ õjílã drí îcálé jĩlâ ãngó ꞌá nõngá rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nĩngá sĩ, Ẽlíyã yî Músạ̃ bê drí âfõzó lãjóꞌbá nâ ꞌdĩ ꞌbá yî ândrá, rĩꞌá ĩyî úlı̣́ âtáꞌá Yésũ yí bê. ");
INSERT INTO avu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Gõꞌdá Pétẽrõ ndrê gólĩyî bê rî, drílâ ngãzó tã âtálé Yésũ drí kĩ nĩ rî, “Kúmú rĩꞌá tã tãndí ꞌî ãmâ drí âꞌdózó ãní bê nõngá. Ĩtí rî, mã âꞌdô gũgũ gãꞌá nâ. ꞌDĩî ãlô ní drí, ãzâ Músạ̃ drí gõꞌdá kpá ãlô Ẽlíyã drí.” ");
INSERT INTO avu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pétẽrõ âtâ úlı̣́ ꞌdĩ tã ı̣̂sũ ãkó, tãlâ gólâ nı̣̃ı̣́ tã yí drí ꞌẽꞌá âtálâ rî kô. Gólâ gõꞌdá lãjóꞌbá ãzâ rı̣̃ rî ꞌbá yí bê trá ũrı̣̃ ró rõô. ");
INSERT INTO avu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nĩngá sĩ, mbãrãsãsã drí ậsı̣́zó ûrú lésĩ gólĩyî lîmólé ndrĩ. Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí úlı̣́ ârízó mbãrãsãsã ꞌásĩ kĩ nĩ rî, “Nõô ámâ mvá nyãányâ má drí lôvó lâ ꞌbãlé rî ĩꞌdî, ꞌdõvó nĩ rî úlı̣́ gólâkâ ârílí.” ");
INSERT INTO avu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nĩngá sĩ, mbãrãsãsã wálé bê rî, lãjóꞌbá ꞌdĩ ꞌbá yî drí ngãzó ꞌwãâ võ ndrẽlé dîrî gbãâ. Drílĩyî cé Yésũ rî ndrẽzó ĩꞌdî ĩyí bê, gõꞌdá Músạ̃ yî Ẽlíyã bê trá yûꞌdạ́wạ́. ");
INSERT INTO avu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Vó lâ ꞌásĩ, gólĩyî õtírĩ rĩî ârílí únı̣́ drı̣̃ lésĩ Yésũ yí bê rî, Yésũ drí ngãzó tã âtálé gólĩyî drí, tãlâ gólĩyî õzó tã gólĩyî drí ndrẽlé trá ꞌdĩ pẽê õjílã ãzãkã ãlôlâ drí. Gólĩyî õꞌbã tã ꞌdî tãkõ ĩyî ꞌá té ı̣̃tú gólâ yí Yésũ drí lîdrízó óꞌdí õdrã ꞌásĩ rî tú. ");
INSERT INTO avu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ĩtí rî, drílĩyî tã Yésũ kâ âtálé ĩyî drí ꞌdĩ ꞌẽzó té ĩtí. Gõꞌdá gólĩyî drí rĩzó kpá ĩyî îjílí ĩyî lãfálé ꞌásĩ úlı̣́ ĩtõ kĩꞌá nĩ rî, lîdrî-lîdrî óꞌdí õdrã ꞌásĩ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Vólé drı̣̃ lâ ꞌásĩ, lãjóꞌbá ꞌdĩ ꞌbá yî drí Yésũ rî îjízó kĩ nĩ rî, “Úlı̣́ lãꞌbí îmbá ꞌbá drí âtálé kĩꞌá nĩ rî, Ẽlíyã âꞌdô âcáꞌá âgõlé zãlô sı̣́sı̣́ ꞌdíyî pã ꞌbá âjólé Ôvârí ngá lésĩ rî drí sĩ rî tã pạ̃tı̣́ı̣̃ ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Nĩngá sĩ, Yésũ drí tã îjî gólĩyíkâ ꞌdĩ drı̣̃ lâ lôgõzó kĩ nĩ rî, “Tã pạ̃tı̣́ı̣̃ ꞌî, rĩꞌá dó Ẽlíyã drí âcázó sı̣́sı̣́ õjílã pı̣̃pı̣̂sı̣́lı̣́ êdélé njãâ âcâ-âcâ ꞌdíyî pã ꞌbá kâ tãsĩ. Má âtâ ãnî drí pạ̃tı̣́ı̣̃ ró, Ẽlíyã âcâ trá. Gõꞌdá õjílã ꞌê ĩyî gólâ trá õnjí ró, õzõ drílĩyî lẽlé rî tí. Gólĩyî ꞌê gólâ té õzõ tã ậngũ ꞌbá drí îgĩlí trá Ẽlíyã rî tãsĩ ạ̃kû ró rî kâtí. Gõꞌdá kpá mâ rî gógó Ôvârí drí âjólé trá ûrú lésĩ nô kâtí, íîgĩ trá kĩ nĩ rî, má âꞌdô ꞌbãꞌá lâŋõ bê rõô. Áâꞌdô ámâ gãꞌá dó. Íîgĩ úlı̣́ ꞌdĩ ꞌbá yî trá ámâ tãsĩ ĩtí ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nĩngá sĩ, Yésũ yî ângâ bê lãjóꞌbá nâ rî ꞌbá yí bê âgõlé lãjóꞌbá ũrûkậ ꞌbá yî ngálâ rî, drílĩyî õjílã tı̣́lı̣́lı̣́ ûsúzó êꞌbê rû ĩyî trá gbãâ lãjóꞌbá rî ꞌdĩ ꞌbá yî rú sĩ. ꞌDĩî lãꞌbí îmbá ꞌbá rî ĩyî kpá bê tólâ rĩꞌá ĩyî tã ôjáꞌá lãjóꞌbá rî ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gõꞌdá ꞌwãâ õjílã drí ndrĩ lı̣̃fı̣́ ꞌbẽzó Yésũ rú ânĩrĩ ꞌá ĩyî lãjóꞌbá nâ rî ꞌbá yí bê. Ĩtí rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó ndrĩ. Õjílã ꞌdî ꞌbá yî drí ngãzó rãlé gólâ ngálâ nî-bê-yã fẽlé gólâ drí. ");
INSERT INTO avu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nĩngá sĩ, Yésũ drí õjílã rî ꞌdĩ ꞌbá yî îjízó kĩ, “Nĩ rî ãꞌdô tã ôjáꞌá ngbãângbânõ lãjóꞌbá ámákâ nõ ꞌbá yí bê yã?” ");
INSERT INTO avu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gõꞌdá nĩngá sĩ, ãgô ãzâ ãlô õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî lãfálé sĩ drí ngãzó tã îjî Yésũ kâ ꞌdĩ drı̣̃ lâ lôgõlé kĩ, “Tã îmbá ꞌbá, má âjî ámâ mvá ágó ró nõ ní ngálâ, tãlâ gólâ rĩꞌá cú líndrí õnjí bê, gõꞌdá ꞌê gólâ trá rĩlí úlı̣́ âtá ãkó. ");
INSERT INTO avu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Líndrí õnjí rî ꞌdĩ rî gólâ rî âsélé âsê gĩ gĩ gĩ vũdrı̣́ cú ãmósá bê yí tı̣́ kạ̃trũ-kạ̃trũ, gõꞌdá nĩꞌá lôngá bê pẽrẽ-pẽrẽ. Nĩngá sĩ, kpá cú sı̣́-gílí nyãnyã bê kítrí-kítrí, gõꞌdá drílâ gólâ rî âsézó kãgãꞌdã. Gõꞌdá má âcálé bê nõngá rî, má ndã nî trá kpı̣̃ı̣̂. Gõꞌdá má drí gbõ lãjóꞌbá áníkâ ꞌdĩ ꞌbá yî îjízó, tãlâ gólĩyî õlôfõ ró ĩyî líndrí õnjí ꞌdĩ ámâ mvá ágó ró nõ ꞌásĩ. Tákõ gólĩyî îcá kô líndrí õnjí ꞌdĩ lôfõlé.” ");
INSERT INTO avu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ nĩ rî, “Ãnî ndrĩ rĩꞌá ꞌdó tã lẽlẽ ãkó. Má âꞌdô rĩꞌá ãnî tã lẽlẽ ãkó ꞌbá bê ạ̃dũkũ lâ cãlé bũúũ ángô tú yã? Nĩ âꞌdô tã âríꞌá ángô tú yã? Nĩ âjî ágámvá ꞌdĩ má ngáá nõlé.” ");
INSERT INTO avu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ĩtí rî, drílĩyî ágámvá ꞌdĩ âjízó Yésũ ngálâ. Nĩngá sĩ, líndrí õnjí rĩ ꞌbá ômbélâ ꞌdĩ ndrê Yésũ bê rî, ꞌwãâ drílâ ágámvá rî ꞌdĩ îngázó vũlı̣́ vũdrı̣́. Gõꞌdá drílâ rĩzó íyî lînyílí ı̣̃nyạ́kú drı̣̃ sĩ, gõꞌdá cú ãmósá bê yí tı̣́ kạ̃trũ-kạ̃trũ. ");
INSERT INTO avu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nĩngá sĩ, Yésũ drí ágámvá ꞌdĩ átá lâ rî îjízó kĩ, “Líndrí õnjí ꞌdĩ îtõ ánî mvá ágó ꞌdĩ ꞌẽlé ángô tú yã?” Ĩtí rî, ágámvá ꞌdĩ átá lâ drí tã Yésũ kâ îjílí ꞌdĩ drı̣̃ lâ lôgõzó kĩ, “Îtõ gólâ trá ạ̃kû ró kó ꞌdĩmvã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gõꞌdá lôꞌbê gólâ kpá trá ândálé ândálé ı̣̃tú ãzâ ꞌbá yî sĩ rî lạ̃sı̣́ ꞌá, gõꞌdá ı̣̃tú ãzâ sĩ rî lı̣̃mvû ꞌá, ãꞌdô ró tíkó drílâ drãzó vólé. Ĩtí rî, ní îcâ trá gólâ rî pãlé yã? Õzõ ní ĩîcâ fí trá rî, ꞌdõvó ní ndrê ãmâ ĩzã. Ní pâ ãmâ.” ");
INSERT INTO avu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nĩngá sĩ, Yésũ drí tã âtázó gólâ drí kĩ nĩ rî, “Ní âtâ trá má drí kĩ, õzõ má ĩîcâ trá rî, má âtâ ní drí, õzõ ní ãꞌdô cú tã lẽlẽ bê Ôvârí ꞌá rî, rĩꞌá tã tãkó ꞌî Ôvârí drí tã cé tı̣̂tı̣̂ ꞌẽzó ní drí.” ");
INSERT INTO avu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gõꞌdá ꞌwãâ, ágámvá ꞌdĩ átá lâ drí ãwó ngõzó kĩ nĩ rî, “Mâ rĩꞌá tã lẽlẽ bê fínyáwá ĩtí, ꞌdõvó ní pâ mâ, má âꞌdô ró tã lẽlẽ bê ạ̃tı̣́ ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nĩngá sĩ, Yésũ drí õjílã tı̣́lı̣́lı̣́ ndrẽzó âráꞌá yí ngálâ. Gõꞌdá gólâ ndrélé bê gólĩyî ĩtí rî, drílâ íyî jãzó líndrí õnjí gólâ ágámvá ꞌdĩ ꞌẽ ꞌbá trá âꞌdólé úlı̣́ âtá ãkó gõꞌdá kpá tã ârí ãkó ꞌdĩ drõzó vólé úlı̣́ âtâ-âtâ sĩ kĩ nĩ rî, “Nî líndrí õnjí ꞌdĩ, ní âfõ vólé gólâ ꞌásĩ. Ní fî gõꞌdá kô gólâ ꞌá kpá óꞌdí.” ");
INSERT INTO avu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nĩngá sĩ, líndrí õnjí ꞌdĩ drí trẽzó ûrû ágámvá ꞌdĩ tı̣̂ lâ sĩ, gõꞌdá ngãzó ágámvá ꞌdĩ âꞌbélé vũdrı̣́, gõꞌdá kpá rĩꞌá gólâ rî îzílí kı̣̃zı̣́-kı̣̃zı̣́. Gõꞌdá drílâ ngãzó âfõlé vólé ágámvá ꞌdĩ ꞌá lâ ꞌásĩ. ꞌDĩî ꞌélé bê rû trá ĩtí rî, ágámvá ꞌdĩ drí rĩzó drẽ nyé ãvõ kâtí. Gõꞌdá tã ꞌdî tãsĩ rî, õjílã drí ngãzó tã âtálé kĩ nĩ rî, “ꞌÁ, mvá ãgô ꞌdĩ kâ ꞌdĩ drã ꞌbô trá ꞌdĩ!” ");
INSERT INTO avu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gõꞌdá nĩngá sĩ, Yésũ drí ágámvá rî ꞌdĩ drı̣́ lâ rũzó gólâ rî îngázó ûrû. Ĩtí rî, ágámvá ꞌdĩ drí ngãzó âdrélé ûrû, éêdê gólâ trá. ");
INSERT INTO avu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Vó lâ ꞌásĩ, Yésũ yî lãjóꞌbá íyíkâ yí bê drí ngãzó fĩlí jó ꞌálâ. Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí gólâ rî îjízó ı̣̃nı̣́nı̣̂ ró kĩ nĩ rî, “Tãlâ ãꞌdô ꞌî ãmâ nyãányâ drí îcázó kô líndrí õnjí ꞌdĩ lôfõlé vólé ágámvá ꞌdĩ ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nĩngá sĩ, Yésũ drí tã-drı̣̃ ꞌdî lôgõzó gólĩyî drí kĩ nĩ rî, “Líndrí õnjí lârâkô ꞌdĩ îcá kô ãnî drí drõlé cú ĩtí rãtáã ꞌẽꞌẽ ãkó. Nĩ âꞌdô rãtáã ꞌẽꞌá zãlô ãmbá Ôvârí drí, tãlâ gólâ õfẽ ró mbârâkã drõzó lâ ĩꞌdî sĩ lâ vólé.” ");
INSERT INTO avu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nĩngá sĩ, Yésũ yî drí ngãzó lậvũlı̣́ võ ꞌdî âyélé. Gólĩyî lậvũ kôrô ı̣̃nı̣́nı̣̂ ró ꞌbạ̃drı̣̃ zı̣̃lı̣́ Gãlĩláyã rî ꞌásĩ, tãlâ Yésũ lẽé kô õjílã ãzâ drí nı̣̃lâ kĩ, ĩyî bí lậvũꞌá. ");
INSERT INTO avu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yésũ ꞌê tã rî ꞌdĩ ĩtí ꞌdĩ, tãlâ gólâ rĩꞌá lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî lı̣̃fı̣́ lâ yî îmbáꞌá íyî õdrã tãsĩ. Ĩtí rî, gólâ kĩ gólĩyî drí rî, “Mâ gólâ Ôvârí drí âjólé ûrú lésĩ rî, áâꞌdô ámâ drı̣́-bã fẽꞌá õjílã drí, drílĩyî fũlı̣́. Õzõ ãꞌdô kpálé ĩtí rî, kậyı̣̂ nâ sĩ rî, má âꞌdô lîdríꞌá õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nĩngá sĩ, lãjóꞌbá ꞌdĩ ꞌbá yî nı̣̃ı̣́ úlı̣́ gólâkâ âtálé ꞌdĩ ꞌbá yî ífí lâ kô. Gõꞌdá gólĩyî îjí ífí lâ tã kpá kô, tãlâ ũrı̣̃ gâ trá gólĩyî rú. ");
INSERT INTO avu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nĩngá sĩ, Yésũ yî lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yí bê drí ngãzó gõlé Kãpẽrãnómã ꞌálâ. Gõꞌdá tólâ Yésũ yî âꞌdólé bê ĩyî jó ꞌá rî, drílâ lãjóꞌbá ꞌdĩ ꞌbá yî îjízó kĩ nĩ rî, “Tã ãnî drí rĩꞌá tã lâ ôjálé ãnî lãfálé ꞌásĩ lạ́tı̣̂ ꞌásĩ rî ãꞌdô ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ĩtí rî, lãjóꞌbá ꞌdĩ ꞌbá yî drí âgízó tı̣́ı̣́ ãnyĩ drí sĩ, tãlâ pávó ꞌásĩ rî, gólĩyî rî trá tã ôjálé tãlâ lãjóꞌbá gólâ ꞌẽ ꞌbá âꞌdólé õjílã ãmbá ró gạ̃rạ̃ rî Yésũ rî lı̣̃fı̣́ drı̣̃ ꞌá rî ãꞌdî ĩꞌdî yã rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nĩngá sĩ, Yésũ drí rĩzó vũdrı̣́. Drílâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî ậzı̣́zó âꞌdólé dîrî yí rú sĩ. Gõꞌdá gólâ kĩ gólĩyî drí rî, “Õjílã gólâ lẽ ꞌbá âꞌdólé ãmbá íyî ãzí-ãzí rî lậvũlı̣́ kôrô rî, gólâ õꞌbã yî âꞌdólé ạ̃dũkũ ró ãmbã ãngó nõ kâ ãkó, tãlâ gólâ ãꞌdô ró bê rû ı̣̂ꞌbũ ꞌbá ró ãzí-ãzí drí ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nĩngá sĩ rî, Yésũ drí ngãzó mvá ãzâ âtrõlé ãlô âdrélé ĩyî ândrá ndrĩ. Gõꞌdá drílâ mvá ꞌdĩ âmvózó íyî drı̣́ sĩ gõzó tã âtálé lãjóꞌbá drí kĩ, ");
INSERT INTO avu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Õjílã gólâ ãlô ꞌdĩyímvá fínyáwá nõ ꞌbá yî ꞌásĩ lậgú ꞌbá, õzõ õjílã má drí lẽlé rî kâtí rî, ꞌdĩî lậgû kpá trá mâ ĩꞌdî. Gõꞌdá õjílã ámâ lậgú ꞌbá rî lậgû kpá gólâ ámâ âjó ꞌbá nõngá rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nĩngá sĩ, Yõwánĩ drí tã âtázó Yésũ drí kĩ, “Ãmbá, mã ndrê ãgô ãzâ trá gólâ âꞌdó kô ãmâ lãfálé ꞌásĩ, gõꞌdá gólâ rĩꞌá ánî rú zı̣̃ꞌá ĩꞌdî líndrí õnjí lâdrózó vólé õjílã ꞌásĩ. Mã cê rû trá kpı̣̃ı̣̂ rú lâ tã ꞌdî âyélé, tãlâ gólâ âꞌdó kô ãmâ lãfálé ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Gõꞌdá ĩtí rî, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ nĩ rî, “Nĩ ı̣̂sũ tã kô. Nĩ êdrẽ gólâ kô. Õjílã gólâ ámâ rú zı̣̃ ꞌbá ĩꞌdî tã lârâkô ꞌẽzó rî, gólâ îcá kô úlı̣́ õnjí âtálé ꞌwãâ má rú. ");
INSERT INTO avu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Õjílã ãzâ rĩ ꞌbá kô tã õnjí ꞌẽlé ãmâ rú rî, rĩꞌá tã pạ̃tı̣́ı̣̃ ró ãmâ ãzí-ãzí ꞌî. ");
INSERT INTO avu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró. Õzõ kpálé õjílã ãzâ õfẽ lũmvû cé ĩgã sĩ dũû mvũlı̣́, tãlâ ãnî trá õjílã ámákâ ĩꞌdî rî, gólâ ꞌdĩ tã mbı̣̂ ró âꞌdô drı̣́-ꞌâ Ôvârí kâ ûsúꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nĩngá sĩ, Yésũ drí tã âtázó kĩ nĩ rî, “Nî ãzâ, õzõ ní ãâdô gólĩyî dãdãwá ró rî yî trá lạ́tı̣̂ mbı̣̂ Ôvârí kâ rî âyélé gõꞌdá rĩzó tã õnjí ꞌẽlé ĩꞌdî rî, rĩꞌá õnjí ró lậvũlı̣́. Tíkó âꞌdô âꞌdóꞌá tãndí ró, õzõ tí óõtrõ kúnı̣́ ândrê kũlũtũtũ rî ĩꞌdî ꞌbãlé ômbélé ngạ́rạ́ ánî ômbê ꞌá, gõꞌdá ánî trõzó vũlı̣́ ĩꞌdí bê lâ gạ́lı̣́ ꞌá, tãlâ ní drã ró bê vólé, drẽ ãkpãkãꞌdã ní drí gólâ dãwá ꞌdĩ âdó ãkó. ");
INSERT INTO avu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Kpá ĩtí õzõ ní õlẽ tã õnjí ꞌẽlé ánî drı̣́ sĩ rî, ní âyê, ní lı̣̂ gólâ túú vólé, ãꞌdô ró bê lédrẽ-lédrẽ ạ̃dũkũ ãkó rî tãsĩ. Ní drí âꞌdózó lédrẽ-lédrẽ ạ̃dũkũ ãkó rî bê cé drı̣́ ạ̃lı̣́ bê rî sû nĩ gạ̃rạ̃ ní drí âꞌdózó drı̣́ bê rı̣̃, gõꞌdá fĩzó vẽlé lạ̃sı̣́ ândrê rạ̃ꞌdạ̃ âdrã ꞌbá kô rî ꞌá rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kpá ĩtí ró, õzõ ní õlẽ nĩlí pá sĩ tã õnjí ꞌẽlé rî, ní âyê, ní lı̣̂ ánî pá njíyá vólé. Rĩꞌá tãndí ró ní drí âꞌdózó lédrẽ-lédrẽ ạ̃dũkũ ãkó rî bê cé pá ãlô bê, gõꞌdá gólâ ní drí âꞌdózó cú pá bê rı̣̃ ní drí vẽzó lạ̃sı̣́ ꞌá rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Õzõ gõꞌdá ánî lı̣̃fı̣́ õꞌê nĩ ánî ꞌbãlé tã õnjí ꞌẽlé rî, ní ângî gólâ vũlı̣́ vólé. Rĩꞌá tãndí ró ní drí cãzó ꞌbũû ꞌálâ lı̣̃fı̣́ bê ãlô, gõꞌdá ní drí âꞌdózó lı̣̃fı̣́ bê rı̣̃ ánî vũzó lạ̃sı̣́ ꞌá rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Võ ꞌdî ꞌá tólâ rî, ı̣̃ꞌbû gólĩyî drã ꞌbá kô rî ꞌbá yî rî ĩyíkâ zãâ õjílã nyãlé, gõꞌdá lạ̃sı̣́ rĩ ꞌbá gólĩyî zãlé rî âdrãá íyíkâ kpá kô. ");
INSERT INTO avu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Órî ꞌạ̃ꞌı̣́-nyá ŋãlé ãꞌwá ı̣́bı̣̃ rú, tãlâ õzó ŋãâ kô. Ĩꞌdî kpá nyé ĩtí, Ôvârí rî ãmâ jũlı̣́ lạ̃sı̣́ sĩ âꞌdólé õjílã tãndí ró yí drí. ");
INSERT INTO avu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ꞌẠ̃ꞌı̣́-nyá rĩꞌá ngá âsô-âsô ꞌî. Gõꞌdá õzõ ꞌạ̃ꞌı̣́-nyá rî ꞌdĩ âsô-âsô lâ õndẽ trá rî, ní âꞌdô ꞌạ̃ꞌı̣́-nyá rî ꞌdĩ ꞌẽꞌá ángô tí yã? Ní âꞌdô dãꞌá lâ vólé vũdrı̣́, tãlâ ní îcá kô ꞌẽlâ âsólé óꞌdí. Ãnî ndrĩ, nĩ âꞌdô ꞌạ̃ꞌı̣́-nyá ró ngírí-ngírí ãnî ãzí-ãzí yî lãfálé. Nĩ rî gólĩyí bê ạ̃ꞌdı̣́ ró. Nĩ ôjâ tã kô ãnî lãfálé ꞌásĩ âꞌdózó ãmbá ró.” ꞌDĩî ꞌbá yî Yésũ rî tı̣̂-võ ꞌî lãjóꞌbá íyíkâ rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ꞌDĩî vósĩ, Yésũ yî drí Kãpẽrãnómã rî âyézó ngãzó nĩlí mbãlé ꞌáꞌá lé drı̣̃ áyágá Jõrõdénĩ kâ ãzâ lésĩ rî ꞌá. Drílĩyî nĩzó zãâ áyágá Jõrõdénĩ kâ ꞌdĩ ꞌáꞌá lé drı̣̃ lâ lésĩ. Gõꞌdá drílĩyî mbãzó kpá gõlé ꞌáꞌá lé drı̣̃ ãzâ rî lésĩ cãlé ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ rî ꞌá. Ĩtí rî, võ ꞌdî ꞌbá yî ꞌásĩ ndrĩ, õjílã õꞌbí drí rû êꞌbézó dîrî gbãâ gólâ rú sĩ kpá óꞌdí. Nĩngá sĩ, gólâ drí ngãzó rĩꞌá tã âꞌdálé gólĩyî drí õzõ drílâ rĩꞌá kó ꞌẽlâ sı̣́sı̣́ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nĩngá sĩ rî, Pạ̃rúsı̣̃ yî drí ngãzó ânĩlí ĩyî gólâ ngálâ, tãlâ gólĩyî lẽ gólâ rî ûjũlı̣́ tã îjî sĩ, õzõ gólâ ãâtâ tã ányâ trá tã ꞌbãꞌbã Músạ̃ kâ rú rî tãsĩ. Îjî ĩyî gólâ kĩ nĩ rî, “Rĩꞌá tã mbı̣̂ ꞌî õjílã drí íyî õkó rî îngázó vólé õzõ õkó rî ꞌdĩ õꞌê tã ányâ ãzâ trá rî yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ĩtí rî, Yésũ drí tã îjî gólĩyíkâ ꞌdĩ drı̣̃ lâ lôgõzó kĩ, “Tã âtâ Músạ̃ kâ ꞌbãlé trá búkũ Ôvârí kâ ꞌá ạ̃kû ró ãnî drí ꞌẽlé tã ꞌdî tãsĩ rî kĩ ãꞌdô yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nĩngá sĩ, drílĩyî tã-drı̣̃ lôgõzó kĩ nĩ rî, “Músạ̃ ꞌbã tã kĩ, õzõ õjílã õlẽ íyî õkó rî îngálé rî, gólâ õfẽ wárãgã õkó îngâ kâ õkó rî ꞌdĩ drí.” ");
INSERT INTO avu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ĩtí, Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Músạ̃ îgĩ tã trá õzõ ꞌdĩî kâtí cé tãlâ ãnî ạ́ꞌbı̣́yạ́ yî drı̣̃ âꞌdô trá âmbâ-âmbâ ró. Ngbãângbânõ, ãnî drı̣̃ kpá trá âmbâ-âmbâ ró, tãlâ tã âꞌdô trá ãnî lãfálé ꞌásĩ ãnî õkó yí bê rî, nĩ îcá kô tã rî ꞌdĩ êdélé. ");
INSERT INTO avu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ạ̃kû ró kậyı̣̂ nã ꞌbá yî sĩ, Ôvârí drí sı̣́sı̣́ ı̣̃nyạ́kú yî ꞌbũû bê ꞌbãzó rî, ‘gólâ ꞌbã ãgô cú íyî õkó bê’. ");
INSERT INTO avu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","‘Tãlâ ĩꞌdî ꞌdĩ, õjílã drí ꞌbã íyî átá yí kâ ândré bê rî âyézó, gõꞌdá njũzó õkó lâ bê ngá ãlô ró.’ Tã Ómvó Ngá 2.24 Nĩ ndrê drẽ, gólĩyî âꞌdó gõꞌdá kô ngá rı̣̃ ꞌî. ");
INSERT INTO avu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ĩtí rî, nĩ câ õjílã lãfálé Ôvârí drí ı̣̂cúlı̣́ trá ngá ãlô ró rî kôꞌdáwá.” ");
INSERT INTO avu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nĩngá sĩ, Yésũ yî gõ bê ꞌbã ꞌálâ rî, lãjóꞌbá gólâkâ drí gólâ rî îjízó kpá óꞌdí tã ꞌdî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ĩtí, Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ nĩ rî, “Õjílã ãzâ gólâ íyî õkó rî îngá ꞌbá vólé ãꞌdô ró bê õkó óꞌdí ãzâ gĩzó ĩꞌdî rî, gólâ ꞌê ꞌdĩ tã õnjí ꞌî õkó lâ rú gõꞌdá kpá Ôvârí rú. ");
INSERT INTO avu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Gõꞌdá õzõ õkó õngâ kpá trá vólé íyî ágó drı̣́gạ́ sĩ nĩꞌá ágó ãzâ trõlé ĩꞌdî rî, ꞌdĩî gólâ ꞌê tã õnjí kpá trá íyî ágó ạ̃kû rî drí gõꞌdá kpá Ôvârí rú.” ");
INSERT INTO avu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nĩngá sĩ, õjílã ãzâ ꞌbá yî drí ꞌdĩyímvá õnyíkõ ậdrı̣̃zó âjílí Yésũ ngálâ, ãꞌdô ró bê gólâ drí tũ wũzó gólĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá õrẽ ró gólĩyî drí. Gõꞌdá lãjóꞌbá gólâkâ drí ngãzó tã lôgõlé õjílã ꞌdĩyímvá âjí ꞌbá ꞌdĩ ꞌbá yî drı̣̃ı̣̂ kĩ nĩ rî, gólĩyî ãânĩ kô. ");
INSERT INTO avu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yésũ ndrê bê lãjóꞌbá ꞌdĩ ꞌbá yî tã ꞌẽꞌá ĩtí rî, tã ꞌdî cí Yésũ rî fĩî kô, gõꞌdá drílâ tã âtázó gólĩyî drí kĩ nĩ rî, “Nĩ âyê ꞌdĩyímvá ꞌdĩ ꞌbá yî ânĩlí má ngálâ. Nĩ lôgâ gólĩyî kô, tãlâ õjílã gólĩyî tã ámákâ ârí ꞌbá ꞌẽlé ꞌwãâ õzõ ꞌdĩyímvá nõ ꞌbá yî drí tã ârírĩ ꞌẽlé rî kâtí rî âꞌdô ĩyî âꞌdóꞌá õjílã Ôvârí kâ ró. ");
INSERT INTO avu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tã pạ̃tı̣́ı̣̃ ró, má âtâ ãnî drí, õzõ nĩ õlẽ âꞌdólé õjílã Ôvârí kâ ró rî, ꞌdõvó nĩ ârî tã ámákâ ꞌẽlé ꞌwãâ õzõ ꞌdĩyímvá õnyíkõ nô ꞌbá yí kâtí. Õzõ ãꞌdô ĩtí kôꞌdáwá rî, nĩ îcá kô âꞌdólé õjílã Ôvârí kâ ró.” ");
INSERT INTO avu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Vó lâ sĩ, Yésũ drí ꞌdĩyímvá ꞌdĩ ꞌbá yî ậzı̣́zó âgõlé yí ngálâ. Gõꞌdá drílâ tũ wũzó gólĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá, gõzó Ôvârí rî îjílí ófẽ ró bê õrẽ gólĩyî drí ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Vó lâ sĩ, Yésũ yî õtírĩ ngãâ võ ꞌdî âyélé rî, ãgô ãzâ drí ngãzó ârálé ꞌãꞌî tı̣̃lı̣́ vũdrı̣́ Yésũ ândrá, gõꞌdá drílâ Yésũ rî îjízó kĩ, “Lı̣̃fı̣́ îmbá ꞌbá tãndí, má âꞌdô tã ángô rî ꞌẽꞌá ĩꞌdî, tãlâ má drí âꞌdózó lédrẽ-lédrẽ ạ̃dũkũ ãkó rî bê yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ĩtí rî, Yésũ drí ngãzó tã ꞌdî drı̣̃ lâ lôgõlé drílâ kĩ nĩ rî, “Ní zı̣̂ mâ õjílã tãndí ró ãꞌdô tãsĩ yã? Õjílã tãndí ãngó nõ ꞌá yû. Cé Ôvârí ĩꞌdî rĩꞌá tãndí ró. ");
INSERT INTO avu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ãꞌdô lạ́tı̣̂ ꞌbũû ꞌálâ rî tãsĩ rî, ní nı̣̃ tã Ôvârí drí ꞌbãlé trá rî yî rĩꞌá nõ ꞌbá yî tí. Ní fû õjílã kô. Ní ꞌbã õkó gólâ âꞌdó ꞌbá kô ánî õkó ró rî kô ní ũgúlı̣́ ậyı̣́zó ĩꞌdí bê lâ. Ní ûgũ ngá kô. Ní âdô õnjõ kô. Ní âdô õjílã kô ngá gólâkâ trõzó vólé. Ní ârî ánî átá yî tı̣̂-võ ánî ândré bê, tãlâ ní ı̣̂njı̣̃ ró gólĩyî bê.” ");
INSERT INTO avu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nĩngá sĩ, ãgô ꞌdĩ drí tã lôgõzó Yésũ drí kĩ, “Ãwô, má rî trá tã ꞌdî ꞌbá yî ꞌẽlé kó ãkpãkãꞌdã ꞌdĩmvã lésĩ bũúũ âcálé ãndrõ nô.” ");
INSERT INTO avu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nĩngá sĩ, Yésũ drí ngãzó võ ndrẽlé mbı̣̂ ãgô rî ꞌdĩ ngálâ lôvó sĩ. Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó drílâ kĩ nĩ rî, “Ngá ãzâ lâkî trá ãlô ní drí ꞌẽlé. ꞌDõvó ní ngâ nĩlí ngá âꞌdó ꞌbá áníkâ ró rî ꞌbá yî lậzı̣́lı̣́ gĩlí ndrĩ vólé, tãlâ ní trõ ró lãfâ lâ ꞌdĩ fẽlé ngá ãkó lé ꞌbá drí. Ĩtí rî, ní âꞌdô âꞌdóꞌá ngá tãndí bê dũû ꞌbũû ꞌálâ. Õzõ ní õꞌê tã rî ꞌdĩ ꞌbá yî trá rî, ní gõ ró bê ânĩlí ꞌdẽlé má vó zãâ tã ârí ꞌbá ámákâ ró.” ");
INSERT INTO avu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Gõꞌdá ãgô ꞌdĩ ârílí bê úlı̣́ Yésũ kâ ꞌdĩ ꞌbá yî rî, võ drí rû îzãzó rú lâ. Drílâ ngãzó nĩlí vólé ĩzã ró, tãlâ gólâ rĩꞌá ngá-tı̣̂ bê dũû. Gólâ lẽé kô ngá ãmbá íyíkâ ꞌdĩ ꞌbá yî lậzı̣́lı̣́ gĩlí vólé. ");
INSERT INTO avu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nĩngá sĩ, Yésũ drí ngãzó võ ndrẽlé dîrî gbãâ, gõꞌdá drílâ tã âtázó tã ârí ꞌbá íyíkâ drí kĩ nĩ rî, “Rĩꞌá âmbâ-âmbâ ró õjílã ngá-tı̣̂ bê dũû rî drí âꞌdózó õjílã Ôvârí kâ ró.” ");
INSERT INTO avu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ĩtí rî, tã ârí ꞌbá tı̣̂ drí ậꞌdı̣́zó. Gõꞌdá Yésũ drí tã ꞌdî âtázó kpá óꞌdí gólĩyî drí kĩ nĩ rî, “Ámâ ꞌbá yî, rĩꞌá lâŋõ ró ãmbá ngá-tı̣̂ dũû ꞌbá drí âꞌdózó õjílã Ôvârí kâ ró. ");
INSERT INTO avu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lâŋõ lâ âꞌdô lậvũꞌá kôrô lâŋõ ĩnjígó rĩ ꞌbá ûjũlı̣́ fĩlí kôrô lı̣́bı̣̃rạ̃ ꞌbú ꞌásĩ rî kâ drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gõꞌdá nĩngá sĩ, tã ârí ꞌbá ꞌdĩ ꞌbá yî tı̣̂ lâ yî drí ậꞌdı̣́zó rõô úlı̣́ ꞌdĩ ꞌbá yî drí sĩ. Nĩngá sĩ, drílĩyî tã âtázó ĩyî lãfálé ꞌásĩ kĩ nĩ rî, “Õzõ ãꞌdô ĩtí lâ ꞌdĩ ró rî, âꞌdô âꞌdóꞌá ángô tí ró õjílã ãzãkã drí ngá pãzó yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Vó lâ sĩ, Yésũ drí võ ndrẽzó gólĩyî ngálâ, gõzó tã âtálé kĩ nĩ rî, “Õjílã ãzâ îcá kô íyî nyãányâ pãlé yí sẽésẽ ró. Cé Ôvârí ĩꞌdî, tãlâ tã ndẽé gólâ kô. Ôvârí cú fãfã bê tã ndrĩ ꞌẽzó.” ");
INSERT INTO avu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nĩngá sĩ, Pétẽrõ drí tã âtázó Yésũ drí ĩyî lãjóꞌbá yî tãsĩ kĩ nĩ rî, “Ní ndrê drẽ, mã âyê ngá ãmákâ rî ꞌbá yî trá ndrĩ, tã lâ rĩzó ánî vó lôbẽlé ĩꞌdî. Gõꞌdá bê trá ĩtí rî, mã âꞌdô ãꞌdô ûsúꞌá ĩꞌdî Ôvârí drı̣́gạ́ sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ĩtí rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ drí kĩ nĩ rî, “Pạ̃tı̣́ı̣̃, má âtâ ãnî drí, õjílã ngá íyíkâ rî ꞌbá yî âyé ꞌbá tã ámákâ ꞌẽzó ĩꞌdî rî, õzõ gólâ ãâyê íyî átá ꞌî ngãtá íyî ândré, íyî ậdrúpı̣̃, íyî îzó ngãtá ꞌdĩyímvá yî ĩꞌdî yã, ngãtá ꞌbô ꞌbã ꞌî ạ́mvú yí bê, ãꞌdô ró bê tã âtî-âtî Ôvârí kâ âtázó õjílã drí yã rî, ");
INSERT INTO avu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gólâ âꞌdô ngá ûsúꞌá dũû ãngó nõ ꞌá. Gólâ âꞌdô âꞌdóꞌá ândrê bê dũû, ậdrúpı̣̃ yî, îzó yî, átá yî, ꞌbã yî gõꞌdá ạ́mvú yí bê dũûdû ãngó nõ ꞌá. Gólâ âꞌdô kpá lâŋõ ûsúꞌá rõô, tãlâ õjílã âꞌdô gólâ rî lârâkô ꞌẽꞌá úlı̣́ ámákâ âtâ-âtâ lâ tãsĩ. Gõꞌdá gólâ âꞌdô kpá tã tãndí ûsúꞌá ꞌbũû ꞌálâ, rĩzó zãâ gbạ́dú ạ̃dũkũ ãkó tólâ. ");
INSERT INTO avu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Gõꞌdá nĩ ꞌbã ãnî nyãányâ kô âꞌdólé lậnjı̣̃-lậnjı̣̃ ró ngá ãníkâ âyélé ndrĩ ámâ tãsĩ rî tãsĩ, tãlâ õjílã gólĩyî tã lâ drí lậnjı̣̃lı̣́ rõô rî ꞌbá yî, tã lâ yî âꞌdô âzáꞌá, gõꞌdá gólĩyî tã lâ drí lậnjı̣̃lı̣́ kôꞌdáwá rî, áâꞌdô gólĩyî tã ꞌbãꞌá âꞌdólé lậnjı̣̃-lậnjı̣̃ ró kôrô ı̣̃zạ́tú.” ");
INSERT INTO avu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kậyı̣̂ ãzâ sĩ, Yésũ yî drí ngãzó nĩlí lạ́tı̣̂ Yẽrõsãlémã kâ rî ꞌásĩ gõlé Yẽrõsãlémã ꞌálâ. ꞌDĩî Yésũ ꞌdê íyíkâ tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî ândrá. Gõꞌdá tã ârí ꞌbá gólâkâ ꞌdĩ ꞌbá yî, tı̣̂ lâ yî drí ậꞌdı̣́zó, tãlâ fĩî ı̣̂dû-ı̣̂dû gólâkâ ꞌdĩ tãsĩ. Gólĩyî bê kpálé ꞌdẽꞌá Yésũ vósĩ rî, gólĩyî kpá rĩꞌá ũrı̣̃ ró. Ĩtí rî, Yésũ drí âdrézó, gõꞌdá drílâ lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî ậzı̣́zó yí ngálâ. Nĩngá sĩ, drílâ tã âtázó gólĩyî drí tã ꞌẽ ꞌbá rû ꞌẽlé yí drí rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gólâ kĩ gólĩyî drí rî, “Nĩ ârî drẽ, nõô ãmâ trá nĩꞌá Yẽrõsãlémã ꞌálâ nõ. Tólâ rî, mâ gólâ Ôvârí drí âjólé trá ûrú lésĩ nô, áâꞌdô ámâ drı̣́-bã fẽꞌá ámâ trõzó drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ândrá gõꞌdá kpá lãꞌbí îmbá ꞌbá yí bê. Tólâ rî, gólĩyî âꞌdô tã ámákâ kĩꞌá kĩ nĩ rî, ꞌdõvó úfû mâ. Gólĩyî âꞌdô ámâ trõꞌá âjílí õjílã ãtrâ Rómã kâ rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Gõꞌdá õjílã ꞌdî ꞌbá yî âꞌdô ámâ gũꞌá. Gólĩyî âꞌdô tũ lûwúꞌá má lı̣̃fı̣́, vó lâ sĩ, ámâ cãzó. Gõꞌdá tã ꞌdî ꞌbá yî vósĩ, gólĩyî âꞌdô ámâ fũꞌá. Gõꞌdá kậyı̣̂ nâ sĩ rî, má âꞌdô lîdríꞌá õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nĩngá sĩ, Yãkóbã yî ậdrúpı̣̃ lâ Yõwánĩ bê, Zẽbẽdáyõ rî mvá yî ró rî drí ngãzó ĩyî rû êsélé ãnyî Yésũ lạ̃gạ́tı̣́ gõꞌdá tã îjílí tı̣́ lâ kĩ nĩ rî, “Lı̣̃fı̣́ îmbá ꞌbá, ní âꞌdô îcáꞌá trá tã ãlô gólâ ãmâ drí ꞌẽꞌá îjílâ nõ ꞌẽlé ãmâ drí yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ĩtí rî, Yésũ drí gólĩyî îjízó kĩ, “Nĩ lẽ má õꞌê ãꞌdô ĩꞌdî ãnî drí yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gõꞌdá lôgõ ĩyî tã-drı̣̃ Yésũ drí kĩ, “Ị̃tú ní drí ânĩzó rĩlí kúmú ạ́ngı̣́ ró ãngó nõ drı̣̃ı̣̂ rî sĩ, ní ꞌbã ãmâ rĩlí ánî gãrã drı̣̃ ꞌá, ãlô ãmâ lãfálé ꞌásĩ rî íyíkâ ánî drı̣́-ágó drı̣̃ı̣̂, gõꞌdá ãzâ ãlô rî ãꞌdô ró íyíkâ ánî drı̣́-lı̣̃jı̣́ drı̣̃ı̣̂, mã gõ ró rĩlí ãní bê ãngó nõ drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nĩngá sĩ, Yésũ drí tã âtázó gólĩyî drí kĩ, “Mĩ nı̣̃ı̣́ tã ífí tã ãnî drí îjílí ꞌdĩ kâ kô. Nĩ õlẽ trá ãyĩkõ ámákâ rî ꞌẽlé rî, ĩtí rî, nĩ âꞌdô îcáꞌá trá ĩzã kõkõ ámákâ âꞌdó ꞌbá ạ̃tı̣́ ꞌálâ rî ꞌẽlé yã? Nĩ âꞌdô îcáꞌá trá ngá mvũlı̣́ ĩgã lâŋõ kâ gólâ má drí ꞌẽzó ngá mvũlı̣́ ꞌálâ sĩ rî ꞌásĩ yã? Lâŋõ âꞌdô ꞌdı̣̃ꞌá má drı̣̃ı̣̂ õzõ lı̣̃mvû gólâ rĩꞌá dãlâ õjílã drı̣̃ı̣̂ bãbãtízĩ ꞌẽ võ ꞌá rî kâtí. Nĩ îcâ trá âꞌdólé bãbãtízĩ ꞌẽꞌẽ ĩtí ꞌdĩ bê yã?” ");
INSERT INTO avu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ĩtí rî, drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ nĩ rî, “Ãwô, mã îcâ trá.” Nĩngá sĩ, Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Âꞌdô âꞌdóꞌá õzõ ꞌdĩî tí. Nĩ âꞌdô kpá ngá mvũꞌá ĩgã lâŋõ kâ má drí ngá mvũzó ꞌálâ sĩ rî ꞌásĩ, gõꞌdá áâꞌdô kpá bãbãtízĩ lâŋõ kâ ꞌẽꞌá ãnî drí õzõ ꞌẽꞌá ꞌẽlâ má drí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Õzõ ãꞌdô kpálé ꞌdĩî kâtí rî, mâ mbârâkã ãkó võ rĩ kâ ámâ gãrã drı̣̃ ꞌá rî fẽzó ãnî drí. Ôvârí rĩꞌá võ kũmũ kâ êdéꞌá õjílã drílâ ꞌẽꞌá êpẽlâ rî yî drí.” ");
INSERT INTO avu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gõꞌdá nĩngá sĩ, lãjóꞌbá mûdrı̣́ rî ꞌbá yî ârílí bê ĩyî úlı̣́ Yãkóbã yí kâ ậdrúpı̣̃ lâ Yõwánĩ bê ꞌdĩ rî, gólĩyî drí âꞌdózó õmbã ró Yãkóbã yî drí. ");
INSERT INTO avu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ĩtí rî, Yésũ drí tã âtázó gólĩyî drí rû êꞌbézó ndrĩ dîrî, gõꞌdá gólâ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Mĩ nı̣̃ trá kĩ nĩ rî, kúmú ꞌbạ̃súrú kâ rî ꞌbá yî rî rĩlí ꞌbạ̃súrú íyíkâ rî ꞌbá yî drı̣̃lı̣́ mbârâkã sĩ. ");
INSERT INTO avu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gõꞌdá ãnî lãjóꞌbá ámákâ rî ꞌbá yî lãfálé ꞌá rî, nĩ ꞌé ĩtí kô. Gólâ tíbê lẽ ꞌbá âꞌdólé ãmbá ró ãnî lãfálé ꞌásĩ Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî, gólâ ı̣̃ı̣̂ꞌbũ rû íyî ãzí-ãzí yî drí ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Õjílã ãnî lãfálé sĩ gólâ tíbê lẽ ꞌbá âꞌdólé ãmbá ró sı̣́sı̣́ íyî ãzí-ãzí yî drı̣̃ı̣̂ sĩ Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî, gólâ ãâꞌdô rạ̃gı̣́ı̣̃ ró rû ı̣̂ꞌbũlı̣́ ãzí-ãzí lâ yî drí ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nĩ ârî drẽ, mâ gólâ âjólé trá ûrú lésĩ rî, ânĩí kô âꞌdólé ãzí-ãzí drí rû ı̣̂ꞌbũzó má drí. Má ânĩ nô rû ı̣̂ꞌbũlı̣́ ĩꞌdî ãzí-ãzí drí, gõꞌdá kpá ámâ nyãányâ fẽlé drãlé, tãlâ má ãꞌdô ró bê õjílã dũû drı̣̃ tĩzó ĩꞌdî sĩ lâ.” ");
INSERT INTO avu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nĩngá sĩ, Yésũ yî rî trá nĩꞌá gõlé Yẽrõsãlémã ꞌálâ ró, gõꞌdá drílĩyî cãzó Yérĩkõ ꞌá. Gõꞌdá gólĩyî bê trá lậvũꞌá Yérĩkõ ꞌásĩ rî, õjílã tı̣́lı̣́lı̣́ ĩyíkâ kpá zãâ gólĩyí bê ꞌdũwạ̃. Tólâ lı̣̃fı̣́ ãkó lé ꞌbá ãzâ bê rĩꞌá rú lâ Bãtĩmáyã, gõꞌdá átá lâ rî rú rĩꞌá Tĩmáyã, gólâ rî rĩlí lạ́tı̣̂ gãrã drı̣̃ ꞌá, tãlâ yí õrî ró bê lãfâ zı̣̃lı̣́ õjílã lạ́tı̣̂ kâ drı̣́gạ́ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ĩtí rî, gólâ drí tã ârízó kĩ nĩ rî, ãâꞌdô Yésũ Nãzãrétã lésĩ rî ĩꞌdî lậvũꞌá õjílã tı̣́lı̣́lı̣́ bê. Gõꞌdá gólâ ârílí bê tã ꞌdî rî, drílâ ngãzó rĩlí lạ̃zı̣́ zı̣̃lı̣́ ngbạ́lạ́-ngbạ́lạ́ kĩ nĩ rî, “Yésũ, ní ꞌbã ámâ ĩzã õgâ ní drı̣̃ı̣̂, nî ĩꞌdî tíbê Ôvârí drí tã lâ âtálé kĩꞌá nĩ rî, âꞌdô ânĩꞌá ãmâ pãlé nõ, ní pâ mâ.” ");
INSERT INTO avu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nĩngá sĩ, õjílã dũû drí ngãzó nĩlí gólâ ngálâ rĩꞌá tã lôgõlé gólâ drı̣̃ı̣̂, gólâ ãâgî tı̣́tı̣́. Gõꞌdá lé ĩtí rî, Bãtĩmáyã, ní lẽé tã õjílã ꞌdî ꞌbá yí kâ ꞌdĩ ârílí kô. Ĩtí, ní drí gõzó trẽlé ûrû kpá óꞌdí ngbạ́lạ́-ngbạ́lạ́ kĩ, “Nî ĩꞌdî tíbê Ôvârí drí tã lâ âtálé kĩꞌá nĩ rî, âꞌdô ânĩꞌá ãmâ pãlé nõ, ní ndrê ámâ ĩzã! Ánî ꞌâ ạ̃ậꞌdı̣̂ má rú! Ní pâ mâ!” ");
INSERT INTO avu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nĩngá sĩ, Yésũ drí âdrézó tã âtálé õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, “Nĩ ậzı̣̂ ãgô nã ânĩlí má ngáá nõlé.” Ĩtí rî, õjílã ꞌdî ꞌbá yî drí lı̣̃fı̣́ ãkó lé ꞌbá Bãtĩmáyã rî ậzı̣́zó kĩ nĩ rî, “Ánî pı̣̃pı̣̂sı̣́lı̣́ ạ̃ậꞌdı̣̂. Ní ngâ ûrû nĩlí, tãlâ gólâ trá ánî zı̣̃ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ĩtí rî, Bãtĩmáyã ní drí ítá ândrê ní rú rî ângízó vũlı̣́ vũdrı̣́, ngãzó nĩlí ꞌwãâꞌwâ Yésũ ngálâ. ");
INSERT INTO avu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Gõꞌdá gólâ câ bê rî, Yésũ drí îjízó lâ kĩ nĩ rî, “Ní lẽ má õꞌê ãꞌdô ĩꞌdî ní drí yã?” Nĩngá sĩ, drílâ tã lôgõzó Yésũ drí kĩ, “Ãmbá, ní êdê ámâ lı̣̃fı̣́, ãꞌdô ró bê má drí võ ndrẽzó.” ");
INSERT INTO avu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Gõꞌdá Yésũ kĩ drílâ rî, “Ãꞌdô trá ꞌdĩî kâtí rî, ní nĩ, má pâ nî trá, tãlâ ní rî rĩlí tã lẽlẽ ámákâ bê ní ꞌá.” Gõꞌdá Yésũ õtírĩ kpá úlı̣́ ꞌdĩ ꞌbá yî âtá ndẽlé rî, kôrô Bãtĩmáyã rî lı̣̃fı̣́ drí rû njı̣̃zó, drílâ võ ndrẽzó rárá. Ĩtí rî, Bãtĩmáyã drí ngãzó ꞌdẽlé kpãâ Yésũ vósĩ õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yí bê ꞌdũwạ̃. ");
INSERT INTO avu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yésũ yî tã ârí ꞌbá íyíkâ rî ꞌbá yí bê trá rĩꞌá ĩyî nĩꞌá sı̣́sı̣́ ꞌálâ ró gõlé Yẽrõsãlémã ꞌálâ. Nĩngá sĩ, drílĩyî cãzó jạ̃rı̣́bạ̃ zı̣̃lı̣́ Bẽtánĩ gõꞌdá Bẽtẽfágẽ bê ãnyî Yẽrõsãlémã rú rî ꞌálâ. Tólâ lạ́tı̣̂ ꞌdĩ drı̣̃ı̣̂ rî, drílĩyî cãzó únı̣́ gólâ fê dõ kâ zı̣̃lı̣́ õlívĩ rî bê yí drı̣̃ı̣̂ rî ꞌálâ. Gõꞌdá gólĩyî câ bê tólâ rî, Yésũ drí ngãzó tã ârí ꞌbá íyíkâ rı̣̃ rî ꞌbá yî jõlé ạ̃tı̣́ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ĩtí, drílâ tã âtázó gólĩyî drí kĩ nĩ rî, “Nĩ fî ꞌbạ̃drı̣̃ mvá Bẽtẽfágẽ ạ̃tı̣́ ꞌálâ nã ꞌá. Tólâ rî, nĩ âꞌdô dõngí mvá ãzâ ómbãá drẽ drı̣̃ lâ ꞌá kôꞌdáwá rî ûsúꞌá óꞌĩ trá ꞌĩꞌĩ tólâ. Nĩ âtĩ ânĩzó ĩꞌdí bê lâ. ");
INSERT INTO avu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Õzõ õjílã ãzâ ꞌbá yî ĩîjî ãnî trá kĩ nĩ rî, nĩ rî dõngí ꞌdĩ âtĩlí ãꞌdô tãsĩ yã rî, nĩ lôgõ tã-drı̣̃ drílâ kĩ nĩ rî, ‘Kúmú ãmákâ lẽ nĩ, gólâ âꞌdô lôgõꞌá lâ ꞌwãâ vólé.’ ” ");
INSERT INTO avu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ĩtí, tã ârí ꞌbá rı̣̃ ꞌdî ꞌbá yî drí ngãzó nĩlí, gõꞌdá drílĩyî dõngí ûsúzó, óꞌĩ ꞌĩ ãnyî jó tı̣́lı̣́-tı̣̂ bê ꞌbã ãzâ ꞌá lạ́tı̣̂ gãrã drı̣̃ ꞌá. Nĩngá sĩ, drílĩyî ꞌdẽzó rĩꞌá âtĩlâ. ");
INSERT INTO avu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Gõꞌdá gólĩyî ꞌdê bê rĩꞌá dõngí rî ꞌdĩ âtĩlí rî, õjílã rĩ ꞌbá âdrélé ãnyî rî ꞌbá yî drí gólĩyî îjízó kĩ, “Nĩ rî dõngí ꞌdĩ âtĩlí ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Gõꞌdá tã ârí ꞌbá rı̣̃ ꞌdî ꞌbá yî lôgõ yî tã-drı̣̃ gbõ õjílã rî ꞌdĩ ꞌbá yî drí nyé õzõ Yésũ drí âtálé trá gólĩyî drí rî kâtí. Bê trá ĩtí rî, õjílã ꞌdî ꞌbá yî drí tã ârí ꞌbá ꞌdĩ ꞌbá yî âyézó dõngí rî ꞌdĩ âtĩlí sẽlé nĩzó ĩꞌdí bê lâ vólé. ");
INSERT INTO avu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nĩngá sĩ, drílĩyî dõngí ꞌdĩ âsézó âjílí Yésũ drí. Gõꞌdá gólĩyî drí ítá bı̣́ ạ́ngı̣́ ró rî ꞌbá yî âtrõzó ꞌbẽlé dõngí rî ꞌdĩ ũgúlı̣́, tãlâ Yésũ õrî ró bê drı̣̃ lâ. Gõꞌdá ĩtí rî, Yésũ drí mbãzó rĩlí gá drı̣̃ lâ fĩlí Yẽrõsãlémã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gõꞌdá dõngí âꞌdô bê rĩꞌá nĩꞌá Yésũ bê yí drı̣̃ı̣̂ rî, õjílã dũû drí ngãzó ꞌdó rĩꞌá ítá ĩyíkâ ꞌbẽlé ı̣̃nyạ́kú drı̣̃ı̣̂ sĩ lạ́tı̣̂ ꞌásĩ Yésũ ândrá, tãlâ gólâ õnĩ ró drı̣̃ lâ sĩ. Gõꞌdá õjílã ũrûkậ ꞌbá yî ĩyíkâ nĩꞌá lârá bê mbı̣́rạ́ bı̣́ âŋõ bê õmã ꞌásĩ âjílí ꞌbẽlé ꞌdó Yésũ ândrá drílâ nĩzó drı̣̃ lâ sĩ. ꞌDĩî gólĩyî lậgû õjílã ãmbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Nĩngá sĩ, õjílã ạ̃tı̣́ ꞌálâ rî ꞌbá yî gõꞌdá ꞌdó gólĩyî vólé ꞌálâ rî ꞌbá yí bê drí ngãzó ĩyî rĩlí tã pẽlé gbórókõ vạ́vạ́rạ́vạ́ sĩ kĩ nĩ rî, “Mã lûyı̣̂ nî, Kúmú. Ní âjô Yésũ trá drı̣́-ãcê áníkâ bê rĩlí ãngó drı̣̃lı̣́ ꞌdíyî pã ꞌbá ró, Mã lûyı̣̂ nî, Ôvârí, tãlâ ãngó lı̣́pı̣̂ trá ãnyî ꞌẽꞌá ãngó rũlı̣́. Mã lûyı̣̂ nî, Ôvârí gólâ rĩ ꞌbá ꞌbũû ꞌálâ rî.” Ĩtí, gólĩyî lậgû Yésũ trá kúmú ạ́ngı̣́ ĩyíkâ ró. ");
INSERT INTO avu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ĩtí rî, Yésũ yî drí ngãzó nĩlí Yẽrõsãlémã ꞌálâ. Tólâ, Yésũ yî drí âfízó ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌá. Gõꞌdá Yésũ drí võ ndrẽzó dîrî ꞌálé lâ ꞌásĩ. Tãlâ ı̣̃tú ꞌdê trá rî drí sĩ, Yésũ yî lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yí bê drí ngãzó gõlé vólé Bẽtánĩ ꞌálâ, võ drílĩyî rĩzó rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gõꞌdá cı̣̃ı̣́nó lâ sĩ, Yésũ yî trá âgõꞌá ĩyî lãjóꞌbá íyíkâ yí bê Yẽrõsãlémã ꞌálâ Bẽtánĩ lésĩ. Yésũ trá gõꞌdá lõfó ró. ");
INSERT INTO avu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Gõꞌdá Yésũ yî âꞌdô bê rĩꞌá nĩꞌá ĩyî lạ́tı̣̂ ꞌásĩ rî, drílâ fê ãzâ rĩꞌá zı̣̃lâ kãnágõwá rî ndrẽzó gĩâ jẽjẽ ró bı̣́ bê ngbũkpũ. Ĩtí, drílĩyî ngãzó nĩlí zẽlé lâ ꞌálâ, tãlâ ndrẽlâ ngãtá lõꞌwâ lâ bê yã rî tãsĩ. Gõꞌdá gólĩyî câ bê fê rî ꞌdĩ zẽlé rî, lõꞌwâ lâ trá yûꞌdạ́wạ́ ãlôwálâ. Ûsû ĩyî cé bı̣́ lâ ĩꞌdî ngbũkpũ fê lâ drı̣̃ı̣̂, tãlâ kậyı̣̂ gólâkâ ꞌwãzó rî âcá drẽ kô. ");
INSERT INTO avu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bê trá ĩtí rî, Yésũ drí fê ꞌdĩ trĩzó kĩ nĩ rî, “Ní rî áníkâ fí zãâ ĩtí lõꞌwâ ꞌwã ãkó, gõꞌdá õjílã õzó îcá kô ánî lõꞌwâ nyãlé óꞌdí ãlôwálâ.” Gõꞌdá nĩngá rî, lãjóꞌbá gólâkâ rî ꞌbá yî ârî ĩyî lãtrí drílâ trĩlí ꞌdĩ trá. ");
INSERT INTO avu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vó lâ sĩ, Yésũ yî drí ngãzó nĩlí cãlé Yẽrõsãlémã ꞌálâ kpá óꞌdí. Gõꞌdá drílĩyî fĩzó ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌá. Tólâ rî, Yésũ drí õjílã ûsúzó rĩꞌá ĩyî ngá lậzı̣́ꞌá gõꞌdá kpá ngá gĩ bê lâgî õnjí sĩ. Gõꞌdá gólâ drí kpá õjílã ãzâ ꞌbá yî ndrẽzó rĩꞌá ĩyî ậdı̣̂ õrĩ ãzâ ꞌbá yî ı̣̂kúrạ̃ꞌá ậdı̣̂ õrĩ ãzâ ꞌbá yî sĩ. Gõꞌdá Yésũ ndrê tã ꞌdî bê ĩtí rî, gólâ drí âꞌdózó õmbã ró, tãlâ gólĩyî rî trá võ íyî átá kâ rî îzãlé. Ĩtí rî, Yésũ drí ngãzó nĩlí tãrãbízã ậdı̣̂ ı̣̂kúrạ̃ ꞌbá yí kâ ꞌdĩ ꞌbá yî lôzélé gõꞌdá drı̣̃ lâ yî âkólé ndrĩ vũdrı̣́. Gõꞌdá gólâ drí kpá ngãzó nĩlí gbáꞌdá õjílã gólĩyî rĩ ꞌbá ĩyíkâ ãmámõ âꞌdó ꞌbá ngá fẽfẽ ró Ôvârí drí rî yî lậzı̣́lı̣́ gĩlí vólé rî lôzélé kpá ndrĩ ꞌdó vũdrı̣́. Drílâ gõzó õjílã ꞌdî ꞌbá yî lâdrólé ndrĩ vólé úlı̣́ âtâ-âtâ bê kĩ, ");
INSERT INTO avu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","17","“Úlı̣́ Ôvârí kâ îgĩlí jó Ôvârí kâ tãsĩ rî kĩ ãꞌdô yã? Ôvârí kĩ nĩ rî, ‘Jó ámákâ rĩꞌá võ ꞌbạ̃súrú ngĩíngî drí ânĩzó rû êꞌbélé ꞌá lâ rĩlí cé rãtáã ꞌẽlé ĩꞌdî.’ Ĩsáyã 56.7 Gõꞌdá nõô, ‘nĩ jâ jó ámákâ trá võ ũgũ kâ ró’, õzõ ãnî drí rĩꞌá ꞌẽlâ ꞌdĩ kâtí.” Yésũ lẽ trá võ ꞌdî âyélé cé õjílã drí rãtáã ꞌẽzó ĩꞌdî ꞌá lâ. Gólâ âyé õjílã kô ngá ĩyíkâ lậzı̣́lı̣́ ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nĩngá sĩ, drı̣̃-ꞌbá Yúdạ̃ yí kâ rî ꞌbá yî drí tã Yésũ kâ õjílã lâdrózó ꞌdĩ ârízó ĩyî. Tã ꞌdî tãsĩ rî, gólĩyî drí ngãzó rĩꞌá lạ́tı̣̂ lôndãlé Yésũ rî fũzó ũrı̣̃ drí sĩ. Tã ı̣̂sũ gólĩyíkâ kĩ, õjílã âꞌdô ꞌdẽꞌá ndrĩ Yésũ vó ĩyî âyélé, tãlâ õjílã dũû ndrĩ tı̣̂ lâ yî ậꞌdı̣̂ trá lı̣̃fı̣́ îmbâ-îmbâ Yésũ kâ ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nĩngá sĩ, tã Yésũ drí õjílã lâdrózó ạ̃ꞌdı̣́-drı̣̃ ꞌásĩ ꞌdî vósĩ, lạ̃njạ́túlı̣́ bê rî, Yésũ yî lãjóꞌbá íyíkâ yí bê drí ngãzó drı̣̃ dĩlí ĩyî gõlé ꞌbã ꞌálâ Bẽtánĩ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gõꞌdá cı̣̃ı̣́nó Yésũ yî drí ngãzó gõlé Yẽrõsãlémã ꞌálâ. Lạ́tı̣̂ ꞌásĩ rî, gólĩyî drí fê Yésũ drí trĩlí sı̣́sı̣́ rî ndrẽzó. Gõꞌdá gólĩyî âꞌdô bê rĩꞌá lậvũꞌá rî, drílĩyî fê rî ꞌdĩ ndrẽzó drã trá, gõꞌdá ꞌî trá kó õmvórẽ lâ lésĩ rãŋõ. ");
INSERT INTO avu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ĩtí rî, tã Yésũ drí fê ꞌdĩ trĩzó rî drí âgázó Pétẽrõ drı̣̃ı̣̂. Gõꞌdá drílâ ngãzó tã âtálé Yésũ drí kĩ nĩ rî, “Tã îmbá ꞌbá, ní ndrê drẽ, fê gólâ ní drí trĩlí rî drã trá, ꞌî trá kãgãꞌdã nâ.” ");
INSERT INTO avu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó Pétẽrõ yî drí kĩ nĩ rî, “Õzõ nĩ õꞌbã tã lẽlẽ ãníkâ ndrĩ gạ́gạ́ Ôvârí ꞌá rî, nĩ âꞌdô kpá îcáꞌá tã rî ꞌdĩ ꞌẽlé má tí mbârâkã Ôvârí kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Má âtâ ãnî drí nõ tã pạ̃tı̣́ı̣̃ ꞌî. Õzõ nĩ ãâtâ úlı̣́ trá únı̣́ ạ́ngı̣́ drí kĩ nĩ rî, ‘Únı̣́ ạ́ngı̣́, únjı̣̃ rû ꞌdẽlé lı̣̃mvû ândrê ꞌá rî.’ Õzõ nĩ ãâtâ úlı̣́ rî ꞌdĩ tã lẽlẽ gạ́gạ́ rákã fê kâtí rî sĩ cú ĩtí tã ı̣̂sũ rı̣̃ rı̣̃ ãkó ãlôwálâ rî, Ôvârí õró fí tã rî ãnî drí âtálé ꞌdĩ ꞌẽê ãnî drí pạ̃tı̣́ı̣̃. ");
INSERT INTO avu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tã ꞌdî tãsĩ rî, má âtâ kpá óꞌdí, õzõ nĩ õtírĩ rãtáã ꞌẽê Ôvârí drí tã ãzâ ꞌẽzó ãnî drí rî, õzõ nĩ õrî tã lẽlẽ sĩ kĩ pạ̃tı̣́ı̣̃ Ôvârí âꞌdô tã rî ꞌdĩ ꞌẽꞌá rî, tã rî ꞌdĩ âꞌdô rû ꞌẽꞌá ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Õzõ nî ãzâ ãâꞌdô bí rĩꞌá tı̣̂ îrátãꞌá Ôvârí drí, ngãtá õjílã ãzâ õꞌê tã õnjí trá ní drí yã rî, ánî fĩî ạ̃ậꞌdı̣̂ gólâ rú, ní âyê gólâ tã õnjí ꞌdĩ ꞌásĩ, tãlâ ánî átá gólâ ꞌbũû ꞌálâ rî ãâyê ró kpá tã õnjí áníkâ rî ꞌbá yî bê. ");
INSERT INTO avu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Õzõ ní õgã dó tã õnjí ãzí-ãzí kâ âyélé rî, Ôvârí âꞌdô gãꞌá kpá dó tã õnjí áníkâ rî âyélé.” ");
INSERT INTO avu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nĩngá sĩ, Yésũ yî drí cãzó kpá óꞌdí Yẽrõsãlémã ꞌálâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. Gõꞌdá gólĩyî âꞌdô bê rĩꞌá nĩꞌá ĩyî jó ạ́ngı̣́ Ôvârí kâ rî ꞌálâ õjílã lı̣̃fı̣́ îmbálé rî, lãꞌbí îmbá ꞌbá, gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ndrĩ ꞌdó gólĩyî sı̣́sı̣́-lésĩ ró rî ꞌbá yí bê, drílĩyî ngãzó ĩyî ânĩlí Yésũ ngálâ ạ̃ꞌdı̣́-drı̣̃ jó Ôvârí kâ rî kâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nĩngá sĩ rî, drílĩyî tã îjízó Yésũ tı̣́ kĩ nĩ rî, “Ndá drı̣́-ãcê ãꞌdô kâ ꞌî ní drı̣́gạ́ rĩzó õjílã lı̣̃fı̣́ îmbálé ạ̃ꞌdı̣́-drı̣̃ jó Ôvârí kâ rî kâ ꞌásĩ yã? Kó ãꞌdî fẽ drẽ drı̣́-ãcê rî ꞌdĩ ní drí nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nĩngá sĩ, Yésũ drí tã îjî gólĩyíkâ ꞌdĩ drı̣̃ lâ lôgõzó kĩ, “Má âꞌdô kpá ãnî îjíꞌá tã îjî sĩ. Õzõ tã îjî ámákâ ꞌdĩ nĩ õlôgõ tã-drı̣̃ lâ trá rî, má drí ꞌdẽzó fí drı̣́-ãcê ángô rî sĩ má drí rĩzó tã nô ꞌbá yî ꞌẽlé nõ lôfõlé ãnî drí. ");
INSERT INTO avu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ĩtí rî, ãꞌdî âjô Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî nĩ ânĩlí rĩlí bãbãtízĩ ꞌẽlé õjílã drí yã? Ôvârí âjô gólâ nĩ bãbãtízĩ ꞌẽlé ngãtá õjílã mvá âjô gólâ nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nĩngá sĩ, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí ngãzó rĩꞌá tã îjî Yésũ kâ ꞌdĩ ôjálé ĩyî lãfálé ꞌásĩ kĩ nĩ rî, “Mã âꞌdô tã îjî gólâkâ ꞌdĩ drı̣̃ lâ jãꞌá ángô tí yã? Õzõ mã õjâ kĩ nĩ rî, Ôvârí âjô Yõwánĩ nĩ rî, ꞌdĩî gólâ âꞌdô tã lôgõꞌá ãmâ drí kĩ nĩ rî, ‘Õzõ ãꞌdô trá ĩtí rî, nĩ gã dó úlı̣́ Yõwánĩ kâ rî lẽlé ãꞌdô tãsĩ yã?’ ");
INSERT INTO avu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Gõꞌdá õzõ mã ãâtâ kĩ, õjílã ãzâ ãâjô gólâ nĩ rî, âꞌdô âꞌdóꞌá ángô tí yã?” Gólĩyî rî tã ꞌdî ôjálé ꞌdĩ ũrı̣̃ drí, tãlâ õjílã ĩyíkâ rî ꞌbá yî õzó kô rû jãâ ĩyî rú, tãlâ õjílã rî ꞌdĩ ꞌbá yî ndrĩ tã pạ̃tı̣́ı̣̃ ró lẽ ĩyî tã trá kĩ nĩ rî, Yõwánĩ rĩꞌá tã ậngũ ꞌbá nyãányâ Ôvârí kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Âꞌdólé bê trá ĩtí rî, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí ngãzó tã-drı̣̃ lôgõlé ĩyî Yésũ drí kĩ nĩ rî, “Mã nı̣̃ı̣́ gólâ Yõwánĩ rî âjó ꞌbá rî kô.” Nĩngá sĩ, Yésũ drí ngãzó úlı̣́ âtálé gólĩyî drí kĩ nĩ rî, “Õzõ tã-drı̣̃ lôgõ ãníkâ ãꞌdô ĩtí rî, gõꞌdá má gã kpá trá dó drı̣́-ãcê fẽ ꞌbá má drí rî âꞌdálé ãnî drí.” ");
INSERT INTO avu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nĩngá sĩ, Yésũ drí ngãzó úlı̣́ mãnĩgõ âtálé drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí. Úlı̣́ mãnĩgõ rî ĩꞌdî nõtí. “Ãgô ãzâ bê ãlô. Drílâ ngãzó fê õzõ âlâꞌbâ kâtí gólâ rĩzó õdrá ꞌẽlé lõꞌwâ lâ ꞌásĩ rî ı̣̂ꞌdı̣́lı̣́ dũû yí drí ạ́mvú ꞌá. Gõꞌdá drílâ ndõgõ gãzó dîrî gbãâ rú lâ sĩ, tãlâ ũgú gõꞌdá kõrõnyã bê õzó lạ́tı̣̂ ûsú âfízó ânĩlí fê lõꞌwâ ꞌdĩ îzãlé. Gõꞌdá éêdê võ ãzâ kpá kúnı̣́ ꞌá gũạ̃lı̣̃-gũạ̃lı̣̃ ĩtí rĩzó õdrá ꞌdĩ zãlé ꞌá lâ. Gõꞌdá drílâ kpãrá ꞌdı̣̃zó ûrû, tãlâ kpá ạ́mvú vó ndrẽ ꞌbá drí rĩzó mbãlé rĩlí gá drı̣̃ lâ ꞌá rĩꞌá ạ́mvú vó ndrẽlé. Nĩngá sĩ, gólâ drí ạ́mvú ꞌwã ꞌbá ãzâ ꞌbá yî ậzı̣́zó ânĩlí lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌá, õzõ õꞌwâ trá rî, yí fẽ ró ũrûkậ lâ bê gólĩyî drí. Gõꞌdá gólâ rî gógó drí íyíkâ ngãzó nĩlí ꞌbạ̃drı̣̃ ãzâ ꞌálâ jẽjẽ ró. ");
INSERT INTO avu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gólâ vólé sĩ rî, fê lõꞌwâ ꞌdĩ ꞌbá yî drí lı̣̂njı̣́zó kãlé. Gõꞌdá lõꞌwâ ꞌdĩ ꞌbá yî ôkírĩ tú rî, ạ́mvú lı̣́pı̣̂ nĩ ꞌbá trá ꞌbạ̃drı̣̃ lídí ꞌálâ nã drí ngãzó lãjóꞌbá íyíkâ âjólé kó tólâ sĩ ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ, tãlâ lõꞌwâ âꞌdó ꞌbá trá íyíkâ ró rî tãsĩ yí drí. ");
INSERT INTO avu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Gõꞌdá ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî gã dó. Nĩngá sĩ, drílĩyî lãjóꞌbá âjólé ꞌdĩ rũzó ãnjĩ cãlé kpãdí-kpãdí õnjí lâ drı̣̃ı̣̂, gõꞌdá drílĩyî drı̣́ yĩzó rú lâ sĩ gõlé vólé ạ́mvú lı̣́pı̣̂ ngálâ drı̣́-drı̣́ı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Vó lâ sĩ, ạ́mvú lı̣́pı̣̂ drí kpá lãjóꞌbá íyíkâ ãzâ âjózó ạ́mvú ꞌwã ꞌbá rî ꞌdĩ ꞌbá yî ngálâ zãâ lõꞌwâ íyíkâ ró rî tãsĩ. Gõꞌdá ꞌdĩî rî, ạ́mvú ꞌwã ꞌbá drí ngãzó ĩyî rĩꞌá lãjóꞌbá ꞌdĩ cãlé õnjí ró. Gólĩyî ꞌê tã ãnyĩ kâ trá ãmbá lãjóꞌbá ꞌdĩ drí, gõꞌdá kpá gólâ rî lôꞌdázó drõlé gõlé vólé. ");
INSERT INTO avu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nĩngá sĩ, ạ́mvú lı̣́pı̣̂ drí ngãzó kpá lãjóꞌbá íyíkâ ãzâ âjólé ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ. Gõꞌdá ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí lãjóꞌbá ꞌdĩ fũzó. Lé ĩtí rî, ạ́mvú lı̣́pı̣̂ drí rĩzó fí zãâ lãjóꞌbá íyíkâ rî ꞌbá yî âjólé ãlô-ãlô ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ. Nĩngá sĩ, ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí ĩyíkâ rĩzó kpá zãâ, lãjóꞌbá rĩꞌá âjólâ ꞌdĩ ꞌbá yî, ãzâ ꞌbá yî cãlé gõꞌdá ãzâ ꞌbá yî ûfúlı̣́. ");
INSERT INTO avu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Gõꞌdá vó lâ sĩ, lâkí ꞌbá ạ́mvú lı̣́pı̣̂ drí jõlé ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ kó rî, cé mvá lâ drílâ lẽlé tákányĩ rî ĩꞌdî. Ĩtí rî, ạ́mvú lı̣́pı̣̂ ꞌdĩ drí íyî mvá ꞌdĩ jõzó ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ ạ̃dũkũ lâ ró tã ı̣̂sũ-ı̣̂sũ bê yí drı̣̃ı̣̂ kĩ nĩ rî, ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî âꞌdô ĩyî íyî mvá ꞌdĩ ı̣̂njı̣̃ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gõꞌdá võ rî ꞌdĩ ꞌá nĩngá rî, mvá lâ ꞌdĩ âcálé bê ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ngálâ ạ́mvú ꞌálâ rî, ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí ngãzó tã ngõlé kírî ró ĩyî lãfálé ꞌásĩ kĩ nĩ rî, ‘Nõô trá rĩꞌá gólâ drı̣́-vó lı̣́pı̣̂ ró rî ĩꞌdî. Nĩ ngâ mã fû ró gólâ vólé. Vó lâ sĩ rî, drı̣́-vó ꞌdĩ âꞌdô âꞌdóꞌá ãmákâ ró.’ ");
INSERT INTO avu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ĩtí rî, drílĩyî ạ́mvú lı̣́pı̣̂ rî mvá ꞌdĩ fũzó gõzó ãvõ lâ trõlé vũlı̣́ vólé ạ́mvú ꞌásĩ tã ạ̃dũkũ ró. ");
INSERT INTO avu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ngbãângbânõ rî, má îjî ãnî nõtí, ạ́mvú ꞌdĩ lı̣́pı̣̂ lâ âꞌdô ãꞌdô ꞌẽꞌá ĩꞌdî yã? Má âꞌdô âꞌdáꞌá lâ ãnî drí. Gólâ âꞌdô ângáꞌá ânĩlí ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî ûfúlı̣́ ngbá, gõzó ạ́mvú ꞌdĩ trõlé fẽlé ạ́mvú ꞌwã ꞌbá ãzâ ꞌbá yî drí vó lâ ndrẽlé.” ");
INSERT INTO avu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gõꞌdá Yésũ drí kpá tã âtázó íyî ífífí tãsĩ kĩ nĩ rî, “Nĩ zı̣́ tã nô kô tã îgĩ Ôvârí kâ ꞌásĩ yã? Gólâ kĩ nĩ rî, ‘Ậjû nyãányâ gólâ jó ꞌdı̣̃ ꞌbá yî drí gãlé dó rî, âꞌdô gõꞌdá trá ậjû tã lâ drí lâzélé rõô jó kâ ró rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tã ꞌdî rĩꞌá Ôvârí drı̣́gạ́ sĩ, gõꞌdá gólâ rî nyãányâ ꞌê nĩ. Ãmâ tı̣̂ ậꞌdı̣̂ trá tã ꞌdî drí sĩ.’ ” ");
INSERT INTO avu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yésũ ndẽ bê úlı̣́ âtâ-âtâ ꞌdĩ rî, drı̣̃-ꞌbá Yúdạ̃ yí kâ lẽ trá gólâ rî rũlı̣́, tãlâ gólĩyî nı̣̃ trá kĩ nĩ rî, Yésũ âtâ úlı̣́ mãnĩgõ ꞌdî ꞌbá yî ĩyî rú. Gõꞌdá gólĩyî âyê Yésũ gõzó nĩlí vólé cú ĩtí gólâ rî rũ ãkó, tãlâ gólĩyî trá ũrı̣̃ ró õjílã õꞌbí ꞌdĩ ꞌbá yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tólâ sĩ, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí ngãzó Pạ̃rúsı̣̃ ãzâ ꞌbá yî jõlé õjílã gólĩyî ꞌdẽ ꞌbá kúmú Ẽródẽ vó rî ꞌbá yí bê Yésũ ngálâ nĩlí gólâ rî ûjũlı̣́ tã âtâ-âtâ ányâ gólâkâ tãsĩ, tãlâ gólâ âtâ ró tã ányâ bê kũmũ Sízã kâ rú. ");
INSERT INTO avu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nĩngá sĩ, gólĩyî drí âcázó Yésũ ngálâ, gõꞌdá drílĩyî tã âtázó kĩ nĩ rî, “Ãmbá, mã nı̣̃ trá kĩ nĩ rî, ı̣́ı̣̂njı̣̃ nî trá tã mbı̣̂ ꞌẽ ꞌbá ró. Ní âyé õjílã kôꞌdáwá ánî drı̣̃ îzãlé, ãmbã gólĩyíkâ sĩ. Võ rî ꞌdĩ ꞌá rî, pạ̃tı̣́ı̣̃ ní rî õjílã îmbálé tã Ôvârí kâ rî ꞌbá yî sĩ. Âꞌdô bê trá ĩtí rî, mã îjî tã ní tı̣́. Rĩꞌá tã mbı̣̂ ꞌî ômbê gĩzó kúmú ạ́ngı̣́ Rómã kâ Sízã drí ngãtá rĩꞌá tã ányâ ꞌî yã? ");
INSERT INTO avu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mã õgî ômbê ngãtá mã õgã dó ômbê gĩlí yã?” Gõꞌdá Yésũ ârílí bê tã îjî ꞌdĩ rî, gólâ nı̣̃ tã ı̣̂sũ gólĩyíkâ trá tã ậnjú ꞌbá ró. Nĩngá sĩ, drílâ tã îjízó gólĩyî tı̣́ kĩ nĩ rî, “Nĩ lẽ ámâ âdólé tã ányâ âtálé mı̣́rı̣̃ rú ãꞌdô tãsĩ yã? Nĩ âfẽ drẽ lãfâ ãnî drí rĩzó ômbê gĩlí ꞌdĩ ãlô rî má drí, tãlâ má ndrê ró bê.” ");
INSERT INTO avu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ĩtí rî, gólĩyî drí ngãzó ậdı̣̂ ífí ꞌdĩ âjílí Yésũ ngálâ. Nĩngá sĩ, drílâ ậdı̣̂ ífí ꞌdĩ âtrõzó âꞌdálé gólĩyî drí, gõꞌdá tã îjízó kĩ, “Nõô ãꞌdî rî líndrí ꞌî ậdı̣̂ ífí nõ rú, gõꞌdá rú îgĩlí rú lâ ꞌá nõ bê yã?” Nĩngá sĩ, drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Kúmú ạ́ngı̣́ Rómã kâ Sízã rî líndrí ꞌî rú lâ bê.” ");
INSERT INTO avu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kĩ, “Õzõ ãꞌdô ĩtí rî, gólâ ĩꞌdî lãfâ ꞌdĩ lı̣́pı̣̂ lâ ꞌî, nĩ lôgõ lãfâ ꞌdĩ vólé gólâ drí ômbê gĩgĩ sĩ. Gõꞌdá ãnî rî gógó ífífí lâ ãnî lı̣́pı̣̂ rĩꞌá Ôvârí ĩꞌdî, nĩ fẽ ãnî nyãányâ gólâ drí tã gólâ drí lẽlé ãnî drí ꞌẽlé rî ꞌẽzó.” Ĩtí rî, ãgô ꞌdĩ ꞌbá yî tı̣̂ lâ yî drí ậꞌdı̣́zó, gõꞌdá drílĩyî ngãzó nĩlí ĩyî vólé. ");
INSERT INTO avu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nĩngá sĩ, õjílã zı̣̃lı̣́ Sạ̃dúsı̣̃ rî ꞌbá yî drí ânĩzó kpá Yésũ ngálâ gólâ rî ûjũlı̣́. Gólĩyî õjílã tã îmbá ꞌbá kĩꞌá nĩ rî, Ôvârí õlîdrí õjílã kó kô õdrã ꞌásĩ rî yî ĩꞌdî. Gólĩyî âcâ bê rî, drílĩyî Yésũ rî îjízó kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ãmbá, ạ̃kû ró Músạ̃ îgĩ tã trá ãmâ drí ꞌẽlé kĩ, ‘Õzõ nî ãzâ ánî ậdrúpı̣̃ õdrã trá õkó lâ rî âyélé cú ĩtí mvá ãkó rî, nî ậdrúpı̣̃ lâ ꞌdĩ âꞌdô ạ̃yı̣́zı̣́ ꞌdĩ trõꞌá, ãꞌdô ró bê mvá tı̣̃zó ánî ậdrúpı̣̃ ạ̃ꞌdı̣́ ró ꞌdĩ võ lâ ꞌá.’ ");
INSERT INTO avu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ꞌDõvó, tã âꞌdâ ró, mã ngî drẽ íꞌdígówá ní drí. Õjílã bê rĩꞌá ĩyî zãlô njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdó ậdrúpı̣̃ ró. Nĩngá sĩ, ậdrúpı̣̃ sı̣́sı̣́ rî drí ngãzó õkó trõlé. Gõꞌdá gólâ drã bê rî, gólâ cú ĩtí ꞌdĩyímvá ãkó õkó rî ꞌdĩ bê. ");
INSERT INTO avu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tã rî ꞌdĩ tãsĩ rî, ậdrúpı̣̃ lâ tı̣̃lı̣́ ũgúlı̣́ lâ ꞌá rî drí õkó rî ꞌdĩ trõzó. Nĩngá sĩ, gólâ drí kpá drãzó cú ĩtí ꞌdĩyímvá ãkó õkó ꞌdĩ bê. Gõꞌdá ậdrúpı̣̃ nâ lâ ró rî drí kpá õkó ãlô ꞌdĩ trõzó. Nĩngá sĩ, gõzó kpá drãlé vólé. ");
INSERT INTO avu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ꞌDó lạ́tı̣̂ ãlô ꞌdĩ ꞌásĩ, ậdrúpı̣̃ njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdî ꞌbá yî drí ꞌdó õkó ꞌdĩ trõzó ãlô-ãlô, gõꞌdá ôdrãzó kpá ngbá vólé ꞌdĩyímvá ãzãkã tı̣̃ ãkó. Gõꞌdá ạ̃dũkũ lâ ró, õkó rî ꞌdĩ nyãányâ lâ drí ngãzó drãlé kpá vólé. ");
INSERT INTO avu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ngã ậdrúpı̣̃ njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdî ꞌbá yî drí õkó ꞌdĩ trõzó trá ndrĩ õkó ró nõ, gõꞌdá ı̣̃tú gólâ ậdrúpı̣̃ ꞌdî ꞌbá yî õkó rî ꞌdĩ bê drí lîdrízó õdrã ꞌásĩ rî sĩ rî, õkó rî ꞌdĩ âꞌdô ꞌbãꞌá ậdrúpı̣̃ ángô rî kâ ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ĩtí rî, Yésũ drí tã ꞌdî drı̣̃ lâ lôgõzó gólĩyî drí kĩ nĩ rî, “Tã ı̣̂sũ ãníkâ rĩꞌá ányâ ró, tãlâ nĩ nı̣̃ı̣́ tã ífí úlı̣́ Ôvârí kâ kô. Gõꞌdá nĩ gã dó tã lẽlé kĩ, Ôvârí mbârâkã bê õjílã lîdrílí õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ị̃tú gólâ õjílã drí lîdrízó âfõlé õdrã ꞌásĩ rî tú rî, ãgô trõó gõꞌdá õkó kô, gõꞌdá ófẽé õkó kpá kôꞌdáwá ãgô drí õkó ró. Võ ꞌdî ꞌá rî, õjílã âꞌdô âꞌdóꞌá õzõ mãlãyíkã gólĩyî âꞌdó ꞌbá ûrú ꞌálâ rî ꞌbá yí kâtí. ");
INSERT INTO avu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ãꞌdô lîdrî-lîdrî õdrã ꞌásĩ rî tãsĩ rî, búkũ Ôvârí kâ ꞌá, nĩ zı̣́ tã Músạ̃ drí îgĩlí úlı̣́ Ôvârí drí âtálé gólâ drí fê cú lạ̃sı̣́ bê yí ꞌá rî kô yã? Ị̃tú rî ꞌdĩ sĩ, Ôvârí kĩ Músạ̃ drí rî, ‘Mâ Ôvârí gólâ Ãbãrãyámã yî drí rĩꞌá rõlâ Yãkóbã yî Ĩsákã yí bê rî ĩꞌdî.’ ");
INSERT INTO avu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Úlı̣́ ꞌdĩ ꞌbá yî âꞌdâ tã ãmâ drí kĩ, lîdrî-lîdrî õjílã kâ õdrã ꞌásĩ rî rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî. Nĩ ndrê drẽ, îcâ fí trá Ôvârí drí tã nô âtázó ãvõ tãsĩ kĩ, gólĩyî rĩꞌá gólâ rî rõlé yã? Îcá kô. Gólâ Ôvârí õjílã gólĩyî lédrẽ-lédrẽ ró rî ꞌbá yî drí rõlé ꞌî. Nĩ ndrê drẽ, Ãbãrãyámã yî ôdrã bê kpálé rî, gólĩyî líndrí bê zãâ ûrú ꞌálâ Ôvârí bê. Ĩtí rî, tã ı̣̂sũ ãníkâ kĩꞌá nĩ rî õjílã õlîdrí kô õdrã ꞌásĩ ꞌdî rî rĩꞌá ányâ ró.” ");
INSERT INTO avu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lãꞌbí îmbá ꞌbá ãzâ ãlô ârî Yésũ trá tã ꞌdî ꞌbá yî ngĩrĩ ꞌá Sạ̃dúsı̣̃ ꞌdĩ ꞌbá yí bê. Gõꞌdá gólâ ndrê bê Yésũ lôgõ tã îjî gólĩyíkâ ꞌdĩ trá tã nı̣̃nı̣̃ sĩ rî, gólâ drí kpá ngãzó Yésũ rî îjílí tã îjî sĩ kĩ, “Tã ãmbá ndrĩ Ôvârí kâ ꞌbãlé ꞌdĩ lãfálé lâ ꞌásĩ rî, tã ꞌbãꞌbã ángô rî íyíkâ ĩꞌdî lậvũlı̣́ kôrô ãmâ drí ârílí yã?” ");
INSERT INTO avu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nĩngá sĩ, Yésũ drí tã îjî gólâkâ ꞌdĩ drı̣̃ lâ lôgõzó kĩ, “Tã ꞌbãꞌbã gólâ lậvũ ꞌbá kôrô ãnî drí ꞌẽlé rî ĩꞌdî nõ, ‘Ãnî õjílã ãmákâ Ĩsĩrãꞌélẽ kâ, nĩ ârî drẽ tã nô! Ôvârí ãmákâ Yãkóvã rĩꞌá Ôvârí ãlô pạ̃tı̣́ı̣̃ rî ĩꞌdî. Ôvârí ãzâ yûꞌdạ́wạ́. ");
INSERT INTO avu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nĩ ꞌbã Yãkóvã Ôvârí ãníkâ lôvó lâ pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ ndrĩ, ãnî líndrí sĩ ndrĩ, tã ı̣̂sũ ãníkâ sĩ ndrĩ, gõꞌdá kpá ãnî mbârâkã sĩ ndrĩ.’ ");
INSERT INTO avu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Vó lâ sĩ, tã ꞌbãꞌbã ãzâ lậvũ ꞌbá kôrô rı̣̃ lâ ró rî ĩꞌdî nõ. ‘Nĩ ꞌbã õjílã ãzí lôvó kpá té õzõ ãnî drí ãnî lôvó ꞌbãrẽ kâtí.’ Tã ꞌbãꞌbã ãzâ yûꞌdạ́wạ́ lậvũ ꞌbá kôrô tã ꞌbãꞌbã gólĩyî rı̣̃ ꞌdî ꞌbá yî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nĩngá sĩ, lãꞌbí îmbá ꞌbá ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Tã îmbá ꞌbá, ní pẽ úlı̣́ trá dó, úlı̣́ áníkâ rĩꞌá mbı̣̂ kĩꞌá nĩ rî, Ôvârí rĩꞌá ãlô gõꞌdá Ôvârí ãzâ yûꞌdạ́wạ́. ");
INSERT INTO avu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ôvârí rî lôvó ꞌbãꞌbã pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ ndrĩ, ãnî líndrí sĩ ndrĩ, tã ı̣̂sũ ãníkâ sĩ ndrĩ, ãnî mbârâkã sĩ ndrĩ, gõꞌdá ãzí-ãzí lôvó ꞌbãꞌbã té õzõ ãnî drí ãnî nyãányâ lôvó ꞌbãrẽ kâtí rî, gõꞌdá ĩtí rî, tã ꞌbãꞌbã rı̣̃ ꞌdî ꞌbá yî rĩꞌá ĩyî lậvũ ꞌbá kôrô kõrõnyã lı̣̃lı̣̃ õjílã drí rĩꞌá zãlâ ngá fẽfẽ ró Ôvârí drí rî ꞌbá yî drı̣̃ı̣̂ sĩ. Kõrõnyã lı̣̃lı̣̃ lôvó ãkó rî rĩꞌá tã tãkó ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nĩngá sĩ, Yésũ ârî bê úlı̣́ ãgô ꞌdĩ kâ ꞌdĩ ꞌbá yî rî, gólâ nı̣̃ trá kĩ, ãgô ꞌdĩ âtâ úlı̣́ rî ꞌdĩ ꞌbá yî tã nı̣̃nı̣̃ sĩ. Gõꞌdá drílâ tã âtázó ãgô rî ꞌdĩ drí kĩ, “Nî trá ãnyî ꞌẽꞌá tã Ôvârí drí õjílã ꞌbãzó âꞌdólé íyíkâ ró rî nı̣̃lı̣́ mbı̣̂mbı̣̂.” Vó lâ sĩ, õjílã gõꞌdá trá ĩyî ndrĩ ũrı̣̃ ró tã îjílí Yésũ tı̣́ tã ûjũ-ûjũ ró. ");
INSERT INTO avu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gõꞌdá nĩngá sĩ, Yésũ rĩꞌá õjílã îmbáꞌá ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌá. Drílâ ngãzó tã îjílí kĩ nĩ rî, “Lãꞌbí îmbá ꞌbá âtâ ĩyî kĩ nĩ rî, ‘Õjílã Ôvârí drí âjólé ꞌdíyî pã ꞌbá ró rî âꞌdô âꞌdóꞌá ózõwá kúmú ạ́ngı̣́ Dạ̃wúdı̣̃ kâ ró.’ Âꞌdô âꞌdóꞌá ĩtí ꞌdĩ ángô tí ró yã? ");
INSERT INTO avu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dạ̃wúdı̣̃ rî nyãányâ pẽ úlı̣́ gólĩyî Líndrí Tãndí Ôvârí kâ drí âꞌdálé drílâ ꞌdíyî pã ꞌbá ꞌdĩ tãsĩ rî trá kĩ, ‘Ôvârí Yãkóvã âtâ trá kúmú ámákâ drí kĩ nĩ rî, “ꞌDõvó ní rî ámâ gãrã drı̣̃ ꞌá gõlé drı̣́-ágó drı̣̃ lésĩ ãngó nõ rũlı̣́ má bê. Gõꞌdá má âꞌdô ạ̃jú-ꞌbá-ãzí áníkâ rî ꞌbá yî ꞌbãꞌá rĩlí ánî pá zẽlé.” ’ ");
INSERT INTO avu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nĩ ndrê, Dạ̃wúdı̣̃ rî nyãányâ zı̣̂ ꞌdíyî pã ꞌbá Ôvârí ngá lésĩ ꞌdî trá kúmú íyíkâ ró. Gõꞌdá bê trá ĩtí ꞌdĩ kâtí rî, ꞌdíyî pã ꞌbá ꞌdĩ âꞌdô ꞌbãꞌá cé Dạ̃wúdı̣̃ rî ózõwá ró ángô tí yã?” Yésũ âtâ tã ꞌdî ĩtí, tãlâ gólâ lẽ gólĩyî drí nı̣̃lı̣́ dódó, ꞌdíyî pã ꞌbá ꞌdĩ rî âꞌdô ꞌbãꞌá õjílã mvá ró, kpá õzõ Ôvârí rî ífífí tí. Nĩngá sĩ, õjílã tı̣́lı̣́lı̣́ ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî ꞌá ꞌdĩ ꞌbá yî drí úlı̣́ Yésũ kâ ꞌdĩ tã-drı̣̃ lâ lẽzó ãyĩkõ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yésũ âꞌdâ tã kpá kĩ nĩ rî, “Ãnî lı̣̃fı̣́ õmbâ ãnî rú, lãꞌbí îmbá ꞌbá tãsĩ, nĩ õzó kô ꞌbãâ õzõ gólĩyî tí. Gólĩyî lẽ õjílã ndrĩ drí ĩyî ndrẽlé õjílã ãmbá ró. Gólĩyî lẽ ítá kũndrũ-kũndrũ ĩyíkâ sõlé gõzó ngãlé nĩꞌá lậmú bê dîrî võ ngá lậzı̣̂ kâ ꞌásĩ, tãlâ õjílã õꞌê ró bê nî-bê-yã ĩyî drí õzõ õjílã ãmbá kâtí rû ı̣̂njı̣̃-ı̣̂njı̣̃ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Gõꞌdá kpá õzõ gólĩyî õfî ĩyî trá jó tã Ôvârí kâ ârî kâ ꞌá rî, gólĩyî fî rĩlí té rĩ-võ sũ ꞌbá kôrô rî ꞌbá yî drı̣̃ı̣̂ sĩ. Kãrámã sĩ rî, gólĩyî lẽ kpá rĩlí rĩ-võ sũ ꞌbá kôrô rî ꞌbá yî drı̣̃ı̣̂ ngá nyãlé õjílã ãmbâ-ãmbâ bê. ");
INSERT INTO avu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gólĩyî njãâ rãtáã ꞌẽlé Ôvârí drí ãcê ró, tãlâ ı̣́ı̣̃ı̣̂sũ ró bê kĩ nĩ rî, yĩ âꞌdô ĩyíkâ lậvũ ꞌbá gạ̃rạ̃ rî ĩꞌdî. Gõꞌdá nĩ ndrê drẽ tã õnjí gólĩyî nyãányâ drí rĩꞌá ꞌẽlâ rî. Gõꞌdá óꞌbã gólĩyî bê rĩꞌá ngá ꞌẽlé ạ̃yı̣́zı̣́ rî ꞌbá yî drí vó lâ yî ndrẽlé rî, gólĩyî âdô ạ̃yı̣́zı̣́ ꞌdĩ ꞌbá yî lãfâ gólĩyíkâ tãsĩ. Ôvârí âꞌdô lâŋõ ândrê fẽꞌá õjílã ꞌdî ꞌbá yî drí.” ");
INSERT INTO avu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nĩngá sĩ, Yésũ drí ngãzó nĩlí rĩlí vũdrı̣́ ãnyî ngá õjílã drí rĩzó lãfâ ngá fẽfẽ ró Ôvârí drí ꞌá lâ rî lạ̃gạ́tı̣́ jó ạ́ngı̣́ Ôvârí kâ rî ꞌá. Gólâ rî trá rĩꞌá õjílã gólĩyî ndrĩ rĩ ꞌbá ânĩlí lãfâ ngá fẽfẽ ĩyíkâ ró rî ꞌbá yî ꞌbãꞌbã lâ yî ngá ꞌdĩ ꞌá rî ndrẽlé. Ngá-tı̣̂ dũû ꞌbá ânĩꞌá ĩyî kpá lãfâ ãmbá ãmbá ꞌbãlé ngá ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Gõꞌdá ạ̃yı̣́zı̣́ ãzâ lãfâ ĩzã ꞌbá ró rî drí kpá ânĩzó ngá fẽfẽ íyíkâ rî bê fẽlé Ôvârí drí. Drílâ lãfâ ífí ạ̃mbúkũ íyíkâ cé fínyáwá rı̣̃ rî ꞌbá yî âtrõzó ꞌbãlé ngá ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gõꞌdá Yésũ ndrélé bê gólâ rî, drílâ ngãzó lãjóꞌbá íyíkâ rî ꞌbá yî ậzı̣́lı̣́ ânĩlí ãnyî, gõꞌdá gólĩyî ânĩlí bê ĩyî rî, Yésũ drí tã âtázó gólĩyî drí kĩ, “Nĩ ndrê ạ̃yı̣́zı̣́ lãfâ ĩzã ꞌbá nã. Má âtâ tã pạ̃tı̣́ı̣̃ ꞌî ãnî drí. Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá, ạ̃yı̣́zı̣́ lãfâ ĩzã ꞌbá ró nã ꞌbã lãfâ ãmbá ꞌî ngá nõ ꞌá lậvũlı̣́ kôrô õjílã ãzâ ꞌbá yî drı̣̃ı̣̂ sĩ, ");
INSERT INTO avu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","tãlâ õjílã ãmbá ꞌdĩ ꞌbá yî ndrĩ ꞌdó rĩꞌá ĩyî lãfâ ạ̃mbúkũ bê ĩyî lĩkítí ꞌásĩ, lãfâ gólĩyî drí ꞌbãlé ngá nõ ꞌá nõ rî ũrûkậ lâ ꞌî. Gõꞌdá ạ̃yı̣́zı̣́ ꞌdĩ ꞌbã íyíkâ rî trá ndrĩ, ũrûkậ lâ âyé ãkó yí drí ngá pãzó drı̣̃ lâ.” ");
INSERT INTO avu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yésũ yî lãjóꞌbá íyíkâ yí bê drí ngãzó âfõlé vólé jó ạ́ngı̣́ Ôvârí kâ rî ꞌásĩ. Gólĩyî drí rĩrĩ âfõlé rî ꞌá rî, lãjóꞌbá ãlô lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî lãfálé sĩ drí tã âtázó gólâ drí kĩ, “Tã îmbá ꞌbá, jó ꞌdı̣̃lı̣́ Ôvârí drí nõ ꞌbá yî sû trá kôrô. Ní ndrê drẽ kúnı̣́ mvá lâ yî ꞌdó rĩꞌá ạ́ngı̣́ ạ́ngı̣́ ró ãbẽ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Gõꞌdá Yésũ drí tã-drı̣̃ ꞌdî lôgõzó gólĩyî drí kĩ nĩ rî, “Nĩ ndrê jó ạ́ngı̣́ ạ́ngı̣́ sũsũ ró ꞌdĩ ꞌbá yî. Pạ̃tı̣́ı̣̃ ró, má âtâ tã ãnî drí ndrĩ, ı̣̃zạ́tú rî, áâꞌdô ûfúꞌá lâ ndrĩ. Kúnı̣́ mvá ãzãkã ãlôlâ lâkí kô rû âdrõ-âdrõ ró gá ãzí-ãzí drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nĩngá sĩ, Yésũ yî drí ngãzó nĩlí mbãlé únı̣́ fê dõ kâ bê yí drı̣̃ı̣̂ rî drı̣̃ ꞌálâ. Únı̣́ rî ꞌdĩ drı̣̃ sĩ, óndrê jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ tõ. Gõꞌdá gólâ õtírĩ ꞌbãâ rĩꞌá únı̣́ ꞌdĩ drı̣̃ rî, Pétẽrõ, Yãkóbã, Yõwánĩ, gõꞌdá kpá Ãndĩríyã yî drí rû êsézó ĩyî ãnyî Yésũ rî îjílí ı̣̃nı̣́nı̣̂ ró kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ꞌDõvó, ní âꞌdâ kậyı̣̂ gólâ ꞌẽzó jó Ôvârí kâ nõ îzãlé rî ãmâ drí. Ní gõ ró kpá lãmbé tã gólĩyî ꞌẽ ꞌbá âꞌdólé sı̣́sı̣́ tã âꞌdâ ró kĩꞌá nĩ rî kậyı̣̂ rî ꞌdĩ trá ãnyî rî âꞌdálé ãmâ drí.” ");
INSERT INTO avu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ĩtí rî, Yésũ drí tã lôgõzó gólĩyî drí kĩ, “Ãnî lı̣̃fı̣́ õmbâ ãnî rú. Nĩ âyê õjílã ãzãkã kô ãnî âdólé âgõ-âgõ ámákâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Má âtâ tã ꞌdî ĩtí, tãlâ õjílã dũû âꞌdô ĩyî ânĩꞌá ꞌdó ámâ rú bê ĩyî sı̣́lı̣́ sĩ tã âꞌbã-âꞌbã bê kĩ, ‘Mâ ꞌdíyî pã ꞌbá Ôvârí drí âjólé rî ĩꞌdî.’ Ĩtí rî, gólĩyî âꞌdô õjílã dũû âdóꞌá lạ́tı̣̂ Ôvârí kâ âyélé. ");
INSERT INTO avu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Gõꞌdá kpá õzõ nĩ ãârî tã ạ̃jú kâ trá ãnyî ãnyî, gõꞌdá kpá õzõ nĩ ãârî tã õmbã kâ trá rî, nĩ ꞌê ũrı̣̃ kô. Tã ĩtí ꞌdĩ ꞌbá yî îcâ trá âꞌdólé õzõ tã Ôvârí kâ lẽlé rî kâtí. Gõꞌdá ạ̃dũkũ ãngó nõ kâ âcá drẽ kô. Ngá õnjí ãzâ ꞌbá yî âꞌdô kpá rû ꞌẽꞌá cákáꞌdá. ");
INSERT INTO avu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pạ̃tı̣́ı̣̃ ró, ꞌbạ̃drı̣̃ âꞌdô ngãꞌá ꞌdẽlé ạ̃jú bê ꞌbạ̃drı̣̃ ãzí drı̣̃ı̣̂. Kúmú ạ́ngı̣́ ãzâ ạ̃jú ꞌbũ ꞌbá íyíkâ bê âꞌdô ngãꞌá ĩyî ꞌdẽlé ạ̃jú bê kúmú ạ́ngı̣́ ãzí drı̣̃ı̣̂. Gõꞌdá kpá ı̣̃nyạ́kú drı̣̃ âꞌdô rû îyáꞌá gbı̣̃ gbı̣̃ gbı̣̃ rõô võ drı̣̃ ãzâ ꞌbá yî ꞌásĩ. Lõfó õnjí tẽtẽ âꞌdô ꞌdẽꞌá õjílã drı̣̃ı̣̂. Lâŋõ rî ꞌdĩ ꞌbá yî rĩꞌá õzõ ngá lâzê-lâzê sı̣́sı̣́ rĩ ꞌbá drı̣̃ îngálé drẽ ãkpãkãꞌdã útı̣́ mvá kô rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yésũ sõ drı̣́-mbílí kpá lãjóꞌbá íyíkâ rî ꞌbá yî lı̣̃fı̣́ kĩ nĩ rî, “Ãnî lı̣̃fı̣́ õmbâ ãnî rú, õjílã âꞌdô ãnî rú trõꞌá âjílí kúmú ândrá, tãlâ nĩ ꞌdê trá má vó. Gólĩyî âꞌdô ãnî ũrûkậ ꞌbá yî ôkíꞌá ônjóróꞌbí sĩ jó tã Ôvârí kâ ârî kâ rî ꞌá. Óõtírĩ ãnî âjí âdrélé kúmú ândrá rî, nĩ âꞌdô îcáꞌá tã ámákâ âtálé lı̣̃fı̣́ drı̣̃ ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ãkpãkãꞌdã ạ̃dũkũ ãngó nõ kâ âcá drẽ kô rî, îcâ-îcâ tã lẽ ꞌbá drí tã âtî-âtî tãndí Ôvârí kâ nõ âtázó zãâ bạ̃dı̣̃ õjílã drí ãngó nõ ꞌásĩ kậkậrậ. ");
INSERT INTO avu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Õzõ úũrû ãnî trá trõlé âjílí âdrélé kúmú ândrá rî, ãnî líndrí õꞌbê kô dı̣̃ sı̣́sı̣́ tã ãnî drí ꞌẽꞌá âtálâ kúmú drí rî tãsĩ. Nĩ pẽ cé úlı̣́ gólĩyî Ôvârí drí âtálé ãnî drí pẽlé âdrérẽ ꞌá kúmú ândrá rî ĩꞌdî. Líndrí Tãndí Ôvârí kâ âꞌdô âꞌdóꞌá nĩ tã âtálé ãnî tı̣́ sĩ. Nĩ âtá úlı̣́ ãnî nyãányâ kâ rî kô.” ");
INSERT INTO avu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nĩngá sĩ, Yésũ drí tã âtázó zãâ kĩ nĩ rî, “Kậyı̣̂ rî ꞌdĩ ꞌbá yî tú rî, ãgô âꞌdô íyî ậdrúpı̣̃ rî ạ̃lı̣̃ âŋõꞌá ꞌbãlé fũlı̣́ vólé, tãlâ ậdrúpı̣̃ lâ ꞌdĩ õjílã ámákâ ĩꞌdî. Átá ró rî âꞌdô kpá tã ãlôlâ ꞌdĩ ꞌẽꞌá ĩꞌdî íyî mvá nyãányâ õjílã ámákâ ró rî drí. Kpá ĩtí, ꞌdĩyímvá âꞌdô ĩyî rû jãꞌá kpúrũkélẽ ãkpã ĩyî ândré yî rú átá yí bê, gólĩyî ꞌbãlé ãꞌdô ró ûfúlı̣́ vólé. ");
INSERT INTO avu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ĩtí rî, õjílã cé tı̣̂tı̣̂ ꞌbãá ãnî lôvó kô, tãlâ nĩ lẽ tã trá má ꞌá. Õjílã gólĩyî âdré ꞌbá ĩyíkâ zãâ rákã fê kâtí ı̣̃tú lâŋõ ãmbá ꞌdĩ ꞌbá yí kâ ꞌásĩ rî, Ôvârí âꞌdô gólĩyî pãꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Gõꞌdá Yésũ âtâ tã kpá kĩ, “ꞌDõvó nĩ ârî drẽ úlı̣́ ngbạ́ngậ nõ. Ị̃zạ́tú, áâꞌdô ngá õnjí ãnyĩ kâ âtrõꞌá lôfílí jó ạ́ngı̣́ Ôvârí kâ ꞌá ꞌbãlâ âꞌdólé ı̣̃ndı̣̂ ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá. Õzõ nĩ õndrê ngá rî ꞌdĩ trá rî, ꞌdõvó õjílã Yũdạ́yạ̃ ꞌá rî õrâ vólé ꞌwãâꞌwâ únı̣́ ꞌálâ ĩyî nyãányâ pãlé. ");
INSERT INTO avu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ãnî gólĩyî jó-drı̣̃ ꞌálâ rî ꞌbá yî, nĩ ârî gõꞌdá kô vũdrı̣́ fĩlí jó ꞌálâ ngá lôfõlé ĩvĩ. Ị̃tú-pá yû ngá rúꞌbạ́ kâ rî ꞌbá yî pãzó. ");
INSERT INTO avu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ãnî rĩ ꞌbá ngá ꞌẽlé ãnî drí ạ́mvú ꞌásĩ rî ꞌbá yî, nĩ ngâ kô gõlé ꞌbã ꞌálâ ítá ãníkâ âtrõlé. ");
INSERT INTO avu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kậyı̣̂ rî ꞌdĩ tú rî, õkó gólĩyî cú ꞌâ bê gõꞌdá gólĩyî cú ꞌdĩyímvá õdé bê drẽ bã ndrõꞌá yî rî ꞌbá yî âꞌdô lâŋõ njı̣̃ꞌá rõô. ");
INSERT INTO avu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nĩ îrátã tı̣̂ Ôvârí drí, tãlâ tã õnjí rî ꞌdĩ õzó kô rû ꞌẽê ôzê lı̣̃mvû sĩ, ");
INSERT INTO avu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","tãlâ ı̣̃tú lâŋõ kâ ꞌdĩ ꞌbá yî âꞌdô âꞌdóꞌá lâŋõ bê rõô, ı̣̃tú ãzâ ꞌbá yî drı̣̃ı̣̂ sĩ, îtõlé kó Ôvârí drí ãngó ꞌbãzó rî sĩ. Lâŋõ õnjí ĩtí ꞌdĩ ꞌbá yî ândá rû kô óꞌdí ꞌdĩî vósĩ. ");
INSERT INTO avu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Õzõ Ôvârí ãâyê lâŋõ õnjí ꞌdĩ njãlé kậyı̣̂ dũû sĩ rî, õjílã rĩ ꞌbá lédrẽ-lédrẽ ró rî yûꞌdạ́wạ́. Tãlâ õjílã gólĩyî Ôvârí drí zĩlí trá tã lẽlé yí ꞌá rî tãsĩ, gólâ âyé lâŋõ õnjí ꞌdĩ njãlé kô, âꞌdô ꞌbãꞌá cé kậyı̣̂ fínyáwá sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kậyı̣̂ rî ꞌdĩ sĩ, õzõ õjílã ãzâ ãânĩ trá tã pẽlé ãnî drí kĩ, ‘Nĩ ndrê drẽ, ꞌdíyî pã ꞌbá ãmákâ rî rĩꞌá nõ’, ngãtá õjílã ãzâ õkĩ nĩ rî, ‘ꞌDíyî pã ꞌbá ãmákâ gĩâ rĩꞌá nã’ rî, nĩ ꞌbã tã kô úlı̣́ gólâkâ ꞌdĩ ꞌbá yî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Õjílã âꞌdô ânĩꞌá ĩyî rĩꞌá õnjõ âgãlé kĩ nĩ rî, yĩ ãꞌdô tã ậngũ ꞌbá Ôvârí kâ, ngãtá yĩ ãꞌdô ꞌdíyî pã ꞌbá âjólé Ôvârí ngá lésĩ rî ĩꞌdî. Gólĩyî âꞌdô tã tı̣̂ drí ậꞌdı̣́zó rî ꞌbá yî ꞌẽꞌá õjílã âdózó ĩꞌdî sĩ lâ. Õzõ ĩîcâ trá rî, gólĩyî âꞌdô kpá tã jũꞌá õjílã Ôvârí drí êpẽlé trá pãlé rî ꞌbá yî âdózó. ");
INSERT INTO avu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","“Tãlâ lâŋõ rî ꞌdĩ ꞌbá yî tãsĩ ndrĩ rî, ꞌdõvó ãnî lı̣̃fı̣́ õmbâ ãnî rú kákárá lı̣́mú kâtí. Má sõ drı̣́-mbílí ãnî lı̣̃fı̣́ tã ꞌdî ꞌbá yî tãsĩ drẽ ãkpãkãꞌdã, õzó ĩyî ãnî âdó kô.” ");
INSERT INTO avu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kpá õzõ úlı̣́ Ĩsáyã drí âtálé rî kâtí kĩ nĩ rî, “Lâŋõ rî ꞌdĩ ꞌbá yî vósĩ, tã nô ꞌbá yî âꞌdô âꞌdóꞌá, ‘Ị́nı̣́rı̣́kúwạ́ âꞌdô ậsı̣́ꞌá ạ̃mvũ ı̣̃tú lı̣̃fı̣́. Gõꞌdá párá îwá võ kô ngạ́cı̣̂ bê. ");
INSERT INTO avu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ị̃ꞌbı̣̂ꞌbı̣̂wạ́ âꞌdô lôꞌdéꞌá ı̣̃nyạ́kú drı̣̃ı̣̂ ꞌbũû lésĩ. Ngá ꞌbũû ꞌálâ rî ꞌbá yî ndrĩ drí rû îyázó kı̣̃zı̣̃-kı̣̃zı̣̃.’ ");
INSERT INTO avu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ị̃tú rî ꞌdĩ tú rî, õjílã drí mâ Ôvârí drí âjólé ûrú lésĩ rî ndrẽzó tõ ânĩrĩ ꞌá ûrú lésĩ mbãrãsãsã bê. Má âꞌdô ânĩꞌá cú mbârâkã ạ́ngı̣́ bê gõꞌdá kpá ãmbã Ôvârí kâ rî bê. ");
INSERT INTO avu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Má âꞌdô mãlãyíkã ámákâ rî ꞌbá yî âjóꞌá võ ãngó nõ drı̣̃ı̣̂ rî ꞌásĩ ndrĩ, tãlâ nĩꞌá õjílã gólĩyî Ôvârí drí êpẽlé trá tã ârí ꞌbá ámákâ ró rî ꞌbá yî êꞌbélé tũ võ ãlô ꞌá ãngó drı̣̃ı̣̂ sĩ ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yésũ âtâ kpá gólĩyî drí kĩ nĩ rî, “Nĩ ı̣̂sũ tã lãmbé gólâ ôzê lı̣̃mvû âꞌdá ꞌbá kĩ trá ãnyî ꞌẽꞌá âcálé rî tãsĩ. Õzõ nĩ õndrê fê bı̣́ ãꞌdô trá ârõꞌá kạ̃ꞌdậ-kạ̃ꞌdậ rî, ꞌdĩî nĩ ı̣̂sũ kĩ nĩ rî, ôzê lı̣̃mvû trá ꞌẽꞌá âcálé. ");
INSERT INTO avu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ĩtí rî, õzõ nĩ õndrê ngá má drí tã lâ ậngũlı̣́ ꞌdĩ ꞌbá yî trá rû ꞌẽꞌá rî, nĩ âꞌdô nı̣̃ꞌá lâ kĩ, ı̣̃tú má drí ꞌẽzó âgõlé ꞌá lâ rî bí ꞌẽꞌá âcálé. ");
INSERT INTO avu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Má âtâ ãnî drí nõ úlı̣́ pạ̃tı̣́-pạ̃tı̣̃ ꞌî. Tã má drí âtálé ãnî drí nõ ꞌbá yî ndrĩ âꞌdô rû ꞌẽꞌá drẽ ãkpãkãꞌdã õjílã ũrûkậ ꞌbá yî gólĩyî lédrẽ-lédrẽ ró ngbãângbânõ nô ꞌbá yî ôdrãá drẽ kô. ");
INSERT INTO avu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ị̃nyạ́kú drı̣̃ ꞌbũû bê âꞌdô rû ndẽꞌá. Gõꞌdá tã ámákâ má drí âtálé nõ ꞌbá yî ndẽé rû kô, âꞌdô rû ꞌẽꞌá ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yésũ âtâ kpá kĩ nĩ rî, “Õjílã ãzãkã nı̣̃ı̣́ kậyı̣̂ má drí âcázó âgõlé ãngó nõ ꞌá rî kô. Gõꞌdá mãlãyíkã ꞌbũû ꞌálâ rî ꞌbá yî nı̣̃ı̣́ kpá kô. Kpálé mâ Ôvârí rî mvá ró rî nı̣̃ı̣́ kậyı̣̂ rî ꞌdĩ kpá kô, cé Ôvârí ãmâ átá nı̣̃ íyîngá nĩ. ");
INSERT INTO avu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ãnî lı̣̃fı̣́ õmbâ ãnî rú, nĩ rî tı̣̂ îrátã-îrátã sĩ, tãlâ mĩ nı̣̃ı̣́ kậyı̣̂ mbı̣̂mbı̣̂ tã rî ꞌdĩ drí ꞌẽzó âꞌdólé ꞌá lâ rî kô. ");
INSERT INTO avu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Âgõ-âgõ ámákâ âꞌdô ꞌbãꞌá õzõ ãgô gólâ ꞌbã âyé ꞌbá ngãzó nĩlí ậcı̣́ ꞌá rî kâtí. Drẽ ãkpãkãꞌdã gólâ ngá drẽ kô rî, gólâ lânjî lôsĩ trá cé tı̣̂tı̣̂ ngá ꞌẽ ꞌbá íyíkâ drí ꞌẽlé. Gólâ âtâ tã kpá lómígówá íyíkâ ạ́tı̣̃ tı̣́ rî drí võ ậrı̣̃lı̣́ dódó. ");
INSERT INTO avu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ãnî lı̣̃fı̣́ õmbâ tã ámákâ ậrı̣̃lı̣́ dódó, õzõ lómígówá ꞌdĩ kâtí, nĩ nı̣̃ı̣́ kô má âꞌdô âcáꞌá âgõlé ángô tú. Má âꞌdô íyîngá âcáꞌá âgõlé lạ̃njạ́túlı̣́ sĩ, ãꞌbí ító ꞌá, ꞌạ̃ꞌú-lúgú cı̣́rı̣̃ sĩ ngãtá cı̣̃ı̣́nó yã rî. ");
INSERT INTO avu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nĩ kô ậꞌdú kô. Nĩ rî njãâ, má âꞌdô âcáꞌá âgõlé nyĩî ró ãnî ûsúlı̣́ ı̣̃tú ãnî drí nı̣̃lı̣́ kô rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Má âtâ kpá úlı̣́ ãlôlâ nõ ĩꞌdî ãnî drí ndrĩ. Ãnî lı̣̃fı̣́ õmbâ tã rî ꞌdĩ drı̣̃ı̣̂ dódó. Úlı̣́ ạ̃dũkũ ámákâ ãnî drí rî ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kậyı̣̂ ạ̃mbúkũ lâkî trá rı̣̃ ı̣̃tú kãrámã lậvũ-lậvũ kôrô kâ rî drí ꞌẽzó âcálé. Kãrámã rî ꞌdĩ úzı̣̂ kpá kãrámã ãmbãtã ạ̃kú ãkó rî nyã kâ. Drẽ ãkpãkãꞌdã sı̣́sı̣́ kậyı̣̂ kãrámã ꞌdî kâ drí âcá ãkó rî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá lãꞌbí îmbá ꞌbá bê trá rĩꞌá ĩyî tã lôndãꞌá ı̣̃nı̣́nı̣̂ ró Yésũ rî rũzó fũlı̣́ vólé. ");
INSERT INTO avu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kpálé gólĩyî lẽ bê trá Yésũ rî fũlı̣́ rî, gólĩyî kĩ nĩ rî, “Mã rû gólâ kô kậyı̣̂ kãrámã kâ ꞌdĩ sĩ, tãlâ õjílã dũû ꞌdĩ ꞌbá yî õzó ĩyî ngãâ ạ̃wạ̃ ró Yésũ rî pãlé cú ãmâ drı̣́gạ́ sĩ.” Gólĩyî lẽ kãrámã ạ̃dũkũ tẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kậyı̣̂ rî ꞌdĩ sĩ, Yésũ rî gógó rĩꞌá Bẽtánĩ ꞌálâ. Gólâ rî ãgô ãzâ gólâ drí êdélé ngá lãzé ãrí kâ ꞌásĩ, rú bê Sĩmónã rî drí ꞌbã ꞌálâ. Gõꞌdá Yésũ yî bê trá rĩꞌá nyãsá nyãꞌá tólâ rî, õkó ãzâ drí ngãzó âfílí cú mãlãngĩ dõ ạ̃jı̣́ bê tũrũ-tũrũ lâgî lâ drí ꞌbãlé kôrô rî kâ bê yí drı̣́gạ́. Dõ rî ꞌdĩ, rú lâ rĩꞌá nárãdã. Ĩtí rî, õkó ꞌdĩ drí cãzó Yésũ ngálâ. Drílâ mãlãngĩ tı̣̂ pı̣̃zó, gõꞌdá dõ ꞌá lâ ꞌdĩ ûtúzó trũtrũ tílílí Yésũ drı̣̃ı̣̂, ãꞌdô ró bê gólâ rî ı̣̂njı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nĩngá sĩ, õjílã ũrûkậ ꞌbá yî jó ꞌálâ rî yî drí ngãzó rĩꞌá úlı̣́ âtálé ạ̃wạ̃ sĩ ĩyî lãfálé ꞌásĩ kĩ nĩ rî, “Õkó ꞌdĩ îzã dõ lâgî lâ drí ꞌbãlé kôrô ꞌdĩ dãlé vũdrı̣́ ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Lãfâ gĩzó lâ rî lậvũ gạ̃rạ̃ lãfâ ngá ꞌẽ ꞌbá kâ ndrô ãlô kâ rî drı̣̃ı̣̂ sĩ. Gólâ ãꞌdô tíkó dõ ꞌdî lậzı̣́ꞌá gĩlí vólé tãlâ lãfâ lâ ꞌdĩ tãsĩ fẽlé ngá ãkó lé ꞌbá drí.” Gólĩyî âtâ úlı̣́ trá rõô õkó rî ꞌdĩ drí. ");
INSERT INTO avu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ĩtí rî, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ nĩ rî, “Nĩ rî õkó ꞌdĩ îkpókpólõlé ãꞌdô tãsĩ yã? Gólâ ꞌê tã sũsũ trá má drí. ");
INSERT INTO avu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ngá ãkó lé ꞌbá âꞌdô âꞌdóꞌá zãâ ãnyî ãnî drí pãlé zãâ cé, õzõ ãnî drí lẽlé rî tí. Gõꞌdá mâ rî gógó âꞌdó kô zãâ cé ãní bê. ");
INSERT INTO avu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Õkó nõ ꞌê ngá gólâ drí îcálé ꞌẽlâ má drí rî trá. Gólâ dã dõ ạ̃jı̣́ bê tũrũ-tũrũ ꞌdî trá má drı̣̃ı̣̂ ámâ rúꞌbạ́ êdélé sı̣́sı̣́ ámâ ãvõ lậpı̣́ ãkó ꞌbú ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pạ̃tı̣́ı̣̃ võ drı̣̃ ꞌásĩ ndrĩ ãngó ꞌásĩ, õjílã õtírĩ rĩî tã âtî-âtî Ôvârí kâ ngĩlí rî, gólĩyî âꞌdô kpá tã õkó nõ drí ꞌẽlé trá nõ ngĩꞌá tólâ, gólâ rî tã ãâgâ ró bê drı̣̃ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Vó lâ sĩ, lãjóꞌbá ãlô mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yî lãfálé ꞌásĩ rú bê Yúdạ̃ Ĩsĩkãrĩyótã rî drí ngãzó nĩlí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî rî ngálâ, ãꞌdô ró bê Yésũ rî drı̣́-bã fẽlé rũlı̣́. ");
INSERT INTO avu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Gólĩyî rĩꞌá ãyĩkõ ãmbá sĩ úlı̣́ Yúdạ̃ kâ ꞌdĩ ꞌá. Nĩngá sĩ rî, gólĩyî drí tã ꞌbãzó lãfâ fẽzó Yúdạ̃ drí. Tã rî ꞌdĩ tãsĩ rî, Yúdạ̃ drí lạ́tı̣̂ ndãzó Yésũ rî fẽzó gólĩyî drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kậyı̣̂ drı̣̃-káká kãrámã ãmbãtã ạ̃kú ãkó rî kâ, gõꞌdá kpá rĩꞌá kậyı̣̂ rĩzó kạ́bı̣̃lı̣́kı̣̃ ûlı̣́lı̣́ lãmbé lậvũ-lậvũ kôrô ạ́tı̣̃ tı̣́ sĩ kâ ró rî ĩꞌdî, lãjóꞌbá Yésũ kâ rî ꞌbá yî drí ngãzó gólâ rî îjílí kĩ nĩ rî, “Ní lẽ ãmâ drí võ êdélé ángô lé, ãꞌdô ró ãmâ drí nyãsá lậvũ-lậvũ kôrô kâ nõ nyãzó ꞌá lâ kpãkã ãlô yã?” ");
INSERT INTO avu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nĩngá sĩ, Yésũ drí lãjóꞌbá íyíkâ rı̣̃ rî ꞌbá yî ậzı̣́zó gólĩyî mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî lãfálé sĩ. Drílâ ngãzó tã pẽlé gólĩyî drí kĩ nĩ rî, “Nĩ nĩ fĩlí Yẽrõsãlémã ꞌálâ. Tólâ nĩ âꞌdô ãgô ûsúꞌá rĩꞌá lı̣̃mvû límvó lı̣̃mvû bê dũû yí ꞌá rî njı̣̃ꞌá. Nĩ ꞌdê, nĩ bẽ ró gólâ rî vó, bũúũ gólâ õfî ró jó ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gõꞌdá nĩ îjî ró tã jó lı̣́pı̣̂ ꞌdĩ tı̣́ kĩ nĩ rî, ‘Tã îmbá ꞌbá îjî tã nô nĩ kĩ, “Jó ũmú kâ ángô lé ró ãmâ drí nyãsá kãrámã lậvũ-lậvũ kôrô rî kâ nyãzó ꞌá lâ lãjóꞌbá ámákâ rî ꞌbá yí bê yã?” ’ ");
INSERT INTO avu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tólâ rî, jó lı̣́pı̣̂ âꞌdô ãnî âjíꞌá jó lạ̃kũ ûrú lésĩ rî ꞌálâ, éêdê trá njãâ tãrãbízã yí bê yí ꞌá. Nĩ êdê võ rî ꞌdĩ ãmâ drí ngá nyãzó ꞌá lâ tólâ.” ");
INSERT INTO avu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ĩtí rî, lãjóꞌbá rı̣̃ ꞌdî ꞌbá yî drí ngãzó nĩlí ĩyî. Gõꞌdá gólĩyî drí cãzó jạ̃rı̣́bạ̃ ạ́ngı̣́ nã ꞌálâ. Gõꞌdá tã Yésũ drí rãlé trá gólĩyî drí ꞌdĩ ꞌbá yî, drílĩyî ꞌẽzó lâ, té õzõ Yésũ drí âtálé rî tí. Drílĩyî nyãsá ꞌẽzó dódó ĩtí kãrámã lậvũ-lậvũ kôrô rî kâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nĩngá sĩ, lạ̃njạ́túlı̣́ bê, Yésũ yî drí cãzó tólâ lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yí bê nyãsá kãrámã kâ nyãlé. ");
INSERT INTO avu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Gõꞌdá gólĩyî drẽ rĩꞌá dîrî gbãâ tãrãbízã rú sĩ nyãsá nyãꞌá ĩyî rî, Yésũ drí ngãzó tã âtálé gólĩyî drí kĩ nĩ rî, “Pạ̃tı̣́ı̣̃ ró, õjílã ãlô ãnî rĩ ꞌbá tãrãbízã rú sĩ nyãsá nyãlé nõ ꞌbá yî ꞌásĩ âꞌdô ámâ drı̣́-bã fẽꞌá nĩ ạ̃jú-ꞌbá-ãzí ámákâ yî drí.” ");
INSERT INTO avu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî ârílí bê úlı̣́ ꞌdĩ ꞌbá yî rî, drílĩyî âꞌdózó tã ı̣̂sũ-ı̣̂sũ ró. Gõꞌdá gólĩyî drí ngãzó ãlô-ãlô Yésũ rî îjílí kĩ nĩ rî, “Âꞌdô îcáꞌá trá má drí âꞌdózó õjílã rî ꞌdĩ ró yã? Îcá kô.” ");
INSERT INTO avu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ĩtí, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ nĩ rî, “Gólâ ꞌẽ ꞌbá ámâ drı̣́-bã fẽlé rî, ãnî lãjóꞌbá ámákâ nõ ꞌbá yî lãfálé sĩ. Gólâ ĩꞌdî ꞌẽ ꞌbá ãmbãtã íyíkâ trõlé sõlé sãánĩ mvá ãtó kâ ꞌá ꞌdũwạ̃ má bê rî. ");
INSERT INTO avu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mâ gólâ âjólé ûrú lésĩ rî, âꞌdô drãꞌá nyé õzõ îgĩlí trá búkũ Ôvârí kâ ꞌá ámâ tãsĩ rî kâtí. Gõꞌdá ãgô gólâ ꞌẽ ꞌbá ámâ drı̣́-bã fẽlé ámâ ạ̃jú-ꞌbá-ãzí yî drí ꞌdĩ, lâŋõ âꞌdô ꞌdẽꞌá gólâ drı̣̃ı̣̂ rõô. Âꞌdô âꞌdóꞌá kó tãndí ró tí õzõ úũtı̣̂ ãgô rî ꞌdĩ kôꞌdáwá rî.” ");
INSERT INTO avu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Gõꞌdá gólĩyî drẽ bê zãâ ngá nyãꞌá ĩyî rî, Yésũ drí ãmbãtã âtrõzó ãwô-ĩtí ꞌẽzó Ôvârí drí, gõꞌdá gólâ drí ꞌâ lâ pı̣̃zó. Gólâ drí trõzó lâ fẽlé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí ndrĩ, gõꞌdá drílâ tã âtázó gólĩyî drí kĩ nĩ rî, “Nĩ nyâ, nõô ámâ rúꞌbạ́ ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vó lâ sĩ, Yésũ drí ĩgã õdrá âlâꞌbâ kâ rî âtrõzó. Drílâ ãwô-ĩtí ꞌẽzó Ôvârí drí. Gõꞌdá gólâ drí trõzó lâ fẽlé lãjóꞌbá íyíkâ yî drí. Drílĩyî mvũzó lâ. ");
INSERT INTO avu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Gólĩyî õtírĩ rĩî mvũlâ rî, Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Nõô ámâ ãrí tã-drı̣̃ lẽlẽ óꞌdí rî kâ, gólâ ꞌẽ ꞌbá rãlé má rú sĩ rî ĩꞌdî ãnî õjílã dũû pãlé, õzõ Ôvârí drí ꞌbãlé trá rî tí. ");
INSERT INTO avu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Má âtâ ãnî drí nõ tã pạ̃tı̣́ı̣̃ ꞌî. Nõô rî vósĩ, mã mvú õdrá âlâꞌbâ kâ gõꞌdá kô ãní bê kpá óꞌdí, mã âꞌdô mvũꞌá lâ ãní bê té ı̣̃tú gólâ õjílã drí Ôvârí rî ndrẽzó ãngó nõ rũ ꞌbá ró rî sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nĩngá sĩ, gólĩyî drí ngãzó lôngó ngõlé Ôvârí rî lûyı̣́zó. Vó lâ ꞌásĩ, drílĩyî ngãzó fõlé nĩlí únı̣́ fê dõ kâ bê yí drı̣̃ı̣̂ drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Lạ́tı̣̂ drı̣̃ı̣̂ rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ rî ꞌbá yî drí kĩ nĩ rî, “Nĩ âꞌdô ndrĩ ꞌdó ámâ âyéꞌá. Âꞌdô âꞌdóꞌá õzõ Ôvârí drí âtálé trá ạ̃kû ró búkũ íyíkâ ꞌá rî kâtí kĩ, yí âꞌdô lôkí ꞌbá fũꞌá, gõꞌdá kạ́bı̣̃lı̣́kı̣̃ âꞌdô rû lâpẽꞌá ndrĩ. ");
INSERT INTO avu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Má âtâ ãnî drí, õzõ má õlîdrî trá õdrã ꞌásĩ rî, má âꞌdô cãꞌá sı̣́sı̣́ ãnî drí Gãlĩláyã ꞌálâ, nĩ âꞌdô ámâ ûsúꞌá tólâ.” ");
INSERT INTO avu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nĩngá sĩ, Pétẽrõ drí ngãzó tã âtálé Yésũ drí kĩ nĩ rî, “Õzõ ãꞌdô kpálé lãjóꞌbá õjâ ũgúlı̣́ nĩ ní drí rî, mâ rî gógó nyãányâ lâ já ũgúlı̣́ ní drí kô ãlôwálâ.” ");
INSERT INTO avu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó drílâ kĩ nĩ rî, “Má âtâ tã pạ̃tı̣́ı̣̃ ꞌî ní drí. Ngạ́cı̣̂ nõ sĩ, drẽ ãkpãkãꞌdã ꞌạ̃ꞌú-lúgú ꞌbé cı̣́rı̣̃ kô ândâlâ rı̣̃, ní âꞌdô tı̣̂ gãꞌá má rú sĩ. Ní â kĩꞌá nĩ rî, yí nı̣̃ı̣́ mâ kô ândâlâ nâ.” ");
INSERT INTO avu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Gõꞌdá Pétẽrõ drí tã âtázó ngbạ́lạ́-ngbạ́lạ́ kĩ nĩ rî, “Mâ rĩꞌá njãâ drãlé ní bê, má gãá tı̣̂ kô.” Gõꞌdá lãjóꞌbá ãzâ ꞌdĩ ꞌbá yî âtâ ĩyî kpá ndrĩ ꞌdó úlı̣́ Pétẽrõ kâ ãlôlâ ꞌdĩ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nĩngá sĩ, Yésũ yî lãjóꞌbá íyíkâ yí bê, drílĩyî ngãzó nĩlí võ zı̣̃lı̣́ Gẽtẽsẽmánĩ rî ꞌálâ. Tólâ, Yésũ drí tã âtázó gólĩyî ãzâ ꞌbá yî drí kĩ nĩ rî, “Nĩ rî nõngá, mâ drẽ nĩꞌá rãtáã ꞌẽlé.” ");
INSERT INTO avu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nĩngá sĩ, Yésũ drí Pétẽrõ, Yãkóbã gõꞌdá Yõwánĩ yí bê drı̣̃zó kpãâ yí bê. Drílâ ngãzó âꞌdólé tã ı̣̂sũ ró rõô gõꞌdá kpá ĩzã ró. ");
INSERT INTO avu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Gõꞌdá nĩngá sĩ, drílâ tã âtázó gólĩyî drí kĩ nĩ rî, “Mâ trá rĩꞌá ĩzã ró rõô, má ı̣̂sũ tã kĩ, ĩzã má rú trá rõô, âꞌdô ámâ fũꞌá nĩ. Nĩ rî nõngá lı̣̃fı̣́ lõmbâ sĩ âꞌdólé ãnî vó lôkílí.” ");
INSERT INTO avu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ĩtí, Yésũ drí nĩzó gbíyá ạ̃tı̣́ ꞌálâ. Drílâ ngãzó íyî âdãlé ạ̃drũ vũdrı̣́, gõꞌdá ngãzó tı̣̂ îrátãlé Ôvârí drí kĩ nĩ rî, “Õzõ ĩîcâ trá rî, ní âyê mâ kô ĩzã nı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ámâ átá, rĩꞌá ní drí lâŋõ ãkó tã tı̣̂ ꞌẽzó cé tı̣̂tı̣̂. Ĩtí rî, ní trõ ĩgã lâŋõ kâ nõ vólé má drı̣́gạ́ sĩ. Gõꞌdá kpálé má õlẽ ní drí ámâ pãlé rî, má âꞌdô ngá ní drí lẽlé má drí ꞌẽlé rî ꞌẽꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Vó lâ sĩ, Yésũ drí ngãzó gõlé lãjóꞌbá íyíkâ nâ ꞌdĩ ꞌbá yî ngálâ. Gólâ ûsû gólĩyî ậꞌdú kõꞌá. Gõꞌdá drílâ tã âtázó Sĩmónã Pétẽrõ drí kĩ nĩ rî, “Sĩmónã, ãnî ậꞌdú kõꞌá yã? Nĩ îcá kô rĩlí cé ı̣̃tú-pá ãlô lı̣̃fı̣́ ngbậ võ lôkílí yã? ");
INSERT INTO avu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ámâ ậdrúpı̣̃ yî, nĩ lôkî ãnî nyãányâ gõꞌdá nĩ îrátã ró tı̣̂, tãlâ nĩ õzó kô tã ányâ ꞌẽê. Má nı̣̃ trá, nĩ lẽ tã mbı̣̂mbı̣̂ rî ꞌẽlé, gõꞌdá ãnî mbârâkã ãkó ꞌẽzó lâ.” ");
INSERT INTO avu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nĩngá sĩ, Yésũ drí ngãzó nĩlí kpá óꞌdí nĩꞌá rãtáã ãlôlâ ꞌdĩ ꞌẽlé Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gõꞌdá gólâ âgõ bê lãjóꞌbá íyíkâ nâ ꞌdĩ ꞌbá yî ngálâ rî, gólâ ûsû gólĩyî kpá zãâ ậꞌdú kõꞌá, tãlâ gólĩyî rĩꞌá lîndĩꞌá. Gõꞌdá Yésũ drí gólĩyî îjízó kĩ, “Nĩ rî ậꞌdú kõlé nõtí ãꞌdô tãsĩ yã?” Nĩngá sĩ, gólĩyî nı̣̃ı̣́ tã-drı̣̃ ĩyî drí ꞌẽꞌá lôgõlâ Yésũ drí rî kô. ");
INSERT INTO avu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nĩngá sĩ, Yésũ drí ngãzó nĩlí kpá óꞌdí rãtáã ꞌẽlé, gõꞌdá drílâ âgõzó. Gõꞌdá gólâ ûsû bê lãjóꞌbá íyíkâ nâ ꞌdĩ ꞌbá yî drẽ kpá zãâ ậꞌdú kõꞌá rî, drílâ ngãzó tã âtálé gólĩyî drí kĩ nĩ rî, “Ãnî drẽ zãâ ậꞌdú kõꞌá yã? Îcâ trá ꞌdĩ. Nĩ ndrê drẽ, ngbãângbânõ rî, mâ gólâ Ôvârí drí âjólé ûrú lésĩ rî óꞌê trá fẽlâ ạ̃jú-ꞌbá-ãzí drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gólâ ámâ drı̣́-bã fẽ ꞌbá rî trá ânĩꞌá. Nĩ ngâ ûrû, mã nĩ ró rû ûsúlı̣́ gólĩyí bê lạ́tı̣̂ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yésũ õtírĩ rĩî úlı̣́ âtálé rî, Yúdạ̃ gólâ âꞌdó ꞌbá ãlô lãjóꞌbá mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ Yésũ kâ rî ꞌbá yî ꞌásĩ rî drí âcázó. Gólâ ậdrı̣̃ õjílã tı̣́lı̣́lı̣́ kpãâ yí bê. Gólĩyî cú lı̣́gú mbẽlẽsó-mbélésô rî ꞌbá yí bê, gõꞌdá kpá pı̣̃drı̣́gú kũjũbı̣́-kújúbı̣̂ rî ꞌbá yí bê. Õjílã tı̣́lı̣́lı̣́ âjólé Yúdạ̃ bê ꞌdĩ ꞌbá yî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî, lãꞌbí îmbá ꞌbá yî, gõꞌdá kpá õjílã gólĩyî âꞌdó ꞌbá sı̣́sı̣́-lésĩ rî ꞌbá yí bê âjô gólĩyî nĩ. ");
INSERT INTO avu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Drẽ ãkpãkãꞌdã gólĩyî âcá drẽ kôꞌdáwá rî, Yúdạ̃ rî ꞌdĩ lẽ tã-drı̣̃ trá kírî ró õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí Yésũ rî âꞌdázó. Gólâ kĩ õjílã rî ꞌdĩ ꞌbá yî drí rî, “Õjílã gólâ má drí âmvólé gõzó bı̣́-ꞌbálé lâ võlé rî, ꞌdĩî gólâ ĩꞌdî ãnî drí rũlı̣́ ạ̃ngbũ ômbélé njírí-njírí trõlé vólé lôkî-lôkî lâ ró rî.” ");
INSERT INTO avu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nĩngá sĩ, gólĩyî âcâ bê rî, kôrô Yúdạ̃ drí ânĩzó Yésũ rî zı̣̃lı̣́ “Tã îmbá ꞌbá!” gõꞌdá gólâ rî âmvózó gõzó bı̣́-ꞌbálé lâ võlé. ");
INSERT INTO avu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ĩtí rî, kôrô ãgô ꞌdĩ ꞌbá yî drí ngãzó ndrõlé ạ̃ngbũ Yésũ drı̣̃ı̣̂. Gõꞌdá drílĩyî Yésũ rî rũzó. ");
INSERT INTO avu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bê trá ĩtí rî, lãjóꞌbá Yésũ kâ ãlô rî drí ngãzó lı̣́gú mbẽlẽsõ íyíkâ ângílí ãhõwã, fókã lâ ꞌásĩ rû fũzó. Gõꞌdá drílâ ãgô ãzâ ãlô rî bı̣́ lâ gãzó njíyá. Ãgô ꞌdĩ rû ı̣̂ꞌbũ ꞌbá drı̣̃-ꞌbá drı̣̃-ꞌbá ãzí drı̣̃ı̣̂ kâ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nĩngá sĩ, Yésũ drí tã âtázó õjílã dũû ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ânĩ ámâ rũlı̣́ pı̣̃drı̣́gú ândrê ândrê bê gõꞌdá kpá lı̣́gú mbẽlẽsó-mbélésô bê ãꞌdô tãsĩ yã? Mâ drı̣̃-ꞌbá õjílã õnjí kâ ꞌî mı̣́rı̣̃ rú yã? ");
INSERT INTO avu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mã rî rĩlí ãní bê ı̣̃tú vósĩ cé. Má rî rĩlí tã âꞌdálé ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌá. Drẽ má âꞌdô bê tólâ rî, nĩ rú mâ kô. Gõꞌdá ꞌdĩî rĩꞌá mbı̣̂, tã tã îgĩ Ôvârí kâ drí âtálé rî drí rû ꞌẽzó.” ");
INSERT INTO avu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ĩtí rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ndrĩ drí Yésũ rî âyézó, gõꞌdá ngãzó rãlé ĩyî vólé. ");
INSERT INTO avu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Gõꞌdá ãgô ãnjî ãlô ítá tãndí gõ ꞌbá tãkó yí rú rî trá rĩꞌá ꞌdẽꞌá Yésũ vósĩ. Gõꞌdá õjílã ꞌdî ꞌbá yî ndrô ĩyî bê ạ̃ngbũ drı̣̃ lâ rî, ");
INSERT INTO avu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","drílâ íyî ânjózó ãpõwã, ítá íyíkâ ãlô ꞌdĩ âyélé gólĩyî drı̣́gạ́, rãzó ũndú ró. ");
INSERT INTO avu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nĩngá sĩ, õjílã ꞌdî ꞌbá yî drí Yésũ rî drı̣̃zó âjílí ãmbá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yí kâ rî ândrá. Drı̣̃-ꞌbá ạ́ngı̣́ ãzâ ꞌbá yî ꞌdó ndrĩ lãꞌbí îmbá ꞌbá yí bê, gõꞌdá gólĩyî âꞌdó ꞌbá sı̣́sı̣́-lésĩ rî ꞌbá yí bê drí rû êꞌbézó tũ tólâ. ");
INSERT INTO avu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Gõꞌdá Pétẽrõ drí ngãzó ꞌdẽlé Yésũ yî vó gĩâ jẽjẽ ró vólé ꞌálâ. Vó lâ sĩ, drílâ âfízó kírî ạ̃ꞌdı̣́-drı̣̃ ãmbá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yí kâ rî kâ ꞌá. Tólâ drílĩyî rĩzó lạ̃sı̣́ yãlé kpãkã ãlô lómígówá ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gõꞌdá jó ꞌálâ rî, drı̣̃-ꞌbá ạ́ngı̣́ ꞌdĩ ꞌbá yî ndrĩ ꞌdó tã kĩ ꞌbá ãzâ ꞌbá yí bê rĩꞌá zãâ ĩyî tã ífí lôndãꞌá lôꞌbãlé Yésũ rú cú ĩtí, ãꞌdô ró bê gólâ rî fũzó vólé. Nĩngá sĩ rî, Yésũ rĩꞌá cú ĩtí tã õnjí ãkó. ");
INSERT INTO avu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Õjílã dũû âdô ĩyî õnjõ trá Yésũ rú. Gõꞌdá õnjõ drílĩyî lôꞌbãlé Yésũ rú ꞌdĩ ꞌbá yî ꞌbé drı̣̃ kô ãlôwálâ. ");
INSERT INTO avu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Õjílã ũrûkậ ꞌbá yî ngâ ĩyî âdrélé cú ûrû tã lôꞌbãlé Yésũ rú õnjõ sĩ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mã ârî gólâ trá tã âtáꞌá kĩ nĩ rî, yí âꞌdô jó ạ́ngı̣́ Ôvârí kâ õjílã mvá drí bẽlé nĩ nô ûfúꞌá îzãlé vólé. Gõꞌdá kậyı̣̂ nâ sĩ, yí âꞌdô jó ãzâ Ôvârí kâ õjílã mvá drí bẽlé nĩ kôꞌdáwá rî bẽꞌá.” ");
INSERT INTO avu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gõꞌdá õnjõ gólĩyíkâ ꞌdĩ âꞌdô bê kpá trá lé ĩtí rî, ꞌbé drı̣̃ kpá kô úlı̣́ ãzâ drílĩyî lôꞌbãlé trá rî ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nĩngá sĩ, ãmbá drı̣̃-ꞌbá ạ́ngı̣́ ꞌdĩ ꞌbá yí kâ ꞌdĩ drí ngãzó âdrélé ûrû tã kĩ ꞌbá ndrĩ ândrá, tãlâ Yésũ rî îjílí tã îjî sĩ. Ĩtí gólâ kĩ Yésũ drí rî, “Ní lôgõó úlı̣́ ãmbá õjílã nô ꞌbá yî drí rĩzó ánî ạ̃lı̣̃ âŋõlé ĩꞌdî sĩ lâ nõ kô yã?” ");
INSERT INTO avu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lé ĩtí rî, Yésũ rî íyîngá gbõ tı̣́tı̣́ ró úlı̣́ îjílí ꞌdĩ drı̣̃ lâ lôgõ ãkó. Drı̣̃-ꞌbá drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yí kâ ꞌdĩ drí Yésũ rî îjízó kpá óꞌdí tã îjî sĩ kĩ nĩ rî, “Ní ı̣̂sũ áníkâ bê rî, nî ꞌdíyî pã ꞌbá âjólé ûrú lésĩ rî ĩꞌdî, gõꞌdá kpá Ôvârí gólâ tãndĩ ãkĩ rî mvá lâ ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó kĩ, “Pạ̃tı̣́ı̣̃, mâ fí ĩꞌdî gólâ ní drí tã lâ âtálé ꞌdĩ. Gõꞌdá nĩ âꞌdô mâ gólâ Ôvârí drí âjólé ûrú lésĩ nô ndrẽꞌá kậyı̣̂ rî gógó ꞌdĩ sĩ, má õtírĩ rĩî Ôvârí mbârâkã ãkĩ rî drı̣́-ágó drı̣̃ lésĩ ró rî, nĩ âꞌdô kpá ámâ ndrẽꞌá âgõ-âgõ rî ꞌdĩ sĩ ãngó nõ ꞌá mbârâkã Ôvârí kâ bê.” ");
INSERT INTO avu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nĩngá sĩ, drı̣̃-ꞌbá ạ́ngı̣́ ꞌdĩ drí ngãzó õmbã ró. Drílâ ítá íyíkâ sĩzó õmbã sĩ, gõꞌdá tã âtázó kĩ nĩ rî, “Îcá gõꞌdá kô õjílã ãzâ ꞌbá yî drí kpá ngãzó ĩyî úlı̣́ âtálé tı̣̂ gã ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ãnî õjílã nô ꞌbá yî, nĩ ârî lãꞌdá gólâkâ Ôvârí rú nõ trá. Ãgô nõ lẽ íyî ꞌbãlé âꞌdólé Ôvârí kâtí, ꞌdĩî sú kô. Âꞌdô bê trá ĩtí rî, mã lẽé gõꞌdá tı̣̂ gã ꞌbá ãzâ kô. Tã ı̣̂sũ ãníkâ tã ꞌdî ꞌá rî íyíkâ ángô tí ró yã?” Gõꞌdá nĩngá sĩ, gólĩyî drí ngãzó ꞌdó tã kĩlí Yésũ rú kĩ nĩ rî, “Úfû gólâ vólé.” ");
INSERT INTO avu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ĩtí rî, lómígówá ãzâ ꞌbá yî drí ngãzó rĩꞌá tũ lûwúlı̣́ gólâ rú. Drílĩyî gólâ rî lı̣̃fı̣́ ômbézó kpạ̃ạ́kũ ítá sĩ. Gõꞌdá gólĩyî drí rĩzó Yésũ rî ậdı̣̃lı̣́ drı̣́ mbãcĩkõ sĩ kı̣̃ kı̣̃. Gõꞌdá âgõzó ĩyî tã âtálé kĩ nĩ rî, “Ní kĩ yí ãꞌdô tã ậngũ ꞌbá ꞌî rî, ní âꞌdâ drẽ ngbãângbânõ ngãtá ãꞌdî dı̣̂ nî ãmâ lãfálé sĩ nĩ yã rî.” Gõꞌdá ĩtí rî, lómígówá ãzâ ꞌbá yî gólĩyî lãfálé ꞌásĩ drí gólâ rî trõzó cãlé rõô. ");
INSERT INTO avu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yésũ õtírĩ ꞌbãâ drẽ tã kĩ ꞌbá ândrá jó ꞌálâ rî, Pétẽrõ drí rĩzó íyíkâ ãkpã ạ̃ꞌdı̣́-drı̣̃ ꞌá ĩvĩ. Ízámvá ãlô gólâ âꞌdó ꞌbá rû ı̣̂ꞌbũ ꞌbá drı̣̃-ꞌbá ạ́ngı̣́ ꞌdĩ kâ rî ró drí ânĩzó ãnyî Pétẽrõ lạ̃gạ́tı̣́ ạ̃ꞌdı̣́-drı̣̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Gõꞌdá nĩngá sĩ, gólâ ndrê bê Pétẽrõ rĩꞌá lạ̃sı̣́ tı̣́ rî, drílâ ngãzó gólâ rî ndrẽlé trı̣́ı̣́. Nĩngá sĩ rî, drílâ tã âtázó kĩ nĩ rî, “Hé, nî ákĩ fí kpá Yésũ Nãzãrétã lé ꞌbá ró rî bê!” ");
INSERT INTO avu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ĩtí rî, Pétẽrõ drí tı̣̂ gãzó dó. Gólâ kĩ nĩ rî, “Má nı̣̃ı̣́ tã áníkâ rĩꞌá âtálâ ꞌdĩ ꞌbá yî kôꞌdáwá. Má nı̣̃ı̣́ ãgô ꞌdĩ kô.” Gõꞌdá Pétẽrõ drí ngãzó nĩlí gõlé ạ́tı̣̃ ndõgõ kâ tı̣́ ꞌálâ ró. Kôrô ꞌạ̃ꞌú-lúgú drí cı̣́rı̣̃ ꞌbẽzó. ");
INSERT INTO avu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ízámvá ró ꞌdĩ ndrê bê gólâ âdrérẽ ꞌá ạ́tı̣̃ ndõgõ kâ rî tı̣́ ꞌálâ rî, drílâ ngãzó tã âtálé kpá óꞌdí õjílã gólĩyî âꞌdó ꞌbá trá âdréꞌá ãnyî rî ꞌbá yî drí kĩ nĩ rî, “Má nı̣̃ trá, ãgô nõ rĩꞌá õjílã Yésũ kâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ĩtí rî, Pétẽrõ drí tı̣̂ gãzó kpá óꞌdí kĩ, “Âꞌdó mâ ĩꞌdî kô.” Gõꞌdá ı̣̃tú-pá dã vósĩ rî, õjílã gólĩyî rĩ ꞌbá âdrélé ãnyî Pétẽrõ lạ̃gạ́tı̣́ rî ꞌbá yî drí ngãzó tã âtálé kĩ nĩ rî, “Pạ̃tı̣́ı̣̃, nî rĩꞌá ãlô õjílã Yésũ kâ rî ꞌbá yî ꞌásĩ, tãlâ ní ânĩ Gãlĩláyã lésĩ.” ");
INSERT INTO avu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Gõꞌdá Pétẽrõ drí ngãzó íyî lâtrílí kĩ nĩ rî, “Õzõ má ãâdô õnjõ ꞌî rî, ngá ãzâ õꞌê mâ. Nĩ fû mâ tãkó kô. Má nı̣̃ı̣́ ãgô ãnî drí rĩꞌá tã lâ âtálé ꞌdĩ kô.” ");
INSERT INTO avu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nĩngá sĩ, kôrô ꞌạ̃ꞌú-lúgú drí cı̣́rı̣̃ ꞌbẽzó ândâlâ rı̣̃ lâ ró. Nĩngá sĩ, úlı̣́ Yésũ kâ âtálé trá kĩꞌá nĩ rî, drẽ ãkpãkãꞌdã ꞌạ̃ꞌú-lúgú ꞌbé cı̣́rı̣̃ kô ândâlâ rı̣̃ rî, ní âꞌdô tı̣̂ gãꞌá kĩ nĩ rî, yí nı̣̃ı̣́ mâ kôꞌdáwá ândâlâ nâ rî drí kôrô âgázó Pétẽrõ drı̣̃ı̣̂. Ĩtí rî, kpạ̃ạ́fũ Pétẽrõ drí fũzó ãwó bê õnjí tẽtẽ ró ı̣̃lı̣́ndrı̣̂ bê cõrõ-cõrõ tã õnjí íyíkâ ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ãkpã cı̣̃ı̣́nó, gólĩyî tã kĩ ꞌbá ró rî yî ndrĩ drí rĩzó ĩyî tã ı̣̂ꞌbı̣̃lı̣́ ĩyî lãfálé ꞌásĩ Yésũ rú. Gólĩyî ĩꞌdî drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî, gõꞌdá gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yî, lãꞌbí îmbá ꞌbá yí bê. Nĩngá sĩ, drílĩyî tã-drı̣̃ kĩzó Yésũ rî ômbélé drı̣̃lı̣́ âjílí kúmú Pĩlátõ ândrá, Pĩlátõ õlẽ ró tã-drı̣̃ bê gólâ rî fũzó. ");
INSERT INTO avu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Gõꞌdá nĩngá sĩ, gólĩyî fílí bê kúmú Pĩlátõ drı̣̃ı̣̂ jó ꞌálâ tã Yésũ kâ ꞌdĩ ngĩlí drílâ rî, Pĩlátõ drí ngãzó Yésũ rî îjílí kĩ, “Nî ĩꞌdî kúmú ạ́ngı̣́ õjílã áníkâ Yúdạ̃ yí kâ rî kâ yã?” Nĩngá sĩ, Yésũ drí tã îjî kúmú kâ ꞌdĩ drı̣̃ lâ lôgõzó kĩ, “Âꞌbãꞌá fí õzõ ní drí âtálé ꞌdĩ tí.” ");
INSERT INTO avu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nĩngá sĩ, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí ngãzó tã âꞌbãlé kpá óꞌdí Yésũ rú. Gólĩyî kĩ nĩ rî kúmú Pĩlátõ drí rî, Yésũ õꞌê tã õnjí trá dũû. ");
INSERT INTO avu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gõꞌdá tãlâ úlı̣́ ꞌdĩ ꞌbá yî tãsĩ rî, Pĩlátõ drí ngãzó Yésũ rî îjílí kpá óꞌdí, “Ní âꞌdô tã nô drı̣̃ lâ lôgõꞌá trá yã? Ní ârî tã õnjí áníkâ ꞌẽlé dũû nõ tã lâ trá yã?” ");
INSERT INTO avu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Âꞌdô bê ĩtí rî, Yésũ lôgõó tã îjî ꞌdĩ drı̣̃ lâ kô kúmú Pĩlátõ drí ãlôwálâ. Ĩtí rî, Pĩlátõ rî tı̣̂ drí ậꞌdı̣́zó ndrú. ");
INSERT INTO avu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gõꞌdá lãꞌbí ãzâ kpá bê rĩꞌá kậyı̣̂ kãrámã lậvũ-lậvũ kôrô kâ nã ꞌá, ódrí õjílã ãlô înjízó vólé gạ̃nı̣́mạ̃ ꞌásĩ. Õjílã gólâ ódrí njĩlí înjílí rî, gólâ ĩꞌdî înjílí gạ̃nı̣́mạ̃ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ãgô ãzâ bê rĩꞌá gạ̃nı̣́mạ̃ ꞌá, rú lâ Bãrábã. Gólĩyî rĩꞌá õjílã ũrûkậ gã ꞌbá trá ĩyî kõrá ró rî ꞌbá yí bê. Bãrábã rî gógó fû õjílã ãzâ ꞌbá yî trá kậyı̣̂ gólâ drí tã sõzó õjílã ꞌá rû jãlé kõrá ró mı̣̃rı̣̃ Rómã kâ rú rî sĩ. ");
INSERT INTO avu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tãlâ lãꞌbí ꞌdĩ tãsĩ rî, õjílã tı̣́lı̣́lı̣́ drí ânĩzó ĩyî kúmú Pĩlátõ ngálâ tã îjílí gólâ tı̣́ õjílã ãlô gạ̃nı̣́mạ̃ ꞌá rî înjî-înjî lâ vólé rî tãsĩ, õzõ gólâ drí rĩrĩ trá ꞌẽlâ ndrô vósĩ cé ı̣̃tú kãrámã rî ꞌdĩ kâ tú rî kâtí. ");
INSERT INTO avu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nĩngá sĩ rî, kúmú Pĩlátõ drí ngãzó õjílã rî ꞌdĩ ꞌbá yî îjílí kĩ nĩ rî, “Nĩ lẽ má înjî kúmú ạ́ngı̣́ ãnî Yúdạ̃ yí kâ nõ ĩꞌdî vólé gạ̃nı̣́mạ̃ ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pĩlátõ îjî tã ꞌdî ĩtí lâ ꞌdĩ ró, tãlâ gólâ nı̣̃ trá dódó kĩ nĩ rî, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ꞌê ĩyî Yésũ rî rũlı̣́ âjílí yí drí, tãlâ drı̣́-ãcê Yésũ kâ ꞌdĩ âgî-âgî gólĩyî lı̣̃fı̣́. ");
INSERT INTO avu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gõꞌdá drı̣̃-ꞌbá rî ꞌdĩ ꞌbá yî lẽé ĩyî tã rî ꞌdĩ kô ãlôwálâ. Gõꞌdá gólĩyî rî ĩyíkâ trá zãâ tã sõlé õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî ꞌá, ãꞌdô ró tã îjílí Bãrábã rî înjízó ĩꞌdî vólé gạ̃nı̣́mạ̃ ꞌásĩ Yésũ rî võ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nĩngá sĩ, Pĩlátõ drí gólĩyî îjízó kĩ, “Nĩ lẽ má õꞌê ãꞌdô ĩꞌdî gólâ ódrí zı̣̃lı̣́ trá kúmú Yúdạ̃ yí kâ ró nõ drí yã?” ");
INSERT INTO avu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ĩtí rî, õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí ngãzó ângbálé kãwõ kĩ, “Íîpâ gólâ ngạ́rạ́ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂, tãlâ gólâ õdrã ró bê vólé.” ");
INSERT INTO avu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nĩngá sĩ, kúmú Pĩlátõ drí gólĩyî îjízó kĩ, “Tãlâ ãꞌdô ꞌî má drí tã õnjí tẽtẽ ꞌdî ꞌẽzó yã? Gólâ ꞌê ãꞌdô ꞌî õnjí tẽtẽ ró yã?” Gõꞌdá õjílã ꞌdî ꞌbá yî gã dó tã ârílí. Gõꞌdá gólĩyî ôtrê gbõ ạ̃tı̣́ ꞌálâ ûrû kĩ nĩ rî, “Íîpâ gólâ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ õdrã ró vólé.” ");
INSERT INTO avu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nĩngá sĩ, kúmú Pĩlátõ lẽ trá tã gólâ õjílã tı̣́lı̣́lı̣́ ꞌdĩ ꞌbá yî drí lẽlé rî ꞌẽlé gólĩyî drí. Tã rî ꞌdĩ tãsĩ, Pĩlátõ ní drí Bãrábã rî înjízó vólé gạ̃nı̣́mạ̃ ꞌásĩ, õzõ õjílã rî ꞌdĩ ꞌbá yî drí lẽlé rî kâtí. Nĩngá sĩ, gólâ drí ngãzó tã âtálé ạ̃jú ꞌbũ ꞌbá íyíkâ rî ꞌbá yî drí, ãꞌdô ró bê Yésũ rî cãzó ônjóróꞌbí sĩ ndîrí-ndîrí, gõꞌdá gólâ rî trõzó fẽlé õjílã gólĩyî ꞌẽ ꞌbá gólâ rî îpálé ngạ́rạ́ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ĩtí rî, ạ̃jú ꞌbũ ꞌbá Pĩlátõ kâ ꞌdĩ ꞌbá yî drí Yésũ rî drı̣̃zó âjílí ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ kúmú ãmbá rî kâ rî ꞌálâ. Gõꞌdá gólĩyî câ bê tólâ rî, drílĩyî ạ̃jú ꞌbũ ꞌbá ãzâ ꞌbá yî ậzı̣́zó ndrĩ tũ. ");
INSERT INTO avu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gõꞌdá nĩngá sĩ, gólĩyî drí ítá bı̣́ ạ̃kû kãâkâ dãdã lâ ró rî âtrõzó gõlé dîrî gbãâ Yésũ rî ũwû ꞌásĩ. Nĩngá sĩ, gólĩyî gâ kpá púrũcı̣́ gárá pãlé õzõ ı̣́tı̣̃tı̣́ kâtí ạ́pạ̃ kúmú ạ́ngı̣́ kâ ró âsálé ãtrã Yésũ drı̣̃ı̣̂. Gólĩyî ꞌê tã ꞌdî ꞌbá yî ĩyíkâ ꞌdó, tãlâ Yésũ rî gógó õlêndrê ró kúmú ạ́ngı̣́ kâtí. ");
INSERT INTO avu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Vó lâ ꞌásĩ, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí ngãzó rĩꞌá ôtrélé Yésũ drı̣̃ı̣̂, gólâ rî gũꞌá ĩyî kĩ, “Mã ꞌê nî-bê-yã ní drí kúmú ạ́ngı̣́ õrĩ Yúdạ̃ yí kâ rî kâ.” ");
INSERT INTO avu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gólĩyî tı̣̃ ꞌãꞌî kpá Yésũ ândrá ândálé ândálé õzõ gólâ rî ı̣̂njı̣̃rı̣̃ kâtí. Nĩngá sĩ rî, drílĩyî Yésũ rî drı̣̃ cãzó pı̣̃drı̣́gú sĩ kpõwẽ-kpõwẽ ândálé ândálé, gõꞌdá rĩzó tũ lûwúlı̣́ lı̣̃fı̣́ lâ ꞌásĩ ândálé ândálé. ꞌDĩî ꞌbá yî ndrĩ ꞌdó ꞌdásí ꞌẽꞌẽ ꞌî Yésũ rú. ");
INSERT INTO avu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Gõꞌdá ꞌdásí ꞌẽꞌẽ ꞌdî îcâ gólĩyî bê trá rî, gólĩyî drí ítá kãâkâ drílĩyî gõlé trá rúꞌbạ́ lâ ꞌá rî înjízó gõzó ítá gólâkâ rî âtrõlé ĩꞌdî âsõlé rúꞌbạ́ lâ ꞌá óꞌdí. Drílĩyî gólâ rî drı̣̃zó âjílí võ ꞌẽzó gólâ rî îpálé fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yésũ trá rĩꞌá fê lậlı̣̂-lậlı̣̂ njı̣̃ꞌá nĩzó ĩꞌdí bê lâ võ õjílã îpâ kâ rî ꞌálâ. Gõꞌdá pávó ꞌá rî, Yésũ rî fãfã drí rû ndẽzó. Gõꞌdá îcá kô drílâ rĩzó zãâ fê lậlı̣̂-lậlı̣̂ íyíkâ ꞌdĩ njı̣̃lı̣́. Tólâ ãgô ãzâ bê Kĩrénẽ lé ꞌbá ꞌî pávó tı̣̂ ꞌá, rú lâ Sĩmónã. Sĩmónã rî nĩꞌá Yẽrõsãlémã ꞌálâ ꞌbạ̃drı̣̃ mvá íyíkâ rî lésĩ. Gõꞌdá ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî ûsû gólâ bê pávó ꞌá rî, drílĩyî gólâ rî ꞌbãzó mbârâkã sĩ fê lậlı̣̂-lậlı̣̂ Yésũ drí îcálé njı̣̃lâ kô ꞌdĩ njı̣̃lı̣́ Yésũ bê. ");
INSERT INTO avu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ĩtí rî, drílĩyî Yésũ rî âjízó võ zı̣̃lı̣́ Gõlõgótã rî ꞌálâ. Gõlõgótã ꞌdĩ ĩtõ lâ kĩ, võ ãvõ drı̣̃ fã kâ. ");
INSERT INTO avu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Võ rî ꞌdĩ ꞌá tólâ rî, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí ngãzó rĩlí õdrá ônjálé trá ãlókõ bê rî âtrõlé rĩꞌá fẽlâ Yésũ drí mvũlı̣́, ãꞌdô ró ngá lâzê-lâzê gólâ rú ꞌdĩ sı̣́ lâ ậꞌdı̣́lı̣́. Gõꞌdá Yésũ gã íyîngá dó mvũlâ. ");
INSERT INTO avu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nĩngá sĩ, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí ngãzó ítá Yésũ kâ ângílí vólé, gõꞌdá gólâ rî trõzó îpálé ngạ́rạ́ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂, gõzó ítá gólâkâ âtrõlé lãfálâ cãlé ĩyî võ ꞌásĩ, gõꞌdá ãzâ tãndí rî âtrõzó vũlı̣́ gõmárĩ sĩ, tãlâ gólĩyî lẽ ndrẽlâ ngãtá ítá rî ꞌdĩ â ꞌdẽꞌá ãꞌdî drí yã rî. ");
INSERT INTO avu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ị̃tú-pá gólĩyî drí Yésũ rî îpázó rî trá rĩꞌá njı̣̂-drı̣̃-lâ-sû cı̣̃ı̣́nó. ");
INSERT INTO avu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nĩngá sĩ, tã âꞌbãlé Yésũ rú rî îgĩzó ngá tã âꞌdâ kâ drı̣̃ı̣̂ trõlé îpálé gá fê lậlı̣̂-lậlı̣̂ ꞌdĩ drı̣̃ı̣̂ Yésũ rî drı̣̃lı̣́ ꞌá. Tã âꞌbã îgĩlí Yésũ rú ꞌdĩ rĩꞌá nõtí, ");
INSERT INTO avu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ị̃tú gólâ Yésũ rî îpázó ꞌdĩ tú rî, íîpâ ngá ôpá ꞌbá ãzâ ꞌbá yî kpá zãlô rı̣̃ gólâ rî gãrã drı̣̃ ꞌá fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂. Ngá ôpá ꞌbá ãzâ ãlô rî íîpâ íyíkâ gõlé Yésũ rî drı̣́-ágó drı̣̃ lésĩ, gõꞌdá gólâ ãzâ rî íyíkâ gõlé drı̣́-lı̣̃jı̣́ lâ lésĩ ró. ");
INSERT INTO avu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Tã ngá ôpá ꞌbá gólĩyî îpálé Yésũ rî gãrã drı̣̃ ꞌá ꞌdĩ ꞌbá yí kâ âꞌdâ tã gólâ îgĩlí trá búkũ Ôvârí kâ ꞌá kĩꞌá nĩ rî, “Úûsû gólâ trá tã õnjí ꞌbá ró, ĩꞌdî gõzó gólâ rî fũlı̣́ tã õnjí ꞌbá ãzí bê.”) ");
INSERT INTO avu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Õjílã gólĩyî rĩ ꞌbá lậvũlı̣́ rî ꞌbá yî drí rĩzó Yésũ rî lôꞌdálé gõzó ĩyî drı̣̃ îyálé. Nĩngá sĩ, drílĩyî tã âtázó kĩ nĩ rî, “Ní kĩ nĩ rî, yí âꞌdô îcáꞌá cú jó ạ́ngı̣́ Ôvârí kâ ûfúlı̣́ gõꞌdá kpá bẽzó lâ jó óꞌdí ró cé kậyı̣̂ nâ sĩ. ");
INSERT INTO avu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bê trá ĩtí rî, õzõ ní ãꞌdô cú mbârâkã bê rî, ꞌdõvó ní pâ drẽ nî ngbãângbânõ kậyı̣̂ nõ sĩ fê lậlı̣̂-lậlı̣̂ ꞌdĩ drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kpá té õzõ sı̣́sı̣́ nã ꞌbá yí kâtí, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ndrĩ ꞌdó lãꞌbí îmbá ꞌbá ãzâ ꞌbá yí bê drí ngãzó ĩyî rĩlí Yésũ rî gũlı̣́ rõô ĩyî lãfálé ꞌásĩ kĩ nĩ rî, “Gólâ îcâ íyíkâ cé õjílã ãzâ ꞌbá yî pãlé ĩꞌdî, gõꞌdá gólâ îcá íyíkâ kô íyî nyãányâ pãlé õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Gólâ kĩ, yí ãꞌdô ꞌdíyî pã ꞌbá ꞌî gõꞌdá kpá kúmú ạ́ngı̣́ ãmâ õjílã Ĩsĩrãꞌélẽ yí kâ ĩꞌdî rî, ꞌdõvó gólâ ãârî vũdrı̣́ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ sĩ ngbãângbânõ, tãlâ mã ndrê ró drẽ gólâ rî mbârâkã, gõꞌdá mã lẽ ró tã gólâ ꞌá.” Gõꞌdá ngá ôpá ꞌbá gólĩyî rı̣̃ Yésũ bê fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ rî ꞌbá yî gû ĩyî kpá gólâ. ");
INSERT INTO avu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ị̃tú-pá mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ sĩ, ı̣̃tú gạ̃gạ̃lı̣́gạ̃ sĩ ı̣́nı̣́rı̣́kúwạ́ drí ꞌbạ̃drı̣̃ lîmózó ndrĩ gúndrı̣̃ tã lârâkô ró. Ị́nı̣́rı̣́kúwạ́ ꞌdĩ lîmô ꞌbạ̃drı̣̃ njãlé bũúũ ı̣̃tú-pá nâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gõꞌdá ı̣̃tú-pá nâ ꞌdĩ ꞌá rî, Yésũ drí ngãzó trẽlé ûrû Ãrãmáyã tı̣̂ sĩ kĩ nĩ rî, Ẽlóyĩ, Ẽlóyĩ, lámã sãbãkãtánĩ? Ĩtõ lâ kĩ, “Ôvârí ámákâ, Ôvârí ámákâ, ní âyê mâ ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gõꞌdá nĩngá sĩ, õjílã ũrûkậ ꞌbá yî rĩ ꞌbá âdrélé ĩyî ãnyî rî ꞌbá yî ârílí bê ĩyî úlı̣́ Yésũ kâ ꞌdĩ rî, gólĩyî nı̣̃ı̣́ tã ífí lâ kô, gõꞌdá drílĩyî ngãzó tã âtálé kĩ, “Hé! Nĩ ârî drẽ úlı̣́ gólâkâ ꞌdĩ. Gólâ rĩꞌá tã ậngũ ꞌbá Ẽlíyã rî zı̣̃ꞌá ânĩlí íyî pãlé.” ");
INSERT INTO avu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Vó lâ sĩ, ãgô ãzâ drí ngãzó rãlé nĩꞌá ngá ãzâ õzõ cõfó kâtí rî âtrõlé. Drílâ trõzó lâ sõlé õdrá ạ̃ꞌdı̣́ ꞌá gõzó sõlâ fê mvá sı̣́lı̣́, gõꞌdá îngázó lâ îjõlé Yésũ drí ndrõlé. Nĩngá sĩ, drílâ tã âtázó õjílã ãzâ ꞌbá yî drí kĩ nĩ rî, “Nĩ rî drẽ njũrũ ngbãângbânõ ndrẽlâ ngãtá Ẽlíyã âꞌdô âcáꞌá fí trá gólâ rî pãlé yã rî.” ");
INSERT INTO avu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ĩtí, Yésũ drí kpá ngãzó trẽlé ûrû óꞌdí gõꞌdá lôvó-lôvó âyézó. ");
INSERT INTO avu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gõꞌdá Yésũ drã bê rî, ítá bı̣́ ꞌbãlé jó mvá tı̣́ jó ạ́ngı̣́ Ôvârí kâ ꞌá rî drí ngãzó sĩlí ãkpẽrẽ ûrú lésĩ bũúũ vũdrı̣́. ");
INSERT INTO avu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nĩngá sĩ, drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ gólâ âdré ꞌbá Yésũ ândrá rî ârílí bê Yésũ rî trẽtrẽ gõꞌdá ndrélé bê lạ́tı̣̂ Yésũ drí drãzó ꞌdĩ rî, drílâ gõzó tã âtálé kĩ, “Pạ̃tı̣́ı̣̃! Ãgô nõ rĩꞌá Ôvârí rî mvá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Gõꞌdá nĩngá sĩ, õkó ũrûkậ ꞌbá yî Yésũ rî lẽ ꞌbá trá rî ĩyíkâ gĩâ âdréꞌá ĩyî nãtí Yésũ rú sĩ rĩꞌá ĩyî gólâ rî ndrẽꞌá drãrẽ ꞌá. Gólĩyî lãfálé ꞌá rî, rĩꞌá Mãríyã Mãgãdálã, Sãlómẽ, gõꞌdá kpá Mãríyã Yãkóbã gólâ dãwá ró rî ândrê yî Jósẽ bê. ");
INSERT INTO avu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gãlĩláyã ꞌálâ rî, õkó nâ ꞌdĩ ꞌbá yî lôbẽ ĩyî Yésũ rî vó trá, gólĩyî fẽ ngá nyãnyã trá tólâ Yésũ yî drí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. Gõꞌdá õkó ãmbá dũû gólĩyî ânĩ ꞌbá trá Yésũ bê Yẽrõsãlémã lésĩ rî, kpá ꞌdó bê ndrĩ rĩꞌá ĩyî tólâ õkó nâ ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yésũ drã té ı̣̃tú gólâ õjílã drí rĩzó ĩyî êdélé kậyı̣̂ gólâ lôvô-lôvô kâ rî tãsĩ rî ꞌá. Kậyı̣̂ rî ꞌdĩ ĩꞌdî sı̣́sı̣́ Sạ́bı̣̃ drí sĩ. Tólâ ãgô ãzâ bê rĩꞌá rú lâ Yõsépã Ãrãmãtáyã lésĩ. Gólâ ãgô ı̣̂njı̣̃-ı̣̂njı̣̃ ꞌî gólĩyî drı̣̃-ꞌbá Yúdạ̃ yí kâ rî ꞌbá yî lãfálé ꞌásĩ. Gólâ rî trá tã lẽꞌá Yésũ ꞌá gõꞌdá gólâ rî âgõ-âgõ ãngó nõ ꞌá rî tẽlé. Gõꞌdá lạ̃njạ́túlı̣́ âcâ bê rî, drílâ ngãzó íyî fĩî zãlé ngãzó nĩlí kúmú Pĩlátõ ngálâ Yésũ rî ãvõ tãsĩ, tãlâ yí õlậpı̣̂ ró bê drẽ ãkpãkãꞌdã kậyı̣̂ lôvô-lôvô kâ rî âcá drẽ kô. ");
INSERT INTO avu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gõꞌdá úlı̣́ kĩzó nĩ Yésũ õdrã trá rî drí ẽꞌdẽ dãzó Pĩlátõ rú. Nĩngá sĩ, drílâ drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ậzı̣́zó ãlô yí ngálâ îjílí ngãtá fí tã pạ̃tı̣́ı̣̃ ꞌî kĩzó nĩ rî, Yésũ õdrã trá yã rî. ");
INSERT INTO avu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gõꞌdá gólâ ârílí bê kĩ, pạ̃tı̣́ı̣̃ Yésũ drã trá rî, drílâ tã-drı̣̃ lẽzó Yõsépã yî drí Yésũ rî ãvõ trõlé nĩꞌá ꞌbãlâ. ");
INSERT INTO avu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ĩtí rî, Yõsépã yî drí ítá tãndí mvẽêmvê âtrõzó, gõzó Yésũ rî ãvõ âtrõlé fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ sĩ, gõꞌdá ítá ꞌdĩ âtrõzó Yésũ rî ãvõ gõzó ĩꞌdî sĩ lâ ngóló-ngóló. Nĩngá sĩ, trõzó lâ ꞌbãlé ũgı̣́ gólâkâ drílâ ꞌdı̣̃lı̣́ ꞌdı̣̃ꞌdı̣̃ únı̣́ ꞌá rî ꞌá. Vó lâ sĩ, drílâ kúnı̣́ úngû ạ́ngı̣́ lîlízó ndũû ũgı̣́ ꞌdĩ tı̣́. ");
INSERT INTO avu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ꞌDĩî Mãríyã Mãgãdálã yî Mãríyã gólâ Jósẽ rî ândrê ró rî bê, drílĩyî ngãzó ꞌdẽlé ĩyî Yõsépã yî vó nĩꞌá võ gólâ Yésũ rî ãvõ ꞌbãzó rî ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gõꞌdá kậyı̣̂ lôvô-lôvô kâ ndẽ rû bê ı̣̃tú-pá njı̣̂-kázíyá sĩ lạ̃njạ́túlı̣́ bê rî, Mãríyã Yãkóbã rî ândrê, gõꞌdá Mãríyã Mãgãdálã lésĩ rî, Sãlómẽ yí bê drí ngãzó ĩyî nĩlí ãlókõ dõ ró gólĩyî drí gĩlí trá rî âtrõlé ânĩzó ĩꞌdí bê lâ lóꞌdé drı̣̃ ꞌálâ ı̣̂nı̣́lı̣́ Yésũ rî ãvõ rú. ");
INSERT INTO avu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kậyı̣̂ ãlô kậyı̣̂ lôvô-lôvô kâ vósĩ rî, drílĩyî ngãzó nĩlí ĩyî ãkpãkãꞌdã ꞌbõlõwá ãwó sĩ. Gõꞌdá ı̣̃tú drí âfõrẽ ꞌá rî, drílĩyî cãzó lóꞌdé drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Drẽ gólĩyî ãkpãkãꞌdã lạ́tı̣̂ ꞌá rî, gólĩyî îjî tã trá ĩyî võ ꞌásĩ kĩ, “Ãꞌdî âꞌdô kó kúnı̣́ úngû ạ́ngı̣́ ũgı̣́ tı̣́ ꞌdĩ jãꞌá vólé ãmâ drí nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Gõꞌdá gólĩyî îngâ bê drı̣̃ võ ndrẽlé ạ̃tı̣́ ꞌálâ rî, drílĩyî ngá ndrẽzó, kúnı̣́ úngû ạ́ngı̣́ ũgı̣́ tı̣́ rî ójâ trá vólé. ");
INSERT INTO avu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ĩtí, drílĩyî ngãzó fĩlí cú ũgı̣́ ꞌálâ. Gõꞌdá ũgı̣́ ꞌá tólâ rî, gólĩyî drí ãgô ãnjî ãzâ ndrẽzó ítá mvẽêmvê ãcê kpírí-kpírí rî bê yí rú. Ãgô ãnjî rî ꞌdĩ rî gõlé drı̣́-ágó lésĩ ró. Gõꞌdá õkó nâ ꞌdĩ ꞌbá yî ndrê bê gólâ ĩtí rî, tı̣̂ lâ yî drí ậꞌdı̣́zó ũrı̣̃ drí tã lârâkô ꞌdĩ drí sĩ. ");
INSERT INTO avu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nĩngá sĩ, ãgô rî ꞌdĩ drí ngãzó tã âtálé gólĩyî drí kĩ, “Nĩ ꞌê ũrı̣̃ kô. Nĩ lôndã ꞌdî Yésũ Nãzãrétã lésĩ rî ĩꞌdî. Gólâ ĩꞌdî fũlı̣́ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ rî. Nĩ ndrê võ gólâ rî ãvõ lâlãzó rî. Nĩ ndrê, ngbãângbânõ gólâ gõꞌdá trá nĩngá yûꞌdạ́wạ́. Gólâ bê rĩꞌá lédrẽ-lédrẽ ró. Gólâ lîdrî trá õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nĩ ngâ nĩlí tã ꞌdî pẽlé Pétẽrõ drí lãjóꞌbá ãzí lâ yí bê. Nĩ pẽ gólĩyî drí kĩ nĩ rî, Yésũ trá rĩꞌá nĩꞌá Gãlĩláyã ꞌálâ gólĩyî ândrá ꞌálâ. Gólĩyî âꞌdô gólâ rî ndrẽꞌá tólâ, õzõ drílâ âtálé trá gólĩyî drí sı̣́sı̣́ rî tí.” ");
INSERT INTO avu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ĩtí, õkó ꞌdĩ ꞌbá yî drí ngãzó lóꞌdé drı̣̃ âyélé rãzó, tãlâ tı̣̂ lâ yî ậꞌdı̣̂ trá ậꞌdı̣̂, gõꞌdá gólĩyî trá ndrĩ ũrı̣̃ ró kpá lẽlẽ ró. Gólĩyî njı̣̃ı̣́ tı̣̂ kô õjílã ãzãkã drí pávó ꞌá, tãlâ gólĩyî trá ũrı̣̃ ró rõô. ");
INSERT INTO avu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gõꞌdá Yésũ lîdrî bê õdrã ꞌásĩ Gímã sĩ ãkpãkãꞌdã cı̣̃ı̣́nó rî, drílâ íyî âꞌdázó sı̣́sı̣́ Mãríyã Mãgãdálã drí. Mãríyã ꞌdĩ gólâ Yésũ drí líndrí õnjí njı̣̂-drı̣̃-lâ-rı̣̃ lâdrózó trá vólé ꞌálâ sĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nĩngá sĩ, Mãríyã Mãgãdálã drí ngãzó nĩlí tã ꞌdî ngĩlí õjílã gólĩyî âꞌdó ꞌbá Yésũ bê rî yî drí. Gólĩyî trá ĩzã ꞌẽꞌá, gõꞌdá kpá ãwó ró rõô. ");
INSERT INTO avu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Gõꞌdá Mãríyã Mãgãdálã drí tã âtázó õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, yí õndrê Yésũ trá, gólâ lîdrî trá. Gólĩyî gã dó úlı̣́ Mãríyã drí âtálé ꞌdĩ ârílí. ");
INSERT INTO avu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ꞌDĩî vósĩ, Yésũ drí kpá íyî âꞌdázó lârâkô ngĩî ãzâ sĩ tã ârí ꞌbá rı̣̃ rî ꞌbá yî drí, drílĩyî rû ûsúrı̣̃ lạ́tı̣̂ ꞌá nĩrĩ ꞌá ꞌbạ̃drı̣̃ mvá ãzâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nĩngá sĩ, tã ârí ꞌbá rı̣̃ ꞌdî ꞌbá yî drí ngãzó gõlé Yẽrõsãlémã ꞌálâ nĩꞌá kpá tã lâ pẽlé tã ârí ꞌbá ạ̃mbúkũ ꞌdî ꞌbá yî drí. Gõꞌdá tã ârí ꞌbá ạ̃mbúkũ ꞌdî ꞌbá yî lẽé ĩyî tã kpá kô úlı̣́ tã ârí ꞌbá rı̣̃ ꞌdî ꞌbá yî drí pẽlé ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ꞌDĩî vósĩ, Yésũ drí íyî âꞌdázó lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-ãlô rî ꞌbá yî drí gólĩyî drí rĩrĩ ngá nyãlé rî ꞌá. Yésũ drí tã lôgõzó gólĩyî drı̣̃ı̣̂ tã õnjí gólĩyíkâ tãsĩ, tãlâ gólĩyî cú ĩtí tã lẽlẽ ãkó. Gólĩyî gã trá dó úlı̣́ õjílã Yésũ rî ndrẽ ꞌbá trá rî ꞌbá yí kâ ârílí Yésũ rî gógó lîdrî-lîdrî lâ õdrã ꞌásĩ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó gólĩyî drí kĩ, “Nĩ ngâ lậꞌbúlı̣́ ꞌbạ̃drı̣̃ ꞌásĩ ndrĩ tã âtî-âtî tãndí Ôvârí kâ ngĩlí õjílã drí ndrĩ kậkậrậ. ");
INSERT INTO avu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Áâꞌdô õjílã gólĩyî tã lẽ ꞌbá trá tã âtî-âtî tãndí Ôvârí kâ ꞌá gõꞌdá kpá lũmvû bãbãtízĩ kâ dãzó trá drı̣̃ lâ ĩyî rî pãꞌá. Gólĩyî gã ꞌbá ĩyíkâ dó rî, áâꞌdô tã-vó gólĩyíkâ kĩꞌá õnjí ró. ");
INSERT INTO avu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gólĩyî tã lẽ ꞌbá trá rî ꞌbá yî âꞌdô ĩyî tã lârâkô nõ ꞌbá yî ꞌẽꞌá ĩꞌdî. Gólĩyî âꞌdô líndrí õnjí lôfõꞌá vólé õjílã ꞌásĩ ámâ rú zı̣̃zı̣̃ sĩ. Gólĩyî âꞌdô tı̣̂ drílĩyî âtálé kôꞌdáwá rî âtáꞌá. ");
INSERT INTO avu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Gólĩyî âꞌdô ı̣̃nı̣̃ rũꞌá drı̣́ sĩ, ngãtá õzõ gólĩyî ũmvû ạ̃lı̣́ trá rî, gólĩyî drãá kô. Gólĩyî âꞌdô drı̣́ ꞌbãꞌá ngá lãzé ꞌbá drı̣̃ı̣̂, tãlâ õngâ ró ĩyî bê ngá lãzé ꞌásĩ âꞌdólé rúꞌbạ́ ạ̃ꞌdı̣́ sĩ.” ");
INSERT INTO avu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nĩngá sĩ, Yésũ âtâ bê úlı̣́ ndẽlé lãjóꞌbá íyíkâ drí rî, ódrí gólâ rî trõzó ꞌbũû ꞌálâ rĩlí drı̣́-ágó Ôvârí kâ drı̣̃ı̣̂, ãngó rũlı̣́ Ôvârí bê. ");
INSERT INTO avu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nĩngá sĩ, tã ârí ꞌbá ꞌdĩ ꞌbá yî drí ngãzó nĩlí tã âtî-âtî tãndí Ôvârí kâ ngĩ bê õjílã drí võ ꞌásĩ ndrĩ. Gõꞌdá Yésũ drí gólĩyî pãzó tã âꞌdálé õjílã drí kĩ, tã âtî-âtî gólĩyî drí âtálé ꞌdĩ rĩꞌá pạ̃tı̣́ı̣̃ tã lârâkô gólĩyî drí ꞌẽlé rî ꞌbá yî sĩ. Íꞌdígówá nõ ạ̃dũkũ lâ ĩꞌdî nõ.");
INSERT INTO avu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ãgô ãmbá Tĩyõfílẽ, tã îgĩ-îgĩ nô ní drí õjílã ãzâ ꞌbá yî ãnî drí ꞌbãzó gólĩyí bê Kúmú Yésũ ꞌá rî yí bê. Má lẽ trá tã nô ífí lâ mbı̣̂mbı̣̂ lâ âtálé ãnî drí tã Yésũ kâ tãsĩ. Õjílã ãzâ ꞌbá yî rĩꞌá nı̣̃ ĩyî trá dódó, îgĩ ĩyî tã trá tã gólâkâ tãsĩ. Má nı̣̃ trá tã õjílã nã ꞌbá yî drí îgĩlí ꞌdĩ rĩꞌá tã pạ̃tı̣́-pạ̃tı̣̃ rû ꞌẽ ꞌbá trá rî ĩꞌdî. Õjílã nã ꞌbá yî ĩꞌdî rĩ ꞌbá ĩyî tã gólâkâ rî îcílí õjílã drí rî ĩꞌdî, mâ rî gógó má rî trá tã gólâkâ ꞌdĩ tı̣̂ lâ ŋãlé õjílã nã ꞌbá yí bê. Má drí kpá tã ꞌdî ndrẽ ꞌbá lâ ãzâ ꞌbá yî ûsúzó ãmâ drí rĩzó tã ꞌdî tı̣̂ lâ ŋãlé gólĩyí bê. Má ûjũ tã gólĩyî drí îgĩlí ꞌdĩ îgĩlí óꞌdí mãnísĩ tãndí ró, tãlâ nĩ lẽ ró tã lâ bê ndrĩ dódó. Tã má drí îgĩlí ãnî drí nõ îtõ rĩꞌá Yésũ rî tı̣̃tı̣̃ ꞌásĩ bũúũ âcálé gólâ rî gõgõ Ôvârí ngálâ ûrú ꞌálâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ndrô gólâ tíbê Yõwánĩ rî tı̣̃zó rî ꞌá rî, Ẽródẽ ĩꞌdî kúmú ró ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ rî drı̣̃ı̣̂. Ndrô gólâ ꞌdĩ ꞌá rî, ãgô ãzâ rĩꞌá drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî ró, rú lâ Zãkãríyã, õkó lâ rî rú íyíkâ Ẽlĩzãbétã. Gõꞌdá Ẽlĩzãbétã rî átá kpá drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zãkãríyã yî õkó lâ bê tã ꞌẽꞌẽ gólĩyíkâ rĩꞌá tãndí ró Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá. Gólĩyî rô Ôvârí rî tı̣̂-võ trá, té õzõ Ôvârí drí lẽlé rî tí. ");
INSERT INTO avu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gólĩyî cú ĩtí mvá ãkó, tãlâ Ẽlĩzãbétã rĩꞌá óndó ꞌî. Gólĩyî ꞌdó kpạ̃rạ̃tı̣́ ãrãkã ró. ");
INSERT INTO avu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tã ꞌẽꞌẽ gólâ drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî kâ ꞌdĩ, órî ꞌẽlâ Yẽrõsãlémã ꞌálâ jó ạ́ngı̣́ Ôvârí kâ nã ꞌá. Zãkãríyã yî drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ ãzâ ꞌbá yí bê gólĩyî ꞌbạ̃súrú dãwá rî gógó Zãkãríyã kâ rî ꞌásĩ rî, drílĩyî ânĩzó Yẽrõsãlémã ꞌálâ rĩlí ngá ạ̃jı̣́ bê tũrũ-tũrũ õzõ bạ̃húrũ kâtí rî zãlé Ôvârí drí ûrú ꞌálâ. Gólĩyî ꞌê ĩyî tã ꞌdî õrĩ Yúdạ̃ yí kâ drí ndrĩ. Kậyı̣̂ vósĩ cé lạ̃njạ́túlı̣́ bê, drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ ãlô rî drí fĩzó jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌálâ rĩlí ngá ạ̃jı̣́ bê rî zãlé Ôvârí drí ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kậyı̣̂ ãzâ sĩ, lạ̃njạ́túlı̣́ bê, Zãkãríyã rî ãzí-ãzí yî zĩ gólâ trá ꞌbãlé rĩꞌá ngá ạ̃jı̣́ bê rî zãlé jó ạ́ngı̣́ Ôvârí kâ nã ꞌá. Drílâ gõzó fĩlí jó ạ́ngı̣́ ꞌdĩ ꞌá cé élêwálâ. ");
INSERT INTO avu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Õjílã ãzâ ꞌbá yî bê dũû, rî ĩyíkâ ĩví ꞌálâ rãtáã ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Gólâ rî bê ngá ạ̃jı̣́ bê ꞌdĩ zãlé jó ạ́ngı̣́ ꞌdĩ ꞌálâ rî, mãlãyíkã lãjóꞌbá Ôvârí kâ drí âcázó. Mãlãyíkã ꞌdî rî âdrélé ãnyî võ ngá zãzó ꞌdĩ rú, drı̣́-ágó lésĩ ró. ");
INSERT INTO avu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gõꞌdá gólâ ndrê mãlãyíkã ꞌdî bê rî, gólâ lârô trá, dạ̃kạ́rũ, lẽlẽ ró. ");
INSERT INTO avu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gõꞌdá mãlãyíkã ꞌdî drí tã âtázó gólâ drí kĩ nĩ rî, “Ní ꞌê ũrı̣̃ kô. Má ânĩ ĩꞌdî tã nô âtálé ní drí nõ, rãtáã áníkâ rĩꞌá ꞌẽlé ı̣̃tú vósĩ cé rî, Ôvârí ârî trá. Ánî õkó Ẽlĩzãbétã âꞌdô rû ꞌbãꞌá ꞌâ bê. Drílâ mvá tı̣̃zó ágó ró. Ní âꞌdô rú lâ zı̣̃ꞌá Yõwánĩ. ");
INSERT INTO avu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ánî lı̣̃fı̣́ âꞌdô wãꞌá tõwã mvá ꞌdĩ tãsĩ. Õjílã ndrĩ sı̣́ lâ ĩyî âꞌdô ârí gũꞌá tã ꞌẽꞌẽ tãndí mvá ꞌdĩ kâ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tã ífí lâ ĩꞌdî rĩꞌá nõtí, tãlâ Ôvârí zĩ gólâ trá rĩlí õjílã lı̣̃fı̣́ îcílí tã mbı̣̂mbı̣̂ sĩ. Ôvârí zĩ gólâ trá ꞌbãlé õjílã ífífí ró, tã ꞌẽꞌẽ gólâkâ âꞌdô ꞌbãꞌá ngĩî ãzí-ãzí lãfálé sĩ. Gólâ mvú õdrá kô. Líndrí Tãndí Ôvârí kâ âꞌdô rĩꞌá gólâ bê gólâ rî lôpélé gólâ rî pãꞌá tã íyíkâ ꞌẽlé ndrĩ tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gólâ âꞌdô õjílã õrĩ Ĩsĩrãꞌélẽ kâ rî ꞌbá yí kâ drı̣̃ lâ yî âjáꞌá ꞌdẽlé Ôvârí vó. ");
INSERT INTO avu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Gólâ âꞌdô ꞌdẽꞌá sı̣́sı̣́ võ êdélé Ôvârí drí âꞌdézó gólâ vó. Gólâ âꞌdô tã âtî-âtî tãndí Ôvârí kâ pẽꞌá, drílâ õjílã âsézó ndrĩ ârílâ. Gólâ rî gógó âꞌdô ꞌbãꞌá kpá mbârâkã bê, õzõ tã ậngũ ꞌbá Ẽlíyã tíbê drã ꞌbá ạ̃kû ró rî tí. Gólâ âꞌdô tã pẽꞌá mvá rî átá yî drí mvá lâ yí bê gólĩyî ꞌbãlé âꞌdólé ãyĩkõ ró ꞌâ ạ̃ꞌdı̣́ sĩ. Gólâ âꞌdô tã pẽꞌá õjílã gólĩyî ârîmâkô ꞌbá drí, gõꞌdá drílĩyî ĩyî jãzó tã mbı̣̂ rî ı̣̂sũlı̣́ ĩꞌdî. Gólâ âꞌdô tã pẽꞌá õjílã drí ĩyî êdézó njãâ tã õnjí ãkó Ôvârí drí âcázó ûsúlâ ĩyî ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zãkãríyã drí tã âtázó mãlãyíkã ꞌdî drí, “Âꞌdô ꞌbãꞌá ángô tí ró yã? Mâ trá ãrãkã ró, ámâ õkó kpá trá ãrãkã ꞌî rî.” ");
INSERT INTO avu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mãlãyíkã ꞌdî drí tã-drı̣̃ lôgõzó kĩ nĩ rî, “Mâ Gãbẽrélẽ ĩꞌdî. Mâ lãjóꞌbá Ôvârí kâ ĩꞌdî. Ôvârí âjô mâ tã tãndí nõ âtálé ní drí, gõꞌdá ní lẽé kô. ");
INSERT INTO avu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tã ámâ âjózó ĩꞌdí bê lâ rî rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî, âꞌdô rû ꞌẽꞌá té õzõ má drí âtálé ꞌdĩ tí. Gõꞌdá ní lẽé tã má drí âtálé ꞌdĩ bê kô rî, ngbãângbânõ nĩlí sı̣́sı̣́ ꞌálâ Ôvârí âꞌdô ánî ꞌbãꞌá ũꞌdúꞌdû ró.” ");
INSERT INTO avu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gõꞌdá õjílã gólĩyî ĩví ꞌálâ rî ꞌbá yî ĩyíkâ drẽ zãâ âdréꞌá jó ạ́ngı̣́ ꞌdĩ tı̣́lı̣́ Zãkãríyã rî tẽlé âfõlé rî, gólĩyî kĩ, “Zãkãríyã rî njãlé jó ꞌá nõ ãꞌdô ꞌẽꞌá yã?” ");
INSERT INTO avu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gõꞌdá gólâ âfõ bê rî, âtá úlı̣́ gõꞌdá kó kô, tãlâ gólâ trá ũꞌdúꞌdû ró. Rî tã âtálé cé drı̣́ sĩ. Gõꞌdá õjílã ꞌdî ꞌbá yî âtâ ĩyî tã trá kĩ nĩ rî, “ꞌDĩî, gólâ ndrê tã lârâkô ãzâ ꞌbá yî trá jó ꞌá tólâ.” ");
INSERT INTO avu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Gõꞌdá ꞌdĩî rî vósĩ rî, kậyı̣̂ ꞌdĩ ꞌbá yî gólâ drí rĩzó ngá ꞌẽꞌẽ ꞌẽlé jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌálâ rî ndẽ rû trá. Gólâ ngâ trá gõlé ꞌbã ꞌálâ té ꞌbạ̃drı̣̃ mvá íyíkâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gõꞌdá õkó lâ Ẽlĩzãbétã ꞌbã rû trá ꞌâ bê. Ẽlĩzãbétã rî trá ꞌbã ꞌá lậmú ãkó ꞌbã-tı̣̂ ꞌásĩ párá njı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ẽlĩzãbétã kĩ nĩ rî, “Ngbãângbânõ Ôvârí pâ mâ trá. Gólâ ndrê mâ bê rî, ámâ ĩzã gâ trá gólâ lı̣̃fı̣́, má ꞌbã rû trá ꞌâ bê. Gólâ trõ ãnyĩ trá má drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ẽlĩzãbétã bê trá ꞌâ bê párá njı̣̂-kázíyá rî, Ôvârí drí lãjóꞌbá íyíkâ Gãbẽrélẽ rî âjózó ízámvá ãzâ rú bê Mãríyã rî ngálâ. Mãríyã ꞌdĩ rî rĩlí Nãzãrétã ꞌálâ. Nãzãrétã rĩꞌá Gãlĩláyã ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gólâ lẽ tã trá ãgô ãzâ rú bê Yõsépã rî trõzó ágó ró. ꞌDĩî gólâ nı̣̃ı̣́ drẽ ãgô tã kô. ꞌDĩî Yõsépã rĩꞌá kúmú Dạ̃wúdı̣̃ rî ózõwá ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gãbẽrélẽ drí âcázó Mãríyã ngálâ tã âtálé kĩ nĩ rî, “Tã ậꞌdı̣̂-ậꞌdı̣̂ Ôvârí kâ ãâꞌdô ní bê. Gólâ lẽ nî trá kôrô.” ");
INSERT INTO avu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tã âtálé ꞌdĩ sĩ rî, Mãríyã rî drı̣̃ lîjã trá, gõꞌdá gólâ nı̣̃ı̣́ úlı̣́ ífí Gãbẽrélẽ drí âtálé yí drí ꞌdĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gãbẽrélẽ drí gõzó tã âtálé gólâ drí kĩ nĩ rî, “Mãríyã, ní ꞌê ũrı̣̃ kô, tãlâ Ôvârí zĩ nî trá cé ĩꞌdî élêwálâ õkó mvá ãzí lãfálé sĩ ꞌbãlé ꞌdíyî pã ꞌbá rî ândrê ró. ");
INSERT INTO avu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ní âꞌdô rû ꞌbãꞌá ꞌâ bê, gõꞌdá ní drí tı̣̃zó lâ mvá ágó ró. Ní âꞌdô rú lâ zı̣̃ꞌá “‘Yésũ”’. ");
INSERT INTO avu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Gólâ ĩꞌdî tíbê Dạ̃wúdı̣̃ rî ózõwá ró rî, gõꞌdá gólâ kpá ĩꞌdî tíbê Ôvârí drí tã lâ ꞌbãlé kĩꞌá nĩ rî, yí âꞌdô âjóꞌá lâ rĩlí kúmú ró õrĩ ãníkâ rî ꞌbá yî drı̣̃ı̣̂ zãâ ạ̃dũkũ ãkó rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mãríyã kĩ nĩ rî, “ꞌDĩî rî âꞌdô ꞌbãꞌá ángô tí yã? Mâ drẽ ꞌdĩyímvá ró nõ. Má nı̣̃ı̣́ drẽ tã ãgô kâ kpá kô nõ.” ");
INSERT INTO avu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gãbẽrélẽ kĩ, “Ôvârí rî mbârâkã âꞌdô ánî ꞌbãꞌá trá rû ꞌbãlé ꞌâ bê, tãlâ mvá rî ꞌdĩ âꞌdô ꞌbãꞌá Ôvârí rî mvá ró, gólâ âꞌdô té õzõ Ôvârí rî gógó kâtí. ");
INSERT INTO avu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ní ndrê drẽ, ánî áró Ẽlĩzãbétã gólâ óndó ꞌî gõꞌdá kpá ãrãkã ró, ngbãângbânõ rî, gólâ trá cú ꞌâ bê párá njı̣̂-kázíyá. ");
INSERT INTO avu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tã ãmbá nã ꞌbá yî, Ôvârí âꞌdô ꞌbãꞌá lâ rû ꞌẽlé cú ĩtí lâŋõ ãkó. Úlı̣́ Ôvârí kâ cú mbârâkã bê.” ");
INSERT INTO avu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mãríyã kĩ, “Mâ rĩꞌá rû ı̣̂ꞌbũ ꞌbá Ôvârí kâ ĩꞌdî. Má rî gólâ rî rõlé zãâ rõrõ kárá. Má âꞌdô rû ꞌbãꞌá mvá ꞌdĩ bê. Tã ꞌdî âꞌdô âꞌdóꞌá ĩtí.” Gãbẽrélẽ drí Mãríyã rî âyézó, gõzó nĩlí. ");
INSERT INTO avu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gõꞌdá nĩngá sĩ rî, Mãríyã drí ngá íyíkâ êdézó ꞌwãâꞌwâ nĩzó íyî áró Ẽlĩzãbétã rî ndrẽlé. Ẽlĩzãbétã rî rĩlí ꞌbạ̃drı̣̃ mvá ãzâ ꞌá, võ lâ ꞌdĩ lũtú ró ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mãríyã drí âcázó Ẽlĩzãbétã drí ꞌbã ꞌálâ, gõzó fĩlí jó ꞌálâ, nî-bê-yã fẽlé Ẽlĩzãbétã drí. ");
INSERT INTO avu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gólâ fẽ nî-bê-yã bê Ẽlĩzãbétã drí rî, mvá drí rû îꞌwãzó Ẽlĩzãbétã ꞌá. Gõꞌdá Líndrí Ôvârí kâ îmbâ Ẽlĩzãbétã rî lı̣̃fı̣́ trá tã nı̣̃nı̣̃ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Gõꞌdá Ẽlĩzãbétã kĩ nĩ rî, “Óõ Mãríyã, Ôvârí ꞌbã lı̣̃fı̣́ trá ní drı̣̃ı̣̂ kôrô õkó ãzí drı̣̃ı̣̂ sĩ, tãlâ Ôvârí zĩ nî trá mvá íyíkâ tı̣̃lı̣́. Mvá tíbê ní drí ꞌẽꞌá tı̣̃lâ nõ rî, Ôvârí lẽ trá kôrô. ");
INSERT INTO avu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tãlâ ãꞌdô ꞌî, ní drí ânĩzó ámâ ndrẽlé yã? Mâ cú ĩtí fõlõgâ ró nõ. Nî ámâ pã ꞌbá rî ândrê ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Má nı̣̃ trá kĩ, ní âꞌdô ꞌbãꞌá Ôvârí rî ândrê ró, tãlâ mvá mâ rî gógó ꞌá nõ îꞌwã rû trá ãyĩkõ drí nî-bê-yã ní drí fẽlé má drí ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ôvârí lẽ nî fí trá kôrô, gólâ âꞌdô ꞌẽꞌá tã ꞌdî ꞌẽlé té õzõ drílâ âtálé mãlãyíkã drí rî tí pạ̃tı̣́ı̣̃ ró.” ");
INSERT INTO avu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Gõꞌdá Mãríyã drí Ôvârí rî lûyı̣́zó lôngó sĩ nõtí, “Má rî nõ Ôvârí rî lûyı̣́lı̣́ gólâ tíbê ꞌdíyî pã ꞌbá ró nõ. ");
INSERT INTO avu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Gólâ ꞌbã mâ trá âꞌdólé ãyĩkõ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Mâ gólâ áyábálá ró nõ, gólâ ꞌbã lı̣̃fı̣́ trá má drı̣̃ı̣̂. Nõngá sĩ, õkó ãzí ndrĩ kĩ nĩ rî, mâ trá cú ândrâ-tãndĩ bê, tãlâ Ôvârí tíbê mbârâkã ãkĩ nô, gólâ âꞌdô fãfã fẽꞌá kpá nĩ má drí tã ꞌdî ꞌbá yî ꞌẽzó. Gólâ ĩꞌdî âꞌdô-âꞌdô gólâkâ drí ꞌbãlé ngĩî õjílã ndrĩ drı̣̃ı̣̂ sĩ, tã tãndĩ gólâkâ rĩꞌá ãmbá. ");
INSERT INTO avu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ãmâ ĩzã gâ trá gólâ drı̣̃ı̣̂. Õzõ mã õrô gólâ rî, gólâ âꞌdô ãmâ pãꞌá, õzõ gólâ drí ãmâ ạ́ꞌbı̣́yạ́ yî pãrẽ ạ̃kû ró rî tí. ");
INSERT INTO avu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gólâ rî drı̣́ rĩꞌá mbârâkã bê õjílã gólĩyî lómbé-lómbéwá ꞌbá rî ꞌbá yî îzãzó vólé. ");
INSERT INTO avu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gólâ âꞌdô kúmú gólĩyî lómbé-lómbéwá ꞌbá ró rî yî îngáꞌá vólé kı̣́tı̣̃ kúmú kâ rî drı̣̃ı̣̂ sĩ, gólĩyî ꞌbã ꞌbá vólé ꞌálâ rî ꞌbãzó ĩꞌdî sı̣́sı̣́ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gólâ rî pı̣̃pı̣̂sı̣́lı̣́ mvẽêmvê ró, õjílã gólĩyî ꞌbã ꞌbá ĩzã ró rî yî pãlé. Gõꞌdá gólâ lẽé õjílã gólĩyî ãrõ-ãrõ ꞌbá ngá ãmbá ãꞌdô ró ꞌdó yí drí ꞌdĩ ꞌbá yî kô. ");
INSERT INTO avu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ngbãângbânõ rî, gólâ ꞌbã trá zãâ tã íyíkâ yí drí âtálé ãmâ ạ́ꞌbı̣́yạ́ yî drí rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Gólâ rî ãmâ pãlé, gõꞌdá gólâ zĩ ãmâ, Ãbãrãyámã rî õrĩ yî, õjílã íyíkâ ró. Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mãríyã rî trá áró lâ Ẽlĩzãbétã bê párá nâ. Ẽlĩzãbétã drí mvá tı̣̃zó zãlô, drílâ gõzó gõlé. ");
INSERT INTO avu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ẽlĩzãbétã tı̣̂ mvá trá mvá ágó ró. ");
INSERT INTO avu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Gólâ rî áró yî, gólâ rî rû-lẽ-ãzí yí bê trá ĩyî ndrĩ ãyĩkõ ró, tãlâ Ôvârí ꞌbã gólâ trá mvá tı̣̃lı̣́ gólâ drí ꞌbãrẽ õkó ãdrá ró rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kậyı̣̂ njı̣̂-drı̣̃-lâ-rı̣̃ vósĩ rî, õjílã ãzâ ꞌbá yî ânĩ ĩyî trá mvá ꞌdĩ âjílí ꞌdẽlé bãsã ꞌá. Kậyı̣̂ ꞌdĩ trá kpá kậyı̣̂ gólâ rú zı̣̃zó mvá ꞌdĩ drı̣̃ı̣̂ rî ĩꞌdî. Gólĩyî kĩ nĩ rî, “Mvá ꞌdĩ rú lâ úzı̣̂ Zãkãríyã.” ");
INSERT INTO avu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Gõꞌdá Ẽlĩzãbétã lẽé kô. Ẽlĩzãbétã kĩ nĩ rî, “Mvá ꞌdĩ rú lâ rĩꞌá Yõwánĩ.” ");
INSERT INTO avu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Õjílã ꞌdî ꞌbá yî kĩ nĩ rî, “ꞌDĩî rî lãꞌbí ãmákâ rî ĩꞌdî, mvá ꞌdĩ rú lâ zı̣̃zó õzõ áró lâ yí kâtí. Nî áró ãzâ ãkó rú bê Yõwánĩ.” ");
INSERT INTO avu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gõꞌdá gólĩyî îjî Zãkãríyã trá kĩ nĩ rî, “Ní lẽ mvá nõ rú lâ zı̣̃lı̣́ ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zãkãríyã drí gõzó mvá ꞌdĩ rú lâ îgĩlí wárãgã bı̣́ drı̣̃ı̣̂ kĩ nĩ rî, “Úzı̣̂ rú lâ Yõwánĩ.” Õjílã ꞌdî ꞌbá yî lârõ trá. ");
INSERT INTO avu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kôrô Zãkãríyã rî tı̣̂ drí rû njı̣̃zó úlı̣́ âtálé íyî tı̣̂ sĩ. Drílâ îtónãzó Ôvârí rî lûyı̣́lı̣́. ");
INSERT INTO avu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gõꞌdá ãzí-ãzí lâ yî trá ꞌdó ũrı̣̃ ró. Tã ꞌdî lậꞌbû trá ndrĩ võ nã ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Õjílã ndrĩ tã ꞌdî ꞌbá yî ârí ꞌbá rî ĩyî trá ꞌdó tã ı̣̂sũ-ı̣̂sũ ró, gólĩyî kĩ nĩ rî, “Á! Mvá rî nõ ãꞌdô lâ ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gõꞌdá nĩngá sĩ rî, Ôvârí njı̣̃ Zãkãríyã rî tı̣̂ bê rî, Líndrí Tãndí Ôvârí kâ drí gólâ rî lı̣̃fı̣́ îmbázó tã nı̣̃nı̣̃ sĩ, úlı̣́ âtázó nõtí, ");
INSERT INTO avu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Má lûyı̣̂ drẽ Ôvârí ámákâ. Gólâ trá ãnyî ꞌẽꞌá ꞌdíyî pã ꞌbá âjólé ãmâ drí mbârâkã bê. ");
INSERT INTO avu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ꞌDíyî pã ꞌbá nõ rî âꞌdô ꞌẽꞌá ꞌbãlé ãmâ drı̣̃ı̣̂ ndrĩ kúmú ró. Gólâ âꞌdô ꞌbãꞌá nĩ ãmâ lı̣́pı̣̂ ró, õzõ gólâ rî ạ́ꞌbı̣́yạ́ Dạ̃wúdı̣̃ tíbê Ôvârí rõ ꞌbá rî tí. ");
INSERT INTO avu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ạ̃kû ró rî, tã ậngũ ꞌbá Ôvârí kâ drí tã lâ âtílí kĩꞌá nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ôvârí âꞌdô ãmâ pãꞌá nĩ ãmâ ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́ sĩ, îzãá ĩyî ãmâ kô. ");
INSERT INTO avu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ꞌDĩî rî tã gólâ drílâ ꞌbãlé zãâ ãmâ ạ́ꞌbı̣́yạ́ drí ạ̃kû ró rî ĩꞌdî. Gólâ âꞌdô tã gólâ drílâ ꞌbãlé gólĩyî drí ꞌdĩ ꞌbãꞌá drílâ rû ꞌẽzó. ");
INSERT INTO avu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gólâ ꞌbã tã rî gógó ꞌdĩ trá rû ꞌẽlé Ãbãrãyámã drí, gõꞌdá tã rî gógó ꞌdĩ drí rû ꞌẽzó. ");
INSERT INTO avu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Gólâ âꞌdô ãmâ pãꞌá ãmâ ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́ sĩ, mã ı̣̂ꞌbũ ró rû bê yí drí cú ĩtí ũrı̣̃ ãkó. ");
INSERT INTO avu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Gõꞌdá kpá mã rî ró bê tã mbı̣̂ ꞌbá ró yí lı̣̃fı̣́. ");
INSERT INTO avu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ámâ mvá, má âtâ tã nô ní drí. Ní âꞌdô ꞌbãꞌá tã ậngũ ꞌbá mbârâkã bê kôrô rî ró. Ní âꞌdô ꞌbãꞌá tã ãmâ pã ꞌbá kâ lôyá ꞌbá ró. Ní âꞌdô kpá ꞌbãꞌá lı̣̃fı̣́ îcí ꞌbá ró õjílã drí âcâ-âcâ ãmâ pã ꞌbá kâ rî drı̣̃ lâ tẽlé. ");
INSERT INTO avu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ní âꞌdô õjílã lı̣̃fı̣́ îcíꞌá nĩ kĩ nĩ rî, Ôvârí rĩꞌá pı̣̃pı̣̂sı̣́lı̣́ bê mvẽêmvê ró, tãlâ gólâ âꞌdô rĩꞌá nĩ tã õnjí õjílã kâ âyélé. ");
INSERT INTO avu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ôvârí ãmákâ rĩꞌá ꞌâ ạ̃ꞌdı̣́ bê kpá ngá lẽlẽ bê. ");
INSERT INTO avu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Gólâ âꞌdô âcáꞌá õjílã ꞌbãlé rû ôjálé ngĩî tã ꞌẽꞌẽ ĩyíkâ rî ꞌásĩ. Gólâ âꞌdô ãmâ îcíꞌá ꞌbãlé mbı̣̂ Ôvârí ágálé, Ôvârí rî pı̣̃pı̣̂sı̣́lı̣́ drí ậꞌdı̣́zó ãmâ rú. Gólâ âꞌdô õdrã ũrı̣̃ gólâ rĩ ꞌbá ãmâ lı̣̃fı̣́ ôjálé õzõ ı̣́nı̣́rı̣́kúwạ́ kâtí rî trõꞌá vólé ãmâ pı̣̃pı̣̂sı̣́lı̣́ ꞌásĩ. Gólâ âꞌdô lạ́tı̣̂ Ôvârí kâ rî îꞌĩꞌá ngbángbá, gólâ rî pı̣̃pı̣̂sı̣́lı̣́ âꞌdô ậꞌdı̣́ꞌá ậꞌdı̣̂ ãmâ rú ndrĩ. Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gõꞌdá Yõwánĩ mbâ trá ạ́ngı̣́ ãgô ró, gõꞌdá gólâ nĩ trá rĩlí õmã ꞌálâ élêwálâ bũúũ âcálé ndrô gólâ drílâ rĩzó tã pẽlé õjílã gólĩyî Yũdạ́yạ̃ kâ rî ꞌbá yî drí rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Ndrô nã ꞌbá yî sĩ, kúmú ạ́ngı̣́ Rómã kâ ãzâ rĩꞌá kúmú ãzí drı̣̃ı̣̂ sĩ ndrĩ, rú lâ rĩꞌá Ạ̃gúsũtũ. Kúmú ạ́ngı̣́ ꞌdĩ drí tã ꞌbãzó õjílã drí ndrĩ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","õjílã õgõ tílílí ꞌbạ̃drı̣̃ ĩyî ạ́ꞌbı̣́yạ́ yî tı̣̃zó rî ꞌásĩ, nĩꞌá ĩyî rú îgĩlí ꞌbã-tı̣̂ ĩyíkâ vó ró bélé-bélé tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ạ̃kû ró rî, Yõsépã rî ạ́ꞌbı̣́yạ́ rî trá ꞌbạ̃drı̣̃ mvá gólâ zı̣̃lı̣́ Bẽtẽlémẽ ꞌdĩ ꞌá, gólâ ꞌbạ̃súrú kúmú Dạ̃wúdı̣̃ yí kâ rî ꞌásĩ. Gõꞌdá nĩngá sĩ rî, Yõsépã yî ngâ ĩyî trá Mãríyã bê, Nãzãrétã ꞌásĩ nĩlí Bẽtẽlémẽ ꞌálâ ĩyî rú îgĩlí bélé-bélé tãsĩ. Mãríyã ꞌbã rû trá ꞌâ bê mbârâkã Ôvârí kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Gólĩyî õtírĩ rĩî Bẽtẽlémẽ ꞌálâ rî, kậyı̣̂ Mãríyã drí ꞌẽzó mvá tı̣̃lı̣́ rî câ trá, ûsû gólâ trá tólâ. ");
INSERT INTO avu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mãríyã drí gõzó mvá sı̣́sı̣́ íyíkâ tı̣̃lı̣́ ágó ró. Drílâ mvá ꞌdĩ gõzó ítá sĩ ngóló-ngóló gólâ rî lãlé õmã ꞌãꞌí drı̣̃ı̣̂. Gólĩyî rĩꞌá jó gólâ kạ́bı̣̃lı̣́kı̣̃ drí rĩzó ꞌá lâ rî ꞌá, tãlâ võ yûꞌdạ́wạ́ drílĩyî ậyı̣́zó jó ũmú kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kậyı̣̂ ꞌdĩ ꞌbá yî ꞌá rî, õjílã ãzâ ꞌbá yî kpá rĩꞌá ĩyî kạ́bı̣̃lı̣́kı̣̃ ĩyíkâ lôkíꞌá ngạ́cı̣̂ sĩ õmã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mãlãyíkã Ôvârí kâ ãzâ drí ânĩzó gólĩyî ngálâ. Gõꞌdá ı̣́nı̣́rı̣́kúwạ́ ãmbá ngạ́cı̣̂ kâ ꞌdĩ drí gõzó ꞌbãlé õzõ ı̣̃tú-ạ̃yı̣́ kâtí, kãngbê-kãngbê, lậgû-lậgû ró. Lôkí ꞌbá ꞌdĩ ꞌbá yî lârô ĩyî trá ũrı̣̃ bê. ");
INSERT INTO avu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mãlãyíkã ꞌdî drí tã âtázó drílĩyî kĩ nĩ rî, “Nĩ ꞌê ũrı̣̃ kô, tãlâ Ôvârí âjô mâ trá tã tãndí pẽlé ãnî drí. Tã tãndí má drí ânĩzó ĩꞌdí bê lâ nõ âꞌdô õjílã ndrĩ ꞌẽꞌá ãyĩkõ ró, ");
INSERT INTO avu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","tãlâ ãndrõ nô rî ꞌdíyî pã ꞌbá tíbê Ôvârí drí tã lâ âtálé kĩꞌá nĩ rî, áâꞌdô âjóꞌá lâ õjílã pãlé rî, útı̣̂ trá Bẽtẽlémẽ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nĩ âꞌdô ûsúꞌá lâ ꞌwãâ. Tã pạ̃tı̣́ı̣̃ ró rî, õzõ nĩ õcâ trá Bẽtẽlémẽ ꞌálâ rî, nĩ âꞌdô mvá õdé ûsúꞌá ógõ trá ítá sĩ ngóló-ngóló jó kạ́bı̣̃lı̣́kı̣̃ drí rĩzó rî ꞌá. Ândrê lâ lã trá õmã ꞌãꞌí drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kôrô ꞌdĩî rî vósĩ rî, mãlãyíkã Ôvârí kâ údúgúꞌbı̣́ drí rĩzó ĩyî ânĩlí ûrú lésĩ lôngó ngõ bê Ôvârí rî lûyı̣̂-lûyı̣̂ bê kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Õjílã ndrĩ ũlûyı̣̂ Ôvârí ûrú ꞌálâ rî, gólâ lẽ õjílã trá kôrô. Gólâ ꞌbã íyî pı̣̃pı̣̂sı̣́lı̣́ trá ậꞌdı̣̂-ậꞌdı̣̂ ró ãnî rú ndrĩ. Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mãlãyíkã údúgúꞌbı̣́ Ôvârí kâ ꞌdĩ ꞌbá yî drí gõzó ûrú ꞌálâ. Gõꞌdá lôkí ꞌbá ꞌdĩ ꞌbá yî drí tã ı̣̂ꞌbı̣̃zó kĩ nĩ rî, yĩ õnĩ drẽ Bẽtẽlémẽ ꞌálâ tã gólâ mãlãyíkã ꞌdî ꞌbá yî drí rĩꞌá pẽlâ ĩyî drí ꞌdĩ ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gólĩyî râ ĩyî trá ꞌwãâꞌwâ, nĩꞌá tã nã ndrẽlé, drílĩyî mvá õdé ꞌdĩ ûsúzó ândrê lâ bê, mvá õdé ꞌdĩ ólã trá vũdrı̣́ õmã ꞌãꞌí drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","20","Gõꞌdá nĩngá sĩ rî, drílĩyî nĩzó gõlé vólé lôngó Ôvârí rî lûyı̣̂-lûyı̣̂ kâ bê. Tã tíbê drílĩyî ârílí gõꞌdá kpá drílĩyî ndrẽzó lâ rĩꞌá kpá té õzõ mãlãyíkã ꞌdî ꞌbá yî drí âtálé drílĩyî rî tí. Õjílã gólĩyî tíbê tã kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá yî drí âtálé nõ ârí ꞌbá lâ ĩyî rî, gólĩyî trá ꞌdó ndrĩ lârõ-lârõ ró tã ꞌdî ârírĩ ꞌá. Gõꞌdá nĩngá sĩ rî, tákõ tã tíbê sı̣́sı̣́ Ôvârí drí rĩꞌá âtálâ Mãríyã drí mãlãyíkã íyíkâ sĩ rî âgâ trá ndrĩ gólâ ꞌá. Drílâ rĩzó tı̣́tı̣́ dĩyí rĩꞌá tã ꞌdî ĩtõ lâ ı̣̂sũlı̣́. ");
INSERT INTO avu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kậyı̣̂ njı̣̂-drı̣̃-lâ-rı̣̃ vósĩ rî, óꞌbê mvá ꞌdĩ trá bãsã ꞌá, gõꞌdá átá lâ zı̣̂ rú lâ trá Yésũ, té õzõ Gãbẽrélẽ drí âtálé ândrê lâ Mãríyã drí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Mvá ꞌdĩ tı̣̃tı̣̃ lâ vósĩ rî, Mãríyã drí ꞌẽzó lâ kậyı̣̂ nyâꞌdî-rı̣̃, drílĩyî gõzó ngãlé nĩlí Yõsépã bê Yẽrõsãlémã ꞌálâ. Gólĩyî câ bê rî, nĩ ĩyî trá fĩlí jó ạ́ngı̣́ Ôvârí kâ rî ꞌálâ mvá ꞌdĩ âꞌdálé Ôvârí drí kpá ngá fẽfẽ ĩyíkâ fẽlé Ôvârí drí. Ngá fẽfẽ drílĩyî fẽlé ꞌdĩ rĩꞌá ãmámõ rı̣̃, âꞌdô tã ꞌbãꞌbã Ôvârí drí ꞌbãlé Músạ̃ sĩ rî vó ró, tãlâ ꞌdĩî rĩꞌá mvá sı̣́sı̣́ ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ꞌDĩî vósĩ rî, ãgô ãzâ bê rĩꞌá Yẽrõsãlémã ꞌá tólâ, rú lâ rĩꞌá Sĩmónã. Gólâ rĩꞌá ãgô tãndí ꞌî. Gólâ ꞌê lãꞌbí ꞌdĩ ꞌbá yî trá ndrĩ bê rî, gólâ drí tã gólâ Líndrí Tãndí Ôvârí kâ drí rĩꞌá âtálâ drílâ rî rõzó. ");
INSERT INTO avu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Líndrí Tãndí Ôvârí kâ ꞌbã tã trá gólâ drí kĩ, gólâ õdrãá kô té gólâ drí ꞌdíyî pã ꞌbá ndrẽzó zãlô. ");
INSERT INTO avu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Líndrí Tãndí Ôvârí kâ drí tã âtázó drílâ õnĩ ró bê jó ạ́ngı̣́ Ôvârí kâ nã ꞌá tólâ. Gõꞌdá ꞌdĩî rî kpá trá té kậyı̣̂ gólâ Mãríyã yî drí nĩzó ágó lâ Yõsépã bê fĩlí jó ạ́ngı̣́ ꞌdĩ ꞌálâ ngá fẽfẽ ĩyíkâ fẽlé Ôvârí drí rî ĩꞌdî. Sĩmónã drí drı̣̃ ꞌbẽzó gólĩyí bê jó ạ́ngı̣́ nã ꞌá tólâ. ");
INSERT INTO avu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Gõꞌdá gólâ ndrê mvá nã bê rî, nı̣̃ trá, yí trõ mvá ꞌdĩ trá yí rú ândré lâ rú sĩ. Gólâ kĩ, “ꞌDĩî rî ꞌdíyî pã ꞌbá Ôvârí drí tã lâ âtálé rî ĩꞌdî.” Gõꞌdá drílâ gõzó Ôvârí rî lûyı̣́lı̣́ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Kúmú ámákâ Ôvârí, má ꞌê ãwô-ĩtí ãmbá ní drí, tãlâ ní âjô mvá ꞌdĩ ãngó ꞌá nõ, ꞌdĩî má âꞌdô gõꞌdá drãꞌá, má ndrê gólâ trá cú ámâ lı̣̃fı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mvá ꞌdĩ ní ꞌbã trá, kó ạ̃kû ró õrĩ nõ ꞌbá yî pãlé ndrĩ ãngó ꞌá nõngá. ");
INSERT INTO avu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mvá, nĩ âꞌdô ꞌbãꞌá õzõ lạ̃sı̣́ kõkõ kâtí Ôvârí rî ífífí âꞌdálé õjílã ãngó ꞌá nõ ꞌbá yî drí ndrĩ. Gólâ ĩꞌdî ãlô õjílã Ĩsĩrãꞌélẽ kâ ꞌásĩ gólâ ꞌé ꞌbá õjílã ndrĩ drí lûyı̣́lı̣́ rî. Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ꞌDĩî vósĩ rî, Mãríyã yî Yõsépã bê trá ĩyî lârõ-lârõ ró úlı̣́ Sĩmónã drí âtálé ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Sĩmónã drí gõzó õrẽ fẽlé gólĩyî drí, gõꞌdá Sĩmónã drí tã âtázó Mãríyã drí kĩ nĩ rî, “Ní ârî drẽ, õjílã ãzâ ꞌbá yî âꞌdô ĩyî âtálâ kĩ, ãwô, tã pạ̃tı̣́ı̣̃ ró, Ôvârí âjô gólâ nĩ ãngó ꞌá nõngá, gõꞌdá õjílã ꞌdî ꞌbá yî, Ôvârí âꞌdô gólĩyî pãꞌá. Gõꞌdá õjílã ãzâ ꞌbá yî âꞌdô ĩyî âtálâ kĩ, ꞌéꞌẽ, Ôvârí âjó gólâ nĩ kô, gõꞌdá õjílã gólĩyî ĩtí ꞌdĩ ꞌbá yî Ôvârí âꞌdô gólĩyî îzãꞌá. Óõ Mãríyã, nî gólâ rî ândrê, ní âꞌdô ꞌbãꞌá ĩzã kõkõ bê rõô lâŋõ ꞌẽ ꞌbá gólâ rî ꞌẽlé rî sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Gõꞌdá kôrô ꞌdĩî rî vósĩ rî, õkó ãzâ drí kpá âfízó jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌá, rú lâ Ánã, Fạ̃nũwélẽ rî mvá ꞌî, ꞌbạ̃súrú Ãsérã yí kâ. Gólâ tã ậngũ ꞌbá ꞌî. Gólâ rĩꞌá õkó ãdrá ꞌî, ndrô lâ trá nyâꞌdî-sû-drı̣̃-lâ-sû. Ágó lâ gî gólâ bê rî, ꞌê ĩyî trá ndrô njı̣̂-drı̣̃-lâ-rı̣̃, ágó lâ drí gõzó drãlé. Gólâ rî gõꞌdá trá ạ̃yı̣́zı̣́ ró ágó lâ rî vólé drı̣̃ ꞌásĩ zãâ ágó ãkó. Gólâ rĩꞌá kậyı̣̂ vósĩ cé jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌálâ rãtáã ꞌẽꞌá Ôvârí drí, gõꞌdá rí kậyı̣̂ ãlô tã ı̣̂sũlı̣́ nõtí kĩꞌá nĩ rî, ngá nyãnyã ꞌẽzó yí drí rî kô, cé rĩzó rãtáã ꞌẽlé ĩꞌdî Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Gõꞌdá gólâ ndrê mvá ꞌdĩ bê rî, gólâ nı̣̃ trá kĩ nĩ rî, ꞌdĩî rî ꞌdíyî pã ꞌbá ꞌî Ôvârí ngá lésĩ. Gólâ lûyı̣̂ Ôvârí trá, gõꞌdá lânjî tã lâ trá gólĩyî rĩ ꞌbá ꞌdíyî pã ꞌbá tẽlé Yẽrõsãlémã ꞌálâ ânĩlí Ôvârí ngá lésĩ ãngó ꞌá nõngá õjílã íyíkâ pãlé rî yî drí. ");
INSERT INTO avu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gõꞌdá nĩngá sĩ, Yõsépã yî Mãríyã bê Yésũ rî õdẽ yí bê nĩ ĩyî trá rĩlí Nãzãrétã ꞌá ꞌbạ̃drı̣̃ zı̣̃lı̣́ Gãlĩláyã rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mvá Yésũ ꞌdĩ mbâ trá tólâ mbârâkã bê. Gólâ trá tã nı̣̃nı̣̃ bê ãmbá. Ôvârí pâ gólâ trá. ");
INSERT INTO avu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ndrô vósĩ cé, gólâ rî átá yî ândrê lâ bê rî ĩyî trá nĩlí Yẽrõsãlémã ꞌálâ kãrámã lậvũ-lậvũ kôrô kâ ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Gõꞌdá gólâ õtírĩ ꞌbãâ ndrô bê mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî gólâ nĩ trá lậmúlı̣́ íyî átá yî íyî ândrê bê Yẽrõsãlémã ꞌálâ kãrámã ꞌdî ꞌẽlé. Áró lâ yî dũû nĩ ĩyî trá ꞌdó gólĩyí bê. ");
INSERT INTO avu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kãrámã ꞌdî vósĩ rî, Yõsépã yî Mãríyã bê ngâ ĩyî trá gõlé Nãzãrétã ꞌálâ, gõꞌdá mvá Yésũ ꞌdĩ ꞌbê íyîngá võ trá ãkpãkãꞌdã Yẽrõsãlémã ꞌálâ cú ĩtí, ândré lâ yî átá bê drí nı̣̃ ãkó. ");
INSERT INTO avu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Átá lâ yî nı̣̃ı̣́ ĩyî ândrê lâ bê kĩꞌá nĩ rî, gólâ ãꞌdô ãkpã vólé rî kô. Gólĩyî kĩ ĩyíkâ rî, gólâ õlậvũ trá áró lâ ãzâ ꞌbá yí bê sı̣́sı̣́ ꞌálâ. Kậyı̣̂ drílĩyî ngãzó ĩyîngá nĩlí rî sĩ, lạ̃njạ́túlı̣́ bê, ı̣̃tú drí fĩrĩ ꞌá, Yõsépã Mãríyã bê gõꞌdá drílĩyî rĩzó gólâ rî ndãlé. ");
INSERT INTO avu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Gõꞌdá gólĩyî ndã gólâ trá kpı̣̃ı̣̂, ûsú ĩyî gólâ kô ãzí-ãzí lâ yî lãfálé sĩ. Gõꞌdá gólĩyî drí gõzó vólé Yẽrõsãlémã ꞌálâ gólâ rî ndãlé kpá óꞌdí. ");
INSERT INTO avu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ndã ĩyî gólâ trá kậyı̣̂ rı̣̃ sĩ, drílĩyî gõzó nĩlí gólâ rî ûsúlı̣́ jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌálâ, íyîngá rĩꞌá lãꞌbí îmbá ꞌbá rî ꞌbá yî lãfálé, rĩꞌá úlı̣́ gólĩyíkâ âríꞌá, kpá rĩꞌá gólĩyî îjíꞌá tã îjî-îjî ãzâ ꞌbá yî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Õjílã rĩ ꞌbá ĩyî tã gólâ drí âtálé rî ꞌbá yî ârílí rî, tı̣̂ lâ ĩyî ậꞌdı̣̂ trá tã gólâ drí rĩꞌá âtálâ rî ꞌá kpá tã îjî gólâkâ rî ꞌá, tãlâ gólâ nı̣̃ tã trá kôrô. ");
INSERT INTO avu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Gõꞌdá ândrê lâ Mãríyã âtâ tã trá gólâ drí nõtí kĩ nĩ rî, “Ãmâ mvá, ní ꞌê ãmâ drí nõ ãꞌdô tã ꞌî yã? Ãmâ ánî átá bê gõꞌdá trá ũrı̣̃ ró, tãlâ mã ndã nî trá kpı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Gõꞌdá gólâ lôgõ úlı̣́ võ trá gólĩyî drí nõtí, “Nĩ rî ámâ ndãlé ãmbá võ ãzâ ꞌbá yî ꞌásĩ nõ ãꞌdô tãsĩ yã? Nĩ nı̣̃ı̣́ kô kĩꞌá nĩ rî, bê má drí ꞌẽꞌá rĩlí jó ámâ átá Ôvârí kâ rî ꞌá tã gólâkâ rî ꞌẽlé yã?” ");
INSERT INTO avu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mãríyã yî Yõsépã bê nı̣̃ı̣́ ĩyî tã ífí gólâ drí âtálé ꞌdĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Drílĩyî gõzó ândrê lâ yí bê átá lâ yí bê ꞌdũwạ̃ Nãzãrétã ꞌálâ. Gólâ rô íyî átá yî trá ândrê lâ bê tã ãmbá ꞌdĩ ꞌbá yî ꞌásĩ ndrĩ. Ândrê lâ ı̣̂sũ tã gólâ kó rû ꞌẽ ꞌbá gólâ rî tı̣̃rı̣̃ ꞌá rî trá gõꞌdá âgâ trá ꞌá lâ, rî trá tã ı̣̂sũlı̣́ ãmbá tã lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Gólâ mbâ trá mbârâkã bê, gólâ îcî íyî lı̣̃fı̣́ trá tã nı̣̃nı̣̃ ãzâ ꞌbá yî sĩ. Ôvârí trá ãyĩkõ ró ãmbá gólâ bê. Gõꞌdá kpá õjílã gólâ rî nı̣̃ ꞌbá rî yî, gólĩyî kpá trá ãyĩkõ ró gólâ bê. ");
INSERT INTO avu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Gõꞌdá Yésũ õtírĩ cãâ ndrô nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́ rî, Tĩbérĩyã ĩꞌdî kúmú ạ́ngı̣́ ꞌî kúmú ãzí drı̣̃ı̣̂ sĩ ndrĩ ꞌbãlé Ạ̃gúsũtũ rî võ ꞌá. Tĩbérĩyã ꞌê trá kũmũ ꞌá ndrô mûdrı̣́-drı̣̃-lâ-ngâ-njı̣̂. Tĩbérĩyã ꞌbã kúmú Pĩlátõ trá Yũdạ́yạ̃ lé ꞌbá yî drı̣̃lı̣́, gõꞌdá kúmú Ẽródẽ Ãnĩtípã trá Gãlĩláyã lé ꞌbá yî drı̣̃lı̣́, gõꞌdá kúmú Fílĩpõ íyíkâ trá Ị̃tũrı̣́yạ̃ lé ꞌbá drı̣̃lı̣́ gõꞌdá kpá Trãkónĩ bê, gõꞌdá kúmú Lĩsánĩ íyíkâ Ãbĩlínĩ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kãyífã ĩꞌdî drı̣̃-ꞌbá drı̣̃-ꞌbá Yúdạ̃ yí kâ rî ꞌbá yí kâ ꞌî, gólâ rî ạ́ꞌbı̣́ Ánãsĩ bê. Kậyı̣̂ ꞌdĩ ꞌá rî, Ôvârí drí tã âtázó Yõwánĩ drí kĩ nĩ rî, “Ngbãângbânõ rî, ní îtónã õjílã ꞌbãlé tã pẽpẽ sĩ njãâ lạ́tı̣̂ ꞌá rĩlí Ôvârí rî drı̣̃ tẽlé lậgúlı̣́.” Yõwánĩ rĩꞌá õmã ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gõꞌdá Yõwánĩ drí ngãzó nĩlí lậmú bê tã ꞌbãlé õjílã rĩ ꞌbá ãnyî áyágá Jõrõdénĩ lạ̃gạ́tı̣́ rî yî drí. Tã gólâ drí rĩꞌá pẽlâ rî ĩꞌdî rĩꞌá nõtí, “Nĩ âdĩ drı̣̃ tã õnjí ꞌásĩ Ôvârí rî rõlé. Gõꞌdá nĩ ânĩ má drí lũmvû dãzó ãnî drı̣̃ı̣̂ bãbãtízĩ ró áyágá Jõrõdénĩ ꞌdĩ ꞌá tã âꞌdâ-âꞌdâ ró kĩꞌá nĩ rî, nĩ âjâ drı̣̃ trá tã õnjí ãníkâ ꞌásĩ. Nĩ õꞌê tã ꞌdî rî ĩꞌdî rî, Ôvârí âꞌdô ãnî âyéꞌá tã õnjí ãníkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Ãkpã ạ̃kû ró rî, Ôvârí ꞌbã tã ậngũ ꞌbá ãzâ trá rú lâ Ĩsáyã tã pẽlé Yõwánĩ rî tãsĩ nõtí, “Ãgô ãzâ âꞌdô rĩꞌá ôtrélé õmã ꞌá kĩ nĩ rî, ‘Nĩ êdê lạ́tı̣̂ mbı̣̂ Kúmú ãníkâ ꞌdíyî pã ꞌbá rî drí âcázó lậmúlı̣́ drı̣̃ lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ãꞌdô ĩtí rî, õrĩ ndrĩ ꞌbạ̃drı̣̃ ãmbá nõ ꞌbá yî ꞌásĩ âꞌdô ĩyî nı̣̃ꞌá lâ tõ kĩ nĩ rî, nõô ãgô gólâ Ôvârí drí ꞌẽꞌá âjólâ rî ĩꞌdî.’ ” ");
INSERT INTO avu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nĩngá sĩ rî, õjílã ãmbá rî trá ânĩlí Yõwánĩ ngálâ gólâ õdã ró lũmvû bê ĩyî drı̣̃ı̣̂ bãbãtízĩ ró. Õꞌbí ãmbá ꞌdĩ ꞌbá yî lãfálé sĩ, õjílã ãzâ ꞌbá yî lẽ ĩyî tã-drı̣̃ kpá trá lũmvû dãzó ĩyî drı̣̃ı̣̂. Gõꞌdá gólĩyî gã ĩyî dó drı̣̃ âjálé tã õnjí ĩyíkâ ꞌásĩ. Gõꞌdá Yõwánĩ drí tã âtázó gólĩyî drí kãkãrãkã sĩ kĩ nĩ rî, “Ãnî âꞌdô rĩꞌá õzõ ı̣̃nı̣̃ gólĩyî rã ꞌbá lạ̃sı̣́ ngbı̣̃lı̣̃rı̣̃ ágálé sĩ rî kâtí. Nĩ ı̣̂sũ ãníkâ bê rî, nĩ âꞌdô ꞌẽꞌá ngá pãlé õmbã Ôvârí kâ ꞌásĩ cé bãbãtízĩ sĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Õzõ nĩ õlẽ trá ngá pãlé rî, ꞌdõvó nĩ âjâ drı̣̃ vólé tã õnjí ãníkâ ꞌásĩ. Ĩtí rî, tã ꞌẽꞌẽ tãndí ãníkâ âꞌdô âꞌdóꞌá õzõ lõꞌwâ tãndí kâtí, tãlâ ãâꞌdâ ró bê kĩ, pạ̃tı̣́ı̣̃ nĩ âjâ drı̣̃ trá vólé tã õnjí ãníkâ ꞌásĩ. Gõꞌdá nĩ âyê tã ı̣̂sũ ãníkâ kĩꞌá nĩ rî, nĩ ãâꞌdô ꞌẽꞌá ãnî nyãányâ pãlé lâŋõ Ôvârí drí ꞌẽꞌá fẽlâ ãnî drí rî ꞌásĩ, tãlâ ãnî rĩꞌá Ãbãrãyámã rî ózõwá yî ĩꞌdî rî. Tã ꞌdî îcá kô ãnî pãlé. Nĩ ârî drẽ, Ôvârí mbârâkã bê âꞌdô kúnı̣́ mvá nõ ꞌbá yî ôjáꞌá Ãbãrãyámã rî ózõwá yî ró ãnî võ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ãnî õzõ fê ı̣̂ꞌdı̣́lı̣́ rî kâtí ı̣̃nyạ́kú nõ drı̣̃ı̣̂. Ôvârí ꞌbã ôlówá trá njãâ fê gólĩyî ꞌwã ꞌbá kô rî yî âgãzó vũdrı̣́. Ôvârí âꞌdô fê gólâ ꞌwã ꞌbá kô rî zãꞌá õzõ tõtõ kâtí lạ̃sı̣́ gólâ rĩ ꞌbá vẽlé ạ̃dũkũ ãkó rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gõꞌdá õjílã gólĩyî tã gólâ Yõwánĩ drí âtálé rî ârí ꞌbá rî, âtâ ĩyî tã trá kĩ nĩ rî, “Mã âꞌdô âꞌdáꞌá lâ ángô tí yã kĩꞌá nĩ rî, áâyê ãmâ trá tã õnjí ãmákâ tãsĩ rî, mã rî gõꞌdá trá Ôvârí rî rõlé ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yõwánĩ kĩ, “Nĩ ꞌê tã tãndí ĩꞌdî õjílã drí ndrĩ lãꞌbí ãníkâ rî lậvũlı̣́. Õzõ nĩ ãꞌdô ítá bê rı̣̃ rî, nĩ fẽ ãlô rî õjílã gólâ ítá ãkó rî drí. Õzõ nĩ ãꞌdô ngá-ĩyínyâ bê rî, nĩ câ lãfálâ õjílã gólâ ĩzã lâ bê rî yî drí.” ");
INSERT INTO avu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gõꞌdá bélé-bélé ûꞌdú ꞌbá ãzâ ꞌbá yî kpá rĩꞌá tólâ, gólĩyî lẽ kpá Yõwánĩ ĩîbábátízã ró ĩyî bê tã õnjí ĩyíkâ tãsĩ. Bélé-bélé ûꞌdú ꞌbá ꞌdĩ ꞌbá yî âtâ ĩyî trá Yõwánĩ drí kĩ nĩ rî, “Ãmâ bélé-bélé ûꞌdú ꞌbá nõ ꞌbá yî, mã âꞌdô ãmákâ kó mbı̣̂mbı̣̂ lâ ãꞌdô ꞌẽꞌá ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yõwánĩ kĩ, “Nĩ lôpê lãfâ bélé-bélé kâ ꞌdĩ kô sı̣́sı̣́ ꞌálâ tã ãníkâ rî tí.” ");
INSERT INTO avu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Gõꞌdá ạ̃jú ꞌbũ ꞌbá ãzâ ꞌbá yî kpá rĩꞌá ĩtí, gólĩyî îjî Yõwánĩ kpá trá kĩ nĩ rî, “Ngã gõꞌdá ãmâ tãsĩ rî yã?” Yõwánĩ kĩ, “Nĩ ꞌbã õjílã õrî ãnî lı̣̃fı̣́ gĩlí, nĩ âyê ró ĩyí bê tã ạ́ngı̣́ ĩyî drí ꞌẽlé rî tãsĩ kô. Nĩ ꞌê ícícíyá õjílã ãzí rú õnjõ sĩ kô. Lãfâ gólâ rĩꞌá fẽlâ ãnî drí rî, nĩ mâ kô.” ");
INSERT INTO avu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ꞌDĩî rî kậyı̣̂ tíbê ãyĩkõ drí ꞌbạ̃súrú Yúdạ̃ yí kâ rî ꞌbá yî cĩzó rî ĩꞌdî. Gólĩyî ı̣̂sũ ĩyíkâ bê rî, Yõwánĩ âꞌdô ꞌdíyî pã ꞌbá ĩyî drí rĩꞌá tẽlâ Ôvârí ngá lésĩ rî, âꞌdô ꞌẽꞌá âjólâ õjílã pãlé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Gõꞌdá Yõwánĩ drí tã îyázó gólĩyî drí kĩ nĩ rî, “Má âꞌdó kô ꞌdíyî pã ꞌbá gólâ ꞌẽ ꞌbá õjílã îbábátízãlé lạ̃sı̣́ sĩ gõꞌdá kpá Líndrí Tãndí Ôvârí kâ sĩ rî ĩꞌdî. Mâ ámákâ cé ãnî îbábátízãlé lũmvû sĩ. Gõꞌdá ãgô ãzâ kpá rĩꞌá ânĩꞌá má vó. Gólâ ĩꞌdî tíbê ãnî drí rĩꞌá tẽlâ ꞌẽ ꞌbá âcálé ꞌdíyî pã ꞌbá ró rî, tã gólâkâ rî ĩꞌdî nõtí, õjílã tã gólâkâ lẽ ꞌbá rî, gólâ âꞌdô Líndrí Tãndí Ôvârí kâ fẽꞌá drílâ. Gõꞌdá õjílã tã gólâkâ lẽ ꞌbá kô rî, áâꞌdô îzãꞌá lâ lạ̃sı̣́ sĩ. Gólâ mbârâkã bê gạ̃rạ̃ má drı̣̃ı̣̂ sĩ. Má îcá kô káꞌbókã gólâkâ ângílí pá lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Gólâ íyíkâ rĩꞌá õzõ õjílã ạ̃drúgú cã ꞌbá kâtí, gólâ âꞌdô ạ̃drúgú ífí tãndí rî êléꞌá dãlé yí drí ꞌbãlé ẽró ꞌálâ rî ĩꞌdî, gõꞌdá kúrũmû lâ ꞌdĩ dãzó íyíkâ tõtõ ró õmã ꞌálâ zãlé vólé lạ̃sı̣́ sĩ ạ̃dũkũ ãkó.” ");
INSERT INTO avu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ꞌDĩî rî tã gólâ Yõwánĩ drí rĩꞌá pẽlâ ândálé kárá lãjóꞌbá Ôvârí kâ ró õjílã drí rî ĩꞌdî, õjílã õꞌbã ró lı̣̃fı̣́ bê Ôvârí drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tã ãzâ Yõwánĩ drí ꞌẽlé rî ĩꞌdî nõ. Gólâ nĩ trá kúmú Ẽródẽ Ãnĩtípã ngálâ, sõ drı̣́-mbílí trá gólâ lı̣̃fı̣́ tã õnjí Ẽródẽ drí ꞌẽlé rî ꞌá, tãlâ Ẽródẽ pâ ậdrúpı̣̃ lâ rî õkó rú bê Ẽrõdíyã rî trá gólâ drı̣́gạ́ sĩ trõlé yí drí õkó ró. ");
INSERT INTO avu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Gõꞌdá Ẽródẽ ârílí bê tã Yõwánĩ drí âtálé ĩtí ꞌdĩ rî, gólâ ꞌbã Yõwánĩ trá gạ̃nı̣́mạ̃ ꞌá. ꞌDĩî rî tã õnjí ãzâ gólâ Ẽródẽ drí ꞌẽlé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ãkpãkãꞌdã Ẽródẽ rú drẽ Yõwánĩ ꞌbãlé gạ̃nı̣́mạ̃ ꞌá kô rî, Yõwánĩ dã lũmvû trá õjílã drı̣̃ı̣̂ bãbãtízĩ ró ãmbá áyágá Jõrõdénĩ kâ ꞌálâ. Gólâ ꞌê bãbãtízĩ kpá trá Yésũ drí zãlô Jõrõdénĩ ꞌálâ. Gõꞌdá gólâ ndẽ bãbãtízĩ ꞌẽꞌẽ bê rî, Yésũ drí rĩzó rãtáã ꞌẽlé drẽ ãkpãkãꞌdã lı̣̃mvû ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kôrô ꞌbũû drí rû njı̣̃zó, Líndrí Tãndí Ôvârí kâ drí âꞌdézó Yésũ drı̣̃ı̣̂ õzõ ạ̃túꞌbú kâtí. Úlı̣́ drí ậꞌúzó ꞌbũû lésĩ Yésũ drí kĩ nĩ rî, “Nî ámâ mvá ífífí rî ĩꞌdî má drí lẽlé rõô rî. Ánî tã sû trá má rú rõô.” ");
INSERT INTO avu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Yésũ trá ndrô bê nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́, gólâ drí ngá ꞌẽꞌẽ îtõzó ãngó nõ ꞌá nõngá. Õjílã ndrĩ ı̣̂sũ ĩyíkâ bê rî, gólâ âꞌdô Yõsépã rî mvá ꞌî. Ạ̃kû ró rî Ôvârí ꞌbã Ádãmã trá. Ádãmã tı̣̂ mvá trá rú lâ Sétẽ. Sétẽ tı̣̂ mvá trá rú lâ Ẽnósã. Ẽnósã tı̣̂ mvá trá rú lâ Kẽnánã. Kẽnánã tı̣̂ mvá trá rú lâ Mãjãlélẽ. Mãjãlélẽ tı̣̂ mvá trá rú lâ Yãrádã. Yãrádã tı̣̂ mvá trá rú lâ Ẽnókã. Ẽnókã tı̣̂ mvá trá rú lâ Mẽtũsélạ̃. Mẽtũsélạ̃ tı̣̂ mvá trá rú lâ Lẽmékẽ. Lẽmékẽ tı̣̂ mvá trá rú lâ Nówã. Nówã tı̣̂ mvá trá rú lâ Sémẽ. Sémẽ tı̣̂ mvá trá rú lâ Ãrãpãsádã. Ãrãpãsádã tı̣̂ mvá trá rú lâ Kãnánã. Kãnánã tı̣̂ mvá trá rú lâ Sélã. Sélã tı̣̂ mvá trá rú lâ Ẽbérẽ. Ẽbérẽ tı̣̂ mvá trá rú lâ Pẽlégẽ. Pẽlégẽ tı̣̂ mvá trá rú lâ Rúũ. Rúũ tı̣̂ mvá trá rú lâ Sẽrúgı̣̃. Sẽrúgı̣̃ tı̣̂ mvá trá rú lâ Nãhórã. Nãhórã tı̣̂ mvá trá rú lâ Térã. Térã tı̣̂ mvá trá rú lâ Ãbãrãyámã. Ãbãrãyámã tı̣̂ mvá trá rú lâ Ĩsákã. Ĩsákã tı̣̂ mvá trá rú lâ Yãkóbã. Yãkóbã tı̣̂ mvá trá rú lâ Yúdạ̃. Yúdạ̃ tı̣̂ mvá trá rú lâ Pẽrézẽ. Pẽrézẽ tı̣̂ mvá trá rú lâ Ẽzẽrónẽ. Ẽzẽrónẽ tı̣̂ mvá trá rú lâ Ãrínĩ. Ãrínĩ tı̣̂ mvá trá rú lâ Ãdãmínõ. Ãdãmínõ tı̣̂ mvá trá rú lâ Ãmĩnãdábã. Ãmĩnãdábã tı̣̂ mvá trá rú lâ Nãsónõ. Nãsónõ tı̣̂ mvá trá rú lâ Sãlámõ. Sãlámõ tı̣̂ mvá trá rú lâ Bõꞌázã. Bõꞌázã tı̣̂ mvá trá rú lâ Óbẽdẽ. Óbẽdẽ tı̣̂ mvá trá rú lâ Yésẽ. Yésẽ tı̣̂ mvá trá rú lâ Dạ̃wúdı̣̃. Dạ̃wúdı̣̃ tı̣̂ mvá trá rú lâ Nãtánã. Nãtánã tı̣̂ mvá trá rú lâ Mãtátã. Mãtátã tı̣̂ mvá trá rú lâ Ménã. Ménã tı̣̂ mvá trá rú lâ Mẽlíyã. Mẽlíyã tı̣̂ mvá trá rú lâ Ẽlĩyãkímõ. Ẽlĩyãkímõ tı̣̂ mvá trá rú lâ Yõnámõ. Yõnámõ tı̣̂ mvá trá rú lâ Yõsépã. Yõsépã tı̣̂ mvá trá rú lâ Yúdạ̃. Yúdạ̃ tı̣̂ mvá trá rú lâ Sĩmónã. Sĩmónã tı̣̂ mvá trá rú lâ Lạ́vı̣̃. Lạ́vı̣̃ tı̣̂ mvá trá rú lâ Mãtátã. Mãtátã tı̣̂ mvá trá rú lâ Yõrímõ. Yõrímõ tı̣̂ mvá trá rú lâ Ẽlĩyézẽ. Ẽlĩyézẽ tı̣̂ mvá trá rú lâ Yásõwã. Yásõwã tı̣̂ mvá trá rú lâ Érẽ. Érẽ tı̣̂ mvá trá rú lâ Ẽlẽmãdémõ. Ẽlẽmãdémõ tı̣̂ mvá trá rú lâ Kõsámõ. Kõsámõ tı̣̂ mvá trá rú lâ Ádĩ. Ádĩ tı̣̂ mvá trá rú lâ Mẽlékẽ. Mẽlékẽ tı̣̂ mvá trá rú lâ Nérĩ. Nérĩ tı̣̂ mvá trá rú lâ Sĩyátĩ. Sĩyátĩ tı̣̂ mvá trá rú lâ Zãrãbãbálã. Zãrãbãbálã tı̣̂ mvá trá rú lâ Résã. Résã tı̣̂ mvá trá rú lâ Yõánã. Yõánã tı̣̂ mvá trá rú lâ Yódã. Yódã tı̣̂ mvá trá rú lâ Yõsékẽ. Yõsékẽ tı̣̂ mvá trá rú lâ Sẽménẽ. Sẽménẽ tı̣̂ mvá trá rú lâ Mãtãtíyã. Mãtãtíyã tı̣̂ mvá trá rú lâ Mátã. Mátã tı̣̂ mvá trá rú lâ Nágã. Nágã tı̣̂ mvá trá rú lâ Ẽsílĩ. Ẽsílĩ tı̣̂ mvá trá rú lâ Nạ́hũmạ̃. Nạ́hũmạ̃ tı̣̂ mvá trá rú lâ Ãmósẽ. Ãmósẽ tı̣̂ mvá trá rú lâ Mãtãtíyã. Mãtãtíyã tı̣̂ mvá trá rú lâ Yõsépã. Yõsépã tı̣̂ mvá trá rú lâ Jãnáyĩ. Jãnáyĩ tı̣̂ mvá trá rú lâ Mẽlékẽ. Mẽlékẽ tı̣̂ mvá trá rú lâ Lạ́vı̣̃. Lạ́vı̣̃ tı̣̂ mvá trá rú lâ Mãtátã. Mãtátã tı̣̂ mvá trá rú lâ Élĩ. Élĩ tı̣̂ mvá trá rú lâ Yõsépã. Gõꞌdá Yõsépã îmbâ Yésũ trá õzõ íyî mvá tı̣̃lı̣́ nĩ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gõꞌdá nĩngá sĩ rî, Yésũ trá mbârâkã Líndrí Tãndí Ôvârí kâ rî kâ bê yí ꞌá rõô. Gólâ ngâ trá ꞌbạ̃drı̣̃ áyágá Jõrõdénĩ kâ ꞌdĩ ꞌásĩ nĩlí sı̣́sı̣́ ꞌálâ rî, gõꞌdá Líndrí Tãndí Ôvârí kâ drí gólâ rî âjízó nĩlí lậmúlı̣́ õmã ꞌálâ. Tólâ rî, Sãtánã drí rĩzó gólâ rî ûjũlı̣́ kậyı̣̂ nyâꞌdî-rı̣̃ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kậyı̣̂ nyâꞌdî-rı̣̃ ꞌdî ꞌbá yî ꞌá rî, gólâ cú ĩtí ngá nyãnyã ãkó, gólâ trá lõfó ró tákányĩ. ");
INSERT INTO avu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gõꞌdá Sãtánã drí tã âtázó gólâ drí kĩ nĩ rî, “Ní ãꞌdô fí pạ̃tı̣́ı̣̃ Ôvârí rî mvá ꞌî rî, ní jâ kúnı̣́ mvá nõ ngá nyãnyã ró ní drí nyãlé.” ");
INSERT INTO avu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Gõꞌdá Yésũ kĩ, “ꞌÉꞌẽ, tã îgĩ Ôvârí kâ ꞌá áâtâ trá nõtí, ‘Õjílã rí rĩlí cé ngá nyãnyã sĩ kô. Ngá ãzâ lậvũ ꞌbá ngá nyãnyã drı̣̃ı̣̂ sĩ kôrô rî kpá bê, tákõ ĩꞌdî rĩꞌá úlı̣́ Ôvârí kâ.’ ” ");
INSERT INTO avu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sãtánã drí kpá gólâ rî îngázó ûrû ꞌwãâ ꞌbạ̃drı̣̃ ãmbá nõ ꞌbá yî âꞌdázó ndrĩ drílâ. ");
INSERT INTO avu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sãtánã drí gõzó tã âtálé gólâ drí kĩ nĩ rî, “Mâ ĩꞌdî ngá ndrĩ ãngó nõ ꞌá lı̣́pı̣̂ lâ ꞌî. Õzõ ní õlẽ trá rî, má âꞌdô kpá drı̣́-ãcê ámákâ rî fẽꞌá ní drí gõꞌdá kpá ngá tãndí ãmbá ãngó nõ kâ rî ꞌbá yî fẽꞌá ní drí, tã ãzâ ꞌbá yî ní drí lẽlé ꞌẽlé rî ꞌẽzó ĩꞌdí bê lâ. ");
INSERT INTO avu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Õzõ ní ũtı̣̃ ꞌãꞌî trá vũdrı̣́ ámâ ı̣̂njı̣̃zó rî, má âꞌdô kpá mbârâkã fẽꞌá ndrĩ ní drí.” ");
INSERT INTO avu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yésũ kĩ, “Íîgĩ trá búkũ Ôvârí kâ ꞌá kĩ, ‘Kúmú Ôvârí ĩꞌdî cé Ôvârí pạ̃tı̣́ı̣̃ ãníkâ ãnî drí ı̣̂njı̣̃lı̣́ rî ĩꞌdî, gõꞌdá nĩ ı̣̂ꞌbũ rû cé gólâ drí.’ ” ");
INSERT INTO avu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Gõꞌdá Sãtánã drí gólâ rî âjízó ꞌwãâ Yẽrõsãlémã ꞌálâ. Gõꞌdá Sãtánã drí gólâ rî ꞌbãzó jó ạ́ngı̣́ Ôvârí kâ rî ãpírĩ lâ ꞌálâ. Sãtánã drí tã âtázó gólâ drí kĩ nĩ rî, “Õzõ ní ãꞌdô fí Ôvârí rî mvá ĩꞌdî rî, ní âwã drẽ âꞌdélé vũdrı̣́ ãâꞌdâ ró tã bê kĩ nĩ rî, Ôvârí lôkî nî trá rõô, ");
INSERT INTO avu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tãlâ íîgĩ trá búkũ Ôvârí kâ ꞌá kĩ nĩ rî, ‘Ôvârí ꞌbã tã trá mãlãyíkã íyíkâ yî drí ánî tãsĩ rĩzó ánî vó ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Gólĩyî âꞌdô ánî lôkóꞌá ĩyî drı̣́gạ́, tãlâ ngá ãzãkã õzó ánî rúꞌbạ́ dõô kô, gbõ lé ánî pá mvá õzó kpá rû sı̣̃ı̣̂ kúnı̣́ mvá rú kô.’ ” ");
INSERT INTO avu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Gõꞌdá Yésũ kĩ, “Búkũ Ôvârí kâ ꞌdĩ ꞌá rî, ókĩ nĩ rî, ‘Ní ꞌbã Kúmú áníkâ Ôvârí kô rĩꞌá ûjũlâ.’ ” ");
INSERT INTO avu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sãtánã ûjũ Yésũ bê kpı̣̃ı̣̂ ngá ãmbá nõ ꞌbá yî ꞌásĩ ĩtí rî, gõꞌdá Sãtánã âyê gólâ trá drẽ tãkõ. ");
INSERT INTO avu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Yésũ drí gõzó Gãlĩláyã ꞌálâ. Líndrí Tãndí Ôvârí kâ drí mbârâkã fẽzó drílâ rĩzó õjílã lı̣̃fı̣́ îcílí kôrô. Gólâ rî trá õjílã lı̣̃fı̣́ îcílí jó tã ârî kâ rî ꞌbá yî ꞌásĩ ndrĩ ꞌbạ̃drı̣̃ Gãlĩláyã kâ ꞌá. Õjílã rî trá gólâ rî rú lûyı̣́lı̣́ rõô ꞌbạ̃drı̣̃ ꞌásĩ ndrĩ tã ꞌẽꞌẽ tãndí gólâkâ drí. ");
INSERT INTO avu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yésũ drí âgõzó Nãzãrétã ꞌálâ, võ yí drí rĩzó trá ãkpãkãꞌdã ꞌdĩyímvá ró rî ꞌálâ. Kậyı̣̂ rãtáã ꞌẽzó rî, drílâ nĩzó jó tã ârî kâ rî ꞌálâ, ꞌdĩî íyíkâ kó tã ꞌẽꞌẽ gólâkâ ĩꞌdî. Drílâ gõzó âdrélé ûrû, tãlâ gólâ lẽ úlı̣́ Ôvârí kâ zı̣̃lı̣́ õjílã drí. ");
INSERT INTO avu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gõꞌdá ófẽ wárãgã bı̣́ ãzâ trá drílâ ngóló-ngóló. Wárãgã bı̣́ nã ꞌá rî, Ôvârí ậngũ tã gólĩyî ꞌẽ ꞌbá rû ꞌẽlé ı̣̃zạ́tú rî ꞌbá yî trá tã ậngũ ꞌbá Ĩsáyã tı̣́ sĩ. Yésũ zı̣̂ úlı̣́ ꞌdĩ trá nõtí, ");
INSERT INTO avu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ôvârí zĩ mâ trá õjílã pãlé. Gólâ âfẽ fãfã trá má drí Líndrí Tãndí íyíkâ sĩ. Má ânĩ trá tã ậꞌdı̣̂-ậꞌdı̣̂ fẽlé õjílã gólĩyî rĩ ꞌbá lı̣̃fı̣́ lôꞌbélé tã õnjí ĩyíkâ tãsĩ rî yî drí. ");
INSERT INTO avu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tã má drí ânĩꞌá âtálâ ãnî drí nõ trá kậyı̣̂ Ôvârí drí õjílã íyíkâ lôfõzó tã ậtũ-ậtũ ꞌásĩ rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ꞌDĩî rî vósĩ rî, Yésũ drí gõzó wárãgã bı̣́ yí drí rĩꞌá zı̣̃lâ ꞌdĩ rî âꞌbãzó pãlé ngóló-ngóló fẽlé õjílã gólâ rĩ ꞌbá vó lâ ndrẽlé rî drı̣́gạ́. Drílâ gõzó rĩlí vũdrı̣́ rĩꞌá õjílã lı̣̃fı̣́ îcílí tã yí drí zı̣̃lı̣́ rî yî sĩ. Õjílã rĩ ꞌbá ĩyî ndrĩ ꞌdî ꞌbá yî îgâ ĩyî bı̣́lı̣́ trá, tã ꞌẽ ꞌbá âfõlé rî ârízó ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Drílâ gõzó tã pẽpẽ îtónãlé nõtí kĩ nĩ rî, “Ị̃tú gólâ ãndrõ nô sĩ rî, tã tíbê má drí rĩꞌá zı̣̃lâ ãnî drí tíbê nõ ꞌê rû trá, âcâ trá tã pạ̃tı̣́-pạ̃tı̣̃ ró, õzõ tã ậngũ ꞌbá drí îgĩlí rî kâtí.” Gólâ îcî õjílã trá tã ífí gólâ drí rĩꞌá zı̣̃lâ ꞌdĩ ꞌbá yî sĩ, gõꞌdá ĩꞌdî õjílã ꞌdî ꞌbá yî ı̣̂sũ ĩyíkâ bê rî kĩ, gólâ õkĩ yí ãꞌdô ĩꞌdî tíbê tã ậngũ ꞌbá Ĩsáyã drí rĩꞌá tã lâ âtálé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Õjílã ndrĩ âꞌdó ꞌbá tólâ rî ꞌbá yî rî ĩyî trá tã tãndí âtálé ĩꞌdî gólâ rî tãsĩ. Gõꞌdá tı̣̂ lâ yî drí ậꞌdı̣́zó ndrúndrú tãlâ tã tãndí gólâ drí rĩꞌá âtálâ ꞌdĩ ꞌbá yî tãsĩ. Gõꞌdá drílĩyî kpá rĩzó tã âtálé kĩ, “Îcâ ángô tí ró mvá Yõsépã kâ nõ drí rĩzó úlı̣́ ĩtí ꞌdĩ ꞌbá yî âtálé yã?” ");
INSERT INTO avu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yésũ âtâ trá õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, “Nĩ lẽé tã má drí rĩꞌá âtálâ rî kô. Nĩ nı̣̃ nô úlı̣́ mãnĩgõ gólâ kĩꞌá nĩ rî, ‘Nî ójó, ní ngî ngá sı̣́sı̣́ ánî rú sĩ, ní gõ ró ãzí-ãzí rú sĩ rî ngĩlí.’ Má âtâ úlı̣́ mãnĩgõ ꞌdî, tãlâ nĩ ârî tã má drí rĩzó tã lârâkô ꞌẽlé Kãpẽrãnómã ꞌálâ rî trá, ĩꞌdî nĩ kĩ kpá má õꞌê ró bê ãnî drí nõngá zãlô, yĩ õndrê ró, yĩ õgõ ró tã lẽlé. ");
INSERT INTO avu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ꞌDõvó má lôgõ drẽ úlı̣́ mãnĩgõ ngĩíngî ãnî drí, ‘Tã ậngũ ꞌbá ûsú õrẽ kô íyî áró yî drı̣́gạ́ sĩ.’ ");
INSERT INTO avu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nĩ ndrê drẽ, ạ̃kû ró rî, tã ậngũ ꞌbá Ẽlíyã ûsú õrẽ kô õjílã íyíkâ drı̣́gạ́ sĩ. Ĩtí rî, Ôvârí drí gõzó lõfó õnjí tẽtẽ ꞌbãlé gólĩyî îzãlé ndrô nâ cú drı̣̃ bê. Gõꞌdá ꞌbạ̃drı̣̃ ãmâ Ĩsĩrãꞌélẽ kâ ꞌá rî, ạ̃yı̣́zı̣́ bê rĩꞌá dũû ĩzã ꞌẽꞌá ĩyî. ");
INSERT INTO avu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gõꞌdá Ôvârí âjó tã ậngũ ꞌbá Ẽlíyã kô ạ̃yı̣́zı̣́ rî ꞌdĩ ꞌbá yî pãlé. Gõꞌdá gólâ jô íyîngá Ẽlíyã vólé ꞌbạ̃drı̣̃ ãmákâ nõ ꞌásĩ, nĩꞌá ạ̃yı̣́zı̣́ ãzâ ngĩî lâ pãlé ĩꞌdî. Ạ̃yı̣́zı̣́ rî ꞌdĩ Zãrẽpátã lé ꞌbá ꞌî ꞌbạ̃drı̣̃ Sĩdónã kâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Gõꞌdá kpá kậyı̣̂ tã ậngũ ꞌbá Ẽlísã kâ rî sĩ, Ôvârí pá õjílã ãzâ õrĩ ãmákâ nõ ꞌásĩ, ngá lãzé bê õzõ ãrí ꞌbá kâtí rî kô, gõꞌdá gólâ pâ cé ãgô rú bê Nãmánã Sírĩyã lé ꞌbá ró rî ĩꞌdî, gĩâ ꞌbạ̃súrú lídí ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Gõꞌdá õjílã ꞌdî ꞌbá yî ârílí bê tã gólâ drí rĩꞌá âtálâ ꞌdĩ rî, drílĩyî ngãzó ꞌdó õmbã ró lậvũlı̣́ kôrô. ");
INSERT INTO avu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Õjílã ꞌdî ꞌbá yî ndrĩ ngâ ĩyî trá ûrû gólâ rî drõlé vólé ꞌbạ̃drı̣̃ mvá nã ꞌásĩ, nĩzó gólâ rî lôzé bê võ cı̣̂rı̣̂ngı̣́ꞌdı̣̂ꞌdı̣̂ rî ꞌásĩ, tãlâ gólâ ãâꞌdê ró bê drãlé vólé. ");
INSERT INTO avu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Gõꞌdá gólâ drí íyîngá ngá pãzó cú õjílã õꞌbí ꞌdĩ ꞌbá yî lãfálé sĩ võ ꞌdî âyélé, gõꞌdá íyîngá nĩzó võ ãzâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nĩngá sĩ rî, drílâ nĩzó gõlé Kãpẽrãnómã ꞌálâ. Kậyı̣̂ rãtáã kâ sĩ, gólâ rĩꞌá tã Ôvârí kâ îmbáꞌá õjílã drí jó tã Ôvârí kâ ârî kâ ꞌá tólâ. ");
INSERT INTO avu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Gõꞌdá õjílã ꞌdî ꞌbá yî tı̣̂ lâ yî drí ậꞌdı̣́zó, tãlâ Yésũ îmbâ tã íyíkâ cú drı̣́-ãcê Ôvârí kâ rî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ãgô ãzâ rĩꞌá jó tã ârî kâ ꞌdĩ ꞌá. Ãgô ꞌdĩ cú rĩꞌá líndrí õnjí ạ̃bạ̃bạ̃ Sãtánã kâ bê yí ꞌá, gõꞌdá líndrí õnjí ꞌdĩ ômbê gólâ trá. Gõꞌdá líndrí õnjí ꞌdĩ drí trẽzó ãgô ꞌdĩ gbórókõ lâ sĩ ûrû kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yésũ, ní îzã ámâ drı̣̃ kô. Ní ânĩ nõ trá ámâ îzãlé. Má nı̣̃ trá, nî Ôvârí rî mvá ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yésũ drí gõzó tã âtálé líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ drí ꞌálé âdrã sĩ, “Nî, ní rî tı̣́tı̣́. Ní âfõ ãgô ꞌdĩ ꞌásĩ.” Ĩtí rî, líndrí õnjí ꞌdĩ drí ãgô ꞌdĩ vũzó vũdrı̣́ õjílã ꞌdî ꞌbá yî ândrá. Líndrí õnjí ꞌdĩ drí âfõzó ãgô ꞌdĩ âyélé. Gõꞌdá líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ ꞌé gólâ õnjí ró kô. ");
INSERT INTO avu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nĩngá sĩ, õjílã tı̣̂ drí ậꞌdı̣́zó ndrĩ tã ꞌdî drí sĩ. Õjílã ꞌdî ꞌbá yî rî ĩyî trá tã âtálé ĩyî võ ꞌásĩ kĩ nĩ rî, “Ãꞌdî fẽ mbârâkã Yésũ drí líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌbãzó íyî rõlé rî nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Gõꞌdá õjílã ꞌdî ꞌbá yî drí tã Yésũ drí ꞌẽlé ꞌdĩ âtázó lậꞌbúlı̣́ ndrĩ võ ꞌdî ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ꞌDĩî vósĩ rî, Yésũ yî ãzí-ãzí lâ yí bê drí gõzó ngãlé jó tã ârî kâ ꞌásĩ nĩꞌá Sĩmónã Pétẽrõ drí ꞌbã ꞌálâ nyãsá nyãlé. Gõꞌdá Sĩmónã Pétẽrõ rî ãdrá rĩꞌá ngá lãzé ró, rúꞌbạ́ lâ âmê trá tílí-tílí. Ódrí tã lâ pẽzó Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yésũ drí ânĩzó âdrélé ãnyî gbãrãkã gólâ drí ậyı̣́zó rî lạ̃gạ́tı̣́. Gólâ kĩ, “Ngá lãzé ꞌdĩ õndẽ rû.” Kôrô Sĩmónã Pétẽrõ rî ãdrá rî rúꞌbạ́ drí ậꞌdı̣́zó. Drílâ ngãzó ûrû nyãsá lâꞌdílí. ");
INSERT INTO avu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lạ̃njạ́túlı̣́ bê, õjílã ãzâ ꞌbá yî drí kpá ĩyî rû-lẽ-ãzí yî âjízó ngá lãzé ngĩíngî bê gólâ ngálâ êdélé. Gólâ rî trá íyî drı̣́ ꞌbãlé gólĩyî drı̣̃ı̣̂, êdê rû ĩyî trá ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gólâ rî trá õjílã ãzâ ꞌbá yî kpá înjílí líndrí õnjí Sãtánã kâ ꞌásĩ. Líndrí õnjí ꞌdĩ ꞌbá yî drí trẽzó ûrû kĩ nĩ rî, “Wûú! Nî Ôvârí rî mvá ĩꞌdî, ꞌdíyî pã ꞌbá ꞌî.” Gõꞌdá gólâ âtâ tã trá líndrí õnjí ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ rî tı̣́tı̣́.” Gólâ lẽé drẽ kô õjílã drí gólâ rî nı̣̃lı̣́ ꞌdíyî pã ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ị̃drú rî tí, võ drí ậwúrı̣̃ sĩ, gólâ drí ngãzó jạ̃rı̣́bạ̃ nã ꞌásĩ âfõlé nĩꞌá võ õjílã ãkó rî ꞌálâ. Gõꞌdá õjílã ꞌdî ꞌbá yî drí ĩyî rĩzó gólâ rî ndãlé. Gõꞌdá ûsû ĩyî gólâ bê rî, âtâ ĩyî tã trá drílâ kĩ nĩ rî, “Ní rî ãmá bê nõngá. Ní nĩ kô.” ");
INSERT INTO avu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gólâ kĩ, “Îcá kô má drí rĩzó cé võ ãlô nõ ꞌá, má âꞌdô nĩꞌá kpá võ ãzâ ꞌbá yî ꞌásĩ tã Ôvârí kâ âtálé õjílã drí ndrĩ, tãlâ Ôvârí âjô mâ trá tã íyíkâ âtálé.” ");
INSERT INTO avu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ꞌDĩî vósĩ rî, gólâ nĩ trá zãâ tã îmbá bê jó tã Ôvârí kâ ârî kâ ꞌásĩ ꞌbạ̃drı̣̃ mvá ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ ꞌá ꞌdĩ ꞌbá yî ꞌásĩ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kậyı̣̂ ãzâ sĩ rî, Yésũ rĩꞌá õjílã õꞌbí ãmbá lı̣̃fı̣́ îcíꞌá ãnyî lı̣̃mvû ândrê zı̣̃lı̣́ Gãlĩláyã rî lạ̃gạ́tı̣́. Õjílã lîzô trá rõô îfî ĩyî ꞌâ trá ngárá-ngárá rû îpĩ ꞌbá rî yî, rû lôzé ꞌbá rî ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","3","Gõꞌdá Yésũ ndrê bê ĩtí rî, õjílã trá dũû ãnyî ãnyî yí rú rî, gólâ ndrê kõlóngbõ trá rı̣̃ ĩtí lı̣́pı̣̂ lâ yî âsê ĩyî trá ĩví ꞌálâ lı̣̃mvû ꞌásĩ. Gólâ drí gõzó mbãlé ãlô rî drı̣̃ı̣̂, tãlâ óndrê ró yî bê tõ tã âtárẽ ꞌá. Kõlóngbõ ꞌdî, lı̣́pı̣̂ lâ Sĩmónã Pétẽrõ ĩꞌdî. Sĩmónã Pétẽrõ yî lậmû-ãzíyã lâ yí bê rĩꞌá ĩyî îmbá ĩyíkâ ı̣̃ꞌbı̣̂ kâ lı̣̃fı̣́ lâ êdéꞌá ngbãâ ãnyî. Lậmû-ãzíyã lâ ꞌdĩ ꞌbá yî, rú lâ yî Yãkóbã yî Yõwánĩ bê, Zẽbẽdáyõ rî mvá ró rî yî. Yésũ drí tã âtázó Sĩmónã drí, gólâ ẽêsê drẽ kõlóngbõ íyíkâ ꞌdĩ fínyáwá lı̣̃mvû ꞌálâ õjílã ꞌdî ꞌbá yî rú sĩ, yí gõ ró tã âtálé rĩzó gólĩyî lı̣̃fı̣́ îcílí lı̣̃mvû lésĩ ró, ãârî ró ĩyî bê tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yésũ ndẽ õjílã õꞌbí ꞌdĩ ꞌbá yî lı̣̃fı̣́ lâ yî îcî-îcî trá. Drílâ gõzó tã âtálé Sĩmónã Pétẽrõ yî drí Yãkóbã yí bê Yõwánĩ yí bê kõlóngbõ zẽlé lı̣̃mvû gạ́lı̣́ ꞌá, õꞌbê ró ĩyî îmbá ĩyíkâ lı̣̃mvû ꞌá ı̣̃ꞌbı̣̂ rũzó. ");
INSERT INTO avu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sĩmónã drí tã âtázó Yésũ drí kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá, mã rî trá îmbá nõ ꞌbẽlé ı̣̃ꞌbı̣̂ drí ngạ́cı̣̂ nõ sĩ kárá lı̣̃mvû nõ ꞌá, gõꞌdá mã rú kó ngá ãzâ kô. Gõꞌdá tãlâ ní âtâ tã trá ãmâ drí rî drí sĩ, mã âꞌdô îmbá ꞌbẽꞌá óꞌdí.” ");
INSERT INTO avu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Gõꞌdá ꞌbê ĩyî îmbá bê ândálé rî, drílĩyî gõzó ı̣̃ꞌbı̣̂ rũlı̣́ ĩyíkâ îmbá ꞌá dũû õzõ tõtõ kâtí, âsê ĩyî kpı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Drílĩyî ãzí-ãzí lâ yî ậzı̣́zó ĩyî pãlé ı̣̃ꞌbı̣̂ âsélé lı̣̃mvû ꞌásĩ ꞌbãlé kõlóngbõ ꞌá, îmbá gõꞌdá trá sĩꞌá, ꞌbã ĩyî ı̣̃ꞌbı̣̂ gõꞌdá trá njúꞌdậ-njúꞌdậ kõlóngbõ ꞌá lậnjı̣̃-lậnjı̣̃ ró, kõlóngbõ trá ꞌẽꞌá fĩlí fĩfĩ lı̣̃mvû zẽlé. ");
INSERT INTO avu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Gõꞌdá Sĩmónã yî ãzí-ãzí lâ yí bê ndrê bê ı̣̃ꞌbı̣̂ trá dũû îmbá ꞌá rî, tı̣̂ lâ yî ậꞌdı̣̂ trá ndrĩ. Sĩmónã drí ꞌãꞌî tı̣̃zó vũdrı̣́ Yésũ ágálé kĩ nĩ rî, “Ôvârí, mâ nõ õjílã õnjí ꞌî. Nî, ní ꞌê âfílí kõlóngbõ ãmákâ nõ ꞌá ãmâ pãlé nõ ángô tí ró, mâ cú ĩtí áyábálá ró nõ yã?” Yésũ kĩ, “Ní ꞌê ũrı̣̃ kô, îtónã ĩꞌdî ngbãângbânõ ı̣̃tú ãndrõ nô sĩ rî, tã ꞌẽꞌẽ áníkâ âꞌdó gõꞌdá ı̣̃ꞌbı̣̂ âsélé ĩꞌdî kô. Ní âꞌdô gõꞌdá rĩꞌá õjílã mvá âsélé ĩꞌdî ꞌdẽlé má vó tã ámákâ rî ꞌẽlé ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sĩmónã yî ãzí-ãzí lâ yí bê drí gõzó kõlóngbõ âsélé lı̣̃mvû ꞌásĩ. Îtónãlé kậyı̣̂ ꞌdĩ ꞌá rî, Sĩmónã yî Yãkóbã yî Yõwánĩ bê âyê ĩyî lôsĩ ı̣̃ꞌbı̣̂ rũrũ kâ trá, âgõ ĩyî trá ꞌdẽlé Yésũ vó lãjóꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kậyı̣̂ ãzâ sĩ, Yésũ rĩꞌá ꞌbạ̃drı̣̃ mvá ãzâ ꞌá. Drílâ ãgô ãzâ ûsúzó ngá lãzé ãrí kâ bê yí rú. Ãgô nõ drí rĩzó vũdrı̣́ ꞌãꞌî drı̣̃ı̣̂ gólâ ágálé rúꞌbạ́ lôꞌbãlé kĩ nĩ rî, “Kúmú, õzõ ĩîcâ trá ní lı̣̃fı̣́ rî, ní êdê ámâ rúꞌbạ́ nõ, ãꞌdô ró bê ngbángbá.” ");
INSERT INTO avu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Drílâ drı̣́ ꞌbãzó gólâ rú kĩ nĩ rî, “Ãwô-ꞌdĩ, má lẽ trá ánî pãlé êdélé rúꞌbạ́ bê lúwạ́-lúwạ́.” Nĩngá sĩ rî, kôrô ngá lãzé ꞌdĩ drí ndẽzó ãgô ꞌdĩ rú sĩ. Ãgô ꞌdĩ, rúꞌbạ́ lâ drí âgõzó lúwạ́-lúwạ́. ");
INSERT INTO avu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Drílâ tã ꞌbãzó ãgô ꞌdĩ drí kĩ nĩ rî, “Ní âꞌdâ tã nô õjílã ãzâ drí kô. Ní nĩ zãlô ánî rúꞌbạ́ ꞌdĩ âꞌdálé drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ drí, ní gõ ró ngá fẽfẽ fẽlé Ôvârí drí. ꞌDĩî rî tã Ôvârí drí âtálé ãmâ ạ́ꞌbı̣́yạ́ Músạ̃ drí tã ꞌbãꞌbã ró rî ĩꞌdî. Õzõ ní õꞌê trá ĩtí rî, õjílã ndrĩ âꞌdô ĩyî nı̣̃ꞌá lâ kĩ nĩ rî, ní êdê rû trá ngbángbá ãrí ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tã Yésũ drí rĩꞌá ꞌẽlâ nõ lậꞌbû trá zãâ ngbẽrê võ ꞌásĩ ndrĩ. Gõꞌdá õꞌbí ãzâ ꞌbá yî ĩyíkâ kpá zãâ ânĩꞌá gólâ ngálâ úlı̣́ gólâkâ rî ârílí, gõꞌdá kpá gólâ rî îjílí ĩyî êdélé ngá lãzé ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gõꞌdá Yésũ rî rĩꞌá ꞌbẽlé íyîngá ꞌbẽꞌbẽ ũgũ sĩ, nĩꞌá võ gólâ õjílã ãkó rî ꞌálâ rãtáã íyíkâ ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gõꞌdá kậyı̣̂ ãzâ sĩ rî, Yésũ rĩꞌá õjílã îmbáꞌá jó ãzâ ꞌá. Lãꞌbí îmbá ꞌbá yî Pạ̃rúsı̣̃ ãzâ ꞌbá yí bê rĩꞌá ĩyî úlı̣́ Yésũ kâ rĩꞌá âtálâ rî ârílí kpá gólâ rî ûjũlı̣́. Võ drílĩyî ânĩzó ꞌálâ ꞌásĩ rî, ãzâ ꞌbá yî ãnyî ãnyî, ãzâ ꞌbá yî jẽjẽ ró õzõ Yẽrõsãlémã tí rî. Gõꞌdá Ôvârí rî rĩꞌá mbârâkã fẽlé Yésũ drí rĩzó õjílã ngá lãzé bê rî ꞌbá yî êdélé. ");
INSERT INTO avu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Õjílã ãzâ ꞌbá yî ậnjı̣̃ ĩyî ãgô ãzâ trá gbãrãkã sĩ nĩzó gólâ ngálâ. Ãgô rî ꞌdĩ rĩꞌá kõrõkpó ró. ");
INSERT INTO avu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Õjílã ꞌdî ꞌbá yî îcá gõꞌdá fĩlí jó ꞌálâ kô, tãlâ õjílã gõꞌdá trá rõô bũúũ ĩvĩ sĩ. Gõꞌdá õjílã ꞌdî ꞌbá yî drí gõzó mbãlé jó-drı̣̃ ꞌálâ, ũpı̣̃ lõlé jó-drı̣̃ lésĩ ró ãgô nã îrízó kôrô gbãrãkã bê nyé vũdrı̣́ ꞌálâ ãnyî Yésũ ágálé ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Gólâ nı̣̃ trá kĩ nĩ rî, õjílã ꞌdî ꞌbá yî lẽ ĩyî tã trá kĩ nĩ rî, yî rĩꞌá cú mbârâkã bê ãgô ꞌdĩ êdézó rî, drílâ gõzó tã âtálé ãgô ngá lãzé bê ꞌdĩ drí kĩ nĩ rî, “Ámâ rû-lẽ-ãzí, áâyê nî trá tã õnjí áníkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nĩngá sĩ rî, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yí bê, drílĩyî rĩzó lôzólé ĩyî võ ꞌásĩ Yésũ rú. Drílĩyî tã âtázó kĩ nĩ rî, “Ãgô nõ gólâ rî íyíkâ ãꞌdô tã âtálé ĩꞌdî, gólâ ı̣̂sũ íyíkâ bê rî, yí ãâꞌdô Ôvârí ĩꞌdî yã? Cé Ôvârí ĩꞌdî rĩ ꞌbá tã õnjí õjílã kâ âyélé rî.” ");
INSERT INTO avu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Gõꞌdá Yésũ nı̣̃ tã ı̣̂sũ-ı̣̂sũ gólĩyíkâ bê trá ĩtí rî, drílâ gõzó tã âtálé kĩ nĩ rî, “Nĩ rî tã ı̣̂sũlı̣́ ĩtí ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mâ gólâ âjólé ûrú lésĩ rî cú rĩꞌá drı̣́-ãcê bê ãngó nõ ꞌá tã õnjí õjílã kâ âyézó. Âꞌdô ꞌbãꞌá cú ĩtí lâŋõ ãkó má drí tã õnjí õjílã kâ âyézó cé úlı̣́ âtâ-âtâ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gõꞌdá õzõ má ĩîngâ ãgô kõrõkpó ró nõ trá ûrû ậcı̣́ tõlé cé úlı̣́ âtâ-âtâ sĩ rî, ꞌdĩî âꞌdô âꞌdálâ kĩ, mâ cú rĩꞌá drı̣́-ãcê bê tã õnjí gólâkâ âyézó.” Drílâ tã âtázó ãgô ngá lãzé bê ꞌdĩ drí kĩ nĩ rî, “Ní ngâ ûrû. Ní trõ gbãrãkã áníkâ, ní gõ ró ꞌbã ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tã Yésũ drí âtálé ꞌdĩ sĩ rî, ãgô ꞌdĩ drí ngãzó ûrû, gbãrãkã íyíkâ trõlé, zãâ nĩzó íyî pá sĩ yí drí ꞌbã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Õjílã tíbê tã ꞌdî ndrẽ ꞌbá trá rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó. Gõꞌdá drílĩyî Ôvârí rî lûyı̣́zó kĩ nĩ rî, “Mã ndrê tã tı̣̂ drí ậꞌdı̣́zó drí lâ sĩ rî trá ãndrõ nô.” ");
INSERT INTO avu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gõꞌdá ꞌdĩî rî vósĩ rî, kậyı̣̂ ãzâ sĩ rî, Yésũ rĩꞌá lậmúꞌá. Gólâ ûsû ãgô ãzâ trá. Ãgô ꞌdĩ bélé-bélé ûꞌdú ꞌbá ꞌî, rú lâ Mãtáyõ. Mãtáyõ rĩꞌá võ íyíkâ bélé-bélé ûꞌdû kâ ꞌá. Yésũ drí tã âtázó Mãtáyõ drí kĩ nĩ rî, “Mãtáyõ, ní ânĩ ꞌdẽlé má vó lãjóꞌbá ámákâ ró.” ");
INSERT INTO avu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Îtónãlé kậyı̣̂ ꞌdĩ ꞌásĩ rî, Mãtáyõ âyê ngá ꞌẽꞌẽ íyíkâ trá, nĩ trá ꞌdẽlé Yésũ vó. ");
INSERT INTO avu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nĩngá sĩ rî, Mãtáyõ drí rû-lẽ-ãzíyã lâ yî ậzı̣́zó, ãânĩ ró ĩyî ngá nyãlé yí drí ꞌbã ꞌálâ, tãlâ ũûsû ró ĩyî Yésũ yî bê lãjóꞌbá gólâkâ yí bê tólâ. Rû-lẽ-ãzíyã lâ ꞌdĩ ꞌbá yî ãmbá lâ rĩꞌá bélé-bélé ûꞌdú ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pạ̃rúsı̣̃ yî gõꞌdá gólĩyî ũrûkậ âꞌdó ꞌbá lãꞌbí îmbá ꞌbá ró rî ꞌbá yí bê ndrê ĩyî bélé-bélé ûꞌdú ꞌbá rî ꞌbá yî tã õnjí ꞌbá ró, tãlâ bélé-bélé ûꞌdú ꞌbá yî îzã lãꞌbí õrĩ gólĩyíkâ trá. Gõꞌdá lı̣̃fı̣́ îcí ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã âtázó lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Yésũ rî íyíkâ ngá nyãlé tã õnjí ꞌbá ꞌdĩ ꞌbá yí bê tãlâ ãꞌdô ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","32","Nĩngá sĩ rî, Yésũ drí tã âtázó lı̣̃fı̣́ îcí ꞌbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ârî drẽ, ngá lãzé ꞌbá nĩ cé nĩ ójó ngálâ ngá ngĩlí. Gõꞌdá má ânĩí kô tã mbı̣̂ ꞌbá pãlé, má ânĩ trá tã õnjí ꞌbá ậzı̣́lı̣́, tãlâ ópâ ró gólĩyî bê tã õnjí gólĩyíkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gõꞌdá nĩngá sĩ rî, lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî drí tã âtázó gólâ drí kĩ nĩ rî, “Tã ârí ꞌbá Yõwánĩ kâ rî ꞌbá yî tã ârí ꞌbá Pạ̃rúsı̣̃ yí kâ bê rî ĩyî trá tı̣̂ ꞌbĩlí rĩzó ꞌálé ꞌãꞌí ró rãtáã ꞌẽlé ĩꞌdî, gõꞌdá tã ârí ꞌbá áníkâ nõ ꞌbá yî rî ĩyíkâ ngá nyãlé zãâ kárá kpá ngá mvũꞌá cú ĩtí tı̣̂ ꞌbĩ ãkó ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Nĩ ârî drẽ, gõꞌdá õdrógô yî õtírĩ rĩî dûrûbạ̃ bê lãgĩ ꞌá ạ́ꞌbı̣́ lâ drí ꞌbã ꞌálâ rî, gólĩyî nyá ĩyî ngá ndrĩ ꞌdó võ ãlô ꞌá ãyĩkõ ꞌẽzó kô yã? Õzõ ãꞌdô ĩtí ngbãângbânõ rî, ãmâ tã ârí ꞌbá ámákâ bê kpá trá ꞌdó ãyĩkõ ró ngá nyãꞌá ꞌdó võ ãlô ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tã âꞌdâ-âꞌdâ lâ õzõ õdrógô õtírĩ âꞌdó yû rî, gólĩyî âꞌdô rĩꞌá cú ĩtí ngá nyã ãkó. Kpá ĩtí, õzõ má õtírĩ gõô ámâ átá ngálâ ûrú ꞌálâ rî, tã ârí ꞌbá ámákâ âꞌdô rĩꞌá kpá cú ĩtí ngá nyã ãkó.” ");
INSERT INTO avu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gólâ âtâ trá lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Má rî nõ tã óꞌdí îmbálé ĩꞌdî tã ârí ꞌbá ámákâ rî ꞌbá yî drí, tã óꞌdí ró rî ĩꞌdî tã ạ̃kû rî võ lâ ꞌá. Tã gólâ má drí rĩꞌá îmbálâ nõ rĩꞌá õzõ ítá óꞌdí kâtí. Ólôsé ítá óꞌdí ró rî kô kpạ̃ạ́kũ ítá ạ̃kû ôsĩ ꞌbá trá rî rú, tãlâ ítá óꞌdí ꞌdĩ õzó ôró ânjólé vólé ítá ạ̃kû ꞌdĩ ũpı̣̃ lâ âyélé hõwéẽ ậvû-ậvû ró lậvũlı̣́ gạ̃rạ̃ sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Gõꞌdá tã gólâ má drí rĩꞌá îmbálâ nõ kpá rĩꞌá õzõ õdrá óꞌdí kâtí. Âꞌdó kô tãndí ró õjílã ãzâ drí õdrá óꞌdí lôrózó mõrá gólâ ạ̃kû mbârâkã ãkó rî ꞌá. Gólâ õꞌê trá ĩtí rî, gõꞌdá õdrá õtírĩ ângá rî, mõrá ạ̃kû ꞌdĩ âꞌdô pı̣̃ꞌá, õdrá ꞌdĩ drí lâsózó vũdrı̣́ rû îzãlé. ");
INSERT INTO avu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ĩtí rî, órî õdrá óꞌdí lôrólâ mõrá gólâ tãndí ró rî ꞌá. Tã ꞌdî tãsĩ rî, âꞌdô rĩꞌá dódó cú ĩtí rû îzã ãkó. ");
INSERT INTO avu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ãnî lãꞌbí îmbá ꞌbá nõ ꞌbá yî Pạ̃rúsı̣̃ yí bê lẽ ĩyíkâ cé tã ạ̃kû rî rõlé ĩꞌdî, nĩ âꞌdô trá õzõ õjílã gólâ rĩ ꞌbá íyíkâ cé õdrá ạ̃kû mvũlı̣́ ĩꞌdî rî kâtí, nĩ lẽé kô ngá óꞌdí îtójõlé ngã ꞌbô tãndí ró, ngã âꞌdó kô tãndí ró yã rî, nĩ lẽé kpá tã ârí ꞌbá ámákâ drí tã óꞌdí ámákâ ârílí kô. Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kậyı̣̂ rãtáã kâ sĩ, Yésũ yî rĩꞌá lậvũꞌá pávó kôrô ạ́mvú ạ̃drúgú lı̣̂njı̣́ ꞌbá trá rî kâ ꞌásĩ lãjóꞌbá íyíkâ rî ꞌbá yí bê. Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ạ̃drúgú ôsĩzó nyãlé lõfó drí sĩ. ");
INSERT INTO avu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî ꞌê bê ĩtí rî, Pạ̃rúsı̣̃ ãzâ ꞌbá yî ngâ trá õmbã ró. Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí tã âtázó Yésũ drí kĩ nĩ rî, “Tãlâ ãꞌdô ꞌî lãjóꞌbá áníkâ ꞌdĩ ꞌbá yî drí ạ̃drúgú ôsĩzó kậyı̣̂ rãtáã kâ nõ sĩ yã? Rĩꞌá tã õnjí ꞌî lôsĩ ꞌẽzó ĩtí kậyı̣̂ rãtáã kâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yésũ drí tã âtázó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ zı̣́ tã ãmâ ạ́ꞌbı̣́yạ́ kúmú ạ́ngı̣́ Dạ̃wúdı̣̃ rî tãsĩ rî trá búkũ Ôvârí kâ ꞌá yã? Gólĩyî ạ̃jú ꞌbũ ꞌbá íyíkâ rî ꞌbá yí bê rĩꞌá lõfó ró. ");
INSERT INTO avu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Gólĩyî fî ĩyî trá jó Ôvârí kâ ꞌálâ ãmbãtã fẽlé trá ngá fẽfẽ ró Ôvârí drí rî nyãlé. Nĩ nı̣̃ trá tãndí ró kĩꞌá nĩ rî, cé drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî ꞌbá yî áâyê ĩꞌdî ngá nyãnyã rî ꞌdĩ nyãlé. Gõꞌdá áâtá kô kĩ nĩ rî, gólĩyî lãꞌbí îzã ꞌbá ꞌî tã gólĩyî drí ꞌẽlé trá ꞌdĩ tãsĩ, tãlâ lõfó mbârâkã lậvũ kôrô tã lãꞌbí ꞌdã ꞌbá kâ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mâ gólâ âjólé ûrú lésĩ rî rĩꞌá drı̣́-ãcê bê kậyı̣̂ gólâ ꞌbãlé rãtáã ꞌẽzó ꞌdĩ drı̣̃lı̣́.” ");
INSERT INTO avu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kậyı̣̂ ãzâ sĩ, kpá kậyı̣̂ rãtáã kâ ꞌî, Yésũ drí fĩzó jó tã Ôvârí kâ ârî kâ ãzâ ꞌá õjílã lı̣̃fı̣́ îcílí. Ãgô ãzâ rĩꞌá tólâ, drı̣́-ágó lâ lîsî trá, êjẽé rû kô, rî trá kõgõꞌdõ ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá ãzâ ꞌbá yí bê rĩꞌá ĩyî võ ꞌdî ꞌá tólâ, rĩꞌá ĩyî Yésũ rî lôtíꞌá ngãtá gólâ ãâꞌdô ꞌbô tã îzãꞌá kậyı̣̂ rãtáã ꞌẽzó ꞌdĩ ꞌá ãgô ꞌdĩ êdézó yã rî, yĩ õfẽ ró mõndrã lâ bê, úũrû ró gólâ, rî ĩyî trá cé gólâ rî ndrẽlé ĩꞌdî lôsĩ ꞌdî ꞌẽrẽ ꞌá kậyı̣̂ rãtáã kâ ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gõꞌdá Yésũ nı̣̃ bê tã ı̣̂sũ-ı̣̂sũ gólĩyíkâ ꞌdĩ trá rî, gólĩyî lẽé ĩyî trá íyî fũlı̣́ vólé, tãlâ gólâ lẽé tã ãmbá gólĩyíkâ rĩꞌá ꞌbãlâ ꞌdĩ ꞌbá yî kô. Yésũ drí gõzó tã âtálé ãgô drı̣́ bê lĩsí ró ꞌdĩ drí kĩ nĩ rî, “Ní ngâ ûrû, ní ânĩ ró má ngáá nõlé, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yí bê õndrê ró ĩyî bê tã má drí ꞌẽꞌá ꞌẽlâ rî.” Ãgô ꞌdĩ drí ngãzó ûrû ânĩlí gólâ ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gólâ drí tã âtázó Pạ̃rúsı̣̃ yî drí lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yí bê kĩ nĩ rî, “Tã ꞌbãꞌbã ãmákâ ꞌá rî, îcâ trá ãmâ drí õjílã pãzó kậyı̣̂ rãtáã ꞌẽzó rî ꞌá ngãtá kô yã? Má âꞌdô õjílã ãlô rî pãꞌá cú ngãtá má ãâyê gólâ õrî ró bê ĩzã ꞌẽlé yã?” ");
INSERT INTO avu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Gólâ drí rĩzó Pạ̃rúsı̣̃ yî tẽlé tã-drı̣̃ ĩyíkâ ꞌdĩ jãlé rî, kó õjílã ãlô ãzâ âtá úlı̣́ kô. Gólâ drí gõzó tã âtálé ãgô ꞌdĩ drí kĩ nĩ rî, “Ní êjẽ ánî drı̣́ mbı̣̂mbı̣̂.” Ãgô ꞌdĩ drí úlı̣́ gólâkâ ꞌdĩ ârízó íyî drı̣́ êjẽzó. Gõꞌdá ãgô ꞌdĩ drí íyî drı̣́ ꞌbãzó tãndí ró mbı̣̂mbı̣̂ mẽné-ménê. ");
INSERT INTO avu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gõꞌdá Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yí bê trá ꞌdó õmbã ró, rĩꞌá lı̣̃fı̣́ ı̣̂njı̣́ꞌá, sı̣́-gílí nyãꞌá, rî ĩyî trá tã âtálé ĩyî võ ꞌásĩ kĩ, yĩ âꞌdô gólâ rî ꞌẽꞌá ángô tí ró yã ĩyî drí fũzó lâ vólé rî. ");
INSERT INTO avu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gõꞌdá ꞌdó kậyı̣̂ gólâ ꞌdĩ ꞌá rî, Yésũ âyê tã ârí ꞌbá íyíkâ trá ꞌdó vólé, drílâ mbãzó únı̣́ drı̣̃ ꞌálâ élêwálâ, gólâ rî trá tólâ ngạ́cı̣̂ gı̣̃rı̣̃ cé rãtáã ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gõꞌdá võ ậwúlı̣́ bê rî, drílâ âgõzó únı̣́ drı̣̃ lésĩ tã ârí ꞌbá íyíkâ rî ꞌbá yî ậzı̣́lı̣́ yí ngálâ. Gõꞌdá drílâ tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî êꞌbézó ꞌdó võ ãlô ꞌá, tã âtázó drílĩyî, drílâ gõzó zĩlâ ꞌálâ ꞌásĩ cé mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rĩlí yí bê lãjóꞌbá íyíkâ ró tã yí drí rĩꞌá îmbálâ rî ꞌbá yî ı̣̂lı̣́lı̣́. ");
INSERT INTO avu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Gõꞌdá rú lâ ĩyî ĩꞌdî nõ, Sĩmónã rĩꞌá zı̣̃lâ Pétẽrõ rî, Ãndĩríyã, Sĩmónã rî ậdrúpı̣̃ ró rî, Yãkóbã yî ậdrúpı̣̃ lâ Yõwánĩ bê. Fílĩpõ, Bãtõlõméyõ, Mãtáyõ, Tómã, Yãkóbã Ãlõpáyã rî mvá ĩꞌdî, Sĩmónã gólâ fĩ ꞌbá õmã ꞌá õmbã ꞌẽlé ꞌbạ̃drı̣̃ tãsĩ rî ĩꞌdî, Yúdạ̃ Yãkóbã ãzâ rî mvá lâ ró rî, Yúdạ̃ Ĩsĩkãrĩyótã gólâ ꞌẽ ꞌbá Yésũ rî gĩlí fũlı̣́ rî. ");
INSERT INTO avu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yésũ yî lãjóꞌbá íyíkâ rî ꞌbá yí bê, ârî ĩyî trá vũdrı̣́ únı̣́ ãpírĩ lésĩ, zãâ âcâ ĩyî trá ı̣̃nyạ́kú drı̣̃ı̣̂ võ sãlãrã sãlãrã rî ꞌá, võ gólâ õjílã drí rĩzó rû êꞌbélé võ ãmbá nõ ꞌbá yî ꞌásĩ ndrĩ tã îmbâ-îmbâ gólâkâ ârílí rî ꞌá, võ jẽjẽ ꞌásĩ, Yẽrõsãlémã lésĩ, Tírã lésĩ, gõꞌdá kpá Sĩdónã lésĩ. ");
INSERT INTO avu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Võ ꞌdî ꞌá rî, õjílã ãzâ ꞌbá yî ngá lãzé bê rî ânĩ ĩyî trá gólâ ngálâ, gólâ ẽêdê ró ĩyî. Gõꞌdá kpá ãzâ ꞌbá yî Sãtánã drí ômbélé trá rî ânĩ ĩyî trá, gólâ ẽêdê ró ĩyî. ");
INSERT INTO avu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Õjílã ndrĩ ûjũ ĩyî trá ꞌẽꞌá drı̣́ dõlé Yésũ rú kĩ nĩ rî, Yésũ õdõ drı̣́ gbõ ꞌwãâ õjílã nô ꞌbá yî rú, kôrô drílĩyî rû êdézó. Gólâ rî mbârâkã câ trá õjílã ꞌdî ꞌbá yî rú, drílĩyî ꞌbãzó tãndí ró ꞌdĩ. ");
INSERT INTO avu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gõꞌdá nĩngá sĩ rî, gólâ ndrê tã ârí ꞌbá íyíkâ rî yî lı̣̃fı̣́ lâ trá, drílâ rĩzó tã âtálé gólĩyî drí kĩ nĩ rî, “Ãnî tã ârí ꞌbá ámákâ rî yî, õzõ ãnî ãꞌdô mbârâkã ãkó ngá ãkó lé ꞌbá ró rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ĩtí rî, nĩ âꞌdô rĩꞌá gólâ bê ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Õzõ ãnî ãꞌdô ngá lôvó bê dũû rî, cé Ôvârí ĩꞌdî ngá lôvó ãníkâ ꞌdĩ ndrẽlé. Gólâ âꞌdô ngá ãnî drí âꞌdózó lôvó lâ bê ꞌdĩ fẽꞌá ãnî drí. Õzõ nĩ õrî ãwó ngõlé nõ tãlâ tã ꞌẽꞌẽ õnjí ãníkâ îzã tã tãndí ãnî lãfálé Ôvârí bê rî ꞌá rî trá rî drí rî, tã ãníkâ âꞌdô sũꞌá Ôvârí rú. Ãyĩkõ âꞌdô ãnî cĩꞌá, õzõ Ôvârí õtírĩ tã õnjí ãníkâ trõô vólé rî. ");
INSERT INTO avu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Õzõ õjílã ãzâ ꞌbá yî õcâ ĩyî lãfálé câ ãnî rú sĩ, rĩzó ãnî lôꞌdálé kpá ꞌdásí ꞌẽlé ãnî rú, tãlâ ãnî ãꞌdô tã ârí ꞌbá ámákâ ĩꞌdî rî, nĩ ı̣̂sũ tã kô. Tã ı̣̂sũ-ı̣̂sũ võ ꞌá rî, nĩ ꞌbã tã ậꞌdı̣̂-ậꞌdı̣̂ ĩꞌdî ãyĩkõ sĩ ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌá, ãnî rĩꞌá cú tã tãndí bê, tãlâ nĩ âꞌdô drı̣́-ꞌâ ạ́ngı̣́ ûsúꞌá ûrú ꞌálâ Ôvârí ngálâ. Ạ̃kû rî, tã ậngũ ꞌbá Ôvârí kâ rî ꞌbá yî, ạ́ꞌbı̣́yạ́ õjílã ꞌdî ꞌbá yí kâ rî îzã kpá gólĩyî rú. Ãnî pı̣̃pı̣̂sı̣́lı̣́ ı̣̃ı̣̂dû ı̣̂dû Ôvârí rî rõlé õzõ tã ậngũ ꞌbá nã ꞌbá yî tí. ");
INSERT INTO avu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ngbãângbânõ rî, gólĩyî tíbê ꞌbã ꞌbá tã ârí ꞌbá ámákâ ró kô rî, tã gólĩyíkâ rî ĩyíkâ kpá ngĩî. Ĩzã kõkõ âꞌdô âcáꞌá gólĩyî rĩ ꞌbá ãngó nõ ꞌá rî ngá-tı̣̂ dũû rî ꞌbá yí bê rî ꞌbá yî drı̣̃ı̣̂, tãlâ gólĩyî êꞌbê ngá-tı̣̂ trá dũû lậpı̣́ ꞌbá ró gólĩyî nyãányâ drí. ");
INSERT INTO avu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ĩzã kõkõ âꞌdô âcáꞌá gólĩyî ꞌbã ꞌbá ãrõ-ãrõ bê rî ꞌbá yî drı̣̃ı̣̂, gólĩyî trá cé ngá bê ãngó ꞌá nõngá, gõꞌdá gólĩyî ngá ãzâ ãkó Ôvârí ngálâ. Ĩzã kõkõ âꞌdô âcáꞌá gólĩyî tíbê âꞌdó ꞌbá cé ãyĩkõ bê ãngó nõ ꞌá rî ꞌbá yî drı̣̃ı̣̂, tãlâ gólĩyî lẽé tã ámákâ kô. ");
INSERT INTO avu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ĩzã kõkõ âꞌdô âcáꞌá gólĩyî tíbê lẽ ꞌbá ĩyíkâ cé õjílã drí ĩyî lûyı̣́lı̣́ ĩꞌdî rî drı̣̃ı̣̂, gólĩyî rĩꞌá õzõ tã ậngũ ꞌbá õnjí gólĩyî ãnî ạ́ꞌbı̣́yạ́ yî drí lûyı̣́lı̣́ rî ꞌbá yí kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ãnî tã ârí ꞌbá ámákâ rî, nĩ ârî drẽ, nĩ lẽ õjílã gólĩyî rĩ ꞌbá ãnî îzãlé rî ꞌbá yî. Nĩ ꞌê tã tãndí gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Õzõ gólĩyî ãâꞌdô rĩꞌá ãnî trĩꞌá rî, nĩ ꞌê rãtáã Ôvârí õfẽ ró tã tãndí gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","30","Õzõ õjílã ãzâ ũsı̣̃ ãnî ékpẽ ngãtá ꞌbô ãnî úlũgbúrũ ngã ꞌbô ãnî gạ̃gạ̃lı̣́-fã yã rî, nĩ sı̣̃ gólâkâ kô, nĩ âyê gólâ ũsı̣̃ ró ãnî kpá óꞌdí. Õzõ ũgú ũûgũ ítá ãníkâ ãlô rî, nĩ êdrẽ gólâ kô. Õzõ õjílã ãzâ ũzı̣̂ ngá ní tı̣̂ sĩ rî, nĩ lôgâ kô, nĩ fẽ drílâ. Õzõ óõlôgõ kô rî, nĩ îjî kô. ");
INSERT INTO avu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tã gólâ ní drí lẽlé kĩꞌá nĩ, ĩyî ãzí-ãzí yî õꞌê ĩyî ĩꞌdî ãnî drí rî, nĩ ꞌê kpá ĩꞌdî gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Îcá kô õzõ nĩ õlẽ cé ãnî rû-lẽ-ãzí yî ĩꞌdî. Âꞌdô ꞌbãꞌá kpá ĩtí õjílã gólĩyî Ôvârí rõ ꞌbá kô rî yî drí. Ôvârí lẽ ãnî drí õjílã lẽlé ndrĩ ãnî ạ̃jú-ꞌbá-ãzí yí bê ndrĩ. ꞌDĩî rî, tã gólĩyî má drí ꞌẽꞌá âꞌdálâ ãnî drí rî, ĩꞌdî nĩ ꞌê kpá gólĩyî rĩ ꞌbá ãnî îkpókpólõlé rî yî drí. ");
INSERT INTO avu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tã õnjí ꞌbá ꞌê ĩyíkâ tã tãndí ĩꞌdî õjílã drí, tãlâ gólĩyî lẽ ĩyíkâ kpá ólôgõ ró tã tãndí ĩyíkâ ꞌdĩ võ lâ ĩyî drí. Gõꞌdá ãnî, nĩ ꞌê kpá tã tãndí ĩꞌdî õjílã gólĩyî îcá ꞌbá tã tãndí võ lôgõlé ãnî drí kô rî yî drí. ");
INSERT INTO avu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tã õnjí ꞌbá yî fẽ ĩyíkâ lãfâ cé õjílã gólâ îcá ꞌbá võ lâ lôgõlé ĩyî drí rî ꞌbá yî drí. Gõꞌdá Ôvârí kĩ, nĩ fẽ ngá kpá õjílã gólâ îcá ꞌbá ngá ãníkâ ꞌdĩ võ lâ lôgõlé kô rî yî drí. ");
INSERT INTO avu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","Nĩ ꞌê tã tãndí kpá õjílã drí ndrĩ. Õzõ nĩ õꞌê trá ĩtí rî, õjílã ãâꞌdô kĩꞌá nĩ rî, ãnî âꞌdô õzõ ãnî átá Ôvârí kâtí, ãnî rú âꞌdô lı̣̂kúꞌá. Ãnî átá Ôvârí rî sı̣́ rĩꞌá ĩvĩ õjílã drí ndrĩ, gólâ rî õjílã âyélé tã õnjí ĩyíkâ ꞌásĩ. Nĩ trõ lârâkô ãnî átá Ôvârí kâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nĩ ꞌê ꞌdásí tã kĩzó ányâ ró õjílã ãzí rú kô, Ôvârí õzó kpá ꞌẽlâ ãnî drí. Nĩ âyê tã õnjí ãnî ãzí-ãzí yî drí ꞌẽlé ãnî drí rî, Ôvârí õgõ ró tã õnjí ãníkâ rî âyélé. ");
INSERT INTO avu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nĩ fẽ ngá ãnî ãzí-ãzí yî drí nyãlé lı̣̃fı̣́ âmbé ãkó, tãlâ Ôvârí âꞌdô kpá võ lâ lôgõꞌá ãnî drí lı̣̃fı̣́ âmbé ãkó lậvũlı̣́ gạ̃rạ̃.” ");
INSERT INTO avu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“Lı̣̃fı̣́ ãkó lé ꞌbá sê lı̣̃fı̣́ ãkó lé ꞌbá kpá bê yã? ꞌÉꞌẽ gólĩyî kpạ̃rạ̃tı̣́ âꞌdô ĩyî ꞌdẽꞌá ꞌbú ꞌá. Nĩ ꞌdê kô lı̣̃fı̣́ îcí ꞌbá õnjí vó, gólâ rĩꞌá õzõ lı̣̃fı̣́ ãkó lé ꞌbá kâtí. ");
INSERT INTO avu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Õzõ ãnî ífífí ãꞌdô trá lı̣̃fı̣́ îcí ꞌbá ró rî, nĩ nı̣̃ tãndí ró kĩ nĩ rî, ꞌdĩyímvá ãnî drí rĩꞌá lı̣̃fı̣́ lâ yî îcílí rî âꞌdô ĩyî ãnî lârâkô trõꞌá ĩꞌdî. Lı̣̃fı̣́ îmbá ꞌbá õnjí âꞌdô ꞌdĩyímvá ĩyíkâ îmbáꞌá kpá õnjí tẽtẽ ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Õzõ nĩ õlẽ kô ꞌdásí ꞌẽlé ãzí-ãzí rú rî, nĩ âtâ tã ãzí-ãzí drí kĩꞌá nĩ rî, gólĩyî âꞌdô õnjí rî kô. Nĩ õꞌê trá ĩtí rî, ãnî cú tı̣̂ ãcê bê. Tõtõ ãnî drí ạ̃ꞌdı̣́-drı̣̃ ꞌá rî, nĩ kũ zãlô, nĩ gõ ró tõtõ ãnî ãzí-ãzí yí kâ rî tã lâ âtálé. Nĩ ndrê tã ꞌẽꞌẽ ãníkâ rî zãlô, nĩ gõ ró ãnî ãzí-ãzí yí kâ rî tã lâ âtálé.” ");
INSERT INTO avu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yésũ âtâ úlı̣́ mãnĩgõ ãzâ kpá trá kĩ nĩ rî, “Fê tãndí ꞌwá lõꞌwâ õnjí kô. ");
INSERT INTO avu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gõꞌdá mã nı̣̃ fê lârâkô tãndí ró rî lõꞌwâ lâ sĩ, õzõ nĩ õndrê lõꞌwâ lâ trá rî, nĩ kĩ nĩ rî, nõô rî fê ꞌdĩ ĩꞌdî. Tã âꞌdâ-âꞌdâ lâ rĩꞌá nõtí, ãꞌdî ôkî íyíkâ kạ̃nı̣́kı̣̃ lõꞌwâ ólófí fê drı̣̃ı̣̂ sĩ rî nĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Úlı̣́ mãnĩgõ ámákâ nõ rî tã ífí lâ rĩꞌá nõtí, õjílã tãndí rî kpá té tã tãndí ꞌẽlé ĩꞌdî, gõꞌdá rî kpá úlı̣́ tãndí âtálé ĩꞌdî yí sı̣́lı̣́ sĩ. Õjílã õnjí rî íyíkâ kpá té tã âfõ ꞌbá ndrĩ gólâ ꞌásĩ õnjí tẽtẽ ró rî ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ãnî ãzâ ꞌbá yî, nĩ rî kárá ámâ zı̣̃lı̣́ kúmú kúmú, gõꞌdá nĩ ró tã ámákâ kô. ");
INSERT INTO avu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Õjílã gólâ úlı̣́ ámákâ rõ ꞌbá rî rĩꞌá õzõ ãgô ãzâ gólâ ꞌbú ꞌdı̣̃ ꞌbá kạ̃ạ́lũ jó íyíkâ ꞌdı̣̃zó gá lũtú drı̣̃ı̣̂ ı̣̃nyạ́kú tãndí ꞌá rî kâtí. Tãlâ gbõ lé ôzê ũꞌdı̣̂ trá kạ̃gũmạ́ạ̃ bê rõô rî, gõꞌdá lı̣̃mvû drí tı̣̃zó rõô rî, jó ꞌdĩ îcá kô ꞌdẽlé vũdrı̣́, tãlâ úꞌdı̣̂ trá gá lũtú drı̣̃ı̣̂ ı̣̃nyạ́kú tãndí ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gõꞌdá õjílã gólâ úlı̣́ ámákâ ârí ꞌbá cú ĩtí rõ ꞌbá lâ kô rî rĩꞌá õzõ ãgô ãzâ gólâ jó íyíkâ ꞌdı̣̃ ꞌbá võ ãlólẽ ꞌá rî kâtí. Ĩtí rî, gõꞌdá õzõ ôzê ũꞌdı̣̂ trá kạ̃gũmạ́ạ̃ bê rõô rî, gõꞌdá lı̣̃mvû drí tı̣̃zó rõô rî, jó ꞌdĩ âꞌdô ꞌẽꞌá ꞌdẽlé, drílâ rû îzãzó.” ");
INSERT INTO avu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gõꞌdá Yésũ ndẽ bê úlı̣́ ꞌdĩ ꞌbá yî âtâ-âtâ lâ ndrĩ rî, drílĩyî gõzó nĩlí gõlé Kãpẽrãnómã ꞌálâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tólâ rî, ãgô ãzâ rĩꞌá, gólâ drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá Rómã kâ rî ꞌbá yí kâ ꞌî. Rû ı̣̂ꞌbũ ꞌbá gólâkâ bê ꞌbã ꞌálâ ngá lãzé bê, ãnyî ꞌẽꞌá drãlé. Gólâ lẽ rû ı̣̂ꞌbũ ꞌbá íyíkâ ꞌdĩ tã lâ trá rõô. ");
INSERT INTO avu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Gõꞌdá ârî bê kĩꞌá nĩ rî, Yésũ âcâ trá rî, gólâ drí õjílã Yúdạ̃ yí kâ sı̣́sı̣́-lésĩ rî jõzó Yésũ ngálâ gólâ ẽêdê ró rû ı̣̂ꞌbũ ꞌbá ꞌdĩ bê ꞌbãlé tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gõꞌdá õjílã gólĩyî sı̣́sı̣́-lésĩ ꞌdî ꞌbá yî âcâ ĩyî bê Yésũ ngálâ rî, drílĩyî tã âtázó Yésũ drí kĩ nĩ rî, “Ní ânĩ rû ı̣̂ꞌbũ ꞌbá ãgô nã kâ nã pãlé, tãlâ ãgô nã rĩꞌá ãgô tãndí ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Gólâ âꞌdó õrĩ ãmákâ rî ꞌásĩ kô. Gõꞌdá ní ndrê drẽ, gólâ âfẽ lãfâ trá ãmâ drí jó tã ârî kâ ꞌdı̣̃zó.” ");
INSERT INTO avu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Gõꞌdá Yésũ drí ngãzó nĩlí õjílã sı̣́sı̣́-lésĩ ꞌdî ꞌbá yí bê drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ꞌdĩ drí ꞌbã ꞌálâ. Gõꞌdá câ ĩyí bê ãnyî rî, drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ꞌdĩ drí õjílã ãzâ ꞌbá yî jõzó, nĩꞌá Yésũ rî ûsúlı̣́ pávó ꞌá tã âtî-âtî ãzâ bê kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá, nî rĩꞌá ãgô ãmbá ꞌî. Îcá kô ní drí ânĩzó ánî îkpókpólõlé âcázó bũúũ má drí ꞌbã ꞌá nõlé. ");
INSERT INTO avu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mâ ámákâ nõ áyábálá ꞌî, má jô cé tã ĩꞌdî ní drí, ní âtâ ró tã tólâ sĩ, ngá lãzé ãâyê ró rû ı̣̂ꞌbũ ꞌbá ámákâ nõ. ");
INSERT INTO avu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Má nı̣̃ tã gólâ drı̣́-ãcê kâ ꞌdĩ trá, mâ rĩꞌá drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ꞌî, má rî kpá tã õjílã gólâ sı̣́sı̣́-lésĩ má drí rî kâ rõlé. Gõꞌdá gólĩyî ꞌbã ꞌbá má zẽlé rî ꞌbá yî rô ĩyî kpá tã ámákâ rî, õzõ má ãâtâ gólĩyî drí kĩ nĩ rî, gólĩyî õnĩ rî, âꞌdô ĩyî nĩꞌá, õzõ má õkĩ nĩ rî, gólĩyî ãânĩ rî, âꞌdô ĩyî kpá ânĩꞌá. Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ámákâ rî ꞌbá yî rî ĩyî kpá ámâ rõlé kpá ĩtí. Õzõ ní ãâtâ cé tã ĩꞌdî tólâ sĩ rî, má nı̣̃ trá, gólâ âꞌdô ꞌbãꞌá tãndí ró.” ");
INSERT INTO avu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Gõꞌdá Yésũ ârílí bê tã ãgô ãmbá drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ꞌdĩ kâ rî, gólâ lârõ trá kĩ nĩ rî, “Ãgô ꞌdĩ lẽ tã trá tã pạ̃tı̣́ı̣̃ ró, mbârâkã ámákâ trá kôrô.” Gõꞌdá Yésũ drí tã âtázó õꞌbí ãmbá âꞌdé ꞌbá yí vósĩ ꞌdî ꞌbá yî drí kĩ nĩ rî, “Õjílã gólĩyî õrĩ ãmákâ Ĩsĩrãꞌélẽ kâ rî ꞌá rî, tã lẽlẽ gólĩyíkâ Ôvârí ꞌá rî âꞌdó rõô té õzõ ãgô nõ kâ rî tí kô.” Yésũ ꞌê trá té õzõ drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ ꞌdĩ drí âtálé rî tí. Gólâ ꞌê rãtáã trá Ôvârí drí rû ı̣̂ꞌbũ ꞌbá ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ꞌDĩî vósĩ rî, õjílã gólĩyî tíbê ânĩ ꞌbá drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ nõ drí ꞌbã lésĩ rî, gõꞌdá gõ ĩyî bê ꞌbã ꞌálâ rî, ûsû ĩyî rû ı̣̂ꞌbũ ꞌbá tíbê ngá lãzé bê ꞌdĩ ngâ trá ngá lãzé ꞌásĩ trá tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ꞌDĩî rî vósĩ rî, Yésũ drí ngãzó nĩlí ꞌbạ̃drı̣̃ mvá ãzâ rĩꞌá zı̣̃lâ Nánã rî ꞌálâ. Gõꞌdá tã ârí ꞌbá gólâkâ ꞌdĩ ꞌbá yî õꞌbí ãmbá ꞌdĩ ꞌbá yí bê ꞌdê trá zãâ gólâ vósĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Gólâ õtírĩ cãâ ãnyî ꞌbạ̃drı̣̃ mvá nã ꞌá rî, ûsû ĩyî rû trá õjílã õꞌbí ãzâ ꞌbá yí bê, ânĩꞌá ĩyî ꞌbạ̃drı̣̃ nã lésĩ ágámvá ãzâ ãvõ lâ bê, nĩꞌá ꞌbãlâ ꞌbú ꞌá. Ágámvá ꞌdĩ útı̣̂ gólâ kó ĩꞌdî élêwálâ ꞌdĩ, átá lâ drã trá. Ândrê lâ gõꞌdá ĩꞌdî ạ̃yı̣́zı̣́ ró. ");
INSERT INTO avu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kúmú Yésũ ndrê bê ĩtí rî, gólâ trá tã ı̣̂sũ-ı̣̂sũ ró õkó ạ̃yı̣́zı̣́ ró nõ ĩzã lâ drí. Gólâ drí tã âtázó õkó ạ̃yı̣́zı̣́ ró ꞌdĩ drí kĩ nĩ rî, “Óõ ámâ ândré, ní ngô ãwô kô.” ");
INSERT INTO avu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Drílâ gõzó íyî drı̣́ tı̣̃lı̣́ gbãrãkã ãvõ njı̣̃zó ꞌdĩ rú. Õjílã gólĩyî tíbê rĩ ꞌbá ãvõ njı̣̃lı̣́ ꞌdĩ ꞌbá yî drí âdrézó ãvõ bê. Drílâ tã âtázó ãvõ ꞌdî drí kĩ nĩ rî, “Nî, ní ngâ ûrû õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ãvõ drí gõzó ngãlé ûrû rĩꞌá úlı̣́ âtálé õjílã drí. Yésũ drí mvá nõ îngázó âsézó lâ ândrê lâ ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Õjílã tı̣̂ drí ậꞌdı̣́zó ndrĩ ꞌdó, drílĩyî ãwô-ĩtí ãmbá ꞌẽzó Ôvârí drí. Õjílã ãzâ ꞌbá yî kĩ nĩ rî, “Ãgô gólâ Yésũ nõ rĩꞌá pạ̃tı̣́ı̣̃ õzõ tã ậngũ ꞌbá kâtí cú mbârâkã bê.” Ãzâ ꞌbá yî drí tã âtázó kĩ nĩ rî, “Ôvârí lẽ ꞌbạ̃súrú ãmákâ nõ trá kôrô, tãlâ gólâ âjô ãgô gólâ Yésũ nõ trá ãmá drí.” ");
INSERT INTO avu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tã gólâ Yésũ drí ꞌẽlé nõ rî lậꞌbû trá võ ꞌásĩ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rĩꞌá drẽ gạ̃nı̣́mạ̃ ꞌálâ. Gólâ ârî bê tã lârâkô ãmbá Yésũ drí rĩꞌá ꞌẽlâ ꞌdĩ ꞌbá yî tã ârí ꞌbá yî rî gógó kâ rî sı̣́lı̣́ sĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","20","gólâ jô võrã ꞌbá yî trá rı̣̃ nĩꞌá Yésũ ngálâ võrã bê. Võrã ꞌbá rı̣̃ ꞌdî ꞌbá yî îjî ĩyî Yésũ trá tã Yõwánĩ drí âtálé rî sĩ kĩ nĩ rî, “Nî õjílã gólâ ꞌẽꞌá âjólâ ꞌdíyî pã ꞌbá ró rî ĩꞌdî, ngãtá mã õtẽ drẽ õjílã ãzâ ngĩî lâ ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Võrã ꞌbá ꞌdĩ ꞌbá yî õtírĩ âcá rî, ûsû ĩyî Yésũ rĩꞌá õjílã ãzâ ꞌbá yî êdéꞌá dũû, kpá rĩꞌá õjílã ãzâ ꞌbá yî lı̣̃fı̣́ lâ êdéꞌá võ ndrẽlé, gõꞌdá kpá gólĩyî líndrí õnjí bê rî înjíꞌá ꞌbãlé tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yésũ drí tã âtázó võrã ꞌbá Yõwánĩ kâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ gõ vólé Yõwánĩ ngálâ, nĩ gõ ró ngá gólâ tíbê ãnî drí ndrẽlé nõlé nõ ꞌbá yî tã lâ âtálé Yõwánĩ drí. Nĩ âtâ gólâ drí, má ꞌbã õjílã lı̣̃fı̣́ ãkó lé ꞌbá trá võ ndrẽlé ngbángbá, õjílã gólĩyî õŋõ ró rî ꞌbá yî trá ậcı̣́ tõlé tãndí ró, gõꞌdá õjílã ãrí bê rî ꞌbá yî rúꞌbạ́ lâ êdê rû trá ngbángbá, õjílã bı̣́-ꞌbálé lâ drí ậsı̣̃lı̣́ rî trá tã âríꞌá, õjílã drã ꞌbá rî ꞌbá yî ngâ ĩyî trá õdrã ꞌásĩ, gólĩyî ngá ãkó lé ꞌbá ûsû ĩyî úlı̣́ tãndí trá má tı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ĩtí rî, nĩ âtâ Yõwánĩ drí, mâ ĩꞌdî âjólé trá Ôvârí ngá lésĩ ꞌdíyî pã ꞌbá ró, gólâ õrî zãâ tã lẽlé ĩꞌdî má ꞌá. Nĩ ndrê drẽ, gbõ lé tã gólĩyî má drí ꞌẽlé rî ꞌbá yî õꞌbã õjílã dũû nĩ ámâ gãlé dó rî, Ôvârí âꞌdô õrẽ fẽꞌá õjílã gólĩyî ámâ gã ꞌbá kô tã ꞌdî ꞌbá yî tãsĩ rî ꞌbá yî drí.” ");
INSERT INTO avu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gõꞌdá võrã ꞌbá rı̣̃ ꞌdî ꞌbá yî gõ ĩyî bê vólé rî, Yésũ îtónã trá tã âtálé õꞌbí ãmbá âꞌdé ꞌbá gólâ vó ꞌdĩ ꞌbá yî drí. Âtâ tã trá gólĩyî drí kĩ nĩ rî, “Tã Yõwánĩ kâ rĩꞌá nõtí. Nĩ nĩ ndrĩ Yõwánĩ rî ârílí õmã ꞌálâ ꞌdĩ ãꞌdô tãsĩ yã? Nĩ nĩ ndrĩ õjílã gólâ mbârâkã ãkó õzõ õmã ĩlî drí ꞌẽꞌá bı̣̃lâ vũdrı̣́ rî kâtí rî ndrẽlé yã? ꞌÉꞌẽ, âꞌdó ĩtí kô. ");
INSERT INTO avu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngã gõꞌdá nĩ nĩ Yõwánĩ rî ârílí õmã ꞌálâ nõ rî, tãlâ drílâ ꞌbãzó õjílã ngá-drı̣̃ ãmbá bê, ítá sũ ꞌbá tãndí ró rî bê rî drí sĩ yã? ꞌÉꞌẽ! Âꞌdó kpá ĩtí kô, tãlâ õjílã gólâ ngá-drı̣̃ ãmbá bê rî rí õmã ꞌá kô. Õjílã gólâ ngá-drı̣̃ ãmbá bê rî, rî ĩyíkâ jạ̃rı̣́bạ̃ ꞌálâ jó ạ́ngı̣́ ạ́ngı̣́ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nĩ nĩ Yõwánĩ rî ndrẽlé, tãlâ nĩ lẽ tã trá kĩ, gólâ ĩꞌdî tã ậngũ ꞌbá ꞌî Ôvârí ngá lésĩ. Tãndí ró, Yõwánĩ lậvũ gạ̃rạ̃ tã ậngũ ꞌbá ãzâ ꞌbá yî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yõwánĩ ĩꞌdî tíbê Ôvârí drí tã lâ âtálé tã ậngũ ꞌbá Mãlákĩ sı̣́lı̣́ kĩꞌá nĩ rî, ‘Ôvârí kĩ nĩ rî, yí âbí lãjóꞌbá íyíkâ jõꞌá sı̣́sı̣́, nĩꞌá ámâ tã âtálé sı̣́sı̣́ õjílã drí, má âcâ ró bê ûsúlâ njãâ.’ ” ");
INSERT INTO avu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yésũ âtâ trá kĩ nĩ rî, “Õjílã gólĩyî tı̣̃lı̣́ trá ãngó nõ ꞌá bũúũ ãndrõ nô rî ꞌbá yî lãfálé sĩ rî, ãmbã Yõwánĩ kâ ĩꞌdî kôrô gólĩyíkâ drı̣̃ı̣̂ sĩ. Gõꞌdá ãnî gólĩyî lı̣̃fı̣́ ꞌbã ꞌbá má drı̣̃ı̣̂ ꞌdíyî pã ꞌbá ãníkâ ró, ámâ rõlé õzõ Kúmú ãníkâ kâtí rî ꞌbá yî lãfálé ꞌásĩ, õjílã tíbê ꞌbã ꞌbá áyábálá ró ãngó ꞌá nõngá rî, ãmbã lâ âꞌdô ꞌbãꞌá kôrô Yõwánĩ kâ drı̣̃ı̣̂ sĩ kũmũ Ôvârí kâ rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Gõꞌdá õjílã ꞌdî ꞌbá yî ndrĩ ârî tã Yésũ drí âtálé ĩtí ꞌdĩ bê rî, õjílã ndrĩ bélé-bélé ûꞌdú ꞌbá rî ꞌbá yí bê lûyı̣̂ ĩyî Ôvârí trá, tãlâ gólĩyî lẽ tã trá úlı̣́ Yõwánĩ kâ ꞌá. Sı̣́sı̣́ rî, õjílã ꞌdî ꞌbá yî îjî ĩyî tã trá Yõwánĩ tı̣́, gólâ õdã ró lũmvû ĩyî drı̣̃ı̣̂ tã õnjí ĩyíkâ âyézó tã lẽlẽ ĩyíkâ Ôvârí ꞌá rî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gõꞌdá Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá rî yí bê, gã ĩyî trá dó Yõwánĩ drí lũmvû dãlé ĩyî drı̣̃ı̣̂ tã õnjí ĩyíkâ tãsĩ, tãlâ gólĩyî lẽé tã Ôvârí kâ rî kô. ");
INSERT INTO avu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Gõꞌdá Yésũ rî trá zãâ tã âtálé kĩ nĩ rî, “Õjílã ãndrõ nô kâ gólĩyî tã Yõwánĩ kâ lẽ ꞌbá kô rî, gõꞌdá gólĩyî lẽé tã ámákâ kpá kô tã ꞌdî ꞌá rî ĩꞌdî, má âtâ úlı̣́ mãnĩgõ nô gólĩyî tãsĩ. Gólĩyî rĩꞌá nyé õzõ ꞌdĩyímvá gólĩyî vólé gã ꞌbá dó lâvílí ãzí-ãzí lâ yí bê võ ãlô ꞌá rî kâtí. Õzõ ꞌdĩyímvá õcâ ĩyî lậrı̣́ trá rĩzó ậndú tõlé rî, gõꞌdá ãzâ ꞌbá yî õgã trá dó ậndú tõlé rî, drílĩyî tã âtázó kĩ nĩ rî, ‘Mã câ lậrı̣́ ậndú tõzó, gõꞌdá nĩ lẽé ậndú tõlé ãmá bê kô ãꞌdô tãsĩ yã?’ Gõꞌdá õzõ gólĩyî õngô gbõ ãwó lôngó drílĩyî ãwó ngõzó rî, gõꞌdá ãzâ ꞌbá yî õgã kpá dó ãwó ngõlé gólĩyí bê rî, drílĩyî tã âtázó kĩ nĩ rî ‘Nĩ lẽé kpá ãwó ngõlé ãmá bê kô ãꞌdô tãsĩ yã?’ ");
INSERT INTO avu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Nĩ ndrê drẽ, kậyı̣̂ ãwó ngõ kâ sĩ, Yõwánĩ rî bê cú ĩtí nyãsá tãndí nyã ãkó õdrá mvũ ãkó rî, nĩ âtâ kpá kĩ nĩ rî, Yõwánĩ ãâꞌdô cú líndrí õnjí bê. ");
INSERT INTO avu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Gõꞌdá mâ gólâ Ôvârí drí âjólé ûrú lésĩ rî âcâ bê nyãsá nyãlé ãní bê ꞌdũwạ̃, õdrá mvũlı̣́ ãní bê ꞌdũwạ̃ rî, nĩ kĩ nĩ rî, má ãâꞌdô ꞌálé kõ ꞌbá ꞌî, má ãâꞌdô kpá õdrá mvũ ꞌbá ꞌî, má õtrõ õjílã õnjî-õnjî kpá lậmû-ãzíyã ró má drí. ");
INSERT INTO avu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gõꞌdá má kĩ nĩ rî tã ãzâ ĩꞌdî nõ, ãnî õjílã gólĩyî úlı̣́ Yõwánĩ kâ ârí ꞌbá úlı̣́ ámákâ rî bê rî âꞌdô ĩyî nı̣̃ꞌá lâ tã pạ̃tı̣́-pạ̃tı̣̃ ró. Úlı̣́ má drí rĩꞌá âtálâ nõ rî Ôvârí kâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kậyı̣̂ ãzâ rî sĩ rî, Pạ̃rúsı̣̃ ãzâ rú lâ Sĩmónã drí Yésũ rî ậzı̣́zó ânĩlí yí drí ꞌbã ꞌálâ ngá nyãlé õzõ ũmú kâtí. Gõꞌdá Yésũ âcálé bê rî, drílâ ânĩzó rĩlí ãnyî tãrãbízã lạ̃gạ́tı̣́ ngá nyãlé. ");
INSERT INTO avu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gõꞌdá õkó ãzâ rĩꞌá tólâ ãnyî Sĩmónã drí ꞌbã lạ̃gạ́tı̣́. Õkó ꞌdĩ tã ꞌẽꞌẽ lâ sú kô, õjílã ndrĩ zı̣̂ ĩyî gólâ ꞌdó õkó õnjí ró. Õkó ꞌdĩ ârî bê kĩꞌá nĩ rî, Yésũ rĩꞌá ngá nyãꞌá Sĩmónã drí ꞌbã ꞌálâ rî, õkó ꞌdĩ drí mãlãngĩ mvá dõ ı̣̂nı̣̂-ı̣̂nı̣̂ kâ ạ̃jı̣́ bê tũrũ-tũrũ rî âtrõzó kpãâ yí drı̣́gạ́. Dõ ı̣̂nı̣̂-ı̣̂nı̣̂ ꞌdĩ órî gĩlâ lãfâ ãmbá sĩ. Õkó ꞌdĩ drí ânĩzó âfílí jó ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Õkó ꞌdĩ drí rû jãzó Yésũ ũgúlı̣́ lésĩ ró ãwó bê. Gõꞌdá ãwó drílâ rĩꞌá ngõlâ ꞌdĩ rî ı̣̃lı̣́ndrı̣̂ lâ drí Yésũ rî pá ũgúlı̣́ âjízó ndrĩ ꞌbẽlẽkẽtẽ. Gõꞌdá õkó ꞌdĩ drí rĩzó vũdrı̣́ Yésũ rî pá lĩlí íyî drı̣̃-ꞌbí ãcê-ãcê ꞌdĩ sĩ. Õkó ꞌdĩ drí tũ wũzó pẽ pẽ Yésũ rî pá ꞌá, gólâ rî rúmvạ́ ạ̃ậꞌdı̣̂ ndrúndrú, drílâ gõzó dõ ạ̃jı̣́ bê nõ ı̣̂nı̣́lı̣́ Yésũ rî pá ũgúlı̣́ ꞌá õzõ õrẽ fẽrẽ kâtí. ");
INSERT INTO avu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sĩmónã ndrê bê tã õkó ꞌdĩ drí ꞌẽlé ꞌdĩ ĩtí rî, ı̣̂sũ tã trá ãkpã yí ꞌá kĩ nĩ rî, “Ãgô gólâ Yésũ nõ rî âꞌdó tã ậngũ ꞌbá ꞌî kô. Tí gólâ õró ꞌbãâ tã ậngũ ꞌbá ꞌî rî, gólâ nı̣̃ tã ꞌẽꞌẽ õkó ꞌdĩ kâ õnjí ꞌdĩ trá, tí âyé õkó ꞌdĩ âcálé ãnyî yí lạ̃gạ́tı̣́ kô.” ");
INSERT INTO avu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Gõꞌdá Yésũ kĩ nĩ rî Sĩmónã drí rî, “Má lẽ trá tã ãzâ âtálé ní drí.” Sĩmónã kĩ, “Ãwô, ní âtâ.” ");
INSERT INTO avu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yésũ drí úlı̣́ mãnĩgõ âtázó nõtí, “Ãgô ãzâ ꞌbá yî rı̣̃ nĩ ĩyî trá lãfâ zı̣̃lı̣́ ãgô ãzâ tı̣́ sĩ, tí drílĩyî ꞌẽzó lãfâ ꞌdĩ võ lâ lôgõlé. Ãgô ãzâ rî trõ íyíkâ gĩníyã kútũ-njı̣̂, ãzâ rî trõ íyíkâ gĩníyã kámá-njı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Îcá gõꞌdá ãgô ꞌdĩ ꞌbá yî drí lãfâ drílĩyî trõlé ꞌdĩ lôgõzó lı̣́pı̣̂ lâ drí kô. Gõꞌdá lãfâ lı̣́pı̣̂ ꞌdĩ kĩ nĩ rî, ‘Nĩ âyê lãfâ ꞌdĩ nĩ lôgõ má drí gõꞌdá kô.’ Ĩꞌdî ꞌdĩ. Ngbãângbânõ rî, má îjî drẽ nĩ, ãgô ángô rî âꞌdô lãfâ lı̣́pı̣̂ rî lẽꞌá nĩ kôrô íyî ãzí-ãzí drı̣̃ı̣̂ sĩ rî nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sĩmónã lôgõ tã îjî-îjî ꞌdĩ trá Yésũ drí nõtí, “Ãgô gólâ lãfâ trõ ꞌbá gạ̃rạ̃ rî, gõꞌdá lãfâ lı̣́pı̣̂ drí tã âtázó kĩꞌá nĩ rî, gólâ ãâyê õlôgõ lãfâ ꞌdĩ võ lâ yí drí kô rî ĩꞌdî.” Yésũ kĩ, “Tã pạ̃tı̣́ı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sĩmónã, ní ꞌé tã dódó má drí kô, ní dãá lı̣̃mvû ámâ pá ꞌá kô, gõꞌdá õkó ꞌdĩ jĩ ámâ pá trá íyî lı̣̃fı̣́ ı̣̃lı̣́ndrı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gõꞌdá ní âfõó ámâ ĩngílí ndrõlé õzõ lãꞌbí ãmákâ rî tí kô, õkó nõ ndrô ámâ pá mvá trá gạ̃rạ̃ ní drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gõꞌdá ní ı̣̂nı̣́ dõ kô ámâ pá rĩzó dõ ı̣̂nı̣́lı̣́ rî ꞌá kô. Õkó nõ gõꞌdá ânĩ nĩ dõ ı̣̂nı̣́lı̣́ ámâ pá rú. Gõꞌdá dõ ꞌdî ógî rĩꞌá lãfâ ãmbá sĩ. ");
INSERT INTO avu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Má âtâ tã ãzâ ĩꞌdî ní drí nõ. Tã õkó nõ drí ꞌẽlé nõ rî, tãlâ gólâ nı̣̃ trá Ôvârí âyê gólâ trá tã õnjí ãmbá íyíkâ rî ꞌásĩ ndrĩ, tã gólâ drí ámâ lẽzó kôrô rî ĩꞌdî ꞌdĩ. Õzõ õjílã ãꞌdô cé tã õnjí bê fínyáwá ĩtí rî, Ôvârí drí gólâ rî âyézó tã lâ sĩ rî, gólâ âꞌdô Ôvârí rî lẽꞌá kpá cé dãwá ĩtí.” ");
INSERT INTO avu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yésũ drí tã âtázó õkó ꞌdĩ drí kĩ nĩ rî, “Ôvârí âyê nî trá tã õnjí áníkâ tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Gõꞌdá õjílã ãzâ ꞌbá yî rĩ ꞌbá ĩyî ngá nyãlé Yésũ yí bê võ ãlô ꞌá ꞌdĩ ꞌbá yî, drílĩyî tã âtázó ĩyî võ ꞌásĩ kĩ nĩ rî, “Ãgô nõ íyíkâ kó ãꞌdî ĩꞌdî yã? Gólâ rî kpá tã õnjí õjílã kâ rî âyélé yã?” ");
INSERT INTO avu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Gõꞌdá Yésũ drí tã âtázó õkó ꞌdĩ drí kĩ nĩ rî, “Ôvârí âꞌdô íyî lı̣̃fı̣́ ꞌbãꞌá ní drı̣̃ı̣̂ ánî pãlé, tãlâ ní lẽ tã ámákâ trá. Ní nĩ, ánî rúꞌbạ́ ạ̃ậꞌdı̣̂ ndrúndrú.” ");
INSERT INTO avu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Gõꞌdá ꞌdĩî rî vólé drı̣̃ lâ ꞌásĩ rî, Yésũ yî nĩ ĩyî trá lậmú bê ꞌbạ̃drı̣̃ mvá õnyíkõ ꞌdî ꞌbá yî ꞌásĩ ndrĩ, nĩꞌá tã tãndí âtá bê õjílã drí tã kũmũ Ôvârí kâ rî kâ tãsĩ. Lãjóꞌbá gólâkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî nĩ ĩyî kpá trá lậmúlı̣́ gólâ bê. ");
INSERT INTO avu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Gõꞌdá õkó ãzâ ꞌbá yî dũû ꞌdê ĩyî trá nĩlí gólĩyí bê. Õkó ꞌdĩ ꞌbá yî, ãzâ ꞌbá yî Yésũ êdê trá ngá lãzé ꞌásĩ. Gõꞌdá ãzâ ꞌbá yî, Yésũ drô líndrí õnjí trá ꞌá lâ yî sĩ, õzõ Mãríyã Mãgãdálã gólâ Yésũ drí líndrí õnjí drõzó ꞌá lâ sĩ njı̣̂-drı̣̃-lâ-ngâ-rı̣̃ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Gõꞌdá õkó ãzâ ꞌdĩ íyíkâ Kózã rî õkó ĩꞌdî, rú lâ Jõánã. Kózã ꞌdĩ rĩꞌá drı̣̃-ꞌbá rû ı̣̂ꞌbũ ꞌbá kúmú Ẽródẽ kâ rî ꞌbá yí kâ ĩꞌdî. Gõꞌdá õkó ãzâ kpá tólâ, rú lâ Sõzánã. Gõꞌdá õkó ꞌdĩ ꞌbá yî rî trá ndrĩ lãfâ ĩyíkâ fẽlé ngá nyãnyã gĩzó gólĩyî drí nyãlé. ");
INSERT INTO avu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nĩngá sĩ, õjílã êꞌbê rû trá ꞌdó ndrĩ võ ãlô ꞌá. Õjílã ânĩ trá ꞌbạ̃drı̣̃ mvá ãmbá nõ ꞌbá yî ꞌásĩ ndrĩ ꞌdó úlı̣́ Yésũ kâ ârílí. Gõꞌdá gólâ âtâ tã trá drílĩyî úlı̣́ mãnĩgõ sĩ nõtí kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ạ́mvú ꞌwã ꞌbá ãzâ nĩ trá ạ́mvú ꞌálâ. Drílâ órĩ rĩzó. Órĩ ãzâ ꞌbá yî lôwã trá ꞌdẽlé lạ́tı̣̂ lı̣̃fı̣́ ꞌá, gõꞌdá õjílã rî trá lậmúlı̣́ drı̣̃ lâ sĩ, úkũú ı̣̃nyạ́kú drı̣̃ lâ kô, ãríwá ânĩ trá nyãlâ vólé. ");
INSERT INTO avu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gõꞌdá órĩ ãzâ ꞌbá yî ꞌdê ĩyíkâ trá rõvõ drı̣̃ı̣̂, âfõ trá. Gõꞌdá nĩngá sĩ rî, ı̣̃tú âfõ bê kãlé rî, drílâ ngá-ạ̃rú lâ ꞌdĩ zãzó, drílâ drãzó kpá vólé. ");
INSERT INTO avu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gõꞌdá órĩ ãzâ ꞌbá yî lôꞌdê ĩyíkâ ãsõpá ngbũkpũ rî ꞌbá yî lãfálé ꞌá. Ĩtí rî, drílĩyî âfõzó mbãlé tãndí ró. Gõꞌdá ãsõpá ꞌdĩ ꞌbá yî drí ạ̃rú lâ ꞌdĩ ꞌbá yî võzó, drílĩyî drãzó. ");
INSERT INTO avu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gõꞌdá órĩ ãzâ drí ĩyíkâ ꞌdẽzó ı̣̃nyạ́kú tãndí ãzâ rũꞌbũ-rũꞌbũ lâ ꞌá. Drílâ âfõzó íyíkâ tãndí ró, pá fã bê kõdõngbõ ĩtí. Drílâ fõzó ꞌwãlé cõkpõ-cõkpõ pá fã ãlô ꞌdĩ sĩ, ífí bê kũrũgbũ.” Gõꞌdá gólâ âtâ tã trá õꞌbí ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ãnî, nĩ ı̣̂sũ úlı̣́ ámákâ ꞌdĩ vólé drı̣̃ lâ tãndí ró, nĩ ꞌbã ró ãnî drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Gõꞌdá ꞌdĩî rî vósĩ rî, lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí tã âtázó gólâ rî îjízó kĩ nĩ rî, “Úlı̣́ mãnĩgõ áníkâ âtálé nõ tã ífí lâ ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Drílâ tã-drı̣̃ lôgõzó kĩ nĩ rî, “Ónyĩ ãnî nyãányâ trá, tãlâ tã Ôvârí kâ gólâ drí lậpı̣́lı̣́ õjílã ãzâ ꞌbá yî drí sĩ tã tíbê gólâ drí õjílã ꞌbãzó rĩlí kũmũ íyíkâ zẽlé rî tãsĩ rî áâꞌdâ ró bê ãnî drí. Gõꞌdá õjílã gólĩyî tíbê tã lâ lẽ ꞌbá kô rî, gólĩyî ârî ĩyî úlı̣́ mãnĩgõ má drí rĩꞌá âtálâ rî trá. ‘Ĩtí rî, gólĩyî âꞌdô tã Ôvârí kâ ndrẽꞌá té ĩyî lı̣̃fı̣́ sĩ cú ĩtí ĩtõ lâ nı̣̃ ãkó. Gõꞌdá gólĩyî âꞌdô kpá Ôvârí rî gbórókõ âríꞌá ĩyî bı̣́ sĩ cú ĩtí tã ífí lâ nı̣̃ ãkó.’ ");
INSERT INTO avu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Úlı̣́ mãnĩgõ má drí âtálé nõ, tã ífí lâ rĩꞌá nõtí. Órĩ ꞌdî ꞌbá yî âꞌdô trá õzõ tã tíbê Ôvârí drí rĩꞌá âtálâ ãnî drí rî tí. ");
INSERT INTO avu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lạ́tı̣̂ lı̣̃fı̣́ ꞌdĩ rî íyíkâ õzõ õjílã gólâ úlı̣́ Ôvârí kâ ârí ꞌbá trá rî tí, gõꞌdá Sãtánã drí îzãzó lâ vólé pı̣̃pı̣̂sı̣́lı̣́ lâ ꞌásĩ, gólâ lẽé gõꞌdá tã Ôvârí kâ rî kô, Ôvârí pá gõꞌdá gólâ tã õnjí gólâkâ rî ꞌásĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Rõvõ drı̣̃ı̣̂ ꞌdĩ íyíkâ õzõ õjílã gólâ úlı̣́ Ôvârí kâ ârí ꞌbá trá fí dódó, gõꞌdá gólâ cé tã lẽlẽ fínyáwá bê Ôvârí ꞌá. Õzõ lâŋõ ãzâ õtírĩ gólâ rî ûsú rî, drílâ tã Ôvârí kâ ꞌdĩ âyézó vólé ꞌwãâ. ");
INSERT INTO avu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Órĩ gólâ ꞌdẽ ꞌbá ãsõpá ngbũkpũ lãfálé ꞌá rî, ꞌdĩî rĩꞌá õjílã gólâ tã âtî-âtî tãndí Ôvârí kâ ꞌdĩ ârí ꞌbá dódó gõzó tã lẽlé ꞌá lâ. Gbõ lé ĩtí rî, gólâ rĩꞌá tã ı̣̂sũ bê rõô ngá gólĩyî ãngó nõ ꞌá nõ ꞌbá yî tãsĩ. Ĩtí rî, gólâ lẽ yí drí ꞌbãlé ngá-drı̣̃ ãmbá nõ ꞌbá yí bê gạ̃rạ̃. Gõꞌdá ꞌdĩî vósĩ rî, tã ꞌẽꞌẽ ãngó nõ kâ ômbê gólâ trá ngạ́rạ́-ngạ́rạ́, gólâ îcá tã tãndí ꞌẽlé dódó kô tã õnjí âyézó. ");
INSERT INTO avu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ị̃nyạ́kú gólâ tãndí ró rũꞌbũ-rũꞌbũ ꞌdî rî, íyíkâ õjílã gólĩyî tíbê úlı̣́ Ôvârí kâ ârí ꞌbá rõzó lâ rî ꞌbá yî ĩꞌdî. Gólĩyî rî trá zãâ tã lẽlẽ bê Ôvârí ꞌá ꞌálé ı̣̂dû-ı̣̂dû sĩ rî, gólĩyî rî ĩyíkâ zãâ tã tãndí ꞌẽꞌẽ sĩ Ôvârí drí. Tã tãndí drílĩyî rĩꞌá ꞌẽlâ ꞌdĩ âꞌdô âꞌdóꞌá õzõ ạ̃drúgú gólâ ꞌwã ꞌbá ífí bê cõkpõ-cõkpõ lı̣̃fı̣́ bê kũrũgbũ nâ kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","18","Yésũ kĩ nĩ rî, “Õzõ má drí rĩꞌá âtálâ ãnî drí rî tí, má rî bê ãnî lı̣̃fı̣́ îcílí úlı̣́ mãnĩgõ sĩ rî, õjílã ãmbá nı̣̃ı̣́ ĩyî tã ífí lâ kô. Gõꞌdá ĩꞌdî nõ kậyı̣̂ lâ trá ꞌẽꞌá âcálé ĩꞌdî nõ õjílã ndrĩ drí tã ífí lâ yî nı̣̃zó dódó. Tã îmbâ-îmbâ ámákâ íyíkâ rĩꞌá õzõ lámbã îꞌĩ-îꞌĩ kâtí. Õjílã ãzâ îꞌĩ lámbã íyíkâ bê drı̣̃ lâ âkólé límvó sĩ ngã ꞌbô lậpı̣́lı̣́ gbãrãkã zẽlé yã? Âꞌdó ĩtí kô. Õjílã ndrĩ rî lámbã îꞌĩlí ꞌbãlé tãrãbízã drı̣̃ı̣̂ jó ꞌá. Õjílã õtírĩ fĩî jó ꞌálâ rî, drílâ ndrẽzó lâ tõ. Kpá ĩꞌdî ĩtí, kậyı̣̂ trá ꞌẽꞌá cãlé õjílã drí tã îmbâ-îmbâ ámákâ nı̣̃zó dódó. Ãnî lãjóꞌbá ámákâ rî ꞌbá yî âꞌdô ꞌbãꞌá lâ nĩ õjílã drí nı̣̃lı̣́ tãndí ró. Âꞌdô ꞌbãꞌá kpá ĩtí, nĩ âꞌdô tã ámákâ rî âríꞌá nĩ îmbálé õjílã ãzí drí. Õzõ nĩ õꞌê trá ĩtí rî, má âꞌdô tã nı̣̃nı̣̃ ãníkâ lôpéꞌá tã ámákâ rî ꞌá. Gõꞌdá õzõ nĩ õgã trá dó ârílâ rî, tã tã nı̣̃nı̣̃ ꞌdî tãsĩ rî âꞌdô ậvı̣̃ꞌá ãnî drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gõꞌdá ꞌdĩî rî vósĩ rî, Yésũ rî ândré, gólâ rî ậdrúpı̣̃ yí bê âcâ ĩyî trá, ꞌẽꞌá gólâ rî ndrẽlé. Gõꞌdá nĩngá sĩ rî, gólĩyî îcá kô ânĩlí ãnyî gólâ rú, tãlâ õꞌbí ãmbá ꞌdĩ ꞌbá yî drí sĩ. ");
INSERT INTO avu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Drílĩyî gõzó õjílã jõlé ĩꞌdî gólâ rî ậzı̣́lı̣́ ĩyî ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Gõꞌdá gólâ ârílí bê tã kĩꞌá nĩ rî, íyî ândré yî, íyî ậdrúpı̣̃ yí bê, lẽ ĩyî íyî ndrẽlé rî, drílâ gõzó tã âtálé nõtí kĩ nĩ rî, “Tã pạ̃tı̣́ı̣̃ ró rî, má lẽ ámâ ândré yî ámâ ậdrúpı̣̃ yí bê. Gõꞌdá õjílã gólĩyî úlı̣́ ámákâ ârí ꞌbá kpá rõzó lâ rî, gólĩyî kpá ámâ ândré yî ĩꞌdî ámâ ậdrúpı̣̃ yí bê.” ");
INSERT INTO avu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kậyı̣̂ ãzâ sĩ rî, Yésũ âtâ tã trá lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Mã mbã lı̣̃mvû ândrê nõ drı̣̃ı̣̂ sĩ ꞌáꞌá ꞌálâ.” Drílĩyî gõzó mbãlé kõlóngbõ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Gõꞌdá gólĩyî drí îtõzó trá ꞌẽꞌá mbãlé ꞌáꞌá ꞌálâ rî, Yésũ õkô trá lâŋõ ãmbá õꞌbí kâ ꞌdĩ ꞌbá yî drí, gólâ ꞌdê trá ậꞌdú bê kõlóngbõ ꞌá kĩní-kĩní. Gõꞌdá nĩngá sĩ rî, kạ̃gũmạ́ạ̃ ândrê drí ânĩzó rĩꞌá vı̣̃lı̣́. Gõꞌdá kõlóngbõ bí íyîngá ꞌẽꞌá fĩlí lı̣̃mvû zẽ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí gólâ rî ôlózó ậꞌdú ꞌásĩ kĩ nĩ rî, “Ãmâ lı̣́pı̣̂, ní ngâ, ãmâ trá ꞌẽꞌá drãlé nõ.” Gólâ drí lı̣̃fı̣́ njı̣̃zó tã âtálé lı̣̃mvû ãmbá tı̣̃ ꞌbá kạ̃gũmạ́ạ̃ bê ꞌdĩ drí rĩzó tı̣́tı̣́. Gõꞌdá kôrô kạ̃gũmạ́ạ̃ ândrê ãmbá rĩ ꞌbá sı̣̃lı̣́ gõꞌdá lı̣̃mvû gólâ rĩ ꞌbá kõlóngbõ îyálé rî bê drí âdrézó. ");
INSERT INTO avu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Gólâ drí gõzó tã âtálé lãjóꞌbá íyíkâ rî yî drí kĩ nĩ rî, “Tãlâ ãꞌdô ꞌî ãnî drí tã lẽlẽ ãníkâ âyézó yã?” Lãjóꞌbá ꞌdĩ ꞌbá yî, tı̣̂ lâ yî drí ậꞌdı̣́zó gólâ rî mbârâkã drí. Âtâ ĩyî tã trá ĩyî võ ꞌásĩ kĩ nĩ rî, “Ãgô nõ íyíkâ ãꞌdô lâ ꞌî tã âtá ꞌbá kạ̃gũmạ́ạ̃ drí lı̣̃mvû bê drílĩyî âdrézó nõ.” ");
INSERT INTO avu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gõꞌdá nĩngá sĩ rî, Yésũ yî lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê mbã ĩyî lı̣̃mvû ândrê ꞌdĩ drı̣̃ lâ trá ꞌáꞌá lésĩ ró rî, gólĩyî drí nĩzó fõlé võ ãzâ zı̣̃lı̣́ Gẽrãgésã rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Võ ꞌdî ꞌá tólâ rî, ãgô ãzâ rĩꞌá, Sãtánã âjô líndrí õnjí ạ̃bạ̃bạ̃ kâ trá rĩlí ꞌá lâ. Gólâ rĩꞌá jó ãkó gõꞌdá rî íyíkâ rĩ bê ũgı̣́ gólĩyî rĩzó ãvõ ꞌbãlé rî ꞌbá yî ꞌásĩ jẽjẽ ró. Óômbê gólâ trá nyãrĩ sĩ, gõꞌdá rî trá ôkílâ tõwãrĩ-tõwãrĩ vólé. Gólâ rî íyîngá lârá bê õmã ꞌásĩ cú ĩtí ũndú ró. Yésũ âfõ bê kõlóngbõ ꞌásĩ âcálé võ tãkó ꞌálâ rî, ãgô gólâ líndrí õnjí bê ꞌdĩ drí ngãzó ânĩꞌá ôtré bê gbõ ĩtí líndrí õnjí ạ̃bạ̃bạ̃ kâ drí. Gólâ drí ânĩzó ꞌdẽlé ꞌãꞌî sĩ Yésũ ágálé. Yésũ âtâ tã trá líndrí õnjí ꞌdĩ drí âfõzó vólé gólâ ꞌásĩ. Yésũ âtâ bê tã ĩtí líndrí õnjí ꞌdĩ drí rî, líndrí õnjí ꞌdĩ drí gõzó trẽlé gbórókõ ãmbá ãgô ꞌdĩ kâ sĩ kĩ nĩ rî, “Yésũ, Ôvârí ãmbá rî mvá, ní lẽ ãꞌdô ngá ꞌî ãmâ drı̣́gạ́ sĩ yã? Ní îkpókpólõ ãmâ kô, ní îzã ãmâ kô.” ");
INSERT INTO avu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","31","Gõꞌdá nĩngá sĩ rî, Yésũ îjî líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ trá kĩ nĩ rî, “Ánî rú ãꞌdî ĩꞌdî yã?” Líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ lôgõ tã-drı̣̃ trá Yésũ drí kĩ nĩ rî, “Ãmâ rú rĩꞌá Õꞌbígó, tãlâ ãmâ rĩꞌá dũû.” Gõꞌdá líndrí õnjí ꞌdĩ îjî Yésũ trá ândálé ândálé, “Ní ꞌbã ãmâ kô võ õnjí rû îzã kâ ạ̃dũkũ ãkó rî ꞌá. Ní jô ãmâ cé ãnyî.” ");
INSERT INTO avu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ngbíkpí õtólõꞌbĩ ãzâ ꞌbá yî rĩꞌá ĩyî ngá sı̣̃ꞌá nyãlé ãnyî lũtú gãrã ꞌá, gõꞌdá líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ ꞌbá yî îjî tã trá kĩ nĩ rî, “Mã ânĩ fĩlí ngbíkpí ꞌdĩ ꞌbá yî ꞌá. Ní lẽ tã-drı̣̃ trá ãmâ drí yã?” Yésũ lẽ tã-drı̣̃ trá líndrí õnjí ꞌdĩ ꞌbá yî drí, gõꞌdá nĩ ĩyî trá fĩlí ngbíkpí ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gõꞌdá nĩngá sĩ, líndrí õnjí ạ̃bạ̃bạ̃ kâ fî bê ngbíkpí ꞌdĩ ꞌbá yî ꞌá rî, râ ĩyî trá zãâ líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ ꞌbá yí bê õzõ lîfõ-lîfõ kâtí, ãlólẽ lũtú pá ꞌálâ gólókõ ꞌá zãâ lôꞌdélé lı̣̃mvû ꞌá ôdrãlé. ");
INSERT INTO avu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gõꞌdá õjílã gólĩyî rĩ ꞌbá ngbíkpí lôkílí rî, gólĩyî rĩꞌá tólâ. Lôkí ꞌbá ꞌdĩ ꞌbá yî ndrê tã ꞌdî bê ĩtí rî, râ ĩyî trá vólé, nĩꞌá tã âtá bê õjílã drílĩyî ûsúlı̣́ lạ́tı̣̂ ꞌásĩ rî ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Õjílã gólĩyî tã ꞌdî ârí ꞌbá rî ânĩ ĩyî trá ndrĩ tã ꞌdî ndrẽlé cú ĩyî lı̣̃fı̣́ sĩ. Ûsû ĩyî ãgô gólâ líndrí õnjí ạ̃bạ̃bạ̃ kâ drí âfõzó ꞌá lâ sĩ nõ rĩꞌá vũdrı̣́ Yésũ lạ̃gạ́tı̣́, tã Yésũ drí rĩꞌá âtálâ rî âríꞌá. Gõꞌdá ãgô ꞌdĩ trá cú ítá bê yí rú, líndrí õnjí ạ̃bạ̃bạ̃ kâ ꞌdĩ ꞌbá yî âyê gólâ trá zãâ. Tã ı̣̂sũ gólâkâ gõꞌdá trá tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Gólĩyî ꞌbã ꞌbá nĩngá tã ꞌdî ndrẽlé ĩyî lı̣̃fı̣́ sĩ rî, âtâ ĩyî tã Yésũ drí ãgô ꞌdĩ ꞌbãzó tãndí ró ꞌdĩ trá kpá ãzâ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","38","Gólĩyî trá ũrı̣̃ ró ãmbá, âtâ ĩyî tã trá Yésũ drí, õnĩ ró bê nĩngá sĩ vólé. Ãgô ꞌdĩ gõꞌdá âꞌdó kô zãâ líndrí õnjí ạ̃bạ̃bạ̃ kâ bê, lẽ trá zãâ ꞌdẽlé Yésũ vó tã ârí ꞌbá ró. Gõꞌdá Yésũ âtâ trá drílâ nõtí, ");
INSERT INTO avu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ní gõ ní drí ꞌbã ꞌálâ, ní âtâ ró tã Ôvârí drí ꞌẽlé ní drí nõ õjílã drí.” Gõꞌdá nĩngá sĩ rî, ãgô ꞌdĩ nĩ trá, nĩꞌá tã ꞌẽlé yí drí ꞌdĩ âtá bê õjílã drí. Gõꞌdá Yésũ yî lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê mbã ĩyî trá kõlóngbõ ꞌá, nĩꞌá gõlé vólé. ");
INSERT INTO avu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yésũ yî õtírĩ âgõô lı̣̃mvû ândrê nã ꞌáꞌá lé drı̣̃ lâ lésĩ rî, õꞌbí ãmbá rî ĩyî trá gólâ rî tẽlé lậgúlı̣́. ");
INSERT INTO avu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ãgô ãzâ bê rú lâ Yáĩrõ, drílâ ânĩzó Yésũ ngálâ. Yáĩrõ rĩꞌá jó tã ârí kâ vó lâ ndrẽ ꞌbá ꞌî. Yáĩrõ ânĩ trá rĩlí ꞌãꞌî sĩ Yésũ ágálé, îjî gólâ trá ânĩlí yí drí ꞌbã ꞌálâ íyî pãlé, ");
INSERT INTO avu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tãlâ mvá lâ trá ngá lãzé ró, ꞌẽꞌá drãlé. Ízámvá ꞌdĩ ĩꞌdî ãlô ꞌdĩ. Ndrô lâ rĩꞌá mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃. ꞌDĩî ꞌásĩ rî, Yésũ nĩ trá Yáĩrõ rî âjílí ꞌbã ꞌálâ. Gõꞌdá õꞌbí ãmbá ꞌdĩ ꞌbá yî nĩ trá ndrĩ gólâ vósĩ, rú lôzê-lôzê bê gólâ rú sĩ. ");
INSERT INTO avu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Gõꞌdá õkó ãzâ rĩꞌá ngá lãzé bê ndrô mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃, ndẽé rû kô, ngá lãzé ꞌdĩ rî párá ró. Õkó ꞌdĩ rî trá lãfâ îzãlé ãmbá ngá lãzé ꞌdĩ õndẽ ró rû bê. Gõꞌdá õjílã ãzâ ójó ró, ãlókõ ꞌbá ró êdé ꞌbá lâ rî yû. ");
INSERT INTO avu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gõꞌdá õkó ꞌdĩ drí ânĩzó rû âjálé Yésũ ũgúlı̣́ lésĩ ró, ítá tı̣̂ gólâkâ dõlé. Kôrô ngá lãzé ꞌdĩ drí rû ndẽzó. ");
INSERT INTO avu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Gõꞌdá nĩngá sĩ rî, Yésũ drí tã îjízó, “Ãꞌdî dõ mâ nĩ yã?” Gõꞌdá õjílã ndrĩ ꞌdî ꞌbá yî gã ĩyî tı̣̂ trá kĩ nĩ rî, “Mã nı̣̃ı̣́ kô.” Gõꞌdá õjílã ꞌdî ꞌbá yî gã ĩyî tı̣̂ bê ndrĩ rî, Pétẽrõ âtâ tã trá nõtí kĩ nĩ rî, “Ámâ lı̣́pı̣̂, õjílã ndrĩ ꞌdó rĩꞌá ánî ı̣̂pı̣̃ꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gõꞌdá Yésũ kĩ nĩ rî Pétẽrõ drí rî, “Õjílã ãzâ dõ mâ trá, má nı̣̃ trá, má ôtójõ trá bũúũ má rú, ámâ fãfã câ trá gólâ rú.” ");
INSERT INTO avu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Gõꞌdá õkó ꞌdĩ ârílí bê tã gólâ drí âtálé ꞌdĩ rî, gólâ nı̣̃ trá kĩ nĩ rî, Yésũ nı̣̃ yî trá. Kôrô drílâ ânĩzó rĩlí ꞌãꞌî sĩ gólâ ágálé, ũrı̣̃ ãmbá sĩ lẽlẽ ró. Tã gólâ drí Yésũ rî dõzó ẽêdê ró yî bê rî tãsĩ, kpá pạ̃tı̣́ı̣̃ gólâ êdê rû trá. ");
INSERT INTO avu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Gõꞌdá gólâ âtâ trá õkó ꞌdĩ drí kĩ nĩ rî, “Ámâ îzó, ngbãângbânõ rî, nî trá dódó. Tã lẽlẽ áníkâ ꞌbã mâ nĩ ánî êdélé. Ní ngâ ûrû, ní nĩ. Ôvârí ãâꞌdô ní bê.” ");
INSERT INTO avu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Gõꞌdá gólâ drẽ tã âtáꞌá õkó nõ drí rî, lãjóꞌbá ãzâ âcâ kpá trá Yáĩrõ drí ꞌbã lésĩ kĩ nĩ rî, Yáĩrõ rî mvá õdrã trá, îcá kô Yésũ drí ânĩzó. ");
INSERT INTO avu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gõꞌdá Yésũ ârílí bê úlı̣́ ꞌdĩ ĩtí rî, gólâ kĩ nĩ rî Yáĩrõ drí rî, “Ní ꞌê ũrı̣̃ kô, ní lẽ tã-drı̣̃ ámákâ, ánî mvá âꞌdô ngãꞌá âꞌdólé tãndí ró.” ");
INSERT INTO avu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","52","Gõꞌdá gólĩyî ndrĩ nĩ ĩyî trá ꞌdó cãlé Yáĩrõ drí ꞌbã ꞌálâ. Gõꞌdá âcâ ĩyî bê rî, õjílã õꞌbí ãmbá ꞌdĩ ꞌbá yî rĩꞌá ĩyî ꞌdó ãwó ngõꞌá. Gõꞌdá nĩngá sĩ rî, Yésũ lẽ cé Pétẽrõ, Yõwánĩ, Yãkóbã gõꞌdá gbõ mvá rî ândrê mvá rî átá bê fĩlí jó ãwó kâ rî ꞌá yí bê. Gólâ kĩ nĩ rî ãwó ãnjó ꞌbá ꞌdĩ ꞌbá yî drí rî, “Nĩ âyê ãwó, mvá ꞌdĩ drãá kô, gólâ rî íyîngá ậꞌdú kõꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Gõꞌdá õꞌbí ãmbá ãwó ãnjó ꞌbá kâ ꞌdĩ ꞌbá yî gû ĩyî gólâ trá kĩ nĩ rî, “ꞌDĩî tã õnjõ kâ ꞌî, mvá ꞌdĩ drã trá.” ");
INSERT INTO avu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gólâ fî trá jó ꞌálâ, rû mvá ãvõ nô drı̣́ lâ trá, gõꞌdá âtâ tã trá kĩ nĩ rî, “Ízámvá, ní ngâ ûrû.” ");
INSERT INTO avu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kôrô mvá nõ lôvó-lôvó lâ drí âgõzó ꞌá lâ. Drílâ ngãzó õdrã ꞌásĩ. Yésũ âtâ tã trá mvá rî ândrê drí kĩ nĩ rî, “Ní âfẽ ngá nyãnyã mvá nõ drí nyãlé.” ");
INSERT INTO avu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gõꞌdá mvá rî ândrê yî átá lâ yí bê lârõ ĩyî trá ãmbá, tã lârâkô drílĩyî ndrẽlé sı̣́sı̣́ lâ kô ꞌdĩ ꞌá. Yésũ âtâ trá drílĩyî, gólĩyî ãâtâ tã ꞌdî õjílã ãzâ ãlôlâ drí kô. ");
INSERT INTO avu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Gõꞌdá nĩngá sĩ rî, Yésũ zı̣̂ lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî trá ndrĩ yí ngálâ. Gólâ kĩ nĩ rî, “Ngbãângbânõ, má fẽ drı̣́-ãcê ámákâ trá ãnî drí, má fẽ fãfã ámákâ kpá trá ãnî drí, ãnî drí nĩzó líndrí õnjí lâdró bê õjílã ꞌásĩ, kpá rĩzó õjílã gólĩyî ngá lãzé bê rî ꞌbá yî ꞌbãlé ngãlé ngá lãzé ꞌásĩ tãndí ró. Ngbãângbânõ rî, nĩ lânjî tã ꞌdî ꞌbá yî jạ̃rı̣́bạ̃ ꞌásĩ ndrĩ kpá rĩzó õjílã lı̣̃fı̣́ îcí bê tã kũmũ Ôvârí kâ rî kâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nĩ ârî drẽ, nĩ trõ ngá ãzâ kô ãní bê ậcı̣́ ꞌdĩ tõrẽ lâ ꞌá. Tã âꞌdâ-âꞌdâ lâ rĩꞌá õzõ nõô rî tí, ngá tíbê ꞌbã ꞌbá õzõ pı̣̃drı̣́gú, ngá nyãnyã, jõráã ítá ꞌbã kâ, lãfâ rĩzó ngá nyãlé rî ꞌbá yí kâtí rî, nĩ trõ ãní bê kô. ");
INSERT INTO avu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Õzõ nĩ ãâcâ trá ạ̃ꞌdı̣́-drı̣̃ ꞌá rî, ꞌbã-lı̣́pı̣̂ õlậgû ãnî rĩlí yí bê nĩngá rî, nĩ rî gólâ bê cãlé bũúũ kậyı̣̂ gólâ ãnî drí ꞌẽzó ꞌbạ̃drı̣̃ mvá ꞌdĩ âyélé ꞌẽzó nĩlí sı̣́sı̣́ ꞌálâ rî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Õzõ õjílã õlậgû ãnî kô rĩlí yí bê rî, nĩ lậvũ ãnîngá sı̣́sı̣́ ꞌálâ. Nĩ yâ tạ̃pı̣́lı̣́ndrı̣́ ꞌbạ̃drı̣̃ ꞌdî kâ ãnî pá ágálé ꞌásĩ. Nĩ ꞌê ꞌdĩî tã âꞌdâ ró kĩ, õjílã ꞌdî ꞌbá yî gã Ôvârí trá dó.” ");
INSERT INTO avu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Gõꞌdá lãjóꞌbá gólĩyî mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî drí ngãzó nĩlí ậcı̣́ ĩyíkâ ꞌá, nĩꞌá lậmú bê võ kpã bê nĩngá sĩ kôrô nĩngá ꞌbã õnyíkõ ꞌásĩ ndrĩ, õjílã lı̣̃fı̣́ îcí bê tã kũmũ Ôvârí kâ rî kâ tãsĩ, nĩzó ngá lãzé ꞌbá êdé bê. ");
INSERT INTO avu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ꞌDĩî ꞌásĩ rî, tã Yésũ kâ nĩꞌá ꞌẽ bê lâ ꞌdĩ ꞌbá yî câ trá kúmú Ẽródẽ Ãnĩtípã rú. Ẽródẽ rî drı̣̃ lîjã trá lîjã-lîjã tã Yésũ kâ rî ꞌá, tãlâ õjílã ãzâ ꞌbá yî kĩ nĩ rî, Yésũ ãâꞌdô Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró gólâ âfõ ꞌbá õdrã ꞌásĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gõꞌdá ãzâ ꞌbá yî kĩ nĩ rî, Yésũ ãꞌdô tã ậngũ ꞌbá Ẽlíyã ĩꞌdî. Gõꞌdá õjílã ãzâ ꞌbá yî kĩ nĩ rî, Yésũ ãꞌdô kpá tã ậngũ ꞌbá ãzâ ꞌbá yî ngĩî rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ẽródẽ ı̣̂sũ tã trá ãkpã yí ꞌá kĩ nĩ rî, “Ãgô nõ âꞌdó Yõwánĩ ĩꞌdî kô, tãlâ mâ rî gógó rî fû Yõwánĩ trá drı̣̃ lâ gãlé vólé ạ̃kû ró. Ãgô nõ âꞌdô ꞌbãꞌá gõꞌdá kó ãꞌdî ĩꞌdî yã? Má lẽ drẽ gólâ rî lı̣̃fı̣́ ndrẽlé.” ");
INSERT INTO avu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî õtírĩ ĩyî âgõô ậcı̣́ ĩyíkâ tõlé rî tã lâ âtálé Yésũ drí rî, Yésũ yî drí ngãzó nĩlí ꞌbạ̃drı̣̃ mvá ãzâ fínyáwá rĩꞌá zı̣̃lâ Bẽtãsédã rî ꞌálâ lôvólé lâŋõ õjílã õꞌbí kâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gõꞌdá õꞌbí ꞌdĩ ꞌbá yî ꞌdê ĩyî kpá té zãâ gólĩyî vó. Yésũ drí kpá tã-drı̣̃ lẽzó ngá lãzé ꞌbá îngázó ngá lãzé ꞌásĩ, gólĩyî lı̣̃fı̣́ îcílí tã kũmũ Ôvârí kâ rî kâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gõꞌdá lạ̃njạ́túlı̣́ bê rî, lãjóꞌbá ꞌdĩ ꞌbá yî ânĩ ĩyî trá gólâ ngálâ tã âtálé drílâ kĩ nĩ rî, “Ní jô õjílã ꞌdî ꞌbá yî vólé, õnĩ ró ĩyî võ ndãlé ĩyî drí ậꞌdú kõzó ꞌá lâ, kpá ngá ndãlé ĩyî drí nyãlé, tãlâ jó yûꞌdạ́wạ́ võ nô ꞌá nõngá gólĩyî drí.” ");
INSERT INTO avu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Gólâ kĩ nĩ rî lãjóꞌbá ꞌdĩ ꞌbá yî drí rî, gólĩyî rî gógó õfẽ nyãsá õjílã ꞌdî ꞌbá yî drí nyãlé. Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî kĩ nĩ rî gólâ drí rî, “Mã âꞌdô nyãsá gĩꞌá õjílã ãmbá nõ ꞌbá yî drí yã? Îcá kô, ãmâ cé rĩꞌá ãmbãtã bê njı̣̂, ı̣̃ꞌbı̣̂ cé rı̣̃. ");
INSERT INTO avu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ãgô ꞌdĩ ꞌbá yî trá gạ̃rạ̃ lậvũlı̣́ kútũ-njı̣̂ drı̣̃ı̣̂ sĩ.” Yésũ drí gõzó tã âtálé lãjóꞌbá íyíkâ rî ꞌbá yî drí, ãâtâ ró ĩyî tã õꞌbí ãmbá ꞌdĩ ꞌbá yî drí rĩzó vũdrı̣́ võ ꞌásĩ tũ tũ, võ ãlô rî ꞌá õjílã õrî nyâꞌdî-rı̣̃-drı̣̃-lâ-ngâ-mûdrı̣́. ");
INSERT INTO avu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Gõꞌdá õꞌbí ãmbá ꞌdĩ ꞌbá yî rî ĩyî bê ndrĩ vũdrı̣́ rî, ");
INSERT INTO avu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yésũ drí gõzó ãwô-ĩtí ꞌẽlé Ôvârí drí ngá nyãnyã drílĩyî ꞌẽꞌá nyãlâ ꞌdĩ tãsĩ. Gólâ drí gõzó ãmbãtã ı̣̃ꞌbı̣̂ bê ꞌdĩ trõlé ꞌâ lâ ûpı̣̃lı̣́ dãdã ĩtí, fẽlé õꞌbí ãmbá ꞌdĩ ꞌbá yî drí. Lãjóꞌbá gólâkâ rî drí ãmbãtã lânjízó õjílã õꞌbí ꞌdĩ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Õꞌbí ãmbá ꞌdĩ ꞌbá yî ndrĩ drí ãmbãtã nyãzó îcálé ĩyî ꞌá dũûdû. Ạ̃mbúkũ lâ drí lâkízó ûꞌdúzó lâ ívõ ꞌásĩ dũûdû mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃. ");
INSERT INTO avu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kậyı̣̂ ãzâ sĩ, Yésũ rĩꞌá rãtáã ꞌẽꞌá Ôvârí drí. Lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî kpá rĩꞌá ãnyî gólâ bê. Gólâ ndẽ rãtáã bê rî, gólâ drí ngãzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îjílí. Gólâ kĩ nĩ rî gólĩyî drí rî, “Õjílã õꞌbí ãmbá rĩ ꞌbá ꞌdĩ ꞌbá yî tã ı̣̂sũ-ı̣̂sũ gólĩyíkâ ámâ tãsĩ rî ĩyíkâ ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî kĩ nĩ rî gólâ drí rî, “Tã ı̣̂sũ-ı̣̂sũ õꞌbí ꞌdĩ ꞌbá yí kâ rî kĩ nĩ rî, ní ãâꞌdô Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî ĩꞌdî. Gõꞌdá ãzâ ꞌbá yî kĩ ĩyíkâ, ní ãâꞌdô Ẽlíyã âgõ ꞌbá ûrú lésĩ rî ĩꞌdî. Gõꞌdá ãzâ ꞌbá yî kĩ ĩyíkâ, ní ãâꞌdô tã ậngũ ꞌbá ãzâ ꞌbá yî ngĩî âgõ ꞌbá ûrú lésĩ rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yésũ drí kpá lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî îjízó, “Gõꞌdá ãnî rî gógó rî, nĩ ı̣̂sũ ãníkâ bê rî, mâ ãꞌdî ĩꞌdî yã?” Pétẽrõ drí gõzó tã âtálé kĩ nĩ rî, “Nî ꞌdíyî pã ꞌbá gólâ Ôvârí drí âjólé rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yésũ drí gõzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ãwô, ꞌdĩî tã pạ̃tı̣́ı̣̃ ꞌî. Gõꞌdá nĩ âꞌdâ drẽ õjílã ãzâ ꞌbá yî drí kô. ");
INSERT INTO avu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mâ Ôvârí drí âjólé ûrú lésĩ rî ĩꞌdî, má âꞌdô lâŋõ ûsúꞌá rõô sı̣́sı̣́-lésĩ rî ꞌbá yî gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yí bê gõꞌdá kpá lãꞌbí îmbá ꞌbá rî ꞌbá yí bê rî drı̣́gạ́ sĩ. Gõꞌdá drílĩyî ámâ fũzó, gõꞌdá kậyı̣̂ nâ rî sĩ, má âꞌdô lîdríꞌá õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yésũ drí kpá tã âtázó kĩ nĩ rî, “Ngbãângbânõ tã gólâ má drí ꞌẽꞌá âtálé õjílã drí ndrĩ nô rî, õzõ õjílã ãzâ õlẽ trá ꞌdẽlé má vó rî, gólâ ı̣̃ı̣̂sũ tã kô íyî ífífí tãsĩ, gólâ õrî njãâ drãlé tã ámákâ ꞌẽrẽ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Õzõ õjílã ãzâ õfẽ íyî ífífí õdrã drí tã ámákâ rî ꞌá kô rî, gõꞌdá gólâ ãꞌdô ũrı̣̃ ró rî, gólâ âꞌdô ꞌbãꞌá cú ĩtí võ ãkó má ngálâ. Õzõ õjílã ãzâ õꞌê ũrı̣̃ kô õdrã drí tã ámákâ tãsĩ rî, gólâ âꞌdô ꞌbãꞌá cú võ bê má ngálâ ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Âꞌdô âꞌdóꞌá ángô tí õzõ õjílã ãꞌdô cú ngá-drı̣̃ ãmbá ãngó nõ ꞌá nõ bê ndrĩ rî, gõꞌdá õzõ gólâ ı̣̃ı̣̂vı̣̃ lạ́tı̣̂ lédrẽ-lédrẽ ạ̃dũkũ ãkó rî kâ trá rî yã? ");
INSERT INTO avu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nĩ ârî drẽ, õzõ õjílã ãzâ drı̣̃ lâ õôkî ôkî ámâ zı̣̃lı̣́ õjílã íyíkâ ró ngã ꞌbô rû-lẽ-ãzí ró yã rî, õzõ má õtírĩ âgõô kpá óꞌdí mbârâkã Ôvârí drí âfẽlé má drí rî bê mãlãyíkã ámákâ rî ꞌbá yí bê rî, ámâ drı̣̃ âꞌdô ôkíꞌá kpá ôkî gólâ rî zı̣̃lı̣́ má ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ãnî, má âtâ ĩꞌdî ãnî drí nõ ãnî ꞌdĩ ꞌbá yî lãfálé sĩ, nĩ drãá drẽ kô, Ôvârí âꞌdô ꞌẽꞌá âꞌdálâ ãnî drí dódó ãnî drí nı̣̃zó lâ kĩ, mâ rĩꞌá gólâ tíbê gólâ drí âjólé rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Gõꞌdá kậyı̣̂ njı̣̂-drı̣̃-lâ-nâ lậvũ bê tã Yésũ drí âtálé ꞌdĩ vólé drı̣̃ lâ ꞌásĩ rî, drílâ gõzó mbãlé únı̣́ drı̣̃ ꞌálâ rãtáã ꞌẽlé. Pétẽrõ, Yõwánĩ, Yãkóbã drílĩyî gólâ rî âjízó. ");
INSERT INTO avu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Gólâ drí rĩrĩ rãtáã ꞌẽlé rî ꞌá rî, lı̣̃fı̣́ lâ drí rû ôjázó gõꞌdá ngĩî kạ̃ꞌdậ-kạ̃ꞌdậ, ítá gólâ rú rî drí gõzó rĩꞌá lậgúlı̣́, õzõ mõgbárá drí lậgúrı̣̃ kâtí. ");
INSERT INTO avu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kôrô ꞌdĩî rî vósĩ rî, ãgô ãzâ ꞌbá yî rı̣̃ drí âfõzó gólâ lạ̃gạ́tı̣́. Ãgô rı̣̃ ꞌdî ꞌbá yî Músạ̃ yî ĩꞌdî Ẽlíyã bê. Gólĩyî ꞌdó lậgû-lậgû ró. Gólĩyî rĩꞌá õdrã tã Yésũ kâ rî tã lâ âtáꞌá âfõ-âfõ gólâkâ õdrã ꞌásĩ Yẽrõsãlémã ꞌálâ rî bê ꞌẽ ꞌbá rû ꞌẽlé ngbãângbânõ rî. ");
INSERT INTO avu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pétẽrõ yî íyî ãzí-ãzí yí bê trá ĩyî lîndĩꞌá ậꞌdú bê. Gõꞌdá gólĩyî õtírĩ lı̣̃fı̣́ njı̣̃ı̣̂ ậꞌdú ꞌásĩ rî, gõꞌdá ndrê ĩyî gbõ Yésũ ĩꞌdî ĩyî lạ̃gạ́tı̣́ rúmvạ́ bê ꞌdó lậgû-lậgû ró zãâ ãgô rı̣̃ ꞌdî ꞌbá yí bê yí lạ̃gạ́tı̣́. ");
INSERT INTO avu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gõꞌdá ãgô rı̣̃ ꞌdî ꞌbá yî drí Yésũ rî âyézó ĩyîngá nĩzó. Pétẽrõ drí tã âtázó Yésũ drí kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá, rĩꞌá tã tãndí ꞌî ãmâ drí âꞌdózó ãní bê nõngá. Ngbãângbânõ rî, mã gâ gũgũ nâ, ãlô rî ní drí, ãlô rî Músạ̃ drí, gõꞌdá ãlô rî Ẽlíyã drí.” Tákõ Pétẽrõ rî íyíkâ nõ ꞌdó tã tãkó âtálé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pétẽrõ drẽ rĩꞌá tã âtáꞌá yí sı̣́lı̣́ sĩ nõtí nõ rî, mbãrãsãsã drí gólĩyî lîmózó kpạ̃ạ́kũ, gólĩyî gõꞌdá trá ũrı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Drílĩyî gõzó õjílã ãzâ gbórókõ lâ ârílí mbãrãsãsã ꞌdî ꞌá rĩꞌá úlı̣́ âtáꞌá kĩ nĩ rî, “Nõô rî ámâ mvá gólâ má drí lẽlé rõô rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gõꞌdá ꞌdĩî rî vólé drı̣̃ lâ ꞌásĩ rî, gólĩyî ndrê ĩyî võ bê tãndí ró rî, ndrê ĩyî Yésũ gõꞌdá élêwálâ. Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí rĩzó ꞌdó njũrũ, âtá ĩyî tã kô õjílã ãzâ drí tã gólĩyî drí ndrẽlé ꞌdĩ tãsĩ, té Yésũ drí gõzó zãlô ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gõꞌdá cı̣̃ı̣́nó ãzâ rî sĩ rî, drílĩyî gõzó ârílí kúnı̣́ drı̣̃ lésĩ, gõꞌdá õꞌbí ãmbá drí rû êꞌbézó gbãâ dîrî Yésũ rú sĩ. ");
INSERT INTO avu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Õjílã ãlô õꞌbí ꞌdĩ ꞌbá yî lãfálé sĩ, drílâ trẽzó ûrû lạ̃zı̣́ bê Yésũ drí kĩ, “Lı̣̃fı̣́ îcí ꞌbá, ní ânĩ ámâ mvá nõ ndrẽlé, gólâ cé ĩꞌdî má drí ãlô nõ. ");
INSERT INTO avu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Líndrí õnjí rĩ ꞌbá Sãtánã rî rõlé rî, rî trá mvá ꞌdĩ vũlı̣́ vũdrı̣́ trẽtrẽ bê ûrû. Líndrí õnjí ꞌdĩ rî mvá ꞌdĩ âsélé ãmósá bê kạ̃trũ íyî tı̣̂ ꞌásĩ, gólâ rî ꞌẽlé kậyı̣̂ vósĩ cé. Fãfã lâ drí rĩzó rû ndẽlé. ");
INSERT INTO avu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Má lôꞌbã rúꞌbạ́ trá lãjóꞌbá áníkâ ꞌdĩ ꞌbá yî drí, ãâtâ ró ĩyî tã, líndrí õnjí ꞌdĩ ãâyê ró gólâ rî, gõꞌdá gólĩyî îcá kô.” ");
INSERT INTO avu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yésũ kĩ nĩ rî, “Ãnî õjílã nô ꞌbá yî, nĩ lẽé tã Ôvârí ꞌá kô yã? Má âꞌdô rĩꞌá zãâ ãní bê ạ̃dũkũ lâ cãlé bũúũ ángô tú yã? Ní âjî ánî mvá ꞌdĩ má ngáá nõlé.” ");
INSERT INTO avu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gõꞌdá mvá ꞌdĩ õtírĩ kpá ângá ânĩlí gólâ ngálâ rî, líndrí õnjí ꞌdĩ drí âsézó lâ, drílâ rĩzó lẽlé. Yésũ drí gõzó tã âtálé líndrí õnjí ꞌdĩ drí mvá ꞌdĩ âyézó, drílâ ꞌbãzó tãndí ró. Drílâ mvá ꞌdĩ trõzó âjílí átá lâ ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Õjílã ndrê trá ndrĩ, Ôvârí fẽ fãfã trá Yésũ drí. Kậyı̣̂ nã ꞌbá yî sĩ rî, õjílã ꞌbạ̃drı̣̃ nã kâ rî trá ꞌdó úlı̣́ âtálé gólâ rî tãsĩ. Gõꞌdá õjílã ꞌbạ̃drı̣̃ mvá nã ꞌbá yí kâ nã âꞌdô bê trá ndrĩ lârõ-lârõ ró tã Yésũ drí rĩꞌá ꞌẽlâ rî ꞌá rî, gõꞌdá Yésũ drí gõzó úlı̣́ ngũrũ-ngũrũ âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nĩ ârî úlı̣́ má drí ꞌẽꞌá âtálâ ãnî drí nõ tãndí ró, tã má drí ꞌẽꞌá âtálâ ãnî drí rî ĩꞌdî nõ. Mâ gólâ Ôvârí drí âjólé ûrú lésĩ rî, áâꞌdô bí ꞌẽꞌá ámâ drı̣́-bã fẽlé õjílã drí fũlı̣́.” ");
INSERT INTO avu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî nı̣̃ı̣́ ĩyî úlı̣́ gólâ drí âtálé ꞌdĩ ífí lâ kô, tãlâ Ôvârí lôgâ tã ífí lâ nĩ gólĩyî drí. Gõꞌdá nĩngá sĩ rî, gólĩyî kpá ũrı̣̃ ró Yésũ rî îjílí tã ífí lâ âꞌdálé ĩyî drí. ");
INSERT INTO avu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gõꞌdá lãjóꞌbá gólâkâ rî ꞌbá yî ngâ ĩyî trá ndrĩ tã ôkî-ôkî bê ĩyî lãfálé ꞌásĩ ãꞌdî ĩꞌdî ãmbá ró gạ̃rạ̃ ĩyî drı̣̃ı̣̂ sĩ yã. ");
INSERT INTO avu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gólâ nı̣̃ tã ı̣̂sũ-ı̣̂sũ gólĩyíkâ ꞌdĩ trá téké. Gõꞌdá drílâ gõzó mvá fínyáwá ãzâ âtrõlé ꞌbãlé âdrélé ĩyî lạ̃gạ́tı̣́ ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Gõꞌdá drílâ tã âtázó nõtí gólĩyî drí, “Õzõ õjílã ãzâ õlẽ ꞌdĩyímvá fínyáwá trá rî, õjílã rî ꞌdĩ lẽ mâ ĩꞌdî. Õzõ õjílã ãzâ õlẽ mâ trá rî, gólâ lẽ ꞌdî Ôvârí gólâ ámâ âjó ꞌbá rî ĩꞌdî. Nĩ ndrê drẽ, õzõ óõꞌbã kpálé mvá fínyáwá nõ ĩꞌdî ãnî drı̣̃ı̣̂ ãmbá ró rî, nĩ ı̣̂ꞌbũ rû kpá gólâ drí. Nĩ ndrê trá, tã ı̣̂sũ-ı̣̂sũ Ôvârí kâ ꞌá rî, íyíkâ cé rĩlí õjílã ãzí pãlé ĩꞌdî. Ãnî tã ârí ꞌbá ámákâ rî ꞌbá yî, tãlâ ãꞌdô ꞌî ãnî drí rĩzó rû cẽlé ꞌbãzó õjílã ạ́ngı̣́ ró yã?” ");
INSERT INTO avu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Gõꞌdá nĩngá sĩ rî, Yõwánĩ drí tã âtázó kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá, mã ndrê ãgô ãzâ trá rĩꞌá líndrí õnjí lôfõꞌá õjílã ꞌásĩ. Gólâ rî trá ngá nyãlé ánî rú sĩ tã líndrí õnjí lôfõ-lôfõ kâ ꞌdĩ ꞌá, mã rî trá gólâ rî îkílí tã ꞌdî ꞌbá yî ꞌẽrẽ lâ ꞌásĩ, tãlâ gólâ âꞌdó ãmâ lãfálé sĩ kô.” ");
INSERT INTO avu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Gõꞌdá Yésũ kĩ nĩ rî gólĩyî drí rî, “Nĩ âyê gólâ, tãlâ gólâ ꞌé tã ꞌdî kô õzõ ạ̃jú-ꞌbá-ãzí kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gõꞌdá Yésũ õtírĩ kậyı̣̂ yí drí ꞌẽzó gõlé ûrú ꞌálâ rî ndrẽê ãnyî ãnyî âcáꞌá rî, gólâ ômbê íyî fĩî trá íyî êdézó nĩlí drãlé Yẽrõsãlémã ꞌálâ. Gólâ âyê ꞌbạ̃drı̣̃ gólâ Gãlĩláyã kâ ꞌdĩ trá, drílâ fĩzó ꞌbạ̃drı̣̃ Sãmárĩyã lé ꞌbá kâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Drílâ íyî ândrâ âtízó sı̣́sı̣́, tãlâ gólĩyî õrî ró ĩyî bê njãâ íyî âcâ-âcâ tẽlé. Tã gólâ drí âtílí ꞌdĩ rî câ trá bũúũ ꞌbạ̃drı̣̃ mvá ãzâ gólâ õjílã Sãmárĩyã lé ꞌbá yî drí rĩzó kpá ꞌá lâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Õjílã ꞌdî ꞌbá yî lẽé ĩyî tã gólâkâ ꞌdĩ tã-drı̣̃ lâ kô, tãlâ gólĩyî nı̣̃ trá kĩ nĩ rî, gólâ ꞌê trá nĩlí Yẽrõsãlémã ꞌálâ, ꞌbạ̃drı̣̃ ĩyî ạ̃jú-ꞌbá-ãzí yí kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gõꞌdá Yõwánĩ yî ậdrúpı̣̃ lâ Yãkóbã bê ârî ĩyî tã ꞌdî bê rî, gólĩyî âtâ ĩyî tã trá Yésũ drí kĩ nĩ rî, “Ãmâ lı̣́pı̣̂, ní lẽ tã-drı̣̃ ãmâ drí Ôvârí rî îjízó ãâjô ró bê lạ̃sı̣́ õjílã ꞌdî ꞌbá yî zãlé vólé.” ");
INSERT INTO avu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Gólâ âtâ tã trá, tã ı̣̂sũ gólĩyíkâ ꞌdĩ ãâyê ró ĩyî. ");
INSERT INTO avu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gõꞌdá nĩngá sĩ rî, zãâ drílĩyî nĩzó ꞌbạ̃drı̣̃ mvá ãzâ ngĩî lâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Gõꞌdá gólĩyî drí rĩrĩ nĩlí lạ́tı̣̂ ꞌásĩ rî ꞌá, gólĩyî ûsû ãgô ãzâ trá. Ãgô ꞌdĩ âtâ trá Yésũ drí kĩ nĩ rî, “Má lẽ trá ánî vó bẽlé zãâ võ ãmbá nõ ꞌásĩ bạ̃dı̣̃ võ ní drí rĩzó lậmúlı̣́ rî ꞌásĩ õzõ tã ârí ꞌbá áníkâ kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Gõꞌdá gólâ lôgõ tã ꞌdî drı̣̃ lâ trá úlı̣́ mãnĩgõ sĩ kĩ, “Õbá cú ꞌbú íyíkâ bê ậꞌdú kõzó ꞌá lâ, gõꞌdá ãríwá kpá cú jó íyíkâ bê ậꞌdú kõzó. Gõꞌdá mâ gólâ âjólé trá ûrú lésĩ nõ rî, mâ cú ĩtí ꞌbã ãkó rĩzó lôvólé ꞌá lâ ámâ ífífí kâ.” ");
INSERT INTO avu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kậyı̣̂ ãzâ sĩ, drílâ kpá ãgô ãzâ îjízó ãânĩ ró bê, yí õrî ró lı̣̃fı̣́ lâ îcílí. Ãgô ꞌdĩ lôgõ tã trá gólâ drí kĩ nĩ rî, “Má lẽ fí trá nĩlí rî, mâ drẽ rĩꞌá tãkõ ámâ átá rî ãrãkã tẽlé ꞌbãlé ꞌbú ꞌá zãlô.” ");
INSERT INTO avu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Gõꞌdá Yésũ kĩ, “Ní âyê õjílã gólĩyî tã lẽ ꞌbá ĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá kô rî âꞌdô ĩyî ãvõ ꞌbãꞌá trá. Má lẽ ní drí ânĩzó ãmá bê ãndrõ nô õjílã ậzı̣́lı̣́ ânĩlí ꞌbãlé Ôvârí rî mvá ró.” ");
INSERT INTO avu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gõꞌdá ãgô ãzâ âtâ tã kpá trá kĩ nĩ rî, “Ãwô, má lẽ trá ãmâ drí nĩzó ní bê, ní âyê drẽ mâ, má nĩꞌá zãlô tã lâ ı̣̂ꞌbı̣̃lı̣́ ámâ átá bê.” ");
INSERT INTO avu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Gólâ âtâ úlı̣́ mãnĩgõ kpá trá drílâ kĩ nĩ rî, “Õzõ õjílã ãzâ õndẽ lôsĩ íyíkâ ꞌbãlé rî kô drílâ rĩzó gõlé vólé ꞌbã ꞌálâ tã lâ sĩ, lôsĩ ámákâ rî âyézó rî, õjílã ꞌdî âꞌdó õjílã ámákâ lôsĩ ámákâ ꞌẽ ꞌbá rî ĩꞌdî kô.” ");
INSERT INTO avu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ꞌDĩî rî vósĩ rî, Kúmú Yésũ drí õjílã ãzâ ꞌbá yî zı̣̃zó nyâꞌdî-nâ-drı̣̃-lâ-ngâ-mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃, jõlé sı̣́sı̣́ ꞌbạ̃drı̣̃ mvá õnyíkõ yí drí ꞌẽꞌá nĩꞌá lậmú bê ꞌá lâ sĩ rî ꞌásĩ, rı̣̃ rı̣̃. ");
INSERT INTO avu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Drílâ úlı̣́ mãnĩgõ ãzâ âtázó õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, “Nĩ nĩ sı̣́sı̣́ má ágá ꞌálâ tã Ôvârí kâ pẽlé õjílã drí, tãlâ õjílã ãmbá lẽ tã ꞌdî ârílí. Gólĩyî rĩꞌá õzõ ạ́mvú ạ́ngı̣́ ạ̃drúgú lâ drí mvẽlé trá njãâ ꞌẽꞌá ŋõlâ rî, gõꞌdá õjílã ŋõ ꞌbá lâ yû rî kâtí. Gõꞌdá má lẽ nĩ ꞌê rãtáã Ôvârí drí gólâ tíbê ꞌbã ꞌbá õjílã ndrĩ lı̣́pı̣̂ ró rî, gólâ ãâjô ró bê õjílã rĩꞌá õjílã ãzí nõ ꞌbá yî lı̣̃fı̣́ lâ yî îcílí tã gólâkâ ârílí. ");
INSERT INTO avu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nĩ nĩ, nĩ ndrê ãnî tãndí ró, tãlâ ãnî rĩꞌá õzõ ı̣̃ndrı̣̂ mvá gólâ rĩ ꞌbá lậvũlı̣́ kôrô võ gólâ kíâkêlówá drí ꞌbãzó ꞌá lâ ꞌásĩ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nĩ nĩ ꞌwãâꞌwâ, nĩ trõ ngá kô ãní bê, õzõ lãfâ, jõráã, káꞌbókã kâtí rî ꞌbá yî. Nĩ âdrê kpá kô nĩꞌá nî-bê-yã ꞌẽ bê õjílã drí lạ́tı̣̂ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Õzõ nĩ ãâcâ trá ꞌbã ãzâ ꞌá rî, nĩ fẽ nî-bê-yã ꞌbã-lı̣́pı̣̂ drí nõtí kĩ nĩ rî, ‘Ní trõ tã ạ̃ꞌdı̣́ Ôvârí kâ trá ní bê.’ ");
INSERT INTO avu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Õzõ ꞌbã-lı̣́pı̣̂ yî õlẽ tã trá rî, Ôvârí âꞌdô gólĩyî pãꞌá. Õzõ õlẽ ĩyî kô rî, Ôvârí pá gólĩyî kô. ");
INSERT INTO avu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nĩ rî zãâ ꞌbã ãlô ꞌá, âꞌdó kô nĩꞌá lậmú bê ꞌbã-tı̣̂ kpã bê kô. Nĩ nyâ ngá, nĩ mvû ngá gólĩyî drí âfẽlé ãnî drí rî ꞌbá yî, tãlâ ngá ꞌdĩ õfẽ ró fãfã ãnî drí rĩzó tã ámákâ rî îcílí. ");
INSERT INTO avu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Õzõ óõlậgû ãnî trá ꞌbạ̃drı̣̃ mvá ãzâ ꞌá rî, nĩ nyâ ngá ndrĩ, nĩ gâ ngá gólâ gólĩyî drí âfẽlé ãnî drí rî kô. ");
INSERT INTO avu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nĩ êdê õjílã gólĩyî ngá lãzé bê rî ꞌbá yî dódó, nĩ âtâ gólĩyî drí kĩ nĩ rî, ‘Ôvârí lẽ ãnî ãꞌdô ró õjílã íyíkâ ró, ólẽ ngá lẽlẽ ãníkâ gólâ bê rî õꞌbê drı̣̃ ãlô.’ ");
INSERT INTO avu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Õzõ õjílã ãzâ ꞌbá yî ꞌbạ̃drı̣̃ ꞌdî kâ õlẽ tã ãníkâ kô rî, nĩ âtâ gólĩyî drí nõtí kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mã âyê ãnî trá zãâ, nĩ ndrê drẽ, mã yâ tạ̃pı̣́lı̣́ndrı̣́ ꞌbạ̃drı̣̃ ꞌdî kâ trá ãmâ pá ágálé ꞌásĩ, mã tô pá ꞌá lâ gõꞌdá kô. Nĩ ndrê trá, Ôvârí lẽ ãnî, gólâ rî ãnî zı̣̃ꞌá ânĩlí õjílã íyíkâ ró, gõꞌdá nĩ gã dó.’ ");
INSERT INTO avu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Lâŋõ gólâ Ôvârí drí ꞌẽꞌá fẽlâ drílĩyî rî âꞌdô lâŋõ gólâ drílâ ꞌẽꞌá fẽlâ õjílã Sõdómõ kâ drí rî lậvũꞌá. ");
INSERT INTO avu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","14","“Á! Ãnî õjílã ꞌbạ̃drı̣̃ Kõrázã kâ nõ õjílã gólĩyî ꞌbạ̃drı̣̃ Bẽtãsédã kâ rî ꞌbá yí bê, má ꞌê tã lârâkô trá ândálé ândálé ãnî lı̣̃fı̣́ drı̣̃ ꞌá. Ãnî lẽé kô drı̣̃ âjálé ꞌdẽzó Ôvârí vó. Nĩ nı̣̃ trá ãꞌdô tã âꞌdô nĩ jạ̃rı̣́bạ̃ Tírã yí kâ drí Sĩdónã bê, ạ̃kû ró rî, Ôvârí îzã gólĩyî trá kôrô. Gólĩyî õró tã lârâkô gólĩyî má drí rĩꞌá ꞌẽlâ ãnî lãfálé ꞌá rî ꞌbá yî ndrẽê cú ĩyî lı̣̃fı̣́ sĩ rî, tí gólĩyî âdĩ drı̣̃ trá tã õnjí ĩyíkâ rî ꞌbá yî ꞌásĩ. Ĩtí rî, Ôvârí âꞌdô lâŋõ ãmbá fẽꞌá ãnî drí lậvũlı̣́ kôrô. ");
INSERT INTO avu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Gõꞌdá õjílã gólĩyî Kãpẽrãnómã kâ rî ꞌbá yî ı̣̂sũ ĩyíkâ bê rî, Ôvârí âꞌdô gólĩyî lậgúꞌá trõlé ûrú ꞌálâ, tãlâ gólĩyî ârî tã âtâ-âtâ ámákâ bê rî, gõꞌdá nı̣̃ ĩyî mâ trá tã lârâkô ndrĩ má drí ꞌẽlé rî ꞌá yã? ꞌÉꞌẽ! Gólĩyî âꞌdô nĩꞌá lạ̃sı̣́ ạ̃dũkũ ãkó rî ꞌá, tãlâ gólĩyî gã dó drı̣̃ âdĩlí tã õnjí gólĩyíkâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Gõꞌdá Yésũ âtâ tã trá lãjóꞌbá íyíkâ rî ꞌbá yî drí nõtí, “Má fẽ drı̣́-ãcê ámákâ trá ãnî drí õjílã lı̣̃fı̣́ îcízó ámâ võ ꞌá. Õzõ õjílã ãzâ ꞌbá yî õlẽ tã ãníkâ trá rî, gólĩyî lẽ tã ámákâ rî kpá trá. Õzõ gólĩyî õgã tã îmbâ-îmbâ ãníkâ trá dó rî, gólĩyî gã ámákâ rî kpá trá dó. Õzõ õjílã ãzâ ꞌbá yî õgã tã ámákâ trá dó rî, gólĩyî gã Ôvârí kâ rî kpá trá dó, tãlâ gólâ ámâ âjó ꞌbá rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gõꞌdá õjílã gólĩyî zĩlí nyâꞌdî-nâ-drı̣̃-lâ-ngâ-mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ꞌdî ꞌbá yî, nĩ ĩyî trá tã Yésũ kâ âtá bê. Gõꞌdá gólĩyî âgõ ĩyî gólâ ngálâ rúꞌbạ́ âsô-âsô bê. Gólĩyî kĩ nĩ rî, “Mã ꞌê tã ꞌdî trá té õzõ ní drí âtálé rî tí. Líndrí õnjí gólâ Sãtánã kâ, mã âtâ tã bê drílĩyî rî, gólĩyî âyê õjílã trá. Mã zı̣̂ ánî rú bê rî, gõꞌdá kôrô drílĩyî rõzó lâ.” ");
INSERT INTO avu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yésũ drí gõzó tã âtálé gólĩyî drí kĩ nĩ rî, “Ãwô, ạ̃kû ró rî, Sãtánã njâ tã Ôvârí kâ bê njãnjã rî, má ndrê ámâ lı̣̃fı̣́ sĩ Ôvârí drí Sãtánã rî ậvũzó ûrú lésĩ vũdrı̣́ ꞌá nõlé. ");
INSERT INTO avu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Líndrí õnjí ꞌdĩ ꞌbá yî rĩꞌá õzõ ótónyî kâtí õjílã zãlé zãzã, kpá ı̣̃nı̣̃ bê rî õjílã cĩlí lâzê-lâzê ró. Gõꞌdá nĩ ró tã kô, gólĩyî lîsí ãnî kô, tãlâ má fẽ drı̣́-ãcê ámákâ trá ãnî drí gólĩyî îzãzó. ");
INSERT INTO avu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngbãângbânõ rî, ãnî rúꞌbạ́ trá âsô-âsô ró, tãlâ nĩ ı̣̂sũ bê, rî ĩyî trá mbârâkã bê líndrí õnjí îzãzó. Tãndí ró, ãnî rúꞌbạ́ ãâꞌdô âsô-âsô ró, tãlâ nĩ âꞌdô trá Ôvârí rî mvá ró rî drí sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Gõꞌdá Líndrí Tãndí Ôvârí kâ ꞌbã Yésũ trá âꞌdólé pı̣̃pı̣̂sı̣́lı̣́ lâ bê ndrĩ ãyĩkõ ró, drílâ tã âtázó Ôvârí drí rãtáã sĩ kĩ nĩ rî, “Ãwô-ĩtí, ámâ átá, nî tíbê ãngó lı̣́pı̣̂ ró rî, ní lậpı̣̂ tã nô ꞌbá yî trá ndrĩ õjílã gólĩyî tã nı̣̃ ãkĩ nõ ꞌbá yî drí. Ánî Líndrí âꞌdâ tã ífí nõ õjílã gólĩyî áyábálá ró rî yî drí. Ní ꞌê ĩtí õzõ tã gólâ ánî pı̣̃pı̣̂sı̣́lı̣́ drí lẽlé rî tí.” ");
INSERT INTO avu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Gõꞌdá gólâ drí tã âtázó lãjóꞌbá íyíkâ rî drí kĩ nĩ rî, “Ámâ átá Ôvârí âfẽ ngá ãmbá nõ ꞌbá yî trá ndrĩ má drı̣́gạ́. Ámâ átá Ôvârí nı̣̃ mâ trá íyî mvá ró, mâ ĩꞌdî. Má nı̣̃ gólâ kpá trá ámâ átá ró Ôvârí ĩꞌdî. Gõꞌdá má lẽ trá Ôvârí rî âꞌdálé õjílã gólĩyî má drí êpẽlé nõ ꞌbá yî drí.” ");
INSERT INTO avu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Drílâ gõzó tã âtálé mãnísĩ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ôvârí rî lı̣̃fı̣́ ãâꞌdô ãnî drı̣̃ı̣̂, tãlâ nĩ rî trá ámâ ndrẽlé tã lârâkô ꞌẽrẽ ꞌá ãmbá. ");
INSERT INTO avu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kúmú ãmbá ãzâ ꞌbá yî, gõꞌdá tã ậngũ ꞌbá ãmbá rî ꞌbá yí bê lẽ ĩyî tã lârâkô ꞌdĩ ꞌbá yî ndrẽlé rî, gõꞌdá îcá ĩyî ndrẽlâ kô, lẽ ĩyî kpá úlı̣́ gólĩyî má drí rĩꞌá âtálâ cú ámâ tı̣̂ sĩ ãnî drí nã ꞌbá yî ârílí rî, gólĩyî ârí kpá kô.” ");
INSERT INTO avu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kậyı̣̂ ãzâ sĩ, ãgô ãzâ gólâ lãꞌbí îmbá ꞌbá rî îjî Yésũ trá, ꞌẽzó tã nı̣̃nı̣̃ Yésũ kâ rî ûjũlı̣́ tã ãzâ ꞌbá yî ꞌá, tãlâ lãꞌbí îmbá ꞌbá ꞌdĩ lẽ Yésũ âtâ ró úlı̣́ ãzâ bê ányâ ró. Lãꞌbí îmbá ꞌbá ꞌdĩ drí tã âtázó gólâ drí kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá Yésũ, õzõ má õlẽ trá rĩlí ạ̃dũkũ ãkó võ ûrú ꞌálâ rî ꞌá rî, má âꞌdô ãꞌdô ꞌẽꞌá ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Gólâ âtâ trá lãꞌbí îmbá ꞌbá ꞌdĩ drí nõtí kĩ nĩ rî, “Tã tíbê Músạ̃ drí îgĩlí tã ꞌbãꞌbã Ôvârí kâ tãsĩ rî, âtâ tã kĩ ãꞌdî yã? Ní âtâ tã lâ má drí.” ");
INSERT INTO avu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lãꞌbí îmbá ꞌbá ꞌdĩ lôgõ tã trá kĩ nĩ rî, “Tã îgĩ tã ꞌbãꞌbã Ôvârí kâ ꞌdĩ rî úlı̣́ âtálé ãmâ drí kĩ nĩ rî, ‘Ní lẽ Ôvârí Kúmú áníkâ ró rî pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ, ánî mbârâkã sĩ ndrĩ, tã ı̣̂sũ-ı̣̂sũ áníkâ sĩ ndrĩ.’ Tã ꞌBãꞌbã Ândâ 6.5 Gõꞌdá kpá, ‘Ní lẽ ánî ãzí-ãzí yî, õzõ ní drí ánî ífífí lẽrẽ kâtí.’ ” ");
INSERT INTO avu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yésũ kĩ, “Tã ní drí îjílí má tı̣́ rî, ní ndẽ trá ĩꞌdî ꞌdĩ. Õzõ ní õꞌê tã ꞌdî ꞌbá yî trá ngbá ꞌbũû rî, ní âꞌdô rĩꞌá Ôvârí bê ꞌbạ̃drı̣̃ ûrú ꞌálâ rî ꞌá ạ̃dũkũ ãkó.” ");
INSERT INTO avu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lãꞌbí îmbá ꞌbá ꞌdĩ lẽé kô õjílã drí tã âtálé kĩꞌá nĩ rî, Yésũ ĩꞌdî tã nı̣̃nı̣̃ bê kôrô yí drı̣̃ı̣̂ sĩ. Lãꞌbí îmbá ꞌbá ꞌdĩ kĩ, “Ní âꞌdâ drẽ má drí õjílã ángô rî ꞌbá yî ĩꞌdî ámâ ãzí-ãzí ró má drí lẽlé rî yã?” ");
INSERT INTO avu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Gõꞌdá Yésũ lôgõ tã-drı̣̃ trá lãꞌbí îmbá ꞌbá ꞌdĩ drí íꞌdígówá sĩ kĩ nĩ rî, “Ãgô ãzâ rĩꞌá ânĩꞌá Yẽrõsãlémã lésĩ, ꞌẽꞌá nĩlí Yérĩkõ ꞌálâ. Ãgô ãzâ ꞌbá yî ngá ôpá ꞌbá ꞌî, rû ĩyî gólâ trá lạ́tı̣̂ ꞌá. Ngá ôpá ꞌbá ꞌdĩ ꞌbá yî drí ngá gólâkâ ôpázó ndrĩ, ítá yí bê ndrĩ. Gólâ gõꞌdá cú ĩtí ũndú ró. Ngá ôpá ꞌbá ꞌdĩ ꞌbá yî drí gõzó gólâ rî cãlé ꞌẽꞌá fũlâ fũfũ, sẽzó lâ nĩꞌá vũlâ pávó gãrã ꞌá ĩtí, gbõcõ, ĩyî drı̣́gạ́ sĩ âyélé ãvõ ró. ");
INSERT INTO avu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Kậyı̣̂ ꞌdĩ sĩ rî, ândrâ-tãndĩ ró, drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ ãzâ íyîngá kpá rĩꞌá ânĩꞌá âcálé võ tíbê gólâ drí rĩzó õzõ ãvõ kâtí ꞌdĩ ꞌá. Gõꞌdá drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ ꞌdĩ ndrê bê gólâ ậyı̣́ꞌá vũdrı̣́ ĩtí rî, drílâ íyîngá lậvũzó rú lâ sĩ âyélâ nĩngá. ");
INSERT INTO avu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Gõꞌdá ꞌdĩî rî vósĩ rî, ãgô ãzâ drí kpá âcázó. Ãgô âcá ꞌbá nõ rî lôsĩ gólâkâ rî rĩꞌá íyíkâ ũgúlı̣́ ậtı̣̃ ꞌbá drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ rî ꞌbá yí kâ lãfálé sĩ. Gõꞌdá ãgô nõ ndrê gólâ bê rî, drílâ íyîngá kpá lậvũzó rú lâ sĩ lạ́tı̣̂ gãrã drı̣̃ ãzâ rî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Gõꞌdá ꞌdĩî rî vósĩ rî, ãgô ãzâ drí kpá âcázó. Ãgô ꞌdĩ Sãmárĩyã lé ꞌbá ꞌî, íyíkâ gĩâ ngá ãwã ꞌî. Ãgô gólâ Sãmárĩyã lé ꞌbá ró ꞌdĩ ndrê bê ãgô lãzé bê ꞌdĩ ậyı̣́ꞌá vũdrı̣́ rî, ĩzã lâ gâ trá drílâ, gólâ kĩ nĩ rî, ‘Óõ! Ãꞌdô ꞌê ãgô nõ nõtí nõ nĩ yã?’ ");
INSERT INTO avu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Gõꞌdá drílâ ânĩzó ãgô lãzé bê ꞌdĩ îngálé lãzé lâ jĩzó õdrá sĩ, drílâ kpá dõ dãzó ĩꞌdî lãzé ꞌdĩ ꞌá ãlókõ ró, drílâ lãzé lâ ômbézó ítá sĩ ngạ́rạ́-ngạ́rạ́. Drílâ ãgô lãzé bê ꞌdĩ îngázó ꞌbãlé dõngí íyíkâ rî drı̣̃ı̣̂, trõlé âjílí jạ̃rı̣́bạ̃ ꞌálâ. Âcâ ĩyî bê jạ̃rı̣́bạ̃ ꞌálâ rî, ꞌbã ãgô lãzé bê ꞌdĩ trá jó ũmú kâ rî ꞌálâ. Gólâ ndrê ãgô lãzé bê ꞌdĩ vó lâ trá tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ị̃drú rî tí, drílâ gõzó lậvũlı̣́. Drílâ lãfâ fẽzó ãgô jó ũmú kâ vó lâ ndrẽ ꞌbá ró ꞌdĩ drí ãlókõ gĩzó, kpá ngá nyãnyã gĩzó ãgô lãzé bê ꞌdĩ drí. Drílâ kpá tã âtázó kĩ nĩ rî, õzõ yí õtírĩ âgõô rî, yí âꞌdô kpá lãfâ ãzâ fẽꞌá ngá gólâ drí nyãlé nõngá rî tãsĩ. Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gõꞌdá Yésũ âtâ trá ãgô gólâ lãꞌbí îmbá ꞌbá ró ꞌdĩ drí kĩ nĩ rî, “Tã ı̣̂sũ áníkâ rî íyíkâ ángô tí yã? Õjílã nâ ꞌdĩ ꞌbá yî lãfálé sĩ rî, ãꞌdî pâ ãgô gólâ ngá ôpá ꞌbá drí cãlé rî nĩ yã, tã ꞌẽzó drílâ õzõ áró lâ kâtí rî yã?” ");
INSERT INTO avu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lãꞌbí îmbá ꞌbá ꞌdĩ âtâ trá kĩ nĩ rî, “Cé õjílã ânĩ ꞌbá Sãmárĩyã lésĩ rî ĩꞌdî.” Yésũ kĩ, “Ní gõ ꞌbã ꞌálâ, ní ꞌê kpá õzõ ãgô gólâ Sãmárĩyã lésĩ rî drí ꞌẽlé ꞌdĩ tí.” ");
INSERT INTO avu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Yésũ yî lãjóꞌbá íyíkâ bê drílĩyî rĩrĩ nĩlí Yẽrõsãlémã ꞌálâ rî ꞌá, kậyı̣̂ ãzâ sĩ pávó ꞌá rî, drílĩyî âcázó ꞌbạ̃drı̣̃ mvá ãzâ ꞌá. ꞌBạ̃drı̣̃ mvá ꞌdĩ ꞌá rî, õkó ãzâ rĩꞌá tólâ rú bê Márãtã. Ậmvúpı̣̃ lâ rî rú Mãríyã. Gólĩyî nı̣̃ Yésũ trá. Márãtã drí Yésũ rî tã âtízó ânĩlí ĩyî drí ꞌbã ꞌálâ ũmú ró. Yésũ âcâ bê drílĩyî ꞌbã ꞌá rî, Mãríyã ânĩ trá rĩlí vũdrı̣́ Kúmú Yésũ lạ̃gạ́tı̣́, úlı̣́ gólâkâ rĩꞌá âtálâ rî ârílí ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Gõꞌdá Márãtã îcá íyíkâ úlı̣́ Yésũ kâ ꞌdĩ ârílí kó kô, tãlâ gólâ rî lı̣̃fı̣́ trá lârâ-lârâ ró, lôsĩ nyãsá lâꞌdî-lâꞌdî kâ rî ꞌẽꞌá ĩꞌdî, drı̣̃ lâ lîjã trá ndı̣̃ ĩtí. Márãtã drí tã âtázó Yésũ drí kĩ nĩ rî, “Kúmú Yésũ, tãlâ ãꞌdô ꞌî ámâ ậmvúpı̣̃ Mãríyã drí ámâ âyézó élêwálâ, rĩꞌá lôsĩ nyãsá lâꞌdî-lâꞌdî kâ ꞌẽlé yã? Ní âtâ gólâ drí ãânĩ ró ámâ pãlé lôsĩ ãzâ ꞌbá yî ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gõꞌdá Kúmú Yésũ drí tã âtázó kĩ nĩ rî, “Márãtã, Márãtã, kậyı̣̂ vósĩ ndrĩ, ní rî zãâ rĩꞌá lı̣̃fı̣́ lôꞌbélé lôꞌbê lôsĩ jó kâ ꞌẽrẽ ꞌá ángô tí yã? ");
INSERT INTO avu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ní ârî drẽ, lôsĩ tãndí kó ĩꞌdî ãlô nõ. Tákõ ĩꞌdî úlı̣́ má drí rĩꞌá âtálâ nõ ârî-ârî lâ ĩꞌdî. Mãríyã lẽ trá úlı̣́ má drí rĩꞌá âtálâ nõ ârílí. Nĩngá sĩ rî, má îcá tã âtálé drílâ kĩꞌá nĩ rî, gólâ õnĩ lôsĩ ãzâ ꞌẽlé rî kô.” ");
INSERT INTO avu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gõꞌdá kậyı̣̂ ãzâ sĩ, Yésũ rî rãtáã ꞌẽꞌá Ôvârí drí. Gõꞌdá lãjóꞌbá gólâkâ rĩꞌá gólâ bê tólâ, ãlô gólĩyî lãfálé ꞌásĩ rî kĩ nĩ rî, “Kúmú ãmákâ, ní îcî ãmâ lı̣̃fı̣́ rãtáã ꞌẽꞌẽ sĩ Ôvârí drí. Ókĩ nĩ rî, Yõwánĩ îcî íyíkâ tã ârí ꞌbá íyíkâ rî ꞌbá yî lı̣̃fı̣́ lâ trá rãtáã ꞌẽꞌẽ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","4","Gõꞌdá Yésũ drí gõzó tã âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ꞌê rãtáã nõtí, nĩ kĩ, Ãmâ átá ûrú ꞌálâ rî, ánî rú ãꞌdô ı̣̂njı̣̃lı̣́ ı̣̂njı̣̃. Kũmũ áníkâ rî ãâcâ. Ãndrõ nô, ní âfẽ ngá nyãnyã ãmákâ kậyı̣̂ vósĩ cé rî ãmâ drí. Ní âyê ãmâ tã õnjí ãmákâ rî ꞌbá yî ꞌásĩ, ãmâ drí rĩꞌá ꞌẽlâ rî ꞌbá yî tãsĩ, õzõ ãmâ drí rĩrĩ ãzí-ãzí gólĩyî rĩ ꞌbá tã õnjí ꞌẽlé ãmâ drí rî ꞌbá yî âyérẽ kâtí. Tã ûjũ-ûjũ ꞌá rî, ní ꞌbã ãmâ pı̣̃pı̣̂sı̣́lı̣́ ı̣̃ı̣̂dû ı̣̂dû, tãlâ mã õzó tã õnjí ꞌẽê.” ");
INSERT INTO avu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã ãzâ âtázó gólĩyî drí tã rãtáã ꞌẽꞌẽ kâ Ôvârí drí rî tãsĩ nõtí, “Õzõ tí tã ãzâ ꞌbá yî ãꞌdô trá õzõ nõtí rî. Ngạ́cı̣̂ ító ꞌá, õzõ ũmú ãzâ ãâcâ ní drí ꞌbã ꞌá võ jẽjẽ ãzâ ꞌásĩ rî, gõꞌdá ũmú rî ꞌdĩ rĩꞌá lõfó ró, gõꞌdá nî cú ĩtí ngá nyãnyã ãkó fẽlé ũmú ꞌdĩ drí nyãlé rî, gõꞌdá ní ngâ nĩlí ꞌbã-tı̣̂-ꞌdı̣̃-ãzí áníkâ ngálâ. Ní kĩ ꞌbã-tı̣̂-ꞌdı̣̃-ãzí ꞌdĩ drí rî, ũmú âcâ trá yí drı̣̃ı̣̂ võ jẽjẽ ꞌásĩ, yî cú ĩtí ngá nyãnyã ãkó fẽlé drílâ nyãlé, îcá kô âkórí drí ãmbãtã âfẽzó yí drí fẽlé drílâ yã? ");
INSERT INTO avu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ngbãângbânõ rî, má âtâ ãnî drí drẽ ãnî tã îjî-îjî sĩ. ꞌBã-tı̣̂-ꞌdı̣̃-ãzí áníkâ ꞌdĩ âꞌdô lôgõꞌá lâ ní drí kĩ nĩ rî, ‘Ní îkpókpólõ mâ kô, má âꞌbã ạ́tı̣̃ trá, má njı̣̃ı̣́ gõꞌdá ạ́tı̣̃ kô, ãmâ, ãmângá trá ãmâ mvá yí bê ậꞌdú kõꞌá.’ ");
INSERT INTO avu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Gõꞌdá ꞌbã-tı̣̂-ꞌdı̣̃-ãzí áníkâ ꞌdĩ âꞌdô ngãꞌá gbãrãkã drı̣̃ı̣̂ sĩ, ạ́tı̣̃ njı̣̃lı̣́ ní drí, ngá gólâ ní drí lẽlé rî âfẽzó ní drí. Gólâ ꞌê tã ꞌdî ĩtí tãlâ ãꞌdô ꞌî yã? Tãlâ ní gólâ rî rû-lẽ-ãzí ꞌî rî drí yã? ꞌÉꞌẽ, gólâ ꞌê tã ꞌdî ĩtí, tãlâ nî rĩꞌá zãâ tã îjíꞌá gólâ tı̣́, gólâ gõꞌdá lẽé õjílã drí tã ı̣̂sũlı̣́ kĩ, yî ꞌbã-tı̣̂-ꞌdı̣̃-ãzí õnjí ꞌî rî kô. Õzõ ãꞌdô ĩtí rî, Ôvârí gólâ tíbê ꞌbã ꞌbá kôrô ánî ꞌbã-tı̣̂-ꞌdı̣̃-ãzí drı̣̃ı̣̂ sĩ rî âꞌdô tã îjî-îjî áníkâ âríꞌá. ");
INSERT INTO avu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","“Õzõ õjílã ãzâ ĩîjî ngá ãzâ tã lâ Ôvârí tı̣́ rî, áâꞌdô fẽꞌá lâ té gólâ drí. Õzõ õjílã õrî ngá ãzâ ndãꞌá rî, áâꞌdô kpá ûsúꞌá lâ. Õzõ õjílã ãzâ õrî ạ́tı̣̃ gãlé rî, áâꞌdô njı̣̃ꞌá lâ gólâ drí. ");
INSERT INTO avu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Õzõ mvá ãzâ ũzı̣̂ ngá nyãnyã átá lâ tı̣́ rî, átá lâ fẽé kúnı̣́ mvá ĩꞌdî kô gólâ drí. Õzõ ũzı̣̂ ı̣̃ꞌbı̣̂ ꞌî rî, ófẽé ı̣̃nı̣̃ ĩꞌdî drílâ kô. ");
INSERT INTO avu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Õzõ ũzı̣̂ ꞌạ̃ꞌú ꞌbú ĩꞌdî rî, ófẽé ótónyî ĩꞌdî drílâ kpá kô. ");
INSERT INTO avu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nĩ ndrê drẽ, ãnî gólĩyî tíbê tã õnjí bê rî ꞌbá yî, nĩ fẽ kpá ngá tãndí ĩꞌdî ãnî mvá yî drí. Ngã gõꞌdá ãmâ átá tíbê ûrú ꞌálâ rî âꞌdô íyíkâ fẽꞌá lâ ãnî drí gạ̃rạ̃ kô yã? Õzõ nĩ ạ̃ậzı̣̂ Líndrí Tãndí gólâkâ ĩꞌdî rî, gólâ âꞌdô fẽꞌá lâ kpá ãnî drí.” ");
INSERT INTO avu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kậyı̣̂ ãzâ sĩ rî, Yésũ êdê ãgô ãzâ trá ngá lãzé líndrí õnjí kâ ꞌásĩ. Líndrí õnjí ꞌdĩ ꞌbã ãgô rî ꞌdĩ trá rĩlí cú ĩtí úlı̣́ âtá ãkó ũꞌdúꞌdû ró. Gõꞌdá éêdê ãgô ꞌdĩ bê rî, ãgô ꞌdĩ rî trá gõꞌdá tã âtálé íyî tı̣̂ sĩ tãndí ró õjílã drí ârílí. Õjílã gólĩyî ãgô ꞌdĩ ndrẽ ꞌbá Yésũ drí rĩrĩ êdérẽ lâ ꞌá rî âꞌdô ĩyî trá ndrĩ lârõ-lârõ ró. ");
INSERT INTO avu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gõꞌdá õjílã ãzâ ꞌbá yî gã dó tã-drı̣̃ lẽlé kĩ, mbârâkã gólâ Yésũ drí rĩzó õjílã êdélé ĩꞌdî sĩ lâ ꞌdĩ, âꞌdó Ôvârí ngá lésĩ kô, õjílã gólâ mbârâkã fẽ ꞌbá Yésũ drí rĩzó õjílã êdélé nõ rĩꞌá Sãtánã ĩꞌdî, tãlâ líndrí õnjí ꞌdĩ bê rĩꞌá Sãtánã bê mbârâkã Sãtánã kâ zẽlé. ");
INSERT INTO avu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Õjílã ãzâ ꞌbá yî tã lẽlẽ ãkó rî, lẽ ĩyî Yésũ rî ûjũlı̣́ kĩ nĩ rî, gólâ âꞌdô ngá âdó ꞌbá ꞌî, ꞌdõvó gólâ õꞌê drẽ kpá tã lârâkô ngĩî gólĩyî õndrê ró bê gólĩyî ũnı̣̃ ró bê kĩꞌá nĩ rî, Ôvârí fẽ mbârâkã ꞌdî nĩ gólâ drí. ");
INSERT INTO avu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gõꞌdá Yésũ nı̣̃ tã ı̣̂sũ-ı̣̂sũ õnjí õjílã ꞌdî ꞌbá yí kâ ꞌdĩ trá kĩ nĩ rî, gólĩyî lẽ trá kõlõgbõ cãlé yí drí. Gólĩyî lẽ âꞌdálâ kĩ, Ôvârí âꞌdó ĩꞌdî kô íyî âjó ꞌbá rî. Gõꞌdá Yésũ âtâ tã trá õjílã ꞌdî ꞌbá yî drí kĩ nĩ rî, “ꞌBạ̃súrú gólâ tíbê lãfálé cã ꞌbá rı̣̃ gõzó rĩlí rû fũlı̣́ ĩyî võ ꞌásĩ rî âꞌdô rĩꞌá fí trá zı̣̃lı̣́ ꞌbạ̃súrú ãlô ró yã? ꞌBã gólâ rĩzó lâwãlé ꞌá lâ ı̣̃tú vósĩ cé ãzí-ãzí bê rî, âꞌdô rĩꞌá trá võ ãlô ꞌá ꞌbã-tı̣̂ ãlô ró yã? ");
INSERT INTO avu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Õzõ õjílã gólĩyî ậyı̣́ ꞌbá ꞌdó Sãtánã zẽlé rî õrî ĩyî lâwãlé kárá rî, kũmũ Sãtánã kâ âꞌdô rĩꞌá ãlô rî ángô tí yã? ꞌÉꞌẽ, îcá rĩlí kô. Rĩꞌá pạ̃tı̣́ı̣̃ ró, Sãtánã âꞌdô vólé gãꞌá dó mbârâkã âfẽlé má drí. Nĩ ı̣̂sũ ãníkâ bê rî, Sãtánã fẽ mbârâkã nĩ má drí rĩzó líndrí õnjí ạ̃bạ̃bạ̃ kâ lôfõlé õjílã ꞌásĩ ꞌdî. Õzõ ãꞌdô ĩtí rî, Sãtánã âꞌdô kpá mbârâkã âfẽꞌá má drí rĩzó líndrí õnjí gólâkâ gólâ rî úfú zẽlé ꞌdĩ ꞌbá yî îzãzó yã? ");
INSERT INTO avu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Gõꞌdá nĩ ı̣̂sũ drẽ tã dã ãnî drı̣̃ı̣̂, tã gólâ má drí ꞌẽꞌá âtálâ ãnî drí nõ tãsĩ. Õzõ Sãtánã ãꞌdô ĩꞌdî mbârâkã fẽ ꞌbá ró má drí rî, gõꞌdá ãꞌdî fẽ íyíkâ mbârâkã ãnî drı̣̃-ꞌbá yî drí rĩzó líndrí õnjí lôfõlé õjílã ꞌásĩ rî nĩ yã? Nĩ îjî tã drẽ drı̣̃-ꞌbá ꞌdĩ ꞌbá yî tı̣́, ãꞌdî fẽ mbârâkã ꞌdî gólĩyî drí nĩ yã? Drı̣̃-ꞌbá ꞌdĩ ꞌbá yî âꞌdô âtáꞌá lâ ãnî drí kĩ, Ôvârí âfẽ mbârâkã nô nĩ ĩyî drí. ");
INSERT INTO avu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gõꞌdá mâ rî gógó kpá rĩꞌá mbârâkã Ôvârí ngá lésĩ rî bê. Nĩ ndrê drẽ, gólâ rî gógó tíbê mbârâkã ꞌbá ró ꞌẽ ꞌbá ãnî pãlé rî, mâ ĩꞌdî rĩꞌá nõ. Ôvârí âjô mâ nĩ ãnî lı̣̃fı̣́ îcílí, mâ ĩꞌdî tíbê ãnî drí ꞌẽꞌá rõlâ rî. ");
INSERT INTO avu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Sãtánã rĩꞌá õzõ ãgô ạ̃wạ̃lạ̃kạ̃ ꞌbá íyíkâ rĩ ꞌbá íyî mvá yî vó ndrẽlé ndrẽndrẽ ạ̃jú sĩ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Õzõ ãgô ãzâ kpá ạ̃wạ́lạ́kạ́ ró mbârâkã lâ drí gólâ rî lậvũlı̣́ gạ̃rạ̃ rî ãânĩ kpá ꞌdẽlé õmbã bê gólâ drı̣̃ı̣̂ rî, âꞌdô gólâ rî drõꞌá cú ꞌbã ꞌásĩ ꞌdĩyímvá gólâkâ ꞌdĩ ꞌbá yî ûwũzó ngbá ngá ꞌbã kâ bê. ");
INSERT INTO avu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Má îmbâ ãnî lı̣̃fı̣́ ĩꞌdî nõ. Nĩ rî kô õmbã Ôvârí yî lãfálé ꞌá Sãtánã bê rî tẽlé. Pạ̃tı̣́ı̣̃ ró, õmbã rî ꞌdĩ ꞌẽꞌá âcálé. Õzõ nĩ ạ̃ậmû ꞌâ má bê kpãkã ãlô kô rî, nĩ lẽ gõꞌdá trá ꞌâ ậmúlı̣́ ạ̃jú-ꞌbá-ãzíyã Sãtánã bê. Ãnî drí ámâ pãlé õjílã Ôvârí kâ êꞌbélé võ ãlô ꞌá õzõ kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá drí kạ́bı̣̃lı̣́kı̣̃ íyíkâ êꞌbérẽ kâtí. Õzõ nĩ õꞌê ĩtí kô rî, nĩ lẽ gõꞌdá trá õjílã Ôvârí kâ lâpẽlé má rú sĩ vólé. Gõꞌdá ꞌdĩî ꞌásĩ rî, Ôvârí âꞌdô tã âtáꞌá kĩ nĩ rî, ‘Ãnî ámâ ạ̃jú-ꞌbá-ãzí ꞌî.’ ");
INSERT INTO avu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Má lẽ trá tã ãzâ âtálé ãnî drí nõngá líndrí õnjí ꞌbá tãsĩ. Õzõ líndrí õnjí Sãtánã ꞌásĩ ꞌdî ãâyê õjílã trá rî, drílâ rĩzó nĩꞌá lậmú bê élê nĩꞌá õjílã ãzâ ꞌbá yî ndãlé, nĩzó rĩlí ꞌâ lâ ꞌá. Õzõ ũûsû õjílã ꞌâ ãzâ kô drílâ rĩzó ꞌá lâ rî, âꞌdô õjílã sı̣́sı̣́ ꞌdĩ nı̣̃ꞌá, gõꞌdá drílâ âgõzó óꞌdí. ");
INSERT INTO avu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Õzõ õjílã ꞌdî ạ̃ậzı̣̂ Líndrí Tãndí Ôvârí kâ íyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá kô líndrí õnjí ꞌdĩ võ lâ ꞌá rî, líndrí õnjí ꞌdĩ õtírĩ âgõô rî, âꞌdô gólâ rî pı̣̃pı̣̂sı̣́lı̣́ ûsúꞌá zãâ tãkó ĩtí íyî tẽꞌá ngbángbá, õzõ jó gólâ tõtõ ậkũzó trá ꞌálâ sĩ êdélé ũmú drí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Gõꞌdá líndrí õnjí ꞌdĩ âꞌdô ãzí-ãzí êꞌbéꞌá dũû ânĩzó rĩlí võ ꞌdî ꞌá, ꞌdĩî rî âꞌdô ꞌbãꞌá lâŋõ ró ãmbá lậvũlı̣́ sı̣́sı̣́ rî drı̣̃ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gõꞌdá Yésũ drẽ rĩꞌá tã ạ̃dũkũ íyíkâ âtáꞌá õꞌbí ãmbá rĩ ꞌbá ĩtí ꞌdĩ ꞌbá yî drí rî, gõꞌdá õkó ãzâ õꞌbí ꞌdĩ ꞌbá yî lãfálé ꞌásĩ, drílâ trẽzó úlı̣́ bê Yésũ drí kĩ nĩ rî, “Õkó ãzâ gólâ ꞌbã ꞌbá ánî ândrê ró nõ, Ôvârí fẽ ãyĩkõ trá drílâ lậvũlı̣́ kôrô.” ");
INSERT INTO avu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gõꞌdá Yésũ drí tã âtázó õkó ꞌdĩ drí nõtí, “Ôvârí âꞌdô ãyĩkõ fẽꞌá lậvũlı̣́ kôrô õjílã gólâ rĩ ꞌbá úlı̣́ má drí âtálé nõ ârílí rî drí gõꞌdá kpá rõ ꞌbá lâ rî drí.” ");
INSERT INTO avu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gõꞌdá nĩngá sĩ rî, õꞌbí ãmbá ꞌdĩ ꞌbá yî trá ậsı̣́ꞌá dîrî gbãâ Yésũ rú sĩ, õzõ õbẽbẽwá drí vó bẽrẽ gbãâ rî kâtí. Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Õjílã rĩꞌá ãmbá tã lẽlẽ ãkó. Gólĩyî lẽ má drí tã lârâkô ꞌẽlé gólĩyî lı̣̃fı̣́ drı̣̃ ꞌá. Má gã dó tã lârâkô ꞌẽlé gólĩyî lı̣̃fı̣́ drı̣̃ ꞌá. Ạ̃dũkũ lâ, gólĩyî âꞌdô ĩyî tã lârâkô ãzâ ndrẽꞌá cé ãlô, õzõ tã âꞌdâ-âꞌdâ kâtí, õzõ tã tíbê Ôvârí drí ꞌẽlé Yónã drí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tã Yónã kâ rî rĩꞌá nõtí. Ạ̃kû ró, ı̣̃ꞌbı̣̂ ạ́ngı̣́ ãzâ tê gólâ trá nyé yí ꞌá. Gõꞌdá Ôvârí drí ı̣̃ꞌbı̣̂ ꞌdĩ ꞌbãzó gólâ rî lôꞌdélé vólé lédrẽ-lédrẽ ró. Gõꞌdá õjílã gólĩyî ꞌbạ̃drı̣̃ Nínĩvẽ kâ rî ꞌbá yî ꞌá rî ârî ĩyî tã ꞌdî bê rî, gólĩyî drí nı̣̃zó lâ kĩ nĩ rî, Ôvârí âjô gólâ nĩ ĩyî ngálâ. Gõꞌdá tã ámákâ rî rĩꞌá nõtí, Ôvârí âꞌdô kpá ámâ ꞌbãꞌá âꞌdólé lédrẽ-lédrẽ ró má drí ꞌbãzó ꞌbú ꞌálâ rî vósĩ. Gõꞌdá ꞌdĩî rî vósĩ rî, õjílã gólĩyî rĩ ꞌbá ãngó ꞌá nõngá nõ ꞌbá yî rî âꞌdô ĩyî nı̣̃ꞌá lâ kĩ nĩ rî, Ôvârí âjô mâ nĩ. ");
INSERT INTO avu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Ị̃zạ́tú kậyı̣̂ gólâ Ôvârí drí tã-vó ãnî õjílã kâ rî kĩzó rî ꞌá rî, õjílã gólĩyî Nínĩvẽ kâ rî âꞌdô ꞌbãꞌá kpá ĩtí tı̣̂ gã ꞌbá ró ícícíyá ꞌẽlé ãnî tíbê tã ârí ꞌbá kô rî ꞌbá yî rú, tãlâ õjílã gólĩyî Nínĩvẽ kâ rî ꞌbá yî ârî ĩyî tã Yónã kâ bê rî, drílĩyî drı̣̃ âdĩzó tã õnjí ꞌásĩ. “Gõꞌdá kúmú ãzâ kpá gólâ võ jẽjẽ ãzâ kâ rî rĩꞌá õkó ꞌî. Gólâ âꞌdô ꞌbãꞌá tólâ kpá ĩtí ícícíyá ꞌẽlé ãnî gólĩyî tã lẽ ꞌbá kô rî ꞌbá yî rú. Gólâ ânĩ trá võ jẽjẽ ꞌásĩ úlı̣́ tã nı̣̃nı̣̃ kâ ârílí kúmú Sólõmõ sı̣́lı̣́ sĩ. Gõꞌdá mâ tíbê âjólé ûrú lésĩ rî âꞌdô ꞌbãꞌá gạ̃rạ̃ kúmú Sólõmõ drı̣̃ı̣̂ sĩ. Gõꞌdá nĩ lẽé úlı̣́ ámákâ ârílí kô. Ngbãângbânõ, má rî tã Ôvârí kâ îcíꞌá ãnî drí, gõꞌdá nĩ lẽé kô ârílâ má tı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ꞌDõvó nĩ ârî drẽ, õjílã ãzâ yûꞌdạ́wạ́ lạ̃sı̣́ îꞌĩlí drı̣̃ lâ âkólé límvó zẽlé. Õzõ õjílã ĩîꞌĩ lạ̃sı̣́ îngálé ûrû rî, õjílã õtírĩ ꞌẽê fĩlí jó ı̣́nı̣́rı̣́kúwạ́ ró rî ꞌá rî, âꞌdô ndrẽꞌá lâ tõ. Úlı̣́ ámákâ rî ĩyíkâ õzõ lạ̃sı̣́ îꞌĩlí lậpı̣́lı̣́ límvó zẽlé kô rî kâtí. Îcá té tã lârâkô ꞌẽzó ĩꞌdî rî kô. ");
INSERT INTO avu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Võ îꞌĩ-îꞌĩ drí fĩzó bũúũ ꞌá lâ ngbángbá. Õzõ ãnî lı̣̃fı̣́ ãꞌdô ngá lãzé ró rî, ngá îꞌĩ fí kô, âꞌdô ꞌbãꞌá ı̣́nı̣́rı̣́kúwạ́ ró. Õzõ nĩ ãârî úlı̣́ ámákâ kô rî, ãnî nyé õzõ lı̣̃fı̣́ gólâ ngá lãzé ró rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Úlı̣́ ámákâ nõ âꞌdô ꞌbãꞌá õzõ ngá îꞌĩ-îꞌĩ kâtí, ãnî lı̣̃fı̣́ õmbâ ãnî rú, ãnî drí úlı̣́ ámákâ trõzó ꞌbãlé ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌá tãlâ úlı̣́ ámákâ nõ rî rĩlí võ îꞌĩlí ãnî pı̣̃pı̣̂sı̣́lı̣́ ꞌá, õzõ võ îꞌĩ-îꞌĩ ngbángbá rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Gõꞌdá ꞌdĩî rî vósĩ rî, Pạ̃rúsı̣̃ ãzâ drí Yésũ rî zı̣̃zó ânĩlí ngá nyãlé yí bê. Gõꞌdá Yésũ drí âcázó rĩlí vũdrı̣́ õzõ lãꞌbí gólĩyíkâ rî tí. Drílâ gõzó îtónãlé ngá nyãlé. ");
INSERT INTO avu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gõꞌdá gólâ îjí lı̣̃mvû tã kô íyî drı̣́ jĩzó bũúũ kûlúgûsú ꞌá, õzõ lãꞌbí Pạ̃rúsı̣̃ kâ rî tí. Pạ̃rúsı̣̃ ꞌdĩ trá lârõ-lârõ ró. ");
INSERT INTO avu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gõꞌdá Yésũ drí tã âtázó Pạ̃rúsı̣̃ ꞌdĩ drí kĩ nĩ rî, “Ãnî ãnî ãzí-ãzí yí bê gólĩyî âꞌdó ꞌbá Pạ̃rúsı̣̃ ró rî ꞌbá yî, nĩ ârî drẽ. Nĩ rô lãꞌbí ãníkâ trá tákányĩ. Nĩ jĩ ãníkâ cé ãnî rúmvạ́ ĩꞌdî, gõꞌdá ãnî pı̣̃pı̣̂sı̣́lı̣́ drí ĩyíkâ rĩzó ı̣̃ndı̣̂ ró. Má âtâ tã ꞌdî tãlâ ãnî ngá lôvó ꞌbá ꞌî, gõꞌdá nĩ âꞌdô kpá õjílã gólĩyî ĩzã ꞌbá ró rî yî ꞌbãꞌá ậdı̣̂ ĩyíkâ fẽlé ãnî drí. ");
INSERT INTO avu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","41","Õzõ nĩ õjĩ cé límvó rúꞌbạ́ ĩví lésĩ rî ĩꞌdî rî, nĩ ı̣̂sũ ãníkâ bê rî, ꞌálé lâ âꞌdô ꞌbãꞌá kpá ngbángbá yã? Nĩ jĩ ãnî pı̣̃pı̣̂sı̣́lı̣́ kpá, Ôvârí ẽêdê ró kpá ãnî rúꞌbạ́ ãnî pı̣̃pı̣̂sı̣́lı̣́ bê. Gõꞌdá ãꞌdô ĩtí rî, nĩ âyê ngá lôvó vólé, ậdı̣̂ ãnî lĩkítí ꞌá, ãnî drí rĩꞌá ꞌbãlâ ꞌdĩ, nĩ fẽ ĩzã ꞌbá drí, ãnî pı̣̃pı̣̂sı̣́lı̣́ ãꞌdô ró bê ngbángbá. ");
INSERT INTO avu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ãnî Pạ̃rúsı̣̃ yî, lâŋõ ạ́ngı̣́ âꞌdô ãnî ꞌẽꞌá, tãlâ nĩ rî trá tã õnyíkõ ãmbá lãꞌbí ãníkâ rî ꞌbá yí kâ vó lâ lôbẽlé ı̣́ndı̣̂-ı̣́ndı̣̂, gõꞌdá tã ꞌbãꞌbã tíbê Ôvârí kâ rî âyézó vũdrı̣́. Tã âꞌdâ-âꞌdâ lâ rĩꞌá nõtí, nĩ câ ạ́mvú ãníkâ ạ̃túbı̣́ kâ lãfálâ mûdrı̣́, gõꞌdá ãlô rî ãnî drí fẽzó lâ Ôvârí drí, gõꞌdá nĩ lẽé õjílã gólĩyî ĩzã ró rî ꞌbá yî vó lâ ndrẽlé kô. ꞌDĩî rî, nĩ lẽé Ôvârí pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ãnî Pạ̃rúsı̣̃ nô ꞌbá yî, nĩ lẽ ãníkâ rĩlí ꞌdó rĩ-võ ãmbâ-ãmbâ drı̣̃ı̣̂ sı̣́sı̣́ lésĩ õjílã ágálé, õzõ nĩ õtírĩ nĩî jó tã ârí kâ rî ꞌálâ rî, nĩ lẽ õjílã õfẽ ró nî-bê-yã ĩyî drí rĩzó ĩyî ı̣̂njı̣̃lı̣́ võ rû êꞌbê kâ ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Õjílã ꞌdî ꞌbá yî nı̣̃ı̣́ kô kĩ, ãnî pı̣̃pı̣̂sı̣́lı̣́ âꞌdô rĩꞌá ı̣̃ndı̣̂ ró.” ");
INSERT INTO avu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Gõꞌdá ãgô ãzâ rĩ ꞌbá lãꞌbí îmbálé rî drí ngãzó tã âtálé Yésũ drí kĩ nĩ rî, “Õzõ ní ãâtâ tã trá ĩtí õjílã gólĩyî Pạ̃rúsı̣̃ ró rî yî drí rî, ꞌdĩî rî, ní rî kpá gólĩyî rĩ ꞌbá lãꞌbí îmbálé rî ꞌbá yî ꞌbãꞌá ꞌdásí ꞌẽzó rú lâ ĩyî.” ");
INSERT INTO avu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nĩngá sĩ, Yésũ drí tã âtázó ãgô ꞌdĩ drí kĩ, “Tã pạ̃tı̣́ı̣̃ ró, õjílã gólĩyî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî, Ôvârí âꞌdô lâŋõ fẽꞌá gólĩyî drí, tãlâ lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî rî ĩyî tã ãzâ ꞌbá yî lãꞌbí kâ lôpélé dũû õjílã drí ꞌẽlé. Tã õnyíkõ ꞌdî ꞌbá yî ndrĩ êꞌbê rû gõꞌdá trá dũû gólĩyî ômbê kúkú ꞌá lậnjı̣̃-lậnjı̣̃ ró, õzõ ngá lậnjı̣̃ kâtí. Ãnî gólĩyî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî rî ĩyî ngá êꞌbélé dũû lậnjı̣̃-lậnjı̣̃ ró õjílã drí njı̣̃lı̣́, gõꞌdá nĩ lẽé gólĩyî pãlé njı̣̃rı̣̃ lâ ꞌá gõꞌdá kpá kô. ");
INSERT INTO avu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nĩ rî lóꞌdé tãndí óꞌdí bẽlé võ ãzâ ꞌbá yî ꞌásĩ ngĩíngî võ gólĩyî tíbê tã ậngũ ꞌbá Ôvârí kâ rî ꞌbá yî ãvõ lâ ꞌbãzó rî ꞌá. Nĩ ꞌê ĩtí, tãlâ õjílã õlôngô ró ãnî tã bê, gõꞌdá ãnî ạ́ꞌbı̣́yạ́ yî gâ ĩyî vólé dó úlı̣́ tã ậngũ ꞌbá ꞌdĩ ꞌbá yí kâ ârílí, gõzó tã ậngũ ꞌbá yî fũlı̣́ vólé. ");
INSERT INTO avu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nĩ trõ ãníkâ ꞌdĩ té ãnî ạ́ꞌbı̣́yạ́ yî lârâkô ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Õzõ ãndrõ nô Ôvârí ãâjô tã ậngũ ꞌbá ãzâ rî, nĩ âꞌdô úlı̣́ gólâkâ gãꞌá dó, gõꞌdá ãnî drí kpá gólâ rî fũzó vólé. Tã pạ̃tı̣́ı̣̃ ró, Ôvârí kĩ, yí âꞌdô võrã âjóꞌá tã ậngũ ꞌbá íyíkâ bê tã âtálé ãnî drí, ãnî rî gógó âꞌdô gólâ rî drõꞌá vólé kpá gólâ rî fũzó. ");
INSERT INTO avu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ôvârí âꞌdô kpá ãnî îzãꞌá vólé. Ôvârí âꞌdô ícícíyá ꞌẽꞌá ãnî rú, tãlâ tã ậngũ ꞌbá yî ãnî drí fũlı̣́ ãmbá kó îtõ võ ãngó kâ rî ꞌá bũúũ ı̣̃tú ãndrõ nô ꞌá rî tãsĩ, ");
INSERT INTO avu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","îtõlé kó sı̣́sı̣́ Ábẽlẽ drı̣̃ı̣̂ sĩ bũúũ âcálé ãzâ rú bê Zẽkãríyã rî rú, úfû Zẽkãríyã íyíkâ jó ạ́ngı̣́ Ôvârí kâ rî ꞌá, ãnyî võ kõrõnyã zã kâ lạ̃gạ́tı̣́. Ãnî õjílã gólĩyî ꞌbã ꞌbá drẽ lédrẽ-lédrẽ ró rî, Ôvârí âꞌdô ãnî îzãꞌá kpá lâŋõ fẽzó ãnî drí tã õnjí ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ãnî gólĩyî lãꞌbí îmbá ꞌbá ró ꞌdĩ ĩyíkâ õzõ õjílã gólĩyî ꞌbã ꞌbá gbákálã-fê, jó tı̣́lı̣́-tı̣̂ Ôvârí kâ îgbálákãzó ĩꞌdî sĩ lâ rî kâtí. Gbákálã-fê íyíkâ õzõ tã nı̣̃nı̣̃ gólâ ꞌẽzó ãmâ pãlé mbârâkã tã õnjí kâ ꞌásĩ rî kâtí. Ãnî lãꞌbí îmbá ꞌbá yî, nĩ lẽé kô ạ́tı̣̃ Ôvârí kâ njı̣̃lı̣́ õjílã drí fĩzó jó tı̣́lı̣́-tı̣̂ ꞌdĩ ꞌásĩ. Ôvârí âꞌdô kpá gólĩyî pãꞌá, drílĩyî fĩzó, gõꞌdá ãnî rî gógó, nĩ fí kô.” ");
INSERT INTO avu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Gõꞌdá Yésũ drí võ ꞌdî âyézó. Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yí bê drí rĩzó tã âtálé ꞌálé âdrã sĩ Yésũ rú. Kậyı̣̂ ꞌdĩ ꞌá rî, Yésũ gõꞌdá trá zãâ gólĩyî ạ̃jú-ꞌbá-ãzíyã ꞌî, gõꞌdá gólĩyî rî trá Yésũ rî îjílí tã îjî-îjî ãzâ ꞌbá yî sĩ dũû, ");
INSERT INTO avu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tãlâ Yésũ ạ̃ậvı̣̃ ró bê úlı̣́ ãzâ ꞌbá yî ꞌá, gõꞌdá yĩ ũrû ró gólâ bê úlı̣́ âfõ ꞌbá gólâ sı̣́lı̣́ sĩ rî sĩ, ãꞌdô ró bê ĩyî drí ícícíyá ꞌẽzó gólâ rú gólĩyî sı̣́sı̣́-lésĩ rî drí, ãꞌdô ró bê gólâ rî fũzó vólé. ");
INSERT INTO avu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kậyı̣̂ vósĩ cé, õꞌbí ãmbá êꞌbê rû trá zãâ rĩꞌá Yésũ rî vó bẽlé. Õjílã trá dũû. Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá íyíkâ drí kĩ nĩ rî, “Ãnî lı̣̃fı̣́ õmbâ ãnî rú, nĩ trõ tã Pạ̃rúsı̣̃ yí kâ kô. Pạ̃rúsı̣̃ yî rî ĩyíkâ tã âtálé kôrô Ôvârí rî rõrõ tãsĩ, gõꞌdá gólĩyî ꞌé ĩyî tã lâ kô, gõꞌdá gólĩyî rî rĩlí tã lãꞌbí ĩyíkâ rî kâ ꞌẽlé ĩꞌdî, gólĩyî pı̣̃pı̣̂sı̣́lı̣́ sú kô. ");
INSERT INTO avu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gõꞌdá ı̣̃zạ́tú rî, Ôvârí âꞌdô tã gólĩyî õjílã pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî âꞌdáꞌá ãlô-ãlô ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Îcá kô õjílã ãlô ãnî lãfálé ꞌásĩ rî drí úlı̣́ ãyãyã ãnî drí rĩꞌá âtálâ jó ı̣́nı̣́rı̣́kúwạ́ ró rî ꞌá rî lậpı̣́lı̣́, ãyãyã rî ꞌdĩ âꞌdô âꞌdóꞌá úlı̣́ ngbạ́lạ́-ngbạ́lạ́ ró õjílã ndrĩ drí ârílí ꞌbũû.” ");
INSERT INTO avu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nĩ ârî drẽ, nĩ rô õjílã gólâ mbârâkã bê ꞌẽ ꞌbá ãnî rúꞌbạ́ ı̣̃nyạ́kú fũlı̣́ rî kô. ");
INSERT INTO avu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nĩ rô cé Ôvârí ĩꞌdî, tãlâ gólâ îcâ kpá ãnî ꞌbãlé drãlé, gõꞌdá gólâ îcâ kpá ãnî ꞌbãlé võ gólâ lạ̃sı̣́ ạ̃dũkũ ãkó rĩ ꞌbá vẽlé rî ꞌá, tãlâ tã õnjí ãníkâ tãsĩ. Gólâ ĩꞌdî rĩꞌá ãnî drí ꞌẽꞌá rõlâ rî. ");
INSERT INTO avu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nĩ ârî drẽ, õzõ nĩ õgî ãríwá mvá rĩꞌá sõlâ fê sı̣́lı̣́ dãdãwá ꞌdĩ ꞌbá yî ĩꞌdî nyãlé lãfâ fínyáwá sĩ rî, õjílã ꞌbãá lı̣̃fı̣́ drı̣̃ lâ kô. Gõꞌdá ãríwá dãdãwá rî ꞌdĩ ꞌbá yî, Ôvârí nı̣̃ gólĩyî trá ãlô-ãlô ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nĩ ndrê trá, Ôvârí lã õjílã drı̣̃-ꞌbí ꞌdĩ trá ndrĩ ãlô-ãlô, ꞌbãá ãnî tã vı̣̃lı̣́ kô. Ãꞌdô ĩtí rî, nĩ ꞌê ũrı̣̃ kô, tãlâ Ôvârí lẽ ãnî trá kôrô lậvũlı̣́ ngá õnyíkõ ndrĩ drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yésũ kĩ nĩ rî, “Õzõ nĩ ãâꞌdâ tã gólâ ãnî drí tã ámákâ lẽzó ꞌdĩ trá õjílã lı̣̃fı̣́ drı̣̃ ꞌá rî, gõꞌdá má âꞌdô kpá âꞌdáꞌá lâ ámâ átá rî lı̣̃fı̣́ drı̣̃ ꞌá kĩꞌá nĩ rî, ãnî nõ õjílã ámákâ ĩꞌdî. Gõꞌdá mãlãyíkã Ôvârí kâ âꞌdô ĩyî kpá tã ꞌdî ꞌbá yî nı̣̃ꞌá ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Õzõ nĩ õgã dó ꞌdẽlé má vó õjílã lı̣̃fı̣́ drı̣̃ ꞌá ũrı̣̃ drí sĩ rî, gõꞌdá má âꞌdô vólé gãꞌá kpá dó ãnî âꞌdálé ámâ átá drí mãlãyíkã íyíkâ rî ꞌbá yí bê. Nĩ âꞌdó õjílã ámákâ kô. ");
INSERT INTO avu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nĩ ârî drẽ, má âtâ tã ãzâ gólĩyî tíbê ámâ gã ꞌbá dó rî ꞌbá yî drí, õzõ gólĩyî õꞌê ꞌdásí mâ tíbê âjólé ûrú lésĩ nô rú rî, gõꞌdá gólĩyî drí Ôvârí rî îjízó ĩyî âyélé tã õnjí ĩyíkâ ꞌdĩ tãsĩ rî, Ôvârí âꞌdô gólĩyî âyéꞌá. Õzõ nĩ ãâtâ kĩ nĩ rî, mbârâkã ámákâ nõ ãꞌdô íyíkâ Sãtánã kâ ĩꞌdî, mbârâkã ámákâ rî ãâꞌdó kô Líndrí Tãndí Ôvârí kâ sĩ rî. Õzõ nĩ ĩîjî Ôvârí ãnî pãlé rî, Ôvârí îcá kô ãnî pãlé tã õnjí ãníkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ãnî tíbê ꞌbã ꞌbá õjílã ámákâ ró rî, nĩ ârî drẽ. Õzõ õjílã ãzâ õfẽ ãnî drı̣́-bã ícícíyá ꞌẽzó ãnî rú, ãnî ꞌbãzó âdrélé õjílã ãmbâ-ãmbâ ꞌbãlé jó tã ârî kâ rî ꞌá rî ágálé, ngã ꞌbô kúmú ágálé tã Ôvârí kâ rî sĩ rî, nĩ ꞌê ũrı̣̃ kô, ");
INSERT INTO avu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tãlâ Líndrí Tãndí Ôvârí kâ âꞌdô úlı̣́ tãndí ꞌbãꞌá ãnî sı̣́lı̣́ âtálé.” ");
INSERT INTO avu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ãgô ãzâ rĩꞌá õꞌbí ãmbá ĩtí ꞌdĩ ꞌásĩ, ãgô ꞌdĩ drí Yésũ rî îjízó nõtí kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá, ní âtâ tã ámâ ậdrúpı̣̃ sı̣́sı̣́ rî drí, gólâ ãâfẽ drı̣́-vó ãmâ átá kâ rî ũrûkậ lâ má drí âꞌdô lãꞌbí ãmákâ rî vó ró, tãlâ ꞌdĩ rî ngá ạ̃dũkũ ãmâ átá drí ꞌẽlé rî ĩꞌdî. Gõꞌdá gólâ lẽé tã ꞌdî ꞌẽlé kô.” ");
INSERT INTO avu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yésũ jâ tã-drı̣̃ ꞌdî trá gólâ drí kĩ nĩ rî, “Má âꞌdó mvá sı̣́sı̣́ ꞌbạ̃súrú ãníkâ rî ꞌá rî ĩꞌdî kô tã ãníkâ ꞌdĩ âtálé yã?” ");
INSERT INTO avu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yésũ âtâ tã trá õꞌbí ãmbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ꞌbã ãnî lı̣̃fı̣́ ngá ãmbá dũû rî drı̣̃ı̣̂ kô, tãlâ rĩrĩ ãmákâ ãngó nõ ꞌá rî âꞌdó kô ãnî drí ꞌbãzó ngá-tı̣̂ bê ãmbá. Õzõ nĩ õꞌbã ãnî lı̣̃fı̣́ ngá ãmbá dũû rî drı̣̃ı̣̂ rî, nĩ âꞌdô ꞌẽꞌá lạ́tı̣̂ võ ûrú ꞌálâ rî kâ ı̣̂vı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","“ꞌDõvó má âtâ drẽ íꞌdígówá ãzâ ãnî drí, nĩ ârî ró bê. Ãgô ãzâ rĩꞌá ạ́mvú íyíkâ bê ạ̃drúgú lâ rĩꞌá rõô. Gólâ trõ ạ̃drúgú trá ndrô ꞌdĩ ꞌá rõô. ");
INSERT INTO avu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gólâ rî trá tã ı̣̂sũlı̣́ nõtí kĩ nĩ rî, ‘Mâ ẽró ạ́ngı̣́ ãkó má drí ạ̃drúgú ꞌbãzó ꞌá lâ. ");
INSERT INTO avu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Âꞌdô bê trá ĩtí rî, má lẽ trá ẽró gólâ ạ̃kû rî ûfúlı̣́ vólé óꞌdí lâ ꞌdı̣̃zó ĩꞌdî võ lâ ꞌá ạ́ngı̣́ ró, má drí ạ̃drúgú ámákâ ãmbá ꞌdĩ ꞌbãzó ndrĩ ꞌá lâ ngá õnyíkõ bê ndrĩ, ");
INSERT INTO avu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","tãlâ ndrô ãzâ rĩ ꞌbá âgõlé nã sĩ rî, má ãꞌdô ró bê ngá nyãnyã bê dũû, gõꞌdá má lẽé gõꞌdá ạ́mvú ãzâ ꞌwãlé kô, tãlâ má rî ró tãkó ĩtí cé ngá nyãlé ĩꞌdî ãyĩkõ sĩ.’ ");
INSERT INTO avu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Gõꞌdá Ôvârí drí tã âtázó ãgô ꞌdĩ drí kĩ nĩ rî, ‘Ánî drı̣̃ yû. Gõꞌdá ngạ́cı̣̂ ãndrõ nô sĩ, má âꞌdô fê áníkâ ŋõꞌá. Ní âꞌdô ngá áníkâ ãmbá ꞌdĩ ꞌbá yî âyéꞌá ãꞌdî drí yã?’ Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Gõꞌdá Yésũ kĩ, “Íꞌdígówá má drí âtálé ꞌdĩ rĩꞌá õjílã gólĩyî ĩyîngá lẽ ꞌbá ꞌbãlé ngá bê ãmbá ãngó nõ ꞌá rî ꞌbá yî drí. Õzõ ãꞌdô trá ĩtí rî, tãndí ró ãmâ drí tã Ôvârí kâ rî ꞌẽzó ĩꞌdî ãngó nõ ꞌá, tãlâ ĩzã õzó ãmâ ꞌẽê kô ı̣̃zạ́tú.” ");
INSERT INTO avu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá íyíkâ rî ꞌbá yî drí kĩ nĩ rî, “Má âtâ ĩꞌdî ãnî drí nõ, nĩ lôꞌbê lı̣̃fı̣́ kô ngá nyãnyã ãngó nõ kâ tãsĩ, ítá sõsõ, ãyĩkõ ãngó nõ kâ rî bê. Îcâ ãnî drí rĩꞌá Ôvârí rî tã lôngólé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nĩ õrî cé tã ı̣̂sũlı̣́ ngá-tı̣̂ ãmbá tãsĩ rî, Ôvârí ꞌbãá ãnî rúmvạ́ âsô-âsô ró kô. ");
INSERT INTO avu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nĩ ndrê drẽ gbõ tã âꞌdâ-âꞌdâ lâ ãríwá tãsĩ, gólĩyî cú ĩtí ạ́mvú ãkó kpá ẽró ãkó ãngó ꞌá nõngá, gõꞌdá Ôvârí rî ngá nyãnyã fẽlé nĩ gólĩyî drí kậyı̣̂ vósĩ cé. Ngã gõꞌdá ãnî rî gógó õjílã mvá ró, Ôvârí drí lẽlé kôrô ãríwá drı̣̃ı̣̂ sĩ rî. ");
INSERT INTO avu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Õzõ nĩ õrî lı̣̃fı̣́ lôꞌbélé lôꞌbê rî, âꞌdô Ôvârí rî ꞌbãꞌá fí trá kậyı̣̂ ãníkâ lôpélé ạ̃tı̣́ ꞌálâ yã? ");
INSERT INTO avu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Õzõ ãꞌdô ĩtí kô rî, tãlâ ãꞌdô ꞌî ãnî drí rĩzó lı̣̃fı̣́ lôꞌbélé ĩtí yã? ");
INSERT INTO avu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nĩ ndrê drẽ gbõ fê fõô õmã ꞌálâ rî, rĩꞌá sũsũ ró, lârâkô lâ ĩyî ꞌdó ngĩíngî. Gólĩyî ꞌé lôsĩ fãfã sĩ ítá lôfõzó ĩyî drí kô. Kúmú ạ́ngı̣́ rú bê Sólõmõ rî, gólâ rî trá ítá tãndí sũsũ ró rî bê. Gõꞌdá ítá gólâ fê fõô kâ rî sû íyíkâ lậvũlı̣́ gạ̃rạ̃. ");
INSERT INTO avu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gõꞌdá fê fõô ꞌdĩ ꞌbá yî rî ĩyíkâ cé kậyı̣̂ dãwá sĩ ĩtí, gõꞌdá drílĩyî vẽzó õmã bê ndrĩ vólé. Õzõ Ôvârí õfẽ íyíkâ ítá tãndí fê fõô yî drí õmã ꞌálâ vẽlé vólé rî, fẽé íyíkâ ngá ãnî drí rî kô yã? Nĩ lẽé tã-drı̣̃ kĩꞌá nĩ rî Ôvârí rĩꞌá ãnî vó ndrẽꞌá rî kô tãlâ ãꞌdô ꞌî yã? ");
INSERT INTO avu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nĩ ı̣̂sũ tã kô kậyı̣̂ vósĩ cé tã tãndí ãngó nõ kâ tãsĩ, õzõ ngá mvũmvũ kâtí ngá nyãnyã bê rî tãsĩ, gõꞌdá nĩ lôꞌbê lı̣̃fı̣́ kpá kô. ");
INSERT INTO avu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Õjílã gólĩyî tíbê Ôvârí rî rõ ꞌbá kô rî, gólĩyî rî ngá ꞌdĩ ꞌbá yî lẽlé zãâ nĩ. Nĩ ꞌê ũrı̣̃ kô, tãlâ ãnî átá ûrú ꞌálâ rî nı̣̃ ngá gólĩyî îcá ꞌbá ãnî drí rî trá. ");
INSERT INTO avu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nĩ ꞌbã Ôvârí rî lı̣̃fı̣́ õwâ tõwã tã rõrõ ãníkâ gólâ drí rî sĩ. Ĩtí gólâ âꞌdô ãnî vó ndrẽꞌá ngá gólĩyî ꞌẽ ꞌbá îcálé ãnî drí rî fẽzó ãnî drí. ");
INSERT INTO avu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ãnî lãjóꞌbá ámákâ rĩꞌá cé dãwá ĩtí gõꞌdá ãnî tã ꞌdê má drí tákányĩ. Nĩ ꞌê ũrı̣̃ kô, tãlâ ãnî átá tíbê Ôvârí rî âꞌdô ãnî ꞌbãꞌá ãnî rúꞌbạ́ drí âsózó kôrô ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Õzõ nĩ õꞌbã ngá ãmbá ãníkâ ꞌdĩ ꞌbá yî gĩlí vólé õjílã ĩzã ꞌbá rî pãzó ĩꞌdî sĩ lâ rî, nĩ âꞌdô ngá tãndí ûsúꞌá trá Ôvârí ngálâ. Ũgú ûgũú ngá tãndí gólâ Ôvârí drí fẽlé trá ãnî drí ꞌdĩ kô, gõꞌdá îzãá rû kpá kô, âꞌdô rĩꞌá ạ̃dũkũ ãkó zãâ ãníkâ ró. ");
INSERT INTO avu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Õzõ ngá tãndí ãníkâ õlậpı̣̂ rû ãngó ꞌá nõngá rî, nĩ lẽ rĩlí zãâ ngá tãndí ꞌdĩ lạ̃gạ́tı̣́. Õzõ ngá tãndí ãníkâ õlậpı̣̂ rû ûrú ꞌálâ Ôvârí bê rî, nĩ lẽ rĩlí kpá Ôvârí bê lạ̃gạ́tı̣́ lâ. ");
INSERT INTO avu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Ãnî lãjóꞌbá ámákâ rî ꞌbá yî, nĩ rî ı̣̃tú vósĩ cé njãâ ámâ âgõ-âgõ tẽlé, tãlâ nĩ nı̣̃ı̣́ kậyı̣̂ ámákâ âgõzó rî kô. Nĩ rî njãâ võ tẽlé, õzõ rû ı̣̂ꞌbũ ꞌbá drí rĩrĩ njãâ íyî lı̣́pı̣̂ rî tẽlé âgõlé ngạ́cı̣̂ sĩ ꞌbã ꞌá kãrámã vósĩ rî kâtí, tãlâ yí õrî ró bê lı̣̃fı̣́ ngbậ ạ́tı̣̃ njı̣̃lı̣́ íyî lı̣́pı̣̂ drí. ");
INSERT INTO avu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Õzõ lı̣́pı̣̂ lâ ũûsû gólâ rĩꞌá njãâ rî, gólâ ãꞌdô ró bê ãyĩkõ sĩ. Gõꞌdá lı̣́pı̣̂ lâ âꞌdô gólâ rî ꞌbãꞌá rĩlí vũdrı̣́ tãrãbízã lạ̃gạ́tı̣́, gõꞌdá gólâ rî lı̣́pı̣̂ âꞌdô nyãsá trõꞌá fẽlé gólâ drí nyãlé. Gõꞌdá õzõ mâ ãnî lı̣́pı̣̂ ró rî ãâgõ ãngó nõ ꞌá ãnî ûsúlı̣́ njãâ ámâ tẽrẽ ꞌá rî, má âꞌdô âꞌdóꞌá kpá ãyĩkõ ró. Kậyı̣̂ ꞌdĩ ꞌá rî, má âꞌdô ãnî ꞌbãꞌá rĩlí vũdrı̣́ tãrãbízã ámákâ lạ̃gạ́tı̣́ ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Rû ı̣̂ꞌbũ ꞌbá nı̣̃ı̣́ kô ngãtá ꞌbô lı̣́pı̣̂ lâ âꞌdô âcáꞌá lạ̃njạ́túlı̣́ bê ngãtá ꞌbô ngạ́cı̣̂ ító ꞌá yã rî. Õzõ ũûsû rû ı̣̂ꞌbũ ꞌbá íyíkâ zãâ lı̣̃fı̣́ ngbậ rî, gólâ âꞌdô ꞌbãꞌá ãyĩkõ ró. ");
INSERT INTO avu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","ꞌDõvó ãꞌdô ĩtí rî, nĩ rî njãâ ámâ âgõ-âgõ tẽlé, tãlâ âgõ-âgõ ámákâ únı̣̃ı̣́ ı̣̃tú lâ kô. Õzõ âgõ-âgõ ámákâ rî ãꞌdô kpálé jẽjẽ ró rî, nĩ âꞌdô njãâ. Ãnî lı̣̃fı̣́ õmbâ ãnî rú, nĩ âꞌdô kô õzõ õjílã ũgú drí ngá gólâkâ ûgũlı̣́ rî tí. Tãlâ gólâ nı̣̃ı̣́ kô kĩ, ũgú âꞌdô ânĩꞌá fĩlí yí drí jó ꞌá ngá ûgũlı̣́. Õzõ tí gólâ õró nı̣̃lâ nı̣̃nı̣̃ rî, gólâ âꞌdô rĩꞌá njãâ ũgú ꞌdĩ tẽlé.” ");
INSERT INTO avu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nĩngá sĩ rî, Pétẽrõ drí tã âtázó Yésũ drí kĩ nĩ rî, “Kúmú ámákâ, ní rî tã ꞌdî âtálé ꞌdĩ ãmâ lãjóꞌbá áníkâ ró rî yî drí, ngã ꞌbô õjílã drí ndrĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gõꞌdá Kúmú Yésũ lôgõ tã-drı̣̃ ꞌdî trá Pétẽrõ drí kĩ, “Má âtâ tã ꞌdî tã lẽ ꞌbá ámákâ rî yî drí ndrĩ. Ãnî lãjóꞌbá ámákâ rî ãnî lı̣̃fı̣́ õmbâ ãnî rú, nĩ âꞌdô ró rû ı̣̂ꞌbũ ꞌbá tãndí ró. Ĩtí rî, rû ı̣̂ꞌbũ ꞌbá gólâ âꞌdó ꞌbá drı̣̃-ꞌbá ngá vó ndrẽ ꞌbá ró drı̣̃ lõmbâ bê rî, rî íyíkâ ãꞌdô ꞌẽlé ĩꞌdî yã? Gólâ ĩꞌdî tíbê lı̣́pı̣̂ lâ drí ꞌbãlé âꞌdólé rû ı̣̂ꞌbũ ꞌbá ãzí drı̣̃ı̣̂ ndrĩ drı̣̃-ꞌbá ró rî. Gólâ rî rĩꞌá ngá nyãnyã gólĩyíkâ êdélé. ");
INSERT INTO avu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","Gõꞌdá lı̣́pı̣̂ lâ õtírĩ âgõô ậcı̣́ ꞌásĩ rî, rû ı̣̂ꞌbũ ꞌbá gólâkâ ꞌdĩ ꞌê ngá ꞌẽꞌẽ gólâkâ trá ndrĩ tãndí ró. Gõꞌdá lı̣́pı̣̂ lâ drí âꞌdózó gólâ rî tã lôngô-lôngô bê, gõꞌdá drílâ âꞌdózó ãyĩkõ ró, gõꞌdá kpá gólâ rî ꞌbãlé ngá ꞌẽꞌẽ íyíkâ vó lâ ndrẽlé ndrĩ, tãlâ gólâ ĩꞌdî drı̣̃-ꞌbá tãndí ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Gõꞌdá rû ı̣̂ꞌbũ ꞌbá drı̣̃-ꞌbá ró ꞌdĩ õkĩ íyî lı̣́pı̣̂ ãâcá drẽ âgõlé ꞌwãâ ậcı̣́ ꞌásĩ kô, gólâ drí rĩzó rû ı̣̂ꞌbũ ꞌbá ãzí gólâ bê nĩngá ꞌdĩ ꞌbá yî cãlé, gõꞌdá kpá rĩꞌá ngá lı̣́pı̣̂ lâ kâ îzãlé, gõꞌdá gbõ rĩꞌá ngá nyãlé ĩꞌdî, õdrá yî mvũlı̣́ ĩꞌdî rõô, õdrá drí rĩzó cĩlâ rî. ");
INSERT INTO avu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Gõꞌdá nĩngá sĩ rî, lı̣́pı̣̂ lâ âꞌdô âgõꞌá nyĩî rô, gólâ rî ûsúlı̣́ tã ányâ rî ꞌbá yî ꞌẽrẽ lâ ꞌá. Gõꞌdá lı̣́pı̣̂ lâ ꞌdĩ âꞌdô ꞌẽꞌá gólâ rî cãlé, gõꞌdá kpá trõlé ꞌbãlé gạ̃nı̣́mạ̃ ꞌá, tãlâ gólâ âꞌdó drı̣̃-ꞌbá tãndí ꞌî kô. Gólâ rî rú âꞌdó kpá kô lôngô-lôngô ró. ");
INSERT INTO avu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Rû ı̣̂ꞌbũ ꞌbá tíbê tã lı̣́pı̣̂ lâ kâ nı̣̃ ꞌbá trá gõꞌdá drílâ rõzó lâ kô rî, lı̣́pı̣̂ lâ âꞌdô lâŋõ fẽꞌá drílâ kôrô. ");
INSERT INTO avu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá tíbê tã lı̣́pı̣̂ lâ kâ nı̣̃ ꞌbá kô gõꞌdá drílâ ậvı̣̃zó ꞌá lâ sĩ rî, âꞌdô kpá lâŋõ fẽꞌá drílâ cé fínyáwá ĩtí. Ãnî lãjóꞌbá ámákâ rî ꞌbá yî, má îcî ãnî trá tã ãmbá sĩ tã ꞌdî ꞌbá yî ãnî drí gólĩyî rõlé gõꞌdá kpá ãnî drí tã ꞌdî ꞌbá yî îmbálé õjílã drí ꞌbũû. ");
INSERT INTO avu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","“Âgõ-âgõ ámákâ ãngó ꞌá nõngá rî âꞌdô lâŋõ Ôvârí kâ ꞌbãꞌá ãngó drı̣̃ı̣̂. Lâŋõ Ôvârí kâ ꞌdĩ âꞌdô âꞌdóꞌá õzõ ngbı̣̃lı̣̃rı̣̃ lạ̃sı̣́ kâ rî tí. Ngbı̣̃lı̣̃rı̣̃ rî gógó ꞌdĩ âꞌdô kpá ámâ zãꞌá. Tã ꞌdî rî trá zãâ ngíyá má drı̣̃ı̣̂ tã ꞌdî õꞌê rû gbõ ꞌwãâ. ");
INSERT INTO avu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nĩ ı̣̂sũ ãníkâ bê rî, má ânĩ ãngó nõ êdélé yã? ꞌÉꞌẽ, õjílã âꞌdô ĩyî lãfálé cãꞌá ãzí-ãzí rú sĩ ámâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ꞌBã-tı̣̂ ãlô nõtí nõ ꞌá rî, õjílã ãzâ ꞌbá yî âꞌdô ꞌdẽꞌá má vó, gõꞌdá ãzâ ꞌbá yî âꞌdô ámâ gãꞌá. ");
INSERT INTO avu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ãzâ ꞌbá yî átá lâ yî âꞌdô ámâ lẽꞌá, gõꞌdá mvá lâ yî lẽé ĩyíkâ mâ kô. Õzõ mvạ́zı̣́ yî õlẽ mâ nĩ rî, gõꞌdá ãdrá yî lẽé mâ kô. Nĩ ı̣̂sũ drẽ tã ĩtí ꞌdĩ ꞌbá yî dódó ãnî drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","“Ãnî õjílã ndrĩ nĩ ârî drẽ, õzõ nĩ õndrê mbãrãsãsã mũkũkũ trá ậnı̣́ꞌá rõô ómvórẽ lésĩ rî, nĩ nı̣̃ trá kĩ nĩ rî, ôzê bí ânĩꞌá ꞌdı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Gõꞌdá kpá ĩtí, õzõ nĩ õndrê fê bı̣́ õmã bê trá lâwáꞌá rî, nĩ nı̣̃ trá kĩ nĩ rî, mîlí trá ãnyî âcáꞌá. ");
INSERT INTO avu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nĩ kĩ, nĩ rî ĩyî rĩꞌá tã nı̣̃nı̣̃ bê mîlí tãsĩ kpá ôzê lı̣̃mvû tãsĩ rî, ngã gõꞌdá ãꞌdô tã ꞌî, nĩ âꞌdó kô tã nı̣̃nı̣̃ bê tã Ôvârí kâ tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","“Nĩ ârî drẽ, õzõ nĩ õtrõ lãfâ õjílã ãzâ drı̣́gạ́ sĩ rî, gólâ âkĩꞌá nĩ rî, nĩ âfẽ ꞌwãâꞌwâ yí õzó ãnî âjí tã-vó kĩ kâ ꞌá kô. ");
INSERT INTO avu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gõꞌdá óõꞌbã ãnî trá gạ̃nı̣́mạ̃ ꞌá rî, nĩ âfõó tãkó ĩtí kô, nĩ âꞌdô té lãfâ fẽꞌá zãlô gõzó ãnî lôfõlé. Gõꞌdá Ôvârí ꞌê ícícíyá trá ãnî rú, tãlâ nĩ lẽé gólâ rî rõlé kô. Ãꞌdô ĩtí rî, nĩ ndã lạ́tı̣̂ ꞌwãâꞌwâ ãnî drí ãnî pãzó, tãlâ kậyı̣̂ ꞌẽzó lâŋõ fẽlé ãnî drí rî trá âcáꞌá ãnyî.” ");
INSERT INTO avu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Gõꞌdá nĩngá sĩ rî, õjílã ãzâ ꞌbá yî âcâ ĩyî trá tã tíbê ãmbá rû ꞌẽ ꞌbá Yẽrõsãlémã ꞌálâ nã tã lâ âtálé. Õjílã ꞌdî ꞌbá yî âtâ ĩyî tã trá kĩ nĩ rî, “Kúmú Pĩlátõ ûfû ãgô ãzâ ꞌbá yî trá Gãlĩláyã lésĩ. Pĩlátõ fû gólĩyî drílĩyî rĩrĩ ngá fẽfẽ fẽlé jó ạ́ngı̣́ Ôvârí kâ ꞌá rî ꞌá. ꞌDĩî rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî gólĩyî õjílã õnjí ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yésũ âtâ trá kĩ nĩ rî, “Nĩ ı̣̂sũ ãníkâ bê rî, Ôvârí ꞌbã õjílã ꞌdî ꞌbá yî Pĩlátõ ũfû ró, tãlâ gólĩyî õjílã õnjí ꞌî yã? Gólĩyî rĩꞌá õjílã õnjí ꞌî lậvũlı̣́ gạ̃rạ̃ õjílã ãzí Gãlĩláyã lé ꞌbá ró rî yî drı̣̃ı̣̂ sĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ôvârí fú gólĩyî vólé ꞌdĩ kĩꞌá nĩ rî gólĩyî õjílã õnjí ꞌî rî kô. ꞌDĩî rî âꞌdó tã ífí lâ ĩꞌdî kô, gõꞌdá âꞌdô ĩyíkâ ꞌbãꞌá tã pạ̃tı̣́ı̣̃ ró, Ôvârí âꞌdô tã-vó gólĩyíkâ kĩꞌá õjílã ãmbá nõ ꞌbá yí bê ndrĩ gõzó lâŋõ fẽlé gólĩyî drí. Gõꞌdá nĩ âdĩ drı̣̃ tã õnjí ãníkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nĩ nı̣̃ı̣́ tã tíbê õjílã gólĩyî ãmbá drã ꞌbá mûdrı̣́-drı̣̃-lâ-ngâ-njı̣̂-drı̣̃-lâ-nâ jó bẽlé tõrõngõlõ Sĩlómã ꞌá rî drí pı̣̃zó drı̣̃ lâ yî gólĩyî ûfúlı̣́ ndrĩ rî kô yã? Nĩ ı̣̂sũ ãníkâ bê rî, Ôvârí ꞌbã gólĩyî ĩyíkâ kó drãlé ĩtí, tãlâ gólĩyî õjílã õnjí ꞌî lậvũlı̣́ gạ̃rạ̃ ãzí-ãzí drı̣̃ı̣̂ sĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ꞌÉꞌẽ, nĩ ârî drẽ, õzõ nĩ ãâdĩ drı̣̃ tã õnjí ꞌásĩ kô rî, Ôvârí âꞌdô ãnî îzãꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gõꞌdá Yésũ âtâ úlı̣́ mãnĩgõ ãzâ trá nõtí kĩ nĩ rî, “Ãgô ãzâ ı̣̂ꞌdı̣̂ kãnágõwá trá yí drí ạ́mvú ꞌá. Fê ꞌdĩ rî trá ndrô ãmbá sĩ ꞌwá kô. ");
INSERT INTO avu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nĩngá sĩ rî, gólâ lẽ trá fê ꞌdĩ gãlé vólé, tãlâ rî trá võ ạ́mvú ꞌá ꞌdĩ lôgálé tãkó. ");
INSERT INTO avu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Gõꞌdá nĩngá sĩ rî, ãzí-ãzí lâ ãzâ drí tã âtázó drílâ kĩ nĩ rî, ‘Ní âyê drẽ ndrô ãlô sĩ, õzõ õꞌwâ kpá kô rî, ní gõ ró gãlâ vólé. Ní ꞌwã lạ̃gạ́tı̣́ lâ ngbá dîrî, ní njô ró tõtõ ĩdíkõ ꞌdî ndrĩ õmvórẽ lâ ꞌá, ");
INSERT INTO avu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ngãtá âꞌdô ꞌwãâ yã rî, õzõ õꞌwâ kpá kô rî, ní gõ ró gãlâ vólé.’ ” ");
INSERT INTO avu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kậyı̣̂ rãtáã kâ ãzâ sĩ rî, Yésũ rĩꞌá tã Ôvârí kâ îmbáꞌá jó tã ârî kâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Õkó ãzâ rĩꞌá tólâ ngá lãzé ãnyâ-fã kâ bê. Ãnyâ-fã âdĩ õkó ꞌdĩ trá ngbãâ kúgúꞌdúwạ́ ĩtí, îjõó yî kô ndrô lâ mûdrı̣́-drı̣̃-lâ-ngâ-njı̣̂-drı̣̃-lâ-nâ. ");
INSERT INTO avu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yésũ ndrê õkó ꞌdĩ bê rî, gólâ kĩ nĩ rî, “Íyá, ngbãângbânõ rî, ngá lãzé áníkâ ꞌdĩ ndẽ rû trá.” ");
INSERT INTO avu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Drílâ gõzó íyî drı̣́ ꞌbãlé õkó ꞌdĩ drı̣̃ı̣̂. Kôrô ngá lãzé ꞌdĩ drí rû ndẽzó. Õkó ꞌdĩ drí rû îjõzó mbı̣̂mbı̣̂, té õzõ íyíkâ ạ̃kû rî tí. Õkó ꞌdĩ drí gõzó Ôvârí rî lûyı̣́lı̣́ ãmbá íyî êdê-êdê ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gõꞌdá ãgô gólâ ãmbá sı̣́sı̣́-lésĩ jó tã ârî kâ ꞌdĩ ꞌá rî, gólâ trá õmbã ró, tãlâ Yésũ êdê õkó ꞌdĩ trá kậyı̣̂ rãtáã ꞌẽzó ꞌdĩ sĩ. Ãgô gólâ ãmbá sı̣́sı̣́-lésĩ ꞌdî drí tã âtázó õjílã drí kĩ nĩ rî, “Kậyı̣̂ rĩꞌá ãmâ drí ngá ꞌẽzó ꞌá lâ njı̣̂-kázíyá. Nĩ ânĩ kậyı̣̂ ꞌdĩ ꞌbá yî ꞌá éêdê ró ãnî, âꞌdó kô kậyı̣̂ rãtáã kâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kúmú Yésũ lôgõ tã-drı̣̃ trá ãgô ãmbá sı̣́sı̣́-lésĩ ꞌdî drí kĩ nĩ rî, “Ãnî ạ́kpúrúkạ̃ ꞌî, ãnî ꞌdĩ ꞌbá yî ndrĩ, õzõ õjílã ãlô ãꞌdô ı̣̃ndrı̣̂ íyíkâ bê ngãtá kạ́bı̣̃lı̣́kı̣̃ íyíkâ bê yã rî, înjílâ lı̣̃mvû fẽzó drílâ mvũlı̣́ kậyı̣̂ rãtáã kâ ꞌdĩ ꞌá kô yã? ");
INSERT INTO avu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Gõꞌdá õkó nõ rĩꞌá õjílã ãníkâ ĩꞌdî, gólâ rĩꞌá ngá lãzé bê. Sãtánã ômbê trá âdĩ-âdĩ ró ndrô ãmbá sĩ, îcá kô gólâ rî înjízó kậyı̣̂ rãtáã kâ ꞌdĩ ꞌá yã?” ");
INSERT INTO avu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gõꞌdá nĩngá sĩ rî, tã-drı̣̃ lôgõ-lôgõ Yésũ kâ ꞌdĩ ꞌê íyî ạ̃jú-ꞌbá-ãzí yî trá ꞌdó ꞌbãlé ãnyĩ ró tã gólâ drí âtálé ꞌdĩ ꞌá. Gõꞌdá õjílã ũrûkậ ãzâ ꞌbá yî rĩꞌá ĩyî ãyĩkõ ãmbá sĩ tã tãndí ạ́ngı̣́ Yésũ drí ꞌẽlé ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Gõꞌdá Yésũ kĩ nĩ rî, “Õjílã gólĩyî úlı̣́ Ôvârí kâ rî ârí ꞌbá rî ꞌbá yî rĩꞌá õzõ líꞌbá ífí kâtí. Nĩ ndrê líꞌbá ífí cé fínyáwá ĩtí, drílâ ngãzó âfõlé mbãlé fê ạ́ngı̣́ ró gárá bê dũû tõrõngõlõ ûrû. Ãríwá drí rĩzó ꞌdẽlé drı̣̃ lâ kpá ꞌbã ꞌdı̣̃zó drı̣̃ lâ ꞌá. Õjílã gólĩyî cé dãwá úlı̣́ ámákâ ârí ꞌbá rî âꞌdô ĩyíkâ ꞌbãꞌá ĩtí dũû. ");
INSERT INTO avu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","“Õjílã Ôvârí kâ kpá rĩꞌá õzõ ạ̃kú kâtí. Õkó ãzâ âꞌdô ạ̃kú dãꞌá cé fínyáwá ĩtí õdrá ꞌá, drílâ lậꞌbúzó ndrĩ ꞌá lâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yésũ õtírĩ rĩî nĩlí lậmúlı̣́ Yẽrõsãlémã ꞌálâ rî, gólâ rî trá âdrélé ꞌbạ̃drı̣̃ mvá õnyíkõ ãzâ ꞌbá yî ꞌásĩ õjílã lı̣̃fı̣́ îcí bê. ");
INSERT INTO avu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ãgô ãzâ îjî gólâ trá kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá, áâꞌdô cé õjílã ũrûkậ pãꞌá ĩꞌdî fĩlí ûrú ꞌálâ yã?” ");
INSERT INTO avu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yésũ lôgõ tã trá gólâ drí kĩ nĩ rî, “Õjílã ãzâ nı̣̃ı̣́ kô kĩꞌá nĩ rî, õjílã bê tạ̃sı̣̂ ꞌẽꞌá cãlé ꞌbạ̃drı̣̃ Ôvârí kâ rî ꞌálâ. Gõꞌdá ãnî, nĩ sõ fãfã nĩ câ ró bê, tãlâ õjílã ãmbá ı̣̂sũ ĩyíkâ kĩ, ãâꞌdô tã fínyáwá ꞌî cãzó kũmũ Ôvârí kâ ꞌá. Gõꞌdá Ôvârí âꞌdô õjílã ꞌdî ꞌbá yî lôgáꞌá dó cãlé, tãlâ gólĩyî rí ĩyî Ôvârí rî tẽlé pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ôvârí rĩꞌá õzõ jó lı̣́pı̣̂ kâtí. Õjílã ãmbá âꞌdô ûjũꞌá lâ fĩlí, gõꞌdá kậyı̣̂ ndẽ rû bê rî, Ôvârí drí íyîngá ngãzó ạ́tı̣̃ âꞌbãlé kpạ̃ạ́kũ. Õzõ ní ãꞌdô zãâ rĩꞌá jó tı̣́lı̣́-tı̣̂ ꞌá rî, îcá gõꞌdá ní drí fĩzó kô. Gõꞌdá ní âkĩꞌá nĩ rî, ‘Ôvârí, ní njı̣̃ ạ́tı̣̃ má drí.’ Ôvârí âkĩꞌá nĩ rî, ‘Má nı̣̃ı̣́ nî kô. Má nı̣̃ı̣́ võ ní drí ânĩzó rî kpá kô.’ ");
INSERT INTO avu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Õzõ ní ãâtâ gbõ lé kĩ nĩ rî, ‘Ní rî trá fí nĩ ámâ lı̣̃fı̣́ îcílí tã áníkâ sĩ jạ̃rı̣́bạ̃ ámákâ rî ꞌálâ rî. Má rî trá kpá ngá nyãlé ãní bê’ rî. ");
INSERT INTO avu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ôvârí âkĩꞌá nĩ rî kpá, ‘Má nı̣̃ı̣́ võ ní drí ânĩzó rî kpá kô. Ní nĩ nĩngá sĩ vólé. Má nı̣̃ı̣́ nî kô, nî õjílã õnjí ꞌî.’ ");
INSERT INTO avu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Gõꞌdá ní drí âꞌdô rĩꞌá ãwó ngõlé ãmbá, tã ı̣̂sũ-ı̣̂sũ bê gõꞌdá kpá ĩzã drí rĩzó ánî ꞌẽlé ạ̃dũkũ ãkó. Ní âꞌdô Ãbãrãyámã yî ndrẽꞌá Ĩsákã bê Yãkóbã yí bê rĩꞌá ĩyî jó tãndí nã ꞌálâ tã ậngũ ꞌbá Ôvârí kâ yí bê, gõꞌdá nî rî gógó Ôvârí îkî nî trá ãkpã jó tı̣́lı̣́-tı̣̂ ꞌá fĩ ãkó yí ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“Tã pạ̃tı̣́ı̣̃ ró, Ôvârí âꞌdô õjílã ậzı̣́ꞌá õrĩ ãmbá ꞌbạ̃drı̣̃ ꞌá nõ ꞌbá yî ꞌásĩ ómvórẽ lésĩ, kpá ı̣̃tú drí fĩrĩ lésĩ ꞌdó ndrĩ ânĩlí rĩlí ngá nyãlé yí bê jó ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Âꞌdô ꞌbãꞌá ĩtí ı̣̃zạ́tú rî, gólĩyî tíbê kĩ ꞌbá nĩ rî ĩyî ĩyíkâ õjílã vólé áyábálá ró rî ĩꞌdî rî, Ôvârí âꞌdô gólĩyî trõꞌá lậvũlı̣́ ꞌbãlé sı̣́sı̣́ õjílã ꞌbạ̃súrú ĩyíkâ kâ rî ró. Gõꞌdá âꞌdô ꞌbãꞌá kpá ĩtí ãnî tíbê ĩyî ꞌbã ꞌbá sı̣́sı̣́ rî, âꞌdô ĩyíkâ ꞌbãꞌá õjílã ạ̃dũkũ ró. Nĩ fí kô ꞌbạ̃drı̣̃ Ôvârí kâ rî ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Gõꞌdá kôrô Pạ̃rúsı̣̃ ãzâ ꞌbá yî drí âcázó Yésũ ngálâ tã âtálé mbârâkã sĩ gólâ drí kĩ nĩ rî, “Yésũ, ní ngâ nĩlí nõngá sĩ vólé, tãlâ Ẽródẽ lẽ trá ánî fũlı̣́.” ");
INSERT INTO avu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yésũ lôgõ tã-drı̣̃ trá Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ êgbê mâ lé rî, má ꞌé ũrı̣̃ kô ãlôlâ. Ẽródẽ âꞌdô õzõ õtógôwá kâtí. Nĩ nĩ tã âtálé õtógôwá ꞌdĩ, Ẽródẽ drí kĩ, mâ drẽ zãâ ngá ámákâ ꞌẽꞌá õjílã gólĩyî líndrí õnjí bê rî ꞌbá yî kpá gólĩyî ngá lãzé bê rî ꞌbá yî êdé bê. ");
INSERT INTO avu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kậyı̣̂ ámákâ má drí ngá ámákâ ndẽzó rî âcá drẽ kô. Ẽródẽ âꞌdó ĩꞌdî ꞌẽ ꞌbá ámâ fũlı̣́ rî kô, tãlâ mâ rĩꞌá tã ậngũ ꞌbá ꞌî, má âꞌdô drãꞌá Yẽrõsãlémã ꞌálâ, tãlâ ꞌdĩî rî võ gólâ õjílã tã ậngũ ꞌbá drí drãzó ꞌá lâ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Á! Ãnî õjílã Yẽrõsãlémã lé ꞌbá yî, nĩ fû tã ậngũ ꞌbá yî gólâ Ôvârí ngá lésĩ nô nĩ. Nĩ lûvũ võrã ꞌbá Ôvârí kâ rî ꞌbá yî nĩ kúnı̣́ mvá sĩ. Má lẽ ámâ drı̣́ ꞌbãlé ãnî rú sĩ ãnî âmvózó kũrú-kúrû õzõ ꞌạ̃ꞌú ândrê drí vũrı̣̃ íyî úfú ꞌbãlé mvá lâ yî drı̣̃ı̣̂ sĩ kũrú-kúrû rî kâtí rî, gõꞌdá nĩ gâ vólé dó. ");
INSERT INTO avu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ngbãângbânõ rî, áâꞌdô jạ̃rı̣́bạ̃ ãníkâ ꞌdĩ îzãꞌá vólé. Nĩ ndré mâ kô zãâ, té kậyı̣̂ ı̣̃zạ́tú ãnî drí ámâ lûyı̣́zó má drí rĩrĩ âgõlé Ôvârí ngá lésĩ rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kậyı̣̂ ãzâ rãtáã kâ sĩ rî, Pạ̃rúsı̣̃ ãzâ gólâ ãmbá ró rî, ậzı̣̂ Yésũ trá ânĩlí ngá nyãlé yí bê. Gõꞌdá Pạ̃rúsı̣̃ ꞌdĩ ãzí-ãzí lâ yî ãzâ ꞌbá yí bê, lẽ ĩyî trá Yésũ rî ûjũlı̣́. Drílĩyî rĩzó gólâ rî îpítãlé õzõ tí gólâ ãâꞌdô tã õnjí ãzâ ꞌẽꞌá yã rî. ");
INSERT INTO avu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Drílĩyî tã ı̣̂ꞌbı̣̃zó, ãgô ãzâ âjízó pá lâ drı̣́ lâ bê rĩꞌá gãgã ró, Yésũ ẽêdê ró gólâ bê kậyı̣̂ ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Gõꞌdá nĩngá sĩ rî, Yésũ nı̣̃ tã gólĩyíkâ ꞌdĩ trá, ı̣̂ꞌbı̣̃ ĩyî tã ꞌẽzó íyî drı̣̃ rũlı̣́ ꞌá lâ. Drílâ tã îjízó gólĩyî tı̣́ kĩ nĩ rî, “Îcâ trá ngá pãpã ꞌẽzó kậyı̣̂ rãtáã kâ nõ ꞌá yã? Nĩ âtâ tã ꞌdî má drí.” ");
INSERT INTO avu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gõꞌdá nĩngá sĩ rî, õjílã ãzâ ãlô tã-drı̣̃ jã ꞌbá rî yû. Drílâ gõzó drı̣́ ꞌbãlé ngá lãzé ꞌbá nõ drı̣̃ lâ rũzó drı̣́ lâ bê kĩ nĩ rî, “Ní ngâ ûrû, ngá lãzé áníkâ ndẽ rû trá.” Drílâ gõzó tã ꞌbãlé ngá lãzé ꞌbá nõ rî drí nĩzó. ");
INSERT INTO avu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gõꞌdá Yésũ drí tã âtázó lı̣̃fı̣́ îmbá ꞌbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ãgô ãzâ ãꞌdô mvá bê, gõꞌdá mvá ꞌdĩ õꞌdê óró fĩfĩ ꞌá rî, âꞌdô îcáꞌá lôfõzó lâ kậyı̣̂ rãtáã kâ ꞌdĩ ꞌá kô yã? Õzõ õjílã ãzâ ãꞌdô ı̣́tı̣́ bê, ı̣́tı̣́ gólâkâ õꞌdê óró ꞌá rî, âꞌdô îcáꞌá lôfõzó lâ kậyı̣̂ rãtáã kâ ꞌdĩ ꞌá kô yã?” ");
INSERT INTO avu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gõꞌdá nĩngá sĩ rî, gólĩyî rî ĩyî trá ꞌdó tı̣́tı̣́, îcá ĩyî kô úlı̣́ gólâkâ ꞌdĩ võ lâ lôgõlé. ");
INSERT INTO avu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ꞌDĩî rî vósĩ rî, Yésũ drí úlı̣́ mãnĩgõ ãzâ âtázó ũmú gólĩyî gólâ bê tólâ rî yî drí tã yí drí rĩꞌá ndrẽlâ ũmú ãzâ ꞌbá yî drí rĩꞌá ꞌẽlâ rî ꞌásĩ. Ũmú ãzâ ꞌbá yî ãâcâ trá võ kãrámã kâ ꞌá rî, gólĩyî lẽ ĩyíkâ rĩlí té kı̣́tı̣̃ gólâ ꞌbãlé õjílã ãmbâ-ãmbâ drí rĩzó rî drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Yésũ kĩ nĩ rî, “Õzõ úũzı̣̂ ãnî trá võ ãmbá ãzâ ꞌá ngãtá ꞌbô lãgĩ ꞌá ngã ꞌbô kãrámã ạ́ngı̣́ ãzâ ꞌbá yî ꞌá yã rî, nî ãzâ, ní rî kô kı̣́tı̣̃ gólâ ꞌbãlé õjílã ãmbâ-ãmbâ drí rĩzó rî drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Õzõ õjílã ãmbá rî võ ꞌdî ꞌbãzó drílâ ꞌdĩ ãâcâ trá rî, áâꞌdô ánî îngáꞌá rî võ ꞌdî drı̣̃ı̣̂ sĩ. Ãnyĩ ạ́ngı̣́ drí gãzó ní drı̣̃ı̣̂, ní drí nĩzó rĩlí ı̣̃nyạ́kú ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Õzõ ní ãꞌdô tã nı̣̃ ꞌbá ꞌî rî, ní rî sı̣́sı̣́ ı̣̃nyạ́kú drı̣̃ı̣̂, ógõ ró ánî îngálé rĩlí kı̣́tı̣̃ drı̣̃ı̣̂, õjílã ndrĩ ũnı̣̃ ró bê kĩ nĩ rî, ı̣́ı̣̂njı̣̃ nî trá kôrô. ");
INSERT INTO avu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Õjílã gólâ tíbê íyî ꞌbã ꞌbá õjílã ạ́ngı̣́ ró gạ̃rạ̃ ãzí-ãzí drı̣̃ı̣̂ sĩ rî, Ôvârí âꞌdô gólâ rî lı̣̃fı̣́ êmvéꞌá, drílâ ꞌbãzó ãnyĩ ró õjílã lı̣̃fı̣́ drı̣̃ ꞌá ndrĩ. Gõꞌdá õjílã gólâ íyî ꞌbã ꞌbá áyábálá ró rî, Ôvârí âꞌdô õjílã ꞌbãꞌá gólâ rî ı̣̂njı̣̃lı̣́.” ");
INSERT INTO avu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gõꞌdá Yésũ drí tã âtázó ãgô gólâ ngá lı̣́pı̣̂ ró nõ drí kĩ nĩ rî, “Õzõ õjílã ãzâ õtírĩ ꞌẽê ãzí-ãzí zı̣̃lı̣́ kãrámã íyíkâ ꞌá ngã ꞌbô ânĩlí ngá nyãlé yí bê yã rî, gólâ ạ̃ậzı̣̂ cé íyî lậmû-ãzíyã yî ĩꞌdî kô, gólâ ạ̃ậzı̣̂ kpá cé õjílã gólĩyî ngá bê ãmbá ꞌdĩ ꞌbá yî ĩꞌdî kô. Nĩ nı̣̃ trá õjílã gólĩyî cé ãnî lậmû-ãzíyã ró ĩꞌdî, âꞌdô ĩyî kpá ãnî ậzı̣́ꞌá ngá nyãlé ĩyí bê kãrámã ĩyíkâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Õzõ nĩ õlẽ trá õjílã zı̣̃lı̣́ rî, nĩ zı̣̂ lı̣̃fı̣́ ãkó lé ꞌbá kõrõkpó gõꞌdá kpá ĩzã ꞌbá bê, ãânĩ ró ĩyî kãrámã nyãlé. ");
INSERT INTO avu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tãlâ gólĩyî ngá ãkó lôgõlé ãnî drí. Ị̃zạ́tú rî, õdrã ãníkâ vósĩ, nĩ õtírĩ cãâ ûrú ꞌálâ rî, Ôvârí âꞌdô õrẽ fẽꞌá nĩ ãnî drí tã tãndí bê.” ");
INSERT INTO avu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ãgô ãzâ kpá rĩꞌá tãrãbízã lạ̃gạ́tı̣́ ĩtí, ãgô nõ ârílí bê tã Yésũ drí âtálé nõ rî, gólâ âtâ tã trá nõtí kĩ nĩ rî, “Wáâwá! Õjílã tíbê gólĩyî âꞌdó ꞌbá ꞌẽꞌá kãrámã nyãlé Ôvârí drí ꞌbã ꞌálâ ûrú ꞌálâ rî, gólĩyî rĩꞌá cú ândrâ-tãndĩ bê.” ");
INSERT INTO avu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yésũ âtâ tã trá ãgô ꞌdĩ drí nõtí kĩ nĩ rî, “Ãwô, tã pạ̃tı̣́-pạ̃tı̣̃ ró, ꞌdĩî tã tãndí ꞌî. “Nĩ ârî drẽ íꞌdígówá ámákâ nõ. Ãgô ãzâ zı̣̂ õjílã trá kãrámã íyíkâ ꞌá dũû lậvũlı̣́ kôrô. ");
INSERT INTO avu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Gõꞌdá nĩngá sĩ rî, óõtírĩ nyãsá âvó rî, gólâ jô rû ı̣̂ꞌbũ ꞌbá íyíkâ trá, nĩꞌá õjílã gólĩyî ũmú ró rî ꞌbá yî ậzı̣́lı̣́, ãânĩ ró ĩyî. Gólâ âtâ tã trá kĩ nĩ rî, éêdê ngá nyãnyã trá ngá mvũmvũ yí bê kpânó-kpânó. Gólĩyî ãânĩ. ");
INSERT INTO avu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gõꞌdá õjílã ꞌdî ꞌbá yî ndrĩ gã ĩyî trá dó ânĩlí. Õjílã gólâ zı̣̃lı̣́ sı̣́sı̣́ rî kĩ nĩ rî, ‘Má nĩí kô. Má gî ạ́mvú óꞌdí ámákâ trá, mâ drẽ nĩꞌá ndrẽlâ.’ ");
INSERT INTO avu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gõꞌdá ãzâ rî kĩ nĩ rî, ‘Má gî ı̣̃ndrı̣̂ ámákâ trá óꞌdí ró, má nĩ drẽ trá, nĩꞌá âjílâ võ tãndí ãzâ ꞌá ngá nyãlé, má âcá kãrámã ꞌdî ꞌá kô.’ ");
INSERT INTO avu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gõꞌdá kpá ãgô ãzâ kĩ nĩ rî rû ı̣̂ꞌbũ ꞌbá ꞌdĩ drí rî, ‘Má îcá ânĩlí kô, tãlâ lãgĩ ámâ õkó kâ óꞌê drẽ ậgı̣́.’ ");
INSERT INTO avu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ꞌdĩ drí gõzó vólé íyî lı̣́pı̣̂ ngálâ tã lâ âtálé drílâ. Ãgô kãrámã lı̣́pı̣̂ ãmbá ꞌdĩ trá õmbã ró, âtâ tã trá rû ı̣̂ꞌbũ ꞌbá íyíkâ ꞌdĩ drí kĩ nĩ rî, ‘Ní ndrê drẽ, má êdê ngá nyãnyã trá ngá mvũmvũ yí bê kpânó-kpânó kãrámã nô tãsĩ, õjílã ãânĩ ndrĩ nyãlâ õzó rû îzãâ. Ní ngâ nĩlí fõfõrõ, nĩꞌá lậmú bê lạ́tı̣̂ õnyíkõ ꞌásĩ ndrĩ õjílã ậzı̣́ bê, ní ậzı̣̂ lı̣̃fı̣́ ãkó lé ꞌbá, kõrõkpó ĩzã ꞌbá, ạ̃yı̣́zı̣́ bê, ãânĩ ró ĩyî kãrámã ámákâ nõ ꞌá.’ Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ꞌdĩ nĩ trá õjílã ꞌdî ꞌbá yî ậzı̣́lı̣́, âgõzó ĩꞌdí bê lâ ĩyî. ");
INSERT INTO avu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","23","Gõꞌdá kãrámã lı̣́pı̣̂ kĩ nĩ rî, võ drẽ zãâ bê õjílã drí rĩzó, gólâ õgõ kpá. Rû ı̣̂ꞌbũ ꞌbá íyíkâ õnĩ gõꞌdá ꞌbã-tı̣̂ ꞌásĩ õjílã ậzı̣́ bê mbârâkã sĩ ânĩlí. Kãrámã lı̣́pı̣̂ lẽ ạ̃ꞌdı̣́-drı̣̃ íyíkâ drí ꞌbãlé ndrĩ ꞌdó ũmú ró. ");
INSERT INTO avu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kãrámã lı̣́pı̣̂ kĩ nĩ rî, yí âtâ trá nõtí, õzõ õjílã tíbê gã ꞌbá dó ânĩlí rî ãânĩ rî, gólĩyî nyá ngá ãzâ rú bê nyãsá rî yí drí ꞌbã ꞌá nõngá kô.” ");
INSERT INTO avu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kậyı̣̂ ãzâ sĩ rî, õjílã zî-ândrê drí nĩzó ĩyî Yésũ bê lạ́tı̣̂ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Yésũ drí âdrézó, rĩꞌá gólĩyî lı̣̃fı̣́ îcílí tã ãzâ ꞌbá yî sĩ, gólĩyî ãꞌdô ró ĩyî bê ngá lẽlẽ bê Ôvârí ꞌá kĩ nĩ rî, “Õzõ nĩ õlẽ tã ámákâ kô lậvũlı̣́ gạ̃rạ̃ õjílã ãníkâ ꞌbã ꞌá rî drı̣̃ı̣̂ sĩ rî, kpá ãnî rî gógó ífífí lâ drı̣̃ı̣̂ sĩ rî, îcá kô ãnî drí ꞌbãzó rû ı̣̂ꞌbũ ꞌbá ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Õzõ nĩ õfẽ ãnî ífífí trá ꞌẽꞌá fũlâ ámâ tãsĩ rî, nĩ âꞌdô ꞌbãꞌá rû ı̣̂ꞌbũ ꞌbá ámákâ ró. Õzõ nĩ õlẽ cé ãnî rúꞌbạ́ ı̣̃nyạ́kú pãlé ĩꞌdî rî, nĩ âꞌdó kô rû ı̣̂ꞌbũ ꞌbá ámákâ ró. Nĩ ı̣̂sũ tã má drí âtálé ãnî drí ꞌdĩ zãlô sı̣́sı̣́, nĩ gõ ró âꞌdélé ámâ vó bẽlé. ");
INSERT INTO avu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tã âꞌdâ-âꞌdâ lâ rĩꞌá nõtí, õzõ nĩ õlẽ trá õjílã ũꞌdı̣̂ ró jó ạ́ngı̣́ ãnî drí ûrû tõrõngõlõ rî, sı̣́sı̣́ nĩ âꞌdô lãfâ ãníkâ lôfõꞌá lãlé zãlô, nĩ gõ ró lôsĩ ꞌbá ꞌdĩ ꞌbá yî îjílí âꞌdô ĩyî ꞌdı̣̃ꞌá lâ tạ̃sı̣̂ yã. ");
INSERT INTO avu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Õzõ nĩ îtõ gbõ kôrô jó ạ́ngı̣́ ꞌdı̣̃lı̣́ ĩꞌdî lãfâ fínyáwá sĩ rî, ndẽé rû kô, lãfâ drí ndẽzó ãnî drı̣́gạ́ sĩ, õjílã drí rĩzó ãnî gũlı̣́ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Wáyéẽ! Nĩ ndrê drẽ, gólâ îtónã jó ạ́ngı̣́ ꞌdı̣̃lı̣́ âyélé cú ĩtí ndẽ ãkó lâ. Ngã lãfâ ãꞌdô yû rî, ngã kó ãꞌdô ꞌî yã?’ ");
INSERT INTO avu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tã âꞌdâ-âꞌdâ lâ ãzâ kpá ĩꞌdî nõ. Õzõ õjílã ꞌbạ̃drı̣̃ ãzâ kâ ãânĩ trá ꞌdẽlé ạ̃jú bê ꞌbạ̃drı̣̃ ãzâ drı̣̃ı̣̂ rî, kúmú ꞌdẽzó drı̣̃ lâ ꞌdĩ îtõó kôrô ạ̃jú îtónãlé ĩꞌdî kô, ậzı̣̂ drı̣̃-ꞌbá ạ̃jú ꞌbũ ꞌbá kâ zãlô tã lâ ı̣̂ꞌbı̣̃zó, õzõ gólĩyî ĩîcâ trá rî, nı̣̃zó lâ kĩ ạ̃jú ꞌbû ꞌbá îcâ trá yã rî. ");
INSERT INTO avu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Õzõ gólĩyî ĩîcâ kô rî, kúmú drí tã lâ êdézó kúmú ãzí bê, úꞌbú ạ̃jú kô, tãlâ óõzó õjílã íyíkâ ûfú ndẽlé. ");
INSERT INTO avu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Má âtâ ĩꞌdî nõ ãnî drí, nĩ ı̣̂sũ tã zãlô sı̣́sı̣́, õzõ nĩ ãꞌdô trá njãâ ngá ãmbá ãníkâ ꞌdĩ ꞌbá yî âyélé, õjílã ãníkâ ꞌbã ꞌá rî ꞌbá yí bê, ámâ vó bẽzó ĩꞌdî rî. Õzõ nĩ õꞌê ĩtí kô rî, óꞌbãá ãnî rû ı̣̂ꞌbũ ꞌbá ámákâ ró rî kô. ");
INSERT INTO avu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Rû ı̣̂ꞌbũ ꞌbá gólâ tã ámákâ âyé ꞌbá ꞌẽlé kô kĩꞌá nĩ rî âmbâ-âmbâ rî, âꞌdô íyíkâ ꞌbãꞌá té õzõ ꞌạ̃ꞌı̣́-nyá gólâ rû îzã ꞌbá trá rî kâtí. Gõꞌdá trá tõtõ ꞌî dãlé vólé õmã ꞌálâ. Õzõ ãnî ãꞌdô bı̣́ bê rî, nĩ ârî tã ꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kậyı̣̂ ãzâ sĩ rî, bélé-bélé ûꞌdú ꞌbá yî kpá lãꞌbí îzã ꞌbá yí bê dũû ânĩ ĩyî trá úlı̣́ Yésũ kâ ârílí. ");
INSERT INTO avu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Gõꞌdá õjílã gólĩyî zı̣̃lı̣́ Pạ̃rúsı̣̃ ró rî ꞌbá yî, kpá lãꞌbí îmbá ꞌbá yî rî trá tã ãzâ ꞌbá yî tı̣̂ lâ ŋãlé ꞌẽlé ĩyî lãfálé ꞌásĩ kĩ nĩ rî, “Yésũ kpá lậmû-ãzíyã ꞌî lãꞌbí îzã ꞌbá nõ ꞌbá yí bê. Nĩ ndrê gólâ ngá nyãꞌá gólĩyí bê.” Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî zı̣̂ õjílã gólĩyî lãꞌbí îzã ꞌbá ꞌdĩ ꞌbá yî “‘õjílã ậvı̣̃-ậvı̣̃ ró”’. ");
INSERT INTO avu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Gõꞌdá Yésũ ârílí bê tã ꞌdî ĩtí rî, drílâ gõzó íꞌdígówá ãzâ ngĩlí. ");
INSERT INTO avu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Gólâ kĩ nĩ rî, Õzõ õjílã ãzâ ãꞌdô kạ́bı̣̃lı̣́kı̣̃ bê nyâꞌdî-njı̣̂, gõꞌdá cé ãlô rî õrî trá vólé, ậvı̣̃ trá rî, gólâ âꞌdô kạ́bı̣̃lı̣́kı̣̃ ꞌdî ꞌbá yî ạ̃mbúkũ lâ ꞌbãꞌá kõró ꞌá. Drílâ gõzó zãâ nĩꞌá ãlô ꞌdĩ ndãlé té drílâ ûsúzó lâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Õzõ ũûsû trá rî, drílâ ậnjı̣̃zó lâ ángbálángõ ꞌá, âgõzó ĩꞌdí bê lâ, drílâ gõzó ꞌbãlé ãyĩkõ ró. ");
INSERT INTO avu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Õró gõ tã lâ âtálé íyî lậmû-ãzíyã drí kĩ nĩ rî, “Mâ trá ãyĩkõ ãmbá sĩ, tãlâ kạ́bı̣̃lı̣́kı̣̃ ámákâ ậvı̣̃ ꞌbá rî, má ûsû trá.” ");
INSERT INTO avu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gõꞌdá nĩngá sĩ rî, Yésũ kĩ nĩ rî, íꞌdígówá íyíkâ ꞌdĩ tã ífí lâ rĩꞌá nõtí, Ôvârí rĩꞌá ãyĩkõ ãmbá sĩ, õzõ õjílã ãlô ãâdĩ drı̣̃ trá tã õnjí ꞌásĩ rî, Ôvârí âꞌdó kô ãyĩkõ sĩ õjílã gólĩyî drı̣̃ âdĩ ꞌbá kô ꞌdĩ ꞌbá yí bê, tãlâ gólĩyî rĩꞌá õjílã lómbé-lómbéwá ꞌbá ꞌî, kĩ nĩ rî, yĩ âꞌdô tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nĩngá sĩ, Yésũ âtâ íꞌdígówá ãzâ kpá trá õkó ãzâ tãsĩ kĩ nĩ rî, Lãfâ õkó ãzâ kâ ậvı̣̃ trá drı̣́gạ́ lâ sĩ jó ꞌá. Õkó ꞌdĩ rî trá lãfâ íyíkâ ꞌdĩ ndãlé jó ꞌásĩ. Drílâ lạ̃sı̣́ îꞌĩzó ãlíká sĩ, rĩzó jó ꞌálé ậkũlı̣́ mãnísĩ, ı̣́ndı̣̂-ı̣́ndı̣̂, rĩzó lãfâ íyíkâ ꞌdĩ ndãlé té drílâ ûsúzó lâ ĩꞌdî. Gólâ kĩ nĩ rî, “Wáâwá! Ãwô-ĩtí, má ûsû lãfâ ámákâ ậvı̣̃ ꞌbá rî trá.” ");
INSERT INTO avu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Õkó ꞌdĩ drí kpá íyî lậmû-ãzíyã yî ậzı̣́zó kĩ nĩ rî drílĩyî, “Ãwô-ĩtí, ãyĩkõ cî trá má rú, tãlâ lãfâ ámákâ ậvı̣̃ ꞌbá jó ꞌá rî, má ûsû trá.” ");
INSERT INTO avu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yésũ drí gõzó tã âtálé kĩ, “Õzõ tã õnjí ꞌbá ãlô âdĩ drı̣̃ trá tã õnjí ꞌásĩ rî, ãyĩkõ cî trá Ôvârí rú ãmbá.” ");
INSERT INTO avu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yésũ âtâ íꞌdígówá ãzâ ngĩî lâ kpá trá tã Ôvârí drí drı̣̃ âdĩ ꞌbá rî lẽzó rî tãsĩ drílĩyî kĩ nĩ rî, Ãgô ãzâ ngá-drı̣̃ ãmbá bê, gólâ rĩꞌá mvá bê rı̣̃, ãgô mvá ró. ");
INSERT INTO avu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gõꞌdá mvá gólâ ạ̃dú ró rî drí tã âtázó íyî átá drí kĩ nĩ rî, “Tátá, nî rĩꞌá ngá bê ãmbá. Má lẽ ní câ ngá ꞌdĩ ꞌbá yî lãfálé ãmâ drí ãkpã ní drí drã ãkó. Ní âfẽ ámákâ rî ngbãângbânõ.” Gõꞌdá átá lâ drí ngá yí bê rî lãfálé lâ cãzó drílĩyî ậdrúpı̣̃ lâ bê. ");
INSERT INTO avu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gõꞌdá nĩngá sĩ rî, mvá gólâ ạ̃dú rî drí ngá gólâ íyíkâ rî gĩzó ngbá vólé, íyîngá nĩzó ꞌbạ̃drı̣̃ ãzâ ꞌá jẽjẽ ró átá lâ rú sĩ. Gõꞌdá nĩngá sĩ rî, gólâ îzã lãfâ tíbê ꞌbã ꞌbá yí bê rî trá ndrĩ rĩrĩ õnjî-õnjî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lãfâ tíbê ãmbá mvá ꞌdĩ drı̣́gạ́ nõ ndẽ rû trá ꞌbũû. Gõꞌdá nĩngá sĩ, kãrábã ạ́ngı̣́ lõfó kâ ꞌdê trá ꞌbạ̃drı̣̃ ãmbá ꞌdĩ ꞌásĩ ndrĩ, gõꞌdá ûsû mvá nã trá cú ĩtí lãfâ ãzâ ãkó yí drı̣́gạ́. ");
INSERT INTO avu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","16","Gõꞌdá nĩngá sĩ, mvá ꞌdĩ nĩ trá ãgô ãzâ ꞌbá yî kó ꞌbạ̃drı̣̃ ꞌbá ró rî ãlô lâ ngálâ lôsĩ ndãlé ꞌẽlé. Gõꞌdá ãgô ꞌdĩ drí gólâ rî jõzó nĩꞌá võ ngbíkpí kâ rî ꞌálâ, ngbíkpí íyíkâ vó lâ ndrẽlé. Gõꞌdá gólâ ı̣̂sũ tã trá kĩ nĩ rî, “Ãwô-ꞌdĩ, tãkó, má âꞌdô ngá nyãꞌá ãndrõ ạ̃drúgú kúrũmû rĩꞌá dãlâ ĩgîzẽ bê ngbíkpí drí ꞌdĩ ꞌbá yî.” Gõꞌdá nĩngá sĩ rî, õjílã ãzâ ãlôlâ fẽé ngá ꞌdĩ ꞌbá yî drílâ nyãlé kô. ");
INSERT INTO avu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nĩngá sĩ rî, tã ı̣̂sũ-ı̣̂sũ âcâ trá gólâ drı̣̃ı̣̂ nõtí kĩ nĩ rî, “Má õtírĩ rĩî drãlé lõfó drí nõ rî, lôsĩ ꞌẽ ꞌbá ámâ átá drí ạ́mvú ꞌá rî yî, gólĩyî rĩꞌá ngá nyãnyã bê kpânó-kpânó vũdrı̣́ sĩ. Gõꞌdá nõô rî, má drí rĩzó íyíkâ drãlé lõfó drí ámâ átá drí ꞌbãrẽ bê rî ꞌá yã? ");
INSERT INTO avu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mâ nĩꞌá gõlé ámâ átá ngálâ, mâ kĩꞌá nĩ rî, ‘Tátá, má îzã rû trá, má ꞌê tã õnjí trá bũúũ Ôvârí rú, gõꞌdá kpá ní rú. ");
INSERT INTO avu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngbãângbânõ rî, îcá gõꞌdá kô ní drí ámâ zı̣̃zó kpá óꞌdí ánî mvá ró. Ní ꞌê mâ õzõ lôsĩ ꞌẽ ꞌbá áníkâ rî tí.’ ” ");
INSERT INTO avu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gõꞌdá nĩngá sĩ rî, drílâ ngãzó zãâ nĩꞌá gõlé íyî átá ngálâ. Gólâ drẽ jẽjẽ ró íyî átá lạ̃gạ́tı̣́ sĩ rî, átá lâ drí gólâ rî ndrẽzó. Átá lâ rî ꞌâ gâ trá ạ̃trạ̃. Átá lâ drí ârázó ânĩlí rû ûtúlı̣́ gólâ drı̣̃ı̣̂, gólâ rî âmvólé bı̣́-ꞌbálé lâ võzó. ");
INSERT INTO avu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gólâ âtâ tã trá átá lâ drí kĩ nĩ rî, “Tátá, má îzã rû trá, má ꞌê tã õnjí trá bũúũ Ôvârí rú gõꞌdá kpá ní drí, îcá kô gõꞌdá ní drí ámâ zı̣̃zó ánî mvá ró.” ");
INSERT INTO avu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","23","Gõꞌdá mvá ꞌdĩ átá lâ, ãyĩkõ cî gólâ trá ãmbá, rî tã ꞌẽlé ꞌdó lı̣̃fı̣́ ãkó. Drílâ lãjóꞌbá íyíkâ zı̣̃zó kĩ nĩ rî, “ꞌWãâꞌwâ, nĩ ꞌbã lũmvû drílâ dãlé yí rú, õsõ ró ítá tãndí, káꞌbókã bê íyî pá ꞌá. Nĩ âfẽ ró tómó ámákâ nã sõlé drı̣́gạ́ lâ. Nĩ nĩ ró bê kạ́bı̣̃lı̣́kı̣̃ sẽsẽ ró ꞌdĩ âsélé fũlı̣́. Mã ꞌê ró bê kãrámã ạ́ngı̣́. ");
INSERT INTO avu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Má kĩ nĩ rî, mvá ámákâ nõ drã trá, tákõ íyîngá lédrẽ-lédrẽ ró.” Gõꞌdá drílĩyî kãrámã îtónãzó. ");
INSERT INTO avu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","26","Nĩngá sĩ rî, ójô ꞌdĩyímvá nĩꞌá mvá gólâ sı̣́sı̣́ rî ậzı̣́lı̣́ ạ́mvú lésĩ ãânĩ ró, tãlâ gólâ rî ậdrúpı̣̃ tíbê ậvı̣̃ ꞌbá rî âcâ trá ꞌbã ꞌá. Gõꞌdá ágámvá gólâ sı̣́sı̣́ ꞌdĩ õtírĩ íyíkâ âcá ãnyî ꞌbã lạ̃gạ́tı̣́ rî, kálálá gõꞌdá trá tákányĩ ꞌbã ꞌálâ. Ágámvá ꞌdĩ kĩ, “Ãꞌdô tã ꞌî nõtí nõ yã?” ");
INSERT INTO avu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ꞌDĩyímvá ꞌdĩ kĩ, “Ánî átá fû kạ́bı̣̃lı̣́kı̣̃ lîngâ-lîngâ trá kãrámã ạ́ngı̣́ ꞌẽzó ĩꞌdî sĩ lâ, tãlâ ánî ậdrúpı̣̃ âgõ trá vólé ꞌbã ꞌá, tã ãmbá gólâ rî ı̣̂mvú ꞌbá ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mvá sı̣́sı̣́ rî trá õmbã ró, îcá gõꞌdá âfõlé ạ̃ꞌdı̣́-drı̣̃ ꞌá kô. Nĩngá sĩ, átá lâ drí ânĩzó rúꞌbạ́ lôꞌbãlé rú lâ, ãâfõ ró bê ꞌbã ꞌálâ nî-bê-yã fẽlé íyî ậdrúpı̣̃ drí. ");
INSERT INTO avu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Âtâ tã trá átá lâ drí kĩ nĩ rî, “Ámâ átá, ní ndrê drẽ, ndrô ãmbá nõ sĩ rî, má rî trá ꞌbã ꞌá ngá ꞌẽlé ní drí õzõ lãjóꞌbá kâtí. Má ꞌé tã õnjí ãzâ ní drí kô. Ní âfẽ íyíkâ ãꞌdô ꞌî má drí yã? Ngbãâ ꞌạ̃ꞌú ró rî, ní fú ãmâ drí nyãlé ámâ lậmû-ãzíyã yí bê kãrámã ꞌẽzó kô. ");
INSERT INTO avu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gõꞌdá mvá áníkâ tíbê ngá áníkâ îzã ꞌbá ndrĩ õkó mvá drı̣̃ı̣̂ õlẽ ró yî bê gõꞌdá âgõ íyíkâ bê rî, ní drí kạ́bı̣̃lı̣́kı̣̃ ạ́ngı̣́ fũzó drílâ.” ");
INSERT INTO avu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Átá lâ lôgõ tã-drı̣̃ trá drílâ kĩ nĩ rî, “Ámâ mvá, ní ndrê drẽ, ãmâ rĩꞌá ní bê ı̣̃tú vósĩ cé ꞌbã ꞌá nõ, ngá gólâ ámákâ rî ndrĩ ꞌdó rĩꞌá kpá áníkâ. ");
INSERT INTO avu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Má ꞌê drẽ kãrámã, má âꞌdô ró ãyĩkõ sĩ, tãlâ ánî ậdrúpı̣̃ tíbê ngá pã ꞌbá õdrã ꞌásĩ nô rî tãsĩ.” Ngá gólâ íꞌdígówá gólĩyî nâ nõ ꞌbá yî ꞌá rî yî rî tã âꞌdálé âꞌdô ngá lẽlẽ Ôvârí kâ tã õnjí ꞌẽ ꞌbá drí rî tãsĩ. Yésũ rî tã ꞌdî âtálé Pạ̃rúsı̣̃ yî drí, tãlâ Pạ̃rúsı̣̃ yî lẽé ĩyî Yésũ drí rĩlí tã õnjí ꞌẽ ꞌbá bê võ ãlô ꞌá kô. ");
INSERT INTO avu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Gõꞌdá Yésũ âtâ trá lãjóꞌbá íyíkâ rî yî drí kĩ nĩ rî, “Nõô rî íꞌdígówá ãgô ãzâ ngá-drı̣̃ ãmbá lı̣́pı̣̂ ró rî kâ, ãgô ãzâ drílâ ꞌbãlé ngá íyíkâ ꞌdĩ ꞌbá yî vó lâ ndrẽlé rî bê. Õjílã ãzâ drí tã âtázó ãgô ãmbá ngá lı̣́pı̣̂ ró ꞌdĩ drí, ãgô tíbê âkórí drí ꞌbãlé ngá íyíkâ ꞌdĩ ꞌbá yî vó lâ ndrẽlé rî, âꞌdô trá rĩꞌá lãfâ âkórí kâ nyãꞌá. ");
INSERT INTO avu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ãgô ngá lı̣́pı̣̂ ró ꞌdĩ drí ngãzó ngá vó ndrẽ ꞌbá íyíkâ ꞌdĩ ậzı̣́lı̣́ tã âtázó drílâ kĩ nĩ rî, ‘Õjílã ãzâ âtâ tã má drí kĩ nĩ rî, ní õrî trá lãfâ ámákâ îzãlé. Âꞌdô trá ĩtí rî, ní îgĩ ngá gólâ tíbê rû îzã ꞌbá rî, õjílã drí trõlé ní drı̣́gạ́ sĩ mạ̃rı̣́ ró rî ꞌẽꞌá lôgõlâ má drí rî ꞌbá yî vũdrı̣́, gõꞌdá kpá ngá gólâ ꞌbã ꞌbá rî ꞌbá yí bê, mã nı̣̃ ró bê. Gõꞌdá má lẽ trá ánî înjílí vólé ngá ꞌẽrẽ ꞌásĩ, tãlâ ní ꞌé ngá dódó kô.’ ");
INSERT INTO avu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Gõꞌdá ãgô gólâ ngá vó ndrẽ ꞌbá ró ꞌdĩ ı̣̂sũ tã trá ãkpã yí ꞌá kĩ nĩ rî, ‘Óõ! Ámâ lı̣́pı̣̂ lẽ trá ámâ înjílí ngá ꞌẽrẽ ꞌásĩ vólé, má âꞌdô ꞌẽꞌá lâ ãꞌdô ró yã? Má drí rĩzó óꞌbã ngá ꞌẽlé cú ámâ drı̣́ sĩ yã? ꞌÉꞌẽ! Mâ fãfã ãkó, má îcá kô. Má drí ꞌbãzó ngá ndã ꞌbá ró ꞌbã ꞌásĩ kpá ngá zı̣̃ ꞌbá ró yã? ꞌÉꞌẽ! Má ãnyĩ ró tã ꞌdî ꞌbá yî ꞌẽrẽ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Má nı̣̃ tã má drí ꞌẽꞌá ꞌẽlâ rî trá. Má lẽ trá tã tãndí ꞌẽlé õjílã drí ndrĩ, õzõ íĩînjî mâ trá ngá ꞌẽrẽ ꞌásĩ rî, ũzı̣̂ ró ĩyî mâ bê ngá nyãlé ĩyî drí ꞌbã ꞌásĩ.’ ");
INSERT INTO avu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ãgô gólâ ngá vó ndrẽ ꞌbá ró ꞌdĩ ꞌê tã trá nõtí, gólâ zı̣̂ õjílã gólĩyî rĩ ꞌbá mạ̃rı̣́ trõlé ãgô ãmbá ꞌdĩ drı̣́gạ́ sĩ rî yî trá ndrĩ ânĩlí yí ngálâ ãlô-ãlô. Gólâ âtâ tã trá ãgô sı̣́sı̣́ rî drí kĩ nĩ rî, ‘Ní âꞌdô ꞌẽꞌá ngá ãgô ãmbá nõ kâ lôgõlé tạ̃sı̣̂ yã?’ ");
INSERT INTO avu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ãgô ꞌdĩ kĩ nĩ rî, ‘Má trõ dõ rĩꞌá sãfíyã kámá-ãlô-drı̣̃-lâ-nyâꞌdî-nâ.’ Ngá vó ndrẽ ꞌbá ꞌdĩ kĩ nĩ rî, ‘Ní ndrê drẽ, ãmâ ꞌdó rĩꞌá ngá ãlô ꞌî ní bê. Má âꞌdô ꞌẽꞌá lâ ní drí nõtí, ãꞌdô ró bê ní drí njõzó lâ ꞌá lâ, kpá ní drí ánî drı̣́ lãfálé ândrãzó, sãfíyã kámá-ãlô-drı̣̃-lâ-nyâꞌdî-nâ ꞌdĩ ꞌá rî, má îgĩ cé nyâꞌdî-sû ní drí lôgõlâ.’ Gõꞌdá ãgô gólâ mạ̃rı̣́ trõ ꞌbá ꞌdĩ drí tã-drı̣̃ lẽzó ꞌdó ãlô. ");
INSERT INTO avu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngá vó ndrẽ ꞌbá ꞌdĩ drí kpá ãgô ãzâ ĩtí ꞌdĩ îjízó, ‘Ní mạ̃rı̣́ ãgô ãmbá kâ bê ní vó tạ̃sı̣̂ yã?’ Ãgô ꞌdĩ kĩ nĩ rî, íyíkâ bê ạ̃drúgú rĩꞌá kõmvõ kútũ-ãlô. Ngá vó ndrẽ ꞌbá nã drí tã-drı̣̃ lẽzó îgĩzó lâ cé kõmvõ kámá-njı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Gõꞌdá ãgô ãmbá ngá lı̣́pı̣̂ ró ꞌdĩ ârî tã gólâ ngá vó ndrẽ ꞌbá ꞌdĩ drí rĩꞌá ꞌẽlâ ꞌdĩ bê rî, gólâ kĩ, ‘Ngá vó ndrẽ ꞌbá ꞌdĩ ꞌê ꞌdĩ lı̣̃fı̣́ lõmbâ ꞌî yí drí. Gólâ êdê lạ́tı̣̂ yí drí ı̣̃zạ́tú óõtírĩ íyî âyé ngá ꞌẽrẽ ꞌásĩ rî tãsĩ.’ ” Gõꞌdá Yésũ âtâ tã trá nõtí kĩ nĩ rî, “Nĩ ndrê drẽ, õjílã ãngó nõ kâ bê ndrĩ, gólĩyî rĩꞌá tã nı̣̃ ꞌbá ꞌî kôrô õjílã Ôvârí kâ rî ꞌbá yî drı̣̃ı̣̂ sĩ, tãlâ õjílã ãngó nõ rî kâ rî ĩyî êdélé njãâ rĩlí tã gólâ ꞌẽ ꞌbá âcálé ı̣̃drú ı̣̃nậtú ãngó nõ ꞌá rî tãsĩ. Gõꞌdá õjílã Ôvârí kâ rî ꞌbá yî êdé ĩyíkâ ĩyî kô võ ꞌbũû ꞌálâ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Má âtâ ãnî drí nõ, õzõ ãnî ãꞌdô trá lãfâ ạ́ngı̣́ bê ãnî drı̣́gạ́ rî, nĩ ꞌbã cé ãnî ífífí drí ĩꞌdî kô. Nĩ pâ kpá õjílã gólĩyî ngá ãkó lé ꞌbá ĩzã ró rî ĩꞌdî sĩ lâ. Ị̃zạ́tú rî, nĩ õtírĩ drãâ nĩlí ûrú ꞌálâ rî, Ôvârí õlậgû ró ãnî bê, ânĩrĩ ꞌá yí ngálâ.” ");
INSERT INTO avu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Õzõ õjílã ãzâ ãꞌdô drı̣́ lõmbâ bê, ngá fínyáwá rú rî, gólâ âꞌdô ꞌbãꞌá kpá drı̣́ lõmbâ bê ngá ạ́ngı̣́ rú. ");
INSERT INTO avu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ámâ ậdrúpı̣̃ yî, Ôvârí fẽ lãfâ ạ́ngı̣́ ãnî drí nõ, ãꞌdô ró ãnî drí ãnî ãzí-ãzí yî pãzó ĩꞌdî sĩ lâ, ngã gõꞌdá õzõ ãnî drı̣́ ãâmbâ âmbâ rú lâ rî, nĩ õpâ ãnî ãzí-ãzí yî ĩꞌdî sĩ lâ kô rî, gõꞌdá ı̣̃zạ́tú õdrã ãníkâ vósĩ rî, Ôvârí âꞌdô fí ãnî pãꞌá trá ngá tãndí sĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Õzõ nĩ õrî ngá ãzí-ãzí kâ rî îzãlé îzã rî, ãꞌdî âꞌdô ngá fẽꞌá nĩ ãnî drí ãꞌdô ró bê ãnî drí vó lâ ndrẽlé yã? ");
INSERT INTO avu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Õzõ nĩ õlẽ lãfâ ạ́ngı̣́ rî, âꞌdô ꞌbãꞌá ãnî drí lậnjı̣̃-lậnjı̣̃ ró Ôvârí rî rõzó. Rû ı̣̂ꞌbũ ꞌbá ãlô rî ı̣̂ꞌbũú rû õjílã rı̣̃ drí ꞌdó ı̣̃tú-pá ãlô rî ꞌá kô. Õzõ gólâ ãârî cé tã õjílã ãlô rî kâ ĩꞌdî rî, gólâ ârí tã õjílã ãzâ rî kâ kô. Má âtâ ĩꞌdî ãnî drí nõ, âꞌdó kô tãndí ró ꞌbãzó rû ı̣̂ꞌbũ ꞌbá Ôvârí kâ ró gõꞌdá kpá lãfâ kâ ró rî.” ");
INSERT INTO avu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pạ̃rúsı̣̃ yî lẽ ĩyíkâ tã lãfâ kâ ꞌdĩ kôrô, ârî ĩyî úlı̣́ Yésũ drí âtálé ĩtí ꞌdĩ bê rî, drílĩyî rĩzó Yésũ rî gũlı̣́. ");
INSERT INTO avu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yésũ kĩ nĩ rî, “Ãnî Pạ̃rúsı̣̃ yî, nĩ rî tã tãndí ãníkâ ꞌẽlé cé õjílã lı̣̃fı̣́ drı̣̃ ꞌá, óõlôngô ró ĩyî tã bê. Ôvârí lẽé õjílã gólĩyî rĩ ꞌbá tã ꞌẽlé ĩtí ꞌdĩ ꞌbá yî kô. Ôvârí nı̣̃ íyíkâ ãnî pı̣̃pı̣̂sı̣́lı̣́ trá ndrĩ ꞌdó ãŋâ ró. ");
INSERT INTO avu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ạ̃kû ró rî, Ôvârí âtâ tã tãndí yí drí ꞌẽꞌá ꞌẽlâ õjílã pãzó rî trá. Músạ̃ rî trá úlı̣́ Ôvârí kâ âtálé, gõꞌdá tã ậngũ ꞌbá ãzâ ꞌbá yî rî kpá ꞌẽlâ. Gõꞌdá Yõwánĩ tíbê rĩ ꞌbá lı̣̃mvû dãlé õjílã drı̣̃ı̣̂, ãâyê ró ĩyî tã õnjí ĩyíkâ rî âtâ kpá. Mâ kpá ĩꞌdî âtáꞌá lâ nõ, õzõ nĩ ãâjâ drı̣̃ tã õnjí ꞌásĩ rî, Ôvârí âꞌdô ãnî pãꞌá. Õjílã ãmbá ârî tã ámákâ trá, gõꞌdá ꞌbã ĩyî trá ậyı̣́lı̣́ úlı̣́ ámákâ rî drı̣̃ı̣̂ îcâ-îcâ ró. ");
INSERT INTO avu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gõꞌdá má lẽ zãâ ãnî drí rĩlí tã Músạ̃ kâ rî rõlé kpá tã tã ậngũ ꞌbá kâ rî bê ndrĩ ꞌbũû, tãlâ úlı̣́ Ôvârí kâ nõ rĩꞌá úlı̣́ ífífí ꞌî, pạ̃tı̣́-pạ̃tı̣̃ ró. Mã ı̣̂njı̣̃ úlı̣́ ꞌdĩ ꞌbá yî õrî ró ạ̃dũkũ ãkó. ");
INSERT INTO avu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nĩ nı̣̃ trá lãꞌbí ꞌá rî, rĩꞌá ꞌwãâ ró ãnî drí ãnî õkó yî îngázó, õkó óꞌdí trõzó. Má âtâ ãnî drí ꞌdĩ, õzõ nĩ õꞌê trá ĩtí rî, nĩ ró Ôvârí kô. Õzõ nĩ õgî õkó ãzí-ãzí drí îngálé trá ạ̃kû rî ĩꞌdî rî, ꞌdĩî kpá rĩꞌá tã õnjí ꞌî Ôvârí ágálé. Tã ífí lâ ĩꞌdî rĩꞌá nõ, tãlâ kậyı̣̂ gólâ ãgô õtírĩ rû gĩî õkó lâ bê rî, Ôvârí kĩ gólĩyî ãâꞌdô ngá ãlô ró té drílĩyî drãzó drãdrã, ágó ró õkó ró, lãfálé cã ãkó.” ");
INSERT INTO avu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Gõꞌdá Yésũ âtâ tã trá kĩ nĩ rî, “Ãgô ãzâ bê rĩꞌá nõngá, gólâ rĩꞌá ngá ãmbá nõ ꞌbá yî tı̣̂ lâ bê cé tı̣̂tı̣̂. Gólâ rĩꞌá ítá tãndí bê, rî íyíkâ ngá tãndí nyãlé ĩꞌdî, kậyı̣̂ vósĩ cé. ");
INSERT INTO avu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ãgô ãzâ rú bê Lázãrõ. Õjílã ãzâ ậnjı̣̃ gólâ trá âyélé ndõgõ ãgô gólâ ngá bê ãmbá ꞌdĩ kâ ꞌdı̣̃lı̣́ ꞌbã rú sĩ ĩtí ꞌdĩ kâ tı̣́lı̣́. Lázãrõ rĩꞌá ĩzã ꞌbá ꞌî, kpá lãzé bê dũû. Lãzé gólâkâ ꞌdĩ ꞌbá yî rî lôrálé lôrâ, õké rî trá ândrãlâ. Lázãrõ ı̣̂sũ tã trá, yí ânĩ ró bê nyãsá ꞌãꞌí lâkí ꞌbá ãgô ꞌdĩ drí âyélé lôꞌdé ꞌbá vũdrı̣́ sĩ rî nyãlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ị̃tú ãzâ sĩ, Lázãrõ tíbê ĩzã ꞌbá ró nõ drã trá. Mãlãyíkã Ôvârí kâ drí gólâ rî âjízó võ gólâ ãmâ ạ́ꞌbı̣́yạ́ Ãbãrãyámã drí rĩzó ꞌá lâ ûrú ꞌálâ rî ꞌá. Gõꞌdá ãgô ãmbá ꞌdĩ drí kpá drãzó, ãvõ lâ ꞌbãzó ꞌbú ꞌá, ");
INSERT INTO avu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","gólâ drí nĩzó võ õjílã zã kâ lạ̃sı̣́ ró rî ꞌálâ rĩꞌá vẽlé. Ãgô ãmbá ꞌdĩ õtírĩ võ ndrẽê ûrú ꞌálâ rî, gólâ ndrê Ãbãrãyámã yî trá Lázãrõ bê jẽjẽ ró yí rú sĩ. Ãbãrãyámã âmvô Lázãrõ trá kpãácĩ yí rú. ");
INSERT INTO avu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ãgô ãmbá ꞌdĩ drí trẽzó ûrû kĩ nĩ rî, ‘Ãbãrãyámã, ní ndrê ámâ ĩzã nô, ní âjô Lázãrõ lũmvû bê dãlé má sı̣́lı̣́, ámâ lãndrâ pá õmvórẽ trá kĩꞌá lạ̃sı̣́ drí nõ. Mâ trá vẽꞌá nõ.’ ");
INSERT INTO avu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ãbãrãyámã lôgõ tã trá ãgô ãmbá ꞌdĩ drí kĩ nĩ rî, ‘Ní ı̣̂sũ drẽ, tã tíbê ní drí ꞌbãzó drẽ ãngó ꞌálâ rî, nî rĩꞌá ngá bê ãmbá ãyĩkõ bê, kậyı̣̂ vósĩ cé, ngá tãndí nyãꞌá. Lázãrõ íyíkâ rĩꞌá ĩzã ꞌẽꞌá tã ı̣̂sũ-ı̣̂sũ bê. Ngbãângbânõ rî, Ôvârí ꞌbã Lázãrõ trá võ tãndí nõ ꞌá ãyĩkõ bê kậyı̣̂ vósĩ cé, nî áníkâ kpá rĩꞌá ĩzã ꞌẽꞌá. ");
INSERT INTO avu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tã ãzâ kpá ĩꞌdî nõ. Îcá kô má drí lậvũzó nĩngá tólâ, tãlâ gólókõ ạ́ngı̣́ rĩꞌá ꞌdĩ ãmâ lãfálé ãní bê rî ꞌá, õjílã ãzâ îcá lậvũlı̣́ tólâ kô.’ ");
INSERT INTO avu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ãgô ãmbá ꞌdĩ âtâ trá kĩ nĩ rî, ‘Âꞌdô trá ĩtí rî, ní âjô Lázãrõ ãânĩ ró ámâ átá rî mvá yî ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mâ rĩꞌá ậdrúpı̣̃ bê njı̣̂, ãâtâ ró tã gólĩyî drí mbı̣̂mbı̣̂, õzó ĩyî gõꞌdá kpá pávó tı̣̂ má drí trõlé nõ trõô õdrã gólĩyíkâ rî vósĩ.’ ");
INSERT INTO avu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ãbãrãyámã âtâ trá gólâ drí kĩ nĩ rî, ‘Gólĩyî cú búkũ Músạ̃ drí îgĩlí rî bê, gõꞌdá kpá tã ậngũ ꞌbá drí îgĩlí rî bê, gólĩyî ãârî úlı̣́ lâ.’ ");
INSERT INTO avu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ãgô ãmbá ꞌdĩ âtâ kpá trá kĩ nĩ rî, ‘Ạ́ꞌbı̣́yạ́ Ãbãrãyámã, gólĩyî âꞌdô ĩyî tã lẽꞌá, té õzõ õjílã ãzâ ãâfõ trá õdrã ꞌásĩ gõlé tã âtálé gólĩyî drí rî, õró ĩyî gõ ârílâ.’ ");
INSERT INTO avu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Gõꞌdá Ãbãrãyámã âtâ kpá trá gólâ drí kĩ nĩ rî, ‘Õzõ gólĩyî ãârî úlı̣́ Músạ̃ yî drí îgĩlí tã ậngũ ꞌbá bê búkũ ꞌá rî kô rî, gólĩyî ârí úlı̣́ õjílã âfõ ꞌbá ãvõ ꞌásĩ nĩlí tã âtálé gólĩyî drí rî kâ kpá kô.’ Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yésũ âtâ tã trá tã ârí ꞌbá íyíkâ rî ꞌbá yî drí kĩ nĩ rî, “Õjílã âdó ꞌbá bê dũû rĩ ꞌbá õjílã ãzí ꞌbãlé rĩꞌá tã õnjí ꞌẽlé rî. Nĩ ârî drẽ, má âtâ ãnî drí, õjílã rĩ ꞌbá õjílã ãzí âdólé rĩꞌá tã õnjí ꞌẽlé rî, Ôvârí âꞌdô lâŋõ ạ́ngı̣́ fẽꞌá gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Õzõ ãꞌdô ĩtí rî, ãnî gólĩyî rĩ ꞌbá õjílã ꞌbãlé tã õnjí ꞌẽlé rî, õzõ tí nĩ õrî nı̣̃lâ kĩꞌá nĩ, lâŋõ lâ Ôvârí drí ꞌẽꞌá fẽlâ ãnî drí rî rĩꞌá gạ̃rạ̃ rî, nĩ âꞌdô tã ı̣̂sũꞌá kĩ, ‘Tí ũkũkũ õró tã ngĩî bê má drí sı̣́sı̣́ rî, má ꞌé tã ꞌdî ꞌbá yî kô. ꞌÉꞌẽ, nõô má âꞌdô ámâ ꞌĩꞌá bãgó sĩ vólé.’ ");
INSERT INTO avu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Õzõ õjílã ãzâ õꞌê tã õnjí ãnî drí rî, nĩ sõ drı̣́-mbílí gólâ lı̣̃fı̣́ sı̣́sı̣́, õzõ gólâ ãꞌdô trá tã ı̣̂sũ-ı̣̂sũ ró tã lâ sĩ rî, õzõ ĩîjî ãnî trá íyî âyélé tã õnjí íyíkâ tãsĩ rî, nĩ âyê gólâ. ");
INSERT INTO avu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Õzõ gólâ õrî kpá zãâ tã õnjí ꞌdĩ ꞌẽlé ãnî drí ândálé ândálé rî, gõꞌdá gólâ ãꞌdô trá kpá tã ı̣̂sũ-ı̣̂sũ ró tã lâ sĩ rî, gólâ ĩîjî ãnî rî, nĩ âyê kpá gólâ tã lâ tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kậyı̣̂ ãzâ sĩ rî, lãjóꞌbá Yésũ kâ drí gólâ rî îjízó kĩ nĩ rî, “Mã lẽ ní ꞌbã ãmâ tã pạ̃tı̣́ı̣̃ ró tã lẽlé gạ̃rạ̃.” ");
INSERT INTO avu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yésũ lôgõ tã trá kĩ nĩ rî, “Õzõ tã lẽlẽ ãníkâ ãꞌdô cé fínyáwá ĩtí õzõ líꞌbá ífí kâtí rî, nĩ âꞌdô tã lârâkô ꞌẽꞌá, ãnî drí tã âtázó fê ạ́ngı̣́ ĩtí ꞌdĩ drí, íyî índrĩgó ângízó rû êsézó, nĩꞌá âdrélé lı̣̃mvû ândrê ĩtí ꞌdĩ ꞌá. Gõꞌdá fê ꞌdĩ âꞌdô tã ꞌdî ꞌẽꞌá té ĩtí.” ");
INSERT INTO avu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kậyı̣̂ ãzâ sĩ, Yésũ âtâ úlı̣́ mãnĩgõ trá tã ârí ꞌbá íyíkâ rî yî drí nõtí, “Õzõ nĩ ãꞌdô rạ̃gı̣́ı̣̃ lı̣́pı̣̂ ꞌî rî, rạ̃gı̣́ı̣̃ ꞌdĩ õꞌê ngá trá ãnî drí rî, ngãtá rî ꞌbô ạ́mvú ãníkâ ꞌwãꞌá, ngã ꞌbô kạ́bı̣̃lı̣́kı̣̃ ãníkâ vó lâ ndrẽlé yã rî, õzõ rạ̃gı̣́ı̣̃ ꞌdĩ õndẽ ngá ꞌẽꞌẽ trá ndrĩ lạ̃njạ́túlı̣́ bê drílâ âgõzó ꞌbã ꞌálâ rî, gólâ âꞌdô âgõꞌá zãâ rĩlí vũdrı̣́ ngá nyãlé yã? ");
INSERT INTO avu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ꞌÉꞌẽ îcá kô, sı̣́sı̣́ gólâ âꞌdô âgõꞌá nyãsá âtrõlé ꞌbãlé tãrãbízã drı̣̃ı̣̂ êdélé íyî lı̣́pı̣̂ drí zãlô nyãlé sı̣́sı̣́. Õzõ gólâ õꞌê trá rî, gõꞌdá ꞌdĩî vósĩ rî, lı̣́pı̣̂ lâ õró gõ gólâ rî âyélé rĩlí vũdrı̣́ íyíkâ rî nyãlé. ");
INSERT INTO avu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Õzõ gólâ õndẽ ngá ꞌẽꞌẽ ꞌdî ꞌbá yî trá ndrĩ rî, lı̣́pı̣̂ lâ ꞌé ãwô-ĩtí drílâ kpá kô âkĩꞌá nĩ rî, rạ̃gı̣́ı̣̃ ꞌdĩ ꞌé ngá ãzâ gólâ drí tãndí ró lậvũlı̣́ kô rî tí. ");
INSERT INTO avu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ĩtí Ôvârí ĩꞌdî ãnî lı̣́pı̣̂ ꞌî, gõꞌdá ãnî rạ̃gı̣́ı̣̃ gólâkâ ĩꞌdî, îcâ trá ãnî drí gólâ rî rõzó ĩꞌdî. Nĩ rô Ôvârí, gólâ õꞌê tã tãndí kpálé ãnî drí kô rî, tãlâ gólâ rĩꞌá lı̣́pı̣̂ ãníkâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yésũ drí rĩrĩ lậmúlı̣́ Yẽrõsãlémã ꞌálâ rî ꞌá, gólâ lậvũ trá ãnyî ẽsê-drı̣̃ Sãmárĩyã yí kâ Gãlĩláyã bê rî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Gólâ ûsû ãgô ãzâ ꞌbá yî trá mûdrı̣́ ꞌdó ãrí ꞌbá ꞌî ĩyî ꞌbã-tı̣̂ ãzâ gãrã lâ ꞌá. Ãgô ꞌdĩ ꞌbá yî âdrê ĩyî trá ĩyî võ ꞌá, ânĩí ĩyî ãnyî Yésũ ngálâ kô. ");
INSERT INTO avu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Gólĩyî zı̣̂ Yésũ trá kĩ nĩ rî, “Yésũ ãmâ lı̣́pı̣̂, ní ndrê ãmâ ĩzã, ní êdê ró ãmâ bê.” ");
INSERT INTO avu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yésũ ndrê gólĩyî bê ĩtí rî, drílâ gõzó tã âtálé gólĩyî drí kĩ nĩ rî, “Nĩ ngâ nĩ nĩ ró ãnî rúꞌbạ́ ꞌdĩ ꞌbá yî âꞌdálé drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ drí, tãlâ drı̣̃-ꞌbá lãꞌbí ꞌẽ kâ õlôyâ ró bê tã lâ õjílã drí kĩ nĩ rî, ãnî rúꞌbạ́ êdê rû trá.” Gõꞌdá gólĩyî õtírĩ nĩî rî, rúꞌbạ́ lâ yî êdê rû trá tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ãrí ꞌbá gólâ ãlô rî ndrê bê ĩtí rî, gólâ âgõ trá Yésũ ngálâ ãwô-ĩtí ꞌẽlé Yésũ drí, kpá Ôvârí rî lûyı̣̂-lûyı̣̂ bê ôtrê-ôtrê bê gbórókõ ãmbá sĩ. ");
INSERT INTO avu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Gólâ ânĩ trá ꞌãꞌî tı̣̃lı̣́ Yésũ ágálé ãwô-ĩtí ꞌẽlé Yésũ drí. Ãgô ꞌdĩ rĩꞌá Sãmárĩyã lé ꞌbá ꞌî, gólâ âꞌdó õjílã Yúdạ̃ yí kâ ꞌî kô. ");
INSERT INTO avu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Gõꞌdá Yésũ drí tã âtázó kĩ nĩ rî, “Má êdê õjílã mûdrı̣́ trá tãndí ró. Ãlô rî âgõ cé nĩ rî, ạ̃mbúkũ lâ ꞌdĩ ꞌbá yî ãꞌdô ꞌá yã? ");
INSERT INTO avu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cé õjílã ãtrâ nõ âgõ íyíkâ cé nĩ, ãwô-ĩtí ꞌẽlé Ôvârí drí rî yã?” ");
INSERT INTO avu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yésũ drí tã âtázó ãgô ꞌdĩ drí kĩ nĩ rî, “Ní ngâ ûrû, ní nĩ, nî trá tãndí ró. Tã lẽlẽ áníkâ má ꞌá rî êdê nî nĩ.” ");
INSERT INTO avu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kậyı̣̂ ãzâ sĩ rî, Pạ̃rúsı̣̃ ãzâ ꞌbá yî îjî ĩyî tã îjî-îjî trá Yésũ tı̣́ gólâ rî ûjũzó kĩ nĩ rî, “Ôvârí âꞌdô gólâ tíbê yí drí zĩlí rî âjóꞌá ãmâ pãlé, gõꞌdá kpá rĩlí ãmâ drı̣̃ı̣̂ kúmú ró rî ángô tû yã?” Gõꞌdá Yésũ lôgõ tã trá gólĩyî drí, “Õzõ gólâ tíbê Ôvârí drí zĩlí rî ãâcâ rî, âꞌdô âcáꞌá ı̣̃nı̣́nı̣̂ ró. ");
INSERT INTO avu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gólâ âcá kô rĩlí kı̣́tı̣̃ íyíkâ drı̣̃ı̣̂ rĩꞌá ãnî vó ndrẽlé kúmú ãzâ võ lâ ꞌá rî kô. Nĩ nı̣̃ı̣́ kĩꞌá nĩ rî, gólâ tíbê Ôvârí drí zĩlí rî âcâ trá ãngó ꞌá nõngá, gólâ rĩꞌá ngbãângbânõ ãnî lãfálé ꞌá nõngá rî kô yã?” ");
INSERT INTO avu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ꞌDĩî vósĩ, Yésũ âtâ tã trá tã ârí ꞌbá íyíkâ rî yî drí kĩ nĩ rî, “Ị̃zạ́tú rî, nĩ âꞌdô tã mâ gólâ âjólé trá ûrú lésĩ rî kâ ı̣̂sũꞌá kôrô, má ãâgõ ró bê ãngó ꞌá nõngá ĩyî pãlé, gõꞌdá ꞌdĩî rî âꞌdó drẽ kậyı̣̂ ámákâ ꞌẽzó âgõlé rî ĩꞌdî kô. ");
INSERT INTO avu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Õjílã ãzâ ꞌbá yî âꞌdô rĩꞌá ãnî âdólé kĩ nĩ rî, yĩ õndrê mâ gólâ âjólé ûrú lésĩ rî trá võ ãzâ ꞌá. Gõꞌdá ꞌdĩî rî, nĩ lẽé tã-drı̣̃ lâ kô, nĩ lẽé tã-drı̣̃ kpá kô âꞌdézó gólĩyî vó. ");
INSERT INTO avu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Õzõ má õꞌê âcálé rî, tã lâ âꞌdô lậꞌbúꞌá ꞌbạ̃drı̣̃ ãmbá nõ ꞌbá yî ꞌásĩ ndrĩ, õzõ ôzê lậgû-lậgû gólâ lậgú ꞌbá ꞌwãâ ûrû õjílã drí ndrẽlé võ ꞌásĩ ndrĩ rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngbãângbânõ rî, mâ ꞌẽꞌá lâŋõ ûsúlı̣́ ĩzã kõkõ ãmbá bê, õjílã gólĩyî ꞌbã ꞌbá lédrẽ-lédrẽ ró ndrẽ ꞌbá lâ rî âꞌdô gãꞌá dó tã ámákâ rî lẽlé. Tákõ, ꞌdĩî rî mâ gólâ Ôvârí drí âjólé ûrú lésĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Gõꞌdá kậyı̣̂ tíbê má drí ꞌẽzó âgõlé ãngó ꞌá nõngá rî ꞌá, õjílã âꞌdô rĩꞌá tã ꞌẽlé, té õzõ drílĩyî rĩrĩ tã ꞌẽlé kậyı̣̂ Nówã kâ rî ꞌá rî kâtí. ");
INSERT INTO avu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Gólĩyî âꞌdô ĩyîngá rĩꞌá ậndú tõlé, õdrá mvũlı̣́, lãgĩ õkó kâ ꞌẽꞌá ĩꞌdî. Nĩ ndrê drẽ, õjílã kậyı̣̂ Nówã kâ rî ꞌá rî ı̣̂sũú ĩyî tã kô, Nówã õtírĩ fĩî kõlóngbõ ạ́ngı̣́ ꞌdĩ ꞌá rî, gõꞌdá ꞌdĩî rî vósĩ rî, ôzê drí ꞌdı̣̃zó, lı̣̃mvû ândrê drí tı̣̃zó gólĩyî ûfúlı̣́ ndrĩ vólé, tãlâ gólĩyî êdé ĩyî njíyá ró lı̣̃mvû tı̣̃tı̣̃ drı̣̃ tẽzó kô, tãlâ gólĩyî kĩ, lı̣̃mvû îcá tı̣̃lı̣́ ãngó ãmbá nõ êtélé kô. Âꞌdô tã âgõ-âgõ ámákâ ãngó ꞌá rî kâ tãsĩ rî kpá ĩtí, õjílã îcá kô tã lâ lẽlé kĩ, má âgõ trá. ");
INSERT INTO avu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Kậyı̣̂ gólâ má drí ꞌẽzó âgõlé ãngó ꞌá nõlé rî, âꞌdô ꞌbãꞌá õzõ kậyı̣̂ gólâ tíbê Ôvârí drí õjílã Sõdómõ kâ zãzó lạ̃sı̣́ sĩ Gõmórã kâ bê rî tí, kậyı̣̂ Lótõ drí ꞌbãzó drẽ rĩꞌá gólĩyî lãfálé rî kâtí. Õjílã ꞌdî ꞌbá yî rî ĩyîngá drı̣̃-bạ́lạ́yı̣̂ ró. Õjílã ãzâ ꞌbá yî ĩyîngá ngá nyãꞌá, gõꞌdá ãzâ ꞌbá yî rĩꞌá õdrá mvũꞌá, gõꞌdá ãzâ ꞌbá yî ĩyíkâ ngá gĩꞌá, ãzâ ꞌbá yî ạ́mvú ĩyíkâ ꞌwãꞌá, ãzâ ꞌbá yî jó óꞌdí ĩyíkâ bẽꞌá. Gólĩyî nı̣̃ı̣́ kĩꞌá nĩ rî, Ôvârí bí ꞌẽꞌá ĩyî zãlé ꞌbũû ngbãângbânõ rî tí rî kô. ");
INSERT INTO avu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lótõ yî ꞌbã-tı̣̂ íyíkâ rî bê, drílĩyî ĩyîngá rãzó fõlé vólé, gõꞌdá Ôvârí drí lạ̃sı̣́ âdãzó ꞌbũû lésĩ õjílã ꞌdî ꞌbá yî drı̣̃ı̣̂ gólĩyî zãlé ngá õnyíkõ bê ngbá ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ámâ âgõ-âgõ ı̣̃zạ́tú rî, âꞌdô ꞌbãꞌá nyé õzõ ꞌdĩî rî kâtí. Õjílã ãmbá âꞌdó kô njãâ ámâ âgõ-âgõ tã ârílí rĩzó ámâ drı̣̃ tẽlé. ");
INSERT INTO avu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Kậyı̣̂ gólâ má drí ꞌẽzó âgõlé rî ꞌá, õzõ nĩ ãꞌdô ûrû jó-drı̣̃ tĩꞌá rî, nĩ ârî gõꞌdá vũdrı̣́ fĩlí ãnî drí jó ꞌálâ kô ngá õnyíkõ ãníkâ âtrõlé. Õzõ nĩ ãâꞌdô ngá ꞌwãꞌá ạ́mvú ꞌálâ rî, nĩ âgõ gõꞌdá ꞌbã ꞌálâ kô. ");
INSERT INTO avu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tã gólâ Lótõ rî õkó kâ rî ãâgâ drẽ ãnî ꞌá, nĩ ı̣̂sũ tã lâ. ");
INSERT INTO avu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Õzõ nĩ ı̣̃ı̣̂sũ rĩrĩ ãníkâ ãngó ꞌá nõngá rî tã lâ ũsû ãnî drí kôrô rî, nĩ îcá gõꞌdá rĩlí ꞌbạ̃drı̣̃ Ôvârí kâ ạ̃dũkũ ãkó nã ꞌálâ rĩlí zãâ gólâ bê gbạ́dú kô. Kậyı̣̂ gólâ âgõ-âgõ ámákâ ãngó ꞌá nõngá rî tú rî, má âꞌdô õjílã ãzâ ꞌbá yî pãꞌá, gõꞌdá má âꞌdô kpá ũgúlı̣́ dĩꞌá õjílã ãzâ ꞌbá yî drí. ");
INSERT INTO avu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ãgô ãzâ ꞌbá yî, õzõ õkô ĩyî ậꞌdú gbãrãkã ãlô drı̣̃ı̣̂ rı̣̃ rî, má âꞌdô ãlô rî pãꞌá, má âꞌdô ãlô rî âyéꞌá. ");
INSERT INTO avu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Õzõ õkó ãzâ ꞌbá yî âꞌdô rı̣̃ õrî ĩyî ngá ꞌı̣̃ꞌá rî, má âꞌdô cé ãlô rî trõꞌá ĩꞌdî, õzõ ãzâ rî ãꞌdô kô õjílã ámákâ ĩꞌdî rî, má âꞌdô âyéꞌá lâ ãkpã võ ꞌdî ꞌá nĩngá.” ");
INSERT INTO avu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Gõꞌdá tã ârí ꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí gólâ rî îjízó kĩ nĩ rî, “Võ mbı̣̂mbı̣̂ áníkâ ní drí ꞌẽzó âgõlé rî, íyíkâ ãꞌdô ꞌá yã?” Gõꞌdá Yésũ drí tã lôgõzó kĩ nĩ rî, “Nĩ âꞌdô nı̣̃ꞌá lâ, õzõ lõgónõ drí võ gólâ kõrõnyã drí drãzó ꞌá lâ rî nı̣̃rı̣̃ kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ꞌDĩî vósĩ, Yésũ ngî íꞌdígówá ãzâ trá tã ârí ꞌbá íyíkâ rî ꞌbá yî drí. Íꞌdígówá ꞌdĩ rî tã âꞌdálé nõtí, tãndí ró ãnî drí rĩzó zãâ rãtáã ꞌẽlé ĩꞌdî, nĩ âyê tã lâ, ũvı̣̃ kô, nĩ õzó ôkõô kô. ");
INSERT INTO avu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yésũ kĩ nĩ rî, “Tã kĩ ꞌbá ãzâ gólâ âꞌdó tã kĩ ꞌbá tãndí ꞌî kô. ");
INSERT INTO avu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Õkó ãzâ ạ̃yı̣́zı̣́ ró ânĩ trá gólâ ngálâ ândálé ândálé, õpâ ró yî tã-vó íyíkâ kĩlí rî. ");
INSERT INTO avu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tã kĩ ꞌbá ꞌdĩ rî gãlé zãâ dó tã-vó õkó ꞌdĩ kâ kĩlí. Gõꞌdá kậyı̣̂ ãmbá ãzâ ꞌbá yî vósĩ rî, tã kĩ ꞌbá ꞌdĩ ı̣̂sũ tã trá yí ꞌá kĩ nĩ rî, ‘Má ró Ôvârí kô õjílã bê ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tákõ má lẽ trá tã-vó õkó ꞌdĩ kâ kĩlí, tãlâ gólâ rî trá ámâ îkpókpólõlé ı̣̃tú vósĩ cé.’ ” ");
INSERT INTO avu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yésũ gõꞌdá âtâ tã trá lãjóꞌbá íyíkâ rî yî drí kĩ nĩ rî, “Nĩ ârî úlı̣́ tã kĩ ꞌbá ꞌdĩ drí âtálé ꞌdĩ trá yã? Gólâ âꞌdó kô tã kĩ ꞌbá tãndí ꞌî, gõꞌdá gólâ pâ õkó ꞌdĩ trá. ");
INSERT INTO avu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nĩ ndrê drẽ, Ôvârí tíbê ꞌbã ꞌbá ı̣̃tú vósĩ cé tãndí ró nõ âꞌdô rĩꞌá zãâ õjílã rĩ ꞌbá ãwó ngõlé yí drí rãtáã bê rî pãlé. ");
INSERT INTO avu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Õzõ gólâ õpâ õjílã ꞌdî ꞌbá yî kô ꞌwãâ ró, ãkpã drílĩyî ãwó ngõrẽ ꞌá rî, ꞌdĩî rî âꞌdô gólĩyî pãꞌá kpá kậyı̣̂ ãzâ ꞌbá yî sĩ ꞌwãâ ró. Ãꞌdô ĩtí rî, má îjî ãnî rĩlí ãwó ngõlé ı̣̃tú vósĩ cé rãtáã bê, tãlâ mâ gólâ ûrú lésĩ nô õtírĩ âgõô ãngó ꞌá nõngá rî, ũûsû ró ãnî bê njãâ rãtáã ꞌẽrẽ ꞌá ãwó ngõngõ bê.” ");
INSERT INTO avu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kậyı̣̂ ãzâ sĩ, Yésũ âtâ úlı̣́ mãnĩgõ ãzâ trá õjílã gólĩyî lómbé-lómbéwá ꞌbá ró kĩꞌá nĩ rî, yĩ âꞌdô tã tãndí ꞌẽ ꞌbá ꞌî rĩzó õjílã ãzí zı̣̃lı̣́ tã õnjí ꞌbá ró rî yî drí. ");
INSERT INTO avu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Gólâ kĩ nĩ rî nõtí, “Õjílã ãzâ ꞌbá yî rı̣̃, nĩ ĩyî trá rãtáã ꞌẽlé jó ạ́ngı̣́ Ôvârí kâ ꞌálâ. Ãlô rî íyíkâ bélé-bélé ûꞌdú ꞌbá ꞌî, gõꞌdá ãzâ rî íyíkâ Pạ̃rúsı̣̃ ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pạ̃rúsı̣̃ ꞌdĩ âdrê íyíkâ ûrû õjílã lı̣̃fı̣́ drı̣̃ ꞌá íyî âꞌdálé rĩzó rãtáã ꞌẽlé. Gólâ kĩ nĩ rî, ‘Ãwô-ĩtí Ôvârí, má lûyı̣̂ nî trá, tãlâ ní ꞌbã mâ trá tãndí ró õjílã ãzí drı̣̃ı̣̂ sĩ ndrĩ, gólĩyî ngá ôpá ꞌbá, õmbã ꞌẽ ꞌbá, ꞌdãzí rî õkó ậyı̣́ ꞌbá, gõꞌdá kpá õzõ bélé-bélé ûꞌdú ꞌbá ámâ gãrã ꞌá nõtí nõ gõꞌdá kpá gólĩyî tã lãꞌbí ãmákâ kâ îzã ꞌbá rî. Hâã! Mâ tãndí ró gạ̃rạ̃ drı̣̃ lâ yî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ôvârí, ní ndrê trá, má rî rãtáã ꞌẽlé ꞌálé ꞌãꞌí sĩ ní drí, má rî rĩlí lõfó sĩ ândâlâ rı̣̃ gímã ãlô ꞌá. Má rî kpá lãfâ fẽlé õjílã rĩ ꞌbá tã áníkâ âtálé ãmâ drí rî drı̣́gạ́.’ ");
INSERT INTO avu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Gõꞌdá bélé-bélé ûꞌdú ꞌbá ꞌdĩ ânĩ bê rî, ꞌê rãtáã íyíkâ ı̣̃nı̣́nı̣̂ ró rúꞌbạ́ lôꞌbã-lôꞌbã sĩ. Õzõ õjílã áyábálá kâtí, gólâ rî âdrélé íyîngá ãkpã vólé ꞌálâ ró. Drílâ rĩzó íyî ạ́gạ́sı̣́ drı̣̃ sãlé ĩzã sĩ trạ̃ trạ̃ kĩ nĩ rî, ‘Óõ! Ôvârí mâ tã õnjí ꞌbá nõ, má lôꞌbã rúꞌbạ́ ní drí, ní âyê mâ tã õnjí ámákâ ãmbá nõ ꞌásĩ, mâ rĩꞌá tã õnjí ꞌbá ꞌî.’ ” ");
INSERT INTO avu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Gõꞌdá Yésũ âtâ trá kĩ, “Má âtâ drẽ tã nô ãnî drí. Ôvârí âyê tã õnjí bélé-bélé ûꞌdú ꞌbá ꞌdĩ kâ trá, gõꞌdá gólâ âyé tã õnjí gólâ Pạ̃rúsı̣̃ kâ rî kô. Õzõ õjílã ãzâ õlôngô íyî tã ãkpã nĩ rî, Ôvârí âꞌdô gólâ rî ꞌbãꞌá âꞌdólé ngá tãkó ró. Õzõ õjílã ãzâ õꞌbã yî âꞌdólé ngá tãkó ró rî, Ôvârí âꞌdô gólâ rî rú ꞌbãꞌá lôngô-lôngô ró.” ");
INSERT INTO avu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Gõꞌdá nĩngá sĩ rî, õjílã ãzâ ꞌbá yî drí ꞌdĩyímvá õnyíkõ âjízó Yésũ ngálâ, õfẽ ró õrẽ gólĩyî drí. Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî lôgâ gólĩyî dó ânĩlí ãnyî ꞌdĩyímvá ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Gõꞌdá gólâ ndrê bê ĩtí rî, gólâ ậzı̣̂ ꞌdĩyímvá õnyíkõ ꞌdî ꞌbá yî trá ânĩlí yí ngálâ. Gólâ âtâ trá lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ âyê ꞌdĩyímvá õnyíkõ ꞌdî ꞌbá yî ãânĩ ró ĩyî má ngáá nõlé. Nĩ lôgâ gólĩyî kô. ");
INSERT INTO avu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nĩ ndrê trá, tã kũmũ Ôvârí kâ ꞌá rî rĩꞌá nõtí, õjílã lâ ꞌá lâ rî, rĩꞌá tã lẽlẽ bê, õzõ ꞌdĩyímvá õnyíkõ kâtí. Âꞌdô ꞌbãꞌá cé ãnî tã lẽ ꞌbá õzõ ꞌdĩyímvá õnyíkõ kâtí rî ꞌbá yî drí. Âꞌdô ĩyî fĩꞌá nĩ kũmũ Ôvârí kâ rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kậyı̣̂ ãzâ sĩ, ãgô ãmbá ãzâ îjî Yésũ trá kĩ nĩ rî, “Lı̣̃fı̣́ îmbá ꞌbá tãndí, má âꞌdô ãꞌdô ꞌẽꞌá ĩꞌdî má drí rĩzó kũmũ Ôvârí kâ zẽlé, rĩlí gólâ bê ạ̃dũkũ ãkó yã?” ");
INSERT INTO avu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yésũ kĩ nĩ rî, “Má lôgõ tã-vó áníkâ ꞌdĩ nõtí. Ní zı̣̂ mâ lı̣̃fı̣́ îmbá ꞌbá tãndí ró tãlâ ãꞌdô ꞌî yã? Cé Ôvârí ĩꞌdî tãndí ró. ");
INSERT INTO avu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gõꞌdá ní rô tã ãmbá Ôvârí drí âꞌdálé Músạ̃ drí mûdrı̣́ rî ꞌbá yî trá ndrĩ yã, kĩꞌá nĩ rî, ní ꞌbã õkó gólâ âꞌdó ꞌbá kô ánî õkó ró rî kô ní ũgúlı̣́ ậyı̣́zó ĩꞌdí bê lâ, ní fû õjílã kô, ní ûgũ ngá kô, ní âdô õnjõ kô, ní ârî ánî átá yî tı̣̂-võ ánî ândré yí bê, tãlâ ní ı̣̂njı̣̃ ró gólĩyî bê yã?” ");
INSERT INTO avu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ãgô ꞌdĩ lôgõ tã-drı̣̃ trá Yésũ drí kĩ nĩ rî, “Drẽ ãkpãkãꞌdã, má drí ꞌbãzó ꞌdĩyímvá ró rî, má rô tã ꞌdî ꞌbá yî trá ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Gõꞌdá Yésũ ârî tã ꞌdî ꞌbá yî bê rî, drílâ tã âtázó ãgô ꞌdĩ drí kĩ nĩ rî, “Tãndí ró, ní rô tã ꞌdî ꞌbá yî trá ndrĩ. Tã ãzâ rĩꞌá ãlô, ní gî ngá ní drí ꞌbãzó ĩꞌdí bê lâ ꞌdĩ ꞌbá yî ndrĩ, ní fẽ ró lãfâ lâ ĩzã ꞌbá yî drí ĩyî pãzó. Õzõ ní õꞌê trá ĩtí rî, Ôvârí âꞌdô ngá tãndí tı̣̂ dũû fẽꞌá ní drí, ní drí rĩzó gólâ bê võ ûrú ꞌálâ rî ꞌálâ. ꞌDĩî rî tã gólâ lậvũ ꞌbá gạ̃rạ̃ lãfâ drı̣̃ı̣̂ sĩ rî ĩꞌdî, ní gõ ró âꞌdélé má vó.” ");
INSERT INTO avu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ãgô ꞌdĩ ârî tã Yésũ drí âtálé ĩtí ꞌdĩ bê rî, gólâ trá tã ı̣̂sũ-ı̣̂sũ ró ãmbá, tãlâ gólâ rĩꞌá ngá-tı̣̂ bê ãmbá, lẽé gĩlâ ndrĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gõꞌdá Yésũ âtâ trá õjílã rĩ ꞌbá ĩtí tã ꞌdî ârílí rî ꞌbá yî drí kĩ nĩ rî, “Rĩꞌá lâŋõ ró ãmbá õjílã ngá-tı̣̂ bê dũû rî drí fĩzó kũmũ Ôvârí kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Âꞌdô ꞌbãꞌá cú ĩtí lâŋõ ãkó ĩnjígó drí fĩzó lı̣́bı̣̃rạ̃ ꞌbú ꞌásĩ kõólõróõ.” ");
INSERT INTO avu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Gõꞌdá õjílã rĩ ꞌbá ãmbá tã ârílí ĩtí ꞌdĩ ꞌbá yî âtâ ĩyî trá Yésũ drí kĩ nĩ rî, “Õzõ ãꞌdô ĩtí rî, âꞌdô âꞌdóꞌá ángô tí ró õjílã ãzãkã drí ngá pãzó yã?” ");
INSERT INTO avu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yésũ drí tã-drı̣̃ jãzó kĩ nĩ rî, “Õjílã ãzãkã yûꞌdạ́wạ́ ãnî lãfálé sĩ tã tãndí ꞌẽlé tãlâ ĩyî ꞌbãlé õjílã Ôvârí kâ ró rĩlí gólâ bê ạ̃dũkũ ãkó ûrú ꞌálâ, cé Ôvârí âꞌdô ãnî ꞌbãꞌá nĩ õjílã íyíkâ ró.” ");
INSERT INTO avu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pétẽrõ âtâ trá Yésũ drí kĩ nĩ rî, “Ní ndrê drẽ, ãmâ rî gógó rî, mã âyê ngá ãmbá ãmákâ rî ꞌbá yî trá ndrĩ vólé âꞌdézó ánî vó bẽlé nõ. Âꞌdô îcáꞌá trá ãmâ drí fĩzó kũmũ Ôvârí kâ rî ꞌálâ yã?” ");
INSERT INTO avu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Yésũ drí kpá tã âtázó tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ôvârí âꞌdô ngá tãndí âfẽꞌá dũû ãnî drí ãngó ꞌá nõngá, gõꞌdá gólâ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽꞌá ãnî drí võ ûrú ꞌálâ rî ꞌálâ, ãnî gólĩyî ꞌbã ĩyíkâ âyé ꞌbá ndrĩ ĩyî áró yí bê ndrĩ kũmũ Ôvârí kâ tãsĩ rî yî drí.” ");
INSERT INTO avu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gõꞌdá Yésũ yî drí ngãzó nĩlí lạ́tı̣̂ Yẽrõsãlémã kâ ꞌásĩ gõlé Yẽrõsãlémã ꞌálâ ró. Drílâ lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yî ậzı̣́zó ndrĩ tã ârí ꞌbá ãzâ ꞌdĩ ꞌbá yî lãfálé ꞌásĩ rĩlí yí lạ̃gạ́tı̣́ tã âtázó drílĩyî. Gólâ kĩ, “Ngbãângbânõ rî, nĩ ngâ, mã nĩ Yẽrõsãlémã ꞌálâ, tãlâ ạ̃kû ró rî, tã ậngũ ꞌbá Ôvârí kâ âtâ trá kĩ nĩ rî, cé Yẽrõsãlémã ꞌálâ ĩꞌdî, tã ãzâ ꞌbá yî drí rû ꞌẽzó mâ gólâ tíbê âjólé Ôvârí ngá lésĩ rî drí. ");
INSERT INTO avu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ámâ drı̣̃ âꞌdô âꞌdéꞌá õjílã ãtrâ Rómã kâ rî ꞌbá yî drı̣́gạ́. Õjílã ꞌdî ꞌbá yî âꞌdô ĩyî ámâ lôꞌdáꞌá, âꞌdô ĩyî tũ lûwúꞌá má rú. ");
INSERT INTO avu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Drílĩyî ámâ cãzó kpá drílĩyî ámâ fũzó. Gõꞌdá kậyı̣̂ nâ lâ ꞌá rî, má drí kpá âfõzó óꞌdí õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî nı̣̃ı̣́ ĩyî tã Yésũ drí âtálé ĩyî drí ꞌdĩ ífí lâ kô, âꞌdó kô mbı̣̂ gólĩyî bı̣́lı̣́. ");
INSERT INTO avu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yésũ drí ꞌẽrẽ nĩlí lậvũlı̣́ kôrô Yérĩkõ ꞌásĩ nĩlí Yẽrõsãlémã ꞌálâ rî ꞌá rî, õꞌbí ãmbá rî trá nĩlí gólâ bê. Ãgô ãzâ lı̣̃fı̣́ ãkó rĩ ꞌbá nĩꞌá lãfâ zı̣̃ bê õjílã tı̣́ sĩ rî, rĩꞌá ãnyî pávó tı̣̂ gãrã ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lı̣̃fı̣́ ãkó lé ꞌbá ꞌdĩ ârílí bê õjílã õꞌbí ãmbá dũû rî ꞌbá ĩyî lậvũlı̣́ yí lạ̃gạ́tı̣́ sĩ ꞌdî ạ̃yı̣́ lâ rî, gólâ îjî õjílã ãzâ ãnyî yí lạ̃gạ́tı̣́ ĩtí ꞌdĩ trá kĩ nĩ rî, “ꞌDĩî ãꞌdô ꞌî yã ãmbá ạ̃yı̣́ bê ꞌdĩ?” ");
INSERT INTO avu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Õjílã ꞌdî âtâ trá gólâ drí kĩ nĩ rî, “Yésũ Nãzãrétã lé ꞌbá ró rî ĩꞌdî õjílã ãzâ ꞌbá yí bê lậvũꞌá ĩyî.” ");
INSERT INTO avu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ãgô gólâ lı̣̃fı̣́ ãkó ꞌdĩ zı̣̂ lạ̃zı̣́ trá ãmbá ãmbá kĩ nĩ rî, “Yésũ, ní ꞌbã ámâ ĩzã õgâ ní drı̣̃ı̣̂, nî ĩꞌdî tíbê Ôvârí drí tã lâ âtálé kĩꞌá nĩ rî, ãâꞌdô ânĩꞌá ãmâ pãlé nõ, ní pâ mâ.” ");
INSERT INTO avu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Gõꞌdá õjílã ãzâ ꞌbá yî drí tã lôgõzó gólâ drı̣̃ı̣̂ kĩ nĩ rî, “Nî, ní rî tı̣́tı̣́.” Gõꞌdá gólâ ârí tã õjílã ꞌdî ꞌbá yí kâ ꞌdĩ kô. Drílâ lạ̃zı̣́ ãzâ zı̣̃zó kpá ãmbá ãmbá kĩ nĩ rî, “Nî ĩꞌdî tíbê Ôvârí drí tã lâ âtálé kĩꞌá nĩ rî, ãâꞌdô ânĩꞌá ãmâ pãlé nõ, ní ndrê ámâ ĩzã! Ánî ꞌâ ạ̃ậꞌdı̣̂ má rú! Ní pâ mâ!” ");
INSERT INTO avu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Gõꞌdá Yésũ drí âdrézó kĩ nĩ rî õjílã ꞌdî ꞌbá yî drí rî, “Nĩ âjî ãgô ꞌdĩ má ngáá nõlé.” Gõꞌdá lı̣̃fı̣́ ãkó lé ꞌbá ꞌdĩ drí ânĩzó ãnyî Yésũ lạ̃gạ́tı̣́. Yésũ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ní lẽ ãꞌdô má drı̣́gạ́ sĩ yã? Má âꞌdô ánî pãꞌá ángô tí ró yã?” Lı̣̃fı̣́ ãkó lé ꞌbá ꞌdĩ kĩ, “Ãgô ãmbá, ní êdê ámâ lı̣̃fı̣́ nõ võ ndrẽlé tãndí ró.” ");
INSERT INTO avu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Gõꞌdá Yésũ kĩ, “Ánî lı̣̃fı̣́ ꞌdĩ âꞌdô võ ndrẽꞌá, âꞌdô ꞌbãꞌá tãndí ró. Tã lẽlẽ áníkâ má ꞌá rî ꞌbã nî trá rû êdélé tãndí ró.” ");
INSERT INTO avu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kôrô ı̣̃tú ꞌdĩ sĩ rî, ãgô ꞌdĩ drí võ ndrẽzó tãndí ró rárá. Gõꞌdá ãgô ꞌdĩ drí ngãzó ꞌdẽlé Yésũ vó, Yésũ rî rú lûyı̣̂-lûyı̣̂ bê ãwô-ĩtí ãmbá ꞌẽꞌẽ bê Ôvârí drí ı̣̃tú vósĩ cé kĩ nĩ rî, “Tákõ, Ôvârí rĩꞌá mbârâkã bê tákányĩ pạ̃tı̣́ı̣̃ tí má ndré võ kô.” Gõꞌdá õjílã ãmbá ꞌdĩ ꞌbá yî ndrê ĩyî gólâ bê võ ndrẽꞌá rî, lûyı̣̂ ĩyî Ôvârí kpá trá kĩ nĩ rî, “Tákõ, Ôvârí fẽ fãfã trá gạ̃rạ̃ Yésũ drí pạ̃tı̣́ı̣̃.” ");
INSERT INTO avu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Gõꞌdá Yésũ drí ngãzó nĩlí kôrô jạ̃rı̣́bạ̃ Yérĩkõ kâ rî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ãgô ãzâ bê tólâ rú lâ Zãkáyõ, gólâ rĩꞌá drı̣̃-ꞌbá bélé-bélé ûꞌdú ꞌbá kâ ꞌî, gólâ rĩꞌá kpá ngá-tı̣̂ ãmbá rî ꞌbá yí bê dũû, tã ndẽé gólâ kô. Õjílã ndrĩ ꞌbãá ĩyî bélé-bélé ûꞌdú ꞌbá lôvó kô, tãlâ gólĩyî rî ĩyî trá lãꞌbí gólĩyíkâ îzãlé kpá rĩꞌá lãfâ õjílã kâ âdólé nyãlé. ");
INSERT INTO avu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zãkáyõ ârî bê kĩꞌá nĩ rî, Yésũ trá ânĩꞌá kôrô jạ̃rı̣́bạ̃ ꞌásĩ rî, gólâ lẽ trá cú Yésũ rî lı̣̃fı̣́ ndrẽlé. Zãkáyõ rĩꞌá ãgô kútúwạ́ ꞌî, nyãgõrã ró, îcá Yésũ rî rúꞌbạ́ ndrẽlé tólâ kô, tãlâ õꞌbí trá dũû. ");
INSERT INTO avu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gõꞌdá nĩngá sĩ rî, râ trá lậvũlı̣́ sı̣́sı̣́ ꞌálâ mbãlé fê ạ́ngı̣́ tõrõngõlõ lâ drı̣̃ı̣̂ Yésũ rî lậvũ-lậvũ tẽlé rúꞌbạ́ lâ ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Gõꞌdá Yésũ âcálé bê té fê ạ́ngı̣́ ꞌdĩ zẽlé rî, gólâ drí Zãkáyõ rî zı̣̃zó kĩ nĩ rî, “Zãkáyõ, Zãkáyõ, ní ârî vũdrı̣́. Ãndrõ nô rî, má lẽ trá nĩlí rĩlí ní drí ꞌbã ꞌálâ ní bê.” ");
INSERT INTO avu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ãyĩkõ cî Zãkáyõ trá. Drílâ ârízó fê drı̣̃ sĩ vũdrı̣́ ꞌwãâꞌwâ, nî-bê-yã fẽlé Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Gõꞌdá õjílã ndrê bê ꞌdó Yésũ nĩ trá Zãkáyõ drí ꞌbã ꞌálâ rî, gólĩyî ngâ trá ndrĩ ꞌdó úlı̣́ ngũrũ-ngũrũ bê kĩ nĩ rî, “ꞌÉꞌẽ, Yésũ nĩ íyíkâ rĩlí ãgô tã õnjí ꞌbá nã drí ꞌbã ꞌálâ ãꞌdô drí yã?” ");
INSERT INTO avu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zãkáyõ drí gõzó âdrélé Yésũ ágálé ãnyî, íyî ômbê kúkú âdĩlí tã âtázó kĩ nĩ rî, “Kúmú ámákâ, ní âyê mâ tã õnjí ámákâ tãsĩ. Má lẽ trá ngá ãmbá má drí ꞌbãzó ĩꞌdí bê lâ nõ lãfálâ cãlé rı̣̃, ãzâ ꞌbá yî fẽzó õjílã ĩzã ꞌbá ngá ãkó rî yî drí. Gõꞌdá má lẽ trá lãfâ tíbê õjílã kâ má drí rĩꞌá âdólâ nyãlé rî ꞌbá yí kâ rî lôgõlé vólé gólĩyî drí. Má lẽ gõꞌdá võ lâ fẽlé ândâlâ sû õjílã drí ãlô-ãlô.” ");
INSERT INTO avu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yésũ kĩ nĩ rî gólâ drí rî, “Kậyı̣̂ ãndrõ nô sĩ rî, Ôvârí âyê nî trá tã õnjí áníkâ tãsĩ. Sı̣́sı̣́ rî, ní âꞌdô trá gbõ bélé-bélé ûꞌdú ꞌbá ꞌî rî, ní îzã lãꞌbí trá, õjílã kĩ nĩ rî, ní âꞌdó Ãbãrãyámã rî ózõwá ꞌî kô. Tákõ ngbãângbânõ rî, nî pạ̃tı̣́-pạ̃tı̣̃ ró Ãbãrãyámã rî ózõwá ĩꞌdî, tãlâ ní âjâ drı̣̃ trá tã õnjí áníkâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Má drí ânĩrĩ Ôvârí ngá lésĩ rî tú rî, má ânĩ cé õjílã gólĩyî ậvı̣̃ ꞌbá trá lạ́tı̣̂ Ôvârí kâ ꞌásĩ tã õnjí drí rî pãlé.” ");
INSERT INTO avu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Gõꞌdá nĩngá sĩ, Yésũ îtónã trá íꞌdígówá ãzâ âtálé õjílã nĩ ꞌbá ĩyî âjílí Yẽrõsãlémã ꞌálâ rî drí, tãlâ õjílã ꞌdî ꞌbá yî ı̣̂sũ ĩyíkâ bê rî, tã Yésũ drí rĩꞌá âtálâ tã kũmũ Ôvârí kâ rî tãsĩ rî âꞌdô rû ꞌẽꞌá ãkpãkãꞌdã ĩyî lı̣̃fı̣́ drı̣̃ ꞌá, Yẽrõsãlémã ꞌá tólâ. ");
INSERT INTO avu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Gólâ kĩ nĩ rî, “Ãgô ãmbá ãzâ úzı̣̂ gólâ trá nĩlí ꞌbạ̃drı̣̃ ãzâ ꞌá jẽjẽ ró íyî ꞌbãlé kúmú ꞌbạ̃drı̣̃ íyíkâ kâ ró, gõꞌdá âgõlé yí drí ꞌbã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Drẽ ãkpã gólâ ngá drẽ nĩlí ꞌbã ꞌásĩ kô, gólâ ậzı̣̂ rû ı̣̂ꞌbũ ꞌbá íyíkâ trá mûdrı̣́ ânĩlí yí ngálâ, tã íyíkâ ꞌẽꞌá âtálâ gólĩyî drí rî ârílí. Drílâ lãfâ fẽzó gólĩyî drí cé tı̣̂tı̣̂ lãfâ párá nâ kâ. Gõꞌdá drílâ tã âtázó gólĩyî drí kĩ nĩ rî, ‘Nĩ ꞌê lôsĩ lãfâ ámákâ nõ drí mbãzó, ãꞌdô ró bê ãmbá má drí.’ Gõꞌdá gólâ drí ngãzó nĩlí ꞌbạ̃drı̣̃ jẽjẽ ró nã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Õjílã gólâ rî ífífí kâ rî gã ĩyî gólâ dó ꞌbãlé kúmú ró ĩyî drı̣̃ı̣̂, gólĩyî drí kpá tã âtízó jõlé ꞌbạ̃drı̣̃ jẽjẽ ró ꞌdĩ ꞌálâ kĩ nĩ rî, ‘Mã lẽé ãgô ꞌdĩ kô ꞌbãlé kúmú ró ãmâ drı̣̃ı̣̂.’ ");
INSERT INTO avu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Gõꞌdá nĩngá sĩ rî, óꞌbã gólâ trá kúmú ró, âgõ trá yí drí ꞌbã ꞌá. Gõꞌdá gólâ âgõ bê rî, ậzı̣̂ rû ı̣̂ꞌbũ ꞌbá íyíkâ ꞌdĩ ꞌbá yî trá ndrĩ ânĩlí yí ngálâ, gólâ lẽ trá lãfâ yí drí âyélé gólĩyî drı̣́gạ́ rî ndrẽlé, ãꞌdî kâ rî lậvũ nĩ kôrô yã? ");
INSERT INTO avu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ãlô rî drí ânĩzó gólâ ngálâ kĩ nĩ rî, ‘ꞌBã-lı̣́pı̣̂, má ꞌê lôsĩ trá lãfâ párá nâ kâ ꞌdĩ lôpê rû trá ândálé mûdrı̣́.’ ");
INSERT INTO avu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Gólĩyî lı̣́pı̣̂ ꞌdĩ kĩ nĩ rî ãgô ꞌdĩ drí rî, ‘Tã tãndí ꞌî, má âꞌdô ánî ꞌbãꞌá kpá kúmú ꞌbạ̃drı̣̃ mvá mûdrı̣́ rî kâ ró.’ ");
INSERT INTO avu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá rı̣̃ lâ rî drí ânĩzó gólâ ngálâ kĩ nĩ rî, ‘ꞌBã-lı̣́pı̣̂, má ꞌê lôsĩ trá lãfâ párá nâ kâ ꞌdĩ lôpê rû trá ândálé njı̣̂.’ ");
INSERT INTO avu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Gólĩyî lı̣́pı̣̂ ꞌdĩ kĩ nĩ rî ãgô ꞌdĩ drí rî, ‘Tã tãndí ꞌî, má âꞌdô ánî ꞌbãꞌá kpá kúmú ꞌbạ̃drı̣̃ njı̣̂ kâ ró.’ ");
INSERT INTO avu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Gõꞌdá ãzâ drí kpá ângázó kĩ nĩ rî, ‘ꞌBã-lı̣́pı̣̂, lãfâ áníkâ tíbê fẽlé má drı̣́gạ́ lãfâ párá nâ kâ rî rĩꞌá nõ, má âbí lôgõꞌá lâ ní drí, má lậpı̣̂ zãâ rĩꞌá kpậkậ ítá kâ ꞌá nõ. ");
INSERT INTO avu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ũrı̣̃ ꞌê mâ ꞌẽꞌẽ, tãlâ nî õjílã ạ̃wạ́lạ́kạ́ ꞌî. Ní rî ngá gólĩyî ꞌbã ꞌbá áníkâ ró kô rî trõlé ꞌdó ndrĩ ní drí, gõꞌdá ní rî kpá ngá gólĩyî õjílã kâ ı̣̂ꞌdı̣́lı̣́ kã ꞌbá âꞌdó ꞌbá áníkâ ró kô rî ŋõlé ndrĩ ní drí.’ ");
INSERT INTO avu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Gõꞌdá ãgô ꞌdĩ lı̣́pı̣̂ lâ kĩ nĩ rî, ‘Nî rĩꞌá rû ı̣̂ꞌbũ ꞌbá õnjí ꞌî. Tã ꞌdî âfõ nî rî gógó sı̣́lı̣́ sĩ kĩ nĩ rî, má ãꞌdô õjílã ạ̃wạ́lạ́kạ́ ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tãlâ ãꞌdô ꞌî ní drí lãfâ ꞌdĩ ꞌbãzó cú ĩtí lôsĩ ꞌẽzó ĩꞌdî sĩ lâ, drílâ tı̣̃zó nĩꞌá sı̣́sı̣́ ꞌálâ kô yã? Tã ní drí lãfâ ꞌdĩ lậpı̣́zó rĩlí cú ĩtí ꞌdĩ rî, má lẽ trõlâ vólé ní drı̣́gạ́ sĩ.’ ");
INSERT INTO avu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kúmú drí tã âtázó rû ı̣̂ꞌbũ ꞌbá ãzâ ꞌbá yî drí kĩ nĩ rî, ‘Ní trõ lãfâ ꞌdĩ vólé drı̣́gạ́ lâ sĩ, fẽlé ãgô gólâ íyíkâ ꞌbã ꞌbá tı̣̃lı̣́ ândâlâ mûdrı̣́ rî drí.’ ");
INSERT INTO avu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Gõꞌdá rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî kĩ nĩ rî, ‘Gõꞌdá ãgô ãzâ nã kpá rĩꞌá lãfâ dũû bê rî, âꞌdô nõô rî fẽꞌá kpá gólâ drí yã?’ ");
INSERT INTO avu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Gõꞌdá lãfâ lı̣́pı̣̂ kĩ nĩ rî, ‘Má âtâ drẽ tã ãzâ ãnî drí, õjílã gólĩyî má drí ı̣̂njı̣̃lı̣́ rî, má âꞌdô ngá fẽꞌá drílĩyî gạ̃rạ̃. Gõꞌdá gólĩyî tíbê má drí ı̣̂njı̣̃lı̣́ kô rî, má âꞌdô ngá gólĩyíkâ rî trõꞌá vólé drı̣́gạ́ lâ ĩyî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ngbãângbânõ má lẽ nĩ âjî ámâ ạ̃jú-ꞌbá-ãzíyã yî gólĩyî tíbê ámâ lẽ ꞌbá kô ꞌbãlé kúmú ró ĩyî drı̣̃ı̣̂ rî fũlı̣́ ngbãângbânõ ámâ lı̣̃fı̣́ drı̣̃ ꞌá nõngá.’ ” ");
INSERT INTO avu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Gõꞌdá nĩngá sĩ rî, Yésũ drẽ zãâ rĩꞌá nĩꞌá Yẽrõsãlémã ꞌálâ. Tã ârí ꞌbá gólâkâ ꞌdĩ ꞌbá yî ꞌdê trá zãâ gólâ vó. ");
INSERT INTO avu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Gólĩyî ânĩ trá âcálé ãnyî ꞌbạ̃drı̣̃ mvá zı̣̃lı̣́ Bẽtẽfágẽ rî ꞌá. Bẽtẽfágẽ ꞌdĩ rĩꞌá ãnyî Bẽtánĩ lạ̃gạ́tı̣́. Yésũ yî câ trá únı̣́ gólâ fê dõ kâ zı̣̃lı̣́ õlívĩ rî bê yí drı̣̃ı̣̂ rî drı̣̃ ꞌálâ, gõꞌdá drílâ tã ârí ꞌbá ãzâ ꞌbá yî jõzó rı̣̃ sı̣́sı̣́, nĩꞌá fĩlí ꞌbạ̃drı̣̃ mvá Bẽtẽfágẽ kâ ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Gólâ kĩ nĩ rî, “Nĩ nĩ, nĩ fî Bẽtẽfágẽ ꞌálâ. Õzõ nĩ õcâ trá rî, nĩ âꞌdô dõngí mvá ûsúꞌá óꞌĩ trá ꞌĩꞌĩ tólâ. Dõngí ꞌdĩ kó õjílã ãzâ mbãá drẽ drı̣̃ lâ kô. Nĩ âtĩ dõngí ꞌdĩ, nĩ âsê ró âjílí má drí nõlé. ");
INSERT INTO avu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Õzõ õjílã ãzâ ĩîjî ãnî trá kĩꞌá nĩ rî, nĩ rî dõngí ꞌdĩ âtĩlí nĩzó ĩꞌdí bê lâ ãꞌdî drí yã rî, nĩ âtâ drílâ nõtí kĩ nĩ rî, ‘Kúmú ãmákâ lẽ nĩ, gólâ âꞌdô lôgõꞌá lâ ꞌwãâ vólé.’ ” ");
INSERT INTO avu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tã ârí ꞌbá rı̣̃ ꞌdî ꞌbá yî nĩ ĩyî trá, ꞌê ĩyî tã ꞌdî trá, té õzõ Yésũ drí âtálé gólĩyî drí rî tí. Nĩ ĩyî ûsû ĩyî dõngí óꞌdíwá ꞌdĩ trá, ");
INSERT INTO avu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ꞌdê ĩyî trá rĩꞌá âtĩlâ. Gõꞌdá dõngí ꞌdĩ lı̣́pı̣̂ lâ îjî gólĩyî trá kĩ nĩ rî, “Háyĩ, nĩ rî dõngí ꞌdĩ âtĩlí ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tã ârí ꞌbá rı̣̃ nô ꞌbá yî lôgõ ĩyî tã trá kĩ nĩ rî, “Kúmú rî lẽlâ nĩ.” ");
INSERT INTO avu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tã ârí ꞌbá rı̣̃ ꞌdî ꞌbá yî drí dõngí ꞌdĩ âtĩzó âjílí Yésũ drí. Õjílã rĩꞌá dũû ânĩ ꞌbá Yésũ rî âjílí rî, ãzâ ꞌbá yî drí ítá dãzó dõngí ꞌdĩ ũgúlı̣́, ãꞌdô ró bê Yésũ drí rĩzó drı̣̃ lâ mı̣̃ ꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gõꞌdá drílĩyî Yésũ rî îngázó ꞌbãlé dõngí ũgúlı̣́. Gõꞌdá ãzâ ꞌbá yî ꞌdê ĩyíkâ sı̣́sı̣́ zãâ, nĩꞌá ítá ꞌbẽ bê vũdrı̣́ sĩ lạ́tı̣̂ ꞌásĩ, Yésũ drí nĩzó dõngí bê drı̣̃ lâ sĩ. Õjílã ꞌdî ꞌbá yî ꞌê ĩyî tã ꞌdî ĩtí ꞌdĩ, tãlâ gólĩyî lẽ ĩyíkâ trá Yésũ trá ĩꞌdî kúmú ạ́ngı̣́ ĩyíkâ ró. ");
INSERT INTO avu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Gõꞌdá nĩngá sĩ rî, Yésũ drí ngãzó âlólé únı̣́ gólâ fê dõ kâ bê yí drı̣̃ı̣̂ ꞌdĩ pálé lâ ꞌálâ. Õꞌbí ãmbá drí nĩzó gólâ rî âjílí. Drílĩyî rĩzó Ôvârí rî lûyı̣́lı̣́ gbórókõ ãmbá sĩ. Gólĩyî ꞌê ĩyî ãwô-ĩtí trá Ôvârí drí, tãlâ Yésũ ꞌê tã lârâkô ãzâ ꞌbá yî õyĩ ró rî trá dũû gólĩyî lı̣̃fı̣́ drı̣̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Gólĩyî kĩ nĩ rî, Ôvârí ãâfẽ õrẽ kúmú ạ́ngı̣́ drílâ âjólé ĩyî drí nõ drí. Gólĩyî kĩ nĩ rî, ngbãângbânõ, tã ạ̃ꞌdı̣́ âcâ trá ĩyî lãfálé Ôvârí ngá lésĩ, yĩ ı̣̃ı̣̂njı̣̃ Ôvârí gólâ rĩ ꞌbá mbârâkã bê gạ̃rạ̃ ûrú ꞌálâ rî. ");
INSERT INTO avu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Gõꞌdá Pạ̃rúsı̣̃ yî ârî ĩyî tã ꞌdî bê ĩtí rî, gólĩyî âtâ ĩyî tã trá Yésũ drí kĩ nĩ rî, gólâ ãâtâ tã õjílã ꞌdî ꞌbá yî drí kĩ, gólĩyî ãâtâ tã ꞌdî ꞌbá yî kô, gólĩyî õrî tı̣́tı̣́, gólĩyî õrî tã ãzâ âtálé Yésũ rî rú sĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yésũ drí tã âtázó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Îcá kô gólĩyî drí rĩzó tı̣́tı̣́. Õzõ gólĩyî ũlûyı̣̂ Ôvârí kô ámâ tãsĩ rî, kúnı̣́ mvá gólĩyî lạ́tı̣̂ ꞌá nõ ꞌbá yî âꞌdô Ôvârí rî lûyı̣́ꞌá trá.” ");
INSERT INTO avu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Gõꞌdá nĩngá sĩ rî, Yésũ drí Yẽrõsãlémã rî ndrẽzó sı̣́sı̣́ yî ágálé ĩtí, gólâ drí îtónãzó ãwó ngõlé ı̣̃lı̣́ndrı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Drílâ tã âtázó kĩ nĩ rî, “Óõ ãnî õjílã Yẽrõsãlémã lé ꞌbá nõ rî trá ândrâ-tãndĩ ꞌî ạ̃dũkũ ãníkâ ꞌẽzó ãnî pãlé rî ĩꞌdî nõ. Õmbã Ôvârí kâ sı̣́ lâ drí ậꞌdı̣́zó ãnî rú rî ĩꞌdî. Gõꞌdá nĩ nı̣̃ı̣́ gõꞌdá kô, nĩ ndré kpá kô. ");
INSERT INTO avu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Ngbãângbânõ rî, ãnî ạ̃jú-ꞌbá-ãzí yî âꞌdô ꞌdẽꞌá ãnî drı̣̃ı̣̂ võ ꞌásĩ ndrĩ. Gólĩyî âꞌdô rû êꞌbéꞌá ndrĩ gbãâ jạ̃rı̣́bạ̃ ãníkâ rú sĩ. Gólĩyî âꞌdô ngá ꞌbáráŋã ró rî ꞌdı̣̃ꞌá, kpá bẽzó lâ únı̣́ sĩ jạ̃rı̣́bạ̃ ãníkâ rú sĩ, nĩ õzó ꞌbẽê rãlé kô. Gólĩyî âꞌdô ãnî ûfúꞌá ngbá ndẽlé vólé. Drílĩyî jạ̃rı̣́bạ̃ ãníkâ ꞌdĩ îzãzó ngbángbá. Tãlâ nĩ gâ vólé dó tã lẽlé kĩꞌá nĩ rî, Ôvârí âcâ trá ĩyî pãlé.” ");
INSERT INTO avu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Yésũ drí fĩzó jạ̃rı̣́bạ̃ ꞌálâ zãâ lậvũlı̣́ jó ạ́ngı̣́ Ôvârí kâ rî ꞌálâ, gólâ õtírĩ âcá ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌálâ rî, gólâ ûsû õjílã ãzâ ꞌbá yî trá rĩꞌá ĩyî ngá gólâ rĩꞌá fẽlâ zãlé ngá fẽfẽ ró rî gĩꞌá ãkpã jó ꞌá. Yésũ drí tã âtázó gólĩyî drí õmbã sĩ kĩ nĩ rî, “Ôvârí âtâ trá tã ậngũ ꞌbá Ĩsáyã sı̣́lı̣́ kĩ nĩ rî, ‘Jó ámákâ rî íyíkâ cé rãtáã ꞌẽzó ĩꞌdî ꞌá lâ má drí ámâ lûyı̣̂-lûyı̣̂ bê.’ Ĩsáyã 56.7 Nĩ ârî drẽ, jó Ôvârí kâ âꞌdó kô ngá ãzâ ꞌẽzó ꞌá lâ. Gõꞌdá nõô rî, nĩ jâ trá rĩzó ngá ãníkâ gĩlí ꞌá lâ, rĩꞌá lãfâ lâ nyãlé. Ãnî trá õzõ ũgú kâtí.” Gõꞌdá Yésũ lâdrô õjílã ꞌdî ꞌbá yî trá õmbã sĩ. ");
INSERT INTO avu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gõꞌdá nĩngá sĩ rî, Yésũ rî trá lậmúlı̣́ kậyı̣̂ vósĩ cé, jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌá, rĩlí tã tãndí Ôvârí kâ âtálé õjílã gólĩyî rĩ ꞌbá rû êꞌbélé jó ạ́ngı̣́ Ôvârí kâ rî ꞌá rî yí drí. Drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî, lãꞌbí îmbá ꞌbá yî gõꞌdá kpá gólĩyî sı̣́sı̣́-lésĩ ró rî ꞌbá yí bê, lẽ ĩyî trá Yésũ rî fũlı̣́ rî. ");
INSERT INTO avu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Îcá ĩyî kô, tãlâ õjílã ãmbá ꞌdó rĩꞌá tólâ úlı̣́ Yésũ drí rĩꞌá lôyálâ ꞌdĩ âríꞌá. Õꞌbí ãmbá ĩtí ꞌdĩ ꞌbá yî lẽ ꞌdó úlı̣́ Yésũ kâ ârílí ĩyî bı̣́-ꞌbálé sĩ. ");
INSERT INTO avu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kậyı̣̂ ãzâ sĩ, Yésũ õtírĩ rĩî tã pẽlé jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ꞌá rî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá lãꞌbí îmbá ꞌbá yí bê, rî ĩyî trá Yésũ rî îjílí tã îjî-îjî sĩ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ãꞌdî ꞌbã nî rĩꞌá tã pẽlé jó Ôvârí kâ nõ ꞌá rî nĩ yã? Ãꞌdî fẽ drı̣́-ãcê ní drí tã ꞌdî ꞌbá yî ꞌẽzó rî nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yésũ lôgõ tã-drı̣̃ trá gólĩyî drí nõtí, “Má lẽ trá ãnî îjílí tã îjî-îjî sĩ nõtí, ");
INSERT INTO avu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ãꞌdî ꞌbã Yõwánĩ rĩꞌá bãbãtízĩ ꞌẽlé õjílã drí rî nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gõꞌdá drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî îcá ĩyî úlı̣́ Yésũ kâ ꞌdĩ võ lâ lôgõlé kô. Gólĩyî ı̣̂sũ tã trá kĩ nĩ rî, õzõ yĩ ãâtâ gólâ drí kĩꞌá nĩ rî, Ôvârí ĩꞌdî rî, Yésũ âꞌdô lôgõꞌá lâ ĩyî drí kĩ nĩ rî, ngã ãꞌdô kpá ĩtí rî, gólĩyî ró úlı̣́ Yõwánĩ kâ kô ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Õzõ gõꞌdá yĩ ãâtâ kpá âꞌdó Ôvârí ĩꞌdî kô rî, õꞌbí ãmbá rĩ ꞌbá ĩtí ꞌdĩ ꞌbá yî âꞌdô ꞌdẽꞌá kpá ĩyî drı̣̃ı̣̂ ĩyî fũlı̣́, tãlâ gólĩyî lẽ ĩyî tã-drı̣̃ trá kĩ nĩ rî, Yõwánĩ ĩꞌdî tã ậngũ ꞌbá Ôvârí kâ. ");
INSERT INTO avu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gõꞌdá âꞌdô bê ĩtí rî, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî gã ĩyî trá dó tã-drı̣̃ lôgõlé, gólĩyî drí tã âtázó Yésũ drí kĩ nĩ rî, yĩ nı̣̃ı̣́ kô. ");
INSERT INTO avu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Gõꞌdá Yésũ âtâ trá gólĩyî drí kĩ nĩ rî, “Õzõ ãꞌdô ĩtí rî, má lẽé kpá kô âꞌdálâ ãnî drí kĩ, ãꞌdî ꞌbã mâ nĩ tã pẽlé yã rî.” ");
INSERT INTO avu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yésũ âtâ íꞌdígówá trá drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ãgô ãzâ ꞌwã ạ́mvú íyíkâ trá, gólâ drí fê õzõ âlâꞌbâ kâtí gólâ rĩzó õdrá ꞌẽlé lõꞌwâ lâ ꞌásĩ rî ı̣̂ꞌdı̣́zó ꞌá lâ. Ạ́mvú lı̣́pı̣̂ ꞌdĩ drí gõzó ạ́mvú ꞌwã ꞌbá ãzâ ꞌbá yî ꞌbãlé rĩꞌá lôsĩ ꞌẽlé ạ́mvú íyíkâ ꞌdĩ ꞌá, tãlâ gólâ ꞌẽꞌá nĩlí rĩlí ꞌbạ̃drı̣̃ ãzâ ꞌá jẽjẽ ró ạ́mvú íyíkâ ꞌdĩ rú sĩ. Drílâ gõzó tã âtálé ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, ‘Õzõ fê ạ́mvú ꞌá ꞌdĩ õꞌwâ trá rî, nĩ trõ lõꞌwâ lâ ũrûkậ ꞌbá yî ãnî drí, nĩ gõ ró ạ̃mbúkũ lâ âfẽlé má lı̣́pı̣̂ lâ drí.’ ");
INSERT INTO avu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gõꞌdá fê lõꞌwâ ꞌdĩ kâ trá ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí ôkízó lâ. Ạ́mvú lı̣́pı̣̂ drí gõzó lãjóꞌbá íyíkâ âjólé ânĩꞌá fê lõꞌwâ íyíkâ ró rî trõlé. Ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí lãjóꞌbá ạ́mvú lı̣́pı̣̂ kâ ꞌdĩ rũzó cãlé drõlé vólé, drílĩyî gãzó dó fê lõꞌwâ ꞌdĩ fẽlé ạ́mvú lı̣́pı̣̂ ꞌdĩ drí. ");
INSERT INTO avu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ạ́mvú lı̣́pı̣̂ ꞌdĩ drí kpá lãjóꞌbá ãzâ âjózó. Ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî drí rũzó lâ kpá cãlé. Gólĩyî ꞌê tã ãnyĩ kâ trá ãmbá lãjóꞌbá ꞌdĩ drí, gõꞌdá kpá gólâ rî lôꞌdázó drõlé gõlé vólé. Lôgâ ĩyî fê lõꞌwâ ꞌdĩ kpá dó fẽlé. ");
INSERT INTO avu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ạ́mvú lı̣́pı̣̂ ꞌdĩ drí gõzó lãjóꞌbá nâ lâ jõlé, drílĩyî kpá cãzó lâ, lôꞌézó lâ rõô. Fẽé ĩyî fê lõꞌwâ ꞌdĩ ạ́mvú lı̣́pı̣̂ drí kpá kô. ");
INSERT INTO avu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ạ́mvú lı̣́pı̣̂ ꞌdĩ drí tã ı̣̂sũzó kĩ nĩ rî, ‘Má âꞌdô ꞌẽꞌá lâ nõ ángô tí ró yã? Má lẽ gõꞌdá trá drẽ ámâ mvá má drí lẽlé kôrô rî jõlé ĩꞌdî. Ãzângá sĩ, gólĩyî âꞌdô gólâ rî rõꞌá, drílĩyî ngá ámákâ ꞌdĩ âfẽzó.’ Gõꞌdá mvá ꞌdĩ drí nĩzó ạ́mvú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Gõꞌdá ạ́mvú ꞌwã ꞌbá ꞌdĩ ꞌbá yî õtírĩ ạ́mvú lı̣́pı̣̂ ꞌdĩ mvá lâ rî ndrẽê rî, âtâ ĩyî tã trá ĩyî lãfálé ꞌásĩ kĩ nĩ rî, ‘Nõô rî ạ́mvú lı̣́pı̣̂ rî mvá ĩꞌdî, mã rû gólâ fũlı̣́ vólé, tãlâ ạ́mvú nõ õrî ró bê ãmângá ãmâ drí.’ ");
INSERT INTO avu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gólĩyî lôkô ạ́mvú lı̣́pı̣̂ rî mvá trá, sẽlâ vólé ạ́mvú ꞌásĩ gõꞌdá nĩꞌá fũlı̣́ vólé.” Gõꞌdá íꞌdígówá ꞌdĩ vósĩ rî, Yésũ îjî tã trá drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî tı̣́ kĩ nĩ rî, “Gõꞌdá ạ́mvú lı̣́pı̣̂ ꞌdĩ âꞌdô ꞌẽꞌá lâ ángô tí ró yã? ");
INSERT INTO avu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tã pạ̃tı̣́ı̣̃ ró, ạ́mvú lı̣́pı̣̂ âꞌdô ânĩꞌá ạ́mvú ꞌwã ꞌbá õnjí ꞌdĩ ꞌbá yî ûfúlı̣́, drílâ gõzó ạ́mvú ꞌwã ꞌbá ãzâ ꞌbá yî ꞌbãlé ĩꞌdî ạ́mvú ꞌdĩ ꞌá.” Gõꞌdá õꞌbí ãmbá rĩ ꞌbá ĩtí ꞌdĩ ꞌbá yî drí tã âtázó kĩ nĩ rî, “Tã ĩtí ꞌdĩ ꞌbá yî îcá rû ꞌẽlé kô.” ");
INSERT INTO avu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yésũ âꞌdâ õjílã ꞌdî ꞌbá yî lı̣̃fı̣́ lâ trá drı̣́-mbílí sĩ kĩ nĩ rî, “Nĩ nı̣̃ úlı̣́ tã ậngũ ꞌbá Ôvârí kâ drí âtálé kĩꞌá nĩ rî, ‘Ậjû nyãányâ gólâ jó ꞌdı̣̃ ꞌbá yî drí gãlé dó rî, âꞌdô gõꞌdá trá ậjû tã lâ drí lâzélé rõô jó kâ ró rî ĩꞌdî. Tã ꞌdî rĩꞌá Ôvârí drı̣́gạ́ sĩ, gõꞌdá gólâ rî nyãányâ ꞌê nĩ. Ãmâ tı̣̂ ậꞌdı̣̂ trá tã ꞌdî drí sĩ.’ ");
INSERT INTO avu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ĩtí rî, õzõ õjílã ãzâ ũsı̣̃ íyî pá trá jó ậjû ꞌdĩ rú rî, gólâ rî pá âꞌdô ŋõꞌá. Gõꞌdá õzõ jó ậjû ꞌdĩ ãâꞌdê õjílã rî ꞌdĩ drı̣̃ı̣̂ rî, âꞌdô gólâ rî ôŋõꞌá cĩnyí-cĩnyí.” ");
INSERT INTO avu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gõꞌdá nĩngá sĩ, drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî lẽ ĩyî trá Yésũ rî trõlé nĩꞌá fũlâ, tãlâ gólĩyî nı̣̃ trá Yésũ rî íꞌdígówá âtálé ꞌdĩ ĩyî rú. Nĩngá sĩ rî, gólĩyî îcá ꞌẽlâ kô, tãlâ gólĩyî rô õꞌbí ãmbá ꞌdĩ ꞌbá yî ạ̃wạ̃lạ̃kạ̃ lâ yî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî rî ĩyî trá Yésũ rî âdólé, úlı̣́ õnjí ãzâ ãâfõ ró bê gólâ sı̣́lı̣́ sĩ, yĩ ũrû ró gólâ bê. Jô ĩyî tã ngõ ꞌbá yî trá nĩlí Yésũ rî tı̣̂ lôtẽlé, ãâtâ ró úlı̣́ ãzâ bê ányâ ró, gólĩyî ãânĩ ró bê tã lâ ngõlé ĩyî drí. Gólĩyî drí kpá tã âtázó tã ngõ ꞌbá ꞌdĩ ꞌbá yî drí, gólĩyî õjâ ĩyî kpá ꞌbãlé õjílã tãndí ró tã îjî-îjî ãzâ ꞌbá yî îjílí Yésũ tı̣́, pávó lôndãzó gólâ rî rũzó, drı̣̃ lâ ãâꞌdê ró bê, gólĩyî ãâꞌdô kpá ícícíyá ꞌẽ ꞌbá ró Yésũ rú. ");
INSERT INTO avu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Õjílã gólĩyî tã ngõ ꞌbá ꞌdĩ yî îjî ĩyî Yésũ trá kĩ nĩ rî, “Lı̣̃fı̣́ îcí ꞌbá, ní âtâ úlı̣́ tãndí trá, gõꞌdá ní îcî õjílã lı̣̃fı̣́ trá tã pạ̃tı̣́-pạ̃tı̣̃ Ôvârí kâ rî sĩ, õzõ õjílã ãmbá ꞌdĩ ꞌbá yî ãꞌdô ĩyî gbõ lé õmbã ró ní bê rî. ");
INSERT INTO avu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mã lẽ ní âtâ ãmâ drí tã mbı̣̂ ró, mã õgî ômbê ngá ãtrâ Rómã kâ drí ngã kô yã?” ");
INSERT INTO avu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yésũ nı̣̃ trá gólĩyî rî ꞌdĩ kõlõgbõ cãꞌá yí drí ꞌdẽzó, tãlâ yĩ ũrû ró yî bê. Gólâ drí gõzó tã âtálé gólĩyî drí nõtí, ");
INSERT INTO avu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nĩ âfẽ drẽ lãfâ ãnî drí rĩzó ômbê gĩlí ĩꞌdî sĩ lâ ꞌdĩ ãlô rî má drí, tãlâ má ndrê ró bê. Nõô ãꞌdî rî líndrí ꞌî ậdı̣̂ ífí nõ rú, gõꞌdá rú îgĩlí rú lâ ꞌá nõ bê yã?” ");
INSERT INTO avu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tã ngõ ꞌbá ꞌdĩ ꞌbá yî drí tã âtázó Yésũ drí kĩ nĩ rî, “Nõô rî kúmú Rómã kâ ꞌbãlé ãmâ drı̣̃ı̣̂ nõ líndrí lâ ĩꞌdî.” Gõꞌdá Yésũ âtâ trá gólĩyî drí nõtí, “Õzõ ãꞌdô ĩtí rî, gólâ ĩꞌdî lãfâ ꞌdĩ lı̣́pı̣̂ lâ ꞌî, nĩ lôgõ lãfâ ꞌdĩ vólé gólâ drí ômbê gĩgĩ sĩ. Gõꞌdá ãnî rî gógó ífífí lâ ãnî lı̣́pı̣̂ rĩꞌá Ôvârí ĩꞌdî, nĩ fẽ ãnî nyãányâ gólâ drí tã gólâ drí lẽlé ãnî drí ꞌẽlé rî ꞌẽzó.” ");
INSERT INTO avu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nĩngá sĩ rî, tã ngõ ꞌbá ꞌdĩ ꞌbá yî trá ꞌdó lârõ-lârõ ró, tãlâ Yésũ lôgõ tã îjî-îjî gólĩyíkâ ꞌdĩ trá tã nı̣̃nı̣̃ sĩ. Gólĩyî îcá ĩyî úlı̣́ ãzâ âtálé Yésũ rî drı̣̃ rũzó rî kô. Gólĩyî gõꞌdá trá úlı̣́ ãzâ ãkó âtálé. ");
INSERT INTO avu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Gõꞌdá Sạ̃dúsı̣̃ ãzâ ꞌbá yî âcâ ĩyî trá Yésũ rî ûjũlı̣́. Gólĩyî rî ĩyíkâ õjílã lı̣̃fı̣́ îcílí kĩ nĩ rî, Ôvârí îcá kô õjílã îngálé õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Gólĩyî âtâ trá Yésũ drí nõtí, “Lı̣̃fı̣́ îcí ꞌbá, ãmâ ạ́ꞌbı̣́yạ́ Músạ̃ îgĩ tã trá ãmâ drí kĩ nĩ rî, ‘Õzõ ãgô ãzâ õdrã cú ĩtí mvá tı̣̃ ãkó rî, gólâ rî ậdrúpı̣̃ yî âꞌdô gólâ rî õkó ꞌdĩ trõꞌá mvá tı̣̃zó gólâ drí.’ ");
INSERT INTO avu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ngbãângbânõ rî, mã âtâ drẽ íꞌdígówá ãzâ ní drí. Ãgô ãzâ rĩꞌá mvá bê njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdó ĩyî ágó ró. Gõꞌdá mvá sı̣́sı̣́ rî drí õkó gĩzó, drílâ drãzó õkó ꞌdĩ âyélé tı̣́ ĩyî mvá õkó ꞌdĩ bê kô. ");
INSERT INTO avu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ậdrúpı̣̃ lâ ãzâ drí trõzó lâ ạ̃yı̣́zı̣́ ró, tı̣́ ĩyî mvá kpá kô, drílâ kpá drãzó. ");
INSERT INTO avu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ậdrúpı̣̃ ãzâ drí kpá ạ̃yı̣́zı̣́ ꞌdĩ trõzó, tı̣́ mvá kpá kô, drílâ kpá drãzó. Ậdrúpı̣̃ ãzâ drí kpá ạ̃yı̣́zı̣́ ꞌdĩ trõzó, tı̣́ mvá kpá kô, drílâ kpá drãzó, ndrĩ gbõ ꞌdó ĩtí té ạ̃dũkũ lâ mvá ạ̃dũ ró rî, drílâ ạ̃yı̣́zı̣́ ꞌdĩ trõzó nĩ, tı̣́ ĩyî mvá kpá kô. Mvá ạ̃dũ ꞌdî drí kpá drãzó. ");
INSERT INTO avu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Õkó ꞌdĩ drí kpá drãzó. Gõꞌdá ní âtâ drẽ tã lâ ãmâ drí. ");
INSERT INTO avu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ị̃zạ́tú ãngó nõ ꞌá rî, õzõ Ôvârí ĩîngâ õjílã ôdrã ꞌbá rî yî trá lédrẽ-lédrẽ ró rî, ậdrúpı̣̃ gólĩyî njı̣̂-drı̣̃-lâ-rı̣̃ ꞌdó õkó ꞌdĩ trõ ꞌbá ndrĩ ꞌdî ꞌbá yî ꞌásĩ rî, õkó ꞌdĩ âꞌdô ꞌbãꞌá ángô rî õkó lâ ró yã?” Gólĩyî âtâ tã ꞌdî ĩtí ꞌdĩ, tãlâ Yésũ rî rúꞌbạ́ ônjâ ró bê tã ányâ lôgõlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yésũ drí tã âtázó Sạ̃dúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Ãngó ꞌá nõngá rî, ãgô rî õkó gĩlí. ");
INSERT INTO avu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Gõꞌdá võ Ôvârí ngálâ ûrú ꞌálâ rî ꞌá rî, âꞌdó kô õkó gĩzó ĩꞌdî ꞌbãzó ãyĩkõ ró, õjílã tı̣́ mvá kô, ");
INSERT INTO avu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","gõꞌdá õjílã drãá kpá kô. Õjílã âꞌdô ꞌbãꞌá ꞌdó ndrĩ õzõ mãlãyíkã kâtí, drãá ĩyî gõꞌdá kô. Gólĩyî âꞌdô ꞌbãꞌá Ôvârí rî mvá ró, tãlâ Ôvârí îngâ gólĩyî trá õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ãnî Sạ̃dúsı̣̃ yî, tã ı̣̂sũ ãníkâ âꞌdó kô mbı̣̂. Ãmâ ạ́ꞌbı̣́yạ́ Músạ̃ îgĩ tã trá âyélé ãmâ drí, kậyı̣̂ tíbê Ôvârí drí úlı̣́ âtázó yí drí fê ngbũkpũ-ngbũkpũ rĩ ꞌbá kõlé lạ̃sı̣́ ró ĩtí ꞌdĩ ꞌásĩ kĩ nĩ rî, ‘Mâ cé ĩꞌdî Ôvârí tíbê Ãbãrãyámã drí rĩꞌá rõlâ rî, mâ kpá ĩꞌdî Ôvârí tíbê Ĩsákã drí rĩꞌá rõlâ rî ĩꞌdî, kpá Ôvârí Yãkóbã drí rõlé rî ĩꞌdî.’ Ôvârí õtírĩ tã âtá Músạ̃ drí rî, Ãbãrãyámã, Ĩsákã gõꞌdá Yãkóbã yî drã ĩyî trá. ");
INSERT INTO avu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Îcá gõꞌdá kô ãvõ drí Ôvârí rî rõzó, gõꞌdá ngbãângbânõ rî, Ãbãrãyámã, Ĩsákã, Yãkóbã gõꞌdá trá lédrẽ-lédrẽ ró Ôvârí ngálâ.” ");
INSERT INTO avu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lãꞌbí îmbá ꞌbá ãzâ ꞌbá yî drí tã âtázó Yésũ drí kĩ nĩ rî, “Yésũ, ní lôgõ tã-drı̣̃ Sạ̃dúsı̣̃ ꞌdĩ ꞌbá yí kâ trá tãndí ró.” Gólĩyî âtâ tã ꞌdî ĩtí ꞌdĩ, tãlâ gólĩyî lẽé ĩyî Sạ̃dúsı̣̃ yî kô. ");
INSERT INTO avu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gõꞌdá nĩngá sĩ, lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî õjílã gólĩyî sı̣́sı̣́-lésĩ rî yí bê rô ĩyî Yésũ trá, îjí ĩyî gõꞌdá gólâ óꞌdí kô, tãlâ gólĩyî îcá gõꞌdá tã ãzâ ı̣̂sũlı̣́ Yésũ rî drı̣̃ rũzó ꞌá lâ kô. Tã lôgõ-lôgõ Yésũ kâ rî lậvũ gólĩyî trá tã nı̣̃nı̣̃ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Gõꞌdá Yésũ kĩ drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí rî, “Nĩ ı̣̂sũ drẽ tã mãnísĩ tã ꞌdíyî pã ꞌbá kâ tãsĩ. Íîgĩ trá búkũ Ôvârí kâ ꞌá kĩꞌá nĩ rî, ꞌdíyî pã ꞌbá gólâ Ôvârí drí ꞌẽꞌá âjólâ nõ rĩꞌá kúmú Dạ̃wúdı̣̃ rî ózõwá ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Gõꞌdá má kĩ, kúmú Dạ̃wúdı̣̃ rî gógó âtâ trá lôngó ãzâ ꞌá nĩngá kĩ nĩ rî, ꞌdíyî pã ꞌbá gólâ Ôvârí drí ꞌẽꞌá âjólâ nõ ãâꞌdô ꞌbãꞌá kúmú íyíkâ ró. Dạ̃wúdı̣̃ âtâ trá nõtí, ‘Ôvârí âtâ tã trá Kúmú ámákâ drí, gólâ õrî yí bê võ ãlô ꞌá cú drı̣́-ãcê bê ãngó nõ rũlı̣́ yí bê. ");
INSERT INTO avu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Gõꞌdá yí âꞌdô gólâ rî ạ̃jú-ꞌbá-ãzí yî ꞌbãꞌá âꞌdólé áyábálá ró gólâ rî pá zẽlé.’ ” ");
INSERT INTO avu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gõꞌdá Yésũ âtâ tã trá drı̣̃-ꞌbá Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí úlı̣́ mãnĩgõ sĩ kĩ nĩ rî, “Âꞌdô âꞌdóꞌá ángô tí ró, ꞌdíyî pã ꞌbá gólâ Ôvârí drí ꞌẽꞌá âjólâ rî drí ꞌbãzó kúmú ró Dạ̃wúdı̣̃ drı̣̃ı̣̂, gõꞌdá kpá âꞌdólé Dạ̃wúdı̣̃ rî ózõwá ró yã?” Yésũ âtâ tã ꞌdî ĩtí, tãlâ gólâ lẽ gólĩyî drí nı̣̃lâ dódó, ꞌdíyî pã ꞌbá ꞌdĩ rî âꞌdô ꞌbãꞌá õjílã mvá ró, kpá õzõ Ôvârí rî ífífí tí. ");
INSERT INTO avu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Gõꞌdá nĩngá sĩ, Yésũ âtâ tã trá tã ârí ꞌbá íyíkâ rî drí, gõꞌdá õꞌbí ãmbá ꞌdĩ ꞌbá yî ârî ĩyî gólâ kpá trá, tã âtâ rĩꞌá nõtí, ");
INSERT INTO avu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nĩ ꞌbã ãnî drı̣̃ı̣̂, ạ̃dũkũ lâ ró, nĩ õzó ꞌbãâ kô õzõ lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yî tí. Lãꞌbí îmbá ꞌbá rî ꞌbá yî gólĩyî rî ĩyíkâ ítá ãcê-ãcê sõlé ĩꞌdî kạ́trạ́-kạ́trạ́ vũdrı̣́ sĩ, ĩyî âꞌdázó bê lı̣̃fı̣́ îcí ꞌbá ró. Gõꞌdá kpá rĩzó ậcı̣́ tõlé lómbé-lómbéwá sĩ gõcẽ-gõcẽ võ ngá gĩ kâ ꞌásĩ, õjílã õrî ró bê nî-bê-yã fẽlé ĩyî drí tã rõrõ sĩ. Gõꞌdá gólĩyî nĩ bê rãtáã ꞌẽlé jó tã ârî kâ ꞌálâ rî, gólĩyî drí té kı̣́tı̣̃ ạ́ngı̣́ ạ́ngı̣́ sı̣́sı̣́ ꞌálâ rî ꞌbá yî zĩzó ĩꞌdî rĩzó drı̣̃ lâ. Õzõ gólĩyî õcâ trá võ kãrámã kâ ꞌá rî, gólĩyî drí ĩyíkâ rĩzó zãâ ĩyî ífífí ꞌbãlé âꞌdólé sı̣́sı̣́ rĩlí kı̣́tı̣̃ ạ́ngı̣́ ạ́ngı̣́ drı̣̃ı̣̂, kı̣́tı̣̃ gólĩyî kó ꞌbãlé cé ũmú gólĩyî ãmbâ-ãmbâ drí rî yî drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gõꞌdá óꞌbã gólĩyî bê rĩꞌá ngá ꞌẽlé õkó gólĩyî ágó lâ yî drí ôdrãlé rî vó lâ yî ndrẽlé rî, gólĩyî rî ĩyîngá cé lãfâ õkó ꞌdĩ ꞌbá yí kâ ꞌdĩ îzãlé ĩꞌdî. Gõꞌdá gólĩyî rî trá rĩꞌá rãtáã ꞌẽlé kárá Ôvârí drí, gbórókõ ãmbá sĩ ngbạ́lạ́-ngbạ́lạ́, õjílã ãzí lı̣̃fı̣́ drı̣̃ ꞌá. Gõꞌdá nĩngá sĩ rî, gólĩyî rĩꞌá tã õnjí bê tákányĩ ĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá. Tã lâ rĩꞌá nõtí, Ôvârí âꞌdô lâŋõ fẽꞌá gólĩyî drí lậvũlı̣́ kôrô.” ");
INSERT INTO avu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yésũ rî trá ãnyî ngá gólâ rĩzó lãfâ ngá fẽfẽ ró rî ꞌbãlé ꞌá lâ rĩzó ngá ꞌẽꞌẽ Ôvârí kâ vó lâ ndrẽlé jó ạ́ngı̣́ Ôvârí kâ ꞌá rî lạ̃gạ́tı̣́. Gólâ ndrê ãgô ãzâ ꞌbá yî ngá-drı̣̃ ãmbá bê rî ꞌbá yî trá, lãfâ ãmbá ꞌbãꞌá ngá ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Gõꞌdá ạ̃yı̣́zı̣́ ãzâ ĩzã ꞌbá ró rî gólâ cé lãfâ ífí bê rı̣̃, drílâ kpá ânĩzó fẽlâ Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Gõꞌdá Yésũ drí tã âtázó kĩ nĩ rî, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, nĩ ndrê drẽ õkó ĩzã ꞌbá ró nõ. Gólâ fẽ lãfâ dódó ró Ôvârí drí lậvũlı̣́ gạ̃rạ̃, tãlâ gólâ cú ĩtí ngá ãzâ ãkó fẽlé. Ôvârí âꞌdô tã tãndí gólâkâ ꞌdĩ võ lâ lôgõꞌá. ");
INSERT INTO avu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ãgô gólĩyî ngá-drı̣̃ ãmbá bê nõ ꞌbá yî rĩꞌá lãfâ bê dũû, fẽfẽ lâ âꞌdó lâŋõ ró kô. Gõꞌdá õkó gólâ ĩzã ꞌbá ró nõ kâ rî, fẽ íyíkâ ĩꞌdî nyé ꞌdĩ, ạ̃mbúkũ lâ âyé ãkó yí drí ngá pãzó drı̣̃ lâ ạ̃tı̣́ ꞌálâ, ꞌdĩî ngá lẽlẽ gólâkâ rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lãjóꞌbá Yésũ kâ bê rĩꞌá âfõꞌá jó ạ́ngı̣́ Ôvârí kâ ꞌásĩ rî, gólĩyî drí rĩzó tã âtálé tã jó ạ́ngı̣́ Ôvârí kâ sû ãkĩ, bẽlé kúnı̣́ mvá sĩ îgígírãlé nyạ̃rũ-nyạ̃rũ nâ tãsĩ, kpá ngá fẽfẽ Ôvârí drí jó ạ́ngı̣́ gólâkâ nã êdézó sũlı̣́ rõô nã tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yésũ âtâ tã trá gólĩyî drí kĩ nĩ rî, “Má âtâ ĩꞌdî ãnî drí tã pạ̃tı̣́ı̣̃ ró, ı̣̃zạ́tú rî, nĩ âꞌdô ndrẽꞌá lâ, jó ạ́ngı̣́ tõrõngõlõ sũ ꞌbá ãkĩ ꞌdî, kậyı̣̂ lâ õtírĩ cãâ rî, áâꞌdô lâpẽꞌá lâ ndéré-ndéré, kúnı̣́ mvá lâ ꞌdĩ ꞌbá yî drí lôꞌdézó ndrĩ vũdrı̣́ sĩ ndíyá-ndíyá.” ");
INSERT INTO avu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gõꞌdá nĩngá sĩ, lãjóꞌbá ꞌdĩ ꞌbá yî drí tã îjízó Yésũ tı̣́ kĩ nĩ rî, “Ngá ꞌdĩ, kậyı̣̂ lâ âꞌdô âcáꞌá ángô tû yã? Ngá ãzâ bê ꞌẽ ꞌbá rû ꞌẽlé sı̣́sı̣́ kậyı̣̂ lâ âꞌdálé ãmâ drí yã?” ");
INSERT INTO avu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yésũ kĩ, “Nĩ ꞌbã ãnî drı̣̃ı̣̂ tãndí ró, nĩ ꞌbã õjílã ãâdô ãnî kô âgõ-âgõ ámákâ rî tã lâ tãsĩ. Õnjõ ꞌbá ãzâ ꞌbá yî bê rĩꞌá dũû. Ãzâ ꞌbá yî âꞌdô tã âmãꞌá kĩ nĩ rî, yĩ ãꞌdô ĩꞌdî ꞌdíyî pã ꞌbá ꞌî. Ãzâ ꞌbá yî âꞌdô âtáꞌá lâ kĩ nĩ rî, kậyı̣̂ câ trá ạ̃dũkũ ãngó kâ drí âcázó. Gõꞌdá nĩ ârî tã ꞌdî ꞌbá yî kô ãlôwálâ, tãlâ ꞌdĩî ꞌdó õnjõ ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Gõꞌdá õzõ nĩ ãârî tã ạ̃jú kâ ngãꞌá gbõ lé võ ãzâ ꞌbá yî ꞌásĩ rî, nĩ ꞌê ũrı̣̃ kô. Nĩ lôꞌbê lı̣̃fı̣́ kpá kô kĩꞌá nĩ rî, ạ̃dũkũ ãngó kâ trá âcáꞌá ĩꞌdî ꞌdĩ. Ngá ãmbá ꞌdĩ ꞌbá yî âꞌdô lậvũꞌá ndrĩ ạ̃dũkũ ãngó kâ õró gõ âcálé vólé lésĩ ró. ");
INSERT INTO avu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nĩ âꞌdô ndrẽꞌá lâ, õrĩ tı̣̂ ãmbá âꞌdô ngãꞌá rĩꞌá rû fũlı̣́ ĩyî võ ꞌásĩ gĩâ nãlé gõꞌdá kpá nõngá. Kó nĩ ꞌê ũrı̣̃ kô. ");
INSERT INTO avu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nĩ âꞌdô ndrẽꞌá lâ, tã lârâkô âꞌdô rû ꞌẽꞌá, ı̣̃nyạ́kú drí rĩzó rû îyálé, kpá lõfó õnjí drí ꞌdẽzó õjílã drı̣̃ı̣̂, ngá lãzé tı̣̂ õnjî-õnjî âꞌdô õjílã ꞌẽꞌá ndrĩ. Gõꞌdá nĩ âꞌdô ndrẽꞌá lâ kpá tã lârâkô ãzâ ꞌbá yî õzõ õyĩ ạ́ngı̣́ kâtí rî âꞌdô rû ꞌẽꞌá ꞌbũû ꞌá. Ị̃tú lı̣̃fı̣́ ngã ꞌbô ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ lı̣̃fı̣́ ꞌî yã rî, âꞌdô rĩꞌá rû ôjálé võ ꞌásĩ ngĩíngî. ꞌDĩî rî tã âꞌdálé kĩ, kậyı̣̂ ạ̃dũkũ trá ãnyî. ");
INSERT INTO avu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Gõꞌdá ãkpãkãꞌdã drẽ ngá ꞌdĩ ꞌbá yî ꞌé rû kô rî, ãnî ãzâ ꞌbá yî, õjílã âꞌdô ãnî rũꞌá âjílí õjílã ạ́ngı̣́ sı̣́sı̣́-lésĩ rî ágálé tã lâ kĩlí, ãzâ ꞌbá yî âjízó kúmú ạ́ngı̣́ ạ́ngı̣́ ágálé tã lâ kĩlí ꞌbãlé gạ̃nı̣́mạ̃ ꞌá, rĩꞌá ãnî îzãlé, tãlâ ãnî lãjóꞌbá ámákâ ĩꞌdî rî drí sĩ. ");
INSERT INTO avu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Õzõ tã ꞌdî ꞌbá yî õtírĩ rû ꞌẽê rî, nĩ âꞌdô lạ́tı̣̂ tãndí ûsúꞌá tã âtázó ámâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Nĩ ꞌê ũrı̣̃ kô. Óõꞌbã ãnî gbõ lé gạ̃nı̣́mạ̃ ꞌá rî, nĩ lôꞌbê lı̣̃fı̣́ kô úlı̣́ võ ãnî ạ̃jú-ꞌbá-ãzí yí kâ ícícíyá ꞌẽzó ãnî rú rî lôgõrẽ ꞌá, tãlâ mâ bê. Má âꞌdô tã nı̣̃nı̣̃ âfẽꞌá ãnî drí úlı̣́ ífífí âtázó ĩꞌdî gólĩyî pẽzó. ");
INSERT INTO avu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ãnî ãzí-ãzí yî ngãtá ꞌbô ãnî áró yî âꞌdô lé õdrã sõꞌá nĩ ãnî lı̣̃fı̣́ ámâ tãsĩ rî, nĩ ꞌê ũrı̣̃ kô. Áâꞌdô õjílã ãzâ ꞌbá yî ãnî lãfálé sĩ rî ûfúꞌá kpá ámâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Õjílã ãzâ ꞌbá yî dũû ꞌálé lâ yî drí âdrãzó kpá ãnî rú ámâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Gólĩyî âꞌdô ãnî fũꞌá gõꞌdá gólĩyî îcá kô ãnî fũlı̣́ zãâ, âꞌdô ĩyî cé ãnî rúꞌbạ́ fũꞌá ĩꞌdî, ãnî lîdrí-lîdrí âyélé. ");
INSERT INTO avu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Õzõ õjílã ãâꞌdô ãnî îzãꞌá rõô ámâ tãsĩ rî, nĩ rî fĩî ậtũ-ậtũ sĩ. Ĩtí rî, nĩ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá. ");
INSERT INTO avu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nĩ ndrê dódó õzõ ạ̃jú ꞌbũ ꞌbá õtírĩ rãâ dîrî gbãâ Yẽrõsãlémã rú sĩ ạ̃jú ꞌbũlı̣́ rî, nĩ nı̣̃ trá âbí ꞌẽꞌá îzãlâ. ");
INSERT INTO avu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Õjílã gólĩyî rĩ ꞌbá dîrî Yũdạ́yạ̃ rú sĩ rî õrâ ndrĩ únı̣́ drı̣̃ ꞌálâ ĩyî lậpı̣́lı̣́. Gõꞌdá õjílã gólĩyî rĩ ꞌbá ĩyî ꞌbã-tı̣̂ ĩyíkâ ꞌásĩ rî, âꞌdó kô tãndí ró drílĩyî gõꞌdá rãzó Yẽrõsãlémã ꞌálâ ĩyî lậpı̣́lı̣́. ");
INSERT INTO avu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gólĩyî ꞌê rãlé ꞌdĩ, tãlâ Ôvârí trá ꞌẽꞌá Yẽrõsãlémã rî îzãlé. Ôvârí ꞌê Yẽrõsãlémã rî îzãlé ꞌdĩ, tãlâ ạ̃kû ró rî tã ậngũ ꞌbá âtâ tã lâ trá ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nõô rî trá kậyı̣̂ ĩzã kâ ꞌî õkó ꞌâ bê rî ꞌbá yî drí gõꞌdá kpá gólĩyî mvá bê drı̣́ ꞌá rî ꞌbá yî drí! Õjílã ndrĩ âꞌdô ĩzã ꞌẽꞌá rõô ngbı̣̃lı̣̃rı̣̃ Ôvârí kâ drí sĩ. ");
INSERT INTO avu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Áâꞌdô õjílã ãmbá ꞌdı̣̃ꞌá îzãꞌá ạ̃jú sĩ, áâꞌdô õjílã ãzâ ꞌbá yî rũꞌá fẽlé rạ̃gı̣́ı̣̃ ró ꞌbạ̃drı̣̃ ãzâ ꞌbá yî ꞌá jẽjẽ ró. Õjílã lídí drí ânĩzó nĩ Yẽrõsãlémã rî rũlı̣́, té kậyı̣̂ Ôvârí drí ꞌbãlé mbârâkã gólĩyíkâ drí rû ndẽzó rî drí cãzó nĩ.” ");
INSERT INTO avu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","“Gõꞌdá nĩngá sĩ rî, tã lârâkô ãzâ ꞌbá yî âꞌdô rû ꞌẽꞌá ı̣̃tú lı̣̃fı̣́, kpá párá lı̣̃fı̣́, kpá ı̣̃ꞌbı̣̂ꞌbı̣̂wạ́ lı̣̃fı̣́. ꞌDĩî rî, ngá ꞌbũû ꞌálâ rî ꞌbá yî âꞌdô rû îyáꞌá kı̣̃zı̣̃-kı̣̃zı̣̃ õyĩ ró. Tã ꞌdî ꞌbá yî âꞌdô õjílã ãmbá ꞌbãꞌá âꞌdólé kõló-kólô ró fãfã ãkó ĩtí. Õjílã ãmbá îcá rãlé kô, tãlâ ngá ꞌdĩ ꞌbá yî âꞌdô lı̣̃mvû ândrê ꞌbãꞌá tı̣̃lı̣́ õjílã ûfúlı̣́. Õjílã ãmbá drı̣̃ âꞌdô lîjãꞌá ũrı̣̃ drí, tãlâ gólĩyî âkĩꞌá nĩ rî, ạ̃dũkũ ãngó kâ âcâ trá. ");
INSERT INTO avu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Gõꞌdá mâ gólâ âjólé ûrú lésĩ nô âꞌdô âgõꞌá mbãrãsãsã bê. Má âꞌdô ânĩꞌá cú mbârâkã ạ́ngı̣́ bê gõꞌdá kpá ãmbã Ôvârí kâ rî bê, õjílã drí ndrẽzó lâ ndrĩ. ");
INSERT INTO avu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tã ꞌdî ꞌbá yî õtírĩ rû ꞌẽê ĩtí rî, nĩ ꞌbã lı̣̃fı̣́ vó lâ, tãlâ má âꞌdô âgõꞌá õjílã gólĩyî ĩzã bê ámâ tãsĩ rî pãlé ĩzã rî ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Gõꞌdá Yésũ âtâ úlı̣́ mãnĩgõ trá gólĩyî drí nõtí kĩ nĩ rî, “Nĩ õtírĩ fê bı̣́ ndrẽê ârõꞌá cãrõ rî, nĩ nı̣̃ trá kĩ nĩ rî, ôzê lı̣̃mvû trá ãnyî ꞌẽꞌá âcálé. ");
INSERT INTO avu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gõꞌdá nõô rî kpá ĩtí, õzõ nĩ õtírĩ tã lârâkô ꞌdĩ ꞌbá yî ndrẽê rû ꞌẽꞌá rî, nĩ âꞌdô nı̣̃ꞌá lâ kpá kĩ nĩ rî, tã kũmũ Ôvârí kâ rî kâ rî ꞌẽꞌá ãnyî âcálé. ");
INSERT INTO avu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Õjílã ãnî lãfálé sĩ rî, ãzâ ꞌbá yî âꞌdô ndrẽꞌá lâ drẽ ãkpã gólĩyî ôdrãá drẽ kô. ");
INSERT INTO avu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Õzõ kpálé ı̣̃nyạ́kú drı̣̃ ꞌbũû bê ãâꞌdô rû ndẽꞌá ndrĩ rî, úlı̣́ ámákâ nõ ndẽé rû kô ãlôwálâ. ");
INSERT INTO avu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Nĩ sû ãnî rú dódó, nĩ ı̣̂sũ tã kô cé tã ãngó nõ kâ tãsĩ, nĩ sõ ãnî kô mõrá õdrá kâ rî ꞌá, rĩzó cú ĩtí tã ı̣̂sũ-ı̣̂sũ ãkó. Âgõ-âgõ ámákâ ãngó ꞌá nõlé rî âꞌdô ꞌbãꞌá cú ĩtí, õjílã ãzâ drí kậyı̣̂ lâ nı̣̃ ãkó, âꞌdô ꞌbãꞌá ꞌwãâ ró, õzõ kõlõgbõ drí ậsı̣́rı̣̃ ꞌwãâ ró ãcõmõ édrégó drı̣̃ı̣̂ rî kâtí. Õjílã gólĩyî tíbê drı̣̃ âdĩ ꞌbá tã õnjí ĩyíkâ ꞌásĩ kô rî, ûsú ĩyî kậyı̣̂ gõꞌdá drı̣̃ âdĩzó tã õnjí ĩyíkâ ꞌásĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ãnî lãjóꞌbá ámákâ rî ꞌbá yî, nĩ rî njãâ. Má âꞌdô ꞌẽꞌá âgõlé ꞌwãâ ró, nĩ rî zãâ rãtáã ꞌẽlé Ôvârí drí, õꞌbã ró ãnî pı̣̃pı̣̂sı̣́lı̣́ bê ı̣̂dû-ı̣̂dû ró rĩlí lãjóꞌbá tãndí ró. Õzõ nĩ õꞌê trá ĩtí rî, âꞌdó kô ãnyĩ ró âdrérẽ ꞌá ı̣̃zạ́tú má ágálé, má õtírĩ âgõô tã kĩlí ạ̃dũkũ lâ ró rî. Nĩ âꞌdô kákárá lı̣́mú kâtí, nĩ pâ ró ngá bê lâŋõ ãmbá ꞌdĩ ꞌbá yî ꞌásĩ. Nĩ ꞌbã ãnî pı̣̃pı̣̂sı̣́lı̣́ kpá vũdrı̣́, nĩ pâ ró ngá bê lâŋõ Ôvârí rî mvá kâ rî ꞌásĩ. ꞌDĩî tã ámákâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yésũ rî trá õjílã lı̣̃fı̣́ îcílí ı̣̃tú vósĩ cé jó ạ́ngı̣́ Ôvârí kâ ꞌálâ. Lạ̃njạ́túlı̣́ sĩ rî, drílâ ngãzó gõlé táyã gólĩyíkâ ꞌálâ, únı̣́ fê dõ kâ bê dũû drı̣̃ lâ rî drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ãkpãkãꞌdã õjí bê, ı̣̃tú vósĩ cé, õjílã ãmbá rî ĩyî trá nĩlí tã gólâkâ ârílí. ");
INSERT INTO avu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gõꞌdá kãrámã ãmbãtã ạ̃kú ãkó rî kâ tíbê rĩꞌá zı̣̃lâ kpá kãrámã lậvũ-lậvũ kôrô kâ âcâ trá ãnyî. ");
INSERT INTO avu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî lãꞌbí îmbá ꞌbá yí bê, êꞌbê ĩyî rû trá tã ı̣̂ꞌbı̣̃lı̣́ ꞌẽzó Yésũ rî fũlı̣́ ı̣̃nı̣́nı̣̂ ró, tãlâ gólĩyî rô õmbã õjílã kâ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kpá kậyı̣̂ gólĩyî drí rĩrĩ tã ı̣̂ꞌbı̣̃lı̣́ rî ꞌá rî, Sãtánã drí fĩzó Yúdạ̃ Ĩsĩkãrĩyótã ꞌá, Yúdạ̃ rî ꞌbãlé Yésũ rî drı̣́-bã fẽlé íyî ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́. Yúdạ̃ ꞌdĩ kpá lãjóꞌbá Yésũ kâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yúdạ̃ drí nĩzó õjílã ãmbâ-ãmbâ Yúdạ̃ yí kâ gólĩyî rĩ ꞌbá ĩyî tã lôndãlé ꞌẽzó Yésũ rî fũlı̣́ ꞌdĩ ꞌbá yî ngálâ tã ꞌdî ı̣̂ꞌbı̣̃lı̣́ gólĩyí bê. ");
INSERT INTO avu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Âcâ-âcâ Yúdạ̃ kâ gólĩyî ngálâ rî, ãyĩkõ lâ cî gólĩyî trá kôrô. Drílĩyî tã-drı̣̃ lẽzó lãfâ fẽzó Yúdạ̃ drí, Yésũ rî drı̣́-bã fẽzó ĩyî drı̣́ rî sĩ. ");
INSERT INTO avu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yúdạ̃ rî trá cé ı̣̃tú tẽlé ĩꞌdî ꞌẽzó Yésũ rî drı̣́-bã fẽlé ạ̃jú-ꞌbá-ãzí drí, gólâ õtírĩ ꞌbãâ élêwálâ rî. ");
INSERT INTO avu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kậyı̣̂ gólâ kãrámã nã kâ sĩ rî, ꞌbã-lı̣́pı̣̂ ꞌbã-tı̣̂ ãlô-ãlô kâ drí kạ́bı̣̃lı̣́kı̣̃ ûlı̣́zó nyãlé ạ̃ꞌdı̣́-drı̣̃ ĩyíkâ ꞌá, ãꞌdô ró bê kậyı̣̂ Ôvârí drí lậvũzó kôrô ĩyî drı̣̃ı̣̂ sĩ Mạ́sı̣̃rı̣̃ ꞌálâ rî, tã lâ õzó jãâ kô. ");
INSERT INTO avu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yésũ drí tã âtázó Pétẽrõ yî drí Yõwánĩ bê nĩlí ngá kãrámã ꞌdî kâ êdélé. ");
INSERT INTO avu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pétẽrõ yî Yõwánĩ bê drílĩyî tã îjízó Yésũ tı̣́ kĩ, võ lâ ꞌdĩ ángô lé yã? ");
INSERT INTO avu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yésũ âtâ trá gólĩyî drí kĩ, “Nĩ nĩ, õzõ nĩ õcâ trá Yẽrõsãlémã ꞌálâ rî, nĩ âꞌdô ãgô ãzâ ûsúꞌá, rĩꞌá lũmvû límvó njı̣̃ꞌá. Nĩ ꞌdê zãâ gólâ vó, âꞌdô nĩꞌá fĩlí jó ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nĩ gõ ró úlı̣́ âtálé ꞌbã-lı̣́pı̣̂ drí kĩ nĩ rî, ‘Ãmâ lı̣́pı̣̂ âtâ tã ní drí nõtí, jó ĩyî drí rĩzó ꞌá lâ lãjóꞌbá íyíkâ rî ꞌbá yí bê kãrámã nyãlé rî íyíkâ ángô lé yã?’ ");
INSERT INTO avu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Gólâ âꞌdô jó ꞌálé ạ́ngı̣́ ãzâ âꞌdáꞌá ãnî drí, lạ̃kũ ûrú lésĩ rî ꞌá õrî mbãlé mbãmbã nĩꞌá ꞌálâ ãzâ rî ꞌá tólâ. Tãrãbízã yî ngá ãzâ ꞌbá yí bê ꞌdó rĩꞌá tólâ kpá, nĩ lı̣̂ ró kạ́bı̣̃lı̣́kı̣̃ lâꞌdílí ngá nyãnyã ãzâ ꞌbá yí bê êdélé njãâ, ãmâ drí ânĩꞌá nyãlâ, nĩ gõ ró ânĩlí tã lâ âtálé ãmâ drí.” ");
INSERT INTO avu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gõꞌdá Pétẽrõ yî Yõwánĩ bê, drílĩyî nĩzó ãgô ꞌdĩ ûsúlı̣́, té õzõ Yésũ drí âtálé rî tí. Gõꞌdá drílĩyî ngá kãrámã ꞌdî kâ êdézó. ");
INSERT INTO avu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Gõꞌdá nĩngá sĩ, Pétẽrõ yî Yõwánĩ bê ânĩ ĩyî trá tã lâ âtálé Yésũ drí. Yésũ yî drí âcázó lãjóꞌbá íyíkâ rî ꞌbá yí bê kãrámã nyãlé. Drílĩyî nĩzó rĩlí tãrãbízã lạ̃gạ́tı̣́ ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yésũ drí gõzó tã âtálé lãjóꞌbá íyíkâ drí kĩ nĩ rî, “Má rî tã âtálé ãnî drí rî, má lẽ tã trá tákányĩ ãmâ drí kãrámã nô ꞌẽzó ãní bê drẽ ãkpãkãꞌdã má drãá drẽ kô. ");
INSERT INTO avu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Má ꞌé kãrámã ãzâ gõꞌdá õzõ nõô rî tí kô, zãâ té ngá gólâ tã lâ âꞌdálé nõ âꞌdô rû ꞌẽꞌá zãlô. Gõꞌdá Ôvârí âꞌdô ámâ ꞌbãꞌá kúmú võ ûrú ꞌálâ rî kâ ró.” ");
INSERT INTO avu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yésũ drí ĩgã õdrá âlâꞌbâ kâ îngázó ûrû, drílâ rãtáã ꞌẽzó Ôvârí drí. Gõꞌdá gólâ kĩ nĩ rî, “Ãnî ndrĩ, nĩ trõ ĩgã õdrá âlâꞌbâ kâ nõ má drı̣́gạ́ sĩ, nĩ mvû ró. ");
INSERT INTO avu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Õzõ má drí âtálé ãnî drí nõtí, má mvú õdrá âlâꞌbâ gõꞌdá kô té tã kũmũ Ôvârí kâ tã lâ drí rû ꞌẽzó zãlô.” ");
INSERT INTO avu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Gõꞌdá drílâ ãmbãtã trõzó, rãtáã ꞌẽzó Ôvârí drí, drílâ ûpı̣̃zó lâ fẽlé lãjóꞌbá íyíkâ rî yî drí kĩ nĩ rî, “Áâꞌdô ámâ rúꞌbạ́ ûpı̣̃ꞌá, õzõ ãmbãtã nô tí. Má lẽ ãnî drí ãmbãtã nô nyãlé kpãkã ãlô õzõ nõô tí, ãꞌdô ró bê ãnî drí ámâ õdrã gólâ ãnî pãzó rî tã lâ ı̣̂sũzó.” ");
INSERT INTO avu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gõꞌdá nyâ ĩyî ngá bê trá ndrĩ rî, Yésũ drí kpá ĩgã õdrá kâ nõ trõzó kpá óꞌdí kĩ nĩ rî, “Ámâ ãrí âꞌdô lâsóꞌá trá õzõ õdrá nõ tí, ãꞌdô ró bê Ôvârí drí ãnî pãzó. Õdrá nõ âꞌdâ tã-drı̣̃ lẽlẽ óꞌdí Ôvârí kâ ĩꞌdî ãnî pãzó, tãlâ õdrã ámákâ âꞌdô ãnî gĩꞌá. ");
INSERT INTO avu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Tákõ gólâ ꞌẽ ꞌbá ámâ drı̣́-bã fẽlé ámâ ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́ rî kpá rĩꞌá ãnyî má lạ̃gạ́tı̣́ nõ. ");
INSERT INTO avu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Trá ãnyî ꞌẽꞌá ámâ fũlı̣́ vólé ĩꞌdî, ꞌdĩî tã Ôvârí drí ámâ âjózó ânĩlí ãngó ꞌá nõ, ãꞌdô ró bê tã õnjí ãníkâ tãsĩ ãnî drı̣̃ tĩzó. Gólâ tíbê ámâ drı̣́-bã fẽ ꞌbá ámâ ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́ rî, gólâ rî ĩzã gâ trá má drı̣̃ı̣̂, tã õnjí ꞌẽꞌẽ gólâkâ ꞌdĩ âꞌdô gõꞌá ãkpã gólâ drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Lãjóꞌbá ꞌdĩ ꞌbá yî rî trá tã îjílí ĩyî võ ꞌásĩ kĩ nĩ rî, “Tã ꞌdî âꞌdô ꞌbãꞌá ángô tí yã? Õjílã ángô rî âꞌdô tã ꞌẽꞌá nĩ ĩtí ãmâ lãfálé sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ꞌDĩî rî vósĩ rî, lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ngãzó rĩꞌá tı̣̂ ôcílí ĩyî võ ꞌásĩ, ãꞌdî ĩꞌdî ĩyî lãfálé kôrô ĩyî drı̣̃ı̣̂ yã. ");
INSERT INTO avu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Gõꞌdá Yésũ âtâ trá gólĩyî drí kĩ nĩ rî, “Nĩ ârî drẽ, tã kúmú ạ́ngı̣́ ạ́ngı̣́ kâ ãngó ꞌá nõngá rî trá nõtí, gólĩyî âtâ ĩyî tã trá õjílã drí ânĩzó ꞌwãâꞌwâ ngã ꞌbô tã ãzâ ꞌbá yî ꞌẽzó ꞌwãâꞌwâ. Gõꞌdá gólĩyî ꞌbã õjílã trá rú ãzâ zı̣̃lı̣́ ĩyî drı̣̃ı̣̂ nõtí, “‘rû-lẽ-ãzíyã õjílã kâ ndrĩ”’. ");
INSERT INTO avu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gõꞌdá ãnî drí rî âꞌdó ĩtí kô. Gólâ tíbê ꞌẽ ꞌbá rû ı̣̂ꞌbũlı̣́ íyî ãzí-ãzí yî drí rî, gólâ ĩꞌdî tíbê Ôvârí drí ꞌẽꞌá ꞌbãlâ õjílã ạ́ngı̣́ ró rî. ");
INSERT INTO avu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nĩ âꞌdâ drẽ má drí, ãꞌdî ĩꞌdî gạ̃rạ̃ yã, õjílã gólâ rĩ ꞌbá tãrãbízã bê yí ágálé rî ĩꞌdî, ngã ꞌbô õjílã rĩ ꞌbá nyãsá lânjílí ĩyî drí nõ ĩꞌdî? Nĩ lôgõ drẽ tã nô má drí, õjílã gólâ rĩ ꞌbá tãrãbízã lạ̃gạ́tı̣́ nõ, nĩ ı̣̂sũ drẽ tã ꞌẽꞌẽ ámákâ. Nĩ ndrê drẽ, mâ bê ãnî lãfálé nõngá, õzõ rû ı̣̂ꞌbũ ꞌbá kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gõꞌdá Yésũ kĩ, “Nĩ rî trá má bê lâŋõ drí ámâ ꞌẽrẽ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ámâ átá Ôvârí âfẽ drı̣́-ãcê íyíkâ trá má drí. Ngbãângbânõ rî, má fẽ drı̣́-ãcê trá ãnî drí ndrĩ, tãlâ nĩ rî trá ãnyî má lạ̃gạ́tı̣́ tã ámákâ ârílí. ");
INSERT INTO avu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nĩ âꞌdô rĩꞌá ngá mvũlı̣́, ngá nyãlé má bê tãrãbízã ámákâ drı̣̃ı̣̂ kũmũ ámákâ ꞌá, nĩ âꞌdô rĩꞌá má bê tã-vó ꞌbạ̃súrú Ĩsĩrãꞌélẽ kâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî ꞌbá yí kâ kĩlí.” ");
INSERT INTO avu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yésũ drí tã âtázó Sĩmónã Pétẽrõ drí kĩ, “Sĩmónã, ní ârî úlı̣́ ámákâ. Sãtánã ûsû drı̣́-ãcê Ôvârí drı̣́gạ́ sĩ ãnî ûjũzó ndrĩ. Gólâ âꞌdô ãnî îyáꞌá õzõ yãvó ạ̃drúgú kúrũmû kâ îyárẽ kâtí. ");
INSERT INTO avu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Má rî trá rãtáã ꞌẽlé ánî tãsĩ, tãlâ ní õzó tã lẽlẽ áníkâ âyé vólé kô. Ní âꞌdô tã õnjí ꞌẽꞌá, gõꞌdá ní õtírĩ drı̣̃ âdĩî tã õnjí áníkâ ꞌásĩ rî, ní sõ mbârâkã ánî ậdrúpı̣̃ yî nõngá nõ ꞌbá yî rî ꞌá gạ́gạ́, ꞌdê ĩyî kô.” ");
INSERT INTO avu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pétẽrõ âtâ trá Yésũ drí kĩ nĩ rî, “Ámâ lı̣́pı̣̂, mâ trá njãâ nĩlí gạ̃nı̣́mạ̃ ꞌálâ kpá drãlé ní bê.” ");
INSERT INTO avu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yésũ kĩ, “Kậyı̣̂ gólâ ãndrõ nô ꞌá nõ, drẽ ãkpãkãꞌdã ꞌạ̃ꞌú-lúgú ꞌbé cı̣́rı̣̃ kô, ní âꞌdô ámâ gãꞌá ândâlâ nâ kĩꞌá nĩ rî, yí nı̣̃ı̣́ mâ kô.” ");
INSERT INTO avu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí ndrĩ kĩ nĩ rî, “Kậyı̣̂ tíbê má drí ãnî jõzó nĩlí tã âtá bê rî ꞌá, má kĩ nĩ rî, nĩ trõ lãfâ kô, nĩ trõ ítá, káꞌbókã, jõráã ãníkâ ngá ꞌbãzó ꞌá lâ rî yî kô. Nĩ lẽ ngá ãzâ trá yã?” Gólĩyî lôgõ tã-drı̣̃ trá Yésũ drí kĩ nĩ rî, “ꞌÉꞌẽ.” ");
INSERT INTO avu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yésũ kĩ, “Ngbãângbânõ rî, trá ı̣̃tú-pá ĩzã kâ ꞌî. Nĩ trõ lãfâ jõráã yí bê, tãlâ nĩ nı̣̃ı̣́ kô, nĩ ãâꞌdô ꞌẽꞌá rãlé jẽjẽ ró rî. Nĩ âꞌdô ítá ạ́ngı̣́ ãníkâ ꞌbãꞌá gĩlí, lı̣́gú ândrê gĩzó drı̣́-lãfâ ró ãnî drı̣́gạ́ óõzó ãnî fũû kô. ");
INSERT INTO avu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Má âtâ tã ꞌdî ĩtí, tãlâ tã tíbê tã ậngũ ꞌbá Ĩsáyã drí âtálé ạ̃kû ró rî ꞌá ámâ tãsĩ âꞌdô bí ꞌẽꞌá âcálé ngbãângbânõ, âꞌdô ĩyî ámâ îzãꞌá õzõ tã õnjí ꞌbá kâtí. Ãwô, tã ꞌdî ꞌbá yî âꞌdô rû ꞌẽꞌá ꞌdó ngbãângbânõ.” ");
INSERT INTO avu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî nı̣̃ı̣́ ĩyî tã ꞌdî ífí lâ kô. Gólĩyî kĩ, “Ní ndrê, Yésũ, ãmâ rĩꞌá lı̣́gú ândrê bê zãlô rı̣̃.” Yésũ îkî gólĩyî kĩ nĩ rî, “Îcâ trá ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ꞌDĩî rî vósĩ rî, Yésũ yî drí gõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê táyã gólĩyíkâ rî gãrã drı̣̃ lâ mbãlé únı̣́ fê dó kâ bê yí drı̣̃ı̣̂ rî drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Gólĩyî õtírĩ cãâ võ ꞌdî ꞌá rî, gólâ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ꞌê rãtáã Ôvârí drí, gólâ õꞌbã ãnî pı̣̃pı̣̂sı̣́lı̣́ ı̣̂dû-ı̣̂dû ró, tãlâ nĩ õzó tã lẽlẽ ãníkâ ôjá õdrã ũrı̣̃ drí.” ");
INSERT INTO avu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Drílâ ngãzó nĩlí gólĩyî lạ̃gạ́tı̣́ sĩ vólé rĩlí gĩâ nãtí, ꞌãꞌî tı̣̃lı̣́ vũdrı̣́ rãtáã ꞌẽzó Ôvârí drí. ");
INSERT INTO avu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Gólâ kĩ nĩ rî, “Tátá, õzõ ní õlẽ trá rî, ní ꞌbã lâŋõ ạ́ngı̣́ nõ kâ kô má drı̣̃ı̣̂. Gõꞌdá ní ꞌbã tã âꞌdô õzõ tã lẽlẽ áníkâ rî tí. Má âꞌdô rõꞌá lâ.” ");
INSERT INTO avu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Gõꞌdá mãlãyíkã Ôvârí kâ drí ânĩzó ûrú lésĩ gólâ rî lôpélé mbârâkã fẽlé gólâ drí, tãlâ gólâ rî rúꞌbạ́ ôdrã trá ndrĩ, tã ı̣̂sũ-ı̣̂sũ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gólâ ꞌê rãtáã trá rõô cú tã ı̣̂sũ-ı̣̂sũ ĩzã kâ sĩ íyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá. Gõꞌdá gólâ rî ũrı̣́ râ trá gólâ rú sĩ vũdrı̣́, õzõ ãrí drí rãrẽ kâtí. ");
INSERT INTO avu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Gólâ ndẽ rãtáã ꞌẽꞌẽ bê rî, drílâ gõzó lãjóꞌbá íyíkâ rî yî ngálâ, ûsû gólĩyî trá ꞌdó ậꞌdú kõꞌá, gólĩyî trá lâŋõ ró ĩzã drí sĩ. ");
INSERT INTO avu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gõꞌdá gólâ âtâ trá drílĩyî kĩ nĩ rî, “Nĩ rî ậꞌdú kõlé ãꞌdô drí yã? Nĩ ngâ ûrû rãtáã ꞌẽlé, tãlâ nĩ õzó tã lẽlẽ ãníkâ ôjá kô õdrã ũrı̣̃ drí sĩ.” ");
INSERT INTO avu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yésũ drẽ tã âtáꞌá lãjóꞌbá íyíkâ drí nõ rî, õjílã õꞌbí ãzâ ꞌbá yî drí âcázó. Yúdạ̃, lãjóꞌbá Yésũ kâ rî, ậdrı̣̃ õjílã õꞌbí trá ânĩlí Yésũ rî rũlı̣́. Yúdạ̃ ânĩ trá Yésũ rî âmvólé, nî-bê-yã fẽzó drílâ. ");
INSERT INTO avu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yésũ âtâ trá Yúdạ̃ drí kĩ nĩ rî, “Yúdạ̃, ní ꞌê tã nõtí ãꞌdô tãsĩ yã, ámâ drı̣́-bã fẽzó ạ̃jú-ꞌbá-ãzí drí nî-bê-yã fẽfẽ sĩ má drí nõ?” ");
INSERT INTO avu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî ndrê ĩyî bê tã ꞌdî trá ãnyî rî, gólĩyî kĩ nĩ rî, “Ãmâ lı̣́pı̣̂, mã õgâ gólĩyî lı̣́gú ândrê ãmákâ nõ ꞌbá yî sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Gõꞌdá lãjóꞌbá ãzâ Yésũ kâ rî drí, drı̣̃-ꞌbá drı̣̃-ꞌbá Yúdạ̃ yí kâ rî ꞌbá yí kâ rû ı̣̂ꞌbũ ꞌbá lâ bı̣́ lâ gãzó lı̣́gú ândrê sĩ njíyá vũdrı̣́. ");
INSERT INTO avu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá ꞌdĩ drí kĩ nĩ rî, “Îcâ trá ꞌdĩ, ní âyê.” Gõꞌdá drílâ ngãzó ãgô ꞌdĩ bı̣́ lâ trõlé lôgõlé võ lâ ꞌá êdélé dódó. ");
INSERT INTO avu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gõꞌdá Yésũ âtâ tã trá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî, ạ̃jú ꞌbũ ꞌbá gólĩyíkâ yí drí kĩ nĩ rî, “Nĩ lẽ ânĩlí lı̣́gú yí bê, pı̣̃drı̣́gú yí bê yã? ");
INSERT INTO avu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Õzõ nĩ õlẽ mâ rî, má rî trá jó ạ́ngı̣́ Ôvârí kâ ꞌá ãní bê, nĩ lẽé kô ámâ rũlı̣́ tólâ ãꞌdô tãsĩ yã? Nĩ rî ânĩlí ngạ́cı̣̂ sĩ nô tã nô ꞌbá yî ꞌẽlé má drí nõ rî, tãlâ nĩ rî tã ꞌẽꞌẽ Sãtánã kâ ꞌẽlé ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Õjílã nâ ꞌbá yî rû ĩyî Yésũ trá, sê ĩyî gólâ trá mbârâkã sĩ, nĩzó ĩꞌdí bê lâ drı̣̃-ꞌbá drı̣̃-ꞌbá Yúdạ̃ yí kâ rî ꞌbá yí kâ nã ngálâ. Pétẽrõ drí ꞌdẽzó zãâ gólĩyî vó ũgúlı̣́ lésĩ ró, ũgũ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Lómígówá ãzâ ꞌbá yî îcî ĩyî lạ̃sı̣́ trá ạ̃ꞌdı̣́-drı̣̃ ꞌá ĩtí, rĩzó tı̣́ lâ. Pétẽrõ drí ânĩzó âtólé tı̣́ lâ ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ízámvá ãzâ rû ı̣̂ꞌbũ ꞌbá ró rî drí Pétẽrõ rî nı̣̃zó rĩrĩ lạ̃sı̣́ tı̣́ rî ꞌá. Ízámvá ꞌdĩ drí Pétẽrõ rî âꞌdázó õjílã ãzâ ꞌbá yî drí tã âtázó kĩ nĩ rî, “Ãgô nõ gólĩyî Yésũ yí bê ãlô.” ");
INSERT INTO avu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pétẽrõ gã tı̣̂ trá dó kĩ nĩ rî, “Má nı̣̃ı̣́ ãgô ꞌdĩ kô.” ");
INSERT INTO avu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gõꞌdá kpá ꞌdĩî rî vósĩ rî, õjílã ãzâ drí kpá ânĩzó tã âtálé Pétẽrõ drí kĩ nĩ rî, “Má nı̣̃ trá kĩ, nî rĩꞌá ãlô Yésũ bê rî ꞌbá yî ꞌásĩ rî ĩꞌdî.” Pétẽrõ kĩ, “ꞌÉꞌẽ, âꞌdó mâ ĩꞌdî kô.” ");
INSERT INTO avu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Gõꞌdá ꞌdĩî rî vólé drı̣̃ lâ ꞌê cé ı̣̃tú-pá ãlô, õjílã ãzâ drí kpá ânĩzó kĩ nĩ rî, “Tã pạ̃tı̣́ı̣̃ ró, ãgô nõ gólĩyî Yésũ bê. Nĩ ndrê gólâ Gãlĩláyã lé ꞌbá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pétẽrõ kĩ, “ꞌDĩî õnjõ ꞌî.” Drẽ Pétẽrõ rĩꞌá tã âtáꞌá yí sı̣́lı̣́ nõtí nõ rî, ꞌạ̃ꞌú-lúgú trá cı̣́rı̣̃ ꞌbẽꞌá. ");
INSERT INTO avu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kúmú Yésũ drí lı̣̃fı̣́ âjázó mbı̣̂ võ ndrẽlé Pétẽrõ ngálâ. Kôrô Pétẽrõ drí tã Yésũ drí âtálé yí drí rî ı̣̂sũzó kĩꞌá nĩ rî, ꞌạ̃ꞌú-lúgú õtírĩ cı̣́rı̣̃ ꞌbẽê ãndrõ nô rî, gólâ gã íyî tı̣̂ trá ândâlâ nâ rî. ");
INSERT INTO avu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gõꞌdá Pétẽrõ drí ngãzó nĩlí vólé ạ̃ꞌdı̣́-drı̣̃ ꞌdî ꞌásĩ, rĩꞌá ãwó ngõlé rõô tã ı̣̂sũ-ı̣̂sũ bê tã õnjí íyíkâ ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Gõꞌdá ngạ́cı̣̂ ãlô-ãlô ꞌdĩ sĩ rî, lómígówá gólĩyî rĩ ꞌbá Yésũ rî vó ndrẽlé rî, rî ĩyî trá zãâ Yésũ rî lôꞌdálé kpá rĩꞌá gólâ rî cãlé. ");
INSERT INTO avu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ômbê ĩyî ítá trá gólâ lı̣̃fı̣́ kĩ nĩ rî, “Ní âꞌdô õzõ tã ậngũ ꞌbá kâtí rî, ní âꞌdâ ãmâ drí, ãꞌdî rî ánî cãlé ngbãângbânõ rî nĩ yã?” ");
INSERT INTO avu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Rî ĩyî trá zãâ tã ãzâ õnjî-õnjî âtálé gólâ drí. ");
INSERT INTO avu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngá drí ậwúrı̣̃ ꞌá, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî êꞌbê ĩyî rû trá gólĩyî âꞌdó ꞌbá sı̣́sı̣́-lésĩ rî ꞌbá yí bê gõꞌdá kpá lãꞌbí îmbá ꞌbá rî ꞌbá yí bê võ ãlô ꞌá. Ódrí nĩzó Yésũ rî ậdrı̣̃lı̣́ ꞌbãlé gólĩyî ágálé. ");
INSERT INTO avu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Gólĩyî drí Yésũ rî îjízó kĩ nĩ rî, “Õzõ ní ãꞌdô ĩꞌdî Ôvârí drí âjólé ꞌdíyî pã ꞌbá ró rî, ní âtâ tã lâ ãmâ drí.” Yésũ âtâ trá gólĩyî drí kĩ nĩ rî, “Õzõ má ãâtâ ãnî drí ngbãângbânõ kĩꞌá nĩ rî, mâ ĩꞌdî nõô rî, nĩ lẽé tã-drı̣̃ lâ kô, nĩ âkĩꞌá nĩ rî, âꞌdô õnjõ ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Õzõ má ĩîjî tã ãnî tı̣́ rî, nĩ lôgõó võ lâ má drí kpá kô. ");
INSERT INTO avu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gõꞌdá ngbãângbânõ rî, tã pạ̃tı̣́ı̣̃ ró, mâ âjólé Ôvârí ngá lésĩ nô, âꞌdô fí gõꞌá, rĩlí Ôvârí mbârâkã lı̣́pı̣̂ ró rî gãrã drı̣̃ lâ ꞌá drı̣́-ágó lâ lésĩ ró.” ");
INSERT INTO avu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gólĩyî kĩ nĩ rî, “Nî ĩꞌdî Ôvârí rî mvá ꞌî yã? Ní âtâ ãmâ drí.” Yésũ kĩ, “Ĩꞌdî ꞌdĩ õzõ ãnî drí âtálé ꞌdĩ tí.” ");
INSERT INTO avu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gõꞌdá gólĩyî âtâ ĩyî kĩ nĩ rî, “Ãmâ tã ı̣̂sũ ãzâ ãkó õjílã ãzâ ậzı̣́lı̣́ ãmâ ạ̃lı̣́pı̣̂ ró. Gõꞌdá mã ârî trá gólâ sı̣́lı̣́ sĩ, âtâ trá íyî tı̣̂ sĩ kĩ nĩ rî, yí âꞌdô Ôvârí ĩꞌdî. ꞌDĩî rĩꞌá tã õnjí ꞌî, mã fû gólâ vólé.” ");
INSERT INTO avu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Gõꞌdá ꞌdĩî vósĩ rî, drílĩyî Yésũ rî âjízó kúmú Pĩlátõ ágálé. ");
INSERT INTO avu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Gólĩyî drí rĩzó ícícíyá ꞌẽlé gólâ rú kĩ nĩ rî, “Ãgô nõ sõ tã trá õjílã ãmákâ ꞌá kĩ nĩ rî, gólĩyî õgî ômbê kô ãnî gólĩyî ngá ãtrâ ró rî ꞌbá yî drí. Gõꞌdá gólâ kĩ nĩ rî, yí âꞌdô kpá ꞌdíyî pã ꞌbá gólâ tíbê Ôvârí drí tã lâ âtálé, yí âꞌdô âjóꞌá lâ ãngó ꞌá nõngá ꞌbãlé kúmú ãmákâ ró rî ĩꞌdî. Ní fû gólâ vólé.” ");
INSERT INTO avu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Gõꞌdá Pĩlátõ îjî Yésũ trá kĩ nĩ rî, “Nî ĩꞌdî kúmú ꞌî õrĩ Yúdạ̃ yí kâ drı̣̃ı̣̂ yã?” Yésũ lôgõ tã trá Pĩlátõ drí kĩ nĩ rî, “Rĩꞌá õzõ ní drí âtálé nĩ ꞌdî kâtí.” ");
INSERT INTO avu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Gõꞌdá Pĩlátõ ârî ícícíyá ꞌdĩ ꞌbá yî bê ndrĩ rî, âtâ tã trá drı̣̃-ꞌbá sı̣́sı̣́-lésĩ rî ꞌbá yî drí õꞌbí ãmbá ꞌdĩ ꞌbá yí bê kĩ nĩ rî, “Má âtâ ãnî drí nõ, ãgô nõ ꞌé tã õnjí ãzâ ãlôlâ kô.” ");
INSERT INTO avu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gõꞌdá õjílã gólĩyî ícícíyá ꞌbá ꞌdĩ ꞌbá yî rî ĩyî trá zãâ sõlé tã bê kĩ nĩ rî, Yésũ õrî õjílã ꞌâ îngálé, lı̣̃fı̣́ îcílí tã õnjí ꞌẽlé ĩꞌdî îtónãlé ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî ꞌásĩ ndrĩ bũúũ âcálé nõngá Yẽrõsãlémã ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Gõꞌdá Pĩlátõ ârî tã ꞌdî bê ĩtí rî, gólâ îjî gólĩyî trá kĩ nĩ rî, “Yésũ ꞌdĩ Gãlĩláyã lé ꞌbá ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gõꞌdá Ẽródẽ ĩꞌdî kúmú ꞌî Gãlĩláyã lé ꞌbá yî drı̣̃lı̣́. Gõꞌdá kậyı̣̂ nã ꞌbá yî sĩ rî, Ẽródẽ kpá trá ânĩꞌá ũmũ tõlé Yẽrõsãlémã ꞌálâ, gõꞌdá Pĩlátõ drí Yésũ rî jõzó ícícíyá ꞌbá ꞌdĩ ꞌbá yí bê ndrĩ Ẽródẽ ngálâ gólâ õkî ró tã gólĩyíkâ. ");
INSERT INTO avu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kậyı̣̂ ãmbá ꞌdĩ ꞌbá yî sĩ rî, Ẽródẽ ꞌê trá lạ́tı̣̂ lôndãlé ꞌẽzó Yésũ rî ndrẽlé tã lârâkô drílâ rĩꞌá ꞌẽlâ ꞌdĩ ꞌbá yí bê, gõꞌdá Ẽródẽ trá ãyĩkõ ró ãmbá Pĩlátõ bê Yésũ rî âjólé yí ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ẽródẽ îjî Yésũ trá tã îjî-îjî ãzâ ꞌbá yî sĩ dũû, gõꞌdá Yésũ âtá úlı̣́ ãzâ kô ãlôwálâ. ");
INSERT INTO avu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî lãꞌbí îmbá ꞌbá ãzâ ꞌbá yí bê, rî ĩyî trá zãâ ícícíyá ꞌẽlé Yésũ rú kôrô. ꞌÂ lâ yî drí ngãzó õmbã bê gólâ rú. ");
INSERT INTO avu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ẽródẽ yî ạ̃jú ꞌbũ ꞌbá íyíkâ rî yí bê, rî ĩyî trá Yésũ rî lôꞌdálé rĩzó lârâkô lâ ꞌẽlé, drílĩyî ítá nyạ̃rũ-nyạ̃rũ sõzó Yésũ rú õzõ ítá kúmú kâ kâtí ꞌdásí ró. Drílĩyî Yésũ rî jõzó lôgõlé vólé Pĩlátõ ngálâ. ");
INSERT INTO avu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kậyı̣̂ ꞌdĩ sĩ rî, Ẽródẽ yî Pĩlátõ bê, drílĩyî ꞌbãzó zãâ rû-lẽ-ãzí ró. Kó drẽ ạ̃kû rî, gólĩyî lẽé ĩyî rû ĩyî lãfálé ꞌásĩ kô. ");
INSERT INTO avu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Gõꞌdá Pĩlátõ drí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ậzı̣́zó gólĩyî sı̣́sı̣́-lésĩ ꞌdî ꞌbá yí bê ꞌdó, gõꞌdá drílâ õjílã ndrĩ kpá zı̣̃zó võ ãlô ꞌá, ");
INSERT INTO avu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tã âtázó drílĩyî kĩ nĩ rî, “Nĩ âjî Yésũ trá má ngálâ ícícíyá ꞌẽzó rú lâ má drí kĩ nĩ rî, gólâ õrî õjílã âdólé. Gõꞌdá mâ rî gógó, má rî bê ndrẽlâ rî, má ûsú tã õnjí gólâkâ kô, ícícíyá ãníkâ ꞌdĩ tã ífí ãkó. ");
INSERT INTO avu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ẽródẽ ı̣̂sũ tã kpá ĩtí, tãlâ âjô Yésũ kpá trá lôgõlé má ngálâ. Nĩ ndrê trá gólâ ꞌé tã õnjí kô, má lẽé kô gólâ rî fũlı̣́ cú ĩtí. ");
INSERT INTO avu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ãꞌdô trá ĩtí rî, má lẽ trá gólâ rî âyélé. Sı̣́sı̣́ má âꞌdô õjílã ꞌbãꞌá gólâ rî cãlé ônjóróꞌbí sĩ ãnî drí.” ");
INSERT INTO avu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gõꞌdá õjílã ꞌdî ꞌbá yî ângbâ ĩyî trá ꞌdó tã bê kĩ nĩ rî, “Ní fû gólâ vólé, gólâ tíbê ãmâ drí lẽlé lôfõlé ãmâ drí rî Bãrábã ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bãrábã nõ rî, óꞌbã gólâ gạ̃nı̣́mạ̃ ꞌá, tãlâ gólâ fû õjílã trá, gólâ sõ tã kpá trá õjílã ꞌâ ngá ãtrâ rõzó kô. ");
INSERT INTO avu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gõꞌdá Pĩlátõ âtâ trá õꞌbí ãmbá ꞌdĩ ꞌbá yî drí óꞌdí kĩ nĩ rî, yí lẽ trá Yésũ rî âyélé, yí lẽé gólâ rî fũlı̣́ kô. ");
INSERT INTO avu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gõꞌdá drílĩyî kpá ôtrézó tã bê óꞌdí kĩ nĩ rî, “Ní fû gólâ vólé fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kpá Pĩlátõ drí õꞌbí ãmbá ꞌdĩ ꞌbá yî îjízó óꞌdí kĩ nĩ rî, “Tãlâ ãꞌdô ꞌî nĩ lẽ Yésũ rî fũlı̣́ yã? Nĩ âꞌdâ drẽ tã õnjí gólâ drí ꞌẽlé rî má drí. Má kĩ nĩ rî, gólâ ꞌé tã õnjí kô, má lẽ cé gólâ rî cãlé ĩꞌdî, gólâ rî âyézó.” ");
INSERT INTO avu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gõꞌdá õꞌbí ãmbá ꞌdĩ ꞌbá yî drí ângbázó ôtrê-ôtrê bê kĩ nĩ rî, “Ní fû gólâ! Ní îpâ gólâ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂!” Gõꞌdá gólĩyî ôtrê trá rõô. ");
INSERT INTO avu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pĩlátõ drí tã gólĩyíkâ drı̣̃ lâ lẽzó, ");
INSERT INTO avu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bãrábã rî lôfõzó gạ̃nı̣́mạ̃ ꞌásĩ gõꞌdá Yésũ rî fũzó, õzõ tã gólĩyî drí lẽlé rî tí. ");
INSERT INTO avu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí Yésũ rî sẽzó vólé nĩngá sĩ. Lạ́tı̣̂ ꞌá rî, drílĩyî kpá ãgô ãzâ rú bê Sĩmónã rî ûsúzó. Sĩmónã gólâ Kĩrénẽ lé ꞌbá ꞌî. Sĩmónã rî nĩꞌá Yẽrõsãlémã ꞌálâ ꞌbạ̃drı̣̃ mvá íyíkâ rî lésĩ. Drílĩyî Sĩmónã rî ꞌbãzó mbârâkã sĩ fê lậlı̣̂-lậlı̣̂ êdélé Yésũ rî îpázó drı̣̃ lâ nã njı̣̃lı̣́ Yésũ bê. ");
INSERT INTO avu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Gõꞌdá õꞌbí ãmbá ꞌdĩ ꞌbá yî drí ꞌdẽzó ĩyíkâ gólĩyî vó. Õkó ãzâ ꞌbá yî kpá tólâ rî ĩyî trá ãwó ngõlé ãmbá Yésũ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yésũ drí lı̣̃fı̣́ âjázó vólé gólĩyî ndrẽlé, tã âtázó drílĩyî kĩ nĩ rî, “Ãnî mvá Yẽrõsãlémã kâ rî yî, nĩ ngô ãwó ámâ tãsĩ kô, nĩ ngô ãwó ãnî ífífí tãsĩ kpá ãnî mvá yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ị̃zạ́tú rî, ĩzã ạ́ngı̣́ âꞌdô ãnî ꞌẽꞌá. Ị̃tú ĩzã kâ ꞌdĩ sĩ rî, nĩ âꞌdô tã ı̣̂sũꞌá kĩ nĩ rî, ‘Ãꞌdî kĩ tí mã ũtı̣́ mvá gbõ kô, mã rî ró ãmângá óndó ró mvá ãkó, mã õzó rĩî ĩzã ndrẽlé ãmâ mvá yî rú drílĩyî drãrẽ ꞌá.’ ");
INSERT INTO avu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","‘Nĩ âꞌdô tã îjíꞌá kúnı̣́ tı̣́ kĩ nĩ rî, yĩ õfî ró ĩyî lậpı̣́lı̣́ ũgı̣́ lâ ꞌá, gõꞌdá îcá kpá kô.’ ");
INSERT INTO avu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Õzõ lâŋõ ꞌdî õꞌê mâ gólâ tã õnjí ꞌẽ ꞌbá kô rî trá rî, lâŋõ âꞌdô ꞌẽꞌá âꞌdólé õjílã gólĩyî tã õnjí ꞌẽ ꞌbá kôrô rî yî drı̣̃ı̣̂ lậvũlı̣́ gạ̃rạ̃. Ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Gõꞌdá ãgô ãzâ ꞌbá yî kpá rı̣̃, ãgô ꞌdĩ ꞌbá yî ngá ôpá ꞌbá yî ĩꞌdî, ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî trõ ĩyî kpá trá nĩꞌá îpálâ Yésũ bê fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ sĩ fũlı̣́ vólé, võ ãzâ kó õjílã fũ kâ rĩꞌá zı̣̃lı̣́ ãvõ drı̣̃-fã rî ꞌálâ. Íîpâ Yésũ trá gólĩyî lãfálé ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Gõꞌdá ꞌdĩî vósĩ rî, Yésũ drí tã âtázó Ôvârí drí kĩ nĩ rî, “Ámâ átá, ní âyê õjílã gólĩyî ámâ fũ ꞌbá nõ ꞌbá yî, tãlâ gólĩyî nı̣̃ı̣́ kô kĩꞌá nĩ rî, mâ ánî mvá ní drí âjólé gólĩyî pãlé rî ĩꞌdî.” Ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî lânjî ítá Yésũ kâ trá ĩyî võ ꞌásĩ, gõꞌdá ãzâ tãndí rî âtrõzó vũlı̣́ gõmárĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Õꞌbí ãmbá ꞌdĩ ꞌbá yî rî ĩyî trá ndrẽlâ. Drı̣̃-ꞌbá Yúdạ̃ yí kâ rî ꞌbá yî rî ĩyî trá ꞌdásí ꞌẽlé Yésũ rú kĩ nĩ rî, “Nĩ ndrê drẽ, gólâ rî íyíkâ ãzí-ãzí pãlé, gõꞌdá pá íyî ífífí kô ãꞌdô drí yã? Gólâ âꞌdó kô ĩꞌdî ꞌdíyî pã ꞌbá tíbê Ôvârí drí zĩlí nĩ rî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî ꞌê ĩyî ꞌdásí kpá trá Yésũ rú, drílĩyî õdrá ĩdrí fẽzó Yésũ drí mvũlı̣́. ");
INSERT INTO avu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Gólĩyî kĩ nĩ rî, “Õzõ ní ãꞌdô ĩꞌdî kúmú ꞌî õjílã Yúdạ̃ yí kâ rî drı̣̃lı̣́ mbârâkã bê kôrô rî, ní pâ ánî ífífí.” ");
INSERT INTO avu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Áâtâ tã ꞌdî ĩtí, tãlâ õjílã ãzâ îgĩ trá fê lậlı̣̂-lậlı̣̂ ꞌdĩ drı̣̃ı̣̂ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ngá ôpá ꞌbá ãzâ ãlô îpálé Yésũ bê rî ꞌê ꞌdásí kpá trá kĩ nĩ rî, “Õzõ ní ãꞌdô ꞌdíyî pã ꞌbá Ôvârí ngá lésĩ rî ĩꞌdî rî, ní pâ ánî ífífí ãmá bê ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gõꞌdá ngá ôpá ꞌbá ãzâ gólâ îpálé ꞌdó võ ãlô ꞌá Yésũ yí bê rî kĩ nĩ rî, “Ní ró Ôvârí kô, ní drí tã âtázó drílâ ĩtí ꞌdĩ yã? Ní kpá rĩꞌá ĩzã ꞌẽꞌá gólâ tí, ");
INSERT INTO avu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","gõꞌdá mã rî ãmákâ ĩzã ꞌẽlé nõ tã ꞌẽꞌẽ õnjí ãmákâ rî drí. Gõꞌdá gólâ ꞌé tã õnjí ãzâ kô.” ");
INSERT INTO avu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Gõꞌdá ngá ôpá ꞌbá ꞌdĩ drí tã âtázó Yésũ drí kĩ nĩ rî, “Yésũ, ní ꞌbã ámâ tã ũvı̣̃ kô õzõ ní õtírĩ âgõô ãngó nõ ꞌá kúmú ró rî.” ");
INSERT INTO avu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Gõꞌdá nĩngá sĩ, Yésũ kĩ gólâ drí rî, “Tã pạ̃tı̣́ı̣̃ ró, má âtâ ní drí, ní âꞌdô ꞌbãꞌá má bê võ ûrú ꞌálâ rî ꞌá ãndrõ nô.” ");
INSERT INTO avu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Gõꞌdá ꞌdĩî rî vósĩ rî, ı̣̃tú-pá mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ ı̣̃tú-ạ̃yı̣́ ꞌdĩ sĩ, ı̣́nı̣́rı̣́kúwạ́ drí ꞌbạ̃drı̣̃ lîmózó ndrĩ cãlé bũúũ ı̣̃tú-pá nâ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jẽjẽ ró, jó ạ́ngı̣́ Ôvârí kâ nã ꞌálâ rî, ítá gólâ tíbê ômbélé jó mvá õjílã drí cãzó ꞌá lâ kô rî ꞌá, drílâ sĩzó kpẽrẽ ûrú lésĩ bũúũ vũdrı̣́ zãlô rı̣̃. ");
INSERT INTO avu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gõꞌdá Yésũ drí trẽzó ãmbá ûrû Ôvârí drí kĩ nĩ rî, “Tátá, má fẽ ámâ lôvó-lôvó ní drı̣́gạ́.” Nĩngá sĩ, kôrô Yésũ drí drãzó. ");
INSERT INTO avu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Gõꞌdá drı̣̃-ꞌbá gólâ ãmbá ạ̃jú ꞌbũ ꞌbá kâ ꞌbãlé gólĩyî vó ndrẽlé ꞌdĩ rî ndrê tã ꞌdî bê ĩtí rî, drílâ Ôvârí rî lûyı̣́zó kĩ nĩ rî, “Tã pạ̃tı̣́ı̣̃ ró, ãgô nõ tã mbı̣̂ ꞌbá ꞌî, úfû gólâ nõ cú ĩtí.” ");
INSERT INTO avu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kpá õꞌbí ãmbá nõ ꞌbá yî ndrê ĩyî tã ꞌdî bê ĩtí rî, drílĩyî gõzó ĩyî ꞌbã ꞌálâ, ạ́gạ́sı̣́ sãsã bê tã ı̣̂sũ-ı̣̂sũ ãmbá ꞌdĩ drí sĩ. ");
INSERT INTO avu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gõꞌdá Yésũ rî rû-lẽ-ãzí yî õkó gólĩyî ânĩ ꞌbá gólâ rî âjílí Gãlĩláyã lésĩ rî ꞌbá yí bê, âdrê ĩyî trá jẽjẽ ró Yésũ rî ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nĩngá sĩ, ãgô ãzâ rĩꞌá, rú lâ Yõsépã, gólâ Ãrãmãtáyã lé ꞌbá ꞌî. Gólâ ĩꞌdî drı̣̃-ꞌbá Yúdạ̃ yí kâ. Gólâ ĩꞌdî rĩꞌá õjílã tãndí ꞌî. Gólâ lẽé tã-drı̣̃ kô Yésũ rî fũzó. Gólâ lẽ tã trá pạ̃tı̣́ı̣̃ kĩ, Yésũ ĩꞌdî tíbê âjólé Ôvârí ngá lésĩ ró rî ĩꞌdî ꞌbãlé õjílã drı̣̃ı̣̂ kúmú ró. ");
INSERT INTO avu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Gólâ nĩ trá Pĩlátõ rî îjílí Yésũ rî ãvõ tãsĩ, yí õtrõ ró bê ꞌbãlé. ");
INSERT INTO avu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pĩlátõ lẽ tã-drı̣̃ trá drílâ, Yésũ rî ãvõ ângízó fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ sĩ, ítá tãndí mvẽêmvê sõzó rú lâ. Gólĩyî ꞌbã Yésũ rî ãvõ trá ũgı̣́ ꞌá kãtrã-kãtrã ró, gólâ ndẽé êdê-êdê lâ ndrĩ kô, tãlâ ı̣̃tú trá fĩꞌá. Õꞌbãá drẽ õjílã ãzâ kó ũgı̣́ ꞌdĩ ꞌá kô sı̣́sı̣́ lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kậyı̣̂ ꞌdĩ gímã vólé drı̣̃ı̣̂ njı̣̂ ꞌî, kậyı̣̂ rî ꞌdĩ rĩꞌá kậyı̣̂ õjílã drí rĩzó ĩyî êdélé nĩzó rãtáã ꞌẽlé rî ĩꞌdî. Îcá kô ngá ꞌẽzó kậyı̣̂ rãtáã ꞌẽzó rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Õkó gólĩyî Yésũ rî âjí ꞌbá Gãlĩláyã lésĩ rî ꞌbá yî ꞌdê ĩyî trá zãâ Yõsépã yî vó bũúũ võ Yésũ rî ꞌbãzó ũgı̣́ ꞌá rî ꞌálâ, tãlâ yĩ âgõ ró bê kậyı̣̂ rãtáã kâ vósĩ Yésũ rî ãvõ êdélé. ");
INSERT INTO avu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Drílĩyî gõzó âgõlé vólé ꞌbạ̃drı̣̃ mvá nã ꞌálâ ãlókõ ãzâ ꞌbá yî ꞌbạ̃drı̣̃ kâ êdélé dõ bê ãvõ lâ ı̣̂nı̣́zó kpá nĩꞌá ãwó ngõlé, ı̣̃drú cı̣̃ı̣́nó rî tí, gõꞌdá rãtáã ꞌẽzó, tãlâ ꞌdĩî trá tã ꞌbãꞌbã ꞌî, ótó ậcı̣́ kô. ");
INSERT INTO avu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kậyı̣̂ gólâ rãtáã kâ ꞌdĩ vósĩ, ãkpãkãꞌdã ngá drí ậwúrı̣̃ ꞌá, võ pạ̃nı̣̃-pạ̃nı̣̃ rî, õkó ꞌdĩ ꞌbá yî ngâ ĩyî trá gõlé võ gólâ Yésũ rî ãvõ ꞌbãzó ũgı̣́ ꞌá rî ꞌálâ êdélâ ãlókõ sĩ dõ yí bê. ");
INSERT INTO avu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Gõꞌdá õkó ꞌdĩ ꞌbá yî câ ĩyî bê ũgı̣́ ꞌálâ rî, ndrê ĩyî ólîlî kúnı̣́ úngû ꞌbãlé tíbê ũgı̣́ tı̣́ ạ́ngı̣́ nã trá vólé ũgı̣́ tı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gólĩyî fî ĩyî bê ũgı̣́ ꞌálâ rî, ûsú ĩyî Yésũ rî ãvõ gõꞌdá võ lâ ꞌá kô. ");
INSERT INTO avu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ꞌÂ lâ yî drí gãzó. Gõꞌdá gólĩyî tı̣̂ drí kpá ậꞌdı̣́zó. Kôrô ãgô ãzâ ꞌbá yî rı̣̃ ítá lậgû-lậgû bê rî ꞌbá yî drí âdrézó ĩyî tólâ. ");
INSERT INTO avu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Õkó ꞌdĩ ꞌbá yî lârõ ĩyî trá ũrı̣̃ bê, âsõ ĩyî drı̣̃ trá vũdrı̣́. Gõꞌdá ãgô ꞌdĩ ꞌbá yî drí tã âtázó gólĩyî drí kĩ nĩ rî, “Tãlâ ãꞌdô ꞌî ãnî drí rĩzó õjílã lédrẽ-lédrẽ ró rî ndãlé võ ãvõ ꞌbã kâ rî ꞌá yã? ");
INSERT INTO avu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yésũ âtâ tã trá ãnî drí kĩ nĩ rî, yí âꞌdô ngãꞌá õdrã ꞌásĩ. Gólâ nõngá yûꞌdạ́wạ́. Nĩ ı̣̂sũ drẽ tã tíbê drílâ âtálé ãnî drí Gãlĩláyã ꞌálâ rî, gólâ âtâ tã ãnî drí kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mâ âjólé ûrú lésĩ nõ áâꞌdô ámâ drı̣́-bã fẽꞌá ạ̃wạ́lạ́kạ́ drı̣́gạ́ îpálé fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂. Má drí drãzó, kậyı̣̂ nâ ꞌá rî má drí kpá ngãzó õdrã ꞌásĩ.’ ” ");
INSERT INTO avu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Gõꞌdá tã tíbê Yésũ drí âtálé rî drí âgázó gólĩyî drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Gõꞌdá õkó ꞌdĩ ꞌbá yî drí âgõzó ũgı̣́ lésĩ vólé Yẽrõsãlémã ꞌálâ tã ꞌdî ꞌbá yî âtálé lãjóꞌbá Yésũ kâ rî yî drí rû-lẽ-ãzí lâ yî ãzâ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Õkó ꞌdĩ ꞌbá yî lãfálé sĩ rî nı̣̃lı̣́ rî Mãríyã Mãgãdálã ĩꞌdî, Jõánã gõꞌdá Mãríyã gólâ Yãkóbã rî ândré yí bê. ");
INSERT INTO avu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî ârî ĩyî tã õkó ꞌdĩ ꞌbá yî drí âtálé kĩꞌá nĩ rî, Yésũ lîdrî trá õdrã ꞌásĩ rî, gólĩyî drí tã âtázó kĩ nĩ rî, õkó ꞌdĩ ꞌbá yî âtâ ĩyî úlı̣́ âzâ-âzâ ꞌî, lẽé ĩyî úlı̣́ ꞌdĩ tã lâ ârílí kô. ");
INSERT INTO avu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Gõꞌdá Pétẽrõ drí ngãzó rãlé nĩꞌá ũgı̣́ ꞌálâ. Gõꞌdá gólâ câ bê tólâ rî, drílâ ậndı̣̃zó rĩꞌá võ ı̣̂ndrı̣́lı̣́ dĩyí ũgı̣́ ꞌálâ, gõꞌdá ndrê cé ítá tãndí gólâ ãvõ ꞌbãzó ꞌá lâ rî ĩꞌdî, ãvõ gõꞌdá yû. Gõꞌdá nĩngá sĩ, drílâ ngãzó nĩꞌá gõlé ꞌbã ꞌálâ tã ı̣̂sũ-ı̣̂sũ bê lậvũlı̣́ kôrô. ");
INSERT INTO avu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ꞌDó kậyı̣̂ ãlô ꞌdĩ ĩꞌdî, Yésũ rî rû-lẽ-ãzí yî kpá zãlô rı̣̃ rĩꞌá ĩyî nĩꞌá ꞌbạ̃drı̣̃ mvá ãzâ rĩꞌá zı̣̃lâ Ẽmáwõ rî ꞌálâ. ꞌBạ̃drı̣̃ mvá ꞌdĩ jẽjẽ lâ rĩꞌá kĩlõmítĩrĩ mûdrı̣́-drı̣̃-lâ-ngâ-ãlô Yẽrõsãlémã rú sĩ. Ãgô ãlô, rú lâ Kẽlẽópã. ");
INSERT INTO avu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Gólĩyî rĩꞌá õdrã tã Yésũ kâ rî âtáꞌá, gõꞌdá ngá nõ ꞌbá yî ꞌê rû ꞌdó vólé lésĩ. ");
INSERT INTO avu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gólĩyî drí rĩrĩ tã âtálé rî ꞌá Yésũ drí ânĩzó âcálé ãnyî gólĩyî lạ̃gạ́tı̣́ tã âtálé gólĩyí bê. ");
INSERT INTO avu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Gõꞌdá Ôvârí ꞌê ãgô ꞌdĩ ꞌbá yî gólâ rî nı̣̃lı̣́ kô. ");
INSERT INTO avu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Nĩ rî ãꞌdô tã âtáꞌá lạ́tı̣̂ ꞌásĩ yã?” Gólĩyî drí âdrézó pávó tı̣̂ ꞌá, lı̣̃fı̣́ lâ yî gõꞌdá trá ĩzã ró. ");
INSERT INTO avu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Gõꞌdá Kẽlẽópã drí tã âtázó Yésũ drí kĩ nĩ rî, “Ní ârí tã ạ́ngı̣́ rû ꞌẽ ꞌbá ậndrạ́tú Yẽrõsãlémã ꞌálâ rî kô yã?” ");
INSERT INTO avu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yésũ drí tã-drı̣̃ jãzó kĩ nĩ rî, “Ãꞌdô tã ꞌê rû nĩ yã?” Gólĩyî kĩ, “Tã gólâ Yésũ Nãzãrétã lé ꞌbá ró rî kâ. Gólâ trá tã ậngũ ꞌbá Ôvârí kâ ꞌî. Drílâ rĩzó tã tãndí âtálé dódó mbârâkã sĩ. Tã ꞌẽꞌẽ gólâkâ ndrĩ ꞌdó tã Ôvârí kâ rî vó ró. Õjílã dũû ı̣̂njı̣̃ ĩyî gólâ trá. ");
INSERT INTO avu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî rî gólĩyî sı̣́sı̣́-lésĩ rî ꞌbá yí bê, fẽ ĩyî gólâ rî drı̣́-bã trá fũlı̣́ vólé, gólâ rî îpâ-îpâ fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ sĩ rî. ");
INSERT INTO avu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mã nı̣̃ trá ãgô rî ꞌdĩ âꞌdô ãmâ pãꞌá nĩ ãmâ ạ̃jú-ꞌbá-ãzí yî drı̣́gạ́ sĩ. Gõꞌdá gólâ drã trá, ꞌê trá kậyı̣̂ rı̣̃. ");
INSERT INTO avu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gõꞌdá tã ãzâ kpá ĩꞌdî nõ, ûsú gõꞌdá ãvõ lâ ũgı̣́ ꞌá kpá kô. Cı̣̃ı̣́nó nõ õkó ãzâ ꞌbá yî ãmâ lãfálé sĩ, âtâ ĩyî úlı̣́ rũbạ́ạ̃ ãzâ trá nõngá kĩ nĩ rî, yĩ õnĩ bê ũgı̣́ gólâ Yésũ rî ãvõ ꞌbãzó rî ndrẽlé rî, ");
INSERT INTO avu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yĩ ûsú gólâ rî ãvõ ꞌá lâ kô. Gólĩyî drí âgõzó vólé tã lâ âtálé ãmâ drí, yĩ õndrê mãlãyíkã ꞌî gólâ rî võ ꞌá tólâ. Gõꞌdá mãlãyíkã ꞌdî drí tã âtázó ĩyî drí kĩ nĩ rî, ‘Yésũ âꞌdô bê lédrẽ-lédrẽ ró.’ ");
INSERT INTO avu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Gõꞌdá ãgô ãzâ ꞌbá yî ãmâ lãfálé sĩ rî drí kpá nĩzó ũgı̣́ gólâ rî ꞌbãzó ꞌá lâ ꞌdĩ ndrẽlé rî, ûsû ĩyî tã kpá té õzõ õkó ꞌdĩ ꞌbá yî drí âtárẽ lâ tí, ûsú ĩyî gólâ rî ãvõ kô.” ");
INSERT INTO avu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Gõꞌdá nĩngá sĩ, Yésũ kĩ nĩ rî gólĩyî drí rî, “Ãnî gólĩyî tíbê tã nı̣̃ ꞌbá kôꞌdáwá nõ ꞌbá yî, nĩ lẽé kô úlı̣́ gólĩyî tíbê tã ậngũ ꞌbá drí îgĩlí ãnî drí rî ârílí yã? ");
INSERT INTO avu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tã ậngũ ꞌbá âtâ trá kĩ nĩ rî, ı̣̃zạ́tú rî, gólâ tíbê Ôvârí drí zĩlí nĩ ꞌdíyî pã ꞌbá ró rî âꞌdô rû îzãꞌá ĩtí, gõꞌdá Ôvârí drí gólâ rî ꞌbãzó kpá mbârâkã bê gạ̃rạ̃ kúmú ạ́ngı̣́ ró.” ");
INSERT INTO avu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Gõꞌdá Yésũ drí tã gólâ Músạ̃ yî drí îgĩlí tã ậngũ ꞌbá bê tã íyíkâ rî tãsĩ rî ífí lâ âtázó drílĩyî. ");
INSERT INTO avu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Gõꞌdá gólĩyî câ ĩyî bê Ẽmáwõ ꞌá rî, Yésũ ꞌê trá zãâ nĩlí sı̣́sı̣́ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Gõꞌdá îkî ĩyî Yésũ trá tã âtázó drílâ kĩ nĩ rî, “Ní rî ãmá bê nõngá. Ní ndrê, ı̣̃tú trá fĩꞌá.” Gõꞌdá Yésũ drí ânĩzó âfílí jó ꞌá gólĩyí bê rĩlí. ");
INSERT INTO avu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Gólâ rî trá vũdrı̣́ ngá nyãlé gólĩyí bê. Gõꞌdá trõ ãmbãtã trá, drílâ rãtáã ꞌẽzó Ôvârí drí, gõꞌdá drílâ ûpı̣̃zó lâ cíkírĩnyáwá ró ĩtí fẽlé gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ngbãângbânõ rî, Ôvârí njı̣̃ gólĩyî rî lı̣̃fı̣́ trá Yésũ rî nı̣̃lı̣́. Gõꞌdá Yésũ drí íyîngá ậvı̣̃zó. ");
INSERT INTO avu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gõꞌdá ãgô ꞌdĩ ꞌbá yî drí tã âtázó ĩyî võ ꞌásĩ kĩ nĩ rî, “Ãgô ꞌdĩ fí té Yésũ rî ífífí ĩꞌdî. Ãmâ trá ãyĩkõ ró gólâ drí tã âtárẽ ãmâ drí lạ́tı̣̂ ꞌá, kpá tã gólâ drí tã lâ îgĩlí ꞌdĩ ꞌbá yî ífí lâ lôfõrẽ ãmâ drí rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kôrô gólĩyî drí ngãzó ûrû, nĩꞌá gõlé vólé Yẽrõsãlémã ꞌálâ. Gõꞌdá gólĩyî câ ĩyî bê rî, ûsû ĩyî lãjóꞌbá Yésũ kâ mûdrı̣́-drı̣̃-lâ-ngâ-ãlô ꞌdĩ ꞌbá yî êꞌbê ĩyî rû trá ꞌdó võ ãlô ꞌá, ĩyî rû-lẽ-ãzíyã yí bê. ");
INSERT INTO avu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Lãjóꞌbá ꞌdĩ ꞌbá yî kĩ nĩ rî gólĩyî drí rî, “Ãwô-ĩtí Yésũ lîdrî trá õdrã ꞌásĩ, gólâ âꞌdâ yî trá Sĩmónã Pétẽrõ drí.” ");
INSERT INTO avu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gõꞌdá ãgô rı̣̃ nã ꞌbá yî âtâ ĩyî kpá gólĩyî drí, tã tíbê rû ꞌẽ ꞌbá lạ́tı̣̂ ꞌá drílĩyî ndrẽlé rî tãsĩ, gõꞌdá kpá drílĩyî Yésũ rî nı̣̃zó drílâ rĩrĩ ãmbãtã ûpı̣̃lı̣́ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nĩngá sĩ, kôrô Yésũ rî gógó drí âdrézó gólĩyî lãfálé tã âtálé gólĩyî drí kĩ nĩ rî, “Ãnî pı̣̃pı̣̂sı̣́lı̣́ ạ̃ậꞌdı̣̂.” ");
INSERT INTO avu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî lârõ ĩyî trá, rî ĩyî trá ꞌdó tı̣́tı̣́ ũrı̣̃ bê, tãlâ gólĩyî ı̣̂sũ ĩyíkâ bê rî, Yésũ âꞌdô ꞌbúlı̣́-ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Nĩ rî ũrı̣̃ ꞌẽlé ãꞌdô drí sĩ yã? Nĩ rî tã ı̣̂sũlı̣́ rı̣̃ rı̣̃ kĩꞌá nĩ rî, âꞌdó mâ ĩꞌdî kô rî ãꞌdô drí sĩ yã? ");
INSERT INTO avu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Nĩ ndrê drẽ ạ̃lı̣́bı̣́ ámâ drı̣́ ꞌá, ámâ pá bê. Mâ rî gógó ĩꞌdî rĩꞌá nõ. Nĩ ậnjû drẽ ámâ rúꞌbạ́. Nĩ ndrê drẽ, ꞌbúlı̣́-ꞌbá cú ĩtí ĩnyĩrĩkõ ãkó kpá fã ãkó, mâ rĩꞌá cú ĩnyĩrĩkõ bê gõꞌdá kpá fã bê.” ");
INSERT INTO avu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Gólĩyî ꞌâ gâ trá, líndrí lâ yî ꞌbê trá dı̣̃, tãlâ tã ꞌdî trá õzõ tã lârâkô tã lẽzó ꞌá lâ kô rî kâtí. Gõꞌdá Yésũ drí tã âtázó gólĩyî drí kĩ nĩ rî, “Ãnî cú ngá nyãnyã bê âfẽlé má drí nyãlé yã?” ");
INSERT INTO avu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Gõꞌdá gólĩyî drí ı̣̃ꞌbı̣̂ lâꞌdî-lâꞌdî âfẽzó Yésũ drí nyãlé. ");
INSERT INTO avu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yésũ drí gõzó ı̣̃ꞌbı̣̂ ꞌdĩ nyãlé gólĩyî lı̣̃fı̣́ drı̣̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó gólĩyî drí, “Ãnî, nĩ ı̣̂sũ tã tíbê má drí âtálé ãnî drí, má drí ꞌbãzó drẽ ãní bê ꞌbạ̃drı̣̃ ꞌá nõngá rî ꞌá rî trá yã? Má âtâ tã trá ãnî drí kĩ, tã gólĩyî Músạ̃ yî drí îgĩlí ámâ tãsĩ, tã ậngũ ꞌbá yí bê, kpá tã ndrĩ lôꞌbãzó lôngó sĩ rî âꞌdô rû ꞌẽꞌá trá.” ");
INSERT INTO avu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gõꞌdá ꞌdĩî vósĩ rî, Yésũ âtâ bê tã ꞌdî rî, gólâ drí gólĩyî ꞌbãzó nı̣̃lâ lı̣̃fı̣́ îcî úlı̣́ Ôvârí kâ búkũ ꞌá rî kâ rî sĩ, gólĩyî ũnı̣̃ ró tã ífí lâ bê dódó. ");
INSERT INTO avu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Gõꞌdá drílâ tã âtázó gólĩyî drí, “Ôvârí âtâ trá tã ậngũ ꞌbá drí kĩ, gólâ tíbê âjólé ûrú lésĩ ꞌdíyî pã ꞌbá ró rî, ĩzã âꞌdô gólâ rî ꞌẽꞌá, drílâ drãzó, gõꞌdá kậyı̣̂ nâ ꞌá rî, gólâ drí lîdrízó õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ꞌDĩî rî vósĩ rî, õjílã ãzâ ꞌbá yî âꞌdô ĩyî tã lâ pẽꞌá õrĩ ãmbá ãngó ꞌá nõ ꞌbá yî drí kĩ nĩ rî, gólĩyî tíbê drı̣̃ âjá ꞌbá trá tã ꞌẽꞌẽ õnjí ĩyíkâ ꞌásĩ rî, Ôvârí âꞌdô gólĩyî âyéꞌá tã õnjí gólĩyíkâ ꞌásĩ ꞌdíyî pã ꞌbá rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ãnî ífífí ĩꞌdî ꞌẽ ꞌbá tã ámákâ pẽlé rî, tãlâ ãnî rî gógó rî ndrê tã rû ꞌẽ ꞌbá rî cú nĩ ãnî lı̣̃fı̣́ ífífí sĩ. ");
INSERT INTO avu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ámâ ífífí âꞌdô Líndrí Tãndí Ôvârí kâ tíbê ámâ átá drí tã lâ âtálé rî âjóꞌá ãnî pãlé. Nĩ rî drẽ tãkõ Yẽrõsãlémã ꞌá nõngá tẽlâ té drílâ âcázó nĩ. Gõꞌdá kpá mbârâkã Ôvârí kâ âꞌdô âcáꞌá rĩlí ãní bê.” ");
INSERT INTO avu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Gõꞌdá nĩngá sĩ rî, Yésũ drí gólĩyî lôfõzó ꞌbạ̃drı̣̃ mvá nã ꞌásĩ, nĩlí ãnyî ꞌbạ̃drı̣̃ mvá ãzâ ꞌálâ Bẽtánĩ rú. Gõꞌdá drílâ õrẽ fẽzó drílĩyî. ");
INSERT INTO avu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Gõꞌdá Yésũ fẽ õrẽ bê gólĩyî drí ndrĩ rî, Ôvârí drí Yésũ rî trõzó nĩlí võ ꞌbũû ꞌálâ ûrú ꞌálâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nĩngá sĩ, gólĩyî drí ãwô-ĩtí ãmbá ꞌẽzó Yésũ drí gólâ rî lûyı̣́zó Ôvârí ró. Gõꞌdá drílĩyî âgõzó vólé Yẽrõsãlémã ꞌálâ ãyĩkõ ró ãmbá. ");
INSERT INTO avu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Gólĩyî rî trá Ôvârí rî lûyı̣́lı̣́ ı̣̃tú vósĩ cé ĩyî pı̣̃pı̣̂sı̣́lı̣́ sĩ jó ạ́ngı̣́ Ôvârí kâ rî ꞌá.");
INSERT INTO avu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Drẽ ãkpãkãꞌdã sı̣́sı̣́ óꞌbãá ãngó nõ drẽ kô rî, “‘Ôvârí rî âꞌdá ꞌbá”’ bê rĩꞌá Ôvârí bê. Gólâ Ôvârí ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Îtõ võ ꞌásĩ, Ôvârí õtírĩ ãngó ꞌbãâ rî, gólâ bê rĩꞌá Ôvârí bê. ");
INSERT INTO avu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Õzõ Ôvârí õlẽ trá ngá lôꞌbãlé rî, Ôvârí âtâ tã lâ gólâ drí, drílâ ꞌẽzó lâ, nyé õzõ Ôvârí drí lẽlé rî kâtí. Ngá ãzâ yûꞌdạ́wạ́ ꞌbãlé cú ĩtí gólâ ãkó. ");
INSERT INTO avu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","5","Gólâ ĩꞌdî Ôvârí drí âjólé lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽlé õjílã drí rî. Gólâ kpá ĩꞌdî Ôvârí drí âjólé ngá îꞌĩ íyíkâ bê ânĩlí ı̣́nı̣́rı̣́kúwạ́ tã õnjí kâ drõlé vólé õjílã pı̣̃pı̣̂sı̣́lı̣́ ꞌásĩ rî. Gbõ lé õjílã lẽé ĩyî kô ı̣́nı̣́rı̣́kúwạ́ ĩyíkâ îꞌĩlí rî, îcá kô lôsĩ gólâkâ ı̣́nı̣́rı̣́kúwạ́ îꞌĩ kâ ꞌdĩ pẽlé. ");
INSERT INTO avu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Ãgô ãzâ bê rú lâ Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî. Ôvârí njĩ gólâ trá jõlé nĩꞌá tã Ngá îꞌĩ ꞌbá kâ pẽlé õjílã drí, gólĩyî ẽêdê ĩyî njãâ ngá îꞌĩ ꞌbá ꞌẽ ꞌbá âcálé ꞌdĩ tẽlé tã lẽlẽ sĩ tã âtî-âtî ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yõwánĩ rî gógó âꞌdó kô Ngá îꞌĩ ꞌbá ꞌdĩ ĩꞌdî. Gõꞌdá lôsĩ Yõwánĩ kâ rî íyíkâ cé Ngá îꞌĩ ꞌbá rî gógó ꞌdĩ tã lâ pẽlé õjílã drí. ");
INSERT INTO avu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Gólâ Ngá îꞌĩ ꞌbá ró Ôvârí rî âꞌdá ꞌbá ãmâ drí rî ĩꞌdî tíbê Ôvârí drí âjólé ûrú lésĩ õjílã mvá ró ãmâ lãfálé ãngó ꞌá nõngá, tã mbı̣̂ Ôvârí kâ âꞌdálé ãmâ õjílã drí rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gbõ lé óꞌbã bê õjílã ãngó nõ ꞌá ndrĩ gólâ sĩ rî, gõꞌdá kpálé gólâ âꞌdô bê kpá ĩꞌdî Ôvârí rî âꞌdá ꞌbá ró õjílã drí ãngó nõ ꞌá rî, õjílã dũû gâ ĩyî vólé dó gólâ rî nı̣̃lı̣́ ꞌdíyî pã ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Gbõ lé útı̣̂ bê gólâ õjílã Yúdạ̃ yí kâ ró rî, Yúdạ̃ yî gã ĩyî gólâ dó. ");
INSERT INTO avu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gõꞌdá ũrûkậ ꞌbá yî lãfálé sĩ gólĩyî tíbê tã lẽ ꞌbá trá gólâ ꞌá rî, gólâ ꞌbã gólĩyî trá âꞌdólé Ôvârí rî mvá yî ró pı̣̃pı̣̂sı̣́lı̣́ tãndĩ íyíkâ rî sĩ. ");
INSERT INTO avu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gólĩyî âcâ trá âꞌdólé Ôvârí rî mvá yî ró, tãlâ gólĩyî lẽ tã trá gólâ tíbê Ôvârí rî âꞌdá ꞌbá rî ꞌá rî drí sĩ. Gólĩyî âcâ âꞌdólé Ôvârí rî mvá ró ꞌdĩ âꞌdó õzõ ãmâ õjílã mvá ândrê drí tı̣̃lı̣́ nĩ átá bê rî tí kô, Ôvârí jâ âꞌdô-âꞌdô gólĩyíkâ rî ĩꞌdî gólĩyî ꞌbãlé âꞌdólé íyî mvá yî ró. ");
INSERT INTO avu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","15","Gõꞌdá gólâ tíbê “‘Ôvârí rî âꞌdá ꞌbá”’ rî útı̣̂ trá õjílã mvá ró ânĩlí rĩlí ãmâ lãfálé ꞌá ãngó nõ ꞌá. Ãmâ lãjóꞌbá gólâkâ rî, mã nı̣̃ gólâ Ôvârí rî mvá ãlôwá ró, tãlâ mbârâkã átá lâ Ôvârí kâ fẽlé gólâ drí rî tãsĩ. Gólâ ĩꞌdî tíbê Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî drí tã lâ âtálé kĩꞌá nĩ rî, gólâ âꞌdô âcáꞌá rî. Yõwánĩ âtâ kĩ, “Nõô ãgô tíbê má drí rĩꞌá tã lâ âtálé ãnî drí kĩzó nĩ rî, ãâꞌdô âcáꞌá má vósĩ rî ĩꞌdî. Gõꞌdá ãmbã gólâkâ rî lậvũ gạ̃rạ̃ ámákâ rî drı̣̃ı̣̂ sĩ. Má nı̣̃ trá, ꞌdĩî tã pạ̃tı̣́ı̣̃ ꞌî, tãlâ gólâ bê rĩꞌá drẽ ãkpãkãꞌdã útı̣́ mâ kô.” Gólâ Ôvârí rî âꞌdá ꞌbá ró ꞌdĩ ãâꞌdô pı̣̃pı̣̂sı̣́lı̣́ pạ̃tı̣́ı̣̃ mbı̣̂ bê ꞌâ ạ̃ꞌdı̣́ bê õjílã tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ꞌÂ ạ̃ꞌdı̣́ ãmbá gólâkâ õjílã tãsĩ ꞌdî sĩ, gólâ fẽ õrẽ trá ãmâ drí lậvũlı̣́ gạ̃rạ̃ zãâ bạ̃dı̣̃. ");
INSERT INTO avu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nĩ ndrê drẽ, Ôvârí fẽ tã ꞌbãꞌbã íyíkâ ãmâ drí Músạ̃ sĩ, gõꞌdá gólâ rî ꞌâ ậꞌdı̣̂ trá ãmâ tãsĩ Yésũ Krístõ sĩ. Gõꞌdá mã nı̣̃ pı̣̃pı̣̂sı̣́lı̣́ pạ̃tı̣́ı̣̃ mbı̣̂ gólâkâ Yésũ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Õjílã ãzãkã yûꞌdạ́wạ́ Ôvârí rî ndrẽ ꞌbá trá íyî lı̣̃fı̣́ sĩ rî. Gõꞌdá Yésũ Ôvârí rî mvá ró ĩꞌdî Ôvârí rî cócóló ꞌî. Gólâ âꞌdâ âꞌdô-âꞌdô tãndí Ôvârí kâ õjílã tãsĩ rî trá dódó õjílã drí ãngó nõ ꞌá tã ꞌẽꞌẽ íyíkâ rî sĩ. ");
INSERT INTO avu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ârî ĩyî tã bê kĩꞌá nĩ rî, Yõwánĩ rĩꞌá tã pẽꞌá kpá bãbãtízĩ ꞌẽꞌá õjílã drí rî, gólĩyî pı̣̃pı̣̂sı̣́lı̣́ drí lôngázó tã rî ꞌdĩ tãsĩ. Gõꞌdá drílĩyî drı̣̃-ꞌbá ãzâ ꞌbá yî gólĩyî lãfálé ꞌásĩ gõꞌdá kpá ũgúlı̣́ ậtı̣̃ ꞌbá gólĩyíkâ ãzâ ꞌbá yí bê jõzó Yẽrõsãlémã ꞌásĩ nĩlí Yõwánĩ rî îjílí ngãtá gólâ ãꞌdî ĩꞌdî yã rî, ngãtá gólâ ꞌdíyî pã ꞌbá Ôvârí drí tã lâ âtálé kĩzó nĩ, yí âꞌdô âjóꞌá lâ ãngó ꞌá õjílã pãlé rî ĩꞌdî yã rî. ");
INSERT INTO avu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Gõꞌdá õjílã jõlé ꞌdĩ ꞌbá yî câ bê Yõwánĩ ngálâ tã ꞌdî îjílí rî, Yõwánĩ drí ngãzó tã lôgõlé gólĩyî drí trậ kĩ, yí âꞌdó kô ꞌdíyî pã ꞌbá tã lâ âtálé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gõꞌdá ãgô ꞌdĩ ꞌbá yî drí tã îjízó kpá óꞌdí Yõwánĩ tı̣́ kĩ, “Háyĩ, ngã gõꞌdá nî ãꞌdî ĩꞌdî yã? Nî tã ậngũ ꞌbá Ẽlíyã gólâ ꞌẽ ꞌbá âgõlé kpá óꞌdí rî ĩꞌdî yã?” Yõwánĩ kĩ gólĩyî drí rî, “Má âꞌdó Ẽlíyã ĩꞌdî kô.” Gõꞌdá gólĩyî drí Yõwánĩ rî îjízó kpá óꞌdí kĩ, “Mã kĩ, gõꞌdá nî áníkâ kó ãꞌdî ĩꞌdî yã, nî tã ậngũ ꞌbá Músạ̃ drí tã lâ îgĩlí búkũ Ôvârí kâ ꞌá kĩꞌá nĩ rî, ãâꞌdô âcáꞌá rî ĩꞌdî?” Gõꞌdá Yõwánĩ drí tã-drı̣̃ jãzó kpá óꞌdí kĩ, “Kó kô, má âꞌdó kpá kô tã ậngũ ꞌbá ãnî drí tã lâ âtálé ꞌdĩ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gõꞌdá gólĩyî drí gólâ rî îjízó kpá óꞌdí kĩ, “Ní âtâ drẽ tã mbı̣̂ ãmâ drí, mã gõ ró bê nĩꞌá âtálâ õjílã ãmbâ-ãmbâ ãmâ âjó ꞌbá rî yî drí. Gõꞌdá nî áníkâ kó ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Gõꞌdá Yõwánĩ drí tã-drı̣̃ lôgõzó gólĩyî drí úlı̣́ gólĩyî tã ậngũ ꞌbá Ĩsáyã drí ậngũlı̣́ íyî tãsĩ kĩ, “Má âꞌdô âcáꞌá tã îyálé õmã ꞌálâ õjílã drí kĩ, ‘Kúmú ãmákâ bí ânĩꞌá, nĩ êdê lạ́tı̣̂ njãâ gólâ drí ânĩzó ꞌá lâ sĩ.’ ” ");
INSERT INTO avu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Gõꞌdá õjílã drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí âjólé ꞌdĩ ꞌbá yî, Pạ̃rúsı̣̃ yî kpá bê gólĩyî lãfálé. Drílĩyî Yõwánĩ rî îjízó kĩ, ");
INSERT INTO avu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Õzõ ní ãꞌdô ꞌdíyî pã ꞌbá ãmâ Yúdạ̃ yî drí rĩꞌá tẽlâ rî ĩꞌdî kô, ní ãꞌdô gõꞌdá kpá Ẽlíyã ĩꞌdî kô, gõꞌdá kpá tã ậngũ ꞌbá Músạ̃ drí tã lâ âtálé rî ĩꞌdî kô rî, gõꞌdá ní rî õjílã îbábátízãlé ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Gõꞌdá Yõwánĩ drí tã-drı̣̃ jãzó gólĩyî drí kĩ nĩ rî, “Má rî rĩꞌá õjílã îbábátízãlé lı̣̃mvû sĩ, tãlâ má rî gólĩyî êdélé âꞌdólé njãâ ꞌdíyî pã ꞌbá rî lậgúlı̣́. Má âtâ ãnî drí, ꞌdíyî pã ꞌbá rî gógó ꞌdĩ bê rĩꞌá ngbãângbânõ ãngó ãmákâ nõ ꞌá nõngá. Gõꞌdá gólâ ĩꞌdî tíbê tã lâ drí ꞌẽꞌá lâzélé kôrô ꞌẽ ꞌbá âꞌdólé ãmbá ró rî. Gólâ âꞌdô bê gbõ lé nõngá rî, nĩ nı̣̃ı̣́ gólâ kô. Mâ rî gógó Yõwánĩ nõ âꞌdó kô tãndí ró îcálé âꞌdólé rû ı̣̂ꞌbũ ꞌbá gólâkâ ró káꞌbókã gólâkâ ângílí.” ");
INSERT INTO avu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tã ꞌdî ꞌê rû trá ĩtí áyágá ãmbá zı̣̃lı̣́ Jõrõdénĩ gólâ Yõwánĩ drí rĩzó bãbãtízĩ ꞌẽlé ꞌá lâ rî, ꞌáꞌá lé drı̣̃ õjí lésĩ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kậyı̣̂ ãzâ rî sĩ, Yõwánĩ bãbãtízĩ ꞌbá ró rî drí Yésũ rî ndrẽzó ânĩrĩ ꞌá yí ngálâ. Kôrô Yõwánĩ drí ngãzó tã âtálé õjílã gólĩyî rĩ ꞌbá gólâ bê ꞌdĩ ꞌbá yî drí kĩ, “Nĩ ndrê drẽ ãgô nã. ꞌDĩî ãgô Ôvârí drí âjólé drı̣̃ tĩ ꞌbá ró rî ĩꞌdî. Gólâ ĩꞌdî “‘Kạ́bı̣̃lı̣́kı̣̃ drı̣̃ tĩ ꞌbá Ôvârí kâ”’ ãrí lâ drí ꞌẽꞌá tã õnjí õjílã kâ jĩlí ndrĩ rî. ");
INSERT INTO avu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Gólâ ĩꞌdî má drí tã lâ âtálé ãnî drí kĩ, gólâ ãâꞌdô íyî âꞌdáꞌá ngbãângbânõ rî. Gõꞌdá gólâ kpá ĩꞌdî má drí kĩꞌá nĩ rî, ãmbã gólâkâ rî rĩꞌá gạ̃rạ̃ má drı̣̃ı̣̂ sĩ rî, tãlâ drẽ ãkpã útı̣́ mâ kô rî, gólâ bê rĩꞌá. ");
INSERT INTO avu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Sı̣́sı̣́ rî, má nı̣̃ı̣́ gólâ kô ꞌdíyî pã ꞌbá ró. Gõꞌdá ngbãângbânõ rî, má nı̣̃ gólâ trá. Má rî bãbãtízĩ ꞌẽlé ãnî drí lı̣̃mvû sĩ, ꞌdĩî rî ãꞌdô ró bê gólâ rî âꞌdázó ãnî Ĩsĩrãꞌélẽ yî drí, tãlâ ãꞌdô ró bê kpá õjílã ꞌbãlé âꞌdólé njãâ gólâ rî lậgúlı̣́ kậyı̣̂ gólâ drí âcázó rî tú.” ");
INSERT INTO avu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Gõꞌdá Yõwánĩ drí lạ́tı̣̂ yí drí tã nı̣̃zó kĩ, Yésũ ĩꞌdî rĩꞌá ꞌdíyî pã ꞌbá ꞌî rî âꞌdázó õjílã drí kĩ, “Kậyı̣̂ Yésũ drí ânĩzó má drí gólâ rî îbábátízãzó rî, má nı̣̃ gólâ trá ꞌdíyî pã ꞌbá ró. Mĩ ndrê drẽ, Ôvârí kĩ, má ãâꞌdô íyî mvá ꞌdĩ nı̣̃ꞌá, õzõ má õtírĩ Líndrí Tãndí íyíkâ ndrẽê âꞌdérẽ ꞌá rĩlí gólâ drı̣̃ı̣̂ õzõ ạ̃túꞌbú kâtí rî. Ôvârí kĩ, õzõ má õndrê tã ꞌdî trá rû ꞌẽꞌá rî, má âꞌdô nı̣̃ꞌá lâ kĩ, õjílã tã rî ꞌdĩ drí rû ꞌẽzó drílâ ꞌdĩ rî, trá rĩꞌá ꞌdíyî pã ꞌbá ꞌî, gõꞌdá kpá gólâ tíbê rĩ ꞌbá Líndrí Tãndí Ôvârí kâ âfẽlé õjílã drí rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mâ rî gógó Yõwánĩ, má ndrê Líndrí Tãndí Ôvârí kâ ꞌdĩ trá ámâ lı̣̃fı̣́ sĩ âꞌdê trá rĩlí gá Yésũ rî gógó drı̣̃ı̣̂. Má âtâ ãnî drí pạ̃tı̣́-pạ̃tı̣̃ ró, gólâ rĩꞌá ꞌdíyî pã ꞌbá ꞌî, gõꞌdá gólâ kpá rĩꞌá Ôvârí rî mvá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ị̃drú rî tí rî, Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî rĩꞌá ĩyî âdréꞌá lãjóꞌbá íyíkâ rı̣̃ rî ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Gõꞌdá Yõwánĩ ndrê Yésũ bê ânĩꞌá rî, gólâ drí tã âtázó lãjóꞌbá íyíkâ rı̣̃ ꞌdî ꞌbá yî drí kĩ, “Nĩ ndrê drẽ ãgô rĩ ꞌbá ânĩlí nã! ꞌDĩî rĩꞌá ꞌdíyî pã ꞌbá gólâ Ôvârí drí âjólé ânĩꞌá drãlé õzõ kạ́bı̣̃lı̣́kı̣̃ drı̣̃ tĩtĩ kâ ró rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gõꞌdá nĩngá sĩ, lãjóꞌbá Yõwánĩ kâ rı̣̃ ꞌdî ꞌbá yî ârî ĩyî bê úlı̣́ Yõwánĩ drí âtálé ꞌdĩ rî, kôrô drílĩyî ngãzó ꞌdẽlé Yésũ vósĩ. ");
INSERT INTO avu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nĩngá sĩ, Yésũ õtírĩ võ ndrẽê vólé rî, lãjóꞌbá Yõwánĩ kâ rı̣̃ ꞌdî ꞌbá yî rĩꞌá ĩyî ânĩꞌá gólâ vósĩ. Ĩtí rî, Yésũ drí âdrézó gólĩyî tẽlé, gõꞌdá âcâ ĩyî bê rî, Yésũ drí gólĩyî îjízó kĩ, “Ngá ãnî drí lẽlé rî ãꞌdô ꞌî yã?” Gõꞌdá lãjóꞌbá Yõwánĩ kâ ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Lı̣̃fı̣́ îmbá ꞌbá, mã lẽ võ ní drí rĩzó rĩlí rî ndrẽlé.” ");
INSERT INTO avu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Õzõ nĩ õlẽ trá võ má drí rĩzó rî ndrẽlé rî, ꞌdõvó nĩ âꞌdê má vósĩ, nĩ ânĩ ró bê ndrẽlâ.” Ĩtí rî, drílĩyî ꞌdẽzó Yésũ vósĩ, gólâ rî âjílí bũúũ cãlé võ gólâ drí rĩzó rĩlí rî ꞌálâ. Gólĩyî drí cãzó Yésũ yí bê võ Yésũ drí rĩzó rĩlí rî ꞌálâ lạ̃njạ́túlı̣́ sĩ ı̣̃tú-pá sû ꞌá. Gõꞌdá drílĩyî rĩzó Yésũ yí bê tólâ kậyı̣̂ rî ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Lãjóꞌbá Yõwánĩ kâ ãlô gólâ ꞌdẽ ꞌbá Yésũ vósĩ kậyı̣̂ rî ꞌdĩ ꞌá rî, rú lâ Ãndĩríyã. ");
INSERT INTO avu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Gõꞌdá ı̣̃drú rî tí rî, kôrô Ãndĩríyã drí ngãzó nĩlí íyî ậdrúpı̣̃ rú bê Sĩmónã rî ngálâ. Gõꞌdá Ãndĩríyã drí tã âtázó ậdrúpı̣̃ lâ Sĩmónã drí kĩ, “Mã ûsû ꞌdíyî pã ꞌbá trá!” ");
INSERT INTO avu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Gõꞌdá drílâ íyî ậdrúpı̣̃ Sĩmónã rî ậdrı̣̃zó âjílí Yésũ ngálâ. Gõꞌdá Yésũ ndrélé bê Sĩmónã rî, kôrô gólâ drí nı̣̃zó lâ tõ kĩ, Sĩmónã lẽ trá ꞌdẽlé yí vósĩ âꞌdólé lãjóꞌbá íyíkâ ró. Gõꞌdá gólâ drí tã âtázó Sĩmónã drí kĩ, “Sĩmónã, Yónã rî mvá, má âꞌdô ánî rú zı̣̃ꞌá gõꞌdá Pétẽrõ.” (Rú Pétẽrõ ꞌdĩ Ị́bũrũ tı̣̂ sĩ rĩꞌá Kéfã, tã ífí lâ kĩ, kúnı̣́.) ");
INSERT INTO avu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gõꞌdá ı̣̃tú ãzâ rî sĩ, Yésũ ı̣̂sũ tã trá nĩzó gõlé ꞌbạ̃drı̣̃ zı̣̃lı̣́ Gãlĩláyã rî ꞌálâ lãjóꞌbá yí drí ûsúlı̣́ ꞌdĩ ꞌbá yí bê. Gõꞌdá gólĩyî câ bê Gãlĩláyã ꞌálâ rî, Yésũ drí ãgô ãzâ ûsúzó tólâ rú lâ Fílĩpõ, gõꞌdá Yésũ drí tã âtázó gólâ drí kĩ, “Ní âꞌdê má vósĩ.” ");
INSERT INTO avu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fílĩpõ rî gógó ꞌdĩ ânĩ jạ̃rı̣́bạ̃ zı̣̃lı̣́ Bẽtãsédã rî lésĩ, Bẽtãsédã ꞌdĩ kpá jạ̃rı̣́bạ̃ Ãndĩríyã yî drí ânĩzó ꞌálâ sĩ Pétẽrõ bê rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Gõꞌdá nĩngá sĩ, Fílĩpõ drí nĩzó nĩꞌá Nãtãnélẽ rî ûsúlı̣́, drílâ tã âtázó Nãtãnélẽ drí kĩ, “Ní ı̣̂sũ drẽ tã gólâ Ôvârí drí âtálé ạ̃kû ró Músạ̃ yî tı̣́ sĩ tã ậngũ ꞌbá yí bê kĩzó nĩ, yí ãꞌdô ꞌdíyî pã ꞌbá âjóꞌá ãmâ drí rî! ꞌDíyî pã ꞌbá rî gógó ꞌdĩ bê rĩꞌá ãmâ lãfálé ngbãângbânõ! Mã ûsû gólâ trá! Rú lâ Yésũ gólâ Yõsépã rî mvá ꞌî jạ̃rı̣́bạ̃ zı̣̃lı̣́ Nãzãrétã rî lésĩ.” ");
INSERT INTO avu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Gõꞌdá Nãtãnélẽ drí tã âtázó Fílĩpõ drí kĩ, “Tã tãndí îcâ fí trá âfõlé Nãzãrétã lésĩ yã?” Fílĩpõ drí tã-drı̣̃ lôgõzó Nãtãnélẽ drí kĩ, “Ní ôkî tã kô, nõô tã pạ̃tı̣́ı̣̃ ꞌî! Ní ânĩ, mã nĩ ró bê ndrẽlâ.” Gõꞌdá ĩtí rî, drílĩyî ngãzó nĩlí Yésũ rî ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Gõꞌdá Yésũ ndrê bê Nãtãnélẽ ânĩrĩ ꞌá yí ngálâ rî, Yésũ drí tã âtázó kĩ, “Nĩ ndrê drẽ ãgô rĩ ꞌbá ânĩlí nã! Gólâ rĩꞌá õjílã tãndí ãmákâ Ĩsĩrãꞌélẽ yí kâ tíbê õnjõ âdó ꞌbá kô rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nĩngá sĩ, Nãtãnélẽ drí tã âtázó Yésũ drí kĩ, “Tí ní nı̣̃ mâ ángô tí ró yã?” Gõꞌdá Yésũ drí tã-drı̣̃ jãzó Nãtãnélẽ tı̣́ kĩ, “Má ndrê nî trá võ tíbê ní drí rĩzó lôvólé ꞌá lâ, kãnágõwá líndrí nã ꞌá, drẽ ãkpãkãꞌdã Fílĩpõ nĩí ámâ tã âtálé ní drí kô.” ");
INSERT INTO avu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Gõꞌdá Nãtãnélẽ drí tã âtázó Yésũ drí kĩ, “Lı̣̃fı̣́ îmbá ꞌbá, má lẽ tã trá kĩ, nî Ôvârí rî mvá ꞌî, gõꞌdá kpá Kúmú ãmâ õjílã Ĩsĩrãꞌélẽ kâ kâ.” ");
INSERT INTO avu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã-drı̣̃ lôgõzó Nãtãnélẽ drí kĩ, “Ní lẽ tã kĩzó nĩ, má ãꞌdô Ôvârí rî mvá ĩꞌdî rî, tãlâ má drí tã âtázó ní drí kĩ, má ndrê nî ãkpãkãꞌdã, ní drí rĩzó lôvólé kãnágõwá líndrí nã ꞌá rî drí sĩ yã? Má âtâ ní drí pạ̃tı̣́-pạ̃tı̣̃ ró, ní âꞌdô tã lârâkô gólâ ánî tı̣̂ drí ậꞌdı̣́zó rî ndrẽꞌá ı̣̃zạ́tú gạ̃rạ̃ gólâ nõ drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gõꞌdá Yésũ drí kpá tã âtázó óꞌdí kĩ, “Nĩ ârî tã nô, ãnî ndrĩ! Ị̃zạ́tú ꞌbũû âꞌdô rû njı̣̃ꞌá ãnî drí mãlãyíkã Ôvârí kâ rî ꞌbá yî ndrẽzó ânĩrĩ ꞌá má ngálâ, Ôvârí âꞌdô âꞌdáꞌá lâ kĩ, pạ̃tı̣́ı̣̃, mâ rĩꞌá gólâ tíbê yí drí âjólé trá ûrú lésĩ rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kậyı̣̂ rı̣̃ vósĩ, õjílã ãzâ ꞌbá yî rĩꞌá kãrámã lãgĩ kâ ꞌẽꞌá jạ̃rı̣́bạ̃ mvá zı̣̃lı̣́ Kánã rî ꞌá, ꞌbạ̃drı̣̃ Gãlĩláyã kâ rî ꞌálâ. Mãríyã Yésũ rî ândrê kpá rĩꞌá lãgĩ ꞌdî võ lâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Gõꞌdá lãgĩ lı̣́pı̣̂ yî drí kpá Yésũ rî ậzı̣́zó ânĩlí kãrámã lãgĩ ꞌdî kâ ꞌdĩ ꞌá lãjóꞌbá íyíkâ rî ꞌbá yí bê. Ĩtí rî, Yésũ yî drí ngãzó nĩlí. ");
INSERT INTO avu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Gõꞌdá õtírĩ cãâ kãrámã lãgĩ kâ ꞌdĩ ító ꞌâ lâ ꞌá rî, õdrá kãrámã kâ ꞌdĩ drí rû ndẽzó. Gõꞌdá õdrá kãrámã rî ꞌdĩ kâ ndẽ rû bê rî, Mãríyã drí ânĩzó Yésũ ngálâ tã âtálé gólâ drí kĩ nĩ rî, “Ámâ mvá, õdrá kãrámã nô kâ nõ ndẽ rû trá!” ");
INSERT INTO avu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Gõꞌdá nĩngá sĩ rî, Yésũ drí tã-drı̣̃ lôgõzó ândrê lâ drí kĩ, “Ní âtâ tã lâ má drí ãꞌdô tãsĩ yã? ꞌDĩî âꞌdó tã ámákâ ĩꞌdî kô. Kậyı̣̂ má drí mbârâkã ámákâ âꞌdázó õjílã drí rî âcá drẽ kô.” ");
INSERT INTO avu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Gõꞌdá nĩngá sĩ, ândrê lâ drí lı̣̃fı̣́ jãzó rû ı̣̂ꞌbũ ꞌbá lãgĩ lı̣́pı̣̂ kâ rî ꞌbá yî ngálâ tã âtálé gólĩyî drí kĩ nĩ rî, “Nĩ ꞌê ngá gólâ drí âꞌdálé ãnî drí ꞌẽlé rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ꞌBã kãrámã ꞌẽzó ꞌá lâ ꞌdĩ, cú rĩꞌá límvó ạ́ngı̣́ ạ́ngı̣́ bê njı̣̂-kázíyá rĩzó lı̣̃mvû lôdãlé ꞌá lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ nĩ lı̣̃mvû âbẽlé óró lésĩ lôdãlé límvó ꞌdĩ ꞌbá yî ꞌásĩ.” Ĩtí rî, rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí nĩzó lı̣̃mvû âbẽlé lôdãlé límvó ꞌdĩ ꞌbá yî ꞌásĩ dũûdû. ");
INSERT INTO avu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Gõꞌdá nĩngá sĩ, límvó ạ́ngı̣́ ạ́ngı̣́ ꞌdĩ ꞌbá yî îcâ bê dũûdû rî, Yésũ drí kpá tã âtázó rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí kĩ, “Nĩ bẽ lı̣̃mvû ꞌdĩ âjílí kãrámã vó ndrẽ ꞌbá drí.” Drílĩyî ꞌẽzó lâ té õzõ Yésũ drí âtálé rî kâtí. ");
INSERT INTO avu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nĩngá sĩ, kãrámã vó ndrẽ ꞌbá ꞌdĩ drí lı̣̃mvû rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí âjílí yí drí ꞌdĩ trõzó âmbélé rî, gõꞌdá lı̣̃mvû rî ꞌdĩ jâ rû trá õdrá ró, gõꞌdá âsô-âsô ró gạ̃rạ̃ sı̣́sı̣́ gólĩyî drí rĩꞌá mvũlâ rî drı̣̃ı̣̂ sĩ. Kãrámã vó ndrẽ ꞌbá ꞌdĩ nı̣̃ı̣́ kô ngãtá õdrá ꞌdĩ ûsû rû ãꞌdô ꞌásĩ yã rî, gõꞌdá rû ı̣̂ꞌbũ ꞌbá ꞌdĩ ꞌbá yî nı̣̃ võ õdrá ꞌdĩ ûsúzó rî trá, gólĩyî âꞌdá lâ kô kãrámã vó ndrẽ ꞌbá ꞌdĩ drí. Gõꞌdá kãrámã vó ndrẽ ꞌbá ꞌdĩ drí õdrógô õkó lâ rî âjílí ꞌdĩ ậzı̣́zó tã âtázó drílâ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Õjílã rî õdrá íyíkâ âsó ꞌbá âsô rî lânjílí ĩꞌdî sı̣́sı̣́ kãrámã võ ꞌásĩ, gõzó gólâ âsó ꞌbá kô rî fẽlé ạ̃dũkũ lâ ró, õzõ õjílã ậzı̣́lı̣́ rî ꞌbá yî ãꞌdô trá ꞌdó õdrá ró rî. Gõꞌdá áníkâ rî âꞌdó íyíkâ ĩtí kô. Ní âyê áníkâ õdrá âsó ꞌbá dódó kôrô rî trá fẽlé õjílã drí ạ̃dũkũ lâ ró.” ");
INSERT INTO avu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ꞌDĩî tã lârâkô drı̣̃-káká Yésũ kâ ꞌẽlé rî ĩꞌdî. Tã lârâkô ꞌdĩ rî âꞌdálâ kĩ, Yésũ Ôvârí rî mvá ꞌî. Gõꞌdá lãjóꞌbá gólâkâ ndrê ĩyî bê tã lârâkô gólâ drí ꞌẽlé ꞌdĩ rî, gólĩyî drí tã-drı̣̃ lẽzó pạ̃tı̣́-pạ̃tı̣̃ ró kĩ, Yésũ Ôvârí rî mvá ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kãrámã lãgĩ kâ ꞌdĩ vósĩ rî, Yésũ yî drí ngãzó nĩlí Kãpẽrãnómã ꞌálâ, ândrê lâ yí bê, gõꞌdá ậdrúpı̣̃ lâ yí bê gõꞌdá kpá lãjóꞌbá íyíkâ rî ꞌbá yí bê ꞌẽlâ kậyı̣̂ fínyáwá. ");
INSERT INTO avu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gõꞌdá kậyı̣̂ kãrámã lậvũ-lậvũ kôrô kâ rî trá ãnyî. Tã ꞌdî tãsĩ rî, Yésũ yî drí nĩzó Yẽrõsãlémã ꞌálâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tólâ drílĩyî fĩzó ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌá, drílĩyî ngá lậzı̣́ ꞌbá ûsúzó dũû, ãzâ ꞌbá yî rĩꞌá ı̣́tı̣́ lậzı̣́ꞌá, ãzâ ꞌbá yî rĩꞌá kạ́bı̣̃lı̣́kı̣̃ lậzı̣́ꞌá, ãzâ ꞌbá yî ãmámõ lậzı̣́ꞌá, ãꞌdô ró bê fẽlé ngá fẽfẽ ró Ôvârí drí, gõꞌdá ãzâ ꞌbá yî ĩyíkâ kpá ậdı̣̂ õrĩ ı̣̂kúrạ̃ꞌá ậdı̣̂ õrĩ ngĩíngî õjílã ãzâ ꞌbá yí kâ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gõꞌdá Yésũ ndrê tã ꞌdî bê rî, tã rî ꞌdĩ sú gólâ lı̣̃fı̣́ kô, tãlâ õjílã ꞌdî ꞌbá yî rî ngá ꞌdĩ ꞌbá yî lậzı̣́lı̣́ lâgî õnjí sĩ jó Ôvârí kâ rî ꞌá. Ĩtí rî, Yésũ drí ngãzó bãgó pĩpĩ âtrõlé gõzó ꞌâ lâ âtílí ândálé, ãꞌdô ró bê ônjóróꞌbí ró, õjílã rĩ ꞌbá kõrõnyã lậzı̣́lı̣́ ꞌdĩ ꞌbá yî lâdrózó ndrĩ vólé kõrõnyã ĩyíkâ ꞌdĩ ꞌbá yí bê ĩꞌdî sĩ lâ, gõꞌdá gólâ drí kpá tãrãbízã ậdı̣̂ ı̣̂kúrạ̃ ꞌbá yí kâ ꞌdĩ lôzézó ndrĩ vũdrı̣́ ậdı̣̂ gólĩyíkâ ꞌdĩ ꞌbá yî drí rû lâpẽzó ndíyángá vũdrı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Gõꞌdá Yésũ drí tã âtázó õjílã gólĩyî rĩ ꞌbá ãmámõ lậzı̣́lı̣́ ꞌdĩ ꞌbá yî drí kĩ nĩ rî, “Nĩ ârî drẽ tã ámákâ nõ! Nĩ rî ngá lậzı̣́lı̣́ ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌá ãꞌdô tãsĩ yã? Nõô võ ámâ átá kâ ĩꞌdî. Rĩꞌá õnjí ró ãnî drí ꞌbãzó lâ âꞌdólé võ ngá lậzı̣̂ kâ ró! Nĩ ûꞌdû ngá ãníkâ ꞌdĩ ꞌbá yî trõlé, nĩzó ĩꞌdí bê lâ vólé nõngá sĩ.” ");
INSERT INTO avu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Gõꞌdá nĩngá sĩ, lãjóꞌbá Yésũ kâ ârî ĩyî tã Yésũ drí âtálé ꞌdĩ bê rî, gólĩyî drí nı̣̃zó lâ kĩ, Yésũ rĩꞌá võ Ôvârí rî îrátã kâ lôvó lâ bê yí ꞌá dũû. Gólâ rî vó lâ ndrẽlé nyé õzõ kúmú Dạ̃wúdı̣̃ kâtí, tíbê tã âtá ꞌbá kĩꞌá nĩ rî, “Ôvârí, tã lôvó bê rĩꞌá má ꞌá dũû rĩzó jó áníkâ vó lâ ndrẽlé.” ");
INSERT INTO avu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gõꞌdá nĩngá sĩ, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî trá ạ̃wạ̃ ró tã Yésũ drí ngá lậzı̣́ ꞌbá lâdrózó ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌásĩ rî tãsĩ, gólĩyî drí ânĩzó Yésũ ngálâ tı̣̂ ânyálé gólâ bê tã ꞌdî tãsĩ kĩ, “Tãlâ ãꞌdô ꞌî ní drí ánî ꞌbãzó âꞌdólé gạ̃rạ̃ ãzí-ãzí drı̣̃ı̣̂ sĩ yã? Ãꞌdô ĩtí rî, ní ꞌê drẽ tã lârâkô tíbê âꞌdá ꞌbá lâ kĩꞌá nĩ rî, ꞌdĩî drı̣́-ãcê Ôvârí kâ rî ĩꞌdî rî, mã nı̣̃ ró bê kĩꞌá nĩ rî, ní ânĩ Ôvârí ngá lésĩ.” ");
INSERT INTO avu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Ãnî, õzõ kpálé nĩ ũûfû jó Ôvârí kâ nõ rî, mâ rî gógó, má âꞌdô bẽꞌá lâ kpá óꞌdí cé kậyı̣̂ nâ sĩ.” ");
INSERT INTO avu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã-drı̣̃ jãzó Yésũ drí kĩ, “Wúûwú, ní ậvı̣̃ tráã! Ní nı̣̃ı̣́ kô kĩꞌá nĩ rî, õjílã ꞌdı̣̂ jó ạ́ngı̣́ Ôvârí kâ ꞌdĩ ndẽlé ndrô nyâꞌdî-rı̣̃-drı̣̃-lâ-ngâ-njı̣̂-kázíyá sĩ yã? Ní ı̣̂sũ áníkâ bê-rî kĩ, ní âꞌdô îcáꞌá jó ạ́ngı̣́ ꞌdĩ ꞌdı̣̃lı̣́ ndẽlé cé kậyı̣̂ nâ sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Úlı̣́ Yésũ drí âtálé jó ạ́ngı̣́ Ôvârí kâ ûfû kâ ꞌdĩ, tákõ, rĩꞌá úlı̣́ mãnĩgõ ꞌî, íyî rúꞌbạ́ ı̣̃nyạ́kú tãsĩ, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ âꞌdô íyî fũꞌá, gõꞌdá kậyı̣̂ nâ sĩ, yí âꞌdô lîdríꞌá kpá óꞌdí õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gõꞌdá kậyı̣̂ gólâ lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí Yésũ rî ndrẽzó lîdrî trá õdrã ꞌásĩ rî, úlı̣́ tíbê Yésũ drí âtálé gólĩyî drí kĩꞌá nĩ rî, áâꞌdô íyî fũꞌá, gõꞌdá kậyı̣̂ nâ sĩ, yí âꞌdô lîdríꞌá kpá óꞌdí õdrã ꞌásĩ rî drí âgázó gólĩyî drı̣̃ı̣̂. Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí tã lẽzó úlı̣́ tíbê Ôvârí drí âtálé búkũ ꞌá kĩꞌá nĩ rî, yí âꞌdô ꞌdíyî pã ꞌbá rî lîdríꞌá kpá óꞌdí õdrã ꞌásĩ rî trá, tákõ, rĩꞌá tã mbı̣̂ ꞌî. Gólĩyî lẽ tã ꞌdî, tãlâ gólĩyî ndrê trá úlı̣́ Yésũ drí âtálé rî, tã lâ ꞌê rû trá pạ̃tı̣́ı̣̃. ");
INSERT INTO avu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kậyı̣̂ kãrámã lậvũ-lậvũ kôrô kâ ꞌdĩ ꞌbá yî sĩ, Yésũ drí tã lârâkô õjílã pã kâ ꞌẽzó dũû mbârâkã Ôvârí kâ sĩ. Gõꞌdá õjílã ndrê ĩyî tã lârâkô gólâkâ ꞌẽlé ꞌdĩ ꞌbá yî bê rî, õjílã dũû drí ngãzó ꞌdó tã lẽlé gólâ ꞌá. Gõꞌdá tã ı̣̂sũ gólĩyíkâ Yésũ rî tãsĩ kĩꞌá nĩ rî, Yésũ âꞌdô ĩyî pãꞌá õjílã Rómã kâ drı̣́gạ́ sĩ ꞌdî rĩꞌá ányâ ró. ");
INSERT INTO avu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Gõꞌdá Yésũ lẽé kô tã ı̣̂sũ gólĩyíkâ ꞌdĩ ꞌẽlé ĩꞌdî, tãlâ gólâ nı̣̃ tã ı̣̂sũ gólĩyíkâ trá ndrĩ tãndí ró. ");
INSERT INTO avu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Gólâ lẽé kô õjílã ãzâ drí tã âtálé yí drí õjílã mvá tãsĩ, tãlâ gólâ nı̣̃ tã ı̣̂sũ ányâ gólĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌá rî kpá trá ndrĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ãgô ãzâ bê rú lâ Nĩkõdímã, gólâ sı̣́sı̣́-lésĩ tã Yúdạ̃ yí kâ kĩ ꞌbá ꞌî, gõꞌdá kpá drı̣̃-ꞌbá Pạ̃rúsı̣̃ yí kâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ngạ́cı̣̂ ãlô sĩ, gólâ drí ngãzó nĩlí Yésũ ngálâ. Gõꞌdá gólâ câ bê Yésũ ngálâ rî, drílâ tã âtázó Yésũ drí kĩ, “Tã îmbá ꞌbá, mã nı̣̃ trá kĩ, Ôvârí âjô nî nĩ ânĩꞌá tã íyíkâ îmbálé ãmâ drí, tãlâ õjílã ãzâ yûꞌdạ́wạ́ ãngó nõ ꞌá tã lârâkô ní drí rĩꞌá ꞌẽlâ ꞌdĩ ꞌẽlé, õzõ mbârâkã Ôvârí kâ ãꞌdô yûꞌdạ́wạ́ gólâ bê rî.” ");
INSERT INTO avu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Gõꞌdá Yésũ drí tã-drı̣̃ jãzó Nĩkõdímã drí kĩ, “Má âtâ ní drí nõ tã pạ̃tı̣́-pạ̃tı̣̃ ró rî ĩꞌdî, õzõ õjílã õlẽ tã trá âꞌdózó Ôvârí rî mvá ró rî, áâꞌdô gólâ rî tı̣̃ꞌá zãlô óꞌdí.” ");
INSERT INTO avu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Gõꞌdá Nĩkõdímã nı̣̃ı̣́ úlı̣́ Yésũ kâ âtálé ꞌdĩ ífí lâ kô, gólâ rî tı̣̂ ậꞌdı̣̂ gõꞌdá trá ậꞌdı̣̂ tã Yésũ drí âtálé ꞌdĩ tãsĩ. Gõꞌdá gólâ drí tã-drı̣̃ jãzó Yésũ drí kĩ, “Âꞌdô âꞌdóꞌá ĩtí ꞌdĩ íyíkâ kó ángô tí ró kĩzó nĩ rî, õjílã âꞌdó ꞌbá trá ạ́ngı̣́ rî áãꞌdô tı̣̃ꞌá lâ kpá óꞌdí ꞌdĩ yã? Õjílã mbã ꞌbá trá ạ́ngı̣́ rî âꞌdô gõꞌá kpá óꞌdí ândrê lâ ꞌá gõzó tı̣̃lâ ândálé trá óꞌdí yã?” ");
INSERT INTO avu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Gõꞌdá Yésũ drí kpá tã-drı̣̃ lôgõzó Nĩkõdímã drí kĩ, “Má âtâ ní drí nõ tã pạ̃tı̣́ı̣̃ ꞌî, õzõ úũtı̣̂ õjílã kô óꞌdí ró rî, gólâ îcá kô âꞌdólé õjílã Ôvârí kâ ró. Áâꞌdô õjílã ndrĩ tı̣̃ꞌá zãlô Líndrí Tãndí Ôvârí kâ rî sĩ, gõꞌdá kpá tã õnjí gólĩyíkâ jĩzó zãlô lı̣̃mvû Ôvârí kâ rî sĩ, ĩtí rî, gólĩyî ꞌdê gbõ âꞌdólé õjílã Ôvârí kâ ró. ");
INSERT INTO avu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mí ndrê drẽ, õjílã mvá tı̣̂ íyíkâ kpá té íyî nyãányâ ĩꞌdî, gõꞌdá Líndrí Tãndí Ôvârí kâ tı̣̂ íyíkâ fí té íyî nyãányâ ĩꞌdî, âꞌdô-âꞌdô bê õjílã Ôvârí kâ ró. ");
INSERT INTO avu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nĩkõdímã! Ánî drı̣̃ õlîjã tã má drí âtálé ní drí nõ sĩ kô! Rĩꞌá tã pạ̃tı̣́ı̣̃ ró ãnî ndrĩ tı̣̃zó óꞌdí, nĩ ꞌdê gbõ âꞌdólé õjílã Ôvârí kâ ró. ");
INSERT INTO avu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ní ı̣̂sũ drẽ gbõ tã ĩlî kâ. Ĩlî vı̣̂ íyíkâ võ ꞌásĩ ndrĩ. Gõꞌdá mã ndré võ ĩlî kâ rĩzó rî kô. Ĩlî õtírĩ rĩî vı̣̃lı̣́ rî, mã nı̣̃ı̣́ kô, gólâ rî nĩlí ángô lé, gõꞌdá mã ndré ĩlî rî ꞌdĩ rúꞌbạ́ lâ kpá kô. Gõꞌdá õjílã gólâ tı̣̃lı̣́ trá Líndrí Tãndí Ôvârí kâ sĩ rî, âꞌdô ꞌbãꞌá kpá ĩtí. Ĩtí rî, mã nı̣̃ı̣́ tã tã lâ sĩ rî kpá kô.” ");
INSERT INTO avu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Gõꞌdá Nĩkõdímã drí kpá tã-drı̣̃ lôgõzó Yésũ drí kĩ, “ꞌÉꞌẽ, tã áníkâ ꞌdĩ fí drẽ zãâ má drı̣̃ı̣̂ kô.” ");
INSERT INTO avu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nĩngá sĩ, Yésũ drí kpá tã âtázó Nĩkõdímã drí óꞌdí kĩ, “Nĩkõdímã, nî tã îmbá ꞌbá ạ́ngı̣́ õjílã ndrĩ ãmákâ Ĩsĩrãꞌélẽ kâ drí rĩꞌá ı̣̂njı̣̃lâ rî ĩꞌdî. Tãlâ ãꞌdô ꞌî úlı̣́ má drí âtálé nõ drí zãâ fĩzó ní drı̣̃ı̣̂ kô rî? ");
INSERT INTO avu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ní ârî drẽ tã má drí âtálé ní drí nõ tãndí ró, tãlâ ꞌdĩî rĩꞌá ngá gólâ ãmâ drí ndrẽlé trá ãmâ lı̣̃fı̣́ sĩ rî ĩꞌdî. Gõꞌdá tãlâ ãꞌdô ꞌî ní drí tã lẽzó kô ngá ãmâ drí ndrẽlé trá pạ̃tı̣́ı̣̃ ró nõ ꞌá yã? ");
INSERT INTO avu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ní ârî drẽ, má âꞌdâ tã ûrú ꞌálâ nã âꞌdô lâ ãnî drí ngá gólĩyî ãngó nõ ꞌá nõ ꞌbá yî sĩ, gõꞌdá tã lâ fí drẽ zãâ ãnî drı̣̃ı̣̂ kô. Õzõ gõꞌdá má ãâtâ ngá gólĩyî ûrú ꞌálâ rî tã lâ ĩꞌdî pạ̃tı̣́ı̣̃ rî, nĩ âꞌdô tã-drı̣̃ lâ lẽꞌá fí trá yã? ");
INSERT INTO avu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Má âtâ ní drí, õjílã ãzâ yûꞌdạ́wạ́ cã ꞌbá trá ûrú ꞌálâ, cé mâ gólâ âjólé trá ûrú lésĩ nô ĩꞌdî ânĩ ꞌbá tã ûrú ꞌálâ kâ nã ꞌbá yî âtálé ní drí rî. ");
INSERT INTO avu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","“Má âtâ ní drí, rĩꞌá îcâ-îcâ ró ódrí mâ âjólé trá ûrú lésĩ rî îngálé ûrû fê drı̣̃ı̣̂, tãlâ gólĩyî tíbê tã lẽ ꞌbá trá má ꞌá rî ũûsû ró ĩyî lédrẽ-lédrẽ ạ̃dũkũ ãkó rî bê, nyé õzõ Músạ̃ drí ꞌẽrẽ lâ ạ̃kû ró ãmâ ạ́ꞌbı̣́yạ́ yî drí õmã ꞌá kậyı̣̂ ı̣̃nı̣̃ drí rĩzó gólĩyî ôcílí rî tú rî kâtí. Gólâ êdê ı̣̃nı̣̃ líndrí trá îpálé fê sı̣́lı̣́ îngálé ûrû, tãlâ õjílã gólĩyî ı̣̃nı̣̃ drí ôcílí rî ĩîngâ ĩyî lı̣̃fı̣́ trá ûrû ı̣̃nı̣̃ líndrí ꞌdĩ ndrẽlé rî, Ôvârí âꞌdô gólĩyî pãꞌá õdrã ı̣̃nı̣̃ drí gólĩyî cĩzó ꞌdĩ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ôvârí lẽ õjílã trá ndrĩ rõô, tãlâ gólâ âjô mvá íyíkâ kó ãlô nõ trá ânĩꞌá drãlé tã õnjí gólĩyíkâ tãsĩ, tãlâ õjílã tíbê tã lẽ ꞌbá trá mvá gólâkâ nõ ꞌá rî drãá kô gõꞌdá âꞌdô rĩꞌá lédrẽ-lédrẽ ró zãâ, õzõ rúꞌbạ́ ı̣̃nyạ́kú lâ õdrã kpá lé rî.” ");
INSERT INTO avu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pạ̃tı̣́-pạ̃tı̣̃ ró, Ôvârí âjô íyî mvá ãngó nõ ꞌá nõ, âꞌdó kô lâŋõ fẽlé õjílã drí tã õnjí gólĩyíkâ tãsĩ. Bê-rî Ôvârí âjô íyî mvá ãngó nõ ꞌá nõ õjílã pãlé tã õnjí gólĩyíkâ rî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Õjílã gólĩyî ndrĩ lẽ ꞌbá trá Ôvârí rî mvá ꞌá rî áâꞌdô ĩyî ngá pãꞌá lâŋõ ꞌẽꞌá fẽlâ gólĩyî drí tã õnjí gólĩyíkâ tãsĩ rî ꞌásĩ. Gõꞌdá gólĩyî lẽ ꞌbá Ôvârí rî mvá ꞌá kô rî, áâꞌdô ĩyíkâ lâŋõ tã õnjí ĩyíkâ rî kâ ŋãꞌá ĩyî drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Rĩꞌá tã mbı̣̂ ró, lâŋõ tã õnjí õjílã gólĩyî tã lẽ ꞌbá Ôvârí rî mvá ꞌá kô rî kâ fẽzó gólĩyî drí. Nĩ ndrê drẽ, Ôvârí âjô íyî mvá ãngó nõ ꞌá nõ, ãꞌdô ró ngá îꞌĩ tã mbı̣̂ kâ âꞌdálé õjílã drí. Gõꞌdá õjílã lẽé kô rĩlí ngá îꞌĩ ꞌdî ꞌá. Gólĩyî lẽ tákányĩ rĩlí zãâ ı̣́nı̣́rı̣́kúwạ́ Sãtánã kâ rî ꞌá, tãlâ tã ꞌẽꞌẽ gólĩyíkâ ndrĩ rĩꞌá õnjí ró. ");
INSERT INTO avu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Õjílã gólĩyî tã õnjí ꞌẽ ꞌbá rî yî gã ĩyî ngá îꞌĩ trá dó, tãlâ óõzó tã õnjí ĩyíkâ ndrẽê kô. ");
INSERT INTO avu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Õjílã gólĩyî rĩ ꞌbá tã pạ̃tı̣́ı̣̃ Ôvârí kâ lẽlé pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ rî, gólĩyî ĩꞌdî tíbê ngá îꞌĩ Ôvârí kâ ꞌdĩ lậgú ꞌbá rî. Gõꞌdá ngá îꞌĩ ꞌdî âꞌdô tã âꞌdáꞌá õjílã ãzâ ꞌbá yî drí kĩ, gólâ rî ꞌdĩ tã Ôvârí drí lẽlé gólâ drí ꞌẽlé rî ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gõꞌdá nĩngá sĩ rî, Yésũ yî drí ngãzó Yẽrõsãlémã ꞌásĩ nĩlí lãjóꞌbá íyíkâ yí bê ꞌbạ̃drı̣̃ mvá ãzâ ꞌbá yî Yũdạ́yạ̃ kâ ꞌálâ rĩlí õjílã ꞌbạ̃drı̣̃ mvá ꞌdĩ ꞌbá yí kâ lı̣̃fı̣́ lâ yî îmbálé tã Ôvârí kâ sĩ. Gõꞌdá gólĩyî drí rĩzó õjílã gólĩyî tã îmbâ Yésũ kâ tãsĩ rî lẽ ꞌbá trá rî ꞌbá yî îbábátízãlé. ");
INSERT INTO avu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ꞌDĩî Yõwánĩ íyíkâ kpá rĩꞌá õjílã îbábátízãꞌá võ zı̣̃lı̣́ Ãyẽnónã rî ꞌá ãnyî jạ̃rı̣́bạ̃ ãzâ zı̣̃lı̣́ Sãlímã rî lạ̃gạ́tı̣́, tãlâ lı̣̃mvû tãndí bê tólâ dũû bãbãtízĩ ꞌẽzó ꞌá lâ. Gõꞌdá õjílã dũû tã lẽ ꞌbá trá tã Ôvârí kâ ꞌá rî, rî ĩyî trá ânĩlí Yõwánĩ rî îjílí ĩyî îbábátízãlé. ");
INSERT INTO avu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tã ꞌdî ꞌbá yî âꞌdô trá drẽ ãkpãkãꞌdã Ẽródẽ Ãnĩtípã rú drẽ Yõwánĩ ꞌbãlé gạ̃nı̣́mạ̃ ꞌá kô. ");
INSERT INTO avu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kậyı̣̂ ãzâ sĩ, lãjóꞌbá Yõwánĩ kâ rĩꞌá ĩyî tı̣̂ ânyáꞌá ãgô ãzâ ꞌbạ̃súrú Yúdạ̃ yí kâ ꞌásĩ rî bê, tã lãꞌbí ngĩíngî gólâ âꞌdózó ngbángbá Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Gõꞌdá gólĩyî ârílí bê tã tíbê ãgô ꞌdĩ âtálé rî, lãjóꞌbá Yõwánĩ kâ ꞌdĩ ꞌbá yî drí tã âtázó Yõwánĩ drí kĩ nĩ rî, “Lı̣̃fı̣́ îmbá ꞌbá, ãgô gólâ ní drí ûsúlı̣́ ꞌáꞌá lésĩ ní drí zı̣̃lı̣́ ꞌdíyî pã ꞌbá ró rî kpá rĩꞌá õjílã îbábátízãꞌá gõꞌdá ânĩ-ânĩ õjílã kâ ãmâ ngáá nõlé rî võ lâ ꞌá rî, õjílã ĩyîngá ꞌdó rĩꞌá nĩꞌá gólâ ngálâ bãbãtízĩ tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Gõꞌdá nĩngá sĩ, Yõwánĩ drí tã-drı̣̃ lôgõzó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Nĩ ı̣̂sũ tã kô, tãlâ ãgô rú bê Yésũ ꞌdĩ rî, Ôvârí fẽ mbârâkã nĩ gólâ drí rĩzó õjílã îbábátízãlé ꞌdĩ. Gólâ ꞌê ꞌdĩ âꞌdó kô mbârâkã íyíkâ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ãnî ndrĩ, nĩ nı̣̃ trá tãndí ró, má rî trá âtálâ õjílã drí ndrĩ kĩ, ‘Má âꞌdó kô ꞌdíyî pã ꞌbá ꞌî. Ôvârí âjô mâ trá sı̣́sı̣́ íyíkâ cé õjílã êdélé njãâ ânĩ-ânĩ gólâkâ rî tẽlé.’ ");
INSERT INTO avu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mâ rĩꞌá ãyĩkõ ró, tãlâ õjílã dũû rĩꞌá nĩꞌá Yésũ ngálâ. ꞌDĩî má âꞌdô ꞌbãꞌá nyé õzõ ãgô ãnjî ãzâ rû-lẽ-ãzí lâ bê rî kâtí, gõꞌdá õzõ ãgô ãnjî rî ꞌdĩ õgî õkó trá óꞌdí rî, õjílã ndrĩ drí âꞌdózó ãyĩkõ ró, tãlâ gólĩyî ndrê ãyĩkõ ãgô ãnjî ꞌdĩ kâ ĩꞌdî õkó lâ óꞌdí ꞌdĩ bê. Kpálé rî, gólĩyî îcá kô õkó ꞌdĩ trõlé nĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Rĩꞌá tãndí ró Yésũ drí âcázó õjílã ãmbá tã lâ drí lâzélé rõô rî ró. Õzõ ámâ tã õlâzê kô rî, tã lâ ꞌé ngá ãzâ kô. ");
INSERT INTO avu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tã pạ̃tı̣́ı̣̃ ró, õjílã gólâ ânĩ ꞌbá Ôvârí ngá lésĩ rî îmbâ íyíkâ kpá té tã gólĩyî Ôvârí ngá lésĩ rî yî ĩꞌdî. Gõꞌdá mâ õjílã ãngó nõ kâ ró rî, rî tã Ôvârí kâ îmbálé tã nı̣̃nı̣̃ ãngó nõ kâ rî vó ró. Ĩtí rî, Yésũ rĩꞌá gạ̃rạ̃ má drı̣̃ı̣̂ sĩ, tãlâ gólâ ânĩ trá Ôvârí ngá lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yésũ rî íyíkâ nõ tã yí drí ndrẽlé trá kpá yí drí ârílí trá rî îmbálé ĩꞌdî. Gõꞌdá cé õjílã fínyáwá lẽ ĩyî tã nĩ tã îmbâ gólâkâ ꞌdĩ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Õjílã gólĩyî tã lẽ ꞌbá trá tã îmbâ Yésũ kâ ꞌá rî, ꞌdĩî gólĩyî âꞌdâ tã trá kĩ, tã Ôvârí kâ tã pạ̃tı̣́ı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tãlâ Ôvârí âjô Yésũ nĩ ânĩlí tã âtî-âtî íyíkâ îmbálé ãmâ drí. Ôvârí rĩꞌá Yésũ bê ngá ãlô ró, gõꞌdá gólâ drí Líndrí Tãndí íyíkâ âjózó mbârâkã bê ânĩlí rĩlí Yésũ bê, Yésũ õꞌê ró ngá ndrĩ mbârâkã lâ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nĩ ndrê drẽ, Ôvârí lẽ íyî mvá Yésũ trá rõô. Gõꞌdá gólâ drí drı̣́-ãcê fẽzó Yésũ drí âꞌdózó mbârâkã bê ngá ndrĩ drı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Õjílã ndrĩ tíbê tã lẽ ꞌbá trá Ôvârí rî mvá ꞌá rî, gólĩyî trá õjílã Ôvârí kâ ĩꞌdî gõꞌdá Ôvârí âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽꞌá gólĩyî drí. Gõꞌdá õzõ õjílã õlẽ tã Ôvârí rî mvá ꞌá kô rî, rĩꞌá õnjí ró! Ôvârí fẽé lédrẽ-lédrẽ ạ̃dũkũ ãkó rî gólĩyî drí kô. Ôvârí âꞌdô rĩꞌá zãâ lâŋõ fẽꞌá ĩꞌdî gólĩyî drí tã õnjí gólĩyíkâ ꞌdĩ tãsĩ, tãlâ Ôvârí rĩꞌá ạ̃wạ̃ ró gólĩyí bê.” ");
INSERT INTO avu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Kậyı̣̂ nã ꞌbá yî ꞌá rî, õjílã dũû rî trá nĩlí Yésũ ngálâ bãbãtízĩ ꞌẽlé. Õjílã rĩ ꞌbá ꞌdẽlé Yésũ vósĩ gõꞌdá Yésũ yî drí kpá rĩzó bãbãtízĩ ꞌẽlé drílĩyî rî, trá gạ̃rạ̃ gólĩyî rĩ ꞌbá nĩlí Yõwánĩ ngálâ rî ꞌbá yî drı̣̃ı̣̂ sĩ. Gbõ lé õjílã ꞌdî ꞌbá yî rî ĩyî bê nĩlí Yésũ ngálâ rî, Yésũ rî gógó nyãányâ lâ ꞌé bãbãtízĩ cú nĩ õjílã rî ꞌdĩ ꞌbá yî drí kô. Lãjóꞌbá gólâkâ rî ꞌbá yî rî ĩyî nĩ bãbãtízĩ ꞌẽlé õjílã ꞌdî ꞌbá yî drí. Gõꞌdá Pạ̃rúsı̣̃ yî ârî ĩyî bê tã ꞌdî rî, tã ꞌdî sú gõꞌdá gólĩyî rú kô. Gõꞌdá Yésũ nı̣̃ tã ꞌdî bê kĩ, tã ꞌdî sú Pạ̃rúsı̣̃ yî rú gõꞌdá kô rî, gólĩyî drí ngãzó nĩlí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê ꞌbạ̃drı̣̃ Yũdạ́yạ̃ kâ ꞌdĩ âyélé gõzó vólé Gãlĩláyã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Gõꞌdá gõgõ Gãlĩláyã ꞌálâ rî sĩ rî, Yésũ yî nĩ kôrô lạ́tı̣̂ gólâ nĩ ꞌbá kpũrú ꞌbạ̃drı̣̃ zı̣̃lı̣́ Sãmárĩyã rî ꞌásĩ rî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Gõꞌdá gólĩyî drí nĩzó cãlé ãnyî jạ̃rı̣́bạ̃ mvá ãzâ Sãmárĩyã kâ zı̣̃lı̣́ Sĩkárã rî lạ̃gạ́tı̣́. Óró bê rĩꞌá tólâ tíbê Yãkóbã drí ꞌdı̣̃lı̣́ trá ạ̃kû ró gõꞌdá drílâ fẽlé ı̣̃nyạ́kú lâ bê íyî mvá Yõsépã drí rî. Yésũ yî gõ câ bê óró ꞌdĩ tı̣́ rî, lâŋõ ậcı̣́ kâ fî trá gólâ rú rõô. ꞌDĩî rĩꞌá ı̣̃tú-pá mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ sĩ, ı̣̃tú âmê gõꞌdá trá rõô. Ĩtí rî, gólâ drí rĩzó vũdrı̣́ lôvólé óró ꞌdĩ tı̣́. ");
INSERT INTO avu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ĩyî ngãzó nĩlí jạ̃rı̣́bạ̃ mvá nã ꞌálâ nĩꞌá ngá nyãnyã gĩlí, gólâ rî âyélé ãkpã óró ꞌdĩ tı̣́ nĩngá élê. Nĩngá sĩ, õkó ãzâ ꞌbạ̃súrú Sãmárĩyã kâ ꞌásĩ, rî rĩlí jạ̃rı̣́bạ̃ mvá ꞌdĩ ꞌá nĩngá drí ânĩzó lı̣̃mvû ꞌũlı̣́ óró ꞌdĩ ꞌásĩ. Gõꞌdá õkó Sãmárĩyã lé ꞌbá ró ꞌdĩ âcâ bê rî, Yésũ drí tã âtázó õkó ꞌdĩ drí kĩ, “Ámâ îzó, ní âꞌdô îcáꞌá fí trá lı̣̃mvû âfẽlé má tı̣́ yã?” ");
INSERT INTO avu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Gõꞌdá õkó ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ní zı̣̂ lı̣̃mvû má tı̣́ ꞌdĩ ángô tí ró? Mâ Sãmárĩyã lé ꞌbá ꞌî. Ạ̃kû lâ sĩ, ãnî õjílã Yúdạ̃ yí kâ mvû ĩyî ĩgã tı̣́ bê õjílã Sãmárĩyã kâ bê yã?” Õkó ꞌdĩ âtâ úlı̣́ ꞌdĩ ĩtí ꞌdĩ, tãlâ õjílã Yúdạ̃ yí kâ kĩ, ngá Sãmárĩyã lé ꞌbá kâ âꞌdô ĩyî îzãꞌá Ôvârí rî lı̣̃fı̣́ drı̣̃ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó õkó ꞌdĩ drí kĩ, “Tí ní õró ngá fẽfẽ tãndí Ôvârí drí rĩꞌá fẽlâ õjílã drí ngbãângbânõ rî nı̣̃ı̣̂ bê, gõꞌdá ní õró tí kpá mâ rî gógó lı̣̃mvû zı̣̃ ꞌbá ní tı̣́ sĩ nô nı̣̃ı̣̂ bê, gõꞌdá ní drí lı̣̃mvû zı̣̃zó má tı̣́ sĩ rî, tí má âꞌdô lı̣̃mvû gólâ ánî ꞌbã ꞌbá rĩlí zãâ lédrẽ-lédrẽ ró rî fẽꞌá ní drí.” ");
INSERT INTO avu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Gõꞌdá õkó ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ãmbá, óró nõ fĩfĩ, nî kpá ngá lı̣̃mvû âsê kâ ãkó rî, ní âꞌdô áníkâ lı̣̃mvû rî ꞌdĩ âséꞌá ãꞌdô sĩ yã? Gõꞌdá ní âꞌdô áníkâ lı̣̃mvû ámâ ꞌbã ꞌbá rĩlí zãâ lédrẽ-lédrẽ ró rî ûsúꞌá ãꞌdô ꞌásĩ ãngó nõ ꞌá rî yã? ");
INSERT INTO avu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Úlı̣́ áníkâ âtálé ꞌdĩ ꞌá rî, ní ı̣̂sũ áníkâ bê rî, nî gạ̃rạ̃ ãmâ ạ́ꞌbı̣́yạ́ Yãkóbã tíbê óró nõ ꞌdı̣̃ ꞌbá nĩ, yî rî gógó drí mvũlı̣́ kõrõnyã íyíkâ yí bê ndrĩ, gõꞌdá íyî mvá yî drí mvũzó lâ kpá ĩꞌdî rĩrĩ gólĩyíkâ sĩ gõꞌdá âcálé bũúũ ãmâ rú rî drı̣̃ı̣̂ sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Gõꞌdá Yésũ drí tã-drı̣̃ jãzó õkó ꞌdĩ drí kĩ, “Õjílã tíbê lı̣̃mvû mvũ ꞌbá óró Yãkóbã kâ ꞌdĩ ꞌásĩ rî, lı̣̃mvû lôvó âꞌdô gólâ rî ꞌẽꞌá kpá óꞌdí. ");
INSERT INTO avu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gõꞌdá õjílã tíbê lı̣̃mvû má drí ꞌẽꞌá fẽlâ ní drí rî mvũ ꞌbá rî, lı̣̃mvû lôvó ꞌé gólâ gõꞌdá kô, tãlâ lı̣̃mvû má drí ꞌẽꞌá fẽlâ gólâ drí ꞌdĩ rî, âꞌdô rĩꞌá gólâ rî pı̣̃pı̣̂sı̣́lı̣́ ꞌá õzõ óró kâtí, lı̣̃mvû lâ ꞌdĩ âꞌdô rĩꞌá ậtı̣́lı̣́ gólâ rî pãlé zãâ gbạ́dú ạ̃dũkũ ãkó.” ");
INSERT INTO avu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Gõꞌdá õkó ꞌdĩ drí tã lôgõzó kpá Yésũ drí kĩ, “Ãmbá, ní âfẽ lı̣̃mvû rî lârâkô bê ĩtí ꞌdĩ má drí kẽ, tãlâ lı̣̃mvû lôvó õzó kô ámâ ꞌẽê kpá óꞌdí, gõꞌdá má õzó kô kpá ânĩî lı̣̃mvû ậꞌũlı̣́ óꞌdí óró nõ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yésũ drí gõzó tã âtálé õkó ꞌdĩ drí kĩ, “Tãndí ró, ꞌdõvó ní nĩ ánî ágó rî ậzı̣́lı̣́, nĩ ânĩ ró gólâ bê má ngáá nõlé.” ");
INSERT INTO avu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Gõꞌdá õkó ꞌdĩ drí tã-drı̣̃ jãzó Yésũ drí kĩ, “Mâ ámângá ágó ãkó.” Gõꞌdá Yésũ drí tã âtázó gólâ drí kĩ, “Pạ̃tı̣́ı̣̃, úlı̣́ áníkâ ꞌdĩ rĩꞌá mbı̣̂! Nî ágó ãkó, tãlâ ní trõ ágó trá âyélé âyélé ândâlâ njı̣̂, gõꞌdá ãgô gólâ ãnî drí ꞌbãzó gólâ bê ngbãângbânõ rî, âꞌdó kô ánî ágó ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Gõꞌdá õkó ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ãmbá, ãꞌdô ĩtí rî, pạ̃tı̣́ı̣̃ nî rĩꞌá tã ậngũ ꞌbá ꞌî! ");
INSERT INTO avu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ĩtí rî ꞌdõvó, má îjî drẽ tã ní tı̣́. Võ gólâ tãndí mbı̣̂ õjílã drí Ôvârí rî ı̣̂njı̣̃zó ꞌá lâ rî íyíkâ ángô rî ĩꞌdî yã? Tãlâ ãmâ ạ́ꞌbı̣́yạ́ yî îmbâ ĩyíkâ ãmâ lãꞌbí ãmákâ ꞌá Ôvârí rî ı̣̂njı̣̃lı̣́ únı̣́ ãmbá ãzâ drı̣̃ı̣̂ nõngá. Gõꞌdá ãnî õjílã Yúdạ̃ yí kâ rî, rî âtálâ kĩ, võ tãndí mbı̣̂ Ôvârí rî ı̣̂njı̣̃ kâ âꞌdô cé Yẽrõsãlémã ꞌálâ. Ngbãângbânõ võ rı̣̃ ꞌdî ꞌásĩ rî, gõꞌdá ángô rî íyíkâ ĩꞌdî tãndí ró Ôvârí rî ı̣̂njı̣̃zó yã?” ");
INSERT INTO avu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Gõꞌdá Yésũ drí tã-drı̣̃ jãzó gólâ drí kĩ, “Ní ârî drẽ úlı̣́ má drí ꞌẽꞌá âtálâ ní drí nõ. Kậyı̣̂ lâ trá ngbãâ ãnyî õjílã drí Ôvârí rî ı̣̂njı̣̃zó võ ꞌásĩ ndrĩ pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ, gõꞌdá Ôvârí drí rãtáã gólĩyíkâ ꞌdĩ ârízó. Âꞌdó kô cé únı̣́ drı̣̃ı̣̂ nõngá, ngãtá cé Yẽrõsãlémã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ãnî Sãmárĩyã lé ꞌbá, nĩ rî Ôvârí gólâ ãnî drí nı̣̃lı̣́ kô rî ı̣̂njı̣̃lı̣́ ĩꞌdî. Gõꞌdá ãmâ Yúdạ̃ yî, mã rî Ôvârí ãmâ drí nı̣̃lı̣́ trá dódó rî ı̣̂njı̣̃lı̣́ ĩꞌdî, tãlâ ꞌdíyî pã ꞌbá gólâ Ôvârí drí âjólé rî rĩꞌá õjílã Yúdạ̃ kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gõꞌdá kậyı̣̂ âcâ trá Ôvârí drí lạ́tı̣̂ óꞌdí âꞌdázó õjílã drí. Ôvârí lẽ õjílã drí íyî ı̣̂njı̣̃lı̣́ võ ꞌásĩ ndrĩ tã mbı̣̂ sĩ. Gõꞌdá tã lậvũ ꞌbá gạ̃rạ̃ rî, gólâ lẽ õjílã drí íyî ı̣̂njı̣̃lı̣́ pı̣̃pı̣̂sı̣́lı̣́ ãlô tãndí rî sĩ. ");
INSERT INTO avu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ní ârî drẽ! Ôvârí rĩꞌá líndrí ró. Gólâ rí kô cé võ ãlô ꞌá. Gólâ rî kárá tã ꞌẽlé pı̣̃pı̣̂sı̣́lı̣́ tãndí ãlô rî sĩ. Õjílã ı̣̃ı̣̂njı̣̃ gólâ pı̣̃pı̣̂sı̣́lı̣́ tãndí pạ̃tı̣́ı̣̃ mbı̣̂ gõꞌdá kpá ãlô rî sĩ. ꞌDĩî rî sû nĩ Ôvârí drí rõô.” ");
INSERT INTO avu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Gõꞌdá õkó ꞌdĩ drí tã-drı̣̃ lôgõzó kĩ, “Úlı̣́ tãndí ní drí âtálé ꞌdĩ ꞌbã mâ trá ꞌdíyî pã ꞌbá tíbê ꞌẽ ꞌbá âcálé rî tã lâ ı̣̂sũlı̣́, gólâ âꞌdô âcáꞌá nĩ tã pạ̃tı̣́ı̣̃ Ôvârí ngá lésĩ rî âꞌdálé ndrĩ ãmâ drí.” ");
INSERT INTO avu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yésũ drí tã-drı̣̃ lôgõzó õkó ꞌdĩ drí kĩ, “Mâ rĩ ꞌbá tã nô âtálé ní drí nõ rĩꞌá ꞌdíyî pã ꞌbá rî gógó ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Gõꞌdá Yésũ drẽ zãâ rĩꞌá úlı̣́ âtáꞌá õkó ꞌdĩ bê rî, lãjóꞌbá gólâkâ rî ꞌbá yî drí âgõzó jạ̃rı̣́bạ̃ lésĩ gólĩyî ûsúlı̣́ úlı̣́ âtárẽ ꞌá. Gõꞌdá lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ûsû ĩyî gólĩyî bê úlı̣́ âtárẽ ꞌá rî, drílĩyî âꞌdózó lârõ-lârõ ró, tãlâ lãꞌbí Yúdạ̃ yí kâ ꞌá rî, rĩꞌá õnjí ró ãgô drí rĩzó tã ngĩlí õkó lídí bê. Gbõ lé lãjóꞌbá ꞌdĩ ꞌbá yî âꞌdô bê lârõ-lârõ ró gõꞌdá kpá tã ı̣̂sũ ró rî, õjílã ãlô gólĩyî lãfálé sĩ õkó ꞌdĩ îjí ꞌbá kĩꞌá nĩ rî, ní lẽ ãꞌdô yã, ngãtá Yésũ rî îjí ꞌbá kĩꞌá nĩ rî, gólâ rî úlı̣́ âtálé õkó Sãmárĩyã lé ꞌbá ró ꞌdĩ bê ãꞌdô tãsĩ yã rî yû. ");
INSERT INTO avu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Gõꞌdá õkó ꞌdĩ drí lı̣̃mvû límvó íyíkâ âyézó ãkpã nĩngá, gólâ drí ngãzó nĩlí ꞌwãâꞌwâ gõlé vólé jạ̃rı̣́bạ̃ ꞌálâ. Gõꞌdá gólâ câ bê tólâ rî, gólâ drí õjílã ậzı̣́zó tã âtázó gólĩyî drí kĩ, ");
INSERT INTO avu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nĩ ânĩ drẽ ꞌwãâꞌwâ tã nô ârílí! Má ûsû ãgô ãzâ trá óró tı̣́ tólâ, gõꞌdá ãgô rî ꞌdĩ âꞌdâ tã gólĩyî má drí ꞌẽlé trá ạ̃kû ró rî yî trá ndrĩ má drí! Gólâ îcâ fí trá âꞌdólé ꞌdíyî pã ꞌbá ãmâ drí rĩꞌá tẽlâ rî ĩꞌdî yã? Nĩ ânĩ, mã nĩ ró ndrẽlâ.” ");
INSERT INTO avu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Gõꞌdá õjílã ꞌdî ꞌbá yî ârílí bê úlı̣́ õkó ꞌdĩ kâ âtálé ꞌdĩ rî, gólĩyî drí ngãzó ndrĩ nĩlí Yésũ rî ndrẽlé óró tı̣́ ꞌá tólâ. ");
INSERT INTO avu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Gõꞌdá õkó ꞌdĩ õtírĩ kpá lậvũû rî, kôrô lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí ngá nyãnyã âtrõzó fẽlé Yésũ drí. Gólĩyî drí tã âtázó kĩ, “Tã îmbá ꞌbá, mã gî ngá nyãnyã trá, rĩꞌá nõ, ní nyâ.” ");
INSERT INTO avu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Mâ cú ngá nyãnyã ámákâ bê, tíbê ãnî ndrĩ drí tã lâ nı̣̃lı̣́ kô rî.” ");
INSERT INTO avu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî, drı̣̃ lâ ĩyî trá lîjã-lîjã ró. Gõꞌdá drílĩyî rĩzó tã âtálé ĩyî lãfálé ꞌásĩ kĩ, “Õjílã ãzâ âjî ngá nyãnyã trá gólâ drí ãmâ vólé sĩ nô yã?” ");
INSERT INTO avu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nĩngá sĩ, Yésũ drí gõzó úlı̣́ mãnĩgõ íyíkâ ngá nyãnyã kâ ꞌdĩ ĩtõ lâ âꞌdálé gólĩyî drí kĩ, “Nĩ ndrê drẽ, má rî nõ lôsĩ gólâ Ôvârí drí ámâ âjózó ꞌẽlâ rî ꞌẽꞌá. Õzõ má õtírĩ rĩî lôsĩ gólâ drí lẽlé má drí ꞌẽlé rî ꞌẽlé rî, ꞌdĩî fẽ fãfã má drí õzõ ngá nyãnyã drí fãfã fẽrẽ õjílã drí rî kâtí. Má lẽ ámákâ zãâ ı̣̃tú vósĩ cé lôsĩ rî ꞌdĩ ꞌẽlé ndẽlé vólé. ");
INSERT INTO avu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Õjílã rî trá tã âtálé kĩ, õzõ ạ́ạ̃ậfũ ạ̃drúgú trá rî, ạ̃drúgú rî ꞌẽlâ párá dũû ạ́mvú ꞌá gõzó ŋõlâ! Nĩ ndrê drẽ, ãndrõ nô rî, âꞌdó gõꞌdá ĩtí kô. Nĩ ndrê drẽ võ lạ́tı̣̂ ꞌálâ! Ạ̃drúgú lı̣̂njı̣̂ trá njãâ ŋõlé! Nĩ ânĩ, mã ŋõ ró êꞌbélé võ ãlô ꞌá ꞌbãlé ẽró Ôvârí kâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ôvârí âjô mâ ânĩlí úlı̣́ íyíkâ ı̣̂ꞌdı̣́lı̣́ õjílã ꞌásĩ. Nĩ ânĩ ámâ pãlé õjílã ꞌdî ꞌbá yî êꞌbélé tũ võ ãlô ꞌá, tãlâ õrî ró ĩyî bê lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó. Mâ ĩꞌdî ı̣̂ꞌdı̣́ ꞌbá lâ ꞌî, má âꞌdô lâŋõ lôsĩ kâ ãnî drí ámâ pãzó ꞌdĩ drı̣́-ꞌâ lâ fẽꞌá ãnî drí, mã âꞌdô ró bê ãyĩkõ ró kpãkã ãlô ãní bê õjílã gólĩyî ãmâ drí îmbálé ꞌdĩ ꞌbá yî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Rĩꞌá tã pạ̃tı̣́ı̣̃ ró õjílã drí rĩzó tã âtálé kĩ, ‘Ãzâ ꞌbá yî ı̣̂ꞌdı̣̂ ĩyíkâ ı̣̂ꞌdı̣̂-ı̣̂ꞌdı̣̂ lâ, gõꞌdá ãzâ ꞌbá yî ŋõ ĩyíkâ ŋõŋõ lâ êꞌbélé ẽró ꞌá.’ ");
INSERT INTO avu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Gõꞌdá ngbãângbânõ rî, mâ rĩꞌá ãnî jõꞌá ngá gólĩyî má drí ı̣̂ꞌdı̣́lı̣́ rî ꞌbá yî êꞌbélé. Gbõ lé õjílã ãzâ ꞌbá yî õꞌê ĩyî lôsĩ õjílã ꞌdî ꞌbá yî êdê-êdê lâ kâ nĩ ãnî drí rî, gõꞌdá nĩ âꞌdô ândrâ-tãndĩ lâ ûsúꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gõꞌdá Sãmárĩyã lé ꞌbá ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ õkó ꞌdĩ kâ âtálé kĩꞌá nĩ rî, Yésũ õlôfõ tã yí drí ꞌẽlé trá ạ̃kû ró rî yî trá ndrĩ ꞌdó yí drí rî, õjílã dũû gólĩyî lãfálé ꞌásĩ drí tã lẽzó pạ̃tı̣́ı̣̃ kĩ, Yésũ ãâꞌdô ꞌdíyî pã ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gõꞌdá Sãmárĩyã lé ꞌbá ꞌdĩ ꞌbá yî câ ĩyî bê Yésũ ngálâ óró tı̣́ ꞌá tólâ rî, gólĩyî lẽ drẽ zãâ tã îmbâ Yésũ kâ ârílí, gõꞌdá drílĩyî rúꞌbạ́ lôꞌbãzó Yésũ rú, gólâ õrî ró drẽ dã ĩyí bê jạ̃rı̣́bạ̃ ĩyíkâ ꞌdĩ ꞌá nĩngá. Yésũ drí tã-drı̣̃ gólĩyíkâ ꞌdĩ lẽzó, gõꞌdá gólâ drí rĩzó gólĩyí bê nĩngá kậyı̣̂ rı̣̃ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gõꞌdá Yésũ îmbâ gólĩyî bê kậyı̣̂ rı̣̃ ꞌdî ꞌá rî, õjílã dũû drí ngãzó tã lẽlé Yésũ ꞌá ꞌdíyî pã ꞌbá ró pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ. ");
INSERT INTO avu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Õjílã gólĩyî tã lẽ ꞌbá trá Yésũ ꞌá ꞌdĩ ꞌbá yî, drílĩyî ngãzó úlı̣́ âtálé õkó gólâ gólĩyî ậzı̣́ ꞌbá ânĩlí Yésũ rî ndrẽlé ꞌdĩ drí kĩ, “Ãmâ îzó, mã nı̣̃ trá ngbãângbânõ kĩ, pạ̃tı̣́ı̣̃ Yésũ ĩꞌdî gólâ ânĩ ꞌbá õjílã ndrĩ pãlé tã õnjí gólĩyíkâ ꞌásĩ rî. Sı̣́sı̣́ rî, mã lẽ tã cé úlı̣́ ní drí âtálé ãmâ drí nã tãsĩ. Gõꞌdá mã lẽ tã pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ ngbãângbânõ rî, tãlâ mã ârî úlı̣́ rĩ ꞌbá âfõlé gólâ sı̣́lı̣́ sĩ rî trá cú ãmâ bı̣́ sĩ. Ngbãângbânõ, mã ꞌdê trá gólâ vósĩ.” ");
INSERT INTO avu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kậyı̣̂ rı̣̃ ꞌdî vósĩ, Yésũ yî drí ngãzó lậvũlı̣́ Gãlĩláyã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Gõꞌdá ꞌdĩî gólâ âtâ úlı̣́ mãnĩgõ trá kĩ, “Õjílã gólâ tã ậngũ ꞌbá Ôvârí kâ ró rî, õjílã gólâkâ rî ꞌbá yî ró gólâ kô.” Gólâ âtâ úlı̣́ ꞌdĩ trá ĩtí, tãlâ gólâ nı̣̃ trá kĩ, õjílã Yúdạ̃ yí kâ rî ꞌbá yî ı̣̂njı̣̃ı̣́ ĩyî yî kô. ");
INSERT INTO avu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Gõꞌdá gólĩyî câ bê Gãlĩláyã ꞌálâ rî, õjílã ndrĩ drí ngãzó Yésũ rî lậgúlı̣́ ãyĩkõ sĩ, gólĩyî ı̣̂sũ ĩyíkâ bê rî kĩ, Yésũ âꞌdô kpá tã lârâkô gólâ drí ꞌẽlé Yẽrõsãlémã ꞌálâ rî ꞌẽꞌá ꞌbạ̃drı̣̃ ĩyíkâ ꞌá nĩngá, tãlâ õjílã gólĩyî ũrûkậ ꞌbá yî nĩ ꞌbá Yẽrõsãlémã ꞌálâ kãrámã lậvũ-lậvũ kôrô kâ ꞌẽlé nã ꞌbá yî ngî ĩyî tã lârâkô Yésũ drí ꞌẽlé tólâ nã tã lâ trá gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kậyı̣̂ ãzâ sĩ, Yésũ drí nĩzó kpá óꞌdí Kánã tíbê gólâ drí lı̣̃mvû jãzó õdrá ró ꞌá lâ rî ꞌálâ. Gõꞌdá ãgô ãmbá ãzâ kũmũ Ẽródẽ kâ zẽlé bê jạ̃rı̣́bạ̃ ãzâ zı̣̃lı̣́ Kãpẽrãnómã nã ꞌá. Mvá ãgô ãmbá ꞌdĩ kâ trá ngá lãzé ró ãnyî ꞌẽꞌá drãlé. ");
INSERT INTO avu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Gõꞌdá ãgô ãmbá ꞌdĩ ârílí bê tã kĩꞌá nĩ rî, Yésũ ãâcâ trá Yũdạ́yạ̃ lésĩ Gãlĩláyã ꞌá, gõꞌdá gólâ ãâꞌdô bê Kánã ꞌálâ rî, ãgô ãmbá ꞌdĩ drí ngãzó ꞌwãâ nĩlí Yésũ ngálâ. Gõꞌdá ãgô ꞌdĩ câ bê Yésũ rî ûsúlı̣́ rî, gólâ drí rúꞌbạ́ lôꞌbãzó Yésũ rú kĩ, “Óõ, kúmú, mvá ágó ámákâ ngá lãzé ró ạ̃mbúkũ lâ cé pı̣̃pı̣̂sı̣́lı̣́ ꞌá, ní âꞌdô ânĩꞌá fí trá pãlâ má drí õdrã ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Gõꞌdá Yésũ drí tã-drı̣̃ jãzó ãgô ꞌdĩ drí trậ kĩ, “Ãnî õjílã Gãlĩláyã kâ nõ ꞌbá yî, õzõ nĩ õndrê tã lârâkô má drí rĩꞌá ꞌẽlâ rî kô rî, nĩ gã dó tã lẽlé kĩ, pạ̃tı̣́ı̣̃ Ôvârí âjô mâ nĩ.” ");
INSERT INTO avu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Gõꞌdá ãgô ãmbá ꞌdĩ drí tã lôgõzó Yésũ drí kĩ, “Ãmbá, ní ânĩ, mã nĩ ró bê ꞌwãâꞌwâ ámâ mvá ágó nõ trá ꞌẽꞌá lôvó-lôvó âyélé!” ");
INSERT INTO avu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó ãgô ꞌdĩ drí kĩ, “Tãndí ró, ánî mvá ágó ꞌdĩ drãá kô, âꞌdô ngá pãꞌá. Ní nĩ gõlé ní drí ꞌbã ꞌálâ.” Ãgô ãmbá ꞌdĩ drí tã lẽzó úlı̣́ Yésũ kâ ꞌdĩ ꞌá, gõꞌdá gólâ drí ngãzó nĩꞌá gõlé yí drí ꞌbã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gõꞌdá ãgô ãmbá ꞌdĩ ngâ bê nĩꞌá gõlé yí drí ꞌbã ꞌálâ rî, gólâ õtírĩ cãâ ãnyî yí drí ꞌbã bê rî, gólâ drí rû ûsúzó rû ı̣̂ꞌbũ ꞌbá íyíkâ yí bê lạ́tı̣̂ ꞌá. Gõꞌdá kôrô rû ı̣̂ꞌbũ ꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ngãzó tã âtálé gólâ drí kĩ, “Ánî mvá ágó ngâ trá ngá lãzé ꞌásĩ! Gólâ rî rúꞌbạ́ âcâ trá tãndí ró!” ");
INSERT INTO avu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gõꞌdá ãgô ꞌdĩ drí tã îjízó rû ı̣̂ꞌbũ ꞌbá íyíkâ ꞌdĩ ꞌbá yî tı̣́ kĩ, “ꞌDĩî tã pạ̃tı̣́ı̣̃ ꞌî yã? Gólâ rî rúꞌbạ́ âcâ tãndí ró ꞌdĩ ángô tú yã?” Gõꞌdá gólĩyî drí tã-drı̣̃ jãzó kĩ, “Ậgı̣́ ı̣̃tú drí drı̣̃ dĩrĩ ꞌá kôrô gólâ rî rúꞌbạ́ ãmbá âmé ꞌbá ꞌdĩ drí ậꞌdı̣́zó, gõꞌdá mbârâkã lâ drí âgõzó rúꞌbạ́ lâ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Gõꞌdá kôrô ãgô ꞌdĩ drí nı̣̃zó lâ kĩ, ngá lãzé fõ trá íyî mvá rú sĩ té ı̣̃tú-pá gólâ Yésũ drí úlı̣́ âtázó yí drí kĩꞌá nĩ rî, yí õnĩ ꞌbã ꞌálâ, íyî mvá ágó ãâꞌdô ngãꞌá ngá lãzé ꞌásĩ ꞌdî ꞌá. Gõꞌdá ãgô ãmbá ꞌdĩ drí tã lẽzó pạ̃tı̣́-pạ̃tı̣̃ ró pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ Yésũ ꞌá, gõꞌdá õjílã gólâkâ ꞌbã kâ ndrĩ drí tã lẽzó kpá pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ õzõ gólâ kâtí. ");
INSERT INTO avu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ꞌDĩî tã lârâkô rı̣̃ lâ Yésũ drí ꞌẽlé Gãlĩláyã ꞌálâ âgõ-âgõ gólâkâ Yũdạ́yạ̃ lésĩ rî vósĩ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tã Yésũ drí ꞌẽlé Gãlĩláyã ꞌálâ ꞌdĩ ꞌbá yî vósĩ rî, gólâ drí ngãzó kpá óꞌdí Gãlĩláyã ꞌásĩ nĩlí Yẽrõsãlémã ꞌálâ kãrámã Yúdạ̃ yí kâ ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Gõꞌdá Yẽrõsãlémã ꞌá tólâ rî, ạ́pậrı̣̂ ãzâ bê rú lâ Bẽtẽzádã tı̣̂ Yúdạ̃ yí kâ sĩ, ãnyî ạ́tı̣̃ jạ̃rı̣́bạ̃ kâ zı̣̃lı̣́ Ạ́tı̣̃ Kạ́bı̣̃lı̣́kı̣̃ kâ rî lạ̃gạ́tı̣́. Gõꞌdá ạ́pậrı̣̂ ꞌdĩ tı̣́ rî, úꞌdı̣̂ pạ̃trạ̃ trá tólâ njı̣̂. ");
INSERT INTO avu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Õjílã gólĩyî ngá lãzé ꞌbá ró rî rî ĩyî trá pạ̃trạ̃ ꞌdî ꞌbá yî ꞌásĩ, gólĩyî lı̣̃fı̣́ ãkó rî ꞌbá yî, lĩsí ró rî ꞌbá yí bê gõꞌdá rĩ ꞌbá õŋõ ró rî ꞌbá yí bê. (Tãlâ mãlãyíkã Ôvârí kâ rî ânĩlí lı̣̃mvû ạ́pậrı̣̂ ꞌdĩ kâ îyálé kãgbã-kãgbã. Õzõ õjílã ãzâ ngá lãzé bê rî õꞌdê trá sı̣́sı̣́ lı̣̃mvû ạ́pậrı̣̂ ꞌdĩ kâ rĩ ꞌbá rû îyálé ꞌdĩ ꞌá rî, kôrô ngá lãzé gólâkâ ꞌdĩ drí rû ndẽzó.) Ĩꞌdî ngá lãzé ꞌbá ꞌdĩ ꞌbá yî rî lı̣̃mvû ꞌdĩ rû îyâ-îyâ lâ tẽlé. ");
INSERT INTO avu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","6","Gõꞌdá Yésũ yî câ bê ạ́pậrı̣̂ ꞌdĩ tı̣́ ꞌálâ rî, gólĩyî drí ãgô ãzâ ûsúzó tólâ, ậyı̣́ꞌá gbũrũkũ drı̣̃ı̣̂ ngá lãzé bê, ãgô rî ꞌdĩ ꞌê trá ndrô nyâꞌdî-trá-drı̣̃-lâ-ngâ-mûdrı̣́-drı̣̃-lâ-ngâ-njı̣̂-drı̣̃-lâ-nâ ngá lãzé íyíkâ ꞌdĩ bê. Gõꞌdá Yésũ ndrélé bê ãgô ngá lãzé bê ꞌdĩ ậyı̣́rı̣̃ ꞌá vũdrı̣́ rî, drílâ nı̣̃zó lâ kĩ, ãgô ꞌdĩ ꞌê trá ndrô ãmbá lâŋõ ngá lãzé íyíkâ ꞌdĩ kâ bê. Gõꞌdá Yésũ drí ãgô rî ꞌdĩ îjízó kĩ, “Ámâ ậdrúpı̣̃, ní lẽ ngãlé ngá lãzé áníkâ ꞌdĩ ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Gõꞌdá ãgô ngá lãzé bê ꞌdĩ drí tã lôgõzó Yésũ drí kĩ, “Óõ ãmbá, mâ õjílã ãkó ámâ zẽlé ꞌwãâ lı̣̃mvû ꞌdĩ ꞌá tólâ, õzõ lı̣̃mvû ꞌdĩ õtírĩ rû îyá kãgbã-kãgbã rî. Tãlâ má õtírĩ ámákâ drẽ rĩî ámâ sẽlé mãnísĩ rî, ạ̃kû ró õjílã gólĩyî mbârâkã bê rî ꞌbá yî ꞌdê ĩyîngá trá sı̣́sı̣́ má drí lı̣̃mvû ꞌá tólâ.” ");
INSERT INTO avu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Gõꞌdá Yésũ drí tã âtázó gólâ drí kĩ, “Ní ngâ ûrû! Ní pâ gbũrũkũ áníkâ, ní ngâ nĩꞌá lậmú bê!” ");
INSERT INTO avu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ĩtí rî, kôrô ãgô ꞌdĩ pá lâ drí âmbázó óꞌdí, té õzõ ạ̃kû rî tí. Gõꞌdá drílâ ngãzó ûrû gbũrũkũ íyíkâ pãlé nĩzó lậmú bê. ꞌDĩî Yésũ îngâ ãgô ꞌdĩ ngá lãzé ꞌásĩ, té kậyı̣̂ Yúdạ̃ yí kâ lôvô kâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tã ꞌdî tãsĩ rî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ãzâ ꞌbá yî ndrê bê ãgô Yésũ drí îngálé ngá lãzé ꞌásĩ ꞌdî nĩꞌá lậmú bê lạ́tı̣̂ ꞌásĩ gbũrũkũ íyíkâ bê yí drı̣̃ı̣̂ kậyı̣̂ ĩyíkâ lôvô kâ sĩ rî, gólĩyî drí ꞌbãzó ạ̃wạ̃ ró ãgô ꞌdĩ bê. Gõꞌdá gólĩyî drí tã îjízó ãgô ꞌdĩ tı̣́ kĩ, “Nî, tãlâ ãꞌdô ꞌî ní drí rĩzó ngá njı̣̃lı̣́ kậyı̣̂ ãmákâ kậyı̣̂ lôvô kâ sĩ yã? Ní nı̣̃ı̣́ kĩꞌá nĩ rî, ãndrõ nô rî kậyı̣̂ ãmákâ rãtáã ꞌẽ kâ ꞌî rî kô yã? ꞌDĩî rĩꞌá tã õnjí ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Gõꞌdá ãgô ꞌdĩ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Tã ámákâ bê yã? Mâ ámângá kó ậyı̣́ꞌá ngá lãzé ámákâ bê gõꞌdá ãgô ãzâ drí ânĩzó ámâ îngálé ngá lãzé ámákâ ꞌdĩ ꞌásĩ, gõꞌdá drílâ tã âtázó má drí kĩ, má õngâ má õtrõ gbũrũkũ ámákâ, má õnĩ lậmú bê. Ĩꞌdî má drí rĩzó nĩlí nõ.” ");
INSERT INTO avu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Gõꞌdá drílĩyî tã âtázó ãgô ꞌdĩ drí kĩ, “Õjílã õnjí rî gógó gólâ tã âtá ꞌbá ní drí kĩꞌá nĩ rî, ní õtrõ gbũrũkũ áníkâ nĩzó ĩꞌdí bê lâ kậyı̣̂ ãmákâ rãtáã ꞌẽ kâ nõ ꞌá nõ íyíkâ ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Gõꞌdá ãgô ꞌdĩ îcá kô tã îjî gólĩyíkâ ꞌdĩ tã-drı̣̃ lâ lôgõlé, tãlâ gólâ nı̣̃ı̣́ õjílã íyî îngá ꞌbá ngá lãzé ꞌásĩ ꞌdî rú lâ kô. Tãlâ Yésũ îngâ gólâ bê ngá lãzé ꞌásĩ rî, Yésũ drí íyîngá kôrô fĩzó ꞌwãâ õjílã õꞌbí ạ́pậrı̣̂ tı̣́ ꞌdĩ ꞌbá yî lãfálé. ");
INSERT INTO avu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tã ndrĩ ꞌdî vósĩ rî, ãgô îngálé ngá lãzé ꞌásĩ ꞌdî drí ngãzó kpá nĩlí jó ạ́ngı̣́ Ôvârí kâ rî ꞌálâ. Gõꞌdá Yésũ drí gólâ rî ûsúzó kpá óꞌdí jó Ôvârí kâ nã ꞌálâ. Gõꞌdá Yésũ drí tã âtázó gólâ drí kĩ, “Ámâ ậdrúpı̣̃, ópâ nî trá! Ngbãângbânõ rî, ní âyê tã õnjí ꞌẽꞌẽ. Õzõ ní ãâyê tã õnjí ꞌẽꞌẽ kô rî, ngá ãzâ õnjí tẽtẽ lâ âꞌdô âꞌdóꞌá ní bê gạ̃rạ̃ sı̣́sı̣́ ꞌdĩ drı̣̃ı̣̂ sĩ.” ");
INSERT INTO avu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gõꞌdá ãgô ꞌdĩ drí ngãzó nĩlí ꞌwãâꞌwâ drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ tíbê gólâ rî îjí ꞌbá sı̣́sı̣́ rî yî ngálâ. Gõꞌdá drílâ tã âtázó gólĩyî drí kĩ, “Ãgô tíbê ámâ îngá ꞌbá ngá lãzé ꞌásĩ ãnî drí rĩꞌá tã lâ îjílí má tı̣́ rî, gólâ ĩꞌdî ãgô gólâ rĩꞌá zı̣̃lâ Yésũ rî.” ");
INSERT INTO avu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ârî ĩyî bê tã ꞌdî ĩtí rî, gólĩyî ꞌbãá Yésũ rî lôvó gõꞌdá kô, tãlâ tã Yésũ drí ꞌẽlé kậyı̣̂ gólĩyíkâ rãtáã kâ ꞌdĩ ꞌá ꞌdĩ tãsĩ. Gõꞌdá gólĩyî drí rĩzó zãâ Yésũ rî îkpókpólõlé úlı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Gõꞌdá Yésũ drí tã âtázó gólĩyî drí gólĩyî lı̣̃fı̣́ drı̣̃ ꞌá kĩ, “Tãlâ ãꞌdô ꞌî nĩ lẽé tã gólâ má drí rĩꞌá ꞌẽlâ nõ kô yã? Nĩ nı̣̃ı̣́ kô kĩꞌá nĩ rî, ámâ átá Ôvârí rî lôsĩ ꞌẽlé kậyı̣̂ vósĩ cé yã? Gólâ rî zãâ ãnî vó ndrẽlé kậyı̣̂ rãtáã kâ ꞌá. Tãlâ ĩꞌdî ꞌdĩ má drí rĩzó kpá lôsĩ ꞌẽlé kậyı̣̂ rãtáã kâ sĩ ꞌdî, õzõ ámâ átá kâtí.” ");
INSERT INTO avu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Úlı̣́ Yésũ kâ ꞌdĩ drí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ꞌbãzó âꞌdólé ạ̃wạ̃ ró rõô. Yésũ rî lôvó drí fõzó gólĩyî ꞌásĩ zãâ gbạ́dú. Gõꞌdá drílĩyî rĩzó lạ́tı̣̂ lôndãlé, ãꞌdô ró bê Yésũ rî fũzó vólé. Tã ífí gólĩyî drí ꞌbãzó ạ̃wạ̃ ró Yésũ bê rî, tãlâ Yésũ ró lãꞌbí gólĩyíkâ kĩꞌá nĩ rî, kậyı̣̂ rãtáã kâ ꞌdĩ ãâꞌdô kậyı̣̂ lôvô kâ ꞌî õjílã õꞌê lôsĩ ꞌá lâ kô rî kô. Gõꞌdá ngîngî lâ, tã pạ̃tı̣́ı̣̃ gólâ Yésũ drí Ôvârí rî zı̣̃zó íyî átá ró ꞌdĩ ꞌbã gólĩyî trá âꞌdólé ạ̃wạ̃ ró rõô, tãlâ tã ı̣̂sũ gólĩyíkâ ꞌá rî, úlı̣́ Yésũ kâ ꞌdĩ rî âꞌdálâ kĩ, Yésũ ãâmã yî trá âꞌdólé Ôvârí ró. ");
INSERT INTO avu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ ꞌdĩ ꞌbá yî rî ĩyî bê Yésũ rî tı̣̂ ânyálé rî, Yésũ drí gõzó tã âtálé gólĩyî drí kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́-pạ̃tı̣̃ ró, má îcá kô tã ꞌẽlé cú ĩtí ámâ átá ãkó. Má rî cé tã Ôvârí drí rĩꞌá ꞌẽlâ rî ꞌbá yî ꞌẽlé ĩꞌdî. Má lẽ cé ngá gólâ drí lẽlé má drí ꞌẽlé rî ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tãlâ ámâ átá lẽ mâ íyî mvá trá rõô, ĩꞌdî ꞌdĩ gólâ drí ngá yí drí lẽlé ꞌẽlé rî âꞌdázó ndrĩ má drí. Má âtâ ãnî drí, ámâ átá âꞌdô ámâ ꞌbãꞌá tã tãndí ãzâ ꞌbá yî ꞌẽlé gạ̃rạ̃ tã gólâ ãnî drí ndrẽlé nõ drı̣̃ı̣̂ sĩ. Nĩ õtírĩ ámâ ndrẽê ꞌẽrẽ lâ ꞌá rî, gõꞌdá ãnî tı̣̂ âꞌdô ậꞌdı̣́ꞌá ậꞌdı̣̂. ");
INSERT INTO avu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ámâ átá rî õjílã lîdrílí õdrã ꞌásĩ gólĩyî ꞌbãlé âꞌdólé lédrẽ-lédrẽ ró, õzõ drílâ lẽlé rî tí. Mâ rî gógó gólâ rî mvá ró nõ âꞌdô kpá õjílã lîdríꞌá õdrã ꞌásĩ gólĩyî ꞌbãlé âꞌdólé lédrẽ-lédrẽ ró, õzõ má drí lẽlé rî tí, nyé õzõ ámâ átá kâtí. ");
INSERT INTO avu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Gõꞌdá ámâ átá fẽ drı̣́-ãcê trá ndrĩ má drı̣́gạ́, má drí tã-vó õjílã ndrĩ kâ kĩzó. ");
INSERT INTO avu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Gólâ ꞌê tã ꞌdî ĩtí ꞌdĩ rî, tãlâ õjílã ndrĩ ı̣̃ı̣̂njı̣̃ ró mâ bê íyî mvá ró, õzõ gólĩyî ãꞌdô fí gólâ rî ı̣̂njı̣̃ ꞌbá ꞌî rî. Õzõ õjílã ãzâ ı̣̃ı̣̂njı̣̃ mâ Ôvârí rî mvá ró nõ kô rî, õjílã rî gógó ꞌdĩ ı̣̂njı̣̃ı̣́ ámâ átá gólâ tíbê ámâ âjó ꞌbá nõ kpá kô. ");
INSERT INTO avu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Má âtâ ãnî drí tã pạ̃tı̣́-pạ̃tı̣̃ ró, õzõ õjílã ãzâ ãârî úlı̣́ má drí rĩꞌá âtálâ rî ꞌbá yî trá, gõꞌdá õjílã rî ꞌdĩ drí tã lẽzó kĩ, Ôvârí âjô mâ nĩ rî, õjílã rî gógó ꞌdĩ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá. Õjílã rî ꞌdĩ rúꞌbạ́ ı̣̃nyạ́kú lâ õdrã lé rî, lôvó-lôvó lâ âꞌdô rĩꞌá zãâ gbạ́dú ạ̃dũkũ ãkó õdrã gólâkâ vósĩ, tãlâ lâŋõ má drí ꞌẽꞌá fẽlâ gólâ drí tã õnjí gólâkâ tãsĩ rî, má fẽé gõꞌdá kô. Gólâ lậvũ trá õdrã ꞌásĩ fĩlí lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Má âtâ tã pạ̃tı̣́ı̣̃ ró, kậyı̣̂ âcâ trá tã óꞌdí drí rû ꞌẽzó ngbãângbânõ! Gõꞌdá mâ rî gógó Ôvârí rî mvá ró nõ âꞌdô tã âtáꞌá õjílã gólĩyî ôdrã ꞌbá rî yî drí, gólĩyî drí ámâ gbórókõ ârízó, gõꞌdá drílĩyî ngãzó âfõlé õdrã ꞌásĩ rĩlí lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó. ");
INSERT INTO avu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tãlâ ámâ átá fẽ mbârâkã trá má drí õjílã îngázó õdrã ꞌásĩ óꞌdí rĩlí lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó, nyé õzõ gólâ drí ngá ndrĩ lôꞌbãrẽ tí, gõzó ngá ndrĩ ꞌdî ꞌbá yî vó lâ ndrẽlé âꞌdólé lédrẽ-lédrẽ ró cé íyî úlı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Gõꞌdá lạ́tı̣̂ ãlô-ãlô ꞌdĩ ꞌásĩ, ámâ átá Ôvârí âfẽ drı̣́-ãcê kpá trá má drí tã-vó õjílã ndrĩ kâ kĩzó, tãlâ mâ gólâ rî mvá ꞌî, gõꞌdá ĩꞌdî gólâ drí ámâ âjózó ûrú lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ãnî tı̣̂ rî ậꞌdı̣́lı̣́ úlı̣́ má drí rĩꞌá âtálâ nõ ꞌá tãlâ ãꞌdô ꞌî yã? Nĩ lẽ tã úlı̣́ má drí âtálé nõ ꞌá. Kậyı̣̂ âbí âcáꞌá, má drí õjílã gólĩyî ndrĩ ôdrã ꞌbá trá rî yî zı̣̃zó, drílĩyî lạ̃zı̣́ ámákâ ârízó, gõꞌdá drílĩyî ngãzó âfõlé õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Gõꞌdá õjílã gólĩyî tã tãndí ꞌẽ ꞌbá kậyı̣̂ drílĩyî ꞌbãzó lédrẽ-lédrẽ ró rî sĩ rî, âꞌdô ngãꞌá õdrã ꞌásĩ rĩlí lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó. Gõꞌdá õjílã gólĩyî tã õnjí ꞌẽ ꞌbá kậyı̣̂ drílĩyî ꞌbãzó drẽ lédrẽ-lédrẽ ró ı̣̃nyạ́kú drı̣̃ı̣̂ nõngá nõ ꞌá rî, âꞌdô ĩyî lâŋõ zãâ gbạ́dú ạ̃dũkũ ãkó rî ûsúꞌá. ");
INSERT INTO avu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tã ndrĩ má drí rĩꞌá ꞌẽlâ rî, âꞌdó kô tã ámâ nyãányâ kâ ĩꞌdî. Má rí kô tã ámâ nyãányâ drí lẽlé rî ꞌẽlé ĩꞌdî. Má âꞌdô tã-vó õjílã kâ kĩꞌá, nyé õzõ ámâ átá drí âꞌdálé trá má drí rî kâtí. Õzõ ꞌdĩî rî kâtí rî, má rî tã-vó õjílã kâ kĩlí lạ́tı̣̂ mbı̣̂ ꞌásĩ, tãlâ má rî té tã gólĩyî ámâ átá ámâ âjó ꞌbá rî drí lẽlé rî ꞌẽlé ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Má âtâ ãnî drí, nĩ ı̣̂sũ ãníkâ bê rî, má lôngô ꞌdĩ ámâ tã ꞌî yã? Âꞌdó ĩtí kô. Õzõ má õró nõ rĩî ámâ nyãányâ tã lôngólé ĩꞌdî rî, tí tã ndrĩ má drí rĩꞌá âtálâ nõ ꞌbá yî âꞌdô ꞌbãꞌá ndrĩ tã tãkó ró. ");
INSERT INTO avu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pạ̃tı̣́-pạ̃tı̣̃ ró, ámâ átá Ôvârí âꞌdâ tã pạ̃tı̣́ı̣̃ ámákâ rî nĩ ãnî drí. Gõꞌdá má nı̣̃ trá kĩ, tã drílâ âꞌdálé ámâ tãsĩ rî rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nĩ jô õjílã trá Yõwánĩ ngálâ, gólĩyî ãꞌdô ró tã gólâkâ ârílí. Gõꞌdá Yõwánĩ drí tã pạ̃tı̣́ı̣̃ âtázó gólĩyî drí ámâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tã bê âꞌdó ꞌbá tãndí ró lậvũlı̣́ gạ̃rạ̃ úlı̣́ õjílã mvá õzõ Yõwánĩ kâtí rî kâ drı̣̃ı̣̂ sĩ. Gõꞌdá má rî tã nô âtálé úlı̣́ Yõwánĩ kâ tãsĩ, tãlâ úlı̣́ gólâkâ ꞌdĩ ãâgâ ró bê ãnî drı̣̃ı̣̂, gõꞌdá nĩ âdĩ ró drı̣̃ bê tã õnjí ãníkâ rî ꞌásĩ ânĩlí má ngálâ, má pâ ró ãnî bê. ");
INSERT INTO avu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yõwánĩ rĩꞌá õzõ ngá îꞌĩ gólâ tíbê rĩ ꞌbá lạ́tı̣̂ îꞌĩlí ãnî drí rî kâtí. Gõꞌdá nĩ âꞌdô trá ãyĩkõ ró tã lẽlé úlı̣́ gólâkâ ꞌá kậyı̣̂ dã sĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tã tíbê âꞌdó ꞌbá ꞌbãlé tãndí ró lậvũlı̣́ gạ̃rạ̃ úlı̣́ Yõwánĩ kâ drı̣̃ı̣̂ sĩ rĩꞌá tã gólĩyî má drí rĩꞌá ꞌẽlâ nõ rî, gólĩyî rî tã âꞌdálé kĩ, Ôvârí âjô mâ nĩ. Má rî nõ té tã ámâ átá drí âtálé má drí ꞌẽlé rî ꞌẽlé ĩꞌdî ndẽlé. ");
INSERT INTO avu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","“Õzõ pạ̃tı̣́ı̣̃ nĩ ũnı̣̃ úlı̣́ Ôvârí kâ fí trá dódó rî, nĩ âꞌdô nı̣̃ꞌá lâ kĩ, pạ̃tı̣́ı̣̃ Ôvârí âjô mâ nĩ, tãlâ búkũ gólâkâ ꞌá rî, gólâ âtâ tã ámâ âcâ-âcâ kâ trá ãnî drí. Gõꞌdá nĩ gã trá dó tã lẽlé úlı̣́ gólâkâ ꞌdĩ ꞌá, nĩ ârí gólâ rî úlı̣́ kô ãnî bı̣́ sĩ, gõꞌdá nĩ ndré gólâ kpá kô ãnî lı̣̃fı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nĩ rî zãâ kárá búkũ Ôvârí kâ rî zı̣̃lı̣́ mãnísĩ, tãlâ ãnî drí tã mbı̣̂ ûsúzó lédrẽ-lédrẽ ạ̃dũkũ ãkó rî tãsĩ, gõꞌdá tãlâ ãꞌdô ꞌî ãnî drí tã lẽzó kô kĩ, búkũ Ôvârí kâ ꞌdĩ rî ámâ tã âtálé ĩꞌdî ãnî drí yã? ");
INSERT INTO avu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gõꞌdá nĩ rî ámâ gãlé dó ãꞌdô tãsĩ yã? Mâ ĩꞌdî õjílã lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽ ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","43","“Má nı̣̃ trá, ãnî ndrĩ, nĩ lẽé Ôvârí kô ãlôlâ, tãlâ nĩ lẽé kô tã lẽlé tã âtî-âtî má drí ânĩzó ĩꞌdí bê lâ nõ ꞌá. Ámâ átá Ôvârí âjô mâ nĩ ânĩlí ãnî îmbálé. Gõꞌdá má ndrê bê rî, nĩ ꞌê ãníkâ tã lẽlé cé õjílã gólâ ânĩ ꞌbá íyî tã lôngô-lôngô bê kĩ, yí ãâꞌdô íyíkâ ĩꞌdî gạ̃rạ̃ rî ꞌá! Mâ rî gógó nyãányâ lâ nõ, tã ı̣̂sũ ámákâ rî âꞌdó kô cé ãnî õjílã drí ámâ lûyı̣́lı̣́ ĩꞌdî. Má lẽ ámákâ cé ãnî drí tã lẽlé tã âtî-âtî ámákâ nõ ꞌá ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tí nĩ âꞌdô tã lẽꞌá má ꞌá ángô tí, õzõ nĩ õꞌbã lı̣̃fı̣́ nõ gbõ zãâ ngá gólĩyî ãngó nõ kâ rî ꞌbá yî vó, tãlâ ãnî ãzí-ãzí yî ũlûyı̣̂ ró ãnî rú bê kĩ, ãnî ãꞌdô õjílã tãndí ꞌî rî yã? ꞌDĩî gõꞌdá nĩ lẽé kô tã gólĩyî sũ ꞌbá Ôvârí rú rî ꞌbá yî ꞌẽlé. ");
INSERT INTO avu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ãnî, nĩ gã úlı̣́ ãnî ạ́ꞌbı̣́yạ́ Músạ̃ kâ kpá trá dó, tíbê ãnî drí kĩꞌá nĩ, ãâꞌdô tã ãnî drí lı̣̃fı̣́ ꞌbãzó vó lâ rî âtáꞌá nĩ ãnî tãsĩ Ôvârí ágálé rî. Gõꞌdá nĩ gã bê úlı̣́ gólâkâ ámâ tãsĩ rî kpá trá dó ꞌdĩ rî, Músạ̃ rî gógó âꞌdô âdréꞌá gõꞌdá kpá nĩ Ôvârí ágálé ãnî ạ̃lı̣̃ âŋõlé. Âꞌdó kô mâ rî gógó nõ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nĩ ndrê trá, tí nĩ õró úlı̣́ Músạ̃ kâ âtálé rî lẽê rî, tí nĩ lẽ tã kpá trá úlı̣́ ámákâ ꞌá, tãlâ Músạ̃ rî tã âtálé âcâ-âcâ ámákâ rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gõꞌdá nĩ lẽé bê tã tã Músạ̃ drí îgĩlí trá rî ꞌá kô rî, ĩtí rî, tí nĩ âꞌdô tã lẽꞌá úlı̣́ má drí âtálé rî ꞌá ángô tí yã?” ꞌDĩî úlı̣́ Yésũ drí âtálé drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ drí Yẽrõsãlémã ꞌálâ rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gõꞌdá ꞌdĩî vósĩ rî, Yésũ yî drí âgõzó Yẽrõsãlémã lésĩ gõlé Gãlĩláyã ꞌálâ lãjóꞌbá íyíkâ rî ꞌbá yí bê. Kậyı̣̂ ãzâ sĩ, gólĩyî drí ngãzó fĩlí kõlóngbõ ꞌá mbãlé lı̣̃mvû ândrê Gãlĩláyã kâ rî ꞌáꞌá lé drı̣̃ lâ lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","4","ꞌDĩî rĩꞌá kậyı̣̂ kãrámã Yúdạ̃ yí kâ zı̣̃lı̣́ kãrámã lậvũ-lậvũ kôrô kâ rî trá ãnyî. Gõꞌdá õjílã ndrê bê tã lârâkô Yésũ drí rĩꞌá ꞌẽlâ rĩzó õjílã îngálé ngá lãzé ꞌásĩ ꞌdî rî, gólĩyî drí ngãzó ꞌdó ꞌdẽlé gólâ vósĩ. Nĩngá sĩ, Yésũ yî drí nĩzó mbãlé lũtú drı̣̃ı̣̂ ꞌálâ, gõꞌdá gólĩyî drí rĩzó vũdrı̣́ lãjóꞌbá íyíkâ rî ꞌbá yí bê dîrî yí lạ̃gạ́tı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Gõꞌdá Yésũ õtírĩ rĩî lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî lı̣̃fı̣́ lâ yî îcílí rî, ꞌdĩî õjílã ãzâ ꞌbá yî kpá bê dũû rĩꞌá ĩyî ânĩꞌá gólâ ngálâ. Gõꞌdá Yésũ jâ lı̣̃fı̣́ bê gólĩyî ndrẽlé dîrî rî, drílâ ngãzó tã îjílí Fílĩpõ tı̣́ kĩ, “Fílĩpõ, mã âꞌdô ngá nyãnyã ûsúꞌá ãꞌdô ꞌásĩ gĩlí fẽlé õjílã õꞌbí nõ ꞌbá yî drí nyãlé yã?” ");
INSERT INTO avu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yésũ îjî tã ꞌdî Fílĩpõ tı̣́ ꞌdĩ, ãꞌdô ró tã ı̣̂sũ Fílĩpõ kâ ûjũzó, ngãtá Fílĩpõ lẽ tã trá kĩ, yî Yésũ cú rĩꞌá mbârâkã bê ngá nyãnyã ûsúzó fẽlé õjílã dũû rĩ ꞌbá ânĩlí ꞌdĩ ꞌbá yî drí yã. Tákõ gólâ nı̣̃ íyîngá tã yí drí ꞌẽꞌá ꞌẽlâ rî trá. ");
INSERT INTO avu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Gõꞌdá nĩngá sĩ, Fílĩpõ drí tã ꞌdî drı̣̃ lâ jãzó Yésũ drí kĩ, “Mã âꞌdô ngá nyãnyã rî ꞌdĩ ûsúꞌá õjílã õꞌbí ꞌdĩ ꞌbá yî drí ĩtí ꞌdĩ ãꞌdô ꞌásĩ yã? Õzõ kpálé óõtrõ ậdı̣̂ kậyı̣̂ kámá-rı̣̃ kâ ãmbãtã gĩzó rî, îcá õjílã õꞌbí ꞌdĩ ꞌbá yî drí nyãlé cé tı̣̂tı̣̂ kô.” ");
INSERT INTO avu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gõꞌdá nĩngá sĩ, lãjóꞌbá Yésũ kâ Sĩmónã Pétẽrõ rî ậdrúpı̣̃ ró rú bê Ãndĩríyã rî drí tã âtázó Yésũ drí kĩ, ");
INSERT INTO avu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ágámvá ãzâ bê rĩꞌá nõ, gólâ cú ãmbãtã dãdãwá bê njı̣̂, gólâ kpá cú ı̣̃ꞌbı̣̂ fínyá-fînyâwá bê rı̣̃. Gõꞌdá õzõ kpálé mã õfẽ ãmbãtã njı̣̂ ꞌdĩ gõꞌdá ı̣̃ꞌbı̣̂ rı̣̃ ꞌdî ꞌbá yí bê õjílã õꞌbí ꞌdĩ ꞌbá yî drí nyãlé rî, îcá gólĩyî drí kô.” ");
INSERT INTO avu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Gõꞌdá ĩtí rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ rî ꞌbá yî drí, gólĩyî ãâtâ ró tã õjílã õꞌbí ꞌdĩ ꞌbá yî drí, tãlâ õrî ró ĩyî bê vũdrı̣́ ngá nyãlé. Gõꞌdá õjílã õꞌbí ꞌdĩ ꞌbá yî drí rĩzó vũdrı̣́ õmã ạ̃rú drı̣̃ı̣̂ ngá nyãnyã tẽlé. Õjílã rĩ ꞌbá ꞌdĩ ꞌbá yî rĩꞌá kútũ-njı̣̂. ꞌDĩî ólã cé ãgô ĩꞌdî, gõꞌdá ólãá õkó ꞌdĩyímvá bê kô. ");
INSERT INTO avu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Gõꞌdá nĩngá sĩ, Yésũ drí ãmbãtã njı̣̂ ꞌdĩ trõzó, gõꞌdá drílâ rãtáã ꞌẽzó Ôvârí drí, gõꞌdá drílâ fẽzó lâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí, gólĩyî õlânjî ró õjílã õꞌbí gólĩyî rĩ ꞌbá vũdrı̣́ ꞌdĩ ꞌbá yî drí. Gõꞌdá gólâ drí ı̣̃ꞌbı̣̂ rı̣̃ ꞌdî ꞌbá yî ꞌẽzó kpá ĩtí. Mbârâkã Ôvârí kâ sĩ, ãmbãtã njı̣̂ ꞌdĩ ꞌbá yî gõꞌdá kpá ı̣̃ꞌbı̣̂ rı̣̃ ꞌdî ꞌbá yí bê drí õjílã õꞌbí ꞌdĩ ꞌbá yî îcázó ndrĩ. ");
INSERT INTO avu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Gõꞌdá õꞌbí ꞌdĩ ꞌbá yî nyâ ĩyî ngá nyãnyã bê îcálé dũû rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí, gólĩyî ũûꞌdû ngá nyãnyã ạ̃mbúkũ õjílã õꞌbí ꞌdĩ ꞌbá yî drí nyãlé âyélé ꞌdĩ ꞌbãlé dódó, õzó kô rû îzãâ. ");
INSERT INTO avu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gõꞌdá ĩtí rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî drí ãmbãtã ạ̃mbúkũ ı̣̃ꞌbı̣̂ bê lâkí ꞌbá ꞌdĩ ûꞌdúzó ívõ ꞌásĩ dũûdû. ꞌDĩî cé ãmbãtã dãdãwá njı̣̂ gõꞌdá ı̣̃ꞌbı̣̂ fínyá-fînyâwá bê rı̣̃ Yésũ drí rãtáã ꞌẽzó drı̣̃ lâ rî drí õjílã õꞌbí ꞌdĩ ꞌbá yî îcázó, gõꞌdá ạ̃mbúkũ lâ drí kpá lâkízó ívõ ꞌásĩ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃. ");
INSERT INTO avu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Gõꞌdá nĩngá sĩ, õjílã õꞌbí ꞌdĩ ꞌbá yî ndrê ĩyî bê tã lârâkô Yésũ drí ꞌẽlé mbârâkã Ôvârí kâ sĩ ngá nyãnyã ꞌdî ꞌẽzó âcálé dũû rî, tı̣̂ lâ ĩyî drí ậꞌdı̣́zó. Gõꞌdá drílĩyî tã ı̣̂sũzó kĩ, “Ãꞌdô ĩtí rî, ꞌdĩî trá pạ̃tı̣́ı̣̃ ꞌdíyî pã ꞌbá gólâ Ôvârí drí tã lâ ꞌbãlé trá búkũ íyíkâ ꞌá ꞌẽꞌá âjólâ ãmâ pãlé rî ĩꞌdî, ĩꞌdî gólâ âcâ trá.” ");
INSERT INTO avu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Gólĩyî lẽ trá Yésũ rî ꞌbãlé âꞌdólé kúmú gólĩyíkâ ró mbârâkã sĩ, tãlâ gólâ õdrô ró bê ạ̃jú-ꞌbá-ãzí gólĩyíkâ vólé. Tákõ, Yésũ nı̣̃ tã ı̣̂sũ gólĩyíkâ ꞌdĩ trá ạ̃kû, gõꞌdá tã ı̣̂sũ gólĩyíkâ ꞌdĩ sú gólâ rú kô, gõꞌdá gólâ drí íyîngá ꞌbẽzó kírî élêwálâ ró nĩlí íyî lậpı̣́lı̣́ únı̣́ lãfálé. ");
INSERT INTO avu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Gõꞌdá ngá drí ậnı̣́rı̣̃ ꞌá, Yésũ drẽ zãâ únı̣́ lãfá ꞌálâ. Lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí ngãzó nĩlí gõlé lı̣̃mvû ândrê tı̣́ ꞌálâ, ãꞌdô ró nĩꞌá kõlóngbõ mbãlé nĩzó gõlé Kãpẽrãnómã ꞌálâ ró. Gõꞌdá Yésũ rî gógó âgõó drẽ kô gólĩyî ngálâ. Gõꞌdá ngá ậnı̣̂ bê gólĩyî ûsúlı̣́ drẽ ãkpã lı̣̃mvû ító ꞌâ ꞌá rî, ꞌdĩî Yésũ âcá drẽ zãâ gólĩyî ngálâ kô. ");
INSERT INTO avu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gõꞌdá gólĩyî câ bê kõlóngbõ bê lı̣̃mvû ândrê ꞌdĩ kâ ꞌdĩ ító ꞌâ lâ ꞌá rî, kạ̃gũmạ́ạ̃ ândrê drí îtõzó rĩꞌá ậsı̣̃lı̣́ mbârâkã sĩ. Gõꞌdá lı̣̃mvû drı̣̃ drí rĩzó rû îyálé mbârâkã sĩ kãgbã-kãgbã. ");
INSERT INTO avu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Gõꞌdá ꞌdĩî gólĩyî nĩ trá õzõ kĩlõmítĩrĩ njı̣̂ kâtí lı̣̃mvû ândrê ꞌdĩ tı̣́ sĩ, drílĩyî ngá ndrẽzó vólé rî, drílĩyî õjílã ãzâ ndrẽzó ânĩꞌá gólĩyî ngálâ lı̣̃mvû drı̣̃ı̣̂ sĩ, kôrô ũrı̣̃ drí gãzó gólĩyî rú. ");
INSERT INTO avu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gõꞌdá Yésũ âcâ bê ãnyî rî, gólâ drí tã âtázó gólĩyî drí kĩ, “Nĩ ꞌê ũrı̣̃ kô! Nĩ nı̣̃ı̣́ kô kĩ, nõô mâ ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Gõꞌdá lãjóꞌbá ꞌdĩ ꞌbá yî drí ꞌbãzó ndrĩ ãyĩkõ ró, drílĩyî Yésũ rî ậzı̣́zó mbãlé kõlóngbõ ꞌá ĩyî ngálâ. Gõꞌdá ꞌwãâ ró, kõlóngbõ ꞌdî drí cãzó tãndí ró lı̣̃mvû tı̣́ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gõꞌdá cı̣̃ı̣́nó ãzâ lâ sĩ rî, õꞌbí gólĩyî Yésũ drí ngá nyãnyã fẽzó drílĩyî rî drí ngãzó rĩꞌá Yésũ rî lôndãlé võ ngá nyãnyã fẽzó drílĩyî ꞌdĩ ꞌá nĩngá, tãlâ gólĩyî nı̣̃ trá kĩ, ậgı̣́ rî, kõlóngbõ kó cé ãlô lãjóꞌbá Yésũ kâ drí mbãzó ꞌá lâ nĩlí Kãpẽrãnómã ꞌálâ rî ĩꞌdî, gõꞌdá gólĩyî nı̣̃ kpá trá kĩ, Yésũ mbãá kô kõlóngbõ ꞌdî ꞌá nĩlí lãjóꞌbá íyíkâ yí bê. ");
INSERT INTO avu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Gõꞌdá kõlóngbõ ãzâ ꞌbá yî drí kpá âcázó jạ̃rı̣́bạ̃ Tĩbérĩyã kâ rî lésĩ âdrélé ãnyî võ Yésũ drí ngá nyãnyã fẽzó õꞌbí ꞌdĩ ꞌbá yî drí ꞌdĩ lạ̃gạ́tı̣́ nĩngá. ");
INSERT INTO avu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gõꞌdá õꞌbí ꞌdĩ ꞌbá yî lôndã ĩyî bê Yésũ trá kpı̣̃ı̣̂, gõꞌdá lãjóꞌbá gólâkâ âꞌdô bê kpá tólâ yûꞌdạ́wạ́ rî, gólĩyî drí mbãzó kõlóngbõ âcá ꞌbá Tĩbérĩyã lésĩ ꞌdî ꞌbá yî ꞌá, ãꞌdô ró nĩlí Kãpẽrãnómã ꞌálâ Yésũ rî lôndãlé tólâ. ");
INSERT INTO avu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Gõꞌdá Kãpẽrãnómã ꞌá tólâ rî, õjílã ꞌdî ꞌbá yî drí Yésũ rî ûsúzó jó tã Ôvârí kâ ârî kâ ꞌá õjílã bê dũû. Gõꞌdá drílĩyî Yésũ rî îjízó kĩ, “Lı̣̃fı̣́ îmbá ꞌbá, ní âcâ nõngá ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nĩngá sĩ, Yésũ drí tã âtázó gólĩyî drí kĩ, “Nĩ rî ámâ lôndãlé tãlâ ãꞌdô ꞌî yã? Nĩ rî ámâ ndãlé nõ cé ngá nyãnyã má drí fẽlé ãnî drí ậgı̣́ rî tãsĩ, âꞌdó kô tã lârâkô má drí ꞌẽlé trá rî tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pạ̃tı̣́-pạ̃tı̣̃ ró, má âtâ ãnî drí, nĩ âyê nyãsá tíbê ꞌẽ ꞌbá lâvãlé ãnî ꞌásĩ ꞌwãâ rî ndãndã lâ. Nĩ ndã nyãsá gólâ tíbê ꞌẽ ꞌbá ãnî pãlé gbạ́dú rî ĩꞌdî, tãlâ lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽlé ãnî drí. ꞌDĩî ngá nyãnyã tíbê mâ rî gógó ânĩ ꞌbá ûrú lésĩ nõ drí ꞌẽꞌá fẽlâ ãnî drí rî ĩꞌdî. Ámâ átá Ôvârí âjô mâ nĩ ngá nyãnyã fẽlé ãnî drí, gõꞌdá tã ámákâ sû trá gólâ rú rõô.” ");
INSERT INTO avu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Gõꞌdá Yésũ âtâ bê úlı̣́ ꞌdĩ ĩtí rî, õjílã ꞌdî ꞌbá yî drí tã îjízó gólâ tı̣́ kĩ, “Õzõ ãꞌdô ĩtí rî, mã âꞌdô ãꞌdô ꞌẽꞌá ĩꞌdî sũlı̣́ Ôvârí lı̣̃fı̣́ yã?” ");
INSERT INTO avu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yésũ drí gõzó kpá tã-drı̣̃ lôgõlé gólĩyî drí kĩ, “Tã Ôvârí drí lẽlé ãnî drí ꞌẽlé rî cé ĩꞌdî nõ, ãnî drí tã lẽlé mâ rî gógó gólâ Ôvârí drí âjólé nõ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Gõꞌdá õjílã ꞌdî ꞌbá yî drí kpá Yésũ rî îjízó kĩ, “Ãꞌdô ĩtí rî, ꞌdõvó ní ꞌê tã lârâkô ãzâ, ãꞌdô ró bê mbârâkã áníkâ âꞌdálé ãmâ drí. Gõꞌdá mã ꞌdê gbõ nı̣̃lâ kĩ, pạ̃tı̣́ı̣̃ Ôvârí âjô nî nĩ, gõꞌdá ãmâ drí gõzó tã lẽlẽ bê ní ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mí ndrê drẽ, ãmâ ạ́ꞌbı̣́yạ́ yî õtírĩ lậmú õmã ꞌálâ rî, Músạ̃ fẽ ngá nyãnyã trá gólĩyî drí. Íîgĩ trá búkũ Ôvârí kâ ꞌá kĩ, ‘Gólâ âfẽ ngá nyãnyã trá ûrú lésĩ gólĩyî drí nyãlé.’ Gólĩyî rî trá ngá nyãnyã ꞌdî nyãlé ı̣̃tú vósĩ cé ndrô drílĩyî rĩzó lậmúlı̣́ õmã ꞌálâ rî ꞌbá yî sĩ.” ");
INSERT INTO avu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Gõꞌdá nĩngá sĩ, Yésũ drí gõzó kpá tã-drı̣̃ lôgõlé gólĩyî drí kĩ, “Má âtâ tã pạ̃tı̣́ı̣̃ ãnî drí, ngá nyãnyã gólâ ódrí fẽlé ãnî ạ́ꞌbı̣́yạ́ yî drí nã rî, ámâ átá âfẽ nĩ, âꞌdó kô Músạ̃ ĩꞌdî. Ngá nyãnyã rî ꞌdĩ trá ngá nyãnyã rúꞌbạ́ ı̣̃nyạ́kú kâ ꞌî. Gõꞌdá ngá nyãnyã pạ̃tı̣́-pạ̃tı̣̃ tíbê ûrú lésĩ rî, ámâ átá lẽ trá fẽlâ ãnî drí ãndrõ nô. ");
INSERT INTO avu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Õjílã gólâ Ôvârí drí âjólé trá ûrú lésĩ rî, gólâ ĩꞌdî rĩ ꞌbá ngá nyãnyã gólâ rĩ ꞌbá lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽlé õjílã drí rî fẽlé rî.” ");
INSERT INTO avu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Gõꞌdá õjílã ꞌdî ꞌbá yî drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Tãndí ró kúmú, ãꞌdô ĩtí rî, ní âfẽ ngá nyãnyã rî gógó ꞌdĩ ãmâ drí kậyı̣̂ vósĩ cé!” ");
INSERT INTO avu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Gõꞌdá Yésũ drí gõzó tã âtálé gólĩyî drí kĩ, “Nĩ ârî drẽ, ámâ nyãányâ ĩꞌdî ngá nyãnyã lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽ ꞌbá ꞌî. Õjílã gólâ tíbê tã lẽ ꞌbá má ꞌá pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ, gõꞌdá kpá íyî nyãányâ fẽ ꞌbá ndrĩ má drí pạ̃tı̣́-pạ̃tı̣̃ rî, má âꞌdô gólâ rî ꞌbãꞌá lõfó drí îcázó gõꞌdá gólâ rî ꞌẽlé kô, gõꞌdá lı̣̃mvû lôvó fú gólâ kpá kô. Drílâ rĩzó lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó. ");
INSERT INTO avu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Gõꞌdá nĩ ndrê mbârâkã ámákâ bê kpálé trá rî, nĩ lẽé tã drẽ zãâ kô kĩ, Ôvârí âjô mâ nĩ. ");
INSERT INTO avu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Õjílã ndrĩ gólĩyî ámâ átá drí âfẽlé má drí rî âꞌdô tã lẽꞌá má ꞌá. Gõꞌdá má âꞌdô gólĩyî ndrĩ lậgúꞌá ãyĩkõ ãmbá sĩ âꞌdólé õjílã ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ôvârí âjô mâ trá ûrú lésĩ ãngó nõ ꞌá tã gólâkâ ꞌẽlé. Má ânĩí kô tã ámâ nyãányâ kâ ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","40","Tã ámâ átá Ôvârí drí lẽlé má drí ꞌẽlé rî ĩꞌdî nõô. Õjílã gólĩyî gólâ drí âfẽlé má drí rî, gõꞌdá tã lẽ ꞌbá mâ Ôvârí rî mvá ró rî ꞌá rî, gólâ lẽ má drí vó lâ ĩyî ndrẽlé dódó, õjílã ãzâ gólĩyî lãfálé ꞌásĩ ậvı̣̃ı̣́ kô. Ôvârí lẽ kpá má drí lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽlé gólĩyî drí. Gõꞌdá kậyı̣̂ ạ̃dũkũ ꞌá rî, má âꞌdô gólĩyî lîdríꞌá õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Gõꞌdá õjílã õꞌbí ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé kĩꞌá nĩ rî, yí ãâꞌdô ĩꞌdî ngá nyãnyã gólâ ûrú lésĩ rî ĩꞌdî rî, gólĩyî drí ngãzó rĩꞌá lôzólé ĩyî võ ꞌásĩ Yésũ rú. ");
INSERT INTO avu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Gõꞌdá drílĩyî tã âtázó kĩ, “Ãgô ꞌdĩ rî tã âtálé ĩtí tãlâ ãꞌdô ꞌî yã? Gólâ âꞌdó kô cé Yésũ Yõsépã rî mvá ró nõ ĩꞌdî, tíbê ãmâ drí átá lâ rî nı̣̃lı̣́ trá ândré lâ bê nõ yã? Gólâ kĩ, yí ânĩ ûrú lésĩ rî ángô tí ró yã?” ");
INSERT INTO avu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Gõꞌdá ĩtí rî, Yésũ drí ngãzó tã âtálé gólĩyî drí kĩ, “Nĩ âyê drẽ lôzô-lôzô ãníkâ má rú ãnî lãfálé ꞌásĩ ꞌdî. Nĩ ârî drẽ úlı̣́ ámákâ nõ. ");
INSERT INTO avu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tã pạ̃tı̣́ı̣̃ ró, má âtâ ãnî drí, õjílã ãzâ îcá kô tã lẽlé má ꞌá cú ĩtí ámâ átá Ôvârí gólâ ámâ âjó ꞌbá rî drí gólâ rî ậzı̣́ ãkó. Gõꞌdá má âꞌdô õjílã rî ꞌdĩ lîdríꞌá õdrã ꞌásĩ kậyı̣̂ ạ̃dũkũ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tã ậngũ ꞌbá yî îgĩ trá búkũ Ôvârí kâ ꞌá kĩ, ‘Ôvârí âꞌdô õjílã îmbáꞌá nĩ’. Pạ̃tı̣́ı̣̃ má âtâ ãnî drí, õjílã gólĩyî tã îmbâ-îmbâ Ôvârí kâ ârí ꞌbá dódó rî, gólĩyî âꞌdô ĩyî tã lẽꞌá má ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gõꞌdá õjílã ãzâ ãlô ãnî lãfálé sĩ ámâ átá rî ndrẽ ꞌbá rî yû. Mâ rî gógó nõ ndrê Ôvârí cé nĩ, tãlâ má ânĩ Ôvârí ngá lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Má âtâ ãnî drí tã pạ̃tı̣́-pạ̃tı̣̃ ró, õjílã tíbê tã lẽ ꞌbá má ꞌá pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ rî ûsû lédrẽ-lédrẽ ạ̃dũkũ ãkó rî trá. ");
INSERT INTO avu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mĩ ndrê drẽ, mâ ngá nyãnyã gólâ õjílã ꞌbã ꞌbá rĩlí zãâ gbạ́dú ạ̃dũkũ ãkó rî ĩꞌdî! ");
INSERT INTO avu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ꞌDõvó nĩ ı̣̂sũ tã ãnî ạ́ꞌbı̣́yạ́ yî tãsĩ. Gólĩyî ndrĩ nyâ ĩyî bê ngá nyãnyã Músạ̃ drí fẽlé gólĩyî drí rî bê rî, gólĩyî zãâ bê rĩꞌá lédrẽ-lédrẽ ró yã? Âꞌdó ĩtí kô, gólĩyî ôdrã trá ndrĩ! ");
INSERT INTO avu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gõꞌdá mâ ngá nyãnyã ânĩ ꞌbá ûrú lésĩ rî ĩꞌdî. Õjílã gólâ ngá nyãnyã ꞌdî nyã ꞌbá rî drãá kô. ");
INSERT INTO avu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Má âtâ ãnî drí kpá óꞌdí, ngá nyãnyã lédrẽ-lédrẽ ạ̃dũkũ ãkó fẽ ꞌbá ꞌdĩ rĩꞌá ámâ rúꞌbạ́ ꞌî. Má ânĩ trá ûrú lésĩ, gõꞌdá mâ rĩꞌá njãâ ámâ rúꞌbạ́ fẽlé drãlé ãnî õjílã ãngó nõ kâ pãlé tã õnjí ãníkâ ꞌásĩ. Õzõ nĩ õnyâ ámâ rúꞌbạ́ trá rî, ãnî drí rĩzó lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó.” ");
INSERT INTO avu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Gõꞌdá õjílã õꞌbí ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ kĩꞌá nĩ íyî rúꞌbạ́ âꞌdô ĩꞌdî ngá nyãnyã ânĩ ꞌbá ûrú lésĩ rî ĩꞌdî rî, gólĩyî drí ngãzó ạ̃wạ̃ ró, gõꞌdá rĩꞌá ĩyî úlı̣́ âtálé ĩyî lãfálé ꞌásĩ kĩ, “Ãgô nõ âꞌdô íyî rúꞌbạ́ âfẽꞌá ãmâ drí nyãlé ꞌdĩ íyíkâ ángô tí ró yã?” ");
INSERT INTO avu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Gõꞌdá Yésũ drí kpá tã-drı̣̃ jãzó gólĩyî drí kĩ, “Pạ̃tı̣́-pạ̃tı̣̃ ró, má âtâ ãnî drí, mâ gólâ Ôvârí drí âjólé trá ûrú lésĩ rî, õjílã gólâ ámâ rúꞌbạ́ nyã ꞌbá kô gõꞌdá ámâ ãrí mvũ ꞌbá kpá kô rî, ûsú lédrẽ-lédrẽ ạ̃dũkũ ãkó rî kô! ");
INSERT INTO avu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pạ̃tı̣́-pạ̃tı̣̃ má âtâ ãnî drí, õjílã gólâ ámâ rúꞌbạ́ nyã ꞌbá gõꞌdá kpá ámâ ãrí mvũ ꞌbá rî, âꞌdô rĩꞌá lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó. Má âꞌdô gólâ rî lîdríꞌá õdrã ꞌásĩ, kậyı̣̂ ạ̃dũkũ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mĩ ndrê drẽ, ámâ rúꞌbạ́ gõꞌdá ámâ ãrí bê rî ĩꞌdî cé ngá nyãnyã gólâ ꞌẽ ꞌbá õjílã ꞌbãlé rĩlí lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó rî. ");
INSERT INTO avu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Õjílã gólâ tíbê ámâ rúꞌbạ́ nyã ꞌbá gõꞌdá kpá ámâ ãrí mvũ ꞌbá rî, gólâ âꞌdô rĩꞌá má bê ngá ãlô ró, gõꞌdá má âꞌdô kpá rĩꞌá gólâ bê. ");
INSERT INTO avu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nĩ ârî drẽ, ámâ átá ĩꞌdî rĩ ꞌbá lédrẽ-lédrẽ âfẽlé rî. Gõꞌdá gólâ ꞌbã mâ kpá nĩ rĩlí lédrẽ-lédrẽ ró. Ĩtí rî, õjílã gólâ ámâ rúꞌbạ́ nyã ꞌbá rî âꞌdô rĩꞌá kpá lédrẽ-lédrẽ ró mbârâkã ámákâ sĩ zãâ gbạ́dú ạ̃dũkũ ãkó. ");
INSERT INTO avu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kpá ĩꞌdî õzõ má drí âtálé trá ãnî drí rî kâtí, mâ rĩꞌá ngá nyãnyã ûrú lésĩ rî ĩꞌdî. ꞌDĩî âꞌdó kô õzõ ngá nyãnyã gólâ ãnî ạ́ꞌbı̣́yạ́ yî drí nyãlé trá rî kâtí, gõꞌdá ꞌdĩî vósĩ rî, gólĩyî drã trá ndrĩ. Gõꞌdá gólĩyî tíbê ámâ rúꞌbạ́ nyã ꞌbá rî âꞌdô ĩyíkâ rĩꞌá lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó.” ");
INSERT INTO avu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Úlı̣́ ꞌdĩ ꞌbá yî Yésũ âtâ trá õjílã ꞌdî ꞌbá yî drí, drílâ rĩrĩ tã îmbálé Kãpẽrãnómã ꞌálâ jó tã Ôvârí kâ ârî kâ rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gõꞌdá tã ârí ꞌbá Yésũ kâ ũrûkậ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ ꞌdĩ ꞌbá yî ndrĩ rî, tı̣̂ lâ yî drí ậꞌdı̣́zó, gõꞌdá drílĩyî úlı̣́ Yésũ kâ ꞌdĩ gãzó dó. Gõꞌdá drílĩyî ngãzó rĩꞌá úlı̣́ âtálé ĩyî lãfálé ꞌásĩ kĩ, “ꞌÁá, úlı̣́ ꞌdĩ âmbâ trá rõô õjílã drí tã lẽzó ꞌá lâ!” ");
INSERT INTO avu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gõꞌdá Yésũ nı̣̃ trá cú ĩtí kĩ, tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yî lãfálé sĩ, ãzâ ꞌbá yî lẽé úlı̣́ yí drí âtálé ꞌdĩ ꞌbá yî kô. Gólâ drí gõzó tã îjílí gólĩyî tı̣́ kĩ, “Úlı̣́ má drí âtálé ꞌdĩ sú ãnî rú kô, ĩꞌdî ãnî drí ꞌẽzó ámâ âyélé gõzó vólé yã? ");
INSERT INTO avu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Õzõ nĩ õndrê mâ gõrẽ ꞌá vólé ûrú ꞌálâ, võ ámâ âjózó rî ꞌálâ sĩ rî ꞌálâ rî, tã ı̣̂sũ ãníkâ tã ꞌdî tãsĩ rî âꞌdô ꞌbãꞌá ángô tí yã? ");
INSERT INTO avu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Má âtâ ãnî drí, nĩ ı̣̂sũ úlı̣́ má drí âtálé ãnî drí ámâ rúꞌbạ́ nyã kâ ꞌdĩ ífí lâ dódó. Mbârâkã õjílã mvá kâ îcá lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽlé ãnî drí kô. Tã ꞌdî tãsĩ rî, úlı̣́ ámákâ ꞌdĩ ꞌbá yî âꞌdó kô rúꞌbạ́ ı̣̃nyạ́kú nõ tãsĩ. Úlı̣́ ꞌdĩ ꞌbá yî rĩꞌá Líndrí Tãndí Ôvârí kâ tãsĩ, gólâ ꞌẽ ꞌbá ãnî ꞌbãlé rĩlí lédrẽ-lédrẽ ró zãâ gbạ́dú ạ̃dũkũ ãkó tã lẽlẽ ãníkâ má ꞌá rî sĩ rî. ");
INSERT INTO avu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Gõꞌdá ngbãângbânõ rî, mâ rĩꞌá tã ı̣̂sũ ró, tãlâ ãnî ũrûkậ ꞌbá yî lẽé drẽ zãâ tã kô má ꞌá.” Yésũ âtâ tã ꞌdî ĩtí ꞌdĩ rî, tãlâ gólâ nı̣̃ tã ı̣̂sũ tã ârí ꞌbá íyíkâ ꞌdĩ ꞌbá yí kâ trá ndrĩ ãkpãkãꞌdã kậyı̣̂ gólĩyî drí ꞌdẽzó yí vósĩ rî ꞌá. Gólâ nı̣̃ gólĩyî tã íyíkâ lẽ ꞌbá kô rî yî trá ndrĩ. Gõꞌdá gólâ nı̣̃ lãjóꞌbá gólâ ángô rî ĩꞌdî tíbê ꞌẽ ꞌbá íyî drı̣́-bã fẽlé fũlı̣́ rî kpá trá. ");
INSERT INTO avu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tãlâ gólâ âtâ trá sı̣́sı̣́ lãjóꞌbá íyíkâ rî yî drí kĩ, õjílã ãzãkã îcá kô ânĩlí yí ngálâ cú ĩtí tã ı̣̂sũ gólâkâ sĩ. Ôvârí âꞌdô gólâ rî pı̣̃pı̣̂sı̣́lı̣́ âjáꞌá nĩ ĩꞌdî ꞌdê gbõ tã lẽlé yí ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Gõꞌdá úlı̣́ Yésũ kâ ꞌdĩ ꞌbá yî vósĩ rî, tã ârí ꞌbá gólâkâ ãzâ ꞌbá yî dũû drí ngãzó ĩyî gólâ rî âyélé, nĩzó gõlé ĩyî drí ꞌbã ꞌásĩ. Gólĩyî drí tã îmbâ-îmbâ Yésũ kâ âyézó. ");
INSERT INTO avu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Gõꞌdá Yésũ drí lı̣̃fı̣́ jãzó lãjóꞌbá íyíkâ mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ tíbê gólâ drí êpẽlé nĩ sı̣́sı̣́ rî yî ngálâ, gõꞌdá drílâ tã îjízó gólĩyî tı̣́ kĩ, “Ãnî, nĩ lẽ kpá trá ámâ âyélé nĩzó, õzõ gólĩyî nĩ ꞌbá ꞌdĩ ꞌbá yí kâtí yã?” ");
INSERT INTO avu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Gõꞌdá Sĩmónã Pétẽrõ drí tã-drı̣̃ jãzó Yésũ drí kĩ, “Kúmú, mã âꞌdô ãmákâ nĩꞌá nõ ꞌbô ángô lé ró yã? Mã nı̣̃ trá, mã lẽ tã kpá trá kĩ, nî rĩꞌá õjílã ndı̣̂ndı̣̂ ꞌî pạ̃tı̣́ı̣̃ Ôvârí kâ rî ĩꞌdî, úlı̣́ áníkâ âtálé rî âꞌdô ãmâ ꞌbãꞌá nĩ rĩlí zãâ gbạ́dú ạ̃dũkũ ãkó, õjílã ãzãkã yûꞌdạ́wạ́ ãmâ drí ꞌdẽzó vó lâ ꞌásĩ õzõ ání kâtí.” ");
INSERT INTO avu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Gõꞌdá Yésũ drí tã âtázó lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩ, “Má zĩ ãnî nĩ mûdrı̣́-drı̣̃-lâ-gâ-rı̣̃ lãjóꞌbá ámákâ ró, gõꞌdá kpálé rî, ãnî lãfálé sĩ rî, ámâ ạ̃jú-ꞌbá-ãzí bê ãlô tíbê ꞌẽ ꞌbá ámâ drı̣́-bã fẽlé fũlı̣́ rî.” ");
INSERT INTO avu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yésũ âtâ tã ꞌdî ĩtí ꞌdĩ rî Yúdạ̃ Sĩmónã Ĩsĩkãrĩyótã rî mvá rî tãsĩ. Gõꞌdá kpálé Yúdạ̃ rĩꞌá lãjóꞌbá ãlô lãjóꞌbá Yésũ kâ mûdrı̣́-drı̣̃-lâ-ngâ-rı̣̃ rî lãfálé sĩ rî, Yésũ nı̣̃ trá kĩ, ạ̃tı̣́ ꞌá tólâ gólâ ãâꞌdô íyî drı̣́-bã fẽꞌá nĩ fũlı̣́. ");
INSERT INTO avu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gõꞌdá Yésũ drẽ rĩꞌá Gãlĩláyã ꞌálâ rî, drílâ nĩzó lậmú bê õjílã lı̣̃fı̣́ îmbá bê jạ̃rı̣́bạ̃ Gãlĩláyã kâ ꞌásĩ. Gólâ lẽé kô cãlé Yũdạ́yạ̃ ꞌálâ õjílã lı̣̃fı̣́ îmbálé, tãlâ drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ Yẽrõsãlémã ꞌálâ rî lẽ trá gólâ rî fũlı̣́. ");
INSERT INTO avu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Gõꞌdá kậyı̣̂ gólĩyî kãrámã Yúdạ̃ yí kâ zı̣̃lı̣́ kãrámã gũgũ kâ rî kâ trá ãnyî. ");
INSERT INTO avu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Gõꞌdá kậyı̣̂ gólĩyî kãrámã ꞌdî kâ câ bê rî, Yésũ rî ậdrúpı̣̃ yî drí ngãzó Yésũ rî îcílí tã lârâkô gólâ drí rĩꞌá ꞌẽlâ rî ꞌbá yî tãsĩ, gõꞌdá drílĩyî tã âtázó drílâ kĩ, “Hé, tí gõꞌdá ní nĩí Yẽrõsãlémã ꞌálâ õjílã lı̣̃fı̣́ îmbálé kậyı̣̂ gólĩyî ãmbá kãrámã nô kâ ꞌá mbârâkã áníkâ âꞌdálé tólâ õꞌbí ꞌá, tãlâ õjílã dũû õꞌdê ró bê ní vósĩ rî kô yã? ");
INSERT INTO avu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ní lẽ áníkâ tã lârâkô ꞌẽlé nõ cé nõngá kírî ũgũ ró ãꞌdô tãsĩ yã? Õzõ ní õlẽ õjílã dũû drí ꞌdẽlé ní vósĩ rî, ní nĩ tã lârâkô ꞌẽlé õꞌbí ꞌá Yẽrõsãlémã ꞌá tólâ, õꞌbí nã ꞌbá yî õndrê ró mbârâkã áníkâ bê.” ");
INSERT INTO avu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gõꞌdá ꞌdĩî zãâ Yésũ rî ậdrúpı̣̃ yî lẽé ĩyî drẽ tã kô Yésũ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Gõꞌdá Yésũ drí tã lôgõzó íyî ậdrúpı̣̃ yî drí kĩ, “Ị̃tú ámákâ nĩzó Yẽrõsãlémã ꞌálâ rî cá drẽ kô. Ãnî drí rî, kậyı̣̂ íyíkâ ndrĩ rĩꞌá tãndí ró ãnî drí nĩzó Yẽrõsãlémã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ãníkâ rî, õjílã ãngó nõ kâ ꞌbã ĩyíkâ ãnî lôvó ꞌbãꞌbã, gõꞌdá gólĩyî ꞌbãá ĩyíkâ ámâ lôvó kô, tãlâ má rî bê kárá tã õnjí gólĩyíkâ rĩꞌá ꞌẽlâ rî tã lâ âꞌdálé gólĩyî drí rî sĩ. ");
INSERT INTO avu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ãnî rî gógó, nĩ lậvũ sı̣́sı̣́ kãrámã ꞌá tólâ. Má îcá nĩlí tólâ ngbãângbânõ kô, tãlâ ı̣̃tú ámákâ nĩ kâ cá drẽ kô.” ");
INSERT INTO avu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ĩtí rî, úlı̣́ Yésũ kâ ꞌdĩ vósĩ rî, ậdrúpı̣̃ lâ yî drí ngãzó nĩlí Yẽrõsãlémã ꞌálâ. Gõꞌdá Yésũ drí rĩzó Gãlĩláyã ꞌá nĩngá. ");
INSERT INTO avu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gõꞌdá Yésũ rî ậdrúpı̣̃ yî lậvũ bê Yẽrõsãlémã ꞌálâ rî, kậyı̣̂ ãzâ sĩ, Yésũ drí ngãzó kpá nĩlí Yẽrõsãlémã ꞌá tólâ kírî ũgũ ró. ");
INSERT INTO avu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Gõꞌdá kậyı̣̂ kãrámã gũgũ kâ ꞌdĩ kâ rî ꞌbá yî sĩ rî, Yẽrõsãlémã ꞌá tólâ rî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî drí rĩzó Yésũ rî lôndãlé õꞌbí lãfálé ꞌásĩ. Drílĩyî nĩzó tã îjí bê õjílã tı̣́ sĩ kĩ, “Ãgô rú bê Yésũ rî, rî rĩlí ángô lé ró yã? Nĩ ndré gólâ kô yã?” ");
INSERT INTO avu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gõꞌdá õjílã ꞌdî ꞌbá yî drí rĩzó tã âtálé ĩyî lãfálé ꞌásĩ ãyãyã sĩ. Ãzâ ꞌbá yî kĩ, “Ãgô rú bê Yésũ ꞌdĩ ãgô tãndí ꞌî.” Gõꞌdá ãzâ ꞌbá yî kĩ ĩyíkâ, “ꞌÉꞌẽ, ãgô ꞌdĩ rî õjílã âdólé õnjõ sĩ.” ");
INSERT INTO avu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gõꞌdá õjílã ãzãkã yûꞌdạ́wạ́ úlı̣́ âtálé Yésũ rî tãsĩ drı̣̃-bạ́lạ́yı̣̂ ró ngbạ́lạ́-ngbạ́lạ́, tãlâ õjílã ndrĩ ꞌdó ũrı̣̃ ró, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ õzó ngãâ kô ạ̃wạ̃ ró ĩyí bê. ");
INSERT INTO avu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gõꞌdá õjílã ꞌê ĩyî kãrámã ꞌdî bê cãlé kậyı̣̂ nâ sĩ rî, Yésũ drí nĩzó fĩlí jó ạ́ngı̣́ Ôvârí kâ rî ꞌálâ, drílâ îtõzó rĩꞌá õꞌbí rĩ ꞌbá tólâ nã ꞌbá yî îmbálé. ");
INSERT INTO avu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ârî ĩyî bê tã îmbâ Yésũ kâ ꞌdĩ rî, tı̣̂ lâ yî drí ậꞌdı̣́zó. Drílĩyî ngãzó tã âtálé gólâ rî tãsĩ kĩ, “Gólâ ûsû íyíkâ tã nı̣̃nı̣̃ tã îmbâ kâ nõ ãꞌdô ꞌásĩ yã? Gólâ rĩꞌá cú ĩtí tã îmbá ꞌbá ãkó.” ");
INSERT INTO avu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Gõꞌdá Yésũ ârî tã gólĩyíkâ rĩꞌá âtálâ ꞌdĩ bê rî, gólâ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Tã gólâ má drí rĩꞌá îmbálâ nõ âꞌdó tã îmbâ-îmbâ ámâ nyãányâ kâ ĩꞌdî kô, má rî tã îmbâ Ôvârí gólâ ámâ âjó ꞌbá rî kâ îmbálé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Õjílã gólĩyî tã Ôvârí kâ ꞌẽ ꞌbá rî ꞌbá yî âꞌdô ĩyî nı̣̃ꞌá lâ pạ̃tı̣́ı̣̃ kĩ, ngãtá tã má drí rĩꞌá îmbálâ nõ ámâ nyãányâ kâ ngã tã îmbâ Ôvârí kâ ĩꞌdî yã rî. ");
INSERT INTO avu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Õzõ má õrî nõ tã ámâ nyãányâ kâ îmbálé ĩꞌdî rî, nĩ âꞌdô nı̣̃ꞌá lâ kĩ, má lẽ cé õjílã drí lậnjı̣̃ ꞌbãlé má rú ĩꞌdî. Gõꞌdá âꞌdó kô ĩtí. Má ânĩ tã Ôvârí gólâ ámâ âjó ꞌbá rî kâ îmbálé ĩꞌdî, tãlâ óꞌbã ró bê lậnjı̣̃ gólâ rú. Tã îmbâ ámákâ ꞌdĩ âꞌdó kô õnjõ ꞌî, rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gõꞌdá ãnî, nĩ rî ámâ lôndãlé fũlı̣́ tãkó ãꞌdô tãsĩ yã? Nĩ rî tã âꞌbãlé kĩ, yĩ ârî tã ꞌbãꞌbã Ôvârí kâ Músạ̃ drí âꞌdálé ãnî drí rî trá. Tákõ, ãnî rĩꞌá njãâ ámâ fũlı̣́. Nĩ ârí tã ꞌbãꞌbã Músạ̃ kâ ꞌdĩ kó kô.” ");
INSERT INTO avu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Gõꞌdá õjílã ãmbá gólĩyî lãfálé ꞌásĩ rî yî drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ãꞌdî ꞌê tí ánî fũlı̣́ nĩ yã? Ní lîfõ-lîfõ! Õjílã ãzâ yûꞌdạ́wạ́ ꞌẽ ꞌbá ánî fũlı̣́!” ");
INSERT INTO avu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Gõꞌdá Yésũ drí ngãzó tã âtálé gólĩyî drí kĩ, “Má îngâ õjílã ngá lãzé ꞌásĩ ândâlâ ãlô kậyı̣̂ ãmákâ rãtáã ꞌẽ kâ sĩ, gõꞌdá nĩ kĩ, má õꞌê ꞌdĩ tã õnjí ꞌî tã lâ drí lâzézó ãnî rú ĩꞌdî ãnî drí ngãzó má bê ạ̃wạ̃ ró tã lârâkô má drí ꞌẽlé ꞌdĩ ꞌá yã? ");
INSERT INTO avu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Gõꞌdá tã ꞌdẽꞌdẽ kâ bãsã ꞌá rî, nĩ rî ꞌẽlâ kậyı̣̂ lôvô-lôvô kâ sĩ. Músạ̃ ꞌbã tã Yúdạ̃ yî drí mvá lâ yî ꞌbẽlé bãsã ꞌá. ꞌDẽꞌdẽ bãsã ꞌá rî âꞌdó kô cé tã Músạ̃ drí ꞌbãlé ꞌdĩ ĩꞌdî. ꞌDẽꞌdẽ bãsã ꞌá rî îtõ trá ãmâ ạ́ꞌbı̣́yạ́ Ãbãrãyámã drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Õzõ kậyı̣̂ ꞌdĩyímvá kâ ꞌdẽ kâ bãsã ꞌá rî õꞌdê trá kậyı̣̂ lôvô-lôvô kâ ꞌá rî, nĩ ꞌbãá ꞌdĩyímvá ꞌdẽlé bãsã ꞌá kô yã? Nĩ rî ꞌẽlâ! Gõꞌdá má îngâ bê õjílã ngá lãzé ꞌásĩ kậyı̣̂ lôvô-lôvô kâ ꞌá rî, tã lâ sú ãnî drí kô tãlâ ãꞌdô ꞌî yã? Nĩ ı̣̂sũ ãníkâ bê rî, tã ꞌdẽꞌdẽ kâ bãsã ꞌá Músạ̃ drí ꞌbãlé rî tã lâ lậvũ gạ̃rạ̃ tã ꞌbãꞌbã kậyı̣̂ lôvô-lôvô kâ kâ drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nĩ âyê tã gólâ ãnî drí rĩzó lãꞌbí ãníkâ tã lâ trõlé ĩꞌdî ꞌbãlé gạ̃rạ̃ ꞌdî. Nĩ ꞌê tã ꞌẽꞌẽ gólâ tãndí ró mbı̣̂mbı̣̂ rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Gõꞌdá nĩngá sĩ, Yésũ âtâ bê úlı̣́ ꞌdĩ ꞌbá yî ĩtí rî, õjílã ãzâ ꞌbá yî rĩ ꞌbá rĩlí ĩyî jạ̃rı̣́bạ̃ Yẽrõsãlémã kâ ꞌá rî drí ngãzó ĩyî tã âtálé ĩyî võ ꞌásĩ kĩ, “ꞌDĩî âꞌdó kô ãgô gólâ drı̣̃-ꞌbá ãmákâ rî yî drí ꞌẽꞌá fũlâ rî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Gõꞌdá õjílã ãzâ ꞌbá yî ãkpã gólĩyî lãfálé ꞌásĩ drí tã-drı̣̃ lôgõzó kĩ, “Drı̣̃-ꞌbá ãmákâ ꞌdĩ ꞌbá yî âyê ĩyî gólâ rĩꞌá tã îmbálé õjílã drí drı̣̃-bạ́lạ́yı̣̂ ró tãlâ ãꞌdô ꞌî yã? Drı̣̃-ꞌbá ãmákâ ꞌdĩ ꞌbá yî êdrẽé ĩyî gólâ tã îmbâ ꞌdĩ ꞌásĩ kô, tãlâ gólĩyî ı̣̂sũ tã bê rî kĩ, ãgô ꞌdĩ ãâꞌdô ꞌdíyî pã ꞌbá ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Gõꞌdá õjílã ãzâ ꞌbá yî drí kpá tã-drı̣̃ lôgõzó kĩ, “Ãgô nõ âꞌdô ꞌbãꞌá ꞌdíyî pã ꞌbá ró ꞌdĩ ángô tí yã? Mã nı̣̃ jạ̃rı̣́bạ̃ gólâ drí rĩzó ꞌá lâ rî trá! Gólâ Nãzãrétã lé ꞌbá ꞌî! Gõꞌdá õjílã îcá kô võ ꞌdíyî pã ꞌbá drí ꞌẽzó ânĩlí âfõlé ꞌálâ sĩ rî nı̣̃lı̣́.” ");
INSERT INTO avu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Gõꞌdá Yésũ bê drẽ zãâ tã îmbáꞌá jó ạ́ngı̣́ Ôvârí kâ rî ꞌálâ rî gõꞌdá ârî úlı̣́ õjílã ꞌdî ꞌbá yí kâ âtálé ꞌdĩ bê rî, drílâ tã âtázó drílĩyî ngbạ́lạ́-ngbạ́lạ́ kĩ, “Nĩ ı̣̂sũ ãníkâ bê rî, nĩ ũnı̣̃ mâ trá. Nĩ ũnı̣̃ jạ̃rı̣́bạ̃ má drí ânĩzó ꞌálâ ꞌásĩ rî trá. Gõꞌdá nĩ nı̣̃ı̣́ kô kĩ, ãꞌdî âjô mâ nĩ ãngó nõ ꞌá yã rî. Ámâ átá Ôvârí âjô mâ nĩ. Má ânĩí kô drı̣́-ãcê ámákâ sĩ. Má ânĩ trá drı̣́-ãcê ámâ átá gólâ ámâ âjó ꞌbá rî kâ sĩ. Gólâ Ôvârí pạ̃tı̣́-pạ̃tı̣̃ rî ĩꞌdî. Gõꞌdá nĩ nı̣̃ı̣́ gólâ kô. ");
INSERT INTO avu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Gõꞌdá má nı̣̃ gólâ trá, tãlâ má ânĩ gólâ ngá lésĩ, gólâ âjô mâ nĩ.” ");
INSERT INTO avu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, drílĩyî ngãzó ꞌẽꞌá gólâ rî rũlı̣́ rî, gõꞌdá gólĩyî îcá kô gólâ rî rũlı̣́, tãlâ kậyı̣̂ Ôvârí drí ꞌbãlé gólâ rî rũzó ꞌá lâ rî âcá drẽ kô. ");
INSERT INTO avu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gõꞌdá õjílã dũû õꞌbí ꞌdĩ ꞌbá yî lãfálé sĩ lẽ ĩyî tã trá Yésũ ꞌá, drílĩyî ngãzó gõꞌdá tã âtálé kĩ, “Ãgô gólâ Yésũ nõ ꞌdíyî pã ꞌbá ꞌî pạ̃tı̣́ı̣̃. Îcá kô õjílã ãzâ drí âꞌdólé ꞌdíyî pã ꞌbá ró tã lârâkô ꞌẽlé lậvũlı̣́ gạ̃rạ̃ tã lârâkô Yésũ drí ꞌẽlé ꞌdĩ ꞌbá yî drı̣̃ı̣̂ sĩ.” ꞌDĩî âꞌdâ trá kĩ, Yésũ ĩꞌdî ꞌdíyî pã ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Gõꞌdá Pạ̃rúsı̣̃ yî ârî ĩyî bê tã õjílã dũû ꞌdĩ ꞌbá yî drí rĩꞌá âtálâ tã lârâkô ãmbá Yésũ kâ ꞌẽlé rî tãsĩ rî, gólĩyî drí ꞌbãzó ạ̃wạ̃ ró. Drílĩyî ngãzó nĩlí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ngálâ tã ı̣̂ꞌbı̣̃lı̣́ Yésũ rú. Gõꞌdá drílĩyî ạ̃jú ꞌbũ ꞌbá ĩyíkâ jõzó nĩlí Yésũ rî ậrúlı̣́. ");
INSERT INTO avu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gõꞌdá ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî nĩ ĩyî bê cãlé Yésũ ngálâ rî, Yésũ drí rĩzó zãâ tã îmbálé kĩ, “Má âꞌdô ꞌbãꞌá drẽ zãâ bê ãní bê nõngá kậyı̣̂ fínyáwá sĩ. ꞌDĩî vósĩ rî, má âꞌdô gõꞌá ámâ átá gólâ ámâ âjó ꞌbá rî ngálâ. ");
INSERT INTO avu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Õzõ nĩ õrî ámâ lôndãlé sı̣́sı̣́ ꞌálâ rî, nĩ îcá kô ámâ ûsúlı̣́, tãlâ võ gólâ má drí ꞌẽzó nĩlí ꞌálâ rî, nĩ îcá kô nĩlí cãlé tólâ.” ");
INSERT INTO avu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Gõꞌdá õjílã Yúdạ̃ yí kâ ũrûkậ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, drílĩyî ngãzó rĩꞌá ĩyî úlı̣́ âtálé ĩyî lãfálé ꞌásĩ kĩ, “Ãgô nõ rî íyíkâ kó úlı̣́ âtálé nõtí nõ ángô tí yã? Gólâ ꞌê íyíkâ nĩlí nõngá sĩ nô ꞌbô ángô lé yã ãmâ drí ꞌẽzó gólâ rî lôndãlé kpı̣̃ı̣̂, gõꞌdá gólâ rî ûsúzó kô rî? Gólâ ꞌê nĩlí ꞌbạ̃drı̣̃ Gı̣̃rı̣́kı̣̃ kâ ꞌálâ võ gólâ õjílã ãmákâ drí rĩzó rî ꞌálâ, õjílã Gı̣̃rı̣́kı̣̃ kâ îmbálé tólâ yã? ");
INSERT INTO avu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Úlı̣́ Yésũ kâ âtálé kĩꞌá nĩ rî, õzõ mã õrî íyî lôndãlé rî, mã îcá kô íyî ûsúlı̣́, tãlâ võ yí drí ꞌẽzó nĩlí ꞌálâ rî, mã îcá kpá kô cãlé ꞌá lâ ꞌdĩ tã ífí lâ ãꞌdô ꞌî yã?” ");
INSERT INTO avu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gõꞌdá kậyı̣̂ ạ̃dũkũ kãrámã gũgũ kâ ꞌdĩ kâ sĩ rî, Yésũ drí âfõzó âdrélé kpá óꞌdí jó ạ́ngı̣́ Ôvârí kâ ꞌá. Drílâ ngãzó rĩꞌá õꞌbí ꞌdĩ ꞌbá yî lı̣̃fı̣́ lâ yî îmbálé rê-rê ûrû kĩ, “Nĩ ârî drẽ tã nô, ãnî ndrĩ, õzõ õjílã ãzâ ãꞌdô lı̣̃mvû lôvó bê rî, õjílã rî ꞌdĩ ãânĩ má ngálâ rî, má âꞌdô lı̣̃mvû lânjã fẽꞌá õjílã rî ꞌdĩ drí. ");
INSERT INTO avu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Õjílã gólĩyî tã lẽ ꞌbá trá má ꞌá pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ rî, õzõ gólĩyî ũmvû lı̣̃mvû má drí fẽlé gólĩyî drí rî trá rî, lı̣̃mvû ꞌdĩ âꞌdô rĩꞌá ậdı̣́lı̣́ gólĩyî pı̣̃pı̣̂sı̣́lı̣́ ꞌásĩ õzõ óró kâtí. Lı̣̃mvû rî ꞌdĩ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽꞌá gólĩyî drí, õzõ Ôvârí drí âtálé trá rî kâtí.” ");
INSERT INTO avu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Úlı̣́ gólâ Yésũ drí âtálé lı̣̃mvû kâ ꞌdĩ, gólâ rî ꞌdĩ Líndrí Tãndí Ôvârí kâ rî tã lâ âtálé ĩꞌdî. Õjílã gólĩyî tíbê tã lẽ ꞌbá trá yí ꞌá rî, yí âꞌdô Líndrí Tãndí Ôvârí kâ âjóꞌá gólĩyî drí. Yésũ õtírĩ rĩî úlı̣́ ꞌdĩ ꞌbá yî âtálé rî, gólâ drãá drẽ kô âfõlé óꞌdí õdrã ꞌásĩ gõlé ûrú ꞌálâ Líndrí Tãndí rî ꞌdĩ âjólé. ");
INSERT INTO avu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gõꞌdá õꞌbí ꞌdĩ ꞌbá yî ârî úlı̣́ Yésũ drí âtálé ꞌdĩ bê trá rî, ũrûkậ ꞌbá yî drí ngãzó ĩyî rĩꞌá tã âtálé kĩ, “Ãꞌdô ĩtí rî, ãgô nõ pạ̃tı̣́ı̣̃ tã ậngũ ꞌbá Ôvârí drí kĩꞌá nĩ rî, yí âꞌdô âjóꞌá lâ ãmâ drí rî ĩꞌdî!” ");
INSERT INTO avu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gõꞌdá ãzâ ꞌbá yî kĩ ĩyíkâ, “Pạ̃tı̣́ı̣̃ ró, ꞌdĩî ꞌdíyî pã ꞌbá ꞌî.” Gõꞌdá õjílã ãzâ ꞌbá yî lẽé ĩyíkâ tã ꞌdî kô. Gólĩyî kĩ ĩyíkâ rî, “Ãgô nõ âꞌdó kô ꞌdíyî pã ꞌbá ꞌî, tãlâ ãgô nõ rĩꞌá Gãlĩláyã lé ꞌbá ꞌî. Gõꞌdá ꞌdíyî pã ꞌbá îcá kô ânĩlí Gãlĩláyã lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mã nı̣̃ trá ndrĩ búkũ Ôvârí kâ kĩ nĩ rî, ‘ꞌDíyî pã ꞌbá ꞌdĩ âꞌdô âꞌdóꞌá Dạ̃wúdı̣̃ rî ózõwá yî ꞌásĩ, gõꞌdá áâꞌdô tı̣̃ꞌá lâ Bẽtẽlémẽ ꞌálâ, jạ̃rı̣́bạ̃ Dạ̃wúdı̣̃ kâ rî ꞌá.’ ” ");
INSERT INTO avu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tã ı̣̂sũ õꞌbí ꞌdĩ ꞌbá yí kâ âꞌdó kô ãlô ĩyî lãfálé ꞌásĩ. Ũrûkậ ꞌbá yî lẽ ĩyî tã trá Yésũ ꞌá. Gõꞌdá ãzâ ꞌbá yî gâ ĩyî vólé dó tã lẽlé Yésũ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî gõꞌdá ạ̃jú ꞌbũ ꞌbá ĩyíkâ rî ꞌbá yí bê lẽ ĩyî bê kpálé Yésũ rî rũlı̣́ rî, õjílã ãzâ ãlô gólĩyî lãfálé ꞌásĩ drı̣́ dõ ꞌbá Yésũ rú rî yû, tãlâ gólĩyî ndrĩ ꞌdó ũrı̣̃ ró. ");
INSERT INTO avu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gõꞌdá ạ̃jú ꞌbũ ꞌbá gólĩyî jõlé Yésũ vó rî drí âgõzó ĩyî cú ĩtí Yésũ rî rũ ãkó drı̣́-drı̣́ı̣̃ ró drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ gõꞌdá Pạ̃rúsı̣̃ yí bê ꞌdĩ ꞌbá yî ngálâ. Gõꞌdá drı̣̃-ꞌbá ꞌdĩ ꞌbá yî drí ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî îjízó kĩ, “Nĩ âgõ cú ĩtí Yésũ rî ậrú ãkó ãꞌdô tãsĩ yã? Ãꞌdô tã âꞌdô nĩ ãnî drí âgõzó ãmâ ngálâ drı̣́-drı̣́ı̣̃ ró nõ yã?” ");
INSERT INTO avu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Gõꞌdá ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó drı̣̃-ꞌbá ꞌdĩ ꞌbá yî drí kĩ “Úlı̣́ Yésũ drí âtálé rî ꞌbã ãmâ ndrĩ âꞌdólé ũrı̣̃ ró tã õnjí ꞌẽlé gólâ drí, tãlâ gólâ rî úlı̣́ âtálé mbârâkã sĩ. Mã ûsú drẽ õjílã ãzâ kô úlı̣́ âtá ꞌbá õzõ Yésũ kâtí.” ");
INSERT INTO avu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Gõꞌdá drı̣̃-ꞌbá ꞌdĩ ꞌbá yî Pạ̃rúsı̣̃ yí bê drí ạ̃jú ꞌbũ ꞌbá ꞌdĩ ꞌbá yî îjízó kpá óꞌdí ạ̃wạ̃ sĩ kĩ, “Ãgô ꞌdĩ âdô ãnî kpá trá úlı̣́ gólâkâ sĩ õzõ drílâ õjílã ãzâ ꞌbá yî âdórẽ tí yã? ");
INSERT INTO avu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nĩ ûsû drı̣̃-ꞌbá ạ́ngı̣́ ãmákâ Yúdạ̃ yí kâ ãzâ ꞌbá yî tã lẽ ꞌbá ãgô ꞌdĩ ꞌá rî trá yã? ");
INSERT INTO avu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ꞌDĩî õjílã gólĩyî tã lẽ ꞌbá Yésũ ꞌá rî ꞌbá yî gólĩyî lãꞌbí ãmákâ nı̣̃ ꞌbá kô rî ĩꞌdî. Lâŋõ ạ́ngı̣́ õꞌdê gólĩyî drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Gõꞌdá Pạ̃rúsı̣̃ ãzâ ãlô gólĩyî lãfálé ꞌásĩ rú bê Nĩkõdímã rî, gólâ tíbê nĩ ꞌbá trá sı̣́sı̣́ ngạ́cı̣̂ bê tã îjílí Yésũ tı̣́ rî, drí tã âtázó íyî ãzí-ãzí yî drí kĩ, ");
INSERT INTO avu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Îcâ fí trá lâŋõ fẽzó õjílã ãzâ drí cú ĩtí tã gólâkâ kĩ ãkó yã? Îcá kô! Tã ꞌbãꞌbã ãmákâ vó ró, sı̣́sı̣́ áâꞌdô tã gólâkâ âríꞌá zãlô.” ");
INSERT INTO avu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Gõꞌdá Nĩkõdímã rî ãzí-ãzí yî drí tã-drı̣̃ lôgõzó gólâ drí ạ̃wạ̃ sĩ kĩ, “Ndá nî, ní rî úlı̣́ âtálé ĩtí rî, nî kpá Gãlĩláyã lé ꞌbá ꞌî yã? ꞌDõvó ní âtâ bê trá ĩtí rî, ní nĩ drẽ ndãlâ búkũ Ôvârí kâ ꞌá, ngãtá ní âꞌdô tã ûsúꞌá kĩ, tã ậngũ ꞌbá ãâꞌdô âfõꞌá Gãlĩláyã lésĩ yã rî!” ");
INSERT INTO avu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ndã ĩyî lạ́tı̣̂ bê trá kpı̣̃ı̣̂ ꞌẽzó Yésũ rî rũlı̣́ rî, gbõ drílĩyî ngãzó lậꞌbúlı̣́ nĩlí gõlé ĩyî drí ꞌbã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Gõꞌdá Yésũ ndẽ bê tã îmbâ-îmbâ gólâ drí rĩꞌá îmbálâ jó ạ́ngı̣́ Ôvârí kâ nã ꞌálâ rî, gólâ drí ngãzó nĩlí únı̣́ fê dõ kâ bê yí drı̣̃ı̣̂ nã ꞌálâ ậꞌdú kõlé tólâ. ");
INSERT INTO avu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gõꞌdá võ âfõ bê ậwúlı̣́ ãkpãkãꞌdã cı̣̃ı̣́nó rî, Yésũ drí ngãzó kpá óꞌdí gõlé jó ạ́ngı̣́ Ôvârí kâ nã ꞌálâ. Õjílã õtírĩ ĩyî Yésũ rî ndrẽê rî, ꞌwãâ drílĩyî rû êꞌbézó kpá óꞌdí dũû dîrî gólâ rú sĩ tã gólâkâ ârílí. Gõꞌdá Yésũ ndrê bê õjílã ꞌdî ꞌbá yî dũû ĩtí rî, gólâ drí rĩzó vũdrı̣́ õjílã rû êꞌbé ꞌbá ꞌdĩ ꞌbá yî îmbálé. ");
INSERT INTO avu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Gõꞌdá Yésũ õtírĩ rĩî õjílã õꞌbí ꞌdĩ ꞌbá yî îmbálé rî, kôrô Pạ̃rúsı̣̃ yî gõꞌdá kpá gólĩyî lãꞌbí îmbá ꞌbá yí bê drí õkó ãzâ drílĩyî rũlı̣́ ãgô ãzâ bê ậyı̣́rı̣̃ ꞌá rî âtrõzó ꞌbãlé âdrélé Yésũ ândrá õꞌbí ꞌdĩ ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Gõꞌdá drílĩyî tã âtázó Yésũ drí kĩ, “Nî tíbê tã îmbá ꞌbá ró nõ, mã lẽ ánî îjílí tã nô tãsĩ. Ní ndrê drẽ õkó nõ, mã rû gólâ trá ậyı̣́rı̣̃ ꞌá ĩyî ãgô ãzâ tíbê âꞌdó ꞌbá kô gólâ rî ágó ró rî bê. ");
INSERT INTO avu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tã ꞌbãꞌbã ãmákâ Músạ̃ drí ꞌbãlé rî vó ró rî, îcâ trá õkó ꞌdĩ lûvũlı̣́ kúnı̣́ mvá sĩ drãlé vólé.” Gõꞌdá drílĩyî Yésũ rî îjízó kĩ, “Gõꞌdá ngbãângbânõ rî, tã ı̣̂sũ áníkâ rî ángô tí tã õkó nõ drí ꞌẽlé rî tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tã îjî õjílã ꞌdî ꞌbá yí kâ ꞌdĩ ꞌá rî, gólĩyî rî ꞌdĩ Yésũ rî ûjũꞌá. Õzõ gólâ ãâtâ úlı̣́ trá ányâ ró tã ꞌbãꞌbã ĩyíkâ rú rî, yĩ âꞌbã ró bê tã gólâ rú, tãlâ tã gólâkâ kĩzó bê tã rî ꞌdĩ tãsĩ. Gõꞌdá Yésũ lôgõó tã-drı̣̃ gólĩyíkâ ꞌdĩ kô. Ĩtí rî, gólâ drí ậndı̣̃zó vũdrı̣́ rĩꞌá tã îgĩlí ı̣̃nyạ́kú drı̣̃ı̣̂ íyî drı̣́-mvá sĩ. ");
INSERT INTO avu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gõꞌdá Pạ̃rúsı̣̃ yî lãꞌbí îmbá ꞌbá ꞌdĩ ꞌbá yí bê, drílĩyî rĩzó Yésũ rî îjílí kpá óꞌdí, tãlâ gólâ ãâꞌdâ ró bê tã ı̣̂sũ íyíkâ tã õkó ꞌdĩ kâ tãsĩ rî. Gõꞌdá nĩngá sĩ rî, Yésũ drí ngãzó âdrélé ûrû íyî ãcê vó ꞌásĩ tã âtálé gólĩyî drí kĩ, “Õzõ õjílã ãzâ ãꞌdô bê ãlô ãnî lãfálé sĩ íyî ndrẽ ꞌbá trá kĩ yí ãâꞌdô tã õnjí ãkó rî, ꞌdõvó gólâ õtrõ kúnı̣́ mvá nĩ õkó ꞌdĩ vũzó sı̣́sı̣́.” ");
INSERT INTO avu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Gõꞌdá drílâ ậndı̣̃zó kpá óꞌdí, rĩꞌá tã îgĩlí ı̣̃nyạ́kú drı̣̃ı̣̂. ");
INSERT INTO avu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Gõꞌdá õjílã ꞌdî ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, kôrô õjílã gólĩyî õkó ꞌdĩ ậrú ꞌbá âjílí Yésũ ngálâ ꞌdĩ ꞌbá yî drí ngãzó lậꞌbúlı̣́ ãlô-ãlô. Gólĩyî ãrãkã ró rî ꞌbá yî drí ꞌdẽzó lậvũlı̣́ sı̣́sı̣́, gõꞌdá ạ̃mbúkũ lâ ꞌdĩ ꞌbá yî drí ꞌdẽzó gólĩyî vósĩ. Âyê cé Yésũ yî ĩꞌdî õkó ꞌdĩ bê gõꞌdá õꞌbí tólâ nã ꞌbá yí bê. ");
INSERT INTO avu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Gõꞌdá õjílã gólĩyî õkó ꞌdĩ âjí ꞌbá ꞌdĩ ꞌbá yî lậꞌbû ĩyî bê ndrĩ rî, Yésũ drí gõzó ngãlé ûrû tã îjílí õkó ꞌdĩ tı̣́ kĩ, “Õjílã ꞌẽ ꞌbá ĩyî ánî fũlı̣́ nõ ꞌbá yî ángô lé yã? Õjílã ãlô lâkí ꞌbá gólĩyî lãfálé ꞌásĩ lâŋõ fẽ ꞌbá ní drí rî bê yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Õkó ꞌdĩ drí tã lôgõzó Yésũ drí kĩ, “ꞌÉꞌẽ lı̣̃fı̣́ îmbá ꞌbá, õjílã ãzâ ãlô lâŋõ fẽ ꞌbá má drí rî yûꞌdạ́wạ́.” Gõꞌdá Yésũ drí tã âtázó õkó ꞌdĩ drí kĩ, “Ãꞌdô bê trá ĩtí rî, má âyê nî trá tã õnjí áníkâ ꞌásĩ. Ní nĩ, gõꞌdá ní ꞌê tã õnjí ꞌdĩ kpá kô óꞌdí.” ");
INSERT INTO avu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Gõꞌdá nĩngá sĩ, Yésũ drí îtõzó kpá óꞌdí õjílã õꞌbí ꞌdĩ ꞌbá yî îmbálé. Gólâ kĩ, “Mâ ĩꞌdî Ngá îꞌĩ ꞌî õjílã ndrĩ ãngó nõ kâ rî ꞌbá yî drí. Õjílã gólâ tã lẽ ꞌbá má ꞌá rî, gólâ âꞌdô lậmúꞌá ngá îꞌĩ ꞌásĩ. Gõꞌdá gólâ lậmú ı̣́nı̣́rı̣́kúwạ́ ꞌásĩ kô. Ĩtí rî, ngá îꞌĩ má drí ꞌẽꞌá fẽlâ õjílã rî ꞌdĩ drí rî âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî fẽꞌá gólâ drí.” ");
INSERT INTO avu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Gõꞌdá Pạ̃rúsı̣̃ yî tíbê rĩ ꞌbá ĩyî lạ́tı̣̂ lôndãlé ꞌẽzó Yésũ rî fũlı̣́ rî kpá bê ĩyî õjílã õꞌbí Yésũ drí rĩꞌá îmbálâ ꞌdĩ ꞌbá yî lãfálé. Gõꞌdá drílĩyî ngãzó úlı̣́ âtálé Yésũ drí kĩ, “Nî, ãꞌdî âꞌdô kó tã lẽꞌá nĩ úlı̣́ áníkâ ní drí rĩzó ánî lômbélé âtálâ ꞌdĩ ꞌbá yî ꞌá, ní drí ꞌbãzó cú ĩtí ũgúlı̣́ ậtı̣̃ ꞌbá ãkó nõ yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Má ãꞌdô kpálé ũgúlı̣́ ậtı̣̃ ꞌbá ãkó rî, úlı̣́ má drí rĩꞌá âtálâ ámâ tãsĩ nô rĩꞌá tã pạ̃tı̣́ı̣̃ ꞌî. Ãnî, nĩ ndré võ má drí ânĩzó ꞌálâ sĩ gõꞌdá má drí ꞌẽzó kpá gõlé ꞌálâ rî kô. Mâ rî gógó, má nı̣̃ trá kĩ, má ânĩ Ôvârí ngá lésĩ, gõꞌdá má âꞌdô gõꞌá kpá Ôvârí ngálâ ûrú ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nĩ ꞌbã tã ı̣̂sũ ãníkâ cé lãꞌbí ãníkâ ꞌá ĩꞌdî. Tã ꞌdî tãsĩ rî, ãnî drí tã âꞌbãzó má rú kĩ, má ãâꞌdô tã õnjí ꞌbá ꞌî. Tã ı̣̂sũ ámákâ rî âꞌdó ĩtí kô, tãlâ má zı̣́ õjílã ãzâ ãlô kô tã õnjí ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gõꞌdá õzõ má õlẽ tã-vó ãníkâ kĩlí rî, má âꞌdô kĩꞌá lâ mbı̣̂, tãlâ má âꞌdó kô élê tã ı̣̂sũ rî ꞌdĩ ꞌá. Tã ndrĩ má drí ı̣̂sũlı̣́ ꞌẽlé rî, rĩꞌá ámâ átá gólâ ámâ âjó ꞌbá rî kâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tã ꞌbãꞌbã ãníkâ ꞌá rî, íîgĩ trá kĩ, ‘Õzõ õjílã rı̣̃ õlẽ ĩyî tã-drı̣̃ trá ꞌdó úlı̣́ ãlô ꞌá rî, úlı̣́ rî ꞌdĩ trá úlı̣́ pạ̃tı̣́ı̣̃ ꞌî.’ ");
INSERT INTO avu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ĩtí rî, úlı̣́ má drí rĩꞌá âtálâ ꞌdĩ ꞌbá yî, mâ rî gógó ãkpã ĩꞌdî ũgúlı̣́ ậtı̣̃ ꞌbá ámâ nyãányâ kâ, gõꞌdá ámâ átá gólâ ámâ âjó ꞌbá rî kpá ĩꞌdî ũgúlı̣́ ậtı̣̃ ꞌbá ãzâ tã ndrĩ má drí rĩꞌá âtálâ nõ ꞌbá yí kâ ĩꞌdî, tãlâ úlı̣́ ãmákâ ámâ átá bê ndrĩ ꞌdó rĩꞌá úlı̣́ ãlô ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Gõꞌdá nĩngá sĩ, gólĩyî drí Yésũ rî îjízó kĩ, “Ánî átá íyíkâ ãꞌdî ĩꞌdî yã? Gólâ bê ángô lé yã?” Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Õzõ nĩ õlẽ tã trá má ꞌá rî, nĩ âꞌdô ámâ átá rî nı̣̃ꞌá. Gõꞌdá õzõ nĩ õlẽ tã má ꞌá kô rî, nĩ nı̣̃ı̣́ ámâ átá kpá kô.” ");
INSERT INTO avu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yésũ rî úlı̣́ ꞌdĩ ꞌbá yî âtálé ꞌdĩ gólâ drí rĩrĩ tã îmbálé jó ạ́ngı̣́ Ôvârí kâ rî ꞌálâ rî ꞌá, ãnyî jó gólâ rĩzó ngá fẽfẽ rĩꞌá fẽlâ Ôvârí drí rî ꞌbãlé ꞌálâ rî ꞌá. Gõꞌdá õjílã ãzãkã dõó drı̣́ Yésũ rú kô, tãlâ kậyı̣̂ ꞌẽzó gólâ rî rũlı̣́ rî âcá drẽ kô. ");
INSERT INTO avu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Gõꞌdá Yésũ drí tã âtázó drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí kpá óꞌdí kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, má âꞌdô nĩꞌá nõngá sĩ vólé. Nĩ âꞌdô ámâ ndãꞌá kpı̣̃ı̣̂. Võ gólâ má drí ꞌẽzó nĩlí ꞌálâ rî, nĩ cá kô tólâ, gõꞌdá nĩ âꞌdô ôdrãꞌá tã õnjí ãníkâ ꞌá, tãlâ nĩ lẽé tã ámákâ kô.” ");
INSERT INTO avu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Gõꞌdá nĩngá sĩ, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, drílĩyî tã âtázó ĩyî lãfálé ꞌásĩ kĩ, “Úlı̣́ gólâkâ âtálé kĩ, mã îcá kô cãlé võ yí drí ꞌẽzó nĩlí ꞌálâ rî ꞌá rî, tã ífí lâ ángô tí yã? Gólâ âꞌdô íyî nyãányâ fũꞌá yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nĩngá sĩ, Yésũ drí tã âtázó drílĩyî tã lẽ ãkõ gólĩyíkâ tãsĩ kĩ, “Má âtâ ãnî drí, ãnî rĩꞌá cé õjílã ãngó nõ kâ ꞌî, gõꞌdá mâ rî gógó âꞌdó kô cé õjílã ãngó nõ kâ ꞌî, má ânĩ ûrú lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ĩtí rî, má âtâ ãnî drí, õzõ nĩ õlẽ tã kô kĩ, mâ ĩꞌdî ꞌdíyî pã ꞌbá ꞌî rî, lâŋõ tã õnjí ãníkâ rî kâ âꞌdô gõꞌá ãkpã ãnî drı̣̃ı̣̂. Nĩ âꞌdô ôdrãꞌá tã õnjí ãníkâ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã îjízó Yésũ tı̣́ kĩ, “Ní âꞌdâ drẽ tã ãmâ drí trậ, nî ãꞌdî ĩꞌdî yã?” Yésũ drí gõzó tã-drı̣̃ lôgõlé gólĩyî drí kĩ, “Mâ õjílã gólâ má drí rĩꞌá tã lâ âtálé ãnî drí ı̣̃tú vósĩ cé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mâ rĩꞌá tã bê dũû ꞌẽꞌá âꞌdálâ ãnî drí tã õnjí ãníkâ rĩꞌá ꞌẽlâ rî ꞌbá yî tãsĩ. Gõꞌdá má rî nõ kpá té tã gólâ ámâ âjó ꞌbá rî kâ âtálé ĩꞌdî ãnî õjílã ãngó nõ kâ drí. Gõꞌdá gólâ ámâ âjó ꞌbá rî, rî íyíkâ zãâ úlı̣́ pạ̃tı̣́ı̣̃ âtálé ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî nı̣̃ı̣́ kô kĩ, Yésũ rî ꞌdĩ tã íyî átá Ôvârí tíbê íyî âjó ꞌbá rî kâ âtálé ĩꞌdî gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ĩtí rî, Yésũ drí tã âtázó gólĩyî drí kĩ, “Má nı̣̃ trá kĩ, õzõ kậyı̣̂ ãnî drí ꞌẽzó ámâ fũlı̣́ ꞌá lâ rî õtírĩ âcá rî, nĩ âꞌdô ámâ îpáꞌá fê lậlı̣̂-lậlı̣̂ drı̣̃ı̣̂ ûrû. Gõꞌdá õzõ nĩ õꞌê trá ĩtí rî, ãnî drí gõzó nı̣̃lâ ạ̃dũ lésĩ kĩ, pạ̃tı̣́ı̣̃, mâ ĩꞌdî ꞌdíyî pã ꞌbá tíbê Ôvârí drí âjólé ûrú lésĩ rî. Nĩ âꞌdô nı̣̃ꞌá lâ kpá kĩ, tã ndrĩ má drí rĩꞌá îmbálâ rî ꞌbá yî, âꞌdó kô tã ámâ nyãányâ kâ ĩꞌdî. Gõꞌdá má rî tã ámâ átá drí âꞌdálé rî îmbálé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ôvârí ámâ âjó ꞌbá rî, gólâ bê rĩꞌá má bê kậyı̣̂ vósĩ cé, tãlâ má rî tã gólâ drí lẽlé rî ꞌẽlé ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Gõꞌdá õjílã ꞌdî ꞌbá yî ârî ĩyî tã îmbâ-îmbâ Yésũ drí îmbálé ꞌdĩ bê rî, õjílã dũû gólĩyî lãfálé ꞌásĩ drí ngãzó tã lẽlé Yésũ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nĩngá sĩ, Yésũ drí ngãzó tã âtálé õjílã gólĩyî tã lẽ ꞌbá trá yí ꞌá ꞌdĩ ꞌbá yî drí kĩ, “Má âtâ ãnî drí pạ̃tı̣́-pạ̃tı̣̃ ró, úlı̣́ Ôvârí kâ má drí rĩꞌá îmbálâ ãnî drí nõ, õzõ nĩ ũnjû trá rú lâ rî, nĩ âꞌdô ꞌbãꞌá pạ̃tı̣́ı̣̃ tã ârí ꞌbá ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gõꞌdá nĩ âꞌdô úlı̣́ Ôvârí kâ ꞌdĩ ífí lâ nı̣̃ꞌá. Õzõ nĩ ũnı̣̃ úlı̣́ rî ꞌdĩ ífí lâ trá rî, úlı̣́ rî ꞌdĩ âꞌdô ãnî înjíꞌá lâŋõ tã õnjí ãníkâ rî kâ ꞌásĩ. Nĩ âꞌdó gõꞌdá rạ̃gı̣́ı̣̃ tã õnjí kâ ró kô.” ");
INSERT INTO avu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gõꞌdá Pạ̃rúsı̣̃ yî tíbê tã Yésũ kâ lẽ ꞌbá kô rî yî drí tã lôgõzó Yésũ drı̣̃ı̣̂ kĩ, “Ní kĩ ãꞌdô yã? Mã âꞌdó rạ̃gı̣́ı̣̃ õjílã ãzâ kâ ꞌî kô! Ãmâ rĩꞌá Ãbãrãyámã rî ózõwá yî ĩꞌdî. Ní âꞌdô ãmâ înjíꞌá ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Má âtâ tã ãnî drí, õjílã gólâ tíbê rĩ ꞌbá zãâ tã õnjí ꞌẽlé rî, gólâ rĩꞌá rạ̃gı̣́ı̣̃ tã õnjí kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nĩ nı̣̃ trá tãndí ró kĩ, rạ̃gı̣́ı̣̃ rí zãâ lôsĩ ꞌẽlé íyî lı̣́pı̣̂ gólâ drí rĩzó lôsĩ ꞌẽlé drílâ rî bê kô, tãlâ lı̣́pı̣̂ lâ îcâ trá gólâ rî gĩlí vólé õjílã ãzâ drí. Gõꞌdá mvá ágó ró ꞌbã-lı̣́pı̣̂ kâ rî âꞌdô rĩꞌá cé nĩ zãâ átá lâ rî mvá ró. ");
INSERT INTO avu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ĩtí rî, mâ rî gógó Ôvârí rî mvá ró rî, õzõ má ĩînjî ãnî trá tã õnjí ãníkâ ꞌásĩ rî, pạ̃tı̣́ı̣̃ ró, áâꞌdô ãnî ꞌbãꞌá drı̣̃-bạ́lạ́yı̣̂ ró rạ̃gı̣̃ tã õnjí kâ ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gõꞌdá nĩngá sĩ, Yésũ drí kpá tã âtázó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ, “Má nı̣̃ trá kĩ, ãnî Ãbãrãyámã rî ózõwá yî ĩꞌdî. Gõꞌdá nĩ ꞌê ámâ fũlı̣́ ãꞌdô tãsĩ yã? Má ndrê bê rî, nĩ ꞌê ámâ fũlı̣́ ꞌdĩ, tãlâ nĩ lẽé tã ámákâ rĩꞌá îmbálâ rî kô. ");
INSERT INTO avu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pạ̃tı̣́ı̣̃ ró, má âtâ ãnî drí tã gólĩyî má drí rĩꞌá îmbálâ nõ rĩꞌá ámâ átá drí âꞌdálé má drí ꞌẽlé rî ĩꞌdî. Gõꞌdá nĩ rî ãníkâ tã gólâ ãnî átá ãzákôlâ ꞌdĩ drí âtálé ãnî drí ꞌẽlé rî ꞌẽlé ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Gõꞌdá õjílã ꞌdî ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ ꞌbá yî rî, drílĩyî tã-drı̣̃ lôgõzó gólâ drí kĩ, “Pạ̃tı̣́ı̣̃ ãmâ átá rĩꞌá Ãbãrãyámã ĩꞌdî.” Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Tí õzõ nĩ ãꞌdô pạ̃tı̣́ı̣̃ Ãbãrãyámã rî mvá yî ĩꞌdî rî, tí nĩ âꞌdô tã lẽꞌá úlı̣́ ámákâ nõ ꞌbá yî ꞌá, õzõ Ãbãrãyámã drí tã lẽrẽ úlı̣́ Ôvârí kâ ꞌá rî tí. ");
INSERT INTO avu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Má rî nõ pạ̃tı̣́ı̣̃ ró tã Ôvârí drí âꞌdálé trá má drí rî âtálé ĩꞌdî. Kpálé ĩtí rî, nĩ lẽ ámâ fũlı̣́. Ãbãrãyámã ꞌé tã ãzâ kô õzõ ãnî drí ꞌẽꞌá ꞌẽlâ rî kâtí! ");
INSERT INTO avu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ãꞌdô ĩtí rî, nĩ âꞌdó kô Ãbãrãyámã rî mvá yî ĩꞌdî. Ãnî átá bê rĩꞌá ngĩî, tãlâ nĩ rî tã gólâkâ ꞌẽlé ĩꞌdî.” Gõꞌdá õjílã ꞌdî ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, drílĩyî kpá tã-drı̣̃ lôgõzó Yésũ drí ạ̃wạ̃ sĩ kĩ, “Tã pạ̃tı̣́ı̣̃ ró, mã âꞌdó kô mõrõgíyã mvá ꞌî. Ãmâ átá íyíkâ kó cé ãlô Ôvârí ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ĩtí rî, Yésũ drí kpá tã âtázó õjílã ꞌdî ꞌbá yî drí kĩ, “Õzõ tíkó ãnî ãꞌdô pạ̃tı̣́-pạ̃tı̣̃ Ôvârí rî mvá ꞌî rî, ámâ lôvó âꞌdô ꞌbãꞌá ãnî ꞌá, nĩ âꞌdô ámâ lẽꞌá. Má ânĩí kô ámâ nyãányâ sĩ. Má ânĩ drı̣́-ãcê Ôvârí kâ sĩ. Gólâ âjô mâ nĩ. ");
INSERT INTO avu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Úlı̣́ má drí rĩꞌá âtálâ ãnî drí rî, tã ífí lâ fí kô ãnî drı̣̃ı̣̂ ãꞌdô tãsĩ yã? Nĩ gâ vólé dó, tãlâ nĩ lẽé úlı̣́ ꞌdĩ ârílí tã lâ ꞌẽzó kô! ");
INSERT INTO avu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Má nı̣̃ trá kĩ, ãnî Sãtánã rî mvá yî ĩꞌdî. Tãlâ ĩꞌdî ꞌdĩ ãnî drí lẽzó tã Sãtánã drí lẽlé rî ꞌẽlé ĩꞌdî. Tã gólâ drí lẽlé rî íyíkâ zãâ tã õjílã ûfû kâ ĩꞌdî. Gólâ lẽé tã mbı̣̂ Ôvârí kâ rî kô. Gólâ âtâ íyíkâ zãâ úlı̣́ õnjõ kâ õjílã âdózó rî ĩꞌdî, gólâ ꞌê íyíkâ kpá zãâ tã íyî pı̣̃pı̣̂sı̣́lı̣́ drí lẽlé rî ĩꞌdî, tãlâ gólâ âꞌdó kô tã pạ̃tı̣́ı̣̃ âtá ꞌbá ꞌî. Gólâ rĩꞌá õnjõ lı̣́pı̣̂ ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gõꞌdá mâ rî gógó âdó õnjõ kô, gõꞌdá má rî zãâ tã pạ̃tı̣́ı̣̃ âtálé ĩꞌdî. Tã ꞌdî tãsĩ rî, ĩꞌdî ãnî drí vólé gãzó dó tã lẽlé úlı̣́ má drí âtálé rî ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mĩ ndrê drẽ, tã ndrĩ má drí rĩꞌá ꞌẽlâ rî ꞌbá yî, tã õnjí bê ꞌá lâ yã? Õzõ tã má drí rĩꞌá âtálâ rî ꞌbá yî ãꞌdô tã pạ̃tı̣́ı̣̃ ꞌî rî, gõꞌdá nĩ lẽé tã kô ꞌá lâ ãꞌdô tãsĩ yã? ");
INSERT INTO avu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Õzõ ãꞌdô trá ĩtí rî, nĩ âꞌdó kô Ôvârí rî mvá yî ĩꞌdî, tãlâ nĩ gã úlı̣́ Ôvârí kâ trá dó! Õzõ tí nĩ ãꞌdô pạ̃tı̣́-pạ̃tı̣̃ ró Ôvârí rî mvá yî ĩꞌdî rî, nĩ âꞌdô tã lẽꞌá úlı̣́ Ôvârí kâ má drí rĩꞌá âtálâ nõ ꞌbá yî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Gõꞌdá nĩngá sĩ, õjílã Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî drí tã âtázó Yésũ drí ꞌdásí sĩ kĩ, “Tíkó mã nı̣̃ı̣́ kô kĩ, nî rĩꞌá Sãmárĩyã lé ꞌbá ꞌî, cú líndrí õnjí bê ní ꞌá yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ĩtí rî, Yésũ drí tã-drı̣̃ lôgõzó õjílã ꞌdî ꞌbá yî drí kĩ, “Má âꞌdó líndrí õnjí bê kô. Má rî nõ ámâ átá Ôvârí rî ı̣̂njı̣̃ꞌá. Gõꞌdá nĩ gã dó ámâ ı̣̂njı̣̃lı̣́. ");
INSERT INTO avu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Má âtâ ãnî drí tã pạ̃tı̣́ı̣̃ ró, má ꞌbãá ámâ nyãányâ nĩ kô õjílã ı̣̃ı̣̂njı̣̃ ró mâ bê. Ôvârí lẽ nĩ õjílã drí ámâ ı̣̂njı̣̃lı̣́, gõꞌdá Ôvârí âꞌdô tã gólĩyíkâ kĩꞌá nĩ. ");
INSERT INTO avu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Má âtâ ãnî drí tã pạ̃tı̣́-pạ̃tı̣̃ ró, õzõ õjílã ãzâ õlẽ tã trá úlı̣́ ámákâ rĩꞌá âtálâ nõ ꞌbá yî ꞌá rî, õjílã rî ꞌdĩ drãá kô, gólâ âꞌdô rĩꞌá lédrẽ-lédrẽ ró zãâ.” ");
INSERT INTO avu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Gõꞌdá õjílã ꞌdî ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, drílĩyî tã âtázó gólâ drí kĩ, “Úlı̣́ ãmâ drí âtálé rî fõ trá ꞌálâ sĩ pạ̃tı̣́ı̣̃. Ãgô ꞌdĩ rĩꞌá cú líndrí õnjí bê yí ꞌá. Ãmâ ạ́ꞌbı̣́yạ́ Ãbãrãyámã tã ậngũ ꞌbá ạ̃kû rî ꞌbá yí bê rî ôdrã ĩyíkâ trá. Gõꞌdá õjílã ãzâ kpá bê ãngó nõ ꞌá drã ꞌbá kô yã? Gõꞌdá ánî nyãányâ, ní âtâ tã kĩ, õzõ mã ãârî úlı̣́ áníkâ trá rî, mã îcá kô drãlé rî! Ní ı̣̂sũ áníkâ bê rî, nî ãꞌdî ĩꞌdî yã? Ĩtí rî, mbârâkã áníkâ rî lậvũ gạ̃rạ̃ mbârâkã gólĩyî tíbê drã ꞌbá ꞌdĩ ꞌbá yí kâ drı̣̃ı̣̂ sĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Gõꞌdá nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó kpá óꞌdí gólĩyî drí kĩ, “Nĩ ı̣̂sũ ãníkâ bê rî, má ꞌbã ámâ nyãányâ nĩ âꞌdólé ãmbá ró yã? Âꞌdó ĩtí kô. Tí õzõ má õró ámâ nyãányâ ꞌbãâ nĩ âꞌdólé ãmbá ró rî, tí úlı̣́ ámákâ nõ âꞌdô ꞌbãꞌá âzâ-âzâ ró ãnî drí. Gólâ tíbê ámâ ꞌbã ꞌbá ãmbá ró rî, rĩꞌá ámâ átá tíbê ãnî drí rĩꞌá ı̣̂njı̣̃lâ kĩ, ãâꞌdô Ôvârí ãníkâ ĩꞌdî rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gõꞌdá nĩ nı̣̃ı̣́ gólâ kô. Má nı̣̃ gólâ trá cé nĩ. Tí õzõ má ãâtâ kĩ, má ũnı̣̃ı̣́ gólâ kô rî, má âꞌdô ꞌbãꞌá õnjõ ꞌbá ró õzõ ãní kâtí. Má nı̣̃ gólâ trá tãndí ró, gõꞌdá má rî nõ té tã gólâ drí lẽlé má drí ꞌẽlé rî ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ạ̃kû ró drẽ ãkpã Ãbãrãyámã drãâ kô rî, gólâ ꞌbã lı̣̃fı̣́ trá âcâ-âcâ ámákâ drı̣̃ı̣̂, gõꞌdá gólâ rĩꞌá ãyĩkõ ró ámâ ndrẽlé. Gõꞌdá tãlâ ãꞌdô ꞌî ãnî gólâ rî ózõwá yî drí ámâ lẽzó kô yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Gõꞌdá Pạ̃rúsı̣̃ ꞌdî ꞌbá yî drí kpá tã lôgõzó Yésũ drí kĩ, “Wáâwá, ní rî tã âtálé ĩtí ꞌdĩ ãꞌdô tãsĩ yã? Ndrô áníkâ cá drẽ nyâꞌdî-rı̣̃-drı̣̃-lâ-ngâ-mûdrı̣́ kô. Ãmâ ạ́ꞌbı̣́yạ́ Ãbãrãyámã drã trá ạ̃kû ró, gõꞌdá ní âkĩꞌá nĩ rî, yí õndrê gólâ trá ꞌdĩ ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yésũ drí tã-drı̣̃ lôgõzó drílĩyî kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́-pạ̃tı̣̃ ró, sı̣́sı̣́ drẽ Ãbãrãyámã rî tı̣̃ ãkó rî, mâ bê rĩꞌá ạ̃kû ró Ôvârí ngálâ.” ");
INSERT INTO avu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Gõꞌdá nĩngá sĩ, Pạ̃rúsı̣̃ yî ârî ĩyî úlı̣́ Yésũ drí âtálé ꞌdĩ bê rî, kôrô drílĩyî ngãzó ạ̃wạ̃ ró, nĩꞌá kúnı̣́ mvá lôndãlé ꞌẽzó Yésũ rî lûvũlı̣́ ĩꞌdî sĩ lâ fũlı̣́, tãlâ gólâ âmã yî trá âꞌdólé Ôvârí ró. Gõꞌdá kôrô Yésũ drí íyîngá ꞌbẽzó dı̣̃ vólé gólĩyî ágálé sĩ ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ kâ ꞌdĩ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kậyı̣̂ ãzâ sĩ, Yésũ yî rĩꞌá lậvũꞌá lãjóꞌbá íyíkâ rî ꞌbá yí bê lạ́tı̣̂ drı̣̃ı̣̂ sĩ. Gõꞌdá drílĩyî nĩzó ãgô ãzâ ûsúlı̣́, útı̣̂ ãgô rî ꞌdĩ kó lı̣̃fı̣́ ãkó ꞌálé lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî ndrê ĩyî bê ãgô ꞌdĩ lı̣̃fı̣́ ãkó rî, drílĩyî Yésũ rî îjízó kĩ, “Tã îmbá ꞌbá, tã õnjí rî gógó ãgô nõ ꞌbã ꞌbá gólâ rî tı̣̃zó ꞌálé lésĩ lı̣̃fı̣́ ãkó nõ ãꞌdî kâ ĩꞌdî yã? ꞌDĩî tã õnjí átá lâ yí kâ ĩꞌdî ândré lâ bê, ngãtá tã õnjí gólâ rî nyãányâ kâ ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Gõꞌdá Yésũ drí tã-drı̣̃ jãzó gólĩyî drí kĩ, “Tı̣̃tı̣̃ ãgô ꞌdĩ kâ lı̣̃fı̣́ ãkó ꞌdĩ rî âꞌdó kô tã õnjí õjílã ãzâ ãlôlâ kâ tãsĩ. Tı̣̃tı̣̃ gólâkâ lı̣̃fı̣́ ãkó ꞌdĩ, Ôvârí lẽ má drí mbârâkã íyíkâ âꞌdálé ãgô nõ rú lı̣̃fı̣́ lâ njı̣̃njı̣̃ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Rĩꞌá tãndí ró ãmâ drí lôsĩ Ôvârí gólâ ámâ âjó ꞌbá rî kâ rî ꞌẽzó ngbãângbânõ ãkpãkãꞌdã ngá ậnı̣́ drẽ kô. Tãlâ ı̣̃tú õfî trá rî, õjílã ãzâ gõꞌdá yûꞌdạ́wạ́ lôsĩ ꞌẽlé ngạ́cı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Gõꞌdá nĩ ndrê drẽ, kậyı̣̂ má drí ꞌbãzó drẽ bê rĩꞌá lédrẽ-lédrẽ ró ãngó nõ ꞌá rî, mâ ĩꞌdî rĩꞌá Ngá îꞌĩ ꞌî õjílã ãngó nõ kâ drí.” ");
INSERT INTO avu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Gõꞌdá Yésũ âtálé bê úlı̣́ ꞌdĩ ĩtí lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí rî, gólâ drí ậndı̣̃zó tũ wũlı̣́ ı̣̃nyạ́kú drı̣̃ı̣̂, gõꞌdá drílâ tũ ꞌdî ônjázó ı̣̃nyạ́kú bê gõzó ũlútrạ́ lâ ꞌdĩ bẽlé ãgô ꞌdĩ lı̣̃fı̣́ ĩnyĩrĩkõ lâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Gõꞌdá nĩngá sĩ, drílâ tã âtázó ãgô ꞌdĩ drí kĩ, “Ní nĩ ánî lı̣̃fı̣́ jĩlí ạ́pậrı̣̂ gólâ zı̣̃lı̣́ Sĩlómã nã ꞌálâ.” Gõꞌdá ãgô ꞌdĩ drí ngãzó nĩlí ạ́pậrı̣̂ rî ꞌdĩ tı̣́ ꞌálâ. Gólâ câ bê tólâ rî, drílâ íyî lı̣̃fı̣́ jĩzó lũmvû ạ́pậrı̣̂ ꞌdĩ kâ sĩ, õzõ Yésũ drí âtálé gólâ drí rî kâtí. Kôrô ãgô ꞌdĩ lı̣̃fı̣́ lâ drí rû njı̣̃zó, drílâ võ ndrẽzó ngbángbá. Gõꞌdá ãgô ꞌdĩ drí ngãzó gõlé ꞌbã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ĩtí rî, õjílã gólĩyî ꞌbã-tı̣̂-ꞌdı̣̃-ãzí gólâkâ ró rî yî gõꞌdá kpá gólĩyî gólâ rî ndrẽ ꞌbá trá sı̣́sı̣́ rĩrĩ ꞌá lạ́tı̣̂ gãrã drı̣̃ ꞌá rĩꞌá ngá zı̣̃lı̣́ õjílã tı̣́ sĩ rî drí tã âtázó kĩ, “Hé, ákĩ ꞌdĩî fí ãgô lı̣̃fı̣́ ãkó rĩ ꞌbá rĩlí ngá zı̣̃lı̣́ kárá õjílã tı̣́ sĩ lạ́tı̣̂ gãrã drı̣̃ ꞌá rî ĩꞌdî kô yã? Gólâ gõ rî ngá ndrẽlé nõ ángô tí ró yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Gõꞌdá õjílã ãzâ ꞌbá yî kĩ, “ꞌDĩî âꞌdó kô gólâ ĩꞌdî! Ãgô ãzâ bê rĩꞌá nyé õzõ gólâ tí.” Gõꞌdá ãgô lı̣̃fı̣́ lâ drí rû njı̣̃lı̣́ trá ꞌdĩ ârílí bê tã õjílã ꞌdî ꞌbá yî drí rĩꞌá ôjálâ ĩyî lãfálé ꞌásĩ ꞌdî rî, drílâ gõzó tã âtálé gólĩyî drí kĩ, “Mâ ĩꞌdî tíbê lı̣̃fı̣́ ãkó rĩ ꞌbá ngá zı̣̃lı̣́ õjílã tı̣́ sĩ lạ́tı̣̂ gãrã drı̣̃ ꞌásĩ rî. Má rî võ ndrẽlé nõ nĩ pạ̃tı̣́ı̣̃, tãlâ ámâ lı̣̃fı̣́ njı̣̃ rû trá!” ");
INSERT INTO avu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Gõꞌdá õjílã ꞌdî ꞌbá yî tı̣̂ lâ yî drí ậꞌdı̣́zó ndrĩ. Gõꞌdá drílĩyî ãgô ꞌdĩ îjízó kĩ, “Ánî lı̣̃fı̣́ njı̣̃ rû ní drí rĩzó võ ndrẽlé ꞌdĩ ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ãgô ꞌdĩ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Ãgô gólâ rú bê Yésũ rî njı̣̃ ámâ lı̣̃fı̣́ nĩ. Gólâ wû tũ nĩ ı̣̃nyạ́kú ônjázó ĩꞌdî sĩ lâ, gõzó ũlútrạ́ lâ ꞌdĩ bẽlé ámâ lı̣̃fı̣́ ꞌá. Gõꞌdá gólâ drí ámâ jõzó nĩlí ạ́pậrı̣̂ zı̣̃lı̣́ Sĩlómã rî tı̣́ ꞌálâ ámâ lı̣̃fı̣́ jĩlí lũmvû lâ sĩ. Gõꞌdá má jĩ ámâ lı̣̃fı̣́ lũmvû nã sĩ bê rî, kôrô ámâ lı̣̃fı̣́ drí rû njı̣̃zó má drí võ ndrẽzó ngbángbá!” ");
INSERT INTO avu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Gõꞌdá õjílã ꞌdî ꞌbá yî drí kpá gólâ rî îjízó kĩ, “Gõꞌdá ãgô rî gógó ꞌdĩ bê ángô lé yã?” Ãgô ꞌdĩ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Má nı̣̃ı̣́ võ gólâ drí ꞌbãzó ꞌá lâ rî kô.” ");
INSERT INTO avu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gõꞌdá nĩngá sĩ, õjílã ꞌdî ꞌbá yî drí ngãzó ãgô lı̣̃fı̣́ lâ njı̣̃lı̣́ trá ꞌdĩ trõlé âjílí Pạ̃rúsı̣̃ yî ândrá tã lâ âꞌdálé gólĩyî drí. ");
INSERT INTO avu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gólĩyî âjî ãgô ꞌdĩ Pạ̃rúsı̣̃ yî ngálâ, tãlâ kậyı̣̂ gólâ Yésũ drí ãgô ꞌdĩ lı̣̃fı̣́ lâ njı̣̃zó ꞌá lâ rî rĩꞌá kậyı̣̂ lôvô kâ ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Gõꞌdá Pạ̃rúsı̣̃ yî drí ãgô ꞌdĩ îjízó kĩ, “Ánî lı̣̃fı̣́ njı̣̃ rû trá ángô tí ró võ ndrẽlé yã?” Gólâ kĩ, “Ãgô rú bê Yésũ rî ônjâ ı̣̃nyạ́kú nĩ tũ sĩ ũlútrạ́ lâ trõlé bẽlé ámâ lı̣̃fı̣́ ꞌá, gõꞌdá gólâ kĩ, má õnĩ nĩꞌá ámâ lı̣̃fı̣́ jĩlí. Gõꞌdá má jĩ ámâ lı̣̃fı̣́ bê rî, kôrô ámâ lı̣̃fı̣́ drí rû njı̣̃zó võ ndrẽlé dódó nõ!” ");
INSERT INTO avu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Gõꞌdá Pạ̃rúsı̣̃ yî ârílí bê úlı̣́ ãgô ꞌdĩ drí ngĩlí gólĩyî drí ꞌdĩ rî, kôrô drílĩyî ngãzó rĩꞌá tı̣̂ ânyálé ĩyî lãfálé ꞌásĩ. Ãzâ ꞌbá yî kĩ, “Ãꞌdô ĩtí rî, ãgô Yésũ ꞌdĩ tã õnjí ꞌbá ꞌî. Ôvârí âjó gólâ nĩ kô, tãlâ gólâ wã trá tã ꞌbãꞌbã ãmákâ kậyı̣̂ rãtáã kâ rî kâ drı̣̃ı̣̂ sĩ.” Gõꞌdá ãzâ ꞌbá yî kĩ ĩyíkâ rî, “Õjílã gólâ ꞌbã ꞌbá tã õnjí ꞌbá ró rî âꞌdô íyíkâ mbârâkã ûsúꞌá tã lârâkô ãmbá ĩtí ꞌdĩ ꞌẽzó ꞌdĩ ãꞌdô ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ĩtí rî, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ãgô ꞌdĩ îjízó kpá óꞌdí kĩ, “Nî gólâ tíbê lı̣̃fı̣́ lâ njı̣̃lı̣́ nõ, ní âtâ drẽ tã nô tãndí ró ãmâ drí. Tã ı̣̂sũ áníkâ ãgô gólâ ánî lı̣̃fı̣́ njı̣̃ ꞌbá ꞌdĩ tãsĩ rî íyíkâ ángô tí yã?” Gõꞌdá ãgô ꞌdĩ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Ãgô ámâ lı̣̃fı̣́ njı̣̃ ꞌbá ꞌdĩ, gólâ rĩꞌá tã ậngũ ꞌbá Ôvârí drí âjólé rî ĩꞌdî!” ");
INSERT INTO avu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Gõꞌdá kpálé tã ndrĩ ãgô ꞌdĩ drí ngĩlí Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ꞌdĩ ꞌbá yî ꞌásĩ rî, gólĩyî gâ ĩyî vólé dó tã lẽlé kĩ, pạ̃tı̣́ı̣̃ ãgô ꞌdĩ tı̣̃rı̣̃ lâ ꞌásĩ rî gólâ rĩꞌá lı̣̃fı̣́ ãkó, gõꞌdá Yésũ njı̣̃ lı̣̃fı̣́ lâ nĩ võ ndrẽlé dódó. Gõꞌdá drílĩyî võrã jõzó ãgô ꞌdĩ átá lâ yî vó ândré lâ bê gólĩyî ậzı̣́lı̣́ ânĩlí ĩyî ngálâ. ");
INSERT INTO avu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Gõꞌdá ãgô ꞌdĩ átá lâ yî âcâ bê ândré lâ bê rî, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kpá gólĩyî îjízó kĩ, “Nõô pạ̃tı̣́ı̣̃ mvá ágó ãnî drí tı̣̃lı̣́ lı̣̃fı̣́ ãkó ꞌálé lésĩ rî ĩꞌdî yã? Õzõ ãꞌdô pạ̃tı̣́ı̣̃ gólâ ĩꞌdî rî, lı̣̃fı̣́ lâ gõ njı̣̃ rû rĩꞌá võ ndrẽlé ãmbã drı̣̃ı̣̂ nõ ángô tí ró yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Gõꞌdá ãgô ꞌdĩ átá lâ yî ândré lâ bê drí tã-drı̣̃ lôgõzó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ, “Ãwô pạ̃tı̣́ı̣̃, nõô mvá ágó ãmákâ rî ĩꞌdî, mã nı̣̃ trá pạ̃tı̣́ı̣̃ kĩ, mã tı̣̂ gólâ trá lı̣̃fı̣́ ãkó. ");
INSERT INTO avu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gõꞌdá mã nı̣̃ı̣́ lạ́tı̣̂ ãmâ mvá ꞌdĩ lı̣̃fı̣́ lâ drí rû njı̣̃zó rî kô, ngãtá ãꞌdî njı̣̃ lı̣̃fı̣́ lâ nĩ võ ndrẽlé yã rî. Nĩ âꞌdô îjíꞌá lâ fí gólâ tı̣́, gólâ ãâꞌdâ ró íyî tı̣̂ sĩ ãnî drí, tãlâ gólâ trá õjílã ãmbá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ãgô ꞌdĩ átá lâ yî ândré lâ bê âtâ ĩyî tã ꞌdî ĩtí ꞌdĩ rî, tãlâ gólĩyî ũrı̣̃ ró tã ꞌbãꞌbã Yúdạ̃ yí kâ tãsĩ kĩꞌá nĩ rî, õzõ õjílã ãzâ õlẽ tã trá Yésũ ꞌá kĩ, gólâ ãâꞌdô ꞌdíyî pã ꞌbá ꞌî rî, áâꞌdô õjílã rî ꞌdĩ drõꞌá vólé jó tã Ôvârí kâ ârî kâ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ꞌDĩî tã ífí ãgô ꞌdĩ átá lâ yî ândré lâ bê drí tã âtázó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí, gólĩyî ĩîjî mvá ꞌdĩ ãâꞌdâ ró bê cú íyî tı̣̂ sĩ, tãlâ gólâ trá ãmbá ró rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gõꞌdá Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ãgô lı̣̃fı̣́ lâ njı̣̃lı̣́ ꞌdĩ ậzı̣́zó kpá óꞌdí tã îjízó tı̣́ lâ kĩ. “Ní âꞌdâ drẽ tã pạ̃tı̣́-pạ̃tı̣̃ Ôvârí rî ı̣̂njı̣̃zó rî ãmâ drí Ôvârí ágálé, pạ̃tı̣́ı̣̃ ãgô rú bê Yésũ ꞌdĩ njı̣̃ ánî lı̣̃fı̣́ fí nĩ yã? Mã îjî nî nõ rî, tãlâ mã nı̣̃ trá ãgô gólâ Yésũ ꞌdĩ rĩꞌá tã õnjí ꞌbá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Gõꞌdá ãgô ꞌdĩ drí tã-drı̣̃ lôgõzó Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ, “Má nı̣̃ı̣́ kô ngãtá Yésũ tã õnjí ꞌbá ꞌî yã ngãtá âꞌdó kô tã õnjí ꞌbá ꞌî yã rî. Tã má drí nı̣̃lı̣́ rî íyíkâ cé tã ãlô ꞌî, ámâ lı̣̃fı̣́ ndré võ kó kô ãkpã ámâ tı̣̃rı̣̃ lésĩ. Gõꞌdá ngbãângbânõ rî, Yésũ njı̣̃ ámâ lı̣̃fı̣́ trá, ámâ lı̣̃fı̣́ ndrê võ gõꞌdá trá dódó.” ");
INSERT INTO avu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nĩngá sĩ, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ãgô ꞌdĩ îjízó kpá óꞌdí kĩ, “Ní âtâ drẽ tã mbı̣̂ rî ĩꞌdî ãmâ drí! Gólâ ꞌê ãꞌdô tã ꞌî ánî lı̣̃fı̣́ drí rû njı̣̃zó võ ndrẽlé nõ yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Gõꞌdá ãgô ꞌdĩ drí ngãzó tã-drı̣̃ lôgõlé gólĩyî drí kĩ, “Nĩ rî ámâ îjílí kpá óꞌdí tã ãlô nõ tãsĩ ꞌdî tãlâ ãꞌdô ꞌî yã? Tí õzõ má õró tã-drı̣̃ lôgõô ãnî drí kô rî, rĩꞌá tãndí ró! Nĩ îjî mâ ꞌdĩ, tãlâ nĩ lẽ kpá trá âꞌdólé tã ârí ꞌbá Yésũ kâ ró yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gõꞌdá Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí ngãzó ạ̃wạ̃ ró úlı̣́ ꞌdĩ ꞌbá yî tãsĩ. Drílĩyî ãgô ꞌdĩ ꞌdãzó gõꞌdá tã âtázó drílâ kĩ, “Mã ndrê bê rî, nî rî gógó rĩꞌá tã ârí ꞌbá ãzâ ãlô Yésũ kâ rî ĩꞌdî. Gõꞌdá mã rî ãmákâ tã ꞌbãꞌbã Músạ̃ kâ rî ârílí gõꞌdá ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tãlâ mã nı̣̃ trá kĩ, Ôvârí âtâ úlı̣́ trá ãmâ ạ́ꞌbı̣́yạ́ yî drí Músạ̃ sĩ, rĩꞌá úlı̣́ pạ̃tı̣́ı̣̃ ꞌî. Gõꞌdá mã nı̣̃ı̣́ tã ãzãkã kô Yésũ rî tãsĩ. Gõꞌdá mã nı̣̃ı̣́ võ gólâ drí ânĩzó ꞌálâ sĩ rî kpá kô.” ");
INSERT INTO avu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nĩngá sĩ, ãgô ꞌdĩ drí kpá tã-drı̣̃ lôgõzó ꞌwãâ gólĩyî drí kĩ, “ꞌDĩî úlı̣́ ángô rî ĩꞌdî ãnî drí rĩꞌá âtálé ĩtí ꞌdĩ yã? Nĩ kĩ, yĩ ũnı̣̃ı̣́ võ gólâ drí ânĩzó ꞌálâ sĩ rî kô! Nĩ ı̣̂sũ tã mbârâkã gólâkâ tãsĩ. Útı̣̂ mâ rĩꞌá lı̣̃fı̣́ ãkó, gõꞌdá ngbãângbânõ rî, gólâ njı̣̃ ámâ lı̣̃fı̣́ nĩ má drí rĩzó võ ndrẽlé dódó nõ! ");
INSERT INTO avu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","33","Ĩtí ạ̃kû lâ sĩ tã ómvó ngá ꞌásĩ rî, nĩ ârî tã ãzâ trá kĩ, õjílã mvá ãzâ bê êdê õjílã gólĩyî tı̣̃lı̣́ lı̣̃fı̣́ ãkó rî ꞌbá yî trá, gõꞌdá lı̣̃fı̣́ lâ yî drí rû njı̣̃zó võ ndrẽlé dódó yã? Õzõ mbârâkã Yésũ drí ámâ lı̣̃fı̣́ êdézó nõ ãꞌdô Ôvârí kâ kô rî, gólâ îcá tã lârâkô ĩtí ꞌdĩ ꞌẽlé kô, tãlâ Ôvârí fẽé mbârâkã íyíkâ kô õjílã gólĩyî rĩ ꞌbá tã õnjí ꞌẽlé rî ꞌbá yî drí, gólâ rî cé tã õjílã gólĩyî rĩ ꞌbá tã gólâkâ ꞌẽlé rî kâ ârílí ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Gõꞌdá Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî ârî ĩyî tã ãgô ꞌdĩ drí lôgõlé ĩyî drí ꞌdĩ bê rî, drílĩyî âꞌdózó ạ̃wạ̃ ró rõô. Gõꞌdá drílĩyî tã âtázó ãgô ꞌdĩ drí kĩ, “Útı̣̂ nî lı̣̃fı̣́ ãkó ꞌdĩ ákĩ fí tã õnjí áníkâ drí sĩ kô yã? Ãmâ gólĩyî tã Ôvârí kâ nı̣̃ ꞌbá trá tãndí ró rî, ní âꞌdô ãmâ îmbáꞌá tã Ôvârí kâ sĩ ángô tí yã?” Gõꞌdá drílĩyî ãgô ꞌdĩ drõzó vólé ĩyî lãfálé sĩ. ");
INSERT INTO avu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gõꞌdá Yésũ ârílí bê kĩ, Pạ̃rúsı̣̃ yî drô ãgô yí drí lı̣̃fı̣́ lâ njı̣̃lı̣́ ꞌdĩ trá rî, gólâ drí ꞌdẽzó rĩꞌá ãgô ꞌdĩ lôndãlé. Gõꞌdá gólâ ûsúlı̣́ bê ãgô ꞌdĩ rî, gólâ drí ãgô rî ꞌdĩ îjízó kĩ “Pạ̃tı̣́ı̣̃, ní lẽ tã fí trá ꞌdíyî pã ꞌbá Ôvârí drí âjólé ûrú lésĩ rî ꞌá yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ãgô ꞌdĩ drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ãmbá, ní âꞌdâ drẽ ꞌdíyî pã ꞌbá rî gógó ꞌdĩ má drí, tãlâ má lẽ ró tã bê gólâ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nĩngá sĩ, Yésũ drí gõzó tã-drı̣̃ lôgõlé gólâ drí kĩ, “Ní ndrê gólâ trá ánî lı̣̃fı̣́ sĩ. Gólâ rî gógó ĩꞌdî rĩ ꞌbá tã âtálé ní bê ngbãângbânõ rî.” ");
INSERT INTO avu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Gõꞌdá ãgô ꞌdĩ ârílí bê tã Yésũ kâ âtálé ꞌdĩ rî, gólâ drí ꞌãꞌî tı̣̃zó vũdrı̣́ Yésũ rî ı̣̂njı̣̃lı̣́. Gõꞌdá drílâ tã âtázó kĩ, “Kúmú, má nı̣̃ trá kĩ, nî ĩꞌdî ꞌdíyî pã ꞌbá Ôvârí drí âjólé trá rî. Ngbãângbânõ rî, má lẽ tã trá ní ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tã ꞌdî ꞌbá yî vósĩ rî, Yésũ drí ngãzó tã âtálé ãgô yí drí lı̣̃fı̣́ lâ njı̣̃lı̣́ trá ꞌdĩ drí kĩ, “Má ânĩ ãngó nõ ꞌá nõ, tãlâ õjílã gólĩyî lı̣̃fı̣́ ãkó tã Ôvârí kâ nı̣̃ ꞌbá drẽ kô rî ꞌbá yî lı̣̃fı̣́ lâ yî ũnjı̣̃ ró rû bê tã Ôvârí kâ nı̣̃lı̣́, gõꞌdá gólĩyî kĩ ꞌbá nĩ, yĩ ũnı̣̃ tã Ôvârí kâ trá dódó rî, lı̣̃fı̣́ lâ yî drí ậsı̣̃zó kpạ̃ạ́kũ. ꞌDĩî tã ífí gólâ má drí ânĩzó ãngó nõ ꞌá rî ĩꞌdî ꞌdĩ.” ");
INSERT INTO avu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Gõꞌdá Yésũ õtírĩ rĩî úlı̣́ ꞌdĩ ꞌbá yî âtálé rî, Pạ̃rúsı̣̃ ãzâ ꞌbá yî kpá bê âdréꞌá tólâ. Gõꞌdá drílĩyî tã îjízó Yésũ tı̣́ kĩ, “Úlı̣́ gólâ ní drí âtálé ꞌdĩ ꞌbá yî ꞌásĩ rî, ní ı̣̂sũ áníkâ bê rî, ãmâ kpá lı̣̃fı̣́ ãkó yã?” ");
INSERT INTO avu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Tí õzõ nĩ õró tã-drı̣̃ lẽê nõ kĩ, nĩ âꞌdô lı̣̃fı̣́ ãkó rî, nĩ âꞌdô ânĩꞌá Ôvârí ngálâ, gõꞌdá gólâ âꞌdô ãnî âyéꞌá tã õnjí ãníkâ ꞌásĩ ndrĩ. Gõꞌdá nĩ âtálé bê trá kĩ, yĩ âꞌdô cú lı̣̃fı̣́ bê võ ndrẽzó rî, nĩ âdô ꞌdĩ ãnî nyãányâ ꞌî. Gõꞌdá Ôvârí âꞌdô lâŋõ fẽꞌá ãnî drí tã õnjí ãníkâ tãsĩ.” ");
INSERT INTO avu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Gõꞌdá nĩngá sĩ, Yésũ drí ngãzó úlı̣́ mãnĩgõ âtálé Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ, “Má âtâ ãnî drí tã pạ̃tı̣́-pạ̃tı̣̃ ró, õjílã gólâ fĩ ꞌbá kô jó tı̣́lı̣́-tı̣̂ kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá kâ rî ꞌásĩ, gõꞌdá mbã ꞌbá íyíkâ ãbẽ drı̣̃ ꞌásĩ fĩlí jó ꞌálâ rî, gólâ rĩꞌá ũgú ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gõꞌdá õjílã gólâ ânĩ ꞌbá fĩlí jó ꞌálâ kôrô jó tı̣́lı̣́-tı̣̂ ꞌásĩ rî, rĩꞌá kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá ꞌî. ");
INSERT INTO avu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kạ́bı̣̃lı̣́kı̣̃ lı̣́pı̣̂ ꞌdĩ âꞌdô ânĩꞌá âcálé ạ́tı̣̃ tı̣́. Ĩtí rî, kõró tı̣̂ vó ndrẽ ꞌbá ꞌdĩ âꞌdô ạ́tı̣̃ njı̣̃ꞌá drílâ. Gõꞌdá gólâ âꞌdô kạ́bı̣̃lı̣́kı̣̃ íyíkâ ꞌdĩ ꞌbá yî zı̣̃ꞌá rú sĩ ãlô-ãlô. Gõꞌdá kạ́bı̣̃lı̣́kı̣̃ gólâkâ ꞌdĩ ꞌbá yî ndrĩ âꞌdô gólâ rî gbórókõ nı̣̃ꞌá, gõꞌdá drílĩyî ânĩzó gólâ ngálâ, drílâ gólĩyî lôfõzó ĩví ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Gólâ âꞌdéꞌá sı̣́sı̣́, gõꞌdá kạ́bı̣̃lı̣́kı̣̃ gólâkâ ꞌdĩ ꞌbá yî drí ꞌdẽzó gólâ vósĩ. Ĩtí rî, kạ́bı̣̃lı̣́kı̣̃ ꞌdî ꞌbá yî âꞌdô ĩyî ꞌdẽꞌá ndrĩ nĩlí vó lâ sĩ ũrı̣̃ ãkó, tãlâ gólĩyî nı̣̃ gólâ rî gbórókõ trá tãndí ró. Gólâ âꞌdô gólĩyî drı̣̃ꞌá nĩꞌá âjílâ võ õmã bê rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gõꞌdá õzõ ãꞌdô õjílã lídí ꞌî rî, kạ́bı̣̃lı̣́kı̣̃ ꞌdî ꞌbá yî âꞌdô ꞌbãꞌá ĩyî ũrı̣̃ ró ꞌdẽlé vó lâ sĩ, gólĩyî âꞌdô lâráꞌá vólé, tãlâ gólĩyî nı̣̃ı̣́ gólâ rî gbórókõ kô.” ");
INSERT INTO avu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ĩtí rî, Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, tã ífí lâ fí gólĩyî drı̣̃ı̣̂ kô, tãlâ gólâ âtâ úlı̣́ ꞌdĩ ꞌbá yî úlı̣́ mãnĩgõ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Gõꞌdá Yésũ drí kpá tã âtázó óꞌdí Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí kĩ, “Má âtâ tã pạ̃tı̣́ı̣̃ ró ãnî drí kĩ, mâ ĩꞌdî rĩ ꞌbá õjílã ámákâ rî ꞌbá yî vó lâ yî ndrẽlé dódó õzõ kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá drí rĩrĩ kạ́bı̣̃lı̣́kı̣̃ íyíkâ vó lâ yî ndrẽlé rî kâtí. Gõꞌdá mâ rî gógó ĩꞌdî ạ́tı̣̃ jó tı̣́lı̣́-tı̣̂ kâ ĩꞌdî gólĩyî drí ndrĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","“Gõꞌdá õjílã ãzâ ꞌbá yî ânĩ ꞌbá sı̣́sı̣́ má drí sĩ rî ꞌbá yî ꞌbã ĩyî nyãányâ trá âꞌdólé kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá ró, tákõ gõꞌdá gólĩyî rĩꞌá ũgú ꞌî. Tã ꞌdî tãsĩ rî, kạ́bı̣̃lı̣́kı̣̃ gã dó gólĩyî gbórókõ ârílí ꞌdẽzó gólĩyî vósĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ĩtí rî, mâ ĩꞌdî rĩꞌá ạ́tı̣̃ tı̣̂ ꞌî kạ́bı̣̃lı̣́kı̣̃ drí. Kạ́bı̣̃lı̣́kı̣̃ gólĩyî fĩ ꞌbá jó ꞌálâ kôrô má sĩ rî âꞌdô ĩyî ngá pãꞌá. Má âꞌdô gólĩyî vó ndrẽꞌá, ngá õnjí ꞌé gólĩyî kô. Õzõ gólĩyî õtírĩ ĩyî ꞌẽê âfõlé nĩꞌá õmã nyãlé rî, gõꞌdá drílĩyî âgõzó fĩlí jó ꞌálâ lâŋõ ãzâ ãkó. ");
INSERT INTO avu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ũgú ânĩ ĩyíkâ cé kạ́bı̣̃lı̣́kı̣̃ ûgũlı̣́, gõꞌdá kpá gólĩyî ûfúlı̣́ vólé. Gõꞌdá mâ rî gógó, má ânĩ nõ, tãlâ kạ́bı̣̃lı̣́kı̣̃ ámákâ rî ꞌbá yî ũûsû ró ngá pãpã bê, ngá pãpã gólâ ꞌẽ ꞌbá gólĩyî ꞌbãlé rĩlí zãâ lédrẽ-lédrẽ ró ãyĩkõ sĩ mbârâkã Ôvârí kâ sĩ rî. ");
INSERT INTO avu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mâ ĩꞌdî rĩꞌá “‘Kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá tãndí”’ rĩ ꞌbá vó kạ́bı̣̃lı̣́kı̣̃ íyíkâ vó lâ yî ndrẽlé dódó rî ĩꞌdî. Mâ rĩꞌá njãâ ámâ nyãányâ fẽlé drãlé gólĩyî pãlé tã õnjí ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Õjílã gólâ rĩ ꞌbá kạ́bı̣̃lı̣́kı̣̃ vó ndrẽlé cé lãfâ tãsĩ rî ndré kạ́bı̣̃lı̣́kı̣̃ vó dódó kô, tãlâ gólâ âꞌdó kô kạ́bı̣̃lı̣́kı̣̃ ꞌdî ꞌbá yî lı̣́pı̣̂ lâ ꞌî. Õzõ gólâ õndrê kíâkêlówá trá ânĩrĩ ꞌá kạ́bı̣̃lı̣́kı̣̃ rũlı̣́ rî, gólâ âꞌdô rãꞌá kạ́bı̣̃lı̣́kı̣̃ ꞌdî ꞌbá yî âyélé kíâkêlówá ꞌdĩ drí rũlı̣́, gõꞌdá kpá gólĩyî lâpẽlé lậꞌbúlı̣́ fãã. ");
INSERT INTO avu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kạ́bı̣̃lı̣́kı̣̃ vó ndrẽ ꞌbá ꞌdĩ râ kạ́bı̣̃lı̣́kı̣̃ ꞌdî ꞌbá yî âyélé, tãlâ gólâ ꞌê lôsĩ ꞌdî cé lãfâ ûsúzó. Tí õzõ kạ́bı̣̃lı̣́kı̣̃ vó ndrẽ ꞌbá ꞌdĩ õró ꞌbãâ ngá lẽlẽ bê kạ́bı̣̃lı̣́kı̣̃ ꞌdî ꞌbá yî vó lâ yî ndrẽndrẽ tãsĩ rî, gólâ îcá rãlé gólĩyî âyélé kô. ");
INSERT INTO avu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Mâ rî gógó ĩꞌdî “‘Kạ́bı̣̃lı̣́kı̣̃ lôkí ꞌbá tãndí”’ rĩ ꞌbá kạ́bı̣̃lı̣́kı̣̃ ámákâ rî ꞌbá yî vó lâ yî ndrẽlé dódó rî ĩꞌdî. Ãmâ rĩꞌá ámâ átá bê ngá ãlô ꞌî. Má nı̣̃ gólâ trá tãndí ró, gõꞌdá gólâ nı̣̃ mâ kpá trá tãndí ró. Kpá ĩtí, kạ́bı̣̃lı̣́kı̣̃ ámákâ rî ꞌbá yî nı̣̃ ĩyî mâ trá dódó, kpá õzõ má drí gólĩyî nı̣̃rı̣̃ dódó rî kâtí. Mâ rĩꞌá njãâ drãlé gólĩyî pãlé tã õnjí ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kạ́bı̣̃lı̣́kı̣̃ ãzâ ꞌbá yî kpá bê. Má âꞌdô gólĩyî ꞌbãꞌá âꞌdólé kạ́bı̣̃lı̣́kı̣̃ ámákâ ró. Ngbãângbânõ gólĩyî rí kô võ ãlô ꞌá kạ́bı̣̃lı̣́kı̣̃ ámákâ nõ ꞌbá yí bê. Gõꞌdá má âꞌdô gólĩyî ậzı̣́ꞌá kpá ânĩlí má ngálâ, tãlâ gólĩyî õrî ró ĩyî bê ngá ãlô ró kạ́bı̣̃lı̣́kı̣̃ ámákâ nõ ꞌbá yí bê. Gólĩyî âꞌdô ámâ gbórókõ nı̣̃ꞌá. Gõꞌdá má âꞌdô gólĩyî êꞌbéꞌá ndrĩ võ ãlô ꞌá âꞌdólé kạ́bı̣̃lı̣́kı̣̃ ámâ nyãányâ kâ ró. Mâ lôkí ꞌbá gólĩyíkâ ĩꞌdî ndrĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Má âꞌdô ámâ nyãányâ fẽꞌá drãlé. Õzõ má õdrã trá rî, má âꞌdô lîdríꞌá kpá óꞌdí õdrã rî ꞌdĩ ꞌásĩ, tãlâ õjílã ámákâ rî ꞌbá yî pãlé. ꞌDĩî tã ámâ átá drí ꞌbãlé má drí ꞌẽlé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Õjílã ãzâ yû ꞌẽ ꞌbá ámâ fũlı̣́ cú ĩtí mbârâkã íyíkâ sĩ. Má âꞌdô ámâ nyãányâ fẽꞌá nĩ drãlé. Mâ kpá rĩꞌá mbârâkã bê lîdrízó õdrã rî ꞌdĩ ꞌásĩ. Tãlâ ꞌdĩî rĩꞌá tã gólâ ámâ átá Ôvârí drí ꞌbãlé má drí ꞌẽlé rî ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ âtálé ꞌdĩ rî, gólĩyî lẽé ĩyî tã-drı̣̃ kô ĩyî lãfálé ꞌásĩ úlı̣́ Yésũ kâ âtálé ꞌdĩ ꞌbá yî tãsĩ, gõꞌdá drílĩyî lãfálé cãzó. ");
INSERT INTO avu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Õjílã dũû gólĩyî lãfálé sĩ kĩ, “Yésũ ãꞌdô cú líndrí õnjí bê yí ꞌá rĩꞌá gólâ rî ꞌbãlé âꞌdólé lîfõ-lîfõ ró. Tãlâ ãꞌdô ꞌî ãnî drí rĩzó tã gólâkâ ârílí yã?” ");
INSERT INTO avu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gõꞌdá õjílã ãzâ ꞌbá yî gólĩyî lãfálé sĩ kĩ ĩyíkâ rî, “Õjílã gólâ líndrí õnjí bê rî îcá kô úlı̣́ âtálé ĩtí. Líndrí õnjí âꞌdô mbârâkã ûsúꞌá õjílã gólĩyî lı̣̃fı̣́ lâ yî drí võ ndrẽlé kô rî ꞌbá yî lı̣̃fı̣́ lâ yî njı̣̃zó ãꞌdô ꞌásĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tã ꞌdî ꞌbá yî vósĩ ndrĩ, kậyı̣̂ Yúdạ̃ yí kâ kãrámã jó ạ́ngı̣́ Ôvârí kâ ꞌbã kâ âꞌdólé cé Ôvârí drí rĩꞌá ꞌẽlâ ndrô vósĩ cé võ ạ̃ꞌdı̣́ sĩ Yẽrõsãlémã ꞌálâ rî drí âcázó. Gõꞌdá ĩtí rî, Yúdạ̃ yî drí ngãzó nĩlí ndrĩ kãrámã rî ꞌdĩ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kãrámã nã ꞌá tólâ rî, kậyı̣̂ ãzâ sĩ, Yésũ drí ngãzó nĩlí lậvũlı̣́ ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌdĩ ꞌásĩ, nĩꞌá gõlé jó-bı̣́lı̣́ Sólõmõ kâ rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Gõꞌdá Yésũ drí rĩrĩ lậvũlı̣́ rî ꞌá rî, drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ drí ânĩzó gólâ rî êdrẽlé gõꞌdá âdrézó ĩyî rú lâ sĩ dîrî. Nĩngá sĩ, drílĩyî gólâ rî îjízó ạ̃wạ̃ sĩ kĩ, “Ní âꞌdô kó ãmâ drı̣̃ ꞌbãꞌá rĩꞌá lîjãlé nõtí nõ bũúũ ángô tú yã? Ní âtâ drẽ ãmâ drí hậ, õzõ ní ãꞌdô pạ̃tı̣́ı̣̃ ꞌdíyî pã ꞌbá tíbê Ôvârí drí âjólé rî ĩꞌdî rî.” ");
INSERT INTO avu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Gõꞌdá nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó gólĩyî drí kĩ nĩ rî, “Má âtâ tã ꞌdî trá ãnî drí ạ̃kû ró kĩ, mâ ꞌdíyî pã ꞌbá tíbê Ôvârí drí âjólé rî ĩꞌdî, gõꞌdá nĩ gâ vólé dó úlı̣́ ámákâ âtálé ꞌdĩ ârílí, gbõ lé nĩ ndrê bê tã lârâkô gólâ má drí ꞌẽlé trá ngá lãzé ꞌbá îngázó mbârâkã Ôvârí kâ sĩ rî ꞌbá yî rî. Gõꞌdá tã lârâkô ꞌdĩ ꞌbá yî rî tã âꞌdálé kĩ, mâ ĩꞌdî pạ̃tı̣́ı̣̃ õjílã gólâ má drí tã lâ âtálé trá ãnî drí rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gõꞌdá nĩ gâ vólé dó tã lẽlé má ꞌá, tãlâ nĩ âꞌdó kô kạ́bı̣̃lı̣́kı̣̃ ámákâ ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kạ́bı̣̃lı̣́kı̣̃ ámákâ rî ꞌbá yî rî ĩyíkâ zãâ kárá tã îmbâ ámákâ rî ꞌbá yî ârílí ꞌẽlé tãndí ró, gõꞌdá mâ rî gógó, má nı̣̃ gólĩyî trá ãlô-ãlô kạ́bı̣̃lı̣́kı̣̃ ámákâ ró, gõꞌdá gólĩyî rî ꞌdẽlé má vó pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ tã ârí ꞌbá ámákâ ró. ");
INSERT INTO avu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mâ rî gógó, má âꞌdô gólĩyî ꞌbãꞌá rĩlí zãâ gbạ́dú ạ̃dũkũ ãkó. Gõꞌdá gólĩyî ôdrãá kô zãâ gbạ́dú. Gõꞌdá ĩtí rî, õjílã ãzâ îcá kô gólĩyî ôpálé má drı̣́gạ́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mĩ ndrê drẽ, ámâ átá Ôvârí âfẽ gólĩyî nĩ má drí, gõꞌdá mbârâkã gólâkâ lậvũ trá gạ̃rạ̃ ngá ãngó nõ kâ rî ꞌbá yî drı̣̃ı̣̂ sĩ ndrĩ. Tã ꞌdî tãsĩ rî, õjílã ãzâ îcá kô gólĩyî ôpálé ámâ átá drı̣́gạ́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mĩ ndrê drẽ, ãmâ ámâ átá bê rĩꞌá ngá ãlô ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Gõꞌdá Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ kâ ꞌdĩ rî, drílĩyî ngãzó ạ̃wạ̃ ró rõô gõꞌdá kúnı̣́ mvá ûꞌdúlı̣́ ĩyî drı̣́gạ́, tíkó yĩ ũlûvũ ró Yésũ ĩꞌdî sĩ lâ drãlé vólé. ");
INSERT INTO avu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nĩngá sĩ, Yésũ drí gõzó ngãlé tã âtálé gólĩyî drí kĩ, “Ãnî ndrĩ, nĩ ndrê õjílã gólĩyî ngá lãzé bê má drí rĩꞌá îngálâ ngá lãzé ꞌásĩ mbârâkã ámâ átá Ôvârí kâ sĩ rî ꞌbá yî trá ãnî lı̣̃fı̣́ sĩ tãndí ró. Gõꞌdá tã gólâ sũ ꞌbá ãnî rú kô, ãnî drí ꞌẽzó ámâ lûvũlı̣́ kúnı̣́ mvá sĩ fũlı̣́ vólé nõ íyíkâ ángô rî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Gõꞌdá Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Mã ꞌê ánî fũlı̣́ nõ, âꞌdó kô tã tãndí áníkâ ꞌẽlé ꞌdĩ tãsĩ. Mã ꞌê ánî fũlı̣́ nõ, tãlâ úlı̣́ ꞌdásí áníkâ âꞌbãlé Ôvârí rî gógó rú kĩꞌá nĩ rî, yĩ ãâꞌdô ãlô Ôvârí bê nõ tãsĩ. Nî õjílã mvá tãkó nõ ĩꞌdî, ní âꞌdô áníkâ ánî lômbéꞌá ꞌbãlé ãlô Ôvârí bê ꞌdĩ ángô tí yã?” ");
INSERT INTO avu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Gõꞌdá Yésũ drí kpá tã-drı̣̃ lôgõzó gólĩyî drí kĩ, “Ngã gõꞌdá úlı̣́ Ôvârí drí âtálé îgĩlí búkũ gólâkâ ꞌá rî kĩ ãꞌdô yã? Gólâ âtâ tã trá kĩ, tã kĩ ꞌbá yî drí ꞌbãlé õjílã íyíkâ drı̣̃lı̣́ rî ꞌbá yî rĩꞌá õzõ yî Ôvârí tí. ");
INSERT INTO avu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mã nı̣̃ trá kĩ nĩ rî, úlı̣́ gólâ Ôvârí drí rĩꞌá âtálâ rî rĩꞌá pạ̃tı̣́-pạ̃tı̣̃ ró zãâ gbạ́dú. Gõꞌdá ĩtí rî, Ôvârí zı̣̂ tã kĩ ꞌbá rî ꞌdĩ ꞌbá yî ôvârí yî ró. ꞌDĩî õjílã gólĩyî tã âtî-âtî gólâkâ âfẽzó trá drílĩyî rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gõꞌdá õzõ má tí rî, ámâ átá âjô mâ trá ãngó nõ ꞌá. Bê trá ĩtí rî, nĩ îcâ tã âtálé kĩ, má ãâꞌbã tã ꞌî, tãlâ má ãâtâ tã trá kĩ, má ãâꞌdô Ôvârí rî mvá ꞌî rî ángô tí ró yã? ");
INSERT INTO avu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nĩ ârî drẽ úlı̣́ nõ, tí õzõ tã lârâkô ndrĩ má drí rĩꞌá ꞌẽlâ nõ ꞌbá yî, má õꞌê mbârâkã ámâ átá kâ sĩ kô rî, nĩ lẽ tã má ꞌá kô. ");
INSERT INTO avu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Õzõ gõꞌdá má õrî fí tã lârâkô ꞌdĩ ꞌẽlé ndrĩ mbârâkã ámâ átá kâ sĩ rî, ꞌdõvó nĩ lẽ tã má ꞌá, tãlâ tã lârâkô ndrĩ má drí rĩꞌá ꞌẽlâ ꞌdĩ ꞌbá yî rĩꞌá Ôvârí kâ ĩꞌdî, gólâ fẽ mbârâkã lâ nĩ ꞌẽzó lâ, gõꞌdá ãmâ gólâ bê ngá ãlô ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gõꞌdá Yésũ rî ạ̃jú-ꞌbá-ãzí ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Yésũ drí âtálé ꞌdĩ rî, gólĩyî drí kpá ngãzó ĩyî, tãlâ úũrû ró Yésũ bê fũlı̣́, gõꞌdá Yésũ drí íyîngá ꞌbẽzó gólĩyî drı̣́gạ́ sĩ dı̣̃ íyîngá nĩlí vólé. ");
INSERT INTO avu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nĩngá sĩ, Yésũ drí ngãzó Yẽrõsãlémã rî âyélé nĩzó áyágá zı̣̃lı̣́ Jõrõdénĩ rî mbãlé, nĩzó lậvũlı̣́ rĩlí võ sı̣́sı̣́ Yõwánĩ bãbãtízĩ ꞌẽ ꞌbá ró rî drí rĩzó tã Ôvârí kâ pẽlé gõꞌdá kpá õjílã gólĩyî tã lẽ ꞌbá trá rî îbábátízãlé rî ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gõꞌdá Yésũ ãꞌdô bê tólâ rî, õjílã dũû drí rĩzó ânĩlí tã îmbâ gólâkâ ꞌdĩ ârílí. Gõꞌdá õjílã ꞌdî ꞌbá yî ârî ĩyî bê tã îmbâ gólâkâ ꞌdĩ, gõꞌdá ndrê ĩyî bê kpá tã lârâkô gólâkâ rĩꞌá ꞌẽlâ ꞌdĩ ꞌbá yî rî, drílĩyî tã âtázó kĩ, “Pạ̃tı̣́ı̣̃, ãgô nõ rĩꞌá ꞌdíyî pã ꞌbá Yõwánĩ drí tã lâ îmbálé trá ãmâ drí kĩꞌá nĩ rî, ãâꞌdô âcáꞌá Ôvârí ngá lésĩ rî ĩꞌdî, tãlâ ãmâ rĩꞌá tã lârâkô gólâ drí rĩꞌá ꞌẽlâ rî ndrẽꞌá. Gbõ lé Yõwánĩ ꞌé bê tã lârâkô ãmâ drí ndrẽlé kô rî, úlı̣́ Yõwánĩ kâ âtálé Yésũ rî tãsĩ rî rĩꞌá ndrĩ pạ̃tı̣́ı̣̃ ró.” ");
INSERT INTO avu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Gõꞌdá tã ꞌdî kâ rî tí rî, õjílã dũû võ ꞌdî ꞌá ꞌdĩ drí ĩyî tã lẽzó Yésũ ꞌá kĩ, pạ̃tı̣́ı̣̃ Yésũ rĩꞌá ꞌdíyî pã ꞌbá gólâ Ôvârí drí âjólé rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ãgô ãzâ bê rú lâ Lázãrõ, gólâ rĩꞌá îzó bê zãlô rı̣̃, rú lâ yî rĩꞌá Mãríyã gõꞌdá ãzâ rî rú lâ íyíkâ Márãtã. Gólĩyî nı̣̃ ĩyî rû trá Yésũ yí bê tãndí ró. ꞌBã gólĩyíkâ jạ̃rı̣́bạ̃ zı̣̃lı̣́ Bẽtánĩ rî ꞌálâ. Gõꞌdá Mãríyã rî Lázãrõ rî îzó ró ꞌdĩ âꞌdô dõ lâgî-lâgî lâ drí lậvũlı̣́ gạ̃rạ̃ rî dãꞌá kpá nĩ Yésũ rî pá drı̣̃ı̣̂ ı̣̃zạ́tú. Gõꞌdá kậyı̣̂ ãzâ sĩ rî, Lázãrõ drí ꞌdẽzó ngá lãzé bê Yésũ vólé sĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gõꞌdá nĩngá sĩ, Lázãrõ rî îzó yî ndrélé bê ngá lãzé Lázãrõ kâ ꞌdĩ lậnjı̣̃-lậnjı̣̃ ró kĩ, gólâ ĩîcá kô ngá pãlé ꞌálâ sĩ rî, drílĩyî ngãzó võrã jõlé Yésũ drí kĩ, “Kúmú, ánî rû-lẽ-ãzí tãndí Lázãrõ trá ngá lãzé bê lậnjı̣̃-lậnjı̣̃ ró ãnyî ꞌẽꞌá drãlé.” ");
INSERT INTO avu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Gõꞌdá Yésũ ârílí bê ngá lãzé Lázãrõ kâ ꞌdĩ tã lâ rî, gólâ drí tã âtázó lãjóꞌbá íyíkâ drí kĩ, “Ngá lãzé Lázãrõ kâ ꞌdĩ íyíkâ fí lậnjı̣̃-lậnjı̣̃ ró rî, gõꞌdá gólâ îcá drãlé trõlé ꞌbãlé ꞌbú ꞌá zãâ kô, tãlâ ngá lãzé gólâkâ ꞌdĩ âꞌdô ĩtí ꞌdĩ, ãꞌdô ró bê mbârâkã Ôvârí kâ âꞌdázó, gõꞌdá kpá nı̣̃zó lâ kĩ, pạ̃tı̣́ı̣̃ Ôvârí âjô mâ nĩ mbârâkã íyíkâ ꞌdĩ bê.” ");
INSERT INTO avu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tã pạ̃tı̣́ı̣̃ ró, Yésũ lẽ Lázãrõ trá rõô îzó lâ yí bê. ");
INSERT INTO avu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Gbõ lé Yésũ ârî tã bê kĩ, ngá lãzé Lázãrõ kâ lậnjı̣̃-lậnjı̣̃ ró, gõꞌdá gólâ õpá ngá ꞌá lâ sĩ kô ꞌdĩ tã lâ rî, gólâ ngá kôrô nĩlí Lázãrõ rî ndrẽlé kô. Võ ꞌdî ꞌá rî, gólâ ꞌê kậyı̣̂ zãlô rı̣̃ võrã ꞌdî ârî-ârî lâ vólé drı̣̃ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ꞌDĩî vósĩ rî, Yésũ drí tã âtázó lãjóꞌbá íyíkâ drí kĩ, “Mã nĩ gõlé kpá vólé Yũdạ́yạ̃ ꞌálâ, tãlâ mã nĩ ró bê Bẽtánĩ ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Gõꞌdá lãjóꞌbá gólâkâ drí tã-drı̣̃ lôgõzó gólâ drí kĩ, “Tã îmbá ꞌbá, ậndrạ́tú drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ rî ꞌbá yî ꞌê ĩyî kpá ánî fũlı̣́ tólâ kô yã? Gólĩyî â ꞌbãꞌá nõ zãâ rĩꞌá lạ́tı̣̂ lôndãꞌá ꞌẽzó ánî fũlı̣́. Gõꞌdá ní lẽ nô kpá ãmâ drí gõzó tólâ óꞌdí yã?” ");
INSERT INTO avu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Gõꞌdá nĩngá sĩ, Yésũ drí ngãzó úlı̣́ âtálé gólĩyî drí tãlâ ũrı̣̃ gólĩyíkâ ꞌdĩ tãsĩ kĩ, “Nĩ ꞌê ũrı̣̃ kô, Ôvârí âꞌdô ámâ vó ndrẽꞌá bũúũ má drí lôsĩ gólâkâ ndẽzó. Kậyı̣̂ bê drẽ rĩꞌá ãmbá, má âꞌdó kô ũrı̣̃ ró tã gólĩyî drí ꞌẽzó ámâ fũlı̣́ ꞌdĩ ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gõꞌdá Yésũ âtâ bê úlı̣́ ꞌdĩ ĩtí rî, gólâ drí kpá tã yí drí lẽlé ꞌẽꞌá ꞌẽlâ Yũdạ́yạ̃ ꞌálâ rî âtázó kĩ, “Ámâ rû-lẽ-ãzíyã Lázãrõ bê rĩꞌá ậꞌdú kõꞌá Bẽtánĩ ꞌá tólâ, mã nĩ, gõꞌdá má nĩ ró bê gólâ rî ôlólé ậꞌdú ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî drí tã-drı̣̃ lôgõzó gólâ drí kĩ, “Kúmú, õzõ Lázãrõ ãâꞌdô ậꞌdú kõꞌá rî, rĩꞌá tãndí ró, gólâ âꞌdô lı̣̃fı̣́ njı̣̃ꞌá trá ậꞌdú rî ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Gõꞌdá nĩngá sĩ, tákõ tã Yésũ kâ âtálé lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî drí kĩꞌá nĩ rî, Lázãrõ ãâꞌdô ậꞌdú kõꞌá nõ rî, íyîngá rĩꞌá úlı̣́ mãnĩgõ ꞌî, gólâ nı̣̃ trá tãndí ró kĩ, Lázãrõ drã trá. Gõꞌdá lãjóꞌbá gólâkâ ꞌdĩ ꞌbá yî nı̣̃ı̣́ ĩyíkâ úlı̣́ mãnĩgõ gólâkâ âtálé ꞌdĩ ífí lâ kô, gólĩyî ı̣̂sũ ĩyíkâ rî kĩ, tã pạ̃tı̣́-pạ̃tı̣̃ ró, Lázãrõ ãâꞌdô ậꞌdú tãkó rî kõꞌá ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gõꞌdá Yésũ drí tã yí drí âtálé ꞌdĩ ífí lâ lôfõzó gólĩyî drí trậ, tãlâ gólĩyî ũnı̣̃ ró ĩyî ífí lâ bê. Ĩtí rî, gólâ kĩ, “Lázãrõ drã trá! ");
INSERT INTO avu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Gõꞌdá mâ rĩꞌá ãyĩkõ ró, tãlâ Lázãrõ drã trá má vólé sĩ, ꞌdĩî trá rĩꞌá tãndí ró, tãlâ nĩ lẽ ró tã bê má ꞌá pạ̃tı̣́-pạ̃tı̣̃ ró. Bê trá ĩtí rî, ꞌdõvó nĩ ânĩ mã nĩ ró bê ãwó võ ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Gõꞌdá nĩngá sĩ, lãjóꞌbá Yésũ kâ rú bê Tómã rî drí ngãzó tã âtálé íyî ãzí-ãzí yî drí kĩ, “Ãꞌdô trá ĩtí rî, ꞌdõvó mã nĩ gólĩyí bê ãwó ꞌdĩ võ lâ ꞌá, tãlâ õzõ óõlẽ gólâ rî fũlı̣́ rî, ógõ ró bê ãmâ ûfúlı̣́ ndrĩ gólĩyí bê.” Gõꞌdá ĩtí rî, Yésũ yî drí ngãzó nĩlí Bẽtánĩ ꞌálâ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê ndrĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Gõꞌdá Yésũ yî ngâ bê nĩlí lãjóꞌbá íyíkâ yí bê rî, gõꞌdá cãlé ãnyî jạ̃rı̣́bạ̃ Bẽtánĩ kâ ꞌdĩ rú rî, drílĩyî rû ûsúzó õjílã ãzâ ꞌbá yí bê. Gõꞌdá õjílã rî ꞌdĩ ꞌbá yî drí tã âtázó gólĩyî drí kĩ nĩ rî, yĩ õꞌbã Lázãrõ trá ꞌbú ꞌá, ꞌdĩî gólâ ꞌê trá kậyı̣̂ sû ꞌbú ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ĩtí rî, õjílã Yúdạ̃ yí kâ ãzâ ꞌbá yî dũû ânĩ ĩyî kpá trá nĩꞌá ãwó ngõlé Márãtã yî ngálâ Mãríyã bê gõꞌdá kpá tã tãndí lôgõlé gólĩyî drı̣̃ı̣̂, tãlâ ĩzã õzó gólĩyî ꞌẽê rõô kô. ");
INSERT INTO avu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Gõꞌdá Márãtã ârî tã bê kĩꞌá nĩ rî, Yésũ ãâꞌdô trá ânĩꞌá, gõꞌdá gólâ ãâcâ trá ãnyî rî, Márãtã drí ngãzó rãlé nĩꞌá Yésũ rî drı̣̃ tẽlé lạ́tı̣̂ ꞌálâ. Gõꞌdá Mãríyã drí íyíkâ rĩzó ãkpã ãwó jó ꞌá tólâ. ");
INSERT INTO avu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Gõꞌdá nĩngá sĩ, Márãtã ndrê Yésũ bê rî, gólâ drí tã âtázó Yésũ drí kĩ nĩ rî, “Óõ kúmú, tíkó ní õró ꞌbãâ nõngá rî, ãmâ lônyí nõ drãá kô, tí ní îngâ gólâ nõ trá ngá lãzé gólâ rî fũ ꞌbá trá nõ ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gõꞌdá má nı̣̃ trá kĩ, Ôvârí âꞌdô tã ndrĩ ní drí îjílí gólâ tı̣́ rî ꞌẽꞌá, Lázãrõ õdrã gbõ lé rî.” ");
INSERT INTO avu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Gõꞌdá nĩngá sĩ, Yésũ drí tã âtázó Márãtã drí kĩ, “Márãtã ámâ îzó, ánî lônyí âꞌdô lîdríꞌá õdrã ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Gõꞌdá ĩtí rî, Márãtã drí tã-drı̣̃ lôgõzó kpá Yésũ drí kĩ, “Ãwô, má nı̣̃ trá, Ôvârí âꞌdô gólâ rî ꞌẽꞌá lîdrílí õdrã ꞌásĩ kậyı̣̂ Ôvârí drí õjílã íyíkâ lîdrízó ndrĩ rî ꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Gõꞌdá nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó kpá Márãtã drí kĩ, “Márãtã, mâ rĩꞌá cú mbârâkã õjílã lîdrî kâ bê õdrã ꞌásĩ. Gõꞌdá õjílã gólâ tã lẽ ꞌbá trá má ꞌá rî, õzõ gólâ õdrã kpálé ãngó nõ ꞌásĩ rî, gólâ âꞌdô lîdríꞌá kpá óꞌdí õdrã ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Õzõ õjílã rî ꞌdĩ õlîdrî trá õdrã ꞌásĩ rî, gólâ drãá gõꞌdá kô ãlôwálâ. Ĩtí rî, Márãtã, ní lẽ tã trá úlı̣́ má drí âtálé nõ ꞌá yã?” ");
INSERT INTO avu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Gõꞌdá nĩngá sĩ, Márãtã drí tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Ãwô kúmú, má lẽ tã trá úlı̣́ ꞌdĩ ꞌá, tãlâ má nı̣̃ trá, ní ânĩ Ôvârí ngá lésĩ ꞌdíyî pã ꞌbá ró. Má nı̣̃ trá, nî Ôvârí rî mvá ꞌî.” ");
INSERT INTO avu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Gõꞌdá Márãtã âtâ úlı̣́ ꞌdĩ bê Yésũ drí ĩtí rî, gólâ drí ngãzó nĩlí ꞌbã ꞌálâ tã âtálé íyî ậmvúpı̣̃ Mãríyã drí kírî ró kĩ, “Tã îmbá ꞌbá ãmákâ âcâ trá, gólâ kĩ, yí õlẽ úlı̣́ âtálé ní bê.” ");
INSERT INTO avu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Gõꞌdá nĩngá sĩ, Mãríyã ârílí bê úlı̣́ ậmvúpı̣̃ lâ drí âtálé ꞌdĩ rî, gólâ drí ngãzó ạ̃vũ ûrû nĩlí ꞌwãâꞌwâ Yésũ ngálâ. ");
INSERT INTO avu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ꞌDĩî Yésũ drẽ zãâ âdréꞌá lạ́tı̣̂ ꞌá võ tíbê Márãtã drí gólâ rî âyézó ꞌálâ rî ꞌá. ꞌDĩî gólâ cá drẽ zãâ ãwó võ ꞌdî ꞌálâ kô. ");
INSERT INTO avu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Gõꞌdá õjílã õꞌbí Yúdạ̃ yí kâ rĩ ꞌbá ĩyî Márãtã yî lạ̃gạ́tı̣́ Mãríyã bê ãwó võ ꞌálâ nã ꞌbá yî ndrê bê ĩyî Mãríyã nĩꞌá ꞌwãâꞌwâ rî, gólĩyî drí kpá ngãzó ꞌdẽlé Mãríyã vósĩ, tãlâ gólĩyî ı̣̂sũ ĩyíkâ bê rî kĩ, Mãríyã õrî nĩlí ꞌdĩ lóꞌdé drı̣̃ ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nĩngá sĩ, Mãríyã yî nĩ bê cãlé Yésũ rî ûsúlı̣́ rî, Mãríyã drí ârázó ꞌãꞌî tı̣̃lı̣́ Yésũ ândrá ãwó bê, gõꞌdá drílâ tã âtázó Yésũ drí kĩ, “Óõ kúmú, tí ní õró ꞌbãâ nõ kó nõngá rî, tí ámâ lônyí nõ drãá kô, tãlâ tí ní pâ gólâ nõ trá ngá lãzé ꞌdĩ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Gõꞌdá Yésũ ndrélé bê Mãríyã õjílã dũû ꞌdẽ ꞌbá vó lâ sĩ ꞌdî ꞌbá yí bê ꞌdó ãwó ngõꞌá ĩyî rî, kôrô ĩzã drí gãzó gólâ rú. ");
INSERT INTO avu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Gõꞌdá drílâ tã îjízó gólĩyî tı̣́ kĩ, “Nĩ ꞌbã gólâ rî ãvõ nô ángô lé ró yã?” Gõꞌdá drílĩyî tã-drı̣̃ lôgõzó Yésũ drí kĩ, “Kúmú, ní ânĩ, mã nĩ ró bê võ gólâ rî ꞌbãzó rî âꞌdálé ní drí.” ");
INSERT INTO avu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Gõꞌdá ĩtí rî, kôrô ı̣̃lı̣́ndrı̣̂ drí lâdãzó Yésũ lı̣̃fı̣́ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gõꞌdá õjílã gólĩyî ânĩ ꞌbá ꞌdĩ ꞌbá yî ndrê ĩyî Yésũ bê ãwó ngõꞌá rî, ãzâ ꞌbá yî drí ngãzó tã âtálé kĩ nĩ rî, “Nĩ ndrê drẽ, gólâ lẽ Lázãrõ trá rõô!” ");
INSERT INTO avu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gõꞌdá õjílã rî ꞌdĩ ãzâ ꞌbá yî âtâ ĩyíkâ tã kĩ, “ꞌDĩî âꞌdó kô tí ãgô gólâ rĩ ꞌbá õjílã lı̣̃fı̣́ êdélé rî ĩꞌdî yã? Tí gõꞌdá gólâ îngá rû-lẽ-ãzí lâ ngá lãzé õdrã kâ ꞌdĩ ꞌásĩ kô ãꞌdô tãsĩ yã?” ");
INSERT INTO avu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Gõꞌdá Yésũ ndrélé bê õjílã dũû ꞌdó rû êꞌbé ꞌbá ãwó ngõlé Mãríyã yí bê ꞌdĩ ꞌbá yî rî, gólĩyî ĩzã drí gólâ rî ꞌẽzó rõô, ĩꞌdî gólâ drí rĩzó ãwó ngõlé ꞌdĩ. Ĩtí rî, Yésũ yî õtírĩ nĩî cãlé lóꞌdé drı̣̃ ꞌálâ rî, gólâ drẽ zãâ ãwó ngõꞌá. Óꞌbã Lázãrõ rî ãvõ ꞌdî ũgı̣́ ꞌá, gõzó kúnı̣́ úngû âtrõlé ꞌbãlé kpạ̃ạ́kũ tı̣́ lâ. ");
INSERT INTO avu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nĩngá sĩ, Yésũ yî câ bê lóꞌdé drı̣̃ ꞌálâ rî, gólâ drí tã âtázó gólĩyî drí kĩ, gólĩyî õlîlî kúnı̣́ úngû ꞌbãlé ũgı̣́ tı̣́ ꞌdĩ vólé. Gõꞌdá ĩtí rî, Márãtã drí tã âtázó Yésũ drí kĩ, “Kúmú, ãvõ ậyı̣́ ꞌbá trá ꞌbú ꞌá kậyı̣̂ sû nõ rî áâꞌdô tı̣̂ lâ njı̣̃ꞌá ángô tí ró yã? Ạ̃jı̣́ lâ ngũ nõ trá õnjí ró.” ");
INSERT INTO avu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Gõꞌdá nĩngá sĩ, Yésũ drí tã-drı̣̃ lôgõzó Márãtã drí kĩ, “Márãtã, tã má drí âtálé rî fí drẽ zãâ ní drı̣̃ı̣̂ kô yã? Má kĩ ní drí rî, õzõ ní õlẽ tã trá má ꞌá pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ rî, ní âꞌdô mbârâkã Ôvârí kâ ndrẽꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nĩngá sĩ, drílĩyî kúnı̣́ úngû ũgı̣́ tı̣́ ꞌdĩ lîlízó vólé. Gõꞌdá Yésũ drí lı̣̃fı̣́ îngázó ûrú ꞌálâ, gõzó rãtáã ꞌẽlé Ôvârí drí kĩ, “Tátá, ãwô-ĩtí ãâꞌdô ní drí, má lûyı̣̂ nî, tãlâ ní rî ı̣̃tú vósĩ cé zãâ rãtáã ámákâ ârílí mbârâkã âfẽzó má drí. ");
INSERT INTO avu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Má nı̣̃ trá kĩ, ní âfẽ mbârâkã trá ndrĩ má drı̣́gạ́. Gõꞌdá má îrátã nî nõ rî, tãlâ õjílã gólĩyî má lạ̃gạ́tı̣́ nõ ꞌbá yî ũnı̣̃ ró ĩyî tã bê kĩ, pạ̃tı̣́-pạ̃tı̣̃ ró ní âjô mâ nĩ.” ");
INSERT INTO avu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Gõꞌdá nĩngá sĩ, Yésũ ndẽ rãtáã íyíkâ ꞌdĩ bê ndrĩ rî, gólâ drí Lázãrõ rî zı̣̃zó ngbạ́lạ́-ngbạ́lạ́ kĩ, “Lázãrõ, ámâ rû-lẽ-ãzíyã, ní âfõ ĩví ꞌá nõlé!” ");
INSERT INTO avu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Gõꞌdá nĩngá sĩ rî, Lázãrõ tíbê drã ꞌbá trá ꞌdĩ rî drí lîdrízó õdrã ꞌásĩ âfõlé ĩvĩ ũgı̣́ ꞌdĩ ꞌásĩ. Ĩtí rî, gólâ drẽ zãâ ítá gólâ rî ꞌbãzó rî bê yí rú, gõꞌdá ítá tı̣̂ ômbélé kpạ̃ạ́kũ drı̣̃ lâ ꞌá rî drẽ kpá zãâ bê. Nĩngá sĩ, Yésũ drí tã âtázó õjílã rĩ ꞌbá ĩyî âdrélé ꞌdĩ ꞌbá yî drí kĩ, “Nĩ înjî ítá ꞌdĩ ꞌbá yî gólâ rú sĩ, ítá drı̣̃ lâ ꞌá ꞌdĩ bê, mã nĩ ró bê ꞌbã ꞌálâ.” ");
INSERT INTO avu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gõꞌdá õjílã gólĩyî ãwó võ ꞌá ꞌdĩ ꞌbá yî ndrélé bê ĩyî tã lârâkô Yésũ drí ꞌẽlé Lázãrõ rî îngázó õdrã ꞌásĩ ꞌdî rî, ãmbá võ lâ yî drí ngãzó ĩyî ꞌdó tã lẽlé Yésũ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gõꞌdá ãzâ ꞌbá yî drí ĩyíkâ rãzó bê-rî nĩꞌá tã lârâkô Yésũ kâ ꞌẽlé ꞌdĩ tã lâ âtálé ĩꞌdî Pạ̃rúsı̣̃ yî drí. ");
INSERT INTO avu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Gõꞌdá Pạ̃rúsı̣̃ yî drı̣̃-ꞌbá ạ́ngı̣́ rî ꞌbá yí bê ârî ĩyî bê tã ꞌdî rî, gólĩyî drí âꞌdózó ndrĩ ạ̃wạ̃ ró. Nĩngá sĩ rî, drílĩyî tã kĩ ꞌbá Yúdạ̃ yí kâ ró rî ꞌbá yî ậzı̣́zó ndrĩ rû êꞌbélé võ ãlô ꞌá tã ı̣̂ꞌbı̣̃lı̣́ Yésũ rú. Gõꞌdá êꞌbê rû ĩyî bê ndrĩ rî, drílĩyî rĩzó tã ı̣̂ꞌbı̣̃lı̣́ kĩ, “Mã âꞌdô ãꞌdô ꞌẽꞌá ĩꞌdî ãgô nõ êdrẽzó, tã gólâkâ rĩꞌá ꞌẽlâ nõ ꞌásĩ yã? Gólâ rĩꞌá õjílã drı̣̃ îzãꞌá tã lârâkô íyíkâ ꞌdĩ sĩ nô. ");
INSERT INTO avu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Õzõ mã ãâyê gólâ trá rĩꞌá zãâ tã ꞌdî ꞌẽlé ĩtí rî, gólâ âꞌdô õjílã drı̣̃ îzãꞌá ndrĩ ꞌdó ꞌdẽlé yí vósĩ, tã íyíkâ rî lẽlé ĩꞌdî! Gõꞌdá õzõ mı̣́rı̣̃ Rómã kâ ãârî ĩyî tã lâ trá rî, gólĩyî âꞌdô ngãꞌá ãmá bê ạ̃wạ̃ ró, gólĩyî â kĩꞌá nĩ rî, mã ı̣̃ı̣̂ꞌbı̣̃ tã ꞌdó nĩ gólĩyí bê tã ꞌdî ꞌbá yî ꞌẽzó ꞌdĩ. Gõꞌdá gólĩyî âꞌdô ânĩꞌá ạ̃jú ꞌbũ ꞌbá ĩyíkâ yí bê ânĩꞌá ãmâ rũlı̣́ ôjálé vólé kũmũ ãmákâ ꞌásĩ.” ");
INSERT INTO avu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gõꞌdá drı̣̃-ꞌbá drı̣̃-ꞌbá Yúdạ̃ yí kâ rî kâ ndrô ꞌdĩ sĩ zı̣̃lı̣́ Kãyífã rî drí ngãzó tã âtálé gólĩyî drí kĩ nĩ rî, “Ũrı̣̃ ãníkâ nõtí nõ kó ãꞌdô kâ ꞌî yã? Nĩ nı̣̃ı̣́ tã ãmâ înjízó lâŋõ ꞌdî ꞌásĩ rî kô yã? ");
INSERT INTO avu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nĩ nı̣̃ı̣́ kô kĩꞌá nĩ rî, rĩꞌá tãndí ró õjílã ãlô drí drãlé õjílã dũû drı̣̃ tĩlí yã? Õjílã rî ꞌdĩ âꞌdô drãꞌá ꞌbạ̃súrú ãmákâ Yúdạ̃ yí kâ pãlé, tãlâ mı̣́rı̣̃ Rómã kâ õzó kô ânĩî õjílã ãmákâ ûfúlı̣́ ndrĩ.” ");
INSERT INTO avu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kãyífã âtâ úlı̣́ ꞌdĩ ĩtí ꞌdĩ, tãlâ úũfû ró Yésũ bê. Gólâ nı̣̃ı̣́ kô kĩ, Ôvârí ꞌbã úlı̣́ ꞌdĩ nĩ yí sı̣́lı̣́ âtálé ĩtí, õzõ tã ậngũ ꞌbá kâtí kĩ, Yésũ ãâꞌdô drãꞌá ꞌbạ̃súrú Yúdạ̃ yí kâ tãsĩ ndrĩ, ");
INSERT INTO avu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","gõꞌdá kpá ꞌbạ̃súrú ãzâ ꞌbá yî ngĩíngî rî yî pãlé. Drãdrã Yésũ kâ ꞌdĩ ꞌá rî, gólâ âꞌdô õjílã gólĩyî tíbê õjílã íyíkâ ró rî yî ꞌbãꞌá âꞌdólé ngá ãlô ró íyî mvá yî ró. ");
INSERT INTO avu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ârî ĩyî bê úlı̣́ Kãyífã kâ âtálé ꞌdĩ rî, gólĩyî kĩ ĩyíkâ, ãwô-ꞌdĩ yĩ ûsû lạ́tı̣̂ trá Yésũ rî fũzó. ꞌDĩî vósĩ rî, ꞌâ lâ ĩyî drí ĩyíkâ gõzó gĩlí Yésũ rú rõô lậvũlı̣́ sı̣́sı̣́ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Gõꞌdá Yésũ nı̣̃ bê trá kĩꞌá nĩ rî, gólĩyî lẽ trá íyî fũlı̣́ rî, gólâ drí rĩzó íyî lậpı̣́lı̣́ lậpı̣̂, gõꞌdá drílâ nĩzó nĩꞌá rĩlí jạ̃rı̣́bạ̃ mvá zı̣̃lı̣́ Ẽfẽrémã rî ꞌálâ lãjóꞌbá íyíkâ yí bê kậyı̣̂ dã sĩ. Jạ̃rı̣́bạ̃ ꞌdî rĩꞌá ãnyî võ gólâ ꞌbã ãkó rî lạ̃gạ́tı̣́. ");
INSERT INTO avu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tã ꞌdî ꞌbá yî vósĩ rî, kậyı̣̂ Yúdạ̃ yí kâ kãrámã lậvũ-lậvũ kôrô kâ rî trá ãnyî. Gõꞌdá õjílã dũû trá ꞌdó rĩꞌá ĩyî nĩꞌá Yẽrõsãlémã ꞌálâ kãrámã rî ꞌdĩ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gõꞌdá Yúdạ̃ yî ãzâ ꞌbá yî câ bê ĩyî Yẽrõsãlémã ꞌálâ rî, lı̣̃fı̣́ lâ yî ĩyíkâ trá ꞌdó pávó ꞌá Yésũ rî tẽꞌá âcálé ạ̃ꞌdı̣́-drı̣̃ jó ạ́ngı̣́ Ôvârí kâ rî kâ ꞌdĩ ꞌálâ. Gõꞌdá ãzâ ꞌbá yî ĩyíkâ tã îjíꞌá ĩyî lãfálé ꞌásĩ ngãtá Yésũ ãâꞌdô âcáꞌá fí té trá kãrámã ꞌdî ꞌá yã rî. ");
INSERT INTO avu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ĩtí rî, ạ̃kû drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ Pạ̃rúsı̣̃ yí bê rî, ꞌbã ĩyî tã trá lậnjı̣̃-lậnjı̣̃ ró gólĩyî ĩyíkâ ró rî ꞌbá yî drí. Õzõ õjílã ãzâ õndrê võ Yésũ drí ꞌbãzó ꞌá lâ rî trá rî, gólĩyî ânĩ kôrô tã lâ âtálé ĩyî drí, tãlâ yĩ õnĩ ró bê gólâ rî ậrúlı̣́. ");
INSERT INTO avu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","2","Gõꞌdá nĩngá sĩ, Yésũ yî drí ngãzó gõlé kpá óꞌdí Bẽtánĩ ꞌálâ võ Lázãrõ gólâ Yésũ drí îngálé õdrã ꞌásĩ rî drí rĩzó rî ꞌálâ rî, ꞌdĩî kậyı̣̂ ạ̃mbúkũ âyê trá cé njı̣̂-kázíyá kãrámã lậvũ-lậvũ kôrô kâ drí âcázó. Tólâ rî, õjílã ãzâ ꞌbá yî drí Yésũ rî zı̣̃zó lãjóꞌbá íyíkâ yí bê ngá nyãlé Yésũ rî lậgúzó, gõꞌdá Lázãrõ kpá bê ngá nyãnyã ꞌdî võ lâ ꞌá. Márãtã rî nĩ rû ı̣̂ꞌbũlı̣́ gólĩyî drí ngá nyãnyã ꞌdî võ lâ ꞌá tólâ. ");
INSERT INTO avu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Gõꞌdá Yésũ yî õtírĩ ꞌbãâ ngá nyãꞌá rî, Mãríyã drí ânĩzó dõ ạ̃jı̣́ bê tũrũ-tũrũ lâgî lâ drí lậvũlı̣́ kôrô rî bê mãlãngĩ ꞌá dũû. Drílâ ânĩzó kôrô dõ ꞌdî bê ûtúlâ Yésũ rî pá ũgúlı̣́ ꞌá gólâ rî ı̣̂njı̣̃zó, gõꞌdá rĩzó lĩlâ íyî drı̣̃-ꞌbí sĩ. Gõꞌdá dõ rî ꞌdĩ ạ̃jı̣́ lâ drí lậꞌbúzó jó ꞌdĩ ꞌálé lâ ꞌásĩ ndrĩ tũrũ-tũrũ. ");
INSERT INTO avu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ĩtí rî, lãjóꞌbá ãzâ Yésũ kâ rú bê Yúdạ̃ Ĩsĩkãrĩyótã rî kpá bê võ ꞌdî ꞌá. Yúdạ̃ rî gógó ĩꞌdî ꞌẽ ꞌbá tíbê Yésũ rî drı̣́-bã fẽlé ạ̃jú-ꞌbá-ãzí Yésũ kâ rî yî drí rî. Gõꞌdá Yúdạ̃ ndrê bê tã Mãríyã drí ꞌẽlé ꞌdĩ rî, gólâ drí ngãzó tã âtálé ạ̃wạ̃ sĩ kĩ, ");
INSERT INTO avu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Dõ lâgî lâ drí lậvũlı̣́ kôrô ꞌdĩ órî îzãlâ ĩtí ãꞌdô drí yã? Tí gólâ gí dõ ꞌdî vólé gõzó lãfâ lâ ûsúlı̣́ âfẽlé ãmâ drí lânjílí ngá ãkó lé ꞌbá drí kô ãꞌdô drí yã?” ");
INSERT INTO avu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tã Yúdạ̃ kâ âtálé ꞌdĩ rî âꞌdó kô kĩ, gólâ lẽ pạ̃tı̣́ı̣̃ lãfâ ꞌdĩ fẽlé ngá ãkó lé ꞌbá drí. Yúdạ̃ âtâ tã ꞌdî ĩtí ꞌdĩ rî, tãlâ gólâ ĩꞌdî lãfâ ãzí-ãzí lâ ꞌdĩ ꞌbá yí kâ vó lâ ndrẽ ꞌbá ꞌî. Gólâ lẽ õzõ óõfẽ lãfâ ꞌdĩ trá yí drí vó lâ ndrẽlé rî, yí õrî ró bê rĩꞌá ûgũlâ nĩzó íyî tı̣̂ nyã bê. ");
INSERT INTO avu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yúdạ̃ âtâ úlı̣́ ꞌdĩ bê ĩtí rî, Yésũ drí tã âtázó gólâ drí kĩ, “Ní îkpókpólõ õkó ꞌdĩ kô! Gólâ ꞌê ꞌdĩ tã tãndí ꞌî. Tã gólâ drí ꞌẽlé dõ dãzó ámâ pá rú ꞌdĩ rî âꞌdálâ kĩ, gólâ êdê ꞌdĩ ámâ rúꞌbạ́ ꞌî njãâ ꞌbãlé ꞌbú ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Õzõ ní õlẽ ngá ãkó lé ꞌbá pãlé rî, gólĩyî bê ãní bê nõngá ı̣̃tú vósĩ cé ãnî drí rĩꞌá pãlâ. Gõꞌdá mâ rî gógó nõ, má âꞌdó kô rĩ ꞌbá ꞌî ãní bê nõngá ı̣̃tú vósĩ cé. Má âꞌdô nĩꞌá vólé ꞌwãâ.” ");
INSERT INTO avu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nĩngá sĩ, õjílã gõ ârî ĩyî bê tã kĩꞌá nĩ rî, Yésũ ãꞌdô bê Bẽtánĩ ꞌálâ rî, drílĩyî ngãzó nĩlí tólâ, ãꞌdô ró bê Yésũ rî ndrẽlé, gõꞌdá lậvũlı̣́ bê gạ̃rạ̃ lâ, gólĩyî lẽ Lázãrõ tíbê Yésũ drí îngálé õdrã ꞌásĩ rî ndrẽlé. ");
INSERT INTO avu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gõꞌdá drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ârî ĩyî bê kpá tã kĩ, õjílã dũû nĩ ĩyî trá ꞌdó Lázãrõ rî ndrẽlé rî, drílĩyî kpá tã ı̣̂ꞌbı̣̃zó ĩyî lãfálé ꞌásĩ ꞌẽzó Lázãrõ rî fũlı̣́ vólé, ");
INSERT INTO avu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tãlâ mbârâkã Yésũ drí Lázãrõ rî îngázó ĩꞌdî sĩ lâ õdrã ꞌásĩ ꞌdî pạ̃tı̣́ı̣̃ Ôvârí kâ ĩꞌdî. Ĩtí rî, mbârâkã ãkĩ ꞌdî drí tã âꞌdázó õjílã õꞌbí ꞌdĩ ꞌbá yî drí kĩ, pạ̃tı̣́ı̣̃ Yésũ Ôvârí rî mvá ꞌî. Õjílã ãmbá gólĩyî lãfálé rî ꞌbá yî drí drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî âyézó, gõꞌdá ꞌdẽzó Yésũ vósĩ tã ârí ꞌbá ró. ");
INSERT INTO avu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Gõꞌdá kậyı̣̂ ãzâ rî sĩ, Yésũ yî drí ngãzó lãjóꞌbá íyíkâ yí bê nĩlí Yẽrõsãlémã ꞌálâ. Lạ́tı̣̂ ꞌá, lãjóꞌbá ꞌdĩ ꞌbá yî drí dõngí âtrõzó ãꞌdô ró bê Yésũ drí mbãzó bê drı̣̃ lâ ꞌá nĩlí fĩlí Yẽrõsãlémã ꞌálâ. Ĩtí rî, õjílã õꞌbí tíbê ânĩ ꞌbá gólâ rî ndrẽlé Lázãrõ bê Bẽtánĩ ꞌá nĩngá rî, ndrê ĩyî bê Yésũ nĩꞌá Yẽrõsãlémã ꞌálâ rî, drílĩyî ꞌdẽzó kpãâ Yésũ yî vó. Gõꞌdá õjílã õꞌbí ãzâ ꞌbá yî ânĩ ꞌbá Yẽrõsãlémã ꞌálâ kãrámã lậvũ-lậvũ kôrô kâ ꞌẽlé rî, ârî ĩyî bê tã kĩꞌá nĩ, Yésũ ãâꞌdô bí ânĩꞌá rî, drílĩyî nĩzó gólâ rî lûyı̣́ bê âjílí Yẽrõsãlémã ꞌálâ. ");
INSERT INTO avu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Drílĩyî ngãzó ndrĩ ꞌdó mbı̣́rạ́ bı̣́ ôŋõlé ĩyî drı̣́gạ́ rãzó nĩꞌá Yésũ rî drı̣̃ tẽlé lạ́tı̣̂ ꞌálâ. Gõꞌdá drílĩyî rĩzó kpá Yésũ rî lûyı̣́lı̣́ gõꞌdá kpá ı̣̂njı̣̃lı̣́ úlı̣́ âtâ-âtâ bê ngbạ́lạ́-ngbạ́lạ́ kĩ, “Ãmâ ndrĩ, mã lûyı̣̂ Ôvârí! Mã lûyı̣̂ nî gólâ âcá ꞌbá Ôvârí ngá lésĩ rî. Ní ânĩ rĩlí kúmú ạ́ngı̣́ ãmákâ Ĩsĩrãꞌélẽ kâ ró!” ");
INSERT INTO avu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yésũ rî rãlé dõngí drı̣̃ı̣̂ nyé õzõ búkũ Ôvârí kâ drí âtálé rî kâtí kĩꞌá nĩ rî, ");
INSERT INTO avu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ãnî õjílã Yẽrõsãlémã kâ, nĩ ꞌê ũrı̣̃ gõꞌdá kô. Nĩ ndrê kúmú ãníkâ bí ânĩꞌá! Nĩ ndrê gólâ rĩꞌá ânĩꞌá dõngí jõrã drı̣̃ı̣̂.” ");
INSERT INTO avu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ĩtí rî, lãjóꞌbá Yésũ kâ ꞌdĩ ꞌbá yî nı̣̃ı̣́ ĩyî tã rû ꞌẽ ꞌbá ꞌdĩ ífí lâ kô. Yésũ ngâ té nĩ zãlô õdrã ꞌásĩ, drílĩyî gõzó úlı̣́ ífí îgĩlí búkũ Ôvârí kâ ꞌá nã nı̣̃lı̣́. Yésũ õtírĩ ngãâ õdrã ꞌásĩ rî, drílĩyî nı̣̃zó lâ kĩ, tã Yésũ drí âcázó dõngí drı̣̃ı̣̂ õjílã drí gólâ rî lûyı̣́zó nã ꞌê rû trá té õzõ búkũ Ôvârí kâ drí tã lâ âꞌdálé rî tí. ");
INSERT INTO avu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Õjílã õꞌbí ꞌdĩ ꞌbá yî ngâ ĩyî ndrĩ ꞌdó nĩꞌá Yésũ rî lậgúlı̣́ ꞌdĩ rî, tãlâ gólĩyî ârî tã gólâ kĩꞌá nĩ rî, Yésũ ĩîngâ Lázãrõ trá õdrã ꞌásĩ rî ĩꞌdî. Tãlâ õjílã gólĩyî Yésũ rî ndrẽ ꞌbá cú Lázãrõ rî îngárẽ ꞌá õdrã ꞌásĩ rî yî, gólĩyî rî nĩ nĩlí võrã lâ lânjí bê õjílã drí kĩ, Yésũ ãâꞌdô cú mbârâkã Ôvârí kâ bê. ");
INSERT INTO avu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Gõꞌdá Pạ̃rúsı̣̃ yî ndrê ĩyî bê õjílã dũû ꞌdó Yésũ rî lûyı̣́ꞌá rî, drílĩyî ꞌbãzó gõꞌdá tã ı̣̂sũ ró rõô. Drílĩyî rĩzó tã âtálé ĩyî võ ꞌásĩ kĩ, “Mã âꞌdô Yésũ rî êdrẽꞌá ángô tí yã? Nĩ ndrê drẽ gbõ õjílã õꞌbí rĩ ꞌbá ꞌdẽlé gólâ sĩ ꞌdî ꞌbá yî.” ");
INSERT INTO avu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Õjílã õꞌbí ãmbá ânĩ ꞌbá Yẽrõsãlémã ꞌá Ôvârí rî îrátãlé kậyı̣̂ kãrámã kâ ꞌdĩ ꞌá ꞌdĩ, ꞌbạ̃súrú Gı̣̃rı̣́kı̣̃ kâ kpá bê lãfálé lâ ĩyî ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gõꞌdá õjílã Gı̣̃rı̣́kı̣̃ kâ ũrûkậ ꞌbá yî drí ânĩzó tã âtálé Fílĩpõ drí. Gólĩyî kĩ gólâ drí rî, “Ãmbá, mã lẽ Yésũ rî ndrẽlé.” ");
INSERT INTO avu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Gõꞌdá Fílĩpõ drí ngãzó nĩlí tã õjílã Gı̣̃rı̣́kı̣̃ kâ ꞌdĩ ꞌbá yî drí âtálé yí drí ꞌdĩ âtálé Ãndĩríyã drí, gõꞌdá drílĩyî ngãzó kpạ̃rạ̃tı̣́ Ãndĩríyã bê nĩꞌá õjílã ꞌdî ꞌbá yî âjílí Yésũ ngálâ. Drílĩyî ngá õjílã ꞌdî ꞌbá yî drí lẽlé rî tã lâ âtázó ndrĩ Yésũ drí. ");
INSERT INTO avu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Gõꞌdá Yésũ ârílí bê ngá õjílã gólĩyî Gı̣̃rı̣́kı̣̃ kâ ꞌdĩ ꞌbá yî drí lẽlé ꞌdĩ tã lâ rî, gólâ drí ngãzó úlı̣́ âtálé gólĩyî drí ndrĩ lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yí bê kĩ, “Kậyı̣̂ gólâ Ôvârí drí ámâ âꞌdázó gólâ tíbê yí drí âjólé ûrú lésĩ rî âcâ trá. Ôvârí âꞌdô tã lâ âꞌdáꞌá gólĩyî drí õdrã ámákâ sĩ lîdrî-lîdrî ámákâ õdrã ꞌásĩ rî bê. ");
INSERT INTO avu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nĩ ârî tã má drí ꞌẽꞌá âtálâ nõ dódó, má âꞌdô ꞌẽꞌá drãlé ꞌbãlé ꞌbú ꞌá, nyé õzõ ạ̃drúgú ífí ı̣̂ꞌdı̣́rı̣̃ kâtí. Õzõ ní õlẽ ạ̃drúgú ífí ãlô rî drí tı̣̃lı̣́ dũû rî, ní âꞌdô ạ̃drúgú ífí ãlô ꞌdĩ ı̣̂ꞌdı̣́ꞌá zãlô ꞌbú ꞌá, ạ̃drúgú ífí ꞌdĩ drí gõzó âfõlé óꞌdí mbãlé ãcê, drílâ fõzó, drílâ gõzó ífí ꞌbãlé dũû. Rĩꞌá tãndí ró ạ̃drúgú ífí rî ꞌdĩ ı̣̂ꞌdı̣́zó zãlô ꞌbú ꞌá, drílâ gõzó âfõlé dũû. Tí õzõ ı̣́ı̣̃ı̣̂ꞌdı̣̂ ꞌbú ꞌá kô rî, ífí lâ ꞌdĩ âꞌdô ꞌbãꞌá kó zãâ cé ãlô ĩtí. Ĩtí rî, îcâ trá má drí drãlé ámâ ꞌbãzó ꞌbú ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Õjílã gólâ tã ãngó nõ kâ lẽ ꞌbá ĩꞌdî rõô gạ̃rạ̃ má drı̣̃ı̣̂ sĩ rî, gólâ âꞌdô drãꞌá zãâ gbạ́dú ạ̃dũkũ ãkó. Gõꞌdá õjílã gólâ íyî nyãányâ fẽ ꞌbá drãlé ámâ tãsĩ rî, gólâ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá. ");
INSERT INTO avu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Õzõ õjílã ãzâ pạ̃tı̣́-pạ̃tı̣̃ ró õlẽ trá ꞌdẽlé má vó rî, õrî ĩyî ãnyî má bê nõngá tã ârí ꞌbá ámákâ ró. Gbõ lé óõlẽ ãmâ fũlı̣́ gólĩyí bê rî, gólĩyî õrâ kô vólé. Õzõ gólĩyî ạ̃ậtũ fĩî trá ꞌdũwạ̃ má bê rî, ámâ átá âꞌdô drı̣́-ꞌâ fẽꞌá gólĩyî drí.” ");
INSERT INTO avu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Gõꞌdá Yésũ drí ngãzó tã ı̣̂sũ íyíkâ âꞌdálé gólĩyî drí kĩ nĩ rî, “Ngbãângbânõ rî, mâ tã ı̣̂sũ bê rõô. Má nı̣̃ı̣́ kô, ngãtá má âkĩꞌá nĩ rî ãꞌdô yã rî. Ngãtá má ĩîjî ámâ átá má õzó kô drãâ yã? Kó, má îcá kô tã îjílí ĩtí, tãlâ má ânĩ trá ãngó nõ ꞌá lâŋõ tã õnjí kâ trõlé má drı̣̃ı̣̂ õjílã ndrĩ pãlé. ");
INSERT INTO avu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ĩtí rî, ámâ átá, má fẽ ámâ nyãányâ ní drı̣́gạ́. Ní âꞌdâ mbârâkã áníkâ õjílã drí õzõ ãmâ drí ı̣̂ꞌbı̣̃lı̣́ trá ní bê rî kâtí!” Gõꞌdá Yésũ âtâ bê úlı̣́ ꞌdĩ ĩtí rî, Ôvârí drí tã âtázó ûrú lésĩ kĩ, “Má âꞌdâ mbârâkã ámákâ trá, gõꞌdá mâ kpá trá njãâ âꞌdálâ õjílã drí ngbãângbânõ óꞌdí ró ní sĩ.” ");
INSERT INTO avu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Õjílã ndrĩ võ ꞌdî ꞌá ꞌdĩ drí ĩyî úlı̣́ ậꞌú ꞌbá ûrú lésĩ Ôvârí drí âtálé ꞌdĩ ârízó ndrĩ. Gõꞌdá õjílã ãzâ ꞌbá yî kĩ ĩyíkâ rî, ꞌdĩî ãâꞌdô mõgbárá ꞌî. Gõꞌdá ãzâ ꞌbá yî kĩ, mãlãyíkã Ôvârí kâ ãâtâ tã nĩ Yésũ drí ûrú lésĩ. ");
INSERT INTO avu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Gõꞌdá Yésũ drí tã âtázó õjílã ꞌdî ꞌbá yî drí kĩ, “Ãwô, Ôvârí âtâ úlı̣́ ꞌdĩ nĩ, gólâ âtá tã ꞌdî kô ámâ pãlé, gólâ âtâ tã ꞌdî ámâ âꞌdálé ãnî drí Ôvârí rî mvá ró. ");
INSERT INTO avu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Má âꞌdô Sãtánã gólâ íyî ꞌbã ꞌbá kúmú ró ãngó nõ ꞌá nõ pẽꞌá ngbãângbânõ, má drí gólâ rî drõzó vólé. Gõꞌdá õjílã võ ꞌásĩ ndrĩ gólĩyî tíbê rĩ ꞌbá tã Sãtánã kâ rî ꞌẽlé ĩꞌdî rî drí ĩyî jãzó ꞌdẽlé má vó tã ámákâ rî ꞌẽlé ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Õzõ íĩîngâ mâ trá fê drı̣̃ı̣̂ rî, gõꞌdá õjílã ndrĩ drí âgõzó ꞌdẽlé má vósĩ.” ");
INSERT INTO avu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ꞌDĩî tã Yésũ drí õdrã lârâkô íyî ạ̃jú-ꞌbá-ãzí yî drí ꞌẽzó íyî fũlı̣́ rî âꞌdázó rî ĩꞌdî. ");
INSERT INTO avu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gõꞌdá Yésũ âtâ tã ꞌdî bê ĩtí rî, õjílã ãzâ drí tã âtázó õꞌbí ꞌdĩ ꞌbá yî lãfálé sĩ kĩ, “Úlı̣́ áníkâ âtálé ꞌdĩ ꞌbã ãmâ drı̣̃ gõꞌdá trá nõlé lîjãlé lîjã. Íîgĩ trá búkũ Ôvârí kâ ꞌá kĩ, ꞌdíyî pã ꞌbá Ôvârí drí ꞌẽꞌá âjólâ rî õdrãá kô, ãâꞌdô rĩꞌá zãâ gbạ́dú ạ̃dũkũ ãkó rî, gõꞌdá ní âtâ tã kĩꞌá nĩ rî, íĩîngâ gólâ tíbê âjólé trá ûrú lésĩ ꞌdî fê drı̣̃ı̣̂ rî ãꞌdô tãsĩ yã? Gólâ tíbê âjólé trá ûrú lésĩ ní drí tã âtálé tã lâ tãsĩ ꞌdî ãꞌdî ĩꞌdî yã?” ");
INSERT INTO avu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nĩngá sĩ rî, Yésũ drí tã âtázó kpá gólĩyî drí kĩ, “Mâ bê ãní bê ngá îꞌĩ ró ãnî drí cé kậyı̣̂ fínyáwá sĩ. Bê trá ĩtí rî, nĩ tô ậcı̣́ drẽ ãkpã ngá îꞌĩ drẽ bê nõ, tãlâ võ õtírĩ gõꞌdá ậnı̣́ rî, nĩ îcá gõꞌdá ậcı̣́ tõlé ı̣́nı̣́rı̣́kúwạ́ ꞌásĩ kô, ı̣́nı̣́rı̣́kúwạ́ ꞌásĩ rî, õjílã îcá kô võ yí drí lẽlé nĩlí ꞌálâ rî ndrẽlé dódó. ");
INSERT INTO avu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nĩ lẽ tã má ꞌá ngbãângbânõ pı̣̃pı̣̂sı̣́lı̣́ ãlô sĩ má drí ꞌbãrẽ bê nõngá nõ ꞌá nõ! Õzõ nĩ õlẽ tã trá má ꞌá ngá îꞌĩ lạ́tı̣̂ Ôvârí kâ âꞌdá ꞌbá rî ró rî, ãnî drí âꞌdózó õjílã ámákâ ró âꞌdólé cú ngá îꞌĩ ámákâ bê. Ĩtí rî, nĩ âꞌdô lạ́tı̣̂ Ôvârí kâ nı̣̃ꞌá dódó ậcı̣́ tõzó drı̣̃ lâ sĩ mbı̣̂mbı̣̂ ró.” Gõꞌdá Yésũ âtâ úlı̣́ ꞌdĩ bê ĩtí rî, gólâ drí ngãzó gólĩyî âyélé ndrĩ ꞌdó nĩngá nĩzó íyî lậpı̣́lı̣́ íyî ạ̃jú-ꞌbá-ãzí yî lı̣̃fı̣́ drı̣̃ ꞌásĩ kírî ró. ");
INSERT INTO avu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Gbõ lé Yésũ âꞌdâ yî bê õjílã Yúdạ̃ yí kâ rî ꞌbá yî drí ândálé tã lârâkô dũû sĩ kĩ, Ôvârí âjô yî nĩ rî, õjílã dũû gâ vólé trá dó tã pạ̃tı̣́ı̣̃ ꞌdĩ lẽlé. ");
INSERT INTO avu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Gólĩyî gâ vólé trá dó tã pạ̃tı̣́ı̣̃ rî lẽlé, nyé õzõ õjílã gólĩyî ạ̃kû vólé gã ꞌbá ꞌdó dó tã lẽlé rî yí kâtí. Tã ậngũ ꞌbá Ĩsáyã ậngũ tã gólĩyî tãsĩ kĩ nĩ rî, “Ôvârí, õjílã nô ꞌbá yî ãlôlâ lẽé tã kô úlı̣́ áníkâ ãmâ drí rĩꞌá âtálâ gólĩyî drí nõ ꞌá! Õjílã ãzâ fí bê ãlô gólĩyî lãfálé sĩ mbârâkã áníkâ ndrẽ ꞌbá yã?” ");
INSERT INTO avu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Õjílã gólĩyî tã lẽ ꞌbá Yésũ ꞌá kô ꞌdĩ, gólĩyî nyé õzõ õjílã gólĩyî gã ꞌbá dó tã lârâkô tı̣̂ drí ậꞌdı̣́zó ậꞌdı̣̂ Ôvârí drí rĩꞌá ꞌẽlâ Ĩsáyã drí rĩrĩ tã îmbálé gólĩyî drí rî ꞌá rî kâtí. Gõꞌdá Ôvârí âtâ kpá ĩtí Ĩsáyã tı̣̂ sĩ õjílã gólĩyî tã lẽ ꞌbá Yésũ ꞌá kô ꞌdĩ ꞌbá yî tãsĩ. Gólâ kĩ nĩ rî, ");
INSERT INTO avu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gólĩyî drı̣̃ rĩꞌá âmbâ-âmbâ ró tã ámákâ Ôvârí kâ drí fĩzó ꞌá lâ. Gõꞌdá gólĩyî âmbê ĩyî lı̣̃fı̣́ kpá trá gạ́gạ́. Tí õzõ ãꞌdô kô ĩtí rî, tí gólĩyî âꞌdô îcáꞌá pạ̃tı̣́ı̣̃ tã ámákâ ndrẽlé ĩyî lı̣̃fı̣́ sĩ nı̣̃zó lâ. Tí tã âtî-âtî ámákâ âꞌdô fĩꞌá gólĩyî drı̣̃ı̣̂, tãlâ gólĩyî ãâdĩ ró drı̣̃ tã õnjí ꞌásĩ âgõzó má ngálâ. Ĩtí rî, má âꞌdô gólĩyî êdéꞌá âꞌdólé dódó.” ");
INSERT INTO avu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ĩsáyã âtâ tã ꞌdî tã ậngũ ꞌbá ró tã õjílã drí Yésũ rî gãzó dó rî âꞌdázó, tãlâ Ôvârí âꞌdâ mbârâkã Yésũ kâ trá Ĩsáyã drí. ");
INSERT INTO avu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gbõ lé drı̣̃-ꞌbá ạ́ngı̣́ Yúdạ̃ yí kâ ꞌdĩ ꞌbá yî ãmbá lâ gâ vólé bê dó tã lẽlé Yésũ ꞌá rî, gõꞌdá ãzâ ꞌbá yî gólĩyî lãfálé ꞌásĩ lẽ ĩyíkâ tã kpá trá Yésũ ꞌá. Gõꞌdá gólĩyî ãzâ ꞌbá yî ꞌdó tã lẽ ꞌbá trá Yésũ ꞌá ꞌdĩ rî, gólĩyî lẽé ĩyî kô âꞌdálâ õꞌbí ꞌá kĩ, yĩ õlẽ tã trá Yésũ ꞌá, tãlâ gólĩyî ũrı̣̃ ró ĩyî ãzí-ãzí Pạ̃rúsı̣̃ ró ꞌdĩ ꞌbá yî tãsĩ. Tãlâ Pạ̃rúsı̣̃ ꞌdĩ ꞌbá yî ꞌbã ĩyî tã trá kĩ, õjílã tíbê tã lẽ ꞌbá trá Yésũ ꞌá rî, gólĩyî trá ndrĩ õjílã õnjí ꞌî, áâyé gólĩyî kô fĩlí jó tã Ôvârí kâ ârî kâ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tãlâ Pạ̃rúsı̣̃ tíbê tã lẽ ꞌbá Yésũ ꞌá ꞌdĩ ꞌbá yî, lẽé ĩyî kô ĩyî ãzí-ãzí yî drí ĩyî zı̣̃lı̣́ õjílã õnjí ró, gólĩyî lẽ tã ı̣̂sũ ĩyî ãzí-ãzí Pạ̃rúsı̣̃ ró rî ꞌbá yí kâ gạ̃rạ̃ tã ı̣̂sũ Ôvârí kâ rî drı̣̃ı̣̂ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Gõꞌdá kậyı̣̂ ãzâ sĩ rî, Yésũ kpá rĩꞌá õjílã lı̣̃fı̣́ îmbáꞌá. Ĩtí rî, Yésũ drí tã âtázó ûrû gólĩyî drí kĩ, “Õzõ õjílã õlẽ tã trá má ꞌá rî, gólâ lẽ tã ꞌdî kpá Ôvârí tíbê ámâ âjó ꞌbá nõ ꞌá. Gólâ lẽ tã ꞌdî âꞌdó kô cé má ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Õjílã gólâ ámâ nı̣̃ ꞌbá trá tãndí ró kĩ, mâ Ôvârí rî mvá ꞌî rî, ꞌdĩî gólâ nı̣̃ Ôvârí kpá trá. ");
INSERT INTO avu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Má ânĩ ãngó nõ ꞌá nõ âꞌdólé ngá îꞌĩ ró ãnî drí. Õjílã gólâ tíbê tã lẽ ꞌbá trá má ꞌá rî, õjílã rî ꞌdĩ âꞌdô íyíkâ zãâ rĩꞌá ậcı̣́ tõlé ngá îꞌĩ ꞌásĩ, gõꞌdá gólâ rí kô ı̣́nı̣́rı̣́kúwạ́ ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","“Õzõ õjílã ãzâ õlẽ tã lẽlé tã îmbâ ámákâ ꞌá gõꞌdá kpá má ꞌá kô rî, õjílã rî ꞌdĩ âꞌdô lâŋõ lậnjı̣̃-lậnjı̣̃ ûsúꞌá. Tã lẽ ãkõ gólâkâ ꞌdĩ âꞌdô tã-vó gólâkâ kĩꞌá ãkpã nĩ. Mâ rî gógó âꞌdó kô õjílã gólâ ꞌẽ ꞌbá tã-vó gólâkâ kĩlí rî ĩꞌdî, tãlâ má ânĩ trá ãngó nõ ꞌá nõ õjílã pãlé tã õnjí gólĩyíkâ ꞌásĩ, âꞌdó kô lâŋõ fẽlé drílĩyî tã õnjí gólĩyíkâ tãsĩ. ");
INSERT INTO avu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tã gólâ má drí rĩꞌá âtálâ ãnî drí nõ rî âꞌdó kô úlı̣́ ámákâ ĩꞌdî, ámâ átá ûrú ꞌálâ rî âtâ úlı̣́ nõ nĩ má sı̣́lı̣́. Gólâ kĩ nĩ rî, má ãânĩ âtálâ ãnî drí, nyé õzõ yí drí âtálé má drí rî kâtí. ");
INSERT INTO avu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Má rî nõ té tã gólâ drí âtálé má drí rî âtálé ĩꞌdî ãnî drí nõ. Má nı̣̃ kpá trá tãndí ró, õzõ õjílã ãzâ õlẽ tã trá úlı̣́ ámâ átá kâ nõ ꞌá rî, õjílã rî ꞌdĩ âꞌdô lédrẽ-lédrẽ ạ̃dũkũ ãkó rî ûsúꞌá.” ");
INSERT INTO avu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kậyı̣̂ Yésũ drí kãrámã lậvũ-lậvũ kôrô rî kâ ꞌẽzó lãjóꞌbá íyíkâ rî ꞌbá yí bê rî drí âcázó. Gõꞌdá Yésũ drí tã âꞌdázó lãjóꞌbá íyíkâ yî drí kĩ, yí lẽ gólĩyî trá kó îtõ võ ꞌásĩ bũúũ kậyı̣̂ gólâ yí drí rĩzó gólĩyí bê ãngó nõ ꞌá ngá lẽlẽ âꞌdálé gólĩyî drí ꞌdĩ ꞌá. Kậyı̣̂ ꞌdĩ ꞌá rî, Yésũ nı̣̃ trá kĩ, kậyı̣̂ yí drí drãzó rî âbí âcáꞌá. Ĩtí rî, Yésũ âꞌdâ ngá lẽlẽ íyíkâ lãjóꞌbá íyíkâ rî yî drí lạ́tı̣̂ nõ ꞌbá yî ꞌásĩ. ");
INSERT INTO avu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kậyı̣̂ rî gógó ꞌdĩ ꞌbá yî ꞌá rî, Yúdạ̃ Ĩsĩkãrĩyótã Sĩmónã rî mvá, ꞌbã ꞌbá bê kpá lãjóꞌbá Yésũ kâ ró rî, Sãtánã fî trá pı̣̃pı̣̂sı̣́lı̣́ lâ ꞌá, gólâ õꞌê Yésũ rî drı̣́-bã fẽlé. Ĩtí rî, kậyı̣̂ kãrámã lậvũ-lậvũ kôrô rî kâ ꞌdĩ lạ̃njạ́túlı̣́ lâ sĩ rî, Yésũ yî lãjóꞌbá íyíkâ yí bê êꞌbê rû ĩyî trá ꞌdó võ ãlô ꞌá ngá nyãlé. ");
INSERT INTO avu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Gõꞌdá Yésũ nı̣̃ trá kĩ, íyî átá fẽ mbârâkã trá ndrĩ ꞌdó yí drı̣́gạ́ tã ꞌbã ꞌbá bê rî ꞌbá yî ndẽzó. Gõꞌdá gólâ nı̣̃ kpá trá kĩ, yí ânĩ Ôvârí ngá lésĩ, gõꞌdá yí âꞌdô ꞌẽꞌá kpá gõlé ngbãângbânõ Ôvârí ngálâ. ");
INSERT INTO avu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Gõꞌdá gólĩyî drí ꞌbãrẽ ngá nyãꞌá lãjóꞌbá íyíkâ yí bê rî, Yésũ drí ngá nyãnyã âyézó, gõꞌdá ngãzó âdrélé ûrû, gõzó ítá íyíkâ ãmbá rĩꞌá âsálâ yí rú ítá ãzí drı̣̃ı̣̂ rî ângízó ꞌbãlé vũdrı̣́, gõzó ítá rúꞌbạ́ lĩ kâ âtrõlé âmbélé íyî ı̣́pı̣́tı̣́kû ꞌá. ");
INSERT INTO avu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nĩngá sĩ rî, gólâ drí lũmvû âdãzó límvó lũmvû dã kâ ꞌá õzõ rạ̃gı̣́ı̣̃ tãndí kâtí, gõꞌdá ngãzó rĩꞌá lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî pá lâ yî jĩlí ãlô-ãlô gõzó lĩlâ ítá rúꞌbạ́ lĩ kâ ꞌdĩ sĩ. ");
INSERT INTO avu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Gõꞌdá Yésũ rî bê lãjóꞌbá íyíkâ ꞌdĩ pá lâ yî jĩlí ãlô-ãlô cãzó ĩꞌdí bê lâ bũúũ Sĩmónã Pétẽrõ rú, gõꞌdá kpá yí õjĩ ró Pétẽrõ rî pá rî, Pétẽrõ ní drí vólé gãzó dó. Ní kĩ Yésũ drí rî, “Kúmú, má lẽé kô ní drí ámâ pá jĩzó õzõ rạ̃gı̣́ı̣̃ ámákâ kâtí!” ");
INSERT INTO avu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó Pétẽrõ drí kĩ, “Pétẽrõ, ní nı̣̃ı̣́ drẽ tã má drí rĩꞌá ꞌẽlâ nõ ífí lâ kô, gõꞌdá ní âꞌdô ífí lâ nı̣̃ꞌá trá tãndí ró.” ");
INSERT INTO avu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ĩtí rî, Pétẽrõ gâ vólé zãâ dó Yésũ drí íyî pá jĩzó. Gólâ kĩ nĩ rî, “Kúmú kó kô, ní âꞌdô ánî lôgõꞌá õjílã rạ̃gı̣́ı̣̃ ró ámâ pá jĩlí ꞌdĩ kó ángô tí yã? Má lẽé kô!” Gõꞌdá Yésũ drí kpá tã-drı̣̃ lôgõzó Pétẽrõ drí kĩ, “Pétẽrõ, õzõ má õjĩ ánî pá kô rî, ní âꞌdó gõꞌdá kô lãjóꞌbá ámákâ ĩꞌdî.” ");
INSERT INTO avu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nĩngá sĩ rî, gbõ Pétẽrõ drí tã-drı̣̃ lẽzó Yésũ drí íyî pá jĩzó. Gólâ kĩ, “Ãꞌdô ĩtí rî Kúmú, ꞌdõvó ní jĩ kpá ámâ drı̣́ yî ámâ drı̣̃ bê, má âꞌdô ró bê zãâ áníkâ ró.” ");
INSERT INTO avu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Gõꞌdá Yésũ drí tã-drı̣̃ lôgõzó Pétẽrõ drí kĩ, “Ní ndrê drẽ, õjílã gólâ tíbê lũmvû dã ꞌbá trá rî, rúꞌbạ́ lâ trá ndrĩ ngbángbá. Õzõ õjílã rî ꞌdĩ õtô ậcı̣́ trá rî, rĩꞌá tãndí ró gólâ drí cé íyî pá jĩzó ĩꞌdî. Ãnî lãjóꞌbá ámákâ rî ꞌbá yî, ãnî trá ngbángbá, gõꞌdá cé õjílã ãlô ãnî lãfálé ꞌásĩ gólâ âꞌdó kô ngbángbá.” ");
INSERT INTO avu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yésũ âtâ tã ꞌdî ĩtí ꞌdĩ rî, tãlâ gólâ nı̣̃ trá kĩ, lãjóꞌbá íyíkâ rî ꞌbá yî lãfálé sĩ rî, ãlô rî âꞌdô íyî drı̣́-bã fẽꞌá nĩ íyî ạ̃jú-ꞌbá-ãzí yî drí. Ĩꞌdî gólâ drí tã âtázó kĩ, “Nĩ âꞌdó kô ndrĩ ngbángbá ĩtí.” ");
INSERT INTO avu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gõꞌdá Yésũ jĩ bê lãjóꞌbá íyíkâ ꞌdĩ ꞌbá yî pá lâ yî ndrĩ rî, gólâ drí ítá íyíkâ âtrõzó sõlé yí rú