﻿USE sofia;
DROP TABLE IF EXISTS sofia.avt_vpl;
CREATE TABLE avt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES avt_vpl WRITE;
INSERT INTO avt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Menmen im hi hewisɨm hɨram niuk me maamrer yapɨrwe ne weiwɨk miutɨp me Jisas Krais, kerek hɨrak nepenyek ke mɨtɨk iuwe Devit, hɨrak nepenyek hak ke maam nɨpu kaiu Ebraham. ");
INSERT INTO avt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham kine Aisak. Aisak kine Jekop. Jekop kine Juda ketike heiyiuwerer nɨrak, kikrek tɨrak. ");
INSERT INTO avt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda kɨwaai ketike Tema hɨre wine Peres ketike Sara. Peres kine Hesron. Hesron kine Ram. ");
INSERT INTO avt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram kine Aminadap. Aminadap kine Nason. Nason kine Salmon. ");
INSERT INTO avt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon keit Rehap hɨre wine nɨkan kɨre Boas. Boas hɨrak keit Rut hɨre wine nɨkan kɨre Obet. Obet kine Jesi. ");
INSERT INTO avt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi kine Devit hɨrak mɨtɨk iuwe king. Devit kine Solomon. Nɨpaa Solomon miye pɨrak hɨre mɨte pe mɨtɨk Yuraia. Yuraia epei kaa, Devit ketɨwe hɨre mɨte pɨrak. ");
INSERT INTO avt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon kine Riaboam. Riaboam kine Abaisa. Abaisa kine Esa. ");
INSERT INTO avt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa kine Jihosafat. Jihosafat kine Joram. Joram kine Usaia. ");
INSERT INTO avt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia kine Jotam. Jotam kine Ehas. Ehas kine Hesekaia. ");
INSERT INTO avt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia kine Manasa. Manasa kine Emos. Emos kine Josaia. ");
INSERT INTO avt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia kine Jekonaia ketike kikrek nɨrak. Me wɨ im, mɨt ne Bebilon netike mɨt ne Isrel nenepan, hɨr neriyei mɨt ne Isrel neri nen wit kɨr. ");
INSERT INTO avt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hɨr nari mɨt ne Isrel nen wit kɨr eik, Jekonaia kine Sialtiel. Siatiel kine Serababel. ");
INSERT INTO avt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel kine Abaiat. Abaiat kine Elaiakim. Elaiakim kine Eso. ");
INSERT INTO avt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso kine Sedok. Sedok kine Ekim. Ekim kine Elaiat. ");
INSERT INTO avt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiat kine Eliesa. Eliesa kine Matan. Matan kine Jekop. ");
INSERT INTO avt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop kine Josep, mɨtɨk kerek keit mɨte Maria kerek wine mɨtɨk Jisas, kerek mɨt nenewek Mɨtɨk Iuwe ek Krais. ");
INSERT INTO avt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nɨpaa wɨ Ebraham kepu ere mɨte wine Devit, haiu mewenhis maamrer hɨr nar hiswiyen tekyaait (14). Me wɨ Devit kepu ere mɨte wine Jekonaia, wɨ kerek mɨt ne Bebilon neriyei mɨt ne Isrel neri nen wit kɨr, haiu mewenhis maamrer hɨr nar hiswiyen tekyaait (14). Me wɨ im ere Maria wine Jisas kerek God kehimɨtanek hɨrak kɨkaap haiu mɨt kaktaihis, haiu mewenhis maamrer hɨr nar hiswiyen tekyaait (14). ");
INSERT INTO avt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Menmen im hɨram hɨm me Jisas Krais miye pɨrak winaak ek. Jisas miye pɨrak Maria ap wetike Josep neitan wen au. Hɨr nehimɨteni weinɨm te hɨre wertei hɨre nepei wepɨtu wentar God Hɨmɨn Yaaik kau kekrerep kewis nɨkan kekre tu kɨre te hɨre wawinaak. ");
INSERT INTO avt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hɨre wawine nɨkan te mɨtɨk kɨre Josep han kitet hɨrak ap kɨwaai ketikerep te hɨre wepɨtu. Hɨrak mɨtɨk yaaik ap hanhan kakwepyapɨr hɨrak han kitet hɨre wɨrɨak enum kaknipiye yɨnk enuk te hɨrak kare kakɨpakɨnep kaksiuwerep wauno. ");
INSERT INTO avt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep han kitet mɨte pɨrak Maria kerek epei wetu, te hɨrak kɨwaai kɨtyak te mɨtɨk ensel ke Mɨtɨk Iuwe God kan ketpɨwek, “Ti nepenyek hak ke maam nɨpu kit Devit ti ap enaain ti etikerep eiyɨtan eiyɨntar nɨkan kekre tu ke mɨte pit God Hɨmɨn Yaaik kewisɨk kekrerep hɨre wepɨtu. ");
INSERT INTO avt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hɨre sip newenep wawine nɨkan te ti ewis niuk mɨrak Jisas entar hɨrak kakɨkaap mɨt nɨrak ne Isrel, hɨrak kakɨsak menmen mɨr enum.” ");
INSERT INTO avt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Menmen im mamnen mamises hɨm kerek nɨpaa Mɨtɨk Iuwe God katɨp mɨt profet em. Hɨram matɨp mar im: ");
INSERT INTO avt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yi mɨt miyapɨr eiyɨmtau im em. Maain mɨte nɨhan wawɨtu wawine nɨkan te mɨt nanɨnewek niuk mɨrak Emanyuel.” Haiu meweikɨn niuk mɨrak men hɨm maiu haiu matɨp, ‘God kau ketikewai.’ ");
INSERT INTO avt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wanewik epei au, Josep kekrit hɨrak kises menmen kerek mɨtɨk ensel nepei ketpɨwek hɨrak kɨwaai kɨtyak kɨrem, te hɨrak keit Maria hɨr neitan. ");
INSERT INTO avt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hɨr neitan te hɨrak ketikerep nɨran au ere hɨre sip newenep hɨre wine nɨkan. Hɨre winaak epei au, Josep hɨrak kewis niuk mɨrak Jisas. ");
INSERT INTO avt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisas miye pɨrak winaak keit wit Betlehem keit provins Judia. Maain kike mɨtɨkɨt hakɨt tɨr saur metike hɨr, wit kɨrakɨt keit yanɨmɨn kerek wepni kokai kan, hɨrakɨt tɨnaaiwɨr wit kɨrakɨt ten tiun wit Jerusalem, hɨrakɨt titehi mɨt tar ik: ");
INSERT INTO avt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Nɨkan kike kerek miye winaak maain hɨrak kakre Mɨtɨk Iuwe King kakinɨn naanmampre mɨt ne Isrel, hɨrak keik? Haiu mɨr saur kɨrak kerek keteiknai miye wine mɨtɨk maain hɨrak kakre Iuwe. Hɨram mɨr meke wepni kokai kan, te haiu man mamwenɨpi niuk mɨrak.” ");
INSERT INTO avt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mɨtɨk iuwe King Herot hɨrak kemtau hɨm kerek mɨte wine nɨkan, hɨrak han enuk kentar hɨrak han kitet maain hɨrak kakɨkrehɨr kɨrak. Mɨt yapɨrwe ne wit Jerusalem hɨr nepɨrpɨr nɨnapen nentar Herot hɨrak han enuk. ");
INSERT INTO avt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mɨtɨk Herot kenɨne mɨt iuwe ne pris netike mɨt ne Skraip kerek nertei hɨm me Moses natɨp mɨt em, hɨrak kitorhi, “Mɨt profet natɨp mɨte wawine Mɨtɨk Krais kerek God kehimɨtanek kaknen hɨre wawinaak wawɨt nein?” ");
INSERT INTO avt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hɨr mɨt newenhi netpɨwek, “Hɨre wawinaak kakɨt wit Betlehem ke provins Judia kentar im em nɨpaa mɨtɨk profet Maika kewis hɨm me God mau tɨwei mar im: ");
INSERT INTO avt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yi mɨt ne wit Betlehem yeit provins Judia. Yi iuwe yar ke mɨt ninɨn naanmɨpre mɨt ne Isrel. Yi yɨre iuwe yentar maain mɨtɨk hak kekre nɨmɨn ke yi mɨt, hɨrak kakre mɨtɨk iuwe kakinɨn naanmampre mɨt nai ne Isrel.’” ");
INSERT INTO avt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hɨr netpɨwek epei au, te mɨtɨk Herot kenɨne mɨtɨkɨt kerek tɨr saur hɨrak kɨsawɨn kitɨwekɨthi me wɨ marmenum te hɨrakɨt tɨr saur kerekek kɨr keteikɨn mɨte wine nɨkan kerek maain hɨrak mɨtɨk iuwe. ");
INSERT INTO avt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Epei au, hɨrak keriuwetet ten Betlehem hɨrak ketpɨwekɨt kar ik, “Yi eino eiyɨn eiyɨneitnɨwek ere yi einapɨnek, te yi pɨke einen eiyɨtpo te hi anen awen ninɨp ewenɨpi niuk mɨrak.” ");
INSERT INTO avt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hɨrakɨt temtau hɨm me Herot epei werek, te hɨrakɨt ten. Te saur kerek nɨpaa hɨrakɨt tɨrek hɨrak kɨr kepu kentar wit kerek Jisas miye winaak kɨwaairi en. ");
INSERT INTO avt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hɨrakɨt tɨr saur (o hɨr) kau kentar wit te hɨrakɨt han yaaik iuwe. ");
INSERT INTO avt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hɨrakɨt tɨnɨk ten wɨnak nɨmɨn ein tɨr nɨkan Jisas ketike miye pɨrak Maria. Epei au, hɨrakɨt tewen ninɨp tine han kɨrakɨt yaaik teriuwerek tatɨp hɨrak nɨkan yaaik. Epei au, hɨrakɨt tewep tanɨk mɨrakɨt tewetɨwek menmen weinɨm. Hɨrakɨt tewetɨwek menmen yaaim gol, metike frankinsens (hɨram menmen mɨre smok smel), hɨram metike mir (hɨram menmen mɨnɨn yaaim mɨre yeirep, semi o kɨpna). ");
INSERT INTO avt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Maain hɨrakɨt tɨtyak tɨr God Haai hɨrak ketpɨwekɨt, “Yi ap pɨke eino eitɨp Herot menmen yi epei yɨrem.” Te maain hɨrakɨt tɨnaaiwɨr wit Betlehem hɨrakɨt pɨke titet yayiwe hak hɨrakɨt pɨke ten wit kɨrakɨt eik. ");
INSERT INTO avt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mɨtɨkɨt wikak epei ten, Josep kɨtyak kɨr ensel hak ke God ke wɨtaan kan ketpɨwek, “Ti ekrit ehɨt nɨkan ketike miye pɨrak eri erɨr enaaiwɨr in ek ti eno Isip. Yi eiyu en ek ere hi etpi te yi einaaiwɨr wit ik e. Herot kɨnkatɨn nɨkan kakɨkɨp kaki.” ");
INSERT INTO avt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep kɨwaai kɨr ensel epei au, hɨrak kekrit ke wɨtaan ketike miye nɨkan hɨr nɨnaaiwɨr wit ik nen Isip. ");
INSERT INTO avt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hɨr nepu Isip ere maain Herot kaa. Menmen im epei man mar ke Mɨtɨk Iuwe God ketpim te mɨtɨk profet Hosia kewisɨm mau tɨwei. Hɨram matɨp, “Hi epei enɨne Nɨkan kai kan kɨnaaiwɨr Isip.” ");
INSERT INTO avt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Maain Herot kertei mɨtɨkɨt wikak te wit wepni kokai kan en hɨrakɨt epei temitɨwekpɨn, hɨrakɨt ap pɨke tan au, hɨrak han enuk wɨsenuk. Hɨrak nɨpaa ketpɨwekɨt te hɨrakɨt pɨke tatnen tatpɨwek, te hɨrakɨt ap pɨke tan au. Te hɨrak kesiuwe mɨt nanɨno wit Betlehem nanɨnep nɨkerek hɨrakɨt wen kike tar tito mar wiketerem mar ke nɨpaa mɨtɨkɨt kerek tises saur tan tetpɨwekem me wɨ saur hɨrak kinɨn kɨr keteiknor mɨte wine nɨkan ik. ");
INSERT INTO avt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mar im hɨm nɨpaa profet Jeremaia kewisɨm mau tɨwei hɨram epei man. Hɨram matɨp mar im: ");
INSERT INTO avt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Hɨr mɨt nemtau hɨm me miyapɨr nɨkɨt neit wit Rama. Hɨr nemtau hɨr nɨkɨt hɨm iuwe hɨm iuwe. Nepenyerer ne Resel nɨkɨt nɨkerek nɨr. Hɨr mɨt miyapɨr nanrekyi nanweni han yaaik taau nentar nɨkerek nɨr ap nau en au. Hɨr naa.” ");
INSERT INTO avt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herot epei kaa, Josep keit Isip. Wɨtaan ham Josep kɨwaai kɨtyak kɨr mɨtɨk ensel hak kiutɨp ke God kan kɨrek kewepyapɨr hɨrekes. ");
INSERT INTO avt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hɨrak kewepyapɨr hɨrekes ketpɨwek kar ik: “Ti ekrit pɨke ehɨt nɨkan ketike miye pɨke eri eno wit ke Isrel. Mɨtɨk Herot nepei kaa te mɨt nɨrak ap te nanɨnep nɨkan ik au.” ");
INSERT INTO avt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ensel ketpɨwek epei au, hɨrak kekrit keit nɨkan ketike miye pɨrak keri ken Isrel. ");
INSERT INTO avt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hɨrak keri ken Isrel, hɨrak kemtau Herot nɨkan kɨrak Akeleas kekrehɨr ke haai kɨrak kɨrɨak menmen mɨrak naanmɨpre mɨt ne Judia, te hɨrak kɨnapen pɨke kaknen kaku wit Betlehem. Hɨrak kɨwaai kɨtyak ke wɨtaan kɨr ensel ke God ketpɨwek hɨrak kakno wit hak kaku en. Te Josep kɨnaaiwɨr Judia ken provins Galili. ");
INSERT INTO avt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hɨrak ken provins Galili ken kau wit hak kike mɨt nenewek Nasaret. Mar im hɨm nɨpaa mɨt profet newisɨm mau tɨwei me Mɨtɨk Krais hɨram epei man. Hɨm matɨp, “Hɨr mɨt nanɨnewek mɨtɨk ke wit Nasaret.” ");
INSERT INTO avt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","4","Tito yapɨrwe epei men, hɨr wen nepu wit Nasaret. Me wɨ im mɨtɨk John kerek kɨkɨr mɨt nekre tɨpar hɨrak kan kau wit weinɨk ke Isrel kerek mɨt ap newi en. Hɨrak keriuwet kamel tepnek mɨrak mau yɨnk kɨrak, hɨrak keit yɨnk mɨram kamɨr mɨre waai keiyɨm ketepenem mau mamɨn kɨrak. Hɨrak kaam weise metike manu nɨkim mɨram me yaank weinɨm. Menmen meiyam au. Hɨrak kɨre mɨtɨk enuk kerp weinɨm. Hɨrak katɨp mɨt hɨm me God. Hɨrak ketpor kar ik: “Yi eiweikɨn sip eiwet menmen enum, hi akɨri eikre tɨpar yi eiyises hɨm yaaim me God eiyɨntar menep te haiu mamɨr God kakɨrkeik hɨrak kakinɨnai naanmamrai.” John hɨrak mɨtɨk ik kerek nɨpaa profet Aisaia katɨp maain hɨrak kaknen. Hɨrak katɨp kar ik: “Tɨ ik ek ap mɨt nei newik, mɨtɨk hak kɨnap katɨp kar ik: ‘Yi einetɨt yayiwe me Mɨtɨk Iuwe, yi eirɨakek yaaik akɨrek te hɨrak kakisesim werek.’” ");
INSERT INTO avt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Me wɨ im hɨr mɨt ne Jerusalem netike mɨt han nau nerer wit wit me provins Judia netike mɨt wit kɨr menep mani Jodan, hɨr nan nanɨr Jon. ");
INSERT INTO avt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Hɨr newepyapɨr menmen enum nɨpaa hɨr nɨrɨakem epei au, te Jon ken kɨkɨri nekre mani Jodan. ");
INSERT INTO avt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","John kɨr mɨt iuwe yapɨrwe nises hɨm me Farisi netike hɨm me Sadyusi. Mɨt in hɨr mɨt iuwe natɨp mɨt han hɨr enises hɨm me Moses markeik. Hɨr nan te John kakɨkɨri te hɨrak kinɨn ketpor, “Yi enun yɨre nɨkerek ne manpen o yenmik. Yenmak te yi han kitet yi yaain hi akɨri te yi yairɨr yainopɨn yaikeipɨn menmen enum God maain kakrɨakem skelim mɨt enun kakɨwaanki kakriuwerem a? ");
INSERT INTO avt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yi eiyinɨn eiweikɨn sip eiwet menmen enum yi eirɨak menmen yaaim eiteiknaiyem, haiu mamɨrtei yi yaain te maain hi akɨri eiyɨriuwe tɨpar. ");
INSERT INTO avt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yi ap han ekitet yi ap eiweikɨn sip eiwet menmen enum eiyɨntar yi nepenyerer ne Ebraham, te God kaktɨp yi nɨkerek nɨrak au! Hi hetpi God yaaik te kakweikɨnhis nan im mamre mɨt hɨram mamɨkrehɨr ke yi nepenyerer ne Ebraham. ");
INSERT INTO avt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","In ek God kewis hɨne me yerepɨ mɨwaai nu nun mɨram, te nu ap mamine nɨkim yaaim hɨrak kakman kakwɨrem mamɨkre si. ");
INSERT INTO avt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Hi hɨkɨr mɨt neriuwe tɨpar hentar hɨr neweikɨn sip newet menmen enum. Mɨtɨk hak kiutɨp kakɨkaru kaknen hɨrak kɨre Mɨtɨk Iuwe kinɨna hi au weinɨk. Maain hɨrak kaknen hɨrak kakweti yi mɨt menmen wik. Hɨrak kakweti God Hɨmɨn Yaaik kaktike si. Hɨrak kewet mɨt menmen im hɨram mar ke ");
INSERT INTO avt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","hɨrak keses rais mekre sar. Hɨrak kesesim epei au, hɨrak kaktenwewim hɨram haas mɨram mamno pɨn, hɨrak kakɨt rais kakwisɨm mamɨkre wɨnak. Te hɨrak kakripep haas weinɨm kakwɨrem kakɨsiyem.” ");
INSERT INTO avt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Maain wɨ ham, Jisas kɨnaaiwɨr provins Galili ken mani Jodan kewepyapɨr hɨrekes kitehi Jon te hɨrak kakɨkɨrek. ");
INSERT INTO avt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te Jon hanhan kewenek hɨrak ketpɨwek kar ik: “Ti henmak te ti han hitauhi te hi akɨrit? Ti iuwe hi au weinɨk. Hɨram yaaim te ti ekɨra.” ");
INSERT INTO avt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisas keremirɨwekem ketpɨwek, “Me in ek ti hɨrɨakem emɨr ke hi hituthiyem hentar hawɨr ewises menmen hɨm me God mau tɨwei hɨram matɨp menmen.” Hɨrak katɨp epei au, Jon kewenhi kɨkɨrek. ");
INSERT INTO avt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hɨrak kɨkɨrek epei au, Jisas kɨnaairwɨr tɨpar kehɨn kɨniu ken pɨn eik, te nepni hɨremes mewep mɨre weipɨr hɨrak kɨr God Hɨmɨn Yaaik kekiuwe kan main main kɨre hore tapɨ hɨrak kenterik. ");
INSERT INTO avt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Epei au, God katɨp hɨm hɨram meke nepni man matɨp mar im: “Ik ek hɨrak Nɨkan kai hi hanhan heriuwerek. Hɨrak kenipa hi han yaaik.” ");
INSERT INTO avt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jon kɨkɨr Jisas epei au, God Hɨmɨn Yaaik keriyaak ken yaank weinɨk mɨt ap newi, te Seten kari han kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hɨrak kau en 40 wɨtaan ere 40 wanewik, hɨrak ap kaam menmen au. Hɨrak ap kaam menmen au, te nɨnpɨ maak. ");
INSERT INTO avt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hɨrak nɨnpɨ maak te Seten enuk kewisesik kan kakri han kɨrak. Hɨrak kan ketpɨwek kar ik: “Ti Nɨkan ke God ti etɨp nan im emweikɨn emre bret te ti ehɨm.” ");
INSERT INTO avt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisas ap kises hɨm mɨrak au, hɨrak ketpɨwek kar ik: “Hi ap arɨakem antar hɨm me God mau tɨwei hɨram matɨp, ‘Mɨt miyapɨr ap te nankaap hɨras nanu nanriuwe menmen weinɨm hɨr nanɨm au. Hɨr enises hɨm me God te hɨr nanu werek.’” ");
INSERT INTO avt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hɨrak katɨp epei au, Seten keriyaak keiyɨk ken wit Jerusalem kerek mɨt nehimɨtanek wit ke God. Hɨrak keiyɨk ken kewisɨk kerp kentɨr wɨnak siup ke wɨnak ke God. ");
INSERT INTO avt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hɨrak kerp kentɨr wɨnak siup ke wɨnak ke God, Seten ketpɨwek kar ik: “Ti Nɨkan ke God ti ehɨtɨkɨr ehiun tɨ. Ti ap te hahi au ehɨntar hɨm me God nɨpaa mɨt newisɨm mau tɨwei matɨp, ‘God kaktɨp mɨt nɨrak ensel me ti. Hɨr hismamrut te ti ap enamu hɨt mit ewenem mamniu nan taau.’” ");
INSERT INTO avt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas ketpɨwek, “Hi ap arɨakem antar hɨm me God mau tɨwei matɨp mar im: ‘Yi mɨt miyapɨr ap eiri han ke Mɨtɨk Iuwe God ki te hɨrak kakɨkepi au emɨt!’” ");
INSERT INTO avt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hɨrak katɨp epei au, Seten keriyaak keiyɨk ken mɨniu (o neiyɨp) kau niu keteiknɨwek wit yapɨrwe me mɨt newi metike menmen mɨram yaaim. ");
INSERT INTO avt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hɨrak keteiknɨwekem, hɨrak ketpɨwek, “Ti ewen ninɨp ewenɨpi niuk mai hi iuwe te hi ewetit menmen yapɨrwe im te ti ehinɨn naanmamprewem.” ");
INSERT INTO avt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisas pɨke ketpɨwek, “Ti enopɨn ekeipno. Hi ap arɨakem au antar hɨm me God au tɨwei matɨp mar im: ‘Yi mɨt miyapɨr eiwenɨpi niuk me Mɨtɨk Iuwe ki God kerekek, eirɨak menmen mɨrak. Menmen ham em au emɨt.’” ");
INSERT INTO avt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas katɨp epei au, Seten kɨrɨr kɨnaiwɨrek. Te Ensel hɨr nan nekepik. ");
INSERT INTO avt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Maain Jisas kemtau mɨt natɨp mɨt han nari Jon neiyɨk nen newisɨk kekre wɨnak enuk kentar hɨrak kene mɨtɨk iuwe King Herot. Hɨrak kemtewek nepei au, hɨrak kɨnaaiwɨr wit ik pɨke ken provins Galili. ");
INSERT INTO avt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hɨrak ap kau wit Nasaret au. Hɨrak kɨnaiwɨrek ken kau wit Kapaneam kerek kɨrapɨt menep wan ke Galili, nɨpaa mɨt ne weiwɨk me Sebyulan ketike Naftalai hɨr newi. ");
INSERT INTO avt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hɨrak kau in te hɨm me God nɨpaa profet Aisaia kewisɨm mau tɨwei hɨram mamnen. Nɨpaa hɨrak kewis hɨm im: ");
INSERT INTO avt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Wit ke Sebyulan ketike wit ke Naftalai menep wan iuwe keit pɨnak ke mani Jodan, tɨ mau provins Galili mɨt ap ne weiwɨk me Isrel newi. ");
INSERT INTO avt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mɨt miyapɨr kerek newi en hɨr nɨre mɨt kerek nau ne wɨtaan toto, te in ek hɨr nɨr si iuwe merhɨhe. Mɨt kerek nau enum nɨnaain hɨr nani hɨr nar ke mɨt kerek nau wit toto enum im. Te in ek wanewik epei kan.” ");
INSERT INTO avt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Me wɨ im Jisas katɨp mɨt hɨm mɨrak, hɨrak katɨp, “Yi mɨt miyapɨr eiweikɨn sip eiwet menmen enum eiyɨntar menep haiu mamɨr mamɨrkeik te God kakinɨn naanmamprai haiu mɨt.” ");
INSERT INTO avt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas kitet tenhaan menep wan eik ke Galili, hɨrak kɨr mɨtɨkɨt wik tariyakɨt ten tewɨr hepin iuwe tekin saauk. Niuk mɨrakɨt Saimon (niuk ham Pita) ketike nɨkik kɨrak Endru. ");
INSERT INTO avt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas kɨret te hɨrak ketpɨwekɨt, “Yi wiketeret yi eiyisɨsa. Nɨpaa yi yari saauk. Te in ek hi ateikni yi yarkeik te yi eiri han ke mɨt hɨr nanises God.” ");
INSERT INTO avt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hɨrak ketpɨwekɨt epei au, in ek hɨrakɨt tɨnaaiwɨr menmen mɨrakɨt te hɨrakɨt tisesik. ");
INSERT INTO avt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hɨrak kepno kike kɨr mɨtɨkɨt wiketeret hakɨt Jems ketike nɨkik kɨrak Jon, hɨrakɨt nɨkerek hɨrakɨt te mɨtɨk niuk mɨrak Sebedi. Hɨrakɨt tetike haai tau bot kɨrakɨt tekerwo hepin. Jisas kenɨnewekɨt, ");
INSERT INTO avt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","te hɨrakɨt wasenum tɨnaaiwɨr haai kɨrakɨt ketike menmen mɨrakɨt hɨrakɨt tisesik. ");
INSERT INTO avt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hɨrak kenɨnewekɨt epei au, hɨrak ken kerer wit wit me provins Galili kewepyapɨr hɨm mɨrak kekre wɨnak mɨt nererik nekine hɨm me Moses hɨrak katɨp hɨm yaaim me God kinɨn naanmɨpre mɨt, hɨrak kɨkaap mɨt miyapɨr kerek nɨnap o yɨnk kɨr enuk, hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hɨrak kɨkaap mɨt miyapɨr hɨr nɨre yaain te hɨm me menmen Jisas kɨrɨakem men merer wit wit me provins Siria. Te hɨr yapɨrwe newi nari mɨt miyapɨr nɨnap o yɨnk kɨr enuk hɨr neriyei neri nen Jisas. Mɨt miyapɨr han hɨr nɨnap his hɨt enum, han en hɨr neperper nani, han en herwe mersɨsi te Jisas kekepi hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hɨr mɨt yapɨrwe nisesik. Mɨt in hɨr ne wit Jerusalem provins Judia, Galili, wit Dikapolis ketike tɨ me mani Jodan pɨnak ein. ");
INSERT INTO avt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas kɨr mɨt miyapɨr nisesik, hɨrak kɨniu mɨniu (o neiyɨp) ken kau ke nɨmɨn. Mɨt nɨrak disaipel hɨr nan nau netikerek. ");
INSERT INTO avt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hɨr nau netikerek, hɨrak kewep hɨm ketpor hɨm im: ");
INSERT INTO avt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Eiyɨmtau. Mɨt miyapɨr kerek hɨr nertei hɨr ap nises God werek werek hɨr han yaaik nanu nanɨntar God kaknen kakinɨni naanmampror. ");
INSERT INTO avt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","God kenip mɨt miyapɨr kerek in ek hɨr nɨkɨt hɨr nanu werek nentar God kakɨkepi. ");
INSERT INTO avt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mɨt miyapɨr kerek hɨr newenɨn han kɨr ke menmen, hɨr han yaaik nanu nanɨntar hɨr nanɨt menmen God nɨpaa ketpor hɨrak kakwetɨrem. ");
INSERT INTO avt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Mɨt miyapɨr kerek hɨr hanhan iuwe nises menmen God han yaaik hɨr nanisesim, hɨr han yaaik nanu. God kakɨkepi hɨr nanu werek nanisesik. ");
INSERT INTO avt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Mɨt miyapɨr kerek hɨr hanhan neriuwe mɨt nekepi hɨr han yaaik nanu nanɨntar maain God hanhan kakriuweri kakɨkepi. ");
INSERT INTO avt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Mɨt miyapɨr kerek hɨr han kɨr yaaik ap nɨrɨak menmen enum, hɨr han yaaik nanu nanɨntar maain hɨr nantike God nanu nanɨt. ");
INSERT INTO avt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Mɨt miyapɨr kerek hɨr newen mɨt han kɨr te hɨr nankiyan nanu nanɨt hɨr han yaaik nanu nanɨntar God kaktɨp hɨr nɨkerek nɨrak. ");
INSERT INTO avt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Mɨt miyapɨr kerek mɨt han nanɨp nentar hɨr nises menmen God ketpor hɨr enisesim, hɨr han yaaik nanu. Maain hɨr nantike God naanmampre menmen yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mɨt hɨr netpi enum nerekyi enum naniwep newenɨni hɨm menmen nanɨntar yi yises hɨm mai, yi han yaaik yayu. ");
INSERT INTO avt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yi han yaaik yayu yayɨntar maain God kakweti menmen yaaim iuwe kakɨt wit kɨrak. Yi yayɨt menmen im yayɨntar nɨpaa mɨt nɨrɨak enum nenep mɨt profet nɨpaa newepyapɨr hɨm me God, te hɨrak kakwetɨr menmen yaaim iuwe mamɨt wit kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yi mɨt yi yɨkaap mɨt ne tɨ ap nises menmen enum mɨre sol mɨkaap sak naan hɨrak ap mamnɨn waswas. Te sol meweikɨn mɨre tɨpar ap mamtɨn hɨm yi eirɨak mekam te hɨram pɨke tokim? Taauye! Yi eiwɨrem mamno witeik te mɨt miyapɨr nanɨntɨram, hɨram enum. ");
INSERT INTO avt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yi yɨkaap mɨt ne tɨ nises God yɨre si mekepi me wɨtaan yitet yayiwe. Yi yɨre wit kerek mɨt nau niu. Hɨrak ap te kɨsawɨn taau, kau yaain mɨt miyapɨr nɨrek yanɨmɨn. ");
INSERT INTO avt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mɨt miyapɨr ap neksiu si nɨsawɨnek kɨnɨk tɨkenup o newisɨk kɨnɨk yeno au. Hɨr newisɨk kentar yeno te hɨrak kɨriyor kekre wɨnak te hɨr kerek nau nekrerek nɨr menmen. ");
INSERT INTO avt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mar im menmen yi yɨrɨakem hɨram mɨre si. Mɨt nɨrem hɨram yaaim te hɨr nanwenɨpi niuk me Haai kaiu God kerek kau keit wit kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yi ap han ekitet hi han ehɨwaank hɨm me God Moses ketike mɨt profet nɨpaa newisɨm mau tɨwei. Hi ap han ehɨwaankem au. Hi han arɨak menmen nɨpaa hɨr netpim hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hi etpi werek. Hɨm mei kike me Moses o me mɨt profet hɨram ap te mamɨwaank mamɨt ere tɨ mamtike nepni hɨram mamwep mamɨwaank mamɨt. Me wɨ im menmen yapɨrwe hɨram epei au mamɨsi mamɨt. ");
INSERT INTO avt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mɨt kerek neweikɨn sip newet hɨm mei kike me hɨm me Moses metike hɨm me mɨt profet, hɨr nanri han ke mɨt te hɨr nanisesi, mɨt in niuk mɨr meit wit ke God hɨram weinɨm. Te mɨt kerek hɨr nises hɨm me God werek werek neteikɨn mɨt han hɨr enisesim, maain niuk mɨr meit wit ke God hɨram iuwe. ");
INSERT INTO avt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hi hetpi werek. God katɨp menmen yaaim yi yisesim yɨrɨakem ap te maminɨn menmen mɨt ne Farisi netike mɨt iuwe ne Skraip kerek ninɨn nertei hɨm me Moses natɨp mɨt em hɨr nɨrɨakem, yi ap eitike God eiyu hɨrak naanmamri. Hi hetpi menmen im hentar mɨt ne Farisi netike mɨt ne Skraip hɨr ap te nanu nantike God taau! ");
INSERT INTO avt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nɨpaa ere in yi yemtau hɨm me God Moses kewisɨm mau tɨwei hɨram matɨp, ‘Yi mɨt ap einep mɨt han te hɨr nani au emɨt! Mɨtɨk kerek kenep mɨtɨk hak kaki, mɨt neiyɨk nanɨno mɨtɨk iuwe gavman.’ ");
INSERT INTO avt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Te hi hetpi. Mɨtɨk kerek han enuk keriuwe kɨrak yinak, mɨt neiyɨk nanɨno nanɨr mɨt iuwe. Mɨtɨk kerek katɨp kɨrak yinak enum ketawɨnek, hɨr neiyɨk nanɨno nanɨr mɨtɨk iuwe gavman. Keimɨn katɨp kɨrak yinak enum katɨp hɨrak mɨtɨk enuk keweikɨn sip kewet God, te hɨrak naanempre hɨrekes te God ap kakwɨrek kakno si. ");
INSERT INTO avt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Wɨ ham ti eno wɨnak iuwe ke God ewenɨpi niuk mɨrak ewetɨwek menmen mɨt enwisɨm emɨntar kɨnaan me nan (alta), te ti eket han menmen enum ti hɨrɨak kit yinak em, ti ewis menmen mit emwaai en, ti ehinɨn eno etike kit yinak yi yewepnak yatɨp ere yi yekiyakɨt yau. Epei au, ti pɨke enen ehɨt menmen mit ewepwarem ewet God em ewenɨpi niuk mɨrak heriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mɨtɨk hak han enuk keriuwit hanhan keryit kakno mɨtɨk iuwe gavman kakɨtpɨwek kakɨswut hɨm, ti etikerek eitɨpakɨt menmen ere yi han yaaik eiyu, o au en, yi yɨnapɨn mɨtɨk iuwe, hɨrak kakɨswut hɨm te mɨtɨk iuwe gavman kakriuwetit ti eno his me mɨt hɨr naanmɨpre wɨnak enuk, te hɨr nanwisit ekɨkrerek. ");
INSERT INTO avt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ti ehu en ere ti pɨke ewetɨwek pewek emrer mɨrak ere werek, o au en, ti ehu ehɨt. ");
INSERT INTO avt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nɨpaa ere in yi yemtau hɨm me God Moses kewisɨm mau tɨwei hɨram matɨp, ‘Yi ap eiriyan his eiwenɨnem au emɨt!’ ");
INSERT INTO avt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Te hi hetpi. Mɨtɨk kerek kɨr mɨte naanmɨrewe hɨrak hemkre menepam hanhanep, hɨrak epei kɨwaai ketikerep kekre han kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Menmen ti hɨrem heriuwe nanamɨr kit ke his yaaim mari han kit ti hɨrɨak menmen enum, ti eketim ewɨrem. Ti eket nanamɨr kit te ti ehu werek eno wit ke God hɨram yaaim. Hɨram enum te ti nanamɨr kit hɨrak kepu werek te kakri han kit te God kakwɨrit ti eno si. ");
INSERT INTO avt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","His mit yaaim em hɨram mises han kit mɨrɨak menmen enum, ti ehɨt hɨne eremir ewɨrem. Ti eremir his ewɨrem te ti ehu werek eno wit ke God hɨram yaaim. His mit yaaim mepu werek te ti hɨrɨak menmen enum ti eno si hɨram enum. ");
INSERT INTO avt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nɨpaa ere in yi nepei yemtau hɨm me God Moses kewisɨm mau tɨwei matɨp, ‘Mɨtɨk kerek kesiuwe mɨte pɨrak wauno waunaiwɨrek, hɨrak kakwetɨwe tɨwei hɨram matɨp nɨpaa hɨre mɨte pɨrak te in ek au hɨrak kepɨrep wen.’ ");
INSERT INTO avt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Te in ek hi etpi. Mɨtɨk kerek kepɨr mɨte pɨrak wɨnaiwɨrek, te hɨre ap wɨrɨak menmen enum wetike mɨtɨk hak au, hɨrak kenipep weweikɨn sip wewet hɨm me God, me wɨ hɨre pɨke wawɨt mɨtɨk keiyak. Mɨtɨk kerek ketikerep hɨr nanɨtan, hɨrak keweikɨn sip kewet hɨm me God ketikerep. ");
INSERT INTO avt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nɨpaa ere in yi yemtau hɨm me God Moses kewisɨm mau tɨwei matɨp, ‘Yi ap eiweikɨn sip eiwet hɨm nɨpaa yi yatɨp God. Au, yi eiyisesim.’ ");
INSERT INTO avt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Te hi hetpi. Yi ap eitɨp hɨm ham me menmen me God mamkaap hɨm mi yi yatɨp mɨt em te yi eiyisesim au emɨt! Yi ap eitɨp ‘Tru antap’ au emɨt eiyɨntar hɨrak wit ke God. Yi ap eitɨp menmen me tɨ mamkaap hɨm mi yi yatɨp mɨt em au emɨt eiyɨntar tɨ hɨram mɨre yeno me God hɨrak kewis hɨt mentɨram. Yi ap eitɨp menmen me wit Jerusalem mamkaap hɨm mi yi yatɨp mɨt em au emɨt eiyɨntar hɨrak wit kerek Mɨtɨk Iuwe God kau ketike mɨt. Yi yatɨp mar im yi yatɨp niuk me God. Hɨram enum emɨt! ");
INSERT INTO avt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yi ap eitɨp menmen me paan ki mamkaap hɨm yi yatɨp mɨt em au emɨt eiyɨntar yi ap te eirɨak paan kei kiutɨp o yapɨrwe mau hesnu ki mamre hike o nɨpɨak taau. God kerekek kakrɨakem te hɨram mɨre ti atɨp niuk me God. ");
INSERT INTO avt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yi yatɨp mɨt yi eirɨak menmen yi eitɨp, ‘O, hi arɨakem,’ o ‘Au, hi hɨnapen.’ Yi eitɨp hɨm meiyam mamkaap hɨm mi te hɨr nertei yi eiyisesim, hɨram menmen enum meke Seten man. Menmen im enum emɨt! ");
INSERT INTO avt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nɨpaa ere in yi yemtau hɨm me God Moses kewisɨm mau tɨwei hɨram matɨp, ‘Mɨtɨk keketut nanamɨr kit ti eketɨwek kɨrak. Mɨtɨk kenektɨnut yehes kit, ti enektɨnɨwek kɨrak.’ ");
INSERT INTO avt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Te in ek hi hetpi yi ap te einep mɨt mamrer me menmen mi enum nɨpaa hɨr nerekyiyem au emɨt! Mɨtɨk kitep ken tekep pɨnam, ti eteiknɨwek pɨnam hɨrak ekitep ekwim. ");
INSERT INTO avt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mɨtɨk kerek keryit kakno mɨtɨk iuwe gavman kakmitetpɨn kakɨtpɨwek enum me menmen yaaim ti hɨrɨakem, te hɨrak kakɨt pewek mei mit ti ewetɨwekem emriuwe tanɨk. ");
INSERT INTO avt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mɨt iuwe ne gavman nan nanitihi yi einenor menmen mɨr eiyɨm eino menep in, yi ap han enuk eikepi eiyɨm eino menep in au emɨt. Yi eiyɨm eino yanɨmɨn. ");
INSERT INTO avt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mɨtɨk kerek kituthi me menmen mit, ti ewetɨwekem. Mɨtɨk kerek hanhan kakri menmen mit me wɨ im te maain hɨrak pɨke kakwetut mei mɨrak mamrerim, ti ewenɨwekhi ewetɨwekem. ");
INSERT INTO avt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nɨpaa ere in yi yemtau hɨm me God Moses kewisɨm mau tɨwei hɨram matɨp, ‘Yi hanhan yeriuwe ni yinan, te yi han enuk yeriuwe mɨt enun nepan ni.’ ");
INSERT INTO avt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Te hi hetpi yi hanhan yeriuwe mɨt enun nepan ni, yi eiyitehi God hɨrak ap skelim mɨt kerek nerekyi enum, hɨrak ekrekyor menmen yaaim. ");
INSERT INTO avt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yi yɨrɨak menmen mar im te yi eirɨak menmen eiyɨr ke haai ki God keit wit kɨrak hɨrak kɨrɨakem. Hɨrak kenip wepni kɨr kɨkaap mɨt yaain netike mɨt enun nɨrɨak enum. Hɨrak kɨrɨak hawɨ kan kɨkaap mɨt yaain, mɨt au enun. ");
INSERT INTO avt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yi mɨt hanhan yeriuwe mɨt kerek hanhan neriuwi te mɨt han au, yi han kitet God kakweti menmen yaaim a? Taauye! Mɨt enun nari pewek me takis hɨr nɨrɨak menmen mar im. Hɨram menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yi mɨt yenɨne mɨt han ni yinan hɨr yaain te mɨt han au yi han kitet God kakweti menmen yaaim a? Taauye! Mɨt ap ne weiwɨk me Isrel ap nises God hɨr nɨrɨak menmen im. Hɨram menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yi yɨrɨak mɨt ni enun nepan yaain, te yi yaain eiyɨr ke Haai ki God keit wit kɨrak hɨrak yaaik. ");
INSERT INTO avt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Yi naanempre hɨras te yi ap eirɨak menmen yaaim te mɨt nanri nanwenɨpi niuk mi nantɨp yi yaain au emɨt. Yi yɨrɨak menmen mar im te Haai ki God keit wit kɨrak kau niu hɨrak ap kakweti menmen yaaim menterim taau. ");
INSERT INTO avt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wɨ yi eiwet mɨt kerek hɨr netenen menmen auri eiwetɨr menmen, yi ap eiwepyapɨr menmen yi yɨrɨakem au emɨt! Mɨt enun newisesik hɨr newet mɨt menmen, hɨr newepyapɨrem neit yayiwe o nekre wɨnak kerek mɨt nekine hɨm me Moses nekrerek, te mɨt nanɨr menmen hɨr nɨrɨakem nanwenɨpi niuk mɨr nanriuwerem. Hi hetpi werek, maain God ap kakwetɨr menmen mamrerim kakɨt wit kɨrak kakɨntar mɨt nepei netpɨwek hɨm yaaim me menmen hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yi eiyises menmen mɨr au emɨt! Yi eirɨak menmen eikaap mɨt, te yi eirɨakem eisawɨnem te mɨt ni yinan o mɨt han ap te nanɨrem taau. ");
INSERT INTO avt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yi eirɨakem eisawɨnem te Haai ki God kerek kɨr menmen yi yɨsawɨn yɨrɨakem, hɨrak kakweti menmen yaaim mamrerim. ");
INSERT INTO avt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wɨ kerek yi yitehi God menmen yi ap eirɨakem eiyɨr ke mɨt enun newisesik hɨr nɨrɨakem. Hɨr hanhan nerp nekre wɨnak kerek mɨt nekine hɨm me Moses nekrerek, o hɨr nerp yayiwe nitehi God menmen te mɨt nanɨri han kitet hɨr yaain nanwenɨpi niuk mɨr. Hi hetpi werek, maain God kakwetɨr menmen mamrerim kakɨt wit kɨrak taau. ");
INSERT INTO avt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wɨ kerek yi yitehi God menmen, yi eino haau ke wɨnak iyepet weipɨr eiyitehi God kerek mɨt ap nɨrek, yi eitɨwekhi menmen. Te maain Haai ki God kerek kɨr menmen yi yɨsawɨn yɨrɨakem hɨrak kakweti menmen yaaim mamrerim. ");
INSERT INTO avt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Yi yitehi God menmen, yi ap eitɨp hɨm weinɨm yapɨrwe eiyɨr ke mɨt ap nertei God nerer wit wit ap ne Isrel hɨr nɨrɨakem au emɨt. Hɨr han kitet God kakɨmtau menmen mɨr kakɨntar hɨr netpɨwek neriuwe hɨm yapɨrwe nokim nokim. ");
INSERT INTO avt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yi ap eiyises menmen hɨr nɨrɨakem eiyɨntar Haai ki God nepei kertei menmen yi yaitɨwem te maain yi yayu werek. ");
INSERT INTO avt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Yi eitɨwekhi menmen yi eitɨp yayɨr ik: ‘Haai kaiu God, ti kerek heit wit kit heven, ti niuk mit iuwe te ti enip mɨt hɨr nanwenɨpi niuk mit. ");
INSERT INTO avt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Haiu mituthi te ti enen ehinɨn naanmamprai haiu mɨt, te haiu mɨt yapɨrwe emises han kit mamɨr ke mɨt ensel neit wit kit heven hɨr nises han kit. ");
INSERT INTO avt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Petepin ti ewetai menmen mei te haiu mamɨm. ");
INSERT INTO avt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ti esak menmen enum haiu mɨrɨakem mamɨr ke haiu mesak menmen enum me mɨt nerekyeiyem haiu matɨp, Hɨram menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ti ap ewis menmen enum mamri han kaiu haiu mamrɨak enum au emɨt! Ti naanemprai me menmen enum.’ ");
INSERT INTO avt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Eiyɨmtau. Yi eiyɨsak menmen enum mɨt nerekyiyem yi ap han ekitetim, yi eitɨp hɨram menmen weinɨm, te Haai ki God hɨrak kakɨsak menmen enum mi. ");
INSERT INTO avt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yi ap eisak menmen enum me mɨt nerekyiyem au, te Haai ki God ap kakɨsak menmen enum mi. ");
INSERT INTO avt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Wɨ kerek yi yɨnaain menmen nɨnpɨ mamiwei te yi eiyitehi God menmen, yi ap eiwen toni emu ninaan mi eiyɨr ke mɨt enun newisesik nɨrɨakem au emɨt! Hɨr newen toni mau ninaan mɨr te mɨt yapɨrwe nanɨri hɨr han kitet hɨr yaain hɨr newenɨpi niuk mɨr menterim. Hi hetpi werek, maain God ap te kakwenɨpi niuk mɨr taau. ");
INSERT INTO avt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Wɨ kerek yi yɨnaain menmen yi nɨnpɨ miwei te yi eiyitehi God menmen, yi ap eiwen toni waniu (o wein) au emɨt! Yi eikɨr eiwepep paan te mɨt han ap nertei yi nɨnpɨ miwei yitehi God. Te God Haai ki kerek mɨt ap nɨrek au, hɨrak kertei menmen yi yɨsawɨn yɨrɨakem, te maain hɨrak kakweti menmen yaaim menterim. ");
INSERT INTO avt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yi ap eiri menmen mei yapɨrwe me tɨ im naanemprewem meit wɨnak ki au emɨt! Mesik, metike wesiun merermirɨr laplap, nɨ o heiniut mamwim te menmen mamwepep, o mɨt enun nanɨnen nanwep wɨnak nankintɨp menmen im. ");
INSERT INTO avt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Au, yi yɨrɨak menmen yaaim te God kakweti menmen mɨrak yaaim meit wit kɨrak. Menmen hɨrak kakwetaiyem, mesik, wesiun o heiniut mamɨnterim ap te mamɨwaank menmen im au, mɨt enun ap te nanɨnen nantɨwem taau. ");
INSERT INTO avt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Menmen mɨt han kitet hɨram mamkepi nanu werek, han kɨr kakisesim. Te yi han ekitet menmen me tɨ au emɨt! Menmen me God keremem. ");
INSERT INTO avt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nanamɨr ki hɨrak kɨre si kakɨkaap yɨnk ki. Nanamɨr ki yaaik te yi yayɨr menmen werek werek. Han ki hɨrak kɨre nanamɨr. Yi han kitet menmen yaaim, yi eiyises God werek werek. ");
INSERT INTO avt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Te nanamɨr ki hɨrak enuk toto te yi ap eiyɨr menmen werek werek au. Han ki kekre yɨnk ki hɨrak kises menmen enum, hɨram mɨre toto, te menmen im mekrerek hɨram mamriwaank. ");
INSERT INTO avt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mɨtɨk ap kakises menmen wik werek werek au. Hɨrak hanhan mɨtɨk kiutɨp, hɨrak kaknapen keiyak. Hɨrak kakɨkaap mɨtɨk kiutɨp, hɨrak kakweikɨn sip kakwet keiyak. Yi han ki kakɨnke kakɨntar pewek ap te yi eiyises God werek werek au. ");
INSERT INTO avt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Te hi hetpi. Yi ap han kakitet yapɨrwe me menmen yi yayɨm te yi yayu werek, o menmen yi eimɨr emu yɨnk ki au emɨt! Han ki kinɨn menmen yi yayɨm, yɨnk ki kinɨn klos yi yaimɨr. God keweti yɨnk ki ketike han ki kekrerek te yi eiyisesik. Hɨrak naanmampri me menmen te yi eiyu werek werek. ");
INSERT INTO avt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yi eiyɨr hore hɨram meniuwe men in men ein. Hɨram ap mamɨr ni mei o meket teket mei men mewisɨm mekre weisaak au. Te Haai ki God hɨrak naanmɨprewem. Yi yinɨn hore yapɨrwe te God naanmampri. ");
INSERT INTO avt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mɨtɨk kei kiutɨp kekre nɨmɨn ke yi mɨt han kitet yapɨrwe te kakrɨak menmen mamkepik hɨrak kaku wɨ meiyam o tito yapɨrwe a? Taauye! ");
INSERT INTO avt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Yi ap hanhan yeriuwe menmen yi eimɨr au emɨt. Yi yayɨr timen hɨram mewo meit yayiwe. Hɨram ap mekerwo laplap o mesikek yɨwaap au. ");
INSERT INTO avt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Te hi hetpi. Nɨpaa mɨtɨk iuwe King Solomon hɨrak kamɨr klos mɨrak yaaim, te klos mɨrak ap yaaim mar ke timen im au. ");
INSERT INTO avt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God kerekek hɨrak kenip yenkis timen weinɨm hɨram mɨre yaaim. Te hɨram mepu petepin, teipmen hɨram mami te mɨt nanɨsiyem. Yi yinɨn timen te God naanmɨprewem werek werek hɨrak naanmampri. Yi ap yises hɨm me God werek werek au. ");
INSERT INTO avt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Te yi ap han ekitet emɨr im: ‘Maain hi ehɨt menmen mamtike tɨpar mamɨt nein te hi hahɨm o hi ehɨt klos mamɨt nein te hi emɨr? Menmen mar im au emɨt.’ ");
INSERT INTO avt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yi ap han kitet menmen im au eiyɨntar mɨt ap ne weiwɨk mi Isrel kerek ap nises God hɨr hanhan neriuwe menmen im wɨsenum. Yi ap han ekitet menmen eiyɨr ke hɨr han kitetim eiyɨntar God hɨrak Haai ki nepei kertei menmen yapɨrwe yi eitɨwem te yi eiyu werek werek. ");
INSERT INTO avt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Te yi mɨt miyapɨr yinɨn hanhan eiyises God hɨrak kinɨn naanmampri te hɨrak kakrekyi yi yaain. Yi yɨrɨak menmen im te God naanmampri me menmen meiyam te yi eiyu werek. ");
INSERT INTO avt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","God naanmampri me menmen meiyam yi eiyu werek, te yi ap hanhan eiriuwe menmen teip hekrit hɨram mamnen. Menmen teiyɨp hekrit hɨram mamnen, yi ap yaiwenem taau. Hɨram mamnen. Te yi han ekitet me menmen enum petepin epei man naanempre hɨras me menmen im. ");
INSERT INTO avt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Yi ap skelim mɨt me menmen hɨr nɨrɨakem te God ap skelim yi mɨt me menmen me yi yɨrɨakem taau. ");
INSERT INTO avt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yi ap skelim mɨt eiyɨntar God skelim yi mɨt kakriuwe menmen yi yɨrɨak mɨt han em. Menmen yi yɨrɨak mɨt han em, God kakrekyiyem kakɨnterim. ");
INSERT INTO avt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ti henmak te ti hɨr kit yinak menmen kike mɨre yenkis yehes mekre nanamɨr kɨrak te ti hanhan ekinɨwekem mamnopɨn mamkeipnɨwek nanamɨr kɨrak, te ti ap hanhan ekin menmen wɨsenum mɨre nu heneik mekre nanamɨr kit a? ");
INSERT INTO avt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hɨram enum te ti atɨp kit yinak, ‘Ti ewisa hi ekinut menmen mekre nanamɨr kit emnopɨn emkeipɨn nanamɨr kit,’ te ti menmen wɨsenum mamsonut nanamɨr kit te ti ap ehɨr ein ein werek werek taau. ");
INSERT INTO avt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ti mɨtɨk enuk ewenɨn hɨm. Ti ehinɨn naanempre nanamɨr kit te maain ti ekaap kit yinak eriuwe nanamɨr kɨrak. Hɨram mar im: Ti ehinɨn eweikɨn sip ewet menmen enum mekre han kit te ti ehu werek. Maain ti ehu werek te ti ekaap kit yinak ekweikɨn sip ekwet menmen enum mɨrak kike. ");
INSERT INTO avt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yi ap eitɨp mɨt enun han kɨr enuk kɨre samiyak hɨm yaaim me God au emɨt! Yi eirɨakem hɨram mamɨr ke mɨtɨk kewɨr hore haam metike pitau (o yɨnɨ) o menmen yaaim mɨwaai tɨ, sak mamnen mamɨntɨrerim mamɨwaankem. Hɨram mamɨntɨrerim mamɨwaankem nepei au, hɨram mamweikɨn mamwɨr nɨkɨn mamiwep. ");
INSERT INTO avt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Yi eiyitehi God menmen te hɨrak kakwetiyem. Yi eiyɨneitɨn menmen me God te yi eiyɨrem. Yi eiyɨrp weipɨr eiket teruk te God kakɨkeiswiyek. ");
INSERT INTO avt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hi hetpi werek. Mɨt kerek nitehi God menmen hɨrak kakwetɨrem. Mɨt kerek nanɨnantɨn menmen me God hɨr nanɨrem. Mɨt kerek nerp weipɨr neket teruk, te God kakɨkeisworek. ");
INSERT INTO avt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mɨtɨk hak kekre nɨmɨn ke yi mɨt, nɨkan kɨrak kakitɨwekhi me niu o bret, hɨrak ap kakwetɨwek nan te hɨrak kakɨm au. ");
INSERT INTO avt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O nɨkan kɨrak kakitehi haai me saauk, hɨrak ap kakwetɨwek mɨniu han enuk (o neiyɨp han) o manpen siurp (o yenmik siurp) enuk te kakɨm taau. ");
INSERT INTO avt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yi mɨt kerek yi enun yi yertei yewet nɨkerek ni menmen yaaim. Te Haai ki God kerek keit wit kɨrak Heven hɨrak yaaik wɨsenuk kakɨkaap mɨt kerek nanitɨwekhi me menmen yaaim hɨrak kakwetɨrem hɨram mamkepi. ");
INSERT INTO avt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Te hi hetpi. Yi eiyinɨn eirɨak mɨt miyapɨr menmen yaaim yi hanhan te hɨr pɨke nanrekyiyem. Menmen im hi hetpi yi eirɨakem hɨram mises menmen yapɨrwe mɨtɨk Moses ketike mɨt profet hɨr newisɨm mau tɨwei hɨram matɨp yi eiyisesim. ");
INSERT INTO avt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Yi eiyitet weipɨr kike eiyɨntar ya weipɨr ke wit si enum hɨrak kɨhi iuwe, yayiwe kɨpɨrak, mɨt miyapɨr yapɨrwe nitetik. ");
INSERT INTO avt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Te weipɨr kerek mɨt miyapɨr nanitetik te hɨr hɨmɨn kɨr kaku werek, hɨrak au kɨhi kike, ya enuk kike, mɨt miyapɨr niutɨp niutɨp keriyen nanitetik. ");
INSERT INTO avt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Yi mɨt miyapɨr yi naanempre hɨras me mɨt profet enun nemipɨn. Hɨr nanɨnen nanmitipɨn nanriuwe hɨm mɨr te yi han kitet hɨr mɨt yaain God keriuweti nan netpi menmen. Te han kɨr enuk hɨr nemipɨn nanriwaank me menmen me God yi yisesim. ");
INSERT INTO avt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yi eiyɨrtei hɨr yaain o enun nanriuwe menmen hɨr nanrɨakem. Nu teketuk ap te mamri mamɨr ke hɨnaan nɨkim au. Waai wakɨn ap te mamri mamɨr ke tuwaan au. ");
INSERT INTO avt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nu yaaim hɨram mamri nɨkim yaaim. Nu enum ap mɨre yaaim te mamri nɨkim yaaim au. Enum keremem. ");
INSERT INTO avt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nu yaaim ap te mamri nɨkim enum au. Nu enum ap te mamri nɨkim yaaim taau. ");
INSERT INTO avt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nu mei enum ap mine nɨkim yaaim, mɨt nanman nanwɨrem mamno si. ");
INSERT INTO avt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Te hi hetpi werek. Yi eiyɨrtei mɨt kerek profet enun nemipɨn neriuwe menmen hɨr nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Yi ap han kitet mɨt yapɨrwe kerek nenewa hi Mɨtɨk Iuwe yaaik, hɨr nanre nɨkerek ne God. Au, hɨr mɨt miyapɨr kerek nises menmen Haai kai God hɨrak hanhan hɨr nanisesim, hɨr keriyen hɨr nɨkerek nɨrak. ");
INSERT INTO avt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wɨ maain God kakɨnke mɨt, hɨr yapɨrwe nanɨnen nanɨtpo, ‘Mɨtɨk Iuwe Yaaik. Haiu epei mekrehɨr kit haiu matɨp mɨt hɨm me God, haiu mepɨr herwe enum men mekeipɨn mɨt, haiu mɨrɨak menmen yaaim yapɨrwe nɨpaa mɨt ap nɨrem, haiu mɨkaap mɨt nɨnap o his hɨt enum ere hɨr nɨre yaain.’ ");
INSERT INTO avt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hɨr nanɨtpo menmen im te hi tewen ehɨtpor, ‘Hi hepɨtari yi neimɨn. Yi ap ne God au. Yi mɨt enun yɨrɨak enum yi einopɨn eikeipno!’ ");
INSERT INTO avt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mɨt miyapɨr kerek nemtau hɨm mai hɨr nanisesim hɨr nanɨr ke mɨtɨk yaaik kime wɨnak kɨrak kau kentɨr nan. ");
INSERT INTO avt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Maain hawɨ kan mani kɨniu nɨme yuwerep mɨniu wɨsenum te wɨnak kewen au. Hɨrak mɨtɨk kimaak kentɨr nan. ");
INSERT INTO avt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mɨt kerek nemtau hɨm hi hetpim hɨr ap nanisesim hɨr nanɨr ke mɨtɨk kime wɨnak kɨwaai tɨ kɨre tenhaan. ");
INSERT INTO avt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Maain hawɨ kaknen, mani kɨniu, nɨme yuwerep mɨniu, te wɨnak kewen. Wɨnak kewen mani kakɨp keiyɨk ken.” ");
INSERT INTO avt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas katɨp hɨm mɨrak epei au, mɨt miyapɨr yapɨrwe kerek nemtau menmen hɨrak ketpim, hɨr han kekrit neriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Hɨr han kekrit neriuwerem nentar hɨrak ap ketpor kar ke mɨt iuwe ne skraip kerek ninɨn nertei hɨm me Moses natɨp mɨt em. Au, hɨr nises hɨm me mɨt iuwe ne nɨpaa ein netporem. Te Jisas ketpor kar ik au. Hɨrak ketpor kar ke Mɨtɨk Iuwe God keriuwetek kan ketpor hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas kɨnaaiwɨr mɨniu (o neiyɨp) kekiuwe kan kesiyen, te mɨt yapɨrwe nisesik. ");
INSERT INTO avt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hɨrak kekiuwe ken kesiyen, mɨtɨk kerek enuk lepro mau yɨnk kɨrak ek kan kɨrek kewen ninɨp kau menep hɨt mɨrak, hɨrak han kitet hɨrak iuwe, hɨrak ketpɨwek kar ik: “Kai Iuwe, ti han kit ti ekepa hi are yaaik.” ");
INSERT INTO avt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hɨrak katɨp epei au, Jisas kesiuwe his metenenik hɨrak katɨp, “Hi han kai ekepit ti ere yaaik.” Hɨrak katɨp epei au, wasenum mɨtɨk enuk lepro mewik hɨrak kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hɨrak kɨre yaaik, Jisas ketpɨwek, “Ti ap eno etɨp mɨt han menmen hi herekyutem au emɨt! Ti eno wɨnak ke God eteikɨn mɨt pris yɨnk kit ewepwar menmen mar ke hɨm me Moses mau tɨwei metput ti hɨrakem. Ti hɨrɨak menmen im te hɨr nanɨrtei God kekepit ti hɨre yaaik.” ");
INSERT INTO avt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Maain Jisas ken kiun wit Kapaneam, mɨtɨk iuwe ke ami ke wit Rom kewenyipɨrek kitɨwekhi hɨm iuwe kar ik: ");
INSERT INTO avt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kai Iuwe, mɨtɨk kɨrɨak menmen mai hɨrak kɨnap kɨwaai wɨnak eik. His hɨt mɨrak epei au maa meit, yɨnk kɨrak kekek wɨsenum.” ");
INSERT INTO avt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas kewenhi ketpɨwek, “Hi tewen anen akepik te hɨrak kakre yaaik.” ");
INSERT INTO avt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te mɨtɨk iuwe ke ami ketpɨwek, “Mɨtɨk Iuwe, hi ap yaaik te ti enen enɨk wɨnak kai. Ti atɨp hɨm weinɨk kerekek te menmen enum mamnopɨn mamkeipɨn mɨtɨk kerek kɨrɨak menmen mai hɨrak ekre yaaik. ");
INSERT INTO avt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hi hises hɨm me mɨtɨk hak hɨrak kinɨna hɨrak iuwe naanmɨprau. Te hi hɨrekes naanmɨpre mɨt nai hi hinɨni. Te hi hatɨp mɨtɨk keiyak kiutɨp: ‘Ti eno,’ hɨrak kakno. Hi hatɨp keiyak: ‘Ti enen,’ hɨrak kaknen. Te hi atɨp mɨtɨk kerek kɨrɨak menmen mai em: ‘Ti erɨak menmen eim,’ te hɨrak kɨrɨakem. Hi hertei ti atɨp hɨm mit ehɨrp in, hɨrak kakre yaaik.” ");
INSERT INTO avt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas kemtau hɨm kerek mɨtɨk ik ek ketpim, hɨrak han kekrit kekrit keriuwerem. Te hɨrak katɨp mɨt miyapɨr kerek nisesik, “Hi ap nɨpaa hɨr mɨtɨk kei ke Isrel katɨp hɨm mar im kises God werek werek kar hɨrak kisesik au. Hɨrak kiutɨp kerekek.” ");
INSERT INTO avt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jisas wen katɨp: “Hi hetpi werek. Mɨt miyapɨr yapɨrwe nanɨnen nanrer wit wit nanises hɨm mai werek te hɨr nanu yeno nanɨm menmen nantike Ebraham, Aisak, tetike Jekop nanu nanɨt wit kerek God kewiyen. ");
INSERT INTO avt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Te mɨt miyapɨr kerek nɨpaa miyerer nɨr ninen hɨr ne Isrel hɨr ap nanisɨsa au, te maain God kakɨpɨri nanɨno wit enuk toto te hɨr nankɨt nanine han enuk nanɨneknen yehes mɨr nanu en.” ");
INSERT INTO avt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jisas ketpor epei au, hɨrak katɨp mɨtɨk iuwe ke ami ke Rom kerek kinɨn naanmɨpre mɨt han en, “Ti eno. Menmen mamnen mamɨr ke ti han kitet hɨram mamnen.” Hɨrak katɨp epei au, waswas wok mɨtɨk kɨrak hɨrak kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Maain Jisas kan wɨnak ke Pita eik, hɨrak kɨr Pita maam pɨrak kerek wine mɨte pɨrak hɨre wɨwaai yeno wɨnap yɨnk sisi. ");
INSERT INTO avt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas ken ketenen his mɨre, te hɨre wɨnap yɨnk sisi epei au, hɨre wɨre yaaip. Te hɨre wekrit wɨrɨak menmen me Jisas kakɨm. ");
INSERT INTO avt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Maain hɨnkewɨ, hɨr mɨt han neithis mɨt miyapɨr yapɨrwe kerek herwe enum mau mekre han kɨr, hɨr neriyei nan nɨr Jisas. Hɨrak kepɨr herwe enum im kriuwe hɨm hɨrak ketpim, hɨrak kɨkaap mɨt miyapɨr kerek nɨnap te hɨr nɨre yaain hɨr nanu werek. ");
INSERT INTO avt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hɨrak kɨrɨak menmen im te hɨm nɨpaa God katɨp Aisaia kewisɨm mau tɨwei hɨram nepei man. Hɨm im matɨp mar im: “Hɨrak kepɨr menmen enum merekyei haiu mɨnap en te haiu mɨre yaain.” ");
INSERT INTO avt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","In ek Jisas kɨr mɨt miyapɨr yapɨrwe nisesik neweiknɨwek te hɨrak katɨp mɨt nɨrak, “Haiu mɨt han emno wan pɨnak ein emnaaiwɨr mɨt in.” ");
INSERT INTO avt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hɨrak ketpor epei au, mɨtɨk hak ke skraip kerek ninɨn nertei hɨm me Moses natɨp mɨt em, hɨrak katɨp Jisas, “Hi apɨno wit kerek ti epnoriyen.” ");
INSERT INTO avt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas ketpɨwek, “Miyak ke niu hɨram mɨwaai mekre nu herkip. Hore hɨram mime yaank mau niu. Te hi Mɨtɨk ke wit ke Mɨtɨk Iuwe ap wɨnak kei kepu te hi eno ewaai ekrerek. Hi ap ewetut menmen au. Ti henmak te ti hanhan ehisɨsa?” ");
INSERT INTO avt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mɨtɨk disaipel hak katɨp Jisas, “Mɨtɨk Iuwe, ti ewisa hi ehinɨn ano ewis haai kai kerek kaki kakɨkre hei, te hi pɨke anen eisesit.” ");
INSERT INTO avt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te Jisas ketpɨwek, “Au ti ehisɨsa. Mɨt kerek ap nises hɨm mai hɨr enwisɨk kakɨkre hei.” ");
INSERT INTO avt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hɨrak katɨp epei au, Jisas kehɨn kɨniu ken kekre bot. Mɨt disaipel nɨrak hɨr nisesik. ");
INSERT INTO avt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hɨr nau nekre bot epei au, hɨr nerekir wan. Te yuwerep mɨniu mɨrɨak wan sɨr mɨniu mɨsawɨn bot, te Jisas hɨrak kɨwaai. ");
INSERT INTO avt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hɨrak kɨwaai hɨr nan nekotɨtek netpɨwek, “Mɨtɨk Iuwe ekepei! Bot epei kaknatɨn kakɨkre tɨpar kakno tɨ eik te haiu mami.” ");
INSERT INTO avt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisas ketpor, “Yenmak te yi yɨnapen? Yi mɨt ap han kitet menmen yaaim mai iuwe au a?” Hɨrak ketpor epei au te hɨrak kekrit katɨp kewen yuwerep te wasenum nɨme metike wan tɨpar mehɨhe mɨwaai meit. ");
INSERT INTO avt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Te mɨt neperper natɨpan, “Hɨrak mɨtɨk ik ek hɨrak kɨre keimɨn te nɨme metike wan memtau hɨm mɨrak te hɨrak katɨp yuwerep metike nɨme te hɨram mewɨre mɨwaai meit?” ");
INSERT INTO avt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ken kiun wan pɨnak ein, hɨrak tɨ ke mɨt ne wit Gadara. Hɨrak kiun ein, mɨtɨkɨt wik herwe enum mau mekreret kenipet hɨrakɨt tau tekre herwe hei te hɨrakɨt tan tewenyɨpɨr Jisas. Hɨrakɨt enukɨt tetaritari han ken sip tɨrɨak enum te mɨt miyapɨr nɨnaain hɨrakɨt tatnɨp te hɨr ap nanitet yayiwe kerek hɨrakɨt tewi en taau. Hɨrakɨt tewenyipɨrek hɨrakɨt ");
INSERT INTO avt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tɨnap tenɨne tar ik: “Nɨkan ke God, kenmak te ti han heraiwaank. Wɨ ap epei man wen au te ti han arekyei menmen enum hepɨrei mamno wit enuk kerek menmen mamwep!” ");
INSERT INTO avt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sak ham yapɨrwe maam menmen meit yanɨmɨn kike eik, ");
INSERT INTO avt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","te herwe enum mitehi Jisas, “Ti ehɨpɨrei, te eriuwetei emno emɨkre sak yapɨrwe eim e.” ");
INSERT INTO avt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas ketpor, “Yi eino.” Te hɨram menke mɨrɨr men mekre sak, te sak yapɨrwe keremem metaritari mɨrɨr men menke matɨn mɨniu (o neiyɨp) kerekek ere men mekre wan iuwe eik, tɨpar mekiuwe hɨm yipɨr mɨram hɨram maam tɨpar maa meit. ");
INSERT INTO avt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Epei au, mɨt kerek naanmɨpre sak em nɨrɨr nen wit iuwe nen natɨp mɨt han netpor menmen epei man metike menmen me mɨtɨkɨt wiketeret nɨpaa herwe mersɨset. ");
INSERT INTO avt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hɨr netpor epei au, mɨt miyapɨr ne wit iuwe nan nanwen yipɨr Jisas. Hɨr nɨrek hɨr nɨneinɨk te hɨr nitɨwekhi hɨm iuwe eknaaiwɨr wit kɨr, te hɨrak ekno wit hak. ");
INSERT INTO avt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mɨt natɨp epei au, Jisas kehɨn kɨniu ken kekre bot kerekir wan ken wit kɨrak eik. ");
INSERT INTO avt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hɨr mɨt han neit mɨtɨk hak his hɨt mɨrak epei maa meit, hɨr neiyɨk nan hɨrak kɨwaai yeno. Jisas kɨri hɨr han kitet hɨrak iuwe kakɨkaap mɨtɨk ik kakre yaaik, te hɨrak katɨp mɨtɨk kerek his hɨt maa meit em, “Kai yinak, ti enakɨn tokim. In ek hi esak menmen enum mit ti hɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jisas katɨp menmen im epei au, mɨt han ne Skraip, kerek ninɨn nertei hɨm me Moses natɨp mɨt em, hɨr natɨpan nar ik: “Mɨtɨk ik e hɨrak katɨp enum kekrehɨr ke God katɨp hi esak menmen mit enum.” ");
INSERT INTO avt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas kertei menmen hɨr han kitetim netpim te hɨrak ketpor, “Kenmak te yi han kitet yekre han ki hi nepei hatɨp enum a? ");
INSERT INTO avt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hi hatɨp mɨtɨk kɨwaai kentar kɨnaan, ‘Hi esak menmen enum nɨpaa ti hɨrɨakem, hɨram mamno,’ yi yepɨtari hi hatɨp werek auye. Te hi hatɨp mɨtɨk, ‘Ti hekrit etenen yeno eiyɨm eno,’ hɨrak kakɨkrit yeno, yi eiyɨrtei hi hatɨp werek te hi esak menmen enum me yi mɨt. Hi hetpi mekam te yi han ekiteta? ");
INSERT INTO avt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hi atɨp mɨtɨk ik har ik, ‘Ti ekrit eno,’ te yi eiyɨrtei hi Mɨtɨk ke wit ke Mɨtɨk Iuwe han tɨ ik e God kewisa hi ahɨsak menmen enum mɨt nɨrɨakem?” Hɨrak ketpor epei au, hɨrak katɨp mɨtɨk kerek his hɨt mɨrak maa meit em, “Ti ekrit ekin yeno mit eiyɨm eno wɨnak kit eik.” ");
INSERT INTO avt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hɨrak katɨp epei au, mɨtɨk ik hɨrak kekrit ken wɨnak kɨrak eik. ");
INSERT INTO avt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mɨt miyapɨr yapɨrwe hɨr nɨr menmen im hɨr neperper han kekrit neriuwerem. Hɨr nertei God kewis Jisas kɨkaap mɨt neriuwe menmen mɨrak iuwe, te hɨr newenɨpi niuk me God. ");
INSERT INTO avt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas kɨnaaiwɨr wit ik kerekek, hɨrak kakno, hɨrak kɨr mɨtɨk hak niuk mɨrak Matyu kau wɨnak kerek mɨt nari pewek me takis neitai en. Te Jisas ketpɨwek, “Ti ehisɨsa erɨak menmen mai.” Hɨrak katɨp epei au, Matyu kekrit kɨnaaiwɨr menmen mɨrak kisesik. ");
INSERT INTO avt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Maain Jisas kau yeno me wɨnak kɨrak eik ek kakɨm menmen, te mɨt enun kerek nari pewek me takis em hɨr netike mɨt han enun nises menmen enum nau wɨnak nanɨm menmen netike Jisas ketike mɨt nɨrak disaipel. ");
INSERT INTO avt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hɨr mɨt han ne Farisi, kerek han kitet hɨr ninɨn mɨt han nises hɨm me Moses, hɨr nɨr menmen im hɨr nitehi disaipel nar ik: “Kenmak te Mɨtɨk Iuwe ki kaam menmen ketike mɨt enun kerek nari pewek me takis netike mɨt enun nises menmen enum em?” ");
INSERT INTO avt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas kemtau hɨm im te hɨrak katɨp hɨm tok piksa mar im: “Mɨtɨk kɨnap hɨrak dokta kaku kaktikerek. Mɨtɨk hak han kitet hɨrak yaaik auye! ");
INSERT INTO avt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yi eino han ekitet hɨm hi ehɨtpiyem hɨram mau tɨwei me God. Hɨram matɨp, ‘Hi ap hanhan yi yaiwepwar samiyak menmen yaiwetewem au. Hi hanhan yi eirɨak mɨt miyapɨr yaaim.’ Hi ap han henɨne mɨt kerek han kitet hɨr mɨt yaain te hɨr enweikɨn sip enwet menmen enum enisɨsa au. Hi han hari han ke mɨt kerek hɨr nertei hɨr enun. Te hɨr enisɨsa.” ");
INSERT INTO avt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Maain mɨtɨk Jon disaipel nɨrak nan nɨrek nitɨwekhi, “Haiu metike mɨt ne Farisi me wɨ ham haiu mɨnaain menmen te haiu nɨnpɨ mewei haiu mitehi God. Te mɨt disaipel nit au. Hɨr nenmak?” ");
INSERT INTO avt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas ketpor hɨm tok piksa mar im: “Mɨtɨk hak kerek kakɨt mɨte ep hɨrak eku ektike nɨrak yinan te hɨr han yaaik. Maain wɨ mamnen te mɨtɨk kerek keit mɨte ep hɨrak kaknaaiwɨr mɨt nɨrak, te hɨr han enuk nɨnpɨ mamɨn nanɨt. ");
INSERT INTO avt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ap mɨtɨk keiyak keremir laplap kerek yaaim nɨmnam em kekerwewim mamu enum tokim kerek mewep em. Hɨrak kakrɨakem mamɨr em te maain hɨrak kakɨkemyetɨt, yaaim nɨmnam em mamuwep enum tokim em te mamuwep wɨsenum. ");
INSERT INTO avt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ap mɨtɨk keiyak keit tɨpar wain yaaim mɨrɨram keiyɨm kewenem mekre meme yɨnk mɨram kerek epei enum tokim em au. Hɨrak kakrɨakem mamɨr keremem te nap mamniu mamnan yɨnk mɨram te meme yɨnk mamwep mamriuwe nap mɨrak o tɨwerpek mɨrak te tɨpar mamno tɨ. Au, mɨt nanwenem mamɨkre yaaim wen petep hɨram mamu werek werek.” ");
INSERT INTO avt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas wen ketpor hɨm im keremem, mɨtɨk hak iuwe kerek kinɨn naanmɨpre mɨt han ne Isrel, hɨrak kan kewen ninɨp menep hɨt me Jisas kitɨwekhi kar ik: “Hi nɨki pai in ek epei waa wɨwaai weit, te ti enen ewis his mit emu yɨnk kɨre te hɨre wawɨkrit wawu.” ");
INSERT INTO avt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hɨrak katɨp epei au, Jisas ketike mɨt disaipel nɨrak nekrit nisesik nen. ");
INSERT INTO avt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Mɨte hap piutɨp winen hemkre hekrit hekrit ere tito hiswiyen wik (12) hɨre wisesik. Mekre han kɨre hɨre watɨp, “Hi hewis his emɨntar laplap mɨrak, te hi are yaaip.” Mɨte kerepep weke sip ke Jisas wan wewis his wetenen laplap hɨr mɨram kerek Jisas kamɨr em. ");
INSERT INTO avt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas keweikɨn kɨwaai nan kɨrep. Te hɨrak ketpɨwe, “Pai yina yaaip ti enakɨn tokim. Ti han kitet hi iuwe te hi akepit ti hɨre yaaip.” Jisas katɨp epei au, waswas hɨre wɨre yaaip. ");
INSERT INTO avt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jisas kan ere kiun wɨnak ke mɨtɨk iuwe kerek kinɨn naanmɨpre mɨt. Hɨrak kɨpiun ein, hɨrak kɨr mɨt neremɨm heurek em netike hɨr mɨt miyapɨr yapɨrwe nesikeyaanmi nɨkɨt nɨki pɨrak nepei waa. ");
INSERT INTO avt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisas kɨri hɨrak ketpor kar ik: “Yi einepɨn eikeipnɨwe ap eikɨtep au emɨt! Hɨre ap waa au. Hɨre wɨwaai kerepep.” Hɨrak ketpor kar ek, te hɨr yapɨrwe nenwesɨsek enum wɨsenum. ");
INSERT INTO avt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hɨr nan nepɨr mɨt miyapɨr netpaan nen epei au, te Jisas kɨnɨk ken haau nɨki wɨwaairiyen ketenen his mɨre te hɨre wekrit. ");
INSERT INTO avt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hɨm me menmen im em kerek Jisas kɨkaap nɨki ip e men merer wit wit. ");
INSERT INTO avt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas kɨnaaiwɨr wit kerek ek ken. Hɨrak kitet yayiwe te mɨtɨkɨt wiketeret kerek nanamɨr toto tisesik tenɨnewek tatɨp, “Ti nepenyek ke Devit, ti hanhan heriuwawɨr.” ");
INSERT INTO avt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas ken kɨnɨk ken wɨnak, te mɨtɨkɨt wiketeret nanamɨr toto ten tɨrek. Jisas ketpɨwekɨt, “Yi wiketeret yekre han ki yatɨp hi te werek arekyi yi eire yaaikɨt?” Hɨrakɨt tatɨp, “Ti Mɨtɨk Iuwe te ti werek.” ");
INSERT INTO avt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Te Jisas kewis his menterwekɨt nanamɨr kɨrakɨt hɨrak katɨp: “Hi erekyi yi yaaikɨt hentar yi han kiteta.” ");
INSERT INTO avt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Te nanamɨr kɨrakɨt kɨr. Jisas ketpɨwekɨt hɨm manp kar ik: “Yi wiketeret naanmɨpre hɨrekses te mɨtɨk keiyak kakɨrtei menmen im em au.” ");
INSERT INTO avt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hɨrakɨt ten wit eik tises menmen hɨrak ketpɨwekɨtem au. Hɨrakɨt ten terer wit wit tatɨp mɨt menmen Jisas kerekyɨwekɨtem. ");
INSERT INTO avt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hɨrakɨt tepno te mɨt han neit mɨtɨk enuk han aurek, herwe kau kekrerek neiyɨk nan Jisas. ");
INSERT INTO avt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kewaai meruri Jisas kepɨr herwe enum, mɨtɨk enuk han aurek kewepnak katɨp, te mɨt nerp en hɨr han kekrit neriuwerek, hɨr natɨp, “Ap nɨpaa mɨtɨk ap kɨrɨak menmen kar ik keit wit kaiu Isrel.” ");
INSERT INTO avt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Te mɨt han ne Farisi natɨp, “Mɨtɨk iuwe Seten kerek kinɨn naanmɨpre herwe yapɨrwe, hɨrak kɨkaap Jisas kepɨr herwe im e.” ");
INSERT INTO avt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Epei au, Jisas ken kerer wit iuwe wit kike ken kekre wɨnak kerek mɨt hɨr nererik nekine hɨm me Moses mau tɨwei. Hɨrak ken en katɨp hɨm yaaim me God kaknen naanmɨpre mɨt. Hɨrak kɨkaap mɨt miyapɨr yapɨrwe hɨr nɨnap his hɨt enum, nanamɨr toto, menmen ham te hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hɨrak kɨr mɨt miyapɨr nererik nau en, te hɨrak han tewenɨni kentar hɨr nepu enum han kekrit nɨnapen menmen ham nɨre sipsip mɨtɨk ap naanmɨprewem. ");
INSERT INTO avt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hɨrak kɨri epei au, hɨrak katɨp mɨt disaipel nɨrak kar ik: “Mɨt in hɨr nɨre menmen mau ni epei yaaim te ap mɨt nei nepu te hɨr nanɨno nantɨwem. ");
INSERT INTO avt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yi eiyitehi haai ke ni im te hɨrak kakriuwet mɨt nanɨkrerem te hɨr nanɨthis mɨt miyapɨr nanri han kɨr te hɨr enisesik.” ");
INSERT INTO avt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas kenɨne mɨt nɨrak disaipel nar hiswiyen wik (12), hɨr nan nererik. Hɨr nan nererik, hɨrak kewetɨr menmen mɨrak iuwe hɨr nekrehɨr kɨrak nanɨno nanɨpɨr herwe enum nankaap mɨt miyapɨr hɨr nɨnap his hɨt enum nanamɨr toto, menmen ham te hɨr nanɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Im em hɨram niuk me aposel nar hiswiyen wik (12) nɨrak. Saimon kerek niuk mɨrak ham Pita, hɨrak kinɨn ketike nɨkik kɨrak Endru. Hɨrakɨt tetike Jems ketike nɨkik kɨrak Jon hɨrakɨt nɨkerek hɨrakɨt te Sebedi. Hɨrakɨt tetike Filip, Batolomyu, Tomas, Matyu kerek keitɨt pewek me takis. Hɨr netike Jems itai kɨrak, hɨrak nɨkan ke Alfias, Tadias, Saimon kerek kises hɨm me mɨt Selot. Hɨr netike Judas ke wit Keriot, mɨtɨk kerek kewepyapɨr Jisas te hɨr mɨt enun neiyɨk nen nakɨp. Mɨt in keriyen hɨr mɨt nɨrak aposel. ");
INSERT INTO avt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas keriuwet mɨt in nar hiswiyen wik (12) nen, hɨrak kinɨn ketpor hɨm im: “Yi ap eino eiyu eitike mɨt ap ne weiwɨk me Isrel o mɨt nau nerer wit wit ke Sameria. ");
INSERT INTO avt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Au, yi eino mɨt ne Isrel keriyen. Hɨr mɨt miyapɨr han hɨr nɨre sipsip mɨtɨk ap naanmɨpror te hɨram mɨrɨr mɨsawɨn meit yaank. ");
INSERT INTO avt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yi wen eino ein yi eiwepyapɨr hɨm im: ‘God menep hɨrak kakteiknai kakɨrkeik te hɨrak kakinɨn naanmamrai haiu mɨt.’ ");
INSERT INTO avt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yi eikaap mɨt miyapɨr nɨnap hɨr enɨre yaain, yi eikɨan mɨt miyapɨr naa te hɨr pɨke nanɨkrit. Yi eikaap mɨt miyapɨr lepro mewi hɨr enɨre yaain. Hi eweti menmen mai iuwe im hɨram weinɨm te yi eiyɨm eikaap mɨt han eiriuwerem, yi ap te eiyɨt pewek mamrerim au emɨt. ");
INSERT INTO avt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Yi ap eitenen pewek mei mamɨkre tanɨk mi au emɨt! Yi ap eitenen tanɨk iuwe yi eiwis menmen mekrerem au. Yi ap eiyɨt teipe o samiyak o hɨne yipo henmik au. Yi eiyɨhis eino eiyɨntar yi mɨt kerek yɨrɨak menmen me mɨt han, hɨr enkepi naanempri me menmen. ");
INSERT INTO avt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ewaai meruri yi eino wit iuwe o kike, yi eino eiyɨneitɨn mɨtɨk hak yaaik hanhan naanempri me menmen. Yi eiyu eitikerek ere yi pɨke einaaiwɨr wit. ");
INSERT INTO avt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ewaai meruri yi eino wɨnak ke mɨtɨk hak, yi eitɨp mɨt en eiyɨr ik: ‘God kaku kaktikewi naanmampri.’ ");
INSERT INTO avt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mɨt miyapɨr in hɨr yaain te hɨm mi mamu mamtikeri God kakɨkepi, o au en, hɨm nɨpaa yi yetporem hɨram pɨke mamu mamtikewi te God ap kakɨkepi. ");
INSERT INTO avt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yi eino te mɨt han ap naanmampri me menmen o nɨnapen nanɨmtau hɨm mi yaaim yi yetpim, te yi einopɨn eikeipɨn wɨnak o wit kɨr, yi einepep toni waniu (o win) mau hɨt mi eiteiknor God han enuk keriuweri. ");
INSERT INTO avt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hi hetpi werek. Maain wɨ God skelim mɨt, hɨrak God kaknep mɨt miyapɨr enun nɨpaa nau Sodom ketike wit Gomora kaknɨp kike. Te mɨt miyapɨr kerek nanweikɨn sip nanwet hɨm mi, maain God kaknɨp iuwe kaknepi. ");
INSERT INTO avt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Yi eiyɨmtau. Hi ariuweti yi eino eiyɨkre nɨmɨn ke mɨt enun eiyɨr ke mɨtɨk hak kaksiuwe sipsip hak kakno kakɨrp nɨmɨn ke nepere enum me yaank. Hɨram hanhan mamkɨp mamɨk. Yi naanempre hɨras me menmen yi eirɨakem eiyɨr wɨnɨni naanmɨpre hɨremes me wɨ mɨt nanmɨp hɨram mɨrɨr. Yi eirɨak menmen yaaim eikaap mɨt eiyɨr ke tɨpar nemnok mamkaap mɨt. ");
INSERT INTO avt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Te yi naanempre hɨras me mɨt enun. Hɨr nantihis nanɨswi yi eino eiyɨr kaunsil kɨr, te hɨr nanɨt nɨpɨn neiyɨk naniwep nanɨt wɨnak kerek mɨt nekine hɨm me Moses nekrerek. ");
INSERT INTO avt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hɨr nantihis nanri nanɨno ninaan me mɨt iuwe o mɨt ne gavman nanɨntar yi yisɨsa. Te yi eiwepyapɨr hɨm mai yaaim eitɨp mɨt iuwe nantike mɨt ap ne weiwɨk me Isrel eitpor hɨm mai. ");
INSERT INTO avt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Maain hɨr nantihis nanri yi eino eiyɨrp ninaan me mɨt, yi p einapen han ekitet menmen yi eiyɨtpim maamkaap yɨnk ki au emɨt! Wɨ im mamnen God kakweti hɨm mɨrak yaaim. ");
INSERT INTO avt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Te God Hɨmɨn Yaaik kakweti hɨm mɨrak yaaim te hɨrak kakɨkepi yi eitɨp hɨm mɨrak. Hɨm mi au. ");
INSERT INTO avt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Heiyiuwerer nanwepyapɨr kikrek hɨr nansiuweri te mɨt nanɨnɨp nani. Haai kakwepyapɨr nɨkan kɨrak kaksiuwerek te mɨt nankɨp kaki. Nɨkerek nanwepyapɨr miye haai nɨr, te mɨt nanɨnɨp nani. ");
INSERT INTO avt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mɨt yapɨrwe hɨr nanɨneini nanɨntar yi yisɨsa, te neimɨn hɨr nanisɨsa ere hɨr mɨt nanɨnɨp hɨr nani, maain hi etorhis hɨr nanu nantikewa. ");
INSERT INTO avt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Maain hɨr mɨt nerekyi enum neit wit hak, yi eirɨr eino wit hak yaaik eiwi. Hɨr mɨt en nanrekyi enum neit wit hak yaaik yi yewi, te yi pɨke eirɨr eino wit hak. Hi hetpi werek yi ap eino eirer wit wit mɨt ne Isrel newi en ere hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke enen. ");
INSERT INTO avt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sumatin hak ap te kakɨrtei menmen kakinɨn tisa kɨrak au. Wok mɨtɨk ap te kakinɨn mɨtɨk kerek hɨrak kerekyɨwek menmen mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Au, mɨt sumatin o wok mɨtɨk hɨr han yaaik menmen enum nanɨwaanki nanɨr ke menmen enum nanɨwaank tisa kɨr o mɨtɨk iuwe kɨr. Mɨt epei nenewa hi Bielsebul hɨram niuk mei enum me Seten, te hi hɨre Haai. Maain yi mɨt kerek yisɨsa yi yɨre nɨkerek nai, hɨr nanewi hɨm enum enum. ");
INSERT INTO avt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","27","“Te yi ap einapen mɨt au. Menmen yapɨrwe in ek hɨram mɨsawɨn meit, maain mɨt nanɨrteiyem hɨram mamnen mamu yaain. Menmen hi hɨsawɨn hetpiyem yi maain eiyɨrp wit iuwe eiwepyapɨrem eitɨp mɨt em. ");
INSERT INTO avt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yi ap einapen mɨt kerek naniwep yi yayi eiyɨntar hɨr ap te nanɨnepi hɨmɨn ki au. Yi einapen hɨrak God kerek kakiwep epei au, hɨrak kakwɨr hɨmɨn ki kakno si tatɨkneni. ");
INSERT INTO avt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Yi mɨt han ki yi eiwɨr pewek kiutɨp yi eiyɨt hore wiketeri. Hɨre hore peiyap ap te wawi waunatɨn wawaai tɨ, te Haai kaiu ap kerteiyek au. Hɨrak kertei ye! ");
INSERT INTO avt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","God epei kertei paan marmenum mɨwapɨn paan hesnu ki. ");
INSERT INTO avt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Te yi ap einapen menmen au. Yi yinɨn hore yapɨrwe, te God Haai kaiu hɨrak naanempri werek werek. ");
INSERT INTO avt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mɨt miyapɨr kerek nerp ninaan me mɨt han nanwepyapɨr hɨr nises hɨm mai, te maain hɨr nanɨrp ninaan me Haai kaiu, hi etpor hɨr yaain nises hɨm mai, hɨr mɨt nai. ");
INSERT INTO avt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Neimɨn au, te hi au. ");
INSERT INTO avt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yi ap han kitet hi han enip mɨt te hɨr enkiyan enu enɨt. Au, hi han ehɨnkeri. ");
INSERT INTO avt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hi han enip nɨkan ketike haai hɨrakɨt enukɨt tepan, o nɨki wetike miye pɨre, o yani wetike miye pɨre hɨr enun nepan. ");
INSERT INTO avt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mɨt miyapɨr ne weiwɨk me mɨtɨk hak hɨr netikerek nanɨr ke mɨt enun nepan. ");
INSERT INTO avt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mɨt miyapɨr kerek hɨr ninɨn hanhan miye haai o nɨkerek nɨr te hɨr ap hanhan werek neriuwa au, hɨr ap yaain te nanisɨsa nanɨmtau hɨm mai au. ");
INSERT INTO avt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mɨt miyapɨr kerek hɨr nɨnapen menmen enum mamnen mamnɨp nanɨntar hɨr nises hɨm mai, hɨr ap yaain te hɨr nanisɨsa au. ");
INSERT INTO avt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mɨt miyapɨr kerek neweikɨn sip newet hɨm mai nanɨntar mɨt nanɨnɨp, maain hɨr ap te nanu nantike God au. Neimɨn mɨt hɨr nanɨnɨp nanɨntar hɨr nisɨsa, maain hɨr nantike God nanu nanɨt. ");
INSERT INTO avt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mɨt miyapɨr kerek hɨr nantihis naanmampri hɨram mamɨr ke hɨr nantauhis naanmamprau. Hɨr kerek nantauhis naanmamprau, hɨram mamɨr ke hɨr naanmampre hɨrak God kerek keriuweta hi han in. ");
INSERT INTO avt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mɨt miyapɨr kerek naanmɨpre mɨtɨk profet nanɨntar hɨrak profet kerekek, maain God kakwetɨr menmen yaaim miutɨp nantike mɨtɨk profet. Neimɨn naanmampre mɨtɨk yaaik kises hɨm me God nanɨntar hɨrak mɨtɨk yaaik kerekek, maain God kakwetɨr menmen yaaim miutɨp nantike mɨtɨk yaaik. ");
INSERT INTO avt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mɨt miyapɨr kerek hɨr nankaap mɨt miyapɨr weinɨn kerek nisɨsa nanrekyor menmen kike yaaim miutɨp, maain God kakwetɨr menmen yaaim.” ");
INSERT INTO avt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas katɨp mɨt nɨrak disaipel nar hiswiyen wik (12) epei au, hɨr nɨnaiwɨrek nen nerer wit wit. Hɨr nɨnaiwɨrek te Jisas kɨnaaiwɨr wit kerek hɨrak kewi, hɨrak ken katɨp mɨt kerek nau nɨrapɨt wit kɨrak ik hɨrak ketpor hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Me wɨ im Jon Baptais kepu kekre wɨnak enuk. Hɨrak kau kekrerek, hɨrak kemtau menmen Jisas kɨrɨakem, te hɨrak keriuwet mɨt disaipel nɨrak nen nɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hɨr nen nepɨtɨr niun Jisas hɨr nitɨwekhi nar ik: “Ti hɨrekes mɨtɨk kerek Jon katɨp ti enen o haiu mamɨmerɨr mɨtɨk keiyak?” ");
INSERT INTO avt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas kewenhi ketpor, “Menmen yi epei yan yɨrem, o yi yemtewem, yi eino eitɨp Jon em. ");
INSERT INTO avt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mɨt miyapɨr nanamɨr enum toto, hi enipi hɨr pɨke nɨr ein ein. Mɨt miyapɨr his hɨt enum, hɨr nɨre yaain nen ein nen ein. Mɨt miyapɨr hɨr lepro mewi, hɨr yɨnk kɨr yaaik. Mɨt miyapɨr hɨr nɨkɨp toto, hɨr nɨre yaain nemtau menmen werek werek. Mɨt miyapɨr epei naa, hi hɨkɨan hɨr pɨke nekrit nau. Hi atɨp mɨt miyapɨr kerek netenen menmen au, hi hetpor menmen im hɨram menmen God katɨp mɨtɨk hɨrak kaknen kakrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mɨt han kerek hɨr han kiteta hi mɨtɨk kerek God keriuweta hi han, maain hɨr han yaaik nanu.” ");
INSERT INTO avt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hɨrak ketpor epei au, mɨt ne Jon pɨke nen. Hɨr epei nanɨno, Jisas katɨp mɨt menmen me Jon. Hɨrak ketpor, “Nɨpaa yi yen yɨr Jon yi han kitet yi yayɨr mɨtɨk kɨre mekak? Hɨrak mɨtɨk keweikɨn han yapɨrwe kɨre niyen (o tupne) nɨme metɨtɨwem hɨram mɨrirɨr a? Taauye! ");
INSERT INTO avt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Te yi yen yayɨr mekam? Yi yɨr mɨtɨk keriuwet klos yaaim a? Au, mɨt kerek neriuwet klos yaaim hɨr nau wɨnak ke mɨt iuwe gavman. ");
INSERT INTO avt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Im em au, te yi yen yayɨr mekam? Yi yen yɨr mɨtɨk profet a! Hɨram werek, te hi hetpi, yi yɨr mɨtɨk hɨrak kinɨn profet. ");
INSERT INTO avt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hɨrak mɨtɨk kerek nɨpaa tɨwei me God mɨtɨk kewisɨm matɨp hɨrak kaknen. Hɨm matɨp mar im: ‘Hi ariuwet mɨtɨk kai kakinɨn kaknen kaktɨp hɨm mai. Hɨrak kakɨmani han ke mɨt yapɨrwe te hɨr nanɨmtau hɨm mit.’ ");
INSERT INTO avt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Hi hetpi werek. Jon Baptais hɨrak kinɨn mɨt miyapɨr yapɨrwe kerek nɨpaa ere in miyerer nɨr ninen. Te neimɨn hɨr mɨt weinɨn hɨr nanises hɨm me God maain hɨr nanu nantike God nanɨt en te hɨr naninɨn Jon kerek wɨ hɨrak kau tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nɨpaa wɨ Jon kinɨn kewepyapɨr hɨrekes katɨp mɨt menmen, nɨpaa ein ere in God kewepyapɨr hɨrak kakinɨn naanmampre mɨt miyapɨr. Te mɨt kerek nenehan nenepan nɨrɨakan enum hɨr neweikɨn sip newet menmen enum hɨr nises hɨm im. ");
INSERT INTO avt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Menmen im epei man mentar hɨm nɨpaa Moses kewisɨm mau tɨwei metike hɨm mɨt profet newisɨm mau tɨwei hɨram matɨp me Jon kaknen kaktɨp mɨt hɨm im. ");
INSERT INTO avt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te yi han kitet hi hatɨp werek, hi etpi Jon hɨrak mɨtɨk ik Ilaija nɨpaa yi yekinaak kau tɨwei hɨrak epei kaknen. ");
INSERT INTO avt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Neimɨn hɨr nemtau hɨm mai hɨr han ekitetim werek werek. ");
INSERT INTO avt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hi ewis mɨt miyapɨr nau tɨ in ek hɨr nɨre mekam? Hɨr nɨre nɨkerek nenɨnehan neit maket nemitetpɨn hɨr natɨp, ");
INSERT INTO avt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Haiu mɨrɨak tukɨn menep wekɨnp, te yi ap yɨrɨre au. Haiu menep tukɨn mɨtɨk hɨrak kaa te yi ap yan yɨkɨtek au.’ ");
INSERT INTO avt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Hi hatɨp menmen im hentar Jon kewepyapɨr hɨrekes wɨ ham hɨrak nɨnpɨ maak, hɨrak ap kaam tɨpar si enum au. Mɨt iuwe nɨrek te hɨr natɨp, ‘Herwe kersɨsek hɨrak han enuk.’ Hɨr ap han yaaik neriuwerek nisesik au. ");
INSERT INTO avt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hi Mɨtɨk ke wit ke God hi han hewepyapɨr hɨrekes hi etike mɨt haiu maam menmen maam tɨpar. Mɨt iuwe nɨra hɨr natɨp, ‘Eiyɨrek! Hɨrak kaam menmen iuwe yeunɨm, hɨrak kaam tɨpar si enum ere ketaritari. Hɨrak ketike mɨt enun nari pewek me takis netike mɨt han enun hɨr neryeiyan nen.’ Menmen God ketpawɨr hi etike Jon hawɨr wisesim te yi ap han yaaik yeriuwawɨr yisesawɨr au. Menmen hawɨr wɨrɨakem hɨram meteikɨn mɨt God kertei menmen werek werek.” ");
INSERT INTO avt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hɨrak ketpor epei au, te Jisas kene mɨt nau nerer wit wit kerek hɨrak nɨpaa kɨrɨak menmen yapɨrwe kɨkaap mɨt keriuwerem. Hɨrak keneri kentar hɨr ap neweikɨn sip newet menmen enum hɨr nises hɨm mɨrak au. ");
INSERT INTO avt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Hɨrak katɨp kar ik: “Yi mɨt miyapɨr yau wit Korasin yetike mɨt miyapɨr ne wit Betsaida! Maain God kakriwaank! Menmen yi yɨra hi hɨrɨakem heit wit ki, nɨpaa mɨt profet nɨrɨakem neit wit Taia ketike wit Saidon, te hɨr waswas nanweikɨn sip nanwet menmen enum nanwen toni mamɨntar yɨnk kɨr nanteikɨn God hɨr yɨnk enuk. Te yi mɨt yi ap yɨrɨakem au. ");
INSERT INTO avt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hi hetpi werek. Maain wɨ kerek God skelim mɨt, hɨrak kaknep mɨt ne Taia netike mɨt ne Saidon kaknɨp kike, te yi mɨt au hɨrak kakiwep iuwe. ");
INSERT INTO avt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yi mɨt ne wit Kapaneam. Yi han kitet God kaktɨp yi yaain a? Au, God kaktɨp yi mɨt enun kakwɨri yi eino si. Hi hɨrɨak menmen yaaim heit wit Sodom kerek nɨpaa hɨrak kepu kar ke hi epei hɨrɨakem heit wit ki, te hɨr neweikɨn sip newet menmen enum te God ap kanɨp kaknepi wit weinɨk au. Hɨr wen nepu. ");
INSERT INTO avt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hi hetpi werek. Maain wɨ kerek God skelim mɨt, hɨrak kaknep mɨt ne Sodom kaknɨp kike, te yi mɨt miyapɨr au, hɨrak kakiwep iuwe.” ");
INSERT INTO avt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Me wɨ im Jisas katɨp kar ik: “Haai ti kerek Mɨtɨk Iuwe ke nepni metike tɨ, hi han yaaik heriuwit hentar ti hɨsawɨn menmen mit yaaim te mɨt iuwe nepɨtariyem. Ti epei ewepyapɨrem heteikɨn mɨt weinɨn em. ");
INSERT INTO avt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hi han yaaik heriuwit hentar ti hanhan hises han kit te ti hɨrɨakem mar im. ");
INSERT INTO avt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Haai kai ti epei eweto menmen mit yapɨrwe te hi naanmɨprewem. Mɨt ap nertei han ke hi Nɨkan kit. Ti Haai kai kerekek. Mɨt ap nertei han kit au. Hi Nɨkan kit hetike mɨt kerek hi ewepyapɨr han kit eteiknorek. ");
INSERT INTO avt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Yi mɨt miyapɨr kerek yi yɨrɨak menmen iuwe yises God, te yi han ki enuk yentar yi yisesik werek werek au. Yi einen eiyises hɨm mai te hi akepi yi eiyisesik werek werek. ");
INSERT INTO avt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yi einen eiyises hɨm mai te hi eteikni menmen. Yi eiyisɨsa eiyɨntar hi ap hɨre mɨtɨk atɨp hɨm tokik au. Hi ewenɨn han kai atɨp mɨt hɨm yaaim. Yi eiyisɨsa te yi han yaaik, yi yayu werek werek. ");
INSERT INTO avt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Menmen hi ahitihi yi eiyisesim eirɨakem, hɨram yaaim. Te yi ap han enuk yayisesim au. Yi han yaaik eiyu.” ");
INSERT INTO avt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Maain wɨ ham Sabat Jisas ketike mɨt nɨrak disaipel neremir (o nitet nɨmɨn ke) ni kerek wit yehes mɨram mewim. Mɨt nɨrak hɨr nɨnpɨ maan te hɨr nerpesɨs yehes mɨram newenwohisem naam. ");
INSERT INTO avt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mɨt han ne Farisi nɨri nɨrɨak menmen im te hɨr natɨp Jisas, “Ei ti emtewem! Mɨt nit disaipel hɨr nɨrɨak menmen me wɨ Sabat kerek hɨm me Moses meriuwesɨsem.” ");
INSERT INTO avt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas ketpor kar ik: “Yenmak te yi ap yertei menmen werek werek nɨpaa Devit kɨrɨakem me wɨ hɨrak ketike mɨt nɨrak hɨr nɨnpɨ maan. ");
INSERT INTO avt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hɨrak ken kekre wɨnak kerek mɨt newepwar God menmen, hɨrak keit bret mɨtɨk hetpris kewetɨwekem. Mɨt epei newet God em te hɨrak ketike mɨt nɨrak hɨr naam. Hɨm me God Moses kewisɨm mau tɨwei matɨp mɨt pris keriyen hɨr nanɨm. Mɨt han au. ");
INSERT INTO avt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te yi yenmak te yi ap yertei menmen werek werek mekre hɨm me Moses yi yekinaam a? Wɨ Sabat yapɨrwe miutɨp miutɨp mɨt pris hɨr nɨrɨak wok nenep samiyak nesiyem newet God em. Hɨr ap nau yain yain nar ke hɨm me Moses matɨp mɨt enisesim te God katɨp mɨt pris hɨr yaain. Menmen im me God minɨn hɨm me Moses me wɨ Sabat. ");
INSERT INTO avt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hi hetpi werek. Menmen kau in hɨrak kinɨn wɨnak iuwe ke God. ");
INSERT INTO avt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yi yertei hɨm werek werek God kewisɨm mau tɨwei, te yi ap yatɨp enum yene mɨt kerek nɨrɨak menmen enum au. Hɨm me God matɨp mar im: ‘Hi hanhan te yi hanhan yeriuwe mɨt. Menmen im minɨn samiyak yi yamɨp yesiyem yewetewem.’ ");
INSERT INTO avt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hi hetpi hi Mɨtɨk ke wit ke God hi Iuwe naanmɨpre menmen mɨt ne wɨ Sabat hɨr nɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas ketpor epei au, hɨrak kɨnaaiwɨr wit ik, hɨrak ken wɨnak hak kɨr kerek hɨr nererik nekine hɨm me Moses metike hɨm me mɨt profet newiyen. Hɨrak ken en, ");
INSERT INTO avt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","mɨtɨk kiutɨp kau wɨnak ek hɨrak his mɨrak miutɨp enum maa. Mɨt han en hɨr hanhan nesiuwe Jisas me menmen hɨm me Moses metpim, te hɨr nitɨwekhi nar ik: “Hɨm me Moses haiu misesim me wɨ Sabat meriuwesɨs mɨtɨk kakɨkaap mɨtɨk kɨnap o au?” ");
INSERT INTO avt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Te Jisas ketpor, “Me wɨ Sabat mɨtɨk keiyak ke yi mɨt hɨrak sipsip kɨrak kiutɨpen kerekek kakɨnke kakɨkre hei, hɨrak kakno kakɨkinɨk kakwisɨk kakɨt wit eik a? ");
INSERT INTO avt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Haiu mɨt minɨn sipsip hɨram au menmen weinɨm. Te haiu me wɨ Sabat mamkaap mɨt te hɨr nanɨre yaain.” ");
INSERT INTO avt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hɨrak katɨp epei au, hɨrak katɨp mɨtɨk his enum, “Ti esiuwe his mit.” Hɨrak kesiuwe his miutɨp mɨrak te his mɨre yaaim mar ke his mɨrak pɨnam. ");
INSERT INTO avt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hɨrak kɨrɨakem, te mɨt en ne Farisi hɨr nen witeik hɨr nɨsawɨn natɨpan nimenɨpɨnek narkeik te hɨr nanɨnep Jisas kaki. ");
INSERT INTO avt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas kertei menmen hɨr hanhan nanrekyɨwekem te hɨrak kɨnaaiwɨr wit eik e. Mɨt yapɨrwe hɨr nɨnap hɨr nisesik te hɨrak kekepi hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te hɨrak ketpor hɨm iuwe hɨr ap entɨp mɨt han menmen hɨrak kerekyorem au emɨt. ");
INSERT INTO avt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hɨrak ketporem te menmen nɨpaa mɨtɨk profet Aisaia ketpim kewisɨm mau tɨwei mamnen. Hɨm im hɨram matɨp, ");
INSERT INTO avt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mɨtɨk ik hi hehimɨtanek hɨrak kɨrɨak menmen mai. Hi hanhan heriuwerek, hɨrak kenipa hi han yaaik. Hi tewen ariuwet Hɨmɨn kai Yaaik kaku kakɨkre han kɨrak te hɨrak kakɨkepik kakno kaktɨp mɨt nerer wit wit menmen yaaim hi arekyorem ahɨsak menmen enum mɨr. ");
INSERT INTO avt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hɨrak kaktike mɨt han ap nanɨtpepan, hɨrak ap te kaknip hɨm iuwe o kakɨrp yayiwe kaktɨp mɨt hɨm mɨrak au. ");
INSERT INTO avt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hɨrak ap kakɨwaank mɨt miyapɨr hɨr nises God yaaik kike nɨre niyen me mani hɨram maa nɨme mɨniu mamwenɨnem. Mɨt miyapɨr hɨr nɨre si metnen kike maain hɨram mami, hɨrak kakɨkepi hɨr nanu werek. Hɨrak kakɨkepi ere wɨ hɨrak kakinɨn menmen enum te hɨm hɨrak kaktɨp mɨt em, hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te mɨt miyapɨr nerer wit wit ap ne weiwɨk me Isrel, hɨr enises hɨm mɨrak nanu nanɨnkɨkwek ere maain hɨrak kakne kaktorhis.” ");
INSERT INTO avt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maain hɨr mɨt han neit mɨtɨk enuk herwe kenipek nanamɨr toto, hɨrak kemesɨsɨwek hɨm ap katɨp au. Hɨr neiyɨk nan Jisas te hɨrak kepɨr herwe enuk ken, hɨrak kɨre yaaik kɨr ein ein, katɨp werek werek. ");
INSERT INTO avt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mɨt miyapɨr yapɨrwe hɨr nɨrek, hɨr han kekrit natɨp nar ik: “Yi han kitet mɨtɨk ik hɨrak Krais ik Nepenyek ke Devit kerek nɨpaa God katɨp hɨrak kakriuwetek kaknen?” ");
INSERT INTO avt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Te mɨt han ne Farisi hɨr nemtau mɨt natɨp menmen mar im hɨr nemnorem natɨp nar ik: “Hɨrak ap Nepenyek ke Devit au. Hɨrak kepɨr herwe enum kentar mɨtɨk iuwe ke herwe hɨrak Bielsebul hɨrak kekepik kepɨrem.” ");
INSERT INTO avt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas kertei menmen hɨr han kitetim te hɨrak ketpor kar ik: “Mɨt nau wit iuwe hɨr newep nau ke nɨmɨn nentar menmen, te mɨt in ap nepu werek werek au. Mɨt ne weiwɨk miutɨp o nɨkerek ne mɨtɨk kiutɨp hɨr newep nau ke nɨmɨn nentar menmen te hɨr ap nepu werek werek naanmɨpre wit kɨr au. Hɨr nanɨnke hasini nanɨwaank hɨras. ");
INSERT INTO avt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Seten hɨrak kekepa hi epɨr herwe mɨrak te hɨrak kewep kau nɨmɨn. Karkeik te hɨrak kaku werek werek a? Taau! ");
INSERT INTO avt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yi yatɨp hi hepɨr herwe hentar Bielsebul kekepa. Hɨrak kekepa hi hepɨr herwe te mɨt han ne yi mɨt, neimɨn nekepi te hɨr nepɨr herwe mekre han ke mɨt? Seten a? Au! Hɨr ap nepɨr herwe nentar Seten kekepi au. God kerekek. Te menmen hɨr nɨrɨakem meteikɨn yi yetpo enum me Seten kekepa. Au, God kerekek kekepa. ");
INSERT INTO avt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","God Hɨmɨn Yaaik kerekek kekepa hi hepɨr herwe mamnopɨn mamkeipɨn. Menmen im meteikni God epei kan kau menep kakinɨni naanmampri. ");
INSERT INTO avt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Hi wen etpi hɨm ham. Mɨtɨk hak kakno kakɨkintɨp menmen me mɨtɨk iuwe hɨrak kakinɨn kakrɨak mekam? Hɨrak kakinɨn kaksenkek his hɨt me mɨtɨk iuwe. Hɨrak kaksenkɨkwek his hɨt mɨrak, hɨrak kakɨkintɨp menmen mɨrak keiyɨm kakno. ");
INSERT INTO avt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Neimɨn hɨr ap nisɨsa hɨr nar ke mɨt enun nepan nai. Neimɨn hɨr ap nekepa haiu mamri han ke mɨt nanises God hɨr nar ke mɨt enun nepɨr mɨt nanises menmen enum heriyai heriyai. ");
INSERT INTO avt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Te hi hetpi, menmen yapɨrwe mɨt nɨrɨakem o menmen enum hɨr netpim hɨr newepyapɨrem neweikɨn sip newetɨwem maain God kakɨsakem. Te mɨt miyapɨr kerek hɨr natɨp enum me God Hɨmɨn Yaaik, God ap te kakɨsak menmen im au. ");
INSERT INTO avt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mɨt miyapɨr kerek hɨr natɨp enum me hi kerek Mɨtɨk Iuwe keriuweta hi han, maain God kakɨsak menmen enum hɨr netpim. Te neimɨn hɨr natɨp enum me God Hɨmɨn Yaaik, God ap kakɨsak menmen enum hɨr natɨp in o maain. Hɨr nanɨt wit kɨrak yaaik au. ");
INSERT INTO avt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nu mei hɨram yaaim te hɨram mamri mamine nɨkim mɨram yaaim. Nu mei enum te hɨram mamri mamine nɨkim mɨram enum. Mɨt nɨr nu nɨkim mɨram hɨr natɨp, ‘Nu im hɨram yaaim’, o au en, hɨr natɨp, ‘Nu im hɨram enum mesine’. ");
INSERT INTO avt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yi mɨt enun nɨkerek ne manpen Seten. Yi ap eitɨp hɨm ham yaaim eiyɨntar yi mɨt enun. Mɨt natɨp hɨm nises menmen mekre han kɨr. ");
INSERT INTO avt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mɨtɨk yaaik katɨp menmen yaaim kentar han kɨrak yaaik. Mɨtɨk enuk katɨp menmen enum kentar han kɨrak enuk. ");
INSERT INTO avt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hi hetpi menmen im hentar maain wɨ kerek God skelim yi mɨt, hɨrak kakitihi me menmen enum miutɨp miutɨp nɨpaa yi yetpim. ");
INSERT INTO avt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maain God kakitihi me menmen miutɨp miutɨp yi nɨpaa yetpim. Te hɨm mi hɨremes maain mamteikɨn God yi yɨre mɨt yaain o au enun.” ");
INSERT INTO avt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hɨrak katɨp epei au, mɨt han ne Skraip, kerek ninɨn nertei hɨm me Moses natɨp mɨt em, hɨr netike mɨt ne Farisi, kerek han kitet hɨr ninɨn mɨt han nises hɨm me Moses, hɨr natɨp nar ik: “Mɨtɨk Iuwe, haiu hanhan ti hɨrekes erɨak menmen yaaim nɨpaa mɨt ap nɨrɨakem au.” ");
INSERT INTO avt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Te Jisas ketpor kar ik: “Yi mɨt miyapɨr kerek yitauhi hi arɨak menmen yaaim nɨpaa mɨt ap nɨrɨakem, yi mɨt miyapɨr enun ap yises God au. Hi ap ateikni menmen yi yitauhiyem au. Hi ateikni menmen hɨram mei me mɨtɨk profet Jona nɨpaa kau tɨ keremem. ");
INSERT INTO avt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nɨpaa saauk wɨsenuk ke wan eik kekes Jona hɨrak kekre tu kɨrak ere wɨ wikak. Te hi Mɨtɨk kerek Mɨtɨk Iuwe keriuweta hi han in, hi hahu akre hei ehɨt nɨmɨn ere wɨ wikak. ");
INSERT INTO avt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Maain wɨ God skelim yi mɨt, mɨt nɨpaa nau neit Nineva nanɨrp nantike mɨt nau tɨ in. Hɨr nanɨrp nantike mɨt in hɨr nantɨp, ‘Yi mɨt enun.’ Hɨr nantɨp nanɨr ik nanɨntar nɨpaa Jona katɨp mɨt en hɨm me God te hɨr neweikɨn sip newet menmen enum nises hɨm me God. Mɨtɨk Iuwe kinɨn Jona hɨrak kau in te yi ap yeweikɨn sip yewet menmen enum au. ");
INSERT INTO avt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Maain wɨ God skelim yi mɨt, mɨte iuwe kwin hɨre nɨpaa naanmɨpre mɨt nau wit Siba, hɨre wawɨrp wautike mɨt miyapɨr nau tɨ in. Hɨre wawɨrp wautike mɨt miyapɨr nau tɨ in ek hɨre wautɨp, ‘Yi mɨt miyapɨr enun.’ Hɨre wautɨp menmen im wawɨntar nɨpaa hɨre wɨnaaiwɨr wit kɨre wen hɨt nokim (o yanɨmɨn) te wemtau hɨm yaaim mɨtɨk iuwe King Solomon ketpim. Mɨtɨk Iuwe kinɨn King Solomon hɨrak kau in te yi ap yeweikɨn sip yewet menmen enum yemtau hɨm mɨrak au. ");
INSERT INTO avt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Wɨ kerek herwe enuk kenke kɨnaaiwɨr mɨtɨk, hɨrak kepno ein ein kerekir wit tɨpar aurek, hɨrak kɨnkatɨn wit hak te hɨrak kakwi. Hɨrak kɨnketnɨwek kɨnketnɨwek hɨrak ap kɨnapɨnek au. ");
INSERT INTO avt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Te hɨrak han kitet kar ik: ‘Hi ap hɨnapɨn wit yaaik au, te hi pɨke eno wit kai kerek nɨpaa hi hewik.’ Hɨrak pɨke kepno wit kɨrak, hɨrak kɨr wɨnak herwe keiyak kewik au. Hɨrak yaaik kɨre mɨtɨk keripep waniu yaaim. ");
INSERT INTO avt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hɨrak kɨrek epei au, hɨrak ken kɨnkatɨn herwe enum mar hispɨnak wik (7) minɨnek. Epei au, hɨrak ketikeri nanɨno wɨnak eik e nanu nanɨt. Nɨpaa mɨtɨk hɨrak herwe kewik han enuk kike, te in ek hɨram herwe mamɨwaank han kɨrak enuk. Menmen mamɨr im mamnen mamnep mɨt nau tɨ im.” ");
INSERT INTO avt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas wen katɨp mɨt menmen mɨrak, te miye pɨrak wetike kikrek nɨrak nan nanɨrek. Hɨr nerp witeik hanhan netpɨwek menmen. ");
INSERT INTO avt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hɨr nerp en, mɨt han nerp en netpɨwek nar ik: “Emtewek. Miye wetike kikrek nit nan nanrit nanɨtput menmen.” ");
INSERT INTO avt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas kewenɨwekhi katɨp, “Peimɨn hɨre miye pai. Neimɨn hɨr nɨre kikrek nai?” ");
INSERT INTO avt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hɨrak kesiuwe mɨt nɨrak disaipel his hɨrak katɨp, “Eiyɨri. Mɨt miyapɨr in hɨr nɨre miyerer nai netike kikrek nai. ");
INSERT INTO avt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Neimɨn hɨr nises menmen Haai kai keit wit kɨrak hɨrak hanhan hɨr nanisesim, hɨr nɨre kikrek nai, yenterer nai o miye pai.” ");
INSERT INTO avt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Me wɨ im keremem, Jisas kɨnaaiwɨr wɨnak ketpaan ken wit eik ken kau menep wan eik. ");
INSERT INTO avt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hɨrak kau en, mɨt miyapɨr yapɨrwe nererik menep menep nersɨs Jisas. Te hɨrak kɨniu ken kekre bot kau en, hɨr mɨt miyapɨr nerp tenhaan nau pɨn eik. ");
INSERT INTO avt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jisas ketpor menmen yapɨrwe me tok piksa mar im. Hɨrak katɨp: “Mɨtɨk hak ken kamɨr nu nɨkim mekre ni mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te mɨtɨk kewɨrem mau ni, nɨkim ham menke mɨwaai yayiwe kerek wit yaain te hore man maam. ");
INSERT INTO avt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yehes ham menke mentar nan kerek ap tɨ mei iuwe menterim em, te hɨram mewo wasenum mentar tɨ kike kentar nan. ");
INSERT INTO avt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wepni kan kɨr kenterim te hɨram ap mewɨr nekenik men tɨ eik au. Hɨram me weiwei te maa meit. ");
INSERT INTO avt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nɨkim ham menke mɨwaai waai kerek tɨktɨk mewim em, te waai keremem tɨktɨk mewim em mɨniu mɨwapɨn em. Te hɨram mewo werek werek ap mari au. ");
INSERT INTO avt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nɨkim ham menke mɨwaai tɨ yaaik nɨpaa mɨtɨk kewenek te hɨram mewo mari yaaim. Ham mari 100, ham mari 60, ham mari 30. ");
INSERT INTO avt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mɨt miyapɨr kerek nemtau hɨm mai hɨr han ekitetim werek werek!” ");
INSERT INTO avt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hɨrak ketpor epei au, mɨt disaipel nan nitehi Jisas, “Ti henmak ti hetpor hɨm tok piksa?” ");
INSERT INTO avt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisas ketpor, “God epei keteikni menmen hɨrak kakrɨakem te kakinɨn naanmɨpre yi mɨt. Hɨrak keteikni yarkeik te yi eire nɨkerek nɨrak yi eiyisesik. Te mɨt in en au. ");
INSERT INTO avt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mɨt han kerek netenen menmen ham me God, hɨrak kakwetɨr meiyam yapɨrwe te hɨr nantɨwem yapɨrwe. Te mɨt han kerek ap netenen menmen iuwe nɨnapen hɨm mɨrak, menmen kike hɨr epei netenenim mamɨwaank mamɨt. ");
INSERT INTO avt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hi hetpor menmen meriuwe tok piksa hentar hɨr nɨr menmen te hɨr ap nertei menmen. Hɨr nɨkɨp memtau, te hɨr ap nertei menmen hi hetpim werek werek au. ");
INSERT INTO avt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hɨm ham nɨpaa mɨtɨk profet Aisaia ketpim hɨrak kewisɨm mau tɨwei hɨram epei man mentar menmen mɨt miyapɨr in hɨr nɨrɨakem. Hɨram matɨp: ‘Yi yayɨmtau hɨm yeteipim yeteipim te yi yayɨrtei menmen werek werek au. Yi yayɨr menmen yaiteipim yaiteipim te yi yayɨr menmen werek werek au. ");
INSERT INTO avt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hɨr nanɨrem werek werek au nentar han ke mɨt miyapɨr in en epei au ketaritari, hɨr nemesɨs nɨkɨp mɨr epei au nɨnapen nanɨmtau hɨm. Te hɨr nɨnapɨpɨ nanamɨr kɨr ap nɨr menmen hi hɨrɨakem. Hɨr ap nɨrɨak menmen im te hɨr nanɨr menmen hi hɨrɨakem nemtau menmen mai werek werek, han kɨr enisɨsa te hi akepi hɨr enɨre yaain.’ ");
INSERT INTO avt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Te yi han yaaik eiyu. Nanamɨr ki epei kɨr menmen werek werek. Nɨkɨp mi epei memtau menmen werek werek. ");
INSERT INTO avt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hi hetpi menmen werek werek. Mɨt profet yapɨrwe netike mɨt yaain nɨpaa hanhan nanɨr menmen yi epei yɨra hi hɨrɨakem, te hɨr ap nɨrem au. Hɨr hanhan nanɨmtau menmen yi epei yemtau hi hetpim te hɨr ap nemtewem. Au, hɨr epei naa. ");
INSERT INTO avt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yi eiyɨmtau hɨr o as me tok piksa me mɨtɨk kewɨr rais nɨkim mɨram mau ni. ");
INSERT INTO avt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mɨt yapɨrwe nemtau hɨm me God kakinɨn naanmɨpre mɨt te hɨr ap nerteiyem werek werek au, hɨr nɨre nɨkim mɨwaai yayiwe. Maain Seten kaknen kakɨkre han kɨr kakpɨr hɨm kerek epei God kewisɨm mekrerek. ");
INSERT INTO avt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nɨkim ham mɨnatɨn mɨwaai tɨ kike mentar nan, im em hɨram mɨre mɨt han wasenum nemtewem han yaaik neriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Te hɨr nɨre nɨkim keremem ap mine nekenik men tɨ eik au te mamu kike. Maain hɨram pɨke mami. Mar im em te mɨt neiyan nemtau hɨm me God nisesim. Maain kike mɨt han neneri nerekyor enum nentar hɨr nisesim, te hɨr wasenum neweikɨn sip newetɨwem. ");
INSERT INTO avt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nɨkim ham menke mekre waai kerek enum tɨktɨk mewim em, hɨram mɨre mɨt nemtau hɨm im te menmen enum me tɨ ik ek metike pewek hɨr hanhanem hɨram minɨn hɨm me God. Mɨt nar ik ek ap te nanrɨak menmen yaaim nanises God werek werek au. ");
INSERT INTO avt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nɨkim menke mekre tɨ yaaik hɨram mar ke mɨt nertei hɨm me God nemi mekre han kɨr. Te hɨram mine wit mari yehes yapɨrwe, ham mar 100, ham mar 60, ham mar 30, te hɨr nɨrɨak menmen yaaim yapɨrwe.” ");
INSERT INTO avt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas ketpor hɨm tok piksa ham. Hɨrak katɨp: “Menmen God kɨrɨakem hɨram mɨre mɨtɨk hak kewɨr wit nɨkim mitet ni mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Maain wɨtaan mɨt miyapɨr nɨwaai, mɨtɨk enuk kɨrak kepan kan kewɨr yenkis yehes mɨram enum mitet ni kerek hɨrak epei kewɨr wit nɨkim mewi en, te hɨrak ken. ");
INSERT INTO avt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Maain wit kerek hɨr epei newɨrem em mau ni eim mɨre iuwe mamine nɨkim, te hɨr nɨr yenkis enum keremem metikerem. ");
INSERT INTO avt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mɨt nɨrɨak menmen me mɨtɨk iuwe hɨr nen netpɨwek nar ik: ‘Mɨtɨk iuwe ti nepei hamɨr wit yehes mekre ni mit im e. Ti hamɨr menmen yaaim te menmen im enum meke nein man te hɨram mewo in?’ ");
INSERT INTO avt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hɨrak kewenhi ketpor, ‘Mɨtɨk hak enuk kepan kan kamɨr menmen enum mekre nɨmɨn me menmen yaaim.’ Hɨr nitɨwekhi, ‘Ti hanhan haiu emno emketetim?’ ");
INSERT INTO avt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te hɨrak keweni ketpor, ‘Hi hɨnaain yi eiketetim emnopɨn. Yi yaiket menmen yaaim mamtikerem. Au emɨt! ");
INSERT INTO avt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yi eiwisɨm emu ere maain hɨram emi. Te hi etɨp mɨt kerek nanremir nanɨr ik: ‘Yi eiyinɨn eiremir menmen enum eisenkekim emriuwe waai. Maain haiu mamɨsiyem. Yi eiremir menmen enum epei au, te yi eino eiremir nɨkim yaaim eiwisɨm emɨkre wɨnak kai.’” ");
INSERT INTO avt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas ketpor hɨm tok piksa hɨrak katɨp, “Menmen God kɨrɨakem hɨram mɨre nu mastet nɨkim mɨram. Mɨtɨk hak ketɨwem kamɨr mau ni mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nu mastet nɨkim hɨram ap iuwe mar ke nɨkim me menmen ham em. Au, hɨram kike enum. Te maain hɨram mau ni mamniu mamre iuwe maminɨn menmen kerek mau ni em, hɨram mamre nu te hore mamnen mamwis yaank mamu heneik mɨram. Mar im mɨt in kerek nises hɨm mai hɨr nɨre niutɨp niutɨp. Te maain hɨr nanɨre yapɨrwe.” ");
INSERT INTO avt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas pɨke ketpor hɨm ham. Hɨrak katɨp, “Menmen God kɨrɨakem hɨram mɨre yis mɨte weiyɨm wen wenipem metike flaua weweiknenim mekre sar mau hɨm ere hɨram nap mɨnanem mɨniu wɨsenum.” ");
INSERT INTO avt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas katɨp mɨt miyapɨr menmen yapɨrwe keriuwe hɨm mɨre tok piksa. Hɨrak ap ketpor hɨm meiyam au. Hɨrak ketpor tok piksa keremem. ");
INSERT INTO avt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hɨrak katɨp kar ik te menmen nɨpaa mɨtɨk profet ketpim kewisɨm mau tɨwei, hɨram mamnen mamɨr ke nɨpaa hɨrak ketpim. Hɨm im hɨram matɨp, “Hi awep hɨm atɨp mɨt tok piksa. Hi atɨp menmen nɨpaa hi God hɨrɨak tɨ ere in mɨt ap nerteiyem au.” ");
INSERT INTO avt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas katɨp mɨt miyapɨr menmen epei au, hɨrak kɨnaaiwɨr mɨt miyapɨr hɨrak kɨnɨk ken wɨnak. Hɨrak kɨnɨk ken wɨnak, mɨt nɨrak disaipel nan nitɨwekhi, “Ti etpei werek menmen me yehes enum mekre ni.” ");
INSERT INTO avt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas kewenhi ketpor, “Mɨtɨk kerek kamɨr yehes yaaim mekre ni hɨrak hi kerekek. Mɨtɨk Iuwe God keriuweta hi han tɨ ik. ");
INSERT INTO avt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ni eim hɨram tɨ ik ek. Yehes yaaim hɨram mɨre mɨt miyapɨr nises hɨm me God. Yehes enum hɨram mɨre mɨt miyapɨr nises hɨm me Seten. ");
INSERT INTO avt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mɨtɨk enuk kepan kerek kamɨr yehes enum hɨrak Seten. Wɨ mɨt hɨr nan newen yehes hɨram mɨre wɨ God skelim mɨt. Mɨt kerek nen newen yehes hɨr ensel. ");
INSERT INTO avt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mamɨr ke mɨt neit yehes enum nesenkekim neiyɨm nan newɨrem mekre si, te maain wɨ menmen mamnen mamɨr im God skelim yi mɨt. ");
INSERT INTO avt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi asiuwe mɨt ensel nai nanɨno nanrer wit wit me tɨ kerek hi naanmampre mɨt miyapɨr hɨr nanɨnke menmen enum mari han ke mɨt en. Hɨr nanɨnke menmen enum metike mɨt han kerek nɨrɨak menmen enum. Te hi enkerem emnopɨn emkeipɨn wit kerek Mɨtɨk Iuwe naanmɨprewem. ");
INSERT INTO avt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Te hɨr nanwɨr mɨt miyapɨr enun nanɨno nanɨkre si kerek hɨr nanɨnepɨp nanɨneknen yehes mɨr. ");
INSERT INTO avt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Me wɨ im mɨt miyapɨr kerek yaain en nanu wit yaaik God kakwetɨr menmen mɨrak iuwe kakɨkepi te hɨr nanɨr nanre wepni nanɨt wit kɨrak. Mɨt neimɨn nemtau hɨm mai hɨr han ekitetim! ");
INSERT INTO avt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Menmen me God hɨram yaaim mɨre okis pewek mekrerem mɨt nɨpaa hɨr mɨt nɨsawɨnem mekre ni ham. Maain mɨtɨk hak kiutɨp kɨnapɨnem, hɨrak pɨke kɨsawɨnem mekre hei, hɨrak han yaaik, te hɨrak ken keit menmen mɨrak yapɨrwe keiyɨm ken kesiuwerem men mɨt, hɨrak keit nan mererim, hɨrak keiyɨm ken kewɨrem keiyɨm katɨn ni keremem. ");
INSERT INTO avt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Menmen me God hɨram yaaim mɨre mɨtɨk hak kerek kɨnkatɨn pewek wɨnak hɨrak kɨnkatɨn kerek yaaim yaaim em, keiyɨm ken kesiuwerem men mɨt te kakɨt moni mamrerim. ");
INSERT INTO avt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hɨrak kɨr pewek wɨnak kerek yaaik ek, te hɨrak ken kesiuwe menmen mɨrak keiyɨm ken kesiuwerem men mɨt, hɨrak keit moni mererim, hɨrak keiyɨm ken kewɨrem keit wɨnak yaaik kerekek. ");
INSERT INTO avt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Menmen God kɨrɨakem hɨram mɨre hepin mɨt hɨr newɨrem mekre wan neiyɨm nanri saauk metike menmen ham yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hepin kenempet keriuwerem, te hɨr neriyaam man mɨwaai pɨn eik. Te hɨr nau nekorɨrem newis saauk yaaim em mekre tɨkenup ham, enum em hɨr newɨrem men. ");
INSERT INTO avt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Me wɨ kerek maain God skelim mɨt ne tɨ ik ek, hɨram mampar ik. Mɨt ensel ne God nanɨnen nanɨnke mɨt enun kerek nises menmen enum me nɨmɨn me mɨt yaain nises menmen yaaim. ");
INSERT INTO avt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Te hɨr nanwɨri nanɨno nanɨkre si iuwe. Me si im em hɨr nanɨnepɨp nankɨt nanɨneknen yehes mɨr naneitaiyen.” ");
INSERT INTO avt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Te Jisas kitorhi, “Yi yertei hɨm yapɨrwe hi epei hetpiyem?” Hɨr newenhi natɨp Jisas, “Kai Iuwe, haiu merteiyem.” ");
INSERT INTO avt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Te Jisas ketpor, “Mar keremem te mɨt skraip kerek nertei hɨm me Moses natɨp mɨt em, hɨr epei nertei hɨm hi hewepyapɨrem, hɨr nɨre mɨtɨk haai ke wɨnak iuwe. Hɨrak ken kɨnɨk wɨnak kɨrak kekin menmen yaaim petep metike menmen enum tokim keiyɨm kan kɨkaap mɨt kewetɨrem. Hɨr newepyapɨr hɨm me God nɨpaa hɨrak katɨp mɨt profet em metike hɨm mai yaaim.” ");
INSERT INTO avt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas katɨp hɨm tok piksa im epei au, hɨrak kɨnaaiwɨr wit ik ken. ");
INSERT INTO avt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hɨrak pɨke ken wit kɨrak eik ken katɨp mɨt hɨm me God kekre wɨnak kerek hɨr nererik nekine hɨm me Moses neitai en. Hɨrak ketpor werek te hɨr nekrit nehɨnhɨn natɨp, “Keimɨn ketpɨwek hɨm yaaim hɨrak ketpeiyem? Keimɨn kekepik te hɨrak kɨrɨak menmen yaaim kɨkaap mɨt keriuwerem kepɨr herwe kɨrɨak mɨt kerek nɨnap hɨr nɨre yaain? Hɨrak mɨtɨk weinɨk kar ke haiu mɨt in. ");
INSERT INTO avt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mɨtɨk ik ek nɨkan ke mɨtɨk kerek kime wɨnak kerekek. Maria hɨre miye pɨrak kerepep. Jems ketike Josep, Saimon Judas hɨr kikrek nɨrak keriyen. ");
INSERT INTO avt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yenterer nɨrak hɨr nau netikewai. Menmen yapɨrwe im em hɨrak ketɨwem meke nein man?” ");
INSERT INTO avt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hɨr natɨp narik te han kɨr enuk neriuwerek hɨr neweikɨn sip newetɨwek nentar hɨr ap nertei karkeik te hɨrak kɨrɨak menmen im yaaim. (Hɨr han kitet hɨrak mɨtɨk kerekek. Mɨtɨk Iuwe au.) Te Jisas ketpor, “Mɨt profet niuk mɨr iuwe mau merer wit wit, te mɨt neit wit kɨrak netike mɨt ne weiwɨk mɨrak, hɨr ap han kitet hɨrak iuwe au.” ");
INSERT INTO avt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hɨrak ap kɨrɨak menmen yapɨrwe kɨkaap mɨt his hɨt enum metike menmen ham keit wit eik ek kentar hɨr ap han kitet hɨrak mɨtɨk kerek God keriuwetek kan au. ");
INSERT INTO avt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Me wɨ im, mɨtɨk iuwe gavman Herot ke provins Galili kemtau menmen Jisas kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Te mɨtɨk Herot katɨp mɨt kerek nɨrɨak menmen mɨrak, “Hi han kitet ik hɨrak mɨtɨk Jon kerek kɨkɨr mɨt neriuwe tɨpar em. Hɨrak kaa te in ek hɨrak pɨke kekrit te menmen wɨsenum manpenum mau his mɨrak, te hɨrak kɨrɨak menmen yaaim im. ");
INSERT INTO avt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nɨpaa Jon katɨp Herot, “Ti heit mɨte ip ep. Menmen im e hɨram ap yaaim au.” Te Herot han enuk ketenen Jon kesenkekik keriuwe sen ain kewisɨk kekre wɨnak enuk kentar Herot epei keit Herodias, mɨte pe Filip, Herot nɨkik kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot hanhan kaknep Jon kaki, te hɨrak kɨnaain mɨt miyapɨr. Hɨr han kitet Jon hɨrak mɨtɨk profet ke God. ");
INSERT INTO avt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Maain wɨ ham miutɨp, mɨt han nen nau netike Herot han kitet wɨ kerek nɨpaa miye winaak ek. Me wɨ im nɨki pe Herodias wɨrɨre wen werp nɨmɨn ke hɨr mɨt. Te herot hanhanep wɨsenum. ");
INSERT INTO avt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hɨrak hanhanep wɨsenum te hɨrak katɨp mɨte kerepep kar ik: “Hi hetput werek. Menmen ti hanhan ehitauhiyem, hi ewetitem.” ");
INSERT INTO avt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Miye pe nɨki ip ep watɨp nɨki pɨre weriuwe hɨm, te hɨre watɨp, “Ti erekir teruk ke Jon kerek kɨkɨr mɨt en ewisɨk ekɨkre tɨkenup eiyɨk enen ewetewek in ek, te hi hertei hɨrak kaa.” ");
INSERT INTO avt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hɨre watɨp war ik, te mɨtɨk iuwe eik ek hɨrak han enuk. Hɨrak kɨnapen kakrekyɨwekem te hɨrak yɨnk enuk kentar mɨt nau naam menmen netikerek nemtau menmen hɨrak ketpɨwerem. Te hɨrak katɨp mɨt nɨrak enwetɨwe menmen im emnen. ");
INSERT INTO avt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Herot keriuwet mɨtɨk ken wɨnak enuk te hɨr mɨt en nerekir teruk ke Jon neit ein te tɨmɨr kewen keket. ");
INSERT INTO avt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Epei au, hɨr neit paan kɨrak kekre tɨkenup neiyɨk nan newet nɨki ep ek. Hɨre wetɨwek epei au, hɨre weiyɨk wen wewet miye pɨre rek. ");
INSERT INTO avt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mɨt disaipel ne Jon nerteiyek, hɨr nan neit herwe yɨnk kɨrak neiyɨk nen newisɨk kekre hei. Hɨr newisɨk epei au, hɨr nen natɨp Jisas menmen enum mɨt nɨrɨak Jon em. ");
INSERT INTO avt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas kemtau hɨm me mɨr hɨr nenep Jon keremem, hɨrak kehɨn kɨniu ken kekre bot kerekir wan ken wit weinɨk kerek mɨt ap newi au. Te mɨt yapɨrwe nemtau Jisas ken, hɨr neke tɨ nɨnaaiwɨr wit kɨr nisesik nen. ");
INSERT INTO avt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas epei kau bot keiyɨk ken ere epei kiun wit kerek hɨrak hanhan kakno. Hɨrak kɨnaaiwɨr bot kenke ken tɨ, hɨrak kɨr mɨt miyapɨr yapɨrwe nisesik nan. Te hɨrak han tewenɨni kɨkaap mɨt han kerek nɨnap, his hɨt enum em. ");
INSERT INTO avt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hɨnkewɨ epei man, te mɨt disaipel nɨrak nan natɨp Jisas, “Wit ik ek enuk weinɨk ap mɨt newik. Te wɨ epei men wɨtaan kaknen. Ti eriuwet mɨt miyapɨr yapɨrwe nanɨno enrer wit wit kerek menep ek te hɨr hɨras enwɨr pewek enɨt menmen mɨr nanɨm.” ");
INSERT INTO avt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas ketpor, “Haiu ap te mamriuweti enɨno au emɨt. Yi eiwetɨr menmen enɨm me yi hɨras.” ");
INSERT INTO avt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hɨr newenɨwekhi netpɨwek, “Haiu ap metenen menmen mei yapɨrwe au. Haiu meit bret hispɨnak (5), saauk wiketerem im em keremem.” ");
INSERT INTO avt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisas katɨp, “Eikinɨm eiyɨm einen in.” ");
INSERT INTO avt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hɨrak katɨp mɨt miyapɨr yapɨrwe nau yenkis nau tɨ. Epei au, hɨrak kekin bret hispɨnak (5) keremem metike saauk wiketerem hɨrak kɨkɨam naan men niu nepni eim, hɨrak kitehi God katɨp hɨrak han yaaik keriuwe menmen im. Epei au, hɨrak kewep bret keremem hɨrak kewet mɨt disaipel nɨrak em, te hɨr neweiknɨm newet mɨt miyapɨr yapɨrwe rem. ");
INSERT INTO avt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hɨr naam nen nen ere tu iuwe. Te hɨr disaipel neit yinam kerek epei naam em nemi mekre wapnake ere wapnake hiswiyen wik (12) menempetɨt meriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hɨr mɨt kerek naam menmen hɨr yapɨrwe nar 5,000 mɨt. Hɨr ap newenhis mɨyapɨr netike nɨkerek nau netikeri au. ");
INSERT INTO avt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas kewtɨr menmen epei au, hɨrak katɨp mɨt nɨrak disaipel nehɨn nɨniu nen nekre bot naninɨn nanɨno wan pɨnak ein te hɨrak kaku kakriuwet mɨt miyapɨr yapɨrwe nanɨno. Epei au, hɨrak kakisesi. ");
INSERT INTO avt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jisas keriuweti nen te hɨrak hɨrekes kɨniu mɨniu (o neiyɨp) ken kakitehi God menmen. Nepei hɨnkewɨ kakre wɨtaan hɨrak kiutɨp kerekek kepu. ");
INSERT INTO avt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bot hɨrak epei ken wan nɨmɨniuwe eik, te nɨme mɨniu meke bot paan kɨrak te wan sɨr mɨniu mamuwer bot. ");
INSERT INTO avt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Epei menep wanewik hɨram wen toto, Jisas keriuwe hɨt mɨrak keke niu kitet wan ken kakɨr mɨt nɨrak disaipel. ");
INSERT INTO avt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hɨr nɨrek keriuwe hɨt mɨrak keke niu kitet wan te hɨr neperper, hɨr natɨp, “Hɨrak herwe.” Te hɨr nenepɨp nenɨne hɨm iuwe. ");
INSERT INTO avt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wasenum Jisas kenɨne ketpor, “Yi ap einapen. Yi einakɨn tokim. Hi kerekek han. Hi ap herwe auye!” ");
INSERT INTO avt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita kewenhi ketpɨwek kar ik: “Kaiu Iuwe, ti hɨrekes te ti etpo hi eriuwe hɨt mai eitet wan anen arit.” ");
INSERT INTO avt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas katɨp, “Ti enen.” Te Pita kɨnaaiwɨr bot keriuwe hɨt mɨrak kitet wan ken kakɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pita kɨr nɨme mɨniu te hɨrak kɨnapen, hɨrak kaknatɨn kakno kakɨm tɨpar kakɨkre wan. Te hɨrak kenɨne, “Kaiu Iuwe ekepa!” ");
INSERT INTO avt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wasenum Jisas kewis his ketenen Pita, hɨrak ketpɨwek, “Ti ap han kiteta hi Iuwe au? Ti henmak te ti heit han wik wik?” ");
INSERT INTO avt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nepei au, hɨrakɨt wiketeret tɨniu tau bot te nɨme maa meit. ");
INSERT INTO avt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hɨr mɨt kerek nau bot en nɨr menmen im, hɨr newenɨpi Jisas natɨp, “Haiu mertei werek ti Nɨkan ke God.” ");
INSERT INTO avt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hɨr epei nerekir wan nen pɨnak ein niun tɨ ke Genesaret. ");
INSERT INTO avt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hɨr mɨt ne wit ik ek hɨr nertei hɨrak Jisas te hɨr nesiuwe hɨm men merer wit wit kerek menep menep ek, hɨr neithis mɨt kerek nɨnap ek neri nan. ");
INSERT INTO avt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hɨr neri nen epei au, hɨr nɨnap natɨp hɨm iuwe nitɨwekhi hɨrak ekwisi hɨr hɨras enwis his entenen yɨnk kɨrak o laplap hɨr mɨrak. Hɨr mɨt miyapɨr kerek newis his netenen laplap hɨr mɨram netike mɨt netenen yɨnk kɨrak, hɨr yapɨrwe nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hɨrak Jisas wen kepu wit Genesaret, mɨt han ne farisi netike mɨt skraip kerek ninɨn nertei hɨm me Moses natɨp mɨt em, hɨr nɨnaaiwɨr Jerusalem nan nɨr Jisas nitɨwekhi menmen. ");
INSERT INTO avt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hɨr natɨp, “Nenmak te hɨr mɨt disaipel nit nɨrɨak menmen ap nises menmen kerek nɨpaa maamrer naiu nɨrɨakem? Hɨr nanɨm menmen hɨr ninɨn nekemyet his. Te mɨt disaipel nit au.” ");
INSERT INTO avt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas kewenhi ketpor, “Yenmak te yi ap yises menmen me God te yi yises hɨm nɨpaa mɨt kerek yi yisesi hɨr newetiyem netpiyem a? ");
INSERT INTO avt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nɨpaa God katɨp, ‘Yi eiyɨmtau hɨm me miye haai ni te maain yi naanmampri. Mɨtɨk kerek katɨp enum ke menmen miye haai nɨrak, yi mɨt eikɨp kaki.’ ");
INSERT INTO avt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Te yi yises hɨm im au. Yi yatɨp, ‘Mɨtɨk keiyak ketenen pewek o menmen kakɨkaap miye haai nɨrak, te hɨrak katɨp miye haai, “Hi epei hehimɨtan im em te hi ewet God em. Hi ap naanempri eriuwerem au.” ");
INSERT INTO avt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yi yatɨp hɨram werek hɨrak ap ekɨkaap miye haai nɨrak neriuwerem au.’ Me menmen mar im yi yerekir hɨm me God yeriuwe hɨm ham me maamrer ni yi yisesim. ");
INSERT INTO avt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yi mɨt enun yemipɨn. Mɨtɨk profet Aisaia nɨpaa kehimɨteni werek me wɨ hɨrak katɨp hɨm me God kar ik. Hɨrak katɨp, ");
INSERT INTO avt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mɨt in en hɨr hanhan newenɨpi niuk mai neriuwe hɨm mɨr, te han kɨr au nisɨsa werek werek au. ");
INSERT INTO avt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Menmen hɨr netpim newenɨpi niuk mai neriuwerem hɨram au enum menmen weinɨm. Menmen hɨr natɨp mɨt hɨr enisesim hɨram ap hɨm mai au. Hɨm mɨr weinɨm.’” ");
INSERT INTO avt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas ketpor epei au, hɨrak kenɨne mɨt miyapɨr nan nɨrek, hɨrak ketpor, “Yi eiyɨrteiyem han ekitetim werek werek! ");
INSERT INTO avt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Menmen kerek mɨt hɨr nanɨm menip God katɨp hɨr mɨt enun au. Menmen mɨt netpim hɨram menip God katɨp hɨr mɨt enun.” ");
INSERT INTO avt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hɨrak ketpor nepei au, mɨt nɨrak disaipel nan natɨp Jisas, “Ti hertei mɨt ne Farisi nemtau hɨm ti hetpim em te hɨr han enuk neperper?” ");
INSERT INTO avt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas kewenhi katɨp, “Haai kai kau wit kɨrak Heven hɨrak menmen mɨrak mau ni. Menmen kerek hɨrak ap kamɨr au, hɨram mewo weinɨm, maain hɨrak kakɨketim mamriuwe nekenik mɨram mamno. ");
INSERT INTO avt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yi eiwisi enu en. Hɨr nɨre mɨt nanamɨr enuk toto, te hɨr nanteikɨn mɨt han kerek nanamɨr toto en yayiwe hɨr enisesim te hɨr nanɨr God. Te nanamɨr toto kakteikɨn mɨtɨk hak nanamɨr toto yayiwe, hɨrakɨt wiketeret tatɨnkewɨn tatɨkre wi.” ");
INSERT INTO avt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita kewenhi katɨp Jisas, “Ti ewepyapɨr hɨm me tok piksa, te haiu emɨmtewem.” ");
INSERT INTO avt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","17","Jisas katɨp, “Yi ap han kewi au a? Yi yɨre mɨt han en a? Yi ap yertei menmen kerek mɨtɨk hɨrak kewisim mekre hɨm hɨram men mekre nɨnpɨ tɨwaak te maain hɨrak kakno kaknerem mamɨkre hei? ");
INSERT INTO avt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Te menmen mekre han ke mɨt, maain hɨr netpim, im hɨram menip God katɨp mɨt hɨr enun. ");
INSERT INTO avt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Menmen kerek metpaan meke han ke mɨtɨk hɨram mar im: han kitet menmen enum, kenep mɨt naa, kari miyapɨr his kewenem, kekintɨp menmen, kewenɨn hɨm, katɨp kenip mɨtɨk hak yɨnk enuk. ");
INSERT INTO avt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Menmen im em hɨram menip God katɨp mɨtɨk ik hɨrak enuk. Mɨtɨk ap kekemyet his wen au, te hɨrak kakɨm menmen, hɨram ap te mamnip God kaktɨp mɨtɨk kar ik hɨrak enuk au.” ");
INSERT INTO avt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas kɨnaaiwɨr wit Genesaret te hɨrak ken tɨ ke wit Taia ketike Saidon. ");
INSERT INTO avt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mɨte hap pe Kenan kerek wau wit eik kerekek, hɨre wan wenɨnɨwek hɨm iuwe wetpɨwek, “Mɨtɨk Iuwe ti Nepenyek ke Devit, ti han etwenɨna. Herwe enum mewaank nɨki pai.” ");
INSERT INTO avt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Te Jisas ap kewenhi ketpɨwe menmei au. Hɨr mɨt disaipel nan nɨrek netpɨwek, “Mɨte ip ep hɨre wenɨne wenɨne wisesai wan. Ti ekepiye te hɨre wauno.” ");
INSERT INTO avt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisas ketpor, “Au, God keriuweta te hi han hɨkaap mɨt kerek ne weiwɨk miutɨp me Isrel, hɨr nɨre sipsip nɨsawɨn neit yaank. Mɨt han au.” ");
INSERT INTO avt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hɨrak katɨp epei au, mɨte kerepep wan wewen ninɨp werp hɨt me Jisas watɨp, “Kai Iuwe, ti ekepa.” ");
INSERT INTO avt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisas ketpɨwe tok piksa kar ik: “Hɨram enum te haiu mamkin menmen me nɨkerek mamwɨrem mamno mamwet nepere rem, hɨram mamɨm.” ");
INSERT INTO avt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mɨte watɨp, “Kai Iuwe, ti hatɨp werek. Haiu enun mɨre nepere. Te nepere hɨram mekorɨr menmen kerek miye haai nɨr naam hɨram mɨnatɨn mɨwaai yeno kerek hɨr naam menmen menterim.” ");
INSERT INTO avt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hɨre watɨp war ik te Jisas ketpɨwe, “Mɨte ti eises hɨm me God werek werek. Menmen ti hanhan em hɨram mamnen.” Hɨrak katɨp epei au, waswas mɨte nɨki pɨre hɨre wɨre yaaip. ");
INSERT INTO avt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","In ek Jisas kɨnaaiwɨr Taia ketike Saidon te hɨrak ken kitet menep wan ke Galili. Hɨrak ken kɨniu mɨniu (o neiyɨp) ken kau nu ein. ");
INSERT INTO avt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mɨt miyapɨr yapɨrwe nan nererik nɨrek, hɨr neithis mɨt kerek hɨt enum o han kɨr enuk, hemik meweikɨn, han auri netike menmen ham yapɨrwe hɨr neri nan nɨrek. Hɨr newisi nɨwaai menep hɨt me Jisas te hɨrak kerekyorem hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hɨr mɨt miyapɨr nɨr menmen im te hɨr han kekrit hɨr han kitetim nentar hɨr nɨr mɨt kerek han auri en natɨp, hemik mɨn em mɨre yaaim. Mɨt nanamɨr toto en hɨr nɨr ein ein werek werek. Mɨt kerek hɨt enum hɨr nitet ein ein. Hɨr nɨr menmen im te hɨr newenɨpi God ke mɨt ne Isrel neriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas kekepi epei au, hɨrak kenɨne mɨt disaipel nɨrak nan, hɨrak katɨp, “Hi hanhan heriuwe hɨr mɨt miyapɨr ein en. Wɨ wikak epei men hɨr nau netikewa te hɨr menmen me nanɨm em au. Hi hɨnapen esiuweri nɨnpɨ mamɨn nanɨno te hɨr nani nanɨtɨn yayiwe.” ");
INSERT INTO avt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Te hɨr mɨt disaipel natɨp Jisas, “In en ap mɨt nei newi. Te haiu mamɨt menmen mamoke nein te mamwet mɨt yapɨrwe rem te hɨr nanɨm?” ");
INSERT INTO avt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisas kitorhi, “Yi yetenen bret marmenum?” Hɨr natɨp, “Haiu metenen bret hispɨnak wik (7), saauk kike kiutɨp kiutɨp.” ");
INSERT INTO avt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hɨr netpɨwek epei au, Jisas katɨp mɨt miyapɨr hɨr nanu tɨ. ");
INSERT INTO avt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jisas kekin saauk metike bret hispɨnak wik (7), hɨrak kitehi God em kewepim kewet mɨt nɨrak disaipel em, hɨr newet mɨt yapɨrwe rem. ");
INSERT INTO avt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hɨr yapɨrwe naam ere tu iuwe, te hɨr neit yinam kerek mɨt ap naam te hɨr nemi mekre wapnake mar hispɨnak wik (7). ");
INSERT INTO avt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hɨr mɨt naam menmen hɨr nar 4,000, te hɨr ap newenhis nɨkerek miyapɨr nau netikeri au. ");
INSERT INTO avt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas keriuwet mɨt miyapɨr nen. Hɨrak keriuweti nen, hɨrak kehɨn kɨniu kekre bot ketike mɨt nɨrak disaipel, hɨr nerekir wan nen tɨ ke mɨt nau neit Magadan. ");
INSERT INTO avt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hɨr mɨt ne Farisi netike mɨt ne Sadyusi kerek han kitet mɨt epei naa ap pɨke nanɨkrit nanu au, hɨr nan nɨr Jisas. Hɨr nanmitɨwekpɨn nanri han kɨrak me ekrɨak menmen yaaim ekɨkaap mɨt ekriuwerem te hɨr nertei God keriuwetek kan. ");
INSERT INTO avt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te Jisas ketpor, “Hɨnkewɨ epei man yi yatɨp nepni mɨre ninɨm te teipmen hɨram wepni yaaik. ");
INSERT INTO avt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yi yekrit yatɨp, ‘Napɨ mɨre nɨpɨak wepni kɨre ninɨk, hauwɨ kaknen.’ Yi yɨr menmen mau nepni te yi yertei werek werek mekam mamnen. Te yi ap yertei werek werek han kitet menmen God kɨrɨakem me wɨ im a? ");
INSERT INTO avt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yi mɨt miyapɨr yapɨrwe enun, yi ap yises God werek werek au! Yi yitauhi hi hɨrɨak menmen yaaim te yi eiyɨrtei God keriuweta hi han te hi ap arɨak menmen te yi yayɨrem au. Hi eteikni menmen me Jona kerek nɨpaa kaa kekre saauk tu mɨrak. Wɨ wikak epei au, hɨrak pɨke kekrit kau.” Hɨrak keptor epei au, hɨrak kɨnaiwɨri ken. ");
INSERT INTO avt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hɨr mɨt disaipel nau bot nerekir wan nanɨno, te hɨr han kaa ap neit niu metikeri neiyɨm nen. ");
INSERT INTO avt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas ketpor tok piksa kar ik: “Yi naanempre hɨras yi einopɨn yis me Sadyusi netike mɨt ne Farisi.” ");
INSERT INTO avt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Te hɨr hɨras han kitet natɨpan nar ik: “Hɨrak ketpim kentar haiu ap meit bret mei meiyɨm man metikewai.” ");
INSERT INTO avt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas kertei menmen hɨr netpim te hɨrak katɨp, “Yi mɨt in en ap han kiteta hi Iuwe naanempri au. Yenmak te yi yatɨp haiu ap meit bret mei au? ");
INSERT INTO avt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yi ap yertei menmen werek wen au a? Te yi ap han ekitet bret mar hispɨnak (5) mɨt nar 5,000 hɨr naam, te wapnake mar hiswiyen wik (12) yi yemi mekrerem? ");
INSERT INTO avt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te yi ap han ekitet bret hispɨnak wik (7) kerek mɨt nar 4,000 hɨr naam, te wapnake mar hispɨnak wik (7) yi yemi mekrerem a? ");
INSERT INTO avt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yenmak te yi ap yertei hi ap hetpi menmen me bret. Yi naanmamre hɨras me hɨm me mɨt ne Farisi netike mɨt ne Sadyusi.” ");
INSERT INTO avt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hɨrak ketpor epei au, hɨr nertei hɨrak ap ketpor naanmɨpre hɨras me yis me bret au. Hɨrak ketpor hɨr naanmɨpre hɨras hɨr ap nises hɨm me Farisi netike hɨm me mɨt ne Sadyusi, kerek hɨr natɨp mɨt enisesim. ");
INSERT INTO avt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Maain me wɨ Jisas ken tɨ menep wit Sisaria Filipai hɨrak kitehi mɨt disaipel nɨrak, “Hɨr mɨt miyapɨr hɨr natɨp hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, hi keimɨn?” ");
INSERT INTO avt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hɨr natɨp, “Mɨt han natɨp ti Jon kerek kɨkɨr mɨt neriuwe tɨpar. Mɨt han natɨp ti profet Ilaija kerek nɨpaa kau tɨ. Mɨt han natɨp ti Jeremaia o mɨtɨk profet hak nɨpaa nepu tɨ.” ");
INSERT INTO avt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Te Jisas ketpor, “Yi han kitet hi keimɨn?” ");
INSERT INTO avt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon niuk mɨrak ham Pita hɨrak kewenhi ketpɨwek, “Ti Nɨkan ke God kerek kaku kakɨt tipmain tipmain enum eik. Ti Mɨtɨk Krais kerek hɨrak keriuwetit ti anen tɨ ekaap haiu mɨt etaihis.” ");
INSERT INTO avt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas ketpɨwek, “Saimon nɨkan ke Jona, God han yaaik keriuwit. Ap mɨtɨk kei ke tɨ ik ek keteiknut hɨm im em au. Haai kai God kau wit kɨrak hɨrak keteiknut menmen im. ");
INSERT INTO avt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Hi hetput, ti Pita ti hɨre teinɨk. Ti ekaap mɨt miyapɨr yapɨrwe nanises hɨm mai. Te menmen ham meke Seten mamnen hɨram ap te maminɨni au. ");
INSERT INTO avt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Te maain hi ewisit ti ekrehɨr kai. Ti atɨp menmen mɨt miyapɨr kerek nanises hɨm mai hɨr nanrɨakem. Menmen ti hetpor hɨram werek hɨr nisesim. God keit wit kɨrak kaktɨp hɨram yaaim. Menmen ti hetpor hɨram enum hɨr ap te nanisesim nanu tɨ im, God kakɨt wit kɨrak kaktɨp, ti hetpor werek werek.” ");
INSERT INTO avt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jisas katɨp mɨt disaipel kewɨrnak kekteni ap te enwepyapɨrek entɨp mɨt han hɨrak Krais, Mɨtɨk kerek God keriuwetek kan kɨkaap mɨt ne tɨ. ");
INSERT INTO avt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Me wɨ im ere maain Jisas katɨp mɨt disaipel nɨrak hɨrak kakno wit Jerusalem, te mɨt iuwe ninɨn naanmɨpre mɨt netike mɨt iuwe ne pris, mɨt nertei hɨm me Moses nanrekyɨwek enum yɨnk kɨrak kakɨkek hɨr nankɨp kaki. Hɨrak kaki kakwaai ere wɨ wikak, te hɨrak pɨke kakɨkrit. ");
INSERT INTO avt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hɨrak ketpor epei au, Pita keithis Jisas keiyɨk ken pɨn eik te hɨrak kenerek kentar hɨrak katɨp hɨrak kaki. Hɨrak ketpɨwek, “Ti kaiu Iuwe kerekek taau. Menmen ti hetpim hi hanhan God ap te kakwisɨm mamnen taau.” ");
INSERT INTO avt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas keweikɨn katɨp Pita, “Seten ti eno sip kai enopɨn. Ti hanhan hari han kai enuk. Ti ap han kitet menmen mar ke God han kitetim au. Ti han kitet menmen mar kerek mɨt keriyen han kitetim.” ");
INSERT INTO avt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hɨrak ketpɨwek epei au, Jisas katɨp mɨt disaipel nɨrak, “Mɨt kerek hanhan nisɨsa, hɨr enwenɨn han kɨr me menmen hɨr hanhanem, te hɨr ap nɨnapen te nani nanɨr maain hi hahi entar nu tentarakɨt. ");
INSERT INTO avt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mɨt kerek hanhan nani au, nanu werek, maain mɨt in hɨmɨn kɨr kakɨwaank. Te mɨt kerek nisɨsa ap nɨnaain mɨt nanɨnɨp nani nanɨnterik, te maain hɨmɨn kɨr kaku werek. ");
INSERT INTO avt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mɨtɨk hak ketenen menmen yapɨrwe kerek aku tɨ ik ek te hɨrak ap kises God au, maain hɨrak kaki te hɨmɨn kɨrak kakɨwaank. Te menmen yapɨrwe kerek nɨpaa hɨrak ketenenim mau tɨ ik mamkepik te God kaktɨp hɨrak yaaik mamɨrkeik a? Taau! Te hɨrak kakɨt mekam keiyɨm kakɨkaap hɨmɨn kɨrak kaku werek kakɨt wit ke God a? Taauye! ");
INSERT INTO avt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Maain hi Mɨtɨk Iuwe ke wit ke Mɨtɨk Iuwe, hi pɨke anen ariuwe menmen iuwe me Haai kai merhɨhe mɨre si. Te mɨt ensel nɨrak nanɨnen nantikewa me wɨ hi pɨke anen. Me wɨ im hi arɨak mɨt miyapɨr ne tɨ ik ek menmen yaaim o menmen enum mampar kerek nɨpaa nau tɨ ik ek hɨr nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Hi hetpi werek. Mɨt han kerek neperp in en ap epei naa te hɨr ninɨn nanɨr hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, hi anen ariuwe menmen mai Iuwe te hi ehinɨn naanmamre mɨt.” ");
INSERT INTO avt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wɨ hispɨnak kiutɨp (6) epei men, Jisas keithis Pita ketike mɨtɨkɨt wik Jems ketike nɨkik kɨrak Jon. Hɨrak keryei keri ken mɨniu (o neiyɨp) hak enuk kau niu ein. Hɨrakɨt keriyen tepu. ");
INSERT INTO avt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hɨrakɨt tepu en, yɨnk ke Jisas keweikɨnhis kɨre hak, hɨrakɨt tɨrek teriuwe nanamɨr. Te ninaan mɨrak mɨr mɨre wepni kɨr, laplap mɨrak mir mɨre si merhɨhe. ");
INSERT INTO avt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moses ketike Ilaija wiketeret tɨnaaiwɨr wit ke God tan te hɨrakɨt disaipel wikak tɨr mɨtɨkɨt wiketeret tatɨp tetike Jisas. ");
INSERT INTO avt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita kɨr menmen im te hɨrak katɨp Jisas, “Haiu mau in hɨram yaaim. Te ti hanhana, hi aime weisaak mei mamrɨri mamwaai in. Ham hɨram mit, ham me Moses, ham me Ilaija.” ");
INSERT INTO avt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hɨrak wen ketpim, napɨ kɨre hike kewen kan kɨwapɨni. Te mɨtɨk hak katɨp kekre napɨ kewen kan katɨp kar ik: “Mɨtɨk ik hɨrak Nɨkan kai yaaik. Hi hanhan heriuwerek. Yi eiyɨmtau hɨm mɨrak eiyisesim!” ");
INSERT INTO avt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te hɨrakɨt mɨtɨkɨt disaipel temtau hɨm im keremem, hɨrakɨt tewen ninɨp tewis ninaan mɨwaai tɨ, te hɨrakɨt tepɨrpɨr wɨsenum. ");
INSERT INTO avt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas kan menep kɨret ketenenikɨt ketpɨwekɨt, “Yi eiyɨkrit. Yi ap einapen!” ");
INSERT INTO avt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Te hɨrakɨt tekrit terenaan ap tɨr mɨtɨk keiyak. Au, hɨrakɨt tɨr Jisas kerekek. ");
INSERT INTO avt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hɨr nɨnaaiwɨr mɨniu (o neiyɨp) te hɨr wen nekiuwe nepno, Jisas ketpɨwekɨt hɨm manp, “Menmen im yi epei yɨrem ap te yi pɨke eitɨp mɨt han em. Hɨram mamɨkre (o mamrɨau) han ki ere maain hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi hahi, hi pɨke ekrit ahu.” ");
INSERT INTO avt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hɨrak ketpɨwekɨt epei au, hɨrakɨt mɨtɨkɨt disaipel tɨrak titɨwekhi, “Nenmak te mɨt nertei hɨm me Moses natɨp Ilaija kakinɨn kaknen, te maain mɨtɨk kerek God keriuwetek kakɨkaap haiu mɨt kaktaihis hɨrak kakisesik?” ");
INSERT INTO avt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas ketpɨwekɨt, “O, hɨram werek. Ilaija hɨrak kakinɨn kaknen kakrɨak menmen yapɨrwe mamre yaaim. ");
INSERT INTO avt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Te hi hetpi, Ilaija epei kan, te hɨr mɨt ap nerteiyek au. Hɨr nises han kɨr te hɨr nerekyɨwek enum. Mar im te hɨr nanrekya hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, hɨr nanrekyau menmen enum nanrewaank.” ");
INSERT INTO avt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas katɨp kar ik, te hɨrakɨt mɨtɨkɨt disaipel tertei hɨrak katɨp ke Jon kerek kɨkɨr mɨt nekre tɨpar keremem. ");
INSERT INTO avt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hɨr nen ere niun mɨt miyapɨr yapɨrwe en, mɨtɨk hak ken kɨr Jisas kewen ninɨp kerp hɨt mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Hɨrak katɨp, “Mɨtɨk Iuwe, ti hanhan heriuwe nɨkan kai. Hɨrak enuk ketaritari te yɨnk kɨrak au enuk. Wɨ yapɨrwe hɨrak kaa kenke kekre si, kekre tɨpar. ");
INSERT INTO avt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Hi epei etɨwekhis heiyɨk han mɨt disaipel nit, te hɨr ap nɨrɨakek kɨre yaaik.” ");
INSERT INTO avt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas katpor, “Yi mɨt miyapɨr yau tɨ in en ap yises hɨm me God werek werek au. Te han ki ap yaaik. Wɨ marmenum te hi ehu ektikewi te yi yises God werek werek? Yi eitɨwek his eiyɨk einen in.” Hɨr neiyɨk nan newisɨk keit Jisas. ");
INSERT INTO avt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Epei au, Jisas kene herwe enum keremem, te hɨram mɨnaaiwɨr nɨkan kerekek men, te wasenum hɨrak kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maain mɨt disaipel nɨrak neit wɨnak hɨr nitehi Jisas netpɨwek, “Haiu menmak te haiu ap mamkaap nɨkan kike kerekek mamɨpɨr herwe enum mamno?” ");
INSERT INTO avt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisas ketpor, “Yi ap yises God werek werek au, te yi ap yepɨr herwe ik au. Hi hetpi werek, yi yises hɨm me God werek im e mɨre nu mastet nɨkim mɨrak, te yi eitɨp mɨniu (o neiyɨp) ik ek, ‘Ekrit eno pɨnak ein en,’ te hɨrak kakɨkrit kakno. Yi yises God werek te menmen yi yɨrɨakem hɨram mampar keremem mamnen.” ");
INSERT INTO avt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Te ap menmeiyam me yeiyɨm yaiyɨpɨr herwe im em taau. Yi nɨnpɨ miwei eiyu eiyɨt me yi eiyitehi God menmen, te yi eiyɨpɨr herwe im keremem.” ");
INSERT INTO avt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Maain Hɨr nariyan nitet Galili te Jisas katɨp mɨt disaipel nɨrak: “Maain hɨr mɨt nanriuweta hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi ano his me mɨt enun. ");
INSERT INTO avt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Te hɨr naniyep hahi. Me wɨ wikak hɨrak God pɨke kakɨkoya hi pɨke ahɨkrit ahu are mɨtɨk.” Hɨr nemtau menmen hɨrak kepɨwekɨtem, te hɨr han enuk. ");
INSERT INTO avt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas ketike mɨt nɨrak disaipel epei nen niun wit Kapaneam. Mɨt kerek neit pewek me takis me wɨnak ke God hɨr nan nitehi Pita, “Mɨtɨk Iuwe kit hɨrak kewɨr pewek me takis me wɨnak ke God a?” ");
INSERT INTO avt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita hɨrak ketpor, “O hɨrak Mɨtɨk Iuwe kaiu kepwɨrem.” Hɨrak katɨp epei au, hɨr nen nɨnɨk wɨnak eik ek te Jisas kitehi Pita, “Pita ti han kitet mekam? Mɨt iuwe naanmɨpre mɨt ne tɨ hɨr nari pewek me takis me nɨkerek nɨr o me mɨt han? ");
INSERT INTO avt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ketpɨwek, “Mɨt nɨrak au. Mɨt han keriyen.” Jisas ketpɨwek, “Te mɨt ne mɨtɨk Iuwe ap nanwɨr pewek a? Te hi ap te hewɨr pewek a! Haiu nɨkerek ne God te haiu ap mamwɨr pewek naanmampre wɨnak kɨrak au. ");
INSERT INTO avt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hɨram yaaim te hi ap hewɨr pewek hɨrɨak mɨt han enuk neriuwerem. Te ti eno wan ewɨr strin huk mewik ere ti eri saauk eknen tenhaan ik. Te saauk hak kerek epei ti heriyaak kinɨn kan tenhaan ik ek, te ti etenenik ewep hɨm kɨrak te ti ehɨr pewek mau mekrerek. Ti eiyɨm eno ewɨrem ewet mɨt pewek me takis mawɨr.” ");
INSERT INTO avt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Me wɨ im mɨt disaipel nan nɨr Jisas netpɨwek, “Keimɨn hɨrak kinɨn mɨt han te hɨrak kɨre iuwe ke mɨt miyapɨr kerek nises hɨm me God?” ");
INSERT INTO avt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hɨr netpɨwek, te Jisas kenɨne nɨkan hak kan te hɨrak kewisɨk kerp nɨmɨn ke mɨt yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Epei au, hɨrak katɨp, “Hi hetpi hɨm werek. Yi ap eiweikɨn sip eiwet menmen yi yisesim yi eiyises God eiyɨr ke nɨkerek kike hanhan nises hɨm me miye haai nɨr, te yi ap eiyu eiyɨr ke mɨt ne weiwɨk me God. Taau! ");
INSERT INTO avt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mɨtɨk kerek kewenɨn han kɨrak ke menmen yapɨrwe hɨrak hanhanem, te hɨrak kises menmen miutɨp kar nɨkan ik ek kisesim, hɨrak kinɨn mɨt han ne weiwɨk miutɨp me God, hɨrak kakises God werek werek. ");
INSERT INTO avt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te mɨt kerek naanempre mɨtɨk kiutɨp kɨre nɨkan ik nentar hɨr nises hɨm mai, hɨram mar ke hɨr nekepa. ");
INSERT INTO avt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Te mɨtɨk hak kiutɨp kakri han ke mɨt weinɨn hɨr nɨre nɨkerek kike in te hɨr nises menmen enum ap nises hɨm mai au, hɨram yaaim te hɨr mɨt han enwenkek nan iuwe kiutɨp eku tɨmɨr kɨrak te hɨr enwɨrek ekno ekɨkre wan nɨmɨn iuwe ein kaki te maain God ap kakɨkɨp kakɨwaankek wɨsenuk ke menmen im. ");
INSERT INTO avt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Menmen enum mamwɨwaank mɨt miyapɨr nau tɨ nanri han kɨr te hɨr nanises menmen enum. Hekrit hekrit menmen enum mari han ke mɨt miyapɨr yapɨrwe, te maain God kakɨwaank mɨt o miyapɨr kerek nɨrɨakem nari han ke mɨt miyapɨr han neriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Yi yɨrɨak menmen enum eiriuwe his o hɨt mi, yi eiremir eiwɨrem emno. Hɨram yaaim yi his hɨt miutɨp te yi eitike God eiyu werek. Hɨram enum te his hɨt wik mamu te hɨr nanri yi eino eikre si enum kerek mamu mamɨt tipmain tipmain enum eik ap te mami au. ");
INSERT INTO avt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nanamɨr ki kɨr menmen kakri han ki me menmen enum, te yi eiketik eiwɨrek ekno. Hɨram yaaim yi nanamɨr kiutɨp kaku te yi eiyu werek eitike God. Hɨram enum yi nanamɨr wik te hɨr nanwɨri yi eino eikre si enum me hel, wit kerek God kakɨwaank mɨt keriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Yi naanempre hɨras werek werek te yi ap han ekitet mɨtɨk kei weinɨk kerek kises hɨm mai. Hi hetpi werek. Mɨt ensel kerek naanmɨpre mɨt miyapɨr nisɨsa hɨr nanɨno nanɨr Haai kai God kakɨt wit kɨrak, hɨr nanɨswi hɨm me menmen enum yi yɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yi ap yerekyor enum yentar hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi han hɨnhatɨn akepi ahɨthis mɨt miyapɨr nises menmen enum te hɨr nanises hɨm mai. ");
INSERT INTO avt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Yi han kitet mekam? Mɨtɨk hak kewis 100 sipsip te sipsip hak kiutɨp kɨrɨr kɨsawɨn keit yaank, te hɨrak ap te kakɨnkakɨtnɨwek pɨke kaknanek o au? Hɨrak kakwis 99 sipsip mamɨrp mɨniu eik hɨrak kakno kakɨnkaktɨn hak kiutɨp epei keit nein eik. ");
INSERT INTO avt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hi hetpi werek. Maain hɨrak kɨnapɨnek epei au, hɨrak han yaaik wɨsenuk kenterik, te hɨrak han yaaik kike keriuwe 99 sipsip ap meit nein ek kentar hɨram mepu werek. ");
INSERT INTO avt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mar im Haai ki God kau wit kɨrak Heven kɨnapen mɨtɨk keiyak kiutɨp ke yi nɨkerek kike nɨrak kakweikɨn sip kakwetɨwek kakɨwaank hɨrekes. ");
INSERT INTO avt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Te mɨtɨk kit hɨrekes kerekyut menmen enum ti eno ehɨrek te ti eteiknɨwek menmen enum hɨrak kɨrɨakem. Hɨrak kemtau hɨm mit kisesim keweikɨn sip kewetɨwem, te ti epei hetɨwek his kɨnaaipɨs menmen enum. ");
INSERT INTO avt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Te hɨrak ap kemtau hɨm mit, ti ehɨt his mɨtɨk keiyak kiutɨp o wiketeret, te yi eiriyakɨt eino. Mar im te yi wikak eiwepyapɨr menmen hɨrak kɨrɨakem kesiuwek hɨm. ");
INSERT INTO avt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te hɨrak ap kemtau hɨm mi, te yi eitɨp mɨt han ne weiwɨk me God. Te hɨrak ap kemtau hɨm mɨr te yi einerek mɨtɨk enuk hanhan kises menmen enum. Yi eiyɨpɨrek ap eitikerek yɨrɨak menmen ham au.” ");
INSERT INTO avt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jisas katɨp, “Hi hetpi werek menmen yapɨrwe enum yi ap yesakem meit tɨ ik ek, keremem te God ap kakɨsakem kakɨt wit kɨrak. Menmen yi yesakem yayɨt tɨ ik ek, te God kakɨsakem kakɨt wit kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Te hi hetpi werek. Mɨtɨkɨt wiketeret te tɨ ik yi han kɨpɨrakɨt me menmen miutɨp te yi yitehi God em, Haai kai God kau wit kɨrak kakrekyiyem. ");
INSERT INTO avt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Hɨrak kakrekyiyem yi eitɨwem eiyɨntar yi mɨtɨkɨt wik o wikak yi yererik yentar yi yisɨsa yi eiyɨrtei God te hi ahu atikewi ekre nɨmɨn hi akepi.” ");
INSERT INTO avt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jisas katɨp epei au, Pita kan kɨr Jisas ketpɨwek, “Mɨtɨk Iuwe, kai yinak hɨrak kakrekyo menmen enum te hi akepik anke menmen enum mɨrak emno emkeipnɨwek mamɨrmenum? Ti arekyewem mar ke hispɨnak wik (7) hɨram werek?” ");
INSERT INTO avt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas ketpɨwek, “Hi ap hetput are mamɨr hispɨnak wik (7) au. Hi hatɨp ti ekepik enke menmen enum kerek hɨrak kɨrɨakemem ere yapɨrwe mar ke 490. ");
INSERT INTO avt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Menmen haiu mɨt kerek mises God haiu mɨrɨakem hɨram mɨre menmen mɨtɨk iuwe ke gavman hɨrak kɨrɨakem. Hɨrak katɨp hɨrak kakɨt pewek yapɨrwe nɨpaa mɨt kerek nɨrɨak menmen mɨrak hɨr netɨwem weinɨm te hɨr ap pɨke newetɨwekem mererim wen au. ");
INSERT INTO avt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hɨrak kɨrɨak menmen me mɨt netɨwem weinɨm ap epei newetɨwek pewek mererim wen au, hɨr neithis mɨtɨk hak neiyɨk nan. Nɨpaa hɨrak ketenen pewek me mɨtɨk ik mar 10 milion kina te hɨrak ap kewetɨwekem mererim wen au. ");
INSERT INTO avt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te hɨrak ap ketenen pewek iuwe mar im te kakwetɨwekem mererim au. Te mɨtɨk iuwe katɨp hɨr anɨthis mɨtɨk ketike mɨt nɨkerek netike menmen mɨr ham yapɨrwe hɨr nesiuwerem nanɨt nan mamrerim me menmen nɨpaa hɨrak ketɨwem weinɨm me mɨtɨk iuwe ik. ");
INSERT INTO avt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hɨrak katɨp epei au, te mɨtɨk kerek kɨrɨak menmen me mɨtɨk iuwe kewen ninɨp kitehi katɨp mɨtɨk iuwe kar ik: “Ti hanhan heriuwa, wen ewisa pewek hi hewetut menmen yapɨrwe mit nɨpaa hi heriyaam.” ");
INSERT INTO avt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te mɨtɨk iuwe hanhan keriuwerek kerek nɨpaa hɨrak ketɨwem weinɨm em meit, hɨrak ketpɨwek hɨram menmen weinɨm te hɨrak kɨnaiwɨrek ken. ");
INSERT INTO avt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Maain mɨtɨk kerek kɨrɨak menmen me mɨtɨk iuwe ketpaan ken wit eik, te hɨrak kɨr mɨtɨk wariyakɨt kɨrak kerek nɨpaa hɨrak kewetɨwek pewek mar 100 kina, te hɨrak kewetɨwekem mererim au. Te hɨrak ketenenik kɨr enum kau teruk kɨrak ketpɨwek, ‘Ti eweto pewek emrer mai kerek nɨpaa ti hetɨwem.’ ");
INSERT INTO avt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hɨrak ketpim nepei au, te wariyakɨt kɨrak kewen ninɨp kau kitɨwekhi ketpɨwek hɨm iuwe kar ik: ‘Ti hanhan heriuwa te ti hewisa ere maain te hi pɨke ewetitem.’ ");
INSERT INTO avt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Te hɨrak kɨnapen. Hɨrak ken kewɨrek kekre wɨnak enuk kaku kakɨt ere maain hɨrak kakrer pewek nɨpaa hɨrak ketɨwem. ");
INSERT INTO avt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Te hɨr mɨt wariyan nɨrak nɨr menmen hɨrak kerekyɨwekem hɨr han enuk neriuwerek. Te hɨr nen newepyapɨr menmen enum hɨrak kɨrɨakem natɨp mɨtɨk iuwe kɨr em. ");
INSERT INTO avt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hɨr netpɨwek epei au, te mɨtɨk iuwe kenɨne mɨtɨk kerek nɨpaa kɨrɨak menmen en ketpɨwek kar ik: ‘Ti mɨtɨk hɨrɨak menmen mai, ti enuk! Nɨpaa ti hɨkɨt hetpo te hi han tewenɨnit me menmen nɨpaa ti hetɨwem em. ");
INSERT INTO avt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Hi nɨpaa han tewenɨnit. Henmak te ti ap han tewenɨn wariyakɨt kit a?’ ");
INSERT INTO avt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Te mɨtɨk iuwe kɨrak han enuk keriuwerek te hɨrak kesiuwerek ken mɨt kerek nɨrɨakek menmen enum nanɨwaankek te hɨrak kaku kakɨt ere mamrer menmen kerek nɨpaa hɨrak ketɨwem. ");
INSERT INTO avt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Te han ki, yi eikaap ni yinan me menmen enum hɨr nepei nɨrɨakem. Te Haai kai kau wit kɨrak Heven kakrɨakem mampar keremem me yi. Haai kai kau wit kɨrak Heven kakrekyi menmen mamɨr im. Te yi eikaap ni yinan me menmen enum hɨr nerekyiyem yi eiyɨtpor hɨram menmen weinɨm. Yi han kitet menmen werek werek!” ");
INSERT INTO avt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas katɨp hɨm me menmen epei au, hɨrak kɨnaaiwɨr Galili ken tɨ ke provins Judia keit pɨnak ke mani Jodan ein. ");
INSERT INTO avt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hɨrak ken en, mɨt miyapɨr yapɨrwe nisesik. Te hɨrak kɨkaap mɨt miyapɨr kerek nɨnap hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hɨrak keit ein, hɨr mɨt ne Farisi nan nanmitɨwekpɨn nanri han kɨrak natɨp, “Hɨm me Moses haiu misesim matɨp hɨram yaaim te mɨtɨk akɨpɨr mɨte pɨrak hɨre wauno waunaiwɨrek me menmen miutɨp o yapɨrwe hɨre wɨrɨakem hɨrak kɨneinɨm o au?” ");
INSERT INTO avt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te hɨrak kewenhi ketpor, “Yi yenmak te nɨpaa yi ap yertei werek hɨm im em mau tɨwei yi yɨrem a? Hɨram matɨp God nɨpaa kɨrɨak menmen yapɨrwe, nɨpaa enum eik hɨrak kime mɨtɨk ketike mɨte. ");
INSERT INTO avt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God kɨrɨak mɨte keriuwe hɨrepit ke mɨtɨk te hɨrak katɨp, ‘Mɨtɨk kaknaaiwɨr miye hai nɨrak hɨrak kaku kaktike mɨte pɨrak, te hɨr wik nankiyan nanu nanɨt.’ ");
INSERT INTO avt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Te hɨr ap pɨke nɨre hɨre o hɨrak wik wik au. Hɨr nɨre yɨnk kiutɨp kerekek. Menmen kerek God epei kehimɨtanem miutɨp, yi mɨt ap te yayɨnkerem.” ");
INSERT INTO avt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Te hɨr mɨt ne Farisi netpɨwek, “Te kenmak Moses kewis hɨm hɨram matɨp, “Mɨtɨk kakwis tɨwei kaktɨp kakɨnmak te hɨrak kakɨnke mɨte hɨrak kakwetɨwerek te kakɨnkerep wauno?” ");
INSERT INTO avt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas ketpor, “Moses kewisi yi yayɨpɨr miyapɨr ni kentar yi han ki enuk ap yises hɨm me God werek werek au. Nɨpaa enum eik God ap hanhan keriuwe mɨt hɨr nises miyapɨr nɨr nɨnaaiwɨri nanɨno au. ");
INSERT INTO avt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hi hetpi hɨm mar im em. Mɨte pe mɨtɨk hak ap nɨpaa wɨrɨak menmen enum wɨwaai wetike mɨt han, te hɨrak kakɨpɨrep wauno kakɨt mɨte hap, mɨtɨk kar ik hɨrak kewaank hɨrekes kɨre mɨtɨk enuk kari miyapɨr his kewenem.” ");
INSERT INTO avt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Te hɨr mɨt disaipel nɨrak hɨr netpɨwek, “Menmen nɨmɨn ke mɨtɨk ketike mɨte pɨrak hɨram mar im, te mɨtɨk kakɨt mɨte au emɨt. Hɨrak eku weinɨk kerekek.” ");
INSERT INTO avt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Te Jisas ketpor kar ik: “Ap te mɨt miyapɨr yapɨrwe nantenen hɨm im em taau. Hɨr keriyen kerek God kakɨkepi hɨr nantenenim hanhan nanisesim. ");
INSERT INTO avt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mɨt han ap te nanɨt miyapɨr nentar miyerer nɨr nɨpaa ninen te hɨr ap yaain te hɨr nanwaai nantike miyapɨr. Nepɨr kerekek mɨt han nɨpaa nekin menmen me mɨt han te hɨr ap te nanɨt miyapɨr nanwaai nantikeri au. Te han en han kitet nanises menmen me hɨm me God nanrɨak menmen mɨrak keremem te hɨr nɨnapen nanɨt miyapɨr. Mɨt kerek hɨr han kitet hɨm im hɨram yaaim hɨr nanisesim.” ");
INSERT INTO avt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hɨrak katɨp epei au, hɨr mɨt han neit his nɨkerek han kike neri nan, hɨr hanhan natɨp Jisas te hɨrak ekwis his emɨnteri te ekitehi God kakrekyor menmen yaaim. Te hɨr mɨt disaipel neneri. ");
INSERT INTO avt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hɨr neneri, Jisas katɨp, “Yi eiwis nɨkerek kike en hɨr nanɨnan in. Yi ap eiweni au emɨt! Mɨt miyapɨr kerek nises God hɨr han yaaik nanu nanɨr nɨkerek in e.” ");
INSERT INTO avt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hɨrak kewis his menteri. Hɨrak kɨrɨak menmen im epei au, hɨrak kɨnaaiwɨr wit ik ken wit hak. ");
INSERT INTO avt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wɨ ham mɨtɨk hak yaaik kan kɨr Jisas ketpɨwek kar ik: “Mɨtɨk Iuwe Yaaik hi arɨak mekam yaaim eiyisesim te hi hahɨt hɨmɨn yaaik te hi hahu hahɨt tipmain tipmain enum eik?” ");
INSERT INTO avt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisas ketpɨwek, “Kenmak te ti hitauhi me menmen mekam yaaim? God kiutɨp kerekek hɨrak Yaaik. Te ti hanhan hahɨt hɨmɨn yaaik ehu etike God, te ti ehises hɨm kerek God kewet Moses em mɨt enisesim.” ");
INSERT INTO avt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Te mɨtɨk kitɨwekhi, “Hi ehises hɨm lo me Moses mekam?” Jisas ketpɨwek, “Ti ehises hɨm mar im: ‘Ti ap enep mɨt hɨr nani. Ti ap hetike mɨte pe mɨtɨk hak yi eirɨran au emɨt! Ti ap ekintɨp menmen me mɨt han. Ti ap ewen hɨm etɨp mɨt han. ");
INSERT INTO avt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ti emtau hɨm me miye haai nit eisesim naanmamror me menmen, ti hanhan eriuwe mɨt miyapɨr han ehɨr ke ti hanhan hɨrekes.’” ");
INSERT INTO avt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Te mɨtɨk pipɨak ketpɨwek, “Hɨm im em hi epei hisesim. Te hi ehises mekam ham?” ");
INSERT INTO avt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas ketpɨwek, “Ti hanhan are yaaik te ti eno esiuwe menmen mit yapɨrwe ehɨt pewek emrerim te ti ewet mɨt enun ap netenen menmen mei em. Ti erɨak menmen im, ti hetenen menmen yapɨrwe hahu wit ke God. Ti hɨrɨak menmen im epei au, ti enen ehisɨsa.” ");
INSERT INTO avt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mɨtɨk pipɨak kemtau hɨm im, hɨrak kɨnaaiwɨr Jisas han enuk ken kentar Jisas ketpɨwek hɨrak kesiuwe menmen mɨrak mamno. Hɨrak ketenen menmen yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hɨrak epei ken, Jisas katɨp mɨt disaipel nɨrak, “Hi hetpi werek. Menmen yapɨrwe mɨt netenenim hɨram mewen (o mesenkek) han kɨr te hɨr ap nises hɨm me God waswas au. ");
INSERT INTO avt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hi pɨke hetpi heteipim. Kamel hɨram ap te mamnɨk hei ke nil ke nekerwo laplap neriuwerek ek taau. Hɨram hei kike. Mɨtɨk ketenen pewek yapɨrwe hɨrak ap te kakises God taau kɨre kamel ap te kakises hei. Hɨrak kɨrɨak menmen au kentar pewek hɨrak ketenenim hɨrak han kɨrak kenke kenterim te kakisesik werek werek taau.” ");
INSERT INTO avt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mɨt disaipel nɨrak nemtau hɨm im em hɨr nehɨnhɨn te hɨr han kekrit nitɨwekhi, “God ap kakɨthis mɨtɨk kar ik au, te neimɨn ne haiu mɨt mamu mamtikerek? Taauye!” ");
INSERT INTO avt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hɨr natɨp epei au, Jisas kɨrapror ketpor, “Mɨt ap nankaap hɨras nanu nantike God au. Menmen mɨt netenenim mamkepi au. God kerekek kakɨkepi.” ");
INSERT INTO avt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hɨrak katɨp epei au, Pita ketpɨwek, “Haiu epei mɨnaaiwɨr menmen mai yapɨrwe te haiu misesit. Maain haiu mamɨt mekam?” ");
INSERT INTO avt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas kewenhi ketpor, “Hi hetpi menmen im! Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe maain hi hahu yeno mai iuwe naanmampre mɨt me wɨ yaaim maain mamnen, te yi mɨt kerek yisɨsa yi yayu yeno yaipar ke hi ik ek. Yi skelim mɨt ne weiwɨk yapɨrwe me Isrel. ");
INSERT INTO avt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hɨr mɨt miyapɨr niutɨp niutɨp kerek nɨnaaiwɨr wɨnak o menmen mɨr, kikrek nɨr, yenterer, miye haai o nɨkerek nɨr o tɨ kɨr, hɨr nɨnaaiwɨrem nentar hɨr nises menmen nɨpaa hɨr netenenim, maain hɨr nanɨt yapɨrwe mamɨr ke 100. Te hɨr nantike God nanu nanɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mɨt miyapɨr kerek in ek hɨr niuk mɨr iuwe, hɨr maain nanɨre mɨt weinɨn. Mɨt miyapɨr yapɨrwe in ek hɨr nɨre mɨt weinɨn, maain hɨr nanɨre mɨt iuwe. ");
INSERT INTO avt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Menmen God kɨrɨakem me haiu mɨt hɨram mar ke mɨtɨk ketenen tɨ iuwe. Hekrit enum eik hɨrak ken kakɨthis mɨt nanrɨak menmen naanmɨpre ni me waai wain mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hɨrak katɨp ketike mɨt han nanrɨak menmen naanmɨpre ni me tɨpar wain mɨrak. Te hɨrak han yaaik keriuweri te hɨr nanɨt pewek iuwe miutɨp me wɨ im em. Epei au, hɨrak keriuweti nen ni me waai wain mɨrak eim. ");
INSERT INTO avt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Maain wepni epei kehɨn kɨniu kan, hɨrak ken kɨr mɨt han nerp weinɨn neit wit maket. ");
INSERT INTO avt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hɨrak katɨp mɨt han in en, ‘Yi eino eirɨak menmen eipeit ni wain eim, te hi eweti pewek iuwe miutɨp mampɨreri keriyen.’ ");
INSERT INTO avt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Te hɨr nen. Wepni kau nɨmɨn iuwe kewen ken, hɨrak ken kari mɨt han keprer kerekek nɨpaa hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Hɨnkewɨ hɨrak ken kɨr mɨt han au nerp neit ap nɨrɨak menmen. Te hɨrak ketpor, ‘Yenmak te yi yerp weinɨm petepin in ere hɨnkewɨ ik ek?’ ");
INSERT INTO avt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hɨr netpɨwek, ‘Ap mɨtɨk kei kewetei menmen haiu mamrɨakem.’ Hɨrak ketpor, ‘Yi eino ni me tɨpar wain mai em eirɨak menmen.’ ");
INSERT INTO avt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Epei hɨnkewɨ, te haai ke ni wain katɨp mɨtɨk iuwe naanmɨrpe mɨt nɨrɨak menmen hɨrak ketpɨwek, ‘Ti enɨne mɨt nɨrɨak menmen nanɨnen te ti ewetɨr pewek. Ti ewet mɨt kerek nan ne hɨnkewɨ pewek eninɨn. Maain ti ewet mɨt kerek nepei ninɨn nekriteik nan ek nɨkaru. Te ti ewetɨr pewek mɨpɨram.’ ");
INSERT INTO avt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Hɨr mɨt kerek nan nɨrɨak menmen neit ni wain em ne hɨnkewɨ hɨr neit pewek kiutɨp. ");
INSERT INTO avt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Epei au, mɨt kerek ninɨn nɨrɨak menmen meit ni wain em, hɨr nan te hɨr han kitet hɨr nanɨt pewek yapɨrwe maminɨni, te au, hɨr netɨwem mɨpɨram keremem. Pewek kiutɨp. ");
INSERT INTO avt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hɨr netɨwem, te hɨr nene mɨtɨk kerek ke ni keremem. ");
INSERT INTO avt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hɨr natɨp nar ik: ‘Mɨt in en hɨr nan nɨkaru. Hɨr nɨrɨak menmen kike keremem, te ti ewetɨr pewek mɨpɨram mepɨr ke haiu metɨwem. Haiu epei mɨrɨak menmen iuwe me hekrit eik ere wepni kɨman si kewai meriuwerem.’ ");
INSERT INTO avt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Hɨr natɨp nar ik te hɨrak katɨp mɨtɨk hak kiutɨp ke hɨr mɨt en. Hɨrak katɨp, ‘Kai yinak hi ap herekyut enum. Nɨpaa ti ewenhi hɨram werek te ti hɨrɨak menmen ehɨt pewek kiutɨp a? ");
INSERT INTO avt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ti ehɨt pewek kit kiutɨp te ti eno. Pewek kiutɨp hi epei ewetitem, mar keremem te hi hanhan ewet mɨt pewek kerek nɨkaru en em. ");
INSERT INTO avt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mekam! Yi han kitet hi hɨrɨak menmen hises han kai mamriuwe pewek mai im em o au a? Hi ehisesim ye! Hi hɨrɨak menmen yaaim me menmen im em yi au han enuk yeriuwa a?’ Haai ke ni ik hɨrak katɨp kar ik. ");
INSERT INTO avt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Te hi Jisas hetpi. Hɨr mɨt kerek in ek hɨr mɨt weinɨn, maain hɨr iuwe. Mɨt kerek in ek hɨr iuwe, maain hɨr nanɨre mɨt weinɨn.” ");
INSERT INTO avt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas kakniu kakno Jerusalem, te hɨrak keit his mɨt disaipel nar hiswiyen wik (12) hɨr netikerek nen. Hɨr nitet yayiwe nen, te Jisas ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Eiyɨmtau. In ek haiu mamno Jerusalem. Te hɨrak mɨtɨk kerek kakriuweta hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi eno his me mɨt iuwe pris netike mɨt ninɨn nertei hɨm me Moses. Te hɨr nanmitetpɨn nantɨp hi enuk te hi ahi. ");
INSERT INTO avt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Te hɨr nansiuwa hi ano his me mɨt ap ne weiwɨk me Isrel, hɨr nanɨtpo enum me nanrekyau yɨnk enuk, hɨr nanwaai nɨpɨn menmen naniyep te nanwenkeka ehu nu tentarakɨt. Me wɨ wikak, hi pɨke ekrit hahu.” ");
INSERT INTO avt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Me wɨ im Sebedi mɨte pɨrak weithis nɨkerek tɨre Jems ketike Jon hɨre weri wan Jisas. Hɨre wewen ninɨp witɨwekhi hɨrak kakrekyɨwe menmen yaaim. ");
INSERT INTO avt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas ketpɨwe, “Ti hanhan mekam?” Hɨre watɨp, “Maain ti are Mɨtɨk Iuwe King naanmamprai haiu mɨt. Me wɨ im hi hanhan ti atɨp nɨkerek tawɨr wiketeret it tatu menep tatɨtikewit naanmampre mɨt tatkitewit. Hak kakno his henkik, hak kakno his yaaim tatɨt wit kerek mɨt iuwe newi. Hɨram werek o au?” ");
INSERT INTO avt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hɨre watɨp warik, te Jisas ketpɨwe, “Auye! Yi ap yertei menmen werek werek yi yitauhiyem. Hɨram werek te yi yayises menmen enum yayɨr ke hi ehisesim eiwis menmen enum mamnen mamiwep a?” Hɨrakɨt tatɨp, “Hawɨr te wawisesim.” ");
INSERT INTO avt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Te Jisas ketpɨwekɨt, “Hɨram werek te yi wiketeret yayises menmen hi ehisesim te mamrewaank. Te keimɨn hɨrak kaku kakɨnke kakno his henkik mai, keimɨn kakno his yaaim mai, hɨm im em hɨrak ap hɨm mai te hi etpiyem au. Yeno keremem hɨram me mɨt han kerek Haai kai God kɨrɨakem te mɨt han nanwim.” ");
INSERT INTO avt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hɨr mɨt disaipel han nar hiswiyen (10) nemtau menmen hɨrakɨt titehi Jisas em keremem, hɨr han enuk neneret. ");
INSERT INTO avt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Te Jisas kenɨnor hɨr nan nanɨrek, te hɨrak katɨp, “Yi yertei hɨr mɨt iuwe ne weiwɨk ham hɨr natɨp mɨt hɨr weinɨn te hɨr iuwe ninɨni. Te hɨr mɨt iuwe keriyen natɨp hɨm manp enuk te hɨr mɨt miyapɨr nises hɨm kɨr me menmen hɨr netpim. ");
INSERT INTO avt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Te menmen enum mar im ap emɨrp nɨmɨn me yi mɨt au. Mɨtɨk keimɨn kakre iuwe nɨmɨn ke yi mɨt, te hɨrak ekpar mɨtɨk kɨrɨak menmen yaaim me kakɨkepi. ");
INSERT INTO avt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mɨtɨk kerek hanhan kakre iuwe ke yi mɨt, te hɨrak ekpar mɨtɨk weinɨk kɨrɨak menmen mi. ");
INSERT INTO avt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hɨrak kɨrɨak menmen ekpar hi Mɨtɨk ke wit ke Mɨtɨk Iuwe kerekek hi arɨakem. Hi ap han te mɨt nanrekyo menmen mai nankepa au. Hi han arɨak menmen me mamkaap mɨt, te hi enaaiwɨr yɨnk kai hahi akaap mɨt miyapɨr yapɨrwe ahɨsak menmen enum hɨr nɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hɨr natɨp epei au, hɨr nɨnaaiwɨr wit Jeriko nen, te mɨt miyapɨr yapɨrwe nises Jisas. ");
INSERT INTO avt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hɨr nepno te mɨtɨkɨt wiketeret kerek nanamɨr toto tau yayiwe. Hɨrakɨt temtau hɨm mɨt natɨp me Jisas kitet yayiwe kakno, te hɨrakɨt tɨnap tatɨp tenɨne hɨm iuwe, “Mɨtɨk Iuwe ti Nepenyek ke Devit kerek God kewetit menmen mɨrak iuwe. Ti han etwenɨnawɨr.” ");
INSERT INTO avt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mɨt miyapɨr hɨr natɨp hɨm iuwe te hɨrakɨt tekintɨp wɨre wɨre. Au, hɨrakɨt tɨnap tatɨp iuwe tar ik: “Mɨtɨk Iuwe ti Nepenyek ke Devit, ti han etwenɨnawɨr.” ");
INSERT INTO avt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas kerp kenɨnewekɨt katɨp, “Yi wiketeret yi hanhan hi arekyi mekam?” ");
INSERT INTO avt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te hɨrakɨt tatɨp Jisas, “Mɨtɨk kai Iuwe hawɨr hanhan ti erekyawɨr nanamɨr mawɨr mamre yaaim te hawɨr wawɨr ein ein.” ");
INSERT INTO avt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Te Jisas han tewenɨnet kewis his mau nanamɨr mɨrakɨt, te wasenum hɨrakɨt tɨr ein ein werek werek. Te hɨrakɨt tisesik ten. ");
INSERT INTO avt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hɨr epei nen menep wit Jerusalem, hɨr niun wit Betfasi kerek menep mɨniu (o neiyɨp) niuk mɨrak wit Oliv. Hɨr neit ein te Jisas kakriuwet mɨtɨkɨt disaipel wiketeret. ");
INSERT INTO avt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Te hɨrak ketpɨwekɨt kinɨn: “Yi eino wit kike eik ek te yi yayɨr menep in en. Te wasenum yi yayɨr donki (hɨre wɨre hos) hɨr mɨt nesenkekiye weriuwe waai werp nu, nɨkan kɨre ketikerep. Yi eisiupani eiyɨriyei eiyɨn einen eiwetori. ");
INSERT INTO avt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te mɨtɨk hak kakɨtpi menmen me yi wiketeret, te yi eitɨp eiyɨr ik: ‘Mɨtɨk kawɨr iuwe kakrɨak menmen ham kakriuwerem.’ Maain hɨrak kakrɨak menmen kakriuwerem epei au, hɨrak kaksiuwerem pɨke mamnen.” ");
INSERT INTO avt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Menmen im man te hɨram mises menmen kerek nɨpaa profet netpim em. Hɨram matɨp mar im: ");
INSERT INTO avt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yi eitɨp mɨt miyapɨr nau wit Saion emɨr ik: ‘Eiyɨr mɨtɨk Iuwe ki kaknen kakri. Hɨrak ap mɨtɨk katɨp hɨm tokim au. Hɨrak kau donki keteikɨn mɨt hɨrak naanmɨpri werek werek. Hɨrak keiyɨk kan. Hɨrak kau donki kike, nɨkan kerek miye pɨrak hɨre winaak.’” ");
INSERT INTO avt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Te mɨtɨkɨt disaipel wiketeret ten tises menmen kerek Jisas epei ketpɨwekɨt em. ");
INSERT INTO avt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hɨrakɨt teithis donki miye wetike nɨkan kɨre, te hɨrakɨt tewis laplap saket mɨrakɨt menterik, te Jisas kau sip kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Te hɨr mɨt miyapɨr yapɨrwe newis laplap saket menmen mɨwaai yayiwe. Mɨt han neremir nu heneik newisɨm mɨwaai yayiwe nesɨsɨwek neriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te hɨr mɨt miyapɨr ninɨnek, hɨrak ketike han nisesik hɨr nɨkaru nan nɨnap nenɨne, “Kai yaaik ik hɨrak Nepenyek ke Devit. Haiu hanhan God kakrɨak menmen yaaim ke mɨtɨk ik kan kakɨkrehɨr kɨrak. Hɨrak yaaik te haiu emwenɨpi niuk me God.” ");
INSERT INTO avt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas ken Jerusalem, te mɨt miyapɨr neit wit iuwe eik, hɨr nehɨnhɨn neriuwerek te hɨr natɨp, “Mɨtɨk ik ek hɨrak keimɨn?” ");
INSERT INTO avt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Te mɨt miyapɨr kerek nen ek natɨp, “Hɨrak profet Jisas, mɨtɨk ke Nasaret keit provins Galili.” ");
INSERT INTO avt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te Jisas kɨnɨk ken wɨnak iuwe ke God tempel kerek mɨt natɨp mɨt han hɨm me God nekrerek ek. Te hɨrak kepɨr mɨt kerek nesiuwe menmen nanɨt pewek mamriuwerem em. Hɨrak kewɨr yeno mɨr kerek hɨr newis pewek menterim metike yeno me mɨt kerek hɨr nesiuwe hore newet mɨt em hɨr newi. ");
INSERT INTO avt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hɨrak kɨrɨakem epei au, hɨrak katɨp, “Tɨwei me God matɨp mar ik: ‘Mɨt nanrer wit wit nankine wɨnak kai nenewek wɨnak kerek mɨt nanitehi God menmen nanɨkrerek.’ Te yi yɨrɨakek kɨre wɨnak ke mɨt enun nekintɨp menmen newik.” ");
INSERT INTO avt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas kepeit wɨnak tempel kerek mɨt natɨp mɨt han hɨm me God nekrerek, te mɨt han nanamɨr toto netike mɨt nɨnap enum nan nɨrek, te hɨrak kerekyi yɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Te hɨr mɨt iuwe ne pris netike mɨt iuwe nertei hɨm me Moses natɨp mɨt em, hɨr nɨr menmen yaaim Jisas kɨrɨakem kɨkaap mɨt, te hɨr nemtau nɨkerek nenɨne neit ein natɨp nar ik: “Haiu emwenɨpi niuk me nepenyek ke Devit,” te hɨr han enuk. ");
INSERT INTO avt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hɨr han enuknetpɨwek, “Ti hemtau hɨm kerek hɨr netpim em a?” Te Jisas ketpor, “O, hi hemtewem. Yenmak te yi ap han kitet menmen yi epei yekinaam me menmen im a? Hɨrak katɨp, ‘Ti God hewep han ke nɨkerek kike netike han kerek nau sɨnipau naam nɨm te hɨr natɨp newenɨpi niuk mit hɨram iuwe.’” ");
INSERT INTO avt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hɨrak katɨp nepei au, hɨrak kɨnaiwɨri keit wit iuwe ik, hɨrak ken kau Betani me wɨtaan ik ek. ");
INSERT INTO avt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hekrit enum eik, Jisas pɨke ken wit iuwe eik te hɨrak nɨnpɨ maak. ");
INSERT INTO avt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Te hɨrak kɨr nu fik hak kiutɨp keit yayiwe, te hɨrak ken kɨrek. Te hɨrak ap kɨr nɨkim mei mewik au. Hɨrak keperp weinɨm. Te hɨrak katɨp nu fik, “Ti ap hari eine nɨkim meiyam au.” Te wasenum nu fik keweiwei kaa. ");
INSERT INTO avt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hɨr disaipel nɨrek te hɨr nehɨnhɨn. Hɨr natɨp, “Kenmak te nu fik keweiwei kaa waswas?” ");
INSERT INTO avt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas ketpor, “Hi hetpi werek. Yi yises hɨm me God werek werek, yi ap han kitet God kakɨkepi o au, te maain yi yairɨak menmen mamɨr ke epei yi yɨra hi hɨrɨakem me nu fik ik ek. Te menmen im keremem au. Yi yaitɨp mɨniu (o neiyɨp) ik, ‘Ti eket eno ekre wan’, te hɨrak kakises hɨm kerek yi epei yetpɨwek ek hɨrak kakno kakɨkre wan. ");
INSERT INTO avt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yi yises God werek werek yi eiyitɨwekhi me menmen, maain hɨrak kakrekyiyem.” ");
INSERT INTO avt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas pɨke kan wɨnak iuwe ke God katɨp mɨt hɨm mɨrak. Hɨrak wen ketpim, mɨt iuwe pris netike mɨt iuwe kerek ninɨn naanmɨpre mɨt ne Isrel nan nitɨwekhi narik: “Keimɨn kehimɨtanut te ti hatɨp mɨt hɨm im?” ");
INSERT INTO avt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas ketpor, “Hi hitihi menmen miutɨp. Yi eiyɨtpewem werek, te hi hetpi keimɨn kehimɨtena hi hatɨp mɨt hɨm im. ");
INSERT INTO avt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Keimɨn kehimɨtan Jon hɨrak kɨkɨr mɨt neriuwe tɨpar? God kehimɨtanek o hɨrak kises han kɨrak?” Hɨr hɨras natɨpan nar ik: “Haiu emɨtpɨwek mekam werek? Haiu mamɨtpɨwek God kehimɨtanek hɨrak kɨrɨakem, te hɨrak kakɨtpei, ‘Yenmak te yi ap yises hɨm me Jon a?’ ");
INSERT INTO avt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Haiu matɨp Jon kises han kɨrak kɨrɨakem, haiu mɨnapen mɨt nanrekyei enum nanɨntar hɨr han kitet John hɨrak mɨtɨk iuwe profet. ");
INSERT INTO avt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hɨr nɨnaain mɨt te hɨr ap natɨp Jon hɨrak mɨtɨk weinɨk. Te hɨr natɨp Jisas, “Haiu au mepɨtari keimɨn kehimɨtenek kɨrɨakem.” Hɨr natɨp epei au, Jisas ketpor, “Yi ap yetpo werek menmen me Jon, te hi ap etpi keimɨn kehimɨtena hi hɨrɨak menmen im.” ");
INSERT INTO avt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas katɨp, “Yi han kitet mekam? Nɨpaa mɨtɨk hak kine nɨkerek hɨrakɨt wik. Hɨrakɨt epei tɨre iuwe, wɨ ham haai ken nɨkan iuwe mɨtɨk ketpɨwek kar ik, ‘Petepin hi hanhan ti eno erɨak menmen naanmɨpre ni me waai wain mai.’ ");
INSERT INTO avt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hɨrak katɨp haai kɨrak kar ik: ‘Hi au hɨnapen.’ Maain hɨrak keweikɨn han kɨrak ken ni me haai kɨrak kɨrɨak menmen. ");
INSERT INTO avt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Haai ken kitehi nɨkan kike ek, ‘Ti tewen eno ni mai erɨak menmen naanemprewem.’ Nɨkan nɨkik ek kewenhi katɨp, ‘Hi eno’, te hɨrak ap ken ni eim au. ");
INSERT INTO avt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yi han kitet keimɨn ke nɨkerek wiketeret kises hɨm me haai?” Hɨr netpɨwek, “Nɨkan iuwe mɨtɨk kerekek.” Jisas ketpor, “Hi hetpi werek. Mɨt enun newenɨn his mɨt hɨr ninɨn neweikɨn sip newet menmen enum nises hɨm me God. Te yi mɨt iuwe au! ");
INSERT INTO avt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hɨr nenmak? Yi yises hɨm me God werek werek au yentar Jon kan keteikni menmen yi yayisesim te yi ap yises hɨm mɨrak au. Te mɨt enun neitɨt pewek me takis netike miyapɨr kewenek nari mɨt his newenem, hɨr keriyen nises hɨm mɨrak. Yi epei yɨri hɨr nises hɨm mɨrak te yi ap yeweikɨn han yisesik. Au, yi yeweikɨn sip yewetɨwek yau weinɨn.” ");
INSERT INTO avt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas wen ketpor kar ik: “Yi eiyɨmtau hɨm tok piksa ham im. Mɨtɨk iuwe ketenen tɨ mei kamɨr waai wain nɨkim mɨrak epei au. Hɨrak kime nɨwa keweiknɨwem kekin hei kewis yemtɨ wɨsenuk kekrerem te ketepen waai wain nɨkim tɨpar mɨram mekrerek. Epei au, hɨrak kime kɨnaan kau niu naanmɨpre ni mɨrak. Epei au, hɨrak kehimɨtan mɨt hɨr naanmɨrewem. Te hɨrak kɨnaaiwɨr wit ik ken wit hak keit yanɨmɨn. ");
INSERT INTO avt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maain waai wain nɨkim epei maa, hɨrak keriuwet mɨt nɨrak kerek nɨrɨak menmen mɨrak em hɨr nen neit nɨkim pɨnam mɨrak neiyɨm nanɨnen. ");
INSERT INTO avt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mɨt naanmɨpre ni em nerekyor enum. Hak ek hɨr nakɨp, hak ek hɨr nakɨp kaa, hak ek hɨr newɨr nan nakɨp hemkre maain mekiuwe yɨnk kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Maain kike, mɨtɨk iuwe kesiuwe mɨt han nɨrak yapɨrwe nan ninɨn kerek nɨpaa hɨrak keriuweti nan. Hɨrak keriuweti nan te mɨt kerek naanmɨpre ni nerekyor enum mar ke nɨpaa hɨr nɨrɨak mɨt han em. ");
INSERT INTO avt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Epei au, mɨtɨk iuwe kesiuwe nɨkan kɨrak kɨkaru kan hɨrak han kitet kar ik: ‘Hɨr nanɨmtau hɨm me nɨkan kai.’ ");
INSERT INTO avt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mɨt kerek naanmɨpre ni me mɨtɨk iuwe, hɨr nɨr nɨkan kɨrak kan hɨr hɨras netpepan natɨp nar ik: ‘Ik ek hɨrak nɨkan ke mɨtɨk iuwe. Haiu emkɨp te haiu emɨt tɨ kɨrak ik ek.’ ");
INSERT INTO avt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Te hɨr natɨp epei werek, hɨr netɨwekhis neiyɨk nen nɨnaaiwɨr ni nakɨp kaa. ");
INSERT INTO avt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Maain mɨtɨk iuwe ke ni im hɨrak kaknen kakrekyor mekam?” ");
INSERT INTO avt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hɨr newenhi netpɨwek, “Hɨrak kaknen kaknep mɨt enun en epei au, hɨrak kakwis mɨt han nanɨnen naanmamre ni mɨrak mɨt in hɨr yaain nanwetɨwek menmen yinam mɨrak kerek hɨram epei mekiute.” ");
INSERT INTO avt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas ketpor, “Yi yenmak te yi ap yertei werek werek hɨm me God mau tɨwei nɨpaa profet newisɨm? Hɨram matɨp, ‘Teinɨk yaaik kerek mɨt nime wɨnak hɨr nɨnapen newisɨm mɨwaai, God kehimɨtanek hɨrak kinɨn teinɨk ham mɨt epei namɨr. Mɨtɨk Iuwe God kerekek kɨrɨak menmen im haiu han kitet hɨram yaaim.’ ");
INSERT INTO avt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Te hi hetpi menmen yaaim me God nɨpaa hɨrak kewetiyem yi ap yisesim werek werek, te hɨrak keriyaam mamnopɨn hɨrak kakwet mɨt han em hɨr yaain nanises menmen God hanhan hɨr nɨrɨakem neriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Neimɨn hɨr neweikɨn sip neweto hɨr nanɨwaank nanɨr ke mɨn kaknatɨn kakɨntar teinɨk hɨram mereprɨr. Maain hi arekyor enum hɨr nanɨwaank nanɨt nanɨr ke teinɨk kaknatɨn kakɨntar menmen hɨrak kaksesi tɨkip tɨkip mamre niutɨp.” ");
INSERT INTO avt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hɨrak katɨp epei au, mɨt iuwe ne pris netike mɨt han ne Farisi nemtau hɨm me Jisas hɨr nertei hɨrak katɨp hɨm tok piksa im keneri keriuwerem. ");
INSERT INTO avt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hɨr nerteiyem epei au, hɨr hanhan netɨwek his nanɨriyaak neiyɨk nanɨno nanwisɨk kakɨkre wɨnak enuk, te hɨr nɨrɨakem au. Hɨr nɨnaain mɨt yapɨrwe kerek nererik nemtau hɨm me Jisas hɨr nanɨnɨp nanɨntar hɨr han kitet Jisas hɨrak mɨtɨk iuwe profet. ");
INSERT INTO avt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas pɨke katɨp mɨt miyapɨr hɨm keriuwe tok piksa. ");
INSERT INTO avt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Hɨrak ketpor, “Menmen God kɨrɨakem kenɨne mɨt ne tɨ hɨr nanises hɨm mɨrak hɨram mar ke mɨtɨk iuwe kinɨn naanmɨpre mɨt hɨrak kemani menmen keiyɨm kɨnkɨk mɨt kakɨntar nɨkan kɨrak ketike mɨte nanɨtan. ");
INSERT INTO avt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nɨpaa hɨrak kehimɨtan mɨt han nanɨnen nanɨm menmen nantikerek. In ek hɨrak keriuwet mɨt nɨrak han hɨr nanɨno nanɨnɨnor nantɨp mɨt hɨr nanɨnen nanɨm menmen nantikeri. Te hɨr ap nɨnapen. ");
INSERT INTO avt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hɨr au nɨnapen, te hɨrak kenɨne mɨt nɨrak han ketpor, ‘Yi eitɨp mɨt kerek nɨpaa hi etpor nanɨnen nanɨm menmen eiyɨtpor hi epei hemani menmen nepei au, te hɨr enɨnen enɨm. Hi epei enep bulmakau nenium yapɨrwe metike samiyak ham yaaim.’ ");
INSERT INTO avt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mɨt en nen netpor menmen epei au, te hɨr neweikɨn sip newetɨrem nises menmen mɨr. Mɨtɨk hak ken ni mɨrak, mɨtɨk hak ken stua kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mɨt han en nepu hɨr netenen mɨt kerek mɨtɨk keriuweti nan, hɨr nerekyor enum nanɨp naa. ");
INSERT INTO avt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hɨr nerekyor enum nanɨp naa, mɨtɨk iuwe han enuk wɨsenuk keriuweti te hɨrak keriuwet mɨt nɨrak ne ami hɨr nen nenep mɨt in enun kerek nenep mɨt nɨrak, hɨr nanɨp nenepi nesi wit kɨr. ");
INSERT INTO avt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hɨr nanɨp nenepi epei au, mɨtɨk iuwe kenɨne mɨt nɨrɨak menmen mɨrak, hɨrak ketpor, ‘Hi epei hemani menmen epei au, te mɨt kerek hi nɨpaa hehimɨtenor hɨr nanɨnen hɨr au enun. ");
INSERT INTO avt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Te yi eino eirer yayiwe yi eiyɨr mɨt yapɨrwe nan nitet yayiwe yi eiyɨtpor hɨr enɨnen enɨm menmen hi emaniyem.’ ");
INSERT INTO avt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hɨrak ketpor epei au, mɨt nɨrak hɨr nen nerer yayiwe nari mɨt kerek hɨr nɨri nitet yayiwe en. Mɨt han yaain, mɨt han au enun, te hɨr neri nen wɨnak kerek mɨtɨk ketike mɨte hɨr nanɨtan neitai en, ere hɨr nau neneises wɨnak nenepik. ");
INSERT INTO avt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Hɨr nau neneises wɨnak nenepik, mɨtɨk iuwe kan kakɨr mɨt kerek nau nererik nɨpaam menmen mɨrak. Hɨrak kan kɨri, hɨrak kɨr mɨtɨk kiutɨp ap hanhan keriuwe mɨtɨk iuwe hɨrak keriuwet klos yaaim me mɨt hɨr nanɨtan au. Hɨrak kan ketpɨwek, ");
INSERT INTO avt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Kai yinak. Harkeik te ti hɨtɨt naan mɨt nai naanmɨrau weipɨr te ti hɨnɨk han nɨmɨn in a?’ Mɨtɨk hɨrak ap ketpɨwek menmen au. Hɨrak yɨnk enuk kau en kenesnɨn paan. ");
INSERT INTO avt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Te mɨtɨk iuwe naanmɨpre mɨt hɨrak kenɨne mɨt nɨrɨak menmen mɨrak ketpor: ‘Yi eiyɨt mɨtɨk ik eisenkɨkɨwek his hɨt eiwɨrek ekno wit eik toto enuk. Hɨrak kakɨkɨt kaknakɨn yehes mɨrak kakine han enuk kaku kakɨt.’” ");
INSERT INTO avt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas ketpor hɨm im epei au, hɨrak ketpor: “Hɨrak kɨkɨt kɨnakɨn yehes kentar God kenɨne mɨt yapɨrwe nanisesik, te hɨrak kehimɨtan mɨt niutɨp niutɨp keriyen hɨr nanɨnen nanu nantikerek.” ");
INSERT INTO avt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jisas ketpor hɨm epei au, wɨ im mɨt ne Farisi nɨnaiwɨrek hɨr nimenɨpɨnek newisɨwekek neriuwe hɨm ham. ");
INSERT INTO avt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hɨr nimenɨpɨnek newisɨwekek epei au, hɨr neriuwet mɨt hɨr han nises hɨm mɨr, hɨr netike mɨt kerek nises hɨm me Herot hɨr nan nanri han kɨrak nitɨwekhi, “Mɨtɨk Iuwe tisa, haiu mertei ti mɨtɨk yaaik hatɨp menmen yaaim me God werek werek. Ti han kitet mɨt yapɨrwe hɨr nɨpɨran te ti ap ewis kiutɨp kakri han kit me menmen. ");
INSERT INTO avt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Te haiu hanhan ti etpai han kit. Hɨram yaaim te haiu mamwɨr pewek me takis mamwet mɨtɨk iuwe ke Rom naanmɨprai mamwetɨwekem o au?” ");
INSERT INTO avt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Te Jisas kertei han kɨr enuk te hɨrak ketpor, “Yi mɨt enun yewisɨsik. Yi yenmak te yi hanhan yewisɨsewek a? ");
INSERT INTO avt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yi eiyɨt pewek yi yewɨrem yewet mɨt ne gavman em me takis eiyɨm einen.” Hɨrak ketpor, te hɨr nen neit pewek miutɨp neiyɨm nan neteiknɨwekem. ");
INSERT INTO avt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Hɨr neiyɨm nan neteiknɨwekem, te hɨrak kitorhi ketpor, “Ninaan me keimɨn metike niuk mɨrak mewik?” ");
INSERT INTO avt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hɨr natɨp, “Me mɨtɨk iuwe Sisa keremem.” Te hɨrak ketpor, “Te yi eiwet mɨtɨk iuwe Sisa menmen mɨrak, yi eiwet God menmen mɨrak.” ");
INSERT INTO avt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hɨrak ketpor epei au, hɨr han kekrit neriuwe menmen hɨrak epei ketpor nentar hɨr ap te nanwisesik au. Te hɨr nɨnaiwɨrek hɨr nen. ");
INSERT INTO avt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Me wɨ im keremem, mɨt han ne Sadyusi hɨr nan nɨr Jisas. Mɨt in hɨr ap han kitet mɨt epei naa hɨr pɨke nanɨkrit taau. ");
INSERT INTO avt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Hɨr nan nitɨwekhi nar ik: “Mɨtɨk Iuwe Tisa, hɨm nɨpaa Moses kewisɨm mau tɨwei matɨp, ‘Mɨtɨk kaki kaknaaipɨs mɨte pɨrak, te hɨre ap wine nɨkerek nei au, maain nɨkik kɨrak kaktɨwe te hɨre wawine nɨkerek nei nanɨkrehɨr ke haai kɨr.’ ");
INSERT INTO avt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nɨpaa mɨt ne haai kiutɨp hɨr nar hispɨnak wik (7), hɨr nepu in. Nɨkan iuwe mɨtɨk keit mɨte te hɨrak kaa ap kine nɨkerek wen au. Hɨrak nɨkik kɨrak nɨmɨnek hɨrak ketɨwe. ");
INSERT INTO avt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hɨrak ketɨwe hɨrak kaa, te hɨrak ap kine nɨkerek au. Hɨr nepɨr kerekek ere hɨrakɨt tɨpaa ap tine nɨkerek nei au. ");
INSERT INTO avt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hɨrakɨt tɨpaa ere tepnepik, mɨte pɨrakɨt wɨpaa wɨpkaru. ");
INSERT INTO avt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Maain wɨ kerek mɨt pɨke nanɨkrit nanu, hɨre waure mɨte pe keimɨn? Hɨre nɨpaa wau wetike mɨkan tɨre tar hispɨnak wik (7).” ");
INSERT INTO avt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Hɨr natɨp epei au, Jisas ketpor kar ik: “Yi mɨt yatɨp enum yentar yi yepɨtari hɨm me God, yi ap yertei God hɨrak manp enuk wɨsenuk te hɨrak kakises han kɨrak kɨrɨak menmen yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Me wɨ God kakɨkɨan mɨt hɨr nanu, hɨr ap nanɨt miyapɨr au. Hɨr nanu weinɨn nanɨr ke mɨt ensel neit wit ke God. ");
INSERT INTO avt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Te menmen yi nepei yetpim me mɨt pɨke nanɨkrit yentar yi ap han kitet hɨr pɨke nanɨkrit. Hi hetpi menmen im. Yi yenmak te yi ap yertei menmen yi yekinaam mau tɨwei me Moses God ketpiyem a? ");
INSERT INTO avt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Hɨrak katɨp, ‘Hi God ke Ebraham, Aisak ketike Jekop.’ Hɨrak God ke mɨt hɨr hɨmɨn kɨr kepu keriyen.” ");
INSERT INTO avt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mɨt yapɨrwe nerp menep nemtau menmen hɨrak ketporem, hɨr han kekrit hɨr han yaaik neriuwe hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Maain kike, mɨt ne Farisi nemtau Jisas katɨp werek kinɨn hɨm kerek mɨt ne Sadyusi nitɨwekhiyem, teɨr yɨnk enuk, hɨr nekintɨp nɨnaiwɨrek. Te hɨr nan nekiyan nau niutɨp nimenɨpɨnan natɨp. ");
INSERT INTO avt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Epei au, mɨtɨk kiutɨp kekre nɨmɨn ke hɨr mɨt, hɨrak ke mɨt ne Skraip, hɨrak kan katɨp Jisas kɨnɨnek ketpɨwek, ");
INSERT INTO avt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mɨtɨk Iuwe Tisa, hɨm mekam hɨram minɨn hɨm ham nɨpaa Moses ketike profet newisaiyem mau tɨwei matɨp?” ");
INSERT INTO avt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas kewenɨwekhi ketpɨwek, “Yi hanhan Mɨtɨk Iuwe ki God yeriuwe han ki ketike me menmen yapɨrwe mekre yɨnk ki. ");
INSERT INTO avt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hɨm im hɨram iuwe minɨn hɨm ham mau tɨwei nɨpaa Moses ketike Profet newisaiyem. ");
INSERT INTO avt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hɨm ham iuwe misesim hɨram mepɨr ke hɨm minɨn em, hɨram mɨpɨram. Hɨram matɨp, ‘Yi hanhan mɨt han o ni yinan yar ke yi hanhan yeriuwe hɨras.’ ");
INSERT INTO avt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mɨt nanises menmen wik im te hɨram mamkepi hɨr nanises hɨm yapɨrwe werek werek nɨpaa Moses ketike mɨt profet hɨr newisɨm mau tɨwei.” ");
INSERT INTO avt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mɨt ne Farisi wen nekiyan nau niutɨp, Jisas kitorhi kar ik. ");
INSERT INTO avt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Hɨrak katɨp, “Yi han kitet mekam me Mɨtɨk Krais kerek God kakriuwetek kaknen kakɨkaap mɨt ne tɨ? Hɨrak Nepenyek ke keimɨn?” Hɨr netpɨwek, “Hɨrak kakre Nepenyek ke Devit.” ");
INSERT INTO avt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas kitorhi keteipim, “Hɨrak kakre nepenyek ke Devit kerekek, kenmak te God Hɨmɨn Yaaik kɨkɨak han ke Devit kene Krais hɨrak Mɨtɨk Iuwe kɨrak? Devit ketpim kewisɨm mau tɨwei mar im: ");
INSERT INTO avt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mɨtɨk Iuwe God katɨp Mɨtɨk Iuwe kai Krais kar ik: “Ti ehu yeno im menep his yaaim kerek mɨt iuwe newi. Ti ehu in ere hi anep mɨt enun nepan ni anɨp anepi.’” ");
INSERT INTO avt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit kene Krais hɨrak Mɨtɨk Iuwe kɨrak, karkeik te hɨrak kenewek nepenyek kɨrak kerekek? Taau. Hɨrak Nepenyek ke Devit te hɨrak kenewek hɨrak Nɨkan ke God!” ");
INSERT INTO avt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hɨrak katɨp epei au, mɨtɨk hak kekre nɨmɨn ke hɨr mɨt yapɨrwe ap te newenhi au. Me wɨ im ere maain hɨrak mɨtɨk hak kekre nɨmɨn ke hɨr mɨt hɨrak kaknen kakitɨwekhi hɨm meiyam kike au. Hɨr yɨnk enuk nɨnapen. ");
INSERT INTO avt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Maain Jisas katɨp mɨt miyapɨr kerek nererik nau netike mɨt nɨrak disaipel hɨrak ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mɨt ne Skraip kerek ninɨn nertei hɨm me Moses natɨp mɨt em, hɨr netike mɨt ne Farisi, mɨt iuwe hɨr nehimɨteni hɨr natɨp mɨt hɨm me Moses ɨr enisesim. ");
INSERT INTO avt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Te yi eimtau menmen hɨr netpiyem yi eiyisesim. Te yi ap eiyises menmen hɨr nɨrɨakem au emɨt! Hɨr natɨp hɨm ham te hɨr ap nisesim au. Hɨr nises hɨm ham. ");
INSERT INTO avt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hɨr neriuwe hɨm mɨr kerek hɨr netpiyem yi eiyisesim hɨram mar ke hɨr neit menmen nɨmenum neneipetɨtem newisɨm mau yapɨr ki yi yeremɨme. Te hɨr ap nankepi nanɨt menmen nɨmenum yi yerermɨme au. Hɨr ap te nanises hɨm enum nɨpaa hɨr netpiyem yi eisesim taau. ");
INSERT INTO avt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hɨr nɨrɨak menmen yapɨrwe te mɨt kerek nɨrem hɨr nantɨp hɨr mɨt yaain. Hɨr nime ni newis hɨm me prea mekre tanɨk mɨram mau maat metike his mɨr, te mɨt nɨrem hɨr natɨp hɨr yaain. Hɨr nime ni nokim newisɨm neses laplap kerek hɨr newisɨm mau yɨnk mɨr me wɨ hɨr nitehi God menmen, te mɨt nɨrem hɨr natɨp hɨr yaain. ");
INSERT INTO avt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hɨr hanhan nanu yeno mɨt nehimɨtanem me mɨt iuwe nanwim neit wɨnak kerek mɨt nererik nekine hɨm me Moses neitai en nekre wɨnak ke mɨt me wɨ hɨr nererik naam menmen. ");
INSERT INTO avt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hɨr hanhan mɨt miyapɨr hɨr nɨri neit maket, hɨr nanwenɨpi niuk mɨr natɨp hɨr mɨt iuwe, hɨr nenewor, ‘Mɨt naiu iuwe tisa.’ ");
INSERT INTO avt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yi ap eiwis mɨt hɨr nenewi yi mɨt iuwe Tisa au emɨt! Yi yapɨrwe yɨre ni yinan keriyen, mɨtɨk kiutɨp hɨrak Mɨtɨk Iuwe God hɨrak Tisa ki. ");
INSERT INTO avt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yi ap eine mɨtɨk hak kiutɨp kau tɨ ik enewek ‘Mɨtɨk Haai Iuwe’ au ekɨt! Yi ap enewek Mɨtɨk Haai Iuwe ki eiyɨntar Mɨtɨk Haai Iuwe kiutɨp kerekek kepu. Hɨrak God kekrekek kerek kepu wit kɨrak Heven. ");
INSERT INTO avt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yi ap eiwis mɨt hɨr nenewi yi Mɨt Iuwe au emɨt eiyɨntar Mɨtɨk Iuwe kiutɨp ki hi Mɨtɨk kerek God kehimɨtena hi han akepi yi mɨt atihis. ");
INSERT INTO avt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Keimɨn hanhan niuk mɨrak iuwe kekre nɨmɨn ke yi mɨt hɨrak kakwenɨn han kɨrak kakisesi kakɨkepi kakrɨak menmen. ");
INSERT INTO avt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mɨt kerek han kitet hɨr yaain ninɨn mɨt han, maain God kakɨwaank niuk mɨr hɨram menmen weinɨm. Mɨt kerek hɨr newenɨn han kɨr han kitet hɨr weinɨn, maain God kaknip niuk mɨr hɨram iuwe. ");
INSERT INTO avt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Yi mɨt ne Farisi yetike yi mɨt kerek yinɨn yertei hɨm lo me Moses yatɨp mɨt em. Maain God kakiwep kakriwaank kakɨntar yi enun yewisesik. Yi yar ke mɨt enun neiyepet weipɨr ke mɨt hɨr nanɨno nɨmɨn. Yi ap hanhan yises hɨm me God werek werek au, te yi yewen mɨt miyapɨr kerek hanhan nanises God werek werek. ");
INSERT INTO avt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yi mɨt ne Farisi yetike yi mɨt kerek yatɨp mɨt hɨm me Moses. Maain God kakiwep kakriwaank kakɨntar yi enun yewisesik. Yi yemitetpɨn miyapɨr kerek mɨt epei naa, yi yemitorpɨn yeit menmen mɨr mekre wɨnak kɨr te maain yi yitehi God yerp ninaan me mɨt, yi yɨsawɨn menmen enum yi yɨrɨakem yeriuwe prea im te yi yenip mɨt hɨr han kitet yi yaain. ");
INSERT INTO avt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Yi mɨt ne Farisi yetike yi mɨt kerek yi yinɨn yertei hɨm lo me Moses yatɨp mɨt em. Maain God kakiwep kakriwaank kakɨntar yi mɨt enun yewisesik. Yi yɨrɨak menmen ham yapɨrwe te yi yari han ke mɨtɨk kiutɨp kakises hɨm mi. Maain hɨrak kises hɨm mi, yi yenipek hɨrak kakre nɨkan ke Seten kakno si tatɨknenik, kinɨn yi mɨt enun hɨrak ap kises God kakɨr ke yi mɨt. ");
INSERT INTO avt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Maain God kakiwep kakriwaank yi mɨt enun yar ke mɨt nanamɨr toto eiyɨntar yi ap yeteikɨn mɨt han yayiwe kɨrak werek werek au. Yi yemitorpɨn. Yi yatɨp, ‘Mɨtɨk hak kerek katɨp, “Hi tewen arɨak menmen. Hi ap te ewisiyek au hi atɨp werek. Hi ekine wɨnak iuwe ke God kakɨhimɨtenau hɨm mai.’” Yi yatɨp, ‘Hɨrak kaktɨp kakɨr ik, hɨrak ap te kakises hɨm mɨrak au menmen weinɨm.’ Yi yatɨp, ‘Mɨtɨk hak katɨp, “Hi tewen arɨak menmen. Hi ap te ewisesik au. Hi atɨp werek. Hi ekine gol mekre wɨnak iuwe ke God te hi hatɨp werek.’” Yi yatɨp, ‘Hɨrak katɨp hɨm im, hɨrak ekises menmen hɨrak ketpim em.’ ");
INSERT INTO avt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yi mɨt enun han auri. Mekam hɨram iuwe minɨn? Mekam au hɨram kike mɨkaru? Gol mɨwaai mekre wɨnak ke God o wɨnak ke God kerek kɨrɨak gol hɨram yaaim me God. Wɨnak ke God kerekek kinɨn! ");
INSERT INTO avt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yi wen yatɨp, ‘Mɨtɨk kerek kekine kɨnaan keit wɨnak ke God hɨram mehimɨtan hɨm mɨrak hɨrak katɨp hɨrak kakisesim. Maain hɨrak ap kakisesim te hɨram menmen weinɨm. Te mɨtɨk kerek kekine menmen mɨt hɨr newisɨm mentar kɨnaan, hɨr natɨp ‘Tru antap’, hɨram mamɨhimɨtan menmen hɨrak ketpim hɨrak kakisesim, te hɨrak kakisesim, o au en, hɨrak mɨtɨk enuk.’ ");
INSERT INTO avt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yi mɨt nanamɨr toto! Mekam hɨram iuwe minɨn a? Menmen mɨt newisɨm mɨwaai mentar kɨnaan newepwarem newet God, o kɨnaan hɨrekes kerek kɨrɨak menmen im mɨt newet God em hɨram yaaim? Kɨnaan keremem hɨram minɨn. ");
INSERT INTO avt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mɨtɨk kerek kekine kɨnaan hɨram mehimɨtan menmen hɨrak ketpim, hɨrak kekine kɨnaan metike menmen mewim hɨram mehimɨtan hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mɨtɨk kerek kekine wɨnak iuwe ke God kakɨhimɨtan menmen hɨrak ketpim hɨrak kakisesim, hɨrak kekine wɨnak ketike God kerek Hɨmɨn kɨrak kewik hɨrakɨt tehimɨtan hɨm hɨrak ketpim. ");
INSERT INTO avt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mɨtɨk kerek kekine wit ke God kakɨhimɨtan menmen hɨrak ketpim, hɨrak kekine wit ke God kerekek au. Hɨrak kekine God kerek kau wit kɨrak hɨrak kakɨhimɨtan menmen hɨrak katɨp hɨrak kakisesim. ");
INSERT INTO avt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Yi mɨt ne Farisi yetike yi mɨt kerek yinɨn yertei hɨm lo me Moses yatɨp mɨt em. Maain God kakriwaank kakɨntar yi mɨt enun yewisɨk. Yi yewep menmen mi yapɨrwe mar hiswiyen (10) te maain yi yewet God menmen mi miutɨp me menmen hiswiyen (10). Yi yises menmen kike im te yi yeweikɨn sip yewet hɨm iuwe me God ham im. Yi ap yises menmen yaaim, yi ap hanhan mɨt miyapɨr han au, yi ap yises menmen yi yetpim au. Yi yɨrɨak menmen iuwe im metike menmen kike me yewet God menmen te yi yaain. Te au, yi yɨnapen! ");
INSERT INTO avt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yi mɨt enun yɨre mɨt nanamɨr toto yeteikɨn mɨt han yayiwe ke God. Yi hanhan yayises menmen kike me hɨm me God te yi han kaa yayises menmen mɨrak iuwe. ");
INSERT INTO avt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Yi mɨt ne Farisi yetike yi mɨt kerek yinɨn yertei hɨm lo me Moses yatɨp mɨt em. Maain God kakriwaank kakɨntar yi mɨt enun yewisesik. Han ki hɨrak kɨre wenkepye metike kap kerek mɨt nekemyetɨt neke wit te hɨram menmen enum mewim meke nɨmɨn hɨr ap nekemyetɨt au. Han ki enuk keit nɨmɨn kentar menmen yi yisesim yi yetɨwem yeriuwe menmen enum yi yɨrɨakem yeriyaam yises han ki. ");
INSERT INTO avt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yi mɨt ne Farisi yi han auri. Yi yar ke mɨt enun nanamɨr toto. Yi eiyinɨn eiyises menmen yaaim mekre han ki te maain menmen yi yairɨakem hɨram mamre yaaim. Menmen im hɨram mamre mɨt nekemyet wenkepye metike kap neke nɨmɨn, neke wit. ");
INSERT INTO avt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Yi mɨt ne Farisi yetike yi mɨt yatɨp mɨt han hɨm me Moses. Maain God kakriwaank kakɨntar yi mɨt enun yewisesik. Yi han ki yar ke hei herwe maa mɨt newisɨm mekrerek. Hɨr namɨr timen meweiknɨwek te mɨt nanɨnen nanɨrem hɨr han kitet hei hɨrak yaaik. Te menmen enum mɨre herwe hemik paan mɨnɨn mekrerek. ");
INSERT INTO avt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mar im mɨt miyapɨr nɨri hɨr han kitet yi mɨt yaain yises hɨm yaaim. Te yi mɨt enun. Menmen enum mɨsawɨn mekre han ki. Menmen me yi yewisesik ek, metike menmen ham enum enum. ");
INSERT INTO avt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Yi mɨt ne Farisi yetike yi mɨt kerek yi yinɨn yertei hɨm lo me Moses yatɨp mɨt em. Maain God kakriwaank kakɨntar yi mɨt enun yewisesik. Yi yeses hei kerek mɨt profet nɨpaa nau tɨ hɨr naa hemik mɨr mɨwaai mekrerem. Hɨram metike hei mei me mɨt yaain nɨpaa naa hemik mɨr mɨwaai mekrerem. ");
INSERT INTO avt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yi yatɨp yar ik: ‘Nɨpaa haiu mepu tɨ wɨ mɨt profet hɨr nepu netike maamrer naiu, haiu ap te manɨp mar ke maamrer naiu nɨrɨakem taau.’ ");
INSERT INTO avt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Te yi yeriuwe hɨm im yi yetpim yewepyapɨr yi nepenyerer ne mɨt kerek nɨpaa nenep mɨt profet hɨr naa. ");
INSERT INTO avt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hi hetpi. Yi yayises menmen enum nɨpaa maamrer ni hɨr nɨrɨakem ere yi enun yayɨr ke hɨr enun. ");
INSERT INTO avt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yi mɨt enun yar ke manpen (o yenmik). Yi mɨt enun nepenyerer ne mɨt enun nɨre manpen. Yi yarkeik yi han kitet yi ap eino si tatɨkneni a? Taauye! ");
INSERT INTO avt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Te hi hetpi. Maain hi ariuwet mɨt profet nantike mɨt nertei hɨm me God werek werek netike mɨt nanwepyapɨr hɨm mai yaaim. Mɨt han ne mɨt in yi yainɨp yeiwenkeki nanu nu tentarakɨt. Mɨt han yi yainɨp yairiuwe nɨpɨn yayɨt wɨnak kerek yi yekine hɨm me Moses yekrerem. Yi yaipɨri nanɨnaaiwɨr wit ik yi yayɨnyei hɨr nanrɨr nanɨno nanrer wit wit. ");
INSERT INTO avt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yi eirɨak menmen im te God kakrekyi enum kakiwep kakrer paan ki. Hɨrak kakiwep kakɨntar kakrer paan ki me mɨt yapɨrwe yaain naa, me wɨ hemkre me mɨtɨk yaaik Ebel mewen ere me mɨtɨk profet Sekaraia, nɨkan ke Berekaia, kerek maamrer ni hɨr nakɨp kaa kekre nɨmɨn ke kɨnaan metike wɨnak iuwe ke God. ");
INSERT INTO avt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hi hetpi werek. Menmen im enum yapɨrwe mamnen yi mɨt miyapɨr kerek yi en ek yau tɨ yaiyɨntar menmen hi nepei hetpiyem yi yairɨakem. ");
INSERT INTO avt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yi mɨt miyapɨr ne Jerusalem, wit kerek mɨt newi hɨr nenep mɨt profet. Hɨr nenep mɨt kerek God keriuweti nan nɨri. Wɨ yapɨrwe hi hanhan naanmɨpri me menmen enum har ke suware naanmɨpre nɨkim mɨre mɨnɨk yapɨr mɨre. Te yi au yɨnapen. ");
INSERT INTO avt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yi eiyɨmtewem. Maain wit ki hɨrak kaku weinɨk mɨt miyapɨr ap nanwi au. ");
INSERT INTO avt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","In ere maain yi mɨt miyapɨr ne Jerusalem ap pɨke nanɨra meiyam au ere yi eitɨp, ‘God naanmamre kakɨkaap Mɨtɨk ik Krais kerek kekrehɨr kɨrak hɨrak keriuwetek kan in.’” ");
INSERT INTO avt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas kɨnaaiwɨr wɨnak iuwe ke God ken witeik, mɨt nɨrak disaipel newenyɨpɨrek te hɨr nanteiknɨwek wɨnak yaaim yapɨrwe me wɨnak iuwe ke God. ");
INSERT INTO avt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hɨr neteiknɨwekem, te hɨrak ketpor, “Hi hetpi werek. Yi yɨr menmen yapɨrwe im a? Maain wɨ mamnen te nan kerek mɨt nime wɨnak meriuwerem, hɨrak ap te mamwaai mamɨntereram au. Mɨt nanɨnen nanwepim te hɨram yapɨrwe mamɨnke mamwaai tɨ.” ");
INSERT INTO avt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas wen kau mɨniu (o neiyɨp) mɨt nenewek wit Oliv, mɨt nɨrak disaipel keriyen nan nitɨwekhi natɨp, “Ti etpai wɨ kerek menmen im enum mamnen, metike mekam mamnen mamteiknei wɨ im epei man te ti enen ewepyapɨr hɨrekes te menmen God kakrɨakem hɨram epei au.” ");
INSERT INTO avt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas kewenhi ketpor, “Yi naanmamre hɨras ap eiwis mɨt han hɨr nanwisesiyek. ");
INSERT INTO avt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ap eiwis mɨt han hɨr nanwisesiyek nanɨntar hɨr yapɨrwe nanɨnen nanmitipɨn nanɨkrehɨr kai nantɨp, ‘Hi kerekek hi Krais kerek God kehimɨtena hi anen akaap mɨt.’ Hɨr nanwis mɨt miyapɨr yapɨrwe nanriuwe hɨm mɨr. ");
INSERT INTO avt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maain yi eiyɨmtau mɨt neit menep hɨr nenepan, yi eiyɨmtau hɨm me mɨt hɨr neit yanɨmɨn hɨr nenepan, te yi ap einapen au emɨt! Menmen im hɨram emnen te wɨ hi anen awepyapɨr hɨrekes nepei man wen au. ");
INSERT INTO avt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mɨt ne weiwɨk miutɨp hɨr netike mɨt ne weiwɨk ham hɨr nanɨnepan. Mɨt kerek nau tɨ menep in nantike mɨt neit yanɨmɨn hɨr nanɨnepan. Mɨt nerer wit wit nɨnpɨ mamɨn nanɨntar hɨr menmen mau ni au. Tɨ mamrer wit wit mamtanɨk. ");
INSERT INTO avt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Menmen im kerek mamnen hɨram mamre mɨte hɨre tu hɨmɨr ketnɨnɨwe iuwe te hɨre wawine nɨkan. Mɨt miyapɨr nau tɨ menmen im mamnen mamɨkrit mamriwaank. ");
INSERT INTO avt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Me wɨ im mɨt nantihis yi yaino wɨnak enuk te mɨt naniwep yayi o yɨnk ki hɨr nanɨwaankem. Mɨt nanrer wit wit han enuk nanriuwi nanɨneini nanɨntar yi yises hɨm mai. ");
INSERT INTO avt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wɨ im mamnen, mɨt yapɨrwe nanweikɨn sip nanwet hɨm mai. Hɨr nanwepyapɨran, han enuk nanɨriuwehan. ");
INSERT INTO avt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Me wɨ im, mɨt profet enun newisesik hɨr yapɨrwe nanɨnen nanri han ke mɨt miyapɨr yapɨrwe nanwisɨsorek nanriuwe hɨm mai. ");
INSERT INTO avt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Me wɨ im mɨt miyapɨr nanises han kɨr nanrɨak menmen enum yapɨrwe te mɨt miyapɨr yapɨrwe hɨr ap hanhan nanriuwehan wɨsenum au, kike keremem. ");
INSERT INTO avt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Te mɨt miyapɨr kerek nanisɨsa werek werek ere hɨr nani, maain hi atorhis hɨr nanu nantikewa. ");
INSERT INTO avt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mɨt miyapɨr hɨr nanwepyapɨr hɨm yaaim me God kakinɨn naanmamre mɨt, hɨr nanɨtpim nanrer wit wit te mɨt nanɨrtei menmen yaaim God kɨrɨakem. Hɨr nanwepyapɨrem epei au, maain wɨ mamnen te hi anen awepyapɨr hɨrekes te menmen God kakrɨakem hɨram epei au. ");
INSERT INTO avt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Maain yi yayɨr menmen enum mamɨwaank wɨnak iuwe ke God mamɨrp mamɨkre nɨmɨn kerek hɨram ap te mamno nɨmɨn au kerek nɨpaa profet Daniel katɨp hɨram mamnen (yi mɨt kerek yekine menmen im, yi han kitetim werek werek). ");
INSERT INTO avt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Te yi mɨt yapɨrwe kerek yi yepu provins Judia, yi yairɨr yaino mɨniu o neiyɨp eisawɨn eiyɨt ein. ");
INSERT INTO avt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mɨt miyapɨr kerek nau wepni neit witeik, hɨr ap pɨke nanɨno nɨmɨn wɨnak nanɨt menmen mɨr mekrerek au emɨt! Hɨr nanrɨr waswas nanɨno. ");
INSERT INTO avt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mɨt miyapɨr kerek neit ni mɨr, hɨr ap pɨke nanɨno witeik nanɨt menmen klos au emɨt! Hɨr nanrɨr waswas nanɨno. ");
INSERT INTO avt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Maain wɨ menmen im mamnen, miyapɨr nanɨnan nɨkerek kike wen nau sɨnipau hɨr nanɨwaank nanɨntar hɨr ap te nanrɨr waswas au. ");
INSERT INTO avt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yi eiyitehi God te yi ap eirɨr me hawɨ hɨtan o wɨ Sabat au emɨt eiyɨntar yi ap te eirɨr waswas au. ");
INSERT INTO avt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Me wɨ im menmen enum mamnen mamɨwaank mɨt miyapɨr nau tɨ. Menmen mar im ap man nɨpaa God kinɨn kewis tɨ ere in. Maain menmen enum mar im ap pɨke mamnen taau. ");
INSERT INTO avt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","God ap te kakremir wɨ menmen enum im mamu tɨ te mɨt miyapɨr yapɨrwe nani. Au, God han kitet mɨt miyapɨr kerek hɨrak kehimɨteni hɨr nises hɨm mɨrak te hɨrak kakremir wɨ menmen im mamu tɨ. ");
INSERT INTO avt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Maain me wɨ im mɨtɨk hak kakɨtpi, ‘Yi eiyɨrek. Mɨtɨk Iuwe Krais hɨrak kepu in!’ O ‘Hɨrak kau keit pɨnak ein!’ Hɨrak kakɨtpi hɨm mamɨr im yi ap yayisesim au emɨt! ");
INSERT INTO avt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hi hetpi. Maain mɨt enun newisesik nanɨno nantɨp hɨr Krais o hɨr mɨt profet hɨr nanwepyapɨr hɨras. Hɨr nanrɨak menmen iuwe nɨpaa mɨt nɨrɨakem au, te hɨr nanri han ke mɨt miyapɨr kerek nises hɨm me God. Te hɨr ap nanisesim taau. ");
INSERT INTO avt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yi eiyɨmtau. Hi hinɨn etpi menmen im. Maain menmen im mamnen yi eiyɨrteiyem. ");
INSERT INTO avt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Maain mɨt hɨr nanɨtpi nanɨr ik: ‘Yi einen eiyɨrek! Hɨrak kau wit weinɨk mɨt ap newi au!’ Te yi ap eino au emɨt! ");
INSERT INTO avt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yi yɨr nepni mewenɨn meke wepni kokai kan ere kewen ken. Kakɨr eik te maain yi eiyɨr hi mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen. Mɨt miyapɨr yapɨrwe nanra. ");
INSERT INTO avt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Wit kerek mɨtɨk herwe kɨwaairi, hore tepre mamnen mamkɨp mamkinenik mamɨk. Marim im maain mɨt yapɨrwe nau tɨ hɨr enun enun, hi pɨke anen etike mɨt ensel hi skelim hɨr mɨt hi ahɨwaanki. ");
INSERT INTO avt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Maain wɨ menmen enum epei man mau tɨ, wepni kakweikɨn kakre wɨtaan, wenke ap te kakɨr au, hɨr mau nepni mamɨnkɨke, menmen iuwe mau nepni hɨram mamtanɨk. ");
INSERT INTO avt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Menmen im epei au, te menmen mamu nepni mamteikɨn mɨt hi mɨtɨk ke wit ke Mɨtɨk Iuwe hi awepyapɨr hɨrekes, te mɨt miyapɨr ne weiwɨk yapɨrwe nerer wit wit nankɨt nanra hi hau hentɨr napɨ heriuwe menmen mai iuwe metike menmen mai yaaim merhɨhe hi anen. ");
INSERT INTO avt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hi anen, te God kaktenwo taur. Kaktenwo taur, hi heriuwet mɨt ensel nai hɨr nanɨno nanrer wit wit kerek mɨt miyapɨr hi hehimɨteni hɨr nises hɨm mai hɨr nanwiyen, hɨr nanri nanɨnen nantikewa mamu niutɨp. ");
INSERT INTO avt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Hi eteikni menmen heriuwe nu fik. Maain wɨ kerek heneik mɨrak hɨram mamɨnsiunen, te yi eiyɨrtei menep te wepni yaaik. ");
INSERT INTO avt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mar im, maain yi eiyɨr menmen hi etpiyem hɨram epei man, te yi eiyɨrtei hi menep te hi pɨke anen. ");
INSERT INTO avt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hi hetpi werek. Mɨt miyapɨr kerek nepu tɨ in ek, hɨr ap te nani ere menmen yapɨrwe im mamnen. ");
INSERT INTO avt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nepni mamtike tɨ mamɨwaank mamɨt te hɨm mai ap te mamɨwaank au emɨt! Hɨram mamu mamɨt tipmain tipmain enum eik, te menmen hi nepei hetpim hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mɨt miyapɨr nau tɨ o ensel neit wit ke God o hi mɨtɨk iuwe ke wit ke mɨtɨk iuwe, haiu yapɨrwe ap mertei wɨ kerek God kakriuweta hi pɨke anen tɨ. God kiutɨp kerek kertei. ");
INSERT INTO avt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wɨ kerek hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen tɨ, hɨram menmen mamnen mamɨr ke nɨpaa wɨ mɨtɨk Noa kau tɨ ik. ");
INSERT INTO avt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Me wɨ hawɨ ap epei man mɨwapɨn tɨ wen au, mɨt miyapɨr nises menmen mar ke nɨpaa hɨr nɨrɨakem. Hɨr naam menmen, neitan, nesiuwe yenterer nantike mɨt han hɨr nanɨtan ere wɨ Noa ken kau kekre sip. ");
INSERT INTO avt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hɨr mɨt miyapɨr hɨr ap nertei menmen enum mamnen ere tɨpar mɨniu manɨp meri men hɨr naa. Mar im maain hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen, te mɨt miyapɨr ap nanmeriyau hi anen au. ");
INSERT INTO avt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Maain wɨ hi pɨke enen, mɨtɨkɨt wiketeret tatu ni mɨrakɨt. Hi ehɨt his mɨtɨk kiutɨp kaknen, kiutɨp au hi ewisɨk kaku kakɨt ni eim. ");
INSERT INTO avt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Maain miyapɨr wik hɨr nenepɨp tiu, hi ehɨt his piutɨp, peiyap hi au ewisiye wawu wawɨt yaank eik. ");
INSERT INTO avt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yi naanmɨpre hɨras te yi yises God werek werek yayɨntar yi yepɨtari wɨ kerek hi Mɨtɨk Iuwe ki hi pɨke anen. ");
INSERT INTO avt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yi han kitet menmen im. Mɨtɨk kerek kau wɨnak kertei wɨtaan kerek mɨtɨk enuk kekintɨp menmen kaknen, te hɨrak naanmamre wɨnak kɨrak ap kakwis mɨtɨk enuk kaknen kekintɨp menmen mɨrak. Te hɨrak au kepɨtari. Mar im wɨ kerek mɨt nepɨtariyem, hi pɨke anen tɨ ik. ");
INSERT INTO avt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Te yi mɨt eiyises God werek werek eiyɨntar hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen me wɨ yi ap yerteiyem. ");
INSERT INTO avt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yi mɨt keriyen yi yɨre mɨtɨk yaaik kertei menmen werek werek te mɨtɨk iuwe kɨrak kewisɨk hɨrak kɨre mɨtɨk iuwe naanmamre mɨt miyapɨr kerek nɨrɨak menmen me mɨtɨk iuwe, hɨrak kakwetɨr menmen me wɨ hɨrak kehimɨtanem hɨr nantɨwem. ");
INSERT INTO avt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maain mɨtɨk iuwe kɨrak nɨpaa kɨnaaiwɨr wit, hɨrak pɨke kaknen kakɨr ke mɨtɨk kɨrɨak menmen nɨpaa hɨrak kehimɨtenɨwekem, hɨrak han yaaik kakriuwerek te hɨrak wok mɨtɨk kɨrak kaku werek werek. ");
INSERT INTO avt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Hi hetpi werek werek. Maain hɨrak kaknen kakɨrek kises menmen yaaim, hɨrak kakɨhimɨtanek hɨrak naanmamre menmen mɨrak yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mɨtɨk ik au, hɨrak enuk kɨnapen kises menmen me mɨtɨk iuwe, hɨrak kaktɨp hɨrekes, ‘Mɨtɨk iuwe kai ken yanɨmɨn ap pɨke kaknen waswas au.’ ");
INSERT INTO avt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Hɨrak kaktɨp kakɨr ik, te hɨrak kaknenp mɨt miyapɨr kerek nɨrɨak menmen me mɨtɨk iuwe kɨrak, hɨrak kakno kaktike mɨt enun netaritari naam tɨpar si enum, hɨrak kaktikeri nanɨm. ");
INSERT INTO avt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Maain mɨtɨk iuwe kɨrak kaknen me wɨ hɨrak ap han kitet hɨrak kaknen, te hɨrak kemeriyɨwek au. ");
INSERT INTO avt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mɨtɨk iuwe kaknen hɨrak kaknep mɨtɨk ik wɨsenuk kakɨwaankek kaksiuwerek kakno wit kerek mɨt enun newisesik newi en. Mɨt neit in hɨr nine han enuk nɨkɨt nɨnakɨn yehes. ");
INSERT INTO avt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Maain wɨ kerek hi mɨtɨk ke wit ke Mɨtɨk Iuwe pɨke anen, God kakwis mɨt miyapɨr nanɨno wit kɨrak kakɨr ke miyapɨr nɨhan nar hiswiyen (10) kerek neit lam mɨr nen nemerɨr mɨtɨk pɨpɨak kaknen kakɨt his mɨte pɨrak. ");
INSERT INTO avt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Miyapɨr hispɨnak (5) hɨr nertei menmen werek werek miyapɨr hispɨnak (5) au hɨr netari netari menmen. ");
INSERT INTO avt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Miyapɨr netaritari hɨr neit lam neiyɨm nan te hɨr ap neit tɨpar mei te nanwenem mamɨkre lam au. ");
INSERT INTO avt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Miyapɨr hɨr nertei menmen werek werek te hɨr neit lam metike tɨpar mei te nanwenem mamɨkre lam mɨr. ");
INSERT INTO avt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hɨr epei nan nemerɨr mɨtɨk ik kaknen te hɨrak ap kan waswas au. Hɨrak ap kan waswas au te hɨr nanamɨr menen hɨr nɨwaai. ");
INSERT INTO avt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Hɨr nɨwaai nɨnatɨn, wɨ nɨmɨn hɨr nemtau mɨtɨk hak kenɨne katɨp, ‘Mɨtɨk pipɨak kaknen kakɨthis mɨte pɨrak, yi eino eiwenyipɨrek eiwisɨk yayiwe yi eitɨwekhis eiyɨk einen.’ ");
INSERT INTO avt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Miyapɨr nemtau menmen im, te hɨr nekrit newen tɨpar mekre lam hɨr neweiknɨm merhɨhe mɨr te hɨr neiyɨm nen. ");
INSERT INTO avt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Te miyapɨr enun netaritari natɨp miyapɨr han yaain en nar ik: ‘Yi eiwetei tɨpar mei mi te haiu emwenem emɨkre lam maiu, te haiu emtikewi emno. Lam maiu tɨpar epei au mesi te hɨram mami.’ ");
INSERT INTO avt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Te miyapɨr han en netpor, ‘Haiu ap metenen tɨpar yapɨrwe te haiu mamweti mei au emɨt! Au kike. Haiu mamweti tɨpar mei kike, te maain haiu lam maiu yapɨrwe mami. Yi eino eiyɨt mei eiyɨt wɨnak kerek mɨt nansiuwerem nanwet mɨt em hɨr enweti mei.’ ");
INSERT INTO avt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hɨr netpor epei au, miyapɨr netaritari nen nanɨt tɨpar mei. Hɨr neit ein, mɨtɨk pipɨak kan kiun wɨnak eik kan kiun wɨnak eik, hɨr miyapɨr kerek nemeriyɨwek hɨr netikerek nen nɨmɨn en, hɨr neiyepet weipɨr. ");
INSERT INTO avt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Maain miyapɨr han en pɨke nan nenɨne natɨp, ‘Mɨtɨk iuwe, mɨtɨk iuwe, ti ekeisiuwai weipɨr.’ ");
INSERT INTO avt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hɨr nenɨnewek te hɨrak ketpor, ‘Hi hetpi werek. Hi ap hertei yi neimɨn. Yi ap nai yinan au.’ ");
INSERT INTO avt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Te Jisas ketpor kar ik: “Yi naanempre hɨras te yi eiyises God werek werek eiyɨntar yi yepɨtari wɨ hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi anen. ");
INSERT INTO avt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Maain menmen God kakrɨak mɨt miyapɨr em te hɨr nantikerek nanu nanɨt wit kɨrak hɨram mamɨr ke mɨtɨk iuwe kakno yanɨmɨn. Hɨrak kakno yanɨmɨn te hɨrak kenɨne mɨtɨkɨt tɨrak wikak hɨrak kehimɨtanet hɨrakɨt naanmamre menmen mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hɨrak han kitet tarkeik te hɨrakɨt tɨrɨak menmen te hɨrak kewetɨwekɨt menmen mar im. Mɨtɨk kiutɨp kertei werek, hɨrak kewetɨwek 5,000 pewek. Mɨtɨk hak hɨrak kewetɨwek 2,000 pewek. Mɨtɨk hak au kertei kike, hɨrak kewetɨwek 1.000 pewek. Hɨrak kɨrɨak menmen mar im epei au, hɨrak ken. ");
INSERT INTO avt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hɨrak ken yanɨmɨn, mɨtɨk kerek ketenen 5,000 pewek ken waswas kewɨr pewek mɨrak te hɨrak keiyɨm kari pewek 5,000 meiyam man metikerem (mɨre kas mani). ");
INSERT INTO avt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hɨrak mɨtɨk hak kerek ketenen 2,000 pewek, hɨrak ken kewɨrem keiyɨm kari pewek 2,000 ham man metikerem kar ke mɨtɨk hak epei kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mɨtɨk hak au. Hɨrak ken witeik kekin hei keit 1,000 pewek nɨpaa mɨtɨk iuwe kewetɨwekem, hɨrak kɨsawɨnem mekrerek kɨwapɨnem mɨwaai meit. ");
INSERT INTO avt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Maain wenke yapɨrwe epei men, mɨtɨk iuwe pɨke kan kitɨwekɨthi me pewek kerek hɨrak nɨpaa kewetɨwekɨtem. ");
INSERT INTO avt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mɨtɨk kerek nɨpaa keit 5,000 pewek, hɨrak kan kewetɨwek pewek ham metikerem ketpɨwek kar ik: ‘Mɨtɨk iuwe, ti nɨpaa eweto 5,000 pewek im, te hi hɨrɨak menmen heriuwerem hi hari 5,000 pewek ham man metikerem.’ ");
INSERT INTO avt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mɨtɨk iuwe kewenhi ketpɨwek, ‘Ti hɨrɨak menmen yaaim, ti kai yaaik. Ti naanempre werek werek menmen kike im te hi ewetit menmen yapɨrwe te ti naanmamprewem. Ti enen ehu etikewa han yaaik.’ ");
INSERT INTO avt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hɨrak ketpɨwek epei au, mɨtɨk hak kerek ketenen 2,000 pewek hɨrak kises mɨtɨk kerek ketenen 5,000 pewek kinɨn kan kɨr mɨtɨk iuwe, hɨrak kisesik kan katɨp, ‘Mɨtɨk iuwe, nɨpaa ti eweto 2,000 pewek, te hi hɨrɨak menmen heriuwerem, hi hari 2,000 pewek ham man metikerem.’ ");
INSERT INTO avt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mɨtɨk iuwe kewenhi katɨp, ‘Ti hɨrɨak menmen yaaim ti kai yaaik. Ti naanmɨpre werek werek menmen kike im te hi ewetit menmen yapɨrwe te ti naanmamprewem. Ti enen ehu etikewa han yaaik.’ ");
INSERT INTO avt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hɨrak katɨp epei au, mɨtɨk kerek ketenen 1,000 pewek hɨrak kɨkaru kan katɨp kar ik: ‘Mɨtɨk iuwe, hi hertei ti mɨtɨk enuk hatɨp hɨm tokim tokim. Ti atɨp mɨt hɨr namɨr ni mit, te maain ti ehɨt menmen yeunɨm. Ti atɨp mɨt hɨr newen rais hɨr newis haas mɨram mɨwaai han, hɨr newis nɨkim mɨwaai han. Ti au hetɨwem yeunɨm ewisɨm meit wɨnak kit. Hɨr au. ");
INSERT INTO avt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hi hertei ti mɨtɨk enuk har ke hi hetpim te hi hɨnapen hewɨr pewek mit ewaankem. Hi hetɨwem heiyɨm hen hewisɨm mekre hei. Ehɨrem. Hi epei heit menmen mit ewetitem im em.’ ");
INSERT INTO avt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mɨtɨk iuwe ketpɨwek kar ik: ‘Ti mɨtɨk enuk hau yain yain. Ti epei hertei hi hatɨp mɨt hɨr namɨr ni mai te hi ahɨt menmen yeunɨm. Ti hertei hi hatɨp mɨt nanwen rais hɨr nanɨt nɨkim mɨram mamwaai, te hi atɨwem yeunɨm ewisɨm emɨkre wɨnak kai a? ");
INSERT INTO avt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Te henmak te ti ap hewis pewek mai mekre his me mɨt hɨr naanmɨpre benk te maain hi han hi pɨke ahɨt pewek mai mamtike pewek meiyam kike mamtikerem? ");
INSERT INTO avt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yi mɨt nai yerp menep, yi eiyɨt pewek me mɨtɨk ik, yi eiwet mɨtɨk kerek ketenen 5,000 pewek em. ");
INSERT INTO avt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yi eiwetɨwek pewek eiyɨntar mɨtɨk kerek kɨrɨak menmen keriuwe menmen hɨrak ketenenim hɨrak kakɨt meiyam mamtikerem. Te hɨrak ketenen menmen yapɨrwe. Mɨtɨk kerek ap kɨrɨak menmen keriuwe menmen kike hɨrak ketenenim, maain hi ariyaam etɨwem hɨrak kaku weinɨm. ");
INSERT INTO avt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yi eiyɨthis mɨtɨk enuk ik eiyɨk eiwɨrek ekno wit enuk toto kerek mɨt nau en hɨr han enuk nɨkɨt nɨnakɨn yehes.’ ");
INSERT INTO avt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Maain wɨ hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen ariuwe menmen mai iuwe merhɨhe mamtike mɨt ensel, hi ehu yeno mai yaaim me Mɨtɨk Iuwe. ");
INSERT INTO avt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mɨt ensel ne God hɨr nanɨthis mɨt miyapɨr nanrer wit wit ne tɨ hɨr nanrerik nanu nantikewa menep ninaan mai. Hɨr nanu, te hi ahɨnkeri han nanɨno in, han nanɨno ein nanɨre mɨt hɨr nenke sipsip metike meme. ");
INSERT INTO avt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hi awis mɨt miyapɨr yaain nɨre sipsip hɨr nanɨno his yaaim mai, hi awis mɨt miyapɨr enun nɨre meme hɨr nanɨno his henkik mai. ");
INSERT INTO avt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Epei au, hi Mɨtɨk Iuwe atɨp mɨt miyapɨr kerek nerp his yaaim mai etpor har ik: ‘Yi mɨt miyapɨr kerek Haai kai God hɨrak kerekyi yaaim, yi einen eiyɨt menmen yaaim mi kerek God nɨpaa kime tɨ metike nepni wen au, hɨrak kehimɨteni yi eitɨwem. ");
INSERT INTO avt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hi nɨnpɨ meiyo te yi yeweto menmen mi hi haam. Hi hɨm niu enuk (o mar kewen kɨkau hɨm) te yi yeweto tɨpar hi haam. Hi hɨre mɨtɨk ke wit hak yi yeratayi yi epei yetauhis yerya yen wɨnak ki. ");
INSERT INTO avt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hi klos au te yi epei yewetewem. Hi hɨnap te yi naanmɨrau ere hi hɨre yaaik. Hi hen hekre wɨnak enuk te yi yan yɨra yekepa yeriuwe menmen.’ ");
INSERT INTO avt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Hi atɨp menmen im epei au, hɨr mɨt miyapɨr yaain hɨr nanitauhi, ‘Mɨtɨk Iuwe, nɨpaa haiu ap mɨrit ti nɨnpɨ mito, te haiu mewetiti menmen mei au. Nɨpaa haiu ap mɨrit ti hɨm niu enuk (o mar kewen kɨkut hɨm) te haiu mewetit tɨpar mei au. ");
INSERT INTO avt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nɨpaa haiu ap mɨrit ti hɨre mɨtɨk ke wit hak au te haiu metuthis merit men nɨmɨn wɨnak kaiu au, o haiu ap mewetit klos mei au. ");
INSERT INTO avt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nɨpaa haiu ap mɨrit ti hɨnap te haiu ap mekepit ere ti yaaik au, o ti hekre wɨnak enuk haiu men mɨrit au.’ ");
INSERT INTO avt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Te hi Mɨtɨk Iuwe ewenhi etpor, ‘Hi hetpi werek. Wɨ kerek yi epei yɨkaap mɨt nai yinan in kerek nises hɨm mai, hɨram mar ke yi yerekyewem.’ ");
INSERT INTO avt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Hi etpor epei au, hi eweikɨn atɨp mɨt miyapɨr nau his henkik mai etpor, ‘Yi mɨt miyapɨr enun kerek God kerekyi enum yi einopɨn eikeipno, yi eino si kerek ap te mami au. Hɨram mamu mamɨt tipmain tipmain enum eik. God epei kemani si im me Seten ketike mɨt ensel nɨrak. ");
INSERT INTO avt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yi eino si enum eiyɨntar nɨpaa hi nɨnpɨ meiyo yi ap yeweto menmen mei au. Hi hɨm niu enuk (o mar kewen kɨkau hɨm) te yi ap yeweto tɨpar mei hi hahɨm au. ");
INSERT INTO avt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nɨpaa hi hɨre mɨtɨk ke wit hak te yi ap yekepa yerya yan wɨnak ki au, o hi klos au te yi ap yeweto mei au. Hi hɨnap te yi ap yekepa hi hɨre yaaik au. Hi hen hekre wɨnak enuk te yi ap yan yɨra yekepa yeriuwe menmen mi au.’ ");
INSERT INTO avt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Hi etpor epei au, te hɨr nanitauhi nanɨtpo, ‘Nɨpaa haiu ap mɨrit ti nɨnpɨ mito o ti hɨm niu enuk (o mar kewen kɨkut hɨm), o ti hɨre mɨtɨk ke wit hak, o ti klos au, o ti hɨnap, o ti hen hekre wɨnak enuk te haiu ap mekepit au.’ ");
INSERT INTO avt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Te hi Mɨtɨk Iuwe etpor, ‘Hi hetpi werek. Nɨpaa yi ap yɨkaap mɨt nai yinan weinɨn kerek nises hɨm mai, yi yar ke yi ap yekepa au.’ ");
INSERT INTO avt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hi etpor epei au, mɨt miyapɨr enun hi ariuweti hɨr nanɨno wit enuk kerek hɨr nanɨwaank nanɨt tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas katɨp ketike mɨt keriyen epei au, hɨrak katɨp mɨt disaipel nɨrak. ");
INSERT INTO avt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Hɨrak katɨp, “Yi yertei wɨ wiketerem mepeit te wɨ me haiu mamɨm menmen me Pasova hɨram mamnen. Te mɨtɨk hak kakwepayapɨr te mɨt enun nantauhis hi Mɨtɨk ke wit ke Mɨtɨk Iuwe nanwenkɨke ehu nu tentarakɨt.” ");
INSERT INTO avt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Me wɨ im hɨr mɨt iuwe ne pris netike mɨt iuwe ne kausil nen nererik nau wɨnak ke mɨtɨk iuwe Pris niuk mɨrak Kaiafas. ");
INSERT INTO avt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Te hɨr nimenɨpɨnan menmen newen hɨm Jisas te hɨr nɨsawɨn nantenenik nanrɨak (nanɨriyaak neiyɨk) nanɨno nansiuwe hɨm enum te hɨr nankɨp kaki. ");
INSERT INTO avt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Te hɨr natɨp, “Haiu ap emrɨak im em wɨ kerek mɨt miyapɨr nererik naam menmen em, te hɨr han kekrit nanɨnepɨp nansikeyaanmi nanɨntar hɨr han kitet Jisas hɨrak Mɨtɨk Iuwe profet, hɨr nɨnapen hɨrak kaki.” ");
INSERT INTO avt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas kau keit wit Betani keit wɨnak ke mɨtɨk kerek nɨpaa his hɨt mɨnwo niuk mɨrak Saimon. ");
INSERT INTO avt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hɨrak kau wɨnak ek, mɨte hap piutɨp wan wɨrek. Hɨre wetenen mɨn tɨpar me nu nad nekenpɨ mɨrak mɨnɨn yaaaim mekrerek. Hɨre wewɨr pewek iuwe mererim. Te hɨre wan wewen tɨpar im mɨnɨn yaaim mentar paan ke Jisas kerek hɨrak wen kaam menmen kau yeno kerek mɨt naam menmen menterim. ");
INSERT INTO avt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hɨr mɨt disaipel nɨr menmen im, te hɨr han enuk. Hɨr natɨpan, “Wenmak te mɨte ip wewen tɨpar mɨnɨn yaaim em mentar Jisas men weinɨm? ");
INSERT INTO avt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Te haiu emsiuwe tɨpar mɨnɨn yaaim im emno mɨt han enwɨr pewek emrim emtɨwem te haiu emɨt pewek yapɨrwe emwet mɨt enun ap netenen menmen em.” ");
INSERT INTO avt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas kertei hɨm hɨr netpim, te hɨrak ketpor, “Yi yenmak te yi yene mɨte ip einipɨye yɨnk enuk. Hɨre epei werekyo menmen yaaim. ");
INSERT INTO avt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wɨ yapɨrwe mɨt enun netenen menmen au hɨr nanu nantikewi te yi eikepi. Te hi au, hi ap ehu atikewi wɨ yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mɨte ip hɨre wewen tɨpar mɨnɨn yaaim em mentar yɨnk kai, hɨre wɨrɨak menmen im weses yɨnk mai me hi eno ekre herwe hei. ");
INSERT INTO avt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hi hetpi hɨm werek. Nerer wit wit kerek mɨt nanwepyapɨr hɨm mai nantɨp mɨtem, hɨr nantɨp menmen mɨte ip werekyewem te hɨr han kitetim han tewenɨnep.” ");
INSERT INTO avt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Me wɨ im keremem, mɨtɨk hak ke hɨr mɨt 12 disaipel niuk mɨrak Judas ke wit Iskeriot, hɨrak ken kɨr mɨt iuwe ne pris. ");
INSERT INTO avt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Te hɨrak katɨp, “Yi eiweto mekam te hi awepyapɨr Jisas asiuwerek aknen his mi?” Hɨrak ketpor epei au, hɨr newetɨwek 30 kina. ");
INSERT INTO avt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Me wɨ im, hɨrak han kitet wɨ meiyam te hɨrak kakwepyapɨr Jisas kakno his mɨr. ");
INSERT INTO avt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Me wɨ im mekrit minɨn te mɨt nererik nanɨm bret me wɨ Pasova me yis ap mekrerem au (mentar hɨr han tewenɨn nɨpaa God kenep mɨt ne Isip), hɨr mɨt disaipel nan nɨr Jisas netpɨwek, “Ti hanhan neinan te haiu mamɨmani menmen te haiu mamɨm me Pasova?” ");
INSERT INTO avt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jisas katɨp, “Yi eino wit iuwe Jerusalem te yi eino mɨtɨk hak kiutɨp te yi eiyɨtpɨwek, ‘Mɨtɨk Iuwe kaiu katɨp: Wɨ mai hi hahi epei man menep. Hi hahɨm menmen me pasova atike mɨt disaipel nai mamu wɨnak kit.’” ");
INSERT INTO avt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hɨrak katɨp epei au, mɨt disaipel nɨrɨakem nar ke Jisas epei ketpɨwekɨtem, te hɨrakɨt temani menmen me Pasova. ");
INSERT INTO avt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hɨnkewɨ Jisas kan kau yeno ketike mɨt disaipel nɨrak nar hiswiyen wik (12). ");
INSERT INTO avt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hɨr naam menmen nau, hɨrak katɨp, “Hi hetpi hɨm werek, mɨtɨk hak kiutɨp ke yi mɨt in en, hɨrak kakwepayapɨr kakriuweta hi ano his me mɨt enun.” ");
INSERT INTO avt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hɨrak katɨp epei au, hɨr han enuk te mɨtɨk kiutɨp mɨtɨk kiutɨp hɨr nitɨwekhi, “Kai Iuwe hi a?” ");
INSERT INTO avt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas katɨp, “Mɨtɨk ik ek kerek ketikewa waam menmen mekre tɨkenup im hɨrak kakwepayapɨr. ");
INSERT INTO avt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hi mɨtɨk ke wit ke Mɨtɨk Iuwe, hi ano hahi apar ke nɨpaa tɨwei me God epei matɨp ek. Te mɨtɨk ik kerek kakwepayapɨr hi mɨtɨk ke wit ke Mɨtɨk Iuwe hɨrak kakine han enuk kakɨwaank. Te miye pɨrak ap winaak au, hɨrak yaaik. Te hɨrak ap kakɨwaank hɨrekes kakriuwe menmen im.” ");
INSERT INTO avt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hɨrak katɨp epei au, Judas mɨtɨk kerek kakwepyapɨrek, hɨrak kitehi Jisas, “Mɨtɨk Iuwe kai, hi a?” Jisas ketpɨwek, “Ti hɨrekes kerek ek.” ");
INSERT INTO avt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hɨr wen naam menmen nanu en, Jisas kekin bret kitehi God katɨp hɨrak yaaik. Epei au, hɨrak kewepik kewet mɨt disaipel nɨrak em hɨr nanɨm, te hɨrak katɨp, “Yi yetɨwem yayɨm hɨram mamɨr ke yɨnk kai.” ");
INSERT INTO avt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hɨrak katɨp epei au, hɨrak kekin tɨpar wain mekre hesnu hak, te hɨrak kitehi God keriuwerem, te hɨrak kewetɨrem katɨp, “Yi yapɨrwe eiyɨm im em. ");
INSERT INTO avt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Im em hɨram hemkre mai mamwen te God kakises hɨm mɨrak te kakɨsak menmen enum me mɨt miyapɨr yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Hi hetpi werek. In ek ere maain hi ap te hahɨm tɨpar wain taau ere maain hi ektikewi mamɨm wain petep mamɨt wit ke Haai kai God.” ");
INSERT INTO avt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hɨr naam menmen epei au, hɨr nine henye ham. Epei au, hɨr nen witeik nen ere niu niun mɨniu (o neiyɨp) niuk mɨrak wit Oliv. ");
INSERT INTO avt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hɨr nɨpiun mɨniu (o neiyɨp niuk mɨrak) wit Oliv, Jisas ketpor, “Yi kerek yises hɨm mai yi yainaiwɨra me wɨtaan im em. Tɨwei me God matɨp, ‘Hi anep mɨtɨk kerek naanmɨpre sipsip em te hɨram emrɨr emɨnke asin asin o heriyai heriyai. ");
INSERT INTO avt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Hi hahi, te maain hi pɨke akrit hi ahinɨni ano provins Galili.” ");
INSERT INTO avt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ketpɨwek, “Hɨr yapɨrwe nanɨnaiwɨrit nanrɨr nanɨntar mɨt han nantuthis nanitep, te hi taauye! Hi ahu atikewit!” ");
INSERT INTO avt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas ketpɨwek, “Hi hetput hɨm im werek. Me wɨtaan im em Suware ap matɨp wen au, ti eraupakɨn wikak etɨp mɨt ti epratari hises hɨm mai au.” ");
INSERT INTO avt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita ketpɨwek, “Hi hahi atikewit, te hi ap aritpakɨn taau!” Hɨrak katɨp te mɨt disaipel yapɨrwe natɨp nepɨr kerekek. ");
INSERT INTO avt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hɨr natɨp epei au, Jisas ken ketikeri nen tɨ hak mɨt nenewek wit Getsemani. Hɨr niun en, hɨrak ketpor, “Yi eiyu in en, hi ano pɨnak ein ehitehi God menmen.” ");
INSERT INTO avt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hɨrak keithis Pita ketike nɨkerek wiketeret te Sebedi, Jems ketike Jon tariyakɨt ten. In ek, hɨrak han kɨrak enuk kekrit kekrit. ");
INSERT INTO avt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jisas ketpor, “Han kai enuk ere hi hahi. Yi eitikewa eiyu in han tewenɨna.” ");
INSERT INTO avt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Te hɨrak ken kike kenke kɨwaai tɨ kitehi God, “Haai kai, hɨram werek ti ehɨt menmen enum mamnen hɨram emnopɨn emkeipno. Hi ap ehises han kai au, emɨt! Hi ehises han kit.” ");
INSERT INTO avt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hɨrak kitehi God epei au, Jisas kan kɨr mɨtɨkɨt disaipel. Hɨrak kɨret tɨwaai. Hɨrak kekotɨtit katɨp Pita, “Yenmak te yi ap yayu yeitikewa mei kike han tewenɨna a? ");
INSERT INTO avt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yi naanmamre hɨras eiyitehi God kakɨkepi te menmen enum me mamri han ki mamnen mamriwaank. Yi han ki hanhan kises menmen me God te yɨnk ki au kɨnapen menmen enum.” ");
INSERT INTO avt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hɨrak ketpɨwekɨt epei au, Jisas pɨke ken keteipim kitehi God menmen katɨp, “Haai kai, te menmen enum im ap te mamnopɨn mamkeipno te hi ehises menmen im. Te ti ehises han kit kerekek.” ");
INSERT INTO avt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jisas pɨke kan kɨret tɨwaai teit. Hɨrakɨt nanamɨr mekses te hɨrakɨt tɨwaai. ");
INSERT INTO avt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jisas pɨke kɨnaiwɨret, hɨrak ken kitehi God wikak. Hɨrak kitehi God me menmen hɨrak epei kitɨwekhiyem. ");
INSERT INTO avt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Maain hɨrak pɨke kan kɨr mɨtɨkɨt disaipel tɨrak hɨrak kekotɨtet kitɨwekɨthi, “Yi wen yɨwaai a? Eiyɨmtau! Wɨ epei man te mɨtɨk kakwepyapɨr hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi ano his me mɨt enun nises menmen enum. ");
INSERT INTO avt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yi eiyɨkrit. Haiu emno. Yi eiyɨr mɨtɨk kerek kewepyayapɨr epei kan.” ");
INSERT INTO avt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas wen katɨp kerp, Judas mɨtɨk hak ke mɨt 12 disaipel nɨrak, hɨrak kan. Mɨt yapɨrwe netikerek nan netenen nu mɨr paap yoki metike hɨne me his. Hɨr mɨt iuwe ne pris netike mɨt iuwe ne kaunsil ne Isrel hɨr neriuweti nan. ");
INSERT INTO avt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mɨtɨk Judas kerek kakwepyapɨr ek nepei katɨp mɨt enun hɨm im: “Yi yaira hi heiyewewik emɨwek tekep mɨrak em, hɨrak kerekek mɨtɨk yi hanhan eitenenik. Yi eitɨwekhis.” ");
INSERT INTO avt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hɨrak kiun en, hɨrak kan Jisas wasenum katɨp, “Hi epei han Mɨtɨk Iuwe.” Te hɨrak kemɨwek tekep. ");
INSERT INTO avt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas ketpɨwek, “Kai yinak, menmen ti erekyewem em, ti erekyewem wasenum.” Te hɨr nan menep hɨr newis his netenenik. ");
INSERT INTO avt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hɨr netenɨnek, te mɨtɨk hak kiutɨp kerp ketike Jisas hɨrak keiyɨm kari hɨne ke his kɨrak, keiyɨk kenep mɨtɨk kɨrɨak menmen me mɨtɨk iuwe ke pris keremɨrɨwek nɨkɨp mɨrak mɨnatɨn. ");
INSERT INTO avt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Te Jisas ketpɨwek, “Ti pɨke ewis hɨne ke his ekɨkre nɨrak keriyen ekɨt! Mɨt yapɨrwe nenepan neriuwe hɨne me his te mɨt han nanɨnɨp nanriuwe hɨne me his mɨr hɨr nani. ");
INSERT INTO avt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ti ap hertei hi te enɨne haai kai God, Te wasenum hɨrak kakweto mɨt ensel yapɨrwe naninɨn 70,000 mɨt ne ami a? ");
INSERT INTO avt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Te hi erɨakem mamɨr im keremem, te hɨm me God mamnen mamɨrkeim a? Taauye! Tɨwei ke God katɨp menmen mamnen te hɨram mamnen mampar keremem.” ");
INSERT INTO avt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hɨrak katɨp Pita epei au, Jisas katɨp mɨt yapɨrwe keriyen, “Yi yan yaitauhis, yi yetenen hɨne metike nu mar ke yi yaitenen mɨtɨk enuk kekintɨp menmen enum yaisenkekik a? Wɨ yapɨrwe hi hau hekre wɨnak iuwe ke God hi hatɨp mɨt miyapɨr hɨm me God te yi ap yetenɨna au. ");
INSERT INTO avt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Menmen im epei man te hɨm me nɨpaa mɨt profet newisɨm mau tɨwei, hɨram mamnen.” Hɨrak katɨp epei au, te mɨt disaipel nɨrak nɨnaaiwɨr Jisas nɨrɨr nen. ");
INSERT INTO avt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hɨr mɨt netenen Jisas, te hɨr netɨwek his neiyɨk nen wɨnak ke mɨtɨk hak hetpris Kaiafas. Mɨt han ninɨn nertei hɨm lo me Moses hɨr netike mɨt iuwe ne kausil hɨr nererik nau neit en. ");
INSERT INTO avt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita kisesik ken, te hɨrak au keit yanɨmɨn. Hɨrak epei ken kekre nɨwa keweikɨn tɨ ke mɨtɨk hetpris wɨnak kɨrak kɨwaairiyen. Hɨrak kɨnɨk ken kau ketike mɨt naanmɨpre wit. Hɨrak hanhan kakɨr menmen mei mamnen. ");
INSERT INTO avt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hɨr mɨt iuwe ne pris netike mɨt iuwe ne kaunsil nɨnatɨn mɨtɨk keiyak te kakmitepɨn Jisas me menmen enum hɨrak kɨrɨakem te hɨr nankɨp kaki. ");
INSERT INTO avt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mɨt yapɨrwe nan newenɨwek hɨm netpɨwek enum. Te hɨr ap epei nɨnapɨn mekam enum hɨrak kɨrɨakem te hɨr nankɨp kaki. Maain mɨtɨkɨt wiketeret tan, ");
INSERT INTO avt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","te hɨrakɨt tatɨp, “Mɨtɨk ik nɨpaa katɨp hɨrak kakwep wɨnak iuwe ke God te pɨke kakimaak me wɨ wikak keremem.” ");
INSERT INTO avt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mɨtɨk iuwe ke pris kerp katɨp Jisas, “Ti ap ewenhi hatɨp hɨm mei au a? Tenmak te hɨrakɨt tewenut hɨm me menmen enum a?” ");
INSERT INTO avt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Te Jisas ap katɨp hɨm mei au. Te mɨtɨk iuwe hetpris ketpɨwek, “Hi hituthi hekrehɨr ke Mɨtɨk Iuwe God kerek kaku kakɨt tipmain tipmain enum eik, ti etpeiyem. Ti Mɨtɨk Iuwe Krais Nɨkan ke God o au?” ");
INSERT INTO avt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas ketpɨwek, “Ti hɨrekes kerekek epei hetpim. Te hi hetpi. In ek ere maain yi eiyɨr hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi ahu his yaaim me God Iuwe kerek mɨt iuwe newiyen. Maain hi ahu nepni pɨke anen in.” ");
INSERT INTO avt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas katɨp kar ik te mɨtɨk iuwe hetpris kewep laplap mɨrak keteikɨn mɨt God han enuk te hɨrak katɨp, “Hɨrak katɨp enum ketawɨn God kerekyɨwek yɨnk enuk. Haiu ap te emnɨne mɨt neiyan nanɨnen nanwepyapɨr hɨm ham nɨpaa hɨrak ketpim au emɨt! Hɨrak epei katɨp enum ketawɨn God. Yi epei yemtewem. ");
INSERT INTO avt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Te yi han kitet mekam?” Hɨr newenhi netpɨwek, “Hɨrak kɨrɨak menmen enum te hɨrak eki.” ");
INSERT INTO avt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hɨr natɨp epei au hɨr nenikɨn tɨmank men ninaan me Jisas hɨr nakɨp. Mɨt han newis laplap nɨsawɨn nanamɨr kɨrak nakɨp nesiuwek tekep, ");
INSERT INTO avt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hɨr nitɨwekhi natɨp, “Ti Mɨtɨk Iuwe, ti atɨp hɨm me profet in ek. Ti ewepyapɨr keimɨn kitep.” ");
INSERT INTO avt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita kau wit eik kekre nɨwa ke wɨnak. Te mɨte hap kerek wɨrɨak menmen em wan wɨrek watɨp, “Ti ik ek nɨpaa hau hetike Jisas ke provins Galili.” ");
INSERT INTO avt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Te Pita kiune katɨp kerp menep ninaan me mɨt yapɨrwe en, “Ti henmak te ti etpo menmen im? Hi hepɨtariyek.” ");
INSERT INTO avt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hɨrak ketpaan ken witeik kau wɨnak hɨnp ek. Te mɨte hap wɨrek hɨre watɨp mɨt miyapɨr yapɨrwe en kerek nerp menep en war ik: “Mɨtɨk ik ek nɨpaa kau ketike Jisas ke Nasaret.” ");
INSERT INTO avt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Te Pita kiune katɨp hɨm manp, “Hi hetpi hitehi God kehimɨtan hɨm mai mɨtɨk ik ek hi au hepɨtariyek.” ");
INSERT INTO avt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Maain kike, mɨt han nerp en nan natɨp Pita, “Hɨre watɨp werek. Ti mɨtɨk kiutɨp ke mɨt kerek nises Jisas. Teruk kit keweputyapɨr merp yaain ti mɨtɨk ke Galili.” ");
INSERT INTO avt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Te in ek Pita katɨp hɨm iuwe, “God kaknen kakiyep te hi ap hetpi werek. Hɨram werek te hi ap hertei mɨtɨk ek ek au.” Hɨrak katɨp epei au, suware katɨp. ");
INSERT INTO avt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Suware katɨp epei au, Pita han kitet hɨm kerek nɨpaa Jisas ketpim em kar ik: “Suware ap katɨp wen au, te ti hatɨp wikak ti ap herteiya.” Te Pita ken witeik hɨrak kɨkɨt wɨsenum kentar hɨrak yɨnk enuk hɨrak katɨp hɨrak kepɨtari Jisas. ");
INSERT INTO avt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Epei wanewik, mɨt iuwe ne pris netike mɨt iuwe ne kaunsil ne mɨt miyapɨr ne Isrel hɨr nimenɨpɨn natɨp te nanɨnep Jisas kaki. ");
INSERT INTO avt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Te hɨr nesenkekik keriuwe waai neiyɨk nan nanwet mɨtɨk iuwe gavman ke Rom Pailat ek. ");
INSERT INTO avt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Maain Judas kerek kewepyapɨrek, hɨrak kertei mɨt iuwe neiyɨk nen newet Gavman ek, hɨrak yɨnk enuk keriuwe menmen hɨrak kɨrɨakem te hɨrak pɨke ken kewet mɨt iuwe pris netike mɨt iuwe ne kaunsil 30 pewek me silva im. ");
INSERT INTO avt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hɨrak kewetɨrem, hɨrak katɨp, “Hi epei hises menmen enum hi hewepyapɨr mɨtɨk ap kɨrɨak enum au yaaik, te hɨrak kaki.” Te hɨr natɨp, “Hɨram ap menmen maiu au. Hɨram menmen mit ti hɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Te mɨtɨk Judas kewɨr 30 pewek silva im men mɨwaai wɨnak iuwe ke God eik, te hɨrak kɨnaiwɨri ken keit waai keiyɨk kɨkɨaip hɨrekes kau teruk hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hɨr mɨt iuwe ne pris nekin pewek im keremem, hɨr natɨp, “Im em hɨram pewek me mamnep mɨtɨk kaki. Haiu ap emwisɨm emtike pewek me wɨnak iuwe ke God au emɨt!” ");
INSERT INTO avt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Te hɨr natɨp nitet han kiutɨp me pewek keremem. Hɨr neiyɨm natɨn tɨ ke mɨtɨk kerek kime mɨn kewiyen. Hɨr neit tɨ keremem nehimɨtanek me hɨr nanwis herwe mɨwaairi en me mɨt ne yanɨmɨn kerek nan nanɨr Jerusalem. ");
INSERT INTO avt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mar keremem te in hɨr newep niuk me tɨ kerek nenewek ‘Tɨ hemkre kerekek.’ ");
INSERT INTO avt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mar im hɨm ham nɨpaa God ketpim mɨtɨk profet Jeremaia kewisɨm mau tɨwei epei man. Hɨram matɨp, “Hɨr neit 30 pewek me silva, hɨr Isrel nɨpaa nehimɨtanem natɨp pewek me nanɨthis mɨtɨk ik ek. ");
INSERT INTO avt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mɨt pris nesiuwe pewek me silva im hɨr neiyɨm natɨn tɨ ke mɨt newi nime mɨn mar ke nɨpaa kai iuwe God ketpowem.” ");
INSERT INTO avt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hɨr newis Jisas kerp ninaan me mɨtɨk iuwe gavman ke Rom. Te mɨtɨk iuwe gavman kitɨwekhi, “Ti Mɨtɨk Iuwe King kɨr ke Isrel?” Te Jisas katɨp, “Ti hɨrekes hatɨp har kerekek.” ");
INSERT INTO avt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hɨr mɨt iuwe ne pris netike mɨt iuwe ne kaunsil ne Isrel newenɨwek hɨm natɨp hɨrak kɨrɨak menmen enum. Hɨrak ap kɨrɨak menmen im enum au te hɨrak ap pɨke katɨp hɨm mei kike au. Hɨrak kekintɨp wɨre wɨre kau keit. ");
INSERT INTO avt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mar keremem te Pailat ketpɨwek, “Ti ap hertei hɨm yapɨrwe kerek hɨr netputem em a?” ");
INSERT INTO avt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Te Jisas ap kewenhi katɨp hɨm mei miutɨp men pailat au. Mar keremem te mɨtɨk iuwe gavman ke Rom han kitetim. ");
INSERT INTO avt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wɨ yapɨrwe me tito miutɨp miutɨp mɨtɨk iuwe gavman kesiupan mɨtɨk kekre wɨnak enuk ken. Mɨtɨk kerekek kaksiuwerek kakno witeik. ");
INSERT INTO avt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Me wɨ im mɨtɨk hak enuk kau en keit wɨnak enuk niuk mɨrak Barabas. ");
INSERT INTO avt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hɨr mɨt miyapɨr nererik nau in ek, te Pailat kitorhi ketpor, “Yi hanhan hi asiupan keimɨn ekno his mi? Hi esɨwi Barabas o Jisas hɨr nenewek Krais a?” ");
INSERT INTO avt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hɨrak Pailat kertei hɨr mɨt iuwe ne pris netike mɨt iuwe ne kaunsil hɨr hemkre menepam han enuk neriuwe Jisas nentar mɨt miyapɨr hanhanek, te hɨr newepyapɨrek nar kerekek kerp ninaan mɨrak kakɨkɨp kaki. ");
INSERT INTO avt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat kau yeno me mɨtɨk masistret kerek hɨrak skelim mɨt nerp ninaan mɨrak em, te mɨte pɨrak wesiuwek hɨm mau tɨwei watɨp, “Ti ap erɨak menmeiyam me mɨtɨk eik kerekek. Hɨrak ap kɨrɨak menmei enum au. Wɨtaan hi hɨtyak hɨrek te hi hɨwaai enum henterik.” ");
INSERT INTO avt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hɨr mɨt iuwe ne pris netike mɨt iuwe ne Isrel nari han ke mɨt miyapɨr te hɨr enɨnap entɨp Pailat kaksiupan Barabas, te hɨr enɨnep Jisas kaki. ");
INSERT INTO avt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Te mɨtɨk iuwe gavman pɨke kitorhi ketpor keteipim, “Mɨtɨkɨt it et yi hanhan hi enaairwɨr keimɨn ekno yi mɨt?” Hɨr natɨp, “Barabas.” ");
INSERT INTO avt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat kitorhi kar ik: “Te hi hɨrɨak Jisas mekam, kerek mɨt nenewek Krais?” Te hɨr yapɨrwe natɨp, “Yi eiwenkekik eku nu tentarakɨt.” ");
INSERT INTO avt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat kitorhi katɨp, “Hɨrak kenmak? Hɨrak kɨrɨak mekam enum a?” Te hɨr au nɨnap nenɨne hɨm iuwe, “Eiwenkekik eku nu tentarakɨt.” ");
INSERT INTO avt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mɨtɨk Pailat kertei in ek hɨrak kakɨtpim au, te mɨt en nesikeyaanmi nanɨnepan nanɨriuwerek. Te hɨrak kekin tɨpar keiyɨm kekemeyet his mɨrak keit ninaan me mɨt miyapɨr yapɨrwe keteiknor hɨrak kɨnapen kakɨkɨp. Te hɨrak katɨp, “Hi ap hertei mekam enum hɨrak kɨrɨakem, te hi anep mɨtɨk ik kaki. Hɨram menmen mi keremem.” ");
INSERT INTO avt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te mɨt miyapɨr newenhi netpɨwek, “Ti akɨp kaki. Hɨram ap menmen mit te God han enuk kakriuwit. Maain hɨrak han enuk kakriuwai haiu mɨte metike nɨkerek naiu.” ");
INSERT INTO avt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hɨr natɨp menmen im nepei au, te Pailat kesiupan Barabas ken his mɨr. Te hɨrak katɨp mɨt nɨrak nɨwaai nɨpɨn nenep Jisas te hɨrak kesiuwerek ken his me mɨt ne ami te hɨr enwenkekik eku nu tentarakɨt. ");
INSERT INTO avt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailat kesiuwe Jisas ken his me mɨt ne ami ne gavman, hɨr neithis Jisas neiyɨk nen wɨnak ke gavman, te hɨr mɨt soldia keriyen nan nererik hɨr yapɨrwe neweiknɨwek en. ");
INSERT INTO avt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Te hɨr nenemtɨn laplap mɨrak, te hɨr nemrɨwek laplap ham mɨre ninɨm. ");
INSERT INTO avt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hɨr nime waai wiwɨr tɨktɨk mewik ek kɨre teperiye, te hɨr nankiunɨwek kaku paan. Te hɨr newetɨwek niyen nun kɨrak ketenenik ken his yaaim mɨrak nemitetpɨn natɨp hɨrak mɨtɨk iuwe. Te hɨr newen ninɨp menep hɨt mɨrak netpɨwek enum nitɨtɨweknaan natɨp, “Ti yaaik Mɨtɨk Iuwe King ke mɨt ne Isrel.” ");
INSERT INTO avt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Te hɨr nenikɨn tɨmank menterik, hɨr nekin niyɨn kerekek neiyɨk nenep paan kɨrak yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hɨr netpɨwek nitetɨweknaan enum epei werek, te hɨr nenke laplap mekeipnɨwek. Te hɨr pɨke nemirɨwek laplap mɨrak hɨrekes, te hɨr netɨwek his neiyɨk nen nanwenkekik kaku nu tentarakɨt. ");
INSERT INTO avt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hɨr nitet yayiwe nen, te hɨr nɨr mɨtɨk ke Sairini niuk mɨrak Saimon. Te hɨr natɨp hɨm iuwe hɨrak nenipek kaknan nu tentarakɨt ke Jisas kakɨkepik. ");
INSERT INTO avt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hɨr nan niun wit hak niuk mɨrak Golgota kerek haiu meweikɨn hɨm haiu menewek ‘Wit Paan Hesnu.’ ");
INSERT INTO avt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hɨr nɨpiun ein hɨr newet Jisas tɨpar wain epei neweiknɨm metike marasin enum me wekwai te hɨrak kakɨm. Hɨrak kɨnɨnem, te ap kaam au kɨnapen. ");
INSERT INTO avt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hɨr epei newenkekik kau nu tentarakɨt, hɨr neretɨt satu me nein nanɨt saket mɨrak me hɨr hɨras. ");
INSERT INTO avt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hɨr neretɨt satu epei au, hɨr nau tɨ naanmɨprewek. ");
INSERT INTO avt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mau niu merp paan kɨrak hɨr newis hɨm im em kerek nɨpaa hɨr nenkerek kerp ninaan me mɨtɨk iuwe em. Hɨr newisɨm mar im: IK EK HƗRAK JISAS MƗTƗK IUWE KING KE MƗT MIYAPƗR NE ISREL. ");
INSERT INTO avt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Menep Jisas hɨr newenkek mɨtɨkɨt wiketeret enukɨt raskel tekintɨp menmen. Hɨr newenkek hak kau his yaaim, hak kau ken his henkik. ");
INSERT INTO avt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hɨr nepu en, hɨr mɨt miyapɨr nan nen hɨr netpɨwek enum neweiknɨwek nenwesɨsek, hɨr netpɨwek nar ik: ");
INSERT INTO avt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ti mɨtɨk kerek ewep wɨnak tempel iuwe ke God ek te ti pɨke eimaak me wɨ wikak keremem, ti ekaap hɨrekes! Ti atɨp ti Nɨkan ke God te ti enaaiwɨr nu tentarakɨt te ti enatɨn enen tɨ.” ");
INSERT INTO avt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mar im hɨr mɨt iuwe ne pris netike mɨt ninɨn nertei hɨm lo me Moses netike mɨt iuwe ne Isrel hɨr netpɨwek enum nitetɨweknaan. Hɨr natɨp, ");
INSERT INTO avt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Hɨrak nɨpaa kɨkaap mɨt han, te hɨrak ap kɨkaap hɨrekes. Hɨrak mɨtɨk iuwe ke Isrel a? Hɨrak eknaaiwɨr nu tentarakɨt te haiu emises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hɨrak katɨp, ‘Hi hises hɨm me God hi Nɨkan ke God.’ Te God hanhan keriuwerek te ekɨkepik in ek.” ");
INSERT INTO avt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mar im mɨtɨkɨt wiketeret kerek enukɨt raskel kerek tekintɨp menmen em newenkekikɨt tau nu tentarakɨt tetike Jisas tau menep hɨrakɨt tatɨp Jisas enum. ");
INSERT INTO avt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wepni kau nɨmɨn, wɨtaan toto man mɨwapɨn tɨ eik ek ere hɨnkewɨ. ");
INSERT INTO avt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Menep hɨnkewɨ, Jisas kɨnap kenɨne hɨm iuwe kar ik: “Eli, Eli, lema Sabaktani?” Hɨram hɨm Hibru mar im em: “Haai kai, Haai kai God, henmak te ti nepei heweikɨn sip eweto hɨnairwɨra?” ");
INSERT INTO avt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te mɨt han nerp menep hɨr nemtewek te hɨr ap nerteiyek werek au, te hɨr natɨp, “Mɨtɨk ik ek hɨrak kenɨne Ilaija.” ");
INSERT INTO avt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wasenum mɨtɨk hak kesiukɨn ken keit mosong o nɨk me wan eik, te hɨrak kewisɨm mekre wain epei mesine, hɨrak kewisɨm mau niyen nun kesiuwe Jisas em ekɨm. ");
INSERT INTO avt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Te mɨt han natɨp, “Ti ewetɨwekem wen au emɨt! Haiu mamɨr te hɨrak Ilaija kaknen kakɨkepik o au!” ");
INSERT INTO avt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas pɨke kɨnap kenɨne hisiuwe te hɨrak keriuwet hɨmɨn kɨrak ken kekeipnɨwek, hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hɨrak kaa, te laplap iuwe mau wɨnak iuwe ke God (tempel) ek mewep pɨnam pɨnam mau niu ein en ere miun tɨ eik, mɨre wiketerem. Te God keteikɨn mɨt Jisas kewep yayiwe keriuwe yɨnk kɨrak te mɨt nanitɨwekhi menmen. Tɨ kɨtanɨk nan iuwe mewep, ");
INSERT INTO avt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","te herwe hei mɨkaisiu te mɨt miyapɨr yapɨrwe kerek nises God nɨpaa epei naa, in ek hɨr pɨke nekrit. ");
INSERT INTO avt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hɨr nɨnaaiwɨr herwe hei maain, Jisas pɨke kekrit epei au, te hɨr nen wit yaaik iuwe Jerusalem. Te mɨt yapɨrwe hɨr nɨri. ");
INSERT INTO avt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mɨtɨk iuwe ke ami ketike mɨt nɨrak nau netikerek nau naanmɨpre Jisas hɨr nɨr tɨ kɨtanɨk, te hɨr nɨr menmen yapɨrwe man, hɨr nɨnapen wɨsenum hɨr natɨp, “Hɨram werek. Mɨtɨk ik ek hɨrak Nɨkan ke God.” ");
INSERT INTO avt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Miyapɨr yapɨrwe nepu, hɨr nɨpaa nises Jisas nɨnaaiwɨr provins Galili nan nankepik neriuwe menmen. Hɨr miyapɨr keriyen nerp yanɨmɨn kike hɨr nɨrek. ");
INSERT INTO avt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mɨte hap pe hɨr miyapɨr en hɨre Maria pe Magdala. Hap ep hɨre Maria, miye pe Jems wetike Josep. Hɨre wetike Miye pe nɨkerek wiketeret te Sebedi, Jems ketike Jon. ");
INSERT INTO avt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Maain hɨnkewɨ, mɨtɨk hak kiutɨp ketenen nan yapɨrwe ke wit Arimatia, kerek niuk mɨrak Josep, hɨrak kan wit kerek Jisas kaa. Hɨrak nɨpaa kɨre mɨtɨk disaipel ke Jisas kises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hɨrak ken kɨr pailat te hɨrak kitɨwekhi hɨrak kakɨt herwe yɨnk ke Jisas. Te Pailat katɨp mɨt nɨrak hɨr newetɨwek Jisas yɨnk kɨrak. ");
INSERT INTO avt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep hɨrak keit Jisas yɨnk kɨrak kesenkekik keriuwe laplap yaaim me hike. ");
INSERT INTO avt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Hɨrak kesenkekik keriuwe laplap me hike, hɨrak kewisɨk kekre han kerek mɨt epei nekupɨn hei mɨnɨk nan me Josep. Hɨrak kewisɨk kekre han nepei au, hɨrak katɨp mɨt hɨr neweiknen nan wɨsenuk kɨwapɨn hɨm kɨrak. Hɨr newisɨk kɨwapɨn hɨm ke hei epei au, hɨr nen. ");
INSERT INTO avt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mɨt nɨrɨak menmen im, Maria pe Magdala wetike Maria hap, hɨr nau tɨ neit en menep hei. ");
INSERT INTO avt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Teipmen, wɨ kerek mises wɨ mɨt nemani menmen me Pasova, mɨt iuwe ne pris netike mɨt ne Farisi hɨr nen nanɨr Pailat. ");
INSERT INTO avt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Hɨr nen nanɨr Pailat hɨr nitɨwekhi netpɨwek nar ik: “Mɨtɨk iuwe, haiu mɨt han kitet hɨm ham im nɨpaa mɨtɨk enuk kewenɨn hɨm hɨrak ketpim. Hɨrak katɨp, ‘Wɨ wikak epei au, hi pɨke ekrit ehu.’ ");
INSERT INTO avt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Te haiu hanhan ti atɨp mɨt han nit hɨr naanmamre hɨm ke hei kerek Jisas yɨnk mɨrak mɨwaai mekrerek, me wɨ wikak. Te mɨt nɨrak disaipel hɨr ap nanɨnen nanri yɨnk kɨrak nantɨp mɨt hɨrak epei kekrit. Hɨr nanrɨak menmen im, te hɨram minɨn hɨm enum nɨpaa hɨrak ketpim me hɨrak Mɨtɨk kerek God kehimɨtanek kaknen kakɨkaap mɨt.” ");
INSERT INTO avt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat kewenhi ketpor kar ik, “Yi eiyɨt his mɨt han ne ami eino naanmamre hei ik werek werek kerek yi yerteiyem.” ");
INSERT INTO avt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hɨrak katɨp epei au, hɨr nen newis waai neriuwesɨs hei. Nepei au, hɨr newis mɨt han ne ami hɨr nerp en naanmɨre herwe hei im. ");
INSERT INTO avt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Maain wɨ Sabat epei au, menep kakre wanewik me wɨ Sande, Maria pe wit Magdala wetike Maria hap hɨr nen nanɨr hei kerek mɨt newis Jisas kekrerek. ");
INSERT INTO avt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hɨr nen nanɨr hei waswas tɨ kɨtanɨk kentar ensel ke Mɨtɨk Iuwe God kɨnaaiwɨr wit kɨrak kekiuwe kan tɨ keweikɨn nan kenkerek kerek kɨwapɨn hɨm ke hei. Hɨrak keweikɨn nan kenkerek epei au, hɨrak kau kenterik. ");
INSERT INTO avt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ninaan mɨrak merhɨhe mɨre nepni mewenɨn, klos mɨrak hɨram mɨre hike mar ke surp wepni yaaik hɨrak kewep. ");
INSERT INTO avt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ensel hɨrak kau kenterik, mɨt han ne ami kerek naanmɨpre hei ke herwe kekrerek, hɨr nɨrek hɨr nepɨrpɨr wɨsenum nenkewɨn nɨwaai tɨ nar ke herwe epei maa. ");
INSERT INTO avt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Te ensel katɨp miyapɨr wik kar ik: “Yi ap einapen au emɨt! Hi hertei yi yɨnyatɨn Jisas kerek mɨt newenkekik kau nu tentarakɨt hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hɨrak ap kaa kɨwaai in au. Hɨrak epei kekrit kar ke nɨpaa hɨrak ketpim. Yi einen in eiyɨr wit kerek nɨpaa hɨr newisɨk hɨrak kɨwaairi. ");
INSERT INTO avt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","In ek yi eino waswas eitɨp mɨt nɨrak disaipel hɨrak nepei kekrit kinɨni kakno provins Galili. Yi eino en te yi eiyɨrek ekɨt en. In ek hi nepei hetpi hɨm mai,” ");
INSERT INTO avt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hɨrak ketpor epei au, miyapɨr in nɨnaaiwɨr hei ik nepɨrpɨr hɨr han yaaik nesiuknen nen nantɨp mɨt nɨrak disaipel. ");
INSERT INTO avt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hɨr wen nesiuknen nitet yayiwe, Jisas kewenyipɨri kewisɨk yayiwe hɨrak ketpor, “Yi nepei yan?” Hɨrak ketpor nepei au, hɨr nan menep neiyewo hɨt mɨrak newenɨpiyek. ");
INSERT INTO avt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hɨr neiyewewik epei au, hɨrak ketpor kar ik: “Yi ap einapen au emɨt! Yi eino eitɨp nai yinan hɨr enɨno provins Galili, te hɨr nanɨra nanɨt en.” ");
INSERT INTO avt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Miyapɨr wen nitet yayiwe nepno, mɨt han ne ami kerek naanmɨpre herwe hei, hɨr nen wit Jerusalem natɨp mɨt iuwe ne pris menmen epei man. ");
INSERT INTO avt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Hɨr netpor epei au, mɨt iuwe ne pris netike mɨt iuwe ne kaunsil hɨr nimenɨpɨn natɨp. Epei au, hɨr newet mɨt ne ami pewek nari han kɨr neriuwerem netpor nar ik: “Mɨt han nanɨnen nanitihi me Jisas herwe yɨnk kɨrak yi eimitorpɨn eiyɨtpor wɨ nɨmɨn yi yɨwaai, mɨt disaipel nan nekin yɨnk kɨrak neiyɨk nen. ");
INSERT INTO avt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Maain hɨm im mamno mɨtɨk iuwe gavman te hɨrak kerteiyem, haiu mamno mamɨtpɨwek te hɨrak ap han enuk au, te hɨrak ap kakrekyi enum kakɨnterim.” ");
INSERT INTO avt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hɨr netpor epei au, mɨt ne ami nen nises hɨm mɨr natɨp mɨt yapɨrwe hɨm im. Te nɨpaa ein ere in mɨt yapɨrwe ne Isrel hɨr han kitet hɨm im. ");
INSERT INTO avt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Miyapɨr wik nen natɨp disaipel nar hiswiyen kiutɨp (11) menmen Jisas ketpor epei au, hɨr nitet yayiwe ke Galili kerek Jisas ketpor hɨr enɨno enɨrek. ");
INSERT INTO avt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hɨr nen ein nɨr Jisas, hɨr newenɨpiyek. Te mɨt han ap han kitet hɨrak Jisas hɨrekes au. Hɨr han kitet hɨrak herwe kerekek. ");
INSERT INTO avt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hɨr newenɨpiyek, hɨrak kan menep ketpor menmen. Hɨrak katɨp kar ik: “God epei keweto menmen mɨrak iuwe te hi hinɨn naanmamre menmen yapɨrwe meit wit kɨrak ketike menmen yapɨrwe me tɨ metike nepni. ");
INSERT INTO avt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Te yi eino eirer wit wit eiri han ke mɨt miyapɨr yapɨrwe hɨr enises hɨm mai. Yi eikɨri enriuwe tɨpar me niuk me God Haai, hi God Nɨkan wetike God Hɨmɨn Yaaik. ");
INSERT INTO avt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yi eiteiknor hɨr enises hɨm yapɨrwe hi nepei hetpiyem. Yi eiyɨmtau. Wɨ im ere wɨ maain God kakɨwaank tɨ im mamɨt, hekrit hekrit hi ahu atikewi.” ");
INSERT INTO avt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hɨm im hɨram hɨm yaaim me Jisas Krais God Nɨkan kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nɨpaa Aisaia kewepyapɨr hɨm me God hɨrak kewisɨm mau tɨwei hɨram matɨp mar im: “God katɨp mɨtɨk hɨrak kehimɨtanek kar ik: ‘Hi ariuwet mɨtɨk kai kaktɨp hɨm mai kakinɨnit kakno kaknetɨt yayiwe.’ ");
INSERT INTO avt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mɨtɨk hak keit wit weinɨk mɨt ap newik hɨrak kɨnap katɨp hisiuwe kar ik: ‘Yi eirɨak yayiwe yaaim me Mɨtɨk Iuwe te hɨrak kakisesim werek.” ’ ");
INSERT INTO avt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hɨrak mɨtɨk niuk mɨrak Jon. Hɨrak kɨkɨr mɨt neriuwe tɨpar. Hɨrak kan kepu yaank weinɨk kewepyapɨr hɨm me God katɨp kar ik: “Yi kerek yi eiweikɨn sip eiwet menmen enum, yi einen in hi akɨri te God kakɨsak menmen enum yi yɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hɨr mɨt nerer wit wit ne provins Judia, hɨr netike mɨt yapɨrwe ne wit Jerusalem hɨr nan nɨrek. Hɨr newepyapɨr menmen enum hɨr nɨrɨakem, te Jon kɨkɨri nekre mani Jodan. ");
INSERT INTO avt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kamɨr tepnek me kamel mɨt nɨrɨakem mar ke laplap, hɨrak kamɨr yɨnk ke kamel kɨre henpen kau tu. Hɨrak kaam weise metike manu nɨkim meit yaank. ");
INSERT INTO avt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hɨrak katɨp mɨt miyapɨr hɨm kar ik: “Maain mɨtɨk hak kakɨkrehɨr kai. Hɨrak Mɨtɨk Iuwe kinɨna. Hi ap Mɨtɨk Iuwe har ke hɨrak au. ");
INSERT INTO avt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Hi epei hɨkɨri yekre tɨpar, te maain hɨrak kakwis God Hɨmɨn Yaaik kakɨkre han ki.” ");
INSERT INTO avt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Me wɨ im Jisas kɨnaaiwɨr wit Nasaret keit provins Galili hɨrak kan kiun mani Jodan. Hɨrak kan kiun mani Jodan, Jon kɨkɨrek keriuwe tɨpar. ");
INSERT INTO avt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hɨrak kɨnaaiwɨr tɨpar kehɨn kɨniu ken tenhaan eik, Jon kɨr nepni hɨremes mewep mɨre weipɨr, God Hɨmɨn Yaaik kɨre hore tapɨ kekiuwe kan kewik. ");
INSERT INTO avt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te Mɨtɨk Iuwe keit God katɨp hɨm hɨram meke nepni man matɨp mar im: “Ti Nɨkan kai hi hanhanit. Hi han yaaik heriuwit.” ");
INSERT INTO avt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wasenum, God Hɨmɨn Yaaik keriuwet Jisas hɨrak ken yaank weinɨk. ");
INSERT INTO avt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hɨrak kepu ein me wɨ 40, te Seten kari han kɨrak. Jisas ketike miyak me yaank nepu ein. Mɨt ensel ne wit ke God hɨr nan nekepik. ");
INSERT INTO avt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Maain mɨt han newis Jon kekre wɨnak enuk ke gavman. Me wɨ im Jisas kan provins Galili katɨp mɨt miyapɨr hɨm me God. ");
INSERT INTO avt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hɨrak katɨp kar ik: “Wɨ epei man menep te God kakinɨn naanmampri yi mɨt miyapɨr ne tɨ. Yi eiweikɨn sip eiwet menmen enum yi eiyɨmtau hɨm me God eiyisesim.” ");
INSERT INTO avt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas keke tɨ kesiurɨr wan ken pɨn, hɨrak kɨr Saimon ketike nɨkik kɨrak Andru. Hɨrakɨt tewɨr hepin iuwe men mekre wan. Hekrit hekrit hɨrakɨt tari saauk. ");
INSERT INTO avt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas ketpɨwekɨt kar ik: “Yi eitikewa haiu mamno, hi eteikni menmen te yi eiri han ke mɨt hɨr nanises hɨm mai.” ");
INSERT INTO avt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wasenum hɨrakɨt tɨnaaiwɨr hepin mɨrakɨt, hɨrakɨt tisesik. ");
INSERT INTO avt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisas ken kike, hɨrak kɨr Jems ketike nɨkik kɨrak Jon, hɨrakɨt nɨkerek hɨrakɨt wik te mɨtɨk niuk mɨrak Sebedi. Hɨrakɨt tau bot kɨrakit tekerwo hepin mɨrakɨt. ");
INSERT INTO avt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hɨrak kenɨnewekɨt, te hɨrakɨt tɨnaaiwɨr haai kɨrakɨt hɨrak kau kekre bot ketike mɨt han kerek hɨr nekepik nekerwo hepin, hɨrakɨt ten tises Jisas. ");
INSERT INTO avt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hɨrakɨt tisesik, te hɨr nen niun wit Kapaneam. Hɨr nepu wit Kapaneam, maain wɨ Sabat epei man, hɨrak Jisas ken wɨnak kerek mɨt nererik nekine hɨm me Moses neitai, hɨrak katɨp mɨt miyapɨr hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hɨr nemtau hɨm mɨrak, te hɨr han kekrit neriuwe menmen hɨrak ketpim. Hɨrak ap ketpor kar ke mɨt kerek ninɨn nertei hɨm me Moses netpim. Au, hɨrak katɨp kar ke Mɨtɨk Iuwe Krais kerek God keriuwetek kan kekepi kerekek. ");
INSERT INTO avt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Me wɨ im, mɨtɨk enuk herwe kau kekrerek hɨrak kepu wɨnak ik. ");
INSERT INTO avt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Hɨrak kɨnap katɨp kar ik: “Jisas ke wit Nasaret, ti han herekyei mekam a? Ti han te hewep a? Hi herteiyit. Ti Mɨtɨk Yaaik Iuwe ke God.” ");
INSERT INTO avt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Te Jisas kenerek ketpɨwek kar ik: “Herwe enuk ti ekintɨp wɨre wɨre ti enepɨn ekeipɨn mɨtɨk ik etpaan eno.” ");
INSERT INTO avt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jisas katɨp kar ik, herwe enuk ketenenik te hɨrak keperper kenepɨp him iuwe, herwe ketpaan kenpɨn kekeipnɨwek. ");
INSERT INTO avt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mɨt miyapɨr nɨr menmen im hɨr nepɨrpɨr nitehiyan nar ik: “Mekak ik. Hɨrak ketpai hɨm ham yaaim. Hɨrak kɨre Mɨtɨk Iuwe hɨrak katɨp herwe enun hɨr nemtau hɨm mɨrak hɨr nisesim.” ");
INSERT INTO avt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Te waswas hɨr mɨt miyapɨr natɨpan menmen Jisas kɨrɨakem te mɨt nerer wit wit neit provins Galili hɨr nertei Jisas. ");
INSERT INTO avt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas kɨnaaiwɨr wɨnak eik e, hɨrak ketike mɨt nɨrak nen wɨnak ke Saimon ketike Andru. Jems ketike Jon hɨrakɨt ten tetikeri. ");
INSERT INTO avt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon maam pɨrak (miye pe mɨte pɨrak) hɨre wɨnap wɨwaai yeno hɨre yɨnk sisi. Hɨr natɨp Jisas hɨre wɨnap. ");
INSERT INTO avt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Te Jisas ken kɨrep ketenen his mɨre kɨka hɨre wekrit werp, hɨrak ketpɨwe kar ik: “Ti hɨnap epei au.” Te yɨnk sisi epei au, hɨre yaaip. Hɨre yaaip te hɨre wemani menmen hɨr nanɨm. ");
INSERT INTO avt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Maain wepni kewen ken, hɨr mɨt nerer wit wit neriyei mɨt miyapɨr hɨr nɨnap, hɨr netike mɨt miyapɨr han kerek herwe mekreri, hɨr neriyei nen nɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mɨt miyapɨr yapɨrwe ne wit iuwe ik nen nererik nau menep weipɨr ke wɨnak. ");
INSERT INTO avt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisas kɨkaap mɨt miyapɨr kerek hɨr nɨnap te hɨr pɨke yaain. Mɨt han hɨrak kepɨr herwe enum menpɨn mekeipnor. Hɨrak katɨp herwe hɨr ap enwepyapɨrek hɨrak keimɨn au emɨt! Hɨr nerteiyek hɨrak Nɨkan ke God. ");
INSERT INTO avt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hekrit enum eik hɨrak kekrit ketpaan ken yaank weinɨk kitehi God, te hɨrak ketikerek tewepnak. ");
INSERT INTO avt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Maain, Saimon ketike mɨt han nepu netikerek, hɨr nen nisesik. ");
INSERT INTO avt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hɨr nen nɨnapɨnek hɨr netpɨwek nar ik: “Mɨt miyapɨr yapɨrwe hɨr nan nɨnetnut.” ");
INSERT INTO avt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hɨrak ketpor kar ik: “Emɨt! Haiu wen emno wit ham menep te hi hatɨp mɨt miyapɨr hɨm mai heitai en.” ");
INSERT INTO avt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Te hɨrak ken heriyai heriyai me provins Galili, hɨrak katɨp mɨt miyapɨr hɨm mɨrak keit wɨnak kerek mɨt nererik nekine hɨm me Moses neitei. Hɨrak kepɨr herwe enum mau mekre mɨt miyapɨr hɨram menpɨn mekeipnor. ");
INSERT INTO avt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mɨtɨk enuk lepro mewik hɨrak kan kewen ninɨp kitehi Jisas kar ik: “Mɨtɨk Iuwe, ti hanhan eriuwa te ti ekepa hi are yaaik.” ");
INSERT INTO avt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas hɨrak hanhanek te hɨrak kewis his menterik ketpɨwek kar ik: “Hi hanhan ti are yaaik.” ");
INSERT INTO avt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hɨrak katɨp epei au, in ek lepro menke menpɨn mekeipnɨwek hɨrak kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisas ketpɨwek hɨm manp te hɨrak keriuwetek ken wasenum. ");
INSERT INTO avt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jisas ketpɨwek kar ik: “Ti emtewem. Ti ap etɨp mɨtɨk hak menmen im. Au, ti eno eteikɨn mɨtɨk pris yɨnk kit. Te ti ewetɨwek menmen nɨpaa Moses ketpai haiu mamwet God em, te mɨt hɨr nanɨrtei ti pɨke ere yaaik.” ");
INSERT INTO avt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Te mɨtɨk ik kemtau hɨm me Jisas au. Hɨrak kewepyapɨrem heriyai heriyai, te maain Jisas ap kakno kakitet witeik au. Hɨrak kɨrɨakem te mɨt nanɨrek hɨr han yaaik nanɨrp nanweiknɨwek. Te hɨrak kerp pɨn eik, mɨt nerer wit wit hɨr nan nanɨrek. ");
INSERT INTO avt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Maain wɨ ham, hɨrak pɨke kan wit Kapaneam. Mɨt en nertei hɨrak pɨke kan kepu wɨnak kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hɨr nertei hɨrak kepu, te hɨr yapɨrwe nen nererik ere wɨnak kenempet keriuweri. Mɨt han nerp ya weipɨr menep hɨr nemtau Jisas ketpor hɨm me God. ");
INSERT INTO avt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hɨrak wen ketpor hɨm, mɨtɨkɨt tekyaait ten tekerɨr mɨtɨk kɨwaai kentar kɨnaan. Hɨrak his hɨt maa tupe tupe meit. Hɨrakɨt tan tatɨr Jisas tewep mɨt yapɨrwe nerp neiyepet weipɨr, te hɨrakɨt ap tatno nɨmɨn taau. Te hɨrakɨt tehɨn tɨniu leta me wɨnak pɨnak ein. ");
INSERT INTO avt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hɨrakɨt tehɨn tɨniu wɨnak ten niu ein, hɨrakɨt tenke toni kɨwapɨn wɨnak siup kerek Jisas hɨrak kerp ketɨn ni en. (Mɨt ne Juda hɨr newis toni kɨwapɨn wɨnak siup. Nɨpɨn au. Wit hɨrak tenhaan weinɨk, hɨr niu auri.) Hɨrakɨt tenke toni ere kɨhi wɨsenuk kepeit, hɨrakɨt tɨnaaiwɨr kɨnaan kerek mɨtɨk kɨwaai kekrerem men tɨ. ");
INSERT INTO avt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas kertei hɨrakɨt tetike mɨtɨk kɨwaai kɨnaan han kitet hɨrak kakɨkepik, hɨrak ketpɨwek kar ik: “Mɨtɨk, hi esak menmen enum mit hɨram mamno.” ");
INSERT INTO avt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hɨrak katɨp kar ik, te mɨt han kerek ninɨn nertei hɨm me Moses natɨp mɨt miyapɨr em, hɨr nau neit en hɨr han kitet nar ik: ");
INSERT INTO avt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ko! Kenmak hɨrak katɨp kar ik? Hɨrak katɨp enum kekrehɨr ke God. Hɨrak kɨre God te hɨrak ketpim a? God kerekek kakɨsak menmen enum mamno. Mɨt taauye!” ");
INSERT INTO avt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisas kertei kekre han kɨrak hɨr han kitet nar ik, te hɨrak ketpor kar ik: “Yi ap han ekitet menmen mekre han ki mar im au emɨt! ");
INSERT INTO avt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hi atɨp mɨtɨk kɨwaai kentar kɨnaan, ‘Hi esak menmen enum nɨpaa ti hɨrɨakem hɨram mamno,’ yi yepɨtari hi atɨp werek auye. Te hi atɨp mɨtɨk, ‘Ti ekrit etenen yeno eiyɨm eno, hɨrak kakɨkrit kakno, yi eiyɨrtei hi atɨp werek te hi esak menmen enum me yi mɨt. Hi etpi mekam te yi han ekiteta?’ ");
INSERT INTO avt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hi tewen etpɨwek har ik: ‘Ekrit eno,’ te yi eiyɨrtei hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi esak menmen enum yi mɨt ne tɨ yi yɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Hɨrak ketpor epei au, hɨrak katɨp mɨtɨk kɨwaai kekre kɨnaan kar ik: “Ti ekrit etenen kɨnaan mit eiyɨm eno witeik.” ");
INSERT INTO avt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hɨrak katɨp epei au, te mɨtɨk kehɨn kekrit ketenen kɨnaan mɨrak kewepi ken witeik. Mɨt nɨrek, te hɨr nepɨrpɨr newenɨpi God Hɨrak Iuwe, hɨr natɨp nar ik: “Haiu mɨr menmen yaaim mar im nɨpaa ein auye.” ");
INSERT INTO avt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Maain Jisas pɨke kitet tenhaan ken wan ke Galili, mɨt nen nererik te hɨrak ketpor hɨm me God. ");
INSERT INTO avt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hɨrak wen kitet tenhaan hɨrak kɨr Livai, hɨrak nɨkan ke mɨtɨk Alfias, hɨrak naanmɨpre wɨnak ke mɨt hɨr newɨr pewek me takis. Jisas kɨrek ketpɨwek kar ik: “Ti etikewa hawɨr wariyakɨt wauno te ti ehises hɨm mai.” Livai kekrit kisesik ketikerek ten. ");
INSERT INTO avt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Maain Jisas kau wɨnak ke Livai. Mɨt yapɨrwe enun kerek hɨr neit takis nekintɨp pewek ham nɨsawɨnem, hɨr nen netike mɨt kerek nɨrɨak menmen enum hɨr naam menmen netike Jisas ketike mɨt nɨrak disaipel kerek nises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","In ek mɨt han nepu, niuk mɨr Farisi, hɨr ninɨn nises hɨm me Moses. Mɨt han nepu niuk mɨr Skraip. Hɨr ninɨn nertei hɨm me Moses natɨp mɨt em. Hɨr nɨr Jisas ketike mɨt naanmɨpre pewek me takis netike mɨt kerek hɨr nɨrɨak enum, hɨr yapɨrwe newepnak nekiyan naam menmen. Hɨr mɨt Skraip natɨp Jisas disaipel nɨrak nar ik: “Kenmak hɨrak kɨpaam menmen ketike mɨt nari pewek me takis netike mɨt nɨrɨak menmen enum a?” ");
INSERT INTO avt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas kemtau hɨm mɨr, te hɨrak ketpor kar ik: “Mɨt nɨnap nanɨno nanɨr mɨtɨk dokta. Mɨt hɨr manpenun neit taau. Hi epei han tɨ hari han ke mɨt hɨr nɨrɨak enum. Mɨt kerek hɨr han kitet hɨr yaain au.” ");
INSERT INTO avt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maain wɨ ham mɨt nises hɨm me Jon netike mɨt ne Farisi hɨr han tewenɨn menmen me God yaaim, te hɨr nanɨt nɨnpɨ nanu. Mɨt han nɨri te hɨr nan nɨr Jisas nitɨwekhi nar ik: “Mɨt ne Jon netike mɨt ne Farisi hɨr nanɨt nɨnpɨ nanu. Nenmak te mɨt nises hɨm mit nɨrɨakem au?” ");
INSERT INTO avt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas ketpor tok piksa kar ik: “Mɨt nanɨt nɨnpɨ nanu nantike mɨtɨk epei keit mɨte a? Taauye! Hɨr han yaaik nanɨm menmen nantikerek. ");
INSERT INTO avt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Maain wɨ ham hɨr mɨt han hɨr nantɨwekhis neiyɨk nanɨno, te hɨr mɨt nɨrak nanɨt ninpɨ rek nanu.” ");
INSERT INTO avt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hɨrak wen ketpor tok piksa kar ik: “Mɨt hɨr ap nekerwo laplap ham kike yaaim mentɨr ham enum tokim au. Hɨr nekerwewim, maain hɨr nankemyet laplap hɨram mamno mamre kike mamri laplap tokik mamwepim. ");
INSERT INTO avt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mɨt hɨr ap newen tɨpar wain wen petep mekre meme hiyei tokim auye! Hɨr nanwenem te wain tɨwerpek mamniu, hiyei tokim mamwep te wain mamwen mamno tɨ, hiyei enum mamwep mamɨt. Au, mɨt newen wain wen petep mekre meme hiyei wen yaaim nɨmnam.” ");
INSERT INTO avt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Maain wɨ sabat ham, Jisas hɨrak ketike mɨt disaipel nɨrak hɨr nen nitet ni ham. Mɨt nɨrak newen wit yehes mɨram nehis newenem hɨr naam. ");
INSERT INTO avt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mɨt ne Farisi kerek ninɨn nises hɨm me Moses hɨr natɨp Jisas nar ik: “Ko! Nenmak te mɨt nit nɨrɨak menmen im enum a? Nɨpaa God kewet Moses hɨm lo me wɨ Sabat, te haiu metput me mɨt nit hɨr newen wit yehes au emɨt.” ");
INSERT INTO avt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisas hɨrak ketpor kar ik: “Yi ap han kitet werek menmen yi yekinaam me hɨm me maam kaiu Devit a? Nɨpaa hɨrak ketike mɨt nɨrak nɨnpɨ maan te hɨr naam menmen nar ke haiu mɨt in ek epei maam. Te yi wen yepɨtari hɨr nɨrɨak enum au, yaaim ye! ");
INSERT INTO avt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abaiata hɨrak wen mɨtɨk hetpris naanmɨpre wɨnak ke God, hɨrak Devit ketike mɨt nɨrak nen wɨnak eik nɨmɨn ein naam bret tokim mɨt newisɨm me God mɨwaai mensiu kɨnaan menep. Mɨt naanmɨpre menmen me God, hɨr keriyen naam bret tokim mɨrak. Mɨt han au. Hɨm me Moses matɨp emɨt, te hɨrak Abaiata kewet Devit ketike mɨt nɨrak em hɨr naam. ");
INSERT INTO avt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","God kinɨn kɨrɨak mɨt. Hɨrak hanhani, hɨrak kehimɨtan wɨ sabat hɨram mamkaap mɨt keriyen. ");
INSERT INTO avt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi Mɨtɨk Iuwe, hi hinɨn menmen me wɨ sabat.” ");
INSERT INTO avt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Maain Jisas pɨke ken wɨnak kerek mɨt nererik nekine hɨm me Moses neitai en. Mɨtɨk enuk his miutɨp meweikɨn hɨrak kau ein. ");
INSERT INTO avt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mɨt han hɨr nɨpɨrek hɨrak kakɨkepik me wɨ Sabat te hɨr nenerek nansiuwek hɨm nanriyaak kakno wɨnak enuk. ");
INSERT INTO avt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas katɨp mɨtɨk his enuk kar ik: “Ti enen in.” ");
INSERT INTO avt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hɨrak epei kan, Jisas katɨp mɨt kar ik: “Me wɨ Sabat hɨm me God kerek Moses kewisɨm mau tɨwei hɨram mewisai haiu mɨrɨak menmen yaaim o enum? Haiu emkaap mɨt o haiu emnɨp?” Hɨr au nekintɨp neit. ");
INSERT INTO avt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hɨrak kɨwaainaan kɨri kemtaantɨwo han enuk kentar hɨr mɨt han toenuk. Hɨrak katɨp mɨtɨk his enum kar ik: “Ti esiuwe his emnen.” Hɨrak kesiuwehis mɨrak te his pɨke mɨre yaaim. ");
INSERT INTO avt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","His mɨre yaaim te mɨt ne Farisi hɨr nen witeik nen nererik netike mɨt kerek nises hɨm me mɨtɨk iuwe King Herot, hɨr nimenɨpɨn Jisas nankɨp. ");
INSERT INTO avt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas ketike mɨt disaipel nɨrak hɨr nen wan eik. Mɨt yapɨrwe ne provins Galili hɨr nisesik nen nererik netike mɨt ne Provins Judia, ");
INSERT INTO avt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Idumia, wit yapɨrwe ke mani Jodan pɨnak ein, wit Taia, wit Jerusalem ketike wit Saidon. Hɨr yapɨrwe nemtau menmen Jisas epei kɨrɨakem, te hɨr nan nanɨrek. ");
INSERT INTO avt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hɨr epei nan, Jisas katɨp mɨt nɨrak kar ik: “Yi yayit bot eiyɨk einen eitenɨnek te mɨt ap nanɨpɨra hi ankewɨn hɨr nanɨntɨrɨra.” ");
INSERT INTO avt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nɨpaa Jisas kɨkaap mɨt miyapɨr yapɨrwe nɨnap hɨr nɨre yaain, te in ek mɨt yapɨrwe nɨnap newep mɨt hɨr nan nerp menep newis his mentar Jisas, te hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hɨrak ken kitet ein ein, herwe enun nɨrek nitehɨr nau tɨ nenepɨp nar ik: “Ti Nɨkan ke God.” ");
INSERT INTO avt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Te Jisas ketpor hɨm manp hɨr ap nanwepyapɨrek au emɨt! ");
INSERT INTO avt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Maain Jisas kehis mɨt kerek hɨrak hanhani kenɨnor hɨr nan nisesik netikerek nen nau mɨniu (o neiyɨp) kentɨr ein. ");
INSERT INTO avt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hɨr nau ein, hɨrak kehis mɨt hiswiyen wik (12) hɨrak kewep niuk kenewor niuk mɨr “Aposel.” Hekrit hekrit hɨr netikerek nanriyan nanisesik nanɨmtau hɨm mɨrak. Maain hɨrak kakriuweti nanɨno nantɨp mɨt miyapɨr hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Maain hɨrak kakriuweti kakwisi hɨr nepɨr herwe enun nanɨno nankeipɨn mɨt. ");
INSERT INTO avt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Im em hɨram niuk me mɨt hɨrak ketorhis keriyei netikerek: Saimon (hɨrak kewis niuk mɨrak ham Pita), ");
INSERT INTO avt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems, ketike nɨkik kɨrak Jon, hɨrakɨt nɨkerek te Sebedi (Hɨrak kewis niuk mɨrakɨt wik Boanesis kentar hɨrakɨt tatɨp hɨm iuwe mɨre nepni mewenɨn). ");
INSERT INTO avt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Hɨrak wen kehimɨtan Andru, Filip, Batolomyu, Matyu, Tomas, Jems hɨrak nɨkan ke mɨtɨk Alfias, Tadias, Saimon Selot, ");
INSERT INTO avt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","hɨr netike Judas ke wit Iskeriot kerek kewepyapɨr Jisas te mɨt enun nepan nɨrak neiyɨk nen nakɨp. ");
INSERT INTO avt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas kehis mɨt hiswiyen wik (12) epei au, hɨrak ken wɨnak kɨrak eik. Hɨrak ken wɨnak, mɨt yapɨrwe nererik wɨnak kɨrak te hɨrak ketike mɨt disaipel nɨrak ap te nanɨm menmen taau. ");
INSERT INTO avt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Maain miye pɨrak wetike kikrek tɨrak hɨr nerteiyek, hɨr nen nare nantɨwekhis nanriyaak neiyɨk nanɨno nɨr ein nentar hɨr han kitet hɨrak han ken sip hɨrak ketaritari. ");
INSERT INTO avt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mɨt kerek ninɨn nertei hɨm lo me Moses natɨp mɨt miyapɨr em, hɨr nɨnaaiwɨr wit Jerusalem nekiuwe nan natɨp nar ik: “Herwe enuk niuk mɨrak Bielsebul hɨrak kersɨs Jisas te hɨrak Seten kewis Jisas hɨrak kinɨn herwe enun kepɨri nanɨno nankeipɨn mɨt.” ");
INSERT INTO avt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas kertei menmen hɨr netpim te hɨrak kenɨne mɨt ein hɨr nan nerp menep in, hɨrak ketpor tok piksa kar ik: “Seten kenmak te hɨrak kepɨr herwe nɨrak nekeipɨn mɨt a? Taauye! ");
INSERT INTO avt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mɨt ne wit hak hɨras nanɨnepan, te hɨr nankiyan nantike mɨt han ne wit hak nanɨnepan taauye! ");
INSERT INTO avt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mɨt ne weiwɨk miutɨp hɨras nanɨnepan te hɨr nanɨrkeik te hɨr nankiyan nanu nanɨt? Au, hɨr nanɨwaank hɨras. ");
INSERT INTO avt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seten hɨrekes kepɨr herwe nɨrak nankeipɨn mɨt, hɨr nanɨnke hasini nanɨwaank hɨras. ");
INSERT INTO avt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hi hinɨn Seten hi epɨr herwe nɨrak nekeipɨn mɨt, hɨram mar ke mɨtɨk hak kinɨn kakno kakwep weipɨr kaksenkek mɨtɨk enuk yehes enum o mɨtɨk iuwe, te hɨrak kakɨt menmen mɨrak meit wɨnak eik keiyɨm kakno. ");
INSERT INTO avt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Hi etpi werek. Menmen enum mɨt nɨrɨakem metike hɨm enum hɨr netpim hɨrak God kakɨsakem han ekitetim au. ");
INSERT INTO avt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Te mɨt natɨp enum me menmen God Hɨmɨn Yaaik kɨrɨakem, hɨrak ap te kakɨsakem taau! Hɨram mamu mamɨt tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jisas katɨp hɨm im kentar mɨt han ne Jerusalem hɨr natɨp nar ik: “Herwe enuk kersɨsek kekepik te hɨrak kepɨr herwe enun nekeipɨn mɨt.”) ");
INSERT INTO avt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hɨrak katɨp epei au, Jisas miye pɨrak wetike kikrek tɨrak nan nerp witeik nenɨnewek. ");
INSERT INTO avt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mɨt nau neit nɨmɨn nemtau hɨr nenɨnewek, hɨr netpɨwek nar ik: “Miye pit wetike kikrek nit hɨr nerp witeik nenɨnut.” ");
INSERT INTO avt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisas ketpor kar ik: “Neiyɨn hɨr nɨre miye wetike kikrek nai?” ");
INSERT INTO avt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hɨrak kɨwaainaan kɨr mɨt nau menep te hɨrak katɨp: “Mɨt in hɨr nɨre miye wetike kikrek nai. ");
INSERT INTO avt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mɨt kerek nemtau hɨm me God nisesim, hɨr keriyen nɨre miye wetike kikrek o yenterer nai.” ");
INSERT INTO avt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas pɨke ken wan ke Galili kerp tenhaan eik katɨp mɨt hɨm me God. Hɨrak kepu ein, mɨt yapɨrwe nan nererik nanɨmtau hɨm mɨrak. Hɨr nerp menep menep nersɨs Jisas, te hɨrak ken kau bot kɨwaai kentar wan menep tenhaan. Mɨt yapɨrwe nau tenhaan nemtau hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hɨrak ketpor tok piksa kar ik: ");
INSERT INTO avt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yi eiyɨmtewem! Hɨrak mɨtɨk hak ken kewɨr yehes meit ni mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hɨrak wen kewɨrem, ham menke mɨwaai yayiwe, hore meniuwe man maam. ");
INSERT INTO avt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yehes ham hɨram menke mɨwaai tɨ kentar nan mewo waswas mekre tɨ kike. ");
INSERT INTO avt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Maain, wepni iuwe kan kamɨp, hɨram meweiwei maa keremem. ");
INSERT INTO avt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yehes ham menke mɨwaai tɨ kerek nɨpaa waai enum tɨk tɨk mewiyen. Maain, waai enum tɨk tɨk pɨke mewo mɨwapɨnem, te hɨram ap mari au. ");
INSERT INTO avt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yehes ham menke mɨwaai tɨ yaaik nɨpaa mɨtɨk kewenek. Hɨram mewo iuwe mari yapɨrwe. Ham mari 30, ham mari 60, ham mari 100.” ");
INSERT INTO avt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas katɨp hɨm mɨrak mɨkaru mar ik: “Neimɨn yi yertei hɨm mai werek werek yi han ekitetim werek werek.” ");
INSERT INTO avt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Maain, mɨt yapɨrwe epei nen, Jisas hɨrak kepu weinɨm ketike mɨt hiswiyen wik nɨrak (12) netike mɨt han disaipel kerek nemtau hɨm mɨrak keriyen. Hɨr nepu nitɨwekhi hɨm me nɨpaa hɨrak ketpim. ");
INSERT INTO avt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Te hɨrak ketpor kar ik: “God kewisi yi yertei menmen me hɨrak kinɨn naanmɨpre menmen karkeik. Nɨpaa God ap kewepyapɨrem, te mɨt hɨr nerteiyem au. Hi etpim hɨsawɨnem te yi mɨt keriyen yertei menmen me God. ");
INSERT INTO avt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mɨt han toenuk au. Hi etpim hɨsawɨnem hetpor te ‘hɨr enɨr menmen te hɨr ap nerteiyem, hɨr nemtewem te hɨr nerteiyem au. Hɨr nertei te hɨr neweikɨn han newet God em, God kakɨsak menmen enum hɨr nɨrɨakem. Hɨr nepɨtari menmen te hɨrak kakɨsak menmen enum mɨr au.’ ");
INSERT INTO avt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“In ek yi yepɨtari menmen im hi etpiyem hɨsawɨnem, te maain yi eiyɨrtei menmen ham hi etpiyem hɨsawɨnem mamɨrkeik? Taauye! Hi are ewepyapɨr im em, te maain yi eiyɨrtei hɨm me God werek werek. ");
INSERT INTO avt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","15","Yehes mɨwaai yayiwe hɨram mar ke mɨt hɨr nemtau hɨm me God, te Seten kan keweiknor han kɨr hɨr han kaa hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yehes menke mɨwaai tɨ kike kentar nan hɨram mar ke mɨt nemtau hɨm me God hɨr han yaaik. ");
INSERT INTO avt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yehes nekenik kike mewo mepu, maain wepni kamɨp hɨram meweiwei maa hɨram mɨre mɨt. Mar im hɨr nepu han yaaik, te maain mɨt hɨr han neneri newepnaki, hɨr han enuk nanɨnaaiwɨr hɨm me God mamɨt. ");
INSERT INTO avt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yehes mɨwaai tɨ nɨpaa waai tɨktɨk mewi mɨwapɨn yehes hɨram mar ke mɨt hɨr nemtau hɨm me God. ");
INSERT INTO avt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Te hɨr han kitet menmen yapɨrwe. Hɨr han yaaik nanɨt pewek yapɨrwe, hɨr hemkre menepam neriuwe menmen heriyai heriyai ere han kɨr kenke kenterim. Hɨm me God mepu mekre han kɨr au, hɨr han kaa rem meit. ");
INSERT INTO avt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yehes mɨwaai tɨ yaaim mari yapɨrwe, hɨram mar ke mɨt nemtau hɨm me God hɨr nisesim nɨrɨak menmen yaaim. Mɨt han kike, mɨt han iuwe, mɨt han wɨsenum.” ");
INSERT INTO avt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas hɨrak pɨke ketpor kar ik: “Yi yayɨt si te yi eisawɨnek ekɨkre sar o eknɨk yeno a? Taauye! Yi eiwisɨk ekɨntar yeno eku niu ekɨr. ");
INSERT INTO avt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Menmen yapɨrwe mɨsawɨn meit, maain hɨram pɨke mamu yaain mɨt nanɨrteiyem. Menmen ham yapɨrwe mɨt hɨr nehanem, maain hɨram mamu yaain mɨt nanɨrteiyem. ");
INSERT INTO avt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Keiyɨn kakɨrtei, hɨrak kakɨmtewem.” ");
INSERT INTO avt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hɨrak wen ketpor kar ik: “Menmen yi eiyɨmtewem yi han ekitetim werek werek. Mar ke yi han kitet mɨt netike menmen hɨr nɨrɨakem, maain mar im God han kakiteti yi mɨt kakrekyiyem, te hɨrak kakriyaam wɨsenum. ");
INSERT INTO avt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mɨtɨk hak ketenen menmen, te God kakwetɨwek menmen ham mamtikerem hɨram yapɨrwe. Mɨtɨk hak au ketenen menmen kike, menmen mɨrak kike God kakriyaam mamno mamkeipnɨwek mamɨwaank mamɨt.” ");
INSERT INTO avt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas wen katɨp: “Menmen God kɨrɨakem kakri han ke mɨt te hɨr nanisesik, hɨram mar ke mɨtɨk kamɨr yehes mau ni. ");
INSERT INTO avt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wɨtaan o wanewik hɨrak kɨwaai o kɨrɨak menmen, yehes mewo. Hɨrak kɨrem mewo, te hɨrak kepɨtari karkeik te hɨram mewo. ");
INSERT INTO avt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tɨ hɨrekes kenip yehes mewo men mine tɨwei, maain heneik mewim hɨram mamri mamine nɨkim mɨram. Mɨtɨk au, tɨ erekek kenip menmen mewo. ");
INSERT INTO avt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maain yehes me nenhep maa, mɨtɨk kaknen kakwenem.” ");
INSERT INTO avt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas wen ketpor kar ik: “Hi etpi menmen God kɨrɨakem kakri han ke mɨt kakriuwerem hɨram mɨre mekam? Hi etpi hɨm im. ");
INSERT INTO avt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yehes me nu mastet men tɨ mewo hɨram kike kike. (Hɨram mar ke God kinɨn naanmɨpre mɨt, te maain hɨr yapɨrwe nanɨrtei menmen mɨrak.) ");
INSERT INTO avt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Maain, hɨrak mastet nɨkik kakwo kakre iuwe, hɨrak kinɨn menmen mɨt namɨr mau ni eim, hɨrak ken niu kakwɨrɨr heneik mewik, te hore mamnen mamwik mamwis yaank mentar heneik mɨrak.” ");
INSERT INTO avt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas katɨp mɨt yapɨrwe tok piksa mar im ere hɨrak keremir yinam au meit mentar hɨr ap nerteiyem wen au. ");
INSERT INTO avt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Hɨrak katɨp tok piksa mar im katɨp mɨt yapɨrwe rem keriyen. Te hɨrak ketike mɨt nɨrak nepu weinɨm, hɨrak kewepyapɨr menmen nɨpaa hɨrak ketpim kɨsawɨnem. ");
INSERT INTO avt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Maain hɨnkewɨ menep kakre wɨtaan, Jisas katɨp mɨt nɨrak kar ik: “Haiu emno emrekir wan emno pɨnak ein.” ");
INSERT INTO avt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hɨrak ketpor, te hɨr netikerek wen nau bot nɨnaaiwɨr mɨt yapɨrwe nerp tenhaan. Mɨt nau bot ham netikeri nen. ");
INSERT INTO avt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hɨr wen nepno ein, yuwerep kɨniu kan keriuwet wan te tɨpar kehɨnhɨn kekre bot. ");
INSERT INTO avt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas kɨwaai kɨnatɨn kekre bot sip kɨrak kewis paan kentar yeno tap mɨrak. Mɨt nɨrak nan nekotɨtek netpɨwek nar ik: “Haai, ti ap han kitetai au a? Haiu wan kɨniu kakwep te haiu mami.” ");
INSERT INTO avt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Te Jisas kekrit katɨp wan yuwerep kewenek kar ik: “Hɨhe enuk ewaai ehɨt!” Hɨrak katɨp epei au, yuwerep katɨn kike kike, wan hɨhe enuk kɨwaai keit. ");
INSERT INTO avt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Te Jisas katɨp mɨt nɨrak kar ik: “Yi yenmak te yi yɨnaain a? Yi ap han kiteta wen au a?” ");
INSERT INTO avt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hɨr nemtau hɨm mɨrak, hɨr nɨnaain natɨpan main main nar ik: “Mɨtɨk ik hɨrak keimɨn? Hɨrak mɨtɨk kerekek? Hɨrak kertei kewen yuwerep wan hɨhe enuk kɨwaai keit.” ");
INSERT INTO avt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hɨr nau bot nerekir wan nen pɨnak ein, hɨr niun tɨ ke wit ke mɨt ne Gerasa. ");
INSERT INTO avt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisas hɨrak kenke kɨnaaiwɨr bot kiun tenhaan ken pɨn eik, mɨtɨk hak kerek herwe enuk kersɨsek hɨrak kɨnaaiwɨr herwe hei kɨnɨk mɨniu (o neiyɨp), hɨrak kan Jisas. ");
INSERT INTO avt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mɨtɨk ik hekrit hekrit kepu kekre herwe hei kɨnɨk mɨniu (o neiyɨp). Mɨt han hɨr ap nenke sen nesenkekik neriuwerem in ek au. ");
INSERT INTO avt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hɨr nɨpaa nesenkekik neriuwe sen mau his hɨt mɨrak, te hɨrak au kari me his ketnim, hɨrak kewɨr nan kenemtɨn me hɨt. Mɨt han hɨr nepɨtari nɨrɨak menmen te hɨrak kɨre yaaik kau keit, taau. ");
INSERT INTO avt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hekrit hekrit wɨtaan wepni, hɨrak kepu kepeit kepɨkre herwe hei kɨnɨk mɨniu (o neiyɨp), hɨrak kenepɨp kenep hɨrekes keriuwe nan kerekir yɨnk kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hɨrak kɨr Jisas keperp ein, hɨrak kesiukɨn ken kewen ninɨp kitehɨr kewenɨpiyek kerp menep, ");
INSERT INTO avt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","hɨrak kenepɨp katɨp kar ik: “Ti Nɨkan ke Mɨtɨk Iuwe ti henmak te t!” ");
INSERT INTO avt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Herwe kɨnapen kentar Jisas nɨpaa ketpɨwek kar ik: “Ti herwe enuk enke enepɨn ekeipnɨwek.” ");
INSERT INTO avt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisas kitɨwekhi kar ik: “Ti ekine hɨrekes.” Herwe katɨp, “Hi niuk mai mɨt yapɨrwe hentar haiu herwe yapɨrwe mersɨsek.” ");
INSERT INTO avt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hɨrak kitehi Jisas hɨm iuwe te hɨrak ap kakriuweti nanɨnaaiwɨr wit ik au ekɨt! ");
INSERT INTO avt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sak yapɨrwe meit mɨniu (o neiyɨp) eik maam menmen. ");
INSERT INTO avt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Herwe nitɨwekhi nar ik: “Ti eriuwetai haiu mamno mamɨkre sak.” ");
INSERT INTO avt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisas hɨrak kewenhi te hɨr netpaan nɨrɨr nekeipɨn mɨtɨk ik, hɨr nen nekre sak. Sak yapɨrwe mar 2,000 hɨram mɨrɨr mekiuwe mɨniu (o neiyɨp) men mamɨn wan tɨpar mekiuwe hɨm yipɨr hɨram maa meit. ");
INSERT INTO avt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mɨt kerek naanmɨpre sak hɨr nɨrɨr nen natɨp mɨt ne wit iuwe, mɨt ne wit kike me menmen im epei man. Hɨr nemtau menmen im, hɨr nan nanɨr menmen mɨt hɨr epei netporem. ");
INSERT INTO avt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hɨr nan nɨr Jisas ketike mɨtɨk nɨpaa herwe nersɨsek. Mɨtɨk ik hɨrak kau tɨ han yaaik, hɨrak epei keriuwet klos, te hɨr mɨt nɨnapen. ");
INSERT INTO avt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mɨt naanmɨpre sak wen netpor menmen hɨr epei nɨrem me mɨtɨk enuk ketaritari ketike sak. ");
INSERT INTO avt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hɨr nemtau menmen im, hɨr nitehi Jisas hɨm iuwe hɨrak kaknaaiwɨr wit kɨr. ");
INSERT INTO avt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hɨr nitɨwekhi nar ek, te hɨrak ken kau bot. Hɨrak mɨtɨk nɨpaa herwe nersɨsek kitehi Jisas, te hɨrak ketikerek tatno. ");
INSERT INTO avt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Te Jisas ketpɨwek kar ik: “Au, ti ehu in eno wit me mɨt nit eteiknor etpor menmen Mɨtɨk Iuwe hɨrak kerekyutem han tewenɨnit kekepit.” ");
INSERT INTO avt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Te hɨrak ken wit mar hiswiyen (10) niuk mɨram Dikapolis, hɨrak katɨp kewepyapɨr menmen Jisas kerekyɨwekem. Mɨt en nemtewem hɨr nepɨrpɨr han yaaik han kitetim. ");
INSERT INTO avt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas pɨke ken kau bot ketike mɨt nɨrak, hɨr nerekir wan nen pɨnak ein. Jisas kenke kɨnaaiwɨr bot pɨke ken kiun tenhaan eik, mɨt yapɨrwe nerp nererik neweiknɨwek kerp en. ");
INSERT INTO avt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hɨr nerp nererik neweiknɨwek kerp en, mɨtɨk hak kerek naanmɨpre wɨnak kerek mɨt nererik nekine hɨm me Moses neitai, niuk mɨrak Jairas, hɨrak kan kenke kitehɨr kɨwaai hɨt me Jisas, ");
INSERT INTO avt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","hɨrak katɨp hɨm iuwe kar ik: “Nɨki pai nepei menep wawi waunatɨn wauno. Ti enen etikewa euno ti ewis his menteriye te hɨre aure yaaip hɨre pɨke wawɨkrit wawu.” ");
INSERT INTO avt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hɨrak ketpɨwek, te Jisas ketikerek ten ein. Hɨrak tetike mɨt disaipel nɨrak nen en, mɨt yapɨrwe nisesi nen nerp neweikɨn Jisas. ");
INSERT INTO avt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mɨte piutɨp wises Jisas wetikeri, hɨre wɨnap hekrit hekrit winen hemkre me tito mar hiswiyen wik (12). ");
INSERT INTO avt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hɨre nɨpaa wen wɨr mɨt dokta yapɨrwe, hɨre wewɨr pewek wewetorem weiyɨm watɨn hɨrehes ere hɨram epei au mesi. Te hɨr nertei nekepye au. Hɨre wen wɨnap winen hemkre. ");
INSERT INTO avt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hɨre wemtau mɨt natɨp menmen Jisas hɨrak kɨrɨakem, te hɨre wisesik. ");
INSERT INTO avt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hɨre han kitet war ik: “Hi awis his mentar laplap mɨrak kerekek, te hi pɨke are yaaip.” ");
INSERT INTO avt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hɨre wesiuwe his wewisɨm mentar laplap mɨrak, hemkre kɨre katɨn keit, hɨre wɨre yaaip. Te hɨre wertei hɨre winen hemkre epei au keit. ");
INSERT INTO avt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisas hɨrak kertei menmen mɨrak yaaim iuwe mɨnaiwɨrek men mɨkaap neimɨn, te hɨrak keweikɨn kɨwaainaan kitehi mɨt kar ik: “Keimɨn ketenɨno laplap mai?” ");
INSERT INTO avt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mɨt nɨrak disaipel netpɨwek: “Ko! Mɨt yapɨrwe neweiknɨnit. Kenmak te ti hitorhi me laplap mit a?” ");
INSERT INTO avt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Au, Jisas wen kɨwaainaan kakɨr keimɨn ketenɨnɨwek laplap. ");
INSERT INTO avt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mɨte ip wertei hɨre epei wɨre yaaip, te hɨre wepɨrpɨr wan wenke witehɨr wɨwaai hɨt me Jisas wewepyapɨr menmen hɨre wɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Te Jisas ketpɨwe kar ik, “Mɨte, ti han kiteta hi ekepit, te ti ere yaaip. Nɨpaa ti hɨnap te in ek ti epei ere yaaip.” ");
INSERT INTO avt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hɨrak wen ketpɨwe, mɨtɨk Jairas mɨt nɨrak nan netpɨwek nar ik: “Nɨki pit epei waa, henmak te ti eriyaam ektan Jisas? Ti ewisɨk kakno?” ");
INSERT INTO avt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Te Jisas kemtewem hɨrak katɨp mɨtɨk Jairas kar ik: “Ti ap enaain au. Ti han ekiteta kerekek.” ");
INSERT INTO avt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hɨrak kewis Pita, Jems ketike nɨkik kɨrak Jon tetike mɨtɨk ik keretet, hɨrakɨt ten ein. Hɨrak kewen mɨt han au, hɨr nerp in. ");
INSERT INTO avt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hɨrakɨt ten tɨpiun wɨnak ke mɨtɨk ek, hɨrak Jisas kɨr mɨt hɨr nɨkɨtep nesikeyaanmi. ");
INSERT INTO avt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hɨrak ken wɨnak ke nɨmɨn ein, hɨrak ketpor kar ik: “Yenmak te yi yɨkɨtep? Hɨre ap waa au, hɨre wɨwaai kerepep.” ");
INSERT INTO avt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hɨr nemtewek katɨp kar ik te hɨr nenwesɨsek enum enum nen. Te hɨrak keriuweti nen wit eik. Hɨrak ketike miye haai nɨre nen netike Pita, Jems, Jon neit haau me nɨki wɨwaai weitai en. ");
INSERT INTO avt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hɨrak ketenenɨwe his kiutɨp ketpɨwe hɨm me mɨt ne Isrel kar ik: “Talita kumi.” Haiu meweikɨn hɨm haiu matɨp mar ik: “Nɨki kike hi hetput ti ekrit.” ");
INSERT INTO avt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hɨre wekrit wasenum witet ein ein. (Nɨpaa ein hɨre wepu tito mar hiswiyen wik (12).) Hɨr mɨt nɨrep hɨre witet ein ein hɨr nenemyɨwe naan natɨp: “Ko!” ");
INSERT INTO avt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas ketpor hɨm iuwe te hɨr ap nanwepyapɨrek au emɨt. Epei au, hɨrak ketpor hɨr nanwetɨwe menmen te hɨre wawɨm. ");
INSERT INTO avt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas kɨnaaiwɨr wit ik ek ken kiun wit kɨrak eik. Mɨt nɨrak hɨr nisesik. ");
INSERT INTO avt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hɨrak ken kiun witeik, maain wɨ sabat ham, hɨrak ken kekre wɨnak kerek mɨt nekine hɨm me Moses neitai en, hɨrak katɨp mɨt miyapɨr hɨm me God. Hɨr nemtewek, hɨr nehɨnhɨn natɨp nar ik: “Keimɨn ketpɨwek hɨm im te hɨrak ketpaiyem? Karkeik te hɨrak kertei menmen im? Hɨrak kɨrɨak menmen yaaim nɨpaa haiu ap mɨrem au. ");
INSERT INTO avt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mɨtɨk ik ek hɨrak kime wɨnak kerekek. Hɨrak nɨkan ke Maria. Hɨrak heiyiuwe ke Jems, Josep, Judas tetike Saimon. Yenterer nɨrak nau in netikewai. Hɨrak Mɨtɨk Iuwe au. Hɨrak mɨtɨk weinɨk kepɨr ke haiu mɨt keriyen.” Te hɨr han toenuk neriuwerek nɨneinɨk. ");
INSERT INTO avt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas ketpor kar ik: “Mɨtɨk hak katɨp mɨt menmen God keteiknɨwekem, niuk mɨrak iuwe men heriyai heriyai merer wit wit. Te niuk mɨrak ap iuwe keit wit kɨrak, o weiwɨk miutɨp mɨrak o miye haai kikrek o yenterer nɨrak au.” ");
INSERT INTO avt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hɨrak ap kɨrɨak menmen yaaim yapɨrwe nɨpaa mɨt ap nɨrem au, te hɨrak kewis his mentar mɨt nɨnap kekekpi hɨr nɨre yaain manpenuk neit. ");
INSERT INTO avt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hɨrak kenke kekreri kentar mɨt in ap han kitetik. ");
INSERT INTO avt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hɨrak kari mɨt hiswiyen wik nɨrak (12) nau hɨrak ketpor menmen. Hɨrak ketpor menmen, hɨrak kenkeri keriuweti nɨre wik wik nen nerer wit wit. Hɨrak kewisi hɨr nekrehɨr kɨrak nepɨr herwe enun nanɨno nankeipɨn mɨt. ");
INSERT INTO avt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hɨrak ketpor hɨm iuwe te hɨr ap nanɨt menmen yapɨrwe neiyɨm nanɨno au emɨt! Pewek o wapnake o menmen au. Paap kerekek te hɨr neke tɨ neriuwerek. ");
INSERT INTO avt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hɨr neriuwet su, te saket wik au emɨt, miutɨp keremem. Hɨrak ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Me wɨ yi yaino yayu yayɨkre wɨnak hak, yi ap yayɨm menmen eirer wɨnak ham au emɨt. Wɨnak kiutɨp kerekek ere yi yainaaiwɨr wit yaino wit hak. ");
INSERT INTO avt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mɨt ne wit hak ap neriyi mɨt naanmampri yayɨt wɨnak kɨr nanɨmtau hɨm mi au, yi einaaiwɨr mɨt in einepep toni waniu (o win) mau hɨt mit, te yi yeteiknor hɨr nɨrɨak enum.” ");
INSERT INTO avt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hɨrak ketpor epei au, hɨr mɨt nɨrak nen natɨp mɨt miyapɨr han hɨm me God me hɨrak katɨp mɨt hɨr nanweikɨn sip nanwet menmen enum. ");
INSERT INTO avt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hɨr nepɨr herwe enun yapɨrwe nekeipɨn mɨt, hɨr newen wel mentar mɨt nɨnap, te hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mɨtɨk iuwe King Herot kinɨn naanmɨpre mɨt ne Isrel, hɨrak kertei menmen Jisas kɨrɨakem kentar Jisas niuk mɨrak iuwe te mɨt hɨr nertei menmen hɨrak kɨrɨakem hɨr netpim nerer wit wit. Te Herot kemtewek. Mɨt han natɨp nar ik: “Jon kerek kɨkɨr mɨt neriuwe tɨpar hɨrak nepei kaa, te hɨrak pɨke kekrit kepu. Mar im te hɨrak kɨrɨak menmen yaaim nɨpaa haiu mɨt ap mɨrem au.” ");
INSERT INTO avt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te mɨt han natɨp nar ik: “Hɨrak Jisas ik hɨrak Ilaisa kerekek.” Mɨt han natɨp: “Au, hɨrak kɨre mɨt profet nɨpaa natɨp hɨm me God newepyapɨrem natɨp mɨt em.” ");
INSERT INTO avt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot kemtewem, hɨrak han kitet kar ik: “Hɨrak Jon nɨpaa hi eriuwet mɨtɨk hak ken kerekir teruk kɨrak paan kewen keket, hɨrak pɨke kekrit kau keit.” ");
INSERT INTO avt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nɨpaa Jon hɨrak epei katɨp Herot kar ik: “Ti hewaank Herodias mɨte pe nɨkik kit ti hetɨwe. Menmen im hɨram ap yaaim au, hɨram enum!” Herot han enuk keriuwet mɨt nɨrak hɨr netenen Jon nesenkekik newisɨk kekre wɨnak enuk kentar mɨte pe Herot nɨkik kɨrak niuk mɨrak Filip, hɨrak herot ketɨwe. ");
INSERT INTO avt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias hɨre han enuk ware waunep Jon, te hɨre taau. ");
INSERT INTO avt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot kɨnaain Jon. Hɨrak kertei Jon mɨtɨk yaaik kises hɨm me God. Te Herot naanmɨprewek. Wɨ kerek herot kemtau hɨm mɨrak hɨrak kɨnaain. Te hɨrak wen pɨke hanhan kakɨmtau hɨm mɨrak kakteipim kerekek. ");
INSERT INTO avt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Maain wɨ ham Herodias hanhan wemirɨr Herot mɨtɨk kɨre hɨrak kaknep Jon. Wɨ im Herot han kitet wɨ nɨpaa miye pɨrak winaak, te hɨrak kemani menmen kakwet mɨt nɨrak ne gavman netike mɨt kerek naanmɨpre mɨt ne ami netike mɨt niuk mɨr iuwe neit provins Galili hɨrak kakwetɨr menmen hɨr nanɨm. ");
INSERT INTO avt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hɨr naam epei au, Herodias nɨki pɨre wan wɨrɨre winor henye. Hɨr mɨt han yaaik iuwe neriuwerep, te Herot ketpɨwe kar ik: “Ti itauhi me menmen ti hanhanem, te hi tewen ewetitem. ");
INSERT INTO avt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Menmen mekam ti itauhiyem hi ewetitem. Ti itauhi me menmen hi naanmɨprewem te hi enke pɨnam ewetitem hi wen hetenen pɨnam.” ");
INSERT INTO avt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hɨrak katɨp epei au, hɨre wen witeik witehi miye pɨre war ik: “Hi ehitɨwekhi mekam?” Hɨre miye wetpɨwe war ik: “Ti ehitɨwekhi me mɨtɨk kakno kaknep mɨtɨk Jon Baptais kerek kɨkɨr mɨt neriuwe tɨpar hɨrak kakweto paan kɨrak.” ");
INSERT INTO avt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hɨre pɨke wan waswas wetpɨwek hɨm iuwe war ik: “In ek ti eweto paan ke Jon ekɨkre tɨkenup.” ");
INSERT INTO avt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot kemtau hɨm im, hɨrak han enuk. Te nɨpaa hɨrak ketpɨwe hɨm iuwe, mɨt yapɨrwe nemtewek. Te hɨrak kɨnapen kaknep Jon, te hɨrak yɨnk enuk katɨp mɨte auye. ");
INSERT INTO avt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Te hɨrak kesiuwe mɨtɨk ken kerekir Jon teruk kɨrak kekre wɨnak enuk. ");
INSERT INTO avt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Hɨrak kewis paan kɨrak kekre tɨkenup hɨrak pɨke keiyɨk kan kewet mɨte rek. Hɨre wen witeik wewet miye pɨre paan ke Jon. ");
INSERT INTO avt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Maain mɨt ne Jon nertei hɨrak epei kaa, hɨr nen wɨnak enuk neit yɨnk kɨrak neiyɨk nan newisɨk kekre hei. ");
INSERT INTO avt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mɨt aposel ne Jisas pɨke nan netpɨwek menmen hɨr nɨrɨakem natɨp mɨt miyapɨr em. ");
INSERT INTO avt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hɨrak ketpor kar ik: “Yi eitikewa haiu mamno wit weinɨk mamu mamɨt ein.” Hɨrak katɨp kar ik kentar mɨt yapɨrwe nan netpor wanewik ere wɨtaan, te hɨr ap nau naam menmen taau. ");
INSERT INTO avt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hɨr hɨras nau bot nepno wit weinɨk. ");
INSERT INTO avt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Te mɨt yapɨrwe ne wit yapɨrwe nɨri hɨr nen, hɨr nerteiri hɨr neimɨn, te hɨr mɨt miyapɨr nesiuknen ninɨn nen wit weinɨk eik ek nemeriyor hɨr nanɨnen. ");
INSERT INTO avt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas kenke kɨnaaiwɨr bot ken kiun tenhaan kerp tɨ eik, hɨrak kɨr mɨt yapɨrwe nererik in, hɨrak hanhani kentar hɨr nɨre sipsip mɨt naanmɨprewem au, hɨram mamno heriyai heriyai menmen mamɨmɨp mamɨwaankem. Hɨrak katɨp keteiknor menmen me God yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Maain menep kakre wɨtaan hɨrak wen ketpor hɨm, mɨt disaipel nɨrak nan netpɨwek nar ik: “Wit weinɨk ik ek, nepei au kakre wɨtaan. ");
INSERT INTO avt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ti eriuweti enɨno enrer wit wit enɨt menmen enɨm.” ");
INSERT INTO avt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hɨrak Jisas ketpor, “Yi hɨras eiwetɨr menmen hɨr nanɨm.” Te hɨr pɨke netpɨwek, “Haiu emno emwɨr pewek mar 200 kina mamɨt menmen a? Taauye! Haiu ap meit pewek mei yapɨrwe au!” ");
INSERT INTO avt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisas kitorhi kar ik: “Menmen marmenum mepeit in? Yi eino eiwenhisem.” Hɨr epei nen newenhisem, hɨr pɨke nan netpɨwek nar ik: “Bret hispɨnak (5) metike saauk wik me wan mepeit in keremem.” ");
INSERT INTO avt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hɨrak epei kertei, hɨrak katɨp mɨt disaipel nɨrak: “Yi eitɨp mɨt hɨr enɨnke hasini enu yenkis eim.” ");
INSERT INTO avt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hɨrak ketpor kar ek, te hɨr nenkeri hasini hasini nau nitet yenkis, mɨt han nar 100, mɨt han nar 50. ");
INSERT INTO avt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Te hɨrak ketenen bret metike saauk mau his mɨrak, hɨrak kɨkɨamnaan men nepni eim kitehi God katɨp hɨrak yaaik. Epei au, hɨrak kewep bret kewet mɨt disaipel nɨrak em. Te hɨr netɨwem neiyɨm nen newet mɨt miyapɨr em. Epei au, hɨrak pɨke keit saauk kewetɨrem hɨr neiyɨm nen newet mɨt miyapɨr em hɨr naam. ");
INSERT INTO avt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Mɨt miyapɨr yapɨrw naam ere tu iuwe, ham au mepeit. Te mɨt disaipel neit menmen yinam mɨwaai em kerek mɨt hɨr naam au, hɨr nemi mekre wapnake mar hiswiyen wik (12) ere mau hɨm. ");
INSERT INTO avt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hɨr mɨt yapɨrwe nar 5,000 mɨt keriyen hɨr nererik naam menmen. ");
INSERT INTO avt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","In ek Jisas katɨp mɨt disaipel nɨrak hɨm manp te hɨr eninɨn enu bot enɨno enrekir wan eniun pɨnak ein enmeriyɨwek enɨt wit Betsaida. Hɨrak kakriuwet mɨt hɨr nanɨno heriyai heriyai nanrer wit mɨr eim. ");
INSERT INTO avt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hɨrak Jisas keriuweti hɨr nen, te hɨrak ken mɨniu (o neiyɨp) kitehi God, hɨrakɨt tewepnak. ");
INSERT INTO avt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Maain wɨtaan man, bot ke mɨt wen kerekir wan ke nɨmɨn, hɨrak Jisas kerp tɨ kepu weinɨk. Hɨrak kɨr mɨt nɨrak hɨr neiyɨk newen tɨpar iuwe neriuwet bot ken, te nɨme mɨniu meriuwet bot ap ken kiun pɨnak ein au. ");
INSERT INTO avt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Menep wanewik, Jisas hɨrak kitet wan keke niu ken. Hɨrak kakno kaksipaat mɨt nau bot, ");
INSERT INTO avt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","te hɨr nɨrek kitet wan keke niu ken, hɨr han kitet hɨrak herwe. ");
INSERT INTO avt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Te hɨr nɨnaain nenepɨp. Hɨr nenepɨp te hɨrak ketpor kar ik: “Yi han tokik eiyu. Hi Jisas kerekek hi han. Te yi ap eineina au.” ");
INSERT INTO avt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hɨrak ketpor epei au, hɨrak kehɨn kɨniu ketikeri nau bot. Te nɨme matɨn meit. Hɨr nɨrek, te hɨr nepɨrpɨr iuwe. ");
INSERT INTO avt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hɨr ap han kitet menmen me bret kerek hɨrak kɨrɨakem kewet mɨt em hɨram meteiknor hɨrak Mɨtɨk Iuwe. Au, han kɨr wen toenuk. Mar im te hɨr nepɨrpɨr. ");
INSERT INTO avt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Hɨr nerekir wan ere hɨr niun tenhaan ken pɨn eik. Hɨr nɨnaaiwɨr bot nerp tenhaan mɨt yapɨrwe hɨr nɨr ninaan me Jisas hɨr nerteiyek hɨrak keimɨn. Te hɨr nen heriyai heriyai ");
INSERT INTO avt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","nerer wit wit hɨr nenerɨr mɨt nɨnap neri nen newisi nɨwaai nentar yeno, hɨr nɨnani neri nen wit kerek hɨr nemtau Jisas kewiyen. ");
INSERT INTO avt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas ken kerer wit kike o wit iuwe, hɨr mɨt newis mɨt nɨnap hɨr nau yaain menep yayiwe, hɨr nitɨwekhi te hɨr newɨr his netenen klos mɨrak. Mɨt kerek newɨr his netenen klos mɨrak, hɨr pɨke nɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mɨt han ne Farisi kerek ninɨn nises hɨm me Moses, hɨr netike mɨt han kerek ninɨn nertei hɨm me Moses natɨp mɨt miyapɨr em, hɨr nɨnaaiwɨr wit Jerusalem nen nererik neit wit eik nanɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hɨr nɨr mɨt disaipel han kerek nises hɨm me Jisas hɨr nɨpaam menmen te hɨr ninɨn nekemyet his mɨr au. ");
INSERT INTO avt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Mɨt miyapɨr ne Isrel hɨr niutɨp niutɨp nises hɨm me maamrer te mɨt ne Farisi hɨr nisesim iuwe. Hɨr nekemyet his au, te hɨr nanɨm menmen au. ");
INSERT INTO avt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hɨr nanɨno wit nanɨt menmen mɨt nesiuwerem meit maket, hɨr nantɨwem pɨke nanɨnen wit eik hɨr ninɨn nanmɨr au, te hɨr nanɨm menmen au. Hɨr nises hɨm meiyam me maamrer mar im. Hɨr nekemyet wa hesnu, mɨn me toni, wenkepye, sar metike mɨn me ain. Au, hɨr ap te nanɨm menmen taau!) ");
INSERT INTO avt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hɨr mɨt ne Farisi netike mɨt kerek ninɨn nertei hɨm me Moses natɨp mɨt miyapɨr em, hɨr nitehi Jisas nar ik: “Nenmak mɨt hɨr nises hɨm mit, te hɨr ap nises hɨm me maamrer? Hɨr naam menmen neriuwe his enum hapɨk mewim.” ");
INSERT INTO avt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisas ketpor kar ik: “Nɨpaa Aisaia hɨrak katɨp hɨm me yi mɨt kerek yewenɨn hɨm. Hɨrak kewis hɨm mau tɨwei mar im: ‘Mɨt in newenanɨpi neriuwe hɨm mɨr, te han kɨr kisɨsa au. ");
INSERT INTO avt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hɨr nitehɨr newen ninɨp nine henye newenɨpi niuk mai weinɨm. Hɨr natɨp mɨt miyapɨr hɨm mɨr hɨram mar ke hɨm me God.’ ");
INSERT INTO avt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Yi yeweikɨn sip yewet hɨm me God, te yi yises hɨm weinɨm mɨt keriyen hɨr netpiyem.” ");
INSERT INTO avt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hɨrak wen ketpor, “Yi yertei werek werek eiweikɨn sip eiwet hɨm me God te yi eiyises hɨm mi. ");
INSERT INTO avt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nɨpaa Moses kewis hɨm mau tɨwei katɨp kar ik: ‘Yi naanmampre miye haai ni eiwenɨpi niuk mɨr eikepi, maain yi naanmampri. Neimɨn hɨr nene miye haai nɨr nanre newɨrpaan newepik, hɨr mɨt han nanɨnɨp nani nanɨt.’ ");
INSERT INTO avt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Te yi mɨt yatɨp mɨtɨk hak kaktɨp miye haai nɨrak menmen hɨrak maain kakwetɨrem kakɨkepi, te hɨrak kehimɨtanem kakwet God em, ");
INSERT INTO avt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","te maain yi yeriuwesɨsek hɨrak ap kakwet miye haai em kakɨkepi kakriuwerem au. ");
INSERT INTO avt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mar im yi yewenɨn hɨm me God yeriuwe menmen maamrer netpiyem yi yisesim yatɨp mɨt em. Yi mɨt yɨrɨak menmen yapɨrwe enum mar im.” ");
INSERT INTO avt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas pɨke kenɨne mɨt miyapɨr yapɨrwe hɨrak ketpor kar ik: “Yi mɨt miyapɨr yapɨrwe, yi nɨkɨp emnep eiyɨmtau hɨm mai, yi han ekitetim! ");
INSERT INTO avt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Menmen mɨt nanɨm mamno tu kɨr hɨram ap menip God kaktɨp mɨt hɨr enun au. Menmen mekre han ke mɨt hɨram meweikɨn han kɨr hɨram menip God hɨrak kaktɨp mɨt hɨr enun. ");
INSERT INTO avt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Neimɨn hɨr enɨrtei hɨr nanɨmtewem.” ");
INSERT INTO avt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Maain hɨrak epei kɨnaaiwɨr mɨt hɨrak ken wɨnak ken nɨmɨn ein, mɨt nɨrak nises hɨm mɨrak hɨr nitɨwekhi me hɨm nɨpaa hɨrak ketpim. ");
INSERT INTO avt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hɨrak kenemyor naan ketpor kar ik: “Yi wen yepɨtariyem yar ke mɨt ein a? Yi yepɨtari menmen hɨram mamno hɨm ke mɨt hɨram menip God hɨrak kaktɨp mɨt hɨr enun taauye! ");
INSERT INTO avt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Menmen hɨram mamno mamɨke tu kerekek maain mɨt hɨr nanɨno nanɨnerem mamno mune ne heim.” (Me hɨm im Jisas katɨp hɨrak keteiknai menmen yapɨrwe me tɨ hɨram yaaim te haiu mamɨm.) ");
INSERT INTO avt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hɨrak wen katɨp, “Menmen enum mekre han ke mɨt hɨram menip God kaktɨp hɨr enun. ");
INSERT INTO avt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Menmen mekre han ke mɨt meit nɨmɨn hɨram menipi hɨr han kitet enum, hɨr nisesan nɨrɨran, hɨr nekintɨp menmen o hɨr nenep mɨt nani. ");
INSERT INTO avt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Hɨr nari miyapɨr ne mɨt han his newenem nɨwaai netikeri, hɨr hemkre menepam enum nanɨt menmen, hɨr nɨrɨak menmen enum meit wit wit heriyai heriyai, hɨr newenɨn hɨm, hɨr nenke perke enum o paan tokik nekitet naan, hɨr han enuk neriuwe mɨt hɨr ninɨni neit menmen yapɨrwe, hɨr netpi nisesi, hɨr han kitet hɨr iuwe ninɨn mɨt han. Menmen im metike menmen ham enum. ");
INSERT INTO avt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Menmen im yapɨrwe meit nɨmɨn mekre han man hɨram menip God hɨrak kaktɨp mɨt hɨr enun.” ");
INSERT INTO avt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Maain Jisas hɨrak kekrit kɨnaaiwɨr wit ik, hɨrak kepno ken hɨn me wit Taia. Hɨrak ken kiun ein, hɨrak ken kepu wɨnak hak kɨnapen hɨr mɨt en nertei hɨrak kepu wɨnak eik, te hɨr nemtewek. ");
INSERT INTO avt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","In ek, mɨte hap nɨki pɨre herwe enuk kersɨsep, hɨre wemtau mɨt natɨpan me Jisas. Te hɨre wen wenke wɨwaai tɨ menep hɨt me Jisas. ");
INSERT INTO avt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mɨte ip hɨre pe Isrel au. Hɨre miye pɨre wina (o winiye) weit provins Sairo Finisia. Hɨre witehi Jisas hɨrak kakɨpɨr herwe kaknopɨn kakɨkeipɨn nɨki pɨre. ");
INSERT INTO avt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Te Jisas katɨp hɨrak kakinɨn kakɨkaap mɨt ne Isrel, te hɨrak ketpɨwe tok piksa kar ik: “Nɨkerek hɨr eninɨn enɨm menmen. Hɨram enum te haiu mɨt mamkin menmen me nɨkerek mamwɨrem mamno mamwet nepere rem.” ");
INSERT INTO avt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te hɨre wetpɨwek, “Ti atɨp werek Mɨtɨk Iuwe, te nepere mekorɨr menmen me nɨkerek mɨnatɨn mɨwaai tɨ.” ");
INSERT INTO avt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hɨrak ketpɨwe, “Ti atɨp werek ik, te ti pɨke eno witeik. Hɨrak herwe epei kenke kenpɨn kɨnaaiwɨr nɨki pit.” ");
INSERT INTO avt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hɨre pɨke wen witeik, hɨre wɨr nɨki pɨre wɨwaai yeno, hɨre wertei herwe epei kenke kenpɨn kekeipnɨwe. ");
INSERT INTO avt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Maain Jisas kɨnaaiwɨr wit ke Taia keit ein, hɨrak ken kewep nɨmɨn ke wit Saidon hɨrak ken menep hɨn me wit hiswiyen (10) hɨrak ken ere kiun wan ke provins Galili. ");
INSERT INTO avt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mɨt han neit mɨtɨk hak neiyɨk nen neteikɨn Jisas ek. Mɨtɨk ik hɨrak nɨkɨp toenum katɨp werek au. Teruk enuk kemerhin (o kemarkɨk). Hɨr natɨp Jisas hɨm iuwe, te hɨrak kakwis his mamɨnterik kakɨkepik. ");
INSERT INTO avt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hɨrak Jisas ketɨwekhis keriyaak keiyɨk ken ketikerek tekiyakɨt tɨnaaiwɨr mɨt yapɨrwe nererik neit ein. Te hɨrak kewis histuwak mɨrak mekre nɨkɨp mɨrak, hɨrak kenikɨn tɨmank men nin kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Te hɨrak kɨkɨam naan men niu kekin han ketpɨwek kar ik: “Efata.” Haiu meweikɨn hɨm haiu matɨp, “Ti nɨkɨp mit emnep emtau menmen.” ");
INSERT INTO avt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hɨrak nɨkɨp mɨrak menep, teruk kerek kemerhin (o kemarkɨk) epei au, hɨrak katɨp werek werek. ");
INSERT INTO avt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hɨrak Jisas ketpor hɨm iuwe te hɨr enwepyapɨr menmen im emɨt! Hɨrak kehimɨtenorem katɨp hɨr ap enɨtpim au emɨt! Te hɨr newepyapɨrem iuwe nerer wit wit heriyai heryiyai. ");
INSERT INTO avt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mɨt in han kekrit wɨsenum hɨr natɨp nar ik: “Hɨrak epei kɨrɨak menmen yapɨrwe yaaim. Hɨrak wen kɨrɨak mɨtɨk ik nɨpaa nɨkɨp to enum, hɨrak nɨkɨp menep kemtau hɨm.” ");
INSERT INTO avt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","In ek mɨt yapɨrwe nererik nan, hɨr ap neit menmen mei te nanɨm au. Te Jisas hɨrak kenɨne mɨt disaipel nɨrak ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Hi hanhan heriuwe mɨt in. Hɨr nau netikewa me wɨ wikak, te in ek menmen hɨram epei au mesi hɨr nɨnpɨ maan. ");
INSERT INTO avt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Hi eriuweti nanɨt nɨnpɨ nanɨno nɨr ein te hɨr nɨnpɨ mamɨn nanɨnkewɨn nanwaai yayiwe. Mɨt han hɨr neke yanɨmɨn nan.” ");
INSERT INTO avt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mɨt nɨrak netpɨwek nar ik: “Haiu mamwetɨr menmen hɨr nanɨm mamɨrkeik? Wit ik ek hɨrak weinɨk.” ");
INSERT INTO avt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas hɨrak kitorhi kar ik: “Menmen marmenum mepeit?” Hɨr natɨp, “Menmen hispɨnak wik(7).” ");
INSERT INTO avt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hɨrak katɨp hɨm iuwe te mɨt miyapɨr yapɨrwe hɨr nanu tɨ. Te hɨrak ketenen bret hispɨnak wik (7), hɨrak kitehi God em katɨp hɨrak yaaik. Te hɨrak kewenɨn bret kewet mɨt disaipel nɨrak em hɨr nenkerem newet mɨt yapɨrwe rem. ");
INSERT INTO avt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hɨr mɨt disaipel nɨrak wen netenen saauk ham kike. Te Jisas kitehi God em, hɨrak kewet mɨt nɨrak em ketpor hɨr enwet mɨt han em. Hɨr newetɨrem. ");
INSERT INTO avt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hɨr mɨt yapɨrwe naam menmen ere tu iuwe. Mɨt disaipel nɨrak nen neit menmen yinam wen mepeit, hɨr neiyɨm nen nemi mekre wapnake hispɨnak wik (7) mau hɨm. ");
INSERT INTO avt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mɨt miyapɨr nar 4,000 hɨr epei naam menmen im. Hɨr epei naam, hɨrak keriuweti nen. ");
INSERT INTO avt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hɨrak keriuweti nen, hɨrak ketike mɨt disaipel nɨrak hɨr nehɨn nɨniu nau bot, hɨrak kerekir wan ken kiun hɨn me distrik Dalmanuta. ");
INSERT INTO avt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","In ek mɨt han ne Farisi kerek hɨr ninɨn nises hɨm me Moses hɨr nan netike Jisas newepnak. Hɨr nenerek nitɨwekhi hɨrak kakrɨak menmen kakteiknor hɨrak God keriuwetek kan tɨ ik. Hɨr hanhan nanri han kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas kekin han ketpor kar ik: “Yenmak yi mɨt yitauhi te hi arɨak menmen hi eteikni God keriuweta hi han a? Hi hetpi werek. Hi ap te eteikni yi mɨt ne tɨ menmen mar im taau.” ");
INSERT INTO avt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hɨrak katɨp epei au, hɨrak kɨnaiwɨri kehɨn kɨniu kau bot ketike mɨt nɨrak, hɨrak kerekir wan kakno pɨnak ein. ");
INSERT INTO avt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hɨr mɨt disaipel nɨrak neit bret au, hɨr han kaa rem. Kiutɨp kɨwaai kekre bot kepeit kerekek. ");
INSERT INTO avt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bot hɨrak wen kerekir wan, hɨrak Jisas katɨp hɨm iuwe ke hɨm enum mɨt newepyapɨrem natɨp hɨram yaaim metike menmen mɨt ne mɨtɨk iuwe King Herot nɨrɨakem. Hɨrak ketpor, “Naanempre hɨras. Yi einopɨn eikeipɨn yis me mɨt ne Farisi metike yis me mɨt ne Herot.” ");
INSERT INTO avt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te hɨr natɨpan nar ik: “Haiu han kaa bret te hɨrak kenai ketpaiyem.” ");
INSERT INTO avt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas kemtau hɨr natɨpan, te hɨrak ketpor kar ik: “Yenmak te yi yatɨp yi han kaa bret a? Yi ap han kitet menmen werek werek wen au a? Han ki au to enuk a? ");
INSERT INTO avt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","“Yi nanamɨr kewi te yi yɨr menmen au. Yi nɨkɨp mewi, te yi yemtau menmen au. Yi han kaa menmen im a? ");
INSERT INTO avt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nɨpaa ein hi ewepep bret mar hispɨnak (5) me mɨt nar 5,000, yi yeit yinam mekre wapnake mau hɨm marmenum a?” Hɨr netpɨwek, “Haiu memi mar hiswiyen wik (12).” ");
INSERT INTO avt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hɨrak ketpor kar ik: “Me bret hispɨnak wik (7) me mɨt nar 4,000 yi yeit yinam yemi mekre wapnake mau hɨm marmenum a?” Hɨr netpɨwek, “Haiu meit hispɨnak wik (7).” ");
INSERT INTO avt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hɨrak ketpor, “Yi wen yepɨtari a? Hi ap heni me bret au. Hi hetpi yi einopɨn ap eiyises hɨm enum mɨt ne Farisi natɨp mɨt hɨr enisesim.” ");
INSERT INTO avt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Maain hɨr nen niun wit Betsaida. Hɨr mɨt han nari mɨtɨk nanamɨr toto hɨr neiyɨk nan nɨr Jisas, hɨr nitɨwekhi hɨm iuwe te hɨrak kakwis his mamɨnterik. ");
INSERT INTO avt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas ketenɨnwek his kariyaak ken kɨnaaiwɨr wit ken kerp pɨn eik. Hɨrak kenikɨn tɨmank men nanamɨr kɨrak, hɨrak kewis his menterik. Te hɨrak kitɨwekhi kar ik: “Ti hɨr menmen o au?” ");
INSERT INTO avt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hɨrak mɨtɨk kɨwaainaan kɨr ein ein katɨp, “Hi hɨr mɨt neke tɨ o hi hɨr nu waai?” ");
INSERT INTO avt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hɨrak Jisas pɨke kewis his mentar nanamɨr kɨrak. In ek hɨrak mɨtɨk kɨr hɨmɨn naan menmen hɨrak kɨrem werek werek yaaim. ");
INSERT INTO avt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hɨrak nanamɨr yaaik te Jisas kare kaksiuwerek kakno, hɨrak ketpɨwek kar ik: “Ti ap eno wit Betsaida eik, au emɨt! Ti eno nit en kerekek.” ");
INSERT INTO avt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Maain Jisas ketike mɨt disaipel nɨrak nen nerer wit wit me Sisaria Filipai. Hɨr wen nepno hɨrak kitehi mɨt nɨrak kar ik: “Mɨt hɨr nenewa hi keimɨn?” ");
INSERT INTO avt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mɨt nɨrak hɨr netpɨwek nar ik: “Mɨt han natɨp ti Jon kerek kɨkɨr mɨt nekre tɨpar ti pɨke hekrit heke herwe hei han. Mɨt han natɨp ti profet Ilaija ti hɨnaaiwɨr wit ke God hekiuwe han tɨ ik e. Mɨt han natɨp ti mɨtɨk profet hak nɨpaa natɨp hɨm me God newepyapɨrem natɨp mɨt em, ti pɨke hekrit heke herwe hei han.” ");
INSERT INTO avt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hɨrak Jisas kitorhi, “Te yi han kitet hi keimɨn?” Hɨrak Pita ketpɨwek, “Ti Mɨtɨk Krais kerek God kehimɨtanit kerek ti ekepai haiu mɨt keriyen.” ");
INSERT INTO avt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jisas ketpor hɨm iuwe, “Yi ap eiwepyapɨr hi keimɨn au emɨt!” ");
INSERT INTO avt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","In ek, hɨrak kinɨn ketpor kar ik: “Maain hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi yɨnk kai kakiyewo iuwe. Haairer netike mɨt iuwe pris kerek newet God menmen me mɨt, hɨr netike mɨt ninɨn nertei hɨm lo me Moses, hɨr nanɨneina te hɨr naniyep hi hahi. Te maain wɨ wikak, hi pɨke ekrit ehu.” ");
INSERT INTO avt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas katɨp hɨm kepakɨn menmen au, hɨrak kewepyapɨrem. Te Pita ketpɨwek keriyaak keiyɨnk ken pɨn eik hɨrak kenerek ketpɨwek kar ik: “Ti han kitet menmen mar im au emɨt.” ");
INSERT INTO avt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jisas keweikɨn kɨr mɨt disaipel nɨrak han te hɨrak kene Pita ketpɨwek kar ik: “Seten ti enopɨn ekeipno. Ti ap han kitet menmen har ke God han kitetim au. Ti han kitet menmen har ke mɨt keriyen.” ");
INSERT INTO avt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Maain Jisas kenɨne mɨt yapɨrwe netike mɨt disaipel nɨrak. Hɨr nan nererik nau, te hɨrak ketpor kar ik: “Neimɨn hɨr hanhan nanisɨsa nanɨmtau hɨm mai, hɨr hanhan hɨras au. Hɨr ap nehɨnhɨn enɨnaain menmen enum mamnen mamriwaank nentar hɨr nises hɨm mai. ");
INSERT INTO avt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Neimɨn nɨrɨak ek au, te hɨr nare nanu nanɨt menmen yapɨrwe, maain hɨr maain nani. Te neimɨn nani nanɨntar hɨm mai hɨr nisesim, hɨr nantikewa nanu nanɨt. ");
INSERT INTO avt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mɨtɨk hak keit menmen yapɨrwe me tɨ te hɨmɨn kɨrak hɨrak kakɨwaank, mamɨrkeik te hɨram mamkepik hɨrak kaktike God tatu werek a? Taauye! ");
INSERT INTO avt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mɨtɨk kakwet God mekam te hɨrak kakwetɨwek hɨmɨn hak yaaik kɨrak a? Taauye! ");
INSERT INTO avt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Neimɨn ne yi mɨt yi yɨnk enuk ap eitɨp mɨt enun ne tɨ ik yi yises hɨm mai, maain me wɨ hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi heit menmen me Haai merhihe mewepna, hi anen ehɨrp tɨ hetike mɨt ensel nai, hi eweikɨn sip ewet yi mɨt.” ");
INSERT INTO avt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas ketpor kar ik: “Hi etpi werek. Mɨt han nepu nepeit in hɨr nani wen au, te hɨr nanɨr menmen iuwe God kɨrɨakem mamnen hɨrak keiyɨm naanmampre mɨt kakriuwerem.” ");
INSERT INTO avt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Maain wi hispɨnak kiutɨp (6) epei men, hɨrak Jisas keithis Pita, Jems, Jon tetikerek ten mɨniu (o neiyɨp) kau niu ein. Hɨrakɨt tepu weinɨm. Mɨt han au. Hɨrakɨt tɨrek keweikɨn his keit in. ");
INSERT INTO avt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Laplap mɨrak merhɨhe mɨre hike, te hɨr mɨt ne tɨ hɨr ap te nɨrɨakem mar im taauye. ");
INSERT INTO avt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hɨrakɨt tɨr Ilaija ketike Moses, hɨrakɨt maam nɨpu te nɨpaa ein, hɨrakɨt wik tetike Jisas tewepnak. ");
INSERT INTO avt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hɨrak Pita kɨr menmen im te hɨrak katɨp Jisas kar ik: “Haai, haiu mau in hɨram yaaim. Haiu mamwep weisak wikak. Kiutɨp kit, kiutɨp ke Moses, kiutɨp ke Ilaija.” ");
INSERT INTO avt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hɨrak Pita katɨp hɨm im kentar hɨrakɨt tɨnaain te Pita kepɨtari hɨm mekak hɨrak ketpiyem, te hɨrak ketpi hɨm im o hɨm eim. ");
INSERT INTO avt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hɨrak katɨp epei au, napɨ kɨwapɨni, hɨrakɨt temtau hɨm me God meke napɨ man matɨp mar im: “Hɨrak Nɨkan kai ik hi hanhanek. Nɨkɨp emnep yi eiyɨmtau hɨm mɨrak.” ");
INSERT INTO avt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hɨram matɨp epei au, napɨ kewep ken hɨrakɨt terenaan waswas tɨr mɨtɨkɨt wik au. Hɨrakɨt tenep teit pɨke ten wit ke God. Jisas kerekek hɨrak kepu. ");
INSERT INTO avt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hɨrakɨt tekiuwe mɨniu (o neiyɨp) Jisas kewenet ketpɨwekɨt hɨrakɨt ap tewepyapɨr menmen hɨrakɨt epei tɨrem au emɨt ere maain hɨrak Mɨtɨk ke wit ke Mɨtɨk Iuwe hɨrak kaki pɨke kakɨkrit kaku. ");
INSERT INTO avt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hɨrakɨt temtau hɨm mɨrak hɨrakɨt tepakɨnek. Te hɨrakɨt titehiyakɨt menmen Jisas ketpɨwekɨtem me maain hɨrak kaki pɨke kakɨkrit kaku. ");
INSERT INTO avt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Te hɨrakɨt titɨwekhi tatɨp tar ik: “Nenmak mɨt ninɨn nertei hɨm lo me Moses hɨr natɨp Ilaija kakinɨn kaknen, te maain Mɨtɨk Krais kɨkaru kaknen?” ");
INSERT INTO avt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas ketpɨwekɨt, “Hɨrak Ilaija kakinɨn kaknen pɨke kakrɨak menmen ere werek. Te nenmak hɨr mɨt ne nɨpaa ein newis hɨm mau tɨwei me hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi yɨnk kakiyewo iuwe, mɨt hɨr nanitetaunaan a? ");
INSERT INTO avt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Te hi hetpi werek. Hɨrak Ilaija epei kan, te mɨt hɨr nerekyɨwek nises han kɨr mar ke nɨpaa mɨt newisɨm mau tɨwei. Hɨrak Jon kerekek.” ");
INSERT INTO avt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hɨrak ketpɨwekɨt epei au, hɨrakɨt tan tɨr mɨt disaipel nɨrak han. Hɨrakɨt tɨr mɨt yapɨrwe nan nererik neweiknor. Mɨt disaipel hɨr netike mɨt hɨr ninɨn nertei hɨm lo me Moses hɨr nenehan me menmen. ");
INSERT INTO avt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","In ek hɨr mɨt nɨr Jisas kan te hɨr han kekrit han yaaik nen natɨp nar ik: “Ti epei han.” ");
INSERT INTO avt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Hɨrak ketpor, “O hi epei han.” Te hɨrak kitorhi, “Yi yenehan yektaan mekam?” ");
INSERT INTO avt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mɨtɨk kiutɨp ke hɨr yapɨrwe hɨrak ketpɨwek kar ik: “Haai, hi epei hari nɨkan kai heiyɨk han. Hɨrak herwe enuk kersɨsek kewek teruk. ");
INSERT INTO avt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Me wɨ hɨrak kersɨsek, hɨrak kewɨrek kɨwaai tɨ, hɨrak nɨkan kenikɨn mar tɨwerpek, hɨrak kenip yehes mɨrak kɨkir kɨkir, yɨnk kererwo. Hi hitehi mɨt disaipel nit hɨr nanɨpɨr herwe kakno, te hɨr taauye!” ");
INSERT INTO avt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas hɨrak kemtau hɨm im te hɨrak keneri kar ik: “Yi mɨt miyapɨr kerek yi ap han ekitɨta? Wɨ marmenum hi ehu emeryi te yi han ekitɨta? Ehɨt nɨkan eiyɨk enen.” ");
INSERT INTO avt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hɨr neiyɨk nan hɨrak herwe enuk kɨr Jisas. Herwe enuk kɨr Jisas, hɨrak han enuk kersɨs nɨkan kenipek kenke kɨwaai tɨ. Nɨkan keweikɨn heriyai heriyai, hɨrak kenikɨn mar tɨwerpek. ");
INSERT INTO avt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas kitehi haai kɨrak kar ik: “Wɨ marmenum hɨrak kɨrɨak kar ik e?” Haai kɨrak ketpɨwek, “Nɨpaa hɨrak nɨkan kike ere in. ");
INSERT INTO avt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hekrit hekrit hɨrak herwe kersɨsek te hɨrak kewɨrek kekre si o kekre wan tɨpar te hɨrak kaknep hɨrekes kaki. Ti iuwe ti hertei epɨr herwe eik, te ti hanhanai ekepik.” ");
INSERT INTO avt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas hɨrak kenerek kar ik: “Ti henmak ti atɨp te hi hertei a? Keiyɨn han kitɨta hɨrak kakrɨak menmen yapɨrwe.” ");
INSERT INTO avt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Waswas haai kitehi Jisas hɨm iuwe, “Hi han kitetit iuwe au, kike keremem. Ti ekepa te hi han ekitetit iuwe.” ");
INSERT INTO avt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas kɨr mɨt yapɨrwe nesiuknen nan nererik neweiknɨwek nanɨrek, hɨrak kene herwe enuk ketpɨwek kar ik: “Ti herwe enuk hersɨsek hewek teruk hemesɨsɨwek nɨkɨp paan toto, hi hetput hɨm iuwe ti etpaan eno ekeipnɨwek ap pɨke eno ekrerek au ekɨt. Ti enopɨn.” ");
INSERT INTO avt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hɨrak herwe kekre nɨkan hɨrak kenepɨp pɨke kenep nɨkan, hɨrak kaa keperper, hɨrak herwe kenpɨn kekeipnɨwek ken. Hɨrak nɨkan kɨwaai kɨre mɨtɨk epei kaa, te mɨt yapɨrwe natɨp, “Hɨrak epei au kaa.” ");
INSERT INTO avt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Te Jisas keriyɨwek his men niu kari nɨkan hɨrak kekrit. ");
INSERT INTO avt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Maain hɨrak ken wɨnak nɨmɨn ein, hɨr mɨt disaipel nɨrak nitɨwekhi nar ik: “Menmak te haiu ap mepɨrek ken au a?” ");
INSERT INTO avt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas hɨrak ketpor, “Yi yepɨr herwe enuk kar ik yeriuwe menmen ham au. Prea keremem.” ");
INSERT INTO avt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Maain hɨr nɨnaaiwɨr wit ik, hɨr nen nitet yayiwe neke nɨmɨn ke provins Galili, te hɨrak kɨnapen mɨt yapɨrwe hɨr nanɨrteiyek. ");
INSERT INTO avt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Hɨrak kɨnapen kentar hɨrak hanhan katɨp mɨt disaipel nɨrak hɨm mɨrak. Hɨrak ketpor kar ik: “Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe mɨt han hɨr nanriuweta hi eno his me mɨt enun hɨr naniyep hi hahi. Maain, wɨ wikak, hi pɨke ahɨkrit hahu.” ");
INSERT INTO avt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hɨr han kitet hɨm mɨrak hɨr nepɨtariyem. Te hɨr nɨnaain nanitɨwekhi me menmen hɨrak ketporem. ");
INSERT INTO avt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hɨr newepnak epei au, hɨr nen niun wit Kapaneam. Hɨr epei nen wɨnak nɨmɨn ein, hɨrak kitorhi kar ik: “Nɨpaa haiu wen mɨpitet yayiwe, yi yatɨpan mekam?” ");
INSERT INTO avt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Hɨr au nekintɨp nentar nɨpaa hɨr natɨpan me hɨr hɨras keimɨn ke hɨr hɨrak kinɨni iuwe. ");
INSERT INTO avt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas kau yeno kari mɨt hiswiyen wik nɨrak (12), hɨrak ketpor kar ik: “Mɨtɨk hak kakinɨn mɨt han, hɨrak ekɨkaru ekɨkrɨak menmen mɨr weinɨm.” ");
INSERT INTO avt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hɨrak kari nɨkan kewisɨk kerp keit nɨmɨn. Hɨrak keiyewewik ketpor, ");
INSERT INTO avt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mɨt neimɨn kerek hɨr nɨkaap mɨtɨk kiutɨp kar ke nɨkan ik nentar hɨr nises hɨm mai, hɨrak kar ke hɨr nɨkaap mɨtɨk kerekek au. Hɨr nekepik ketikewa. Mɨt kerek nekepa, hɨr nekepa kerekek au. Hɨrak kar ke hɨr nekepa hetike Mɨtɨk Iuwe kerek keriuweta hi han tɨ ik.” ");
INSERT INTO avt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hɨrak Jon ketpɨwek kar ik: “Mɨtɨk Iuwe, haiu mɨr mɨtɨk hak kepɨr herwe enum kekine niuk mit, te haiu meriuwesɨsek kentar hɨrak kises hɨm mit ketikewai au. Haiu mɨt keriyen.” ");
INSERT INTO avt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas ketpor kar ik: “Yi yeriuwesɨsek au ekɨt! Mɨtɨk kerek kɨrɨak menmen yaaim iuwe kekine niuk mai, hɨrak ap te kaktɨp enum me hi waswas taau. ");
INSERT INTO avt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Neimɨn hɨr nɨrɨak menmen mar ke haiu mɨrɨakem, hɨr naiu yinan. ");
INSERT INTO avt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Hi hetpi werek. Mɨt han nekepi, hɨr neweti tɨpar mei yi yayɨm yentar yi yises hɨm me hi Krais, God hɨrak ap han kaa menmen im au. Maain hɨrak kakwetɨr menmen yaaim. ");
INSERT INTO avt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mɨtɨk hak kakrɨak nɨkan hak ke nɨkerek yapɨrwe in hɨr han kitɨta kar ik, te hɨrak keweikɨn han kɨrak te hɨrak kakrɨak enum, hɨrak yaaik te mɨt han hɨr nankaaip nan kariyɨwek teruk hɨr nanwɨrek kakno kakɨkre wan kaki te maain hɨrak ap kakrɨak menmen ham enum te God han enuk wɨsenuk kakɨwaankek kakɨkre si. ");
INSERT INTO avt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ti hɨrɨak menmen enum heriuwe his mit te ti eremir meiyam pɨnam ewɨrem. Ti eremir meiyam pɨnam ewɨrem hɨram enum kike mentar ti ap erɨak menmen enum ti etike God yi eiyu eiyɨt tipmain tipmain enum eik. Te ti his mit wik mepwit ti erɨak menmen enum ere ti eno si tatɨknenit te ti ehu en tipmain tipmain enum eik, hɨram menmen enum iuwe. ");
INSERT INTO avt_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ti eno wit enuk ik, henek hɨram mamɨk yɨnk ki hɨrak kaki au, si mami au mamu tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ti hɨrɨak menmen enum heriuwe hɨt mit, te ti eremir meiyam pɨnam ewɨrem. Ti hɨt miutɨp keremem mepwit hɨrak enum kike. Ti etike God yi eiyu eiyɨt tipmain tipmain enum eik. Te ti hɨt mit wik mepwit ti erɨak menmen enum ere ti eno si tatɨknenit ti ehu tipmain tipmain enum eik, hɨram enum wɨsenum. ");
INSERT INTO avt_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ti eno wit enuk ik, henek hɨram mamɨk yɨnk ki hɨrak kaki au, si mami au mamu tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ti hɨrɨak menmen enum heriuwe nanamɨr kit, te ti eket keiyak ewɨrek. Ti nanamɨr keiyak kiutɨp kepwit hɨrak enuk kike. Ti hetike God yi eiyu eiyɨt tipmain tipmain enum eik. Te ti nanamɨr wik kepwit te ti hɨrɨak menmen enum ere ti eno si tatɨknenit ti ehu tipmain tipmain enum eik, hɨram enum iuwe. ");
INSERT INTO avt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ti eno wit enuk ik, ‘henek hɨram mamɨk yɨnk ki hɨrak kaki au kaku, si mami au mamu tipmain tipmain enum eik.’ ");
INSERT INTO avt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sol (o siyak) mamno mamɨkre menmen mamnipem hɨram yaaim mamtɨn hɨm. Mar im menmen enum kerek mewaank mɨt, hɨram mamkepi yi yayɨr ke mɨt yaain. ");
INSERT INTO avt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol hɨram menmen yaaim. Hɨram merekir nin au, hɨram enum mɨre tɨpar harɨk, te yi yarkeik eirɨakem te hɨram pɨke mamrekir nin a? Taauye! Yi yɨre sol (o siyak) yi han kitet menmen yaaim te yi eitike mɨt han yi eikiyan eiyu eiyɨt.” ");
INSERT INTO avt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Maain Jisas kɨnaaiwɨr wit Kapaneam hɨrak ken kiun hɨn me provins Judia. Te hɨrak ken kerekir mani Jodan ken pɨnak kerek wepni kekai kan. Hɨr mɨt yapɨrwe ne wit yapɨrwe pɨke nan nererik nanɨrek. Hɨrak pɨke ketpor kar kerek nɨpaa ein hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hɨr mɨt han ne Farisi kerek ninɨn nises hɨm me Moses, hɨr nan niun Jisas newisesik, hɨr nitɨwekhi nar ik: “Hɨm lo me maamrer hɨram mewis mɨtɨk hak kepɨr mɨte pɨrak hɨre wauno waunaiwɨrek o au?” ");
INSERT INTO avt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas hɨrak kinɨn kitorhi hɨm ham kar ik: “Hɨm me Moses hɨram matɨp mekam?” ");
INSERT INTO avt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hɨr natɨp, “Hɨm me Moses mewis mɨtɨk hɨrak kewis tɨwei kakwet mɨte pɨrak ek, te hɨrak kakpɨrep wauno.” ");
INSERT INTO avt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas ketpor kar ik: “Hɨrak Moses kewis hɨm im mentar yi mɨt enun han to enuk. ");
INSERT INTO avt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nɨpaa enum eik God kɨrɨak tɨ ketike menmen yapɨrwe, hɨrak kewis mɨtɨk ketike mɨte pɨrak. ");
INSERT INTO avt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mar ik te mɨtɨk hak kaknaiwɨr miye haai nɨrak, hɨrak kaktike mɨte nanu nanɨt, ");
INSERT INTO avt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hɨr nankiyan nanu nanɨr ke yɨnk kiutɨp. Hɨr wik au, hɨr nɨre niutɨp. ");
INSERT INTO avt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Te mɨtɨk mɨte God kerekyor hɨr neitan, hɨr mɨt han ap te nanriuwetep wauno waunaiwɨrek taau.” ");
INSERT INTO avt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Maain hɨr mɨt nɨrak netikerek nau wɨnak neit nɨmɨn ein, hɨr nitɨwekhi me menmen im. ");
INSERT INTO avt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Te Jisas ketpor kar ik: “Mɨtɨk hak kepɨr mɨte pɨrak kakɨt mɨte hap, hɨrak kɨrɨak enum me mɨte winɨn nɨpaa hɨrak ketɨwe. ");
INSERT INTO avt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mar keremem, mɨte piutɨp waunaaiwɨr mɨtɨk kɨre wawɨt mɨtɨk hak, hɨre wɨrɨak enum me mɨtɨk kinɨn nɨpaa hɨre wetɨwek.” ");
INSERT INTO avt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mɨt han neriuwet nɨkerek nɨr nanɨr Jisas te hɨrak kakwis his mamɨnteri kakɨtpor hɨm yaim. Te mɨt disaipel nɨrak hɨr neneri. ");
INSERT INTO avt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas kɨr menmen im, hɨrak han enuk katɨp mɨt disaipel nɨrak kar ik: “Yi eiwis nɨkerek hɨr nanɨnen in. Yi ap eiweni au emɨt! Hɨr mɨt kerek God hɨrak naanmɨpror hɨr nar ke nɨkerek in. Hɨr hanhana. ");
INSERT INTO avt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Hi hetpi werek. Mɨt kerek hɨr hanhan God hɨrak naanmampri, hɨr nanises hɨm mɨrak nanɨr ke nɨkerek in hɨr nises hɨm me miye haai nɨr, o au en, hɨr ap te nanu nantike God taau!” ");
INSERT INTO avt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hɨrak katɨp epei au, hɨrak kewis his mɨrak menteri hɨrak ketpor hɨm mɨrak yaaim. ");
INSERT INTO avt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Menep te Jisas kaknaaiwɨr wit ik kakno, mɨtɨk hak kesiuknen kan kɨr Jisas kewen ninɨp kitɨwekhi kar ik: “Mɨtɨk Iuwe Yaaik. Hi arɨak mekam te hi ehɨt hɨmɨn yaaik hi etike God hawɨr ewu tipmain tipmain enum eik?” ");
INSERT INTO avt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas ketɨwekhi kar ik: “Ti henmak te ti atɨp hi Mɨtɨk Iuwe yaaik a? Hɨrak God kiutɨp kerekek hɨrak Mɨtɨk Iuwe Yaaik. ");
INSERT INTO avt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ti hertei hɨm God ketpaiyem. ‘Ti ap enep mɨt nani au, ti ewaai etike miyapɨr ne mɨt han au. Ti ap ekintɨp menmen me mɨtɨk hak au. Ti ap ewises mɨt han ek au. Ti naanempre miye haai nit ekepi.’” ");
INSERT INTO avt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hɨrak katɨp Jisas kar ik: “Mɨtɨk Iuwe, hi hisesim, hi kike ere in.” ");
INSERT INTO avt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas kɨpɨrek hɨrak hanhanek ketpɨwek kar ik: “Menmen miutɨp wen mewenɨnit ti hises hɨm me God werek werek. Ti eno esiuwe menmen yapɨrwe mit ti ewet mɨt em weinɨm, te maain menmen mit yaaim mamu wit ke God. Ti esiuwerem epei au, ti enen ehisɨsa.” ");
INSERT INTO avt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mɨtɨk hɨrak kemtau hɨm im, hɨrak han kekrit pɨke ken hɨrak kine han enuk kentar hɨrak ketenen menmen yapɨrwe kɨnapen kakwet mɨt em weinɨm. ");
INSERT INTO avt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas kɨwaainaan katɨp mɨt disaipel nɨrak kar ik: “Hɨram hat tru te mɨt kerek netenen menmen yapɨrwe te hɨr nanwis God naanmɨpri.” ");
INSERT INTO avt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Hɨr mɨt disaipel nɨrak nemtau hɨm mɨrak, hɨr nehɨnhɨn neriuwerem, te hɨrak wen ketpor, “Pipep nai, hi hetpi. Hɨram hat tru te mɨt hɨr nanɨno wit ke God nanu nantikerek. ");
INSERT INTO avt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hɨrak miyak kamel (hɨrak iuwe kɨre hos) kakno kakitet hei me tɨk mɨt nekerwo menmen neriuwerem hɨrak ap hat wok iuwe mar ke mɨt netenen menmen yapɨrwe hɨr hanhan nanises hɨm me God te hɨrak naanmampri.” ");
INSERT INTO avt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mɨt disaipel nɨrak nemtau hɨm im, te hɨr han kekrit nitehiyan nar ik: “Hɨram hɨm mar im, te neimɨn hɨr nantike God nanu nanɨt hɨrak naanmampri a? Taauye!” ");
INSERT INTO avt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas kɨpɨri ketpor, “Hɨr mɨt ne tɨ ap te nanrɨak menmen miutɨp hɨr nankaap hɨras, te hɨr nanɨt hɨmɨn yaaik hɨr nantike God nanu. God kerekek. Hɨrak God kertei menmen yapɨrwe hɨrak kakrɨakem kakɨkaap mɨt kakriuwerem.” ");
INSERT INTO avt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita hɨrak ketpɨwek kar ik: “Haiu mɨnaaiwɨr menmen yapɨrwe misesit.” ");
INSERT INTO avt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas hɨrak katɨp, “Hi hetpi werek. Mɨt miyapɨr kerek nɨnaaiwɨr witeik, o heiyiuwe o kikrek o yenten o miye haai o nɨkerek nɨr nentar hɨr nisɨsa hetike hɨm mai yaaim, hɨr nanu tɨ nanɨt 100 witeik, ");
INSERT INTO avt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","heiyiuwerer, kikrek, yenterer miyerer haairer, nɨkerek nɨr netike tɨ meiyam. Te hɨr mɨt nanrekyor enum enum nanɨntar hɨr nises hɨm mai. Maain, hɨr nanɨt hɨmɨn yaaik hɨr nantike God nanu nanɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","In ek mɨt kerek hɨr ninɨn, maain hɨr nankaru. In ek hɨr mɨt kerek hɨr nɨkaru o hɨr mɨt weinɨn, maain hɨr iuwe naninɨn mɨt han.” ");
INSERT INTO avt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hɨr wen nitet yayiwe nepno wit Jerusalem, Jisas kinɨni ken. Mɨt disaipel nɨrak hɨr nertei mɨt iuwe neit Jerusalem hɨr hanhan nankɨp kaki, te hɨr han kekrit. Mɨt miyapɨr han kerek nisesik, hɨr nɨnaain. Jisas hɨrak pɨke kerp kemerɨr mɨt disaipel nɨrak nar hiswiyen wik (12), hɨrak ketpor menmen maain mɨt neit Jerusalem hɨr nanrekyɨwekem. ");
INSERT INTO avt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hɨrak ketpor kar ik: “Nɨkɨp emnep yi eiyɨmtau! Haiu mamno Jerusalem. Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, mɨt iuwe pris kerek newet God menmen me mɨt, hɨr nantike mɨt ninɨn nertei hɨm lo me Moses, hɨr nantauhis hɨr nehimɨtena hi hahi, hɨr nanriuweta hi eno his me mɨt han hɨr ap ne Isrel, te hɨr naniyep hi hahi. ");
INSERT INTO avt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hɨr nanitɨtaunaan hɨr nanɨnikɨn tɨmank mamɨntera, hɨr nanwaai nɨpɨn naniyep. Hɨr naniyep hi hahi, te maain wɨ wikak epei men, hi pɨke hahɨkrit hahu.” ");
INSERT INTO avt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jems ketike Jon hɨrakɨt nɨkerek hɨrakɨt te mɨtɨk niuk mɨrak Sebedi hɨrakɨt ten tɨrapɨt Jisas tetpɨwek tar ik: “Mɨtɨk Iuwe, hawɨr hanhan (o weikɨkit) menmen hawɨr wituthiyem.” ");
INSERT INTO avt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Hɨrak ketpɨwekɨt, “Hi herekyi mekam?” ");
INSERT INTO avt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hɨrakɨt tetpɨwek tar ik: “Ti ewisawɨr maain ti naanmampre mɨt, hawɨr wautikewit hawɨr waukepit naanmampre mɨt hawɨr wawu menep his yaaim metike his henkik mit.” ");
INSERT INTO avt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hɨrak ketpɨwekɨt kar ik: “Yi yepɨtari yi yitauhi menmen wɨsenum. Yi te eiwis menmen enum mamnen mamiwep mamɨr ke menmen enum hɨram mamnen mamiyep o au?” ");
INSERT INTO avt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hɨrakɨt tewenhi tar ik: “O, hawɨr werteiyem.” Jisas ketpɨwekɨt, “Maain menmen enum mamiwep mamɨr ke hɨram mamiyep. ");
INSERT INTO avt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Te hi ewisi yi eitikewa naanmampre mɨt te yi yau menep his yaaim o his henkik mai au. Hi taau. Mɨt han kerek God Haai kehimɨteni, maain hɨr keriyen nanu ein nantikewa naanmampre mɨt.” ");
INSERT INTO avt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hɨr mɨt disaipel han nar hiswiyen (10) nemtewem, hɨr han enuk neriuwe Jems ketike Jon. ");
INSERT INTO avt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Te Jisas hɨrak kari mɨt disaipel nɨrak ketpor kar ik: “Yi yertei mɨt kerek ninɨn mɨt naanmɨpror hɨr nenipi hɨr enises han kɨr. ");
INSERT INTO avt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Te yi ap eirɨak menmen emɨr im au emɨt. Keimɨn ke yi hɨras kakre iuwe kakinɨni, te hɨrak kakrɨak menmen mi. ");
INSERT INTO avt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Keimɨn ke yi hɨras hanhan kakinɨni kakre mɨtɨk iuwe, te hɨrak ekrɨak menmen mi weinɨm. ");
INSERT INTO avt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi ap han te hɨr mɨt nanrɨak menmen mai au, taauye! Hi han te hi arɨak menmen me mɨt hi akepi. Hi hahi te hi akepi yi mɨt ne tɨ yapɨrwe. Hi akepi atihis te God kakiwep au. Hɨrak kaktɨp yi yaain.” ");
INSERT INTO avt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hɨr nen niun wit Jeriko. Maain Jisas epei kaknaaiwɨr wit ik kaktike mɨt nɨrak, hɨr nitet yayiwe netike mɨt yapɨrwe. Hɨrak mɨtɨk Batimias nanamɨr toto hɨrak nɨkan ke Timias, hɨrak kau yayiwe kitehi mɨt nanwetɨwek pewek me menmen hɨrak kakɨm. ");
INSERT INTO avt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hɨr mɨt netpɨwek Jisas ke wit Nasaret epei kan, te hɨrak kɨnap kenɨnewek kar ik: “Jisas ti Nepenyek ke maam nɨpu iuwe Devit, ti han etwenɨna ekepa.” ");
INSERT INTO avt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hɨr mɨt yapɨrwe nenerek netpɨwek hɨrak kekintɨp, te hɨrak au. Hɨrak kɨnap kenɨnewek hɨm iuwe ham kar ik: “Nepenyek ke Devit, ti han etwenɨna ekepa.” ");
INSERT INTO avt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas hɨrak kerp ketpor kar ik: “Enɨnewek eiyɨk einen.” Te hɨr nenɨne mɨtɨk ik nanamɨr toto hɨr netpɨwek nar ik: “Ti han yaaik ehu. Ekrit. Hɨrak epei kenɨnut.” ");
INSERT INTO avt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hɨr netpɨwek te hɨrak kenke saket kewɨrem mɨwaai tɨ, hɨrak kɨn kekrit kerp ken kiun Jisas. ");
INSERT INTO avt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas kitɨwekhi kar ik: “Ti hanhan hi erekyut mekam?” Mɨtɨk enuk nanamɨr toto ketpɨwek kar ik: “Mɨtɨk Iuwe, ti ekepa hi ahɨr ein ein.” ");
INSERT INTO avt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas ketpɨwek, “Ti eno we. Ti epei han kiteta hi ekepit, te ti ehu werek.” In ek kerekek hɨrak kɨr ein ein kisesik ken yayiwe eik. ");
INSERT INTO avt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Maain hɨr epei nen menep wit Jerusalem, hɨr nerp wit Betfasi menep mɨniu (o neiyɨp) mɨt nenewek neiyɨp ke nu Oliv. Te Jisas hɨrak keriuwet mɨtɨkɨt disaipel tɨrak wik, ");
INSERT INTO avt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hɨrak ketpɨwekɨt kar ik: “Yi eino wit kike pɨnak eik e. Yi eirekir wit kau nɨmɨn kike, te yi eiyɨr donki nɨkik (hɨrak kɨre hos) mɨt hɨr nekaaip waai kau teruk kɨrak kiyau nu. Mɨt hɨr nau sip kɨrak wen au. Yi eisiupanek eiyɨk einen. ");
INSERT INTO avt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mɨt han hɨr nanitihi, ‘Yi yɨrɨak menmen im yenmak?’ te yi eiyɨtpor eiyɨr ik: ‘Hɨrak Mɨtɨk Iuwe kaiu kare hanhanek kaktɨwek.’ Yi eiyɨtpor eiyɨr ek, te hɨr nanɨsiuwerek kaknen waswas.” ");
INSERT INTO avt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Te hɨrakɨt ten tɨr hos nɨkik keit weipɨr ke wɨnak, te hɨrakɨt tesiupanek. ");
INSERT INTO avt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mɨt han nerp menep nitɨwekɨthi nar ik: “Yi yenmak te yi yesiupan donki ik ek?” ");
INSERT INTO avt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hɨrakɨt tetpor menmen nɨpaa Jisas ketpɨwekɨt, te hɨr newisɨkɨt hɨrakɨt teiyɨk ten. ");
INSERT INTO avt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hɨrakɨt teit donki teriyaak teiyɨk ten Jisas. Hɨr mɨt disaipel nɨrak newis saket mɨr (hɨram mɨre laplap) mɨwaai menterik. Te Jisas kewik. ");
INSERT INTO avt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hɨr mɨt yapɨrwe newis saket mɨwaai tɨ neses yayiwe neriuwerem. Mɨt han hɨr neremir nu heneik neiyɨm nen newisɨm mɨwaai yayiwe kerek hɨr netɨwem me ni me yayiwe pɨnak pɨnak. ");
INSERT INTO avt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hɨr mɨt han ninɨn nen netike mɨt han nisesik hɨr nɨnap natɨp nar ik: “Haiu emwenɨpi God. Mɨtɨk ik hɨrak kekrehɨr ke God te haiu hanhan God hɨrak kakrekyɨwek yaaim naanmamprewek. ");
INSERT INTO avt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God kakɨkaap mɨtɨk ik hɨrak menep kakinɨn naanmamprai haiu mɨt kar ke nɨpaa maam nɨpu kaiu Devit kinɨn naanmɨre maamrer naiu. God hɨrak yaaik iuwe!” ");
INSERT INTO avt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas hɨrak ken kiun wit Jerusalem hɨrak ken kɨnɨk wɨnak iuwe ke God ein. Epei hɨnkewɨ, te Jisas kerenaan kɨr menmen, hɨrak pɨke ken wit eik, hɨrak ketike mɨt disaipel nɨrak nar hiswiyen wik (12) hɨr pɨke nen wit Betani. ");
INSERT INTO avt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Teip hekrit, hɨrak kɨnaaiwɨr wit Betani, Jisas nɨnpɨ maak kepno. ");
INSERT INTO avt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hɨrak kɨr nu fik kerp yanɨmɨn ein, te hɨrak ken kakɨr nu nɨkim mari mewik o au. Tɨwei weinɨm keremem. Hɨrak ap wepni yaaik wen au. ");
INSERT INTO avt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Te hɨrak ketpɨwek kar ik: “Maain ti ap ari eine nu nɨkim meiyam au.” Mɨt disaipel nɨrak nemtewek hɨrak katɨp. ");
INSERT INTO avt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hɨr nen niun wit Jerusalem, Jisas hɨrak ken kekre wɨnak iuwe ke God. Te hɨrak kepɨr mɨt kerek nesiuwe menmen neit pewek mererim. Epei au, hɨrak kepɨr mɨt kerek neit menmen newet God em nekre wɨnak iuwe ke God. Hɨrak keweikɨn kɨnaan me mɨt enun hɨr nekrehɨr pewek me mɨt ne wit ham. Hɨrak keweikɨn yeno me mɨt enun hɨr nesiuwe hore tapɨ men mɨt pris kerek newet God em. ");
INSERT INTO avt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hɨrak ap kewis mɨt hɨr nɨnan menmen meit wɨnak iuwe ke God nɨmɨn ein, au! ");
INSERT INTO avt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Epei au, hɨrak ketpor hɨm kar ik: “Yi ap yertei hɨm mau tɨwei me God matɨp mar ik: ‘Yi yertei wɨnak kai hɨrak kɨre wɨnak ke mɨt ne wit yapɨrwe hɨr nanɨnen nanwenanɨpi nanitauhi menmen nanɨt nɨmɨn a?’ Te yi mɨt yɨrɨakek kar ke wɨnak ke mɨt enun nekintɨp menmen.” ");
INSERT INTO avt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hɨr mɨt iuwe Pris kerek ninɨn naanmɨpre pris han, hɨr netike mɨt hɨr ninɨn nertei hɨm me Moses, hɨr nemtewek te hɨr nimenɨpɨn Jisas nankɨp nanɨrkeik. Hɨr nɨneinɨk nentar mɨt yapɨrwe hɨr han yaaik nanɨmtau hɨm me Jisas. ");
INSERT INTO avt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Maain menep wɨtaan, Jisas hɨrak ketike mɨt disaipel nɨrak hɨr nɨnaaiwɨr wit nen. ");
INSERT INTO avt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wanewik hɨr pɨke nanɨno wit Jerusalem, hɨr nesipaat nu Fik. Hɨrak keweiwei kaa. ");
INSERT INTO avt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Hɨrak kɨrek te Pita han kitet menmen Jisas nepɨp ketpim. Te hɨrak ketpɨwek kar ik: “Mɨtɨk Iuwe, nepɨp ti hatɨp nu fik ik enum, te hɨrak epei kaa.” ");
INSERT INTO avt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hɨrak Jisas katɨp mɨt disaipel nɨrak kar ik: “Yi han kitet God. ");
INSERT INTO avt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hi etpi werek. Mɨt han nantɨp mɨniu (o neiyɨp) ik, ‘Ekrit eno emɨn wan eik,’ hɨr ap han kitet wik au, hɨr han kitet menmen hɨram mamnen mamɨr ke nɨpaa hɨr natɨp, menmen mamnen mamɨr im e. ");
INSERT INTO avt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Te hi hetpi werek. Menmen yi yitehi God em, yi han kitet yi eitɨwem, maain yi eiyɨt menmen mamɨr im. ");
INSERT INTO avt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Me wɨ yi eiyɨrp wɨnak ke God, yi eiyitehi God me menmen, yi eiyɨrtei mɨtɨk hak yi han enuk eiriuwerek, yi ap han ekitetim emɨt, te Haai kit God keit wit kɨrak hɨrak kakɨsak menmen enum yi yɨrɨakem hɨrak ap han ekitetim au. ");
INSERT INTO avt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yi wen han ekitetim, te God ap kakɨsak menmen enum yi yɨrɨakem, au emɨt!” ");
INSERT INTO avt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hɨrak katɨp epei au, hɨr pɨke nan Jerusalem. Hɨrak keke tɨ kitet wɨnak ke God keit nɨmɨn ein, mɨt iuwe kerek ninɨn mɨt pris kerek newet God menmen, hɨr netike mɨt ninɨn nertei hɨm lo me Moses, hɨr netike mɨt kerek hɨr niuk mɨr iuwe, hɨr nen nɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hɨr nitɨwekhi nar ik: “Keimɨn keriuwetit ti hɨrɨak menmen heit in?” ");
INSERT INTO avt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas hɨrak ketpor kar ik: “Hi itihi menmen ham. Yi yayɨtpo te hi etpi keimɨn keriuweta hi han hɨrɨak menmen im. ");
INSERT INTO avt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hɨrak keimɨn keriuwet Jon hɨrak kɨkɨr mɨt neriuwe tɨpar? Hɨrak God o Jon hɨrekes han kitetim?” ");
INSERT INTO avt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hɨr natɨpan nar ik: “Haiu mamtɨp God hɨrak keriuwetek kan in, te hɨrak kakɨtpai, ‘Yenmak te yi yemtau hɨm mɨrak au?’ ");
INSERT INTO avt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Haiu mamtɨp hɨrekes han kitetim keremem, te hɨr mɨt in nanweikɨn sip nanwetai.” (Hɨr mɨt iuwe nɨnaain mɨt nererik nan nentar hɨr mɨt yapɨrwe han kitet God keriuwet Jon te hɨrak katɨp mɨt hɨm mɨrak.) ");
INSERT INTO avt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hɨr natɨpan epei au, hɨr natɨp Jisas nar ik: “Haiu ap merteiyek au.” Te Jisas hɨrak ketpor, “Yi eiyɨtpo keimɨnek au, te hi ap te etpi keimɨn keriuweta hi han hɨrɨak menmen im. Taauye!” ");
INSERT INTO avt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas wen kepu wɨnak iuwe ke God, hɨrak katɨp mɨt miyapɨr en hɨm mɨre tok piksa kar ik: “Nɨpaa mɨtɨk hak kamɨr ni me waai wain nɨkim. Hɨrak kime nɨwa me nan keseniuwem, hɨrak kekin hei kewis yemtɨ iuwe, te hɨrak kakɨntɨrer wain tɨpar, hɨram mamɨkiuwe hei mɨram. Epei au, hɨrak kime kɨnaan iuwe nokim, te mɨt hɨr nanwim nanɨr mɨt enun nanɨnen nankintɨp menmen. Hɨrak kewis mɨt han hɨr naanmɨprewem. Hɨr naanmɨprewem, hɨrak ken wit hak yanɨmɨn. ");
INSERT INTO avt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Maain wain nɨkim mɨram mewɨnki, hɨrak haai ke ni im e hɨrak keriuwet mɨtɨk kɨrak ken kakɨr mɨt nɨpaa naanmɨpre ni mɨrak, hɨrak kakɨt nɨkim me waai im. ");
INSERT INTO avt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Te hɨr mɨt netenenik nakɨp pɨke nesiuwerek kehis ken. ");
INSERT INTO avt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Maain haai ke ni im hɨrak pɨke keriuwet mɨtɨk hak, te hɨr nenep paan kɨrak nerekyɨwek enum. ");
INSERT INTO avt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Maain hɨrak keriuwet mɨtɨk hak, te hɨr nakɨp kaa. Te hɨrak keriuwet han, hɨr nɨrɨakem narek narek. Mɨt han hɨr naa, mɨt han au. ");
INSERT INTO avt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hɨrak wen ketenen kiutɨp, hɨrak nɨkan kɨrak. Maain hɨrak kesiuwerek kɨkaru ken. Hɨrak han kitet kar ik: “Hɨr nanɨmtau hɨm mɨrak.” ");
INSERT INTO avt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hɨr mɨt nɨrek te hɨr natɨpan nar ik: “Ik ek kakɨt menmen me haai kɨrak. Haiu emkɨp kaki te haiu mamɨt menmen me haai kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hɨr natɨp nar ek, hɨr netenenik nakɨp kaa, hɨr newɨr yɨnk kɨrak keit witeik. ");
INSERT INTO avt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Hɨrak mɨtɨk kerek kamɨr ni hɨrak kakrɨak mekam? Hɨrak kaknen kaknep mɨt enun in nani, hɨrak kakwis mɨt han naanmampre ni mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yi ap yertei werek werek hɨm me God mɨt nisesɨm mau tɨwei hɨram matɨp mar im: ‘Nu teinɨk kerek mɨt nime wɨnak hɨr nɨneinɨk, hɨrak kerekek kaku kakre teinɨk mɨtɨk. ");
INSERT INTO avt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","God hɨrekes kɨrɨakem, te haiu mɨt han kitet hɨram yaaim.’” ");
INSERT INTO avt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hɨr mɨt iuwe ne Isrel neit wɨnak iuwe ke God nansiuwe mɨt nantenen Jisas te hɨr nɨnaain mɨt yapɨrwe nererik neit ein. Hɨr nertei hɨrak kesiuwor hɨm keriuwe hɨm tok piksa im em. Te hɨr nɨnaiwɨrek nen. ");
INSERT INTO avt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Maain mɨt iuwe neriuwet mɨt han ne Farisi kekek ninɨn nises hɨm me Moses netike mɨt kerek nises hɨm me Herot te hɨr nan nanri han ke Jisas. ");
INSERT INTO avt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hɨr nan niun Jisas hɨr nitɨwekhi nar ik: “Mɨtɨk iuwe, haiu mertei ti mɨtɨk yaaik. Ti atɨp werek, ti han kitet haiu mɨt yapɨrwe mɨpɨran. Ti ewepyapɨr hɨm me God hatɨp haiu mɨt miyapɨr em keremem. Te ti etpai. Hɨm me Moses kewisai haiu mamwɨr pewek me takis mamno mɨtɨk iuwe ke Rom niuk mɨrak Sisa o au? Haiu emwɨrem o au?” ");
INSERT INTO avt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jisas hɨrak kertei hɨr newenɨn hɨm nanri han kɨrak neriuwerem, te hɨrak ketpor kar ik: “Yi yenmak te yi yaiwisɨsewek yairi han kai a? Yi yayɨt pewek kei kiutɨp eiyɨk einen hi ehɨrek.” ");
INSERT INTO avt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hɨr newetɨwek neiyɨk nan newetɨwekem, hɨrak kɨrem. Te hɨrak ketpor kar ik: “Ninaan me keimɨn im e? Keimɨn niuk mɨrak mewik?” Hɨr natɨp nar ik: “Mɨtɨk Iuwe Sisa kerekek.” ");
INSERT INTO avt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Te Jisas hɨrak ketpor, “Yi eiwet Sisa pewek me takis mɨrak, te eiwet God menmen mɨrak.” Hɨr nemtewek, hɨr han kekrit neriuwerek. ");
INSERT INTO avt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Maain kike mɨt han nises hɨm me Sadyusi hɨr nan. Hɨr han kitet mɨt hɨr naa maain hɨr pɨke nanɨkrit au. Hɨr nen niun Jisas nitɨwekhi nar ik: ");
INSERT INTO avt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mɨtɨk Iuwe, Moses hɨrak kewis hɨm mar im: ‘Mɨtɨk hak kaki, te mɨte pɨrak wepu, hɨre wine nɨkerek wen au, mɨtɨk heiyiuwe o nɨkik kaktɨwe, hɨr naniyewan hɨre wawine nɨkerek ne mɨtɨk epei kaa.’ ");
INSERT INTO avt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nɨpaa mɨt hispɨnak wik (7) ne haai kiutɨp hɨr nepu. Hɨrak iuwe mɨtɨk keit mɨte, te hɨrak kaa ap kine nɨkerek nei au. ");
INSERT INTO avt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Maain nɨmɨnek ketɨwe hɨrak kaa ap kine nɨkerek nei au. ");
INSERT INTO avt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hɨr narek narek kike yiu ketɨwe kaa. Maain mɨte ip hɨre waa. ");
INSERT INTO avt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Maain hɨr mɨt yapɨrwe pɨke nanɨkrit nanu, hɨre waure mɨte pe keimɨn? Hɨr mɨt hispɨnak wik (7) nɨpaa epei netɨwe ye!” ");
INSERT INTO avt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas ketpor kar ik: “Yi yetari menmen yentar yi yepɨtari hɨm me God metike menmen mɨrak iuwe. ");
INSERT INTO avt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maain, hɨr mɨt pɨke nanɨkrit, hɨr nanɨt miyapɨr au. Miyapɨr nanɨt mɨt au. Hɨr nanu nanre mɨt ensel ne wit ke God. ");
INSERT INTO avt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ne mɨt hɨr pɨke nanɨkrit, yi ap yekine hɨm Moses kewisɨm me nu tɨwei hɨrak si taak ap kaa a? Hɨrak God katɨp Moses kar ik: ‘Hi God ke Ebraham, Aisak tetike Jekop.’ ");
INSERT INTO avt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hɨrak God ke mɨt epei naa neit au. Hɨrak God ke mɨt hɨr nepu. Hɨr naa neit au, hɨr nepu. Yi yepɨtari a?” ");
INSERT INTO avt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mɨtɨk kiutɨp ke mɨt kerek hɨr ninɨn nertei hɨm me Moses natɨp mɨt em, hɨrak kan kemtau mɨt hɨr natɨpan nenehan, hɨrak kertei Jisas ketpor werek werek. Te hɨrak kitɨwekhi kar ik: “Hɨm mekam hɨram iuwe mɨnin hɨm yapɨrwe nɨpaa God kewet Moses em hɨrak kewisɨm te haiu emisesim?” ");
INSERT INTO avt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas ketpɨwek kar ik: “Hɨm hɨram iuwe minɨn hɨm ham hɨram im: ‘Yi mɨt ne Isrel nɨkɨp emnep eiyɨmtau! Mɨtɨk Iuwe God hɨrak kiutɨp kerekek. ");
INSERT INTO avt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yi hanhan Mɨtɨk Iuwe God eiriuwe han ki ketike hɨmɨn ki.’ ");
INSERT INTO avt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hɨm mises hɨm ham minɨn hɨram im: ‘Yi hanhan eiriuwe mɨt han nar ke yi hanhan hɨras.’ Hɨm wik im minɨn, hɨm ham yapɨrwe hɨram mɨkaru.” ");
INSERT INTO avt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mɨtɨk ik kerek kertei hɨm lo me Moses, hɨrak katɨp kar ik: “Mɨtɨk Iuwe ti atɨp werek. Ti atɨp hɨrak God hɨrak kiutɨp. Hɨrak kerekek kepu. Han au. ");
INSERT INTO avt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Haiu hanhan Mɨtɨk Iuwe God keriuwe han kai mamɨr ke haiu hanhan hɨras, te im minɨn menmen haiu si tatɨm mamwet God em o menmen haiu mewepwarem mewet God em.” ");
INSERT INTO avt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hɨrak katɨp epei au, Jisas hɨrak kertei hɨrak mɨtɨk katɨp werek, te hɨrak ketpɨwek kar ik: “Ti han kit yaaik te ti hises hɨm me God werek werek.” Hɨrak katɨp epei au, mɨt han hɨr nɨnaain nanitɨwekhi menmen ham. ");
INSERT INTO avt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas wen katɨp keit wɨnak iuwe ke God, hɨrak kitehi mɨt kar ik: “Nenmak mɨt kerek hɨr ninɨn nertei hɨm lo me Moses hɨr natɨp Mɨtɨk Krais kerek God kehimɨtanek hɨrak Nepenyek ke Devit kerekek? ");
INSERT INTO avt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nɨpaa God Hɨmɨn Yaaik kɨkɨak han ke Devit te hɨrak kewis hɨm mau tɨwei kar ik: ‘Mɨtɨk Iuwe God katɨp Mɨtɨk Iuwe kai Krais kar ik: “Ti hau menep his yaaim mai ere hi enep mɨt enun nepan nit hi ehinɨni.” ’ ");
INSERT INTO avt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit hɨrak hɨrekes kenewek Mɨtɨk Iuwe kɨrak. Te hɨrak karkeik hɨrak kɨre Nepenyek ke maam nɨpu kɨrak Devit kerekek a?” Te mɨt miyapɨr yapɨrwe hɨr han yaaik nemtau hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas hɨrak wen katɨp mɨt miyapɨr hɨm mɨrak hɨrak ketpor kar ik: “Yi naanmampre hɨras me mɨt kerek hɨr nɨnɨn nertei hɨm me God. Hɨr nare nanɨno ein ein, hɨr neriuwet saket yaaim nokim me mɨt kerek hɨr netenen pewek yapɨrwe netike mɨt hɨr nertei menmen iuwe. Hɨr han yaaik te mɨt miyapɨr nanɨtpor, ‘Haai, ti epei han?’ neit wit maket kerek mɨt nesiuwe menmen. ");
INSERT INTO avt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Hɨr nanu yeno ne mɨt niuk mɨr iuwe neit wɨnak ke God, hɨr nanu yeno ne mɨt niuk mɨr iuwe neit wɨnak ke mɨt hɨr nanɨm menmen. ");
INSERT INTO avt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hɨr newises miyapɨr kerek mɨt nɨr epei naa. Hɨr nari wɨnak mɨr metike menmen mɨr yapɨrwe. Hɨr prea yapɨrwe hɨr newises mɨt ek te mɨt yapɨrwe natɨp hɨr yaain. Maain God hɨrak kaknɨp wɨsenum!” ");
INSERT INTO avt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas katɨp epei au, hɨrak ken kɨr tɨkenup mɨre bokis me mɨt hɨr newɨr pewek mekrerem newet God em. Tɨkenup mɨre bokis mɨwaai ein, hɨrak Jisas kau kereptim keit in. Hɨrak kɨr mɨt yapɨrwe newɨr pewek mekrerem. Mɨt han netenen pewek yapɨrwe newɨr pewek yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mɨte piutɨp menmen aurep hɨre wetenen pewek kike, te hɨre wewɨr pewek wik mɨre toea miutɨp. ");
INSERT INTO avt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisas hɨrak kenɨne mɨt disaipel nɨrak hɨrak ketpor kar ik: “Hi etpi werek. Mɨte ip hɨre wewɨr pewek hɨram minɨn pewek me mɨt kerek hɨr newɨr pewek yapɨrwe mekrerem. ");
INSERT INTO avt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hɨr newɨr pewek ham mekre tɨkenup mɨre bokis, te meiyam wen mepeit wɨnak mɨr. Hɨr newɨrem nanɨt menmen. Te hɨre au. Hɨre wetenen pewek wik wewɨrem epei au, hɨre wawu weinɨm. Hɨre wawɨt menmen wawɨm taauye! Meiyam meit wɨnak kɨre au.” ");
INSERT INTO avt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas hɨrak kɨnaaiwɨr wɨnak iuwe ke God kakno witeik, hɨrak mɨtɨk hak disaipel kɨrak ketpɨwek kar ik: “Mɨtɨk Iuwe ehɨrem. Nan im yaaim. Wɨnak im yaaim.” ");
INSERT INTO avt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisas ketpɨwek kar ik: “Ti ehɨr wɨnak yapɨrwe im e? Maain nan im mɨt han nanɨnen hɨr nanwenem mamwaai tɨ weinɨm.” ");
INSERT INTO avt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hɨr nen nau mɨniu (o neiyɨp) mɨt nenewem neiyɨp me nu Oliv hɨram menep wɨnak iuwe ke God pɨnak ein. Te Pita, Jems, Jon, tetike Andru hɨrakɨt tan menep titɨwekhi hɨm tar ik: ");
INSERT INTO avt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ti etpai me wɨ God kehimɨtan menmen im hɨram mamnen. Mekam maminɨn mamnen te haiu mamɨrtei God kakrɨakem?” ");
INSERT INTO avt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisas ketpor hɨm mɨrak mar im: “Yi naanmampre hɨras te hɨr mɨt nanwisiyek au. ");
INSERT INTO avt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mɨt yapɨrwe hɨr nanɨnen nanɨkrehɨr kai nantɨp mɨt miyapɨr ne tɨ nanɨr ik: ‘Hi Mɨtɨk Iuwe Krais kerek God kehimɨtena hi han kerekek.’ Hɨr nanwisorek hɨr nanisesi. ");
INSERT INTO avt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maain yi eiyɨmtau hɨm me mɨt hɨr nantɨp mɨt hɨr nanɨnepan menep o mɨt nanɨnepan yanɨmɨn, yi ap han ekɨkrit ein ein au emɨt. Menmen im maminɨn mamnen te wɨ epei mamnen wen au. ");
INSERT INTO avt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mɨt ne weiwɨk ham hɨr netike mɨt ne weiwɨk ham hɨr nanɨnepan. Mɨt ne wit hak nantike mɨt ne wit hak hɨr nanɨnepan. Tɨ kaktanɨk heriyai heryiyai. Hawɨ au te ni meiyam mami mamɨt menmen au. Menmen enum im maminɨn mamnen te maain God skelim mɨt me menmen enum hɨr nɨrɨakem. Hɨram mar ke mɨte weteiknen. Maain hɨre wawine nɨkan. ");
INSERT INTO avt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Yi naanmampre hɨras me menmen im e. Maain hɨr mɨt nantihis nanɨryi yi yaino wɨnak ke kaunsil. Hɨr nanɨt nɨpɨn naniwep yayɨt wɨnak ke God. Yi yayɨrp yayɨt wɨnak ke kaunsil me gavman nantike mɨt han ninɨn naanmɨpre wit heriyai heriyai yayɨntar yi yises hɨm mai. Te yi eiyɨtpor menmen mai. ");
INSERT INTO avt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yi eiyɨtpor hɨm mai maminɨn, te mɨt nerer wit wit hɨr nanɨmtewem. Te maain wɨ enum mamnen. ");
INSERT INTO avt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Maain yi eiyɨrp wɨnak ke kaunsil yi han ekitet yapɨrwe hɨm mekam yi eiyɨtpor au emɨt! Menmen God Hɨmɨn Yaaik kakɨtpiyem kakwetiyem, yi eiyɨtpim. Menmen me han ki au. Taauye! ");
INSERT INTO avt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Heiyiuwerer nanwet mɨt enun kikrek nɨr hɨr nanɨnɨp nani. Haairer nanwet mɨt enun nɨkerek nɨr, nɨkerek han nanwet mɨt enun haairer o miyerer hɨr mɨt nanɨnɨp nani. ");
INSERT INTO avt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Maain mɨt yapɨrwe hɨr han enuk nɨneini nanɨntar yi yises hɨm mai. Te neimɨn nanu nanɨt nanisɨsa ere hɨr nani, maain hi etorhis hɨr nanu nantikewa haiu mamu mamɨt wit ke God. ");
INSERT INTO avt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Maain yi yayɨr menmen enum mamɨwaank wit mamtike mɨtɨk hɨrak kakɨrp wit kerek God keriuwesɨsek. (Mɨt kerek nekine tɨwei ik nɨkɨp emnep yi han ekitet menmen im werek werek.) Yi mɨt miyapɨr yayu provins Judia me wɨ im yi eirɨr eino einiu mɨniu o neiyɨp. ");
INSERT INTO avt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mɨtɨk kerek kau kentar wɨnak siup, hɨrak ekɨkɨuwe eknen ekɨrp tɨ, hɨrak ap kakno wɨnak nɨmɨn ein kakɨt menmen au emɨt! Hɨrak ekrɨr ekno waswas kerekek. ");
INSERT INTO avt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mɨtɨk hak keit ni hɨrak pɨke kakweikɨn kakɨt saket mɨrak au, emɨt! Hɨrak kakrɨr waswas kerekek. ");
INSERT INTO avt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Miyapɨr kerek hɨr nepɨtu o miyapɨr hɨr newet nɨkerek nɨm hɨr naam, menmen im enum mamnen mamɨwaanki. ");
INSERT INTO avt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yi eiyitehi God te menmen im mamnen wɨ me hawɨ hɨtan au emɨt! ");
INSERT INTO avt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maain me wɨ eim, hɨr mɨt menmen mamɨwaanki iuwe. Nɨpaa wɨ God kewis tɨ ketike nepni ere in, menmen ap mewaank mɨt nanɨr ke menmen im mamɨwaanki au. Wɨ eim epei man, maain menmen mamɨwaank mɨt nanɨr im taauye! ");
INSERT INTO avt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","God hɨrak keremir wɨ im au, te mɨt yapɨrwe hɨr nani nanɨnektɨn te wit weinɨk. Te hɨrak keremir wɨ yinam me mɨt nɨpaa hɨrak kehimɨteni hɨr nɨrak, hɨr nises hɨm mɨrak hɨrak kakɨkepi. ");
INSERT INTO avt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Maain wɨ eim e, te mɨtɨk hak kakɨtpi kakɨr ik: ‘Eiyɨrek, hɨrak Mɨtɨk Krais hɨrak keit in.’ O mɨtɨk hak kakɨtpi, ‘Hɨrak kerp ein.’ Yi ap eiyɨmtau hɨm im au emɨt! ");
INSERT INTO avt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mɨt enun tawewai (o newenɨn hɨm) nanɨnen nanɨtpi, ‘Hi Mɨtɨk Krais’ o hɨr nantɨp, ‘Hi mɨtɨk profet hi ewepyapɨr menmen me God.’ Hɨr nanrɨak mɨt menmen yaaim nɨpaa hɨr nɨrem au mamɨt nepni o nanɨt tɨ. Hɨr nanrɨakem te hɨr nare nanri han ke mɨt God kehimɨteni hɨr nɨrak, hɨr nanwisorek nanises hɨm mɨr, te hɨr au taau. ");
INSERT INTO avt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yi naanmamre hɨras. Maain menmen mamnen mamɨr ke hi epei etpiyem. ");
INSERT INTO avt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Maain wɨ im, menmen enum mamɨwaank mɨt epei au, wepni kakɨr iuwe au, hɨrak kakweikɨn kakre wɨtaan, wenke ap te kakɨr taau. ");
INSERT INTO avt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hɨr hɨram mau nepni hɨram mamɨnke, menmen eim meit nepni hɨram mamtanɨk. ");
INSERT INTO avt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Menmen im epei man, te hɨr mɨt nanɨra hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi anen ewepyapɨr hɨrekes akre napɨ ke nepni. Menmen me haai merhɨhe mewepna, hi anen ehinɨn naanmampre mɨt. ");
INSERT INTO avt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hi esiuwe mɨt ensel ne wit ke God hɨr nanɨno nanrer wit wit nanɨthis mɨt miyapɨr hi ehimɨteni hɨr nises hɨm mai. ");
INSERT INTO avt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nu fik hɨram meteikni menmen me wɨ maain menmen mamnen. Maain wɨ kerek heneik mɨram hɨram mamsiunen, yi eiyɨrtei menep te wepni yaaik. ");
INSERT INTO avt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mar nu im, maain yi yayɨr menmen im hi hetpiyem hɨram mamnen, yi eiyɨrtei hi Mɨtɨk ke wit ke Mɨtɨk Iuwe menep te hi pɨke anen. ");
INSERT INTO avt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hi hatɨp werek. Mɨt miyapɨr in ek nepu nepeit, hɨr ap te nani ere menmen im hi hetpiyem hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nepni metike tɨ mamwep mamweikɨn mamre nɨme mamɨwaank mamɨt te hɨm mai au mamu mamnen mamɨr ke hi hetpim. ");
INSERT INTO avt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Me wɨ menmen im mamnen, mɨt hɨr nepɨtariyem, mɨt ensel ne wit ke God hɨr nepɨtariyem, hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi epɨtariyem. God Haai kerekek hɨrak kerteiyem. ");
INSERT INTO avt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yi naanmampre hɨras. Yi yepɨtari wɨ menmen im mamnen. ");
INSERT INTO avt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Menmen mamnen mamɨr ke mɨtɨk iuwe hak kakno yanɨmɨn. Te mɨt nɨrak nepɨtari wɨ mekam hɨrak pɨke kaknen. Hɨrak kehimɨtan mɨt hɨr naanmɨpre wɨnak kɨrak, hɨrak katɨp mɨtɨk hɨrak naanmɨpre weipɨr ke nɨwa ke wit kɨrak. Hɨrak ketpɨwek hɨm iuwe hɨrak naanmɨprewek werek werek. ");
INSERT INTO avt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Te yi mɨt naanmamre hɨras werek werek. Yi yepɨtari wɨ me Haai ke wɨnak hɨrak pɨke kaknen. Hɨrak kaknen wɨtaan o wɨ nɨmɨn o wanewik toto o wepni o hɨnkewɨ, yi yepɨtariyek. ");
INSERT INTO avt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yi naanmɨpre hɨras te hɨrak kaknen wasenum kakri yi yaiwaai yi ap yayises hɨm mɨrak au. ");
INSERT INTO avt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Menmen hi hetpiyem, hi hetpiyem mamno mɨt miyapɨr yapɨrwe. Yi yapɨrwe naanempre hɨras! Yi yepɨtari wɨ mekam hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen.” ");
INSERT INTO avt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wɨ wik mepeit ere wɨ mɨt hɨr han tewenɨn wɨ Pasova kerek nɨpaa God kenep mɨt ne Isip hɨr naa te mɨt ne Isrel au. Mɨt hɨr newis yis mekre bret mɨr me wɨ im au. In ek hɨr mɨt pris iuwe kerek ninɨn mɨt pris han kerek newet God menmen me mɨt, hɨr netike mɨt hɨr ninɨn nertei hɨm lo me Moses hɨr nererik nime nɨpɨn Jisas nɨsawɨn nemitɨwekpɨn nantɨwekhis nankɨp kaki. ");
INSERT INTO avt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hɨr natɨp nar ik: “Wɨ haiu wen han tewenɨn menmen me wɨ Pasova, haiu ap te mamtɨwekhis mamkɨp au. Haiu mamrɨakem te mɨt yapɨrwe hɨr nantikewai haiu mamnepan.” ");
INSERT INTO avt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Me wɨ im Jisas hɨrak keit wit Betani hɨrak kepu wɨnak ke Saimon nɨpaa lepro mewik. Hɨrak wen kepu yeno kaam menmen, mɨte piutɨp hɨre wan wetenen mɨn tɨpar me nu nad nekenpɨ mɨrak mɨnɨn yaaim mekrerek. Mɨt hɨr newɨr pewek yapɨrwe me menmen im. Hɨre weket hɨm mɨrak wewen tɨpar mentar paan kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hɨr mɨt han nepu en hɨr natɨpan main main han enuk nar ik: “Wenmak te hɨre wewen tɨpar im wewenem weinɨm? ");
INSERT INTO avt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hɨre wewen tɨpar im au, te mɨtɨk hak kaksiuwerem kakɨt 300 kina kakwet mɨt enum menmen auri, hɨr nantɨwem.” Hɨr han enuk te hɨr nenerep. ");
INSERT INTO avt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Te Jisas keneri katɨp kar ik: “Yi eiwisiye ewɨt! Yi yenmak te yi yerekyɨwe enum. Hɨre werekyo menmen yaaim. ");
INSERT INTO avt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hɨr mɨt enun netenen menmen auri, hekrit hekrit hɨr nau netikewi. Wɨ ham yi han ki yi eikepi. Te hi ap ehu etikewi me wɨ yapɨrwe, te yi yairekyo menmen yaaim au. ");
INSERT INTO avt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mɨte ip hɨre hanhan wɨrɨakem hɨre epei werekyewem. Hɨre weremani maain mɨt hɨr nanwisa hi awaai ehɨkre hei. ");
INSERT INTO avt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Hi hetpi werek. Wit heriyai heriyai kerek mɨt hɨr nanɨmtau hɨm yaaim mai, mɨt hɨr nanɨrtei menmen mɨte ip hɨre werekyewem, hɨr han kitetim hɨr han tewenɨnep.” ");
INSERT INTO avt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jisas katɨp epei au, Judas ke wit Iskeriot hɨrak mɨtɨk kiutɨp ke mɨt disaipel hiswiyen wik (12) kerek nises hɨm me Jisas, hɨrak ken witeik. Hɨrak ken kiun mɨt iuwe ne pris kerek newet God menmen me mɨt, hɨrak kewepyapɨr Jisas kakwetɨrek. ");
INSERT INTO avt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hɨr mɨt en nerteiyek, hɨr han yaaik, hɨr natɨp Judas hɨr nanwetɨwek pewek mamrerim. Hɨrak kɨnaiwɨri ken han kitet hɨrak kakwetɨrek kakɨrkeik. ");
INSERT INTO avt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Maain wɨ miutɨp me wɨ mɨt hɨr ap newis yis mekre bret au, wɨ me Pasova kerek hɨr nenep sipsip mar ke nɨpaa mɨt hɨr nenep sipsip te God kenep maamrer au, Jisas mɨt nɨrak nitɨwekhi nar ik: “Ti are eriuwetai haiu mamno nein te haiu emrutmani menmen me wɨ Pasova?” (Wɨ Pasova hɨram wɨ mɨt hɨr han tewenɨn God hɨrak kenep mɨt ne Isip te maamrer ne Isrel au.) ");
INSERT INTO avt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Te Jisas hɨrak keriuwet mɨtɨkɨt wik te mɨt disaipel nɨrak hɨrak ketpɨwekɨt kar ik: “Yi yaino wit Jerusalem yi eiyɨr mɨtɨk hak keremɨme mɨn tɨpar mekrerem, hɨrak kaksipeti. Te yi eiyisesik. ");
INSERT INTO avt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yi eiyisesik eino wɨnak kerek hɨrak kakno kakɨkrerek, yi eiyitehi mɨtɨk ke wɨnak ik eiyɨr ik: ‘Mɨtɨk Iuwe kawɨr hɨrak kituthi haau meiyam miutɨp meit nɨmɨn weinɨm te haiu mɨt disaipel nɨrak mamtikerek emu mamɨm menmen kerekek me wɨ Pasova mamwi?’ ");
INSERT INTO avt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Te hɨrak kakteikni haau miutɨp weinɨm kau niu kerek yeno metike kɨnaan mekrerek. Ein e yi eiraimani menmen te haiu mamɨm.” ");
INSERT INTO avt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hɨrak ketpɨwekɨt menmen te hɨrakɨt ten wit Jerusalem, hɨrakɨt tɨr menmen mar ke nɨpaa Jisas ketpɨwekɨtem. Te hɨrakɨt temani menmen me Pasova wɨ hɨr han tewenɨn nɨpaa God kenep maamrer nɨr au. ");
INSERT INTO avt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Maain hɨnkewɨ, hɨrak Jisas ketike mɨt disaipel nar hiswiyen wik (12) hɨr nen wɨnak. ");
INSERT INTO avt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hɨr wen naam menmen nau yeno em, Jisas hɨrak ketpor kar ik: “Hi hetpi werek. Mɨtɨk hak kiutɨp (o mɨtɨk keiyak) ke yi mɨt yi yaam menmen yetikewa hɨrak kakwepayapɨr hi eno his me mɨt enun.” ");
INSERT INTO avt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hɨr nemtewek, hɨr han kekrit nine han enuk, hɨr niutɨp niutɨp nenepepan nitɨwekhi ere hɨr nepnepik hɨr nitɨwekhi nar ik: “Hi ewepityapɨr o au?” ");
INSERT INTO avt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hɨrak ketpor kar ik: “Hɨrak mɨtɨk kiutɨp ke yi mɨt hiswiyen wik (12), hɨrak kiutɨp kaam menmen mekre sak kerepta. ");
INSERT INTO avt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hi Mɨtɨk ke wit ke God hi ano hahi ahɨr ke hɨm me God mau tɨwei hɨram metpim. Te hɨrak mɨtɨk kerek kakwepayapɨr hɨrak kakɨwaank hɨrekes. Nɨpaa miye pɨrak ap winaak te hɨram yaaim. Te hɨre epei winaak te in ek hɨrak kakɨwaank hɨrekes.” ");
INSERT INTO avt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hɨr wen naam menmen, Jisas keit bret kitehi God katɨp hɨrak yaaik. Te hɨrak kewepik kewet mɨt ek ketpor kar ik: “Yi eitɨwek eiyɨk. Ik hɨrak yɨnk kai.” ");
INSERT INTO avt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hɨr naak, mar keremem te hɨrak keit wa hesnu tɨpar wain mekrerek, hɨrak kitehi God katɨp hɨrak yaaik. Te hɨrak kewetɨrek hɨr naam tɨpar wain mekre wa hesnu. ");
INSERT INTO avt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Te hɨrak ketpor kar ik: “Im em hɨram hemkre mai. Hi enip hɨm ham yaaim kontrak mamɨke wit ke God mamnen. Hemkre mai mamwen te hi akaap mɨt miyapɨr ariuwerem. ");
INSERT INTO avt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Hi hetpi werek. Hi ap pɨke ehɨm tɨpar wain ere wɨ maain hi ehɨm tɨpar wain yaaim nɨmnam mamɨt wit ke God.” ");
INSERT INTO avt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hɨrak katɨp epei au, hɨr nine henye. Hɨr nine henye, te hɨr nen witeik nɨnaaiwɨr wit Jerusalem, hɨr nɨniu nen mɨniu (o neiyɨp) ke nu Oliv. ");
INSERT INTO avt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","In ek Jisas ketpor kar ik: “Maain kike yi yainaipɨsa. Hɨm me God hɨram matɨp mar im: ‘Hi God hi enep mɨtɨk naanmɨpre sipsip, hɨram mamrɨr mamno heriyai heriyai.’ ");
INSERT INTO avt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Maain, God hɨrak kakɨkoya hi pɨke ekrit, hi ehinɨni hi ano provins Galili.” ");
INSERT INTO avt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ketpɨwek hɨm iuwe kar ik: “Hɨr mɨt in nanɨnapɨsit nanrɨr te hi au. Taauye!” ");
INSERT INTO avt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas ketpɨwek kar ik: “Hi hetput werek. Wɨtaan ik ek, suware kaktɨp wik wen au, ti eraupakɨn wikak atɨp mɨt hi epɨtari hɨrak keimɨn.” ");
INSERT INTO avt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Te Pita katɨp hɨm iuwe, “Hi hahi etikewit hi hahi, te hi aritpakɨn au. Taauye!” Hɨr mɨt nɨrak yapɨrwe natɨp narek. ");
INSERT INTO avt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hɨr natɨp epei au, hɨr nen wit ni meitai niuk mɨrak Getsemani. Jisas hɨrak katɨp mɨt nɨrak kar ik: “Yi eiyu in hi eno ehitehi God.” ");
INSERT INTO avt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hɨrak keit Pita, Jems tetike Jon, hɨrakɨt tetikerek ten wit hak. In ek Jisas hɨrak menmen menepɨwek hemkre, hɨrak kine han enuk. ");
INSERT INTO avt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Te hɨrak ketpɨwekɨt kar ik: “Hi hine han enuk ere hi hahi. Hi hanhan hɨrekes wɨsenum.” ");
INSERT INTO avt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hɨrak ken kike kɨwaai tɨ kitehi God te menmen enum im mamsiurɨrek mamno. ");
INSERT INTO avt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hɨrak kitehi God kar ik: “Haai kai ti hertei hɨrɨak menmen yapɨrwe. Ti esiuwe menmen enum im mamno emnopɨn emkeipo. Te hi hises han kai au, han kit.” ");
INSERT INTO avt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hɨrak katɨp epei au, hɨrak ken kɨr mɨtɨkɨt tɨrak tɨpwaai. Te hɨrak kene Pita kar ik: “Saimon ti hɨwaai a? Ti ap epu naanmɨpre mɨt nanɨnen me wɨ kike au a? ");
INSERT INTO avt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yi naanmɨpre mɨt nanɨnen. Yi eiyitehi God te hɨrak Seten ap te kakinɨni yi eiweikɨn sip eiweto. Yi han ki yaaik, te yɨnk ki au kɨnapen kaki kaktikewa.” ");
INSERT INTO avt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hɨrak katɨp epei au, Jisas pɨke ken ein kitehi God menmen kerek nɨpaa hɨrak kitɨwekhiyem. ");
INSERT INTO avt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hɨrak pɨke ken kiun mɨtɨkɨt tɨrak, te hɨrakɨt au pɨke tɨwaai nanamɨr mekses. Hɨrakɨt tekrit tepɨtari tetpɨwek mekam taauye. ");
INSERT INTO avt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hɨrakɨt yɨnk enuk hɨrak pɨke ken kan hɨrak ketpɨwekɨt kar ik: “Yi wen yɨwaai yɨnatɨn a? Epei werek emɨt! Eiyɨrek! Wɨ epei man te hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hɨrak mɨtɨk hak kakwepayapɨr hi eno his me mɨt han nanrekyo enum hɨr nantenɨna. ");
INSERT INTO avt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Eiyɨkrit haiu emno. Yi eiyɨrek! Mɨtɨk kewepayapɨr epei kan keit in.” ");
INSERT INTO avt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","In ek hɨrak wen katɨp, Judas hɨrak kan. Hɨrak mɨtɨk kiutɨp ke mɨt disaipel nar hiswiyen wik (12). Hɨrak ketike mɨt yapɨrwe hɨr netenen hɨne metike paap yoki. Hɨr mɨt iuwe ne Pris kerek newet God menmen me mɨt, hɨr netike mɨt ninɨn nertei hɨm lo me Moses, hɨr netike mɨt iuwe ne Isrel, hɨr nesiuwe mɨt in nan. ");
INSERT INTO avt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nɨpaa hɨrak mɨtɨk Judas kerek kewepyapɨrek hɨrak ketpor kar ik: “Hɨrak mɨtɨk kerek hi eiyewewik emɨwek tekep mɨrak, yi eitɨwekhis eitenenik eiriyaak eiyɨk eino.” ");
INSERT INTO avt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas kan kiun Jisas hɨrak katɨp kar ik: “Mɨtɨk Iuwe.” Te hɨrak keiyewewik. ");
INSERT INTO avt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Te hɨr mɨt han nan neithis Jisas netenenik. ");
INSERT INTO avt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te mɨtɨk kiutɨp kɨrak kerek kerp menep hɨrak ketenen hɨne ke his nokik, te hɨrak kɨwaai hɨne kesipe nɨkɨp me mɨtɨk hak enuk eik. Mɨtɨk iuwe ke mɨt pris kerek newet God menmen me mɨt, mɨtɨk kɨrak kɨrɨak wok mɨrak weinɨm, hɨrak mɨtɨk ik ke Jisas hɨrak kesipe nɨkɨp mɨrak. ");
INSERT INTO avt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hɨrak Jisas kene mɨt han enun ein ketpor kar ik: “Yi epei yan yetauhis eiriuwe hɨne metike paap yoki yar ke yi yeithis mɨtɨk enuk kekintɨp menmen a? ");
INSERT INTO avt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hekrit hekrit hi etikewi haiu mepu wɨnak iuwe ke God hi ewepyapɨr hɨm mai. Te yi yetauhis auye! Yi yɨrɨak menmen im te hɨm me God mɨt newisɨm mau tɨwei hɨram mamnen mamir em.” ");
INSERT INTO avt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hɨrak katɨp epei au, hɨr mɨt disaipel nɨrak hɨr nɨnaiwɨrek nɨrɨr nen. ");
INSERT INTO avt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mɨtɨk pipɨak hak kiutɨp kerek kises Jisas, hɨrak kamɨr laplap mɨre hike mɨsanu traup mɨrak. Hɨr mɨt han nantɨwekhis, ");
INSERT INTO avt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","te hɨrak kehɨresiuri kenemtɨn laplap mɨrak hɨrak ke puk weinɨk kɨrɨr ken. ");
INSERT INTO avt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hɨr mɨt nari Jisas nen niun mɨtɨk iuwe hetpris kinɨn naanmɨpre mɨt pris kerek newet God menmen me mɨt. Mɨt iuwe pris yapɨrwe newet God menmen me mɨt, hɨr netike mɨt niuk mɨr iuwe, hɨr netike mɨt hɨr ninɨn nertei hɨm lo me Moses, hɨr nererik nau ein nemeriyɨwek. ");
INSERT INTO avt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hɨrak Pita ketepik yanɨmɨn, hɨrak ken kekre nɨwa ke wɨnak ke mɨtɨk iuwe kinɨn mɨt pris han. Hɨrak ketike mɨt kerek naanmɨpre wɨnak enuk hɨr nau si neminɨn his hɨt men si. ");
INSERT INTO avt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hɨr mɨt pris iuwe kerek newet God menmen me mɨt, hɨr netike mɨt han ne kaunsil hɨr nɨnatɨn mɨt nesiuwe hɨm Jisas, te hɨr nankɨp kaki, te hɨr nɨnapɨn menmen enum hɨrak ketpim au. ");
INSERT INTO avt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mɨt yapɨrwe nesiuwe hɨm Jisas newenɨwek hɨm te hɨm mɨr ap mɨpɨram au. ");
INSERT INTO avt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mɨt han nerp newenɨn hɨm natɨp nar ik: ");
INSERT INTO avt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Haiu memtewek hɨrak katɨp, ‘Hi ewep wɨnak iuwe ke God mɨt nimaak, te maain wɨ wikak hi pɨke eimaak mɨt ap te nanimaak taau.’” ");
INSERT INTO avt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hɨm me mɨt in hɨram ap mɨpɨram au. ");
INSERT INTO avt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hɨrak mɨtɨk iuwe hetpris kerek kinɨn naanmɨpre mɨt kerek newet God menmen me mɨt, hɨrak kerp kekreri kitehi Jisas kar ik: “Ti pɨke etpai au a? Nenmak te hɨr mɨt in neswut hɨm a?” ");
INSERT INTO avt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jisas hɨrak kekintɨp ketpor au. Mɨtɨk iuwe hetpris hɨrak pɨke kitɨwekhi kar ik: “Ti mɨtɨk Krais kerek God kehimɨtenit, ti Nɨkan ke Mɨtɨk Iuwe kerek haiu mewenɨpiyek o au a? Ti etpai!” ");
INSERT INTO avt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas hɨrak ketpɨwek kar ik: “Hi hɨrekes kerekek. Maain yi eiyɨr hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hahu menep his yaaim me God kerek hɨrak Iuwe tokik keit, hi anen ekre napɨ me nepni.” ");
INSERT INTO avt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mɨtɨk iuwe hetpris hɨrak kepɨrpɨr kari saket mɨrak kewepim katɨp hisiuwe kar ik: “Menmak te haiu mamri mɨt han nansiuwek hɨm a? ");
INSERT INTO avt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","yi epei yemtau hɨrak katɨp enum kekrehɨr ke God. Yi han kitet mekam a?” Hɨr yapɨrwe natɨpan nar ik: “Hɨrak kɨrɨak enum hɨrak eki.” ");
INSERT INTO avt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","In ek mɨt han nenikɨn tɨmank menterik, hɨr newepnɨwek ninaan meriuwe laplap, te hɨr nakɨp neriuwe his mɨr nitɨtɨweknaan natɨp nar ik: “Keimɨn kitep a? Ti profet te ti etpai.” Mɨt han hɨr naanmɨpre weipɨr nen nɨwaaihis nenepɨwek tekep. ");
INSERT INTO avt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Hɨrak Pita wen kepu witeik keit nɨwa ke wɨnak, mɨte piutɨp wɨrɨak menmen me mɨtɨk iuwe hetpris, ");
INSERT INTO avt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","hɨre wan wɨr pita kau si keminɨn his hɨt men si. Hɨre werp menep wetpɨwek war ik: “Ti hɨrekes hetike Jisas ke wit Nasaret yi epei yariyakɨt.” ");
INSERT INTO avt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Te Pita kiune hɨm katɨp, “Henmak te ti hitauhi menmen im? Hi hepɨtariyek.” Hɨrak katɨp epei au, hɨrak ken kerp ya weipɨr. Te suware katɨp. ");
INSERT INTO avt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mɨte wen wɨpɨrek pɨke watɨp mɨt han nerp menep war ik: “Hɨrak mɨtɨk kises hɨm me Jisas kerekek.” ");
INSERT INTO avt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita pɨke kiune hɨm katɨp, “Hi hepɨtariyek.” Maain kike, mɨt hɨr nerp menep natɨp nar ik: “Ti hises hɨm mɨrak kerekek. Ti hɨrekes mɨtɨk ke provins Galili.” ");
INSERT INTO avt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita katɨp hɨm iuwe ketpor kar ik: “Hi epɨtari mɨtɨk hak yi yitauhiyek au. Hi atɨp werek au, te God hɨrak kaknen kakiyep.” ");
INSERT INTO avt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hɨrak katɨp epei au, hɨrak suware pɨke katɨp. Te Pita hɨrak han kitet menmen Jisas nɨpaa ketpɨwek kar ik: “Maain suware katɨp wik wen au, ti tewen eraupakɨn wikak.” Hɨrak han kitetim te hɨrak kine han enuk kɨkɨt. ");
INSERT INTO avt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wanewik toto, mɨt iuwe pris kerek newet God menmen me mɨt, hɨr netike mɨt iuwe hɨr netike mɨt ninɨn nertei hɨm lo me Moses, hɨr netike mɨt han yapɨrwe ne kaunsil hɨr han kitetim natɨpan. Epei au, hɨr nesenkek Jisas his mɨrak neriyaak neiyɨk nen newet mɨtɨk iuwe gavman Pailat ek. ");
INSERT INTO avt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat hɨrak kitɨwekhi kar ik: “Ti Mɨtɨk Iuwe King ke mɨt ne Isrel o au?” Jisas ketpɨwek kar ik: “Hɨrak hɨm mit.” ");
INSERT INTO avt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mɨt iuwe pris kerek newet God menmen me mɨt, hɨr nesiuwe hɨm Jisas yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Te Pailat kitehi Jisas kar ik: “Ti pɨke etpor au a? Hɨr neswut hɨm yapɨrwe.” ");
INSERT INTO avt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisas kekintɨp, te Pailat han kekrit keriuwerek. ");
INSERT INTO avt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tito yapɨrwe nɨpaa ein me wɨ im mɨt hɨr nehis nempep menmen me Pasova hɨr nitehi Pailat hɨrak kakɨkaisiu weipɨr ke mɨtɨk hak nɨpaa hɨrak ken kekre wɨnak enuk. ");
INSERT INTO avt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mɨtɨk hak niuk mɨrak Barabas hɨrak kepu wɨnak enuk ketike mɨt enun yapɨrwe nɨpaa hɨr netike mɨt ne gavman hɨr nenepan, hɨr nenep mɨtɨk kiutɨp kaa. ");
INSERT INTO avt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hɨr mɨt yapɨrwe nen niun Pailat nitɨwekhi hɨrak kakrɨak menmen nɨpaa ein hɨrak kɨprɨakem. ");
INSERT INTO avt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hɨrak ketpor kar ik: “Yi han yaaik te hi eweti Jisas Mɨtɨk Iuwe ke Isrel hɨrak kaknen?” ");
INSERT INTO avt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hɨrak kertei mɨt iuwe pris kerek newet God menmen me mɨt hɨr epei newetɨwek Jisas nentar hɨr hemkre menepam han enuk neriuwerek. ");
INSERT INTO avt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hɨr mɨt pris nɨkɨak han ke mɨt yapɨrwe te hɨr nitehi Pailat ke Barabas. Jisas au. ");
INSERT INTO avt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat pɨke kitorhi kar ik: “Hi eweti Barabas, te hi arɨak mekam heriuwe mɨtɨk yi eiwis niuk mɨrak Mɨtɨk Iuwe King ke Isrel a?” ");
INSERT INTO avt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hɨr pɨke natɨp nar ik: “Ti ewenkek Jisas ekɨntar nu tentarakɨt.” ");
INSERT INTO avt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat ketpor kar ik: “Hi henmak? Hɨrak kɨrɨak mekam enum?” Te hɨr wen nɨnap nenɨne his iuwe natɨp nar ik: “Ti ewenkekik ekɨntar nu tentarakɨt.” ");
INSERT INTO avt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat hanhan kakrɨak mɨt hɨr han yaaik. Te hɨrak kewetɨr mɨtɨk Barabas. Hɨrak katɨp mɨt nɨrak hɨr nanɨnep Jisas nanriuwe nɨpɨn. Hɨr nakɨp neriuwe nɨpɨn, Pailat hɨrak keriuwetek ken mɨt soldia nɨrak te hɨr nanɨno nanwenkek Jisas kakɨntar nu tentarakɨt. ");
INSERT INTO avt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mɨt soldia ne ami hɨr neit nɨmɨn wɨnak ke mɨtɨk iuwe, hɨr nari Jisas neiyɨk nen haau hak. Hɨr nenɨne mɨt han, ");
INSERT INTO avt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","te hɨr neriuwet Jisas saket mɨre yɨwir, hɨr nime wiwɨr tɨktɨk enuk newisɨk keweikɨn paan kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hɨr nerp netpɨwek nar ik: “Haai, Mɨtɨk Iuwe King ke Isrel, ti epei han.” ");
INSERT INTO avt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Epei au, hɨr nenep paan kɨrak neriuwe niuk, hɨr nenikɨn tɨmank menterik, nitehɨr nemipɨn newenɨpiyek. ");
INSERT INTO avt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hɨr nitɨtɨweknaan nenwesɨsek ere werek, hɨr neriuwetek (o neresɨwek) saket mɨre yɨwir, hɨr pɨke newis saket mɨrak menterik, hɨr neiyɨk nanɨno nanwenkekik kakɨntar nu tentarakɨt. ");
INSERT INTO avt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mɨtɨk hak niuk mɨrak Saimon hɨrak haai ke Rufas ketike Aleksanda, hɨrak ke wit Sairini, hɨrak kepnen ni menep. Hɨr mɨt soldia hɨr neit nu tentarakɨt neiyɨk nimaasik hɨrak ekɨkerɨr nu ik ke Jisas. ");
INSERT INTO avt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hɨr nari Jisas neiyɨk nen niun wit niuk mɨrak Golgota. Haiu meweikɨn hɨm haiu matɨp “Wit Paan Hesnu”. ");
INSERT INTO avt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hɨr newet Jisas tɨpar wain marasin mekrerem, te hɨrak yɨnk kɨrak kekek au. Hɨrak kɨnapen te hɨrak kaam au. ");
INSERT INTO avt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hɨr mɨt newenkekik kentar nu tentarakɨt, hɨr neit menmen mɨrak neretɨt satu neiyɨk nɨr menmen hɨr nantɨwem. ");
INSERT INTO avt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wen hekrit iuwe wepni kehɨn kɨniu kan, hɨr newenkekik. ");
INSERT INTO avt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hɨr newis hɨm mentar nu nenmak hɨr newenkekik nesiuwerek. Hɨr neiyɨm nen newisɨm mau men paan kɨrak. Hɨm im matɨp mar ik: “IK EK HƗRAK MƗTƗK IUWE KING KE ISREL.” ");
INSERT INTO avt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hɨr newenkek mɨtɨkɨt enukɨt raskel wik tɨrɨak enum tetikerek. Hɨrak mɨtɨk kau ken ke his yaaim, mɨtɨk hak kau ken ke his henkik. ");
INSERT INTO avt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Mar im hɨm me God nɨpaa mɨt newisɨm mau tɨwei hɨram epei man. Hɨram matɨp mar im: “Hɨr han kitet hɨrak kɨre mɨtɨk enuk raskel kɨrɨak menmen enum.”) ");
INSERT INTO avt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mɨt kerek hɨr nan nen ein hɨr nitɨtɨweknaan netpɨwek nar ik: “Ko! Ti mɨtɨk kerek ti ewep wɨnak iuwe ke God ti pɨke eimaak me wɨ wikak? ");
INSERT INTO avt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ti ekaap hɨrekes ekiuwe nu tentarakɨt ehɨrp tɨ.” ");
INSERT INTO avt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mar im mɨt iuwe pris kerek newet God menmen me mɨt, hɨr netike mɨt ninɨn nertei hɨm lo me Moses, hɨr nitɨtɨweknaan natɨpan nar ik: “Hɨrak kɨkaap mɨt han, te hɨrak kɨkaap hɨrekes taauye! ");
INSERT INTO avt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ti Mɨtɨk God kehimɨtenit ti Mɨtɨk Iuwe ke Isrel, ti ekiuwe ehɨrp tɨ, te haiu mamrit han kitetit.” Mɨtɨkɨt hɨr newenkekikɨt tau niu tetikerek, hɨrakɨt tetpɨwek enuk tetikeri. ");
INSERT INTO avt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wepni kan kau nɨmɨn iuwe ere hɨnkewɨ, wɨtaan toto mɨwapɨn wit yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nepei hɨnkewɨ Jisas kenepɨp hɨm iuwe katɨp kar ik: “Eloi Eloi Lama Sabaktani?” Haiu meweikɨn hɨm haiu matɨp mar im: “God kai God kai. Kenmak te ti hɨnaiwɨra eweikɨn sip eweto?” ");
INSERT INTO avt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mɨt han nerp menep hɨr nemtewek hɨr natɨp nar ik: “Eiyɨmtewek. Hɨrak kenɨne Ilaija.” ");
INSERT INTO avt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mɨtɨk kiutɨp kesiuknen ken ein keit mosong o nɨk me wan eik (hɨram mɨre wum nɨkik), hɨrak kewis tɨpar wain mesine mekrerek, hɨrak kewisɨk kentar niyen pɨke kan kewetɨwekek kakɨmɨsek katɨp kar ik: “Haiu mamɨr te Ilaija kaknen kaknektɨn Jisas kakwisɨk kakɨrp tɨ o au.” ");
INSERT INTO avt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","38","Jisas kenepɨp miutɨp hɨm iuwe, hɨrak kaa. Hɨrak kaa, laplap iuwe mɨwapɨn ya weipɨr me mɨt nehimɨtan em me God meit wɨnak iuwe ke God meit nɨmɨn ein hɨram mewep pɨnam pɨnam mau nɨmɨn mau niu ein ere men miun tɨ eim. ");
INSERT INTO avt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hɨrak mɨtɨk iuwe kerek naanmɨpre mɨt soldia han, hɨrak kerp menep kɨr Jisas hɨrak kaa, hɨrak katɨp kar ik: “Mɨtɨk ik hɨrak Nɨkan ke God.” ");
INSERT INTO avt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Miyapɨr han netikerek nerp ein, te hɨr nerp yanɨmɨn. Maria pe wit Magdala wetike Salomi, hɨr netike Maria miye pe Joses ketike nɨkik kɨrak Jems hɨr nerp ein. ");
INSERT INTO avt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hɨr miyapɨr in nises Jisas me wɨ hɨrak kau keit provins Galili, hɨr newetɨwek menmen hɨrak kaam. Miyapɨr han yapɨrwe nɨpaa netikerek nan nen wit Jerusalem nerp ein. ");
INSERT INTO avt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Maain petko matɨp, Josep ke wit Arimatia kan kɨr Pailat kentar hɨrak mɨtɨk iuwe hak ke kaunsil. Hɨrak kemerɨr God kaknen naanmɨpre mɨt. Hɨrak ap kɨnaain au, te hɨrak ken kɨr Pailat kitɨwekhi ke herwe yɨnk ke Jisas. ");
INSERT INTO avt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat han kitet kar ik: “Jisas epei kaa? Ko!” Te hɨrak kenɨne mɨtɨk iuwe soldia kerek naanmɨpre mɨt soldia han, hɨrak kitɨwekhi me Jisas epei kaa o au. ");
INSERT INTO avt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mɨtɨk eik ketpɨwek Jisas epei kaa, te Pailat kewis Josep kakɨthis herwe yɨnk kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep hɨrak kewɨr pewek keit laplap yaaim mɨre hike, hɨrak kenke Jisas yɨnk kɨrak kewɨr laplap keweiknenik kewapɨnek kewisɨk kekre hei ke nan iuwe. Epei au, hɨrak keriuwet nan iuwe keiyepet hei hɨm kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria pe wit Magdala wetike Maria miye pe Joses, hɨr nɨr wit Josep kewis Jisas kɨwaairi. ");
INSERT INTO avt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Maain wɨ Sabat hɨram epei men, Maria pe wit Magdala wetike Salomi, hɨr netike Maria miye pe Jems, hɨr neit menmen yaaim mɨnɨn neiyɨm nen nanɨr Jisas nanwen yɨnk kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wepni kewep kan hekrit iuwe me wɨ Sande te hɨr nen hei kɨrak. ");
INSERT INTO avt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hɨr nepnen hɨr natɨpan nar ik: “Keimɨn kakɨnkawɨr nan kɨwapɨn weipɨr kɨhi kentar nan hɨrak nɨmenuk?” ");
INSERT INTO avt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hɨr nen menep ein hɨr nɨkaamnaan nɨr nan keit pɨnak ein. Nɨpaa mɨtɨk hak keweiknɨk keriuwetek ken pɨn ein. ");
INSERT INTO avt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hɨr nen nɨpiun hei eik, hɨr nen nitetik nen nɨmɨn ein. Te hɨr nɨr mɨtɨk pipɨak kau yeno me pɨnak me his yaaim. Hɨrak kamɨr laplap nokim yaaim hɨram mɨre hike. Te hɨr nehɨnhɨn han kekrit neriuwerek. ");
INSERT INTO avt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hɨrak ketpor kar ik: “Yi ap einaain au. Yi yɨnyatɨn Jisas ke wit Nasaret kerek hɨr mɨt newenekik kau nu tentarakɨt. Hɨrak epei kekrit kau. Hɨrak kepu in au. Yi eiyɨr yeno nɨpaa hɨr newisɨk kɨwaairi. ");
INSERT INTO avt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","In ek yi eino eitɨp Pita ketike mɨt disaipel han Jisas ketpor kar ik: ‘Hi ehinɨni ano provins Galili.’ Maain yi eiyɨrek eiyɨt ein eiyɨr ke nɨpaa hɨrak epei ketpi.” ");
INSERT INTO avt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hɨr miyapɨr nen witeik nɨrɨr nen ein, hɨr nepɨrpɨr iuwe han kekrit neriuwerek. Hɨr natɨp mɨt hɨm au. Hɨr nɨnaain nekintɨp nen. ");
INSERT INTO avt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Me wɨ Sande hekrit enum eik, Jisas kekrit kɨnaaiwɨr hei. Hɨrak kekrit kau wanewik, hɨrak kinɨn kewepyapɨr hɨrekes me ninaan me Maria pe wit Magdala. Nɨpaa hɨrak kepɨr herwe enum mar hispɨnak wik (7) mekrerep hɨram metpaan men mɨnaiwɨrep. ");
INSERT INTO avt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hɨre epei wɨr Jisas, te hɨre wen watɨp mɨt nɨpaa netikerek hɨr nariyan. Hɨr wen han tewenɨnek nɨkɨtek. ");
INSERT INTO avt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hɨre wen wetpor hɨre wɨrek hɨrak kepu, te hɨr nemtau hɨm mɨre au. ");
INSERT INTO avt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Maain mɨtɨkɨt wik tɨrak ten wit hak tɨrek, te hɨrak keweikɨnhis hɨrekes kɨre mɨtɨk hak. ");
INSERT INTO avt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hɨrakɨt nepei terteiyek, hɨrakɨt pɨke ten tatɨp mɨt disaipel han nɨrak, te hɨr nemtau hɨm mɨrakɨt au. ");
INSERT INTO avt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Maain, hɨr mɨt disaipel nɨrak hiswiyen kiutɨp (11) nau naam menmen, Jisas kan keneri kentar hɨr han to enuk nepu, hɨr ap nemtau hɨm me mɨt nɨpaa nepei nɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hɨrak ketpor kar ik: “Yi eino heriyai heriyai eirer wit wit kerek mɨt miyapɨr newi, yi eiwepyapɨr hɨm yaaim mai, mɨt yapɨrwe nanɨmtewem. ");
INSERT INTO avt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Neimɨn nanɨmtau hɨm mai nanisesim, yi eikɨri. Maain God kaktorhis, hɨr mɨt miyapɨr nɨrak. Neimɨn nemtau hɨm nanisesim au, God han kitet menmen enum hɨr nɨrɨakem skelim mɨt kakɨnterim. ");
INSERT INTO avt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mɨt kerek hɨr nises hɨm mai, hɨr nanrɨak menmen im nankinau niuk mai. Hɨr nanpɨr herwe enum hɨram mamno, hɨr natɨp hɨm ham nɨpaa hɨr nerteiyem au. ");
INSERT INTO avt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hɨr nantenen manpen o yenmik o hɨr nanɨm menmen enum menep mɨt, hɨr ap te nani au, hɨr nanu werek. Hɨr nanwis his mamɨntar mɨt hɨr nɨnap, te maain hɨr nanre yaain.” ");
INSERT INTO avt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mɨtɨk Iuwe Jisas ketpor epei au, God ketɨwekhis ken wit kɨrak. Hɨrak ken kau menep his yaaim me God. ");
INSERT INTO avt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Maain mɨt disaipel nɨrak hɨr nen heriyai heriyai nerer wit wit mɨt miyapɨr newi, hɨr newepyapɨr hɨm me Jisas. Mɨtɨk Iuwe Jisas hɨrak kekepi hɨr nɨrɨak menmen yaaim kerek nɨpaa kerek mɨt nɨrem au. Te mɨt hɨr nertei hɨm im mɨt netporem hɨram yaaim. ");
INSERT INTO avt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kai yinak Tiofilas. Mɨt yapɨrwe hɨr nepei newis menmen kerek epei man metɨn ke nɨmɨn ke haiu mɨt, kerek haiu misesim. ");
INSERT INTO avt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Hɨr newis menmen kerek mɨt nɨpaa ninɨn epei nɨr menmen im newepyapɨrem hɨr netpaiyem. ");
INSERT INTO avt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mɨtɨk iuwe, hi Luk hi hertei werek menmen yapɨrwe epei mekrit man ere in. Te hi han kitet hɨram yaaim hi hewisut tɨwei ik ek hetput menmen werek werek epei man. ");
INSERT INTO avt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hi hɨrɨakem te ti ertei menmen werek werek kerek nɨpaa hɨr mɨt epei netpiyem. ");
INSERT INTO avt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nɨpaa me wɨ mɨtɨk King Herot hɨrak kɨre mɨtɨk iuwe naanmɨpre mɨt ne provins Judia, mɨtɨk pris niuk mɨrak Sekaraia kepu. Hɨrak ke weiwɨk me pris niuk mɨr Abaisa. Hɨrak mɨte pɨrak niuk mɨre Ilisabet, hɨre pe weiwɨk ham me pris han. Hɨr nepenyerer ne maam nɨpu kiutɨp Eron. ");
INSERT INTO avt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hɨrak ketikerep nau werek werek nises God. Hɨr nises hɨm me Mɨtɨk Iuwe God werek werek nɨpaa hɨrak kewet Moses em. ");
INSERT INTO avt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hɨr ap nine nɨkerek nei au nentar Ilisabet hɨre enu tenmɨn (o rumaa). Hɨre wetike Sekaraia epei enun ne mɨt. ");
INSERT INTO avt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wɨ ham Sekaraia wen kɨrɨak menmen kɨre mɨtɨk pris keit wɨnak ke God. Hɨrak weiwɨk mɨrak hɨram wɨ mɨr te hɨr nanwensi kuri nanwet God em. ");
INSERT INTO avt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Hɨrak kɨrɨakem kentar hɨr nises menmen nɨpaa mɨt pris netpim hɨr neretɨt satu God kehimɨtanek hɨrak kakno kakɨkre wɨnak iuwe ke God hɨrak kaktenen si keiyɨm kakɨsi kuri tɨwei mamɨntar kɨnaan newenɨpi God neriuwerem. Hɨrak ken en kesi kuri tɨwei. ");
INSERT INTO avt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hɨrak kesi kuri tɨwei, mɨt yapɨrwe ne Isrel nererik nau wit eik nitehi God menmen. ");
INSERT INTO avt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hɨrak keit nɨmɨn en, mɨtɨk ensel keke wit ke Mɨtɨk Iuwe God kan kerp kenke ken his yaaim me kɨnaan kerek Sekaraia kewis menmen mɨnɨn mɨre kuri tɨwei hɨram mɨwaai menterim. Hɨrak kewepyapɨr hɨrekes te Sekaraia kɨrek. ");
INSERT INTO avt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mɨtɨk Sekaraia kɨrek, hɨrak han kepɨrpɨr hɨrak kɨnaain, ");
INSERT INTO avt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","te mɨtɨk ensel ketpɨwek kar ik: “Sekaraia, ti ap hɨnapen au emɨt! God kemtau menmen ti epei hitɨwekhiyem, te mɨte pit Ilisabet tewen wawine nɨkan hɨrak kei. Yi yaiwisɨwek niuk mɨrak Jon. ");
INSERT INTO avt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti etike mɨte pit han yaaik eiyu. Mɨt yapɨrwe nanɨrek hɨr han yaaik nanɨntar miye hɨre winaak. ");
INSERT INTO avt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hɨrak maain God han kitet hɨrak kakre mɨtɨk iuwe kakinɨn mɨt han nisesik. Hɨrak ap te kakɨm tɨpar wain o tɨpar si enum au emɨt! Me wɨ miye winaak wen au, God Hɨmɨn Yaaik kaku kakɨkre han kɨrak kakneisesik. ");
INSERT INTO avt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hɨrak te kakɨkaap mɨt yapɨrwe ne Isrel nanweikɨn sip nanwet menmen enum hɨr pɨke nanises hɨm me God kɨr. ");
INSERT INTO avt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hɨrak kakinɨn mɨtɨk iuwe kakno kakrer wit wit kaktɨp hɨm me God kakriuwe menmen iuwe kakri han ke mɨt kakɨr nɨpaa mɨtɨk Ilaija ketpim. Hɨrak kakɨkaap haairer nantike nɨkerek nɨr nanu han kiutɨp. Hɨrak kakweikɨn mɨt enun nises menmen enum te hɨr pɨke nanises menmen mɨt yaain nisesim. Hɨrak kakɨkaap mɨt nanises mɨtɨk iuwe, hɨr nanu naanmeriyɨwek hɨrak kaknen kaktorhis.” ");
INSERT INTO avt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mɨtɨk ensel katɨp epei au, mɨtɨk Sekaraia kitɨwekhi kar ik: “Harkeik te hi ertei menmen im ti hetpewem hɨram werek? Hi epei enuk he mɨtɨk te mɨte pai hɨre epei enu we mɨte.” ");
INSERT INTO avt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hɨrak ensel kewenhi ketpɨwek, “Hi ensel Gebriel hi herp ninaan me God hɨrɨak menmen mɨrak. Hɨrak keriuweta hi han hetput hɨm yaaim im e. ");
INSERT INTO avt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","In ek ti ap atɨp hɨm mei taau ere wɨ menmen mamnen hi epei hetputem hentar ti ap han kitet hɨm mai. Ti ap atɨp hɨm mei ere wɨ me menmen im God kehimɨtanem hɨram mamnen.” ");
INSERT INTO avt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ensel ketpɨwek menmen, mɨt wen nemerɨr Sekaraia keit nɨmɨn en hɨr nanɨrtei kenmak te hɨrak kepeit wɨnak iuwe ke God. ");
INSERT INTO avt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sekaraia ketpaan kan, hɨrak ap ketpor, te hɨr nertei hɨrak epei kepu kɨtyak kɨr menmen keit wɨnak nɨmɨn en. Hɨrak ap kaktɨp hɨm mei miutɨp te hɨrak kewɨr his ketpor keriuwerem. ");
INSERT INTO avt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wɨ hɨrak kɨrɨak menmen kekre wɨnak ke God epei au, mɨtɨk Sekaraia pɨke ken wɨnak kɨrak. ");
INSERT INTO avt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Maain wɨ ham mɨte pɨrak Ilisabet wetu, te hɨre ap wɨnaaiwɨr wɨnak wenke hispɨnak (5) ere hɨre tu iuwe miyapɨr nertei hɨre wetu. Hɨre watɨp, ");
INSERT INTO avt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“In ek Mɨtɨk Iuwe God kekepa mar im. Hɨrak epei kepɨr menmen kenipa yɨnk enuk me ninaan me mɨt miyapɨr hentar nɨpaa hi hine nɨkerek au.” ");
INSERT INTO avt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Me wenke kar hispɨnak kiutɨp (6) mɨte Ilisabet wepɨtu, God keriuwet ensel Gebriel ken wit niuk mɨrak Nasaret keit provins Galili. ");
INSERT INTO avt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hɨrak kaktɨp mɨte nɨhan niuk mɨre Maria. Haai kɨre kehimɨtenep wautike mɨtɨk niuk mɨrak Josep, hɨrak nepenyek ke maam nɨpu kɨr Devit. ");
INSERT INTO avt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ensel ke God kan kɨrep ketpɨwe kar ik: “Ti han yaaik ehu. Han yaaik ke God kau ketikewit. Hɨrak God ketikewit kakrekyut yaaim.” ");
INSERT INTO avt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɨte Maria wemtau hɨm im kerek ensel ketpim te hɨre han kekrit han kitet war ik: “Kenmak hɨrak ketpo kar ik?” ");
INSERT INTO avt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Te ensel ketpɨwe, “Ti ap enapen Maria. God han yaaik keriuwit kakrekyut yaaim im e. ");
INSERT INTO avt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Maain ti ehɨtu te ti eine nɨkan, ti ewis niuk mɨrak Jisas. ");
INSERT INTO avt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“Hɨrak kakre Mɨtɨk Iuwe mɨt nanɨnewek Nɨkan ke God hɨrak Mɨtɨk Iuwe. God kakrɨakek kakre Mɨtɨk Iuwe naanmamre mɨt kakre nɨpaa maam kɨrak Devit. ");
INSERT INTO avt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hɨrak naanmamre mɨt ne Isrel kerek hɨr nepenyerer ne mɨtɨk Jekop kerek nɨpaa enum eik hɨrak kepu. Hɨrak naanmamre mɨt hɨrak kaku kakɨt tipmain tipmain enum eik. Menmen mɨrak ap te mamesi taau.” ");
INSERT INTO avt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mɨte Maria watɨp ensel ke God war ik: “Hi ap hɨwaai hetike mɨtɨk hak au. Mamɨrkeik te hi ahɨtu?” ");
INSERT INTO avt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ensel ke God kewenep ketpɨwe, “God Hɨmɨn Yaaik kaknen kaku kakɨnterit kakriuwe menmen iuwe me God. Mɨt nankinaak hɨrak Nɨkan yaaik ke God nanɨntar God Hɨmɨn Yaaik kewis nɨkan yaaik ik kekre tu kit maain ti einaak. ");
INSERT INTO avt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ti han kitet menmen God kɨrɨak wekeni pit Ilisabet em. Mɨt nɨpaa natɨp hɨre enu tenmɨn (o rumaa) ap te wawine nɨkerek au. Te hɨre hɨrehes weriuwet wenke hispɨnak kiutɨp (6) hɨre nɨkan kewiye. Te hɨre epei we mɨte. ");
INSERT INTO avt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ap te menmen mei miutɨp te God ap kakrɨakem taau.” ");
INSERT INTO avt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria watɨp, “Hi hɨre mɨte hanhan hises menmen God hanhan kakrɨakem, te menmen mamnen mamɨr ke ti epei hetpim.” Hɨre watɨp epei au, Ensel ke God kɨnaiwɨrep ken. ");
INSERT INTO avt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ensel ke God kɨnaiwɨrep, wɨ ham kike Maria wemani menmen wekrit waswas wen wit menep mɨniu (o neiyɨp) yapɨrwe me provins Judia. ");
INSERT INTO avt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hɨre wen wɨnak ke mɨtɨk Sekaraia, hɨre watɨp Ilisabet, “Ti yaaip.” ");
INSERT INTO avt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilisabet wemtau Maria watɨp hɨre yaaip te nɨkan kekre tu kehɨn kekrerep. God Hɨmɨn Yaaik kau kekre han ke Ilisabet keneisesye, ");
INSERT INTO avt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","te hɨre watɨp weriuwe hɨm iuwe, “God kakrekyut ti han yaaik ehinɨn miyapɨr han. God kakrɨak yaaim ke nɨkan ti ehinaak. ");
INSERT INTO avt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hi mɨte weiniye te hi han yaaik menmen iuwe im man hi, te Mɨtɨk Iuwe God miye pɨrak wan wɨra. ");
INSERT INTO avt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hi hemtau hɨm mit epei au, te nɨkan kekre tu kai han yaaik kehɨn. ");
INSERT INTO avt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ti han yaaik iuwe hentar ti hises hɨm kerek God ketpim. Maain God kakrɨak menmen hɨrak nɨpaa ketputem.” ");
INSERT INTO avt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria watɨp, “Hi han kai yaaik ewenɨpi niuk me Mɨtɨk Iuwe God. ");
INSERT INTO avt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Hi han yaaik hentar maain God kakɨkepa kaktauhis. Hi mɨte hɨrɨak menmen mɨrak hi enu weiniye, ");
INSERT INTO avt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","te hɨrak hanhan keriuwa. Te in ek ere maain mɨt yapɨrwe nantɨp God kerekya hi han yaaik iuwe, ");
INSERT INTO avt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","hentar menmen iuwe hɨrak kerekyewem. Niuk mɨrak yaaim iuwe. ");
INSERT INTO avt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hɨrak hanhan keriuwe mɨt kerek hɨr nisesik newenɨpiyek, me mɨt nɨpaa ein nepu ere in. ");
INSERT INTO avt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hɨrak kɨrɨak menmen keriuwe menmen mɨrak iuwe, hɨrak keiyɨm kepɨr mɨt kerek enun hanhan hɨras nɨrɨak menmen mɨr enum hɨr nen. ");
INSERT INTO avt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Hɨrak kepɨr mɨt iuwe naanmɨpre mɨt, hɨrak kewisi hɨr nau weinɨm, te hɨrak kewis mɨt weinɨn hɨr nɨre iuwe. ");
INSERT INTO avt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hɨrak epei kewet mɨt enun nau weinɨm nɨnpɨ maan kewetɨr menmen wɨsenum ere tu iuwe, te hɨrak keriuwet mɨt netenen menmen yapɨrwe ne his nen. ");
INSERT INTO avt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hɨrak kises hɨm kerek nɨpaa katɨp maamrer naiu yem. Hɨrak kan kakɨkaap mɨt nɨrak ne wit Isrel. ");
INSERT INTO avt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hɨrak han kitet keriuwe Ebraham nɨpaa kau tɨ ketike nepenyerer in ek nepu tɨ. Hɨrak kerekyor yaaim tipmain tipmain enum eik, kar ke nɨpaa hɨrak ketpim.” ");
INSERT INTO avt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hɨre watɨp menmen im epei au, mɨte Maria wau wetike Ilisabet ere wenke wikak. Maain wenke wikak epei man men, hɨre pɨke wen wit kɨre eik. ");
INSERT INTO avt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wɨ epei man te mɨte Ilisabet weteiknen, hɨre wine nɨkan. ");
INSERT INTO avt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mɨt nɨre nau menep netikerep hɨr netike paaprer nɨre nemtau God kerekyɨwe yaaim hɨre wine nɨkan te hɨr nan nɨrep han yaaik netikerep. ");
INSERT INTO avt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Maain nɨkan kɨre kepu wɨ hispɨnak wikak (8), hɨr nerekir yɨnk kɨrak, hɨr nanwis niuk mɨrak Sekaraia kakrerɨr haai kɨrak. ");
INSERT INTO avt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Te miye pɨrak watɨp, “Au, hi ewis niuk mɨrak Jon.” ");
INSERT INTO avt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te hɨr netpɨwe, “Ap te paap o tete o keimɨn niuk mɨrak mar em te ti ewisɨk kakrerim taau!” ");
INSERT INTO avt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Te hɨr natɨp nitehi haai kɨrak neriuwe his main main, “Ti ewis niuk me nɨkan ik ek kakrar keimɨn?” ");
INSERT INTO avt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hɨrak Sekaraia kitorhi nanwetɨwek tɨwei te kakwis niuk mamwik. Hɨr newetɨwekem te hɨrak kewis menmen im mewim: “Niuk mɨrak Jon.” ");
INSERT INTO avt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hɨr wen han kekrit natɨp me menmen im, Sekaraia han kewep katɨp kewenɨpi niuk me God. ");
INSERT INTO avt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Te mɨt netikerek nau menep hɨr nepɨrpɨr te hɨm me menmen im men merer wit wit meit mɨniu (o neiyɨp) me Judia. ");
INSERT INTO avt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Te neimɨn kerek nemtewem hɨr han kitetim nitehiyan, “Te nɨkan ik e maain kakrɨak mekam?” Mɨt nertei God kau ketikerek kewetɨwek menmen mɨrak iuwe. ");
INSERT INTO avt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon haai kɨrak Sekaraia God kewis Hɨmɨn kɨrak yaaik kekre han kɨrak te hɨrak katɨp menmen maain mamnen. ");
INSERT INTO avt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Hɨrak katɨp kar ik: “Haiu emrɨak menmen emwenɨpi niuk me Mɨtɨk Iuwe God ke Isrel. Hɨrak epei kan kakɨkepai haiu mɨt nɨrak haiu mamnaaiwɨr menmen enum hɨrak kaktaihis. ");
INSERT INTO avt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Hɨrak God kewetei Mɨtɨk Iuwe manpenuk kakɨkepai te kaktaihis, hɨrak ke weiwɨk me Devit hɨrak mɨtɨk kɨrɨak menmen me God. ");
INSERT INTO avt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hɨrak keweteiyek kar ke nɨpaa enum eik hɨrak katɨp mɨt nɨrak profet menmen hɨr newisɨm mau tɨwei newepyapɨr maamrer nai yem. Hɨram matɨp menmen im. ");
INSERT INTO avt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","God katɨp hɨrak kakɨkepai kaktaihis mamkeipɨn mɨt enun nepan hɨr han enuk nɨnaain haiu mɨt. ");
INSERT INTO avt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nɨpaa hɨrak katɨp maamrer nai hɨrak maain kakrekyei yaaim kakises hɨm nɨpaa hɨrak ketpim. ");
INSERT INTO avt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Nɨpaa hɨrak ketike maam kaiu Ebraham hɨrakɨt tekiyakɨt tau teit, God ketpɨwek hɨrak kakɨkaap nepenyerer nɨrak. In ek hɨrak kakises menmen nɨpaa hɨrak ketpim, hɨrak kenipai haiu mɨt in e mamkeipɨn mɨt nepan naiu te haiu ap mɨnaain au. Haiu emisesik mamrɨak menmen mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Me wɨ yapɨrwe haiu mau tɨ ik, hɨrak kehimɨtenei haiu yaain prar prar.” ");
INSERT INTO avt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekaraia epei ketpor, hɨrak kemunaan katɨp nɨkan kɨrak kar ik: “Maain mɨt nantɨp ti mɨtɨk profet kerek ewepyapɨr hɨm me God iuwe kinɨn menmen yapɨrwe. Ti kerekek ehinɨn eno etɨp mɨt enɨnaaiwɨr menmen enum emɨt enmerɨr Mɨtɨk Iuwe kaknen. ");
INSERT INTO avt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ti tewen atɨp haiu mɨt nɨrak ne Isrel hɨrak kakɨsak menmen enum haiu mɨrɨakem hɨrak kaktaihis. ");
INSERT INTO avt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God kɨrɨak menmen im kentar hɨrak yaaik hanhan keriuwai haiu mɨt. ");
INSERT INTO avt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mɨtɨk Iuwe kɨrak hɨrak kɨre wepni kewep kan kɨr krusai haiu mɨt ne tɨ ik te hɨrak kaknaaiwɨr wit ke God kaknen kaktɨp haiu mɨt han kaiu enuk toto metari hɨm me God kakɨtpai hɨm mɨrak yaaim. Haiu mau enum mɨnaain mami te hɨrak kaknen kakteiknai yayiwe kɨrak yaaik te haiu mamu werek werek.” ");
INSERT INTO avt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Maain nɨkan Jon kɨniu kɨre iuwe, han kɨrak tokik ap te kɨnapen mɨt au. Hɨrak kepu wit weinɨk mɨt newi au ere maain wɨ hɨrak kewepyapɨr hɨrekes katɨp mɨt ne wit Isrel hɨm me God. ");
INSERT INTO avt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Me wɨ keremem Ilisabet wine Jon, mɨtɨk iuwe Sisa Ogastas kesiuwe hɨm men katɨp mɨt miyapɨr nerer wit wit gavman ne Rom naanmɨpror hɨr enɨnen enwis niuk mɨr emu tɨwei. ");
INSERT INTO avt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Me wɨ im mɨt newisor niuk mɨr mau tɨwei, mɨtɨk iuwe Sairinias hɨrak kɨre mɨtɨk iuwe gavman naanmɨpre mɨt ne provins Siria. ");
INSERT INTO avt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hɨr mɨt yapɨrwe niutɨp niutɨp pɨke nen wit kɨr kerek nɨpaa maamrer nɨr ninɨn newiyen te hɨr enwis niuk mɨr mau tɨwei emɨt. ");
INSERT INTO avt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mɨtɨk Josep kɨnaaiwɨr wit Nasaret keit provins Galili hɨrak ken provins Judia keit wit niuk mɨrak Betlehem kerek nɨpaa mɨtɨk iuwe Devit miye pɨrak winaak keitai en. Josep ken en kentar hɨrak hɨrekes nepenyek kei ke Devit. ");
INSERT INTO avt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hɨrak ken kakwis niuk mɨrak mamtike niuk me mɨte pɨrak Maria kerek nɨpaa hɨr epei nehimɨtan te hɨr nanɨtan. Hɨre epei nɨkan kekrerep. ");
INSERT INTO avt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Hɨr neit wit Betlehem, wɨ epei man te hɨre weteiknen wawine nɨkan. Hɨre wine nɨkan kɨre iuwe mɨtɨk, hɨre weit laplap weiyɨm weweiknenik wewisɨk kekre tɨkenup iuwe kerek hɨr newet bulmakau menmen mekrerek. Hɨr newisɨk kekrerek nentar wɨnak pasenda kerek mɨt nererik nɨwaairi en nɨpaa mɨt yapɨrwe nɨpwaairi nererim te yeno meiyam ap weinɨm meit au. Mɨt nɨwaai rem nererim nenemtɨn te hɨr nen nɨwaai weisaak ke bulmakau, hɨre wine nɨkan weitai. ");
INSERT INTO avt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Menep wit ik kerek mɨte Maria wine nɨkan, mɨt han neit ni naanmɨpre sipsip ne wɨtaan. ");
INSERT INTO avt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hɨr naanmɨpre sipsip ne wɨtaan, ensel kiutɨp ke Mɨtɨk Iuwe kewepyapɨr hɨrekes menmen iuwe me God merhɨhe mɨriusor te hɨr nɨnaain nepɨrpɨr iuwe. ");
INSERT INTO avt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hɨr nepɨrpɨr iuwe, ensel ketpor kar ik: “Yi ap einaain au emɨt! Hi epei han etpi hɨm yaaim mamnip mɨt nerer wit wit han yaaik nanu. ");
INSERT INTO avt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Me wɨtaan ik ek mɨte wine nɨkan weit wit ke Devit niuk mɨrak Betlehem. Hɨrak mɨtɨk God kehimɨtanek hɨrak Mɨtɨk Iuwe kakɨkaap mɨt kaktorhis. ");
INSERT INTO avt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Menmen im hi hetpiyem mamteikni hi hemitipɨn au. Yi yayɨr nɨkan miye wenke laplap weweiknenik keriuwerem kɨwaai wewisɨk kekre tɨkenup ke bulmakau naam menmen mekrerek, hɨrak kɨwaairi.” ");
INSERT INTO avt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wasenum ensel nɨre yapɨrwe ne wit ke God hɨr newepyapɨr hɨras nerp netike ensel, hɨr nine henye newenɨpi niuk me God natɨp hɨm im: ");
INSERT INTO avt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Haiu hanhan yi mɨt eiwenɨpi niuk me God. Yi mɨt miyapɨr yau tɨ yi eikiyan eiyu eiyɨt eiyɨntar God han yaaik keriuwi.” ");
INSERT INTO avt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensel nine henye epei au, hɨr nen nekeipnor pɨke nen wit ke God, te mɨt kerek naanmɨpre sipsip en natɨpan, “Sɨs, haiu emno wit Betlehem emɨr menmen epei man, kerek Mɨtɨk Iuwe God ketpaiyem.” ");
INSERT INTO avt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Te hɨr nesiukɨn nen nɨnapɨn Maria wetike Josep, hɨr nɨr nɨkan kɨwaai kekre tɨkenup. ");
INSERT INTO avt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mɨt kerek naanmɨpre sipsip hɨr nɨrek epei au, hɨr netpor menmen ensel epei nan netporem me nɨkan ik e. ");
INSERT INTO avt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mɨt yapɨrwe kerek nemtau hɨm mɨt naanmɨpre sipsip netporem, hɨr han kitet menmen im epei man. ");
INSERT INTO avt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria han kaa menmen au. Hɨre wewisɨm mekre han kɨre, hekrit hekrit hɨre han kitetim. ");
INSERT INTO avt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mɨt naanmɨpre sipsip pɨke nen nɨr ein newenɨpi God natɨp hɨrak yaaik iuwe nentar menmen ensel netporem metike menmen hɨr nɨrem hɨram mar ke ensel epei netporem. ");
INSERT INTO avt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wɨ hispɨnak wikak (8) epei man te Maria wine nɨkan, te hɨr neiyɨk nen nerekir yɨnk kɨrak. Hɨr newis niuk mɨrak Jisas. Niuk im Ensel katɨp Maria em nɨpaa hɨre ap wepɨtu wen au. ");
INSERT INTO avt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maain wɨ epei man te hɨm me Moses Mau tɨwei matɨp mɨte waukɨr te God kaktɨp hɨre yaaip. Me wɨ im Maria wetike Josep nɨnan Jisas neiyɨk nen wit Jerusalem newet God ek. ");
INSERT INTO avt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hɨr nen Jerusalem newet God ek nentar hɨm nɨpaa God kewet Moses hɨrak kewisɨm mau tɨwei matɨp mar im: “Nɨkerek hɨrakɨt iuwe mɨtɨkɨt miyapɨr ninakɨt hɨr mɨt nehimɨtanet hɨrakɨt te God.” ");
INSERT INTO avt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hɨr nen newet mɨtɨk pris menmen kakwet God em nises hɨm God kewet Moses em kewisɨm mau tɨwei matɨp mɨt enwet God hore nɨmanp wik o tapɨ wik wen tɨpniu. ");
INSERT INTO avt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mɨtɨk kiutɨp kau Jerusalem niuk mɨrak Simion. Hɨrak mɨtɨk yaaik kises God werek werek. Hɨrak kemerɨr Mɨtɨk God kehimɨtanek kaknen kakɨkaap mɨt ne Isrel. God Hɨmɨn Yaaik kau ketikerek. ");
INSERT INTO avt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Hɨrak keteiknɨwek ap te kaki ere hɨrak kakɨr Mɨtɨk Iuwe Krais kerek God kehimɨtanek kaknen kakɨkaap mɨt. ");
INSERT INTO avt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","God Hɨmɨn Yaaik kɨkɨak han kɨrak te hɨrak ken wɨnak iuwe kerek mɨt nererik newenɨpi niuk me God. Maain miye haai ne nɨkan Jisas neiyɨk nen wɨnak iuwe ke God eik e nanwet God menmen hɨm me Moses mau tɨwei metpim. ");
INSERT INTO avt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion kɨr nɨkan kɨr hɨrak kɨnanek kewenɨpi God katɨp kar ik: ");
INSERT INTO avt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“In ek Mɨtɨk Iuwe God ti epei hises hɨm nɨpaa ti epei hetpewem, te ti ewisa hi mɨtɨk hi hɨrɨak menmen mit, hi han yaaik hahi. ");
INSERT INTO avt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hi han yaaik hahi ehɨntar hi epei hɨr Mɨtɨk ti hehimɨtanek hɨrak kakɨkaap haiu mɨt ne Isrel. ");
INSERT INTO avt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ti epei hɨrɨak menmen im merp nɨmɨn me mɨt miyapɨr yapɨrwe nerer wit wit. ");
INSERT INTO avt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hɨrak kakre wepni (o yanm) kɨr kakteikɨn mɨt yayiwe, hɨrakkakteikɨn mɨt miyapɨr ap ne weiwɨk me Isrel amɨrkeim te hɨr enises hɨm me God. Hɨrak Mɨtɨk Iuwe kakinɨn naanmampre haiu mɨt ne Isrel, te mɨt miyapɨr nerer wit wit hɨr nantɨp nanɨr ik: ‘God epei kɨrɨak menmen yaaim.’” ");
INSERT INTO avt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josep ketike Jisas miye pɨrak hɨr nemtau menmen Simion katɨp me nɨkan te hɨr nepɨrpɨr han kitetim. ");
INSERT INTO avt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hɨr nepɨrpɨr, Simion kitehi God kakrekyor yaaim katɨp Maria miye pe Jisas kar ik: “God kehimɨtan Nɨkan ik e kaknip mɨt han yapɨrwe ne Isrel nanɨwaank nanɨt. Mɨt han yapɨrwe au, God kaktorhis nanu werek. Hɨrak kɨre Mɨtɨk God kakteikɨn mɨt han kɨrak keriuwerek te mɨt yapɨrwe hɨr nantikerek nanɨnehan nanweikɨn sip nanwetɨwek. ");
INSERT INTO avt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Te hɨrak kakwepyapɨr menmen mɨt han kitetim. Maain menmen enum mamɨr ke mɨt newɨr yipo nenep mɨtɨk, mɨt nanrekyɨwek enum mamrekir han kit te mamwetit han enuk.” ");
INSERT INTO avt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mɨte piutɨp niuk mɨre Ana hɨre wepu en. Hɨre mɨte profet hɨre wewepyapɨr hɨm me God. Hɨre nɨki pe mɨtɨk Fanyuel, hɨrak ke weiwɨk me maam nɨpu kɨrak Asa. Hɨre we mɨte enu, hɨre wepu wetike mɨtɨk kɨre tito mar hispɨnak wik (7). ");
INSERT INTO avt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Maain tito mar hispɨnak wik (7) epei au, hɨrak kaa te nɨpaa ere in 84 tito epei men, hɨre wepu weiniye. Wɨtaan wanewik hɨre wewenɨpi niuk me God, hɨre wepu menep wɨnak iuwe ke God wɨnaiwɨrek au. Me wɨ ham hɨre nɨnpɨ maau wepu, hɨre watɨp God menmen. ");
INSERT INTO avt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Josep ketike Jisas miye Maria hɨr wen nepu wɨnak iuwe ke God newet God menmen, mɨte ip e wan wewenɨpi niuk me God wepɨr ke Simion kewenɨpiyek. Hɨre watɨp mɨt neit Jerusalem kerek hɨr nemeriyɨwek kaknen kakɨkaap mɨt ne Isrel hɨre wetpor me nɨkan ik e. ");
INSERT INTO avt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hɨr nɨrɨak menmen hɨm me Moses matɨp hɨr nanisesim epei au, hɨr pɨke nen provins Galili hɨr nau wit kɨr Nasaret. ");
INSERT INTO avt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nɨkan kɨniu kɨre iuwe hɨrak manpenuk kepu hɨrak kertei menmen werek werek wɨsenum God kerekyɨwek yaaim. ");
INSERT INTO avt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tito miutɨp miutɨp miye haai ne Jisas nen wit Jerusalem me wɨ Pasova kerek mɨt ne Isrel nererik naam menmen han tewenɨn wɨ God kenep mɨt ne Isip te hɨr au, hɨrak keriyei nɨnaaiwɨr Isip. ");
INSERT INTO avt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Maain Jisas hɨrak 12 tito epei au, hɨrak ketike miye haai nen Jerusalem nises menmen me wɨ Pasova mar ke nɨpaa hɨr nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wɨ me Pasova epei au, hɨr pɨke nanɨno, te Jisas wen kepeit wit Jerusalem. Te Josep ketike Jisas miye pɨrak au netariyek. ");
INSERT INTO avt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hɨr han kitet hɨrak epei kinɨn ken ketike mɨt nɨr han te hɨr nen ere wɨtaan. Wɨtaan, hɨr nɨnetnɨwek nitet mɨt nɨr ne wit eik o paaprer nɨrak te hɨr ap nɨnapɨnek au. ");
INSERT INTO avt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Te hɨr pɨke nen Jerusalem nen nɨnetnɨwek neit en. ");
INSERT INTO avt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jisas hɨrak kepeit wit Jerusalem ere wɨ wikak, hɨr nɨnapɨnek keit wɨnak iuwe ke God kau ketike mɨt iuwe nertei hɨm me Moses natɨp mɨt miyapɨr em. Hɨrak kemtau hɨm mɨr hɨrak kitorhi menmen. ");
INSERT INTO avt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hɨr mɨt kerek nemtau menmen hɨrak kewenhiyem kerteiyem hɨr han kekrit natɨp hɨrak nɨkan kertei iuwe. ");
INSERT INTO avt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Miye haai nɨrak nɨrek, hɨr han kekrit. Te miye pɨrak witɨwekhi war ik: “Nɨkan kai, ti henmak te ti herekyawɨr menmen mar im: Haai kit ketikewa hawɨr wɨnwetnut wɨkɨt. Hawɨr wɨkɨt ere hawɨr wɨnepnit.” ");
INSERT INTO avt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hɨrak kewenhi ketpor kar ik: “Yi yenmak te yi yɨnyetno? Yi yepɨtari hi ehises menmen me Haai kai heit wɨnak kɨrak au a?” ");
INSERT INTO avt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hɨr ap nertei mekam hɨrak katɨp hɨram me Haai kɨrak God. ");
INSERT INTO avt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hɨrak ketpor epei au, hɨrak ketikeri nen wit Nasaret, hɨrak kises hɨm mɨr. Te miye pɨrak wemi han hɨm mɨrak mekre han kɨre. ");
INSERT INTO avt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Maain Jisas kɨre iuwe hɨrak manpenuk enuk keit hɨrak kertei wɨsenum. God ketike mɨt nau tɨ hɨr han yaaik neriuwerek. ");
INSERT INTO avt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tito hiswiyen hispɨnak (15) epei men me Taibirias Sisa hɨrak kerekek naanmɨpre mɨt nau tɨ ik. Me wɨ im mɨtɨk iuwe Pontias Pailat naanmɨpre mɨt ne provins Judia, mɨtɨk iuwe King Herot naanmɨpre mɨt nau provins Galili. Nɨkik kɨrak Filip naanmɨpre mɨt nau provins wik niuk mɨrakɨt Ituria ketike Trakonaitas. Mɨtɨk iuwe Laisenias naanmɨpre Abilini. ");
INSERT INTO avt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mɨtɨk Anas ketike Kaiapas hɨrakɨt wik naanmɨpre mɨt pris han neit wɨnak iuwe ke God keit Jerusalem. Me wɨ im em Sekaraia nɨkan kɨrak Jon keit wit weinɨk mɨt ap newi. Me wɨ im God ketpɨwek kewetɨwek hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Epei au Jon ken kerer wit wit menep mani Jodan. Hɨrak kewepyapɨr hɨm katɨp mɨt enweikɨn sip enwet menmen enum te hɨrak kakɨkɨri nanriuwe tɨpar te God kakɨsak menmen enum mɨr mamno. ");
INSERT INTO avt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Menmen im epei man mar nɨpaa mɨtɨk Aisaia hɨrak kewepyapɨr hɨm me God hɨrak kewisɨm mau tɨwei hɨram matɨp mɨt neweikɨn sip newet menmen enum hɨram mɨre mɨt newep yayiwe. Hɨram matɨp mar ik: “Mɨtɨk keit wit weinɨk mɨt ap newik hɨrak kɨnap katɨp, ‘Yi einetɨt yayiwe ke Mɨtɨk Iuwe yi eirɨakek yaaik akɨrak te hɨrak kakisesim werek. ");
INSERT INTO avt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yi eiwep tɨ mɨtɨt eiwɨr meri emwapɨn kerek kɨnatɨn keit ek ere ekɨrak. Yayiwe kerek keweikɨn yi eirɨakem ere ekɨrak te yayiwe kerek keweikɨn o hei mekrerek, yi eirɨakem ere emɨram. ");
INSERT INTO avt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mɨt miyapɨr nerer wit wit nanɨr mɨtɨk kerek God kehimɨtanek hɨrak kakɨkaap haiu mɨt kaktaihis.’” ");
INSERT INTO avt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hɨr mɨt miyapɨr yapɨrwe nan nɨr Jon te hɨrak kakɨkɨri. Hɨrak keneri ketpor, “Yi mɨt enun yɨre manpen o yenmik yi yewisesik. Keimɨn ketpi yi einen hi akɨri te yi eirɨr einopɨn eikeipɨn menmen enum God kakrɨakem maain mamnen a? ");
INSERT INTO avt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yi eiyinɨn eirɨak menmen te hɨram mamteikɨn mɨt yi epei yeweikɨn sip yewet menmen enum nɨpaa yi yɨrɨakem. Te yi ap yaitɨpan yayɨr ik: ‘Haiu mɨt in hɨrak Ebraham hɨrak maam nɨpu kaiu, te haiu ap mamweikɨn sip mamwet menmen enum au. Haiu mɨre mɨt nɨrak, te maain God kaktaihis.’ Menmen im taau! Hi hetpi. God hɨrak kakweikɨn nan im kakrɨakem mamɨr ke nepenyerer ne Ebraham mamɨkrehɨri yi mɨt enun. ");
INSERT INTO avt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In ek hɨne ke yerepɨ epei kɨwaai menep nu nekenpɨ te God kakremir nu ham kerek ap mine nɨkim yaaim, nɨman mamwen te mɨt nɨrak hɨr nanwɨrem mamɨkre si. Yi mɨt in yi yɨre nu ap mine nɨkim au!” ");
INSERT INTO avt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hɨrak ketpor kar ik, mɨt yapɨrwe nitɨwekhi, “Te haiu mamrɨak mekam te mamteikɨn haiu meweikɨn sip mewet menmen enum?” ");
INSERT INTO avt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon hɨrak ketpor, “Keimɨn kerek naanmɨpre sak wik, hɨrak ektike keimɨn kerekek au, hɨrakɨt etwepim etwetakɨt. O keimɨn hɨrak ketenen menmen yapɨrwe ekwet keimɨn hɨrak menmen au rek.” ");
INSERT INTO avt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mɨt han kerek nari pewek me mɨt nanwet gavman em hɨr nan nɨr Jon te hɨrak kakɨri te hɨr nitɨwekhi, “Mɨtɨk tisa, haiu mamrɨak mekam?” ");
INSERT INTO avt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hɨrak ketpor, “Yi eiyɨt pewek empar kerek mɨt ne gavman epei netpim. Yi ap eiyinɨnem eiri meiyam au emɨt!” ");
INSERT INTO avt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mɨt ne Ami nitɨwekhi, “Haiu mamrɨak mekam?” Hɨrak ketpor, “Yi ap einep mɨt eiri menmen mɨr au emɨt! Yi ap eisiuwe hɨm weinɨm au emɨt! Yi han yaaik eiyu eiriuwe menmen mɨt iuwe newetiyem.” ");
INSERT INTO avt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mɨt miyapɨr yapɨrwe han kekrit, te hɨr mɨt nitehi nekre han kɨr nar ik: “Jon hɨrak Mɨtɨk Iuwe krais kerek God kehimɨtanek kaknen kakɨkaap mɨt o au?” ");
INSERT INTO avt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Te mɨtɨk Jon ketpor yapɨrwe, “Hi hɨkri heriuwe tɨpar kerem em. Te hɨrak mɨtɨk kerek wɨsenuk kinɨna maain kakɨkaru kaknen hɨrak yaaik kɨre Mɨtɨk Iuwe, hi au hɨre mɨtɨk weinɨk. Hi ap werek hɨrɨak menmen mɨrak kiutɨp taau. Maain hɨrak kaknen hɨrak kakwis God Hɨmɨn Yaaik kaku han ki kakre si hɨrak si tatɨm menmen enum mi ere yi yaain. ");
INSERT INTO avt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hɨrak kɨre mɨtɨk keses rais mekre sar. Hɨrak kesesim epei au, hɨrak kaktenwewim hɨram haas mɨram mamnopɨn hɨrak kakɨt rais kakwisɨm mamɨkre wɨnak. Hɨrak kakwisɨm mamɨkre wɨnak, hɨrak kakripep haas kakwɨrem mamɨkre si hɨram mamɨrhɨhe ap te mami au.” ");
INSERT INTO avt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon katɨp hɨm ham me kakɨkɨakyor han kɨr me wɨ hɨrak kewepyapɨr hɨm yaaim me God. ");
INSERT INTO avt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Maain Jon katɨp kene mɨtɨk ke gavman King Herot kentar hɨrak keit Herodia, mɨte pe nɨkik kɨrak. Hɨrak kenerek kenterik ketike menmen ham enum hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Te Herot pɨke kɨrɨak menmen enum. Hɨrak kewis Jon kekre wɨnak enuk. ");
INSERT INTO avt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Herot kewis Jon kekre wɨnak enuk wen au, Jon kɨkɨr mɨt miyapɨr yapɨrwe. Hɨrak kɨkɨr mɨt miyapɨr yapɨrwe epei au, Jisas kan te Jon kɨkɨrek ketikeri. Hɨrak Jisas wen kitehi God menmen, te nepni hɨremes mewep mɨre weipɨr. ");
INSERT INTO avt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nepni hɨremes mewep mɨre weipɨr, God Hɨmɨn Yaaik keke nepni kan keweikɨnhis kɨre hore tapɨ hɨrak kenterik. God katɨp hɨm iuwe mekiuwe man matɨp mar im: “Ti Nɨkan kai yaaik. Hi han yaaik wɨsenuk heriuwit.” ");
INSERT INTO avt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Me wɨ Jisas kekrit kɨrɨak menmen mɨrak, hɨrak kepu tito mar 30. Mɨt miyapɨr han kitet Josep kine Jisas, te hɨrak au. God kerekek. Im em hɨram niuk me maamrer ne weiwɨk mɨrak: Hilai nɨpaa kine Josep. ");
INSERT INTO avt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat kine Hilai. Livai kine Matat. Melkai kine Livai. Janai kine Melkai. Josep kine Janai. ");
INSERT INTO avt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matataias kine Josep. Emos kine Matataias. Neam kine Emos. Eslai kine Neam. Nagai kine Eslai. Meat kine Nagai. ");
INSERT INTO avt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Matataias kine Meat. Semen kine Matataias. Josek kine Semen. Joda kine Josek. ");
INSERT INTO avt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan kine Joda. Resa kine Joanan. Serababel kine Resa. Sialtiel kine Serababel. Nerai kine Sialtiel. ");
INSERT INTO avt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melkai kine Nerai. Edai kine Melkai. Kosam kine Edai. Elmadam kine Kosam. Ea kine Elmadam. ");
INSERT INTO avt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josua kine Ea. Jorim kine Josua. Eliesa kine Josua. Jorim kine Eliesa. Matat kine Jorim. Livai kine Matat. ");
INSERT INTO avt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simion kine Livai. Juda kine Simion. Josep kine Juda. Jonam kine Josep. Elaiakim kine Jonam. ");
INSERT INTO avt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melia kine Elaiakim. Mena kine Melia. Matata kine Mena. Netan kine Matata. Devit kine Netan. ");
INSERT INTO avt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesi kine Devit. Obet kine Jesi. Boas kine Obet. Salmon kine Boas. Nason kine Salmon. ");
INSERT INTO avt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadap kine Nason. Admin kine Aminadap. Anai kine Admin. Hesron kine Anai. Peres kine Hesron. Juda kine Peres. ");
INSERT INTO avt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jekop kine Juda. Aisak kine Jekop. Ebraham kine Aisak. Tera kine Ebraham. Neho kine Tera. ");
INSERT INTO avt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serak kine Neho. Riyu kine Serak. Pelek kine Riyu. Iba kine Pelek. Sila kine Iba. ");
INSERT INTO avt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kenan kine Sila. Afaksat kine Kenan. Sem kine Afaksat. Noa kine Sem. Lemek kine Noa. Metusala kine Lemek. ");
INSERT INTO avt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Inok kine Metusala. Jeret kine Inok. Mahalalil kine Jerot. Kenan kine Mahalalil. ");
INSERT INTO avt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Inos kine Kenan. Set kine Inos. Adam kine Set. God kerekek kime Adam. ");
INSERT INTO avt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","God Hɨmɨn Yaaik hɨrak kɨkɨak Jisas han kɨrak te keneisesik hɨrak kɨnaaiwɨr mani Jodan. Hɨrak keriyaak ken yaank weinɨk mɨt ap newi. ");
INSERT INTO avt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hɨrak kepu en wɨ mar 40, Seten kari han kɨrak. Hɨrak ap kaam menmen mei kises wɨ kerek hɨrak kepu wit weinɨk ek au. Me wɨ yapɨrwe em, hɨrak nɨnpɨ maak. ");
INSERT INTO avt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hɨrak nɨnpɨ maak kepu en wɨ mar 40, te Seten ketpɨwek kar ik: “Ti Nɨkan ke God te ti etɨp nan ik ekweikɨn ekre bret.” ");
INSERT INTO avt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas ketpɨwek, “Hɨm me God mau tɨwei matɨp, ‘Mɨtɨk kaku werek te hɨrak ap kakɨm menmen metike tɨpar weinɨm keremem au.’” ");
INSERT INTO avt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Epei au Seten keriyaak keiyɨk ken mɨniu (o neiyɨp) iuwe kau niu ein, waswas hɨrak keteiknɨwek tɨ kerer wit wit mɨt newiyen. ");
INSERT INTO avt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hɨrak ketpɨwek kar ik: “Hi awetut wit im yapɨrwe metike menmen mɨr iuwe ti naanmamrewem te ti ehɨt niuk mit iuwe. Nɨpaa God kewetewem te hi han kai hi ewet mɨtɨk kerek hi hanhanek ewetɨwekem. ");
INSERT INTO avt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ti ewen ninɨp hitehɨr ewenaunɨpi hi iuwe te hi ewetutem.” ");
INSERT INTO avt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas pɨke ketpɨwek kar ik: “Hɨm me God mau tɨwei matɨp haiu mɨt emwenɨpi God kaiu, hɨrak iuwe kerek ek, haiu emises menmen mɨrak. Han en au.” ");
INSERT INTO avt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hɨrak ketpɨwek kar ek, Seten keriyaak keiyɨk ken wit Jerusalem kewisɨk kentɨr wɨnak siup ke wɨnak iuwe ke God ketpɨwek kar ik: “Ti Nɨkan ke God te ti ehɨtɨkɨr ehɨn eno tɨ eik. ");
INSERT INTO avt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ti ap hahi au antar hɨm me God mau tɨwei matɨp, ‘God katɨp mɨt ensel nɨrak hɨr maain his mamprut. ");
INSERT INTO avt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hɨr nanɨnanit nanriuwe his mɨr te ti ap enkewɨn antar nan enamu hɨt mit ewenem mamniu nan taau.’” ");
INSERT INTO avt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas ketpɨwek kar ik: “Hɨm me God mau tɨwei matɨp: ‘Yi mɨt ap eiri han ke Mɨtɨk Iuwe ki God te kakɨkepi au ekɨt!’” ");
INSERT INTO avt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seten kari han ke Jisas keriuwe menmen ham ham epei au, hɨrak kisesim au, hɨrak kɨnaiwɨrek ere maain wɨ ham. ");
INSERT INTO avt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","God Hɨmɨn Yaaik kekre han kɨrak keneisesik kekepik te hɨrak pɨke ken provins Galili. Hɨm me menmen Jisas kɨrɨakem men merer wit wit in. ");
INSERT INTO avt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hɨrak katɨp mɨt miyapɨr hɨm kekre wɨnak kerek mɨt nau nererik nekine hɨm me Moses, te hɨr newenɨpi niuk mɨrak natɨp hɨrak yaaik. ");
INSERT INTO avt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Maain Jisas kɨpiun wit Nasaret kerek nɨpaa hɨrak kewik ere iuwe. Me wɨ Sabat hɨrak ken kekre wɨnak kɨr kerek hɨr nekine hɨm me Moses en, hɨrak ken kar nɨpaa hɨrak kɨrɨakem, hɨrak kekrit kekine hɨm me God. ");
INSERT INTO avt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mɨtɨk kewetɨwek tɨwei nɨpaa mɨtɨk Aisaia hɨrak profet kewisɨm, hɨrak kenke tɨwei kɨnapɨn hɨm hɨram matɨp mar im: ");
INSERT INTO avt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hɨmɨn Yaaik ke Mɨtɨk Iuwe God kekre han kai kentar hɨrak kehimɨtena hi ewepyapɨr hɨm yaaim mamno mɨt enun nau weinɨm. Hɨrak keriuweta hi atɨp mɨt har ik: ‘Menmen meteneni te hi asiupeni.’ Hi akaap mɨt kerek nanamɨr toto te hɨr enɨr ein ein. Mɨt hɨr han enuk neriuwe menmen enum te hi arekyor han kɨr yaaik kakrihis me menmen im. ");
INSERT INTO avt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Hɨrak keriuweta te hi awepyapɨr hɨm me tito im God kakrɨak mɨt menmen yaaim kakɨkepi.” ");
INSERT INTO avt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hɨrak kekinaam epei au, hɨrak keiyepet tɨwei, hɨrak pɨke kewet mɨtɨk kerek naanmɨprewem hɨrak pɨke kau yeno. Epei au, mɨt yapɨrwe nekre wɨnak eik e hɨr nɨpɨrek. ");
INSERT INTO avt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hɨr nɨpɨrek, hɨrak ketpor kar ik: “Petepin hɨm mau tɨwei yi yemtau hi ekinaam hɨram epei mamnen.” ");
INSERT INTO avt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hɨr yapɨrwe netpɨwek nar ik: “Hɨm im yaaim?” Te hɨr han kitet hɨm yaaim hɨrak ketpim hɨr natɨpan nar ik: “Hɨrak nɨkan ke Josep kerek ek.” ");
INSERT INTO avt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hɨrak ketpor kar ik: “Hi hertei maain yi hanhan eiyɨtpo hɨm im kerek nɨpaa mɨt netpim nar ik: ‘Mɨtɨk ti ahɨkaap mɨt hɨr nɨnap te ti ɨkaap hɨrekes. Menmen haiu memtau ti epei hɨrɨakem meit wit Kapaneam ti erɨakem in meit wit kit haiu mamɨrem.’” ");
INSERT INTO avt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hɨrak wen ketpor, “Hi hetpi werek. Mɨt ne wit ke mɨtɨk profet hɨr ap nemtau hɨm mɨrak nanisesim au. ");
INSERT INTO avt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hi hetp werek. Nɨpaa enum eik miyapɨr yapɨrwe neit Isrel mɨkan nɨr naa hɨr nepu weinɨm. Me wɨ im Ilaija kitehi God keiyepet hawɨ keit menep ere tito wikak wenke hispɨnak kiutɨp (6) te menmen ap mewo mau ni au. ");
INSERT INTO avt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","God ap keriuwet Ilaija ken kɨkaap miyapɨr ne Isrel kerek mɨkan nɨr naa ek au. Hɨrak keriuwetek ken kɨkaap mɨte kerepep kerek mɨtɨk kɨre kaa ek, hɨre weit wit Sarefat ke wit iuwe Saidon. Hɨre ap pe weiwɨk me Isrel au. ");
INSERT INTO avt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nɨpaa enum eik me wɨ mɨtɨk profet hak niuk mɨrak Ilaisa kau tɨ, mɨt yapɨrwe ne Isrel lepro mewi, te hɨrak ap kekepi hɨr nɨre yaain au. Hɨrak kɨkaap mɨtɨk Neman ke wit Siria kerekek, ap ke weiwɨk me Isrel. Yi yɨre mɨt nɨpaa nepu en, neweikɨn sip newet mɨtɨk kɨr Ilaija. In ek yi yeweikɨn sip yeweto, te hi anaiwɨri.” ");
INSERT INTO avt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mɨt yapɨrwe hɨr neit wɨnak eik e nemtau hɨm im hɨr han enuk neriuwerek wɨsenuk nentar hɨr nertei hɨrak keneri keriuwe hɨm im. ");
INSERT INTO avt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hɨr nekrit neiyɨk nen nepɨrek kenpɨn me wit. Hɨr neriyaak neiyɨk nen mɨniu kerek wit kɨr kɨwaairi, te hɨr nanwɨrek kakɨnkewɨn kaki. ");
INSERT INTO avt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Au, God kenipi han kɨr toenuk te hɨrak keke tɨ kewepi nɨmɨn ken kɨnaiwɨri ken. ");
INSERT INTO avt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas kɨnaaiwɨr wit Nasaret ken, hɨrak kekiuwe ken kiun Kepeneam, wit hak ke provins Galili. Me wɨ Sabat hɨrak katɨp mɨt miyapɨr hɨm me God, ");
INSERT INTO avt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Te hɨr han kekrit han yaaik neriuwe hɨm hɨrak ketporem nentar hɨrak ketpor kar ke Mɨtɨk Iuwe God keriuwetek kan ketpor hɨm mɨrak iuwe. ");
INSERT INTO avt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mɨtɨk hak kau wɨnak kerek mɨt nererik nemtau hɨm me Moses mɨt nekinaam, herwe enuk ke Seten kekrerek. Te hɨrak kɨnap katɨp hɨm iuwe kar ik: ");
INSERT INTO avt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ti henmak te ti han herekyei enum Jisas ke Nasaret? Ti han awep eraiwaank mamɨt. Haiu mertei ti keimɨn. Ti Mɨtɨk Iuwe God kehimɨtenit enen akaap mɨt.” ");
INSERT INTO avt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisas kenerek katɨp, “Ti ekintɨp enke enopɨn ekeipnɨwek.” Herwe enuk kewɨr mɨtɨk kerekek kan kɨwaai tɨ kekre nɨmɨn ne mɨt yapɨrwe. Hɨrak ketpɨwek kar ik, te hɨrak herwe enuk kɨnaiwɨrek, te hɨrak ap kewaankek au. ");
INSERT INTO avt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mɨt yapɨrwe nɨrek hɨr han kekrit natɨpan nar ik: “Hɨm im mekam? Hɨrak ketpor keriuwe hɨm mɨrak hɨram iuwe te herwe mekrerek hɨram mɨnapen mɨrɨr mekeipnɨwek.” ");
INSERT INTO avt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Te hɨm me menmen Jisas kɨrɨakem men mɨt nerer wit wit nɨrapɨt Kapaneam. ");
INSERT INTO avt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas kɨkaap mɨtɨk enuk tɨpir kekrerek, hɨrak kekrit kɨnaaiwɨr wɨnak kerek mɨt nau nererik nekine hɨm me Moses mekrerem, hɨrak kɨnɨk ken wɨnak ke Saimon. Saimon maam pɨrak (miye pe mɨte pɨrak) hɨre wɨnap wɨsenum yɨnk sisi te hɨr nen netpɨwek netɨwekhis kan kakɨrep. ");
INSERT INTO avt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hɨrak ken kerp menep yeno mɨre kerek mɨte hɨre wɨnap wɨwaaiyem em, hɨrak katɨp menmen enum, te hɨram menke mekeipnɨwe. Wasenum hɨre wekrit te hɨre wewetɨr menmen wekepi. ");
INSERT INTO avt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","In ek wepni kewen ken te mɨt pɨke nepno ein ein nentar wɨ Sabat hɨram epei au, te hɨr neimɨn nɨr yinan nɨnap neriuwe menmen enum enum hɨr netorhis neri nan, hɨrak Jisas kewis his mentar hɨr mɨt miyapɨr yapɨrwe kekepi hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Herwe enum hɨram menke mekeipɨn mɨt han menepɨp mar ik: “Ti Nɨkan ke God kerekek.” Au, hɨrak keneri ketpor te hɨr ap pɨke nekrit natɨp nentar hɨr nertei hɨrak Mɨtɨk Krais kerek God kehimɨtanek kaknen kakɨkaap mɨt. ");
INSERT INTO avt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Maain teip hekrit, Jisas kɨnaaiwɨr wit ik ken wit weinɨk katɨp God menmen. Hɨrak ken wit weinɨk kitehi God menmen, mɨt nɨnetnɨwek ere hɨr nɨnapɨnek, hɨr newenek natɨp te hɨrak ektikeri enu enɨt. ");
INSERT INTO avt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Au, hɨrak ketpor, “Hi are ano herer wit wit awepyapɨr hɨm mei yaaim me mɨt enwis God naanmamror. God keriuweta te hi awepyapɨrem.” ");
INSERT INTO avt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Te hɨrak ken kɨnaiwɨri kewepyapɨr hɨm me God kekre wɨnak kerek mɨt nau nererik nekine hɨm me Moses nerer wit wit neit provins Judia. ");
INSERT INTO avt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wɨ ham mɨt miyapɨr yapɨrwe nises Jisas neriuwetan nerp menep nanɨmtau hɨm me God hɨrak kakɨtporem kerp wan ke Genesaret. ");
INSERT INTO avt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hɨrak wen katɨp hɨm, hɨrak kɨr sip wiketerem mɨwaai tenhaan. Mɨt kerek newɨr hepin nankin saauk, hɨr nɨnaaiwɨr sip nen nekemyet hepin mɨr. ");
INSERT INTO avt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hɨrak ken kau kekre sip me Saimon. Hɨrak kenɨne Saimon kitɨwekhi hɨrak kakriuwet sip mamno tɨpar kike. Te hɨrak kau kekre sip wen ketpor menmen mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hɨrak katɨp epei au, hɨrak katɨp Saimon kar ik: “Ti ehu sip eno wan kerek kesikekre, ti etike mɨt nekepi yi eiwɨr hepin emɨkiuwe wan kerekek te yi eiyɨt saauk.” ");
INSERT INTO avt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon ketpɨwek kar ik: “Mɨtɨk Iuwe, haiu mewɨr hepin me wɨtaan ere wanewik te haiu ap mari saauk mei au. Ti hetpo te hi ewɨrem emno nɨmɨn ein.” ");
INSERT INTO avt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hɨrak ketpor, hɨr newɨrem men nɨmɨn ein epei au, hɨr nari saauk yapɨrwe ere hepin mamwep, ");
INSERT INTO avt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","te hɨr nenɨne nɨr yinan neit sip ham nanɨnen nankepi. Hɨr nan nekepi neriyaam newisɨm mekre sip ere mau hɨm te sip wik menep te mamnatɨn mamɨkre wan. ");
INSERT INTO avt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita kɨr menmen im epei au, hɨrak kewen ninɨp kerp ninaan me Jisas ketpɨwek kar ik: “Ti Mɨtɨk Iuwe enaiwɨra. Hi mɨtɨk enuk ap hises hɨm me God werek au.” ");
INSERT INTO avt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hɨrak ketike mɨt kerek netikerek hɨr han kekrit nentar saauk yapɨrwe hɨr netɨwem. ");
INSERT INTO avt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon Pita ketike wariyakɨt tɨrak Jems ketike Jon nɨkerek te mɨtɨk Sebedi hɨrakɨt tetikerek han kekrit. Jisas katɨp Saimon, “Ti ap enaain au. In ere maain ti eri mɨt enɨnen enisɨsa.” ");
INSERT INTO avt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jisas ketpɨwekɨt epei au, hɨr mɨt han nekepikɨt nari sip neiyɨm nen tenhaan, hɨrakɨt tɨnaiwɨrem tisesik. ");
INSERT INTO avt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wɨ ham Jisas keit wit hak kerek mɨtɨk enuk lepro mewik hɨrak keitai en. Hɨrak kɨr Jisas hɨrak kan kenke kɨwaai tɨ kitehi Jisas kar ik: “Ti han kit ti erekyo te hi yaaik.” ");
INSERT INTO avt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisas kewis his menterik katɨp kar ik: “Hi hanhan ti are yaaik.” Wasenum lepro epei menke mekeipnɨwek hɨrak kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas ketpɨwek hɨm manp kar ik: “Ti ap atɨp mɨt menmen im au emɨt. Ti eno eteikɨn pris yɨnk kit, ti ewetɨwek menmen hɨrak kakwet God em mamɨr ke hɨm me Moses mekre tɨwei metpim. Menmen im mamteikɨn mɨt ti yaaik.” ");
INSERT INTO avt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hɨrak katɨp mɨt hɨr ap nanwepyapɨr menmen hɨrak kerekyorem, te menmen hɨrak kɨrɨakem, mɨt nerer wit wit nemtewem te hɨr yapɨrwe nan nanɨmtau hɨm mɨrak o hɨr nan te hɨrak kakɨkepi te hɨr yaain manpenun enu. ");
INSERT INTO avt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wɨ yapɨrwe hɨrak kɨpnaaiwɨr mɨt hɨrak ken wit weinɨm mɨt ap newi, hɨrak prea kitehi God menmen. ");
INSERT INTO avt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wɨ ham, hɨrak kewepyapɨr mɨt menmen, mɨt han ne Farisi kerek ninɨn nises hɨm me Moses, hɨr netike mɨt han ne Skraip kerek newis menmen me hɨm me Moses mau tɨwei natɨp mɨt em, hɨr nau en. Hɨr nɨnaaiwɨr wit Jerusalem, han nɨnaaiwɨr wit yapɨrwe me provins Galili ketike provins Judia, hɨr nan nanɨmtau hɨm mɨrak. Menmen iuwe me Mɨtɨk Iuwe God metikerek mekepik te hɨrak kakɨkaap mɨt nɨnap o his hɨt enum te hɨr nanre yaain. ");
INSERT INTO avt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mɨt han nan nɨnan mɨtɨk hak his hɨt tupe mekiuwerem epei maa meit, hɨr nɨnanek kekre kɨnaan kɨwaai yeno neiyɨk nan. Hɨr neiyɨk nanoke nein te hɨr nanɨno nɨmɨn nanwisɨk kɨwaai hɨt me Jisas. ");
INSERT INTO avt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hɨr nɨnatɨn au nentar mɨt yapɨrwe nerp neiyepet ya weipɨr ke wɨnak te hɨr nɨniu wɨnak siup nen niu ein, hɨr nenke toni kɨwapɨn wɨnak siup, hɨr nesiuwe mɨtɨk neriuwe waai kau yeno ken kɨwaai tɨ kekreri nɨmɨn ke mɨt netike Jisas. ");
INSERT INTO avt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas hɨrak kertei hɨr han kitet hɨrak kakɨkaap mɨtɨk ik, hɨrak ketpɨwek kar ik: “Hi esak menmen enum ti hɨrɨakem hɨram mamno.” ");
INSERT INTO avt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mɨt ne Skraip netike mɨt ne Farisi hɨr nitehiyan natɨpan nar ik: “Mɨtɨk ik hɨrak keimɨn te hɨrak katɨp enum, hɨrak kekrehɨr ke God? Keimɨn kakɨsak menmen enum haiu mɨt mɨrɨakem? Mɨt au, God kerekek.” ");
INSERT INTO avt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas kertei hɨr natɨpan menmen te hɨrak ketpor, “Yi yenmak yi han kitet menmen mekre han ki mar em? ");
INSERT INTO avt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hi atɨp mɨtɨk kɨwaai yeno kar ik: ‘Hi esak menmen enum ti hɨrɨakem mamno,’ te yi yepɨtari hi atɨp werek o au. Te hi etpɨwek: ‘Ti hekrit etenen yeno eiyɨm eno,’ te yi eiyɨrtei hi atɨp werek te hɨrak kakɨkrit kakno. Au en, hɨrak wen kakwaai yeno. ");
INSERT INTO avt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hi hemipɨn ap hesak menmen enum mɨrak au, hi ap te akaap mɨtɨk ik kakre yaaik taau. Hi tewen atɨp mɨtɨk ik har ik: ‘Ti ekrit eno,’ te yi yayɨrtei hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi yaaik te hi herp tɨ, hi esak menmen enum mɨt nɨrɨakem mamno.” Hɨrak ketpor epei au, hɨrak katɨp mɨtɨk enuk his hɨt tupe mekiuwerem epei maa meit, hɨrak ketpɨwek kar ik: “Ti ekrit etenen yeno mit eiyɨm eno nit ein.” ");
INSERT INTO avt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hɨrak katɨp epei au, mɨtɨk enuk kekrit waswas te hɨr mɨt yapɨrwe nɨpɨrek hɨrak keit yeno kerek nɨpaa kɨwaaiyem, hɨrak keiyɨm ken nɨrak ein kewenɨpi niuk me God. ");
INSERT INTO avt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hɨr mɨt miyapɨr yapɨrwe han kekrit newenɨpi niuk me God nenterik, hɨr natɨp nar ik: “Petepin haiu mɨr menmen nɨpaa mɨt ap nɨrem mar im au.” ");
INSERT INTO avt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hɨrak kɨkaap mɨtɨk epei au, maain hɨrak ketpaan ken witeik ken kɨr mɨtɨk kerek keit pewek me takis me mɨt hɨrak kewet gavman em. Niuk me mɨtɨk ik hɨrak Livai. Hɨrak kau wɨnak kerek kari pewek me mɨt keitaak. Jisas ketpɨwek, “Ti ehisɨsa enen.” ");
INSERT INTO avt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mɨtɨk Livai kerek kari pewek me mɨt hɨrak kɨnaaiwɨr menmen mɨrak yapɨrwe kekrit kises Jisas. ");
INSERT INTO avt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Maain Livai kɨam Jisas menmen iuwe keit wɨnak kɨrak. Hɨrak kari mɨt han enun ne mɨt kerek nari pewek me mɨt newet gavman em, hɨr netike mɨt han hɨr nererik nau nekre wɨnak kɨrak naam menmen netikeret. ");
INSERT INTO avt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mɨt ne Farisi netike mɨt Skraip kerek nertei hɨm me Moses natɨp mɨt miyapɨr em, hɨr nises menmen me Farisi, hɨr nan natɨp nene mɨt disaipel kerek nises Jisas. Hɨr natɨp nar ik: “Yenmak te yi yetike mɨt enun nari pewek me mɨt, hɨr netike mɨt han nɨrɨak enum, yi yetikeri yaam menmen metike tɨpar? Menmen im au enum emɨt!” ");
INSERT INTO avt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas kewenhi ketpor kar ik: “Neimɨn kerek yaain hɨr ap nari mɨtɨk dokta kakɨkepi au. Neimɨn kerek nɨnap hɨr keriyen nari mɨtɨk dokta kakɨkepi. ");
INSERT INTO avt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Hi ap han enɨne mɨt kerek han kitet hɨr nɨre yaain te hɨr enweikɨn sip enwet menmen enum au. Hi han enɨne mɨt kerek nertei hɨr enun nɨrɨak enum keriyen.” ");
INSERT INTO avt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hɨr wen nitɨwekhi nar ik: “Mɨt disaipel ne mɨtɨk Jon ap naam menmen me wɨ yapɨrwe te hɨr nitehi God menmen. Mɨt nises hɨm me Farisi hɨr netikeri ap naam menmen au. Te mɨt nit hekrit hekrit hɨr naam menmen. Hɨr nenmak?” ");
INSERT INTO avt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisas kewenhi ketpor, “Mɨt nau netike mɨtɨk ketike mɨte epei neitan te hɨr ap naam menmen a? Taauye! Hɨr nanɨm ye! ");
INSERT INTO avt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Te maain wɨ mamnen mɨt han nantɨwek his kaknaaiwɨr mɨt nɨrak yinan. Me wɨ im mɨt nɨrak nɨneinɨwek menmen ap te nanɨm au. Hɨr han tewenɨnek.” ");
INSERT INTO avt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisas ketpor hɨm tok piska mar im. Hɨrak katɨp, “Mɨtɨk hak ap kakwep laplap mɨrak yaaim kekerwewim mamu enum tokim au. Keimɨn kakrɨak menmen im, hɨrak kakɨwaank mɨrak yaaim em. Te laplap yaaim kerek epei kewepim kekerwewim mau tokim em ap te mamɨram au mentar ti ekemyet, hɨram mamweikɨnhis mamre kike. ");
INSERT INTO avt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mɨtɨk keiyak ap te kakwen tɨpar wain wen petep mamɨkre yɨnk me meme epei enum tokim au. Hɨrak kakrɨakem te maain tɨwerpek me wain mamniu mamwep yɨnk me meme enum tokim te hɨram mamwen, tɨpar mamno tɨ. ");
INSERT INTO avt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Au, wain tɨpar wen yaaim emwenem emɨkre yɨnk me meme wen yaaim weiwei. Tokim au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mɨtɨk keiyak kaam wain enum tokim hɨrak katɨp hɨram yaaim. Hɨrak kɨnapen tɨpar wain wen petep. Hɨrak kaktɨp enum tokim em hɨram minɨn.” ");
INSERT INTO avt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Me wɨ Sabat, Jisas ken keremir ni ham wit nɨkim mewim ketike mɨt nɨrak hiswiyen wik (12). Me wɨ Sabat, mɨt nɨrɨak menmen au, hɨr nau weinɨm. Mɨt disaipel nɨrak neit nɨkim me wit (hɨram mɨre rais), hɨr nehis newenem nekinenim naam. ");
INSERT INTO avt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Te mɨt han ne Farisi hɨr natɨp neneri nar ik: “Yenmak te yi yɨrɨak menmen kerek hɨm me Moses meriuwesɨsem te yi ap eirɨakem me wɨ Sabat a?” ");
INSERT INTO avt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas keweni ketpor, “Yi epei yekine menmen nɨpaa maam nɨpu kaiu Devit ketike mɨt nɨrak hɨr nɨrɨakem me wɨ kerek hɨr nɨnpɨ maan. Te yi ap han kitetim yerteiyem werek werek au a? ");
INSERT INTO avt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hɨrak ken kɨnɨk wɨnak ke God kerek mɨt newenɨpi God neit nɨmɨn en. Mɨtɨk iuwe pris kewetɨwekem kekin bret kerek newisɨm nehimɨtanem me God, hɨrak kaam kewet mɨt kerek netikerek kewtɨr meiyam hɨr naam. Hɨm me Moses matɨp mɨt pris keriyen nanɨm bret im e. Mɨt han au. Mɨtɨk hetpris kewis maam nɨpu kaiu Devit kɨrɨak menmen im ap kenerek au, te yi yenmak yena yatɨp hi hɨrɨak enum a?” ");
INSERT INTO avt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi yaaik te hi atɨp mɨt menmen hɨr enrɨakem me wɨ Sabat. Hi hinɨn menmen maamrer netpim te yi eiyisesim me wɨ Sabat. ");
INSERT INTO avt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Me wɨ Sabat ham, Jisas ken kekre wɨnak kerek mɨt nererik nekine hɨm me Moses, hɨrak kewepyapɨr hɨm me God. Mɨtɨk hak kau en, hɨrak his yaaim mɨrak enum meweikɨn, hemik weinɨk. ");
INSERT INTO avt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mɨt han ne Skraip newepyapɨr hɨm me Moses netike mɨt han ne Farisi naanmɨpre Jisas te hɨr nanɨrek kakrɨak menmen kakɨkaap mɨtɨk ik his enum kakɨ wɨ Sabat kerek hɨr neriuwesɨsem, te hɨr nantɨp nansiuwek hɨm nankɨp kaki. ");
INSERT INTO avt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hɨrak kertei han kɨr, hɨrak katɨp mɨtɨk kerek his mɨrak meweikɨn ketpɨwek kar ik: “Enen ehɨrp in.” Hɨrak kekrit kan kerp in. ");
INSERT INTO avt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jisas ketpor kitorhi, “Hɨm me Moses matɨp haiu mamrɨak yaaim o enum mamɨ wɨ Sabat? Haiu mamrɨak mɨtɨk kɨnap kaku o kaki me wɨ Sabat a?” ");
INSERT INTO avt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hɨrak naanmenteri mɨt yapɨrwe. Hɨrak naanmenteri, hɨrak katɨp mɨtɨk ik kar ik: “Ti esiuwe his mit.” Hɨrak kɨrɨakem te his mɨrak mɨre yaaim mɨpɨram. ");
INSERT INTO avt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jisas kekepik, te mɨt hɨr neperper nine han enuk wɨsenum natɨpan nime nɨpɨnek menmen hɨr nanrɨak Jisas em enum. ");
INSERT INTO avt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Me wɨ im, Jisas kɨniu ken mɨniu (o neiyɨp) kitehi God menmen. Wɨtaan ere wanewik hɨrak kitɨwekhi menmen. ");
INSERT INTO avt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wanewik, hɨrak ken kenɨne mɨt yapɨrwe kerek nises hɨm mɨrak, hɨrak kehimɨtan mɨt hiswiyen wik (12) hɨrak kewepor niuk mɨr kenewor kare “Aposel” nɨrak, maain hɨr enrɨak menmen mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hɨrak kehimɨtan Saimon kerek hɨrak kewis niuk mɨrak ham Pita. Hɨrak ketike nɨkik kɨrak Endru. Hɨrak kehimɨtan Jems, Jon, Filip, Batolomyu, ");
INSERT INTO avt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems hɨrak nɨkan ke mɨtɨk Alfias, Saimon kerek niuk mɨrak ham Selot, hɨr netike ");
INSERT INTO avt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, nɨkan ke mɨtɨk hak Jems, hɨrak ketike Judas Iskeriot kerek maain kakwepyapɨr Jisas te mɨt enun nepan nɨrak neiyɨk nen nakɨp. ");
INSERT INTO avt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Epei au, Jisas ketike mɨt nɨrak nekiuwe mɨniu (o neiyɨp), hɨr nen wit kɨpɨrak netike mɨt yapɨrwe nises hɨm mɨrak. Hɨr netike mɨt yapɨrwe nerer wit wit me provins Judia netike mɨt ne Jerusalem netike mɨt ne wan menep wit iuwe Taia ketike Saidon, ");
INSERT INTO avt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","hɨr nan nanɨmtau hɨm me Jisas, hɨr nan te hɨrak kakɨkepi. Mɨt han kerek hɨram herwe mekreri hɨr nan, te Jisas hɨrak kekepi kepɨrem. ");
INSERT INTO avt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mɨt yapɨrwe hanhan nanwis his mamwik nanɨntar menmen mɨrak iuwe meit nɨmɨn mamno mamkaap mɨt te hɨr nanɨre yaain. ");
INSERT INTO avt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas kerenaan kɨr mɨt nɨrak nisesik hɨrak ketpor kar ik: “Yi mɨt enun menmen auri. Yi han yaaik eiyu eiyɨntar God naanmamri. ");
INSERT INTO avt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Yi mɨt miyapɨr kerek hanhan eiyises hɨm me God Iuwe, yi han yaaik eiyu eiyɨntar maain yi eiyisesik werek eiyu werek eiyɨr ke mɨt kerek hɨr nɨnpi maan hɨr naam menmen ere tu iuwe. ");
INSERT INTO avt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Yi han yaaik eiyu te hɨr mɨt han enuk neriuweri hɨr nanɨmtaantɨwo hɨr neweikɨn sip newetiyem hɨr netpi nisesi nentar yi yisɨsa hi Mɨtɨk ke wit ke Mɨtɨk Iuwe. ");
INSERT INTO avt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nɨpaa enum eik maamrer nɨr nɨrɨak mɨt profet enum te God kakwetɨr menmen yaaim iuwe kakɨt wit kɨrak. Maain mɨt nanrekyi enum nanɨr ke nɨpaa maamrer nɨr nɨrɨak profet em. Maain wɨ menmen enum im mamnen, yi einakɨn tokim han yaaik eiyu eiyɨntar maain God kakweti menmen yaaim mɨrak kakɨt wit kɨrak. ");
INSERT INTO avt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Yi mɨt in ek yi yetenen menmen yapɨrwe te maain yi han enuk eiyu eiyɨntar yi ap yayɨt menmen yaaim meit wit ke God au. ");
INSERT INTO avt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Yi mɨt in ek yi tu iuwe han enuk eiyu eiyɨntar maain yi nɨnpɨ mamiwei. Yi mɨt in ek yenwesɨs, maain yi han enuk eiyu eiyɨntar maain yi yaikɨt. ");
INSERT INTO avt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Newaai meruri mɨt netpi yi yaain yi naanmamre hɨras eiyɨntar menmen im ap meteikɨn yi yatɨp yaaim au. Nɨpaa maamrer ne mɨt in enun hɨr natɨp mɨt profet enun nemipɨn hɨr yaain. Te hɨr yaain au. Hɨr enun ye! ");
INSERT INTO avt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Yi mɨt kerek yemtau hɨm mai hi hetpi har ik: ‘Yi hanhan mɨt nepan, yi yairɨak yaaim me mɨt hɨr han enuk neriuwi. ");
INSERT INTO avt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mɨt kerek newen henye netpi enum te yi yetpor hɨm yaaim. Hɨr mɨt kerek nerekyi enum, yi eiyitehi God ekrekyor yaaim. ");
INSERT INTO avt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mɨtɨk kerek kakitep kaknemtɨnut nɨkɨp, ti ewisɨk pɨke ekitep ekno nɨkɨp pɨnam. Mɨtɨk hak kaknen kakri saket kit, ti ap etenen siot au. Ti ewisɨk hɨrak ektɨwek ektikerek. ");
INSERT INTO avt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Neimɨn nitihi menmen yi eiwetɨrem, te yi ap pɨke yetpor hɨr enwetiyem au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yi eiyinɨn eirɨak mɨt menmen yi hanhan maain te mɨt nanrekyiyem. ");
INSERT INTO avt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Yi hanhan mɨt keriyen kerek hɨr hanhani, yi han kitet God kaktɨp yi yaain? Taau. Hɨram menmen weinɨm. Mɨt enun nises God au, hɨr nɨrɨak menmen mar im. ");
INSERT INTO avt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yi eirɨak yaaim mɨt keriyen kerek nerekyi yaaim, yi han kitet menmen im hɨram iuwe te God kaktɨp yi yaain? Taau. Hɨram menmen weinɨm. Mɨt enun nises God au hɨr nɨrɨak menmen mar im. ");
INSERT INTO avt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yi eiwet mɨt menmen kerek yi han kitet maain hɨr pɨke enwetiyem, yi han kitet menmen im hɨram iuwe te God kaktɨp yi yaain a? Taau! Hɨram menmen weinɨm. Mɨt enun newet mɨt han menmen te hɨr pɨke nantɨwem. ");
INSERT INTO avt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yi hanhan mɨt nepan eirekyor yaaim, eiwetɨr menmen te ti ap han kitet pɨke eiyɨt menmen au emɨt! Yi eirɨak menmen im te God kakweti menmen yaaim. Yi yeteikɨn mɨt yi yaire nɨkerek ne God yentar God kɨrɨak yaaim kɨkaap mɨt enun nises han kɨr hanhan hɨras, hɨr netike mɨt yaain. ");
INSERT INTO avt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yi eikaap mɨt eirekyor yaaim eire Haai ki God kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yi ap skelim mɨt me menmen hɨr nɨrɨakem te God ap skelim yi mɨt me menmen yi yɨrɨakem taau. Menmen enum mɨt nerekyiyem, yi eitɨp hɨram menmen weinɨm. Te God han yaaik keriuwi kakɨsak menmen enum mi mamno. ");
INSERT INTO avt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yi eiwet mɨt menmen te God kakweti menmen ere mau hɨm te mamɨhɨnhɨn. Mamɨrkeim yi eiwet mɨt menmen, hɨram mamɨr ke God maain kakwetiyem.” ");
INSERT INTO avt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas ketpor hɨm tok piksa im e. Hɨrak katɨp, “Mɨtɨk nanamɨr toto ap te kakteikɨn mɨtɨk hak kerek nanamɨr toto tatriyakɨt tatitet yayiwe. Hɨrak kakrɨak menmen mar im te hɨrakɨt tatɨnkewɨn tatɨkre wi. ");
INSERT INTO avt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nɨkan sumatin kau skul ap kakɨrtei menmen kakinɨn mɨtɨk tisa kɨrak. Te maain hɨrak kakɨrtei menmen epei werek te hɨrak kakre tisa kɨrak kerek ek. ");
INSERT INTO avt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Ti henmak te ti hɨpɨr menmen mɨre yenkis yehes mekre nanamɨr ke kit yinak te ti ap hertei nu mɨre heneik mau mekre nanamɨr kit a? Ti ehinɨn eweikɨn sip ewet menmen enum te maain ti yaaik te ti atɨp kit yinak menmen enum hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nu yaaim ap mine nɨkim enum au, nu enum ap te mine nɨkim yaaim au. ");
INSERT INTO avt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mɨt nɨr nɨkim me nu ham, hɨr nertei hɨram tuwaan o hɨnaan. Mɨt ap nenep tapɨr mau nu miyak herpe au. Hɨr ap newen hɨnaan nɨkim mari mau sɨrpɨt au. ");
INSERT INTO avt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mɨt hɨr nar nu im. Mɨtɨk yaaik kɨrɨak menmen yaaim kentar menmen yaaim mau han kɨrak. Hɨm me mɨt mewepyapɨr menmen mekre han kɨr. ");
INSERT INTO avt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Yi yenmak yi yatɨp hi Mɨtɨk Iuwe te yi ap yises hɨm mai au a? ");
INSERT INTO avt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Mɨtɨk kerek kaknen kakɨmtau hɨm mai kakisesim, hɨrak kakre mɨtɨk kime wɨnak. Mɨtɨk ik kekin hei kime wɨnak kentar nan keit mɨniu (o neiyɨp). Maain mani kakniu kaknep wɨnak te ap keket wɨnak au kentar mɨtɨk kimaak yaaik kime wɨnak kentar nan keit mɨniu (o neiyɨp). ");
INSERT INTO avt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mɨtɨk kerek kaknen kakɨmtau hɨm mai kakisesim au, hɨrak kakre mɨtɨk kime wɨnak kekin hei kau tenhaan menep mani. Hɨrak kimaak kau tenhaan, maain mani kakniu kaknep wɨnak kakwenek, hɨrak keiyɨk kakno kakɨwaankek.” ");
INSERT INTO avt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas katɨp menmen im epei au, hɨrak ken wit Kapaneam. ");
INSERT INTO avt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hɨrak ken wit Kapaneam, mɨtɨk iuwe ke ami ke wit Rom kepu Kapaneam, hɨrak han tewenɨn mɨtɨk kerek kɨrɨak menmen mɨrak, hɨrak kɨnap menep te kaki. ");
INSERT INTO avt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Me wɨ im hɨrak kemtau Jisas kɨkaap mɨt, hɨrak keriuwet mɨt iuwe ne Juda nau wit eik te hɨr nanitɨwekhi kaknen kakɨkaap mɨtɨk ik. ");
INSERT INTO avt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hɨr nan nɨr Jisas nitɨwekhi hɨm iuwe netpɨwek, “Mɨtɨk ik hɨrak yaaik te ti enen ekepik. ");
INSERT INTO avt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hɨrak han tewenɨn haiu mɨt ne Isrel hɨrak kime wɨnak kaiu kerek haiu mau mererik mekine hɨm me Moses.” ");
INSERT INTO avt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hɨr natɨp epei au, Jisas ketikeri nen. Hɨr menep te hɨr nɨpɨun wɨnak kɨrak eik, mɨtɨk iuwe ke ami keriuwet nɨrak yinan newenyipɨri netpɨwek, “Mɨtɨk Iuwe ti ap enen au emɨt! Hi ap yaaik te ti enen enɨk wɨnak kai au. Ti Mɨtɨk Iuwe hi au weinɨk. ");
INSERT INTO avt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hi han kitet hi ap yaaik te hi enen erit au. Hi hertei ti atɨp hɨm keremem te mɨtɨk kai pɨke kaku werek kentar ");
INSERT INTO avt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","hi har ke ti. Hi ehises hɨm me mɨt naiu ne ami ninɨna. Hi hinɨn naanmɨpre mɨt ne ami han. Hi atɨp mɨtɨk ik, ‘Ti eno,’ te hɨrak kakno. Hi atɨp mɨtɨk eik, ‘Ti enen,’ te hɨrak kaknen. Hi hatɨp mɨtɨk kerek kɨrɨak menmen mai, ‘Ti erɨak menmen im,’ te hɨrak kakrɨakem. Ti atɨp enen menmen enum mekre yɨnk ke mɨtɨk kai te hɨram emɨnke emrɨr emkepnɨwek.” ");
INSERT INTO avt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas kemtewek katɨp karik, hɨrak han kekrit han yaaik, hɨrak keweikɨn katɨp kar ik: “Hi etpi hi ap hertei mɨtɨk kiutɨp ke mɨt ne weiwɨk me Isrel hɨrak han kitet hɨm me God kar ke mɨtɨk ik kisesim au.” ");
INSERT INTO avt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jisas katɨp epei au, hɨrak keriuwet mɨt kerek mɨtɨk iuwe ke ami keriuweti nan nɨrek, te hɨr pɨke nen wɨnak kɨrak, hɨr nɨr mɨtɨk kɨrɨak menmen mɨrak hɨrak pɨke kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Maain wɨ ham Jisas ken wit niuk mɨrak Nen. Mɨt nɨrak nises hɨm mɨrak netike mɨt han yapɨrwe nen netikerek. ");
INSERT INTO avt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hɨrak ken kiun ya weipɨr ke nɨwa ke wit eik epei au, hɨrak kɨr mɨt nɨnan herwe kentar kɨnaan nanwisɨk kakɨkre hei. Herwe kaa, hɨrak nɨkan ke mɨte kerek nɨpaa mɨtɨk kɨre kaa. Mɨt yapɨrwe ne wit nɨkɨtek nen. ");
INSERT INTO avt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mɨtɨk Iuwe Jisas kɨr miye pɨrak wɨkɨtek, hɨrak han tewenɨnep ketpɨwe kar ik: “Ti ap ekɨtek au emɨt! Ekintɨp!” ");
INSERT INTO avt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hɨrak kan kewis his mentar yeno te hɨr mɨt nɨnanek neiyɨk nerp neit. Te hɨrak katɨp mɨtɨk pipɨak kar ik: “Hi hetput ti ekrit.” ");
INSERT INTO avt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hɨrak katɨp epei au, herwe kerek kaa hɨrak kekrit kau, hɨrak katɨp. Te Jisas keriuwetek pɨke ketike miye pɨrak nen. ");
INSERT INTO avt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hɨr nepɨrpɨr newenɨpi niuk me God natɨp nar ik: “Mɨtɨk profet iuwe epei kan kau nɨmɨn ke haiu mɨt. God epei kan kakɨkaap haiu mɨt miyapɨr nɨrak.” ");
INSERT INTO avt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mɨt newepyapɨr menmen Jisas kɨrɨakem men merer wit wit me provins Judia ketike wit menep. ");
INSERT INTO avt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mɨt disaipel ne Jon netpɨwek menmen yapɨrwe Jisas kɨrɨakem. Te hɨrak kari mɨtɨkɨt wik tɨrak, ");
INSERT INTO avt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","keriuwetet ten Mɨtɨk Iuwe Jisas te titɨwekhi, “Ti Mɨtɨk Iuwe kerek God katɨp kaknen ek o haiu mamɨmerɨr mɨtɨk keiyak?” ");
INSERT INTO avt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mɨtɨkɨt te Jon epei ten tɨr Jisas hɨrakɨt titɨwekhi tarik: “Jon kerek kɨkɨr mɨt keriuwetawɨr te hawɨr wituthi, ‘Ti Mɨtɨk Iuwe Krais kerek God keriuwetit o haiu mamɨmerɨr keiyak maain kaknen?’” ");
INSERT INTO avt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Me wɨ im Jisas kɨkaap mɨt hɨr nɨnaap hɨr nɨre yaain. Hɨrak kɨkaap mɨt han kepɨr herwe mekre han kɨr hɨr nɨre yaain. Hɨrak kɨkaap mɨt nanamɨr toto te hɨr nɨr ein ein. ");
INSERT INTO avt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hɨrak kewen Jon mɨtɨkɨt tɨrak ketpɨwekɨt, “Yi pɨke eino eitɨp Jon menmen yi yɨrem, menmen yi yemtewem. Mɨt nanamɨr toto hi ekepi te hɨr nɨr ein ein. Mɨt kerek perku enum hɨr neke tɨ nen werek werek. Mɨt lepro mewi, yɨnk kɨr kɨre yaaik. Mɨt nɨkɨp toto enum hɨr nemtau. Mɨt epei naa hi hɨkɨan nekrit nepu. Hi atɨp mɨt enun menmen au, hi eweporyapɨr hɨm yaaim me God. ");
INSERT INTO avt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mɨt kerek hɨr han yaaik neriuwe menmen hi hɨrɨakem han kiteta, hi Mɨtɨk God keriuweta hɨkaap mɨt, hɨr han yaaik enu.” ");
INSERT INTO avt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hɨrak ketpɨwekɨtem, mɨtɨkɨt Jon keriuwetet epei ten, Jisas katɨp mɨt yapɨrwe in me Jon. Hɨrak ketpor kar ik: “Yi yen yayɨr mekam yayɨt wit weinɨm a? Yi yɨr menmen weinɨm mɨre niyen (o keneiken) nɨme metɨtɨwem, ");
INSERT INTO avt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","o au en, yi yen yayɨr mekam a? Mɨtɨk keriuwet klos yaaim? Au, mɨt narik hɨr nau werek werek hɨr nepu wɨnak ke mɨt iuwe gavman keriyen. ");
INSERT INTO avt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Im au, te yi yen yayɨr mekam a? Mɨtɨk profet? Yi epei yɨr mɨtɨk profet, te hi etpi werek. Hɨrak Jon kinɨn mɨt profet. ");
INSERT INTO avt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon hɨrak mɨtɨk kerek hɨm me God mau tɨwei matɨp mar im: ‘Eiyɨmtewem! Hi ariuwet mɨtɨk kai kaktɨp hɨm kakinɨnit kakno kaktɨp mɨt, ti Mɨtɨk hi God hehimɨtenut ti enen, te hɨr enweikɨn sip enwet menmen enum nanmeriyut.’ ");
INSERT INTO avt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Hi hetpi me wɨ Jon kɨrɨak menmen, hɨrak mɨtɨk iuwe epei kinɨn mɨt yapɨrwe kerek miyapɨr nɨpaa ninen. Te in ek hɨr mɨt kerek niuk mɨr kike hɨr nises God hɨrak naanmɨpror, maain hɨr nanu nantike God nanɨt en hɨr naninɨn Jon kerek wɨ hɨrak kau tɨ ik e.” ");
INSERT INTO avt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hɨr mɨt weinɨn netike mɨt kerek hɨr nari pewek me takis newet mɨt iuwe ne gavman em, hɨr yapɨrwe nemtau hɨm Jisas ketpim me Jon, hɨr natɨp, “Hɨm me God hɨram yaaim.” (Hɨr keriyen nises hɨm me God kehimɨtanorem, hɨr newis Jon kɨkɨri neriuwe tɨpar. ");
INSERT INTO avt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hɨr mɨt ne Farisi kerek naanmɨpre hɨm me Moses netike mɨt ne Skraip kerek newepyapɨr hɨm me Moses, hɨr au. Hɨr neweikɨn sip newet menmen God hanhan hɨr nanisesim mamkepi te hɨr ap newis Jon kɨkɨri neriuwe tɨpar au.) ");
INSERT INTO avt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas wen ketpor kar ik: “Hi atɨp mekam te hi eteikni mɨt nau tɨ ik ek hɨr neweikɨn sip newet God hɨr nɨre mekam? Hi hetpi. ");
INSERT INTO avt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hɨr nɨre nɨkerek netike miye haai nen maket nesiuwe menmen mɨr, nɨkerek han nenɨne nɨkerek han netpor, ‘Haiu mɨrɨam tukɨn mine henye te yi yɨprɨre au. Haiu memipɨn menep tukɨn han tewenɨn herwe kaa, te yi yɨkɨtek au. (Haiu mɨrɨak menmen ham ham te yi ap han yaaik yeriuwerem au.) Yi mɨt han yi yɨre nɨkerek in.’ ");
INSERT INTO avt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hɨrak Jon kerek kɨkɨr mɨt neriuwe tɨpar kan nɨnpɨ maak kepu, hɨrak ap kaam wain tɨpar si enum, te yi yatɨp herwe kekrerek. ");
INSERT INTO avt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe epei han haam menmen metike wain tɨpar si enum te yi yatɨp, ‘Eiyɨrek! Hɨrak kaam menmen yapɨrwe kaam tɨpar yapɨrwe. Hɨrak ketike mɨt nari pewek me takis netike mɨt nɨrɨak enum, hɨrak ketikeri nariyan nɨrɨak menmen.’ ");
INSERT INTO avt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Menmen God kɨrɨakem mɨt kerek nisesim nertei hɨram yaaim.” ");
INSERT INTO avt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mɨtɨk kiutɨp ke mɨt Farisi kitehi Jisas kaktikerek tatɨm menmen tatɨt wɨnak kɨrak, te hɨrak ketikerek ten taam menmen teit wɨnak kɨrak eik. ");
INSERT INTO avt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mɨte hap weit wit ik ek, hɨre enu wɨrɨak enum. Hɨre wertei Jisas kaam menmen keit wɨnak ke mɨtɨk ke Farisi, te hɨre weit mɨn tɨpar mɨnɨn yaaim mekrerem weiyɨm wan. ");
INSERT INTO avt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hɨre wen werp sip ke Jisas menep hɨt mɨrak, witehɨr wɨkɨt wan ketnen kentar hɨt mɨrak te hɨre weit paan kɨre nokik weiyɨk wesiunen hɨt mɨrak. Hɨre weiyewɨwek hɨt te hɨre wewen tɨpar sanda kerek yaaim mɨnɨn em menterim. ");
INSERT INTO avt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mɨtɨk hak ke Farisi ik ek nɨpaa kenɨne Jisas ken kaam menmen ketikerek hɨrak kɨr menmen im, hɨrak katɨp kekre han kɨrak, “Mɨtɨk ik hɨrak kɨre profet, te hɨrak epei kertei mɨte ip ep hɨre peimɨn hɨre wɨre mekap te hɨre wetenenik, hɨre wɨre mɨte enu wɨrɨak menmen enum.” ");
INSERT INTO avt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas kertei han kɨrak te hɨrak ketpɨwek kar ik: “Saimon, hi amɨ hetput menmen.” Saimon kewenhi kar ik: “Mɨtɨk Iuwe, ti etpo.” ");
INSERT INTO avt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas katɨp, “Nɨpaa mɨtɨkɨt wik tari pewek me mɨtɨk hɨrak kewetɨwekɨtem, te pɨke tatwetɨwekɨtem kiutɨp hɨrak kari 500 kina. Hak au 50 kina kerem em. ");
INSERT INTO avt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Maain hɨrakɨt ap tetenen pewek te hɨrakɨt pɨke tatwetɨwekem, hɨrak katɨp hɨram menmen weinɨm. Te ti han kitet keimɨn ke mɨtɨkɨt wik hɨrak han tewenɨnek wɨsenuk a?” ");
INSERT INTO avt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon katɨp, “Mɨtɨk nɨpaa kari pewek iuwe, hɨrak han tewenɨnek wɨsenuk.” Jisas ketpɨwek, “Ti atɨp werek.” ");
INSERT INTO avt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jisas kɨwaai naan kɨr mɨte ip e, hɨrak katɨp Saimon, “Ti epei hɨr mɨte ip a? Ti henɨnau te hi han wɨnak kit. Ti ap eweto tɨpar te hi ekemyet hɨt mai ehises menmen me maamrer naiu au. Te hɨre wekemyet hɨt mai weriuwe wan ke nanamɨr kɨre, hɨre wesiunenim weriuwe paan kɨre. ");
INSERT INTO avt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nɨpaa hi han wɨnak kit ti ap heiyewowa au, te hɨre weiyewo hɨt mai kerek nɨpaa hi hɨwaai yeno ere in. ");
INSERT INTO avt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ti ap hewis tɨpar mɨnɨn yaaim kike mau paan kai au. Te hɨre wewen tɨpar mɨnɨn yaaim wɨsenum mau hɨt mai. ");
INSERT INTO avt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hi hetput, hɨre han tewenɨna. Menmen im meteikɨn mɨt hɨre han yaaik wentar hi epei hesak menmen enum mɨre yapɨrwe, hɨram epei men. Mɨtɨk kerek ap kertei werek God kesak menmen mɨrak hɨram iuwe, maain hɨrak han tewenɨn God kike.” ");
INSERT INTO avt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jisas katɨp mɨte ip kar ik: “Menmen enum mit, ti nɨpaa hɨrɨakem, hi epei esakem.” ");
INSERT INTO avt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mɨt han nau yeno eim naam menmen netikerek hɨr han kitetim mekre han kɨr, “Hɨrak han kitet hɨrak keimɨn te hɨrak kesak menmen enum mɨt nɨrɨakem a? Hɨrak God a?” ");
INSERT INTO avt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Au, Jisas wen ketpɨwe kar ik: “God kekepit kentar ti han kiteta. Ti han yaaik eno.” ");
INSERT INTO avt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Maain wɨ ham Jisas ken wit iuwe, wit kike kewepyapɨr hɨm yaaim me God naamamre mɨt. Mɨt nɨrak nar hiswiyen wik (12) netikerek nen. ");
INSERT INTO avt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Miyapɨr han kerek nɨpaa Jisas kekepi nɨnap o kepɨr herwe mewi menpɨn, niuk mɨr im: Maria kerek niuk ham Magdala kerek nɨpaa Jisas kepɨr herwe hispɨnak wik (7). ");
INSERT INTO avt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hɨre wetike Joana kerek mɨte pe mɨtɨk Susa, mɨtɨk iuwe naanmɨpre menmen meit wɨnak ke mɨtɨk iuwe gavman King Herot. Hɨre wetike Susana, miyapɨr han yapɨrwe naanmɨpre Jisas ketike mɨt nɨrak nisesik hɨr naanmɨprewek neriuwe menmen mɨr. ");
INSERT INTO avt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mɨt nerer wit wit nan nɨr Jisas. Jisas kɨr mɨt yapɨrwe nererik nerp menep, hɨrak ketpor hɨm tok piska mar im: ");
INSERT INTO avt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mɨtɨk hak ken kewɨr rais yehes meit ni mɨrak. Hɨrak wen kewɨrem, ham menke mɨwaai yayiwe, mɨt nan nentɨraam, hore meniuwe man maam. ");
INSERT INTO avt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yehes ham menke mɨwaai tɨ kike kentar nan. Hɨram mewo te hɨram maa mentar tɨpar au. ");
INSERT INTO avt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yehes ham menke mɨwaai tɨ waai enum tɨktɨk enum mewiyen. Yehes metike waai enum mewo mɨpɨram te waai enum mɨwapɨnem te hɨram ap mari au. ");
INSERT INTO avt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yehes ham menke mekre tɨ yaaik nɨpaa mɨtɨk kewenek hɨram mewo yapɨrwe mine nɨkim mar 100.” Hɨrak Jisas wen katɨp kɨnap hɨm iuwe, “Keimɨn ekɨmtau hɨm mai nɨkɨp emnep hɨrak han ekitet menmen hi epei hetpim.” ");
INSERT INTO avt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hɨrak katɨp epei au, mɨt nɨrak kerek nises hɨm mɨrak nitɨwekhi nar ik: “Ti ewepyapɨr hɨm nɨpaa ti hetpim.” ");
INSERT INTO avt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas ketpor kar ik: “God kewisi yi yertei han kɨrak te hɨrak naanmamre mɨt. Te mɨt han en hi hetpor heriuwe tok piska te hɨr nɨr menmen hɨr nepɨtariyem, hɨr nemtau hɨm te hɨr ap nisesim werek au. ");
INSERT INTO avt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Hɨm me tok piksa hɨram im: Rais yehes hɨram hɨm me God keremem. ");
INSERT INTO avt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yehes mɨwaai yayiwe hɨram mɨre mɨt nemtau hɨm me God te Seten kan kari hɨm yaaim mau han kɨr mamno te hɨr ap nises hɨm mɨrak, te hɨrak God ap kakɨkepi kaktorhis au. ");
INSERT INTO avt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yehes mɨwaai tɨ kike kentar nan hɨram mɨre mɨt nemtau hɨm me God hɨr han yaaik hɨr nɨre nekenik kike mau pɨn. Hɨr han kitet hɨm me God kike keremem, te hɨm mamno han kɨr au mɨre yehes nekenik kike mau pɨn. Maain wepni kakmɨp hɨram mamɨweiwei. Maain Seten kaknen kakri han kɨr te hɨr nanweikɨn sip nanwet hɨm me God. Hɨm mɨrak mekre han kɨr mami. ");
INSERT INTO avt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yehes menke mɨwaai tɨ enuk kerek waai tɨktɨk mewiyen, hɨram mɨre mɨt nemtau hɨm me God te hɨr hemkre menepam neriuwe pewek o menmen mɨr, hɨr hanhan nises menmen han kɨr katɨp hɨram yaaim, te hɨram meiyepet han kɨr te hɨr ap nises God werek werek au. ");
INSERT INTO avt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yehes menke mɨwaai tɨ yaaim ham mɨre mɨt nemtau hɨm yaaim me God. Hɨr nemi mekre han kɨr yaaik, hɨr nisesim ere hɨr nises God werek werek nɨrɨak menmen yaaim mɨre rais mari yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mɨtɨk ap keksiu si kɨsawɨnek kekre sar o kewisɨk kɨnɨk yeno au. Hɨrak kewisɨk kau yaain te mɨt nanɨnen nɨmɨn in nanɨrek. ");
INSERT INTO avt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Menmen yapɨrwe mɨsawɨn meit te maain hɨram mamu yaain mɨt nanɨrem. Menmen yapɨrwe mɨsawɨn meit te maain God kakwepyapɨrem kakteikɨn mɨt em. ");
INSERT INTO avt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Menmen yi yemtewem yi naanempre hɨras te yi yemtewem werek, yi han ekitetim werek werek. Keimɨn ketenen hɨm yaaim kisesim, maain God kakwetɨwek hɨm ham yaaim. Keimɨn han kitet kerekek hɨrak ketenen hɨm ham hɨrak kisesim, menmen hɨrak han kitet hɨrak kerteiyem, God kakriyaam mamno mamkeipnɨwek mamɨwaank mamɨt.” ");
INSERT INTO avt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Miye pe Jisas wetike kikrek nɨrak nan nanɨrek te hɨr ap nanwep mɨt yapɨrwe nanɨrek. ");
INSERT INTO avt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mɨt han netpɨwek, “Miye pit wetike kikrek nit nerp wit eik nanrit.” ");
INSERT INTO avt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Te Jisas kewenhi ketpor, “O, hi hemtau. Te hi hetpi, mɨt kerek nemtau hɨm me God nisesim, hɨr nɨre miye wetike kikrek nai.” ");
INSERT INTO avt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wɨ ham Jisas ketike mɨt nises hɨm mɨrak hɨr nen nau nekre sip. Te hɨrak ketpor, “Haiu mamno wan pɨnak ein.” Hɨrak ketpor, te hɨr nepno. ");
INSERT INTO avt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hɨr nepno, Jisas kɨwaai kɨnatɨn keit, yuwerep kɨniu kekiuwe mɨniu (o neiyɨp) kan. Yuwerep kekiuwe mɨniu (o neiyɨp) kan te wan tɨpar kehɨn kekre sip, sip menep mamɨwer mamriuweri nanɨkre wan te hɨr nani. ");
INSERT INTO avt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mɨt nɨrak nen nekotɨtek netpɨwek nar ek: “Mɨtɨk Iuwe, Mɨtɨk Iuwe, haiu menep te mami.” Jisas kekrit katɨp kewen yuwerep ketike wan, hɨram mewɨre meit. ");
INSERT INTO avt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Te hɨrak ketpor, “Yenmak yi yɨnaain te yi ap han kiteta werek werek au a?” Te hɨr han kekrit hɨr nɨnaain natɨpan nar ik: “Mɨtɨk ik hɨrak iuwe, menmen iuwe mewik te hɨrak katɨp yuwerep wan hɨram mewɨre mɨwaai meit.” ");
INSERT INTO avt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sip merekir wan ere mɨpiun tɨ ke wit Gegesa. Gegesa kɨwaai wan keit pɨnak ein te Galili kɨwaai keit pɨnak in. ");
INSERT INTO avt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisas kenke ken kiun tenhaan eik, mɨtɨk ke wit iuwe kewenyipɨrek. Mɨtɨk ik herwe mekrerek me wɨ yapɨrwe hɨrak ap kamɨr laplap au. Hɨrak kau wɨnak au, hɨrak kepu han kɨnɨk mɨniu (o neiyɨp) han kerek mɨt newis herwe maa mekrerem. ");
INSERT INTO avt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Wɨ yapɨrwe herwe merekyɨwek han ken sip, mɨt naanmɨprewek hɨr newenkekik neriuwe sen ain mau his hɨt mɨrak te hɨrak keremir te herwe meriyaak meiyɨk men wit weinɨm mɨt ap newi. Jisas katɨp herwe enum hɨm manp te hɨrak kepɨrem mamno. Jisas wen ketpɨwek hɨrak kenepɨp kenkewɨn kɨwaai ninaan mɨrak hɨrak katɨp hɨm iuwe mar im: “Jisas ti Nɨkan ke God Wɨsenuk. Ti henmak herekyo menmen im? Hi hituthi ti ap herekyo menmen im au emɨt!” ");
INSERT INTO avt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas kitehi herwe kar ik: “Ti ekine niuk mit.” Hɨram matɨp mar im: “Niuk maiu mɨt yapɨrwe mentar haiu yapɨrwe mekrerek.” ");
INSERT INTO avt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Herwe mitɨwekhi te hɨrak ap kakriuwetem mamno hei enuk. ");
INSERT INTO avt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sak yapɨrwe merp mɨniu (o neiyɨp) menep maam menmen te herwe nitɨwekhi hɨrak ekwisɨm mamno mamɨkre sak im. Jisas kewenhi herwe hɨram mamno. ");
INSERT INTO avt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jisas kewenhi herwe te hɨram metpaan mekeipɨn mɨtɨk, hɨram men mekre sak. Te sak mesiukɨn mekiuwe tɨnpi (o neiyi) me mɨniu (o neiyɨp) men mamɨn wan te tɨpar mekiuwe hɨm yipɨr, hɨram maa meit. ");
INSERT INTO avt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hɨr mɨt naanmɨpre sak nɨr menmen im, hɨr nɨrɨr nen natɨp mɨt ne wit iuwe, mɨt ne wit kike netporem. ");
INSERT INTO avt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hɨr netporem, hɨr mɨt ne wit nesiukɨn nen nanɨr menmen hɨr nepei netporem me sak. Te hɨr nan nɨr Jisas ketike mɨtɨk kerek Jisas kepɨr herwe mekeipnɨwek hɨrak kau menep hɨt me Jisas. Hɨrak han yaaik epei kamɨr laplap te hɨr nɨnaain. ");
INSERT INTO avt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mɨt kerek epei nɨr Jisas kekepik hɨr natɨp mɨt ne wit karkeik Jisas kɨkaap mɨtɨk nɨpaa herwe mekrerek. ");
INSERT INTO avt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Te mɨt nerer wit wit me Gegesa hɨr nan nitehi Jisas kaknaiwɨri kakɨntar hɨr nɨneinɨk wɨsenum, te Jisas ken kau sip kakno pɨnak ein. ");
INSERT INTO avt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hɨrak kau sip kakno, mɨtɨk kerek Jisas kepɨr herwe menke menpɨn mekeipnɨwek kitehi Jisas hɨm iuwe kaktikerek tatno, te Jisas keriuwetek ketpɨwek, ");
INSERT INTO avt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ti pɨke eno nit en ewepyapɨr atɨp mɨt menmen yaaim iuwe God kerekyutem.” Hɨrak ketpɨwek, te hɨrak pɨke ken nɨrak en kewepyapɨr katɨp mɨt yapɨrwe neit nɨrak en menmen Jisas kerekyɨwekem. ");
INSERT INTO avt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas pɨke ken kerekir wan ken pɨnak ein, te mɨt yapɨrwe hɨr han yaaik neriuwerek nentar hɨr nemeriyɨwek pɨke kerekir wan kaknen en. ");
INSERT INTO avt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hɨrak kiun ein, mɨtɨk niuk mɨrak Jairas ken menep. Hɨrak mɨtɨk iuwe ke wɨnak kerek mɨt nau nererik nekine hɨm me Moses ein. Hɨrak kan kenke kɨwaai hɨt me Jisas kitɨwekhi hɨm iuwe kar ik: “Ti enen wɨnak kai.” ");
INSERT INTO avt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hɨrak kitɨwekhi kentar hɨrak kine nɨki piutɨpen, hɨre tito hiswiyen wik (12). Hɨre wɨnap menep te wawi. Jisas kepno ketikerek, mɨt yapɨrwe nisesik neweiknɨwek. ");
INSERT INTO avt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mɨte hap kerek winen hemkre tito hiswiyen wik (12) hɨre wisesik. Hɨre wewɨr pewek mɨre epei mesi, te mɨt nekepye werek werek au. ");
INSERT INTO avt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hɨrak kepno, hɨre wisesik weke sip kɨrak wan wetenen hɨr me saket mɨrak, te wasenum hɨre hemkre katɨn keit. ");
INSERT INTO avt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisas kitehi katɨp, “Peimɨn wetenɨna?” Te hɨr yapɨrwe niune natɨp nar ik: “Hi au. Hi au.” Pita katɨp, “Haiu mɨt yapɨrwe meweiknut merp menep menep. Ti henmak te ti hatɨp hɨm mar im?” ");
INSERT INTO avt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Au, Jisas katɨp, “Mɨte hap hɨre wetenɨna. Hi hertei menmen mai iuwe epei mɨnaiwɨra mɨkaap mɨte peiyap.” ");
INSERT INTO avt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mɨte wertei Jisas kertei menmen hɨre wɨrɨakem, te hɨre weperper wan wewen ninɨp wɨwaai menep hɨt me Jisas, hɨre wewepyapɨr hɨrehes me ninaan me mɨt yapɨrwe markeim te wasenum hɨrak kekepiye hɨre wepu werek werek. ");
INSERT INTO avt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hɨre wepu werek werek, te Jisas ketpɨwe kar ik: “Mɨte ti han kiteta te God kekepit ti hɨre yaaip. Ti han yaaik eno.” ");
INSERT INTO avt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas wen katɨp hɨm im, mɨtɨk hak ke wɨnak ke mɨtɨk iuwe Jaires kan ketpɨwek kar ik: “Nɨki pit epei waa. Ti henmak ti eriyaam ektan Jisas? Ti ewisɨk kakno.” ");
INSERT INTO avt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas kemtewek hɨrak katɨp Jaires kar ik: “Ti ap enaain au. Ti han ekiteta te hɨre wawu werek.” ");
INSERT INTO avt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hɨrak kɨpiun wɨnak, te hɨrak kewis mɨt han netikerek nanɨno nɨmɨn wɨnak au. Pita, Jems, Jon netike miye haai hɨr keriyen nen nɨmɨn. ");
INSERT INTO avt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mɨt yapɨrwe ein nɨkɨtep hɨr han tewenɨnep, te Jisas ketpor, “Yi ap eikɨtep au emɨt! Hɨre ap waa, hɨre wɨwaai kerep ep.” (Hɨrak ketpim kentar hɨrak hanhan kakɨkɨa.) ");
INSERT INTO avt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hɨr nemtewek hɨr nenwesɨsek nentar hɨr nertei hɨre epei waa weit. ");
INSERT INTO avt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hɨr nenwesɨsek te Jisas ketenɨnɨwe his mɨre kenɨnewe hɨm iuwe kar ik: “Nɨki ti ekrit.” ");
INSERT INTO avt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hɨmɨn kɨre pɨke kan kekrerep te wasenum hɨre wekrit. Jisas katɨp miye haai hɨr enwetɨwe menmen hɨre wawɨm. ");
INSERT INTO avt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Miye haai nɨre, hɨr han kekrit, te hɨrak ketpor hɨm manp te hɨr ap nantɨp mɨt menmen hɨrak kɨrɨakem au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas kenɨne mɨt nɨrak disaipel hiswiyen wik nɨrak (12) kewisi hɨr nekrehɨr kɨrak ninɨn herwe hɨr nankaap mɨt nɨnap te hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hɨrak keriuweti hɨr nen nanwepyapɨr God kinɨn naanmamre mɨt. Hɨrak keriuweti nankaap mɨt miyapɨr nɨnap. ");
INSERT INTO avt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hɨrak kinɨn ketpor, “Yi ap eiyɨt menmen kerek yi yeiyɨm yaino au. Menmen au, pewek au, laplap meiyam au, tanɨk metike paap au. Yi yewi yɨrɨak menmen mi, ");
INSERT INTO avt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","maain yi yaino wit mɨt hɨr newisi yewi, yi yau wɨnak kiutɨp kerekek ere yi einaaiwɨr wit. ");
INSERT INTO avt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yi eipiun wit mɨt ap nanɨmtau hɨm mi, yi einaaiwɨr wit eik, yi einepep toni waniu mamu hɨt mi te eiteiknor God han enuk kakriuweri.” ");
INSERT INTO avt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hɨrak ketpor epei au, mɨt nɨrak nɨnaiwɨrek nen nerer wit wit newepyapɨr natɨp hɨm yaaim me God, hɨr nɨkaap mɨt ein hɨr nɨnap. ");
INSERT INTO avt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","In ek mɨtɨk iuwe gavman King Herot hɨrak naanmɨpre mɨt ne provins Galili, hɨrak kemtau menmen epei man, hɨrak han kitetim kentar mɨt han natɨp Jon kerek kɨkɨr mɨt neriuwe tɨpar nɨpaa kaa te in ek hɨrak pɨke kekrit kepu. ");
INSERT INTO avt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mɨt han natɨp, “Ilaija profet ke nɨpaa hɨrak pɨke kan.” Mɨt han natɨp, “Mɨtɨk profet hak ke profet yapɨrwe nɨpaa ein te God kɨkɨak hɨrak epei kan.” ");
INSERT INTO avt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herot kekre han kɨrak han kitet, “Nɨpaa hi herekir teruk ke Jon hɨrak kaa. Hɨrak keimɨn hi hemtau hɨrak kɨrɨak menmen im e?” Hɨrak hanhan kakɨrek. ");
INSERT INTO avt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Maain mɨt nɨrak aposel nɨpaa keriuweti nen, hɨr epei nan netpɨwek menmen hɨr nɨrɨakem. Te hɨrak kɨnaaiwɨr mɨt yapɨrwe hɨrak keithis mɨt nɨrak hiswiyen wik (12) ketikeri keriyen hɨr nen wit Betsaida. ");
INSERT INTO avt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hɨr nen en, mɨt yapɨrwe nerteiyek, hɨr nisesik nen ein te hɨrak han yaaik keriuweri ketpor God kakinɨn naanmamre mɨt, hɨrak kɨkaap mɨt nɨnap te hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hɨnkewɨ, mɨt nɨrak nar hiswiyen wik (12) nan netpɨwek, “Ti esiuwe mɨt enɨno te hɨr nanɨno wit metike ni mɨt newi hɨr enɨt menmen hɨr enwaai en. Wit ik ek hɨrak wit weinɨk ap menmen mewi au.” ");
INSERT INTO avt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Te Jisas ketpor kar ik: “Yi hɨras eiwetɨr menmen hɨr nanɨm.” Hɨr newenek netpɨwek, “Haiu metenen bret hispɨnak (5), saauk wiketeret mɨt epei nɨam kerem em. Ti hanhan te haiu mamno mamɨt menmen mamwet mɨt em? Taauye! Hɨr mɨt enun yapɨrwe!” ");
INSERT INTO avt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hɨr natɨp menmen im nentar mɨt keriyen yapɨrwe hɨr 5,000 mɨt neit ein keriyen. Hɨr ap newenhis miyapɨr nɨkerek au. Jisas katɨp mɨt nɨrak, “Yi eirɨak mɨt nererik nau nɨre 50 in 50 ein nɨran ere hɨr enu tɨ werek.” ");
INSERT INTO avt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mɨt nɨrak nɨrɨakem nar hɨrak ketpim, hɨr newen mɨt nau tɨ. ");
INSERT INTO avt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Te Jisas keit bret hispɨnak (5), saauk wiketeret kɨkɨamnaan katɨp God hɨrak yaaik, te hɨrak kewepim kewet mɨt nɨrak em te hɨr nanwetɨrem. ");
INSERT INTO avt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mɨt yapɨrwe naam ere tu iuwe. Mɨt nɨrak neit menmen mɨt naam au, hɨr neit hause (o wanpnake) mar hiswiyen wik (12) neiyɨk nemi yinam kerek mɨwaai em. ");
INSERT INTO avt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wɨ ham Jisas hɨrak kitehi God menmen, mɨt nɨrak nau netikerek neit wit weinɨk. Hɨr nau en, hɨrak kitorhi kar ik: “Mɨt natɨp hi keimɨn?” ");
INSERT INTO avt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hɨr newenhi natɨp, “Mɨt han natɨp ti Jon Baptais kerek nɨpaa kɨkɨri neriuwe tɨpar, pɨke kekrit kepu. Mɨt han natɨp ti profet Ilaija ke nɨpaa. Mɨt han natɨp ti mɨtɨk profet hak ke nɨpaa ein mɨt profet yapɨrwe nepu te God kɨkɨak katɨp hɨrak kaknen.” ");
INSERT INTO avt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Te Jisas hɨrak kitorhi kar ik: “Yi han kitet hi keimɨn?” Pita ketpɨwek, “Ti Mɨtɨk Krais nɨpaa God kehimɨtenit ti enen ekepai haiu mɨt.” ");
INSERT INTO avt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jisas katɨp hɨm manp te hɨr ap newepyapɨr hɨrak Mɨtɨk God kehimɨtanek kerekek au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hɨrak wen katɨp, “Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, mɨt iuwe ne Isrel nantike mɨt ne Skraip nantike mɨt iuwe naanmɨpre wɨnak iuwe ke God hɨr nanweikɨn sip nanweto, hɨr naniyep hi hahi. Maain wɨ wikak God kakɨkoya hi pɨke akrit hahu.” ");
INSERT INTO avt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hɨrak katɨp epei au, Jisas katɨp mɨt nɨrak yapɨrwe kar ik: “Mɨtɨk kerek kakisɨsa hɨrak ekwenɨn han kɨrak me menmen hɨrak hanhan kakrɨakem, hɨrak hekrit hekrit han kitet, ‘Hi hahi entar hi hisesik hɨram menmen weinɨm te hi ehisesik.’ ");
INSERT INTO avt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Keimɨn ap kisɨsa kentar hɨrak wen hanhan kises han kɨrak, maain hɨrak kaki hɨrak ap kaku werek kaktike God au. Te keimɨn katɨp kar ik: ‘Hi ap hepu hises han kai hɨram menmen weinɨm, te hi hises hɨm me God,’ mɨtɨk ik kaku werek kakɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mɨtɨk hak kakɨt menmen yapɨrwe me tɨ im te hɨrak kewaank menmen me kaku werek. Menmen me tɨ ik mamkepik kaku kaktike God mamɨrkeik a? Taauye! ");
INSERT INTO avt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Keimɨn hɨrak yɨnk enuk kɨnapen kakisɨsa hetike hɨm mai yaaim, hi anapen hɨrak kaku kaktikewa. Maain me wɨ hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen ariuwe menmen yaaim God Haai kakwetewem, hi etike mɨt yaain nɨrak ensel, hi hɨnapen mɨtɨk kar ik kaku kaktikewa au. ");
INSERT INTO avt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Hi hetpi werek. Mɨt han neit in hɨr nani au ere hɨr epei nɨr menmen iuwe God kakrɨakem naanmamre mɨt kakriuwerem.” ");
INSERT INTO avt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Maain wɨ hispɨnak wikak (7) epei au, Jisas ken kɨniu mɨniu (o neiyɨp) ken kaktɨp kaktike God. Hɨrak keithis Pita, Jems, Jon tetikerek ten. ");
INSERT INTO avt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hɨrak wen kitehi God menmen, ninaan mɨrak meweikɨnhis merhɨhe, klos mɨrak merhɨhe mɨre nepni mewenɨn. ");
INSERT INTO avt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Waswas mɨtɨkɨt wiketeret tan tetikerek tewepnak. Hɨrakɨt Moses ketike Ilaija. ");
INSERT INTO avt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hɨrakɨt tetike menmen iuwe me God merhɨhe yaaim man, hɨrakɨt tetike Jisas tatɨp me menmen Jisas kakrɨakem, kises han ke God Haai, kaki kakɨt wit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","In ek Pita ketike mɨtɨkɨt tau tetikerek hɨrakɨt tɨwaai tɨnatɨn te hɨrakɨt tekrit tɨr Jisas kerhɨhe yaaim, hɨrak ketike mɨtɨkɨt wik terp en. ");
INSERT INTO avt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hɨrakɨt mɨtɨkɨt wiketeret tatnaaiwɨr Jisas tatno, Pita katɨp Jisas, “Kaiu Iuwe, hɨram yaaim te haiu mau in ek. Haiu emime weisaak emɨr wikak: Hak kit, hak ke Moses, hak ke Ilaija.” ");
INSERT INTO avt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hɨrak wen katɨp hɨm im e, napɨ kɨwapɨni te hɨrakɨt wikak tɨnapen napɨ kɨwapɨnet. ");
INSERT INTO avt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hɨrakɨt temtau God katɨp keke napɨ kar ik: “Ik ek hɨrak nɨkan kai, nɨpaa hi hehimɨtanek. Yi eiyɨmtau hɨm mɨrak!” ");
INSERT INTO avt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hɨrakɨt temtau hɨm matɨp epei au, hɨrakɨt tɨr Jisas kiutɨpen kerek kepu. Hɨrakɨt tekintɨp wɨre wɨre. Hɨrakɨt ap tatɨp mɨt neiyan me wɨ im Jisas ken ketikeri menmen hɨrakɨt epei tɨrem au. ");
INSERT INTO avt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Maain teipmen hɨr nepei nekiuwe mɨniu (o neiyɨp) nan, hɨr mɨt yapɨrwe nan nɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mɨtɨk hak kenɨne kekre mɨt yapɨrwe hɨrak katɨp kar ik: “Mɨtɨk Iuwe, hi hituthi iuwe te ti enen ehɨr nɨkan kai. Hɨrak nɨkan kai kiutɨp kerek ek. ");
INSERT INTO avt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Herwe keweikɨn han kɨrak te waswas hɨrak kenepɨp hɨrak keperper kaa, hɨrak teknek mar tɨwerpek kekesɨs hɨm, herwe merekyɨwek enum ere hemkre meneises yɨnk kɨrak, hɨrak kɨnapen kɨnaiwɨrek au. ");
INSERT INTO avt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hi hitehi mɨt nit te hɨr nepɨrek taau.” ");
INSERT INTO avt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas kewenhi katɨp, “Yi mɨt han ki enuk yi han kitet menmen iuwe me God werek werek au. Hi hɨnapen hepu hetikewi wɨ yapɨrwe.” Hɨrak katɨp mɨtɨk eik kar ik: “Ti ehɨt nɨkan kit eiyɨk enen.” Hɨrak katɨp, te mɨtɨk ik keiyɨk kepnen. ");
INSERT INTO avt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɨkan kepnen, herwe kewɨrek ken tɨ, hɨrak keperper. Jisas kene herwe enuk kepɨrek kekeipnɨwek, nɨkan kɨre yaaik, te hɨrak keriuwet nɨkan ken haai kɨrak. ");
INSERT INTO avt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mɨt yapɨrwe han kekrit nentar menmen iuwe yaaim me God hɨr epei nɨrem. Hɨr wen han kekrit neriuwe menmen im, hɨrak Jisas katɨp mɨt nɨrak kar ik: ");
INSERT INTO avt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Yi han ekitet menmen werek werek hi in ek etpiyem. Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe God, maain mɨtɨk hak kakwisa hi eno his me mɨt enun hɨr nantenɨna.” ");
INSERT INTO avt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Te hɨr ap nertei werek menmen hɨrak ketporem nentar hɨrak ap kekepi werek te hɨr nerteiyem. Hɨr nɨnaain pɨke nanitɨwekhiyem. ");
INSERT INTO avt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas mɨt nɨrak hɨr natɨpan nenehan keimɨn ke hɨr mɨt hɨrak kinɨn. ");
INSERT INTO avt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas kertei menmen hɨr han kitetim, te hɨrak keit nɨkan kewisɨk kerp menep hɨrekes hɨrak ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Keimɨn kɨkaap mɨtɨk kiutɨp kar ke nɨkan kike ik e kentar hɨrak kisɨsa, hɨrak kekepa. Keimɨn kekepa hɨrak kar ke hɨrak kɨkaap hɨrak Mɨtɨk Iuwe kerek keriuweta hi han. Keimɨn hɨrak han kitet hɨrak weinɨk ke yi mɨt, hɨrak kɨre iuwe kinɨni.” ");
INSERT INTO avt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mɨtɨk Jon katɨp Jisas kar ik: “Mɨtɨk Iuwe, haiu mɨr mɨtɨk hak kepɨr herwe kekrehɨr kit te haiu metpɨwek hɨrak kakrɨakem au kentar hɨrak ke haiu mɨt au.” ");
INSERT INTO avt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisas ketpɨwek, “Yi ap yeremirɨwek menmen mɨrak hɨrak kɨrɨakem au emɨt! Keimɨn hɨrak ap mɨtɨk kepan ke yi mɨt, hɨrak ki yinak yaaik yɨrɨak menmen miutɨp.” ");
INSERT INTO avt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Maain wɨ menep mamnen te Jisas kakno wit ke God, hɨrak han ekitet hɨrak kakno wit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hɨrak keriuwet mɨt han ninɨn nen niun wit kike ke provins Sameria hɨr nen nɨnatɨn wɨnak newis menmen neiyɨm nemeriyɨwek. ");
INSERT INTO avt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Au, mɨt in ap nekepik nentar hɨr nertei hɨrak kakno Jerusalem kakwenɨpi God, te hɨr nɨneinɨk. ");
INSERT INTO avt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jems ketike Jon terteiyek, hɨrakɨt tatɨp tar ik: “Mɨtɨk Iuwe, ti hanhan hawɨr wari si emoke wit ke God emnen si etɨn mɨt o au?” ");
INSERT INTO avt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Te Jisas hɨrak keweikɨn keneret. ");
INSERT INTO avt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hɨrak keneret, te hɨr epei nen wit hak. ");
INSERT INTO avt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hɨr wen nitet yayiwe nanɨno Jerusalem, mɨtɨk hak katɨp Jisas kar ik: “Hi tewen aisesit epno nein kerek me ti epnori en.” ");
INSERT INTO avt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas ketpɨwek, “Miyak mɨwaai mekre nu herkip, hore mɨwaai mekre yaank mɨr, te hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi wit aure te hi ewaairi au. Ti ehisɨsa te ti ewaai nein?” ");
INSERT INTO avt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisas katɨp mɨtɨk hak, “Ti ehisɨsa.” Te hɨrak ketpɨwek, “Mɨtɨk Iuwe, ti ewisa hi ehinɨn eno ewis haai kai kerek menep kaki kakɨkre hei, te maain hi ehisesit.” ");
INSERT INTO avt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas ketpɨwek, “Ti ewis mɨt kerek nisɨsa au hɨr enwis mɨt kerek naa, te ti eno ewepyapɨr hɨm me God naanmamre mɨt.” ");
INSERT INTO avt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mɨtɨk hak katɨp, “Mɨtɨk Iuwe, hi tewen ehisesit te hi ehinɨn eno atɨp miye haai kikrek nai hi enaiwɨri.” ");
INSERT INTO avt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisas ketpɨwek, “Mɨtɨk kerek hɨrak kises hɨm me God te hɨrak hanhan menmen enum nɨpaa hɨrak kisesim, hɨrak ap te kakises menmen me God werek werek au. Mɨtɨk ik kɨre mɨtɨk kamɨr rais keriuwe paap hɨhe, hɨrak kɨwaainaan mentar sip kɨrak hɨrak kamɨr kewaankem.” ");
INSERT INTO avt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jisas katɨp mɨt epei au, hɨrak kehimɨtan 70 mɨt han, hɨrak keriuweti ninɨnek nen hɨrak kenkeri wik wik nerer wit wit kerek hɨrak menep te kaknen. ");
INSERT INTO avt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hɨrak ketpor kar ik: “Han ke mɨt hɨrak kɨre menmen mau ni epei mewɨnki te mɨt ap yapɨrwe nantɨwem mamɨsi. Yi eiyitehi Haai ke ni te hɨrak kakriuwet mɨt yapɨrwe te hɨr nanɨno nanri han ke mɨt hɨr nanisesik. Menmen im hɨram mɨre mɨt nanɨno ni nanɨt menmen mewɨnki ere mamɨsi. ");
INSERT INTO avt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yi eino hi eriuweti yɨre sak nɨkim mamno yaank nepere kimaam kakmɨp. Te hi heriuweti yi yaino eitɨp mɨt hɨm mai te God naanmamri. ");
INSERT INTO avt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yi ap eiyɨt tanɨk yinak o tanɨk me nemi niu mekrerem, hɨram metike su mei au emɨt! Yi eisipat mɨt yayɨt yayiwe eitikeri eiwepnak au emɨt. Yi yayɨtpor hɨm kike te yi yaino keriyen. ");
INSERT INTO avt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wɨnak kerek yi yɨnɨk ek, yi eitɨp mɨt neimɨn nau wɨnak ik ek, ‘Hawɨr hanhan God kakrekyi yaain eiyu werek werek.’ ");
INSERT INTO avt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mɨtɨk yaaik kepu in te hɨm yaaim mi mamri han ke God kakɨkepik, o au en, God kakɨkepik kaku werek werek au. ");
INSERT INTO avt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yi eipau wɨnak kiutɨp kerekek, eipaam menmen eipaam tɨpar kerek hɨr newisiyem. Yi ap eiwɨr nan eiwetɨrem eiyɨntar yi yɨrɨak menmen mamkepi te hɨr naanmamri menmen. Yi ap eiyu eirer wɨnak wɨnak au. ");
INSERT INTO avt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Yi eino wit hak te hɨr nantihis, yi yayno yayɨm menmen yaitikeri yaipaam menmen hɨr nanɨnkiyem. ");
INSERT INTO avt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yi eikaap mɨt nɨnap neitai en, te yi eiyɨtpor, ‘God kerek wɨsenuk menep naanmamre haiu mɨt ne tɨ.’ ");
INSERT INTO avt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Te neimɨn yi yaino wit kɨr hɨr ap nantihis au, yi yaino eiyɨrp yayiwe kɨr eiyɨtpor, ");
INSERT INTO avt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Waniu me tɨ me wit ki ik mau hɨt maiu te haiu pɨke mesiunenim men yi hɨras meteikni God han enuk keriuwi. Te hawɨr wetpi te yi yertei menmen im. Wi epei man menep te God naanmamre haiu mɨt.’ ");
INSERT INTO avt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hi hetpi wɨ maain mamnen God skelim mɨt ne menmen enum, mɨt ne Sodom God kakɨwaanki kike, te God kakɨwaank mɨt in au wɨsenum. ");
INSERT INTO avt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Yi mɨt ne Korasin God kakriwaank. Yi mɨt ne wit Betsaida God kakriwaank eiyɨntar menmen yaaim God kerekyiyem, te yi ap yeweikɨn sip yewet menmen enum. Yi epei yɨpɨrem yisɨsa au. Te nɨpaa God kɨrɨak menmen mar im meit wit ke Taia ketike Saidon mɨt nɨrem, te hɨr waswas namɨr laplap enum newen toni te hɨr neteikɨn God hɨr neweikɨn sip newet menmen enum. Te yi au. ");
INSERT INTO avt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Maain God skelim mɨt, hɨrak kakrɨak mɨt ne wit Taia ketike Saidon kakrekyor menmen enum kike, te yi mɨt yeit Korasin ketike Betsaida au iuwe. ");
INSERT INTO avt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yi mɨt ne Kapaneam, yi han kitet God katɨp yi yaain a? Au, maain God kaktɨp yi enun yɨre menmen weinɨn.” ");
INSERT INTO avt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hɨrak katɨp mɨt nɨrak, “Keimɨn kemtau hɨm mi, kemtau hɨm mai. Keimɨn keweikɨn sip kewetiyem, hɨrak kar ke hɨrak keweikɨn sip kewetewem. Keimɨn keweikɨn sip keweto, hɨrak kar ke hɨrak keweikɨn sip kewet God kerek keriuweta hi han tɨ ik.” ");
INSERT INTO avt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Maain mɨt 70 han yaaik pɨke nan natɨp Mɨtɨk Iuwe, “Nɨpaa haiu matɨp mekrehɨr ke ti herwe metike menmen ham yapɨrwe hɨr nemtau hɨm maiu, haiu minɨni.” ");
INSERT INTO avt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisas kewenhi ketpor, “Hi epei hɨr Seten hɨrak kɨre nepni mewenɨn hɨrak keke nepni ken tɨ kentar menmen yi yɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hi epei heweti menmen mai iuwe te yi yinɨn Seten. Yi yayɨntɨrer manpen siurp (o yenmik) yehes enum mamtike mispenepnam (o nɨkɨnpɨnepnam) te hɨram mamiwep, yi ap yayi au. ");
INSERT INTO avt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yi ap han yaaik wɨsenuk eiyɨntar herwe nemtau hɨm mi au. Yi han yaaik wɨsenuk eiyu eiyɨntar niuk mi God kewisɨm mau weiwɨk miutɨp mɨrak te yi yɨre mɨt nɨrak.” ");
INSERT INTO avt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Me wɨ miutɨp keremem God Hɨmɨn Yaaik kɨrɨak Jisas han yaaik. Jisas katɨp kar ik: “Haai kai ti Mɨtɨk Iuwe ke wit kit ketike tɨ ik. Hi hetput ti yaaik hentar ti epei hɨsawɨn menmen mit me hɨr mɨt iuwe kerek han kitet hɨr nertei menmen werek werek, ti epei heteikɨn mɨt weinɨn em. Ti epei hɨrɨak menmen im hises han kit kerekek. ");
INSERT INTO avt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ti Haai kai Iuwe God epei heweto menmen mit yapɨrwe. Mɨtɨk keiyak ap kertei hi Nɨkan kit hi han kai hɨrak kar ke kit au. Ti God Haai kerekek herteiyek. Mɨtɨk keiyak ap kertei ti Haai kai hɨrak kɨre han kai han kit au. Hi Nɨkan kit kiutɨp kerekek, hetike mɨt in en hi eweputyapɨri.” ");
INSERT INTO avt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hɨrak katɨp epei au, hɨrak keweikɨn kɨr mɨt nɨrak disaipel ketpor main main kar ik: “Yi han yaaik eiyu eiyɨntar menmen hi hɨrɨakem yi yɨrem. ");
INSERT INTO avt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hi etpi nɨpaa enum eik mɨt profet yapɨrwe kerek newepyapɨr hɨm me God, hɨr netike mɨt kerek naanmɨpre mɨt ne wit Isrel, hɨr hanhan nanɨr menmen yi epei yɨr hi hɨrɨakem, te hɨr au. Hɨr hanhan nanɨmtau menmen yi epei yemtewem hi hetpim te hɨr au. Hɨr epei naa.” ");
INSERT INTO avt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wɨ ham mɨtɨk kerek kinɨn kertei hɨm me Moses kewepyapɨrem hɨrak kekrit kan katɨp kewises Jisas keriuwe hɨm me Moses. Hɨrak kan katɨp Jisas kar ik: “Mɨtɨk Iuwe. Hi erɨak mekam te hi ehu etike God tipmain tipmain enum eik?” ");
INSERT INTO avt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas ketpɨwek, “Hɨm me God Moses kewisɨm mau tɨwei matɨp mekam? Ti etpo mekam ti han kitetim.” ");
INSERT INTO avt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hɨrak kewenhi ketpɨwek, “Ti hanhan Mɨtɨk Iuwe God kit wɨsenuk heriuwe han kit, han ekitetik herkit hekrit. Ti hanhan mɨt han o nit yinan har ke ti hanhan hɨrekes.” ");
INSERT INTO avt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas ketpɨwek, “Hɨram werek. Ti erɨak menmen im te ti etike God yaikiyakɨt yayu tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mɨtɨk yɨnk enuk kentar Jisas kenerek te hɨrak kewen tapɨn te hɨrak kitehi Jisas kar ik: “Keimɨn ti hatɨp hi han kitet hɨrak kai yinak?” ");
INSERT INTO avt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas kewenhi ketpɨwek, “Nɨpaa mɨtɨk kiutɨp kɨnaaiwɨr wit Jerusalem kekiuwe ken wit Jeriko. Mɨt enun nɨsawɨn nakɨp nari menmen mɨrak, nɨnaiwɨrek kɨwaai yayiwe maain hɨrak kaki, hɨr nɨrɨr. ");
INSERT INTO avt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Me wɨ im mɨtɨk pris kerek kewet God menmen me mɨt, hɨrak kekiuwe yayiwe eik, hɨrak kɨrek te kesipatek ken yayiwe pɨnak ein kepno. ");
INSERT INTO avt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Maain kike, mɨtɨk ke weiwɨk me Livai kerek naanmɨpre wɨnak iuwe ke God, hɨrak kan kɨr mɨtɨk kɨwaai keriyen, te hɨrak kesipatek ken yayiwe pɨnak ein kepno. ");
INSERT INTO avt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Maain mɨtɨk kiutɨp ke mɨt yapɨrwe ne Sameria kerek nɨnapen mɨt ne Isrel, hɨrak kerekek kekiuwe yayiwe ken. Hɨrak kɨr mɨtɨk kɨwaai, hɨrak hanhan keriuwerek. ");
INSERT INTO avt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hɨrak ken kɨrek kewen tɨpar me nu oliv metike wain hɨram mɨpre marasin menterik. Te hɨrak kemsɨwek his hɨt. Epei au, hɨrak kɨnanek ere kewisɨk kentar hos pɨrak, hɨrak keiyɨk ken wɨnak kerek mɨt nererik nɨwaai ek, hɨrak naanmɨprewek. ");
INSERT INTO avt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Teipmen, hɨrak keit pewek wik kewet mɨtɨk ke wɨnak em, hɨrak ketpɨwek, ‘Ti naanemprewek ere hɨrak pɨke yaaik. Maain hi pɨke enen hi ewetit nan emrer mit kerek ti ewɨrem eiyɨm ekepik heriuwerem.’ ");
INSERT INTO avt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Keimɨn ke mɨtɨkɨt wikak hɨrak kɨre kɨrak yinak ke mɨtɨk ik kerek mɨt enun nakɨp?” ");
INSERT INTO avt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mɨtɨk Skraip kerek kewepyapɨr hɨm me Moses hɨrak katɨp, “Hɨrak mɨtɨk kerek kekepik kerekek.” Jisas ketpɨwek, “Ti eno erɨak menmen yaaim mamɨr im.” ");
INSERT INTO avt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas ketike mɨt nɨrak disaipel nepno, hɨr nɨpiun wit hak mɨte piutɨp niuk mɨre Mata wau en, te hɨre weriyei nen wɨnak kɨre, nanɨt menmen nanɨm. ");
INSERT INTO avt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata kikɨr pɨre Maria, hɨre wau menep hɨt me Jisas wawɨmtau menmen hɨrak ketpim. Hɨre ap wɨkaap Mata wemani menmen. ");
INSERT INTO avt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata han enuk wentar menmen yapɨrwe hɨre waurɨakem me naanmamre mɨt te hɨre wan watɨp Jisas war ik: “Mɨtɨk Iuwe ti han kitet hɨram menmen weinɨm kikɨr pai wɨnaiwɨra wemtau hɨm mit te hi hɨrehes hɨrɨak menmen iuwe im e? Ti etpɨwe hɨre eunen eukepa.” ");
INSERT INTO avt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jisas ketpɨwe, “Mata, tewisiye ewɨt! Ti hanhan menmen yapɨrwe ti hɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Menmen miutɨp te ti ap etɨwem, Maria epei weit menmen im yaaim, te ti ap eriye te hɨre waunaiwɨrem au. Hɨre ewu ewɨmtau hɨm hi hetpim.” ");
INSERT INTO avt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wɨ ham Jisas kitehi God menmen keit wit hak. Hɨrak kitehi God menmen epei au, mɨtɨk hak ke mɨt disaipel kerek nises hɨm mɨrak nitɨwekhi, “Mɨtɨk Iuwe, eteiknai menmen me prea te haiu mamitehi God menmen mamɨr ke Jon epei keteikɨn mɨt kerek nises hɨm mɨrak.” ");
INSERT INTO avt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisas ketpor kar ik: “Yi eiyitehi God menmen emɨr im. Yi eitɨp, ‘Haai, haiu hanhan niuk mit mɨre iuwe te ti enip mɨt hɨr nanwenɨpi nuik mit. Wɨ mamnen te ti naanmamre haiu mɨt. ");
INSERT INTO avt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ti petepin ewetei menmen emɨm har ke nɨpaa ti eweteiyem hekrit hekrit. ");
INSERT INTO avt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ti esak menmen enum haiu mɨrɨakem ap han ekitetim emɨr ke haiu hɨras matɨp menmen mɨt nerekyeiyem hɨram menmen weinɨm, haiu han ekitetim au emɨt! Ti ap ewis menmen enum mamri han kaiu.’” ");
INSERT INTO avt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jisas katɨp mɨt nɨrak, “Mɨtɨk kiutɨp ke yi mɨt ke nɨmɨn hɨrak kakno wɨnak ke kɨrak yinak, hɨrak kakɨtpɨwek, ‘Ti eweto niu mei wikak. ");
INSERT INTO avt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kai yinak hak keke yanɨmɨn kan kɨra, te hi ap etenen menmen mei au, te hi ewetɨwekem.’ ");
INSERT INTO avt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Hɨrak keit nɨmɨn kakwenuthi kakɨtput, ‘Hi epei heiyepet weipɨr, nɨkerek nai nɨwaai netikewa, hi ap te akrit awetut menmen taau.’ ");
INSERT INTO avt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hi etpi hɨrak ap kakɨkrit kakwetut menmen kentar mɨtɨk hɨrak kit yinak au, te hɨrak kakɨkrit kakwetit menmen kentar ti hitɨwekhi yapɨrwe me menmen. ");
INSERT INTO avt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hi hetpi, yi eiyitehi God menmen te hɨrak kakwetiyem. Yi yɨnyatɨn menmen te yi yainapɨnem. Yi yeretɨt weipɨr te hɨrak kɨkeiswi weipɨr kɨrak. ");
INSERT INTO avt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hi hetpi menmen im hentar keimɨn kitehi God menmen, hɨrak kakwetɨwekem. Keimɨn kɨnkatɨn menmen kaknapɨnem. Keimɨn keretɨt God kekeisɨwek weipɨr. ");
INSERT INTO avt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Keimɨn ke yi mɨt hɨrak kɨre haai te nɨkan kit kitɨwekhi saauk te ti ewetɨwek manpen siurp o mɨniuhan (neiyɨp han) te hɨrak kakɨm a? Taau! ");
INSERT INTO avt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O hɨrak kituthi suware yɨnu, te ti ewetɨwek mispenepnam (o nɨkɨnpenepnam) a? Taau! ");
INSERT INTO avt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Te yi mɨt enun yi yertei yewet nɨkerek ni menmen yaaim, te God Haai ki keit wit kɨrak kakinɨn menmen yi yewet nɨkerek em. Hɨrak kakwet Hɨmɨn kɨrak Yaaik kakno mɨt kerek hɨr nitɨwekhi me hɨrak.” ");
INSERT INTO avt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Maain Jisas kepɨr herwe kekre mɨtɨk kerek han enuk hɨm kɨtapu. Te hɨrak kenip mɨtɨk hɨrak kau kekrerek hɨrak hɨm kɨtapu. Herwe kɨnaiwɨrek, mɨtɨk enuk hɨrak katɨp, te mɨt yapɨrwe han kekrit neriuwe menmen im. ");
INSERT INTO avt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Au, mɨt han natɨp, “Hɨrak kepɨr herwe kentar Bielsebul hɨrak wɨsenuk kinɨn herwe hɨrak kekepik kepɨrek.” ");
INSERT INTO avt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mɨt han hanhan Jisas kakrɨak menmen nɨpaa hɨr nɨrɨakem taau, kakteiknor hɨrak mɨtɨk kerek God kehimɨtanek kaknen kakɨkaap mɨt. ");
INSERT INTO avt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Au, Jisas kertei menmen hɨr han kitetim, te hɨrak ketpor kar ik: “Wit kiutɨpen mɨt newi hɨr hɨras nenepan te mɨt ne wit hak nanɨnɨp nani nanɨnepi. Iuwe mɨtɨk ketike kike tenepakɨt te hɨrakɨt tatɨwaank weiwɨk mɨrakɨt. ");
INSERT INTO avt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yi yatɨp Seten Bielsebul kekepa hi hepɨr herwe mɨrak te yi yatɨp hɨrak ketike herwe mɨrak nenepan. Seten kɨrɨak menmen im, karkeik te hɨrak kaku werek naanmɨpre menmen mɨrak werek werek a? Taauye! ");
INSERT INTO avt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hi hepɨr herwe hentar Bielsebul kekepa, te keimɨn kɨkaap mɨt kerek nises hɨm mi hɨr nepɨr herwe a? Mɨt nises hɨm mi nanteikɨn yi ap yatɨp werek werek nentar hi hepɨr herwe neriuwe niuk me God. ");
INSERT INTO avt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Te hi hepɨr herwe heriuwe menmen iuwe me God. Menmen im hi hɨrɨakem meteikni God epei kan menep kakinɨn naanmamri yi mɨt. ");
INSERT INTO avt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mɨtɨk iuwe keit yipo henmik naanmɨpre wit kɨrak, menmen mɨrak mepu werek. ");
INSERT INTO avt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Te mɨtɨk hak hɨrak manpenuk kinɨn mɨtɨk ik, hɨrak ketikerek tenepakɨt, hɨrak kɨnaiwɨrek hɨrak kakri yipo henmik mɨrak kerek mɨtɨk nɨpaa han kitet hɨram mamkepik, hɨrak kakriyaam mamtike menmen mɨrak yaaim mamno, hɨrak kakɨnkerem kakwet nɨrak yinan em. ");
INSERT INTO avt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Keimɨn hɨrak ap kekepa kari mɨt nanisɨsa, hɨrak kar ke mɨtɨk kepan kakɨwaank mɨt nai nisɨsa, hɨr nanwep nanrɨr ein ein. ");
INSERT INTO avt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wɨ kerek herwe enuk kaknaaiwɨr mɨtɨk, hɨrak kakno wit tenhaan weinɨk kakɨnkatɨn nein te hɨrak kakwi, o au en, hɨrak kaktɨp, ‘Hi pɨke enen nai kerek nɨpaa hi hewiyen.’ ");
INSERT INTO avt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hɨrak kaknen, hɨrak kakɨr han ke mɨtɨk kɨpre wɨnak miyapɨr nɨripep menmen nɨkɨn nakɨrke mekre wɨnak. ");
INSERT INTO avt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hɨrak kɨpɨrek, te hɨrak kakno kakɨthis herwe ham hispɨnak wik (7) hɨram enum minɨnek, te hɨram mamtikerek mamnen mamu mɨtɨk kerek ek. Nɨpaa hɨrak mɨtɨk kɨre enuk te in ek au mamɨwaankek.” ");
INSERT INTO avt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas katɨp menmen im epei au, mɨte piutɨp pe mɨt yapɨrwe hɨre watɨp hɨm iuwe war ik: “Peimɨn hɨre winit wewetut nɨm hɨre han yaaik wepu.” ");
INSERT INTO avt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Te Jisas kewenhi katɨp, “O, hɨre han yaaik. Te neimɨn nemtau hɨm me God nisesik, hɨr han yaaik kɨr kakinɨn miye pai.” ");
INSERT INTO avt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mɨt yapɨrwe nan neweikɨn Jisas, hɨrak wen katɨp kar ik: “Mɨt miyapɨr nau tɨ in e, hɨr enun hɨr nitauhi hi arɨak menmen yaaim eteiknor God han yaaik keriuwa. Te hi eteiknor menmen yaaim yapɨrwe au. Menmen miutɨp me mɨtɨk Jona kerek nɨpaa God kekepik kepu kekre tu ke saauk me wɨ wikak. ");
INSERT INTO avt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nɨpaa Jona hɨrak kɨwaai kekre saauk tu kɨrak me wɨ wikak, te God keteikɨn mɨt ne Nineva menmen mɨrak iuwe keriuwerem. Mar im hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi eteikɨn mɨt in menmen mar im eteiknor menmen iuwe me God. ");
INSERT INTO avt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Me wɨ God skelim mɨt, mɨte iuwe naanmɨpre mɨt ne wit Siba, hɨre wautɨp yi enun wentar nɨpaa hɨre weke yanɨmɨn wan wemtau hɨm yaaim mɨtɨk iuwe King Solomon ketpim. Hi hinɨn mɨtɨk iuwe Solomon te yi ap yemtau hɨm mai au. ");
INSERT INTO avt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Maain wɨ God skelim mɨt, mɨt enun ne Nineva nantɨp yi enun yinɨni nentar nɨpaa hɨr nemtau Jona kewepyapɨr hɨm me God, hɨr neweikɨn sip newet menmen enum. Hi hinɨn profet Jona, te yi ap yeweikɨn sip yewet menmen enum, te yi yises hɨm mai au. ");
INSERT INTO avt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mɨtɨk hak ap keksiu si te kakwisɨk kaksawɨnek kaknɨk wɨnak, o kaknɨk tɨkenup. Au, hɨrak ekɨrp yaain te mɨt neimɨn nanɨnen nɨmɨn hɨr enɨr si mamɨr. ");
INSERT INTO avt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nanamɨr kit hɨrak kɨre weipɨr. Nanamɨr kit naanmɨpre menmen yaaim te ti han kitet menmen yaaim, o au en, ti nanamɨr kit naanmɨpre menmen enum ti han ekitet menmen enum hemkre menepam heriuwerem. ");
INSERT INTO avt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Te yi naanempre hɨras te nanamɨr ki hɨrak kɨre weipɨr hɨrak ap ekwis menmen enum mamu mamɨkre han ki. ");
INSERT INTO avt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mɨtɨk han kɨrak werek, hɨrak han kitet menmen werek werek. Te hɨrak kertei werek werek menmen God kɨrɨakem keteiknɨwekem. Hɨrak kɨre mɨtɨk han kɨrak kɨre si kɨr keteiknɨwek menmen.” ");
INSERT INTO avt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas katɨp hɨm mɨrak epei au, te mɨtɨk hak ke Farisi kitɨwekhi, “Ti enen wɨnak etikewa ewɨm menmen.” Hɨrak ketpɨwek, hɨrak ketikerek tariyakɨt ten. ");
INSERT INTO avt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hɨrakɨt tariyakɨt ten, mɨtɨk ke Farisi kehɨnhɨn kentar Jisas hɨrak ap kises hɨm me maamrer nɨr, hɨrak ap kekemyet his mɨrak te kakɨm menmen taau. ");
INSERT INTO avt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mɨtɨk Iuwe Jisas ketpɨwek, “Yi mɨt ne Farisi yekemyet sar wenkepye mi au werek, te yi ap yɨrɨak han ki keit nɨmɨn yaaik au. Hɨrak enuk kises menmen enum mɨre hemkre menepam me menmen o yi yetike miyapɨr yɨrɨran. ");
INSERT INTO avt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yi yetaritari mɨt! Hɨrak God kerek kerekyi yɨnk ki hɨrak kɨrɨak han ki ketikerek. ");
INSERT INTO avt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yi eiwet mɨt menmen mi yapɨrwe mekre sar o wenkepye hɨram mamkepi te menmen mekre han ki hɨram yaaim. ");
INSERT INTO avt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yi mɨt ne Farisi menmen enum mamnen mamiwep mamɨntar yi yewet God menmen meiyam kike me menmen yapɨrwe yi yetɨwem yaaim te yi ap yɨrɨak mɨt yapɨrwe menmen mɨpɨram au. Yi ap han tewenɨn God werek werek au. Yi eiyinɨn eirɨak mɨt yaaim mɨpɨram, yi hanhan God, menmen im metike menmen me yi eiwet God menmen kike me menmen yapɨrwe, hɨram yaaim iuwe. Te yi au yɨnapen. ");
INSERT INTO avt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Yi mɨt ne Farisi menmen enum mamiwep mamɨntar yi hanhan yayu yeno yaaim me mɨt iuwe yayɨt wɨnak kerek mɨt nererik nekine hɨm me Moses. Yi hanhan mɨt nanɨtpi nanwenɨpi niuk mi nanɨt maket, wit kerek mɨt nererik nesiuwe menmen mɨr. ");
INSERT INTO avt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Yi mɨt ne Farisi menmen enum mamiwep mamɨntar yi enun yɨre hei ke herwe kekrerek mɨt ap neriuwesɨsek au. Menmen yaaim mɨt hɨr nɨri yi yɨrɨakem, hɨram mɨsawɨn menmen enum mekre han ki mɨre meri mɨwapɨn hei enuk keriuwe herwe enuk kɨnɨn kekrerek. Maain mɨt han nises menmen yi yetporem hɨr enrɨakem te hɨr nepɨtari hɨr nises menmen enum mar ke yi mɨt yɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mɨtɨk ke mɨt Skraip katɨp Jisas kitɨwekhi, “Mɨtɨk Iuwe, ti atɨp menmen im ti enai metikeri.” ");
INSERT INTO avt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisas kewenhi ketpɨwek, “Yi mɨt ne Skraip menmen enum mamiwep mamɨntar yi yewis hɨm ham weinɨm mamtike hɨm yaaim me God, te mɨt ap nanisesim werek werek taau. Yi yenip mɨt hɨr nanisesim te yi ap eiyisesim au.” ");
INSERT INTO avt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Menmen enum mamiwep mamɨntar yi yeses herwe hei mɨkaap mɨt han tewenɨn mɨt profet kerek nɨpaa maamrer keriyen hɨr nanɨp. ");
INSERT INTO avt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yi hɨras yeteikɨn yi yertei menmen enum maamrer ni nɨpaa nɨrɨakem, yi han yaaik yeriuwerem yentar yi naanmɨpre herwe hei im e. ");
INSERT INTO avt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“God kertei menmen im te nɨpaa hɨrak katɨp hɨm mar im: ‘Hi tewen ariuwet mɨt profet nantike mɨt aposel nanɨno mɨt ne Isrel. Han hɨr nanrekyor enum, mɨt han hɨr nanɨnɨp.’ ");
INSERT INTO avt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Te God kaknep yi mɨt ne Isrel yau tɨ ik kar ke hɨrak kaknenp maamrer ni kerek nɨpaa hɨr nenep profet yapɨrwe naa me nɨpaa enum eik ere in. ");
INSERT INTO avt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nɨpaa Ebel hɨrak profet kinɨn kaa hemkre mɨrak mewen ere mɨtɨk profet kɨkaru Sekaraia kaa kerp nɨmɨn kɨnaan kerek mɨt newis menmen me God mewik metike wɨnak iuwe ke God. God kakrɨak mɨt ne Isrel nau in enum enum kakɨnterim. ");
INSERT INTO avt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Yi mɨt ne Skraip menmen enum mamiwep. Yi yertei hɨm me God te yi yeweikɨn hɨm mɨrak mɨre menmen ham. Yi yɨnapen yises hɨm mɨrak werek werek eiyɨntar yi hanhan mɨt nanɨnen nanitihi markeik te hɨr enises God werek werek. Yi enun yar ke mɨt yeiyepet weipɨr menmen mau meit nɨmɨn. Maain mɨt nanɨnen nanɨm menmen yi ap eiwisi nanɨno nɨmɨn nanɨm menmen au. Hɨr nanu nanɨt.” ");
INSERT INTO avt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Maain Jisas kɨnaaiwɨr wɨnak ik ken witeik, mɨt ne Farisi hɨr han enuk nitɨwekhi menmen yapɨrwe ");
INSERT INTO avt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nemeriyɨwek hɨrak kaktɨp menmen enum te hɨr nansiuwek hɨm nankɨp. ");
INSERT INTO avt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mɨt miyapɨr yapɨrwe nerp menep menep te hɨr nentɨreran, Jisas katɨp mɨt disaipel nɨrak kinɨn kar ik: “Yi naanempre hɨras te yi ap eiyises hɨm me mɨt ne Farisi. Hɨram enum mɨre sak haak. Hi atɨp hɨr mɨt enun nemipɨn, hɨr newɨrnak nekteni te hɨr nises han kɨr. ");
INSERT INTO avt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Menmen yapɨrwe kerek mɨsawɨn, maain God kakwepyapɨrem te mɨt nanɨrem nanɨrteiyem. ");
INSERT INTO avt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Maain hɨm kerek yi epei yetpim me wɨtaan te God ke wepni kakwepyapɨrem mɨt nanɨmtewem. Menmen kerek yi yatɨp mɨt han em yi yɨsawɨn yekre wɨnak, maain God kakwepyapɨrem kakɨt wit eik te mɨt neit wit nanɨmtewem. ");
INSERT INTO avt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Hi hetpi nai yinan, yi ap einapen mɨt au emɨt! Hɨr nenep mɨtɨk yɨnk kerekek, te maain hɨr ap te nanrɨak menmen meiyam taau. ");
INSERT INTO avt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hi hetpi eteikni keimɨn kerek yi eineinɨk. Yi einapen God. Hɨrak kakiwep epei au, hɨrak enuk manpenuk te kakwɨri yaino si enum. Hi hetpi, yi eineinɨk. ");
INSERT INTO avt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hore kike hispɨnak (5) mɨt newɨr pewek wik nantɨwem. Hore kike mɨt namɨp hɨram menmen weinɨm te God epei kertei hɨram maa. ");
INSERT INTO avt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","God epei kertei menmen iuwe, hɨrak kewenhis kertei paan marmenum mɨwapɨn paan hesnu ki. Te yi ap einaain menmen au. God katɨp yi hɨmɨn ki hɨrak menmen iuwe kinɨn hore. Hore hɨram menmen weinɨm ap hɨmɨn kewim au. God hanhan hore, te hɨrak hanhani mɨt wɨsenum naanmamri.” ");
INSERT INTO avt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jisas wen katɨp, “Hi etpi nai yinan, mɨt niutɨp niutɨp neimɨn newepyapɨr hɨras nisɨsa nerp ninaan me mɨt miyapɨr yapɨrwe, te hi Mɨtɨk ke wit ke Mɨtɨk Iuwe maain hi ewepyapɨr mɨt in me ninaan me mɨt ensel ne God, hi atpor hɨr nɨkerek ne God keriyen. ");
INSERT INTO avt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Te neimɨn hɨr nepakɨn hɨr nisɨsa me ninaan me mɨt, maain hi Mɨtɨk ke wit ke Mɨtɨk Iuwe apakɨni hɨr ne God nerp ninaan me mɨt ensel ne God. ");
INSERT INTO avt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mɨt neimɨn niutɨp niutɨp natɨp netawɨn hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, hi asak menmen enum mɨr. Neimɨn kerek natɨp neratawɨn God Hɨmɨn Yaaik, God Haai ap te kakɨsak menmen mɨr taau. Hɨram mamu mamɨt. ");
INSERT INTO avt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mɨt maain nansiuwe hɨm nanɨntar yi yises hɨm mai, hɨr nantorhis nanri nanɨno wɨnak kerek mɨt nererik nekine hɨm me Moses neitai, o yi yayɨrp ninaan me mɨt iuwe gavman netike kaunsil, te yi ap hanhan menmen te yi yayɨtpim te yi eikaap hɨras au. ");
INSERT INTO avt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yi hanhan em au eiyɨntar me wɨ eim God Hɨmɨn Yaaik kakwis menmen mamɨkre han ki te yi eiyɨtporem.” ");
INSERT INTO avt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mɨtɨk kiutɨp ke mɨt yapɨrwe nerp en katɨp Jisas kar ik: “Mɨtɨk Iuwe ti atɨp heiyiuwe kai te hɨrak ekweto menmen mei me menmen haai kawɨr kaa kewisɨm mɨwaairi, maain hawɨr ewɨnkerem ewetakɨt.” ");
INSERT INTO avt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisas ketpɨwek, “Mɨtɨk keimɨn kehimɨtena te hi ehɨnke menmen mi a?” ");
INSERT INTO avt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hɨrak keweikɨn katɨp mɨt yapɨrwe, “Naanempre hɨras te yi ap hemkre menepepam me menmen yapɨrwe. Menmen yapɨrwe mɨtɨk kentenenim ap te mamkepik kaku au.” ");
INSERT INTO avt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jisas ketpor hɨm tok piksa mar im: “Mɨtɨk hak iuwe kamɨr ni hɨram matɨn yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Te hɨrak han kitet kar ik: ‘Hi arɨak mekam? Hi menmen yapɨrwe te hi ewisɨm emwaai nein? Wɨnak au.’ ");
INSERT INTO avt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hɨrak katɨp, ‘Hi are arɨak menmen im. Hi ewep wɨnak ketike weisaak me teket te hi ehime ham wɨsenum minɨn im te hi ewis menmen mamwaai weisaak mamtike menmen mewo meit ni eim, hɨram mamno mamwaai mamɨkre weisaak kerem em. Hi arɨak menmen im, te ");
INSERT INTO avt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","hi atɨp hɨrekes, Ti epu werek werek menmen meiyam yapɨrwe mepeit me tito yapɨrwe. Ti ehu ehɨm menmen ehɨm tɨpar si enum ehu han yaaik.’ ");
INSERT INTO avt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Au, God ketpɨwek kar ik: ‘Ti etaritari mɨtɨk! Wɨtaan ik ek ti hahi, hɨmɨn kit kakno, te menmen mi yapɨrwe ti epei hetɨwem hewisɨm mɨwaai meit, maain keimɨn kaktɨwem a? Ti au!’ ");
INSERT INTO avt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Keimɨn keit menmen yapɨrwe kakɨkaap hɨrekes, te hɨrak ap kises menmen God hanhan hɨrak kakisesim, hɨrak enuk kar ke mɨtɨk eik e.” ");
INSERT INTO avt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisas katɨp mɨt nɨrak disaipel kar ik: “Yi eiyises menmen God hanhan yi eiyisesim, te hi hetpi menmen im: yi ap han ekitet karkeik eiyɨt pewek eiwɨrem eiyɨt menmen yi yayɨm o menmen yi eimɨr emu yɨnk ki au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hɨmɨn ki kepu werek, hɨrak kinɨn menmen yi eiyɨm. Yink ki kaku werek werek kakinɨn menmen yi yamɨr. ");
INSERT INTO avt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yi yayɨr hore tepre. Hɨram ap mamɨr ni meket teket au. Hɨram mime wɨnak te mewis menmen mekrerem au, te God kewetɨr menmen. God han kitet yi iuwe yinɨn hore, hɨram au menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mɨtɨk keiyak hɨrak han kitet kakrɨak menmen te hɨrak kaku wɨ meiyam o tito yapɨrwe au. ");
INSERT INTO avt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yi ap eɨrɨak menmen kike mar im au, te yi yenmak han kitet menmen ham te yi yayu werek werek a? Au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Yi yayɨr timen mɨwaai yayiwe. Hɨram mewo, hɨram ap mesikek yɨwaap mekerwo menmen au. Te hɨram yaaim mɨr minɨn mɨtɨk iuwe King Solomon hɨrak ketenen menmen yapɨrwe. Hɨrak nɨpaa ap kamɨr menmen mau yɨnk kɨrak yaaim minɨn timen im au. Te timen hɨram menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God kerekek kɨrɨak menmen im hɨram yaaim te hɨram petepin mepu teipmen mami, te mɨt nantɨwem neiyɨm nanwɨrem mamɨkre si. Timen im hɨram menmen weinɨm, te God kakweti menmen yi yaimɨr mamu yɨnk. Yi ap han kitet God werek werek au. ");
INSERT INTO avt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yi ap han kitet yapɨrwe yi yayɨt menmen o tɨpar te yi yayɨm ere tu iuwe au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mɨt nerer wit wit ap nises God hɨr han kitet menmen mar im. God hɨrak Haai ki kertei yi yayɨt menmen im te yi eiyu. ");
INSERT INTO avt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Te yi yinɨn eiyises menmen God hanhan yi eiyisesim, te hɨrak kakweti menmen mamkepi yi yayu werek werek.” ");
INSERT INTO avt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yi mɨt nai yɨre sipsip, yi ap einaain menmen au eiyɨntar God Haai ki kakwisi yi eiyinɨn naanmamre mɨt me menmen mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yi yesiuwe menmen yapɨrwe kerek yi yetenenim yayɨt pewek mererim eiwet mɨt weinɨn m. Mar im yi yaiwis menmen yaaim mamkepi mamwaai wit ke God. Hɨram mamu mamɨt te mɨt enun nekintɨp menmen o wesiuk mamnen mamɨwaank menmen mi mamɨt en au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Menmen ti hanhanem, han kit ekitetim. ");
INSERT INTO avt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Yi eimɨr laplap tokim keremem, yi eiyɨt waai eiyɨk eitepenem eiyɨksiu si, yi eiyu eimerɨr menmen mamnen. ");
INSERT INTO avt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yi yayre mɨt nemerɨr mɨtɨk iuwe kɨr kaknen kakɨke wit kerek mɨte wetike mɨtɨk neitan neitai ein ek, hɨrak kaknen wit kɨrak te hɨr nanɨnkɨwek weipɨr wasenum kerek hɨrak kan keretɨtek. ");
INSERT INTO avt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Te mɨtɨk iuwe kaknen kakri mɨt nɨrɨak menmen mɨrak ap nɨwaai au, te mɨt keriyen hɨr han yaaik. Hi etpi te hɨrak kakmɨr laplap tokim mɨrak hɨrak kakɨtpor nanu yeno kerek naam menmen menterim, te hɨrak kaknen kakwetɨr menmen hɨr nanɨm kakɨr ke wok mɨtɨk kɨr. ");
INSERT INTO avt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Te hɨrak kaknen kakɨ wɨ nɨmɨn suware kenep enum, hɨrak kɨr mɨt nɨrɨak menmen mɨrak hɨr nepu, hɨr han yaaik nanu. ");
INSERT INTO avt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Yi eiyɨrtei menmen im e. Mɨtɨk ke wɨnak epei kertei wɨ kerek mɨtɨk enuk kekintɨp menmen kaknen, te hɨrak ap kakwisɨk kakwep weipɨr kakno nɨmɨn kekin menmen mɨrak au. ");
INSERT INTO avt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yi yɨre mɨtɨk eik e. Yi eimeriyo hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke anen me wɨ yi yepɨtari hi anen.” ");
INSERT INTO avt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas katɨp epei au, Pita kitehi Jisas, “Ti hetpei keriyen hɨm im o haiu mɨt yapɨrwe?” ");
INSERT INTO avt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Te Jisas kewenhi katɨp, “Hi hetpi yi yapɨrwe. Yi han kitet keimɨn kɨrɨak menmen me mɨtɨk iuwe, hɨrak yaaik kemtau hɨm kisesim? Hɨrak mɨtɨk kerek mɨtɨk iuwe kɨrak kakwisɨk kakinɨn naanmamre mɨt han kerek nɨrɨak menmen me mɨtɨk kiutɨp kerek ek, hɨrak kakinɨn kakwetɨr menmen yaaim nanɨm me wɨ hɨrak kewetɨrem. ");
INSERT INTO avt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Maain mɨtɨk iuwe kaknen kakɨr mɨtɨk kɨrɨak menmen mɨrak hɨrak wen kɨrɨakem, te hɨrak han yaaik keriuwerek, te mɨtɨk kerekek han yaaik. ");
INSERT INTO avt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hi hetpi werek. Hɨrak kakwisɨk naanmamre menmen mɨrak yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mɨtɨk hak kɨrɨak menmen me mɨtɨk iuwe kɨrak kaktɨp, ‘Mɨtɨk iuwe kai ap te kaknen waswas,’ te hɨrak kaknep mɨt han kerek nɨrɨak menmen me mɨtɨk iuwe kerek ek, kaknep miyapɨr kerek nɨrɨak menmen me mɨtɨk iuwe kerekek, neiyewewan, kaam menmen metike tɨpar si enum. ");
INSERT INTO avt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Te mɨtɨk iuwe kerekek maain hɨrak kaknen me wɨ hɨrak ap kermeriyɨwek au. Hɨrak han kaa pɨke kaknen keremem. Hɨrak au ketari, te hɨrak kakrekyɨwek enum kakɨwaankek kaksiuwerek kakno kaktike mɨt han kerek nɨrɨak menmen mɨrak ap nises hɨm mɨrak werek werek au. ");
INSERT INTO avt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mɨtɨk kerekek kemtau hɨm me mɨtɨk iuwe kɨrak, te hɨrak ap kises hɨm mɨrak, hɨrak mɨtɨk iuwe kɨrak kakɨkɨp wɨsenum kakriuwe nɨpɨn. ");
INSERT INTO avt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Te hɨrak keimɨn ap kertei werek werek menmen mɨtɨk iuwe kɨrak hanhan hɨrak kakrɨakem, hɨrak kɨrɨak menmen enum, te mɨtɨk kɨrak kakɨp kakriuwe nɨpɨn au kike. Mɨt kerek God kewetɨr menmen yapɨrwe, maain hɨr pɨke enwet God em. Mɨt neimɨn kerek neit menmen yapɨrwe me mɨt, maain hɨr pɨke enwetɨrem yapɨrwe.” ");
INSERT INTO avt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas wen katɨp, “Hi han hewɨr si meit tɨ ik, te hi hanhan si emɨrhɨhe waswas, ");
INSERT INTO avt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","te hi ahinɨn ahɨwaank wɨsenum hahi. Han kai enuk heriuwe menmen mamrewaank ere hɨram epei au. ");
INSERT INTO avt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yi han kitet hi epei han te hɨrɨak mɨt nankiyan nanu nanɨt a? Au, hi epei han te hi ewep mɨt miyapɨr han nanɨnepan nanɨntar hɨm mai. ");
INSERT INTO avt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","In ek ere maain mɨt ne wɨnak kiutɨp nar mɨt hispɨnak (5) hɨr nanɨnke. Mɨtɨkɨt wikak tatkite mɨtɨkɨt wiketeret nanɨnehan nanɨnepan nanɨntar hɨm mai. ");
INSERT INTO avt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mɨt nanɨnkehan. Haai kaktike nɨkan kɨrak tatnehakɨt tatnepakɨt. Miye wautike nɨki pɨre nanɨnehan nanɨnepan. Mɨte wautike yani pɨre nanɨnehan nanɨnepan nanɨntar hɨm mai.” ");
INSERT INTO avt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hɨrak katɨp disaipel nɨrak epei au, hɨrak katɨp mɨt miyapɨr yapɨrwe kar ik: “Yi epei yɨr napɨ meke wit kerek wepni kewen ken keremem, waswas yi yatɨp, ‘Hawɨ kaknen.’ Maain hɨrak kaknen. ");
INSERT INTO avt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yi yemtau nɨme wenituk meke wepni kokai kan te yi yatɨp, ‘Wepni sisi iuwe kaknen.’ Maain hɨrak kaknen. ");
INSERT INTO avt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yi mɨt enun yemipɨn. Yi yertei menmen me tɨ o nepni. Yi yenmak te yi yetari menmen God in ek kɨrɨakem a? ");
INSERT INTO avt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Yi yenmak te yi ap han kitet menmen yaaim te yi yɨrɨakem a? ");
INSERT INTO avt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mɨtɨk hak kesiuwe hɨm kerwit (o kerwetit) te ti eno ehɨr mɨtɨk iuwe ke gavman. Ti eno kot hitet yayiwe, ti etpɨwek te yi eikiyakɨt eiyu, o au en, hɨrak kakɨrit eno kot, maain mɨt nanwɨrit eno wɨnak enuk. ");
INSERT INTO avt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Hi etput, ti ehu ere ti ewɨr pewek eiyɨm etnik.” ");
INSERT INTO avt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Me wɨ im, mɨt han nepu en hɨr natɨp Jisas nar ik: “Mɨt han ne Galili nen wɨnak ke God nenep samiyak mɨr newepwarem nanwet God em, te mɨtɨk iuwe gavman Pailat kesiuwe mɨt nɨrak ne ami nen nanɨp, hemkre mɨr meweiknenim metike miyak mɨwaai kɨnaan.” ");
INSERT INTO avt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisas kewenhi ketpor kar ik: “Yi han kitet mɨt hɨr naa nar ik, menmen im meteiknai mɨt in ne Galili hɨr nɨrɨak menmen enum minɨn mɨt han ne provins Galili a? Taauye! ");
INSERT INTO avt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hi etpi werek. Yi ap eiweikɨn sip eiwet menmen enum yi yayi yayɨr ke mɨt ein ne provins Galili epei naa. ");
INSERT INTO avt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yi yertei mɨt hiswiyen hispɨnak (15) naa neit tɨpar me wit Siloam nentar wɨnak nokik kewen kanɨp? Yi han kitet menmen enum hɨr nɨrɨakem hɨram minɨn menmen enum mɨt han ne wit Jerusalem nɨrɨakem a? Taauye! ");
INSERT INTO avt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hi etpi werek. Yi ap eiweikɨn sip eiwet menmen enum yi yayi yayɨr ke mɨt in.” ");
INSERT INTO avt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hɨrak wen ketpor hɨm tok piksa hɨrak katɨp kar ik: “Nu hɨnaan kewo keit ni me mɨtɨk hak. Hɨrak ketpaan ken kakɨr nɨkim au, hɨrak kuwaau (o kiwaau). ");
INSERT INTO avt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hɨrak kuwaau (o kiwaau) au, hɨrak katɨp mɨtɨk kerek naanmɨprɨwek ni mɨrak kar ik: ‘Ahɨrem! Tito wikak hi han hen hɨr nu hɨrak ap kine nɨkim au. Ti ekan nu eik ek eknepɨn. Hi hɨnapen hɨrak kaku tɨ ik e kari nan tɨ.’ ");
INSERT INTO avt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Te mɨtɨk naanmɨpre tɨ kerekek katɨp mɨtɨk iuwe, ‘Ewisɨk akɨrek me tito im e, hi awep wi aweiknɨwek awɨr waniu (o win) mamwetɨwek. ");
INSERT INTO avt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Maain hɨram mamine nɨkim hɨram yaaim, o au en, ti ekan eketik eknepɨn ekɨkeipɨn.’” ");
INSERT INTO avt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Me wɨ Sabat, Jisas keit wɨnak kerek mɨt nererik nekine hɨm me Moses, hɨrak kewepyapɨr hɨm me God. ");
INSERT INTO avt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Me wɨ im, mɨte hap wepu. Tɨpir kaaup te hɨre wɨnap tito hiswiyen hispɨnak wikak (18). Hɨre sip kɨre kɨn te hɨre ap wekrit wen werek werek au. ");
INSERT INTO avt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas kɨrep, te hɨrak kenɨnwe ketpɨwe kar ik: “Mɨte hi hepɨr menmen enum mewit mamno mamnopɨn mamkeipnut, te ti ere yaaip.” ");
INSERT INTO avt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hɨrak kewis his mɨrak menteriye, hɨre wekrit wenhɨ hɨrehes wekrit werp, hɨre wewenɨpi niuk me God. ");
INSERT INTO avt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mɨtɨk kinɨn naanmɨpre wɨnak ik e, hɨrak han enuk kentar Jisas kɨkaap mɨte me wɨ Sabat, te hɨrak katɨp kar ik: “Wɨ hispɨnak kiutɨp (6) haiu mamrɨak menmen. Yi einen in me wɨ eim te God kakɨkepi te yi yayu werek. Me wɨ Sabat emɨt!” ");
INSERT INTO avt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jisas pɨke ketpɨwek, “Yi mɨt enun yewisesik. Yi mɨt niutɨp niutɨp me wɨ Sabat yaino yaisiupan bulmakau o hos yairiyaam mamno mamɨm tɨpar. ");
INSERT INTO avt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mɨte ip e kerek hɨre nepenye pe Ebraham kerek Seten kerekyɨwe enum te hɨre wɨnap tito hiswiyen hispɨnak wikak (18). Hɨre winɨn sak mi te hi ekepye herekyɨwe yaaim me wɨ Sabat.” ");
INSERT INTO avt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mɨt han kerek nɨpaa natɨp menmen enum, hɨr yɨnk enuk nekintɨp nentar hɨrak katɨp hɨm im. Te mɨt yapɨrwe han yaaik neriuwe menmen iuwe yaim hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas pɨke katɨp, “Menmen God kɨrɨakem hɨram mɨre mekam? Te hi enɨnem mamtike mekam mamɨram? ");
INSERT INTO avt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hɨram mɨre nu mastet nɨkim mɨrak kike enum. Mɨtɨk hak ketɨwem kamɨr mau ni mɨrak. Maain hɨrak ken niu kɨre nu iuwe, hore hɨram meniuwe meke niu mewis yaank mewik.” ");
INSERT INTO avt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisas pɨke katɨp, “Hi enɨn menmen God kɨrɨakem mekre han kaiu hɨram mamtike mekam mamɨram? ");
INSERT INTO avt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hɨram mɨre yis mɨte hap wewisɨm metike plaua, hɨre weweiknenim ere werek. Maain plaua mɨniu wɨsenum.” ");
INSERT INTO avt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas katɨp epei au, hɨrak ken wit iuwe wit kike kewepyapɨr hɨm me God te hɨrak kakpɨno Jerusalem. ");
INSERT INTO avt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mɨtɨk hak ketpɨwek, “Mɨtɨk Iuwe, maain God kakɨthis mɨt niutɨp niutɨp keriyen nanu nantikerek o au?” Jisas katɨp mɨtɨk ik ketike mɨt yapɨrwe kar ik: ");
INSERT INTO avt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yi naanmamre hɨras te yi eino eitet weipɨr kike ek. Hi hɨre weipɨr. Mɨt yapɨrwe hɨr hanhan nanɨno nantikerek nanɨno nɨmɨn ein te hɨr au. ");
INSERT INTO avt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Maain mɨtɨk ke wɨnak kerek kakɨkrit kakiyepet weipɨr, te yi yayɨrp wit eik yairetɨt weipɨr yaitɨp, ‘Mɨtɨk Iuwe, ekaisiu weipɨr.’ Hɨrak kakɨtpi, ‘Hi ap ertei yi neimɨn.’ ");
INSERT INTO avt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Te yi yaiyɨtpɨwek, ‘Haiu nɨpaa maam menmen maam tɨpar metikewit, te ti herp yayiwe kaiu eik ek ewepei hɨm.’ ");
INSERT INTO avt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Te hɨrak kaktɨp, ‘Hi hetpi, hi ap hertei yi neimɨn. Yi eiyɨnka eikeipno yi mɨt enun yɨrɨak menmen enum.’ ");
INSERT INTO avt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Te maain yi eiyɨr Ebraham, Aisak, Jekop netike mɨt profet nanu nantike God te yi au eiyɨt wit eik yaykɨt yainakɨn yehes. ");
INSERT INTO avt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mɨt nanɨnen nanke wepni kokai kan, han nanɨnen nanke wepni kewen ken o nanoke pɨnak nanoke pɨnak nanɨnen nanu yeno nanɨt wit ke God nanɨm menmen iuwe. ");
INSERT INTO avt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mɨt han kerek in ek hɨr mɨt weinɨn ek maain hɨr naninɨn mɨt iuwe han. In ek hɨr mɨt iuwe te maain hɨr nanre mɨt weinɨn.” ");
INSERT INTO avt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hɨrak wen ketpim, mɨt han ne Farisi hɨr nan netpɨwek, “Yi eino eikeipɨn! In ek mɨtɨk Herot hanhan kakitep!” ");
INSERT INTO avt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas ketpor, “Yi eino eitɨp manpen mawenekɨn Herot petepin, teipmen, tepɨn hi epɨr herwe enum, hɨkaap mɨt nɨnaap hɨr pɨke nɨre yaain. Me wɨ wikak menmen mai epei au. Menmen mai epei au, hi ehu ehɨt. Herot kakiyep au ere hi hɨrɨak menmen epei au. ");
INSERT INTO avt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Te hi wen ano ehitet yayiwe petepin, teipmen, tepɨn. Hi profet ke God ap ahi ehɨt wit hak au. Wit Jerusalem kerekek. ");
INSERT INTO avt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O mɨt miyapɨr ne Jerusalem! Nɨpaa God keriuwet mɨt profet hɨr newepyapɨr hɨm mɨrak te yi yanɨp naa. Wɨ yapɨrwe hi hanhan hari yi mɨt yererik hi naanmɨpri har ke suware wari nɨkim mɨnɨk yapɨr mɨre, te yi au yɨnapen. ");
INSERT INTO avt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","In ek God keweikɨn sip kewet wit ki, yi hɨras naanmɨprewem. Hi etpi werek, yi eira au ere yi yaitɨp, ‘God kɨrɨak yaaim kakɨkaap mɨtɨk hɨrak keriuwetek kaknen kakɨkrehɨr ke God.’” ");
INSERT INTO avt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Me wɨ Sabat, Jisas ken kaam menmen keit wɨnak ke mɨtɨk iuwe ke Farisi. Hɨr mɨt nau en naanmɨprewek te hɨrak kɨrɨak menmen. ");
INSERT INTO avt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mɨtɨk hak his hɨt mɨrak mɨnwo hɨrak kerp menep kɨrapɨt Jisas. ");
INSERT INTO avt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas katɨp mɨt ninɨn nertei hɨm me Moses natɨp mɨt em hɨr netike mɨt ne Farisi kerek ninɨn nises hɨm me Moses, hɨrak kitorhi kar ik: “Hɨm me Moses mamwisai haiu mɨt mamkaap mɨt nɨnap me wɨ Sabat o au?” ");
INSERT INTO avt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hɨr ap newenhi au, wɨre wɨre neit, te Jisas keit mɨtɨk kekepik ere werek, hɨrak kesiuwerek ken. ");
INSERT INTO avt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hɨrak kesiuwerek ken, hɨrak keweikɨn kitorhi kar ik: “Hos mi o bulmakau mi mamɨnke mamɨkre hei me wɨ Sabat, yi eiriyaak eiketik me wɨ Sabat o au?” ");
INSERT INTO avt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hɨr ap newenɨwekhi netpɨwek menmen au. Hɨr yɨnk enuk. ");
INSERT INTO avt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas epei kɨr mɨt yapɨrwe kerek nanɨnen nanɨm menmen, hɨr nau yeno yaaim me mɨt iuwe te hɨrak ketpor tok piksa mar im. ");
INSERT INTO avt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Hɨrak katɨp, “Wɨ kerek mɨtɨk hak hɨrak kenɨni einen eiyɨm menmen me nɨkan kɨrak kakɨt mɨte, yi ap eiyu yeno yaaim me mɨt iuwe, te mɨtɨk iuwe akinɨnit eknen. ");
INSERT INTO avt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hɨrak eknen te mɨtɨk kerek nɨkan kɨrak kakɨt mɨte, hɨrak kaknen kakɨtpi, ‘Yi eiyɨnke eino ein, eiwis mɨtɨk iuwe ik hɨrak ekwim.’ Hɨrak kɨrɨak menmen im te yi yɨnk enuk eiyɨntar yi eiyu yeno weinɨm. ");
INSERT INTO avt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Im em emɨt! Mɨtɨk ketpi yi einen eiyɨm menmen yi eiyu yeno weinɨm me mɨt, te maain mɨtɨk nɨpaa ketput yi einen eiyɨm, hɨrak kaktihis kakɨtpi kakɨr ik: ‘Nai yinan, yi einen eiyu yeno me mɨt iuwe newim,’ te mɨt en nɨpaa hɨrak netikewi yayɨm menmen hɨr han kitet yi iuwe. ");
INSERT INTO avt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mɨtɨk kerek han kitet hɨrekes mɨtɨk iuwe, God kakrɨakek hɨrak mɨtɨk weinɨk.” ");
INSERT INTO avt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nepei au, Jisas katɨp mɨtɨk kerek nɨpaa ketpɨwek kaknen kakɨm, hɨrak ketpɨwek kar ik: “Maain ti enɨne mɨt nanɨnen nanɨm menmen iuwe, ti ap enɨne paaprer o haairer o nɨkerek o kikrek o nit yinan netenen menmen iuwe au emɨt! Ti ap erɨakem ehisesim ehɨntar maain hɨr pɨke nanwetut menmen mit mamrerim. ");
INSERT INTO avt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maain ti hemani menmen, ti enɨne mɨt enun menmen auri o mɨt his hɨt nanamɨr enum. ");
INSERT INTO avt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ti erɨak menmen mar im te God maain kakrekyut yaaim kakɨntar mɨt in enun te hɨr ap pɨke nanwetutem mamrerim. Maain God kakwetutem me wɨ kerek maain hɨrak kakɨkɨan mɨt kerek nɨre yaain hɨr pɨke nanɨkrit nanu nantikerek.” ");
INSERT INTO avt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mɨtɨk kiutɨp kau kɨnaan kaam menmen kemtau menmen Jisas katɨp, hɨrak ketpɨwek kar ik: “Mɨt nau kɨnaan neit wit ke God nanɨm menmen hɨr han yaaik nanu.” ");
INSERT INTO avt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisas ketpɨwek, “Nɨpaa ein mɨtɨk kemani menmen kenɨne mɨt yapɨrwe nanɨnen. ");
INSERT INTO avt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wɨ epei man te hɨrak kakwet mɨt menmen. Hɨrak keriuwet mɨtɨk kɨrak kaknɨnor kakɨtpor kar ik: ‘Hi epei emani menmen te yi einen eiyɨm eitikewa.’ ");
INSERT INTO avt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hɨrak kitorhi, te hɨr yapɨrwe natɨp, ‘Haiu ap te mamno au.’ Mɨtɨk hak katɨp, ‘Hi epei hewɨr pewek heiyɨm hatɨn tɨ, te hi eno ahɨrek te hi hanhan ti ap han enuk heriuwe hi ap enen taau.’ ");
INSERT INTO avt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mɨtɨk hak katɨp, ‘Hi epei hewɨr pewek etɨn bulmakau hiswiyen (10) me mamwen tɨ te hi ano ahɨrem enɨnem te hi hanhan ti ewisa hi ehu in ehɨm menmen mit au.’ ");
INSERT INTO avt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mɨtɨk hak katɨp, ‘Hi epei heit mɨte te hi ap anen au.’ ");
INSERT INTO avt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Te mɨtɨk kerek kɨrɨak menmen mɨrak, hɨrak ken ketpɨwek. Epei ketpɨwek, hɨrak han enuk ketpɨwek kar ik: ‘Ti eno waswas erer yayiwe me wit ehɨthis mɨt kerek his hɨt nanamɨr mɨre enum, kerek nau yayiwe ek e.’ ");
INSERT INTO avt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Maain mɨtɨk hɨrak epei kan ketpɨwek, ‘Mɨtɨk Iuwe, menmen ti etpewem hi epei hɨrɨakem, te yeno ham wen mepeit weinɨm.’ ");
INSERT INTO avt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mɨtɨk iuwe katɨp mɨtɨk kerek kɨrɨak menmen mɨrak kar ik: ‘Ti eno ehitet yayiwe iuwe, ehitet ya ke yaank, ya meke nɨmɨn te wɨnak kai eknempet ekriuwe mɨt miyapɨr. ");
INSERT INTO avt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hi etput werek. Ap nei kerek nɨpaa hi henɨnor nanɨnen nanɨm menmen nantikewa au.’” ");
INSERT INTO avt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mɨt miyapɨr yapɨrwe nen nises Jisas te hɨrak keweikɨn ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mɨtɨk kerek kaknen kakisɨsa hɨrak hanhan kinɨn kemtau hɨm me miye haai nɨrak, mɨte o nɨkerek nɨrak, hɨrak ap kakises hɨm mai taau. ");
INSERT INTO avt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mɨtɨk kerek kisɨsa te kɨnaain menmen enum mamnen mamkɨp, hɨrak ap te kakises hɨm mai werek werek au. ");
INSERT INTO avt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Keimɨn ke yi mɨt hanhan kakime wɨnak iuwe nokik, hɨrak wen eku han ekitet hɨrak ketenen teket mei o niu mei kakwet mɨt kerek nankepik nanime wɨnak kɨrak ere nanɨnepik. ");
INSERT INTO avt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hɨrak epei kekin hei kamɨr teinɨk kewis tapɨn, te hɨrak ap kime wɨnak kenterim wen au kentar hɨrak pewek kike hɨram epei au mesi, te mɨt kerek nanɨnen nanɨrek nanitetɨweknaan nanɨniuwesɨsek. ");
INSERT INTO avt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Hɨr nantɨp nar ik: ‘Mɨtɨk ik kakime wɨnak te hɨrak ap kakimaak ere werek au.’ ");
INSERT INTO avt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Mɨtɨk iuwe kerek naanmɨpre mɨt yapɨrwe en kakno kaktike mɨt yapɨrwe nɨrak 10,000 nanɨno nanɨnepan nantike mɨtɨk iuwe hak ketike mɨt nɨrak yapɨrwe nar 20,000. Hɨrak wen eku han ekitet hɨrak manpenuk te kakɨrp kakinɨn mɨtɨk hak ik kaktike mɨt nɨrak o taau. ");
INSERT INTO avt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Au en, mɨtɨk hak ek wen kepeit yanɨmɨn, hɨrak kakriuwet mɨt nɨrak nanɨno nanwenyipɨrek nanitɨwekhi me mekam hɨr enrɨakem te hɨr enkiyan enu enɨt. ");
INSERT INTO avt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te keimɨn hɨrak ap ekinɨn han kitet werek werek ekweikɨn sip ekwet menmen mɨrak, hɨrak ap te kakises hɨm mai taau. ");
INSERT INTO avt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol hɨram menmen yaaim, te hɨram tokim ap matɨn hɨm mamɨrmeim te hɨram pɨke emtɨn hɨm? Taauye! ");
INSERT INTO avt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mɨt ap newɨrem te mamkaap tɨ au. Hɨram mamɨwaank tɨ. Hɨr nanwɨrem mamno mune me bulmakau mamkaap menmen meit ni eim mamwo taau. Mɨt nanwɨrem mamitet yayiwe weinɨk. Nɨkɨp emnep eiyɨmtewem!” ");
INSERT INTO avt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wɨ ham, mɨt enun kerek nari pewek me takis, hɨr netike mɨt han enun nises menmen enum, hɨr nan menep nanɨmtau hɨm me Jisas. ");
INSERT INTO avt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mɨt han ne Farisi netike mɨt nertei menmen me Moses newepyapɨr mɨt em, natɨpan nene Jisas nar ik: “Hɨrak hanhan kari mɨt enun kaam menmen ketikeri.” ");
INSERT INTO avt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Te Jisas kewenhi ketpor tok piksa im e: ");
INSERT INTO avt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mɨtɨk kiutɨp ke yi mɨt kewis sipsip yapɨrwe, hak kɨnaaiwɨr mɨtɨk ik kɨrɨr keit yaank te hɨrak kaknaiwɨrem mamu weinɨm, hɨrak kakɨnkakɨtnɨwek ere kerek epei kɨrɨr ek hɨrak kaknapɨnek. ");
INSERT INTO avt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hɨrak kaknapɨnek, hɨrak kektɨn hɨpi han yaaik kakriuwerek. ");
INSERT INTO avt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hɨrak kektɨn hɨpi kaknan ek kakɨr ik kakiun wit, hɨrak kaknɨne nɨrak yinan netike mɨt ne wit kɨrak kakɨtpor, ‘Yi han yaaik eitikewa. Hi epei hɨnapɨn sipsip kerek nɨpaa kɨrɨr keit yaank eik.’ ");
INSERT INTO avt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hi hetpi mɨt ensel neit wit ke God hɨr han yaaik kike keriyen neriuwe mɨt yaain hɨr nau werek werek. Te hɨr han yaaik wɨsenuk neriuwe mɨtɨk enuk kiutɨp keweikɨn sip kewet menmen enum. Hɨr han ehitet yayiwe iuwe, ehitet ya keyaaik iuwe nar ke mɨtɨk hɨrak han yaaik kentar sipsip kɨrak hɨrak kɨnapɨnek.” ");
INSERT INTO avt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mɨte peimɨn wetenen pewek hiswiyen (10), te kiutɨp kɨnatɨn keit, hɨre weksiu si wɨripep wɨnak ere hɨre wɨnapɨnek. ");
INSERT INTO avt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hɨre epei wɨnapɨnek, hɨre wenɨne nɨre yinan netike miyapɨr ne wit kɨre eik, hɨre wetpor war ik: ‘Yi han yaaik eiyu eitikewa eiyɨntar hi hɨnapɨn pewek kerek nɨpaa kɨnatɨn.’ ");
INSERT INTO avt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hi hetpi mar im. Mɨt ensel ne God hɨr han yaaik iuwe neriuwe mɨtɨk hak kiutɨp keweikɨn sip kewet menmen enum.” ");
INSERT INTO avt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas wen ketpor kar ik: “Mɨtɨk hak kine nɨkerek hɨrakɨt wikereret. ");
INSERT INTO avt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kike katɨp haai kɨrak, ‘Haai enkaau menmen mei in ek maain ti hahi ti ewetewem.’ Nepei au, haai kɨrak kenke menmen mɨrak kewet nɨkerek tɨrak em. ");
INSERT INTO avt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Maain wɨ ham, kike kesiuwe tɨ keit pewek mererik keiyɨm kakno wit iuwe yanɨmɨn ein. Hɨrak kenke menmen mɨrak kewɨrem keiyɨm katɨn menmen enum. ");
INSERT INTO avt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hɨrak kewɨr pewek keiyɨm katɨn menmen enum ere pewek nan epei au mesi hɨrak kau weinɨm. Hɨrak kau weinɨm, hawɨ au te ni merer wit wit mewo au, maa meit te mɨt menmen auri, hɨr nɨnpɨ maan. ");
INSERT INTO avt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hɨrak nɨnpɨ maak te hɨrak ken kɨrɨak menmen me mɨtɨk ke wit ik e, hɨrak kesiuwerek kakno naanmamre sak mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hɨrak hanhan kakɨm nu weki nɨkim mɨt newet sak em kentar hɨrak menmen au ap mei mau te hɨrak kakɨm au. ");
INSERT INTO avt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Hɨrak epei kertei hɨrak kau enum enum hɨrak han kitet hɨrekes katɨp kar ik: ‘Mɨt yapɨrwe nɨrɨak menmen me haai kai, hɨr neit menmen werek te hi au nɨnpɨ meiyo, hi hau in hahi hentar hi menmen au. ");
INSERT INTO avt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Hi pɨke eno ahɨr haai kai hi etpɨwek, ‘Haai, hi epei eweikɨn sip ewet God hi herekyut enum. ");
INSERT INTO avt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hi ap yaaik te hi hɨre nɨkan kit au. Ti ewisa hi are mɨt nɨrɨak menmen mit.’ ");
INSERT INTO avt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hɨrak han kitet kar ik, te hɨrak kekrit kakno kakɨr haai. “Hɨrak kan kitet yanɨmɨn, haai kɨrak kɨrek, hɨrak hanhanek kesiukɨn ken keiyewewik, kemwek tekep kises menmen me maamrer hɨrak keteiknɨwek hɨrak han yaaik keriuwerek. ");
INSERT INTO avt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nɨkan katɨp haai kar ik: ‘Haai ye! Hi epei eweikɨn sip ewet God hi herekyut menmen enum. Hi ap yaaik te ti enewa hi nɨkan kit au.’ ");
INSERT INTO avt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Te haai keremirɨwek hɨm katɨp mɨt nɨrɨak menmen mɨrak ketpor kar ik: ‘Yi eino waswas eiyɨt laplap yaaim emɨriyɨwekem eiyɨt pitau eiyɨnwɨkem eiriuwetɨwek su emu hɨt. ");
INSERT INTO avt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Eiyɨt bulmakau kerek wa kewik eikɨp eiyɨk te haiu emɨm han yaaik emu. (Haai kɨrɨak menmen im keteikɨn nɨkan kɨrak hɨrak wen hanhan hɨrak kɨre nɨkan kɨrak.) ");
INSERT INTO avt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Haiu mamrɨakem mamɨntar nɨkan kai hɨrak kar ke mɨtɨk kaa. Te in ek haiu mɨnapɨnek epei kekrit kau.’ Hɨr nɨrɨak menmen han yaaik neriuwerem naam. ");
INSERT INTO avt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“In ek heiyiuwe kɨrak keit ni eim. Hɨrak pɨke kaknen wɨnak eik hɨrak kemtau mɨt nɨrɨre nine henye. ");
INSERT INTO avt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hɨrak kenɨne mɨtɨk ke mɨt nɨrɨak menmen me haai kɨrak, hɨrak kitɨwekhi kar ik: ‘Yi mɨt ein yi yɨrɨak mekam?’ ");
INSERT INTO avt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hɨrak kewenhi kar ik: ‘Nɨkik kit epei kan te haai kit kenep bulmakau wa kewik nɨak naak neiyɨk nɨrɨre nenar nɨkik kit pɨke kan kepu werek, haai hɨrak han yaaik.’ ");
INSERT INTO avt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hɨrak kemtewek epei au, hɨrak kine han enuk. Haai kɨrak ketpaan kan, hɨrak ketpɨwek kari han kɨrak te hɨrak kɨnapen kakno wɨnak nɨmɨn ein. ");
INSERT INTO avt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hɨrak katɨp haai kɨrak, ‘Hi epei hɨrɨak menmen mit tito yapɨrwe, ap wɨ miutɨp te hi eweikɨn sip ewet hɨm mit au. Te ti ap eweto sak meme kiutɨpen te hi etike nai yinan mamkɨp mamɨk meiyɨk mamrɨre au. ");
INSERT INTO avt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Te nɨkan kit enuk kerek nɨpaa kewɨr pewek kerek nɨpaa ti ewetɨwekem, hɨrak ketike miyapɨr enun nari mɨt his newenɨnem neiyewewan, hɨrak epei kan in, te ti enep bulmakau yaaik wa kewik ekɨp ewetɨwekek.’ ");
INSERT INTO avt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Haai ketpɨwek, ‘Nɨkan kai, ti hekrit hekrit epu etikewa. Menmen yapɨrwe mai hɨram menmen mit. ");
INSERT INTO avt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Te haiu han yaaik emu emɨm menmen emrɨre emɨntar nɨkik kit hɨrak kar ke mɨtɨk epei kaa. Te in ek hɨrak pɨke kekrit kepu. Hɨrak kɨre sipsip kepɨr keit yaank, te in ek haiu mɨnapɨnek.’” ");
INSERT INTO avt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas katɨp mɨt disaipel nɨrak kar ik: “Mɨtɨk hak ketenen pewek menmen ham yapɨrwe, hɨrak kewis mɨtɨk hak naanmɨpre menmen mɨrak. Mɨt han nan netpɨwek, ‘Mɨtɨk kerek naanmɨpre menmen mit hɨrak kewɨr pewek mit menep epei mamesi.’ ");
INSERT INTO avt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hɨrak kemtewek, hɨrak ketpɨwek kar ik: ‘Hi epei hemtau ti hɨrɨak enum. Ti ewiso tɨwei eteikno menmen ti epei hɨrɨakem entar ti ap wen naanmɨpre menmen mai au.’ ");
INSERT INTO avt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Te mɨtɨk kemtau menmen me mɨtɨk iuwe kerekek hɨrak han kitet hɨrekes katɨp kar ik: ‘Mɨtɨk iuwe kai kakɨnka kakriuweta hi ano entar hi hɨrɨak enum heriuwe menmen mɨrak. Hi arɨak mekam? Hi ap manpenuk te hi ewep wi au. Hi yɨnk enuk ehu yayiwe ehitehi mɨt nanweto pewek au. ");
INSERT INTO avt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hi epei han kitet arɨak menmen ham te mɨt hɨr anɨra entauhis ano wɨnak kɨr hɨr naanemprau. Te maain hi epei henke ekeipɨn menmen nɨpaa ein hi naanmɨprewem hi ehu werek.’ ");
INSERT INTO avt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Te hɨrak kenɨne mɨt yapɨrwe niutɨp niutɨp nan kerek nɨpaa neit menmen me mɨtɨk iuwe kɨrak weinɨm. Hɨr ap newetɨwek nan mererim wen au, te hɨrak katɨp mɨtɨk kerek kinɨn kan kar ik: ‘Ti nɨpaa heit menmen marmenum me mɨtɨk iuwe kai?’ ");
INSERT INTO avt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hɨrak ketpɨwek kar ik: ‘Hi nɨpaa heit dram me tɨpar mar 100.’ Mɨtɨk naanmɨpre menmen ketpɨwek, ‘Ehu in ehɨt tɨwei ik ti ewis nɨpaa ti heit 50 dram kerem em.’ ");
INSERT INTO avt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mɨtɨk hak kan hɨrak kitɨwekhi kar ik: ‘Nɨpaa ti heit mekam?’ Hɨrak ketpɨwek, ‘Nɨpaa hi heit 100 bek rais kerem em.’ Hɨrak ketpɨwek, ‘Ti ehu in ehɨt tɨwei ik ewis menmen mɨre 80 bek rais kerem em.’ ");
INSERT INTO avt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Maain mɨtɨk iuwe kɨrak kan katɨp mɨtɨk enuk kɨrak kerek naanmɨpre menmen, hɨrak ketpɨwek hɨrak mɨtɨk enuk weise tɨpar kertei menmen werek werek kari han ke mɨt te maain mɨt ein naanmamrɨwek.” Jisas wen katɨp, “Mɨt ne tɨ ap nises God hɨr ninɨn mɨt nises hɨm me God me naanmɨpre menmen mɨr yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Hi wen hetpi werek. Yi han kitet yayɨt menmen mi eikaap mɨt eiriuwerem te maain yi yayi yaino wit ke God hɨrak kakɨtpi yi yayu yaitikerek yayɨntar yi yɨrɨak menmen yaaim a? Taauye! ");
INSERT INTO avt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Mɨtɨk keimɨn hɨrak naanmɨpre menmen kike werek werek, te maain hɨrak naanmamre menmen wɨsenum werek werek. Te hɨrak mɨtɨk kerek kemipɨn me menmen kike, maain hɨrak kakmipɨn me menmen iuwe. ");
INSERT INTO avt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yi ap naanmɨpre pewek werek werek me tɨ ik e, te keimɨn kakwisi yi naanmamre hɨm yaaim me God? Taauye! ");
INSERT INTO avt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te yi ap naanmɨpre menmen me mɨt han werek werek, te God ap te kakweti menmen kerek yi yaitenenim taau! ");
INSERT INTO avt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Mɨtɨk kɨrɨak menmen me mɨtɨk hak ap te kakrɨak menmen me mɨtɨkɨt wiketeres taau. Te hɨrak han tatwenɨn hak, hak au kakneinɨk. O hɨrak han kekrit keriuwe hak, han ap kekrit keriuwe hak. Yi han ki kakɨnke kakɨntar pewek ap te yi eiyises God werek werek taau.” ");
INSERT INTO avt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mɨt ne Farisi hanhan pewek, hɨr nemtau menmen Jisas ketpim, te hɨr netpɨwek enum nanwesɨsek. ");
INSERT INTO avt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Te Jisas ketpor, “Yi keriyen yɨrɨak menmen yari han ke mɨt yeriuwerem te hɨr han kitet yi yɨre yaain yinɨn mɨt han. Te God kertei han ki. Menmen mɨt han kitet hɨram yaaim, God han kitet hɨram enum weinɨm. ");
INSERT INTO avt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Hɨm me Moses metike hɨm me mɨt profet, hɨram mepu naanmɨpri ere wɨ Jon kerek kɨkɨr mɨt neriuwe tɨpar hɨrak kan kewepyapɨr hɨm ham yaaim me God. Me wɨ eim ere in haiu mewepyapɨr hɨm im yaaim me God naanmamre mɨt. ");
INSERT INTO avt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Maain nepni mamtike tɨ ik mamno mamɨwaank mamɨt. Te hɨm ham kike me hɨm yaaim yapɨrwe Moses nɨpaa kewisɨm ap te mamɨt taau! Mamɨr keremem mamu mamɨt. ");
INSERT INTO avt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mɨtɨk kerek kepɨr mɨte pɨrak kakɨt hap, hɨrak kɨre mɨtɨk enuk kari mɨte his kewenem. Keimɨn keit mɨte nɨpaa wɨnaaiwɨr mɨtɨk kɨre, hɨrak kɨre mɨtɨk enuk kari miyapɨr his kewenem. ");
INSERT INTO avt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nɨpaa mɨtɨk ketenen pewek yapɨrwe kepu. Hɨrak kewɨr pewek yapɨrwe keit klos yaaim iuwe. Hekrit hekrit hɨrak kau werek, keriuwet klos yaaim, kaam menmen yaaim. ");
INSERT INTO avt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mɨtɨk enuk weinɨk niuk mɨrak Lasaras kepu. Hɨrak mɨt nɨrak neriyaak neiyɨk nan newisɨk kɨwaai ya weipɨr ke nɨwa ke wɨnak eik. ");
INSERT INTO avt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Hɨrak kemerɨr mɨt nanɨt menmen mɨt newɨrem nɨpaa mau kɨnaan ke mɨtɨk iuwe hɨram menke. Hɨrak kau en nepere mepnen meswɨwek (o mesiuwewik) wikes meriuwe nin mɨram. ");
INSERT INTO avt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Maain mɨtɨk weinɨk ek kaa, mɨt newisɨk kekre hei te ensel ne God nɨnan hɨmɨn kɨrak ken kau ketike mɨtɨk Ebraham teit wit kɨrak kewik. Mɨtɨk ketenen menmen yapɨrwe kaa, te mɨt newisɨk kekre hei. ");
INSERT INTO avt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mɨtɨk ketenen menmen yapɨrwe hɨrak kekre si enum, menmen merekyɨwek han enuk yɨnk mɨrak mekek. Te hɨrak kɨkɨamnaan kɨr Ebraham keit yanɨmɨn kau niu ein ketike mɨtɨk Lasaras tekiyakɨt tau. ");
INSERT INTO avt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Te hɨrak kɨnap kenɨne, ‘Maam Ebraham, ti han ekiteta esiuwe Lasaras ekwis tɨpar emɨntɨrau nin kai te nɨme wenɨna. Hi au si teknɨna heit wit enuk ik e.’ ");
INSERT INTO avt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Te Ebraham katɨp, ‘Nɨkan, ti han ekitet nɨpaa ti etenen menmen yapɨrwe kerek nɨpaa ti hau tɨ eik, Lasaras hɨrak kau enuk te wikes makɨp, hɨrak kaam menmen enum. In ek hɨrak kau werek werek te ti au enuk yɨnk kitewo. ");
INSERT INTO avt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hi hanhan akepit te menmen mewenɨna. Wi iuwe kau nɨmɨn nɨpaa God kewisɨm kerekirai. Te neimɨn in nanɨno ein taau. Mɨt ein ap te nanrekir wi kerekek nanɨnen nanɨrei taau.’ ");
INSERT INTO avt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mɨtɨk ketenen pewek yapɨrwe katɨp, ‘Hi hituthi ti eriuwet Lasaras kakno wɨnak kerek haai kai nɨpaa kewik. ");
INSERT INTO avt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ti atɨp Lasaras hɨrak kakno kaktɨp kikrek nai hispɨnak (5) hɨrak kakwepyapɨr ekɨtpor hɨr enweikɨn sip enwet menmen enum te hɨr ap anɨnen entikewa enu wit ik kerek hi yɨnk keiyewo heitai.’ ");
INSERT INTO avt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Te Ebraham katɨp, ‘Hɨr netenen hɨm me Moses mau tɨwei metike hɨm mɨt profet newisɨm mau tɨwei. Ewisi hɨr enises hɨm mɨr.’ ");
INSERT INTO avt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mɨtɨk ketenen pewek yapɨrwe katɨp, ‘Au, hɨr ap nanisesim au. Haai Ebraham mɨtɨk hak kerek nɨpaa kaa ti eriuwetek ekno ekɨtpor, te hɨr enweikɨn sip enwet menmen enum.’ ");
INSERT INTO avt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ebraham ketpɨwek, ‘Hɨr ap nanɨmtau hɨm me Moses ketike profet au, te hɨr ap te nanɨmtau hɨm me keimɨn kerek nɨpaa kaa hɨrak pɨke kekrit kakno kakɨtpor taau.’” ");
INSERT INTO avt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas katɨp mɨt nɨrak disaipel, “Menmen enum me mamri han ke mɨt hɨr nisesim mamriwaank, hɨram mamnen. Te keimɨn kakrɨak menmen enum kakri han ke mɨt, maain hɨrak God kakɨwaankek kakɨr ke hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hɨram yaaim te mɨt nankaaip nan keriyɨwek teruk, hɨr nanwɨrek hɨrak kakno kakɨkre wan kaki kakɨt, te hɨrak kakrɨak mɨtɨk kerek kises hɨm mai hɨrak kakweikɨn sip kakises menmen enum. Hɨrak kaku kakrɨak enum, maain hɨrak kaknen kakɨr God hɨrak enuk wɨsenuk. ");
INSERT INTO avt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Yi naanempre hɨras hekrit hekrit yi eiyises menmen yaaim keremem. Kit yinak kerekyut enum ti enerek. Hɨrak yɨnk enuk keriuwe menmen enum hɨrak kerekyutem, hɨrak ketput, ‘Ti yaaik hi herekyut enum,’ te ti hetpɨwek hɨm yaaim mar im: ‘Hɨram menmen weinɨm.’ ");
INSERT INTO avt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hɨrak ke wɨ miutɨp hɨrak kerekyut enum me hispɨnak wik (7), te hɨrak yɨnk enuk keriuwerem, hɨrak pɨke kaknen kakɨtput, ‘Ti yaaik hi herekyut enum,’ te ti etpɨwek, ‘Hɨram menmen weinɨm.’ Hɨrak kɨrɨak karek karek ere hispɨnak wik (7), ti etpɨwek, ‘Hɨram menmen weinɨm,’ ti erɨweksak menmen enum.” ");
INSERT INTO avt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mɨt aposel natɨp Jisas, “Ti ekepai te haiu emisesit emɨrp han tokik.” ");
INSERT INTO avt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jisas katɨp, “Yi eiyises God werek werek kike yi yɨre nu mastet nɨkim hɨram kike te maain hɨram mamwo ere wɨsenum. Yi eiyisesik eiyɨr ek te yi yaitɨp niuwaine ik e, hɨrekes kakɨket kakriuwe puk mɨrak, te hɨrak kakɨmtau hɨm mit kakno kakɨkɨr hɨrekes kakɨkre wan eik kakɨrp kakɨt. ");
INSERT INTO avt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Te keimɨn ke yi mɨt hɨrak ketenen mɨtɨk kerek kɨrɨak menmen mɨrak kɨre kewen tɨ me ni o naanmɨpre sipsip mɨrak. Maain hɨrak kaknaaiwɨr ni kaknen wɨnak ti etpɨwek, ‘Ti enen ehu yeno wasenum ehɨm menmen?’ Hɨrak taau! ");
INSERT INTO avt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Au, ti etpɨwek har ik: ‘Ti emɨr laplap tokim erekyo menmen mai mɨwaai eiyɨm emeriyo ere hi ehɨm menmen, ehɨm tɨpar. Te maain ti ehɨm menmen, ehɨm tɨpar mit.’ ");
INSERT INTO avt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hɨrak katɨp mɨtɨk kerekyɨwek menmen mɨrak, hɨrak yaaik kentar hɨrak kemtau hɨm mɨrak kerek hɨrak ketpɨwek em? Au, hɨram menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yi yar ke mɨtɨk eik kɨrɨak menmen keremem. Yi epei yɨrɨak menmen God ketpiyem yɨrɨakem, yi han ekitetim emɨr im: ‘Haiu mɨt weinɨn keriyen, haiu epei mɨrɨak menmen keremem God ketpeiyem.’” ");
INSERT INTO avt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas kepno Jerusalem kitet yayiwe kewep provins Galili ketike provins Sameria. ");
INSERT INTO avt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hɨrak kare kakno wit kike, mɨt hiswiyen (10) lepro mewi hɨr newenyipɨrek newisɨk yayiwe eik, hɨr nepɨr nenpɨn nekeipnɨwek. ");
INSERT INTO avt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Hɨr nepɨr nenpɨn nekeipnɨwek, hɨr nɨnap nenɨne Jisas netpɨwek, “Jisas Mɨtɨk Iuwe, ti han etwenɨnei.” ");
INSERT INTO avt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas kɨri ketpor, “Yi eino eiteikɨn mɨtɨk pris kerek kewet God menmen keit wɨnak kɨrak, yi eiteiknɨwek yɨnk ki.” Hɨrak ketpor, hɨr nepno, wasenum lepro epei mekeipnor men te yɨnk kɨr kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hɨr nertei hɨr nɨre yaain, mɨtɨk kiutɨp ke mɨt en pɨke kan katɨp hɨm iuwe kewenɨpi niuk me God. ");
INSERT INTO avt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hɨrak kan kenke kɨwaai hɨt me Jisas ketpɨwek, “Ti yaaik.” Hɨrak mɨtɨk ke wit Sameria. ");
INSERT INTO avt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Epei au, Jisas katɨp, “Hi epei hɨkaap mɨt hiswiyen (10) lepro mewi. Mɨt hispɨnak tekyaait (9) neit nein a? ");
INSERT INTO avt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kenmak te mɨtɨk ik ke wit hak hɨrak kerekek pɨke kan kewenɨpi niuk me God? Mɨt ne Isrel au nɨnapen a?” ");
INSERT INTO avt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas ketpɨwek kar ik: “Ti ekrit eno. Ti epei hɨre yaaik hentar ti han kiteta.” ");
INSERT INTO avt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mɨt han ne Farisi nitehi Jisas mewaai meruri wɨ mamnen te God kakinɨn naanmamre mɨt. Hɨrak kewenhi ketpor kar ik: “Mɨt ap nanɨr menmen im me God mamnen au. ");
INSERT INTO avt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ap te mɨtɨk keiyak kaktɨp, ‘Eiyɨr menmen God kɨrɨakem keit in ek o meit ein e.’ Au, hɨram mau ke nɨmɨn ke yi mɨt, te yi ap eiyɨrem eiyɨr ke yi eiyɨr nu o menmen taau.” ");
INSERT INTO avt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hɨrak katɨp mɨt ne Farisi epei au, hɨrak keweikɨn katɨp mɨt nɨrak disaipel keriyen kar ik: “Wɨ mamnen te yi hanhan hi hahu etikewi wɨ miutɨp kerekek mar ke in ek hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hau hetikewi, te maain hi ehu etikewi au. ");
INSERT INTO avt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mɨt han maain nanɨtpi nanɨr ik: ‘Eiyɨrek! Krais pɨke kan.’ o ‘Eiyɨrek in.’ Te yi ap eiyɨtpaan eino eiyɨrek au emɨt! Hɨr nemipɨn. ");
INSERT INTO avt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mɨpre nepni mewenɨn iuwe mɨr merer wit wit mau yaain, mamɨr im e te hi mɨtɨk ke wit ke Mɨtɨk Iuwe me wɨ hi pɨke enen, mɨt yapɨrwe nanɨra hi hahu yaain. ");
INSERT INTO avt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Te hi ehinɨn hahi, mɨt ne tɨ in ek enweikɨn sip enweto. ");
INSERT INTO avt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Maain wɨ hi Mɨtɨk ke wit ke Mɨtɨk Iuwe pɨke anen, menmen mamu mamɨr ke wɨ nɨpaa Noa kau tɨ. ");
INSERT INTO avt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mɨt yapɨrwe nɨpaam menmen nɨpaam tɨpar si enum, haairer nesiuwe nɨkerek hɨram (o hɨran) nɨr te mɨt netike miyapɨr neitan, netenenan his ere wɨ Noa ken kekre sip mɨrak, wan tɨpar kɨniu kenep mɨt hɨr naa ere nenepik o nesi. ");
INSERT INTO avt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wɨ hi pɨke enen hɨram mamɨr ke wɨ nɨpaa Lot kau tɨ. Mɨt ein naam menmen metike tɨpar si enum, hɨr newɨr pewek neiyɨm neit menmen o nesiuwe menmen mɨr neit nan mererim, hɨr namɨr ni me wɨnak, hɨr nime menmen. ");
INSERT INTO avt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Me wɨ Lot kɨnaaiwɨr wit Sodom, God keriuwet si metike nan sisi mɨnɨn enum menep mɨt menepi neit ein. ");
INSERT INTO avt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Me wɨ hi Mɨtɨk ke wit ke Mɨtɨk Iuwe maain hi pɨke enen ewepyapɨr hɨrekes, mɨt nanrɨak menmen hi epei hetpiyem. ");
INSERT INTO avt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Me wɨ eim, keimɨn kentɨr wɨnak siup ap te kakɨkiuwe kaknen kakinɨn kakɨt menmen mɨrak yaaim mekre wɨnak kɨrak au. Hɨrak kakrɨr kerek ek. Mɨtɨk kerek keit ni mɨrak, hɨrak kɨrem, hɨrak ap te kaknen wɨnak kakɨt menmen ekɨt. Hɨrak kakrɨr kerek ek. ");
INSERT INTO avt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yi han ekitet Lot mɨte pɨrak. Hɨre weweikɨn werp wɨr wit Sodom te God kaaup keweikniye hɨre weweikɨn wɨre nan. ");
INSERT INTO avt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mɨtɨk keimɨn hanhan naanmamre hɨrekes, hɨrak ap kises hɨm me God, maain hɨrak kaku kaktike God au. Keimɨn kerek ap hanhan naanmɨpre hɨrekes te maain hɨrak kaki kakɨntar hɨrak kises hɨm mai, God kaktɨwekhis kaku kaktikerek. ");
INSERT INTO avt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Hi hetpi. Me wɨtaan keremem hi pɨke enen, mɨtɨkɨt wiketeret tatwaai yeno miutɨp, kiutɨp hi etɨwekhis kaknen kaktikewa, au kiutɨp kakwaai yeno kakwaai kakɨt. ");
INSERT INTO avt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Miyapɨr wiketeri nehis newen niu. Hap piutɨp hi etɨwehis wawu wautikewa. Hap ep au, wawu wawɨt en.  ");
INSERT INTO avt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mɨtɨkɨt wiketeret tatɨt ni eim. Mɨtɨk hak hi etɨwekhis heiyɨk kaknen, hak au kaku.” ");
INSERT INTO avt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mɨt nɨrak disaipel nemtau menmen im hɨrak ketpor, hɨr nitɨwekhi, “Mɨtɨk Iuwe, menmen im mamɨt nein?” Jisas ketpor tok piksa ik: “Herwe kaa kɨwaairi te hore tepre mamno mamwik mamkinenik mamɨk.” ");
INSERT INTO avt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas katɨp mɨt nɨrak hɨm tok piksa kakɨkepi hɨr enɨrtei te hɨr enitehi God hekrit hekrit, hɨr ap enɨnapen. ");
INSERT INTO avt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hɨrak katɨp kar ik: “Nɨpaa mɨtɨk masistret kau wit hak kiutɨp, hɨrak ap kises God, ap hanhan mɨt au. ");
INSERT INTO avt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mɨte hap weiniye nɨpaa mɨtɨk kɨre kaa hɨre wau wit kiutɨp wetike masistret, hɨre wen wan wɨr masistret ik wetpɨwek war ik: ‘Mɨtɨk hak enuk kan kerekyo enum. Ti ekepa.’ ");
INSERT INTO avt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nɨpaa enum eik masistret ap kekepye ere maain hɨrak han kitet menmen im hɨrak katɨp, ‘Hi ap hɨnapen God au, hi ap hanhan mɨt. ");
INSERT INTO avt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Hi akaap mɨte weiniye hentar hɨm hɨre wetpewem te hɨre ewu werek o au en, hɨre waunen hekrit hekrit te waurekya han enuk eriuwerep.’” ");
INSERT INTO avt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisas wen katɨp, “Yi eiyɨmtau hɨm me mɨtɨk masistret enuk ketpim, yi han ekitetim. ");
INSERT INTO avt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","In ek yi han ekitet God kakɨkaap mɨt nɨrak kakɨmtor hɨm mɨr kerek hɨr nɨnap nanitɨwekhi ekɨkepi wɨtaan wanewik o au? Te hɨrakkakɨkepi waswas o au? ");
INSERT INTO avt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Hi etpi, God kakɨkepi kakɨmtau hɨm mi kakrɨakem wasenum. Te maain hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke enen tɨ, mɨt hɨr han ekiteta nanitehi God menmen nanmeriyo o au?” ");
INSERT INTO avt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisas hɨrak wen katɨp hɨm tok piksa im e me mɨt kerek han kitet hɨras hɨr nɨrɨak menmen yaaim, te nɨnaain han en nɨrɨak menmen enum. ");
INSERT INTO avt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Hɨrak katɨp kar ik: “Mɨtɨkɨt wiketeret tɨniu ten wɨnak iuwe ke God hɨrakɨt titehi God menmen. Hak ke mɨt ne Farisi, hak ke mɨt nari pewek me takis me mɨt. ");
INSERT INTO avt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mɨtɨk ke Farisi kerp hɨrekes kitehi God kar ik: ‘God, hi han yaaik heriuwit hentar hi ap enuk har ke mɨt han au. Hi ap enuk o sampeine hari pewek me mɨt, hises menmen enum o etike mɨte wɨrɨran au. Hi ap har mɨtɨk ik enuk kerek kari pewek me takis me mɨt au. ");
INSERT INTO avt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Me wɨ wik me wik miutɨp miutɨp, hi au hɨt nɨnpɨ hau te hi hituthi menmen. Hi pewek mei man hi ewepim ewetut pɨnam kike, hi ehɨt pɨnam kerek mepeit en.’ ");
INSERT INTO avt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hɨrak katɨp kar ik, te mɨtɨk enuk kari pewek me mɨt me takis, hɨrak keit wɨnak ke God kerp yanɨmɨn, hɨrak ap kɨkɨamnaan men niu wit ke God au. Hɨrak yɨnk enuk kɨwaai his kewen han pank kɨrak katɨp God, ‘Ti hanhan heriuwa. Hi mɨtɨk enuk hɨrɨak menmen enum.’ ");
INSERT INTO avt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisas katɨp, “Hi hetpi, mɨtɨk ik ek enuk kari pewek me mɨt, hɨrak kɨnaaiwɨr wɨnak ke God hɨrak God katɨp hɨrak yaaik. Te mɨtɨk hak eik au. Mɨtɨk kerek han kitet hɨrak yaaik kinɨn mɨt han, God kaktɨp hɨrak weinɨk. Te mɨtɨk kerek hɨrak han kitet hɨrak weinɨk, God kakrekyɨwek kaktɨp hɨrak yaaik iuwe.” ");
INSERT INTO avt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mɨt han neit nɨkerek kike nɨr neri nan Jisas te hɨrak ekwis his emɨnteri ekitehi God naanmamror. Te mɨt disaipel nɨr miye haai nɨr hɨr natɨp neneri nar ik: “Jisas epei kɨkaap mɨt yapɨrwe hɨr nɨnap. Nɨkerek kike hɨr weinɨn. Yi einopɨn!” ");
INSERT INTO avt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Te Jisas kenɨne nɨkerek kike enɨnen enɨrek, hɨrak katɨp mɨt disaipel nɨrak, “Yi eiwisi hɨr enɨnen. Yi ap eiweni eiyɨntar mɨt hɨr nanises hɨm me God hɨr han ekitet God nanɨr ke nɨkerek han kitet hɨm me miye haai netpim. ");
INSERT INTO avt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Hi hetpi werek. Neimɨn ap nises hɨm me God nanwisɨk naanmampri nanɨr ke nɨkerek hɨr nises hɨm me miye haai nɨr, hɨr ap nanɨt menmen God kakwetɨrem taau.” ");
INSERT INTO avt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mɨtɨk kiutɨp ke mɨt iuwe ne Isrel kan kitɨwekhi kar ik: “Mɨtɨk Yaaik kerek ti hertei menmen ewepyapɨrem, hi erɨak mekam te hi ehɨt hɨmɨn yaaik hi ehu etike God tipmain tipmain enum eik?” ");
INSERT INTO avt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas ketpɨwek kar ik: “Henmak te ti etpo hi yaaik? Ti hertei ti atɨp hi hɨre keimɨn te ti atɨp hi yaaik a? Mɨtɨk kiutɨp kekre nɨmɨn ne yi mɨt miyapɨr hɨrak yaaik au. God kiutɨp kerekek. ");
INSERT INTO avt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ti hertei hɨm lo Moses nɨpaa kewisɨm. ‘Yi ap eitike miyapɨr kerek epei neit mɨt yi ap eirɨran au emɨt! Yi ap einep mɨt nani. Yi ap eisawɨn eiyɨt menmen me mɨt han. Yi ap eimipɨn eiwenɨn hɨm mɨtɨk hak. Yi eiyises miye haai ni eiyɨmtau hɨm mɨr.’” ");
INSERT INTO avt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mɨtɨk kerek ketenen menmen yapɨrwe ketpɨwek, “Nɨpaa kerek hi hɨre nɨkan kike ere in ek hi epei hises hɨm me God Moses kewisɨm mau tɨwei.” ");
INSERT INTO avt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas kemtau menmen im, hɨrak ketpɨwek, “Ti wen erɨak menmen ham miutɨp ti ap hisesim. Ti etenen menmen yapɨrwe. Ti eno esiuwe menmen mit ehɨt pewek mamrerim ti ewet mɨt enun weinɨn em. Epei au, ti enen eisɨsa. Ti erɨakem te God kakwetut menmen yaaim mɨrak kakɨt wit kɨrak.” ");
INSERT INTO avt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mɨtɨk ketenen menmen yapɨrwe kemtau hɨm im, hɨrak han enuk kentar hɨrak ketenen menmen yapɨrwe. Hɨrak kɨnapen kakwet mɨt em. ");
INSERT INTO avt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas kɨrek, hɨrak han enuk te hɨrak katɨp, “Amɨrkeik te mɨt netenen menmen yapɨrwe hɨr enwis God kinɨni naanmamri hɨr nises hɨm mɨrak. Taauye! ");
INSERT INTO avt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Miyak kamel (hɨrak kɨre hos) kakno kakitet pewek kɨhi taau. Mɨtɨk kerek wen ketenen menmen yapɨrwe kakno kakises hɨm me God kakwis God kakinɨn naanmamrɨwek taauye!” ");
INSERT INTO avt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Te mɨt nemtau hɨm im, hɨr nitɨwekhi, “Te keimɨn God kaktɨwekhis kaku kaktikerek kaku kakɨt? Taauye!” ");
INSERT INTO avt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas kewenhi ketpor, “Menmen mɨt ap nanrɨakem, hɨram menmen weinɨm God hɨrak kakrɨakem.” ");
INSERT INTO avt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Te Pita katɨp, “Haiu epei mɨnaaiwɨr wit kaiu, menmen maiu misesit.” ");
INSERT INTO avt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas ketpor kar ik: “Hi hetpi im e. Neimɨn nɨnaaiwɨr wit kɨr o nɨnaaiwɨr miyapɨr nɨr o kikrek nɨr o miye haairer o nɨkerek nɨr nentar hɨr nises hɨm me God, ");
INSERT INTO avt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hɨr nanɨt menmen yaaim yapɨrwe me wɨ hɨr nau tɨ ik e. Maain God skelim mɨt, hɨr nanu nanɨt nantikerek tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas keithis mɨt disaipel nɨrak hiswiyen wik (12) keri ken ketpor, “Eiyɨmtau! Haiu mamno wit Jerusalem menmen yapɨrwe mɨt profet nɨpaa newisɨm mau tɨwei me hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Te hɨr nanriuweta hi ano his me mɨt enun ap ne Isrel hɨr nanrekyo enum, nanitɨtonaan, nanɨtpo enum, nanɨnikɨn tɨmank mamnewa. ");
INSERT INTO avt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hɨr naniyep nanriuwe nɨpɨn, hi ano te mɨt nanwenkeka hahu nu tentarakɨt hi hahi. Me wɨ wikak hi pɨke akrit ehu.” ");
INSERT INTO avt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mɨt disaipel ap nertei menmen werek werek au. Te menmen kerek hɨrak ketpim au mɨsawɨn ap meke yaain au. Te hɨr ap nertei menmen werek werek Jisas ketpim au. ");
INSERT INTO avt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas kan menep wit Jeriko, mɨtɨk kerekek nanamɨr toto kau menep yayiwe kenɨne mɨt miyapɨr nanwetɨwek nan te kakɨt menmen kakɨm. ");
INSERT INTO avt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mɨtɨk nanamɨr toto kemtau mɨt yapɨrwe nan nanɨno, hɨrak kitehi mɨt han kar ik: “Mɨt nɨrɨak mekam?” ");
INSERT INTO avt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hɨr netpɨwek, “Jisas ke wit Nasaret kan kesipetit ken.” ");
INSERT INTO avt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hɨr netpɨwek te mɨtɨk nanamɨr toto kɨnap katɨp, “Jisas Nepenyek ke Devit. Ti han etwenɨna.” ");
INSERT INTO avt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Te mɨt kerek ninɨn ek nenerek netpɨwek, “Ekintɨp wɨre wɨre!” Te hɨrak pɨke kɨnap yapɨrwe kenɨne hisiuwe, “Nepenyek ke Devit, ti han ekepai naanmɨprai, te ti han etwenɨna.” ");
INSERT INTO avt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisas kemtewek hɨrak kerp ketpor, “Eiyɨthis mɨtɨk nanamɨr toto eiyɨk einen.” Hɨr neiyɨk nan, hɨrak kan menep, Jisas kitɨwekhi kar ik: ");
INSERT INTO avt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ti hanhan hi erekyut mekam?” Mɨtɨk nanamɨr toto katɨp, “Mɨtɨk Iuwe, hi hanhan nanamɨr kai pɨke eksiupan te hi ahɨr menmen werek werek.” ");
INSERT INTO avt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hɨrak katɨp epei au, Jisas ketpɨwek, “Ti esiupan nanamɨr ehɨr menmen. Ti han ekiteta te hi hekepit ti hɨre yaaik.” ");
INSERT INTO avt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wasenum hɨrak kɨr menmen werek werek kises Jisas kewenɨpi God. Mɨt yapɨrwe nɨrek, hɨr newenɨpi God nentar hɨr han yaaik neriuwerek. ");
INSERT INTO avt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Jisas kepno kitet wit Jeriko kesipatek kepno. Mɨtɨk iuwe niuk mɨrak Sakias hɨrak kepu wit ik. Hɨrak kinɨn naanmɨpre mɨt kerek hɨr nari pewek me mɨt ne takis newet gavman em. Hɨrak ketenen menmen yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mɨtɨk ik hɨrak kare kakɨr Jisas hɨrak keimɨn. Hɨrak mɨtɨk kike yinak te ap kakɨr Jisas kentar mɨt yapɨrwe nerp menep menep nesonɨwek. ");
INSERT INTO avt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Te hɨrak kesiuknen kinɨn mɨt yapɨrwe ken kɨniu nu fik kau niu (hɨrak kɨre tapɨr kup) hɨrak kakɨr Jisas kentar hɨrak kakno kaksipaat nu ik e. ");
INSERT INTO avt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas kan kerp nu ik e kɨkɨamnaan kɨr Sakias ketpɨwek kar ik: “Sakias, ekiuwe wasenum enen. Hi etput, hi petepin atikewit wauno wɨnak kit ek.” ");
INSERT INTO avt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias kekiuwe wasenum kan tɨ, hɨrak han yaaik keriuwe Jisas kekre han kɨrak, hɨrak keriyaak ken wɨnak kɨrak. ");
INSERT INTO avt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hɨr mɨt yapɨrwe nɨrek, hɨr natɨpan nɨnan yipɨr newɨrek hɨr natɨp nar ik: “Jisas kakno wɨnak ke mɨtɨk enuk kɨrɨak menmen enum.” ");
INSERT INTO avt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Maain keit wɨnak eik, Sakias kekrit kerp katɨp Jisas, “Mɨtɨk Iuwe emtau! Hi ewet pewek o menmen mai pɨnam mamno mɨt enun winen menmen auri. Te hi nɨpaa emipɨn mɨt han ekinortɨp pewek mɨr, hi pɨke ewetɨrem mamrer mɨr kerek nɨpaa hi etɨwem miutɨp, hi ewetɨrem tekyaait.” ");
INSERT INTO avt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisas katɨp te mɨt nau en nemtewek. Hɨrak katɨp kar ik: “Petepin mɨtɨk ik epei keweikɨn sip kewet menmen enum. Hɨrak hɨrekes nepenyek ke Ebraham kentar in ek hɨrak kises God werek werek. Hɨrak kises God werek werek kentar ");
INSERT INTO avt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, hi han te hi hɨnhatɨn mɨt hɨr newaank hɨras nar mɨtɨk ik, te hi ekepi etorhis.” ");
INSERT INTO avt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas katɨp hɨm tok piksa men mɨt kerek nemtewek katɨp Sakias menmen. Hɨrak katɨp hɨm im kentar in ek hɨrak epei menep kakiun wit Jerusalem kaki. Te hɨr mɨt han kitet natɨp epei menep te God kaknen kakriuwe menmen mɨrak iuwe yaaim kakinɨn naanmamre mɨt. ");
INSERT INTO avt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Te Jisas katɨp kar ik: “Nɨpaa mɨtɨk hak iuwe kepu. Hɨrak kakno wit hak keit yanɨmɨn te mɨt han nanwisɨk kakre iuwe naanmamre mɨt neit ein. Maain hɨrak pɨke kaknen wit kɨrak ik. ");
INSERT INTO avt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Menep hɨrak kakno, hɨrak kenɨne mɨt hiswiyen (10) nekepik nɨrɨak menmen mɨrak, hɨr nan. Hɨr nan, hɨrak kewtɨr pewek mar 20 kina miutɨp miutɨp. Epei au, hɨrak ketpor, ‘Eiyɨmtau menmen. Yi yayɨt pewek im em, hɨram mamri meiyam mamkiterem mamwaai ere iuwe, te hi pɨke anen.’ ");
INSERT INTO avt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“In ek, mɨt han ne wit kɨrak, hɨr nɨneinɨk te hɨr nesiuwe mɨt han nɨkaru nen natɨp nar ik: ‘Haiu mɨnapen mɨtɨk ik kakre iuwe naanmamrai.’ ");
INSERT INTO avt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Maain mɨtɨk iuwe epei naanmɨpre mɨt pɨke kan, wasenum hɨrak kenɨne mɨt kerek nɨrɨak menmen mɨrak em kerek nɨpaa neit pewek, hɨrak keriyeiri hɨr nan nerp ninaan mɨrak, hɨrak kitorhi me pewek nɨpaa hɨrak kewetɨrem, te hɨr neit pewek meiyam mamtikerem o au. ");
INSERT INTO avt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mɨtɨk hak kiutɨp kinɨn kan katɨp, ‘Mɨtɨk iuwe, me pewek nɨpaa ti ewetewem mar 20 kina, hɨram mari ham mɨre 200 kina.’ ");
INSERT INTO avt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mɨtɨk iuwe ketpɨwek kar ik: ‘Ti yaaik, ti mɨtɨk erekyau menmen mai yaaim. Ti yaaik naanmɨprau menmen kike mar im werek, te hi ewisit naanmamre wit iuwe mar hiswiyen (10) im e.’ ");
INSERT INTO avt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Hɨrak epei ken, mɨtɨk hak kerek kɨrɨak menmen mɨrak ek kan katɨp, ‘Mɨtɨk iuwe, me pewek nɨpaa ti ewetewem mar 20 kina, hɨram mari ham mɨre 100 kina.’ ");
INSERT INTO avt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hɨrak katɨp epei au, mɨtɨk iuwe king katɨp me mɨtɨk ik kar ik: ‘Ti naanmamre wit mar hispɨnak (5).’ ");
INSERT INTO avt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Hɨrak epei ken, mɨtɨk hak kɨrɨak menmen mɨrak kan katɨp, ‘Mɨtɨk iuwe, im em hɨram pewek mit nɨpaa ti ewetewem. Hi hɨsawɨnem mekre wa hɨtɨn. ");
INSERT INTO avt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Hi hɨneinit hentar ti menmen kerek mɨt han nimaam. Ti ewenkek menmen kerek nɨpaa ti ap emɨr em au, mɨt han namɨr.’ ");
INSERT INTO avt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mɨtɨk iuwe king ketpɨwek, ‘Ti mɨtɨk erɨak menmen mai, ti enuk! Hi pɨke ehɨt hɨm mit ti etpim me hi, hi pɨke enit eriuwerem. Ti hertei hi mɨtɨk enuk atɨp hɨm tokik tokik ari menmen ap mai ewenkek menmen kerek hi ap epei hamɨr au mɨt han. ");
INSERT INTO avt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Henmak te ti ap ewisa pewek mei mekre benk? Te hi ehɨt meiyam kike weinɨm mamtikerem wɨ kerek hi pɨke han in a?’ ");
INSERT INTO avt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Te mɨtɨk iuwe king katɨp mɨt kerek nerp ein en, ‘Eiyɨt pewek emkeipnɨwek eiwɨrem te yi eiwet mɨtɨk hak kerek ketenen 200 kina eiwetɨwekem.’ ");
INSERT INTO avt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Hɨr netpɨwek, ‘Mɨtɨk iuwe mɨtɨk eik epei ketenen 200 kina, ekɨt.’ ");
INSERT INTO avt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Mɨtɨk iuwe katɨp kar ik: ‘Hi etpi mɨt kerek netenen menmen hɨram yapɨrwe, te maain hɨrak mɨtɨk iuwe kakwetɨr meiyaam. Te mɨt kerek ap netenen menmen yapɨrwe au, menmen kike kerek hɨr netenenim, mɨtɨk iuwe kaktɨwem mamkeipnor. ");
INSERT INTO avt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","In ek mɨt nai nepan nɨnaain hi hɨre mɨtɨk iuwe naanmamror, yi eitorhis einen in yi einɨp te hi ahɨri.’” ");
INSERT INTO avt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas katɨp hɨm im epei au, hɨrak kinɨn kɨniu kakno wit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hɨrak kan menep ke wit Betfasi ketike wit Betani keit mɨniu (o neiyɨp) niuk mɨrak oliv. Epei au, Jisas keriuwet mɨtɨkɨt disaipel wik tɨniu ten. ");
INSERT INTO avt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hɨrak ketpɨwekɨt kar ik: “Yi eino wit eik yi eiyɨr donki nɨkik (hɨrak kɨre hos) mɨt nekeipɨk kerp kerek mɨt niutɨp niutɨp ap nɨpaa newik wen au. Yi eisiupanek eiriyaak eiyɨk einen in e. ");
INSERT INTO avt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te mɨt han nanitihi, ‘Yi yenmak te yi yesiupan ek,’ te yi eiyɨtpor, ‘Mɨtɨk iuwe hanhan kaktɨwek.’” ");
INSERT INTO avt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hɨrakɨt ten ten ere tɨnapɨn menmen mar ke Jisas nɨpaa ketpɨwekɨtem. ");
INSERT INTO avt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tɨnapɨnek o, hɨrakɨt wen tesiupan hos, mɨt kerek naanmɨpre hos netpɨwekɨt, “Yi yenmak te yi yesiupanek?” ");
INSERT INTO avt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hɨrakɨt tatɨp, “Mɨtɨk iuwe kawɨr kakwik.” ");
INSERT INTO avt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hɨr newenhi te hɨrakɨt tari hos eik teiyɨk ten Jisas, hɨr yapɨrwe newɨr saket (hɨram mɨre laplap) mentar hos sip kɨrak, te hɨr nekin Jisas newisɨk kewik. ");
INSERT INTO avt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisas kewik kepno, hɨr mɨt nepno netikerek nenepep saket newisɨm minɨn mɨwaai yayiwe neteikɨn hɨr newenɨpiyek han yaaik neriuwerek. ");
INSERT INTO avt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jisas kan menep wit Jerusalem kerek yayiwe kiun wank kekiuwe ken mɨniu Oliv ek, mɨt disaipel nɨrak yapɨrwe nererik menep menep hɨr han yaaik newenɨpi God nine henye newep hɨm iuwe nentar menmen yaaim hɨr epei nɨr Jisas kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hɨr natɨp nar ik: “God naanmamre Mɨtɨk Iuwe kerek naanmamre haiu mɨt, hɨrak kakɨkrehɨr God. God hanhan keriuwai haiu mɨt. God hɨrak kakɨt niuk iuwe.” ");
INSERT INTO avt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Te mɨt han ne Farisi kerek naanmɨpre hɨm me Moses nekre mɨt yapɨrwe en natɨp Jisas, “Mɨtɨk Iuwe, ti atɨp mɨt disaipel nit wɨre wɨre nentar hɨr natɨp God keriuwetit te ti han tɨ ik. Hɨram enum.” ");
INSERT INTO avt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisas kewenhi ketpor, “Hi etpi, hɨr nekintɨp wɨre wɨre, nan hɨremes kerek mɨwaai yayiwe mamnap mamtɨp mamwenɨpi niuk mai.” ");
INSERT INTO avt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas epei kan menep wit Jerusalem, hɨrak kɨrek, hɨrak kɨkɨt mɨt nau wit eik. ");
INSERT INTO avt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hɨrak katɨp, “Hi hanhan te yi mɨt petepin yertei menmen eitɨwem me yi eiyu werek werek, te in ek yi ap yerteiyem taau. ");
INSERT INTO avt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Maain wɨ mamnen te mɨt ni enun nepan nanɨnen nanweikni hɨr naniyepeti mɨt nanɨnke yinan hesini nanɨnke yinan hasini. ");
INSERT INTO avt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Te hɨr nanɨnen naniwep yi mɨt miyapɨr nanɨwaank wit ki. Ap te nan mei miutɨp mamu kerek nɨpaa mepu ek taau. Menmen im mamnen mamɨntar yi ap yertei wɨ God kan te kakɨkepi.” ");
INSERT INTO avt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Maain wɨ ham Jisas ken wɨnak iuwe kerek mɨt nererik natɨp hɨm me God neitai en, hɨrak kene mɨt kerek nesiuwe menmen mɨre sipsip o hore menmen ham mɨt namɨp nanwet God em, hɨrak kepɨri nen. ");
INSERT INTO avt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hɨrak ketpor kar ik: “Hɨm nɨpaa God ketpim mɨt newisɨm mau tɨwei mar im: ‘Wɨnak kai mɨt netpim hɨrak ke hɨr nanɨno nanitehi God menmen naneitak.’ Te yi yeweiknɨk kɨre wɨnak ke mɨt enun nekintɨp menmen newik.” ");
INSERT INTO avt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Epei au, hekrit hekrit Jisas katɨp mɨt miyapɨr hɨm mɨrak keit wɨnak iuwe ke God kerek ek. Te mɨt iuwe pris newet God menmen me mɨt, hɨr netike mɨt ne Skraip kerek natɨp mɨt miyapɨr hɨm me Moses, hɨr netike mɨt iuwe ninɨn mɨt, hɨr nimenɨpɨn Jisas hanhan nankɨp kaki. ");
INSERT INTO avt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Te hɨr ap nɨrɨakem au nentar hɨr mɨt yapɨrwe nemtau hɨm mɨrak ap te nanɨnaaiwɨr hɨm meiyam miutɨp au. Hɨr hanhan netikerek neit wɨnak iuwe ke God eik. ");
INSERT INTO avt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wɨ ham, kerek Jisas kepeit wɨnak iuwe ke God keit Jerusalem kerekek, hɨrak katɨp mɨt miyapɨr hɨm yaaim me God, mɨt han pris iuwe kerek newet God menmen me mɨt, hɨr netike mɨt ne Skraip kerek natɨp mɨt miyapɨr hɨm me Moses, hɨr netike mɨt iuwe hɨr naanmɨpre mɨt ne Isrel hɨr nan. ");
INSERT INTO avt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hɨr nan hɨr nitɨwekhi, “Ti etpai, keimɨn kehimɨtenit te ti han hɨrɨak menmen im? Keimɨn ketput hɨram yaaim te ti hɨrɨakem?” ");
INSERT INTO avt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisas kewenhi ketpor, “In ek hi hitihi yi eiyɨtpewem. ");
INSERT INTO avt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mɨtɨk Jon, God keriuwetek kan hɨrak kɨkɨr mɨt neriuwe tɨpar ketpor hɨr enweikɨn sip enwet menmen enum o Jon hɨrekes han kitetim kɨrɨakem?” ");
INSERT INTO avt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hɨr natɨpan han kitetim mar im: “Haiu mamtɨp me God, te hɨrak kaktɨp, ‘Hɨram meke God man te yi yenmak ap yises hɨm me Jon?’ ");
INSERT INTO avt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te haiu mamtɨp Jon hɨrekes han kitetim kɨrɨakem, mɨt yapɨrwe in en nanwɨr nan nanwep nanɨntar hɨr han kitet Jon hɨrak profet, God keriuwetek kan kewepyapɨr hɨm mɨrak.” ");
INSERT INTO avt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Te hɨr newenhi natɨp Jisas nar ik: “Haiu ap mertei menmen Jon ketpim meke nein man?” ");
INSERT INTO avt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Te Jisas ketpor, “Mar keremem te hi ap hetpi keimɨn keriuweta hi hɨrɨak menmen.” ");
INSERT INTO avt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hɨrak ketpor epei au, Jisas katɨp mɨt hɨm tok piksa im: “Mɨtɨk kiutɨp kamɨr wain nɨkim mau ni kewis mɨt han naanmɨprewem. Maain hɨr nanɨt ham, hɨrak kakɨt ham. Epei au, hɨrak kɨnaaiwɨr wit kɨrak ken kakɨt wit hak ere maain tito yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Me wɨ kerek hɨr nanɨt waai nɨkim mewɨnki kerem em, hɨrak keriuwet mɨtɨk kerek kɨrɨak menmen mɨrak kakno kakɨr mɨt kerek naanmɨprewem, hɨr enwetɨwek ham pɨnam. Te mɨt kerek naanmɨpre ni keremem nakɨp nenipek yɨnk enuk nesiuwerek kan ap ketenen menmen mei au. ");
INSERT INTO avt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Maain hɨrak pɨke keriuwet mɨtɨk hak ken te mɨt naanmɨpre ni keremem hɨr nakɨp nenipek yɨnk enuk nesiuwerek pɨke kan ap ketenen menmen mei au. ");
INSERT INTO avt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hɨrak pɨke kan ap ketenen menmen au, hɨrak keriuwet wok mɨtɨk hak kepno, te mɨt naanmɨpre ni hɨr nakɨp kaa hɨr newɨrek kenpɨn. ");
INSERT INTO avt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hɨr newɨrek kenpɨn, mɨtɨk ke ni hɨrekes katɨp, ‘Hi arɨak mekam te hi ehɨt menmen mai pɨnam? Hi hertei. Hi esiuwe nɨkan kai nɨpaa hi hinaak kiutɨp kerek ek. Hɨrak ekno te hɨr han ekitetik enwetɨwek menmen.’ ");
INSERT INTO avt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hɨrak keriuwetek ken ni eim, te mɨt kerek naanmɨprewem nɨrek hɨr natɨpan, ‘Ik ek hɨrak nɨkan kɨrak hɨrekes kerek ek. Haiu emkɨp te haiu mamɨt ni me waai wain hɨram maiu.’ ");
INSERT INTO avt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Te hɨr nepɨrek kaknopɨn ni me waai nɨkim kerem em, hɨr nakɨp. Mɨtɨk hɨrekes ke ni keremem ekrɨak mekam me mɨt naanmɨpre ni mɨrak? ");
INSERT INTO avt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hi hetpi hɨrak eknen eknep mɨt kerek naanmɨpre ni eim, hɨrak pɨke ekwet han em naanmɨpre ni me waai keremem.” Mɨt hɨr nemtau hɨm im hɨr natɨp, “Taau! Emɨt! Mɨt kerek naanmɨpre ni ap te nanrɨak enum marim auye!” ");
INSERT INTO avt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas kɨri ketpor kitorhi kar ik: “Menmen im ap te mamnen taau, kenmak hɨm me God mau tɨwei matɨp mar im: ‘Teinɨk kerek nɨpaa mɨt kerek nime wɨnak ek nɨneinɨk nenkerek newisɨk kɨwaai?’ ");
INSERT INTO avt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mɨt neimɨn niutɨp niutɨp kerek neweikɨn sip neweto hɨr nar ke mɨt hɨr nerewo teinɨk ek hɨrak kakrenirɨr kike kike nanriwaank. Teinɨk kakɨnke kakɨntar neimɨn hɨrak kaksesi tɨkip tɨkip mamre niutɨp. (Hi kerekek hɨre teinɨk ik. Keimɨn ap kises hɨm mai kakɨwaank hɨrekes.)” ");
INSERT INTO avt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mɨt hɨr natɨp mɨt miyapɨr hɨm me Moses netike mɨt iuwe pris kerek ninɨn mɨt han, hɨr hanhan in ek nanɨthis Jisas nankɨp nentar hɨrak katɨp mɨt hɨm weinɨm tok piksa me hɨr mɨt iuwe keriyen. Te hɨr nɨnapen mɨt miyapɨr yapɨrwe nererik menep menep, te hɨr netɨwekhis nanɨp au. ");
INSERT INTO avt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Te hɨr nemerɨr wɨ te nantɨwekhis. Hɨr nehimɨtan mɨt enun nemipɨn hɨr nɨre yaain te hɨr nanɨnen nanmipɨn Jisas nanitɨwekhi menmen te hɨr nanwisɨk kakno his me mɨtɨk iuwe Gavman ke Rom. ");
INSERT INTO avt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hɨr nan natɨp Jisas, “Kaiu Iuwe, haiu mertei menmen ti etpim ewepyapɨrem hɨram yaaim. Haiu mertei ti ap hɨnaain mɨt iuwe o mɨt neimɨn weinɨn. Hɨram menmen weinɨm ti etpor hɨm yaaim me God keremem. ");
INSERT INTO avt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ti etpei hɨram yaaim werek te haiu emwet mɨtɨk iuwe naanmɨpre mɨt ne Rom netikewei pewek me takis o au?” ");
INSERT INTO avt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Te Jisas kertei kekre han kɨrak hɨr nemipɨn te hɨrak ketpor, “Yi yenmak te yi yitauhiyem a? ");
INSERT INTO avt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Yi eiteikno pewek kei kiutɨp. Hɨmɨn metike niuk me keimɨn im em?” Hɨr newenhi, “Mɨtɨk iuwe Sisa kerek naanmɨpre mɨt ne Rom ek.” ");
INSERT INTO avt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Te Jisas katɨp, “Yi eiwet mɨtɨk iuwe naanmɨpre mɨt ne Rom menmen lo metpim. Te yi eiwet God menmen hɨm me Moses keremem metpim.” ");
INSERT INTO avt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hɨr ap nemtau hɨm mei enum hɨrak ketpim te hɨr nanriyaak me nanamɨr me mɨt neiyɨk nanɨno au. Te hɨr nekintɨp wɨre wɨre neit, hɨr han kekrit neriuwe hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mɨt han pris hɨr nises hɨm me Sadyusi, hɨr nan Jisas. Hɨr keriyen han kitet mɨt epei naa ap te pɨke nanɨkrit taau. Hɨr nitɨwekhi nar ik: ");
INSERT INTO avt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mɨtɨk Iuwe, mɨtɨk Moses kewisai hɨm lo im em: ‘Mɨtɨk kaa kɨnaaiwɨr mɨte pɨrak te nɨkerek au, mɨtɨk kerekek nɨkik o heiyiuwe kɨrak ekɨt mɨte pɨrak weiniye kerepep te hɨre pɨke ewine nɨkerek enɨkrehɨr ke mɨtɨk nɨpaa kaa ek e.’ ");
INSERT INTO avt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nɨpaa mɨtɨk ketike kikrek nɨrak hispɨnak kiutɨp (6) ne haai kiutɨp hɨr nepu. Heiyiuwe kɨr keit mɨte. Maain hɨrak kaa, te hɨrak ap epei kine nɨkerek nei wen au. ");
INSERT INTO avt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Te nɨkik kɨrak kerek nɨmɨnek ek ketɨwe te hɨrak kaa ap epei kine nɨkerek au. ");
INSERT INTO avt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nɨmnek ketɨwe te menmen mar im me hɨrakɨt hispɨnak wik (7), hɨr naa te ap hɨr nine nɨkerek nei au. ");
INSERT INTO avt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","33","Hɨr naa, maain mɨte hɨre waa. Maain wɨ God kakɨkɨan mɨt nanɨkrit, mɨte ip e pe mɨtɨk keimɨn ke mɨt hispɨnak wik (7)?” ");
INSERT INTO avt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hɨr nitɨwekhi epei au, Jisas kewenhi ketpor, “Mɨt miyapɨr in ek hɨr neitan. Haairer ne miyapɨr nɨhan hɨram, hɨr nesiuwe nɨkerek nɨr nanɨno nanɨt pewek nanmereyi. ");
INSERT INTO avt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Te mɨt netike miyapɨr kerek hɨr yaain en nentar hɨr newis God naanmɨpri, hɨr nani te maain God kakɨkɨan hɨr nanɨkrit nanu te maain hɨr ap pɨke nanɨtan taau. ");
INSERT INTO avt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Hɨr nanɨre mɨt ensel nentar hɨr ap te nani au. Hɨr nanu nanre nɨkerek ne God nanɨntar hɨr naa hɨr pɨke nanɨkrit. ");
INSERT INTO avt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mɨtɨk Moses katɨp keteiknai werek werek kerek mɨt naa maain nanɨkrit nanu. Hɨm me God mau tɨwei Moses kewisɨm matɨp menmen me wɨ hɨrak kɨr si taak nu ap kaa au, hɨrak katɨp ke Mɨtɨk Iuwe, ‘Hɨrak God ke Ebraham, God ke mɨtɨk Aisak, mɨtɨk Jekop kerek nɨpaa enum eik nepu.’ ");
INSERT INTO avt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Menmen im meteiknai hɨrak God ke mɨt hɨr naa au. Hɨr nepu. Haiu mɨt in han kitet mɨt epei naa, te God katɨp au hɨr hɨmɨn kɨr kepu. Hɨr nɨnaaiwɨr yɨnk kɨr kaa kerekek te nanɨt yɨnk hak yaaik.” ");
INSERT INTO avt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mɨt han ne Skraip kerek newepyapɨr hɨm me Moses newenhi natɨp, “Mɨtɨk Iuwe, ti epei atɨp werek.” ");
INSERT INTO avt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hɨr yɨnk enuk nɨnaain nanitehi Jisas menmen meiyam au. ");
INSERT INTO avt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisas ketpor, “Nenmak mɨt kerek natɨp mɨt miyapɨr hɨm me Moses natɨp Mɨtɨk Krais kerek God kehimɨtanek hɨrak nepenyek ke Devit kerekek a? ");
INSERT INTO avt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hɨrak nepenyek kɨrak kerekek au kentar Devit hɨrekes katɨp mau tɨwei Sam kar ik: ‘God hɨrak katɨp Mɨtɨk Iuwe kai: Ti ehu etikewa har ke mɨt iuwe, ");
INSERT INTO avt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ere maain hi enep mɨt nit enun nepan epei au nesi.’ ");
INSERT INTO avt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit kene nepenyek kɨrak “Mɨtɨk Iuwe kai.” Markeik te Mɨtɨk Iuwe God kehimɨtanek kaknen kakɨkaap mɨt hɨrak kakre nepenyek ke Devit kerekek a?” Jisas katɨp menmen im keteikɨn mɨt hɨrak kɨre God. ");
INSERT INTO avt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mɨt yapɨrwe nererik nemtewek, Jisas katɨp mɨt nɨrak disaipel menmen im: ");
INSERT INTO avt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Yi naanmamre hɨras me mɨt iuwe newepyapɨr hɨm me Moses. Hɨr nanɨno ein ein neweikɨn laplap saket nokik kerek meteikɨn mɨt hɨr nises God, hɨr han yaaik nantɨpan neiyewowan nanɨrp wit maket kerek mɨt nererik nesiuwe menmen. Hɨr hanhan nanu yeno mɨt nehimɨtanem me mɨt iuwe neit wɨnak kerek mɨt nererik nekine hɨm me Moses, o wɨnak mɨt nererik naam menmen neriuwe mɨt han. ");
INSERT INTO avt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hɨr hanhan nɨsawɨn nanri menmen, wɨnak o tɨ me miyapɨr mɨt nɨr epei naa nesiupani. Hɨr epei nari menmen, te hɨr nanɨno wɨnak ke God hɨr nemipɨn nitehi God menmen neteikɨn mɨt yapɨrwe hɨr yaain. Maain God kakɨwaanki wɨsenum nanɨntar hɨr nemipɨn nɨrɨak enum.” ");
INSERT INTO avt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas kerenaan kɨr mɨt netenen menmen yapɨrwe hɨr newɨr pewek yapɨrwe mekre tɨkenup mɨwaai wɨnak iuwe ke God. ");
INSERT INTO avt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Hɨr newɨrem, Jisas kau kɨr mɨte weiniye nɨpaa mɨtɨk kɨre kaa hɨre wewɨr pewek kike wik mepno mekre tɨkenup kerekek. ");
INSERT INTO avt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hɨre wewɨrem epei au, Jisas katɨp, “Hi hetpi, mɨte weiniye ip e nɨpaa mɨtɨk kɨre kaa, hɨre wewɨr pewek mekre tɨkenup hɨram minɨn mɨt han. ");
INSERT INTO avt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mɨt han en hɨr newis ham kerek epei nenkerem men, pɨnam au meit, te hɨr newet God em. Te hɨre wetenen pewek mei yapɨrwe au, te hɨre wewisɨm wenepim kerek hɨre wetenenim me weiyɨm wawɨm menmen.” ");
INSERT INTO avt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mɨt han hɨr natɨp menmen me wɨnak iuwe ke God hɨrak yaaik nan yaaim mɨre teinɨk mɨt newen ninaan mewik, menmen ham yaaim mɨt newisɨm neiyɨm neses wɨnak neriuwerem. Te Jisas ketpor, ");
INSERT INTO avt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Hɨram menmen im yi yɨrem, maain wɨ mamnen te ap nan kei kiutɨp kaku taau, te menmen meiyam miutɨp miutɨp mamu mamɨntereram taau. Mɨt nanwɨrem mamno tɨ heriyai heriyai.” ");
INSERT INTO avt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hɨr mɨt en nitɨwekhi nar ik: “Mɨtɨk Iuwe, me wɨ mekam te menmen im mamnen? Menmen mekam mamnen mamteiknei wɨ epei menep te menmen im mamnen?” ");
INSERT INTO avt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisas ketpor, “Yi naanmamre hɨras te mɨt ap nanmitipɨn. Mɨt yapɨrwe nanɨnen nanɨkrehɨr kai, hi Mɨtɨk God kehimɨtana hi akaap mɨt. Hɨr niutɨp niutɨp nanɨnen nantɨp, ‘Hi epei han,’ o ‘Wɨ epei man menep te tɨ kakɨwaank kakɨt.’ Yi eiyɨmtau hɨm im eiyisesim au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Maain yi eiyɨmtau mɨt nanɨnepan wɨsenum yi ap einapen eipɨrpɨr au emɨt! Menmen ham yapɨrwe maminɨn mamnen keremem te wɨ eik enum epei man menep wen au.” ");
INSERT INTO avt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jisas wen katɨp, “Mɨt ne wit hak iuwe kiutɨp nantike mɨt han ne wit hak iuwe nanɨnepan, gavman han nantike gavman han nanɨnepan. ");
INSERT INTO avt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Menmen enum mamnen tɨ. Tɨ kaktanɨk kakrer wit wit, hawɨ au, te menmen mamwo au. Mɨt miyapɨr nɨnpɨ mamɨn. Menmen enum mamɨkrit mamnen te yi yainap. Menmen enum mamtike menmen ham iuwe me nepni mamɨr te yi yayɨrem. ");
INSERT INTO avt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Menmen im maain mamnen te im minɨn mamnen. Mɨt hɨr nanwepiyapɨr me menmen yi yɨrɨakem, nanrekyi enum te nanɨswi yi yaino mɨt kerek naanmɨpre wɨnak kerek mɨt nekine hɨm me Moses, o mɨt iuwe, o gavman te hɨr nanriwaank yaino wɨnak enuk yaiyɨntar yi yises hɨm mai. ");
INSERT INTO avt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Im em hɨram wɨ yaaim te yi eiwepyapɨr hɨm yaaim me God. ");
INSERT INTO avt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yi ap eiyinɨn han ekitet menmen yi eitɨp mɨt iuwe em naanmampre hɨras au emɨt! Yi ap eirɨakem eiyɨntar ");
INSERT INTO avt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","hi eweti hɨm mai yaaim yi yaiyɨrtei menmen werek werek te mɨt kerek hɨr nepan ni en ap te nanwepiyapɨr nanweni hɨm me ninaan me gavman ke menmen yi yetpim. ");
INSERT INTO avt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Mɨt enun nantike miye haai ni, o kikrek ni, yenterer ni, o ni yinan, hɨr nanriuweti yaino mɨt enun nepan, hɨr naniwep yi mɨt neiyan. ");
INSERT INTO avt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mɨt yapɨrwe nanɨneini nanɨntar yi yises hɨm mai. ");
INSERT INTO avt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Te God naanmamre hɨmɨn ki yi eiyu werek werek. ");
INSERT INTO avt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yi han tokik eiyu eiyises hɨm mai te mɨt naniwep yi yayi, maain hɨmɨn ki kaku werek werek yi yayu yaitikewa. ");
INSERT INTO avt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Maain wɨ kerek yi eiyɨr mɨt ne ami enun nepan nanɨnen nanweikɨn wit Jerusalem, te yi eiyɨrtei wɨ epei man menep te mɨt nanɨwaankek. ");
INSERT INTO avt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Te neimɨn nau provins Judia enrɨr enɨno mɨniu (o neiyɨp) enu enɨt en. Neimɨn kerek nau wit Jerusalem hɨr enɨno enɨnopɨn. Neimɨn kerek nerer wit wit kɨrapɨt menep Jerusalem ap pɨke enɨnen wit kɨr iuwe ek enu enɨt en au emɨt! ");
INSERT INTO avt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wɨ im hɨram wɨ God kakrɨak mɨt enum kakɨntar menmen enum hɨr nɨrɨakem mar ke nɨpaa hɨm me God mau tɨwei metpim mamnen. ");
INSERT INTO avt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Maain me wɨ im hɨr miyapɨr nanine nɨkerek hɨr han enuk, hɨr nantike miyapɨr nɨnan nɨkerek kike newetɨr nɨm nanɨntar hɨr ap nanrɨr waswas au. Menmen im enum mamnen mamɨwaanki. Menmen enum mamnen mɨt nanu tɨ ik e, God kakrɨak mɨt ne Isrel enum enum. ");
INSERT INTO avt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mɨt han hɨr mɨt enun nanɨnɨp nanriuwe hɨne me his, hɨr nantorhis nanriyei nanɨno nanrer wit wit nanrɨak menmen me mɨt han. Te mɨt kerek hɨr ap ne weiwɨk me Isrel au, nanu wit Jerusalem naanmamrɨwek ere wɨ kerek God kewis mɨt nanweikɨn sip nanwet menmen enum hɨram epei au. ");
INSERT INTO avt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Maain menmen yapɨrwe mamu nepni mamɨr im: Hɨram wepni, hɨr, wenke mamweikɨnhis mamre menmen ham, mɨt nanrer wit wit han toenuk nanɨnapen nanɨmtau wan sɨr mewenɨn wan kakniu. ");
INSERT INTO avt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mɨt yapɨrwe nanɨr menmen im han kakitet menmen meiyam enum mamnen tɨ ik te hɨr han toenuk nanpɨrpɨr nanɨnkewɨn nanwaai nanɨnatɨn. Menmen iuwe mau nepni mamɨnke mamnaaiwɨr wit mɨr mamnen in, mamno ein. ");
INSERT INTO avt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Te in ek yi eiyɨr hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi anen akre napɨ etike menmen mai iuwe mamtike menmen mai yaaim mamrehɨhe. ");
INSERT INTO avt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Menmen im enum mamɨkrit mamnen, yi han ekitet hi Mɨtɨk Iuwe menep hi anen akepi etihis, te yi ap einaain au emɨt! Yi han yaaik eiyu eiyɨt.” ");
INSERT INTO avt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hɨrak ketpor epei au, Jisas ketpor hɨm tok piksa ham im: “Yi han ekitet nu fik kerek hɨrak kɨre nu hamis ketike nu ham. ");
INSERT INTO avt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wɨ yi eiyɨr nu heneik mɨram mamɨnsiunen, yi eitɨp, ‘Wepni yaaik epei te kaknen.’ ");
INSERT INTO avt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mar im yi yayɨr menmen im me nepni o wan hɨram mamnen mamɨr ke hi epei hetpiyem, te yi eiyɨrtei God menep te kaknen naanmamre mɨt miyapɨr ne tɨ. ");
INSERT INTO avt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Hi hetpi werek. Mɨt nau tɨ in ek ap nani ere wɨ mamnen te menmen yapɨrwe hi hetpim mar im hɨram mamɨkrit mamnen. ");
INSERT INTO avt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maain nepni mamtike tɨ ik mamɨwaank mamɨt te hɨm mai taau, mamu mamɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Yi naanmamre hɨras ap han ekitet yayɨm menmen yapɨrwe, tɨpar si enum, o menmen me tɨ, ni mi o sak o menmen im au emɨt! Hekrit hekrit yi han ekite eirɨak menmen im keremem te wɨ hi Krais pɨke enen, yi ap yemeriya werek werek au. Wɨ im mamnen mamwepyapɨr mɨt yapɨrwe nau tɨ nerer wit wit hɨr ap nises God nanɨr ke miyak ketari tɨrpe kakɨkɨp. ");
INSERT INTO avt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Naanmamre hɨras eiyitehi God hekrit hekrit te yi eiyɨrp han tokik me menmen enum me wɨ enum mamnen te maain yi wen eiyises hɨm mai yi yaain te yi eiyu eitikewa hi Mɨtɨk ke wit ke Mɨtɨk Iuwe.” ");
INSERT INTO avt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Me wepni, Jisas ken wɨnak iuwe ke God hɨrak kewepyapɨr hɨm mɨrak katɨp mɨt em. Me wɨtaan, hɨrak kɨniu mɨniu (o neiyɨp) Oliv ken kɨwaai ein. ");
INSERT INTO avt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Wanewik hekrit, hɨr mɨt miyapɨr nanpɨno wɨnak iuwe ke God nanɨmtau hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wɨ epei man menep kerek mɨt ne Isrel han tewenɨn wɨ kerek nɨpaa God kari maamrer nɨr nɨnaaiwɨr wit Isip, hɨrak ken kenep mɨt newiyen. Wɨ im hɨr nekinaam Pasova, hɨr ap newis yis mekre bret au. ");
INSERT INTO avt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mɨt iuwe pris netike mɨt ne Skraip kerek natɨp mɨt miyapɨr hɨm me God kerek Moses kewisɨm mau tɨwei, hɨr han kitet mamɨrkeik te hɨr nanɨnep Jisas nanɨntar hɨr nɨnapen nanriyaak kakɨt wit yaain te mɨt kerek nises hɨm mɨrak hɨr nanɨnɨp. ");
INSERT INTO avt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Te Seten kan kari han ke Judas kerek mɨt nenewek “Mɨtɨk ke wit Keriot,” kerek hak kiutɨp ke mɨt disaipel hiswiyen wik (12). ");
INSERT INTO avt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Seten kari han kɨrak te Judas ken katɨp mɨt iuwe pris netike mɨt iuwe naanmɨpre polis ne wɨnak iuwe ke God, hɨrak ketpor ekɨrkeik te hɨrak ekwetɨr Jisas kakno his mɨr. ");
INSERT INTO avt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hɨr nemtewem, te hɨr han yaaik natɨp nanwetɨwek pewek. ");
INSERT INTO avt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas kewenhi pewek te hɨrak han kitet ekɨrkeik te hɨrak kakwepyapɨr Jisas kakwet mɨt iuwe rek, te mɨt yapɨrwe nepu au hɨr nanɨtariyek. ");
INSERT INTO avt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Wɨ epei man te mɨt ne Isrel nanɨm bret yis mekrerem au. Me wɨ ik hɨr mɨt enɨnep sipsip enɨr ke hɨm me Moses mau tɨwei metpim, hɨr nanɨm me wɨ Pasova han tewenɨn God kɨkaap maamrer nɨr nɨpaa nɨnaaiwɨr Isip. ");
INSERT INTO avt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Me wɨ im Jisas keriuwet Pita ketike Jon ten ketpɨwekɨt, “Yi eino eiraimani menmen eirɨakem me wɨ Pasova te haiu mamɨm.” ");
INSERT INTO avt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hɨrakɨt titɨwekhi, “Ti hanhan hawɨr waumani menmen wawɨt nein?” ");
INSERT INTO avt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jisas ketpɨwekɨt, “Eiyɨmtau. Yi eino wit iuwe ek yi yayɨr mɨtɨk keremɨme mɨn tɨpar mekrerem. Yi eisesik einɨk eino wɨnak kerek hɨrak kaknɨk kakno kakɨkrerek. ");
INSERT INTO avt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Te yi eitɨp mɨtɨk hɨrekes ke wɨnak kar ik: ‘Mɨtɨk iuwe kawɨr ketput, Ti eweto haau meiyam em te hi etike mɨt disaipel nai mamɨm menmen me Pasova mamwi.’ ");
INSERT INTO avt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hɨrak kakteikni haau yaaim mau niu ein epei newis menmen mekrerem. Yi eiyɨt menmen eiwisɨm emwaai haau im e.” ");
INSERT INTO avt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hɨrak katɨp epei au, hɨrakɨt ten tɨnapɨn menmen kerek epei Jisas ketpɨwekɨt em, te hɨrakɨt tɨrɨak menmen mɨwaai werek werek te hɨr nanɨm menmen me Pasova. ");
INSERT INTO avt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hɨrakɨt temani menmen epei werek, Jisas ketike mɨt aposel nɨrak nar hiswiyen wik (12), hɨr nan nau neweikɨnan nanɨm menmen. ");
INSERT INTO avt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hɨr nau en, Jisas ketpor, “Hi hanhan iuwe me hi hahɨm menmen im me Pasova etikewi maminɨn te maain hi hahi. ");
INSERT INTO avt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hi hanhan ehɨm menmen im entar hi etpi, hi ap te ehɨm menmen meiyam mar im ere maain God kaknen naanmamri yi mɨt nai.” ");
INSERT INTO avt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jisas ketpor epei au, hɨrak kekin wa hesnu keriuwe tɨpar wain, hɨrak kitehi God ketpɨwek kar ik: “Ti yaaik.” Epei au, hɨrak katɨp, “Yi eiyɨt tɨpar mekre wa hesnu ik ek, eiwenem emrer yi mɨt. ");
INSERT INTO avt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Hi hetpi ap te hi pɨke ehɨm tɨpar wain im me wɨ im ere maain God kakinɨn kaknen naanmamri yi mɨt.” ");
INSERT INTO avt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Epei au, hɨrak kekin bret kerek ek, hɨrak kitehi God ketpɨwek, “Ti yaaik,” te hɨrak kewepik kewetɨrek katɨp, “Ik ek hɨrak kɨre yɨnk kai. Hi hahi te akepi. Yi yaitɨwem yayɨm han etwenɨn menmen hi arɨakem.” ");
INSERT INTO avt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hɨr naam epei au, mar keremem hɨrak kewetɨr wa hesnu tɨpar wain mekrerem, hɨrak ketpor, “Mar im tɨpar wain hi ewenem mekre wa hesnu ik e, hɨram hemkre mai mamwen mamkepi yi mɨt te God kakweti hɨm kontrak ham mɨrak yaaim me yi eitikerek eikiyan eiyu han kiutɨp. ");
INSERT INTO avt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yi eiyɨmtau! Hɨrak mɨtɨk kerek maain kakwepayapɨr epei kau ketikewai kaam menmen. ");
INSERT INTO avt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi hahi ahɨr ke nɨpaa God epei katɨp, te mɨtɨk kerek kakwepayapɨrek, hɨrak kakɨwaank hɨrekes.” ");
INSERT INTO avt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hɨr nemtewek epei au, hɨr nekrit nitehiyan ne hɨr hɨras keimɨnak maain kakrɨak menmen im e. ");
INSERT INTO avt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Maain mɨt disaipel natɨp nenehan me hɨr keimɨn hɨrak kakinɨni ne hɨr hɨras. ");
INSERT INTO avt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Hɨr nenehan menmen im te Jisas ketpor, “Mɨt iuwe ne mɨt ap ne weiwɨk me Isrel, hɨr naanmɨpre mɨt en, hanhan mɨt nenewor nɨr yinan. ");
INSERT INTO avt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Te yi au. Keimɨn ke yi mɨt hɨrak kakinɨn, hɨrak han ekitet hɨrak kɨre mɨtɨk weinɨk, hɨrak han ekitet hɨrak kɨre mɨt nitet yayiwe hɨrak kɨkaru. ");
INSERT INTO avt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yi han kitet keimɨn wɨsenuk kinɨn. Mɨtɨk kau yeno kaam menmen o mɨtɨk kerek kemani menmen kekinem kewet mɨtɨk kau yeno em? Mɨtɨk kau yeno kerek ek. ");
INSERT INTO avt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yi keriyen epei yetikewa me menmen enum epei man merewaank. ");
INSERT INTO avt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Te hi eweti menmen yi naanmamrewem yayɨr ke haai kai epei kewetewem hi naanmɨprewem. ");
INSERT INTO avt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Te yi yayɨm menmen mamtike tɨpar yayu yeno mai yaitikewa. Yi yayu yeno me mɨt iuwe yi skelim mɨt ne weiwɨk hiswiyen wik (12) me Isrel.” ");
INSERT INTO avt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas ketpor epei au, hɨrak katɨp Pita, “Saimon, Saimon, emtewek! Mɨtɨk enuk Seten, God epei ketpɨwek te hɨrak kakmitipɨn me menmen kakri han ke yi mɨt. Hɨrak kakrɨakem kakɨr ke mɨtɨk kerek keit rais nɨkim keses haas kewis nɨkim yaaim mamwaai in, kewɨr haas men ein. ");
INSERT INTO avt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Te hi epei hitehi God kakɨkepit ti Saimon te ti ehises hɨm yaaim ap te menmen mamɨwaankem. Maain te ti pɨke eweikɨn ehisɨsa, ti ekaap nit yinan in.” ");
INSERT INTO avt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita katɨp keremirɨwek hɨm kar ik: “Mɨtɨk Iuwe, hi ap hɨnaain te hawɨr wauno wɨnak enuk hi hahi etikewit.” ");
INSERT INTO avt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas ketpɨwek, “Pita, hi hetput. Suware ap te kaknep enum wen au ere ti epei atɨp wikak te ti ap erteiya au.” ");
INSERT INTO avt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas katɨp Pita epei au, hɨrak katɨp disaipel nɨrak yapɨrwe kar ik: “Nɨpaa me wɨ hi heriuweti yi yen ap yeit tanɨk kike o tanɨk iuwe me nɨkɨn nakɨrke metike su, mɨt neweti menmen mei o au? Yi nɨnpɨ miwei o au?” Hɨr newenhi natɨp, “Haiu meit menmen werek.” ");
INSERT INTO avt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisas katɨp, “Te in ek, yi neimɨn yeit tanɨk kike o tanɨk iuwe au, yi eitɨwem. Yi neimɨn ap yeit hɨne me his au en, yi eisiuwe saket te yi eiyɨt kei ki. ");
INSERT INTO avt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hi hetpiyem entar yi han tokik eiyu me menmen enum mamnen eiyɨr ke mɨtɨk ketenen hɨne keiyɨk kaknep mɨt enun nepan. Hɨm me God mau tɨwei nɨpaa mɨt newisɨm hɨram matɨp me hi mar ik: ‘Mɨt iuwe nanwisɨk kaki kaktike mɨt enun nɨrɨak enum.’ Menmen mekre tɨwei nɨpaa mɨt newisɨm me hi, hɨram mamnen mamɨrek.” ");
INSERT INTO avt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hɨrak katɨp epei au, mɨt disaipel natɨp, “Mɨtɨk Iuwe, ehɨr im em. Haiu metenen hɨne me his wik.” Hɨrak kewenhi katɨp, “Hɨram werek. Emɨt. Yi yepɨtari hɨm mai.” ");
INSERT INTO avt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hɨr natɨp epei au, Jisas ken witeik kɨnaaiwɨr wit Jerusalem, hɨrak ken mɨniu (o neiyɨp) Oliv kepɨr ke nɨpaa hɨrak kɨrɨakem. Mɨt disaipel nɨrak nisesik nen. ");
INSERT INTO avt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hɨrak kan wit ik epei au, hɨrak ketpor, “Yi eiyitehi God te menmen enum Seten kakrekyorem hɨram ap te mamnen mamiwep taau.” ");
INSERT INTO avt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hɨrak ketpor epei au, hɨrak kɨnaiwɨri ken ere yanɨmɨn ein kɨre mɨt newɨr nan, hɨrak kewen ninɨp kau tɨ kitehi God menmen. ");
INSERT INTO avt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Hɨrak katɨp, “Haai, ti han kit te ti ehɨt menmen im enum emkeipno. Ap han kai, au. Ti han kit ti erɨakem.” ");
INSERT INTO avt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mɨtɨk ensel keke wit ke God kan kɨrek kekepik han tokik kepu. ");
INSERT INTO avt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas han toenuk keriuwe menmen te hɨrak kitehi God hisiuwe, siuwan mɨrak meweikɨnhis mɨre hemkre metnen men tɨ. ");
INSERT INTO avt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hɨrak kitehi God epei au, hɨrak kekrit pɨke kakno kakɨr mɨt disaipel tɨrak. Au, hɨrakɨt tɨwaai tentar hɨrakɨt han enuk teriuwe menmen enum mamnen. ");
INSERT INTO avt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hɨrak kitorhi ketpor, “Yenmak te yi yɨwaai a? Yi eiyɨkrit eiyitehi God ekɨkepi te Seten ap kakrekyi enum taau.” ");
INSERT INTO avt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas wen ketpor menmen im, mɨtɨk niuk mɨrak Judas kerek mɨtɨk kiutɨp ke mɨt disaipel hiswiyen wik (12), hɨrak kinɨn mɨt yapɨrwe kan kerp ninaan me Jisas te keiyewewik kemɨwek tekep (kises menmen me maamrer nɨr.) ");
INSERT INTO avt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Te Jisas ketpɨwek, “Ti eriuwe menmen im me hawɨr weiyewewakɨt hɨram mɨre hawɨr hɨrekses te ti ewisa hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi eno his me mɨt enun nepan a?” ");
INSERT INTO avt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mɨt disaipel kerek nerp en netikerek nertei menmen mamnen hɨr nitɨwekhi, “Mɨtɨk Iuwe, haiu emnep mɨt mamriuwe hɨne me his maiu o au?” ");
INSERT INTO avt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mɨtɨk disaipel kiutɨp kɨwaai hɨne ke his kenep mɨtɨk kɨrɨak menmen me mɨtɨk iuwe pris, hɨrak keremir nɨkɨp me his yaaim mewen meket. ");
INSERT INTO avt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Au, Jisas katɨp keremiror hɨm kar ik: “Epei au werek. Eiwisɨk.” Hɨrak keit nɨkɨp pɨke kemtɨn mau paan kɨrak epei werek te mɨtɨk kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jisas kerekyɨwekem mɨre yaaim, hɨrak kitehi mɨt iuwe pris netike mɨt naanmɨpre polis kerek naanmɨre wɨnak iuwe ke God, hɨr netike mɨt iuwe ne kaunsil, hɨr nan nantɨwekhis, hɨrak ketpor, “Yi yenmak te yi yan yetike hɨne me his o paap yoki te yi yan yetauhis yaire yi yayɨthis mɨtɨk enuk kerek kekintɨp menmen a? ");
INSERT INTO avt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hekrit hekrit hi epeu etikewi hi heit wɨnak ke God eik ek, te yi ap eitauhis eiwisa ekre wɨnak enuk ke gavman au. Te in ek hɨram wɨ mi te yi yairɨak menmen enum. Seten in ek kare kakinɨna.” ");
INSERT INTO avt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hɨrak katɨp epei au, hɨr netɨwekhis neriyaak neiyɨk nen nekre wɨnak ke mɨtɨk iuwe hetpris. Pita kisesi wen keit yanɨmɨn. ");
INSERT INTO avt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hɨr mɨt ne polis nɨman si nau menep ke wɨnak iuwe eik ek. Epei au, mɨt nererik nau si, Pita kan kau ketikeri. ");
INSERT INTO avt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hɨrak kau ketikeri, mɨte piutɨp wɨrek kau si em, hɨre wenemiyɨwek naan watɨp, “Hɨrak mɨtɨk ik ek ketike Jisas.” ");
INSERT INTO avt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hɨrak keremirɨwe hɨm kepakɨnek katɨp, “Mɨte hi epɨtariyek.” ");
INSERT INTO avt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Maain kike, mɨtɨk hak kɨrek te hɨrak ketpɨwek, “Ti kiutɨp ke mɨt yi yisesik.” Te Pita keremirɨwek hɨm katɨp, “Mɨtɨk hi ap hisesik taau.” ");
INSERT INTO avt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Maain kike, mɨtɨk hak katɨp hɨm manp, “Hi atɨp werek! Mɨtɨk ik nɨpaa ketikerek kentar hɨrak katɨp kɨre mɨtɨk ke provins Galili, kar ke Jisas ketpim.” ");
INSERT INTO avt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Au, Pita keremirɨwek hɨm katɨp, “Mɨtɨk, hi epɨtari mekam ti etpewem.” Pita wen ketpim, suware kenep enum. ");
INSERT INTO avt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Suware kenep enum, Jisas kerenaan kɨr Pita. Pita hɨrak keket han nɨpaa Jisas ketpɨwek me hɨm im, “Suware ap kaknep enum wen au, ti eraupakɨn wikak.” ");
INSERT INTO avt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hɨrak han kitet menmen im te hɨrak ken wit eik kɨkɨt wɨsenum. ");
INSERT INTO avt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Mɨt kerek naanmɨre Jisas hɨr nitɨtɨweknaan nakɨp. Hɨr newenkɨkɨwek nanamɨr neriuwe laplap nitɨwekhi, “Keimɨn kitep a? Ti profet ti ewepyapɨrek.” ");
INSERT INTO avt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hɨr netpɨwek hɨm enum me nɨrɨakek yɨnk enuk. ");
INSERT INTO avt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wanewik epei kan, mɨt iuwe naanmɨpre mɨt ne Isrel, hɨr netike mɨt iuwe naanmɨpre mɨt pris, hɨr netike mɨt ninɨn nertei hɨm me Moses natɨp mɨt miyapɨr em, hɨr nererik nau wɨnak ke kaunsil te hɨr nari Jisas kan kerp nɨmɨn. ");
INSERT INTO avt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hɨrak kan kerp nɨmɨn, hɨr nitɨwekhi, “Ti hetpei ti Mɨtɨk kerek God kehimɨtenut kakɨrwetit ti enen tɨ ik o au?” Hɨrak ketpor, “Hi hetpi te yi ap yisɨsa hɨm mai taau. ");
INSERT INTO avt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hi ehitihi menmen te yi ap yayɨtpowem taau. ");
INSERT INTO avt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","In ek ere maain hi Mɨtɨk ke wit ke Mɨtɨk Iuwe ehu etike God iuwe wawinɨn naanmamre mɨt.” ");
INSERT INTO avt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hɨr yapɨrwe nitɨwekhi, “Ti atɨp ti Nɨkan ke God a?” Hɨrak kewenhi katɨp, “Hi Nɨkan ke God hepɨr yi yetpim.” ");
INSERT INTO avt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hɨr natɨpan, “Haiu ap mamri mɨt han te nanwepyapɨr hɨm enum nɨpaa hɨrak ketpim taau. Haiu epei memtau menmen enum hɨrak in ek ketpim.” ");
INSERT INTO avt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mɨt ne kaunsil nemtau hɨm me Jisas epei au, mɨt yapɨrwe nekrit nari Jisas neiyɨk nen mɨtɨk iuwe gavman Pailat. ");
INSERT INTO avt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","In ek hɨr newepyapɨrek natɨp, “Haiu mɨnapen mɨtɨk ik ek hɨrak kariyeinaan mɨt naiu ne Isrel, hɨrak ketpor ap emwetɨr pewek me takis emno mɨt ne gavman ke Rom, hɨrak katɨp hɨrak hɨrekes Krais, hɨrak Mɨtɨk Iuwe kinɨn mɨt.” ");
INSERT INTO avt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat kitɨwekhi, “Ti Mɨtɨk Iuwe king hinɨn naanmɨpre mɨt ne Isrel a?” Jisas kewenhi katɨp, “Ti hɨrekes hetpim me hi kerekek.” ");
INSERT INTO avt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Epei au, Pailat keweikɨn katɨp mɨt iuwe pris netike mɨt yapɨrwe, “Hi ap hertei menmen enum hɨrak kɨrɨakem te hi atɨp hɨrak enuk. Au, hɨrak yaaik.” ");
INSERT INTO avt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Te hɨr newep hɨm natɨp hɨm iuwe, “Hɨrak hɨrekes kɨrɨak mɨt han kekrit kekrit neriuwe hɨm hɨrak ketporem. Hɨrak kinɨn kɨrɨakem keit provins Galili, ken kerer wit wit ke provins Judia te in ek hɨrak epei kan Jerusalem.” ");
INSERT INTO avt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mɨtɨk Pailat kemtau hɨm mɨr im hɨrak kitorhi, “Hɨrak mɨtɨk ik ek ke Galili a?” Hɨr netpɨwek, “O, hɨrak hɨrekes ke Galili.” ");
INSERT INTO avt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hɨrak kertei Jisas hɨrak ke mɨt kerek Herot naanmɨpror neit provins Galili, hɨrak keriuwetek ken kɨrek. Me wɨ im, Herot kan kau wit Jerusalem me wɨ kike keremem. ");
INSERT INTO avt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mɨtɨk Herot hɨrak han yaaik kakɨr Jisas kentar hɨrak epei kemtau menmen me Jisas. Te hɨrak nɨpaa kemeriyɨwek kaktɨp kakɨrek. Hɨrak hanhan kakɨr Jisas kakrɨak menmen mɨt nɨpaa nɨrem au kakɨkaap mɨt kakriuwerem. ");
INSERT INTO avt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Te Herot kitehi Jisas yapɨrwe, te Jisas ap kewenhi katɨp hɨm mei miutɨp au. ");
INSERT INTO avt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Te mɨt iuwe ne pris netike mɨt newepyapɨr hɨm me Moses nekrit nerp natɨp hɨm manp nesiuwe hɨm Jisas. ");
INSERT INTO avt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hɨr nerp nesiuwe hɨm Jisas, mɨtɨk Herot ketike mɨt nɨrak ne ami natɨp Jisas enum, nitetɨweknaan nerekyɨwek enum. Hɨr nemrɨwek laplap yaaim kerek mɨt iuwe namɨr te hɨr pɨke neriuwetek ken kakɨr mɨtɨk Pailat. ");
INSERT INTO avt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Me wɨ im keremem Herot ketike Pailat tekiyakɨt tau tentar Pailat keriuwet Jisas ken kɨrek. Hɨrakɨt nɨpaa tɨre mɨtɨkɨt enukɨt tepan. ");
INSERT INTO avt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mɨtɨk Pailat kenɨne mɨt iuwe ne pris, mɨt iuwe ne kaunsil netike mɨt yapɨrwe, ");
INSERT INTO avt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","te hɨrak ketpor, “Yi epei yari mɨtɨk ik ek yeiyɨk yan, yi yatɨp hɨrak kari han ke mɨt In ek, hi epei hitɨwekhi me ninaan me yi mɨt yapɨrwe, te hi ap hɨnapɨn hɨrak kɨrɨak menmen enum kerek yi yetpewem em au. ");
INSERT INTO avt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot kɨnapɨnek te hɨrak kɨrɨak enum au. Te hɨrak kesiuwerek kan in. Mɨtɨk ik ap kɨrɨak menmei enum te hɨrak kaki au. ");
INSERT INTO avt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hi atɨp mɨt nai nantenenik nanwaai nɨpɨn nankɨp te hi esiuwerek kakno.” ");
INSERT INTO avt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Me wɨ Pasova mɨtɨk Pailat kɨnaaiwɨr mɨtɨk kiutɨp kerek nɨpaa kau kekre wɨnak enuk ek, hɨrak kakno mɨt neitei en.) ");
INSERT INTO avt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mɨt yapɨrwe nererik en natɨp, “Einep Jisas. Enaaiwɨr mɨtɨk Barabas eknen ektike haiu mɨt, har ke nɨpaa me wɨ Pasova ti hɨnaaiwɨr mɨt han.” ");
INSERT INTO avt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas nɨpaa hɨr newisɨk kekre wɨnak enuk me menmen enum hɨrak kɨrɨakem. Hɨrak ketike mɨt iuwe ne gavman nenepan te hɨrak kenep mɨtɨk kaa.) ");
INSERT INTO avt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mɨtɨk Pailat hanhan kaknaaiwɨr Jisas kakno, te hɨrak pɨke kenɨne mɨt yapɨrwe ketpor kar nɨpaa hɨrak ketpim. ");
INSERT INTO avt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Te hɨr nɨnap natɨp, “Ewisɨk eku nu tentarakɨt! Ewisɨk eku nu tentarakɨt!” ");
INSERT INTO avt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mɨtɨk Pailat pɨke ketpor ere wikak kar ik: “Te hɨrak kɨrɨak mekam enum te hi akɨp a? Hi ap hɨnapɨn menmen enum hɨrak kɨrɨakem te hi akɨp hɨrak eki! Hi hanhan mɨt nai nantenenik nanwaai nɨpɨn nankɨp te hi esiuwerek kakno!” ");
INSERT INTO avt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Te hɨr nɨnap nenke natɨp hɨm iuwe te hɨrak akwenkek Jisas ekɨntar nu tentarakɨt. Hɨr nɨnap narek ere Pailat kises hɨm mɨr. ");
INSERT INTO avt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Te Pailat katɨp Jisas kaki kakre mɨt hanhanek. ");
INSERT INTO avt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hɨrak kɨnaaiwɨr mɨtɨk kerek hɨr hanhanek, kerek nɨpaa kekre wɨnak enuk kentar hɨrak ketike mɨt ne gavman nenepan, hɨrak kenep mɨtɨk kaa. Te hɨrak kesiuwe Jisas ken kaki kar ke mɨt hanhanek. ");
INSERT INTO avt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mɨt ne ami ne Rom hɨr neithis Jisas neiyɨk nen. Hɨr nepno, hɨr newenyipɨr mɨtɨk niuk mɨrak Saimon, hɨrak ke wit Sairini, kerek kan keke wit kɨrak yanɨmɨn. Hɨr netɨwekhis newis nu kenterik hɨrak kekerɨr nu keiyɨk kises Jisas. ");
INSERT INTO avt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mɨt yapɨrwe nisesik netike miyapɨr nei kerek nɨkɨtek netikeri nen. ");
INSERT INTO avt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hɨr nɨkɨtek te Jisas keweikɨn ketpor, “Miyapɨr ne Jerusalem. Yi ap eiyɨkta au emɨt! Yi eikɨt hɨras eitike nɨkerek ni eiyɨntar mɨt nanriwaank. ");
INSERT INTO avt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hi hatɨp hɨm im te wɨ maain mamnen te mɨt nantɨp, ‘Hɨram yaaim me miyapɨr tenmɨn, o miyapɨr kerek ap nine nɨkerek en, o miyapɨr ap newet nɨkerek nɨm, hɨr han yaaik enu.’ ");
INSERT INTO avt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Me wɨ eim mɨt nantɨp hɨr hanhan mɨniu (o neiyɨp) o wank kakwen kakɨnteri. ");
INSERT INTO avt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hɨr mɨt ne Rom neiyep te hi hɨrɨak menmen enum au, te maain hɨr nanrekyi mekam me menmen enum mɨt in nɨrɨakem? Hɨr nanriwaank yayɨt.” ");
INSERT INTO avt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hɨr neithis mɨtɨkɨt hakɨt wik, hɨrakɨt enukɨt tɨrɨak menmen enum tenep mɨt, nanɨksɨp tatkite Jisas. ");
INSERT INTO avt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hɨr epei nan menep wit kerek mɨt nenewek “Paan Hesnu,” hɨr newenkekik kau nu tentarakɨt, te mɨtɨkɨt enukɨt raskel, hak kau kenke ken his yaaim, hak kau kenke ken his henkik. ");
INSERT INTO avt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisas kau kentar nu tentarakɨt, hɨrak katɨp, “Haai, ti han ekitet menmen im au emɨt! Ehɨsak menmen enum hɨr nerekyewem. Hɨr ap nertei hi keimɨn te hɨr nerekyewem.” Hɨr mɨt ne ami nenke laplap newetan nentar hɨr neretɨt satu o sak hemik. ");
INSERT INTO avt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mɨt yapɨrwe nerp en nɨpɨrek, te mɨt iuwe ne kaunsil ne Isrel natɨp Jisas enum hɨr natɨp, “Hɨrak kɨkaap mɨt miyapɨr han te hɨrak Mɨtɨk God nɨpaa kehimɨtanek kakɨkaap haiu mɨt, emwisɨk hɨrak ekɨkaap hɨrekes kakɨnke kakɨrp tɨ te hɨrak kaki au.” ");
INSERT INTO avt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Te mɨt ne ami nan nɨrek netpɨwek enum, te hɨr newen tɨpar wain enum mɨnɨn hɨr newetɨwekem. ");
INSERT INTO avt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Hɨr newetɨwekem hɨr netpɨwek, “Ti mɨtɨk iuwe naanmɨpre mɨt ne Isrel te ti ahɨkaap hɨrekes enke nu ik ehɨrp tɨ.” ");
INSERT INTO avt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hɨr netpim nentar mɨtɨk iuwe ke gavman kewis hɨm im mau nu tentarakɨt mau niu mentar paan ke Jisas. Hɨram matɨp mar im: “HƗRAK MƗTƗK IUWE KING NAANMƗPRE MƗT NE ISREL.” ");
INSERT INTO avt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mɨtɨk ke mɨtɨkɨt hakɨt kerek epei newenkekikɨt tau nu tentarakɨt tetike Jisas Tatɨp enum kar ik: “Ti Mɨtɨk Iuwe Krais, te ti ekepawɨr wautikewit.” ");
INSERT INTO avt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Te mɨtɨk hak ek kemtewek, hɨrak katɨp kenerek, “Hawɨr menmen enum wetikerek mɨpɨram, te ti enapen atɨp enum te maain haiu mami God kakwep wɨsenum a? ");
INSERT INTO avt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Menmen im enum mɨt nerekyawɨrem me menmen enum hawɨr wɨrɨakem te hawɨr wawi wawɨnterim, hɨram werek. Mɨtɨk ik ek au, kaki weinɨm kakɨntar hɨrak ap kɨrɨak menmen enum au, menmen yaaim.” ");
INSERT INTO avt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Te hɨrak katɨp Jisas, “Ti han etwenɨna Jisas, maain me wɨ ti naanmamre mɨt.” ");
INSERT INTO avt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisas ketpɨwek, “Hi hetput im e. Petepin ti etikewa ehu wit yaaik kerek mɨt yaain epei naa, hɨmɨn kɨr kewi.” ");
INSERT INTO avt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","In ek hɨrak wepni kau nɨmɨn iuwe, te God kenip wepni kaa ap te kɨr au, te wɨtaan mɨwapɨn tɨ ik merer wit wit ere wepni kewen ken hɨnkewɨ ik e. ");
INSERT INTO avt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Wepni wen ap kɨr te wit toto, laplap kerek nɨpaa mɨt nɨmɨan mekre wɨnak iuwe ke God ek mɨwapɨn haau hak holi tru mɨt nehimɨtanek ke God, hɨram mewep wiketerem. Mar im God keteikɨn mɨt Jisas kaa kakɨnke weipɨr te mɨt hekrit hekrit nanitehi God nanɨt ninaan mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Menmen im man epei au, Jisas kɨnap kenɨne hɨm iuwe, “Haai, hi esiuwe hɨmɨn kai kaknaiwɨr yɨnk kai te hi hahi.” Hɨrak katɨp epei au, hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te mɨtɨk iuwe naanmɨpre mɨt han nar 100 ne ami, hɨrak kɨr menmen im Jisas kɨrɨakem, hɨrak kewenɨpi God katɨp, “Hi hertei hɨrak mɨtɨk yaaik kɨrɨak menmen enum au.” ");
INSERT INTO avt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mɨt yapɨrwe kerek nererik nerp ein e nɨr menmen im, hɨr pɨke nen nɨr ein newen toni nɨkɨtek. ");
INSERT INTO avt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hɨr neimɨn kerek nertei Jisas werek werek netike miyapɨr kerek nises Jisas neit Galili, hɨr nerp yanɨmɨn nɨr menmen me Jisas kaa. ");
INSERT INTO avt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mɨtɨk hak niuk mɨrak Josep, hɨrak ke wit Arimatia kerek wit kiutɨp ke Isrel. Hɨrak mɨtɨk yaaik katɨp menmen yaaim werek werek, kemerɨr God kaknen naanmamre mɨt. Hɨrak mɨtɨk kiutɨp ke mɨt ne kaunsil te hɨrak ap han yaaik keriuweri me menmen enum hɨr natɨp nanrɨak Jisas em. ");
INSERT INTO avt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hɨrak ken wɨnak ke mɨtɨk iuwe Pailat kitɨwekhi ekwetɨwek yɨnk ke Jisas kerek epei kaa. Hɨrak kewenhi epei au, ");
INSERT INTO avt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","te Josep kesiupan herwe yɨnk ke Jisas kau nu tentarakɨt ken tɨ. Hɨrak kewenkekik keriuwe laplap yaaim meweiwei, te hɨrak kɨnanek keiyɨk ken kewisɨk kɨnɨk han nɨpaa mɨt nekinɨk kekre nan ke mɨniu (o neiyɨp) kerek nɨpaa ap mɨt newis nei nekrerek wen au. ");
INSERT INTO avt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hɨram me wɨ Fraide kerek mɨt hɨr nemani nekre menmen, te wɨ Sabat epei mamɨkrit. ");
INSERT INTO avt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Te miyapɨr kerek nɨpaa nises Jisas neke Galili nan, hɨr netike Josep nen nɨr hɨrak kewis Jisas yɨnk kɨrak kekre hei ke mɨniu (o neiyɨp) markeik. ");
INSERT INTO avt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Epei au, hɨr pɨke nen wit eik nɨrɨak menmen mɨnɨn yaaim te neiyɨm nanɨnen nanwisɨm mamu yɨnk kɨrak te hɨrak ap kaknɨn waswas au. Epei au, hɨr nau neit nar ke hɨm me Moses mau tɨwei metpim ere wɨ Sabat hɨram epei au. ");
INSERT INTO avt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wɨ Sande, wanewik kesiupan toto eik, miyapɨr nen hei kerek han kewen kɨnɨk nɨpaa mɨt newis Jisas kekrerek, hɨr neit menmen yaaim mɨnɨn te nanwisɨm mamu Jisas yɨnk kɨrak kerek nɨpaa hɨr nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hɨr nen nɨr nan kerek keiyepet hɨm ke hei ek mɨt nepei nenkerek kenpɨn kekeipɨn hɨm ke weipɨr ke hei. ");
INSERT INTO avt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hɨr nɨnɨk nen nɨmɨn, te hɨr nɨnetnɨwek ap nɨnapɨn yɨnk ke Jisas kekre hei kɨwaai au. ");
INSERT INTO avt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hɨr nerp en han kitet me menmen im, te wasenum mɨtɨkɨt wik teriuwet laplap mɨre hike terp menep tetikeri. ");
INSERT INTO avt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hɨr miyapɨr nɨnapen wɨsenum te hɨr nitehɨr newen ninɨp nau tɨ te mɨtɨkɨt hɨrakɨt tetpor, “Yenmak te yi yan yɨnyatɨn mɨtɨk pɨke kekrit kepu yeit wit ke mɨt hɨr epei naa newisi neitai a? ");
INSERT INTO avt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hɨrak ap keit in au. Hɨrak epei kekrit. Yi han ekitet menmen nɨpaa hɨrak ketpiyem me wɨ hɨrak wen kepu provins Galili. Hɨrak katɨp kar ik: ");
INSERT INTO avt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, mɨt han nanwisa hi eno his me mɨt enun nises menmen enum te hɨr nanwenkɨka hahu nu tentarakɨt hi hahi. Te maain hi pɨke ahɨkrit ehu are mɨtɨk me wɨ wikak.’” ");
INSERT INTO avt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hɨrakɨt tatɨp epei au, miyapɨr han kitet menmen me hɨm nɨpaa hɨrak ketpim, ");
INSERT INTO avt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","te hɨr nɨnaaiwɨr herwe hei pɨke nen. Mɨte kerep ep niuk mɨre Maria pe Magdala, Joana wetike Maria miye pe Jems, hɨr netike miyapɨr han natɨp hɨm im men mɨt aposel nar hiswiyen kiutɨp (11) netike mɨt han, hɨr netpor menmen hɨr epei nɨrem. ");
INSERT INTO avt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Te mɨt aposel natɨp nekre han kɨr menmen miyapɨr netpim hɨr nemipɨn, te hɨr ap nemtewem nisesim au. ");
INSERT INTO avt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Te mɨtɨk Pita kekrit kesiukɨn ken hei kerek nɨpaa mɨt newis Jisas keitai. Hɨrak ken en, hɨrak kitehɨr kɨr laplap weinɨm. Hɨrak ap kɨr menmeiyam au, te hɨrak pɨke ken wit eik han kitet menmen epei man. ");
INSERT INTO avt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Me wɨ kerek Pita kɨr hei weinɨk keremem, mɨtɨkɨt wiketeret ten wit hak kiutɨp mɨt nenewek Emeas. Hɨrak yanɨmɨn kike kɨre 11 kilomita ke Jerusalem. ");
INSERT INTO avt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Te hɨrakɨt teke tɨ tatɨpakɨt me menmen epei man keremem. ");
INSERT INTO avt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hɨrakɨt wen tetpim han kitetim, Jisas hɨrekes kisesikɨt kan kewenyipɨret. ");
INSERT INTO avt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hɨrakɨt tɨrek te hɨrakɨt ap terteiyek hɨrak keimɨn kentar hɨrak kenipɨwekɨt han kɨrakɨt ap terteiyek au. ");
INSERT INTO avt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisas ketpɨwekɨt, “Yi yewepnak yatɨp mekam yi yeke tɨ yepno?” Te hɨrakɨt terp teit tenep naan mekiuwe. ");
INSERT INTO avt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mɨtɨk hak niuk mɨrak Kliopas kitɨwekhi, “Mɨt miyapɨr yapɨrwe nerer wit wit han nererik neit Jerusalem me wɨ im. Te ti kiutɨp kerekek ap hertei menmen im nɨpaaseik epei man a?” ");
INSERT INTO avt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jisas kitɨwekhi, “Mekam epei man?” Hɨrakɨt tetpɨwek tar ik: “Menmen epei man mewaank Jisas ke wit Nasaret. Mɨtɨk ik hɨrak profet, hɨrak kɨrɨak menmen nɨpaa mɨt ap te nɨrɨakem. Hɨrak mɨtɨk yaaik kewepyapɨr hɨm yaaim, te God ketike mɨt han kitet hɨrak yaaik iuwe. ");
INSERT INTO avt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mɨt naiu iuwe ne pris netike mɨt iuwe ne kaunsil newisɨk ken gavman te hɨr newenkekik kentar nu tentarakɨt hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Te haiu hanhan hɨrak kiutɨp kerekek kakɨkepai haiu mɨt miyapɨr ne Isrel kaktaihis keriyen. In ek hɨram wɨ wikak menmen im nepei man. Menmen im epei man metike menmen ham im. ");
INSERT INTO avt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Miyapɨr han naiu nerekyei haiu han kekrit. Wanewik hɨr nen nanɨr hei kerek mɨt newisɨk kɨwaairi en. ");
INSERT INTO avt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Te hɨr ap nɨnapɨn yɨnk kɨrak au. Hɨr pɨke nan natɨp hɨr nau nɨtyak nɨr mɨtɨkɨt ensel tetpor, ‘Hɨrak epei kekrit kɨre mɨtɨk.’ ");
INSERT INTO avt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hɨr natɨp epei au, mɨt han ne haiu mɨt nen nɨr hei kerek mɨt newisɨk kekrerek mepɨr ke miyapɨr netpim te hɨr ap nɨnapɨnek au.” ");
INSERT INTO avt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Te Jisas keneret ketpɨwekɨt, “Yi han auri. Yenmak te yi ap yises menmen yapɨrwe profet netpim a? ");
INSERT INTO avt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mekam? Yi ap yertei Krais kerek God kehimɨtanek kaknen kakɨkaap mɨt, hɨrak ekinɨn eki pɨke kakɨkrit te maain hɨrak kakɨt niuk iuwe me God a?” ");
INSERT INTO avt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Te Jisas ketpɨwekɨtem werek werek menmen tɨwei me God metpim me hɨrekes. Hɨrak kekrit keit tɨwei Moses kewisɨm, hɨrak kewepwekɨtyapɨr hɨm ere hɨrak ketpor hɨm mɨt profet netpim newisɨm mau tɨwei me hɨrekes. ");
INSERT INTO avt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hɨrakɨt tan menep ke wit kerek hɨrakɨt tatnori, te Jisas kemipɨn kare kakno yanɨmɨn. ");
INSERT INTO avt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Te hɨrakɨt tewenek kerp tetpɨwek, “Ehu etikewawɨr (o etikawɨr). Wepni epei kakwen kakno wɨtaan.” Te hɨrak ken kau ketikeret. ");
INSERT INTO avt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jisas kau ketikeret tatɨm menmen. Hɨrak kekin bret katɨp God hɨrak yaaik, te hɨrak kewepik kewetɨwekɨtek. ");
INSERT INTO avt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hɨrak kɨkɨak han kɨrakɨt hɨrakɨt terteiyek, te hɨrak keweikɨn his kɨre nɨme keit, hɨrakɨt ap tɨrek au. ");
INSERT INTO avt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hɨrakɨt tatɨpakɨt, “Han kawɨr kekrit kerek hɨrak ketpawɨr witet yayiwe ketpawɨr werek werek hɨm me God mau tɨwei.” ");
INSERT INTO avt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hɨrakɨt tatɨpakɨt epei au, hɨrakɨt tekrit wasenum pɨke ten Jerusalem. Hɨrakɨt tɨr mɨt disaipel hiswiyen kiutɨp (11) nererik netike mɨt han. ");
INSERT INTO avt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Te hɨr netpɨwekɨt nar ik: “Haiu metpi werek. Mɨtɨk Iuwe pɨke kekrit kepu. Saimon epei kɨrek kepu.” ");
INSERT INTO avt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Te mɨtɨkɨt wiketeret tetpor menmen werek werek kerek epei man meit yayiwe eik. Hɨrakɨt tetpor markeik hɨrakɨt tertei Jisas kewep bret kewetɨwekɨtek. ");
INSERT INTO avt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hɨrakɨt wen tetpor hɨm im, wasenum Jisas hɨrekes kerp ketikeri ketpor, “Yi eiyu werek werek.” ");
INSERT INTO avt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Te hɨr nɨnapen nepɨrpɨr nentar hɨr han kitet hɨr nɨr herwe. ");
INSERT INTO avt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Te hɨrak ketpor, “Yenmak te yi han toenuk a? Yenmak te yi han kiteta hi herwe a? ");
INSERT INTO avt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Eiyɨr pap me hei mau his hɨt mai. Hi hɨrekes kerek ek. Eirɨrauhis, te yi eiyɨrtei hi hɨrekes. Herwe ap te naan o hemik kewik kar ke epei yi yɨra auye!” ");
INSERT INTO avt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jisas ketpor hɨm im epei au, hɨrak keteiknor his hɨt mɨrak. ");
INSERT INTO avt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hɨr ap te nanisesim nentar hɨr han yaaik wɨsenuk te hɨrak kitorhi, “Yi yeit menmen mei te yi yeweto mei ehɨm o au?” ");
INSERT INTO avt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hɨr newetɨwek saauk hak kiutɨp kerek epei si taak. ");
INSERT INTO avt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","44","Hɨrak kekinɨk kaak, hɨr nɨrek. Hɨrak kaak epei au, hɨrak ketpor, “Menmen im nɨpaa hi epei hetpiyem kerek hi wen hepu hetikewi hɨram im: ‘Menmen yapɨrwe kerek nɨpaa Moses ketike mɨt profet hɨr newisɨm mau tɨwei metike hɨm mau tɨwei Sam hɨram mamnen.’” ");
INSERT INTO avt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Epei au, hɨrak kerekyor han kɨr kewep te hɨr nanɨrtei hɨm me God mau tɨwei werek werek. ");
INSERT INTO avt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Te hɨrak ketpor, “Im em hɨram hɨm nɨpaa mɨt newisɨm mau tɨwei: ‘Mɨtɨk God kehimɨtanek Mɨtɨk Iuwe Krais eki te pɨke kakɨkrit me wɨ wikak.’ ");
INSERT INTO avt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yi mɨt nai yeit wit Jerusalem yi yaino yairer wit wit yaitɨp mɨt miyapɨr hɨm yaaim te hɨr nanweikɨn sip nanwet menmen enum God kakɨsak menmen enum mɨr kakɨntar menmen hi hɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","49","Yi epei yɨr menmen im te yi yaiwepyapɨrem. Hi hɨrekes eriuweti menmen nɨpaa Haai kai katɨp hɨrak kaksiuwerek kaknen, te yi wen eiyu wit iuwe ik ek eimerɨr menmen iuwe me wit ke God mamɨkiuwe mamnen mamwi.” ");
INSERT INTO avt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisas katɨp epei au, hɨrak keriyei nen nɨnaaiwɨr wit Jerusalem, hɨr nen wit Betani. In ek hɨrak kɨkɨam his mɨrak kitehi God naanmamror. ");
INSERT INTO avt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jisas wen kitehi God naanmamror, hɨrak ken kɨnaiwɨri kɨniu ken wit ke God. ");
INSERT INTO avt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Epei au, hɨr newenɨpiyek. Hɨr wen newenɨpiyek hɨr pɨke nepno wit Jerusalem han yaaik iuwe. ");
INSERT INTO avt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hekrit hekrit hɨr nen wɨnak iuwe ke God newenɨpiyek. ");
INSERT INTO avt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nɨpaa enum eik, God kɨrɨak tɨ wen au, mɨtɨk kiutɨp kepu kerek kakwetai hɨm yaaim. Hɨrak kau ketike God, hɨrakɨt tau niutɨp tɨpɨrakɨt. ");
INSERT INTO avt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Menmen mepu wen au, hɨrak kau ketike God. ");
INSERT INTO avt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God katɨp mɨtɨk ik, te hɨrak kewis menmen yapɨrwe kerek mepu, hɨrak kɨrɨakem. Menmen meiyam miutɨp ap te hɨremes mekrit au. Hɨrak Haai ke hɨmɨn hak yaaik kɨkaap mɨt hɨr nanu nanɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hɨrak kɨkaap mɨt nertei God, hɨr nanu werek nanɨr ke si mɨr te mɨt hɨr nanɨr yayiwe. ");
INSERT INTO avt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hɨm me mɨtɨk ik hɨram mɨre si mɨrius ein ein. Menmen enum mɨre wɨtaan toto mekre han ke haiu mɨt ap te maminɨnem mamɨwaankem taau. ");
INSERT INTO avt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God keriuwet mɨtɨk kakwepyapɨr menmen im, hɨrak itai kai niuk mɨrak Jon. ");
INSERT INTO avt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hɨrak kan katɨp mɨt me mɨtɨk ik. Hɨrak yaaik kɨre si mɨr, te mɨt yapɨrwe nemtau hɨm me Jon, hɨr nanises mɨtɨk ik. ");
INSERT INTO avt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hɨrak hɨrekes ap mɨtɨk ik au. Hɨrak kan katɨp mɨt hɨm me mɨtɨk ik yaaik kɨre si mɨr. ");
INSERT INTO avt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɨtɨk ik hɨrak kɨre si, hɨrak kan tɨ. Hɨrak kɨkaap mɨt miyapɨr kerek nepu te hɨr nertei God. ");
INSERT INTO avt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nɨpaa God kɨrɨak tɨ keriuwerek, te mɨtɨk ik kan kau tɨ. Mɨt nau tɨ nepɨtari mɨtɨk ik hɨrak Mɨtɨk Iuwe kɨrɨak menmen im au. ");
INSERT INTO avt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hɨrak kan tɨ kerek nɨpaa hɨrak kɨrɨakek, te mɨt nɨrak en ne weiwɨk me Isrel neweikɨn sip newetɨwek. ");
INSERT INTO avt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Te mɨt han kerek nemtewek nisesik, hɨrak katɨp hɨram werek te hɨr nɨre nɨkerek ne God. ");
INSERT INTO avt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hɨr ap nɨre nɨkerek ne God nentar miye haai ninen au. Hɨr nɨkerek ne God nentar God kehimɨteni hɨr nɨrak. ");
INSERT INTO avt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mɨtɨk ik kan tɨ keit yɨnk kar ke haiu mɨt. Haiu mɨrek hɨrak Mɨtɨk Yaaik kɨre God, hɨrak kerekyei haiu mɨt menmen yaaim, hɨrak katɨp hɨm kemipɨn au. Hɨrak kɨrɨak menmen im yaaim kentar hɨrak Nɨkan kiutɨp kerekek God kɨrɨakek, te hɨrak mɨtɨk kar ek. ");
INSERT INTO avt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon kewepyapɨrek katɨp mɨt kar ik: “Mɨtɨk ik hɨrak mɨtɨk nɨpaa hi hetpiyek har ik: ‘Hɨrak kɨkaru kakwepyapɨr hɨm te hɨrak iuwe kinɨna kentar nɨpaa miye wina wen au, hɨrak kepu ketike God.’” ");
INSERT INTO avt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Haiu mɨt meit menmen yaaim me God mentar mɨtɨk ik ketenen menmen mɨrak yapɨrwe kewetaiyem keteipim keteipim. ");
INSERT INTO avt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nɨpaa God kewet Moses hɨm lo mɨrak hɨrak kewetaiyem haiu emisesim o au en, haiu mami. Te Jisas Krais kerekek kerekyei yaaim kewetai hɨm mɨrak ham yaaim. ");
INSERT INTO avt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mɨtɨk kiutɨp keiyak ap kɨr God au. Mɨtɨk kiutɨp kerekek hɨrak hɨrekes kɨre God kau ketikerek menep, hɨrak epei kewepyapɨrek keteiknaiyek te haiu mertei God hɨrak kɨre mekak. ");
INSERT INTO avt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wɨ ham mɨt iuwe naanmɨpre mɨt ne Isrel hɨr neriuwet mɨt pris netike mɨt han ne weiwɨk miutɨp me Livai kerek hɨr nɨkaap pris nɨrɨak menmen, hɨr nan nitehi Jon nar ik: “Ti hatɨp ti keimɨn?” ");
INSERT INTO avt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hɨrak kepakɨn au hɨrak kewepyapɨrem ketpor kar ik: “Hi ap Mɨtɨk God kehimɨtena hi akaap mɨt ne Isrel au.” ");
INSERT INTO avt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hɨr pɨke nitɨwekhi, “Ti ap Mɨtɨk God kehimɨtenut ti ekepai haiu mɨt ne Isrel au, te ti keimɨn? Ti mɨtɨk profet Ilaija o au?” Hɨrak ketpor: “Hi ap Ilaija au.” Hɨr nitɨwekhi neteipim: “Ti mɨtɨk profet haiu memeriyut ti enen o au?” Hɨrak katɨp: “Hi mɨtɨk profet ik au.” ");
INSERT INTO avt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hɨr netpɨwek: “Te ti keimɨn? Mɨt kerek neriuwetai haiu man in hanhan nanɨrtei ti atɨp mɨt ti keimɨn. Te ti etpai.” ");
INSERT INTO avt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ketpor kar ik: “Hi mɨtɨk ik ek. Hi mɨtɨk herp wit tenhaan weinɨk mɨt ap newi hi hɨnap hatɨp, ‘Yi mɨt einetɨt yayiwe eirɨakem yaaim te Mɨtɨk Iuwe kakitetik kaknen.’” Nɨpaa profet Aisaia hɨrak kewis hɨm im mau tɨwei. ");
INSERT INTO avt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mɨt ne Farisi kerek ninɨn nertei hɨm me Moses hɨr nisesim, hɨr keriyen neriuwet mɨt in nan nitehi Jon menmen im. ");
INSERT INTO avt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Te mɨt in hɨr nitehi Jon, “Ti ap Mɨtɨk God kehimɨtenut ti ekaap haiu mɨt ne Isrel, ti Ilaija au, ti mɨtɨk haiu memeriyut au, ti henmak te ti hɨkɨr mɨt miyapɨr neriuwe tɨpar a?” ");
INSERT INTO avt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Itai kai Jon ketpor, “Hi hɨkɨr mɨt neriuwe tɨpar weinɨm, te mɨtɨk kiutɨp kerp nɨmɨn ke yi mɨt yi yepɨtariyek. ");
INSERT INTO avt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hɨrak kisɨsa, te hɨrak Mɨtɨk Iuwe kinɨna, hi hɨre mɨtɨk enuk weinɨk.” ");
INSERT INTO avt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Menmen im man meit wit Betani meit menke men pɨnak ein ke mani Jodan kerek Jon kɨkɨri keitai en. ");
INSERT INTO avt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Maain wɨ ham itai kai Jon kɨr Jisas kaknen kakɨrek hɨrak katɨp, “Eiyɨrek! Mɨtɨk ik ek hɨrak kɨre Sipsip ke God. Hɨrak keriuwetek kan in kaki kakɨkrehɨr ke haiu mɨt te hɨrak kakɨsak menmen enum haiu mɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hɨrak mɨtɨk kerekek kerek nɨpaa hi etpiyek kerek maain kɨkaru kakisɨsa kaknen, hɨrak Mɨtɨk Iuwe kinɨna kentar nɨpaa hɨrak kinɨna kepu ketike God me wɨ miye ap wina wen au. ");
INSERT INTO avt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nɨpaa hi ap hertei hɨrak kakre keimɨn, te hi hɨkɨr mɨt har ik ek te hi eteikɨn yi mɨt ne Isrel yi eiyɨrtei hɨrak keimɨn.” ");
INSERT INTO avt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon katɨp hɨm im em me menmen hɨrak kɨrem. Hɨrak katɨp, “Hi hɨr God Hɨmɨn Yaaik kenke keke nepni kan kɨre hore tapɨ kan kenterik. ");
INSERT INTO avt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hi nɨpaa hepɨtari God kehimɨtanek hɨrak mɨtɨk kerek kakɨkepai, te God keriuweta hi akɨri eiriuwe tɨpar em, hɨrak ketpo, ‘Ti ahɨr God Hɨmɨn Yaaik kakɨnke kaknen kakɨkre mɨtɨk, mɨtɨk ik kerekek kakwet mɨt God Hɨmɨn Yaaik kaku kakreri.’ ");
INSERT INTO avt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Hi epei hɨrek, te hi etpi hɨrak Nɨkan ke God.” ");
INSERT INTO avt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Teipmen, itai kai Jon wen kepeit mani Jodan ketike mɨtɨkɨt disaipel wiketeret. ");
INSERT INTO avt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hɨrak kɨr Jisas kan ken te hɨrak katɨp, “Mɨtɨk ik hɨrak Sipsip ke God. Hɨrak keriuwetek kan kaki kakɨkaap haiu mɨt.” ");
INSERT INTO avt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mɨtɨkɨt wik temtau Jon katɨp kar ik, te hɨrakɨt tises Jisas ten tetikerek. ");
INSERT INTO avt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas keweikɨn kɨret tisesik, te hɨrak kitɨwekɨthi, “Yi yayɨr mekam?” Hɨrakɨt tetpɨwek, “Rabai, ti hau heit nein?” (Haiu meweikɨn hɨm Rabai hɨram matɨp Mɨtɨk Iuwe tisa.) ");
INSERT INTO avt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hɨrak katɨp, “Einen eiyɨrem.” Te hɨrakɨt tetikerek tariyakɨt ten tɨr wit kerek hɨrak kewiyen, te hɨrakɨt ten en tetikerek ere wɨtaan (Hɨram epei hɨnkewɨ te hɨrakɨt tetpɨwek menmen im.) ");
INSERT INTO avt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mɨtɨk hak niuk mɨrak Endru hɨrak nɨkik ke Saimon Pita hɨrak mɨtɨk kiutɨp ke mɨtɨkɨt wiketeret hɨrak kemtau hɨm me Jon te hɨrak kises Jisas. ");
INSERT INTO avt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Wasenum, mɨtɨk Endru kɨnaaiwɨr Jisas ken kɨnapɨn heiyiuwe kɨrak Saimon, hɨrak ketpɨwek, “Hawɨr epei wɨnapɨn Mɨtɨk Iuwe Mesaia.” (Haiu meweikɨn hɨm Mesaia haiu matɨp Krais, Mɨtɨk kerek God kehimɨtanek kakɨkaap haiu mɨt.) ");
INSERT INTO avt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hɨrak ketpɨwek epei au, Endru keithis Saimon keiyɨk ken kɨr Jisas. Jisas kɨrek, hɨrak ketpɨwek, “Ti Saimon nɨkan ke Jon. In ek hi eweikɨn niuk mit mamre Sifas.” (Haiu meweikɨn hɨm hɨram matɨp, “Pita” o “Nan”.) ");
INSERT INTO avt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wɨ ham Jisas kekrit kakno provins Galili. Hɨrak han kitet kakno en te hɨrak kɨnapɨn mɨtɨk Filip ketpɨwek kar ik: “Ti enen eisɨsa!” ");
INSERT INTO avt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip hɨrak ke wit Betsaida, wit ke Endru ketike Pita. ");
INSERT INTO avt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Te Filip kɨnapɨn Nataniel hɨrak ketpɨwek, “Haiu epei mɨnapɨn mɨtɨk kerek nɨpaa Moses kewisɨm mau tɨwei mɨrak, hɨrak ketike mɨt profet newisɨm mau tɨwei. Haiu epei mɨnapɨnek, hɨrak Jisas, nɨkan ke Josep ke Nasaret.” ");
INSERT INTO avt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel ketpɨwek, “Menmen mei miutɨp yaaim ap te mamɨke Nasaret mamnen auye!” Filip kewenhi ketpɨwek kar ik: “Ti eno ehɨrek.” ");
INSERT INTO avt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisas kɨr Nataniel kan kakɨrek, hɨrak katɨp, “Eiyɨrek. Hɨrak mɨtɨk ke Isrel ap kemipɨn au.” ");
INSERT INTO avt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel ketpɨwek, “Ti harkeik te ti herteiya?” Jisas ketpɨwek, “Filip kenɨnut wen au, hi hɨrit kerek ti hau hɨnɨk nu fik ek.” ");
INSERT INTO avt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel ketpɨwek kar ik: “Ti Mɨtɨk Iuwe, ti Nɨkan ke God kerekek. Ti Mɨtɨk Iuwe ehinɨn naanmamrai haiu mɨt ne Isrel.” ");
INSERT INTO avt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas ketpɨwek, “Hi hetput hi hɨrit hau hɨnɨk nu fik te me menmen in ti han kiteta hi Mɨtɨk Iuwe a? Hi hetput maain ti ehɨr menmen iuwe minɨn menmen im em.” ");
INSERT INTO avt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Te Jisas ketpor, “Hi hetpi werek. Yi maain yayɨr wit ke God kakwep te yi eiyɨr mɨt ensel ne God nanɨniu nanɨkiuwe nanɨntar hi Mɨtɨk ke wit ke Mɨtɨk Iuwe.” ");
INSERT INTO avt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wɨ wikak epei men, mɨtɨk ketike mɨte nanɨtan nanɨt wit Kena keit provins Galili. Jisas miye pɨrak hɨre wepeit en. ");
INSERT INTO avt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Te Jisas ketike mɨt disaipel nɨrak natɨp nanɨno nanɨri nanɨtan. ");
INSERT INTO avt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Maain hɨr naam tɨpar wain mɨr epei au, Jisas miye wetpɨwek war ik: “Hɨr naam tɨpar wain epei au mesi.” ");
INSERT INTO avt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisas ketpɨwe, “Ti ap etpo menmen hi ehisesim. Hɨram ap menmen mit. Au, hɨram menmen mai. Wɨ ap man wen au te hi hewepyapɨr hɨrekes hi keimɨn.” ");
INSERT INTO avt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Te Jisas miye pɨrak watɨp mɨt kerek nɨrɨak menmen me mɨt en, “Yi eirɨak menmen eiyises hɨm mɨrak kerek hɨrak ketpi ek.” ");
INSERT INTO avt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mɨt ne Isrel newis hɨm lo mau tɨwei matɨp hɨr naninɨn nankemyet his te hɨr nanɨm menmen. Me menmen im hɨr newis mɨn iuwe mar hispɨnak kiutɨp (6) (hɨram mɨre heurek nun) hɨram mepu. Hɨram iuwe te mamtenen tɨpar yapɨrwe (Mar ke heurek hiswiyen hiswiyen hiswiyen (30). ");
INSERT INTO avt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Te Jisas katɨp mɨt en, “Yi eiwen tɨpar emɨkre mɨn.” Te hɨr newen tɨpar mekrerem ere mau hɨm. ");
INSERT INTO avt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Epei au, hɨrak ketpor, “Yi eiwen tɨpar mei eiyɨm eino eiwet mɨtɨk naanmɨpre menmen me neitan em.” Hɨrak katɨp epei au, hɨr neiyɨm nen newet mɨtɨk ek em. ");
INSERT INTO avt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hɨr neiyɨm nen newetɨwekem, hɨrak kaam tɨpar mei kike kerek Jisas keweikɨnhis em mɨre tɨpar wain, hɨrak kepɨtari mɨt neit tɨpar wain im neit nein. (Te mɨt kerek nɨmɨan (o nɨmin) tɨpar im em hɨr nerteiyem.) Te hɨrak kenɨne mɨtɨk kerek keit mɨte ep hɨrak ketpɨwek kar ik: ");
INSERT INTO avt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Mɨt yapɨrwe newet mɨt tɨpar wain yaaim, hɨr ninɨn nanɨm, te maain hɨr netaritari, hɨr newetɨr tɨpar yaaim kike. Te ti au! Ti etenen tɨpar wain yaaim ti ewet mɨt em emakaru.” ");
INSERT INTO avt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Menmen im hɨram menmen iuwe Jisas kinɨn kɨrɨakem. Hɨrak kɨrɨakem keit Kena hɨrak wit kike ke provins Galili. Ik ek keteikɨn haiu mɨt disaipel nɨrak menmen iuwe God kewetɨwekem, te haiu han kitet hɨrak Mɨtɨk God keriuwetek kan kakɨkepai haiu mɨt. ");
INSERT INTO avt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Epei au, Jisas ketike miye pɨrak kikrek tɨrak netike mɨt disaipel nɨrak nen wit Kapaneam nau en wɨ ham. ");
INSERT INTO avt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wɨ Pasova menep mamnen te mɨt ne Isrel han tewenɨn nɨpaa God kenep mɨt ne Isip, te maamrer nɨr au. Me wɨ im Jisas ken wit iuwe Jerusalem. ");
INSERT INTO avt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hɨrak ken kekre wɨnak iuwe ke God, hɨrak kɨr mɨt kerek nesiuwe bulmakau metike sipsip, hore nɨmanp nanɨt pewek mamrerim. Hɨrak kɨr mɨt in netike mɨt han nau yeno hɨr neit pewek me mɨt nerer wit wit newetɨr pewek ham yaaim me Isrel. ");
INSERT INTO avt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hɨrak kɨr menmen im, Jisas keit waai kɨrɨakek kɨre nɨpɨn kɨwaaiyek kenep sipsip bulmakau. Mɨt nau yeno netenen pewek hɨrak kepɨri nen witeik. Hɨrak kepɨri nen wit eik, hɨrak kenke kɨnaan keit pewek mɨr kewɨrem mesikenɨk mɨwaai tɨ. ");
INSERT INTO avt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hɨrak katɨp mɨt kerek nesiuwe hore kar ik: “Yi eikinɨm eiyɨm eino wit eik. Hi hɨnapen yi yɨrɨak wɨnak ke Haai kai enuk kɨre wɨnak maket mɨt neiyɨk neisuwe menmen neitak.” ");
INSERT INTO avt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Haiu mɨt disaipel nɨrak han kitet hɨm nɨpaa haiu mekinaam mau tɨwei me God hɨram matɨp mar im: “Hi hanhan iuwe me naanmamprut wɨnak kit kaku werek werek.” ");
INSERT INTO avt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hɨrak kɨrɨak menmen im epei au, hɨr mɨt iuwe ne kaunsil ke Isrel nan netpɨwek, “Ti erɨak menmen iuwe manmen emteikɨn God kewisit te ti han hepɨr menmen im meit wɨnak iuwe kɨrak ik ek.” ");
INSERT INTO avt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisas ketpor kar ik: “Yi yaiwen wɨnak ke God ik ek, te wi wikak hi pɨke eimaak.” ");
INSERT INTO avt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hɨr pɨke netpɨwek, “Me 46 tito mɨt nime wɨnak iuwe ke God ik ek. Te ti hatɨp ti pɨke eimaak me wɨ wikak keremem a? Taauye!” ");
INSERT INTO avt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas ap katɨp me wɨnak ke God. Au, hɨrak katɨp me yɨnk kɨrak. ");
INSERT INTO avt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Te maain mɨt nenep Jisas kaki, God kɨkɨak hɨrak kekrit kepu, haiu mɨt disaipel nɨrak meket han hɨm nɨpaa hɨrak ketpim, te haiu mises hɨm nɨpaa God kewisɨm mau tɨwei. Hɨram metike hɨm me Jisas. ");
INSERT INTO avt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas wen kepu Jerusalem me wɨ Pasova, wɨ kerek mɨt han tewenɨn God kenep mɨt ne Isrel au, mɨt ne Isip keriyen. Me wɨ im mɨt yapɨrwe nisesik nentar menmen yaaim iuwe hɨr nɨrek hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Te Jisas ap kemtau hɨm hɨr netpɨwekem kisesim au. Hɨrak ap kewisi hɨr nehimɨtanek mɨtɨk iuwe king kɨr naanmɨpri au, kentar hɨrak kertei menmen mɨt ne tɨ hɨr hanhanem. ");
INSERT INTO avt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hɨrak epei kertei werek werek menmen mekre han ke mɨt ne tɨ ap mɨtɨk hak te kakinɨnek kertei han ke mɨt te hɨrak ketpɨwekem au. ");
INSERT INTO avt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mɨtɨk niuk mɨrak Nikodimas kepu. Hɨrak mɨtɨk hak ke mit ne Farisi kerek hɨr ninɨn nises hɨm me Moses. Hɨrak mɨtɨk iuwe hak ke mɨt kerek ninɨn naanmɨpre mɨt ne Isrel. ");
INSERT INTO avt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wɨtaan ham hɨrak kan kɨr Jisas ketpɨwek kar ik: “Mɨtɨk luwe, haiu mertei God keriuwetit ti han tɨ heteiknai menmen. God kekepit ti hɨrɨak menmen. Mɨt neiyan ap te nanrɨak menmen iuwe mamɨr ke tɨ hɨrɨakem taau!” ");
INSERT INTO avt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas ketpɨwek kar ik: “Hi hetput hɨm im em hɨram yaaim. Mɨtɨk ap kakweikɨn yaaik kakɨr ke nɨkan miye winaak ek, hɨrak ap te kaku kaktike God taau!” ");
INSERT INTO avt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas kitɨwekhi kar ik: “Markeik te mɨtɨk nepei enuk ke mɨtɨk hɨrak pɨke kakre mɨtɨk pipɨak. Hɨrak pɨke kaku kakɨkre tu ke miye pɨrak te hɨre pɨke wawinaak?” ");
INSERT INTO avt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas kewenhi ketpɨwek kar ik: “God ap te kakinɨn naanmampre mɨt ere mɨt han nankɨri nanriuwe tɨpar, God Hɨmɨn Yaaik kakrɨak hɨmɨn kɨr hɨrak yaaik. ");
INSERT INTO avt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mɨtɨk kerek miye winaak, hɨrak kɨre mɨtɨk kerekek. Mɨtɨk God Hɨmɨn Yaaik kakrɨakek hɨmɨn kɨrak hɨrak yaaik, hɨrak kɨre God. ");
INSERT INTO avt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ti ap han kekrit epɨpɨr entar hɨm im hi hetputem me yi yapɨrwe God Hɨmɨn Yaaik ekrekyi hɨmɨn ki hɨrak kakre yaaik. ");
INSERT INTO avt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nɨme mɨniu mepno in mepno ein. Yi yemtau hɨram matɨp, te yi ap yertei hɨram meke nein man, te mamno nein. God Hɨmɨn Yaaik hɨrak kɨre nɨme. Haiu mepɨtari karkeik hɨrak kɨrɨak menmen kɨkaap mɨt au.” ");
INSERT INTO avt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas kitɨwekhi kar ik: “Mamɨrkeik te menmen im em manmen?” ");
INSERT INTO avt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas ketpɨwek, “Ti mɨtɨk iuwe tisa ti hertei menmen yapɨrwe hinɨn mɨt ne Isrel, te ti ap hertei menmen im au a? Menmen mit! ");
INSERT INTO avt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hi hetput werek. Haiu matɨp menmen haiu epei merteiyem, haiu matɨp menmen haiu epei mɨrem. Te yi yeweikɨn sip yewet menmen haiu metpiyem. ");
INSERT INTO avt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Hi nepei hetpi menmen me tɨ im e te yi ap han kiketim yisesim au. Te hi hetpi me menmen me wit ke God, mamɨrkeik te yi yayɨmtau menmen hi etpiyem me wit ke God yi yayisesim a? Taauye! ");
INSERT INTO avt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mɨtɨk keiyak ap nɨpaa ken wit ke God heven au. Hi Mɨtɨk ke wit ke Mɨtɨk luwe kerekek, hi hɨnaaiwir wit kɨrak hekiuwe han tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nɨpaa Moses kɨkɨak manpen kau niu keit wit weinɨk mɨt ap newi. Mar im, mɨt nanwenkɨka hi Mɨtɨk ke wit ke Mɨtɨk luwe nanwisa antar nu tentarakɨt. ");
INSERT INTO avt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Te mɨt yapɨrwe kerek nises God, hɨr nanu nantikerek tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“God hanhan mɨt ne tɨ ik iuwe te hɨrak keriuwet nɨkan kɨrak kiutɨp kerekek kan tɨ ik. Te neimɨn kerek nanisesik, hɨr ap nani au. Hɨr nanu nanɨt nantike God tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God ap kesiuwe hi Nɨkan kɨrak hi han tɨ ik skelim mɨt au. Hi han hahi akaap mɨt ne tɨ ik. ");
INSERT INTO avt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Neimɨn nisɨsa hi Nɨkan ke God ap te God skelim hɨr nanɨno si au. Te neimɨn kerek ap nisɨsa hi Nɨkan ke God ehu, hɨrak God epei skelim mɨt in nentar hɨr ap han kitet he Nɨkan kiutɨp kerekek kɨrak ahɨsak menmen enum hɨr nirɨakem. ");
INSERT INTO avt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God skelim mɨt kakɨr ik. Hɨm mai yaaim mɨre wepni kɨr, hi han tɨ ik heteikɨn mɨt menmen me God. Te hɨr hanhan menmen enum me tɨ hɨram mɨre wɨtaan toto. Menmen yaaim em me God au. Hir hanhan menmen enum me tɨ nentar hɨr nɨrɨak menmen enum enum. ");
INSERT INTO avt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Neimɨn hɨr nɨrɨak menmen enum hɨr nɨre mɨt enun nepan ne menmen yaaim me God. Te hɨr ap nanɨnen nanises hi Nɨkan ke God nanɨntar hɨr nɨnapen hi ewepyapɨr menmen enum hɨr nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Te neimɨn hɨr hanhan nanrɨak menmen yaaim, hɨr nanɨnen hi Nɨkan ke God kerek hɨm mai yaaim hɨram mɨre wepni te hɨr nanteikɨn mɨt yapɨrwe hɨr nɨrɨak menmen yaaim God katɨp hɨr enrɨakem.” ");
INSERT INTO avt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jisas katɨp Nikodimas epei au, Jisas ketike mɨt disaipel nɨrak nɨnaaiwɨr Jerusalem nen wit hak kike ke Judia. Hɨrak kau en ketikeri wɨ ham, hɨr nɨkɨr mɨt miyapɨr neriuwe tɨpar. ");
INSERT INTO avt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon hɨrak kɨkɨr mɨt neriuwe tɨpar menep tɨ niuk mɨrak Inon, hɨrak menep wit Selim. Hɨrak kɨkɨr mɨt in kentar tɨpar yapɨrwe meitai. Mɨt nen nanɨrek te hɨrak kɨkɨri. ");
INSERT INTO avt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Mɨtɨk iuwe King Herot ap kewis Jon kekre wɨnak enuk ke gavman wen au.) ");
INSERT INTO avt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mɨt disaipel han ne Jon netike mɨtɨk hak ke Isrel hɨr nenehan nentar menmen me nɨkɨr mɨt neriuwe tɨpar nises hɨm mɨt ne Isrel nɨpaa nisesim. ");
INSERT INTO avt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Te hɨr nen Jon nitɨwekhi nar ik: “Mɨtɨk luwe, ti han kitet mɨtɨk kerek nɨpaa ketikewit yeit mani Jodan yeit pɨnak eik, kerek ti hatɨp hɨm mɨrak em? Hɨrak epei kɨkɨr in ek, te mɨt yapɨrwe nanɨno nanɨrek.” ");
INSERT INTO avt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ketpor, “God keit wit kɨrak Heven ap keriuwet mɨtɨk kiutɨp menmen hɨrak ap kaktɨwem au. ");
INSERT INTO avt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yi hɨras yertei hɨm mai kerek nɨpaa hi hetpim. Hi hatɨp har ik: ‘Hi ap Krais au. God keriuweta te hi hɨnɨn han hewepyapɨrek.’ ");
INSERT INTO avt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mɨtɨk kerek kakɨt mɨte hɨre mɨte pɨrak. Jisas hɨrak kɨre mɨtɨk ik. Mɨt nises hɨm mɨrak hɨr nɨre mɨte pɨrak. Mɨtɨk kerek wariyakɨt kɨrak kemtewek hɨrak kaknen ketpɨwek menmen, hɨrak han yaaik kar ke in ek hi han yaaik iuwe. Te hi ap yɨnk enuk hentar mɨt yapɨrwe nisesik au. In ek hi han yaaik iuwe. ");
INSERT INTO avt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hɨrak kakre Mɨtɨk luwe keit niuk iuwe, te hi au hi hɨre mɨtɨk weinɨk.” ");
INSERT INTO avt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jisas kerek keke wit ke God kan tɨ ik hɨrak kinɨn mɨt. Keimɨn hɨrak ke tɨ ik hɨrak mɨtɨk kerekek, hɨrak han kitet menmen me tɨ ik. Hɨrak kerek ke wit ke God hɨrak hɨrak kinɨn menmen yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hɨrak kewepyapɨr hɨm me menmen hɨrak epei kɨrem, menmen hɨrak apei kemtewem. Hɨrak kewepyapɨrem katɨp mɨt em te mɨtɨk keiyak ap kemtewem kisesim au. ");
INSERT INTO avt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mɨtɨk kerek hɨrak kemtau kises him mɨrak hɨrak keteikɨn mɨt han God hɨrak katɨp hɨm yaaim. ");
INSERT INTO avt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mɨtɨk kerek God keriuwetek hɨrak kakwepyapɨr hɨm me God kentar hɨrak kewetɨwek Hɨmɨn kɨrak Yaaik keneises han kɨrak kekepik kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","God Haai hanhan Nɨkan kɨrak, te hɨrak kewetɨwek menmen yapɨrwe meit his mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Neimɨn nises nɨkan ke God nanɨt hɨmɨn yaaik kaku kakɨt tipmain tipmain enum eik. Neimɨn neweikɨn sip newet hɨm me nɨkan ke God, hɨr ap te nanu nanɨt au. God han enuk kakriuweri. ");
INSERT INTO avt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Me wɨ im mɨt ne Farisi kerek ninɨn nises hɨm me Moses nemtau hɨm ham mar im: “Jisas keithis mɨt yapɨrwe te hɨrak kɨkɨri ninɨn Jon.” ");
INSERT INTO avt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Te Jisas hɨrekes ap kɨkɨr mɨt au. Hɨr mɨt disaipel nɨrak keriyen nɨkɨri. ");
INSERT INTO avt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jisas kertei menmen mɨt ne Farisi hɨr nemtewem, te hɨrak kɨnaaiwɨr provins Judia hɨrak pɨke kepno provins Galili. ");
INSERT INTO avt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te yayiwe hɨrak kitetik ek ken kerekir provins Sameria. ");
INSERT INTO avt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Te hɨrak ken wit hak iuwe ke Sameria niuk mɨrak Saika. Wit ik hɨrak menep tɨ me ni kerek nɨpaa enum eik Jekop epei kewet nɨkan kɨrak Josep em. ");
INSERT INTO avt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hei ke mɨt hɨr nanmɨan tɨpar keit in kerek nɨpaa maam ke Isrel hɨrak kekinɨk. Jisas hɨt mekek te hɨrak kau menep hei kerekek. Wepni nepei kan kau nɨmɨniuwe. ");
INSERT INTO avt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jisas kau en, mɨte hap pe Sameria wan waumɨan tɨpar. Te Jisas kitɨwehi, “Ti eweto tɨpar mei ehɨm.” ");
INSERT INTO avt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Hɨr mɨt disaipel ne Jisas epei nen wit eik nanwɨr pewek nanɨt menmen me hɨr nanɨm.) ");
INSERT INTO avt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mɨte pe Sameria wewenhi watɨp, “Ti mɨtɨk ke Isrel, hi mɨte pe Sameria. Kenmak te ti hitauhi tɨpar te ti ehɨm a?” (Mɨt ne Isrel ap te nanɨt menmen me Sameria mɨre tɨkenup wenkepye kerek naam menmen nekrerem em au. Hɨr han kitet God kaktɨp hɨr enun nanɨnterim.) ");
INSERT INTO avt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisas ketpɨwe, “Ti ertei werek menmen God kakweti yi mɨt em, ti hertei hi keimɨn hi hituthi, ‘Ti eweto tɨpar mei ehɨm’, te ti etpo, ‘Ti eweto tɨpar mei yaaim mamu mamɨt tipmain tipmain enum eik.’” ");
INSERT INTO avt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mɨte watɨp war ik, “Mɨtɨk Iuwe, ti ap heit menmen me tɨpar. Hei ke tɨpar ik hɨrak kesikekre. Te ti ehɨt tɨpar yaaim mamkaap haiu mɨt mamu werek tipmain tipmain enum eik ehɨt nein? ");
INSERT INTO avt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nɨpaa maam nɨpu kaiu Jekop kewetei hei ik. Hɨrak nɨpaa ketike nɨkerek, sipsip, bulmakau mɨrak, hɨr naam tɨpar im em. Ti are iuwe hinɨn maam kaiu Jekop?” ");
INSERT INTO avt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas kewenhi katɨp, “Mɨt yapɨrwe nanɨm tɨpar im em maain hɨr pɨke hɨm niu enuk (o mar kakwenkɨkor hɨm) nanɨm tɨpar meiyam. ");
INSERT INTO avt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Te neimɨn nanɨm tɨpar kerek hi ewetɨrem, maain hɨr ap te hɨr pɨke hɨm niu enuk (o mar kakwenkɨkor hɨm) au. Tɨpar kerek hi ewetɨrem hɨram mamre tɨpar mamɨkre han kɨr mamu mamɨt mamkaap mɨt nanu werek werek tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Hɨre pɨke witɨwekhi war ik: “Mɨtɨk Iuwe, ti eweto tɨpar mei im em. Te hi ap pɨke hɨm niu enuk (o mar kakwenkɨkor hɨm) au. Te maain hi ap pɨke anen in amɨan tɨpar mei au.” ");
INSERT INTO avt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisas ketpɨwe, “Ti eno enɨne mɨtɨk kit te ti pɨke enen in.” ");
INSERT INTO avt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mɨte watɨp, “Hi ap heit mɨtɨk au.” Jisas ketpɨwe, “Ti hatɨp ti mɨtɨk au. Ti atɨp werek. ");
INSERT INTO avt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nɨpaa ti heit mɨkaan nar hispɨnak (5). In ek mɨtɨk ti hau hetikerek hɨrak ap mɨtɨk kit. Ti epei hatɨp werek.” ");
INSERT INTO avt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hɨre wetpɨwek, “Mɨtɨk Iuwe, hi hertei ti hɨre mɨtɨk profet. ");
INSERT INTO avt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maamrer nai ne Sameria nises God newenɨpiyek neit mɨniu (o neiyɨp) ik ek. Te haiu emwenɨpi God emeitak. Te yi mɨt ne Isrel yatɨp wit iuwe Jerusalem hɨrak yaaik kerekek. Wit hak au.” ");
INSERT INTO avt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisas ketpɨwe, “Mɨte, ti ehises hɨm mai. Maain wɨ ham mamnen te yi mɨt ne tɨ yaiwenɨpi niuk me Haai kai yayɨt mɨniu (o neiyɨp) ik au, o yayɨt wit iuwe Jerusalem au.” ");
INSERT INTO avt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jisas ketpɨwe, “Yi mɨt ne Sameria ap yertei werek keimɨn yi yisesik yewenɨpiyek. Haiu mɨt ne Isrel mertei werek keimɨn haiu misesik mewenɨpiyek. Menmen God hɨrak kɨrɨakem keithis mɨt miyapɨr hɨr nisesik, hɨrak kewetaiyem. ");
INSERT INTO avt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wɨ epei mamnen menep te mɨt kerek hɨr yaain nises God Haai, hɨr nanwenɨpiyek neriuwe han kɨr. Te mɨt nar ik God Haai hanhan hɨr enisesik enwenɨpiyek. ");
INSERT INTO avt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God hɨrak Hɨmɨn Yaaik kerekek. Hɨr mɨt hɨr newenɨpi niuk mɨrak, hɨr enises menmen yaaim enwenɨpiyek enriuwe hɨmɨn kɨr yaaik.” ");
INSERT INTO avt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Te mɨte wetpɨwek, “Hi hertei maain mɨtɨk Mesaia kerek God kehimɨtanek kaknen, hɨr mɨt nenewek Krais, maain hɨrak kaknen hɨrak kakɨtpai menmen yapɨrwe.” ");
INSERT INTO avt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisas ketpɨwe kar ik: “Hi kerekek hi atɨp etikewit hi Krais.” ");
INSERT INTO avt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hɨrak katɨp kar ek, hɨr mɨt disaipel nɨrak hɨr nɨrek katɨp ketike mɨte hap, hɨr han kitet yapɨrwe. Te in ek mɨtɨk keiyak ap kitɨwehi kar ik: “Ti ehɨt mekam?” O hɨr nitɨwekhi, “Kenmak te ti hatɨp hetikerep?” ");
INSERT INTO avt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hɨre wɨnaaiwɨr heurek ke tɨpar mɨre, hɨre pɨke wen wit iuwe eik, te hɨre wen watɨp mɨt yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Hɨre wetpor, “Yi einen eiyɨr mɨtɨk ik. Hɨrak ketpo menmen yapɨrwe kerek hi nɨpaa hɨrɨakem. Hɨrak mɨtɨk Mesaia kerek God kehimɨtanek kakɨkaap haiu mɨt?” ");
INSERT INTO avt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hɨre wetpor, te hɨr nɨnaaiwɨr wit ek nen nanɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mɨte wen wit kɨre eik, mɨt disaipel natɨp Jisas, “Mɨtɨk Iuwe, ti ehɨm menmen.” ");
INSERT INTO avt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Te Jisas ketpor, “Hi menmen mai yi ap yerteiyem hi hahɨm.” ");
INSERT INTO avt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mɨt disaipel nɨrak hɨras natɨp nar ik: “Mɨtɨk keiyak ketɨwek menmen keiyɨm kan o?” ");
INSERT INTO avt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisas ketpor, “Menmen mai mar im: Hi hises hɨm me Haai hɨrak nɨpaa keriuweta te hi han. Hi arɨak wok mɨrak enemtɨn hɨram mar ke menmen hi ahɨm.” ");
INSERT INTO avt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yi mɨt yatɨp yar ik: “Wenke tekyaait (4) ere wɨ mamnen te haiu mamket menmen mau ni. Hi hetpi. Yi eiwaainaan heriyai heriyai eiyɨr ni werek werek. Teket epei me yaaim te yi eiketim mamnen. ");
INSERT INTO avt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mɨtɨk hɨrak kerek epei keit menmen, hɨrak keit pewek hɨram mamu werek. Hɨram mar ke hɨrak kari han ke mɨt hɨr enises hɨm me God te hɨr enu enɨt tipmain tipmain enuk eik. Mɨtɨk kerek kamɨr ni hɨrak ketike mɨtɨk kerek keit menmen me ni hɨrakɨt han yaaik tekiyakɨt. Mɨt han natɨp mɨt hɨm me God netike mɨt hɨr nari han ke mɨt hɨr nises hɨm me God hɨr nɨre mɨtɨkɨt wik it. ");
INSERT INTO avt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mar ek te hɨm im hɨram yaaim. ‘Mɨtɨk kiutɨp kamɨr menmen, maain mɨtɨk hak kakɨketim.’ ");
INSERT INTO avt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nɨpaa hi eriuweti yi yen yari han ke mɨt hɨr nises hɨm me God yar ke mɨtɨk kakɨt menmen epei me yaaim meit ni eim. Nɨpaa yi ap yen yetpor menmen, te yi yɨkɨak han kɨr te hɨr nanises hɨm me God. Mɨt han keriyen nɨrɨak menmen im. Te in ek yi yɨkaap mɨt hɨr nanises hɨm me God.” ");
INSERT INTO avt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Maain mɨt yapɨrwe ne wit kike Saika ke provins Sameria nises Jisas nentar hɨr nemtau hɨm me mɨte hɨre epei wetpor, “Hɨrak ketpo menmen yapɨrwe nɨpaa ein hi hɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Te mɨt ne Sameria nan nɨr Jisas hɨr netpɨwek eku ektikeri. Te hɨrak kau ketikeri neit wit eik wɨ wik. ");
INSERT INTO avt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mɨt han yapɨrwe hɨr nemtau hɨm mɨrak te hɨr nisesik. ");
INSERT INTO avt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Te hɨr natɨp mɨte, “In ek haiu memtau hɨm mɨrak te haiu misesim. Haiu ap misesim mentar menmen nɨpaa ti etpaiyem au. Haiu hɨras memtewem te haiu han kitet hɨrak Mɨtɨk Krais kerek God keriuwetek kaknen kakɨkaap haiu mɨt miyapɨr ne tɨ.” ");
INSERT INTO avt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wɨ wik epei au, Jisas kɨnaaiwɨr wit ik hɨrak ken Galili. ");
INSERT INTO avt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisas hɨrekes epei katɨp, “Mɨtɨk profet niuk mɨrak iuwe meit wit kɨrak au.” ");
INSERT INTO avt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te wɨ Jisas epei ken kiun provins Galili, mɨt nau en netpɨwek, “Ti yaaik ti han.” Hɨr netpɨwekem nentar hɨr hɨras nɨpaa nen nɨr menmen me wɨ Pasova neit Jerusalem me wɨ mɨt nererik han tewenɨn God nɨpaa kenep mɨt ne Isip hɨr naa. Te hɨr epei nɨr menmen yaaim hɨrak kɨrɨakem keit ein. ");
INSERT INTO avt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Epei au, Jisas pɨke ken wit Kena ke provins Galili, wit kerek nɨpaa hɨrak keweikɨn tɨpar weinɨm mɨre tɨpar wain. Mɨtɨk iuwe ke gavman keit Kapaneam kau in. Nɨkan kɨrak hɨrak kɨnap. ");
INSERT INTO avt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hɨrak kemtau Jisas epei kɨnaaiwɨr provins Judia kan Galili, te hɨrak ken kɨrek kitɨwekhi eknen ekɨkaap nɨkan kɨrak kɨnap. Nɨkan kɨrak epei menep kaki. ");
INSERT INTO avt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisas ketpɨwek, “Yi ap yɨr menmen iuwe hi arɨakem, te yi ap eiyɨmtau hɨm mai eiyisesim au.” ");
INSERT INTO avt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mɨtɨk iuwe ke gavman ketpɨwek, “Mɨtɨk Iuwe, ti esiukɨn, o au en, nɨkan kai kaki.” ");
INSERT INTO avt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisas ketpɨwek, “Ti eno! Nɨkan kit kaku werek.” Mɨtɨk ik kemtau hɨm me Jisas kisesim te hɨrak kɨnaiwɨrek ken. ");
INSERT INTO avt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hɨrak kepno wɨnak kɨrak, mɨt kerek nerekyɨwek menmen hɨr nan newenek yayiwe hɨr netpɨwek, “Nɨkan kit epei kɨre yaaik.” ");
INSERT INTO avt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hɨrak kitorhi, “Kewaai meruri nɨkan kai hɨrak kɨre yaaik?” Hɨr netpɨwek, “Nepɨp wepni kau nɨmɨniuwe hɨrak yɨnk sisi epei au meit.” ");
INSERT INTO avt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Te haai kertei me nepɨp wepni kau nɨmɨniuwe, Jisas ketpɨwek nɨkan kaku werek. Te hɨrak ketike mɨte nɨkerek nɨrak hɨr nises hɨm me Jisas. ");
INSERT INTO avt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Menmen im hɨram menmen yaaim wik hɨrak kɨrɨakem me wɨ hɨrak kɨnaaiwɨr Provins Judia ken kiun provins Galili. ");
INSERT INTO avt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jisas kɨkaap nɨkan ke mɨtɨk iuwe epei au, wɨ ham kerek mɨt ne Isrel nererik naam menmen epei man. Te Jisas pɨke ken Jerusalem. ");
INSERT INTO avt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Meit Jerusalem menep weipɨr iuwe ke sipsip, wanwerweik iuwe kɨwaairi. Mɨt natɨp hɨm Hibru hɨr nenewek Betesda. Menep wan werweik kerekek mɨt newep weisaak hispɨnak (5) te mɨt nɨnapen wepni o hawɨ te hɨr nɨsawɨn newim. ");
INSERT INTO avt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mɨt miyapɨr yapɨrwe kerek hɨr nɨnap hɨr nɨwaairi. Hɨr mɨt han nanamɨr toto, mɨt han his hɨt mɨn enum, mɨt han his hɨt epei maa. ");
INSERT INTO avt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Wɨ ham mɨtɨk ensel ke Mɨtɨk Iuwe God kenke kan wan kerekek te hɨram tɨpar mɨtanɨk. Tɨpar mɨtanɨk nepei au, mɨtɨk kinɨn kakɨkwe kakno kakɨkre tɨpar, hɨrak kakre yaaik. ");
INSERT INTO avt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mɨtɨk kiutɨp kau weisaak nɨpaa hɨrak kɨnap ere 38 tito. ");
INSERT INTO avt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas kɨr mɨtɨk ik kɨpwaai en, hɨrak kertei hɨrak kɨnap kɨwaai wɨ yapɨrwe, te Jisas ketpɨwek kar ik: “Ti hanhan ti pɨke are yaaik a?” ");
INSERT INTO avt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mɨtɨk ik kerek kɨnap hɨrak ketpɨwek, “Mɨtɨk Iuwe, kerek tɨpar mɨrirɨr, hi ap mɨt nei nekina newisa hekre tɨpar au. Hi hɨrekes eno, mɨt han hɨr nɨnatɨn nan ninɨna.” ");
INSERT INTO avt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisas ketpɨwek, “Ti ekrit ehɨrp ehɨt yeno mit eiyɨm eno.” ");
INSERT INTO avt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wasenum hɨrak mɨtɨk kɨnap ek hɨrak kɨre yaaik. Hɨrak keit yeno mɨrak keiyɨm ken. Wɨ im hɨram wɨ Sabat. ");
INSERT INTO avt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mɨt iuwe ne Isrel nɨr mɨtɨk ik kemerɨr yeno mɨrak te hɨr nenerek netpɨwek, “Petepin hɨram wɨ Sabat. Wɨ im em ti ap emerɨr yeno mit emɨt!” ");
INSERT INTO avt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hɨrak kewenhi ketpor, “Hɨrak mɨtɨk kerekya hi hɨre yaaik ketpo, ‘Ekin yeno mit eiyɨm ekrit eno.’” ");
INSERT INTO avt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hɨr nitɨwekhi, “Keimɨn hɨrak ketput ti ekin yeno mit eiyɨm ekrit eno a?” ");
INSERT INTO avt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mɨtɨk kerek Jisas kekepik ap kertei hɨrak keimɨn kentar Jisas kɨnaiwɨrek ken ek, mɨt yapɨrwe nererik neit wit eik e. ");
INSERT INTO avt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Maain Jisas kɨnapɨnek keit wɨnak iuwe ke God hɨrak ketpɨwek, “Ti epei hɨre yaaik. Ti ap pɨke hanhan ehises menmen enum te menmen ham iuwe enum mamnen mamwit.” ");
INSERT INTO avt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hɨrak ketpɨwek epei au, mɨtɨk ik ken katɨp mɨt iuwe ne Isrel kar ik: “Mɨtɨk kerekek kerekya hi yaaik hɨrak Jisas.” ");
INSERT INTO avt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hɨrak ketpor Jisas kekepik te mɨt iuwe ne Isrel hɨr ninɨn nɨrɨak Jisas enum nentar hɨrak kɨkaap mɨtɨk enuk kɨnap iuwe hɨrak kɨre yaaik me wɨ Sabat (kerek mɨt nɨrɨak menmen au. Hɨr nau weinɨm.) ");
INSERT INTO avt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hɨr natɨp Jisas enum nenerek, te hɨrak ketpor, “Hekrit hekrit Haai kai kɨrɨak menmen, te hi arɨakem har ke hɨrak kɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hɨm im kerek Jisas ketpim mɨrɨak mɨt iuwe ne Isrel han enuk iuwe te hɨr hanhan nanɨnep Jisas kaki. Hɨr hanhan nankɨp kentar hɨrak kɨkaap mɨtɨk ke wɨ Sabat kerekek au. Hɨr han enuk nankɨp nanɨntar hɨrak katɨp God hɨrekes Haai kɨrak, te hɨrak kɨrɨak hɨrekes iuwe kɨre God Haai. ");
INSERT INTO avt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mɨt iuwe ne Isrel nenerek, te Jisas ketpor, “Hi etpi hɨm yaaim! Hi Nɨkan ap te hi hɨrekes arɨak menmen mei weinɨm me han kai au. Hi hɨrɨak menmen mamɨr ke hi hɨr Haai kai kɨrɨakem. Haai kai kɨrɨak menmen, hi herteiyem te hi hɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Haai hɨrak hanhan keriuwa hi Nɨkan kɨrak, hɨrak keteikno menmen iuwe hɨrak kɨrɨakem. Maain hɨrak kakteikno menmen iuwe minɨn menmen hi epei hɨrɨakem te yi yapɨrwe han kakɨkrit kakriuwerem. ");
INSERT INTO avt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hɨram mar ke Haai kɨkɨan mɨt kerek epei naa ek te hɨr pɨke nekrit nau, te hi nɨkan kɨrak ehises han kai awis hɨmɨn yaaik kaku kakɨkre han ke mɨt kerek hi hanhan hewisɨk kakɨkre han kɨr. ");
INSERT INTO avt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Haai kai hɨrekes ap skelim mɨt au. Hɨrak kewisa hi Nɨkan kɨrak hi ekrehɨr kɨrak hi skelim mɨt. ");
INSERT INTO avt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Te mɨt yapɨrwe nanwenɨpi niuk me hi Nɨkan mamɨr ke hɨr newenɨpi niuk me Haai kai. Mɨt kerek ap newenɨpi niuk me hi Nɨkan, hɨr ap nanwenɨpi niuk me Haai kai kerek keriuweta hi han in. ");
INSERT INTO avt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Hi hetpi hɨm yaaim. Neimɨn nemtau hɨm mai hɨr nisesim, te hɨr nanises hɨm me hɨrak kerek keriuweta hi han in, te hɨr nanɨt hɨmɨn yaaik kaku kakɨt tipmain tipmain enum eik. Hi ap te skelim mɨt au. Hɨr nepei nɨnaaiwɨr menmen enum, hɨr neit hɨmɨn yaaik nanu werek. ");
INSERT INTO avt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hi hetpi hɨm yaaim. Wɨ kerek nɨpaa God kehimɨtanem hɨram epei man, te mɨt nɨpaa naa hɨr nanɨmtau hɨm me hi Nɨkan ke Mɨtɨk Iuwe God. Te neimɨn nanɨmtewem, hɨr nanɨt hɨmɨn yaaik nanu werek. ");
INSERT INTO avt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","God Haai hɨrak kaki au. Hɨrak Haai ke menmen mamkaap menmen yapɨrwe mamu mamɨt. Te hɨrak keweto hi Nɨkan kɨrak menmen te hi ap hahi au. Hi hetenen menmen im te hi akaap mɨt miyapɨr te hɨr nanu nanɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hɨrak kewisa hi Iuwe hi skelim mɨt hentar hi Mɨtɨk ke wit kɨrak. ");
INSERT INTO avt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yi ap han kekrit ke menmen im epei au emɨt. Wɨ mamnen te mɨt kerek nɨpaa naa mɨt newisi nekre hei nanɨmtau hɨm me hi Nɨkan ke Mɨtɨk Iuwe. ");
INSERT INTO avt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Te hɨr nanɨnaaiwɨr hei, hɨr nanɨtpaan nanɨnen witik. Neimɨn kerek nɨpaa nɨrɨak menmen yaaim e, hɨr nanɨkrit nanu nanɨt. Te mɨt nipaa nɨrɨak enum, hɨr nanɨkrit nanɨno si enum. ");
INSERT INTO avt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Hi ap hɨrɨak menmen hises han kai au. Menmen hi hemtau God ketpewem te hi hisesim skelim mɨt ariuwerem. Hi skelim mɨt werek werek hentar hi ap hises han kai. Hi hises han ke God kerek keriuweta te hi han tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Te hi kerekek etpi menmen me hi hɨrekes yi han kitet hi hemipɨn. ");
INSERT INTO avt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mɨtɨk kiutɨp kepu kewepayapɨr hɨm mai. Hi hertei hɨm im hɨram matɨp mɨt me hi hɨram hɨm yaaim. ");
INSERT INTO avt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yi nɨpaa yesiuwe mɨt hɨr nen nɨr Jon nitɨwekhi menmen, te hɨrak ketpi hɨm im me hi hɨram yaaim. ");
INSERT INTO avt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hi ap han kitet yapɨrwe me mɨtɨk hɨrak kewepyapɨr niuk mai au. Hi hetpiyem te yi eiyɨrteiyem eiyises hɨm mai te God kakɨkepi yi eiyu eitikerek eiyu werek werek. ");
INSERT INTO avt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon hɨrak kɨre si keteikni yayiwe, hɨrak keteikni menmen me God. Me wɨ hɨrak kepu yi hanhan yisesik. ");
INSERT INTO avt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Menmen ham minɨn hɨm nɨpaa Jon ketpim me hi. Hɨram im. Menmen yaaim haai kai ketpo hi hɨrɨakem. Menmen ham nɨpaa hi hɨrɨakem, hɨram meteikɨn mɨt miyapɨr te hɨr nertei Haai kai God keriuweta te hi han in. ");
INSERT INTO avt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Haai kerek keriuweta hi han in, hɨrak kewepayapɨr ketpi hi keimɨn. Te yi ap yemtau hɨm mɨrak au. Yi ap nɨpaa yɨr ninaan mɨrak au. ");
INSERT INTO avt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hɨm mɨrak ap mau mekre han ki. Yi ap yemtau hɨm me hɨrak Mɨtɨk Iuwe kerek keriuweta hi han tɨ ik. ");
INSERT INTO avt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yi han kitet hɨm me God mau tɨwei, yi yekinaam te yi han kitet hɨram mamkepi yi eiyu eitike God, God kakweti hɨmɨn yaaik te yi eiyu tipmain tipmain enum eik. Te hɨm im yi yekinaam hɨram matɨp me hi! ");
INSERT INTO avt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Te yi yɨnapen eiyɨmtau hɨm mai te hi akepi yi eiyɨt hɨmɨn yaaik te yi eiyu eiyɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Hi ap hanhan mɨt nanwenɨpi niuk mai nantɨp hi yaaik. Hɨram menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Te hi hertei yi mɨt yi yɨre mekak. Yi ap hanhan God yekre han ki au. ");
INSERT INTO avt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Hi han hekrehɨr ke Haai kai, te yi ap yises hɨm mai au. Mɨt han ne tɨ hɨr nanɨnen netpi hɨr mɨt iuwe, yi yemtau hɨm mɨr yisesim. Te yi ap yemtau hɨm mai au! ");
INSERT INTO avt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yi mɨt hanhan yaiwenɨpiyan niuk mi, te yi yɨnapen Mɨtɨk Iuwe kiutɨp hɨrak God hɨrak kakwenɨpi niuk mi kakɨtpi yi yaain. Yi han kitet menmen im hɨram weinɨm. Yi ap hanhan hɨrak kaktɨp yi yaain, te yayɨrkeik te yi hanhan eiyises hɨm mai? ");
INSERT INTO avt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yi ap han ekitet hi esiuwi hɨm hatɨp Haai kai me menmen yi yɨrɨakem. Au, hɨm kerek Moses kewisɨm mau tɨwei kerek yi yekinaam han kitet hɨram mamkepi te God kaktɨp yi yaain, hɨram mamsiuwi hɨm. ");
INSERT INTO avt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yi yises hɨm me Moses werek werek, te yi eiyises hɨm mai yentar hɨrak kewis hɨm me hi. ");
INSERT INTO avt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Te yi ap yises hɨm Moses kewisɨm mau tɨwei, te yi ap eiyises menmen hi hetpiyem au!” ");
INSERT INTO avt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jisas ketpor menmen im epei au, hɨrak ken kerekir wan iuwe ke Galili (kerek mɨt nenewek niuk ham Wan ke Taibirias). ");
INSERT INTO avt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mɨt yapɨrwe nises Jisas nentar hɨr nɨpaa nɨr menmen iuwe hɨrak kɨrɨakem kɨkaap mɨt nɨnaap. Mar ik te hɨr nisesik. ");
INSERT INTO avt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas ken kɨniu mɨniu wank ken kau ketike mɨt disaipel nɨrak. ");
INSERT INTO avt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wɨ Pasova man menep. Hɨram wɨ kerek mɨt ne Isrel nererik naam menmen han tewenɨn wɨ nɨpaa God kenep mɨt ne Isip, kɨkaap mɨt ne Isrel. ");
INSERT INTO avt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas kerenaan kɨr mɨt miyapɨr yapɨrwe nan nɨrek. Te hɨrak katɨp Filip, “Haiu mamɨt niu o bret mamɨt nein te haiu mamwet mɨt miyapɨr em hɨr nanɨm?” ");
INSERT INTO avt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Jisas katɨp mɨtɨk Filip hɨm im em te hɨrak kakri han kɨrak kakises mekam. Jisas epei kertei menmen hɨrekes kakrɨakem.) ");
INSERT INTO avt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip kewenhi ketpɨwek kar ik: “Haiu mewɨr 200 kina mamɨt niu o bret meriuwerem hɨram ap werek te mɨt in nanɨm kike kike au.” ");
INSERT INTO avt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Disaipel ke Jisas niuk mɨrak Endru, hɨrak nɨkik ke Saimon Pita hɨrak katɨp Jisas kar ik: ");
INSERT INTO avt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mɨtɨk pipɨak ik e keit bret bali mar hispɨnak (5) metike saauk wik. Te hɨram ap iuwe me mɨt yapɨrwe nar ik.” ");
INSERT INTO avt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisas ketpor, “Yi eiwen mɨt miyapɨr enu tɨ. Yenkis yapɨrwe meit in.” Te mɨt 5,000 hɨr yapɨrwe keriyen nererik nau yenkis keremem nau tɨ. ");
INSERT INTO avt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Hɨr nau tɨ epei au, te Jisas keit bret keiyɨm kitehi God, te hɨrak kewenem keketim kewet mɨt nɨrak em hɨr newet mɨt miyapɨr em. Epei au, hɨrak keit saauk kewepim kewetɨrem kar ke nepei ein hɨrak kewetɨr bret bali, te hɨrak kewet mɨt menmen mar ke hɨr hanhanem. ");
INSERT INTO avt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hɨr epei naam tu iuwe, Jisas katɨp mɨt disaipel nɨrak kar ik: “Eikinen yinam yinam mɨt ap naam. Hi hɨnapen hɨr nanwɨsim mamu tɨ. Yi ap eiwis mei kike mamu au.” ");
INSERT INTO avt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hɨrak katɨp epei au, hɨr nekorɨrim (o nekurerim) ere epei au mesi, te hɨr nemi mekre tanɨk mar hiswiyen wik (12) meke bret hispɨnak (5) nɨpaa Jisas ketɨwem kewet mɨt em hɨr naam. ");
INSERT INTO avt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mɨt miyapɨr nɨr menmen yaaim Jisas kɨrɨakem te hɨr natɨp, “Hɨram hɨm yaaim. Mɨtɨk ik hɨrak profet ik ek kaknen tɨ.” ");
INSERT INTO avt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas kertei hɨr hanhan nantenenik nanɨhimɨtanek hɨrak mɨtɨk iuwe king kɨr hɨrak kaku kakinɨn naanmɨpror. Te hɨrak kɨnaiwɨri hɨrak kerekek pɨke ken mɨniu (o neiyɨp) eik. ");
INSERT INTO avt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Me hɨnkewɨ disaipel ne Jisas hɨr nekiuwe nen wan eik. ");
INSERT INTO avt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Hɨr nehɨn nɨniu nekre bot newik nerekir wan nanɨno pɨnak ein. Hɨr nen Kapaneam. Nepei au wɨtaan, te Jisas ap kan kiunor wen au. ");
INSERT INTO avt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","In ek nɨme iuwe mɨniu te wan kewenɨn iuwe. ");
INSERT INTO avt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hɨr neit niu mɨrak neiyɨk nari wan ere 5 o 6 kilomita nau nɨmɨn, hɨr nɨr Jisas kitet wan kitet tɨpar keke niu ken menep bot. Hɨr nɨrek te hɨr nɨnaain. ");
INSERT INTO avt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Te Jisas ketpor, “Hi kerekek han. Yi ap einaain.” ");
INSERT INTO avt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hɨrak ketpor te hɨr han yaaik netɨwekhis kɨniu ketikeri nekre bot. Te wasenum bot kepno menep wit hɨr hanhan nanɨnori. ");
INSERT INTO avt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hekrit eik, mɨt miyapɨr hɨr wen nepeit wan pɨnak eik, hɨr nertei nepɨp bot ap keiyak kepu au. Kiutɨp kerekek kepu, Jisas ap kau ketike disaipel au. Hɨr disaipel keriyen nekre bot ik ek te hɨr nen. ");
INSERT INTO avt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Te bot ham me Taibirias man menep wit kerek Jisas kewetɨr bret hɨr naam newi. ");
INSERT INTO avt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mɨt yapɨrwe nɨr Jisas hɨrak ap ketike mɨt disaipel ap nau, te hɨr nehɨn nekre bot hak, hɨr nen Kapaneam nɨnetnɨwek. ");
INSERT INTO avt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Maain mɨt nɨnapɨn Jisas keit wan pɨnak ein epei au, hɨr netpɨwek, “Mɨtɨk Iuwe, hewaai meruri te ti han in a?” ");
INSERT INTO avt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisas kewenhi ketpor, “Hi hetpi werek. Yi yɨnyetno yentar yi epei yaak bret ere tu iuwe. Yi ap han kitet menmen yaaim iuwe hi hɨrɨakem au. ");
INSERT INTO avt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yi ap hanhan yayɨt menmen me yayɨm keremem hɨram mamɨwaank au ekɨt! Yi hanhan eiyɨt menmen yaaim hɨram mɨre menmen me yi eiyɨm, hɨram mamkepi te yi yayɨt hɨmɨn yaaik ke kaku kakɨt tipmain tipmain enum eik. Menmen im hi Mɨtɨk ke wit ke Mɨtɨk Iuwe awetiyem hentar God Haai kɨrɨak menmen keteikɨn mɨt hɨrak keriuweta hi hɨrɨak menmen mɨrak.” ");
INSERT INTO avt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hɨrak ketpor hɨm im, te hɨr nitɨwekhi natɨp nar ik: “Haiu emrɨak mekam te haiu emrɨak menmen God han yaaik keriuwerem?” ");
INSERT INTO avt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisas kewenhi ketpor, “Menmen yi yɨrɨakem God han yaaik keriuwerem hɨram im. Yi eiyises hɨm me hi Mɨtɨk kerek God keriuweta hi han tɨ ik.” ");
INSERT INTO avt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hɨr newenhi natɨp, “Ti erɨak mekam iuwe te haiu emɨrem te haiu emises hɨm mit a? ");
INSERT INTO avt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maamrer naiu naam menmen niuk mɨram mana neit wit weinɨk mɨt ap newi en. Hɨm me God matɨp Moses kewetɨr menmen meke wit ke God hɨr naam.” ");
INSERT INTO avt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisas ketpor, “Hi hetpi werek. Moses kewetɨr menmen au. Haai kai kewetɨrem. Menmen me nɨpaa hɨram ap bret yaaim mamkaap hɨmɨn ki au. In ek Haai kai kerekek keweti menmen yaaim me wit kɨrak, hɨram yaaim mɨre bret mamkaap hɨmɨn ki kaku werek. ");
INSERT INTO avt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bret God kewetiyek ek, hi Jisas kerek heke wit ke Mɨtɨk Iuwe han hi bret ik. Hi aweti hɨmɨn yaaik kaku kakɨkri tipmain tipmain enuk eik.” ");
INSERT INTO avt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hɨr nitɨwekhi nar ik: “Mɨtɨk Iuwe, ti ewetai bret kit eknen in ere tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisas ketpor, “Hi hɨrekes hɨre bret hɨkaap mɨt nanu nanɨt hɨmɨn yaaik. Hɨr neimɨn nanisɨsa te hɨr ap nɨnpɨ mamɨn. Neimɨn hɨr nanisɨsa ap te hɨm niu enuk (o mar kakwenkɨkor hɨm) hanhan nanɨm tɨpar mei au. Neimɨn hɨr nanisɨsa ap te hɨm niu enuk (o mar kakwenkɨkor hɨm) hanhan nanɨm tɨpar mei au. ");
INSERT INTO avt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Hi hetpi yi epei yɨra te yi ap yises menmen hi etpiyem. ");
INSERT INTO avt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mɨt neimɨn kerek Haai kai God kewetauri, hɨr nanɨnen nanisɨsa. Hi ap te aweikɨn sip ewet neimɨn kerek nanɨnen nanisɨsa au. ");
INSERT INTO avt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hi hɨnaaiwɨr wit ke God te hi hises han kai au. Hi hises han ke hɨrak Mɨtɨk Iuwe kerek keriuweta hi han tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hɨrak kerek keriuweta hi han tɨ ik hɨrak hanhan menmen im. Hɨrak hanhan hi ap hɨnaaiwɨr mɨtɨk kiutɨp ke mɨt yapɨrwe hɨrak epei keriuweti au. Hi akɨan mɨt miyapɨr yapɨrwe nanɨkrit nanu me wɨ maain God skelim mɨt. ");
INSERT INTO avt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Menmen im Haai kai God hanhanem hɨram im: Neimɨn nɨra hi Nɨkan kɨrak, hɨr nisɨsa nanɨmtau hɨm mai, hɨr nanɨt hɨmɨn yaaik kaku kakɨt tipmain tipmain enum eik, te hi akɨan nanu nanɨt me wɨ maain God skelim mɨt.” ");
INSERT INTO avt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hɨrak katɨp epei au, mɨt ne Isrel natɨpan nen Jisas nentar hɨrak katɨp hɨm im: “Hi bret kerek heke wit ke God hi han in.” ");
INSERT INTO avt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Te hɨr natɨp, “Mɨtɨk ik hɨrak kerekek nɨkan ke Josep. Haiu mertei miye haai nɨrak. Kenmak te hɨrak katɨp hɨrak keke wit ke God kan a?” ");
INSERT INTO avt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas kewenhi ketpor, “Yi ap eitɨp einehan me yi hɨras emɨt! ");
INSERT INTO avt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mɨtɨk kiutɨp ap te kakisɨsa ere God Haai kerek keriuweta hi han hɨrak kakri han kɨrak. Hi akɨak hɨrak kakɨt hɨmɨn yaaik ke kaku kakɨt me wɨ maain God skelim mɨt. ");
INSERT INTO avt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mɨt profet newis hɨm im mau tɨwei hɨram matɨp mar im: ‘Mɨt yapɨrwe te God kakɨtpor menmen kakɨkepi werek werek.’ Mɨt neimɨn niutɨp niutɨp kerek epei nemtau hɨm me Haai kai God te hɨr nanisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mɨtɨk kiutɨp ke mɨt yapɨrwe ap te kɨr God Haai ek au. Hi Mɨtɨk kerek God keriuweta hi han tɨ ik ek, hi kerekek epei hɨrek. ");
INSERT INTO avt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hi hetpi werek. Hɨrak keimɨn kises hɨm mai kakɨt hɨmɨn yaaik ke kaku kakɨt tipmain tipmain emum eik. ");
INSERT INTO avt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hi hɨrekes kerekek hɨre bret, hi akaap mɨt nanu nanɨt tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Maamrer ni nɨpaa naam menmen mana God kewetɨrem neit wit weinɨk mɨt ap newi, te hɨr ap nepu au. Hɨr epei naa. ");
INSERT INTO avt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hi Mɨtɨk kerek hɨnaaiwɨr wit ke God han tɨ ik ek hi hɨre bret mɨkaap mɨt nanu. Neimɨn nisɨsa hɨr nani au. Hɨr nanu tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Hi hɨre bret akaap mɨt nanu nanɨt tipmain tipmain enum eik. Hi heke wit ke God han. Mɨt kerek nanɨm bret im hɨr nanu nanɨt tipmain tipmain enum eik. Bret im hɨram yɨnk kai kerek hi hewet mɨt ne tɨ hɨr nanɨm te hi akepi hɨr nanɨt hɨmɨn yaaik.” ");
INSERT INTO avt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Menmen im hɨrak ketpor menip mɨt ne Isrel nenehan natɨpan hɨm me hɨr hɨras, hɨr natɨp nar ik: “Mɨtɨk ik kakɨrkeik te hɨrak kakwetei naan me yɨnk kɨrak haiu mamɨk a? Taauye!” ");
INSERT INTO avt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisas ketpor, “Hi hetpi werek. Yi ap yayɨk yɨnk kai ke hi Mɨtɨk ke wit ke Mɨtɨk Iuwe, o yi ap yayɨm hemkre mai, te yi ap yayɨt hɨmɨn yaaik kakɨkri. ");
INSERT INTO avt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Neimɨn nanɨk yɨnk kai o nanɨm hemkre mai, hɨr nanɨt hɨmɨn yaaik. Te hi akɨan hɨr mɨt kerek nɨpaa naa, hɨr pɨke nanɨkrit nanu nanre mɨt me wɨ maain God skelim mɨt. ");
INSERT INTO avt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yɨnk kai hɨrak menmen yaaik kɨre samiyak kakɨkepi. Hemkre mai hɨram mɨre tɨpar yaaim mamkepi. ");
INSERT INTO avt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Neimɨn naak yɨnk kai ketike hemkre mai, hɨr nau netikewa nises hɨm mai, te hi hau hekre han kɨr ");
INSERT INTO avt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","God kerek hɨrak Haai ke menmen yapɨrwe mepu, hɨrak keriuweta hi han, hɨrak kenipa hi ahu tipmain tipmain enum eik. Neimɨn nanɨk yɨnk kai hɨr nanu nanɨt nanriuwerek. ");
INSERT INTO avt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hi hɨrekes hi hɨre bret keke wit ke God kan. Bret ik hɨrak ap kɨre menmen nɨpaa maamrer ni nɨpaa naam au. Hɨr naam ere hɨr ne mɨt te hɨr naa. Neimɨn nanɨk bret ik hɨrak yaaik kakɨkepi te hɨr nanu nanɨt tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas katɨp mɨt menmen im keit wɨnak kerek mɨt nererik nekine hɨm me Moses neitai en neit wit Kapaneam. ");
INSERT INTO avt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mɨt yapɨrwe kerek nɨpaa nises hɨm mɨrak nemtau menmen im epei au, hɨr natɨp, “Hɨm im hɨram enum merekyei han enuk. Neimɨn nanu nanɨmtau hɨm mamɨr im a? Taauye!” ");
INSERT INTO avt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas epei kertei kekre han kɨrak hɨr mɨt disaipel nɨrak natɨpan menmen im hɨrak ketpor kar ik: “Hɨm mai merekyi te yi han enuk a? ");
INSERT INTO avt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Maain yi eiyɨr hi Mɨtɨk ke wit ke Mɨtɨk Iuwe hi pɨke hɨniu eno wit kerek nɨpaa hi hewik, te yi han enuk yeriuwa wɨsenum a! ");
INSERT INTO avt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yi mɨt hɨras ap te eikaap hɨras te yi yayu tipmain tipmain enum eik taau. God Hɨmɨn Yaaik kerekek kakɨkepi. Hɨm im hi epei hetpim em, hɨram mamkepi hɨmɨn ki te yi yayu tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Te mɨt han ne yi mɨt ap yisɨsa au.” (Jisas epei kertei wɨ kerek hɨrak kehimɨtan mɨt disaipel nɨrak, keimɨn ap kakisesik kakwepyapɨrek kakwet mɨt enun nepan ek hɨr neiyɨk nanɨno nankɨp.) ");
INSERT INTO avt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jisas wen katɨp, “Nɨpaa hi hetpi ap mɨtɨk keimɨn kisɨsa ere God Haai kakri han kɨrak hɨrak kakisɨsa.” ");
INSERT INTO avt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hɨrak katɨp epei au, mɨt yapɨrwe nɨpaa nisesik neweikɨn sip newetɨwek. ");
INSERT INTO avt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hɨr neweikɨn sip newetɨwek, hɨrak katɨp mɨt disaipel nɨrak nar hiswiyen wik (12) kitorhi kar ik: “Yi eiweikɨn sip eitikeri einaiwɨra a?” ");
INSERT INTO avt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita kewenɨwekhi ketpɨwek kar ik: “Mɨtɨk Iuwe, haiu mamno keimɨn? Ti kerekek hetpei hɨm mamkepei te haiu mamu tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","In ek haiu hɨras keriyen merteiyit ti keimɨn haiu misesit. Ti Mɨtɨk kerek God kehimɨtenit ti akaap haiu mɨt.” ");
INSERT INTO avt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisas ketpor kar ik: “Hi hɨrekes hehimɨtan yi mɨt yar hiswiyen wik (12), te mɨtɨk hak kiutɨp ke yi mɨt hɨrak enuk kɨre Seten.” ");
INSERT INTO avt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hɨrak katɨp ke Judas nɨkan ke Saimon ke wit Iskeriot. Hɨrak mɨtɨk kiutɨp ke mɨt hiswiyen wik (12), maain hɨrak kakwepyapɨr Jisas kakwet mɨt enun ek. ");
INSERT INTO avt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Menmen im epei au, Jisas ken kerer wit wit me provins Galili hɨrak kɨnapen kakno kakrer wit wit me provins Judia kentar mɨt iuwe nare nankɨp. ");
INSERT INTO avt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wɨ epei man menep te mɨt ne Isrel nanrerik nanɨm menmen nau nekre weisaak mɨr, hɨr newet God menmen mei me ni mɨr. ");
INSERT INTO avt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisas kikrek nɨrak nemipɨn netpɨwek, “Ti enaaiwɨr wit ik e eno Judia, te mɨt kerek nises hɨm mit enɨnen enɨr menmen yaaim ti erɨakem. ");
INSERT INTO avt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mɨtɨk kerek hanhan mɨt nanɨrteiyek ap te kakrɨak menmen kaksawɨnem au. Hɨrak kakrɨakem kakrer wit wit te mɨt yapɨrwe enɨrem. Ti arɨak menmen im yaaim, ti eno wit Jerusalem eteikɨn mɨt iuwe rem.” ");
INSERT INTO avt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Kikrek nɨrak natɨp menmen im nentar hɨr ap han kitet hɨrak Krais kerek God kakriuwtek kaknen kakɨkaap mɨt au.) ");
INSERT INTO avt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Te Jisas ketpor kar ik: “Wɨ mai ap epei man te hi awepyapɨr hɨrekes hi Mɨtɨk Iuwe kerek God keriuweta hi han tɨ ik. Wɨ yi han kitetim yi yaino, te yi eino wit Jerusalem eitike mɨt eiyɨm menmen. ");
INSERT INTO avt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mɨt ne tɨ ik ek hɨr ap han enuk neriuwi au. Te hɨr han enuk neriuwa nentar hi hewepyapɨr menmen enum hɨr nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yi eino eitikeri eiyɨm menmen. Hi au, hi ehu in me wɨ ham hentar hi ap ewepyapɨr hi Mɨtɨk God kehimɨtena wen au.” ");
INSERT INTO avt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hɨrak ketpor epei au, hɨrak wen kepu provins Galili. ");
INSERT INTO avt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisas kikrek nɨrak nen netike mɨt han nererik naam menmen epei au, Jisas kepno. Hɨrak ap ketike mɨt yapɨrwe nen au. Hɨrak kerekek ken kau kɨre mɨtɨk kɨsawɨn. ");
INSERT INTO avt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mɨt iuwe ne Isrel nɨnatɨn Jisas neit wit kerek hɨr nererik naam menmen neitai ein. Hɨr nitehiyan, “Hɨrak keit nein?” ");
INSERT INTO avt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Neit ein ek, mɨt yapɨrwe newepnak natɨpan me Jisas. Mɨt han natɨp hɨrak yaaik, mɨt han au natɨp hɨrak enuk kari han ke mɨt yapɨrwe hɨr nises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ap mɨt nei natɨp nerp yaain menmen me Jisas nentar hɨr nɨnapen mɨt iuwe ninɨn naanmɨpre mɨt ne Isrel hɨr nanɨmtewem te hɨr neneri. ");
INSERT INTO avt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wɨ wikak epei men kerek mɨt nererik naam menmen, te Jisas ken wɨnak iuwe ke God keit Jerusalem, hɨrak katɨp mɨt hɨm mɨrak kerp yaain ketpor menmen. ");
INSERT INTO avt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mɨt iuwe ne Isrel nehɨnhɨn natɨp, “Mɨtɨk ik weinɨk kertei menmen mau tɨwei karkeik? Nɨpaa hɨrak ap ken skul te mɨt iuwe tisa neteiknɨwek menmen au.” ");
INSERT INTO avt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisas kewenhi ketpor, “Menmen hi etpiyem hɨram ap mai au. Hɨram hɨm me hɨrak kerek keriuweta te hi han tɨ ik. ");
INSERT INTO avt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Neimɨn hɨr nises menmen God hanhan hɨr nisesim, hɨr nanɨrtei hɨm hi hetpiyem hɨram me God o hɨm hi hɨrekes han kitetim etpiyem. ");
INSERT INTO avt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Keimɨn hɨrak katɨp mɨt menmen hɨrak han kitetim hɨrak hanhan mɨt nanwenɨpi niuk mɨrak keremem. Keimɨn hanhan kakwenɨpi niuk me mɨtɨk kerek keriuwetek, hɨrak kakises menmen yaaim kemipɨn au. ");
INSERT INTO avt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses nɨpaa keweti hɨm mɨrak mau tɨwei te keimɨn ke yi mɨt hɨrak kisesim werek werek? Taauye! Te yi yenmak yi yaiyep hi hahi yentar yi yatɨp hi ap hises hɨm me Moses werek werek au a?” ");
INSERT INTO avt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mɨt en hɨr nitɨwekhi nar ik: “Neimɨn hɨr hanhan nanitep te ti hahi a? Herwe enuk kersɨsit te ti han ken sip te ti hatɨp menmen mar im!” ");
INSERT INTO avt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisas ketpor, “Hi hɨrɨak menmen miutɨp yaaim me wɨ Sabat te yi han kekrit han enuk yeriuwa. ");
INSERT INTO avt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nɨpaa Moses ketpi yi yerekir yɨnk ke nɨkerek hɨrakɨt ti. (Nɨpaa maaamrer ninɨn nɨrɨak menmen im. Moses au.) Yi yerekir yɨnk ke nɨkerek hɨrakɨt ti me wɨ Sabat te yi yises hɨm me Moses. ");
INSERT INTO avt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yi yɨrɨak menmen im me wɨ Sabat, te yi yises hɨm me Moses werek werek. Te yi yenmak yi han enuk yeriuwa yentar hi hɨkaap mɨtɨk kɨnap hɨrak kɨre yaaik me wɨ Sabat a? ");
INSERT INTO avt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yi ap han ekitet menmen hi etpiyem eiyɨntar yi han kitet hi heremir hɨm yi yisesim. Yi han ekitet menmen werek werek te yi eiyɨrtei menmen hi hetpiyem hɨram yaaim.” ");
INSERT INTO avt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mɨt han nau Jerusalem natɨp, “Mɨt iuwe ninɨn naanmɨprai hɨr hanhan nanɨnep mɨtɨk ik kaki. ");
INSERT INTO avt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Te yi eiyɨrek. Hɨrak katɨp mɨt menmen mɨrak keit wit yaaik me ninaan mɨr, te mɨtɨk hak ap kesiuwek hɨm au. Mɨt iuwe han kitet mɨtɨk ik hɨrak Mitɨk Krais kerek God keriuwetek kaknen kakɨkaap haiu mɨt o au a? ");
INSERT INTO avt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Karkeik te hɨrak Mɨtɨk God kehimɨtanek kaknen kakɨkepai a? Haiu mertei mɨtɨk ik ek wit kɨrak. Maain wɨ Mɨtɨk Krais kerek God kehimɨtanek kaknen in, haiu mɨt ap te nanɨrtei hɨrak keke nein kan au!” ");
INSERT INTO avt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas keit wɨnak ke God katɨp hɨm iuwe kar ik: “Yi han kitet yi yertei hi keimɨn, yi yertei wit hi hewik. Te yi yepɨtari hi ap han weinɨm au. Mɨtɨk kerek hɨrak keriuweta hi han ik, hɨrak kerekek kepu, te yi au yepɨtariyek. ");
INSERT INTO avt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hi hertei ek werek werek entar hi nɨpaa hau hetikerek hɨrak keriuweta hi han tɨ ik e.” ");
INSERT INTO avt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hɨrak katɨp menmen im epei au, mɨt iuwe hanhan nantɨwek his nanwisɨk kakɨkre wɨnak enuk ke gavman. Hɨr ap netɨwek his nentar wɨ kerek maain hɨrak kaki hɨram ap epei man wen au. ");
INSERT INTO avt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mɨt yapɨrwe ne mɨt kerek nemtau hɨm mɨrak hɨr nisesik. Hɨr natɨp nar ik: “Maain Mɨtɨk Krais kerek God kehimɨtanek hɨrak kaknen ap te kakinɨn menmen yaaim iuwe mɨtɨk ik kɨrɨakem taauye! Mɨtɨk ik hɨrak Krais!” ");
INSERT INTO avt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mɨt ne Farisi kerek ninɨn nertei hɨm me Moses hɨr nisesim, hɨr nemtau mɨt natɨpan nar ik me Jisas, te hɨr netike mɨt iuwe pris neriuwet mɨt naanmɨpre wɨnak ke God en hɨr nan nanɨt his Jisas. ");
INSERT INTO avt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hɨr epei nan, Jisas katɨp, “Hi wen hahu hatikewi wɨ ham, te maain hi pɨke ano hahu atike hɨrak kerek nɨpaa keriuweta hi han tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Maain yi yayɨnyayɨtno te yi ap yainepya au. Hi ano wit kerek yi ap te yayisɨsa yainen taau.” ");
INSERT INTO avt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hɨrak katɨp epei au, mɨt iuwe ne Isrel natɨpan nar ik: “Hɨrak kakno nein te haiu ap mamnapɨnek a? Hɨrak kakno kakrer wit wit me mɨt ap ne weiwɨk me Isrel kerek mɨt han nai ne Isrel newiyen te hɨrak kaktɨp mɨt ne weiwɨk me Grik hɨm me God a? ");
INSERT INTO avt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kenmak te hɨrak katɨp menmen im: ‘Maain yi yayɨnyaitno te yi ap yainepya au. Hi ano wit kerek yi ap te yaisɨsa yainen taau?’” ");
INSERT INTO avt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Me wɨ mɨkaru me mɨt hɨr nererik naam menmen, hɨram wɨ iuwe epei man, Jisas kekrit kerp katɨp keriuwe hɨm iuwe kar ik: “Keimɨn hɨm niu enuk (o mar kewenkɨkɨwek hɨm) kaknen kakɨra te kakɨm tɨpar mei.” ");
INSERT INTO avt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Menmen im hɨram mar ke hɨm me God metpim. Hɨram matɨp, “Keimɨn kisɨsa, te menmen yaaim mamu mamɨt maain mɨre hɨtɨk meke han kɨrak mamnen witeik.” ");
INSERT INTO avt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas katɨp hɨm im me God Hɨmɨn Yaaik kerek neimɨn nisesik, te hɨr nantɨwek kaku kakɨkre han kɨr. Me wɨ im God Hɨmɨn Yaaik ap kan wen au kentar Jisas ap kaa pɨke kekrit ken wit ke God keit menmen iuwe wen au. ");
INSERT INTO avt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mɨt yapɨrwe nererik menep menep nemtau Jisas, hɨr natɨp hɨm mar im: “Mɨtɨk ik ek hɨrak kɨre mɨtɨk profet hɨrekes kinɨn kaknen me wɨ menep Mɨtɨk Krais kaknen.” ");
INSERT INTO avt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mɨt han natɨp hɨrak kerekek Mɨtɨk God kehimɨtanek keriuwetek kaknen ek. Te mɨt han natɨp, “Mɨtɨk kerek God keriuwetek kaknen ap te mɨtɨk kei ke provins Galili taau!” ");
INSERT INTO avt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tɨwei me God matɨp, “Mɨtɨk God keriuwetek kaknen hɨrak nepenyek ke mɨtɨk Devit. Te mɨte wawinaak kakɨt Betlehem kerek wit nɨpaa Devit kewi en.” ");
INSERT INTO avt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Te hɨr mɨt yapɨrwe nererik newep nau nɨmɨn pɨnan en han kitet hɨm ham, pɨnan natɨp han kitet hɨm ham me Jisas. ");
INSERT INTO avt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hɨrak katɨp menmen im epei au, mɨt han hanhan nantɨwekhis nanwisɨk kakɨkre wɨnak enuk ke gavman. Te hɨr ap netɨwekhis nentar wɨ kerek maain kaki ap man wen au. ");
INSERT INTO avt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Menmen im epei au, mɨt in naanmɨpre wɨnak ke God nɨnaaiwɨr Jisas pɨke nen natɨp mɨt iuwe pris ninɨn naanmɨpror, netike mɨt ne Farisi. Te hɨr netpor, “Yenmak te yi ap yetɨwekhis yeiyɨk yan in a?” ");
INSERT INTO avt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Te mɨt in ne wɨnak iuwe ke God netpor, “Mɨt nei ap nɨpaa natɨp nar ke mɨtɨk ik ek hɨrak katɨp.” ");
INSERT INTO avt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Te mɨt ne Farisi neneri netpor nar ik: “Hɨrak kari han ki ketike mɨt miyapɨr en a? ");
INSERT INTO avt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yi ap yɨr mɨtɨk kei kerek kinɨn naanmɨpri ek o haiu mɨt ne Farisi mises hɨm mɨrak au! ");
INSERT INTO avt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mɨt yapɨrwe in en ap nertei hɨm lo me Moses nisesim werek nar ke haiu mɨt au. Te God kakriwaank kakɨt ninaan mɨrak me wɨ maain hɨrak skelim haiu mɨt ne tɨ.” ");
INSERT INTO avt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas kerek nɨpaa ke wɨtaan ken kɨr Jisas hɨrak mɨtɨk kiutɨp ke hɨr mɨt ne Farisi hɨrak ketpor, ");
INSERT INTO avt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Hɨm lo maiu hɨram matɨp haiu mɨt iuwe eminɨn mamɨntau hɨm mɨtɨk hɨrak ketpim, mamɨr menmen hɨrak kɨrɨakem, te maain haiu matɨp hɨrak yaaik o enuk. Haiu emɨmtau hɨm mɨrak werek, te haiu emɨrtei menmen hɨrak kɨrɨakem werek werek.” ");
INSERT INTO avt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Te hɨr nenerek netpɨwek, “Ti enuk ke Galili har ke mɨt en a? Ehɨr tɨwei me God werek werek te ti ertei mɨtɨk profet kei ap te kaknen in hɨrak ke provins Galili auye!” ");
INSERT INTO avt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hɨr natɨp epei au, hɨr mɨt yapɨrwe kerek nererik hɨr nen wit kɨr, te Jisas ken mɨniu (o neiyɨp) mɨt nenewek wit Oliv. ");
INSERT INTO avt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Teipmen wen hekrit enum eik, Jisas ken wɨnak iuwe ke God. Te mɨt yapɨrwe nenerik neweiknɨwek nau tɨ te hɨrak ketpor hɨm. ");
INSERT INTO avt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mɨt iuwe ninɨn nertei hɨm lo me Moses natɨp mɨt em, hɨr netike mɨt ne Farisi neit his mɨte kerek epei wetike mɨtɨk hak hɨr nɨrɨran hɨr neiyɨp nan. Hɨr netpɨwe werp nɨmɨn ke ninaan me mɨt. ");
INSERT INTO avt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Hɨr natɨp Jisas nar ik: “Mɨtɨk luwe, mɨte ip ep epei wari mɨtɨk hak his wewenem te mɨt han nɨri. ");
INSERT INTO avt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Hɨm lo Moses keweteiyem matɨp mɨte wɨrɨak menmen enum mar im haiu emwɨr nan mamip wawi. Te in ek ti atɨp mekam?” ");
INSERT INTO avt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hɨr natɨp hɨm mar im me nanri han ke Jisas te hɨr nesiuwek hɨm nantɨwek his kakno wɨnak enuk. Te hɨr ap nanmitɨwekpɨn au. Hɨrak kertei, te hɨrak kitehɨr kenke his tɨwak kɨrak kewis hɨm mɨwaai tɨ. ");
INSERT INTO avt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Te hɨr au nerp nitɨwekhi menmen. Jisas kekrit kari hɨrekes werek te hɨrak ketpor, “Mɨtɨk keimɨn kiutɨp ke yi mɨt kerek ap kises menmen enum kɨrɨakem au, hɨrak ekinɨn ekwɨr nan ekip.” ");
INSERT INTO avt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hɨrak katɨp epei au, hɨrak kitehɨr kewis hɨm meriuwe histuwak kɨrak mau tɨ. ");
INSERT INTO avt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te hɨr nemtau hɨm Jisas ketpor kar ik, hɨr nenepep nɨre ne kiutɨp kiutɨp nen witeik. Mɨt iuwe niutɨp niutɨp ninɨn netpaan, hɨr mɨt han weinɨn nɨkaru ere hɨr nɨnaaiwɨr Jisas kiutɨp kepeit nɨmɨn ein ketike mɨte kerepep weperp. ");
INSERT INTO avt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas kekrit kerp kari hɨrekes te hɨrak ketpɨwe, “Hɨr mɨt neit nein? Ap kei kiutɨp kerp in te hɨrak kaksɨwut hɨm me menmen enum ti hɨrɨakem?” ");
INSERT INTO avt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mɨte wewenhi watɨp, “Mɨtɨk luwe hɨr epei nen. Ap kei kiutɨp kerp in au.” Jisas ketpɨwe, “Hi ap te heswut hɨm me menmen im enum ti hɨrɨakem taau. Ti enaaiwɨr in eno, te ti ap pɨke erɨak menmen enum au emɨt!” ");
INSERT INTO avt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas pɨke katɨp mɨt nisesik kar ik: “Hi hɨr hɨre wepni ke tɨ ik ek. Keimɨn kisɨsa kemtau hɨm mai, hɨrak ap kakises menmen enum mɨre wɨtaan toto taau. Hɨrak kakises menmen mai yaaim mɨr mɨre wepni te hɨrak kakɨt hɨmɨn yaaik kaku kakɨt.” ");
INSERT INTO avt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mɨt ne Farisi natɨp Jisas, “In ek ti etpim me ti hɨrekes. Menmen im ti etpim hɨram menmen weinɨm meteiknai ti keimɨn au.” ");
INSERT INTO avt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisas ketpor kar ik: “Au, menmen hi hɨrekes erɨakem hatɨp me hi hɨrekes hɨram yaaim werek hentar hi hertei hi eke nein han te hi ano nein. Te yi ap yertei hi heke nein han o hi pɨke ano nein. ");
INSERT INTO avt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yi skelim hi te yises menmen enum me tɨ. Yi ap yertei werek menmen me hi hɨrɨakem te yi wen yeswo hɨm. Te hi ap skelim mɨtɨk kiutɨp kerekek kar ik au. ");
INSERT INTO avt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Te hi kitet mɨt nanɨrp ninaan mai me menmen hɨr nɨrɨakem hɨram te yaaim werek mentar hi ap hɨrekes kiutɨp skelim hɨr mɨt me menmen im. Haai kai God kerek keriuweta hi han in hɨrak kau ketikewa kekepa hawɨr wɨrɨak menmen im. ");
INSERT INTO avt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Hɨram hɨm lo mi matɨp mɨtɨkɨt wiketeret tatɨp menmen miutɨp hɨrap yaaim werek mentar hɨrakɨt tatɨp hɨm miutɨp mɨpɨram. ");
INSERT INTO avt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Hi hetpi me hi hɨrekes hi Mɨtɨk ke wit ke Mɨtɨk luwe. Haai kai kerek keriuweta hi han in hɨrak ketikewa hawɨr wewepyapɨr hi keimɨn.” ");
INSERT INTO avt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hɨr mɨt en nitɨwekhi, “Haai kit keik?” Jisas ketpor, “Yi ap yertei hi keimɨn te yi yepɨtari Haai kai. Yi yerteiya te yi yayɨrtei Haai kai.” ");
INSERT INTO avt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas ketpor hɨm im keit wɨnak iuwe ke God, keit haau kerek mɨt newis pewek mekre bokis newet God em mɨwaai en. Te mɨt nei ap newɨrek kekre wɨnak enuk nentar wɨ mɨrak hɨrak kaki ap epei man wen au. ");
INSERT INTO avt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas pɨke ketpor keteipim, “Hi ano ehɨt en ehɨt (o ano auwesi ehɨt). Te yi maain yayɨnyaitno te yi yayi yeriuwe menmen enum yi yɨrɨakem. Te yi ap eino nein kerek hi ano en taau.” ");
INSERT INTO avt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Te mɨt iuwe ne Isrel natɨp, “Hɨrak katɨp kar ik, ‘Yi ap yaino wit kerek hi ano taau.’ Hɨm im hɨrak ketpim mɨre hɨrak kaknep hɨrekes kakɨt nein te haiu ap mamno mamtikerek?” ");
INSERT INTO avt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisas kewenhi ketpor, “Yi mɨt yi ne tɨ ik ek keriyen. Te hi au hi ke tɨ ik au. Hi ke wit kau niu. ");
INSERT INTO avt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mar keremem te hi etpi yi yayi yeriuwe menmen enum mau mekre han ki. Yi ap yerteiya hi Mɨtɨk God keriuweta hi han tɨ ik e. Te yi yaino si yayɨntar menmen enum yi yɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hɨr nitɨwekhi, “Ti keimɨn?” Jisas kewenhi ketpor, “Hi epei hetpi hɨm menmen nɨpaa ein ek, wɨ kerek hi hinɨn hewepiyapɨr hɨm God ketpewem. ");
INSERT INTO avt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Menmen yapɨrwe yi yɨrɨakem te hi etpiyem skelim yi mɨt ariuwerem ahɨr ke mɨtɨk masistret hɨrak kɨrɨakem. Te hi ap arɨakem in ek au. In ek hi etɨp yi mɨt ne tɨ hɨm me Mɨtɨk luwe kerek hɨrak keriuweta hi han in hɨrak yaaik hɨrak ketpewem te hi epei hemtewem. Hi arɨak menmen im keremem. Menmen ham au.” ");
INSERT INTO avt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hɨr ap mertei menmen hɨrak ketporem me Haai kɨrak God ek au. ");
INSERT INTO avt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Te hɨrak ketpor, “Maain te yi eirɨak hi Mɨtɨk ke wit ke Mɨtɨk luwe yewerikɨka hahu nu tentarakɨt, te yi yaiyɨrtei hi keimɨn hi hɨrekes. Te maain yi eiyɨrtei hi ap hɨrɨak menmen me hi hɨrekes au. Hi hetpi menmen miutɨp kerek epei Haai kai ketpewem. ");
INSERT INTO avt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hɨrak kerek keriuweta hi han ti ik hɨrak kepu ketikewa. Hɨrak ap kɨnaiwɨra hi kiutɨpen hepu. Au, hekrit hi hemtau menmen mɨrak hisesim te hɨrak han yaaik keriuwa.” ");
INSERT INTO avt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mɨt yapɨrwe nemtau hɨm me menmen Jisas ketpim, te hɨr nisesik. ");
INSERT INTO avt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisas katɨp mɨt ne Isrel kerek nemtau hɨm mɨrak nisesik kar ik: “Yi yises hɨm mai hi epei hetpiyem yi yɨre mɨt disaipel nai. ");
INSERT INTO avt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yi yayɨrtei hɨm yaaim werek, te hɨm yaaim im mamkepi yainepɨm yaikeipɨn menmen enum, yar ke mɨtɨk epei ketpaan kɨnaaiwɨr wɨnak enuk.” ");
INSERT INTO avt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mɨt han en natɨp, “Haiu nepenyerer ne mɨtɨk Ebraham. Haiu ap nɨpaa mɨre mɨt nɨrɨak menmen weinɨm me mɨtɨk hak kerek naanmɨprai au. Ti henmak te ti atɨp hɨm im em, ‘Yi yayu yaaim werek yainopɨn yaikeipɨn menmen enum yar ke mɨtɨk epei ketpaan kɨnaaiwɨr wɨnak enuk a?” ");
INSERT INTO avt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas ketpor, “Hi hetpi werek. Yi mɨt yapɨrwe kerek yi yɨrɨak menmen enum yi yar ke mɨt nekre wɨnak enuk ke menmen enum yi yisesim hɨrak mewenkeki mari han ki yi ap te einaiwɨrem au. ");
INSERT INTO avt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mɨt kerek nepu nekre wɨnak enuk ap te nanises han kɨr nanrɨak menmen au. Te mɨtɨk kerek kepu witeik hɨrak kepu kepeit en kises han kɨrak kɨrɨak menmen. ");
INSERT INTO avt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Te hi Nɨkan ke God hi herekyi yi eire yaain einopɨn eikeipɨn menmen enum, te yi eiyu werek werek. ");
INSERT INTO avt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hi hertei yi nepenyerer ne Ebraham. Te yi yayiyep yayɨntar yi ap yemtau hɨm mai yisesi. ");
INSERT INTO avt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Hi hetpi menmen nɨpaa Haai kai epei keteiknewem, te yi yɨrɨak menmen kerek nɨpaa haai ki hɨrak ketpiyem.” ");
INSERT INTO avt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hɨr newehi netpɨwek, “Haai kaiu hɨrak Ebraham.” Jisas ketpor, “Yi nɨkerek ne Ebraham hɨras, te yi yairɨak menmen yaaim mamɨr ke hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Te menmen hi epei hetpiyem hɨram hɨm yaaim werek hi hemtewem meke God man. Te yi wen hanhan yaitɨp yayiyep. Ebraham hɨrak kɨnapen menmen im. ");
INSERT INTO avt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yi yɨrɨak menmen kerek haai ki kɨrɨakem.” Hɨr nenerek natɨp, “Miyerer naiu ap nɨwaai netike mɨt han te hɨr ninaiu nar ke ti au. Haiu Haai kaiu kiutɨp God hɨrekes.” ");
INSERT INTO avt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisas ketpor, “God hɨrak Haai ki hɨrekes, te yi han tewenɨna. Hɨrak keriuweta hi heke wit kɨrak han te hi hau in ek. Hi ap hises han kai hɨnaaiwɨr wit te hi han tɨ ik auye! Haai kai keriuweta. ");
INSERT INTO avt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yi yenmak te yi ap yertei menmen hi epei hetpiyem a? Yi yepɨtariyem yentar yi ap yau werek werek yemtau hɨm mai. ");
INSERT INTO avt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yi nɨkerek ne haai ki Seten, te yi hanhan yayises menmen enum mɨrak. Nɨpaa enum eik wɨ kerek hɨrak kinɨn kau ek, hɨrak enuk kenepep mɨt naa. Hɨrak ap pɨke kɨre yaaik mei kike au, kentar hɨrak ap katɨp hɨm yaaim mamkaap mɨt au. Hɨrak enuk kemipɨn mɨt kari han kɨr mekrerek. Hekrit hekrit hɨrak enuk kemitetpɨn, hɨrak haai ke mɨt hɨr nemitetpɨn. ");
INSERT INTO avt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hi hetpi hɨm yaaim ap hemipɨn au, te yi ap yisɨsa yentar menmen hi nepei hetpim me Seten. ");
INSERT INTO avt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Keimɨn kiutɨp ke yi ektɨp menmen hi epei hɨrɨakem hɨram enum? Hi hetpi hɨm yaaim te yi yenmak yi ap han kiteta? ");
INSERT INTO avt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mɨt kerek hɨr nɨkerek ne God hɨr enɨmtau hɨm me God. Te yi ap nɨkerek ne God au yentar yi ap yemtau hɨm mɨrak.” ");
INSERT INTO avt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mɨt iuwe ninɨn naanmɨpre mɨt han ne Isrel hɨr netpɨwek, “Nɨpaa haiu matɨp werek. Ti hɨrekes mɨtɨk enuk ke wit Sameria herwe kewit te ti han ken sip.” ");
INSERT INTO avt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisas kewenhi ketpor kar ik: “Hi herwe ap mekra au. Hi hewenɨpi niuk me Haai kai keremem, te yi au yetpo enum ap yewenɨpi niuk mai au. ");
INSERT INTO avt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Hi ap hɨrɨak menmen te mɨt nantɨp hi yaaik iuwe au. Maain God kakteikɨn mɨt hi yaaik iuwe, hɨrak han ekitet menmen hi hɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hi hetpi werek. Neimɨn nises hɨm mai, hɨr ap te nani au. Hɨr nanu nanɨt tipmain tipmain enum eik.” ");
INSERT INTO avt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mɨt iuwe ne Isrel netpɨwek, “In ek haiu mertei herwe enum mersɨs han kit te ti han ken sip. ");
INSERT INTO avt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mɨtɨk Ebraham ketike mɨt profet kerek newepyapɨr hɨm me God natɨp mɨt em, hɨr epei naa. Te ti hatɨp neimɨn nises hɨm mit te hɨr nanu nanɨt tipmain tipmain enum eik. Ti iuwe hinɨn Ebraham ketike mɨt profet a? Ti han kitet ti keimɨn a? Ti han kitet ti hɨre God a?” ");
INSERT INTO avt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisas katɨp kar ik: “Hi hɨrekes hewenɨpi niuk mai hɨram menmen weinɨm. Hi au Haai kai kerek yi yatɨp yi yisesik yewenɨpiyek hɨrak kewenɨpi niuk mai. ");
INSERT INTO avt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yi yatɨp yi yerteiyek, te ti yisesik au. Hi herteiyek hisesik. Hi hatɨp hi hepɨtariyek, te hi mɨtɨk enuk hemipɨn har ke yi mɨt. Au, hi herteiyek, hi hises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Maam ki Ebraham hanhan kakɨr wɨ kerek hi anaaiwɨr wit ke Mɨtɨk luwe eweikɨn hɨre mɨtɨk anen hahu tɨ ik atike yi mɨt. Hɨrak epei kɨrek te hɨrak han yaaik.” ");
INSERT INTO avt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mɨt iuwe ne Isrel netpɨwek, “Ti ap epei enuk he mɨtɨk wen au, ti epei hɨr Ebraham a? Taauye!” ");
INSERT INTO avt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisas ketpor, “Hi hetpi werek Ebraham miye pɨrak winaak wen au, hi kerekek hepu.” ");
INSERT INTO avt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hɨrak katɨp epei au, mɨt neit nan nanwɨrem nankɨp. Au, Jisas kiune hɨrekes hɨrak kɨnaaiwɨr wɨnak iuwe ke God ketpaan ken witeik. ");
INSERT INTO avt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas keke tɨ kepno, hɨrak kɨr mɨtɨk hak kerek miye winaak hɨrak enuk nanamɨr toto. ");
INSERT INTO avt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mɨt disaipel nɨrak nitɨwekhi nar ik: “Mɨtɨk luwe, neinɨn nɨrɨak enum te miye pɨrak winaak te hɨrak nanamɨr toto? Hɨrekes o miye haai nɨrak?” ");
INSERT INTO avt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisas ketpor kar ik: “Mɨtɨk ketike miye haai ap nɨrɨak enum au. Hɨrak nanamɨr toto kentar God kɨrɨak menmen yaaim kakriuwerek kakteikɨn mɨt em. ");
INSERT INTO avt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Haiu emrɨak menmen me God kerek keriuweta hi han. Haiu emrɨakem me wɨ hɨrak kɨmat haiu mamrɨakem. Haiu emrɨakem emɨntar maain wɨ mamnen te mɨt ap te nanrɨak menmen mar im au. ");
INSERT INTO avt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Hi wen hepu tɨ ik ek, hi hɨre si mɨr meteikɨn mɨt yapɨrwe yayiwe, hi heteiknor menmen me God.” ");
INSERT INTO avt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hɨrak katɨp menmen im epei au, hɨrak kenikɨn tɨmank men tɨ keweiknɨm mɨre toni, hɨrak kewisɨm mau nanamɨr ke mɨtɨk eik. ");
INSERT INTO avt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Hɨrak kewisɨm epei au, hɨrak ketpɨwek, “Ti eno ekɨr ekre wan niuk mɨrak Siloam.” (Haiu meweikɨn hɨm im haiu matɨp ‘Mɨt neriuwetem men.’) Jisas ketpɨwek epei au, hɨrak ken kekemyet ninaan te hɨrak pɨke kan kɨr ein ein werek werek. ");
INSERT INTO avt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hɨrak epei kan, te mɨt nau menep nɨrapɨtek netike mɨt han nɨrek nɨpaa kau tɨ ek kitehi mɨt me pewek, hɨr natɨpan nar ik: “Mɨtɨk ik nɨpaa kau tɨ kitehi mɨt nanwetɨwek pewek. Mɨtɨk ik o au a?” Mɨt han en, hɨr natɨp, “Mɨtɨk ik ninaan mɨrak mar ke mɨtɨk hak eik kau tɨ.” ");
INSERT INTO avt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mɨt han natɨp, “Mɨtɨk ik kerekek nɨpaa kau tɨ kitehi mɨt pewek.” Au, mɨt han natɨp, “Hɨrekes au. Hɨrak ninaan mɨrak mɨre mɨtɨk kerek nɨpaa nanamɨr toto ek.” Hɨrak ketpor, “Au, hi mɨtɨk hɨrekes kerek nɨpaa nanamɨr toto.” ");
INSERT INTO avt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hɨrak ketpor, te hɨr nitɨwekhi, “Ti harkeik te nanamɨr kit yaaik te ti hɨr ein ein a?” ");
INSERT INTO avt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hɨrak ketpor kar ik, “Mɨtɨk ik hɨr nenewek Jisas kenikɨn tɨmank mau tɨ keweiknenim ere mɨre toni, te hɨrak kewisɨm mau nanamɨr kai te hɨrak ketpo kar ik: ‘Ti eno ekemyet ninaan emɨkre wan niuk mɨrak Siloam.’ Epei au, hi hen hekemyet ninaan mai te nanamɨr kai kɨre yaaik hi hɨr ein ein werek werek.” ");
INSERT INTO avt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hɨrak katɨp epei au, hɨr nitɨwekhi, “Hɨrak keit nein?” Hɨrak katɨp, “Hi hepɨtariyek.” ");
INSERT INTO avt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Hɨr mɨt neithis mɨtɨk ik kerek nɨpaa nanamɨr enuk toto ek hɨr neriyaak ketikeri nen nɨr mɨt ne Farisi kerek ninɨn nises hɨm me Moses. ");
INSERT INTO avt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wɨ kerek Jisas kewis toni kau mɨtɨk nanamɨr toto te hɨrak nanamɨr yaaik kesiupan kɨr ein ein werek werek, hɨrak kɨrɨak menmen im me wɨ Sabat kerek mɨt ap nɨrɨak menmen au. ");
INSERT INTO avt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hɨrak ketikeri nen nɨr mɨt ne Farisi, hɨr nitɨwekhi pɨke kakɨtpor karkeik te hɨrak in ek kɨr ein ein. Hɨrak kewenhi katɨp, “Mɨtɨk hɨrak kewen toni kau nanamɨr kai, hi hekekyet te hi hɨr ein ein.” ");
INSERT INTO avt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mɨt han ne Farisi natɨp, “God keriuwet mɨtɨk ik au kentar hɨrak kɨrɨak menmen me wɨ Sabat ap kises hɨm me Moses au.” Mɨt han natɨp, “Mamɨrkeik te mɨtɨk enuk kakrɨak menmen yaaim mamɨr im?” Hɨr mɨt newep nau nɨmɨn. Pɨnan natɨp Jisas enuk, han pɨnan natɨp hɨrak yaaik. ");
INSERT INTO avt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mɨt ne Farisi nitehi mɨtɨk neteipim nar ik: “Ti han kitet mekam me mɨtɨk kerekyut nanamɨr? Hɨrak yaaik?” Hɨrak ketpor, “Hɨrak mɨtɨk profet kerekek.” ");
INSERT INTO avt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mɨt iuwe ne Isrel nertei mɨtɨk ik au, te hɨr ap han kitet nɨpaa hɨrak nanamɨr enuk toto, te in ek hɨrak kɨr ein ein. Hɨr nemtau hɨm mɨrak au ere hɨr nɨtehi miye haai nɨrak. ");
INSERT INTO avt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hɨr nitorhi nar ik: “Ik ek hɨrak nɨkan kit kerek nɨpaa yi yinaak ek, hɨrak nanamɨr toto? Karkeik te hɨrak kɨr ein ein?” ");
INSERT INTO avt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Miye haai nɨrak netpor, “Haiu mertei ik ek nɨkan kawɨr kerek hawɨr winaak hɨrak nanamɨr toto, hawɨr werteiyek. ");
INSERT INTO avt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Hawɨr wepɨtari hɨrak karkeik te hɨrak kɨpɨr ein ein. Yi eiyitɨwekhi. Hɨrak epei kɨre iuwe. Hɨrak kɨrekes kakɨtpiyem.” ");
INSERT INTO avt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Miye haai nɨrak natɨp nar ik nentar hɨr nɨnaain mɨt iuwe ne Isrel. Mɨt iuwe nɨpaa natɨp keimɨn katɨp Jisas hɨrak Mɨtɨk Krais kerek kaknen kakɨkaap haiu mɨt, hɨr ap nanwenɨwekhi kaknen wɨnak kerek mɨt nererik nekine hɨm me Moses neitai au. ");
INSERT INTO avt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Miye haai nɨrak nertei menmen im te hɨr netpor, “Hɨrak epei iuwe, te yi eiyitɨwekhi em.” ");
INSERT INTO avt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mɨt iuwe pɨke nari mɨtɨk kerek nɨpaa nanamɨr toto ek hɨrak kan te hɨr netpɨwek nar ik: “Ti ewenɨpi niuk me God, te ti atɨp werek. Haiu mertei mɨtɨk ik ap kises God werek werek o au. Ti ewepyapɨrek hɨrak enuk.” ");
INSERT INTO avt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hɨrak ketpor kar ik: “Hi hepɨtari mɨtɨk ik hɨrak yaaik o enuk. Menmen miutɨp hi hertei. Nɨpaa hi nanamɨr toto, te in ek hi hɨr ein ein werek werek.” ");
INSERT INTO avt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hɨr pɨke nitɨwekhi, “Hɨrak kerekyut mekam? Hɨrak karkeik te hɨrak keniput nanamɨr kit kɨre yaaik?” ");
INSERT INTO avt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hɨrak ketpor kar ik: “Hi epei hetpiyem, te yi ap yisesim werek werek au. Yi yenmak te yi hanhan yayɨmtewem yaiteipim a? Yi hanhan yayisesik yi yayɨr disaipel nɨrak a?” ");
INSERT INTO avt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hɨrak katɨp epei au, hɨr han enuk netpɨwek enum nar ik: “Ti kerekek hises hɨm mɨrak. Haiu auye! Haiu mises hɨm me Moses! ");
INSERT INTO avt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Haiu mertei God katɨp Moses hɨm mɨrak, te mɨtɨk ik weinɨk haiu mepɨtari keimɨn keriuwetek kan.” ");
INSERT INTO avt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mɨtɨk keneri ketpor kar ik: “Menmen im yaaim menipa hi heniuwesɨs. Yi yepɨtari keimɨn keriuwetek hɨrak kan, te hɨrak kekepa kɨrɨak nanamɨr kai kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Haiu mertei God hɨrak kemtau hɨm me mɨt enun hɨr nitɨwekhi menmen au. Hɨrak kemtau hɨm keremem me mɨt yaain hɨr nɨrɨak menmen God hanhan hɨr nisesi. ");
INSERT INTO avt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nɨpaa God kewis tɨ ere in haiu ap memtau mɨtɨk hak kɨkaap mɨt nanamɨr enum toto, te hɨr nɨr ein ein werek werek au. ");
INSERT INTO avt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God ap keriuwet mɨtɨk ik te hɨrak ap kakrɨak menmen werek werek taauye!” ");
INSERT INTO avt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hɨr mɨt nemtaantɨwo nenerek nar ik: “Nɨpaa miye pit winit ti enuk mɨtɨk weinɨk, te ti han kitet ti mɨtɨk iuwe hetpai menmen me God a?” Hɨr netpɨwek epei au, hɨr nepɨrek ken witeik. ");
INSERT INTO avt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas kemtau hɨr epei nepɨrek ken witeik, te hɨrak kɨnketnɨwek. Hɨrak kɨnapɨnek epei au, hɨrak kitɨwekhi kar ik: “Ti kerekek hises hɨm me mɨtɨk ke wit ke Mɨtɨk luwe o au?” ");
INSERT INTO avt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mɨtɨk ik kitɨwekhi kar ik: “Mɨtɨk luwe, ti etpo hɨrak keimɨn te hi hises hɨm mɨrak.” ");
INSERT INTO avt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas ketpɨwek, “Ti epei hɨrek hɨrak kerek in ek hɨrak ketput menmen.” ");
INSERT INTO avt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hɨrak pɨke katɨp Jisas kar ik: “Mɨtɨk luwe, hi han kitet ti Mɨtɨk ke wit ke Mɨtɨk luwe.” Te hɨrak kewen ninɨp kewenɨpi niuk mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Te Jisas katɨp, “Hi han tɨ ik te hi hewepyapɨr neimɨn nises God, neimɨn hɨr au. Hi han akaap mɨt netari hɨm me God te hɨrak kakrekyor han kitet hɨr nanamɨr toto te hɨr nanisesik nanɨrteiyek werek werek. Hi han te neimɨn hɨr han kitet hɨr epei nertei hɨm me Moses werek werek, hi heteiknor hɨr ap nises God werek werek au. Hɨr nɨre mɨt enun nanamɨr toto.” ");
INSERT INTO avt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mɨt han ne Farisi nerp netikerek nemtau menmen hɨrak ketpim, hɨr netpɨwek nar ik: “Ti ap han kitet haiu nanamɨr toto metike mɨt yapɨrwe weinɨn au a?” ");
INSERT INTO avt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas ketpor, “Yi yepɨtari hi keimɨn te God ap han kitet menmen yi yerekyewem hɨram enum iuwe au. Kike. Te in ek yi yatɨp yi yertei menmen me God werek werek, te menmen enum mekre han ki hɨram emu emɨt!” ");
INSERT INTO avt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Hi hetpi werek werek. Mɨtɨk kerek ap kitet ya weipɨr kakno nɨwa ke sipsip au, hɨrak kɨniu nɨwa keke han kerekir ken nɨmɨn ein, hɨrak mɨtɨk enuk kekintɨp menmen. ");
INSERT INTO avt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Te mɨtɨk kerek kitet ya weipɨr hɨrak mɨtɨk ke naanmɨpre sipsip. ");
INSERT INTO avt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mɨtɨk kerek kekiwo nɨwa kau ya weipɨr kɨre mɨtɨk ik, hɨrak kewisɨk ken nɨmɨn hɨrak kakno nɨmɨn te sipsip mamɨmtau hɨm mɨrak, hɨrak kekine niuk me sipsip miutɨp miutɨp, hɨrak keriyaam keiyɨm kakno wit eik. ");
INSERT INTO avt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hɨrak kari sipsip mɨrak hɨrak kinɨn kakno. Sipsip hɨram misesik mentar hɨrak kenɨnewem (o kenɨnorem), hɨram memtau tonɨk mekre nɨkɨp te hɨram misesik. ");
INSERT INTO avt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Te mɨtɨk hak taau. Hɨram mɨneinɨk mɨrɨr mentar hɨram ap memtau tonɨk mekre nɨkɨp kɨre mɨtɨk kerek naanmɨprewem (o naanmɨprorem) au.” ");
INSERT INTO avt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas katɨp mɨt ne Farisi hɨm im, te hɨr ap nertei menmen werek werek hɨrak ketporem me hɨrekes au. ");
INSERT INTO avt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mɨt netari menmen hɨrak ketpim te Jisas pɨke katɨp kar ik: “Hi hetpi werek werek hi hɨrekes hɨre weipɨr ke sipsip. Hi hɨkaap mɨt hɨr nɨre sipsip hɨr nanises hɨm me God. ");
INSERT INTO avt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mɨt yapɨrwe nɨpaa ninɨn nan naanmɨpre mɨt ne Isrel hɨr mɨt enun nɨre mɨt nekintɨp menmen. Mɨt hɨr nɨre sipsip ne God ap nises mɨt in au. ");
INSERT INTO avt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Hi hɨre ya weipɨr. Neimɨn nisɨsa hɨr nɨre sipsip nanɨnen nɨmɨn nɨwa, te hɨr nanu werek maain nanɨno witeik nanɨnantɨn yenkis yaaim nanɨm. ");
INSERT INTO avt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mɨtɨk enuk kekintɨp menmen kaknen te kakɨt menmen kaknep sipsip kakɨwaank menmen. Hi au hi han te hɨr nani au. Hɨr nanu werek werek nanɨr ke God hanhan hɨr nanwim. ");
INSERT INTO avt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Hi hɨre mɨtɨk yaaik naanmɨpre sipsip hi hahi akaap sipsip nai te hɨr nanu werek werek. ");
INSERT INTO avt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mɨtɨk kerek naanmɨpre sipsip kakɨt pewek mamrerim, hɨram ap sipsip mɨrak. Hɨrak kɨr nepere iuwe ke yaank kaknen, hɨrak kɨnaain kɨrɨr te nepere iuwe ke yaank kemiyei sipsip ken kɨyaau kiutɨp kakɨp, te hɨram ham mɨrɨr mewep ein mewep ein. ");
INSERT INTO avt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mɨtɨk kar ik kɨrɨr kentar hɨrak ap hanhan sipsip au. Hɨrak naanmɨprewem kakɨt pewek mamrerim keremem. ");
INSERT INTO avt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Hi hɨre mɨtɨk yaaik naanmɨpre sipsip. Hi hertei werek werek mɨt neimɨn hɨr nɨre sipsip nai, hɨr nerteiya nisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hi hetike Haai kai werteiyakɨt mar im. Hi hertei mɨt nɨre sipsip nai, hɨr nerteiya. Hi hetike sipsip nai hanhan meriuwehan te hi hahi akepi. ");
INSERT INTO avt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mɨt han nɨre sipsip nai, hɨr nepu, te hɨr ap ne weiwɨk me mɨt nai ne Isrel au. Hi tewen haryei nantike mɨt han in te hɨr nemtau hɨm mai nanisɨsa. Maain hɨr nanre weiwɨk miutɨp te hi kiutɨp naanmampror. ");
INSERT INTO avt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Haai hɨrak hanhan keriuwa hentar hi hanhan hahi akaap mɨt te hi pɨke akrit. ");
INSERT INTO avt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mɨtɨk hak ap te kakiyep te hi hahi au. Hi han kai kerekek. God ketpo menmen im te hi arɨakem. Hɨrak katɨp werek te hi hahi, maain hɨrak kakwisa hi pɨke akrit hahu.” ");
INSERT INTO avt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mɨt iuwe ne Isrel en hɨr newepan nau nɨmɨn pɨnan, han kitet menmen im, pɨnan au han kitet menmen ham nentar hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mɨt yapɨrwe natɨp, “Herwe kau kekrerek, te hɨrak han ken sip hɨrak ketaritari katɨp menmen im em. Yi yenmak te yi yerp in yemtau hɨm mɨrak a?” ");
INSERT INTO avt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mɨt han natɨp hɨm mɨrak ap hɨm me mɨtɨk kerek herwe kau kekre han kɨrak au. Herwe ap te kɨrɨak mɨtɨk nanamɨr toto enuk ek te hɨrak kɨre yaaik kɨr ein ein werek werek au. ");
INSERT INTO avt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jisas katɨp menmen im meit wit Jerusalem me wɨ mɨt nererik han tewenɨn nɨpaa mɨt nepɨr menmen enum mekre wɨnak ke God, hɨr pɨke nɨkaisiu weipɨr, te hɨr pɨke nanɨno nɨmɨn newenɨpi niuk me God. Me wɨ im hɨram mɨre hawɨ hɨtan. ");
INSERT INTO avt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas ken kitet wɨnak iuwe ke God keit haau mɨt nenewem ‘Hɨnp ke mɨtɨk iuwe King Solomon.’ ");
INSERT INTO avt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hɨrak wen kepu en, mɨt iuwe ne Isrel neweiknɨwek nitɨwekhi, “Wɨ marmenum te ti heteiknai haiu mamɨrteiyek. Ti etpai werek werek. Ti Mɨtɨk God kehimɨtanit ti akepai haiu mɨt o au?” ");
INSERT INTO avt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisas ketpor, “Hi epei hetpi te yi ap han kitet hɨm mai werek werek au. Menmen yaaim hi hɨrɨakem heriuwe menmen iuwe me Haai kai hɨram mewepayapɨr hi keimɨn. ");
INSERT INTO avt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yi ap yises hɨm mai yentar yi ap yɨre sipsip nai au. Nɨpaa hi hetpiyem! ");
INSERT INTO avt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip nai hɨr nanɨmtau hɨm mai hi herteiri niutɨp niutɨp hɨr nisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Te hi ekepi te hɨr nanu nantikewa tipmain tipmain enum eik, hɨr nani au. Mɨtɨk hɨrak ap te kakri mɨt sipsip nai te hɨr ap nanises hɨm mai nanɨwaank taau. ");
INSERT INTO avt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Haai kai kerek kewetau mɨt in hɨrak kinɨn menmen yapɨrwe. Mɨtɨk hak ap kakri mɨt nisesik te hɨr nanweikɨn sip nanwetɨwek nanɨwaank taau. ");
INSERT INTO avt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Hi etike Haai kai hawɨr wekiyakɨt wepu niutɨp.” ");
INSERT INTO avt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hɨrak katɨp menmen in epei au, mɨt iuwe ne Isrel pɨke neit nan te hɨr nankɨp. ");
INSERT INTO avt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisas kitorhi, “Hi epei hɨrɨak menmen yapɨrwe me ninaan mi hises menmen Haai kai kehimɨtena hi hɨrɨakem. Me mekam miutɨp te yi eiwɨr nan yayiyep a?” ");
INSERT INTO avt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mɨt iuwe ne Isrel netpɨwek, “Haiu mamitep me menmen yaaim ti hɨrɨakem au. Haiu mamitep mamɨntar ti atɨp enum, ti hɨre mɨtɨk kerekek, te ti hatɨp ti hɨrekes hɨre God.” ");
INSERT INTO avt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas katɨp, “Hɨm me God mau tɨwei hɨram matɨp mar im: ");
INSERT INTO avt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","‘Hi atɨp yi yɨre God.’ Haiu mertei hɨm me God mau tɨwei hɨram yaaim ap mamweikɨn matɨp hɨm ham taau. God katɨp mɨt kerek hɨrak kewetɨr hɨm mɨrak hɨr nɨre God. ");
INSERT INTO avt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","God Haai kehimɨtena hɨrak keriuweta te hi han hau tɨ ik ek te yi yenmak yatɨp hi hatɨp enum hentar hi etpi hi Nɨkan ke God a? ");
INSERT INTO avt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Hi ap hɨrɨak menmen Haai kai kehimɨtena, te yi ap eiyises hɨm mai au emɨt! ");
INSERT INTO avt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Te hi hɨrɨak menmen me Haai kai. Yi yɨnapen han ekitet hɨm hi hetpiyem me Haai kai keriuweta hi han tɨ ik yentar hi mɨtɨk kerekek. Te yi han ekitet menmen hi hɨrɨakem te yi yayɨrtei werek werek han ekitet Haai kai God ketikewa hawɨr wekiyakɨt wepu han kiutɨp.” ");
INSERT INTO avt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hɨrak katɨp menmen im epei au, hɨr pɨke nantɨwekhis nanwisɨk kakɨkre winaɨk enuk, te hɨrak kɨnaiwɨri ken. ");
INSERT INTO avt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hɨrak kɨnaiwɨri pɨke ken kerekir mani Jodan ken kiun wit kerek nɨpaa Jon kɨkɨr mɨt, hɨrak kewiyen. ");
INSERT INTO avt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mɨt yapɨrwe hɨr nan natɨp, “Jon ap kɨrɨak menmen yaaim kɨkaap mɨt enun hɨr nɨre yaain kar ke mɨtɨk ik kɨrɨakem. Te menmen hɨrak ketpei me mɨtɨk ik ek hɨram yaaim werek.” ");
INSERT INTO avt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mɨt yapɨrwe nau en, hɨr han kitet hɨrak Mɨtɨk Krais kerek God kehimɨtanek kaknen kakɨkaap haiu mɨt. ");
INSERT INTO avt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mɨtɨk hak kiutɨp niuk mɨrak Lasaras, hɨrak kau wit Betani. Betani hɨrak wit kerek Maria wetike heiyiuwe pɨre Mata newi en. ");
INSERT INTO avt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Nɨpaa mɨte Maria ip ep wewen tɨpar yaaim mɨnɨn yaaim mɨre natɨn kɨpna em mentar hɨt me Mɨtɨk luwe Jisas. Epei au hɨre pɨke wenke paan kɨre pɨke weiyɨk wesiunɨnɨwekem. Mɨte ip e hɨre yenten kɨre Lasaras. Hɨrak kɨnap.) ");
INSERT INTO avt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hɨrak Lasaras kɨnap te Maria wetike Mata hɨr nesiuwe hɨm men Jisas netpɨwek, “Kit yinak Lasaras nepei kɨnap wɨsenum. Ti enen ekepik te hɨrak kakre yaaik.” ");
INSERT INTO avt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisas kemtewem, hɨrak katɨp, “Lasaras kɨnap keremem ap te kaki herwe enuk kakno kakɨsine kakɨt au. Menmen im man te mɨt nanwenɨpi niuk me God, mɨt nanwenɨpi niuk mai hi Nɨkan ke God.” ");
INSERT INTO avt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas han tewenɨn Mata wetike kikɨre pɨre, netike yenten kɨr Lasaras. ");
INSERT INTO avt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jisas kemtau hɨm me Lasaras kɨnap, te hɨrak wen kepu wit kerek hɨrak kepwi en ere wɨ wiketerem. ");
INSERT INTO avt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Epei au, hɨrak katɨp mɨt disaipel nɨrak, “Haiu pɨke emno provins Judia.” ");
INSERT INTO avt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Te mɨt disaipel newenek natɨp, “Mɨtɨk luwe, ti hanhan pɨke eno wit kerek nɨpaa ein mɨt nau en nanwɨr nan nanitep a? Ekɨt haiu emu in!” ");
INSERT INTO avt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas katɨp kar ik: “Ap 12 aua me hekrit ere hɨnkewɨ a? Te mɨtɨk kakno kakitet yayiwe ap te kakrewo menmen kakɨnkewɨn kentar hɨrak wepni kɨr kan tɨ ik ek, hɨrak kɨr yayiwe hɨrak kitetik. ");
INSERT INTO avt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Te hɨrak kakno kakɨ wɨtaan, hɨrak kakrewo menmen te kakɨnkewɨn kentar ap wepni kɨr keteiknɨwek menmen werek werek.” ");
INSERT INTO avt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas katɨp hɨm im em epei au, hɨrak pɨke ketpor keteipim kar ik: “In ek Lasaras epei kɨwaai keit, te hi pɨke eno akotɨtek kakɨkrit kaku.” ");
INSERT INTO avt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mɨt disaipel netpɨwek nar ik: “Mɨtɨk luwe, hɨrak kɨwaai, te hɨrak maain pɨke kakre yaaik. Te haiu emu in a?” ");
INSERT INTO avt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas ketpor me Lasaras hɨrak epei kaa, te hɨr han kitet hɨrak keptor hɨrak kɨwaai kerekek. ");
INSERT INTO avt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mar keremem te Jisas ketpor werek werek kar ik: “Lasaras epei kaa. ");
INSERT INTO avt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Te hi han yaaik hi ap hau hetikerek kerek wɨ hɨrak kaa kentar maain hi hekepik yi eiyɨrtei God keriuweta hi han. In ek haiu emno emɨrek.” ");
INSERT INTO avt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mɨtɨk Tomas hɨr nekine niuk mɨrak ham nenewek Didimas, hɨrak katɨp mɨt disaipel han ne Jisas kar ik: “Tɨs, haiu emno emtike Mɨtɨk luwe te haiu mami mamtikerek.” ");
INSERT INTO avt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Maain Jisas kan, mɨt netpɨwek nar ik: “Wɨ tekyaait Lasaras kaa, hɨr newisɨk kɨwaai kekre han kewen kɨnɨk.” ");
INSERT INTO avt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Wit Betani ap yanɨmɨn ke wit iuwe Jerusalem. Au menep kɨre 3 kilomita. ");
INSERT INTO avt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Te mɨt miyapɨr yapɨrwe ne Isrel epei nan Betani nanɨr Mata wetike Maria, hɨr enwenor han kɨr yaaik nentar yenten kɨr Lasaras epei kaa. ");
INSERT INTO avt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata wemtau Jisas kaknen, hɨre wen te wawɨwenyipɨrek wawɨt yayiwe eik. Te Maria au wepu wɨnak eik. ");
INSERT INTO avt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata wan watɨp Jisas, “Mɨtɨk luwe, nɨpaa ti epei enen ehu in te yenten kai ap te kaki taau. ");
INSERT INTO avt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Te hi hertei God in ek kakwetit menmen kerek ti hitɨwekhiyem heriuwerem em.” ");
INSERT INTO avt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisas jetpɨwe, “Yenten kit tewen kakɨkrit kaku kakre mɨtɨk.” ");
INSERT INTO avt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata wewenhi watɨp, “Hi hertei maain hɨrak kakɨkrit me wɨ kerek God kehimɨtenem skelim mɨt.” ");
INSERT INTO avt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisas ketpɨwe, “Hi Haai ke mɨt pɨke nanɨkrit nanu. Hi Haai ke mɨt nanɨt hɨmɨn yaaik. Neimɨn nises hɨm mai, hɨr nani, te maain hi pɨke akɨan nanu nanɨt. ");
INSERT INTO avt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Neimɨn kerek nau nisɨsa hɨr keriyen nanɨt hɨmɨn yaaik nanu nanɨt tipmain tipmain enum eik. Ti han kitet hɨm mai hisesim o au?” ");
INSERT INTO avt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata wewenhi war ik: “O Mɨtɨk luwe, hi hises hɨm mit. Hi hisesit hentar hi hertei ti Nɨkan ke God, ti Mɨtɨk kerek God kehimɨtenit ti han tɨ ik e.” ");
INSERT INTO avt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata watɨp hɨm im epei au, hɨre pɨke wen wenɨne kikɨr pɨre Maria. Hɨr wik hasini hɨre wetpɨwe main main war ik: “Mɨtɨk luwe epei kan kitauhi hi hetput ti eno ehɨrek.” Hɨre wetpɨwe epei au, hɨre wen wɨrɨak menmen. ");
INSERT INTO avt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria wemtau hɨm im em, hɨre wesiukɨn wasenum wen wawɨr Jisas. ");
INSERT INTO avt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ap epei kan kiun wit ik wen au. Hɨrak wen kepeit wit kerek Mata epei wen wɨrek kewiyen. ");
INSERT INTO avt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mɨt miyapɨr ne Isrel neit wɨnak kɨr enwenɨn han kɨre hɨr nɨr Maria hɨre wesiuknen wasenum wen, te hɨr nisesiye. Hɨr natɨp, “Hɨre waunɨne herwe hei te hɨre waukɨtek.” ");
INSERT INTO avt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Te Maria epei wan wiun wit kerek Jisas kewiyen, hɨre wɨrek wenke wɨwaai hɨt mɨrak wewenɨpiyek. Hɨre watɨp, “Mɨtɨk luwe, nɨpaa ti epei enen in ne, te yenten kai ap te kaki au.” ");
INSERT INTO avt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas kɨrep wɨkɨt, te mɨt miyapɨr ne Isrel kerek epei netikerep hanhan ek hɨr nɨpkɨtek, hɨrak han enuk te hɨrak han kɨrak kekrit. ");
INSERT INTO avt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Te hɨrak kitɨwehi kar ik: ‘Yi yewisɨk kɨwaai nein?” Hɨr natɨp, “Mɨtɨk luwe enen ehɨrek.” ");
INSERT INTO avt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas han tewenɨnek kɨkɨtek. ");
INSERT INTO avt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mɨt han en ne Isrel natɨp, “Eiyɨrek, hɨrak hanhanek wɨsenuk.” ");
INSERT INTO avt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Te mɨt han natɨp, “Hɨrak nɨpaa kɨrɨak mɨtɨk kerek nanamɨr toto hɨrak kɨr ein ein ek a? Hɨrak ap te kakɨkaap Lasaras kaa au a?” ");
INSERT INTO avt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas han enuk han kekrit, te hɨrak ken han kerek mɨt epei newisɨk kɨwaairi en. Han ik kerekek nɨpaa hɨr nekinɨk kekre nan hɨr newis nan keiyepet hɨm kɨrak. ");
INSERT INTO avt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas katɨp, “Yi eiyɨnke nan ik eknepɨn.” Mata yenten kɨre kerek kaa ek, hɨre watɨp, “Mɨtɨk luwe, hɨrak epei kaa ere wɨ tekyaait epei men, te hɨrak epei kɨnɨn enuk. Ti ap ekeisiuwek ekɨt!” ");
INSERT INTO avt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisas ketpɨwe, “Hi hetput ti ehises hɨm mai te ti tewen hahɨr menmen iuwe me God mamnen.” ");
INSERT INTO avt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hɨrak katɨp epei au, hɨr nenkre nan ken pɨn, Jisas kɨkɨamnaan katɨp, “Haai ti yaaik ti epei emtau menmen hi hituthiyem. ");
INSERT INTO avt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Hi hertei me wɨ yapɨrwe ti hemtau hɨm mai, te hi hatɨp hɨm im em hentar mɨt in en, te hɨr nanɨrtei ti heriuweta hi han tɨ ik ek.” ");
INSERT INTO avt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hɨrak kitehi God menmen im epei au, hɨrak kenɨne hɨm iuwe kar ik: “Lasaras, ti etpaan enen witeik.” ");
INSERT INTO avt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Te mɨtɨk kerek kaa ek hɨrak ketpaan kan witeik. His hɨt mɨrak hɨr newenkekim meriuwe laplap kerek nɨpaa hɨr neiyɨm newisɨk ek, te laplap ham mewenkɨkɨwek ninaan mɨrak. Jisas ketpor, “Yi eisiupenɨwek laplap einaiwɨrek ekno.” ");
INSERT INTO avt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mɨt miyapɨr yapɨrwe ne Isrel kerek epei nan nɨr Maria, hɨr nɨr menmen Jisas kɨrɨakem, te hɨr han kitet hɨrak Mɨtɨk kerek God keriuwetek kan tɨ ik. ");
INSERT INTO avt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Au, mɨt han pɨke nen natɨp mɨt ne Farisi me menmen Jisas epei kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Te mɨt ne Farisi netike mɨt iuwe ne pris netike mɨt ne kaunsil hɨr nererik natɨp nar ik: “Haiu emrɨak mekam? Hɨrak epei kɨrɨak menmen iuwe mar im! ");
INSERT INTO avt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te haiu mamwisɨk kakrɨak menmen mampar im, te mɨt yapɨrwe nanisesik. Mɨt nanisesik, te mɨt iuwe ne wit Rom nansiuwe ami nanɨnen nanwen wɨnak iuwe ke God hɨr nanɨwaankai haiu mɨt ne Isrel!” ");
INSERT INTO avt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mɨtɨk hak niuk mɨrak Kaiafas, kerek me tito im hɨrak hetpris kinɨn pris yapɨrwe, hɨrak ketpor, “Yi hɨras ap yertei menmen mei kike taau! ");
INSERT INTO avt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yi ap yertei werek hɨram yaaim te mɨtɨk kiutɨp ik kaki, haiu mɨt yapɨrwe ne weiwɨk me Isrel au.” ");
INSERT INTO avt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hɨrak ap katɨp im em me han kɨrak. Au, hɨrak mɨtɨk het pris kerek kinɨn naanmɨpre mɨt en me tito im em, te hɨrak katɨp hɨm kɨre profet kar ik ek: Jisas kaki kakɨkaap mɨt ne Isrel keriyen. ");
INSERT INTO avt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hɨr keriyen au, hɨrak kaki te kakri mɨt miyapɨr nɨre nɨkerek yapɨrwe ne God nau nerer wit wit nanɨnen nanɨre mɨt ne weiwɨk miutɨp. ");
INSERT INTO avt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Me wɨ in ere maain, mɨt iuwe ne Isrel nimenɨpɨn nanɨnep Jisas. ");
INSERT INTO avt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mar keremem te Jisas ap ken kitet yayiwe yaaik ke mɨt ne Judia. Hɨrak kɨnaiwɨri hɨrak ken yaank weinɨk mɨt ap newi en, ken wit hak niuk mɨrak Efraim. In ek hɨrak kau ketike mɨt disaipel nɨrak. ");
INSERT INTO avt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wɨ me mɨt ne Isrel nererik nanɨm menmen han tewenɨn nɨpaa God kenep mɨt ne Isip, hɨram epei man menep. Wɨ me mɨt nererik nanɨm menmen wen au, hɨr mɨt miyapɨr nɨnaaiwɨr wit kɨr nɨniu nen wit Jerusalem me nanwet pris menmen te God kaktɨp hɨr yaain, nanɨr ke hɨm me Moses ketpim. ");
INSERT INTO avt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hɨr yapɨrwe nɨpiun wit Jerusalem, hɨr nɨnatɨn Jisas. Hɨr neit wɨnak iuwe ke God nɨmɨn ein, hɨr nitehiyan natɨpan, “Yi han kitet mekam? Hawɨr han kitet hɨrak ap te kaknen in kakɨm menmen kaktike mɨt miyapɨr in taau.” ");
INSERT INTO avt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mɨt iuwe pris netike mɨt ne Farisi epei natɨp mɨt neimɨn nertei Jisas keit nein, te hɨr enɨnen nanɨtpor te mɨt iuwe nanɨno nantɨwek his nankɨp. ");
INSERT INTO avt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Maain wɨ ham Jisas pɨke kan wit Betani, wit kerek Lasaras kewiyen. Hɨrak mɨtɨk kerek Jisas kɨkɨak te pɨke kekrit. Me wɨ im, wɨ hispɨnak kiutɨp (6) wen mepu ere mɨt nererik nanɨm menmen me Pasova. Me wɨ im mɨt hɨr han tewenɨn nɨpaa God kenep mɨt ne Isip, te hɨr Isrel au. ");
INSERT INTO avt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mɨt en hɨr epei nemani menmen me Jisas kakɨm neit wit kɨr eik. Mata wɨkaap mɨt kerek newetɨr menmen. Mɨtɨk Lasaras kau ketike Jisas tekiyakɨt taam menmen. ");
INSERT INTO avt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Te mɨte niuk mɨre Maria, hɨre yenten pe Lasaras wekin mɨn tɨpar me nu nad mɨnɨn mekrerem me mɨt hɨr newɨr pewek iuwe nantɨwem, hɨre wewenem mentar Jisas hɨt mɨrak. Epei au, hɨre wesiunenim meriuwe paan kɨre. Tɨpar yaaim mɨnɨn mekre wɨnak au han iuwe kewen. ");
INSERT INTO avt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mɨtɨk disaipel hak kiutɨp ke Jisas niuk mɨrak Judas ke Iskeriot, kerek maain kakwepyapɨr Jisas kakno his me mɨt iuwe ne Isrel, hɨrak katɨp, ");
INSERT INTO avt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nenmak te mɨt ap neit tɨpar yaaim mɨnɨn im em nesiuwerem nanɨt pewek mererim mar 300 kina te hɨr enwet mɨt enun ap netenen menmen enwetɨrem?” ");
INSERT INTO avt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hɨrak ap han tewenɨn mɨt enun ap netenen menmen au. Hɨrak enuk kekintɨp menmen. Hɨrak naanmɨpre tɨkenup kerek Jisas ketike disaipel nɨrak newis pewek mekrerek ek te hɨrak kekinenim kɨsawɨnem. ");
INSERT INTO avt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Hɨrak katɨp kenerep, te Jisas ketpɨwek, “Ewisiye ewɨrp! Hɨre wetenen menmen im wɨrɨakem me maain hi hahi hɨr mɨt nanwisa akre hei. ");
INSERT INTO avt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mɨt enun netenen menmen au hɨr nanu nantikewi hekrit, te hi au. Wɨ ham hi anaiwɨri.” ");
INSERT INTO avt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mɨt yapɨrwe ne Isrel nemtau Jisas keit wit Betani, te hɨr nen en nanɨrek. Hɨr ap nanɨr Jisas kiutɨp kerekek au. Hɨr nanɨr Lasaras kerek Jisas kɨkɨak kaa ek pɨke kekrit kau. ");
INSERT INTO avt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Te mɨt iuwe pris nimenɨpɨn nanɨnep Lasaras ketike Jisas. ");
INSERT INTO avt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mɨt yapɨrwe neweikɨn sip newet hɨm me mɨt iuwe ne Isrel hɨr nises Jisas, nentar menmen Jisas kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Maain wɨ ham hekrit, mɨt yapɨwe kerek epei nan nererik nanɨm menmen me wɨ Pasova kerek hɨr han tewenɨn God kenep mɨt ne Isip, hɨr nemtau Jisas kaknen wit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Te hɨr neit wapnake neiyɨm nen newenyipɨrek neit yayiwe eik. Te hɨr nɨnap natɨp, “God ti yaaik. Haiu emwenɨpi niuk me mɨtɨk ik kan kakɨkrehɨr ke ti Mɨtɨk luwe God. Ti akaap mɨtɨk ik naanmamre haiu mɨt ne Isrel.” ");
INSERT INTO avt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas kɨnapɨn donki (hɨrak kɨre hos), te hɨrak kewik kar ke hɨm me God mau tɨwei metpim mar im: ");
INSERT INTO avt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yi mɨt yau wit Saion, yi ap einapen! In ek Mɨtɨk luwe ki kaknen kakri kau donki wen yaaik kɨpniu.” ");
INSERT INTO avt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mɨt disaipel nɨrak ap nertei nenmak hɨr nɨrɨak menmen im ere maain Jisas kaa pɨke kekrit ken wit ke God kakɨt niuk iuwe. Maain hɨr han kitet menmen nɨpaa tɨwei me God metpim, hɨr nertei nenmak hɨr nerekyɨwek im em. ");
INSERT INTO avt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mɨt yapɨrwe kerek nɨpaa nau netike Jisas me wɨ kerek hɨrak kenɨne Lasaras nɨpaa hɨrak kaa te hɨrak kekrit kekre herwe hei kan. Mɨt in nɨr menmen im, te hɨr nen newepyapɨr menmen hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mar keremem te hɨr mɨt yapɨrwe nen newenyipɨr Jisas. Hɨr nemtau Jisas kɨrɨak menmen iuwe mar im. ");
INSERT INTO avt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Te hɨr mɨt ne Farisi nesiuwehan hɨm natɨpan nar ik: “Yi eiyɨri! Menmen haiu mɨrɨakem ap te mamwenek taau! Mɨt yapɨrwe ne tɨ ik nisesik.” ");
INSERT INTO avt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mɨt han ne weiwɨk me Grik nan Jerusalem netike mɨt han ne Isrel, te hɨr nererik naam menmen han tewenɨn wɨ nɨpaa God hɨrak kenep mɨt ne Isip. ");
INSERT INTO avt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hɨr nan nɨr mɨtɨk Filip (hɨrak ke wit Betsaida keit provins Galili), te hɨr natɨp, “Mɨtɨk iuwe haiu hanhan mamɨr Jisas mamɨtpɨwek menmen.” ");
INSERT INTO avt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ken katɨp Endru, te hɨrakɨt wiketeret ten tatɨp Jisas. ");
INSERT INTO avt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisas ketpɨwekɨt, “Wɨ apei menep man te hi Mɨtɨk ke wit ke Mɨtɨk luwe, God kakweto niuk mɨrak yaaim iuwe hi etɨwem. ");
INSERT INTO avt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hi hetpi hɨm werek. Yehes kei kiutɨp ke rais kɨnatɨn kɨwaai tɨ au, te yehes kiutɨp kerekek kakpau. Yi eikɨr ekɨkre tɨ, te kakine nɨkim yapɨrwe. Mar im hi hɨr mɨt nanwisa akre hei. Maain hi akrit hi akaap mɨt yapɨrwe nanises hɨm me God. ");
INSERT INTO avt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Neimɨn hanhan nanises han kɨr nanɨwaank hɨras. Neimɨn ap nises han kɨr nau tɨ ik ek, hɨr nises han ke God, te maain han kɨr kaku werek werek tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mɨt neimɨn nanrɨak menmen mai hi hɨrɨakem, te hɨr enisɨsa hɨr nani nanɨr ke hi hahi. Wit kerek hi hewiyen te mɨt nɨrɨak menmen mai hɨr nanwiyen. Te Haai kai kakwis niuk mɨr iuwe kentar hɨr nisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","In ek han kai kekrit kehɨnhɨn te hi atɨp mekam? Te hi atɨp Haai hi anaaiwɨr menmen im mamnen mamiyep? Au, mar keremem te hi han hau tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Haai, ti enip niuk me mɨt emre iuwe!” Jisas katɨp kar ik te hɨm meke nepni man matɨp mar ik: “Hi henip niuk mai mɨre iuwe, te hi pɨke arɨakem mamre iuwe.” ");
INSERT INTO avt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Te mɨt yapɨrwe nerp menep nemtau hɨm kerekek, te hɨr natɨp, “Nepni mewenɨn.” Mɨt han au, natɨp, “Mɨtɨp ensel ke God ketpɨwek.” ");
INSERT INTO avt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisas ketpor, “Hɨm em ap man me menmen mai mamkepa au. Hɨram man te mamɨkepi yi eiyɨrtei God keriuweta hi han tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","In ek, wɨ epei man, te God skelim hɨr mɨt nau tɨ ik ek me menmen enum nɨpaa hɨr nɨrɨakem. In ek hɨrak kakinɨn Seten kerek naanmɨpre menmen enum me tɨ. ");
INSERT INTO avt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te maain mɨt nanwenkɨka hi ahu nu tentarakɨt, te hi ari han ke mɨt yapɨrwe nanisɨsa.” ");
INSERT INTO avt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Jisas katɨp hɨm im keteikɨn mɨt karkeik te hɨrak kaki.) ");
INSERT INTO avt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Te mɨt yapɨrwe pɨke newenhi natɨp nar ik: “Hɨr haiu misesim nɨpaa mɨt newisɨm mau tɨwei hɨram matɨp mɨtɨk kerek God kehimɨtanek kakɨkaap mɨt en te hɨrak kaku kakɨt tipmain tipmain enum eik. Ti henmak te ti hatɨp mɨtɨk ke wit ke Mɨtɨk luwe mɨt han hɨr nanwenkekik hɨrak kaki? Keimɨn hɨrak Mɨtɨk ke wit ke Mɨtɨk luwe God a?” ");
INSERT INTO avt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisas kewenhi ketpor hɨm tok piksa kar ik: “Wepni kakɨr kike kau nɨmɨn ke yi mɨt. Yi eiyitet yayiwe me wɨ wepni (o yanm) kɨr, te yi eiyu werek, te wɨtaan ap mamsawɨn yayiwe. Maain hi anaiwɨri ano, yi eiyɨr mɨtɨk kerek ke wɨtaan kakno kepɨtari yayiwe hɨrak ken nein. ");
INSERT INTO avt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yi eiyisɨsa hi hɨre wepni (o yanm) wɨ hi hepu in, te maain yi yɨre mɨt yi eiyises menmen yaaim.” Jisas katɨp menmen im epei au, hɨrak ken kɨsawɨn hɨrekes kenpɨn kekeipnor. ");
INSERT INTO avt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hɨr mɨt nɨpaa nɨrek kɨrɨak menmen iuwe kɨkaap mɨt nɨnap hɨr nɨre yaain, te hɨr ap han kitet hɨrak Mesaia, mɨtɨk kerek God keriuwetek kan tɨ au. ");
INSERT INTO avt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hɨr ap nisesik, te hɨm nɨpaa mɨtɨk profet Aisaia ketpim kewisɨm mau tɨwei mamnen mar im: “Mɨtɨk luwe, neimɨn nises hɨm maiu? Mɨt auye! Mɨtɨk luwe keteikɨn menmen mɨrak iuwe men neimɨn? Mɨt yapɨrwe!” ");
INSERT INTO avt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Te mɨt ap nisesik nentar hɨm nɨpaa Aisaia pɨke kewisɨm mau tɨwei mar im: ");
INSERT INTO avt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God hɨrak kesor nanamɨr (o naan) kɨr te hɨrak tokik kepu, hɨrak kenipi te hɨr han toenuk. Te hɨr ap nɨr menmen werek werek au, hɨr ap nertei menmen werek werek. Hɨr nertei menmen werek werek, te hɨr nanisesik te hɨrak kakɨkepi hɨr nɨre yaain, te hɨr au.” ");
INSERT INTO avt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mɨtɨk profet Aisaia katɨp menmen im kentar hɨrak kɨr Jisas keit niuk mɨrak iuwe te hɨrak kewepyapɨrek. ");
INSERT INTO avt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Me wɨ im, mɨt iuwe ne Isrel yapɨrwe hɨr nises Jisas. Hɨr nɨnapen mɨt ne Farisi, te hɨr ap newepyapɨr hɨr nises Jisas. Hɨr natɨp te mɨt ne Farisi nanɨpɨri nanɨnepɨn nankeipɨn wɨnak kerek mɨt nererik nekine hɨm me Moses neitai. ");
INSERT INTO avt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hɨr hanhan iuwe mɨt nantɨp hɨr yaain, te hɨr hanhan kike God hɨrak kakɨtpor hɨr yaain. Hɨram menmen weinɨm. ");
INSERT INTO avt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas katɨp hɨm iuwe kar ik: “Neimɨn nisɨsap ap nisɨsa hi kiutɨp kerekek au. Hɨrak kises Mɨtɨk luwe kerek keriuweta hi han tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Neimɨn nɨra, te hɨram mamɨr ke hɨr nɨr Mɨtɨk luwe kerek keriuweta hi han tɨ ik e. ");
INSERT INTO avt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Hi han tɨ ik ek, hi hɨre wepni kɨr. Mɨt neimɨn niutɨp niutɨp kerek nisɨsa, hɨr ap nanu enum nanɨr ke mɨtɨk ke wɨtaan kau auye! ");
INSERT INTO avt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Neimɨn nemtau hɨm mai te ap nisesim, hi ap skelim hɨr mɨt au. Hi ap han tɨ skelim mɨt nau tɨ ik ek au. Hi han te hi akepi. ");
INSERT INTO avt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mɨtɨk keimɨn ke yi mɨt keweikɨn sip keweto ap kemtau hɨm mai, maain menmen mekam skelim mɨtɨk ik a? Me hɨm kerek nɨpaa hi hetpiyem, hɨram skelim mɨtɨk ik me wɨ kerek God skelim mɨt. ");
INSERT INTO avt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Menmen im hɨram werek mentar hi ap hises han kai hetpim au. Haai kerek keriuweta hi han ketpo hɨm te hi ewepyapɨrem. ");
INSERT INTO avt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hi hertei hɨm hɨrak ketpim mamrɨak mɨt nanu werek tipmain tipmain enum eik. Menmen hi hetpiyem hɨram menmen Haai kai ketpewem.” ");
INSERT INTO avt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wɨ me mɨt nererik nanɨm menmen me Pasova kerek hɨr han tewenɨn God kenep mɨt ne Isip teipmen mamnen. Jisas kertei wɨ mɨrak epei man te hɨrak kaki kaknaaiwɨr tɨ ik, te hɨrak pɨke kakno kakɨr God Haai. Hekrit hekrit hɨrak han tewenɨn mɨt nɨrak yaain nau tɨ ik ek. (Hɨrak han tewenɨni ere maain hɨrak kaki.) Te in ek hɨrak kakteiknor hɨrak han tewenɨni wɨsenum. ");
INSERT INTO avt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisas ketike mɨt disaipel nɨrak naam menmen. Seten epei kakri han ke Judas, nɨkan ke Saimon ke wit Iskeriot, te hɨrak kakwepyapɨr Jisas kakwet mɨt enun ek. ");
INSERT INTO avt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas kertei Haai kɨrak God epei kewetɨwek menmen iuwe werek, hɨrak kertei hɨrak kan keke wit ke God, te hɨrak pɨke kakno kakɨrek. ");
INSERT INTO avt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Te Jisas kekrit kekeipɨn yeno kerek hɨr naam menmen menterim em, kenemtɨn laplap saket men, te hɨrak kakɨr laplap taul nokik mau mamɨn mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Epei au, hɨrak kewen tɨpar mekre tɨkenup kekemyetɨt mɨt disaipel nɨrak hɨt hiyap mɨr. Hɨrak kesiunenim keriuwe taul kerek kakɨr kau mamɨn mɨrak em, kɨre mɨtɨk enuk weinɨk kɨrɨak menmen me mɨt iuwe nɨrak. ");
INSERT INTO avt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisas ken kakɨr Saimon Pita, te hɨrak Pita ketpɨwek, “Mɨtɨk luwe, ti henmak te ti hekemyetɨt hɨt mai?” ");
INSERT INTO avt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisas kewenhi ketpɨwek kar ik: “In ek ti ap hertei menmen in ek hi hɨrɨakem. Te maain ti tewen erteiyem.” ");
INSERT INTO avt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita katɨp Jisas, “Ti ap te ekemyetau hɨt mai taauye!” Te Jisas pɨke ketpɨwek, “Hi ap akemyetut hɨt, te ti ap har ke mɨtɨk disaipel kai taau!” ");
INSERT INTO avt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita kewenhi katɨp kar ik: “Mɨtɨk luwe, ti ap ekemyet hɨt mai keremem au. Ti akemyetɨt his metike paan.” ");
INSERT INTO avt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisas katɨp, “Keimɨn kisɨsa hɨrak kɨre mɨtɨk kerek epei kɨkɨr, hɨrak yaaik prar prar, te hɨrak ap pɨke kakɨkɨr hɨrekes. Au, me hɨt miutɨp keremem, hɨrak ekɨkɨrem. Yi yapɨrwe yi yaain yɨre mɨt epei nɨkɨr prar prar neit. Kiutɨp kerekek au. Hɨrak kɨre mɨtɨk hapɨk mewik.” ");
INSERT INTO avt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas epei kertei keimɨn kerek maain kakwepyapɨrek kakno his me mɨt enun, te hɨrak katɨp mɨt nɨrak, “Yi mɨt han ki kɨre mɨt epei nɨkɨr prar prar. Te kiutip au han kɨrak enuk kɨre mɨtɨk ap kɨkɨr hapɨk mewik.” ");
INSERT INTO avt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas epei kekemyetɨt hɨt mɨr epei au, te hɨrak pɨke keriuwet saket mɨrak mɨre laplap, te hɨrak pɨke kau yeno. Hɨrak kau yeno, hɨrak kitorhi, “Yi yertei hi henmak te hi epei herekyiyem o au? Hi hetpi. ");
INSERT INTO avt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yi yenewa hi Mɨtɨk luwe enuk hi ewepiyapɨr hɨm. Hɨram werek te yi yenewa mar im yentar hi hɨrekes luwe kerekek. ");
INSERT INTO avt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hi Mɨtɨk luwe ki hewepiyapɨr hɨm, te hi hekemyeti hɨt. Yi yises menmen hi herekyiyem, yi eikemyetɨt hɨt me ni yinan, yar ke mɨtɨk enuk weinɨk kɨrak menmen me mɨtɨk iuwe kɨrak. ");
INSERT INTO avt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hi epei ateikniyem te yi eiyisesim empar kerek hi epei herekyiyem. ");
INSERT INTO avt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Hi hetpi werek. Mɨtɨk kɨrɨak menmen me mɨtɨk hak, hɨrak ap te kakinɨnek me menmen taau! Mɨtɨk kerek keriuwet mɨtɨk hak katɨp mɨt hɨm mɨrak, hɨrak iuwe kinɨnek. ");
INSERT INTO avt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","In ek yi yertei menmen ti hetpiyem werek yi eiyisesim eirɨakem. Hɨram mamkepi te yi han yaaik eiyu. ");
INSERT INTO avt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Hi ap hatɨp me yi yapɨrwe. Hi hertei neimɨn kerek hi nɨpaa hehimɨteni en. Te hɨm mau tɨwei me God em matɨp menmen mamnen mamɨr im: ‘Mɨtɨk kere hi hewetɨwek menmen hɨrak kaam, hɨrak kerekyo enum.’ ");
INSERT INTO avt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","In ek hi hetpi menmen in. Maain menmen im mamnen mamiyep, te yi eiyɨrtei hi Mɨtɨk ik kerek God keriuweta hi han akaap mɨt ne tɨ. ");
INSERT INTO avt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Hi hetpi hɨm werek! Keimɨn hɨrak kakɨthis mɨt naanmampror kerek hi heriuweti nanɨno ek, hɨrak kakɨr hɨrak kaktauhis. Keimɨn kaktauhis naanmɨprau, hɨrak kakɨr ke hɨrak kakɨthis Mɨtɨk luwe kerek keriuweta hi han in.” ");
INSERT INTO avt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas katɨp hɨm im epei au, hɨrak han enuk kekre han kɨrak, te hɨrak kewepyapɨr ketpor hɨm im. “Hi hetpi werek, Mɨtɨk kiutɨp ke yi mɨt hɨrak maain kakwepayapɨr kakime yipɨr mɨt enun hɨr naniyep.” ");
INSERT INTO avt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Te mɨt disaipel niutɨp niutɨp nɨwaainaan nɨran. Hɨr nepɨtari hɨrak katɨp mɨtɨk keimɨn. ");
INSERT INTO avt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mɨtɨk disaipel kiutɨp hi John hɨrekes kerekek Jisas hanhana, hi hau hɨrapɨt Jisas menep. ");
INSERT INTO avt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita kitauhi keriuwe his katɨp, “Ti hitɨwekhi hɨrak katɨp ke keimɨn.” ");
INSERT INTO avt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pita kitauhi epei au, hi mɨtɨk disaipel ik ek henke hau hɨrapɨt Jisas hitɨwekhi, “Mɨtɨk luwe, keimɨn kakrɨak menmen im?” ");
INSERT INTO avt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas ketpo kar ik: “Hi hatɨp bret ik ek kerek hi awisɨk ekre mɨn tɨpar mekrerek, te hi ewet mɨtɨk kere kakrɨak menmen im em.” Hɨrak katɨp epei au, hɨrak kewet Judas nɨkan ke Saimon ke wit Iskeriot bret ik hɨrak kaak. ");
INSERT INTO avt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas keit bret ik kaak epei au, Seten kan kari han kɨrak, te Jisas ketpɨwek kar ik: “Ti eno waswas erɨak menmen ti hanhan erɨakem.” ");
INSERT INTO avt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Haiu mɨt kerek mekiyan maam menmen em ap mertei mekam Jisas ketpɨwekem. ");
INSERT INTO avt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Haiu mɨt disaipel mertei Judas ketenen pewek maiu mekre tanɨk, te haiu mɨt han kaiu han kitet Jisas ketpɨwek kakno kakwɨr pewek keiyɨm kakɨt menmen me haiu mamɨm, o hɨrak ketpɨwek hɨrak kakno kakwet mɨt kerek ap netenen menmen kakwetɨr pewek mei. ");
INSERT INTO avt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Te Judas keit bret wasenum, hɨrak ketpaan ken witeik. In ek hɨrak wɨtaan toto. ");
INSERT INTO avt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas epei ken witeik, Jisas katɨp, “In ek hi Mɨtɨk ke wit ke Mɨtɨk luwe ahɨt niuk iuwe me menmen hi arɨakem akaap mɨt. Te in ek God kakɨt niuk iuwe kentar menmen hi arɨakem. ");
INSERT INTO avt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","God kakɨt niuk iuwe, te hɨrak kakteikɨn mɨt hi Mɨtɨk ke wit kɨrak kakteiknor hi niuk mai iuwe. Hɨrak kakrɨakem waswas. ");
INSERT INTO avt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nɨkerek nai hi ap te hahu tɨ ik ek atikewi wɨ yapɨrwe. Maain yi yayɨn yayɨtno te hi hetpi hɨm im em. Hi epei heptɨp mɨt iuwe ne Isrel em mar im: ‘Yi ap te yaino wit kerek hi anori en.’ ");
INSERT INTO avt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Hi etpi hɨm ham yaaim yi eiyisesim. Yi han etwenɨnan eiyɨr ke han tewenɨni, te yi han etwenɨnan emɨt ek keremem. ");
INSERT INTO avt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yi han tewenɨnan, te hɨr mɨt nerer wit wit nanri nantɨp yi disaipel ne hi Jisas. ");
INSERT INTO avt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita kitɨwekhi kar ik: “Mɨtɨk luwe ti eno nein?” Jisas ketpɨwek, “Ti ap ehisɨsa eno wit kerek hi anori en. Te maain ti ehisɨsa.” ");
INSERT INTO avt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita kitɨwekhi, “Mɨtɨk luwe ti henmak te hi ap ehisesit in ek a? Hi epei hanhan hahi akepit.” ");
INSERT INTO avt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas kewenhi katɨp, “Ti werek te ti hanhan hahi akepa a? Hi etput hɨm werek. Suware ap te kaknep enum wen au, te ti ehiune atɨp wikak ti herteiya au.” ");
INSERT INTO avt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas wen katɨp kar ik: “Yi ap han enuk te yi han ekitet menmen au emɨt! Yi yises God, te in ek yi eiyisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wɨnak ke Haai kai haau yapɨrwe mekrerek. Hi ehinɨn ano etnɨni wit kakmerɨri. Hi etpiyem mentar menmen im mepu. Au hi ap te etpiyem. ");
INSERT INTO avt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Maain hi epei hetnɨni wit epei au, te hi pɨke anen atihis yainen, te yi eiyu wit kerek hi hewiyen. ");
INSERT INTO avt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yi yertei eiyises menmen te yi eino wit kerek hi enori en.” ");
INSERT INTO avt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mɨtɨk Tomas katɨp Jisas, “Mɨtɨk luwe, haiu ap mertei nein ti enori en. Emɨrkeik te haiu emɨrkeik te haiu emɨrtei yayiwe kakno keriyen a?” ");
INSERT INTO avt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas ketpɨwek, “Hi hɨre yayiwe, te mɨt nanɨr God. Hi Haai ke hɨm yaaim, hi Haai ke menmen mamkaap mɨt nanɨt hɨmɨn yaaik kaku kakɨt tipmain tipmain enum eik. Neimɨn nanɨno Haai kai God ek, te hɨr nanisɨsa nanre hɨr nitet yayiwe. ");
INSERT INTO avt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","In ek yi epei yerteiya. Te yi yayɨrtei Haai kai God. Te in ek ere maain yi yerteiyek, yi nepei yɨrek.” ");
INSERT INTO avt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mɨtɨk Filip katɨp Jisas, “Mɨtɨk luwe, to eteiknai God Haai, te haiu han yaaik emu.” ");
INSERT INTO avt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas ketpɨwek, “Nɨpaa enum eik hi epei hau hetikewi wɨ yapɨrwe, te in ek Filip, yi wen au yepɨtari menmen? Neimɨn epei nɨra, te hɨr epei nɨr Haai kai. Ti henmak te ti hitauhi, ‘Eteiknai God Haai hɨrak kɨre mekak a?’ ");
INSERT INTO avt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip ti ap hertei Haai kai God ketikewa hawɨr wekiyakɨt wau niutɨp? Menmen hi hetpiyem hɨrak ap hɨm mai au. Haai kerek kau kekre han kai hɨrak kerekek kises han kɨrak kɨrɨak menmen mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yi eiyises hɨm hi etpiyem kerek hi etpi hi hetike Haai kai God hawɨr wekiyakɨt wau niutɨp. Te hɨm im au yi eiyɨr menmen kerek hi hɨrɨakem hɨkaap mɨt nɨnap his hɨt enum nɨre yaain, te yi eiyɨrtei hi etike Haai kai hawɨr wekiyakɨt wau niutɨp. ");
INSERT INTO avt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Hi hetpi hɨm werek. Mɨt neimɨn nanisɨsa, hɨr nanrɨak menmen iuwe mamɨr ke hi hɨrɨakem. Menmen hɨr nanrɨakem hɨram maminɨn menmen mai mamɨntar hi ano ahɨr Haai kai ehu etikerek esiuwe God Hɨmɨn Yaaik kaknen kakɨkaap yi mɨt. ");
INSERT INTO avt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te hi eweti menmen kerek yi eiyitehi God em meriuwe niuk mai iuwe. Hi ewetiyem, te mɨt nanwenɨpi niuk me God Haai nanɨntar menmen hi arekyiyem. ");
INSERT INTO avt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yi eiyitauhi menmen heriyai heriyai eiriuwe niuk mai iuwe, te hi arɨakem ewetiyem. ");
INSERT INTO avt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Yi hanhana, te yi eiyises hɨm hi hetpiyem. ");
INSERT INTO avt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hi tewen ehitehi Haai kai kakweti keiyak kaknen kakɨkepi kaku kaktikewi tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hɨrak God Hɨmɨn Yaaik kaktɨp mɨt hɨm yaaim kakɨkre han kɨr. Hɨrak ap kaku han ke mɨt ne tɨ kentar hɨr ap nɨrek nerteiyek. Te yi eiyɨrteiyek eiyɨntar hɨrak kaku kaktikewi kaku kakɨkre han ki. ");
INSERT INTO avt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Maain wɨ hi ano wit ke Haai kai, hi ap enaiwɨri te yi yayu weinɨm eiyɨr ke nɨkan miye haai aurek. Au, hi pɨke anen. ");
INSERT INTO avt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wɨ epei menep te mɨt ne tɨ ik ek ap te pɨke nanɨra au. Te yi eiyɨra. Maain yi yayi yi pɨke yaiyɨkrit yayu eiyɨntar hi hahi hi pɨke akrit ehu. ");
INSERT INTO avt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Maain hi pɨke ekrit ehu, yi eiyɨrtei hi etike Haai kai God hawɨr wekiyakɨt wau niutɨp. Yi eiyɨrtei hi hetikewi haiu mekiyan mau niutɨp. ");
INSERT INTO avt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mɨt neimɨn nertei hɨm mai nisesim, hɨr keriyen hanhana. Te Haai kai hanhani kentar hɨr hanhana. Te hi hanhani heteiknor hekre han kɨr hi hau hetikeri.” ");
INSERT INTO avt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mɨtɨk Judas hak (ap mɨtɨk Judas ke wit Iskeriot au) hɨrak katɨp, “Mɨtɨk luwe, ahɨrkeik te ti anen eteiknai hɨrekes, te mɨt yapɨrwe ne tɨ ik ek au a?” ");
INSERT INTO avt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas ketpɨwek, “Mɨt neimɨn hanhan nanises hɨm mai, te Haai kai hanhani. Te Haai kai ketikewa hawɨr wawu wawɨkre han kɨr. ");
INSERT INTO avt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mɨt neimɨn ap hanhana ap nanises hɨm mai au. Hɨm kerek hi epei etpiyem em ap mekre han kai man au. Hɨram menmen me Haai kai kerek keriuweta te hi han tɨ ik ek, hɨram man. ");
INSERT INTO avt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Hi hepu hetikewi te hi epei hetpi hɨm im em. ");
INSERT INTO avt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","God Hɨmɨn Yaaik kakɨkepi, God Haai kaksiuwerek kaknen kakɨntera kakteikni menmen yapɨrwe te kakɨkepi han tewenɨn hɨm kerek nɨpaa hi epei hetpiyem. ");
INSERT INTO avt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Hi are aneiwɨri te hi han yaaik kai kaku kakɨkri. Hi han yaaik kai hi ewetiyem, hɨram mamre han yaaik ke mɨt ne tɨ ik ek netɨwem au. Yi ap han kekrit einaain menmen mamnen au emɨt! ");
INSERT INTO avt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yi epei yemtau hi hetpi hi epei eneiwɨri ano. Te hi pɨke anen ari. Yi hanhana, te yi han yaaik hi pɨke ano ahɨr Haai kai kentar hɨrak iuwe kinɨna kakɨkepi iuwe te yi eirɨak menmen yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hi epei hinɨn hetpi menmen im em in ek me wɨ menmen ap mamnen wen au. Te maain hɨram mamnen, yi eiyɨrtei hi Mɨtɨk kerek nɨpaa God hɨrak keriuweta hi han tɨ ik ek. ");
INSERT INTO avt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hi ap hatɨp hetikwei yapɨrwe hentar mɨtɨk enuk Seten hɨrak iuwe kinɨn naanmɨpre mɨt miyapɨr ne tɨ ik e kaknen kaktauhis. Hɨrak ap kinɨna au. ");
INSERT INTO avt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Te hi ewisɨk hɨrak kaktauhis, te mɨt yapɨrwe ne tɨ ik ek, hɨr enɨrtei hi hanhan Haai kai God, hi hɨrɨak menmen yapɨrwe hɨrak ketpo hi hɨrɨakem. Eiyɨkrit, emnaaiwɨr wit ik haiu emno.” ");
INSERT INTO avt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas katɨp, “Hi hɨre waai yaaim. Haai kai God hɨrak kɨre mɨtɨk naanmɨpre waai mekre ni. ");
INSERT INTO avt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mɨt nisɨsa hɨr nɨre nu heneik mari. Neimɨn hɨr ap nisɨsa werek werek, hɨr nɨre nu heneik ap mari, te Haai kai kakremir. Nu heneik mari mine nɨkim, Haai kai keremir yinam ere hɨram yaaim te tito ham hɨram mamri mamu menep menep. ");
INSERT INTO avt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yi epei yaain yentar hɨm mai hi hetpiyem hɨram mau mekre han ki. ");
INSERT INTO avt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yi eiyisɨsa, te hi ehu ekre han ki. Nu heneik ap mau waai, hɨram mamri mamine nɨkim au. Yi mɨt ap yisɨsa, te yi ap yɨrɨak menmen yaaim au. ");
INSERT INTO avt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Hi hɨre waai, yi yɨre heneik mai. Neimɨn hɨr nisɨsa, hi hahu akre han kɨr, hɨr nanrɨak menmen yaaim. Yi ap yisɨsa, te yi yɨrɨak menmen yaaim au. ");
INSERT INTO avt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Neimɨn ap nisɨsa, God keriuweti nen nɨre mɨt neket heneik enum newɨrem mɨwaai tɨ meweiwei meit. Maain hɨr nanɨt heneik mar im nanwɨrem mamno si, si tatɨm. ");
INSERT INTO avt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yi yisɨsa, hɨm mai mau mekre han ki merekyi yi yisesim, maain yi eiyitehi God menmen yi hanhanem, te hɨram mamnen mamɨr ke yi yitɨwekhiyem. ");
INSERT INTO avt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yi yɨrɨak menmen yaaim, te mɨt nanwenɨpi niuk me Haai kai, te yi yeteikɨn mɨt yi mɨt disaipel nai yi yisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hi hanhan eriuwi har ke Haai hanhan keriuwa. Yi yewisa hi wen naanempri hanhan heriuwi. ");
INSERT INTO avt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yi yises hɨm mai, te yi yewisa hi wen naanmɨpri hanhan heriuwi har ke hi hises hɨm me Haai kai, te hɨrak naanmɨprau hanhan keriuwa. ");
INSERT INTO avt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Hi epei etpi menmen im te menmen menipa hi han yaaik mamu maɨkre han ki, te yi han yaaik iuwe. ");
INSERT INTO avt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hi hetpi hɨm im yi eiyisesim. Yi hanhan yeriuwehan eiyɨr ke hi hanhan heriuwi. ");
INSERT INTO avt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mɨtɨk hak ap kɨrɨak menmen han kakinɨn kakteikɨn mɨt hɨrak hanhan keriuwi wɨsenum, te hɨrak kaki te kakɨkepi. ");
INSERT INTO avt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yi yises menmen hi epei etpiyem, yi yɨre nai yinan. ");
INSERT INTO avt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","In ek, hi ap atɨp yi yɨre mɨt nɨrɨak menmen mai weinɨm au, hentar mɨt nɨrak nar ik hɨr netari menmen mɨtɨk kɨr kɨrɨakem. Au, hi atɨp yi nai yinan yentar hi epei etpi menmen yapɨrwe Haai kai ketpewem. ");
INSERT INTO avt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yi ap yehimɨtena yi yisɨsa au. Hi hehimɨteni yi yisɨsa, yi eirɨak menmen yaaim, te menmen im mamu mamɨt. Yi yɨrɨak menmen im, te Haai kakweti menmen menmeiyam yi yitɨwekhiyem kakɨntar yi yisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Te hi etpi hɨm mai im: Yi hanhan mɨt han. ");
INSERT INTO avt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Mɨt ne tɨ hɨr nɨneini, te yi han ekitet nɨpaa hɨr nɨneina. ");
INSERT INTO avt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yi mɨt yi yises menmen me tɨ im e te mɨt ne tɨ hanhan neriuwi nar ke hɨr hanhan hɨras. Au, hi hehimɨteni yi yisɨsa, te yi ap ne tɨ au, hɨr mɨt ne tɨ nɨneini. ");
INSERT INTO avt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yi han ekitet menmen hi hetpiyem. Mɨtɨk kɨrɨak menmen me mɨtɨk iuwe kɨrak ap kinɨnek au. Nɨpaa hɨr mɨt nerekiyo menmen enum, te hɨr nanrekyi menmen enum. Nɨpaa hɨr mɨt han nises hɨm mai, te maain hɨr nanises hɨm mai. ");
INSERT INTO avt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hɨr nanrekyi menmen im enum nanɨntar yi yisɨsa. Hɨr ap nertei God kerek keriuweta hi han, te hɨr nisesik au. ");
INSERT INTO avt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Hi ap han hetpor menmen, hɨrɨak menmen yaaim te mɨt nanweikɨn sip nanwet God hɨram menmen enum kike. Au, hi epei etpor menmen hɨrɨak menmen yaaim, te in ek hɨr neweikɨn sip newet God te hɨrak kaktɨp hɨr nɨrɨak menmen enum iuwe hɨrak kakɨwaanki. ");
INSERT INTO avt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Neimɨn nɨneina ap nisɨsa, hɨr nɨnaain Haai kai ap nisesik au. ");
INSERT INTO avt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hi ap hɨrɨak menmen menmeiyam kerek nɨpaa mɨt nɨrɨakem au, te hɨr neweikɨn sip newet God, hɨr nɨrɨak menmen enum kike. Te hɨr epei nɨr menmen iuwe hi hɨrɨakem, hɨr neweikɨn sip newet God hɨr nɨneina hetike Haai kai. ");
INSERT INTO avt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Menmen im hɨr nɨrɨakem epei man, te hɨm mau tɨwei hɨr nisesim hɨram mamnen mamɨr ke hɨm nɨpaa mɨt netpim hɨram mamnen. Hɨm im matɨp mar im: ‘Hɨr nɨneina nentar menmen au weinɨm keremem.’ ");
INSERT INTO avt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Maain, hɨrak kerek kakɨkaap mɨt, hɨrak kaknen. Hɨrak God Hɨmɨn Yaaik katɨp hɨm yaaim, hɨrak keke wit ke God kaknen. Hɨrak kaknaaiwɨr Haai, hi eriuwetek kaknen yi mɨt, hɨrak kakwepyapɨr menmen mai kakɨtpiyem. ");
INSERT INTO avt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yi yetikerek yi yaitɨp mɨt me menmen mai yentar nɨpaa wɨ kerek hi hinɨn ewepyapɨr hɨm mai, yi yetikewa haiu mariyan.” ");
INSERT INTO avt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas katɨp, “Hi epei hetpi hɨm im em te yi ap einaaiwɨr hɨm mai yayises menmen ham enum. ");
INSERT INTO avt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Te hɨr mɨt nanɨpɨri yi yainepɨn wɨnak ke God kerek hɨr nererik nekine hɨm me Moses nekrerem. Maain wɨ mamnen te mɨt han kitet hɨr naniwep te hɨr nankaap God. ");
INSERT INTO avt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hɨr nanrekyi menmen enum mar im nentar hɨr ap nertei hi hetike Haai kai God, hɨr ap nisɨsawɨr au. ");
INSERT INTO avt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hi epei hetpi hɨm im te maain wɨn mamnen me hɨr nanrekyi menmen mar im, yi han ekitet nɨpaa hi epei hetpiyem. “Nɨpaa hi ap hetpi menmen in ek hi are etpiyem hentar hi wen hepu hetikewi. ");
INSERT INTO avt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Te in ek hi han hahɨr Haai kai kerek keriuweta hi han in. Te ap keimɨn ke yi mɨt hanhan yitauhi, ‘Ti eno nein.’ ");
INSERT INTO avt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Te in ek hi epei hetpi, te yi epei han enuk kekre han ki. ");
INSERT INTO avt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Te hi hetpi werek. Hɨrak yaaik kakɨkepi te hi ano hahɨntar hi ap ano, te Hɨmɨn Yaaik kerek kakɨkepi ek ap te kaknen kaku kaktikewi taau. Hi ano, te hi eriuwetek kaknen kaku kaktikewi. ");
INSERT INTO avt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te maain hɨrak kaknen hɨrak kakteikɨn kaktɨp mɨt ne tɨ ik ek ap nanɨrtei hɨr nises menmen enum, ap nertei mekam yaaim, te God skelim. ");
INSERT INTO avt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hɨrak kakteikɨn mɨt hɨr nɨrɨak enum nentar hɨr ap nisɨsa. ");
INSERT INTO avt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Hɨrak kakteiknor mekam yaaim iuwe kakɨntar hi ano ahɨr Haai kai hɨrak Hɨmɨn yaaik kakɨkrehɨr kai. Te yi ap pɨke eiyɨra au. ");
INSERT INTO avt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Hɨrak kakteikɨn mɨt God skelim mɨt ne tɨ nises menmen enum kakɨntar God epei skelim mɨtɨk Seten kerek kinɨn naanmɨpre tɨ. ");
INSERT INTO avt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Hi hɨm yapɨrwe mepu te hi ap etpiyem hentar in ek yi ap yayɨrteiyem werek au. ");
INSERT INTO avt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Maain God Hɨmɨn Yaaik kerek katɨp hɨm yaaim kaknen, hɨrak kakteikni menmen yapɨrwe yaaim. Hɨrak ap te kaktɨp menmen me han kɨrak au. Nɨpaa hɨrak kemtewem, te hɨrak kakɨtpiyem te maain hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hɨrak kakwenɨpi niuk mai kentar menmen kerek hi hetpim, hɨrak kaktɨwem kakɨtpiyem kekre han ki. ");
INSERT INTO avt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Menmen yapɨrwe me Haai kai God hɨram mai. Mar keremem, te hi hatɨp God Hɨmɨn Yaaik kakɨt hɨm mai te hɨrak kakɨtpiyem kakɨkre han ki. ");
INSERT INTO avt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Maain kike yi ap yayɨra au. Maain wɨ ham yi pɨke eiyɨra.” ");
INSERT INTO avt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mɨt han ne mɨt disaipel nɨrak nitehiyan nar ik: “Mekam im hɨrak ketpaiyem katip, ‘Maain yi ap yayɨra au, maain wɨ ham yi pɨke eiyɨra.’ Hɨm im metike hɨm ham im e: ‘Hi hentar hi eno ahɨr Haai.’ Kenmak te hɨrak ketpim?” ");
INSERT INTO avt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Hɨr natɨpan nar ik: “Mekam hɨm hɨrak katɨp: ‘Me wɨ kike?’ Haiu mepɨtari hɨm im!” ");
INSERT INTO avt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas kertei hɨr hanhan nitɨwekhi me menmen in te hɨrak ketpor, “Yi yitehiyan menmen hi etpim me maain kike yi ap yayɨra, maain wɨ ham yi pɨke eiyɨra a? ");
INSERT INTO avt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Hi etpi werek. Maain yi yaiyɨkta wɨsenum han tatwenɨna, te mɨt ne tɨ hɨr han yaaik iuwe. Yi han enuk eiyu te maain yi han yaaik iuwe. ");
INSERT INTO avt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mɨte sip newenep weteiknen weriuwe nɨkerek hɨre han enuk wenterim. Maain hɨre wine nɨkerek hɨre ap han kitet menmen im mewo au. Hɨre han yaaik wentar hɨre wine nɨkerek. ");
INSERT INTO avt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","In ek yi han enuk yentar hi hahi, te maain hi pɨke ekrit ari, te yi han yaaik eiyu. Mɨtɨk keiyak ap te kakri menmen im yaaim mau mekre han ki au. ");
INSERT INTO avt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Maain wɨ eim mamnen, te yi ap eiyitauhi me menmen. Hi etpi werek, yi eiyitehi Haai me menmen in ek, te hɨrak kakwetiyem yeriuwe niuk mai iuwe. ");
INSERT INTO avt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nɨpaa ere in yi ap yitehi God me menmen yentar yi yeriuwe niuk mai iuwe. Yi yitɨwekhi menmen yi yaitɨwem, te hɨrak kakrekyi han yaaik iuwe. ");
INSERT INTO avt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Hi epei hetpi hɨm mei mɨre tok piksa, te maain wɨ mamnen te hi etpi eriuwe menmen im au. Hi etpi eriuwe hɨm yaaim me God Haai, te yi eiyɨrteiyem werek werek. ");
INSERT INTO avt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Maain wɨ eim mamnen yi yitehi God yeriuwe niuk mai iuwe. Hi ap hitɨwekhi menmen me yi mɨt au ");
INSERT INTO avt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","hentar Haai kai God hɨrekes hanhani kakɨmtau menmen mi yi yitɨwekhiyem. Hɨrak hanhani kentar yi hanhana, yi yertei hi hɨnaaiwɨr Haai hi han tɨ ik. ");
INSERT INTO avt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nɨpaa hi hɨnaaiwɨr Haai hi han tɨ ik e. In ek, hi hɨnaaiwɨr tɨ ik pɨke ano ahɨr Haai.” ");
INSERT INTO avt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mɨt disaipel nɨrak netpɨwek nar ik: “In ek ti atɨp werek. Ti ap atɨp hɨm tok piksa au. ");
INSERT INTO avt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","In ek haiu mertei ti hertei menmen yapɨrwe, te haiu mituthi menmen ti hetpim hɨram yaaim au. Haiu mertei ti hɨnaaiwɨr God ti han tɨ eik mentar menmen im ti etpaiyem.” ");
INSERT INTO avt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas ketpor, “In ek yi han kitet yi yertei hi hɨnaaiwɨr God han in. ");
INSERT INTO avt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Te wɨ epei man te mɨt nanripɨr yi eirɨr eino ein ein, te hi kiutɨpen kerekek ehu. Hi kerekek ehu au. God kau ketikewa. ");
INSERT INTO avt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Hi epei etpi menmen im te yi yetikewa emkiyan han kiutɨp emu, te yi han yaaik eiyu. Mɨt ne tɨ nanrekyi menmen enum, te yi han tokik eiyu. Hi epei hinɨn menmen enum mɨt ne tɨ hɨr nisesim.” ");
INSERT INTO avt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas katɨp menmen im epei au, hɨrak kɨkɨamnaan katɨp kar ik: “Haai, wɨ epei man. Ti ewenɨpi niuk mai, hi Nɨkan kit heriuwe menmen ti herekyewem, te hi ewenɨpi niuk mit. ");
INSERT INTO avt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ti epei heweto hɨm mit ti atɨp hɨram yaaim werek, te hi ewet mɨt miyapɨr ne tɨ hewetɨr hɨmɨn yaaik te hɨr nanu werek tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mɨt nertei ti, ti God kiutɨp kerekek, ti etikewa hi Jisas Krais, Mɨtɨk kerek ti heriuweta hi han, hɨr enɨrteiyawɨr enisɨsawɨr. Neriuwe menmen im hɨr nisesim, hɨram mamkepi hɨr nanu werek tipmain tipmain enum eik. ");
INSERT INTO avt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Hi heteikɨn mɨt miyapɨr niuk mit iuwe heit tɨ ik e. Hi epei hɨrɨak menmen ti ehimɨtanem hi hɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Haai, ti pɨke eweto niuk mai iuwe kerek nɨpaa tɨ kepu wen au, hi hetenenim hau hetikewit. ");
INSERT INTO avt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Hi epei hewepyapɨr hatɨp mɨt kerek ti ewetori ne tɨ ik e, hetpor ti hɨre mekam. Hɨr mɨt nit te ti ewetori hɨr epei nises hɨm mi. ");
INSERT INTO avt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","In ek hɨr nertei menmen yapɨrwe hi hɨrɨakem, nɨpaa ti ewetewem hi hɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Hi epei hetpor hɨm nɨpaa ti etpewem, te hɨr nisesim. Hɨr nertei ti heriuweta hi heke wit kit hekuwe han in. ");
INSERT INTO avt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Hi hituthi ti ekaap mɨt in. Hi ap hituthi ti ekaap mɨt nises menmen me tɨ au. Hi hituthi ti ekaap mɨt kerek ti ewetori hentar hɨr mɨt nit. ");
INSERT INTO avt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Menmen yapɨrwe hi hetenenim hɨram mit. Menmen yapɨrwe ti hetenenim hɨram mai. Mɨt nanɨrtei niuk mai iuwe nentar menmen mɨt nai in nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","In ek, hi anen arit. Maain hi ap hahu tɨ ik, te hɨr nanu tɨ ik e. Haai Kai Yaaik, ti naanmampror eriuwe niuk mit iuwe, niuk im kerek nɨpaa ti ewetewem, te mɨt in nantikewit nankiyan han kiutɨp nar ke ti etikewa hawɨr wekiyakɨt han kiutɨp. ");
INSERT INTO avt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wɨ kerek hi hau hetikeri hi naanempror heriuwe menmen iuwe mit. Hɨr yapɨrwe nepu werek te kiutɨpen au kerek hɨrak kakɨwaank hɨrekes, te hɨm mit kerek mɨt hɨr newisɨm mau tɨwei mamnen mamɨr ke nɨpaa mɨt newisɨm. ");
INSERT INTO avt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","In ek hi enen arit. In ek hi hatɨp hɨm im hi hau tɨ te hɨr nemtau hɨm hi hetputem hɨr nanɨt han yaaik kai iuwe kaku kakɨkri. ");
INSERT INTO avt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hi epei hetpor hɨm ti etpewem. Mɨt miyapɨr nau tɨ hɨr nɨneini nentar mɨt in hɨr ap nises menmen me tɨ nar ke hi ap hisesim. ");
INSERT INTO avt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hi ap hituthi ti etorhis hɨr nɨnaaiwɨr tɨ ik ek au. Hi hituthi te ti naanempror, te mɨtɨk enuk Seten ap kakɨwaanki. ");
INSERT INTO avt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hɨr ap nises menmen me tɨ mɨt nisesim nar ke hi ap hisesim au. ");
INSERT INTO avt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ti ehimɨteni hɨr mɨt nit neriuwe hɨm yaaim mit hi etporem. Hɨm mit hɨram yaaim. ");
INSERT INTO avt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hi heriuweti nen mɨt miyapɨr ne tɨ nɨrɨak menmen mai nɨre nɨpaa ti heriuweta hi hen mɨt miyapɨr ne tɨ hɨrɨak menmen mit. ");
INSERT INTO avt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hi hehimɨtan hɨrekes hi ewetut yɨnk kai hi hahi, te hɨr mɨt ti ehimɨteni hɨr nisesit werek werek neriuwe hɨm yaaim mit hi etporem. ");
INSERT INTO avt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Hi hituthi me mɨt in keriyen au. Hi hituthi ti akaap mɨt miyapɨr nanises hɨm mit nanɨntar hɨm hɨr mɨt in nanɨtporem te hɨr nanɨmtewem. ");
INSERT INTO avt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Haai, hi hanhan hɨr yapɨrwe nankiyan nanu han kiutɨp, nar ke ti etikewa hawɨr wekiyakɨt wau han kiutɨp. Hi hanhan hɨr han kiutɨp nanisɨsawɨr te mɨt miyapɨr nau tɨ nanɨrtei ti heriuweta hi han in. ");
INSERT INTO avt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hi epei ewetɨr niuk mai iuwe kerek nɨpaa ti ewetewem, te hɨr enu han kiutɨp nanɨr ke ti etikewa hawɨr wekiyakɨt wau han kiutɨp. ");
INSERT INTO avt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Hi hahu ekre han kɨr har ke ti hau ekre han kai, te hɨr nekiyan nanu han kiutɨp te mɨt miyapɨr ne tɨ nanɨrtei ti heriuweta hi han tɨ ik. Ti hanhan heriuweri har ke ti hanhan heriuwa. ");
INSERT INTO avt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Haai, ti epei heweto mɨt in hɨr nai. Hi hanhan hɨr nanɨnen nanu nantikewa nanu wit kerek maain hi hahu en, te hɨr nanɨrtei niuk mai iuwe. Niuk mai iuwe im me wɨ ti hɨrɨak tɨ wen au, ti hanhan heriuwa ti ewetewem. ");
INSERT INTO avt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Haai Kai Yaaik. Mɨt ne tɨ ap nerteiyit nisesit werek werek au. Hi kerekek. Mɨt in hɨr nertei ti heriuweta hi han. ");
INSERT INTO avt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Hi epei hetpor me ti, hi wen etporem te ti hanhani har ke ti hanhana, hi ehu ekre han kɨr.” ");
INSERT INTO avt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas kitehi God menmen epei au, hɨrak kɨnaaiwɨr wit ketike mɨt disaipel nɨrak hɨr nerekir hɨtɨk Kidron. Ni miutɨpen mepu in te Jisas ketikeri nen nau en. ");
INSERT INTO avt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mɨtɨk Judas hɨrak enuk kewepyapɨr Jisas kertei ni ik ek kentar nɨpaa me wɨ yapɨrwe Jisas ketike mɨt disaipel nɨrak nererik nau en. ");
INSERT INTO avt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas keit mɨt ne ami han netike mɨt kerek naanmɨpre wɨnak iuwe ke God kerek mɨt iuwe pris netike mɨt han ne Farisi hɨr neriuweti nanɨno, hɨr yapɨrwe netike Judas nen ni im em. Hɨr netenen yipo henmik, hɨr nemsiu si nen. ");
INSERT INTO avt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas kertei menmen yapɨrwe mɨt nanrekyɨwekem, te hɨrak kinɨn ken katɨp, “Yi yɨnyatɨn keimɨn?” ");
INSERT INTO avt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hɨr netpɨwek, “Haiu man mɨnmatɨn Jisas ke wit Nasaret mamtɨwekhis.” Hɨrak ketpor, “Hi hɨrekes Jisas.” ");
INSERT INTO avt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Judas mɨtɨk enuk kewepyapɨr Jisas kerp ketikeri. ");
INSERT INTO avt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jisas ketpor, “Hi hɨrekes Jisas,” te mɨt en hɨr pɨke neriuwet nen nenke nɨwaai tɨ. Hɨr nen nenke nɨwaai tɨ, Jisas kitorhi keteipim, “Yi yɨnyatɨn keimɨn?” Hɨr netpɨwek neteipim, “Haiu man mɨnmatɨn Jisas ke wit Nasaret mamtɨwekhis.” ");
INSERT INTO avt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisas pɨke ketpor, “Hi epei hetpi hi hɨrekes Jisas. Yi epei yan yetauhis te yi eiwis mɨt nai in nanɨno.” ");
INSERT INTO avt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hɨrak katɨp menmen im, te hɨm nɨpaa hɨrak ketpim mamnen mamɨr em. Nɨpaa hɨrak katɨp, “Haai, mɨt kerek ti ewetauri, hi ap hɨnaaiwɨr keiyak au.” ");
INSERT INTO avt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita ketenen hɨne ke his, hɨrak keketik kekre paus kɨrak kɨwaaiyek keremir nɨkɨp me mɨtɨk niuk mɨrak Malkas, kerek kɨrɨak menmen me mɨtɨk pris iuwe. ");
INSERT INTO avt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisas katɨp Pita kar ik: “Ti pɨke ewis hɨne ke his kakno paus kɨrak. Hi are ewis mɨt nanrekiyo menmen Haai kai kehimɨtan hɨr nanrekiyewem naniyep nanrewaank.” ");
INSERT INTO avt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mɨt ne ami netike mɨtɨk iuwe kɨr, hɨr netike mɨt kerek naanmɨpre wɨnak iuwe ke God, hɨr neithis Jisas nesenkek his mɨrak, ");
INSERT INTO avt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","hɨr neiyɨk ninɨn nen nɨr mɨtɨk Anas. Hɨrak kenɨne Kaiafas yenik kɨrak. Kaiafas me tito im hɨrak kɨre mɨtɨk iuwe kinɨn pris han yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hɨrak Kaiafas kerekek nɨpaa katɨp mɨt ne Isrel hɨram yaaim te mɨtɨk kiutɨp kaki kakɨkrehɨr ke haiu mɨt yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Hɨr neit Jisas neiyɨk nen ein, Saimon Pita ketike hi disaipel hak wises Jisas. Mɨtɨk pris iuwe kinɨn pris han yapɨrwe hɨrak kertei mɨtɨk disaipel hak, te hɨrak ken kerp ke nɨmɨn ke nɨwa keweikɨn wɨnak. ");
INSERT INTO avt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita au hɨrak kerp menep ya weipɨr ke nɨwa keit witeik. Hi mɨtɨk disaipel kerek mɨtɨk iuwe pris kerteiyek, hi pɨke hen witeik hatɨp mɨte werp naanmɨpre ya weipɨr te hɨre weithis Pita weiyɨk wen nɨmɨn. ");
INSERT INTO avt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mɨte kerek naanmɨpre weipɨr eik watɨp Pita, “Ti ik e mɨtɨk hises hɨm me Jisas o au?” Pita ketpɨwe, “Hi au.” ");
INSERT INTO avt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nɨme menep mɨt nɨrɨak menmen me mɨtɨk iuwe pris, hɨr netike mɨt kerek naanmɨpre wɨnak iuwe ke God te hɨr nɨman si nerp neweiknɨwem nekinɨn yɨnk kɨr. Pita ken kerp ketikeri kekinɨn yɨnk kɨrak. ");
INSERT INTO avt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mɨtɨk nɨpaa hɨrak hetpris kitehi Jisas ke mɨt hɨr nisesik, kitɨwekhi me hɨm hɨrak katɨp mɨt em. ");
INSERT INTO avt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisas ketpɨwek kar ik: “Hekrit hekrit hi hepu wit mɨt nererik, hi hatɨp mɨt miyapɨr menmen. Hi heit wɨnak kerek mɨt nererik nekine hɨm me Moses o hepu wɨnak tempel ke God wit kerek mɨt ne Isrel nererik, hi hewepyapɨr hɨm mai. Hi ap hɨsawɨn hatɨp menmen meiyam au. ");
INSERT INTO avt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Te henmak te ti hitauhi menmen? Ti hitehi mɨt kerek nemtau hɨm mai. Ti hitorhi hi atɨp mekam. Hɨr nertei hɨm mai.” ");
INSERT INTO avt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas katɨp menmen im epei au, mɨtɨk ke polis kerp menep kɨwaai his kakɨp kesinɨwek kar ik: “Ti ap atɨp mɨtɨk pris iuwe enum mar im au emɨt.” ");
INSERT INTO avt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas ketpɨwek kar ik: “Hi atɨp enum ti atɨp mɨt in hɨram mekam, o au en, hi atɨp werek ti henmak te ti eiyep a?” ");
INSERT INTO avt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hɨr nitehi Jisas epei au, hɨr nɨpaa nesenkɨkɨwek his neriuwe waai hɨram wen mepu, mɨt neriuwetek keriuwerem ken kɨr mɨtɨk hak hɨrak pris iuwe niuk mɨrak Kaiafas. ");
INSERT INTO avt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita wen keperp si kekinɨn yɨnk kɨrak, te mɨt han netpɨwek nar ik: “Ti etike mɨt han yises hɨm me Jisas o au?” Pita kepakɨnek ketpor kar ik, “Hi au.” ");
INSERT INTO avt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mɨtɨk kiutɨp kɨrɨak menmen me mɨtɨk pris iuwe, hɨrak ke weiwɨk me mɨtɨk kerek Pita keremir nɨkɨp mɨrak, hɨrak kitɨwekhi kar ik: “Nɨpaa hi herp ni eim, hi hɨrit ti herp hetikerek yeit ein o au?” ");
INSERT INTO avt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita au kiune keteipim katɨp kar ik: “Ti hɨra au.” Hɨrak katɨp epei au, suware katɨp. ");
INSERT INTO avt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hɨr mɨt neithis Jisas nɨnaaiwɨr wɨnak ke Kaiafas, hɨr nesiuwerek ken wɨnak ke mɨtɨk iuwe gavman. Hɨrak wanewik. Mɨt iuwe ne Isrel hɨr nɨnapen nanɨno wɨnak ke gavman nentar hɨr nanɨno nanɨkre wɨnak ke mɨtɨk ap ke weiwɨk me Isrel, hɨm me Moses matɨp hɨr enun ne ninaan me God nar ke mɨtɨk hapɨk mewik. Te hɨr ap nanɨm menmen me wɨ Pasova kerek mɨt nererik han tewenɨn God kenep mɨt ne Isip. ");
INSERT INTO avt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hɨr nɨnapen nanɨno nɨmɨn, te mɨtɨk gavman Pailat ken witeik kitorhi kar ik: “Yi yesiuwe hɨm mɨtɨk ik yentar mekam a?” ");
INSERT INTO avt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hɨr netpɨwek nar ik: “Mɨtɨk ik ap kɨrɨak menmen enum au, haiu ap te meriyaak man in au.” ");
INSERT INTO avt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat ketpor kar ik: “Yi hɨras yetɨwekhis yesiuwerek kakno kaunsil ni te yi yesiuwek hɨm yises menmen mi nɨpaa maamrer netpim yi yɨrɨakem me mɨtɨk kɨrɨak enum.” Hɨr netpɨwek nar ik: “Mɨt iuwe ne Rom ap newisai haiu mamnep mɨt hɨr nani.” ");
INSERT INTO avt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Menmen im epei man te hɨram mises hɨm kerek nɨpaa Jisas katɨp kakɨrkeik te hɨrak kaki.) ");
INSERT INTO avt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat katɨp epei au, hɨrak pɨke ken nɨmɨn wɨnak. Hɨrak kenɨne mɨt nanɨt Jisas neiyɨk nanɨnen menep. Epei au, hɨrak kitɨwekhi kar ik: “Ti Mɨtɨk Iuwe King hinɨn naanmampre mɨt ne Isrel o au?” ");
INSERT INTO avt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas kitɨwekhi kar ik: “Ti hɨrekes han kitetim o ti hemtau mɨt han netputem?” ");
INSERT INTO avt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat ketpɨwek kar ik: “Ti han kitet hi mɨtɨk ke weiwɨk me Isrel a? Hi au. Mɨt ne weiwɨk me Isrel netike mɨt iuwe pris nɨr netuthis neriuwetit ti han in. Ti hɨrɨak mekam?” ");
INSERT INTO avt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas ketpɨwek, “Hi ap ehinɨn naanempre mɨt ne tɨ in ek au. Hi naanempre mɨt in, te mɨt kerek nisɨsa hɨr nankepa nantikeri nanɨnepan, te hɨr ap nantauhis. Au, hi ehu in ehinɨn naanmɨpre mɨt au.” ");
INSERT INTO avt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hɨrak katɨp epei au, Pailat kitɨwekhi kar ik: “Ti mɨtɨk iuwe ehinɨn mɨt a?” Jisas ketpɨwek, “Ti atɨp hi Mɨtɨk Iuwe. Miye pai wina hi herp tɨ te hi hɨrɨak menmen im miutɨp. Hi hatɨp mɨt hɨm yaaim. Neimɨn nises hɨm yaaim hɨr nanɨmtau hɨm mai.” ");
INSERT INTO avt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat kitɨwekhi, “Hɨm yaaim hɨram mekam?” Hɨrakɨt tatɨp epei au, Pailat pɨke ken witeik katɨp mɨt ne Isrel kar ik: “Hi ap hertei menmen enum hɨrak kɨrɨakem, te hi akɨp kaki au. ");
INSERT INTO avt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Me tito miutɨp tito miutɨp hi hises menmen nɨpaa yi yɨrɨakem. Me wɨ Pasova hi esiupan mɨtɨk enuk kiutɨp kau kekre wɨnak enuk kaknen yi mɨt. Yi hanhan hi esiupan Mɨtɨk Iuwe ke Isrel ik e o au?” ");
INSERT INTO avt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hɨr nɨnap netpɨwek nar ik: “Hɨrak au. Haiu hanhan ti esiupan Barabas.” (Mɨtɨk Barabas hɨrak mɨtɨk enuk kenep mɨt naa hɨrak kekintɨp menmen.) ");
INSERT INTO avt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hɨr mɨt en nɨnap natɨp menmen epei au, mɨtɨk Pailat keit Jisas ken nɨmɨn katɨp mɨt nɨrak ne ami hɨr nanwaai nɨpɨn nankɨp. ");
INSERT INTO avt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Hɨr nakɨp epei au, hɨr neit waai nekepen nimaak kɨre teperiye nekiun kau paan kɨrak. Epei au, hɨr neit laplap mɨre yɨwir neriuwetɨwekem nar ke mɨt iuwe ne gavman neriuwetem, te hɨr nan nitɨtɨweknaan natɨp, ");
INSERT INTO avt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","“Haiu hanhan mɨtɨk iuwe king kinɨn naanmɨpre mɨt ne Isrel kaku tipmain tipmain enum eik.” Epei au, hɨr nɨwaai his nakɨp. ");
INSERT INTO avt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Epei au, hɨrak Pailat pɨke ken witeik katɨp mɨt en kar ik: “Yi eiyɨmtau. Hi etɨwekhis eiyɨk enen witeik te yi yertei hi epɨtari menmen miutɨp hɨrak kɨrɨakem te hɨrak kaki kakɨnterim.” ");
INSERT INTO avt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hɨrak katɨp epei au, Jisas ketpaan kan witeik keriuwe waai nekepen kau paan kɨrak laplap mɨre yɨwir mau yɨnk kɨrak. Jisas kan witeik, Pailat katɨp, “Yi eiyɨrek. Hɨrak mɨtɨk ik e.” ");
INSERT INTO avt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mɨt iuwe pris netike mɨt kerek naanmɨpre wɨnak iuwe ke God nɨrek, hɨr nɨnap natɨp nar ik: “Yi eiwenkekik eku nu tentarakɨt. Yi eiwenkekik eku nu tentarakɨt.” Hɨr nɨnap natɨp, te Pailat ketpor, “Yi yaitɨwekhis eiwenkekik eku nu tentakakɨt. Hi epɨtari menmen enum hɨrak kɨrɨakem, te hɨrak kaki kakɨnterim.” ");
INSERT INTO avt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mɨt iuwe ne Isrel natɨp nar ik: “Hɨm lo mekre tɨwei haiu misesim hɨram matɨp hɨrak eki ekɨntar hɨrak katɨp hɨrak Nɨkan ke God.” ");
INSERT INTO avt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat hɨrak kemtau hɨm im, te hɨrak kɨnaain wɨsenum kentar Jisas katɨp hɨrak Nɨkan ke God. ");
INSERT INTO avt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hɨrak kari Jisas keiyɨk kan wɨnak iuwe eik kentar hɨrak han kitet Jisas hɨrak Nɨkan ke God. Te hɨrak kitɨwekhi kar ik: “Ti ekine wit kit keik.” Jisas au, kekintɨp keit. ");
INSERT INTO avt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat ketpɨwek, “Ti henmak te ti etpo au? Ti epɨtari hi iuwe te hi esiupenit o hi ewenkekit ehu nu tentarakɨt a?” ");
INSERT INTO avt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas ketpɨwek, “Ti iuwe hinɨna hentar God kewisit ti hɨrɨakem. Mɨtɨk kerek keriuweta hi han hau his mit hɨrak kɨrɨak menmen enum wɨsenum. Ti au hɨrɨak enum kike.” ");
INSERT INTO avt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat kemtau hɨm im hɨrak han kitet karkeik te hɨrak kaksiupan Jisas. Au, mɨt ne Isrel netpɨwek nar ik: “Ti esiupanek ti ap ekaap mɨtɨk iuwe Sisa keit Rom. Keimɨn katɨp hɨrak mɨtɨk iuwe kinɨn mɨt, hɨrak mɨtɨk enuk kepan ke Sisa.” ");
INSERT INTO avt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat kemtau hɨm im, hɨrak keithis Jisas keiyɨk ken witeik kau yeno ke mɨtɨk iuwe masistret keit wit niuk mɨrak “Ya nan” (Mɨt ne Isrel nekine wit ik “Gabata”) ");
INSERT INTO avt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wɨ im hɨram wɨ mɨt ne Isrel nemani menmen me wɨ Pasova kerek hɨr hantewenɨn nɨpaa God kenep mɨt ne Isip te hɨr mɨt ne Isrel au. Wepni kau nɨmɨn iuwe, te Pailat ketpor kar ik: “Yi eiyɨr mɨtɨk iuwe king ki ik e.” ");
INSERT INTO avt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hɨr pɨke nɨnap netpɨwek, “Akɨp! Akɨp! Ti ewenkekik eku nu tentarakɨt.” Pailat kitorhi, “Mekam? Yi hanhan hi ewenkek mɨtɨk iuwe king ki eku nu tentarakɨt a?” Mɨt iuwe pris pɨke netpɨwek nar ik: “Sisa kerekek hɨrak mɨtɨk iuwe kaiu. Mɨt han au.” ");
INSERT INTO avt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hɨr natɨp menmen im epei au, Pailat kewet mɨt nɨrak ek te hɨr netɨwekhis neriyaak nen newenkekik kaku nu tentarakɨt. ");
INSERT INTO avt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mɨt ne ami nɨrak hɨr netɨwekhis, hɨrak kekerɨr nu kɨrak hɨrak keiyɨk ken wit niuk mɨrak “Wit Herwe Paan” kerek mɨt ne Isrel nenewek “Wit Golgota.” ");
INSERT INTO avt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hɨr newenkekik keit ein. Hɨr newenkek mɨtɨkɨt wiketeret tentar nu tentarakɨt tetikerek. Kiutɨp kau ken his yaaim kiutɨp kau ken his henkik, Jisas kekre nɨmɨn. ");
INSERT INTO avt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat kewis hɨm mau menmen katɨp mɨt nɨrak hɨr newisɨk kentar nu tentarakɨt. Hɨm mɨrak matɨp mar im: “IK JISAS KE NASARET, MƗTƗK IUWE KE ISREL.” ");
INSERT INTO avt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mɨt yapɨrwe ne Isrel nekine menmen im nentar wit kerek Jisas mɨt newenkekik kau nu tentarakɨt hɨrak menep wit iuwe Jerusalem. Hɨm hɨr newisɨm mekre hɨm me mɨt ne Isrel, hɨm me mɨt Grik metike hɨm me mɨt ne Rom. ");
INSERT INTO avt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mɨt iuwe pris ne Isrel nen natɨp pailat nar ik: “Ti ap ewis mɨtɨk iuwe king ke Isrel au. Ti ewis mɨtɨk ik katɨp hɨrekes mɨtɨk iuwe king ke Isrel.” ");
INSERT INTO avt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat pɨke ketpor kar ik: “Menmen hi nepei ewisɨm emɨrem emu!” ");
INSERT INTO avt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mɨtɨkɨt te ami tewenkekik epei au, hɨrakɨt tekyaait teit Jisas klos mɨrak tenkerem tewetakɨtem. Hɨr neit laplap saket nokim mɨrak kerek mɨre miutɨp hɨr mewim au. ");
INSERT INTO avt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Te mɨtɨkɨt te ami tatɨp tar ik: “Haiu ap mamwepim au. Haiu emretɨt satu eiyɨk emwɨrem te haiu emɨrem emɨrtei keimɨn kaktɨwem, ti o hi.” Hɨrakɨt tɨrɨak menmen im, te hɨm me God mau tɨwei nɨpaa mɨt profet newisɨm hɨrak mamnen. Hɨm im matɨp mar ik: “Hɨr mɨt nenke klos mai newetan. Hɨr neretɨt Satu me laplap nokim mai.” Te mɨtɨkɨt te ami tɨrɨak menmen im. ");
INSERT INTO avt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas miye pɨrak werp wetikewa hi Jon kerek Jisas hanhan keriuwa. ");
INSERT INTO avt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Te hɨrak katɨp miye pɨrak, “Mɨte, nɨkan kit kerp in kereptit.” ");
INSERT INTO avt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nepei au, hɨrak katɨp hi mɨtɨk disaipel kɨrak har ik: “Ip e hɨre miye pit.” Me wɨ ik Jisas ketpim ere maain, hɨre wen wau wetikewa wau weit wɨnak kai. ");
INSERT INTO avt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas katɨp epei au, hɨrak kertei hɨrak kɨrɨak menmen yapɨrwe epei au kerek nɨpaa mɨt profet newisɨm mau tɨwei. Menmen miutɨp keremem mau tɨwei. Hɨrak hanhan hɨram mamnen mamɨr nɨpaa mɨt newisɨm, te hɨrak katɨp, “Hi hɨm niu enuk (o mar kewenkɨka hɨm) ehɨm tɨpar mei.” ");
INSERT INTO avt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mɨn kiutɨp kepu tɨpar si enum mekrerek. Mɨt en neit mosong nɨkɨam newenem mekre tɨpar nesenkekim mentar nu heneik ke nu hisop (hɨram mɨre mapɨk) hɨr neriuwetem men hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas kaam tɨpar si enum. Epei au, hɨrak katɨp kar ik: “Menmen God katɨp hi hɨrɨakem hɨram epei au.” Hɨrak katɨp epei au, hɨrak kitehɨr kaa keriuwet hɨmɨn kɨrak ken. ");
INSERT INTO avt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mɨt iuwe ne Isrel nen nitehi Pailet hɨrak kaksiuwe mɨt nɨrak nanwen hɨt nɨan ne mɨt nau nu tentarakɨt hɨr nani waswas nentar ik ek wɨ kerek mɨt nemani menmen me wɨ Sabat. Hɨr nɨnapen mɨt en wen nanu nanɨt nanɨntar nu tentarakɨt ne wɨ Sabat nentar Sabat im hɨram wɨ Pasova mekrit, hɨram wɨ yaaim holi iuwe. ");
INSERT INTO avt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hɨr nitehi Pailat epei au, hɨrak keriuwet mɨt hɨr nen newen hɨt me mɨtɨk ke his yaaim, mɨtɨk ke his henkik kerek hɨr newenkekikɨt tau nu tentarakɨt tetike Jisas. ");
INSERT INTO avt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hɨr nan nɨr Jisas hɨrak epei kaa, te hɨr ap newen hɨt mɨrak. ");
INSERT INTO avt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mɨtɨk kiutɨp ke mɨt ne ami hɨrak kewɨr yipo kɨrak kakɨp keneper hɨrepit me Jisas te tɨpar metike hemkre mewen. ");
INSERT INTO avt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Hi mɨtɨk kerek hi hɨr menmen im hi hewisɨm mau tɨwei te yi eiyɨrtei Jisas hɨrak Nɨkan ke God. Menmen hi hewisɨm hɨram yaaim. Hi ap hemipɨn au. Hi atɨp werek.) ");
INSERT INTO avt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Menmen epei man mɨre hɨm me God mau tɨwei nɨpaa mɨt profet newisɨm hɨram matɨp. Hɨm im matɨp mar im: “Mɨt ap nanwen hemik mei mɨrak miutɨp au.” ");
INSERT INTO avt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hɨm ham mau tɨwei matɨp mar im: “Mɨt nanɨr mɨtɨk kerek nɨpaa hɨrnewɨr yipo nankɨp neneper hɨrepit.” ");
INSERT INTO avt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mɨt nɨrɨak menmen im epei au, mɨtɨk Josep ke wit Arimatia kitehi Pailat hɨrak kakɨnke Jisas herwe yɨnk kɨrak keit nu tentarakɨt. Josep hɨrak kises hɨm me Jisas, te hɨrak kepakɨnem kentar hɨrak kɨnaain mɨt iuwe ne Isrel. Pailat kewenhi, te hɨrak ken keit yɨnk kɨrak keiyɨk ken. ");
INSERT INTO avt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mɨtɨk Nikodimas kerek nɨpaa ken kɨr Jisas ke wɨtaan ken ketike Josep, hɨrak keit 50 kilo me tɨpar me nu wik mɨnɨn yaaim. ");
INSERT INTO avt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hɨrakɨt teit Jisas herwe yɨnk kɨrak, hɨr nesenkekik mekre laplap yaaim metike nu tɨpar. Mar im mɨt ne Isrel nemani herwe yɨnk ke mɨt, hɨr newisɨk kekre han. ");
INSERT INTO avt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Wit kerek mɨt newenkek Jisas kau nu tentarakɨt, ni mepu menep han kewen kɨnɨk kepu kerek herwe ap mei mɨwaai mekrerek ap nɨpaa ein au. ");
INSERT INTO avt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Te hɨrakɨt tewis Jisas herwe yɨnk kɨrak kekrerek tentar wɨ im hɨram wɨ kerek mɨt nemani menmen me wɨ Sabat. Wɨ ham mepeit te hɨrakɨt tɨntatɨn wit hak tewisɨk kekrerek au. ");
INSERT INTO avt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wɨ Sande hekrit enum hɨrkiwo, Maria pe Magdala hɨre wan han kerek mɨtɨkɨt tewis Jisas kekrerek. Hɨre wan wɨrek, hɨre wɨr nan kerek nɨpaa keiyepet hɨm ke han eik, mɨt nenkerek kenpɨn kekeipɨn hei eik. ");
INSERT INTO avt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hɨre wɨrek epei au, hɨre wɨrɨr wen wɨr Saimon Pita ketike hi mɨtɨk disaipel hak kerek Jisas hanhana. Hɨre wetpawɨr war ik: “Hɨr mɨt epei neit yɨnk ke Mɨtɨk Kaiu Iuwe kekre han eik, hɨr neiyɨk nen newisɨk kɨwaai nein te hawɨr miyapɨr ap wɨnapɨnek au.” ");
INSERT INTO avt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hɨre watɨp epei au, Pita ketikewa hawɨr wɨnaiwɨri wen han eik e. ");
INSERT INTO avt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hawɨr wesiuknen te hi mɨtɨk hak eik hinɨn Pita hen hɨr han eik. ");
INSERT INTO avt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hi hitehɨr herenaan hɨr laplap mɨwaai te hi ap hen nɨmɨn en au. ");
INSERT INTO avt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita kɨkaru kan kewenayipɨr. Hɨrak ken kekre han eik kɨr laplap yaaim mɨwaai en. ");
INSERT INTO avt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Hɨrak kɨr laplap nɨpaa hɨrakɨt mɨtɨkɨt wik tewisɨm teiyɨm teweikɨn paan ke Jisas keriuwerem. Hɨram ap mɨwaai metike laplap ham au. Hɨram miutɨpen mɨwaai ham, hɨrak Jisas keweiknenim mɨwaai meit. ");
INSERT INTO avt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pita ken nɨmɨn en epei au, hi mɨtɨk disaipel hak kerek hi hinɨn han hiun han kewen kɨnɨk eik, hi hisesik hɨr menmen te hi hertei Jisas pɨke kekrit. ");
INSERT INTO avt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nɨpaa ere wɨ im em, mɨt wen nepɨtari hɨm me God mekre tɨwei hɨram matɨp mar im: “Hɨrak pɨke kakɨkrit kaku kakɨt.” ");
INSERT INTO avt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hawɨr wɨrek epei au, hawɨr pɨke wen nawɨr en. ");
INSERT INTO avt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria wan werp han werp witeik witehɨr wɨwaainaan wɨkɨtek. Hɨre wɨkɨtek, hɨre witehɨr werenaan. ");
INSERT INTO avt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Te hɨre wɨr mɨtɨkɨt ensel wik teriuwet laplap me hike tau yeno kerek nɨpaa Jisas herwe yɨnk kɨrak kɨwaairi, kiutɨp kau yeno paan, kiutɨp kau yeno me hɨt. ");
INSERT INTO avt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hɨrakɨt titɨwehi tar ik: “Mɨte, ti henmak te ti hɨkɨt?” Hɨre wetpɨwekɨt, “Mɨt epei neit herwe yɨnk ke Mɨtɨk Iuwe kai neiyɨk nen wit hak, te hi hepɨtari hɨr newisɨk keit nein.” ");
INSERT INTO avt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hɨre watɨp epei au, hɨre weweikɨn wɨr Jisas kerp menep te hɨre wepɨtari hɨrak Jisas. ");
INSERT INTO avt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisas kitɨwehi kar ik: “Mɨte ti henmak te ti hɨkɨt? Ti hɨnhatɨn keimɨn?” Hɨre han kitet hɨrak mɨtɨk kerek naanmɨpre ni, te hɨre wetpɨwek, “Mɨtɨk, ti heit yɨnk kɨrak hewisɨk kɨwaai wit hak ti etpau te hi ano etɨwek.” ");
INSERT INTO avt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas ketpɨwe, “Maria.” Hɨre weweikɨn wɨkɨamnaan wɨrek, te hɨre wenke hɨm me Isrel wetpɨwek war ik: “Rabonai.” Hɨram matɨp tisa. ");
INSERT INTO avt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisas ketpɨwe kar ik: “Ti ap etenɨna au emɨt. Hi ap han hɨr Haai kai wen au. Ti eno atɨp nai yinan mɨt disaipel har ik: ‘Hi ano ahɨrek kerek hɨrak Haai kai, Haai ki, God kai, God ki.’” ");
INSERT INTO avt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hɨrak katɨp epei au, Maria pe Magdala pɨke wen watɨp mɨt disaipel me menmen hɨre watɨp, “Hi epei hɨr Mɨtɨk Iuwe.” Te hɨre wetpor hɨm kerek hɨrak nepei ketpɨwerem. ");
INSERT INTO avt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wɨtaan me wɨ Sande, haiu mɨt disaipel haiu mererik meiyepet weipɨr, te mɨt ap nɨrai mentar haiu mɨnaain mɨt iuwe ne Isrel nantaihis naniwep. Haiu wen mepeit en, Jisas kan koknɨnai kerp nɨmɨn ketpai, “Yi han yaaik eiyu.” ");
INSERT INTO avt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hɨrak ketpai epei au, hɨrak keteiknai his mɨrak nɨpaa mɨt nekenpet nil mekre his mɨrak, keteiknai hɨrepit kerek mɨtɨk ke ami kakɨp keneper keriuwe yipo. Haiu mɨt disaipel mɨrem, haiu han yaaik iuwe mentar haiu mertei Mɨtɨk kaiu Iuwe pɨke kekrit. ");
INSERT INTO avt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas pɨke ketpai, “Yi han yaaik eiyu. Hi heriuweti yi yepno yɨrɨak menmen mai yar ke Haai kai keriuweta hi han tɨ ik e.” ");
INSERT INTO avt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hɨrak ketpai epei au, hɨrak ketenwɨwai ketpai kar ik: “Yi eiyɨt God Hɨmɨn Yaaik. ");
INSERT INTO avt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yi yesiuwe menmen enum mau mekre han ke mɨt ap han kitetim, hɨram mamno, o au en, hɨram mamu han kɨr mamu mamɨt.” ");
INSERT INTO avt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wɨ kerek Jisas kan kewepyapɨr haiu mɨt disaipel nɨrak hɨrekes, mɨtɨk kiutɨp Tomas kepu ketikewai au. Niuk mɨrak ham Didimas. ");
INSERT INTO avt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Maain, haiu mɨt disaipel haiu mɨrek haiu metpɨwek mar ik: “Haiu epei mɨr Mɨtɨk Iuwe Jisas.” Au, Tomas ketpai, “Hi ap hɨr pap mekre his o heriuwet his mai mamno mitet pap me hɨrepit mɨrak, hi ap han kitet hɨrak kepu au.” ");
INSERT INTO avt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Maain wɨ hispɨnak wikak (8) epei au, haiu mererik meit nɨmɨn hɨr neiyepet weipɨr, Tomas kau ketikewai. Haiu meiyepet weipɨr te Jisas hɨrak kan koknɨnai kerp nɨmɨn ke haiu mɨt miyapɨr ketpai kar ik: “Yi han yaaik eiyu.” ");
INSERT INTO avt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Epei au, hɨrak katɨp Tomas kar ik: “Ti ewis histuwak kit eknen in ehɨr his mai. Epei au ti eriuwet his mamnen mitet hɨrepit mai. Ti ap eweikɨn sip eweto au. Ti eisɨsa!” ");
INSERT INTO avt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ketpɨwek kar ik: “Ti Mɨtɨk Iuwe kai, ti God kai!” ");
INSERT INTO avt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisas ketpɨwek, “Ti han kitet hi pɨke hekrit hentar ti hɨra a? Neimɨn ap nɨra te hɨr han kitet hi pɨke hekrit, hɨr ninɨnit.” ");
INSERT INTO avt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas kɨrɨak menmen yapɨrwe yaaim ham kɨkaap mɨt han. Haiu mɨt disaipel epei mɨrem te hi ap hewisɨm mekre tɨwei ik. ");
INSERT INTO avt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Menmen hi hewisɨm im hi hewisɨm, te yi mɨt kerek yekine tɨwei ik, yi yertei Jisas hɨrak mɨtɨk Krais kerek God keriuwetek kan tɨ ik kɨkaap haiu mɨt ne tɨ. Hɨrak nɨkan ke God yi eiyisesik yi yayɨt hɨmɨn yaaik eiyu eitikerek eiyɨntar hɨrak Mɨtɨk Iuwe ik kerek nɨpaa God ketpaiyem. ");
INSERT INTO avt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Maain wɨ ham Jisas kewepyapɨr haiu mɨt disaipel nɨrak hɨrekes keit wan Taibirias. Hɨrak kɨrɨakem kar ik. ");
INSERT INTO avt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (kerek niuk mɨrak ham Didimas), Nataniel ke wit Kena ke provins Galili, hawɨr nɨkerek hɨrakɨt wik te mɨtɨk Sebedi, haiu metike disaipel wik hakɨt te Jisas. Haiu mererik mau meit. ");
INSERT INTO avt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Haiu mererik mau meit, Saimon ketpai kar ik: “Hi are ano hahu bot ewɨr hepin ehɨt saauk mei.” Hɨrak katɨp, te haiu metpɨwek, “Haiu mamno mamtikewit.” Haiu men mau bot men mewɨr hepin wɨtaan ere wanewik, te haiu meit saauk mei miutɨp au. ");
INSERT INTO avt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wepni kewep kan, Jisas kerp tenhaan menep tɨpar, te haiu mɨt disaipel ap mertei hɨrak Jisas au. Haiu han kitet hɨrak mɨtɨk hak. ");
INSERT INTO avt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Hɨrak ketpai kar ik: “Yi pipep, yi yeit menmen o au?” Haiu matɨp, “Ap saauk mei au.” ");
INSERT INTO avt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hɨrak katɨp kar ik: “Yi eiwɨr hepin mi emno his yaaim mekre tɨpar te yi eiyɨt saauk mei.” Hɨrak katɨp epei au, haiu mewɨr hepin mekre tɨpar, te haiu ap pɨke meriyaam meriuwe saauk yapɨrwe mɨwaai mekrerem. ");
INSERT INTO avt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hi mɨtɨk disaipel kerek Jisas hanhana hi hatɨp Pita, “Mɨtɨk Iuwe Jisas eik e.” Pita kemtewek, te hɨrak keriuwet saket iuwe mɨwapɨn yɨnk kɨrak. (Hɨrak keriuwet saket kentar hɨrak kenke klos mɨrak te kakɨt saauk.) Hɨrak keriuwetem epei au, hɨrak kehɨn kamɨn tɨpar kari wan ken kiun Jisas. ");
INSERT INTO avt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Haiu mɨt disaipel han nau bot man tenhaan mari hepin saauk mekrerem mau niu. Haiu meit yanɨmɨn au. Haiu menep tenhaan mɨre 90 mita keriyen. ");
INSERT INTO avt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Haiu man merp tenhaan, haiu mɨr si mɨwaai meit ein, saauk mekre si metike bret mei. ");
INSERT INTO avt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Haiu epei man merp ein, te Jisas ketpai, “Yi eiyɨt saauk mei mekre hepin yi epei yetɨwem eiyɨm einen.” ");
INSERT INTO avt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hɨrak katɨp, te Saimon Pita ken kerp kekre bot kari hepin keiyɨm kan tenhaan. Saauk iuwe mar 153 mɨwaai mekre hepin, te hɨram mewep saauk mɨrɨr au. ");
INSERT INTO avt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Epei au, Jisas ketpai kar ik: “Yi einen eiyɨm.” Keiyak ke haiu mɨt en ap kitɨwekhi hɨrak keimɨn kentar haiu yapɨrwe mertei hɨrak Mɨtɨk Iuwe Jisas. ");
INSERT INTO avt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Haiu merp, te Jisas kan keit bret keiyɨm kan kewetaiyem. ");
INSERT INTO avt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","In ek haiu mɨt haiu mɨr Jisas meteipim wikak me wɨ nɨpaa Jisas kaa pɨke kekrit kepu ere in. ");
INSERT INTO avt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Haiu mɨt maam menmen epei au, Jisas katɨp Saimon Pita, “Saimon ti nɨkan ke Jon, ti hinɨn mɨt in hanhana hi o au?” Pita ketpɨwek kar ik: “O Mɨtɨk Iuwe, ti hertei hi hanhan ti.” Jisas ketpɨwek, “Te ti naanmampre mɨt nanisɨsa ti har ke mɨtɨk naanmɨpre sipsip mai.” ");
INSERT INTO avt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisas kitɨwekhi keteipim, “Saimon ti nɨkan ke Jon, ti hanhana hi o au?” Pita ketpɨwek keteipim, “O Mɨtɨk Iuwe, ti hertei hi hanhan ti.” Jisas ketpɨwek, “Ti naanmamre mɨt nanisɨsa ti har ke mɨtɨk naanmɨpre sipsip mai.” ");
INSERT INTO avt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas pɨke kitɨwekhi keteipim, “Pita, nɨkan ke Jon, ti hanhan hi o au?” Pita yɨnk enuk kentar Jisas pɨke kitɨwekhiyem wikak, te hɨrak pɨke ketpɨwek kar ik: “Mɨtɨk Iuwe ti hertei menmen yapɨrwe. Ti hertei hi hanhan ti.” Jisas ketpɨwek keteipim kar ik: “Ti naanmamre mɨt nanisɨsa ti har ke mɨtɨk naanmɨpre sipsip mai. ");
INSERT INTO avt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Hi hetput werek. Nɨpaa ti pipɨak ti heit tanɨk kit ti hises han kit hen in hen ein. Maain ti he mɨtɨk, ti eriuwet his mit, mɨtɨk hak kaksenkekim kakriuwe waai keiyɨk kakɨryit ti eno wit kerek ti hɨnapen enori.” ");
INSERT INTO avt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisas katɨp menmen im kewepyapɨr karkeik te maain Pita kaki kakwenɨpi niuk me God.) Epei au, Jisas ketpɨwek kar ik. “Ti ehisɨsa.” ");
INSERT INTO avt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita keweikɨn kerenaan kɨra hi mɨtɨk disaipel kiutɨp herp sip kɨrak kerek Jisas hanhana. Hi mɨtɨk disaipel kerek nɨpaa hepu yeno hetike Jisas wɨrapɨtakɨt hi hitɨwekhi har ik: ‘Mɨtɨk Iuwe, keimɨn kewepityapɨr ti eno mɨt enun?’ ");
INSERT INTO avt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita kɨra hɨrak kitehi Jisas kar ik: “Mɨtɨk Iuwe, mekam mamnen mɨtɨk ik?” ");
INSERT INTO avt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas ketpɨwek, “Hi hanhan hɨrak kaku ere hi pɨke anen, hɨram menmen mit au. Ti ehisɨsa.” ");
INSERT INTO avt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Te hɨm epei mekrit te mɨt nises hɨm me Krais natɨp hi mɨtɨk disaipel ik ek hahi au. Te Jisas ap katɨp hi ap hahi au. Hɨrak katɨp, “Hi hanhan mɨtɨk ik kaku ere hi pɨke anen, hɨram menmen mit au.” ");
INSERT INTO avt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hi kerekek hi disaipel hi atɨp me menmen im, hi ewisɨm mau tɨwei. Yi yertei menmen hi hetpim, hɨram hɨm yaaim, hi ap emipɨn au. ");
INSERT INTO avt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas kɨrɨak menmen yapɨrwe ham. Mɨt hɨr nanwisɨm mamu tɨwei ham, hi han kitet tɨ im haiu mɨt mewim ap ketenen tɨwei yapɨrwe mar im taau. ");
INSERT INTO avt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kai yinak Tiofilas, nɨpaa hi Luk hewiswut tɨwei hak me menmen Jisas hɨrak kɨrɨakem metike hɨm hɨrak ketpim kewepyapɨr mɨt em, ");
INSERT INTO avt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ere wɨ God ketɨwekhis keiyɨk ken wit kɨrak. God ketɨwekhis wen au, Jisas hɨrak wen kepu tɨ, hɨrak katɨp mɨt nɨrak kerek nɨpaa hɨrak kehimɨteni hɨr aposel hɨr nanwep yapɨr hɨm mɨrak. Hɨrak ketpor hɨm nɨpaa God Hɨmɨn kɨrak Yaaik ketpɨwekem. ");
INSERT INTO avt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas hɨrak kaa pɨke kekrit nepei au, me wɨ 40 hɨrak keteiknor hɨrak hɨrekes kepu keriuwe menmen yapɨrwe hɨrak kɨrɨakem. Hɨrak kewepyapɨr hɨrekes ketpor menmen me God kakinɨn mɨt naanempror. ");
INSERT INTO avt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hɨrak wen kepu ketikeri, hɨrak ketpor hɨm manp te hɨr ap nanɨnaaiwɨr wit Jerusalem au. Hɨrak katɨp kar ik: “Yi eiyɨt in ere God Hɨmɨn kɨrak Yaaik kerek nɨpaa God Haai kai katɨp kakriuwetek hɨrak kaknen. Nɨpaa hi hetpiyem. ");
INSERT INTO avt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nɨpaa Jon kɨkɨr mɨt neriuwe tɨpar keremem. Te maain wɨ ham God kakweti yi mɨt Hɨmɨn kɨrak Yaaik kaknen kaku kakɨkre han ki, hɨrak kakɨkepi yi einaaiwɨr wit Jerusalem eiwepyapɨr hɨm me God.” ");
INSERT INTO avt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mɨt aposel wen nererik nepu, hɨr nitɨwekhi nar ik: “Mɨtɨk Iuwe me wɨ im te ti ehu wit Isrel ehinɨn naanmamprai haiu mɨt ne Isrel a?” ");
INSERT INTO avt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hɨrak kewenhi ketpor kar ik: “Hɨram ap menmen mi te yi eiyɨrtei wɨ te menmen im mamnen au. God Haai hɨrekes kɨmat wɨ im kises han kɨrak. Te menmen im hi hetpiyem te yi eiyɨrteiyem. ");
INSERT INTO avt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Maain God Hɨmɨn Yaaik kaknen kakwi yi yayɨt menmen mɨrak iuwe mamkepi, yi yaino wit Jerusalem eiwepyapɨr hɨm mai. Im em epei au, yi yaino provins Judia. Im em epei au, yi yaino wit iuwe Sameria metike wit yapɨrwe, yi eiwepyapɨr hɨm mai.” ");
INSERT INTO avt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hɨrak ketpor hɨm im epei au, hɨr wen nɨrek, hɨrak God keriyaak kɨnaaiwɨr tɨ ken niu, napɨ kɨwapɨnek hɨr nɨrek nepei au. ");
INSERT INTO avt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hɨr wen nereweknaan keit nepni, mɨtɨkɨt wik terp tekiteri klos mɨrakɨt hɨram mɨre hike. ");
INSERT INTO avt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hɨrakɨt tetpor tar ik: “Yi mɨt ne Galili yi yenmak yi yereweknaan keit nepni? Mɨtɨk eik Jisas hɨrekes yi yɨrek hɨrak kɨnaiwɨri ken wit ke God, maain hɨrak pɨke kaknen kakɨr ke in ek yi yɨrek hɨrak ken nepni.” ");
INSERT INTO avt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hɨrakɨt tatɨp epei au, hɨr aposel nɨnaaiwɨr mɨniu (o neiyɨp) niuk mɨrak wit Oliv, hɨr nen wit Jerusalem. Hɨrak ap yanɨmɨn au. Hɨrak menep kar ke mɨt ne Juda me wɨ Sabat hɨr neke tɨ nanɨno. Hɨrak kɨre 1 kilomita. ");
INSERT INTO avt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","14","Hɨr nɨpiun Jerusalem, hɨr nan wɨnak kerek nɨpaa hɨr newik. Hɨr nɨnɨk nen haau nɨmɨn ein mekre wɨnak kau niu. Hɨr mɨt in: Pita, Jon, Jems, Andru, Filip, Tomas, Batolomyu, Matyu, Jems hɨrak mɨtɨk hak nɨkan ke mɨtɨk Alfias, Saimon kerek kises hɨm me mɨt Selot, hɨr netike Judas nɨkan ke Jems, Maria, miye pe Jisas wetike kikrek nɨrak, hɨr netike miyapɨr han. Hɨr yapɨrwe nau haau ik e. Wɨ yapɨrwe hɨr nererik neit in, hɨr nitehi God menmen. ");
INSERT INTO avt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Maain wɨ ham mɨt 120 hɨr nises hɨm me Krais, hɨr nererik nau haau iuwe, Pita kekrit ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nai yinan, nɨpaa God Hɨmɨn Yaaik kenip mɨtɨk iuwe King Devit hɨrak kewis hɨm mau tɨwei me mɨtɨk Judas kerek nɨpaa kewepyapɨr Jisas kerp nein te hɨr mɨt enun netɨwekhis. Hɨm im nepei man mar ke nɨpaa Devit kewisɨm hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nɨpaa Judas hɨrak ketikewai. Jisas kehimɨtanek kɨrɨak menmen ketikewai. ");
INSERT INTO avt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Mɨtɨk ik keit tɨ mei keriuwe pewek hɨrak nɨpaa ketɨwem me menmen enum hɨrak kɨrɨak Jisas em. Hɨrak keit tɨ, hɨrak kerp kau niu kenkewɨn ken tɨ tu kewep nɨnpɨ meket men witeik hɨrak kaa.” ");
INSERT INTO avt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mɨt yapɨrwe neit Jerusalem nemtau Judas kaa karkeik te hɨr nekine tɨ ik mekre hɨm mɨr hɨr natɨp Akeldama. Hɨm im hɨram matɨp mar im: “Hemkre mekiuwe tɨ.”) ");
INSERT INTO avt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Hɨm mau tɨwei nɨpaa Devit kewisɨm hɨram Sam. Hɨm im matɨp mar im, ‘Wɨnak kɨrak kaku weinɨk, mɨtɨk hak ap kakwik ekɨt. Mɨtɨk hak kakɨkrehɨr kɨrak kakrɨak menmen nɨpaa hɨrak kɨrɨakem.’ ");
INSERT INTO avt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Sɨs, haiu mamɨhimɨtan mɨtɨk hak kaktikewai mamwepyapɨr Mɨtɨk Iuwe Jisas hɨrak pɨke kekrit. Haiu mamɨhimɨtan mɨtɨk kerek kekitewai men ein nɨpaa Mɨtɨk Iuwe Jisas kekitewai haiu men me wɨ Jon kewepyapɨr hɨm me God hɨrak kɨkɨr mɨt ere God keithis Jisas keiyɨk ken wit kɨrak.” ");
INSERT INTO avt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita katɨp epei au, hɨr nehimɨtan mɨtɨkɨt wik. Josep kerek mɨt hɨr nekinaak Banabas o Jastas, hɨrak kekite Mataias. Hɨrakɨt wik keretet. ");
INSERT INTO avt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hɨr nehimɨtan wik et, hɨr nitehi Mɨtɨk Iuwe God nar ik: “Mɨtɨk Iuwe ti epei hertei han ke mɨt yapɨrwe te ti eteiknai keimɨn ke mɨtɨkɨt wik it ti ehimɨtanek ");
INSERT INTO avt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hɨrak kakɨkrehɨr ke Judas. Judas hɨrak keweikɨn sip kewet menmen im me God hɨrak kaa epei ken wit kerek nɨpaa ti God ehimɨtanek hɨrak kaknori. Hɨrak kakɨkrehɨr kɨrak te hɨrak kakrɨak menmen kakɨr ke haiu mɨt aposel.” ");
INSERT INTO avt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hɨr nitehi Mɨtɨk Iuwe God menmen nepei au, hɨr nen vot keimɨn kakɨkrehɨr ke Judas. Hɨr nen vot nepei au, hɨr nehimɨtan Mataias hɨrak kakɨkrehɨr ke Judas, hɨrak kaku kaktike mɨt aposel nar ke hiswiyen kiutɨp (11). ");
INSERT INTO avt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mewaai meruri wɨ Pentikos epei man, kerek mɨt nererik newet God menmen ham me ni mɨr, mɨt kerek nises hɨm me Krais hɨr nererik nau wɨnak kiutɨp. ");
INSERT INTO avt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hɨr nererik nau wɨnak, wasenum menmen mesikeyaanmi meke nepni man mɨre yuwerep mɨniu ma mekre wɨnak, hɨram mesikeyaanmi (o mesikewari) wɨsenum meit wɨnak mɨt newik. ");
INSERT INTO avt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hɨram mesikeyaanmi wɨsenum meit wɨnak eik, hɨr mɨt en nɨr menmen mɨre si mekinen nin kike kike mau merer mɨt hɨras yapɨrwe nau wɨnak. ");
INSERT INTO avt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hɨr yapɨrwe God Hɨmɨn Yaaik kewi kinɨni naanmɨpror, hɨr natɨp hɨm ham hɨm ham hɨr netariyem, kerek God Hɨmɨn Yaaik kenipi niutɨp niutɨp hɨr netpim. ");
INSERT INTO avt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Me wɨ im mɨt ne weiwɨk miutɨp ne Isrel hɨr nises hɨm me God nitɨwekhi menmen, hɨr nau nerer wit wit, hɨr nan nau wit Jerusalem nanises menmen me wɨ Pentikos. ");
INSERT INTO avt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mɨt yapɨrwe in hɨr nemtau menmen mesikeyaanmi (o mesikewari) meit wɨnak ke aposel newik, te hɨr nesiuknen nan nererik, hɨr han kɨr kekrit kekrit kentar hɨr nemtau mɨt nises hɨm me Krais natɨp hɨm mɨr. ");
INSERT INTO avt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hɨr nehɨnhɨn nemtau menmen im te hɨr natɨpan nar ik: “Mɨt in hɨr natɨp hɨm maiu te hɨr ne Galili keriyen, ");
INSERT INTO avt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","te haiu markeik haiu niutɨp niutɨp memtau hɨm maiu me nɨpaa ein miye haai naiu netpim neit wit kaiu eik? ");
INSERT INTO avt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Haiu mɨt yapɨrwe merer provins mar im em. Haiu ne wit Patia, Midia, Ilam, Mesopotemia, Judia, Kapadosia, Pontas, Esia, ");
INSERT INTO avt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frisia, Pamfilia, wit iuwe Isip, wit me Libia menep Sairini. Haiu mɨt han ne wit iuwe Rom haiu mau in, ");
INSERT INTO avt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","haiu mɨt han ne weiwɨk miutɨp me Isrel, haiu mɨt han au weiwɨk miutɨp ham. Haiu mɨt han ne wit Krit o Arebia, te haiu mɨt yapɨrwe memtau menmen iuwe God kɨrɨakem kerek mɨt in hɨr netpaiyem neriuwe hɨm maiu.” ");
INSERT INTO avt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Han kɨr katɨp te hɨr nitehiyan natip nar ik: “Mekam im hɨram epei man?” ");
INSERT INTO avt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Au, mɨt han hɨr nitetnaan natip, “Mɨt in naam tɨpar si enum wain keremem, te hɨr netaritari.” ");
INSERT INTO avt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Te Pita kekrit ketike mɨt aposel hiswiyen kiutɨp (11) hɨrak katɨp hɨm iuwe katɨp kar ik: “Yi mɨt ne Judia yetike mɨt yi yau wit Jerusalem, yi nɨkɨp emnep eiyɨmtau menmen im hi etpiyem me menmen im epei man. ");
INSERT INTO avt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yi han kitet mɨt in hɨr naam tɨpar si enum hɨr netaritari. Hɨr au, hɨrak weni hekrit wepni kewep kan kerekek. Wɨtaan te mɨt hɨr naam tɨpar si enum netaritari. ");
INSERT INTO avt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Menmen im yi yemtewem hɨram menmen nɨpaa profet Joel hɨrak ketpim kar ik: ");
INSERT INTO avt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Hi God me wɨ kerek Mɨtɨk Iuwe Krais epei kaknen kaku tɨ, hi hɨrekes ariuwet Hɨmɨn kai Yaaik kaknen mɨt yapɨrwe. Nɨkerek hɨrakɨt tetike nɨkerek hɨram (o hɨran) ni hɨr nanwepyapɨr hɨm mai, yi mɨt pipep yi wen yepu yɨtyaak, yi enun ye mɨt yi eiwaai eiyɨtyak eiyɨr menmen mai. ");
INSERT INTO avt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Me wɨ ham im mɨt han nai o miyapɨr han nai hɨr nɨrɨak menmen mai hi eriuwet Hɨmɨn kai Yaaik kaknen te hɨr nanwepyapɨr hɨm mai. ");
INSERT INTO avt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Me wɨ eim, hi arɨak menmen nɨpaa yi yɨrem mau nepni o mau tɨ mar im au. Hi arɨak si metike si tɨwekre hemkre hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wepni kakɨr au, wenke hɨrak kakweikɨnhis kakre yɨwir menep wɨ yaaim Mɨtɨk Iuwe Krais pɨke kaknen tɨ ik. ");
INSERT INTO avt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Te mɨt miyapɨr niutɨp niutɨp kerek nenɨne Mɨtɨk Iuwe nanitehi Krais kakɨkepi, hɨrak kakɨkepi kaktorhis.’ Profet Joel katip hɨm im. ");
INSERT INTO avt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Yi mɨt ne Isrel yi eiyɨmtau hɨm im me Jisas ke Nasaret. Yi yertei Jisas kɨrɨak menmen yaaim yapɨrwe, hɨrak kɨkaap mɨt his hɨt enum keriuwe menmen iuwe God kewetɨwekem. God keteikni hɨrak keriuwet Jisas kan keriuwe menmen hɨrak kewis Jisas kɨrɨakem, yi mɨt epei yɨrem. ");
INSERT INTO avt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nɨpaa God kertei mekam mamnen te hɨrak han kitet te kaksiuwe Jisas kakno his me yi mɨt. Yi yeriyaak yeiyɨk yen yewis mɨt enun newenkekik kau nu tentarakɨt hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hɨrak kaa, te God kɨkɨak hɨrak kepu kesiupanek kɨnaaiwɨr wit mɨt epei naa hɨmɨn kɨr kewi. Hɨrak God kinɨn menmen menip mɨt nani hɨr han enuk nentar Jisas kaki kaku kakɨt taau. Au, God nɨpaa katɨp kakɨkɨak Jisas kekre hei yɨnk kɨrak ap te kakɨsine au. ");
INSERT INTO avt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hɨm me God nɨpaa Devit kewisɨm mau tɨwei matɨp menmen im: ‘Hekrit hekrit hi hɨpɨr Mɨtɨk Iuwe menep. Hɨrak kau ketikewa te hi ap han kɨrɨra keriuwe menmen au. ");
INSERT INTO avt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hi han yaaik hentar menmen im. Menmen hi hetpim meteikɨn mɨt hi han yaaik. Hi hɨre mɨtɨk kerekek te hi han tokik ehu ehɨntar ");
INSERT INTO avt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ti God ap ewis hɨmɨn kai kaku wit ke mɨt naa hɨmɨn kɨr kewi au. Ti ap ewisa hi Mɨtɨk kerek nɨpaa ti ehimɨtena hi hɨrɨak menmen mit, ti ap ewisa hi hahi awaai akre herwe hei te yɨnk kai kaknɨn taau. ");
INSERT INTO avt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ti epei heteikno menmen hi tewen arɨakem te hi ehu ehɨt. Ti ehu etikewa te hi han yaaik wɨsenuk.’ Devit epei katɨp hɨm im: ");
INSERT INTO avt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nai yinan hi hetpi menmen te yi eiyɨrteiyem me maam nɨpu kaiu Devit. Hɨrak kaa mɨt newisɨk kekre hei kɨwaai keit. Haiu mertei hei kɨrak wen kɨwaai ketike haiu mɨt, te hɨm nɨpaa Devit kewisɨm hɨrak katɨp ke hɨrekes au, mɨtɨk hak. ");
INSERT INTO avt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nɨpaa Devit wen kepu, hɨrak kɨre profet hɨrak kertei menmen maain God kakrɨakem kentar God ketpɨwekem. God katip hɨrak kaknip nepenyek kɨrak hak hɨrak mɨtɨk iuwe king kɨre Devit, hɨrak kakinɨn haiu mɨt naanmamprai. ");
INSERT INTO avt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit hɨrak kertei menmen God kakrɨakem te hɨrak kewis hɨm mau tɨwei me Mɨtɨk God kehimɨtanek hɨrak Krais maain hɨrak kaki pɨke kakɨkrit. Hɨrak kewis hɨm hɨram matɨp: ‘Hɨrak God ap kɨnaiwɨrek keit wit ke mɨt hɨr naa hɨmɨn kɨr kewi, hɨrak yɨnk kɨrak kakɨsine au.’ ");
INSERT INTO avt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","God epei kɨkɨak Mɨtɨk ik Jisas pɨke kekrit kepu. Haiu mɨt in epei mɨrek. ");
INSERT INTO avt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God kɨkɨak Jisas pɨke kekrit kau, hɨrak kau ketike God kinɨn naanmɨpre menmen yapɨrwe. God kewetɨwek Hɨmɨn Yaaik kar ke nɨpaa hɨrak ketpim, te in ek menmen yi yɨrem yemtewem hɨram God Hɨmɨn Yaaik hɨrak keriuwetek kan haiu mɨt, hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Devit hɨrekes ap ken wit ke God au, mɨtɨk hak. Devit kewis hɨm mau tɨwei hɨram matɨp: ‘Mɨtɨk Iuwe God katɨp Mɨtɨk Iuwe kai Krais “Ti ehu menep etikewa ehinɨn naanmɨpre menmen ere hi enip mɨt enun nepan nanises hɨm mit.” ’ ");
INSERT INTO avt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pita wen katɨp kar ik: “Yi mɨt ne Isrel, yi eiyɨrtei menmen im werek werek. Mɨtɨk ik Jisas kerek yi yewenkekik kau nu tentarakɨt, God hɨrak kenipek hɨrak Mɨtɨk Iuwe hɨrak kehimɨtenek hɨrak Krais.” ");
INSERT INTO avt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mɨt epei nemtau menmen Pita ketpim, hɨm merekir han kɨr han enuk natɨp Pita kekite mɨt aposel han netpor nar ik: “Naiu yinan, te in ek haiu emrɨak mekam?” ");
INSERT INTO avt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita kewenhi katɨp kar ik: “Yi yapɨrwe niutɨp niutɨp eiweikɨn sip eiwet menmen enum haiu mamɨkri yayɨkre tɨpar mamkine niuk me Jisas Krais te hɨrak kakɨsak menmen enum yi yɨrɨakem te hɨrak kakweti God Hɨmɨn Yaaik. ");
INSERT INTO avt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nɨpaa God katɨp kaksiuwe God Hɨmɨn Yaaik kaknen yi mɨt yaitike nɨkerek ni, mɨt yapɨrwe hɨr nau neit nerer wit wit kerek God kaknɨnor hɨr nanisesik.” ");
INSERT INTO avt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ketpor hɨm ham yapɨrwe kari han kɨr keriuwerem, hɨrak katɨp kar ik: “Yi eikaap hɨras einepɨn eikeipɨn menmen enum mamnen mamnep mɨt enun in nɨpaa nenep Jisas.” ");
INSERT INTO avt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mɨt yapɨrwe hɨr nemtau hɨm Pita ketporem te hɨr newisi nɨkɨri. Me wɨ im e God kari 3,000 mɨt hɨr netike mɨt aposel hɨr nises hɨm me Krais. ");
INSERT INTO avt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mɨt in han kɨr kekrit hɨr hanhan nemtau hɨm me mɨt aposel, hɨr netike mɨt nau han kiutɨp nɨkaapan, hɨr nekiyan naam menmen han tewenɨn menmen Jisas kɨrɨakem, hɨr nekiyan nitehi God me menmen. ");
INSERT INTO avt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mɨt aposel hɨr nɨrɨak menmen yaaim yapɨrwe nɨkaap mɨt nɨnap hɨr nɨre yaain te mɨt yapɨrwe hɨr han kekrit neriuwe menmen. ");
INSERT INTO avt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mɨt kerek hɨr nises hɨm me Krais hɨr nekiyan nau neit, hɨr han kitet menmen yapɨrwe hɨr netenenim, hɨram me mɨt, hɨras au. ");
INSERT INTO avt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Hɨr nesiuwe tɨ mɨr o menmen mɨr nanɨt nan mererim. Hɨr neit pewek im hɨr nenkerem newet mɨt neimɨn netenen pewek au, hɨr neiyɨm nen nanɨt menmen. ");
INSERT INTO avt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hekrit hekrit hɨr nen nekiyan nau niutɨp neit wɨnak iuwe ke God keit Jerusalem, hɨr nekiyan nau naam menmen nerer wɨnak mɨr han tewenɨn menmen Jisas kɨrɨakem. Hɨr han yaaik naam menmen mɨr. ");
INSERT INTO avt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hɨr newenɨpi niuk me God, hɨr mɨt han yaaik neriuweri. Hekrit hekrit Mɨtɨk Iuwe God kari han ke mɨt hɨr nisesik, te hɨr nererik nekiyan nau neit neriuwe mɨt kerek hɨr ninɨn nises God. ");
INSERT INTO avt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wɨ ham hɨnkewɨ Pita ketike Jon tariyakɨt ten wɨnak iuwe ke God. Hɨnkewɨ in ek mɨt nererik nitehi God menmen. ");
INSERT INTO avt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mɨtɨk hak kerek hɨt enum nɨpaa miye winaak ere in, hekrit hekrit mɨt nɨnanek newisɨk kau menep ya weipɨr niuk mɨrak “Yaaim” hɨram ya weipɨr ham me wɨnak iuwe ke God, hɨrak kau en kitehi mɨt miyapɨr kerek nanɨno nɨmɨn hɨrak ketpor hɨr nanwetɨwek pewek mei me menmen. ");
INSERT INTO avt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hɨrak kɨr Pita ketike Jon epei tatno wɨnak nɨmɨn ein, hɨrak kitɨwekɨthi ke pewek mei ke menmen. ");
INSERT INTO avt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hɨrakɨt tɨrapɨrɨwek, Pita ketpɨwek kar ik: “Ti erawɨr.” ");
INSERT INTO avt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hɨrak mɨtɨk kɨkɨamnaan kɨret hɨrak han kitet kar ik: “Hɨrakɨt tatweto menmen.” ");
INSERT INTO avt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita ketpɨwek kar ik: “Hi hetenen pewek mei au, te menmen hi hetenɨnem hi ewetutem. Hi hetput ekrehɨr ke Jisas Krais nɨpaa ke wit Nasaret, ti ekrit eke tɨ eno.” ");
INSERT INTO avt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hɨrak katɨp epei au, hɨrak ketenen his yaaim mɨrak keriyaak kekrit kerp. Wasenum hɨt metike hɨtpar mɨrak mɨre yaaim. ");
INSERT INTO avt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hɨrak kehɨn kekrit kerp hɨrak keke tɨ ketikeret ten wɨnak ke God. Hɨrak keke tɨ, kehɨn kɨniu ketɨkɨr kewenɨpi niuk me God. ");
INSERT INTO avt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mɨt yapɨrwe en nɨrek keke tɨ kewenɨpi niuk me God. ");
INSERT INTO avt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hɨr nertei hɨrak mɨtɨk hɨt enum kerek nɨpaa kau ya weipɨr niuk mɨrak “Yaaim” ke wɨnak iuwe ke God, hɨrak hekrit hekrit kitehi mɨt me menmen. Hɨr nerteiyek te hɨr nehɨnhɨn han kitetim nar ik: “Mekam epei man mekepik te hɨrak kɨre yaaik?” ");
INSERT INTO avt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mɨtɨk ik nɨpaa hɨt enum kewen Pita ketike Jon, mɨt yapɨrwe nitehiyan menmen im nehɨnhɨn nepɨrpɨr nesiukɨn nen wɨnak hɨnp niuk mɨrak “Hɨnp ke Solomon.” ");
INSERT INTO avt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita kɨr menmen ik hɨrak kewenhi mɨt ketpor kar ik: “Yi mɨt ne Isrel. Yenmak yi yehɨhɨn yentar menmen im? Yi yenmak te yi yɨrapɨrawɨr han kitet hawɨr yaaikɨt wɨrɨak menmen im meriuwe menmen iuwe mawɨr te mɨtɨk ik nɨpaa hɨt enum hɨrak kɨre yaaik? ");
INSERT INTO avt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Hɨrak God ke maam nɨpu kaiu Ebraham, Aisak, Jekop, hɨr netike maamrer naiu nɨpaa hɨr nɨkaru nepu, hɨrak kenip Mɨtɨk Jisas kerek kɨrɨak menmen mɨrak, kenipek hɨrak Mɨtɨk Iuwe. Yi epei yeriuwetek ken mɨtɨk iuwe gavman Pailat, hɨrak kinɨn naanmɨprai haiu mɨt mau wit Isrel, hɨrak hanhan kare kaksiupan Jisas te yi yeweikɨn sip yewetɨwek yatɨp Jisas hɨrak mɨtɨk enuk. ");
INSERT INTO avt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yi epei yeweikɨn sip yewet Mɨtɨk Yaaik kerek God kehimɨntanek hɨrak kises hɨm mɨrak. Yi au hanhan mɨtɨk iuwe Pailat kaksiupan mɨtɨk enuk nɨpaa kenep mɨtɨk kaa, hɨrak ken yi mɨt, ");
INSERT INTO avt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","te yi yenep mɨtɨk hɨrak keteikɨn mɨt menmen mamkepi te hɨr nanu nantike God. Au, yi yakɨp kaa te God kɨkɨak Jisas pɨke kekrit kepu. Hawɨr epei wɨrek. ");
INSERT INTO avt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hawɨr wises hɨm me Jisas te menmen iuwe me Jisas kenip mɨtɨk ik, kerek yi yerteiyek, hɨrak yaaik. Jisas hɨrak kenip mɨtɨk ik yaaik kentar hɨrak kekepai haiu misesik te menmen iuwe mɨrak man mɨkaap mɨtɨk ik te yi epei yɨpɨrek, hɨt mɨrak tokim meit. ");
INSERT INTO avt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“In ek nawɨr yinan, hi hertei yi yetike mɨt iuwe ninɨni naanmɨpri yɨrɨak menmen im enum yenep Jisas yentar yi yetari hɨrak keimɨn. Yi han kitet hɨrak mɨtɨk kerekek. ");
INSERT INTO avt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","God nɨpaa enum eik kenip mɨt profet hɨr newis hɨm mau tɨwei, hɨr newepyapɨr Mɨtɨk God kehimɨtanek hɨr mɨt han mɨt nanɨwaankek. God kɨrɨak menmen im epei man meriuwe menmen enum yi nepei yɨrɨak Jisas em. ");
INSERT INTO avt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Yi eiweikɨn sip eiwet menmen enum, yi eiyises God hɨrak kakɨsak menmen enum yi yɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Te Mɨtɨk Iuwe kakweti menmen kaknip han ki kaku werek werek, hɨrak kakriuwet Mɨtɨk hɨrak kehimɨtanek hɨrak kaku kaktikewi. Mɨtɨk ik hɨrak Jisas. ");
INSERT INTO avt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hɨrak eku ekɨt wit ke God ere wɨ mamnen God kaknip menmen pɨke mamre yaaim. Nɨpaa God katɨp mɨt profet me menmen im te hɨr newisɨm mau tɨwei newepyapɨrem. ");
INSERT INTO avt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Nɨpaa Moses hɨrak katɨp kar ik: ‘God hɨrak Mɨtɨk Iuwe kakɨt mɨtɨk kiutɨp ke weiwɨk mi, hɨrak kakwisɨk kakre mɨtɨk profet kaksiuwerek kakwepyapɨr menmen me God kakɨr ke hɨrak keriuweta hi han. Yi nɨkɨp emnep eiyɨmtau hɨm hɨrak ketpiyem. ");
INSERT INTO avt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mɨt kerek nemtau hɨm mɨrak nisesim au, hɨrak God kakpɨri ne weiwɨk me Isrel kaknɨp nani.’ ");
INSERT INTO avt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nɨpaa mɨt profet yapɨrwe hɨr newepyapɨr hɨm me God. Samyuel kekite profet hɨr nɨkaru nekrehɨr ke Moses, hɨr natɨp me wɨ im e. ");
INSERT INTO avt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hɨm God ketpim kewet mɨt profet em, hɨr newepyapɨrem hɨram me yi mɨt in. Yi eiyɨt menmen nɨpaa God katɨp kakwet maamrer ni em. Nɨpaa hɨrak katɨp Ebraham kar ik: ‘Hi erɨak yaaim me mɨt yapɨrwe nau tɨ heriuwe nepenyek kit.’ ");
INSERT INTO avt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Te God kehimɨtan mɨtɨk kɨrɨak menmen mɨrak hɨrak kinɨn ken yi mɨt ne weiwɨk me Isrel kerekyi yaaim kenip yi mɨt niutɨp niutɨp yeweikɨn sip yewet menmen enum.” ");
INSERT INTO avt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita kekite Jon wen terp en hɨrak Pita wen katɨp mɨt menmen, te mɨt pris kerek newet God menmen me mɨt, hɨr netike mɨtɨk iuwe kepten ke polis kerek naanmɨpre wɨnak ke God, hɨr netike mɨt ne Sadyusi kerek han kitet mɨt naa hɨr pɨke nankrit nanu au, hɨr nan nanɨthis Pita ketike Jon. ");
INSERT INTO avt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Hɨr nine han enuk neriuweret nentar hɨrakɨt tewepyapɨr hɨm tatɨp mɨt em, hɨrakɨt tatɨp Jisas kaa hɨrak pɨke kekrit kepu te mɨt hɨr nisesik hɨr nani, maain hɨr pɨke nankrit nanu. ");
INSERT INTO avt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hɨr netɨwekɨthis ne hɨnkewɨ newisɨkɨt tekre wɨnak enuk teit in ere wanewik. ");
INSERT INTO avt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Te mɨt yapɨrwe nemtau hɨm me God Pita ketpim, hɨr nisesim. In ek, mɨt neit Jerusalem hɨr nises hɨm me God, hɨr nar ke 5,000. ");
INSERT INTO avt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wanewik, mɨt iuwe pris netike mɨt iuwe ne kaunsil netike mɨt ninɨn nertei hɨm lo me Moses, hɨr nererik neit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hɨr netike Anas, kerek kinɨn naanmɨpre mɨt pris, hɨrak ketike Kaiafas, Jon, Aleksanda tekite mɨt yapɨrwe ne weiwɨk me mɨtɨk iuwe Anas, hɨr nan nererik nau wɨnak iuwe eik. ");
INSERT INTO avt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hɨr nari Pita ketike Jon neiyɨt nan newisɨkɨt terp nɨmɨn, hɨr nitɨwekɨthi nar ik: “Keimɨn kekepi te yi epei yenip mɨtɨk hɨt enum hɨrak kɨre yaaik? Yi yekine niuk me keimɨn te yi yekepik?” ");
INSERT INTO avt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","God Hɨmɨn Yaaik kan kau kekre han ke Pita te hɨrak ketpor kar ik: “Yi mɨt iuwe yinɨn naanmɨpre haiu mɨt ne Isrel yetike yi mɨt iuwe ne Kaunsil, ");
INSERT INTO avt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yi yare yitawɨrhi me menmen yaaim hawɨr wenip mɨtɨk ik hɨt mɨrak enum. Yi hanhan yaiyɨrtei markeik te hawɨr wenipmɨtɨk ik kɨre yaaik. ");
INSERT INTO avt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Hi hatɨp te yi mɨt in yetike mɨt yapɨrwe ne wit kaiu Isrel yi eiyɨrtei te mɨtɨk ik kerp ninaan mi hɨrak kɨre yaaik keriuwe menmen iuwe me Jisas Krais nɨpaa ke wit Nasaret kerek yi yewenkekik kau nu tentarakɨt hɨrak kaa, te God kɨkɨak pɨke kekrit kepu. ");
INSERT INTO avt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hɨm me God mau tɨwei matɨp tok piksa me Jisas mar im. ‘Hɨrak kɨre teinɨk yaaik, te yi mɨt yime wɨnak yi yɨneinɨk yi han kitet hɨrak enuk yi yepɨrek. Yi yepɨrek te God hanhanek kenipek hɨrak kɨre teinɨk mɨtɨk hɨrak ketenen wɨnak siup.’ ");
INSERT INTO avt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hɨrak kerekek kakɨkaap mɨt ne tɨ. Neiyan taau. Haiu mɨt ne tɨ merer wit wit God ap kewetai niuk ham te haiu emisesik te hɨrak kaktaihis taau. Jisas Krais kerekek.” ");
INSERT INTO avt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hɨr epei nemtau Pita ketike Jon hɨrakɨt tatɨp hɨm iuwe hɨrakɨt tɨnaain au, hɨr nertei hɨrakɨt ten skul au, hɨr han kekrit kekrit me menmen im. Hɨr nertei nɨpaa hɨrakɨt tau tekite Jisas. ");
INSERT INTO avt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hɨr hanhan netpɨwekɨt menmen enum neneret te hɨr nɨr mɨtɨk kerp ketikeret hɨrak kɨre yaaik te hɨr nekintɨp nerp neit. ");
INSERT INTO avt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hɨr nekintɨp nerp neit o, hɨr netpɨwekɨt tatno witeik tɨnaaiwɨr haau hɨr newim. Hɨrakɨt tatno. Nepei au, hɨr mɨt ne kaunsil hɨr natɨpan natɨp nar ik: ");
INSERT INTO avt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Haiu mamrɨak mɨtɨkɨt it mekam? Mɨt yapɨrwe nau wit Jerusalem epei nertei mɨtɨkɨt wik hɨrakɨt tɨrɨak menmen ik yaaik te haiu ap mepakɨnet taau. ");
INSERT INTO avt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Haiu emɨtpɨwekɨt emneret hɨrakɨt ap tatwepyapɨr hɨm me Jisas tatɨp mɨt em te menmen im me Jisas mamno mɨt han au emɨt!” ");
INSERT INTO avt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hɨr natɨpan epei au, hɨr nenɨnɨwekɨt neriyaakɨt tan, hɨr netpɨwekɨt hɨm manp te hɨrakɨt ap tatwepyapɨr tatɨp mɨt hɨm me Jisas. ");
INSERT INTO avt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Au, Pita ketike Jon tewenhi tetpor tar ik: “Yi han ekitet God hɨrak han kitet mekam yaaim hawɨr ewisesim. Hɨm mi o hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Te hawɨr ewepyapɨr menmen hawɨr wɨrem, menmen hawɨr wemtau hɨrak ketpim. Hawɨr wekintɨp au.” ");
INSERT INTO avt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mɨt ne kaunsil wen netpɨwekɨt hɨm manp neneret. Nepei au, hɨr neriuwetet ten wit eik. Hɨr ap nɨnapɨn menmen enum te hɨr naksɨp nentar mɨt yapɨrwe newenɨpi niuk me God me menmen hɨrakɨt tɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mɨtɨk kerek hɨrakɨt tekepik hɨrak kɨre yaaik, hɨrak kinɨn 40 tito kau tɨ. ");
INSERT INTO avt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hɨr neriuwetet ten epei au, Pita ketike Jon pɨke ten nɨrakɨt yinan tetpor menmen mɨt iuwe pris netike mɨt iuwe ne kaunsil netpim. ");
INSERT INTO avt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hɨr nemtewek epei au, mɨt hɨr nitehi God natɨp nar ik: “Mɨtɨk iuwe God ti epei hewis nepni mekite tɨ, wan eik, menmen yapɨrwe mewim. ");
INSERT INTO avt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nɨpaa Hɨmɨn kit Yaaik hɨrak kenip maam kaiu Devit kewis hɨm mau tɨwei hɨram matɨp mar im: ‘Nenmak mɨt ap ne weiwɨk me Isrel hɨr han enuk wɨsenuk? Nenmak hɨr nimenɨpɨn natɨp weinɨm me nanɨnep Mɨtɨk Iuwe God. ");
INSERT INTO avt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mɨtɨk Iuwe kinɨn naanmɨpre mɨt nerer wit wit hɨr neit yipo henmik nopen menmen mɨr hɨr nan nererik nanɨnep Mɨtɨk Iuwe God ketike Mɨtɨk hɨrak kehimɨtanek hɨrak Krais.’ ");
INSERT INTO avt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Menmen epei man. Mɨtɨk iuwe gavman King Herot ketike mɨtɨk iuwe gavman Pailat hɨrakɨt tetike mɨt ne weiwɨk me Isrel mɨt han au, ne weiwɨk ham, hɨr yapɨrwe nimoryipɨr neit wit Jerusalem nenep mɨtɨk yaaik kɨrɨak menmen mit kerek nɨpaa ti ehimɨtanek hɨrak Krais. ");
INSERT INTO avt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hɨr nererik nɨrɨak menmen mar ke nɨpaa ti hanhan heriuwe menmen mit iuwe enipem hɨram mamnen. ");
INSERT INTO avt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Te in ek Mɨtɨk Iuwe God ti emtau menmen enum hɨr netpaiyem me hɨr nanwep. Ti ekepai haiu ap mɨnaain te haiu mamtɨp mɨt miyapɨr hɨm yaaim me Jisas. ");
INSERT INTO avt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ti eteikɨn mɨt iuwe enun ti enip mɨt hɨr nɨnap o his hɨt enum ti enipi hɨr enɨre yaain, ti ekepai haiu emnip menmen yaaim emɨkrehɨr ke mɨtɨk Jisas hɨrak kɨrɨak menmen mit.” ");
INSERT INTO avt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hɨr nitehi God menmen epei au, haau ke wɨnak hɨr nererik nau neit nɨmɨn ein, hɨrak kɨtanɨk, God Hɨmɨn Yaaik kan kau kekre han kɨr kekepi te hɨr newepyapɨr hɨm yaaim me God hɨr ap nɨnaain au. ");
INSERT INTO avt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mɨt yapɨrwe hɨr nises hɨm me God nekiyan nau han kiutɨp. Mɨtɨk kiutɨp kari pewek menmen au. Hɨr mɨt yapɨrwe han kitet nare menmen me mɨt niutɨp niutɨp hɨram menmen me haiu mɨt yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","God kɨkaap mɨt aposel keriuwe menmen mɨrak iuwe te hɨr natɨp werek werek newepyapɨr hɨm me Jisas hɨrak kaa God kɨkɨak pɨke kekrit kepu. Mɨt yapɨrwe han kitet hɨr yaain iuwe. ");
INSERT INTO avt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mɨtɨk kiutɨp ke mɨt in yapɨrwe hɨrak ap mɨtɨk ketenen menmen auri me menmen yapɨrwe au. Neimɨn hɨr netenen tɨ o wɨnak hɨr nesiuwerem nanɨt pewek mererim te hɨr neit pewek neiyɨm nan ");
INSERT INTO avt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","newet mɨt aposel em te hɨr nenkerem newet mɨt miyapɨr netenen menmen au hɨr newetɨr em te hɨr nau werek werek. ");
INSERT INTO avt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Me wɨ im, mɨtɨk kiutɨp niuk mɨrak Josep hɨrak ke weiwɨk me Livai, hɨrak nɨpaa miye pɨrak winaak keit wit Saipras kerek wan kimaak keketik, hɨrak kepu ketike mɨt en. Aposel nekine niuk mɨrak ham me hɨm Grik Banabas. Niuk im hɨram matɨp mar im: “Mɨtɨk kɨkaap mɨt nises hɨm me God.” ");
INSERT INTO avt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hɨrak kerekek kesiuwe tɨ mɨrak ham keit pewek mererim keiyɨm kan kewet mɨt aposel em. ");
INSERT INTO avt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Banabas hɨrak kewet mɨt aposel kewetɨr pewek kenemtɨn me tɨ mɨrak te mɨtɨk hak au. Niuk mɨrak Ananaias. Hɨrak mɨte pɨrak Sapaira. Hɨrak kesiuwe tɨ mɨrak ham keit pewek mererim. ");
INSERT INTO avt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Te hɨrak kenke meiyaam pɨnam kɨsawɨnem, hɨrak kewet mɨt aposel pɨnam hɨrak ketpor kar ik: “Pewek im hi ewetiyem hɨram keremem. Hi ap etenen meiyam au.” Mɨte pɨrak epei wertei han kɨrak hɨre watɨp: “Hɨram werek.” ");
INSERT INTO avt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita kitɨwekhi kar ik: “Ti henmak te ti hewis Seten kari han kit te ti hewisɨs God Hɨmɨn Yaaik ti epei henke ham pɨnam hɨsawɨnem? ");
INSERT INTO avt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nɨpaa ti etenen tɨ hɨram mit. Ti epei hesiuwerem heit pewek mererim, hɨram mit. Ti henmak te ti han kitet hɨrɨak menmen enum mar im hɨsawɨn pewek pɨnam. Ti ap hewisɨsai haiu mɨt keriyen meriuwerem au. Ti hewises God ek.” ");
INSERT INTO avt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias kemtau hɨm im epei au, hɨrak kenkewɨn kaa. Hɨrak kenkewɨn kaa, mɨt kerek nemtau menmen im hɨr nepɨrpɨr iuwe. ");
INSERT INTO avt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Hɨr nepɨrpɨr iuwe, hɨr mɨt pipep neit laplap neiyɨm nan nesenkekik keriuwerem hɨr neiyɨk nen newisɨk kekre hei. ");
INSERT INTO avt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Maain, mɨte pɨrak wetari menmen im epei man, te hɨre wan in. ");
INSERT INTO avt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita kitɨwehi kar ik: “Ti hetike mɨtɨk kit yi epei yeit nan im keremem me tɨ yi yesiuwerem o?” Hɨre wewenhi watɨp war ik: “Keremem.” ");
INSERT INTO avt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ketpɨwe kar ik: “Ti hetike mɨtɨk kit yi yenmak te yi han kitetan yi yewenɨn hɨm God Hɨmɨn Yaaik te hɨrak kakyiwep au? Mɨt kerek epei newis mɨtɨk kit kekre hei, hɨr pɨke nanɨnen nantuthis nanrit nanɨno.” ");
INSERT INTO avt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hɨrak katɨp epei au, mɨte ip e hɨre wenkewɨn waa. Wenkewɨn waa, pipep nan nɨmɨn in nɨrep hɨre waa, te hɨr nɨnanep neiyɨp nen newisiye wɨwaai menep hei ke mɨtɨk kɨre. ");
INSERT INTO avt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mɨt ne weiwɨk miutɨp me God kerek nises hɨm me Krais neit Jerusalem netike mɨt han kerek nemtau menmen im, hɨr nepɨrpɨr wɨsenum. ");
INSERT INTO avt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mɨt aposel nɨrɨak menmen yaaim mirakel mekre nɨmɨn ke mɨt neiyɨm nɨkaap mɨt neriuwerem. Mɨt yapɨrwe kerek nises hɨm yaaim me Krais hɨr nererik nau han kiutɨp neit wɨnak iuwe ke God neit pɨnak niuk mɨrak “Hɨnp ke mɨtɨk Solomon.” ");
INSERT INTO avt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mɨt kerek ap nises hɨm me Krais hɨr nɨnapen netikeri nau nererik, te hɨr han kiteti hɨr mɨt yaain. ");
INSERT INTO avt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mɨt miyapɨr yapɨrwe neweikɨn sip newet menmen enum nises God, hɨr nererik netike mɨt miyapɨr nɨpaa nises God. ");
INSERT INTO avt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mɨt neit ein nɨr menmen yaaim aposel nɨrɨakem, te hɨr neit mɨt nɨnap neri nen newisi nɨwaai wit eik nentar yeno te Pita keke tɨ kakno in o ein kakwis his mamɨntar mɨt nɨnap o au en wepni kɨr kenep hɨmɨn kɨrak kentar mɨt nɨnap te hɨr nanre yaain. ");
INSERT INTO avt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mɨt yapɨrwe nerer wit wit menep Jerusalem hɨr nɨnan mɨt nɨnap netike mɨt herwe enum manɨp mekreri han kɨr ken sip te hɨr neri nan te Pita kekepi hɨr yapɨrwe niutɨp niutɨp nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mɨtɨk iuwe hetpris ketike mɨt han kerek nɨrɨak menmen netikerek, hɨr netike mɨt ne Sadyusi kerek han kitet mɨt nani pɨke nanɨkrit au. Hɨr yapɨrwe han mekpep neriuwe mɨt aposel nentar menmen hɨr nɨrɨakem ");
INSERT INTO avt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","te hɨr nen netorhis newisi nekre wɨnak enuk me nanamɨr ke mɨt yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Hɨr newisi nekre wɨnak enuk nepu nepeit, te Ensel ke God ke wɨtaan kan kɨkaisiu weipɨr ke wɨnak enuk keriyei nen wit eik ketpor kar ik: ");
INSERT INTO avt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yi eino eiyɨrp wɨnak iuwe ke God eitɨp mɨt miyapɨr hɨm me hɨr enises menmen ham yaaim hɨr nanu werek.” ");
INSERT INTO avt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hɨr nemtau hɨm mɨrak epei au, wanewik mɨt aposel nen nekre wɨnak iuwe ke God natɨp mɨt miyapɨr hɨm yaaim. Me wɨ im, mɨtɨk iuwe hetpris ketike mɨt kerek nɨrɨak menmen netikerek hɨr nenɨne mɨt iuwe ne Isrel netike mɨt han ne Kaunsil hɨr nererik nau wɨnak nemtau hɨm. Hɨr nau en, hɨr nesiuwe mɨt nanɨno wɨnak enuk te nantihis nanɨnen. ");
INSERT INTO avt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Hɨr nen ein te hɨr ap nɨri nekre wɨnak enuk au, te hɨr pɨke nan natɨp nar ik: ");
INSERT INTO avt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Haiu men miun wɨnak enuk epei au, haiu mɨr weipɨr nepei au nekepetek kɨk (o pes enum keit), mɨt nerp weipɨr naanmɨprewek te haiu mɨkaisiu weipɨr mɨnmatɨn mɨt hɨr nepu au.” ");
INSERT INTO avt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kerek mɨtɨk kinɨn naanmɨpre mɨt plisman ke wɨnak iuwe ke God hɨrak ketike mɨt iuwe pris nemtau menmen im, hɨr han kitet karkeik te hɨr netpaan nen wit eik. ");
INSERT INTO avt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hɨr wen han kitet menmen im mɨtɨk hak kan katɨp kar ik: “Nɨkɨp emnep eiyɨmtau menmen im. Mɨt kerek nɨpaa yi yewisi nekre wɨnak enuk hɨr nau neit wɨnak iuwe ke God newepyapɨr menmen natɨp mɨt miyapɨr em.” ");
INSERT INTO avt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hɨrak katɨp epei au, mɨtɨk kinɨn naanmɨpre plisman ketike mɨt plisman nɨrak epei nen ein netorhis neri nan. Hɨr nanɨp au nentar hɨr nɨnaain mɨt yapɨrwe en nanwɨr nan nanɨnɨp. ");
INSERT INTO avt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hɨr netorhis neri nan newisi nerp nekre nɨmɨn, mɨt ne kaunsil neweiknor, mɨtɨk iuwe pris kinɨn pris han, hɨrak kitorhi kar ik: ");
INSERT INTO avt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nɨpaa haiu metpi hɨm manp yi ap yewepyapɨr hɨm me Jisas nepei ketpim te yi epei yatɨp hɨm im merer wit wit ere mɨt yapɨrwe ne Jerusalem epei nemtewem nenepim. Yi hanhan yaitɨp haiu mɨt in menep Jisas hɨrak kaa.” ");
INSERT INTO avt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita ketike aposel han newenhi natɨp, “Haiu emises hɨm mi au, hɨm me God keremem. ");
INSERT INTO avt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yi epei yenep Jisas hɨrak kaa kentar nu tentarakɨt te God ke maamrer naiu nɨpaa ein naa, hɨrak kɨkɨak Jisas hɨrak pɨke kekrit kepu. ");
INSERT INTO avt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God kɨkɨak keriyaak kan ketikerek tau. Hɨrak kau menep his yaaim kerek mɨt iuwe newiyen. Hɨrak kɨre mɨtɨk iuwe kinɨn mɨt hɨrak kakɨkaap mɨt ne Isrel te hɨr enweikɨn sip enwet menmen enum te hɨrak kakɨsak menmen enum hɨr nɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Haiu mewepyapɨr menmen im. Hɨmɨn Yaaik kerek God kewet mɨt ek te hɨr nisesik, hɨrak kewepyapɨr menmen im.” ");
INSERT INTO avt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mɨt ne kaunsil nemtau hɨm im nepei au, hɨr nine han enuk wɨsenuk hɨr han kitet nanɨnep aposel nanɨnɨp nanɨnepi. ");
INSERT INTO avt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Au, mɨtɨk kiutɨp ke kaunsil niuk mɨrak Gameliel hɨrak mɨtɨk ke Farisi kerek hɨr ninɨn nises hɨm lo me Moses, hɨr mɨt han kitet hɨrak iuwe, hɨrak kerp ninaan me kaunsil katɨp mɨt hɨr nansiuwe aposel nanɨno wit eik nanɨno nanɨkre haau ham. ");
INSERT INTO avt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Hɨr epei nen wit eik, hɨrak katɨp mɨt ne kaunsil kar ik: “Yi mɨt ne weiwɨk me Isrel. Yi han ekitet werek werek menmen yi hanhan yairɨak mɨt in em. ");
INSERT INTO avt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nɨpaa mɨtɨk Tiudas kekrit katɨp hɨrak mɨtɨk iuwe, te mɨt 400 nererik nisesik. Au, mɨt nakɨp kaa te mɨt nɨpaa nisesik noknɨn nanɨno. ");
INSERT INTO avt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Me wɨ nɨpaa mɨt newis niuk me mɨt yapɨrwe mekre tɨwei me gavman, mɨtɨk Judas ke wit iuwe Galili kari han ke mɨt hɨr nisesik te hɨr mɨt han nakɨp kaa, mɨt kerek nisesik hɨr noknɨn nanɨno. ");
INSERT INTO avt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Te in ek hi hetpi me menmen me mɨt in. Yi ap eirɨak enum me mɨt in au, eiwisi enɨt. Menmen im hɨr nisesim hɨram han ke mɨt keremem te hɨram mami mamɨt. ");
INSERT INTO avt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Au en, menmen im God hɨrekes kɨrɨakem, te yi ap eiyinɨn mɨt in me menmen au, eiyɨntar yi eiyɨrtei yi yetike God yenepan hɨrak kakɨkepi.” Hɨrak katɨp epei au, mɨt ne kaunsil nises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hɨr nesiuwe mɨt nen neithis aposel neri nan, hɨr natɨp plisman nanɨp neriuwe nɨpɨn. Hɨr nanɨp neriuwe nɨpɨn, hɨr neriuweti nen netpor hɨm manp te hɨr ap pɨke nantɨp mɨt hɨm kerek nɨpaa Jisas epei ketpim, au meit. ");
INSERT INTO avt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel nɨnaaiwɨr wɨnak ke kaunsil han yaaik nentar hɨr nertei God han kitet hɨr yaain te hɨr mɨt han nanɨp nentar hɨr nises hɨm me Jisas. ");
INSERT INTO avt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hekrit hekrit neit wɨnak iuwe ke God kekite wɨnak ke mɨt hɨr wen natɨp mɨt miyapɨr hɨm yaaim me Jisas kerek hɨrak Mɨtɨk God kehimɨtanek kakɨkaap mɨt nantike God nanu. ");
INSERT INTO avt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Maain wɨ ham, mɨt nises hɨm me Krais hɨr nɨre yapɨrwe. Mɨt nises hɨm me Krais kerek natɨp hɨm Grik, hɨr nemtaantɨwo neriuwe mɨt nises hɨm me Krais hɨr natɨp hɨm Hibru. Mɨt natɨp hɨm Grik hɨr natɨp nar ik: “Mɨt ap newet miyapɨr han kerek mɨkaan nɨr naa epei nɨnaiwɨri, mɨt han ap nekepi newetɨr menmen nɨnpɨn werek au.” ");
INSERT INTO avt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Te mɨt aposel hiswiyen wik (12) nenɨne mɨt yapɨrwe nises hɨm me Krais netpor nar ik: “Haiu mɨt aposel emwet mɨt miyapɨr pewek me nɨnpɨn menmen meiyam te haiu ap mewepyapɨr hɨm me God au emɨt. ");
INSERT INTO avt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Te naiu yinan yi yɨnyatɨn mɨt hispɨnak wik (7) hɨr mɨt yaain God Hɨmɨn Yaaik kau han kɨr hɨr nertei menmen werek werek haiu mehimɨteni hɨr naanmɨpre menmen im. ");
INSERT INTO avt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Hɨr enrɨak menmen im te haiu mehimɨtan hɨras haiu hekrit hekrit mitehi God menmen, haiu matɨp mewepyapɨr hɨm me Krais.” ");
INSERT INTO avt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mɨt miyapɨr yapɨrwe hɨr han yaaik neriuwe hɨm me mɨt aposel te hɨr nehimɨtan mɨt hispɨnak wik (7). Hɨr nehimɨtan Stiven, hɨrak mɨtɨk kises hɨm me God iuwe, God Hɨmɨn Yaaik kau kekre han kɨrak iuwe. Hɨr nehimɨtanek kekite Filip, Prokoras, Naikena, Taimon, Pamenas, hɨr netike Nikolas, kerek nɨpaa ke wit Antiok. Hɨrak ap ke weiwɨk me Isrel te hɨrak nɨpaa keweikɨn sip kewet menmen enum kises hɨm me Moses. ");
INSERT INTO avt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Hɨr neit mɨt in neriyei neri nen mɨt aposel. Hɨr nitehi God ke mɨt in, hɨr ner neit mɨt in neriyei neri nen mɨt aposel. Hɨr nitehi God ke mɨt in, hɨr newis his mau paan kɨr niutɨp niutɨp nehimɨteni nɨrɨak menmen hɨr nɨpaa netpim. ");
INSERT INTO avt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mɨt miyapɨr neiyan yapɨrwe neit Jerusalem nemtau hɨm me Krais, hɨr nisesim. Mɨt pris hɨr newet God menmen me mɨt, hɨr yapɨrwe nises hɨm yaaim me Krais. ");
INSERT INTO avt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Hɨrak Stiven kerek kises hɨm me Krais, God kerekɨwek yaaim, kewetɨwek menmen iuwe mɨrak te hɨrak kɨrɨak menmen yaaim mirakel kɨkaap mɨt kerek hɨr nɨnap o menmen yapɨrwe manɨp te hɨr nɨre yaain. ");
INSERT INTO avt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Te mɨt han netikerek nenehan. Mɨt in hɨr ne wɨnak kerek mɨt nererik nekine hɨm me Moses nekrerek. Niuk me wɨnak ik hɨram Friman kentar mɨt nɨpaa nepu enum nɨrɨak menmen nanɨt pewek mererim au, te in ek hɨr nɨnaaiwɨr menmen im. Mɨt in hɨr ne wit Sairini, wit Aleksandria, Silisia ketike provins Esia, hɨr netike Stiven nenehan. ");
INSERT INTO avt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Hɨr nenehan te God Hɨmɨn Yaaik kɨkaap Stiven hɨrak kertei menmen wɨsenum te mɨt en ap natɨp menmen ninɨnek taau. ");
INSERT INTO avt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hɨr han enuk newet mɨt han pewek te hɨr nan newepyapɨr Stiven natɨp nar ik: “Haiu memtewek hɨrak katɨp enum me Moses ketike God.” ");
INSERT INTO avt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mar im hɨr nari han ke mɨt yapɨrwe hɨr han enuk hɨr netike mɨt iuwe ne kaunsil netike mɨt ninɨn nertei hɨm lo me Moses hɨr nan netɨwekhis neriyaak neiyɨk nen wɨnak ke kaunsil. ");
INSERT INTO avt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hɨr neithis mɨt han nan nemitɨwekpɨn natɨp nar ik: “Hekrit hekrit mɨtɨk ik hɨrak katɨp enum me wɨnak iuwe ke God ik ketike hɨm lo me Moses. ");
INSERT INTO avt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Haiu memtau hɨrak katɨp Mɨtɨk Jisas ke Nasaret kakwen wɨnak iuwe ke God ik e kaknip haiu mɨt emises hɨm ham me hɨm nɨpaa Moses kewisɨm kewetaiyem.” ");
INSERT INTO avt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mɨt yapɨrwe neit wɨnak ke kaunsil nɨrapɨre Stiven nɨr ninaan mɨrak hɨram mɨre ninaan ke mɨtɨk ensel ke wit ke God, hɨram merhɨhe. ");
INSERT INTO avt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mɨtɨk iuwe hetpris kinɨn mɨt pris han, hɨrak kitehi Stiven kar ik: “Menmen mɨt in netpaiyem nɨpaa ti hetpim o au?” ");
INSERT INTO avt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiven kewenhi ketpor kar ik: “Nai yinan yetike haairer, yi eiyɨmtau hɨm mai. Nɨpaa enum eik Ebraham hɨrak maam nɨpu kaiu ken wit Heran wen au, hɨrak kepu wit Kaldia, God hɨrak yaaik kerhɨhe kewepyapɨr hɨrekes ");
INSERT INTO avt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","katɨp Ebraham kar ik: ‘Ti enaaiwɨr wit kit ik e, haairer, paaprer nit, ti eno tɨ hak hi tewen ateiknutek.’ ");
INSERT INTO avt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hɨrak katɨp epei au, Ebraham kɨnaaiwɨr wit ke mɨt ne Kaldia ken kau wit Heran. Hɨrak kau en ere haai kɨrak epei kaa te maain God kesiuwerek ken wit kerek yi mɨt in yewi. ");
INSERT INTO avt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Hɨrak kau en me wɨ eim, te God ap kewetɨwek tɨ kei kike kiutɨp au. God katɨp Ebraham hɨrak kakwetɨwek tɨ kaktike nepenyerer nɨrak hɨr nantɨwek. Wɨ God katɨp Ebraham hɨm im, Ebraham ap kine nɨkerek wen au. ");
INSERT INTO avt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God katɨp Ebraham hɨm im, hɨrak katɨp kar ik: ‘Nɨkerek ni nanu tɨ hak ere 400 tito. Hɨr nanu enum mɨt nanrekyor enum, hɨr nanre mɨt enun nekre wɨnak enuk hɨr nanrɨak menmen nanɨt pewek mererim au. ");
INSERT INTO avt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Maain hi anep mɨt kerek nanrɨak nepenyerer ni enum, hi anɨp erekyor enum te hi eriyei nepenyerer ni nanɨnaaiwɨr wit enuk ek nanɨnen tɨ ik nanises hɨm mai nanwenanɨpi.’ ");
INSERT INTO avt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Hɨrak katɨp epei au, God kewet Ebraham hɨm hɨrak kakisesim me hɨrak kerekir yɨnk kɨrak keteikɨn mɨt hɨrak kises God hɨrakɨt tekiyakɨt tau teit. Maain hɨrak kine nɨkan kɨrak Aisak. Hɨrak kepu me wɨ hispɨnak wikak (8), haai kɨrak kerekir yɨnk kirak. Maain hɨrak Aisak kɨre iuwe, hɨrak kine Jekop, te hɨrak kerekir yɨnk kɨrak. Maain Jekop kɨre iuwe hɨrak kerekir yɨnk ke nɨkerek hiswiyen wik nɨrak (12). Hɨr maamrer nɨpu naiu. ");
INSERT INTO avt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Maain hɨr nɨre iuwe hɨr han menepep nɨkik kɨr Josep te hɨr nesiuwerek ken his me mɨt nanɨno Isip hɨr neit pewek mererik. Josep kɨrɨak menmen keit pewek mererim au, te God kau ketikerek naanmɨprewek. ");
INSERT INTO avt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","God kekepik keriuwe menmen enum yapɨrwe epei man mɨt nerekyɨwekem. Wɨ kerek Fero mɨtɨk iuwe ke wit iuwe Isip kari Josep kan kɨrek, God kekepik hɨrak katɨp hɨm yaaim kertei menmen werek werek. Fero epei kɨrek hɨrak kehimɨtanek hɨrak kinɨn naanmɨpre wit iuwe Isip ketike wɨnak yapɨrwe me mɨtɨk iuwe Fero. ");
INSERT INTO avt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Maain wɨ man tɨ hawɨ au te ni mɨr mewo au maa meit wit Isip kekite wit Kenan. Menmen im mewaank mɨt yapɨrwe, maamrer nɨpu naiu nɨnatɨn menmen au. ");
INSERT INTO avt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Maain Jekop kemtau menmen meit wit Isip, hɨrak keriuwet nɨkerek, hɨr maamrer nɨpu naiu, hɨr ninɨn nen Isip nanɨt menmen. ");
INSERT INTO avt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Maain hɨr pɨke nen neteipim te Josep kewepyapɨr hɨrekes ke heiyiuwerer nɨrak kerek hɨr han kitet nɨpaa ein hɨrak kaa. Marik Fero kertei Josep heiyiuwerer nɨrak, haai kɨrak hɨr nepu. ");
INSERT INTO avt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep katɨp heiyiuwerer nɨrak kar ik: ‘Yi eitɨp haai kai hɨrak ketikewi, miyapɨr ni nɨkerek ni yi einen eiyu wit Isip.’ Mɨt miyapɨr hɨr yapɨrwe nar ke 75 mɨt. ");
INSERT INTO avt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Epei au, Jekop ketike nɨkerek nɨrak nepenyerer nɨrak nekiuwe nen Isip nau en ere hɨrak ketike nɨkerek nɨrak, kerek maamrer nɨpu naiu, hɨr ne mɨt hɨr naa. ");
INSERT INTO avt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nepenyerer neit herwe yɨnk neiyɨk nen wit Sikem hɨr newisɨm mekre han kerek nɨpaa Ebraham kewɨr pewek ketnik ke mɨt ne weiwɨk miutɨp me mɨtɨk Hemo. ");
INSERT INTO avt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Wɨ epei man menep kerek God kakises hɨm nɨpaa hɨrak katɨp Ebraham em me kakwetɨwek tɨ me wit Kenan, mɨt haairer ne weiwɨk maiu hɨr nɨre yapɨrwe neit wit Isip. ");
INSERT INTO avt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Hɨr nɨre yapɨrwe ere mɨtɨk Fero hak kinɨn naanmɨpre Isip. Hɨrak ap kises menmen nɨpaa Josep kɨrɨakem au kɨneinɨm kentar nɨpaa enum eik Josep kaa. ");
INSERT INTO avt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hɨrak kewises maamrer naiu, hɨrak kewaanki. Hɨrak kenipor hɨr newɨr nɨkerek hemkre tu nen wit eik te hɨr au nani. ");
INSERT INTO avt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Me wit im e, Moses miye pɨrak hɨre winaak hɨrak yaaik wetpen. Miye haai naanmɨprewek neit wɨnak ere wenke wikak. ");
INSERT INTO avt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wenke wikak o, miye haai nɨrak newisɨk keit wit eik nises hɨm me mɨt iuwe ninɨn naanmɨpre Isip. Hɨrak kaa au. Nɨki pe mɨtɨk iuwe Fero hɨre wɨrek weriyaak wetɨwekhis naanmɨprewek hɨrak kɨre nɨkan kɨre. ");
INSERT INTO avt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mɨt ne Isip neteiknɨwek menmen yapɨrwe hɨr nerteiyem te hɨrak kɨre mɨtɨk iuwe katɨp hɨm yaaim kɨrɨak menmen yaaim kertei menmen yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Maain Moses kepu 40 tito epei au, hɨrak kare kakno kakɨr nɨrak yinan ne weiwɨk miutɨp mɨrak me Isrel. ");
INSERT INTO avt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Hɨrak ken en kɨr mɨtɨk ke Isip kɨrɨak mɨtɨk ke Isrel menmen enum te hɨrak Moses kekepik kenep ke Isip kakɨp kaa. ");
INSERT INTO avt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hɨrak han kitet mɨt ne weiwɨk miutɨp mɨrak nanɨrtei God kehimɨtanek te hɨrak kakɨkepi hɨr nanɨnaaiwɨr Isip te hɨr au netari. ");
INSERT INTO avt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wɨ ham hɨrak kɨr mɨtɨkɨt wik te weiwɨk miutɨp mɨrak tenepakɨt te hɨrak kereksir ketpɨwekɨt kar ik: ‘Emɨt! Yi mɨtɨkɨt yi te maam kiutɨp. Yi ap te yi yɨrɨakakɨt enum emɨt!’ ");
INSERT INTO avt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Au, hɨrak kerek kɨrɨak keiyak enum keriuwet Moses ken ketpɨwek kar ik: ‘Ti enopɨn. Keimɨn kehimɨtenut ti mɨtɨk iuwe naanmamprai erehirawɨr hawɨr wenepakɨt me menmen? ");
INSERT INTO avt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ti han kitet ti eiyep har ke nepɨp ti enep kei ke Isip a?’ ");
INSERT INTO avt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses kemtau menmen mɨtɨk ketpɨwekem, hɨrak han kitet mɨtɨk iuwe kakɨmtau hɨrak kenep mɨtɨk ke Isip kaa te hɨrak kɨnaain kɨnaaiwɨr Isip kɨrɨr ken yanɨmɨn kɨpiun wit Midian kau en. Hɨrak kau en o, hɨrak kine nɨkerek hɨrakɨt wik. ");
INSERT INTO avt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Hɨrak kepu wit Midian kau en ere 40 tito. Wɨ ham, ensel ke God kɨsawɨn kekre nu, hɨrak kenip si metnen mau nu keit wit tenhaan weinɨk menep mɨniu (o neiyɨp) Sainai. Hɨrak kewepyapɨr hɨrekes kekre nu kerek Moses kɨrek si metnen mewik. ");
INSERT INTO avt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses kɨrek si metnen mewik, te hɨrak kehɨnhɨn ken menep kakɨrek. Hɨrak ken menep kakɨrek, hɨrak kemtau God ketpɨwek. ");
INSERT INTO avt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Hɨrak ketpɨwek kar ik: ‘Hi God ke maamrer nɨpu nit. Hi God ke Ebraham, Aisak, Jekop.’ Moses hɨrak kepɨrpɨr kɨnapen kɨkɨamnaan kɨrek au. ");
INSERT INTO avt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mɨtɨk Iuwe God ketpɨwek kar ik: ‘Ti eket su mit. Tɨ ik ti herp en, hɨrak tɨ holi hi hehimɨtanek hɨrak kai hentar hi hewik. Hi hanhan ti han ekitɨta. ");
INSERT INTO avt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Hi epei hɨr menmen enum mɨt nɨrɨak mɨt ne weiwɨk miutɨp mai neit Isip. Hi hemtau hɨm mɨr hɨr natɨp nenepɨp te hi han akepi. Ti enen in ewisa hi heriuwetit ti eno Isip.’ ");
INSERT INTO avt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses hɨrak mɨtɨk kerek mɨt ne Isrel nɨpaa netpɨwek nar ik: ‘Keimɨn kehimɨtenut ti naanmamprai erehirai haiu mɨt menehan menepan me menmen? Taau!’ Hɨrak kerekek God keriuwetek ken naanmɨpri, ensel ke God kekre nu sitaak hɨrak kekepik. ");
INSERT INTO avt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hɨrak kekepik, hɨrak Moses keriyei mɨt nɨnaaiwɨr Isip, hɨrak kɨrɨak menmen yaaim iuwe mirakel nɨpaa mɨt nɨrem au keit wit Isip ketike Wan kɨre Yɨwir, ketike wit tenhaan weinɨm ere 40 tito. ");
INSERT INTO avt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses kerekek hɨrak katɨp mɨt ne Isrel kar ik: ‘God hɨrak kakweti mɨtɨk hɨrak profet kakɨr ke hi hɨrak keriuweta, hɨrak ke yi mɨt te yi yayɨmtau hɨm mɨrak.’ ");
INSERT INTO avt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses nɨpaa kepu ketike mɨt ne Isrel nererik nau wit tenhaan weinɨm, kerek mɨt newi au. Hɨrak kepu ketike maamrer naiu netike ensel kerek ketpɨwek keit miniu (o neiyɨp) niuk mɨrak Sainai. Hɨrak keit hɨm me God hɨram mamkaap mɨt nanu nanɨt tipmain tipmain enum eik hɨrak kewetaiyem. ");
INSERT INTO avt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Au, maamrer nai nɨneinɨk nises hɨm mɨrak au. Hɨr neweikɨn sip newetɨwek, nekre han kɨr hɨr hanhan pɨke nanɨno Isip, ");
INSERT INTO avt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","te hɨr natɨp Eron nar ik: ‘Ti eime menmen mɨre bulmakau hɨram mamɨr ke God kaiu hɨram maminɨn mamno naanmamprai. Haiu mepɨtari Moses hɨrak kerek keriyai meit Isip kerai kan, hɨrak kepeit mɨniu (o neiyɨp) o hɨrak keit neiyɨn o mekam makɨp. Ekɨt en ekɨt!’ ");
INSERT INTO avt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Me wɨ im hɨr nime nu mɨre bulmakau, hɨr nenep samiyak neit hemkre neiyɨm nehɨnek, nemaniyek naam teipe menmei menmei miunewek neiyɨm nɨrɨre. ");
INSERT INTO avt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hɨr nemaniyek nɨrɨre o, God keweikɨn sip kewetɨr kewisi hɨr newenɨpi hɨr mau nepni. Hɨm God hɨrak kewet mɨt profet em hɨr newisɨm mau tɨwei matɨp mar im: ‘Yi mɨt ne Isrel. Me 40 tito yi ap yenep samiyak yeit hemkre yeiyɨm yehɨnem au. Yi yewet tɨpir ham em. ");
INSERT INTO avt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yi yɨnan weisaak me yɨnk me meme me tɨpir Molok kerekek. Hi au. Yi yɨnan menmen mɨre me tɨpir Refan yi yɨrɨakem. Im em hɨram mɨre ninaan mau teinɨk mi yi yimaam yewenɨpi niuk mɨr. Hi au. Te maain hi tewen eriuwet mɨt nepan ne wit Babilon hɨr nanɨnen nantihis nanri nanɨno yi eisipat wit kɨr yi eino ein.’ ");
INSERT INTO avt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Maamrer naiu neremɨme weisaak kɨr neit wit tenhaan weinɨm mɨt ap newi. Weisaak ik keteiknor hɨrak God kau ketikeri. Hɨr epei nimaak kar ke nɨpaa God katɨp Moses keteiknɨwek han kɨrak hɨrak kimaak. ");
INSERT INTO avt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Maain nɨkerek nɨr neit weisaak kɨr ke haairer te hɨr netike Josua neiyɨk nen, hɨr nari tɨ ke mɨt ap ne weiwɨk me mɨt ne Isrel. God kepɨr mɨt in nen naa te mɨt ne Isrel nekrehɨr kɨr. Weisaak kɨr kepu keit wit Isrel ere wɨ Devit naanmɨpre mɨt en. ");
INSERT INTO avt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God hanhan Devit te Devit kitɨwekhi kakime wɨnak ke God kerek maam nɨpu kaiu Jekop kewenɨpiyek. ");
INSERT INTO avt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Au, Solomon, Devit nɨkan kɨrak hɨrak kime wɨnak eik e. ");
INSERT INTO avt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“God hɨrak mɨtɨk iuwe ap kepu wɨnak mɨt nimaak. Au, mɨtɨk profet Aisaia kewis menmen im: ");
INSERT INTO avt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mɨtɨk Iuwe God hɨrak katɨp kar ik: “Nepni hɨram mɨre yeno kai hi hau en, hi hinɨn naanmɨpre menmen, tɨ hɨram mɨre tapɨn hi hewis hɨt menterim. Te yi yayime wɨnak karkeik te hi ehu en? ");
INSERT INTO avt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hi ehu wit karkeik? Hi hɨrekes epei hewis menmen yapɨrwe.” ’ ");
INSERT INTO avt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Yi mɨt enun nɨkɨp paan tokini. Yi yɨre mɨt enun ap yises hɨm God ketpiyem. Yi yar ke maamrer ni. Yi yetikeri ap yises hɨm me God Hɨmɨn Yaaik au. ");
INSERT INTO avt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yi eikine niuk me mitɨk profet kiutɨpen ke mɨt profet yapɨrwe kerek nɨpaa ein nepu te maamrer ni ap nerekyor enum. Taauye! Hɨr nenep mɨt en kerek nɨpaa newepyapɨr hɨm natɨp Mɨtɨk Yaaik Krais God kehimɨtanek hɨrak kaknen kakɨkepai. Yi hɨras epei yenep mɨtɨk ik. ");
INSERT INTO avt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yi keriyen yeit hɨm me God ensel kewetiyem te yi ap yisesim au.” ");
INSERT INTO avt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mɨt ne kaunsil nemtau hɨm Stiven epei ketpor, hɨram merekiror han hɨr han enuk neriuwerek yehes matɨn mekeipepam. ");
INSERT INTO avt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stiven kerek God Hɨmɨn Yaaik kau kekre han kɨrak iuwe hɨrak kɨkɨamnaan kɨr menmen iuwe me God, hɨrak kɨr Jisas kerp God his yaaim mɨrak kerek mɨt iuwe nerpai. ");
INSERT INTO avt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stiven kɨrek, hɨrak katɨp kar ik: “Yi eiyɨmtau. Hi hɨr nepni mewep hi hɨr wit ke God kau yaain. Mɨtɨk Jisas, hɨrak Mɨtɨk ke wit ke God hɨrak kerp his yaaim mɨrak.” ");
INSERT INTO avt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hɨrak katɨp menmen im epei au, hɨr mɨt yapɨrwe nɨnap nenepɨp nemesɨs nɨkɨp nɨnapen nemtau hɨm im, hɨr nesiuknen nererik neweiknɨwek netenenik ");
INSERT INTO avt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","neriyaak ken wit eik ere nɨnaaiwɨr nɨwa ke wit Jerusalem, hɨr newɨr nan nakɨp. Mɨt nɨpaa newepyapɨrek nenke saket mɨr nokim newisɨm mɨwaai hɨt me mɨtɨk pipɨak hak niuk mɨrak Sol, hɨrak naanmɨpre saket mɨr te hɨr nenep Stiven. ");
INSERT INTO avt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hɨr wen newɨr nan nakɨp, hɨrak Stiven kitehi God katɨp kar ik: “Mɨtɨk Iuwe Jisas ti ehɨt hɨmɨn kai.” ");
INSERT INTO avt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hɨrak kitehɨr kewen ninɨp kɨnap hɨm iuwe, “Mɨtɨk Iuwe ti ap han ekitet menmen enum hɨr nerekyewem.” Hɨrak katɨp menmen im epei au, hɨrak kaa. Mɨtɨk Sol hɨrak han yaaik hɨr nakɨp kaa. ");
INSERT INTO avt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Me wɨ im mɨt neit Jerusalem newaank mɨt miyapɨr kerek nises hɨm me Krais. Mɨt yapɨrwe hɨr nises hɨm me Krais nɨnaaiwɨr Jerusalem nɨrɨr nen nau nerer wit wit neit provins Judia kekite provins Sameria. Hɨr mɨt aposel au, hɨr wen nau neit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mɨt han nises hɨm me God werek, hɨr neit Stiven herwe yɨnk kɨrak nen newep hei newisɨk, hɨr nɨkɨtek hɨm iuwe. ");
INSERT INTO avt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Hɨr nɨkɨtek te Sol kare kakɨwaank mɨt miyapɨr nises hɨm me Krais. Hɨrak ken kerer wɨnak wɨnak kari mɨt miyapɨr ken kewisi nen nekre wɨnak enuk. ");
INSERT INTO avt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mɨt nises hɨm me Krais kerek nɨpaa nɨrɨr nɨnaaiwɨr Jerusalem nen ein ein natɨp mɨt miyapɨr hɨm me Krais. ");
INSERT INTO avt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mɨtɨk niuk mɨrak Filip ken wit Sameria katɨp mɨt ne mɨtɨk Krais kerek God kehimɨtanek kan kɨkaap mɨt. ");
INSERT INTO avt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mɨt miyapɨr yapɨrwe hɨr han kiutɨp newis nɨkɨp nises menmen hɨrak ketpim nentar hɨr nɨr menmen yaaim hɨrak kɨrɨakem keiyɨm kɨkaap mɨt. ");
INSERT INTO avt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Hɨrak kepɨr herwe enum hɨram menepɨp menpɨn mekeipɨn mɨt, hɨrak kɨkaap mɨt hɨt maa o mɨt hɨt enum hɨr nɨre yaain, ");
INSERT INTO avt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","te mɨt neit ein han yaaik nepu. ");
INSERT INTO avt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mɨtɨk hak niuk mɨrak Saimon hɨrak kau wit Sameria. Nɨpaa ere wɨ Filip kan hɨrak ketenwo henpɨn, kewen hawɨ menmei menmei marim te mɨt miyapɨr neit Sameria hɨr han kɨr kekrit. Hɨrak kewenɨpi hɨrekes hɨrak iuwe. ");
INSERT INTO avt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mɨt yapɨrwe neit Sameria, mɨt iuwe, mɨt weinɨn, hɨr nemtau hɨm mɨrak nisesik. Hɨr natɨp nar ik: “Mɨtɨk ik hɨrak ketenen menmen me God iuwe hɨrak kɨre God.” ");
INSERT INTO avt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mɨt en hɨr nisesik iuwe nentar me wɨ yapɨrwe hɨrak kenipi hɨr han kɨr kekrit keriuwe menmen hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Te maain Filip kan katɨp mɨt miyapɨr hɨm me God kakinɨn naanmampre mɨt, ketpor hɨm me Jisas Krais, mɨt miyapɨr yapɨrwe hɨr neweikɨn sip newet Saimon, hɨr nises hɨm im te Filip kɨkɨri. ");
INSERT INTO avt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon hɨrkes kises hɨm me Krais, Filip kɨkɨrek. Epei au, hɨrak kises Filip menep menep kɨre wariyakɨt kɨrak, hɨrak kɨr menmen yaaim iuwe hɨrak kɨrɨakem kɨkaap mɨt keriuwerem te hɨrak han kɨrak kekrit. ");
INSERT INTO avt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mɨt aposel neit Jerusalem nemtau mɨt ne Sameria nises hɨm me God, hɨr neriuwet Pita kekite Jon hɨrakɨt ten Sameria. ");
INSERT INTO avt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hɨrakɨt ten tiun Sameria, hɨrakɨt titehi God te God Hɨmɨn Yaaik kaku han ke mɨt in, ");
INSERT INTO avt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","tentar God Hɨmɨn Yaaik ap kan kewi wen au. Filip kɨkɨri kekine niuk me Jisas kerekek. ");
INSERT INTO avt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pita ketike Jon tewis his mɨrakɨt mewi te God Hɨmɨn Yaaik kan kau han kɨr. ");
INSERT INTO avt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon kɨr aposel tewis his mɨrakɨt mau mɨt God Hɨmɨn Yaaik kan kewi, te hɨrak katɨp kakwet Pita kekite Jon pewek ");
INSERT INTO avt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ketpɨwekɨt kar ik: “Yi yenipa hi hertei menmen im te hi ewis his mamu mɨt, God Hɨmɨn Yaaik kakwi.” ");
INSERT INTO avt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita kewenhi kar ik: “Hi hanhan ti hetike pewek mit yaino si tatɨkneni yentar ti han kitet ewɨr pewek ehɨt menmen yaaim me God hɨrak kewet mɨt en em weinɨm. ");
INSERT INTO avt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Menmen im hɨram menmen mit au, mentar God kɨr han kit hɨrak yaaik au. ");
INSERT INTO avt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ti eweikɨn sip ewet menmen im me ti han kitetim, ehitehi God kakɨsak menmen enum ti han kitetim. ");
INSERT INTO avt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Hi hertei ti han enuk hemkre menepam heriuwe menmen haiu mɨrɨakem. Menmen im enum mau mekre han kit metenɨnit mar ke waai mesenkek mɨtɨk hak his mɨrak keit wɨnak enuk.” ");
INSERT INTO avt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon katɨp Pita kekite Jon: “Yi eiyitehi God ke hi te menmen ti hetpim ap mamnen mamrewaank.” ");
INSERT INTO avt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita ketike Jon tatɨp menmen hɨrakɨt terteiyem me Jisas Krais, hɨrakɨt tetpor hɨm me God. Epei au, hɨrakɨt pɨke tepno Jerusalem, hɨrakɨt ten tatɨp mɨt miyapɨr hɨm me God terer wit wit me provins Sameria ere hɨrakɨt tɨpiun wit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pita ketike Jon epei ten, ensel ke Mɨtɨk Iuwe God kan katɨp Filip kar ik: “Ti hekrit ekiuwe eno ere ti epiun yayiwe kepno Jerusalem ere wit Gesa.” Nɨpaa mɨt nises yayiwe ik te in ek au. ");
INSERT INTO avt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Filip kemtewek epei au, hɨrak kekrit ken. Me wɨ im mɨtɨk hak hɨrak mɨtɨk iuwe ke wit Itiopia pɨke kakno wit kɨrak kitet yayiwe ik kepno. Mɨtɨk ik mɨtɨk iuwe naanmɨpre pewek me mɨte iuwe mɨt nekine niuk mɨre nenewe Kwin Kandesi, hɨre pe kantri Itiopia. Hɨrak ken wit Jerusalem kewenɨpi God te hɨrak pɨke kau karis kɨrak kepnen. Hɨrak kepnen hɨrak kekine tɨwei nɨpaa profet Aisaia kewisɨm. ");
INSERT INTO avt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","God Hɨmɨn Yaaik katɨp Filip kar ik: “Ti eno menep karis im ti etikerek eino.” ");
INSERT INTO avt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hɨrak katɨp epei au, Filip kesiuknen ken menep kemtau mɨtɨk ek kekine hɨm mau tɨwei nɨpaa profet Aisaia kewisɨm. Filip kitɨwekhi kar ik: “Ti hertei hɨr o as me menmen ti ekinaam o au?” ");
INSERT INTO avt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mɨtɨk iuwe eik kewenhi kar ik: “Markeik te hi erteiyem? Mɨtɨk ketpo menmen te hi erteiyem. Ti enen etikewa ewu in ti ewepyapɨr menmen te hi erteiyem.” ");
INSERT INTO avt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Hɨm mɨtɨk hɨrak kekinaam hɨram mar im: “Hɨrak kɨre sipsip mɨt neriyaak nakɨp hɨrak ketikeri nenepan au. Hɨrak kɨre sipsip mɨt nime tepnek mɨrak hɨrak katɨp hɨm enum au, hɨrak kekintɨp. ");
INSERT INTO avt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Hɨr nenipek yɨnk enuk, hɨr nanriyaak kakno kot mɨt nankepik au. Keimɨn kakwis niuk me nɨkerek nɨrak mamu tɨwei? Hɨrak mɨtɨk hak ap kakwisɨm kakɨntar hɨr nankɨp kaki, hɨrak ap kaku tɨ kakine nɨkerek au.” ");
INSERT INTO avt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mɨtɨk iuwe kitehi Filip kar ik: “Ti etpo profet katɨp keimɨn? Hɨrak hɨrekes o mɨtɨk hak?” ");
INSERT INTO avt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip ketpɨwek menmen, hɨrak katɨp me hɨm ek hɨrak kekinam te hɨrak ketpɨwek hɨm yaaim me Jisas. ");
INSERT INTO avt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hɨrakɨt tepno yayiwe tɨpiun wit heipun mɨwaairi te mɨtɨk iuwe katɨp, “Ahɨrek! Tɨpar mei mɨwaai in. Ap menmen mei meiyepeta te ti ekɨra au.” ");
INSERT INTO avt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip kewenhi, “Hi ekrit te ti hises Jisas Krais heriuwe han kit.” Hɨrak kar ik: “Hi han kitet Jisas hɨrak Nɨkan ke God kerekek.” ");
INSERT INTO avt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hɨrakɨt tatɨp epei au, mɨtɨk iuwe katɨp mɨtɨk naanmɨpre karis hɨram merp, te hɨrak ketike Filip tenke ten tɨpar, Filip kɨkɨrek. ");
INSERT INTO avt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hɨrakɨt tɨnaaiwɨr tɨpar tɨniu ten, God Hɨmɨn Yaaik keithis Filip keriyaak ken te mɨtɨk iuwe kerenaan kɨnketnɨwek kɨrek au. Hɨrak pɨke kau karis kitet yayiwe han yaaik ken nɨrak en. ");
INSERT INTO avt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Te God Hɨmɨn Yaaik hɨrak kari Filip ken. Hɨrak keriyaak ken, te hɨrak kerenaan kɨr hɨrekes hɨrak keit wit Asdot. Hɨrak keke tɨ ken kerer wit wit kewepyapɨr hɨm yaaim me God ere hɨrak kɨpiun wit Sisaria. ");
INSERT INTO avt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Filip wen kɨrɨak menmen, mɨtɨk Sol wen katɨp enum kaknep mɨt miyapɨr nises hɨm me God. Hɨrak ken kɨr mɨtɨk iuwe pris kerek kinɨn naanmɨpre pris yapɨrwe, ");
INSERT INTO avt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","hɨrak kitɨwekhi kakɨt tɨwei keiyɨm kakno wɨnak me mɨt ne weiwɨk me Isrel hɨr nau nererik nekine hɨm me Moses neit wit Damaskas. Tɨwei ik katɨp hɨram yaaim te Sol kɨr mɨt miyapɨr kerek nises hɨm nɨpaa Jisas ketpim, hɨrak kaktorhis kakriyei kakri kaknen wit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hɨrak keit tɨwei epei au, hɨrak ken wit Damaskas. Hɨrak kepno menep, si mewenɨn waswas moke nepni man mɨr meweiknɨwek. ");
INSERT INTO avt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Hɨrak kenkewɨn kɨwaai tɨ kemtau mɨtɨk keit ein katɨp kar ik: “Sol Sol ti henmak te ti erekyo enum?” ");
INSERT INTO avt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol kitɨwekhi kar ik: “Mɨtɨk Iuwe ti keimɨn?” Hɨrak ketpɨwek kar ik: “Hi Jisas kerek ti herkyo enum. ");
INSERT INTO avt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ti ekrit eno wit Damaskas. Maain ti heit en, mɨtɨk hak kaknen kakɨtput menmen ti ehisesim.” ");
INSERT INTO avt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hɨr mɨt kerek netike Sol nitet yayiwe nen, hɨr nerp neit. Hɨr nemtau hɨm te hɨr ap nɨr mɨtɨk keimɨn katɨp. ");
INSERT INTO avt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jisas ketpɨwek nepei au, Sol kekrit kesiupan nanamɨr te hɨrak ap kɨr menmen au. hɨrak nanamɨr toto, te mɨt netikerek netɨwekhis neriyaak neiyɨk nen Damaskas. ");
INSERT INTO avt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Hɨr nɨpiun Damaskas, me wɨ wikak Sol epei kɨr menmen au, hɨrak ap kaam tɨpar o menmen au. ");
INSERT INTO avt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mɨtɨk kiutɨp kises hɨm me Jisas kau wit Damaskas niuk mɨrak Ananaias. Hɨrak kepu kɨtyak kɨr Mɨtɨk Iuwe Jisas kan ketpɨwek menmen kar ik: “Ananaias.” Hɨrak kekɨke kar ik: “Mɨtɨk Iuwe hi hepu.” ");
INSERT INTO avt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mɨtɨk Iuwe ketpɨwek, “Ti ekrit eno wit niuk mɨrak “Ya wit kɨpɨrak,” ti eno wɨnak ke Judas ti eitɨwekhi ke mɨtɨk ke wit Tasas niuk mɨrak Sol. Hɨrak prea kitauhi menmen kepu ek. ");
INSERT INTO avt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Hɨrak epei kɨtyak kɨr mɨtɨk niuk mɨrak Ananaias kan kewis his menterik te hɨrak pɨke kakɨr ein ein.” ");
INSERT INTO avt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias pɨke ketpim, “Mɨtɨk Iuwe, mɨt yapɨrwe netpo me mɨtɨk ik e menmen enum yapɨrwe hɨrak kɨrɨakem me mɨt nises hɨm mi neit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Hɨrak epei kan in ketenen tɨwei ke mɨt iuwe pris, hɨr natɨp hɨram yaaim te hɨrak kakɨthis mɨt miyapɨr neimɨn newenɨpi niuk mit.” ");
INSERT INTO avt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Hɨrak Mɨtɨk Iuwe Krais ketpɨwek kar ik: “Ti eno kerekek hentar hi epei ehimɨtanek kakwepyapɨr hɨm mai kaktɨp mɨt ap ne weiwɨk me Isrel em, hɨr netike mɨt iuwe nɨr netike mɨt han ne weiwɨk me Isrel. ");
INSERT INTO avt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Hi hɨrekes tewen eteiknɨwek mekam mamnen mamkɨp kakɨntar hɨrak kaktɨp mɨt miyapɨr hɨm mai.” ");
INSERT INTO avt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mɨtɨk Iuwe katɨp epei au, Ananaias ken wɨnak ke Sol kewik, hɨrak kewis his menterik ketpɨwek kar ik: “Kai yinak Sol, Mɨtɨk Iuwe Jisas kerek keweputyapɨr hɨrekes keit yayiwe te ti hɨrek, hɨrak hɨrekes keriuweta hi han. Hɨrak keriuweta te hi ekepit ti pɨke ehɨr ein ein, God Hɨmɨn Yaaik kaku kakɨkre han kit.” ");
INSERT INTO avt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hɨrak katɨp epei au, menmen mɨre saauk hɨar mekre nanamɨr kɨrak mɨnatɨn, te Sol pɨke kɨr ein ein. Hɨrak kekrit ken, Ananaias kɨkɨrek. ");
INSERT INTO avt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Epei au, hɨrak kaam menmen hɨrak pɨke manpenuk keit. ");
INSERT INTO avt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sol hɨrak kepu ketike mɨt han nises hɨm me God neit Damaskas me wɨ ham. Waswas hɨrak ken wɨnak ke mɨt ne weiwɨk me Isrel hɨr nau nererik nekine hɨm me Moses, hɨrak kewepyapɨr hɨm me Jisas katɨp mɨt hɨrak Nɨkan ke God. ");
INSERT INTO avt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mɨt nemtau hɨm mɨrak hɨr han kekrit natɨpan nar ik: “Mɨtɨk ik kerekek hɨrak keit Jerusalem kenep mɨt kerek nises hɨm me Jisas a? Hɨrak kan in te kakɨthis mɨt kerek newenɨpi niuk mɨrak kakriyei kakri kakno kakwet mɨt iuwe pris en?” ");
INSERT INTO avt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol keriuwe hɨm iuwe hɨrak ketpim kari han ke mɨt yapɨrwe keteiknor Jisas hɨrak Mɨtɨk Iuwe Krais kerek God nɨpaa kehimɨtanek te hɨr mɨt ne weiwɨk me Isrel nau Damaskas hɨr ap nemɨnp hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wɨ yapɨrwe epei men, mɨt han ne weiwɨk me Isrel nau en nererik natɨpan nimenɨpɨn Sol nankɨp te ");
INSERT INTO avt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mɨt han netpɨwek menmen hɨr nanrɨakem. Wɨtaan wanewik hekrit hekrit hɨr nerp ya weipɨr ke wit Damaskas nekiwɨwek hɨr nankɨp. ");
INSERT INTO avt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Au, wɨtaan hak mɨt kerek nises hɨm mɨrak me Jisas hɨr netɨwekhis newisɨk kekre wɨpo wɨsenuk hɨr nɨkaaip waai nɨnaiwɨrek ken kekre hei ke han iuwe keit wit eik keweikɨn wit Damaskas kekiuwe kerp tɨ hɨrak kɨrɨr. ");
INSERT INTO avt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol kɨnaaiwɨr Damaskas epei ken wit Jerusalem, hɨrak kare kaku kaktike mɨt en nises hɨm me Krais. Au, hɨr ap nemtau hɨm mɨrak. Hɨr nɨneinɨk nentar hɨr han kitet hɨrak ap kises hɨm me Krais. Hɨr han kitet hɨrak kan kemipɨn kakwenaani kakɨr neimɨn hɨr nises Krais hɨrak kakwisi nanɨno wɨnak enuk. ");
INSERT INTO avt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hɨr nɨneinɨk te mɨtɨk Banabas ketɨwekhis keriyaak keiyɨk ken mɨt aposel ketpor Sol kitet yayiwe hɨrak kɨr Mɨtɨk Iuwe Jisas, hɨrak ketpɨwek menmen. Hɨrak wen ketpor Sol katɨp mɨt hɨm me Krais ketpor hɨm manp keit wit Damaskas. ");
INSERT INTO avt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hɨrak ketpor epei au, hɨr newis Sol kau ketikeri te hɨrak ken kɨr ein ein keit Jerusalem katɨp hɨm iuwe ketpor hɨm me Jisas. Hɨrak ap kɨnapen au. ");
INSERT INTO avt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hɨrak ketike mɨt ne weiwɨk me Isrel kerek hɨr nertei hɨm Grik, hɨr natɨpan nenehan me Jisas te hɨr nererik nimenɨpɨnek nankɨp. ");
INSERT INTO avt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wɨ kerek mɨt nises hɨm me Jisas ein nemtewek, hɨr neithis Sol neriuwetek kekiuwe ken wit Sisaria newisɨk kau sip neriuwetek ken nɨrak en wit Tasas. ");
INSERT INTO avt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Me wɨ im mɨt ap nenep mɨt nises hɨm yaaim me Jisas te hɨr mɨt yapɨrwe nau neit provins Judia, Galili ketike Sameria hɨr nau werek werek. God Hɨmɨn Yaaik kekepi hɨr nɨnakɨn tokim hɨr nari mɨt han nises hɨm me Jisas Krais hɨr han kitet hɨrak yaaik. ");
INSERT INTO avt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita keke tɨ ken kerer wit wit. Wɨ ham hɨrak ken kɨr mɨt nises hɨm me God neit wit Lida. ");
INSERT INTO avt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Hɨrak ken kɨr mɨt neit wit Lida, hɨrak kɨr mɨtɨk niuk mɨrak Inias. Mɨtɨk ik kɨwaai yeno me tito hispɨnak wikak (8) kentar his hɨt maa te hɨrak ap kekrit au. ");
INSERT INTO avt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ketpɨwek kar ik: “Inias, Jisas kenipit ti hɨre yaaik. Ekrit ewen laplap ewisɨm emɨntar yeno.” Hɨrak katɨp epei au, mɨtɨk kekrit waswas. ");
INSERT INTO avt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mɨt yapɨrwe nau wit Lida kekite wit iuwe Seron nɨrek hɨrak kɨre yaaik te hɨr neweikɨn sip newet menmen enum nises Mɨtɨk Iuwe Jisas. ");
INSERT INTO avt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mɨte piutɨp niuk mɨre Tabita wepu wit Jopa. Me hɨm Grik hɨr mɨt nenewe Dokas. Hekrit hekrit hɨre wɨrɨak menmen yaaim hɨre wɨkaap mɨt enun menmen auri, hɨre wises hɨm me God. ");
INSERT INTO avt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Me wɨ Pita kepu wit Lida, mɨte ip wɨnap hɨre waa. Mɨt miyapɨr han en nises menmen me maamrer nɨr hɨr nɨkɨr yɨnk kɨre newisiye wɨwaai wekre haau mau wɨnak kau niu. ");
INSERT INTO avt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Wit Lida hɨrak menep kɨrapɨt wit Jopa te mɨt nises hɨm me God neit ein nemtau mɨt natɨp Pita kepu Lida, te hɨr nesiuwe mɨtɨkɨt wik ten tetpɨwek tar ik: “Ti etikawɨr euno wit kawɨr waswas.” ");
INSERT INTO avt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hɨrakɨt tatɨp epei au, Pita kekrit ketikeret ten. Hɨrakɨt ten tiun wɨnak eik, hɨr neriyaak ken haau kau niu ein. Miyapɨr yapɨrwe kerek mɨkaan nɨr epei naa, hɨr nerp en nɨkɨtep. Hɨr nɨr Pita epei kan, te hɨr nan neweiknɨwek neteiknɨwek menmen nɨpaa me wɨ hɨre wepu Dokas wekerwo laplap wewet mɨt miyapɨr em neriuwetem. ");
INSERT INTO avt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita keriuweti nen witeik, hɨrak kitehɨr kewen ninɨp kitehi God me hɨre. Epei au, hɨrak kerenaan katɨp herwe yɨnk kɨre kar ik: “Tabita ti ekrit.” Hɨrak katɨp epei au, hɨre wesiupan naan. Hɨre wesiupan naan wɨr Pita, te hɨre wekrit wau yeno. ");
INSERT INTO avt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Hɨre wekrit wau yeno, Pita kɨkɨa hɨre wekrit werp, hɨrak kenɨne miyapɨr mɨt nɨr epei naa nɨpaa ein, hɨr netike mɨt han en nises hɨm me God kewetɨr mɨte ip pɨke wan. ");
INSERT INTO avt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mɨt yapɨrwe neit Jopa nemtau hɨm im te hɨr nises hɨm yaaim me Mɨtɨk Iuwe Krais. ");
INSERT INTO avt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita kepu wɨ yapɨrwe kau wɨnak ke Mɨtɨk itai kɨrak Saimon kerek kenip yɨnk me samiyak yaaim me yerkesi. ");
INSERT INTO avt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mɨtɨk hak niuk mɨrak Konilias kepu wit Sisaria. Hɨrak mɨtɨk iuwe ke Ami, hɨrak kinɨn naanmɨpre 100 mɨt soldia ne ami ne wit iuwe Itali keit yanɨmɨn. ");
INSERT INTO avt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hɨrak mɨtɨk ik ketike mɨt nau wɨnak kɨrak hɨr han kitet God hɨrak iuwe te hɨr newenɨpiyek. Hekrit hekrit hɨrak kitehi God menmen, hɨrak keit pewek kewet mɨt ne Isrel kerek enun menmen auri kewetɨrem. ");
INSERT INTO avt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wɨ ham menep hɨnkewɨ hɨrak kepu kɨtyak kɨr ensel kerekek ke God kan ketpɨwek kar ik: “Konilias.” ");
INSERT INTO avt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hɨrak Konilias kɨrapɨrwek kepɨrpɨr kitɨwekhi, “Mekam mɨtɨk iuwe?” Ensel ketpɨwek kar ik: “God han kitetit ti hitɨwekhi hekrit hekrit ti ewet mɨt enun si enuni pewek herekyor yaaim. ");
INSERT INTO avt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Te in ek ti esiuwe mɨt han nanɨno wit Jopa hɨr nanɨnantɨn mɨtɨk kerekek niuk mɨrak Saimon. Niuk mɨrak ham hɨrak Pita. ");
INSERT INTO avt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hɨrak kau wɨnak ke itai kɨrak Saimon, kerek kenip yɨnk me samiyak, hɨrak wɨnak kɨrak kɨwaai tenhaan menep wan eik. Hɨrak kakɨtput menmen te yi eiyisesim.” ");
INSERT INTO avt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ensel ketpɨwek epei au, hɨrak ken. Hɨrak ken, Konilias kenɨne mɨtɨkɨt wik tɨrɨak menmen mɨrak tekite mɨtɨk ke ami kiutɨpen. Mɨtɨk ke ami kewenɨpi niuk me God, hɨrak hekrit hekrit kau ketike Konilias naanmɨpre menmen mɨrak me ami. ");
INSERT INTO avt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hɨrak ketpɨwekɨt menmen hɨrak epei kɨrem. Hɨrak ketpɨwekɨtem epei au, hɨrak kesiuweret ten wit Jopa. ");
INSERT INTO avt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Hɨrak kesiuweret ten, wɨtaan hɨrakɨt tɨwaai ya ke nɨmɨn. Wanewik hɨrakɨt tekrit tepno menep wit Jopa. Menep me wepni nɨmɨn iuwe Pita kɨniu ken kau wɨnak siup kerek kɨpɨrak ken kitehi God menmen. ");
INSERT INTO avt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hɨrak Pita kitehi God menmen, hɨrak nɨnpɨ maak hɨrak han kitet kakɨm menmen, hɨrak wen kemeriyor hɨr wen nɨam mɨwaai si. Hɨrak kepu en hɨrak kepu kɨtyak, ");
INSERT INTO avt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","kɨr nepni mewep menmen mɨre laplap mɨt nɨkaaip waai mewim men pɨnak men pɨnak, men yinak, men yinak, hɨram mekiuwe man menep tɨ. ");
INSERT INTO avt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Menmen yapɨrwe mau mekrerem. Samiyak, manpen, pewen, kɨrin metike hore yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hɨrak kɨrem, hɨrak kemtau mɨtɨk ketpɨwek kar ik: “Pita ekrit emɨp ehɨm.” ");
INSERT INTO avt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Au, Pita ketpɨwek kar ik: “Auye! Hi nɨpaa ere in ap haam menmen im hɨm me Moses mau tɨwei meriuwesɨsem mar ik: ‘Yi mɨt ne Isrel ap eiyɨm samiyak im au emɨt.’” ");
INSERT INTO avt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hɨrak mɨtɨk ketpɨwek kar ik: “Menmen God katɨp hɨram yaaim ti ap etɨp hɨram enum au emɨt.” ");
INSERT INTO avt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Menmen im man mar wikak. Epei au, menmen mɨre laplap pɨke mɨniu men nepni eim. ");
INSERT INTO avt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Hɨram mɨniu men nepni eim, Pita han kitet kar ik: “Menmen im meteikno mekam?” Pita han kitetim, mɨtɨkɨt kerek Konilias nɨpaa keriuwetet tɨpiun Jopa titehi mɨt ere tɨnapɨn wɨnak ke mɨtɨk Saimon, hɨrakɨt terp ya weipɨr ke nɨwa meweikɨn wɨnak eik e. ");
INSERT INTO avt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hɨrakɨt tenɨne titehi tar ik: “Mɨtɨk kiutɨp niuk mɨrak Saimon Pita kau in o au?” ");
INSERT INTO avt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita han kitet menmen hɨrak epei kɨrem, God Hɨmɨn Yaaik ketpɨwek kar ik: “Nɨkɨp emnep emtewek! Mɨtɨkɨt wikak epei tan tɨntetnut, ");
INSERT INTO avt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","te ti ekrit ekiuwe eno etikeret eino. Ti ap enapen han ekitet menmen au emɨt. Hi epei heriuwetet tan.” ");
INSERT INTO avt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hɨrak katɨp epei au, Pita kekiuwe ken kɨr mɨtɨkɨt kerek Konilias keriuwetet tan in, hɨrak ketpɨwekɨt kar ik: “Hi mɨtɨk yi yɨnyetno. Yenmak te yi yan?” ");
INSERT INTO avt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hɨrakɨt tetpɨwek tar ik: “Mɨtɨk iuwe kinɨn naanmɨpre 100 mɨt ne ami keriuwetei haiu man in. Hɨrak mɨtɨk yaaik han kitet God iuwe hɨrak kisesik, mɨt ne weiwɨk me Isrel hɨr natɨp: ‘Hɨrak yaaik,’ mɨtɨk ik God kesiuwe ensel kɨrak ketpɨwek hɨrak kakriuwet mɨt han nanɨno nantuthis ti enen wɨnak kɨrak ti etpɨwek menmen.” ");
INSERT INTO avt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hɨrakɨt tatɨp epei au, Pita keriyei keri kan wɨnak nɨmɨn en, hɨrakɨt tɨwaai en me wɨtaan. Wanewik hɨrak kekrit ketike mɨt han ne wit Jopa hɨr nises hɨm me God, hɨr netikeret nen. ");
INSERT INTO avt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Hɨr netikeret nen ere wɨtaan, hɨr nɨwaai. Wanewik hɨr nekrit nen. Me wɨ im hɨr nɨpiun Sisaria kerek Konilias kemerɨr Pita. Hɨrak epei kari nei ne weiwɨk miutɨp mɨrak, netike nɨrak yinan han hɨr nau wɨnak. ");
INSERT INTO avt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ketikeri nare nanɨno nɨmɨn en, Konilias kewenyipɨrek keit ya weipɨr ke wɨnak kenke kewen ninɨp kitehɨr menep hɨt mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Au, Pita kenipek hɨrak kekrit, ketpɨwek kar ik: “Ti ekrit hentar hi ap God au. Hi mɨtɨk har ke ti kerekek.” ");
INSERT INTO avt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita ketike Konilias tewepnak ten nɨmɨn en, Pita kɨr mɨt yapɨrwe nererik nau en. ");
INSERT INTO avt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Hɨrak kɨr mɨt nau en, hɨrak ketpor kar ik: “Yi mɨt hɨras yi yertei werek hɨm haiu mɨt ne Isrel misesim hɨram meriuwesɨsai mamu wɨnak ke mɨt ap ne weiwɨk me Isrel mamɨm menmen mamtikeri au emɨt. Te God epei keteikno hi ap han ekitet mɨtɨk hak enuk kentar hɨrak ap ke weiwɨk me Isrel au. ");
INSERT INTO avt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wɨ kerek yi yeriuwet mɨtɨkɨt tan tetauhis, hi ap hatɨp au. Hi han kerekek. In ek hi hitihi te yi yenmak yi yeriuwet mɨtɨkɨt tan tetauhis te hi han in?” ");
INSERT INTO avt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilias katɨp kar ik: “Mar ke petepin ti han in, nɨpaseik wɨ tekyaait (4) hi heit wɨnak kai hi hitehi God menmen ere menep hɨnkewɨ. Hi wen hepu in, hi hɨr mɨtɨk kiutɨp keriuwet klos merhɨhe kerp ninaan mai. ");
INSERT INTO avt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hɨrak ketpo kar ik: ‘Konilias, God kemtau hɨm mit ti hitɨwekhi menmen. Hɨrak han kitet menmen yaaim ti hɨrɨak mɨt enun si enuni em. ");
INSERT INTO avt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ti eriuwet mɨt han nanɨno wit Jopa nanɨnantɨn mɨtɨk niuk mɨrak Saimon Pita. Hɨrak kau wɨnak ke mɨtɨk Saimon kerek kenip yɨnk me samiyak yaaim meyerkesi, hɨrak wɨnak kɨrak kɨwaai tenhaan menep wan eik.’ ");
INSERT INTO avt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hi epei hemtewek, waswas hi heriuwet mɨtɨkɨt wik ten tɨntetnut tetuthis terit tan. Ti mɨtɨk yaaik te ti etikeret epei yan in. Tɨs, God kau ketikewai haiu mererik te haiu mamɨmtau menmen God ketput ti ewepyapɨrem etpaiyem.” ");
INSERT INTO avt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Konilias katɨp Pita epei au, Pita ketpor kar ik: “Hi hetpi werek. In ek hi hertei God hɨrak han kitet mɨt miyapɨr yapɨrwe nɨpɨran kerekyor menmen miutɨp. ");
INSERT INTO avt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Weiwɨk miutɨp keremem au. God han yaaik keriuwe mɨt nerer wit wit kerek newenɨpiyek nɨrɨak menmen yaaim nisesik. ");
INSERT INTO avt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yi yertei hɨm God kewet haiu mɨt haiu nepenyerer ne Isrel kewetaiyem. God kewepyapɨr hɨm yaaim katɨp haiu mamtikerek emu han kiutɨp mamɨntar Jisas Krais. Hɨrak Mɨtɨk Iuwe kinɨn naanmɨpre mɨt yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yi yertei nɨpaa Jon katɨp mɨt menmen ketpor hɨr enweikɨn sip enwet menmen enum, hɨrak kɨkɨri. Hɨrak kɨkɨri epei au, Jisas kewepyapɨr hɨm me God mekrit minɨn meit Galili men merer wit wit meit Isrel. ");
INSERT INTO avt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yi yertei Jisas ke wit Nasaret. God kehimɨtanek kewetɨwek Hɨmɨn Yaaik kɨrak ken kewik kewetɨwek menmen iuwe mɨrak kakɨkepik. Hɨrak ken kerer wit wit kɨrɨak menmen yaaim me mɨt, kɨkaap mɨt kerek Seten kewɨr menmen mɨrak enum menteri, kekepi hɨr nɨre yaain kentar God kau ketikerek kekepik. ");
INSERT INTO avt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Haiu mɨt aposel mewepyapɨr menmen yapɨrwe hɨrak kɨrɨakem kerer wit wit ke Isrel, mekite wit iuwe Jerusalem. Mɨt iuwe ninɨn naanmɨpre wit Isrel hɨr netɨwekhis neiyɨk nen nakɨp newenkekik kau nu tentarakɨt hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Au, me wɨ wikak hekrit enum eik, God kɨkɨak hɨrak kekrit kepu hɨrak kewepyapɨr hɨrekes. ");
INSERT INTO avt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mɨt yapɨrwe au. Haiu mɨt aposel kerek nɨpaa God kehimɨtenai haiu mewepyapɨr menmen mɨrak. Hɨrak kekrit kepu haiu maam tɨpar menmen metikerek. ");
INSERT INTO avt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Hɨrak ketpai hɨm manp te haiu mamno mamwepyapɨr hɨrak mɨtɨk God kehimɨtanek hɨrak skelim mɨt nɨpaa naa, mɨt wen nepu. ");
INSERT INTO avt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mɨt profet yapɨrwe nɨpaa newis hɨm mekre tɨwei mewepyapɨr hɨm me mɨtɨk ik. Hɨr natɨp mɨt miyapɨr kerek nisesik, God kakɨsak menmen enum hɨr nɨrɨakem kakɨntar menmen yaaim Jisas kerekyaiyem.” ");
INSERT INTO avt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita wen ketpor hɨm mɨrak, God Hɨmɨn Yaaik kan kau han ke mɨt miyapɨr kerek nemtau hɨm Pita ketporem. ");
INSERT INTO avt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mɨt ne weiwɨk me Isrel, kerek nises hɨm me God nan netike Pita, hɨr nehɨnhɨn natɨp nar ik: “God epei kesiuwe Hɨmɨn kɨrak Yaaik kan kau haiu mɨt ketike mɨt in kerek ap ne weiwɨk me Isrel.” ");
INSERT INTO avt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hɨr natɨp menmen ik nentar hɨr epei nemtau mɨt in natɨp hɨm ham hɨr hɨras nepɨtariyem newenɨpi niuk me God hɨrak iuwe neriuwe hɨm im. Pita katɨp hɨm iuwe kar ik: ");
INSERT INTO avt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“God Hɨmɨn Yaaik kan kau han ke mɨt in kar ke nɨpaa hɨrak kan kau haiu mɨt. Keimɨn kaktɨp te mɨt in ap haiu mamkɨri mamriuwe tɨpar au a? Auye!” ");
INSERT INTO avt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hɨrak katɨp epei au, hɨrak ketpor hɨr nɨkɨri neriuwe tɨpar nekine niuk me Jisas. Hɨr nɨkɨri epei au, hɨr mɨt en nitɨwekhi hɨrak kau ketikeri me wɨ ham. ");
INSERT INTO avt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mɨt aposel netike mɨt kerek nises hɨm me God neit provins Judia nemtau mɨt ap ne weiwɨk me Isrel epei nises hɨm yaaim me God. ");
INSERT INTO avt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ewaai meruri Pita pɨke kan wit Jerusalem, mɨt kerek natɨp mɨt nises hɨm me God nerekir yɨnk kɨr hɨr nitɨwekhi nenerek ");
INSERT INTO avt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","natɨp nar ik: “Ti henmak te ti hau hetike mɨt ap ne weiwɨk me Isrel, yi yekiyan yaam menmen? Hɨram au emɨt.” ");
INSERT INTO avt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Au, Pita kewepyapɨr ketpor menmen yapɨrwe epei man kerek God kɨrɨak Konilias em. ");
INSERT INTO avt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Hɨrak katɨp kar ik: “Hi hepu wit Jopa, hi hepu ein hi hitehi God menmen, au hi hɨtyak hɨr menmen mɨre laplap mekiuwe man, hɨr newɨr waai neriyaam nen yinak nen yinak, nen pɨnak nen pɨnak mekiuwe man merp menep hi herpai. ");
INSERT INTO avt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Te hi hɨr samiyak, manpen, pewen, kɨrin metike hore mei me yaank mekrerem. ");
INSERT INTO avt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hi hɨr samiyak mekrerem, hi hemtau mɨtɨk ketpo kar ik: ‘Pita ti ekrit enep mei ehɨm.’ ");
INSERT INTO avt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Hi hewenhi har ik: ‘Mɨtɨk iuwe auye. Nɨpaa ere in hi ap haam menmen im kerek hɨm me Moses meriuwesɨsim mar im: Yi mɨt ne Isrel ap eiyɨm samiyak im.’ ");
INSERT INTO avt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mɨtɨk keit nepni pɨke ketpo kar ik: ‘Menmen God katɨp hɨram mɨre yaaim, ti ap etɨp hɨram enum au emɨt.’ ");
INSERT INTO avt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Menmen man marim ere mar wikak, te hɨram pɨke mɨniu men nepni. ");
INSERT INTO avt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Hɨram pɨke men nepni, mɨtɨkɨt wikak kerek mɨtɨk ke Sisaria keriuwetet, hɨrakɨt ten terp wɨnak hi hewik. ");
INSERT INTO avt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","God Hɨmɨn Yaaik ketpo hi ap han ekitet menmen au. Hi eno etikeret kerekek. Mɨtɨkɨt hispɨnak kiutɨp (6) terp in tetikewa hɨrakɨt tetikewa mariyan men wit Sisaria haiu men mekre wɨnak ke mɨtɨk Konilias. Haiu men wɨnak ke mɨtɨk Konilias, ");
INSERT INTO avt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","hɨrak ketpai hɨrak kɨr ensel kerp wɨnak kɨrak ketpɨwek kar ik: ‘Ti esiuwe mɨtɨk kakno wit Jopa kakɨnkatɨn mɨtɨk niuk mɨrak Saimon Pita. ");
INSERT INTO avt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hɨrak kaknen kaktɨp hɨm mamkaap ti etike mɨt miyapɨr nau wɨnak ki yi eiyises hɨm me God te maain God kaktihis.’ ");
INSERT INTO avt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Hi han kekrit hare etpor menmen, au God Hɨmɨn Yaaik kan kau kekre han kɨr kar nɨpaa kan kau haiu mɨt in. ");
INSERT INTO avt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hɨrak kan kewi, hi han kitet hɨm nɨpaa Mɨtɨk Iuwe Krais katɨp. Hɨrak katɨp kar ik: ‘Jon kɨkɨr mɨt keriuwe tɨpar te hi tewen esiuwe God Hɨmɨn Yaaik kaknen kaku yi mɨt.’ ");
INSERT INTO avt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Haiu mertei nɨpaa haiu mises hɨm me Mɨtɨk Iuwe Jisas Krais, hɨrak kesiuwe Hɨmɨn kɨrak yaaik. In ek God epei kewet mɨt ap ne weiwɨk me Isrel menmen yaaik ik nɨpaa hɨrak kewetaiyem. Hi keimɨn te hi hatɨp God ekɨt? Taauye!” ");
INSERT INTO avt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mɨt en nemtau hɨm Pita ketpim, hɨr ap wen nenerek au. Hɨr newenɨpi niuk me God natɨp nar ik: “God epei kewis mɨt ap ne weiwɨk me Isrel hɨr nanweikɨn sip nanwet menmen enum te hɨr nanu nanɨt nantikerek nanɨr ke haiu mɨt in.” ");
INSERT INTO avt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Me wɨ mɨt nenep mɨtɨk Stiven hɨrak kaa, mɨt nanɨwaank mɨt miyapɨr kerek nises hɨm me God. Au, hɨr nɨrɨr. Han nɨrɨr nen menep, han au nen yanɨmɨn ere hɨr niun wit Finisia, wit Saipras, wit Antiok natɨp mɨt ne Isrel nau en keriyen hɨm yaaim me Krais. ");
INSERT INTO avt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mɨt han kerek nises hɨm me God hɨr ne wit Saipras ketike provins Sairini, hɨr nen wit Antiok newepyapɨr hɨm yaaim me Mɨtɨk Iuwe Jisas, hɨr natɨp mɨt ne Isrel netike mɨt ap nei ne Isrel netporem. ");
INSERT INTO avt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mɨtɨk Iuwe God kekepi te mɨt yapɨrwe nemtau hɨm neweikɨn sip newet menmen enum hɨr nises Mɨtɨk Iuwe Krais. ");
INSERT INTO avt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mɨt ne weiwɨk me God neit Jerusalem nemtau hɨm me menmen im epei man, te hɨr nesiuwe Banabas ken wit Antiok kɨr menmen. ");
INSERT INTO avt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hɨrak ken kɨri, hɨrak kɨr God kerekyor yaaim, hɨrak han yaaik keriuweri hɨrak ketpor hɨm manp te hɨr wen enises Mɨtɨk Iuwe ekɨkre han kɨr iuwe. ");
INSERT INTO avt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas hɨrak mɨtɨk yaaik, God Hɨmɨn Yaaik kau kekre han kɨrak iuwe, hɨrak kises God werek werek, te mɨt yapɨrwe nises hɨm me Mɨtɨk Iuwe Krais. ");
INSERT INTO avt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mɨt yapɨrwe nises hɨm me Krais te Banabas ken wit Tasas kɨnkatɨn Sol. ");
INSERT INTO avt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hɨrak kɨnkatɨn Sol ere kɨnapɨnek keriyaak pɨke keiyɨk ken wit Antiok, hɨrak pɨke ken wit Antiok kau en tito kiutɨp, hɨrakɨt tau en tekite mɨt ne weiwɨk me God teteikɨn mɨt yapɨrwe menmen, tetpor hɨm me God. Hɨr neit wit ik e, mɨt han ninɨn nekine niuk me mɨt nises hɨm me Krais, hɨr mɨt Kristen. ");
INSERT INTO avt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Me wɨ im, mɨt han profet kerek newepyapɨr hɨm me God, nɨnaaiwɨr wit Jerusalem nekiuwe nen wit Antiok. ");
INSERT INTO avt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mɨt nan nererik nemtau hɨm me God, mɨtɨk kiutɨp ke mɨt in niuk mɨrak Agabas hɨrak kekrit kerp nɨmɨn hɨr mɨt nau nererik en, God Hɨmɨn Yaaik ketpɨwek te hɨrak kewepyapɨr menmen im: Maain wɨ mamnen te hawɨ ap kaknen kakrer wit wit au, menmen mamu ni ap mamwo au mami. (Menmen im epei man me wɨ mɨtɨk iuwe gavman ke Rom Klodias hɨrak kinɨn naanmɨpre mɨt.) ");
INSERT INTO avt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mɨt nises hɨm me God en han kitet hɨr niutɨp niutɨp nenke pewek mɨr nanɨsiuwerem mamno wit Judia kerek hawɨ ap kan keit ein menmen me ni ap mewo au. Hɨram maa. ");
INSERT INTO avt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hɨr nenkerem nemaniyem, hɨr newet Banabas ketike Sol pewek im hɨrakɨt teiyɨm ten tewet mɨt iuwe ninɨn naanmɨpre mɨt ne God neit Jerusalem, tewetɨrem. ");
INSERT INTO avt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Me wɨ im mɨtɨk iuwe gavman King Herot kinɨn naanmɨpre mɨt neit Isrel, hɨrak kewaank mɨt han ne weiwɨk me God. ");
INSERT INTO avt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Hɨrak keithis Jems, Jon nɨkik kɨrak, katɨp mɨt ne ami nɨrak hɨr nerekir teruk kɨrak kewen keket. ");
INSERT INTO avt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hɨrak kaa, hɨrak Herot kertei mɨt ne Isrel han yaaik neriuwe menmen hɨrak epei kɨrɨakem, hɨrak wen kɨrɨak menmen enum. Hɨrak keithis Pita kewisɨk kekre wɨnak enuk me wɨ mɨt nererik han tewenɨn menmen, hɨr naam bret yis mekrerem au. ");
INSERT INTO avt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hɨrak kewis Pita kekre wɨnak enuk, mɨt ne ami naanmɨprewek. Hɨr mɨt nar 16 hɨr nenkehan nɨre tekyaait tekyaait (4) naanmɨpre Pita wɨtaan wanewik wɨtaan wanewik. Herot han kitet wɨ mɨt nererik han tewenɨn menmen hɨr naam menmen epei au, hɨrak kaksiupanek kakno witeik mɨt yapɨrwe nanɨrek hɨr nantɨp nare nankɨp. ");
INSERT INTO avt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mɨt ne ami wen naanmɨpre Pita, te mɨt miyapɨr yapɨrwe ne weiwɨk me God hɨr nitehi God iuwe te kakɨkepik. ");
INSERT INTO avt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wɨtaan wɨ miutɨp mɨtɨk King Herot kaknen kakɨthis Pita kakno wit mɨt yapɨrwe nanɨrek nankɨp, me wɨtaan ik Pita kɨwaai kekre mɨtɨkɨt wik te ami ketɨn ke nɨmɨn, hɨr newis sen me ain wik mewik, mari hispɨnam me ami ek, pɨnam mari ami ek. Mɨt ami han naanmɨpre ya weipɨr ke wɨnak enuk eik e. ");
INSERT INTO avt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Hɨr naanmɨpre ya weipɨr, ensel ke God kerp en kɨre si merhɨhe meit haau ek. Hɨrak mɨtɨk ensel kewis his mau yapɨr ke Pita kekotɨtek ketpɨwek kar ik: “Ti ekrit waswas.” Hɨrak epei ketpim, sen menke mɨnaaiwɨr his mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Hɨram mɨnaaiwɨr his mɨrak, Ensel pɨke ketpɨwek kar ik: “Ti enke klos mit tokim eriuwet su mit.” Pita kɨrɨakem epei au, ensel ketpɨwek kar ik: “Ti eriuwet saket kit ti eisɨsa enen.” ");
INSERT INTO avt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita kisesik kɨnaaiwɨr wɨnak enuk ken wit eik. Hɨrak kepɨtari menmen ensel kɨrɨakem hɨram werek o au. Hɨrak han kitet hɨrak kɨwaai kɨtyak. ");
INSERT INTO avt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hɨrakɨt tɨnaaiwɨr weipɨr ke han ke nɨmɨn. Epei au, hɨrakɨt tɨnaaiwɨr weipɨr ke han ke wit eik ere tiun weipɨr wɨsenuk ke ain ke nɨwa kɨkaisiu ke wit Jerusalem. Weipɨr eik au tokik keit te hɨrekes kɨkaisiu, hɨrakɨt ten wit eik. Hɨrakɨt tekiuwe ya, ensel keweikɨnhis kɨre nɨme kɨnaiwɨrek, ");
INSERT INTO avt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ensel kɨnaaiwɨr Pita, hɨrak kertei mekam epei man te hɨrak katɨp kar ik: “Hi hertei werek. God kesiuwe ensel kɨrak ketauhis keriya hi hɨnaaiwɨr menmen Herot ketike mɨt ne Isrel han kitet nanrekyewem.” ");
INSERT INTO avt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hɨrak han kitet menmen im ere werek, hɨrak ken wɨnak ke Maria, miye pe mɨtɨk Jon Mak, mɨt yapɨrwe nererik neit ein hɨr nitehi God me Pita. ");
INSERT INTO avt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita kan kerp weipɨr ke wɨnak keit witeik keretɨt weipɨr keket teruk. Mɨte niuk mɨre Roda hɨre wɨrɨak menmen weit pewek im au, hɨre wan wawɨr keimɨn keretɨt weipɨr keket teruk. ");
INSERT INTO avt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hɨre wen menep witehi war ik: “Ti keimɨn?” Hɨrak kekɨke tonɨk mekre nɨkɨp mɨre hɨre wertei hɨrak Pita. Hɨre wertei hɨrak Pita, hɨre han yaaik wesiuknen wen ein wɨkaisiu weipɨr au, watɨp mɨt en war ik: “Pita kerp witeik.” ");
INSERT INTO avt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hɨr newenuwehi nar ik: “Ti hetaritari.” Au, hɨre weptɨp yapɨrwe war ik: “Hɨrak kerp witeik.” Hɨr natɨp nar ik: “Au, hɨrak au, hɨmɨn kɨrak kerekek.” ");
INSERT INTO avt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hɨr wen natɨpan, Pita wen keretɨt weipɨr te hɨr nare nanɨno nanɨrek. Hɨr nɨkaisiu weipɨr nɨrek hɨr nehɨnhɨn. ");
INSERT INTO avt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Hɨr nehɨnhɨn nesike yaanmi, Pita kɨkɨam his kesiyor hɨrak katɨp kar ik: “Yi eikintɨp.” Epei au, hɨrak ketpor karkeik Mɨtɨk Iuwe God ketɨwekhis keriyaak kan kɨnaaipɨs wɨnak enuk ke gavman. Hɨrak ketpor menmen im epei au, hɨrak ketpor kar ik: “Yi eino eitɨp Jems ketike naiu yinan han hɨm im hi epei hetpiyem.” Hɨrak ketpor epei au, hɨrak kɨnaaiwɨr wit ik kɨrɨr ken wit hak kɨsawɨn kau en. ");
INSERT INTO avt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Maain wanewik epei man, mɨt ne ami neit wɨnak enuk hɨr nekrit han enuk wɨsenuk hɨr natɨp nitehiyan nar ik: “Pita ken neiyɨn?” ");
INSERT INTO avt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mɨtɨk iuwe King Herot kesiuwe mɨt ne ami han hɨr nɨnetnɨwek nɨetnɨwek au. Hɨr nɨnetnɨwek au, Herot kitehi mɨt kerek naanmɨpre Pita hɨr nepɨtari menmen te hɨrak han enuk katɨp mɨt ne ami han nantorhis neriyei neri nanɨno nanɨnɨp nani. Epei au, Herot kɨnaaiwɨr provins Judia kekiuwe ken wit Sisaria. ");
INSERT INTO avt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mɨtɨk iuwe King Herot kepu wit Sisaria, hɨrak han enuk keriuwe mɨt ne wit Taia ketike wit Saidon. Hɨr nerteiyek in ek hɨrak kaknen te hɨr mɨt han nan nererik nen nanɨr King Herot. Hɨr nɨpiun ein, hɨr ninɨn natɨp mɨtɨk niuk mɨrak Blastas kerek naanmɨpre menmen me wɨnak ke King Herot, hɨr netpɨwek menmen hɨr hanhan menmen me nɨpaa hɨr netike King Herot han enuk neriuwehan hɨram nepei werek emɨt. Hɨr netpɨwek epei au, hɨr nen nɨr King Herot nitɨwekhi enkiyan enu enɨt nentar hɨr neit menmen me wit King Herot naanmɨprewem. ");
INSERT INTO avt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Me wɨ hɨrak nepei kɨmat, mɨtɨk iuwe Herot keriuwet laplap me mɨtɨk iuwe hɨrak keiyɨm kakɨr mɨt, hɨrak kan kau yeno mɨrak me gavman katɨp mɨt hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Hɨrak katɨp epei au, mɨt hɨr nɨnap natɨp nar ik: “Hɨrak katɨp kɨpre God kerekek. Kɨre mɨtɨk au. ");
INSERT INTO avt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wasenum hɨrak mɨtɨk ensel ke God kenip Herot hɨrak kɨnap kentar hɨrak ap keweni ketpor, “Hi God au, hi mɨtɨk kerekek.” Henek mɨre pɨnike maak tu kɨrak te hɨrak kaa. ");
INSERT INTO avt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Te mɨt miyapɨr yapɨrwe nerer wit wit nemtau hɨm me God hɨr nisesim. ");
INSERT INTO avt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas ketike Sol hɨrakɨt tewet mɨt neit wit Jerusalem pewek. Me wɨ im hawɨ ap kan te menmen me ni mɨr ap mewo au. Hɨrakɨt tewɨr pewek epei au, hɨrakɨt teithis Jon Mak ketikeret pɨke tekiuwe ten wit Antiok. ");
INSERT INTO avt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mɨt han profet kerek newepyapɨr hɨm me God, hɨr netike mɨt han tisa kerek neteikɨn mɨt kerek nises hɨm me God neteiknor menmen God hanhan hɨr enisesim, hɨr nepu netike mɨt kerek newenɨpi niuk me God neit wit Antiok. Profet netike tisa niuk mɨr im: Banabas, Simion, kerek mɨt han nekine niuk mɨrak ham ‘Naisa’ o ‘Yɨnk nɨpɨak’, hɨrakɨt tekite Lusias ke provins Sairini, maneyen kerek nɨpaa hɨrak ketike mɨtɨk iuwe King Herot kinɨn naanmɨpre mɨt, hɨrakɨt tekiyakɨt tau wɨnak kiutɨp, hɨrak ketike mɨtɨk Sol. ");
INSERT INTO avt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Me wɨ ham, hɨr mɨt in ap naam menmen te hɨr nitehi God, God Hɨmɨn Yaaik ketpor, “Yi yehimɨtan Banabas ketike Sol, hɨrakɨt tɨrɨak menmen hi epei hehimɨtenɨwekɨtem tatrɨakem.” ");
INSERT INTO avt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hɨrak ketpor epei au, hɨr wen nɨnpɨ maan nepu, hɨr nitehi God. Hɨr nitehi God, hɨr newis his menterikɨt hɨr neriuwetet ten. ");
INSERT INTO avt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","God Hɨmɨn Yaaik keriuwetet ten wit ke wan eik niuk mɨrak Selusia. Hɨrakɨt ten wit Selusia, hɨrakɨt tau sip ten wit Saipras kerek wan kimaak keketik. ");
INSERT INTO avt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hɨrakɨt tau sip ten wit iuwe Saipras, hɨrakɨt ten wit Salamis ten wɨnak ke mɨt ne Isrel nau nererik nekine hɨm me Moses en, hɨrakɨt tewepyapɨr hɨm me God tatɨp mɨt em. Hɨrakɨt nɨpaa teithis mɨtɨk Jon Mak hɨrak kan kakɨkepikɨt. ");
INSERT INTO avt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hɨrakɨt teke tɨ terekir wit Saipras ke nɨmɨn ten ere tɨpiun wit pɨnak ein niuk mɨrak Pefos. Hɨrakɨt ten en tɨr mɨtɨk kertei ketenwo henpɨn ketike menmen mar im, niuk mɨrak Ba-Jisas. Hɨrak ke weiwɨk me Isrel, hɨrak katɨp hɨrak kewepyapɨr hɨm God ketpɨwekem, te au, hɨrak kemipɨn. ");
INSERT INTO avt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hɨrak wariyakɨt ke Sesias Polas kerek kinɨk naanmɨpre mɨt nau wit wan kimaak keketik, hɨrak mɨtɨk kertei menmen werek werek. Mɨtɨk Sesias Polas kenɨne Banabas ketike Sol tan tɨrek tentar hɨrak hanhan kemtau hɨm me God. ");
INSERT INTO avt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hɨrak hanhan kemtau hɨm me God te mɨtɨk Ba-Jisas kerek ketenwo henpɨn menmei menmei niuk mɨrak me hɨm Grik hɨram Elimas, hɨrak katɨp keknɨwekɨt hɨm mɨrakɨt. Hɨrak han kitet kakri han ke mɨtɨk iuwe gavman Sesias Polas te hɨrak ap kises hɨm me God hɨrakɨt tewepyapɨrem. ");
INSERT INTO avt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Hɨrak wen kari han kɨrak te Sol kerek mɨt nenewek niuk mɨrak me hɨm Grik hɨr nekinaam Pol, God Hɨmɨn Yaaik kau kekre han kɨrak hɨrak kepɨr mɨtɨk ik, ");
INSERT INTO avt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ketpɨwek kar ik: “Ti nɨkan ke Seten, ti hɨre mɨtɨk enuk ti hɨnapen hɨm yaaim. Han kit kertei werek werek menmen enum me memipɨn mekite menmei menmei enum te hekrit hekrit ti eweikɨn hɨm yaaim me God mɨre hɨm enum memipɨn. ");
INSERT INTO avt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","In ek Mɨtɨk luwe God kakitep te wɨ ham ti ap ehɨr menmen au. Ti nanamɨr toto ere wɨ God kehimɨtanem epei au mesi.” Hɨrak katɨp epei au, wasenum menmen mɨre napɨ mesɨwek nanamɨr, hɨrak keke tɨ kɨnkatɨn mɨtɨk hak kaktɨwekhis kakteiknɨwek ya. ");
INSERT INTO avt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mɨtɨk iuwe gavman Sesias Polas kɨr menmen im, hɨrak kises hɨm me God. Hɨrak han kekrit keriuwe hɨm hɨrakɨt tetpɨwek ke Mɨtɨk luwe Krais. ");
INSERT INTO avt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol ketike wariyakɨt tɨrak tɨnaaiwɨr Pefos tau sip terekir wan ten wit Pega ke provins Pamfilia. Me wɨ im Jon Mak kɨnaiwɨret pɨke ken wit Jerusalem. ");
INSERT INTO avt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Hɨr nɨnaaiwɨr Pega neke tɨ nen wit Antiok ke provins Pisidia hɨrakɨt tau en. Hɨrakɨt tau en, me wɨ Sabat kerek mɨt nererik nekine hɨm me Moses, hɨrakɨt ten tau tetikeri neit wɨnak eik e. ");
INSERT INTO avt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hɨrakɨt tau tetikeri neit wɨnak eik, hɨrakɨt temtau mɨt nekine hɨm Moses kewisɨm mau tɨwei metike hɨm mɨt profet nɨpaa newisɨm mau tɨwei. Hɨr mɨt iuwe nekinaam epei au, hɨr neriuwet mɨtɨk kan kitɨwekɨthi kar ik: “Taiu yinakɨt, hɨm meiyam mepeit yi eiyɨpim eikaap mɨt eiriuwerem o au?” ");
INSERT INTO avt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hɨrakɨt tewenhi te Pol kekrit kɨkɨam his mɨrak katɨp kar ik: “Nai yinan yetike mɨt in ap ne weiwɨk me Isrel yi yewenɨpi God. Yi yapɨrwe nɨkɨp emnep eiyɨmtau hɨm! ");
INSERT INTO avt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hɨrak God kerek haiu mɨt ne Isrel mewenɨpiyek, nɨpaa hɨrak kehimɨtan maamrer naiu kerekyor hɨr nɨre yapɨrwe me wɨ hɨr nau wit Isip nar ke mɨt ne wit hak in ek hɨr nau netikewai. Maain God epei keriyeiri (o keriyeiyi) nen nɨnaaiwɨr Isip keriuwe menmen iuwe hɨrak kɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Me 40 tito hɨrak naanmɨpror keit yaank tenhaan weinɨm ap mɨt newi, te hɨrak kɨnaain menmen hɨr nerekɨwekem. ");
INSERT INTO avt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Epei au, hɨrak kenep mɨt miyapɨr ne weiwɨk hispɨnak wik (7) neit wit Kenan kanɨp kenepi kewet mɨt ne Isrel tɨ im kar ke nɨpaa hɨrak ketpim. Hɨm newim ere 450 tito. ");
INSERT INTO avt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Me wɨ God kehimɨtan mɨt nɨre masistret, hɨr nɨkaap mɨt ne Isrel nepɨr mɨt enun nepan nanɨno. God kehimɨtan mɨt narik ere maain wɨ mɨtɨk Samyuel hɨrak profet kɨkaru hɨrak kinɨn naanmɨpre mɨt. ");
INSERT INTO avt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Me wɨ im, mɨt ne Isrel nitehi Samyuel kehimɨtan mɨtɨk hɨrak kakre king hɨrak kakinɨni naanmampri, te God kehimɨtan mɨtɨk Sol nɨkan ke mɨtɨk Kis ke weiwɨk miutɨp me maam Bensamin. Hɨrak kinɨn naanmɨpre mɨt ne 40 tito. ");
INSERT INTO avt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Maain God kepɨrek kehimɨtan Devit hɨrak kekrehɨr ke Sol. God katɨp ke Devit kar ik: ‘Hi hertei mɨtɨk ik Devit hɨrak nɨkan ke Jesi, hɨrak mɨtɨk kar ke hi hanhanek kakises menmen hi hanhan hɨrak kakisesim.’ ");
INSERT INTO avt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nɨpaa God katɨp hɨrak kakriuwet mɨtɨk hak hɨrak kaknen kakɨkaap mɨt ne Isrel kaktorhis nanu werek werek. Mɨtɨk Jisas ke weiwɨk me maam kɨrak Devit, God kehimɨtanek hɨrak Krais kɨkaap haiu mɨt ne Isrel. ");
INSERT INTO avt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Jisas kewepyapɨr menmen iuwe hɨrak kakrɨakem wen au, mɨtɨk Jon katɨp mɨt miyapɨr yapɨrwe ne Isrel hɨr enweikɨn sip enwet menmen enum te hɨrak kakɨri. ");
INSERT INTO avt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Hɨrak Jon kɨrɨak menmen mɨrak kerek God kehimɨtanek kɨrɨakem. Hɨrak kɨrɨakem menep epei au, hɨrak kitehi mɨt kar ik: ‘Yi han kitet hi keimɨn?’ Hi ap Mɨtɨk Krais te yi yemeriyɨwek kaknen. Au, yi yemtewek. Hɨrak kakisɨsa kerekek kaknen hɨrak Mɨtɨk luwe hi au hɨre mɨtɨk enuk weinɨk.” ");
INSERT INTO avt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pol wen katɨp kar ik: “Nai yinan nepenyerer ne Ebraham, yi yetike mɨt han in kerek yewenɨpi God. God epei keriuwetai mɨtɨk te kewepaiyapɨr hɨm yaaim me hɨrak kakɨthis haiu mɨt. ");
INSERT INTO avt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mɨt nepu wit Jerusalem netike mɨt iuwe ninɨn naanmɨprai hɨr netariyek hɨrak Mɨtɨk God kehimɨtanek hɨrak kan kɨkaap haiu mɨt ne Isrel. Hɨr netari hɨm nɨpaa mɨt profet newisɨm mau tɨwei me mɨtɨk ik, hɨram me wɨ Sabat yapɨrwe hɨr nekinaam. Hɨr nesiuwerek ken wɨnak ke kaunsil nesiuwe hɨm nises menmen nɨpaa mɨt profet netpim mamnen. ");
INSERT INTO avt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hɨr ap nɨnapɨn menmen enum hɨrak kɨrɨakem au, te hɨr wen neriuwetek ken mɨtɨk iuwe gavman Pailat nitɨwekhi hɨrak kaknep Jisas hɨrak kaki. ");
INSERT INTO avt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Hɨr nerekyɨwek menmen yapɨrwe hɨm me God mau tɨwei profet newisɨm natɨp hɨram mamnen. Hɨr nerekyɨwekem epei au, hɨrak kaa hɨr newenkekik kentar nu tentarakɨt hɨrak kaa, hɨr newisɨk kekre hei ke han. ");
INSERT INTO avt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Au, hɨrak God kɨkɨak hɨrak kepu. ");
INSERT INTO avt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Me wɨ yapɨrwe hɨrak kewepyapɨr hɨrekes mɨt nɨpaa nɨnaaiwɨr wit Galili nen wit Jerusalem netikerek, hɨr nɨrek. In ek hɨr newepyapɨr menmen im natɨp mɨt ne Isrel em. ");
INSERT INTO avt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Im ek haiu man metpi hɨm yaaim me mɨtɨk Krais. Menmen nɨpaa God katɨp maamrer naiu ketporem, hɨrak in ek kerekyei haiu nepenyerer nɨr kerekyeiyem kentar hɨrak kɨkɨak Jisas kekrit kepu. Hɨm me menmen im mau tɨwei Sam nɨpaa mɨt newisɨm mar im. Hɨram matɨp: ‘Ti nɨkan kai. Petepin hi hɨre Haai kit.’ ");
INSERT INTO avt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God katɨp hɨm im me maain hɨrak kakɨkɨak Jisas pɨke kakɨkrit kaku, kaki kaku kakɨt au. Hɨm mau tɨwei matɨp mar im: ‘Maain hi erekyi yaaim entar hɨm nɨpaa hi atɨp Devit hi ewetɨwekem.’ ");
INSERT INTO avt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Devit kewis hɨm ham mar ik: ‘Hi hertei werek ti God ap ewis ti ehimɨtanek kakɨkaap mɨt ye yɨnk kɨrak kaknɨn kakɨkre hei taau.’ ");
INSERT INTO avt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Devit hɨrak Mɨtɨk Krais God kehimɨtanek au. Hɨrak kɨrɨak menmen God hanhan hɨrak kisesim, hɨrak kepu me wɨ God kehimɨtanek, te hɨrak kaa. Hɨrak kaa, mɨt newisɨk kekre hei menep hei ke maamrer nɨrak, hɨrak kɨwaa en kesine keit. ");
INSERT INTO avt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mɨtɨk Krais kerek God kehimɨtanek kɨkaap haiu mɨt ne Isrel hɨrak kɨwaai kesine au. God kɨkɨak hɨrak pɨke kekrit kepu. ");
INSERT INTO avt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Naiu yinan haiu metpi yi mɨt in yapɨrwe hɨm im mentar menmen hɨrak Jisas kɨrɨakem, hɨrak kasɨsak menmen enum yi yɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nɨpaa hɨm me Moses yi yisesim hɨram ap werek mamɨsak menmen enum yi yɨrɨakem te God katɨp yi yaain au. In ek mɨt kerek nises hɨm me Jisas, hɨrak kasɨsak menmen enum mɨr te God katkɨp hɨr mɨt yaain. ");
INSERT INTO avt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yi naanempre hɨras te menmen nɨpaa mɨt profet newisɨm mau tɨwei hɨram ap manmen yi mɨt. ");
INSERT INTO avt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Hɨram matɨp mar im: ‘Yi mɨt yi yɨnan yipɨr yewɨrek yentar hɨm me God. Yi han kitet yapɨrwe yi yayi yayɨwaank hɨras me menmen hi hɨrɨakem me wɨ yi yepu tɨ, hɨram menmen mɨtɨk hak kewepyapɨrem ketpiyem te yi ap eiyisesim au.’ ");
INSERT INTO avt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol katɨp epei au, hɨrak ketike Banabas tɨnaaiwɨr wɨnak kerek mɨt nekine hɨm me Moses eik, hɨrakɨt tepno, mɨt han netpɨwekɨt me wɨ Sabat ham hɨrakɨt pɨke tatnen tatwepyapɨr hɨ mei me menmen hɨrakɨt tetpim. ");
INSERT INTO avt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mɨt neit wɨnak ek nen witeik epei au, mɨt ne weiwɨk me Isrel netike han ap ne weiwɨk me Isrel au, hɨr nises hɨm me God, hɨr nises Pol ketike Banabas. Hɨrakɨt tetpor tekekyor han te hɨr enises menmen yaaim God kɨrɨak mɨt em. ");
INSERT INTO avt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Me wɨ ham Sabat epei man, mɨt ne wit nen nereik wɨnak kerek hɨr nekine hɨm me Moses nekrerek eik nenewo ere menep wit weinɨk te hɨr nanɨmtau hɨm me God. ");
INSERT INTO avt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Me wɨ kerek mɨt ne weiwɨk me Isrel nɨr mɨt yapɨrwe nererek en, hir yɨnk enuk neriuwerem te hɨr natɨp enum me Pol nemnɨnɨwek hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hɨr nemnɨnɨwek hɨm mɨrak, Pol ketike Banabas tatɨp hɨm iuwe teneri tar ik: “Yi eiyɨmtewen. Hɨram yaaim te yi mɨt yinɨn yemtau hɨm me God. Au, yi yeweikɨn sip yewetɨwem, yi han kitet yi ap yaain te yi yises hɨm im mamkaap yi yayu yaitlike God, te hawɨr wauno wewepyapɨr hɨm me God mamno mɨt ap ne weiwɨk mi me Isrel. ");
INSERT INTO avt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mɨtɨk luwe God ketpawɨr keriuwe hɨm mɨrak katɨp kar ik: ‘Hi ehimɨteni yi yire si meteikɨn mɨt ya ke wɨtaan te yi eiteikɨn mɨt han kerek ap ne weiwɨk me Isrel nerer wit wit eiteiknor hɨr nanises hɨm me God te hɨr nanu werek werek God kaktorhis.’” ");
INSERT INTO avt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mɨt miyepɨr ap ne weiwɨk me Isrel epei nemtau menmen im te hɨr han yaaik wɨsenum hɨr natɨp, “Hɨm me God hɨram yaaim wisenum.” Mit miyapɨr kerek God nɨpaa kehimɨteni hɨr nanu nanɨt nantikerek tipmain tipmain enum eik hɨr nises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mɨt natɨp hɨm me Mɨtɨk luwe God hɨram men merer wit wit me provins ein. ");
INSERT INTO avt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Te mɨt han ne weiwɨk me Isrel nari han ke mɨt iuwe ninɨn naanmɨmpre mɨt ne wit, hɨr netike miyapɨr iuwe han hɨr nises hɨm me Moses, hɨr nɨrɨak Pol ketike Banabas enum hɨr nepɨret tɨnaaiwɨr provins kɨr. ");
INSERT INTO avt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hɨr nepɨret tɨnaaiwɨr provins kɨr te hɨrakɨt tɨtanɨk toni waniu (o win) mau laplap mɨrakɨt teteiknor hɨr mɨt enun neweikɨn sip newet God. Epei au, hɨrakit ten wit Aikoniam. ");
INSERT INTO avt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mɨt kerek nises hɨm me God neit wit Antiok hɨr han yaaik nepu, God Hɨmɨn Yaaik kau kekreri keneisesi. ");
INSERT INTO avt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Hɨrakɨt epei tan wit Aikoniam hɨrakɨt tɨrɨak menmen mar nɨpaa hɨrakɨt tɨrɨakem teit wit Antiok ke provins Pisidia. Hɨrakɨt ten wɨnak ke mɨt ne Isrel nau nererik nekine hɨm me Moses ein eik, tatɨp mɨt hɨm yaaim me Krais te mɨt yapɨrwe ne weiwɨk me Isrel netike mɨt yapɨrwe ap ne weiwɨk me Isrel nises hɨm mɨrakɨt. ");
INSERT INTO avt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mɨt han ne weiwɨk me Isrel hɨr nɨnapen nises hɨm mɨrakɨt hɨr nari han ke mɨt ap ne weiwɨk me Isrel te hɨr nɨnapen mɨt nanises hɨm yaaim me Krais. ");
INSERT INTO avt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Hɨrakɨt aposel tepu en wɨ yapɨrwe, hɨrakɨt ap tɨnapen au. Hɨrakɨt tatɨp mɨt miyapɨr hɨm me Mɨtɨk Iuwe Krais. Mɨtɨk Iuwe kekepikɨt te hɨrakɨt tɨrɨak menmen yaaim tɨkaap mɨt miyapɨr nɨnap o his hɨt enum hɨr nɨre yaain. Mɨt en nertei hɨm hɨrakɨt tetpim me Jisas Krais epei kerekyei haiu mɨt haiu yaain, hɨm mɨrakɨt hɨram yaaim mentar menmen yaaim hɨr nɨr hɨrakɨt tɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mɨt miyapɨr yapɨrwe ne wit ik e, hɨr newep nau nɨmɨn. Han pɨnan netike mɨt ne weiwɨk me Isrel, han pɨnan netike aposel. ");
INSERT INTO avt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mɨt han ne weiwɨk me Isrel netike mɨt han au, hɨr netike mɨt iuwe nɨr han kitet nanɨnep hɨrakɨt aposel neriuwe nan te hɨrakɨt tati. ");
INSERT INTO avt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Au, hɨrakɨt aposel temtewem, hɨrakɨt tɨrɨr ten wit Listra ketike Debi, hɨram wit me provins Likionia, hɨram metike wit ham menep. ");
INSERT INTO avt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hɨrakɨt tepeit en tetpor hɨm yaaim me Krais. ");
INSERT INTO avt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mɨtɨk kiutɨp keit wit Listra hɨt mɨrak enum me wɨ miye winaak ere in te hɨrak kekrit keke tɨ au. ");
INSERT INTO avt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hɨrak kau tɨ kemtau Pol katɨp hɨm me God. Pol kɨrapɨrwek kertei hɨrak kises hɨm me Krais werek te hɨrak kakɨkepik. ");
INSERT INTO avt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Hɨrak katɨp mɨtɨk ik hɨm iuwe kar ik: “Ti ehɨn ekrit ehɨrp eriuwe hɨt mit.” Hɨrak ketpɨwek epei au, mɨtɨk kehɨn kekrit kerp keke tɨ. ");
INSERT INTO avt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mɨt miyapɨr yapɨrwe nɨr menmen im Pol kɨrɨakem, hɨr nɨnap natɨp neriuwe hɨm mɨr Likionia, “God kenipet hɨrakɨt teweikɨnhis tɨre haiu mɨt tekiuwe tan tɨ.” ");
INSERT INTO avt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Hɨr nekine Banabas hɨrak Sus. Hɨr nekine Pol hɨrak Hemes nentar hɨrak kerekek katɨp menmen kar ke hɨr han kitet Hemes ketpim. ");
INSERT INTO avt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wɨnak ke tɨpir Sus kau keit witeik kɨrapɨt ke wit iuwe eik e. Mɨtɨk pris kerek naanmɨpre wɨnak ik e keit bulmakau metike timen keiyɨm kan kewisɨm meit ya weipɨr ke nɨwa. Hɨrak ketike mɨt en hanhan nenep bulmakau neit hemkre neiyɨm nehɨn teinɨk newenɨpi aposel. ");
INSERT INTO avt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ewaai meruri Pol ketike Banabas tertei menmen mɨt nare nanrɨakem hɨrakɨt tewepep klos mɨrakɨt teteikɨn mɨt hɨr han enuk hɨrakɨt tesiuknen tewep mɨt tetɨn ke nɨmɨn ");
INSERT INTO avt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","tɨnap tatɨp tar ik: “Yi mɨt yenmak te yi yɨrɨak menmen im e? Hawɨr mɨtɨkɨt keretet wɨre yi mɨt. Hawɨr epei wan wetpi hɨm yaaim me Krais, te yi eiweikɨn sip eiwet menmen im weinɨm yi eiyises God hɨrak kepu. Hɨrak kerekek kɨrɨak nepni, tɨ wan eik metike menmen yapɨrwe mewim. ");
INSERT INTO avt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nɨpaa hɨrak kewis mɨt nises han kɨr hɨr newenɨpi God weinɨm memipɨn, ");
INSERT INTO avt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","te hɨrak nɨpaa ere in keteikɨn mɨt hɨrak kepu keriuwe menmen yaaim hɨrak kɨrɨakem. Hɨrak kesiuwi hawɨ keke nepni kan, kenip menmen mi yapɨrwe mewo yaaim meriuwe wɨ mɨram. Hɨrak keweti menmen yaaim te yi han yaaik yayu.” ");
INSERT INTO avt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hɨrakɨt tatɨp menmen im te menep hɨrakɨt ap teweni te hɨr nenep bulmakau neit hemkre neiyɨm nehɨnet newenɨpi niuk mɨrakɨt. ");
INSERT INTO avt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mɨt han ne weiwɨk me Isrel nau wit Antiok ke provins Pisidia hɨr netike han ne wit Aikoniam nan nari han ke mɨt yapɨrwe neriuwe hɨm mɨr, hɨr newɨr nan nenep Pol. Hɨr newɨr nan nenep Pol, hɨr han kitet hɨrak nepei kaa, te hɨr nari yɨnk kɨrak neiyɨk nan newɨrek ken kɨnaaiwɨr wit kɨr kɨwaai keit. ");
INSERT INTO avt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hɨrak kɨwaai keit o, mɨt nises hɨm me Krais hɨr nan nererik nerp neweiknɨwek. Hɨr nerp neweiknɨwek, hɨrak Pol kekrit ketikeri pɨke nariyaan nen wit eik. Wanewik, Pol ketike Banabas tariyakɨt ten wit Debi. Hɨrakɨt pɨke ten wit Antiok ke provins Siria. ");
INSERT INTO avt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol ketike Banabas tatɨp mɨt hɨm yaaim me Krais teit wit Debi te hɨr mɨt yapɨrwe nemtau hɨm nisesim. Epei au, hɨrakɨt pɨke ten wit Listra ketike wit Aikoniam. Ten ein epei au, hɨrakɨt pɨke ten wit Antiok ke provins Pisidia. ");
INSERT INTO avt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Hɨrakɨt tɨkaap mɨt kerek nises hɨm me God en te hɨr han tokik nepu, hɨr wen nises hɨm yaaim me Krais wɨsenum. Hɨrakɨt tetpor, “Haiu mɨt menmen enum yapɨrwe mamraiwaank in ek te maain haiu mamu han yaaik God kakinɨn naanmamprai.” ");
INSERT INTO avt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ne mɨt nerer wit wit nises hɨm me God nererik newepnɨpi niuk mɨrak hɨrakɨt tehimɨtan mɨt iuwe hɨr ninɨn naanmɨpre mɨt en. Hɨrakɨt nɨnpɨ makɨt hɨrakɨt titehi Mɨtɨk Iuwe kerek hɨr nisesik, hɨrak kakɨkepikɨt. ");
INSERT INTO avt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","25","Pol ketike Banabas teke tɨ ere ten tɨnaaiwɨr provins Pisidia hɨrakɨt ten tɨpiun provins Pamfilia. Hɨrakɨt ten wit Pega hɨrakɨt tatɨp mɨt ein hɨm yaaim me Krais. Epei au, Hɨrakɨt ten wit Atelia kerek keit wan eik. Epei au, ");
INSERT INTO avt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","hɨrakɨt tau sip pɨke ten wit Antiok hak wit kerek nɨpaa mɨt nehimɨtenikɨt nitehi God naanmamprɨwekɨt me menmen hɨrakɨt in ek epei tɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hɨrakɨt tɨpiun Antiok epei au, hɨrakɨt tari mɨt ne weiwɨk me God en hɨr nererik, hɨrakɨt tetpor menmen yapɨrwe God kekepikɨt tɨrɨakem, hɨrak keteikɨn hɨrak hanhan mɨt ap ne weiwɨk me Isrel hɨr nanisesik. ");
INSERT INTO avt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Hɨrakɨt tatɨp epei au, hɨrakɨt tau tetikeri me wɨ yapɨrwe. ");
INSERT INTO avt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mɨt han ne provins Judia nen wit Antiok natɨp mɨt nises hɨm yaaim me Krais nar ik: “Yi ap yerekir yɨnk ki kar ke nɨpaa Moses ketpim te God ap kaktihis yi eitikerek eiyu au.” ");
INSERT INTO avt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol ketike Banabas hɨrakɨt tetike mɨt in hɨr newepnak natɨp menmen im yapɨrwe, hɨr nenehan. Hɨr nenehan te mɨt ne weiwɨk me God en han kitet nanriuwet Pol Banabas tekite mɨt han en ne Antiok te hɨr nanɨno wit Jerusalem nanɨr mɨt aposel netike mɨt iuwe ninɨn naanmɨpre mɨt ne weiwɨk miutɨp me God ein nanitorhi me menmen im. ");
INSERT INTO avt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mɨt ne weiwɨk me God neit Antiok neriuweti nen. Hɨr nepno newep provins Finisia ketike Sameria, hɨr natɨp mɨt en, “Yi mɨt ap ne weiwɨk me Isrel yi eiweikɨn sip eiwet menmen enum eiyises God.” Mɨt en kerek nises hɨm me God nemtewem te hɨr han yaaik neriuwerem. ");
INSERT INTO avt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hɨr nɨpiun Jerusalem epei au, mɨt aposel, mɨt iuwe ninɨn naanmɨpre mɨt ne weiwɨk me God en netike mɨt en nises hɨm me God nererik newenɨpi God, hɨr han yaaik neriuwe mɨt han nan. Pol ketike Banabas hɨrakɨt tetpor menmen yapɨrwe God kekepikɨt tɨrɨakem. ");
INSERT INTO avt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Hɨrakɨt tetpor epei au, mɨt han ne Farisi kerek in ek nises God hɨr ninɨn nises hɨm lo me Moses hɨr nekrit natɨp nar ik: “Mɨt ap ne weiwɨk me Isrel hɨr enrekir yɨnk kɨr hɨr enises hɨm nɨpaa Moses ketpim.” ");
INSERT INTO avt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hɨr natɨp epei au, mɨt aposel netike mɨt iuwe ninɨn naanmɨpre mɨt ne weiwɨk me God en hɨr nau nererik newepnak natɨpan menmen im. ");
INSERT INTO avt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hɨr newepnak natɨpan yapɨrwe epei au, Pita kekrit katɨp, “Nai yinan, yi yertei nɨpaa enum eik God ke haiu mɨt kehimɨtena hi hewepyapɨr hɨm yaaim me Krais hetpim men mɨt ap ne weiwɨk me Isrel te hɨr nemtewem nisesim. ");
INSERT INTO avt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God hɨrak kertei han ke mɨt keteiknai hɨrak han yaaik te mɨt ap ne weiwɨk me Isrel hɨr nisesik. Haiu merteiyem mentar hɨrak kesiuwe God Hɨmɨn Yaaik kewetɨrek kar ke nɨpaa hɨrak kewetaiyek. ");
INSERT INTO avt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","God kɨrɨak menmen miutɨp me haiu mɨt metike hɨr mɨt ne weiwɨk ham. Hɨrak kesak menmen enum hɨr nɨrɨakem mentar hɨr nises hɨm mɨrak. ");
INSERT INTO avt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","In ek yi yenmak te yi einip God han enuk keriuwe menmen me hɨm me Moses yi han kitet mɨt kerek nises God hɨr enisesim? Menmen im hɨram mɨre menmen miyapɨr neremtɨt hɨram nɨmenum, hɨram mamnip han kɨr enum me menmen enum weinɨm. Nɨpaa maamrer nai netike haiu mɨt in ek ap nises menmen me Moses werek werek au. ");
INSERT INTO avt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Au, haiu han kitet God kaktaihis kakɨr ke hɨrak kakɨthis mɨt han en kakɨntar Mɨtɨk Iuwe Jisas Krais hanhanai kerekyai yaaim. Hɨm me Moses au.” ");
INSERT INTO avt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita katɨp epei au, Mɨt nekintɨp nau neit nemtau Banabas ketike Pol hɨrakɨt tetpor menmen yaaim me mɨt his hɨt enum o menmen meiyam enum hɨr nɨre yaain, God kekepikɨt te hɨrakɨt tɨrɨakem me mɨt miyapɨr ne weiwɨk ap me Isrel. ");
INSERT INTO avt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hɨrakɨt tatɨp epei au, Jems katɨp hɨm mɨrak kar ik: “Nai yinan, nɨkɨp emnep eiyɨmtau menmen im! ");
INSERT INTO avt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon epei ketpai me wɨ God kinɨn keteiknai hɨrak hanhan mɨt ap ne weiwɨk me Isrel hɨrak kari mɨt han ne mɨt han en hɨr mɨt nɨrak. ");
INSERT INTO avt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nɨpaa mɨt profet natɨp me menmen im mar ke haiu metpim. Hɨm mau tɨwei hɨr newisɨm matɨp mar im: ");
INSERT INTO avt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Maain hi Mɨtɨk Iuwe God hi pɨke anen akaap mɨt ne weiwɨk me maam kɨr Devit. Hɨr enun nɨre wɨnak epei kewen te hi pɨke ekepi hɨr nanu werek nar ke wɨnak hi pɨke eimaak ekɨrp. ");
INSERT INTO avt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Hi hɨrɨak menmen im te mɨt ne weiwɨk ham nerer wit wit nanisɨsa, mɨt kerek hi hehimɨteni hɨr mɨt nai.’ ");
INSERT INTO avt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nɨpaa Mɨtɨk Iuwe God kewepyapɨr hɨm im ketpim. ");
INSERT INTO avt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Hi Jems hi han kitet te haiu ap mamɨwaank mɨt han ne weiwɨk ham hɨr neweikɨn sip newet menmen enum nises God. ");
INSERT INTO avt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Haiu emwis tɨwei emsiuwerem emno emɨtpor te hɨr ap nanɨm menmen mɨt han newepwar newet tɨpir weinɨm em mentar God keriuwesɨsem hɨram enum. Im metike hɨr ap nariyanhis newenɨnem, hɨr ap nanɨm samiyak mɨt newers tɨmɨr namɨp neriuwe hemkre ap mewen au hɨr ap nanɨm hemkre mei kike au. ");
INSERT INTO avt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Me wɨ Sabat yapɨrwe mɨt epei nekine hɨm me Moses neit wɨnak kerek mɨt nererik nekine hɨm mɨrak. Mɨt nerer wit wit nekine hɨm mɨrak natɨp mɨt em. Hɨram ap yaaim te mɨt ap ne weiwɨk me Isrel nau netike mɨt ne Isrel nekre wɨnak mɨt nerer ein ein neit nenipi yɨnk enum nentar hɨr ap nises menmen Moses nɨpaa keriuwesɨsem.” ");
INSERT INTO avt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hɨr natɨp epei au, mɨt aposel netike mɨt iuwe ninɨn naanmɨpre mɨt ne God en, hɨr netike mɨt yapɨrwe nises God en hɨr han kitet nehimɨtan mɨt han neriuweti nanɨno Antiok nantike Pol, Banabas. Hɨr nehimɨtan Judas, mɨt nekine niuk mɨrak ham Basabas, hɨrak ketike Sailas. Mɨt nises God in han kitet mɨtɨkɨt it hɨrakɨt yaaikɨt. ");
INSERT INTO avt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Hɨr newis tɨwei newet mɨt em hɨram matɨp mar im: “Haiu mɨt Aposel metike mɨt iuwe ninɨn naanmɨpre mɨt ne weiwɨk me God in, haiu metike mɨt weinɨn ne weiwɨk mɨrak, haiu yapɨrwe metpi yi yaain, yi mɨt yises God yi ap ne weiwɨk me Isrel yau wit Antiok, Siria, Silisia. ");
INSERT INTO avt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Haiu memtau mɨt han ne haiu mɨt nen wit ki nari han ki keriuwe hɨm hɨr netpiyem te yi han enuk. Haiu ap metpor hɨr nanɨno netpiyem au. ");
INSERT INTO avt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Haiu memtewem, te haiu mererik matɨpan menmen im, haiu mehimɨtan mɨtɨkɨt wik mamriuwetet tatno yi mɨt. Hɨrakɨt tatno tatkite taiu yinakɨt yaaikɨt Banabas ketike Pol. ");
INSERT INTO avt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Hɨr mɨt han natɨp nanɨksɨp nanɨntar hɨrakɨt tises hɨm me Mɨtɨk Iuwe kaiu Jisas Krais, hɨrakɨt tatɨp mɨt em. ");
INSERT INTO avt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Haiu epei meriuweti Judas ketike Sailas. Hɨrakɨt tatɨtpi tatriuwe hɨm mɨrakɨt hɨm mepɨr menmen haiu mewisɨm mau tɨwei ik e. ");
INSERT INTO avt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","God Hɨmɨn Yaaik ketike haiu mɨt in haiu han kitetim matɨpan te haiu ap metpi yi eiyises hɨm me Moses yapɨrwe au. Eiyisesim mei kike keremem. ");
INSERT INTO avt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Yi ap eiyɨm menmen mɨt newepwarem newet tɨpir weinɨm em. Yi ap eiyɨm hemkre au, o samiyak mɨt namɨp newers tɨmɨr hemkre wen meriuwerem, yi ap eiriyanhis eiwenɨnem au emɨt! Yi ap eirɨak menmen im haiu mewisiyem te yi eiyu werek werek mepɨr keremem.” ");
INSERT INTO avt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hɨr newis tɨwei epei au, hɨr neriuwet mɨt nen Antiok. Hɨr nɨpiun Antiok, hɨr nari mɨt kerek nises hɨm me Krais hɨr nererik hɨr newetɨr tɨwei ik. ");
INSERT INTO avt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Hɨr neit tɨwei nekinaak. Hɨr nekinaak, hɨr han yaaik neriuwe hɨm mau tɨwei. ");
INSERT INTO avt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ketike Sailas hɨrakɨt mɨtɨkɨt profet, te hɨrakɨt tetpor yapɨrwe tekepi hɨr han tokik nepu te hɨr nepu werek. ");
INSERT INTO avt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hɨrakɨt tepu en wɨ ham teit wit Antiok. Epei au, mɨt nises God en neriuwetet pɨke ten, hɨrakɨt tetpor tar ik: “God naanmampri.”  ");
INSERT INTO avt_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sailas au, hɨrak hanhan kepu en. ");
INSERT INTO avt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol ketike Banabas tepu Antiok me wɨ ham. Hɨrakɨt tetikite mɨt han yapɨrwe hɨr natɨp mɨt hɨm me God newepyapɨrem. ");
INSERT INTO avt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Maain wɨ ham Pol katɨp Banabas kar ik: “Hawɨr pɨke euno ewɨr nawɨr yinan nises God nerer wit wit nɨpaa hawɨr wewepyapɨr hɨm yaaim me Krais, te hawɨr wawɨrtei hɨr nepu werek nisesim o au.” ");
INSERT INTO avt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas hanhan keithis Jon Mak kaktikerek tariyakɨt tatno, ");
INSERT INTO avt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","te Pol kɨnaain ap kaktɨwekhis tariyakɨt tatno kentar nɨpaa hɨrak ap kepu ketikeret ere hɨrakɨt tɨrɨak menmen epei au. Au, hɨrak kɨnaiwɨret keit provins Pamfilia. ");
INSERT INTO avt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hɨrakɨt tenehakɨt tenehakɨt han enuk wɨsenum tentar menmen im te hɨrakɨt tɨnaipɨsakɨt ten. Banabas keithis Jon Mak hɨrakɨt tariyakɨt tau sip ten wit Saipras wan kimaak keketik. ");
INSERT INTO avt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol keithis Sailas tariyakɨt ten. Mɨt nises God en hɨr neriuwetet nitehi God naanmamprewekɨt. ");
INSERT INTO avt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Hɨrakɨt teke tɨ ten provins Siria ketike provins Silisia, hɨrakɨt tɨkaap mɨt ne weiwɨk me God ein tekepi hɨr han tokik enu enises God werek werek. ");
INSERT INTO avt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol hɨrak ketike Sailas ten tiun wit Debi ketike Listra. Mɨtɨk kises hɨm me God hɨrak kepu en, niuk mɨrak Timoti. Miye pɨrak hɨre wetikerek nises hɨm me God miye pɨrak hɨre pe weiwɨk me Isrel te haai kɨrak au, hɨrak ke weiwɨk me mɨt Grik. ");
INSERT INTO avt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mɨt yapɨrwe nises hɨm me God neit wit Listra, wit Aikoniam hɨr natɨp nar ik: “Timoti hɨrak mɨtɨk yaaik.” ");
INSERT INTO avt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol hanhan kaktɨwekhis te hɨrak kerekir yɨnk kɨrak kaknip mɨt ne weiwɨk me Isrel han yaaik. Hɨrak kɨrɨak menmen im kentar mɨt nerer wit wit menep ne weiwɨk me Isrel nertei Timoti haai kɨrak hɨrak mɨtɨk ke Grik, hɨrak ap kerekir yɨnk kɨrak au. ");
INSERT INTO avt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Epei au, hɨrakɨt ten terer wit wit tatɨp mɨt kerek nises hɨm me God, menmen mɨt aposel netike mɨt iuwe ninɨn naanmɨpre mɨt ne God neit Jerusalem hɨr natɨp mɨt ap ne weiwɨk me Isrel hɨr enisesim. Hɨrakɨt tetpor hɨr enisesim, ");
INSERT INTO avt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","te mɨt ne weiwɨk me God neit ein hɨr han tokik nepu nises God werek werek. Mɨt han yapɨrwe hekrit hekrit neweikɨn sip newet menmen enum nises hɨm me God. ");
INSERT INTO avt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Hɨrakɨt teke tɨ ten provins Frisia ketike Galesia tentar God Hɨmɨn Yaaik ap kewisɨkɨt tatno provins Esia tatɨp mɨt miyapɨr hɨm me Krais. ");
INSERT INTO avt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hɨrakɨt ten ere tiun hɨn ke provins Misia, hɨrakɨt tare tatno provins Bitinia te God Hɨmɨn Yaaik kerek Jisas kewet mɨt ek, hɨrak ap kewisɨkɨt tatno au. ");
INSERT INTO avt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hɨrak ap kewisɨkɨt tatno au, te hɨrakɨt tɨnaaiwɨr Bitinia tekiuwe Misia ere tiun wit Troas. ");
INSERT INTO avt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Hɨrakɨt tɨpiun wit Troas, wɨtaan Pol kepu kɨtyak kɨr mɨtɨk ke Masedonia kerp kitɨwekhi kar ik: “Ti ehu sip enen wit kaiu Masedonia ti ekepai.” ");
INSERT INTO avt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol kɨr menmen im epei au, (hi Luk hetikeret) haiu mewen menmen memi mekre tanɨk kaiu haiu mare mamno provins Masedonia mentar haiu epei mertei God kenɨnai kehimɨtenai mamno en mamtɨp mɨt miyapɨr hɨm yaaim me Krais. ");
INSERT INTO avt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Haiu mau sip mɨnaaiwɨr wit Troas merekir wan mesipat wit yapɨrwe men ere mɨpiun wit Samotres. Haiu mɨpiun wit Samotres, haiu mɨpiun wit Niapolis. ");
INSERT INTO avt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Haiu mɨpiun Niapolis epei au, haiu mɨnaaiwɨr sip meke tɨ men wit Filipai kerek nɨpaa mɨt ne wit iuwe Rom nan newik nenipek kɨre wit iuwe kinɨn wit ham me provins Masedonia. Haiu mepu wit eik wɨ ham. ");
INSERT INTO avt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Me wɨ Sabat haiu mɨnaaiwɨr wit men mani menep wit. Haiu han kitet mɨt nehimɨtan wit menep tɨpar eik te hɨr natɨp God menmen. Haiu mau en metike miyapɨr keriyen nererik nau mani eik haiu mewepnak. ");
INSERT INTO avt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mɨte piutɨp pe miyapɨr kerek nererik en nemtau hɨm maiu, hɨre niuk mɨre Lidia. Hɨre wises God wewenɨpiyek. Hɨre pe wit Taiataira, hɨre wesiuwe laplap mɨre yɨwir wawɨt pewek mamrerim. Mɨtɨk Iuwe God hɨrak keweikɨn han kɨre te hɨre wemtau hɨm Pol ketpim hɨre wisesim. ");
INSERT INTO avt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hɨre wetike mɨt miyapɨr neit wɨnak kɨre hɨr nitehi haiu mɨt mɨkɨri neriuwe tɨpar. Haiu mɨkɨri neriuwe tɨpar, hɨre witaihi war ik: “Yi han kitet hi hises hɨm yaaim me Krais te yi einen eiyu wɨnak kai.” Hɨre wari han kaiu te haiu men mau en. ");
INSERT INTO avt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wɨ ham haiu mepno wit menep mani te matɨp God menmen, mɨte piutɨp kerek wɨrɨak menmen me mɨt han, hɨre herwe enuk kau kekre han kɨre kekepye wewepyapɨr menmen maain te mamnen. Mɨt kerek naanmɨprewe neit pewek yapɨrwe nentar menmen im. ");
INSERT INTO avt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hɨre wises Pol ketikewai wɨnap watɨp war ik: “Mɨt in hɨr nɨrɨak menmen me Mɨtɨk Iuwe God. Hɨr newepyapɨr netpai menmen haiu emisesim te God kakɨsak menmen enum haiu mɨrɨakem te hɨrak kaktaihis.” ");
INSERT INTO avt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hɨre wɨrɨakem warek wɨ yapɨrwe ere Pol han enuk keriuwerep keweikɨn ketpɨwe kar ik: “Hi hetput hekrehɨr ke Mɨtɨk Iuwe Jisas ti enke enopɨn ekeipnɨwe.” Hɨrak katɨp epei au, herwe kɨnaiwɨrep kɨrɨr ken waswas. ");
INSERT INTO avt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Maain mɨt kerek naanmɨprewe hɨr nertei herwe kenke kekeipnɨwe te hɨr ap nanɨt pewek mei au, hɨr neithis Pol ketike Sailas nerikɨt nen nɨr mɨt iuwe masistret neit wit nɨmɨnek me wit mɨt nesiuwe hɨm nererik neitai, ");
INSERT INTO avt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","hɨr nerikɨt nen mɨt iuwe masistret ne Rom natɨp nar ik: “Mɨtɨkɨt it hɨrakɨt te weiwɨk me Isrel, hɨrakɨt tɨrɨak enum me haiu mɨt mau wit ik e. ");
INSERT INTO avt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Hɨrakɨt tetpai menmen te hɨram ap mises menmen mɨt naiu iuwe ne Rom natɨp haiu emisesim au.” Haiu ap emises menmen mɨtɨkɨt it tetpaiyem au emɨt. ");
INSERT INTO avt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mɨt miyapɨr yapɨrwe netikeri nesiuwe hɨm. Epei au, Mɨt iuwe masistret neriyɨwekɨt klos mɨrakɨt newepim natɨp mɨt nɨr nanɨnen nanwaai nɨpɨn nanɨksɨp. ");
INSERT INTO avt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hɨr nenke nɨpɨn naksɨp yapɨrwe. Te hɨr newɨret tekre wɨnak enuk, hɨr natɨp mɨtɨk naanmɨpre wɨnak enuk te hɨrak naanempre mɨtɨkɨt werek werek. ");
INSERT INTO avt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Hɨrak kemtau hɨm mɨr im epei au, hɨrak kewisɨkɨt tekre haau ke nɨmɨn kewis hɨt mɨrakɨt kemenkekim mitet hei me nu nɨmenum metenen hɨt me mɨt. ");
INSERT INTO avt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Me wɨ nɨmɨn Pol ketike Sailas hɨrakɨt titehi God menmen hɨrakɨt tine henye. Mɨt han nekre wɨnak enuk ek hɨr nemtau menmen hɨrakɨt tinaam tetpim. ");
INSERT INTO avt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hɨrakɨt tɨrɨak menmen im, tɨ kɨtanɨk wɨsenum te wɨnak enuk kɨrirɨr iuwe, waswas weipɨr yapɨrwe menke, sen hɨram menke mɨnatɨn men mekeipɨn mɨt yapɨrwe nekre wɨnak eik. ");
INSERT INTO avt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mɨtɨk naanmɨpre wɨnak enuk kekrit kerenaan kɨr weipɨr yapɨrwe menke, hɨrak han kitet mɨt neit nɨmɨn en nepei nɨrɨr nen witeik. Hɨrak keket hɨne kɨrak kare kakwɨrek kaknep hɨrekes kentar hɨrak kɨnaain mɨt iuwe nanɨr mɨt enun epei netpaan nɨrɨr nen te hɨr han enuk neriuwerek nankɨp. ");
INSERT INTO avt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Hɨrak kaknep hɨrekes, au, Pol kɨnap hɨm iuwe kesinɨwek ketpɨwek, “Au emɨt! Ti ap enep hɨrekes. Haiu mɨrɨr au haiu mepu in.” ");
INSERT INTO avt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hɨrak katɨp epei au, mɨtɨk ik kenɨne mɨtɨk hak kakɨt si keiyɨk kaknen. Hɨrak keit si keiyɨk kan, hɨrak kesiuknen ken nɨmɨn hɨrak kepɨrpɨr kitehɨr kewen ninɨp menep hɨt me Pol ketike Sailas. ");
INSERT INTO avt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Te hɨrak pɨke kekrit kerp kerikɨt ken witeik kitɨwekɨthi kar ik: “Hi arɨak mekam te God kakɨsak menmen enum mai hɨrak kaktauhis?” ");
INSERT INTO avt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hɨrakɨt tewenɨwekhi tetpɨwek tar ik: “Ti ehises hɨm me Mɨtɨk Iuwe Jisas te ti etike mɨte nɨkerek nit, God hɨrak kakɨsak menmen enum yi yɨrɨakem.” ");
INSERT INTO avt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Hɨrakɨt tatɨp epei au, hɨrak ketɨwekɨthis ten hɨrakɨt tewepyapɨr hɨm me Mɨtɨk Iuwe Krais te hɨrak mɨtɨk ketike mɨt miyapɨr neit wɨnak kɨrak nemtau hɨm me God hɨrakɨt tetpim. ");
INSERT INTO avt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hɨrakɨt tatɨp epei au, hɨram wen wɨ nɨmɨn, mɨtɨk ik ketɨwekhis ken kɨkɨr sip kirakɨt ere werek. Hɨrak kɨkɨr sip kɨrakɨt, Pol ketike Sailas tɨkɨr mɨtɨk ketike mɨt miyapɨr nɨrak neriuwe tɨpar. ");
INSERT INTO avt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Hɨrakɨt tɨkɨri, hɨrak mɨtɨk eik ketɨwekɨthis keiyɨkɨt ken wɨnak kɨrak kewetɨwekɨt menmen taam. Hɨrak ketike mɨt miyapɨr neit wɨnak kɨrak hɨr han yaaik nentar hɨr in ek nises hɨm me God. ");
INSERT INTO avt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wanewik, mɨt iuwe masistret ne Rom nau wit, hɨr nesiuwe mɨt plisman nen wɨnak enuk natɨp nar ik: “Yi eisiuwe mɨtɨkɨt wik hɨrakɨt tatno.” ");
INSERT INTO avt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mɨt natɨp epei au, mɨtɨk naanmɨpre wɨnak enuk kan katɨp Pol kar ik: “Mɨt iuwe masistret nesiuwe hɨm natɨp yi yaino witeik, yi yaino God naanmampri me menmen.” ");
INSERT INTO avt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Te Pol katɨp mɨt plisman kar ik: “Mɨt iuwe ap nɨnapɨn menmen enum hawɨr wɨrɨakem te hɨr newep neit witeik mɨt yapɨrwe nɨrei. Hawɨr wɨre mɨt nau wit Rom hɨr ap nerekyawɨr menmen em mar im au nentar mɨt iuwe neit wit Rom newis hɨm mau tɨwei neriuwesɨsem. In ek hɨr mɨt in nare nɨsawɨn menmen neriuwetawɨr a? Taau! Hɨr hɨras nanɨnen in nanriuwetawɨr euno witeik.” ");
INSERT INTO avt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Hɨrak katɨp menmen im epei au, mɨt plisman pɨke nen natɨp mɨt iuwe hɨm mɨrak. Hɨr epei nemtau Pol ketike Sailas hɨrakɨt tɨre mɨt ne wit Rom hɨr nɨnaain natɨp nar ik: “Haiu mɨrɨak menmen enum ye.” ");
INSERT INTO avt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Te hɨr nen nɨr Pol ketike Sailas, hɨr natɨp nar ik: “Yi yaaikɨt, haiu mepɨtari yi yɨre mɨt ne Rom.” Hɨr natɨp epei au, hɨr neriyakɨt ten witeik nitɨwekɨthi te hɨrakɨt tɨnaaiwɨr wit kɨr. ");
INSERT INTO avt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol ketike Sailas hɨrakɨt tɨnaaiwɨr wɨnak enuk ten wɨnak ke Lidia. Epei au, hɨrakɨt tatɨp mɨt kerek nises hɨm me God tetpor hɨm mamkepi hɨr han tokik nanu. Hɨrakɨt tetpor hɨm ere werek, hɨrakɨt teit menmen teiyɨm tatnaaiwɨr wit Filipai tatno. ");
INSERT INTO avt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Hɨrakɨt tɨnaaiwɨr Filipai, hɨrakɨt ten tewep wit Amfipolis. Hɨrakɨt ten tewep wit Amfipolis tesipatek, hɨrakɨt ten tewep wit Apolonia ten ere tɨpiun wit Tesalonaika kerek wɨnak ke mɨt ne Isrel nererik nekine hɨm me Moses neitai. ");
INSERT INTO avt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol keit in kɨrɨak menmen kar ke nɨpaa hɨrak kɨrɨakem keit wit hak. Me wɨ Sabat hɨrak ken wɨnak kɨr. Me wɨ Sabat wikak hɨrak ketikeri newepnak natɨpan, hɨrak keit hɨm me God mau tɨwei ketporem keteiknorem kar ik: ");
INSERT INTO avt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Mɨtɨk God kehimɨtanek hɨrak Krais, God hɨrak katɨp mɨtɨk ik kaki pɨke kakɨkrit. Mɨtɨk ik Jisas hi ewepyapɨr etpiyek hɨrak Mɨtɨk God kehimɨtanek hɨrak Krais kerekek kakɨkaap haiu mɨt ne tɨ.” ");
INSERT INTO avt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mɨt miyapɨr han ne weiwɨk me Isrel hɨr nemtau hɨm im hɨr nises Pol ketike Sailas. Mɨt han ne Grik kerek newenɨpi God, hɨr netike miyapɨr iuwe yapɨrwe ne Tesalonaika hɨr nisesikɨt. ");
INSERT INTO avt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Te mɨt han ne weiwɨk me Isrel neit wɨnak en hɨr ap nises hɨm im hɨr yɨnk enuk nentar mɨt yapɨrwe nises hɨm mɨrakɨt. Hɨr nen ya neithis mɨt enun nau yain yain hɨr nesikeyaanmi nererik nen nari han ke mɨt yapɨrwe ne wit. Hɨr neweikɨn wɨnak ke mɨtɨk niuk mɨrak Jeson nenke weipɨr nɨnatɨn Pol ketike Sailas te hɨr neriyakɨt nesiuweret ten mɨt. ");
INSERT INTO avt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hɨr nɨnetnɨwekɨt nɨnetnɨwekɨt au, hɨr nari mɨtɨk Jeson ketike mɨt han nises Krais, neriyei nen mɨt iuwe masistret nɨnap netpor nar ik: “Mɨt kerek nɨrɨak enum nerer wit wit epei nan in nɨrɨak enum. ");
INSERT INTO avt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Mɨtɨk ik Jeson kewisi nan nau wɨnak kɨrak. Hɨr neweikɨn sip newet hɨm me mɨt iuwe neit Rom. Hɨr natɨp nar ik: ‘Mɨtɨk iuwe king hak kinɨn Sisa, hɨrak niuk mɨrak Jisas.’” ");
INSERT INTO avt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Hɨr natɨp hɨm im, hɨr n