﻿USE sofia;
DROP TABLE IF EXISTS sofia.auy_vpl;
CREATE TABLE auy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES auy_vpl WRITE;
INSERT INTO auy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ísu Káráísitini akúníꞌo uráan-aai. Ísun-aíwáꞌná Téfítin-iye. Téfítin-aíwáꞌná Émbaramun-iye. ");
INSERT INTO auy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Émbaramu Áísáakimba maꞌankówana Áísáaki Yékopumba maꞌankówana Yékopu Yúndaa-iyai afarawainonda matinkówana ");
INSERT INTO auy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yúndaa Pérésinte Sáraante matínkaraimba tinówa Témaan-iye. Pérési Éséronimba maꞌankówana Éséroni Árámumba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Árámu Ámínándapumba maꞌankówana Ámínándapu Násonimba maꞌankówana Násoni Sáómonimba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sáómoni Póásimba maꞌánkaraimba anówa Réꞌapimaniye. Póási Ópétimba maꞌánkaraimba anówa Rútimaniye. Ópéti Yésimba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yési Téfítimba maꞌankówana Téfítimo káráwiyaiwai Soromonimbá maꞌánkaraimba anówani aifaráán-kwánkón-áwíꞌa Yúráya úwana ánaaen-kwamba Téfítin-iye. ");
INSERT INTO auy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromoní Ríyapoamumba maꞌankówana Ríyapoamu Ápáísaamba maꞌankówana Ápáísaa Ésaamba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ésaa Yíósafatimba maꞌankówana Yíósafati Yórámumba maꞌankówana Yórámu Ásáyaamba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ásáyaa Yótámumba maꞌankówana Yótámu Éꞌásaamba maꞌankówana Éꞌásaa Ésékayaamba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ésékayaa Mánásaamba maꞌankówana Mánásaa Émósimba maꞌankówana Émósi Yósáyaamba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yósáyaa Yékónaya-iyai afarawainonda matinkówasa minkánááfímbá Pépíróni-naopakewi Ísareri-waasi tatíꞌmaesa Pépírónifaꞌa ándáfaꞌa mátínkaraawe. ");
INSERT INTO auy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pépírónifaꞌa mátinkon-kanaafimba Yékónaya Síátiomba maꞌankówana Síátio Sérápáperimba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sérápáperi Ápáyatimba maꞌankówana Ápáyati Éráyakimumba maꞌankówana Éráyakimu Ésomba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Éso Sétókomba maꞌankówana Sétóko Ékímumba maꞌankówana Ékímu Éráyatimba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Éráyati Éríesaamba maꞌankówana Éríesaa Mátánaamba maꞌankówana Mátánaa Yékopumba maꞌankówana ");
INSERT INTO auy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yékopu Yósepimba maꞌankówana Yósepi Máríyaan-awaaikó úwana Máríyaa Ísun-anówan-iye. Ísuntafesa Maníkó íyáfasinankaraiwaiye sésa Káráísitiye wésewe. ");
INSERT INTO auy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Émbaramumo méronkaꞌa sísamaifakemba éíyaimba kumbaimái-waasi 14 waasi agaiyówasa Téfítimo paápé urénamo méronkaꞌa sísamaifakemba éíyaimba kumbaimái-waasi 14 waasi agaiyówasa Pépírónifakewi tatíꞌmaesa Pépírónifaꞌa ándáfaꞌa mátínkarowasa méron-kanaafimba sísamaifakemba éíyaimba kumbaimái-waasi 14 waasi agaiyówana minkáꞌá Máríyaa Ísu Káráísitimba maꞌánkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ísu Káráísitimba maꞌankómba maará uráiye. Ísun-anówamba Yósepinkaꞌa aaí símakowana Yósepi ímba weséꞌa kurónkaꞌa ámúꞌa paápé uráiye. Ufaen-ámútánkó Máríyaan-arumpi túwana ámúꞌa paápé úwana ");
INSERT INTO auy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","awaaikó kaweꞌá wéuwai séna waási túrankaꞌa aiꞌmáráanana Máríyaa aigaesáféna ifáímpóꞌa aúpáꞌá aiꞌmátuwanaumne-imayaa uráiye. ");
INSERT INTO auy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Miyá imáyáa wéena aún-kwérowana Fasiꞌaénkó kísau-waasigo wíyómpakewi kaainampáꞌá simámena séna Yósepiyo Téfítin-andafaken-kwaasi óne. Máríyaamo ámúꞌo káúfímba Ufaen-ámútánkó aantemba ámúꞌa kauwánkáímba po wembá úwoi máínompo ímba ááꞌa íno. ");
INSERT INTO auy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iyámpóímo maꞌankáínda áwíꞌa Ísuwe simánkaao siyáiye. Mináwíkóní áwáuma wení waási sáwí-imayaagomo taꞌótokaimpinkemba faútinkainiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Naaófáꞌá Maníkón-aaimo simátímakowi siyónkaꞌa póna miyán-tántááꞌá paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Wemá agaimaréna séna moórá-inaamarugo waaí ímba maiyéna ámúꞌa kaumái iyámpói maꞌankáínasa miníyámpóígón- áwíꞌa Émániyueriye sénááwe agaimaréna siyáimba mináwíkóní áwáuma Maníkó keséta méraiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yósepi aúfínkémbá íyáfasinena Fasiꞌaénkóní kísau-waasigo wíyómpakewi siyóntemba awaainínkómbá maiyéna ");
INSERT INTO auy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ímba weséꞌa kúmba úwoi ména káráwiyowana iyámpói maꞌankówana áwíꞌa Ísuwe simánkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yúndiyaa-marafaken-kawaagon-awiꞌa Éroti méron-kanaafimba Pétaremu-naopaꞌa Máríyaa Ísumba maꞌánkarowasa némpakemba aafáúmó íyáúsupaken-kwaasi kaweꞌ-ímáyááwáráꞌ-wáásí témesa Yérúsaremu-naopaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sésa Yúndaa-waasiyaꞌa káráwiyiniye sénamo maꞌánkáín-iyampoi nááfara ánkaraao. Aafáúmó íyáúsipaꞌa méta awánáúndasa moórá-oꞌa paápé isatá awánéta séta iyámpói maꞌánkaraimba póta awánéta wenáwíꞌa mósá maránae séta témeta túne siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Suwaná marará-káwáágó Éroti minááí isówana arunkó sáwíꞌa úwasa Yérúsaremu-naopakewiwaraꞌa ísówana tirunkó sáwíꞌa úwana ");
INSERT INTO auy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Éroti óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé táántowasa túwaandu uwaná séna Maníkómó aiꞌmaráíndawimba Káráísitimba maꞌankáínda nááfara maꞌankáíníyo súwasa ");
INSERT INTO auy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","sésa Yúndiyaa-marafaꞌa Pétaremu-naopaꞌa maꞌankáíníye. Maníkón-aaimo simátímakowi agaimaréna séna ");
INSERT INTO auy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yúndiyaa-marafaꞌa Pétaremu-naopaken-kwaasisono. Yúndiyaa-marafaꞌa káráwiyaiwaifimba kentí naaópaꞌo káráwiyaiwai ímba tínaaempaꞌa méraawe. Kentí naaópakemba moóráwigo paápé uréna kesí waási Ísareri-waasiyaꞌa kaweꞌá úmai káráwiyiniye agaimaréna siyáiye suwaná ");
INSERT INTO auy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Éroti iséna aafáúmó íyáúsupaken-kwaasi aúpáꞌá táántowasa tuwaná tísai ena séna nóran-kanaawa minóꞌá paápé isará awánaraao súwasa simámúwana ");
INSERT INTO auy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Éroti séna Pétaremufaꞌa miníyámpóí koayaafáí úmai awánéꞌa tasimásimiyaꞌa keséꞌa kuréꞌa wenáwíꞌa mósá máráano súwasa ");
INSERT INTO auy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","isésa kumbá aafáúmó íyáúsupaꞌo mésamo awánaraan-oꞌa awánowana minókó aifaꞌá wéwena miníyámpóímó méronkaꞌa kowaúwasa ");
INSERT INTO auy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","áfááraumai aamoí ésa ");
INSERT INTO auy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","mindáúmpáꞌá iyésa anówane miníyámpóíyé tuwánésa kífaesa miníyámpóígón-áwíꞌa mósá marésa unáámbá óin-tokésa kawe-tántááꞌá korí-óntámbá fóimai amésa kaweꞌ-úmúmbó í-tántááꞌá fóimai amésa asaa-wiyúm-básáwénkwáráꞌá fóimai ámakaawe. ");
INSERT INTO auy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ámatuwesa tún-kwáúwana Maníkó kaainampáꞌá simátimena séna Érotimba ímba kosimáméro súwasa fíꞌon-ampakemba kentí naaópaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kúwana wíyómpakemba Fasiꞌaénkóní kísau-waasigomba Yósepi kaainampákémbá awánówana séna Éroti miníyámpóí tufuwíndasafena wésaafa-ifo íyáfasine anówane miníyámpóíyé tíꞌmae Ísípi-marafaꞌa koménaꞌa aánoꞌa simámeꞌa áíꞌmae tiyó sénaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","mindóꞌwáámbá íyáfasinena anówane miníyámpóíyé tíꞌmaena Ísípi-marafaꞌa wémena ");
INSERT INTO auy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","mifáꞌá komérowana Éroti pukáiye. Naaófáꞌá Maníkón-aaimo simátímakowi siyónkaꞌa póna miyá uráiye. Wemá agaimaréna séna Fasiꞌaénkó séna Ísípi-marafakemba kesáánimba mérainaꞌa áántaanana kouweráíníye siyáiye agaimaréna siyónkaꞌa póna miyá uráiye. ");
INSERT INTO auy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Éroti awánómba aafáúmó íyáúsupaken-kwaasi karoꞌá simánkesa kóuwana Érotin-arunko áyámba úwana aafáúmó íyáúsupaken-kwaasimo simámakon-aaisafenawe oꞌá paápé uráiyemo siyón-aaisafenawe imáyáa éna tuwímbai tiꞌmaréna séna Pétaremu-naoꞌ-aempaꞌ-naopimpaꞌa kaeꞌ-áátáímó uwásúwén-iyampoiye ímbo kaeꞌ-áátáímó uwásúwén-iyampoiye saafá úmai tínkantuwaaro súwasa miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Yérémaya siyónkaꞌa póna miyá uráiye. Wemá agaimaréna séna ");
INSERT INTO auy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ráma-waasi áfááraumaimo ifiꞌó taráamba ísaraawe. Réserin-aísaafitantamba uráan-kwaasi miwítí iyámpóísafesa ifiꞌá taawasá iyámpóímo pukáantafesa timambá faráátamai tínkaraawasa úwoi ifiꞌá támaesa iyáawe agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Éroti puwúmba Yósepi Ísípi-marafaꞌa ména wíyómpakemba Fasiꞌaénkóní kísau-waasigomba kaainampákémbá awánówana séna ");
INSERT INTO auy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","miníyámpóígómbá tufuwónaemo sen-kwáásí éꞌa púwófo íyáfasine anówane miníyámpóíyé tíꞌmae Ísareri-marafaꞌa waaó súwana ");
INSERT INTO auy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","íyáfasinena awaainínkóné ááninkonte tíꞌmaena Ísareri-marafaꞌa kúmba ");
INSERT INTO auy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Érotin-ááninkon-awiꞌa Ákéreasi afowán-ánóndáá Yúndiyaa-aempaꞌa kawáá-kísáú wémauwana Yósepi iséna mináémpáꞌó wíndasafena inkaisúwana kaainampáꞌá Maníkó simámuwana Káríri-aempaꞌa ");
INSERT INTO auy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Násareti-naopaꞌa tíꞌmaena koméraiye. Naaófáꞌá Maníkón-aaimo simátímakowi siyónkaꞌa póna miyá uráiye. Wemá Ísuntafena séna Násaretifaken-kwaasin-iye sénááwe agaimaréna siyónkaꞌa póna miyá uráiye. ");
INSERT INTO auy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Minkánááfímbá moóráwigon-awiꞌa Yóni ména nombó maitinkówi póna Yúndiyaa-marafaꞌa kúmba máásai-marafaꞌa koména simátimena séna ");
INSERT INTO auy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Maníkó wení waási kawáánimba ómbaraifo kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌá teró simátímaꞌmaena iyáiye. ");
INSERT INTO auy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Naaófáꞌá Yóni ímbo méronkaꞌa Maníkón-aaimo simátímakowin-awiꞌa Áísáya Yónimo paápé índasafena imáyáa éna agaimaréna séna moóráwigo máásai-marafaꞌa ména aaemáíyakemba séna Fasiꞌaénkóní aambó wiꞌankáíyamba wení aambá arupíse íyana minámpáꞌá wíno Áísáya agaimaréna siyónkaꞌa póna Yóni paápé úwana minááí paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yóni káámeri-poigoni áyáu-watoi iyéna ásisamba áꞌwáánkau uréna faꞌnóríné wantáámíkóní aúwé mintón-aantemba wénena ");
INSERT INTO auy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","aaí simátímaꞌmaena iyúwasa Yérúsaremu-naopaken-kwaasiye Yúndiyaa-aempaken-kwaasiye Yóndani-nonkoni menáípákéné maanáípákén-kwáásíyé miyáumai-waasi tóso ésa ");
INSERT INTO auy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","miwítí sáwí-awauma kufíyúwana Yóni Yóndani-nompimba nombá maitínkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yóni nombá maitinkéna awánómba ámáán-kawaa-waasiye Sátúsi-amaan-kawaa-waasiye sáwífaꞌa nombá maisinkáínkwae sésa wempáꞌá tóso uwaná simátimena séna iyánkó póígon-araaꞌan-owe. Maníkó kentí sáwí-meyamba timínífo nááwa simátímísara iséra inkaiséra wéteo. ");
INSERT INTO auy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kentí sáwí-kisau tuwéꞌo Maníkómpáꞌó téꞌo éꞌa kawe-kísáú maíyaꞌa tuwánánaumne. ");
INSERT INTO auy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Émbaramu kentáá síwáꞌná imbá póta Maníkóní kaweꞌ-wáásísá úne séꞌa miyán-ímáyáá ímba oro. Maníkó Émbaramun-aísaafitantamba ónááwe sénaraantaasi maanóntámpínkémbá kanaámpóꞌa waási úráaro sisaꞌá úráawaisino. Émbaramun-aísaafitantamba uráundawi póta kaweꞌ-wáásísá úne séꞌa miyán-ímáyáá ímba oro. ");
INSERT INTO auy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ímba kaweꞌ-árámbá íyáín-taima áwáufimba wéayaisuwesamo iyafímbó agaisúwáántemba Maníkó miyáumai kentí sáwí-meyamba timíníye Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yóni simátimena séna kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌó tewí nombá wémaitinkaundanifo kesínaaembo tíndawi Ufaen-ámútánkómbá aiꞌmaráínana kuména kempímbá óraaꞌa uwátinkainiye. Iyamó agáéntemba íníye. Wemá óraako kembá íyáákaraifo wemó aaí síndaraꞌo kemó sendá sáwíꞌan-iye. ");
INSERT INTO auy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aawinkwínaumo sipetifímbó mósá marésamo mentúwááwanamo anómbo marapáꞌó kúmísanamo ásimo fiyúndágomo tiyútúwáísasamo kámakamaꞌo índai-iyafimbo uwááígomo agaisuwésamo anómbo naaúmpaꞌo mósá máráántemba waási miyáráámbá íníye Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Minkánáá Ísu Káríri-aempakemba Yóndani-nompaꞌa téna Yóni nombá maisinkáínkwae séna túwana ");
INSERT INTO auy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yóni séna ímbanifo emó nombó maisinkénda kanaán-ifo kentáfémo sémo nombá maisinkaaómó séndawe súwana ");
INSERT INTO auy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ísu séna ifátuwe súndantemba miyán-uwo. Miyámó ékaimo ékai Maníkó siyáiniꞌa óyauye súwana ewé séna ");
INSERT INTO auy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","nombá maiyankówana nompínkémbá íyáfasinowana kampúaran-tawaai tuwínkaaꞌ-úwana Yóni awánómba Maníkóní ámútanko mááufuꞌ-numaraamba úmaena Ísu aneꞌá kumbérowana ");
INSERT INTO auy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aaigó aantemba wíyómpakemba séna maawá kesáánimba isaꞌá wen-ímáyáá wéeꞌa áfááraumai aamoí uwánkaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Súwana waántáwanko Ísumba áísai úmai isáíndasafena Maníkóní ámútanko Ísumba simámuwana máásai-marafaꞌa ");
INSERT INTO auy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","koména tómbá ímba néna ayáátáákaꞌa 40 noꞌwaamba waúwana áfááran-aai tówana ");
INSERT INTO auy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","waántáwanko Ísu sáwíꞌo índa awánánae séna Ísumpaꞌa téna séna emá Maníkón-ááninko úne wésempo maanóntánkóntáfé tómbá úrénaꞌa naanó siyó súwana ");
INSERT INTO auy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ísu séna Maníkón-aai aúfáífinkemba séna tómbó náíyawi aantemba waási ímba fasiꞌátinkainifo Maníkó siyáintemba seyaafáꞌá íyana fasiꞌátinkainiye siyáifo emó sénda ímba miyá ónaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","waántáwanko Ísumba áíꞌmaena Yérúsaremu-naopaꞌa wéna óraaꞌ-amaan-dankoni amifaꞌá móankena ");
INSERT INTO auy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","séna Maníkón-aai aúfáífinkemba séna Maníkó wíyómpakemba wení kísau-waasisomba tiꞌmaráínasa enkáꞌá káráwiyesa pósa óntankaꞌa aísamai turaráanafo sésa tiyáántandesa faramónááwe siyáiye. Mindásafe emá Maníkón-ááninko úne wésempo maankákémbá ásáfenasa wíyómpakewi farámbaesa marapáꞌá múankanaawe waántáwanko súwana ");
INSERT INTO auy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ísu séna Maníkón-aai aúfáífinkemba éꞌa miyá siyéna moórá-aaiwaraꞌa séna kentí Fasiꞌaénkó Maníkómbá áísai úmai isánae ímba seró siyáimba emó séndantembo miyámó ékaa Maníkómbá áísai úmai isáúsino. Mindásafemo emó sénda ímba miyá ónaumne Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","waántáwanko Ísumba áíꞌmaena óraaꞌ-omapaꞌa iyéna móankena seyaafáꞌ-máráfáꞌá káráwiyon-kwaasiye miwítí óraa-fasiꞌaene aráánamena ");
INSERT INTO auy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","séna kenkáꞌó kífaemo ken-ímáyáámó mósá márénaꞌo éꞌa káráwiyi-kisau áména káráwiyinone waántáwanko súwana ");
INSERT INTO auy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ísu séna waántáwanko kóuwo. Maníkón-aai aúfáífinkemba séna kentí Fasiꞌaénkó Maníkómpáꞌá imáyáa éꞌa wenáwíꞌ-aantemba mósá maréꞌa wení kísau aantemba máéro siyáifo emó sénda ímba miyá ónaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","waántáwanko auwéna kúwasa wíyómpakemba Maníkóní kísau-waasi kumésa Ísumba áwaꞌnai uráawe. ");
INSERT INTO auy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yóni marará-káwáágón-áwíꞌa Érotintafena séna sáwíꞌa uráiye siyóntafena ándáfaꞌa máankowana méron-aai Ísu iséna Káríri-aempaꞌa wéna ");
INSERT INTO auy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Násareti-naopaꞌa ímba koména Kápaneamu-naopaꞌa koméraiye. Mindáópaꞌa Káríri-nonkwaaunkoni áwáífaꞌ-naopaꞌa Sépiyuraaniye Náfataraiye tísaafitantambo uráawiti mararáꞌó wéron-daopaꞌaniye. ");
INSERT INTO auy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ísu Kápaneamu-naopaꞌa koméromba naaófáꞌó Maníkón-aaimo simátímakowin-awiꞌa Áísáya agaimaréna siyónkaꞌa póna miyá uráiye. Wemá agaimaréna séna ");
INSERT INTO auy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sépiyuraaninte Náfatarainte mindárai tísaafiti marafáꞌá nonkwaaúnkóní áwáífaꞌa Yóndani-nonkoni menáípáꞌ-márágón-áwíꞌa Káríri-marafaꞌa méraawi fíꞌo-fiꞌon-kwaasisafeꞌa súnda ");
INSERT INTO auy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","minkwáásí túnáín-aempaꞌa mésa sámo kaipaꞌá awánánááwe. Maníkóní némpaꞌo túnáín-aempaꞌo méraawi sán-kátinkainiye agaimaréna siyónkaꞌa póna Ísu paápé éna miyá uráiye. ");
INSERT INTO auy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Minkánáá Ísu simátimindasafena ómbarena simátimena séna Maníkó wení waási kawáánimba ómbaraifo kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌá teró siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ísu Káríri-waaunkoni áwáífakafamba kúmba kaeꞌ-wáásíyáí mésarai awaaón-áwíꞌa Sáímoni moórá-awiꞌa Pítaa úwana áfákon-awiꞌa Énduruweꞌa mésarai miwítí kísau pósarai mófááꞌa to-tímapaꞌa wénesarai mareꞌmareꞌ-únámbá nompí tukésarai méroyana ");
INSERT INTO auy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ísu simátimena séna keséꞌa tekaiyó. Mófááꞌo toꞌmáímo tímapaꞌo wénoyantemba aú-kisau tíménakai wénekai kesáái simátímapaꞌa wéniyasa kempáꞌá teró súwasarai ");
INSERT INTO auy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","mimbáréꞌmáréꞌ-únámbá tuwésarai weséꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Weséꞌa kuyaná Ísu maréna kúmba kaeꞌ-wáásíyáí mésarai Sépétin-ááninkai awaaón-áwíꞌa Yémísi úwana áfákon-awiꞌa Yóniye tifowámpín-kwimái nompín-táómpimba méresa mareꞌmareꞌ-únámbá toꞌmayaa wéuwana Ísu minkáéꞌnárai táántowasarai ");
INSERT INTO auy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","minúwóíyáámbá tifowámbá mindómpín-táómpimba auwésarai Ísuweꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ísu Káríri-aempaꞌa naaóꞌ-naoꞌa wénena ámáán-daumpimpaꞌa Maníkó wení waási kawáánin-aai minásé-ááí kosimátímapaꞌa wénena fíꞌo-fiꞌon-tiꞌo ún-kwaasi asófatinkafaꞌa kúwana ");
INSERT INTO auy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","wenááigo Síriyaa-marafaꞌa naaóꞌ-naoꞌa wété úwasa fíꞌo- fiꞌon-tiꞌo ún-kwaasiye sáwí-amutanko tirumpimbó méron-kwaasiye tíyayaambo táúnkon-kwaasiye tíyayaambo pukón-kwaasiye miyámó un-kwáásí taawiyaꞌmaésa Ísumpaꞌa mátínkówana asófatinkena ");
INSERT INTO auy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","aambó wénumba sáwífaꞌnanka Káríri-aempakene Tékáporisi-aempakene Yérúsaremu-naopakene Yúndiyaa-aempakene Yóndani-nonkoni menáípákén-kwáásíyé miyáumai-naopaken-kwaasi wempáꞌá tóso uráawe. ");
INSERT INTO auy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ísu mérowasa sáwífaꞌ-waasimo tóso umbá tuwánéna omápaꞌa imérowasa wení waásisomba túwaandu uwaná ");
INSERT INTO auy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","simátimena séna ");
INSERT INTO auy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Maníkó súwaꞌnai ínkwae sewí Maníkó miwí kaweꞌá wéuwatinkena miwíyáꞌá wégawaaniye. ");
INSERT INTO auy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Miwífímbá sáwí-imayaa wéraisana tirunkó umbaí wétaiwai Maníkó miwí kaweꞌá wéuwatinkena fetóí wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kentúmo ímbo maimaésa wéiyowi Maníkó miwí kaweꞌá wéuwatinkaimba pósa siyáim-barama maénááwe. ");
INSERT INTO auy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Maníkó siyáintemba miyámó ónaemo wésewi Maníkó miwí kaweꞌá wéuwatinkena kaweꞌó úmaimo méraiyantafena kaweꞌ-íꞌa uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tirumbó wéuwatinkaawi Maníkó miwí kaweꞌá wéuwatinkena arumbá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tirumpinkémbó kaweꞌ-ááí aantemba wésewi Maníkó miwí kaweꞌá wéuwatinkaimba pósa Maníkómbá awánánááwe. ");
INSERT INTO auy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Waásifimbo farumó uwátinkaiyantafesa kísau wémaewi Maníkó miwí kaweꞌá wéuwatinkena kesí iyámpóín-owe síníye. ");
INSERT INTO auy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Maníkóntáfésamo imáyáamo ésamo arupíse úmaimo méraantafesa sáwíꞌa wéuwatinkaawe. Maníkó miwí kaweꞌá wéuwatinkena miwí wení waási-iꞌo ombá póna wégawaaniye. ");
INSERT INTO auy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kembiwímó kentáféꞌo fasiꞌámaimo méraantafesa mindásafesa sáwí-aai simátinkesa sáwíꞌa uwátinkesa fíꞌo-fiꞌon-karoꞌ-aai simátínkáámba Maníkó kembiwí kaweꞌá wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Naaófáꞌó Maníkón-aaimo simátímakowimo sáwíꞌo uwátínkaraantemba káféꞌa sáwíꞌa wéuwatinkaamba tirunkó kaweꞌá wéinaꞌa aamoí éꞌa wíyómpakemba kentí kaweꞌ-méyámbá maénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ísu simátimena séna marapáꞌó méraan-kwaasifimba méꞌa uwígómó ásémo intenkáámbá wéowe. Miyá wéombanifo uwímó sáwíꞌo énamo imbá ímba kaweꞌá úmai kéna ímba áséma éna sáwísankaamba isasá aampaꞌá tukésa wénowe. ");
INSERT INTO auy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Marapáꞌó méraan-kwaasifimba méꞌa sámo kaintenkáámbá wéowe. Omápaꞌo wérain-daopaꞌo mósá awánaantemba kembiwí méraawini áwáuma wéawanaawe. ");
INSERT INTO auy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iyamá ómbá kúraꞌmaresa ímba aúpáꞌá maráíyamba aforaꞌá makésa mindáópaken-kwaasi awánánááwe. ");
INSERT INTO auy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Miyáumai sámo kaintembá waásifimba méꞌa sán-kátinkaiyasa kentí kawe-kísáú tuwánésa kentifo wíyómpaꞌo méraiwain-awiꞌa mósá maránááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ísu minááí simátimena séna ímba kentáféꞌa séꞌa Mósese siyáin-aine Maníkón-aai simátímakaawi siyáan-aine ifáꞌá túwáíwaiye ímba seró. Maníkón-aai siyáan-aai ímba tuwánáúmpo siyáanteniꞌo úmaimo paápé índasafeꞌa kunkáumne. ");
INSERT INTO auy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Simátíménda ísáaro. Wíyómba maramá wéraisana póna Maníkón-aai waéꞌwaeꞌa wéiye. Maníkón-aaigo seyaafáꞌá waéꞌwaeꞌa wéimba póna minááígómó siyáinten-úmai seyaafá-tántááꞌá paápé íníye. ");
INSERT INTO auy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Miyáumai Maníkón-aaifinkembo karoꞌ-ááímó taraisésamo fíꞌowantafesamo sésamo wéundantemba miyá índa mindá kanaán-iye síyanamo éna Maníkó séna kesí waási kawáánúnda-waasifinkemba ímba fasiꞌaén-kwáásín-owe sínífo Maníkón-aaimo taawiyafésamo simátimesamo sésa Maníkón-aai ísáaro wésewisafena Maníkó séna kesí waási kawáánúnda-waasifinkemba óraaꞌ-waasin-owe síníye. ");
INSERT INTO auy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Moórá-aai simátíménda ísáaro. Ámáán-kawaa-waasiye ámáámba sen-kwáásíyé sésa Maníkómó siyáintemba úmai méraumnemo sembá karoꞌá wésewe. Miwímó ontembó kembiwímó éꞌa Maníkómó kawáánipaꞌa ímba méꞌa Maníkómó siyáintemba éraiꞌa miyámó éꞌo éꞌa Maníkómó kawáánipaꞌa ménaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ísu maarán-ááíwáráꞌá siyáiye. Naaófáꞌá Mósese kentíwáꞌnásafena simátímakain-aai ísaraamba maará siyáiye. Ímba tínkamiyasa púwóro. Miyámó íyasamo ésa aaifimbá maitinkánááwe siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","simátimeꞌa súne. Miwítí waásisafesa aaisambá wétiyiyawi aaifimbá maitinkáíyamba mindá kanaán-iye. Miwítí waásisafesa sáwí-aai simátínkááwi tíꞌmaesa aaimó ísááwitopaꞌa tíyasa aaifimbá maitinkáíyamba mindá kanaán-iye. Miwítí waásisafesa uwó-wáásíyáꞌó úwoi-waasiyaꞌo sésa símai sáwíꞌa wéiyawi ónkaifaꞌo iyamó wégaipaꞌa méraiyamba mindá kanaán-iye. ");
INSERT INTO auy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Miyán-ááí imáyáa ombá Maníkóntáféꞌo imáyáamo éꞌo moórá-tantaaꞌo aménaeꞌo óraaꞌ-amaan-daumpaꞌo koméꞌo éꞌa kentí waási aaí taꞌótokaiyaꞌo táákaꞌo makéꞌo éꞌa ");
INSERT INTO auy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Maníkómbó amíyan-tantaaꞌa óntan-taaregoni ewaaꞌá mámareꞌa minááí koísámai arupíse uwásuweꞌa kouweréꞌa Maníkómbá áméro. ");
INSERT INTO auy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aaimó simátinkanae síyawimo tíꞌmae wíyasa aampaꞌá mósimai paápé uwásuwesa koró. Óraaꞌ-waasimo mátimiyasamo ésa i-wáásí timíyasa ándá-naumpaꞌa tinkánááwe. ");
INSERT INTO auy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ímbo miyámó íyasamo ésa ándá-naumpaꞌa mótinkaiyasa ímba ááéma taiꞌánaumne sésa seyaafáꞌ-méyámbá tímatuwaiyasa faútinkanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ísu minááí simátimena séna naaófáꞌá Mósese simátímakain-aai ísaraamba maará siyáiye. Fíꞌowi tuwaainíntóné tuwaaiꞌwainté ímba nóro siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","simátimeꞌa súne. Moóráwigo moórá-inimbo awánénamo tafisénae sénamo índa ímba aforaꞌá ínífo imáyáa aantemba tafisínana Maníkó séna imáyáafinkemba éꞌa wétafisiye síníye. ");
INSERT INTO auy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Túrankomo sáwíꞌo ínaꞌa misáwí-ámpáꞌá kúnafo séꞌa moórá-turamba fitúwáaro. Kae-túrántámbó awánéꞌo éꞌa ónkaifaꞌo wíyamba mindá sáwíꞌan-iye. Sáwíꞌo uráinda maisuwéꞌo méraiyamba mindá kaweꞌán-iye. ");
INSERT INTO auy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tiyáánkomo sáwíꞌo ínaꞌa misáwí-ámpáꞌá kúnafo séꞌa moórá-tiyaamba arátúwáaro. Kae-tíyáámbó wérainaꞌo éꞌa sáwí-marupaꞌo iyamó wégaipaꞌa wíyamba mindá sáwíꞌan-iye. Sáwíꞌo uráinda maisuwéꞌo méraiyamba mindá kaweꞌán-iye. ");
INSERT INTO auy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Naaófáꞌá Mósese maará siyáiye. Moóráwigo awaainínkómbá aiꞌmátuwaindawi aúfáífimba agaimaréna séna kesuwaainímbá aiꞌmátuwaumne séna agaimái amíno siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","simátimeꞌa súne. Awaainínkó ímba moórá-waasigoe wénisana awaaikó aiꞌmátuwaisana minínínkó kówéna moórá-waasi komaiyéna minínínkó aú-waasigoe wénimba sáwí-ankaꞌa wéniye. Aifaꞌ-áwááíkómó aiꞌmátukaintafena miyá wéiye. Moórá-waasigo aiꞌmátukain-inimbo wémaimba wewáráꞌá umémbá wémaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ísu maarán-ááíwáráꞌá siyáiye. Naaófáꞌá Mósese simátímakain-aai ísaraamba maará siyáiye. Fasiꞌaénkómpátá miyá ónaumne síyamba karoꞌá sefáínifo éraiꞌa séꞌa miyán-oro siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","simátimeꞌa súne. Kemó miyá ónaumnemo síyambo éꞌa éraiꞌa miyán-oro. Kemó ímbo miyá ónaumnemo síyambo éꞌa éraiꞌa ímba miyán-oro. Maníkó káráwiyaiwi wíyómpaꞌa méraifo Maníkón-áwíkaꞌa ímba matuwéꞌa seró. ");
INSERT INTO auy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Maníkó marapáꞌá káráwiyaipaꞌan-ifo ímba mararáꞌá matuwéꞌa seró. Yérúsaremu-naopaꞌa Maníkó káráwiyain-daopaꞌan-ifo ímba mindáópaꞌa matuwéꞌa seró. ");
INSERT INTO auy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Fafután-áꞌnóntáúráꞌá kaantún-aꞌnontau ímba kanaán-ureꞌa kaantún-aꞌnontauraꞌa fafután-áꞌnóntáú ímba kanaán-uránááfo tiꞌnónkáꞌá ímba matuwéꞌa seró. ");
INSERT INTO auy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kemó miyá ónaumnemo síyambo éꞌa maarán-ááí aantemba seró. Ewé miyá ónaumne seró. Kemó ímbo miyá ónaumnemo síyambo éꞌa maarán-ááí aantemba seró. Aꞌáo ímba miyá ónaumne seró. Simátimunda-aai waántáwankon-imayaafinkeniꞌa wéowe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ísu minááí simátimena séna Mósese simátímakain-aai ísaraamba maará siyáiye. Moóráwigomo moóráwigoni aúrambo fituwáínasamo ésa wen-ánóndáá wenaúramba fituwánááwe. Moóráwigomo moóráwigoni áwááyaamba pótuwainasamo ésa wen-ánóndáá wenáwááyaamba pótuwanaawe siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","simátimeꞌa súne. Sáwíꞌo uwátinkaiyaꞌa ímba anondáá miwí sáwíꞌa uwátínkáaro. Tááꞌo tuwaumíyaꞌo éꞌa ímba anondáá tínkameꞌa anekaꞌá waé-timiyasa tuwaumónááwe. ");
INSERT INTO auy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kentí unáánkwátóisafesamo maénae sésamo tíꞌmaesamo aaimó ísáín-waasigompaꞌa kurésamo síyaꞌo éꞌa ímba aꞌáo síyamba paákákén-únánkwátóiwaraꞌa tíméro. ");
INSERT INTO auy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aampaꞌó taꞌótoresamo sésa kentáásí moparáwímbá kárikaꞌa súwaꞌnai orómó síyaꞌo éꞌa ímba aꞌáo síyamba úwoima ayáátáákaꞌa túwaꞌnai oro. ");
INSERT INTO auy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Moórá-tantaaꞌa simiyó síyaꞌo éꞌa úwoi tíméro. Moórá-tantaaꞌa wááu simiyó síyaꞌo éꞌa miyán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ísu minááí simátimena séna naaófáꞌá simátímakain-aai ísaraamba maará siyáiye. Kentí waási-imayaan-oro. Kentí namuro-wáásí tíyámba uwátínkáaro siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","simátimeꞌa súne. Kentí namuro-wáásí imáyáa timéꞌa sáwíꞌo uwátínkááwisafeꞌa túwaꞌnai úmai Maníkómpáꞌá inaí seró. ");
INSERT INTO auy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Miyámó ombá wíyómpaꞌo kentifo méraiwaini iyámpóí-iꞌa wéowe. Maníkó miyáumai kaweꞌá uwátinkena aaí sisaná aaꞌá kaisaná kaweꞌ-wáásíyáꞌé sáwí-waasiyaꞌe aaꞌá kaisaná Maníkó aaí sisaná aaꞌá tisaná arupísemo on-kwáásíyáꞌé ímbo arupísemo on-kwáásíyáꞌé aaꞌá wétiye. ");
INSERT INTO auy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Seyaafáꞌnánká kentí waási-imayaamo wéowasamo ombá anondáá miwí-ímáyááwáráꞌá wéowe. Taakisimó máén-umen-kwaasi ímba kaweꞌ-wáásí ombánifo miwítí waási-imayaamo owasamó ombá anondáá miwí-ímáyáá wéowe. Miyáumaimo kentí waási-imayaa aantembo íyanamo éna Maníkó ímba kaweꞌ-méyámbá timínífo kentí namuro-wáásíwáráꞌá imáyáa tíméro. ");
INSERT INTO auy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Seyaafáꞌnánká kentí waási-iꞌa úmai kaweꞌá wéuwatinkaawe. Maníkóní ambó ímbo wéaraaiwaewiwaraꞌa miyá wéowe. Miyámó onten-úmai kentí waási aantemba ímbanifo kentí namuro-wáásíwáráꞌá kaweꞌá uwátínkáaro. ");
INSERT INTO auy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kentifo wíyómpakewi kaweꞌ-íꞌa úmai méraimba mindásafeꞌa imáyáa éꞌa kaweꞌ-íꞌa úmai méraaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ísu minááí simátimena séna tuwímbaisafeꞌa tirumbá uwátinkeꞌa túwaꞌnai íyamba ímba maarán-ímáyáá éꞌa waási méraiyankaꞌa wétuwaꞌnai-onasa óraaꞌ-waasin-iye síwae-imayaa ímba íyamba úwoi túwaꞌnai oro. Miyán-ímáyáámó wéeꞌo túwaꞌnai íyanamo éna kentifo wíyómpakewi kaweꞌ-méyámbá ímba timíníye. ");
INSERT INTO auy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Óntamo ímbo makáawimo túwaꞌnai íyamba waási aamoí uwásinkaiwae-imayaa ímba éꞌa ímba óraakaꞌ-oraakaꞌa síyamba úwoi túwaꞌnai ónááwe. Kaumbo-kaeꞌ-ááíwáráꞌ-wáásí ámáán-daumpaꞌe aampaꞌé toruparésa óraakaꞌo sembá óntamo ímbo makáawimo tímémba ímba miwí-ímáyáá ombá wétimesa kesúwíꞌa mósá maráíwae sésa wétimewe. Éraiꞌa simátimeꞌa súne. Mindámo tímén-anondaa miwí túwíꞌo mósá máráámba éꞌa mimbéyámbá wémaewe. ");
INSERT INTO auy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Óntamo ímbo makáawimo túwaꞌnai íyamba kesí waási suwánaafo séꞌa waásimo ímbo méraiyankaꞌa túwaꞌnai oro. Miyámó ombá kentifo aúpáꞌó wéomba tuwánaiwai póna kaweꞌ-méyámbá timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ísu minááí simátimena séna Maníkómpáꞌó inaimó síyamba kaumbo-kaeꞌ-ááíwáráꞌ-wáásímó sentembá ímba miyán-oro. Miwí sésa waási suwánésa aamoí uwásinkaiwae-imayaa ésa ámáán-daumpaꞌa mésa waásimo tóso on-áémpáꞌá mésa inaí wésewe. Éraiꞌa simátimeꞌa súne. Miwímó miyámó wéon-anondaa miwí túwíꞌo mósá wémaraamba mimbéyámbá wémaewe. ");
INSERT INTO auy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Miwí miyá wéofo Maníkómpáꞌá inaí síyamba kentí naaúmpaꞌa kembiwí aantemba iméꞌa kentifombó ímbo aneꞌó awánaawimpaꞌa inaí síyana aúpáꞌó wéomba tuwánaiwai póna iséna kaweꞌá úmai túwaꞌnai íníye. ");
INSERT INTO auy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Maníkómpáꞌá inaí síyamba úwoi-aaiyaamba ímba símai tafisénááwe. Maníkóní aambó ímbo arááíwáéwi sésa tafisímai-aaisa senanasá súwaꞌnai íníye sésa úwoi-aaiyaamba símai wétafisefo ");
INSERT INTO auy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ímba miyán-oro. Kentifombó Maníkómpáꞌó miyám-baaran-aaisafeꞌo wéaisai-eꞌo súwaꞌnai íníyemo síyamba éꞌa awánaraimba póna túwaꞌnai íníye. ");
INSERT INTO auy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Maníkómpáꞌó aaimó síyamba maará seró. Kentáásifowao wíyómpaꞌo méraandawi enáwíꞌa íyáákarain-awita mósá wémaraumne. ");
INSERT INTO auy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ení nombaragó seyaafá moórá-mora-waasi tirumpimbá kumíno. Wíyómpakewimo ení ámáámbo arááíwáéntemba marapátá méraundawisa miyáumai arááíwáéno. ");
INSERT INTO auy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Káfé-kanaa-tomba kentáá simiyó. ");
INSERT INTO auy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Waásimo aoisaambó uwásinkaiyata anondáá ínta miyásá uwátinketa miwítí aoisaambá maitiyúwáana miyáumaisa kentáásí aoisaambá maisiyuwaaó. ");
INSERT INTO auy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sáwí-yantaakomo kentáá maꞌmáímo awánáíndasafenamo ínamo e wasiyuwaaó. Seyaafáꞌ-máꞌú-yántáákó kentááfímbá tifó sé maisiyuwaaó.  Ení waási kawáánúmae wéiyonana ení fasiꞌaémbá waéꞌwaeꞌa úmae wéiyisana enáwíꞌa óraaꞌa úmae wéiyimba éraiꞌ-aain-iye.  Miyán-ááí Maníkómpáꞌá seró. ");
INSERT INTO auy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sáwíꞌo uwátínkaraamba ímbo anondáámo sáwíꞌo éꞌo ifátuwaiyanamo éna kentifo wíyómpakewi kembiwímó sáwíꞌo wéomba túwaꞌnai ena maitiyuwáínífo ");
INSERT INTO auy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","sáwíꞌo uwátínkaraamba úwoimo imáyáamo úmae iyéꞌo ímbo ifátuwaiyanamo éna kentifo wíyómpakewi kembiwímó sáwíꞌo wéomba ímba maitiyuwáíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ísu minááí simátimena séna Maníkómpáꞌó inaí aantembo séꞌa tómbá wéawentan-omba aasásóíꞌ-wáásímó ontembá ímba miyán-oro. Miwí sésa waási suwánésa sésa kaweꞌá ésa tómbá wéawentan-owe síwae sésa tómbó ímbo naanten-tóíꞌá matuwésa méraawe. Éraiꞌa simátimeꞌa súne. Miwítí méyámbá miwí túwíꞌa mósá wémaraam-beyamba éꞌa maiyáawe. ");
INSERT INTO auy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Miwí ésa miyá wéofo kembiwí tómbá wéawentan-omba tóiꞌa wisukéꞌa tiꞌnóntáu paaséꞌa túmai kaweꞌá úmaraiyasa ");
INSERT INTO auy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","waási tuwánésa tómbá wéawentan-owe ímba síyana kentifo tuwánéna kaweꞌ-méyámbá timíníye. Kentifon-aneꞌó ímbo awánaawi aúpáꞌó ombá awánaiwai kaweꞌ-méyámbá timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ísu minááí simátimena séna marapáꞌó méraamba sáwífaꞌ-ontama ímba máráaro. Maráíyan-ontama ufóíyaraamba ínana waígo náínana táúkaaꞌa ínasa mindámbá sáwíꞌa uwásuwesa umémbá maénááfo sáwífaꞌ-ontama ímba maréꞌa ");
INSERT INTO auy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kawe-kísáú maíyana kentí kawe-tántááꞌá wíyómpaꞌa wéíniye. Wíyómpaꞌa wéraimba ufóíyaraamba ímba ínana waígo ímba náínana táúkaaꞌa ímba ínasa waási ímba umémbá maíyana úwoi wéíniye. ");
INSERT INTO auy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Marapáꞌó kentí óntamo wérainanamo éna marapátáféna tinkáínífo wíyómpaꞌo kentí óntamo wérainanamo éna wíyómpatafena tinkáíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ísu minááí simátimena séna túranko kentí imáyáafimbo sámo kain-tántááꞌán-iye. Túrankomo kaweꞌó úmaimo awánáínanamo éna seyaafáꞌ-ímáyáá sáma káínífo ");
INSERT INTO auy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","túrankomo ímbo kaweꞌó úmaimo awánáínanamo éna seyaafáꞌ-ímáyáá tuwinkáíníye. Marapá-tántááꞌ-ímáyáá aantembo íyanamo éna kempímbó sámo kain-tántááꞌó ímbo wénamo éna kumeuꞌó í-tántáákó óraaꞌa úmai wéíniye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ísu minááí simátimena séna ímba kanaaꞌá kae-káwáá-wáásítí kísau wémaewe. Miyámó ésamo ésa moóráwigomba aamoí ésa moóráwigomba ímba aamoí uwánkanaawe. Miyámó ésamo ésa moóráwigoni kísau kaweꞌá úmai maésa moóráwigoni kísau tuwesaraí ónááwe. Miyáumai Maníkóní kísaumo maéꞌo éꞌa sáwífaꞌ-ontamba maénaumne-imayaa ímba úmae iyónááwe. Sáwífaꞌ-ontamba maénaumne-imayaamo éꞌo éꞌa Maníkóní kísau ímba maénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ísu minááí simátimena séna minááí imáyáa éꞌa simátimeꞌa súne. Méraamba ímba óraaꞌ-imayaa éꞌa tómbó náíyantafeꞌa ímba óraaꞌ-imayaa éꞌa kentúraꞌo unáánkwátóimo íyantafeꞌa ímba óraaꞌ-imayaan-oro. Tómbó náíyamba úwoisambanifo waásimo méraamba óraa-tantaaꞌan-iye. Unáánkwátói íyamba úwoisambanifo waási túma óraa-tantaaꞌan-iye. ");
INSERT INTO auy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Numagómpáꞌá imáyáan-oro. Numagó ímba kísau éna tómbá fákáꞌmai naaúmpaꞌa makéna wénaifo kentifo wíyómpakewi miwítí tómbá tímísasa wénaawe. Maníkón-aúrankaꞌa kemá waási numagómbá íyáákaraamba póna kentí tómbó éna timíníye. ");
INSERT INTO auy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kembiwímó óraaꞌ-imayaamo éꞌo éꞌa maíyan-kanaa ímba kanaaꞌá ayáátáákaꞌa méranaawe. ");
INSERT INTO auy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Unáánkwátói íyantafeꞌa ímba óraaꞌ-imayaa éꞌa waiwandáánkáꞌá imáyáan-oro. Waiwandáánkó ímba kísau éna ímba wení unáánkwátói makáifo ");
INSERT INTO auy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","simátimeꞌa súne. Naaófáꞌá Yúndaa-waasiti óraakon-awiꞌa Soromoní sáwífaꞌ-unankwatoiye koꞌnaariríyé makówi úwasa waási awánésa kaweꞌán-iye sumbánifo waiwandáán-aramba awánésa óraa-kaweꞌan-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ufáꞌá koꞌnaarirí-tántááꞌé séna waiwandáámbá Maníkó makáiye. Umá ímba waéꞌwaeꞌa ínífo káféꞌa ínasa aafáyáa waási agaisuwáíyamba Maníkó mintántááꞌá imáyáa éna koꞌnaarirí-tántááꞌá makáiye. Miyáumai Maníkó waásisafena imáyáa éna kentí unáánkwátói timínífo kembiwí Maníkóntáféꞌa ímba kanaaꞌá wésuwaꞌnai-iwain-iye ímbo seráámbá wésewe. ");
INSERT INTO auy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Maníkó wétuwaꞌnai-imba póꞌa tóné nonémó náíyantafeꞌa ímba óraaꞌ-imayaa éꞌa unáánkwátóimo íyantafeꞌa ímba óraaꞌ-imayaan-oro. ");
INSERT INTO auy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Maníkóní aambó ímbo arááíwáéwi tóné nonémó náíyantafesa óraaꞌ-imayaa wéowe. Tómbó nombó ímbo wéneꞌo éꞌa púwófo séna kentifo imáyáa éna wétimifo imáyáa ímba óraaꞌ-imayaa wéeꞌa ");
INSERT INTO auy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Maníkómó wení waásimo kawáánintafeꞌa aifaꞌá imáyáa éꞌa wembó arááímo tainíꞌo wéontafeꞌa imáyáa éꞌa miyámó owaná mintántááꞌá wétimiye. ");
INSERT INTO auy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aúnkáwe aafáyáawe paápé índa-tantaatafeꞌa ímba óraaꞌ-imayaa íyana tirunkó umbaí táíno. Káféꞌa wérain-tantaatafeꞌa imáyáa éꞌa aafáyáamo paápé índa-tantaaꞌa awánéꞌa imáyáa éꞌa moórá-kanaa moórá-kanaamo paápé índa-tantaaꞌo awánaantemba imáyáan-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ísu minááí simátimena séna tuwánéꞌo éꞌa sáwí-waasiye siyanamó éna Maníkó kentáfénawaraꞌa miyá sínífo tuwánéꞌo éꞌa sáwí-waasiye sefó. ");
INSERT INTO auy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kaweꞌ-ááí wésimatimeꞌa sáwí-aai wésimatimeꞌa íyantafena Maníkó kembá miyá íníye. Tíménteniꞌa úmai Maníkó miyáumai timíníye. ");
INSERT INTO auy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kentúrampimba iya-arumbá wéraisaꞌo ombá ímba awánaamba kentí waási tuwánéꞌa enaúrampimba ayaantambá wéraiye wésefo ímba miyá seró. ");
INSERT INTO auy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kentúrampimbo iya-arumbó ímbo awánaamba nóra séra kentí waási túrampinkemba tiyaantambá maitiyuwánae wéseo. ");
INSERT INTO auy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaumbo-kaeꞌ-ááíwáráꞌ-wáásín-ofo kentúrampinkemba iya-arumbá maisukéꞌa tuwánéꞌa kentí waási túrampinkemba tiyaantambá kanaaꞌá maitiyuwánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kawe-tántááꞌó iyánkómbó ímbo áméntemba Maníkón-aai taraisíyawi ímba simátíméro. Simátimiyasamo ésa karaánááꞌa simátinkanaawe. Kawe-tántááꞌó póígombo ímbo áméntemba Maníkón-aai ímba sínkáíye wésewi ímba simátíméro. Simátimiyanamo éna minááígó fiyúndáraamba toꞌwíníye. ");
INSERT INTO auy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ísu séna Maníkómpáꞌó inaimó wésemba áísai úmae wéiyiyana timíníye. Áántamaeꞌo wéiyiyana kentáái isáíníye. Wésaafa úmae iyíyana Maníkó aráátiminiye. ");
INSERT INTO auy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Áísai íyanamo éna Maníkó timíníye. Wéaantewanamo éna Maníkó kentáái isáíníye. Saafámo íyanamo éna Maníkó aráátiminiye. ");
INSERT INTO auy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kemá iyámpóíwaraꞌ-waasi kentáánintombo kisaamá simiyómó síyaꞌo éꞌa ímba óntamba timíyamba kisaamá timénááwe. ");
INSERT INTO auy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mófááꞌa simiyómó síyaꞌo éꞌa ímba iyaankafayaambá timénááwe. ");
INSERT INTO auy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Énifo sáwí-waasi ombánifo kentáánintomba kawe-tántááꞌá wétimefo wíyómpakemba kentáásifowa kaweꞌ-aantemba iwáí póna áísai íyawimo éna kawe-tántááꞌá timíníye. ");
INSERT INTO auy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kembó tirááímo táínda-iꞌo úmaimo wétuwaꞌnai-iyaꞌa miwí miyáumai túwaꞌnai oro. Minááímó simátimunda Mósese siyáin-aaiye Maníkón-aai simátímakowi siyáan-aaiye minkáéꞌ-ááígóní áwáuma wésimatimune Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ísu séna kaeꞌ-óntámá wéraisaꞌa káriꞌ-ontafimba íyáféráaro. Óraaꞌ-ontama óraaꞌ-ankoni ontamán-iye. Maníkóní némpaꞌo maéꞌmaeꞌo íyan-aempaꞌa minórááꞌ-ámpáꞌá wéwesa sáwífaꞌ-waasi minóntáfímbá wégowe. ");
INSERT INTO auy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Káriꞌ-ontama umbai-ánkóní ontamán-iye. Aúíꞌo úmaimo maéꞌmaeꞌo íyan-aempaꞌa minúmbáí-ámpáꞌá wéwesa sesimáí-waasi aantemba minóntámá saafá úmai awánésa wéiyaferaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ísu minááí simátimena séna tuwímbai karoꞌá simátimesa sésa Maníkón-aai simátimunda-waasi úne wésewi miwí káráwimai méraaro. Sipisípi-poigomo aáno úmaimo máíntemba miwí karoꞌ-ááwéyáá úmai wénombanifo kaweꞌ-ímáyáá sáwíꞌa wéuwatinkaan-kwaasin-owe. ");
INSERT INTO auy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Miwítí áwáumo awánánaeꞌo éꞌa miwítí kísau awánéꞌa miwímó méraawini áwáuma awánaaro. Fekómó éna ímba áwíyanda-arankaamba iyáínífo feꞌ-arambá iyáíníye. Antirígómá afoꞌafááꞌ-arankaamba ímba iyáínífo antirí-aramba iyáíníye. ");
INSERT INTO auy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Miyáumai kawe-táígó kaweꞌ-árámbá íyáísana sáwí-taigo sáwí-aramba wéiyaiye. ");
INSERT INTO auy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kawe-táígó ímba sáwí-aramba íyáísana sáwí-taigo ímba kaweꞌ-árámbá íyáísasa ");
INSERT INTO auy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","kaweꞌ-árámbó ímbo íyáín-taima ayáímai iyafímbá wéagaisuwaawe. ");
INSERT INTO auy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Miyáumai minkáróꞌ-wáásítí kísau awánéꞌa miwítí áwáuma miyáráán-úmai awánánááwe. ");
INSERT INTO auy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kentáfésa kesí Fasiꞌaénkón-iye wésewiwaraꞌa Maníkó ímba seyaafáꞌnánká káráwinda póna kesifo wíyómpakewimbo arááímo tainíꞌo wéowi aantenkaꞌa káráwiyiniye. ");
INSERT INTO auy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Maníkó seyaafáꞌnánká méraawini áwáusafesa tísai índa-kanaa tíndaraꞌa kentáfésa sáwífaꞌ-waasi sésa Fasiꞌaénkóo ení fasiꞌaéntámbá Maníkón-aai simátímakaumne. Ení fasiꞌaéntámbá waási tirumpinkémbá sáwí-amutamba maitíyukaumne. Ení fasiꞌaéntámbá fíꞌo-fiꞌon-kawe-kisau ímbo awánaraan-kisau maiyáumne síyambanifo ");
INSERT INTO auy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","simátimeꞌa súne. Ímba kesí waási éꞌa sáwí-kisau wémaen-kwaasin-ofo kóro kemá sénaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ísu minááí simátimena séna kesáái isésa wéaraaiwaewi miyán-kwáásímó simátíméndaraꞌa ísáaro. Kaweꞌ-ímáyááwáráꞌ-wáásí fasiꞌaén-dámbá ónae sésa maiꞌá uꞌmaésa kumémesa óntankaꞌa naamayáámba múfaimai naambá úmaraiyana ");
INSERT INTO auy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","aaꞌá téna óraaꞌ-nomba fínana mindámbá ímba tawisínda fasiꞌámai wéena óntankaꞌ-namba póna úwoi wéíniye. ");
INSERT INTO auy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Énifo kesááimo isésamo ímbo kaweꞌó úmaimo wéisaiyawi miyán-kwáásímó simátíméndaraꞌa ísáaro. Naambá ónae sésa ímba maiꞌá ukésa íyamba nonáámááíyaꞌa paákáꞌá úmakaiyana ");
INSERT INTO auy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","óraaꞌ-aꞌa téna nombá fiyéna mindámbá tawísísuwainana sáwíꞌa íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ísu minááí simátimuwasa túwaandu urón-kwaasi isésa ");
INSERT INTO auy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ámáámba sen-kwáásímó sentembá ímba sifó óraaꞌ-waasigoraamba siyé sésa táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Táátafesa uwaná Ísu minómápákémbá kumúwasa sáwífaꞌnanka ánaaemba arááíwáúwana ");
INSERT INTO auy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","moóráwigo námombo kón-kwaasi Ísumpaꞌa téna óraakon-iye séna aísamaifimba takífaena séna kentáfénamo ankáínamo e kanaaꞌá aúíꞌa uwásinkainone súwana ");
INSERT INTO auy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ísu ayáámba aneꞌá taꞌótorena séna miyá ónaumpo enáúraꞌa karefóꞌa kawáúwiye súwana minúwóíyáámbá kawáúguwana ");
INSERT INTO auy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ísu séna enáúraꞌo uwánkaunda-aai simátimenafo enáúraꞌa kawáúwifo naaófáꞌó Mósesemo siyáintemba ámáán-kisau-waasifaꞌa wéma enáúma máaraatime póíma tímínasa Maníkóntáfésa ísámai tufúꞌmai agaíyasa seyaafáꞌnánká awánésa áúrakemba kawáúwiye sénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ísu minááí simásuwena Kápaneamu-naopaꞌa kúwana Rómu-i-waasiti kawáágó ména Ísumpaꞌa téna óraaka séna ");
INSERT INTO auy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","óraakoo kesí kísau-waasi naaúmpaꞌa ména óraaꞌ-aiꞌa isaná áúwawaako ímba úwaauwa wéisana méraiye súwana ");
INSERT INTO auy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ísu séna koasófankanaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","wemá séna kemá káriꞌ-waasi úmpo emá óraaꞌ-waasi ómpo kesí naaúmpaꞌa íyínda uwófíꞌa ínompo ifátuwe aaí aantemba sinaná kesí kísau-waasi asófáíno. ");
INSERT INTO auy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kewáráꞌá kawáá-kísáúgóní áwáuma awánaraunda kesí kawáágó sisaꞌá wení kísau wémaeꞌa kesí i-wáásísáféꞌa súnasa kesí kísau wémaewe. Moóráwigontafeꞌa séꞌa waaó súnana wéwisaꞌa moóráwigontafeꞌa séꞌa tiyó súnana wétisaꞌa kesí kísau-waasisafeꞌa miyá uwómó súndantemba miyá wéofo úwoi aaí aantemba sinaná kesí kísau-waasi asófáíno súwana ");
INSERT INTO auy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ísu minááí iséna áátafena éna wembó arááíwaꞌmaesamo kun-kwáásísóntáféna séna simátimeꞌa súne. Minkwáásí Rómu-waasigo kentáféna súwaꞌnai í-fásíꞌáémbá tokáiye wésifo kesí waási Ísareri-waasifinkene fíꞌon-kwaasifinkene ímba miyán-ááí wésewe. ");
INSERT INTO auy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Simátíménda ísáaro. Aafáúmó íyáúsipakene kúwáféráípakene fíꞌo-fiꞌon-aempakene sáwífaꞌnanka tóso ésa Maníkó wení waásimo kawáánipaꞌa mésa kentíwáꞌná Émbaramuwe Áísáakiye Yékopuwe tómbá náíyambanifo ");
INSERT INTO auy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","mindárau tísaafitantambo uráawi miwí túma maimaé wéiyesa sésa Maníkó kawáánipata ménaumne wésewi tíꞌmaena kumeuꞌó in-áémpáꞌá tiyuwáínasa ifiꞌá wétesa sáwíꞌa úmai mésa túwááyaamba umpufuwónááwe Ísu simátimena ");
INSERT INTO auy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Rómu-i-waasiti kawáágóntáféna séna emó kentáfémo séndantemba miyá onaná asófainifo ení naaúmpaꞌa waaó súwana minkánáá wení kísau-waasi asófankaraiye. ");
INSERT INTO auy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ísu Pítaani naaúmpaꞌa iména awánómba Pítaan-áráandaomba áuiya kówana mérowana ");
INSERT INTO auy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ayáánkaꞌa taꞌótorowana mináúíyá tasí úwana íyáfasinkena tómbá kúfuꞌa uwátímakaiye. ");
INSERT INTO auy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Úwasa fenómpinkaꞌa sáwí-amutamba tirumpimbó méron-kwaasi tíꞌmaesa Ísumpaꞌa túwana aaí séna sáwí-amutamba tirumpinkémbá maitiyuwówasa kóuwana tíꞌo ún-kwaasi asófatinkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Áísáya agaimaréna Ísuntafena séna síꞌo wéimba asófasinkena síꞌo wéimba tasí uwásínkaraiye agaimaréna siyónkaꞌa póna Ísu miyá uráiye. ");
INSERT INTO auy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Moórá-kanaa sáwífaꞌnanka tóso ésa Ísun-amándáraꞌa mérowana tuwánéna wení waásisafena séna nonkwaaúnkóní menáípátá kónae súwana ");
INSERT INTO auy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","moóráwigo ámáámba sún-kwaasigo téna séna seyaafáꞌ-náópaꞌo níndafaꞌa eséꞌa nónaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ísu minkwáásígómbá áísai ena séna emó sénda súnda-aai imáyáan-uwo. Waankó taaiyaifimbá wáísana numagó ánáamba úmarena wéwaifo kemá waási úranko ímba naambá úmareꞌa wéwaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","moóráwigo wembó arááíwauwai séna óraakoo méraanana kesifo puwína utámareꞌa embá arááíwaenaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ísu séna ímbanifo kesáái ímbo isésamo pukáan-kwaasiyaamba owí puwíyan-kwaasi utátinkanaafo emá kembá sirááíwauwo Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ísu minááí simámena wení kísau-waasiye nompín-táómpimba íyátesa nonkwaaúnkóní menáípáꞌá kumbá ");
INSERT INTO auy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ísu aún-kwaigurówana minkwaaúmpáꞌá óraa-fiyunda torówana nonkó tufántááfan-éna nompín-táómpimba ówitowasa kúwáfekunafo sésa ");
INSERT INTO auy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","inkaisésa Ísumba koaúsésa sésa Fasiꞌaénkó puwúnafosa súwaꞌnai uwo suwaná ");
INSERT INTO auy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","nóintafera wéinkaisoo. Kentimankúnkúmba káriꞌan-iye séna íyáfasinena fiyúndágonte nonkóntétafena óraaka séna mafáékaiyo súwasarai fiyúndágoe nonkóeꞌa mafáúyana nonkó karáꞌnáguwana ");
INSERT INTO auy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","tááꞌa úwasa keáímbá sésa nóran-kwaasiyaꞌiyo. Fiyúndágoe nonkóeꞌa wenáái isaíyó sésa tiyáámba ufakésa táátafesa ésa siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Simásuwesa mindómpín-táómpimbo kumbá Káríri-marama tínaaempaꞌa wérowana Kégésaa-marama túrampaꞌa wérowasa mimbáráfáꞌá kumbá Ísu mindómpín-táómpinkemba kumúwasarai kaeꞌnárai wempáꞌá tiyááye. Minkáéꞌnárai sáwí-amutamba tirumpimbá mérowasarai waásimo utátínkón-ontan-aifaꞌa mésarai túwáífiya wéuyasa waási inkaisésa minkáéꞌnáraimo méroyapaꞌa ímba kuwasaráí minkáéꞌnárai Ísumpaꞌa tésarai ");
INSERT INTO auy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","óraaka sésarai Maníkón-ááninkoo sínkami-kanaa ímba tiyáisa sínkaminiyerai wétene suyasá ");
INSERT INTO auy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ewaaꞌá sáwífa-poima mésa umá wénowasa ");
INSERT INTO auy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","minkáéꞌnárai tirumpinké-sáwí-ámútántómbá Ísuntafesa sésa siꞌmátuwesaamo e mimpóí tirumpimbá siꞌmaraaó suwaná ");
INSERT INTO auy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","miyán-oro súwasa sáwí-amutantomba minkáéꞌnárai tirumpinkémbá kárúwesa póí-tirumpimba koférówasa mimpóísómbá seyaafáꞌá ámémpakemba tuwaantantésa nonkwaaúmpímbá kúwáférómba putásowasa ");
INSERT INTO auy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","póíyaꞌo tafíkówi awánésa minúwóíyáán-úmai naaópaꞌa wésa póígomo úne Ísumo minkáéꞌnáraimo uwátinkone mósimatim-besimati uwasá ");
INSERT INTO auy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","isésa koawánánae sésa kumbá koawánésa Ísuntafesa sésa maambáráfáꞌá ifá siyuwésa kóuwo siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Suwaná Ísu wení kísau-waasiye nompín-táómpimba íyátesa kumbá wení naaópaꞌa marapáꞌá kúmúwasa ");
INSERT INTO auy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tuwímbai aísamaimo pukówimba wandaaifímbá marésa taawiyaꞌmaésa tésa Ísumpaꞌa máánkówana Ísu tuwánéna taawiyaꞌmaésamo tun-kwáásímó éraiꞌa kaweꞌá uwánkainiye-imayaamo umbá Ísu tuwánéna aísamaimo pukón-kwaasigontafena séna kesí waásiyo ení sáwí-imayaa maiyauwáúmne súwasa ");
INSERT INTO auy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ámáámbo sun-kwáásí keáímbá sésa Maníkó weyáá sáwí-imayaa maitiyuwáínífo minkwáásígó Maníkómbá karaánááꞌa wéankaiye suwaná ");
INSERT INTO auy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ísu miwítí imáyáa tuwánéna nóra séra miyá-sáwí-ímáyáá wéoo. ");
INSERT INTO auy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Moóráwigo aísamaimo pukáindawintafenamo séna ení sáwí-imayaa maiyauwáúmne sínasamo ésa éraira sí karorá síyó sénááwe. Énifo moóráwigomo aísamaimo pukáindawintafenamo séna íyáfasine eyááríkaꞌa waaó sínasamo ésa éraira sí karorá síyó sésa awánánááwe. ");
INSERT INTO auy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kemá waási úranko marapáꞌó méraunda waásiti sáwí-imayaa maitiyuwáúnda-fasiꞌaemba tokáumpo aráátíménda awánánááwe séna aísamaimo pukón-kwaasigontafena séna íyáfasinke ení wandaaimá maimaé ení naaópaꞌa waaó súwana ");
INSERT INTO auy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","íyáfasinena wení naaópaꞌa kúwasa ");
INSERT INTO auy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","mérowi Ísumo úmba awánésa táátafesa ésa Maníkón-áwíꞌa mósá marésa sésa Maníkó minkwáásígómbá fasiꞌaémbá ámísana póna miyá uráiye sésa táátafesa ésa tiyáámba tóipimba fáákaawe. ");
INSERT INTO auy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Suwaná Ísu tuwéna wéna awánómba moóráwigon-awiꞌa Mátíyu taakisimó máún-daumpaꞌa mérowana awánéna séna íyáfasine keséꞌa tiyó súwana íyáfasinena wembá arááíwaꞌmaena kúwasa ");
INSERT INTO auy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ísu wení kísau-waasiye Mátíyuni naaúmpaꞌa imésa tómbá wénowasa sáwífaꞌnanka taakisimó máún-kwaasiye sáwíꞌo un-kwáásíyé mindáúmpáꞌá imésa nowasá ");
INSERT INTO auy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ámáán-kawaa-waasi awánésa Ísuni kísau-waasisafesa tísai esa sésa kentí óraako nóra sénawa taakisimó máén-umen-kwaasiye sáwíꞌo on-kwáásíséꞌa tómbá wénaiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ísu iséna séna tíyofaan-kwaasi kaweꞌ-úmaimo méraan-kwaasi ímba wétuwaꞌnai-ofo tíꞌo in-kwáásí wétuwaꞌnai-owe. ");
INSERT INTO auy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mindásafeꞌa arupíse úmaimo méraan-kwaasi táántaanasa Maníkómpáꞌá tíwae séꞌa ímba kunkáumpo sáwíꞌo úmaimo méraan-kwaasi táántaanasa Maníkómpáꞌá tíwae séꞌa kunkáumne. Maníkón-aai aúfáífimba agaimaréna séna Maníkó séna póímo tufúꞌmaimo agaimáímo símémba kanaán-ifo tirumbó wéuwatinkaamba óraaꞌ-aamoi wéune siyáimba mindásafeꞌa imáyáa éꞌa miyá wéumpo minááígóní áwáuma iséꞌa miyán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Súwasa Yóni nombó maitínkáíwaini kísau-waasi Ísumpaꞌa tésa áísai esa sésa keséta ámáán-kawaa-waasiye moórá-mora-kanaa Maníkóntáféta imáyáa éta tómbá ímbo náúnda inaí aantemba wésumpo ení kísau-waasi ímba miyá ombá tómbá úwoi wénaawe. Nóra sésawa miyá wéoo suwaná ");
INSERT INTO auy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ísu séna moóráwigo aaremó maíndawi amááraasomba tanómbo kautimínda miwíséꞌa mérainasa aamoí ésa mintómbá ímba aꞌáo sénááfo úwoi nánááwe. Ánaaemba minkwáásígómbá aíꞌmae kóíyasa minkánáá amááraasomba tirunkó sáwíꞌa ínasa tómbá aꞌáo sénááwe Ísu séna wemó ánaaemba tiyuwénamo iyíndasafena minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ísu minááí simátimena séna ááéraan-ampantamo afaaꞌó wéraisasamo ombá aú-ampanta ímba kárámai wéfaruwowe. Miyámó íyanamo éna aú-ampantago sáwíꞌa ínana ááéraan-ampantago aú-ampantaraamba ímba íníye. ");
INSERT INTO auy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aú-anda-aran-domba ááéraa-sipisipi-asi-anafeumpimba ímba wéfatimaraawe. Miyámó íyanamo éna aú-anda-aran-donko óraaꞌa éna ááéraan-anafeumba kafaména sáwíꞌa ínana mindómbá úwoifaꞌa fatíwiniye. Mindásafesa aú-anda-aran-domba aú-sipisipi-asi-anafeumpimba wéfatimaraawana minándá-árán-dóné misípísípí-ási-anafeune kaweꞌá úmai wéraiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ísu minááí wésimatimuwana moóráwigo ámáán-dankaꞌo káráwiyowi téna Ísu óraakon-iye séna aísamaifimba kífaena séna kesiyáámúmba puwínena wéifo tiyé aneꞌá kotaꞌótorenana íyáfasinaino súwana ");
INSERT INTO auy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ísu íyáfasinena wení kísau-waasiye miwá-íyáíseꞌa kumbá ");
INSERT INTO auy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","moórá-ininkomba áíꞌa ún-ininko sísamaifakemba kaeꞌá kumbaimái-aatai naaeyámba ankówana minínínkó Ísumba arááíwaꞌmaena wéwena wení unáánkwátói áráíyaꞌa kotaꞌótorena ");
INSERT INTO auy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","imáyáa éna séna wení unáánkwátói áráíyaꞌa kotaꞌótóráánanama síꞌa ésinkainiye-imayaa éna kotaꞌótorowana ");
INSERT INTO auy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ísu faéꞌmai awánéna séna kesímánaako ááꞌa ímba íno. Kentáfé sé éraiꞌa súwaꞌnai índawin-iye sénda póna áíꞌa éꞌánkáíye súwana minkánáá kaweꞌá úmai méraiye. ");
INSERT INTO auy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kaweꞌá úmai mérowana Ísu wéna ámáán-dankaꞌo káráwiyowini naambó wéronkaꞌa wéna awánómba túwaandu úmaimo méron-kwaasi uwíyemba wétufuwesa óraaꞌ-ifiꞌa wétowana Ísu tuwánéna ");
INSERT INTO auy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","séna máápaꞌa kúmóro. Minárásígó ímba pukáifo úwoi aúmá wéraiye súwasa Ísun-awíyáái uwaná ");
INSERT INTO auy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ísu tiꞌmátuwowasa máápaꞌa kúwákárúwowana minárásígó pukópaꞌa iyéna ayáánkaꞌa taꞌótorowana minárásígó íyáfasinowana ");
INSERT INTO auy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ísumo ún-aai wété uráiye. ");
INSERT INTO auy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Minááí wété úwana minkákémbá Ísu aampaꞌá kúmba kaeꞌnárai túramba kafíkóndarai wembá arááíwaꞌmaesarai wésarai óraaka sésarai Téfítini akún-ándáfákéwí ómpo arunkáí uwásinkaao suyaná ");
INSERT INTO auy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","maréna naaúmpaꞌa imérowasarai minkáéꞌnárai weséꞌa iméroyana Ísu tísai ena séna kentáfékai sékai súramba kanaaꞌá kaweꞌá uwásinkainiyewa wéseyo Ísu súwasarai óraakoo kanaámpó miyá ínone suyaná ");
INSERT INTO auy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","kentáfékai miyásáfékai éraiꞌe séyamba póna túramba kaweꞌá íno súwasarai ");
INSERT INTO auy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","túramba awánamai kaweꞌá uyaná Ísu óraaka simátimena séna kemó únda ímba simátímékaiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ifátuwesarai wemó úmba mósimatim-besimatimba uyaná wété uráiye. ");
INSERT INTO auy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Minkáéꞌnárai kuyasá tuwímbai moóráwigomba áíꞌmaesa Ísumpaꞌa tuwaná wenarumpimbá sáwí-amutamba mérontafena minkwáásígó ímba aaí wésuwasa áíꞌmaesa Ísumpaꞌa máánkówana ");
INSERT INTO auy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ísu maiyauwówana kóúwana minkwáásígó aaí súwasa sáwífaꞌnanka awánésa táátafesa ésa sésa Ísareri-waasisa éta naaófáꞌá miyán-kísáú ímba awánaraundasa káféꞌwarata ímba wéawanaumne sumbánifo ");
INSERT INTO auy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ámáán-kawaa-waasi sésa sáwí-amutantonti kawáágó fasiꞌaémbá ámísana tokéna póna sáwí-amutamba wémaitiyuwaiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ísu naaóꞌ-naoꞌa óraaꞌ-naopaꞌe káriꞌ-naopaꞌe wénena ámáán-daumpimpaꞌa iména Maníkó wení waásimo kawáánin-aai ásé-aai simátímaꞌmaena iyéna fíꞌo-fiꞌon-tiꞌo ún-kwaasi asófatinkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ísu miyá wéuwasa sáwífaꞌnankaꞌo tóso umbá tuwánéna séna sipisípiyaꞌo ímbo káráwiyaawimo ímbo méraisasamo sipisípimo sáwíꞌo úmaimo nóntemba miyá owasá ímba túwaꞌnai úmae wénowasa sáwíꞌa wéowe séna arumbá uwátinkena ");
INSERT INTO auy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","waásima Maníkómpáꞌá tíwae-imayaa éna wení kísau-waasisafena séna kísaufaꞌa sáwífa-tomba áfu karáisasa mintómbá fakaráíyan-kwaasi sesimáí-waasi méraamba póꞌa ");
INSERT INTO auy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kísaugoni afowámpáꞌá inaí síyana kísau-waasi tiꞌmaráínasa mintómbá fakaránááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ísu wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi táántowasa tuwaná waási tirumpinkémbá sáwí-amutamba maitíyuꞌmaeꞌa nóro-fasiꞌaemba tiména fíꞌo-fiꞌon-tiꞌo ún-kwaasi asófatinkai-fasiꞌaemba tímakaiye. ");
INSERT INTO auy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Fasiꞌaémbá tiména wení kísauraꞌa tiꞌmaréna séna kesí aantá-waasin-owe súwai túwíꞌa moóráwigo Sáímoniye séna aú-awiꞌa Pítaawe simánkena moóráwigo Pítaan-áfáko Énduruni moóráwigo Sépétin-ááninko Yémísini moóráwigo Yémísin-áfáko Yónini moóráwigo ");
INSERT INTO auy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fírípini moóráwigo Pátóromiyuni moóráwigo Tómaasini moóráwigo Mátíyu wemá taakisimó maúwaini moóráwigo Áráfíásin-ááninko Yémísini moóráwigo Tándiyasini ");
INSERT INTO auy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","moóráwigo Sáímoni wemá Rómu-kamani-waasi tiꞌmátuwanae siyáiwaini moóráwigo Yúndasi-Ísakerioti wemá ánaaemba Ísumba wení namuro-wáásímó aráátímakaiwai miyáumai-waasi Ísuni kísau-waasin-owe. ");
INSERT INTO auy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ísu minkwáásí sísamaifakemba kaeꞌá kumbaimái-waasi tiꞌmaréna séna kosimátímaꞌmae nóro. Fíꞌonkaa-waasiti naaópaꞌe Sámériyaa-waasiti naaópaꞌe ímba néꞌa ");
INSERT INTO auy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kentí waási Ísareri-waasiti naaópimpaꞌa nóro. Sipisípiyaꞌo ímbo káráwiyaiwaimo ímbo méraisasamo sipisípimo sáwíꞌo úmaimo nóntemba Ísareri-waasi miyámó wéomba ");
INSERT INTO auy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","kosimátimeꞌa séꞌa Maníkó wení waásimo kawáánimba wéombaraiye kosimátímaꞌmaeꞌa nóro. ");
INSERT INTO auy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tíꞌo in-kwáásí asófatinkeꞌa púwón-kwaasi íyáfasintinkeꞌa námombo karáin-kwaasi túma kaweꞌá uwátinkeꞌa sáwí-amutamba tirumpimbá méraan-kwaasi maitiyúwáanasa kónááwe. Minkísáúgóní fasiꞌaémbá úwoi timúnaꞌa ímba óntamba méyámbakaafo úwoi kaweꞌá uwátínkáaro. ");
INSERT INTO auy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aampaꞌó wíyamba ímba moórá-tantaaꞌa maimaé koró. Óntamba ímba unáámpímbá fáítumaeꞌa wéꞌa ");
INSERT INTO auy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","tón-únámbá ímba maimaé wéꞌa tísamai ánáamba ímba maimaé wéꞌa táúmba ímba maimaé koró. Moórá-mora unáánkwátói timantentén-úmai kuféꞌmaeꞌa koró. Túwaꞌnai íyawi káráwiyonaafo tuwímbai-tantaaꞌa ímba maíyamba úwoi koró. ");
INSERT INTO auy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Maníkón-aaimo simátimiyantafeꞌa moórá-naopaꞌo wíyamba kembiwímó naambó timíndawimba saafá éꞌa mindáúmpáꞌ-aantemba méꞌa kentí kísau maimái taiꞌéꞌa mindámbá tuwéꞌa fíꞌon-daopaꞌa koró. ");
INSERT INTO auy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Moórá-naumpaꞌo iyíyamba méraiyan-kwaasisafeꞌa séꞌa kaweꞌá úmai méraaro síyasa ");
INSERT INTO auy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","kembiwímó káráwiyiyanamo éna Maníkó kaweꞌá uwátinkainifo ímbo káráwiyiyanamo éna Maníkó kembiwí aantemba kaweꞌá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Moórá-naopaꞌo wíyambo naambá ímbo timésamo kentáái ímbo isáíyanamo éna Maníkó mindáópaken-kwaasi ímba aamoí uwátinkainifo aaraámbareꞌa aiyowáíꞌa éꞌa tísamaifakem-baramo uwáéntenkaaniꞌa oro. Mindáúmpáráꞌi mindáóparaꞌiyo tuwéꞌa koró. ");
INSERT INTO auy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Simátíménda ísáaro. Maníkó waási méraawini áwáusafenamo tísai índa-kanaa tínda naaófáꞌó Sóndómu-naopaꞌe Kómóraa-naopaꞌe méraan-kwaasi sáwíꞌo uráantafena sáwí-meyamba timíníye. Kembiwímó tínaaembo uwátimiyan-kwaasi sáwí-meyamba timíníye. Minkwáásísóntí sáwí-meyanko Sóndómu-naopakewiye Kómóraa-naopakewiyeti sáwí-meyankomba íyáákainiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ísu minááí simátimena séna simátíménda ísáaro. Sipisípimo wisanamó áwáífiyaaseꞌo in-íyánkómó intenkáámbó on-kwáásífímbá tiꞌmaránaumne. Kaweꞌ-ímáyááwáráꞌ-wáásíyáámbá úmai méꞌa sáwíꞌo uwátinkaiyambo éꞌa ímba anondáá sáwíꞌa íyamba aáno úmai méraaro. ");
INSERT INTO auy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Káráwiyoro. Óraaꞌ-amaan-kisau-waasi kembiwí tíꞌmaesa óraaꞌ-waasifaꞌa mótinkesa aaifimbá maitinkésa ámáán-daumpaꞌa mótinkesa túwiyonkuꞌ-nésa ");
INSERT INTO auy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","kentáféꞌo fasiꞌámaimo méraantafesa taꞌótoꞌmai tíꞌmaesa kámáni-oraaꞌ-waasifaꞌe kawáánon-kwaasifaꞌe mátinkesa aaifimbá maitinkáíyaꞌa miwí kesáái simátimeꞌa fíꞌonkaa-waasisonte kesáái simátimenaawe. ");
INSERT INTO auy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Aaimó simátínkénkaꞌa nóran-aaiya sénaumno-imayaa ímba óraaꞌa éꞌa ímba kentí imáyáafinken-aai sénááfo kentifoní ámútanko íyan-aai úwoi tááka tinkáínaꞌa sénááwe. ");
INSERT INTO auy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tuwímbai tífáꞌawaawi tíꞌmai fíꞌowiyaꞌa tinkáíyasa tínkamiyasa puwónááwe. Tifoísáímo ésa tíráámarimba tíꞌmai fíꞌowiyaꞌa tinkáíyasa tínkamiyasa puwónááwe. Iyámpóísombo ésa tinófoima tíꞌmai fíꞌowiyaꞌa tinkáíyasa tínkamiyasa puwónááwe. ");
INSERT INTO auy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kentáféꞌo fasiꞌámaimo méraantafesa tíyámba uwátinkesa miyámó wéomba ímbo ifátuwesamo kentáfésamo fasiꞌámaimo méwi Maníkó kawepáꞌá métinkainiye. ");
INSERT INTO auy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Moórá-naopaꞌo méwasamo sáwíꞌo uwátínkéwaꞌo éꞌa tiyuwéꞌa tuwaantantéꞌa fíꞌon-daopaꞌa koró. Simátíménda ísáaro. Ísareri-waasiti naaóꞌ-naoꞌa simátímaꞌmaeꞌa wéniyana minkísáú ímba taíꞌáraindaraꞌa kemá waási úranko anekaꞌá kumónaumne. ");
INSERT INTO auy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ifóꞌ-wáásígó uwáítáíꞌ-iwáímbá ímba wéiyaakaiye. Kísau-waasigo wení óraaꞌ-waasi ímba wéiyaakaiye. ");
INSERT INTO auy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ifóꞌ-wáásígó uwáítáíꞌ-in-kwáásígómó índantemba íníye. Kísau-waasigo wení óraaꞌ-waasigomo índantemba íníye. Miyáumai kemá óraako únasa símai sáwíꞌa uwásinkesa sésa sáwí-amutantonti kawáágón-áwíꞌa Píyésepuri iyémá wésewe. Miyá wésemba pósa kesí waási símai áfááraumai sáwíꞌa uwátinkanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ísu simátimena séna minááí imáyáa éꞌa waási táároi ímba inkaiséꞌa méraaro. Aúpáꞌó wérain-tantaaꞌa seyaafáꞌá aforaꞌá paápé ínasa awánánááwe. Kumeupáꞌá wérain-tantaaꞌa aforaꞌá paápé ínasa awánánááwe. Mindásafeꞌa waási táároi ímba inkáísóro. ");
INSERT INTO auy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aúpáꞌó simátíménda aforaꞌá simátíméro. Kembiwímó simátíménda-aai sáwífaꞌ-waasimo túwaandu íyaꞌa simátíméro. ");
INSERT INTO auy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tínkamiyaꞌo puwíyan-kwaasi táároi ímba inkáísóro. Miwí kentimambá ímba tínkambai taiꞌánááfo Maníkón-áároi aantemba inkáísóro. Wemó éna ónkaifaꞌa túwaraꞌe timankwáráꞌé tuwáínasa méranaawe. ");
INSERT INTO auy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Maarán-ááí imáyáan-oro. Káriꞌa téntémpaaran-dumama kaeꞌ-númámá káriꞌ-ontankakemba siyáánkai-toyaaraamba wémeyanofo Maníkó kíyaan-dumama káráwiyena ímbo kanaán-iyemo sínanamo éna ímba puwéna marapáꞌá kumínífo ");
INSERT INTO auy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","sáwífaꞌ-numama Maníkón-aúrankaꞌa ímba óraa-tantaaꞌan-ifo waási óraa-tantaaꞌa owaná póna káráwiyena seyaafá-tántááꞌá wéawanena kentiꞌnótáuwaraꞌa wétoraumai wéawanaifo ímba tááꞌa íno Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ísu minááí simátimena séna seyaafáꞌ-wáásí túrankaꞌa kentáfésa sésa kesí óraakon-iye síyawisafeꞌa kesifo wíyómpakewin-aúrankaꞌa séꞌa kesí waásin-owe sénaumne. ");
INSERT INTO auy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Énifo waási túrankaꞌa kembá tínaaemba uwásiyawisafeꞌa kesifo wíyómpakewin-aúrankaꞌa sínaaemba uwátinkanaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ísu minááí simátimena séna kentáféꞌa maarán-ímáyáá ímba oro. Waási seyaafáꞌá aáno úmai méraantafena marapáꞌá kunkáiye. Ímbanifo marapáꞌó kunkáunda maarán-iye. Waási tuwínkaaꞌ-ésa tuwímbai kesáái isáíyasa tuwímbai aaisambá sénááwe. ");
INSERT INTO auy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Káféꞌwara aánoꞌwaraꞌa kesááisafesa maará ónááwe. Afowá moórá-imayaa ínana ááninko fíꞌon-imayaa íníye. Anówa moórá-imayaa ínana ayáámúnko fíꞌon-imayaa íníye. Anááfúkowe fíꞌo-fiꞌon-imayaa óyááye. ");
INSERT INTO auy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Moóráwigo wenamáárawi wení namuro-wáásíyáámbá úmai ónááwe. Kesááisafesa miyáumai miwítí imáyáa tuwínkaaꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ísu minááí simátimena séna kesí waási-iꞌa ónae síyawi aifaꞌá tinófoiye táánine tiyáámúne tirumbá timésa ánaaemba kembá tirumbá símémba uwófíꞌan-owe. ");
INSERT INTO auy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kemó púwónda-aaraa-taimo súwaataꞌmaeꞌo kondantembá kesí waási-iꞌa íyawi umbai-tántááꞌá timíyasa minúmbáí-tántááꞌá ímba maimaésa kembó sirááíwaiyamba uwófíꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tirááímo táínda-iꞌo ésa ímba kaweꞌá úmai méranaafo kentáfésa imáyáa ésamo tirááímo táínda-tantaaꞌa tuwésa puwésa aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ísu minááí simátimena séna tiꞌmáráandawi kentáái isáíyawi kesááiwaraꞌa isánááwe. Kesáái isáíyawi siꞌmákaiwain-aaiwaraꞌa isánááwe. ");
INSERT INTO auy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Maníkón-aai simátimindawi tuwímbaifaꞌa wínasa sésa Maníkón-aai wésimatimendawi ónda póꞌa enáái isánaumne síyawi wésimatimiwaimba Maníkó kaweꞌ-méyámbá aména wéisaiyawiwaraꞌa miyám-béyámbá timíníye. Arupíse úmai méraiwai tuwímbaifaꞌa wínasa sésa arupíse úmai méraandawi ónda póꞌa enáái isánaumne síyawi arupíse úmai mérainda-waasigomba Maníkó kaweꞌ-méyámbá aména wéisaiyawiwaraꞌa miyám-béyámbá timíníye. ");
INSERT INTO auy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kesí waási awánésa sésa úwoisan-kwaasi imbánifo Ísuni waási-iꞌa uráamba póꞌa áwaꞌnai ónae sésa kári-tantaaꞌa nombá amíyana Maníkó kaweꞌ-méyámbá timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ísu wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi mináyáátááꞌ-ááí simátimena mimbáráfáꞌá tuwéna fíꞌo-fiꞌon-daopaꞌa wenáái kouwáítáíꞌ-úmae wénena wenáái simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Simátimuwana Yóni ándá-naumpaꞌa méronkaꞌa Maníkómó íyáfasinankaiwai Káráísiti ún-aai iséna wení kísau-waasi tiꞌmarówasarai Ísumpaꞌa tésarai ");
INSERT INTO auy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","áísai esarai sésa kumínonemo siyáawiyaꞌo. Fíꞌowawa ónómpo kumíndawinta amuꞌmaránaumne suyaná ");
INSERT INTO auy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ísu séna tauwerékai isááyane awánááyane Yónimba kosimámekai sékai ");
INSERT INTO auy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","túrambo kafíkáiwai túramba awánaawana tááꞌo káúnkaiwai tááꞌa ísááwana tísamaimo pukáiwai kaweꞌ-úmai tín-taawaná námombo kaiwáí kaweꞌá uwátinkena pukáan-kwaasi íyáfasintinkena úwoi-waasi ásé-aai simátimena séna ");
INSERT INTO auy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","kentáféna ímba kaeꞌ-ímáyáá íyawi tirunkó kaweꞌá wéiye siyé Yónimba kosimámékaiyo Ísu súwasarai kurááye. ");
INSERT INTO auy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yónini kísau-waasiyai tauwerésarai kuyaná Ísu Yónin-aai seyaafáꞌ-wáásí simátimena séna Yóni máásai-marafaꞌa méraisaꞌa koawánéꞌa nóran-imayaawa wéera koawánaraao. Fiyúndá toréna umó mómaꞌmemaꞌo intenkáán-kwáásí Yóni iyé-ímáyááwá uráao. Yóni ímba miyán-kwáásín-ifo fasiꞌaén-kwáásín-iye. ");
INSERT INTO auy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nóran-imayaawa wéera koawánaraao. Kaweꞌ-únánkwátói úmakain-kwaasi Yóni iyé-ímáyááwá uráao. Ímbanifo miyán-kwáásí kaweꞌ-únánkwátóiwaraꞌ-waasi óraaꞌ-waasiti naaúmpaꞌa méraawe. ");
INSERT INTO auy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nóran-imayaawa wéera koawánaraao. Maníkón-aaimo siwáí Yóni iyé-ímáyááwá uráao. Ewé Maníkón-aaimo siwáín-iye. Éraiꞌa simátime súne. Wemá Maníkón-aaimo siyáawai íyáákaraiye. ");
INSERT INTO auy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Maníkón-aai aúfáífimba Yónin-aai símai agaimaréna séna Maníkó séna isaaó. Moóráwigomba aiꞌmáráanana kesáái maimaéna ení aifaꞌá wéna ení aambá wiyíníye siyáiye gaimaréna siyáimba Yónintafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Simátíménda ísáaro. Yóni nombó maitínkáíwaini kísaugo seyaafáꞌ-wáásítí kísaugomba íyáákaisana Maníkó kaweꞌá uwánkaraifo Maníkó wení waásiyaꞌo kawáánin-kwaasi óraaꞌ-waasiye úwoi-waasiye óraa-kaweꞌa uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yóni nombó maitínkáíwai Maníkón-aai simátimindasafena ómbakainkemba káféꞌwaraꞌa tuwímbai Maníkó kawáánipaꞌa íyófo sésa aambá faiyónae sésa óraa-kisau máéwasa tuwímbai aamoí ésa Maníkó kenkáꞌá kawáánínkwae wésewe. ");
INSERT INTO auy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Naaófáꞌá Maníkón-aai simátímakowiye Mósesewe Maníkó wení waásimo kawáánínda paápé íníye-aai suwaná ánaaemba Yóni paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Naaófáꞌá Íráiyaa maéꞌéíwai anekaꞌá paápé íníye-aai suwaꞌá minááímó siyáan-aaisafeꞌa éraiꞌe sewaꞌá kemá séꞌa Íráiyaantafesamo siyáamba Yónintafesa siyáawe wésunda minááísáféꞌa éraiꞌe seró. ");
INSERT INTO auy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ísáán-kwaasi ísámai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ísu minááí simátimena moórá-aaiwaraꞌa simátimena séna káféꞌo méraan-kwaasi nóran-kwaasiyaanewa sénaumno. Miyán-kwáásíyáámbán-owe. Iyámpóísomba naaópaꞌa marupímbá mésa ááféma wétesa moórá-aempaꞌo méraan-iyampoi táántesa sésa tiyéꞌa imá seró. ");
INSERT INTO auy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Moórá-isa súnaꞌa ímba táásái uráawe. Tirumbó in-ísá súnaꞌa ímba ifiꞌá taráawe siyáawe. Énifo miníyámpóímó uráantemba maaméraan-kwaasi miyá wéowe. ");
INSERT INTO auy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yóni nombá maitínkáíwai ména ándá-aran-domba ímba wénena Maníkóntáféna imáyáa éna tónkwáráꞌá ímba wénaisasa wentáfésa sésa sáwí-amutamba arumpimbó méraiwain-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kemá waási úranko méꞌa ándá-aran-donkwara tónkwáráꞌá náúnasa kentáfésa sésa ándá-aran-done tóntéꞌo naiwáí póna taakisimó máén-umen-kwaasiye sáwíꞌo on-kwáásítí waásin-iye wésewe. Énifo Maníkó simátímakaintembo owí sésa Maníkó kaweꞌ-ímáyááwáráwín-iye wésewe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Moórá-mora-kanaa Ísu naaóꞌ-naoꞌa kawe-kísáú ímbo awánaraan-kisau wémauwasa awánésa sáwí-awauma ímba tuwésa Maníkómpáꞌó ímbo tuntáféna Ísu óraaka séna ");
INSERT INTO auy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","kembiwí Kórási-naopaken-kwaasiye Pétésáíta-naopaken-kwaasiye sáwí-meyamba kentópaꞌa tíníye. Naaófáꞌó Táyaa-naaopaken-kwaasiye Sáíndóni-naopaken-kwaasiye Maníkón-aaimo ímbo ísaraawifimbo kawe-kísáú ímbo awánaraan-kisaumo maéwándamo awánarekaa miwítí sáwí-awauma tukáawisino. Sáwí-awaumo tuwésamo úwoi-unankwatoimo úmaesamo kanamó aꞌmakáankakaa Maníkó tuwánaraisino. ");
INSERT INTO auy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mindásafeꞌo simátíménda ísáaro. Maarán-ímáyáá wéeꞌa Maníkó waási méraawini áwáusafena tísai índa-kanaamo tínda Maníkó Táyaa-naopaken-kwaasiye Sáíndóni-naopaken-kwaasiye sáwí-meyamba óraaꞌa timíníye-imayaa wéowe. Énifo kentí sáwí-meyanko minkáéꞌ-náópakewiti sáwí-meyankomba íyáákamai-sawi-meyamba timíníye. ");
INSERT INTO auy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kápaneamu-naopaken-kwaasisono. Kentúwíꞌa mósá maréꞌa séꞌa wíyómpaꞌa iyónaumne sembánifo púwón-aempaꞌa kónááwe. Naaófáꞌá Sóndómu-naopaken-kwaasifimbo kawe-kísáú ímbo awánaraan-kisaumo maéwándamo awánarekaa miwítí sáwí-awauma túwówana póna Maníkó mindáóꞌa ímba taíꞌásuwowana káféꞌa úwoi wéraisino. ");
INSERT INTO auy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mindásafeꞌo simátíménda ísáaro. Maarán-ímáyáán-oro. Maníkó waási méraawini áwáusafena tísai índa-kanaamo tínda Maníkó Sóndómu-naopaken-kwaasi sáwí-meyamba óraaꞌa timíníye-imayaa wéowe. Énifo kentí sáwí-meyanko Sóndómu-naopakewiti sáwí-meyankomba íyáákamai-sawi-meyamba timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Minkánáá Ísu Maníkóntáféna séna kesifóo wíyómpaꞌwara mararáꞌwáráꞌó káráwiyaandawi óne. Seyaafá-tántááꞌá isáúmne sen-kwáásí ímba simátime úwoi-waasi simátime ");
INSERT INTO auy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","miyámó íyantafena ánkáísaꞌa póꞌa enáwíꞌa mósá maráúmne Ísu Maníkóntáféna siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ísu minááí simámena séna kesifo seyaafá-tántáákáꞌá káráwiyuwo séna símakaiye. Seyaafáꞌnánká kesí áwáuma ímba suwánaraafo kemá kesifoní áwáugo únana póna kesí áwáuma suwánaraiye. Seyaafáꞌnánká kesifoní áwáuma ímba awánaraafo kesifombá póꞌa keyáá wení áwáuma awánaraumne. Kesifoní áwáuma simátimenae únda-waasi kanaaꞌá kesifoní áwáuma wéawanaawe. ");
INSERT INTO auy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kentí kísau umbai-kísáú wémaewana kentópaꞌa umbai-tántááꞌá wéraiwai kesópaꞌa tíyaꞌa kentí imáyáa aúíꞌa uwátínkáanaꞌa faru úmai méranaawe. ");
INSERT INTO auy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kemá kesúma ímba maimaé iyéꞌa farumó uwátinkaundawi únaꞌa póꞌa kesí aambá kaweꞌ-úmai awánéꞌa kesáái taawiyafíyaꞌa kentí imáyáa aúíꞌa uwátínkáanaꞌa faru úmai méranaawe. ");
INSERT INTO auy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kesááimo taawiyafíyamba ímba umbaí táínana tíménda-kisau kawe-kísáún-iye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Minkánááfímbá Yúndaa-waasimo saagaan-kánááráꞌá Ísuwe wení kísau-waasiye kísaufaꞌa wíti-ton-kisaufaꞌa wéguwana wení kísau-waasi táái tówasa wíti-aramba kútúmai ásima pítuwesa nowasá ");
INSERT INTO auy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ámáán-kawaa-waasi tuwánésa Ísuntafesa sésa tuwánaao. Saagaan-kánáá aambá fáíꞌmakaawasa miyá wéowe suwaná ");
INSERT INTO auy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ísu séna naaófáꞌó Téfítimo uráimba aúfáífimbo agaimakáin-aaigoni áwáu ímba ísaraawe. Téfítiye wení waásiye táái tówana ");
INSERT INTO auy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Téfíti Maníkóní ámáán-daumpaꞌa iyéna Maníkón-aúrankaꞌo makón-tomba imaiyéna wénena wení waási timúwasa naráawe. Mintómbá úwoi-waasi ímbo néꞌómbanifo ámáán-kisau-waasi aantembo néꞌómbaniye. Téfíti mintómbá imaiyéna timúwasa nonkáꞌá Maníkó ímbo aaisambá siyáimbanifo kesí waási miyá owaꞌá aaisambá ímbo seráámbá wésewe. ");
INSERT INTO auy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naaófáꞌá Mósese simátímakain-aai aúfáífinkemba awánaraawe. Maníkóntáfésamo ísámaimo póímo tufúꞌmaimo agáén-kwaasi óraaꞌ-amaan-daumpaꞌa kísau wémaesa saagaan-kánááwáráꞌá kísau máéwasa miyámó ontáfésa ímba aaí simátinkesa sésa sáwíꞌa wéowe ímba wésewe. ");
INSERT INTO auy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Simátimeꞌa súne. Kempímbá wémaunda-kisaugo óraaꞌ-amaan-daumpaꞌo wémaen-kisaugomba íyáákaraifo saagaan-kánáá ámáán-kisau-waasi kísau máéntafeꞌo ímba sáwíꞌa owémó senkákémbá kesí kísau-waasisafeꞌa sáwíꞌa wéowe ímba seró. ");
INSERT INTO auy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maníkón-aai aúfáífimba agaimaréna séna Maníkó séna póímo tufúꞌmaimo agaimáímo símémba kanaán-ifo tirumbó wéuwatinkaamba óraaꞌ-aamoi wéune siyáimba minááígóní áwáumo iséꞌo arááíwaekaa ímbo sáwíꞌo uráan-kwaasi aaifimbá ímba maitínkááwaisino. ");
INSERT INTO auy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wíyómpakemba waási úranko póꞌa saagaan-kánááráꞌó káráwiyaundawi úmpo saagaan-kánááráꞌó waásimo kísau máémba kendén-iye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ísu mifáꞌá tuwéna ámáán-daumpaꞌo iyúwana ");
INSERT INTO auy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","moóráwigo ayáámbo kemporarón-kwaasi mérowasa aaifimbá maenkánae sésa Ísumba áísai esa sésa saagaan-kánáá kísau aambá fáíꞌmakaan-kanaa póna áíꞌo in-kwáásí asófankai-kisau maínda ámáámba taraisíni ína taraisíníyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ísu tísai ena séna kempínkémbá kentí sipisípi-poraaꞌo saagaan-kánááráꞌó maipímbó kúwáfekainaꞌo éꞌa ááéma mósá farántuwanaao. Ewé éꞌa miyá íyamba ");
INSERT INTO auy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","waásigo sipisípi-poigomba íyáákaraimba póna saagaan-kánáá áíꞌo índa-waasi asófankaiyamba kaweꞌá éna ámáámba ímba taraisíníye simátimena ");
INSERT INTO auy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ayáámbo kemporarón-kwaasigontafena séna enayáámba fárútuwaao súwana ayáámba fárútuwowana kaweꞌá uwánkowana fíꞌon-ayaankaamba úwasa ");
INSERT INTO auy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ámáán-kawaa-waasi ámáán-daumpakemba kumésa Ísumba tufuwíyanamo puwínda-aai siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tufuwíyanamo puwínda-aaimo sumbá Ísu iséna mimbáráfáꞌá tuwówasa sáwífaꞌnanka wembá arááíwáúwana tíꞌo ún-kwaasi seyaafáꞌá asófatinkena ");
INSERT INTO auy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","óraaka séna kemó uwátinkaunda-aai ímba simátíméro siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Miyámó úmba naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Áísáya siyónkaꞌa póna Ísu miyá uráiye. Áísáya agaimaréna séna Maníkó séna ");
INSERT INTO auy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","wembá íyáfasinankaraunana kesí kísau-waasi isaꞌá wen-ímáyáá wéeꞌa aamoí wéuwankeꞌa aaí senaná kesí ámútanko weséꞌa mérainana fíꞌo-fiꞌon-kwaasi seyaafáꞌnánká kesí arupíse-aai simátimena ");
INSERT INTO auy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ímba aaisambá tiyéna ímba óraaka séna naaópaꞌa wénena ímba óraaka séna ");
INSERT INTO auy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Maníkómpáꞌó ímbo fasiꞌámaimo méraan-kwaasi ímba tiyuwéna kaweꞌá uwátinkainiye. Miyá úmae iyéna kísau maimaé iyéna ímba ifátuwainana kesí arupíse-aaigo íyáákena wérainasa ");
INSERT INTO auy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","fíꞌonkaa-waasi wenáwíꞌa isésa sésa éraiꞌa súwaꞌnai índawin-iye sénááwe Maníkó siyáiye siyónkaꞌa póna Ísu miyá uráiye. ");
INSERT INTO auy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Moóráwigomba wenarumpimbá sáwí-amutamba mérowana póna minkwáásígó ímba aaí wésuwana aúramba kafíkówasa áíꞌmaesa Ísumpaꞌa máánkówana Ísu maisuwéna minkwáásígómbá kaweꞌá uwánkowana wemá aaí súwana aúramba awánówasa ");
INSERT INTO auy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","sáwífaꞌnanka táátafesa ésa sésa miwá Téfítin-andafakemba paápé íníyemo siyáawiyaꞌi fíꞌowawaꞌiyo suwasá ");
INSERT INTO auy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ámáán-kawaa-waasi minááí isésa karoꞌá sésa ímbanifo sáwí-amutantonti kawáágón-áwíꞌa Píyésepuri fasiꞌaémbá ámísana tokéna póna sáwí-amutamba wémaitiyuwaiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Suwaná Ísu miwímó un-ímáyáá iséna simátimena séna moórá-andamo tiyésamo ésa tuwínkaaꞌ-urésa mésa ímba fasiꞌámai méranaawe. Moórá-naoparaꞌi moórá-akunaꞌi aaimó tuwíntáán-akumba pósa tuwínkaaꞌ-urésa ímba fasiꞌámai méranaawe. ");
INSERT INTO auy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Waántáwankoni waásimo tiyésamo tuwínkaaꞌo ésamo ésa ímba fasiꞌámai méranaawe. Kentáféꞌo sembá Píyésepuri fasiꞌaémbá ámísana tokéna póna sáwí-amutamba wémaitiyuwaiyemo sembá ");
INSERT INTO auy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","énifo Píyésepurini fasiꞌaénkáꞌó sáwí-amutambo wémaitiyuwaundarakaa kentí waásiwaraꞌa Píyésepurini fasiꞌaénkáꞌá sáwí-amutamba maitiyúwáísino. Miyán-ááímó síyasamo ésa kentí waási karoꞌá sewé sénááwe. ");
INSERT INTO auy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Énifo kemá Maníkóní ámútankoni fasiꞌaénkáꞌá sáwí-amutambo maitiyuwáúndasafena Maníkóní fasiꞌaémbá kempímbá paápé isaꞌá wéawanaawe. ");
INSERT INTO auy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Moórá-aai imáyáan-oro. Moóráwigo moórá-nankoni afowámó fasiꞌaéwímó mérainanamo éna mindáúmpákén-úmémbó maíndasafenamo éna ímba úwoi íyáferainifo miwá mindánkóní afowámbá ándá káráꞌumankenamo éna kanaaꞌá íyáfekena wení moparáwímbá umémbá máíníye. ");
INSERT INTO auy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kembá ímba súwaꞌnai esa kesí namuro-wáásíyáámbán-owe. Ímba súwaꞌnai esa waási túwaandu úmai símémba moórá-mora uwáguraawe. ");
INSERT INTO auy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mindásafeꞌo simátíménda ísáaro. Waási sáwí-kisau wémaesa símai sáwíꞌo uwátínkáámba mindá Maníkó maitiyuwáínífo Maníkóní ámútankontafesa símai sáwíꞌo uwánkaiyamba mindá Maníkó ímba maitiyuwáíníye. ");
INSERT INTO auy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kembá waási úrankomba símai sáwíꞌo uwásinkaiyamba mindá Maníkó maitiyuwáínífo Ufaen-ámútánkóntáfésa símai sáwíꞌo uwánkaiyamba mindá Maníkó ímba maitiyuwéna káféꞌwara ánaaenkwaraꞌa ímba maitiyuwáíníye. ");
INSERT INTO auy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kawe-táígó kaweꞌ-árámbá íyáísana sáwí-taigo sáwí-aramba wéiyaifo taaéramba awánésa kawe-táígón-aramban-iye. Sáwí-taigon-aramban-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Iyánkó póígon-araaꞌan-owe. Sáwíꞌ-aantembo on-kwáásí méꞌa póꞌa ímba kanaaꞌá kaweꞌ-ááí wésewe. Tirumpimbá wérain-imayaasamba wésewe. ");
INSERT INTO auy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaweꞌ-wáásí kaweꞌ-ímáyááfínkémbá kawe-kísáú máéwasa sáwí-waasi sáwí-imayaafinkemba sáwí-kisau wémaefo sáwí-waasi éꞌa sáwí-aai wésewe. ");
INSERT INTO auy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Simátíménda ísáaro. Maníkó waásimo méraawini áwáusafena tísai índa-kanaa tínda úwoi-aaimo fíꞌo-fiꞌon-aaimo siyáantafena tísai íníye. ");
INSERT INTO auy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kaweꞌ-ááímó siyáan-kwaasisafenamo éna arupíse-waasin-owe Maníkó séna sáwí-aaimo siyáan-kwaasisafenamo éna sáwí-waasin-owe síníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Súwasa tuwímbai ámáán-kawaa-waasiye ámáámba sun-kwáásíyé Ísumo sáwí-aaimo sínda isánae sésa óraakoo éraira Maníkómpákéná kunkáanai ímbo awánáúnda-kisau máínata awánaano suwaná ");
INSERT INTO auy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ísu séna káféꞌo méraan-kwaasi sáwí-waasi éꞌa Maníkóntáféꞌa ímba imáyáa éꞌa kentáféꞌa wéseꞌa Maníkómó aiꞌmákainamo e ímba awánáúnda-kisau máínata awánaanomo sembá naaófáꞌá Maníkó Yónaambo uráintemba kembá miyá ínífo minááí imáyáan-oro. ");
INSERT INTO auy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Naaófáꞌó óraaꞌ-mofaako Yónaambo nawíkowanamo kaumbo-kánáámó arumpimbó méraintemba kemá waási úranko kaumbo-kánáá maipímbá ménaumne. ");
INSERT INTO auy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yónaa kaumbo-kánáá óraaꞌ-mofaako arumpimbá mérowana mín-kwituwówana minkákémbá Nínéfa-naopaꞌa Maníkón-aai kosimátimuwasa isésa sáwí-awauma tuwésa Maníkón-aai ísaraawe. Káféꞌa Yónaambo íyáákaraundawi méraunaꞌa kesáái ímba wéisaamba póna ánaaemba Maníkó waásimo méraawini áwáusafenamo tísai índa-kanaamo tínda Nínéfa-naopaken-kwaasi kembiwí aaifimbá maitinkésa sésa Yónaan-aai iséta sáwí-awauma tukáundasaanifo Yónaamba íyáákaraiwai kentí naaópaꞌa mérowaꞌa wenáái ímba iséꞌa sáwí-awauma ímba tukáawe Nínéfa-naopaken-kwaasi sénááwe. ");
INSERT INTO auy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Naaófáꞌá kentíwáꞌnáraꞌa káráwiyowin-awiꞌa Soromoní kaweꞌ-ímáyááfínkémbá aaí wésimatimuwana moórá-ininko némpaken-kawaa-ininko Soromonin-áái koisánae séna wémena kuráiye. Káféꞌa kemá Soromonimbá íyáákaraundawi méraunaꞌa kesáái ímba ísáámba póna ánaaemba Maníkó waásimo méraawini áwáusafenamo tísai índa-kanaamo tínda minínínkó kembiwí aaifimbá maitinkéna séna kemá némpakemba Soromonin-áái taísaraumpo Soromonimbó íyáákaraiwai kempáꞌá mérowaꞌa wenáái ísómba ímba ísámai kaweꞌá uráawe síníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ísu minááí simátimena séna waási arumpinkémbá sáwí-amutanko auwéna máásai-marafaꞌa nombá ímbo wéraipaꞌa kowénena séna nááfara ménaumno séna saafá uwááena ");
INSERT INTO auy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","séna tauweréꞌa kesí naambá waásigon-arumpimba póꞌa koménaumne simásuwena téna taawánaimba mindánkómbá kankambá wiyúꞌmai kaweꞌá uwásukaisana taawánéna ");
INSERT INTO auy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tauweréna afakaeté-sawi-amutamba miwítí sáwí-kisau óraaꞌa uráawi tíꞌmaena minkwáásígón-arumpimba taméraawana moórá-sawi-amutanko arumpimbá méraisana minkwáásígó sáwíꞌa úmai méraisasa ánaaemba sáwífa-sawi-amutamba méraawana wemá óraa-sawiꞌa úmai méraiye. Miyáumai káféꞌo méraan-kwaasi sáwí-kisau wémaesa óraa-sawiꞌa úmaesa iyónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ísu wésimatimuwasa Ísun-anówawe Ísun-áfárawaisaiye tésa aaimó simámiyantafesa máápaꞌa tamérowana ");
INSERT INTO auy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","moóráwigo Ísuntafena séna enanówe enáfárawaisaiye aaí simámenaesa máápaꞌa taméraawe súwana ");
INSERT INTO auy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ísu séna kesinó nááwaꞌiyo. Kesífárawaisai nááwiyaꞌo séna ");
INSERT INTO auy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ayáántamba wení kísau-waasi aráátimena séna kesinó kesífárawaawi méraawe. ");
INSERT INTO auy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kesifo wíyómpakewi siyáintemba wéowi kesinówe kesúnafaraawinen-owe Ísu siyaíye. ");
INSERT INTO auy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Minkánáá Ísu naaúmpaꞌa tuwéna Káríri-nonkwaaunkoni áwáífaꞌa koména aaimó simátimindasafena kúwasa ");
INSERT INTO auy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","sáwífaꞌnanka tóso ésa ewaaꞌá tamérontafena nompín-táómpimba íyátena imérowasa minkwáásísómbá nonkwaaúnkóní áwáífaꞌa mérowana fíꞌo-fiꞌon-aai waéꞌmai simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Moórá-aai simátimena séna moóráwigo ánáuntumba maimaéna kísaufaꞌa wéwena ");
INSERT INTO auy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","mátuꞌmaraisana tuwímbai-anauntumba aampaꞌá kuwéraisana numagó fáíꞌnasukaiye. ");
INSERT INTO auy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tuwímbai-anauntumba óntankwaraꞌ-marafimba kuwéna paákáꞌ-máráfímbá póna minúwóíyáán-úmai óraaꞌa isaná ");
INSERT INTO auy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","aaꞌá kaisaná amímá yáátáákaꞌa ímba kunkéna aáénkaguraiye. ");
INSERT INTO auy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tuwímbai-anauntumba karaampaꞌá kuwéna kárúraisana karaan-tantáákó fandundupásukaiye. ");
INSERT INTO auy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tuwímbai-anauntumba kaweꞌ-máráfímbá kuwéna karuwéna óraaꞌa éna arambá imái sáwífaꞌ-aramba iyéna tuwímbai íyáákarain-aramba íyáísana tuwímbai imaimái-aramba iyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ísáán-kwaasi ísámai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ísu súwasa wení kísau-waasi wempáꞌá tésa taáísai esa sésa wésimatimenda nóra séwa waéꞌmai-aai wésimatimeno suwaná ");
INSERT INTO auy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ísu séna Maníkó wení waásimo kawáánin-aaigoni áwáumo simátimunda Maníkó kembiwí imáyáa tímísaꞌa wéisaafo miwí imáyáa ímba tímakaisasa wéisaantafeꞌa waéꞌmai-aai wésimatimune. ");
INSERT INTO auy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maníkón-aaimo ísámaimo kaweꞌó íyawi Maníkó túwaꞌnai ínasa moórá-aaiwaraꞌa isésa miyámó wéiyanamo éna Maníkó túwaꞌnai ínasa seyaafáꞌ-ááíwáráꞌá isánááwe. Maníkón-aaimo ímbo ísámaimo kaweꞌó ésa karoꞌá sésa kaweꞌ-úmai wéisaumne síyawi tirumpinkémbá minááí maimaínana ímba wérainiye. ");
INSERT INTO auy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ísáámbanifo ímba ísámai kaweꞌá wéowe. Awánaambanifo ímba awánamai kaweꞌá wéowe. Miyámó ontáféꞌa simátimunda waéꞌmai-aai wésimatimune. ");
INSERT INTO auy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Áísáya siyáimba miwí miyá wéowe. Áísáya séna ísáámbanifo ímba ísámai kaweꞌá wéowe. Awánaambanifo ímba awánamai kaweꞌá wéowe. ");
INSERT INTO auy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Miwítí imáyáago umbaí wétaisana tááko aaimó isáísáféna awesaraí isaná túranko awánaisafena awesaraí ifo ímbo miyámó ésamo ésa tááꞌo isésamo túrambo awánésamo kesááimo isésamo miwítí sáwí-imayaamo tuwésamo kempáꞌó tenkakaa sáwí-imayaa maitiyuwéꞌa kaweꞌá uwátinkausino Maníkó siyáiye Áísáya agaimaréna siyáimba Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ísu minááí simátimena séna simátimeꞌa súne. Kembiwí kaweꞌ-úmaimo awánaamba Maníkó kaweꞌá wéuwatinkaiye. Kaweꞌó úmaimo ísáámba Maníkó kaweꞌá wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Simátíménda ísáaro. Naaófáꞌá Maníkón-aai simátímakowiye arupíse úmai mérowiye sáwífaꞌ-waasi kembiwímó wéunda-kisau awánaanten-úmai awánánae sésa umbá ímba awánaraawe. Miwí kembiwímó wéisaanten-úmai isánae sésa umbá ímba ísaraawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ísu wení kísau-waasisafena simátimena séna moóráwigo ánáuntumba tuꞌmakáin-aaigoni áwáuma súnda ísáaro. ");
INSERT INTO auy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Maníkó wení waásimo kawáánin-aai isésa ímba ísámai kaweꞌá owaná waántáwanko téna tirumpinkémbá tamaimái úwoifaꞌa wétiyuwaiye. Minkwáásí aampaꞌó kuwérain-anauntunkaamba wéowe. ");
INSERT INTO auy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ánáuntumbo óntankwaraꞌ-marafimbo kúmímba maarán-áwáún-iye. Maníkón-aai isésa aamoí ombánifo ");
INSERT INTO auy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ímba tirumpimbá taꞌótoꞌmai kaweꞌá owasá Maníkón-aaisafesa umbaí tátínkáíntafesa Maníkón-aai ifátukaawe. ");
INSERT INTO auy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ánáuntumbo karaampimbó kúmímba maarán-áwáún-iye. Maníkón-aai ísáámbanifo marapáꞌ-úmbáí-tántáátáfésa imáyáa úmae nésa ónta-imayaa úmae wénesa miyán-ímáyáágó Maníkón-aai faráátasuwaisasa ímba Maníkóní kísau wémaewe. ");
INSERT INTO auy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ánáuntumbo kaweꞌ-máráfímbó kúmímba maarán-áwáún-iye. Maníkón-aai isésa tirumpimbá taꞌótoꞌmai kaweꞌá ésa fasiꞌámai mésa Maníkóní kísau maésa wétuwaꞌnai-owasa tuwímbai íyáákamai-kisau maésa wétuwaꞌnai-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ísu minááí simátimena séna Maníkó wení waásimo kawáánin-aai maarán-ááín-iye. Moóráwigo wení kísaufaꞌa kaweꞌ-ánáúntúmbá áwíꞌa wíti uꞌmakáisana ");
INSERT INTO auy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","moórá-noꞌwaamba ánaoraawaraꞌa tún-kwaiguráawana namuro-wáásígó téna arambó ímbo íyáí-witiyaan-anauntumba sáwí-anauntumba afufumpimpáꞌá tuꞌmakáisana ");
INSERT INTO auy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","wíti óraaꞌa éna arambá íyáísana wítiyaan-damaiwaraꞌa óraaꞌa isasá ");
INSERT INTO auy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","kísau-waasi awánésa kísaugoni afowámpáꞌá tésa sésa kaweꞌ-ánáúntúmbá tuꞌmakáandafimba wítiyaan-damai nááfakena mimpímbá wéraiyo sewaná ");
INSERT INTO auy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","séna namuro-wáásígó mátuꞌmakaiye sisasá áísai esa sésa káúsuwanaumne sewaná ");
INSERT INTO auy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","séna ímbanifo wíti káúsuwaafainifo ifátúwéwana ");
INSERT INTO auy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","wérainana ánaaemba wíti aumbákáínaꞌa tómbó fakaráíyawisafeꞌa senasá misáwí-wítíyáán-dámáí káúmai asááúmai iyamá wégaindafaꞌa tuwésa wíti úramba fákáꞌmai kesí tón-dáúmpáꞌá maránááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Ísu maarán-ááíwáráꞌá simátimena séna Maníkó wení waásimo kawáánin-aai maarán-iye. Moórá kári-taerankon-awiꞌa másítáti mintáígón-aramba ímbo aneꞌó awánaraan-taeramba kísaufaꞌa uꞌmakáawana óraaꞌa éna amaimá mófarena wété uráisana numagó mimpímpáꞌá ánáamba úmarena wémaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ísu maarán-ááíwáráꞌá simátimena séna Maníkó wení waásimo kawáánin-aai maarán-ááín-iye. Moórá-ininko péréti-tomba agaénae séna kanaráán-tántáákón-áwíꞌa páráwaaꞌa maéna intoráínda-tantaaꞌa kári-tantaaꞌa káúmaraisana wéna intoréna óraaꞌa wéiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ísu waásisomba aaí simátimenae sénamo úmba ímba aforaꞌá siyáifo waéꞌmai-aai aantemba simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Naaófáꞌá Maníkón-aaimo simátímakowi siyónkaꞌa póna Ísu miyá uráiye. Wemá agaimaréna séna simátíménda waéꞌmai-aai simátimenaumne. Maníkó maramá úmaronkaꞌa aúpáꞌó wéron-kisaugon-aai ímbo ísaraan-aai simátimenaumne siyáiye agaimaréna siyáimba Ísuntafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ísu minááí simátimena tiyuwéna naaúmpaꞌa iyúwasa wení kísau-waasi wempáꞌá tésa sésa namuro-wáásígómó moóráwigoni kísaufaꞌo sáwí-anauntumbo tuꞌmáráíwaini áwáuma simásimiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ísu séna kaweꞌ-ánáúntúmbó tuꞌmakáiwaini áwáuma kemá waási úranko úne. ");
INSERT INTO auy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kísaugoni áwáuma maramán-iye. Kaweꞌ-ánáúntúnkóní áwáuma Maníkó wení waásimo kawáánin-kwaasin-owe. Sáwí-anauntunkoni áwáuma waántáwankoni waásin-owe. ");
INSERT INTO auy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Namuro-wáásígó sáwí-anauntumba tuꞌmakáiwaini áwáuma waántáwankon-iye. Tómbó fakaráíyan-kanaagoni áwáuma maramó taiꞌáínda-kanaan-iye. Tómbó fakaráíyawaini áwáuma Maníkóní kísau-waasi wíyómpakewin-owe. ");
INSERT INTO auy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Námáímo toꞌmáímo iyafímbó agaisuwáíyantemba ánaaen- kanaamo tínda miyá ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Waási úranko kumpaápé uráundawi kesí kísau-waasi wíyómpakemba tiꞌmáráanasa kesí waásifinkemba sáwí-waasiye fíꞌowimo sáwí-imayaamo timíyasamo sáwí-ambo wéaraaiwaiwiye kuntíꞌmai ");
INSERT INTO auy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","iyamó wégaipaꞌa tiyuwáíyasa mésa ifiꞌá tésa túwááyaamba umpufuwésa méraiyasa ");
INSERT INTO auy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","arupísemo úmaimo méraawi Maníkó kentifo kawáánipaꞌa mésa aaꞌó wégaintemba miyá ónááwe. Ísáán-kwaasi ísámai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ísu maarán-ááíwáráꞌá simátimena séna Maníkó wení waásimo kawáánin-aai maarán-ááín-iye. Fíꞌonkaꞌmaꞌmai-ontamba marafímbá utámarena pukáisana moóráwigo téna taawánéna aamoí éna káátamarena mimbárámá méyámbá índasafena wení óntama maimái tímatuwena óntamba maiyéna mimbárámá koméyánéna mifíꞌónkáꞌmáꞌmáí-óntámbá kofasímbai maiyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Maníkó wení waásimo kawáánin-aai maarán-ááín-iye. Moóráwigo akaaroróma méyámbaraindasafena naaóꞌ-naoꞌa wénena ");
INSERT INTO auy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","awánáínda moóráwigo fíꞌonkaꞌmaꞌmai-akaaroroma makáinana awánéna wení óntama maiyéna wétimena óntamba maiyéna mifíꞌónkáꞌmáꞌmáí-ákáárórómá koméyánúmai wémaiye. ");
INSERT INTO auy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Maníkó wení waásimo kawáánin-aai maarán-ááín-iye. Mareꞌmareꞌ-únánkáámbá moóráwigo nompímbá túwáísana fíꞌo-fiꞌom-bofaaꞌa ");
INSERT INTO auy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","minúnámpímbá ówitawisana fasináíndasafena úmai wéawanaisasa tuwímbai áwaꞌnai úmai fasímbai áámááífaꞌa makésa kaweꞌ-mófááꞌá unáámpímbá fáítesa sáwí-mofaaꞌa ifáꞌá wétuwaawe. ");
INSERT INTO auy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ánaaen-kanaamo tínda miyá íníye. Wíyómpaken-kisau-waasi kaweꞌ-wáásífínkémbá sáwí-waasisomba tíꞌmai ");
INSERT INTO auy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","iyamó wégaindafaꞌa tuwáíyasa ifiꞌá tésa tíꞌo índasafesa túwááyaamba umpufuwónááwe simásuwena ");
INSERT INTO auy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","wení kísau-waasisafena tísai ena séna simátimunda-aaigoni áwáuma éra isááo súwasa ewé suwaná ");
INSERT INTO auy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ísu simátimena séna ísáámba simátimunda-aai simátíméro. Moóráwigo naankón-afowá wení naaúmpaꞌa ááéraan-tantaaꞌe aú-tantaaꞌe wéraisana tuwímbai wení waási wétimiye. Miwání afowámó wétimintemba miyáumai ááéraan-amaampinkene Maníkó wení waásimo kawáánin-aaifinkene simátíméro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ísu minááí simátimena mimbáráfáꞌá tuwéna ");
INSERT INTO auy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","wenamáápaꞌa kúmba miwítí ámáán-daumpaꞌa iyéna aaí simátimuwasa táátafesa ésa sésa nááfakena kaweꞌ-ímáyáá maiyénawa kaweꞌ-ááí wésimasimenasaawa nááwawa fasiꞌaémbá ámísanawa kawe-kísáú ímbo awánáúnda-kisau wémaiyo. ");
INSERT INTO auy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kesáámó awánáúnda wení kísau taaisambó tuwímbai-tantaaꞌo wéiwain-aaninkon-iye. Máríyaan-áánimba éna Yémísiye Yósepiye Sáímoniye Yúndasi-iyai tuwaaón-iye. ");
INSERT INTO auy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wenáúnafaꞌa maankáꞌá méraawe. ");
INSERT INTO auy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Maankákéwí éna úwoi-waasin-ifo nááfakena minááí isénawa mifásíꞌáémbá maiyénawa wésiyo sésa kaorésa tínaaemba uwámúwana Ísu simátimena séna Maníkón-aai simátímíwai fíꞌo-fiꞌon-daopaꞌa wénisasa wenáwíꞌa mósá wémaraafo wení naaópaꞌo koméraimba wenamááraa sésa kesáámó úndanten-kwaasin-iye sésa wenáwíꞌa ímba mósá makáawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kesáámó úndanten-kwaasi éna ímba súwaꞌnai íníye suntáféna ímbo awánon-kisau moórá-mora-kisau aantemba maiyáiye. ");
INSERT INTO auy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Minkánáá Ísuni kísaugon-aai símae íyúwana Káríri-marafaken-kawaagon-awiꞌa Éroti minááí iséna ");
INSERT INTO auy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","wení kísau-waasisafena séna minkwáásígó Yóni nombó maitínkaraiwain-iye. Pukáimpinkemba íyáfasinkena póna fasiꞌaémbá wempímbá wéraisana miyán-kísáú wémaiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ááéma Éroti wenáfákon-awaaininkon-awiꞌa Érótíyasimba maiyówana Yóni séna enáfákon-awaainimba aambá fáíꞌmakaawa maiyáane símasimaꞌa wéuwana Éroti tiꞌmarówasa Yónimba koáíꞌmaesa ándáfaꞌa máánkarowana ");
INSERT INTO auy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Éroti Yónimba tufuwónae súmba waási táároi inkaiséna ímba tufukáiye. Waási Yónintafesa sésa Maníkón-aai simátímíwain-iye suwaná Éroti séna Yónimba tufúwónasa aaisambá siyónááwe séna ímba tufuwéna mérowana ");
INSERT INTO auy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","wembó maꞌánkaron-kanaamo túwana óraa-tanomba kaumái sáwífaꞌ-waasi tímúwasa nowaná Érótíyasin-ayaamunko téna túrankaꞌa araimá marówana Éroti aamoí uwánkena ");
INSERT INTO auy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","minárásígóntáféna séna nóin-tantaatafenawa wéankaiya simásímínaꞌa áméno. Éraiꞌa súmpo sísai inaꞌá áméno súwana ");
INSERT INTO auy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","anówamba koáísai ena súwana anówama aaí súwana Érotimpaꞌa téna séna Yóni nombó maitínkáíwai anuwarambá kambísámai aꞌnómbá táúfapimba maꞌmái simiyó súwana ");
INSERT INTO auy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","iséna arumbá wéumbanifo aifaꞌá fasiꞌaén-ááí siyáin-aai imáyáa éna tómbó naan-kwáásíwáráꞌá ísaraantafenawe séna ímba aꞌáo sénae séna ");
INSERT INTO auy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","moóráwigomba aiꞌmarówana ándáfakemba Yónimba anuwarambá kambísámai aꞌnómbá ");
INSERT INTO auy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","táúfapimba maimaéna minárásígómbá máamuwana maimaéna anówamba máamuwasa ");
INSERT INTO auy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yónini kísau-waasi isésa anómba komaimái utánkesa Ísumpaꞌa tésa tasimámakaawe. Ánaaemba Éroti Ísuni kísaugon-aai iséna séna minkwáásígó Yóni nombó maitínkaraiwai éna pukáimpinkemba íyáfasinkena póna fasiꞌaémbá wempímbá wéraisana miyán-kísáú wémaiye Éroti siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yóni puwúmba wení kísau-waasi Ísumba simámúwana iséna tuwéna wení kísau-waasiye nompín-táómpimba íyátena waásimo ímbo méraiyapata kónae séna kúmba naaóꞌ-naokewi minááí isésa marapáꞌá tóso uwaná nompín-táómpimba wéna ");
INSERT INTO auy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","marapáꞌá kumúmba misáwífáꞌ-wáásí tuwánéna arumbá uwátinkena tíꞌo ún-kwaasi asófatinkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ísu asófatinkowasa fenómpinkaꞌa wení kísau-waasi wempáꞌá tésa sésa ímba sáwífaꞌ-waasi méraapaꞌan-ifo fenáíndafinkaꞌa tiꞌmárénasa ewaaꞌ-náópimpaꞌa wénesa tómbá méyámbáráaro suwaná ");
INSERT INTO auy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ísu séna tóntááꞌa ímba wíyamba tómbá tíméro súwasa ");
INSERT INTO auy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","miwí sésa kári-tomba séfataase-tonkwara kaeꞌ-mófááꞌwáráꞌá wéraifo sáwífaꞌ-waasifimba ímba kanaán-íníye suwaná ");
INSERT INTO auy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ísu maimaéꞌa másíméro séna ");
INSERT INTO auy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","sáwífaꞌ-waasisafena maraꞌá méraaro séna séfataase-tonkwara kaeꞌ-mófááꞌwáráꞌá maisoréna wíyómpaꞌa kararéna Maníkóntáféna súwi simásuwena mintómbá tafántafan-úmai wení kísau-waasi timúwasa misáwífáꞌ-wáásí tímúwasa ");
INSERT INTO auy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","seyaafáꞌnánká nowaná tímúꞌa fówasa sáwífaꞌa 5,000 waaima uwasá aarewé iyámpóíwaraꞌe miyáumai-waasi nowaná tímúꞌa fówasa Ísuni kísau-waasi mintón-ayai sísamaifakemba kaeꞌá kumbaimái-unampimba fáítuwana ówitaraiye. ");
INSERT INTO auy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Fáítuwana ówitowana minkákémbá Ísu wení kísau-waasi tiꞌmaréna séna kesí aifaꞌá nompín-táómpimba íyáteꞌa menáípáꞌ-náópaꞌa koró. Misáwífáꞌ-wáásí tiꞌmaré séꞌa kentí naaóꞌ-naoꞌa koró simátimenaumne séna ");
INSERT INTO auy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","misáwífáꞌ-wáásí tiꞌmarówasa miwítí naaóꞌ-naoꞌa kuwaná Maníkómpáꞌó inaimó síndasafena omápaꞌa imérowana nóꞌwaamba túnkúwana Ísu weyáá mérowasa ");
INSERT INTO auy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","wení kísau-waasi nompín-táómpimba non-afufumpá mérowana maramá nénkaꞌa wérowana óraa-fiyunda toꞌmaé téna mintáómba tataꞌótoꞌmarowasa ímba kumbá ");
INSERT INTO auy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","siyarónkaꞌa Ísu non-afóforaꞌa maréna wení kísau-waasimo méronkaꞌa túwasa ");
INSERT INTO auy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","non-afóforaꞌo wénumba awánésa táátafesa ésa tinekembá tataꞌá wéuwasa sésa waántágo wéniye suwaná ");
INSERT INTO auy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ísu minúwóíyáán-úmai séna tááꞌa ifó aánoꞌa méraaro. Kemá úne súwana ");
INSERT INTO auy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pítaa simámena séna emó Fasiꞌaénkó úrambo éma sinaꞌá non-afóforaꞌa emó méraandafaꞌa konó súwana ");
INSERT INTO auy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ísu séna kanaán-ifo tiyó súwana nompín-táómpinkemba ásáfena non-afóforaꞌa Ísumo méropaꞌa kúmba ");
INSERT INTO auy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kaweꞌá úmaena kúmba óraa-fiyundamo toróntafena imáyáa éna inkaisúmba nompímbá kúwáfekoraꞌnara wéena óraakaꞌa séna Fasiꞌaénkóo kembá taꞌótoraao súwana ");
INSERT INTO auy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ísu minúwóíyáán-úmai ayáámba fárúꞌmai taꞌótorena séna óraa-fiyundamo tóráíntafe sáwí-imayaa e kesí fasiꞌaéntáfémo ímbo imáyáamo óndasafe kúwáferaane. Kesí fasiꞌaéntáfé ímba kaeꞌ-ímáyáán-uwo séna ");
INSERT INTO auy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","mindárai nompín-táómpimba íyátoyana óraa-fiyundago mafaúwasa ");
INSERT INTO auy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","nompín-táómpimba mérowi Ísun-imayaa mósá marésa sésa éraiꞌa Maníkón-ááninko óne siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Éraiꞌa Maníkón-ááninko óne sésa waaúnkóní menáípáꞌá Kénésáréti-marafaꞌa kumbá marapáꞌá kúmúwasa ");
INSERT INTO auy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","mimbápákén-kwáásí Ísumba awíyésa Ísun-iye sésa naaóꞌ-naoꞌa simátimesa Ísumo tamaún-aai isésa tíꞌo ún-kwaasi tíꞌmaesa tóso ésa ");
INSERT INTO auy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","sésa ení unáánkwátóigoni áráíyaꞌa taꞌótoraiyana tíꞌa étinkainkwae suwasá taꞌótórówana tíꞌa étínkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé Yérúsaremu-naopakemba Ísumo méropaꞌa tésa sésa ");
INSERT INTO auy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ení kísau-waasi nóra isasawá kentáá síwáꞌnáti ámáámba ímba arááíwaesawa tiyáámba ímba non-kwiyésawa tómbá wénaao suwaná ");
INSERT INTO auy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ísu séna kentíwáꞌnámo simátímakaan-amaamba arááíwaeꞌa Maníkóní ámáámba wétaraisomba nóra séra miyá wéoo. ");
INSERT INTO auy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Maníkó séna kentinófoi-tuwiꞌa óraaꞌan-oro. Énifo anófoimo sáwíkaambo simátinkaindawimba tufuwíyana puwíníye Maníkó siyáifo ");
INSERT INTO auy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","kembiwímó siyáamba moóráwigo anófoisafena simátimena séna moórá-tantaaꞌa Maníkóndén-ifo ímba kanaaꞌá timénaumne siyéna anófoi ímba wétuwaꞌnai-iye. Miyámó ontáféꞌa kanaán-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Miyá-sáwíꞌó ontáféꞌa Maníkón-aai tuwéꞌa kentíwáꞌnáti ámáámba wéaraaiwaewe. ");
INSERT INTO auy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kaumbo-kaeꞌ-ááíwáráꞌ-wáásín-owe. Naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Áísáya kembiwísáféna éraiꞌ-aai agaimaréna séna Maníkó séna ");
INSERT INTO auy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","maawí kesúwíꞌa tóikaken-aantemba sésa ken-ímáyáá ímba tirumpimbá wéraiye. ");
INSERT INTO auy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Waásiti ámáámba símai paápé ombánifo Maníkóní ámáámban-iye karoꞌó sembá miyáráán-úmai ken-ímáyáá karoꞌ-ímáyáá mósá wémaraawe Maníkómó siyáiye Áísáya símai agaimakáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ísu minááí simátimena waásisafena teró súwasa wempáꞌá tuwaná séna simátíménda iséꞌa kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Máápaken-tantaaꞌo naawáí ímba waási sáwíꞌa wéuwatinkaifo tirumpinkén-ááígó aantemba waási sáwíꞌa wéuwatinkaiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Súwasa Ísuni kísau-waasi wempáꞌá tésa sésa ámáán-kawaa-waasi emó simátimenda-aai isésa aaisambá aéésa kaóráámba ína isaánó suwaná ");
INSERT INTO auy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ísu séna kesifo wíyómpakewi ímbo uꞌmakáin-anauntumbo éna káúsuwainiye. ");
INSERT INTO auy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ámáán-kawaa-waasi-taaisafeꞌa ímba óraaꞌ-imayaan-oro. Miwí ímbo aambó awánaankakemba tóikakemba karoꞌá simátimesa sésa aambá aráátimenaumne wésewe. Moórá aúgafitawi moórá aúgafitawimba ayáán-toꞌmaesarai ímba kanaaꞌá kóyááfo miyámó ésaraimo ésarai maipímbá kotanaa fáyááye súwana ");
INSERT INTO auy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pítaa séna waéꞌmai-aaimo simátimenda-aaigoni áwáuma simásimiyo súwana ");
INSERT INTO auy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ísu séna kenkwáráꞌá ímba tááko péé wésisaꞌa ísáámbanifo ímba ísámai kaweꞌá uráawe. ");
INSERT INTO auy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Máápaken-tantaaꞌo naawí tindáámpáꞌá kúwátúsúwinifo ");
INSERT INTO auy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","aaimó wésemba tirumpinkén-ímáyáágó éna mindá waási sáwíꞌa wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tirumpin-ímáyááfínkémbá sáwí-imayaa ésa tínkamiyasamo puwíyasamo ésa aare-úmémbá ésa waai-úmémbá ésa seyaafá-tántááꞌá umémbá ésa karoꞌ-ááí simátinkesa símai sáwíꞌa uwátinkesa ");
INSERT INTO auy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","miyá-sáwíꞌó wéomba tirumpinkén-ímáyáágó waási sáwíꞌa wéuwatinkaifo tiyáámbo ímbo non-kwiyésamo tómbó wénaamba miwá ímba waási sáwíꞌa wéuwatinkaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ísu minááí simátimena wení kísau-waasi tíꞌmaena Táyaa-naopaꞌe Sáíndóni-naopaꞌe mináémpáꞌó kúmba ");
INSERT INTO auy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","mináémpákén-ínínkó ímba Yúndaa-inimba póna Kénaani-ininko Ísumpaꞌa téna óraaka séna óraakoo Téfítin-andafakewi arumbá uwásinkaao. Sáwí-amutamba kesiyáámúnkon-arumpimba méraisana sáwíꞌa úmai méraiye súwana ");
INSERT INTO auy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ísu iséna ímba aaí súwasa wení kísau-waasi wempáꞌá tésa óraaka sésa aiꞌmátuwaao. Aasiyaasí miyá sifáínifo suwaná ");
INSERT INTO auy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ísu séna Maníkó siꞌmákaisaꞌa Ísareri-waasi aantemba túwaꞌnai eꞌa Ísareri-waasimo sipisípi-poiyaan-úmaimo wété wéowi wétuwaꞌnai-une súwana ");
INSERT INTO auy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","minínínkó Ísun-amándáraꞌa maraꞌá kumbaéna séna óraakoo súwaꞌnai uwo súwana ");
INSERT INTO auy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ísu séna iyámpóíti tómbá maimái iyámbá timúnafo miyáumai Ísareri-waasimo túwaꞌnai úndantemba emá fíꞌonkaa-inimba ónda póꞌa áwaꞌnai únafo súne súwana ");
INSERT INTO auy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","minínínkó séna óraakoo éraiꞌa sémpo iyánkón-afowá ewé sínana tón-ayai tawémandaiye. Miyáumai fíꞌonkaa-ininkon-iye sínana kanaán-ína súwaꞌnai ínono súwana ");
INSERT INTO auy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ísu séna kentáfé fasiꞌámai méraanda-ininko sénda póꞌa miyá ónaumne séna minkánáá ayáámúnkomba asófankaraiye. ");
INSERT INTO auy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Asófankena kúmba Káríri-waaunkoni áwáífaꞌa kógáramai omápaꞌa maraꞌá imérowasa ");
INSERT INTO auy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","sáwífaꞌ-waasi wemó méropaꞌa kumbá tísamaimo táúnkon-kwaasiye tiyáántámbo káénkuron-kwaasiye túrambo kafíkón-kwaasiye aaimó ímbo sun-kwáásíyé fíꞌo-fiꞌon-tiꞌo ún-kwaasi tíꞌmaesa wenaísamaifimba mótinkowana asófatinkowasa ");
INSERT INTO auy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","tísamaimo táúnkon-kwaasi kaweꞌá uwasá tiyáántámbo káénkuron-kwaasi kaweꞌá uwasá túrambo kafíkón-kwaasi kaweꞌ-úmai awánowasa aaimó ímbo sun-kwáásí aaí suwasá misáwífáꞌnánká awánésa áfááraumai tááꞌa úwasa Ísareri-waasiti Fasiꞌaénkón-áwíꞌa mósá makáawe. ");
INSERT INTO auy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Maníkón-áwíꞌa mósá marówana Ísu wení kísau-waasi táántowasa tuwaná séna maankwáásísómbá kaumbo-kánáá keséꞌa taméraawana tómbó maimaé tiyáamba taíꞌáísaꞌa sirumbá uwátinkaumne. Tiꞌmáráanasa miwítí naaóꞌ-naoꞌa kónááfo aampaꞌó wíyamba táái táínasa púwófainiye súwasa ");
INSERT INTO auy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","wení kísau-waasi sésa máásai-marafaꞌa sáwífaꞌ-waasin-ofo nááfaken-tona maimáíya timénaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ísu tísai ena séna nóraumai-tona wéraiyo súwasa afakaeté-tomba wéraisana sesimáí-mofaaꞌwaraꞌa wéraiye suwaná ");
INSERT INTO auy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","minkwáásísóntáféna séna maraꞌ-méraaro séna ");
INSERT INTO auy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","afakaeté-tone mófááꞌe maisoréna Maníkóntáféna súwiyo séna mintómbá tafántafan-úmai wení kísau-waasi timúwasa minkwáásísómbá tímúwasa ");
INSERT INTO auy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","seyaafáꞌnánká nowaná tímúꞌa fówasa sáwífaꞌ-waasi 4,000 waaima uwasá aarewé iyámpóíwaraꞌe miyáumai-waasi nowaná tímúꞌa fówasa wení kísau-waasi mintón-ayaimo túwómba afakaeté-unampimba fáítuwana ówitowana ");
INSERT INTO auy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ísu misáwífáꞌ-wáásí tiꞌmaréna wení kísau-waasiyeꞌa nompín-táómpimba íyátesa Mágátani-aempaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mifáꞌá Ísu mérowasa ámáán-kawaa-waasiye Sátúsi-amaan-kawaa-waasiye Ísumo sáwí-aaimo sínda isánae sésa Ísumpaꞌa tésa sésa éraira Maníkómpákéná kunkáanai ímbo awánáúnda-kisau máínata awánaano suwaná ");
INSERT INTO auy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ísu séna fénáímpinkaꞌo awánaamba aafáúmá naaeríríꞌa isaꞌá séꞌa aafáyáa aaꞌá káíníye séꞌa ");
INSERT INTO auy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","aafáyáaraꞌa awánaamba ainánkó aafáúmá káátasuwaisaꞌa séꞌa káféꞌa aaꞌá tíníye wésewe. Wíyómpaꞌo awánéꞌo ombá séꞌa aaꞌá káíníye. Aaꞌá tíníye wésemba miyán-tántáákóní áwáuma awánaambanifo Maníkómó káféꞌo wéin-tantaakoni áwáuma ímba awánaraawe. ");
INSERT INTO auy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Káféꞌo méraan-kwaasi sáwí-waasi éꞌa Maníkóntáféꞌa ímba imáyáa éꞌa kentáféꞌa wéseꞌa Maníkómó aiꞌmákainamo e ímba awánáúnda-kisau máínata awánaanomo wésemba naaófáꞌá Maníkó Yónaambo uráintemba kembá miyá ínífo minááí imáyáan-oro. Naaófáꞌó óraaꞌ-mofaako Yónaambo nawíkowanamo kaumbo-kánáámó arumpimbó méraintemba kemá kaumbo-kánáá maipímbá ménaumne Ísu séna tiyuwéna kuráiye. ");
INSERT INTO auy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tiyuwéna kúmba Ísu wení kísau-waasiye nonkwaaúnkóní menáípáꞌó kumbá marapáꞌá kumésa wení kísau-waasi péréti-tomba ímbo máúmba tuwinkésa kuwaná ");
INSERT INTO auy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ísu ámáán-kawaa-waasiye Sátúsi-amaan-kawaa-waasiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásí owé-ímáyáá éna wení kísau-waasi simátimena séna intóráín-tantaaꞌa kári-tantaaꞌa moórá-tonkon-awiꞌa péréti mimpímbá márááwanamo intoréna óraaꞌo intembá ámáán-kawaa-waasiye Sátúsi-amaan-kawaa-waasisafeꞌa imáyáa éꞌa kentúma káráwiyoro súwasa ");
INSERT INTO auy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","keáímbá sésa nóra sénawa miyá wésiyo. Péréti-tomba ímba maimaéta túnanasa miyá wésiye suwaná ");
INSERT INTO auy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ísu keáímbó wésun-aai iséna nóra séra tómbá ímba wéraiye-aai wéseo. Kári-timankunkumban-ifo kentáféꞌa timankúnkúmba oro. ");
INSERT INTO auy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kanaaꞌá tómbá timénaumpo ááémo uráundawini áwáuma ímba tááko péé wésiye. Séfataase-tombo tafántafan-úmaimo sáwífaꞌa 5,000 waasi timéwánasa naráamba mintón-ayai nóraumai-unampina fáíturaawara kemó uráundawini áwáuma ímba awánaraawe. ");
INSERT INTO auy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Afakaeté-tombo tafántafan-úmaimo sáwífaꞌa 4,000 waasi timéwánasamo naráamba mintón-ayai nóraumai-unampina fáíturaawara kemó uráundawini áwáuma ímba awánaraawe. ");
INSERT INTO auy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ámáán-kawaa-waasiye Sátúsi-amaan-kawaa-waasisafeꞌa imáyáa éꞌa pérétimo intóráín-tantaatafeꞌa kentúma káráwiyoro-aaimo súnda ímba péréti-tontafeꞌa wésumpo nóra séra ímba ísaraao súwana ");
INSERT INTO auy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tááko péé súwasa minááígóní áwáuma ísówana péréti-tontafena ímba siyáifo ámáán-kawaa-waasiye Sátúsi-amaan-kawaa-waasiye tááisafena séna káráwiyeꞌa méraaro siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ísu Sísááríya Fírípái-naoꞌ-aempaꞌo kúmba wení kísau-waasi tísai ena séna seyaafáꞌnánká kembá waási úrankontafesa nóran-kwaasiyewa wéseo súwasa ");
INSERT INTO auy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","miwí tuwímbai sésa emá Yóni nombó maitinkáándawi óne sewasá tuwímbai sésa naaófáꞌá Maníkón-aaimo simátímakaandawin-awiꞌa Íráiyaa óne sewasá tuwímbai naaófáꞌá Maníkón-aaimo simátímakaandawin-awiꞌa Yérémaya óne sewasá tuwímbai sésa naaófáꞌá Maníkón-aai simátímakaawifinkemba moóráwigo óne wésewe suwaná ");
INSERT INTO auy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ísu séna kembiwí kentáféꞌa nóran-kwaasiyewa wéseo súwana ");
INSERT INTO auy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sáímoni Pítaa séna Maníkómó íyáfasinankaraiwaimba Yúndaa-waasisa wéamuꞌmaraundawisa óne. Maníkó fasiꞌaénkwáráwín-ááninko óne Pítaa súwana ");
INSERT INTO auy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ísu séna Sáímoni Yónaan-ááninko ónana Maníkó kaweꞌá wéuwankaiye. Kesí ááinkoni áwáumo sénda waási ímba simáméfo kesifo wíyómpakewi minááí embá simámísa isáánda póna Maníkó embá kaweꞌá wéuwankaiye. ");
INSERT INTO auy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Simátimeꞌa súne. Enáwíꞌa Pítaawemo wésemba mináwíkóní áwáuma óntamban-iye. Óraaꞌ-ontankaꞌa kesí naankáámbá ondá mindánkáámbá kesí waási-iꞌa owaná púwó-fasiꞌaenko ímba íyáákainiye. ");
INSERT INTO auy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Maníkó wení waásimo wégarawi-fasiꞌaemba áména marapáꞌó méraanda sáwíꞌo ombá aambó fasiyóndanten-úmai Maníkó wíyómpaꞌa ména éꞌa aambá fásíꞌmakaiye. Kaweꞌó ombá ímbo aambó fasiyóndanten-úmai Maníkó wíyómpaꞌa ména éꞌa miyá uráiye simásuwena ");
INSERT INTO auy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","wení kísau-waasisafena óraaka séna Maníkómó íyáfasisinkaiwai Yúndaa-waasi wésimuꞌmaraawi úne-aai ímba simátíméro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Minkánáá Ísu wemó puwínda-aai ómbarena wení kísau-waasi simátimena séna Yérúsaremu-naopaꞌa kondá Yúndaa-oraaꞌ-waasiye óraaꞌ-amaan-kisau-waasiye ámáámbo sen-kwáásíyé síꞌo índa-iꞌa uwásinkesa sínkamiyaꞌo púwóndanifo kaumbo-kánáá maisúwáanana Maníkó íyáfasisinkainiye súwana ");
INSERT INTO auy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pítaa áíꞌmaena weyááfaꞌa máankena séna Fasiꞌaénkóo miyán-ááí sénafo Maníkó ímba ewé sínasa séndantemba ímba uwánkanaawe súwana ");
INSERT INTO auy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ísu waeréna Pítaantafena óraaka séna waántáwanko siyuwé kóuwo. Waásiti imáyáafinkemba wésempo ímba Maníkóní imáyáafinkemba wésempo kesí aambá ímba faiyuwó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ísu minááí simámena wení kísau-waasi simátimena séna kembó sirááíwaenae síyawi tirááímo táínda-tantaaꞌa ímba taꞌótóráaro. Kemó púwónda-aaraa-taimo súwaataꞌmae kondantembá kembó sirááíwaiyawi umbai-tántááꞌá timíyasa minúmbáí-tántááꞌá úwoi maimaésa sirááíwaenaawe. ");
INSERT INTO auy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tirááímo táínda-iꞌo ésa ímba kaweꞌ-úmai méranaafo kentáfésa ísámaimo tirááímo táínda-tantaaꞌo tuwésamo puwésa aúíꞌa úmai maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mararáké-séyááfá-tántááꞌó maésamo puwíyanamo éna mintántáákó ímba túwaꞌnai íníye. Puwíyamba marapáꞌó makáan-tantaatamba ímba méyámbátuwesa anekaꞌá ayáátááka méranaawe. ");
INSERT INTO auy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kemá waási úranko kesí kísau-waasi wíyómpakewiye kesifoní fasiꞌaénkwáráꞌá kuméꞌa seyaafáꞌ-wáásímó miyámó úmae wéiyomba imáyáa éꞌa miwítí méyámbá timénaumne. ");
INSERT INTO auy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Éraiꞌa simátime súne. Tuwímbai maankáꞌó méraan-kwaasi ímba aifaꞌá pukénkaꞌa kemá waási úranko kesí waásimo kawáánúnda suwánéꞌa ánaaemba puwónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ísu minááí simátimena afaꞌmóráe-noꞌwaamba waéna Pítaane Yémísine wenáfáko Yónine tíꞌmaena omápaꞌo iyúmba miwí aantemba imésa ");
INSERT INTO auy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","miwí túrankaꞌa Ísu fíꞌon-auma faufúwana óipakemba aafáúgómó inten-úwana wení unáánkwátóiyakemba sán-kena waéníꞌa kówasa ");
INSERT INTO auy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","awánomba kaeꞌ-wáásíyáí wíyómpakemba paápé ésarai mindárai-tuwiꞌa Mósesee Íráiyaaeꞌa Yúndaa-waasi tíwáꞌnárai Ísuweꞌa aaí wésuyana ");
INSERT INTO auy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pítaa Ísuntafena séna Fasiꞌaénkóo maankáꞌó méraundasa kaweꞌá imbá póta emó sinatáámó éta wááu-namba kaumbosáámó ondasá moórá endé éta moórá Mósesende éta moórá Íráiyaande éta miyásá onó siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Miyá wésunkaꞌa ainánkó sán-kámaena waéníꞌa kámae kuména kunkáátowana mináínámpínkémbá aaigó aantemba séna miwá kesáánimba isaꞌá wen-ímáyáá wéeꞌa óraaꞌ-aamoi uwánkaumne. Wenáái ísáaro súwasa ");
INSERT INTO auy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","wení kísau-waasiyau minááí isésa táátafesa ésa marapáꞌá kífaesa tinekembá tataꞌá úwana ");
INSERT INTO auy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ísu miwímó méropaꞌa téna tineꞌá taꞌótorena séna tááꞌa ifó íyáfasinaaro súwasa ");
INSERT INTO auy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","awánomba mindárai wíyómpaꞌa íyúyana Ísu aantemba méraiye. ");
INSERT INTO auy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Úwasa omápakemba kúmúmba Ísu óraaka simátimena séna awánaamba ímba simátíméro. Kemá waási úranko púwóndafinkembo íyáfasinaandaraꞌa awánaamba kanaaráꞌá simátímaꞌmae íyóro súwasa ");
INSERT INTO auy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","wení kísau-waasiyau Ísumba áísai esa sésa ámáámba sen-kwáásí Íráiyaa aifaꞌá paápé ínana Maníkó íyáfasinankaiwai Yúndaa-waasisa amuꞌmakáundawisa ánaaemba paápé íníyemo sembá nóra sésawa minááí wéseo suwaná ");
INSERT INTO auy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ísu séna aifaꞌá Íráiyaa paápé éna toꞌmayaa íníye-aai éraiꞌ-aain-iye. ");
INSERT INTO auy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Simátimeꞌa súne. Íráiyaa éꞌa paápé úwasa ímba Íráiyaan-iye sésa sáwíꞌa uwánkanae sésa sáwíꞌa uwánkesa miyá uráantemba kembá waási úrankomba sáwíꞌa uwásinkanaawe súwana ");
INSERT INTO auy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tááko péé súwasa Íráiyaa siyáimba Yóni nombó maitínkaraiwaintafena siyáiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Simátimesa omápakembo kúmúmba sáwífaꞌ-waasi túwaandu urówasa awánomba moóráwigo Ísumpaꞌa téna aísamaifimba kífaena séna ");
INSERT INTO auy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","óraakoo kesáánimba arumbá uwánkaao. Sáwíꞌa uwáwéna ména tanaambá fágufagu isaná aigaregó nonkááníꞌa isaná aíyayaamba kuꞌwisaná nompíné iyafíné tanaambá wéfamaena wénisaꞌa ");
INSERT INTO auy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ení kísau-waasi méraapaꞌa máankaunasa ímba kanaaꞌá kaweꞌá uwánkaraawe súwana ");
INSERT INTO auy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ísu séna kentí imáyáa kaentaén-ímáyáá isaꞌá kentáféꞌa ímba imáyáa owaná póna sirunkó umbaí wétaifo nóraumai-kanaarara keséꞌa ménaumno. Enáánimba áíꞌmae tiyó súwana áíꞌmae túwana ");
INSERT INTO auy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ísu sáwí-amutankontafena séna auwé kóuwo súwana arumpinkémbá auwéna kóúwana miníyámpóí kaweꞌá uwánkowana kaweꞌá úmai méraiye. ");
INSERT INTO auy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kaweꞌá uwánkowasa ánaaembo Ísu weyáámo méronkaꞌa wení kísau-waasi tésa sésa nóra sétaawa misáwí-ámútámbá ímba kanaatá maiyáúkaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ísu séna Maníkóntáféꞌo maiyauwáíníyemo séꞌo timankúnkúmbo onkakaa maiyaúwáísino. Éraiꞌa simátimeꞌa súne. Moórá-taigon-awiꞌa másítáti káriꞌ-aramba íyáísana áruma wíkéna óraa-tainambo wéintemba kentáféꞌa timankúnkúmba kárikaꞌa uréꞌa ánaaemba óraakaꞌa timankúnkúmba éꞌa omátafeꞌo séꞌo faiwíꞌmae fíꞌon-aempaꞌa kóuwomo síyanamo éna miyá íníye. ");
INSERT INTO auy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Maníkómpáꞌá inaí síyantafesa tómbá aawentamó ombá minánkó aantemba miyá-sáwí-ámútámbá maisuwáíníye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ísu wení kísau-waasi Káríri-aempaꞌa túwaandu uwaná Ísu simátimena séna kembá waási úrankomba fíꞌon-kwaasi timíyasa ");
INSERT INTO auy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sínkamiya puwéꞌa kaumbo-kánáá maisúwáanana íyáfasisinkainiye simátimuwana miwí tirunkó umbaí taráiye. ");
INSERT INTO auy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tirunkó umbaí tówasa Ísu wení kísau-waasiye Kápaneamu-naopaꞌa kumbá óraaꞌ-amaan-dankontafesa taakisi-óntámbá wémauwai Pítaampaꞌa tésa sésa ení óraako óraaꞌ-amaan-dankontafena taakisi-óntámbá wétuwai ína wétuwaiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pítaa séna wétuwaiye simátimena naaúmpaꞌa iyúwana taakisi-ááímó siyónkaꞌa Ísu Pítaamba áísai ena séna Sáímoniyo marapákén-órááꞌ-wáásí timááraawifakemba taakisi-óntámbá maésa fíꞌonkaafakemba maésawa wéompo nóran-imayaamo wéemo e simásimiyo súwana ");
INSERT INTO auy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pítaa séna taakisi-óntámbá fíꞌonkaafakemba wémaewe súwana Ísu séna miyáumai Maníkóní waásisa póta óraaꞌ-amaan-dankoni taakisi-óntámbá ínta tuwánáúmpo ");
INSERT INTO auy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","aaisambá sefáímpóta úwoi tuwánáúmpo nonkwaaúmpáꞌá kuré ándá túwénana kumína aifaꞌó tawáínda-mofaaꞌa maiyé óipimbo óntambo wéraina maimaé minóntántámbá esáféwe kendéwe taakisi máuwo Ísu súwana miyá uráiye. ");
INSERT INTO auy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Minkánáá Ísuni kísau-waasi wempáꞌá tésa taáísai esa sésa Maníkó wení waásimo kawáánin-kwaasifinkemba nááwa íyáákesawa óraaꞌ-waasi-iꞌa wéiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ísu moórá-iyampoi áántowana túwana afufumpimbá íyáfasinankena ");
INSERT INTO auy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","séna éraiꞌa simátimeꞌa súne. Sen-ímáyáámó ímbo tuwéꞌo iyámpóímo ímbo íyáákanae-imayaamo ontembó kembiwí miyán-ímáyáámó ímbo íyanamo éna Maníkó kenkáꞌá ímba kawááníníye. ");
INSERT INTO auy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Miníyámpóígómó tísamaifimbo máíntemba miyámó wéowi Maníkó wení waásimo kawáánin-kwaasifinkemba wéiyaakaawe. ");
INSERT INTO auy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kentáfésa imáyáa ésa iyámpóímo áwaꞌnai onten-úmai wésuwaꞌnai-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ísu minááí simátimena séna iyámpóímo kesááisafesamo timankúnkúmbo onten-úmai tuwímbai timankúnkúmba wéowe. Tuwímbai tésa kesááisafesamo éraiꞌemo wésewi karoꞌ-ááí tasimátimiyasa isésa sáwí-ampaꞌa kóíyasa Maníkó karoꞌó síyawi sáwí-meyamba óraaꞌa timínífo miwímó tinuwarampimbó óraaꞌ-ontambo fáríꞌwimaresamo nompímbó túwááwasamo kumpuwésaraa karoꞌ-ááí ímba simátíméwasa sáwí-ampaꞌa ímba kowisinó. Mindá kanaán-iye. ");
INSERT INTO auy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Marapáꞌó méraankaꞌa kesáái tuwésa sáwí-ampaꞌa wíyantafena fíꞌo-fiꞌon-tantaako wétafisiye. Miyá-sáwí-tántáákó waéꞌwaeꞌa wéimba pósa sáwí-ambo fíꞌowimo aráátíméwi sáwí-meyamba maénááwe. ");
INSERT INTO auy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tiyáánkowaꞌi tísamaigowaꞌi sáwíꞌo ínaꞌa misáwí-ámpáꞌá kúnafo séꞌa moórá-tiyaanaꞌi moórá-tisamaiyaꞌi kambísásúwáaro. Kae-tíyáánáꞌi kae-tísámáíyáꞌi wérainaꞌo éꞌa sáwí-marupaꞌo iyamó wégaipaꞌo wíyamba mindá sáwíꞌan-iye. Sáwíꞌo uráimbo maisuwéꞌo méraiyamba mindá kaweꞌán-iye. ");
INSERT INTO auy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Túrankomo sáwíꞌo ínaꞌa misáwí-ámpáꞌá kúnafo séꞌa moórá-turamba fitúwáaro. Kae-túrántámbó awánéꞌo éꞌa ónkaifaꞌo iyamó wégaipaꞌo wíyamba mindá sáwíꞌan-iye. Sáwíꞌo uráimbo maisuwéꞌo méraiyamba mindá kaweꞌán-iye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ísu séna úwoi-waasisafeꞌa sáwísamban-owe ímba síyamba káráwiyoro. Maníkóní kísau-waasi wíyómpakewi miwíyáꞌá káráwiyaawai kesifo wíyómpakewini ewaaꞌá mésa miwí táái wésimamefo káráwiyoro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ísu minááí simátimena séna kemá waási úranko Maníkóní aampaꞌó ímbo wéaraaiwaen-kwaasisafeꞌa saafá úmai sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métínkáandasafeꞌa kunkáumne. ");
INSERT INTO auy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sipisípiyaꞌa káráwiyowi on-ááí ísáaro. Moóráwigo sáwífaꞌa 100 sipisipiyaꞌa káráwiyaisana moórá-sipisipi áwiyoꞌwisana misáwífá-sípísípímó umó wénaamba tiyuwéna moórámo áwiyoꞌwimba kosaafá émena ");
INSERT INTO auy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","awánénamo imbá aamoí éna séna kesí sipisípimo áwiyoꞌwimba áíkaumne séna mimbóráwígóntáféna óraaꞌ-aamoi éna sáwífa-sipisipimo ímbo áwiyokombo úwoimo méraawiti aamoí kárikaꞌa wéiye. ");
INSERT INTO auy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sipisípiyaꞌo káráwiyowimo áwiyoꞌwi-sipisipisafenamo arunkómó umbaimó taintembá kentifo wíyómpakewi wení aampaꞌó ímbo wéaraaiwaen-kwaasisafena arunkó umbaí wétaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ísu minááí simátimena séna ení waási Maníkóní waásigomo embó sáwíꞌo uwánkainamo e wempáꞌá minááísáfé kosimámínana we aantemba méraindaraꞌa kosimámínana enáái isénamo arupísemo uwánkainamo ékai wesé eséꞌa kaweꞌá úmai méraakaiyo. ");
INSERT INTO auy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Enáái ímbo isáínamo e moóráwigonaꞌi kaekónáꞌi kotíꞌmai weséꞌa mé simámuwo. Maníkón-aai aúfáífimba agaimaréna séna moóráwigomba aaifimbá maenkánae séna minááímó ísaraawi kaeráꞌi kaumbowáꞌi tíꞌmaena mátinkena áísai úmai isáíníye siyáimba mindásafena ení waási enáái isáíndasafena moóráwigonaꞌi kaekónáꞌi kotíꞌmai wenkáꞌá méꞌa simámiyana kentáái isáíno. ");
INSERT INTO auy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Énifo ímbo isáínamo e Maníkóní waási torupátinke enáái simátímínasa mésa simámiyana wemó miwí tááimo ímbo isáínamo e imáyáa e sé Maníkóní aambó ímbo arááíwáén-kwaasiyaamba éna taakisi-úmén-kwáásíyáámbá wéiye siyó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ísu séna éraiꞌa simátimeꞌa súne. Marapáꞌó méraankaꞌa sáwíꞌo ombá aambó faíyónten-úmai Maníkó wíyómpaꞌa ména éꞌa aambá fáíꞌmakaiye. Kaweꞌó ombá ímbo aambó faíyónten-úmai Maníkó wíyómpaꞌa ména éꞌa miyá uráiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ísu minááí simátimena séna moórá-aai simátíménda ísáaro. Marapáꞌó méraankaꞌa kaeꞌ-wáásígóráímó moórá-aaisafesaraimo mimbórá-ímáyáámó ésaraimo kesifo wíyómpakewimo áísai íyanamo éna miyá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kaumbo-kaeꞌ-wáásí kentáfésa imáyáa ésa túwaandu ombá túwaꞌnai ondasáféꞌa miwíséꞌa ménaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ísu minááí súwana Pítaa Ísumpaꞌa téna séna Fasiꞌaénkóo kesí waásimo sáwíꞌo uwásínkáfaꞌo wéiyomba mindásafeꞌa nóraumai-kanaawa ímba aaifimbá maenkéra ímba imáyáa éra ifátuwanaumno. Afakaeté-kanaa sáwíꞌa uwásínkáímba ímba aaifimbá maenkéꞌa ímba imáyáa éꞌa ifátuwaunda póꞌa moórá-kanaamo sáwíꞌo uwásinkaindaraꞌa aaifimbá ína maenkéra ína imáyáa éra ifátuwanaumno súwana ");
INSERT INTO auy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ísu séna ímba afakaeté-kanaa aantembanifo úwoi miyá úmae iyuwó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ísu séna sáwíꞌo uwátínkáámba ímba imáyáa éꞌa ifátúwáaromo súnda maarásáféꞌa súne. Maníkó wení waásimo kawáámó in-ááí maarán-ááín-iye. Moórá óraaꞌ-waasigo wení kísau-waasi óntamba wááu tímakena ");
INSERT INTO auy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","tísai ónae wéimba óraaꞌ-ontamba 10,000,000 ontamba wááumo ámakaiwaimba moóráwigo áíꞌmaena móaminkwae séna íyísana ");
INSERT INTO auy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ímba móamintafena óntan-anafo wení kísau-waasisafena séna wembá aiyéꞌa awaainínkómbá aiyéꞌa wení iyámpóíye wení póíye wení óntawe maimaéꞌa fíꞌon-kwaasiti kísaumo maíndasafeꞌa miwí wétimeꞌa óntamba maimaéꞌa kemó tukáunda-ontankaamba úmai másíméro sisaná ");
INSERT INTO auy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","wení kísau-waasigo aísamaifimba kífaena séna arumbá uwásinkema simuꞌmakénaꞌa óntamba saafá éꞌa seyaafáꞌá áméno sisaná ");
INSERT INTO auy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","wení óraaꞌ-waasigo arumbá uwánkena séna kanaán-ifo wááumo ámakaunda-ontamba ímba imáyáa ónaumpo ifátuwaao sisaná ");
INSERT INTO auy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","kísau-waasigo máápaꞌa kuména moórá kísau-waasigomba awánéna káriꞌ-ontamba 100 ontamba ámakaiwaimba awánéna amóísáúmba kuntaraména óraaka séna wááumo ámakaunda-ontamba minúwóíyáámbá simiyó sisaná ");
INSERT INTO auy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","wenaísamaifimba kífaena séna arumbá uwásinkema simuꞌmakénaꞌa óntamba saafá éꞌa áméno sisaná ");
INSERT INTO auy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ímba iséna áíꞌmaena ándáfaꞌa móankena séna wááumo ámakaunda-ontamba símínasa faútúwáaro sisasá ");
INSERT INTO auy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","kísau-waasisomba awánésa tirumbá uwánkesa miwítí óraaꞌ-waasigomba kosimáméwana ");
INSERT INTO auy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","óraaꞌ-waasigo iséna wení kísau-waasigo sáwífaꞌ-ontamba 10,000,000 ontamba maiyáiwaimba áántaisana tisaná séna sáwí-kisau-waasi óne. Kentáfé arumbá uwásinkaao séndasafeꞌa miyá éꞌa óraaꞌ-ontamba wááu ámakaunda-ontamba ímba imáyáa ónaumpo ifátuwe ímba simiyó séꞌa ");
INSERT INTO auy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","sirumbó uwánkaraundantemba moórá-kisau-waasigomba arumbá uwánkááraamba sáwíꞌa óne séna ");
INSERT INTO auy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","arumbá óraa-sawiꞌa uwánkena ándáfaꞌo káráwiyaiwaikaꞌa móankena séna wááumo ámakaunda-ontamba seyaafáꞌá simína faúꞌauwaao sisaná ándáfaꞌa ánkaraiye ");
INSERT INTO auy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ísu simátimena wení kísau-waasisafena séna kentí waásimo sáwíꞌo uwátínkáámbo ímbo ifátuweꞌo imáyáamo úmaeꞌo wéiyiyanamo éna kesifo wíyómpakewi kentí sáwí-imayaa ímba maitiyuwáíníye. Óntan-anafomo intembá kesifo miyá uwátinkainiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ísu mináyáátááꞌ-ááí simátimena Káríri-aempaꞌa tuwéna Yúndiyaa-aempaꞌa Yóndani-nonkoni menáípáꞌ-áémpáꞌá komérowasa ");
INSERT INTO auy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","sáwífaꞌ-waasi tóso uwaná tíꞌo ún-kwaasi asófatinkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Asófatinkowasa ámáán-kawaa-waasi sésa Ísumo sáwí-aaimo sínda isánae sésa Ísumpaꞌa tésa sésa moórá-waasigo maanááísáfénawaꞌi fíꞌo-fiꞌon-aaisafenawaꞌi awaainínkómbá kanaará auwáíníyo. Miyámó énamo éna ámáán-aai taraisíni ína taraisíníyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ísu séna naaófáꞌó Mósesemo agaimakáin-aai toráumai awánaraawe. Maarán-ááí agaimaréna séna Maníkó wíyóne marawémó úmaronkaꞌa aarewárá waaiwáráꞌá úmakaiye. ");
INSERT INTO auy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Úmarena séna aarewárá waaiwáráꞌá úmakaundasafesa tinófoi tiyuwésa awaaikóe awaainínkóeꞌa tagááísamai mimbórá-túmá maꞌmái méranaawe Maníkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mindásafesa awaaikóe awaainínkóeꞌa ímba kaeꞌ-wáásíyáámbá ésa mimbóráíꞌa wéowe. Maníkó aare-waaí mimbóráíꞌa uwátínkaraintafesa ímba tuwínáaro Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","miwí sésa naaófáꞌá Mósese maará siyáiye. Moóráwigo awaainínkómbá aiꞌmátuwaindawi aúfáífimba agaimaréna séna kesuwaainímbá aiꞌmátuwaumne séna agaimái amíno siyáiye. Nóra sénawa miyán-ááí siyáiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ísu séna kentíwáꞌná tirumbó makáamba pósa Maníkón-aai ímbo ísóntafena mindásafena Mósese minámáámbá siyáimbanifo Maníkó wíyóne marawémó úmaronkaꞌa ímba miyá siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Simátimeꞌa súne. Moóráwigomo awaainínkó ímba moórá-waasigoeꞌa wénisana awaaikó fíꞌon-aaisafena aiꞌmátuwenamo fíꞌon-inimbo wémaimba umémbá wémaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ísu minááí simátimena mérowasa wení kísau-waasi sésa aaremó máémba sénda-aai wérainkaꞌa pósa miyá wéofo ímbo aaremó maésamo úwoimo máémba kaweꞌá wéowe suwaná ");
INSERT INTO auy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ísu séna sen-ááí seyaafáꞌnánká ímba kaweꞌá úmai ísááwasa aaremó ímbo maíyantafesa Maníkó fasiꞌaémbá tímakaiwai minááí wéisaawe. ");
INSERT INTO auy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tuwímbai moórá-mora-aaisafesa ímba aaré máéwasa tuwímbai tinófoi uwó-wáásí matínkaraawi aaré ímba máéwasa tuwímbai túmo sáwíꞌo uwátínkaraawi aaré ímba máéwasa tuwímbai Maníkó wení waásimo kawáánin-aai isésa Maníkóntáfésa imáyáa ésa aaré ímba wémaewe. Kanaaꞌá miyá ónaumnemo sewí minááí isánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ísu simátimuwasa tuwímbai Ísu taꞌótorena kaweꞌá uwátinkena Maníkómpáꞌá inaí sínkwae sésa iyámpói tíꞌmae tuwasá wení kísau-waasi sésa tíꞌmae kóro suwaná ");
INSERT INTO auy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ísu simátimena séna ímba kóro síyamba tiyuwáíyasa kempáꞌá iyámpói úwoi teró. Miníyámpóímó kempáꞌó tentembá Maníkó wení waásimo kawáánimba miyáráán-úmai wégawaanimba iyámpóímo kempáꞌó tíyan-amba ímba aambá faíyóro séna ");
INSERT INTO auy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","miníyámpóí taꞌótokena ayááfúmba tátinkena tíyukaiye. ");
INSERT INTO auy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tiyuwówana moóráwigo ifóꞌ-wáásígó Ísumpaꞌa téna séna óraakoo nóran-kawera éra aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónaumno súwana ");
INSERT INTO auy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ísu séna nóra séwa kawe-kísáúsáfé sísai ónó. Mimbóráwígó Maníkó weyáá kawekón-iye. Aúíꞌa úmai maéꞌmaeꞌa ónaemo sémo e Maníkóní ámáámba kaweꞌá úmai arááíwauwo súwana ");
INSERT INTO auy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","miwá áísai ena séna nóin-amaana arááíwaenaumno súwana Ísu séna ímba tínkamiyasa púwóro. Ímba aare-úmémbán-oro. Ímba umémbá máéro. Karoꞌ-ááí ímba simátínkáaro. ");
INSERT INTO auy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kentinófoi-tuwiꞌa óraaꞌ-iꞌan-oro. Kesáfé-ímáyáámó onten-úmai kentí waási-imayaawaraꞌa oro. Miyáumai-amaamba arááíwauwo Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","miwá séna minámáámbá arááíwaꞌmaeꞌa wéiyumpo nóran-amaankona ímba kaweꞌá wéuno súwana ");
INSERT INTO auy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ísu séna seyaafá-tántááꞌó kanaaꞌó émo e ení moparáwímbá fíꞌon-kwaasi wétime óntamba maiyé ímbo makéwi tímínana ení kaweꞌ-méyámbá Maníkó wíyómpaꞌa ankáíníye. Tímatuwemo e kembá sirááíwainone súwana ");
INSERT INTO auy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","minááí iséna sáwífaꞌ-moparawimbo makóntafena óraaꞌ-imayaa úwana arunkó sáwíꞌa úwana kuráiye. ");
INSERT INTO auy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kúwana Ísu wení kísau-waasisafena séna éraiꞌa simátimeꞌa súne. Sáwífaꞌ-ontamo makén-kwaasi Maníkómó wení waásimo kawáánipaꞌo wíyamba umbaí táíníye. ");
INSERT INTO auy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Moórá-poigon-awiꞌa káámeri mimpóígó waigóní afaapimbá ímba kanaaꞌá kóferainiye. Káámeri-poigomo waigóní afaapimbó kóféráínkakaa sáwífaꞌ-ontamo makén-kwaasi Maníkómó kawáánipaꞌa kowisinó Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","wení kísau-waasi minááí isésa táátafesa ésa sésa umbaí taifó nóran-kwaasiya Maníkómó kawáánipaꞌa ménaao suwaná ");
INSERT INTO auy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ísu tuwánéna séna waási miwítí kísausamba ímba méyámbaresa kónááfo Maníkó seyaafá-tántááꞌá úwoi kanaaꞌá wéiye súwana ");
INSERT INTO auy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pítaa séna isaaó. Kentáásí seyaafá-tántááꞌá tuwéta entá wéaraaiwaumpo nóram-beyana maénaumno súwana ");
INSERT INTO auy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ísu séna éraiꞌa simátime súne. Maníkó seyaafá-tántááꞌá aúíꞌa úmaraindaraꞌa kemá waási úranko fasiꞌaénkwáráwí méꞌa káráwiyonaꞌa kembiwí sísamaifakemba kaeꞌá kumbaimái-waasi kembó wésiraaiwaewi Ísareri-waasi méraan-aaisafeꞌa tísai ónááwe. Ísareri sísamaifakemba kaeꞌá kumbaimái matínkaraiwain-andafakewi méraan-aaisafeꞌa tísai ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kentáfésa imáyáa ésa Maníkón-aai kosimátimiyantafesa naaópaꞌa tuwésa tuwaaísáiye tífáꞌe tímánaaꞌe tinófoiye táánine tiyáámúne tiyuwésa miwítí maramó túwááwin-anondaa túwáán-tantaaꞌa miyán-tántááꞌá sáwífaꞌa maésa aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ánaaemba aifarááwífínkémbá tuwímbai tínaaeniꞌa íyasa tínaaenkewifinkemba tuwímbai aifaríꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ísu minááí simátimena séna Maníkó wení waásimo kawáámó in-ááí maarán-iye. Moóráwigo ándá-aran-kisaugoni afowá kesí kísau máíwae séna ááéma íyáfasinkena waási saafá úmai tuwánéna ");
INSERT INTO auy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","séna kesí kísau wémaiyaꞌa moórá-kanaa-kisaugoni óntamba tíméno sisasá ewé sewaná tíꞌmaena wení ándá-aran-kisaufaꞌa mótinkaisasa kísau wémaewana ");
INSERT INTO auy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","aafáyáara fíꞌonkwaraꞌa kísau máíwae séna kísaumo maénae sésamo túwaandu opaꞌá wéna tuwánéna ");
INSERT INTO auy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","séna kesí kísau wémaiyaꞌa kanaaráꞌ-óntámbá tíméno sisasá ");
INSERT INTO auy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ewé sésa minkísáú wémaewana wááwái miyáumai fíꞌonkwaraꞌa wétiyena fénáímpinkaꞌa fíꞌonkwaraꞌa wétiyena ");
INSERT INTO auy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","kísau taíꞌén-kanaa kárikaꞌa tisaná kísaumo maénae sésamo túwaandu opaꞌá wéna tuwímbai tuwánéna séna nóra séra úwoi méraꞌo sisasá ");
INSERT INTO auy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","sésa ímba moóráwigo kesí kísau máéro siyáawata méraumne sewaná tiyéꞌa kesí ándá-aran-kisaufaꞌa kísau máéro sisasá miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Miyá owaná fénáímpinkaꞌa kísaugon-afowá kísau-waasiyaꞌo káráwiyaiwaintafena séna kísau-waasi táántare miwítí méyámbá timé ánaaembo tiyáawi aifaꞌá timé aifaꞌó tiyáawi ánaaemba timiyó sisaná ");
INSERT INTO auy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","iséna miyá éna kísau taiꞌáíníye wéinkaꞌo tiyáawi moórá-kanaa-kisaugoni óntamba tiména miyáumai tímatuwena ");
INSERT INTO auy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ááéma aafáyáaraꞌo tiyáawiti méyámbá timíne wéisasa miwí imáyáa ésa kentáásí méyámbá óraaꞌan-iye wésewana moórá-kanaa-kisaugoni óntamba tímísasa ");
INSERT INTO auy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","maimaésa kísaugoni afowámbá íꞌai simánkesa ");
INSERT INTO auy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","sésa ánaaembo tiyáan-kwaasi kári-kisau maiyáafo kesáá aifaꞌó tiyáundawisa óraaꞌ-aꞌa wégaisata umuꞌnáán-araaꞌa méta óraa-kisau maiyáundasa mimbóráíꞌa úmaisa méyámbá símakaandasa nóra séwa kentáámó siméndantem-beyamba miwí tímakaano sewaná ");
INSERT INTO auy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","kísaugon-afowá miwífínkémbá moóráwigontafena séna kesí waásiyo kemá séꞌa kesí kísau wémaewaꞌa moórá-kanaa-kisaugoni óntamba tíméno súnaꞌa ewé séꞌa kísau maiyáawaꞌa mindásafeꞌa ímba sáwí-meyamba wétimumpo ");
INSERT INTO auy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","kentí méyámbá maimaéꞌa koró. Kembó timúndantem-beyamba ánaaembo tiyáawi miyám-béyámbá timénaeꞌa wéune. ");
INSERT INTO auy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kesí óntambo tuwímbareꞌo timúnda mindá kendén-iye. Kári-kisaumo maiyáawi óraaꞌ-ontamba timúnaꞌa ímbo kaórááraamba wégaoraawe kísaugon-afowá siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ísu minááí simátimena séna miyáráán-úmai Maníkó wení waásimo kawáánipaꞌa aifaꞌó kowí íyasa ánaaembo kowíséꞌa mimbóráíꞌa úmai aasiyaasí aúíꞌa úmai maéꞌmaeꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ísu séna Yérúsaremu-naopaꞌa kónae séna aampaꞌá wéwena wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi tíꞌmaena moórá-aempaꞌa tínkarena ");
INSERT INTO auy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","simátimena séna ísáaro. Yérúsaremu-naopaꞌa konanasá moóráwigo kembá waási úrankomba óraaꞌ-amaan-kisau-waasiye ámáámbo sen-kwáásíyé aráátiminasa kembó sínkamiyan-aai símai káráꞌumaresa ");
INSERT INTO auy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","síꞌmai fíꞌonkaa-waasi timíyasa karaánááꞌa sinkésa súwiyonkuꞌ-nésa aaraa-táíyáꞌá sínkamiyaꞌa púwónasa utámaraiyaꞌa kaumbo-kánáá maisuwéꞌa íyáfasinanaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Minkánáá Sépétin-ááninkai tinówama tíꞌmaena Ísumpaꞌa téna moórá-tantaatafenamo áísai índasafena óraakon-iye séna takífauwana ");
INSERT INTO auy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ísu séna nóintafewa sísai íníyewa wéono súwana tinówa séna emó kawáánindafaꞌa kesááninkai íyáfasintinke séfasefaꞌ-arausampaꞌa tinkáínone súwana ");
INSERT INTO auy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ísu séna sénda-aaigoni áwáuma ímba ísaraiye. Sáwí-nombo anaféúmpínkémbó naandantén-úmai síꞌo índa-iꞌa uwásinkaiyantena keráí kanaará kemó naanda-ánáfeumpinkemba náyááyo súwasarai keráí kanaámpókai náyauye suyaná ");
INSERT INTO auy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ísu séna éraiꞌa séye. Kemó naanda-ánáfeumpinkemba náyááfo kesí séfasefa-sirausampaꞌa kemá ímba íyáfasintinkanaumpo Maníkó kaeꞌnárai uwátínkaraimba póna íyáfasintinkainiye súwasa ");
INSERT INTO auy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ísuni kísau-waasi siyáánkai-waasi minááí isésa mináfáráwáí aaisambá tíyúwana ");
INSERT INTO auy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ísu táántowasa tuwaná séna éꞌa ísaraawe. Marapáꞌ-órááꞌ-wáásísómbá íyáákamai-fasiꞌaen-aai simáti-simati uwasá wenkóyááka-tayaaka uráawe. ");
INSERT INTO auy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Óraaꞌ-waasimo ontembá kembiwí ímba miyán-oro. Kempínkémbó íyáákanaemo síyawi fíꞌowiti wayóꞌá maénááwe. ");
INSERT INTO auy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kempínkémbó aifaríꞌa ónaemo síyawi seyaafáꞌ-wáásítí kísau túwaꞌnai oro. ");
INSERT INTO auy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kemá waási úranko ímba súwaꞌnai íwaeꞌa kunkáumpo kemá waási túwaꞌnai ónaeꞌa kunkáumne. Sáwí-imayaafinkembo faútínkáandasafeꞌa puwónaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ísuwe wení kísau-waasiye Yéríko-naopakemba kumbá sáwífaꞌ-waasi tínaaemba kumbá ");
INSERT INTO auy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","kaeꞌnárai túramba kafíkóndarai aanawáísáraꞌa mésarai Ísu wétiye-aai isésarai óraaka sésarai Téfítin-andafakewi ómpo arunkáí uwásinkaao suyasá ");
INSERT INTO auy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","misáwífáꞌ-wáásí aaisambá tiyésa sésa aaí séyafo suwasaráí minááí ifátuwesarai anekaꞌá óraaka sésarai óraakoo Téfítin-andafakewi ómpo arunkáí uwásinkaao wésuyana ");
INSERT INTO auy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ísu aampaꞌó kúmba minká koména tísai ena séna nóin-tantaara tirááímo táínda-tantaaꞌa uwátinkanaumno súwasarai ");
INSERT INTO auy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","óraakoo súramba kaweꞌá uwásinkaao suyaná ");
INSERT INTO auy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ísu arumbá uwátinkena ayáámba túrankaꞌa taꞌótorowasarai minúwóíyáámbá túramba kaweꞌá úmai awánésarai Ísumba arááíwaꞌmae kurááye. ");
INSERT INTO auy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ísu wení kísau-waasiseꞌo kumbá Yérúsaremu-naoꞌ-ampaꞌa kumbá Órífi-omakaꞌ-ewaaꞌ-naoꞌ-awiꞌa Pétífasi-naoꞌa ewaaꞌá wésa wení kísau-waasi kaeꞌá mátiꞌmarena ");
INSERT INTO auy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","séna epín-dáópaꞌa kurékai awáneyamba moórá-poigon-awiꞌa tónki ándá fáríꞌwimaraawana árááꞌwaraꞌa méraifo koawánékai ándáma faútuwekai áíꞌmae tekaiyó. ");
INSERT INTO auy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Moóráwigo tuwánénamo tísai ínakai óraako ayááꞌmae kónae siyé kosimámiyana séna énifo áíꞌmaekai kokaiyó síníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Naaófáꞌá Maníkón-aaimo simátímakowi siyáintemba Ísu miyá uráiye. Maníkón-aai simátímakowi séna ");
INSERT INTO auy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sáíyóni-naopaken-kwaasisafe simátime sé kentí kawáágó kentópaꞌa wempaꞌá témena tónki-poigo ayááꞌmaena téna tónki-poigon-araako ayááꞌmaena wétiye simátimiyo siyáiye agaimaréna Sáíyóni-naopaꞌemo siyáimba Yérúsaremu-naopatafena siyáiye. Minááímó paápé índasafena Ísu kaeꞌnárai tiꞌmarówasarai ");
INSERT INTO auy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ísumo súntemba miyá ésarai ");
INSERT INTO auy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","tónki-poi árááꞌwaraꞌa áíꞌmaesarai Ísumpaꞌa tuyasá wení kísau-waasi paákákén-únánkwátói faúꞌmai mimpóígón-arósááunkaꞌa wandaaí uwíꞌmárówana Ísumba ayááꞌmae wéguwasa ");
INSERT INTO auy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","sáwífaꞌ-waasi mésa óraaꞌ-waasin-iye sésa tuwímbai paákákén-únánkwátói faúꞌmai tuwímbai taaénáma ankáímai aampaꞌá uwíꞌmaꞌmae wéguwana minúnánkwátóiyaꞌe mintáénárafane támae wéguwasa ");
INSERT INTO auy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","aifaꞌó tun-kwáásíyé Ísun-ánaaembo tun-kwáásíyé óraakaꞌ-oraakaꞌa sésa Téfítin-andafakewin-awiꞌa mósá wémaraumne. Fasiꞌaénkó aiꞌmáráísana kunkáiwaimba Maníkó kaweꞌá uwánkáíye. Wíyómpakewin-awiꞌa mósá maráúmne óraakaꞌ-oraakaꞌa suwaná ");
INSERT INTO auy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ísu Yérúsaremufaꞌa kúwasa tuwaantantésa tóso wéesa nááwawa wétiyo suwasá ");
INSERT INTO auy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tuwímbai sésa Ísu Maníkón-aaimo simátímíwai Káríri-aempakemba Násareti-naopakewin-iye siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Suwaná Ísu Yérúsaremu-naopaꞌa óraaꞌ-amaan-daumpaꞌa Maníkóní naaúmpaꞌa iyéna ámáán-daumpaꞌo méyámbó wéun-kwaasi tuwánéna itiꞌmátuwena óntambo wéwaeron-kwaasiti taaremá tawísísuwena Maníkóntáfésa imáyáa ésa mááufuꞌ-numamo wéamun-dumama méyámbárón-kwaasiti taaremá tawísísuwena ");
INSERT INTO auy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","simátimena séna Maníkón-aai aúfáífimba agaimaréna séna kesí naantafésa sésa Maníkómpáꞌó inaimó sen-dámbán-iye wésewe agaimaréna siyáiye. Énifo umén-dáúmpáꞌó ontenkáámbá uráawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ísu minááí simátimena óraaꞌ-amaan-daumpaꞌa mérowasa túrambo kafíkówiye tíyayaambo táúnkowiye wempáꞌá tuwaná asófatinkowasa ");
INSERT INTO auy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","iyámpói mésa óraakaꞌ-óraakaꞌa sésa Téfítin-andafakewin-awiꞌa mósá wémaraumne sumbá óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé isésa Ísumo fíꞌoran-kawe-kisaumo maúmba awánésa tirumbá sáwíꞌa uwánkesa ");
INSERT INTO auy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ísuntafesa sésa iyámpóímo sáwí-aaimo wésemba ína wéisaano suwaná Ísu séna éꞌa wéisaunda Maníkón-aai aúfáífimba agaimakáin-aai awánaraawe. Maarán-ááí siyáiye. Túwaꞌnai óndasafesa pósa iyámpóíye umarané enáwíꞌa mósá wémaraawe agaimaréna siyáiye Ísu simátimena ");
INSERT INTO auy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tiyuwéna máápaꞌa kuména mindáópaꞌa tuwéna Pétáni-naopaꞌa wéna mindóꞌwáámbá kowaiyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pétáni-naopaꞌa kowáúmba íyáfasinesa Yérúsaremu-naopaꞌa tumbá Ísumba áái tówana ");
INSERT INTO auy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","moórá-taigon-awiꞌa fíkima aankón-awáísáfaꞌa wérowana mintáéramba nánae séna áwáufaꞌa wéna awánómba áná aantemba wérowana mintáígóntáféna séna emá ímba arambá iyáínone súwana mintáímá aáénkaraiye. ");
INSERT INTO auy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mintáí aáénkówasa Ísuni kísau-waasi awánésa táátafesa ésa tiyáámba tóipimba faafésa sésa fíki-tai ááéma aáénkaraiye suwaná ");
INSERT INTO auy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ísu séna éraiꞌa simátime súne. Maníkóntáféꞌo ímbo kaeꞌ-ímáyáámó éꞌo fasiꞌaén-ímáyáámó éꞌo éꞌa fíki-taigontafeꞌo súnanamo aáénkaintemba kanaaꞌá miyá éꞌa ímba miyá aantemba éꞌa maanómátáféꞌo séꞌo faiwíꞌwé nompáꞌá kumuwómó síyanamo éna miyá íníye. ");
INSERT INTO auy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Maníkómpáꞌá inaí séꞌa fíꞌo-fiꞌon-tantaatafeꞌa áísai eꞌa timankúnkúmba ombá éraiꞌa Maníkó kanaaꞌá súwaꞌnai uwásinkainiyemo sembá kanaaꞌá wétuwaꞌnai-iye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ísu minááí simátimena óraaꞌ-amaan-daumpaꞌa iména Maníkóní ásé-aai simátimuwasa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye tésa sésa nááwawa aiꞌmáráísawa tiyéwa nááwampinkena maiyéwa fasiꞌaén-kísáú wémaeno. Simásimiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ísu séna aifaꞌá moórá-aaimo tísai onaꞌó anondáámo síyaꞌo éꞌa sísai on-ááí simátimenaumne. ");
INSERT INTO auy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ááéma Yóni nombó maitínkaraiwai Maníkówá simámakaisanawa nombá maitínkarai waásiya simámakaawanawa nombá maitínkaraiyo súwasa miwí keáímbá sésa nórasaawa sénaumno. Maníkó simámakaisana nombá maitínkaraiye senanasáámó éna nóra séra Yónin-aaisafeꞌa ímba éraiꞌe siyáao síníye. ");
INSERT INTO auy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Waási simámakaawana nombá maitínkaraiye senasasáámó ésa úwoi-waasisa sínkamonaawe. Úwoi-waasi sáwífaꞌ-waasi Yónintafesa Maníkón-aaimo simásímakaiwai uráiye wésemba pósa aaisantá siyónááwe miyá keáímbá sésa ");
INSERT INTO auy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ísuntafesa sésa emó sísai ónda-aaisa ímba isáúmne suwaná Ísu séna ímbo simásimiyaꞌa nááwampinkena maiyéra fasiꞌaén-kísáúmó maúnda-aai ímba simátimenaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ísu minááí simátimena séna simátíménda-aai imáyáan-oro. Moóráwigo kaeꞌ-íyámpóíwáráwí aifarááwíntáféna séna kesááninkoo kesí ándá-aran-kisaufaꞌa kísau komauwó sisaná ");
INSERT INTO auy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","aifarááwí séna ímba siráái taiyé séna ména moórá-imayaa éna kísau komáísana ");
INSERT INTO auy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","áfákontafena séna kesí ándá-aran-kisaufaꞌa kísau komauwó sisaná ewé símai ifátuwena ímba kísau maiyáiye ");
INSERT INTO auy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ísu simátimena tísai ena séna nááwa tifowán-áái wéisaiyo súwasa aifarááwí afowán-áái wéisaiye suwaná Ísu séna minááí imáyáa éꞌa simátíménda-aai ísáaro. Taakisi-úmén-kwáásíyé sáwí-ankaꞌo nón-inine sáwíꞌo on-kwáásín-owe sembánifo miwí Maníkó wení waásimo kawáánin-ampaꞌa ááéma wégofo kembiwíndo. ");
INSERT INTO auy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yóni nombó maitínkaraiwai téna kaweꞌ-ámbá aráátimuwaꞌa wenááisafeꞌa ímba éraiꞌe siyáafo taakisi-úmén-kwáásíyé sáwí-ankaꞌo nón-inine Yónin-aaisafesa éraiꞌe suwaꞌá kembiwí miwí tuwánéꞌa Yónin-aaisafeꞌa ímba éraiꞌe séꞌa kentí sáwí-imayaa ímba tuwéꞌa Maníkómpáꞌá tiyáawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ísu minááí simátimena séna moórá waéꞌmai-aai simátíménda ísáaro. Moóráwigo óraaꞌ-marawarawi ména óntan-kusai úmakena ándá-aran-kisau úmarena ándá-arankoni táúfaꞌa úmarena ándá-arambo mapamínanamo anombó kumínda-taufaꞌa úmarena óntan-damba kísauraꞌo káráwiyan-damba úmarena ayáátááka fíꞌom-barafaꞌa koménae séna maankísáúráꞌó káráwiyawimo éꞌa kesáféꞌa tuwímbai-aramba wémaeꞌa tuwímbai kembá siyúwáaro simátimena fíꞌom-barafaꞌa koméraisana ");
INSERT INTO auy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","arambó áfumo kain-kánáá tisaná aanáfó kesí ándá-aramba komáéro séna wení kísau-waasi tiꞌmáráísasa minkísáúráꞌó káráwiyowifaꞌa tewasá ");
INSERT INTO auy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","taꞌótoꞌmai moóráwigomba tufuwésa moóráwigomba tufúꞌmárááwana púwísasa moóráwigomba óntantamba tufuwésa ándá-aramba ímbo tímémba tiꞌmátuwaawasa kowaná ");
INSERT INTO auy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","aanáfó aifaꞌá wení kísau-waasi tuwímbai tiꞌmaréna ánaaemba sáwífaꞌnanka tiꞌmáráísasa tewasá minkísáúráꞌó káráwiyowi taꞌótoꞌmai aifaꞌó uráantemba miyá ésa sáwíꞌa uwátinkesa ándá-aramba ímba tímémba tiꞌmátuwaawasa kowaná ");
INSERT INTO auy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","aanáfó ména ánaaemba séna kesááninkomba aiꞌmáráanana wínasa wenáái isánááwe séna aiꞌmáráísana tisasá ");
INSERT INTO auy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","minkísáúráꞌó káráwiyowi awánésa keáímbá sésa aanáfón-ááninko wétifo tufúwónanasa puwéna maankísáú ímba maínata kesáá maénae sésa ");
INSERT INTO auy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","taꞌótoꞌmai ándá-aran-kisaufakemba famétuwesa tufúwówana pukáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ísu minááí simátimena séna minkísáúgóní aanáfó tínda kísauraꞌo káráwiyowi nóra síníyo súwasa ");
INSERT INTO auy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","miwí sésa misáwí-wáásí tínkaminasa puwíyana fíꞌon-kwaasi kesí kísauraꞌa káráwiyoro sínasa minkísáúráꞌá káráwiyesa arambó áfumo kain-kánáá tíndantemba aanáfómbá minárámbá aménááwe siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Suwaná Ísu simátimena séna Maníkón-aai aúfáífimba awánaraawe. Maarán-ááí agaimaréna séna óntan-dambo on-kwáásí moórá-ontantafesa sáwíꞌa wéiye sésa maisukáawe. Ánaaemba minóntánkó áfonkaaamba uráiye. Mindá Fasiꞌaénkó isatá awánéta séta fíꞌoran-kaweꞌa uráiye súne agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Minááí imáyáa éꞌa simátimeꞌa súne. Maníkó kembiwí Yúndaa-waasisafena maará siyé. Kenkáꞌá ímba kawáánónaumne séna tiyuwéna fíꞌonkaa-waasisafena kenkáꞌá kawáánónaumne sínasa wení kísau maénááwe. ");
INSERT INTO auy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Minóntánkáꞌá tanaambá kofésa sáwíꞌa úmai ménaafo minóntánkó tufúꞌmai sáwíꞌa uwásuwainiye Ísu séna wenááisafesamo ímbo éraiꞌemo síyawi imáyáa éna minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ísu súwasa óraaꞌ-amaan-kisau-waasiye ámáán-kawaa-waasiye isésa tááko péé súwasa sésa moóráwigon-ááninkai aaimó simbá kentáásáféna siyé sésa ándá-aran-kisauraꞌo káráwiyowisafenamo simbá kentáásáféna siyé sésa óntankowemo simbá kentáásáféna siyé sésa ");
INSERT INTO auy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","taꞌótoꞌmai tufuwónae sésamo umbá seyaafáꞌ-wáásí Ísuntafesa sésa Maníkón-aai simásímíwain-iye sun-kwáásí táároi inkaisésa Ísumba ímba taꞌótoresa ifátukaawe. ");
INSERT INTO auy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Anekaꞌá Ísu aaí simátimindasafena waéꞌmai-aai simátimena séna ");
INSERT INTO auy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Maníkó wení waásimo kawáánin-aai maarán-iye. Moóráwigo káráwiyaiwain-ááninko aaré maíndasafena óraa-tanomba kaufónae séna ");
INSERT INTO auy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","sáwífaꞌ-waasi táántena séna aáno úmai tanómba tamandaaró séna ména tanómba kaumaréna wení kísau-waasi tiꞌmaréna séna tamandaaró kosimátíméro sisasá miyá owasá ifátuwesa ímba tewaná ");
INSERT INTO auy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","anekaꞌá kísau-waasi tiꞌmaréna séna táántaraundawi kosimátimeꞌa séꞌa tómbó nembá wétoꞌmayaan-eꞌa purumakawé óraa-poiye tufúꞌmai wégaufumpo tamandaaró. Kesááninkomo aaremó maíndaraꞌa tamandaaró. Kosimátíméro séna tiꞌmáráísasa miyá kosewasá ");
INSERT INTO auy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ifátuwesa ímba tembá moóráwigo wení kísaufaꞌa kóísana moóráwigo óntambo maínda-kisaufaꞌa kóísasa ");
INSERT INTO auy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","tuwímbai káráwiyaiwaini kísau-waasisomba taꞌótoꞌmai tínkamowasa púwówana ");
INSERT INTO auy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","káráwiyaiwai aaisambá séna wení i-wáásí tiꞌmáráísasa miwí tínkamowasa púwówasa miwítí naampimpáꞌá iyamá agáéwana káwisana ");
INSERT INTO auy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","káráwiyaiwai wení kísau-waasisafena séna tanómba kauféꞌa táántaraundawi kesááninkoni tanómbo tamandáíyawi sáwíꞌan-owe. ");
INSERT INTO auy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aampakáꞌó waásimo túwaandu opaꞌá kosaafá úmai fíꞌo-fiꞌon-kwaasi tuwánéꞌa simátimiyasa tanómba tamandaaró sisasá ");
INSERT INTO auy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","wení kísau-waasi isésa aampaꞌá wénesa waási saafá úmai tuwánésa sáwí-waasiye kaweꞌ-wáásíyé torupátinkesa tíꞌmaesa tésa tómbó naan-dáúmpáꞌá sisipáá uráawe. ");
INSERT INTO auy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Yúndaa-waasi aaremó máénkaꞌo ombá tanómbo nánaesamo ten-kwáásí ontaráꞌó tewasá kísau-waasi kaweꞌ-únánkwátói tíméwasa urésa mindáúmpáꞌá imésa tómbá wénaafo minúnánkwátóimo ímbo urésamo ésa ímba tómbá imandánááwe. Tómbó naan-dáúmpáꞌá sisipáá owaná káráwiyaiwai tuwánaimba moóráwigo ímba kaweꞌ-únánkwátói uréna méraisana awánéna ");
INSERT INTO auy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","séna nóra séwa kaweꞌ-únánkwátói ímba uréwa iyáano sisaná ímba aaí sisaná ");
INSERT INTO auy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","káráwiyaiwai wení kísau-waasisafena simátimena séna aíyayaankaꞌa káráꞌumai máápaꞌa kumeuꞌó in-áémpáꞌá aúwéwana ifiꞌá téna áíꞌo índasafena áwááyaamba umpufuwíníye siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ísu minááí simátimena séna Maníkó sáwífaꞌ-waasi táántain-kwaasifinkemba tuwímbai aantemba wení waási-iꞌa wéuwatinkaiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ísu súwasa ámáán-kawaa-waasi máápaꞌa kumbésa keáímbá sésa nóran-aaisaawa áísai onanasááwá sáwí-aaimo sínata aaifintá maenkánaumno sésa ");
INSERT INTO auy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","miwí tínaaenkaꞌo tirááíwáún-kwaasiye Éroti amááraawe tiꞌmárówasa Ísumpaꞌa tésa sésa óraakoo éraiꞌ-waasi po Maníkóní aambó arááíwáén-aai arupíse úmai simátimendasa ísaraumne. Waási táároi ímba inkaisé óraaꞌ-waasiye úwoi-waasi táároi ímba inkaisé tirumbó faiyáꞌmai-aai ímbo sénda arupíse úmai simátimendasa ísaraumne. ");
INSERT INTO auy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Simáménda-aaisa isaaó. Kanaasááwá taakisi-óntámbá Rómu-kamanisa timénaum íntaawa timénaumno. Tíméndasa Yúndaa-waasisa kentáásí ámáámba taraisónaum íntaawa taraisónaumno. Nóran-imayaamo émo e simásimiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ísu miwítí sáwí-imayaa iséna séna kaumbo-kaeꞌ-ááíwáráꞌ-wáásí póꞌa kentáféꞌa sáwí-aaimo síndawe séꞌa wésisai-owe. ");
INSERT INTO auy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Taakisi-óntámbá moórá maimaé máaraasimero súwasa maimaé máaraanamuwana ");
INSERT INTO auy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","séna nááwan-óikaana uráinkara áwíꞌa wéraiyo súwasa ");
INSERT INTO auy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","miwí sésa Rómu-kamani-kawaagon-óikaamba isaná áwíꞌa wéraiye suwaná Ísu séna Rómu-kamani-kawaagonde wembá áméro. Maníkóndé Maníkómbá áméro súwasa ");
INSERT INTO auy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","minááí ísówana tááꞌa úwasa ímba aaí sésa auwésa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kuwasá Sátúsi-amaan-kawaa-waasi púwómpinkemba ímba íyáfasinanaawe sun-kwáásí pósa minkánáá Ísumpaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","sésa óraakoo naaófáꞌá Mósese séna moóráwigo aaré maimakéna iyámpói ímbo maꞌánkáímba puwínana áfáko maimakéna awaaón-anondaa-wareꞌe séna iyámpói maꞌankáíníye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Moórá-aai isaaó. Moórá-kanaa maankáꞌá afakaeté-afarawainonda mésa tuwaaó aaré maimakéna iyámpói ímbo maꞌánkáímba púwísana ");
INSERT INTO auy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","wenánaaenkewi wareꞌá maimakéna iyámpói ímbo maꞌánkáímba púwísana wenánaaenkewi wareꞌá maimakéna iyámpói ímbo maꞌánkáímba púwísana miyá émesa afakaeté-waasi putásaawana ");
INSERT INTO auy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","minínínkó ánaaemba pukáiye simámesa ");
INSERT INTO auy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ísumba áísai esa sésa miyámó ombá waási puwíyampinkembo íyáfasinaiyan-kanaa minínímbá afakaeté-waasi tuwaainímbá éna nááwa máíníyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ísu séna Maníkón-aai aúfáífimbo agaimakón-aai ímba kaweꞌ-úmai iséꞌa Maníkóní fasiꞌaémbá ímba awánéꞌa póꞌa miyáumai sáwísáwí-aai wésewe. ");
INSERT INTO auy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pukémpinkemba íyáfasinesa wíyómpaꞌo imaíyan-kanaa aaré ímba maíyasa waaí ímba maíyamba ésa Maníkóní kísau-waasimo wíyómpaꞌo méraawimo ontembá minínínákwáꞌá miyáumai aaré ímba maíyasa waaí ímba maíyamba ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Waási pukémpinkembo íyáfasinaiyamba simátíménda ísáaro. Maníkó simátímakomba aúfáífimba agaimakón-aai toráumai awánaraawe. ");
INSERT INTO auy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Maníkó Mósesentafena maarán-ááí siyáiye. Maníkó úne. Enaíwáꞌná Émbaramune Áísáakine Yékopune miwítí Maníkó úne siyáiye. Maníkó minááímó siyáimba minkáúmbó-wáásí éꞌa púwúwasa utaráambanifo minááí siyáimba pósa miwí úwoi méraawe Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","weséꞌo méron-kwaasi isésa táátafesa ésa sésa aaigóní áwáuma wésimasimiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Suwaná Ísun-aaigo Sátúsi-amaan-kawaa-waasi-taai íyáákomba ámáán-kawaa-waasi isésa túwaandu ésa ");
INSERT INTO auy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","miwífínkémbá moóráwigo ámáámbo kaweꞌó úmaimo ísarowi Ísumo sáwí-aaimo sínda isánae séna áísai ena séna ");
INSERT INTO auy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","óraakoo Maníkóní ámáámpinkemba nóran-amaana aifaráámbán-iyo súwana ");
INSERT INTO auy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ísu séna Maníkón-aai aúfáífimba agaimaréna séna Maníkómpáꞌá kentí Fasiꞌaénkómbá kentiruné kentí imáyáawe kentimané áméro agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Minámáámbá aifaráán-ámáámbá isaná ");
INSERT INTO auy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","miwán-ánaaenken-amaamba óraaꞌ-amaamba maarán-ámáámbán-iye. Maníkón-aai aúfáífimba agaimaréna séna kesáfé-ímáyáámó ontembá kentí waási-imayaawaraꞌa oro agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Minkáéꞌ-ámáánkó áfonkaamba uráisana Mósesemo fíꞌon-amaambo siyáine Maníkón-aaimo simátímakowi siyáan-amaane meꞌwi-meꞌwiyáámbá éna kaeꞌ-ámáánkó áfonkaamba uráinkaꞌa tawéaraapaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Súwasa ámáán-kawaa-waasi túwaandu uwaná Ísu miwí tísai ena séna ");
INSERT INTO auy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Maníkómó íyáfasinankaraiwai Káráísiti nááwan-andafaken-kwaasiyaꞌiyo súwasa kentáásíwáꞌná Téfítin-andafaken-kwaasin-iye suwaná ");
INSERT INTO auy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ísu séna naaófáꞌá Maníkóní ámútanko Téfítimba imáyáa amúwana Téfíti Káráísitintafena séna kesí Fasiꞌaénkón-iye siyáimba ");
INSERT INTO auy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Imó agaimakón-aufaifimba Téfíti agaimaréna séna kesí Fasiꞌaénkóntáféna Maníkó séna kesiyáánúrapaꞌa fasiꞌaén-áémpáꞌá maraꞌ-ménaꞌa ení namuro-wáásí íyáákaanasa miwí taiꞌánááwe Maníkómó siyáin-aai Téfíti siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Miyáumai Téfíti Káráísitintafena séna kesí Fasiꞌaénkón-iye siyáimbanifo nóraumaiya wemá Téfítin-andafaken-kwaasin-iyo Ísu súmba ");
INSERT INTO auy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Káráísiti Téfítini Fasiꞌaénkó éna Téfítin-andafaken-kwaasigon-iye súmbanifo miwí ímba kanaaꞌá aaí sésa táátafesa ésa minkákémbá ímba áísai úmaesa iyáawe. ");
INSERT INTO auy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ísu túwaandu urón-kwaasiye wení kísau-waasiye simátimena séna ");
INSERT INTO auy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Maníkó íyáfasintinkaraisasa ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye Mósese agaimakáin-aai toráumaimo wésimatimemba ");
INSERT INTO auy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","iséꞌa arááíwáéro. Mósese siyáin-amaamba miwí tóikaken-aantemba sésa ímba wéaraaiwaefo miwímó ontembá ímba oró. ");
INSERT INTO auy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Umbai-tántááꞌó asááúmakesamo túwaataꞌmaeꞌa korómó sésamo ímbo túwaꞌnai ontembá miwí umbai-ááí simátimesa ímba túwaꞌnai ombá úwoi arááíwáéro wésewe. ");
INSERT INTO auy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Miwí sésa waási suwánésa óraaꞌ-waasin-owe síwae sésa Mósese siyáin-amaamba agaimái anaféúmpímbá makésa túwayaankaꞌe tiyáánkaꞌe káráꞌumaresa miwítí wátói-araiyaꞌa ayáátáákaꞌa tafétafe úmakesa naaópaꞌa afufumpaꞌá wénesa ");
INSERT INTO auy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","tanómbo kaúfópaꞌo ombá kaweꞌ-áémpáꞌá mésa ámáán-daumpaꞌo ombá óraaꞌ-waasimo máépaꞌa imésa ");
INSERT INTO auy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","waási suwánésa sésa óraaꞌ-waasi ámáán-aai simátíméwin-owe síwae sésa naaópaꞌa maruꞌ-afufumpaꞌá wénesa miyámó ontáfésa aamoí wéowe. ");
INSERT INTO auy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Miwí miyá wéombanifo ímba miyán-oro. Kembiwísáfésa óraaꞌ-waasi ámáán-aai simátíméwi owémó síyambo éꞌa kímborawigo óraaꞌ-waasi isatá wení waásisa mimbóráíꞌa úmaisa méraumne seró. ");
INSERT INTO auy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kempínkémbá moóráwigontafeꞌa óraaꞌ-waasi kesifón-iye sefó. Kentifo wíyómpaꞌa méraiye. ");
INSERT INTO auy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kempínkémbá moóráwigontafeꞌa kentááráꞌá káráwiyaiwain-iye sefó. Maníkómó íyáfasisinkaraiwai keyáá kenkáꞌá káráwiyaundawi kemá úne. ");
INSERT INTO auy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kempínkémbá íyáákanae síyawi kentí wayóꞌá máéro. ");
INSERT INTO auy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kentúwíꞌo mósá maráíyawi Maníkó úwoi kentúwíꞌa múratinkainifo kentúwíꞌo ímbo mósá maráíyawi Maníkó mósá tinkáíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ísu minááí simátimena séna ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye simátíménda ísáaro. Kaumbo-kaeꞌ-ááíwáráꞌ-wáásímó éꞌa káráwiyoro. Maníkó wení waásimo kawáánin-amba wéfaitinkaawe. Maníkó wení waásimo kawáánin-ampaꞌa ímba kónae sembá kónaesamo owítí aambá wéfaitinkaawe. ");
INSERT INTO auy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásí éꞌa ketoꞌ-íníntí óntawara naankwaráꞌá umémbá wémaeꞌa waási suwánésa súwíꞌa mósá maráíwae séꞌa tafisímai-inai karoꞌá wésewe. Mindásafeꞌa káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásí éꞌa simátimunda ámáán-aai arááíwaiwae séꞌa saafá úmaeꞌa óraaꞌ-nomba kofatéꞌa némpaꞌa wéneꞌa tuwánéꞌa kentí sáwí-kisau aráátíméwasa miwítí sáwí-kisaugo kentí sáwí-kisaugomba íyáákaraimba póꞌa mindásafeꞌa káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aambó ímbo kaweꞌ-úmaimo awánaraawi karoꞌá séꞌa maarán-ámbá arááíwáéromo sewí káráwiyoro. Kembiwímó ámáán-aaimo sembá karoꞌá simátimeꞌa séꞌa óraaꞌ-amaan-dankon-aai tikaꞌ-marésa sésa miyá ónaumnemo sembá minímáyáámó ifátuwaiyanamo éna kanaaꞌá íníye. Énifo kaweꞌ-óntánkón-áwíꞌa korí-óntánkón-aai tikaꞌ-marésa sésa miyá ónaumnemo sembá minímáyáámó ifátuwaiyanamo éna sáwíꞌa íníye wésewe. ");
INSERT INTO auy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Minkórí-óntánkó óraaꞌ-amaan-dankomba ímba íyáákaraifo mindáúmpáꞌó wérainda mindá kaweꞌán-iye. Kembiwí ámáán-aaisafena tááko ímba péé sisaꞌá wéisaawe. Sáwí-imayaawaraꞌ-waasi simátímén-aai karoꞌ-ááín-iye. ");
INSERT INTO auy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kembiwímó ámáán-aaimo sembá karoꞌá simátimeꞌa séꞌa Maníkóntáfésamo póímo tufúꞌmaimo agáén-taaregon-aai tikaꞌ-marésa sésa miyá ónaumnemo sembá minímáyáámó ifátuwaiyanamo éna kanaaꞌá íníye. Énifo mintááréráꞌó Maníkómbó wéamem-poigon-aai tikaꞌ-marésa sésa miyá ónaumnemo sembá minímáyáámó ifátuwaiyanamo éna sáwíꞌa íníye wésewe. ");
INSERT INTO auy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Maníkómbó ámém-poigo mintáárégómbá ímba wéiyaakaifo mintáárégó íyáákarena ámém-poi kaweꞌá wéiye. Kembiwí ámáán-aaisafena tááko ímba péé sisaꞌá wéisaawe. Sáwí-imayaawaraꞌ-waasi simátíménaai karoꞌ-ááín-iye. ");
INSERT INTO auy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Fasiꞌaén-ááímó sembá Maníkóntáfésamo póímo tufúꞌmaimo agáén-taaregon-aaimo tikaꞌó marésamo sésamo ésa mintáárégón-aaiwaraꞌa Maníkómbó wéamem-poigon-aaiwaraꞌa wésewe. ");
INSERT INTO auy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Fasiꞌaén-ááímó sembá óraaꞌ-amaan-dankon-aaimo tikaꞌ-marésamo sésamo ésa mindánkón-ááiwara Maníkó mindáúmpáꞌá méraiwain-aaiwaraꞌa wésewe. ");
INSERT INTO auy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wíyómpaꞌe simásuwesamo tikaꞌó marésamo sésamo ésa Maníkó mifáꞌá káráwiyaiwain-aaiwaraꞌa wésewe. ");
INSERT INTO auy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásímó éꞌa káráwiyoro. Naaófáꞌó Mósesemo siyáintemba kentí kísaufakemba kári-tonkwaraꞌa tuwínkaaꞌ-úmai siyáánkai makéꞌa moórá Maníkómbá améꞌa kaweꞌá wéeꞌa miyán-ámáámbá ísámae wéiyofo Mósesemo siyáin-amaamba óraaꞌ-amaamba ifáꞌá tuwéꞌa póꞌa waási ímba arupíse uwátinkeꞌa tirumbá ímba uwátinkeꞌa ímba Maníkóntáféꞌa timankúnkúmba éꞌa miyámó ontáféꞌa póꞌa minórááꞌ-ámáántómbá ifáꞌá tukáawe. ");
INSERT INTO auy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aambá ímba kaweꞌ-úmai awánaraawi karoꞌá séꞌa maarán-ámbá arááíwáéro wésemba káriꞌ-amaamba arááíwaeꞌa óraaꞌ-amaamba tukáawe. Miyámó ombá tóipinkaambo wénaawiyaan-kwaasin-owe. ");
INSERT INTO auy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásímó éꞌa káráwiyoro. Anaféúné táúfaꞌe paákáꞌ-aantembo wénonkwiyofo andáámpáꞌá sáwíꞌa uráisaꞌa póꞌa kempímbá sáwífa-tantaaꞌa óraaꞌa wéraiye. ");
INSERT INTO auy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ámáán-kawaa-waasisono. Ámáán-aaisafena tááko ímba péé sisaꞌá wéisaawe. Anaféúné táúfaꞌe andáámpáꞌó non-kwíyówanamo andáámpáꞌé paákáꞌé kaweꞌó intembá kentí sáwí-imayaa tuwéꞌa kaweꞌ-ímáyáá úmai méraaro. ");
INSERT INTO auy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásímó éꞌa káráwiyoro. Waásimo maipímbó utámakaawanamo kawááꞌisasamo waási ímbo awánaantemba kentirumpimbá miyá isaꞌá sáwíꞌa wéowasa waási ímba wétuwanaawe. Waásimo maipímbó utámakesamo kawe-tóꞌwááímó owasamó awánésamo sésa kaweꞌá wéowemo sentembá kembiwí tuwánésa kaweꞌ-wáásín-owe sembánifo kentirumpimbá miyá-sáwí-tántááꞌá wéraisaꞌa kaumbo-kaeꞌ-ááíwáráꞌ-wáásín-owe. ");
INSERT INTO auy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ámáámbo sen-kwáásíyé ámáán-kawaa-waasiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásímó éꞌa káráwiyoro. Kentíwáꞌná Maníkón-aaimo simátímakowi tínkamuwasa púwúwaꞌa utámakaapaꞌa toꞌwaaí wéowe. Arupíse úmai méron-kwaasi tínkamuwasa púwúwaꞌa utámakaapaꞌa toꞌwaaí wéeꞌa ");
INSERT INTO auy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","séꞌa miwí tísaafitantambo uráawi séꞌa minkánáámó mérekaa kentáá síwáꞌnámo uráantemba ímba miyásá uráusino wésewe. ");
INSERT INTO auy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Miyámó sembá maarán-ááí wéseꞌa Maníkón-aai simátímakowi tínkamesa miyá-sáwíꞌá uráawi tírááta úne wéseꞌa miwímó uráantemba miyá wéowe. ");
INSERT INTO auy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kentíwáꞌnámo uráantembo miyámó wéeꞌa taiꞌánááwe. ");
INSERT INTO auy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Taiꞌáíyamba iyánkó póígon-araaꞌan-owe. Maníkó kembá aaifimbá matinkáínaꞌa sáwí-meyambo maíyapaꞌa ónkaifaꞌa komésa wété íyan-amba ímba wéraiye. ");
INSERT INTO auy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Miyáumai kesáái simátimiyawiye aráátimiyawiye kaweꞌ-ímáyááwáráꞌ-wáásíyé tiꞌmáráanasa kempímbá wéniyaꞌa tuwímbai tínkamiyasa puwíyaꞌa tuwímbai aaraa-táíyáꞌá tínkamiyasa puwíyaꞌa tuwímbai kentí ámáán-daumpimpaꞌa taántámbá tínkameꞌa moórá-mora-naopimpaꞌo wéniyaꞌo éꞌa tiꞌmátuꞌmaeꞌa nónááwe. ");
INSERT INTO auy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Miyámó íyana arupíse-waasimo tínkamom-beyamba seyaafáꞌ-wáásítí méyámbá kentópaꞌa tíníye. Aifaꞌó tufúwanamo pukáin-kwaasigon-awiꞌa Éperi ánaaemba moóráwigo Pérékáíyaan-ááninkon-awiꞌa Sékáráíya óraaꞌ-amaan-daumpaꞌa mérowana moórá-aempaꞌa Maníkóntáfésamo ísámaimo póímo tufúꞌmaimo agáún-ontan-taaremo wérowana moórá-aempaꞌa aifaꞌ-ámáán-káwáágó aantemba iyún-ontama wérowana afufumpimbá Sékáráíya imérowasa tufúwana pukáiye. ");
INSERT INTO auy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Minkáéꞌ-wáásítí afufumpimbó kárúraan-kwaasi tínkamuwasa pukáawiwaraꞌa miwítí sáwí-meyamba káféꞌo méraan-kwaasi maénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ísu minááí simátimena Yérúsaremu-naopaken-kwaasi arumbá uwátinkena séna Yérúsaremu-naopaken-kwaasisono. Maníkón-aaimo simátímakaawi tínkambae núwasa pukáawe. Maníkó tiꞌmarówasa kuwáí óntantamba tínkambae núwasa pukáawe. Kokórigo áráátombo ayóífáꞌó tínkarenamo káátatinkaintemba aasiyaasi-kánáá kemá miyá ónaumne súndanifo tínaaemba wéuwasimewe. ");
INSERT INTO auy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ísáaro. Maníkó tiyuwáínaꞌa tuꞌnankáámbá ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Simátimeꞌa súne. Ímba úwoi suwánánááfo ánaaembo séꞌo Maníkó aiꞌmáráísana kunkáiwaimba Maníkó kaweꞌá uwánkáíye síyankaꞌa anekaꞌá suwánánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ísu minááí simátimuwasa óraaꞌ-amaan-daumpakemba kárúwesa kúmúmba wení kísau-waasi sésa óraaꞌ-amaan-damba kaweꞌ-námbán-ifo awánaao suwaná ");
INSERT INTO auy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ísu séna káféꞌo awánaan-dantafeꞌa simátimeꞌa súne. Ánaaemba waási tésa mindámbá seyaafá tawísísuwesa seyaafáꞌ-óntánkwáráꞌé tawísísuwanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ísu minááí simátimena Órífi-omapaꞌa imérowasa wení kísau-waasi weyáá méropaꞌa tésa áísai esa sésa emó sénda nóin-kanaawa paápé íníyo. Nóin-kwaamera ínataawa séta ampáánkáꞌá emá kúmínana káféꞌo wérain-tantaaꞌa taiꞌáíníyesa sénaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ísu séna karoꞌ-ááí iséꞌa éraiꞌe sefó káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sáwífaꞌ-waasi tésa kesúwíꞌa máwatesa sésa Maníkómó íyáfasisinkaraiwai úne síyasa sáwífaꞌnanka minkáróꞌ-ááísáfésa éraiꞌe sénááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tíyááwemo síyan-aai némpakenaꞌi ewaakénáꞌi isáíyana ímba tááꞌa íno. Miyán-kánáámó tínda mindá ímba seyaafá-tántááꞌó taiꞌáínda-waameꞌan-iye. ");
INSERT INTO auy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Fíꞌo-fiꞌon-aempaꞌ-waasi tiyánááwe. Moórá-kawaa-waasigomo éna moórá-kawaa-waasigoni amááraasafena íyáfasine tíyáaromo sínasa íyáfasinesa tiyánááwe. Fíꞌo-fiꞌom-barafaꞌa aawaí táíníye. Fíꞌo-fiꞌom-barafaꞌa óraaꞌ-mari táíníye. ");
INSERT INTO auy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Miyán-tántááꞌó paápé ínaꞌa séꞌa seyaafá-tántááꞌó taiꞌáínda-kanaa ímba tiyáifo iyámpóímo matinkánae owanamó óraa-tiꞌo intembá umbai-kánáámó tínda minkánáá paápé iye seró. ");
INSERT INTO auy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Miyán-ááímó síyasa minkákémbá kembiwí taꞌótoꞌmai fíꞌowi timíyasa sáwíꞌa uwátinkesa tínkamiyaꞌa puwónááwe. Kentáfésamo fasiꞌámaimo méraiyantafesa fíꞌo-fiꞌon-kwaasi seyaafáꞌnánká tíyámba uwátinkanaawe. ");
INSERT INTO auy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kesááisafesa éraiꞌemo wésiyawifinkemba sáwífaꞌnanka kesáái tínaaemba uwámesa miwítí namuro-wáásí moórá-morawigo aráátimesa tíyámba uwátinkanaawe. ");
INSERT INTO auy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sáwífaꞌnanka paápé ésa karoꞌá sésa Maníkón-aai simátimundawi úne sésa sáwífaꞌnanka karoꞌá simátimenaawe. ");
INSERT INTO auy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Miyáumai sáwí-kisaugo wété éna óraaꞌa ínasa fíꞌowi-imayaamo émémba ifátuwesa kentáfé-ímáyáá aantemba ónááfo ");
INSERT INTO auy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ímbo ifátuwesamo kentáfésamo fasiꞌámaimo méraiyawi taiꞌáínda-kanaaraꞌa Maníkó tíꞌmai kawepáꞌá métinkainiye. ");
INSERT INTO auy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Seyaafáꞌ-máráfákén-kwáásí isáíyantafeꞌa ásé-aai Maníkó wení waásimo kawáánin-aai simátímaꞌmae iyíyana ánaaemba seyaafá-tántááꞌá taiꞌáínda-kanaa tíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ísu minááí simátimena séna ánaaemba sáwíꞌa íyan-tantaako paápé íníye. Naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Tánieri mintántáátáféna siyáiye Ísu siyáiye. Kemá Mátíyu súne. Maanáúfáímó torausíyawi tááko péé sínaꞌa ísáaro wésune. Ísu séna Maníkóní kaweꞌ-náópaꞌa misáwí-tántááꞌá paápé ínasa awánáíyamba ");
INSERT INTO auy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yúndiyaa-marafaꞌo méraiyan-kwaasi omápata tuwaantantésa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ontaráꞌó méraiyan-kwaasi ímba naaúmpaꞌo iyíyamba óntama ifátuwesa úwoi tuwaantantésa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kísaufaꞌo méraiyan-kwaasi ímba naaópaꞌo tíyamba unáánkwátói ifátuwesa úwoi tuwaantantésa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tímúkaꞌnine káféꞌ-iyampoiwaraꞌ-inine minkánáá sáwíꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tuwaantambó iyíyamba táwiꞌo índa-kanaa iyéꞌa saagaan-kánáá iyéꞌa únafo séꞌa Maníkómpáꞌá inaí seró. ");
INSERT INTO auy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Minkánáámó tínda óraaꞌ-umbai táíníye. Naaófáꞌá Maníkó maramó úmaronkaꞌe káféꞌwaraꞌe miyán-úmbáí-tántááꞌá ímba tiyáiye. Ánaaenkwaraꞌa miyán-úmbáí-tántááꞌá ímba tíníye. ");
INSERT INTO auy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Miyán-úmbáí-tántááꞌó wéin-kanaa Maníkó ampáásé úmakaiye. Miyán-úmbáí-kánáámó ayáátáákaꞌo wérainkakaa seyaafáꞌ-wáásí ímba úwoi túnamai méraawisino. Maníkó wemparíꞌo úmakain-kwaasisafena imáyáa éna miyán-úmbáí-tántááꞌá ampáásé uráiye. ");
INSERT INTO auy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ampáásémó ínasa tuwímbai simátimesa sésa Maníkómó íyáfasinankaraiwai mifáꞌ-maafaꞌa méraiye síyaꞌo éꞌa ímba ísáaro. ");
INSERT INTO auy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tuwímbai paápé ésa karoꞌá sésa Maníkómó íyáfasisinkaraiwai úne síyasa tuwímbai karoꞌá sésa Maníkón-aaimo simátimundawi úne simátímaꞌmaesa níyamba ímbo awánen-kisau maésa Maníkómó wemparíꞌo úmakain-kwaasi karoꞌá simátinkanae sésa miyán-óráá-kísáú maénááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Miwísáféꞌa éraiꞌ-waasin-owe sefó séꞌa ímba paápé uráankaꞌa aifaꞌá simátimumpo káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Súnda-aai imáyáa éꞌa ánaaembo moóráwigomo kentáfénamo sénamo paápé uréna máásai-marafaꞌa méraiyemo sínaꞌo éꞌa ímba koró. Moóráwigomo kentáfénamo aúpáꞌá méraiyemo sínaꞌo éꞌa ímba éraiꞌe seró. ");
INSERT INTO auy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wíyómpaꞌo aafáyáumo tóráísasamo awánaantemba kemá waási úranko miyáumai aforaꞌá anekaꞌá kumónaumne. ");
INSERT INTO auy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Póímo sawaímó kawááꞌipaꞌo náíndasafenamo embontaan-dúmágómó tatorúpaintemba Maníkó sínana súnda-aai paápé íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ísu minááí simátimena séna miyán-úmbáí-tántááꞌó tínda-kanaa taiꞌáínana aafáúgó kumeuꞌá ínana wíyónko ímba sán-káínana oꞌá wíyómpakemba kaisínana wíyónko úwaauwa ínasa ");
INSERT INTO auy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","seyaafáꞌ-máráfákén-kwáásí wíyómpaꞌa awánemba fíꞌonkaꞌmaꞌmai-tantaaꞌa awánésa kentáfésa sésa kumínena toꞌmayaa wéiye sésa táátafesa wéesa ifiꞌá wétesa suwánemba kemá waási úranko óraa-fasiꞌaenkwara sáwaraꞌa ainánká kúmónaꞌa suwánánááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Uwíyemba wétufuweꞌa wíyómpaken-kisau-waasi tiꞌmáráanasa Maníkómó wemparíꞌo úmakain-kwaasi seyaafáꞌ-máráfákémbá tíꞌmaesa moóráfimba túwaandu ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ísu minááí simátimena séna moórá naan-táígón-áwíꞌa fíki-taigontafeꞌa imáyáa úmai ísáaro. Asáómó agaínda awáné séꞌa áúꞌo sínda-kanaa kárikaꞌa tíníye sénááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Miyámó intembá kemó súnda-tantaaꞌa ínaꞌa awáné séꞌa kárikaꞌa kumíníye sénááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Éraiꞌa simátime súne. Káféꞌo méraan-kwaasi tuwímbai ímbo pukáiyankaꞌa kemó súnda-tantaaꞌa paápé íníye. ");
INSERT INTO auy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wíyóne marawé taiꞌáínífo kesáái ímbo taiꞌáínda úwoi waéꞌwaeꞌa íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ísu minááí simátimena séna kúmónda-kanaa aafáúmá waási ímba ísááwasa wíyómpaken-kisau-waasiwaraꞌa ímba ísááwaꞌa kemá Maníkón-ááninko ímba wéisaumpo kesifo weyáá ísaraiye. ");
INSERT INTO auy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Naaófáꞌá moóráwigon-awiꞌa Nówaamo méronkaꞌa waási ímbo Maníkón-ímáyáá ésamo maéꞌóntemba ánaaemba kemá waási úranko kúmónda miyá ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Piriꞌ-nónkómó ímbo tínkankonkaꞌa noné tóné wénesa tiyáámúmba wétoꞌwaai-esa aaré máúwasa waaí máúwasa wéuwana Nówaa nompín-táómpimba imérowasa ");
INSERT INTO auy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","piriꞌ-nónkó táínda-aai ísaresa ímba imáyáa ésa mérowana óraaꞌ-aꞌa téna piriꞌ-nónkó seyaafáꞌ-wáásí tínkamuwasa putásaraawe. Miyámó uráantemba kemá waási úranko anekaꞌó kúmóndaraꞌa kentáfésamo ímbo imáyáamo íyawi miyá ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Minkánáá maará ónááwe. Kaeꞌ-wáásí kísaufaꞌa méreyana Maníkó moóráwigomba auwéna moóráwigomba aiyáíníye. ");
INSERT INTO auy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Minkánáá kaeꞌ-ínínkáí tómbá wétoꞌmayaan-íyana Maníkó moórá-inimba auwéna moórá-inimba aiyáíníye. ");
INSERT INTO auy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kemá kentí Fasiꞌaénkómó kúmónda-kanaa ímba ísaraafo káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Simátíménda-aai imáyáan-oro. Naankón-afowámó umén-kwáásímó tínda-kanaamo ísarenaraa umén-kwáásímó timbá wétoꞌmayaan-ena awánéna watúwáísana wení naaúmpakemba umémbá ímba máísino. ");
INSERT INTO auy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Miyáumai kemá waási úranko kafífímbá kumónaumpo kembiwí wétoꞌmayaan-eꞌa simuꞌmáráaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ísu minááí simátimena séna kawe-kísáúmó máéwi kaweꞌ-ímáyááwáráꞌ-wáásísáféꞌa súne. Wení óraako séna kesí kísau-waasiyaꞌa káráwiye tómbá tuwímbai tímaꞌmae iyuwó síníye. ");
INSERT INTO auy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wení óraako téna wení kísaumo kaweꞌ-úmaimo maínda taawánáínana kísaumo maíndawi arunkó kaweꞌá ínana ");
INSERT INTO auy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","minóráákó séna kesí seyaafáꞌ-mópáráwínkáꞌá káráwiyuwo síníye. ");
INSERT INTO auy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Énifo minkísáú-wáásígómó imáyáamo énamo kesí óraako ayáátáákaꞌa ímba tíníye sénamo ");
INSERT INTO auy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kísau-waasi tínkamenamo tómbó nénamo uwóíꞌ-nombo wénaan-kwaasiye uwóíꞌo énamo ");
INSERT INTO auy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","wení óraakomo tínda-kanaa ímbo ísarainanamo kafífímbó téna ");
INSERT INTO auy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","óraakaꞌa tatufúꞌmai aiꞌmátuwena séna kaumbo-kaeꞌ-ááíwáráꞌ-wáásímó mésamo tíꞌo wéisasamo ifiꞌó wétesamo túwááyaambo umpufuwésamo méraapaꞌa kóuwo síníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ísu minááí simátimena aaremó máéwini áwáuma imáyáa éna séna ánaaen-kanaamo tínda Maníkó wení waásimo kawáánin-aai maarán-iye. Aaremó maíndawi tómbá náíyanesa siyáánkai-inaamaru ómbá kúraꞌmaesa aampakémbá koáíkaawe. ");
INSERT INTO auy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Minárásísómbá séfataase sáwí-imayaawaraꞌa owasá séfataase kaweꞌ-ímáyááwáráꞌá owasá ");
INSERT INTO auy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","sáwí-imayaawaraꞌ-arasi ómbá kurarésa fíꞌon-anafeumpimba iyamó káínda-nomba ímba fatíyowasa ");
INSERT INTO auy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kaweꞌ-ímáyááwáráꞌ-árásí ómbá kurarésa fíꞌon-anafeumpinkwaraꞌa iyamó káínda-nomba fatiyésa ");
INSERT INTO auy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","aaremó maíndawimba koamuꞌmakáawana ímba ááéma tisasá túgáfaaꞌa isasá tún-kwaiguráawe. ");
INSERT INTO auy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tún-kwéraawana nóꞌwaan-afufuntamba moóráwigo táántena séna wétifo koaiyánáísaiye sisasá ");
INSERT INTO auy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","misíyáánkáí-árásí íyáfasinesa ómbá toꞌmaésa kombá ");
INSERT INTO auy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","sáwí-imayaawaraꞌ-arasi kaweꞌ-ímáyááwáráꞌ-árásísáfésa sésa kentáásí iyamá pisináínífo nombá fatísimero sewasá ");
INSERT INTO auy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","miwí sésa kesááwáráꞌá miyáumai wétaiꞌaifo nombó fatíyón-daumpakemba koméyámbáráaro sewasá ");
INSERT INTO auy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","wégowana aaremó maíndawi tisasá séfataase-arasi toꞌmayaa úmaimo méraawi weséꞌo tómbó náíyanesa naaúmpaꞌa íyówana ");
INSERT INTO auy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ontá wisúwáísasa miséfátáásé-árásí nombó fatiyónaesamo kówai tésa óraakaꞌa sésa óraakoo ontá tisinkaaó sewaná ");
INSERT INTO auy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ímba awánáúnda-arasi ombá póꞌa ímba ontá titinkánaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ísu simátimena séna miyáumai kemó kúmónda-kanaa ímba ísarenkaꞌa kumónaumpo káráwiyeꞌa méraaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ísu minááí simátimena séna ánaaen-kanaamo tínda Maníkó wení waásimo kawáánin-aai maarán-iye. Moórá-oraako némpaꞌa wááu koménae séna wení kísau-waasi táántena séna kesí óntankaꞌa káráwiyoro séna ");
INSERT INTO auy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","moóráwigo wení kísau kawe-kísáúmó máísanamo awánaiwaintafena séna kesí óntamba séfataase-unamba káráwiyuwo séna aména moóráwigo wení kísaumo kárikaꞌo kawe-kísáúmó máíwaintafena séna kesí óntamba kaeꞌ-únámbá káráwiyuwo séna aména moóráwigo wení kísaumo kári-kisaumo máíwaintafena séna kesí óntamba moórá-unamba káráwiyuwo séna aména tiyuwéna némpaꞌ-marafaꞌa kóísana ");
INSERT INTO auy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","séfataase-unan-ontambo maiyáiwai minóntántámbá kísau maimaéna wéwena fíꞌomba séfataase-unan-ontamba máísana ");
INSERT INTO auy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","moóráwigo kaeꞌ-únán-óntámbó maiyáiwai minóntántámbá kísau wémaena fíꞌomba kaeꞌ-únámbá máísana ");
INSERT INTO auy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","moóráwigo moórá-unan-ontambo maiyáiwai minóntántámbá ímba kísau maéna úwoi marafímbá utámakaiye. ");
INSERT INTO auy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Utámakaisasa miyá wéowana miwítí óraako ayáátáákaꞌa kuróm-bapaꞌa mifáꞌá ména ánaaemba téna wááumo tímakaunda-ontamba torupámai awánánae séna táántaisasa ");
INSERT INTO auy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tésa séfataase-unan-ontambo maiyáiwai maimaéna máaraanamena séna séfataase-unan-ontambo símakaandarakemba kísau wémaeꞌa fíꞌomba séfataase-unan-ontamba maiyáumne sisaná ");
INSERT INTO auy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","óraako séna kesí kísau-waasigo kaweꞌá óne. Kentáfémo imáyáamo émo kári-tantaakaꞌo kaweꞌó úmaimo káráwiyaandantemba sáwífa-tantaakaꞌa káráwiyinone. Kesirunkómó aamoimó intembá keséꞌa taménana enarunkó aamoí íno sisaná ");
INSERT INTO auy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","kaeꞌ-únán-óntámbó maiyáiwai maimaéna máaraanamena séna kaeꞌ-únán-óntámbó símakaandarakemba kísau wémaeꞌa fíꞌomba kaeꞌ-únán-óntámbá maiyáumne sisaná ");
INSERT INTO auy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","óraako séna kesí kísau-waasigo kaweꞌá óne. Kentáfémo imáyáamo émo kári-tantaakaꞌo kaweꞌó úmaimo káráwiyaandantemba sáwífa-tantaakaꞌa káráwiyinone. Kesirunkómó aamoimó intembá keséꞌa taménana enarunkó aamoí íno sisaná ");
INSERT INTO auy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","moórá-unan-ontambo maiyáiwai maimaéna máaraanamena séna emá fasiꞌaén-kwáásí éma fíꞌowiti kísaurakemba tómbá wéne fíꞌowiti kísaurakemba úwoi wéne wémandaanaꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","enáároi inkaiséꞌa ení óntantamba kísau ímba maúnda úwoi aúpáꞌá makáumpo ení óntamba máínone sisaná ");
INSERT INTO auy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","óraako séna sáwí-kisau-waasigo kafóná-waasi po kentáfémo sémo fíꞌowiti kísaurakemba tómbá wéne fíꞌowiti kísaurakemba úwoi wéne wémandaanaꞌa óne sénda po ");
INSERT INTO auy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kesí óntambo seyaafáꞌ-wáásítí óntambo máráán-daumpaꞌo makáandarakaa téꞌa kesí óntankwara aꞌwáá-ontankwaraꞌa máúsino séna ");
INSERT INTO auy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","wení kísau-waasisafena séna minóntámbá maiyéꞌa siyáánkai-unan-ontambo tokáiwaimba áméro. ");
INSERT INTO auy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sáwífa-tantaakaꞌo kaweꞌ-úmaimo káráwisinkaiwaimba moórá-mora-tantaaꞌa áménana káráwisinkainifo ímbo kaweꞌ-úmaimo káráwisinkaindawimpakemba makáimba méraanaꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","misáwí-kísáú-wáásígómbá áíꞌmaeꞌa máápaꞌa múra auwáíyana kumeuꞌ-áémpáꞌá tíꞌo wéisasamo ifiꞌó wétesamo túwááyaambo umpufuwésamo méraapaꞌa wíníye siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ísu minááí simátimena séna kemá waási úranko ánaaembo kúmóndaraꞌa ságaenkwara wíyómpaken-kisau-waasiwaraꞌa káráwiyaundawi póꞌa kúmónasa ");
INSERT INTO auy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","seyaafáꞌ-máráfákén-kwáásí kesúrankaꞌa túwaandu íyaꞌa sipisípi-poiye méme-poiyaꞌemo káráwiyaiwaimo tuwímbaraintemba minkwáásísómbá miyáumai tuwímbakeꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","tuwímbai siyáánúrapaꞌa mótinkeꞌa tuwímbai siyáánaepaꞌa métinkeꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","káráwiyaundawi siyáánúrapaꞌo méraiyan-kwaasisafeꞌa séꞌa kesifo kaweꞌó uwátínkáíwain-owe. Maníkó maramó úmakonkaꞌa ken-ímáyáá éna kentí maruꞌá toꞌmayaa úmakaifo mifáꞌá taméraaro. ");
INSERT INTO auy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kaweꞌá uwásinkeꞌa kembó sááimo tówaꞌo méraawanda tómbá siméꞌa nombá siméꞌa fíꞌom-bapaken-kwaasimo ówánda aamoí uwásinkeꞌa kentí naaúmpaꞌa mósá wésinkeꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","unáánkwátói-iyaimbo ówánda wésimeꞌa síꞌo úmba wégarawiyeꞌa ándáfaꞌo maéwánda wésuwaꞌnai-eꞌa miyá uwásínkaraawe. Miyán-ááí senasá ");
INSERT INTO auy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","arupíse úmaimo méraawi sísai esa sésa Fasiꞌaénkóo nóꞌwaiya embó ááimo tówamo méronda tóné noné amétaawa ");
INSERT INTO auy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","nóin-kanaawa fíꞌom-bapaken-kwaasiyaambo undá aamoí uwánketa kentáásí naaúmpaꞌa mósá ankétaawa nóꞌwaiya unáánkwátói-iyaimbo undá amétaawa ");
INSERT INTO auy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","nóꞌwaiya áíꞌo úmba áwaꞌnai étaawa nóꞌwaiya ándáfaꞌo maúnda áwaꞌnai uráumno síyaꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","káráwiyaundawi séꞌa éraiꞌa simátime súne. Kesí waásimo úwoi-waasimo miyáumaimo túwaꞌnai uráamba mindá kembán-iye simátimenaumne. ");
INSERT INTO auy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Miyá simátimeꞌa siyáánaepaꞌo méraiyan-kwaasisafeꞌa séꞌa Maníkó sáwíꞌa uwátinkaindawin-ofo siyuwéꞌa kóro. Maníkó waántáwankone wení kísau-waasiye imáyáa éna óraaꞌ-iyama toꞌmayaa uwátínkaraisana kámakamaꞌa wéena ímba pisínáípaꞌa mifáꞌá koméraaro. ");
INSERT INTO auy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kembó sááimo tówaꞌo méraawanda tóné noné ímba siméꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","fíꞌom-bapaken-kwaasimo ówánda ímba aamoí uwásinkeꞌa kentí naaúmpaꞌa ímba mósá sinkéꞌa unáánkwátói-iyaimbo ówánda ímba siméꞌa síꞌo úmba ímba súwaꞌnai eꞌa ándáfaꞌo maéwánda ímba súwaꞌnai eꞌa miyá uwásínkaraawe. Miyán-ááí senasá ");
INSERT INTO auy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","sísai esa sésa Fasiꞌaénkóo nóꞌwaiya embó ááimo tówamo méronda tóné noné ímba amétaawa nóꞌwaiya fíꞌom-bapaken-kwaasiyaambo undá ímba aamoí uwánketa kentáásí naaúmpaꞌa ímba mósá ankétaawa nóꞌwaiya unáánkwátói-iyaimbo undá ímba amétaawa nóꞌwaiya áíꞌo úmba ímba áwaꞌnai étaawa nóꞌwaiya ándáfaꞌo maúnda ímba áwaꞌnai uráumno síyaꞌa ");
INSERT INTO auy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","kemá séꞌa éraiꞌa simátime súne. Kesí waásimo úwoi-waasimo ímbo túwaꞌnai uráamba mindá kembán-iye simátimenaumne. ");
INSERT INTO auy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Miyán-ááí simátimeꞌa aaí senasá miwítí sáwí-meyambo ímbo taiꞌáínanamo waéꞌwaeꞌo índa-aempaꞌa komaéꞌmaeꞌa ónááfo arupíse úmaimo méraawi aúíꞌa úmai maéꞌmaeꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Ísu mifíꞌó-fíꞌón-ááí wení kísau-waasisafena simátímakaiye. Naaófáꞌó Maníkó Yúndaa-waasi tíyótaimo í-tánón-kánáá imáyáa éna séna kaeꞌ-nóꞌwáámbá waésa tíyótaimo í-tánón-kánáá tínda kembá taꞌótoꞌmai aaraa-táíyáꞌá sínkamiyaꞌa puwónaumne Ísu wení kísau-waasisafena simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Simátimuwasa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye aifaꞌ-ámáán-káwáágón-áwíꞌa Káyafaasini naaúmpaꞌa túwaandu urésa ");
INSERT INTO auy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","sésa nóraumaisaawa aúpáꞌá Ísumba taꞌótoꞌmaisaawa tufuwónaumno. ");
INSERT INTO auy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Seyaafáꞌ-wáásí tíyááfainifo tanómbo kaufíyan-kanaaraꞌa ínta tufuwónaumne siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Suwaná Ísu Pétáni-naopaꞌa koména moóráwigon-awiꞌa Sáímonini naaúmpaꞌa áúmo námombo kón-kwaasigoni naaúmpaꞌa ména tómbá wénowana ");
INSERT INTO auy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","moórá-ininko iyéna asaa-wiyúmbó úm-basawemba óraaꞌ-ontankakemba méyámbakaim-basawemba maimaéna iyúmba Ísu aꞌnómpímbá fatímarowasa ");
INSERT INTO auy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","wení kísau-waasi awánésa aaisambá sésa nóra sénawa mimbásáwémbá úwoi fatíyankaiyo. ");
INSERT INTO auy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mimbásáwémbó fíꞌowi timénamo óraaꞌ-ontambo maiyénamo ímbo óntamo makáan-kwaasi tíméraambaniye suwaná ");
INSERT INTO auy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ísu iséna séna ifátuweꞌa ímba aaisambá aééro. Kaweꞌá asínkáíye. ");
INSERT INTO auy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ímbo óntamo máráán-kwaasi keséꞌa maéꞌmaeꞌa wéiyaꞌa túwaꞌnai ónae séꞌa túwaꞌnai ónááfo kemá keséꞌa marapáꞌá ímba maéꞌmaeꞌa ónaumne. ");
INSERT INTO auy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Púwóndaraꞌa masawémba asinkésa utánáafo minínínkó éꞌa masawémba asínkáíye. ");
INSERT INTO auy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Éraiꞌa súmpo ísáaro. Kesí ásé-aai seyaafáꞌ-mápáꞌá simátimesa minínínkómó uwásínkáín-aai simátimiyasa táákaꞌa maránááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Súwana Ísuni kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasifinkemba moóráwigon-awiꞌa Yúndasi moórá-awiꞌa Ísakerioti óraaꞌ-amaan-kisau-waasifaꞌa wéna ");
INSERT INTO auy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","séna Ísumbo taꞌótoraimo aráátíménaꞌo éꞌa nóraumai-meyana siménaao súwasa moórá-waai úmai siyáánkai-ontamba 30 ontamba toráumai ámúwana Yúndasi maimaéna ");
INSERT INTO auy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","wéna nóraumaiya Ísumba aráátíménasawa taꞌótoranaao-imayaa ómbarena úmaena kuráiye. ");
INSERT INTO auy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yúndaa-waasi ímbo intóráín-tantaaꞌwara-pereti agáún-kanaa aifa-kánáá túntemba wení kísau-waasi Ísumba taáísai esa sésa nááfara tíyótaimo í-tánómbá kogaufónaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ísu séna Yérúsaremu-naopaꞌa wékai moórá-waasigontafe sékai kentáásí óraako séna kesí kanaamá tisatá kesí kísau-waasiseꞌa ení naaúmpaꞌa tíyótaimo í-tánómbá nánaumne wésiye kosimámékaiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ísumo súntemba miyá ésarai minkáꞌá tanómba kauwánkaraaye. ");
INSERT INTO auy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tanómba kaumakóyasa fenómpinkaꞌa Ísu wení kísau-waasi wésa mindáúmpáꞌá imésa ");
INSERT INTO auy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","tómbá wémandesa uwaná Ísu séna kempínkémbá moóráwigo kembá namuro-wáásí aráátiminiye súwana ");
INSERT INTO auy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tirunkó umbaí tówasa moórá-mora áísai esa sésa Fasiꞌaénkóo kewáꞌíyo símaesa kuwaná ");
INSERT INTO auy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ísu séna moóráwigo wení tón-ayai maimaéna keséꞌo moórá-taufapimba túꞌmaimo náíndawi wemá kembó namuro-wáásímó aráátimindawin-iye. ");
INSERT INTO auy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Naaófáꞌá Maníkón-aai aúfáífimba agaimaréna séna waási úranko puwíníye siyáintemba póꞌa púwónana namuro-wáásímó aráátimindawi sáwí-meyamba máíníye. Wembó ímbo maꞌánkaraankakaa kaweꞌá isinó Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yúndasi wembó aráátimindawi séna óraakoo kentáféwa sénó súwana Ísu séna éꞌa séne siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Súwasa tómbá wénowana Ísu péréti maisoréna Maníkómpáꞌá súwiyo séna tafámbai wení kísau-waasi tiména séna mindá kesún-ifo maimái naaró séna ");
INSERT INTO auy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ándá-aran-dombo wéron-anafeumba maisoréna Maníkómpáꞌá súwiyo séna tiména séna seyaafáꞌá naaró. ");
INSERT INTO auy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mindá kesí naaén-iye. Kesí naaemá sáwífaꞌ-waasisafena kumínda póna Maníkó sáwí-imayaa maitiyuwéna séna keséꞌa kááísamai méraiwae séna mináú-ááí símai kááísamakaiye. ");
INSERT INTO auy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Simátime súne. Fíꞌonkwaraꞌa ándá-aran-domba ímba nánaumpo kesifo wení waásimo kawáánipaꞌa keséꞌo méraiyamba ándá-aran-domba aú-nomba nánaumne Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Maníkóntáfésa ísámai imá simásuwesa mindáúmpáꞌá tuwésa Órífi-omapaꞌa iyáawe. ");
INSERT INTO auy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Órífi-omapaꞌa imérowana Ísu simátimena séna Maníkón-aai aúfáífimba agaimaréna séna Maníkó séna sipisípiyaꞌo kawáániwaimba tufúwónasa sipisípisomba wété ónááwe Maníkó siyáiye siyáimba póna káféꞌ-noꞌwaamba tááꞌa ínaꞌa siyuwéꞌa wété ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Énifo púwónasa utámaraiya íyáfasineꞌa kentí aifaꞌá Káríri-aempa konaꞌá kesínaaemba kónááwe Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pítaa séna seyaafáꞌnánká auwésa wété ónááfo kemá ímba miyá ónaumne súwana ");
INSERT INTO auy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ísu séna éraiꞌa simáme súne. Káféꞌ-noꞌwaamba kokórigo ímba ááimo siyáindaraꞌa emá kaumbo-íkáꞌá kentáfé sé ímbo awánáúnda-waasiye sínone Ísu Pítaantafena súwana ");
INSERT INTO auy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pítaa séna entéꞌo sínkamonae íyaꞌo éꞌa ímba auwéꞌa kónaumne súwasa wení kísau-waasi seyaafáꞌá miyá simásaraawe. ");
INSERT INTO auy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Seyaafáꞌá miyá simásuwesa Ísuwe wení kísau-waasiye taaiyámófaꞌa áwíꞌa Kétésémánifaꞌa komésa Ísu simátimena séna maankáꞌ-méraiyaꞌa Maníkómpá inaí kosenó séna ");
INSERT INTO auy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pítaane Sépétin-ááninkaiye tíꞌmaena komérowana umbai-tántáákó arumbá sáwíꞌa úwana ");
INSERT INTO auy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","simátimena séna kesirunkó umbaiséꞌa taisá póꞌa púwóraantamba wéune. Maankáꞌ-méꞌa keséꞌa káráwiyoro séna ");
INSERT INTO auy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tiyuwéna ewaaꞌá wéna Maníkó óraakon-iye séna maraꞌá kumbéna inaifínkémbá séna kesifóo emó kanaán-iye sémo e maanúmbáí-tántááꞌó kempáꞌó tínda maisiyuwé énifo ímba kesí imáyáan-ifo ení imáyáa arááíwáéno Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ísu inaí simásuwena wení kísau-waasiyaufaꞌa téna tatuwánómba tún-kwaigurówana tatúséna Pítaantafena séna ímba kanaaráꞌá kárikaꞌa keséꞌa káráwimai méraane. ");
INSERT INTO auy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Waántáwanko tísai úmai isánae-aai kempáꞌá sifáínifo Maníkómpáꞌá inaí seró. Imáyáago ewé sisaná áúgo umbaimó wétaimba mindá aúgáfaaꞌa wéiye simátimena ");
INSERT INTO auy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","anekaꞌá tiyuwéna ewaaꞌá wéna Maníkómpáꞌá inaifínkémbá séna minúmbáí-tántááꞌá empáꞌá úwoi tíníyemo sinaꞌó éꞌa emó sindantembá miyá ónaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ísu inaí kosimásuwena wení kísau-waasiyaufaꞌa téna tatuwánómba tún-kwaigurésa túgáfaateꞌa wéuwana ");
INSERT INTO auy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","anekaꞌá tiyuwéna ewaaꞌá wéna súntemba anekaꞌá inaí kosimásuwena kouweréna ");
INSERT INTO auy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","minkáúmbónárausafena séna túmó waiguréꞌo méraamba kembá waási úrankomba sáwíꞌo on-kwáásí aráátiminasa taꞌótoraiyan-kanaa wétifo ");
INSERT INTO auy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","íyáfasinewata wétiyapata konó. Kembó aráátimindawi wétiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ísu minááí wésuwana wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasifinkemba moóráwigon-awiꞌa Yúndasi túmba weséꞌa sáwífaꞌ-waasi taánáínkwara paepáéꞌwaraꞌa maimaé tumbá óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye miwí tiꞌmárówasa tumbá ");
INSERT INTO auy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ááéma Yúndasi Ísumbo aráátimindasafena simátimena séna aaweyáámó uwánkáandawimba taꞌótóráaro siyónkaꞌa ");
INSERT INTO auy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","póna Yúndasi Ísumpaꞌa téna séna óraakoo méraano wésena aaweyáá wéuwankowana ");
INSERT INTO auy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ísu séna kesí waásiyo emó ónaemo sinda-íꞌa uwó súwasa weséꞌo tuwáí Ísumba taꞌótórówana ");
INSERT INTO auy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ísuni kísau-waasifinkemba moóráwigo paepáéꞌa awáúfínkémbá mósá taútuwena aifaꞌ-ámáán-káwáágóní kísau-waasigon-ááꞌa fagáúsuwowana ");
INSERT INTO auy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ísu wentáféna séna ení paepáéꞌa awáúfáꞌá wiyuwó. Paepáétambo tínkamiyan-kwaasi anondáámo ésa paepáétamba tínkamiyasa puwónááwe. ");
INSERT INTO auy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Maarásáféꞌa imáyáan-oro. Kesifontáféꞌo séꞌo súwaꞌnai uwómó senanamó éna wíyómpaken-kisau-waasisomba sáwífaꞌnanka ímbo kanaamó torausónááwi minúwóíyáámbá tiꞌmaráínasa súwaꞌnai ónááwe. ");
INSERT INTO auy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Miyámó súndarakaa Maníkón-aai aúfáífimba agaimakáin-umbai-tantaaꞌa kempáꞌá ímba tisinó. Énifo siyáintemba miyáumai paápé íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ísu minááí simátimena tun-kwáásísáféna séna kentáféꞌa umén-kwáásín-iye séꞌa póꞌa taánáínkwara paepáéꞌwaraꞌa maimaéꞌa kembá taꞌótoranae séꞌa wétewe. Sáwífa-kanaa óraaꞌ-amaan-daumpaꞌa kesááimo wésimatimundaraꞌa ímba kembá taꞌótokaawe. ");
INSERT INTO auy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Naaófáꞌá Maníkón-aaimo simátímakowi aúfáífimbo agaimakáan-aai kembó miyámó uwásínkéneꞌa wétewe súwasa wení kísau-waasi seyaafáꞌá inkaisésa auwésa wété uráawe. ");
INSERT INTO auy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wení kísau-waasi inkaisésa auwésa kóuwasa Ísumbo taꞌótórówi áíꞌmaesa aifaꞌ-ámáán-káwáágón-áwíꞌa Káyafaasini naaúmpaꞌa móankesa mindáúmpáꞌá ámáámbo sun-kwáásíyé Yúndaa-oraaꞌ-waasiye túwaandu urón-daumpaꞌa móankowana ");
INSERT INTO auy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pítaa tínaaemba nénkaꞌo témomba aifaꞌ-ámáán-káwáágóní máápaꞌ-ontafinkemba iyéna naamaáífa ména Ísun-aneꞌó paápé índamo awánáíndasafena i-wáásísé méraiye. ");
INSERT INTO auy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pítaa mérowasa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye seyaafáꞌnánká Ísumba tufuwíyana puwíníye-aaigoni áwáuma saafá uwaná ");
INSERT INTO auy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ímba wérowasa Ísuntafesa mósimesi-aai sésa ímba moórá-aai suwasá kaeꞌ-wáásígóráí íyáfasinesarai ");
INSERT INTO auy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","karoꞌá sésarai wemó sisatáámó isáúndasa óraaꞌ-amaan-damba Maníkóní naambá kanaa tawísísuweꞌa kaumbo-kánáá maisuwéꞌa ónaumne siyáiye suyaná ");
INSERT INTO auy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","aifaꞌ-ámáán-káwáágó íyáfasinena Ísumba áísai ena séna mindáraimo simánkaayan-aai anondáá ína sínono súwana ");
INSERT INTO auy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ísu iséna ímba aaí súwana aifaꞌ-ámáán-káwáágó séna Maníkó fasiꞌaénkwáráwín-aúrankaꞌa emá méma áísai onda-ááí éraiꞌ-aai aantemba simásimiyo. Maníkómó íyáfasinankaraiwai Káráísiti Maníkón-ááninkowaꞌonompo simásimiyo súwana ");
INSERT INTO auy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ísu séna éꞌa sémpo simátimeꞌa súne. Ánaaemba suwánáíyaꞌa kemá waási úranko Maníkó fasiꞌaénkón-ayáánúrapaꞌa fasiꞌaén-áémpá iméꞌa ainánkáꞌá kumónaumne Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","aifaꞌ-ámáán-káwáágón-arunko sáwíꞌa úwana wení unáánkwátói tafétuwena séna Maníkómbá karaánááꞌa ankéna wesáféna sifó minááísáféta aaifimbá maenkéta fíꞌon-aaimo simánkáámba saafá únda póta ifátá tuwéta Maníkómbó símaimo sáwíꞌo uwánkáíntafeta ");
INSERT INTO auy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","nórasaawa ónaumno súwasa sáwíꞌan-ifo tufuwíyana puwíno sésa ");
INSERT INTO auy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ísumba tuwiyáái wiꞌankésa tufuwésa tiyáántambo tufúwún-kwaasi ");
INSERT INTO auy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","karaánááꞌa sésa esáfé sé Maníkó íyáfasisinkaraiwai únemo séndawi ómpo kemá nááwa tufúnái simásimiyo siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pítaa naamaáífa mérowana aifaꞌ-ámáán-káwáágóní kísaumo maún-arasigo awánéna wempáꞌá téna séna Káríri-aempakewiseꞌo maéndawi óne súwana ");
INSERT INTO auy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pítaa seyaafáꞌ-wáásí túrankaꞌa séna emó sénda-aai sááko ímba kaweꞌán-iye simásuwena ");
INSERT INTO auy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","máápaꞌ-ontafimba komérowana anekaꞌá moórá kísaumo maún-inaamarugo awánéna méron-kwaasisafena séna minkwáásígó Ísu Násareti-naopakewiyeꞌo máíwain-iye súwana ");
INSERT INTO auy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pítaa aikaꞌá maréna séna ímbo awánáúnda-waasin-iye simásuwena mérowasa ");
INSERT INTO auy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","kárikaꞌa mésa Pítaampaꞌa tésa sésa Ísuni kísau-waasi miyán-kwáásí méraawataamo awánemaundantenkaan-kwaasiyaamba éma mináémpákén-kwáásí tááiyaamba wésene suwaná ");
INSERT INTO auy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pítaa séna karoꞌ-ááímó wésenanamo éna Maníkó sínkaminiye. Sewímbá ímbo awánáúnda-waasin-iye súwana kokórigo áái súwana ");
INSERT INTO auy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pítaa Ísumo simámakon-aai áákaꞌ-maréna miyá siyónkaꞌa kokórigo ááimo ímbo siyáindaraꞌa emá kaumbo-íkáꞌá kentáfé sé ímbo awánáúnda-waasin-iye sínone siyónkaꞌa minááí áákaꞌ-maréna máápaꞌa kuména áfááraumai ifiꞌá taráiye. ");
INSERT INTO auy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Úwasa aafáúmó íyáúsunkaꞌa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye Ísumbo tufuwíyanamo puwínda-aai símai tarímaresa ");
INSERT INTO auy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ísumba ayáánkaꞌa káráꞌumaresa áíꞌmaesa Rómu-kamani-kawaagon-awiꞌa Páíratimpaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Páíratimpaꞌa kuwaná Yúndasi Ísuni pintaruꞌó maiyówi Ísu puwíníyemo sun-ááí iséna ímbo miyá oráámbá kemá sáwíꞌa uráumne séna pintaruꞌó ésamo ámakon-ontamba 30 ontamba maimaéna óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye miwífáꞌá wéna séna ");
INSERT INTO auy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ímba sáwíꞌa uráin-kwaasi aráátimunaꞌa tufuwónaeꞌa wéomba kemá mindá sáwíꞌa uráumne súwasa miwí sésa ímba kentáánén-ifo endén-iye suwaná ");
INSERT INTO auy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yúndasi minóntámbá óraaꞌ-amaan-daumpaꞌa metuwéna tiyuwéna ándá maimaéna waandaꞌá faráiye. ");
INSERT INTO auy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yúndasi minóntámbá óraaꞌ-amaan-daumpaꞌa metuwówasa óraaꞌ-amaan-kisau-waasi maésa sésa maanóntámbá pintaruꞌ-óntámbá póta seyaafáꞌ-wáásímó Maníkóntáfésamo imáyáamo ésamo máráán-ontampimbo máráandasa kentáásí ámáámba taraisónaumne simásuwesa ");
INSERT INTO auy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","minóntánkón-aai sésa mimbórá-ááí sésa minóntántámbá moórá-marama sawemó om-bárámá méyámbakaanasasa mimbáráfímbá fíꞌom-barafaken-kwaasi puwíyan-kwaasi utánááwe siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Miyá uráantafesa mimbárásáfésa sésa pintaruꞌ-márámán-iye siyáawasa káféꞌwaraꞌa miyá wésewe. ");
INSERT INTO auy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Óraaꞌ-amaan-kisau-waasi miyán-ááí wésesa mimbárámá méyámbakaamba Maníkón-aaimo simátímakowin-awiꞌa Yérémayaamo siyáin-aai paápé uráiye. Yérémaya séna Ísarerin-aísaafitantambo uráawi tuwímbai mimbórá-ááí sésa moóráwigombo pintaruꞌó íyan-ontamba 30 ontamba maimaésa ");
INSERT INTO auy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","sawemó wéom-barama méyámbakaamba Fasiꞌaénkómó simásímakaintemba miyá ónááwe Yérémayaamo siyáintemba pósa miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ísu Rómu-kamani-kawaagon-aúrankaꞌa mérowana áísai ena séna Yúndaa-waasiti kawáágówá ónó súwana Ísu séna éꞌa séne súwasa ");
INSERT INTO auy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye fíꞌo-fiꞌon-aaisafesa aaifimbá maénkówana Ísu iséna ímba aaí súwana ");
INSERT INTO auy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Páírati Ísumba áísai ena séna sáwífaꞌ-aai wésimankaafo ína wéisaano súwana ");
INSERT INTO auy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ísu iséna seyaafáꞌ-ááísáféna ímba anondáá súwana kámáni-kawaago Páírati sáwífaꞌ-imayaa uráimbaniye. ");
INSERT INTO auy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Naaófáꞌá Maníkó Yúndaa-waasi tíyótai í-tánón-kánáá túntemba Rómu-kamani-kawaago séna seyaafáꞌnánká túwaandu urésa aamoí ésa ándáfaꞌo mérain-kwaasigon-awiꞌa síyaꞌa faútuwanaumne séna minkánáá miyáumai ándá-waasi faútínkáíye. ");
INSERT INTO auy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","minkánáá moóráwigon-awiꞌa Párápási seyaafáꞌnánká wenáái ísarowi ándáfaꞌa mérowasa ");
INSERT INTO auy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","sáwífaꞌ-waasi túwaandu urówana Páírati tísai ena séna ándáfaꞌo méraan-kwaasifinkemba moóráwigon-awiꞌa síyaꞌa faúꞌauwaano. Párápásiyaꞌi Ísu Maníkómó íyáfasinankaraiwaiye wésewinaꞌiyo séna ");
INSERT INTO auy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Páírati imáyáa éna séna óraaꞌ-amaan-kisau-waasi Ísuntafesa ímba óraaꞌ-waasi-iꞌa ínkwae sésa taꞌótoꞌmaesa ke maúndafaꞌa áíꞌmaesa tiyáawe séna minááí tísai uráiye. ");
INSERT INTO auy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Páírati minááí tísai ena aaimó ísón-daumpaꞌa mérowana awaainínkó moóráwigomba aiꞌmarówana wempáꞌá téna séna enawaainínkó séna nóꞌwaamba kaaimbá awánáúnda minkwáásígó ímba sáwíꞌa uráisana sirunkó umbaí wétaifo ímba aaifimbá maenkaaó enawaainínkó siyé kosimámakaiye. ");
INSERT INTO auy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Awaainínkón-áái kosimámuwasa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye úwoi-waasi sáwífaꞌnanka waꞌwisésa sésa Páíratintafeꞌa séꞌa Párápásimba faúꞌáúwénasa Ísumba tufíyana puwíno simáméro simátímúwana ");
INSERT INTO auy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Páírati anekaꞌá tísai ena séna minkáéꞌ-wáásífínkémbá nááwana faúꞌauwanaumno súwasa miwí sésa Párápásimba faúꞌauwaao suwaná ");
INSERT INTO auy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Páírati séna Ísumba Maníkómó íyáfasinankaraiwainemo sewímbá nóra ónaumno súwasa seyaafá sésa aaraa-táíyáꞌá tufíyana puwíno suwaná ");
INSERT INTO auy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Páírati séna nóra-sawira uráiyo súwasa óraaka sésa aaraa-táíyáꞌá tufíyana puwíno aantemba siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Miyá aantemba suwaná Páírati miwí táái ímba kanaaꞌá taraisónaumne-imayaa éna seyaafáꞌ-wáásí tíyáafo séna táúfapimba nombá fatímarena seyaafáꞌ-wáásí túrankaꞌa aiyowáíꞌa éna ayáámba non-kwiyéna séna miwámó puwínda-umbai-tantaako kesiyáámpimba ímba wéraifo kentiyáámpimba wéraiye súwasa ");
INSERT INTO auy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","seyaafá sésa puwínata mimbéyámbá kentáásísaafitantambo íyawiseta maénaumne suwaná ");
INSERT INTO auy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Páírati Párápásimba faúꞌauwena i-wáásí simátimuwasa Ísumba áwíyandasamba áwiyonkuꞌ-nowana Páírati séna áíꞌmae aaraa-táíyáꞌá tufuwíyana puwíno séna Ísumba i-wáásí tímakaiye. ");
INSERT INTO auy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Páírati Ísumba wení i-wáásí timúwasa áíꞌmaesa kámáni-waasiti naaúmpaꞌa móankesa seyaafáꞌ-í-wáásí táántowasa tamésa ");
INSERT INTO auy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","wení unáánkwátói faútuwesa naae-únánkwátói óraaꞌ-waasiti unáánkwátóin-iye sésa Ísumba uwánkesa ");
INSERT INTO auy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","óraaꞌ-waasiti kámoꞌan-iye sésa áwíyandama owepámai Ísu aꞌnómpímbá kuféꞌankesa táúmba ayáánúrapaꞌa toꞌankésa karaánááꞌa ankésa moórá-mora kífaesa sésa Yúndaa-waasiti kawáágó óne sésa ");
INSERT INTO auy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tuwiyáái wiꞌankésa ayáámpimbo toꞌánkón-taumba maiyésa aꞌnómbá wétufamesa ");
INSERT INTO auy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","karaánááꞌa ánkásuwesa naae-únánkwátói faútuwesa wení unáánkwátói uwánkesa tufíyanamo puwíndafaꞌa áíꞌmaesa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","I-wáásí Ísumbo áíꞌmae kumbá moóráwigo Sáíríni-naopakewin-awiꞌa Sáímoni aampaꞌá túwasa i-wáásí taꞌótoresa Ísumbo tufíyan-aaraa-tai áúwaataꞌankesa sésa áwaꞌnai úmai tiyó suwaná miyá úwasa ");
INSERT INTO auy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","marésa moórá-maragon-awiꞌa Kórígótaafaꞌa wésa mináwíkóní áwáuma aꞌnónayaantapaꞌemo supaꞌá wésa ");
INSERT INTO auy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ándá-aran-domba maiyésa áíꞌa taiꞌáínkwae sésa ikamó fain-tántááꞌá mimpímbá marésa Ísumba ámúwana óikaꞌa maꞌmái awánéna ímba naráiye. ");
INSERT INTO auy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ísu ímba nówasa áíꞌmaesa aaraa-táíyáꞌá aíyayaampimba tufúsúmaresa wení unáánkwátói maénae sésa ááfésa wétiyaananasa nááwa íyáákaindawiya máíníyo sésa miyá ésa ");
INSERT INTO auy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","maraꞌá mésa Ísunkaꞌa káráwiyesa ");
INSERT INTO auy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ísumbo tufúwanamo puwún-aaigoni áwáuma aúfáífimba agaimarésa sésa Ísu Yúndaa-waasiti kawáágón-iye agaimarésa aꞌnónkáꞌ-ááráá-táíyáꞌá mósá marésa ");
INSERT INTO auy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","uméntéꞌo uyan-kwáásíyáí tíꞌmaesa Ísuni séfasefaꞌ-aempaꞌa aaraa-táíyáꞌá tufúsúmaresa maraꞌá mésa minkwáásíyáꞌá káráwiyowasa ");
INSERT INTO auy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","tuwímbai tésa tiyáámba tóipimba faafésa timántákáí faꞌankésa karaánááꞌa ankésa sésa ");
INSERT INTO auy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","úwé emá séma óraaꞌ-amaan-damba tawísísuweꞌa kaumbo-kánáá maisuwéꞌa anekaꞌá ónaumne siyáampo Maníkón-ááninkomo émo e esáfé enáú áwaꞌnai ema eyááríkaꞌa taaiyakémbá taútuwe marapáꞌá kumuwó siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Suwasá miyáumai óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé Yúndaa-oraaꞌ-waasiye karaánááꞌa ankésa ");
INSERT INTO auy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","sésa fíꞌowi túwaꞌnai ena wesáféna wenáúma ímba kanaa áwaꞌnai iye. Ísareri-waasiti kawáágó únemo sémáímba póna éraiꞌo sémaindamo éna weyááríkaꞌa aaraa-táíyákémbá kumínata awánéta séta éraiꞌa Maníkón-áánimban-iyesa sénaumne. ");
INSERT INTO auy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Maníkóntáféꞌa fasiꞌámai méraunda Maníkón-áánimba úne sémáímba Maníkómó áwaꞌnai ónaemo sénaraa káféꞌa áwaꞌnai isinó suwasá ");
INSERT INTO auy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","miwímó suntembá uméntéꞌo uyan-kwáásíyáí séfasefaꞌ-aempa-taiyaꞌo tufúsúmarowiyai karaánááꞌa Ísumba ánkaraaye. ");
INSERT INTO auy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ísumba karaánááꞌa ánkówana wááwái seyaafáꞌ-áémpáꞌá túnkwéna aafáúmó taenónkaꞌa túnkúmba ");
INSERT INTO auy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ísu óraaka Yúndaa-waasi-taaifinkemba séna eri eri rama sapakataniyemo súmba maarán-iye. Maníkó kesí Maníkóo nóra séwa siyuwááno súwasa ");
INSERT INTO auy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","minkáꞌó méron-kwaasi isésa tuwímbai sésa naaófáꞌá Maníkón-aai simátímakaiwaimba Íráiyaamba wéaantaiye suwaná ");
INSERT INTO auy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","moóráwigo awaantanténa faru-táénáma maimaéna ándá-aran-domba ika-nómpímbá tuꞌmaéna ofiyen-táemopimba sinúfaimaena náínkwae séna Ísun-óikaꞌa mósá marówasa ");
INSERT INTO auy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","tuwímbai sésa Íráiyaama kuména áwaꞌnai íni ína áwaꞌnai íníyo séta amuꞌmaréta méraumne suwaná ");
INSERT INTO auy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ísu anekaꞌá óraaka séna afowan-ayáámpimba wení ámútamba toꞌmaréna pukáiye. ");
INSERT INTO auy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ísu puwúwana óraaꞌ-amaan-daumpaꞌa ampanta-óntámó úmakomba sanaan-áyáíyákémbá itafááꞌmaena marapáꞌá mútafaatena kaesé uwágúwana póna Maníkómpáꞌó iyíyan-amba wiꞌmarówana óraaꞌ-marima tówana óraaꞌ-ontantomba tufánkaaꞌa wéuwana ");
INSERT INTO auy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","utámárón-ontan-aifimba awááúmaron-ontamba fawákúwasa Maníkóní waási sáwífaꞌnankaꞌo pukómpinkemba íyáfasinesa ");
INSERT INTO auy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","utámakon-ontan-aifinkemba íyáfasinesa mésa Ísu pukéna íyáfasinon-kanaa Yérúsaremu-naopaꞌa paápé úwasa sáwífaꞌnanka awánaraawe. ");
INSERT INTO auy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ísu puwúmba i-wáásítí kawáágówé wení i-wáásíyé Ísunkaꞌo káráwisuwesamo mérowi marímo tówanamo seyaafá-tántááꞌó paápé úmba awánésa áfááraumai táátafesa ésa sésa éraiꞌa wemá Maníkón-ááninkon-iye siyáawe. ");
INSERT INTO auy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Minááímó sumbá sáwífaꞌ-inimba awánánae sésa tumbá nénkaꞌa tamésa awánaraawe. Miníníntómbá Káríri-aempakembo Ísumbo arááíwaꞌmaesamo áwaꞌnai úmaesamo Yérúsaremufaꞌo tiyáan-inintompinkemba ");
INSERT INTO auy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","moórá-inimba Mágátáraa-naopaken-ininkon-awiꞌa Máríyaa úwana moórá-inimba Yémísinte Yósepinte tinówan-awiꞌa Máríyaa úwana moórá-inimba Sépétin-ááninkai tinówa úwasa tuwímbai-inintonkwaraꞌa tamésa awánaraawe. ");
INSERT INTO auy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Miníníntómbá tamérowana fenómpinkaꞌa moóráwigo óntawarawin-awiꞌa Yósepi Árímátíyaa-naopakewi Ísun-aaisafena éraiꞌe súwai ");
INSERT INTO auy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Páíratimpaꞌa téna séna Ísun-áúma utánáifo simiyó súwana wení i-wáásísáféna séna Ísun-áúma mai-áméro súwasa miyá uwaná ");
INSERT INTO auy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yósepi Ísun-áúma tamaimái aú-ampantafimba asááúmaena ");
INSERT INTO auy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","maimaéna kemó púwónasamo utáíyane sénamo aúsámakon-ontan-aifimba mámarena óikaꞌa óraaꞌ-ontantamba awááúwasuwena kóúwasa ");
INSERT INTO auy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Máríyaa Mágátáraa-naopaken-ininko úwana araámáóeꞌa maraꞌá mésarai Ísumbo utámárón-ontan-aifimba karátuwesarai méraaye. ");
INSERT INTO auy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Minínínkáí karáꞌmatuwesarai méroyasa aafáyáaraꞌa sambaatiyáꞌá óraaꞌ-amaan-kisau-waasiye ámáán-kawaa-waasiye Páíratimpaꞌa túwaandu ésa ");
INSERT INTO auy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sésa óraakoo úwoimo aúmó arónkaꞌa karoꞌ-ááíséꞌo siwáí séna kaumbo-kánáá maisuwéꞌa púwóndafinkemba íyáfasinanaumne súwataamo ísaraundasa sáákata maráúmpo ");
INSERT INTO auy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","i-wáásí tiꞌmárénasa kaumbo-kánáá utámáráán-ontan-aifimba kogáráwiyesa awánaaro. Wení kísau-waasi wenáúma fasímbaesa aúpáꞌá utámaresa sésa pukáimpinkemba íyáfasinkaiye sefáínifo. Miyán-ááímó síyanamo éna minkáróꞌ-ááígó ááémo siyáin-karoꞌ-aaigomba íyáákaifainiye suwaná ");
INSERT INTO auy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Páírati séna kentí i-wáásí tiꞌmáréwasa sentembá minóntán-aifimba kaweꞌ-úmai káráwiyoro súwasa ");
INSERT INTO auy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","wésa waási óntan-aifimba íyáféráafo sésa torú maimaésa mókaaisamaranae sésa kurésa miyá araénáémba úmaresa i-wáásí mátiyuwesa kóuraawe. ");
INSERT INTO auy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yúndaa-waasimo saagon-kánáá taiꞌówasarai sondaaráꞌá aafáyáaraꞌa aafáúmó íyáúsunkaꞌa Máríyaa Mágátáraa-naopaken-ininko úwana araámáó úwasarai Ísumbo utámakopaꞌa koawánánae sésarai kuyambá ");
INSERT INTO auy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","3","óraaꞌ-marima tówana Fasiꞌaénkóní kísau-waasigo wíyómpakemba kuména wenóikakemba aafáúmó íyáúsenamo intembá wéuwana wení unáánkwátóiyakemba ainánkómó intembá waéníꞌa kówana kuména óntambo óikaꞌo makón-ontamba kufankwátuwena minóntánkáꞌá maraꞌá mérowana ");
INSERT INTO auy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","utámakopaꞌo káráwiyuwai áfááraumai tááꞌa úwasa tinekembá tataꞌá úwana tímááfomba waékuraiye. ");
INSERT INTO auy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Káráwiyuwai miyá úwasarai minkáéꞌ-ínímbá kuyaná wíyómpakewi minínínkáí simátimena séna ímba tááꞌa íno Ísumba aaraa-táíyáꞌó tufúwówanamo pukáiwaimba taawánáyae sékaimo téyamba ísaraumne. ");
INSERT INTO auy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wemó siyáintemba pukáimpinkemba íyáfasinena kówéna ímba maankáꞌá méraifo utaráampimba iawánékai ");
INSERT INTO auy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","tuwaantantékai wení kísau-waasi kosimátimekai sékai Ísu pukáimpinkemba íyáfasinena kentí aifaꞌá Káríri-aempaꞌa wínaꞌa koawánánááwe. Minááí kosimátímékaiyo siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Súwasarai minínínkáí minúwóíyáámbá utarópaꞌa tuwésarai táátafesarai uyaná tirunkó aamoí úwasarai wení kísau-waasi kosimátimiyantafesarai aampaꞌá kuyambá ");
INSERT INTO auy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ísu minínínkáí tuwánéna séna nááfara maémayaayanaꞌo súwasarai óraako iyé-ímáyáá ésarai wenaísamaifimba tamésarai aísamaiyaꞌa taꞌótoresarai wen-ímáyáá mósá máróyana ");
INSERT INTO auy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ísu simátimena séna kesífáꞌawaawi kosimátimiyasa Káríri-aempaꞌa komésa suwánaaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ísu minááí súwasarai wemó súntemba minínínkáí aampaꞌá kuyambá utámárópaꞌo káráwiyun-i-waasi tuwímbai Yérúsaremu-naopaꞌa wésa óraaꞌ-amaan-kisau-waasi paápé ún-tantaaꞌa kosimátímúwasa ");
INSERT INTO auy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye túwaandu urésa aaí símai mimbórá-ááí tarímaresa utámárópaꞌo káráwiyun-i-waasi óraaꞌ-ontamba timésa ");
INSERT INTO auy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","simátimesa sésa maarán-ááí simátíméro. Nóꞌwaamba súsá kwaiguráunasa Ísuni kísau-waasi tésa wenáúma umémbá maimaésa kóuraawe kosimátímaꞌmaeꞌa nóro. ");
INSERT INTO auy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Páíratimo minááímó isáínataamo éta moórá-aaiwaraꞌa simáménanasa kembiwí ímba aaifimbá maitinkáíníye suwasá ");
INSERT INTO auy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","miní-wáásí isésa óntamba maimaésa kurésa sunten-ááí aantemba kosimátímaꞌmaesa núwana minááígó wété úwasa ísaraamba káféꞌwaraꞌa Yúndaa-waasi wéisaawe. ");
INSERT INTO auy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ísuni kísau-waasi sísamaifakemba moórá kumbaimái-waasi Káríri-aempaꞌa Ísumo minómákáꞌó koméraaromo siyón-omakaꞌa komérowana ");
INSERT INTO auy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","miwí túrankaꞌa paápé úwasa awánésa wen-ímáyáá mósá márówasa tuwímbai kaeꞌ-ímáyáá ésa sésa Ísu pukáimpinkemba íyáfasinkai fíꞌowawaꞌiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ísu miwí timándáraꞌa taména séna Maníkó fasiꞌaémbá siména séna wíyómpaꞌe marapáꞌé káráwiyuwo simbá ");
INSERT INTO auy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","póꞌa mindásafeꞌa seyaafáꞌ-máráfáꞌá kesáái simátímaꞌmaeꞌa níyasa kesí waási-iꞌa ésa kesifowé kemá wenááninkoe Ufaen-ámútánkóeꞌa kááísamai méraiyaꞌa kentáásúwíkaꞌa nombá maitinkéꞌa ");
INSERT INTO auy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","simátímakaunda-aai arááíwaesa fasiꞌámai taꞌótoraiwae séꞌa simátímaꞌmaeꞌa íyóro. Maramá wéraindaraꞌa kembiwíséꞌa méꞌa káféꞌo wérain-tantaaꞌo taiꞌáíndaraꞌa kembiwíséꞌa méraandasafeꞌa imáyáa úmaeꞌa íyóro Ísu siyáiye. Kemá Mátíyu súnda-aai taíꞌáiye. ");
INSERT INTO auy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Maníkón-ááninko Ísu Káráísiti wení ásé-aai maarán-iye. ");
INSERT INTO auy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Naaófáꞌá moóráwigon-awiꞌa Yóni ímbo méronkaꞌa Maníkón-aaimo simátímakowin-awiꞌa Áísáya Yónin-aai símai agaimaréna séna Maníkó séna isaaó. Moóráwigomba aiꞌmáráanana kesáái maimaéna ení aifaꞌá wéna ení aambá wiꞌankéna ");
INSERT INTO auy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","máásai-marafaꞌa ména aaemáíyakemba séna Fasiꞌaénkóní aambó wiꞌankáíyamba wení aambá arupíse úmai wiꞌankáíyana minámpáꞌá wíno Maníkó siyáiye Áísáya agaimaréna siyónkaꞌa Yóni paápé úwana minááí paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Yóni nombó maitinkówi máásai-marafaꞌa komérowasa Yúndiyaa-aempakene Yérúsaremu-naopaken-kwaasi seyaafáꞌá Yónimpaꞌa tuwaná simátimena séna kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌá tíyana sáwí-imayaa maitiyuwáínaꞌa nombá maitínkáano súwasa miwítí sáwí-awau kufíyúwana Yóni Yóndani-nompimba nombá maitínkaraiye. ");
INSERT INTO auy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yóni káámeri-poigoni áyáu-watoi iyéna ásisandena áꞌwáánkau uréna faꞌnóríné wantáámíkóní aúwé mintón-aantemba wénena ");
INSERT INTO auy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","simátimena séna moóráwigo kesínaaembo tíndawi wemá óraako kembá íyáákaraifo wemó aaí síndaraꞌo kemó sendá sáwíꞌan-iye. ");
INSERT INTO auy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kemá nombá maitinkánaumpo wemá Ufaen-ámútánkómbá aiꞌmaráínana kuména kempímbá óraaꞌa uwátinkainiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Minkánáá Káríri-aempaꞌa Násareti-naopakemba Ísu túwana Yóndani-nompimba Yóni wembá nombá maiyankówana ");
INSERT INTO auy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ísu nompínkémbá íyáfasinowana kampúaran-tawaai tuwínkaaꞌ-úwana Yóni awánómba Maníkóní ámútanko mááufuꞌ-numaraamba úmaena Ísun-aneꞌá kumbaúwana ");
INSERT INTO auy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","wíyómpakemba aaigó aantemba séna emá kesááninko ónaꞌa en-ímáyáá éꞌa óraaꞌ-aamoi uwánkaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Súwana Maníkóní ámútanko Ísumba simámuwana máásai-marafaꞌa komérowana ");
INSERT INTO auy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ayáátáákaꞌa 40 noꞌwaamba komérowana waántáwanko Ísu sáwíꞌo índa awánánae séna fíꞌo-fiꞌon-aai súwana Ísu ímba sáwíꞌo úmba afááꞌ-wáí-wáánkó íyáíseꞌa mérowasa wíyómpakemba Maníkóní kísau-waasisomba kumésa áwaꞌnai uwánkaraawe. ");
INSERT INTO auy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ánaaemba Yóni Káríri-marafaken-kawaagon-awiꞌa Érotintafena séna sáwíꞌa uráiye siyóntafena Yónimba ándáfaꞌa máankowana mérowana Ísu Káríri-aempaꞌa wéna Maníkóní ásé-aai simátimena séna ");
INSERT INTO auy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","miwání áwáu paápé isaná Maníkóní nombaragó ewaaꞌá tifo kentí sáwí-imayaa tuwéꞌa Maníkóní ásé-aaisafeꞌa timankúnkúmba oro siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Minááí simátimena Káríri-waaunkoni áwáífakafambo kúmba kaeꞌ-wáásíyáí awaaón-áwíꞌa Sáímoni úwana áfákon-awiꞌa Énduruweꞌa mésarai miwítí kísau pósarai mófááꞌa toꞌmái tímapaꞌa wénesarai mareꞌmareꞌ-únámbá nompí tukésarai méroyana ");
INSERT INTO auy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ísu simátimena séna keséꞌa tekaiyó. Mófááꞌo to-tímapaꞌo nóyantemba aú-kisau tíménakai wénekai kesáái simátímapaꞌa wéniyasa kempáꞌá teró súwasarai ");
INSERT INTO auy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","mimbáréꞌmáréꞌ-únámbá tuwésarai weséꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Weséꞌa kuyaná Ísu kárikaꞌa kúmba kaeꞌ-wáásíyáí Sépétin-ááninkai awaaón-áwíꞌa Yémísi úwana áfákon-awiꞌa Yóniyeꞌa nompín-táómpimba mésarai mareꞌmareꞌ-únámbá toꞌmayaa wéuyana ");
INSERT INTO auy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ísu tuwánéna táántowasarai mindómpín-táómpimba tifowáné wení kísau-waasiye tiyuwésarai Ísuweꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kápaneamu-naopaꞌa komérowasa Yúndaa-waasi ámáán-aaimo ísón-kanaa túwana Ísu ámáán-daumpaꞌa iména wenáái simátimuwasa ");
INSERT INTO auy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","isésa óraaka súntafesa sésa ámáámbo sentenkáámbá ímba wésifo óraaꞌ-waasigoraamba wésiye sésa táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Táátafesa uwaná minámáán-dáúmpáꞌá moóráwigo wenarumpimbá sáwí-amutambo méron-kwaasigo ména ");
INSERT INTO auy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","óraaka séna Ísu Násaretifakewi óne. Kentáá nórawa ínewa tasínkambaisaawa taiꞌáínono. Embá awánáúndawi Maníkóní kawe-kísáú-wáásí óne súwana ");
INSERT INTO auy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ísu sáwí-amutankontafena óraaka séna aseré minkwáásígómbá auwé kóuwo súwana ");
INSERT INTO auy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","misáwí-ámútánkó minkwáásí famétuwowana aíyayaanko tata úwana wááꞌa túmaena arumpinkémbá kóúwasa ");
INSERT INTO auy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","awánésa táátafe ésa keáímbá sésa mindórawaꞌiyo. Aúíꞌan-iye. Wemá sáwí-amutantafena óraaka sisasá sintembá wéowe suwaná ");
INSERT INTO auy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","miyá úwasa Káríri-aempaꞌa Ísun-aai wété úwasa ísaraawe. ");
INSERT INTO auy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ísówasa ámáán-daumpaꞌa tuwésa Sáímoninte Éndurunteti naaúmpaꞌo íyúmba Yémísiye Yóniye Ísuwe úmai íyúmba ");
INSERT INTO auy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sáímonin-áráandaomba áuiya kówana mérowasa Ísumba simámúwana ");
INSERT INTO auy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","iséna wempáꞌá téna ayáánkaꞌa taꞌótoꞌmai íyáfasinankowana mináúíyá taiꞌówana íyáfasinkwena tómbá agaimái tímakaiye. ");
INSERT INTO auy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Úwasa fenómpinkaꞌa tíꞌo ún-kwaasisonkwara sáwí-amutamba tirumpimbó méron-kwaasisonkwaraꞌa tíꞌmaesa Ísumpaꞌa tuwasá ");
INSERT INTO auy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","mindáópaken-kwaasisomba seyaafá ontaráꞌá túwaandu uwaná ");
INSERT INTO auy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ísu fíꞌo-fiꞌon-tiꞌo ún-kwaasisomba asófatinkena sáwí-amutamba tirumpinkémbá maitiyuwówasa misáwí-ámútántómbá Ísuntafesa Maníkón-ááninkon-iye sésa wembá awánontafena aséráaro Ísu súwasa kóuraawe. ");
INSERT INTO auy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kóuwana siyataróꞌá Ísu íyáfasinena mindáópaꞌa tuwéna Maníkómpáꞌá inaimó síndasafena ímba waásimo méropaꞌa koména inaí wésena mérowana ");
INSERT INTO auy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sáímoni wení waásiseꞌa Ísumba ayaafáí úmai ");
INSERT INTO auy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","awánésa sésa seyaafáꞌ-wáásí embá wéayaafai-owe suwaná ");
INSERT INTO auy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ísu séna fíꞌon-daopimpaꞌwarata wéneta kesáái simátímapaꞌa kónaumne. Miyámó ondasáféꞌa túne séna ");
INSERT INTO auy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Káríri-aempaꞌa ámáán-daumpimpa kosimátímapaꞌa wénena tirumpinkémbá sáwí-amutamba maitiyuwówasa kóuraawe. ");
INSERT INTO auy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Moórá-kanaa Ísumpaꞌa námombo kón-kwaasigo téna óraakon-iye séna aísamaifimba takífaena séna kentáfénamo ankáínamo e kanaaꞌá aúíꞌa uwásinkainono súwana ");
INSERT INTO auy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ísun-arumbá úwana ayáántamba aneꞌá taꞌótorena séna miyá ónaumpo enáúraꞌa karefóꞌa kawáúwiye súwana ");
INSERT INTO auy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","minúwóíyáámbá kawáúguwana ");
INSERT INTO auy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ísu óraaka séna enáúraꞌa kawáúwimba po Mósesemo siyáintemba ámáán-kisau-waasifaꞌa wéma enáúma máaraatime póíma tímínasa Maníkóntáfésa ísámai tufúꞌmai agaíyasa seyaafáꞌnánká awánésa áúrakemba kawáúwiye sénááwe. Énifo enáúraꞌo uwánkaunda-aai simátimunafo sé waaó Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","minkwáásígó ifátuwena kaweꞌó uwánkon-aai simátímaꞌmae iyúwana minááígó wété úwasa sáwífaꞌnanka Ísu tíníye sésa kentí naaópimpaꞌa túwaandu urówana mindásafena Ísu ímba naaóꞌ-naoꞌo kúmba waási ímbo méronkafamba mérowasa naaóꞌ-naoken-kwaasi wempáꞌá tóso uráawe. ");
INSERT INTO auy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tuwímbai-noꞌwaamba waéna Ísu Kápaneamu-naopaꞌo kúmba wení naaúmpaꞌa mérowasa sáwífaꞌ-waasi isésa ");
INSERT INTO auy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","túwaandu ésa mindáúmpá sisipáá ésa pááimpaꞌwaraꞌa sisipáá uwásowana Ísu wenáái wésimatimuwasa ");
INSERT INTO auy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","éíyain-kwaasi aísamaimo pukówimba taawiyaꞌmaésa tumbá ");
INSERT INTO auy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","mindáúmpá sáwífaꞌ-waasi sisipáá uwasá ímba kanaaꞌó íyóraantamba ésa naanamifaꞌá taawiyaꞌmaésa imésa afaaꞌá aúsámaresa ándára taꞌótoresa túwówana kumémena Ísumo méronka aúrankaꞌa kumúwana ");
INSERT INTO auy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ísu taawiyaꞌmaé tun-kwáásímó éraiꞌa kaweꞌá uwánkainiye-imayaamo umbá Ísu tuwánéna aísamaimo pukón-kwaasigontafena séna kesí waásiyo ení sáwí-imayaa maiyauwáúmne súwasa ");
INSERT INTO auy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ámáámbo sun-kwáásí mésa ");
INSERT INTO auy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","imáyáa ésa sésa nóra sénawa miyá síyó. Maníkó weyáá sáwí-imayaa maitiyuwáínífo waási ímba miyá ónááfo Maníkómbá karaánááꞌa ánkáíye-imayaa ésa suwaná ");
INSERT INTO auy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ísu minímáyáámó umbá iséna simátimena séna nóra séra miyán-ímáyáá wéoo. ");
INSERT INTO auy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Moóráwigo aísamaimo pukáindawintafenamo séna ení sáwí-imayaa maiyauwáúmne sínasamo ésa éraira sí karorá síyó sénááwe. Énifo moóráwigomo aísamai pukáindawintafenamo séna eyááríkaꞌa íyáfasine ení wandaaí maimaé waaó sínasamo ésa éraira sí karorá síyó sésa awánánááwe. ");
INSERT INTO auy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kemá waási úranko marapáꞌó méraunda waásiti sáwí-imayaamo maitiyuwáúnda-fasiꞌaemba tokáumpo aráátíménda awánánááwe séna aísamaimo pukón-kwaasigontafena séna ");
INSERT INTO auy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","isaaó. Íyáfasinke ení wandaaí maimaé naaópaꞌa waaó súwana ");
INSERT INTO auy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","seyaafáꞌ-wáásí túrankaꞌa íyáfasinkwena wení wandaaí maimaéna kúwasa seyaafáꞌnánká táátafesa ésa Maníkón-áwíꞌa mósá marésa sésa ímbo awánaraunda-iꞌa isatá awánáúmne sésa táátafesa ésa tiyáámba tóipimba fáákaawe. ");
INSERT INTO auy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ísu tuwéna Káríri-nonkwaaunkoni áwáífaꞌa kúwasa sáwífaꞌ-waasi wempáꞌá túwaandu uwaná wenáái simátimena ");
INSERT INTO auy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","wéna awánómba Áráfíásin-ááninkon-awiꞌa Rífái taakisimó máún-daumpaꞌa mérowana Ísu awánéna séna íyáfasine keséꞌa tiyó súwana íyáfasinena wembá arááíwaꞌmaena kuráiye. ");
INSERT INTO auy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kúwasa Ísuwe wení kísau-waasiye Rífáini naaúmpaꞌa imésa tómbá wénowasa taakisimó máún-kwaasiye sáwíꞌo un-kwáásíyé sáwífaꞌa Ísumba arááíwaꞌmaesa Rífáini naaúmpaꞌa imésa wénowasa ");
INSERT INTO auy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ámáán-kawaa-waasifinkemba ámáámbo sun-kwáásí Ísu taakisimó máún-kwaasiye sáwíꞌo un-kwáásíyé tómbó wénomba tuwánésa Ísuni kísau-waasisafesa tísai esa sésa nóra sénawa taakisimó máén-umen-kwaasiye sáwíꞌo on-kwáásíséꞌa Ísu tómbá wénaiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ísu iséna séna tíyofaan-kwaasi kaweꞌ-úmaimo méraan-kwaasi ímba wétuwaꞌnai-ofo tíꞌo in-kwáásí wétuwaꞌnai-owe. Mindásafeꞌa arupíse úmaimo méraan-kwaasi táántaanasa Maníkómpáꞌá tíwae séꞌa ímba kunkáumpo sáwíꞌo úmaimo méraan-kwaasi táántaanasa Maníkómpáꞌá tíwae séꞌa kunkáumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Moórá-kanaa Yóni nombó maitínkáíwaini kísau-waasiye ámáán-kawaa-waasiye Maníkóntáfésa imáyáa ésa tómbá ímbo nombá inaí aantemba wésuwasa tuwímbai Ísumba taáísai esa sésa Yónini kísau-waasiye ámáán-kawaa-waasiti kísau-waasiye moórá-mora-kanaa Maníkóntáfésa imáyáa ésa tómbá ímbo naambá inaí aantemba wésefo ení kísau-waasi ímba miyámó ombá tómbá úwoi wénaawe. Nóra sésawa miyá wéoo suwaná ");
INSERT INTO auy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ísu séna moóráwigo aaremó maíndawi amááraasomba tanómba kautimínda miwíséꞌa mérainasa aamoí ésa mintómbá ímba aꞌáo sénááfo úwoi nánááwe. ");
INSERT INTO auy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ánaaemba minkwáásígómbá aíꞌmae kóíyasa minkánáá amááraasomba tirunkó sáwíꞌa ínasa tómbá aꞌáo sénááwe Ísu séna wemó ánaaemba tiyuwénamo iyíndasafena minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ísu minááí simátimena séna ááéraan-ampantamo afaaꞌó wéraisasamo ombá aú-ampanta ímba kárámai wéfaruwowe. Miyámó íyanamo éna aú-ampantago sáwíꞌa ínana ááéraan-ampantago aú-ampantaraamba ímba íníye. ");
INSERT INTO auy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aú-anda-aran-domba ááéraa-sipisipi-asi-anafeumpimba ímba wéfatimaraawe. Miyámó íyanamo éna aú-anda-aran-donko óraaꞌa éna ááéraan-anafeumba kafaména sáwíꞌa ínana mindómbá úwoifaꞌa fatíwiniye. Mindásafesa aú-anda-aran-domba aú-sipisipi-asi-anafeumpimba wéfatimaraawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Moórá-kanaa Yúndaa-waasimo saagon-kánááráꞌá Ísuwe wení kísau-waasiye wíti-ton-kisaufaꞌa wéwesa wení kísau-waasi wíti-aramba kútúmai ásima pítuwesa nowasá ");
INSERT INTO auy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ámáán-kawaa-waasi tuwánésa Ísuntafesa sésa isaaó. Ení kísau-waasi saagaan-kánáámá aambá fáíꞌmakaawasa miyá wéowe suwaná ");
INSERT INTO auy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ísu séna naaófáꞌá Téfítimo uráimba aúfáífimbo agaimakáin-aaigoni áwáu ímba ísaraawe. Aifaꞌ-ámáán-káwáágón-áwíꞌa Ápáyata méronkaꞌa Téfítiye wení waásiye táái tówana Téfíti Maníkóní ámáán-daumpaꞌa iyéna Maníkón-aúrankaꞌo makón-tomba imaiyéna wénena wení waási timúwasa naráawe. Mintómbá úwoi-waasi ímbo néꞌómbanifo ámáán-kisaumo máún-kwaasi aantembo néꞌómbaniye. Téfíti mintómbá imaiyéna timúwasa nonkáꞌá Maníkó ímbo aaisambá siyáimbanifo kesí waási miyá owaꞌá aaisambá ímbo seráámbá wésewe. ");
INSERT INTO auy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Maníkó waásisafena imáyáa éna túwaꞌnai índasafena saagaan-kánáá maréna waási aifa-tántááꞌá maréna saagaan-kánáá ánaaen-tantaaꞌa póna túwaꞌnai índasafena makáiye. ");
INSERT INTO auy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wíyómpakemba waási úranko póꞌa saagaan-kánááráꞌó káráwiyaundawi úmpo saagaan-kánáámó waási kísaumo máémba kendén-iye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Moórá-kanaa Ísu ámáán-daumpaꞌo iyúmba moóráwigo ayáámbo kemporarón-kwaasi mérowasa ");
INSERT INTO auy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","aaifimbá maenkánae suwáí mésa Ísuntafesa sésa saagaanká póna minkwáásí kaweꞌó uwánkainataamo éta taꞌótoꞌmaisa aaifintá maenkánaumne sésa Ísumba awánomba ");
INSERT INTO auy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ísu ayáámbo kemporarón-kwaasisafena séna kemó méraundara tiyó súwana miyá úwana ");
INSERT INTO auy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ísu miwísáféna séna kentáásí ámáán-aaifimba nóin-aaiya wéraiyo. Saagaan-kánáárá póta kawe-kísáúsááwá máúm sáwí-kisausaawa wémaumno. Waási túwaꞌnai onasasááwá kawerá óna tínkamonasasaawa puwónááo tísai ena súwasa ímba aaí suwaná ");
INSERT INTO auy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ísu mótuwana-metuwana éna aaisambá títuwena waásisafesa ímbo imáyáamo ontáféna arumbá úwana ayáámbo kemporarón-kwaasigontafena séna enayáámba fárútuwaao súwana ayáámba fárútuwowana kaweꞌá uwánkowasa ");
INSERT INTO auy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ámáán-kawaa-waasi ámáán-daumpaꞌa tuwésa minúwóíyáán-úmai Érotini waási túwaandu ésa Ísumba nóraumaisaawa tufuwónaumno sésa tufuwíyanamo puwínda-aai siyáawe. ");
INSERT INTO auy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ísu tiyuwéna wení kísau-waasi tíꞌmaena Káríri-nonkwaaunkoni áwáífaꞌo kúmba sáwífaꞌ-waasisomba Kárírifaken-kwaasiye Yúndiyaafaken-kwaasiye ");
INSERT INTO auy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yérúsaremu-naopaken-kwaasiye Ítúmiyaa-aempaken-kwaasiye Yóndani-nonkoni menáípákén-kwáásíyé Táyaa-naoꞌ-aempaken-kwaasiye Sáíndóni-naoꞌ-aempaken-kwaasiye miyáumaifaken-kwaasisomba Ísuni kísau-aai isésa Ísumpaꞌa tóso uwaná ");
INSERT INTO auy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","12","sáwífaꞌ-waasi asófatinkowasa mindásafesa tíꞌo ún-kwaasisomba asófasinkainkwae sésa Ísun-aneꞌó taꞌótoraiyanesa faméꞌmae íyúwasa tirumpimbó sáwí-amutambo méron-kwaasi Ísumba awánésa maraꞌá kífaesa óraaka sésa emá Maníkón-ááninko óne suwaná Ísu óraaka séna Maníkón-ááninko óne séꞌa ímba símai paápé oro séna wení kísau-waasi simátimena séna sáwífaꞌ-waasi faméꞌmaesa famésiyuwaafo nompín-táómba maimaé ewaaꞌá másínkáaro siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ísu omápaꞌa iména tuwímbai íyáfasintinkanae séna táántowasa wempáꞌá íyúwana ");
INSERT INTO auy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","minkwáásífínkémbá sísamaifakemba kaeꞌá kumbaimái-waasi íyáfasintinkena séna kesí aantá-waasi éꞌa méꞌa kesáái kosimátímapaꞌo wíyantafe tiꞌmaréꞌa ");
INSERT INTO auy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tirumpinkémbó sáwí-amutambo komaitiyuwáíya-fasiꞌaembo timúnda miyásáféꞌa íyáfasintinkaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Miwí túwíꞌa Sáímoniye séna aú-awiꞌa Pítaawe simánkena ");
INSERT INTO auy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sépétin-ááninkorai túwíꞌa Yémísini Yóni aú-awiꞌa Póánésiye súwaiyai mináwíkóní áwáu wíyónaaimo siwáíní áráákoraiye súwaiyaisafena séna ");
INSERT INTO auy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","moóráwigo Énduruni moóráwigo Fírípini moóráwigo Pátóromiyuni moóráwigo Mátíyuni moóráwigo Tómaasini moóráwigo Áráfíásin-ááninko Yémísini moóráwigo Tándiyasini moóráwigo Sáímoni wemá Rómu-kamani-waasi tiꞌmátuwanaemo siyáiwaini ");
INSERT INTO auy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","moóráwigo Yúndasi-Ísakerioti wemá ánaaemba Ísumba wení namuro-wáásímó aráátímakaiwai miyáumai-waasi Ísu íyáfasintinkena naaópaꞌa kouwékáiye. ");
INSERT INTO auy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ísu naaúmpaꞌo iyúmba aneká sáwífaꞌ-waasi túwaandu ésa sisipáá untáfésa Ísuwe wení kísau-waasiye tómbá ímba kanaaꞌá naráátámba uwasá ");
INSERT INTO auy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ísun-amááraa isésa uwóíꞌa úmae wéniye sésa taaiyánae sésa tiyáawe. ");
INSERT INTO auy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yérúsaremu-naopaken-kwaasi Maníkóní ámáámbo sun-kwáásí tésa sésa sáwí-amutantonti kawáágón-áwíꞌa Píyésepuri fasiꞌaémbá ámísana tokéna sáwí-amutamba wémaitiyuwaiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ísu táántowasa tuwaná waéꞌmai-aai simátimena séna waántáwankomo éna ímba waántáwamba maisuwáíníye. ");
INSERT INTO auy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Moórá-andamo tiyésamo ésa tuwínkaaꞌa urésa ímba fasiꞌámai méranaawe. ");
INSERT INTO auy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Moórá-akumba aaimó tuwíntáán-akumba pósa tuwínkaaꞌ-urésa ímba fasiꞌámai méranaawe. ");
INSERT INTO auy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Waántáwankoni waási tiyésamo tuwínkaaꞌ-ésamo ésa ímba fasiꞌámai méranaawe. ");
INSERT INTO auy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Moórá-aai imáyáan-oro. Moóráwigo moórá-nankoni afowámó fasiꞌaéwí mérainanamo éna mindáúmpákén-úmémbó maíndasafenamo éna ímba úwoi íyáferainifo miwámá mindánkóní afowámbá ándá káráꞌumakenamo éna kanaaꞌá íyáfekena wení moparáwímbá umémbá máíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ísu simátimena séna ísáaro. Waási sáwí-kisau wémaesa símai sáwíꞌo uwátínkáámba mindá Maníkó maitiyuwáínífo ");
INSERT INTO auy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ufaen-ámútánkóntáfésa símai sáwíꞌo uwánkaiyamba mindá Maníkó ímba maitiyuwáínana waéꞌwaeꞌa íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ísuntafesa sésa sáwí-amutanko wenarumpimbá méraiyemo suntáféna Ísu minááí simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Minááí simátimuwasa Ísun-anówawe Ísun-áfárawaisaiye tésa máápaꞌa tamésa sésa Ísuntafesa tiyó kosimáméro suwasá ");
INSERT INTO auy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","naaúmpaꞌo méron-kwaasi sésa enanówe enáfárawaisaiye máápaꞌa tamésa wéaantaawe suwaná ");
INSERT INTO auy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ísu séna kesinó nááwaꞌiyo. Kesífárawaisai nááwiyaꞌo séna ");
INSERT INTO auy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","naaúmpaꞌo méron-kwaasi tuwánéna séna kesinó kesífárawaawi méraawe. ");
INSERT INTO auy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maníkómó sintembó owí kesinówe kesúnafaraawinen-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Anekaꞌá Ísu Káríri-nonkwaaunkoni áwáífaꞌa koména aaí wésimatimuwasa sáwífaꞌnanka tóso ésa ewaaꞌá tamérontafena nompín-táómpimba íyátena mérowana nompín-táómba waaún-afoforaꞌa wérowasa minkwáásísómbá nonkwaaúnkóní áwáífaꞌa mérowana ");
INSERT INTO auy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","fíꞌo-fiꞌon-aai waéꞌmai simátimena séna ");
INSERT INTO auy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ísáaro. Moóráwigo ánáuntumba maimaéna kísaufaꞌa wéwena ");
INSERT INTO auy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","mátuꞌmaraisana tuwímbai-anauntumba aampaꞌá kunkwéraisana numagó fáíꞌnasukaiye. ");
INSERT INTO auy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tuwímbai-anauntumba óntankwaraꞌ-marafimba kunkwéna paákáꞌ-máráfímbá éna minúwóíyáán-úmai óraaꞌa isaná ");
INSERT INTO auy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","aaꞌá kaisaná ánúꞌa ayáátáákaꞌa ímba kunkéna aáénkaguraiye. ");
INSERT INTO auy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tuwímbai-anauntumba karaampaꞌá kunkwéna kárúraisana karaan-tantáákó fandundupásúwáísana ímba arambá wéiyaiye. ");
INSERT INTO auy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tuwímbai-anauntumba kaweꞌ-máráfímbá kunkwéna kárúrena óraaꞌa éna arambá imái sáwífaꞌ-aramba iyéna tuwímbai íyáákamai-aramba íyáísana tuwímbai imaimái-aramba wéiyaiye. ");
INSERT INTO auy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ísáán-kwaasi ísámai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ísu súwasa ánaaemba wení kísau-waasiye tuwímbai-waasiye mésa Ísuntafesa sésa minkwáéꞌmáí-ááígóní áwáuma sinatá ísáano suwaná ");
INSERT INTO auy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ísu séna Maníkó wení waásimo kawáánin-aaigoni áwáumo wésimatimunda Maníkó kembiwí imáyáa tímísaꞌa wéisaafo fíꞌon-kwaasi waéꞌmai-aai aantemba wésimatimumpo ");
INSERT INTO auy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ísáámbanifo ímba ísámai kaweꞌá wéowe. Awánaambanifo ímba awánamai kaweꞌá wéowe. Isékaa Maníkómpáꞌá tewaná Maníkó miwítí sáwí-imayaa maitiyúwáísino. Mindásafeꞌa waéꞌmai-aai simátimune Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ísu simátimena séna maankwáéꞌmáí-ááímó simátimunda ímba ísáafo fíꞌo-fiꞌon-kwaemai-aaimo sendá ímba isánááwe. ");
INSERT INTO auy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Minááígóní áwáumo sendá ísáaro. Moóráwigomo ánáuntumbo tuꞌmáráínten-úmai Maníkón-aai simátímísana ");
INSERT INTO auy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tuwímbai-anauntumbo aampaꞌó kúmímba waási tirumpintá kúmísasa Maníkón-aai ísááwana waántáwanko téna tirumpinkémbá maimái úwoifaꞌa wétiyuwaiye. ");
INSERT INTO auy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tuwímbai-anauntumbo óntankwaraꞌ-marafimbo kúmímba waási tirumpintá kúmísasa minúwóíyáámbá Maníkón-aai isésa aamoí ombánifo ");
INSERT INTO auy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ímba tirumpimbá taꞌótoꞌmai kaweꞌá owasá Maníkón-aaisafesa umbai-taiyé sésa Maníkón-aai ifáꞌá wétuwaawe. ");
INSERT INTO auy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tuwímbai-anauntumbo karaampaꞌó kúmímba waási tirumpintá kúmísasa Maníkón-aai ísáámbanifo ");
INSERT INTO auy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","marapáꞌ-úmbáí-tántáátáfésa imáyáa úmae nésa ónta-imayaa úmae wénesa fíꞌo-fiꞌon-tantaaꞌa maénae símae nésa miyán-ímáyáágó Maníkón-aai faráátasuwaisasa ímba Maníkóní kísau wémaewe. ");
INSERT INTO auy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tuwímbai-anauntumbo kaweꞌ-máráfímbó kúmímba waási tirumpimbá kúmísasa Maníkón-aai isésa tirumpimbá taꞌótoꞌmai kaweꞌá ésa fasiꞌámai mésa Maníkóní kísau maésa wétuwaꞌnai-owasa tuwímbai íyáákamai-kisau maésa wétuwaꞌnai-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ísu simátimena séna ómbó kúraꞌmaraamba ímba aúpáꞌá marésa ímba taare-améndaampaꞌa wémaraafo aforaꞌá mósá wémaraawe. ");
INSERT INTO auy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Miyámó onten-úmai aúpáꞌó wérain-tantaaꞌa seyaafá aforaꞌá paápé ínasa awánánááwe. Kumeupáꞌó wérain-tantaaꞌa aforaꞌá paápé ínasa awánánááwe. ");
INSERT INTO auy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ísáán-kwaasi ísámai kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tíménten-úmai Maníkó miyáumai tiména anekaꞌá timíníye. Mindásafeꞌa ísáán-aai imáyáa úmai kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Maníkón-aai ísámaimo kaweꞌó owí Maníkó túwaꞌnai ínasa moórá-aaiwaraꞌa isánááwe. Maníkón-aai ímbo ísámai kaweꞌó owí tirumpinkémbá maimaínana ímba wéíniye. Mindásafeꞌa ísáán-aai imáyáa úmai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ísu simátimena séna Maníkó wení waásimo kawáánin-aai maarán-iye. Moóráwigo ánáuntumba tuꞌmaréna ");
INSERT INTO auy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ímbo áwaꞌnai imbá waéna siyaréna wéisana ánáuntunko weyááríkaꞌa wéanon-iye. ");
INSERT INTO auy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Maragó ánáuntunkomba áwaꞌnai isaná áruma wíkéna óraaꞌa éna arambá iyéna ");
INSERT INTO auy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","áfuma kaisaná fákáꞌnaiyan-kanaa tisasá fákáꞌmai wénaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ísu séna Maníkó wení waásimo kawáánimba nóinkara kawááníyómpo maarán-ááí simátíménaꞌa ísáaro. ");
INSERT INTO auy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maníkó wení waásimo kawáánimba maarán-iye. Kári-taerankon-awiꞌa másítáti mintáígón-aramba ímbo aneꞌó awánaraan-taeramba marafímbá uꞌmakáawana mimpínkémbá wíkéna ");
INSERT INTO auy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","óraaꞌa éna óraaꞌ-amaima mófarena wété uráisana numagó mimpímpáꞌá ánáamba úmarena wémaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Ísu waásisomba aaí simátimenae sénamo úmba ímba aforá siyáifo waéꞌmai-aai aantemba simátimuwasa tuwímbai súntemba móisasuwowana mináyáíyákémbá simátimuwasa móisowana miyáumai simátimena énifo wení kísau-waasi weséꞌo méronkaꞌa minááígóní áwáu simátímaꞌmaena iyáiye. ");
INSERT INTO auy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Minkánáá fenómpinka Ísu wení waásisafena séna nonkwaaúnkóní menáípátá kónae súwasa ");
INSERT INTO auy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","fíꞌon-kwaasi tiyuwésa Ísumba áíꞌmaesa nompín-táómpimba íyáte kuwasá tuwímbai-nompin-taonkwaraꞌo kumbá ");
INSERT INTO auy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Ísu mintáónkoni ayáífáꞌá aún-kwaigurówana óraa-fiyunda torówana nonkó tufántááfan-éna nompín-táómpimba ówitowasa kúwáfekunafo sésa inkaisésa Ísumba koaúsésa sésa óraakoo ken-ímáyáá ímba inatá puwúnafosa súwaꞌnai uwo suwaná ");
INSERT INTO auy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","íyáfasinena fiyúndágonte nonkóntétafena óraakaꞌa séna mafáékaiyo súwasarai fiyúndágoe nonkóe mafáúyana nonkó karáꞌnáguwana ");
INSERT INTO auy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ísu simátimena séna nóintafera wéinkaisoo. Kentáfé nóra séra ímba timankúnkúmba wéoo súwana ");
INSERT INTO auy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tááꞌa úwasa keáímbá sésa nóran-kwaasiya isanawá fiyúndágoe nonkóeꞌa wenáái isaíyó sésa tiyáámba ufakésa táátafesa ésa siyáawe. ");
INSERT INTO auy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Simásuwesa mindómpín-táómpimbo kumbá Káríri-marama tínaaempa wérowana Kégésaa-marama túrampaꞌa wérowasa mimbáráfáꞌó kumbá ");
INSERT INTO auy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","4","Ísu mindómpín-táómpinkemba mimbáráfáꞌá kumúwana moóráwigo sáwí-amutamba arumpimbó méron-kwaasigo utátínkón-ontan-aifaꞌo maúmpakemba Ísumpaꞌa tiyái. Minkwáásí káráꞌumarontemba taraꞌnaaraꞌó úwaima éna ímba waási mésa ímba káráꞌumakowana ");
INSERT INTO auy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","wááwáiye nóꞌwaane omápaꞌo utátínkón-ontan-aifaꞌa wénena wááꞌa wétena óntantamba wenáúma wékambisena ");
INSERT INTO auy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","nénkakemba Ísumba awánéna awaantanténa Ísun-amándáraꞌa taména wen-ímáyáá éna áwíꞌa mósá marówana Ísu minkwáásígó arumpinké-sáwí-ámútánkóntáféna séna emá sáwí-amutamba ómpo minkwáásígómbá auwé kóuwo súwana óraaka séna Ísuwo íyáákamai-Fasiꞌaenkon-ááninko ómpo Maníkóntáfé ísámai sínkamonafainifo nóra uwásinkainono súwana ");
INSERT INTO auy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ísu séna enáwíꞌa nááwaꞌono súwana séna sáwífaꞌa méraumpo kesúwíꞌa sáwífakoma úne séna mérowasa ");
INSERT INTO auy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","13","omápaꞌa sáwífa-poima mésa umá wénowasa minkwáásígó arumpinké-sáwí-ámútántómbá Ísuntafesa óraaka sésa fíꞌopaꞌa ímba siꞌmaraaó. Mimpóí tirumpintá siꞌmaraaó suwaná miyán-oro súwasa sáwí-amutantomba minkwáásígón-arumpinkemba kárúwesa póí-tirumpimba koférówasa mimpóísómbá seyaafáꞌá ámémpakemba tuwaantantésa nonkwaaúmpíntáámó kúwáférómba putásowasa ");
INSERT INTO auy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","póíyaꞌo tafíkówi miyámó úmba awánésa minúwóíyáámbá naaópaꞌa wésa kísaufimpaꞌo méron-kwaasi mósimatim-besimati uwasá isésa koawánánae sésamo kumbá ");
INSERT INTO auy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ísumpaꞌa kotúwaandu ésa awánomba sáwí-amutantombo arumpinkémbó kóun-kwaasigo unáánkwátói úmarena kaweꞌ-úmai mérowasa koawánésa tááteꞌa úwasa ");
INSERT INTO auy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ísu minkwáásígómbó kaweꞌó uwánkowasamo awánon-aaiye póígomo ún-aaiye simátímúwasa ");
INSERT INTO auy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","isésa Ísuntafesa sésa maambáráfáꞌá ifá siyuwésa kóuwo suwaná ");
INSERT INTO auy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","nompín-táómpimba íyátowana sáwí-amutambo maiyauwón-kwaasigo Ísuntafena óraakaꞌa séna eséꞌa kónae súwana ");
INSERT INTO auy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ímbanifo ení naaópaꞌa kuré Fasiꞌaénkómó arumbá uwánkenamo kaweꞌó uwánkáín-aai enamááraasomba kosimátimiyo súwana ");
INSERT INTO auy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tékáporisi-aempaꞌa mindáópata Ísumo uwánkon-aai simátímaꞌmae kúwasa seyaafáꞌ-wáásí sáwífaꞌ-imayaa uráawe. ");
INSERT INTO auy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ísu Káríri-waaunkoni menáípákémbá nompín-táómpimba kouweréna túmba aneká waaúnkón-áwáífaꞌa mérowasa sáwífaꞌ-waasi túwaandu uwaná ");
INSERT INTO auy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","moóráwigo ámáán-dankaꞌo káráwiyowin-awiꞌa Yáírási téna Ísumba taawánéna Ísu óraakon-iye séna aísamaifimba kífaena ");
INSERT INTO auy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","óraaka séna kesiyáámúmba puwíndasafena wéifo tiyéma aneꞌá kotaꞌótorenana asóféna kaweꞌ-úmai méraino súwana ");
INSERT INTO auy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ísu weséꞌo kúmba sáwífaꞌ-waasi Ísumba úkúresa arááíwaꞌmae kuwaná ");
INSERT INTO auy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","moórá-ininkomba áíꞌo ún-ininkowaraꞌa arááíwaꞌmae kúmba wembá naaeyámba ankówana sísamaifakemba kaeꞌá kumbaimái-aatai maisuwéna mináíꞌá ímba éꞌankowasa ");
INSERT INTO auy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","sáwífaꞌ-ika tíyofaan-kwaasi áwaꞌnai uwaná óntamba tímaꞌmai taíꞌásuwowana mináíꞌá ímbo éꞌankomba óraaꞌ-aiꞌa uwágúwana ");
INSERT INTO auy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","minínínkó Ísumo kaweꞌó uwátínkaron-aai iséna séna Ísuni unáánkwátóiyaꞌa kotaꞌótóráánana síꞌa ésinkainiye séna sáwífaꞌ-waasimo arááíwaꞌmae kumpímbá minínínkó maréna ánaaempakemba unáánkwátóiyaꞌa taꞌótorowana ");
INSERT INTO auy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","mindááéyánko éꞌankowana asófasinkaiye-imayaa úwana ");
INSERT INTO auy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ísu imáyáa éna séna kempínké-fásíꞌáénkó moóráwigomba kaweꞌá uwánkáíye séna waéꞌmai tuwánéna séna nááwawa kesí unáánkwátóiyaꞌa taꞌótóráínaꞌiyo súwasa ");
INSERT INTO auy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","wení kísau-waasi Ísumba simámesa sésa úwé sáwífaꞌ-waasimo faméꞌmae íyómpimba taꞌótokaafo nááwawa kesí unáánkwátóiyaꞌa taꞌótóráínaꞌiyo nóra séwa wéseno suwaná ");
INSERT INTO auy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","taꞌótorowintafena móawana-meawana úwana ");
INSERT INTO auy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","minínínkó asófasinkaiye-imayaa úwana anekembá tataꞌá úwana Ísun-aísamaifimba kífaena asófankon-aai simámuwana ");
INSERT INTO auy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ísu séna kesímánaako kentáfé sé éraiꞌa súwaꞌnai índawin-iye sénda póna áíꞌa éꞌánkáífo kaweꞌ-úmai waaó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ísu minááí wésuwasa ámáán-dankaꞌo káráwiyowini naaópaken-kwaasi tésa Yáírásintafesa sésa enayáámúnko pukáifo óraakontafe ténafo siyó suwaná ");
INSERT INTO auy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ísu minááí iséna ifátuwena Yáírásintafena séna minááísáfé ímba áákauraumo indá kentáfé amankúnkúmba uwo séna ");
INSERT INTO auy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","arááíwaꞌmae kun-kwáásísóntáféna maankáꞌ-méraaro séna Pítaane Yémísine wenáfákon-awiꞌa Yónine tíꞌmaena kúmba ");
INSERT INTO auy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","sáwífaꞌ-waasi ámáán-dankaꞌo káráwiyowini naaúmpaꞌa túwaandu urésa óraaꞌ-ifiꞌa wétowana Ísu iséna ");
INSERT INTO auy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","naaúmpaꞌa íyáferena séna ímba ifiꞌá taaró. Minárásígó ímba pukáifo úwoi aúmá wéraiye súwasa ");
INSERT INTO auy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ísun-awíyáái uwaná tiꞌmátuwowasa máápaꞌa kúwákárúwowana minárásígón-anófoiye wení kísau-waasiyauwe tíꞌmaena minárásígó pukópaꞌa iyéna ");
INSERT INTO auy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ayáánkaꞌa taꞌótorena wenááifinkemba simámena séna tarita kumi miyámó súmba waéꞌmai séna inaamarúgóo íyáfasinaao súwana ");
INSERT INTO auy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","íyáfasinkwena sífákémba kaeꞌá kumbaimái-aataimo maisukáin-inaamaru íyáfasinowasa awánésa táátafesa uwaná ");
INSERT INTO auy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ísu óraaka séna kemó únda-aai ímba simátíméro séna minárásígómbá tómbá áméro siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Minkákémbá Ísu wenamáápaꞌa wéena wení kísau-waasiseꞌo kúmba ");
INSERT INTO auy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yúndaa-waasi ámáán-aaimo ísón-kanaaraꞌa ámáán-daumpaꞌa iyéna aaí simátimuwasa sáwífaꞌ-waasi isésa táátafesa ésa sésa nááfakena kaweꞌ-ímáyáá maiyénawa kaweꞌ-ááí wésimasimenasaawa nááwawa fasiꞌaémbá ámísanawa kawe-kísáú ímbo awánáúnda-kisau wémaiyo. ");
INSERT INTO auy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wentáámó awánáúnda wení kísau taaisambó tuwímbai-tantaaꞌo wéiwain-iye. Máríyaan-ááninko éna Yémísiye Yósisiye Yúndasiye Sáímoni-iyai tuwaaón-iye. Wenáúnafaraawimba maankáꞌá méraawe. Maankákéwí éna úwoi-waasin-ifo nááfakena minááí isénawa mifásíꞌáémbá maiyénawa wésiyo sésa kaorésa tínaaemba uwámúwana ");
INSERT INTO auy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ísu simátimena séna Maníkón-aaimo simátímíwai fíꞌo-fiꞌon-daopaꞌa wénisasa wenáwíꞌa mósá wémaraafo wení naaópaꞌo koméraimba wenamááraa sésa kesáámó úndanten-kwaasin-iye sésa wenáwíꞌa ímba mósá makáawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kesáámó úndanten-kwaasi éna ímba súwaꞌnai íníyemo suntáféna ímbo awánon-kisau moórá-mora-kisau aantemba maiyáiye. Moórá-mora tíꞌo ún-kwaasi tineꞌá ayáántamba taꞌótorena asófatinkena ");
INSERT INTO auy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","wenamáápaken-kwaasi sésa ínta súwaꞌnai íníye sun-ááísáféna imáyáa uwááena naaóꞌ-naoꞌa Maníkón-aai simátímapaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ísu wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi táántowasa tuwaná waási tirumpinkémbá sáwí-amutamba maitíyuꞌmae nóro-fasiꞌaemba tiména séna kaesá uwásuweꞌa nóro séna ");
INSERT INTO auy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","óraaka simátimena séna aampaꞌó wíyamba ímba moórá-tantaaꞌa maimaéꞌa koró. Tómbá ímba maimaé wéꞌa tón-únámbá ímba maimaé wéꞌa óntamba ímba maimaéꞌa koró. Táúmba faimaéꞌa ");
INSERT INTO auy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","tísamai ánáamba wimaéꞌa moórá-mora unáánkwátói timantentén-úmai kuféꞌmaeꞌa koró. ");
INSERT INTO auy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maníkón-aaimo simátimiyantafe moórá-naopaꞌo wíyasamo naambó timíyaꞌa mindáúmpáꞌ-aantemba méꞌa kentí kísau maimái taiꞌéꞌa mindámbá tuwéꞌa fíꞌon-daopaꞌa koró. ");
INSERT INTO auy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Moórá-naopaꞌo wíyambo naambá ímbo timésamo kentáái ímbo isáíyanamo éna Maníkó mindáópaken-kwaasi ímba aamoí uwátinkainifo aiyowáíꞌa éꞌa tísamaifakem-baramo uwáéntemba uwáꞌmare koró Ísu simátimuwasa ");
INSERT INTO auy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","wení kísau-waasi isésa naaóꞌ-naoꞌa wénesa kosimátimesa sésa sáwí-imayaa tínaaemba uwámeꞌa Maníkómpá teró sésa ");
INSERT INTO auy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","sáwí-amutantomba waási tirumpinkémbá komaitiyuwésa tíꞌo ún-kwaasi taaéraampinken-domba atínkáfaꞌa kuwasá asófaraawe. ");
INSERT INTO auy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ísuni kísaugon-aai símae íyúwana Káríri-marafaken-kawaagon-awiꞌa Éroti minááí ísaraiye. Ísuntafesa tuwímbai sésa Yóni nombó maitínkaraiwai pukáimpinkemba íyáfasinkena póna wempímbá fasiꞌaémbá wéraisana miyán-kísáú wémaiye suwasá ");
INSERT INTO auy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","tuwímbai sésa wemá Maníkón-aaimo simátímakowin-awiꞌa Íráiyaa pukáimpinkemba íyáfasinena méraiye suwasá tuwímbai sésa wemá naaófáꞌá Maníkón-aaimo simátímakowiyaamba méraiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Éroti iséna séna wemá Yóni nombó maitínkaraiwain-iye. Kemó séwánasamo Yónin-anuwarambó kambísówanamo pukáimba íyáfasinankaraisana méraiye Éroti siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ááéma Éroti wenáfákon-awaaininkon-awiꞌa Érótíyasimba maiyówana Yóni séna enáfákon-awaainimba aambá fáíꞌmakaawa maiyáane símasimaꞌa wéuwana Éroti tiꞌmarówasa Yónimba koáíꞌmaesa ándáfaꞌa máánkarowana Érótíyasi Yónin-aaisafena aaisambá séna tufuwónae súwana ");
INSERT INTO auy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Éroti séna ímbaniye séna Yóni kaweꞌ-ímáyááwáráꞌ-wáásí úntafena Éroti wenáároi inkaiséna wenkáꞌá káráwiyena Érótíyasi tufífo séna wenkáꞌá káráwiyena wenáái iséna sáwífaꞌ-imayaa uwánkena aasiyaasí koísaraiye. ");
INSERT INTO auy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Énifo ánaaemba Érótíyasini kanaamó túmba Éroti óraa-tanomba kaumái wení kawáá-wáásíyé i-wáásíyé Káríri-aempaken-oraaꞌ-waasiye tímúwasa nowaná ");
INSERT INTO auy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Érótíyasin-ayaamunko téna araimá marówasa Érotiye tómbó non-kwáásíyé aamoí uwánkówana Éroti minárásígóntáféna séna nóin-tantaatafenawa aráái taiyó. Simásímína áméno. ");
INSERT INTO auy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Éraiꞌa súmpo sísai inaꞌá áméno. Kesí maragó aráái táínamo e sísai inaꞌá tuwín-ameno súwana ");
INSERT INTO auy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","anówamba koáísai ena séna nóin-tantaara komaénaumno súwana séna Yóni nombó maitínkaraiwaini aꞌnómbá koáísai e mauwó súwana ");
INSERT INTO auy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","minúwóíyáámbá Érotimpaꞌa téna taáísai ena séna káféꞌa Yóni nombó maitínkaraiwai anuwarambá kambísámai aꞌnómbá táúfapimba maꞌmái simiyó súwana ");
INSERT INTO auy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","iséna arumbá úmbanifo aifaꞌá fasiꞌaén-ááímó siyáin-aai imáyáa éna tómbó non-kwáásíwáráꞌá ísaraantafenawe séna ímba aꞌáo sénae séna ");
INSERT INTO auy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","moórá-i-waasi aiꞌmarówana ándáfakemba Yónin-anuwarambá kambísámai aꞌnómbá ");
INSERT INTO auy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","táúfapimba maréna maimaéna minárásígómbá máamuwana maimaéna anówamba máamuwasa ");
INSERT INTO auy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yónini kísau-waasi isésa wenáúma komaimái utaráawe. Ánaaemba Éroti Ísuni kísaugon-aai iséna séna minkwáásí Yóni nombó maitínkaraiwai éna pukáimpinkemba íyáfasinankaisana méraiye Éroti siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ísu kísauraꞌo tiꞌmákain-kwaasi minkísáú maisuwésa Ísumpaꞌa tésa seyaafá-kísáúmó máún-aaiye aaimó sun-ááíyé simámúwasa ");
INSERT INTO auy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ísumpaꞌa sáwífaꞌ-waasi kuré-tiyesa untáfésa tómbá ímba kaweꞌ-úmai nowaná mindásafena wení kísau-waasisafena séna waásimo ímbo mérepata kométa saagaanó súwasa ");
INSERT INTO auy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","nompín-táómpimba íyátesa waási ímbo mérepataawe sésa kuwasá ");
INSERT INTO auy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","sáwífaꞌ-waasi tuwánésa embí miwín-owe sésa naaóꞌ-naokembo marapáꞌá tóso uwasá Ísu-iyai nompín-táómpimbo kumbá ");
INSERT INTO auy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","marapáꞌá kuména misáwífáꞌ-wáásí tuwánéna arumbá uwátinkena sipisípi-poimo miwímó káráyiyon-kwaasi ímba mérowasa keyáá aantemba mérontafena Ísu arumbá uwátinkena ayáátááꞌ-aai wésimatimuwasa ");
INSERT INTO auy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","fenómpinkaꞌa wení kísau-waasi wempáꞌá tésa sésa ímbo sáwífaꞌ-waasi méraapaꞌan-ifo fenáíndara ");
INSERT INTO auy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","tiꞌmárénasa ewaaꞌ-náópimpaꞌa wénesa tómbá méyámbáráaro suwaná ");
INSERT INTO auy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ísu simátimena séna kemá tómbá tíméro súwasa sáwífaꞌ-ontankakemba 200 kinaaraken-tomba méyámbaꞌmaisa timúsina. Óntamba ímba wéraiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","nóraumai-tona makáawai koawánaaro súwasa koawáné tésa sésa kári-tomba séfataase-tonkwara kaeꞌ-mófááꞌwáráꞌá wéraiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ísu wení kísau-waasisafena séna unkwimaꞌmái maraꞌá méraaro súwasa ");
INSERT INTO auy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","moóráfaꞌa 50 waasi máúwasa moóráfaꞌa 100 waasi máúwasa miyáumai-waasi túwaandu urówana ");
INSERT INTO auy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ísu séfataase-tonkwara kaeꞌ-mófááꞌwáráꞌá maisoréna wíyómpaꞌa kararéna Maníkóntáféna súwiyo simásuwena mintómbá tafántafan-úmai wení kísau-waasi timúwasa misáwífáꞌ-wáásí tímúwasa mófááꞌa tafántafan-úmai timúwasa misáwífáꞌ-wáásí tímúwasa ");
INSERT INTO auy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","seyaafáꞌnánká nowaná tímúꞌa fówasa sáwífaꞌa 5,000 waasi nowaná tímúꞌa fówasa wení kísau-waasi mintón-ayai sísamaifakemba kaeꞌá kumbaimái-unampimba fáítuwana ówitaraiye. ");
INSERT INTO auy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Fáítuwana ówitowana minkákémbá Ísu wení kísau-waasi tiꞌmaréna séna aifaꞌá nompín-táómpimba íyáteꞌa menáípáꞌ-náópaꞌa Pétésáítafa koró. Misáwífáꞌ-wáásí tiꞌmaré séꞌa kentí naaóꞌ-naoꞌa koró simátimenaumne séna ");
INSERT INTO auy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","misáwífáꞌ-wáásí tiꞌmarówasa miwítí naaóꞌ-naoꞌa kuwaná Maníkómpáꞌó inaimó síndasafena omápaꞌa imérowana ");
INSERT INTO auy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","nóꞌwaamba túnkúwana Ísu weyáá marapáꞌá mérowasa wení kísau-waasi nompín-táómpimba non-afufumpá mérowana maramá nénkaꞌa wérowana ");
INSERT INTO auy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ísu awánómba óraa-fiyunda toꞌmaé téna mintáómba tataꞌótoꞌmarowasa nombó tuwíntámae kun-táámbá nonkó maimaúwasa ímbo kumbá siyarónkaꞌa Ísu non-afóforaꞌa maréna wení kísau-waasimo méronkaꞌa táyáákaguwasa ");
INSERT INTO auy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","awánésa táátafesa ésa tinekembá tataꞌá uwasá sésa waántágo wéniye suwaná Ísu minúwóíyáán-úmai séna tááꞌa ifó aánoꞌa méraaro. Kemá úne séna ");
INSERT INTO auy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","nompín-táómpimba íyátena wewáráꞌá imérowana óraa-fiyundago mafaúwasa áfááraumai táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kári-tombo sáwífaꞌ-waasimo tafámbai timúwasamo nowíní áwáu ímba mindásafesa imáyáa unkákémbá táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Táátafesa áfááraumai ésa waaúnkóní menáípáꞌá Kénésáréti-marafaꞌo kumbá nonáwáífaꞌa nompín-táómba ándá káráꞌumaresa ");
INSERT INTO auy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","marapátá kúmúwasa mimpápákén-kwáásí Ísumba awíyésa Ísun-iye sésa ");
INSERT INTO auy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","naaóꞌ-naoꞌa simátimesa Ísumo tamaún-aai isésa tíꞌo ún-kwaasi taareráꞌá taawiyaꞌmaé tóso uwaná ");
INSERT INTO auy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ísu káriꞌ-naoꞌe óraaꞌ-naoꞌe wénuwasa tíꞌo úwai tíꞌmai marupáꞌá marésa sésa ení unáánkwátói áráíyaꞌa taꞌótoraiyana tíꞌa étinkainkwae suwasá taꞌótórówana tíꞌa étínkaraiye. ");
INSERT INTO auy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé Yérúsaremu-naopakemba Ísumo méropaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","tuwánomba Ísuni kísau-waasi tuwímbai tiyáámba ímba non-kwisuwésa tómbá nowasá ");
INSERT INTO auy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yúndaa-waasi ámáán-kawaa-waasiye úwoi-waasiye tíwáꞌnáti ámáámbo arááíwáúntafesa tiyáámba non-kwisukésa tómbá nésa ");
INSERT INTO auy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","maaketifákémbá naaópaꞌa iyésa tiyáámba non-kwisukésa tómbá nésa tíwáꞌnáti ámáámba fíꞌo-fiꞌon-amaamba arááíwaesa táúfaꞌe nonánáwé anaféúné non-kwiyáawe. ");
INSERT INTO auy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé Ísumpaꞌa túwaandu ésa sésa ení kísau-waasi nóra sésawa kentáá síwáꞌnáti ámáámba ímba arááíwaesawa tiyáámba ímbo non-kwíyómba tómbá wénaao suwaná ");
INSERT INTO auy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ísu séna kaumbo-kaeꞌ-ááíwáráꞌ-wáásín-owe. Naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Áísáya kembiwísáféna éraiꞌ-aai agaimaréna séna Maníkó séna maawí kesúwíꞌa tóikaken-aantemba sésa ken-ímáyáá ímba tirumpimbá wéraiye. ");
INSERT INTO auy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Waásiti ámáámba símai paápé ombánifo Maníkóní ámáámban-iye karoꞌó sembá miyáráán-úmai ken-ímáyáá karoꞌ-ímáyáá mósá wémaraawe Maníkómó siyáimba aúfáífimba agaimakáiye. ");
INSERT INTO auy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Maníkóní ámáámba tuwéꞌa tíwáꞌnáti ámáámba wétoraawe. ");
INSERT INTO auy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Maníkón-aai túwáántafeꞌa miwán-ánóndáá kentááisafeꞌa aamoí wéowe. ");
INSERT INTO auy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Naaófáꞌá Mósese séna kentinófoi-tuwiꞌa óraaꞌan-oro. Énifo tinófoimo sáwíkaambo simátinkaindawimba tufuwíyana puwíníye Mósese siyáifo ");
INSERT INTO auy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","kembiwímó siyáamba tinófoisafesa simátimesa sésa moórá-tantaaꞌa Maníkóndén-ifo ímba kanaaꞌá timénaumne siyésa ");
INSERT INTO auy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tinófoi ímba wétuwaꞌnai-owe. Miyámó ontáféꞌa kanaán-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Miyá-sáwíꞌó ontáféꞌa Maníkón-aai tuwéꞌa kentíwáꞌnáti ámáámba wéaraaiwaeꞌa kentáái wésimatimewe. Miyáráámbá wéowe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ísu minááí simátimena waásisafena teró súwasa wempáꞌá tuwaná séna simátíménda iséꞌa kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Máápaken-tantaaꞌo naawí ímba waási sáwíꞌa wéuwatinkaifo tirumpinkén-ááígó aantemba waási sáwíꞌa wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ísáán-kwaasi ísámai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ísu simásuwena minkwáásísómbá tiyuwéna naaúmpaꞌa imérowasa wení kísau-waasi sésa minááígóní áwáusa simásimiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ísu séna kenkwáráꞌá ímba tááko péé wésisaꞌa ísáámbanifo ímba ísámai kaweꞌá uráawe. Máápaken-tantaaꞌo naawí waási ímba sáwíꞌa wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mindá ímba imáyáa kuwérainifo tindáámpáꞌá kúwátúsúwinifo ");
INSERT INTO auy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aaimó wésemba tirumpinkén-ímáyáágó éna mindá waási sáwíꞌa wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tirumpin-ímáyááfínkémbá sáwí-imayaa ésa tínkamiyasa puwíyasamo ésa aare-úméné waai-úméné ésa seyaafá-tántááꞌá umémbá ésa ");
INSERT INTO auy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","túraniyamba ésa miyá-miya- sawiꞌa ésa karoꞌ-ááí sésa aoisaambá wimaé nésa kawe-kísáúmó máéntafesa tirunkó símai sáwíꞌa wéuwatinkesa tuwesarai-íꞌa ésa uwó-ímáyáá ésa ");
INSERT INTO auy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","miyá-sáwíꞌó ombá tirumpinkén-ímáyáágó waási sáwíꞌa wéuwatinkaifo tiyáámbo ímbo non-kwíyómbo tómbó wénaamba miwá waási ímba sáwíꞌa wéuwatinkaiye Ísu siyáiye. Énifo Ísu wemó siyáimba seyaafá-tómbá kaweꞌ-úmai wénaawe siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ísu minááí simátimena wení kísau-waasiseꞌa mifáꞌá tuwéna Táyaa-naopaꞌe Sáíndóni-naopaꞌe mináémpáꞌó kúmba moórá-naumpaꞌa iména séna kemó tamaúnda ímba simátíméro súwasa énifo tuwímbai-waasi tamaún-aai ísówana ");
INSERT INTO auy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","moórá-ininkon-ayáámúnko arumpimbá sáwí-amutamba mérowana minínínkó Ísumo tamaún-aai iséna minúwóíyáán-úmai wempáꞌá iyéna maraꞌá kífaena ");
INSERT INTO auy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","wemá ímba Yúndaa-inimba póna Síriyaa-marafaꞌa Fínísiyaa-naopaken-ininko Ísumpaꞌa iyéna maraꞌá kífaena óraaka séna kesiyáámúnkon-arumpinkemba sáwí-amutamba maiyauwaaó súwana ");
INSERT INTO auy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ísu simámena séna aifaꞌá iyámpói tómbá timénaumne. Iyámpóíti tómbá maimái iyámbá timúnafo miyáumai Ísareri-waasimo túwaꞌnai úndantemba emá fíꞌonkaa-inimba ónda póꞌa áwaꞌnai únafo súne súwana ");
INSERT INTO auy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","minínínkó séna óraako éraiꞌa sémpo iyámpóíti tón-ayai iyánkó tamandáíníye. Miyáumai fíꞌonkaa-ininkon-iye sinaná kanaán-ína súwaꞌnai ínono súwana ");
INSERT INTO auy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ísu séna kaweꞌ-ááímó séndasafeꞌa enayáámúnkon-arumpinkemba sáwí-amutamba maiyauwáúmpo ení naaópaꞌa waaó súwana ");
INSERT INTO auy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","wení naaópaꞌa wénamo koawánómba sáwí-amutamba kóúrowana ayáámúnko kaweꞌ-úmai taareráꞌá méraiye. ");
INSERT INTO auy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ísu Táyaa-naopaꞌ-aempakemba Sáíndóni-naopaꞌ-aempaꞌa táyáákena Tékáporisi-aempaꞌa táyáákena Káríri-nonkwaaumpaꞌo kúmba ");
INSERT INTO auy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tuwímbai uwó-wáásígómbá áíꞌmae tésa sésa enayáántamba taꞌótoꞌmai asófankaao suwaná ");
INSERT INTO auy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","waásifinkemba áíꞌmai weyááfaꞌa ankéna ayáánaufitamba áápimba wimaréna awiyáái wiꞌmaréna anááfíyaꞌa taꞌótorena ");
INSERT INTO auy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","wíyómpaꞌa awánéna sirumbá iyé séna wenááifinkemba séna epaata minááí waéꞌmai séna ááꞌo káúnkaimba intísuwaumne súwana ");
INSERT INTO auy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ááko kaweꞌá úwana anááfígo fetóí úwana aaí kaweꞌ-úmai súwana ");
INSERT INTO auy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ísu óraaka séna ímba simátíméro súwasa ímbo ísónkakemba simátímapaꞌa kuwasá ");
INSERT INTO auy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ísówana áfááraumai tááꞌa úwasa sésa seyaafá-tántááꞌá kaweꞌá úmai wéiyena tááꞌo káúnkain-kwaasi kaweꞌá wéuwatinkena aaimó ímbo kaweꞌ-úmaimo sen-kwáásí kaweꞌá wéuwatinkaiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Moórá-kanaa sáwífaꞌ-waasi túwaandu uwaná miwítí tómbá taiꞌówana Ísu wení kísau-waasi táántowasa tuwaná ");
INSERT INTO auy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","séna kaumbo-kánáá keséꞌa taméraawana tómbó maimaé tiyáamba taíꞌáísaꞌa sirumbá uwátinkaumne. ");
INSERT INTO auy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tiꞌmáráanasa kentí naaóꞌ-naoꞌa kónááfo némpaken-kwaasi aampaꞌó wíyamba tááimo táínkaꞌa pósa púwófainifo súwasa ");
INSERT INTO auy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","wení kísau-waasi sésa máásai-marafaꞌan-ifo nááfakentaawa tómbá maimáísaawa timénaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tísai ena séna nóraumai-tona makáao súwasa afakaeté-tomba makáawe suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","minkwáásísóntáféna séna maraꞌ-méraaro séna afakaeté-tomba maisoréna Maníkóntáféna súwiyo séna tómbá tafántafan-úmai wení kísau-waasi timúwasa minkwáásísómbá tímúwana ");
INSERT INTO auy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","sesimáí-mofaaꞌa wérowana Ísu maisoréna Maníkóntáféna súwiyo séna wení kísau-waasi timúwasa minkwáásísómbá tímúwasa ");
INSERT INTO auy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","nowaná tímúꞌa fówasa sáwífaꞌ-waasi 4,000 waasi nowaná tímúꞌa fówasa wení kísau-waasi mintón-ayaimo túwómba afakaeté-unampimba fáítumai ówitowana ");
INSERT INTO auy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ísu misáwífáꞌ-wáásí tiꞌmaréna wení kísau-waasiseꞌa nompín-táómpimba íyátesa Tárímánúta-aempaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mifáꞌá Ísu mérowasa ámáán-kawaa-waasi sáwí-aaimo sínda isánae sésa Ísumpaꞌa tésa sésa éraira Maníkómpákéná kunkáanai ímbo awánáúnda-kisau máínata awánaano suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ísun-arunko umbaí wétopakemba séna káféꞌo méraan-kwaasi nóra séra ímbo awánáúnda-kisau máínata awánaano wéseo. Éraiꞌa simátime súne. Káféꞌo méraan-kwaasi ímba aráátimenaumne séna ");
INSERT INTO auy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ifátiyuwena nompín-táómpimba íyátena nonkwaaúnkóní menáípáꞌá kuráiye. ");
INSERT INTO auy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ísu wení kísau-waasiseꞌa nonkwaaúnkóní menáípáꞌó kumbá wení waási péréti-tomba ímbo máúmba tuwinkésa kuwaná kímbora-tomba nompín-táómpimba wérowana ");
INSERT INTO auy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ísu ámáán-kawaa-waasiye Érotiye kaumbo-kaeꞌ-ááíwáráꞌ-wáásí owé-ímáyáá éna wení kísau-waasi simátimena séna intóráín-tantaaꞌa kári-tantaaꞌa moórá-tonkon-awiꞌa péréti mimpímbá márááwanamo intoréna óraaꞌo intembá ámáán-kawaa-waasiye Érotiye miwí tááisafeꞌa kentúraꞌa káráwiyoro súwasa ");
INSERT INTO auy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","keáímbá sésa nóra sénawa miyá wésiyo. Péréti-tomba ímba makáunanasa miyá wésiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ísu keáímbó wésun-aai iséna nóra séra tómbá ímba wéraiye-aai wéseo. Kanaaꞌá tómbá timénaumpo ááémo uráundawini áwáuma ímba tááko péé wésiye. Kentí imáyáagowe kentirunkówé faráátaraisaꞌa wéowe. ");
INSERT INTO auy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Túramba wéraimbanifo ímba awánamai kaweꞌá wéowe. Tááꞌa wéraimbanifo ímba ísámai kaweꞌá wéowe. ");
INSERT INTO auy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Séfataase-tombo tafántafan-úmaimo sáwífaꞌa 5,000 waasi timéwánasamo naráamba mintón-ayai nóraumai-unampina fáíturaao séna tísai úwasa sísamaifakemba kaeꞌá kumbaimái-unampinta ówitaraumne suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","afakaeté-tombo tafántafan-úmaimo sáwífaꞌa 4,000 waasi timéwánasamo naráamba mintón-ayai nóraumai-unampina fáíturaao séna tísai úwasa afakaeté-unampinta ówitaraumne suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ísu séna nóra sénawa ímba tááko péé sisaꞌá ísaraao Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ísu simátimena wení kísau-waasiseꞌa Pétésáíta-naopaꞌo kumbá tuwímbai aúrambo kafíkówimba áíꞌmaesa Ísumpaꞌa tésa sésa taꞌótoꞌmai asófankaao suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ísu ayáán-toꞌmaena mindáókoni ayáífáꞌá wéna aúrampimba awiyáái wiꞌankéna aúrankaꞌa taꞌótorena séna éra awánááno súwana ");
INSERT INTO auy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","awánéna séna wéawanaumne. Taaiyaán-kwáásí marapáꞌá wénowaꞌa awánáúmne súwana ");
INSERT INTO auy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","anekaꞌá Ísu aúrankaꞌa taꞌótorena kaweꞌá uwánkowana aúramba kararéna kaweꞌ-úmai awánówana ");
INSERT INTO auy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ísu séna mindáópaꞌa kónafo ení naaópaꞌa tauweré waaó siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ísu simámena wení kísau-waasiseꞌa Sísááríya Fírípái-naoꞌ-aempaꞌo kúmba aampaꞌá wéwena wení waási tísai ena séna kentáfésa seyaafáꞌnánká nóran-kwaasin-iyewa wéseo súwasa ");
INSERT INTO auy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","miwí tuwímbai sésa emá Yóni nombó maitinkáándawi óne sewasá tuwímbai sésa naaófáꞌá Maníkón-aaimo simátímakaandawin-awiꞌa Íráiyaa óne sewasá tuwímbai sésa naaófáꞌá Maníkón-aaimo simátímakaawifinkemba moóráwigo óne wésewe suwaná ");
INSERT INTO auy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ísu séna kembiwí kentáféꞌa nóran-kwaasiyewa wéseo súwana Sáímoni Pítaa séna Maníkó íyáfasinankaraiwai Yúndaa-waasisa wéamuꞌmaraundawisa óne súwana ");
INSERT INTO auy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","minááí ímba simátíméro Ísu óraaka siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ísu wemó puwínda-aai ómbarena wení kísau-waasi simátimena séna síꞌo índa-iꞌa uwásinkesa Yúndaa-oraaꞌ-waasiye óraaꞌ-amaan-kisau-waasiye ámáámbo sen-kwáásíyé tínaaeniꞌa uwásinkesa sínkamiyaꞌo púwóndanifo kaumbo-kánáá taiꞌáínaꞌa púwóndafinkemba íyáfasinanaumne séna ");
INSERT INTO auy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","miyáumai aforaꞌá simátimuwana Pítaa Ísumba áíꞌmaena weyááfaꞌa máankena séna miyán-ááí sénafo súwana ");
INSERT INTO auy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ísu waeréna wení kísau-waasi tuwánéna Pítaantafena óraaka séna waántáwanko siyuwé kóuwo. Waásiti imáyáafinkemba wésempo ímba Maníkóní imáyáafinkemba wésene Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ísu minááí simámena waásisone wení kísau-waasiye táántena séna kembó sirááíwaenae síyawi tirááímo táínda-tantaaꞌa ímba taꞌótóráaro. Kemá púwónda-aaraa-taimo súwaataꞌmae kondantembá kembó sirááíwaiyawi umbai-tántááꞌá timíyasa minúmbáí-tántááꞌá úwoi maimaésa sirááíwaenaawe. ");
INSERT INTO auy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tirááímo táínda-iꞌo ésa ímba kaweꞌ-úmai méranaafo kentáfésa ísámai Maníkóní ásé-aaisafesa ísámai tirááímo táínda-tantaaꞌo tuwésa puwésa aúíꞌa úmai maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mararáké-séyááfá-tántááꞌó maésamo puwíyambo éna mintántáákó ímba túwaꞌnai íníye. ");
INSERT INTO auy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Puwíyamba marapáꞌó makáan-tantaatamba ímba méyámbátuwesa anekaꞌá ayáátááka méranaawe. ");
INSERT INTO auy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Káféꞌa Maníkóntáfésa ímba imáyáa ésa méraankaꞌa kenkwárá kesááiwaraꞌo tigaemó uwásínkáámba póꞌa ánaaemba kemó marapáꞌó kúmónda miwí sigaé uwátinkanaumne. Kemá waási úranko ánaaembo kesifoní sáwara wíyómpakembo Maníkóní kísau-waasiti sáwaraꞌo marapáꞌó kúmónda miwí sigaé uwátinkanaumne. ");
INSERT INTO auy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Éraiꞌa simátime súne. Tuwímbai maankáꞌó méraan-kwaasi ímba aifaꞌá puwéꞌa Maníkó wení fasiꞌaéntámbó wégawaanimba awánéꞌa ánaaemba puwónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ísu minááí simátimena afaꞌmóráe-noꞌwaamba waéna Pítaane Yémísine Yónine tíꞌmaena óraaꞌ-omapaꞌo iyúmba miwí aantemba imésa miwí túranka Ísu fíꞌoran-auma faufúwana ");
INSERT INTO auy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","wení unáánkwátóiyakemba sán-kena aafáúmó íyáúsenamo intembá úwasa ");
INSERT INTO auy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","awánomba kaeꞌ-wáásíyáí wíyómpakemba paápé ésarai mindárai-tuwiꞌa Íráiyaae Móseseeꞌa Yúndaa-waasi tíwáꞌnárai Ísuweꞌa aaí wésuyana ");
INSERT INTO auy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pítaa Ísuntafena séna óraakoo maankáꞌó méraundasa kaweꞌá imbá póta wááu-namba kaumbosáámó ondasá moórá endé éta moórá Mósesende éta moórá Íráiyaande miyáumaisa onó súwana ");
INSERT INTO auy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","áfááraumai tááꞌa úwana nóin-aaiya sínenawa íyómpo miyán-ááí Pítaa siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Miyá wésunkaꞌa ainánkó kuména káátaguwana mináínámpínkémbá aaigó aantemba séna miwá kesáánimba isaꞌá wen-ímáyáá wéune. Wenáái ísáaro súwasa ");
INSERT INTO auy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","wení kísau-waasiyau awánomba mindárai wíyómpaꞌa íyúyana Ísu aantemba méraiye. ");
INSERT INTO auy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Úwasa omápakembo kúmúmba Ísu óraaka simátimena séna awánaamba ímba simátíméro. Kemá waási úranko púwóndafinkembo íyáfasinaandaraꞌa maami awíyaamba kanaaráꞌá simátímaꞌmae íyóro súwasa ");
INSERT INTO auy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","isésa ímba simátimesa minááí úwoi faráátesa keáímbá sésa púwóndafinkemba íyáfasinanaumne simbá nóran-aaiyaꞌiyo siyáawe. ");
INSERT INTO auy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Simásuwesa Ísumba áísai esa sésa ámáámbo sen-kwáásí sésa Íráiyaa aifaꞌá paápé ínana Maníkó íyáfasinankaraiwai Yúndaa-waasisa amuꞌmakáundawisa ánaaemba paápé íníyemo sembá nóra sésawa minááí wéseo suwaná ");
INSERT INTO auy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ísu séna aifaꞌá Íráiyaa paápé éna toꞌmayaa íníye-aai éraiꞌ-aain-iye. Moórá-aai waási úranko kumpaápé uráiwaintafena agaimaréna séna wembá áíꞌo índa-iꞌa uwánkesa tínaaeniꞌa uwánkanaawe agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Simátimeꞌa súne. Íráiyaa éꞌa tiyáiye. Agaimakóntemba úmai wembá sáwíꞌa uwánkanae sésa sáwíꞌa uwánkaraawe. Miyán-ááí wentáfésa agaimakóntemba kemá waási úrankontafesa agaimakáawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ísu simátimena omápakembo kúmúmba wení kísau-waasifaꞌa kúmúwasa sáwífaꞌ-waasi túwaandu ésa ámáámbo sun-kwáásíyé Ísuni kísau-waasiye iyafákén-ááí sésa ");
INSERT INTO auy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ísu túntafesa ifátuwesa aaweyáá uwánkówana ");
INSERT INTO auy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ísu séna nóintafera iyafákén-ááí wéseo séna tísai úwana ");
INSERT INTO auy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","miwífínkémbá moóráwigo séna óraakoo kesáánimba áíꞌmae túne. Wenarumpimbá sáwí-amutamba méraisana ímba aaí wésisana ");
INSERT INTO auy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","misáwí-ámútánkó taꞌótoꞌmai fameꞌnaameꞌ-isaná tanaambá fágufagu wéena áwááyaamba umpufuwéna aigaregó nonkáánéna aíyayaamba kuꞌwisaná miyá úmae wéiyisaꞌa ení kísau-waasisafe séꞌa sáwí-amutamba arumpinkémbá maiyaúwáaro súnasa ímba kanaaꞌá maiyáúkaawe súwana ");
INSERT INTO auy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ísu séna kentáféꞌa ímba imáyáa owaná póna sirumbá umbaí wétaifo nóraumai-kanaarara keséꞌa méranaumno simásuwena séna énifo enáánimba áíꞌmae tiyó súwasa ");
INSERT INTO auy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","áíꞌmaesa tuwaná misáwí-ámútánkó Ísumba awánéna miníyámpóí faméꞌauwowana tanaambá féna wárereꞌ-úwana aigaregó nonkáánúwana ");
INSERT INTO auy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ísu afowántáféna séna nóin-kanaawa ánkaraiyo súwana umarankáꞌá ánkaraiye. ");
INSERT INTO auy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tufuwíndasafena póna sáwífaꞌ-iꞌa faméꞌmai iyafíné nompínémó túwááraantamba wéiye. Emó kanaamó e aruntá uwásinkesa súwaꞌnai uwo súwana ");
INSERT INTO auy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ísu séna nóra séwa emó kanaamó e súwaꞌnai uwo wéseno. Maníkómpá timankúnkúmbo íyawimo ésa seyaafá-tántááꞌá kanaaꞌá ónááwe súwana ");
INSERT INTO auy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","miníyámpóígón-afowá minúwóíyáán-úmai óraaka séna kemá Maníkómpáꞌá simankúnkúmba úmpo kemá Maníkómpáꞌá ímba fasiꞌaráumpo súwaꞌnai uwo súwana ");
INSERT INTO auy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ísu awánómba sáwífaꞌ-waasi sisipáá uwaná sáwí-amutankontafena séna uwó-sáwí-ámútánkóo auwé kóuwo. Ímbo kouwérénda ékaꞌa kóuwo súwana ");
INSERT INTO auy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","wááꞌa téna miníyámpóí faméꞌauwowana tanaambá fówana arumpinkémbá kóúwana miníyámpóí púwóraantan-éna mérowasa tuwímbai sésa éꞌa púwíye suwaná ");
INSERT INTO auy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ísu ayáánkwanda toꞌmái íyáfasinakowana kokuꞌá méraiye. ");
INSERT INTO auy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kokuꞌá mérowana Ísu naaúmpaꞌa imérowasa Ísu weyáámo méronkaꞌa wení kísau-waasi imésa sésa nóra sétaawa misáwí-ámútámbá ímba kanaatá maiyáúkaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","séna inaigó aantemba miyáumai miyá-sáwí-ámútámbá maiyauwáínífo fíꞌon-tantaako ímba kanaaꞌá maiyauwáíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ísu simátimena tuwéna Káríri-aempaꞌ-aampaꞌa wéwena sáwífaꞌ-waasi túwaandu ofó séna kesí kísau-waasi aantemba aaí simátimenae séna aampaꞌá wéwena séna kembá waási úrankomba fíꞌon-kwaasi timíyasa sínkamiya puwéꞌa kaumbo-kánáá maisuwéꞌa íyáfasinanaumne súwasa ");
INSERT INTO auy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","wemó sún-aaigoni áwáuma ímba isésa áísai ónae sésamo umbá tááꞌa úwasa ímba áísai uráawe. ");
INSERT INTO auy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ímba áísai esa Kápaneamu-naopaꞌo kumbá naaúmpaꞌa imáúwana Ísu tísai ena séna aampaꞌ-wéteꞌa nóin-aaiya siyáao súwasa ");
INSERT INTO auy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","aampaꞌ-wéwesa sésa kentááfínkémbá nááwa íyáákaiyo sésa keáímbá símae wéwesa pósa ímba aaí suwaná ");
INSERT INTO auy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ísu maraꞌ-maéna wení waási sísamaifakemba kaeꞌá kumbaimái-waasisafena séna ísáaro. Íyáákanaemo síyawi tínaaeniꞌa ésa seyaafáꞌ-wáásítí wayóꞌá máéro simásuwena ");
INSERT INTO auy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","moórá-iyampoi áíꞌmai afufumpimbá isáúwankena taparéna simátimena séna ");
INSERT INTO auy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","kentáfésa imáyáa wéesa iyámpóímo túwaꞌnai onten-úmai wésuwaꞌnai-owe. Súwaꞌnai onten-úmai Maníkó siꞌmákaiwaimba wéawaꞌnai-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Súwana Yóni Ísuntafena séna óraakoo moóráwigo wénena sáwí-amutantontafena séna Ísuni fasiꞌaémbó wéraintafe auwé kóuwo simátímapaꞌa wisasá misáwí-ámútámbá kóuraawe. Minkwáásígó ímba kentááfínkén-kwáásí ómpo ímba miyámó indá étuwaaosa siyáumne Yóni súwana ");
INSERT INTO auy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ísu séna ímba tufínankaaro. Ímbo awánaan-kisaumo wémaewi úwoi kesúwíꞌa ímba sáwíꞌa uwásinkanaawe. ");
INSERT INTO auy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kentáásí kísaugomba ímba sáwíꞌo owí úwoi wésuwaꞌnai-owe. ");
INSERT INTO auy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Éraiꞌa simátime súne. Kembiwí tuwánésa sésa Ísu Káráísitini waási ombá pósa túwaꞌnai ónae sésa kári-tantaaꞌa nombó timíyawi Maníkó kaweꞌ-méyámbá timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ísu minááí simátimena séna iyámpóímo kesááisafesa timankúnkúmbo ontenkáán-úmai tuwímbai timankúnkúmba wéowe. Tuwímbai tésa kesááisafesa timankúnkúmbo owímá karoꞌ-ááí tasimátimiyasa isésa sáwí-ampaꞌa kóíyasa Maníkó karoꞌó síyawi sáwí-meyamba óraaꞌa timínífo miwímó tinuwarampimbó óraaꞌ-ontamba fáríꞌwimaresa nompímbó túwááwasamo kumpuwésaraa karoꞌ-ááí ímba simátíméwasa sáwí-ampaꞌa ímba kowisinó. Mindá kanaán-iye. ");
INSERT INTO auy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tiyáánkomo sáwíꞌo ínaꞌa misáwí-ámpáꞌá kúnafo séꞌa moórá-tiyaamba kambísásúwáaro. Kae-tíyáámbó wérainaꞌo éꞌa ónkaifaꞌo iyamó kámakamaꞌo wéipaꞌo wíyamba mindá sáwíꞌan-iye. Sáwíꞌo uráimbo maisuwéꞌo méraiyamba mindá kaweꞌán-iye. ");
INSERT INTO auy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO auy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tísamaigomo sáwíꞌo ínaꞌa misáwí-ámpáꞌá kúnafo séꞌa moórá-tisamai kambísásúwáaro. Kae-tísámáímó wérainaꞌo éꞌa ónkaifaꞌo iyamó kámakamaꞌo wéipaꞌo wíyamba mindá sáwíꞌan-iye. Sáwíꞌo uráimbo maisuwéꞌo méraiyamba mindá kaweꞌán-iye. ");
INSERT INTO auy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO auy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Túrankomo sáwíꞌo ínaꞌa misáwí-ámpáꞌá kúnafo séꞌa moórá-turamba fitúwáaro. Kae-túrántámbó awánéꞌo éꞌa ónkaifaꞌo iyamó wégaipaꞌo wíyamba mindá sáwíꞌan-iye. Sáwíꞌo uráimbo maisuwéꞌo méraiyamba Maníkó wení waásimo kawáánipaꞌo méraiyamba mindá kaweꞌán-iye. ");
INSERT INTO auy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ónkaifaꞌa marinkómó éna waéꞌwaeꞌa wéinana iyamó éna ímbo pisínáímba kámakamaꞌa wéiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ísu simátimena séna uwímó tónkáꞌó toꞌmárááwanamo kaweꞌó intembá Maníkó waásiyaꞌa iyamó kaintenkáán-úmai maráínasa kaweꞌ-úmai méranaawe. ");
INSERT INTO auy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Uwímá kawe-tántááꞌán-ifo óraaꞌa taíꞌáísana ayáántámba wéraifo ímba anekaꞌá uwímó káínaꞌo éꞌa toꞌmaránááwe. Uwígó ásémo intenkáámbá wéeꞌa aáno úmai méranaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ísu minkáꞌá tuwéna Yúndiyaa-aempaꞌa Yóndani-nonkoni menáípáꞌá komérowasa anekaꞌá sáwífaꞌ-waasi túwaandu úwana sún-aai wésimatimuwasa ");
INSERT INTO auy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ámáán-kawaa-waasi sésa sáwí-aaimo sínda isánae sésa Ísumpaꞌa tésa sésa moórá-waasigo awaainínkómbá kanaará auwáíníyo. Miyámó énamo éna ámáán-aai taraisíni ína taraisíníyo suwaná ");
INSERT INTO auy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","séna naaófáꞌá Mósese nóra-amaana simátímakaiyo séna tísai úwasa ");
INSERT INTO auy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","miwí sésa Mósese maará siyáiye. Moóráwigo awaainínkómbó aiꞌmátuwaindawi aúfáífimba agaimaréna séna kesuwaainímbá aiꞌmátuwaumne séna agaimái amíno siyáiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ísu séna kentíwáꞌná tirumbó makáamba pósa Maníkón-aai ímbo ísóntafena mindásafena Mósese minámáámbá siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maníkó wíyóne marawémó úmaronkaꞌa ímba miyá siyáifo Maníkó aarewárá waaiwáráꞌá úmakaiye. ");
INSERT INTO auy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Miyámó uráintafesa tinófoi tiyuwésa awaaikóe awaainínkóeꞌa takááísamai ");
INSERT INTO auy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mimbórá-túmá maꞌmái méraawe. Mindásafesa awaaikóe awaainínkóeꞌa ímba kaeꞌ-wáásíyáámbó ombá mimbóráíꞌa wéowe ");
INSERT INTO auy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Maníkó aare-waaí moórá-iꞌo uwátínkaraintafesa ímba tuwínáaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ísu simátimena naaúmpaꞌa imésa wení kísau-waasi Ísumo sún-aaisafesa áísai uwaná ");
INSERT INTO auy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","séna moóráwigo awaainínkómbá aiꞌmátuwenamo fíꞌon-inimbo wémaimba umémbá wéiye. ");
INSERT INTO auy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Moórá-ininko awaaikómbá auwénamo fíꞌonkwambo wémaimba umémbá wéiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ísu simátimuwasa tuwímbai Ísu taꞌótorena ayááfúmba tátinkainkwae sésa iyámpói tíꞌmae tuwasá wení kísau-waasi sésa tíꞌmae kóro suwaná ");
INSERT INTO auy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ísu tuwánéna aaisambá tiyéna séna ímba kóro síyamba tiyuwáíyasa kempáꞌá iyámpói úwoi teró. Miníyámpóí kempáꞌó tentembá Maníkó wení waásimo kawáánimba miyáráán-úmai wégawaanimba iyámpói kempáꞌó tíyan-amba ímba faítinkaaro. ");
INSERT INTO auy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Éraiꞌa simátime súne. Maníkóntáfésamo sésa iyámpóíyaan-úmai kenkátá wégawaanonemo síyanamo éna miwíyáꞌá kawáánínífo ímbo miyámó síyawimo éna ímba kawááníníye Ísu séna ");
INSERT INTO auy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","miníyámpóísómbá taparéna tineꞌá taꞌótorena ayááfúmba tátínkaraiye. ");
INSERT INTO auy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ísu simátimena kúwana moóráwigo awaantanténa Ísu óraakon-iye séna takífaena séna kawekó óne. Nóra úmaiya aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónaumno súwana ");
INSERT INTO auy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ísu séna kentáfé nóra séwa kawekó óne wéseno. Mimbóráwígó Maníkó weyáá kawekón-iye. ");
INSERT INTO auy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Maníkóní ámáámba éꞌa ísaraane. Minámáámbá aúfáífimba agaimaréna séna waási ímba tínkamiyasa púwóro. Ímba aare-úmémbán-oro. Ímba umémbá máéro. Ímba karoꞌ-ááí simátínkáaro. Ímba karoꞌá séꞌa fíꞌowiti moparáwímbá máéro. Kentinófoi-tuwiꞌa óraaꞌ-iꞌan-oro siyáiye súwana ");
INSERT INTO auy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","miwá séna minámáámbá kemá iyámpóíyakemba ísareꞌa kaweꞌá úmae wéiyune súwana ");
INSERT INTO auy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ísu awánéna aamoí éna séna kaweꞌá éma moórá-tantaaꞌa ímba kaweꞌá uráampo ení moparáwímbá fíꞌon-kwaasi wétime óntamba maiyé ímbo makéwi tuwín-timinana ení kaweꞌ-méyámbá Maníkó wíyómpaꞌa ankáíníye. Tuwín-timemo e kembá sirááíwainone súwana ");
INSERT INTO auy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","minááí iséna sáwífaꞌ-moparawimbo makóntafena aiꞌá kaoréna óraaꞌ-imayaa úwana arunkó sáwíꞌa úwana kuráiye. ");
INSERT INTO auy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kúwana Ísu waeréna wení kísau-waasisafena séna sáwífaꞌ-ontamo makén-kwaasi Maníkó wení waásimo kawáánipaꞌo wíyamba umbaí táíníye súwana ");
INSERT INTO auy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","wení kísau-waasi minááísáféna tááꞌa úwana séna kesí iyámpóísono. Ónta-imayaamo émaiyawi Maníkómó kawáánipaꞌo wíyamba umbaí táíníye. ");
INSERT INTO auy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Moórá-poigon-awiꞌa káámeri mimpóígó waigóní afaapimbá ímba kanaaꞌá kóferainiye. Káámeri-poigomo waigóní afaapimbó kóféráínkakaa sáwífaꞌ-ontamo makáan-kwaasi Maníkómó kawáánipaꞌa kowisinó súwasa ");
INSERT INTO auy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","minááí isésa táátafesa ésa sésa umbaí taifó nóran-kwaasiya Maníkómó kawáánipaꞌa méranaao suwaná ");
INSERT INTO auy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ísu tuwánéna séna waási miwítí kísausamba ímba méyámbaresa kónááfo Maníkó seyaafá-tántááꞌá úwoi kanaaꞌá wéiye súwana ");
INSERT INTO auy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pítaa séna isaaó. Kentáásí seyaafá-tántááꞌá tuwéta entá wéaraaiwaumne súwana ");
INSERT INTO auy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ísu séna éraiꞌa simátime súne. Kentáfésa imáyáa ésa Maníkóní ásé-aaimo kosimátimiyantafesa naaópaꞌa tuwésa tuwaaísáiye tífátone tímánaatone tinófoiye táánine tiyáámúne tiyuwésa miwítí maramó túwááwin-anondaa ");
INSERT INTO auy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","marapáꞌó méraankaꞌo túwáán-tantaaꞌa miyán-tántááꞌá sáwífaꞌa maésa tuwaaísái-iꞌa ésa tímánaariꞌa ésa tinóisai-iꞌa ésa kentí iyámpóí-iꞌa ésa naané marawémó maíyamba miwífímbá umbaimó tátinkaiyambo ésa ánaaen-kanaa aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ánaaemba aifarááwífínkémbá tuwímbai tínaaeniꞌa íyasa tínaaenkewifinkemba tuwímbai aifaríꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ísu simásuwena Yérúsaremu-naopaꞌa kónae sésa aampaꞌá wéwesa Ísu aifaꞌá kúwasa wení kísau-waasi táátafesa uwasá tínaaembo kun-kwáásíwáráꞌá táátafesa uwaná Ísu wení waási sísamaifakemba kaeꞌá kumbaimái-waasi tíꞌmaena moórá-aempaꞌa tínkarena wempáꞌó tínda-tantaakontafena mósimatimena ");
INSERT INTO auy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","séna ísáaro. Yérúsaremu-naopaꞌa konanasá moóráwigo kembá waási úrankomba óraaꞌ-amaan-kisau-waasiye ámáámbo sen-kwáásíyé aráátiminasa kembó sínkamiyan-aai símaresa síꞌmai fíꞌonkaa-waasi timíyasa ");
INSERT INTO auy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","karaánááꞌa sinkésa tuwiyáái wisinkésa súwiyonkuꞌ-wénesa sínkamiyaꞌa púwónasa utámaraiyaꞌa kaumbo-kánáá maisuwéꞌa íyáfasinanaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Minkánáá Sépétin-ááninkorai Yémísiye Yóniyeꞌa Ísumpaꞌa tésarai sésa óraakoo áísai oyantembá uwásinkaao suyaná ");
INSERT INTO auy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","nóintafenawa wétinkaina uwátinkanaumno súwasarai ");
INSERT INTO auy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sésarai ení sámo kaim-bárúpáꞌó imémo e kenkáí íyáfasisinke séfasefaꞌ-arausampaꞌa sinkaaó suyaná ");
INSERT INTO auy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ísu séna séyan-aaigoni áwáu ímba ísaraaye. Sáwí-nombo anaféúmpínkémbó naandantén-úmai síꞌo índa-iꞌo uwásinkaiyamba keráí kanaará kemó naanda-ánáfeumpinkemba náyááyo. Síꞌo índa-iꞌo uwásinkaiyantemba kanaará kenkáí miyá uwátinkanaao súwasarai ");
INSERT INTO auy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sésarai keráí kanaaꞌá pókai máéyauye suwaná Ísu séna éraiꞌa séye. Kemó naanda-ánáfeumpinkemba náyááye. Síꞌo índa-iꞌo uwásinkaiyantemba kenkáí miyá uwátinkanaafo ");
INSERT INTO auy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kesí séfasefa-sirausampaꞌa kemá ímba íyáfasintinkanaumpo Maníkó kaeꞌnárai uwátínkaraimba póna íyáfasintinkainiye súwasa ");
INSERT INTO auy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ísuni kísau-waasi siyáánkainarau minááí isésa Yémísinte Yóninte aaisambá tíyúwana ");
INSERT INTO auy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ísu táántowasa tuwaná séna éꞌa ísaraawe. Marapáꞌ-órááꞌ-wáásísómbá íyáákamai-fasiꞌaen-aai simáti-simati uwasá wenkóyááka-tayaaka uráawe. ");
INSERT INTO auy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Óraaꞌ-waasimo ontembá kembiwíwáráꞌá ímba miyán-oro. Kempínkémbó íyáákanaemo síyawi fíꞌowiti wayóꞌá ónááwe. ");
INSERT INTO auy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kempínkémbó aifaríꞌa ónaemo síyawi seyaafáꞌ-wáásítí kísau túwaꞌnai oro. ");
INSERT INTO auy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kemá waási úranko ímba súwaꞌnai íwaeꞌa kunkáumpo kemá waási túwaꞌnai ónaeꞌa kunkáumne. Sáwí-imayaafinkembo faútínkáandasafe puwónaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ísuwe wení kísau-waasiye Yéríko-naopaꞌo kumbá sáwífaꞌ-waasiwaraꞌa mindáópa tuwésa aampaꞌá kuwaná Tímiyasin-ááninkon-awiꞌa Páátímiyasi aúrambo kafíkówi óntamba inaí símai maénae séna aanawáísáraꞌa kumbéna wéinai súwasa ");
INSERT INTO auy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","tuwímbai sésa Ísu Násaretifakewi wétiye suwaná iséna óraaka séna Ísuwo Téfítin-andafakewi ómpo arumbá uwásinkaao súwasa ");
INSERT INTO auy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","sáwífaꞌnanka aaisambá aéésa sésa aseraaó suwaná minááí ifátuwena anekaꞌá óraaka séna Ísuwo Téfítin-andafakewi ómpo arumbá uwásinkaao súwana ");
INSERT INTO auy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ísu aampaꞌó wémomba wení ewaaꞌá koíyáfasinena séna áántaaro súwasa aúrambo kafíkówimba áántesa sésa enarunkó kaweꞌá íno. Wéaantaifo íyáfasinaao suwaná ");
INSERT INTO auy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","atuwénamo méron-ampanta faúmarena íyáfasinena Ísuni ewaaꞌá túwana ");
INSERT INTO auy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ísu séna nóina embó arááímo táínda-iꞌa uwánkanaumno súwana séna óraakoo súramba kaweꞌá uwásinkainkwaeꞌa úne súwana ");
INSERT INTO auy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ísu séna kentáfé kanaaꞌá súwaꞌnai índawin-iye sémpo kaweꞌá uwánkaumpo waaó súwana minúwóíyáámbá aúramba awánéna Ísun-ánaaemba kuráiye. ");
INSERT INTO auy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ísu wení kísau-waasiseꞌo kumbá Yérúsaremu-naoꞌ-ampaꞌo kumbá Órífi-omapaꞌ-ewaaꞌ-naokai moórá Pétéfasi-naoꞌa úwana moórá Pétáni-naoꞌa úwana minkáéꞌ-náókoni ewaaꞌó kumbá wení kísau-waasi kaeꞌá mátiꞌmarena ");
INSERT INTO auy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","séna epín-dáópaꞌa kurékai moórá-poigon-awiꞌa tónki koawáneyambo waásimo ímbo ayáákainda-poi ándá faútuwekai áíꞌmae tekaiyó. ");
INSERT INTO auy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Moóráwigo tuwánénamo nóra óyaekaiya óyómo sínakai óraako ayááꞌmaeꞌa konasá áíꞌmaesa kouweránááwe siyé simámékaiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","kuyaná mimpóí ontaráꞌá ándá anuwarampimbá fáríꞌwimarowana mérowasa koawánésarai minándá kofaútúwóyana ");
INSERT INTO auy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","minkáꞌó méron-kwaasi sésa nóra sékaiya mimpóígóní ándá wéfautuwaayo suwasaráí ");
INSERT INTO auy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ísumo sún-aai simátímúyasa kanaán-ifo miyá okaiyó suwasaráí ");
INSERT INTO auy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","áíꞌmaesarai Ísumpaꞌa tuyasá wení kísau-waasi paákákén-únánkwátói faúꞌmai mimpóígón-arósááunkaꞌa wandaaí uwíꞌmárówana Ísumba ayááꞌmae wéguwasa ");
INSERT INTO auy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","sáwífaꞌ-waasi mésa óraaꞌ-waasin-iye sésa tuwímbai paákákén-únánkwátói faúꞌmai tuwímbai taaénáma ankáímai aampaꞌá uwíꞌmaꞌmae wéguwana minúnánkwátóiyaꞌe mintáénárafane támae wéguwasa ");
INSERT INTO auy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","aifaꞌó tun-kwáásíyé Ísun-ánaaembo tun-kwáásíyé óraakaꞌ-oraakaꞌa sésa Fasiꞌaénkó aiꞌmáráísana kunkáiwaimba Maníkó kaweꞌá uwánkáíye. ");
INSERT INTO auy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kentáá síwáꞌná Téfítimo kawáán-uráintemba miyáráámbá íníye. Wenáwíꞌa mósá maráúmne óraakaꞌ-oraakaꞌa suwaná ");
INSERT INTO auy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ísu Yérúsaremufaꞌo kúmba óraaꞌ-amaan-daumpaꞌa iména seyaafá-tántááꞌá awánéna fenómpinkaꞌa wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi tíꞌmaena Pétáni-naopaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pétáni-naopaꞌa kowaiyómba aafáyáaraꞌa mindáópaꞌa tuwésa aampaꞌó kumbá Ísumba áái tówana ");
INSERT INTO auy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","moórá-taigon-awiꞌa fíkima wérowana mintáéramba nánae séna áwáufaꞌa wéna awánómba arambó iyáí-kánáámó ímbo túmba ímba iyéna áná aantemba wérowana saafá uwááena ");
INSERT INTO auy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","mintáígóntáféna séna emá arambá ímba iyáínone. Anekaꞌá waási ení arambá ímba nánááwe súwasa wení kísau-waasi minááí ísaraawe. ");
INSERT INTO auy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ísumo sún-aai isésa Yérúsaremu-naopaꞌo kumbá Ísu óraaꞌ-amaan-daumpaꞌa iyéna ámáán-daumpaꞌo méyámbó wéun-kwaasi tuwánéna itiꞌmátuwena ámáán-dankoni óntambo méyámbárón-kwaasiti taaremá tawísísuwena Maníkóntáfésa imáyáa ésa mááufuꞌ-numamo wéamun-dumamo méyámbárón-kwaasiti taaremá tawísísuwena ");
INSERT INTO auy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","simátimena séna anekaꞌá ímba ámáán-daumpaꞌa miyán-tántááꞌá maimaéꞌa iyé-kunke oro. ");
INSERT INTO auy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Maníkón-aai aúfáífimba agaimaréna séna kesí naantafésa sésa Maníkómpáꞌó inaimó sen-dámbá isasá fíꞌo-fiꞌom-barafaken-kwaasi tésa inaí wésewe agaimaréna siyáiye. Énifo umén-dáúmpáꞌó ontenkáámbá uráawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ísu súwasa óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé Ísumbo tufuwíyan-aai wésesa sáwífaꞌ-waasi Ísun-aaimo ísámae wéiyuntafesa táátafe ésa Ísumbo tufíyan-amba wésaafa-uwasa ");
INSERT INTO auy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","fenómpinkaꞌa Ísu wení kísau-waasiseꞌa Yérúsaremu-naopaꞌa tuwésa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ísu wení kísau-waasiseꞌa kowaiyómba íyáfasinesa aampaꞌó kumbá fíki-taimo awánomba ánúka toꞌmái seyaafáꞌá móaenkagurowana ");
INSERT INTO auy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pítaa Ísumo séwiyon-aai áákaꞌa maréna séna awánaao. Aaimó séwiyaanda-taima éꞌa aáénkaraiye súwana ");
INSERT INTO auy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ísu séna Maníkómpáꞌá timankúnkúmba oro. ");
INSERT INTO auy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Éraiꞌa simátime súne. Maanómátáfé séꞌo iyé faiwíꞌwé nompáꞌá kumuwómó síyawi ímbo kaeꞌ-ímáyáá tokésamo súndantemba éraiꞌa íníye síyanamo éna éraiꞌa miyá íníye. ");
INSERT INTO auy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mindásafeꞌa Maníkómpáꞌá inaí séꞌa fíꞌo-fiꞌon-tantaatafeꞌa áísai eꞌo sembá éraiꞌa Maníkó kanaaꞌá súwaꞌnai uwásínkáíye sembá kanaaꞌá wétuwaꞌnai-iye. ");
INSERT INTO auy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Maníkómpáꞌá inaimó sembá sáwíꞌo uwátinkaiyamba anondáá sáwíꞌa ónaumne-imayaa ímbo íyamba ifátúwáaro. Miyámó íyanamo éna kentifo wíyómpakewi kembiwí sáwíꞌo ombá maitiyuwáíníye. ");
INSERT INTO auy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Énifo sáwíꞌo uwátinkaiyamba úwoimo imáyáamo úmae wéiyeꞌo ímbo ifátuwaiyanamo éna kentifo wíyómpakewi sáwíꞌo ombá ímba maitiyuwáíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ísu wení kísau-waasiseꞌa anekaꞌá Yérúsaremu-naopaꞌo kumbá óraaꞌ-amaan-daumpaꞌa wénuwasa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye ámáámbo sun-kwáásíyé Ísumpaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","sésa nááwawa aiꞌmáráísa tiyéwa nááwampinkena maiyéwa fasiꞌaén-kísáú wémaeno. Simásimiyo suwaná ");
INSERT INTO auy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ísu séna aifaꞌá moórá-aaimo tísai onaꞌó anondáámo síyaꞌo éꞌa sísai on-ááí simátimenaumne. ");
INSERT INTO auy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ááéma Yóni nombó maitínkaraiwai Maníkówá simámakaisanawa nombá maitínkarai waásiya simámakaawanawa nombá maitínkaraiyo súwasa ");
INSERT INTO auy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","miwí keáímbá sésa nórasaawa sénaumno. Maníkó simámakaisana nombá maitínkaraiye senanasáámó éna nóra séra Yónin-aaisafeꞌa ímba éraiꞌe siyáao síníye. ");
INSERT INTO auy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Waási simámakaawana nombá maitínkaraiye senasasáámó ésa úwoi-waasisa sínkamonaawe. Úwoi-waasi sáwífaꞌ-waasi Yónintafesa sésa Maníkón-aai simásímakaiwai uráiye wésemba pósa aaisantá siyónááwe miyá keáímbá sésa ");
INSERT INTO auy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ísuntafesa sésa emó sísai ónda-aaisa ímba isáúmne suwaná Ísu séna ímbo simásimiyaꞌa nááwampinkena maiyéra fasiꞌaén-kísáúmó wémaunda-aai ímba simátimenaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ísu waéꞌmai-aai simátimena séna moóráwigo óntan-kusai úmakena ándá-aran-kisau úmarena ándá-arankoni táúfaꞌa úmarena ándá-arambo mapamínanamo anombó kumínda-taufaꞌa úmarena óntan-damba kísauraꞌo káráwiyiyan-damba úmarena ayáátááka fíꞌom-barafaꞌa koménae séna maankísáúráꞌó káráwiyawimo éꞌa kesáféꞌa tuwímbai-aramba wémaeꞌa tuwímbai kembá siyúwáaro simátimena fíꞌom-barafaꞌa koméraisana ");
INSERT INTO auy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","arambó áfumo kain-kánáá tisaná aanáfó kesí ándá-aramba komáéro séna wení kísau-waasi aiꞌmáráísana minkísáúráꞌó káráwiyowifaꞌa tisasá ");
INSERT INTO auy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","taꞌótoꞌmai tufúꞌmaresa ándá-aramba ímbo ámémba aiꞌmátuwaawana kóísana ");
INSERT INTO auy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","aanáfó moóráwigomba aiꞌmáráísana tisasá minkísáúráꞌó káráwiyowi taꞌótoꞌmai aꞌnómbá tufámbai sáwíꞌa uwánkááwana kóísana ");
INSERT INTO auy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","aanáfó moóráwigomba aiꞌmáráísana tisasá taꞌótoꞌmai tufúꞌmárááwana púwísana aanáfó moórá-mora tiꞌmáráintemba tewasá tínkamba tinkamba wéowasa tuwímbai púwówasa tuwímbai tauwérááwana ");
INSERT INTO auy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","aanáfó kímborama wenááninkomba póna wen-ímáyáámó wéuwaimba ayáátáákaꞌa imáyáa émena kesááninkon-aai isánááwe séna aiꞌmáráísana ");
INSERT INTO auy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","tisasá minkísáúráꞌó káráwiyowi awánésa keáímbá sésa aanáfón-ááninko wétifo tufúwónanasa puwéna maankísáú ímba maínata kesáá maénae sésa ");
INSERT INTO auy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","taꞌótoꞌmai tufúwówana púwísasa maimái aumépaꞌa métukaawe. ");
INSERT INTO auy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ísu minááí simátimena séna minkísáú-áánáfó miyá íníye. Téna kísauraꞌo káráwiyowi tínkaminasa puwíyana fíꞌonkaa-waasi kesí kísauraꞌa káráwiyoro síníye. ");
INSERT INTO auy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Maníkón-aai aúfái toráumai awánaraawe. Maarán-ááí agaimaréna séna óntan-dambo on-kwáásí moórá-ontantafesa sáwíꞌa wéiye sésa maisukáawe. Ánaaemba minóntánkó áfonkaamba uráiye. ");
INSERT INTO auy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mindá Fasiꞌaénkó isatá awánéta séta fíꞌoran-kaweꞌa uráiye súne agaimaréna siyáiye Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yúndaa-kawaa-waasi minááí isésa kentáásáféna siyé sésa taꞌótoꞌmai tufuwónae sésamo umbá seyaafáꞌ-wáásísáféna tááꞌa úwasa ifátuwesa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Óraaꞌ-amaan-kisau-waasi wésa Ísumba áísai íyana sáwí-aaimo sínasa aaifimbó maiyankáíyantafesa ámáán-kawaa-waasifinkemba tuwímbaiye Éroti amááraawifinkemba tuwímbaiye tiꞌmárówasa ");
INSERT INTO auy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ísumpaꞌa tésa sésa óraakoo éraiꞌ-waasi po waási táároi ímba inkaisé óraaꞌ-waasiye úwoi-waasi táároi ímba inkaisé tirumbó faiyáꞌmai-aai ímbo sénda Maníkóní aambó arááíwáén-aai arupíse úmai simátimendasa wéisaumne. Emá nóra séwa wéisaano. Kanaasááwá taakisi-óntámbá Rómu-kamanisa timénaum íntaawa timénaumno. Tíméndasa Yúndaa-waasisa kentáásí ámáána taraisónaum íntaawa taraisónaumno. ");
INSERT INTO auy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Timénaum íntaawa timénaumno suwaná Ísu miwítí imáyáa iséna kaumbo-kaeꞌ-ááíwáráꞌ-wáásín-owe séna kentáféꞌa sáwí-aaimo síndawe séꞌa wésisai-owe. Moórá-ontamba maimaé máaraasimero súwasa ");
INSERT INTO auy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","maimaé máaraanamuwana séna nááwan-óikaana uráinkara áwíꞌa wéraiyo súwasa miwí sésa Rómu-kamani-kawaagon-óikaamba isaná áwíꞌa wéraiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ísu séna Rómu-kamani-kawaagonde wembá áméro. Maníkóndé Maníkómbá áméro súwasa minááí ísówana tááꞌa úwasa ímba aaí siyáawe. ");
INSERT INTO auy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Suwasá Sátúsi-amaan-kawaa-waasi púwómpinkemba ímba íyáfasinanaawemo sun-kwáásí pósa Ísumpaꞌa tésa sésa ");
INSERT INTO auy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","óraakoo naaófáꞌá Mósese séna moóráwigo aaré maimakéna iyámpói ímbo maꞌánkáímba puwínana áfáko maimakéna awaaón-anondaa-wareꞌe séna iyámpói maꞌankáíníye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Moórá-aai isaaó. Moórá-kanaa afakaeté-afarawainonda mésa tuwaaó aaré maimakéna iyámpói ímbo maꞌánkáímba púwísana ");
INSERT INTO auy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","wenánaaenkewi wareꞌá maimakéna iyámpói ímbo maꞌánkáímba púwísana wenánaaenkewi wareꞌá maimakéna iyámpói ímbo maꞌánkáímba púwísana miyá émesa ");
INSERT INTO auy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","afakaeté-waasi putásaawana minínínkó ánaaemba pukáiye simámesa ");
INSERT INTO auy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ísumba áísai esa sésa miyámó ombá waási puwíyampinkembo íyáfasinaiyan-kanaa minínímbá afakaeté-waasi tuwaainímbá éna nááwa máíníyo suwaná ");
INSERT INTO auy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ísu séna Maníkón-aai aúfáífimbo agaimakón-aai ímba kaweꞌ-úmai iséꞌa Maníkóní fasiꞌaémbá ímba awánéꞌa póꞌa miyáumai sáwísáwí-aai wésewe. ");
INSERT INTO auy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pukémpinkemba íyáfasinesa wíyómpaꞌo imaíyan-kanaa aaré ímba maíyasa waaí ímba maíyamba ésa Maníkóní kísau-waasimo wíyómpaꞌo méraawimo ontembá minínínákwáꞌá miyáumai aaré ímba maíyasa waaí ímba maíyamba ónááwe. ");
INSERT INTO auy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Waási pukémpinkembo íyáfasinaiyamba Mósese minááísáféna agaimakáiye. Aúfáífimba agaimaréna séna kári-taiyaꞌa iyamó kaimbá ímba mintáí káwisana mintáífínkémbá Maníkó Mósesentafena séna Maníkó úne. Enaíwáꞌná Émbaramuwe Áísáakiye Yékopuwe miwítí Maníkó úne siyáiye. Maníkó minááímó siyáimba minkáúmbó-wáásí éꞌa púwúwasa utaráambanifo ");
INSERT INTO auy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","minááí siyáimba pósa miwí úwoi méraawe. Énifo kentáái sáwísáwí-aai siyáawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Súwana ámáámbo sún-kwaasigo ména seyaafáꞌ-wáásímó sumbá iséna Ísuni íyáákamai-aai iséna Ísumba áísai ena séna Maníkóní ámáámpinkemba nóran-amaana aifaráámbán-iyo súwana ");
INSERT INTO auy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ísu séna aifaráán-ámáámbá sénaumne. Maníkón-aai aúfáífimba agaimaréna séna Ísareri-waasi ísáaro. Maníkó kentáásí Fasiꞌaénkó éna mimbórá-Fásíꞌáénkón-iye. ");
INSERT INTO auy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Maníkómpáꞌá kentí Fasiꞌaénkómbá kentiruné kentí imáyáawe kentimané kentí fasiꞌaéné áméro agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Miwán-ánaaenken-amaamba sénaumpo ísáaro. Maníkón-aai aúfáífimba agaimaréna séna kesáfé-ímáyáámó ontembá kentí waási-imayaawaraꞌa oro agaimaréna siyáiye. Minkáéꞌ-ámáánkó seyaafáꞌ-ámáámbá íyáákaraiye Ísu simámuwana ");
INSERT INTO auy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","minkwáásígó séna óraakoo éraiꞌa sénda Maníkó weyáá Fasiꞌaénkón-ifo fíꞌo-fiꞌo-fasiꞌaemba ímba méraawe. ");
INSERT INTO auy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kesáámá Maníkómpátá kesiruné imáyáawe kesí fasiꞌaénésá wempáꞌá tuwéta miyásá onó. Kesáfé-ímáyáámó úndantenta kesí waási-imayaawarata onó. Minkáéꞌ-ámáánkó seyaafáꞌ-ámáámbá íyáákaraiye. Tóné sipisípiye iyafímbá agaimái Maníkómbá amúndanifo mindáwaraꞌa íyáákaraiye séna ");
INSERT INTO auy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","miwámó súmba kaweꞌ-ímáyááfínkémbá súwana póna Ísu iséna séna Maníkómó kawáánimba wení ewaaꞌá méraane súwasa ísómba Ísun-aaisafesa tááꞌa úwasa ímba áísai uráawe. ");
INSERT INTO auy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ímba áísai uwaná Ísu óraaꞌ-amaan-daumpaꞌa iména simátimena séna ámáámbo sen-kwáásí sésa Káráísiti Téfítin-andafaken-kwaasin-iye wésefo ");
INSERT INTO auy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","naaófáꞌá Maníkóní Ufaen-ámútánkó Téfítimba imáyáa amúwana Téfíti Káráísitintafena séna kesí Fasiꞌaénkón-iye siyáimba imó agaimakón-aufaifimba Téfíti agaimaréna séna kesí Fasiꞌaénkóntáféna Maníkó séna kesiyáánúrapaꞌa fasiꞌaén-áémpáꞌá maraꞌ-ménaꞌa ení namuro-wáásí íyáákaanasa miwí taiꞌánááwe Maníkómó siyáin-aai Téfíti siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Miyáumai Téfíti Káráísitintafena séna kesí Fasiꞌaénkón-iye siyáimbanifo nóraumaiya wemá Téfítin-andafaken-kwaasin-iye Ísu súmba Káráísiti Téfítini Fasiꞌaénkó éna Téfítin-andafaken-kwaasigon-iye. Úwoi-waasi seyaafáꞌá Ísun-aai isésa aamoí uráawe. ");
INSERT INTO auy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Úwoi-waasi seyaafáꞌá Ísun-aai isésa aamoí wéuwana Ísu simátimena séna tuwímbaimo ámáámbo sen-kwáásítí aambá arááíwáéfo. Minkwáásí ayáátáá-kuferai wiyésa naaópaꞌa afufumpaꞌá wénowasa pósa waási tuwánésa sésa óraaꞌ-waasin-owe wésewe. ");
INSERT INTO auy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Minkwáásí ámáán-daumpaꞌo ombá óraaꞌ-waasimo máén-aempaꞌa imésa tanómbo kaúfópaꞌo ombá kaweꞌ-áémpáꞌá mésa kawe-tómbá wénaawe. ");
INSERT INTO auy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Minkwáásí ketoꞌ-íníntí óntawara naankwaráꞌá umémbá wémaesa waási suwánésa súwíꞌa mósá maráíwae sésa karoꞌ-ááí tafisímai inaí wésewe. Miyámó on-ánóndáá óraaꞌ-umbai maénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Simátimena Ísu óraaꞌ-amaan-daumpaꞌa ména óntambo túwón-anafeunkoni ewaaꞌá ména tuwánómba waásisomba tésa óntambo túwómba sáwífaꞌ-ontawaraꞌ-waasi sáwífaꞌ-ontamba túwówana ");
INSERT INTO auy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","moórá-ketoꞌ-ininko ímba óntamo makón-ininko téna káriꞌ-ontamba kae-tóyáráámbá tuwówana ");
INSERT INTO auy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ísu wení kísau-waasi táántena séna éraiꞌa simátime súne. Minkétóꞌ-ínínkómó túwáín-ontanko seyaafáꞌ-wáásímó túwáán-ontamba íyáákaiye. ");
INSERT INTO auy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Miwí sáwífaꞌ-ontafinkemba tuwímbai túwáafo wemá káriꞌ-ontafinkemba mútúꞌa túwáímba póna ónta-iyaimba méíniye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ísu minááí simátimuwasa óraaꞌ-amaan-daumpakemba kárúwesa kúmúmba wení kísau-waasifinkemba moóráwigo óraaꞌ-amaan-dantafena séna úwé awánaao. Maanóntán-dámbá kaweꞌá uráisana minóntámbá óraaꞌ-ontamba wéraiye súwana ");
INSERT INTO auy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ísu séna maanórááꞌ-námbá awánaaro. Ánaaemba waási tésa mindámbá seyaafáꞌá tawísísuwesa seyaafáꞌ-óntánkwáráꞌá tawísísuwanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ísu minááí simátimena Órífi-omapaꞌa iména óraaꞌ-amaan-damba awánómba Pítaawe Yémísiye Yóniye Énduruwe miyáumai-waasi Ísumo weyáá mérompaꞌa tésa áísai esa sésa ");
INSERT INTO auy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","emó sénda nóin-kanaawa paápé íníyo. Nóran-kwaamera ínataawa séta ampáánkáꞌá Ísumo siyáimba miyá íníyesa sénaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ísu séna karoꞌ-ááí iséꞌa éraiꞌe sefó káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sáwífaꞌ-waasi tésa kesúwíꞌa másesa sésa Maníkómó íyáfasisinkaraiwai úne síyasa sáwífaꞌnanka minkáróꞌ-ááísáfésa éraiꞌe sénááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tíyááwemo siyáan-aai némpakenaꞌi ewaakénáꞌi isáíyana ímba tááꞌa íno. Miyán-kánáámó tínda mindá ímba seyaafá-tántááꞌó taiꞌáínda-waameꞌan-iye. ");
INSERT INTO auy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Fíꞌo-fiꞌon-aempaꞌ-waasi tiyánááwe. Moórá-kawaa-waasimo ésa moórá-kawaa-waasi timááraasafesa íyáfasine tíyáaro síyasamo ésa íyáfasinesa tiyánááwe. Fíꞌo-fiꞌom-barafaꞌa óraaꞌ-marima táíníye. Fíꞌo-fiꞌom-barafaꞌa aawaí táíníye. Miyán-tántááꞌó paápé ínaꞌa séꞌa seyaafá-tántááꞌó taiꞌáínda-kanaa ímba tiyáifo iyámpóímo matinkánae owanamó óraa-tiꞌo intembá umbai-kánáámó tínda minkánáá paápé iye seró. ");
INSERT INTO auy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Miyán-ááísáféꞌa káráwiyoro. Kawáá-wáásí kembiwí tíꞌmaesa óraaꞌ-waasifaꞌa mótinkesa aaifimbá maitinkésa ámáán-daumpaꞌa mótinkamesa kentáfésamo fasiꞌámaimo méraiyantafesa taꞌótoꞌmai tíꞌmaesa kámáni-oraaꞌ-waasifaꞌe kawáá-wáásífáꞌé mótinkesa aaí simátinkaiyaꞌa minórááꞌ-wáásí kesáái simátimenaawe. ");
INSERT INTO auy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aifaꞌá ásé-aai seyaafáꞌ-máráfákén-kwáásí simátímapaꞌa wéniyana ánaaemba seyaafá-tántááꞌó taiꞌáínda-kanaa tíníye. ");
INSERT INTO auy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Taꞌótoꞌmai aaimó simátínkénkaꞌa nóran-aaiya sénaumno-imayaa ímba óraaꞌa éꞌa ímba kentí imáyáafinken-aai sénááfo Maníkóní Ufaen-ámútánkó síyan-aai tááka tinkáínaꞌa minááí sénááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tuwímbai tífárawaawi tíꞌmai fíꞌowi timíyasa tínkamiyasa puwónááwe. Tifoísáímo ésa tíráámarimba tíꞌmai fíꞌowi timíyasa tínkamiyasa puwónááwe. Iyámpóísombo ésa tinófoi tíꞌmai fíꞌowi timíyasa tínkamiyasa puwónááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kentáféꞌo fasiꞌámaimo méraiyantafesa seyaafáꞌnánká tíyámba uwátinkanaawe. Ímbo ifátuwesamo kentáfésa fasiꞌámaimo méraiyawi taiꞌáínda-kanaaraꞌa Maníkó tíꞌmai kawepáꞌá métinkainiye. ");
INSERT INTO auy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ísu minááí simátimena séna ánaaemba sáwíꞌo íyan-tantaako uwófíꞌa íyam-barukaꞌa paápé íníye Ísu siyáiye. Kemá Mááka súne. Maanáúfáímó torausíyawi tááko péé sínaꞌa ísáaro súne. Ísu séna uwófíꞌo í-márúkáꞌá paápé ínasa awánáíyamba Yúndiyaa-marafaꞌo méraiyan-kwaasi omápata tuwaantantésa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ontaráꞌó méraiyan-kwaasi ímba naaúmpaꞌo iyíyamba óntama ifátuwesa úwoi tuwaantantésa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kísaufaꞌo méraiyan-kwaasi ímba naaópaꞌo tíyamba unáánkwátói ifátuwesa úwoi tuwaantantésa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tímúkaꞌ-inine umaran-íyámpóíwáráꞌ-íníné minkánáá sáwíꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tuwaantantéꞌo iyíyamba táwiꞌo índa-kanaa miyá únafo séꞌa Maníkómpáꞌá inaí seró. ");
INSERT INTO auy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Minkánáámó tínda óraaꞌ-umbai táíníye. Naaófáꞌá Maníkó maramó úmaronkaꞌe káféꞌwaraꞌe miyán-úmbáí-tántááꞌá ímba tiyáiye. Ánaaenkwaraꞌa miyán-úmbáí-tántááꞌá ímba tíníye. ");
INSERT INTO auy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Miyán-úmbáí-tántááꞌó índa-kanaa Fasiꞌaénkó ampáásé úmakaiye. Miyán-úmbáí-kánáámó ayáátáákaꞌo ínínkakaa seyaafáꞌ-wáásí ímba úwoi túnamai méraawisino. Maníkó wemparíꞌo úmakain-kwaasisafena imáyáa éna miyán-úmbáí-tántááꞌá ampáásé uráiye. ");
INSERT INTO auy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ampáásémó ínasa tuwímbai simátimesa sésa Maníkómó íyáfasinankaraiwai mifáꞌ-maafaꞌa méraiye síyaꞌo éꞌa ímba ísáaro. ");
INSERT INTO auy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tuwímbai paápé ésa karoꞌá sésa Maníkómó íyáfasisinkaraiwai úne síyasa tuwímbai karoꞌá sésa Maníkón-aaimo simátimundawi úne simátímaꞌmaesa níyamba ímbo awánen-kisau maésa Maníkómó wemparíꞌo úmakain-kwaasi karoꞌá simátinkanae sésa miyán-óráá-kísáú maénááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Miwísáféꞌa éraiꞌ-waasin-owe sefó séꞌa ímbo paápé uráankaꞌa aifaꞌá simátimumpo káráwiyoro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ísu minááí simátimena séna miyán-úmbáí-tántááꞌó tínda-kanaa taiꞌáínana aafáúgó kumeuꞌá ínana wíyónko ímba sán-káínana ");
INSERT INTO auy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","oꞌá wíyómpakemba kuntínana wíyónko toraꞌnááraꞌa ínaꞌa ");
INSERT INTO auy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","kemá waási úranko óraa-fasiꞌaenkwara sáwaraꞌa ainánká kúmónaꞌa suwánánááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wíyómpaken-kisau-waasi tiꞌmáráanasa Maníkómó wemparíꞌo úmakain-kwaasi seyaafáꞌ-máráfákémbá tíꞌmaesa moóráfimba túwaandu ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ísu minááí simátimena séna moórá naan-táígón-áwíꞌa fíki-taigontafeꞌa imáyáa úmai ísáaro. Asáómó agaínda awáné séꞌa áúꞌo sínda-kanaa kárikaꞌa tíníye sénááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Miyámó intembá kemó súnda-tantaaꞌa ínaꞌa awáné séꞌa kárikaꞌa kumíníye sénááwe. ");
INSERT INTO auy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Éraiꞌa simátime súne. Káféꞌo méraan-kwaasi tuwímbai ímbo pukáiyankaꞌa kemó súnda-tantaaꞌa paápé íníye. ");
INSERT INTO auy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wíyóne marawé taiꞌáínana kesáái ímbo taiꞌáínda úwoi waéꞌwaeꞌa íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ísu minááí simátimena séna kúmónda-kanaa aafáúmá waási ímba ísááwasa wíyómpaken-kisau-waasiwaraꞌa ímba ísááwaꞌa kemá Maníkón-ááninko ímba isáúnana kesifo weyáá ísaraiye. ");
INSERT INTO auy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kemó kúmónda-kanaa ímbo ísaraiyankaꞌa kumónaumpo káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Miyámó intenkáán-úmai maarán-ááín-iye. Moórá-oraako némpaꞌa wááu koméranae séna wení kísau-waasisafena kísau máéro séna tiꞌmáꞌmae wéwena ontaráꞌó kawáániwaintafena séna káráwiyuwo séna kóuraiye. ");
INSERT INTO auy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Naankóní aanáfómó tínda-kanaa ímbo ísáántemba kemó kúmónda-kanaama ímba ísaraafo káráwiyoro. Siyataróráꞌí wááwáiyaꞌi fenáíndararaꞌi nóꞌwaanaꞌi kumónaumno minkánáá ímba ísaraafo ");
INSERT INTO auy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","kentáféꞌa ímba imáyáamo wéiyankaꞌa kumúnafainifo wétoꞌmayaan-eꞌa simuꞌmáráaro. ");
INSERT INTO auy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kemó simátimunda seyaafáꞌ-wáásísáféꞌa súmpo káráwiyeꞌa méraaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ísu minááí simátimena naaófáꞌó Maníkó Yúndaa-waasi tíyótaimo í-tánómbá ímbo intóráín-tantaaꞌwara-pereti agáún-kanaa aúnkáraamba úwasa kae-kánáá úwoi mésa óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé sésa nóraumaisaawa Ísumba aúpáꞌá taꞌótoꞌmaisaawa tufuwónaumno. ");
INSERT INTO auy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Seyaafáꞌ-wáásí tíyááfainifo tanómbo kaufíyan-kanaarata ímba tufuwónaumne siyáawe. ");
INSERT INTO auy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Suwaná Ísu Pétáni-naopaꞌa koména moóráwigon-awiꞌa Sáímonini naaúmpaꞌa áúmo námombo kón-kwaasigoni naaúmpaꞌa ména tómbá wénowana moórá-ininko iyéna asaa-wiyúmbó úm-basawemba óraaꞌ-ontankakembo méyámbakaim-basawemba maimaéna iyúmba minánáféúmbá tafántuwena Ísu aꞌnómpímbá fatímarowasa ");
INSERT INTO auy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tuwímbai keáímbá sésa aaisambá aéésa nóra sénawa mimbásáwémbá úwoi fatíyankaiyo. ");
INSERT INTO auy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mimbásáwémbó fíꞌowi timénamo óraaꞌ-ontamba maiyénamo ímbo óntamo makáan-kwaasi tíméraambaniye sésa minínínkómbá aaisambá áúwana ");
INSERT INTO auy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ísu séna ifátuweꞌa ímba aaisambá aééro. Kaweꞌá asínkáíye. ");
INSERT INTO auy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ímbo óntamo máráán-kwaasi keséꞌa maéꞌmaeꞌa íyaꞌa túwaꞌnai ónae séꞌa túwaꞌnai ónááfo kemá keséꞌa marapáꞌá ímba maéꞌmaeꞌa ónaumne. ");
INSERT INTO auy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Minínínkó wení imáyáafinkemba kaweꞌá asínkáíye. Púwóndaraꞌa masawémba asinkésa utánáafo minínínkó éꞌa masawémba asínkáíye. ");
INSERT INTO auy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Éraiꞌa súmpo ísáaro. Kesí ásé-aai seyaafáꞌ-mápáꞌá simátimesa minínínkómó uwásínkáín-aai simátimiyasa táákaꞌa maránááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Súwana Ísuni kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasifinkemba moóráwigon-awiꞌa Yúndasi moórá-awiꞌa Ísakerioti óraaꞌ-amaan-kisau-waasifaꞌa wéna séna túwaꞌnai onaꞌá Ísumba taꞌótoranaawe súwasa ");
INSERT INTO auy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","isésa aamoí ésa sésa miyámó inda-méyámbá óntanta aménaumne suwaná nóraumaiya Ísumba aráátíménasawa taꞌótoranaao-imayaa ómbarena úmaena kuráiye. ");
INSERT INTO auy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yúndaa-waasi ímbo intóráín-tantaaꞌwara-pereti agáún-kanaa túntemba tíyótaimo í-tánón-kánáá sipisípi-araaꞌa tufúꞌmai káúfúnkaꞌa wení kísau-waasi Ísumba taáísai esa sésa tíyótaimo í-tánómbá nááfataawa kaufónaumno suwaná ");
INSERT INTO auy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","kaeꞌá tiꞌmaréna séna Yérúsaremu-naopaꞌa wíyana moóráwigo nonánámó maimaé wíndawimba arááíwáékaiyo. ");
INSERT INTO auy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wemó naaúmpaꞌo iyíndafaꞌo naankón-afowámó mérainakai kosimámekai óraako áísai ena séna kesí kísau-waasiseꞌa náán-aempara tíyótaimo í-tánómbá nánaumno wésiye kosimámékaiyo. ");
INSERT INTO auy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wemá afófumayaaꞌ-nankoni óraaꞌ-aempaꞌa aráátiminiye. Kúfuꞌo uwándáíyan-tantaaꞌa mimpímbá wéraiye. Seyaafá-tántááꞌá toꞌmayaa úmarekai minkáꞌá kausínkáakaiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","mindárai isésarai Yérúsaremu-naopaꞌa wésarai Ísumo sún-tantaaꞌa wérowasarai minkáꞌá tanómba kauwánkaraaye. ");
INSERT INTO auy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tanómba kaumakóyasa fenómpinkaꞌa Ísu wení kísau-waasise mindáúmpáꞌá imésa ");
INSERT INTO auy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","tómbá wémandesa uwaná Ísu séna kempínkémbá moóráwigo keséꞌa tómbó wénaiwai kembá namuro-wáásí aráátiminiye súwana ");
INSERT INTO auy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tirunkó umbaí tówasa moórá-mora áísai esa sésa kewáꞌíyo símaesa kuwaná ");
INSERT INTO auy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ísu séna moóráwigo wení tón-ayai maimaéna keséꞌo moórá-taufapimba túꞌmaimo náíndawi wemá kembó namuro-wáásímó aráátimindawin-iye. ");
INSERT INTO auy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naaófáꞌá Maníkón-aai aúfáífimba agaimaréna séna waási úranko puwíníye siyáintemba póꞌa púwónana namuro-wáásímó aráátimindawi sáwí-meyamba máíníye. Wembó ímbo maꞌánkaraankakaa kaweꞌá isinó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Súwasa tómbá wénowana Ísu péréti maisoréna Maníkómpáꞌá súwiyo séna tafámbai tiména séna mindá kesún-ifo maimái naaró séna ");
INSERT INTO auy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ándá-aran-dombo wéron-anafeumba maisoréna Maníkómpáꞌá súwiyo séna timúwasa seyaafáꞌá nowaná séna mindá kesí naaén-iye. ");
INSERT INTO auy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kesí naaemá sáwí-waasisafena kumínda póna Maníkó keséꞌa kááísamai méraiwae séna mináú-ááí símai kááísamakaiye. ");
INSERT INTO auy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Simátimeꞌa súne. Anekaꞌá ándá-aran-domba ímba nánaumpo Maníkó wení waásimo kawáánipaꞌa méꞌa ándá-aran-domba aú-nomba nánaumne Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Maníkóntáfésa ísámai imá simásuwesa mindáúmpáꞌá tuwésa Órífi-omapaꞌa iyáawe. ");
INSERT INTO auy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Órífi-omapaꞌa imérowana Ísu simátimena séna Maníkón-aai aúfáífimba agaimaréna séna Maníkó séna sipisípiyaꞌo kawáániwaimba tufúwónasa sipisípisomba wété ónááwe Maníkó siyáiye siyáimba póna tááꞌa ínaꞌa siyuwéꞌa wété ónááwe. ");
INSERT INTO auy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Énifo púwónasa utámaraiya íyáfasineꞌa kentí aifaꞌá Káríri-aemapa konaꞌá kesínaaemba kónááwe Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pítaa séna seyaafáꞌnánká auwésa wété ónááfo kemá ímba miyá ónaumne súwana ");
INSERT INTO auy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ísu séna éraiꞌa simáme súne. Káféꞌ-noꞌwaamba kokórigo ímba kaeꞌ-íꞌa ááimo siyáindaraꞌa emá kaumbo-íkáꞌá kentáfé sé ímbo awánáúnda-waasin-iye sínone Ísu Pítaantafena súwana ");
INSERT INTO auy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pítaa óraakaꞌa séna entéꞌo sínkamonae íyaꞌo éꞌa ímba auwéꞌa kónaumne súwasa wení kísau-waasi seyaafáꞌá miyá simásaraawe. ");
INSERT INTO auy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Seyaafáꞌá miyá simásuwesa Ísuwe wení kísau-waasiye taaiyámófaꞌa áwíꞌa Kétésémánifaꞌa komésa Ísu simátimena séna maankáꞌ-méraiyaꞌa Maníkómpá inaí kosenó séna ");
INSERT INTO auy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pítaane Yémísine Yónine tíꞌmaena komérowana umbai-tántáákó arumbá sáwíꞌa úwana ");
INSERT INTO auy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","simátimena séna kesirunkó umbaiséꞌa taisá póꞌa púwóraantamba wéune. Maankáꞌ-méꞌa káráwiyoro séna ");
INSERT INTO auy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","tiyuwéna ewaaꞌá wéna Maníkó óraakon-iye séna maraꞌá kumbéna inaifínkémbá séna kesifóo seyaafá-tántááꞌá kanaaꞌá wéonda po kanaán-iye. Ewé sémo e maanúmbáí-tántááꞌó kempáꞌó tínda maisiyuwé énifo ímba kesí imáyáan-ifo ení imáyáa arááíwáéno Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ísu inaí simásuwena wení kísau-waasiyaufaꞌa téna tatuwánómba tún-kwaigurówana tatúséna Pítaantafena séna Sáímoniyo aún-kwaiguré ímba kanaa kárikaꞌa káráwiye méraane. ");
INSERT INTO auy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Waántáwanko tísai úmai isánae-aai kempáꞌá sifónifo Maníkómpáꞌá inaí seró. Imáyáago ewé sisaná áúgo umbaimó wétaimba mindá aúgáfaaꞌa wéiye simátimena ");
INSERT INTO auy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","anekaꞌá tiyuwéna ewaaꞌá wéna súntemba Maníkómpáꞌá inaí kosimásuwena ");
INSERT INTO auy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","wení kísau-waasifaꞌa téna tatuwánómba tún-kwaigurówana tatúsúwana túgáfaateꞌa úwasa nóran-aaiya anondáá ímba simámuwana ");
INSERT INTO auy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tiyuwéna inaí kosimásuwena kouweréna minkáúmbóráúsáféna séna túmó waiguráamba éꞌanifo kembá waási úrankomba sáwíꞌo on-kwáásí aráátiminasa taꞌótoraiyan-kanaa wétifo ");
INSERT INTO auy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","íyáfasinewata wétiyapata konó. Kembó aráátimindawi wétiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ísu minááí wésuwana wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasifinkemba moóráwigon-awiꞌa Yúndasi túmba weséꞌa sáwífaꞌ-waasi taánáínkwara paepáénkwaraꞌa maimaé tumbá óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé Yúndaa-oraaꞌ-waasiye miwí tiꞌmárówasa tumbá ");
INSERT INTO auy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ááéma Yúndasi Ísumbo aráátimindasafena simátimena séna aaweyáámó uwánkáandawimba taꞌótoꞌmaeꞌa káráwimaeꞌa koró siyónkaꞌa ");
INSERT INTO auy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","póna Yúndasi Ísumpaꞌa téna séna óraakoo méraano wésena aaweyáá wéuwankowasa ");
INSERT INTO auy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","weséꞌo tuwáí Ísumba taꞌótórówana ");
INSERT INTO auy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ísuni kísau-waasifinkemba moóráwigo paepáéꞌa maimaéna aifaꞌ-ámáán-káwáágóní kísau-waasigon-ááꞌa fagáúsuwowana ");
INSERT INTO auy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","tun-kwáásísáféna séna kentáféꞌa umén-kwáásín-iye séꞌa póꞌa taánáínkwara paepáéꞌwaraꞌa maimaéꞌa kembá taꞌótoranae séꞌa wétewe. ");
INSERT INTO auy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sáwífa-kanaa óraaꞌ-amaan-daumpa keséꞌa méꞌa kesááimo wésimatimundaraꞌa ímba kembá taꞌótokaawe. Naaófáꞌá Maníkón-aai aúfáífimbo agaimakáan-aai kembó miyámó uwásínkéneꞌa wétewe súwasa ");
INSERT INTO auy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","wení kísau-waasi seyaafáꞌá inkaisésa auwésa wété uwasá tun-kwáásí Ísumba áíꞌmaesa kuwaná ");
INSERT INTO auy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","moórá-ifoꞌ-waasigo ampanta aantemba káráꞌumaena Ísun-ánaaemba wéguwasa wembá taꞌótórówana ");
INSERT INTO auy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ampantá awátuwena wátói-iyaimba kóuraiye. ");
INSERT INTO auy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kóúwasa Ísumbo taꞌótórówi áíꞌmaesa aifaꞌ-ámáán-káwáágóní naaúmpaꞌa móankesa mindáúmpáꞌá óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye ámáámbo sun-kwáásíyé túwaandu urón-daumpaꞌa móankowana ");
INSERT INTO auy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pítaa tínaaemba nénkaꞌo témomba aifaꞌ-ámáán-káwáágóní máápaꞌ-ontafinkemba iyéna naamaáífa iména i-wáásísé iyaráꞌá koména iyá wégaufiye. ");
INSERT INTO auy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pítaa iyá wégaufuwasa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye seyaafáꞌnánká Ísumba tufuwíyana puwínda-aaigoni áwáu saafá uwaná ímba wérowasa ");
INSERT INTO auy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ísuntafesa mósimesi-aai sésa ímba moórá-aai suwasá ");
INSERT INTO auy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","tuwímbai íyáfasinesa karoꞌá sésa ");
INSERT INTO auy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","wemó sisatáámó isáúndasa óraaꞌ-amaan-damba waásimo uráan-damba tawísísuweꞌa kaumbo-kánáá maisuwéꞌa waásimo ímbo íyan-damba ónaumne siyáiye suwasá ");
INSERT INTO auy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","minkwáásí ímba moórá-aai suwaná ");
INSERT INTO auy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","aifaꞌ-ámáán-káwáágó íyáfasinena Ísumba áísai ena séna simánkáán-aai anondáá ína sínono súwana ");
INSERT INTO auy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ísu iséna ímba aaí súwana aifaꞌ-ámáán-káwáágó áísai ena séna kesáámó áwíꞌo mósá maráúndawin-ááninko e Maníkómó íyáfasinankaraiwai Káráísitiyaꞌonai simásimiyo súwana ");
INSERT INTO auy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ísu séna kemá úne. Suwánenaꞌa kemá waási úranko Maníkó fasiꞌaénkón-ayáánúrapaꞌa fasiꞌaén-áémpá iméꞌa ainánkáꞌá kumónaumne Ísu súwana ");
INSERT INTO auy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","aifaꞌ-ámáán-káwáágón-arunko sáwíꞌa úwana wení unáánkwátói tafétuwena séna Maníkómbá karaánááꞌa ankéna wesáféna simbá póta minááísáféta aaifimbá maenkéta fíꞌon-aaimo simánkáámba saafá únda póta ifátá tuwéta ");
INSERT INTO auy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Maníkómbó símaimo sáwíꞌo uwánkáíntafeta nórasaawa ónaumno súwasa sáwíꞌan-ifo tufuwíyana puwíno sésa ");
INSERT INTO auy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ísumba tuwiyáái wiꞌankésa aúrankaꞌa ampantasámbá káátamakesa wétufuwesa sésa esáfé sé Maníkó íyáfasisinkaraiwai únemo séndawi ómpo kemá nááwa tufúnái simásimiyo suwasá i-wáásí áíꞌmai tiyáántamba tufúkáawe. ");
INSERT INTO auy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pítaa naamaáífa ména iyá wégaufuwana aifaꞌ-ámáán-káwáágóní kísaumo maún-arasigo téna Pítaamba taawánéna séna Ísu Násaretifakewiyeꞌo maéndawi óne súwana ");
INSERT INTO auy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","emó sénda-aai sááko ímba kaweꞌán-iye simásuwena máápaꞌ-ontafimba komérowana ");
INSERT INTO auy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","minárásígó anekaꞌá awánéna méron-kwaasisafena séna efíwáni waásifinkewin-iye súwana ");
INSERT INTO auy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","anekaꞌá Pítaa séna ímbaniye simásuwena mérowasa kárikaꞌa maémómba Pítaantafesa sésa éraita súne. Kárírifakewi po wení kísau-waasifinkewi óne suwaná ");
INSERT INTO auy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pítaa aikaꞌ-maréna séna karoꞌ-ááímó wésenanamo éna Maníkó sínkaminiye. Sewímbá ímbo awánáúnda-waasin-iye súwana ");
INSERT INTO auy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","kokórigo anekaꞌá áái súwana Pítaa Ísumo simámakon-aai áákaꞌ-maréna miyá siyónkaꞌa kokórigomo kaeꞌ-íꞌo ááimo ímbo siyáindaraꞌa emá kaumbo-íkáꞌá kentáfé sé ímbo awánáúnda-waasin-iye sínone siyónkaꞌa minááí áákaꞌ-maréna áfááraumai ifiꞌá taráiye. ");
INSERT INTO auy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Úwasa aafáúmó íyáúsunkaꞌa óraaꞌ-amaan-kisau-waasiye Yúndaa-oraaꞌ-waasiye ámáámbo sun-kwáásíyé mimbórá-ááí símai tarímaresa Ísumba ayáánkaꞌa káráꞌumaresa áíꞌmaesa Rómu-kamani-kawaagon-awiꞌa Páíratimpaꞌa kuwaná ");
INSERT INTO auy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Páírati Ísumba áísai ena séna Yúndaa-waasiti kawáágówá ónó súwana Ísu séna éꞌa séne súwasa ");
INSERT INTO auy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","óraaꞌ-amaan-kisau-waasi fíꞌo-fiꞌon-aaisafesa aaifimbá maénkówana ");
INSERT INTO auy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Páírati Ísumba áísai ena séna sáwífaꞌ-aai wésimankaafo anondáá ína moórá-aai sínono súwana ");
INSERT INTO auy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ísu iséna ímba anondáá súwana Páírati sáwífaꞌ-imayaa uráiye. ");
INSERT INTO auy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Naaófáꞌá Maníkó Yúndaa-waasi tíyótaimo í-tánón-kánáá túntemba Rómu-kamani-kawaago séna seyaafáꞌnánká túwaandu urésa aamoí ésa ándáfaꞌo mérain-kwaasigon-awiꞌa síyaꞌa faúꞌauwaano séna minkánáá miyáumai ándáfaken-kwaasi faútínkáíye. ");
INSERT INTO auy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Minkánáá moóráwigon-awiꞌa Párápási ándáfaꞌo maúmba ááéma tuwímbai kámáni-waasise tíyónkaꞌa wemá moóráwigomba tufúwana puwúwasa ándáfaꞌa ánkarowana mérowasa ");
INSERT INTO auy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","sáwífaꞌ-waasi túwaandu urésa Páíratintafesa sésa moóráwigomba faúꞌankaao suwaná ");
INSERT INTO auy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Páírati imáyáa éna séna óraaꞌ-amaan-kisau-waasi Ísuntafesa ímba óraaꞌ-waasi-iꞌa ínkwae sésa taꞌótoꞌmaesa kempáꞌá tiyáawe séna tísai ena séna Yúndaa-waasiti kawáágóná faúꞌankanaumno súwasa ");
INSERT INTO auy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","óraaꞌ-amaan-kisau-waasi úwoi-waasi sáwífaꞌnanka waꞌwisésa sésa Ísumba ímba faúꞌankainompo Párápásimba faúꞌankaao simáméro suwasá isésa minááí simámúwana ");
INSERT INTO auy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Páírati séna Ísumba Yúndaa-waasiti kawáágó iyémó sewímbá nóra ónaumno súwasa ");
INSERT INTO auy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","óraaka sésa aaraa-táíyáꞌá tufíyana puwíno suwaná ");
INSERT INTO auy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Páírati séna nóra-sawira uráiyo súwasa óraakaꞌ-oraakaꞌa sésa aaraa-táíyáꞌá tufíyana puwíno aantemba suwaná ");
INSERT INTO auy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Páírati miwí táái ewé senasá aamoí uwásinkaiwae séna Párápásimba faúꞌankena i-wáásí simátimuwasa Ísumba áwíyandasamba áwiyonkuꞌ-nowana Páírati séna áíꞌmae aaraa-táíyáꞌá mátufiyana puwíno séna Ísumba i-wáásí tímakaiye. ");
INSERT INTO auy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ísumba i-wáásí timúwasa áíꞌmaesa kámáni-waasiti naaúmpaꞌa móankesa seyaafáꞌ-í-wáásí táántowasa tamésa ");
INSERT INTO auy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","naae-únánkwátói óraaꞌ-waasiti unáánkwátóin-iye sésa Ísumba uwánkesa óraaꞌ-waasiti kámoꞌan-iye sésa áwíyanda owepámai Ísu aꞌnómpímbá wiyankésa ");
INSERT INTO auy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","karaánááꞌa ankésa moórá-mora kífaesa sésa Yúndaa-waasiti kawáágó óne sésa táúntamba aꞌnómbá wétufamesa tuwiyáái wiꞌankésa ");
INSERT INTO auy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","karaánááꞌa ánkásuwesa naae-únánkwátói faútuwesa wení unáánkwátói uwánkesa tufíyanamo puwíndafaꞌa áíꞌmaesa kuráawe. ");
INSERT INTO auy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","I-wáásí Ísumbo áíꞌmae kumbá moóráwigo Sáíríni-naopakewin-awiꞌa Sáímoni wemá Árékísándaae Rúfaasinteti tifowá Yérúsaremu-naoꞌ-ampaꞌa túwasa i-wáásí taꞌótoresa Ísumbo tufíyan-aaraa-tai áúwaataꞌankesa sésa áwaꞌnai úmae tiyó suwaná miyá úwasa ");
INSERT INTO auy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","marésa moórá-maragon-awiꞌa Kórígótaafaꞌa wésa mináwíkóní áwáu aꞌnónayaantapaꞌemo supaꞌá wésa ");
INSERT INTO auy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ándá-aran-domba maiyésa áíꞌa taiꞌáínkwae sésa ikamó fain-tántááꞌá mimpímbá marésa Ísumba ámúwana ímba naráiye. ");
INSERT INTO auy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ísu ímba nówasa áíꞌmaesa aaraa-táíyáꞌá aíyayaampimba mátufusumaresa wení unáánkwátói maénae sésa ááfésa tíyáananasa nááwamo íyáákaindawi máíníye sésa miyá ésa ");
INSERT INTO auy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","aafáúgómó áyanaꞌo kain-kánááráꞌá tufúmba ");
INSERT INTO auy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ísumbo tufúwanamo puwún-aaigoni áwáu aúfáífimba agaimarésa sésa Ísu Yúndaa-waasiti kawáágón-iye agaimarésa aaraa-táíyáꞌá mósá marésa ");
INSERT INTO auy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","uméntéꞌo uyan-kwáásíyáí tíꞌmaesa Ísuni séfasefaꞌ-arausampaꞌa aaraa-táíyáꞌá tufúsúmarowana ");
INSERT INTO auy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","naaófáꞌá Maníkón-aai aúfáífimba agaimaréna séna wemá sáwíꞌo on-kwáásímo máépaꞌa méraisasa awánaraawe agaimaréna siyónka pósa miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aaraa-táíyáꞌá tufúsúmarowasa tuwímbai tésa tiyáámba tóipimba fáákesa timántákáí faꞌankésa karaánááꞌa ankésa sésa úwé emá séma óraaꞌ-amaan-damba tawísísuweꞌa kaumbo-kánáá maisuwé anekaꞌá ónaumne siyáampo ");
INSERT INTO auy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","esáfé enáú áwaꞌnai ema eyááríkaꞌa taaiyakémbá taútuwe marapáꞌá kumuwó suwasá ");
INSERT INTO auy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","miyáumai óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé sésa fíꞌowi túwaꞌnai ena wesáféna wenáú ímba kanaaꞌá áwaꞌnai íníye. ");
INSERT INTO auy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Maníkómó íyáfasisinkaraiwai éꞌa Ísareri-waasiti kawáágó únemo séꞌéímba póna éraiꞌo séꞌéíndamo éna weyááríkaꞌa taaiyakémbá kumínata awáné séta éraiꞌa Maníkón-áánimban-iye sénaumne suwasá miwímó suntembá uméntéꞌo uyan-kwáásíyáí séfasefaꞌ-arausampaꞌo aaraa-táíyáꞌó tufúsúmarowiyai Ísumba karaánááꞌa ánkaraaye. ");
INSERT INTO auy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ísumba karaánááꞌa ánkówana wááwái seyaafáꞌ-áémpáꞌá túnkwéna aafáúmó taenónkaꞌa túnkúmba ");
INSERT INTO auy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ísu óraaka Yúndaa-waasi-taaifinkemba séna eri eri rama sapakataniyemo súmba maará siyáiye. Maníkó kesí Maníkóo nóra séwa siyuwááno súwasa ");
INSERT INTO auy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","minkáꞌó méron-kwaasi isésa tuwímbai sésa naaófáꞌó Maníkón-aaimo simátímakaiwaimba Íráiyaamba wéaantaiye suwaná ");
INSERT INTO auy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","moóráwigo awaantanténa faru-táéná maimaéna ándá-aran-domba ika-nómpímbá tuꞌmaéna ofiyen-táemopimba sinúfaimaena náínkwae séna Ísun-óikaꞌa mósá maréna séna Íráiyaa kuména taaiyakémbá kutaútuwaini ína taútuwainiyo séta amuꞌmaréta méraumne súwana ");
INSERT INTO auy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ísu óraaka séna puwúwana ");
INSERT INTO auy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","óraaꞌ-amaan-daumpaꞌo ampanta-óntámó úmakomba sanaan-áyáíyákémbá itaféꞌmaena marapáꞌá mútafetena kaesé uwágúwana póna Maníkómpáꞌó iyíyan-amba wiꞌmakáiye. ");
INSERT INTO auy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ísu óraakaꞌo sénamo puwúmba i-wáásítí kawáágó awánéna séna éraiꞌa wemá Maníkón-ááninkon-iye siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Minááímó súmba sáwífaꞌ-inimba awánánae sésa tumbá némpaꞌa tamésa awánaraawe. Miníníntómpínkémbá moórá-inimba Mágátáraa-naopaken-ininkon-awiꞌa Máríyaa úwana moórá-inimba ifóꞌ-Yémísinte Yósisinte tinówan-awiꞌa Máríyaa úwana moórá-ininkon-awiꞌa Sárómi ");
INSERT INTO auy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","miyáumai-inimba Ísumo Káríri-aempaꞌa núpaꞌo wembó arááíwaꞌmaesamo áwaꞌnai úmae kuráan-inimba Ísu Yérúsaremufaꞌo túmba miníníntómbá tésa aaraa-táíyáꞌó tufúsúmaronka némpaꞌa tamésa awánaraawe. ");
INSERT INTO auy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Miníníntómbá tamérowana Yúndaa-waasi ámáán-aaimo ísón-kanaa aafáyáaraamba úwana káfékaamba fenómpinkaꞌa moóráwigon-awiꞌa Yósepi Árímátíyaa-naopakewi ");
INSERT INTO auy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","wemá óraaꞌ-waasi éna kaweꞌ-wáásí éna Maníkó wení waási kawááníníye séna amuꞌmakówi ímba áátafena úmba Páíratimpaꞌa téna Ísun-áúma utánáifo simiyó súwana ");
INSERT INTO auy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Páírati imáyáa éna éra pukáiyo séna i-wáásítí kawáágómbá áántena séna Ísu éra pukáiyo súwana ");
INSERT INTO auy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ewé éꞌa pukáiye simámuwana Páírati séna kanaámpó Ísun-áúma máínone súwana ");
INSERT INTO auy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yósepi aú-ampanta komaimaé tiyéna Ísun-áúma aaraa-táíyákémbá tataúꞌmai minámpántáfímbá asááúmaena maimaéna aúsámakon-ontan-aifimba mámarena óikaꞌa óraaꞌ-ontantamba awááúwasuwena kúwana ");
INSERT INTO auy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Máríyaa Mágátáraa-naopaken-ininko úwana araámáó Yósisin-anówaeꞌa mésarai Ísumbo utámaromba taawánésarai kurááye. ");
INSERT INTO auy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yúndaa-waasimo saagon-kánáá taiꞌówasa kaumbo-ínímbá Máríyaa Mágátáraa-naopaken-ininko úwana araámáó Yémísin-anówa úwana Sárómi úwasa miyáumai-inimba Ísun-áúraꞌa asaa-wiyúm-básáwémbá máaꞌankanae sésa ");
INSERT INTO auy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ááéma aafáúmó íyáúsunkaꞌa mimbásáwémbá maimaésa Ísumbo utámakopaꞌa kumbá ");
INSERT INTO auy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","aampaꞌá wéwesa sésa óikaꞌo awááúwasukaan-ontamba óraaꞌ-ontamba póna nááwa súwaꞌnai énasaawa óikaken-ontamba waétuwainiyo sésa awánomba minóntámbá éꞌa fawátukowasa awánésa ");
INSERT INTO auy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","minóntán-aifimbo íyúmba moórá-ifoꞌ-waasi waén-únánkwátóiwaraꞌ-waasigo minkáꞌá mérowasa awánomba tááꞌa úwana ");
INSERT INTO auy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","simátimena séna ímba tááꞌa íno. Ísumba Násaretifakewimba aaraa-táíyáꞌá tufúwówanamo pukáiwaimba taawánánae séꞌo wétemba pukáimpinkemba íyáfasinena kówéna ímba maankáꞌá méraifo utámakaampimba iawánéꞌa ");
INSERT INTO auy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","wení kísau-waasiye Pítaane kosimátime séꞌa Ísu siyáintemba pukáimpinkemba íyáfasinena kentí aifaꞌá Káríri-aempaꞌa wínaꞌa koawánánááwe. Minááí kosimátíméro súwasa ");
INSERT INTO auy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","minóntán-aima tuwésa tááꞌa éna tinekembá tataꞌá úwasa tuwaantantésa wésa tááꞌa úntafesa minááí ímba kosimátímakaawe. Mááka kemó súnda-aai taíꞌáiye. ");
INSERT INTO auy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sondaaráꞌá ááéma Ísu pukáimpinkemba íyáfasinena aifaꞌá Máríyaa Mágátáraa-naopaken-ininkon-aúrankaꞌo paápé úmba ááéma Ísu minínínkón-arumpinkemba afakaeté-sawi-amutambo maiyáúkain-ininkon-aúrankaꞌa paápé úwana ");
INSERT INTO auy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","awánéna wení waási ifiꞌó wétopaꞌa kosimátimuwasa ");
INSERT INTO auy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ísumo aúnarowana minínínkómó awánón-aai simátimumba isésa ímba ísámai kaweꞌá uráawe. ");
INSERT INTO auy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Minkákémbá kaeꞌ-wáásí némpaꞌ-ampaꞌa wéguyana Ísu fíꞌon-kwaasiyaamba úmaena minkáéꞌnárai túrankaꞌa paápé úwasarai awánésarai ");
INSERT INTO auy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","kouwerésarai Ísuni waási tasimátímúwasa ímba ísámai kaweꞌá uráawe. ");
INSERT INTO auy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Minkákémbá Ísuni kísau-waasi sísamaifakemba moórá kumbaimái-waasi tómbá wénowana Ísu paápé úwasa awánowana Ísu aaisambá tiyéna séna kemá pukáundafinkembo íyáfasinkaunda suwánaresa simátíméwaꞌa iséꞌa sirumbá wéfaiyaraawe séꞌa tuwarónaawaro wéowe. Simátímén-aaisafeꞌa éraiꞌemo seráámbá ímba éraiꞌe siyáawe simásuwena ");
INSERT INTO auy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","séna kesí ásé-aai seyaafáꞌ-máráfáꞌá simátímapaꞌa koró. ");
INSERT INTO auy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kesááisafesa éraiꞌe sésa kenkáꞌá timankúnkúmba ésa nombó maíyana Maníkó miwí sáwíꞌo úmaimo mérempinkemba faútinkainifo kesááisafesa ímba éraiꞌe sésa timankúnkúmbo íyawi Maníkó aaifimbá maitinkáíníye. ");
INSERT INTO auy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kesááisafesa éraiꞌe sésa kenkáꞌá timankúnkúmbo íyawi ímbo awánaan-kisau maésa kesí fasiꞌaéntámbá waási tirumpinkémbá sáwí-amutamba maitiyuwésa fíꞌon-aaifinkemba sésa ");
INSERT INTO auy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","waaifaimbó taꞌótoraiyana unkutíndamo ésa ímba puwésa puwíyan-dombo náíyambo ésa ímba puwésa tíꞌo índa-waasimo tiyáámbo taꞌótoraiyamba asófatinkanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Fasiꞌaénkó Ísu minááí simásuwowana Maníkó Ísumba áíꞌmaena wíyómpaꞌa móankowana Maníkón-ayáánúrapaꞌa fasiꞌaén-áémpáꞌá mérowasa ");
INSERT INTO auy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ísuni kísau-waasi seyaafáꞌ-máráfáꞌá ásé-aai simátímapaꞌa kuwaná Fasiꞌaénkó túwaꞌnai úwasa waási ímbo awánaraan-kisau maúwasa awánésa sésa maanááímó simásíménta éraiꞌ-aain-iye siyáawe. Minááí taíꞌáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Óraako Tíófíráasiyo moórá-aai sénaumpo isaaó. Maníkó kentááfímbá paápé uráimba aifaꞌó awánaraan-kwaasi mintántáákón-aai simátímaꞌmaesa iyáamba isasá kentáá wésimasimewe. Sáwífaꞌnanka minááí éraiꞌ-aai agaimakáamba minááígóní áwáu kaweꞌ-úmai iséꞌa aifakén-ááíyé afufumpinkén-ááíyé ánaaenken-aaiye agai-amúne. Ísaraanda-aai éraiꞌ-aaiyaꞌi karoꞌ-ááíyáꞌiyompo mindásafeꞌa maanáúfáí agai-amúmpo toráumai isaaó. ");
INSERT INTO auy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yúndiyaa-marafaken-kawaagon-awiꞌa Éroti méron-kanaafimba moóráwigon-awiꞌa Sékáráíya Ápáísaani akún-ándáfákén-kwáásí ména Maníkóní ámáán-daumpaꞌa kísaumo maúwai mérowana awaainínkón-áwíꞌa Írísápéti Éronini akún-ándáfákén-ínínkó Maníkóní ámáán-daumpaꞌa kísaumo máún-kwaasiti akún-ándáfákén-ínínkó úwasarai ");
INSERT INTO auy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Maníkón-aúrankaꞌa minákwáꞌá kaweꞌ-úmai mésarai Fasiꞌaénkón-aráái waésarai wení ámáámba kaweꞌ-úmai isésarai ");
INSERT INTO auy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","age-ínímbá ména iyámpóí-íyaimba mésarai wauránáráámba káguraaye. ");
INSERT INTO auy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Wauránáráámba káguyasa Sékáráíyaani akúmbá Maníkóní ámáán-daumpaꞌa kísau maésa miyá úmae iyésa miwítí kísau tuwínkaaꞌ-ésa Sékáráíyaamba íyáfasinankowana asaa-wiyúmbó índa-tantaaꞌo agaíndasafena Fasiꞌaénkóní óraaꞌ-amaan-daumpaꞌa iyúwasa ");
INSERT INTO auy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","asaa-wiyúmbó índa-tantaaꞌo agáí-kánáá seyaafáꞌá Yúndaa-waasi máápaꞌa mésa Maníkómpáꞌá inaí wésuwana ");
INSERT INTO auy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sékáráíya Fasiꞌaénkóní óraaꞌ-amaan-daumpaꞌa iyúwana asaa-wiyúmbó í-tántááꞌó agáí-táárégóní ayáánúrapaꞌa wíyómpaken-kisau-waasigo paápé úwana ");
INSERT INTO auy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sékáráíya awánéna kantúmba maréna inkaisúwana ");
INSERT INTO auy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","wíyómpakewi séna Sékáráíyaao ímba inkaisuwó. Maníkómpáꞌó inaimó sénda ísáíntafena enawaainínkó Írísápéti iyámpói máínífo miníyámpóígón-áwíꞌa Yóniye siyó. ");
INSERT INTO auy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Maꞌankáínana enarunkó aamoí ínasa fíꞌon-kwaasiwaraꞌa aamoí ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Maꞌankáíndaraꞌa Maníkóní Ufaen-ámútánkó miníyámpóígón-arumpimba óraaꞌa ínana ándá-aran-done uwóíꞌo on-dóné ímba náíno. Maníkón-aúrankaꞌa wenáwíꞌa óraaꞌa íníye. ");
INSERT INTO auy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wemá óraaꞌa éna Ísareri-waasisomba tafisínasa miwítí Fasiꞌaénkó Maníkómpáꞌá anekaꞌá ténááwe. ");
INSERT INTO auy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wemá Maníkón-aaimo simátímakowin-awiꞌa Íráiyaa uráintemba fasiꞌámai ména Fasiꞌaénkóní aifaꞌá wéna tifoísáíye tíráámarine tafisínasa taankarotámai méranaawe. Aaimó ímbo isáíyan-kwaasi tafisínasa arupísemo on-kwáásímó íyantemba ésa kaweꞌ-ímáyáá ónááwe. Miyáumai Fasiꞌaénkómó kumíndasafena wení waási toꞌmayaa uwátinkainiye wíyómpakewi súwana ");
INSERT INTO auy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sékáráíya séna kesuwaainínkóekai wauránáráámba káguraufo nóra séra minááísáféꞌa éraiꞌe sénaumno súwana ");
INSERT INTO auy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","wíyómpakewi séna kemá Képarieri méꞌa Maníkón-aúrankaꞌa méraunana kaweꞌ-ááí siména siꞌmáráísaꞌa músimamundasafe ");
INSERT INTO auy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ímba éraiꞌe sémpo emá ímba aaimó sindá mérenana ánaaen-kanaa kemó súnda-tantaaꞌa paápé ína kaweꞌ-úmai aaí sínone súwasa ");
INSERT INTO auy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","máápaꞌo méron-kwaasi Sékáráíyaamba amuꞌmatuwé mésa sésa óraaꞌ-amaan-daumpaꞌa nóintafenawa ayáátáákaꞌa méraiyo wésuwana ");
INSERT INTO auy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","máápaꞌa kuména ímba aaí súwasa óraaꞌ-amaan-daumpaꞌa kaainkáámbá awánaraiye suwaná ayáán-kwaameꞌnaameꞌa wéena ímba aaimó súmba ména ");
INSERT INTO auy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","wení kísau-kanaa taiꞌówana wení naaópaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Komérowana awaainínkó Írísápéti ámúꞌa paápé éna aúpáꞌá séfataase-wiyomba maéna ");
INSERT INTO auy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","séna Fasiꞌaénkó kaweꞌá uwásinkena miyámó uráintafeꞌa aamoí éꞌa ayáátáákaꞌa iyámpói ímbo matinkáúnda misígáémó imbá taíꞌáiye Írísápéti siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Írísápéti ámúkaꞌa ména afaꞌmóráe-wiyomba maisuwówana Maníkó wení kísau-waasigon-awiꞌa Képarierimba wíyómpakemba aiꞌmarówana Káríri-marafaꞌa Násareti-naopaꞌa kuména ");
INSERT INTO auy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","moórá-arasigon-awiꞌa Máríyaambo simámindasafena kunkáiye. Minárásígó ímba waaí maiyón-arasigo Téfítin-andafaken-kwaasiyaꞌa áwíꞌa Yósepinkaꞌa aaí tarímarowana ");
INSERT INTO auy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","wíyómpakewi Máríyaampaꞌa kuména séna méwaꞌono. Maníkó aamoí uwánkena eséꞌa méraiye simámuwana ");
INSERT INTO auy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","óraaꞌ-imayaa éna séna minááígóní áwáu nóran-aaisafenawa síyó súwana ");
INSERT INTO auy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","miwá séna Máríyaao Maníkó aamoí uwánkáífo ímba ááꞌa íno. ");
INSERT INTO auy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ámúꞌo kaumáímo iyámpóímo maꞌanké áwíꞌa Ísuwe simánkainone. ");
INSERT INTO auy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wemá óraaꞌa éna óraaꞌ-waasi-iꞌa ínasa íyáákamai-Fasiꞌaenkon-ááninkon-iye sénááwe. Aíwáꞌnágon-awiꞌa Téfítimo kawáá-kísáúmó maiyáintemba Maníkó kawáá-kísáú amínana ");
INSERT INTO auy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yékopun-andafaken-kwaasi kawáá-kísáú waéꞌwaeꞌa ínana minkáwáá-áwíꞌá ímbo taiꞌáínda waéꞌwaeꞌa íníye Képarieri súwana ");
INSERT INTO auy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Máríyaa séna nóra séwa sénó. Kemá ímba waaí maiyéꞌa úwoi méraumne súwana ");
INSERT INTO auy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","wíyómpakewi séna Maníkóní Ufaen-ámútánkó eséꞌa mérainana íyáákamai-Fasiꞌaenkoni fasiꞌaémbá embá amína po maꞌánkénasa áfááran-iyampoi Maníkón-áánimban-iye sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Enamááraa-ininkon-awiꞌa Írísápéti áráamba kéna ámúꞌa kauráiye. Age-ínímbán-iye wésewana ámúꞌa kauréna afaꞌmóráe-wiyomba maisúwáíye. ");
INSERT INTO auy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maníkó seyaafá-tántááꞌá fetóí wéena wenkwáráꞌá miyá wéuwankaiye súwana ");
INSERT INTO auy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Máríyaa séna Maníkóní kísau-arasi úmpo simásimendantemba Maníkó kembá miyá íníye súwana Maníkó aiꞌmákowi auwéna iyáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Iyúwana kárikaꞌa Máríyaa ména íyáfasinena minúwóíyáán-úmai Yúndiyaa-marafaꞌa omápaꞌ-aempaꞌa moórá-naopaꞌa wéna ");
INSERT INTO auy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sékáráíyaani naaúmpaꞌa iyéna Írísápétin-awiꞌa mó tówana ");
INSERT INTO auy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Írísápéti Máríyaa amóísáúmba isówana iyámpóígo anówan-arumpimba ména úwaauwa úwana Maníkóní Ufaen-ámútánkó Írísápéti arumpimbá óraaꞌa úwana ");
INSERT INTO auy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","óraaka séna Maníkó kaweꞌá uwánkena fíꞌon-inimba kárika kaweꞌá uwátinkena embá óraaka kaweꞌá uwánkaraiye. Maꞌánkénda-iyampoigonkwaraꞌa kaweꞌá wéuwankaiye. ");
INSERT INTO auy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ímba súwíꞌwaraꞌ-inimba úndanifo kesí Fasiꞌaénkómbá maꞌánkénda-ininko éma kesí namuꞌá wétene. ");
INSERT INTO auy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Enamóísáúmba isáúnana sirumpimbó mérain-iyampoigo aamoí éna úwaauwa uráiye. ");
INSERT INTO auy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Maníkó simámakain-aai éraiꞌa paápé íníye séndasafena Maníkó kaweꞌá uwánkáíye Írísápéti siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Súwana Máríyaa séna kesí imáyáago Fasiꞌaénkón-áwíꞌa mósá wémaraisaꞌa ");
INSERT INTO auy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","Maníkóní kísau-arasi úwoi-arasi únana ken-ímáyáá isaná sirunkó kaweꞌá isaꞌá Maníkó kaweꞌ-ámpáꞌó mésínkáíwaimba aamoí uwánkaumne. Maníkó óraa-fasiꞌaenkwarawi óraaꞌa uwásínkáímba pósa kentáfésa sésa Maníkó kaweꞌá uwánkaraiye sénááwe. Káféꞌo méraan-kwaasiye ánaaembo paápé íyan-kwaasiye minááí símaesa kónááwe. Maníkó áfááꞌorawi éna ");
INSERT INTO auy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","wenaísamaifimbo méraan-kwaasisafena ááémo maéꞌón-kwaasiye káféꞌo méraan-kwaasiye ánaaembo paápé íyan-kwaasiye arumbá uwátínkámaena iyíníye. ");
INSERT INTO auy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Maníkó fasiꞌaréna fasiꞌaén-kísáú maéna kentúwíꞌo mósá máráán-kwaasi tiꞌmátuꞌmakaiye. ");
INSERT INTO auy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Maníkó túwíꞌo wérain-kwaasi kárikaꞌa múra tinkéna ímbo túwíꞌo wérain-kwaasi óraakaꞌa mósá wétinkaiye. ");
INSERT INTO auy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tááimo wétain-kwaasi kawe-tántááꞌá tiména sáwífa-tantaaꞌo makáan-kwaasi ímba tiména tiꞌmátukaiye. ");
INSERT INTO auy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Maníkó kentáá síwáꞌnáwara Émbaramuntafenawaraꞌa óraaka séna enkwárá enaísaafitantambo íyawiwaraꞌa sirumbá uwátínkámaeꞌa iyónaumne siyáin-aai áákaꞌa makéna kentáá Ísareri-waasisa wení kísau-waasisa wésuwaꞌnai-iye Máríyaa séna ");
INSERT INTO auy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Írísápétiye ména kaumbo-wíyómbá maisuwéna wení naaópaꞌa kunkáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kumúwana Írísápétini kanaa túwana iyámpói maꞌankówasa ");
INSERT INTO auy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Fasiꞌaénkó arumbó uwánkarain-aai isésa wenamááraawe wení naaópakewiye isésa anówankwaraꞌa aamoí uwánkaraawe. ");
INSERT INTO auy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aamoí uwaná miníyámpóígó afakaumboé-noꞌwaamba waúwasa áúma kárámai araénáémba ónae sésa afowán-áwíꞌa Sékáráíyaawe simánkanae uwaná ");
INSERT INTO auy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","anówa séna ímbanifo wenáwíꞌa Yóniye seró súwasa ");
INSERT INTO auy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","miwí sésa ímba ení waásifaꞌa miyán-áwíꞌá wéraiye suwaná ");
INSERT INTO auy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","afowámbá ááꞌa káúnkowasa tiyáán-kwaameꞌnaameꞌ-esa nóran-awira simánkainono suwaná ");
INSERT INTO auy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","afowá aúfáí-wandaai síméro séna waaméꞌnaame úwasa máámúwana agaimaréna wenáwíꞌa Yóniye séna timúwasa awánésa óraaꞌ-imayaa uwaná ");
INSERT INTO auy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sékáráíya agaimaréna óiꞌa fetóí úwana aaí séna Maníkón-áwíꞌa mósá marówasa ");
INSERT INTO auy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","mindáópaken-kwaasi tááꞌa úwana Yúndiyaa-marafaꞌa omápaꞌ-aempaꞌa minááí wété úwasa ");
INSERT INTO auy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ísówi óraaꞌ-imayaa ésa sésa miníyámpóígó ánaaemba nóran-kwaasiya mérainiyo sésa Fasiꞌaénkóní fasiꞌaémbá weséꞌa méraiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Miníyámpóígó afowámbá Sékáráíyaamba Maníkóní Ufaen-ámútánkó óraaꞌa uwánkowana Maníkón-aai simátimena séna ");
INSERT INTO auy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Maníkó kentáásí Fasiꞌaénkó éna wení waásisa Ísareri-waasisa súwaꞌnai ena sáwí-imayaago taꞌótokaimpinkemba faúsinkaindasafenasa wéimba póta wenáwíta mósá maránaumne. ");
INSERT INTO auy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Maníkó wení kísau-waasi Téfítin-andafakewimba fasiꞌaén-kwáásí íyáfasinankaraimba póna sáwíꞌo úmaisaamo méraundafinkemba kaweꞌ-ámpátá mésinkainiye. ");
INSERT INTO auy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Naaófáꞌá Maníkó minááí wení kaweꞌ-wáásí simátimuwasa agaimakáawe. ");
INSERT INTO auy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naaófáꞌá Maníkó kentáásáféna óraaka séna tíyámbo kembó uwátínkén-kwaasi namuro-wáásí taꞌótokempinkemba métiyanaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ááéma Maníkó kentáá síwáꞌnásafena arumbó uwátinkainda-aai séna wení fasiꞌaén-ááí áákaꞌo maráínda-aai siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Maníkó Émbaramu kentáá síwáꞌnásafena kentáásí namuro-wáásífákémbá mésinkainata ímba sááꞌa ínata wení kísau maéta ");
INSERT INTO auy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","wenaúrankaꞌa kaweꞌ-úmai arupíse úmai maéꞌmaeꞌo onda-ááísá óraakaꞌa siyáiye. Sékáráíya simásuwena séna ");
INSERT INTO auy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","kesááninkoo entáfésa íyáákarai-Fasiꞌaenkon-aaimo simátímíndawi óne sénááwe. Aifaꞌá emá Fasiꞌaénkóní aambá wiyínone. ");
INSERT INTO auy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Fasiꞌaénkó wení waásiti sáwí-imayaa maitiyuwéna kaweꞌ-ámpáꞌó métinkainda-aai wésimatime Fasiꞌaénkóní aambá wiyínone. ");
INSERT INTO auy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kentáásí Fasiꞌaénkó áfááraumai arumbá uwásinkenasa aafáúmó íyáúsenamo sámo kaintembá kaweꞌ-ámpátá mésinkenasa sása kásinkainiye. ");
INSERT INTO auy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kumeuꞌó in-áémpáꞌó méraawi puwíyantafena tááꞌo iwáí sáma kátinkena kaweꞌ-ámpáꞌá métinkainiye Sékáráíya siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Súwana miníyámpóígó óraaꞌa éna kaweꞌ-ímáyáá wéena máásai-marafaꞌa ména Ísareri-waasi túrankaꞌa paápé índa-kanaa túwana máásai-marafaꞌa méraiye. ");
INSERT INTO auy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Minkánááfímbá Rómu-kamani-oraakon-awiꞌa Ógásitasi simátimena séna seyaafáꞌ-máráfákén-kwáásí túwíꞌa agaénááwe siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aifaꞌá túwíꞌo agáún-kanaafimba Sáíriniyasi Síriyaa-waasiti kawáágómó méron-kanaafimba ");
INSERT INTO auy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","namupaꞌó maifáꞌo kuráawi kouwerésa kentí akúmbó méropaꞌa túwíꞌo agáíyantafesa tiyáawe. ");
INSERT INTO auy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yósepi Téfítin-andafaken-kwaasi póna Káríri-marafaꞌa Násareti-naopaꞌa tuwéna Yúndiyaa-marafaꞌa Téfítini naaópaꞌa téna mindáópaꞌ-awiꞌa Pétaremufaꞌa túwana ");
INSERT INTO auy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","awaainín-árásígó Máríyaa ámúꞌa kaufúwana áwíꞌo maíndasafena áíꞌmaena túwana ");
INSERT INTO auy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","mindáópaꞌa ména iyámpóímo maꞌankáí-kánáá túwana ");
INSERT INTO auy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","aifaráán-íyámpóí maꞌankéna iyámpóígoni unáánkwátói úsúrena purumakagóní táúfapimba ánkaraiye. Túwíꞌa wéagauwasa sáwífaꞌ-waasi wíyómpimba waásimo wááumo wáén-daumpaꞌa ówiꞌa tarówana purumakagóní naaúmpaꞌa mérena maꞌánkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mináémpáꞌó sipisípiyaꞌo káráwiyowi nóꞌwaamba ufáꞌá wégawaanuwana ");
INSERT INTO auy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Fasiꞌaénkó wení kísau-waasi wíyómpakemba aiꞌmarówana sipisípiyaꞌo káráwiyowifaꞌa paápé úwana Maníkóní sáma tuwówana kumúwasa awánésa áfááraumai táátafesa uwaná ");
INSERT INTO auy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","wíyómpakewi séna ímba tááꞌa íno. Ásé-aai kusimátimunda pósa sáwífaꞌ-waasi isésa áfááraumai aamoí uwánkanaawe. ");
INSERT INTO auy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Káféꞌa Téfítini naaópaꞌa iyámpói maꞌánkáísana miníyámpóígóntáfésa Maníkó íyáfasinankaraiwai Fasiꞌaénkón-iye sénááwe. Miníyámpóígó kenkwáráꞌé fíꞌon-kwaasiye sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkainiye. ");
INSERT INTO auy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Miníyámpóí ampantasámbá úsúmai purumakagóní táúfapimba máráísaꞌa koawáné séꞌa simásímakain-aai éraiꞌ-aai kentáá kaweꞌ-ámpáꞌá mésinkaindawimba maꞌánkaraiye sénááwe súwasa ");
INSERT INTO auy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","minúwóíyáámbá wíyómpakewi sáwífaꞌa paápé ésa Maníkón-áwíꞌa mósá marésa sésa ");
INSERT INTO auy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","wíyómpaꞌa Maníkón-áwíꞌa mósá maráúmne. Marapáꞌá Maníkó aamoimó uwátínkáín-kwaasi aaweyáá úmai méraawe siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wíyómpaken-kisau-waasi wíyómpaꞌa kunuwerésa íyúwasa sipisípiyaꞌo káráwiyowi sésa Fasiꞌaénkómó simásímakain-aaisafeta Pétaremufaꞌa koawánanaisaiye sésa ");
INSERT INTO auy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","minúwóíyáán-úmai kumbá Máríyaae Yósepiye mésarai purumakagóní táúfapimba Ísumba ánkaroyasa taawánésa ");
INSERT INTO auy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","wíyómpakewimo siyón-aai miníyámpóígón-áái tasimátimesa ");
INSERT INTO auy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","20","kouwerésa simásímakain-aaisa éraiꞌ-aaiye sésa ísaron-aaisafesa koawánontafesa Maníkón-áwíꞌa mósá makáawe. Sipisípiyaꞌo káráwiyowi simátimun-aai ísówi imáyáa uwaná Máríyaa minááí áákaraakaꞌa éna imáyáa uráiye. ");
INSERT INTO auy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iyámpói maꞌankéna afakaumboé-noꞌwaamba waúwasa miníyámpóígón-áúma kárámai araénáémba uwaná áwíꞌa simánkena anówamo ímbo ámúꞌo kaurónkaꞌa wíyómpakewimo siyón-awiꞌa simánkena Ísuwe siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Naaófáꞌó Mósese aaremó iyámpóímo matinkésa nombó pétuwesa miwítí naaópaꞌo iyíyan-aaimo siyáin-kanaa túwasarai Yósepiye Máríyaaeꞌa Ísumba áíꞌmesarai Fasiꞌaénkómbó amíyanesarai Yérúsaremu-naopaꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Fasiꞌaénkóní ámáámba Mósese agaimaréna séna Fasiꞌaénkó séna kentí iyámpói aifaꞌá waai-iyámpóísómbá tíꞌmaeꞌa kempáꞌá mátinkeꞌa ení iyámpóíye sénááwe Fasiꞌaénkó siyáiye Mósese agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Moóráfaꞌa Fasiꞌaénkóní ámáámba agaimaréna séna Maníkóntáfékai ísámai mááufuꞌ-numa kaeꞌá fámai agáékaiyo. Ímbo mááufuꞌo makékai mááufukaan-dumagon-árááꞌa kaeꞌá maimái agáékaiyo siyáiye. Minááí miyá íyantafesarai Ísumba áíꞌmesarai Yérúsaremu-naopaꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kuyaná moóráwigon-awiꞌa Símiyoni Yérúsaremufaꞌa ména kaweꞌ-wáásí éna Maníkón-aaisafena fasiꞌámai ména Ísareri-waasi kaweꞌó uwátinkaindawimba amuꞌmaréna mérowana Maníkóní Ufaen-ámútánkó weséꞌa ména ");
INSERT INTO auy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ááéma simámena séna ímba ááéma puwínompo Fasiꞌaénkóní Káráísitimba awáné puwínone simámakaimba ");
INSERT INTO auy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maníkóní ámútanko imáyáa amúwana óraaꞌ-amaan-daumpaꞌa imérowasarai Ísun-anófoiyai ámáámba miyá siyóntafesarai Ísumba áíꞌmaesarai óraaꞌ-amaan-daumpaꞌa íyúyana ");
INSERT INTO auy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Símiyoni miníyámpóí tapéna Maníkóntáféna súwi simásuwena séna ");
INSERT INTO auy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Fasiꞌaénkóo simásímakaanda-aai káféꞌa paápé isaná sirunkó kaweꞌá wéimba póꞌa úwoi puwónaumne. ");
INSERT INTO auy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Seyaafáꞌ-wáásísáféna ísámai kaweꞌ-ámpáꞌó métinkaindawimbo íyáfasinankaandawimba éꞌa awánáúmne. ");
INSERT INTO auy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Fíꞌonkaa-waasi sáma kátinkena kaweꞌ-ámbá aráátiminana póna Ísareri-waasi súwíta sanaambá iyíníye Símiyoni siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Símiyoni miníyámpóígóntáféna súwasarai anófoiyai isésarai óraaꞌ-imayaa uyaná ");
INSERT INTO auy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Símiyoni séna Maníkó kaweꞌá uwátinkainiye simásuwena miníyámpóígón-anówantafena séna Maníkó maaníyámpóí íyáfasinankaiye. Wentáfésa Ísareri-waasi tuwímbai Maníkóntáfésa kaweꞌ-úmai méwasa tuwímbai tínaaemba uwámenaawe. Maníkó wembá waamékáámbá uwánkáísasa sáwí-aaimo simánkaiyawiti ");
INSERT INTO auy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sáwí-imayaa seyaafáꞌ-wáásí túrankaꞌa paápé íníye. Ááiwara-tantaako faiyáráísanamo áíꞌo intenkáámbá umbai-tántáákó enarumpimbá tíníye Símiyoni Máríyaantafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Moórá-ininkon-awiꞌa Ánaa Maníkón-aaimo simátimun-ininko ména Ásan-andafaken-inimba Fániyuerin-ayáámúnko éna waaí maiyéna afakaeté-aatai maisuwówana awaaikó puwúwana ayáátáákaꞌa 84 aatai maisuwéna áráamba kéna aasiyaasi-kánáá óraaꞌ-amaan-daumpaꞌa iména aafáyáaraꞌe fénáímpinkaꞌe nóꞌwaane Maníkón-áwíꞌa mósá wémarena inaí aantembo síndasafena ímba tómbá wénena ");
INSERT INTO auy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Símiyoni sún-kanaa wewáráꞌá ewaaꞌá taména Maníkóntáféna súwi séna miníyámpóígón-aai simátimena Maníkó Yérúsaremufaken-kwaasi sáwí-imayaago taꞌótokaimpinkemba faúsinkaindasafenasa siyáíndawimba wéamuꞌmaraundawintafena miníyámpóígón-aai simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yósepiye Máríyaaeꞌa Fasiꞌaénkómó siyáin-amaamba taíꞌásuwesarai Káríri-marafaꞌa mindáraiti naaópaꞌa Násaretifaꞌa koméroyana ");
INSERT INTO auy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","mindáraiti iyámpóígo óraaꞌa uwáwéna fasiꞌámai ména kaweꞌ-ímáyáá úwana Maníkó kaweꞌá uwánkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Naaófáꞌá Maníkó Yúndaa-waasi tíyótaimo í-tánón-kánáá túntemba Ísun-anófoi Yérúsaremu-naopaꞌa kógo urááye. ");
INSERT INTO auy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ísu sísamaifakemba kaeꞌá kumbaimái-aatai maisukónkaꞌa Yúndaa-waasiti áwáu arááíwaesarai mintánómbó náíyantafesarai Ísumba áíꞌmaesarai Yérúsaremufaꞌa koméroyana ");
INSERT INTO auy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","mintánón-kánáá taiꞌówasa miwítí naaópaꞌa wété uwaná Ísu Yérúsaremufaꞌa mérowasarai anófoi ímba awánésarai ");
INSERT INTO auy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","imáyáa ésarai wenamááraaseꞌa aampaꞌá wéwiye-imayaa ésarai aampaꞌá wéwesarai fenómpinkaꞌa wétoso uwasaráí mindárai miwítí naaóraafine timááraafinemo tíndawe sésarai ayaafáí uyambá ");
INSERT INTO auy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ímba awánésarai ayaafáí uwááesarai anekaꞌá tauwerésarai Yérúsaremufaꞌa koayaafáí úmaesarai kuyambá ");
INSERT INTO auy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","kaumbo-kánáá maisúwóyana óraaꞌ-amaan-daumpaꞌa mérowasarai anófoiyai awánaraaye. Yúndaa-waasi aaimó simátímún-kwaasiti afufumpimbá Ísu ména miwí táái wéisena minááísáféna tísai úwasa ");
INSERT INTO auy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","anondáá wembá áísai uwaná wení kaweꞌ-ímáyááfínkémbá simátimuwasa isésa táátafesa uwasá ");
INSERT INTO auy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","anófoi taawánésarai táátafesarai ésarai tiyáámba píkinesarai anówa séna kesááninkoo enafoékai ayaafáí úmaekai wénuyana sirunkó umbaí wétaifo nóra séwa miyá wéono súwana ");
INSERT INTO auy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ísu séna nóra sékaiya siyaafáí wéoyo. Kesifoní naaúmpaꞌa méraumpo nóra sékaiya ímba ísaraayo súwasarai ");
INSERT INTO auy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","minááígóní áwáu ímba kaweꞌ-úmai ísaraaye. ");
INSERT INTO auy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ímba ísóyana Ísu anófoiseꞌa Yérúsaremufakemba Násareti-naopaꞌa téna miwí tááisafena ewé símaena wéiyena tamérowana anówa Ísumo urómba imáyáa wéena mérowana ");
INSERT INTO auy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ísu óraaꞌa uwáwéna kaweꞌ-ímáyáá wéuwasa Maníkówé waásiye aamoí uwánkaraawe. ");
INSERT INTO auy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rómu-waasiti óraakon-awiꞌa Táípíríyasi ména kawáá-kísáú maiyéna sísamaifakemba séfataase-aatai maisuwónkaꞌa Yúndiyaa-marafaken-kawaagon-awiꞌa Póntiyasi-Páírati maúwana Káríri-marafaken-kawaagon-awiꞌa Éroti maúwana áfákon-awiꞌa Fírípi wemá Ítúríya-marafaꞌe Térékónaitisi-marafaꞌe káráwiyuwana Ráíseniyaasi Ápíríni-marafaꞌa káráwiyuwasa ");
INSERT INTO auy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","miyáumai-waasi káráwiyonkaꞌa Ánásiye Káyafaasiye aifaꞌ-ámáán-káwáágóráí méroyankaꞌa Sékáráíyaan-ááninkon-awiꞌa Yóni máásai-marafaꞌa mérowana Maníkó aaí simámuwana ");
INSERT INTO auy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yóni Yóndani-nonkoni arúfáꞌá wénena simátimena séna sáwí-imayaa tuwéꞌa Maníkómpáꞌá tíyaꞌa nombá maitínkáanana Maníkó kentí sáwí-imayaa maitiyuwáíníye Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Miyá súntafena naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Áísáya agaimaréna séna moóráwigo máásai-marafaꞌa ména aaemáíyakemba séna Fasiꞌaénkóní aambó wiꞌankáíyamba wení aambá arupíse íyana minámpáꞌá wíno. ");
INSERT INTO auy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Omáꞌa kárámai ukwítuꞌmae koró. Kaentaén-ámbá arupíse oro. Kumpékaapeꞌo uráin-amba maimái kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Maníkó sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌó métinkaindawimba aiꞌmaráínana kumínda seyaafáꞌnánká awánánááwe Áísáya agaimaréna siyónkaꞌa póna Yónintafena minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Súwasa Yóni nombá maisinkáínkwae sésa sáwífaꞌ-waasi wempáꞌá tóso uwaná Yóni simátimena séna iyánkó póígon-araaꞌan-owe. Maníkó kentí sáwí-meyamba timínífo nááwa sisará iséra inkaisé wéteo. ");
INSERT INTO auy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kentí sáwí-kisau tuwéꞌo Maníkómpáꞌó téꞌo éꞌa kawe-kísáú maíyaꞌa tuwánánaumne. Émbaramu kentáá síwáꞌná imbá póta Maníkóní kaweꞌ-wáásísá úne séꞌa miyán-ímáyáá ímba oro. Maníkó Émbaramun-aísaafitantamba ónááwemo sénaraa maanóntámpínkémbá kanaámpóꞌa waási úráaro sisaꞌá úráawisino. Émbaramun-aísaafitantambo uráundawi póta kaweꞌ-wáásísá úne séꞌa miyán-ímáyáá ímba oro. ");
INSERT INTO auy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ímbo kaweꞌ-árámbó íyáín-taimo áwáufimbo ayáímai iyafímbó agaisúwáántemba Maníkó miyáumai kentí sáwí-meyamba timíníye Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Súwasa isésa sésa simásimenda-aaisa nórasaawa ónaumno suwaná ");
INSERT INTO auy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yóni séna kaeꞌ-únánkwátóimo makéwi ímbo makéwi moórá-mora tíméro. Tómbá makéwi ímbo makéwi moórá-mora tíméro Yóni súwasa ");
INSERT INTO auy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","taakisi-óntámbó máún-umen-kwaasi Yóni nombá maisinkáínkwae sésa wempáꞌá tésa sésa óraako ómpo nórasaawa ónaumno suwaná ");
INSERT INTO auy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yóni séna ímba karoꞌá símai óraaꞌ-ontambo maíyamba taakisi-óntán-aantemba máéro súwasa ");
INSERT INTO auy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","i-wáásí sésa kesáá nórasaawa ónaumno suwaná Yóni séna tínkantukeꞌa miwítí óntama maénae ímba seró. Karoꞌ-ááí simátimeꞌa miwítí óntama maénae ímba seró. Kentí kísaugoni méyántáféꞌa ímbo kaórémba tirunkó kaweꞌá ínaꞌa méraaro Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yúndaa-waasi Maníkómó íyáfasinankaraiwaimba amuꞌmarésa mésa Yónin-aai isésa óraaꞌ-imayaa ésa sésa Maníkómó íyáfasinankaraiwai wemá Yóniyaꞌi fíꞌowawaꞌiyo suwaná ");
INSERT INTO auy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yóni séna kesínaaembo tíndawi wemá óraako kembá íyáákaraifo wemó aaí síndaraꞌo kemó sendá sáwíꞌan-iye. Kemá nombá maitinkánaumpo wemá Maníkóní Ufaen-ámútánkómbá aiꞌmaráínana kuména kempímbá óraaꞌa uwátinkena iyamó agáéntemba íníye. ");
INSERT INTO auy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aawinkwínaumo sipetifímbó mósá makésamo mentúwááwanamo anómba marapáꞌó kúmísanamo ásimo fiyúndágo aútúwáísasamo kámakamaꞌo in-íyáfímbó wiyúꞌmaimo agaisuwésamo anómbo naaúmpaꞌo mósá máráántemba waási miyáráámbá íníye Yóni séna ");
INSERT INTO auy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Maníkóní ásé-aai ísámai kaweꞌá íwae séna miyán-ááí simátímaꞌmaena iyáiye. ");
INSERT INTO auy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Yóni simátímaꞌmae wéiyena sáwífaꞌ-waasi nombá maitinkéna ánaaemba Ísumba maiyankówana inaí súwana kampúaran-tawaai tuwínkaaꞌ-úwana Maníkóní Ufaen-ámútánkó mááufuꞌ-numaraamba úmaena aneꞌá kumbérowana aaigó aantemba wíyómpakemba séna emá kesááninko ónaꞌa en-ímáyáá wéeꞌa áfááraumai aamoí uwánkaumne siyáiye. Yóni Maníkóní ásé-aai simátimumbanifo Káríri-marafaken-kawaagon-awiꞌa Éroti áfákon-awaainínkón-áwíꞌa Érótíyasimba maiyówana mindásafena fíꞌo-fiꞌon-tantaaꞌo sáwíꞌo úntafena Yóni séna sáwíꞌa óne súwana Éroti Yónimba áíꞌmai ándáfaꞌa ankéna mindásafena sáwí-kisau maimaéna iyáiye. ");
INSERT INTO auy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ísu marapáꞌá kumbéna moórá-waai úmai siyáánkai-aatai maisuwéna wénena Maníkón-aaimo simátiminda ómbarena úwasa waási imáyáa ésa sésa Yósepin-ááninkon-iye siyáawe. Yósepi afowán-áwíꞌa Írai úwana ");
INSERT INTO auy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Írai afowán-áwíꞌa Mátáti úwana Mátáti afowán-áwíꞌa Rífái úwana Rífái afowán-áwíꞌa Méríkai úwana Méríkai afowán-áwíꞌa Yánai úwana Yánai afowán-áwíꞌa Yósepi úwana ");
INSERT INTO auy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yósepi afowán-áwíꞌa Mátátayasi úwana Mátátayasi afowán-áwíꞌa Émósi úwana Émósi afowán-áwíꞌa Néamu úwana Néamu afowán-áwíꞌa Ésírai úwana Ésírai afowán-áwíꞌa Nágai úwana ");
INSERT INTO auy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nágai afowán-áwíꞌa Méati úwana Méati afowán-áwíꞌa Mátátayasi úwana Mátátayasi afowán-áwíꞌa Sémeni úwana Sémeni afowán-áwíꞌa Yóséki úwana Yóséki afowán-áwíꞌa Yónda úwana ");
INSERT INTO auy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yónda afowán-áwíꞌa Yóánani úwana Yóánani afowán-áwíꞌa Résa úwana Résa afowán-áwíꞌa Sérápáperi úwana Sérápáperi afowán-áwíꞌa Síáritiyeri úwana Síáritiyeri afowán-áwíꞌa Nérai úwana ");
INSERT INTO auy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérai afowán-áwíꞌa Méríkai úwana Méríkai afowán-áwíꞌa Éndai úwana Éndai afowán-áwíꞌa Kósamu úwana Kósamu afowán-áwíꞌa Érímendamu úwana Érímendamu afowán-áwíꞌa Éya úwana ");
INSERT INTO auy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Éya afowán-áwíꞌa Yósúwa úwana Yósúwa afowán-áwíꞌa Éríyesa úwana Éríyesa afowán-áwíꞌa Yórimu úwana Yórimu afowán-áwíꞌa Mátáti úwana Mátáti afowán-áwíꞌa Rífái úwana ");
INSERT INTO auy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rífái afowán-áwíꞌa Símiyoni úwana Símiyoni afowán-áwíꞌa Yúndaa úwana Yúndaa afowán-áwíꞌa Yósepi úwana Yósepi afowán-áwíꞌa Yónamu úwana Yónamu afowán-áwíꞌa Éráyakimu úwana ");
INSERT INTO auy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Éráyakimu afowán-áwíꞌa Méríya úwana Méríya afowán-áwíꞌa Ména úwana Ména afowán-áwíꞌa Mátáta úwana Mátáta afowán-áwíꞌa Nétáani úwana Nétáani afowán-áwíꞌa Téfíti úwana ");
INSERT INTO auy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Téfíti afowán-áwíꞌa Yési úwana Yési afowán-áwíꞌa Ópéti úwana Ópéti afowán-áwíꞌa Póási úwana Póási afowán-áwíꞌa Sárimoni úwana Sárimoni afowán-áwíꞌa Násoni úwana ");
INSERT INTO auy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Násoni afowán-áwíꞌa Ámínándapu úwana Ámínándapu afowán-áwíꞌa Ándimini úwana Ándimini afowán-áwíꞌa Ánái úwana Ánái afowán-áwíꞌa Ésíroni úwana Ésíroni afowán-áwíꞌa Pérési úwana Pérési afowán-áwíꞌa Yúndaa úwana ");
INSERT INTO auy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yúndaa afowán-áwíꞌa Yékopu úwana Yékopu afowán-áwíꞌa Áísáaki úwana Áísáaki afowán-áwíꞌa Émbaramu úwana Émbaramu afowán-áwíꞌa Téra úwana Téra afowán-áwíꞌa Néꞌo úwana ");
INSERT INTO auy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Néꞌo afowán-áwíꞌa Séráki úwana Séráki afowán-áwíꞌa Ríyu úwana Ríyu afowán-áwíꞌa Péréki úwana Péréki afowán-áwíꞌa Ípa úwana Ípa afowán-áwíꞌa Síra úwana ");
INSERT INTO auy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Síra afowán-áwíꞌa Kénaani úwana Kénaani afowán-áwíꞌa Áfákisati úwana Áfákisati afowán-áwíꞌa Sému úwana Sému afowán-áwíꞌa Nówaa úwana Nówaa afowán-áwíꞌa Rémeki úwana ");
INSERT INTO auy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rémeki afowán-áwíꞌa Métúsara úwana Métúsara afowán-áwíꞌa Ínóki úwana Ínóki afowán-áwíꞌa Yéréti úwana Yéréti afowán-áwíꞌa Máꞌárariri úwana Máꞌárariri afowán-áwíꞌa Kénaani úwana ");
INSERT INTO auy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kénaani afowán-áwíꞌa Ínosi úwana Ínosi afowán-áwíꞌa Séti úwana Séti afowán-áwíꞌa Ándámu wemá Maníkón-áánimban-iye. Miwí Ísun-aíwáꞌná owé-ímáyáá uráawe. ");
INSERT INTO auy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yóni Ísumba nombá maiyankónkaꞌa Maníkóní Ufaen-ámútánkó Ísumba óraaꞌa uwánkena simámuwana Ísu Yóndani-nomba tuwéna máásai-marafaꞌa komérowana ");
INSERT INTO auy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","waántáwanko Ísu sáwíꞌo índa awánánae súwana Ísu ímba tómbó nómba ména ayáátáákaꞌa 40 noꞌwaamba waúwana áfááran-aai tówana ");
INSERT INTO auy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","waántáwanko séna emá Maníkón-ááninko úne wésempo maanóntánkóntáfé tómbá úrénaꞌa naanó siyó súwana ");
INSERT INTO auy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ísu séna Maníkón-aai aúfáífinkemba séna tómbó náíyawi aantemba waási ímba fasiꞌátinkainifo Maníkómó siyáintemba seyaafáꞌá íyana fasiꞌátinkainiye siyáimba póꞌa emó sénda ímba miyá ónaumne súwana ");
INSERT INTO auy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","waántáwanko Ísumba áíꞌmaena iyéna minúwóíyáán-úmai seyaafáꞌ-máráfáꞌó káráwiyon-kwaasi aráánamena ");
INSERT INTO auy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","séna seyaafáꞌ-máráfáꞌá káráwiyuwo sénamo símakaimba moóráwigomba kesí imáyáafinkemba kanaaꞌá tíménda isaꞌá embá áménana enáwíko iyíníye. ");
INSERT INTO auy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ken-ímáyáámó mósá márénaꞌo éꞌa káráwiyi-kisau áména káráwiyuwo waántáwanko súwana ");
INSERT INTO auy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ísu séna Maníkón-aai aúfáífinkemba séna kentí Fasiꞌaénkó Maníkómpáꞌá imáyáa éꞌa wenáwíꞌ-aantemba mósá maréꞌa wení kísau aantemba máéro siyáifo emó sénda ímba miyá ónaumne súwana ");
INSERT INTO auy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","waántáwanko Ísumba áíꞌmaena Yérúsaremu-naopaꞌa wéna óraaꞌ-amaan-dankoni amifaꞌá móankena séna Maníkón-aai aúfáífinkemba séna Maníkó wíyómpakemba wení kísau-waasisomba tiꞌmaráínasa enkáꞌá káráwiyonaawe. Moóráfimba séna óntankaꞌa aísamai turaráanafo sésa tiyáántandesa faramónááwe siyáiye. Mindásafe emá Maníkón-ááninko úne wésempo maankákémbá ásáfenasa wíyómpakewi farámbaesa marapáꞌá múankaaro waántáwanko súwana ");
INSERT INTO auy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ísu séna Maníkón-aai aúfáífinkemba éꞌa miyá siyéna moórá-aaiwaraꞌa séna kentí Fasiꞌaénkó Maníkómbá áísai úmai isánae ímba seró siyáimba emó séndantembo miyámó ékaa Maníkómbá áísai úmai isáúsino. Mindásafemo emó sénda ímba miyá ónaumne Ísu súwana ");
INSERT INTO auy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","waántáwanko seyaafá-tántáátáféna Ísumba áísai uwásuwena séna kárika anekaꞌá taáísai ónaumne séna auwéna kóuraiye. ");
INSERT INTO auy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kúwana Maníkóní Ufaen-ámútánkóní fasiꞌaénkó Ísumpimba wérowana Ísu máásai-marafaꞌa tuwéna Káríri-marafaꞌa komérowana wenááigo seyaafáꞌ-máráfáꞌá wété úwana ");
INSERT INTO auy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","miwítí ámáán-daumpimpaꞌa Ísu simátimuwasa seyaafáꞌnánká wenáwíꞌa mósá makáawe. ");
INSERT INTO auy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Minkákémbá Ísu kárikomo maéꞌéún-daopaꞌa Násaretifaꞌa koména Yúndaa-waasi ámáán-aaimo ísón-kanaa aasiyaasi-kánáá ámáán-daumpaꞌa imáéntemba miyáumai iména Maníkón-aai aúfáífinkembo simátimindasafena íyáfasinowasa ");
INSERT INTO auy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","naaófáꞌá Maníkón-aaimo siyówi Áísáya agaimakón-kwandaai ámúwana maiyéna fariyéna moórá-aai awánéna séna ");
INSERT INTO auy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Fasiꞌaénkóní ámútanko keséꞌa méraiye. Úwoi-waasisafe kesí ásé-aai kosimátimiyo séna siꞌmákaifo Fasiꞌaénkóní ámútanko keséꞌa méraiye. Taꞌótokaan-kwaasisafeꞌa kemá faútínkáanaꞌa méraaro siyé-ááí kosimátimiyo. Túrambo kafíkáin-kwaasisafe anekaꞌá túrambo awánáíyan-aai kosimátimiyo. Tirumbó umbaimó táínda-waasisafena minúmbáí-tántááꞌá taiꞌáíníye siyé-ááí kosimátimiyo. ");
INSERT INTO auy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Fasiꞌaénkó wení waási kaweꞌó uwátinkainda-kanaagon-aai kosimátimiyo séna siꞌmákaiye agaimaréna siyáiye Ísu simásuwena ");
INSERT INTO auy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","mináúfáí-wándááí owepámai káráwiyowimba aména aaí simátimindasafena maraꞌá mérowasa mindáúmpáꞌó méron-kwaasi aaí sínena úwasa aúrampimba karákówana ");
INSERT INTO auy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ísu séna minááímó súnaꞌo isérón-aai aforaꞌá paápé iye súwasa ");
INSERT INTO auy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","isésa aifaꞌá kaweꞌ-ááí siyé sésa aamoí uwánkesa ánaaemba óraaꞌ-imayaa ésa sésa Yósepin-ááninko éna maankákéwí éna kesáámó úndanten-kwaasin-ifo nóra sénawa miyán-ááí síyó suwaná ");
INSERT INTO auy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ísu séna waási waéꞌmai-aai sésa emá tíyofaan-waasi ómpo enáúraꞌa eyááríka kaweꞌán-uwo wésewe. Minááí kentáféꞌa simásuwe séꞌa Kápaneamu-naopaꞌa kawe-kísáú maiyáanata ísaraumpo maankáꞌá ení naaópaꞌwaraꞌa miyán-kísáú mauwó kentáféꞌa síyambanifo ");
INSERT INTO auy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","éraiꞌa simátime súne. Maníkón-aaimo simátímíwai wení waásifaꞌa Maníkón-aai kosimátiminenamo wimbá wenamááraa sésa kesáámó úndanten-kwaasin-iye sésa wenáwíꞌa ímba mósá wémaraawe. ");
INSERT INTO auy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Éraiꞌ-aai sénaumpo ísáaro. Naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Íráiyaa méronkaꞌa kaumbo-áátáí úmai afaꞌmóráe-wiyomba maisuwéna ímba aaꞌá téna aawaí tówana minkánáá Ísareri-waasiti marafáꞌá ketoꞌ-ínímbá sáwífaꞌa mérowana ");
INSERT INTO auy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Maníkó ímba minkétóꞌ-ínímbá kotúwaꞌnai ínone séna fíꞌom-barafaken-ketoꞌ-inimba Sáíndóni-marafaꞌa Sáréfati-naopaken-ininkomba koáwaꞌnai uwó séna Maníkó Íráiyaamba aiꞌmarówana kuráiye. ");
INSERT INTO auy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Naaófáꞌá moóráwigo Maníkón-aaimo simátímakowin-awiꞌa Íráisa méronkaꞌa Ísareri-waasiti marafáꞌá túmo námombo kón-kwaasi sáwífaꞌa mérowana Maníkó minkwáásísómbá ímbo asófatinkaraimbanifo fíꞌom-barafaꞌa Síriyaa-marafaken-kwaasi áúmo námombo kón-kwaasigon-awiꞌa Néamanimba asófankaraiye Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","minámáán-dáúmpáꞌó mérowi isésa imáyáa ésa kentáásáféna Maníkó ímba túwaꞌnai íníye Ísu wésiye sésa tirunkó ika fówasa ");
INSERT INTO auy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","íyáfasinesa Ísumba taꞌótokesa tafisímaesa máápaꞌa kúwákárúwesa miwítí naaóꞌ-omapa ámémpaꞌa famétuwanaesa uwaná ");
INSERT INTO auy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","énifo Ísu tufíntuwena kóuraiye. ");
INSERT INTO auy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ísu Káríri-marafaꞌa Kápaneamu-naopaꞌa koména Yúndaa-waasi ámáán-aaimo ísón-kanaaraꞌa ámáán-daumpaꞌa iména aaí simátimuwasa ");
INSERT INTO auy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","isésa óraakaꞌo súntafesa óraaꞌ-waasigoraamba siyé sésa táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Táátafesa uwaná minámáán-dáúmpáꞌá moóráwigo sáwí-amutamba wenarumpimbó méron-kwaasigo óraaka séna ");
INSERT INTO auy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ísu Násaretifakewi óne. Kentáá nórawa ínewaꞌono tasínkambaisaawa taiꞌáínono. Embá awánáúndawi Maníkóní kawe-kísáú-wáásígó óne súwana ");
INSERT INTO auy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ísu sáwí-amutankontafena óraaka séna aseré minkwáásí auwé kóuwo súwana misáwí-ámútánkó minkwáásí faméꞌauwowana túrankaꞌa tanaa fówana ímba sáwíꞌo uwánkomba úwoi kóúwasa ");
INSERT INTO auy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","awánésa táátafesa ésa keáímbá sésa nóran-aaiya wésiyo. Fasiꞌaén-ááí sáwí-amutantafena óraaka simátímísasa tirumpinkémbá wégowe suwaná ");
INSERT INTO auy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","miyán-ááí Ísun-aai mináémpáꞌá wété úwasa ísaraawe. ");
INSERT INTO auy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ísówana Ísu minámáán-dáúmpáꞌá tuwéna Sáímonini naaúmpaꞌo iyúmba Sáímonin-áráandaomba áuiya kówana mérowasa Ísumba simámúwana ");
INSERT INTO auy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","iséna wempáꞌá téna áuiyagontafena séna taiꞌaaó súwana mináúíyá taiꞌówana íyáfasinkwena tómbá agaimái tímakaiye. ");
INSERT INTO auy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Úwasa fenómpinkaꞌa fíꞌo-fiꞌon-tiꞌo ún-kwaasi tíꞌmaesa Ísumpaꞌa tuwaná ayáámba taꞌótorowasa asófaraawe. ");
INSERT INTO auy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Miyá úwasa sáwí-amutantomba sáwífaꞌ-waasi tirumpinkémbá tiyuwésa óraaka sésa Maníkón-ááninko óne simásuwesa kóuraawe. Sáwí-amutamba imáyáa ésa Ísuntafesa Maníkómó íyáfasinankaraiwai iyé-ímáyáá untáféna Ísu aséráaro súwasa tiyuwésa kóuraawe. ");
INSERT INTO auy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kóuwana aafáúmó íyáúsunkaꞌa Ísu mindáópaꞌa tuwéna Maníkómpáꞌá inaimó síndasafena ímba waásimo méropaꞌa komérowasa ayaafáí úmai awánésa sésa kónafo keséta méraao suwaná ");
INSERT INTO auy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ísu séna fíꞌon-daopimpaꞌwaraꞌa ásé-aai Maníkó wení waásimo kawáánin-aai kosimátimenaumne. Miyámó ondasáféna Maníkó siꞌmákaisaꞌa kunkáumne séna ");
INSERT INTO auy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","tiyuwéna Yúndiyaa-aempaꞌa koména ámáán-daumpimpaꞌa simátímaꞌmaena iyáiye. ");
INSERT INTO auy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Moórá-kanaa Ísu nonkwaaúnkóní áwáífaꞌ-awiꞌa Kénésárétifaꞌa mérowasa Maníkón-aai isánae sésa tóso ésa faméꞌmaesa tuwaná ");
INSERT INTO auy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","3","kaeꞌá káriꞌ-nompin-taomba nonáámááífaꞌa wérowana moórá Sáímoninde wérowana awánówasa mófááꞌo tóróyan-kwaasi mindómpín-táómba tuwésa mareꞌmareꞌ-únámbá wénonkwiyuwana mintáómba úwoi wérowana awánéna Sáímonini nompín-táómpimba íyátena Sáímonintafena séna ewaaꞌá maimaé waaó súwana ewaaꞌá fafúsúmaena nonáwáífaꞌa kúwana Ísu mimpímbá maraꞌ-ména seyaafáꞌ-wáásí simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Simátimena Sáímonintafena séna nompín-táómba fafúsúmae nonafufumpáꞌá kuré ewé ení waásiye mareꞌmareꞌ-únámbá túwéwana nompímbá kumínaꞌa mófááꞌa fasínáaro súwana ");
INSERT INTO auy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sáímoni séna óraakoo káféꞌ-noꞌwaamba miyámó úmae iyúndasa ínta mófááta toráúndasa úwoisa méraumpo emó séndantemba ónaumne séna ");
INSERT INTO auy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","nonafufumpáꞌá wésa mareꞌmareꞌ-únámbá túwówana nompímbá kumúwana sáwífaꞌ-mofaaꞌa minúnámpímbá ówitena tarárááráántamba úwasa ");
INSERT INTO auy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","moórá-nompin-taompimba miwítí waási mérowasa awánésa tiyáán-tuwaaꞌa ésa tasúwaꞌnai oro suwasá tésa minkáé-táómpimba mófááꞌa mósá márówana ówitena umbaí téna nompímbó kúwáférááraantamba úwana ");
INSERT INTO auy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sáímoni Pítaa miyámó úmba awánéna Ísu óraakon-iye séna aísamaifimba kífaena séna Fasiꞌaénkóo sáwí-waasi úmpo siyuwé waaó siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sáwífaꞌ-mofaaꞌo tóróntafena Pítaawe weséꞌo méron-kwaasiye táátafesa uwasá ");
INSERT INTO auy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sáímoniye mófááꞌo toꞌmaésarai núyawi Sépétin-ááninkai-tuwiꞌa moóráwigo Yémísi úwana moóráwigo Yóni mindáraiye táátafesarai uyaná Sáímoni Pítaa Ísuntafena séna Fasiꞌaénkóo sáwí-waasi úmpo siyuwé waaó súwana Ísu séna ímba ááꞌa íno. Mófááꞌo toꞌmaé wénomba minkísáú ifátuweꞌa káféꞌa waási tafisíyasa kesiráái wáéro súwasa ");
INSERT INTO auy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","mindómpín-táómba tafisímaesa nonáámááífaꞌa mámaresa miwítí kísau ifátuwesa Ísumba arááíwakaawe. ");
INSERT INTO auy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Moórá-kanaa Ísu moórá-naopaꞌa mérowana moóráwigo seyaafáꞌ-áúfáꞌó námombo kón-kwaasi Ísumba awánéna óraakon-iye séna aísamaifimba takífaena séna kentáfénamo ankáínamo e kanaaꞌá aúíꞌa uwásinkainone súwana ");
INSERT INTO auy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ísu ayáámba aneꞌá taꞌótorena séna miyá ónaumpo enáúraꞌa karefóꞌa kawáúwiye súwana minúwóíyáámbá kawáúguwana ");
INSERT INTO auy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ísu óraaka séna enáúraꞌa kawáúwifo naaófáꞌó Mósesemo siyáintemba ámáán-kisau-waasifaꞌa wéma enáú máaraatime póíma tímínasa Maníkóntáfésa ísámai tufúꞌmai agaíyasa seyaafáꞌnánká awánésa áúrakemba kawáúwiye sénááwe. Énifo enáúraꞌo uwánkaunda-aai simátimunafo sé waaó Ísu súwana ");
INSERT INTO auy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ifátuwena kaweꞌó uwánkon-aai simátímaꞌmaena iyúwana minááígó naaóꞌ-naoꞌa wété úwasa sáwífaꞌnanka tóso ésa wenáái wéiseꞌa onaná tíꞌo in-kwáásí asófatinkainkwae sésa tóso uwaná ");
INSERT INTO auy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","énifo Ísu Maníkómpáꞌá inaimó síndasafena máásai-marafaꞌa kógo uráiye. ");
INSERT INTO auy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Moórá-kanaa tuwímbai ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé Yérúsaremu-naopakene Káríri-aempakene Yúndiyaa-aempakene tóso ésa Ísu moórá-naumpaꞌa aaimó wésimatimumba taísaraawe. Maníkó Ísumba asófatinkainda-fasiꞌaemba amúwana mérowasa ");
INSERT INTO auy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","tuwímbai aísamaimo pukówimba wandaaifímbá marésa taawiyaꞌmaé tésa Ísumpaꞌa máánkáananasa kaweꞌá ínkwae sésa tumbá ");
INSERT INTO auy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","mindáúmpáꞌá sáwífaꞌ-waasi sisipáá uwasá ímba kanaaꞌó íyóraantamba ésa naanamifaꞌá taawiyaꞌmaé imésa afaaꞌá aúsámaresa ándára taꞌótoresa túwówana kumémena waásifimbo Ísumo mérompimba aúrankaꞌa kumúwana ");
INSERT INTO auy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ísu taawiyaꞌmaésamo tun-kwáásímó éraiꞌa kaweꞌá uwánkainiye-imayaamo umbá Ísu tuwánéna aísamaimo pukón-kwaasigontafena séna kesí waásiyo ení sáwí-imayaa maiyauwáúmne súwasa ");
INSERT INTO auy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé keáímbá sésa Maníkó weyáá sáwí-imayaa maitiyuwáínífo waási ímba miyá ónááfo Maníkómbá karaánááꞌa ánkáíye suwaná ");
INSERT INTO auy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ísu minímáyáámó umbá iséna séna nóra séra miyán-ímáyáá wéoo. ");
INSERT INTO auy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Moóráwigo aísamaimo pukáindawintafena sénamo ení sáwí-imayaa maiyauwáúmne sínasamo ésa éraira sí karorá síyó sénááwe. Énifo moóráwigomo aísamaimo pukáindawintafena sénamo eyááríkaꞌa íyáfasine waaó sínasamo ésa éraira sí karorá síyó awánánááwe. ");
INSERT INTO auy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kemá waási úranko marapáꞌó méraunda waásiti sáwí-imayaa maitiyúwáanda-fasiꞌaemba tokáumpo aráátíménda awánánááwe séna aísamaimo pukón-kwaasigontafena séna isaaó. Íyáfasine ení wandaaí maimaé ení naaópaꞌa waaó súwana ");
INSERT INTO auy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","túrankaꞌa íyáfasinkwena wení wandaaí wémaena Maníkón-áwíꞌa mósá maréna wení naaópaꞌa kúwasa ");
INSERT INTO auy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","seyaafáꞌnánká táátafesa ésa Maníkón-áwíꞌa mósá marésa sésa ímbo awánáúnda-iꞌa isatá awánáúmne sésa táátafesa ésa tiyáámba tóipimba fáákaawe. ");
INSERT INTO auy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ánaaemba Ísu aampaꞌá wéwena awánómba taakisi-kísáúmó maúwain-awiꞌa Rífái taakisimó máún-daumpaꞌa mérowana Ísu awánéna séna íyáfasine keséꞌa tiyó súwana ");
INSERT INTO auy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","íyáfasinena seyaafá-tántááꞌá tuwéna wembá arááíwaꞌmae wéna ");
INSERT INTO auy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ísuweꞌo náíndasafena wení naaúmpaꞌa óraa-tomba agaúwasa taakisimó máún-kwaasiye fíꞌo-fiꞌon-kwaasiye Rífáini naaúmpaꞌa tamésa mindáraiseꞌa tamésa tawémandowasa ");
INSERT INTO auy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ámáán-kawaa-waasiye miwítí ámáámbo sun-kwáásíyé Ísuni kísau-waasisafesa aaisambá tiyésa tísai esa sésa taakisimó máén-umen-kwaasiye sáwíꞌo on-kwáásíséꞌa tómbá wénaao suwaná ");
INSERT INTO auy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ísu iséna séna tíyofaan-kwaasi kaweꞌ-úmaimo méraan-kwaasi ímba wétuwaꞌnai-ofo tíꞌo in-kwáásí wétuwaꞌnai-owe. ");
INSERT INTO auy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mindásafeꞌa arupíse úmaimo méraan-kwaasi táántaanasa Maníkómpáꞌá tíwae séꞌa ímba kunkáumpo sáwíꞌo úmaimo méraan-kwaasi táántaanasa Maníkómpáꞌá tíwae séꞌa kunkáumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Suwasá tuwímbai Ísuntafesa sésa Yóni nombó maitínkáíwaini kísau-waasi moórá-mora-kanaa Maníkóntáfésa imáyáa ésa tómbá ímba wénesa inaí aantemba wésewasa ámáán-kawaa-waasiti kísau-waasiwaraꞌa miyá wéofo ení kísau-waasi ímba miyá ombá tóné noné úwoi wénaawe. Nóra sésawa miyá wéoo suwaná ");
INSERT INTO auy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ísu séna moóráwigo aaremó maíndawi amááraasomba tanómbo kautimínda miwíséꞌa mérainasa aamoí ésa mintómbá ímba aꞌáo sénááfo úwoi nánááwe. ");
INSERT INTO auy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ánaaemba minkwáásígómbá áíꞌmae kóíyana minkánáá amááraasomba tirunkó sáwíꞌa ínasa tómbá aꞌáo sénááwe Ísu séna wemó ánaaemba tiyuwénamo iyíndasafena minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ísu minááí simátimena maarán-ááí waéꞌmai-aai séna ááéraan-ampantamo afaaꞌó wéraisasamo ombá aú-ampanta ímba kárámai wéfaruwowe. Miyámó íyana aú-ampantago sáwíꞌa ínana ááéraan-ampantago aú-ampantaraamba ímba íníye. ");
INSERT INTO auy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aú-anda-aran-domba ááéraa-sipisipi-asi-anafeumpimba ímba wéfatimaraawe. Miyámó íyanamo éna aú-anda-aran-donko óraaꞌa éna ááéraan-anafeumba kafaména sáwíꞌa ínana mindómbá úwoifaꞌa fatíwiniye. ");
INSERT INTO auy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mindásafesa aú-anda-aran-domba aú-sipisipi-asi-anafeumpimba wéfatimaraawe. ");
INSERT INTO auy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ááéraan-anda-aran-dombo naawímó ombá sésa ááéraan-anda-aran-donko ásé wéiye sésa aú-anda-aran-domba ímba sínkáíye wésewe. ");
INSERT INTO auy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Moórá-kanaa Yúndaa-waasimo saagon-kánááráꞌá Ísuwe wení kísau-waasiye kísaufaꞌa wíti-ton-kisaufaꞌa wéwesa wení kísau-waasi wíti-aramba kútúmai ási pítuwesa nowasá ");
INSERT INTO auy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ámáán-kawaa-waasi tuwímbai tuwánésa sésa saagaan-kánáá aambá fáíꞌmakaawaꞌa nóra séra miyá wéoo suwaná ");
INSERT INTO auy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ísu séna naaófáꞌá Téfítimo uráimba aúfáífimbo agaimakáin-aaigoni áwáu ímba ísaraawe. Téfítiye wení waásiye táái tówana ");
INSERT INTO auy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Téfíti Maníkóní ámáán-daumpaꞌa iyéna Maníkón-aúrankaꞌo makón-tomba imaiyéna wénena wení waási timúwasa naráawe. Mintómbá úwoi-waasi ímbo néꞌómbanifo ámáán-kisau-waasi aantembo néꞌómbaniye. Téfíti mintómbá imaiyéna timúwasa nonkáꞌá Maníkó ímbo aaisambá siyáimbanifo kesí waási miyá owaꞌá aaisambá ímbo seráámbá wésewe. ");
INSERT INTO auy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wíyómpakemba waási úranko póꞌa saagaan-kánááráꞌó káráwiyaundawi úmpo saagaan-kánááráꞌó waásimo kísau máémba kendén-iye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Moórá-kanaa Yúndaa-waasimo saagon-kánááráꞌá Ísu ámáán-daumpaꞌa iyéna wésimatimuwana moóráwigo ayáánúrapaꞌ-ayaambo kemporarón-kwaasi mérowasa ");
INSERT INTO auy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé mésa Ísuntafesa saagáíyá póna minkwáásímó kaweꞌó uwánkainataamo éta taꞌótoꞌmaisa aaifintá maiyankánaumne sésa Ísumba awánomba ");
INSERT INTO auy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ísu minímáyáámó umbá iséna ayáámbo kemporarón-kwaasisafena séna íyáfasine kemó méraundaraꞌa imauwó súwana íyáfasinena Ísumpaꞌa túranka imaúwana ");
INSERT INTO auy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ísu miwísáféna séna moórá-aaisafeꞌa tísai ónaeꞌa súne. Kentáásí ámáán-aaifimba nóin-aaiya wéraiyo. Saagaan-kánáárá póta kawe-kísáúsááwá máúm sáwí-kisausaawa wémaumno. Waási túwaꞌnai onasasááwá kawerá óna tínkamonasasaawa puwónááo tísai ena súwasa ímba aaí suwaná ");
INSERT INTO auy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ísu mótuwana-metuwana éna ayáámbo kemporarón-kwaasisafena séna enayáámba fárútuwaao súwana ayáámba fárútuwowana kaweꞌá uwánkowana ");
INSERT INTO auy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","miwí tirumbá áfááraumai sáwíꞌa úwasa nóra úmaisaawa tufuwónaumno sésa kemó mérompimba keáímbá siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Minkánááráꞌá Ísu fenómpinka omápaꞌa iména ímba aúmá waéna Maníkómpáꞌá inaí símae wéiyuwana ");
INSERT INTO auy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","siyarówana Ísumbo arááíwaꞌmae kun-kwáásí táántowasa íyúwana minkwáásífínkémbá sísamaifakemba kaeꞌá kumbaimái-waasi toráumai séna kesí aantá-waasin-owe séna túwíꞌa siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Miwí túwíꞌa séna moóráwigo Sáímoniye séna aú-awiꞌa Pítaawe simánkena moóráwigo Pítaan-áfáko Énduruni moóráwigo Yémísini moóráwigo Yónini moóráwigo Fírípini moóráwigo Pátóromiyuni ");
INSERT INTO auy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","moóráwigo Mátíyuni moóráwigo Tómaasini moóráwigo Áráfíásin-ááninko Yémísini moóráwigo Sáímoni wemá Rómu-kamani-waasi tiꞌmátuwanae siyáiwaini ");
INSERT INTO auy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","moóráwigo Yémísin-ááninko Yúndasini moóráwigo Yúndasi-Ísakerioti wemá ánaaemba Ísumba wení namuro-wáásímó aráátímakaiwai miyáumai-waasi Ísu táántaraiye. ");
INSERT INTO auy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Omápakemba Ísu miwíséꞌa arúfáꞌá kumbérowasa wembó arááíwáún-kwaasi sáwífaꞌnanka Yúndiyaa-aempakene Yérúsaremu-naopakene Táyaa-naopaꞌe Sáíndóni-naopaꞌ-non-awaifakene sáwífaꞌ-waasisomba tamésa ");
INSERT INTO auy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ísun-aai isánae sésa tíꞌo ún-kwaasiwaraꞌa asófatinkainkwae sésa tóso ésa sáwí-amutamba tirumpimbó méron-kwaasiwaraꞌa tóso uwaná Ísu sáwí-amutamba tirumpinkémbá maitiyuwówasa ");
INSERT INTO auy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","tíꞌo ún-kwaasi Ísun-aneꞌá taꞌótoraanana síꞌa taiꞌáínkwae sésa miyá uwaná fasiꞌaémbá tokéna póna mintíꞌá asófatinkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ísu miyá uwátinkena wení kísau-waasi tuwánéna séna kembiwí Maníkó súwaꞌnai ínkwaemo sewí Maníkó miwí kaweꞌá uwátinkena miwíyáꞌá wégawaaniye. ");
INSERT INTO auy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Káféꞌa tááimo wétaiwai tirunkó fetóí ínaꞌa méraaro. Maníkó kanaá uwátinkainiye. Káféꞌa tirunkó sáwíꞌa isaꞌá ifiꞌó wétaawi tirunkó fetóí ínaꞌa méraaro. Tirunkó kaweꞌá ínaꞌa wíyáái ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kembiwí kemá waási úranko kumpaápé uráundawintafeꞌa fasiꞌámaimo méraawi waási tínaaembo uwátinkesa tíyámbo uwátinkesa sáwí-aaimo simátinkesa sáwí-waasin-owemo síyamba tirunkó fetóí ínaꞌa méraaro. ");
INSERT INTO auy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Miyá íyaꞌa tirunkó kaweꞌá ínaꞌa imá wéteꞌa wíyómpakemba kentí kaweꞌ-méyámbá maénááwe. Naaófáꞌá miwí tíwáꞌná miyá ésa Maníkón-aaimo simátímakaawi sáwíꞌa uwátínkaraawe. ");
INSERT INTO auy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Énifo marapákén-tántááꞌó makáawi káráwiyoro. Tirunkó kaweꞌó wéin-tantaaꞌa éꞌa makáamba póꞌa ímba moórá kaweꞌ-méyámbá maénááwe. ");
INSERT INTO auy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Káféꞌa tímúꞌo faiwáí káráwiyoro. Ánaaemba táái táíníye. Káféꞌa wíyááímo owí káráwiyoro. Ánaaemba ifiꞌá tánááwe. ");
INSERT INTO auy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Naaófáꞌá kentíwáꞌná karoꞌ-ááímó simátímakaawi-tuwiꞌa mósá makáamba pósa miyámó sésamo kentúwíꞌo mósá máréwaꞌo éꞌa káráwiyoro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ísu simátimena séna kemó simátíménda-aai ísáaro. Kesááimo iséꞌo éꞌa kentí namuro-wáásí tirumbá kaweꞌá uwátinkeꞌa tíyámbo uwátínkéwi kaweꞌá uwátínkáaro. ");
INSERT INTO auy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sáwí-aaimo simátínkéwi kaweꞌá uwátínkáaro. Sáwíꞌo uwátínkéwimo éꞌa Maníkómpáꞌá inaí símai miwí túwaꞌnai oro. ");
INSERT INTO auy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tááꞌo tuwaumíyaꞌo éꞌa ímba anondáá tínkameꞌa anekaꞌá waé-tíméro. Kentí unáánkwátói maiyésa sésa anekaꞌá maénae síyaꞌo éꞌa ímba aꞌáo seró. ");
INSERT INTO auy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Moórá-tantaaꞌa simiyó síyaꞌo éꞌa úwoi tíméro. Kendémó moórá-tantaaꞌo maíyaꞌo éꞌa ímba fuwafí séꞌa síméro seró. ");
INSERT INTO auy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kembó tirááímo táínda-iꞌo úmaimo túwaꞌnai íyaꞌa miwí miyáumai túwaꞌnai oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ísu simátimena séna seyaafáꞌnánká kentí waási-imayaamo owasamó ombá anondáá miwí-ímáyáá wéowe. Sáwíꞌo on-kwáásí ímba kaweꞌ-wáásí ombánifo miwítí waási-imayaamo owasamó ombá anondáá miwí-ímáyáá wéowe. Miyáumaimo kentí waási-imayaa aantembo íyanamo éna Maníkó ímba kaweꞌ-méyámbá timínífo kentí namuro-wáásíwáráꞌá imáyáa tíméro. ");
INSERT INTO auy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Seyaafáꞌnánká kaweꞌó uwátínkáán-kwaasi kaweꞌá wéuwatinkaawe. Sáwí-waasiwaraꞌa miyá wéowe. Miyámó onten-úmai kaweꞌó uwátínkáán-kwaasi aantembo kaweꞌó uwátínkéwanamo éna Maníkó ímba kaweꞌán-owe síníye. Kentí namuro-wáásíwárá kaweꞌá uwátínkáaro. ");
INSERT INTO auy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sáwí-waasi ánaaemba siménááwe-imayaa ésa wétimewe. Ánaaembo timíyan-kwaasi aantembo timíyanamo éna Maníkó ímba kaweꞌán-owe síníye. Ánaaemba siménááwe-imayaa ímbo íyamba úwoi tíméro. ");
INSERT INTO auy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kentí namuro-wáásí kaweꞌá uwátinkeꞌa imáyáa tíméro. Anondáá simíwae-imayaa ímbo íyamba úwoi tíméro. Miyámó íyambo éꞌa Maníkómpákémbá kaweꞌ-méyámbá maénááwe. Maníkó wentáfésa ímba súwimo sen-kwáásí úwoi túwaꞌnai ena sáwí-waasiwaraꞌa miyá isasá pósa waási kembiwí miyámó ombá tuwánésa sésa Maníkó wíyómpakewin-áánintomban-owe sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kentifo arumbó uwátínkáíntemba miyán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Tuwánéꞌo éꞌa sáwí-waasiye síyanamo éna Maníkó kentáfénawaraꞌa miyá sínífo tuwánéꞌo éꞌa sáwí-waasiye sefó. Umbai-tántááꞌó timíyanamo éna Maníkó kenkwáráꞌá miyá ínífo umbai-tántááꞌá tíméfo. Sáwíꞌo uwátinkaiyaꞌo éꞌa mintántááꞌá ímba imáyáamo íyamba ifátúwáaro. Miyámó íyanamo éna Maníkó kemó sáwíꞌo ombá maitiyuwáíníye. ");
INSERT INTO auy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Timíyantemba Maníkó anondáá kembá timíníye. Tómbó tíméwasamo nawááesa arááꞌo máráántemba Maníkó miyá úmai sáwífa-tantaaꞌa timíníye. Miyáumaimo tíméntemba Maníkó miyá íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ísu simátimena waéꞌmai-aai séna moórá aúgafitawi moórá aúgafitawimba ayáán-toꞌmaesarai ímba kanaaꞌá kóyááfo miyámó ésaraimo ésarai maipímbá tanaambá fáyááye. ");
INSERT INTO auy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iyámpóímo ésa uwáítáíꞌ-on-kwáásí ímba íyáákanaafo miwí táái ísámaesa íyantemba ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ísu simátimena séna kentúrampimba iya-arumbó wéraisaꞌo ombá ímbo awánaamba kentí waási tuwánéꞌa enaúrampimba ayaantambá wéraiye wésefo ímba miyá seró. ");
INSERT INTO auy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kentúrampimbo iya-arumbó ímbo awánaamba nóra séra kentí waási túrampinkemba tiyaantambá maitiyuwánae wéseo. Kaumbo-kaeꞌ-ááíwáráꞌ-wáásín-ofo kentúrampinkemba iya-arumbá maisukéꞌa tuwánéꞌa kentí waási túrampinkemba tiyaantambá kanaaꞌá maitiyuwánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ísu simátimena séna kawe-táígó ímba sáwí-aramba íyáísana sáwí-taigo ímba kaweꞌ-árámbá wéiyaifo ");
INSERT INTO auy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","mintáígón-aramba awánésa sáwí-taiye kawe-táíyé wésewe. Fekómó éna ímba áwíyanda-arankaamba iyáínífo feꞌ-arambá iyáíníye. Antirígó afoꞌafááꞌ-arankaamba ímba iyáínífo antirí-aramba iyáíníye. ");
INSERT INTO auy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Miyáumai kaweꞌ-wáásí kaweꞌ-ímáyááfínkémbá kawe-kísáú máéwasa sáwí-waasi sáwí-imayaafinkemba sáwí-kisau wémaewe. Tirumpin-ímáyááfínkémbá wésewe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ísu simátimena séna kentáfésa óraako óne sembánifo kemó simátimunda-aai ímba arááíwaꞌmai kaweꞌá wéowe. ");
INSERT INTO auy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kempáꞌó tésa kesáái isésa kaweꞌ-úmaimo arááíwaiyawi miyán-kwáásímó simátíméndaraꞌa ísáaro. ");
INSERT INTO auy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Naambá ónae sésa marafímbá maiꞌá uꞌmaé kumémesa óntamba kusaafá ésa minkáꞌá naamayáámba múfaimai naambá úmaraiyana aaꞌá téna óraaꞌ-nomba fínana mindámbá ímbo tawisínda fasiꞌámai wéena óntankaꞌ-namba póna úwoi wéíniye. Miyáráán-úmai waásimo kempáꞌó tésa kesáái isésa kaweꞌ-úmaimo arááíwáéwi fasiꞌámai ménaawe. ");
INSERT INTO auy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Énifo kesáái isésamo ímbo kaweꞌ-úmaimo isáíyawi miyán-kwáásímó simátíméndaraꞌa ísáaro. Naambá ónae sésa ímba maiꞌó ukésamo íyamba paákáꞌá úmakaiyana óraaꞌ-aꞌa téna nombá fiyéna mindámbá tawísísuwainana sáwíꞌa íníye. Miyáráán-úmai ímbo kesáái ísámaimo kaweꞌó íyawi ímba fasiꞌámai ménaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ísu mináyáátááꞌ-ááí simátimena Kápaneamu-naopaꞌa kúwana ");
INSERT INTO auy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rómu-i-waasiti kawáágó wení kísau-waasi aráái tówimba áíꞌa úwana puwíndasafena wéuwana ");
INSERT INTO auy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","minkáwáágó Ísumo taméron-aai iséna Yúndaa-oraaꞌ-waasisafena séna Ísumba koáíꞌmae tíyana taasófankaino séna tiꞌmarówasa ");
INSERT INTO auy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ísumpaꞌa óraaka kosésa minkáwáágó Yúndaa-waasisa súwaꞌnai ena kentáásí ámáán-damba úmakaifo kaweꞌ-wáásí po kaweꞌ-úmai koáwaꞌnai ínone suwaná ");
INSERT INTO auy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ísu iséna miwíséꞌa wéna minkáwáágóní naambá ewaaꞌó wéronkaꞌa kúwana minkáwáágó wení waási simátimena séna Ísumba kosimámeꞌa maará seró. Óraakoo kentáásí kawáágó séna kemá káriꞌ-waasi úmpo emá óraaꞌ-waasi ómpo ifátuwe kesí naaúmpaꞌa ímba iyínone. ");
INSERT INTO auy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mindásafeꞌa ímba empáꞌá kosimámakaumpo ímba kesí naaúmpaꞌo íyínda úwoi aaí aantemba sinaná kesí kísau-waasi asófáíno. ");
INSERT INTO auy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kewáráꞌá kawáá-kísáúgóní áwáuma awánáúnda kesí kawáágó sisaꞌá wení kísau maéꞌa kesí i-wáásísáféꞌa súnasa kesí kísau wémaewe. Moóráwigontafe séꞌa waaó súnana wisaꞌá moóráwigontafe séꞌa tiyó súnana tisaꞌá kesí kísau-waasisafeꞌa miyá uwómó súndantemba miyá wéiye siyé. Ísumba kosimáméro súwasa tiꞌmarówi tésa tasimámúwana ");
INSERT INTO auy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ísu minááí iséna áátafena éna kowaeréna wembó arááíwaꞌmae kun-kwáásísóntáféna séna simátime séꞌa minkwáásí Rómu-waasigo kentáféna súwaꞌnai índa-fasiꞌaemba tokáiye wésifo kesí waási Ísareri-waasifinkene fíꞌon-kwaasifinkene ímba miyán-ááí wésewe Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tiꞌmarón-kwaasi kouweré tésa taawánomba kísau-waasigo kaweꞌ-úmai mérowasa taawánaraawe. ");
INSERT INTO auy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ísu kárikaꞌa ména tiyuwéna wení kísau-waasiye sáwífaꞌ-waasiye kúmba Néni-naopaꞌa wéna ");
INSERT INTO auy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","mindáókoni óntan-kusaigoni ontaráꞌó kúnkaꞌa moórá-ketoꞌ-ininkon-ááninko puwúwasa taawiyaꞌmaésa sáwífaꞌ-waasi anówae wétuwana ");
INSERT INTO auy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Fasiꞌaénkó anówambo awánómba arumbá uwánkena séna ímba ifiꞌá taaó séna ");
INSERT INTO auy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","makón-taareraꞌa kotaꞌótorowasa taawiyaꞌmaé tun-kwáásí tamáúwana Ísu séna ifóꞌ-wáásígóo íyáfasinaao súwana ");
INSERT INTO auy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","pukómpinkemba íyáfasinena aaí súwana Ísu anówantafena áíꞌmae waaó súwasa ");
INSERT INTO auy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","seyaafáꞌnánká táátafesa ésa Maníkón-áwíꞌa mósá marésa sésa káféꞌa Maníkón-aaimo sin-kwáásí óraaꞌ-waasi kentááfímbá paápé iye. Maníkó aiꞌmáráísana wení waásisaamo súwaꞌnai índa-waasisa kúmíye suwaná ");
INSERT INTO auy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","minááí Ísuntafesamo sun-ááígó Yúndiyaa-aempaꞌa seyaafáꞌ-áémpá wété uráiye. ");
INSERT INTO auy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Minááígó wété úwasa Yónini kísau-waasi isésa Yónimba kosimámúwana wení kísau-waasiyai táántowasarai tuyaná ");
INSERT INTO auy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","simátimena séna Ísumba maanááí koáísai okaiyó. Emá kumínonemo siyáawiyaꞌo fíꞌowawa ónómpo kemá kumíndawimba amuꞌmaránaumno siyé. Kosekaiyó Yóni súwasarai isésarai ");
INSERT INTO auy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ísumpaꞌa tasimámesarai Yóni nombó maitínkáíwai siꞌmáráísakai empáꞌá túye. Yónimo simbá kumínonemo siyáawiyaꞌo fíꞌowawa ónómpo kemá kumíndawimba amuꞌmaránaumno siyé. Ísumba tasimámúyana ");
INSERT INTO auy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","minkánááfímbá Ísu sáwífaꞌ-waasi fíꞌo-fiꞌon-tiꞌa ún-kwaasi kaweꞌá uwátinkena sáwí-amutamba tirumpinkémbá wémaitiyuwena túrambo kafíkón-kwaasi túramba awánamai kaweꞌá uwaná ");
INSERT INTO auy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ísu Yónimo tiꞌmarón-kwaasisafena séna tauwerékai awánááyane isááyane Yónimba kosimáme sékai túrambo kafíkáiwai túramba awánamai kaweꞌá owaná tááꞌo káúnkaiwai tááꞌa ísááwana tísamaimo pukáiwai kaweꞌ-úmai tín-taawaná námombo kaiwáí kaweꞌá uwátinkena pukáan-kwaasi íyáfasintinkena úwoi-waasi ásé-aai simátimena séna ");
INSERT INTO auy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","kentáfésa ímba kaeꞌ-ímáyáá íyawi tirunkó kaweꞌá wéiye siyé. Yónimba kosimámékaiyo Ísu súwasarai kurááye. ");
INSERT INTO auy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yónini kísau-waasiyai tauwerésarai kuyaná Ísu Yónin-aai seyaafáꞌ-wáásí simátimena séna Yóni máásai-marafaꞌa méraisaꞌa koawáné nóran-imayaawa wéera koawánaraao. Fiyúndá toréna umó mómaꞌmemaꞌo intenkáán-kwáásí Yóni iyé-ímáyááwá uráao. Ímbanifo Yóni ímba miyán-kwáásín-ifo fasiꞌaén-kwáásín-iye. ");
INSERT INTO auy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nóran-imayaawa wéera koawánaraao. Kaweꞌ-únánkwátói úmakain-kwaasi Yóni iyé-ímáyááwá uráao. Ímbanifo miyán-kwáásí kaweꞌ-únánkwátóiwara óntawaraꞌ-waasi óraaꞌ-waasiti naaúmpaꞌa méraawe. ");
INSERT INTO auy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nóran-imayaawa wéera koawánaraao. Maníkón-aaimo siwáí Yóni iyé-ímáyááwá uráao. Ewé Maníkón-aaimo siwáín-iye. Éraiꞌa simátime súne. Wemá Maníkón-aaimo siyáawi íyáákaraiye. ");
INSERT INTO auy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Maníkón-aai aúfáífimba Yónin-aai símai agaimaréna séna Maníkó séna isaaó. Moóráwigomba aiꞌmáráanana kesáái maimaéna ení aifaꞌá wéna ení aambá wiyíníye siyáiye agaimaréna siyáimba Yónintafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Simátime séꞌa Yónini kísaugo seyaafáꞌ-wáásítí kísaugomba íyáákaisana Maníkó kaweꞌá uwánkaraifo Maníkó wení waásiyaꞌo kawáánin-kwaasi óraaꞌ-waasiye úwoi-waasiye óraa-kaweꞌa uwátinkainiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Taakisimó máún-kwaasiye úwoi-waasiye minááí isésa Maníkómó siyáin-aai éraiꞌ-aai póta konanasá nombá maisinkáínkwae sésa Yónimpaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Énifo Yóni Maníkóní aambó aráátímakaimba ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé minámbá tínaaemba uwámesa ímba nombó máúmba kóuraawe. ");
INSERT INTO auy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ísu moórá-aaiwaraꞌa simátimena séna káféꞌo méraan-kwaasi nóran-kwaasiyaanewa sénaumno. ");
INSERT INTO auy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Miyán-kwáásíyáámbán-owe. Iyámpóísomba naaópaꞌa marupímbá mésa ááféma wétesa moórá-aempaꞌo méraan-iyampoi táántesa sésa tiyéꞌa imá seró. Moórá-isa súnaꞌa ímba táásái uráawe. Tirumbó in-ísá súnaꞌa ímba ifiꞌá taráawe siyáawe. Énifo miníyámpóímó uráantemba maaméraan-kwaasi miyá wéowe. ");
INSERT INTO auy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yóni nombó maitínkáíwai ména ándá-aran-domba ímba wénena Maníkóntáféna imáyáa éna tónkwáráꞌá ímba wénaisaꞌa wentáfé séꞌa sáwí-amutamba arumpimbó méraiwain-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kemá waási úranko méꞌa ándá-aran-donkwara tónkwáráꞌá náúnaꞌa kentáfé séꞌa ándá-aran-done tóntéꞌo námae íyíwai póna taakisimó máén-umen-kwaasiye sáwíꞌo on-kwáásítí waásin-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Énifo Maníkó simátímakaintembo owí sésa Maníkó kaweꞌ-ímáyááwáráwín-iye wésewe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Moórá-kanaa ámáán-kawaa-waasigon-awiꞌa Sáímoni Ísuntafena séna kesí naaúmpaꞌa tómbá tamandaaó súwana wení naaúmpaꞌa iyéna tómbá iwénowana ");
INSERT INTO auy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","mindáópaken-aankaroꞌ-ininko Ísu ámáán-kawaa-waasigoni naaúmpaꞌa ména tómbá wénaiye-aai minínínkó iséna óntan-anafeumpimba asaa-wiyúmbó úm-basawembo wéromba maimaéna ");
INSERT INTO auy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","mindáúmpáꞌá iyéna Ísun-ánaaempaꞌa aísamaifimba iména ifiꞌá wétowana aꞌní kaꞌmaéna Ísun-aísamaiyaꞌa kumúwana minínínkó ayáátááꞌ-aꞌnontausamba aísamaiyakemba wéuwaena aísamai wéamoꞌnena asaa-wiyúmbó úm-basawemba aísamaiyaꞌa fatímarowana ");
INSERT INTO auy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ámáán-kawaa-waasigo Ísumbo áántowi awánéna imáyáa éna séna minkwáásígó Maníkón-aaimo siwáímó inkakaa aísamaiyaꞌo itaꞌótokain-ininko aankaróꞌ-ínínkó iyé-ímáyáá isinó séna miyán-ímáyáá úwana ");
INSERT INTO auy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ísu minkwáásígóntáféna séna Sáímoniyo moórá-aai simámenae súwana minkwáásígó séna óraako siyó súwana ");
INSERT INTO auy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ísu séna moóráwigo óntambo tímíwai ména moóráwigomba sáwífaꞌ-ontamba siyáánkai-taemoꞌ-ontamba aména moóráwigomba káriꞌ-ontamba moórá-taemoꞌ-ontamba ámísana ");
INSERT INTO auy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","aanáfómbó amí-kánáá tisasaráí óntamba ímba wéraisasarai saafá uwááesarai wempáꞌá tíyana séna kanaán-ifo ímba méyámbá maénaumpo kenkáítí méyán-túwíꞌa tuwígaufatuwaumpo kokaiyó siyáiye-aai Ísu Sáímonimba simámena séna mindásafena miyámó sintáféna minkáéꞌ-wáásígóráí tirunkó aamoí wéuwankaaye. Moóráwigo áfááraumai aamoí wéuwankaimba nááwaꞌiyo Ísu áísai ena súwana ");
INSERT INTO auy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sáímoni séna sáwífaꞌ-ontambo maiyénamo aanáfómbó ímbo máamisanamo méyán-áwíꞌa tuwígáúfatuwaiwai óraaꞌ-aamoi wéuwankaiye Sáímoni súwana Ísu séna mindásafeꞌo súnda éꞌa séne simásuwena ");
INSERT INTO auy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","koutauséna minínínkómbá awánéna Sáímonintafena séna minínínkómbá awánaao. Ení naaúmpaꞌo iyúnda kentáásí áwáu sísamaimo non-kwiyí-nómbá ímba siménana minínínkó ifiꞌá taisaná aꞌnimá sísamaiyaꞌa kúmísana wení aꞌnóntáusamba uwákáiye. ");
INSERT INTO auy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ímba aaweyáá uwásinkaanana minínínkó sísamai taamóꞌna-amoꞌna uráiye. ");
INSERT INTO auy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kentáásí áwáu ímba siꞌnómpáꞌá masawémba asinkáánana minínínkó sísamaiyaꞌa asaa-wiyúmbó im-básáwémbá fatímai asínkáíye. ");
INSERT INTO auy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Minááí simáme súne. Minínínkóní seyaafá-sáwí-ímáyáá maisuwáúnda póna kembá óraaꞌ-aamoi uwásinkena miyán-tántááꞌá kaweꞌá uwásínkáíye. Énifo moóráwigombo kári-sawi-tantaaꞌo maisuwáúnda káriꞌ-aamoi uwásínkáíye Ísu Sáímonintafena simásuwena ");
INSERT INTO auy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","minínínkóntáféna séna ení sáwí-imayaa maisuwáúmne súwasa ");
INSERT INTO auy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","weséꞌo tómbó wénon-kwaasi keáímbá sésa waásiti sáwí-imayaa wémaitiyuwaiwai mindá nóran-kwaasiyaꞌiyo suwaná ");
INSERT INTO auy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ísu minínínkóntáféna séna kentáfé amankúnkúmba ónaꞌa ení sáwí-imayaa maisuwéꞌa kaweꞌá uwánkaumpo aáno úmai enarunkó kaweꞌá ína waaó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Minkákémbá Ísu naaóꞌ-naoꞌa óraaꞌ-naopimpaꞌe káriꞌ-naopimpaꞌe wénena Maníkó wení waásimo kawáánin-aai ásé-aai simátímaꞌmaena iyáiye. Ísuwe wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi wénuwasa ");
INSERT INTO auy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tuwímbai-ininte wénesa miníníntómbá tuwímbai tíꞌa úwana Ísu kaweꞌó uwátínkaron-inimba uwasá tuwímbai tirumpinkémbá sáwí-amutambo maitíyukain-inimba uwaná moórá-inimba Mágátáraa-naopakemba áwíꞌa Máríyaa Ísu wenarumpinkémbá afakaeté-sawi-amutambo maiyáúkon-ininko úwana ");
INSERT INTO auy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","moórá-ininkon-awiꞌa Yóána awaaikón-áwíꞌa Súsa wemá Érotini naankaꞌó káráwiyowi úwana moórá-ininkon-awiꞌa Súsáana úwasa tuwímbai-ininkwaraꞌa uwasá miyáumai-inimba ésa kentí moparáwímpínkémbá Ísune wení kísau-waasiye túwaꞌnai úmaesa kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Naaóꞌ-naoken-kwaasi sáwífaꞌa Ísumpaꞌa tóso uwaná Ísu simátimena séna ");
INSERT INTO auy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","moóráwigo ánáuntumba maimaéna kísaufaꞌa wéwena mátuꞌmaraisana tuwímbai-anauntumba aampaꞌá kuwéraisasa waási tasasámpasukaawana numagó fáíꞌnasukaiye. ");
INSERT INTO auy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tuwímbai-anauntumba óntankwaraꞌ-marafimba kuwéna karuwéna anoníyaim-barafaꞌa póna aáénkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tuwímbai-anauntumba karaampaꞌá kuwéna kárúraisana karaan-tantáákó fandundupásukaiye. ");
INSERT INTO auy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tuwímbai-anauntumba kaweꞌ-máráfímbá kuwéna karuwéna óraaꞌa éna arambá imái sáwífaꞌ-aramba iyáiye. Ísáán-kwaasi ísámai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Súwasa Ísuni kísau-waasi Ísuntafesa minkwáéꞌmáí-ááígóní áwáu sinatá ísáano suwaná ");
INSERT INTO auy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ísu séna Maníkó wení waásimo kawáánin-aaigoni áwáumo simátimunda Maníkó kembiwí imáyáa tímísaꞌa wéisaafo fíꞌon-kwaasi waéꞌmai-aai aantemba wésimatimumpo ísáámbanifo ímba ísámai kaweꞌá wéowe. Awánaambanifo ímba awánamai kaweꞌá wéowe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ísu simátimena séna minááígóní áwáumo sendá ísáaro. Moóráwigo ánáuntumbo tuꞌmáráínten-úmai Maníkón-aai simátímísana ");
INSERT INTO auy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","tuwímbai-anauntumbo aampaꞌó kúmímba waási tirumpintá kúmísasa Maníkón-aai ísááwana waántáwanko imáyáa éna Maníkón-aaisafesa timankúnkúmba íyana sáwí-ampakemba kaweꞌ-ámpáꞌá métínkáífo séna tirumpinkémbá tamaimái úwoifaꞌa wétiyuwaiye. ");
INSERT INTO auy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tuwímbai-anauntumbo óntankwaraꞌ-marafimbo kúmímba waási tirumpintá kúmísasa Maníkón-aai isésa aamoí ombánifo ímba tirumpimbá taꞌótoꞌmai kaweꞌá ontáfésa kárikaꞌa timankúnkúmba owaná fíꞌo-fiꞌon-tantaako tisasá miwán-ímáyáá ésa Maníkón-aai ifátukaawe. ");
INSERT INTO auy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tuwímbai-anauntumbo karaampimbó kúmímba waási tirumpintá kúmísasa Maníkón-aai ísáámbanifo marapáꞌ-úmbáí-tántáátáfésa imáyáa úmae nésa ónta-imayaa úmae wénesa fíꞌo-fiꞌon-tantaaꞌa maénae símae nésa miyán-ímáyáágó Maníkón-aai faráátasuwaisasa ímba Maníkóní kísau wémaewe. ");
INSERT INTO auy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tuwímbai-anauntumbo kaweꞌ-máráfímbó kúmímba waási tirumpintá kúmísasa Maníkón-aai isésa kaweꞌ-ímáyááwáráꞌ-wáásí isésa tirumpimbá taꞌótoꞌmai kaweꞌá ésa fasiꞌámai mésa Maníkóní kísau maésa fíꞌowi wétuwaꞌnai-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ísu simátimena séna ómbó kúraꞌmaraamba ímba aúpáꞌá marésa ímba taare-améndaampaꞌa maránááfo aforaꞌá mósá makéwasa seyaafáꞌnánká naaúmpaꞌo iyíyamba awánánááwe. ");
INSERT INTO auy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Miyámó onten-úmai aúpáꞌó wérain-tantaaꞌa seyaafáꞌá aforá paápé ínasa awánánááwe. Kumeupáꞌó wérain-tantaaꞌa aforá paápé ínasa awánánááwe. ");
INSERT INTO auy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ísáán-aai imáyáa úmai kaweꞌán-oro. Maníkón-aaimo ísámaimo kaweꞌó owí Maníkó túwaꞌnai ínasa moórá-aaiwaraꞌa isánááwe. Maníkón-aaimo ímbo ísámai kaweꞌó ésa karoꞌá sésa kaweꞌ-úmai wéisaumne sewí tirumpinkémbá maimaínana ímba wéíniye. Mindásafeꞌa ísáán-aai imáyáa úmai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Súwasa Ísun-anówawe Ísun-áfárawaisaiye tésa sáwífaꞌ-waasi Ísuwe mésa sisipáá uróntafesa ímba naaúmpaꞌo íyúmba máápata tamérowasa ");
INSERT INTO auy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","mindáúmpáꞌó méron-kwaasi Ísuntafesa sésa enanówe enáfárawaisaiye embá awánánae sésa máápaꞌa taméraawe suwaná ");
INSERT INTO auy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ísu seyaafáꞌ-wáásísáféna séna Maníkón-aaimo isésa kaweꞌó íyawi kesinówe kesífárawaawin-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Moórá-kanaa Ísu wení kísau-waasiseꞌa nompín-táómpimba íyátena nonkwaaúnkóní menáípáꞌá kónae séna miwíséꞌa kúmba ");
INSERT INTO auy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ísu aún-kwaigurówana minkwaaúmpáꞌá óraa-fiyunda torówana nonkó tufántááfan-éna nompín-táómpimba ówitowasa kúwáfekunafo sésa ");
INSERT INTO auy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","inkaisésa Ísumba koaúsésa sésa óraakoo puwúnafosaawe suwaná Ísu íyáfasinena fiyúndágonte nonkóntétafena óraaka séna mafáékaiyo súwasarai fiyúndágoe nonkóeꞌa mafáúyana nonkó étuwowana ");
INSERT INTO auy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ísu simátimena séna kentáféꞌa nóra séra ímba timankúnkúmbo onkákéná wéseo súwasa táátafesa ésa keáímbá sésa nóran-kwaasiya isanawá fiyúndágoe nonkóeꞌa wenáái isaíyó sésa tiyáámba ufakésa táátafesa ésa siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Simásuwesa mindómpín-táómpimbo kumbá Káríri-marama tínaaempaꞌa wérowana Kégésaa-marama túrampaꞌa wérowasa ");
INSERT INTO auy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","mimbáráfáꞌó kumbá Ísu mindómpín-táómpinkemba mimbáráfáꞌá kumúwana moóráwigo mindáópakewi Ísumpaꞌa téna wenarumpimbá sáwí-amutamba mérowana póna ayáátáákaꞌa unáánkwátói-iyaimba ména ímba wení naaúmpaꞌo maúmba waásimo utátínkón-ontan-aifaꞌa mérowana ");
INSERT INTO auy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","sáwífa-kanaa misáwí-ámútánkó sáwíꞌa uwánkowasa waási káráwiyesa aíyayaankaꞌa káráꞌumarowana minándá tarátuwena misáwí-ámútánkó áíꞌmaena máásai-marafaꞌa máánkarowana Ísumo túmba awánéna wááꞌa túwana Ísu sáwí-amutankontafena séna auwé kóuwo súwana Ísu óraakon-iye séna aísamaifimba kífaena óraaka séna Ísuwo íyáákamai-Fasiꞌaenkon-ááninko ómpo sínkamonafonifo nóra uwásinkainono súwana ");
INSERT INTO auy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ísu séna enáwíꞌa nááwaꞌono súwana minkwáásígó sáwífa-sawi-amutamba wenarumpimbó mérontafena séna kesúwíꞌa sáwífaꞌnanka úne séna mérowasa ");
INSERT INTO auy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","omápaꞌa sáwífa-poi mésa umá wénowasa minkwáásígó arumpinké-sáwí-ámútántómbá Ísuntafesa óraaka sésa waántáfaꞌa ímba siꞌmaraaó. Mimpóí tirumpintá siꞌmaraaó suwaná miyán-oro súwasa ");
INSERT INTO auy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","sáwí-amutantomba minkwáásígón-arumpinkemba kárúwesa póí-tirumpimba koférówasa mimpóísómbá seyaafáꞌá ámémpakemba tuwaantantésa nonkwaaúmpímbó kúwáférómba putásowasa ");
INSERT INTO auy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","póíyaꞌo káráwiyowi awánésa minúwóíyáán-úmai naaópaꞌa wésa kísaufakaꞌo méron-kwaasi mósimatim-besimati uwasá ");
INSERT INTO auy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","isésa koawánánae sésamo kumbá Ísumpaꞌa kotúwaandu ésa awánomba sáwí-amutamba arumpinkémbó kóun-kwaasigo unáánkwátói úmarena Ísun-aísamaifimba kaweꞌ-úmai mérowasa koawánésa táátafesa uwasá ");
INSERT INTO auy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ísu minkwáásígómbó kaweꞌó uwánkowasamo awánon-aai simátímúwasa ");
INSERT INTO auy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","isésa áfááraumai táátafesa ésa pósa Kégésaa-marafaken-kwaasi seyaafáꞌnánká Ísuntafesa sésa maambáráfáꞌá ifá siyuwésa kóuwo suwaná nompín-táómpimba íyátowana ");
INSERT INTO auy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","sáwí-amutambo maisuwón-kwaasigo Ísuntafena óraaka séna eséꞌa kónae súwana ímbanifo ");
INSERT INTO auy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ení naaópaꞌa kuré Maníkómó embó kaweꞌó uwánkáín-aai kosimátimiyo súwana Ísumo uwánkon-aai mindáópaꞌa simátímaꞌmaena kuráiye. ");
INSERT INTO auy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ísu Káríri-waaunkoni menáípákémbá nompín-táómpimba kouweréna túmba sáwífaꞌ-waasi amuꞌmakówana túwasa aamoí uwaná ");
INSERT INTO auy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","moóráwigo ámáán-dankaꞌo káráwiyowin-awiꞌa Yáírási téna Ísu óraakon-iye séna aísamaifimba kífaena óraaka séna kímbora kesiyáámúmba puwíndasafena wéifo tiyé aneꞌá kotaꞌótorenana asófáíno súwana minínáámárúgó sísamaifakemba kaeꞌá kumbaimái-aatai maisukáin-arasigontafena afowá tasúwana Ísu weséꞌo kúmba sáwífaꞌ-waasi Ísumba úkúresa arááíwaꞌmae kuwaná ");
INSERT INTO auy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","moórá-ininkomba áíꞌa ún-ininko sísamaifakemba kaeꞌá kumbaimái-aatai naaeyámba ankówasa ímba kanaaꞌá asófankowana mináíꞌá úwoi wérowana ");
INSERT INTO auy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","minínínkó sáwífaꞌ-waasifimba Ísumba arááíwaꞌmae wéwena wení unáánkwátói-araiyaꞌa kotaꞌótorowana mindááéyánko éꞌankowana ");
INSERT INTO auy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ísu séna nááwawa kesí unáánkwátóiyaꞌa taꞌótóráínaꞌiyo súwasa seyaafáꞌnánká sésa ímbaniye suwaná Pítaa séna óraakoo sáwífaꞌ-waasi faméꞌmaesamo íyómpimba taꞌótokaawe súwana ");
INSERT INTO auy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ísu séna kempínké-fásíꞌáénkó moóráwigomba kaweꞌó uwánkáímba awánéꞌa séꞌa moóráwigo kesí unáánkwátóiyaꞌa taꞌótokaiye súne súwana ");
INSERT INTO auy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","minínínkó imáyáa éna ímba aúpáꞌá úmpo éꞌa suwánaraiye-imayaa éna anekembá tataꞌá úwana Ísun-aísamaifimba kífaena seyaafáꞌ-wáásí túrankaꞌa wení unáánkwátóiyaꞌo taꞌótorowanamo asófankon-aai simátimuwana ");
INSERT INTO auy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ísu séna kesímánaako kentáfé sé éraiꞌa súwaꞌnai índawin-iye sénda póna áíꞌa éꞌánkáífo kaweꞌ-úmai waaó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ísu minááí wésuwasa ámáán-dankaꞌo káráwiyowini naaópaken-kwaasi tésa Yáírásintafesa sésa enayáámúnko pukáifo óraakontafe ténafo simámuwo suwaná ");
INSERT INTO auy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ísu minááí iséna Yáírásintafena séna minááísáfé ímba áákauraumo indá kentáfé amankúnkúmba inaná enayáámúnko kaweꞌ-úmai méíniye Ísu séna kúmba ");
INSERT INTO auy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yáírásini naankóní ewaaꞌá wéna arááíwaꞌmae kun-kwáásísóntáféna maankáꞌ-méwaro séna Pítaane Yónine Yémísine minárásígón-anófoiye tíꞌmaena naaúmpaꞌo iyúmba ");
INSERT INTO auy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","mindáúmpáꞌó méron-kwaasi óraaꞌ-ifiꞌa wétowana Ísu séna ímba ifiꞌá taaró. Minárásígó ímba pukáifo úwoi aúmá wéraiye súwasa ");
INSERT INTO auy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","minkwáásísómbá éꞌa pukuráiye-imayaa ésa Ísun-awíyáái uwaná ");
INSERT INTO auy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ísu minárásígón-ayáánkaꞌa taꞌótorena séna inaamarúgóo íyáfasinaao súwana ");
INSERT INTO auy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","minárásígón-amanko arupimbá túwana minúwóíyáámbá íyáfasinowana Ísu séna tómbá amíyana náíno súwasarai ");
INSERT INTO auy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","anófoi táátafesarai uyaná Ísu óraaka séna kemó únda-aai ímba simátímékaiyo siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ánaaemba Ísu wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi táántowasa tuwaná waási tirumpinkémbá sáwí-amutamba maitíyuꞌmaeꞌa nóro-fasiꞌaemba tiména tíꞌo índa-waasi asófatinkai-fasiꞌaemba tiména ");
INSERT INTO auy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","séna Maníkó wení waásimo kawáánin-aai kowésimatimeꞌa tíꞌo índa-waasi wéasofatinkeꞌa oro séna ");
INSERT INTO auy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","aampaꞌó wíyamba ímba moórá-tantaaꞌa maimaé koró. Táúmba ímba maimaé wéꞌa tón-únámbá ímba maimaé wéꞌa tómbá ímba maimaé wéꞌa óntamba ímba maimaé koró. Moórá-mora unáánkwátói timantentén-úmai kuféꞌmae koró. ");
INSERT INTO auy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maníkón-aaimo simátimiyantafeꞌa moórá-naopaꞌo wíyamba naambó timíyaꞌa mindáúmpáꞌ-aantemba méꞌa kentí kísau maimái taiꞌéꞌa mindámbá tuwéꞌa fíꞌon-daopaꞌa koró. ");
INSERT INTO auy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Moórá-naopaꞌo wíyasamo ímbo naambó timíyana Maníkó mindáópaken-kwaasi ímba aamoí uwátinkainifo aiyowáíꞌa éꞌa tísamaifakem-baramo uwáéntemba uwáꞌmareꞌa koró Ísu simátimuwasa ");
INSERT INTO auy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","wení kísau-waasi tuwésa naaóꞌ-naoꞌa wénesa Maníkóní ásé-aai simátímaꞌmae wéwesa tíꞌo ún-kwaasi asófatinkafaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ísuni kísaugon-aai símae íyúwana Káríri-marafaken-kawaagon-awiꞌa Éroti minááí iséna óraaꞌ-imayaa uráiye. Ísuntafesa tuwímbai sésa wemá Yóni nombó maitínkaraiwai pukáimpinkemba íyáfasinkaiye suwasá ");
INSERT INTO auy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","tuwímbai sésa wemá Maníkón-aaimo simátímakaiwain-awiꞌa Íráiyaa pukáimpinkemba íyáfasinena méraiye suwasá tuwímbai sésa wemá naaófáꞌá Maníkón-aaimo simátímakaawifinkemba moóráwigo pukáimpinkemba íyáfasinkaiye suwaná ");
INSERT INTO auy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Éroti miséyááfáꞌ-ááí iséna séna kemá séwánasamo Yónimba anuwarambá kambísówanamo pukáimbanifo minááímó wésemba nááwaꞌiyompo awánánaumne Éroti símae iyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ísuni aantá-waasi Ísumo timún-kisau maisuwésa wempáꞌá tésa seyaafá-kísáúmó máún-aai simámúwana Ísu miwí aantemba tíꞌmaena Pétésáíta-naopaꞌa komérowasa ");
INSERT INTO auy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","énifo sáwífaꞌ-waasi isésa arááíwaꞌmae kuwaná Ísu tuwánéna aamoí éna Maníkó wení waásimo kawáánin-aai simátimena tíꞌo ún-kwaasi asófatinkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Asófatinkowasa fenómpinkaꞌa wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi Ísumpaꞌa tésa sésa ímbo sáwífaꞌ-waasi méraapaꞌan-ifo fenáíndaraꞌa tiꞌmárénasa ewaaꞌ-náópimpaꞌa wénesa tóné naané saafá oro suwaná ");
INSERT INTO auy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ísu simátimena séna kemá tómbá tíméro súwasa miwí sésa kári-tomba séfataasewara kaeꞌ-mófááꞌwáráꞌá wéraifo sáwífaꞌ-waasifimba ímba kanaan-ínífo tómbá koméyánorowa wéseno áísai esa suwasá ");
INSERT INTO auy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","sáwífaꞌ-waasi 5,000 waai uwasá aarewé iyámpóíye mérowana Ísu wení kísau-waasisafena séna unkwimaꞌmái tuwínkaa tuwinkaaꞌ-úmai 50 50 maraꞌá méraaro simátíméro súwasa ");
INSERT INTO auy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","isésa miyá uwátínkówana ");
INSERT INTO auy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ísu séfataase-tonkwara kaeꞌ-mófááꞌwáráꞌá maisoréna wíyómpaꞌa kararéna Maníkóntáféna súwi simásuwena mintómbá tafántafan-úmai wení kísau-waasi timúwasa misáwífáꞌ-wáásí tímúwasa ");
INSERT INTO auy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","seyaafáꞌnánká nowaná tímúꞌa fówasa Ísuni kísau-waasi mintón-ayai sísamaifakemba kaeꞌá kumbaimái-unampimba fáítuwana ówitaraiye. ");
INSERT INTO auy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Moórá-kanaa Ísuwe wení kísau-waasiye mérowana Ísu aantemba Maníkómpáꞌá inaí simásuwena tísai ena séna kentáfésa seyaafáꞌnánká nóran-kwaasiyewa wéseo súwasa ");
INSERT INTO auy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","miwí tuwímbai sésa emá Yóni nombó maitinkáándawi óne sewasá tuwímbai sésa naaófáꞌá Maníkón-aaimo simátímakaandawin-awiꞌa Íráiyaa óne sewasá tuwímbai sésa naaófáꞌá Maníkón-aaimo simátímakaandawi pukáandafinkembo íyáfasinkaandawi óne wésewe suwaná ");
INSERT INTO auy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ísu séna kembiwí kentáféꞌa nóran-kwaasiyewa wéseo súwana Pítaa séna Maníkó íyáfasinankaraiwaimba Yúndaa-waasisa wéamuꞌmaraundawisa óne súwana minááí ímba simátíméro Ísu óraaka siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ísu séna minááí ímba simátíméro simásuwena ");
INSERT INTO auy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","séna kembá waási úrankomba síꞌo índa-iꞌa uwásinkesa Yúndaa-oraaꞌ-waasiye óraaꞌ-amaan-kisau-waasiye ámáámbo sen-kwáásíyé tínaaemba uwásimesa sínkamiyaꞌa púwóndanifo kaumbo-kánáá maisuwéna Maníkó íyáfasisinkainiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ísu seyaafáꞌnánká simátimena séna kembó sirááíwaenae síyawi tirááímo táínda-tantaaꞌa ímba taꞌótóráaro. Kemó púwónda-aaraa-taimo súwaataꞌmaeꞌo kondantembá kembó sirááíwaiyawi umbai-tántááꞌá aasiyaasi-kánáá timíyasa minúmbáí-tántááꞌá úwoi maimaésa sirááíwaenaawe. ");
INSERT INTO auy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tirááímo táínda-iꞌo ésa ímba kaweꞌ-úmai ménaafo kentáfésa ísámai tirááímo táínda-tantaaꞌo tuwésamo puwésa aúíꞌa úmai maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mararáké-séyááfá-tántááꞌó wémaesamo puwíyambo éna mintántáákó ímba túwaꞌnai íníye. ");
INSERT INTO auy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kesááiwara kenkwáráꞌó tigaemó uwásínkáámba póꞌa ánaaemba kemó marapáꞌó kúmónda miwí sigaé uwátinkanaumne. Kemá waási úranko ánaaembo kesí sáwara kesifoní sáwara wíyómpakembo Maníkóní kísau-waasiti sáwaraꞌo marapáꞌó kúmónda miwí sigaé uwátinkanaumne. ");
INSERT INTO auy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Éraiꞌa simátimeꞌa súne. Tuwímbai maankáꞌó méraan-kwaasi ímbo pukénkaꞌa Maníkó wení waásimo kawáánimba awánéꞌa ánaaemba puwónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ísu simátimena afakaumboé-noꞌwaanaꞌi miyáumai waéna Pítaane Yónine Yémísine tíꞌmaena inaimó síndasafena omápaꞌa iména ");
INSERT INTO auy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","inaí wésuwana óiꞌa fíꞌon-oiꞌa faufúwana wení unáánkwátóiyakemba waéníꞌa kéna túgáyáagaya úwasa ");
INSERT INTO auy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","awánomba kaeꞌ-wáásíyáí wíyómpakemba paápé ésarai mindárai-tuwiꞌa Mósesee Íráiyaaeꞌa Yúndaa-waasi tíwáꞌnárai Ísuweꞌa aaí wésuyana wíyómpake-sawaraꞌa wérowarasarai naaófáꞌá Maníkó Ísuntafena séna Yérúsaremufaꞌa puwíníye siyáimba ampáánkáꞌá miyá íníye-aai wésuyasa ");
INSERT INTO auy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pítaaeꞌo méroyan-kwaasi tún-kwaémomba íyáfasinesa Ísuni sámo kaimbá Ísuweꞌa méroyan-kwaasi tuwánomba ");
INSERT INTO auy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","mindárai Ísumba ímba auwésarai iyóyankaꞌa Pítaa Ísuntafena séna óraakoo maankáꞌó méraundasa kaweꞌá imbá póta wááu-namba kaumbosáámó ondasá moórá endé éta moórá Mósesende éta moórá Íráiyaande éta miyásá ónaumne Pítaa ímba imáyáamo úmba úwoi siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Miyá wésunkaꞌa ainánkó kuména káátaguwasa táátafesa uwaná ");
INSERT INTO auy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ainámpínkémbá aaigó aantemba séna miwá kesáánimba éna kemó íyáfasinankaundawin-ifo wenáái ísáaro ");
INSERT INTO auy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","súwasa awánomba mindárai wíyómpaꞌa íyúyana Ísu aantemba mérowasa awánomba minkánáá ímba simátimesa minááí úwoi taꞌótokaawe. ");
INSERT INTO auy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Aafáyáaraamba omápakembo kúmúmba Ísumpaꞌa sáwífaꞌnanka tóso uwaná ");
INSERT INTO auy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","miwífínkémbá moóráwigo óraaka séna óraakoo maawá kímbora kesáánimban-ifo arumbá uwánkaao. ");
INSERT INTO auy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sáwí-amutanko arumpimbá taména wááꞌa téna fameꞌnaameꞌá isaná tanaambá fágufagu wéena áwááyaamba umpufuwéna aigaregó nonkáánéna aíyayaamba kuꞌwisaná miyá úmae wéiyena sáwíꞌa wéuwankaisaꞌa ");
INSERT INTO auy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ení kísau-waasisafe séꞌa sáwí-amutamba arumpinkémbá maiyaúwáaro súnasa ímba kanaaꞌá maiyáúkaawe súwana ");
INSERT INTO auy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ísu séna kentí imáyáa kaentaén-ímáyáá isaꞌá kentáféꞌa ímba imáyáa owaná póna sirunkó umbaí wétaifo nóraumai-kanaarara keséꞌa ménaumno simátimena miníyámpóígón-afowantafena séna enáánimba áíꞌmae tiyó Ísu súwana ");
INSERT INTO auy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","áíꞌmae túwana misáwí-ámútánkó miníyámpóí faméꞌauwowana tanaambá fówana aíyayaamba kuꞌwisaná aigaregó nonkáánúwana Ísu awánéna misáwí-ámútánkóntáféna séna auwé kóuwo séna miníyámpóí kaweꞌá uwánkena afowántáféna séna áíꞌmae waaó súwasa ");
INSERT INTO auy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ísumo miyámó úmba Maníkóní óraa-fasiꞌaemba awánésa seyaafáꞌnánká táátafesa ésa tiyáámba tóipimba fáákaawe. ");
INSERT INTO auy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ísu seyaafá-kísáúmó maúmba awánésa táátafesa uwaná wení kísau-waasisafena séna simátíménda táákaꞌa máráaro. Kembá waási úrankomba fíꞌon-kwaasi timíyasa sínkamiya puwónaumne súwasa ");
INSERT INTO auy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","wemó sún-aaigoni áwáu ímba isésa miwítí imáyáa umbaí tówana minááígóní áwáu aúpáꞌá wérowasa ímba ísámai kaweꞌá ésa áísai ónae sésamo umbá tááꞌa úwasa ímba áísai uráawe. ");
INSERT INTO auy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ísuni kísau-waasi mósimesi-aai sésa kentááfínkémbá nááwa íyáákaiyo sésa keáímbá símae kuwaná ");
INSERT INTO auy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ísu miwítí imáyáa iséna moórá-iyampoi áíꞌmai amándáraꞌa ankéna ");
INSERT INTO auy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","simátimena séna kentáfésa imáyáa ésa iyámpóímo áwaꞌnai onten-úmai wésuwaꞌnai-owe. Súwaꞌnai onten-úmai Maníkó siꞌmákaiwaimba wéawaꞌnai-owe. Kempínkémbá tuwímbai séꞌa kemá káriꞌ-waasi únemo síyawi Maníkó minkwáásísáféna wéiyaakaawe wésiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Súwana Yóni Ísuntafena séna óraakoo moóráwigo wénena sáwí-amutantontafena séna Ísuni fasiꞌaémbó wéraintafe auwé kóuwo simátímapaꞌa wisasá misáwí-ámútámbá kóuraawe. Minkwáásígó ímba kentááfínkén-kwáásín-ifo ímba miyámó indá étuwaaosa siyáumne Yóni súwana ");
INSERT INTO auy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ísu séna ímba tufínankaaro. Kentáásí kísaugomba ímba sáwíꞌo owí úwoisa wésuwaꞌnai-owe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Maníkó Ísumba aiyáínana wíyómpaꞌo iyínda-kanaa ampáánká tínena úwana Ísu wenarumpin-ímáyáá éna óraaka séna Yérúsaremu-naopaꞌa kónae séna wéna ");
INSERT INTO auy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","wení waásisafena kowaíyan-damba kosaafá wéiyaro séna tiꞌmarówasa aifaꞌá Sámériyaa-waasiti naaópaꞌa kuwasá ");
INSERT INTO auy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ísu Yérúsaremu-naopaꞌo wínda-aai isésa tirunkó sáwíꞌa úwasa ímba naambá tímúwasarai ");
INSERT INTO auy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","wení kísau-waasifinkemba kaeꞌ-wáásíyáí Yémísiye Yóniyeꞌa minááí isésarai sésarai Fasiꞌaénkóo Maníkó wíyómpakemba iyamá tuwáínana kuména minkwáásí kafúkoro-aaimo suyambá wéankaiyo suyaná ");
INSERT INTO auy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ísu méfaerena óraaka séna ímba miyá sekaiyó súwasa ");
INSERT INTO auy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mindáópaꞌa tuwésa fíꞌon-daopaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aampaꞌá wéguwana moóráwigo Ísuntafena séna seyaafáꞌ-náópaꞌo níndafaꞌa eséꞌa nónaumne súwana ");
INSERT INTO auy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ísu minkwáásígómbá simámena séna waankó taaiyaifimbá wáísana numagó ánáamba úmarena wéwaifo kemá waási úranko kumpaápé uráundawi ímba naambá úmakeꞌa wéwaumne séna ");
INSERT INTO auy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","minkákémbá moóráwigontafena séna sirááíwaꞌmae tiyó súwana séna óraakoo kemá méraanana kesifo puwína utámareꞌa embá arááíwaenaumne súwana ");
INSERT INTO auy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ísu séna ímbanifo kesáái ímbo isésamo pukáan-kwaasiyaambo owí puwíyan-kwaasi utátinkanaafo emá Maníkómó wení waásimo kawáánin-aai simátímaꞌmae wínone súwana ");
INSERT INTO auy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","moóráwigo Ísuntafena séna óraakoo embá arááíwaenaumpo aifaꞌá kesimááraa siyáámba timéꞌa embó taarááíwaenda kanaawáꞌíyo súwana ");
INSERT INTO auy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ísu séna Maníkóní kísaumo ómbaresa maiyésamo ifátuwesa fíꞌon-imayaamo owí Maníkó wení waásimo kawáánipaꞌa ímba kanaaꞌá kísau maénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ánaaemba Fasiꞌaénkó sáwífaꞌ-waasi 70 waasi íyáfasintinkena kaekaeꞌá uwásuwe wemó wínda-naopimpaꞌa aifaꞌá kónááwe séna ");
INSERT INTO auy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Maníkómpáꞌó tíyantafesa wenáái kosimátímaꞌmae koró-ááí simátimena séna kísaufaꞌa sáwífa-tomba áfu karáisasa mintómbó fakaráíyan-kwaasi sesimáí-waasi méraafo kísaugoni afowámpáꞌá inaí síyana kísau-waasi tiꞌmaráínasa mintómbá fakaránááfo koró. ");
INSERT INTO auy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sipisípi-araaꞌa wínana áwáífiyaamo in-íyánkómó intenkáámbó on-kwáásífáꞌá tiꞌmaránaumne. ");
INSERT INTO auy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Óntambo inai-inaimó sí-únámbá ímba maimaé wéꞌa tón-únámbá ímba maimaé wéꞌa tísamai ánáamba ímba maimaé wéꞌa aampaꞌó wéweꞌa ayáátáákaꞌa ímba úwoi-aai símae wéꞌa ");
INSERT INTO auy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","moórá-naumpaꞌo iyé séꞌa faru úmai méraiyataao seró. ");
INSERT INTO auy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Síyana faru úmaimo méraindawimo éna mifárú-ááí wempímbá wéínifo ímba faru úmai méraindawimo éna mifárú-ááígó kouweréna kembiwífáꞌá tíníye. ");
INSERT INTO auy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kísaumo maíyawi méyámbó máéntafeꞌa timínda-naumpaꞌa iméꞌa timíyan-tomba nánááwe. Ímba fíꞌon-daumpimpaꞌo níyamba timíyan-daumpaꞌ-aantemba iméraaro. ");
INSERT INTO auy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Moórá-naopaꞌo wíyamba naambá timésa tómbá timésa íyaꞌo wéneꞌa ");
INSERT INTO auy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mindáópaꞌo tíꞌo índa-waasi asófatinkeꞌa simátime séꞌa Maníkó wení waásimo kawáánínda-kanaa kempáꞌá kárikaꞌa tíníye simátíméro. ");
INSERT INTO auy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Moórá-naopaꞌo wíyambo naambá ímbo timíyaꞌa aampaꞌá wéweꞌa aforaꞌá simátime séꞌa ");
INSERT INTO auy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","kentí naaópakem-bara sísamaifakenta uwátuwaundasa Maníkó kembiwí ímba aamoí uwátínkáíntafeta aiyowáíꞌa úmai aráátimune. Ísáaro. Maníkó wení waási kawáámó índa-kanaa ampáánkáꞌá tínena isaꞌá tínaaemba uwámewe simátíméro. ");
INSERT INTO auy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Simátime súne. Maníkó waásimo méraawini áwáusafena tísai índa-kanaa tínda naaófáꞌá Sóndómu-naopaꞌo méron-kwaasi sáwí-waasi sáwí-meyamba timínífo kembiwímó tínaaembo uwátimiyan-kwaasi sáwí-meyamba áfááraumai timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ísu simátimena séna Kórási-naopaken-kwaasiye Pétésáíta-naopaken-kwaasiye káráwiyoro. Naaófáꞌá Táyaa-naopaken-kwaasiye Sáíndóni-naopaken-kwaasiye Maníkón-aaimo ímbo ísaraawifimbo fíꞌo-fiꞌon-kisau ímbo awánaraan-kisaumo maéwándamo awánarekaa kentí sáwí-awau tukáawisino. Sáwí-awau tuwésamo úwoi-unankwatoimo úmaesamo kanamó aꞌmakáankakaa Maníkó tuwánaraisino. ");
INSERT INTO auy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mindásafeꞌo simátíménda ísáaro. Maarán-ímáyáá wéeꞌa Maníkó waási méraawini áwáusafena tísai índa-kanaamo tínda Maníkó Táyaa-naopaken-kwaasiye Sáíndóni-naopaken-kwaasiye sáwí-meyamba óraaꞌa timíníye-imayaa wéowe. Énifo kentí sáwí-meyanko minkáéꞌ-náópakewiti sáwí-meyankomba íyáákamai-sawi-meyamba timíníye. ");
INSERT INTO auy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kápaneamu-naopaken-kwaasisono. Kentúwíꞌa mósá maré séꞌa wíyómpaꞌa iyónaumne sembánifo púwón-aempaꞌa kónááwe Ísu simásuwena ");
INSERT INTO auy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","wení kísau-waasisafena simátimena séna kentáái ísámai kaweꞌó owí miyámó ombá kesáái ísámai kaweꞌá wéofo tínaaembo uwátínkááwi kenkwáráꞌá miyá wéowe. Tínaaembo uwásínkááwi miyámó ombá siꞌmákaiwainkwaraꞌa miyá wéowe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ísu súwasa minkwáásí 70 waasi isésa wété urésa Ísumpaꞌa tóso ésa aamoí tauwánkesa sésa Fasiꞌaénkóo sáwí-amutantontafe séta Ísun-awikaꞌa súmpo tiyuwé kóro súnasasa isésa kóuraawe suwaná ");
INSERT INTO auy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ísu séna miyá owaná wíyómpakembo aafáyáumo tóráíntemba wíyómpakemba waántáwankombo maisukáimba awánaraumne. ");
INSERT INTO auy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Simátíménda ísáaro. Fasiꞌaémbá timúna póꞌa waaifainkómó fáíndamo éꞌa ímba puwíyana áwáífiyaamo índa-ufonkwankomo fáíndamo éꞌa ímba puwónááwe. Tímakaunda-fasiꞌaenko waántáwankoni fasiꞌaénkómbá íyáákaimba póna ímba seyaafá-tántáákó sáwíꞌa uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sáwí-amutantomba kentáái isésa kóuraantafeꞌa ímba aamoín-ofo Maníkó wíyómpaꞌa aúfáífimba kentúwíꞌo agaimakáintafeꞌa aamoín-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Minkánáá Maníkóní Ufaen-ámútánkó Ísumba imáyáa amúwana arunkó kaweꞌá úwana séna kesifóo wíyómpaꞌwara mararáꞌwáráꞌó káráwiyaandawi óne. Seyaafá-tántááꞌá isáúmne sen-kwáásí ímba simátime úwoi-waasi simátime miyámó íyantafena ánkáísaꞌa póꞌa enáwíꞌa mósá maráúmne Ísu Maníkóntáféna simásuwena ");
INSERT INTO auy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","simátimena séna kesifo seyaafá-tántáákáꞌá káráwiyuwo séna símakaiye. Seyaafáꞌnánká kesí áwáu ímba suwánaraafo kemá kesifoní áwáugo únana póna kesí áwáu suwánaraiye. Seyaafáꞌnánká kesifoní áwáu ímba awánaraafo kesifombá póꞌa keyáá wení áwáu awánaraumne. Kesifoní áwáumo aráátimundawi wéawanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ísu simátimena méwaerena wení kísau-waasisafena aantemba séna awánaafo tirunkó kaweꞌá ínaꞌa méraaro. ");
INSERT INTO auy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Simátime súne. Naaófáꞌá Maníkón-aaimo simátímakowiye óraaꞌ-waasiye kembiwímó wéunda-kisau awánaanten-úmai awánánae sésa umbá ímba awánaraawe. Miwí kembiwímó wéisaanten-úmai isánae sésa umbá ímba ísaraawe Ísu wení kísau-waasisafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moórá-kanaa Ísu wenáái wésimatimuwana moóráwigo ámáámbo kaweꞌ-úmaimo isówi Ísumpaꞌa téna áísai úmai Ísumba isánae séna óraakoo nóra úmaiya aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónaumno súwana ");
INSERT INTO auy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ísu séna Maníkón-aai aúfáífimbo awánáánda minááísáfé nóran-imayaawa ónó súwana ");
INSERT INTO auy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","minkwáásígó séna Maníkón-aai aúfáífinken-aaigo séna kentiruné kentí imáyáawe kentí fasiꞌaéné Maníkómpáꞌá kentí Fasiꞌaénkómbá áméro séna kesáfé-ímáyáámó ontembá kentí waási-imayaawaraꞌa oro siyáiye súwana ");
INSERT INTO auy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ísu séna éraiꞌa sémpo miyámó é aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ínone Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Súwana minkwáásígó imáyáa éna fíꞌon-kwaasi suwánésa kaweꞌ-wáásín-iye síwae séna Ísuntafena séna kesí waási nááwaꞌiyo súwana ");
INSERT INTO auy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ísu séna simátíménda isaaó. Moóráwigo Yúndaa-waasi Yérúsaremu-naopakemba Yéríko-naopaꞌa kónae séna aampaꞌó wimbá umén-kwáásí taꞌótokesa wení unáánkwátói awáꞌmaesa tufúꞌmárááwana puwíndasafena aampaꞌá méraisana ");
INSERT INTO auy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","moóráwigo Maníkóntáfénamo ísámai póímo tufúꞌmai agáíwai minámpáꞌó wimbá aanawáísáfaꞌa méraisana kóawanena moórá-aanawaisafaꞌa kóyáákaisana ");
INSERT INTO auy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","moóráwigo Rífáin-anaankakewi ámáán-daumpaꞌa kísaumo máíwai minámpáꞌó wimbá aanawáísáfaꞌa méraisana wení ewaaꞌá wéna kóawanena moórá-aanawaisafaꞌa úwoi kóyáákaisana ");
INSERT INTO auy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","moóráwigo Sámériyaafaken-kwaasi miwí Yúndaa-waasiti namuro-wáásífínkémbá moóráwigo minámpáꞌó wimbá koawánéna arumbá uwánkena ");
INSERT INTO auy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","wení ewaaꞌá koména masawémba ándá-aran-donkwara úmai afifimbá aꞌankéna asáá uwánkena mósá farámbai wení tónki-poifimba ankéna áíꞌmaena wááumo ten-kwáásímó wáén-daumpaꞌa móankarena káráwiyena ");
INSERT INTO auy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","íyáfasinena aafáyáaraꞌa mindánkón-afowámbá kae-kánáá-kísáúgóní óntamba aména séna kaweꞌ-úmai káráwiye wenaneꞌó túwénda-ontambo éꞌa ke téꞌa anondáá embá mááméno simásuwena kóuraiye Ísu simásuwena ");
INSERT INTO auy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","37","nóra úmaisaawa aúíꞌa úmaisa maéꞌmaeꞌa ónaumno súwaintafena Ísu áísai ena séna umén-kwáásímó tufúkáan-kwaasigoni waási minkáúmbó-wáásífínkémbá nááwaꞌiyo Ísu súwana minkwáásígó séna arumbá uwánkena áwaꞌnai uráiwai wení waásin-iye súwana Ísu séna wemó intembá komé miyá ínone Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ísu wení kísau-waasiseꞌa aampaꞌó kúmba moórá-ininkon-awiꞌa Máátaamo méron-daopaꞌa kúwana Ísuntafena séna kesí naaúmpaꞌa tómbá imandaaó súwana ");
INSERT INTO auy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","iména aaí wésuwana minínínkón-áúnkon-awiꞌa Máríyaa Ísuntafena óraaꞌ-waasin-iye-imayaa éna aísamaifimba taména wenáái wéisowana ");
INSERT INTO auy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mááta seyaafá-tómbá wéagaena óraa-kisau wémaena óraaꞌ-imayaa éna Ísumpaꞌa téna séna Fasiꞌaénkóo kesúnko ímba súwaꞌnai isaꞌá keyáá óraa-kisau wémaumpo kentáfé ína imáyáa ónó. Simámínana tasúwaꞌnai íno súwana ");
INSERT INTO auy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ísu arumbá uwánkena séna Máátaao sáwífa-tantaaꞌa óraaꞌ-imayaa ónana enarunkó umbaí wétaifo ");
INSERT INTO auy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kesááimo ísáámba mindá óraa-tantaaꞌa póna mindásafena Máríyaa méraifo ímba ifátuweꞌa aiꞌmáráanana wíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ísu moórá-kanaa Maníkómpáꞌá inaí wésuwasa wení kísau-waasi mérowana Ísu simásuwowana wení waásifinkemba moóráwigo séna Fasiꞌaénkóo Yóni nombó maitínkáíwai wení kísau-waasi simátímísasa Maníkómpáꞌó inaimó sentembá kentáá simásímínata Maníkómpátá inaí senó súwana ");
INSERT INTO auy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ísu séna Maníkómpáꞌó inaimó síyamba maará seró. Kentáásifowao enáwíꞌo íyáákarain-awita mósá maráúmne. Ení nombaragó seyaafá moórá-mora-waasi tirumpimbá kumíno. ");
INSERT INTO auy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Káfé-kanaa-tomba kentáá simiyó. ");
INSERT INTO auy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Waásimo aoisaambó uwásinkaiyata anondáá ínta miyásá uwátinketa miwítí aoisaambá maitiyúwáana miyáumaisa kentáásí aoisaambá maisiyuwaaó. Sáwí-yantaapinkembo kentáá maꞌmáímo awánáíndasafenamo ínamo e wasiyuwaaó. Miyán-ááí Maníkómpáꞌá seró Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ísu simásuwena simátimena séna moórá ení waásigo némpakemba nóꞌwaan-afufumba tína ímba tómbá maké ení waásigoni ontafáꞌá wée áísai e sé kesí waásigo némpakembo timbá ímba tómbá makáunana úwoi méraifo tómbá símínaꞌa mááméno sínana ");
INSERT INTO auy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","wení naaúmpakemba séna ontá wisuwéta kesí aare-iyámpóíseta súsá waiguráumpo ímba íyáfasineꞌa aménaumpo kóuwo síníye. ");
INSERT INTO auy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kesí waási póꞌa aménaumne-imayaamo ímbo ínanamo éna ayáátáákaꞌa minááí wésinana ímba aigaé ínana minááí wésindasafena íyáfasinena amíníye. ");
INSERT INTO auy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Miyáráán-úmai simátime súne. Maníkómpáꞌó inaimó sembá áísai úmae iyíyana timíníye. Áántamae iyíyana kentáái isáíníye. Saafá úmae iyíyana Maníkó aráátiminiye. ");
INSERT INTO auy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Áísai íyanamo éna Maníkó timíníye. Áántewanamo éna Maníkó kentáái isáíníye. Saafá íyanamo éna Maníkó aráátiminiye. ");
INSERT INTO auy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kembiwí iyámpóíwaraꞌ-waasi kentáánintombo mófááꞌa simiyómó síyaꞌo éꞌa ímba iyaankafayaambá timénááwe. ");
INSERT INTO auy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kokóri-auma simiyómó síyaꞌo éꞌa ímba íyoiyoimba timénááwe. ");
INSERT INTO auy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Énifo sáwí-waasin-ofo kentáánintomba kawe-tántááꞌá wétimefo wíyómpakemba kentáásifowa kaweꞌ-aantembo iwáí póna ení Ufaen-ámútámbá simiyómó síyawi Maníkó wení Ufaen-ámútámbá timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Moóráwigo wenarumpimbá sáwí-amutamba mérowana póna minkwáásígó ímba aaí wésuwana Ísu maiyauwówana kóúwana minkwáásígó aaí súwasa sáwífaꞌnanka awánésa táátafesa uwasá ");
INSERT INTO auy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","tuwímbai sésa sáwí-amutantonti kawáágón-áwíꞌa Píyésepuri fasiꞌaémbá ámísana tokéna póna sáwí-amutamba wémaitiyuwaiye suwasá ");
INSERT INTO auy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","tuwímbai Ísumo sáwí-aaimo sínda isánae sésa éraira Maníkómpákéná kunkáanai ímbo awánáúnda-kisau maínata awánaano suwaná ");
INSERT INTO auy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ísu miwímó un-ímáyáá iséna simátimena séna moórá-andamo tiyésamo ésa tuwínkaaꞌ-urésa ímba fasiꞌámai méranaawe. Moórá-akumba aaimó tuwíntáán-akumba pósa tuwínkaaꞌ-urésa ímba fasiꞌámai méranaawe. ");
INSERT INTO auy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Waántáwankoni waásimo tiyésamo tuwínkaaꞌ-ésamo ésa ímba fasiꞌámai méranaawe. Kentáféꞌo sembá Píyésepuri fasiꞌaémbá ámísana tokéna póna sáwí-amutamba wémaitiyuwaiyemo sembá ");
INSERT INTO auy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","énifo Píyésepurini fasiꞌaénkáꞌó sáwí-amutambo wémaitiyuwaundarakaa kentí waásiwaraꞌa Píyésepurini fasiꞌaénkáꞌá sáwí-amutamba maitiyúwáísino. Miyán-ááímó síyasamo ésa kentí waási karoꞌá sewé sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Énifo kemá Maníkóní fasiꞌaénkáꞌá sáwí-amutambo maitiyuwáúndasafena Maníkóní fasiꞌaémbá kempímbá paápé isaꞌá wéawanaawe. ");
INSERT INTO auy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Moórá-aai imáyáan-oro. Fasiꞌaén-kwáásígó paroí tokéna wení naakaꞌá káráwiyaisana wení moparáwímbá kaweꞌ-úmai wéraifo ");
INSERT INTO auy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","moóráwigo wení fasiꞌaémbó íyáákaraiwai téna tatufúꞌmai wení paroí fasiꞌámaimo taꞌótokaim-paroi tatafiyéna wení moparáwímbá tatafíyena tuwín-timakaiye. ");
INSERT INTO auy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kembá ímba súwaꞌnai esa kesí namuro-wáásíyáámbá owe. Ímba súwaꞌnai esa waási túwaandu úmai símémba wété uwáguraawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ísu simátimena moórá-aai séna waási arumpinkémbá sáwí-amutanko auwéna máásai-marafaꞌa nombá ímbo wéraipaꞌa kowénena séna nááfara ménaumno séna saafá uwááena séna tauweréꞌa kesí naambá waásigon-arumpimba póꞌa koménaumne simásuwena ");
INSERT INTO auy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","téna taawánaimba mindánkómbá kankambá wiyúꞌmai kaweꞌá uwásukaisana taawánéna ");
INSERT INTO auy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tauweréna afakaeté-sawi-amutamba miwítí sáwí-kisau óraaꞌo uráawi tíꞌmaena minkwáásígón-arumpimba taméraawana moórá-sawi-amutanko arumpimbá méraisana minkwáásígó sáwíꞌa úmai méraisasa ánaaemba sáwífa-sawi-amutamba méraawana wemá óraa-sawiꞌa úmai méraiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ísu minááí simátimuwana sáwífaꞌ-waasifinkemba moórá-ininko Ísuntafena óraaka séna enanó embá maꞌánkarena náámbo ámakaiwaimba Maníkó kaweꞌá uwánkaraiye súwana ");
INSERT INTO auy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ísu séna éraiꞌa sémpo Maníkó wenáái ísámai kaweꞌó owímá óraa-kaweꞌa wéuwatinkaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Súwasa sáwífaꞌ-waasi Ísumpaꞌa tóso uwaná simátimena séna káféꞌo méraan-kwaasi sáwí-waasin-owe kentáféꞌa wésemba Maníkómó aiꞌmákainamo e ímbo awánáúnda-kisau maínata awánaanomo sembá naaófáꞌá Maníkó Yónaambo uráintemba kembá miyá ínífo minááí imáyáan-oro. ");
INSERT INTO auy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Naaófáꞌá Nínéfa-naopaken-kwaasi Yónaa uráintafesa Maníkó aiꞌmákaiyemo siyáantemba kemó ondá awánéꞌa Maníkó aiꞌmákaiye sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Naaófáꞌá Yúndaa-waasiyaꞌa káráwiyowin-awiꞌa Soromoní kaweꞌ-ímáyááfínkémbá aaí wésimatimuwana moórá-ininko némpaken-kawaa-ininko Soromonin-áái koisánae séna wémena kuráiye. Káféꞌa kemá Soromonimbó íyáákaraundawi méraunaꞌa kesáái ímba ísáámba póna ánaaemba Maníkó waásimo méraawini áwáusafenamo tísai índa-kanaamo tínda minínínkó kembiwí aaifimbá maitinkéna séna kemá némpakemba Soromonin-áái taísaraumpo Soromonimbó íyáákaraiwai kempáꞌá mérowaꞌa wenááimo ísááraamba ímba ísaraawe síníye. ");
INSERT INTO auy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Naaófáꞌá Yónaa Nínéfa-naopaꞌa Maníkón-aai kosimátimuwasa isésa sáwí-awau tuwésa Maníkón-aai ísaraawe. Káféꞌa Yónaambo íyáákaraundawi méraunaꞌa kesáái ímba ísáámba póna ánaaemba Maníkó waásimo méraawini áwáusafena tísai índa-kanaamo tínda Nínéfa-naopaken-kwaasi kembiwí aaifimbá maitinkésa sésa Yónaa-aai iséta sáwí-awausa tukáundasaanifo Yónaambo íyáákaraiwai kentí naaópaꞌa mérowaꞌa wenáái iséꞌo sáwí-awau túwááraamba ímba tukáawe Nínéfa-naopaken-kwaasi sénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ómbó kúraꞌmaresa ímba aúpáꞌó maráíyamba aforaꞌá makéwasa naaúmpaꞌo iyíyawi awánánááwe. ");
INSERT INTO auy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miyáumai túranko kentí imáyáafimbo sámo kain-tántááꞌán-iye. Túrankomo kaweꞌ-úmaimo awánáínanamo éna seyaafáꞌ-ímáyáá sáma káínífo túrankomo ímbo kaweꞌ-úmaimo awánáínanamo éna seyaafáꞌ-ímáyáá tuwinkáíníye. ");
INSERT INTO auy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kentí sámo kain-tántááꞌá túnkwifainifo kentúraꞌa káráwimai kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kentí imáyáago ímba kumeuꞌó índa seyaafáꞌá sámo wégaimba ónkómó sámo kátínkáíntemba póna kentí imáyáago kentúraꞌa sáma kátinkainiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ísu minááí simátimuwana moóráwigo ámáán-kawaa-waasigo Ísumpaꞌa téna séna kesí naaúmpaꞌa tómbá imandaaó súwana tómbó náíndasafena iména ");
INSERT INTO auy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ímba ayáámba non-kwiyéna tómbá nówana minkwáásígó awánéna áátafena éna imáyáa úwana ");
INSERT INTO auy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Fasiꞌaénkó awánéna simámena séna kemá ámáán-kawaa-waasi anaféúné táúfaꞌe paákáꞌ-aantemba wénon-kwiyofo andáámpáꞌá sáwíꞌa uráisaꞌa túraniyamba éꞌa sáwíꞌa wéowe. ");
INSERT INTO auy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sáwí-imayaawaraꞌ-waasi méraawe. Maníkó paáká-tántááꞌá éna andáámpá-tántááꞌé imáyáawe mindáwaraꞌa uráiye. ");
INSERT INTO auy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kentí imáyáamo arupíse éꞌo kemó makén-tantaaꞌo ímbo makén-kwaasi timéꞌo éꞌa kentí imáyáago kaweꞌá íníye. ");
INSERT INTO auy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kemá ámáán-kawaa-waasi kentí kísaufakemba kári-tonkwaraꞌa tuwínkaaꞌ-úmai siyáánkai makéꞌa moórá Maníkómbá améꞌa kaweꞌá éꞌa miyán-ámáámbá ísámae wéiyofo óraaꞌ-amaamba ifáꞌá tuwé póꞌa Maníkómbá ímba imáyáa wéameꞌa óntan-iyain-kwaasi sáwíꞌo uwátínkáántafeꞌa káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kemá ámáán-kawaa-waasi ámáán-daumpaꞌa iméꞌa kaweꞌ-áémpáꞌá waási túrankaꞌo iméraamba tiráái wétaiye. Marupáꞌó iméraawasa waási tuwánésa kaweꞌ-ááímó sembá tiráái wétaifo kentúraꞌa káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Waásimo maipímbó utámakaawanamo kawááꞌisasamo waási ímbo awánaantemba kentirumpimbá miyá isaꞌá sáwíꞌa owasá waási ímba wétuwanaafo káráwiyoro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ísu simátimuwana moóráwigo ámáámbo sún-kwaasigo Ísuntafena séna miyámó sénda kentááwáráꞌá símai sáwíta uwásinkaane súwana ");
INSERT INTO auy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ísu séna kemá ámáámbo sen-kwáásí kemó ámáámbo simátímén-aaigo umbaí tíyáísaꞌa minááí ímba wétuwaꞌnai-ofo káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Kentíwáꞌná Maníkón-aaimo simátímakowi tínkamuwasa púwúwaꞌa utámakaapaꞌa toꞌwaaí wéowe. Naaófáꞌá kentíwáꞌnámo uráantafeꞌa kaweꞌá uráawe séꞌa utámakaapaꞌa toꞌwaaí wéofo káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Naaófáꞌá Maníkó kaweꞌ-ímáyááfínkémbá séna kesááimo simátimiyawiye aráátimiyawiye tiꞌmáráanasa miwífímbá wéniyasa tuwímbai sáwíꞌa uwátinkesa tuwímbai tínkamiyasa puwónááwe Maníkómó siyáimba minááí paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Naaófáꞌwárá afufumpinkwárá ánaaenkwaraꞌa Maníkón-aaimo simátímakowi tínkamuwasa pukáantafena póna misáwíꞌó uráawin-anondaa-meyamba káféꞌo méraan-kwaasifaꞌa tíníye. ");
INSERT INTO auy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aifaꞌó tufúwanamo pukáin-kwaasigon-awiꞌa Éperi ánaaemba moóráwigon-awiꞌa Sékáráíya óraaꞌ-amaan-daumpaꞌa mérowana moórá-aempaꞌa Maníkóntáfésa ísámaimo póí tufúꞌmaimo agáún-ontan-taare wérowana moórá-aempaꞌa aifaꞌ-ámáán-káwáágó aantembo iyún-onta wérowana afufumpimbá Sékáráíya imérowasa tufúwana pukáiye. Minkáéꞌ-wáásítí afufumpimbó kárúraan-kwaasi tínkamuwasa pukáawiwaraꞌa miwítí sáwí-meyamba káféꞌo méraan-kwaasi maénááwe. ");
INSERT INTO auy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kemó ámáámbo sen-kwáásí éraiꞌ-aai ímbo aúpáꞌó tukáankakaa minááí ísámai kaweꞌá owisinó. Kemá ímba ísámai kaweꞌá ombá fíꞌon-kwaasiti aambá fáíkaafo káráwiyoro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ísu minááí simátimena máápaꞌa kumúwasa ámáámbo sun-kwáásíyé ámáán-kawaa-waasiye tirumpimbá aaisambá aéésa fíꞌo-fiꞌon-tantaatafesa áísai úmai ísáananamo ");
INSERT INTO auy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","aaimó kaentaén-ááímó sínaꞌo éꞌa aaifimbá maenkánae sésa áísai uráawe. ");
INSERT INTO auy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Minkánáá áfááraumai sáwífaꞌ-waasi túwaandu ésa sisipáá uwaná Ísu wení kísau-waasi simátimena séna ámáán-kawaa-waasi kaumbo-kaeꞌ-ááíwáráꞌ-wáásíyáámbá ofó ímba miyáumai méraaro. Intóráín-tantaaꞌa kári-tantaaꞌa moórá-tonkon-awiꞌa péréti mimpímbá márááwana intoréna óraaꞌo intembá ámáán-kawaa-waasiti sáwí-aai miyá wéifo kempímbá misáwí-ááígó óraaꞌa tifáínifo kentúraꞌa káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aúpáꞌó wérain-tantaaꞌa seyaafáꞌá aforaꞌá paápé ínasa awánánááwe. Kumeupáꞌó wérain-tantaaꞌa aforaꞌá paápé ínasa awánánááwe. ");
INSERT INTO auy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nóꞌwaambo siyáan-aai sán-káíndaraꞌa síyasa isánááwe. Aúpáꞌó siyáan-aai seyaafáꞌ-wáásí túrankaꞌa síyasa isánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ísu simátimena séna kesí waási simátíménda ísáaro. Tuwímbai tínkamiyaꞌa puwónááfo moórá sáwíꞌo uwátinkai-tantaaꞌa ímba wéraifo ímba miwísáféꞌa inkáísóro. ");
INSERT INTO auy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kemá simátime súne. Maníkó méraifo wenáároi inkáísóro. Wemó tínkaminaꞌo puwíyambo éna kanaaꞌá ónkaifaꞌa mátiyuwainiye. Minááí Maníkóntáféꞌa inkáísóro-aai súne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ísu simátimena séna káriꞌa téntémpaaran-dumama séfataase-numama káriꞌ-ontankakemba kae-tóyáráán-óntánkákémbá wémeyanofo Maníkó kíyaan-dumama ímbo awinkaiwáí póna awánaraiye. ");
INSERT INTO auy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Numamá kári-tantaaꞌo awánaiwai póna waási óraa-tantaaꞌan-ofo ímba tááꞌa íno. Kentiꞌnóntáu toráúsíwain-ifo ímba tááꞌa íno Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ísu simátimena séna simátime súne. Seyaafáꞌ-wáásí túrankaꞌa kentáfésa sésa Maníkó aiꞌmáráísana kunkáiwai kesí óraakon-iye síyawisafeꞌa kemá waási úranko Maníkóní kísau-waasi wíyómpakewi túranka séꞌa kesí waásin-owe sénaumne. ");
INSERT INTO auy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Énifo waási túrankaꞌa kembá tínaaembo uwásimiyawisafeꞌa kemá Maníkóní kísau-waasi túrankaꞌa sínaaemba uwátimenaumne. ");
INSERT INTO auy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kembá waási úrankomba símai sáwíꞌo uwásinkaiyamba mindá Maníkó maitiyuwáínífo Maníkóní Ufaen-ámútánkómbá símai sáwíꞌo uwánkaiyamba mindá Maníkó ímba maitiyuwáínana miwíséꞌa waéꞌwaeꞌa íníye. ");
INSERT INTO auy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kesí waási-iꞌo ontáfésa taꞌótoꞌmai tíꞌmaesamo óraaꞌ-waasiye ámáán-kawaa-waasiye túrankaꞌo mátínkaresamo aaifimbá maitínkéwaꞌo éꞌa nóran-aaimo síyamba ímba tááꞌa ínana ");
INSERT INTO auy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maníkóní ámútanko síyan-aai úwoi tááka tinkáínaꞌa sénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Súwana sáwífaꞌ-waasifinkemba moóráwigo Ísuntafena séna óraakoo kesifo púwísana kesuwaá seyaafá-tántááꞌá maiyéna ímba tuwímbai wésimifo emá sinaná tuwímbai násimino súwana ");
INSERT INTO auy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ísu séna kesí waásiyo minááí ímba kosénaumpo keáfáráwáíti moparáwímbá ímba tuwín-timenaumne simámena ");
INSERT INTO auy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","seyaafáꞌ-wáásísáféna séna waási kaweꞌ-úmaimo méraawiti áwáu ímba sáwífaꞌ-moparawimba makáafo moparáwímbá maénae sémeꞌa máéfainifo kentúraꞌa káráwiyoro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Simásuwena moórá-aai simátimena séna moóráwigo sáwífaꞌ-moparawimbo makáindawi wení kísaufaꞌa sáwífa-tomba wéraisana ");
INSERT INTO auy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","wenarumpin-ímáyáá éna sáwífa-tombo fákáꞌmaimo máráanda-namba ímba wéraifo nóra ónaumno. ");
INSERT INTO auy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Miyámó éꞌa tómbó makáunda-namba tawísíyeꞌa óraaꞌ-namba úmareꞌa mimpímbá seyaafá-tómbá fákáꞌmareꞌa kesí moparáwínkwáráꞌá maránaumne. ");
INSERT INTO auy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Miyámó éꞌo éꞌa kesáfé séꞌa seyaafá-tántááꞌá ímbo aáfáán-túwáanda tóné noné námae iyéꞌa ayáátáákaꞌa úwoi méꞌa onaná sirunkó kaweꞌá ínaꞌa ménaumne sisaná ");
INSERT INTO auy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Maníkó simámena séna sáwíꞌo úmaemo iyónda-waasigo óne. Káféꞌ-noꞌwaamba puwéma esáfémo makáanda-moparawimba túwénana nááwa máíníyo Maníkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Marapáꞌá kesáfé-mópáráwín-aantembo makáiyawi miyán-kwáásín-ofo marapá-tántááꞌ-aantemba marésa Maníkómpákén-tántááꞌá ímba makáawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ísu minááí simátimena wení kísau-waasisafena séna simátimeꞌa súne. Miyáráán-úmai méraamba ímba óraaꞌ-imayaa éꞌa tómbó náíyantafeꞌa ímba óraaꞌ-imayaa éꞌa kentúraꞌo unáánkwátóimo íyantafeꞌa ímba óraaꞌ-imayaan-oro. ");
INSERT INTO auy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tómbó náíyamba úwoisambanifo waásimo méraamba óraa-tantaaꞌan-iye. Unáánkwátóimo íyamba úwoisambanifo waási túma óraa-tantaaꞌan-iye. ");
INSERT INTO auy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Numagómpáꞌá imáyáan-oro. Numagó ímba kísau éna tómbá fákáꞌmai naaúmpaꞌa makéna wénaifo Maníkó miwítí tómbá tímísasa wénaawe. Maníkón-aúrankaꞌa numamá kári-tantaaꞌan-ifo waási óraa-tantaaꞌa póna kentí tómbó éna timíníye. ");
INSERT INTO auy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kembiwímó óraaꞌ-imayaamo éꞌo éꞌa kemó maíyan-kanaa ímba kanaaꞌá ayáátáákaꞌa méranaawe. ");
INSERT INTO auy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mindá kári-tantaaꞌa isaꞌá ímba kanaaꞌó íyamba póꞌa fíꞌo-fiꞌon-tantaatafeꞌa ímba óraaꞌ-imayaan-oro. ");
INSERT INTO auy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Waiwandáánkáꞌá imáyáan-oro. Waiwandáánkó ímba kísau éna ímba wení unáánkwátói makáifo simátimeꞌa súne. Naaófáꞌá Yúndaa-waasiti óraakon-awiꞌa Soromoní sáwífaꞌ-unankwatoiye koꞌnaariríyé makówi úwasa waási awánésa kaweꞌán-iye sumbánifo waiwandáán-aramba awánésa óraa-kaweꞌan-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ufáꞌá koꞌnaarirí-tántááꞌé séna waiwandáámbá Maníkó makáiye. Umá ímba waéꞌwaeꞌa ínífo káféꞌa ínasa aafáyáa waási agaisuwáíyamba Maníkó mintántááꞌá imáyáa éna koꞌnaarirí-tántááꞌá makáiye. Miyáumai Maníkó waásisafena imáyáa éna kentí unáánkwátói timínífo kembiwí maarán-ááí ímbo seráámbá Maníkó ímba kanaaꞌá wésuwaꞌnai-iwain-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Maníkó wétuwaꞌnai-imba póꞌa tóné nonémó náíyantafeꞌa ímba óraaꞌ-imayaan-oro. ");
INSERT INTO auy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Moórá-mora-marafaken-kwaasi Maníkón-aai ímbo ísáán-kwaasi tóné nonémó náíyantafesa óraaꞌ-imayaa wéowe. Tóné nonémó ímbo néꞌo éꞌa púwófo séna kentifo imáyáa éna wétimifo ímba óraaꞌ-imayaa éꞌa ");
INSERT INTO auy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Maníkó wení waásimo kawáánintafeꞌa imáyáa íyana mintántááꞌá timíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ísu simátimena wení kísau-waasisafena séna kembó sirááíwáéwi káráwiyaumne. Kentáásifowamo simbá kesí waásimo kawáánonda kembiwíwáráꞌá kawáánónááwe. Miyá íyana kesirunkó kaweꞌá íníye simbá póna ímba tááꞌa íno. ");
INSERT INTO auy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kentí moparáwímbá wétimeꞌa méyámbá maiyéꞌa ímbo makén-kwaasi tíméro. Miyámó íyana kentí kaweꞌ-méyámbá wíyómpaꞌa wérainasa waási ímba umémbá íyana ímba ufóíyaraamba ínana kaweꞌ-úmai aasiyaasí waéꞌwaeꞌa ínaꞌa minkáwéꞌ-méyántáféꞌa imáyáa éꞌa ");
INSERT INTO auy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","marapáꞌó kentí óntamo wérainanamo éna marapátáféna tinkáínífo wíyómpaꞌo kentí óntamo wérainanamo éna wíyómpatafena tinkáíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ísu simátimena séna óraaꞌ-waasigo aaremó toꞌwaai on-tánómbá komandánae séna wínasa wení kísau-waasi unáánkwátói úmaresa ómbá kúraꞌmakesa amuꞌmatuwé mérewana téna táántainasa minúwóíyáámbá ontá tiyankánááwe. Miwí toꞌmayaambó ontembá kembiwíwáráꞌá toꞌmayaa éꞌa amuꞌmaréꞌa méraaro. ");
INSERT INTO auy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Minórááꞌ-wáásígómó tínda wení kísau-waasi kokuꞌá mésa amuꞌmatuwésa ménkaꞌa tínasa aamoí ónááwe. Éraiꞌa simátimeꞌa súne. Minórááꞌ-wáásígó kísaumo maíndasafena unáánkwátói faúꞌmai múra maréna minkwáásísóntáféna maankáꞌ-méwaꞌa tómbá tíméro síníye. ");
INSERT INTO auy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Minórááꞌ-wáásígó nóꞌwaan-afufunaꞌi siyataróráꞌíyo tínda wení kísau-waasi kokuꞌá mésa amuꞌmatuwésa ménkaꞌa tínana tirunkó kaweꞌá íníye. ");
INSERT INTO auy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Simátíménda-aai imáyáan-oro. Naankón-afowámó umén-kwáásímó tínda-kanaamo isénaraa umén-kwáásímó timbá wétoꞌmayaan-ena awánéna watúwáísana wení naaúmpakemba umémbá ímba máísino. ");
INSERT INTO auy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Miyáumai kemá waási úranko kúmóndasafeꞌa kembiwíwáráꞌá ímba imáyáa íyankaꞌa kumúnafainifo wétoꞌmayaan-eꞌa simuꞌmaré méraaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Súwana Pítaa séna Fasiꞌaénkóo emó sénda-aai kentáásáfé aantena wése seyaafáꞌ-wáásísáféwarara wéseno súwana ");
INSERT INTO auy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Fasiꞌaénkó séna kawe-kísáúmó máéwi kaweꞌ-ímáyááwáráꞌ-wáásísáféꞌa súne. Wení óraako séna kesí kísau-waasiyaꞌa káráwiye tómbá tuwímbai tímaꞌmae iyuwó síníye. ");
INSERT INTO auy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wení óraako téna kísaumo kaweꞌ-úmaimo maínda taawánáínana kísaumo maíndawi arunkó kaweꞌá ínana ");
INSERT INTO auy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","minóráákó séna kesí moparáwíné seyaafá-tántáákáꞌé káráwiyuwo síníye. ");
INSERT INTO auy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Énifo minkísáú-wáásígómó imáyáa énamo kesí óraako ayáátáákaꞌa ímba tíníye sénamo kísau-ininakwaꞌo tínkamenamo tóné uwóíꞌ-none wénenamo uwóíꞌo énamo ");
INSERT INTO auy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","wení óraakomo tínda-kanaa ímbo ísarenamo ímbo imáyáa wéindaraꞌa téna óraakaꞌa tatufúꞌmai Maníkón-aai ímbo wéisaan-kwaasimo méraapaꞌa móankainiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ísu simátimena séna kísau-waasi miwítí óraaꞌ-waasigon-aai isésa wemó síndantemba ímbo íyamba mérewana óraaꞌ-waasigo téna óraakaꞌa tatínkaminiye. ");
INSERT INTO auy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Énifo kísau-waasi miwítí óraaꞌ-waasigon-aai ímba isésamo ombá sáwíꞌa ésa méraawana óraaꞌ-waasigo téna kárikaꞌa tatínkaminiye. Maníkó kaweꞌ-ímáyáá óraaꞌo tímakaiyawi óraa-kisau máéro. Kaweꞌ-ímáyáá óraaꞌo tokáiyawi waási túwaꞌnai oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ísu simátimena séna iyamó kaintembá kísaumo máéndasafeꞌa marapáꞌá kumbéraunda minkísáú taiꞌáínana kaweꞌá íníye-imayaa wéune. ");
INSERT INTO auy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kárikaꞌa kembá síꞌo índa-iꞌa íyantafena sirunkó umbaí taisaná síꞌo índa-iꞌo íyamba taiꞌáínana sirunkó kaweꞌá íníye. ");
INSERT INTO auy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kentáféꞌa maarán-ímáyáá ímba oro. Waási seyaafáꞌá aáno úmai méraantafena marapáꞌá kunkáiye. Ímbanifo marapáꞌó kunkáunda maarán-iye. Waási tuwínkaaꞌ-ésa tuwímbai kesáái isáíyasa tuwímbai ímba isánááwe. ");
INSERT INTO auy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Káféꞌwara ánaaenkwaraꞌa moórá-naumpaꞌa séfataase-waasi mésa kesááisafesa miwítí imáyáa tuwínkaaꞌ-urésa kaumbonárau moórá-imayaa íyasa kaeꞌnárai fíꞌon-imayaa óyááye. ");
INSERT INTO auy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Afowá moórá-imayaa ínana ááninko fíꞌon-imayaa íníye. Anówa moórá-imayaa ínana ayáámúnko fíꞌon-imayaa íníye. Anááfúkowe fíꞌo-fiꞌon-imayaa óyááye. Kesááisafesa miyáumai miwítí imáyáa tuwínkaaꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ísu sáwífaꞌ-waasisafena séna ainámbó wérainaꞌo éꞌa séꞌa aaꞌá tíníye síyana aaꞌá tíníye. ");
INSERT INTO auy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Fiyúndá toꞌmái taiꞌáínaꞌo éꞌa séꞌa aaꞌá káíníye síyana aaꞌá káíníye. ");
INSERT INTO auy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wíyómpaꞌo awánéꞌo ombá séꞌa aaꞌá káíníye. Aaꞌá tíníyemo sembá mintántááꞌá awánaraawe. Kaumbo-kaeꞌ-ááíwáráꞌ-wáásí póꞌa miyán-tántáákóní áwáu awánaambanifo Maníkó káféꞌo wéin-tantaakoni áwáu ímba awánaraawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ísu séna simátíménda-aai ísásuweꞌa minkáéꞌ-ámpáꞌá tuwínkaaꞌa uréꞌa moórá-ampaꞌ-aantemba koró. ");
INSERT INTO auy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Moórá-aai ísáaro. Aaimó simátinkanae síyawimo tíꞌmae wíyasa aampaꞌá mósimai paápé uwásuwesa koró. Óraaꞌ-waasimo mátimiyasamo ésa i-wáásí timíyasa ándá-naumpaꞌa tinkánááwe. ");
INSERT INTO auy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ímbo miyá íyasamo ésa ándá-naumpaꞌa mótinkaiyasa ímba ááéma taiꞌánaumne sésa seyaafáꞌ-méyámbá tímatuwaiyasa faútinkanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ísu wésimatimuwasa tuwímbai tasimámesa sésa Káríri-marafaken-kwaasi tuwímbai Maníkóntáfésa ísámai póímo tufúꞌmaimo agáémba kámáni-waasiti óraakon-awiꞌa Páírati tuwímbai tiꞌmáráísasa tínkamisasa pukáawe suwaná ");
INSERT INTO auy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ísu séna minKárírífákémbá pukáan-kwaasisafeꞌo sembá miwítí sáwí-awaugo Kárírifakemba seyaafáꞌ-wáásítí sáwí-awaugomba íyáákaraintafesa pukáawewa wéseo. ");
INSERT INTO auy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ímba miyá wéofo simátimeꞌa súne. Kentí sáwí-awaumo ímbo tuwéꞌo Maníkómpá téꞌo éꞌa kembiwíwáráꞌá puwónááwe. ");
INSERT INTO auy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Imáyáan-oro. Síróámufaꞌa ayáátááꞌ-namba tawiséna sáwífaꞌ-waasi 18 waasi tínkamisasa pukáawe. Mindásafeꞌo sembá miwítí sáwí-awaugo Yérúsaremufakemba seyaafáꞌ-wáásítí sáwí-awaugomba íyáákaraintafena pukáawewa wéseo. ");
INSERT INTO auy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ímba miyá wéofo simátimeꞌa súne. Kentí sáwí-awaumo ímbo tuwéꞌo Maníkómpá téꞌo éꞌa kembiwíwáráꞌá puwónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ísu waéꞌmai-aai simátimena séna moóráwigo wení ándá-aran-kisaufaꞌa arambó naan-táímá áwíꞌa fígi uꞌmakáisana áruma wíkáísana arambá komaénae séna koawánaimba ímba iyáisana ");
INSERT INTO auy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","minkísáúráꞌó káráwiyain-kwaasisafena séna kaumboráꞌá áúꞌo simbá mintáéramba komaénaeꞌa koawánáúnda ímba arambá íyáísaꞌa úmpo mintáí ayáísuwaao. Maragóní anombá nasúwáífainifo ayáísuwaao sisaná ");
INSERT INTO auy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","miwá séna óraakoo ímbanifo mintáí áwáufaꞌa óꞌá túmakeꞌa agamoꞌá makéꞌa ");
INSERT INTO auy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","moórá-auꞌo sínda awánaanana arambó iyéna kaweꞌá ínífo miyámó ímbo ínaꞌa ayáísuwanaumne siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Moórá-kanaa Yúndaa-waasi ámáán-aaimo ísón-kanaaraꞌa Ísu ámáán-daumpaꞌa iména aaí wésimatimuwana ");
INSERT INTO auy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","moórá-ininko sáwí-amutamba arumpimbó méron-ininko ayáátáákaꞌa sáwíꞌa úmai ména 18 aatai maisuwéna miyáumai sáwíꞌa úmai mérowana arósááumba kaénkówana ímba kanaaꞌá kokuꞌá mérowana ");
INSERT INTO auy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ísu minínínkómbá awánéna séna enáíꞌa taiꞌáíno séna ");
INSERT INTO auy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","aneꞌá taꞌótorowana minúwóíyáámbá arósááumba arupíse úwana kokuꞌá íyáfasinena Maníkón-áwíꞌa mósá marówana ");
INSERT INTO auy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ísu saagon-kánááráꞌá minínínkómbá asófankontafena ámáán-dankaꞌo káráwiyowin-arunko sáwíꞌa úwana sáwífaꞌ-waasisafena séna afaꞌmóráe-kanaa kísaumo máénkaꞌa síꞌa asófasinkainkwae séꞌo éꞌa téꞌa saagaan-kánáámó éꞌa ímba teró súwana ");
INSERT INTO auy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Fasiꞌaénkó séna kaumbo-kaeꞌ-ááíwáráꞌ-wáásín-owe. Saagaan-kánááráꞌá kentí purumakawáráꞌá tónki-poiwaraꞌa naaúmpakemba faúꞌankeꞌa áíꞌmae nompáꞌá kowaná nombá wénaiye. ");
INSERT INTO auy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Minínínkó Émbaramun-aísaafitantambo uráin-inimba isaná waántáwanko ayáátáákaꞌa 18 aatai taꞌótokaisaꞌa saagaan-kánááráꞌá faúꞌankaunaꞌa sáwíꞌa óne wésewe Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","símaimo sáwíꞌo uwánkówi minááí isésa tigaemá uwaná kawe-kísáú wémauntafesa úwoi-waasi aamoí uráawe. ");
INSERT INTO auy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ísu séna Maníkó wení waásimo kawáánimba nóinkara kawááníyómpo maarán-ááí simátíménaꞌa ísáaro. ");
INSERT INTO auy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Maníkó wení waásimo kawáánimba maarán-iye. Kári-taerankon-awiꞌa másítáti mintáéramba moóráwigo kísaufaꞌa uꞌmakáisana óraaꞌa éna amaimá mófarena wété uráisana numagó mimpímpáꞌá ánáamba úmarena wémaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Simátimena séna Maníkó wení waásimo kawáánimba nóinkara kawááníyómpo maarán-ááí simátíménaꞌa ísáaro. ");
INSERT INTO auy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Moórá-ininko péréti-tomba agaénae séna kanaráán-tántáákón-áwíꞌa páráwaaꞌa maimaéna intoráínda-tantaaꞌa kári-tantaaꞌa káúmaraisana wéna intoréna óraaꞌa wéiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ísu minááí simátimena Yérúsaremu-naoꞌ-ampaꞌo kúmba naaóꞌ-naoꞌa wenáái simátímaꞌmae kúwana ");
INSERT INTO auy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","moóráwigo séna óraakoo Maníkó moórá-mora-waasi aantena kaweꞌ-ámpáꞌá métinkainiyo súwana Ísu séna ");
INSERT INTO auy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tiyáántán-kwiyéꞌa káriꞌ-ontafimba íyáféráaro. Simátimeꞌa súne. Sáwífaꞌnanka íyáferanae sésa íyambanifo ímba kanaaꞌá íyáferanaawe. ");
INSERT INTO auy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Naankón-afowá íyáfasinena ontá úmarainaꞌa ontaráꞌá iméꞌa áánte séꞌa óraakoo ontasá tisinkaaó síyana séna ímbo tuwánáúnda-waasi nááfakewiyaꞌo sínaꞌa ");
INSERT INTO auy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","kentáásí naaópaꞌa té enáái tasimásimenata eséta tóné nonésá naráumne síyana ");
INSERT INTO auy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","wemá séna nááfakewiyaꞌo. Ímbo tuwánáúnda-waasin-ofo kóro naankón-afowá síníye Ísu simásuwena séna ");
INSERT INTO auy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Maníkó wení waásimo kawáánipaꞌa tiꞌmaráínaꞌa máápakembo awánáíyamba kentíwáꞌná Émbaramuwe Áísáakiye Yékopuwe Maníkón-aaimo simátímakaawiye Maníkómó kawáánipaꞌa méwaꞌa tuwáné tíyántafeꞌa éꞌa ifiꞌá tánááwe. ");
INSERT INTO auy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Seyaafáꞌ-áémpákén-kwáásí Maníkómó kawáánipaꞌa tésa tamésa tómbá nánááwe. ");
INSERT INTO auy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Minkánááráꞌá ánaaemba aifarááwí tínaaeniꞌa íyasa tínaaenkewi aifaríꞌa ónááwe Ísu Maníkómó kawáánintafena minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Minkánáá ámáán-kawaa-waasi tuwímbai Ísumpaꞌa tésa sésa óraaꞌ-waasigon-awiꞌa Éroti séna Ísumba tufúwónana puwíníye wésifo maankáꞌá tuwé fíꞌon-daopaꞌa kóuwo suwaná ");
INSERT INTO auy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ísu séna Érotimba áwáífiyaamo in-áfáꞌ-íyánkáán-kwáásí kosimáme séꞌa sáwí-amutamba waási tirumpinkémbá wémaitiyuweꞌa tíꞌa on-wáásí asófatinkaunda-kisau káféꞌe aafáyáawe maéꞌa aúnká kesí kísau taiꞌánaumne. ");
INSERT INTO auy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Maníkón-aaimo simátímakaawi Yérúsaremu-naopaꞌ-aantemba tínkamowasa wépuwontafeꞌa káféꞌe aafáyáawe aúnkáwe aampaꞌá wéweꞌa kísau maifá kónaumne siyé Érotimba kosimáméro Ísu simásuwena ");
INSERT INTO auy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yérúsaremu-naopaken-kwaasi arumbá uwátinkena séna Yérúsaremu-naopaken-kwaasisono. Maníkón-aaimo simátímakaawi tínkambae íyúwasa pukáawe. Maníkó tiꞌmarówasa kuwáí óntantamba tínkambae íyúwasa pukáawe. Kokórigo áráátombo ayóífáꞌó tínkarenamo káátatinkaintemba aasiyaasi-kánáá kemá miyá ónaumne súndanifo tínaaemba wéuwasimewe. ");
INSERT INTO auy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ísáaro. Maníkó tiyuwáínaꞌa tuꞌnankáámbá ónááwe. Simátimeꞌa súne. Ímba úwoi suwánánááfo ánaaembo séꞌo Maníkó aiꞌmáráísana kunkáiwaimba Maníkó kaweꞌá uwánkáíye síyankaꞌa anekaꞌá suwánánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Moórá-kanaa saagon-kánááráꞌá Ísu ámáán-kawaa-waasi óraaꞌ-waasigoni naaúmpaꞌa tómbó náíndasafena imérowasa saagaan-kánááráꞌó Ísu nóramo índa awánánae sésa imésa awánowana ");
INSERT INTO auy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","moóráwigo aíyayaambo intorón-kwaasigo wení ewaaꞌá mérowana ");
INSERT INTO auy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ísu minkwáásígómbá awánéna ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé tísai ena séna saagaan-kánááráꞌá kanaará áíꞌo in-kwáásí asófankanaumno súwasa ");
INSERT INTO auy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","isésa ímba aaí suwaná minkwáásígómbá áíkena kaweꞌá uwánkena séna énifo waaó súwana kóúwana ");
INSERT INTO auy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tísai ena séna kempínkémbá kentí iyámpóíyaꞌi kentí pórááraꞌiyo maipímbó kúwáfekainaꞌo éꞌa saagaan-kánááráꞌá ááéwa mósá fasinánááo Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","minááí ímba kanaaꞌá anondáá siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aaí ímba anondáá suwasá tómbó nánaesamo tun-kwáásí aifaꞌá iménaemo sumbá Ísu tuwánéna waéꞌmai-aai séna ");
INSERT INTO auy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","moóráwigo séna aaremó toꞌwaai on-tánómbá tamandaaó sína ímba aifaꞌá imauwó. Aifaꞌó iménanamo enáwíꞌo íyáákaraindawimo tínanamo éna ");
INSERT INTO auy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","táántaindawi entáféna séna íyáfasinenana maankwáásígó maankáꞌá tamáíno sínana aigaé uwásuwe tínaaempaꞌa kumbéínone. ");
INSERT INTO auy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Énifo táántainamo tínaaempaꞌo iménanamo táántainda-waasigomo weyááríkaꞌo entáféna séna kesí waásiyo íyáfasine aifaꞌá imauwó sínamo iménasa awánésa enáwíꞌa mósá maránááwe. ");
INSERT INTO auy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Óraaꞌ-waasi úne síyawi Maníkó miwí túwíꞌa múra tiyuwáínífo káriꞌ-waasi únemo síyawi Maníkó miwí túwíꞌa maimaé iyíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ísu simátimena áántarowaisafena séna óraa-tanombo kaufónae sínda-kanaa óntawaraꞌ-waasiye enamááraawe ení akúné ení waási aantemba ímba táántao. Miyámó inasamó ésa ánaaemba áántewa tómbó komandendá mindá ení tónkóní anondáán-iye. ");
INSERT INTO auy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Énifo óraa-tanombo kaufónae sínda-kanaa ímbo óntamo makén-kwaasiye tíyayaamba sáwíꞌo urén-kwaasiye túgafitan-kwaasiye táántenasa tamandáíyambanifo ");
INSERT INTO auy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ení tónkón-ánóndáá ímba amíyambanifo enarunkó kaweꞌá ínana Maníkó ení tónkón-ánóndáá amíníye. Ánaaemba arupíse úmai mén-kwaasi pukémpinkembo íyáfasinaiyan-kanaa Maníkó amíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Minááí súwasa Ísuwe tómbó wénowi isésa uwaná moóráwigo séna Maníkó wení waásimo kawáánipaꞌa tómbó náíyawi tirunkó aamoí íníye súwana ");
INSERT INTO auy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ísu séna éraiꞌa simbánifo simátíménda imáyáan-oro. Moóráwigo óraa-tanomba kaufónae séna sáwífaꞌ-waasi táántarena méraisana ");
INSERT INTO auy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","mintánómbó náíyan-kanaa kárikaꞌa tínana wení kísau-waasigomba aiꞌmáráísana táántaraiwaisafena séna tómbó nembá wétoꞌmayaan-ifo teró sisasá ");
INSERT INTO auy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","miwí ímbo tíyan-aai sewaná moóráwigo séna maramá méyánureꞌa koawánanaumpo ímba tanómbo kaúfópaꞌa kónaumne siyé kosimámuwo sisaná ");
INSERT INTO auy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","moóráwigo séna siyáánkai-poima méyánureꞌa koawánanaumpo ímba tanómbo kaúfópaꞌa kónaumne siyé kosimámuwo sisaná ");
INSERT INTO auy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","moóráwigo séna káféꞌa aaré maiyáunda póꞌa tanómbo kaúfópaꞌa ímba kónaumne siyé kosimámuwo sisaná ");
INSERT INTO auy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","minkísáú-wáásígó wení óraakompaꞌa téna miyá sewé tasimámísana arunkó sáwíꞌa isaná séna minúwóíyáámbá naaóꞌ-naoꞌa wéne tíyayaamba sáwíꞌo uráinda-waasiye túrambo kafíkáinda-waasiye óntama ímbo makén-kwaasiye tiyaafáí úmai tíꞌmae tiyó séna aiꞌmáráísana ");
INSERT INTO auy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","minkísáú-wáásígó miyá kosímai kouweréna taséna simásimendantemba kosímai tíꞌmaeꞌo túnda ení naaúmpaꞌa paaí tuꞌmaꞌá wéraiye sisaná ");
INSERT INTO auy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","wení óraako séna seyaafáꞌ-wáásí kesí naaúmpata sisipáá oro. Seyaafáꞌ-ámpáꞌá wéne waásimo tiyaafáí e óraakaꞌa símai tíꞌmae tiyó siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ísu séna simátime séꞌa aifaꞌó táántaraiwai ímba tésa wení tómbá ímba tamandánááwe Ísu minááí waéꞌmai-aai siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Súwasa Ísuwe aampaꞌá kuwaná méwaerena simátimena séna ");
INSERT INTO auy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","kembó sirááíwaenae síyawi aifaꞌá kembá imáyáa simésa ánaaemba tinófoiye tuwaainíné iyámpóíye tífárawaawiye túnafaraawine kesáfésawe imáyáan-oro. Ímbo miyámó íyamba uwófíꞌa ónááfo miyámó ésamo ésa kembá sirááíwaesa kesí kísau-waasi-iꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kemó púwónda-aaraa-taimo súwaataꞌmae kondantembá kembó sirááíwaiyawi umbai-tántááꞌá timíyasa minúmbáí-tántááꞌó ímbo maimaésamo sirááíwáémba uwófíꞌa ombá pósa ímba kesí kísau-waasi-iꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Moórá-aai ísáaro. Ayáátááꞌ-nambo ónae síyawi aifaꞌá óntambo tuwésamo íyan-imayaa ésa óntamba toráumai awánáíyambo kanaamó ínasamo ésa mináyáátááꞌ-námbá ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ímbo toráumai awánaresamo mindámbó íyamba minóntámbá taíꞌáwinana mindámbá úwoi wérainasa waási awánésa ímba ásawimai uwásukaawe sésa tuwíyáái ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Moórá-aai ísáaro. Moórá tiyáífín-órááꞌ-wáásígó tiyánae séna aifaꞌá wení i-wáásímó torausínda sáwífaꞌ-waasi 10,000 waasi ínana fíꞌon-i-waasiti óraako wení i-wáásímó torausínda áfááraumai sáwífaꞌ-waasi 20,000 waasi ínana imáyáa éna kembá íyáákanaa ína íyáákanaao séna ");
INSERT INTO auy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ímba kanaaꞌá íyáákanaumne-imayaa énamo éna óraaꞌ-waasi némpaꞌa mérainana aantá-waasi tiꞌmaréna séna mintíyáísá ifátá tuwánae siyé kosimáméro síníye. ");
INSERT INTO auy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ísu minááí simásuwena séna aifaꞌá íyan-imayaa urésa ánaaemba síyantemba ónááwe. Miyáumai kembá sirááíwaenae síyawi aifaꞌá makáan-tantaatafesa imáyáa urésa ímba mintántááꞌá tuwánáúmne sésamo ésa kembá ímba sirááíwaenaafo mintántááꞌá tuwánáúmne sésamo ésa kembá sirááíwaesa kesí kísau-waasi-iꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ísu simátimena séna uwímá kawe-tántááꞌán-ifo óraaꞌa taíꞌáísana ayáántámba wéraifo ímba anekaꞌá uwímó káínaꞌo éꞌa toꞌmaránááwe. ");
INSERT INTO auy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ayáántámba ímba agamopáꞌá maráíyana kaweꞌá ínífo úwoifaꞌa tuwánááwe. Ísáán-kwaasi ísámai kaweꞌán-oro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Taakisi-óntámbó máún-umen-kwaasiye sáwíꞌo un-kwáásíyé Ísumpaꞌa wenáái isánae sésa tuwasá ");
INSERT INTO auy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ámáán-kawaa-waasiye ámáámbo sun-kwáásíyé tuwánésa tirunkó sáwíꞌa úwasa keáímbá sésa sáwí-waasiseꞌa tómbá wénena aaimó simbá sáwíꞌa wéiye suwaná ");
INSERT INTO auy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ísu minááí iséna waéꞌmai-aai séna ");
INSERT INTO auy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","sipisípiyaꞌo káráwiyowimo on-ááí ísáaro. Moóráwigo sáwífaꞌa 100 sipisipiyaꞌa káráwiyaisana moórá-sipisipi áwiyoꞌwisasa misáwífá-sípísípí ufáꞌá méraawana moórámo áwiyoꞌwimba kosaafá émena awánéna ");
INSERT INTO auy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","aamoí éna áúwaataꞌmaena ");
INSERT INTO auy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","naaópaꞌa téna wenamááraawe wení naaópaken-kwaasiye táántaisasa túwaandu owaná séna kesí sipisípi áwiyoꞌwisaꞌa kosaafá émeꞌa áíꞌmae túmpo aamoisá ónae sisasá aamoí uráawe. ");
INSERT INTO auy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Simátime súne. Miyáumai wíyómpaꞌo méraawi marapáꞌó tuwánaamba arupíse úmaimo méraan-kwaasi kaweꞌ-úmaimo méraamba tuwánésa aamoí owasá sáwíꞌa úmaimo méraampinkemba sáwí-imayaa tuwésa Maníkómpáꞌá tíyasa Maníkóní kísau-waasi wíyómpaꞌo méraawi óraaꞌ-aamoi wéowe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ísu séna moórá-aai imáyáan-oro. Moórá-ininko siyáánkai-ontan-arumba makáisana moórá áwiyowisana ómbá kúraꞌmakena wení naaúmpaꞌa kankambá wéwiyufena kaweꞌá uwámai saafá éna ");
INSERT INTO auy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","awánéna wenamááraawe wení naaópaken-kwaasiye táántaisasa túwaandu owaná simátimena séna kesí óntamba áwiyowisaꞌa saafá émeꞌa maiyáumpo aamoí íyataao sisasá aamoí uráawe. ");
INSERT INTO auy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Simátimeꞌa súne. Miyáumai sáwíꞌo úmaimo méraampinkemba sáwí-imayaa tuwésa Maníkómpáꞌá tíyasa Maníkóní kísau-waasi wíyómpaꞌo méraawi óraaꞌ-aamoi wéowe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ísu séna moórá-aai imáyáan-oro. Moóráwigo kaeꞌ-íyámpóíwáráwí méraisana ");
INSERT INTO auy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ánaaenkewi afowántáféna séna ení seyaafá-tántááꞌá ímbo pukéndara káféꞌa tuwí-simiyo sisaná tuwímbai ááninkai tímísana ");
INSERT INTO auy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ánaaenkewi kárikaꞌa ména wembó ámakaim-boparawimba tiména óntan-aantemba maimaéna némpaꞌ-marafaꞌa koména sáwíꞌa úmaena wéiyena wení óntamba tuꞌmái ");
INSERT INTO auy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","taíꞌásuwaisana óraaꞌ-aawaima taisaná tóntáféna saafá uwááena ");
INSERT INTO auy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","mimbáráfákén-kwáásígómpáꞌá wéna kísau maénae kosimámísana kesí marafáꞌá komé kesí póíyaꞌa káráwiyuwo sisaná ");
INSERT INTO auy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","póíyaꞌa káráwiyena ááisafena úmae wéiyena póíti tómpínkémbá nánae séna sisasá ímba áméwana ");
INSERT INTO auy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ánaaemba kaweꞌ-ímáyáá éna séna kesifoní kísau-waasi sáwífa-tomba wénesa tímúꞌa faisasá arááꞌwaraꞌa wémaraafo maankáꞌá méꞌa sáái táínaꞌa puwúnafaimpoꞌa ");
INSERT INTO auy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","maankáꞌá tuwéꞌa kesifompáꞌá wéꞌa séꞌa kesifóo Maníkón-aúrankaꞌe enaúrankaꞌe sáwíꞌa úmpo ");
INSERT INTO auy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","kentáfé kesááninkowe sénda uwófíꞌa ómpo kesí kísau-waasiye siyó kosénaumne séna ");
INSERT INTO auy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","mifáꞌá tuwéna témena aampaꞌá tisaná némpakemba afowá awánéna aruntaféna uwánkena aínténa kotaparéna ifiꞌá wétaisana ");
INSERT INTO auy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ááninko séna kesifóo Maníkón-aúrankaꞌe enaúrankaꞌe sáwíꞌa uráumpo kentáfé kesááninkowe sénda uwófíꞌa óne sisaná ");
INSERT INTO auy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","afowá minááí ifátuwena wení kísau-waasi táántaisasa tewaná séna minúwóíyáámbá kaweꞌ-únánkwátói maimaé máuwankeꞌa kesáánimba intáféꞌa waiyambá wéuwankeꞌa aísamai ánáamba wéuwankeꞌa ");
INSERT INTO auy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ánóíwara-purumaka-araaꞌa maimaéꞌa mátufuꞌmai aamoi-tánómbá kaufíyata wéneta aamoisá uwánkáano. ");
INSERT INTO auy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kesááninko áwiyokurai pukurái súnana úwoi ména timbá póta aamoisá ónaumne sisasá aamoí uráawe. ");
INSERT INTO auy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Aamoí owaná aifakéwí kísaufakembo timbá naankóní ewaaꞌá téna aamoimó on-ááí taiséna ");
INSERT INTO auy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","kísau-waasigomba áántena séna nóinkaꞌ-aamoiya wéoo sisaná ");
INSERT INTO auy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","enáfáꞌa kaweꞌ-úmai tiyáisana enafo séna ánóíwara-purumaka-araaꞌa tufúꞌmai kaúfóro sisasá miyá wéesa méraawe sisaná ");
INSERT INTO auy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","minááí ísáísana arunkó sáwíꞌa isaná kaoréna ímba naaúmpaꞌa íyísana afowá máápaꞌa kuména aifakéwín-arumbá kusímai íyáísana ");
INSERT INTO auy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","afowántáféna séna ayáátáákaꞌa esé méꞌa sáwífaꞌ-aatai wémaisuweꞌa enáái ímbo taraisúnda emó séndantemba miyá wéuna óraa-poiye kári-poiye méme-araaꞌe ímba tufú-simenaꞌa kesí waásiseꞌa naráumne. ");
INSERT INTO auy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Enááninko ení óraaꞌ-ontamba maimaé koména aare tineꞌá minóntámbá mátuꞌmai taíꞌásuwena tisá ánóíwara-purumaka-araaꞌa tufúꞌmai kau-améne sisaná ");
INSERT INTO auy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","afowá séna ayáátáákaꞌa keséꞌo méraanda kesí seyaafá-tántááꞌá endén-iye. ");
INSERT INTO auy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Enáfáko áwiyokurai pukurái súnana úwoi ména tintáféta aamoisá uwánkaumne siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ísu wení kísau-waasisafena séna moórá-aai ísáaro. Moóráwigo moparáwínkwáráꞌ-wáásígó kísau-waasisafena séna kesí moparáwínkáꞌá káráwiyuwo sisaná miyá isasá tuwímbai tésa sésa ení moparáwínkáꞌá ímba kaweꞌ-úmai káráwiyaisana ení óntamba áwiyokaiye sewaná ");
INSERT INTO auy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","miwá iséna káráwiyaiwaimba áántaisana tisaná séna enáái sewaꞌá isáúmpo kesí moparáwínkáꞌá ímba káráwinompo kesí moparáwínkáꞌá káráwinda-aufai agai-símínaꞌa ení kísaugoni áwáu awánaano sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","wéwena imáyáa éna kesí óraakomo siꞌmátuwainaꞌa nóra ónaumno. Kemá ímba fasiꞌaénkó póꞌa maramó ufí-kísáú ímba kanaaꞌá maénaumpo inaimó sísáféna sigaé ínífo ");
INSERT INTO auy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","miyá éꞌa aasásóíꞌá úmae wénonana siꞌmátuwainasa miwítí naaúmpaꞌa sínkaresa tómbá siménááwe-imayaa uwásuwena ");
INSERT INTO auy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","wení óraakompakembo ánaaemba méyánónaumne sésa úwoimo maiyáan-kwaasi táántaisana moóráwigo tisaná séna kesí óraakomba nóraumai-meyana amínono sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","séna sáwífaꞌ-masawemba 100 masawemba ówitamai aménaumne sisaná miwá séna ení aúfáífimba ímba 100 iye sindá 50 iye símai agai-simiyó sisaná miyá isaná ");
INSERT INTO auy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","moóráwigo tisaná séna kesí óraakomba nóraumai-meyana amínono sisaná séna sáwífa-ton-unamba 100 unamba aménaumne sisaná miwá séna ení aúfáífimba ímba 100 iye sindá 80 iye símai agauwó sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","minááímó simbá óraakomba simáméwana iséna wení moparáwínká sáwíꞌa úmai káráwiyaiwaintafena séna kaweꞌ-ímáyááwáráꞌ-wáásímó ontembá miyá óne siyáiye. Marapáꞌ-wáásí kentí imáyáarakemba ásawimai miyámó ondawí kaweꞌá íníye símai wémaefo sámo kain-áémpáꞌó méraan-kwaasi ímba miyá wéowe. Miyáumai óraako wení moparáwínkáꞌó káráwiyaiwaintafena séna kaweꞌ-ímáyááwáráꞌ-wáásímó ontembá miyá óne siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ísu simásuwena minááísáféna séna ísáaro. Marapáꞌá kentí óntantamba túwaꞌnai íyasa kentí waási-iꞌa íyaꞌa kentí óntambo taiꞌáíndaraꞌa wíyómpaꞌo ésa iyíyan-kanaa wíyómpaꞌa minkwáásí tuwánésa aamoí uwátinkanaawe. ");
INSERT INTO auy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kári-tantaakaꞌa kaweꞌ-úmaimo káráwiyowi óraa-tantaakaꞌwaraꞌa kaweꞌ-úmai káráwiyonaawe. Kári-tantaakaꞌa sáwíꞌa úmaimo káráwiyowi óraa-tantaakaꞌa sáwíꞌa úmai káráwiyonaawe. ");
INSERT INTO auy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Marapá-tántáákáꞌó ímbo kaweꞌ-úmaimo káráwiyaiyawimo éna Maníkó wíyómpaken-tantaaꞌa ímba tiména káráwiyoro síníye. ");
INSERT INTO auy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Marapáꞌó Maníkómpákén-tántáákáꞌó ímbo kaweꞌ-úmaimo káráwiyaiyawimo éna Maníkó wíyómpaken-tantaaꞌa ímba tiména kendén-iye síníye. ");
INSERT INTO auy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ímba kanaaꞌá kae-káwáá-wáásítí kísau wémaewe. Miyámó ésamo ésa moóráwigomba aamoí ésa moóráwigomba ímba aamoí uwánkanaawe. Miyámó ésamo ésa moóráwigoni kísau kaweꞌ-úmai maésa moóráwigoni kísau tuwesaraí ónááwe. Miyáumai Maníkóní kísaumo maéꞌo éꞌa sáwífaꞌ-ontamba maénaumne-imayaa ímba úmae iyónááwe. Sáwífaꞌ-ontamba maénaumne-imayaamo éꞌo éꞌa Maníkóní kísau ímba maénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ísu minááí súwasa ámáán-kawaa-waasi isésa óntantafesa aamoí wéesa pósa Ísun-awíyáái uwaná ");
INSERT INTO auy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ísu simátimena séna kembiwí waási túrankaꞌa kawe-kísáú wémaewasa tuwánésa sésa kaweꞌ-wáásín-owe wésefo Maníkó kentí imáyáa wétuwanaiye. Seyaafá-tántáákón-áúmo mósá máráán-tantaatafena Maníkó sáwísamban-iye wésiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ísu simátimena séna Mósese Maníkóní ámáámbo simátímakain-aaiye Maníkón-aaimo simátímakaawimo agaimakáan-aaiye mindá aambó usukáín-ááímó éna Yónimo nombó maitínkarainkaꞌa minááí tiyáiye. Káféꞌa ásé-aai Maníkó wení waásimo kawáánin-aai wésimatimemba pósa waási Maníkómó kawáánipaꞌa tiyáántámba fasiꞌámaesa wéiyaferaawe. ");
INSERT INTO auy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Marawé wíyóne taiꞌáínífo Maníkóní ámáámba káriꞌ-amaane óraaꞌ-amaane ímbo taiꞌáínda aasiyaasí waéꞌwaeꞌa íníye. ");
INSERT INTO auy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Moóráwigo awaainímbá aiꞌmátuwenamo fíꞌon-inimbo máímba umémbá wémaiye. Moórá-waasigo aiꞌmátukain-inimbo máímba wewáráꞌá umémbá wémaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ísu séna moórá-aai ísáaro. Óntawaraꞌ-waasigo ména kaweꞌ-únánkwátói sáwífaꞌa makéna kawe-tómbá námaꞌnamaꞌ-isaná ");
INSERT INTO auy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","moóráwigon-awiꞌa Rásarasi ímba óntamo makáiwai óraaꞌ-namomba kaisaná méraisasa ayáí-tómbá amínana náíníye sésa óntawaraꞌ-waasigoni ontaráꞌá móankaraawana méraisana iyánkó téna mindámómbá tauwáꞌnaraiye. ");
INSERT INTO auy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ánaaemba ímbo óntamo makáin-kwaasigo púwísasa Maníkóní kísau-waasi wíyómpakewi kunáíꞌmaesa Émbaramumo kaweꞌ-mápáꞌó méraipaꞌa móankaraawana óntawaraꞌ-waasigo púwísasa utámakaawana ");
INSERT INTO auy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","púwón-aempaꞌo iyamó wégaipaꞌa óraaꞌ-aiꞌa isaná ména mósá awánaimba némpaꞌa Émbaramuwe Rásarasiyeꞌa méraayana tuwánéna ");
INSERT INTO auy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","aaemáífinkemba séna kesifóo Émbaramuwo iyamó wégaipaꞌa óraa-siꞌa isaꞌá méraumpo arumbá uwásinke Rásarasimba aiꞌmárénana kunkéna ayáámba nompí támai sinááfíyaꞌa maráínana tasíyasi íno sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Émbaramu séna kesááninko marapáꞌó méraandaraꞌa seyaafá-káwé-tántááꞌá makáampo Rásarasi sáwíꞌa úmai méraifo mindásafe imáyáan-uwo. Káféꞌa wemá kaweꞌ-úmai méraifo embá áíꞌo ipaꞌá méraane. ");
INSERT INTO auy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Senda-ááíwáráꞌá imáyáan-uwo. Afufumpimbá óraa-tunai wéraifo ímba wété ónááfo sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","óntawaraꞌ-waasigo séna kesifó Émbaramuwo emó sénda-aaisafeꞌa simámeꞌúne. Rásarasimba aiꞌmárénana kesifoní naaópaꞌa ");
INSERT INTO auy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","séfataase kesífárawaisai méraafo kusimátimena sáwí-marupaꞌo iyamó kaipaꞌá tefó simátimino sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Émbaramu séna Mósesemo siyáin-aaiye Maníkón-aaimo simátímakaawi siyáan-aaiye aúfáífimbo agaimakáamba pósa toráumai isánááwe sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","kesifó Émbaramuwo ímbanifo moóráwigo pukáimpinkemba íyáfasinena kusimátiminasa sáwí-imayaa tuwésa Maníkómpáꞌá kónááwe sisaná ");
INSERT INTO auy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Émbaramu séna Mósesemo siyáin-aaiye Maníkón-aaimo simátímakaawi siyáan-aaiye ímbo isésamo ésa pukáimpinkembo íyáfasinkaiwain-aai ímba isánááwe Émbaramu siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ísu wení kísau-waasisafena séna fíꞌo-fiꞌon-tantaaꞌa waásifaꞌa tínasa kesáái tuwánááwe. Tuwímbai tésa kesááimo wéisaawi karoꞌ-ááí tasimátimiyasa kesáái tuwésa kóíyasa karoꞌó síyawifaꞌa sáwí-meyamba tíníye. ");
INSERT INTO auy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Miwímó tinuwarampimbó óraaꞌ-ontamba fáríꞌwimaresamo nompímbó túwááwasamo kumpuwésaraa karoꞌ-ááí ímba simátíméwasa kesááimo ísaraan-iyampoi kesáái ímba tuwésa sáwíꞌa owisinó. ");
INSERT INTO auy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mindásafeꞌa kentúraꞌa káráwiyoro. Kentí waásimo kembó sáwíꞌo uwátinkaiyaꞌo éꞌa kembiwífáꞌá mindásafe simátimiyasa sáwíꞌa únemo síyaꞌo éꞌa ímba anekaꞌá imáyáa éꞌa ifáꞌá túwáaro. ");
INSERT INTO auy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kentí waásigomo kembó sáwíꞌo uwántínkáfaꞌo iyésamo kempáꞌó tésamo sáwíꞌa únemo símae iyíyaꞌo éꞌa ímba anekaꞌá imáyáa éꞌa ifáꞌá túwáaro. Mimbórá-kánáámó afakaetéraꞌo miyámó íyaꞌo éꞌa ímba imáyáa éꞌa ifáꞌá túwáaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Suwasá Fasiꞌaénkóní aantá-waasi wentáfésa sésa entáféta simankúnkúntaamo úndasa súwaꞌnai inatá entáféta simankúnkúntaamo úndasa fasiꞌámaisa méraano suwaná ");
INSERT INTO auy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Fasiꞌaénkó séna moórá-taigon-awiꞌa másítáti káriꞌ-aramba tuꞌmakáawana áruma wíkéna óraa-tainambo intembá miyáumai kentáféꞌa timankúnkúmba íyambo éꞌa óraa-taisafe séꞌo taawíꞌwé óraaꞌ-nompimba kunkaruwuwó síyanamo éna miyá íníye Ísu siyaíye. ");
INSERT INTO auy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ísu wení kísau-waasisafena séna moórá-aai ísáaro. Kísau-waasigomba aiꞌmárááwana kísau wémaena kísaufakenaꞌi póíyaꞌo káráwiyaindafakenaꞌi timbá ení tómbá emá agaimái naaó ímbo síyamba ");
INSERT INTO auy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","kafegafé úmai kaweꞌ-únánkwátói uré tómbá agai-símínaꞌa nasúwáana ánaaemba ení tómbá agaimái náínone miyán-ááí wésewe. ");
INSERT INTO auy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sintembá kísau-waasi miyá ésa úwoi miwítí kísau isasá miyá ombá pósa ímba túwíꞌa mósá wémaraawe. ");
INSERT INTO auy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Miyáumai kembiwí miyá éꞌa simátíméndantemba éꞌa taiꞌáíyankaꞌa séꞌa úwoi wení kísau-waasisa úndasa póta úwoi kentáásí kísausa maiyáumne séꞌa ímba kentú maimaéꞌa íyóro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ísu Yérúsaremu-naoꞌ-ampaꞌo kúmba Sámériyaa-marawe Káríri-marawe afufumpin-ámpáꞌá wéna ");
INSERT INTO auy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","moórá-naopaꞌa kúwasa námombo kón-kwaasi siyáánkai-waasi wétesa némpaꞌo Ísumo túmba awánésa ");
INSERT INTO auy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aaemái sésa óraako Ísuwo kentáá arumbá uwásinkaao suwaná ");
INSERT INTO auy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ísu tuwánéna séna ámáán-kisau-waasifaꞌa wéꞌa kentú máaraatimiyasa tuwánésa námomba kawáúwiye sénááwe súwasa aampaꞌó kumbá túma kaweꞌá uwátinkowana ");
INSERT INTO auy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","miwífínkémbá moóráwigo áúma kaweꞌó uwánkomba awánéna kouweréna óraaka tasiyéna Maníkón-áwíꞌa mósá maréna ");
INSERT INTO auy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ísu óraakon-iye séna aísamaifimba takífaena súwi séna minkwáásí ímba Yúndaa-waasin-ifo Sámériyaa-marafaken-kwaasigo súwi súwana ");
INSERT INTO auy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ísu séna siyáánkai-waasi túma kaweꞌó uwátinkaunda afaꞌéíyain-kwaasi ímba kouwérááwana ");
INSERT INTO auy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","kímborawigo fíꞌom-barafaken-kwaasigo kouweréna Maníkón-áwíꞌa mósá máráíye simásuwena ");
INSERT INTO auy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","minkwáásígóntáféna séna kentáfé súwaꞌnai índawin-iye sénda póna enáú kaweꞌán-ifo waaó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Súwasa ámáán-kawaa-waasi Ísumba áísai esa sésa Maníkó wení waásimo kawáánin-kanaa nóin-kanaawa tíníyo suwaná Ísu séna Maníkó wení waásimo kawáánimba ímba kanaaꞌá túrantamba awánánááfo ");
INSERT INTO auy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Maníkó wení waásimo kawáánimba waási túraꞌa ómbaraimba pósa mifáráꞌi maafá káráwiyaiye ímba kanaaꞌá sénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ísu simátimena wení kísau-waasisafena séna ánaaemba kemá waási úranko kúmónda-kanaa awánánae síyambanifo ímba miyán-kánáá suwánánááwe. ");
INSERT INTO auy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tuwímbai sésa maafáꞌá méraifo taawánaaromo síyasa fíꞌowi sésa maafáꞌá méraifo taawánaaromo síyaꞌo éꞌa ímba éraiꞌe séꞌa wété oro. ");
INSERT INTO auy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wíyómpaꞌo aafáyáumo tóráísasamo awánaantemba kemá waási úranko miyáumai aforaꞌá anekaꞌá kumónaumne. ");
INSERT INTO auy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Misúnda-aai ímba paápé uráinasa aifaꞌá káféꞌo méraan-kwaasi tínaaemba uwásinkesa síꞌo índa-iꞌa uwásinkanaawe. ");
INSERT INTO auy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Naaófáꞌá moóráwigon-awiꞌa Nówaamo méronkaꞌa waási ímba Maníkón-ímáyáá ésamo maéꞌóntemba ánaaemba kemá waási úranko kúmónda miyá ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nówaamo méronkaꞌa noné tóné wénesa tiyáámúmba wétoꞌwaai-esa aaré máúwasa waaí máúwasa wéuwana Nówaa nompín-táómpimba imérowana piriꞌ-nónkó seyaafáꞌ-wáásí tínkamuwasa putásaraawe. ");
INSERT INTO auy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Naaófáꞌá moóráwigon-awiꞌa Rótimo méronkaꞌa ímba Maníkón-ímáyáá ésa noné tóné wénesa méyánúmae wénesa kísauwe naané úmae néꞌómba ");
INSERT INTO auy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Róti Sóndómu-naopaꞌo tiyuwónkaꞌa Maníkó óntankwara iyaronkwáráꞌá wíyómpakemba tuwówana kuména tínkamuwasa putásaraawe. ");
INSERT INTO auy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Rótimo méronkaꞌa waási ímba Maníkón-ímáyáá ésamo maéꞌóntemba kemá waási úranko anekaꞌó kumpaápé ondaráꞌá miyá ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Anekaꞌó kúmóndaraꞌa ontaráꞌó méraiyan-kwaasi ímba naaúmpaꞌo iyíyamba moparáwímbá ifátuwanaawe. Kísaufaꞌo méraiyan-kwaasi ímba naaúmpaꞌo tíyamba moparáwímbá ifátuwanaawe. ");
INSERT INTO auy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Róti awaainínkón-áái imáyáan-oro. Wení moparáwímbó tuwón-imayaa éna mówaerowana óntankwara iyaronkwáráꞌá kuména tufúwana pukáiye. ");
INSERT INTO auy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tirááímo táínda-iꞌo ésa ímba kaweꞌ-úmai ménaafo kentáfésa imáyáa ésa tirááímo táínda-tantaaꞌo tuwésamo puwésa aúíꞌa úmai maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Simátimeꞌa súne. Anekaꞌó kúmóndaraꞌa mindóꞌwáámbá kaeꞌ-wáásí mimbóráfáꞌá túmá wéreyana Maníkó moóráwigomba auwéna moóráwigomba aiyáíníye. ");
INSERT INTO auy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Minkánáá kaeꞌ-ínínkáí tómbó wétoꞌmayaan-íyana Maníkó moórá-inimba auwéna moórá-inimba aiyáíníye. ");
INSERT INTO auy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kaeꞌ-wáásí kísaufaꞌo méreyana Maníkó moóráwigomba auwéna moóráwigomba aiyáíníye Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","wení kísau-waasi sésa Fasiꞌaénkóo emó sénda-aai nááfatafewa sénó suwaná póíye sawaíyémó kawááꞌipaꞌo náíndasafenamo embontaan-dúmágómó tatorúpaintemba Maníkó sínana súnda-aai paápé íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ísu séna aasiyaasí Maníkómpáꞌá inaí wésesa túwáafo séna waéꞌmai-aai simátimena séna ");
INSERT INTO auy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","moórá-naopaꞌa aaimó ísáín-kwaasigo ména ímba Maníkón-áároi inkaiséna ímba waási-imayaa éna méraisana ");
INSERT INTO auy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","mindáópaꞌa ketoꞌ-ínínkó ména aasiyaasí aaimó ísáín-kwaasigompaꞌa tóso éna séna sáwíꞌa uwásinkanaesa wéofo aaí súwaꞌnai uwásinkaao sisaná ");
INSERT INTO auy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ayáátáákaꞌa wenáái ímba ísarena ánaaemba imáyáa éna séna Maníkón-áároi ímba inkaiséꞌa waási-imayaa ímba éꞌa wéumpo ");
INSERT INTO auy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","minínínkó kempáꞌó timbá suwesaraí ifáímpóꞌa áwaꞌnai ónaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Fasiꞌaénkó simásuwena séna aaimó ísáí-sawi-waasigon-aai imáyáan-oro. ");
INSERT INTO auy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Maníkóní waási wempáꞌó inaimó símae íyómba túwáafo séna ímba ayáátáákaꞌa úwoi ména miwí táái iséna ");
INSERT INTO auy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","sáwíꞌo uwátínkénkaꞌa ááéma túwaꞌnai íníye. Ánaaemba kemá waási úranko anekaꞌó kúmóndaraꞌa méraiyan-kwaasifinkemba kesááisafesa timankúnkúmba ónaa ína ónaao tuwánánaumne Ísu séna Maníkómpáꞌó inaimó símae íyómba túwáafo séna minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tuwímbai kaweꞌ-wáásí úne sésa kentúma maimaé iyésa fíꞌon-kwaasi túma símai sáwíꞌo uwátínkén-kwaasisafena waéꞌmai-aai Ísu simátimena séna ");
INSERT INTO auy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","kaeꞌ-wáásígóráí moóráwigo ámáán-kawaa-waasigon-ifo moóráwigo taakisi-óntámbó máín-kwaasigo ésarai óraaꞌ-amaan-daumpaꞌa inaí séyae sésarai iyóyamba ");
INSERT INTO auy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ámáán-kawaa-waasigo kokuꞌá ména wenáú maimaé iyéna séna Maníkóo kemá tuwímbaimo ontembá ímba wéumpo entáféꞌa súwi súne. Umémbó maésamo karoꞌó sésamo aare-úmémbá ésamo ontembá kemá ímba miyá wéune. Maaméraiwai taakisimó máín-umen-kwaasigomo intembá kemá ímba miyá wéune. ");
INSERT INTO auy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aasiyaasi-sóndááráꞌá kae-kae-kánáá ámáántafeꞌa imáyáa éꞌa ímba tómbá wénaumne. Aasiyaasi-kísáúgóní sondaaráꞌó maúnda-tantaaꞌa tuwínkeꞌa kemá afaꞌéíyaimba maéꞌa moórá embá ámaꞌmaeꞌa wéiyune sisaná ");
INSERT INTO auy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","taakisimó máín-kwaasigo moóráfa kokuꞌá ména aigaé éna kífaena séna Maníkóo kempímbá sáwí-imayaa wéraifo arumbá uwásinkaao siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ísu minááí simátimena séna ísáaro. Maníkó taakisimó máíwaini sáwí-imayaa maiyaúwáísana Maníkóe taankarotámai maéna wení naaópaꞌa wisaná ámáán-kawaa-waasigo wempímbá sáwí-imayaa úwoi wéraisana wení naaópaꞌa kuráiye. Óraaꞌ-waasi únemo síyawi Maníkó túwíꞌa múra tuwáínífo Maníkón-aísamaifimbo méraawi Maníkó túwíꞌa maimaé iyíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Simátimuwasa tuwímbai Ísu taꞌótorena kaweꞌá uwátinkainkwae sésa iyámpói tíꞌmae tuwasá wení kísau-waasi tuwánésa kóro suwaná ");
INSERT INTO auy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ísu miníyámpóísáféna táántena séna teró. Ímba kóro síyamba tiyuwáíyasa kempáꞌá iyámpói úwoi teró. Miníyámpóímó kempáꞌó tentembá Maníkó wení waásimo kawáánimba miyáráán-úmai wégawaanimba iyámpóímo kempáꞌó tíyan-amba ímba aambá faíyóro. ");
INSERT INTO auy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Éraiꞌa simátime súne. Maníkóntáfésa sésamo iyámpóíyaan-úmai kenkáꞌá wégawaanonemo síyanamo éna miwíyáꞌá kawáánínífo ímbo miyá síyawimo éna ímba kawááníníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Súwana moóráwigo Yúndaa-waasiti óraako Ísumpaꞌa téna séna óraakoo kawekó óne. Nóra úmaiya aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónaumno súwana ");
INSERT INTO auy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ísu séna kentáfé nóra séwa kawekó óne wéseno. Mimbóráwígó Maníkó weyáá kawekón-iye. ");
INSERT INTO auy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Maníkóní ámáámba éꞌa ísaraane. Minámáámbá aúfáífimba agaimaréna séna ímba aare-úmémbán-oro. Ímba waási tínkamiyasa púwóro. Ímba umémbá máéro. Ímba karoꞌ-ááí simátínkáaro. Kentinófoi-tuwiꞌa óraaꞌ-iꞌan-oro siyáiye súwana ");
INSERT INTO auy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","miwá séna minámáámbá kemá iyámpóíyakemba ísareꞌa kaweꞌá úmae wéiyune súwana ");
INSERT INTO auy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ísu iséna séna kaweꞌá éma moórá-tantaaꞌa ímba kaweꞌá uráampo ení moparáwímbá fíꞌon-kwaasi wétime óntamba maiyé ímbo makéwi tímínana ení kaweꞌ-méyámbá Maníkó wíyómpaꞌa ankáíníye. Tímatuwemo e kembá sirááíwainone súwana ");
INSERT INTO auy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","minááí iséna sáwífaꞌ-moparawimbo makóntafena óraaꞌ-imayaa úwana arunkó sáwíꞌa uráiye. ");
INSERT INTO auy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Arunkó sáwíꞌa úwana Ísu awánéna séna sáwífaꞌ-ontamo makén-kwaasi Maníkómó wení waásimo kawáánipaꞌo wíyamba umbaí táíníye. ");
INSERT INTO auy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Moórá-poigon-awiꞌa káámeri mimpóígó waigóní afaapimbá ímba kanaaꞌá kóferainiye. Káámeri-poigomo waigóní afaapimbó kóféráínkakaa sáwífaꞌ-ontamo makáan-kwaasi Maníkómó kawáánipaꞌa kowisinó súwasa ");
INSERT INTO auy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","minááí isésa áísai esa sésa umbaí taifó nóran-kwaasiya Maníkómó kawáánipaꞌa méranaao suwaná ");
INSERT INTO auy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ísu séna waási miwítí kísausamba ímba méyámbaresa kónááfo Maníkó úwoi kanaaꞌá wéiye súwana ");
INSERT INTO auy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pítaa séna isaaó. Kentáásí naaópaꞌa tuwéta entá wéaraaiwaumne súwana ");
INSERT INTO auy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ísu séna éraiꞌa simátime súne. Maníkó wení waásimo kawáánintafesa imáyáa ombá naaópaꞌa tuwésa tuwaainíné tuwaaísáiye tinófoiye táánine tiyáámúne tiyuwésa miyáumaimo túwááwin-anondaa ");
INSERT INTO auy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","marapáꞌó méraankaꞌo túwáán-tantaaꞌa miyán-tántááꞌá sáwífaꞌa mémaesa ánaaen-kanaa aúíꞌa úmai wíyómpaꞌa maéꞌmaeꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ísu wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasi tíꞌmaena moórá-aempaꞌa tínkarena simátimena séna ísáaro. Yérúsaremu-naopaꞌa konanasá naaófáꞌó Maníkón-aaimo simátímakowimo waási úrankon-aai agaimakáan-aai paápé íníye. ");
INSERT INTO auy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kembá síꞌmai fíꞌonkaa-waasi timíyasa karaánááꞌa sinkésa símai sáwíꞌa uwásinkesa tuwiyáái wisinkésa ");
INSERT INTO auy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","súwiyonkuꞌ-nésa sínkamiyaꞌa púwónasa utámaraiyaꞌa kaumbo-kánáá maisuwéꞌa íyáfasinanaumne Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","wení kísau-waasi nóin-aaisafenawa síyó sésa minááígóní áwáumo aúpáꞌó wérontafesa ímba ísámai kaweꞌá ésa Yérúsaremu-naoꞌ-ampaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ísu aampaꞌó kúmba Yéríko-naoꞌ-ewaaꞌa kúwana moóráwigo aúrambo kafíkówi óntamba inaí símai maénae séna aanawáísáraꞌa kumbéna wéinai séna ");
INSERT INTO auy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sáwífaꞌ-waasimo tésamo kínkimbo sumbá iséna nááwiyaꞌo súwasa ");
INSERT INTO auy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ísu Násaretifakewi wétiye suwaná ");
INSERT INTO auy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","óraaka séna Ísuwo Téfítin-andafakewi ómpo arumbá uwásinkaao súwasa ");
INSERT INTO auy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","aifaꞌó tun-kwáásí aaisambá aéésa sésa aseraaó suwaná minááí ifátuwena anekaꞌá óraaka séna Ísuwo Téfítin-andafakewi ómpo arumbá uwásinkaao súwana ");
INSERT INTO auy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ísu aampaꞌó wémomba wení ewaaꞌá koíyáfasinena séna áíꞌmae teró súwasa áíꞌmaesa ewaaꞌá tuwaná Ísu áísai ena séna ");
INSERT INTO auy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","nóin-tantaara embá arááímo táínda-tantaaꞌa uwánkanaumno súwana séna óraakoo súramba kaweꞌá uwásinkaao súwana ");
INSERT INTO auy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ísu séna kentáfé kanaaꞌá súwaꞌnai índawin-iye sémpo aúramba kaweꞌá íno súwana ");
INSERT INTO auy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","minúwóíyáámbá aúramba kaweꞌ-úmai awánéna Ísumba arááíwaꞌmae wéwena Maníkón-áwíꞌa mósá marówasa sáwífaꞌ-waasi awánésa Maníkón-áwíꞌa mósá makáawe. ");
INSERT INTO auy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Maníkón-áwíꞌa mósá márówana Ísu Yéríko-naopaꞌa kóyáákanae séna kúmba ");
INSERT INTO auy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","moóráwigon-awiꞌa Sákíyasi taakisi-óntámbó máún-kwaasiti óraaꞌ-waasigo éna sáwífaꞌ-ontamba makéna ");
INSERT INTO auy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ísumba awánánae séna úmba sáwífaꞌ-waasi fáítukowana ampáán-kwáásígó éna ímba kanaaꞌá awánéna ");
INSERT INTO auy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","maanámpáꞌá tíníye séna minkwáásí tínaaempakemba aifaꞌá íyáákena moórá-taifaꞌa íyátena mérowana ");
INSERT INTO auy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ísu mintáígóní áwáufaꞌa wéna mósá awánéna séna Sákíyasiyo ení naaúmpaꞌa kónaumpo minúwóíyáámbá marapáꞌá kumuwó súwana ");
INSERT INTO auy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","aamoí uwásuwena minúwóíyáámbá marapáꞌá múra tuwéna kúwááíꞌmaena wení naaúmpaꞌa kúwasa ");
INSERT INTO auy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","minkwáásísómbá awánésa tirunkó sáwíꞌa úwasa sésa sáwíꞌo in-kwáásígóní naaúmpaꞌa wéwiye suwaná ");
INSERT INTO auy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sákíyasi wení naaúmpaꞌa mósá ankéna Fasiꞌaénkóntáféna séna óraakoo kesí ónta afufuntambá tuwínkeꞌa tuwímbai ímbo makén-kwaasi timéꞌa tuwímbai karoꞌá simátinkeꞌa óntamba umémbó maiyáunda póꞌa éíyain-eiyain-úmai tímaꞌmaeꞌa kónaumne súwana ");
INSERT INTO auy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ísu séna káféꞌa maandáúmpáꞌó méraan-kwaasi kaweꞌ-ámpáꞌá métinkaumne. Émbaramun-aísaafitantambo uráandasafeꞌa miyá úne. ");
INSERT INTO auy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kemá waási úranko kumpaápé uráundawi enkáán-kwáásí saafá úmai sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌó métínkáandasafeꞌa kunkáumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Minááí ísówana Ísu Yérúsaremu-naokoni ewaaꞌá kúwasa weséꞌo kun-kwáásí imáyáa ésa sésa Maníkó wení waásimo kawáánimba kárikaꞌa paápé íníye suntáféna waéꞌmai-aai simátimena ");
INSERT INTO auy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","séna moórá-oraakon-aai ísáaro. Kámáni-waasi némpaꞌ-marafaꞌa méraawana kotísai onasamó kanaán-iyemo síyaꞌo éꞌa kesí waásiyaꞌa takáráwiyonae séna ");
INSERT INTO auy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","wení kísau-waasi siyáánkai-waasi táántaisasa tewaná óntamba kae-táémo kae-táémoꞌa tiména séna koméraanaꞌa minóntánkákémbá kísau wémaiyaꞌa téꞌa tuwímbai-ontankwaraꞌa tamáéno séna kóísasa ");
INSERT INTO auy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","wenamááraa tíyántafesa uwánkesa kámáni-waasi kosimátime séꞌa kentááráꞌá ímba takáráwiyiniye kosimátíméro sewasá kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Énifo minóráákómbá káráwiyi-kisau áméwana kouweré téna ááémo óntambo tímakain-kwaasi táántaisasa tewaná séna tímakaunda-ontankakemba nóraumai-ontana maiyáao sisaná ");
INSERT INTO auy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","aifaꞌó ámakaiwai téna séna óraakoo símakaanda-ontankakemba kísau wémaeꞌa moórá kae-táémoꞌa maiyáumne sisaná ");
INSERT INTO auy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","óraako séna kesí kísau-waasigo kaweꞌá óne. Kári-tantaakaꞌa kaweꞌ-úmai káráwiyaampo siyáánkai-naoraaraꞌa káráwiyuwo sisaná ");
INSERT INTO auy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","moórá-kisau-waasigo téna séna óraakoo símakaanda-ontankakemba kísau wémaeꞌa siyáánkai-taemoꞌ-ontamba maiyáumne sisaná ");
INSERT INTO auy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","énifo séfataase-naoraaraꞌa káráwiyuwo sisaná ");
INSERT INTO auy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","moórá-kisau-waasigo téna séna óraakoo símakaanda-ontamba ampantafímbá múꞌmúmai aúpáꞌá makáumpo máínone. ");
INSERT INTO auy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Emá fasiꞌaén-kwáásí éma ímbo makáanda-tantaaꞌa wémae úwoi wéne fíꞌowiti kísaufaken-tomba wénaana póꞌa enáároi inkaiséꞌa úwoi aúpáꞌá makáumpo máínone sisaná ");
INSERT INTO auy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","óraako séna sáwí-kisau-waasigo ónda póꞌa kentáfémo séndantemba aaí simánkanaumne. Kentáfé sé fasiꞌaén-kwáásí éma ímbo makáanda-tantaaꞌa wémae úwoi wéne fíꞌowiti kísaufaken-tomba wénaane sémpo ");
INSERT INTO auy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kesí óntamba seyaafáꞌ-wáásítí óntambo máráán-daumpaꞌo makáandarakaa tiyéꞌa kesí óntankwara aꞌwáá-ontankwaraꞌa máúsino séna ");
INSERT INTO auy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","méraan-kwaasisafena séna maanóntámbá maiyéꞌa kae-táémoꞌ-ontambo tokáiwaimba áméro sisasá ");
INSERT INTO auy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","miwí sésa ímbanifo kae-táémoꞌ-ontamba éꞌa tokáiye sewaná ");
INSERT INTO auy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","óraako séna simátime súne. Sáwífa-tantaakaꞌo kaweꞌ-úmaimo káráwisinkaawi moórá-mora-tantaaꞌa tíménasa káráwisinkanaafo ímbo kaweꞌ-úmaimo káráwisinkaawifinkemba makáan-tantaaꞌa máénaꞌa ");
INSERT INTO auy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kesí namuro-wáásí kentááráꞌá ímba káráwinone siyáawi tíꞌmaeꞌa kempáꞌá tiyéꞌa tínkamiyasa púwóro siyáiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ísu minááí simátimena aifaꞌá Yérúsaremu-naoꞌ-ampaꞌo kúmba ");
INSERT INTO auy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Órífi-omapaꞌ-ewaaꞌ-naokai moórá Pétífasi-naoꞌa úwana moórá Pétáni-naoꞌa úwana minkáéꞌ-náóꞌ-ewaaꞌa wéna wení kísau-waasiyai kaeꞌá mátiꞌmarena séna ");
INSERT INTO auy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","epín-dáópaꞌa kurékai moórá-poigon-awiꞌa tónki koawáneyambo waásimo ímbo ayáákainda-poi ándá awátuwekai áíꞌmae tekaiyó. ");
INSERT INTO auy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Moóráwigo tuwánénamo nóra óyaekaiya óyómo sínakai óraako ayááꞌmaeꞌa kónae siyé simámékaiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","kuyaná súntemba mimpóí mérowasarai koawánésarai ");
INSERT INTO auy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ándá koawátúwóyana mimpóígón-afowá awánéna séna nóra sékaiya mimpóígóní ándá wéawaaeyo súwasarai ");
INSERT INTO auy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","mindárai sésarai óraako ayááꞌmaena wínkwae simásuwesarai ");
INSERT INTO auy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","áíꞌmaesarai Ísumpaꞌa tuyasá wení kísau-waasi paákákén-únánkwátói faúꞌmai mimpóígón-arósááunkaꞌa wandaaí uwíꞌmárówana Ísumba ayááꞌmae wéguwasa ");
INSERT INTO auy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","sáwífaꞌ-waasi mésa óraaꞌ-waasin-iye sésa paákákén-únánkwátói faúꞌmai aampaꞌá uwíꞌmaꞌmae wéguwana minúnánkwátóiyaꞌa auwétamaena wéwena ");
INSERT INTO auy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Órífi-omapaken-ampaꞌo kumúmba Yérúsaremu-naoꞌ-ewaaꞌa kúwasa Ísumba sáwífaꞌ-waasi arááíwaꞌmae wéwesa aamoí ésa fíꞌo-fiꞌon-kisau kawe-kísáú maúmba awánontafesa Maníkón-áwíꞌa mósá marésa óraakaꞌ-oraakaꞌa sésa ");
INSERT INTO auy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Fasiꞌaénkó aiꞌmáráísana kunkáiwaimba Maníkó minkáwáágómbá kaweꞌá wéuwankaiye. Maníkó kentáásáféna séna aáno úmai méraaro wésimba póna wenáwíꞌa óraaꞌa wéiye óraakaꞌa suwasá ");
INSERT INTO auy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","misáwífáꞌ-wáásífínkémbá tuwímbai ámáán-kawaa-waasi sésa óraakoo embó arááíwaꞌmae wénon-kwaasisafe sé aséráaro siyó suwaná ");
INSERT INTO auy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ísu séna simátime súne. Miwí ímba aaimó senkakaa maanóntánkó kentáfénawe séna aaí sisinó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ísu Yérúsaremu-naoꞌ-ewaaꞌa wéna awánéna waási tífiꞌa téna séna ");
INSERT INTO auy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aáno úmaimo máéwini áwáu ímba ísámai kaweꞌá uráawe. Isékaa aáno úmai méraawisino. Káféꞌa ímba kanaaꞌá wéisaawe. ");
INSERT INTO auy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kentí namuro-wáásí tésa kentí naaópaꞌa taúkúresa maramá uꞌmái ontafímbá agariꞌá tásuwesa ");
INSERT INTO auy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","kentí aare-iyámpóíwaraꞌa tínkamesa kentí naambá tawísísuwanaawe. Maníkó kaweꞌ-ámpáꞌá métinkanae séna tisaꞌá tínaaemba uwánkáámba pósa kentí namuro-wáásí tésa miyá ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ísu minááí simásuwena Yérúsaremu-naopaꞌa óraaꞌ-amaan-daumpaꞌa iyéna ámáán-daumpaꞌo méyámbó un-kwáásí itiꞌmátuwena ");
INSERT INTO auy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","simátimena séna Maníkón-aai aúfáífimba agaimaréna séna mindá kesí naambá Maníkómpáꞌó inaimó sen-dámbán-iye agaimaréna siyáiye. Énifo umén-dáúmpáꞌó ontenkáámbá uráawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aasiyaasí óraaꞌ-amaan-daumpaꞌa Ísu simátímaꞌmaena iyúwasa óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé óraaꞌ-waasiye Ísumbo tufíyan-aai suwasá ");
INSERT INTO auy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","úwoi-waasi sáwífaꞌa Ísun-aai ísámae wéiyuwasa tufuwíyan-amba ímba kanaaꞌá saafá uráawe. ");
INSERT INTO auy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Moórá-kanaa Ísu óraaꞌ-amaan-daumpaꞌa iména Maníkóní ásé-aai simátimuwasa óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé Yúndaa-oraaꞌ-waasiye tésa ");
INSERT INTO auy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","sésa nááwawa aiꞌmáráísawa tiyéwa nááwampinkena maiyéwa fasiꞌaén-kísáú wémaeno. Simásimiyo suwaná ");
INSERT INTO auy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ísu séna aifaꞌá moórá-aai tísai onaꞌá simásíméro. ");
INSERT INTO auy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ááéma Yóni nombó maitínkaraiwai Maníkówá simámakaisanawa nombá maitínkarai waásiya simámakaawanawa nombá maitínkaraiyo súwasa ");
INSERT INTO auy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","miwí keáímbá sésa nórasaawa sénaumno. Maníkó simámakaisana nombá maitínkaraiye senanasáámó éna nóra séra Yónin-aaisafeꞌa ímba éraiꞌe siyáao síníye. ");
INSERT INTO auy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Waási simámakaawana nombá maitínkaraiye senasasáámó ésa úwoi-waasisa sínkamonaawe. Úwoi-waasi sáwífaꞌ-waasi Yónintafesa sésa Maníkón-aaimo simásímakaiwai uráiye wésemba pósa óntamba maiyésa sínkamonaawe. ");
INSERT INTO auy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ísuntafesa sésa emó sísai ónda-aaisa ímba isáúmne suwaná ");
INSERT INTO auy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ísu séna ímbo simásimiyaꞌa nááwampinkena maiyéra fasiꞌaén-kísáúmó maúnda-aai ímba simátimenaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ísu waéꞌmai-aai simátimena séna moóráwigo ándá-aran-kisau úmarena ayáátááka fíꞌom-barafaꞌa koménae séna maankísáúráꞌó káráwiyaawimo éꞌa kesáféꞌa tuwímbai-aramba wémaeꞌa tuwímbai kembá siyúwáaro simátimena fíꞌom-barafaꞌa koméraisana ");
INSERT INTO auy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","arambó áfumo kain-kánáá tisaná aanáfó kesí ándá-aramba komauwó séna wení kísau-waasigomba aiꞌmáráísana minkísáúráꞌó káráwiyowifaꞌa tisasá taꞌótoꞌmai tufúꞌmaresa ándá-aramba ímbo ámémba aiꞌmátuwaawana kóísana ");
INSERT INTO auy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","aanáfó moóráwigomba aiꞌmáráísana tisasá minkísáúráꞌó káráwiyowi taꞌótoꞌmai tufúꞌmaresa sáwíꞌa uwánkesa ándá-aramba ímba ámémba aiꞌmátuwaawana kóísana ");
INSERT INTO auy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","aanáfó moóráwigomba aiꞌmáráísana tisasá taꞌótoꞌmai tufúꞌmárááwana naaemá kúmísasa famétuwaawana kóísana ");
INSERT INTO auy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","aanáfó séna nóra ónaumno. Kesááninko imáyáamo ámakaundawimba aiꞌmáráanana wínasa wenáái isánááwe séna aiꞌmáráísana tisasá ");
INSERT INTO auy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","minkísáúráꞌó káráwiyowi awánésa keáímbá sésa aanáfón-ááninko tifo tufúwónanasa puwéna maankísáú ímba maínata kesáá maénae sésa ");
INSERT INTO auy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","taꞌótoꞌmai ándá-aran-kisaufakemba famétuwesa tufúwówana pukáiye. Ísu minááí simátimena séna minkísáú-áánáfó miyá íníye. ");
INSERT INTO auy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Téna kísauraꞌo káráwiyowi tínkaminasa puwíyana fíꞌonkaa-waasi kesí kísauraꞌa káráwiyoro síníye Ísu súwasa minááí isésa sésa ímba miyán-oro suwaná ");
INSERT INTO auy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ísu árimba tuwánéna tísai úmai isánae séna imáyáan-oro séna Maníkón-aai aúfáífimba maarán-ááí agaimaréna séna óntan-dambo on-kwáásí moórá-ontantafesa sáwíꞌa wéiye sésa maisukáawe. Ánaaemba minóntánkó áfonkaamba uráiye agaimaréna siyáimba minááísáféꞌa imáyáan-oro. ");
INSERT INTO auy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wíyamba minóntánkáꞌá tanaambá kofésa sáwíꞌa ónááfo minóntánkó tufúꞌmai sáwíꞌa uwásuwainiye Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé simbá kentáásáféna siyé sésa taꞌótoꞌmai tufuwónae sésamo umbá seyaafáꞌ-wáásísáféna tááꞌa úwasa ifátukaawe. ");
INSERT INTO auy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ifátuwesa taꞌótoraiyan-kanaa káráwiyesa tuwímbai tiꞌmarésa sésa Ísun-aaimo ísáán-kwaasimo ontembá téꞌa áísai íyana sáwí-aaimo sínata taꞌótoꞌmai kámáni-kawaagompaꞌa móankanaumne sésa tiꞌmárówasa Ísumpaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","sésa óraakoo éraiꞌ-aai wése waási táároi ímba inkaisé óraaꞌ-waasiye úwoi-waasi táároi ímba inkaisé tirumbó faiyáꞌmai-aai ímbo sénda Maníkóní aambó arááíwáén-aai arupíse úmai simátimendasa ísaraumne. ");
INSERT INTO auy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Emá nóran-imayaawa ónó. Kanaasááwá taakisi-óntámbá Rómu-kamanisa timénaum íntaawa timénaumno. Tíméndasa Yúndaa-waasisa kentáásí ámáána taraisónaum íntaawa taraisónaumno. Timénaum íntaawa timénaumno suwaná ");
INSERT INTO auy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ísu miwítí imáyáa iséna séna ");
INSERT INTO auy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","moórá-ontamba maimaé máaraasimero súwasa maimaé máaraanamuwana séna nááwan-óikaana uráinkara áwíꞌa wéraiyo súwasa Rómu-kamani-kawaagon-óikaamba isaná áwíꞌa wéraiye suwaná ");
INSERT INTO auy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Rómu-kamani-kawaagonde wembá áméro. Maníkóndé Maníkómbá áméro súwasa ");
INSERT INTO auy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","minááí ísówana tááꞌa úwasa ímba aaí siyáawe. Ísu waási túrankaꞌa ména ímba sáwí-aai súwasa pósa ímba aaí sésa taꞌótokaawe. ");
INSERT INTO auy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ímba taꞌótórówasa Sátúsi-amaan-kawaa-waasi púwómpinkemba ímba íyáfasinanaawe sun-kwáásí pósa Ísumpaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","sésa óraakoo naaófáꞌá Mósese séna moóráwigo aaré maimakéna iyámpói ímbo maꞌánkáímba puwínana áfáko maimakéna awaaón-anondaa-wareꞌe séna iyámpói maꞌankáíníye siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Moórá-aai isaaó. Moórá-kanaa afakaeté-afarawainonda mésa tuwaaó aaré maimakéna iyámpói ímbo maꞌánkáímba púwísana ");
INSERT INTO auy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","wenánaaenkewi wareꞌá maimakéna iyámpói ímbo maꞌánkáímba púwísana ");
INSERT INTO auy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","wenánaaenkewi wareꞌá maimakéna iyámpói ímbo maꞌánkáímba púwísana miyá émesa afakaeté-waasi putásaawana ");
INSERT INTO auy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","minínínkó ánaaemba pukáiye simámesa ");
INSERT INTO auy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ísumba áísai esa sésa miyámó ombá waási puwíyampinkembo íyáfasinaiyan-kanaa minínímbá afakaeté-waasi tuwaainímbá éna nááwa máíníyo suwaná ");
INSERT INTO auy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ísu séna marapáꞌó méraan-kwaasi aaré maíyasa waaí maíyasa tiyáámúmba toꞌwaaí ésa wéowe. ");
INSERT INTO auy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Maníkó táántena séna pukémpinkemba íyáfasineꞌa wíyómpaꞌa iménaawe siyáimba minínínákwáꞌá wíyómpaꞌo iméraiyamba aaré ímba maíyasa waaí ímba maíyamba ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Maníkóní kísau-waasimo wíyómpaꞌo mésamo ímbo púwóntemba minkwáásí miyá ésa ímba anekaꞌá puwónááwe. Pukémpinkembo íyáfasinaiyamba Maníkóní waásin-owe. ");
INSERT INTO auy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Waási pukémpinkembo íyáfasinaiyamba Mósese minááísáféna agaimakáiye. Aúfáífimba agaimaréna séna áru-taiyaꞌa iyamó kaimbá ímba mintáí káwisana mintáífínkémbá Maníkó Mósesentafena séna Maníkó úne. Enaíwáꞌná Émbaramune Áísáakine Yékopune miwítí Maníkó úne siyáiye. Maníkó minááímó siyáimba minkáúmbó-wáásí éꞌa púwúwasa utaráambanifo ");
INSERT INTO auy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","minááí siyáimba pósa miwí úwoi méraawe. Maníkón-aúrankaꞌa seyaafáꞌnánká méraawe Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ámáámbo sun-kwáásí sésa óraakoo kaweꞌ-ááí simásímakaane suwaná ");
INSERT INTO auy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ísun-aaigo tááꞌa úntafesa ímba áísai uráawe. ");
INSERT INTO auy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ímba áísai uwaná Ísu séna Káráísiti Téfítin-andafaken-kwaasin-iye wésefo ");
INSERT INTO auy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","naaófáꞌá Téfíti Káráísitintafena séna kesí Fasiꞌaénkón-iye siyáimba imó agaimakón-aufaifimba Téfíti agaimaréna séna kesí Fasiꞌaénkóntáféna Maníkó séna kesiyáánúrapaꞌa fasiꞌaén-áémpáꞌá ");
INSERT INTO auy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","maraꞌ-ménaꞌa ení namuro-wáásí íyáákaanasa miwí taiꞌánááwe Maníkómó siyáin-aai Téfíti siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Miyáumai Téfíti Káráísitintafena séna kesí Fasiꞌaénkón-iye siyáimbanifo nóraumaiya wemá Téfítin-andafaken-kwaasin-iye Ísu súmba Káráísiti Téfítini Fasiꞌaénkó éna Téfítin-andafaken-kwaasigon-iye. ");
INSERT INTO auy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sáwífaꞌ-waasi minááí ísówana Ísu wení kísau-waasisafena séna ");
INSERT INTO auy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ámáámbo sen-kwáásítí aambá arááíwáéfo. Minkwáásí ayáátáá-kuferai wiyésa naaópaꞌa afufumpaꞌá nówasa pósa waási tuwánésa sésa óraaꞌ-waasin-owe wésewe. Minkwáásí ámáán-daumpaꞌo ombá óraaꞌ-waasimo máépaꞌa imésa tanómbo kaúfópaꞌo ombá kaweꞌ-áémpáꞌá mésa kawe-tómbá wénaawe. ");
INSERT INTO auy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Minkwáásí ketoꞌ-íníntí óntawara naankwaráꞌá umémbá maésa waási suwánésa súwíꞌa mósá maráíwae sésa karokómbá tafisímai inaí wésewe. Miyámó on-ánóndáá óraaꞌ-umbai maénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Simátimena Ísu óraaꞌ-amaan-daumpaꞌa ména tuwánómba óntambo túwón-anafeumpimba sáwífaꞌ-ontawaraꞌ-waasi sáwífaꞌ-ontamba túwówana ");
INSERT INTO auy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","moórá-ketoꞌ-ininko ímba óntamo makón-ininko téna káriꞌ-ontamba kae-tóyáráámbá tuwómba Ísu awánéna ");
INSERT INTO auy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","wení kísau-waasisafena séna éraiꞌa simátime súne. Minkétóꞌ-ínínkómó túwáín-ontanko seyaafáꞌ-wáásímó túwáán-ontamba íyáákaiye. ");
INSERT INTO auy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Miwí sáwífaꞌ-ontafinkemba tuwímbai túwáafo wemá káriꞌ-ontafinkemba mútúꞌa túwáímba póna ónta-iyaimba méíniye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Súwasa tuwímbai óraaꞌ-amaan-dantafesa sésa kaweꞌ-óntánkákémbá úmakaawe. Maníkómbá ámakaan-tantaaꞌa koꞌnaarirí úmakaawata awánéta aamoisá úne suwaná ");
INSERT INTO auy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ísu séna ánaaemba waási tésa awánaan-tantaaꞌa seyaafá tawísísuwesa seyaafáꞌ-óntánkwáráꞌé tawísísuwanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ísu minááí súwasa áísai esa sésa óraakoo emó sénda nóin-kanaawa paápé íníyo. Nóin-kwaamera ínataawa séta ampáánkáꞌá Ísumo siyáimba miyá íníyesa sénaumno suwaná ");
INSERT INTO auy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ísu séna karoꞌ-ááí iséꞌa éraiꞌe sefó káráwiyoro. Sáwífaꞌ-waasi tésa kesúwíꞌa máwatesa sésa Maníkómó íyáfasisinkaraiwai únda póna minkánáá ampáánkáꞌá tíníye sénááwe. Miyán-ááí síyawi ímba tirááíwáéro. ");
INSERT INTO auy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tíyááwemo síyan-aai némpakenaꞌi ewaakénáꞌi isáíyana ímba tááꞌa íno. Miyán-kánáámó tínda mindá ímba seyaafá-tántááꞌó taiꞌáínda-waameꞌan-iye. ");
INSERT INTO auy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Fíꞌo-fiꞌon-aempaꞌ-waasi tiyánááwe. Moórá-kawaa-waasigomo éna moórá-kawaa-waasigoni amááraasafena íyáfasine tíyáaromo sínasa íyáfasinesa tiyánááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Fíꞌo-fiꞌom-barafaꞌa óraaꞌ-mari táíníye. Fíꞌo-fiꞌom-barafaꞌa aawaí táíníye. Sáwífaꞌ-waasi tíꞌa íníye. Wíyómpaꞌa fíꞌo-fiꞌon-tantaaꞌa paápé ínaꞌa awáné táátafeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mintántááꞌó ímbo paápé ínasa kembiwí taꞌótoꞌmai sáwíꞌa uwátinkesa ámáán-daumpaꞌa kawáá-wáásí aaifimbá maitinkésa ándáfaꞌa mótinkanaawe. Kentáféꞌo fasiꞌámaimo méraiyantafesa taꞌótoꞌmai óraaꞌ-waasifaꞌe kámáni-kawaa-waasifaꞌe mótinkesa aaí simátinkaiyaꞌa ");
INSERT INTO auy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","minórááꞌ-wáásí kesáái simátimenaawe. ");
INSERT INTO auy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aaimó simátínkénkaꞌa nóran-aaiya sénaumno-imayaa ímba óraaꞌa íyana tirunkó umbaí táíno. ");
INSERT INTO auy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Minkánáá kaweꞌ-ímáyáá timéꞌa aaí tááka tínkáanaꞌa síyasa kentí namuro-wáásí ímba kanaaꞌá kentáái taraisésa íyáákanaawe. ");
INSERT INTO auy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kentinófoiye kentífáꞌawaawiye kentimááraawe kentí waásiye tíꞌmaesa óraaꞌ-waasiyaꞌa iyésa aaí simátinkaiyasa kempínkémbá tuwímbai tínkamiyaꞌa puwónááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kentáfé fasiꞌámaimo méraiyantafesa seyaafáꞌnánká tíyámba uwátinkanaawe. ");
INSERT INTO auy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Miyá ésa ímba timambá tínkambai taiꞌánááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Fasiꞌámaimo méꞌo éꞌa kaweꞌ-úmai méranaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ísu minááí simátimena séna Yérúsaremu-naopaꞌa namuro-wáásí taúkúmaraiya séꞌa seyaafá-tántááꞌá tawísísuwaiyan-kanaa tiyé sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yúndiyaa-marafaꞌo méraiyan-kwaasi omápata tuwaantantésa iyónááwe. Naaópaꞌo méraiyan-kwaasi mindáópaꞌa tuwésa wété ónááwe. Kísaufaꞌo méraiyan-kwaasi ímba naaópaꞌa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Minkánáá Maníkó sáwí-meyamba timínana Maníkón-aai aúfáífinken-aai paápé íníye. ");
INSERT INTO auy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tímúkaꞌ-inine káféꞌ-iyampoiwaraꞌ-inine minkánáá sáwíꞌa ónááwe. Maníkó maankwáásísáféna aaisambá tiyínana óraaꞌ-umbai táíníye. ");
INSERT INTO auy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Fíꞌom-barafakewi tuwímbai paepáétamba tínkamesa tuwímbai tíꞌmaesa fíꞌo-fiꞌon-kwaasiti marafáꞌá mótinkesa fíꞌonkaa-waasi Yérúsaremu-naopaꞌa káráwiyesa sáwíꞌa íyana Maníkó séna kentí kanaa taíꞌáiye síníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ísu minááí simátimena séna aafáúráꞌé wíyónkaꞌe okáꞌé fíꞌo-fiꞌon-tantaaꞌa paápé íníye. Marapáꞌá fíꞌo-fiꞌom-barafaken-kwaasi tirunkó umbaí táíníye. Uwí-nónkó óraakaꞌa áái wésena tufántááfan-ínasa waási inkaisónááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wíyónko toraꞌnááraꞌa ínasa waási sésa nórawaꞌiyo sésa tinekembá tataꞌá ínasa táátafesa ésa óraaꞌ-imayaa ónááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kemá waási úranko óraa-fasiꞌaenkwara sámo kainkwáráꞌá ainánká kúmónaꞌa suwánánááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kemó súnda-tantaaꞌa áwáu ómbarena paápé ínaꞌa mósá awánánááwe. Maníkó kaweꞌ-ámpáꞌá métinkainda-kanaa kárikaꞌo tínda póꞌa toꞌmayaa éꞌa mósá awánaaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ísu minááí simátimena séna moórá naan-táígón-áwíꞌa fíki mindáwara fíꞌon-taiwaraꞌa imáyáan-oro. ");
INSERT INTO auy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Asáómó agaínda awáné séꞌa áúꞌo sínda-kanaa kárikaꞌa tíníye sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Miyámó intembá kemó súnda-tantaaꞌa ínaꞌa awáné séꞌa Maníkó wení waási kawáánimba kárikaꞌa tíníye sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Éraiꞌa simátime súne. Káféꞌo méraan-kwaasi tuwímbai ímbo pukáiyankaꞌa kemó súnda-tantaaꞌa paápé íníye. ");
INSERT INTO auy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wíyóne marawé taiꞌáínífo kesáái ímbo taiꞌáínda úwoi waéꞌwaeꞌa íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ísu simátimena séna kentúraꞌa káráwiyoro. Uwóíꞌo on-dómbá néꞌa kafóná méꞌa marapá-tántááꞌá óraaꞌ-imayaa ofáínifo. Miyá éꞌo éꞌa ímba imáyáamo wéiyankaꞌa kumúnafainifo káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kífoꞌo aumakáawanamo waígo ímbo imáyáa imbó tafááfíntemba fíꞌo-fiꞌom-barafaken-kwaasi ímbo wéisenkaꞌa kumúnafainifo ");
INSERT INTO auy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","káráwiyoro. Inaí símae wéiyiyana kemó súnda-tantaaꞌa kempáꞌó tínaꞌo éꞌa fasiꞌámai méꞌa waási úranko súrankaꞌa méranaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Minkánááfímbá aasiyaasi-kánáá Ísu óraaꞌ-amaan-daumpaꞌa iména wenáái simátímaꞌmae wéiyena fenómpinka máápaꞌa kumbéna Órífi-omapaꞌa nóꞌwaamba imaéꞌmae úwasa ");
INSERT INTO auy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","sáwífaꞌ-waasi aafáyáaraꞌa ááéma Ísun-aai isánae sésa óraaꞌ-amaan-daumpaꞌa imaéꞌmaeꞌa úmae iyáawe. ");
INSERT INTO auy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Naaófáꞌá Maníkó Yúndaa-waasi tíyótaimo í-tánómbá ímbo intóráín-tantaaꞌwara-pereti agáún-kanaa kárikaꞌa túwasa ");
INSERT INTO auy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé Ísumbo tufíyan-aai suwaná úwoi-waasisafena tááꞌa úwasa ímba aforatá taꞌótoranaumne siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Suwaná Ísuni kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasifinkemba moóráwigon-awiꞌa Yúndasi moórá-awiꞌa Ísakerioti éna waántáwanko wenarumpimbá koména imáyáa amúwana ");
INSERT INTO auy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","óraaꞌ-amaan-kisau-waasifaꞌe ámáán-dakaꞌo káráwirowifaꞌe wéna séna túwaꞌnai onaꞌá Ísumba taꞌótoranaawe súwasa ");
INSERT INTO auy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","isésa aamoí ésa sésa miyámó inda-méyámbá óntanta aménaumne suwaná ");
INSERT INTO auy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yúndasi ewé séna ímbo waásimo mépaꞌo éꞌa nóraumaiya Ísumba aráátíménasawa taꞌótoranaao-imayaa ómbarena úmae kuráiye. ");
INSERT INTO auy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yúndaa-waasi ímbo intóráín-tantaaꞌwara-pereti agáún-kanaa túntemba tíyótaimo í-tánón-kánáá sipisípi-araaꞌa tufúꞌmai káúfúnkaꞌa ");
INSERT INTO auy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ísu Pítaante Yóninteꞌa tiꞌmaréna séna tíyótaimo í-tánómbá kowégaufiyata komandaanó súwasarai ");
INSERT INTO auy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","mindárai sésarai nááfara kogaufóyauyo suyaná ");
INSERT INTO auy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ísu séna Yérúsaremu-naopaꞌa wíyana moóráwigo nonánámó maimaé wíndawimba arááíwáékaiyo. Wemó naaúmpaꞌo iyíndafaꞌo ");
INSERT INTO auy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","naankón-afowámó mérainakai kosimámekai óraako áísai ena séna kesí kísau-waasiseꞌa náán-aempara tíyótaimo í-tánómbá nánaumno wésiye kosimámékaiyo. ");
INSERT INTO auy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wemá afófumayaaꞌ-nankoni óraaꞌ-aempaꞌa aráátiminiye. Kúfuꞌo uwándáíyan-tantaaꞌa mimpímbá wéraiye. Seyaafá-tántááꞌá toꞌmayaa úmarekai minkáꞌá kausínkáakaiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","mindárai isésarai Yérúsaremu-naopaꞌa wésarai Ísumo sún-tantaaꞌa wérowasarai minkáꞌá tanómba kauwánkaraaye. ");
INSERT INTO auy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tanómbo náíyan-kanaa túwasa Ísuwe wení aantá-waasiye tómbó náíyapaꞌa komérowana ");
INSERT INTO auy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ísu simátimena séna kárikaꞌa síꞌo índa-iꞌa uwásinkaiyan-kanaa ímbo tiyáinaꞌa ááéma tíyótaimo í-tánómbá kembiwíséꞌa nánaumne-imayaa úmae iyáunda káféꞌa minkánáá paápé imbá póta nánaumne. ");
INSERT INTO auy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Simátime súne. Marapáꞌá maantánómbá ímba anekaꞌá nánaumpo Maníkó wení waásimo kawáánipaꞌa maantánónkóní áwáuma aforaꞌá wérainaꞌa nánaumne séna ");
INSERT INTO auy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ándá-aran-dombo wéron-anafeumba maisoréna Maníkómpá súwiyo séna maimái moórá-mora úmai naaró. ");
INSERT INTO auy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Simátime súne. Ándá-aran-domba ímba nánaumpo Maníkó wení waásimo kawáánipaꞌa méꞌa anekaꞌá nánaumne séna ");
INSERT INTO auy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","péréti maisoréna Maníkómpá súwiyo séna tafánkena tiména séna mindá kesún-ifo kembiwísáféꞌa ísámai kesú tuwánáúmne. Miyáumai kentáféꞌa imáyáa éꞌa námae íyóro súwasa ");
INSERT INTO auy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","tómbá násúwówana ándá-aran-dombo wéron-anafeumba maisoréna pérétimo timúntemba miyáumai ándá-aran-domba tiména séna mindá kesí naaén-iye kesí naaemá kembiwísáféna kumínda póna Maníkó séna keséꞌa kááísamai méraiwae séna mináú-ááí símai kááísamakaisaꞌa miyáumai kentáféꞌa imáyáa éꞌa námae íyóro. ");
INSERT INTO auy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kembá namuro-wáásímó aráátimindawi keséta ména tómbá wénaiye. ");
INSERT INTO auy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naaófáꞌá Maníkó séna waási úranko puwíníyemo siyáintemba póꞌa púwónana namuro-wáásímó aráátimindawi sáwí-meyamba máíníye Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","wení kísau-waasi keáímbá sésa nááwa miyá ínísanawa síyó siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ísuni kísau-waasi mósimesi-aai sésa kentááfínkémbá nááwa wéiyaakaiyo suwaná ");
INSERT INTO auy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ísu séna marapáꞌ-órááꞌ-wáásísómbá íyáákamai fasiꞌaén-ááí simáti-simati uwasá wenkóyááka-tayaaka ésa sésa kentáásí óraaꞌ-waasi kaweꞌá wéowe siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kembiwí miyáumaimo óraaꞌ-waasimo ontembá ímba miyán-oro. Kempínkémbá óraaꞌo ménae síyawi seyaafáꞌ-wáásítí kísau túwaꞌnai oro. Íyáákanaemo síyawi fíꞌowiti wayóꞌá maénááwe. ");
INSERT INTO auy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Marapáꞌ-wáásífínkémbá tómbó ménamo wénaiwai óraaꞌ-waasin-ifo kúfuꞌo uwámíwai káriꞌ-waasi imbánifo kemá kentí óraako ímba miyá éꞌa kentí wayókóráámbá wéune. ");
INSERT INTO auy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Miyá únaꞌa kembó sáwíꞌo uwásínkáanka keséꞌa méꞌa ímba síyukaawe. ");
INSERT INTO auy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kesifo kentáféna séna waási kawáánuwo siyáintemba kembiwísáféꞌa miyán-ááí simátimenaumne. ");
INSERT INTO auy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Waási kawáámó ondaráꞌá méꞌa tómbá wéneꞌa kawáámó ondaráꞌá méꞌa Ísarerin-áánintomba sísamaifakemba kaeꞌá kumbaimái-aanintonti minándáfákén-kwáásí-taai iséꞌa tuwínkaaꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ísu Sáímonimba arumbá uwánkena séna Sáímoniyo isaaó. Owáí toꞌmáímo tufimpí owanamó arúꞌó marapá kúmísasamo anónkaꞌo mósá máéntemba kawe-tántááꞌá mósá maéꞌa sáwí-tantaaꞌa úwoimo wéraindasafena waántáwanko tísai úmai isánae sínaꞌa ");
INSERT INTO auy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","mindásafe Maníkómpáꞌá inaí séꞌa keséꞌo kááísamaimo méraanda siyuwáánafo séꞌa inaí siyáumne. Emá siyuwé kouweré kesí waási fasiꞌátinkaao Ísu súwana ");
INSERT INTO auy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pítaa séna Fasiꞌaénkóo ándáfaꞌo áíꞌmae wíyaꞌo éꞌa keséꞌa kóyauye. Tufuwíyamo puwínaꞌo éꞌa keséꞌa puwóyauye Pítaa súwana ");
INSERT INTO auy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ísu séna Pítaao simáme súne. Káféꞌa kokórigo ímbo áái siyáindaraꞌa emá kaumbo-íkáꞌá kentáfé sé ímbo awánáúnda-waasiye sínone Ísu Pítaantafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ísu simásuwena wení kísau-waasisafena séna ááéma tiꞌmaré séꞌa óntambo inai-inaimó sí-únámbá ímba maéꞌa tón-únámbá ímba maimaé wéꞌa tísamai ánáamba ímba maimaé koró. Minááí ááéma séꞌa tiꞌmákaunda moórá-tantaatafeꞌa aáfáán-tukáanaꞌiyo súwasa miwí sésa ímbaniye suwaná ");
INSERT INTO auy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ísu séna káféꞌa óntan-unambo makáiyawi minúnámbá maimaésa koró. Tón-únámbó makáiyawi minúnámbá maimaésa koró. Paepáéꞌa ímbo makáiyawi miwítí paákákén-únánkwátói fíꞌowi timésa óntamba maiyésa paepáéꞌa méyánuresa koró. ");
INSERT INTO auy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Simátime súne. Naaófáꞌá Maníkón-aai aúfáífimba Áísáya agaimaréna séna áíꞌmaesa sáwíꞌa uráan-kwaasimo mépaꞌa móankaraawe agaimaréna siyáimba kentáfénamo siyáimba póna paápé íníye Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","wení kísau-waasi sésa Fasiꞌaénkóo kae-páépáéꞌa makáumne suwaná wemó sún-aaigoni áwáu ímba ísóntafena séna éꞌaniye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ísu simátimena máápaꞌa kuména Órífi-omapaꞌa imaéꞌmae úntemba iyúwasa wení kísau-waasi arááíwaꞌmaesa ");
INSERT INTO auy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","íyúwana Ísu simátimena séna waántáwanko tísai úmai isánae-aai kempáꞌá sifáínifo Maníkómpá inaí seró séna ");
INSERT INTO auy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","tiyuwéna ewaaꞌá wéna Maníkó óraakon-iye séna maraꞌá kumbéna inaifínkémbá ");
INSERT INTO auy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","séna kesifóo emó kanaán-iye sémo e maanúmbáí-tántááꞌó kempáꞌó tínda maisiyuwé énifo ímba kesí imáyáan-ifo ení imáyáa arááíwáéno súwana ");
INSERT INTO auy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Maníkóní kísau-waasigo wíyómpakewi paápé éna fasiꞌánkowana ");
INSERT INTO auy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","arunkó óraaꞌ-umbai tówana Maníkómpáꞌá inaí fasiꞌámai súwana umuꞌnáámba naaeráámbá marapáꞌá kumúwana ");
INSERT INTO auy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","inaí simásuwena íyáfasinena wení kísau-waasiyaufaꞌa téna tatuwánómba tirunkó umbaí tówasa tún-kwaigurówana ");
INSERT INTO auy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","tatúséna tasimátimena séna túmó wéraamba íyáfasineꞌa inaí seró. Waántáwanko tísai úmai isánae-aai kempáꞌá sifáínifo Maníkómpáꞌá inaí seró Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ísu minááí wésuwana sáwífaꞌ-waasi wétuwana Ísuni kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasifinkemba moóráwigon-awiꞌa Yúndasi misáwífáꞌ-wáásífímbá aifaꞌá téna Ísumba aaweyáámó uwánkaindasafena Ísuni ewaaꞌá téna ");
INSERT INTO auy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","aasásóíꞌá úntafena Ísu séna Yúndasiyo kemá waási úrankomba kesí namuro-wáásímó aráátímíndasafe aaweyáá uwásinkaane súwasa ");
INSERT INTO auy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ísuweꞌo mérowi moórá-tantaaꞌo paápé índa-imayaa ésa sésa Fasiꞌaénkóo paepáétanta karánaumno suwaná ");
INSERT INTO auy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ísuni kísau-waasifinkemba moóráwigo paepáéꞌa maimaéna aifaꞌ-ámáán-káwáágóní kísau-waasigon-ááꞌa fagáúsuwowana ");
INSERT INTO auy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ísu étuwaao séna minkwáásígón-áákaꞌa taꞌótorena ááꞌa kaweꞌá uwánkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kaweꞌá uwánkowasa óraaꞌ-amaan-kisau-waasiye ámáán-danka-kawaa-waasiye óraaꞌ-waasiye Ísumbo taꞌótoraiyanesa tamérowana Ísu simátimena séna kentáféꞌa umén-kwáásín-iye séꞌa póꞌa taánáínkwara paepáéꞌwaraꞌa maimaé kembá taꞌótoranae séꞌa wétewe. ");
INSERT INTO auy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sáwífa-kanaa óraaꞌ-amaan-daumpaꞌa keséꞌo méraundaraꞌa ímba kembá taꞌótokaawe. Káféꞌa kentí kanaamá isaꞌá kumeukóní fasiꞌaémbá íyáákaisaꞌa kembá taꞌótórááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Súwasa Ísumba taꞌótoꞌmaesa aifaꞌ-ámáán-káwáágóní naaúmpaꞌa móankowana Pítaa tínaaemba nénkaꞌo témomba ");
INSERT INTO auy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","mindánkóní naamaáífa iyamá agaimarésa mérowana Pítaa miwísé maraꞌá tamérowana ");
INSERT INTO auy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","iyamó wégonkaꞌa moórá-kisau-arasigo téna Pítaamba takarákéna séna minkwáásígó weséꞌo máíwain-iye súwana ");
INSERT INTO auy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pítaa séna ímbanifo kemá ímbo awánáúnda-waasin-iye súwana ");
INSERT INTO auy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","kárikaꞌa moóráwigo Pítaamba taawánéna séna wení waásifinkewi óne súwana Pítaa séna kemá ímbaniye súwana ");
INSERT INTO auy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","kárikaꞌa moóráwigo Pítaantafena óraaka séna éraiꞌa súne. Kárírifakewi éna wení kísau-waasifinkewin-iye súwana ");
INSERT INTO auy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pítaa séna emó sénda-aai ímba isáúmne súwana kokórigo áái súwana ");
INSERT INTO auy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Fasiꞌaénkó waeréna Pítaamba awánówana Pítaa Fasiꞌaénkó simámakon-aai áákaꞌ-maréna miyá siyónkaꞌa káféꞌo kokórigo ááimo ímbo siyáindaraꞌa emá kaumbo-íkáꞌá kentáfé sé ímbo awánáúnda-waasin-iye sínone siyónkaꞌa minááí áákaꞌ-maréna ");
INSERT INTO auy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","máápaꞌa kuména áfááraumai ifiꞌá taráiye. ");
INSERT INTO auy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pítaa ifiꞌá tówasa Ísunkaꞌo káráwirowi karaánááꞌa ankésa tufuwésa ");
INSERT INTO auy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","aúrampaꞌa ampantasámbá káátamakesa wétufuwesa sésa esáfé sé Maníkómó íyáfasisinkaraiwai únemo séndawi ómpo kemá nááwa tufúnái simásimiyo wésesa ");
INSERT INTO auy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","fíꞌo-fiꞌon-aai símai sáwíꞌa uwánkaraawe. ");
INSERT INTO auy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aafáúmó íyáúsunkaꞌa Yúndaa-waasiti óraaꞌ-waasiye óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé túwaandu urówasa Ísumba áíꞌmaesa íyúwasa ");
INSERT INTO auy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sésa Maníkómó íyáfasinankaraiwai Káráísitiyaꞌonai simásimiyo suwaná séna simátíménaꞌo éꞌa ímba kaweꞌ-úmai isánááwe. ");
INSERT INTO auy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Moórá-aaimo tísai onaꞌó éꞌa ímba simásimenaawe. ");
INSERT INTO auy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kemá waási úranko Maníkó fasiꞌaénkón-ayáánúrapaꞌa fasiꞌaén-áémpáꞌá iménaumne súwasa ");
INSERT INTO auy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","seyaafáꞌnánká sésa ewá séwa Maníkón-ááninko úne sénó suwaná Ísu séna éꞌa sewé súwasa ");
INSERT INTO auy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","miwí sésa wesáféna sifó minááísáféta aaifintá maenkéta fíꞌon-aaimo simánkáámba saafá únda póta ifátá tuwánáúmne siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Minááísáfésa misáwífáꞌá íyáfasinesa Ísumba áíꞌmaesa Rómu-kamani-kawaagon-awiꞌa Páíratimpaꞌa wésa ");
INSERT INTO auy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","aaí simánkesa sésa minkwáásígó Yúndaa-waasi karoꞌ-ááí simátimena miwítí imáyáa símai sáwíꞌa éna séna Rómu-kamani-aifa-kawaagomba taakisi-óntámbá ímba áméro séna wesáféna séna Yúndaa-waasiti kawáágó éꞌa Maníkómó íyáfasisinkaraiwai úne siyáiye suwaná ");
INSERT INTO auy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Páírati Ísumba áísai ena séna Yúndaa-waasiti kawáágówá ónó súwana Ísu séna éꞌa séne súwana ");
INSERT INTO auy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Páírati óraaꞌ-amaan-kisau-waasisafenawe úwoi-waasisafenawe séna minkwáásígó ímba sáwíꞌa uráisaꞌa awánáúmne súwasa ");
INSERT INTO auy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","óraaka sésa Káríri-aempaken-kwaasi tirumbá totuwéna minkákémbá Yúndiyaa-aempaꞌa taména miyá wéiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Suwaná Páírati minááí iséna séna Káríri-aempakewiyaꞌiyo súwasa ");
INSERT INTO auy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ewé mináémpákéwín-iye suwaná imáyáa éna séna Éroti mináémpákén-káwáágó káféꞌa maankáꞌá Yérúsaremu-naopaꞌa taméraifo aiꞌmáráanana wempáꞌá wínana wemá isáíníye Páírati simásuwena aiꞌmarówasa áíꞌmaesa Érotimpaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ayáátáákaꞌa Éroti Ísuntafesamo sun-ááí iséna Ísumba awánaanana ímbo awánáúnda-kisau maínaꞌa awánánae súwasa Ísumba Érotimpaꞌa kuwaná awánéna aamoí éna ");
INSERT INTO auy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","fíꞌo-fiꞌon-tantaatafena áísai úwana Ísu iséna ímba aaimó súmba úwoi mérowasa ");
INSERT INTO auy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","óraaꞌ-amaan-kisau-waasiye ámáámbo sun-kwáásíyé mésa Ísumbo simánkón-aai óraaka suwasá ");
INSERT INTO auy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Érotiye wení i-wáásíyé Ísumba símai sáwíꞌa uwánkesa karaánááꞌa ankésa óraaꞌ-waasiti unáánkwátói uwánkesa áíꞌmaesa Páíratimpaꞌa aneká kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ááéma Érotiye Páíratiye aaisambó siyááyamba pósarai minkánáá kaweꞌ-úmai méroyasa Ísumba áíꞌmaesa aneká Páíratimpaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kuwaná Páírati óraaꞌ-amaan-kisau-waasiye óraaꞌ-waasiye úwoi-waasiye táántena ");
INSERT INTO auy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","séna minkwáásí kempáꞌá téꞌa séꞌa waásiti imáyáa símai sáwíꞌa wéiye wésewe. Kentúrankaꞌa áísai únana simánkáán-aaigoni áwáu ímba wéraisaꞌa awánáúmne. ");
INSERT INTO auy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Érotiye áísai úyamba minááígóní áwáu saafá uwááekai úyana aiꞌmáráísasa áíꞌmaesa kempáꞌá tiyáawe. Tufíyanamo puwínda-iꞌa ímba uráifo ");
INSERT INTO auy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","i-wáásí senasá áwiyonkuꞌ-násúwéwaꞌa faúꞌankanaumne súwasa ");
INSERT INTO auy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yúndaa-waasi tíyótaimo í-tánón-kánáá tóso úntemba moórá-waasi táántowana Páírati minkwáásí faúꞌankowana miwífáꞌá kúwana Páírati séna Ísumba faúꞌankanae súwasa ");
INSERT INTO auy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","seyaafáꞌ-wáásí óraaka sésa ímbanifo tufíyana puwínífo Párápásimba faúꞌankaao siyáawe. ");
INSERT INTO auy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ááéma tuwímbai kámáni-waasiye tíyómba moóráwigon-awiꞌa Párápási moóráwigomba tufúwana puwúwasa ándáfaꞌa ánkarowasa sésa Párápásimba faúꞌankaao suwaná ");
INSERT INTO auy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Páírati Ísumba faúꞌankanae-imayaa éna simátimuwasanifo ");
INSERT INTO auy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","óraakaꞌ-oraaka sésa aaraa-táíyáꞌá tufíyana puwíno suwaná ");
INSERT INTO auy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Páírati anekaꞌá séna nóra-sawira uráiyo. Tufíyanamo puwínda-iꞌa ímba uráifo i-wáásí senasá áwiyonkuꞌ-násúwéwaꞌa faúꞌankanaumne súwasa ");
INSERT INTO auy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","óraaka sésa aaraa-táíyáꞌá tufíyana puwíno símae íyún-aaigo Páíratin-aaigomba íyáákowana ");
INSERT INTO auy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Páírati miwí táái iséna ewé séna kemó sentembá oro séna ");
INSERT INTO auy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","moóráwigomba faúꞌankena kámáni-waasi tíyómbo moóráwigomba tufuwúwana puwúwasa ándáfaꞌo ánkarowaimba táántowaimba Páírati faúꞌankena aaraa-táíyáꞌá tufíyana puwíníye-imayaa untáféna Ísumba i-wáásí tímakaiye. ");
INSERT INTO auy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Timúwasa i-wáásí Ísumbo áíꞌmae kumbá moóráwigo Sáíríni-naopakewin-awiꞌa Sáímoni Yérúsaremu-naoꞌ-ampaꞌa túwasa i-wáásí taꞌótoresa Ísumbo tufíyan-aaraa-tai áúwaataꞌankesa sésa Ísun-ánaaemba tiyó suwaná miyá úwasa ");
INSERT INTO auy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","sáwífaꞌ-waasi Ísumba arááíwaꞌmae wéguwasa aaresómbá tirumbá uwánkesa imá siyésa ifiꞌá támaesa arááíwaꞌmae kuwaná ");
INSERT INTO auy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ísu waeréna séna Yérúsaremu-naopaken-inintono. Ímba kesífiꞌo tembá kentí iyámpóísafeꞌe kesáfé-ífíꞌá taaró. ");
INSERT INTO auy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yérúsaremu-naopaꞌa sáwí-kanaamo tínda age-íníné ímbo iyámpóímo matinkésamo náámbo tímakaan-inine aamoí ésa iyámpóí-íyaimba póꞌa inkaiséꞌa kónaumne sésa aamoí wéowe sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Minkánáámó tínda káriꞌ-omakowe óraaꞌ-omakontafesawe sésa ááéma pukónáífo faiwíꞌmae kufaráátaao sénááwe. ");
INSERT INTO auy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kemá aú-taiyaamba únda pósa sáwíꞌa wéuwasinkaafo kembiwí aáénkaen-taiyaamba ombá pósa óraa-sawiꞌa uwátinkanaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ísu súwasa kaeꞌ-wáásí sáwíꞌo urááyan-kwaasiwaraꞌa tíꞌmaesa Ísunkwaraꞌ-úmai tínkamonae sésa tíꞌmaesa ");
INSERT INTO auy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","mimbárágón-áwíꞌa aꞌnónayaantapaꞌemo supaꞌá kurésa Ísumba aaraa-táíyáꞌá tufusésa séfasefaꞌ-arausampaꞌa kaeꞌ-wáásí aaraa-táíyáꞌá tufúsúmarowana ");
INSERT INTO auy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ísu séna kesifóo maami owíní áwáu ímba awánaresa kembá sáwíꞌo uwásínkáámba ímba imáyáa e sáwí-meyamba ímbo tímínda sáwí-imayaa maitiyuwaaó súwasa i-wáásí sésa wení unáánkwátói maénae sésa ááfé tíyáananasa nááwamo íyáákaindawi máíníye sésa miyá uwasá ");
INSERT INTO auy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","waásisomba kááꞌa karátuwesa mésa Yúndaa-oraaꞌ-waasi karaánááꞌa ankésa sésa fíꞌowi túwaꞌnai ena Maníkómó íyáfasinankaraiwaimo énamo éna wesáféna wenáú áwaꞌnai íníye suwasá ");
INSERT INTO auy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","i-wáásíyé karaánááꞌa ankésa ikamó fón-domba maimaésa wempáꞌá tésa sésa naaó. ");
INSERT INTO auy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yúndaa-waasiti kawáágómó émo e esáfé enáúma áwaꞌnai uwo suwasá ");
INSERT INTO auy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ááéma aúfái agaimakésa sésa Yúndaa-waasiti kawáágón-iye sésa agaimái Ísun-aꞌnónká-táíyáꞌá mósá makáawe. ");
INSERT INTO auy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mósá márówana sáwíꞌo uyan-kwáásímó tufúsúmaroyan-kwaasigorai moóráwigo Ísumba karaánááꞌa ankéna séna Maníkómó íyáfasinankaraiwaimo émo e enáú áwaꞌnai e kenkáíwáráꞌá súwaꞌnai uwo súwana ");
INSERT INTO auy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","moóráwigo séna ímba miyá siyó. Maníkón-áároimo inkaiséra miyá ímba sésino. Wembó sáwí-meyambo áméntemba kenkáíwáráꞌá miyá wéowe. ");
INSERT INTO auy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wemá ímba sáwíꞌo uráiwaimba sáwí-meyamba wéamefo keráí sáwíꞌo uráuyawinkai sáwí-meyamba uwásínkááwe séna ");
INSERT INTO auy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ísuntafena séna Ísuwo ení waásimo kawáá indaráꞌá ken-ímáyááwáráꞌá uwo súwana ");
INSERT INTO auy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ísu séna éraiꞌa simáme súne. Káféꞌa keséꞌa kaweꞌ-mápáꞌá iméínone Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Súwana wááwái seyaafáꞌ-áémpáꞌá túnkwéna aafáúmó taenónkaꞌa túnkúmba ");
INSERT INTO auy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","óraaꞌ-amaan-daumpaꞌa ampanta-óntámó úmakomba tafááténa kaesé uwágúwana póna Maníkómpáꞌó iyíyan-amba wiꞌmarówana ");
INSERT INTO auy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ísu óraaka séna kesifóo kesimambá enayáámpimba toꞌmaráúmne simásuwena puwúwana ");
INSERT INTO auy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","i-wáásítí kawáágó Ísumo puwúmba awánéna Maníkón-áwíꞌa mósá maréna séna éraiꞌa arupíse-waasin-iye súwasa ");
INSERT INTO auy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","sáwífaꞌ-waasi koawánanaumne sésa túwaandu urón-kwaasi Ísumo puwúmba awánésa tirunkó umbaí tówasa miwítí naaópaꞌa wété uwasá ");
INSERT INTO auy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ísuweꞌo nún-kwaasiye Káríri-aemapakemba Ísumba arááíwaꞌmaesa Yérúsaremufaꞌo tiyón-inine nénkaꞌa tamésa seyaafá-tántááꞌá awánaraawe. ");
INSERT INTO auy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Awánowana moóráwigon-awiꞌa Yósepi Yúndiyaa-marafaꞌa Árímátíyaa-naopakewi kaweꞌ-wáásí arupíse úmaimo mérowi Maníkó wení waási kawááníníye séna amuꞌmaréna póna Ísumbo tufuwónae sun-kwáásí tááisafena ímba ewé siyáiwai wemá ");
INSERT INTO auy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Páíratimpaꞌa téna Ísun-áúma utánáifo simiyó súwana ewé súwana ");
INSERT INTO auy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ísun-áúma aaraa-táíyákémbá tamaimái aú-ampantafimba asááúmaena maimaéna waásimo aúsámakon-ontan-aifimba mámarena waási ímbo makón-aifimba mámarena ");
INSERT INTO auy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","tómbó fákáꞌmaimo toꞌmayaa un-kánáá Yúndaa-waasi saagon-kánáá kárikaꞌa tíne úntafesa Ísumba utámarowasa ");
INSERT INTO auy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kárírifakembo Ísumbo arááíwaꞌmae tiyón-inimba Yósepimba arááíwaꞌmae tésa Ísumbo utámárómba taawánésa ");
INSERT INTO auy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","tauwerésa áúraꞌa máaꞌankanae sésa asaa-wiyúm-básáwémbá toꞌmayaa unkáꞌá saagon-kánáá túwana ámáámbo sunten-úmai úwoi méraawe. ");
INSERT INTO auy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saagon-kánáá úwoi mérowana taiꞌówasa aafáúmó íyáúsunkaꞌa áúraꞌa máaꞌankanae sésa asaa-wiyúm-básáwémbá toꞌmayaa úmakom-basawemba maimaésa Ísumbo utámaropaꞌa wésa ");
INSERT INTO auy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","awánomba óraaꞌ-ontamba óikakemba éꞌa fawátukowasa awánésa ");
INSERT INTO auy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","minóntán-aifaꞌo íyúmba Fasiꞌaénkó Ísun-áúma ímba wérowasa awánésa ");
INSERT INTO auy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","óraaꞌ-imayaa ésa awánomba kaeꞌ-wáásíyáí túgáyáagayaamo ún-unankwatoi urésarai ewaaꞌá méroyasa tuwánésa ");
INSERT INTO auy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","6","táátafesa ésa kífaiyowasarai sésarai púwísaꞌo máánkaraan-ontan-aifimba ímba méraifo íyáfasinena kóuraifo ímba maampímbá ayaafáí oro. Wemá Kárírifaꞌa úwoimo méronkaꞌa simátímakain-aai imáyáan-oro. ");
INSERT INTO auy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Maará siyáiye. Kembá waási úrankomba sáwí-waasi timíyasa sínkamiyaꞌa puwéꞌa kaumbo-kánáá maisuwéꞌa íyáfasinanaumne siyáiye suyasá ");
INSERT INTO auy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","isésa simátímakain-aai táákaꞌa marésa ");
INSERT INTO auy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","minóntán-aima tuwésa wésa Ísuni kísau-waasi sísamaifakemba moórá kumbaimái-waasiye fíꞌon-kwaasiye minááí kosimátimesa ");
INSERT INTO auy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","minínímbá moórá Mágátáraa-naopaken-ininkon-awiꞌa Máríyaa úwana moórá araámáó Yémísin-anówa úwana moórá Yóána úwasa miwíséꞌo méron-inimba Ísuni aantá-waasi minááí kosimátímúwasa ");
INSERT INTO auy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","isésa sésa úwoi karoꞌ-ááí sewé simásuwesa úwoi mérowananifo ");
INSERT INTO auy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pítaa íyáfasinena awaantanténa utámakon-ontan-aifimba kogífaena awánómba ampantasámbó káráꞌumae máutamankon-ampanta aantemba wérowana awánéna kouweréna mindásafena óraaꞌ-imayaa uráiye. ");
INSERT INTO auy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Minkánáá Ísuni waásifinkemba kaeꞌnárai Éméyási-naopaꞌa kóyae siyááye. Mindáópa Yérúsaremufaꞌa ayáátáákakaamba wérowasarai Éméyási-naopaꞌa kóyae sésarai Yérúsaremufaꞌa tuwésarai aampaꞌá wéwesarai ");
INSERT INTO auy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ísumbo éwiyon-aai símaesarai wéguyana ");
INSERT INTO auy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ísu ewaaꞌá téna minkáéꞌnáraiseꞌa kúwasarai ");
INSERT INTO auy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","awánoyana Maníkó túramba kumeuꞌá uwátinkowasarai ímba awíyéraaseraamba uyaná ");
INSERT INTO auy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ísu séna nóin-aaiya aampaꞌá símae wégoyo súwasarai minkáꞌá komésarai tirunkó sáwíꞌa úwasarai ");
INSERT INTO auy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","moóráwigon-awiꞌa Kíríyópási séna káfé-kanaa Yérúsaremu-naopaꞌa tóso ésa paápé uráin-tantaaꞌa awánaraafo eyáá ína awánaraano áísai ena súwana ");
INSERT INTO auy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ísu séna nóinaꞌiyo súwasarai mindárai sésarai Ísu Násaretifakewintafekai súye. Maníkón-aai siyáiwai Maníkón-aúrankaꞌa fasiꞌaén-kísáú maéna fasiꞌaén-ááí simásímísata ísaraumne. ");
INSERT INTO auy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kentáásí óraaꞌ-waasiye óraaꞌ-amaan-kisau-waasiye Ísumba tufuwíyanesa Rómu-kamani-waasigomba áméwana ewé sisasá aaraa-táíyáꞌá tufúwówana pukáiye. ");
INSERT INTO auy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kesáá Ísareri-waasisa séta kentáásí kawáá-íꞌa éna Rómu-kamani-waasi íyáákainiye siyáundasa tufúwówana pukáiye. Moórá-aaiwaraꞌa wéraiye. Tufúwówana pukáimba kaumbo-kánáá maisukáiye. ");
INSERT INTO auy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tuwímbai-inimbo simásímén-aaisa sáátafeta úne. Káféꞌ-aafayaaraꞌa ááéma utaráapaꞌo kombá ");
INSERT INTO auy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wenáú ímba wéraisasa koawánésa kouweré tésa sésa wíyómpakendarai tuwánáúnasarai sésarai pukáimpinkemba íyáfasinkaiye séye tasewatá ");
INSERT INTO auy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","kentááfínkémbá tuwímbai utámakaapa koawánaawana minínímbó sentembá miyá éna ímba wéraisasa awánaawe suyaná ");
INSERT INTO auy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ísu séna sáwí-imayaawaraꞌa óye. Naaófáꞌá Maníkón-aaimo simátímakaawi agaimarésa siyáan-aaisafekai ímba ááéma éraiꞌe séye. ");
INSERT INTO auy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Maníkó íyáfasinankaraiwaimba áíꞌo índa-iꞌa uwánkaiyambanifo sámo kain-áémpáꞌá iméíniye miyám-biyan-aai Maníkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Maníkón-aai aúfáífinkemba wentáfésa siyáan-aaigoni áwáu simátímakaiye. Minááí Mósese agaimaréna siyáin-aaiwara minkákémbá Maníkón-aaimo siyón-kwaasi agaimarésa siyáan-aaiwaraꞌa simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Simátimuwasarai kuyan-dáókoni ewaaꞌá kuyaná Ísu kóyáákowasarai ");
INSERT INTO auy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mindárai taꞌótoresarai óraaka sésarai kumeupá nóꞌwaamban-ifo kesékai méraao suyaná mindáraiseꞌa naaúmpaꞌa iména ");
INSERT INTO auy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","tómbá náíyanesa uwaná tómbá maisoréna Maníkómpá súwi séna tafámbai timúwasarai ");
INSERT INTO auy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","awánésarai Ísumba awíyéraase uyaná áwiyokuwasarai ");
INSERT INTO auy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","sésarai aampaꞌó túyanamo Maníkón-aai aúfáífinkemba simásímísanarai sirunkó óraaꞌ-aamoin-iye siyááye. ");
INSERT INTO auy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Minááí simásuwesarai íyáfasinesarai kouwerésarai Yérúsaremu-naopaꞌo tuyambá Ísuni kísau-waasi sísamaifakemba moórá kumbaimái-waasiye fíꞌon-kwaasiye túwaandu urómba tuwánoyasa ");
INSERT INTO auy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","miwí sésa éraiꞌa Fasiꞌaénkó pukáimpinkemba íyáfasinena Sáímonimpaꞌa paápé isaná awánaraiye suwasaráí ");
INSERT INTO auy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","mindárai aampaꞌó kuyan-ááí simátimesarai sésarai tómbá tafámbai símísakai Fasiꞌaénkómbá awíyéraase uráuye siyááye. ");
INSERT INTO auy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Minááí suyaná Ísu paápé éna miwítí afufumpimbá ména aáno úmai méraaro súwasa ");
INSERT INTO auy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","inkaisésa waántá sewé sésa táátafesa uwaná ");
INSERT INTO auy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ísu séna ímba tááꞌa íno. Ímba kaeꞌ-ímáyáámó íyamba ");
INSERT INTO auy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","siyáánarumpin-afiye sísamaifin-afiye awánéꞌa kentáféꞌa wén-iye seró. Waántá-waasi amaꞌwárá ayáántánkwaraꞌa ímba wéraifo kembá úwoi wéraifo suwánéꞌa sineꞌá taꞌótóráaro ");
INSERT INTO auy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ísu simásuwena ayáánarumpin-afiye aísamaifin-afiye aráátimuwasa ");
INSERT INTO auy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","óraaꞌ-aamoi ésa táátafesa ésa óraaꞌ-imayaa uwaná waántán-iye sefó séna Ísu náíyan-tomba makáao tísai ena súwasa ");
INSERT INTO auy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","agaimakóm-bofaaꞌa ámúwana ");
INSERT INTO auy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","maimái túrankaꞌa naráiye. ");
INSERT INTO auy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Násuwena simátimena séna keséꞌo úwoimo maéwándaraꞌa maará siyáumne. Kentáféna Mósese agaimaréna siyáin-aaiye Maníkón-aaimo siyón-kwaasi agaimarésa siyáan-aaiye imá agaimarésa siyáan-aaiye éraiꞌa paápé íníye simátímakaumne. ");
INSERT INTO auy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Maníkón-aai aúfáífinkemba kaweꞌ-úmaimo isáíyantafena miwítí imáyáa kaweꞌá uwátínkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Maníkón-aai aúfáífimba agaimaréna séna Maníkómó íyáfasinankaraiwaimba áíꞌo índa-iꞌa uwánkaiyana puwíndanifo kaumbo-kánáá maisuwéna íyáfasinainasa ");
INSERT INTO auy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","wení fasiꞌaénkwáráꞌá mésa aifaꞌá Yérúsaremu-naopaꞌa simátimesa minkákémbá fíꞌo-fiꞌom-barafaken-kwaasi mósimatim-besimatin-esa sésa kentí sáwí-imayaa tuwéꞌa Maníkómpá tíyana kentí sáwí-imayaa maitiyuwáíníye agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Awánaan-aai simátímaꞌmae koró. ");
INSERT INTO auy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kesifo óraakaꞌa séna tíméndawimba aiꞌmáráanana kembiwíséꞌa kumbéíniye. Yérúsaremu-naopaꞌa méraiyana kempímbá kumbéna wíyómpake-fasiꞌaemba timínaꞌa awánaan-aai simátímaꞌmae koró Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Simásuwena Ísu tíꞌmaena Yérúsaremufaꞌa tuwéna Pétáni-naoꞌ-ewaaꞌa koména ayáántamba aasumíꞌa uwátínkaraiye. ");
INSERT INTO auy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Uwátinkowana Maníkó aiyówana wíyómpaꞌa iyúwasa ");
INSERT INTO auy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ísun-imayaa ésa áwíꞌa mósá marésa tirunkó óraaꞌ-aamoi úwasa kouwerésa Yérúsaremu-naopaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","aasiyaasi-kánáá óraaꞌ-amaan-daumpaꞌa iyésa Maníkón-áwíꞌa mósá makáawe. Rúku kemó súnda-aai taíꞌáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Áwáuraꞌa maramá ímbo wéronkaꞌa Maníkóní imáyáama aráátímíwaima wenáwíꞌa Maníkón-aaigon-iye. Maníkón-aaigo aasiyaasí ména Maníkóe ména wemá Maníkó póna ");
INSERT INTO auy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","áwáuraꞌa Maníkón-aaigo Maníkóe ména ");
INSERT INTO auy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","seyaafá-tántááꞌá úmarowana Maníkó imáyáa amúwana seyaafá-tántááꞌá minkánáá paápé uráin-tantaaꞌa úmakaiye. ");
INSERT INTO auy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Maníkón-aaigo waásimo maéꞌmaeꞌo íyawini áwáuman-iye. Miyáumai wemá waásifimba sáma kátinkena ");
INSERT INTO auy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","kumeuꞌó in-áémpáꞌá sáma kaisaná kumeuꞌó í-tántáákómá sámo kain-tántáákómbá ímba íyáákena kumeuꞌá uwánkaraiye. ");
INSERT INTO auy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Moóráwigon-awiꞌa Yóni mérowana Maníkó aiꞌmaréna ");
INSERT INTO auy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","sámo kain-ááí maimaé seyaafáꞌ-wáásífáꞌá winasá minááí isésa sésa éraiꞌa Ísu Káráísitima waási sáma kátínkáíwain-iye síwae súwana ");
INSERT INTO auy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yóni wemá ímba sámo kátínkáíwai póna sámo kátinkaindawin-aai maimaéna kuráiye. ");
INSERT INTO auy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Maníkón-aaigoma seyaafáꞌ-wáásífímbá sáma kátínkáíwain-iye. Yóni simátímakonkaꞌa Maníkón-aaigo marapáꞌ-wáásífímbá kumpaápé uráiye. ");
INSERT INTO auy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Maníkón-aaigo maramá úmakena marapáꞌá kumbérowasa marapáꞌ-wáásí wení áwáuma ímba kaweꞌ-úmai awánaraawe. ");
INSERT INTO auy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wenamáápaꞌa kumbérowasa wenamááraa ímba aaweyáá uwánkówasa ");
INSERT INTO auy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","tuwímbai aaweyáá uwánkesa wenááisafesa timankúnkúmba ésa Maníkómpákémbá kunkáiye suwaná póna miwísáféna séna Maníkóní iyámpóísomban-owe siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Waási kentí imáyáafinkeniꞌa úmai wématinkaafo Maníkóní iyámpói ímba miyáumai Maníkóní iyámpóíyaaniꞌa wéowe. Maníkó wení imáyáafinkembo uwátínkáímba pósa Maníkóní iyámpóíyaaniꞌa wéowe. ");
INSERT INTO auy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Maníkón-aaigo waási úkéna marapáꞌá ména kentááfímbá mérowata awánaraumne. Farumó í-tántááꞌwárá arupísemo í-tántááꞌwáráꞌá wempímbá sáwífaꞌa wéron-kwaasi póna sámo kainkwáráꞌ-wáásí úwata awánaraumne. Afowámá ááninkomba kímborawigomba póna sáma amúwana misáwáráꞌá mérowata awánaraumne. ");
INSERT INTO auy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yóni wentáféna seyaafáꞌ-wáásí simátimena séna kembá ímbo masínkaronkaꞌa kesínaaembo tíndawi wenónkáámbá paápé uréna ména póna kembá íyáákaraiye siyáunda-aai minkwáásísáféꞌa siyáumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Farumó í-tántááꞌá wempímbá sáwífaꞌo wéraiwai póna kentáá kaweꞌá wéuwasinkamaena wéwiye. ");
INSERT INTO auy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Naaófáꞌá Maníkó Mósesemba aiꞌmaréna séna kesí ámáámba simátimiyo siyéna ánaaemba Ísu Káráísitimba aiꞌmaréna séna farumó í-tántááꞌé arupísemo í-tántááꞌé mútimiyo siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Naaófáꞌ-naofaꞌe káféꞌe marapáꞌ-wáásí Maníkón-aneꞌá ímba awánaraambanifo kímborawigo ááninkoma weséꞌa ména mimbóráíꞌa úmai ména póna kentáá wéaraasimiye. ");
INSERT INTO auy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yérúsaremu-naopakemba Yúndaa-kawaa-waasi ámáán-kisau-waasiye Rífáin-andafaken-kwaasiye tiꞌmárówasa Yónimpaꞌa tésa áísai esa sésa emá nááwaꞌono suwaná ");
INSERT INTO auy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yóni ímba umémpaꞌa tuwómba aforaꞌá séna Maníkómó íyáfasinankaraiwai Káráísiti ímba kemá úne súwasa ");
INSERT INTO auy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","sésa emá nááwaꞌo. Íráiyaa naaófáꞌá Maníkón-aaimo simátímakaiwaiyaꞌono suwaná Yóni séna ímbaniye súwasa miwí sésa naaófáꞌá Maníkó séna kesáái simátimindawi Móseseraan-kwaasi aiꞌmáráanana kumíníyemo siyáimba wemá ewáꞌónó suwaná Yóni séna ímbaniye súwasa ");
INSERT INTO auy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","miwí sésa nááwaꞌono simásimiyo. Simásímínda-aai siꞌmákaawisa kosimátimeno suwaná ");
INSERT INTO auy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yóni simátimena séna Maníkón-aai simátímakowin-awiꞌa Áísáya naaófáꞌá agaimaréna séna máásai-marafaꞌa moóráwigo ména aaemáíyakemba séna Fasiꞌaénkóní aambá wiꞌankáíyamba wení aambá arupíse íyana minámpáꞌá wíno siyáimba mindá kemá úne Yóni súwasa ");
INSERT INTO auy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","taáísai-un-kwaasifinkemba tuwímbai ámáán-kawaa-waasi miwí ");
INSERT INTO auy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yónimba áísai esa sésa emó sémo Maníkómó íyáfasinankaiwai ímba kemá úne. Ímba kemá Íráiyaa úne. Maníkón-aaimo simátimindawi Móseseraan-kwaasi ímba kemá úne. Emó siyáandanifo nóintafewa nombá wémaitinkaano suwaná ");
INSERT INTO auy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yóni séna kemá non-aantemba wémaitinkaunana kentí afufumpimbó moóráwigomo méraimba ímba wéawanaamba póna ");
INSERT INTO auy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ánaaembo kesínaaenkaꞌo tíndawi wemó aaimó síndaraꞌo kemó sendá sáwíꞌan-iye. Wení kísaumo wémaundasafeꞌa kemá úwoi-waasi úne Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yóndani-nonkoni menáípáꞌá Pétáni-naopaꞌa Yóni nombá wémaitinkowasa áísai uwaná Yóni minááí simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Simátimena aafáyáaraamba Ísumo túmba Yóni awánéna simátimena séna kentí sáwí-imayaasafesa ísámai sipisípi-araaꞌo tufúꞌmaimo Maníkómbó áméntemba wétin-kwaasi seyaafáꞌ-wáásítí sáwí-imayaasafena ísámai maitiyuwáíndasafena póna puwíníye. Mindásafena Maníkó aiꞌmáráísana kúmímba póna puwíníye. ");
INSERT INTO auy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kembá ímbo masínkaronkaꞌa kesínaaembo tíndawi wendónkáámbá ména kembá íyáákaraiyemo siyáunda-aai minkwáásísáféꞌa siyáumne. ");
INSERT INTO auy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Maníkómó íyáfasinankaiwain-aai iséꞌa nááwantafesawa séo siyáunda isaꞌá nombá wémaitinkaunda pósa Ísareri-waasi wembá kaweꞌ-úmai awánánááwe Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Yóni awánaron-aai simátimena séna Maníkómó íyáfasinankaraiwaintafeꞌa séꞌa nááwaꞌiyomo siyáunda wíyómpakemba Maníkóní ámútanko mááufuꞌ-numagoraamba úmaena wenaneꞌá kumbéraisaꞌa awánéꞌa sáákaꞌa makáunda póna Maníkó siꞌmákaiwai séna nombá wémaitinkenana kesí ámútanko moórá-waasigon-aneꞌá kumbaína emá awáné sé Ufaen-ámútánkó tirumpimbá óraaꞌo uwátinkaindawin-iye siyáin-aai sáákaꞌo makáundaraꞌa póna miyámó imbá awánéꞌa simátimeꞌa súne. Wemá Maníkón-ááninkon-iye Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Simátimena aafáyáaraamba Yóniye wení kísau-waasiyaiye méresa ");
INSERT INTO auy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ísumo kúmba awánésa uwaná Yóni séna minkwáásí Maníkó aiꞌmákain-kwaasi póna seyaafáꞌ-wáásítí sáwí-imayaasafena ísámai puwíníye. Kentí sáwí-imayaasafesa ísámai sipisípi-araaꞌo tufúꞌmaimo Maníkómbó áméntemba seyaafáꞌ-wáásítí sáwí-imayaasafena ísámai puwíníye súwasarai ");
INSERT INTO auy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","mindárai isésarai Ísun-ánaaemba arááíwáúyana ");
INSERT INTO auy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ísu faéꞌmai métuwanena séna nóintafekaiyaꞌoyo súwasarai miwí tááifinkemba sésarai Raapaiyo nááfara méraano waéꞌmai sésarai óraakoo nááfara méraano suyaná ");
INSERT INTO auy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ísu séna taawánaakaiyo súwasarai weséꞌa kuyambá mindáúmpáꞌá koméresa aafáúmó taenónkaꞌa koméraawe. ");
INSERT INTO auy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yónimo siyáin-aai iséna Ísumbo arááíwakon-kwaasi moóráwigon-awiꞌa Énduru wemá Sáímoni Pítaan-áfáko ");
INSERT INTO auy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","aifaꞌá awaaó ayaafáí úmai awánéna séna Maníkómó íyáfasinankaraiwai Mésíyaa méraisaꞌa awánaraumne siyáiye. Mésíyaawe-awiꞌa waéꞌmai Kíríki-waasi-taaifinkemba Káráísitiye sembá mináwíkóní áwáuma Maníkómó íyáfasinankaraiwain-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sáímonimba áíꞌmaena Ísumpaꞌa tuyaná Ísu awánéna séna Yónin-ááninko óne. Enáwíꞌa Sáímoniye. Moórá-awiꞌa Pítaawe simánkaumne Ísu siyáiye. Miwí tááifinkemba Pítaawemo sembá óraaꞌ-ontankowe wésewe. ");
INSERT INTO auy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aafáyáaraamba Ísu séna Káríri-aempaꞌa kónae séna Fírípimba ayaafáí úmai awánéna séna kembá sirááíwauwo siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Wemá Pétésáítafakemba Éndurunte Pítaanteti naaópaken-kwaasin-iye. ");
INSERT INTO auy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fírípi Nátániyerimba ayaafáí éna séna Mósese Maníkón-aai aúfáífimba agaimarówasa Maníkón-aai simátímakowiye aúfáífimba agaimarésamo siyáan-kwaasigonta awánaraumne. Wemá Násareti-naopakemba Yósepin-ááninkon-awiꞌa Ísun-iye súwana ");
INSERT INTO auy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nátániyeri séna kesáámó súndasa Násareti-naopakemba ímba kaweꞌ-wáásín-iye wésune súwana Fírípi séna taawánaao súwasarai ");
INSERT INTO auy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","kuyambá Ísu Nátániyerimba awánéna séna maandá éraiꞌa Ísareri-waasigo éna ímbo karoꞌ-ímáyáámó wéraiwai wétiye súwana ");
INSERT INTO auy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nátániyeri áísai ena séna nóra úmaiya kesí imáyáa suwánéwa sénó súwana Ísu séna Fírípi ímbo áántarainkaꞌa ení naaópaꞌa piyáí-áwáuraꞌa méraanaꞌa kesí imáyáafinkemba awánaraumne súwana ");
INSERT INTO auy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nátániyeri séna óraakoo emá Maníkón-ááninko e Ísareri-waasi kentáásí kawáágó óne súwana ");
INSERT INTO auy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ísu séna piyáí-áwáuraꞌa méraanaꞌa kesí imáyáafinkemba awánaraumne súndasafe kentáfé sé éraiꞌe Maníkón-ááninko óne wésene. Ení naaópaꞌa méraanaꞌa imáyáafinkembo awánaraundasafe sénda po mintántáákómbó íyáákainda-tantaaꞌa ánaaemba awánáínone. ");
INSERT INTO auy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Éraiꞌa simátimeꞌa súne. Wíyómpaꞌa kampúaran-tawaai tuwínkaaꞌa ínasa wíyómpakemba waási úranko kumpaápé uráundawifaꞌa wíyómpaken-kisau-waasi iyé-kunke íyaꞌa tuwánánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Aúnkáraamba Káríri-aempaꞌa Kéna-naopaꞌa túwaandu urésa aaré wétoꞌwaai-esa Ísun-anówa komérowasa ");
INSERT INTO auy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ísune wení kísau-waasiye táántowasa komérowasa ");
INSERT INTO auy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ándá-aran-domba nowaná taiꞌówana Ísun-anówa Ísuntafena séna ándá-aran-domba taíꞌáiye súwana ");
INSERT INTO auy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ísu séna kesí kísausafe ímba simásimiyo. Seyaafáꞌnánkáꞌó kesí áwáumo suwánáíyan-kanaa ímba tiyáiye súwana ");
INSERT INTO auy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ísun-anówa kísau-waasisafena séna simátimindantemban-oro siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yúndaa-waasi tiyáámbo non-kwíyúmba mindásafena afaꞌmóráe óraa-sawema wérowana ");
INSERT INTO auy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ísu kísau-waasisafena séna misáwéfímbá nombá fatímai ówitaaro súwasa fatímai ówitamarowana ");
INSERT INTO auy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ísu séna tuwímbai-nomba umaéꞌa tónkáꞌó káráwiyaiwaimba mááméro súwasa miyá uwaná ");
INSERT INTO auy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","mindómbá ándá-aran-domba urówana tónkáꞌó káráwiyowi néna séna nááfaken-donaꞌiyomo súmba kísau-waasi Ísun-aai isésa awánaraawe. Nááfaken-donaꞌiyo séna aaremó maún-kwaasigomba áántowana túwana séna ");
INSERT INTO auy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","seyaafáꞌ-wáásí aifaꞌá kaweꞌ-ándá-árán-dómbá tíméwasa násúwááwasa úwoi-anda-aran-domba wétimewe. Emá ímba miyá óndarakemba ánaaemba kaweꞌ-ándá-árán-dómbá wésimene siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Káríri-aempaꞌa Kéna-naopaꞌa Ísu minkísáú-wááméꞌá úmba wení fasiꞌaémbá aráátimuwasa wení kísau-waasi awánésa timankúnkúmba ésa sésa Maníkómpákémbá kunkáiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Minkákémbá Ísuwe anówawe mináfáráwáínóndaawe wení kísau-waasiye miyáumai-waasi Kápaneamu-naopaꞌa kárikaꞌa kumbéraawe. ");
INSERT INTO auy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Naaófáꞌó Maníkó Yúndaa-waasi tíyótaimo í-tánón-kánáá tóso ún-kanaama ampáámbá wéunkaꞌa Ísu Yérúsaremu-naopaꞌa wéna ");
INSERT INTO auy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","óraaꞌ-amaan-daumpaꞌa iyúmba mifáꞌá waásisomba mésa Maníkómbó amíyantafesa purumakawé sipisípiye mááufuꞌ-numawe wémeyambaresa ámáán-dankoni óntamba wémeyanesa mérowana Ísu tuwánéna ");
INSERT INTO auy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ándásamba ufántuwena mindásamba purumakawé sipisípiye tusú uwásuwena ámáán-dankoni óntambo méyámbárón-kwaasiti taaremá tawísísuwena ");
INSERT INTO auy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","mááufuꞌ-numamo méyámbárón-kwaasisafena séna maimaéꞌa kóro. Kesifoní naaúmpaꞌa ímba maaketí márémba maimaéꞌa kóro Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","wení kísau-waasi awánésa sésa naaófáꞌá Maníkón-aai aúfáífimba agaimaréna séna Maníkóo ení naambá sáwíꞌa ofó séꞌa óraaꞌ-imayaa wéune agaimaréna siyónkaꞌa pósa minááí wení kísau-waasi táákaꞌa makáawe. ");
INSERT INTO auy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yúndaa-kawaa-waasi Ísuntafesa sésa nóin-kwaamera inatááwá awánéta séta Maníkó fasiꞌaémbá ámakaintafema óraaꞌ-amaan-daumpaꞌa miyá ónesa sénaumne suwaná ");
INSERT INTO auy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ísu séna maanámáán-dámbá tawísísuwewaꞌa kaumbo-kánááráꞌá úmaranaumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","sésa maanámáán-dámbá ayáátáákaꞌa 46 aatai maisuwésa úmakaan-damba isamá emá sé kaumbo-kánáá úmaranaumne wésene sumbánifo ");
INSERT INTO auy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","mindá ámáán-dantafenamo siyáimba wení áúsafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ánaaemba pukáimpinkemba Maníkó Ísumba íyáfasinankonkaꞌa wení kísau-waasi minááí táákaꞌa marésa sésa Ísu siyáin-aai éraiꞌ-aai siyáimbaniye sésa Maníkón-aai aúfáífinken-aai éraiꞌ-aain-iye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Naaófáꞌó Maníkómó Yúndaa-waasi tíyótaimo í-tánón-kánááráꞌá Yérúsaremufaꞌa Ísu fíꞌo-fiꞌon-kisau kawe-kísáú maúwasa waásisomba awánésa Ísuntafesa sésa éraiꞌa Maníkómpákémbá kunkáiye sumbánifo ");
INSERT INTO auy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ísu waási tirumpimbá awánéna séna minááí kentáfésa ímba tirumpinkémbá wésefo tuwesaraí kembá uwásinkanaawe séna ");
INSERT INTO auy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","waási ímba simámun-aaifinkenban-ifo wemá waási tirumpimbá awánarontafena Ísu minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Moóráwigo ámáán-kawaa-waasi Yúndaa-waasiti kawáágón-áwíꞌa Níkótímási ");
INSERT INTO auy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","moórá-noꞌwaamba Ísumpaꞌa téna séna óraakoo Maníkón-aai simásímíndasafena embá aiꞌmáráísama taméraanata awánaraumne. Maníkómó embó fasiꞌaémbó ímbo ámakainkakaa fíꞌo-fiꞌon-kawe-kisau ímba kanaaꞌá maésino súwana ");
INSERT INTO auy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ísu séna éraiꞌa simámeꞌa súne. Ímbo anekaꞌó aúraan-úmaimo matinkáíyawimo ésa Maníkóní nombara ímba maénááwe súwana ");
INSERT INTO auy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Níkótímási séna óraaꞌa uwáguraafo nóraumaiya aúíꞌa ónaao séna tinóisai tirumpimbá ímba aneká komaíyasa matinkánááwe súwana ");
INSERT INTO auy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Ísu séna éraiꞌa simámeꞌa súne. Waásimo matínkáámba mindá waásin-ofo Maníkóní ámútankomo uwátínkáímba mindá Maníkóní ámútankowaraꞌa aúíꞌa wéowe. Ímbo nonkwárá Maníkóní ámútankowaraꞌo aúraaniꞌo úmaimo méraiyaniꞌo uwátínkááwi Maníkómó kawáánipaꞌa ímba méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Anekaꞌá aúraan-úmai matinkáíníyemo súnda-aaisafena ímba ááꞌa íno. ");
INSERT INTO auy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Maarán-ááí imáyáan-uwo. Fiyúndágo wení imáyáafinkemba wéwisasa aneꞌá ímba wéawanesa sésa nááfakena nááfara wéwiyo wésewe. Miyámó intembá Maníkóní ámútanko miyáráán-úmai waási wéuwatinkaiye súwana ");
INSERT INTO auy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Níkótímási séna nóra énawa miyá íníyo súwana ");
INSERT INTO auy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ísu séna Ísareri-waasifimba aaí wésimatimendawi óndanifo minááí ímba isááne. ");
INSERT INTO auy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Éraiꞌa simámeꞌa súne. Kesáámó awánaraunda-tantaaꞌe ísaraunda-tantaatafeta wésimatimunda isaꞌá ímba wéisaawe. ");
INSERT INTO auy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Miyá wéon-tantaaꞌe marapáꞌó wéon-tantaatafeꞌo wésimamunda ímba éraiꞌe séndanifo wíyómpaken-tantaatafeꞌo simáméndamo e nóra séwa éraiꞌe sínono. ");
INSERT INTO auy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ímba wíyómpaꞌa iyésa kunkáafo keyáá wíyómpakemba kunkéꞌa kumpaápé uráundawi wíyómpaken-tantaaꞌa kanaaꞌá aráátimune. ");
INSERT INTO auy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Naaófáꞌá Mósese óntamba iyaankafayaambá úmai taaiyaꞌó mósá marówasa puwónaesamo un-kwáásí awánésa ímba pukáawe. Miyámó uráintemba kembá waási úranko kumpaápé uráundawimba sínkambai aaraa-táíyáꞌá mósá maráíyamba pósa ");
INSERT INTO auy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kesááisafesamo timankúnkúmbo íyawimo ésa aúíꞌa úmai aasiyaasí maéꞌmaeꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Maníkó marapáꞌó méraan-kwaasisafena áfááraumai aruntaféna éna póna wenáánimba kímborawigomba aiꞌmarówana kunkáimba pósa wenááisafesamo timankúnkúmbo íyawi waásimo méraawini áwáuma Maníkóní némpaꞌa ímba maéꞌmaeꞌa ónááfo wení ewaaꞌá aúíꞌa úmai maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Marapáꞌ-wáásí aaifimbá maitinkaaó séna Maníkó ááninkomba ímba aiꞌmarówana kunkáifo marapáꞌ-wáásí sáwí-imayaafimbo méraawi kuntíꞌmai kaweꞌ-ámpáꞌá métinkaao séna Maníkó ááninkomba aiꞌmarówana kunkáiye. ");
INSERT INTO auy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Maníkó ááninkon-aaisafesa timankúnkúmbo íyawi ímba aaifimbá maitinkáínífo ímbo timankúnkúmbo íyawi éꞌa aaifimbá maitínkaraiye. Maníkóní kímbora-aaninkon-aaisafesa ímbo timankúnkúmbo wéiyawisafena éꞌa aaifimbá maitínkaraiye. ");
INSERT INTO auy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sámo kátínkáíwai marapáꞌá kunkáimbanifo waási sáwíꞌa wéesa pósa kumeuꞌó in-áémpátáfésa imáyáa ésa sámo kátínkáíwaifaꞌo ímbo tentáféna aaifimbá maitinkáíníye. ");
INSERT INTO auy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sáwíꞌo wéowi sámo kátínkáíwaintafesa ímba wétinkaisasa kesí kísau paápé ifo sésa ímba sámo kátínkáíwaifaꞌa tawémaewe. Sáwíꞌo owí miyá wéofo ");
INSERT INTO auy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","arupísemo owí sámo kátínkáíwaifaꞌa taméraamba pósa Maníkómó sintembó ombá wétuwanaawe. ");
INSERT INTO auy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Minkákémbá Yúndiyaa-aempaꞌa Ísuwe wení kísau-waasiye komésa nombá wémaitinkowana ");
INSERT INTO auy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","minkánááráꞌá Yónimba ándáfaꞌa ímba máánkaronkaꞌa Ínóni-aempaꞌa Sérími-naokoni ewaaꞌ-nónaumpaꞌa Yóni ména sáwífaꞌ-nomba wéropaꞌa mérowasa waásisomba tóso uwaná Yóni nombá wémaitinkowasa ");
INSERT INTO auy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yónini kísau-waasisonte moórá Yúndaa-waasigo-iyaise mésa nombó maitínkón-aaisafesa wesimán-kwesiman-esa ");
INSERT INTO auy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yónini kísau-waasisomba wembá tasimámesa sésa óraakoo Yóndani-nonkoni menáípáꞌó eséꞌo máíwaimba wenáwíꞌo mósá maráándawimba wemá nombá wémaitinkaisasa sáwífaꞌ-waasi wétoso owe suwaná ");
INSERT INTO auy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yóni séna Maníkómó tímísasamo ombá mindá miwínén-iye. ");
INSERT INTO auy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kemó siyáunda Maníkómó íyáfasinankaraiwai ímba kemá úmpo siꞌmarówaꞌa wení aifaꞌá tiyáumnemo siyáunda-aai ísaraawe. ");
INSERT INTO auy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Maarán-ááí imáyáan-oro. Aú-ininkomo awaaikómpáꞌó tisanamá awaaikó amááraasombo aamoimó onten-úmai Ísumpaꞌa tewaꞌá aamoí wéune. ");
INSERT INTO auy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wemá óraaꞌ-waasi imbá póna wenáwíko íyáákainifo kemá káriꞌ-waasi únda póna kesúwíko kumíníye Yóni siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wíyómpakewi seyaafáꞌnánká íyáákaraiye. Maankákén-kwáásí marapáꞌ-wáásí pósa marapáꞌó wéon-tantaatafesa wésefo wíyómpaken-kwaasi íyáákarain-kwaasi póna ");
INSERT INTO auy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","awánarain-tantaa ísarain-tantaatafena sisasá ímba ísáámbanifo ");
INSERT INTO auy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","wenááisafesa éraiꞌe sewí sésa Maníkó éraiꞌ-aaigoni áwáun-iye sisasá tuwánésa sésa Maníkó éraiꞌ-aaigoni áwáun-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Maníkó aiꞌmákaiwaimba wení ámútamba ámakaimba póna Maníkón-aai wésisasa minááísáfésamo éraiꞌemo sewí sésa Maníkó éraiꞌ-aaigoni áwáun-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Maníkó afowámá éna ááninkomba arumbá aména séna seyaafá-tántááꞌá kawáánúmai káráwiyuwo siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ááninkon-aaisafesamo timankúnkúmbo ésamo weséꞌo kááísamaimo méraiyawi aúíꞌa úmai maéꞌmaeꞌa ónááfo wenááimo ímbo ísámaimo kaweꞌó íyawi ímba aúíꞌa úmai mérewana Maníkóní áyánko miwíséꞌa aasiyaasí waéꞌwaeꞌa isasá méraawe. ");
INSERT INTO auy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Yóni nombó maitínkáín-kwaasi Ísumo maitínkáíwai kóyáákaraiye. Énifo Ísu ímba maitínkaraifo wení kísau-waasi maitínkaraawe. Yónimo maitínkáín-kwaasi Ísumo maitínkáímba kóyáákamai-waasi maitínkáín-aai ámáán-kawaa-waasimo ísón-aai Ísu iséna Yúndiyaa-aempaꞌa tuwéna anekaꞌá Káríri-aempaꞌa kónae séna ");
INSERT INTO auy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sámériyaa-ampaꞌa kónae séna ");
INSERT INTO auy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","kúmba Sámériyaa-aempaꞌa Sáíkaa-naopaꞌa naaófáꞌó Yékopumo ááninko Yósepimbo ámakom-barama ewaaꞌá wéron-daopaꞌa kúmba ");
INSERT INTO auy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yékopu nombó uwínenamo uꞌmakóm-baiꞌa wérowana aampaꞌá kúwana Ísumba awesaraí úwana mimbáíkáꞌá wááwái komérowasa ");
INSERT INTO auy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","wení kísau-waasi tómbá méyánónae sésa naaópaꞌa kuwaná Sámériyaa-ininko nombá uwínena túwana Ísu séna nombá usimiyó súwana ");
INSERT INTO auy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","minínínkó séna emá Yúndaa-waasi ómpo kemá Sámériyaa-inimba úmpo ímba nombá usimiyó siyó siyáiye. Yúndaa-waasiye Sámériyaa-waasiye ímba moórá-anafinkemba wénaafo ímba nombá usimiyó siyó súwana ");
INSERT INTO auy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ísu séna Maníkómó kanaán-úmaimo amínda-tantaaꞌa ímba awánaraane. Nombá usimiyómó súnda-waasigosi áwáuma ímba suwánáánda-waasi úne. Kesí áwáumo suwánáándawiyaantasi aasiyaasimó maéꞌmaeꞌo on-dómbá simiyó sénaꞌa amúsino súwana ");
INSERT INTO auy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","minínínkó séna maandómbá káúnkáúmpáꞌó kunkwéraimba náán-anafina aasiyaasimó maéꞌmaeꞌo on-dómbá uwínono. ");
INSERT INTO auy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kentáá síwáꞌnágo Yékopu maandóm-báíꞌá uꞌmaréna wení sipisípiye wení akúntéꞌo tímakaimba isasá maandómbá wénaawe. Kemó súnda emá tímínda-nonko Yékopumo tímakain-donkomba ímba íyáákainiye wésune súwana ");
INSERT INTO auy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ísu séna maandómbó wénaiyawimo éna anekaꞌá nontáféna tinkáínífo ");
INSERT INTO auy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kemó tíménda-nombo náíyawimo éna ímba anekaꞌá nontáféna tinkáíníye. Kemó tíménda-nombo náíyawimo éna tirumpimbá nonaumpinkémbó íyáúsenamo intenkáámbá ínasa pósa aúíꞌa úmai maéꞌmaeꞌa ónááwe súwana ");
INSERT INTO auy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","minínínkó séna emó sénda-nomba símínaꞌa naananá nontáféna ímba sinkáínaꞌa ímba maampínkémbá tauwóno súwana ");
INSERT INTO auy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ísu séna enawaaikómbá koáántamae tiyó súwana ");
INSERT INTO auy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","séna kesuwaaiꞌíyaimba úne súwana Ísu séna emá éraiꞌa séndamanifo ");
INSERT INTO auy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","séfataase-wamba maiyé miwíséꞌo maénda isamá káféꞌo minkwáásígóeꞌo emó méraanda ímba enawaaiꞌá isamá pó éraiꞌ-aai simásimene súwana ");
INSERT INTO auy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","minínínkó séna kemó imáyáamo únda Maníkón-aai simátimendawi óne. ");
INSERT INTO auy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sámériyaa-waasi kentáá síwáꞌná sésa maanómákáꞌá Maníkón-ímáyáá mósá máráaro siyáawaꞌa kembiwí Yúndaa-waasi séꞌa Yérúsaremu-naopaꞌa Maníkón-ímáyáá mósá máráaro wésewe súwana ");
INSERT INTO auy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ísu séna kemó sendamá éraiꞌe siyó. Moórá-kanaamo tínda ímba maanómákáꞌwárá Yérúsaremu-naopaꞌwaraꞌ-aantembanifo seyaafáꞌ-náópáꞌwáráꞌá kesifon-ímáyáá mósá maránááwe. ");
INSERT INTO auy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kembiwí Sámériyaa-waasi wen-ímáyáá máráámbanifo wení áwáuma ímba awánareꞌa wéowe. Yúndaa-waasisa wen-ímáyáá mósá maréta wení áwáusa awánaraumne. Maníkó séna moóráwigo sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkanae síndawi Yúndaa-waasifinkemba paápé íníye siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kesifo séna ken-ímáyáámó mósá maráíyamba ímba tóikakemba séꞌa éraiꞌa tirumpinkémbá ken-ímáyáá mósá máráaro siyáimba miyáumai moórá-kanaa wétisasamo éraiꞌo kesifon-ímáyáámó mósá wémaraiyawi tirumpinkémbá arupíse úmai kesifon-ímáyáá mósá maránááwe. ");
INSERT INTO auy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Maníkómbá áúma ímba wéraisana ámútanko méraisasa pósa ímba túrantamba aneꞌá wéawanaafo miyáráán-úmai Maníkón-ímáyáámó mósá máráámbo ombá wení ámútanko túwaꞌnai isasá tirumpinkémbá wen-ímáyáá mósá máráaro súwana ");
INSERT INTO auy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","minínínkó séna Maníkómó íyáfasinankaraiwai Káráísitiyemo sewí kumíníye. Kumíndaraꞌa seyaafá-tántáátáféna simátiminiye sewaꞌá ísaraumne súwana ");
INSERT INTO auy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ísu séna minááímó séndawi maandá kemá úne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ísu minááí wésuwasa wení kísau-waasi kouwerésa Ísumo Sámériyaa-ininkontafenamo súmba Yúndaa-waasiti namuro-ínínkóntáféna wésuwana póna tááꞌa úwasa tirumpin-ímáyáá ésa minínínkóntáféna nóintafenawa wéankaisanawa íyó-imayaa ésa Ísuntafesa nóra sénawa minínínkóeꞌa wésiyo-imayaa ésa ímba taáísai uwaná ");
INSERT INTO auy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","minínínkó wení sawe-kúrámá tuwéna naaópaꞌa wéna simátimena séna ");
INSERT INTO auy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","seyaafáꞌó uráunda-tantaaꞌa wépaape in-kwaasi méraiye. Maníkómó íyáfasinankaiwaiyaꞌiyo taawánaaro súwasa ");
INSERT INTO auy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","naaópaꞌa tuwésa Ísumpaꞌa tumbá ");
INSERT INTO auy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ísuni kísau-waasi Ísuntafesa sésa óraakoo tómbá naaó suwaná ");
INSERT INTO auy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ísu séna kemá ímbo awánaan-tomba makáumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","wení kísau-waasi keáímbá sésa nááwa tómbá maimaénawa máámakaiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ísu séna tóntáfénamo tááimo taintembá siꞌmákaiwain-aai iséꞌa wení kísau maimaé wéweꞌa taíꞌáandasafena wésinkaiye. ");
INSERT INTO auy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kísaufaꞌa wérain-tontafeꞌa éíyain-kwiyomba kóínana áfuma káínata fákáꞌmai túwaandu ónaumne wésefo kemá súne. Awánaaro. Káféꞌa maankánáá tómbó áfumo kaintembá miyáráán-úmai waásisomba tíꞌmai Maníkómpáꞌá túwaandu ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Waásisombo tíꞌmai Maníkómpáꞌó túwaandu uwátinkaiyan-kwaasimo ésa miwí kaweꞌ-méyámbá maíyasa Maníkómpáꞌó tíyan-kwaasi aúíꞌa úmai maéꞌmaeꞌa ónááwe súne. Tuwímbai kísau úmaraiyasa fíꞌowi fakaránááwe wésewe. Miyáumai kísau íyawiwaraꞌe fakaráíyawiwaraꞌe aamoí ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Fíꞌowi kísaumo úmakaamba isaꞌá kemá tiꞌmaráúnaꞌa fíꞌowiti kísaufaken-tomba wéfakaraawe Ísu waéꞌmai-aai simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Énifo minínínkó séna seyaafáꞌó uráunda-tantaaꞌa paápé uráiye siyáin-aai isésa pósa Sámériyaa-waasi mindáópaken-kwaasi Ísuntafesa sésa éraiꞌa Maníkómó íyáfasinankaraiwain-iye sésa ");
INSERT INTO auy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ísumpaꞌa tésa sésa kentáásí naaópaꞌa taméraao suwaná Ísu kae-kánáá koména ");
INSERT INTO auy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","aaí simátimuwasa isésa sáwífaꞌ-waasiwaraꞌa sésa éraiꞌa sáwíꞌo úmaimo méraundafinkenta kaweꞌ-ámpátáámó mésinkaindawin-iye sésa ");
INSERT INTO auy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","minínínkómbá simámesa sésa ímba enááisafeta aantembanifo wenááimo ísaraundasafeta séta marapáꞌ-wáásí sáwíꞌo úmaimo méraundafinkemba kaweꞌ-ámpátá mésinkaindawin-iye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ísu kaeꞌ-nóꞌwáámbá waéna mindáópaꞌa tuwéna Káríri-aempaꞌa kónae séna wéna ");
INSERT INTO auy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","séna Maníkón-aai simátímíwain-awiꞌa wenamááraa ímba mósá máráafo fíꞌon-daopaken-kwaasi wenáwíꞌa mósá wémaraawe súwana ");
INSERT INTO auy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","miyáumai Káríri-aempaꞌa kúwasa mináémpákén-kwáásí aamoí uwánkaraawe. Ááéma tíyótaimo í-tánón-kánááráꞌá miwí Yérúsaremu-naopaꞌa komésa Ísumo kísaumo maiyáimba awánaraamba pósa aamoí uwánkaraawe. ");
INSERT INTO auy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aamoí uwánkówana Ísu Káríri-aempaꞌa wénena Kéna-naopaꞌa non-úranko ándá-aran-dombo úkáin-daopaꞌo kúmba kámáni-waasi Kápaneamu-naopaken-kwaasigo ááninkomba áíꞌa wéuwana ");
INSERT INTO auy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ísu Yúndiyaa-aempakemba Káríri-aempaꞌa tiyáin-aai iséna Ísumpaꞌa téna séna kesááninko puwíndasafena wéisaꞌa úmpo kesí naaópaꞌa kuré koasófankainono súwana ");
INSERT INTO auy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ísu séna ímbo fíꞌo-fiꞌon-kisau-waameꞌo awánéꞌo éꞌa ímba kesááisafeꞌa timankúnkúmba ónááwe súwana ");
INSERT INTO auy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","óraakoo kesáánimba puwíndasafena wéimba minúwóíyáán-úmai tiyó súwana ");
INSERT INTO auy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ísu séna enáánimba asófawifo waaó súwana Ísun-aaisafena éraiꞌe séna kúmba ");
INSERT INTO auy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","aampaꞌá kúmba wení kísau-waasi tésa sésa enáánimba áíꞌa éꞌánkaraiye suwaná ");
INSERT INTO auy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tísai ena séna kesáánimba nóin-kanaarara áíꞌa éꞌánkaraiyo súwasa miwí sésa fénáímba wááwái áúiyamo kaimbá éꞌánkaraiye suwaná ");
INSERT INTO auy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","afowámá imáyáa éna séna minkánáá enáánimba asófawiyemo siyáimba éraiꞌa siyáiye súwasa wení akúmpákén-kwáásí seyaafáꞌá Ísun-aaisafesa timankúnkúmba uráawe. ");
INSERT INTO auy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yúndiyaa-aempakemba Káríri-aempaꞌa koména moóráma kawe-kísáú-wááméꞌá uréna minkáꞌá miníyámpóígómbá asófankowasa wení akúmbá timankúnkúmba uráawe. ");
INSERT INTO auy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ánaaemba Yúndaa-waasi ámáántafesa tanómba kaumakónkaꞌa Ísu Yérúsaremu-naopaꞌa kurái. ");
INSERT INTO auy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yérúsaremu-naokoni óntan-kusaifaꞌa ontamá wéromba áwíꞌa sipisípigoni ontamá miwání ewaaꞌá nonkwaaúnkón-áwíꞌa Pétésíta-nonkwaaumba wérowana ");
INSERT INTO auy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","mindónkón-áwáífaꞌa wááu-namba séfataase-namba wérowasa mindáúmpátá tíꞌo ún-kwaasisomba tuwímbai túgafitan-kwaasisone tíyayaambo kararón-kwaasisone mésa nonkómó úwaauwaamo índa amuꞌmakówana ");
INSERT INTO auy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","moórá-mora-kanaa wíyómpakewi nompímbá kumúwana nonkó úwaauwa úwana aifaꞌó nompímbó kumúwaimba áíꞌa éꞌánkaraiye. ");
INSERT INTO auy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tíꞌo ún-kwaasisompimba moóráwigo ména ayáátáákaꞌa 38 aatai áíꞌa ún-kwaasi mérowana ");
INSERT INTO auy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ísu awánéna ayáátáákaꞌa áíꞌa wéiye-imayaa éna áísai ena séna embá asófendasafena wéankaiyo súwana ");
INSERT INTO auy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","we séna nonkómó úwaauwaamo índaraꞌo síꞌmaenamo nompímbó sinkáíndawi ímba méraiye. Kemá kumónaeꞌo úndanifo moóráwigo kembá kúwáákena nompímbá aifaꞌá kúmísana kesíꞌa úwoi wéraiye súwana ");
INSERT INTO auy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ísu séna íyáfasinaao. Ení tuwaaiꞌá maimaé waaó súwana ");
INSERT INTO auy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","minúwóíyáán-úmai áíꞌa éꞌankowana wení tuwaaiꞌá maimaéna kuráiye. Yúndaa-waasi ámáán-aaimo ísón-kanaaraꞌa miyá úwasa ");
INSERT INTO auy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yúndaa-kawaa-waasi asófankon-kwaasisafesa sésa káféꞌa saagaan-kánáá isa ení tuwaaiꞌá maimaé wégonda aaraamá makáawe suwaná ");
INSERT INTO auy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","we séna asófasinkaraiwai séna ení tuwaaiꞌá maimaé waaó siyáiye súwasa ");
INSERT INTO auy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","miwí áísai esa sésa ení tuwaaiꞌá maimaé waaómó siyáiwai nááwaꞌiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","sáwífaꞌ-waasifimba Ísu áwiyokuwana póna asófankowi séna áwíꞌa ímbo isáúnda-waasin-iye siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Simásuwena ánaaemba óraaꞌ-amaan-daumpaꞌa iyúwana Ísu ayaafáí úmai awánéna séna áíꞌa éꞌánkaraimba po sáwíyamba sínkáífo sé sáwí-imayaa anekaꞌá ímba uwó súwana ");
INSERT INTO auy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","iséna Yúndaa-kawaa-waasi kosimátimena séna asófasinkaraiwai Ísun-iye súwasa ");
INSERT INTO auy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yúndaa-waasi ámáán-aaimo ísón-kanaaraꞌa Ísu asófankarontafesa Yúndaa-kawaa-waasi Ísumba sáwíꞌa uwánkámae íyúwana ");
INSERT INTO auy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ísu séna kesifo aasiyaasi-kánáá kísau wémaimba póꞌa miyáráán-úmai kísau maénaumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","saagon-kánááráꞌá asófankarontafenawara Maníkó kesifomán-iyemo siyóntafenawaraꞌa pósa Yúndaa-kawaa-waasi sésa tufuwónae símasimaꞌa umbá Maníkó kesifomán-iyemo siyónten-úmai Maníkóe keséꞌa mimbóráíꞌa úmai mérauye siyóntafesa Yúndaa-kawaa-waasi sésa tufuwónae siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Suwaná Ísu simátimena séna éraiꞌa simátimeꞌa súne. Ááninko póꞌa ímba kesí imáyáafinkemba únda kesifomó imbá awánéꞌa miyá wéune. Kesifomó intembá ááninko wéune. ");
INSERT INTO auy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kesifo ááninkomba arumbá siména seyaafá-tántááꞌó wéimba wéaraasimiye. Íyáákainda-kisaumo aráásiminaꞌa minkísáú máénaꞌa táátafeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kesifomá pukáampinkembo íyáfasintinkaintemba ááninko kesí imáyáafinkemba íyáfasintinkanaeꞌa wéune. ");
INSERT INTO auy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kesifo séna ímba aaifimbá maitinkánaumpo aaifimbó maitinkáínda-kisau kesááninkomba ámakaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aaifimbó maitínkáanda-kisau símakaimba pósa kesifon-áwíꞌo mósá máráántemba ááninko súwíꞌa mósá maránááwe. Kesúwíꞌo ímbo mósá maráíyawimo ésa kesifo siꞌmákaiwain-awiꞌwaraꞌa ímba mósá maránááwe. ");
INSERT INTO auy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Éraiꞌa simátimeꞌa súne. Kesááimo isésamo éraiꞌa aiꞌmákaiwai Maníkómá iyémó síyawi éꞌa áwáuma ómbaresa aúíꞌa úmai maéꞌmaeꞌa owe. Waási méraawini áwáuma Maníkóní némpaꞌo maéꞌómbanifo Maníkóní ewaaꞌá taméraamba póꞌa ímba aaifimbá maitinkánaumne. ");
INSERT INTO auy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Éraiꞌa simátimeꞌa súne. Moórá-kanaa tínasa pukáiyan-kwaasi Maníkón-ááninko-saai isánááwe. Isáíyawi íyáfasinesa maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kesifomá waásimo méraawini áwáun-iye. Fasiꞌaémbá siména séna miyámó úndantemba waásimo méraawini áwáuma óne siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kemá wíyómpakemba waási úranko kumpaápé uráundawi únana póna kesifo kentáféna séna aaifimbó maitínkénda-kisau amúne siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Minááísáféna ímba tááꞌa íno. Moórá-kanaamo tínda utaráan-kwaasi seyaafáꞌá kesáái isésa ");
INSERT INTO auy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","utarémpinkemba íyáfasinanaawe. Kaweꞌó uréwimo íyáfasinesa aúíꞌa úmai maéꞌmaeꞌa ónááfo sáwíꞌo uréwimo íyáfasinaiyaꞌa aaifimbá maitinkánaumne. Minááísáféna ímba tááꞌa íno Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ísu simátimena séna ímba kesí imáyáafinkemba wéumpo siꞌmákaiwai simásímakaintemba miyá wéune. Ímba kesí imáyáafinkembo ondasáféꞌa arupíse úmai aaifimbá maitinkánaumpo kesifo simásímakainten-úmai aaifimbá maitinkánaumne. ");
INSERT INTO auy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kemó kesáféꞌo súndarakaa karoꞌé sewaisinó. ");
INSERT INTO auy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Moóráwigowaraꞌo kentáfénamo simbá éraiꞌa wésiye. ");
INSERT INTO auy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kembiwí tuwímbai tiꞌmárówasa Yóni nombó maitínkáíwaimba koáísai uwaná Yóni kentáféna séna éraiꞌ-waasin-iye. Kosimátíméro siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kesí áwáumo síyantafeꞌa ímba óraaꞌ-imayaa úndanifo Yóni kentáfénamo siyáin-aaisafeꞌa éraiꞌe síyaꞌa sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkanae-imayaa wéeꞌa minááí simátimune. ");
INSERT INTO auy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ómbó aampaꞌó kúraꞌmae konten-úmai Yóni kentí aampaꞌó kúratinkowaꞌa kárikaꞌa aamoí uráawe. ");
INSERT INTO auy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Moórá-tantaako Yóni kentáféna siyáin-aaigomba íyáákaraiye. Kesifomó simásímakain-kisau wémaunana minkísáúgó kesí áwáuma wépaape-iye. Kesifomó siménamo siꞌmákain-kisau wémaunasa kesí áwáuma wéawanaawe. Mintántáákó Yóni kentáfénamo siyáin-aaigomba íyáákaraiye. ");
INSERT INTO auy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kesifo siꞌmákaiwai wewáráꞌá kentáféna simbánifo wenáái ísámai ímba kaweꞌá éꞌa wenaneꞌá ímba awánaraawe. ");
INSERT INTO auy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Siꞌmarówaꞌo kunkáundasafeꞌa ímba timankúnkúmba ombá póna Maníkón-aai ímba tirumpimbá wéraiye. ");
INSERT INTO auy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kembiwí séꞌa aúíꞌa úmai maéꞌmaeꞌa ónaumne séꞌa Maníkón-aai aúfáífimba toráumai awána-awana wéowe. Mináúfáífímbá kesí áwáuma agaimárówaꞌanifo ímba kaweꞌ-úmai ísaraawe. ");
INSERT INTO auy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kaweꞌó úmaimo iséꞌo kempáꞌó tenkakaa aúíꞌa úmai maéꞌmaeꞌa owaisinó. ");
INSERT INTO auy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Waási kesúwíꞌa óraaꞌa uwásinkanaawe-imayaa ímba wéune. ");
INSERT INTO auy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Maníkómbó ímbo tirumbó áménkaꞌa wétuwanaumne. ");
INSERT INTO auy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kesifomá simásímakaintafeꞌa kunkáundanifo ímba kaweꞌá wéuwasinkaawe. Énifo moóráwigombo kesifomó ímbo simámakaindawimo tínaꞌo éꞌa kaweꞌá uwánkanaawe. ");
INSERT INTO auy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kembiwí séꞌa waási kentáá súwíꞌa óraaꞌa uwásinkanaawe séꞌa póꞌa kesáái ímba éraiꞌe wésewe. Maníkómá kentáá súwíꞌa óraaꞌa uwásinkainiye senkakaa kentáféꞌa éraiꞌe sewaisinó. ");
INSERT INTO auy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kesifon-aúrankaꞌa ímba aaifimbá maitinkánaumpo Mósese naaófáꞌó ámáán-aaimo agaimakáiwai aaifimbá maitinkáíníye. Mósese súwaꞌnai iyémó sewímó éna wemá aaifimbá maitinkáíníye. ");
INSERT INTO auy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mósese kesáái agaimakáimba póꞌa Mósesen-aaisafeꞌo timankúnkúmbo onkakaa kesááisafeꞌa timankúnkúmba owisinó. ");
INSERT INTO auy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mósesemo agaimakáin-aaisafeꞌa ímba éraiꞌe sembá póꞌa kesááisafeꞌa ímba éraiꞌe sewé Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Naaófáꞌá Maníkó Yúndaa-waasi tíyótaimo í-tánón-kánáá ampáámbá úwana Káríri-waaunkoni menáípáꞌá Ísu nompín-táómpimba wéna minkwaaúnkóní moórá-awiꞌa Táípíriyasi nompáꞌá kúmba tíꞌo ún-kwaasisomba asófatinkowasa awánésa pósa wenánaaemba arááíwáúwasa Ísuwe wení kísau-waasiye nompín-táómpinkemba marapáꞌá kumésa omápaꞌa imérowasa ");
INSERT INTO auy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","sáwífaꞌ-waasi Ísumpaꞌa íyúwana tuwánéna imáyáa éna séna ánaaemba miyá ónaumpo aifaꞌá Fírípimba áísai úmai isánae séna áísai ena séna nááfakena tómbá méyámbaꞌmaiya tíménara nánaao súwana ");
INSERT INTO auy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fírípi séna sáwífaꞌ-ontankakemba 200 kinaaraken-tomba méyámbaꞌmaisa timúnasasa naawaisinó súwana ");
INSERT INTO auy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","moórá-kisau-waasigo Sáímoni Pítaan-áfákon-awiꞌa Énduru ");
INSERT INTO auy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","séna moórá-iyampoigo séfataase-tonkwara kaeꞌ-mófááꞌwáráꞌá makáifo sáwífaꞌ-waasi méraawe súwana ");
INSERT INTO auy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ísu wení kísau-waasisafena séna maraꞌá méraaro simátíméro súwasa simátímúwasa maraꞌá mérowana minkwáásísómbá sáwífaꞌa 5,000 waaima mérowana ");
INSERT INTO auy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ísu mintómbá maisoréna Maníkóntáféna súwiyo simásuwena tómbá tafántafan-úmai wení kísau-waasi timúwasa miwí tímúwana tómbó nontenkáán-úmai mófááꞌa miyáumai nowaná tímúꞌa fówasa miwítí imáyáagomo úniꞌa uwaná ");
INSERT INTO auy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","wení kísau-waasisafena séna mintón-ayai ímba úwoifaꞌa túwáaro súwasa ");
INSERT INTO auy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","séfataase-tompinkemba nésamo túwón-ayaisomba sísamaifakemba kaeꞌá kumbaimái-unampimba fáítuwana ówitowasa ");
INSERT INTO auy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ísumo úmba awánésa sésa Maníkón-aaimo simátímíwai íntaamo awánáúnda-waameꞌa isatá awánáúmne sésa amuꞌmaráúndawin-iye sésa ");
INSERT INTO auy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","kentáásí kawáá-íta íníyemo sumbá Ísu miwí tirumpimbó un-ímáyáá iséna ímba miyá ónaunasa sewé séna tiyuwéna omápaꞌa iyáiye. ");
INSERT INTO auy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ísu omápaꞌa imérowasa fenómpinkaꞌa wení kísau-waasi nonkwaaúnkóní áwáífaꞌa kumésa ");
INSERT INTO auy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kápaneamufaꞌa kónae sésa nompín-táómpimba íyátesa kuwaná Ísu ímba túwana nóꞌwaamba fénkúwana ");
INSERT INTO auy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","óraa-fiyunda toréna nonkó tufántááfan-úwasa ");
INSERT INTO auy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","taántámbá nombá tuwíntámaesa ayáátáákaꞌa kuwaná Ísu non-afóforaꞌa maréna nompín-táónkoni ewaaꞌá túwasa awánésa táátafesa uwaná ");
INSERT INTO auy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ísu séna kemá úmpo ímba táátafe oro. Aánoꞌa méraaro súwasa ");
INSERT INTO auy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","aamoí ésa sésa nompín-táómpimba íyátaao suwaná minúwóíyáámbá nompín-táónko nonáwáífaꞌa kúpaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Aafáyáama menáípáꞌó koméron-kwaasi sésa fénáímba nompín-táómba kímbora wéraisana Ísu ímba mimpímbá wisasá wení kísau-waasi miwí aantemba kuráafo Ísu nááfara méraiyo siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tuwímbai-waasi nompín-táómpimba Táípíriyasifakemba tóso ésa fénáínkaambo Ísumo Maníkóntáfénamo súwiyo súwasamo waásisombo tómbó néwiyopaꞌa tésa ");
INSERT INTO auy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ísuwe wení kísau-waasiye ímba mérontafesa tiyaafáí ónae sésa mindómpín-táómpimba íyátesa Kápaneamufaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kápaneamu-naopaꞌo kumbá Ísumba awánésa sésa kesí óraakoo emá nóin-kanaawa maafáꞌá tiyáano suwaná ");
INSERT INTO auy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ísu séna ísáaro. Ímba kaweꞌ-wááméꞌó aráátimundasafeꞌa wésiyaafai-ofo tómbó naráantafeꞌa wésiyaafai-owe. ");
INSERT INTO auy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tómbó ímbo aasiyaasimó waéꞌwaeꞌo índa-tontafeꞌo éꞌa ímba kísau maéꞌa waásimo aasiyaasimó maéꞌmaeꞌo íyan-tontafeꞌo éꞌa kísau máéro. Mintómbó tíménda kemá waási úranko mintómbá timénaumne. Maníkó kesifomá kentáféna séna aamoí uwánkaumne. Kesí kísau mauwó simbá póꞌa mintómbá timénaumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","áísai esa sésa nóraumaisaawa Maníkóní kísau maénaumno suwaná ");
INSERT INTO auy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ísu séna kentáféꞌo séꞌo éraiꞌa Maníkó aiꞌmákaisana kunkáiwai iyémó sembá mindá Maníkóní kísau maéꞌa sewé súwasa ");
INSERT INTO auy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","nóran-kwaameraꞌini ímbo awánáúnda-waameꞌo inatáámó éta awánéta séta éraiꞌa Maníkó embá aiꞌmáráísama kunkáandawi ónesa sénaumne. Nóin-kisau-waamera ínono sésa ");
INSERT INTO auy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","kentáá síwáꞌná máásai-marafaꞌa mésa wíyómpaken-tonkon-awiꞌa máána-tomba néꞌómbanifo emó uráandawimo éna ímba mindá íyáákaraiye. Naaófáꞌá Maníkón-aai aúfáífimba agaimaréna séna wíyómpaken-tomba timúwasa naráawe agaimaréna siyáiye suwaná ");
INSERT INTO auy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ísu séna ísáaro. Mósesemo tímakain-tomba ímba wíyómpaken-tomban-ifo kesifomá wíyómpaken-tomba kawe-tómbá wétimiye. ");
INSERT INTO auy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wíyómpakembo marapáꞌó kunkáiwai wemá Maníkómó tímín-tomban-iye. Wentáféꞌo wéeꞌa maéꞌmaeꞌa ónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","miwí sésa sénda-tomba aasiyaasi-kánáá simiyó suwaná ");
INSERT INTO auy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ísu séna kemá aasiyaasí maéꞌmaeꞌo íyan-tomba úne. Kempáꞌó wétiyawi ímba tááima táíníye. Kenkáꞌó timankúnkúmbo wéiyawi ímba nontáféna tinkáíníye. ");
INSERT INTO auy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Éꞌa simátímakaumne. Kesí kísau-waameꞌa awánaambanifo kesááisafeꞌa ímba éraiꞌe sésa ímba kenkáꞌá timankúnkúmba wéowe. ");
INSERT INTO auy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Énifo kesifomó símín-kwaasimo éꞌa kempáꞌá ténááwe. Kempáꞌó tíyan-kwaasisafeꞌo éꞌa ímba kóro sénaumne. ");
INSERT INTO auy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kesí imáyáamo arááíwáéndasafeꞌa wíyómpakemba ímba kunkáumpo siꞌmákaiwaini imáyáamo arááíwáéndasafeꞌa kunkáumne. ");
INSERT INTO auy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Siꞌmákaiwai simásimena séna amúnda-waasi sáwí-ampaꞌa arááíwáéfo sé kawáánuwo. Ánaaen-kanaa pukémpinkemba íyáfasintinkaano. ");
INSERT INTO auy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kesifomá simásimena séna kesááninkoo embá awánésa sésa Maníkón-ááninkoman-iyemo síyawi aúíꞌa úmai maéꞌmaeꞌa ónááwe siyáiye. Ánaaen-kanaama pukémpinkemba íyáfasintinkanaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kemá wíyómpaken-tomba úne Ísu súntafesa Yúndaa-oraaꞌ-waasi tirunkó sáwíꞌa úwasa ");
INSERT INTO auy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","miwí sésa wemá Ísuma Yósepin-ááninkoman-iye. Anófoi étaamo tuwánáúndanifo nóra sénawa wíyómpakemba kunkáumne wésiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ísu simátimena séna ímba miyá mósimesin-oro séna ");
INSERT INTO auy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","kesópaꞌa ímba úwoima ténááfo kesifo kembá siꞌmákaiwaima táántainaꞌa kesópaꞌa tíyaꞌa ánaaen-kanaama pukémpinkemba íyáfasintinkanaumne. ");
INSERT INTO auy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mindásafesa naaófáꞌá Maníkón-aaimo simátímakowi agaimarésa sésa Maníkó seyaafáꞌ-wáásí símai aráátiminiye siyáawe. Kesifon-aaimo ísámai kaweꞌó íyawi kesópaꞌa ténááwe. ");
INSERT INTO auy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kesifombá ímba awánaraafo kemá Maníkónópakemba kunkáundawi keyááma kesifombá awánaraumpo kesifon-aaimo ísámai kaweꞌó íyawi kesópaꞌa ténááwe. ");
INSERT INTO auy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Éraiꞌa simátimeꞌa súne. Kesááisafesa éraiꞌe sésa kenkáꞌá timankúnkúmbo íyawi áwáuma ómbaresa aúíꞌa úmai maéꞌmaeꞌa wéowe. ");
INSERT INTO auy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kemá maéꞌmaeꞌo íyan-tomba úne. ");
INSERT INTO auy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kentíwáꞌnáma máásai-marafaꞌa mésa máána-tomba némesa úwoi putáráawe. ");
INSERT INTO auy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Énifo wíyómpaken-tomba miyán-tómbó náíyawima úwoi maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kemá wíyómpaken-tomba maéꞌmaeꞌo íyan-tomba úne. Mintómbó nésamo ésa aasiyaasí maéꞌmaeꞌa ónááwe. Kesúma timúnaꞌo naantaféꞌa póꞌa aasiyaasí maéꞌmaeꞌa ónááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ísu súwasa Yúndaa-oraaꞌ-waasi tirunkó sáwíꞌa úwasa keáímbá sésa nóra sénawa miwá wenáúma simínataawa nánaumno suwaná ");
INSERT INTO auy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ísu simátimena séna éraiꞌa súne. Kemá waási úranko póꞌa kesúmo ímbo néꞌo kesí naaemó ímbo néꞌo éꞌa ímba maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Énifo kesúwe kesí naaewémó naawí áwáuma ómbaresa aúíꞌa úmai maéꞌmaeꞌa ombá póꞌa ánaaen-kanaama pukémpinkemba íyáfasintinkanaumne. ");
INSERT INTO auy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kesúma kawe-tómbán-iye. Kesí naaemá kaweꞌ-nómbán-iye. ");
INSERT INTO auy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kesúwe kesí naaewémó naawí keséꞌa kááísamai méraawaꞌa kemá miwíséꞌa kááísamai méraumne. ");
INSERT INTO auy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kesifo siꞌmákaiwai aasiyaasí maéꞌmaeꞌa iwáí isaꞌá póꞌa kewáráꞌá aasiyaasí maéꞌmaeꞌa wéune. Kemá maéꞌmaeꞌa úndasafeꞌa póꞌa kesúmo newí aasiyaasí maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kentíwáꞌná tómbá némesa úwoi putáráawe. Kemó súnda-tomba wíyómpaken-tomba ímba miyán-tómbán-iye. Kemó súnda-tomba mintómbó newí aasiyaasí maéꞌmaeꞌa ónááwe Ísu miyámá ");
INSERT INTO auy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kápaneamu-naopaꞌa ámáán-daumpaꞌa simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","61","Ísu simátimuwasa wembó arááíwáún-kwaasi tirunkó sáwíꞌa úwasa imáyáa ésa sésa wemó sin-ááígó ínta sínkáín-aai póna umbaí wétaiye suwaná Ísu arumpin-ímáyáá éna simátimena séna minááísáféꞌa wégaoraawe. ");
INSERT INTO auy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kemó wíyómpaken-waasi úrankomo kumpaápé uráundawimo kunuweréꞌo íyónaꞌo suwánéꞌo éꞌa nóran-imayaawa ónaao. ");
INSERT INTO auy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Waásiti fasiꞌaénkó ímba túwaꞌnai ínífo Maníkóní ámútankoni fasiꞌaénkó túwaꞌnai ínaꞌa aúíꞌa úmai maéꞌmaeꞌa ónááwe. Miyámó intembá kemó súnda-aai mindá ámútankon-aai aúíꞌa úmai maéꞌmaeꞌo íyan-aain-ifo ");
INSERT INTO auy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","tuwímbai kentáféꞌa séꞌa karoꞌá siyé wésewe Ísu súmba Ísu karoꞌá siyémó sun-kwáásíyé wení pintaruꞌó índawiwaraꞌa naaófáꞌá ísaronkaꞌa póna séna tuwímbai kentáféꞌa séꞌa karoꞌá siyé wésewe Ísu simátimena ");
INSERT INTO auy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","séna mindásafeꞌa éꞌa simátimeꞌa súne. Kempáꞌá ímba úwoi ténááfo kesifomó táántainaꞌo éꞌa ténááwe simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ísu simátimuwasa wembó arááíwáún-kwaasisomba Ísumba ifáꞌauwesa weséꞌa ímba wénuwana ");
INSERT INTO auy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ísu wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasisafena tísai ena séna kewárárá kembá siyuwaaó séna tísai úwana ");
INSERT INTO auy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sáímoni Pítaa séna óraakoo kesáá nááfataawa kónaunawa sénó. Enááigo aúíꞌa uwátinkainasa aasiyaasí maéꞌmaeꞌa ónááwe wésendawi óne. ");
INSERT INTO auy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Káféꞌa entáféta simankúnkúmba éta séta Maníkómpákémbá kawekó ónesa wésune súwana ");
INSERT INTO auy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ísu simátimena séna kemá sísamaifakemba kaeꞌá kumbaimái-waasimo kemparíꞌa uráundanifo kempínkémbá moórá sáwí-waasigo paápé íníye súmba ");
INSERT INTO auy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sáímoni-Ísakeriotin-ááninkon-awiꞌa Yúndasintafena séna Yúndasi wení kísau-waasi sísamaifakemba kaeꞌá kumbaimái-waasifinkemba Ísuni pintaruꞌá maíndawin-iye. Wentáféna minááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Minkákémbá Yúndiyaa-aempaken-kwaasi Ísumba tufuwónae suntáféna Ísu Yúndiyaa-aempaꞌa ímba númba Káríri-aempaꞌa wénuwana ");
INSERT INTO auy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yúndaa-waasimo wááu-nambo ésamo tanómbo kaúfún-kanaa ampáámbá úwasa ");
INSERT INTO auy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ísun-áfárawaisai karaánááꞌa ankésa sésa maanáémpáꞌá tuwéma Yúndiyaa-aempaꞌa waásimo túwaandu íyapaꞌa ení kísau komáínasa pósa ení waási ení kawe-kísáú awánaaro. ");
INSERT INTO auy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Seyaafáꞌ-wáásí suwánáíwae síyawi ímba aúpáꞌá kísau maénááfo seyaafáꞌ-wáásí túrankaꞌa kísau komauwó sésa ");
INSERT INTO auy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ísun-áfárawaisai wentáfésa ímba imáyáa ésa sésa Maníkómpákémbá kunkáiye sumbá minááí simámúwana ");
INSERT INTO auy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ísu simátimena séna seyaafáꞌnánká kesí áwáumo suwánáíyan-kanaa ímba tiyáifo kembiwí úwoi wíyasa tuwánésa ");
INSERT INTO auy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","marapáꞌ-wáásí kembá ímba aaisambá tíkaafo miwímó on-áwáúsáféꞌo súndasafesa kembá aaisambá síkaawe. ");
INSERT INTO auy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tanómbo opaꞌá ke koró. Seyaafáꞌnánká kesí áwáumo suwánáíyan-kanaa ímba tiyáifo káféꞌa ímba tanómbo opaꞌá kúmpo kemá koró séna ");
INSERT INTO auy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Káríri-aempaꞌa méraiye. ");
INSERT INTO auy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ísu mérowasa áfárawaisai tanómbo upaꞌá kuwaná ánaaemba wemá aúpáꞌá kúwasa ");
INSERT INTO auy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yúndaa-oraaꞌ-waasi Ísumba ayaafáí ésa sésa nááfara méraiyo sésa tísai uwasá ");
INSERT INTO auy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ísuntafesa úwoi-waasi sáwífaꞌ-aai sésa tuwímbai sésa kaweꞌ-wáásín-iye suwasá tuwímbai sésa ímbanifo karoꞌ-wáásín-iye sésa ");
INSERT INTO auy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yúndaa-oraaꞌ-waasi sáwíꞌa uwásínkáafo sésa ímba aforaꞌá sumbá umémpaꞌa tukáawe. ");
INSERT INTO auy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yúndaa-waasimo wááu-nambo úmakesamo tanómbo kaúfún-kanaa séfasefa úwana afufuntan-kánáá Ísu óraaꞌ-amaan-daumpaꞌa iména wenáái simátimuwasa ");
INSERT INTO auy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yúndaa-oraaꞌ-waasi isésa táátafesa ésa tóipimba tiyáámba faafésa sésa ámáán-aaimo uwáítáíꞌ-opaꞌá ímba koména ísaraimbanifo nááfakena ísaraiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ísu minímáyáámó umbá iséna séna kesí imáyáafinkemba ímba simátimumpo Maníkó siꞌmákaiwaini imáyáafinkemba simátimune. ");
INSERT INTO auy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kembiwí imáyáama éꞌa séꞌa nááfaken-aaiya simásímakaiyo. Wení imáyáafinkenaꞌi Maníkóní imáyáafinkenaꞌiyo-imayaa wéowe. Maníkómó siyáintemba ónaemo síyawi miwímó ésa simátimunda-aaigoni áwáuma isánááwe. ");
INSERT INTO auy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kentí imáyáafinken-aaimo síyawi kesúwíꞌa mósá maráíwae sésa kentí imáyáafinkemba wésefo tiꞌmákaiwain-awiꞌa mósá maránae síyawi ímba karoꞌá sembá éraiꞌ-aai wésewe. ");
INSERT INTO auy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mósese ámáámba simátímakombanifo ímba ísámai kaweꞌá uréꞌe sembá sínkamonae wésewe súwasa ");
INSERT INTO auy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","úwoi-waasisomba sésa ímba tufuwónae-imayaasa wéumpo enarumpimbá sáwí-amutamba méraisa miyán-ááí séne suwaná ");
INSERT INTO auy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ísu séna ámáán-aai ísáán-kanaaraꞌa ímba awánaraan-kwaameꞌa uráunda póꞌa kemá sáwífaꞌ-imayaan-owe. ");
INSERT INTO auy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kentíwáꞌnárakemba sésa iyámpói matínkaraawasa afakaumboé-noꞌwaamba waésa túma kárámai araénáémba ónááwe suwaná ánaaemba Mósese minááí agaimakómba pósa tuwímbai-kanaa ámáán-aai ísáán-kanaaraꞌa miyá wéowe. ");
INSERT INTO auy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Móseseni ámáámba ímba taráíyaamba póꞌa saagaan-kánááráꞌá miyán-kísáú iyámpói túraꞌa wéowe. Énifo saagaan-kánááráꞌá moóráwigomba asófankaraunda póꞌa kísau maénafo séꞌa aaisambá wésiyowe. ");
INSERT INTO auy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ímba awánéraase aaisáféꞌa ímba simátínkáaro. Éraiꞌa awánáíyan-aaisafeꞌa simátínkáaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ísu simátimuwasa tuwímbai Yérúsaremu-naopaken-kwaasi sésa minkwáásísáfésawa tufuwónae wéseo sésa ");
INSERT INTO auy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","wemá aforaꞌá wenáái simátímísaꞌanifo ímba aaifimbá maiyánkaraawe. Óraaꞌ-waasisomba sésawa wemá Maníkómó íyáfasinankaraiwai Káráísitin-iye miyáwá wése ína wéseo. ");
INSERT INTO auy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Maankwáásígóní naaópaꞌa awánáúndanifo Maníkómó íyáfasinankaraiwaini naaópaꞌa ímbo awánáúndafakemba tíníye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Minkákémbá Ísu óraaꞌ-amaan-daumpaꞌa simátimena séna kembá éra suwánéra kesi máápaꞌa éra awánéra miyáwá uráao. Ímba kesí imáyáafinkemba kunkáumpo moóráwigo siꞌmáráísaꞌa kunkáumne. Wemá éraiteꞌo siwáín-iye. Wembá ímba awánaraafo ");
INSERT INTO auy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","kemá éꞌa awánáúndawi siꞌmákaisaꞌa wempákémbá kunkáumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","minááímó súnkakemba wembá taꞌótoranae sésa umbánifo wení kanaamá ímba tiyóntafesa ímba taꞌótorowasa ");
INSERT INTO auy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","úwoi-waasifinkemba tuwímbai sésa Maníkómó íyáfasinankaraiwaimo tíndaraꞌa wení kísau-waameko seyaafá-kísáúgómbá íyáákainiye-imayaa wéeta Ísuni kísaugo miyán-kísáúgó póna Ísu Maníkómó íyáfasinankaraiwain-iye wésune siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Úwoi-waasisomba minááí sumbá ámáán-kawaa-waasi isésa miwíyé óraaꞌ-amaan-kisau-waasiye i-wáásísáfésa sésa Ísumba kotaꞌótoraaro sésa tiꞌmárówasa kuwaná ");
INSERT INTO auy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ísu séna kárikaꞌa kembiwíséꞌa méꞌa siꞌmákaiwaimpaꞌa íyónaꞌa ");
INSERT INTO auy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","siyaafáí uwááeꞌa ímba suwánéꞌa iméraandafaꞌa ímba kanaaꞌá iyónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yúndaa-oraaꞌ-waasi keáímbá sésa nááfara wíndasafenawa síyómpo ayaafáí uwááeta ínta awánánaumne. Kíríki-aempara Yúndaa-waasimo méraapara wénawa wenáái simátiminiyo sésa ");
INSERT INTO auy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","wemá séna siyaafáí uwááeꞌo éꞌa ímba suwánéꞌa iméraandafaꞌa ímba iyónááwemo simbá minááígóní áwáuma ínta ísaraumne siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yúndaa-waasi wááu-nambo úmakesamo tanómbo kaúfún-kanaaraꞌa taiꞌón-kanaa óraa-kanaa úwana minkánááráꞌá Ísu íyáfasinena óraaka séna nontáfénamo tinkáíndawi kempákémbá tamandaaró. ");
INSERT INTO auy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Maníkón-aai aúfáífimba agaimaréna siyáintemba nonaumpinkémbó íyáúsenamo intenkáámbá kesááisafesa timankúnkúmbo íyawi tirumpinkémbá nonaumpinkémbó intembá íníye Ísu súmba ");
INSERT INTO auy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Maníkóní ámútankontafena siyáiye. Ísu ímba wíyómpaꞌo kunuwékáintafena Maníkóní ámútanko ímba kunkáiye. Ísu imáyáa éna séna kemá púwóndafinkemba íyáfasineꞌo kesifompáꞌó iyéꞌa Maníkóní ámútankomba aiꞌmáráanana kuména kesááisafesa timankúnkúmbo íyawi tirumpimbá kumbéíniye-imayaa éna Ísu minááí simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ísumo simátimumba waásisomba isésa tuwímbai sésa éraiꞌa wemá Maníkón-aaimo simátímíwain-iye suwasá ");
INSERT INTO auy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","tuwímbai sésa wemá Maníkómó íyáfasinankaraiwai wéamuꞌmaraundawin-iye suwasá tuwímbai sésa Maníkómó íyáfasinankaraiwai ímba Kárírifakemba paápé íníye. ");
INSERT INTO auy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Naaófáꞌá Maníkón-aai aúfáífimba agaimaréna séna Maníkómó íyáfasinankaiwai Téfítin-andafakemba Téfítini naaópaꞌa Pétaremufaꞌa maꞌankáíníye agaimaréna siyáiye sésa umbá ");
INSERT INTO auy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ísuntafesa imáyáa tuwínkaaꞌa ésa ");
INSERT INTO auy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","tuwímbai sésa taꞌótoranae sumbánifo ímba Ísumba taꞌótokaawe. ");
INSERT INTO auy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ímba taꞌótoresa i-wáásí óraaꞌ-amaan-kisau-waasifaꞌe ámáán-kawaa-waasifaꞌe kouwérówasa nóra séra ímba taꞌótoꞌmai áíꞌmaeꞌa téo suwasá ");
INSERT INTO auy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","i-wáásí sésa wenááigo seyaafáꞌ-wáásí tááigomba íyáákaraiye suwasá ");
INSERT INTO auy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ámáán-kawaa-waasi tísai esa sésa kenkwárárá karoꞌá simátínkáísara wéseo. ");
INSERT INTO auy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Óraaꞌ-waasiye kesáá ámáán-kawaa-waasisaawe ímba éraiꞌa wíyómpakemba kunkáiyesa wésumpo kewáráꞌá miyá seró. ");
INSERT INTO auy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Úwoi-waasi aantemba éraiꞌe wésewe. Miwí Móseseni ámáámba ímba wéisaamba póna Maníkó tínkaminiye suwaná ");
INSERT INTO auy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ámáán-kawaa-waasifinkemba moóráwigon-awiꞌa Níkótímási ááéma Ísumpaꞌa iyáiwai simátimena séna ");
INSERT INTO auy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","kentáásí ámáánko séna ímba úwoi séꞌa sáwíꞌa uráiye síyamba wenáái ísareꞌa wení kísau awánéꞌa aaifimbá maénkáaro kentáásí ámáánko siyáiye súwasa ");
INSERT INTO auy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Níkótímásimba karaánááꞌa ankésa sésa Kárírifakewimba arááíwaino. Maníkón-aai aúfáífimba toráumai awánamai kaweꞌá uréo. Maníkón-aai simátímíwai ímba Kárírifakewin-ifo wemá ímba Maníkón-aai simátímíwain-iye sésa ");
INSERT INTO auy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","kentí naaóꞌ-naoꞌa wété uwaná Ísu Órífi-ompaꞌa iyáiye. ");
INSERT INTO auy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Órífi-omapaꞌa Ísu iména ");
INSERT INTO auy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","aafáyáaraꞌa kuména óraaꞌ-amaan-daumpaꞌa imérowasa waásisomba wempáꞌá túwaandu uwaná maraꞌá ména wenáái simátimuwasa ");
INSERT INTO auy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ámáámbo sun-kwáásíyé ámáán-kawaa-waasiye aaregómbá áíꞌmaesa minínínkó fíꞌon-kwaasiseꞌo nímba pósa áíꞌmai seyaafáꞌ-wáásítí túrankaꞌa ankésa ");
INSERT INTO auy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ísuntafesa sésa óraakoo minínímbá fíꞌon-kwaasiseꞌa nísata awánéta taꞌótoꞌmaeta áíꞌmaeta túne. ");
INSERT INTO auy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ámáán-aufaifimba Mósese agaimaréna séna miyámó índawimba óntantamba tufúwónanasa puwíníye agaimaréna siyáiye. Nóran-imayaawa ónó sésa ");
INSERT INTO auy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ísumba maꞌmái awánánae sésa miyá senanasá paápé ínata wembá aaifimbá maiyankánae sésa suwaná Ísu kífaena ayáánaufitamba mararáꞌá aúfái agaimarówasa ");
INSERT INTO auy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","áísai aisai uwaná íyáfasinena simátimena séna ímbo aoisaambó uráindawi aifaríꞌena óntamba maiyé tufuwó simátimena ");
INSERT INTO auy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","anekaꞌá kífaena ayáánaufitamba mararáꞌá aúfái agaimarówasa ");
INSERT INTO auy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","isésa moórá-mora-waasi kúwákárúwasowana óraaꞌ-waasi aifaꞌá kumúwasa miwán-ánaaemba arááíwaꞌmaesa kúmúwana minínínkó aantemba Ísuweꞌa mérowana ");
INSERT INTO auy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","íyáfasinena áísai ena séna nááfara seyaafáꞌá méraao. Seyaafáꞌnánká ína aaifimbá maenkánaao súwana ");
INSERT INTO auy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","séna ewé ímba aaifimbá maisinkánááwe súwana we séna kewáráꞌá ímba aaifimbá maiyankáúna kómpo anekaꞌá ímba aoisaambá uwó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Anekaꞌá Ísu wenáái simátimena séna waási sámo kátínkáandawi úne. Kembó sirááíwaiyawi ímba kumeuꞌá ínífo sáma kátinkainaꞌa maéꞌmaeꞌa ónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ámáán-kawaa-waasi sésa eyááríkaꞌa ení áwáuma séndamanifo ímba éraiꞌa wésene suwaná ");
INSERT INTO auy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ísu séna ímbanifo kesááigoni áwáuma éraiꞌa súne. Éꞌa awánáúndafakemba kunkáundasafeꞌa éꞌa awánáúndafaꞌa íyónda póꞌa kemó súnda-aai éraiꞌa súne. Kesí áwáuma ímba suwánaraawe. ");
INSERT INTO auy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Marapáꞌ-wáásí kentí imáyáafinkemba aaimá maisínkáafo kemá ímba aaimá wémaitinkaumne. ");
INSERT INTO auy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kemó aaimó maitinkáúndarakaa arupíse úsino. Ímba ke aantemba aaifimbá maitinkánaumpo kesé kesifoéꞌa aaifinkáí maitinkáyauye. Miyáumai kemó aaimó maitinkáúndarakaa arupíse úsino. ");
INSERT INTO auy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kentí ámáán-aufaifimba agaimaréna séna kaeꞌ-wáásíyáí moórá-aaimo séyambo ékai minááí éraiꞌa wéseye agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Miyáumai kemá kesáféꞌa simátimunana kesifoé keséꞌa mimbórá-ááí wésimatimuyamba póna éraiꞌ-aain-iye súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","enafomá nááfara méraiyo áísai esa suwaná séna kesí áwáumo ímbo suwánaantafeꞌa kesifombá ímba awánaraawe. Kesí áwáumo suwánaankakaa kesifombá awánaawaisino Ísu súmba ");
INSERT INTO auy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","óraaꞌ-amaan-daumpaꞌa óntambo túwón-daumpaꞌa minááí simátimuwasa taꞌótoranae sésa uwááesa wení kanaamá ímba tiyóntafesa ímba taꞌótokaawe. ");
INSERT INTO auy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Minkákémbá Ísu simátimena séna tiyuwéꞌo íyónaꞌa siyaafáí uwááeꞌa ímba suwánánááwe. Puwíyamba kentí sáwí-imayaa wérainaꞌa puwónááwe. Íyóndafaꞌa ímba kanaaꞌá iyónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yúndaa-oraaꞌ-waasi sésa wemó séna íyóndafaꞌa ímba kanaaꞌá iyónááwe simbá póna weyááríkara puwíndasafenawa síyó suwaná ");
INSERT INTO auy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ísu séna kembiwí maankákén-kwáásín-ofo kemá sanaankéwí úne. Kembiwí marapákén-kwáásín-ofo kemá wíyómpakewi úne. ");
INSERT INTO auy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Simátimeꞌa súne. Puwíyamba kentí sáwí-imayaa wérainaꞌa puwónááwe. Kemá wíyómpakewi úmpo kentáféꞌo ímbo timankúnkúmbo éꞌo éꞌa kentí sáwí-imayaa wérainaꞌa puwónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","minááígóní áwáuma ímba isésa sésa emá nááwawa ónó suwaná Ísu séna aasiyaasi-kánáá éꞌa simátímakaumne. ");
INSERT INTO auy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kembiwísáféꞌa sáwífaꞌ-aai kanaaꞌá séꞌa aaifimbá maitínkáandanifo siꞌmákaiwain-aai aantemba seyaafáꞌ-wáásísáféꞌa wésimatimune. Wemó arupísemo iwáín-áái wésimatimune súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Maníkón-aai súmbanifo ímba ísówana ");
INSERT INTO auy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","mindásafena Ísu séna kemá waási úranko kumpaápé uráundawimba síꞌmaeꞌa aaraa-táíyáꞌá mósinkamiyamba suwáné séꞌa wemó siwáí wení imáyáafinkemba ímba sifó afowamá simámakain-aaifinkemba siyáiye miyá sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Siꞌmákaiwai aamoí ínkwae-iꞌa úmaeꞌa wéiyunda póna ímba siyuwéna keséꞌa mérainiye súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","sáwífaꞌ-waasi isésa wentáfésa timankúnkúmba ésa wíyómpakewin-iye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ísu Yúndaa-oraaꞌ-waasi wentáfésa timankúnkúmba ésa wíyómpakewi iyémó siyówisafena séna kesááimo ísámaimo kaweꞌó éꞌo éꞌa kesí waási-iꞌa úmai méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Éraiꞌ-aai íséwana taꞌótokaiyampinkemba minéráíꞌ-ááígó awátinkainasa méranaawe súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Émbaramun-andafaken-kwaasi únda póta ímba fíꞌon-kwaasi taꞌótokaawe. Nóra séwa awátinkainiye sénó suwaná ");
INSERT INTO auy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ísu séna éraiꞌa simátimeꞌa súne. Aoisaambó owí mináóísáámbó owí kembá wétaꞌotoraiye. Kesí kísau úwoi máíwae sésa méyámbaꞌmai tíkaantenkaan-kwaasin-owe. ");
INSERT INTO auy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Miyán-kwáásí kawáágóní naaúmpaꞌa ímba maéꞌmaeꞌa ónááfo wenáánintomba maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kemó Maníkón-ááninkomo awátínkáanaꞌo éꞌa awátuweꞌa méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Émbaramun-andafaken-kwaasi ombánifo kesáái ímba tirumpimbá wéraintafeꞌa tufuwónae wésewe. ");
INSERT INTO auy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kesifomó aráásímín-aai wésumpo kentifomó simátímín-aai wésewe súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Émbaramu kentáásifowan-iye suwaná Émbaramun-andafakewimo ékaa Émbaramumo uráintemba miyá owaisinó. ");
INSERT INTO auy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Maníkó éraiꞌ-aaimo simásímakaimba simátimunaꞌa tufuwónae wésewe. Émbaramu ímba miyá uráifo ");
INSERT INTO auy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","kentifomó uráintemba miyá wéowe súwasa miwí sésa ímba kesinó aankaróꞌó únkakemba kentáá masínkaraiye. Kentáásifowa mimbóráwígó Maníkón-iye suwaná Ísu séna ");
INSERT INTO auy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Maníkómpákémbá kunkáunda póꞌa Maníkón-árááꞌo ékaa kentirumbá síméwaisino. Ímba kesí imáyáafinkemba kunkáumpo Maníkó siꞌmáráísaꞌa kunkáumne. ");
INSERT INTO auy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kemó súnda nóra séra ímba wéisaao. Kesááigo umbaí wétiyaiye. ");
INSERT INTO auy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kemá waántáwankon-araaꞌa póꞌa wenarááíma waénae wésewe. Wemá áwáurakemba tínkamisasa waási puwéꞌówin-iye. Éraiꞌo sí-tántááꞌá ímba wempímbá wéraisana karokaroꞌ-ááígóní afowáíꞌa wéiwain-iye. ");
INSERT INTO auy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Miyáumai éraiꞌ-aaimo simátimundasafeꞌa éraiꞌ-aain-iye ímba wésewe. ");
INSERT INTO auy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kemá ímba sáwíꞌa uráunda wéisaawe. Arupíse-aai simátimunaꞌa ímba éraiꞌe wésewe. ");
INSERT INTO auy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maníkón-árááꞌa pósa wenáái isésa méraafo kembiwí ímba Maníkón-árááꞌmaariniꞌa uréꞌa póꞌa wenáái ímba ísaraawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ísu simátimuwasa Yúndaa-oraaꞌ-waasi karaánááꞌa ankésa sésa éraita súne. Sámériyaa-waasi ónana sáwí-amutanko enarumpimbá méraisampo minááí siyáane suwaná ");
INSERT INTO auy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ísu séna sáwí-amutanko ímba kesirumpimbá méraiye. Kesifon-áwíꞌa óraaꞌa úndanifo kesúwíꞌa sáwíꞌa uwásínkááwe. ");
INSERT INTO auy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kesúwíꞌa ímba óraaꞌ-iꞌa ónae. Maníkó kentáféna séna kawe-kísáú máénda póꞌa enáwíꞌa mósá óraaꞌa uwánkanaumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Éraiꞌo senda-ááí kesáái ísámai kaweꞌó íyawi ímba puwónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yúndaa-oraaꞌ-waasi sésa sénda-aai sáwí-amutambo enarumpimbó méraimba éta ísaraumne. Émbaramu puwúwasa Maníkón-aai simátímakowi púwúmbanifo emá sé kesáái ísámai kaweꞌá íyawi ímba puwónááwe wésene. ");
INSERT INTO auy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kentáásifowa Émbaramu puwúwasa Maníkón-aai simátímakowi pukáambanifo miwí íyáákainono. Emó sénda nááfakewiyaꞌono suwaná ");
INSERT INTO auy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ísu séna kesúwíꞌo mósá maráúndarakaa úwoisambanifo kesúwíꞌo mósá maráínda kesifomán-iye. Wentáféꞌa séꞌa kentáásí Fasiꞌaénkón-iye wésewe. ");
INSERT INTO auy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kemá wembá wéawanaumpo kembiwí ímba wéawanaawe. Kemó séꞌo ímba wéawanaumnemo súndarakaa kembiwímó ontembá karoꞌ-wáásí mérausino. Éꞌa wéawaneꞌa póꞌa wenáái mósá wémaraumne. ");
INSERT INTO auy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kentifo Émbaramu kemó marapáꞌó kúmónda-aai iséna aamoí éna kembá suwánéna wenarunkó kaweꞌá uráiye súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yúndaa-oraaꞌ-waasi sésa emá ifóꞌ-wáásígó éma ímba kaeꞌ-wááí úmai siyáánkai-aatai maisukáampo emá séma Émbaramumba awánaraumne wésene suwaná ");
INSERT INTO auy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ísu séna éraiꞌa simátimeꞌa súne. Émbaramumbo ímbo maꞌánkaronkaꞌa kemá maéꞌéúndaniye súwasa ");
INSERT INTO auy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","minááísáfésa tufuwónae sésa óntamba máúwana Ísu aúpáꞌá óraaꞌ-amaan-daumpakemba kárúwaguraiye. ");
INSERT INTO auy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ísu kúmba moóráwigomba anówama aúgafitamba maꞌánkarowimba awánésa ");
INSERT INTO auy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","wení kísau-waasi áísai esa sésa óraakoo nááwani aoisaankóní anondááwa aúramba kafíkáiyo. Wendégówáꞌí anófoinegowaꞌiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ísu séna ímba wení aoisaankówé anófoiti aoisaankówén-ifo Maníkóní kawe-kísáú wenaneꞌá paápé ínasa awánáíyantafena aúramba kafíkáiye. ");
INSERT INTO auy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Siꞌmákaiwaini kísausa máéno. Sámo kainkáꞌó kísaumo wémaewanamo nóꞌwaambo isanamó kísaumo máén-kanaamo taíꞌáíntemba miyáumai kísau maúnda-kanaa taiꞌáínda póta káféꞌa Maníkóní kísausa maénaumne. ");
INSERT INTO auy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Marapáꞌó méraunda waási sáma kátinkaundawi úne séna ");
INSERT INTO auy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","mararáꞌá awiyááíma wiꞌmaréna mindásamba toiyaambá úmarena aúrankaꞌa aꞌmaréna ");
INSERT INTO auy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","simámena séna nonkwaaúnkón-áwíꞌa Síróámu-waaumpimba máperaao súwana miyá uráiye. Síróámuwemo súmba wenááifinkemba waéꞌmai séna aiꞌmáráín-kwaune súwana mápetuwena aúramba awánamai kaweꞌá éna túwasa ");
INSERT INTO auy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","wení naaópaken-kwaasiye fíꞌon-kwaasiye awánésa sésa wemá aampaꞌó ménamo óntantafenamo inaimó símasimaꞌo iwáíyáꞌiyo suwasá ");
INSERT INTO auy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","tuwímbai sésa ewé wemán-iye suwasá tuwímbai sésa ímbanifo wen-óiꞌmaisan-kwaasin-iye suwaná wemá séna ímbanifo kemá úne súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","áísai esa sésa nóra ónanawa aúramba kaweꞌá uráiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","moóráwigon-awiꞌa Ísu wemá awiyáái wiꞌmaréna mindásamba toiyaan-úmarena súrankaꞌa aꞌmaréna simásimena séna Síróámu-waaumpimba máperaao sisaꞌá iséꞌa koperáúnana súramba kaweꞌán-iye súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","áísai esa sésa nááfara kuráiyo suwaná ímba awánaraumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Simátimuwasa áíꞌmaesa ámáán-kawaa-waasifaꞌa máánkówana Ísu toimá aúrankaꞌa aꞌmaréna aúrambo kaweꞌó uwánkon-kanaa Yúndaa-waasi ámáán-aaimo ísón-kanaa kísau aaraamó makón-kanaa úwasa aúramba kaweꞌó uwánkarowimba áíꞌmaesa ámáán-kawaa-waasifaꞌa máánkówasa ");
INSERT INTO auy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","áísai esa sésa nóra ónanawa aúramba kaweꞌá uráiyo suwaná séna toimá súrankaꞌa asínkáísaꞌa máperaunana súramba kaweꞌá uwásínkaraiye súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ámáán-kawaa-waasi tuwímbai sésa saagaan-kánááráꞌó miyámó uráimba ímba Maníkómpákémbá kunkáiye suwasá tuwímbai sésa sáwí-imayaawaraꞌ-waasigomo énaraantasi ímba kanaaꞌá kawe-kísáú-wááméꞌá isinó suwasá imáyáa tuwínkaaꞌa ésa ");
INSERT INTO auy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","sésa enaúramba kaweꞌá uwánkaraifo wentáfé nóin-imayaawa ónó áísai esa suwaná Maníkón-aai simátímíwain-iye súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","énifo minYúndáá-órááꞌ-wáásí aúrambo kaweꞌó uwánkontafesa ímba imáyáa umbá anófoi táántowasa ");
INSERT INTO auy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tuyasá tísai esa sésa kenkáítí tááninaꞌiyo. Énifo aúgafitana maꞌánkaraayanaꞌiyo. Nóra énawa aúramba wéawanaiyo suwasaráí ");
INSERT INTO auy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","sésarai kesáánimban-iye. Maꞌankááwayamba aúgafitamban-iye. ");
INSERT INTO auy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Énifo káféꞌa nóra isanawá aúramba kaweꞌ-úmai awánáíyómpo wemá óraakon-ifo áísai íyana weyááríkaꞌa simátimino siyááye. ");
INSERT INTO auy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ááéma Yúndaa-oraaꞌ-waasi sésa Ísuntafesa Maníkómó íyáfasinankaraiwai wéamuꞌmaraundawin-iye síyawi ámáán-daumpaꞌa ímba iyónááwe sumbá póna minánófóí Yúndaa-oraaꞌ-waasisafena tááꞌa úwasarai ");
INSERT INTO auy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","sésarai óraakon-ifo wembá áísai oro siyááye. ");
INSERT INTO auy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Simátímúyasa anekaꞌá aúramba kaweꞌó uwánkarowimba áántowana túwasa sésa minkwáásígó sáwí-imayaa wéiye sewatá ísaraunda po Maníkón-aúrankaꞌa arupíse úmaisa simásimiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","séna sáwí-waasiyaꞌi kaweꞌ-wáásíyáꞌíyo kemá ímba isáúmne. Moórá-tantaatafeꞌa isáúnda súramba kafíkuraimbanifo káféꞌa súramba wéawanaumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","nóraumaiya aúramba kaweꞌá uwánkaraiyo áísai esa suwaná ");
INSERT INTO auy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","séna éꞌa simátímakaumpo ímba ísaraawe. Anekará simátimenara isánááo. Wenaráái waénaemo séꞌa wení kísau-waasi-iꞌa ónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","karaánááꞌa ankésa sésa emá wenaráái wéwaempo kesáá Mósese arááísa wéwaraumne. ");
INSERT INTO auy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Maníkó Mósesemba aaí simámakaifo minkwáásí nááfaken-kwaasiyaꞌiyo suwaná ");
INSERT INTO auy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","miwá séna fíꞌonkaꞌmaꞌmai-tantaaꞌan-iye. Súramba kaweꞌá uwásínkaraifo kembiwí séꞌa nááfaken-kwaasiyaꞌiyo wésewe. Mindá fíꞌonkaꞌmaꞌmai-tantaaꞌan-iye wésune. ");
INSERT INTO auy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","33","Wemó ímbo Maníkómpákémbó kunkénaraa ímba miyá uráisino. Maníkó sáwí-imayaamo owí táái ímba wéisaifo wení kísaumo wémaewi-taai wéisaiye. Maníkón-áwíꞌo mósá márááwi-taai wéisaiye. Maambárámó úmaronkakemba ímba moórá aúgafitan-kwaasi méraisana kaweꞌá uwánkaraiye sewaꞌá ísaraumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","enanó aampaꞌá maꞌánkaraisa po úwoifaken-kwaasi éma enáái kentáá kaweꞌ-wáásísá wésimasimendasaanifo ámáán-daumpakemba kárúwaao suwaná kárúwaguraiye. ");
INSERT INTO auy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Minkákémbá aiꞌmátukon-aai Ísu iséna ayaafáí úmai awánéna áísai ena séna wíyómpakemba waási úrankonkaꞌa amankúnkúmba wéono súwana ");
INSERT INTO auy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ísuntafena séna óraakoo emó sénda nááwawaꞌiyo. Simásímínaꞌa simankúnkúmba onó súwana ");
INSERT INTO auy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ísu séna éꞌo suwánáánda kemá úne súwana we séna ");
INSERT INTO auy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Fasiꞌaénkóo enkáꞌá simankúnkúmba úne séna kífaena wen-ímáyáá mósá makáiye. ");
INSERT INTO auy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wen-ímáyáá mósá marówana Ísu séna marapáꞌá kunkáunda pósa waási afufuntambá tuwínkaaꞌa ónááwe. Túrambo kafíkáindawi túramba kaweꞌ-úmai awánáíyasa túrambo awánaawi túramba kafiyíníye súwasa ");
INSERT INTO auy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ámáán-kawaa-waasi tuwímbaimo mérowi isésa áísai esa sésa ewá kentáásáféwa túramba kafíkáiwai owéwá wéseno suwaná ");
INSERT INTO auy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ísu séna túrambo kafíkáiwaimo méraankakaa kentí sáwí-imayaagoni méyámbá ímba máéwaisino. Éta awánáúmnemo sentáféna kentí sáwí-imayaagoni méyámbá wéraiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ísu séna éraiꞌa simátimeꞌa súmpo ísáaro. Sipisípi kusaifáꞌó kónae síyawi ímbo sipisípigoni ontafímbó íyáférémbo kusaiyákémbó íyámaatesamo ésa miwí umén-kwáásíyé sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sipisípiyaꞌo káráwiyaiwai ontafímbá wéiyaferaiye. ");
INSERT INTO auy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Miyáumai ontarákén-káwáágó ontá tiyánkáísana íyáferena wení sipisípi túwíꞌa itáántaisasa wenáái isésa wempáꞌá kowaná ");
INSERT INTO auy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","sipisípi kusaifákémbá tíꞌmaena aifaꞌá wisasá wenáái isésa wéaraaiwaewe. ");
INSERT INTO auy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Énifo fíꞌon-kwaasi-taai ímba isésa arááíwaiyamba inkaisésa wété wéowe ");
INSERT INTO auy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ísu miyá simátimuwasa minááígóní áwáuma ímba ísaraawe. ");
INSERT INTO auy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Minááígóní áwáuma ímba ísóntafena Ísu séna éraiꞌa simátimeꞌa súne. Sipisípigoni ontamá kemá úne. ");
INSERT INTO auy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ímbo kunkáundaraꞌo tuwímbaimo tiyáawi umén-kwáásín-owe. Miwí táái sipisípisonko ímba ísaraawe. ");
INSERT INTO auy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kemá ontamá úne. Kempáꞌó tíyaꞌo éꞌa íyáféráaro senasá íyáferaiyaꞌa káráwiyonaumne. Tómbó náíyantafesamo ésa kúwákárúwaresa násuwesa anekaꞌá íyáferanaawe. ");
INSERT INTO auy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Umén-kwáásímó tíyawimo ésa waási tínkambai sáwíꞌa uwátinkaiyambanifo kemá kunkáunda pósa fíꞌonkaꞌmaꞌmai kaweꞌá úmai maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sipisípiyaꞌa kaweꞌ-úmaimo káráwiyaundawi úne. Sipisípiyaꞌo kaweꞌ-úmaimo káráwiyaiwai séna kesí sipisípi túwaꞌnai ónaumne séna puwíníye. ");
INSERT INTO auy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Énifo óntantafesawe sésa sipisípiyaꞌa káráwiyaawi áwáífiyaa in-íyánkómbá awánésa sipisípi ifátiyuwesa kówana sipisípisomba fámai watúwáísasa kóítawaaꞌa uwáguraawe. ");
INSERT INTO auy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Miwí sipisípiyaꞌo káráwiyi-imayaa tuwésa óntamo maíyan-imayaa wéowe. ");
INSERT INTO auy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Sipisípiyaꞌa kaweꞌ-úmaimo káráwiyaundawi úne. Kesifo kembá suwíyaisaꞌa kemá kesifombá awíyáúnana miyámó úndantemba kesí sipisípi seyaafáꞌá tuwíyáúnasa kembá wésuwiyaawe. Kesí sipisípi túwaꞌnai ondasáféꞌa póꞌa kemá puwónaumne. ");
INSERT INTO auy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kesí sipisípi tuwímbai fíꞌon-kusaifaꞌa méraamba póꞌa kotíyáanasa kesáái isésa tésa mimbóráíꞌa úmai méraiyaꞌa seyaafá-sípísípíyáꞌá káráwiyonaumne. ");
INSERT INTO auy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","18","Púwóndafinkemba íyáfasinaanda-imayaa kesifomá símísaꞌa kemá ewé súndasafena wenarumbá wésimiye. Kemó ímbo ewémó súndarakaa ímba kanaaꞌá sínkamowisino. Kesí imáyáafinkemba póꞌa kanaaꞌá puwónaumne. Púwóndafinkemba kanaaꞌá íyáfasinanaumne. Kesifomá simásimena séna miyán-uwo séna miyámó onda-fásíꞌáémbá símakaiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ísu minááímó súntafesa Yúndaa-oraaꞌ-waasi imáyáa ésa tuwínkaaꞌ-uwasá ");
INSERT INTO auy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tuwímbai sésa sáwí-amutamba arumpimbá méraintafena uwó-íꞌa wéena siyé. Ke nóra séra wenáái wéisaao suwasá ");
INSERT INTO auy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","tuwímbai sésa sáwí-amutambo arumpimbó mérainkakaa ímba miyán-ááí sisinó. Sáwí-amutambo arumpimbó mérainkakaa ímba aúgafitan-kwaasi aúramba kaweꞌ-úmai awánéna méraisino siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yúndaa-waasi óraaꞌ-amaan-dambo uráan-kanaamo túntemba Yérúsaremu-naopaꞌa tanómba kaúfúnkaꞌa minkánáá táwi-kanaa póna túwana ");
INSERT INTO auy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ísu óraaꞌ-amaan-daumpaꞌa ména Soromoní áúwimai úmakopaꞌa kúwasa ");
INSERT INTO auy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yúndaa-oraaꞌ-waasi túwaandu ésa taúkúmaresa áísai esa sésa entáféta sáwífaꞌ-imayaasa wéune. Maníkómó íyáfasinankaraiwai wéamuꞌmaraundawisaama ewá ónómpo arupíse úmai sinatá ísáano suwaná ");
INSERT INTO auy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ísu séna simátimunaꞌanifo ímba ísaraawe. Kesifo simásímakain-kisau wémaunda póna kesí áwáuma aforaꞌá wépaaꞌiye. ");
INSERT INTO auy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kembiwí ímba kesí sipisípisomba póꞌa kesááisafeꞌa ímba timankúnkúmba wéowe. ");
INSERT INTO auy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kesí sipisípi tuwíyáúnasa kesáái isésa wésiraaiwaewaꞌa ");
INSERT INTO auy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","imáyáa timúnasa aúíꞌa úmai maéꞌmaeꞌa ombá pósa ímba taiꞌánááwe. Kawáánúndafinkemba ímba kanaaꞌá tatafisénááwe. ");
INSERT INTO auy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kesifomá símakaimba wení fasiꞌaénkó seyaafá-fásíꞌáénkómbá íyáákaisasa kesifomá kawáánimpakemba ímba kanaaꞌá tatafisénááwe. ");
INSERT INTO auy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kesé kesifoéꞌa mimbóráíꞌa wéuye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Súwasa Ísumo sún-aaisafesa Yúndaa-oraaꞌ-waasi anekaꞌá tufuwónae sésa óntamba máúwana ");
INSERT INTO auy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ísu simátimena séna kesifomá simásímakain-kisau kawe-kísáú wémaunaꞌa wéawanaafo nóin-kisauwa maúndasafera sínkamonaao súwasa ");
INSERT INTO auy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ímba kawe-kísáúsáféta tufumónaeta wéumpo Maníkómbá karaánááꞌo ankáándasafeta tufuwónaumne. Marapáꞌ-wáásígó séma Maníkó únemo séndasafeta tufuwónaumne suwaná ");
INSERT INTO auy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Ísu séna Maníkón-aai aúfáífimba ímbo karoꞌ-ááímó wérain-aufai agaimaréna séna Maníkó séna kembiwí maníkón-owe siyáiye moóráwigo agaimaréna siyáiye. Maníkón-aai simátímakowisafena séna maníkón-owe siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kesifomá simásinkena siꞌmákaisaꞌa marapáꞌá kunkáumpo Maníkón-ááninko úne súndasafeꞌa Maníkómbá ímba karaánááꞌa wéankaumne. ");
INSERT INTO auy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kesifoní kísaumo ímbo wémaundarakaa kentáféꞌa wíyómpakemba ímba kunkáiye sewaisinó. ");
INSERT INTO auy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kesifoní kísau wémaumpo kentáféꞌa wíyómpakemba ímba kunkáiye séꞌa ímba timankúnkúmba ombánifo kesí kísausafeꞌa Maníkóní kísau wémaiye séꞌo éꞌa mindásafeꞌa séꞌa wesé afowáeꞌa mimbóráíꞌa wéoye sénááwe Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","anekaꞌá taꞌótoranae sésa umbá taꞌótoꞌmai tofíyántuwowana kóuraiye. ");
INSERT INTO auy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ísu miwí tiyuwéna Yóndani-nomba kofaténa ááéma Yónimo nombó maitínkaropaꞌa komérowasa ");
INSERT INTO auy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","waásisomba túwaandu ésa sésa Yóni ímbo awánáúnda-kisau maiyáimbanifo minkwáásísáféna simásímakain-aai éraiꞌ-aai siyáiye suwasá ");
INSERT INTO auy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","sáwífaꞌ-waasi Ísuntafesa timankúnkúmba ésa Maníkómpákémbá kunkáiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Moóráwigon-awiꞌa Rásarasi Pétáni-naopaꞌa mérowana áíꞌa úwasarai ámánaakai túwíꞌa Máríyaae Máátaaeꞌa mimbóráfáꞌá mésa ");
INSERT INTO auy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Máríyaa ááéma ásé-wiyumbo úm-basawemba Ísun-aísamaiyaꞌa fatíyena wenaꞌnóntáusamba uwátukain-ininko éna tuwaawisáwágómbá áíꞌa wéuwasarai ");
INSERT INTO auy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","minámánáákáí moóráwigontafesarai sésarai Ísumba kosimáme sé óraakoo emó arumbó ámakaandawimba áíꞌa wéiye kosimámuwo suyaná kosimámuwana ");
INSERT INTO auy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ísu iséna séna Rásarasimbo áíꞌo wéimba ímba ékaꞌa puwíndasafena áíꞌa wéifo Maníkón-áwíꞌwara ááninko súwíꞌwaraꞌo mósá maráíyantafena áíꞌa wéiye Ísu súmba ");
INSERT INTO auy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Máátaane Máríyaane Rásarasine wenarumbá tímakomba póna ");
INSERT INTO auy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","áíꞌo wéun-aai iséna kae-kánáá aánoꞌa maéna ");
INSERT INTO auy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","minkáꞌá wení kísau-waasisafena séna anekaꞌá Yúndiyaa-aempata kónaumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","sésa óraakoo Yúndaa-oraaꞌ-waasi óntantamba tufuwónae sésa wéopaꞌa isa anekaꞌá mináémpáꞌá kónae wésene suwaná ");
INSERT INTO auy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Ísu miwí simátimena séna kumeuꞌó isasamó kombá ímba sáma kaisasá pósa tanaambá wéfaafo sámo kaisasamó kombá ímba tanaambá wéfaawe. Miyámó ontembá isaꞌá káfé-kanaa kaweꞌ-úmai kísau maénaumne Ísu simátimena séna ");
INSERT INTO auy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","kentáásí waásigo Rásarasi aúmá wéraimba póꞌa íyáfasinankaandasafeꞌa kónaumne súmba ");
INSERT INTO auy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Rásarasi pukóntafena Ísu súmbanifo wení kísau-waasi imáyáa ésa aún-kwéraimba póna íyáfasinainiye-imayaa ésa sésa óraakoo kaweꞌá imbá póna áíꞌa éꞌankainiye suwaná ");
INSERT INTO auy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ísu aforaꞌá séna Rásarasi pukáiye. ");
INSERT INTO auy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Áíꞌo ipaꞌá ímba weséꞌo méraunda kaweꞌá imbá póta wempátáámó kondá suwánéꞌa kentáféꞌa timankúnkúmba éꞌa Maníkómpákémbá kunkáiye simásinkanaawe súwana ");
INSERT INTO auy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","wení kísau-waasifinkemba moóráwigon-awiꞌa Tómaasi moórá-awiꞌa Títímási mináwíkóní áwáuma amáántágaeꞌa wemá simátimena séna Yúndaa-oraaꞌ-waasi Ísumba tufuwónáámba póta weséta puwónaeta mifátá kónaumne Tómaasi siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Súwana Ísu Pétáni-naopaꞌo kúmba Rásarasi puwúwasa utámárówana éíyaimba waúnkaꞌa Ísu koísaraiye. ");
INSERT INTO auy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pétáni-naoꞌa Yérúsaremufaꞌa ewaaꞌá pósa ");
INSERT INTO auy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Máátaante Máríyaante tuwaawisáwágó pukóntafesa Yúndaa-waasisomba ifiꞌá kowétesa mérowana ");
INSERT INTO auy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ísu wétiyemo sumbá Mááta iséna wétupaꞌa kúwana Máríyaa naaúmpaꞌa mérowana ");
INSERT INTO auy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mááta Ísuntafena koséna óraakoo emó maankáꞌó méraandarakaa kesuwaawisáwágó ímba púwísino. ");
INSERT INTO auy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Káféꞌo Maníkómpáꞌó inaimó sinanamó éna miyá íníye-imayaa wéune súwana ");
INSERT INTO auy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ísu séna enawaawisáwágó pukáimpinkemba íyáfasinainiye súwana ");
INSERT INTO auy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mááta séna ánaaen-kanaa tínda pukáindafinkemba íyáfasinainiye-imayaa wéune súwana ");
INSERT INTO auy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ísu séna puwíyampinkembo wéiyafasinaawemo sewíní áwáuma kemá úne. Aúíꞌa úmai maéꞌmaeꞌo íyawini áwáuma kemá úne. Kesááisafesamo éraiꞌemo sésa kenkáꞌá timankúnkúmbo íyawimo ésa puwíyambanifo íyáfasinanaawe. ");
INSERT INTO auy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mésa kesááisafesa éraiꞌe sésa kenkáꞌá timankúnkúmbo íyawimo ésa ímba puwónááwe. Mindásafe emá éraiꞌewa wéseno Ísu Máátaantafena súwana ");
INSERT INTO auy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","séna Fasiꞌaénkóo emá Maníkómó íyáfasinankaraiwai wéamuꞌmaraundawi óne. Maníkón-ááninko óne. Marapáꞌá kúmíndawi emá óne Mááta siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mááta simásuwena wéna áúnkontafena ukutóípínkémbá simámena séna óraako wétena wéaantaiye súwana ");
INSERT INTO auy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Máríyaa iséna minúwóíyáán-úmai íyáfasinena wétupaꞌa kúmba ");
INSERT INTO auy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ísu Máátaamo taawánónkaꞌa ména ímba naaópaꞌo túmba ");
INSERT INTO auy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Máríyaa íyáfasinenamo kúmba Yúndaa-waasi ifiꞌó wéton-kwaasi awánésa imáyáa ésa sésa Rásarasimbo utámakaapaꞌo ifiꞌó táíndasafena wiyé sésa arááíwaꞌmaesa kumbá ");
INSERT INTO auy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ísumo méronkaꞌa Máríyaa wéna óraakon-iye séna aísamaifimba kífaena séna Fasiꞌaénkóo emó maankáꞌó méraandarakaa kesuwaawisáwágó ímba púwísino súwasa ");
INSERT INTO auy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Máríyaawe wenánaaenkaꞌo arááíwáún-kwaasiye ifiꞌó tombá Ísu tuwánówana arumbá éna umbai-tántáákó arumbá sáwíꞌa úwana ");
INSERT INTO auy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","tísai ena séna náánkara utámakaao súwasa óraakoo taawánaao suwaná ");
INSERT INTO auy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ísu ifiꞌá tówasa ");
INSERT INTO auy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yúndaa-waasi awánésa sésa pukáiwaimba aruntaféna uwánkáíye suwasá ");
INSERT INTO auy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","tuwímbai sésa aúgafitan-kwaasi aúramba kaweꞌó uwánkaraimbanifo nóra sénawa ímba asófankaisanawa pukáiyo siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Suwaná Ísu áfááraumai arumbá úwana utánkaropaꞌa kúmba óntan-aifimba mámakesa óikaꞌa óntantamba awáá uwásukowana Ísu koawánéna ");
INSERT INTO auy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","séna óntamba maisúwáaro súwana Mááta pukówin-ámánaako séna Fasiꞌaénkóo éíyain-kanaaraꞌo wáímba póna ánkúteꞌa íníye súwana ");
INSERT INTO auy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ísu séna éꞌa simámakaumne. Kesááisafemo éraiꞌemo sémo kenkáꞌó amankúnkúmbo émo e Maníkóní kawe-kísáú awánáínone súwasa ");
INSERT INTO auy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","óntamba maisúwówana Ísu wíyómpaꞌa awánéna séna kesifóo kesáái isáándasafeꞌa súwiyo súne. ");
INSERT INTO auy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kesáái isáámpo maanááí súnda pósa maankáꞌó méraan-kwaasi kentáfésa éraiꞌa Maníkó aiꞌmákaisana kunkáiye sénááwe simásuwena ");
INSERT INTO auy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","óraakaꞌa séna Rásarasiyo tiyó súwana ");
INSERT INTO auy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","pukówi íyáfasinenamo túmba ampantasámbá úsúmai ánáan-kwisuwesa aíyayaankaꞌa káráꞌumaresa óikaꞌa káátamaresa miyá úmakon-ampantawaraꞌa túwana Ísu séna awátúwéwana méraino siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yúndaa-waasisomba Máríyaampaꞌo kun-kwáásí Ísumo úmba awánésa timankúnkúmba ésa Maníkómpákémbá kunkáiye suwasá ");
INSERT INTO auy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","tuwímbai ímbaniye sésa ámáán-kawaa-waasifaꞌa kosésa Ísumo ún-aai simátímúwasa ");
INSERT INTO auy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","minááí isésa ámáán-kawaa-waasiye óraaꞌ-amaan-kisau-waasiye aaimó ísón-kwaasi táántesa sésa ímbo awánáúnda-kisau wémaimba póta nórasaawa ónaumno. ");
INSERT INTO auy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Úwoimo túwáananasaamo éna miyán-kísáú wémainasa pósa seyaafáꞌnánká wenááisafesa timankúnkúmba ónááwe. Minkáꞌá Rómu-kamani-waasi tésa óraaꞌ-amaan-damba tatawísísuwesa kentáá seyaafáꞌnánká sáwíꞌa uwásínkáafonifo nórasaawa ónaumno suwaná ");
INSERT INTO auy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","moóráwigon-awiꞌa Káyafaasi minkánáá aifaꞌ-ámáán-káwáágó póna wemá séna ímba kaweꞌ-úmai wéisaawe. ");
INSERT INTO auy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yúndaa-waasi seyaafáꞌá púwófo séna moóráwigo puwíníye Káyafaasi siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Minááímó súmba ímba wení imáyáafinkemba siyáifo minkánáá aifaꞌ-ámáán-káwáágó mérontafena póna Maníkó imáyáa amúwana paápé úmai séna Yúndaa-waasi seyaafáꞌ-wáásísáféna ísámai Ísu puwíníye. ");
INSERT INTO auy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ímba Yúndaa-waasi aantemba Maníkón-árááꞌan-ofo fíꞌo-fiꞌom-barafaken-kwaasi mimbóráíꞌa úmai méraiwae séna Ísu puwíníye. ");
INSERT INTO auy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Káyafaasi minááí súwasa minkákémbá Yúndaa-oraaꞌ-waasi Ísumbo tufuwíyan-aai suwaná ");
INSERT INTO auy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","mindásafena Ísu ímba Yúndaa-oraaꞌ-waasi túrankaꞌo númba tiyuwéna máásai-maragoni awáífáꞌá Éfáráímu-naopaꞌa kúmba wení kísau-waasiseꞌa koméraawe. ");
INSERT INTO auy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Komérowana tíyótaimo í-tánón-kánáá ampáámbá úwasa pósa tirumbó kaweꞌó íyanesa naaóꞌ-naokemba Yérúsaremu-naopaꞌa kotúwaandu ésa ");
INSERT INTO auy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ísuntafesa móawana-meawana ésa óraaꞌ-amaan-daumpaꞌa túwaandu ésa sésa tanómbo opaꞌá tíní ína tíníyo siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Óraaꞌ-amaan-kisau-waasiye ámáán-kawaa-waasiye sésa Ísumbo awánésamo ésa simásimiyata taꞌótóráano sumbá mindásafesa úwoi-waasi sésa tanómbo opaꞌá tíní ína tíníyo siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tíyótaimo í-tánón-kánáá kárikaꞌa túwana afaꞌmóráe-kanaa úwoi wérowana Ísu Pétáni-naopaꞌa wéna pukómpinkemba íyáfasinankaraiwain-awiꞌa Rásarasini naaópaꞌa kúwasa ");
INSERT INTO auy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ísuni tómbá kúfuꞌumarowana Ísuwe Rásarasiyeꞌa tómbó náíyapaꞌa méroyana Mááta mintómbá maimái tímaꞌmaena kúwana ");
INSERT INTO auy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Máríyaa asaa-wiyúmbó úm-basawemba óraaꞌ-ontankakemba méyámbakena Ísun-aísamaiyaꞌa sáwífaꞌa fatímarena wenaꞌnóntáusamba uwátuwowana mimbásáwén-kwíyúnkó óraaꞌ-wiyumba naaúmpaꞌa iyúwana ");
INSERT INTO auy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","moóráwigon-awiꞌa Yúndasi-Ísakerioti séna nóra sénawa mimbásáwémbá timénamo óraaꞌ-ontamba 300 kina maiyénamo ímbo óntamo makáan-kwaasi tuwín-timeraane séna minááímó siyáimba Ísuni pintaruꞌó maíndawi siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ímba ónta-iyain-kwaasi-imayaa éna siyáifo wemá Ísuni waásiti óntankaꞌa káráwiyowi uméntéꞌo úwai póna minóntámpínkémbá maénae séna minááí súwana ");
INSERT INTO auy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ísu séna minínínkómbá étúwéwana úwoi miyá íno. Púwónanamo asinkáíndasafena miyá wéiye. ");
INSERT INTO auy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ímbo óntamo makáan-kwaasi keséꞌa aasiyaasí maéꞌmaeꞌa íyaꞌa túwaꞌnai ónááfo kemá keséꞌa marapáꞌá ímba maéꞌmaeꞌa ónaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Súwasa Pétáni-naopaꞌa Ísu méraiye sumbá sáwífaꞌ-waasi Yúndaa-waasi isésa Rásarasi pukówana íyáfasinankarowinteꞌa kotuwánánae sésa kuráa. ");
INSERT INTO auy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Rásarasimba íyáfasinankarontafesa pósa Yúndaa-waasi miwítí óraaꞌ-waasi tiyuwésa Maníkómpákémbá kunkáiwaimpata kónae sésa suntáfésa óraaꞌ-amaan-kisau-waasi Rásarasimba tufuwíyan-aaiwaraꞌa siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Fénáíkaamba ásé-masawemba aꞌánkaraifo káfékaamba Yérúsaremufaꞌa Ísu tíníye sumbá waásisomba minááí isésa ");
INSERT INTO auy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","taaénáma taráꞌmaesa aampakémbá koaiyésa óraakaꞌ-oraakaꞌa sésa Fasiꞌaénkó aiꞌmáráísana kunkáiwaimba Maníkó kaweꞌá wéuwankaiye. Wení Ísareri-waasiti kawáágón-iye wenáwíta mósá maráúmne suwaná ");
INSERT INTO auy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","moórá-poigon-awiꞌa tónkigo Ísumba ayááꞌmaena túmba ");
INSERT INTO auy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","naaófáꞌá Maníkón-aai aúfáífimba agaimaréna séna Sáíyóni-naopaken-kwaasi tááꞌa ifó kentí kawáágó wétiye. Tónki-araako ayááꞌmaena wétiye agaimarénamo siyóntemba miyáumai Ísu tiyáiye. ");
INSERT INTO auy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Minkánáá wení kísau-waasi ímba imáyáa úmai táákaꞌa makónkaꞌa pósa Ísu pukómpinkemba wíyómpaꞌo iyúnkaꞌa táákaꞌa marésa sésa aúfáífimba wérainkaꞌa póna miyán-iye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ísuma Rásarasi pukómpinkembo íyáfasinankomba awánésa tuwímbai-waasi simátímúwasa ");
INSERT INTO auy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","isésa mindásafesa pósa aampakémbá koaíyówasa ");
INSERT INTO auy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","óraaꞌ-amaan-kisau-waasi keáímbá sésa seyaafáꞌnánká kentáá siyuwésa wenarááí-aantemba wéwaefo nórasaawa ónaumno siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yérúsaremu-naopaꞌa ámáán-aai isánae sésa Yúndaa-waasi kuwasá Kíríki-waasiseꞌa wésa ");
INSERT INTO auy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Fírípi Káríri-aempaꞌa Pétésáíta-naopaken-kwaasigompaꞌa tésa sésa Ísumba awánánaeta wétune suwaná ");
INSERT INTO auy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fírípi Éndurumba kosimámena áíꞌmaesarai Ísumba kosimámúyana ");
INSERT INTO auy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ísu séna kemá waási úrankomba kesúwíko óraaꞌo índasafena káféꞌa wépaaꞌiye. ");
INSERT INTO auy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Éraiꞌa simátimeꞌa súne. Ánáuntumbo úwoimo wérenamo éna ímba arambá iyáínífo ánáuntumba uꞌmárááwana aáénkarena áruma wiyéna sáwífaꞌ-aramba imái áfu káíníye. ");
INSERT INTO auy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Miyámó ontembá tirááímo táínda-iꞌo ésa ímba kaweꞌ-úmai méranaafo maambárárákén-ímáyáámó tuwáíyawi aúíꞌa úmai maéꞌmaeꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kentáfésa ení kísaumo maénae síyawi kembá sirááíwáéro. Miyámó íyawi keséꞌa méranaawe. Kesí kísaumo maíyawi kesifo kentúwíꞌa mósá maráíníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ísu simátimena séna kesirunkó umbaiséꞌa wétaimba póꞌa nóra sénaumno. Kesifóo maanúmbáí-tántááꞌó kempáꞌó tínda maisiyuwaaó ímba miyá sénaumpo kemá mindásafeꞌa kunkáumne. ");
INSERT INTO auy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kesifóo enáwíko óraaꞌa íníye súwana wíyómpakemba aaí séna éꞌa kesúwíꞌa óraaꞌa uráunda póꞌa anekaꞌá ónaumne súwasa ");
INSERT INTO auy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","méron-kwaasisomba isésa tuwímbai sésa wíyónaai siyé suwasá tuwímbai sésa Maníkóní kísau-waasi wíyómpakewi aaí wésimamiye suwaná ");
INSERT INTO auy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ísu simátimena séna minááímó ísáámba ímba kembó súwaꞌnai índanifo kembó túwaꞌnai índaniye. ");
INSERT INTO auy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Marapáꞌ-wáásímó aaifimbó maitinkáínda-kanaa wétiye. Marapáꞌ-wáásítí sáwí-kawaagombo watiyuwáínda-kanaa wétiye. ");
INSERT INTO auy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aaraa-táíyáꞌó mó tufusíyan-kanaa seyaafáꞌá imáyáa tíménasa kempátá ténááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Miyámó siyáimba aaraa-táíyáꞌá tufíyana puwíndasafena súwasa ");
INSERT INTO auy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","waásisomba isésa sésa Maníkón-aai aúfáífimba agaimaréna séna Maníkómó íyáfasinankaraiwai aasiyaasí maéꞌmaeꞌa íníye siyáifo emó sénda kemá waási úrankomba aaraa-táíyáꞌá mó tufusíyaꞌa puwónaumne wésempo emá nááwawa sé ewá sénó suwaná ");
INSERT INTO auy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ísu séna waási sáma kátinkaundawi úndanifo kárikaꞌa keséꞌa méranaumne. Waásimo kumeuꞌó in-áémpáꞌó kombá nááfaraꞌi wégowasa pósa ímba wéawanaawe. Kumeuꞌó in-tántáákó kempáꞌá tifó séꞌa sámo kátínkáípaꞌa méraaro. ");
INSERT INTO auy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sáma kaimbá póꞌa kentáféꞌa séꞌa kentáásí ságoma óne sembá póꞌa ságoni árááꞌmarimba úꞌmai méranaawe Ísu siyáiye. Ísu simátimena tiyuwéna aúpáꞌá méraiye. ");
INSERT INTO auy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Túrankaꞌa kawe-kísáú ímba awánaraan-kwaameꞌo uráimbanifo wentáfésa ímba timankúnkúmba ésa Maníkómpákémbá kunkáiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mindásafena naaófáꞌá Maníkón-aaimo simátímakowin-awiꞌa Áísáya siyáin-aai éraiꞌa siyáiye. Fasiꞌaénkóo kaweꞌ-ááí kosimátimunasa minááísáfésa ímba éraiꞌe wésewe. Ení fasiꞌaémbá aráátimendanifo ímba awánaraawe Áísáya agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ísun-aaisafesa ímba timankúnkúmba untáféna naaófáꞌá Áísáya agaimaréna séna ");
INSERT INTO auy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Maníkó túramba kafítúwáísasa pósa túramba ímba awánaraawe. Maníkó tááꞌa káúntuwaisasa pósa ímba ísaraawe. Maníkómó simbá miyá uráunda pósa kempáꞌá ímba tíyaꞌa sáwí-imayaa maitiyuwéꞌa kaweꞌá uwátinkanaumne Maníkó siyáiye Áísáya agaimaréna séna ");
INSERT INTO auy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ísuni sáma awánaraimba póna minááí agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yúndaa-oraaꞌ-waasi tuwímbai Ísuntafesa timankúnkúmba ésa Maníkómpákémbá kunkáiye sésa ámáán-kawaa-waasi ámáán-daumpaꞌa íyófo sésa aambá fáíꞌmaraafoniye sésa ímba aforaꞌá sumbá ");
INSERT INTO auy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Maníkó kesúwíꞌa mósá maráínkwae-imayaa ímbanofo waási tuwímbai kesúwíta mósá maráíwae-imayaa ésa miyán-ímáyáá umbá pósa Ísuntafesa éraiꞌe ímba aforaꞌá siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ímba aforaꞌá suwaná Ísu óraaka séna kesááisafesa éraiꞌe sésa kenkáꞌá timankúnkúmbo íyawi ímba kentáfésa aantemba ofo siꞌmákaiwaintafesawaraꞌa timankúnkúmba wéowe. ");
INSERT INTO auy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kesí áwáumo suwánaawimo ombá ímba ken-aantemba wésuwanaafo siꞌmákaiwainkwaraꞌa wéawanaawe. ");
INSERT INTO auy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Marapáꞌó kumúnda waási sáma kátinkaundawi únda pósa kenkáꞌá timankúnkúmbo íyawi ímba kumeuꞌó in-áémpáꞌá méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kesááimo ímbo ísámai kaweꞌó owí aaifimbó maitinkáí ímba kemá úne. Marapáꞌ-wáásí ímba aaifimbó maitínkáandasafeꞌa kumúndanifo sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkanaeꞌa kunkáumne. ");
INSERT INTO auy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ánaaen-kanaaraꞌa kesáái isésa tínaaembo uwásinkaiyawi sésa kaweꞌ-ááí sínaaemba uwámakaundaniye sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ímba kesí imáyáafinkemba súmpo kesifo siꞌmákaiwai simásímakain-aai súnda póꞌa ánaaen-kanaa tínasa sésa kaweꞌ-ááí sínaaemba uwámakaunda ímbo oráámbá uráundaniye sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kesifon-aai aúíꞌa úmai maéꞌmaeꞌo íyan-aain-iye. Súnda-aai kesifo simásímakain-aai simátimune Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tíyótaimo í-tánón-kánáá aafáyáaraamba úwana káfékaamba Ísu imáyáa éna séna marapáꞌá tuwéꞌa kesifompáꞌó kunuweréꞌo íyónda-kanaa tiyé séna marapáꞌ-wáásí wenááimo ísón-kwaasi áfááraumai imáyáa tiména miwísáfénawe séna puwíníye súwana ");
INSERT INTO auy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","waántáwanko Sáímonin-ááninkomba áwíꞌa Yúndasi-Ísakeriotimba Ísuni pintaruꞌá uwó-ímáyáá ámakowasa Ísuwe wení kísau-waasiye tómbá wénowana ");
INSERT INTO auy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","afowámá seyaafá-fásíꞌáémbá ámakowana póna Maníkómpákémbá kunkáunda póꞌa kunuweréꞌa iyónaumne-imayaa Ísu éna póna ");
INSERT INTO auy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tómbá wénowana íyáfasinena paákákén-únánkwátói faúꞌmarena táúri káráꞌumaena ");
INSERT INTO auy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","táúfapimba nombá fatímarena wení kísau-waasi tísamai non-kwitinkéna táúrisamba uwátuwena ");
INSERT INTO auy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ísuma Sáímoni Pítaampaꞌa túwana séna Fasiꞌaénkóo ímba kesísamai non-kwisinkaaó súwana ");
INSERT INTO auy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ísu séna kemó úndama káféꞌa ímba wéisaanda po ánaaemba isáínone súwana ");
INSERT INTO auy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pítaa séna kesísamaimo non-kwisínkéndasafeꞌa aꞌáo símasimaꞌa ónaumne súwana Ísu séna enaísamaimo ímbo non-kwiyánkáanamo éma kesí waási-iꞌa ímba ínone súwana ");
INSERT INTO auy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pítaa séna Fasiꞌaénkóo ení waási-iꞌa ónae súmpo ímbo sísamai aantemba non-kwínda síyayaankwara siꞌnónkwáráꞌá non-kwiyuwó súwana ");
INSERT INTO auy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ísu séna nombó pékáawimo ésa ímba seyaafá-túfáꞌá non-kwiyónááfo tísamai aantemba non-kwiyónááwe. Kembiwí non-kwisaawaná kímborawigo ímba non-kwiyáiyemo súmba ");
INSERT INTO auy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ísu wení pintaruꞌ-wáásígómbá ísarontafena séna kembiwí non-kwisaawaná kímborawigo ímba non-kwiyáiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ísu simátimena tísamai non-kwitiyuwéna paákákén-únánkwátóimo faúꞌmaromba maimái úmaena ménamo tómbó némopaꞌa wéna tísai ena séna kemó úndawini áwáuma éra isaaó. ");
INSERT INTO auy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kentáféꞌa séꞌa uwáítáíꞌ-iwáí Fasiꞌaénkó ónemo sembá éraiꞌa miyán-kwáásí úne. ");
INSERT INTO auy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kemá kembó uwáítáíꞌ-úndawi kentí Fasiꞌaénkó póꞌa tísamaimo non-kwitinkáúndasafeꞌa kemá moórá-mora non-kwitínkáaro. ");
INSERT INTO auy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kemó kembó aráátimundantemba kembiwíwáráꞌá miyán-oro. ");
INSERT INTO auy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Éraiꞌa simátimeꞌa súne. Kísau-waasimo ésa miwítí óraaꞌ-waasigomba ímba íyáákanaawe. Tiꞌmákaiwain-aai maimaésa kosimátímakaawimo ésa tiꞌmákaiwaimba ímba íyáákanaawe. ");
INSERT INTO auy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Miyáumai kemó únda éꞌa awánaafo miyámó íyambo íyana tirunkó kaweꞌá íníye. ");
INSERT INTO auy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kempínkémbá ímba seyaafátáféꞌa súmpo kendé-íꞌo uwátinkaunda-waasi éꞌa tuwánaraumne. Maníkón-aai aúfáífimba agaimaréna séna keséꞌa moóráfinkembo tómbó naráiwai kesí pintaruꞌ-wáásín-iye agaimarénamo siyáimba éraiꞌa siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ímba paápé uráisaꞌa simátimunda póna ánaaemba paápé ínaꞌa kentáféꞌa timankúnkúmba éꞌa Maníkómpákémbá kunkáiye sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Éraiꞌa simátimeꞌa súne. Tiꞌmáráanasa wíyawi-taai ísámai kaweꞌó íyanten-úmai kesáái ísámai kaweꞌá ónááwe. Kesááimo isáíyanten-úmai siꞌmákaiwain-aai isánááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ísu simátimena wenarunkó umbaí tówana séna éraiꞌa simátimeꞌa súne. Kempínkémbá moóráwigo kembá namuro-wáásímá aráátiminiye súwata ");
INSERT INTO auy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","wení kísau-waasi moórá-mora wenaúfínayaafimba éta nááwantafenawa síyó séta ");
INSERT INTO auy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","wení kísau-waasigo Ísu kembá arumbá símakowi Ísuni ewaaꞌá méraawanana ");
INSERT INTO auy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sáímoni Pítaa kentáféna aúwáꞌnáán-kwaameꞌa éna séna nááwantafewa sénó sé áísai uwo súwaꞌa ");
INSERT INTO auy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","wení ewaaꞌá kífaeꞌa áísai eꞌa séꞌa Fasiꞌaénkóo emó sénda nááwaꞌiyo séwánana ");
INSERT INTO auy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ísu séna kemó tómbó nompín-tuꞌmaimo áménda-waasi wemán-iye séna tómbá maimaéna nompín-tuꞌmai miwámbá Sáímoni-Ísakeriotin-ááninkon-awiꞌa Yúndasimba amúwana ");
INSERT INTO auy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","mintómbá maúwana waántáwanko wenarumpimbá iyúwana Ísu simámena séna emó ónae sinda-íꞌa maaránkaꞌa uwó Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","tómbó wénesamo méron-kwaasi Ísumo sún-aaigoni áwáuma ímba ísámai kaweꞌá umbá ");
INSERT INTO auy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","sésa Yúndasi óntankaꞌo káráwiyowintafena Ísu séna ímbo óntamo makáan-kwaasi tuwímbai timiyó Ísu siyémá sésa tanómbo káúfón-kanaaratafesa sésa tómbá méyánuwo Ísu siyémá suwaná ");
INSERT INTO auy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yúndasi Ísumo amún-tomba maimaéna minúwóíyáán-úmai máápaꞌa kumúwana kumeuꞌá uráiye. ");
INSERT INTO auy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yúndasi máápaꞌa kumúwana Ísu séna káféꞌa waási úranko súwíꞌa óraaꞌa isaná kesí kísaugo Maníkón-áwíꞌa óraaꞌa íníye. ");
INSERT INTO auy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kesí kísaugo Maníkón-áwíꞌa óraaꞌo intembá káféꞌa Maníkó kesúwíꞌa óraaꞌa uwásinkainiye. ");
INSERT INTO auy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kesí iyámpóísono. Kárikaꞌa keséꞌa méꞌa tiyúwáanaꞌa siyaafáí ónááwe. Yúndaa-waasisafeꞌo éꞌo simátimeꞌo súndantemba kentáféꞌa séꞌa íyóndaraꞌa ímba kanaaꞌá iyónááwe. ");
INSERT INTO auy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aú-amaamba simátíménaꞌa kesirumbó timúndanten-úmai moórá-mora-waasi kentirumbá tíméro. ");
INSERT INTO auy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Moórá-mora kentirumbó timíyasamo ésa tuwánésa sésa Ísuni kísau-waasin-owe sénááwe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ísu simátimuwana Sáímoni Pítaa áísai ena séna Fasiꞌaénkóo nááfara iyínono súwana séna íyóndaraꞌa káféꞌa ímba sirááíwainompo ánaaemba sirááíwainone súwana ");
INSERT INTO auy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pítaa séna Fasiꞌaénkóo nóra séra káféꞌa ímba embá arááíwaenaumno. Ímba póꞌa áwaꞌnai eꞌa púwónana kaweꞌá íníye súwana ");
INSERT INTO auy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ísu séna áwaꞌnai eꞌa puwónaumnemo sénda kemá éraiꞌa simámeꞌa súne. Kokórigomo ímbo ááimo siyáindaraꞌa kaumbo-íkáꞌá kentáfé séma ímba awánáúnda-waasin-iye sínone Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ísu simátimena séna kentirunkó ímba sáwíꞌa ínaꞌa ímba óraaꞌ-imayaan-oro. Maníkómbá timankúnkúmba éꞌa kenkwáráꞌá miyán-oro. ");
INSERT INTO auy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kesifoní naaópaꞌa sáwífaꞌ-maruꞌa wéraiye. Ímbo miyámó uráinkakaa ímba simátimusino. ");
INSERT INTO auy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kemó iyúnda kentí maruꞌá itoꞌmayaa uwátinkanaeꞌa iyúne. Iyuweréꞌo kuntíꞌmaeꞌo íyónda kemó méraundaraꞌa iméranaawe. Miyá onaꞌá keséꞌa méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kemó iyúnda-amba éꞌa awánaraawe súwana ");
INSERT INTO auy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tómaasi simámena séna óraakoo emó iyónda-naopaꞌa ínta awánaraumne. Nóraumaisaawa aantá awíyánaumno súwana ");
INSERT INTO auy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ísu séna Maníkómpáꞌó iyíyan-amba kemá úne. Kemá éraikoni áwáuma úne. Kemá maéꞌmaeꞌo íyawini áwáuma úne. Kesifoní naaópaꞌa ímba úwoi iyónááfo kemá minámbá únda pósa iyónááwe. ");
INSERT INTO auy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kesí áwáumo suwánékaa kesifombá awíyaawisino. Káféꞌa wéawanaawe súwana ");
INSERT INTO auy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fírípi séna óraakoo enafombá aráásímínanasa kentáá kanaaꞌá íno súwana ");
INSERT INTO auy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ísu séna ayáátáákaꞌa keséꞌa méraundanifo emá kesí áwáuma ímba suwánaraane. Kesí áwáumo suwánaawi kesifombá éꞌa wéawanaafo nóra isawá enafombá aráásimiyo wéseno. ");
INSERT INTO auy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kemá kesifoéꞌa kááísamai méraunana kesifomá keséꞌa kááísamai méraiye. Minááísáféꞌa éraiꞌe seró. Ímba kesí imáyáafinkemba súmpo kesifomá keséꞌa ména wení kísau isaꞌá súne. ");
INSERT INTO auy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kemá kesifoéꞌa kááísamai méraunana kesifomá keséꞌa kááísamai méraimba póꞌa minááísáféꞌa éraiꞌe seró. Ímbo miyámó séꞌo éꞌa kesí kísau awánéꞌa séꞌa éraiꞌa wíyómpakemba Maníkómpákémbá kunkáiye seró. ");
INSERT INTO auy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Éraiꞌa simátimeꞌa súne. Kentáféꞌa timankúnkúmba éꞌa Maníkómpákémbá kunkáiye síyawi kemó úndanten-kisau miwíwáráꞌá maénááwe. Kesifompáꞌá iyéꞌa Maníkóní ámútankomba aiꞌmáráandasafena miwítí kísaugo kesí kísaugomba íyáákainiye. ");
INSERT INTO auy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ken-ímáyáámó éꞌo sísai íyaꞌo éꞌa miyá ónaumpo kentáféꞌa ísámai kesifon-áwíꞌa mósá maránááwe. ");
INSERT INTO auy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ken-ímáyáámó éꞌo sísai íyaꞌo éꞌa kemá miyá ónaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ísu minááí simátimena séna kentirumbó siméꞌo éꞌa kesáái ísámai kaweꞌá ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kesifombá áísai onaná karááꞌá tutinkáíndawimba aiꞌmaráínana kumbéna keséꞌa aasiyaasí maéꞌmaeꞌa íníye. Wemá éraikoni áwáun-iye. ");
INSERT INTO auy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Marapáꞌ-wáásí wembá ímba awánésa wenáái ímba wéisaamba pósa ímba kanaaꞌá sésa keséꞌa tamauwó wésefo keséꞌa ména kentirumpimbá maéꞌmaeꞌa imbá póꞌa wembá wéawanaawe. ");
INSERT INTO auy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kárikaꞌa tiyúwáandanifo ímba áwíyaraaꞌ-iyampoimo ontembá ónááfo iyuweránaumne. ");
INSERT INTO auy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kári-kanaa marapáꞌ-wáásí kembá ímba suwánánááfo kembiwí anekaꞌá suwánánááwe. Keséꞌa méraunda póꞌa kemá aúíꞌa úmai méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Minkánáá tínaꞌa séꞌa éraiꞌa afowáeꞌa ména keséta méraisata weséta méraumne miyá sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kesááimo taawiyafésamo kaweꞌó owí tirumbá siménááwe. Tirumbó simíyawi kesifoé keséꞌa sirunkáí timéyauye. Kesirumbó timúndawisafeꞌa símai aforaꞌá paápé úmai méranaumne súwana ");
INSERT INTO auy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yúndasi-Ísakerioti araámáón-awiꞌa Yúndasi séna Fasiꞌaénkóo nóintafewe séwa úwoi-waasisafemase símai ímba aforaꞌá paápé úmai méranaumnewa sénó. Kentáásáfémase símai aforaꞌá paápé úmai méranaumnewa sénó súwana ");
INSERT INTO auy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ísu séna tirumbá simíyawi kesáái ísámai kaweꞌá íyana kesifomá arumbá miwí timínakai kewé kesifoé miwíséꞌa kumbéyauye. ");
INSERT INTO auy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kesáái ísámai ímba kaweꞌó owí tirumbá ímba símakaawe. Súnda-aai ímba kesí imáyáafinken-aain-ifo kesifo siꞌmákaiwaini imáyáafinken-aain-iye. ");
INSERT INTO auy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Keséꞌo méraundaraꞌa minááí simátimune. ");
INSERT INTO auy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Énifo kesifomá wení Ufaen-ámútánkómbá kentí karáákómbá aiꞌmaráínana kumbéna ken-ánóndáá éna seyaafá-tántááꞌá aráátimena súnda-aai timínaꞌa táákaꞌa maránááwe. ");
INSERT INTO auy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tiyuwéꞌa faru uwátinkeꞌa kentirumbó aánoꞌo uwátínkáandate úmai méraaro. Marapáꞌ-wáásí ímba miyá wéuwatinkaafo kesirumbó aánoꞌo maráúndantemba miyáumai timúne. Mindásafena kentirunkó ímba sáwíꞌa éna ímba tááꞌa íno. ");
INSERT INTO auy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tiyúwáandanifo kentópaꞌa iyuweránaumnemo súnda éꞌa wéisaawe. Kentirumbó siméꞌo éꞌa kesifompáꞌá íyóndasafeꞌa aamoí ónááwe. Kesifomá kembá íyáákaraintafeꞌa símai aamoí ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ímba paápé uráisaꞌa simátimunda póna paápé ínaꞌa kentáféꞌa séꞌa éraiꞌa siyáiye sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Waántáwanko maambáráráké-sáwí-káwáágó wétimba póꞌa ímba aaimá ayáátáákaꞌa simátimumpo wení fasiꞌaénkó ímba kembá taꞌótorainiye. ");
INSERT INTO auy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kesifomó simásímakaimba miyámó únda suwánésa sésa afowámbá arumbá ámakaiye sénááwe. Íyáfasinaiyata konó Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","5","Ísu simátimena séna éraiꞌa ándáma kemá úne. Kesifomá minándáráꞌó káráwiyaiwain-iye. Ándáma kemá úne. Ándágoni amaimá kemán-owe. Ímbo arambó iyáínda-amaimo éna ayááisuwainiye. Arambó iyáínda-amaimo éna ayááimarainana arágásáó agaimái arambá iyáíníye. Ayááímáráíntemba simátímakaunda-aaigo miyá éna tirunkó arupíse wéiye. Keséꞌa kááísamai méraiyaꞌa kemá kempáꞌá kááísamai méraano. Amai aantenkomo éna ímba arambá iyáíníye. Miyámó intembá keséꞌo ímbo kááísamaimo méraiyanamo éna ímba arambá iyáíníye. Kemá keséꞌa kááísamai méwaꞌa póꞌa keséꞌo kááísamaimo méraiyawimo éꞌa sáwífaꞌ-aramba imái méranaawe. Kembó ifáꞌó siyuwésamo ésa ímba arambá imái méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Amaimó ayááisuwainda-amaimo aáénkáíndamo éna ayáímai agaisuwáíníye. Keséꞌo ímbo kááísaiyawi miyá íníye. ");
INSERT INTO auy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Keséꞌo kááísamaimo méraiyawi kesááimo kentirumpimbó taꞌótoꞌmaraiyawi áísai íyana póna miyá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sáwífaꞌ-arambo imáímo méraiyan-kwaasimo tuwánésamo ésa sésa Ísumbo arááíwáén-kwaasin-owe síyana kesifon-áwíkomo éna óraaꞌa íníye. ");
INSERT INTO auy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kesifomó arumbó símakainten-úmai kesirumbá kembá timúne. Kemó éꞌa misírúntáféꞌe símai méraaro. ");
INSERT INTO auy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kesifoní ámáámba ísámai wenaruntaféꞌo símaimo méraundantemba kesí ámáámbo iséꞌo éꞌa kesiruntaféꞌa símai méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Minááí simátímakaunda póꞌa kesí aamoigó kentirumpimbá óraaꞌa wérainaꞌa aamoí éꞌa méraaro. ");
INSERT INTO auy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kesirumbó timúndantemba moórá-mora-waasi tirumbá tíméro. Mindá kesí ámáámba timúne. ");
INSERT INTO auy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kentí waásisafesawe símai wétuwaꞌnai-eꞌo puwónae sésamo puwíyamba ímba moórá-aai símai íyáákamai tirumbá timénááwe. ");
INSERT INTO auy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kesááimo isémaiyawimo éꞌa kesí waási-iꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Óraaꞌ-waasigoni kísau-waasi óraakoni kísau ímba awánaraambanifo wenáfárawaisai wení kísau wéawanaraawe. Miyámó ontáféꞌa póꞌa kesifomó seyaafáꞌ-ááímó simásímakaimba simátimunda póꞌa ímba kesí kísau-waasiye sendá kesífárawaisaiye sénaumne. ");
INSERT INTO auy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kembiwí ímba kembá kendé-íꞌa uwásínkááwaꞌa kemá kembiwí kendé-íꞌa uwátinkaunda póꞌa wéꞌa fasiꞌaén-árámbá koimái sáwífase úmai méraaro. Ken-ímáyáámó éꞌo kesifompáꞌó áísai íyanamo éna miyá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Moórá-mora-waasi tirumbá tíméro séꞌa miyán-ámáámbá simátimune Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ísu minááí simátimena séna marapáꞌ-wáásímó kembiwísáfésamo tíyámbo uwátinkaiyaꞌo éꞌa táákaꞌa maréꞌa séꞌa aifaꞌá kentáásí Fasiꞌaénkómbá tíyámba uwánkaraawe sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kemá marapáꞌ-wáásífínkémbá kembá kendé-íꞌa uwátinkaunda pósa marapáꞌ-wáásí tíyámba wéuwatinkaawe. Kembó úwoimo marapáꞌ-wáásímó onkakaa kentáfésa sésa kenkáán-kwáásín-owe sésa tirumbá tíméwisino. ");
INSERT INTO auy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kísau-waasi miwítí óraaꞌ-waasigomba ímba íyáákaraawemo súnda imáyáan-oro. Kentí óraako únasa pósa marapáꞌ-wáásí karaánááꞌa sinkésa sáwíꞌo uwásínkáanten-úmai kembiwí karaánááꞌa tinkésa sáwíꞌa uwátinkanaafo kesááimo ísámaimo kaweꞌó íyawi kentáái isánááwe. ");
INSERT INTO auy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kembiwí kesí waási-iꞌa ombá pósa marapáꞌ-wáásí karaánááꞌa tinkésa sáwíꞌa uwátinkanaawe. Siꞌmákaiwaimba ímba awánaraamba pósa sáwíꞌa ésa miyá ónááwe. ");
INSERT INTO auy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kemó ímbo kusimátimundarakaa marapáꞌ-wáásítí sáwí-imayaa úwoi aúpáꞌá wéraisino. Kusimátimunasa miwítí sáwí-imayaa ifáꞌó túwááraamba ímba ifáꞌá túwááwana úwoi wéraiye. ");
INSERT INTO auy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tíyámbo uwásinkewi kesifonkwáráꞌá tíyámba wéuwankaawe. ");
INSERT INTO auy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kemó fíꞌowimo íyáákamaimo ímbo fíꞌo-fiꞌon-kisaumo maúndarakaa marapáꞌ-wáásítí sáwí-imayaa úwoi aúpáꞌá wéraisino. Kesí kísau awánésa kené kesifoné tíyánkai wéuwasinkaawe. ");
INSERT INTO auy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Maníkón-aai aúfáífimba agaimaréna séna úwoisafesa kembá tíyámba wéuwasinkaawe siyáinkaꞌa póna minááí káféꞌa wépaape-iye. ");
INSERT INTO auy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kesifompáꞌá iyéꞌa kentí karááꞌó tutinkáíndawimba aiꞌmáráanana kesifompákémbá wenámútanko kembiwíséꞌa kumbéna wemá éraikoni áwáugo póna kentáféna seyaafá-tántááꞌá kusimátiminiye. ");
INSERT INTO auy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kemó kísaumo ómbaraawandarakemba éꞌa suwánaraamba póꞌa kentáféꞌwara kesí kísausafeꞌwaraꞌa simátímapaꞌa kónááwe. ");
INSERT INTO auy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ánaaemba kesááisafeꞌa ímba fasiꞌámai méꞌa siyúwáafo séꞌa minááí simátimunda imáyáan-oro. ");
INSERT INTO auy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ánaaemba marapáꞌ-wáásímó kembiwísáfésamo ámáán-daumpakemba watuwánaemo síyamba mindásafesa sésa Ísuni kísau-waasi tínkamiyawi Maníkóní kísau wémaewe karoꞌá sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kenté kesifontéꞌa ímba suwánaraamba pósa miyáumai sáwíꞌa uwátinkanaawe. ");
INSERT INTO auy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Káféꞌa minááí simátimunda póna mindá paápé ínaꞌa imáyáa éꞌa séꞌa simásímakaimba wépaape-iye sénááwe. Mindásafeꞌa simátimune Ísu siyáiye. Ísu simátimena séna keséꞌa méraunda póꞌa minááí ímba simátímakeꞌa ");
INSERT INTO auy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","siꞌmákaiwaimpaꞌo íyóndasafeꞌa káféꞌa simátímakaanaꞌa nááfara iyónó séꞌa ímba sísai owe. ");
INSERT INTO auy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Iyónaumne súnda-aai ísááwana tirunkó umbaí taisaꞌá póꞌa nááfara iyónó séꞌa ímba sísai owe. ");
INSERT INTO auy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Éraiꞌa simátimeꞌa súne. Ímbo iyúndarakaa kentí karááꞌó tutinkáíndawi ímba kúmísino. Iyéꞌa wembá aiꞌmáráanana kembiwíséꞌa kumbéna kaweꞌá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kumbéna marapáꞌó méraan-kwaasi kentí sáwí-imayaagoni áwáuma aráátiminiye. Arupísemo úmaimo méraiyawini áwáuma aráátiminiye. Maníkómó aaifimbó maitinkáíndawini áwáuma aráátiminiye. ");
INSERT INTO auy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kesááisafesamo ímbo timankúnkúmbo íyawisafena simátimena séna kentí sáwí-imayaa úwoi wéraiye síníye. ");
INSERT INTO auy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kesifompáꞌó iyúnda ímba suwánánááfo kentí karááꞌó tutinkáíndawi arupíse úmaimo méraiyamba kunaráátiminiye. ");
INSERT INTO auy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Maambáráráké-sáwí-káwáágómbá éꞌa aaifimbá maiyánkaraimba póna Maníkó aaifimbá maitinkáíníyema simátiminiye. ");
INSERT INTO auy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Sáwífaꞌ-aai simátimusina umbai-ááí póꞌa káféꞌa ímba kanaaꞌá isánááfo ánaaemba isánááwe. ");
INSERT INTO auy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Maníkóní ámútanko kumbéna éraiꞌ-amba kaweꞌ-ámbá aráátiminiye. Ímba wení imáyáafinkemba simátiminifo simámakain-aai simátimena aánoꞌo paápé índa-tantaaꞌa simátiminiye. ");
INSERT INTO auy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Súnda-aai simátiminana kesúwíko óraaꞌa íníye. ");
INSERT INTO auy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Seyaafáꞌ-ááísómbá kesifondé mindá kendén-iye. Miyáumai séꞌa simámakaunda-aai Maníkóní ámútanko simátiminiye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ísu simátimena séna kárikaꞌa ímba suwánéꞌa ánaaenkaꞌa suwánanaawe súwasa ");
INSERT INTO auy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","wení kísau-waasifinkemba tuwímbai sésa kesifompáꞌá iyúnda póꞌa kárikaꞌa ímba suwánéꞌa ánaaenkaꞌa suwánanaawemo simbá nóintafenawa síyó. ");
INSERT INTO auy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kárikaꞌemo simbá minááígóní áwáuma ínta isáúmne. Nóintafenawa síyó suwaná ");
INSERT INTO auy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ísu áísai ónaesamo umbá iséna simátimena séna kárikaꞌa ímba suwánéꞌa ánaaenkaꞌa suwánanaawemo súnda-aaisafeꞌa kembiwí áfááraumai kemó súnda-aaisafeꞌa símae wénowe. ");
INSERT INTO auy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Éraiꞌa simátimeꞌa súne. Kembiwí ifiꞌá táíyasa marapáꞌ-wáásí aamoí íyambanifo kentirunkó umbaí taréna ánaaemba kentirunkó fetóí íníye. ");
INSERT INTO auy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Moórá-ininkomo iyámpóímo maꞌankáínda-kanaa tínanamo éna áíꞌa ínana arunkó umbaí táínana ánaaemba miníyámpóí maꞌankéna áíkomba ímba imáyáa éna aamoí íníye. ");
INSERT INTO auy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Miyámó ontembá kentirunkó umbaí táínaꞌa ánaaemba suwánéꞌa aamoí ónááwe. Aamoimó í-tántááꞌá ímba maitiyuwánááwe. ");
INSERT INTO auy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Minkánáámó tínaꞌa ímba sísai ónááfo kesifompáꞌó inaimó síyamba kentáféꞌa ísámai áísai íyantafena póna miyá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kesifompáꞌá ímba inaí siyáafo káféꞌa kentáféꞌa ísámai inaimó síyamba miyá uwátinkainana kentirunkó óraaꞌ-aamoi ínaꞌa méraaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ísu simátimena séna waéꞌmai-aai simátimunda póꞌa ánaaen-kanaa tínaꞌa kesifon-aai aforaꞌá simátimenaumne. ");
INSERT INTO auy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Minkánáámó tínaꞌa ken-ímáyáámó ontáféꞌa kesifompáꞌá inaí síyaꞌa kemá ímba inaí senaná ");
INSERT INTO auy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","wemá úwoi tiména wenarumbó tímakaintafena póna úwoi timíníye. Kentáféꞌa séꞌa Maníkómpákémbá kunkáiye séꞌa tirumbá símakaantafena kesifomá arumbá tímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kesifompákémbá marapáꞌá kumbéraunda póꞌa káféꞌa marapáꞌá tuwéꞌa kesifompáꞌá iyónaumne Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","wení kísau-waasi sésa káféꞌa ímba waéꞌmai-aaifinkemba sémpo aforatá simásimene. ");
INSERT INTO auy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kesáá séta áísai ónáísaiye ímba súnasaama emá ísaraandawi po aforaꞌá wésene. Miyásá séta Maníkómpákémbá kunkáanesa súne suwaná ");
INSERT INTO auy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ísu séna kentáféꞌa Maníkómpákémbá kunkáiye sembánifo ");
INSERT INTO auy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","kárikaꞌa siyuwéꞌa kentí naaóꞌ-naoꞌa wété owaꞌá keyáá mérausina kesifomá keséꞌa méraiye. ");
INSERT INTO auy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Minááí simátimunda póꞌa keséꞌa kááísamai méꞌa aáno úmai wempaꞌá méraaro. Marapáꞌ-wáásí karaánááꞌa tinkésa sáwíꞌa uwátinkanaafo marapá-tántááꞌwárá waásiwaraꞌa íyáákaraunda póꞌa kentirunkó aamoí ínaꞌa méranaawe Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ísu simátimena wíyómpaꞌa awánéna séna kesifóo minkánáá wétiye. Kesúwíꞌa óraaꞌa inaꞌá enáwíꞌa óraaꞌ-iꞌa uwánkáano. ");
INSERT INTO auy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Seyaafáꞌ-wáásí káráwiyaundasafe fasiꞌaémbá símakaanda póꞌa símakaanda-waasi aúíꞌa úmai maéꞌmaeꞌa uwátinkaunda mindásafe kesúwíꞌa óraaꞌ-iꞌa inaꞌá enáwíꞌa óraaꞌ-iꞌa uwánkáano. ");
INSERT INTO auy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Eyáá érai-Fasiꞌaenko óne. Kembá siꞌmákaandawi úne. Empáꞌé kempáꞌé tésa kenkáísááimo ísááwi aúíꞌa úmai maéꞌmaeꞌa wéowe. ");
INSERT INTO auy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Marapáꞌá enáwíꞌa óraaꞌa úmai símakaanda-kisau taiꞌáúmne. ");
INSERT INTO auy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kesifóo maramó ímbo úmakondaraꞌa eséꞌa méraawanana kesúwíko óraaꞌ-iꞌo uráinkaꞌa po anekaꞌá miyá ínkwaeꞌa súne. ");
INSERT INTO auy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Marapáꞌ-wáásífínkémbá ení waási-iꞌa uwátinke símakaanaꞌa entáféꞌa miyámó iwáí méraiye símai paápé uwátinkaunasa enáái wéisaawe. ");
INSERT INTO auy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Símakaandasafesa sésa mintántááꞌá Maníkómó ámakain-tantaaꞌe wésewe. ");
INSERT INTO auy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Símakaanda-aaimo simátimunda wéisaawe. Empákémbá kunkáunda-aai isésa sésa Maníkó aiꞌmákaisana kunkáiye wésewe. ");
INSERT INTO auy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Miwísáféꞌa ísámai inaí súne. Marapákén-úwóí-wáásísáféꞌa ímba inaí súmpo símakaanda-waasi ení waásisafeꞌa ísámai inaí súne. ");
INSERT INTO auy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ení waási kesí waásin-owe. Kesí waási ení waási ésa kesúwíꞌa óraaꞌ-iꞌa wéowe. ");
INSERT INTO auy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Marapáꞌó ímbo méraanda empáꞌá iyónaumpo miwí marapáꞌá méranaawe. Kawe-késífóo miwíyáꞌá emá káráwiyinasa pósa Maníkómbó áántaan-kwaasi-iꞌa úmai méranaawe. Esé keséꞌo kááísamaimo mérauyantemba miwí kááísamai méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Miwíséꞌa méꞌa káráwiyaunasa Maníkómbó áántaan-kwaasi-iꞌa úmai mésa ímba sáwí-amba arááíwakaawe. Énifo moóráwigo sáwí-amba arááíwainda póna minááí Maníkón-aai aúfáífimba agaimaréna siyáin-aai paápé íníye. ");
INSERT INTO auy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Empáꞌá ímbo iyúnda marapáꞌá méꞌa miwí tirumpimbá kesí aamoigó óraaꞌo intáféꞌa minááí simátimune. ");
INSERT INTO auy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Enáái simátímakaumne. Kemó ímbo éraiꞌo marapáꞌ-wáásímó úndantemba miwí ímba éraiꞌa marapáꞌ-wáásí ombá pósa marapáꞌ-wáásí úwoi-waasi tíyámba wéuwatinkaawe. ");
INSERT INTO auy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ímba séꞌa miwí marapákémbá kuntiyaaó súmpo waántáwanko sáwíꞌa uwátínkáífo séma káráwiyuwo súne. ");
INSERT INTO auy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kemó ímbo éraiꞌo marapáꞌ-wáásímó úndantemba miwí ímba éraiꞌa marapáꞌ-wáásín-owe. ");
INSERT INTO auy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Enáái éraiꞌ-aai póna tirumpimbá wérainasa ení waási-iꞌa úmai méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kembó siꞌmarónaꞌo marapáꞌó kunkáundantemba miwí tiꞌmáráanasa marapáꞌ-wáásífímbá méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Miwísáféꞌe séꞌa enarááí aantemba wáúnda pósa enarááí aantemba waránááwe. ");
INSERT INTO auy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ímba maankwáásísáféꞌ-aantemba inaí súmpo miwí táái isésa kentáfésa timankúnkúmba ésa Maníkómpákémbá kunkáiye síyawisafeꞌwaraꞌa inaí súne. ");
INSERT INTO auy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kesifóo inaí séꞌa esé keséꞌo kááísamaimo mérauyantemba miwí enté kenkáꞌé kááísamai méranaawe. Miwí kááísamai méraamba pósa marapáꞌ-wáásí tuwánésa sésa éraiꞌa Maníkó Ísumba aiꞌmákaisana kunkáiye sénááwe. Mindásafeꞌa inaifínkémbá simámune. ");
INSERT INTO auy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Esé keséꞌo mimbóráíꞌo úmaimo mérauyantemba símakaanda-fasiꞌaemba tímakaunda pósa mimbóráíꞌa úmai méranaawe. ");
INSERT INTO auy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Emá keséꞌa kááísamai méraanaꞌa kemá miwíséꞌa kááísamai méraunda pósa miwí kááísamai méranaawe. Marapáꞌ-wáásí mindá tuwánésa sésa Maníkó Ísumba aiꞌmákaisana kunkáiye sénááwe. Enarumbó símakaandantemba miwíwáráꞌá tímakaanda pósa marapáꞌ-wáásí tuwánésa sésa éraiꞌe sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Kesifóo maramó ímbo úmakondaraꞌa enarumbá siméma fasiꞌaémbá símakaane. Símakaanda-waasi keséꞌa méraiwae séꞌa súnda pósa kesí fasiꞌaémbá awánánááwe. ");
INSERT INTO auy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kesifóo usukáéwi óne. Marapáꞌ-wáásí embá ímba wéawanaafo kemó awánáúnda símakaanda-waasi kentáfésa sésa Maníkó aiꞌmákaisana kunkáiwaiye wésewe. ");
INSERT INTO auy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Entáféꞌa miyámó iwáí méraiye símai paápé uwátimunasa enarumbó símakaandantemba miwí tirumbá simíyaꞌa miwíséꞌa méranaumne. Entáféꞌa miyámó iwáí méraiye símai paápé uwátínkareꞌa paápé úmai kónaumne Ísu inaifínkémbá miyá siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ísu simátimena wení kísau-waasiseꞌa Kíndáróni-nomba kofatésa taai-kanáágúnéfímbá komérowana ");
INSERT INTO auy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ísu wení kísau-waasiseꞌa mintáí-kánáágúnéfáꞌá kógo upaꞌá Yúndasi Ísuni pintaruꞌ-wáásígó mintáí-kánáágúnéfáꞌá awánópaꞌa ");
INSERT INTO auy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","mifáꞌá kúmba ámáán-kawaa-waasiye óraaꞌ-amaan-kisau-waasiye i-wáásíwárá ámáán-dankaꞌ-i-waasiwaraꞌa tiꞌmárówana Yúndasi tíꞌmaena taánáínkwara paepáéꞌwaraꞌa maimaésa ómbá toꞌmaésa mintáí-kánáágúnéfáꞌá kumbá ");
INSERT INTO auy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ísu wempáꞌó tínda-tantaakomba iséna wení waásifinkemba íyáfasinena miwí túrankaꞌa koména tísai ena séna nááwani ayaafáíya wéoo súwasa sésa ");
INSERT INTO auy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ísu Násaretifakewintafeta wéayaafai-une suwaná séna miwántáféꞌo sembá kemá úne súwasa Yúndasi Ísuni pintaruꞌ-wáásígó póna miwíséꞌa méraiye. ");
INSERT INTO auy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kemá úne Ísu súwasa miwí tauwérópaꞌa tanaambá fowaná ");
INSERT INTO auy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ísu anekaꞌá tísai ena séna nááwani ayaafáíya wéoo súwasa Ísu Násaretifakewintafeta wéayaafai-une suwaná ");
INSERT INTO auy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ísu séna éꞌa simátímakaumne. Maandá kemá úne. Kembó siyaafáí ontáféꞌa maankwáásí étinkaiyasa koró Ísu súmba ");
INSERT INTO auy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Maníkóntáféna siyáimba símakaanda-waasi ímba sáwí-amba arááíwakaawe siyónkaꞌa póna paápé úmai minááí súwana ");
INSERT INTO auy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sáímoni Pítaa paepáéꞌa awáúfínkémbá taútuwena aifaꞌ-ámáán-káwáágóní kísau-waasigon-ááꞌa fagáúsuwomba minkísáú-wáásígón-áwíꞌa Márákáasi wenááꞌa fagáúsuwowana ");
INSERT INTO auy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ísu Pítaantafena séna ení paepáéꞌa awáúfímbá wiyuwó. Síꞌo índa-iꞌa uwásinkaiyambanifo kesifoní kísau ímba tuwánáúmpo miyá ónaumne Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ísu súwasa i-wáásíyé miwítí óraaꞌ-waasiye ámáán-dankaꞌ-i-waasiye Ísumba taꞌótoꞌmai ayáánkaꞌa káráꞌumaesa ");
INSERT INTO auy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","áíꞌmaesa aifaꞌá moórá-kawaagon-awiꞌa Ánásimpaꞌa tuwaná wemá Káyafaasin-ásáánko éna minkánáá Káyafaasi aifaꞌ-ámáán-káwáágó póna ");
INSERT INTO auy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ááéma simátimena séna Yúndaa-waasi seyaafáꞌá púwófo séna moóráwigo puwíníye siyáiwain-ásáánkompaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kuwasaráí Ísuni kísau-waasiyai moóráwigo Sáímoni Pítaae moóráwigoeꞌa Ísumba arááíwaꞌmaesarai kuyambá aifaꞌ-ámáán-káwáágó moóráwigomba awánasuwowana aaimó ísópaꞌa Ísumbo máánkaropaꞌa imérowana ");
INSERT INTO auy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pítaa máápaꞌ-ontafimba mérowana aifaꞌ-ámáán-káwáágó awánówi iyuweréna ontaráꞌó káráwiyon-arasigomba simámuwana ontá tiyankówana Pítaamba áíꞌmaena íyáferowana ");
INSERT INTO auy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","minárásígó Pítaamba awánéna áísai ena séna minkwáásígóní kísau-waasiyaꞌono súwana Pítaa séna ímbanifo kemá fíꞌon-kwaasi úne súwasa ");
INSERT INTO auy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","táwitafesa ésa kísau-waasiye i-wáásíyé iyamá agaimakésa tiyáámba wégaufuwana Pítaa minááí simásuwena iyaráꞌá koména ayáámba kauráiye. ");
INSERT INTO auy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pítaa iyamá wégaufuwana aifaꞌ-ámáán-káwáágó Ísuntafena séna simátímakaanda-aai simásimiyo. Ení kísau-waasisafewaraꞌa simásimiyo súwana ");
INSERT INTO auy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ísu séna Yúndaa-waasiti óraaꞌ-amaan-daumpaꞌe káriꞌ-amaan-daumpaꞌe simáti-simatimbo émaunda aforaꞌó sémaunda ímba aúpáꞌá simátímakaumpo ");
INSERT INTO auy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","nóintafewa wésisai-ono. Kesááimo ísaraawi tísai inasá simátímakaunda-aai ísaraamba pósa sénááwe súwana ");
INSERT INTO auy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ámáán-dankaꞌ-i-waasigo Ísumba tufuwéna séna aifaꞌ-ámáán-káwáágómó sinkáꞌá ímba miyá siyó súwana ");
INSERT INTO auy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ísu séna sáwí-aaimo súndarakaa misáwí-ááí ááéma aforaꞌá isinó. Kaweꞌ-ááímó súndasafe nóintafewa sínkamono súwana ");
INSERT INTO auy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ánási aiꞌmarówasa ayáámpinken- anda ímba awátuwesa minándáwáráꞌá áíꞌmaesa Káyafaasi aifaꞌ-ámáán-káwáágómpáꞌá kuráawe. ");
INSERT INTO auy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Aifaꞌ-ámáán-káwáágómpáꞌá Ísumba kuwaná Pítaa iyaráꞌá ména ayáámba wégaufuwasa iyaráꞌó máún-kwaasi áísai esa sésa ewárárá minkwáásígóní kísau-waasiyaꞌono suwaná minááí umémpaꞌa tuwéna séna ken-ímbaniye súwana ");
INSERT INTO auy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","aifaꞌ-ámáán-káwáágóní kísau-waasigo Pítaantafena séna emá minkwáásígóeꞌa taai-kanáágúnéfáꞌá méraayaꞌa tuwánérúnda éraira súno séna Pítaamo ááꞌo fagáúsuwowini akún-ándáfákéwí súwana ");
INSERT INTO auy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pítaa anekaꞌá séna ken-ímbaniye súwana kokórigo áái siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kokórigo áái súwasa siyarónkaꞌa Káyafaasini naaúmpakemba Ísumba áíꞌmaesa kámáni-oraakoni pááimpaꞌa máankesa sésa ímba Yúndaa-waasiti naaúmpaꞌan-ifo fíꞌon-kwaasiti naaúmpaꞌa iyéta tíyótaimo í-tánómbá ínta náúnafo sésa ímba íyúwana ");
INSERT INTO auy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Rómu-kamani-kawaagon-awiꞌa Páírati kúwákárúwena kuntísai ena séna minkwáásí nóra inkakena aaifimbá maenkánaera séo súwasa ");
INSERT INTO auy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","sésa ímbo sáwíꞌo uráinkakaa ínta áíꞌmaeta túsino suwaná ");
INSERT INTO auy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Páírati séna keyááríkaꞌa áíꞌmaeꞌa kentí ámáámbo makénten-úmai simánkáaro súwasa minYúndáá-órááꞌ-wáásí sésa Rómu-kamani-waasi moóráwigombo tufúꞌmaimo utáíyantafesa aambá fáíꞌmakaawe sumbá ");
INSERT INTO auy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ááéma Ísu simátimena séna aaraa-táíyáꞌá sínkamiyaꞌa uwónaumne siyáin-aai paápé úwasa áíꞌmaesamo kumbá minááísáfésa uwaná ");
INSERT INTO auy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Páírati naaúmpaꞌa kunuweréna iyéna Ísumba áántena séna emá Yúndaa-waasiti kawáágówá ónó súwana ");
INSERT INTO auy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ísu séna ení imáyáafinkena sísai ó waásiya simámakaawawa sísai ónó súwana ");
INSERT INTO auy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Páírati séna kemá ímba Yúndaa-waasi úne. Ení waásiye óraaꞌ-amaan-kisau-waasiye áíꞌmaesa kempáꞌá tiyáafo nóra ónasawaꞌiyo súwana ");
INSERT INTO auy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ísu séna kemó kawáá-íꞌo úndama ímba marapáꞌá wéraiye. Kemó kawáá-íꞌo úndamo marapáꞌó wérainkakaa kesí kísau-waasi tíyááwaisino. Yúndaa-waasi kembá taꞌótoraafo sésa tíyááwaisino sésa taꞌótokaawe. Kemó kawáá-íꞌo úndama ímba marapáꞌá wéraiye súwana ");
INSERT INTO auy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Páírati áísai ena séna kawáágówá ónó súwana Ísu séna éꞌa séne. Mindásafeꞌa marapáꞌá kumúnana masínkaraimba póꞌa arupíse-aai wésimatimune. Arupíse-aaisafesamo aamoimó owí kesááima wéisaawe súwana ");
INSERT INTO auy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Páírati séna nóin-aaiya arupíse-aain-iyo siyáiye. Páírati simásuwena kúwákárúwena Yúndaa-waasisafena séna wemó sáwíꞌo uráimbo simásímakaamba saafá únana ímbanifo ");
INSERT INTO auy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","tíyótaimo í-tánón-kánáá tintembá moórá-waasi áántaawaꞌa ándáfakembo awáꞌankaundantemba minkánáámó tinkáꞌá Yúndaa-waasiti kawáágóná awáꞌankanaumno tísai ena súwasa ");
INSERT INTO auy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","óraaka sésa ímbanifo wembá ímba awáꞌánkénda Párápásimba awáꞌankaao suwaná Párápási tiyéna uméntéꞌa in-kwáásín-iye sésa wembá awáꞌankaao siyáawe. ");
INSERT INTO auy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Suwaná Páírati i-wáásí simátimuwasa Ísumba áwíyandasamba áwiyonkuꞌ-nésa ");
INSERT INTO auy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","óraaꞌ-waasiti kámoꞌan-iye sésa áwíyandama owepámai Ísu aꞌnómpímbá kuféꞌankesa naae-únánkwátói óraaꞌ-waasiti unáánkwátóin-iye sésa uwánkesa ");
INSERT INTO auy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","karaánááꞌa ankésa moórá-mora wempáꞌá tésa sésa Yúndaa-waasiti kawáágó óne sésa tiyáántamba tufútoꞌnaamai uráawe. ");
INSERT INTO auy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tufútoꞌnaamai uwaná anekaꞌá Páírati kúwákárúwena seyaafáꞌ-wáásísáféna séna ísáaro. Ímba sáwíꞌo uráintafeꞌa áíꞌmaeꞌa túrankaꞌa máánkaraanaꞌa awánaaro. Ímba sáwíꞌa uráiye súwana ");
INSERT INTO auy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ísu kúwákárúwena aꞌnómpímbá áwíyandawara naae-únánkwátóiwaraꞌa kúwákárúwowana Páírati simátimena séna minkwáásígómbá awánaaro súwasa ");
INSERT INTO auy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","óraaꞌ-amaan-kisau-waasiye ámáán-dankaꞌ-i-waasiye awánésa óraakaꞌ-oraakaꞌa sésa aaraa-táíyáꞌá tufíyana puwíno suwaná Páírati séna wemá ímba sáwíꞌa uráimba póꞌa kemá ímba tufuwónaumpo kembiwí áíꞌmaeꞌa aaraa-táíyáꞌá mátufuworo súwasa ");
INSERT INTO auy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yúndaa-waasi sésa wemá séna Maníkón-áánimba úne sémáyáímbanifo kentáásí ámáánko séna miyámó síndawimba tufuwíyana puwíno símakaampimba póta tufuwónaumne suwaná ");
INSERT INTO auy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Maníkón-ááninko úne siyáin-aai Páírati isówana áfááraumai ááꞌa úwana ");
INSERT INTO auy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","naaúmpaꞌa kunuweréna imaéna Ísumba áísai ena séna nááfakewiyaꞌono súwana Ísu iséna ímba aaí súwana ");
INSERT INTO auy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Páírati séna kemó áísai únda nóra séwa ímba aaí wéseno. Kemó aaimó senasamó ésa awáꞌankanaawe. Kemó senasamó ésa aaraa-táíyáꞌá tufuwíyama puwínone. Mifásíꞌáémbá tokáumne súwana ");
INSERT INTO auy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ísu séna Maníkómó mifásíꞌáémbó ímbo ámakainkakaa ímba toráásino. Maníkó ámakaifo síꞌmaenamo enkáꞌó másinkaiwaini sáwí-kisaugo ení sáwí-kisaugomba íyáákaraiye siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ísu súwana Páírati minááí iséna séna nóraꞌiyo ke minkwáásí awáꞌankanaeꞌa wéune súwasa Yúndaa-waasi óraaka sésa emó awáꞌankemo éma ímba Rómu-kamani-aifa-kawaagoni waási-iꞌa wéone. Ísu séna kemá kawáágó úne siyáintafena Rómu-kamani-aifa-kawaagomba íyáákanaemo siyáintafe mindásafewe séma ímba awáꞌankaao suwaná ");
INSERT INTO auy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","Páírati minááí iséna Ísumba áíꞌmaena máápaꞌa óntan-arumbo akwítukom-barupaꞌa Yúndaa-waasi-taaifinken-awiꞌa Kápata-marupaꞌa kumbéna aaifimbó maitínkáám-barupaꞌa kumbéna Yúndaa-waasisafena séna kentí kawáágón-iye súwana tíyótaimo í-tánón-kánáá aafáyáaraamba úwana káfékaamba wááwái kárikaꞌa tínena úwana Páírati Yúndaa-waasisafena séna kentí kawáágón-iye súwasa ");
INSERT INTO auy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ímbaniye sésa óraakaꞌ-oraakaꞌa sésa aaraa-táíyáꞌá tufuwíyana puwíno suwaná Páírati tísai ena séna kentí kawáágómbá aaraa-táíyáꞌá tufuwónaumno. Mindá tirááíya taíyó súwasa óraaꞌ-amaan-kisau-waasi sésa Rómu-kamani-aifa-kawaago weyáá kentáásí kawáágón-iye suwaná ");
INSERT INTO auy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yúndaa-waasi-taaigo íyáákontafena Páírati séna Ísumba aaraa-táíyáꞌá tufúwóro séna tímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Páírati timúwasa i-wáásí Ísumba áíꞌmaesa tufuwíyan-aaraa-taima wembá ámúwana áúwaataꞌmaena tufuwíyan-aempaꞌo kúmba mináémpáꞌ-áwíꞌa aꞌnónayaantapa Yúndaa-waasi-taaifinkemba Kórígótaafa mináémpáꞌá kuwasá ");
INSERT INTO auy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","aaraa-táíyáꞌá aíyayaankaꞌa tufúsúmaresa kaeꞌ-wáásíyáí Ísuni séfasefaꞌ-arausampaꞌa aaraa-táíyáꞌá tufúsúmaresa Ísumba afufumpimbá tufúsúmarowana ");
INSERT INTO auy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Páírati wení kísau-waasisafena séna Ísu Násaretifakewi Yúndaa-waasiti kawáágón-iye séꞌa agaimái aꞌnónká-táíyáꞌá máráaro súwasa ");
INSERT INTO auy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","kaumbo-wáásí tááifinkemba Yúndaa-waasi-taaifinkene Rómu-waasi-taaifinkene Kíríki-waasi-taaifinkene agaimárówasa sáwífaꞌ-waasi awánomba tufúwún-aempaꞌa óraaꞌ-naopaꞌa ewaaꞌá wérowasa sáwífaꞌ-waasi mináúfáímá awánésa toráumai ísówasa ");
INSERT INTO auy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yúndaa-oraaꞌ-amaan-kisau-waasi Páíratintafesa sésa Yúndaa-waasiti kawáágón-iye ímba miyá símai agáínda wemá séna Yúndaa-waasiti kawáágó úne miyá símai agauwó suwaná ");
INSERT INTO auy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Páírati séna éꞌa agaimakáumne siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I-wáásí Ísumba aaraa-táíyáꞌá aíyayaankaꞌa tufúsúmaresa wení unáánkwátói maimaésa éíyainkaꞌa tuwímbaresa moórá-mora-i-waasi éíyain-kwaasi minúnánkwátói maimaésa moórá-ampanta paákákén-únánkwátói ímbo farúmakon-ampanta maimaésa sésa ");
INSERT INTO auy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ínta tafeónaumpo sésa ááfésa tíyáananasa nááwa íyáákenawa máíníyo sumbá Maníkón-aai aúfáífimba agaimaréna séna kesí unáánkwátói tuwímbai maimaésa moórá kesí ampantarátáfésa ááféma tiyaráawe siyónkaꞌa pósa i-wáásí miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","I-wáásí miyá uwasá Ísuni waási aaraa-táíyáꞌó tufún-taigoni áwáufimba mésa Ísun-anówa úwana wenáúnko Kórópasi awaainínkón-áwíꞌa Máríyaa úwana Mágátáraa-naopaken-ininkon-awiꞌa Máríyaa úwasa miyáumai-inimba aaraa-táígóní áwáufimba mérowana ");
INSERT INTO auy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ísu wenanówamba awánéna kembá Yónimba suwánéna anówantafena séna miwá enáánimban-iye séna ");
INSERT INTO auy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","kentáféna séna miwá enanón-iye súwaꞌa iséꞌa kesí naaúmpaꞌa móankareꞌa káráwiyaumne. ");
INSERT INTO auy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Minkákémbá Ísu imáyáa éna séna seyaafá-kísáú taiꞌáúmne súmba sáwí-imayaagomo taꞌótokaimpinkemba awátinkaunda-kisau seyaafá-kísáú taíꞌásuwaumne séna Ísun-aai Maníkóní aúfáífinkemba paápé índasafena Ísu séna nontáféna sínkáíye súwana ");
INSERT INTO auy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ándá-aran-domba ika-nómbá anaféúmpímbá wérowasa faru-táénáma mindómpímbá tuꞌmaésa ofiyen-táemopimba sinúfaimaesa náínkwae sésa Ísun-óikaꞌa mósá márówana ");
INSERT INTO auy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ísu néna séna seyaafá-kísáú taíꞌásuwaumne séna aꞌnómbá kífaena afowan-ayáámpimba wenámútamba toꞌmaréna pukáiye. ");
INSERT INTO auy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ísu weyááríkaꞌa puwúwasa Yúndaa-waasimo saagon-kánáá tíyótaimo í-tánón-kánáá aafáyáaraamba úwasa pósa sésa saagaan-kánááráꞌá puwíyan-kwaasi aaraa-táíyáꞌá máéfo sésa Páíratimpaꞌa tésa sésa puwíyan-kwaasi ímba úwoi tiyúwéwasa aaraa-táíyáꞌá méraaro. Tísamai ankaisíyasa ááéma puwíyasa taaiyakémbá marapáꞌá múratuwaaro suwaná ");
INSERT INTO auy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Páírati ewé súwasa i-wáásí Ísuni séfasefaꞌ-arausampaꞌo tufúsúmaron-kwaasi tísamai koankaisésa ");
INSERT INTO auy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ísumba taawánomba éꞌa pukóntafesa wenaísamai ímba ankáísúwana ");
INSERT INTO auy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","moórá-i-waasigo Ísuni awáúfímbá waantáántámbá faúwana naaewárá nonkwáráꞌá kunkáiye. ");
INSERT INTO auy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mindámo awánáúndawi simátímakaumne. Awánéꞌa éraiꞌ-aai súnda póꞌa iséꞌa séꞌa éraiꞌe sénááwe. ");
INSERT INTO auy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Maníkón-aai aúfáífimba agaimaréna séna wenayáátámba ímba ankaisónááwe agaimaréna siyónkaꞌa pósa i-wáásí miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Moóráfaꞌa agaimaréna séna waantáántámbó fáíyamba afuwónááwe agaimaréna siyónkaꞌa póna paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yósepi Árímátíyaa-naopakewi Ísun-aai isówi éna Yúndaa-oraaꞌ-waasi táároi inkaiséna wenáwíꞌa áwiyotuwena Ísumo puwúnkaꞌa Páíratimpaꞌa téna séna Ísun-áúma utánáifo simiyó súwana Páírati séna kanaámpó máínone súwana Yósepi Ísun-áúma komaúwana ");
INSERT INTO auy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Níkótímási ááéma Ísumpaꞌo nóꞌwaambo tiyáiwai asaa-wiyúmbó úm-basawemba óraaꞌ-masawemba kaeꞌá maimaéna Yósepimba kóáíꞌmaesarai ");
INSERT INTO auy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ísun-áúma komaimaésarai ampantafímbá minásáá-wíyúm-básáwénkwáráꞌá káráꞌumaesarai tésarai Yúndaa-waasi miyáumaimo utaantembá pósarai miyáumai utarááye. ");
INSERT INTO auy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ísumbo tufúkáan-aempaꞌa taai-kisáú wérowana utaráan-ontan-aima ímbo waási utarón-ontan-aima wérowasarai ");
INSERT INTO auy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","saagaan-kánáámá ampáámbán-iye sésarai minóntán-aima ewaaꞌá wérontafesarai Ísumba mimpímbá máutaraaye. ");
INSERT INTO auy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sondaaráꞌá siyarónkaꞌa ímba sán-karowana Máríyaa Mágátáraa-naopaken-ininko utámakopaꞌa wéna koawánómba óntan-aigoni óikaken-ontamba maisukówana koawánéna ");
INSERT INTO auy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","awaantanténa Sáímoni Pítaante kentéꞌa tasimásimena séna kentáásí óraakon-áúma óntan-aifinkemba maimaésa nááfara makáao súwakai ");
INSERT INTO auy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pítaae keséꞌa utámakon-ontan-aifaꞌa kónae sékai ");
INSERT INTO auy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","suwaantantékai kówáyamba kemá Pítaamba kóyáákeꞌa aifaꞌá óntan-aifimba kówánda ");
INSERT INTO auy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","kífaeꞌa ampanta aantemba wéromba awánéꞌa ímba óntan-aifimba íyáferaawanana ");
INSERT INTO auy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sáímoni Pítaa téna óntan-aifimba íyáferena awánómba ampanta aantemba wérowana ");
INSERT INTO auy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ísun-aꞌnónkákén-ámpántá moórá-aempaꞌa wérowana awánówaꞌa ");
INSERT INTO auy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","óntan-aifimba aifaꞌó kówándawi íyáfereꞌa awánéꞌa séꞌa éraiꞌa pukáimpinkemba íyáfasinkaiye séwándanifo ");
INSERT INTO auy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Maníkón-aai aúfáífimba agaimaréna séna pukáindafinkemba íyáfasinainiye siyáimba ímba ísámai kaweꞌá ówáyamba ");
INSERT INTO auy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","kenkáísí naaópakai kuráuye. ");
INSERT INTO auy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Naaópaꞌa kówáyana Máríyaa óntan-aigoni óikaꞌa ména ifiꞌá wétena kífaena óntan-aifimba awánómba ");
INSERT INTO auy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kaeꞌ-wáásí waén-únánkwátóiwaraꞌa Ísumbo utámakom-barupimba mésarai moóráwigo aꞌnómpáꞌá maúwana moóráwigo aísamaifaꞌa méroyana Máríyaa tuwánówasarai ");
INSERT INTO auy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","sésarai menínínkóo nóintafewa ifiꞌá wétaano suyaná Máríyaa séna kesí Fasiꞌaénkómbá maimaésa nááfara makáao séꞌa ímba wéraisaꞌa wéawanaumne ");
INSERT INTO auy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","simásuwena waeréna awánómba Ísu úmbanifo ímba awánéraase úwana ");
INSERT INTO auy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ísu séna menínínkóo nóin-ifira wétewa nááwan-ayaafaawa wéono súwana Máríyaa séna taai-kisáúráꞌó káráwiyaiwai iyé-ímáyáá éna séna emó maimaémo nááfaꞌo maké simásimiyo. Komaénae súwana ");
INSERT INTO auy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ísu séna Máríyaao súwana méwaerena wenááifinkemba séna Raaponai súmba maanááífínkémbá waéꞌmai séna kesí Fasiꞌaénkóo súwana ");
INSERT INTO auy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ísu séna kesifompáꞌó íyóndasafeꞌa úmpo ímba taꞌótoraao. Kesífárawaisai kosimátime sé kesifoné kentifompáꞌá iyúne. Kesí Maníkóné kentí Maníkómpáꞌá iyúne súwana ");
INSERT INTO auy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Máríyaa Mágátáraa-naopaken-ininko Ísuni kísau-waasi kosimátimena séna Fasiꞌaénkómbá awánáúmne séna Fasiꞌaénkómó sún-aai simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Misóndáágóní fenómpinkaꞌa Ísuni kísau-waasi Yúndaa-oraaꞌ-waasisafena tááꞌa úwasa naaúmpaꞌa imésa ontá wisukówana Ísu túrankaꞌa paápé éna séna aáno úmai méraaro séna ");
INSERT INTO auy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ayáánarumpin-afiwara awáúfín-áfíwáráꞌá aráátimuwasa miwítí Fasiꞌaénkómbá awánésa pósa áfááran-aamoi uwánkówana ");
INSERT INTO auy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ísu anekaꞌá séna aáno úmai méraaro. Kesifomó siꞌmákaintemba miyáumai kembiwí tiꞌmáráanaꞌa kesí kísau komáéro séna ");
INSERT INTO auy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","wenááma áútimena séna Maníkóní Ufaen-ámútánkómbá tíménana keséꞌa mérainiye. ");
INSERT INTO auy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sáwí-imayaamo maitiyuwáíyanamo éna misáwí-ímáyáá taiꞌáíníye. Ímbo maitiyuwáíyanamo éna misáwí-ímáyáá úwoi waéꞌwaeꞌa íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ísu paápé úwasa wení kísau-waasi awánasuwonkaꞌa Tómaasi moórá-awiꞌa Títímási mináwíkóní áwáuma amáántágaeꞌa wemá fíꞌopaꞌo maémomba ");
INSERT INTO auy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","túwasa simámesa sésa Fasiꞌaénkó paápé isatá awánáúmne suwaná Tómaasi séna ayáánarumpin-afiwara awáúfín-áfíwáráꞌó awánéꞌo taꞌótorekaa séꞌa pukáimpinkemba íyáfasinkaiye súsino súwasa ");
INSERT INTO auy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","afakaeté-noꞌwaamba maisuwésa Tómaasiwaraꞌ-úmai anekaꞌá wení kísau-waasiye naaúmpaꞌa imésa ontá wisukówana Ísu túrankaꞌa paápé éna séna aáno úmai méraaro séna ");
INSERT INTO auy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tómaasintafena séna siyáánarumpimba taꞌótoꞌmai awáné suwáúfímbá taꞌótoꞌmai awáné sé kentáfé karoꞌé sénafainifo éraiꞌe siyó súwana ");
INSERT INTO auy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tómaasi séna kesí Fasiꞌaénkóo emá kesí Maníkó óne súwana ");
INSERT INTO auy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ísu séna ááéma ímba suwánarempo karoꞌé siyáandaniye. Káféꞌa suwánáánda po éraiꞌe wésene. Ímbo suwánaawimo ésa éraiꞌemo sésamo timankúnkúmbo ésa aamoí isaná tirunkó kaweꞌá íníye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ísu wení kísau-waasi súrankata fíꞌo-fiꞌon-kisau-waameꞌa aráásimuwata tuwímbai maankwándááífímbá ímba agaimakáundanifo tuwímbai agaimakáumne. ");
INSERT INTO auy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ísu Maníkón-ááninko póna wemó íyáfasinankaraiwain-iye séꞌa maanáúfáí agaimakáumpo Ísun-aaisafesa timankúnkúmba ónááwe. Miyámó timankúnkúmbo ésa Ísuweꞌa kááísamai maéꞌmaeꞌa ónááwe séꞌa maanáúfáí agaimaráúmne. ");
INSERT INTO auy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ánaaemba Táípíriyasi-waaunkoni áwáífaꞌa Ísu miyáumai paápé úwasa wení kísau-waasi awánaraawe. ");
INSERT INTO auy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wení kísau-waasi túwaandu uwáí miwí túwíꞌa Sáímoni Pítaawe Tómaasi moórá-awiꞌa Títímásiye moóráwigo Káríri-aempakemba Kéna-naopaken-kwaasigon-awiꞌa Nátániyeriye Sépétin-ááninkaiye fíꞌon-kaeꞌ-waasiye miyáumai-waasi túwaandu uwaná ");
INSERT INTO auy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sáímoni Pítaa simátimena séna mófááꞌa kotoránaeꞌa kúne súwasa kesááwáráꞌá montá kónáisaiye sésa nompín-táómpimba íyátesa kumbá nóꞌwaamba mófááꞌamai wimaꞌwimaꞌ-umbá ímba mófááꞌa torówana ");
INSERT INTO auy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","siyarónkaꞌa Ísu nonáwáífaꞌa mérowasa ímba awánéraase uwaná ");
INSERT INTO auy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ísu séna iyámpóísono. Mófááꞌa tokáao súwasa ímbaniye suwaná ");
INSERT INTO auy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ísu séna mareꞌmareꞌ-únámbá tiyáánúrapaꞌ-aempaꞌa nompímbá túwéwana kumínaꞌa mófááꞌa tóráaro súwasa wemó súnten-umba sáwífaꞌ-mofaaꞌa tórówana mindómpín-táómpimba ímba kanaaꞌá márááraantamba éna ówitowaꞌa ");
INSERT INTO auy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","kemá Pítaantafeꞌa séꞌa epínda Fasiꞌaénkón-iye séwánana Pítaa minááí iséna kísaumo maíndasafena paákákén-únánkwátóimo faúꞌmaromba minúnánkwátói maimái úmaena nompín-táómba tuwéna nompímbá ásáfena nonáwáífaꞌa kúwana ");
INSERT INTO auy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","nonáwáí ewaaꞌá wérowata fíꞌon-kwaasisa mindómpín-táómba maimaéta mareꞌmareꞌ-únámbá tafisímaeta kówándasa ");
INSERT INTO auy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","nonáwáífaꞌo ásáfaawandasa iyamá wégowana mófááꞌwara tónkwáráꞌá wéagauwata awánááwánanasa ");
INSERT INTO auy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ísu séna tóráám-bofaaꞌa tuwímbai maimaéꞌa teró súwana ");
INSERT INTO auy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sáímoni Pítaa nompín-táómpimba íyátena mareꞌmareꞌ-únámbá tafisímaena nonáwáífaꞌa mámarowana óraaꞌ-mofaaꞌa 153 mofaaꞌa wéna sáwífaꞌ-mofaaꞌa wérombanifo mareꞌmareꞌ-únámbá ímba tararówana tafisímaena nonáwáífaꞌa mámarowana ");
INSERT INTO auy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ísu simásimenasa séna tamandaaró súwata nááwaꞌono séta áísai ónae séta ówándasa ímba áísai eta Fasiꞌaénkó iyé-ímáyáá ówánanasa ");
INSERT INTO auy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ísu mófááꞌwara tónkwáráꞌá maimáísa símakaiye. ");
INSERT INTO auy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ísu pukáimpinkemba íyáfasinkena kaeꞌ-íꞌa paápé uréna kaumbogóntá aneká awánaraumne. ");
INSERT INTO auy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tómbá násúwówana Ísuma Sáímoni Pítaantafena séna Yónin-ááninko Sáímoniyo. Miwí íyáákewa enarumbá wésimeno súwana séna ewé Fasiꞌaénkóo en-ímáyáámó únda éꞌa suwánaraane súwana Ísu séna kesí sipisípi-araakaꞌa káráwiyuwo séna ");
INSERT INTO auy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","anekaꞌá Ísu áísai ena séna Yónin-ááninko Sáímoniyo. Ken-ímáyáá wéono súwana séna ewé Fasiꞌaénkóo en-ímáyáámó únda éꞌa suwánaraane súwana Ísu séna kesí sipisípiyaꞌa káráwiyuwo séna ");
INSERT INTO auy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","kaumbo-íꞌa Ísu áísai ena séna Yónin-ááninko Sáímoniyo. Ken-ímáyáá wéono súwana kaumbo-íꞌa áísai ena súntafena Pítaan-arunko umbaí tówana séna Fasiꞌaénkóo seyaafá-tántááꞌá éꞌa awánaraandasafe en-ímáyáámó úndawaraꞌa éꞌa suwánaraane súwana Ísu séna kesí sipisípiyaꞌa káráwiyuwo. ");
INSERT INTO auy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Éraiꞌa simámeꞌa súne. Emá aú-waasi méraanda po ení unáánkwátói aneꞌmaké ení imáyáafinkemba úwoi wénompo waurámbó kéma enayáámba fárútuwenasa ímbo embó arááímo táíndafaꞌa máankanaawe Ísu séna ");
INSERT INTO auy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","minááímó súmba Pítaamo miyáumai puwéna mindá Maníkón-áwíꞌa mósá maráínone séna Pítaantafena séna kesirááíma wauwó siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ísu Pítaantafena súwana Pítaa kowaeréna moóráwigomba awánarai. Ááéma tómbó nopaꞌá Ísuni ewaaꞌá ména séna Fasiꞌaénkóo nááwa ení pintaruꞌ-wáásí íníyo siyáiwaimba ");
INSERT INTO auy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pítaa kowaeréna awánéna Ísumba áísai ena séna Fasiꞌaénkóo minkwáásíndó súwana ");
INSERT INTO auy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ísu séna kemó séꞌo wemá úwoi maambáráráꞌá mérainaꞌa kemá kumónaumnemo sendamá ímba endén-ifo kendén-iye. Emá kesirááíma wauwó Ísu súwasa ");
INSERT INTO auy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","wení kísau-waasi ímba kaweꞌ-úmai ísónkakemba sésa wemá ímba puwíníye sésa simátímaꞌmae kuwaná Ísu miyán-ááí ímba siyáimbanifo wemá úwoi mérainaꞌa kemó kumónaumnemo sendamá ímba endén-iye Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ímba puwíníyemo siyáan-kwaasi kemá Yóni úne. Minááí simátimeꞌa aúfáífimba agaisuwaúnda minááí éraiꞌ-aain-iye. ");
INSERT INTO auy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ísumo maiyáin-kisau tuwímbai agaéꞌa tuwímbai ímba agaiyáunda póꞌa seyaafáꞌó agaisuwéꞌo éꞌa seyaafáꞌ-márámá faráátasuwaunafo séꞌa súne. Kemá Yóni súnda-aai taíꞌáiye. ");
INSERT INTO auy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tíófíráasiyo maankwándááífímbá moórá-aai sénaumpo isaaó. Aifaꞌ-wándááífímbá Maníkó Ísumba aiꞌmarówana marapáꞌó kunkáin-aaiwara kísau kumbaiyáin-aaiwara aaimó siyáin-aaiwara afufumpimbá seyaafá-kísáúmó maiyáinkwaraꞌa komaé tamae úmai wení kísau marapáꞌá taiꞌówana ");
INSERT INTO auy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Maníkó kunaiyówana wíyómpaꞌo iyáin-aaiwaraꞌa aifaꞌ-wándááífímbó agaimakáunda isaꞌá maankwándááífínkwáráꞌa agaimaráúmpo isaaó. Ísu kesí aantá-waasiye séna wemparíꞌa úmakaiye. Ísu ímba wíyómpaꞌo iyónkaꞌa Maníkóní Ufaen-ámútánkóní fasiꞌaénkwáráꞌá ména aantá-waasi wení ámáámba simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ísu pukómpinkemba íyáfasinena kaeꞌ-wááí-kánáá 40 kanaa moórá-mora-kanaa paápé uréna wenáúma kaweꞌ-úmai aráátimuwasa awánésa sésa éraiꞌa Ísu pukáimpinkemba íyáfasinena méraiye suwaná paápé urónkaꞌa Maníkó wení waásimo kawáánin-aai simátímaꞌmaena iyáiye. ");
INSERT INTO auy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Moórá-kanaa túwaandu urésa tómbá wénowana Ísu paápé éna séna maankáꞌá Yérúsaremufaꞌa ímbo túwémba aáno méꞌa kesifo kesí ámútamba timénaumnemo óraaka siyáimba wéamuꞌmareꞌo méraanana úwoi timíno. Minááí éꞌa simátimeꞌa súne. ");
INSERT INTO auy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yóni nombá maitínkaraimbanifo kárikaꞌa Maníkóní Ufaen-ámútánkó kumbéna óraaꞌa uwátinkainifo amuꞌmaréꞌa méraaro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Órífi-omapaꞌa Ísuwe aantá-waasiye túwaandu ésa Ísumba áísai esa sésa Fasiꞌaénkóo káféra Rómu-kamani-waasi tiꞌmátuwewa Ísareri-waasisa kawáánínono suwaná ");
INSERT INTO auy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ísu séna moórá-kanaamo tínda káféraꞌi aánoraꞌiyo Maníkó wení imáyáafinkemba miyá íníye. Kawe-kánááwé sáwí-kanaawemo paápé índa Maníkó wení imáyáafinkemba miyá íníye. Miyán-kánáámó tínda káriꞌ-aain-ifo ");
INSERT INTO auy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kemó sendá óraaꞌ-aain-ifo ísáaro. Maníkóní Ufaen-ámútánkó kempáꞌó kumínda wení fasiꞌaénkó tirumpimbá óraaꞌa uwátinkainaꞌa kesááiwara kentáféꞌwaraꞌa simátimeꞌa Yérúsaremu-naopaꞌe Yúndiyaa-aempaꞌe Sámériyaa-aempaꞌe seyaafáꞌ-áémpáꞌá kosimátímaꞌmaeꞌa nóro ");
INSERT INTO auy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ísu simásuwowasa awánomba Maníkó Ísumba kunaiyówana ainánkó Ísumba káátaguwasa ímba awánowana ");
INSERT INTO auy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ísumo iyúmba wíyómpaꞌa karátuwesa mérowasa minúwóíyáán-úmai kaeꞌ-wáásí waén-únánkwátói úmaesarai ewaaꞌá mésarai ");
INSERT INTO auy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","sésa Káríri-aempaken-kwaasisono. Ímba wíyómpaꞌa karátuweꞌa méraaro. Awánaawanamo Maníkó kunáíyáísanamo wíyómpaꞌo íyínten-úmai anekaꞌá miyáumai kumíníye siyááye. ");
INSERT INTO auy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mindárai simásúwóyasa aantá-waasi Órífi-omapa Yérúsaremu-naoꞌ-ewaaꞌ-omapaꞌa tuwésa Yérúsaremu-naopaꞌa kouwerésa ");
INSERT INTO auy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","méron-daumpaꞌa afófumayaatanaan-daumpaꞌa imésa miwí Ísuni aantá-waasi moórá-mora-waasi-tuwiꞌa Pítaawe Yóniye Yémísiye Énduruwe Fírípiye Tómaasiye Pátóromiyuwe Mátíyuwe Áráfíásin-ááninkon-awiꞌa Yémísiye moóráwigo wemá Rómu-kamani-waasi tiꞌmátuwanae siyáiwain-awiꞌa Sáímoniye moóráwigo fíꞌon-Yemisin-aaninkon-awiꞌa Yúndasiye miyáumai-aanta-waasi ");
INSERT INTO auy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","tatúwaandu untembá inaí séꞌómbani. Minkwáásísóné tuwímbai-inintone Ísun-anówawe Ísun-áfáꞌawaawiye tatúwaandu urésa inaí séꞌómbani. ");
INSERT INTO auy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Inaí símasimaꞌa wéesa moórá-kanaa sáwífaꞌ-waasi 120 waasi Ísuni waási tatúwaandu urówana Pítaa íyáfasinena simátimena séna ");
INSERT INTO auy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","kesí waásisono. Naaófáꞌá Maníkóní Ufaen-ámútánkó kentáá síwáꞌnágon-awiꞌa Téfítimba simámena Yúndasi-aai súwana agaimakáimba póna minááí paápé íníye. Ááéma kentáásáfénawe Yúndasintafenawe Ísu kesí kísau máéro séna sáántowata aantá-kisausa maiyáumne. Ánaaemba Yúndasi tíꞌmaena túwasa Ísumba taꞌótoꞌmaesa ándáfaꞌa ánkaraawe. ");
INSERT INTO auy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yúndasi misáwí-kísáúgóní méyámbá óntamba maiyéna maramá méyánuwasuwena mimbáráfáꞌá ándáma maiyéna weyááríkaꞌa waandaꞌá faréna ámúꞌa tufánkuwana ayánaruntomba marapátá kunturáiye. ");
INSERT INTO auy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yérúsaremufaken-kwaasi isésa miwí tááifinkemba mimbárágón-áwíꞌa Akendamafaꞌan-iye sésa waéꞌmai-awiꞌa naae-máráfáꞌán-iye siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Énifo imó agaimakón-aufaifimba Téfíti agaimaréna séna wení naambá tuꞌnambá ínasa mimpímbá ímba waási wéwaewe agaimaréna séna moóráfaꞌa agaimaréna séna wení kísauraꞌa moóráwigo íyámainiye agaimaréna siyónkaꞌa póta ");
INSERT INTO auy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","moóráwigo Yúndasini kísauraꞌo íyámaindawimba saafá úmaisa aiyánaumne. Ísu Káráísiti pukáimpinkembo íyáfasinkain-aai weséta táásái úmai simátímaꞌmaeta kondasá póta Yóni nombá wémaitinkowana Ísu kísaumo ómbarena maiyówata kuré-tiyeta úmae wénowananasa Maníkó Ísumba kunaiyówana wíyómpaꞌa iyúwasa awánaraawifinkemba moóráwigomba aíyáananasa wemá Yúndasimo tukáin-kisau íyámainiye Pítaa simásuwowasa ");
INSERT INTO auy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","isésa kaeꞌ-wáásí túwíꞌa tésa moóráwigo kaumbo-áwíꞌó simánkaraawi moórá-awiꞌa Yósepini moórá-awiꞌa Pásapasini moórá-awiꞌa Yásítasi úwana moóráwigon-awiꞌa Mátáyáasi mindárai-tuwiꞌa tásuwesa ");
INSERT INTO auy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","inaí sésa Fasiꞌaénkóo seyaafáꞌ-wáásítí imáyáa awáné tirumbá tuwáné minkáéꞌ-wáásífínkémbá nááwa Yúndasini kísau aantá-kisau íyámainiyo aráásímínata awánaano. ");
INSERT INTO auy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yúndasi wení kísau ifátuwena puwéna wení kísaugoni méyámbá sáwí-marupaꞌa kunkáiye sésa ");
INSERT INTO auy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","inaí simásuwesa kaeꞌ-wáásí túwíꞌa kaeꞌ-wándááífímbá agaimái anaféúmpímbá uféꞌmárówana moóráwigo moórá-wandaai mósá maiyéna awánómba Mátáyáasiye sésa agaimárówana aantá-waasi sísamaifakemba moórá kumbaimái-waasifimba kogísau maiyáiye. ");
INSERT INTO auy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ánaaemba tómbá fákáꞌmai Maníkóntáfésa ísámai kaundánae sésa túwaandu un-kánáá túwasa Ísun-aaisafesa timankúnkúmbo uwáí seyaafáꞌá mimbórá-náúmpáꞌá túwaandu urówana ");
INSERT INTO auy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","minúwóíyáán-úwana wíyómpakemba óraa-fiyundaraamba torówasa wéisowana méron-daumpaꞌa kuména ówitowana ");
INSERT INTO auy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","iyaronkáán-tántááꞌá paápé uréna tafántafan-ena moórá-mora-waasi tinepimpáꞌá wété úwana ");
INSERT INTO auy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Maníkóní Ufaen-ámútánkó tirumpimbá óraaꞌa uwátinkowasa mérowana Maníkóní ámútanko fasiꞌaémbá timúwasa fíꞌo-fiꞌon-kwaasi-taaifinkemba siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tómbá fákáꞌmai Maníkóntáfésa ísámai kaundánae sésa túwaandu un-kánáá túntafesa Yúndaa-waasi Maníkón-ímáyáá mósá márówi fíꞌo-fiꞌom-barafakemba Yérúsaremu-naopaꞌa tatúwaandu urówana ");
INSERT INTO auy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","fiyúndáraambo torónkaꞌa isésa mindámbó wéropaꞌa tatúwaandu uwasá miwí tááifinkemba wésuwasa isésa táátafesa ésa ");
INSERT INTO auy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","áfááraumai imáyáa ésa sésa wésewi seyaafáꞌá Kárírifakewi minááí wésewin-owe sésa ");
INSERT INTO auy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","moórá-mora-waasi sésa kesááifinken-aaiye simásaraawe. ");
INSERT INTO auy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kesáámá tuwímbai Páátiyaa-marafakewisa únasa tuwímbai Míndiyaa-marafakewisa únasa tuwímbai Írámu-marafakewisa únasa tuwímbai Másépótemiyaa-marafakewisa únasa tuwímbai Yúndiyaa-marafakewisa únasa tuwímbai Kápándósiyaa-marafakewisa únasa tuwímbai Póntási-marafakewisa únasa tuwímbai Ésiyaa-marafakewisa únasa ");
INSERT INTO auy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","tuwímbai Fírísiyaa-marafakewisa únasa tuwímbai Pámpíriyaa-marafakewisa únasa tuwímbai Ísípi-marafakewisa únasa tuwímbai Rípíyaa-marafakewisa Sáíríni-maragoni ewaakéwísá únasa tuwímbai Rómu-naopakewisa miyáumai-naopakemba tatúwaandu éta ");
INSERT INTO auy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Rómu-naopakewisa tuwímbai Yúndaa-waasisa únasa tuwímbai fíꞌon-ampaꞌa tuwéta Yúndaa-amaan-ampata wéaraaiwaeta énifo tuwímbai Kíríti-marafakewisa únasa tuwímbai Árépiyaa-marafakewisa tatúwaandu uráunasasa Maníkó kawe-kísáú maiyáin-aai wésesa moórá-mora-waasi kesááifinkenta sewatá wéisaumne sésa ");
INSERT INTO auy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","táátafesa ésa áfááran-imayaa ésa isaisa ésa sésa mintántáákóní áwáuma nóra íníyo suwasá ");
INSERT INTO auy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","tuwímbai wíyáái ésa sésa miwí uwóíꞌo on-dómbá nésa uwóíꞌa ésa fíꞌo-fiꞌon-kwaasi-taaifinkemba wésewe siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Simásúwówana aantá-waasi 11 waasi íyáfasinompimba Pítaa íyáfasinena túwaandu urón-kwaasisafena óraakaꞌa simátimena séna kesí Yúndaa-waasisono. Yérúsaremu-naopaken-kwaasiye fíꞌom-barafaken-Yundaa-waasiye ísáaro. Kárírifakewi fíꞌo-fiꞌon-kwaasi-taaifinkembo wésewini áwáuma simátimumpo ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Uwóíꞌo on-dómbá nésa uwóíꞌa owémó sembá minkwáásí ímba uwóíꞌa wéowe. Waási nóꞌwaamba uwóíꞌo on-dómbá nésa uwóíꞌa wéofo káféꞌa aafáyáaraꞌ-aantembanifo minkwáásí ímba uwóíꞌa wéowe. Mintántáákóní áwáu maarán-iye. ");
INSERT INTO auy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Naaófáꞌá Maníkón-aai simátímakowin-awiꞌa Yóweri agaimaréna siyáin-aai wépaape-iye. Maarán-ááí agaimaréna séna ");
INSERT INTO auy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Maníkó séna ánaaen-kanaa maará ónaumne. Kesí ámútambo seyaafáꞌ-wáásímó tíménda kentáánintone kentiyáámúntone kesáái aforaꞌá simátimenaawe. Kentí ifóꞌ-wáásíyé waurán-kwáásíyé kaaimbá awánánááwe. ");
INSERT INTO auy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Éraiꞌa minkánááráꞌá kesí ámútamba kesí kísau-ininakwaꞌo tíménda kesáái aforaꞌá simátimenaawe. ");
INSERT INTO auy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Wíyómpaꞌe marapáꞌé fíꞌo-fiꞌon-kisau-waameꞌo ondá naaewárá iyawárá óraaꞌ-umunkwaraꞌa paápé íníye. ");
INSERT INTO auy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Aafáúgó kumeuꞌá ínana wíyónko naaeríríꞌa ínaꞌa miyámó ondá kesí fíꞌo-fiꞌon-kanaa sámo kain-kánáámó paápé índa ");
INSERT INTO auy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kentáfésamo Fasiꞌaénkówémó síyawi sáwíꞌo úmaimo mérempinkemba kaweꞌ-ámpáꞌá métinkanaumne Maníkó siyáiye Yóweri agaimaréna siyáiye Pítaa minááí simátimena ");
INSERT INTO auy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","séna Ísareri-waasisono. Senda-ááí ísáaro. Maníkó Ísumba Násaretifakewimba fasiꞌaémbá amúwana simámakain-kisau maéna kawe-kísáú fíꞌo-fiꞌon-kisau-waameꞌo uráimba kempímbó úmba awánaraawe. ");
INSERT INTO auy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Naaófáꞌá Maníkó imáyáamo éna miyám-biya ónaumnemo siyáinkaꞌa pósa tuwímbai Ísumba áíꞌmai kembiwí tímúwaꞌa tufuwónae séꞌa sáwí-waasi tímúwasa áíꞌmaesa aaraa-táíyáꞌá tufúwana puwúmbanifo ");
INSERT INTO auy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Maníkó pukómpinkemba íyáfasinankaraiye. Pukéna puwí-áwáúgómá ímba kanaaꞌá taꞌótorowana Maníkó Ísumba faúꞌankowana pukómpinkemba íyáfasinkaiye. ");
INSERT INTO auy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mindásafena naaófáꞌá kentáá síwáꞌnágon-awiꞌa Téfíti Ísun-aai agaimaréna séna aasiyaasí Fasiꞌaénkó keséꞌa méraisaꞌa awánaraumne. Wemá áfomba faiyáísaꞌa póꞌa ímba sáwí-imayaa wéune. ");
INSERT INTO auy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Mindásafeꞌa kesirumbá kaweꞌá uréꞌa Maníkón-áwíꞌa mósá wémaraumne. Púwón-aempaꞌa kesimambá ímba mósiyuwainone. Kesirumbá ámakaundawi ení kísau-waasi únda po pukémpaꞌa ímba másiyuwenana súma kawááꞌa íníye. Mindásafeꞌa méraunda póꞌa imáyáa éꞌa púwóndafinkemba íyáfasisinkainiye. ");
INSERT INTO auy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Púwíndafinkemba íyáfasine maéꞌmaeꞌa ínone séma keséꞌa méraanda póna kesirunkó kaweꞌ-úmai óraaꞌa ínaꞌa ménaumne Téfíti agaimaréna siyáiye Pítaa minááí simátimena séna ");
INSERT INTO auy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","kesí waásisono. Kentáá síwáꞌnágon-awiꞌa Téfítin-aai aforaꞌó simátimunda wemó agaimakáimba ímba wesáféna siyáiye. Wemá puwúwasa utámakowaꞌa wení mararaambá éꞌa awánaraamba póna agaimakáimba ímba wesáféna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Naaófáꞌá Maníkó séna Téfítimo kawáá ménamo uráintemba moóráwigo minákúmpákéwí anondááraꞌa kawáámá méíniye Maníkó siyáimba Téfíti Maníkón-aai simátímakaiwai póna wemá séna Maníkómó siyáin-aai éraiꞌa paápé íníye Téfíti siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Téfíti Maníkómó ánaaembo índa-imayaa éna séna Maníkómó íyáfasinankaiwai Káráísiti puwíndafinkemba íyáfasinainiye súntafena séna pukén-aempaꞌa ímba móauwainana áúma kawááꞌa íníyemo Téfíti súmba ");
INSERT INTO auy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","mindá Ísuntafena siyáiye. Énifo Maníkó Ísumba pukómpinkemba íyáfasinankowata éta awánaraumne. ");
INSERT INTO auy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Maníkó kunáíꞌmaena óraaꞌ-waasi póna ayáánúrapaꞌa fasiꞌaén-áémpáꞌá móankena wení Ufaen-ámútámbá ámakaiye. Afowámó séna éraiꞌa kesí ámútamba aménaumnemo siyáintemba ámakaisana wení ámútamba kembá símakaimba wéiseꞌa suwánéꞌa wéowe Pítaa minááí simátimena séna ");
INSERT INTO auy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Téfíti ímba wíyómpaꞌo iyáiwai séna kesí Fasiꞌaénkóntáféna séna Maníkó séna kesiyáánúrapaꞌa fasiꞌaén-áémpáꞌá maraꞌá ménaꞌa ");
INSERT INTO auy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ení namuro-wáásí íyáákaanasa miwí taiꞌánááwe Téfíti siyáiye. Wemá ímba wíyómpaꞌo iyáiwai póna wesáféna ímba siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Énifo kembiwí aaraa-táíyáꞌá tufúkáawintafena Maníkó séna kemá íyáfasinankaundawi Káráísiti éna Fasiꞌaénkón-iyemo Maníkó siyáimba pósa Ísareri-waasi kaweꞌ-úmai ísáaro Pítaa simátimuwasa ");
INSERT INTO auy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ísómba tirunkó umbaí tówasa Pítaane aantá-waasisafesawe sésa sáwíta uráumpo nóra ondasáfénawa síyó suwaná ");
INSERT INTO auy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pítaa séna kembiwí misáwí-ímáyáá tínaaemba uwámeꞌa Maníkómpáꞌá téꞌa Ísu Káráísitintafeꞌa ísámai nombá máéro. Mindásafena kentí sáwí-imayaa maitiyuwéna Maníkóní Ufaen-ámútámbá úwoi timíníye. ");
INSERT INTO auy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maníkó kempáꞌá terómó sindawí kesí ámútamba timénaumne Maníkó siyáimba pósa kembiwíyé kentíráátone fíꞌo-fiꞌom-barafakewiye fasiꞌaén-ááí siyáiye Pítaa siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pítaa simátimena fíꞌo-fiꞌon-aai kaweꞌ-ááíwáráꞌá simátimena óraakaꞌa séna káféꞌo sáwí-waasi méraawimo éꞌa sáwí-meyamba maénááwe. Kemá káféꞌa sáwí-ampaꞌa tuwéꞌo éꞌa ímba sáwí-meyamba maénááwe Pítaa súwasa ");
INSERT INTO auy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","sáwífaꞌ-waasi isésa wenááisafesa éraiꞌe sésa nombá wémaesa minkánáá sáwífaꞌ-waasi 3,000 waasi Ísun-aaisafesa timankúnkúmba uwasá Ísuni waási sáwífaꞌ-waasi-iꞌa ésa ");
INSERT INTO auy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","túwaandu uwáfaꞌa iyésa aantá-waasi Ísun-aai simátímaꞌmaesa waafán-kwáásí wéiyesa moórá-mora-waasi wétuwaꞌnai-esa Ísuntafesa ísámai aráá-tomba wénesa inaí símae iyáawe. ");
INSERT INTO auy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Inaí símaesa wéiyesa miyámó umbá aantá-waasi kawe-kísáú fíꞌo-fiꞌon-kisau máúwasa pósa seyaafáꞌnánká táátafesa uwasá ");
INSERT INTO auy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ísun-aaisafesa timankúnkúmbo uwáí mimbórá-ímáyáá wéesa túwaandu wéesa imáyáa ésa kentáásí moparáwímbá waafáníꞌan-iye sésa ");
INSERT INTO auy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","miwítí marawé miwítí moparáwíné fíꞌon-kwaasi timésa óntamba maiyésa tuwínkaaꞌ-úmai ímbo makón-kwaasi timésa ");
INSERT INTO auy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","aasiyaasi-kánáá Yúndaa-waasiti óraaꞌ-amaan-daumpaꞌa Maníkóntáfésa ísámai túwaandu wéesa fíꞌowiti naaúmpimpaꞌa komésa Ísuntafesa ísámai aráá-tomba wénesa tirumbá kaweꞌ-úmai mésa tómbá tuwínkaaꞌ-úmai tímaꞌmai wénesa ");
INSERT INTO auy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Maníkón-áwíꞌa mósá márówasa seyaafáꞌnánká tuwánésa miwísáfésa kaweꞌá wéowe suwaná sáwíꞌo urómpinkemba aasiyaasi-kánáá Fasiꞌaénkó tuwímbai kaweꞌ-ámpáꞌá métinkowasa Ísun-aaisafesa timankúnkúmbo uwáíyé túwaandu uráawe. ");
INSERT INTO auy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","2","Moórá-waasi anówa maꞌánkarompinkemba aísamai pukón-kwaasigo mérowasa aasiyaasi-kánáá áíꞌmaesa óraaꞌ-amaan-dankoni ontaráꞌá áwíꞌa sásáꞌ-óntáráꞌá móankarowana ména óraaꞌ-amaan-daumpaꞌo íyún-kwaasisafena óntantafena inaimó sún-kwaasi méronkaꞌa óraaꞌ-amaan-daumpaꞌa Pítaae Yóniyeꞌa íyúyana aafáúmó andeiyónkaꞌa Maníkómpáꞌá inaimó sen-kánááráꞌá íyúyana ");
INSERT INTO auy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tuwánéna séna óntamba símékaiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","túramba afuwésarai Pítaa séna kenkáí suwánaao suyaná ");
INSERT INTO auy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","siméyááye-imayaa éna tuwánówana ");
INSERT INTO auy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pítaa séna óntamba ímba tokáumpo Ísuni fasiꞌaéntámbá kaweꞌá uwánkanaumne. Ísu Káráísiti Násaretifakewin-awikaꞌa súne. Íyáfasine aíntaao súne Pítaa simásuwena ");
INSERT INTO auy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ayáánúrapaꞌa taꞌótoꞌmai íyáfasinankowana aísaune aísarune kaweꞌá úwana ");
INSERT INTO auy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","íyáfasinkwena ásáfaraa táúfaraaꞌa éna aamoí éna Maníkón-áwíꞌa mósá wémarena mindáraiseꞌa óraaꞌ-amaan-daumpaꞌa ");
INSERT INTO auy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","weyááríkaꞌa marapáꞌá iyéna Maníkón-áwíꞌa mósá marówasa seyaafáꞌ-wáásí awánésa ");
INSERT INTO auy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sésa miwá aasiyaasi-kánáá óraaꞌ-amaan-dankoni sásáꞌ-óntáráꞌá ména óntan-inai símasimaꞌo iwáín-iye sésa táátafesa ésa weyááríkaꞌa marapáꞌó iyúntafesa tiyáámba píkinesa táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Weyááríkaꞌa iyéna aamoí éna Pítaante Yóninte tineꞌá taꞌótorowasa seyaafáꞌ-wáásí táátafesa ésa miwífáꞌá tóso ésa óraaꞌ-amaan-daumpaꞌa Soromoní áúwimaimo úmakopaꞌa tóso uwaná ");
INSERT INTO auy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pítaa tuwánéna séna Ísareri-waasisono. Mintántáátáféna ímba tááꞌa íno. Ímba kenkáí kááꞌa súfífáero. Ímba kenkáísí fasiꞌaénkó kaweꞌ-úmai arupíse úmai mékai wéufo ");
INSERT INTO auy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Maníkóní fasiꞌaénkó miyá wéisana minkwáásígó weyááríkaꞌa wéniye. Miyá uráintafena Maníkó Ísun-awiꞌa mósá maréna kentáá síwáꞌná Émbaramuwe Áísáakiye Yékopuwe miwítí Fasiꞌaénkó wení kísau-waasigon-awiꞌa Ísumba póna mósá makáiye. Énifo Ísumba áíꞌmaeꞌa Rómu-kamani-kawaagon-awiꞌa Páíratimpaꞌa kuwaná Páírati séna faúꞌankanae súwaꞌa aꞌáo siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kaweꞌ-wáásí arupíse úmai méron-kwaasigontafeꞌa aꞌáo séꞌa moórá-waasi tufúwana puwúwasa ándáfaꞌa áúkon-kwaasigontafeꞌa faúꞌankaao siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Miyá uráantafeꞌa aúíꞌa úmai maéꞌmaeꞌo íyawini áwáu-waasi kemá tufúwana pukáimpinkemba Maníkó íyáfasinankowakai awánarauye. ");
INSERT INTO auy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Awánarauyawi Ísun-awikoni fasiꞌaénkó aísamaimo pukáin-kwaasi fasiꞌánkáísaꞌa wéawaraawe. Ísu kenkáísí simankúnkúmba wéuwasinkaisana minkwáásí kaweꞌ-úmai wénisaꞌa wéawanaawe Pítaa siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pítaa minááí simátimena séna kembiwíyé kentí kawáá-wáásísé ímba awánamai Ísumba kaweꞌá uréꞌa tufúkáawe. ");
INSERT INTO auy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Naaófáꞌá Maníkó wenáái simátímakowisafena séna simátimeꞌa súne. Kemó íyáfasinankaandawimba sáwíꞌa uwánkanaawe Maníkó siyónkaꞌa póna kembiwí Ísumbo uráamba minááí paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mindásafeꞌa kentí sáwí-imayaa tínaaemba uwámeꞌa Maníkómpáꞌá tíyana Maníkó kentí sáwí-imayaa maitiyuwáíníye. ");
INSERT INTO auy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Moórá-mora-kanaa Fasiꞌaénkó wení fasiꞌaémbá timínaꞌa weséꞌo méraiyantafeꞌa kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌá teró. Maníkó túwaꞌnai ínkwae séna íyáfasinankaraiwaimba Ísumba aiꞌmaráínana kumíndasafeꞌa kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌá teró. ");
INSERT INTO auy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ísu wíyómpaꞌa iméraimba póna ánaaen-kanaamo éna seyaafá-tántááꞌá aúíꞌo índa-kanaa anekaꞌá marapáꞌá kumíníye. Naaófáꞌá Maníkó minááí simátimuwasa Maníkón-aaimo ísón-kwaasi kaweꞌ-wáásí isésa simátímakaawe. ");
INSERT INTO auy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Maníkón-aai simátímakowin-awiꞌa Mósese séna Maníkó kentí Fasiꞌaénkó kembá kesí kísau mauwó séna siꞌmákainten-úmai Maníkón-aaimo simátimindawimba keándáfakemba moóráwigomba aiꞌmaráínana wenáái simátiminasa isánááwe. ");
INSERT INTO auy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ímbo isáíyawimo éna Maníkó wení waásifinkemba tiꞌmátuwena tínkaminasa puwónááwe Mósese siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Maníkón-aai simátímakowin-awiꞌa Sámúwéri simátímakonkaꞌa ánaaen-kwaasi simátimeꞌontemba maami kífé-kanaa wépaape-iye. ");
INSERT INTO auy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Naaófáꞌá Maníkó kentáá síwáꞌnán-awiꞌa Émbaramuntafena séna enándáfákén-kwáásísáféna seyaafáꞌ-máráfákén-kwáásí kaweꞌá uwátinkanaumne Maníkó óraaka siyáiye. Émbaramun-andafaken-kwaasi owaná póna kembiwísáféna Maníkó minááí óraaka siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Miyáumai Maníkó Ísuntafena kesí kísau mauwó séna aiꞌmarówana kempímbá kunkáiye. Seyaafáꞌá kentí sáwí-imayaa tínaaemba uwámiyana aifaꞌá kembiwí kaweꞌá uwátinkaindasafena kempímbá kunkáiye Pítaa Ísareri-waasisafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Óraaꞌ-amaan-daumpaꞌa Pítaae Yóniye wésimatimuyasa ámáán-kisau-waasiye ámáán-dankaꞌo káráwiyowiye Sátúsi-amaan-aaimo sun-kwáásíyé tóso ésa ");
INSERT INTO auy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","miwí táái taisésa aaisambá suwasaráí mindárai Ísu pukáimpinkembo íyáfasinkain-aai simátímúyasa úwoi-waasi isésa sésa Ísu pukáimpinkembo íyáfasinkaintafesa seyaafáꞌ-wáásí pukémpinkemba íyáfasinanaawe suwasá minááí isésa karoꞌé sésa aaisambá sésa ");
INSERT INTO auy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","mindárai taꞌótoresa sésa fénáímba póta aafáyáarata aaifintá maitinkánaumne sésa kawáá-wáásí ándáfaꞌa tínkómbanifo ");
INSERT INTO auy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","úwoi-waasi sáwífaꞌa 5,000 waasi mindárai-taaisafesa timankúnkúmba uráawe. ");
INSERT INTO auy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Aafáyáaraꞌa aaifimbá maitinkánaumne sésa waiyómba aafáyáaraꞌa Yérúsaremu-naopaꞌa Yúndaa-kawaa-waasiye óraaꞌ-waasiye ámáámbo sun-kwáásíyé miyáumai-waasi miwí táái isánae sésa túwaandu ésa ");
INSERT INTO auy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","aifaꞌ-ámáán-káwáágón-áwíꞌa Ánásiye wení akún-ándá-wáásíyé Káyafaasiye Yóniye Árékísandaawe túwaandu ésa ");
INSERT INTO auy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pítaante Yóninte táántowasarai tuyasá tísai esa sésa aísamaimo pukáin-kwaasi nóra urááyo. Nááwani fasiꞌaéná kenkáífímbá wéraisakaiya kaweꞌá uwánkaraayo. Nááwan-awira sékaiya kaweꞌá uwánkaraayo suwaná ");
INSERT INTO auy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Maníkóní Ufaen-ámútánkó wempímbá óraaꞌa uwánkowana Pítaa séna Ísareri-kawaa-waasiye óraaꞌ-waasiye ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Aísamaimo pukáin-kwaasi kaweꞌó uwánkaraundasafeꞌa wésisai-owe. Nóra séra kaweꞌó uwánkaraundasafeꞌa wésisai-o. ");
INSERT INTO auy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aforaꞌó simátíménda kembiwíyé seyaafáꞌ-Ísárérí-wáásíyé ísáaro. Ísu Káráísiti Násaretifakewimba aaraa-táíyáꞌá tufúwówana Maníkó pukómpinkemba íyáfasinankaraiwaimba wenáwíkaꞌa súyana wení fasiꞌaénkó minkwáásí kaweꞌá uwánkáísana kempímbá kaweꞌ-úmai méraisaꞌa wéawanaawe. ");
INSERT INTO auy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Maníkón-aai aúfáífimba Ísun-aai agaimaréna séna óntan-dambo on-kwáásí moórá-ontantafesa sáwíꞌan-iye sésa maisukáawe. Ánaaemba minóntánkó áfonkaamba uráiye minááí Ísuntafena agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","We aantemba sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpátá méwésinkaiye. Maníkó séna wenáwíkaꞌ-aantemba wení fasiꞌaénkó aantemba waási sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkainiye Pítaa siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pítaa minááí simátimena mindárai ímba tááꞌa úwasarai óraaka simátímúyasa minkáwáá-wáásí tuwánésa táátafesa ésa mindárai úwoi-waasiyai ímbo uwáítáíꞌ-urááyan-kwaasin-oye sésa táátafesa ésa sésa Ísuweꞌo núyantafesarai miyá wéoye sésa ");
INSERT INTO auy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","awánomba Pítaante Yónintepaꞌa aísamai kaweꞌó uwánkaroyan-kwaasi mérowasa awánésa mindáraimo simátimiyan-aaisafesa saafá uwááesa ifátuwesa ");
INSERT INTO auy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","sésa máápaꞌa kúmókaiyo suwasaráí kúmúyasa minkáwáá-wáásí keáímbá sésa ");
INSERT INTO auy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","mindárai nórasaawa ónaumno. Fíꞌon-kisau kawe-kísáú maiyááyamba pósa Yérúsaremufaken-kwaasi seyaafáꞌá ísáámba póta ímba karoꞌésá sénaumpo ");
INSERT INTO auy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","fíꞌo-fiꞌon-daopaken-kwaasi ímba isáíyantafeta mindáraisafeta simátimeta séta Ísun-awikaꞌa ímba simátímékaiyosa sénaumne sésa ");
INSERT INTO auy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","táántowasarai íyúyasa sésa Ísun-aai ímba simátímékaiyo. Ísun-awiꞌa ímba sekaiyó suwasaráí ");
INSERT INTO auy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pítaae Yóniye sésarai kemó miyá simásinkaiyakaimo Maníkón-aaimo tuwékai Maníkón-aúrankaꞌa kawerá íníyai ke minááí anekaꞌá ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Keráímó awánarauyan-tantaaꞌe ísarauyan-tantaaꞌe ímba tuwáyaufo úwoi simátimeyauye suyasá ");
INSERT INTO auy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","kawáá-wáásí anekaꞌá óraaka simátimesa sésa énifo úwoi kárúwaakaiyo siyáawe. Aísamai kaweꞌó uwánkaron-kwaasi kaeꞌ-wááí-áátáíyáꞌá ímba weyááríkaꞌa wénuwasarai kaweꞌá uwánkóyasa úwoi-waasi isésa Maníkón-áwíꞌa mósá maróntafesa mindárai ímbo tínkamuyamba úwoi kárúwaakaiyo siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kárúwaakaiyo suwasaráí Pítaae Yóniye kentí waásifaꞌa tésarai óraaꞌ-amaan-kisau-waasiye óraaꞌ-waasiyemo sun-ááí másimátímúyasa ");
INSERT INTO auy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","isésa Maníkómpáꞌá inaí sésa Fasiꞌaénkóo wíyóne marawé uwí-nóné úmare miwán-arumpimbo úmakaanda-tantaaꞌwarakaꞌa wégawaanone. ");
INSERT INTO auy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Naaófáꞌá emá sunaná ení Ufaen-ámútánkó ení kísau-waasi kentáá síwáꞌnágomba Téfítimba kusimámuwana agaimaréna séna nóintafesawa fíꞌom-barafakewi aaisambá sésawa nóintafesawa tufuwíyan-aai siyááesa áúkaawe. ");
INSERT INTO auy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Fíꞌom-barafaken-kawaa-waasi toꞌmayaa úmae tatúwaandu ésa Fasiꞌaénkónté wemó íyáfasinankaiwainte tiyátinkanae siyáawe minááí Téfíti agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Minááí paápé úwasa Yérúsaremu-naopaꞌa Érotiye Póntiyasi-Páíratiye fíꞌonkaa-waasiye Ísareri-waasiye túwaandu ésa Ísumbo tufuwíyan-aai sésa emó íyáfasinankaandawimba ení kawe-kísáú-wáásí Ísuntafesa tufuwíyan-aai siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naaófáꞌó emó miyá ónááwemo siyáanda pósa túwaandu ésa miyá uráawe. Emó ímba miyá ónááwemo siyáandarakaa ímba Ísumba tufúkáawisino. ");
INSERT INTO auy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Fasiꞌaénkóo óraaꞌ-amaan-kisau-waasi tááimo símaimo taráíyaamba ísaraanda po súwaꞌnai ínonda póta ímba inkaiséta enáái úwoi óraakata simátimenaumne. ");
INSERT INTO auy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ení fasiꞌaémbá símínata tíꞌo índa-waasisa asófatinkafata konó. Ení kawe-kísáú-wáásígón-áwíꞌa Ísuwe súnanasa wení fasiꞌaénkó fíꞌo-fiꞌon-kisau kawe-kísáú paápé íníye ");
INSERT INTO auy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","inaí simásúwówana túwaandu urón-daumpaꞌa toraꞌnááraꞌa úwana Maníkóní Ufaen-ámútánkó miwífímbá óraaꞌa uwátinkowasa Maníkón-aai óraaka simátímaꞌmae kuráawe. ");
INSERT INTO auy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ísumpaꞌa timankúnkúmbo uwáí mimbórá-ímáyáá wéesa mésa kentí moparáwíntáfésa ímba kendé aantembaniye wésesa úwoi moórá-mora tímaꞌmaesa kuwasá ");
INSERT INTO auy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","aantá-waasi áfááraumai fasiꞌaénkwáráꞌá mésa Ísu pukómpinkembo íyáfasinkain-aai óraaka simátímaꞌmae wéwesa Maníkó aantá-waasi túwaꞌnai úntafesa kawe-kísáú maimaé wéguwasa ");
INSERT INTO auy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ísuni aampaꞌó kuwáí marawé naanémó makówi fíꞌon-kwaasi timésa óntamba maiyésa aantá-waasi tímúwasa tuwínkaaꞌ-úmai ímbo makón-kwaasi tímakaafo Ísuni aampaꞌó kuwáí seyaafá-tántááꞌá ímba aáfáán-túwówana ");
INSERT INTO auy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","moóráwigon-awiꞌa Yósepiwaraꞌa miyá éna moórá-marama fíꞌon-kwaasigomba aména óntamba maiyéna aantá-waasi tiména wemá Rífáin-andafakewi Sáíparasi-aempakemba tamérowasa aantá-waasi moórá-awiꞌa simánkesa Kíríki-taaifinkemba Páánápáasiye sésa waéꞌmai-awiꞌa tiráfaiyaiwain-iyemo suwáí minóntámbá tímakaiye. ");
INSERT INTO auy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Páánápáasi minóntámbá tímúwasarai moóráwigon-awiꞌa Ánánáyasi úwana awaainínkón-áwíꞌa Sáfáíraaeꞌa mésarai moórá-marama fíꞌon-kwaasi timésarai óntamba maiyésarai ");
INSERT INTO auy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","tuwináyauyo awaainínkómbá simámuwana miyá ínone súwana minóntámbá tuwínkaaꞌ-uréna tuwímbai wesáféna maéna tuwímbai maimaéna aantá-waasi mótimena karoꞌá séna seyaafáꞌá timúne súwana ");
INSERT INTO auy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pítaa séna Ánánáyasiyo waántáwanko áísai úmai isánae sintáfé ewé sé mararákén-óntámbá seyaafáꞌá timúnemo sénda Maníkóní Ufaen-ámútánkómbá karoꞌá simánkaane. ");
INSERT INTO auy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mimbárámá ení maramá isa tuwé óntamba maiyé ení óntamba isa tuwímbai timé ímba sáwíꞌa éma mararákén-óntámbá tuwímbai timúne ímbo sénda seyaafáꞌá timúne séndama sáwíꞌa ómpo ímba waási aantemba karoꞌá simátinkaampo Maníkóní Ufaen-ámútánkómbá karoꞌá simánkaane Pítaa súwana ");
INSERT INTO auy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ánánáyasi iséna puꞌmaéna kuntúwasa minááímó ísón-kwaasi áfááraumai táátafesa uwasá ");
INSERT INTO auy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ifóꞌ-wáásí tésa puwúmba taasááúmaesa maimaésa máutaraawe. ");
INSERT INTO auy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Máwautowana awaainínkó kárikaꞌa ména awaaikómó puwún-aai ímba ísarena Pítaa-iyaifaꞌa túwana ");
INSERT INTO auy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pítaa séna kenkáítí mararákén-óntámbá seyaafárá símakaayo súwana minínínkó séna ewé seyaafáꞌán-iye karoꞌá súwana ");
INSERT INTO auy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pítaa séna enawaaikóe eséꞌa mimbórá-ímáyáá ékai Fasiꞌaénkóní ámútankomba karoꞌá simánkámai awánáyae siyááye. Enawaaiꞌó máwautaan-kwaasi tésa embá tamaimaésa máutanaawe Pítaa súwana ");
INSERT INTO auy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","puꞌmaéna Pítaan-aísamaifimba kuntúwasa ifóꞌ-wáásí tésa puwúmba taawánésa maimaésa awaaikómbó utopaꞌá máutowasa ");
INSERT INTO auy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Fasiꞌaénkóní waásiye fíꞌon-kwaasiye isésa táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aantá-waasi waási túrankaꞌa fíꞌo-fiꞌon-kisau kawe-kísáú maimaésa íyúwasa Ísumpaꞌa timankúnkúmbo uwáí óraaꞌ-amaan-damba Soromoní áúwimai úmakopaꞌa aasiyaasí túwaandu uwasá ");
INSERT INTO auy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","fíꞌo-fiꞌon-akwaꞌa sáwífaꞌa Fasiꞌaénkón-aaisafesa timankúnkúmba ésa miwíséꞌa túwaandu éꞌómbanifo fíꞌon-kwaasi tuwánésa sésa kaweꞌ-wáásín-owe sésa táátafesa ésa ímba miwíséꞌa túwaandu uwasá ");
INSERT INTO auy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","aantá-waasimo uráamba isésa tíꞌo ún-kwaasi taawiyaꞌmaésa marupáꞌá mátinkesa sésa Pítaa wéninana amankókonko taauwétáínasa asófáíwae suwasá ");
INSERT INTO auy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","fíꞌo-fiꞌon-daopakemba tíꞌo ún-kwaasiwara tirumpimbá sáwí-amutambo méron-kwaasiwaraꞌa tíꞌmaesa Yérúsaremu-naopaꞌa mátínkówana Maníkó Pítaamba áwaꞌnai úwasa seyaafáꞌá asófasaraawe. ");
INSERT INTO auy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Miyá wéuwana aifaꞌ-ámáán-káwáágóe wení waási Sátúsi-amaan-aaimo sun-kwáásíyé sésa seyaafáꞌá ímba kentáásiraaima wáéfo aantá-waasi tirááíma wáéwe sésa tíyántafesa ésa ");
INSERT INTO auy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","taꞌótoꞌmai ándáfaꞌa tiyúwówana ");
INSERT INTO auy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","mindóꞌwáámbó waúnkaꞌa Fasiꞌaénkóní kísau-waasigo wíyómpakewi ontamá tisuwéna tíꞌmaena máápaꞌa mútinkena séna ");
INSERT INTO auy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","óraaꞌ-amaan-daumpaꞌa iméꞌa aú-amba waási kaweꞌ-úmai maéꞌmaeꞌo íyan-ankoni áwáuma isimátíméro súwasa ");
INSERT INTO auy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","isésa siyarónkaꞌa óraaꞌ-amaan-daumpaꞌa imésa minááí simátímakaawe. Óraaꞌ-amaan-daumpaꞌa moóráfaꞌa wésimatimuwasa moóráfaꞌa aifaꞌ-ámáán-káwáágówé wení waásiye tésa ándá-waasi-taai isánae sésa Ísareri-oraaꞌ-waasi táántowasa tésa ámáán-dankaꞌ-i-waasisafesa sésa aantá-waasi ándáfaꞌa méraafo kotíꞌmaeꞌa teró suwasá ");
INSERT INTO auy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","kumbá ímba mérowasa kouwerésa tésa sésa ");
INSERT INTO auy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ándá-namba ontamá wisuwésa i-wáásí ontaráꞌá méraawata ontá tisuwéta awánáúndasa ímba méraawata úne suwasá ");
INSERT INTO auy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ámáán-kawaa-waasiye ámáán-dankaꞌo káráwiyowiye isésa táátafesa ésa sésa mindá nórasaawa ónaumno simásuwesa sáwífaꞌ-imayaa wéuwana ");
INSERT INTO auy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","moóráwigo téna séna ándáfaꞌo mátíyukaan-kwaasi óraaꞌ-amaan-daumpaꞌa mésa wésimatimewaꞌa tuwánáúmne súwasa ");
INSERT INTO auy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ámáán-dankaꞌo káráwiyowiye wembó áwaꞌnai un-kwáásíyé kotíꞌmaesa aáno úmai tésa sésa úwoi-waasi miwí táái isésa sínkamofo sésa aáno úmai ");
INSERT INTO auy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","tíꞌmaesa aaimó isáí-wáásífáꞌá mátínkówana aifaꞌ-ámáán-káwáágó ");
INSERT INTO auy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","séna éꞌa simátime séta minkwáásígón-aai wenáwíkaꞌa ímba simátímaꞌmaeꞌa korósá siyáundasa isaꞌá éꞌa simátíméwasa Yérúsaremufaken-kwaasi seyaafáꞌá ísásaraawaꞌa ke karo-súfímbá sinkéta minkwáásí tufúkáawe sewé aifaꞌ-ámáán-káwáágó súwasa ");
INSERT INTO auy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pítaawe aantá-waasiye sésa Maníkón-aai aifaráán-ááígó póna waási-taaigomba íyáákaraimba póta kentááisa ínta iséta Maníkón-aaisa iséta miyásá ónaumne. ");
INSERT INTO auy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kembiwí Ísumba aaraa-táíyáꞌá tufúwana puwúwana kentáá síwáꞌnáti Maníkó Ísumba pukáimpinkemba íyáfasinankena ");
INSERT INTO auy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","séna óraaꞌ-waasi póna sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkainiye séna ayáánúrapaꞌa fasiꞌaén-áémpáꞌá móankena Ísareri-waasi kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌá tíyana kentí sáwí-imayaa maitiyuwáíníye séna Maníkó Ísumba pukómpinkemba íyáfasinankena ayáánúrapaꞌa fasiꞌaén-áémpáꞌá móankaraiye. ");
INSERT INTO auy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Minááí iséta kaweꞌ-úmaisa simátimunanasa Maníkóní Ufaen-ámútánkó minááí kaweꞌ-úmai wésimatimiye. Maníkó wenáái ísámai kaweꞌó owí wení ámútamba wétimisana Maníkóní Ufaen-ámútánkó minááí wésimatimiye aantá-waasi siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Simásúwówasa aaimó ísáán-kwaasi isésa tirunkó sáwíteꞌa úwasa tínkamonae-imayaa uwaná ");
INSERT INTO auy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","miwífínkémbá moóráwigo íyáfasinena ámáán-kawaa-waasigon-awiꞌa Kámérieri íyáfasinena miwí táái taráísuwena wemá Maníkón-aai aúfáífinkemba aasiyaasí simátimuwasa wenáwíꞌa mósá wémarowi íyáfasinena aantá-waasisafena séna kárikaꞌa máápaꞌa kumónááwe súwasa máápaꞌa kúmúwana ");
INSERT INTO auy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","séna Ísareri-waasisono. Maaminkwáásísáféꞌa miyá ónaemo síyamba ékaꞌa imáyáa uréꞌa miyán-oro. ");
INSERT INTO auy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ááéma moóráwigon-awiꞌa Tíútasi íyáfasinena séna óraaꞌ-waasi únda póꞌa kesiráái aantemba waénááwe súwasa sáwífaꞌ-waasi 400 waasi arááíwáúwana moóráwigo Tíútasimba tufúwana puwúwasa wembó arááíwaꞌmaesamo nún-kwaasi wété ésa wení kísau ifátukaawe. ");
INSERT INTO auy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Minkákémbá túwíꞌo faríyón-kanaa moóráwigo Kárírifakewin-awiꞌa Yúndasi íyáfasinena táántowasa sáwífaꞌ-waasi wenarááíma waꞌmaésa wéguwana moóráwigo tufúwana puwúwasa wembó arááíwaꞌmaesamo nún-kwaasi wété uwáguraawe. ");
INSERT INTO auy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mindásafeꞌa imáyáa éꞌa maaminkwáásísómbá ímba ándáfaꞌa mátiyuweꞌa ifátúwéwasa méraaro. Miwítí kísaugoni áwáumo mararáꞌ-wáásítí imáyáafinkembo énamo éna taiꞌáíníye. ");
INSERT INTO auy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Miwítí kísaugoni áwáumo Maníkóní imáyáafinkembo ínaꞌo éꞌa ímba kanaaꞌá taraisónááfo úwoi waéꞌwaeꞌa íníye. Maníkómpákémbó ínaꞌo éꞌa minkwáásí sáwíꞌo uwátinkeꞌo éꞌa Maníkónkwáráꞌá sáwíꞌa uwánkanaawe Kámérieri súwasa aaimó ísáán-kwaasi isésa wenááisafesa ewé sésa ");
INSERT INTO auy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","aantá-waasi táántowasa íyúwasa túwiyonkuꞌ-nésa óraaka sésa Ísun-aai wení fasiꞌaémbá ímba simátíméro sésa tiꞌmákaawe. ");
INSERT INTO auy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tiꞌmárówasa wéesa tigaesáfésa uráawisina Maníkó imáyáa timúwana tirunkó kaweꞌá úwasa sésa Maníkó fasiꞌaémbá símakaisata Ísuntafeta fasiꞌámaisa méraundasa pósa síꞌo índa-iꞌo uwásínkéntaanifo sirunkó kaweꞌá ínata méranaumne aantá-waasi simásuwesa ");
INSERT INTO auy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","aasiyaasi-kánáá óraaꞌ-amaan-daumpaꞌe waásiti naúmpimpaꞌe Ísuni ásé-aai simátímaꞌmae wénesa Maníkómó íyáfasinankaraiwai Yúndaa-waasisa wéamuꞌmaraundawisa wemá Ísun-iye sésa simátímaꞌmaesa kuráawe. ");
INSERT INTO auy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Simátímaꞌmae kuwasá Ísun-aai isésa sáwífaꞌ-waasi wení aampaꞌá wéwesa méronkaꞌa Yúndaa-waasi fíꞌom-barafaken-kwaasi Kíríki-taaifinken-aaimo sun-kwáásí Yérúsaremufaꞌa méron-Yundaa-waasisafesa íꞌai tinkésa óntamba tuwínkesa Kíríki-ketoꞌ-inimba ímbo tímúnkakemba íꞌai tínkówasa ");
INSERT INTO auy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","mindásafesa aantá-waasi Ísuni aampaꞌó kuwáí seyaafáꞌnánká táántowasa tuwasá sésa Maníkón-aaimo simátimunda-kisau tuwéta óntamba tuwínkaaꞌ-úmai timúnda-kisau maúnafo sésa ");
INSERT INTO auy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","kempínkémbá afakaeté-waasi túwíꞌo síyata óntambo tuwináí-kísáú timénaumne. Miwí kaweꞌ-ímáyááwáráꞌ-wáásí Maníkóní Ufaen-ámútánkó miwífímbá óraaꞌo uwátínkáín-kwaasi túwíꞌa síyata óntambo tuwináí-kísáúsá timéta ");
INSERT INTO auy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kesáá Maníkómpátá inaí wéseta Maníkón-aai simátímaꞌmaeta konó aantá-waasi suwasá ");
INSERT INTO auy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ísówana tirunkó kaweꞌá úwasa afakaeté-waasi túwíꞌo sumbá moóráwigon-awiꞌa Sítífeni wemá Maníkóní Ufaen-ámútánkó wempímbá óraaꞌa uwánkowana Ísuntafena imáyáa éna fasiꞌówi úwana moóráwigo Fírípi úwana moóráwigo Pórókórasi úwana moóráwigo Náíkéna úwana moóráwigo Táímóni úwana moóráwigo Páménasi úwana moóráwigo Níkóráasi wemá Ántíoku-naopaken-kwaasi éna fíꞌon-ampakemba Yúndaa-amaan-ampaꞌa kuréna minkákémbá Ísuni aampaꞌó túwai úwasa ");
INSERT INTO auy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","miyáumai-waasi tíꞌmaesa aantá-waasifaꞌa tuwasá Fasiꞌaénkóní kísaumo maíyantafesa tineꞌá taꞌótokesa Maníkómpáꞌá inaí siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Maníkón-aai simátímaꞌmae kuwasá Yérúsaremu-naopaken-kwaasi sáwífaꞌa Ísuni aampaꞌá kuwasá Maníkóní ámáán-daumpaꞌa kísaumo máún-kwaasi sáwífaꞌa Ísun-aai isésa wení aampaꞌá kuwasá miyá úmae wéwesa sáwífaꞌ-waasi-iꞌa uráawe. ");
INSERT INTO auy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Fasiꞌaénkó Sítífenimba áwaꞌnai úwana fasiꞌaénkwáráꞌá ména seyaafáꞌ-wáásí túrankaꞌa fíꞌo-fiꞌon-kisau kawe-kísáú wémauwasa ");
INSERT INTO auy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","moórá-kanaa tuwímbai Sítífenimpaꞌa tésa karoꞌ-ááíyé-ímáyáá ésa wesimán-kwesiman-esa miwí Yúndaa-waasi ésa tuwímbai Sáíríni-marafakewi uwasá tuwímbai Árékísándiriyaa-marafakewi uwasá tuwímbai Sírísiyaa-marafakewi uwasá tuwímbai Ésiyaa-marafakewi miyáumai-marafaken-kwaasi mimbórá-ámáán-dáúmpáꞌá mésa Sítífenimpaꞌa tésa karoꞌ-ááíyé-ímáyáá ésa wesimán-kwesiman-umbanifo ");
INSERT INTO auy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Maníkóní ámútanko Sítífenimba kaweꞌ-ímáyáá amúwana póna Sítífenin-aaigo miwí táái íyáákowasa ");
INSERT INTO auy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ifátuwesa wésa aúpáꞌá óntamba túwaandu úmai tuwímbai-waasi timésa sésa Sítífeni Mósesemba símai sáwíꞌa uwánkena Maníkómbá símai sáwíꞌa uwánkaraisata ísaraumne. Kosimátíméro suwasá ");
INSERT INTO auy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","minkáróꞌ-ááí tasimátímúwasa úwoi-waasiye óraaꞌ-waasiye ámáámbo sun-kwáásíyé ísówana tirunkó sáwíꞌa úwasa Sítífenimo úpaꞌa tésa tataꞌótoꞌmai áíꞌmaesa ámáán-oraaꞌ-waasifaꞌa máankesa ");
INSERT INTO auy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","karoꞌ-ááímó sun-kwáásí kotíꞌmaesa mátínkówasa karoꞌá sésa minkwáásígó óraaꞌ-amaan-damba símai sáwíꞌa úmae iyéna Móseseni ámáámba símai sáwíꞌa úmae iyéna ");
INSERT INTO auy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","séna naaófáꞌá Mósesemo ámáámbo simátímakain-amaamba Ísu Násaretifakewi ifátuwena fíꞌon-amaamba wésena Yúndaa-waasiti óraaꞌ- amaan-damba tawísísuwainiye Sítífeni siyáiye. Miyán-káróꞌ-ááí suwasá ");
INSERT INTO auy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","seyaafáꞌ-wáásí Sítífenimbo awánomba wíyómpakemba Maníkóní kísau-waasi tóikaamba úkówasa awánaraawe. ");
INSERT INTO auy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Miyá simásúwówana aifaꞌ-ámáán-káwáágó Sítífenimba áísai ena séna sen-ááí éraiꞌ-aaiyaꞌi karoꞌ-ááíyáꞌiyo súwana ");
INSERT INTO auy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sítífeni séna kesifoísáí kesuwaaísáíyo simátíménda ísáaro. Naaófáꞌá kentáá síwáꞌnágo Émbaramu ímba Éraanifaꞌa koméronkaꞌa Mésópótemiyaa-marafaꞌo méronkaꞌa Maníkó fasiꞌaénkwáráwí kuména ");
INSERT INTO auy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Émbaramuntafena séna ení marawárá enamááraawaraꞌa tiyuwé winaꞌá moórá-maramo aráánáméndafaꞌa koméínone súwana ");
INSERT INTO auy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","iséna mimbárámá Kárindiyaa-waasiti marafáꞌá tuwéna témena Éraanifaꞌa tamérowana afowá puwúwana Maníkó aiꞌmarówana témena maafáꞌó méraundafaꞌa túwana ");
INSERT INTO auy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","minkánáá Maníkó ímba maramó amúmba óraaka séna ánaaemba maambárámá enkwárá enaísaafitantambo íyawiwaraꞌa timénaumne. Maníkómó súmba Émbaramu iyámpói ímbo maꞌánkaronkaꞌa minááí simámena ");
INSERT INTO auy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","moórá-aaiwaraꞌa séna enaísaafitantambo íyawi fíꞌon-kwaasiti marafáꞌá koméwasa umbai-kísáú timésa sáwíꞌa uwátínkéwana sáwífaꞌ-aatai 400 aatai taiꞌáínaꞌa ");
INSERT INTO auy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","sáwíꞌo uwátinkaiyawi sáwí-meyamba tíménda pósa enaísaafitantambo íyawi mimbárámá tuwésa maafáꞌá tésa ken-ímáyáá mósá maránááwe séna ");
INSERT INTO auy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","minááí naaófáꞌá Maníkó Émbaramuntafena séna ánaaemba maambárámá enkwárá enaísaafitantambo íyawiwaraꞌa timénaumne siyáimba minááí símai kááísamarena póna túma kárámai araénáémba uwo Maníkó siyáiye. Súwana Émbaramu ména Áísáakimba maꞌankéna afakaumboé-kanaa maisuwéna áúma kárámai araénáémba uwánkowana Áísáaki óraaꞌa éna Yékopumba maꞌankéna áúma kárámai araénáémba uwánkowana Yékopu óraaꞌa éna sísamaifakemba kaeꞌá kumbaimái-iyampoi matinkéna túma kárámai araénáémba uwátínkáfaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Miyá uwátínkáfaꞌa kúwasa mináfáráwáínónda tífákon-awiꞌa Yósepintafesa sésa sínaaenkewi ímba kentááráꞌá káráwiniye sésa tirumbá sáwíꞌa uwánkesa áíꞌmaesa fíꞌon-kwaasiyaꞌa mátinkesa óntamba máúwasa miwí Yósepimba áíꞌmaesa wémesa Ísípi-marafaꞌa máánkówana Maníkó weséꞌa mérowasa ");
INSERT INTO auy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","umbai-kísáú amésa sáwíꞌo uwánkómbanifo Maníkó weséꞌa ména áwaꞌnai ena kaweꞌ-ímáyáá uwánkena wení umbai-tántááꞌá taíꞌánkowana mimbárámá Ísípi-marafaken-kawaago Yósepini kaweꞌ-ímáyáá awánéna séna Ísípi-marafaꞌa seyaafáꞌ-wáásíyáꞌá kaweꞌ-úmai káráwiye kesí moparáwínkáꞌá miyán-uwo súwana wemó súntemba úwana ");
INSERT INTO auy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ánaaemba aawaimá téna Ísípi-marafaꞌe Kénaani-marafaꞌe seyaafáꞌ-áémpáꞌá aawaimá tówasa tááisafe uwaná kentáá síwáꞌnásomba tómbá ímba miwífímbá wérowana ");
INSERT INTO auy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yékopu séna Ísípi-marafaꞌa tómbá wéraiye-aai isáúmpo koméyánoro séna áánintomba tiꞌmarówasa koméyánúmaesa ");
INSERT INTO auy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tifowámpáꞌá tamérowana mintómbá taiꞌówasa anekaꞌá kuwaná Yósepi miwíséꞌa tamaéna séna kemá Yósepi kentífáko úne súwasa pukáanesa siyáumne suwaná Ísípi-marafaken-kawaago Yósepini áwáuma iséna awaaísái tuwánówana ");
INSERT INTO auy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Yósepi awaaísái simátimena séna kesifombá kosimámiyana wení akúmbá tíꞌmaena Ísípifaꞌa tiyó Yósepi siyé. Kosimáméro Yósepi súwana afowámá iséna wení akúmbá 75 waasi tíꞌmaena Ísípifaꞌa kaweꞌ-úmai komésa púwúwasa ");
INSERT INTO auy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ánaaemba miwí tísaafitomba tiyáántámba maimaésa témesa Síkémufaꞌo máutomba naaófáꞌó Émbaramu Émon-anaankaken-kwaasi óntambo tímakom-barafaꞌa máutaraawe. ");
INSERT INTO auy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Énifo kentáá síwáꞌnásomba Ísípi-marafaꞌa komésa sáwífaꞌ-waasi agaiyáawe. Maníkó Émbaramuntafena fasiꞌaén-ááí séna Kénaani-marama enaísaafitantambo íyawi timénaumne siyóntemba tímínda-kanaa ampáámbó únkaꞌa ");
INSERT INTO auy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","moóráwigo Ísípi-marafaken-kawaago Yósepimo naaófáꞌó pukóntafena wení kísau-aai ímba ísarowi póna ");
INSERT INTO auy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","kentáá síwáꞌnása umbai-kísáú tiména maimái sáwíꞌa wéuwatinkowasa iyámpói máápaꞌa tiyúwówasa pukáawe. ");
INSERT INTO auy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Iyámpóísomba púwúwana minkánááfímbá Mósesemba kaweꞌ-óíꞌwáráꞌ-íyámpóí maꞌánkarena anówama aúpáꞌá naaúmpaꞌa ánkarowana kaumbo-wíyómbá maisuwéna ");
INSERT INTO auy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","máápaꞌa áíꞌmaena múankarowana Ísípifaken-kawaagon-ayáámúnko awánómba aráái tówana kesáánine séna káráwiyowana óraaꞌa úwasa ");
INSERT INTO auy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ísípifaken-kwaasi miwítí áwáuma simámaꞌmaesa íyúwana Mósese wéisena óraaꞌa éna wení kísaugowe wenááigowe kaweꞌá uráiye. ");
INSERT INTO auy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mósese miyá éna kaeꞌ-wááí-áátáí maisuwéna kesí waási Ísareri-waasi kotuwánánae séna kúmba ");
INSERT INTO auy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ísípi-waasigo Ísareri-waasigomba sáwíꞌa uwánkowana Mósese tuwánéna Ísareri-waasi áwaꞌnai ena Ísípi-waasigomba tufúwana puwúwana ");
INSERT INTO auy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mósese imáyáa éna séna Maníkó minkísáúrátáféna íyáfasisinkaraimba póꞌa Ísípifakemba Ísareri-waasi tíꞌmaeꞌo kondá minkísáúsáfésa ewé sénááwe siyáimbanifo Ísareri-waasi ímba miyán-ímáyáá uwaná ");
INSERT INTO auy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mósese kowaiyómba íyáfasinena kúmba Ísareri-waasi kaekó tíyóyana tuwánéna tíyótainda-imayaa éna séna kaeꞌnáraiyo mimbórá-náóraan-ofo tiyááyafo súwana ");
INSERT INTO auy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","aifaꞌó ómbarenamo tiyón-kwaasigo Mósesemba famétuwena séna nááwa embá íyáfasinankaraisawa kentáásí kawááíꞌa éwa aaisá wésimasimeno. ");
INSERT INTO auy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fénáímbo Ísípi-waasimo tufuwónanamo puwéwiyaintena kembá miyáwá ínono súwana ");
INSERT INTO auy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mósese iséna inkaiséna wéme wémena Míndiyaani-marafaꞌa fíꞌon-kwaasiti marafáꞌá koména kaeꞌ-íyámpóí matínkaraiye. ");
INSERT INTO auy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Mósese koména kaeꞌ-íyámpóí matinkéna ména kaeꞌ-wááí-áátáí maisuwéna moórá-kanaa máásai-marafaꞌa wéwena Sáínai-omapaꞌa ewaaꞌó wéronkaꞌa kúwana kári-taiyakemba iyá kéna ímba mintáí kówana Maníkóní kísau-waasigo wíyómpakewi mimpímbá mérowana mintáí ímba kówana ");
INSERT INTO auy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Mósese awánéna óraaꞌ-imayaa éna ewaaꞌá koména awánówana Maníkó séna enaíwáꞌná Émbaramune Áísáakine Yékopune miwítí Maníkó úne súwana Mósese minááí iséna aíyayaankakemba tataꞌá úwana úwoifaꞌa kararówana ");
INSERT INTO auy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Fasiꞌaénkó séna méraandafaꞌa ufaem-bárámá wéraipaꞌan-ifo kaweꞌ-máráfáꞌó méraapaꞌan-ifo maambárámá sáwíꞌa ónafainifo aísamai ánáamba faútuwaao. ");
INSERT INTO auy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ísípifaꞌa kesí waási sáwíꞌo wéuwatinkaawasamo ifiꞌó wétaamba tuwánáúnda póꞌa túwaꞌnai ónaumpo íyáfasinenaꞌa aiꞌmáráana wéme wéme Ísípifaꞌa kuré kesí waási Ísareri-waasi kótíꞌmae Kénaani-marafaꞌa waaó Maníkó Mósesentafena siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Wembá Mósesemba Ísareri-waasi tínaaemba uwámesa sésa nááwa embá íyáfasinankaraisawa kentáásí kawááíꞌa éwa aaisá wésimasimeno siyáawe. Siyáan-kwaasisafena Maníkó minááí siyáiye. Wembá Mósesentafena Maníkóní kísau-waasi wíyómpakewi kári-taiyakemba aaí simámakaiye. Wembá Mósesemba Maníkó kawáá-kísáú aména aiꞌmarówana Ísípifakemba Ísareri-waasi kótíꞌmaena Kénaani-marafaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wemá Mósesema Ísípifaꞌa ímbo awánon-kisau fíꞌon-kisau maúwasa sésa úwoi tíꞌmae kóuwo suwaná tíꞌmaena kúmba nonkón-áwíꞌa naae-nóné supaꞌá wéna ímbo awánon-kisau kawe-kísáú komaéna tíꞌmaena kúmba máásai-marafaꞌa kaeꞌ-wááí-áátáí komérowana ímbo awánon-kisau kawe-kísáú maimaéna iyáiye. ");
INSERT INTO auy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wemá Mósesema simátimena séna Maníkó kembó íyáfasisinkarainten-úmai ánaaemba moóráwigomba kentísaafitantambo íyawifinkemba íyáfasinankainiye. Maníkón-aaimo simátimindawimba íyáfasinankainiye. ");
INSERT INTO auy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wemá Mósesema máásai-marafaꞌo Maníkóní waási Ísareri-waasimo méropaꞌa miwíséꞌa maéna kentáá síwáꞌnásonteꞌa maéna Maníkóní kísau-waasi wíyómpakewi weséꞌa maéna Sáínai-omapaꞌa imérowana Maníkóní kísau-waasigo wíyómpakewi Maníkóní ámáámba simámuwana ímbo taíꞌáín-aai simámuwasa simátímaꞌmaesa kuráanta wéisaumne. ");
INSERT INTO auy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mósese aaimó simátimumba kentáá síwáꞌná ímba isésa tínaaemba uwámesa Ísípifaꞌa tauweránae-imayaa uwaná ");
INSERT INTO auy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ánaaemba Maníkó Mósesemba áántowana omápaꞌa imérowasa Mósese awaaón-áwíꞌa Éronintafesa sésa Mósese Ísípifakembo síkaiwaisa nááfara kóuraiyo. Ímbo awánáúndafata kóuraifo moórá-manikomba uwámakewata wenarááísa wáéno sésa ");
INSERT INTO auy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","óntantamba purumaka-áráákaamba úmaresa minkáróꞌ-máníkóní aamoimá uwánkesa póíma tufúꞌmai wénesa úmárón-tantaatafesa aamoí ésa tóníꞌa úmai wénowana ");
INSERT INTO auy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","mindásafena Maníkó ánaaemba uwátiyuwowasa wíyóne aafáúwé otáfésa kesí maníkón-iye siyáawe. Mindásafena naaófáꞌá Maníkón-aaimo simátímakowi agaimaréna séna Ísareri-waasisono. Máásai-marafaꞌa kaeꞌ-wááí-áátáí méꞌa póíma tufúꞌmai wéneꞌa ímba kentáféꞌa ísámae wéꞌómbanifo ");
INSERT INTO auy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kentí karoꞌ-máníkóntáféꞌa ísámai wení ampanta-námbá maimaéꞌa wénowe. Minkáróꞌ-máníkón-áwíꞌa Mórókiye siyáawe. Okáán-tántááꞌá úmakeꞌa áwíꞌa Réfáániye wéseꞌa toꞌmaéꞌa wénowe. Minkáró-káéꞌ-máníkáí úmareꞌa kesí maníkówé karoꞌá séꞌa áwíꞌa maimaé wéiyowe. Miyámó uráantafeꞌa kentí marafákémbá tiꞌmáráanaꞌa wémeꞌa moórá-marafaꞌa áwíꞌa Pépíróni-marafaꞌa koméranaawe Maníkón-aaimo simátímakowi agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Naaófáꞌá máásai-marafaꞌa Maníkó Mósesemba aráánamena Maníkóní naambó ampantasámbó íyamba maará ónááwe séna aráánamuwasa Maníkómó súntemba miyán-dámbá úmai maimaésa máásai-marafaꞌa néꞌómbaniye. ");
INSERT INTO auy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ánaaemba miwí táánintomba kentáá síwáꞌnásomba mindámbá taawiyáfúwana Yósúwa tíꞌmaena Kénaani-marafaꞌo kúmba Maníkó túwaꞌnai ena mimbáráfáꞌó méron-kwaasi watuwówasa kóuwasa kotafíyesa mindámbá minkáꞌá mámaresa mérowana ánaaemba Téfíti Ísareri-waasiti kawáámó mérompimba mindámbá úwoi wérowana ");
INSERT INTO auy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Téfíti kaweꞌ-úmai mérowana Maníkó aamoí uwánkowana Téfíti Maníkómbá áísai ena séna ení naambá ónaum ína ónaumno. Emá Yékopuni Maníkómá po ewé sinaꞌó éꞌa ení naambá ónaumne súwana ");
INSERT INTO auy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Maníkó séna emá ímba ínompo enááninko Soromoní kesí naambá íníye siyáimbanifo ");
INSERT INTO auy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Maníkó wíyómpaꞌo méraimba waásimo úmakaan-daumpaꞌa ímba méraiye. Mindásafena naaófáꞌá Maníkón-aaimo simátímakowi agaimaréna séna ");
INSERT INTO auy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Fasiꞌaénkó séna wíyómpaꞌa káráwiyeꞌa mararáꞌá káráwiyumpo úmárénda-naumpaꞌa ímba úwoi marapáꞌá kumbénaumne. ");
INSERT INTO auy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kesáféꞌa mintántááꞌá seyaafáꞌá úmakaumne Fasiꞌaénkó siyáiye agaimaréna siyáiye Sítífeni siyáiye. Sítífeni minááí simátimena aaimó ísón-kwaasisafena simátimena séna ");
INSERT INTO auy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","kembiwí tiruntéꞌa wémareꞌa póꞌa Maníkóní aampaꞌó ímbo arááíwáén-kwaasiyaamba éꞌa Maníkón-aai ísáámbanifo ímba ísámai kaweꞌá wéowe. Kentíwáꞌnásomba Maníkóní Ufaen-ámútánkómbá tínaaembo uwámeꞌontemba kemá miyá wéowe. ");
INSERT INTO auy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kentíwáꞌnásomba Maníkón-aai simátímaꞌmaesa wéguwai seyaafáꞌ-wáásí sáwíꞌa uwátinkesa Maníkóní kawe-kísáú-wáásí kumíníye-aaimo simátímakowi tínkamuwasa pukáawe. Ánaaemba wemá kumúwaꞌa pintaruꞌá úmai tufúwana pukáiye. ");
INSERT INTO auy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Énifo wíyómpakewi Maníkóní ámáámba simátímakowaꞌa kembiwí ísaraambanifo ímba ísámai kaweꞌá uráawe Sítífeni siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sítífeni minááímó simátimumba aaimó ísón-kwaasi áfááraumai tirunkó kásíꞌa úwasa tíyántafesa uwaná ");
INSERT INTO auy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sítífenimba Maníkóní Ufaen-ámútánkó wempímbá óraaꞌa uwánkowana wíyómpaꞌo awánómba Maníkóní sámo kaimbá wérowana Ísu Maníkón-ayáánúrapaꞌa fasiꞌaén-áémpáꞌá mérowana Sítífeni awánéna ");
INSERT INTO auy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","séna awánaaro. Wíyómba tuwínkaaꞌ-isaná Maníkón-ayáánúrapaꞌa fasiꞌaén-áémpáꞌá Ísu waási úranko méraimba wéawiyaumne súwasa ");
INSERT INTO auy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","miwí wenáái ímba isánae sésa táákaꞌa awááésa óraakaꞌa aaí sésa Sítífenimba tuwaantantésa ");
INSERT INTO auy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","taꞌótokesa taawiyaꞌmaésa naaókoni awáífáꞌá mátuwesa óntamba maiyésa tufúkáawe. Sítífenintafesa karoꞌ-ááímó siyáawi paákákén-únánkwátói faútúwówana ifóꞌ-wáásígón-áwíꞌa Sóro minúnánkwátói káráwiyowasa ");
INSERT INTO auy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sítífenimba óntantamba tufúwana Fasiꞌaénkónkáꞌá inaifínkémbá séna Ísu Fasiꞌaénkóo kesimambá kumbáínaꞌa púwóno séna ");
INSERT INTO auy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","arauntaúmbá faiyéna óraakaꞌa séna Fasiꞌaénkóo sáwíꞌa wéuwasinkaafo miwí ímba anondáá sáwíꞌa uwátinkaao Sítífeni simásuwena pukáiye. ");
INSERT INTO auy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Sítífenimbo tufúmba Sóron-arunko aamoí uráifo tuwímbai Maníkón-aaisafesa fasiꞌowí Sítífenin-áúma maimaésa máutesa óraaꞌ-ifiꞌa towaná Sóro Ísuni aampaꞌó kuwáí tínkantanae séna kúmba naaúmpimpakemba aarakwáꞌá kotafisímai ándáfaꞌa tíyupaꞌa kúwasa Yérúsaremufaꞌa Ísuni aampaꞌó kuwáí aifaríꞌena sáwíꞌa uwátinkowasa wété uwasá aantá-waasi aantemba Yérúsaremufaꞌa mérowasa fíꞌon-kwaasi Ísuni aampaꞌó kun-kwáásí Yúndiyaa-aempaꞌe Sámériyaa-aempaꞌe wété uráawe. ");
INSERT INTO auy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ísuni aampaꞌó kuwáí wété ésa Ísuni ásé-aai kosimátímaꞌmaesa kuráawe. ");
INSERT INTO auy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fírípi Sámériyaa-naopaꞌo kúmba kosimátimena séna Maníkómó íyáfasinankaraiwai amuꞌmaráúndawisaamo éꞌo kunkáimba wemá Ísun-iye ");
INSERT INTO auy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Fírípi simátimuwasa kaweꞌ-úmai ísówana ímbo awánaron-kisau maúwasa awánowana ");
INSERT INTO auy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","sáwí-amutamba tirumpimbó mérowisafena aaí súwasa sáwí-amutamba wááꞌa túmaesa kóuwasa waási kaweꞌ-úmai mérowana tíyayaambo pukón-kwaasi asófatinkowasa kaweꞌ-úmai mérowana ");
INSERT INTO auy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sámériyaafaken-kwaasi áfááraumai tirunkó kaweꞌá uráiye. ");
INSERT INTO auy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sámériyaa-naopaꞌa moóráwigon-awiꞌa Sáímoni óraaꞌ-waasi úne séna aitambá éna fintó úmaena wéiyuwasa táátafesa ésa ");
INSERT INTO auy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","óraaꞌ-waasiye úwoi-waasiye wemó úmba awánésa wenaráái waésa sésa Maníkóní fasiꞌaénkóe wení fasiꞌaénkóeꞌa awaiyaríꞌa uráiye karoꞌá suwaná ");
INSERT INTO auy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ayáátáákaꞌa aitambá éna fintó úmaena wéguwasa wenaráái waésa táátafesa uráafo ");
INSERT INTO auy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ánaaemba Fírípi Maníkóní ásé-aai kosimátimena Maníkó wení waásimo kawáánin-kanaa kosimátimena Ísu Káráísitin-aai kosimátimuwasa isésa éraiꞌe sésa timankúnkúmba uwaná Fírípi minákwáꞌá nombá maitinkówana ");
INSERT INTO auy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sáímoniwaraꞌa amankúnkúmba úntafena Fírípi nombá maiyankówana Fírípiye wénuwana ímbo awánón-kisau maúwana awánéna áátafena uráiye. ");
INSERT INTO auy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Miyámó Sámériyaafaꞌo úmba Yérúsaremufaꞌa aantá-waasi mésa Sámériyaafaken-kwaasi Maníkóní ásé-aai isésa minááímó métaꞌotokaan-aai isésa Pítaante Yóninte tiꞌmárówasarai wémesarai ");
INSERT INTO auy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sámériyaafaꞌa komésarai Ísuni aampaꞌó kuwáísáfésarai inaifínkémbá sésarai Maníkóní Ufaen-ámútámbá maénááwe siyááye. ");
INSERT INTO auy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Fírípi nombó maitinkónkaꞌa Fasiꞌaénkó Ísuntafena ísámai nombá maitinkówana Maníkóní Ufaen-ámútámbá ímbo maiyónkaꞌa pósarai Pítaae Yóniye inaifínkémbá sésarai ");
INSERT INTO auy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","tiyáámba taꞌótóróyana Maníkóní Ufaen-ámútánkó tirumpimbá kumúwasa maiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aantá-waasiyai tiyáámba taꞌótóróyana Maníkóní Ufaen-ámútánkó tirumpimbá kumbaúwasa máúmba Sáímoni awánéna fasiꞌaémbá méyámbaranae séna Pítaante Yónintetafena séna óntamba maékai ");
INSERT INTO auy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","mifásíꞌáémbá símékaiyo. Kemá fíꞌon-kwaasi siyáámba taꞌótóráanana Maníkóní Ufaen-ámútánkó tirumpimbá kumbaínkwae súwana ");
INSERT INTO auy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pítaa séna Maníkó úwoimo wétimin-tantaatafe óntantamba méyánónae sénda po ení óntankwara ewáráꞌá iyafímbá taiꞌáyááye. ");
INSERT INTO auy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maníkón-aúrankaꞌa ení imáyáa ímba arupíse imbá pó maankísáú kenkáísí kísau ímba súwaꞌnai ínone. ");
INSERT INTO auy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ení sáwí-imayaagomba ánaaemba uwáme Fasiꞌaénkómbá áísai inaná ení sáwí-imayaagon-anondaa maiyauwáíníye. ");
INSERT INTO auy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Maníkó ímba fasiꞌaémbá ámakaintafe enarumbá sáwíꞌa uwásinkaanana ení sáwí-imayaago óraaꞌa éna embá taꞌótokaiye Pítaa súwana ");
INSERT INTO auy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sáímoni Pítaante Yónintetafena séna súwaꞌnai ekai Fasiꞌaénkómbá inaifínkémbá áísai íyana emó sénda misáwí-tántáákó ímba kempáꞌá tíno Sáímoni siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Súwasarai Pítaae Yóniye Fasiꞌaénkón-aai simátimesarai Ísuweꞌo néꞌóyan-aai simátimesarai Yérúsaremufaꞌa kónae sésarai aampaꞌá wéwesarai Sámériyaa-aempaꞌa naaóꞌ-naoꞌa Maníkóní ásé-aai simátímaꞌmaesarai kurááye. ");
INSERT INTO auy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","28","Mindárai Yérúsaremufaꞌa kuyaná Fírípi Sámériyaafaꞌa mérowana óraaꞌ-waasigo Ítíópíyaa-marafakewi éna Ítíópíyaa-waasiti kawáá-ínínkón-áwíꞌa Káándésini óntankaꞌo káráwiyowi Maníkón-ímáyáá éna Yérúsaremufaꞌa wémena Maníkón-áwíꞌa mósá maréna kouweréna wení táómpimba óraa-poigo tafisímaena nún-taompimba kúmba Fasiꞌaénkóní kísau-waasigo wíyómpakewi Fírípintafena séna íyáfasine Yérúsaremufakemba Késaafaꞌo kon-ámpáꞌá waaó súwana iséna íyáfasinena minámpáꞌá wémena máásai-marafaꞌo kúmba Ítíópíyaa-marafaken-oraaꞌ-waasi wení táómpimba wéwena aúfáífimba toráumai awánéna naaófáꞌó Maníkón-aaimo simátímakowin-awiꞌa Áísáya agaimakón-aai toráumai awánómba ");
INSERT INTO auy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Maníkóní Ufaen-ámútánkó Fírípintafena séna wení táónkoni ewaaꞌá waaó súwana ");
INSERT INTO auy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","awaantanténa kúmba Áísáya agaimakón-aai toráumai wéawanowana Fírípi iséna áísai ena séna minááígóní áwáuma ísaraano súwana ");
INSERT INTO auy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","séna éꞌa moóráwigo simásiminaꞌa isánaumpo kesí táómpimba íyátaao súwana Fírípi mintáómpimba íyátena imaúwana ");
INSERT INTO auy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","mináúfáífínkén-ááí torauséna séna sipisípi áyáumo karánae owanamó ímbo wááꞌo tintembá minkwáásígó ímba aaí siyáiye. Sipisípi tufuwónae owanamó ímbo wááꞌo tintembá minkwáásígó ímba aaí siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wenáwíꞌa múra tuwésa sáwíꞌa úmai aaifimbá maiyánkaraawe. Wení waási sáwí-kisau maiyésa tufúwówana marapáꞌó mérain-kanaa taíꞌáraiye. Mindásafesa miwítí sáwí-kisau ímba kanaaꞌá aforá simátimenaawe agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ítíópíyaafaken-kwaasigo minááí toráusuwena Fírípimba áísai ena séna Maníkón-aaimo simátímakowi nááwantafenawa minááí siyáiyo. Wesáfénawa siyái fíꞌowantafenawa siyáiyo súwana ");
INSERT INTO auy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fírípi Maníkón-aai aúfáífinkembo toráumaimo simámakainten-úmai Ísuni ásé-aai wésimamena ");
INSERT INTO auy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","aampaꞌá kuyambá nombó wérokaꞌa wésarai uyaná Ítíópíyaafaken-kwaasigo séna nombó wérainkaꞌa maisinkáínkwae séꞌa únana nóinkowa aambá fasiyíyo súwana ");
INSERT INTO auy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fírípi séna Ísumpaꞌo arumbó amé wenááisafe amankúnkúmbo inaꞌó éꞌa nombá maiyánkáano súwana séna Ísu Káráísitintafeꞌa éraiꞌa Maníkón-áánimban-iye súne séna ");
INSERT INTO auy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","táómbo toꞌmaé kúwaintafena séna táómba taꞌótoraao súwana taꞌótorowasarai Fírípiye Ítíópíyaafaken-kwaasigoe nompímbá kunkésarai Fírípi nombá maiyankéna ");
INSERT INTO auy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","íyúyana Fasiꞌaénkóní ámútanko Fírípimba kunáíꞌmaena kóúwana Ítíópíyaafaken-kwaasigo awánómba ímba mérowana wení naaópaꞌa wéna aamoí uráiye. ");
INSERT INTO auy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fasiꞌaénkóní ámútanko Fírípimba kunáíꞌmaena Ásítóti-naopaꞌa máankowana Fírípi mináémpáꞌ-náópaꞌa Maníkóní ásé-aai simátímaꞌmaena Sísááríyaa-naopaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Minkánáá Sóro Fasiꞌaénkóní aampaꞌó kuwáísáféna arumbá sáwíꞌa éna tínkamonae símasimaꞌa éna aifaꞌ-ámáán-káwáágómpáꞌá ");
INSERT INTO auy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","koáísai ena séna aúfái agai-símínaꞌa maimaéꞌa Támásikasi-naopaꞌo Yúndaa-amaan-daumpimpaꞌo méraan-kwaasiti óraaꞌ-waasi mátimeno súwana ewé séna minááí agaimaréna séna Sóro Ísuni aampaꞌó wíyawi saafá éna taꞌótoꞌmaena témena Yérúsaremufaꞌa ándáfaꞌa mátiyuwainiye séna agaimaréna súwana ");
INSERT INTO auy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sóro mináúfáí maimaé wémena Támásikasi-naopaꞌa ewaaꞌó kúmba wíyómpakemba sámo kaimbá aafáyáuraan-tantaaꞌa tuwówana kuména aúgáyáagaya úwana ");
INSERT INTO auy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","tanaa fówana aaigó aantemba séna Sóroo nóra séwa kembá sáwíꞌa wéono súwana ");
INSERT INTO auy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","séna emá nááwa sénó súwana kemá Ísu súmpo kembá sáwíꞌa uwásinkaampo ");
INSERT INTO auy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","íyáfasine Támásikasi-naopaꞌa koménana moóráwigomo síndantemba miyán-uwo súwasa ");
INSERT INTO auy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sóroeꞌo kun-kwáásí ímba aaí sumbá mésa ímba waási aneꞌá awánésa aaimó sún-aantemba ísówana ");
INSERT INTO auy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sóro íyáfasinomba aúramba ímba kaweꞌ-úmai awánówasa waási ayáán-toꞌmaesa Támásikasi-naopaꞌa máánkarowana ");
INSERT INTO auy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","kaumbo-nóꞌwáámbá waéna ímba aúramba awánéna tóné noné ímba naráiye. ");
INSERT INTO auy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Sóro kaumbo waúwana moóráwigo Támásikasifaꞌa ména Ísuni aampaꞌó kúwain-awiꞌa Ánánáyasi aúramba aréna kaainkáámbá awánómba Fasiꞌaénkó simámena séna Ánánáyasiyo súwana oó Fasiꞌaénkóo kemá úne súwana ");
INSERT INTO auy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","íyáfasinema aampaꞌá waaó. Minánkón-áwíꞌa arupísemo uráin-ampaꞌa kuré Yúndasini naaúmpaꞌa wée moóráwigo Táásási-naopakewin-awiꞌa Sóromba koawánaao. We inaí wésiye. ");
INSERT INTO auy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kaainkáámbá awánarainkaꞌa moóráwigon-awiꞌa Ánánáyasi téna aneꞌá taꞌótóráísana aúramba kaweꞌ-úmai awánaraiye Fasiꞌaénkó súwana ");
INSERT INTO auy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ánánáyasi séna Fasiꞌaénkóo sáwífaꞌ-waasi wenáái simásímakaawe. Yérúsaremufaꞌa ení waási sáwíꞌo uwátínkarain-aai simásímakaawe. ");
INSERT INTO auy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aifaꞌ-ámáán-káwáágó aúfái agaimái ámísana en-ímáyáámó mósá máráán-kwaasi ándáfaꞌo tiyuwáíndasafena Támásikasifaꞌa tiyáiye súwana ");
INSERT INTO auy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Fasiꞌaénkó séna kesí kísau áménana kesáái kosimátin-tasimatimba fíꞌon-daopaken-kwaasiye kawáá-wáásíyé kesí waási Ísareri-waasiye kosimátin-tasimatimba ínífo íyáfasine wempáꞌá winaná ");
INSERT INTO auy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","kesí kísau Sóro wémainasa waási sáwíꞌa uwánkanaawe. Mindásafeꞌa ke aráánamenaumne Fasiꞌaénkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Súwana Ánánáyasi iséna wéna sún-daumpaꞌa iyéna Sóro aneꞌá ayáámba taꞌótorena séna Sóroo kesí waásiyo. Aampaꞌá wéte Fasiꞌaénkó Ísumba awánaraandawi siꞌmáráísaꞌa túne. Aúramba kaweꞌ-úmai awánenana Maníkóní Ufaen-ámútánkó arumpimbá óraaꞌo uwánkaindasafena siꞌmáráísaꞌa túne súwana ");
INSERT INTO auy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sóron-aúrampinkemba aerambá tákúwana aúramba kaweꞌ-úmai awánéna íyáfasinowana Ánánáyasi nombá maiyankówana ");
INSERT INTO auy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tómbá násuwena áúgoma kaweꞌá uráiye. Sóro Támásikasifaꞌa tuwímbai-noꞌwaamba waéna Ísuni aampaꞌó kuwáíséꞌa ména ");
INSERT INTO auy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","minúwóíyáán-úwana ámáán-daumpaꞌa iména Ísun-aai simátimena séna éraiꞌa Ísu Maníkón-áánimban-iye súwasa ");
INSERT INTO auy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","wenáái ísón-kwaasi táátafesa ésa moórá-mora-waasi tísai-isai esa sésa Yérúsaremufaꞌa Ísun-imayaamo mósá máráán-kwaasi tínkamemayain-kwaasin-iye. Ísun-imayaamo mósá máráán-kwaasi tíꞌmae ándáfaꞌa ámáán-kawaa-waasiyaꞌo mátinkanae séna maankáꞌó tiyáin-kwaasin-iye. Ísumpaꞌa téna méraiye sésa táátafesa uráawe. ");
INSERT INTO auy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Suwaná Sóro óraaka simátímaꞌmae iyéna séna éraiꞌa Maníkómó íyáfasinankaraiwaimba amuꞌmaráúndawisa Ísun-iye séna wenááigo iyúwasa Támásikasifaken-Yundaa-waasi isésa wembá ímba anondáá simámakaawe. ");
INSERT INTO auy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ímba anondáá sumbá sáwífaꞌ-noꞌwaamba waésa túwaandu ésa Sóromba tufuwónae sésa ");
INSERT INTO auy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","tufuwíyanesa nóꞌwaane wááwáiye Támásikasi-naokoni óntan-kusaigoni aumépaꞌa mésa ontaráꞌá takáráwi-karawi wéuwana moóráwigo iséna tufuwónae-aaimo sumbá kosimámuwasa ");
INSERT INTO auy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","moórá-noꞌwaamba Ísuni aampaꞌó kuwáí Sóromba áíꞌmaesa pofafímbá fáítumaresa óntan-kusaigoni afaapimbá túsúsuwesa ándáraꞌa taꞌótoresa túwówana kumémena marapáꞌá múra tuwéna kóuraiye. ");
INSERT INTO auy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sóro Yérúsaremu-naopaꞌa wémena wéna séna Ísuni aampaꞌó kowíséꞌa méranaeꞌa túne súwasa miwí sésa Ísun-aai ímba ísaraiwai karoꞌá siyé sésa wenáároi inkáísúwana ");
INSERT INTO auy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","moóráwigon-awiꞌa Páánápáasi Sóron-aai iséna kaweꞌá úwana áíꞌmaena aantá-waasifaꞌa wéna Sóron-aai kosimátimena séna Sóro Támásikasi-ampaꞌo wéwenamo Fasiꞌaénkómbó awánówana aaimó simámakain-aai simátimena Sóro Támásikasi-naopaꞌo Ísun-aaimo óraakaꞌo simátímaꞌmaenamo kuráin-aai simátimuwasa ");
INSERT INTO auy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","isésa éraiꞌe suwaná Sóro miwíséꞌa ména Ísuni fasiꞌaémbá wérowana Yérúsaremu-naopaꞌo Ísun-aai óraaka kosimátin-tasimatin-ena ");
INSERT INTO auy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","fíꞌon-Yundaa-waasi Kíríki-waasi-taaifinkembo sun-kwáásí simátimuwasa aaí wesimán-kwesiman-esa tufuwónae sésa ");
INSERT INTO auy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","sumbá Ísuni aampaꞌó kuwáí isésa Sóromba áíꞌmaesa wémesa Sísááríyaa-naopaꞌa máankesa sésa Táásási-naopaꞌa waaó sésa aiꞌmárówana mindáópaꞌa kóuraiye. ");
INSERT INTO auy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kóúwasa Ísuni aampaꞌó kun-kwáásímó tínkamumba étínkówasa aáno úmai wempaꞌá mésa Yúndiyaa-aempaꞌe Káríri-aempaꞌe Sámériyaa-aempaꞌe Ísuni aampaꞌó kuwáí aáno úmai wempaꞌá mérowana Maníkóní Ufaen-ámútánkó túwaꞌnai úwasa fasiꞌámai mésa Ísun-aai simátímúwasa isésa éraiꞌe sésa sáwífaꞌ-waasi-iꞌa ésa Fasiꞌaénkón-áwíꞌa mósá marésa wenaísamaifimba méraawe. ");
INSERT INTO auy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pítaa naaóꞌ-naoꞌa wénena Maníkóní waási tuwánáíndasafena Ríndaa-naopaꞌo kúmba ");
INSERT INTO auy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","moóráwigon-awiꞌa Íniyasi ímba aíntamai wénena afakaumboé-aatai naaúmpaꞌ-aantemba maéꞌmaeꞌa wéuwana ");
INSERT INTO auy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pítaa awánéna séna Íniyasiyo Ísu Káráísiti asófankaifo íyáfasinke ení wandaaí fawasaaó súwana íyáfasinkwena kúwasa ");
INSERT INTO auy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ríndaa-naopaken-kwaasiye Séróni-naopaken-kwaasiye seyaafáꞌá awánésa Fasiꞌaénkómpáꞌá tiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yópaa-naopaꞌa moórá-ininkon-awiꞌa Tápítaa Kíríki-waasi-taaifinkemba mináwíꞌá Tókáasiye wésewe. Wemá Ísuni aampaꞌó kún-inimba aasiyaasí kawe-kísáú wémaena moparáwímbá ímbo makón-kwaasi túwaꞌnai úwaimba ");
INSERT INTO auy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","áíꞌa úwana puwúwasa wenáúma nombá péꞌankesa maimaésa afófumayaatanaan-daumpaꞌa móankaraawe. ");
INSERT INTO auy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yópaa-naopakemba Ríndaa-naopaꞌa ewaaꞌá pósa Yópaafaken-kwaasi Ísuni waási Pítaa Ríndaafaꞌo taméron-aai isésa kaeꞌ-wáásí tiꞌmárówasarai Pítaamba kosimámesarai sésa awaantanté kempátá tiyó sésa siꞌmárááwakai túye suyaná ");
INSERT INTO auy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pítaa íyáfasinena mindáraise kúwasa áíꞌmaesa minínímbá puwúwasa matuwé méron-daumpaꞌa afófumayaatanaan-daumpaꞌa íyúwasa Pítaampaꞌa ketoꞌ-íníntómbá tatúwaandu urésa ifiꞌá tésa sésa Tókáasi ímba pukáinkaꞌo farú-simakain-unankwatoiye sésa aráánámúwana ");
INSERT INTO auy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","awánéna séna máápa kárúwaaro súwasa kúmúwana Pítaa kífaena Fasiꞌaénkómpáꞌá inaí simásuwena méwaeꞌmai minínímbá awánéna séna Tápítaao íyáfasinaao súwana aúramba éna Pítaamba awánéna íyáfasinena mérowana ");
INSERT INTO auy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pítaa koisáúwankena Ísuni aampaꞌó kun-kwáásíyé ketoꞌ-íníné táántowasa aúmó arómba iawánésa ");
INSERT INTO auy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yópaa-naopaꞌa kosimátímaꞌmaesa kuwasá isésa sáwífaꞌ-waasi Fasiꞌaénkón-aaisafesa timankúnkúmba uwaná ");
INSERT INTO auy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pítaa Yópaa-naopaꞌa sáwífaꞌ-noꞌwaamba waéna moóráwigon-awiꞌa Sáímoni wení naaúmpaꞌa mérowana minkwáásígó waan-ásisambo wení kísaumo maún-kwaasigoni naaúmpaꞌa méraiye. ");
INSERT INTO auy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sísááríyaa-naopaꞌa moóráwigon-awiꞌa Kóníríyasi ména Rómufakemba sáwífaꞌa 100 i-waasiyaꞌo káráwiyowi mérowasa miní-wáásí túwíꞌa Ítáári-i-waasiye sésa uwaná ");
INSERT INTO auy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kóníríyasi Maníkón-aaisafena fasiꞌámai ména wení akúntéꞌa Maníkón-ímáyáá éna áwíꞌa mósá maréna Yúndaa-waasimo ímbo moparáwímbó makón-kwaasi túwaꞌnai ena Maníkómpáꞌá inaí símaena iyúmba ");
INSERT INTO auy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","moórá-kanaa fenómpinkaꞌa inaí wésuwana Maníkóní kísau-waasigo wíyómpakewi aúrankaꞌa paápé úwana kaweꞌ-úmai awánówana séna Kóníríyasiyo súwana ");
INSERT INTO auy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ááꞌa úwana aúramba afuwéna séna Fasiꞌaénkóo nóran-aaiya simásiminewa sénó súwana emó inaimó séndawiye waásimo túwaꞌnai óndawiye Maníkón-aúrankaꞌa kaweꞌó óndasafena Maníkó en-ímáyáá imbá pó ");
INSERT INTO auy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ení waási tiꞌmárénasa Yópaa-naopaꞌa moóráwigon-awiꞌa Sáímoni Pítaamba koaíyáaro. ");
INSERT INTO auy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wení araámáó Sáímonini naaúmpaꞌa ména minkwáásígó waan-ási-kisaumo máín-kwaasigoni naaúmpaꞌa uwí-nónkóní áwáífaꞌ-naumpakemba koaíyáaro ");
INSERT INTO auy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","simásuwena áwiyokuwana Kóníríyasi wení kísaumo máún-kwaasifinkemba kaeꞌ-wáásíyáíyé moórá-i-waasi Maníkón-ímáyáá mósá marówinteꞌa miyáumai-waasiyau táántowasa ");
INSERT INTO auy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","tuwaná wíyómpakewimo simámakon-aai simátimena séna miyáumai Yópaa-naopakemba koaíyáaro séna tiꞌmákaiye. ");
INSERT INTO auy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tiꞌmarówasa aampaꞌá kówaesa wémesa Yópaa-naopaꞌa ewaaꞌó kumbá wááwái Pítaa naan-afóforaꞌa iména Maníkómpáꞌá inaí wésuwana ");
INSERT INTO auy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","áái tówana tómbá nánae súwasa tómbá wéagauwana kaainkáámbá awánómba ");
INSERT INTO auy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","wíyómba tuwínkaaꞌ-úwana mimpínkémbá óraaꞌ-ampanta éíyain-araiyaꞌa taꞌótoresa túwówana kuménama marapáꞌá kumúwana awánómba ");
INSERT INTO auy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","minámpántáfímbá waí-waane póíye iyaankafayaané numawé fíꞌo-fiꞌon-kwai-waane mérowana ");
INSERT INTO auy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","aaigó aantemba séna Pítaao íyáfasinke tufúꞌmai agandaaó súwana ");
INSERT INTO auy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pítaa séna Fasiꞌaénkóo ímbanifo kentáásí ámáámba Yúndaa-waasisa miyán-tántááꞌá aambá fáíꞌmakaawata póta ínta wénaumne súwana ");
INSERT INTO auy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","minááígó aantemba anekaꞌá séna Maníkó kawe-tántááꞌémó siyáin-tantaatafe ímba aambá fáíꞌmakaawe siyó súwana ");
INSERT INTO auy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","kaumbo-íꞌa kaainkáámbá awánówana wíyómpaꞌa minámpántá iyáiye. ");
INSERT INTO auy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Iyúwana Pítaa minkááínkáán-ááígóní áwáuma nórawaꞌiyo súmba Kóníríyasimo tiꞌmarón-kwaasi Sáímonini naambá taawánésa ontaráꞌá tamésa ");
INSERT INTO auy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","táántesa sésa Sáímoni Pítaa maandáúmpárá méraiyo suwaná ");
INSERT INTO auy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pítaa minkááínkáán-ááígóní áwáuma saafá úwana Maníkóní ámútanko séna kaumbo-wáásí embá ayaafáí úmaesa tefo ");
INSERT INTO auy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","íyáfasine kumuwó. Kemá tiꞌmaráúnasa tefo ímba kaeꞌ-ímáyáán-uwo. Úwoi miwíséꞌa waaó súwana ");
INSERT INTO auy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pítaa kuména minkwáásísáféna séna wésiyaafaa-on-kwaasi úmpo nóintafera wésiyaafaao súwasa ");
INSERT INTO auy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","kentáásí kawáágón-áwíꞌa Kóníríyasi siꞌmáráísata empátá túne. Wemá kaweꞌ-wáásí Maníkón-ímáyáá éna áwíꞌa mósá máráísasa pósa Yúndaa-waasi seyaafáꞌá wentáfésa kaweꞌ-wáásíyé wésewe. Moóráwigo Maníkóní kísau-waasigo wíyómpakewi kusimámena séna tiꞌmárénasa Pítaamba Yópaa-naopakemba koaíyéwana empáꞌá téna aaí tasína isaaó sisatá túne suwaná ");
INSERT INTO auy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pítaa tíꞌmaena naaúmpaꞌa tinkówasa wáúmba aafáyáaraꞌa Pítaa íyáfasinena miwíséꞌa kuráiye. Miwíséꞌa kúwasa Yópaa-naopakemba Ísuni aampaꞌó kun-kwáásí tuwímbai awíyoꞌmaesa ");
INSERT INTO auy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","aampaꞌá kówaesa wémesa Sísááríyaa-naopaꞌo kumbá Kóníríyasi wenamááraawe wení waásiye táántowasa tatúwaandu urésa Pítaamba amuꞌmakówana ");
INSERT INTO auy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pítaa Kóníríyasini naambó wéronkaꞌa ontaráꞌá kúwana Kóníríyasi aamoí éna óraakon-iye séna aísamaifimba kífauwana ");
INSERT INTO auy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pítaa séna emó óndanten-kwaasi úmpo íyáfasinaao séna íyáfasinakena ");
INSERT INTO auy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","aaí simámaꞌmaena Kóníríyasiyeꞌa naaúmpaꞌo iyúmba sáwífaꞌ-waasi túwaandu urómba ituwánéna ");
INSERT INTO auy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","séna kentáásí ámáámba ísaraawe. Yúndaa-waasisa fíꞌonkaa-waasise ímba moórárata taankarotámaisa wémaumne. Miwítí naaúmpata ínta wégundarata Maníkó aráásimena seyaafáꞌ-wáásí ímba sáwí-waasin-owe siyáisaꞌa awánaraunda póta ímba sáwí-waasiyemo sendá úwoi kaweꞌ-úmai ménaumne. ");
INSERT INTO auy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mindásafesa sáántaamba ímba aꞌáo súnda túmpo nóintafera sáántaraao Pítaa súwana ");
INSERT INTO auy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kóníríyasi séna éíyain-doꞌwaamba waéꞌa káfékaamba fénáímpinkaꞌa kesí naaúmpaꞌa inaí súnana minúwóíyáámbá moóráwigo sámo kain-únánkwátói uréna súrankaꞌa kumbéna ");
INSERT INTO auy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","séna Kóníríyasiyo emó inaimó sémo waási túwaꞌnai ema Maníkón-aúrankaꞌa kaweꞌó óndasafena Maníkó en-ímáyáá imbá pó ");
INSERT INTO auy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","tiꞌmárénasa Yópaa-naopaꞌa moóráwigon-awiꞌa Sáímoni Pítaamba koaíyáaro. Araámáó Sáímonini naaúmpaꞌa méraiye. Waan-ási-kisaumo máín-kwaasigoni naaúmpakemba uwí-nónkóní áwáífaꞌ-naumpakemba koaíyáaro súwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","minúwóíyáán-úmai tiꞌmaráúnasa embá koaíyáawa kaweꞌ-úmai téne. Kesáá Maníkón-aúrankaꞌa túwaandu éta Fasiꞌaénkó simámakain-aai simásiminkwae séta amuꞌmakáunasa téne Kóníríyasi siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kóníríyasi súwana Pítaa séna káféꞌa wéisaumne. Éraiꞌa Maníkó ímba Yúndaa-waasi aantemba wégarawifo ");
INSERT INTO auy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","seyaafáꞌ-áémpákén-kwáásí Maníkón-aúrankaꞌa arupíse úmai kaweꞌ-úmai méraawi Maníkó miwí aamoí wéuwatinkaiye. ");
INSERT INTO auy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Maníkó Ísu Káráísitimba aiꞌmarówana Ísareri-waasisafena ásé-aai simátímakaimba éꞌa ísaraawe. Ísu Káráísiti seyaafáꞌ-wáásítí Fasiꞌaénkón-iye. Minásé-ááísáfésa éraiꞌemo síyawi tirumbá kaweꞌ-úmai wempaꞌó méraiyamba ");
INSERT INTO auy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","kemá ísaraawe. Yóni simátimena séna kentí sáwí-imayaa tuwéꞌa Maníkómpáꞌá téꞌa nombá maénááwe siyáimba Ísun-aai aifaꞌá Káríri-aempakemba tiyéna Yúndiyaa-marafaꞌa wété uráiye. ");
INSERT INTO auy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ísu Násaretifakewin-aai ísaraawe. Maníkó wení Ufaen-ámútámbá Ísumba ámakowana wempímbá óraaꞌa uwánkowana Maníkó fasiꞌaémbá aména weséꞌa mérontafena naaóꞌ-naoꞌa kawe-kísáú wété éna waántáwankomo taꞌótoron-kwaasi kaweꞌá uwátínkáfaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yúndiyaa-marafaꞌa Yérúsaremu-naopaꞌa kísau maiyáimba awánaraumne. Wembá aaraa-táíyáꞌá aíyayaampimba tufúsúmarowana puwéna ");
INSERT INTO auy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kaumbo-kánáá maisuwówana Maníkó Ísumba pukómpinkemba íyáfasinankowana paápé únta kesúrandesa awáraumpo ");
INSERT INTO auy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ímba seyaafáꞌ-wáásí awánaraawe. Maníkó simátíméromo siyáinta Ísunta awánéta pukómpinkembo íyáfasinonkaꞌa tóné noné weséta naráumne. ");
INSERT INTO auy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ísu óraakaꞌa simásimena séna Maníkó imáyáa siména pukén-kwaasiye túmó arén-kwaasiye aaifimbá maitinkáínone siyé simátíméro Ísu siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Naaófáꞌá Maníkón-aaimo simátímakowi Ísun-aai simátimesa sésa wenááisafesa timankúnkúmbo íyawi Ísuni fasiꞌaénkáꞌá Maníkó miwítí sáwí-imayaa maitiyuwáíníye naaófáꞌá siyáawe Pítaa siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pítaa minááí simátimuwana wéison-kwaasifimba Maníkóní Ufaen-ámútánkó miséyááfápímbá kumbéna ");
INSERT INTO auy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Maníkóní Ufaen-ámútánkó kumúwasa fíꞌo-fiꞌon-aaifinkemba Maníkón-áwíꞌa mósá márówasa Yúndaa-waasi Ísuni aampaꞌó kun-kwáásí Pítaa-iyaiseꞌa Yópaafakembo tuwáíyé táátafesa ésa sésa Maníkó fíꞌonkaa-waasiwaraꞌa wení ámútamba úwoi wétimiye sésa táátafesa uwaná Pítaa séna ");
INSERT INTO auy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Maníkó wení Ufaen-ámútántáámó símakaintenta miwíwáráꞌá wétimimba póta nombó maíyamba ímba aambá faiyónaumpo úwoi nombá maénááfo ");
INSERT INTO auy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","maitínkáaro súwasa Ísu Káráísitintafesa ísámai nombá maitínkówasa Pítaantafesa sésa tuwímbai-noꞌwaamba keséta waínone suwaná miyá uráiye. ");
INSERT INTO auy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Fíꞌonkaa-waasi Ísun-aai isésa taꞌótokaawemo sumbá aantá-waasiye Ísuni aampaꞌó kuwáí Yúndiyaa-marafaken-kwaasiye minááí isésa mérowana ");
INSERT INTO auy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pítaa Yérúsaremu-naopaꞌa kúwasa tuwímbai-waasi aaisambá aéésa Yúndaa-waasi túma kárámai araénáémbo wéontemba fíꞌonkaa-waasiwaraꞌa miyá orómó siyón-kwaasi Pítaamba aaisambá aéésa ");
INSERT INTO auy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","sésa emá fíꞌonkaa-waasiti naaúmpaꞌa iwaé ímbo túmo kárámai araénáémbo úmakaan-kwaasiti naaúmpakemba tómbá imandaráane suwaná ");
INSERT INTO auy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pítaa seyaafá-tántááꞌó uráimba simátimena ");
INSERT INTO auy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","séna Yópaa-naopaꞌa méꞌa Maníkómpáꞌá inaimó séwándaraꞌa kaainkáámbá awánááwánana wíyómpakemba óraaꞌ-ampanta éíyain-araiyaꞌa taꞌótoresa túwówana kuména méraawandaraꞌa kumúwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","mimpímbá afuwéꞌa awánááwánda póíye waí-waane iyaankafayaané numawé mérowaꞌa awánááwánana ");
INSERT INTO auy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","aaigó aantemba séna Pítaao íyáfasinke tufúꞌmai agandaaó súwaꞌa iséꞌa ");
INSERT INTO auy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","séꞌa Fasiꞌaénkóo ímbanifo kentáásí ámáámba miyán-tántááꞌá aambá fáíꞌmakaawata póta ímba wénaumne séwánana ");
INSERT INTO auy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","minááígó aantemba anekaꞌá séna Maníkó kawe-tántááꞌé siyáin-tantaatafe ímba aambá fáíꞌmakaawe siyó súwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","kaumbo-íꞌa kaainkáámbá awánááwánana wíyómpaꞌa minámpántá iyáiye. ");
INSERT INTO auy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Minúwóíyáámbá Sísááríyaafakemba kaumbo-wáásí kentááꞌa tiꞌmarówi tumbá ");
INSERT INTO auy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Maníkóní ámútanko simásimena séna ímba kaeꞌ-ímáyáá indá miwíséꞌa waaó súwaꞌa kówánasa Yópaafakemba maankwáásí afaꞌmóráe-waasi Ísun-aaimo ísááwi suwíyórówata Sísááríyaa-naopata Kóníríyasini naaúmpata kówánana ");
INSERT INTO auy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","simásimena séna Maníkóní kísau-waasigo wíyómpakewi kesí naaúmpaꞌa kumbéraisaꞌa awánáúnana séna tiꞌmárénasa Yópaa-naopakemba moóráwigon-awiꞌa Sáímoni Pítaamba koaíyéwana ");
INSERT INTO auy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","téna aaí tawésimatiminaꞌa ewárá ení akúnkwáráꞌá seyaafáꞌá wéisewana Maníkó sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkainiye wíyómpakewi siyáiye Kóníríyasi súwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","aaí wésewanana Maníkóní Ufaen-ámútánkó aifaꞌó kentááfímbó kunkáintemba miwífímbá miyá úwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","awánéꞌa moórá-aai sáákaꞌa makáumne. Ááéma Fasiꞌaénkó séna Yóni nombó maitínkaraimbanifo Maníkóní Ufaen-ámútánkó kuména kempímbá óraaꞌa uwátinkainiye Fasiꞌaénkó siyáin-aai sáákaꞌa makáumne. ");
INSERT INTO auy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Énifo kesáá Fasiꞌaénkó Ísu Káráísitin-aaisafeta simankúnkúnta ówánanasa Maníkó wení ámútambo símakaintenta fíꞌonkaa-waasi miwí miyá owaꞌá awánaraumpo kemá Ísuni kísau-waasi póꞌa nombó máúmba ímba aambá faiyówánasa úwoi nombá maiyáawe Pítaa súwasa ");
INSERT INTO auy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","minááí isésa aaisambó áúmba ifátuwesa Maníkón-áwíꞌa mósá marésa sésa Maníkó miyá éna ímba Yúndaa-waasi aantemba aaisá wésimasimifo fíꞌonkaa-waasiwaraꞌa wésimatimisasawaraꞌa miwítí sáwí-imayaa tínaaemba uwámesa Maníkómpáꞌá tésa aúíꞌa úmai maéꞌmaeꞌa ónááwe siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ááéma Sítífenimba tufúwana puwúwasa fíꞌon-kwaasi Ísuni aampaꞌó kun-kwáásí sáwíꞌa uwátínkówasa wété uráamba tuwímbai Fínísiyaa-marafaꞌa kuwasá tuwímbai Sáíparasi-marafaꞌa kuwasá tuwímbai Ántíoku-naopaꞌa kuwasá miwí minkáúmbó-máráfáꞌó méron-kwaasi Yúndaa-waasi aantemba Ísun-aai kosimátimesa ");
INSERT INTO auy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","miwífínkémbá tuwímbai Sáíparasi-marafakewi tuwímbai Sáíríni-marafakewi miwí Ántíoku-naopaꞌo koméronkaꞌa Yúndaa-waasiye fíꞌonkaa-waasiyewaraꞌa Fasiꞌaénkó Ísuni ásé-aai kosimátimuwana ");
INSERT INTO auy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Fasiꞌaénkóní fasiꞌaémbá miwíséꞌa wérowasa sáwífaꞌ-waasi Fasiꞌaénkón-aaisafesa timankúnkúmba ésa wempáꞌá tiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ántíokufaken-kwaasi Fasiꞌaénkón-aaisafesa timankúnkúmba ésa wempáꞌó tiyáan-aai suwasá Fasiꞌaénkóní waási Yérúsaremufaꞌo méron-kwaasi minááí isésa Páánápáasimba aiꞌmárówana Ántíoku-naopaꞌa wémena ");
INSERT INTO auy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","koména Maníkó kaweꞌó uwátínkaromba tuwánéna aamoí éna óraaka simátimena séna kentirumbá fasiꞌámai Fasiꞌaénkóntáféꞌa méraaro séna ");
INSERT INTO auy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Páánápáasi kaweꞌ-wáásí úwana Maníkóní Ufaen-ámútánkó wempímbá óraaꞌa uwánkowana Fasiꞌaénkómpáꞌá amankúnkúmba fasiꞌámai éna aaí simátímaꞌmaena iyúwasa sáwífaꞌ-waasi isésa Fasiꞌaénkómpáꞌá tiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Uwaná Páánápáasi Sóromba ayaafáí úmaena Táásási-naopaꞌo kúmba ");
INSERT INTO auy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","koawánéna koáíꞌmaena Ántíokufaꞌa tésarai moórá-aatai tamaisuwésarai Fasiꞌaénkóní waásiseꞌa mésarai sáwífaꞌ-waasi tatúwaandu untembá Ísun-aai simátímaꞌmaesarai íyúyasa Ísuni aampaꞌó kuwáísáfésa sésa Káráísitini waásiye suwaná aifaꞌá Ántíokufaꞌa minááí paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Minááí paápé úwana minkánáá tuwímbai Maníkón-aaimo simátímakowi Yérúsaremufaꞌa tuwésa wémesa Ántíokufaꞌa kuwaná ");
INSERT INTO auy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","miwífínkémbá moóráwigon-awiꞌa Ákápáasi íyáfasinena Maníkóní ámútanko weséꞌa mérowana séna óraaꞌ-aawai seyaafáꞌ-áémpáꞌá táíníye siyónkaꞌa póna ánaaemba Rómu-kamaniti kawáágón-áwíꞌa Kíróndíyasi méronkaꞌa minááwáí paápé uráiye. Ákápáasi minááí súwasa ");
INSERT INTO auy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","isésa Ísuni aampaꞌó kuwáí moórá-mora sésa óntamba túwaandu úmai Ísun-aaimo ísááwi Yúndiyaa-marafaꞌo méraan-kwaasi timénae sésa ");
INSERT INTO auy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","miyá ésa minóntámbá Páánápáasinte Sóronte tímúwasarai maimaésarai wémesarai Fasiꞌaénkóní waásiti óraaꞌ-waasi mátímakaaye. ");
INSERT INTO auy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Minkánáá Érotin-anáwainko araámáó Éroti Yúndaa-waasiti kawáágó ména Ísuni aampaꞌó kuwáí tuwímbai sáwíꞌa uwátinkena ");
INSERT INTO auy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","moóráwigomba aiꞌmarówana Yóni awaaón-áwíꞌa Yémísimba kotaꞌótokena anuwarambá kambísásuwowana puwúwasa ");
INSERT INTO auy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yúndaa-waasi aamoí uwaná Éroti awánéna aamoí uwásinkaiwae séna moóráwigomba aiꞌmarówana Pítaamba kotaꞌótokaiye. Yúndaa-waasi ímbo intóráín-tantaaꞌwara-pereti agáún-kanaa Pítaamba kotaꞌótoꞌmaena ");
INSERT INTO auy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ándáfaꞌa máánkowasa siyáánkain-úmai afaꞌmóráe-i-waasi wenkáꞌá káráwiyowasa éíyain-eiyain-kwaasi kóyááka-tayaaka úmai káráwiyuwasa Éroti séna Maníkó Yúndaa-waasi tíyótaimo í-tánón-kánáá taiꞌáínaꞌa Pítaamba áíꞌmaeꞌa Yúndaa-waasi túrankaꞌa aaifimbá maenkéꞌa tufuwónaumnemo súmba ");
INSERT INTO auy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pítaa ándáfaꞌa mérowasa Fasiꞌaénkóní waási Fasiꞌaénkómpáꞌá inaí símai Pítaamba áwaꞌnai uráawe. ");
INSERT INTO auy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Inaí sésa Pítaantafesa ísámai áísai uwaná aafáyáaraamba Éroti Yúndaa-waasi túrankaꞌa Pítaamba aaifimbá maiyankánaumne súwana káféꞌ-noꞌwaankaamba Pítaamba aíyayaankaꞌa káráꞌumakesa kaeꞌ-í-wáásí séfasefaꞌa méroyana Pítaa aún-kwaigúwasarai kaeꞌ-í-wáásí ontaráꞌá káráwiyoyana ");
INSERT INTO auy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","minúwóíyáámbá Fasiꞌaénkóní kísau-waasigo wíyómpakewi kumúwana ándá-naumpaꞌa sán-kówana Pítaan-ayóíyáꞌá tufuwéna aúsúwana íyáfasinowana séna úwoiya íyáfasinaao súwana Pítaa ayáámpinken-anda weyááríkaꞌa faúꞌwena marapáꞌá kumúwana ");
INSERT INTO auy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","wíyómpakewi séna ení áꞌwáánkau uré enaísamai ánáamba maimái uwó súwana miyá úwana ení paákákén-únánkwátói kuférénakai kesékai koyó súwana ");
INSERT INTO auy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pítaa ándá-naumpakemba wenánaaemba kuména ímba waásin-iye-imayaa uráifo kaaimbá awánáúmne-imayaa éna ");
INSERT INTO auy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","i-wáásímó méron-ontaraꞌa kúwáákesarai minkákémbá moórá-ontaraꞌa i-wáásímó méron-ontaraꞌa kúwáákesarai minkákémbá ándáfakembo naaópaꞌo kónae owasamó titinkáán-ontaraꞌa fasiꞌaén-óntáráꞌá kúmúyana weyááríkaꞌa tigúwasarai kuwákárúwesarai aampaꞌá kuyaná minúwóíyáámbá wíyómpakewi Pítaamba auwéna áwiyokuwana ");
INSERT INTO auy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pítaa imáyáa éna séna ímba kaaimbá awánáúmpo éraiꞌa Fasiꞌaénkó wení kísau-waasigomba aiꞌmáráísana kuména Éroti sínkamine isaná ayáámpinkemba kuntafísuwaisaꞌa túne. Yúndaa-waasiwaraꞌa sínkamonaesamo ombá kuntafísuwaisaꞌa túne Pítaa siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pítaa minímáyáá uwásuwena Máríyaani naambó wéropaꞌa wéna Yóni-Máákaani anówani naambó wéropaꞌa kúwasa sáwífaꞌ-waasi mindáúmpáꞌá túwaandu ésa Pítaantafesa ísámai Fasiꞌaénkómpáꞌá inaí wésuwana ");
INSERT INTO auy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","mindánkóní ontamá paupau súwana moórá-arasi mindáúmpáꞌó kísaumo maún-arasigon-awiꞌa Róta ontaráꞌá kuména ");
INSERT INTO auy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","séna nááwaꞌono súwana Pítaa séna kemá úne súwana Pítaan-amóísáúmba iséna kunaamoí éna ímbo ontamó tiyankómba awaantanténa sáwífaꞌ-waasi isimátimena séna Pítaa ontaráꞌá méraiye súwasa ");
INSERT INTO auy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","miwí sésa emá uwóíꞌa éma karoꞌá séne suwaná minárásígó anekaꞌá séna éraiꞌa Pítaa ontaráꞌá méraiye súwasa miwí sésa Pítaan-amankon-iye ");
INSERT INTO auy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","suwaná Pítaa ontamá óraakaꞌa paupau súwasa isésa ontá kuntiyésa awánomba wemá Pítaa úwasa táátafesa uwaná ");
INSERT INTO auy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","káíkarewaꞌa simátíméno simásuwena séna Fasiꞌaénkó ándáfakemba kembá síꞌmaena aampaꞌá másiyuwaifo Yémísine Ísun-aaimo ísáán-kwaasiye kosimátíméro Pítaa simátimena tiyuwéna fíꞌon-daopaꞌa kuráiye. ");
INSERT INTO auy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kúwasa aafáyáaraꞌa i-wáásí Pítaambo káráwiyowi awánomba ímba mérowasa kantúmba marésa Pítaa nááfara kóuraiyo suwaná ");
INSERT INTO auy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Éroti iséna Pítaamba ayaafáí oró súwasa ayaafáí uwááesa ifátuwowana Éroti miní-wáásí aaifimbá maitinkéna séna tínkamoro séna tuwímbai tiꞌmarówasa tínkamuwasa púwúwana Éroti miyá uwásuwena Yúndiyaa-marafaꞌa tuwéna kumémena Sísááríyaa-naopaꞌa kumbéraiye. ");
INSERT INTO auy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Éroti Sáíndóni-naopaken-kwaasiye Táyaa-naopaken-kwaasiye áfááraumai aaisambá tiyúwasa minkáéꞌ-náópaken-kwaasi tatúwaandu ésa sésa Érotimo káráwiyai-marafakemba kentáásí tómbá wémaumne sésa minááí símai kaweꞌá ónae sésa Érotimpaꞌo tumbá wení naakaꞌó káráwiyowin-awiꞌa Párásitasimba másimamuwana isówasa minááísámbá másimai tukáawe. ");
INSERT INTO auy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Minkákémbá Éroti óraa-kanaa úwana wenkáꞌó káráwiyowini unáánkwátói úmaena káráwiyowi maéꞌmaeꞌo úpaꞌa iména ayáátááꞌ-aai wésuwasa ");
INSERT INTO auy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Érotimba símai arumbá torésa sésa ímba waásigo sifó maníkó siyé óraaka suwaná ");
INSERT INTO auy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Éroti minááísáféna ímba Fasiꞌaénkó úmpo úwoi-waasi úne séna aúpáꞌá tuwówana maníkóní kísau-waasigo wíyómpakewi tufúwana ufónkwanko arumbá unkutúwana pukáiye. ");
INSERT INTO auy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Puwúwasa Fasiꞌaénkóní waási Maníkón-aai kosimátin-tasimatin-uwasá isésa éraiꞌe sésa Fasiꞌaénkómpáꞌá tiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ántíokufaken-kwaasi Yérúsaremufaken-kwaasisafesa óntamba timénaumne siyómba pósarai Páánápáasiye Sóroe wétimuyana minkísáú taiꞌówasarai ifóꞌ-wáásígón-áwíꞌa Yóni-Máákaamba áíꞌmaesarai Yérúsaremufaꞌa tuwésarai wémesarai Ántíokufaꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ántíoku-naopaꞌa Fasiꞌaénkóní waásifinkemba Maníkón-aai wésimatimen-kwaasiye uwáítáíꞌo un-kwáásíyé mésa moóráwigon-awiꞌa Páánápáasi úwana moóráwigo fafután-kwáásígón-áwíꞌa Símiyoni úwana moóráwigo Sáíríni-marafaken-kwaasigon-awiꞌa Rúsiyasi úwana moóráwigon-awiꞌa Mánéyeni wemá Éroti kawáágóní naaúmpaꞌo maéꞌéíwai úwana moóráwigo Sóro úwana úmai mésa ");
INSERT INTO auy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","moórá-kanaa Fasiꞌaénkóní waási Maníkón-ímáyáá mósá marésa tómbá ímba nésa inaí aantembo sunkáꞌá Maníkóní Ufaen-ámútánkó simátimena séna Páánápáasinte Sóronte kesí kísauraꞌa íyáfasintinkaraumpo mindárai tiyúwáaro súwasa ");
INSERT INTO auy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","tómbá ímbo nombá inaí aantemba sésa Maníkóní kísaurai máíwae sésa tineꞌá tiyáántamba taꞌótoresa tiꞌmárówasarai kurááye. ");
INSERT INTO auy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Maníkóní Ufaen-ámútánkó Páánápáasinte Sóronte tiꞌmarówasarai Yóni-Máákaamba áíꞌmaesarai Ántíoku-naopaꞌa tuwésarai Sérúsiyaa-naopaꞌa kumésarai uwí-nónkóní afufumpim-báráfáꞌá áwíꞌa Sáíparasi-marafaꞌa kónae sésarai nompín-táómba taꞌótoresarai íyátesarai wémesarai ");
INSERT INTO auy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sáíparasi-marafaꞌa Sárámisi-naopaꞌa mindómpín-táómpinkemba kumésarai Yúndaa-waasiti ámáán-daumpimpaꞌa Maníkón-aai simátímaꞌmaesarai kuyaná Yóni-Mááka túwaꞌnai úmaena kúwasarai ");
INSERT INTO auy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","kaweꞌ-ááí simátímaꞌmaesa marapáꞌá wémesa Péfosi-naopaꞌa kuwaná moóráwigo mindáópaꞌa Yúndaa-waasigo ména wenáwíꞌa Pááyísási Kíríki-taafinken-awiꞌa Érímasi aitambá éna fintómó ún-kwaasi póna karoꞌá séna Maníkón-aai simátimundawi úne súwana ");
INSERT INTO auy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","moóráwigo kámáni-kawaagon-awiꞌa Sésiasi-Porasi ména kaweꞌ-ímáyááwáráꞌ-wáásí póna Maníkón-aai isánae séna Páánápáasinte Sóronte táántowana Érímasi aitambá éna fintómó ún-kwaasigo kámáni-kawaagoe aasiyaasí maéꞌmaeꞌo úwai mérowana kámáni-kawaago Páánápáasinte Sóronte táántowasarai tuyaná Érímasiwaraꞌa téna ");
INSERT INTO auy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","mindárai-taai tasímai taráísuwena kámáni-kawaago Ísun-aaisafena amankúnkúmba ifó séna mindárai-taai tasímai taráísuwowana ");
INSERT INTO auy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sóro moórá-awiꞌa Póro Maníkóní Ufaen-ámútánkó wempímbá óraaꞌa uwánkowana Póro fintómó ún-kwaasigomba kááꞌa afuwéna ");
INSERT INTO auy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","séna waántáwankon-árááꞌa po kaweꞌ-ánkóní namuro-wáásí éma seyaafá-sáwí-ímáyáágó empímbá óraaꞌa uwánkáímba po Fasiꞌaénkóní kaweꞌ-ámbá sáwíꞌo úmae iyóndasafena ");
INSERT INTO auy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","káféꞌa Fasiꞌaénkó ení méyámbá amína aúramba kafíꞌwína tuwímbai-kanaa sámo káínda ímba awánáínone Póro súwana minúwóíyáámbá Érímasin-aúrampaꞌa kumeuꞌá uwágúwana siyáán-toꞌmaesamo níyane séna waási tiyaafáí úmae wénuwana ");
INSERT INTO auy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","kámáni-kawaago Fasiꞌaénkón-aai iséna áátafena éna Fasiꞌaénkómó úmba awánéna séna Fasiꞌaénkón-aai éraiꞌ-aain-iye séna amankúnkúmba uráiye. ");
INSERT INTO auy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Póro weséꞌo wénuwaise Péfosi-naopaꞌa tuwésa nompín-táómba taꞌótoresa íyátesa wémesa Pámpíriyaa-marafaꞌa Pékaa-naopaꞌa mindómpín-táómpinkemba kúmúwana Yóni-Mááka tiyuwéna Yérúsaremufaꞌa kóúwasarai ");
INSERT INTO auy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","mindárai marapáꞌá wémesarai Písíndiyaa-marafaꞌa Ántíoku-naopaꞌa wésarai Yúndaa-waasi ámáán-aaimo ísón-kanaaraꞌa Yúndaa-amaan-daumpaꞌa maraꞌá iméroyasa ");
INSERT INTO auy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","aúfáífinkemba Maníkóní ámáámba Mósese agaimakómba simátimesa Maníkón-aaimo simátímakowi agaimakón-aai simátímúwasa Yúndaa-amaan-kawaa-waasi moóráwigomba aiꞌmárówana mindáraifaꞌa téna séna kentáásí waásiyaiyo aaimó wérainakaimo ékai kentáásí imáyáa símai asésinkaakaiyo súwana ");
INSERT INTO auy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Póro íyáfasinena séna ísáaro. Kesí Ísareri-waasiye fíꞌonkaa-waasi Maníkón-ímáyáámó mósá márááwiye ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Naaófáꞌá Ísareri-waasiti Maníkó kentáá síwáꞌnásafena séna kesí waásin-owe súwasa fíꞌon-kwaasiti marafáꞌá Ísípi-marafaꞌa mésa sáwífaꞌ-waasi agáúwana Maníkó wení óraa-fasiꞌaemba wérontafena Ísípifakemba tíꞌmaena ");
INSERT INTO auy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","máásai-marafaꞌa mátinkowasa sáwífaꞌ-aatai 40 aatai wénesa aasiyaasí Maníkóntáfésa sáwí-imayaa umbánifo Maníkó miwíyáꞌá káráwiyena ímba tiyuwówasa ");
INSERT INTO auy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kénaani-marafaꞌa afakaeté-marafaken-kwaasi moórá-mora úmai mérowana Maníkó tínkambaena wéiyuwasa tuwímbai putásowana miwítí maramá maimaéna wení waási Ísareri-waasi mátimuwasa ");
INSERT INTO auy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","mimbáráfáꞌá mésa sáwífaꞌ-aatai 450 aatai maiyáawe. 450 aatai máúwana Maníkó moórá-mora-waasi kawáá-kísáúráꞌá íyáfasintinkafaꞌa kúwana Maníkón-aaimo simátímakowin-awiꞌa Sámúwéri íyámauwasa miyán-káwáá-wáásí taíꞌásowasa ");
INSERT INTO auy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ísareri-waasi Maníkó ímba kentááráꞌá káráwiyinkwae sésa kentááfínkémbá moóráwigomo éna kentááráꞌá káráwiniye suwaná Maníkó séna Pénisaminin-andafakewi Kísin-ááninkon-awiꞌa Sóro káráwiyi-kisau máíníye súwana minkísáú wémaena 40 aatai maisuwówana ");
INSERT INTO auy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Maníkó minkísáú Sórompakemba Yésin-ááninkon-awiꞌa Téfítimba amúwana maúwana séna Téfíti kemó súndantemba wéifo aamoí uwánkaumne Maníkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Naaófáꞌá Maníkó séna Téfítin-andafakembo ánaaembo íyáfasinankaandawi wemó éna Ísareri-waasi sáwíꞌo úmaimo mérempinkemba kaweꞌ-ámpáꞌá métinkainiye siyáimba Ísuntafena minéráíꞌ-ááí siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ísu ímba seyaafáꞌ-wáásí túrankaꞌo paápé urónkaꞌa Yóni nombó maitinkówi seyaafáꞌ-Ísárérí-wáásísáféna simátimena séna kentí sáwí-imayaa tínaaembo uwámeꞌo Maníkómpáꞌó tíyaꞌo éꞌa nombá maitinkánaumne súwasa miyá uwaná nombá maitinkéna ");
INSERT INTO auy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","wení kísau ampáánkáꞌá taiꞌáíne úwana simátimena séna kentí imáyáagomo kentáféꞌo nááwaꞌiyomo sembá wéamuꞌmaraawi ímba kemá úmpo kesínaaembo tíndawi wemá óraako kembá íyáákaraifo wemó aaimó síndaraꞌo kemó sendá sáwíꞌan-iye Yóni siyáiye Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Póro simátimena séna kesí waási Émbaramun-andafaken-kwaasiye fíꞌonkaa-waasi Maníkón-ímáyáá mósá márááwiye ísáaro. Sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌó métínkáímba kentáásáféna Maníkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yérúsaremufaken-kwaasiye miwítí kawáá-wáásíyé sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkainiyemo siyáin-aai Ísuntafesamo siyáamba ímba imáyáa uráawe. Aasiyaasi-kánáá ámáán-aaimo ísón-kanaa Maníkón-aaimo simátímakowi agaimakón-aai aúfáífinkemba toráumai suwasá isésa Ísuntafesamo siyáamba ímba imáyáa uráafo tufúwana pukáifo mináúfáífínkén-ááí paápé uráiye. ");
INSERT INTO auy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tufuwíyan-ambo saafá umbá ímba sáwíꞌa uróntafesa Páíratintafesa úwoi sésa tufuwínone siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Maníkón-aai aúfáífimba Ísun-aai agaimakómba seyaafáꞌá miyá uwasá aaraa-táíyákémbá maimái óntan-aifimba máutamakowana ");
INSERT INTO auy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Maníkó pukómpinkemba íyáfasinankowana ");
INSERT INTO auy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ayáátáákaꞌa moórá-mora-kanaa wení waási túrankaꞌa paápé uráiye. Ímbo tufúkónkaꞌa Kárírifakemba Yérúsaremufaꞌa weséꞌo kuráawi pukómpinkemba íyáfasinenamo moórá-mora-kanaamo paápé urómba minkwáásí awánésa sésa awánáúndasaawe isáúndasaawe Ísareri-waasi kosimátímaꞌmaeta kónae sésa kuráamba minkísáú paaí wémaewe. ");
INSERT INTO auy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Páánápáasiyekai minásé-ááí simátíméyanekai túye. Maníkó kentáá síwáꞌnásafena miyá ónaumnemo siyáimba kesáámó méraunda-kanaafinta miyá éna Ísumba pukómpinkemba íyáfasinankaraiye. Minááí imó agaimakón-aufaifimba kaepímbá agaimaréna séna emá kesáánimba ónaꞌa kesí kísauraꞌa ánkaraumne agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Maníkó wembá pukómpinkemba íyáfasinankaraimba póna ímba anekaꞌá puwínana áúma kawááꞌíndasafena Maníkó séna Téfítintafe séꞌa éraiꞌa kaweꞌá uwánkanaumne siyáundantemba embá kaweꞌá uwánkanaumne Maníkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Moóráfaꞌa imó agaimakón-aufaifimba agaimaréna séna Maníkó wení kawe-kísáú-wáásígómbá ímba auwáínana áúma kawááꞌíníye agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Minááí ímba Téfítintafena siyáifo Téfíti Maníkóní kísau wémaena puwúwasa maimaésa aíwáꞌnámo utámakompimba máutamarowana áúma kawááꞌuraifo ");
INSERT INTO auy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Maníkó Ísumba pukómpinkemba íyáfasinankarowimba wenáúma ímba kawááꞌuraiye Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Póro simátimena séna kesí waásisono. Ísámai kaweꞌán-oro. Ísu pukómpinkemba íyáfasinankaraiwaintafena waásiti aoisaambá maitiyuwáíníye Maníkó siyáiye. Minááímó simátimunda ísámai kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Maníkó Mósesembo simámakain-amaambo arááíwáéwimo ombá minámáánkó kentí aoisaambá ímba maitiyuwáínana arupíse úmai méraawin-owe Maníkó ímba sínífo Ísumo éna wenááisafesa timankúnkúmbo íyawiti aoisaambá maitiyuwáínana miwísáféna arupíse úmai méraawin-owe Maníkó síníye. ");
INSERT INTO auy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Miyáumai Maníkón-aaimo simátímakowi siyáan-aaigo kempáꞌá tifó séꞌa káráwimai kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Naaófáꞌá Maníkón-aaimo simátímakowi agaimarésa sésa éraiꞌ-aaisafeꞌa símai sáwíꞌo on-kwáásí ísáaro. Kembiwímó méraiyan-kanaa kísau máénda minkísáúmó awánéꞌo ímbo kempáꞌó téꞌo éꞌa úwoi puwónááwe. Minkísáúsáfésamo simátimiyaꞌa minááísáfésa ímba timankúnkúmba ónááwe sésa agaimarésa siyáawe. Minááí kempáꞌá tifó séꞌa káráwimai kaweꞌán-oro Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Minááí simátimena Póroe Páánápáasiye ámáán-daumpakemba máápaꞌa kumónae uyasá waási sésa anekaꞌá ámáán-aaimo ísáán-kanaa tínakai minááí másíyata ísáano ");
INSERT INTO auy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","simásuwesa máápaꞌa kúmúwasa sáwífaꞌ-waasi Yúndaa-waasiye fíꞌonkaa-waasi Yúndaa-amaan-ampaꞌo kuwáíyé Póronte Páánápáasinte tirááíwaꞌmaesa kuwasaráí sésarai Maníkó úwoi kaweꞌá uwátinkainifo fasiꞌámai wení aampaꞌá koró siyááye. ");
INSERT INTO auy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Suyaná Yúndaa-waasi ámáán-aaimo ísón-kanaa túwasa mindáópaken-kwaasi seyaafáꞌá Fasiꞌaénkón-aai isánae sésa Yúndaa-amaan-daumpaꞌa imérowasa ");
INSERT INTO auy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yúndaa-waasi tuwánésa tirunkó sáwíꞌa úwasa minááí arááíwáéfo sésa Póronte Páánápáasinte karaánááꞌa tinkésa karoꞌ-ááí séye sésa símai taráísúwasarai ");
INSERT INTO auy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","miwí táároi ímbo inkáísúyamba óraaka sésarai aifaꞌá éraiꞌa Maníkón-aai simátimuyamba minááí tínaaemba uwámeꞌa ímba sínkáíye sembá póꞌa aúíꞌo úmaimo maéꞌmaeꞌo ondá uwófíꞌa ónaumne-imayaa ombá pókai tauwerékai fíꞌonkaa-waasi Maníkón-aai kosimátimeyauye. ");
INSERT INTO auy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ááéma Fasiꞌaénkó simásimenasa séna emá fíꞌonkaa-waasi sáma kátinke kesáái simátímínasa kesí aambá awánáíyaꞌa seyaafáꞌ-máráfákén-kwáásí sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métinkanaumne Maníkó minááí simásímakaimba pókai fíꞌonkaa-waasi wenáái kosimátimeyauye Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Póro súwasa fíꞌonkaa-waasi isésa Fasiꞌaénkón-aaisafesa aamoí ésa tirunkó kaweꞌá úwana Maníkó séna kesí waási éꞌa aúíꞌa úmai maéꞌmaeꞌa ónááwe súwasa miwí Fasiꞌaénkón-aaisafesa timankúnkúmba uráawe. ");
INSERT INTO auy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Fasiꞌaénkómpáꞌá timankúnkúmba ésa mimbáráfáꞌá Fasiꞌaénkón-aai kosimátin-tasimatin-uwasá sáwífaꞌ-waasi ísówasa ");
INSERT INTO auy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yúndaa-waasi Póronte Páánápáasinte tirumbá sáwíꞌa uwátinkesa aare túwíꞌo wéron-inimba Yúndaa-amaan-aaimo fasiꞌámaimo méron-inine mindáópaken-oraaꞌ-waasiye tirumbá tórówasa Póronte Páánápáasinte sáwíꞌa uwátinkesa aaisambá tiyésa miwítí marafákémbá tiꞌmátuwowasarai ");
INSERT INTO auy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Maníkó minkwáásí ímba aamoí uwátinkainiye-aiyowaiꞌa ésarai tísamaifakem-barama uwáꞌmaresarai Ántíoku-naopaꞌa tuwésarai Áíkóníyamu-naopaꞌa kuyasá ");
INSERT INTO auy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ántíoku-naopaꞌa Ísuni aampaꞌó kun-kwáásí mérowana Maníkóní Ufaen-ámútánkó miwífímbá óraaꞌa uwátinkowana tirunkó kaweꞌá uráiye. ");
INSERT INTO auy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Póroe Páánápáasiye Áíkóníyamu-naopaꞌa wésarai ááémo urááyantemba Yúndaa-amaan-daumpaꞌa imésarai ásé-aai óraaka simátímúyasa isésa sáwífaꞌ-waasi Yúndaa-waasiye fíꞌonkaa-waasiye Ísun-aaisafesa timankúnkúmba uwasá ");
INSERT INTO auy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","tuwímbai-Yundaa-waasi Ísun-aaisafesa tínaaemba uwámesa ímbo timankúnkúmbo uwáí Póronte Páánápáasinte sáwí-aai simátínkówasa fíꞌonkaa-waasi isésa mindáraiye Ísun-aaimo ísówiye tirumbá sáwíꞌa uwátínkówasa ");
INSERT INTO auy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","mindárai ayáátáákaꞌa mindáópaꞌa mésarai miwí táároi ímbo inkáísúyamba Fasiꞌaénkón-aai óraaka simátímúyana Fasiꞌaénkó waási úwoi kaweꞌó uwátínkáímba awánáíwae séna mindárai wení fasiꞌaémbá timúwasarai ímbo awánaron-kisau kawe-kísáú máúyasa ");
INSERT INTO auy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","mindáópakewi kaeká tuwínkaaꞌ-ésa tuwímbai Yúndaa-waasi-taaisafesa éraiꞌe suwasá tuwímbai aantá-waasi-taaisafesa éraiꞌe siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Suwasá fíꞌonkaa-waasiye Yúndaa-waasiye miwítí óraaꞌ-waasiye túwaandu ésa tínkamonae-aai sésa óntantamba Póronte Páánápáasinte tínkamonae suwasaráí ");
INSERT INTO auy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","minááí isésarai kaweꞌó íyapaꞌe sésarai Ríkíóniyaa-marafaꞌa wésarai Rísítara-naopaꞌe Tépi-naopaꞌe fíꞌo-fiꞌon-daopaꞌe ");
INSERT INTO auy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ásé-aai simátímaꞌmaesarai kurááye. ");
INSERT INTO auy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Moóráwigo Rísítara-naopaꞌa anówan-arumpinkemba aísamai sáwíꞌo uwáguromba maꞌánkarowana ímba aíntómba ááémo maúnkaꞌa ména ");
INSERT INTO auy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Póro wésimatimun-aai iséna éraiꞌ-aai wésimba póna kaweꞌá uwásinkainiye-imayaa úwana Póro minímáyáámó úmba awánéna arááꞌa afuwéna ");
INSERT INTO auy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","óraaka séna kokuꞌá íyáfasinaao súwana íyáfasinkwena aamoí éna weyááríkaꞌa marapáꞌó kúmba ");
INSERT INTO auy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","sáwífaꞌ-waasi Póromo úmba awánésa miwí tááifinkemba Ríkíóniyaa-taaifinkemba sésa kentáásí maníkóráí waásiyaan-úmai marapáꞌá kentááfímbá kumbéraaye sésa ");
INSERT INTO auy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","miwítí maníkón-áwíꞌa mindárai simátinkesa sésa Páánápáasintafesa Súsiye sésa Pórontafesa aaiséꞌo simátímíwaiye sésa Émísiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Marukón-awáífáꞌá minkáróꞌ-máníkón-áwíꞌa Súsi wení ámáán-damba wérowana minkáróꞌ-máníkóntáféna ísámai póíꞌo uwándon-kwaasigo purumakamá wémaena mowáán-aramba wétarare úmaena mindáókoni kusai-óntáráꞌá mó marówasa sáwífaꞌ-waasi miwítí maníkóntáfésamo póíꞌo uwándaantemba miyáumai Ísuni aantá-waasiyaiyaꞌa póíꞌa uwándánaemo ");
INSERT INTO auy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","sun-ááí isésarai sáwíꞌan-iye sésarai kentí unáánkwátói tafétuwesarai tuwaantantésarai sáwífaꞌ-waasifimba komésarai óraaka sésarai ");
INSERT INTO auy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","kenkáí nóra ónaera wéoo. Keráí kemó onten-kwáásí úye. Ásé-aai tasimátimuyamba miyán-káróꞌó ombá tuwéꞌa éraiꞌ-Manikompaꞌa teró. Éraiꞌ-Maniko wíyóne marawé uwí-nóné mimpímbó wérain-tantaaꞌe úmarena fasiꞌaénkwáráwí méraiye. ");
INSERT INTO auy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ááéma Maníkó úwoi tíyukowaꞌa kentí imáyáafinkemba seyaafáꞌ-áémpákén-kwáásí wénesa ");
INSERT INTO auy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","miyá éꞌéímbanifo Maníkó méraiye síwae séna aaí sisaná aaꞌá téna tónkó kaweꞌá isaꞌá wéneꞌa tirumpin-áámóí wéowe. Miyáumai awánéꞌa miyámó im-báníkó méraiye síwae séna Maníkó kaweꞌ-íꞌa wéiye ");
INSERT INTO auy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","mindárai minááí suyasá seyaafáꞌ-wáásí fasiyésa mindáraiyaꞌa póíꞌa uwándánae suwasaráí ímba miyán-oro símai tufímbaesarai íyúyasa ifátukaawe. ");
INSERT INTO auy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ifátuwowasa tuwímbai-Yundaa-waasi Písíndiyaa-marafaꞌa Ántíoku-naopakene tuwímbai Áíkóníyamu- naopakene tésa seyaafáꞌ-wáásí tirumbá tórówasa isésa Póromba óntantamba tufuwésa éꞌa púwíye-imayaa ésa tafisímaesa mindáókoni awáífáꞌá mátúwówasa ");
INSERT INTO auy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ísuni aampaꞌó kuwáí taúkúresa awánowana íyáfasinena mindáópaꞌa wéna kowaúmba aafáyáaraꞌa íyáfasinesarai Póroe Páápápáasiye mindáópaꞌa tuwésarai Tépi-naopaꞌa kurááye. ");
INSERT INTO auy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Póroe Páánápáasiye Tépi-naopaꞌa ásé-aai kosimátímúyasa isésa éraiꞌe sésa Ísuni aampaꞌá kuwasaráí mindárai Rísítara-naopaꞌa anekaꞌá kurésarai minkákémbá Áíkóníyamu-naopaꞌa kurésarai minkákémbá Písíndiyaa-marafaꞌa Ántíoku-naopaꞌa anekaꞌá kurésarai ");
INSERT INTO auy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","miyá úmae wénesarai Fasiꞌaénkón-aaisafesa timankúnkúmbo uwáí miwítí imáyáa fasiꞌátinkesarai sésarai Ísuni aampaꞌá fasiꞌámai koró sésarai Maníkó wení waásimo kawáánipaꞌo kónae séꞌo éꞌa minámpáꞌá umbaimó tain-ámpáꞌá kónááwe sésarai ");
INSERT INTO auy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","miyáumai mindáópakaꞌa wénesarai Fasiꞌaénkóní waásifinkemba miwítí óraaꞌ-waasi íyáfasintinkafaꞌa kuyasá Maníkón-ímáyáá ésa ímba tómbá nésa inaí aantemba wésesa mindárai Fasiꞌaénkómpáꞌá timankúnkúmbo uwáísáfésarai Fasiꞌaénkó káráwitinkamae iyíníye simátímakaaye. ");
INSERT INTO auy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Simátimesarai Písíndiyaa-marafaꞌa kóyáákesarai Pámpíriyaa-marafaꞌa wésarai ");
INSERT INTO auy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pékaa-naopaꞌa komésarai ásé-aai kosimátimesarai minkákémbá Átériyaa-naopaꞌa kumésarai ");
INSERT INTO auy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","nompín-táómba taꞌótoresarai íyátesarai témesarai Síriyaa-marafaꞌa Ántíoku-naopaꞌa aneká tiyááye. Ááéma mindáópaꞌa Fasiꞌaénkóní waási mindáraisafesa Maníkó túwaꞌnai úmaena iyínífo wení kísau komáékaiyo siyówasarai minkísáú komaisuwésarai tiyááye. ");
INSERT INTO auy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ántíokufaꞌa tuyasá Fasiꞌaénkóní waási tatúwaandu uwasaráí Maníkómó simátimuntembo urááyan-aai sésarai Ísuni aampaꞌó fíꞌonkaa-waasi aráátímúyasa minááísáfésa timankúnkúmba ésa minámpáꞌá kowé-ááí tasimátimesarai ");
INSERT INTO auy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","mindáópaꞌa Ísun-aaimo ísówi ayáátáákaꞌa méraaye. ");
INSERT INTO auy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ántíoku-naopaꞌa méroyasa tuwímbai Yúndiyaa-marafakemba Ántíoku-naopaꞌa komésa Ísun-aaimo ísówisafesa sésa Maníkó Mósesembo simámakain-amaambo ímbo iséꞌo túmo kárámai araénáémbo íyanamo éna Fasiꞌaénkó sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá ímba métinkainiye suwasaráí ");
INSERT INTO auy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Póroe Páánápáasiye minááísáfésarai aaisambá tiyésarai wesimán-kwesiman-esa Ántíokufakewi Ísun-aaimo ísówi sésa Yérúsaremufaꞌa aantá-waasiye Fasiꞌaénkóní waásiti óraaꞌ-waasiye minááísáféꞌa kotísai oro sésa Póroe Páánápáasiye tuwímbai-waasiye tiꞌmárówasa kuráawe. ");
INSERT INTO auy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Fasiꞌaénkóní waási tiꞌmárówasa wémesa Fínísiyaa-marafaꞌe Sámériyaa-marafaꞌe naaóꞌ-naoꞌa komérowasa Ísun-aaimo ísówi túwaandu urówi simátimesa sésa fíꞌonkaa-waasi Ísun-aai isésa timankúnkúmba ésa méraawe suwasá isésa tirunkó kaweꞌá úwasa ");
INSERT INTO auy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","naaóꞌ-naoꞌa simátimesa wémesa Yérúsaremu-naopaꞌa komérowasa aantá-waasiye Fasiꞌaénkóní waásiye miwítí óraaꞌ-waasiye tiyáámba timésa aamoí uwasá Maníkó kísaumo tímakain-kisaumo maiyáan-aai másimatimuwasa ");
INSERT INTO auy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","isésa tuwímbai Ísun-aaisafesa timankúnkúmbo umbánifo ámáán-kawaa-waasiti aampaꞌó kuwáí íyáfasinesa sésa fíꞌonkaa-waasi Ísun-aaisafesa timankúnkúmbo owí Mósese simátímakon-amaamba isésa túma kárámai araénáémba orómá kosimátíméro suwasá ");
INSERT INTO auy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","aantá-waasiye óraaꞌ-waasiye sésa minááí túwaandu uréta imáyáa úmaisa senó siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Uwasá túwaandu urésa ayáátáákaꞌa minááí suwaná Pítaa íyáfasinena séna kesí waásisono. Fíꞌonkaa-waasi ásé-aai isésa Ísun-aaisafesa timankúnkúmba íwae séna ááéma Maníkó kempínkémbá íyáfasisinkena siꞌmarówaꞌa kosimátimewanasa isésa éraiꞌe siyáawe. Kemá minááí éꞌa ísaraawe. ");
INSERT INTO auy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Maníkó seyaafáꞌ-wáásítí imáyáa tuwánéna fíꞌonkaa-waasisafena séna kesí waásin-owe séna Ufaen-ámútámbó símakainten-úmai miwíwáráꞌó tímakaimba awánaraumne. ");
INSERT INTO auy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Maníkó Yúndaa-waasisa fíꞌon-amba ímba aráásimenasa fíꞌonkaa-waasi ínta fíꞌon-amba aráátimena wéifo Maníkó seyaafáꞌ-wáásísá mimbórá-ántá wéaraasimiye. Miwí Ísun-aaisafesa timankúnkúmbo ontáféna miwítí sáwí-imayaa maitiyuwéna kaweꞌ-ímáyáá uwátínkaraiye. ");
INSERT INTO auy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mósesen-aaigo kentáá síwáꞌnása umbaí tiyówasa ímba kanaaꞌá arááíwakaawe. Kentááwáráꞌá miyá isatá ínta kanaatá wéaraaiwaumne. Mindásafesa fíꞌonkaa-waasi Ísuni aampaꞌó kowísáfésamo Mósesen-aai arááíwáéro síyasamo ésa umbai-ámbá arááíwaenaawe. Miyámó íyanamo éna Maníkó aaisambá sínaꞌa ímba miyá ónááwe. ");
INSERT INTO auy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Fasiꞌaénkó Ísu úwoi súwaꞌnai enasa sáwíꞌo úmaimo méraundafinkenta kaweꞌ-ámpátá méwésinkaiye. Minááísáféta éraiꞌesa sénáísaiye miyámó wéintenta fíꞌonkaa-waasiwaraꞌa miyá wéiye Pítaa siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pítaa súwasa isésa seyaafáꞌnánká éraiꞌa siyé sésa ímba aaí suwasaráí Póroe Páánápáasiye Maníkó tímakain-kisau fíꞌonkaa-waasifimbo minkísáú maiyááyan-aai simátimesarai Maníkóní kísau ímbo awánaraan-kisau kawe-kísáúmó maiyááyan-aai ");
INSERT INTO auy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","simátímúyana Yémísi séna kesí waásisono. Kesáái ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ááéma Maníkó fíꞌonkaa-waasisafena imáyáa éna minkwáásífínkémbá tuwímbai íyáfasintinkena séna kesí waásin-owemo siyáin-aai Pítaa káféꞌa simásímakaiye. ");
INSERT INTO auy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Maníkón-aai simátímakowi minááí aúfáífimba agaimarésa sésa ");
INSERT INTO auy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Fasiꞌaénkó séna ánaaemba kuméꞌa Téfítini naambó tawísísukaamba kunuwásuwanaumne. Sáwí-tantaaꞌwaraꞌa kaweꞌó kunuwásúwáanda pósa ");
INSERT INTO auy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","fíꞌonkaa-waasi kempáꞌá ténááwe. Kesí waásin-owe sendawí kempáꞌá ténááwe séna ");
INSERT INTO auy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Fasiꞌaénkó minááí naaófáꞌá siyáimba isaná káféꞌwaraꞌa miyá wésiye Yémísi siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yémísi simátimena séna Fasiꞌaénkó siyáin-aaisafeꞌa imáyáa éꞌa séꞌa fíꞌonkaa-waasi Maníkómpáꞌó ten-kwáásí umbai-kísáú ímba timénaumpo ");
INSERT INTO auy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","aúfái agaimái timéta séta karoꞌ-máníkóntáfésa imáyáa ésa póíꞌo uwándaamba mimpóí ímba naaró. Aare-úméné waai-úméné ímba oró. Póíma tufúꞌnewana wení naaemá ímbo kumíndamo úwoimo wérainaꞌa mimpóí ímba naaró. Naaewáráꞌá ímba naaró. Minááí aúfáífimba agaimaráúmpo toráumai ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ááémo maéꞌón-kwaasiye káféꞌo méraan-kwaasiye ayáátáákaꞌa aasiyaasí ámáán-aaimo ísáán-kanaa minááí Mósesen-aai simátímaꞌmaesa kuráawe. Mindásafeta aúfáífimba agaimaráúmpo toráumai ísáaro Yémísi siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Súwasa aantá-waasiye Fasiꞌaénkóní waásiye miwítí óraaꞌ-waasiye sésa kanaámpóta kentááfímbá tuwímbai tiꞌmáráanasasa Póroe Páánápáasiye Ántíokufaꞌo wíyapaꞌa miwíséꞌa wíwae sésa miwífínkémbá kaeꞌ-wáásí túwíꞌa mósá makáan-kwaasiyai-tuwiꞌo sumbá moóráwigo Sáírási úwana moóráwigo kaeꞌ-áwíꞌá Yúndasi Pásapasiye úmai ");
INSERT INTO auy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","aúfái timésa tiꞌmárówasa kuráawe. Mináúfáífímbá agaimarésa maará siyáawe. Kesáá kentí waásisa úne. Aantá-waasiye óraaꞌ-waasiye moórá-aai sénaumpo kentáásí waási ísáaro. Fíꞌonkaa-waasi Ántíoku-naopaꞌe Síriyaa-marafaꞌe Sírísiyaa-marafaꞌo méraan-kwaasi ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kentááfínkémbá tuwímbai kempáꞌá wésa ímbo simátímakaunda-aai miwítí imáyáafinkemba kosimátímúwaꞌa iséꞌa tirunkó sáwíꞌa úwaꞌa umbaimó taráanta iséta ");
INSERT INTO auy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","túwaandu uréta imáyáa éta mimbórá-ááí símai kaeꞌ-wáásí íyáfasintinketa tiꞌmaráúnasasa Páánápáasiye Póroeꞌa migóye. Mindárai kesí waásisa siruntá tímakaundanaraiye sínkamiyakai puwúyafo-imayaa ímba ésarai Fasiꞌaénkó Ísu Káráísitini kísau wémauye-imayaa ésarai fasiꞌámai wémaeye. ");
INSERT INTO auy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yúndasinte Sáírásinte tiꞌmaráúnasarai migóyamba pósarai aúfáífinken-aaiwara simátimiyan-aaiwaraꞌa mimbórá-ááí pósarai kosimátimeyaaye. ");
INSERT INTO auy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Maníkóní Ufaen-ámútánkówé kesááwé mimbórá-ááí símaisa ímba umbai-ááísá simátimumpo maanáúfáífínkén-ááí simátimundasa ísáaro. ");
INSERT INTO auy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Karoꞌ-máníkóntáfésa imáyáa ésa póíꞌo uwándaamba mimpóí ímba naaró. Naaemá ímba naaró. Póímo tufúꞌnewana wení naaemó ímbo kumíndamo úwoimo wérainaꞌa mimpóí ímba naaró. Aare-úméné waai-úméné ímba oró. Kesáámó súnda-aaimo iséꞌo éꞌa kaweꞌá ónááwe. Minááí taíꞌáiye. Aúfái agaimái timésa siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Suwasá mináúfáí timésa tiꞌmárówasa maimaé wémesa Ántíoku-naopaꞌa kuwasá Fasiꞌaénkóní waási túwaandu urówasa mátímúwasa ");
INSERT INTO auy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","mináúfáífínkémbá toráumai simátímúwasa kaweꞌ-ááí isésa tirunkó kaweꞌá úwasarai ");
INSERT INTO auy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yúndasiye Sáírásiye Maníkón-aai simátímakoyan-kwaasi ésa ayáátáákaꞌa simátimesarai miwítí imáyáa arupíse uwátímúyasa isésa fasiꞌowasaráí ");
INSERT INTO auy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","tuwímbai-noꞌwaamba miwíséꞌa méroyasa Ísun-aaimo ísówi sésa éꞌa kanaán-ifo tiꞌmákaan-kwaasifaꞌa kaweꞌ-ááí kosimátímékaiyo suwaná ");
INSERT INTO auy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sáírási fíꞌon-imayaa éna mindáópaꞌa mérowasarai ");
INSERT INTO auy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Póroe Páánápáasiye ayáátáákaꞌa Ántíokufa mésarai mindáraiseꞌa tuwímbai-waasi mésa Fasiꞌaénkón-aai simátímaꞌmaesa kuráawe. ");
INSERT INTO auy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ánaaemba Póro Páánápáasintafena séna naaóꞌ-naoꞌa Fasiꞌaénkón-aaimo simátímakauyamba Ísun-aaimo ísaraawi kawerá úmaiya méraawai tuwánamaekai kóyae Póro súwana ");
INSERT INTO auy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Páánápáasi séna Yóni-Máákaamba áíꞌmekai kóyae súwana ");
INSERT INTO auy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Póro séna weséta téwáyana Pámpíriyaa-marafaꞌa kenkáí másiyuwena wení naaópaꞌa tauwékáimba pókai ímba áíꞌmekai kóyauye Póro súwana ");
INSERT INTO auy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","minááísáféna kaorésarai aaisa simásuwesarai mindárai tuwínkaaꞌ-uyaná Páánápáasi Yóni-Máákaamba áíꞌmaena nompín-táómba taꞌótoresarai íyátesarai wémesarai Sáíparasi-marafaꞌa kuyaná ");
INSERT INTO auy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Póro Sáírásimba aiyówasa Ísun-aaimo ísówi inaí simásuwesa sésa Fasiꞌaénkó úwoi kaweꞌá uwátinkainifo kokaiyó suwaná Sáírásimba áíꞌmaena kúmba ");
INSERT INTO auy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Síriyaa-marafaꞌe Sírísiyaa-marafaꞌe naaóꞌ-naoꞌa wénesarai Fasiꞌaénkóní waási túwaꞌnai úmaesarai kuyasá kaweꞌá uráawe. ");
INSERT INTO auy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Póroe Sáírásiye miyá úmaesa Tépi-naopaꞌe Rísítara-naopaꞌe kuyaná moóráwigon-awiꞌa Tímóti mindáópaꞌa ména Ísuni aampaꞌó kúwai úwana anówa Ísuni aampaꞌó kún-ininko Yúndaa-ininko úwana afowá Kíríki-waasi úwasa ");
INSERT INTO auy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Rísítara-naopakene Áíkóníyamu-naopakene Ísun-aaimo ísówi Tímótin-awiꞌa mósá makáawe. ");
INSERT INTO auy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Afowá Kíríki-waasi éna áúma ímba kárámai araénáémba urómba pósa Yúndaa-waasi mináémpáꞌó méraan-kwaasi miyán-ááí ísówana Póro séna Fasiꞌaénkóní kísauraꞌa Tímótimba aiyánae séna Yúndaa-waasi aamoí íwae séna Tímótimba áúma karéna ");
INSERT INTO auy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","áíꞌmaena naaóꞌ-naoꞌa wénesa aantá-waasiye Fasiꞌaénkóní waásiti óraaꞌ-waasiye Yérúsaremufaꞌo siyáan-aai Fasiꞌaénkóní waásisafesa simátímaꞌmae wésa sésa minááí ísáaro suwasá ");
INSERT INTO auy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Fasiꞌaénkóní waási Ísumpaꞌa fasiꞌámai mésa fíꞌon-kwaasi simátímaꞌmaesa kuwasá isésa aasiyaasi-kánáá tuwímbai Ísun-aaisafesa timankúnkúmba úmae wéwesa sáwífaꞌ-waasi-iꞌa uráawe. ");
INSERT INTO auy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pórowe Sáírásiye Tímótiye Fírísiyaa-marafaꞌe Kárésíyaa-marafaꞌe wénesa Ésiyaa-marafaꞌa ásé-aai kosimátimenae sumbá Maníkóní Ufaen-ámútánkó ímba kónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","isésa wémesa Mísiyaa-maragoni ófímbá kurésa Pítíníyaa-marafaꞌa kónae sésa uwaná Ísuni ámútanko ímba kónááwe súwasa ");
INSERT INTO auy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","isésa wémesa Mísiyaa-marafaꞌa kóyáákesa wémesa Tóróasi-naopaꞌa kúmúwana ");
INSERT INTO auy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","nóꞌwaamba Póro kaainkáámbá awánówana Máséndóniyaa-marafaken-kwaasigo kokuꞌá taména séna Máséndóniyaafaꞌa tasúwaꞌnai uwo óraaka súwana ");
INSERT INTO auy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Póro awánéna simásimuwata íyáfasineta séta Máséndóniyaa-waasisa ásé-aaisa kosimátíméndasafena Maníkó wésaantaisata Máséndóniyaafaꞌa kónaesa siyáumne. ");
INSERT INTO auy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Miyá séta Tóróasi-naopaꞌa nompín-táómba taꞌótoreta íyáteta kówánanasa mindómpín-táónko arupíyaꞌa kúwata Sámóteresi-marafaꞌa kowaéwándasa aafáyáaraꞌa wémeta Níápórisi-naopaꞌa marapá kúwateta ");
INSERT INTO auy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","minkákémbá Fírípái-naopaꞌa marapátá kuráumne. Mindá Máséndóniyaa-marafaꞌa óraaꞌ-naopaꞌa Rómu-kamani-waasimo káráwiyon-daopaꞌa tuwímbai-noꞌwaamba kówaeta ");
INSERT INTO auy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Yúndaa-waasi ámáán-aaimo ísón-kanaa úwata imáyáa éta Yúndaa-waasi nonáwáífaꞌa túwaandu ésa inaí wésesa owé séta naaópaꞌa tuwéta nonáwáífaꞌo kumówándasa aaresómbá túwaandu urópata kumbéta simátimewanasasa ");
INSERT INTO auy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","isésa uwaná moórá-ininko Táyátáira-naopaken-ininkon-awiꞌa Ríndíyaa wení kísau óraan-tantaaꞌa ampantaráꞌá tásuwena wétimena óntamba wémaena wemá Maníkón-ímáyáá éna wenáwíꞌo mósá marón-ininko Fasiꞌaénkó imáyáa amúwana Póron-aai kaweꞌ-úmai isówana ");
INSERT INTO auy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","minínínkówárá wení akúnkwáráꞌá nombá maitinkówana minínínkó séna kentáfé séꞌa Fasiꞌaénkón-aaisafena amankúnkúmba éna Ísumpaꞌa fasiꞌámai mérain-ininkon-iye séꞌa kesí naaúmpaꞌa taméranaawe óraaka súwata wení naaúmpata kuráumne. ");
INSERT INTO auy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Moórá-arasi kísaumo maún-arasigomba tuwímbai-waasi óntamba tuwésa méyánuraan-arasigomba sáwí-amutanko wenarumpimbá mérowana tuwímbai-waasifaꞌo ánaaembo paápé índa-aai simátimuwasa óntambo ámúmba wembó méyámbakaan-kwaasi timúwasa maéꞌómbaniye. Moórá-kanaa inaí wésupaꞌa kumówánanasa minárásígó suwánénasa ");
INSERT INTO auy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Póronte kenté sirááíwaꞌmae wéwena óraaka séna Maníkó wíyómpaꞌo méraiwaini kísaumo máén-kwaasin-owe. Maníkó sáwíꞌo úmaimo méraampinkemba kaweꞌ-ámpáꞌá métínkáín-aaimo simátíméwin-owe minárásígó séna ");
INSERT INTO auy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","sáwífa-kanaa arááíwaꞌmae wénena miyá súwana Póron-arunko umbaí tówana méutausena wenarumpimbó méro-sawi-amutankontafena séna Ísu Káráísitini fasiꞌaémbó wéraintafeꞌa óraaka súne. Minárásí auwé kóuwo súwana minúwóíyáámbá auwéna kóúwasa ");
INSERT INTO auy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","minárásímó méyánuraawi awánésa tirunkó sáwíꞌa úwasa sésa ímba óraaꞌ-ontamba maénaumne sésa Póronte Sáírásinte tiyáánkwanda tafisímaesa marupáꞌá kawáá-wáásíyáꞌá tiyésa ");
INSERT INTO auy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rómu-kamani-waasiyaꞌa tésa sésa maandárai Yúndaa-waasiyai kentáásí naaópaꞌa sáwí-kisau wémaeye. ");
INSERT INTO auy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kentáásí ámáámba taraisésarai fíꞌon-ampaꞌ-amaamba wéseye. Maandáraimo séyan-amaamba ínta arááíwaenaumpo Rómu-waasiti ámáánta arááíwaenaumne suwasá ");
INSERT INTO auy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","sáwífaꞌ-waasi taúkúresa óraaka sésa éraiꞌe suwasá kawáá-wáásí mindáraiti unáánkwátói tafétuwesa sésa kunánaantamba tínkamoro suwasá ");
INSERT INTO auy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","áfááraumai tínkambaresa tafisímaesa ándáfaꞌa fafúsúsuwesa ándáfaꞌo káráwiyon-kwaasigontafesa sésa ontaráꞌá káráwimai mindárai kaweꞌán-uwo suwaná ");
INSERT INTO auy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","afufumpin-dáúmpáꞌá mófafususuwena tísamaiyai taaí imaiyéna faráátamai ándásamba káráꞌumarowasarai méraaye. ");
INSERT INTO auy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mésarai nóꞌwaan-afufuntamba Póroe Sáírásiye inaí wésesarai Maníkómpáꞌá imá wésuyasa ándáfaꞌo méron-kwaasi ísówana ");
INSERT INTO auy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","minúwóíyáámbá óraaꞌ-marima tówana naamayáámba korekááre uwágúwana seyaafáꞌ-óntá tigúwana ándáfaꞌo méron-kwaasi tíyayaampimpaken-anda weyááríkaꞌa awákúwasa ");
INSERT INTO auy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ándá-naumpaꞌo káráwiyowi aúmá waiguréna íyáfasinena awánómba ontá tigurówana íyáawanena séna ándá-waasi kóuraawe-imayaa éna óraaꞌ-waasigon-aaroi inkaiséna wení paepáéꞌa mósá taúkéna wenáúfimba fagaifáíndasafena úwana ");
INSERT INTO auy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Póro awánéna óraaka séna ímba miyán-uwo. Kesáá seyaafátá úwoisa méraumne súwana ");
INSERT INTO auy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ándá-naumpaꞌo káráwiyowi wení waásisafena séna ómbá kúra-simero súwasa kúraꞌ-amuwana minúwóíyáán-úmai ándá-naumpaꞌo iyúmba aíyayaankakemba tataꞌá úwana óraakorai óye séna Póronte Sáírásinte tísamaifimba kífaena ");
INSERT INTO auy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","íyáfasinena tíꞌmaena máápaꞌa kumbéna séna nóra onanawá sáwíꞌo úmaimo méraundafinkemba Maníkó kaweꞌ-ámpáꞌá mésinkainiyo súwasarai ");
INSERT INTO auy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","mindárai sésarai Fasiꞌaénkó Ísu Maníkómpákémbó kunkáiwaintafe amankúnkúmba inaná ewé ení akúné sáwíꞌo úmaimo mérempinkemba kaweꞌ-ámpáꞌá métinkainiye simámesarai ");
INSERT INTO auy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","minkwáásísómbá Fasiꞌaénkón-aai simátímúyasa isésa ");
INSERT INTO auy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","mindóꞌwáán-afufuntamba ándá-naumpaꞌo káráwiyowi tíꞌmaena tirósááumpaꞌ-afima wénon-kwitiyuwena minkánáá wewé wení waásiye nombá maiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nombá maéna Póronte Sáírásinte tíꞌmaena wení naaúmpaꞌa mátínkarena tómbá timúwasarai wénoyasa wewé wení akúné Ísun-aaisafesa timankúnkúmba uwaná tirunkó kaweꞌá uráiye. ");
INSERT INTO auy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mérowasa aafáyáaraꞌa Rómu-kawaa-waasi i-wáásí tiꞌmárówasa ándá-naumpaꞌa wésa sésa mindárai faútínkénasarai kókaiyo suwaná ");
INSERT INTO auy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ándá-naumpaꞌo káráwiyowi Pórontafena séna Rómu-kawaa-waasi i-wáásí tiꞌmárááwasa tésa sésa Póronte Sáírásinte faútinkaao sefó faútínkáanakai tirunkó kaweꞌá ínakai kokaiyó súwana ");
INSERT INTO auy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Póro i-wáásísáféna séna ímba kaweꞌ-ááí sésa kempímbá ímba wérain-aai símai kunánaantamba sínkamesa ándáfaꞌa fafúsúsukaawe. Rómu-waasiti aúfái tokáuyan-kwaasi úyasa sínkamomba sáwíꞌa ésa minámáámbá taráíyaawe. Káféꞌa aúpáꞌá faúsínkéyan-imayaa owakáí ímba miyá óyauye-imayaa ékai Rómu-kawaa-waasi kempáꞌá tésa ontá tatisúwéwakai kóyauye Póro súwasa ");
INSERT INTO auy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","i-wáásí isésa kouwerésa Póron-aai tasimátimesa Rómu-waasiti aúfái tokááyan-kwaasin-oye simátímúwasa isésa táátafesa ésa ");
INSERT INTO auy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ándá-naumpaꞌa komésa sésa keráí Rómu-waasiti aúfáíma tokááyan-kwaasi óyata ímba ísareta úwoisa tínkankaunda mindá sáwíta éta tínkankaumne sésa tíꞌmaesa máápaꞌa kumésa aáno úmai sésa kentáásí naaópaꞌa tuwékai kokaiyó suwasaráí ");
INSERT INTO auy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Póroe Sáírásiye ándáfaꞌa tuwésarai Rítiyaani naaúmpaꞌa kuyasá Ísun-aaimo ísówi túwaandu urówasarai miwítí imáyáa kaweꞌá uwátinkesarai tiyuwésarai kurááye. ");
INSERT INTO auy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Póroe Sáírásiye wésarai Ámpíporisi-naopaꞌe Ápóróniyaa-naopaꞌe kóyáákesarai Tésáróníkaa-naopaꞌa kuyaná mindáópaꞌa Yúndaa-waasiti ámáán-damba wérowana ");
INSERT INTO auy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Póro úntemba Yúndaa-waasi ámáán-aaimo sunkáꞌá ámáán-daumpaꞌa iména Maníkón-aai aúfáífinken-aai simátimumba ámáán-aaimo ísón-kanaaraꞌa kaumbo-íká simátimena ");
INSERT INTO auy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","séna aúfáífinkemba séna Maníkómó íyáfasinankaraiwaimba áíꞌo índa-iꞌa uwánkaiyana puwéna íyáfasinainiye siyáimba minááígóní áwáuma aforaꞌá simátimune. Minááí Ísuntafesa siyáawe Póro súwasa ");
INSERT INTO auy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","isésa Yúndaa-waasi tuwímbai minááísáfésa timankúnkúmba ésa Póronte Sáírásinte tirááíwaesa Kíríki-waasi Maníkón-ímáyáá mósá márówiye sáwífaꞌ-inimba túwíꞌo wéron-ininte miyáumai-sawifaꞌ-waasi arááíwakaawe. ");
INSERT INTO auy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Arááíwáúwasa Yúndaa-waasi tuwánésa tirunkó sáwíꞌa úwasa sésa minááí arááíwáéfo sésa sáwí-waasi kafóná-waasi táántowasa tamésa tiyánae-aai simátímúwasa Yésónini naambá taúkúmaresa Póronte Sáírásinte tataꞌótoꞌmaeta seyaafáꞌ-wáásí túrankaꞌa aaifintá maitinkánae sésa tiyaafáí umbá ");
INSERT INTO auy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ímba méroyasa Yésóniye Ísun-aaimo ísówi tuwímbai tafisímaesa mindáópaken-kawaa-waasiyaꞌa mátinkesa óraaka sésa Póroe Sáírásiye sáwí-aai wémaresarai seyaafáꞌ-máráfáꞌá wétesarai káféꞌa maankáꞌwáráꞌá kentáásí naaópaꞌa taméraayana ");
INSERT INTO auy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yésóni wení naaúmpaꞌa mátínkaraiye. Rómu-aifa-kawaagoni ámáámba taraisésa sésa kentááráꞌó káráwiyaiwai Ísun-iye wésewe suwasá ");
INSERT INTO auy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","seyaafáꞌ-wáásíyé kámáni-kawaa-waasiye isésa tirunkó sáwíꞌa úwasa tiyáí-ímáyáá uwasá ");
INSERT INTO auy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","kawáá-wáásí Yésónimpin-kwimái tuwímbai-waasisafesa sésa óntamba simíyata faútínkáanaꞌa tiꞌmátuwaaro suwasá óntamba tímúwasa faútínkówasarai kurááye. ");
INSERT INTO auy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Faútínkówasarai kuyasá mindóꞌwáámbá Ísun-aaimo ísówi Póronte Sáírásinte tínkamofo sésa tiꞌmárówasarai Périya-naopaꞌa wémesarai kuyambá Yúndaa-waasiti ámáán-daumpaꞌa imésarai Ísun-aai simátímúyasa ");
INSERT INTO auy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","minkwáásísómbá ímba Tésáróníkaa-waasiyaamba ésa kaweꞌ-ímáyáá ésa Póron-aai kaweꞌ-úmai isésa aasiyaasi-kánáá Maníkón-aai aúfáífimba toráumai isésa sésa Póro éraira wési karorá síyó sésa aasiyaasi-kánáá Maníkón-aai aúfáífimba toráumai awánomba ");
INSERT INTO auy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yúndaa-waasi sáwífa Ísun-aaisafesa éraiꞌe sésa timankúnkúmba uwasá Kíríki-inimba túwíꞌo wéron-inimba sáwífa Ísun-aaisafesa timankúnkúmba uwasá Kíríki-waasi sáwífa Ísun-aaisafesa timankúnkúmba uwasá ");
INSERT INTO auy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Póro Périya-naopaꞌa Maníkón-aai simátímíyemo sun-ááí Yúndaa-waasi Tésáróníkaafaken-kwaasi isésa Périya-naopaꞌa tésa miwí tirumbá torésa suwasá isésa Póromba aaisambá aéésa tufuwónae suwasá ");
INSERT INTO auy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","minúwóíyáámbá Ísun-aaimo ísówi Pórontafesa tufúwófo sésa uwí-nómpáꞌá kumuwó suwaná kumúwasarainifo Sáírásiye Tímótiye mindáópaꞌa méroyasa ");
INSERT INTO auy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Póromba áíꞌmaesa kumémesa Áténisi-naopaꞌa múauwesa kunuwerésa miwítí naaópaꞌa iyésa Sáírásinte Tímótinte isimátimesa sésa minúwóíyáán-úmai kúmókaiyo Póro siyé isimátímakaawe. ");
INSERT INTO auy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Póro Áténisi-naopaꞌa kuména Sáírásinte Tímótinte wétimuꞌmarena awánómba mindáópaken-kwaasi sáwífaꞌa karoꞌ-máníkómbá úmakesa miwán-áwíꞌa mósá wémarowana Póro tuwánéna arunkó umbaí tówana ");
INSERT INTO auy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yúndaa-waasiti ámáán-daumpaꞌa iména Yúndaa-waasiye fíꞌonkaa-waasi Maníkón-ímáyáámó mósá márówiye isimátimena Maníkóní ásé-aai isimátimena aasiyaasi-kánáá mimbárúpáꞌó méron-kwaasi Maníkón-aai simátímaꞌmaena iyúwasa ");
INSERT INTO auy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Épíkúriyaan-aai ísámaesa kuwáíyé Sítóikin-aai ísámaesa kuwáíyé Pórompaꞌa tésa wesimán-kwesiman-esa tuwímbai sésa aaiséꞌo símae nín-kwaasi nóintafenawa síyó suwasá tuwímbai sésa fíꞌom-barafakem-banikontafena siyé sumbá Póro Ísun-aai séna pukáimpinkemba íyáfasinkaiye simátímakaintafesa minááí suwasá ");
INSERT INTO auy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Póromba áíꞌmaesa kawáá-wáásímó túwaandu ésamo tuwímbai-aaimo símaimo kaweꞌ-un-áémpáꞌá áwíꞌa Áríópagasi-aempaꞌa Póromba áíꞌmaesa máankesa sésa aú-aaimo simátimenda-aai simásímínata ísáano. ");
INSERT INTO auy_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kesáá minááísá isáúnda minááígó fíꞌoran-ifo anekaꞌá minááígóní áwáuma simásímínata ísáano sésa ");
INSERT INTO auy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Áténisi-naopaken-kwaasiye fíꞌom-barafaken-kwaasi mindáópaꞌo taméron-kwaasiye aasiyaasi-kánáá túwaandu ésa aú-aai aantemba wésewe. Mindásafesa minááígóní áwáuma simásímínata ísáano siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Suwaná Póro íyáfasinena Áríópagasifaꞌa túwaandu un-kwáásísáféna séna Áténisi-naopaken- kwaasi ísáaro. Monotáféꞌo fasiꞌámaimo méraawi éꞌa tuwánaraumne. ");
INSERT INTO auy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kentí naaópaꞌa wéneꞌa tuwánáúnaꞌa tuwímbai-tantaaꞌa úmakeꞌa miwán-áwíꞌo mósá wémaraamba tuwánaraumne. Óntan-taareraꞌa aúfái agaimaréna séna ímbo awánáúnda-manikontafeꞌa maanóntán-tááré úmakaumne agaimarénamo siyáimba úwaꞌa awánaraumne. Mimbáníkómbá ímbo awánaam-banikon-aai simátimune. ");
INSERT INTO auy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wemá wíyóne marawé mimpímbó wérain-tantaaꞌe úmarena seyaafá-tántáákáꞌá káráwiyena ímba waásimo úmakaan-daumpaꞌa méraiye. ");
INSERT INTO auy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Weyáá waásimo méraawini áwáugo éna tááma tiména seyaafáꞌ-wáásíyáꞌá káráwiyena wempímbá ímbo aawaimó taiwáí éna ímbo waási wembá áwaꞌnai owín-iye. ");
INSERT INTO auy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Maníkó aifaꞌá moórá-waasi úmakowasa wempínkémbá fíꞌo-fiꞌon-kwaasi sáwífaꞌa paápé urésa seyaafáꞌ-máráfáꞌá wété uráawe. Maníkó wení imáyáafinkemba seyaafáꞌ-márámá tuwín-timena seyaafáꞌ-wáásítí kanaamá makáiye. ");
INSERT INTO auy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kembá siyaafáí úmai suwánáíwae séna Maníkó miyá uráiye. Wemá ímba némpaꞌa méraifo ewaaꞌá méraimba póta awánánaumne. ");
INSERT INTO auy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Moóráwigo séna wemá méraisata póta kesáá méraumne siyáiye. Kempínkémbá moóráwigo agaimaréna séna éraiꞌa wení iyámpóísa úne agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Maníkóní iyámpóísa póta waásimo kentí imáyáafinkembo óntambo úmaken-tantaatafetaamo éta kesifowésá ímba sénaumne. ");
INSERT INTO auy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ááémo miwí mésamo sáwíꞌo umbá Maníkó miwísáféna ímba sáwífaꞌ-aai siyáifo káféꞌa seyaafáꞌ-máráfákén-kwáásísáféna séna sáwí-amba tuwéꞌa kempáꞌá teró Maníkó wésiye. ");
INSERT INTO auy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Wení imáyáafinkemba seyaafáꞌ-wáásí aaifimbó maitinkáínda-kanaa tíníye. Aaifimbó maisinkáínda-waasisa éꞌa íyáfasinankaraiye. Pukáimpinkemba íyáfasinankaraimba pósa éraiꞌa wemá aaifimbá maisinkáíníye sénááwe Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pukáimpinkemba íyáfasinankaraiye súmba isésa tuwímbai karaánááꞌa suwasá tuwímbai sésa moórá-kanaamo índa simásímínata ísáano suwaná ");
INSERT INTO auy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Póro tiyuwéna kóúwasa ");
INSERT INTO auy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","tuwímbai arááíwaꞌmaesa wésa wenáái isésa Ísun-aaisafesa timankúnkúmbo umbá miwífínkémbá moóráwigon-awiꞌa Táyónisiyasi Áríópagasi kánísórugo úwana moórá-ininkon-awiꞌa Támárisi-iyai minkáéꞌnáraise úmai tuwímbaifin-kwimái Ísun-aaisafesa timankúnkúmba uráawe. ");
INSERT INTO auy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Póro Áténisi-naopaꞌa simátimena tiyuwéna Kórinti-naopaꞌa komérowana ");
INSERT INTO auy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","moórá Yúndaa-waasigon-awiꞌa Ákwíra mérowana wembá anówa Póntási-marafaꞌa ména maꞌánkarowana ména óraaꞌa éna Ítáári-marafaꞌa Rómu-naopaꞌa koména awaainínkón-áwíꞌa Pírísiraae méroyana mimbáráfáꞌó káráwiyon-kawaagon-awiꞌa Kóróndíyasi Yúndaa-waasi aaisambá tíꞌmai Rómufakemba tiꞌmátuwowasa kuwasaráí Ákwíraae Pírísiraae Kórinti-naopaꞌa koméroyana Póro mindáraifaꞌa wéna ");
INSERT INTO auy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","wení moórá-kisau-waasifaꞌa póna mindáraise koména ampanta-námbá ésa óntamba wémaesa ");
INSERT INTO auy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Yúndaa-waasi ámáán-aaimo ísón-kanaa túntemba Póro Yúndaa-waasiti ámáán-daumpa iména Yúndaa-waasiye Kíríki-waasiye Ísun-aaisafesa éraiꞌe sésa wempáꞌá tíwae séna Ísun-aai simátímaꞌmaena iyáiye. ");
INSERT INTO auy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Simátimunkaꞌa Sáírásiye Tímótiye Máséndóniyaa-marafaꞌa tuwésarai Kórinti-naopaꞌa kúmúyana Póro aasiyaasi-kánáá kaweꞌ-ááí simátímaꞌmae wéiyena Yúndaa-waasisafena séna Maníkómó íyáfasinankaraiwaimba Yúndaa-waasisa amuꞌmaráúndawisa wemá Ísun-iye súwasa ");
INSERT INTO auy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","wenáái taraisésa sáwí-aai simánkówana wení unáánkwátóiyakemba kankambá fapifí éna séna Maníkó sáwíꞌo íyampinkembo kaweꞌ-ámpáꞌó ímbo métinkainda kentí áwáugo ínaꞌa sáwíꞌa ónááwe. Kemá ímba sáwíꞌa uwátinkaumpo keyááríkaꞌa sáwíꞌo ontáfé tiyuwéꞌa fíꞌonkaa-waasifaꞌa kosimátímaꞌmaeꞌa kónaumne Póro simátimena ");
INSERT INTO auy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","tiyuwéna moórá-waasigoni naaúmpaꞌa komérowana mindáúmpákén-kwáásígón-áwíꞌa Tísíyasi-Yásítasi wemá fíꞌonkaa-waasigo éna Maníkón-ímáyáá mósá marówi úwana wení naambá Yúndaa-waasiti ámáán-dankoni ewaaꞌá wérowana Póro mindáúmpáꞌá koména kaweꞌ-ááí kosimátímaꞌmaena iyúwana ");
INSERT INTO auy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","moóráwigon-awiꞌa Kírísipasi Yúndaa-waasiti ámáán-dankaꞌ-oraaꞌ-waasigo Fasiꞌaénkón-aaisafena amankúnkúmba úwasa wení akúnkwáráꞌá timankúnkúmba uwasá Kórinti-naopaken-kwaasi sáwífaꞌnanka Póron-aai isésa Fasiꞌaénkón-aaisafesa timankúnkúmba ésa nombá maiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Nombá máúwana moórá-noꞌwaamba Póro kaainkáámbá awánówana Fasiꞌaénkó séna ímba ááꞌa íno. Kemá eséꞌa méraumpo ímbo ifátúwénda kesáái úwoi simátímaꞌmae waaó. Mindáópakemba sáwífaꞌnanka kesáái isésa kesí waási-iꞌa íyamba pósa ímba sáwíꞌa uwánkanaawe Fasiꞌaénkó súwana ");
INSERT INTO auy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Póro mindáópa moórá-aatai úmai afaꞌmóráe-wiyomba ména Maníkón-aai simátímaꞌmaena iyáiye. ");
INSERT INTO auy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Simátimuwana ánaaemba Rómu-kamanigon-awiꞌa Káriyo Ákáyaa-marafaꞌo káráwiyonkaꞌa Yúndaa-waasi Póromba taꞌótoꞌmaesa Káriyompaꞌa wésa ");
INSERT INTO auy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","sésa maankwáásígó tuwímbai-aai simátimena Maníkómpáꞌó iyíyan-amba moórá-ankwaraꞌa wéaraatimiye. Minááígó kentáásí ámáámba wétaraisiye suwaná ");
INSERT INTO auy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Póro sénae súwana Káriyo Yúndaa-waasisafena séna minkwáásígó kámáni-waasi-taaimo sáwíꞌo énamo sáwí-kisaumo máínkakaa kentáái káféꞌa kaweꞌ-úmai isáúsina. ");
INSERT INTO auy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Énifo kentááiye kentúwíꞌe kentí ámáán-aantentafeꞌa tasísai ontáféꞌa ifátuweꞌa keyááríka minááí másimai kaweꞌán-oro. Kemá ímba miyán-ááí isánaumne séna ");
INSERT INTO auy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","aaimó sí-náúmpákémbá tiꞌmátuwowasa ");
INSERT INTO auy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","moóráwigon-awiꞌa Sósíténisi Yúndaa-waasiti ámáán-dankaꞌ-oraaꞌ-waasigomba taꞌótokesa aaimó ísón-dankoni ewaaꞌá tufúwana Káriyo mindásafena ímbo imáyáamo úmba ifátukaiye. ");
INSERT INTO auy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Póro Kórinti-naopaꞌa ayáátáákaꞌa Ísun-aaimo ísówiseꞌa ména tiyuwéna séna Pírísiraante Ákwíraanteꞌa tíꞌmaena Síriyaa-marafaꞌa kónae séna Sénkíriyaa-naopaꞌa kumbéna Maníkóntáféna éraiꞌ-aai séna aꞌnóntáu seyaafáꞌá kárásuwena mindárai tíꞌmaena nompín-táómba taꞌótoresa íyátesa wémesa ");
INSERT INTO auy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Éfésási-naopaꞌa mindómpín-táómpinkemba marapáꞌá kumésa Póro Pírísiraante Ákwíraante minká tiyuwéna Yúndaa-waasiti ámáán-daumpaꞌa iména aaí wesimán-kwesiman-uwasa ");
INSERT INTO auy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","miwí sésa ayáátáákaꞌa keséta mérainone suwaná aꞌáo kanaán-ifo méwaro ");
INSERT INTO auy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","séna Maníkómó ewé sénamo siꞌmaráínaꞌo éꞌa kouweránaumne séna nompín-táómba taꞌótorena íyátena Éfésási-naopaꞌa tuwéna wémena ");
INSERT INTO auy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sísááríyaa-naopaꞌa mindómpín-táómpinkemba marapáꞌá kunkéna Yérúsaremufaꞌa marapáꞌá iyéna Fasiꞌaénkóní waásisafena kaweꞌ-ááí simátimena Síriyaa-marafaꞌa Ántíoku-naopaꞌa koména ");
INSERT INTO auy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","tuwímbai-noꞌwaamba waitinkéna tiyuwéna Kárésíyaa-aempaꞌa Fírísiyaa-aempaꞌa naaóꞌ-naoꞌa wénena Ísun-aaimo ísówisafena simátímaꞌmaena iyúwasa fasiꞌámai méraawe. ");
INSERT INTO auy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Moórá Yúndaa-waasigon-awiꞌa Ápórósi wemá Árékísándiriyaafaken-kwaasi Éfésási-naopaꞌa taméraiye. Wemá Maníkón-aai kaweꞌ-úmai iséna aúfáífinken-aai kaweꞌ-úmai simátímaꞌmaena iyúwana ");
INSERT INTO auy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","moóráwigo Fasiꞌaénkóní aampaꞌó kun-ááí simámakowana aamoí éna óraaka simátimena Ísun-aai arupíse úmai simátímaꞌmae iyéna Yóni nombó maitinkón-aai aantemba iséna Ísuni waási nombó maitínkón-aai ímbo isómba ");
INSERT INTO auy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Éfésási-naopaꞌa taména Yúndaa-waasiti ámáán-daumpaꞌa óraaka simátimuwasarai Pírísiraae Ákwíraaeꞌa isésarai áíꞌmaesarai kentí naaúmpaꞌa máankesarai Maníkóní aampaꞌó kun-ááí seyaafáꞌ-ááí kaweꞌ-úmai simámakaaye. ");
INSERT INTO auy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Simámuyana Ápórósi iséna séna Ákáyaa-marafaꞌa kónae súwasa Éfésási-naopaken-kwaasi Ísun-aaimo ísówi áwaꞌnai ónaumne sésa aúfái agai-áménasa Ísun-aaimo ísááwi Ákáyaa-marafaꞌo méraawi mátímínasa kaweꞌá uwánkáaro suwaná mináúfáí maimaéna wémena kúmba Maníkó úwoi áwaꞌnai úwana Ísuni aampaꞌó kuwáí túwaꞌnai ena ");
INSERT INTO auy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","aforaꞌá Yúndaa-waasise aaí wesimán-kwesiman-ena Maníkón-aai aúfáífinken-aai simátimena séna Maníkómó íyáfasinankaraiwaimba wéamuꞌmaraundawisa wemá Ísun-iye súmba wenááigo miwí tááigomba íyáákowana miyáumai Ísuni aampaꞌó kuwáí túwaꞌnai uráiye. ");
INSERT INTO auy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ápórósi Kórinti-naopaꞌa mérowana Póro afufumpim-báráfáꞌá wémena Éfésási-naopaꞌo kúmba Ísuni aampaꞌó kun-kwáásí mérowana ");
INSERT INTO auy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Póro tuwánéna tísai ena séna Ísun-aaisafeꞌa timankúnkúmbo uráan-kanaa éra Maníkóní Ufaen-ámútánkó kentirumpimbá kumbéraiyo súwasa miwí sésa ímbaniye. Maníkóní Ufaen-ámútánkón-aaisa ínta ísaraumne suwaná ");
INSERT INTO auy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Póro séna nóran-aaiya wésesawa nombá maitínkaraao súwasa miwí sésa Yónimo simátímakain-aai simásimesasa nombá maisínkaraawe suwaná ");
INSERT INTO auy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Póro séna Yóni séna sáwí-imayaa tínaaemba uwásuweꞌa Maníkómpáꞌá teró súwasa miyá uwaná nombá maitinkéna séna moóráwigo kesínaaembo tíndawin-aaisafeꞌa timankúnkúmba oro Yóni siyáiye. Miwántáféna Ísuwe siyáiye Póro súwasa ");
INSERT INTO auy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","miwí isésa Fasiꞌaénkó Ísuntafesa ísámai nombá máúwana ");
INSERT INTO auy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Póro tineꞌá ayáámba taꞌótorowana Maníkóní Ufaen-ámútánkó miwífímbá óraaꞌa uwátinkowasa fíꞌo-fiꞌon-kwaasi-taaifinkemba sésa Maníkón-aai simátimesa ");
INSERT INTO auy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","sísamaifakemba kaeꞌá kumbaimái-waasi miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Miyá uwaná Póro miwíséꞌa ména kaumbo-wíyónkáꞌá Yúndaa-waasiti ámáán-daumpaꞌa iyéna Maníkó wení waásimo kawáánin-aai óraaka simátímaꞌmaena iyúwasa ");
INSERT INTO auy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","tuwímbai tiruntéꞌa marésa minááísáfésa ímba éraiꞌe sésa seyaafáꞌ-wáásí túrankaꞌa Fasiꞌaénkóní aantafésa símai sáwíꞌa uwaná Póro tiyuwéna Ísuni aampaꞌó kun-kwáásí tíꞌmaena moóráwigon-awiꞌa Tíránasi túwaandu un-dámbó úmakopaꞌa mótínkarena aasiyaasi-kánáá Fasiꞌaénkón-aai simátímaꞌmae iyéna ");
INSERT INTO auy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","kaeꞌ-áátáí maisuwówasa Yúndaa-waasiye fíꞌonkaa-waasiye Ésiyaa-marafaꞌo méron-kwaasi seyaafáꞌá Fasiꞌaénkón-aai ísaraawe. ");
INSERT INTO auy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Fasiꞌaénkón-aai ísówana Maníkó Póromba fasiꞌaémbá amúwana ímbo awáron-kisau fíꞌon-kisau maúwasa ");
INSERT INTO auy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","tuwímbai-waasisomba ampantasámbá Póron-aneꞌá toꞌmaésa miwítí waásimo tíꞌo úwai tineꞌá mátoꞌmarowasa asófowasa miwítí waási tirumpimbó sáwí-amutambo mérowi miyá máuwatinkowasa sáwí-amutamba kóuwasa ");
INSERT INTO auy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","tuwímbai-Yundaa-waasi wénesa waási tirumpinkémbá sáwí-amutamba maitíyuꞌmae wénesa sáwí-amutantafeta óraaka séta Ísun-awikaꞌo Póro sin-áwíkáꞌá kórosa súne suwaná ");
INSERT INTO auy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","moóráwigon-awiꞌa Sífa Yúndaa-amaan-kawaa-waasigon-áánintomba afakaeté mésa miyán-kísáú wémauwana ");
INSERT INTO auy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","sáwí-amutanko simátimena séna kemá Ísune Pórone wétuwanaumpo kemá nááwiyaꞌo súwana ");
INSERT INTO auy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","sáwí-amutanko arumpimbó méron-kwaasigo tínkamuwana naaemá kumúwana unáánkwátói tarátiyuwena mináfákáété-waasi íyáákena famétuwowasa unáánkwátói-iyaimba máápaꞌa kúmúwasa ");
INSERT INTO auy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yúndaa-waasiye fíꞌonkaa-waasiye seyaafáꞌá Éfésási-naopaken-kwaasi minááí isésa táátafesa ésa Fasiꞌaénkó Ísun-awiꞌa mósá makáawe. ");
INSERT INTO auy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Sáwífaꞌ-waasi méronkaꞌa Ísun-aaisafesa timankúnkúmbo uwáí tésa waási túrankaꞌa paápé ésa sésa sáwíꞌa uráumne sésa ");
INSERT INTO auy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","miwífínkémbá titambá ésa fintómó non-kwáásí miwítí aúfáí-wandaai tamaiyésa titambá ésa fintómó non-ááí wérontafesa tamaimái iyafímbá agaisuwésa mináúfáí-wándááímó méyánuraamba sáwífaꞌ-waasi tíyayaamba faikámai minóntámbá 50,000 kina tuwésa ");
INSERT INTO auy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","miyá óraa-fasiꞌaembo umbá pósa Fasiꞌaénkón-aai simátímaꞌmaesa kuwaná wété éna íyáákaraiye. ");
INSERT INTO auy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Miyá uwaná Póro séna Máséndóniyaa-marafaꞌe Ákáyaa-marafaꞌe wéneꞌa Fasiꞌaénkón-aai simátímaꞌmae nónaeꞌe séna minkákémbá Yérúsaremufaꞌa kuréꞌa Rómu-naopaꞌa kónaumne séna ");
INSERT INTO auy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tímótinte Érásítasinte áwaꞌnai íyan-kwaasiyai tiꞌmarówasarai Máséndóniyaa-marafaꞌa kuyaná Ésiyaa-marafaꞌa weyáá méraiye. ");
INSERT INTO auy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mérowasa minkánáá Éfésási-naopaken-kwaasi Fasiꞌaénkóní aampaꞌó kuwáísáfésa tirumbá sáwíꞌa uwátinkesa mindáópakemba óraakaꞌ-oraakaꞌa suwaná ");
INSERT INTO auy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","moóráwigon-awiꞌa Témítiriyasi minkwáásígó óntantamba úmakena miwítí karoꞌ-máníkóní káriꞌ-amaan-dane séna minkáróꞌ-mání-ínínkón-áwíꞌa Átémísiye sésa wení kísau-waasisomba úmakowasa sáwífaꞌ-waasi óntamba mátimesa minkáróꞌ-máníkóní naambá méyánuwana ");
INSERT INTO auy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Témítiriyasi mimbórá-kísáú wémaun-kwaasi táántowasa tatúwaandu uwaná simátimena séna kesáá óraaꞌ-ontamba minkísáúrákéntá wémaumne. ");
INSERT INTO auy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Énifo Póro séna waásimo úmáráámba karoꞌ-máníꞌá wéumaraawemo sin-ááí Ésiyaa-marafaꞌa Éfésási-naopaken-kwaasiye fíꞌo-fiꞌon-daopaken-kwaasiye isésa éraiꞌe wésewe. Kemá Póron-aai éꞌa ísaraawe. ");
INSERT INTO auy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Póron-aaigo kentáásí kísaumo sáwíꞌo índasafena wéiye. Ímba miyá aantembanifo Ésiyaa-marafaken-kwaasiye seyaafáꞌ-máráfákén-kwáásíyé kentáásí maníꞌ-ínínkón-áwíꞌa Átémísi mósá wémaraamba Póron-aaigo Átémísini ámáán-damba sáwísankaamba símai uwásukaimba póna wenáwíko kumíníye siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Súwasa minááí isésa tirunkó sáwíꞌa úwasa aaisambá sésa óraakaꞌ-oraakaꞌa sésa Éfésási-naopaken-kwaasi kentáásí Átémísin-awiꞌa óraaꞌa wéiye sésa ");
INSERT INTO auy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","aaemái suwasá mindáópaꞌa tésa óraakaꞌ-oraakaꞌa sésa Póroeꞌo núyan-kwaasi Máséndóniyaafaken-kwaasiyai moóráwigon-awiꞌa Káyási úwana moóráwigon-awiꞌa Árísítakasi mindárai tafisímaesa túwaandu urópaꞌa mátínkówana ");
INSERT INTO auy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Póro seyaafáꞌ-wáásímó túwaandu íyapaꞌa iyónae súwasa Ísuni aampaꞌó kuwáí ímba waaó sésa taꞌótórówasa ");
INSERT INTO auy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","mimbáráfákén-órááꞌ-wáásí tuwímbai Póroni waási pósa aaí tuwésa sáwífaꞌ-waasimo túwaandu íyapaꞌa ímba iyuwó Pórontafesa siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Suwasá túwaandu un-kwáásísómbá miwítí imáyáa aupiri ésa fíꞌo-fiꞌon-aai sésa tuwímbai sésa nóran-aaisafetaawa tatúwaandu uráumno-imayaa uwasá ");
INSERT INTO auy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yúndaa-waasi miwífínkémbá moóráwigon-awiꞌa Árékísandaamba túrankaꞌa máánkówasa tuwímbai óraaka sésa emá aaí siyó suwaná miwí táái taraisónae séna ayáámba mósá tuwówasa ");
INSERT INTO auy_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","awánomba Yúndaa-waasi úntafesa mimbórá-ááí ayáátáákaꞌa tafisímai óraaka sésa Éfésási- naopaken-kwaasi kentáásí Átémísin-awiꞌa óraaꞌa wéiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Óraaka suwaná mindáópaken-oraaꞌ-waasigo aúfáímo agaúwai tuwááwí éna séna Éfésási-waasisono. Seyaafáꞌnánkátá awánáúnda Átémísini ámáán-damba kawáánéta fíꞌonkaꞌmaꞌmai-ontambo wíyómpakemba marapáꞌó kunkáin-ontamba kawáánúne. ");
INSERT INTO auy_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Minááí ímba kanaaꞌá taraisónááfo seyaafá aseréꞌa ímba sáwíꞌan-oro. ");
INSERT INTO auy_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mindárai ámáán-daumpakemba ímba umémbá ésarai kentáásí maníꞌ-íníntáfésarai ímba símai sáwíꞌa urááyaꞌa úwoi tíꞌmaeꞌa maankáꞌá tiyáawe. ");
INSERT INTO auy_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Témítiriyasiye wení kísau-waasiye aaí simátinkanae sésamo ésa aaimó simátinkai-kanaa úwoi wéraiye. Óraaꞌ-waasi méraamba pósa aaí símai kaweꞌá uwátinkanaawe. ");
INSERT INTO auy_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Énifo kembiwímó fíꞌon-aaimo wérainaꞌo éꞌa seyaafáꞌ-wáásímó túwaandu ompímbá símai kaweꞌá uwásuwanaawe. ");
INSERT INTO auy_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kesáámó aaifintáámó méraandasa káféꞌo tíyáananasaamo Rómu-kamani-waasi tésamo tasísai ésasaamo nóin-aaiyakena tiyááomo síyata kesáámó senda-ááísá ímba wéraiye. ");
INSERT INTO auy_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Aúfáímo agaún-kwaasigo simátimena túwaandu urón-kwaasi tiꞌmátuwowasa kóuraawe. ");
INSERT INTO auy_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Miwí táái taiꞌówana Póro Ísuni aampaꞌó kun-kwáásí táántowasa tuwaná miwítí imáyáa símai kaweꞌá uwátinkena séna Ísun-aai aantemba maimái tirumpimbá máráaro séna énifo méwaro séna tiyuwéna Máséndóniyaa-marafaꞌa wémena ");
INSERT INTO auy_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","mifáꞌá naaóꞌ-naoꞌa wénena Ísuni aampaꞌó kun-kwáásísáféna áfááraumai simátímaꞌmaena núwasa tirunkó kaweꞌá úwana tiyuwéna Kíríki-marafaꞌa wémena ");
INSERT INTO auy_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","koména kaumbo-wíyómbá maisuwéna nompín-táómpimba Síriyaa-marafaꞌa kónae séna úwasa Yúndaa-waasi wembó tufuwónae sumbá iséna ifátuwena Máséndóniyaa-marafaꞌa marapáꞌá kónaumne súwasa ");
INSERT INTO auy_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","maaráumai-waasi moóráwigo Périya-naopakewi Pírasin-ááninkon-awiꞌa Sópata úwana Tésáróníkaa-naopakendarai túwíꞌa Árísítakasiye Sékandasiye uyaná Tépi-naopakewin-awiꞌa Káyási úwana Ésiyaa-marafakendarai túwíꞌa Tíkíkaasiye Tárófímasiye uyaná Tímóti úwasa úmai Póroeꞌa wésa ");
INSERT INTO auy_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","aifaꞌá Tóróasi-naopaꞌa komésa kentáásimuꞌa makówata ");
INSERT INTO auy_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yúndaa-waasimo ímbo intóráín-tantaaꞌwara-peretimo agáún-kanaamo taiꞌónkaꞌa Fírípái-naopakemba nompín-táómba taꞌótoreta íyáteta wémeta séfataase-noꞌwaamba mindómpín-táómpimba kówaeta Tóróasi-naopaꞌa marapá kúwateta aifaꞌó komésamo kentáásimuꞌo makón-kwaasiseta kométa moórá-sondaasa maiyáumne. ");
INSERT INTO auy_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sondaaráꞌá Ísuntafeta ísámai tómbá néta aráá-tombo naandasáféta túwaandu uráawananasa Póro aafáyáa kónae séna simátímaꞌmaena nóꞌwaan-afufuntambo iyúmba ");
INSERT INTO auy_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","afófumayaatanaan-daumpaꞌa méta sáwífaꞌ-omba kúraꞌmaketa méraawananasa ");
INSERT INTO auy_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","moórá-ifokon-awiꞌa Yútíkási naan-afaapimbá imérowana Póro Ísun-aai simátímaꞌmae wéiyuwana Yútíkásimba aúgáfaaꞌa úwana aún-kwéna meminkákémbá tanaa féna marapáꞌá kuntufamúwasa kunkésa awánomba puwúwasa uwaná ");
INSERT INTO auy_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Póro kuména kunkífaena tapéna awánéna séna ímba imáyáan-oro. Pukéna aúnaraiye simátimena ");
INSERT INTO auy_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","mindáúmpáꞌá iyéna Ísuntafena ísámai tómbá tafámbai timúwasa nowaná Póro simátímaꞌmae wéiyuwana siyarówana tiyuwéna kúwasa ");
INSERT INTO auy_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","puwúwanamo íyáfasinankon-kwaasigomba áíꞌmaesa wení naaúmpaꞌa máankesa tirunkó kaweꞌá uráiye. ");
INSERT INTO auy_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Úwana Póro simásimenasa séna kembiwí nompín-táómpimba Ásosi-naopaꞌa wéwiyaꞌa kemá marapáꞌá wémeꞌa Ásosi-naopakemba nompín-táómba taꞌótoreꞌa íyáteꞌa konó súwata aifaꞌá kunkéta nompín-táómba taꞌótoreta íyáteta wémeta Ásosi-naopaꞌa kówánanasa ");
INSERT INTO auy_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Póro marapáꞌá wémena Ásosi-naopaꞌa kuréna nompín-táómba taꞌótorowata kóaiꞌmaeta wémeta Mítíríni-naopaꞌa kówaeta ");
INSERT INTO auy_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","siyarówata wémeta Káyosi-marafaꞌa kóyáákaawananasa fenówata kówaeta aafáyáarata wémeta Sémósi-marafaꞌa kóyáákaawananasa fenówata kówaeta aafáyáaraꞌa wémeta Máíritasi-naopaꞌa kówánanasa ");
INSERT INTO auy_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","tómbá fákáꞌmai Maníkóntáfésa ísámai kaundánae sésamo túwaandu un-kánáá ampáánkáꞌá tíne úwana Póro séna minúwóíyáámbá Yérúsaremu-naopaꞌa kuréꞌa mintánómbá komandánae séna nompín-táómpimba Éfésási-naopaꞌa kóyáákanaumpo Ésiyaa-marafaꞌa ímba ayáátáákaꞌa ménaumne súwata Máíritasi-naopata kuráumne. ");
INSERT INTO auy_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Máíritasi-naopata kówánanasa Póro moóráwigomba aiꞌmarówana Éfésási-naopaꞌa wémena Fasiꞌaénkóní waásiti óraaꞌ-waasi kosimátimena séna Póro wétaantaifo teró siyáiye súwasa ");
INSERT INTO auy_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","tuwaná simátimena séna kesáái ísáaro. Kesí aifa-kánáá Ésiyaa-marafaꞌa keséꞌa koméꞌa kemó ówánda suwánaraawe. ");
INSERT INTO auy_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yúndaa-waasi sínkamiyanesa suwaná sirunkó umbaí tówaꞌa ímba imáyáa éꞌa Fasiꞌaénkóní kísau-waasigo úne séꞌa wenaísamaifimba méꞌa wení kísau maiyáumne. ");
INSERT INTO auy_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ímba aúpáꞌá tuwéꞌa seyaafáꞌ-ááí úwoi simátimeꞌa kembó túwaꞌnai í-ááí túwaandu umpíné kentí naaúmpaꞌe simátímaꞌmaeꞌo iyáunda éꞌa ísaraawe. ");
INSERT INTO auy_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yúndaa-waasiye fíꞌonkaa-waasiye áfááraumai simátime séꞌa sáwí-imayaa tuwéꞌa Maníkómpáꞌá téꞌa Fasiꞌaénkó Ísun-aaisafeꞌa timankúnkúmba oro simátímaꞌmaeꞌa iyáumne. ");
INSERT INTO auy_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Énifo Maníkóní Ufaen-ámútánkó Yérúsaremufaꞌa waaó simásímakaimba póꞌa miyá ónaumne. Kesineꞌó paápé índasafeꞌa ímbo isáúnda úwoi kúne. ");
INSERT INTO auy_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Seyaafáꞌ-náópaꞌo kúnda Maníkóní Ufaen-ámútánkó óraaka simásimena séna umbai-tántááꞌá uwánkesa ándáfaꞌa máankanaawemo simásímímba mindá aantemba ísaraumne. ");
INSERT INTO auy_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sínkamiyaꞌo púwóndaraꞌa ímba káráwiyaumpo Fasiꞌaénkó Ísumo símakain-kisau maimái taíꞌásuwanaumne. Maníkó úwoi súwaꞌnai in-ááí ásé-aai simátímaꞌmaeꞌo iyúnda-kisau maimái taíꞌásuwanaumne. ");
INSERT INTO auy_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Minkísáúmó maiyáunda kembiwífímbá wéneꞌa Maníkó wení waásimo kawáánin-aai simátímakaumpo ánaaembo éꞌa kembó ímbo suwánáíyamba ken-ísaraumne. ");
INSERT INTO auy_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Ímbo inkaisówánda Maníkón-aai seyaafáꞌ-ááí simátímakaunda pósa kembíwífínkémbó tuwímbaimo kesááimo ímbo isésamo Maníkómpáꞌó ímbo tésamo ombá ímba kesí áwáugon-ifo kentí áwáugo ínaꞌa miyá íyantafeꞌa minááí káféꞌa óraaka simátimune. ");
INSERT INTO auy_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Maníkó ááninkomba aiꞌmarówana kuména kumpuwéna wení naaesámbó méyánuwasukaimba Fasiꞌaénkóní waásin-ofo káráwiyoro. Maníkóní Ufaen-ámútánkó kembá íyáfasintinkaraifo kentúwawaaꞌwara Fasiꞌaénkóní waásiyaꞌwaraꞌa kaweꞌ-úmai káráwiyoro. Sipisípiyaꞌo káráwiyonten-úmai káráwiyoro. ");
INSERT INTO auy_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Áwáífiyaamo índa-iyamba téna sipisípi tafámaimo wáráíntemba kemá kónasa waási tésa tasáwíꞌa ónááwe. ");
INSERT INTO auy_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Moórá-kanaa tínasa kembiwífínkémbá tuwímbai íyáfasinesa Ísuni aampaꞌó kon-kwáásítí imáyáa tafisénae sésa karoꞌ-ááí síyasa tuwímbai éraiꞌe sésa arááíwaenaawe. ");
INSERT INTO auy_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mindásafeꞌa káráwimai kaweꞌán-oro. Kaumbo-áátáí keséꞌa méreꞌa moórá-mora sirumbá uwátinkeꞌa aafáyáaraꞌe fenómpinkaꞌe nóꞌwaane aasiyaasí simátínkáfaꞌa iyáumne. Minááísáféꞌa imáyáa úmai kaweꞌán-oro. ");
INSERT INTO auy_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Kaweꞌá íyana Maníkó káráwitinkamae iyínaꞌa méraaro. Wenááigo fasiꞌátinkainiye. Wení waásimo kaweꞌó uwátínkáíntemba kembiwíwáráꞌá kaweꞌá uwátinkainiye. ");
INSERT INTO auy_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Óntantafeꞌe unáánkwátóisafeꞌe fíꞌowiti moparáwíntáféꞌe ímba súraniyamba úne. ");
INSERT INTO auy_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kísau wémaeꞌa minóntántámbá ímbo makáunda-tantaaꞌa méwémaeꞌa kembó súwaꞌnai on-kwáásítí tóné unáánkwátóiye maitiméꞌa úne. Miyámó ówánda éꞌa suwánaraawe. ");
INSERT INTO auy_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Fasiꞌaén-kísáúmó maéwánda suwánaraafo miyá éꞌa aamoisaén-kwáásí túwaꞌnai ónááwe. Fasiꞌaénkó Ísumo siyáin-aai imáyáan-oro. Wemá séna wémaewi tirunkó kaweꞌá imbánifo tímatuwaawi tirunkó kawetéꞌa wéiye Ísu siyáin-aai Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Póro simásuwena kífaena minórááꞌ-wáásíyé Fasiꞌaénkómpáꞌá inaí simásuwowasa ");
INSERT INTO auy_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","seyaafáꞌ-wáásí áfááran-ifiꞌa tésa Póromba tataparésa aaweyáá uwánkesa uwaná ");
INSERT INTO auy_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Póro séna ánaaembo éꞌa ímba suwánánááwe sún-aaisafena tirunkó umbaí tówasa nompín-táómpimba múaukaawe. ");
INSERT INTO auy_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Múauwowata minkwáásísáféta méwaro séta tiyuwéta nompín-táómpimba íyáteta arupíse úmaisa wémeta Kósi-naopaꞌa kóyááketa wémeta kówaeta aafáyáaraꞌa Rósi-naopaꞌa kóyááketa wémeta Pátaraa-naopaꞌa kuréta marapáꞌá kuméta ");
INSERT INTO auy_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","awánááwándasa Fínísiyaa-marafaꞌo wínda-nompin-taomba wérowata mimpímbá íyáteta wémeta ");
INSERT INTO auy_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sáíparasi-marama siyáánaepaꞌa wérowata kóyááketa wémeta Síriyaa-marafaꞌo kówándasa Táyaa-naopaꞌa moparáwímbá mówétuwowata marapáꞌá kumówánasasa ");
INSERT INTO auy_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ísuni aampaꞌó kuwáí mérowata tuwánéta moórá-sondaa miwíséꞌa méraawanasasa sésa Maníkóní ámútanko simátímakain-aai Póromba simámesa sésa tufúwófo Yérúsaremufaꞌa ímba waaó simámaꞌmae íyúwata ");
INSERT INTO auy_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","miwíséꞌo méraawanda-kanaa taiꞌówata mindáópaꞌa tuwéta kówánasasa minkwáásísómbá miwítí aare-iyámpóíseꞌa síꞌmaesasa naaópaꞌa tuwésa uwí-nómpáꞌá kúmúwata kífaeta Maníkómpáꞌá inaí simásuweta ówánasasa ");
INSERT INTO auy_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","kentáásáfésa énifo koró suwatá miwísáféta énifo méwataao simásuweta nompín-táómpimba íyátaawanasasa miwí kunuwerésa miwítí naaópaꞌa iyáawe. ");
INSERT INTO auy_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Miwítí naaópaꞌa íyúwata nompín-táómpimba Táyaa-naopata tuwéta Tórémesi-naopata marapáꞌó kondasáféta Ísun-aaimo ísówi tuwánéta siyáánta timéta moórá-noꞌwaamba miwíséꞌa waéta ");
INSERT INTO auy_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","íyáfasineta marapáꞌá wémeta Sísááríyaa-naopaꞌo kówándasa ááéma aantá-waasi afakaeté-waasi Ísuni kísaumo tímakowifinkemba moóráwigon-awiꞌa Fírípini naaúmpata iméraawananasa wemá Ísun-aaimo simátimuwai mérowasa ");
INSERT INTO auy_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","éíyain-ayaamumba mésa ímba waaí maiyésa úwoi mésa Maníkón-aai wésimatimesa tifowáeꞌa mérowata ");
INSERT INTO auy_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","tuwímbai-noꞌwaamba mindáúmpátá waéwánanasa moóráwigo Maníkón-aaimo simátimuwain-awiꞌa Ákápáasi Yúndiyaa-marafakemba ");
INSERT INTO auy_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","kuména Póroni áꞌwáánkau kumbaiyéna wení aíyayaankaꞌa káráꞌumai aiyowáíꞌa úmai aráánamena séna Maníkóní Ufaen-ámútánkó séna maanáꞌwáánkáúgóní afowámó Yérúsaremufaꞌo iyínasamo ésa Yúndaa-waasi taꞌótoꞌmai miyáumai káráꞌuwankesa áíꞌmaesa fíꞌonkaa-waasi mátimenaawe Maníkóní Ufaen-ámútánkó siyáiye Ákápáasi kusúwata ");
INSERT INTO auy_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","iséta kesétaamo méron-kwaasiseꞌa Pórontafeta séta Yérúsaremufaꞌa ímba iyuwó óraaka séwánanasa ");
INSERT INTO auy_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Póro séna nóintafera ifiꞌá téra kaeꞌ-ímáyáá uwásínkááwanawa kesirunkó umbaí wétaiyo. Yérúsaremufaꞌo íyónasamo kembó taꞌótoraiyamba ímba sááꞌa wéiye. Fasiꞌaénkó Ísun-aai simátimudasafesamo sínkamonaesamo ésa úwoi sínkamonaawe Póro súwata ");
INSERT INTO auy_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","wenááisa ímba kanaasá taraisónaumne séta ifátuweta séta Fasiꞌaénkóní imáyáaraꞌa miyá ónááwe siyáumne. ");
INSERT INTO auy_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Miyá simásuweta tuwímbai-noꞌwaamba miwíséta waéta kentáásí moparáwímbá toꞌmayaa úmaeta mindáópaꞌa tuwéta Yérúsaremufaꞌa iyówánasasa ");
INSERT INTO auy_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sísááríyaafaken-kwaasi Ísuni aampaꞌó kuwáí tuwímbai keséta Yérúsaremufaꞌa iyésa moóráwigon-awiꞌa Nésonini naaúmpata mósinkowana minkwáásígó Sáíparasi-marafaken-kwaasigo ayáátáákaꞌa Ísuni aampaꞌó kúwai séna kesí naaúmpaꞌa méranaawe súwasa wení naaúmpata mósinkaraawe. ");
INSERT INTO auy_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mósinkesasa kentí naaópaꞌa kúmúwata Yérúsaremufaꞌa méraawanasasa Ísun-aaimo ísówi aamoí umpínkémbá siyówata ");
INSERT INTO auy_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","iwaéwándasa aafáyáaraꞌa Fasiꞌaénkóní waásiti óraaꞌ-waasi Yémísi túwaandu uwátinkowasa méropata Póro síꞌmae kúwata koméraawananasa ");
INSERT INTO auy_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Póro ayáámba tímaꞌmai aaweyáá éna séna Maníkó ámakain-kisaumo fíꞌonkaa-waasifimbo maiyáin-aai seyaafáꞌ-ááí simátimuwasa ");
INSERT INTO auy_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","isésa Maníkón-áwíꞌa mósá marésa Fasiꞌaénkóntáfésa sésa kesí waásiyo. Sáwífaꞌ-waasi Yúndaa-waasi Ísun-aaisafesa timankúnkúmba ésa Móseseni ámáámba ímba tuwésa fasiꞌámai isésamo méraamba éꞌa ísaraane. ");
INSERT INTO auy_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tuwímbai miwísáfésa sésa Póro fíꞌonkaa-waasiti naaóꞌ-naoꞌa wénena Yúndaa-waasi mindáópakaꞌo méraan-kwaasi simátimena séna Móseseni ámáámba ifátuweꞌa kentí iyámpói túma ímba kárámai araénáémba uwátinkeꞌa Yúndaa-waasiti aambá ímba arááíwáéro Póro wésiye sewasá isésa ");
INSERT INTO auy_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","emó tiyáanda-aai isésa aaisambá wésefo ");
INSERT INTO auy_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","simáméndantenta uwo. Maankáꞌá éíyain-kwaasi mésa Maníkómpáꞌá éraiꞌ-aai símakaamba po ");
INSERT INTO auy_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ewáráꞌá miyán-uwo. Yúndaa-waasiti ámáámba ísámai kaweꞌó í-tántááꞌá e minéíyáín-kwáásítí póíꞌo méyánuwatiyuwe ámáán-kawaa-waasi timé miwíséꞌa aꞌnóntáu kárásuwenasa awánésa Yúndaa-waasi Ísun-aaisafesa timankúnkúmbo owí sésa emá Móseseni ámáámba isé méraanasa entáfésa karoꞌ-ááí simánkaraawe seró. ");
INSERT INTO auy_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Énifo fíꞌonkaa-waasi Ísun-aaisafesa timankúnkúmbo uráawisafeta ááéma moórá-aai séta agaimaréta séta karoꞌ-máníkóntáfésa imáyáa ésa póíꞌo uwándaamba mimpóí ímba naaró. Naaemá ímba naaró. Póímo tufúꞌnewana wení naaemá ímbo kumínda úwoimo wérainaꞌa mimpóí ímba naaró. Aare-úméné waai-úméné ímba oró. Ááéma minááí agaimaréta tukáumne suwaná Póro iséna ");
INSERT INTO auy_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","aafáyáaraꞌa minkwáásí tíꞌmaena Yúndaa-waasiti ámáámba ísámai kaweꞌó í-tántááꞌá uwásuwena Póro óraaꞌ-amaan-daumpaꞌa iyéna ámáán-kawaa-waasisafena séna afakaeté-noꞌwaamba maisuwéta Yúndaa-waasiti ámáámba ísámai kaweꞌó í-tántááꞌá úmai taíꞌásuweta moórá-mora-waasi póíꞌa úmaeta Maníkómpáꞌá máamenaumne simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Simátimena mérowana mináfákáété-noꞌwaamba taiꞌówana Póro óraaꞌ-amaan-daumpaꞌo iméromba tuwímbai Yúndaa-waasi Ésiyaa-marafakewi iawánésa Pórontafesa sáwí-aai simánkesa tufuwíyan-imayaa ésa taꞌótokesa óraaka sésa ");
INSERT INTO auy_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ísareri-waasi súwaꞌnai oro. Maankwáásígó naaóꞌ-naoꞌa wénena Ísareri-waasisafena sáwí-aai simátinkena Móseseni ámáámba símai sáwíꞌa uwánkena maanórááꞌ-ámáán-dámbá símai sáwíꞌa wéiye. Káféꞌa fíꞌonkaa-waasi tíꞌmaena maanórááꞌ-ámáán-dáúmpáꞌá Yúndaa-waasi aantembo íyón-daumpaꞌa mótinkaisana póna maankáwéꞌ-námbá sáwíꞌa wéiye sumbá ");
INSERT INTO auy_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Éfésási-naopaken-kwaasigon-awiꞌa Tárófímasi Póroeꞌa Yérúsaremufaꞌa núwasa awánonkaꞌa pósa imáyáa ésa Póro áíꞌmaena óraaꞌ-amaan-daumpaꞌa móankaraiye-imayaa karoꞌ-ímáyáá ésa mindásafesa minááí siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Minááí óraaka simátimuwasa mindáópaken-kwaasi mimbóráfímbá tawiyésa Póromba tataꞌótoꞌmai ámáán-daumpakemba tafisímaesa mááꞌarifaꞌa múra auwésa ámáán-dankoni ontá wimarésa ");
INSERT INTO auy_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","sáwífaꞌ-waasi Póromba tufúꞌnaafuꞌ-uwaná moóráwigo Rómu-i-waasiti óraakomba isimámena séna Yérúsaremufaꞌa seyaafáꞌ-wáásí wétiyaawe súwana ");
INSERT INTO auy_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","minúwóíyáán-úmai i-wáásíyé miwítí kawáá-wáásíyé tíꞌmaena awaantanténa kuména waási túwaandu urómpimba tafákáraaꞌa úmaena kumúwasa i-wáásíyé miwítí óraakone tuwánésa tufuwémómba úwoi mérowana ");
INSERT INTO auy_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","óraako Póromba tataꞌótorena i-wáásísáféna séna kaeꞌ-ándásámbá káráꞌoro simásuwena tísai ena séna maankwáásí nááwaꞌiyo. We nóra uráiyo súwasa ");
INSERT INTO auy_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","tuwímbai fíꞌo-fiꞌon-aaisafesa suwasá tuwímbai miyá suwasá uwaná óraako minááígóní áwáu ímba iséna i-wáásísáféna séna miwámbá áíꞌmaeꞌa i-wáásítí naaúmpaꞌa íyóro súwasa ");
INSERT INTO auy_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","áíꞌmaesa ontafín-káráákáꞌó íyúmba tufuwónaesa untáfésa i-wáásí tiyáánkaꞌa farámbaesa íyúwasa ");
INSERT INTO auy_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tínaaemba tirááíwaꞌmae iyésa tufuwíyana puwíno símaesa óraakaꞌa iyáawe. ");
INSERT INTO auy_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","I-wáásí Póromba áíꞌmaesa miwítí naaúmpaꞌa iyónae suwaná Póro miwítí óraakomba simámena séna moórá-aai simámenae súwana óraako séna Kíríki-waasi-taaifinkemba wésempo ");
INSERT INTO auy_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","emá ímba Ísípi-marafaken-kwaasi óne. Minkwáásígó Rómu-kamani-waasisafena aaisambá tiyéna sáwífaꞌ-waasi 4,000 waasi símai tíꞌmaena tiyáí-tántááꞌá maimaésa máásai-marafaꞌo kuráamba ímba wemá óne súwana ");
INSERT INTO auy_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Póro séna Yúndaa-waasi úne. Kesinó kembá Sírísiyaa-marafaꞌa Táásási-naopaꞌa óraaꞌ-naopaꞌa masínkaraiye simásuwena séna moórá-aai simátimenae súwana ");
INSERT INTO auy_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","óraako séna énifo miyán-uwo súwana Póro ontará-káráákáꞌá ména aseráíyantafena ayáámba mósá tuwéna séna kemó senda-ááí ísáaro súwasa asérówana Yúndaa-waasi-taaifinkemba Ípúru-taaifinkemba simátímakaiye. ");
INSERT INTO auy_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Póro simátimena séna kesífárawaisai kesifoísáíyo maanááímó simásínkáámba anondáá sénaumpo ísáaro séna ");
INSERT INTO auy_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ípúru-taaifinkemba súwasa miwí tááifinken-aai pósa isésa asékésa wenáái kaweꞌ-úmai ísówana Póro séna ");
INSERT INTO auy_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","kemá Yúndaa-waasi úne. Kesinó Sírísiyaa-marafaꞌa Táásási-naopaꞌa masinkówaꞌa óraaꞌa éꞌa Yérúsaremufaꞌa Kámérierimo úpaꞌa taméraawanana kentáá síwáꞌnáti ámáámba fasiꞌámai simásímaꞌmaena iyáiye. Maankáꞌó méraan-kwaasimo Maníkóntáfésamo fasiꞌámai méraantemba Maníkón-aai fasiꞌámai métaꞌotokaumne. ");
INSERT INTO auy_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ísuni aampaꞌó kun-kwáásí sáwíꞌa uwátinkeꞌa tafisímaeꞌa ándáfaꞌa aare-waaí mátínkaraumne. ");
INSERT INTO auy_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ááéma aifaꞌ-ámáán-káwáágówé ámáán-oraaꞌ-waasiye aúfái simésa Támásikasi-naopaꞌa Yúndaa-waasi maimaé mátimuwo suwaꞌá Ísuni aampaꞌó kun-kwáásí kotíꞌmaeꞌa Yérúsaremufa ándáfaꞌa mátinkanae séꞌa Támásikasi-naopaꞌa kuráumne. Ááémo mináúfáímó símakaan-kwaasi kotísai eꞌo éꞌa kentáfésa éraiꞌa siyé seró. ");
INSERT INTO auy_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Énifo aampaꞌá wémeꞌa Támásikasi-naopaꞌa ewaaꞌá kówánana wááwái wíyómpakemba sáma aafáyáuraan-tantaaꞌa tuwówana kuména súgáyáagaya úwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","marapáꞌá tanaa fááwánana aaigó aantemba isááwánana sáántena séna Sóroo nóra séwa kembá sáwíꞌa ónó súwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","emá nááwa sénó séwánana kemá Násaretifakewi Ísu únama sáwíꞌa wéuwasinkaane súwasa ");
INSERT INTO auy_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","keséꞌo méron-kwaasi sáma awánésa simásimun-aai ímba kaweꞌ-úmai ísówaꞌa ");
INSERT INTO auy_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","áísai eꞌa séꞌa Fasiꞌaénkóo kemá nóra ónaumno séwánana Fasiꞌaénkó séna íyáfasine Támásikasi-naopaꞌa winaná moóráwigo Maníkómó embó ámakain-kisau-aai simámino súwana ");
INSERT INTO auy_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ságo súgáyáagaya úwaꞌa ímba awánááwánasa keséꞌo nún-kwaasi siyáán-toꞌmaesa Támásikasi-naopaꞌa kuráawe. ");
INSERT INTO auy_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kuwaná moóráwigon-awiꞌa Ánánáyasi Maníkón-aaisafena fasiꞌámai ména kentáásí ámáámba isówasa Yúndaa-waasi Támásikasi-naopakewi wenáwíꞌo mósá márówi ");
INSERT INTO auy_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","kempáꞌá téna ewaaꞌá taména séna Sóroo kesí waásiyo. Anekaꞌá kaweꞌ-úmai aúramba awánáínone súwaꞌa minúwóíyáámbá súramba awánamai kaweꞌá ówánana ");
INSERT INTO auy_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","séna kentáá síwáꞌnási Fasiꞌaénkó embó íyáfasinankaintafe wení imáyáa arááíwáínone. Wení kawe-kísáú-wáásí awáné wenáái iséma ónda po wenáái arááíwáínone. ");
INSERT INTO auy_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Awánáánda-tantaaꞌe isáándawe seyaafáꞌ-wáásí simátímaꞌmae nínone. ");
INSERT INTO auy_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ímba úwoimo máínda íyáfasine Fasiꞌaénkó Ísumba áántenana ení sáwí-imayaa maiyauwáína Ísuntafe ísámai nombá mauwó Ánánáyasi simásimuwaꞌa miyá uráumne. ");
INSERT INTO auy_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Miyá éꞌa kouweréꞌa Yérúsaremufa taméꞌa óraaꞌ-amaan-daumpaꞌa Maníkómpáꞌá inaí wéseꞌa kaainkáámbá awánááwánana ");
INSERT INTO auy_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Fasiꞌaénkó simásimena séna Yérúsaremufaꞌo méraan-kwaasi kesáái simátímínasa ímba kaweꞌ-úmai isánááfo minúwóíyáámbá íyáfasine maankáꞌá tuwaaó Fasiꞌaénkó súwaꞌa ");
INSERT INTO auy_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Fasiꞌaénkóo ámáán-daumpimpaꞌa wéneꞌa enááisafesa timankúnkúmbo on-kwáásí taꞌótoꞌmai tínkambai tafisímaeꞌa ándáfaꞌo mátíyukaunda éꞌa suwánaraawe. ");
INSERT INTO auy_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sítífeni enááimo simátímakaiwaimba tufúnkaꞌa kemá méꞌa sirunkó kaweꞌá úwaꞌa tufún-kwaasiti paákákén-únánkwátóiyaꞌa káráwiyaawanasa tufúwana pukáiye séwánana ");
INSERT INTO auy_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Fasiꞌaénkó séna aiꞌmáráana íyáfasine némpaꞌa fíꞌonkaa-waasi kesáái simátímaꞌmae núwo Fasiꞌaénkó siyáiye Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Póro súwasa ánaaembo sún-aaisafesa aaisambá sésa óraakaꞌ-oraakaꞌa sésa tufuwíyana puwíno. Miyán-kwáásí ímba maambáráfáꞌá mérainiye ");
INSERT INTO auy_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","óraakaꞌ-oraakaꞌa sésa miwítí unáánkwátói faúkésa oférófé ésa ofaí káúresa óipaꞌa tuwésa uwaná ");
INSERT INTO auy_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Rómu-oraako i-wáásísáféna séna áíꞌmaeꞌa kentí naaúmpaꞌa íyóro súwasa miyá uwaná séna Póromba áwiyonkuꞌ-newana Yúndaa-waasi-taaigoni áwáu sínata ísáano súwasa ");
INSERT INTO auy_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Póromba ándásamba káráꞌuwankesa áwiyonkuꞌ-nánae sésa uwaná i-wáásítí kawáágó mérowana Póro wentáféna séna kemá Rómu-waasiti aúfáí-wandaai tokáundawi úmpo ímbo sísai ombá aaifimbó maisinkésamo súwiyonkuꞌ-nánae-imayaamo ombá ámáámba taraisésa uwófíꞌa ónááfo ímba úwoi súwiyonkuꞌ-nánááwe Póro súwana ");
INSERT INTO auy_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","iséna wení óraakomba kosimámena séna minkwáásígó Rómu-waasiti aúfáí-wandaai tokáiwaimban-ifo nóra ónaumno súwana ");
INSERT INTO auy_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","óraako iséna Pórompaꞌa téna séna Rómu-waasiti aúfáí-wandaai tokáano súwana ewé súwana ");
INSERT INTO auy_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","óraako séna kemá óraaꞌ-ontamba tuwéꞌa mináúfáí-wándááí maimái tokáumne súwana Póro séna kesifo tokáimba póꞌa kewáráꞌá úwoi tokáumne súwasa ");
INSERT INTO auy_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","áwiyonkuꞌ-nánaemo sun-kwáásí minááí isésa némpaꞌa kuwaná óraakowaraꞌa áátafena éna séna Rómu-waasiti aúfáí-wandaai tokáiwaimbo káráꞌumankaunda sáwíꞌa úne séna áátafena uráiye. ");
INSERT INTO auy_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Áátafena éna aafáyáaraꞌa óraako séna Yúndaa-waasi Pórombo simánkáán-aaigoni áwáu síyaꞌa isánae séna óraaꞌ-amaan-kisau-waasiye ámáán-oraaꞌ-waasisafena séna túwaandu oro séna i-wáásísáféna Póro ayáámpinken-anda faútúwáaro súwasa faútúwówana áíꞌmaena túwaandu urónkaꞌa máánkaraiye. ");
INSERT INTO auy_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Máankowana Póro ámáán-oraaꞌ-waasi kááꞌa túfífaena séna kesí waásisono. Kemá ááéwara káféꞌwaraꞌa Maníkón-aúrankaꞌa kaweꞌ-úmai méꞌa moórá-tantaaꞌa sirunkó ímba umbaí wétaiye súwana ");
INSERT INTO auy_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","aifaꞌ-ámáán-káwáágón-áwíꞌa Ánánáyasi wemá Póroni ewaaꞌó mérowisafena séna óiꞌa turáráaro súwasa miyá uwaná ");
INSERT INTO auy_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Póro wentáféna séna empímbá sáwí-imayaa wéraimba póna Maníkó embá tufuwíníye. Emá méma imáyáa éma ámáámba arááíwaꞌmai aaifimbá ankáúmne sémpo minámáámbá taraisé óiꞌa turáráaro sénasa sóiꞌo turáráámba ámáámba taraisóne Póro súwasa ");
INSERT INTO auy_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","wení ewaaꞌó mérowi sésa Maníkóní aifaꞌ-ámáán-káwáágómbá símai sáwíꞌa wéuwankaane suwaná ");
INSERT INTO auy_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Póro séna aifaꞌ-ámáán-káwáágó iyémó sewaꞌó isékaa ímba minááí súsino. Maníkón-aai aúfáífimba agaimaréna séna kentí waásiyaꞌo káráwiyewi ímba símai sáwíꞌa uwánkáaro agaimaréna siyáimba isaꞌá sáwíꞌa úne Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Póro simásuwena ámáán-oraaꞌ-waasi tuwánéna imáyáa éna tuwímbai Sátúsi-amaamba sésa púwómpinkemba ímba íyáfasinanaawe-aai sen-kwáásí owasá tuwímbai ámáán-kawaa-waasi owé-ímáyáá éna óraaka séna kesí waásisono. Kesifomá ámáán-kawaa-waasigo éna kembó masínkaraimba kemá ámáán-kawaa-waasi úne. Maníkó pukén-kwaasi íyáfasintinkainiyemo siyáunda-aaisafeꞌa káféꞌa aaifimbá maisínkááwe Póro simátimuwasa ");
INSERT INTO auy_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","isésa ámáán-kawaa-waasi Sátúsi-amaambo sun-kwáásí keíyái aaisambá símai tuwínkaaꞌ-uráawe. ");
INSERT INTO auy_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sátúsi-amaambo sun-kwáásí Maníkó pukén-kwaasimo íyáfasintinkainda-aaisafesa karoꞌ-ááín-iye sésa Maníkóní kísau-waasi wíyómpakewi ímba méraawe sésa waási timambá ímba wéraiye suwasá ámáán-kawaa-waasi sésa Maníkó pukén-kwaasi íyáfasintinkainiye. Maníkóní wíyómpaken-kisau-waasi méraawe. Waási timambá wéraiye suwasá minááísáfésa tuwínkaaꞌ-ésa ");
INSERT INTO auy_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","aaisambá sésa ámáán-kawaa-waasifinkemba ámáámbo sun-kwáásí íyáfasinesa óraaka sésa kesáámó awánáúndasa Póro ímba sáwíꞌa wéifo Maníkóní kísau-waasigowa wembá simámakai moóráwigo wíyómpakewiya wembá simámakaiyo. Ínta isáúmne suwasá ");
INSERT INTO auy_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","aaisambá óraakaꞌ-oraakaꞌa siyáawe. Aaisambá óraakaꞌa suwaná i-wáásítí óraako séna Póromba aaisambá aéésa tafisíyapaꞌa aíyayaamba tawíyófainifo i-wáásísáféna séna waásiti afufumpimbá koméꞌa koáíꞌmaeꞌa kentí naaúmpaꞌa íyóro súwasa miwítí naaúmpaꞌa móankaraawe. ");
INSERT INTO auy_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Móankowana mindóꞌwáámbá Fasiꞌaénkó Póroni ewaaꞌá kumbaéna séna fasiꞌámai mé kentáfé Yérúsaremufaꞌa simátímakaantemba Rómu-naopaꞌa kosimátiminone Fasiꞌaénkó siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Súwasa aafáyáaraꞌa Yúndaa-waasi tuwímbai túwaandu ésa Póromba tufuwíyan-aai sésa tufútuweta tóné nonésá nánaumpo ímbo tufuwéta tóné nonésá ínta nánaumnemo óraakaꞌo ");
INSERT INTO auy_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","sun-kwáásí kaeꞌ-wááí-wáásí mésa sésa ");
INSERT INTO auy_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","óraaꞌ-amaan-kisau-waasiye óraaꞌ-waasiye kosimátimesa sésa túwaandu éta óraaka séta Póromba tufútuweta tóné nonésá nánaumpo ímbo tufuwéta tóné nonésá ínta nánaumne. ");
INSERT INTO auy_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Miyáumai ámáán-oraaꞌ-waasiye Rómu-oraakontafeꞌa karoꞌá kosimáme séꞌa Póromba áíꞌmae kempátá tinatá áísai úmai minááígóní áwáusa isánae sewé kosimámeꞌa seró. Minááí isésamo aampaꞌó áíꞌmaesamo tíyata tufuwónáísaiye siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Suwaná Póroni ámánaakon-ááninko tufuwíyan-aaimo sumbá iséna awaantanténa i-wáásítí naaúmpaꞌa iyéna Póromba minááí isimámuwana ");
INSERT INTO auy_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","iséna i-wáásítí kawáágómbá áántena séna miwámbá áíꞌmae óraakompaꞌa winaná moórá-aai kosimámino súwana ");
INSERT INTO auy_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","áíꞌmaena óraakompaꞌa wéna séna ándáfaꞌo imérain-kwaasigon-awiꞌa Póro sáántena séna minífóꞌá áíꞌmae óraakompaꞌa winaná moórá-aai simámino sisaꞌá empáꞌá áíꞌmae túne súwana ");
INSERT INTO auy_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","óraako miwámbá ayáán-toꞌmaena ímbo waásimo méron-aempaꞌa ánkarena áísai ena séna nóran-aaiyaꞌiyo sinaꞌá ísáano súwana ");
INSERT INTO auy_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","miwá simámena séna Yúndaa-oraaꞌ-waasiye ámáán-oraaꞌ-waasiye moórá-aai sésa aafáyáaraꞌa empáꞌá iyésa karoꞌá isésa Póromba áíꞌmae kempátá kumínata áísai úmai minááígóní áwáusa isánae karoꞌá isénááwe. ");
INSERT INTO auy_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Miwí táái ímba isaaó. Kaeꞌ-wááí-wáásí óraaka sésa Póromba tufútuweta tóné nonésá nánaumpo ímbo tufuwéta tóné nonésá ínta nánaumne sésa aúpáꞌá aampaꞌá káráwiyesa miwí tááisafe ewé sínono sésa káráwiyaawe. Mindásafe miwí táái ímba isaaó. Minífókó óraakomba miyá simámuwana ");
INSERT INTO auy_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","iséna séna simásimenda-aai ímba fíꞌon-kwaasi simátime óraakomba simámakaumne ímba siyó séna aiꞌmákaiye. ");
INSERT INTO auy_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","24","Minífókómbá aiꞌmaréna i-wáásítí kawáágónkáí táántowasarai tuyaná séna káféꞌ-noꞌwaamba Póromba áíꞌmaekai Sísááríyaa-naopaꞌo kámáni-oraakompaꞌa múauwaakaiyo. Sáwífaꞌ-i-waasi 200 i-waasi toꞌmayaa íyasa tuwímbai-waasi ósifinkaꞌo nón-kwaasi 70 waasi toꞌmayaa íyasa sáwífaꞌa 200 waasi paepáéꞌo tokáan-kwaasi toꞌmayaa íyaꞌa Pórombo ayááꞌmaenamo wínda-osi toꞌmayaa uwánkeꞌa káféꞌ-noꞌwaamba Póromba kaweꞌ-úmai káráwimai áíꞌmaeꞌa kámáni-oraakon-awiꞌa Fíríkísimpaꞌa múauwaaro séna ");
INSERT INTO auy_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","aúfái agaéna maará simámena séna ");
INSERT INTO auy_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","kentáásí óraaꞌ-waasi Fíríkísiyo isaaó. Kemá Kóróndíyasi-Rísíyaasi káriꞌ-aai simámenaumpo isaaó. Kaweꞌ-úmaiya méraano. ");
INSERT INTO auy_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yúndaa-waasi minkwáásígón-áwíꞌa Póromba taꞌótokesa tufuwíyanesa owaꞌá Rómu-waasiti aúfáímo tokáin-kwaasigo isaꞌá iséꞌa Yúndaa-waasi tiyáámpinkemba tafisímai kesí i-wáásí tiyáámpimba tinkáúnasa áíꞌmaesa migowé. ");
INSERT INTO auy_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Minkwáásígómbó simánkén-aai isánae séꞌa áíꞌmaeꞌa miwítí óraaꞌ-waasifaꞌa kunkáumne. ");
INSERT INTO auy_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ímba sáwíꞌa uráifo miwítí ámáán-aaigomo intáfésa simánkaraawe. Kemó ándáfaꞌo auwéꞌo tufúwónanamo puwínda ímba moórá-tantaaꞌa uráiye. ");
INSERT INTO auy_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Yúndaa-waasi tuwímbai tufuwíyan-aai sewaꞌá iséꞌa empáꞌá aiꞌmáráanasa áíꞌmaesa kumónááwe. Wembó simánkaraan-kwaasisafeꞌa simátime séꞌa wembó aaifimbó maénkáán-aai enaúrankaꞌa símai kaweꞌán-oro. Mináúfáífímbá agaimaréna siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Agaimaréna súwasa i-wáásí simátimuntemba miyá ésa mindóꞌwáámbá Póromba áíꞌmaesa wémesa Ántípátirisi-naopaꞌa kunkwaésa ");
INSERT INTO auy_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","aafáyáaraꞌa i-wáásí marapáꞌó kun-kwáásí kunuwerésa miwítí naaópaꞌa íyúwasa ósifimbo nún-kwaasi Póromba áíꞌmaesa ");
INSERT INTO auy_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","wémesa Sísááríyaa-naopaꞌa ósifinkemba marapáꞌá kumbaésa mináúfáí óraakomba múamesa Póromba aúrankaꞌa múankowana ");
INSERT INTO auy_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","mináúfáí toráumai iséna Pórontafena séna emá náám-barafaken-kwaasiyaꞌono súwana Póro séna kemá Sírísiyaa-marafaken-kwaasi úne súwana iséna ");
INSERT INTO auy_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","énifo aaimó simánkaraan-kwaasi kumíyaꞌa isánaumne séna wení waásisafena séna Érotimo uráin-daumpa máánkareꞌa kaweꞌ-úmai káráwiyoro súwasa miyá uráawe. ");
INSERT INTO auy_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Káráwiyuwasa séfataase-noꞌwaamba waésa aifaꞌ-ámáán-káwáágón-áwíꞌa Ánánáyasiye óraaꞌ-waasiye Póromba aaimó simánkénesa Sísááríyaa-naopaꞌa Fíríkísimpaꞌo kúmúmba moóráwigo ámáámba kaweꞌ-úmaimo isón-kwaasigon-awiꞌa Tétárasi weséꞌa Fíríkísimpaꞌa kumbésa ");
INSERT INTO auy_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Póromba áántowana túwana Tétárasi aaí simánkena óraakomba símai arumbá faiyaréna séna kentáásí óraakoo kaweꞌ-ímáyááwáráꞌ-wáásí po kaweꞌ-úmai káráwiyonata ayáátáákaꞌa aáno úmaisa méraumne. Ení imáyáafinkemba kaweꞌ-úmai súwaꞌnai ónata maéꞌéúndasaaniye. ");
INSERT INTO auy_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kesáá naaóꞌ-naoꞌo méraunda-waasisa aasiyaasi-kánáá entáféta aamoisá wéune. ");
INSERT INTO auy_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ímba ayáátááꞌ-aai sénaumpo embá awesaraí ifáínifo ampáán-ááí sénaumpo usúkáꞌmai isaaó. ");
INSERT INTO auy_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Maankwáásígó aoisaambá wimái seyaafáꞌ-máráfáꞌá wénena Yúndaa-waasi símai tirumbá faiyáráísasa Násaretifakewini aampaꞌá arááíwaesa owaná miyámó on-kwáásítí aifarááwí éna miyá wéiye. ");
INSERT INTO auy_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Miyá éna fíꞌonkaa-waasi áíꞌmaena óraaꞌ-amaan-daumpaꞌa móankaraisana ména sáwíꞌo uráintafeta maankwáásísá taꞌótoketa kentáásí ámáán-oraaꞌ-waasifaꞌa aaí simánkanae únansa ");
INSERT INTO auy_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","i-wáásítí óraakon-awiꞌa Rísíya kuména kusínkambaisa siyáámpinkemba Póromba kunáíꞌmaena iména ");
INSERT INTO auy_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","simásimenasa séna empáꞌá másénááwe sisatá wégumune. Maankwáásígómbó áísai inanamó éna aaifimbó maénkaraunda-aai wemá sína seyaafáꞌ-ááí isaaó Tétárasi súwasa ");
INSERT INTO auy_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yúndaa-waasi wembá áwaꞌnai esa minááímó simbá éraiꞌ-aai siyé siyáawe. ");
INSERT INTO auy_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Suwaná kámáni-oraako aúwááméꞌa éna Pórontafena e siyó súwana Póro séna emó káráwiyonda ayáátáákaꞌa aatáí maisuꞌmaé iyáanda póꞌa enaúrankaꞌa anondáá ke aaimó sendasáféna sirunkó aamoí wéiye. ");
INSERT INTO auy_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Maníkóntáféꞌa imáyáa éꞌa wenáwíꞌo mósá maráúndasafeꞌa Yérúsaremufa iméꞌa siyáánkai úmai kaeꞌ-nóꞌwáámbá taíꞌáraifo tuwímbaimo tísai inasá éraiꞌa siyé sénááwe. ");
INSERT INTO auy_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Óraaꞌ-amaan-daumpaꞌe káriꞌ-amaan-daumpimpaꞌe máápaꞌe ímba aaisankáámbá séꞌa ímba waási símai tiyáí-ááímó siyáunda Yúndaa-waasi suwánaraawe. ");
INSERT INTO auy_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Kembó simásínkáámba karoꞌá sefó minááígóní áwáu ímba wéraiye. ");
INSERT INTO auy_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Aforaꞌá ke simámenaumne. Ísuni aampaꞌá wéweꞌa kentáá síwáꞌnáti Maníkón-ímáyáá éꞌa áwíꞌa mósá maráúnasa Ísuni aantafésa maankwáásísómbá sésa karoꞌ-ámbán-iye wésewe. Móseseni ámáámba iséꞌa Maníkón-aaimo simátímakowi agaimakáan-aai iséꞌa éraiꞌe súne. ");
INSERT INTO auy_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Miwí sésa Maníkó seyaafáꞌnánká sáwí-waasiye kaweꞌ-wáásíyé pukémpinkemba íyáfasintinkainiye sésamo amuꞌmáráántemba kemá miyá wéune. ");
INSERT INTO auy_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mindásafeꞌa kesí imáyáafimba sáwíꞌan-ifo séꞌa Maníkón-aúrankaꞌe waási túrankaꞌe kaweꞌ-úmai méraumne. ");
INSERT INTO auy_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Énifo fíꞌo-fiꞌom-barafaꞌa wéneꞌa tuwímbai-aatai maisuwéꞌa Yérúsaremufaꞌa kesí waási ímbo tómbó makáan-kwaasi óntamba timéꞌa Maníkóntáféꞌa ísámai póíꞌo ondasáféꞌa iyáumne. ");
INSERT INTO auy_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Minkísáú wémaeꞌa Yúndaa-waasiti ámáámba ísámai kaweꞌó í-tántááꞌá uwásuweꞌa Maníkóntáféꞌa ísámai póíꞌo ondasáféꞌa óraaꞌ-amaan-daumpaꞌa iméraawanasa kempáꞌá sáwífaꞌ-waasi ímba taméresa aaimó símae kumbá Yúndaa-waasi suwánowasa ");
INSERT INTO auy_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","tuwímbai Yúndaa-waasi Ésiyaa-marafaken-kwaasi mésa suwánaraawe. Sáwíꞌo uráanasamo suwánaresa enaúrankaꞌa simásínkáaro. ");
INSERT INTO auy_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ámáán-oraaꞌ-waasifaꞌo méraawandaraꞌo sáwíꞌo uráanasamo suwánaresaraa moórá-aai aantemba sewisinó. Moórá-aai aantembo senkakaa isáásino. ");
INSERT INTO auy_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ámáán-oraaꞌ-waasifaꞌo méraawandaraꞌa óraaka séꞌa Maníkó pukén-kwaasimo íyáfasintinkainiyemo siyáunda-aaisafesa káféꞌa aaifimbá maisínkááwe séwánasa kemó siyáunda-aaisafesa simásínkááwe Póro siyáiye. ");
INSERT INTO auy_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Súwana Fíríkísi Ísuni aampaꞌó kun-ááí éꞌa ísarena séna i-wáásítí óraakon-awiꞌa Rísíya kumínaꞌa maanááí ísámai kaweꞌá ónáífo koró simásuwena ");
INSERT INTO auy_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Póromba káráwiyowintafena séna á