﻿USE sofia;
DROP TABLE IF EXISTS sofia.auu_vpl;
CREATE TABLE auu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES auu_vpl WRITE;
INSERT INTO auu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus Kristus mee ko Daud ma, Abraham ma asii-kaba-kaba seta bagee me kabata mée. Waa kabaano taa miyoo bagee ekaa kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham mee Isak ataagi, Isak mee Yakub ataagi, Yakub mee Yehuda ma okoo kenaa bagee ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda mee Peres ma, Zerah ma wiya ataagi (ekea baayo Tamar), Peres mee Hezron ataagi, Hezron mee Ram ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram mee Aminadab ataagi, Aminadab mee Nahason ataagi, Nahason mee Salmon ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon mee Boas ataagi (Boas wabaayo Rahab), Boas mee Obed ataagi (Obed wabaayo Rut), Obed mee Isai ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai mee Israel bagee me eboo Daud ataagi, Daud mee Salomo ataagi (Salomo wabaayo mee Uria me api miyaa da), ");
INSERT INTO auu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo mee Rehabeam ataagi, Rehabeam mee Abia ataagi, Abia mee Asa ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mee Yosapat ataagi, Yosapat mee Yoram ataagi, Yoram mee Uzia ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia mee Yotam ataagi, Yotam mee Ahas ataagi, Ahas mee Hizkia ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkia mee Manasye ataagi, Manasye mee Amon ataagi, Amon mee Yosia ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia mee Yekonya ma okoo kenaa bagee ataagi. Kuwa bagee yuwa toogee seta kaboo Babel bagee me Israel bagee yuwa peneata Babel magaa kaa badaa maadoo peeta. ");
INSERT INTO auu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babel bagee me Israel bagee yuwa badaa maadoo peeta wodoo taa Yekonya me Sealtiel kabata. Sealtiel mee Zerubabel ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel mee Abihud ataagi, Abihud mee Elyakim ataagi, Elyakim mee Azor ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor mee Zadok ataagi, Zadok mee Akim ataagi, Akim mee Eliud ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud mee Elazar ataagi, Elazar mee Matan ataagi, Matan mee Yakub ataagi, ");
INSERT INTO auu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub mee Yusup ataagi, Yusup me apimee ko Maria, Yesus kabata apii mee. Yesus mee Kristus see ekaa weakee. ");
INSERT INTO auu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","See kemaata Abraham kabata yoo kaama Daud kabata yoo too yaayupii da kuwa mée ega gaasi ma wui asii-kaba-kaba seta. Bedaa Daud kabata yoo kaama Israel bagee yuwa Babel magaa kaa badaa maadoo peeta yoo too yaayupii da kuwa miya mée ega gaasi ma wui asii-kaba-kaba seta. Kiyoo kaama bedaa Israel bagee yuwa badaa maadoo peeta yoo kaama Kristus mee kabata yoo too pakaa-pakaa kuwa miya mée ega gaasi ma wui asii-kaba-kaba seta. ");
INSERT INTO auu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kristus kabata menaa mee ko kisee: Petamanii okooto Maria ma, Yusup ma dimi aapeegee seta kiya ekea aagoe taano taa kaboo da Maria mee Roh Kudus me pesee kaa kadapoo kega. ");
INSERT INTO auu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusup me 'Maria mee se goeapa' see dimii gaagi kiya waa Ogatamee me menaa daamaa yayeetaa see mée to kemaata 'Maria mee ekeasiino kuwa mée gii da kaa se, waa ego weda kaapa naadi wa me bagee paagoo koogo yaekeasiipa' see gaagi. ");
INSERT INTO auu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kuwa dimii gaagaa naadi unu kaa diino malaikat bagee ena deegi, Tuhan me menaa eseasegee see mée. Wa me asiino, \"Yusup, Daud ma apaa kaa mée to, wae. Maria kadapoo kega mee ko Roh Kudus me pesee kaa kadapoo yoka aa se wedaai, Maria mee goeai. ");
INSERT INTO auu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Waa paayogaa yogaa ena kabaata. Mee yogaa mee Yesus see ekaa munitagaai. Yesus me Wa me bagee yuwa okoo Ogatamee ma menaa yuwa yataa kiyaata daba daagimaa peeyaatagi yoka mee ekaa da munitagaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Maria kadapoo kega mee ko idukaa Tuhan me nabi bagee aseta menaa da mikee uwa daaga yoo. ");
INSERT INTO auu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Mee ko \"Ukuyogaa ena paayogaa ma enaataa toono taa da kaa kadapoo keta kaama paayogaa yogaa ena kabaata. Wa ekaa da Imanuel see ekaa weapea\" see menaa ebeamaata. Imanuel see ekaa mee wegayu ko Ogatamee inii ma enaataa mée eetupi see wegayaa mee. ");
INSERT INTO auu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusup waa anoogeeta malaikat bagee me asigi-asigi see see ukuwaano see naadi Maria mee goegi ");
INSERT INTO auu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kiya yoga kabaano taa miyoo kuwa ekea enatapa toono taa. Paayogaa yogaa ena kabamaata kaama Yusup me Yesus see ekaa munta. ");
INSERT INTO auu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus kabata mee ko Herodes mee ebo tota kaboo Yudea wee kaa Betlehem magaa kaa kabata. Kabamaata wodoo okadee ipi see bagee mée okoo wedo waa naa awii yaato kaama Yerusalem magaa kaa megea. ");
INSERT INTO auu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Meemaata kaama kiyoo bagee yuwa paagoo apaadee taano, \"Yahudi bagee yuwa paagoo ebo tootagi Mée mee kayoo kaama kabagea? Inii awii yaato kaama Waa kabagea see nekeensi naadi okadee to epoo to kaa deeta kaama Waa ebo ekee, yaapaagee taano see naadi mege yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kuwa asegea menaa yuwa doodoota Herodes paagoo eewegagea naaki dimi oogi, Yerusalem magaa kaa bagee yuwa uduma miya kisee. ");
INSERT INTO auu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes me kuwa kaasee menaa naadi Yahudi kaa dimi ipi see bagee \"Meei\" asigi. Imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo Herodes paagoo kutuu semaagea. Kutuu semaata kaama wa me okoo apaadee taano, \"Idukaa ebeamaata menaa yiba Ebo Kristus mee kayoo kaama kabaatagea see naa ebeamaata ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Okoo me asiino, \"Yudea wee kaa Betlehem magaa kaa kaama kabaatagea see menaa ebeamaata. Idukaa Ogatamee me wegata menaa da nabi bagee me ebeamaata menaa kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Yehuda wee kaa Betlehem magaa mee ko Yehuda wee kaa magaa yupii mee otoopa magaa se, mee magaa to kaa kaama Israel kaa Eboo ena kabaatagea, kuwa Ni me Israel bagee kuwa Wa me nadeewoo, namuniwoo taatagi' see menaa ebeamaata\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Asegea naadi Herodes me asiino, \"Kuwa awii yaato kaama mepea bagee yuwa koogo badaa namaagii\" see asigi. Badaa maageegea kaboo wa me okoo apaadee taano, \"Mee okadee mee kamee kenoo kaa naa deepea ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bedaa wa me asiino, \"Ikii Betlehem magaa kaa pooi. Peemaata kaama mee yogaa mee ipiipi see niiabaai. Deemaagea kepa ko moga me-nasii, anii miya Waa ebo ekee, yaapaagee taano see yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Okoo wa me menaa yeeta kaama peedoota eta mana kaa deataayaa naaki awii yaato kaama mipi okadee to tupi. Mee okadee to wa keta peegi, peegi kisee too Yogaa to tupi ee to dagii da kaa pe-toomaagi. ");
INSERT INTO auu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Okoo okadee to deeta kaama maamaa ede ketaa. Okadee to peegi, peegi okoo miya peedoota yogaa to tupi ee to kaa. ");
INSERT INTO auu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Okoo ee yiba seemeta kaama deeyaa naaki mee Yogaa to ma, okooto Maria ma topea. Okoo Wa paagoo mumo maga yaato esee-ekeata ebo ekee, yaapaageekea. Ayaabu kea da ekegamaata kaama ebo agiyoo yuwa mee Yogaa to mantayu, kuwa ko emas ma, moneepaa mokoo see agiyoo ma, wunu daamaa see agiyoo ekaa da mur ma kuwa. ");
INSERT INTO auu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kuwa kaboo da Ogatamee me okoo unu kaa asiino, \"Ikii Herodes paagoo se peemagaai\" see asigi. Asigi naadi okoo kutuwadoota eta ena taa okoo me magaa kaa peegea. ");
INSERT INTO auu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Okadee ipi see bagee yuwa pe-seomegea kaboo Tuhan me menaa eseasegee see mée ena me unu kaa Yusup asiino, \"Anoogii. Herodes me mee yogaa to patamaano see naadi me-abaapea yoka ekea seepuguu moga badaa maadoota Mesir magaa kaa eepooi. Eepeemaata kaama Ni me kasiipa menaa kuwa diitoo siwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Asigi naadi daatooyiba moga anoogeeta ekea seepuguu badaa maadoota Mesir magaa kaa eepeegi. ");
INSERT INTO auu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Peemaata kaama Herodes mee bogaano taa kaboo kuwa uduma kiyoo omegee, toogee seta. Mesir magaa kaa omegee, toogee seta kuwa ko idukaa Ogatamee me nabi bagee paagoo aseta menaa kuwa uwa daaga yoo. Kuwa ko kisee: \"Niyoopaa, Mesir magaa kaa kaama pakaai\" see aseta. ");
INSERT INTO auu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes me kuwa okadee ipi see bagee yuwa nadeebaa sepea ii naadi kagoo kigi. Kagoo ebo kaa wa me asiino, \"Betlehem magaa kaa ma, gebo kaa magaa kaa ma kiyoo paayogaa yogaa tahun wiya ompea miyoo kuwa uduma napatameepii taai\" see asigi. Herodes me \"Kuwa tahun wiya ompea miyoo see yogaa yuwa too napatameepii taai\" see aseta menaa mee ko okadee ipi see bagee yuwa me Yesus agoo kimi kenoo kaa wa paagoo aseta kaama tahun wiya too ompea see kuwa ipi kemaata aseta menaa mee. ");
INSERT INTO auu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yoga yuwa patameepii seta kuwa ko idukaa nabi Yeremia me wegata menaa da uwa daaga yoo, mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","\"Ramah magaa kaa kaama mena yeeyaa naaki ae-wae, sooi-wooi, mée yege ma menaa wegagea. Rakel wa me yogaa yuwa kaa yegee segeeka, yoga yuwa uduma taa kegea yoka yege sikiiniino be\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes mee boogi kaboo da Tuhan me menaa eseasegee see mée ena me Yusup unu kaa asiino, ");
INSERT INTO auu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","\"Anoogii. Yogaa to patamaano see koo semea bagee yuwa boogea yoka ekea seepuguu badaa maadoota Israel magaa kaa metaki eepakaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Anoogeeta ekea seepuguu badaa maadoota Israel magaa kaa metaki pakagea ");
INSERT INTO auu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kiya Herodes yoopaa Arkelaus mee nagamee komoo tupi. Waa Yudea wee kaa ebo tupi kemaata Yusup mee kiyoo pakaano wedaagi. Tuhan me bedaa unu kaa \"Kiyoo se pooi\" asigi. Asigi naadi waa Galilea wee kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Peemaata kaama maga ena ekaa da ko Nazaret magaa kaa kiyoo omegee, toogee seta. Kiyoo omegee, toogee seta kuwa ko idukaa nabi bagee me wegata menaa da uwa daaga yoo, mee ko kisee: \"Mee mée mee ko Nazaret magaa kaa Mée to see ekaa weapea\" see menaa wegata. ");
INSERT INTO auu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Uwo mée yatukumeta mée Yohanes mee peedoota Yudea wee kaa piya taa, one taa see ebo mee maga ugii da kaa peemaata kaama weganaa seta menaa ko ");
INSERT INTO auu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","\"Ogatamee Wa too ebo mée eetoono see kooki yoka ikii me pedeo dimii, pedeo menaa kuwa ekeata Waa ma dimii menaa kaa too umiwoo, toowoo taai\" see menaa weganaa seta. ");
INSERT INTO auu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Idukaa nabi Yesaya me wegata menaa ena mee uwa daano yaato ko Yohanes kaa uwa daaga, mee ko kisee: \"Ebo mee maga ugii da taa mée waa ena me ebo menaa-menaa kaa 'TUHAN me etaa da ipiipi yawuditagaai. Waa meeno see etaa da daamaa topoo yatupitagaai'\" see menaa wegata. ");
INSERT INTO auu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes wa me dokaa kuwa ko unta iyuu me iyata dokaa, bedaa epmoonee da mee woda kado me ipiipii seta. Wa me naano agiyoo kuwa ko motaabi ma, degee kegoo uwoo ma kuwa. ");
INSERT INTO auu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mée eebaa wa paagoo peegeekea, kuwa ko Yerusalem magaa kaa bagee ma, Yudea wee kaa bagee ma, Yordan uwo gebo kaa bagee ma okoo mée eebaa. ");
INSERT INTO auu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Okoo me pedeo yuwa uduma awee da kaa wegatagaa semaata kaama Yohanes me Yordan dee kaa uwo yatukumigi. ");
INSERT INTO auu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kuwa kaboo da deamaagi naaki Parisi kaa bagee ma, Saduki kaa bagee ma okoo mée eebaa uwo natukumisi naadi megea. Wa me okoo asiino, \"Yaai, ikii otoogiyoo tomaa, kaasee kaa nakaayoo megea ya? Ogatamee me mée wigintagaatagi naagoo 'Wa me se nakagoo kaatagi, anii daba poota' see dimii mee gaagea ye? ");
INSERT INTO auu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Eto ko ikii me pedeo yuwa ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo taai. Ikii mikee kisee bagee ii see kigaasi naadi daamaa agiyoo too ukuwawoo taai, daamaa poo ekayaabuu siwoo taai. ");
INSERT INTO auu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ikii me 'Inii ko Abraham me asii-kaba-kaba seta bagee yoka inii sikii' see dimii mee se gaai. Ani me kisiino ko: Abraham me asii-kaba-kaba seta bagee gaayu ko Ogatamee me apuwa oma tabaa da kuwa kisee bagee maamaa eebaa kiyaayaa yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Piya manii da kaa yaka maataata eto tupi yoka daamaa poo se ekayaa piyaa yuwa uduma kobegeeta kaama biyaa yiba tameatagi. ");
INSERT INTO auu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Waa uuto meepi Mée mee ko esee ebo. Anii peedi yoka Wa me bado doko yadogaano miya anii iyo, weda. Ikii me pedeo yuwa ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo see bagee yuwa kuwa Ani me ikii uwo yiba kitukumpa kiya Wa me kitukumaano kuwa ko Roh Kudus yiba miya kitukumaatagi, biyaa yiba miya kitukumaatagi. ");
INSERT INTO auu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wa me yagaa da kaa gandum poo wigineakee agiyoo miya topa. Keepa wiginegee sepea yuwa masegeeta maagee see yoo daamaa awimaayu kiya pedeo yaato se modeemaayaa see biyaa kaa boneasiitagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kuwa kaboo da Yesus mee Galilea wee kaa omegee naadi kaama peedoota Yohanes me uwo natukumisi naadi Yordan dee kaa peemaayu ");
INSERT INTO auu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kiya Yohanes me kisee se yoka naadi kaama asiino, \"Anii A me uwo natukumaano mee too daamaa kiya kaasee kaa Aa ni paagoo uwo natukumisi naadi mege ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kiya Yesus me asiino, \"Koosi, Ogatamee me kisee ede kiyaa agiyoo kuwa yaukuwaano gaano pedeo yoka uwo natukumaai\" see asigi. Daamaa yoka naadi uwo yatukumigi. ");
INSERT INTO auu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesus maayoo kaa peanigi too ko taka ena epoo to kabaanega, deataayaa naaki Ogatamee me Roh mee poodee see bedoo keenda Wa kaa eseanigi. ");
INSERT INTO auu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kuwa kaboo da taa epoo to yaato kaama aseeyamaata menaa ko \"Mee ko Niyoopaa. Ni me esee epa see Yogaa yoka Anii dimi wikii-wikii nasiyaabuuki\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kuwa kaboo da Roh me Yesus mee Iblis me Wa paagoo apaadeesi naadi badaa maadoota piya taa, one taa see ebo mee maga ugii da kaa eepeegi. ");
INSERT INTO auu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus mee unu mée wiya, egapii mée wiya kuwa uduma naano agiyoo tapoo omegee, toogee naadi kaama naadi ebo. ");
INSERT INTO auu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mée gaadee taa see mée mee meedoota Wa paagoo asiino, \"Aa Ogatamee Yoopaa yoka kuwa omaa kuwa naano agiyoo kiyaano, daa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kiya Yesus me asiino, \"Ogatamee me kapogee yiba mena ena mee ko kisee: 'Mée tomaa omegee, toogee taano kuwa naano agiyoo kaa too se kiya Ogatamee me wegatagaa seta menaa kuwa uduma kaa omegee, toogee siyaa' see menaa ebeamaata yoka se kayiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bedaa kaawaa ena ma Iblis me Yesus badaa maadoota daamaa wa too wigintaata magaa, Yerusalem magaa kaa kiyoo eepeegi. Eepeemaata kaama Ogatamee me ee dagii da kaa asipasi yoo eepakaanigi. Yesus kiyoo yiinaageeta tuyaata kaama ");
INSERT INTO auu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Wa paagoo asiino, \"Aa Ogatamee Yoopaa yoka Aa kagaata magaa da kaa eseande. Ogatamee me kadiipi, Wa me kapogee yiba mena ena agoo yoka, mee ko kisee: 'Ogatamee me aa se pedeo kese naadi Wa me malaikat bagee yuwa paagoo \"Waa yagaa pakaa-mokatoo taai\" see kaasiipi, aa omaa to kaa bado kepo ena miya se tukuuniipe' see menaa mee ebeamaata yoka dimi se gaata kagaata eseaniino, daa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus me asiino, \"Ogatamee me kapogee yiba ebeamaata menaa ena mee miya kisee: 'Ikii me Eboo TUHAN Ogatamee mee se gaadee taai' see menaa mee ebeamaata yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bedaa kaawaa ena miya Iblis me Yesus badaa maadoota esee togoo see maga bago ena kaa eepakaamaata kaama mée tomaa-tomaa okoo paagoo ebo tookee bagee yuwa ma, okoo me senawii agiyoo-pagiyoo yuwa ma kuwa uduma deeyaagi. ");
INSERT INTO auu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wa me Yesus asiino, \"Deede, kisee Aa ni paagoo mumo maga kaa esee-ekeata anii ebo naekee, naapaagee siwoo siyu ko anii kuwa agiyoo kuwa uduma Aa epoo mée kakiyaapa\" see asigi ");
INSERT INTO auu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","kiya Yesus me asiino, \"Iblis, aa pooi. Ogatamee me ebeamaata menaa ena mee ko kisee: 'TUHAN Ogatamee Wa too ebo ekee, Wa too yaapaagee siwoo taai' see menaa ebeamaata yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iblis pe-seomigi kaboo da malaikat bagee meedoota Wa paagoo iye-iyeekea. ");
INSERT INTO auu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yohanes mee digiyoo ee yiba seemiyaagea see menaa kuwa Yesus me yeeta kaama metaki peedoota Galilea wee kaa, ");
INSERT INTO auu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret magaa kaa. Kiyoo peemaata kaama bedaa muguu naadi Kapernaum magaa kaa Galilea piku geboo da kaa peemaata kiyoo omegee, toogee seta. Kuwa magaa kuwa ko idukaa Zebulon apaa kaa bagee ma, Naptali apaa kaa bagee ma okoo me toogee seta magaa. ");
INSERT INTO auu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus kiyoo omegee, toogee seta kuwa ko idukaa nabi Yesaya me wegata menaa da uwa daaga yoo. Kuwa menaa kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","\"Zebulon magaa ma, Naptali magaa ma wiya kuwa ko uwo pikuu da doodoo da taa peegee see etaa da geboo da kaa magaa, Yordan uwo asii yaato magaa wiya. Kuwa uduma Galilea wee kaa magaa, apanaa tomaa kaa bagee yuwa toogee see magaa. ");
INSERT INTO auu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kiyoo digiyoo yiba toogee see bagee yuwa ebo awee agoo da deegea, Ogatamee ewo kaa boowoo siyaa bagee yuwa paagoo agoo da yawogaamaaga\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mee kaama wodoo Yesus me eeweganaa seta menaa ko \"Ogatamee Wa too ebo mée eetoono see kooki yoka ikii me pedeo dimii, pedeo menaa kuwa ekeata Waa ma dimii menaa kaa too umiwoo, toowoo taai\" see menaa kuwa eeweganaaki. ");
INSERT INTO auu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesus mee Galilea piku geboo da taa peetaaka too deamaayaa naaki doge abagee see mée wiya, ekea kenaaya uwo pikuu da yiba jala onee tameeyamoo taakea. Ena mee ekaa da ko Simon, Petrus see ekaa miya weakee. Ena mee ekaa da ko Andreas. ");
INSERT INTO auu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus me asiino, \"Ni sekaataa nameei. Ekea mée naabawoo see bagee wiya kikiyaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kisee ki jala onee ekeata Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Muguu naadi amokiyoo deamaayaa naaki bedaa mée ekea kenaaya topea, kuwa ko Zebedeus me yogaa wiya, Yakobus ma, Yohanes ma ekea kenaaya. Nagamee ma okoo koma yiba jala onee ipiipii taakea. Yesus me \"Ekea Ni sekaataa nameei\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kisee ki mee komaa da ma, nagamee ma ekeata Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus mee Galilea wee kaa magaa uduma nawenaa, peenaaka too sembahyang segee see ee yuwa yiba mée topetaa, bedaa etokaa daamaa menaa, Ogatamee Wa too ebo mée eetuyaa menaa kuwa eewegataa, bedaa mée kaa meanee seta agiyoo tomaa-tomaa uduma miya yataa kiyaabuu senaaki, kisee ukuwanaaki. ");
INSERT INTO auu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wa me ukuwanaa, peenaa seta menaa yuwa Siria wee kaa magaa uduma ogo peega. Ogo peega naadi kaama mée eebaa Wa paagoo medaakea. Ikiyoo tomaa-tomaa meanee taa see bagee ma, boodi abaagee see bagee ma, paa yago bagee ma, boga-bogaa yago bagee ma, oogimaata see bagee ma okoo eebaa Wa paagoo eemegea. Kuwa okoo kaa meanee seta agiyoo uduma Wa me yataa kiyaabuuki. ");
INSERT INTO auu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mée eebaa Wa sekaataa peedaakea, kuwa ko Galilea wee kaa bagee ma, Dekapolis wee kaa bagee ma, Yerusalem magaa kaa bagee ma, Yudea wee kaa bagee ma, Yordan uwaasii yaato magaa kaa bagee ma, mée eebaa Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus me deamaagi too ko mée eebaa Wa paagoo medaakea. Medaakea naadi maga kutuu to kaa pakaamaata kaama animaayu, Wa me topenaa see bagee yuwa Wa paagoo pakaamaagea. ");
INSERT INTO auu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wa me mée tupi-manee seta menaa kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","\"Okoo me 'Anii daba see mée nao' naadi Ogatamee kaa dimi maayaa bagee kuwa daamaa, okoo ko Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa eetuyaa bagee yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yegee siyaa bagee kuwa daamaa, okoo dimi mena yatamooniyaapi yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dimi daba, mena daba see bagee kuwa daamaa, okoo ko uwoo to, magaa to uduma epoo bagee kaatagea yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Okoo me 'Anii Ogatamee me gaata-gaata yuwa too yaukuwawooka naaki ou' see dimii gaayaa bagee kuwa daamaa, okoo me ou dimii gaayaa yuwa kuwa Ogatamee me daamaa sikii yakiyaapi yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mée epa dimii gaayaa bagee kuwa daamaa, Ogatamee me okoo miya epa kaapi yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pedeo dimii, pedeo menaa taa see bagee kuwa daamaa, okoo Ogatamee diipea yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mée aaemee-emee siyaayaa bagee kuwa daamaa, okoo Ogatamee me yogaanii see ekaa weapea yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ogatamee me gaata-gaata yuwa too yaukuwawoo see bagee okoo kisee bagee kemaata mée me wegee-wegee siyaa kuwa daamaa, okoo ko Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa eetuyaa bagee yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ikii Ni yaato bagee kemaata mée me kiwisineano ma, kipeepuu taano ma, makapaa menaa kikobaano ma kuwa koosi, ede nao. ");
INSERT INTO auu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ikii koogo makii taa see kaa toowoo setaa to mokoo da mee ebo, epoo to wodoo topa yoka ede ma, ede ma siwoo taai. Mée me kisee pedeo kiukuwagee taapea kuwa ko idukaa okoo me bagee me miya nabi bagee eboo yuwa maa diya kisee pedeo yaukuwagee siwoo seta yoka dimi se nagimaai.\" ");
INSERT INTO auu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","\"Ikii ko dega mokoo, magaa da kaa bagee paagoo daamaa yaekeata agiyoo mokoo. Kiya dega gii taa keegoota kaama wodoo kaasee bedaa gii kiyaayaa? Iyo, aii agiyoo too kemaata tameepeata kaama bado batagi-patagi too siyaa. ");
INSERT INTO auu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ikii ko peto agoo da mokoo, mée tomaa-tomaa yuwa daamaa deesi naadi wogaamagaakee agoo da mee. Maga kutuu to kaa mée eebaa toogee see magaa mee se boonemaayaa, awee da kaa deeyaa. ");
INSERT INTO auu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bedaa pelita biyaa iyaata kaama otaawee me apumaakee se kiya ee yiba bagee uduma ago wogaamaasi naadi biyaa maagee yoo too pakaa-ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ikii mee mokoo miya. Ikii me daamaa ukuwagee siyaa agiyoo kuwa mée me kideeta kaama epoo to wodoo Ikiitaagi yaapaageesi yoka ikii yiba ago kusi-kusii da mee booneakee se kiya mée paagoo daamaa yawogaamagaai.\" ");
INSERT INTO auu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","\"Musa me ebeamaata menaa yuwa ma, nabi bagee me wegawoo seta menaa yuwa ma kuwa Anii wisintagaano see naadi meta see kuwa se nagaai. Wisintagaano see naadi meta se kiya kuwa idukaa menaa kuwa uduma mani yaato awee da kaa kiyaabuu seta kaama Ani kaa uwa daasi naadi meta. ");
INSERT INTO auu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Anii mikee kisiino ko: Epoo to ma, magaa to ma taa kaano taa kaboo kuwa Musa me menaa kuwa uduma, mena kamu ena miya, peedi menaa ena miya se taa kaapa, kuwa menaa uduma mikee uwa daaniita. ");
INSERT INTO auu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","See kemaata okoo kuwa menaa yiba mena kamu peedi ena ma wisintaata apanaa bagee paagoo miya 'Taa, dagu ke, niiukuwaai' see wegayaa bagee kuwa Ogatamee Wa too ebo mée eetoowoo siyaa yoo okoo peedi kaapea. Kiya kuwa menaa daamaa yayeewoo, bedaa apanaa bagee paagoo miya 'Inii daamaa niiyeewoo taai' see mée tupiwoo siyaa bagee kuwa Ogatamee Wa too ebo mée eetoowoo siyaa yoo okoo ebo bagee, ebo apii kaapea. ");
INSERT INTO auu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ani me kisiino ko: Ogatamee Wa too ebo mée eetotaa see yoo ikii kiseemiyaayaa mee ko ikii Wa me gaata-gaata yuwa daamaa yaukuwagee siyaa kuwa ebo gaayu too, kuwa Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma okoo me yaukuwagee siyaa kuwa asii eboo gaayu too ikii sikii kiyaa. Taa gaayu ko Ogatamee Wa too ebo mée eetotaa see yoo ikii se kiseemiyaayaa, see kuwa mikee kisega.\" ");
INSERT INTO auu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","\"Idukaa inii me bagee me wegawoo seta menaa ena mee ko kisee: 'Mée se wugii. Kuwa mée wugiyaa bagee kuwa hukuman maniino bagee paagoo yadogeamaano gaano pedeo' see wegawoo seta menaa kuwa ikii ipi kegea. ");
INSERT INTO auu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kiya eto ko Ni me kisiino menaa mee ko kisee: Kagoo mee miya mée wugiyaa mokoo. Kagoo kiyaa bagee okoo kaa miya ebo menaa agoo kiyaa. Mee ko mée waa ena me apanaa mikee gaayaa mée paagoo 'Aa mooniino nakaa da' see asiyu ko waa mena pekataa see bagee yuwa paagoo eepeeyaa, bedaa 'Aa dimi taa see mée yaai' see asiyaa bagee kuwa neraka biyaa yiba tameeyamaayaa. ");
INSERT INTO auu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kisee kiyaa naadi a me Ogatamee paagoo agiyoo kupi-manee taa see yoo agiyoo maniino see koo taaka too 'Anii pedeo dimii nagaataa see mée ena agoo' see nekeeniyu ko ");
INSERT INTO auu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mee maniino agiyoo da mee se manii, kiyoo eke. Ekeata kaama peedoota mee aa ma mena agoo see mée to paagoo pooi. Kagoo sikiinta kaama mee maniino agiyoo da Ogatamee paagoo daba pe-maniyaa. ");
INSERT INTO auu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aa kakagoo kiyaa mée to me mena pekataa see bagee yuwa paagoo kaapeeyu ko eta mana kaa kaama dimi daamaata kaama moga mena taa kiyaai. Mena taa kaano taa kiyu ko amokiyoo mena pekataa see bagee yuwa paagoo kadogeamaayaa. Kiyoo kaama polisi yagaa kaa kapeaniyaata kaama digiyoo ee yiba katameamaayaa. ");
INSERT INTO auu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kisee kiyaa naadi Anii mikee kisiino ko: Aa kuwa kaidimpi kepee uduma maniyu too mee digiyoo ee yiba kaama aa daba kapeeyaayaa yoka kuwa menaa mani taa kiyaai see kisega.\" ");
INSERT INTO auu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","\"Idukaa wegawoo seta menaa ena mee ko kisee: Tobaaka se taai, see menaa mee ikii ipi kegea. ");
INSERT INTO auu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kiya eto ko Ni me kisiino menaa mee ko kisee: Tobaaka taano kuwa ko api emaa daata kaama dimi yiba 'Mee apii to ou' see gaapea ko dimi yiba mee apii ma tobaaka taagi. ");
INSERT INTO auu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A me dagi yagaa yaato emaa masii to mee me pedeo agiyoo ukuwayu ko bigimegeeta tameepeasii. A me maa da uduma neraka biyaa yiba katameano kuwa pedeo yoka a me maa da ponee ena too too tameepeasiino kuwa daamaa. ");
INSERT INTO auu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bedaa a me dagi yagaa da me pedeo agiyoo ukuwayu ko daageeta tameepeasii. A me maa da uduma neraka biyaa yiba katameano kuwa pedeo yoka maa da ponee ena too too tameepeasiino kuwa daamaa.\" ");
INSERT INTO auu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","\"Idukaa wegawoo seta menaa ena miya kisee: Apimee ekeasiinaka see gaayaa mée wa me api ekeasiino kapogee mee keta apii to ebea-manii, see wegawoo seta. ");
INSERT INTO auu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kiya eto ko Ni me kisiino menaa mee ko kisee: Apimee ekeata kaama apanaa bagee paagoo peeyu ko tobaaka taayaa naadi kaama kuwa tobaaka kaa menaa kuwa api ekeasigi mée to mee kaa kaapa. Bedaa mee ekeata apii to goeyaa mée to waa miya tobaaka taakee mée kiyaa. Apimee tobaaka sepa gaayu too paimee me ekeasiyaa.\" ");
INSERT INTO auu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","\"Bedaa idukaa inii me bagee me wegawoo seta menaa ena miya kisee: 'Mée ena me \"Taa ma taa anii kisee agiyoo ukuwaapa, Ogatamee see ekaa weega yoka\" see asiyu ko ukuwaano too, se ukuwaano ko daa' see wegawoo seta menaa mee ikii ipi kegea. ");
INSERT INTO auu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kiya eto ko Ni me kisiino menaa mee ko kisee: Ikii me 'Anii kisee ekaa weega yoka' see menaa kuwa se wegaai, se aatabi taai. Kuwa ko 'Anii epoo to see ekaa da mee weega yoka' see menaa mee miya se aatabi taai. Epoo to wodoo kiyoo ko Ogatamee Waa ebo animaayaa yoo yoka kuwa menaa se wegaai. ");
INSERT INTO auu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bedaa ikii me 'Anii uwoo to, magaa to see ekaa weega yoka' see menaa mee miya se aatabi taai. Uwoo to, magaa to kuwa ko Ogatamee Wa me bado esee-ekee taa see yoo yoka se wegaai. Bedaa ikii me 'Anii Yerusalem see ekaa weega yoka' see menaa mee miya se aatabi taai. Yerusalem magaa mee ko Se-ebo, We-ebo Ogatamee Wa me magaa yoka se wegaai. ");
INSERT INTO auu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bedaa ikii me 'Ni me mumoo to yoka' see menaa mee miya se aatabi taai. A me mumoo to kaa edooyuu apa ena miya poodee kiyaayu taano miya iyo, digiyoo kiyaayu taano miya iyo, se ukuwamaayaa yoka se wegaai. ");
INSERT INTO auu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ikii me 'Taa ma taa anii kisee ukuwaapa' see dimii gaayu ko 'Anii kisee ukuwaapa' see menaa kuwa too wegaai, ebo ekaa ma se aatabi taai. Bedaa ikii me 'Anii se ukuwaapa' see dimii gaayu ko 'Anii se ukuwaapa' see menaa kuwa too wegaai. Kuwa mena ponee to kuwa too sikii. Mee wodoo eebaa menaa kuwa manii to ko Iblis me menaa yoka se aatabi taai.\" ");
INSERT INTO auu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","\"Idukaa wegawoo seta menaa ena miya kisee: Mée ena me emaa kapedeo kiyaayu ko wa me emaa miya yapedeo kiyaayaa, bedaa ego kapedeo kiyaayu ko wa me egoo to miya yapedeo kiyaayaa, see wegawoo seta menaa mee ikii ipi kegea. ");
INSERT INTO auu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kiya eto ko Ni me kisiino menaa mee ko kisee: Pedeo agiyoo kiukuwayaa bagee kuwa ikii modee se masii. Dagi yagaa yaato kona butuu to kaa yagaa kopaa katokoasiyaa bagee bedaa eka yagaa yaato miya katokoasi yoka yaekeasii. ");
INSERT INTO auu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bedaa aa ma mena agoo see mée to me mena ena too too yadaakomee taa see bagee paagoo kaapeemaata kaama a me pedeo yakiyaage mokoo da kamasiino see naadi a me mumaato dokaa da kaidimpi kepa ko mee kaidimpi dokaa da mee too se kiya koosi a me ebo dokaa mee miya kamasisi yoka daamaa yaekeasii. ");
INSERT INTO auu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bedaa kisee omaago see mée ena me ekaapa mokoo 'Ayaa nadogeamaai' see kasiyu ko ekaapa mokoo se kiya bedaa mee amoo taa mokoo aii yadogeamaai. ");
INSERT INTO auu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kaidimiyaa bagee yuwa daamaa maniino too, bedaa keedaa kaidimiyaa agiyoo miya se maneekee se, daamaa manii.\" ");
INSERT INTO auu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","\"Idukaa wegawoo seta menaa ena miya kisee: 'Aa kaepa kiyaa bagee kuwa epa kaai, aa ma yape kiyaa bagee kuwa be kaai' see wegawoo seta menaa mee ikii ipi kegea. ");
INSERT INTO auu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kiya eto ko Ni me kisiino menaa mee ko kisee: Ikii ma yape kiyaa bagee kuwa miya epa kaai, ikii kiwegee-wegee siyaa bagee yuwa miya sembahyang yataai. ");
INSERT INTO auu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ikii epoo to wodoo Ikiitaagi me yogaa yuwa kesea yoka okoo daamaa agiyoo yaukuwawoo taai. Ogatamee Wa me dimi daamaa bagee paagoo miya, dimi pedeo bagee paagoo miya uduma keno daamaa yamiyaabuu segee see, bedaa Wa me menaa yayeekee bagee paagoo miya, si yayeekee bagee paagoo miya uduma deka daamaa yawiyaabuu segee see yoka ikii me miya okoo epa kaai. ");
INSERT INTO auu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kisee ikii epa kigaayaa bagee yuwa too epa gaayu ko Ogatamee me ikii daamaa ukuwataa to mokoo da kineeyaa ye? Taa yoka epa nagaayaa bagee yuwa too epa see dimii mee se. Mee dimii mee ko pajak kepee yamasegee see bagee yuwa miya kisee dimii gaayaa. ");
INSERT INTO auu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bedaa kisee ikii aaepa kiyaa bagee yuwa too epao see aasee siyu ko mee esee daamaa agiyoo ye? Taa, apanaa aii tomaa kaa bagee yuwa me kisee aasee siyaa yoka ikii kiapaagee siyaa agiyoo ko taa, se maa? ");
INSERT INTO auu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kisee kemaata epoo to wodoo Ikiitaagi mokoo see see ikii miya kisee. Wa me ukuwayaa, peeyaa yuwa uduma pedeo ena ma taa, wa too ena yoka ikii miya Waa see see kaai.\" ");
INSERT INTO auu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","\"Ikii Ogatamee me menaa daamaa deewoo, yaukuwawoo siyaa kuwa ko koogo-koogo see yaukuwawoo taai, mée me nadeeta kaama naapaageesi naadi se ukuwaai. Ikii kisee mée me naapaageesi naadi ukuwayu ko daamaa agiyoo ukuwataa to mokoo da mee epoo to wodoo Ikiitaagi me ikii se kiniipi.\" ");
INSERT INTO auu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","\"Kisee kemaata ikii me daba bagee maniino agiyoo aii kisee manegee siyaa kuwa ko awee da kaa se manii, mée se ipi kiyaai. Dimi daamaa poga-poga see bagee yuwa okoo me kisee mée deebaa siyaa yoka ikii miya okoo see see se. Okoo me daba bagee aii maniino agiyoo maniino ko sembahyang segee see ee yuwa yiba miya, ebo etaawee miya kiyoo-kiyoo mée me nadeeta kaama naapaageesi naadi manegee siyaa. Anii mikee kisiino ko: Daamaa agiyoo ukuwataa to mokoo da mee okoo se masiipea, mée me yaapaagee siyaa kuwa too masiyaa, kaama taa. ");
INSERT INTO auu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kiya ikii me daba bagee aii maniino agiyoo maniyu ko ikii me dagi yagaa da me daamaa koo sepea yuwa kuwa eka yagaa da se ipi kiyaai, ");
INSERT INTO auu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","koogo-koogo see maniino too. Agaataagi mee kisee koogo ukuwata agiyoo kuwa deetaa see Mée yoka daamaa agiyoo ukuwataa to mokoo da kiniipi.\" ");
INSERT INTO auu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","\"Bedaa kisee miya ikii me sembahyang siyaa kuwa ko dimi daamaa poga-poga see bagee yuwa okoo me see see se ukuwaai. Okoo mée me nadiino ou naadi kaama sembahyang segee see ee yuwa yiba miya, ebo etaawee miya yiinaageeta sembahyang senaa siyaa yoka ikii miya okoo see see se. Anii mikee kisiino ko: Daamaa agiyoo ukuwataa to mokoo da mee okoo se masiipea, mée me yaapaagee siyaa kuwa too masiyaa, kaama taa. ");
INSERT INTO auu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kiya ikii me sembahyang segee taano kuwa ko koogo a me ee yiba peanta kene munitaata kaama se deeyaa Mée to Agaataagi mee paagoo koogo sembahyang taai. Agaataagi mee kuwa koogo ukuwataa see agiyoo kuwa uduma deetaa see Mée yoka daamaa agiyoo ukuwataa to mokoo da kiniipi. ");
INSERT INTO auu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ikii me sembahyang taano kuwa ko apanaa aii tomaa kaa bagee okoo me wegayaa see see mokoo se ukuwaai. Okoo me sembahyang menaa togoo yoka naadi nayiipi see gaayaa yoka ");
INSERT INTO auu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","kisee dimii se gaai. Ikii me asiino taa kaboo ikii me gaano pedeo agiyoo kuwa Ikiitaagi ipi yoka ikii miya okoo see see se ukuwaai. ");
INSERT INTO auu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kisee kemaata ikii kisee sembahyang taai: Epoo to wodoo Eboo, Iniitaagi, A ekaa da A too ebo kaekee. ");
INSERT INTO auu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A too ebo mée eetoowoo taatage kuwa mani mée yamiyaai. A me gaata-gaata kuwa too epoo to wodoo miya daamaa kaukuwawookea see see, magaa da kaa kiyoo miya kisee daamaa kaukuwawoosi yoka mée yaagoo kiyaai. ");
INSERT INTO auu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Eto kenaagoo naano agiyoo sikii-sikii mée manii. ");
INSERT INTO auu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Inii pedeo mée kiyaata bagee yuwa inii me epa ekeasiyaa see see, A me miya inii me pedeo yuwa epa mée yaekeasii. ");
INSERT INTO auu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bedaa inii mée gaadee see yoo mée peeyaakee se kiya paa me agiyoo kuwa beesekaa mée yaabagaai. Aa ko ebo too toowoo see Mée, Se-pesee, We-pesee yago Mée, asii-sege see Mée kisee too iminoo miya, iminoo miya. Amin. ");
INSERT INTO auu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kisee ikii pedeo kikiyaayaa bagee yuwa epa ekeasiyu ko epoo to wodoo Ikiitaagi me miya ikii me pedeo yuwa epa kiekeasiipi. ");
INSERT INTO auu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kiya ikii pedeo kikiyaayaa bagee yuwa epa se ekeasiyu ko Ikiitaagi me miya ikii me pedeo yuwa epa se kiekeasiipi.\" ");
INSERT INTO auu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","\"Ikii naano agiyoo tapoo toogee siyaa kaboo ebeyuma moumau senaa see se. Dimi daamaa poga-poga see bagee okoo kisee ukuwagee senaa siyaa. Apanaa bagee me 'Waa naano agiyoo tapoo toogeeki ii' see kuwa nanekeenta naapaageesi naadi okoo ebeyuma gakademaaii siyaa bagee yoka ikii okoo see see se. Anii mikee kisiino ko: Daamaa agiyoo ukuwataa to mokoo da mee okoo se masiipea, mée me yaapaagee siyaa kuwa too masiyaa, kaama taa. ");
INSERT INTO auu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kiya ikii naano agiyoo tapoo toogee siyaa kaboo ebeyuma daamaa uwo wetogetaa, edooyuu daamaa gekeetaa, kisee agiyoo ukuwagee taai. ");
INSERT INTO auu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ikii kisee ukuwayu ko mée me 'Aa naano agiyoo tapoo toogeeke ii' see kuwa se kanekeeniyaa, se deeyaa Mée Agaataagi Wa me too kisee kadeeta kaama kanekeeniyaa. Waa ko mée me koogo-koogo ukuwayaa agiyoo deetaa see Mée. A me daamaa agiyoo ukuwataa to mokoo da kaniipi.\" ");
INSERT INTO auu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","\"Magaa da kaa agiyoo-pagiyoo kuwa se kutuu taai, se maawoo taai. Magaa da kaa kiyoo dene-dene, wege-wege, kisee agiyoo agoo yoka pedeo kiyaa, oma maseekee bagee miya agoo see magaa yoka ");
INSERT INTO auu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ikii me ebo agiyoo kuwa magaa da kaa magaakee se kiya epoo to wodoo kiyoo too daamaa magaai. Kiyoo ko dene-dene, wege-wege, kisee agiyoo taa yoka se pedeo kiyaa, oma maseekee bagee miya taa see yoo yoka kiyoo too maawoo taai. ");
INSERT INTO auu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A me ou see gaayaa agiyoo kuwa kaa too dimi maayaa yoka daamaa nekeenii.\" ");
INSERT INTO auu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","\"Emaa masii to mee ko peto agoo da mokoo. A me emaa miya daamaa kiyu ko a me maa da yiba miya daamaa awee da kaa kiyaa. ");
INSERT INTO auu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Emaa miya pedeo kiyu ko má yiba miya digiyoo kiyaa. See kemaata ikii yiba awee mee miya digiyoo too kepa ko esee digiyoo aatakii umina ayaakogo-ayaakogo maadaa siyaa.\" ");
INSERT INTO auu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","\"Agiyoo yaokagee see mée ena me gaano, 'Mee ko ni me eboo, bedaa mee miya ni me eboo, ekea paaya' see gaayaa kiya taa, iyo. Ebo too see ekea wiya kiyu ko ebo ena mee be, ena mee epa, bedaa mena yayiino ko ebo ena mee mena yayeetaa, ena mee otoopa tayu. Mee mokoo miya ikii me 'Ogatamee mee miya ebo, kepe, kisee magaa da kaa agiyoo kuwa miya ebo, ekea paaya ebo, ekea paaya ou' see gaayaa kiya taa, iyo. ");
INSERT INTO auu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ebo ena too too yoka Ani me kisiino ko: Ikii me gaano pedeo agiyoo kaa se gaagaa taai. 'Inii maagiyoo naapea, inii maa da kaa maagiyoo magaapea?' see kuwa dimi se nagimaai. Kuwa agiyoo kuwa ebo agiyoo se. Naano agiyoo kuwa ebo maa diya peedi, dimi menaa da mee too ebo, bedaa doka kuwa ebo maa diya peedi, maa da mee too ebo, se maa? ");
INSERT INTO auu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Epaawee peenaa see bedoo kuwa deeweei. Okoo keepa weeno miya taa, poo ota daageeta kaama maagee ee yiba kutuu taano miya taa kiya epoo to wodoo Ikiitaagi me naano agiyoo daamaa manegeeki. Bedo kuwa peedi, ikii ma endagii taa see agiyoo kiya Wa me kisee daamaa manegeeki kemaata ikii miya daamaa kineewoo taapi, se maa? ");
INSERT INTO auu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Dimi gaagaa see kaa waa ekaato umiino, toono begaa togoo kiyaayaa bagee naa ena agoo ye? ");
INSERT INTO auu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Bedaa 'Anii doka taa kega yaai' see kuwa ikii kaasee kaa dimi gaagaa siyaa? Boo uwaa da kaa boo pui kuwa deeweei. Kuwa boo pui kuwa ukuwaano agiyoo miya taa, doka iyaakee miya taa ");
INSERT INTO auu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","kiya kuwa diino yago. Ani me kisiino ko: Salomo waa senawii ebo, wa me maagee seta dokaa kuwa diino daamaa kiya kuwa boo pui kuwa esee diino daamaa, Salomo me dokaa see see se. ");
INSERT INTO auu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kuwa boo kuwa ebo agiyoo se, eto kenaagoo iyata kaama tokoma mee da badegeeta biyaa kaa yuwitaayaa agiyoo kiya Ogatamee me diino daamaa yakiyaabuu see. Kisee kemaata Wa me ikii me dokaa kuwa miya kuwa boo kuwa asii esee daamaa kiagoo kiyaabuu siwoo taapi, se maa? Ikii dimi gaagaa naadi Ogatamee kaa dimi se maageekea bagee kuwa naa yaai. ");
INSERT INTO auu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","See keta yoo 'Inii maagiyoo naapea, inii maagiyoo magaapea?' see kuwa se gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kuwa dimii kuwa ko mée tomaa-tomaa uduma kisee gaagaa siyaa dimii yuwa. Ikii me gaano pedeo agiyoo uduma epoo to wodoo Ikiitaagi mee ipi yoka dimi gaagaa see se ");
INSERT INTO auu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","kiya ikii me 'Ogatamee Wa too ebo mée eetoono kuwa ou, Wa me gaata-gaata yuwa too yaukuwawoo taano kuwa ou' see dimii kuwa too gaawoo taai. Mee kaama ikii me gaano pedeo agiyoo uduma Wa me kineewoo taapi. ");
INSERT INTO auu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","See kemaata 'Tokoma kaasee ukuwaapea, maasee ukuwaapea' see kuwa se gaagaa taai. Tokoma taano kuwa tokoma too gaagaa siyaa. Egapii gakata dimi nagii-nagii siyaa agiyoo kuwa sikii yoka tokoma gaagaa siyaa yuwa kuwa eto kenaagoo se masii.\" ");
INSERT INTO auu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","\"Ikii me 'Waa kisee mée to, waa kisee apii to' see pedeo-pedeo see kuwa aseekee se. Ogatamee me ikii miya 'Aa kisee mée to, aa kisee apii to' see pedeo-pedeo see kuwa se kisisi naadi kisee se asii. ");
INSERT INTO auu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mee ko ikii me miya pedeo-pedeo see asiyaa see see Ogatamee me miya pedeo-pedeo see kisiitagi, bedaa ikii me miya mée wiginiyaa-wiginiyaa see see Ogatamee me miya kisee kiwigineatagi yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ikii me apanaa bagee emaa togoo maga ponee peedii to yadeetaa see kiya kaasee kaa aa ekaato emaa togoo piya tukuu to ebo mee nekeeniino taa ya? ");
INSERT INTO auu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kaasee a me apanaa bagee ena asiino, 'Meede, a me emaa togoo maga ponee peedii to mee kamaseepeasiinaka' see asiyaa kiya aa ekaato emaa togoo ebo mee piya tukuu to mee topa ya? ");
INSERT INTO auu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yaai, aa mée deebaa see mée to, aa ekaato emaa togoo piya tukuu to mee keta badeepeasii, kaama too aa diino keago kaape yoka apanaa bagee emaa togoo maga ponee peedii to mee yamaseepeasiyaa. ");
INSERT INTO auu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ogatamee kaa agiyoo kameno se manii, nakaa-me naadi kago kigoemaayaa yoka, bedaa a me mutiara keepa yuwa, kisee daamaa agiyoo kuwa miya ekena yumaa to kaa si yadogeamaai, bado me batagi-patagi taapea yoka nekeenii.\" ");
INSERT INTO auu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","\"Idimiweei, ikii masiipea nao. Abaweei, ikii deemagaapea nao. Kenee to kaa tugu-tugu siweei, kene kikabaapi nao. ");
INSERT INTO auu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kuwa ko idimiyaa bagee yuwa uduma masiyaa, abayaa bagee yuwa deemaayaa, kenee to kaa tugu-tugu siyaa bagee yuwa kene yakabataayaa. ");
INSERT INTO auu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kisee ikii me yogaa me namo kiidimiyu ko omaa to maniyaa ye? ");
INSERT INTO auu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Doge kiidimiyu ko doge se kiya otoogiyoo maniyaa ye? ");
INSERT INTO auu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kisee taa. Ikii dimi pedeo see bagee kiya ikii me yogaa yuwa kisee daamaa agiyoo manegee siyaa. Ikii me yogaa yuwa daamaa agiyoo maniino ipi maa diya epoo to wodoo kaama Ikiitaagi me kineewoo siyaa agiyoo kuwa mee asii esee daamaa, Waa idimiyaa bagee yuwa mikee daamaa agiyoo too maniyaa. ");
INSERT INTO auu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ikii me mée me kisee naukuwagea naaki ou see gaayaa agiyoo kuwa ikii miya apanaa bagee yuwa paagoo daamaa pee-yaukuwaai. Mee mena kamuu da mee ko Musa me ebeamaata menaa ma, nabi bagee me menaa ma uduma semoo to ko mee mena kamuu da mee too.\" ");
INSERT INTO auu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","\"Ikii sipi see kenee to taa pakaaniweei. Pedeo kiyaa yoo peegee see kenee to mee ebo, etaa da miya kapo ebo yoka mee etaawee poono bagee mée eebaa ");
INSERT INTO auu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","kiya iminoo miya, iminoo miya toono yoo pakaaniino kenee to mee sipi, etaa da miya kapo peedi yoka mée peenaa too deemaayaa.\" ");
INSERT INTO auu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","\"Nabi poga-poga bagee meepea yoka ipiipi dii. Okoo domba ebeyuma mokoo dimi dabaa poga-poga siyaa see deeyaa kiya dimi yiba mée daano see naadi kiikii siyaa kamenoo mokoo. ");
INSERT INTO auu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Okoo me koo siyaa agiyoo yuwa deeyaa naaki mikee, kisee dimii yago bagee ii see kuwa awee da kaa yanekeeniyaa. Takuu yago piyaa kaa anggur poo daayaa ye? Takuu yago boo kaa ara poo daayaa ye? ");
INSERT INTO auu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Taa. Daamaa piya wodoo to kaa daamaa poo ekayaa, pedeo piya wodoo to kaa pedeo poo ekayaa. ");
INSERT INTO auu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Daamaa piya wodoo to kaa pedeo poo se ekayaa, pedeo piya wodoo to kaa daamaa poo se ekayaa. ");
INSERT INTO auu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Daamaa poo se ekayaa piyaa yuwa kuwa uduma kobegeeta kaama biyaa kaa yuwitaayaa. ");
INSERT INTO auu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kisee kemaata kuwa nabi poga-poga bagee okoo me ekayaa poo kuwa daamaa ye, pedeo ye see yanekeeniino kuwa okoo me koo siyaa agiyoo yuwa kaa yanekeeniyaa.\" ");
INSERT INTO auu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","\"Ogatamee Wa too ebo mée eetoowoo siyaa yoo seemiyaayaa kuwa ko 'Tuhan, Tuhan' see ekaa nawee-wee see bagee kuwa uduma se kiya epoo to wodoo Neataagi me gaata-gaata yuwa yaukuwawoo siyaa bagee kuwa too seemiyaayaa. ");
INSERT INTO auu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wodopasi naagoo mée eebaa me Ni paagoo nasiitagea menaa ko 'Tuhan, Tuhan, inii A ekaa da kawee-wee naadi A me menaa kaweganaa seke, se maa? Inii A ekaa da kawee-wee siyaa naaki paa yuwa peedaa sekea, se maa? Bedaa inii A ekaa da kawee-wee siyaa naaki dimi nagii-nagii agiyoo eebaa agoo kedaa seka, se maa?' see nasiitagea kiya ");
INSERT INTO auu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ani me awee da kaa asiita menaa ko 'Anii ikii kiewo see bagee yuwa, pedeo ukuwagee see bagee yuwa too kideega yoka peeweei' see asiita.\" ");
INSERT INTO auu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","\"Ni me menaa daamaa nayeewoo, naukuwawoo siyaa bagee kuwa ko dimi ipi see bagee me oma dagii da kaa ee daamaa maataayaa mokoo. ");
INSERT INTO auu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ee maataata kaama ebo dekaa wega, uwo degaga, ebo boo wuupu-waapu naadi ee to kaa meanega naaki ee to oma dagii da kaa daamaa maataata yoka bogoa se peeyaa. ");
INSERT INTO auu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kiya Ni me menaa yeegea kiya se ukuwayaa bagee kuwa ko dimi taa bagee me ea dagii da kaa ee maataayaa mokoo. ");
INSERT INTO auu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ee maataata kaama ebo dekaa wega, uwo degaga, ebo boo wuupu-waapu naadi ee to kaa meanega ko ee to umina bogoata peega siyaa, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus me kuwa mée topeta menaa yuwa uduma wegataayaa naaki kiyoo yiitookea bagee yuwa dimi nagimegea, ");
INSERT INTO auu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wa me mée tupiino ko omaago yoka, Musa me menaa mée topetaa see bagee me mée topetaa siyaa see see se. ");
INSERT INTO auu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus maga kutuu to kaa kaama eseemaayaa naaki mée eebaa Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kuwa kaboo da mée ena, bado yagaa kuwa esee pedeo abuu me daa-noota see mée Yesus paagoo meemaata kaama mumo maga kaa esee-ekeasigi. Wa me asiino, \"Neataagi, Aa ede kepa ko ni me abuu kuwa A me nataa kiyaayaa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus me wa kaa yagaa pe-maataata kaama \"Daamaa, a me abuu kuwa taa kaai\" asigi naaki taka ena abuu kisee ki taa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesus me asiino, \"Ani me abuu kataa kiyaaga kuwa mée se asii. Aa koogo peedoota imam bagee paagoo pooi, okoo me daamaa ipiipi kadeesi ke. Abuu kuwa mikee taa kega ii see kadeegea kaboo Ogatamee paagoo kupi-maniino agiyoo kamanisi naadi doo-pooi, idukaa Musa me 'Kisee ukuwaai' see wegata see see. Mée me 'Aa mikee eto abuu taa kega ii' see kuwa kanekeensi naadi kuwa uduma pe-ukuwaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesus peedoota Kapernaum magaa kaa peemaagi too ko Roma kaa bagee eboo ena, okaa yago bagee me eboo tupi. Waa Yesus paagoo meemaata kaama maamaa aseekee kaa ");
INSERT INTO auu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","\"Neataagi, ni me agiyoo naokagee see mée waa ee yiba komoo da kaa oogimaata boodi ebo ketaaki\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus me asiino, \"Daamaa, yataa kiyaano see naadi meenaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kiya mee mée to me asiino, \"Neataagi, anii sikii taa yoka Aa ni me ee yiba nameekee se. A me mena ena too too nawegatagaai, mee ikiyoo mikee taa kaapi. ");
INSERT INTO auu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mee ko ani asii eboo miya agoo. Okoo me menaa anii yayiino too, bedaa ani miyoo okaa yago bagee miya topea. Ni me menaa okoo miya nayiino too. Kisee ani me mée waa ena 'Pooi' see asiyu ko waa peeyaa, bedaa mée ena ma 'Meei' see asiyu ko miyaa. Anii ni me agiyoo naokagee see bagee paagoo miya 'Kuwa agiyoo kuwa naukuwaai' see asiyu ko naukuwataa see. Aa miya kisee asiyaa see Mée yoka A me mena me too sikii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus me kuwa menaa yeeta kaama dimi nagimaano ebo kaa Wa sekaataa bagee yuwa asiino, \"Anii mikee kisiino ko: Mee mée mee wa too esee miya nao see nagaataa see mée. Israel bagee kuwa mee see see mée ena ma Anii diino taa, Anii ewo. ");
INSERT INTO auu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ani me kisiino ko: Iminookaa Ogatamee Wa too ebo mée eetoowoo taatagi yoo apanaa tomaa kaa bagee yuwa mée eebaa ede ma, ede ma noogee taano see naadi meetagea. Okoo awii yaato kaama miya, uwaa yaato kaama miya medaa naadi kaama Abraham ma, Isak ma, Yakub ma epo enaataa naano agiyoo noogee yoo animaaii taatagea. ");
INSERT INTO auu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel bagee okoo miya kiyoo epo enaataa noogee siyaa kiya okoo mée eebaa kuwa maayoo kaa digiyoo yiba tameeyamoo taatagea. Kiyoo ko yege ma, gaagaa ma too totaa see yoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kiyoo kaama Yesus me mee okaa yago bagee me eboo asiino, \"Aa koogo pooi, a me mikee gaape-gaape ukuwaaniipa yoka\" see asigi. Taka ena kuwa kaboo da taa ko wa me agiyoo yaokagee see mée to wa kaa meanta agiyoo taa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus peedoota Petrus me ee kaa peemaata kaama deamaagi too ko Petrus me apimee baayo wa me omegee yoo tani ma ikiyoo meanta topa. ");
INSERT INTO auu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mee apii yagaa da kaa peneasigi naaki ikiyoo taa keepeasega. Taa kega naadi anoogeeta naano agiyoo mée yuwa manega. ");
INSERT INTO auu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Uwaataa da yaato paa yago bagee mée eebaa Yesus paagoo eemedaakea. Wa me mena kamu ena too too wegataagi naaki paa yuwa peegea, bedaa ikiyoo meanta bagee yuwa uduma miya ikiyoo yataa kiyaabuuki. ");
INSERT INTO auu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wa me ikiyoo yataa kiyaabuuki mee ko idukaa nabi Yesaya me wegata menaa uwa daaga yoo. Kuwa menaa kuwa ko kisee: \"Inii dabaa mée kiyaayaa agiyoo kuwa Wa me mée yadogeamoo siyaa, bedaa inii kaa meanee siyaa yuwa kuwa miya Wa me mée yataa kiyaayaa\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesus mee Wa geboo da kaa mée eebaa Waa bobetaata topea see deeta kaama Wa me topenaa see bagee yuwa asiino, \"Piku asii yaato pookee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Poono see kaboo Musa me menaa mée topetaa see mée ena migi. Wa me Yesus asiino, \"Guru, A me peenaa, omenaa taape kuwa uduma anii miya A sekaataa too peenaa, omenaa taapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kiya Yesus me asiino, \"Woda miya umiino yoo agoo, bedo miya geka agoo kiya Mée Yogaa mee omegee see yoo taa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kiyoo kaama Wa me topetaa see bagee waa ena me asiino, \"Tuhan, neataagi mee boota kaama daamaa ogo maataata asii too A sekaataa meekee naa daamaa ye?\" see asigi ");
INSERT INTO auu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","kiya Yesus me asiino, \"Eto kiipaa Ni sekaataa nameei, boota bagee kuwa boota bagee me ogo aamagaasi yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus mee komaa da kaa pakaanta kaama Wa me topenaa see bagee yuwa ma epo enaataa peedoota ");
INSERT INTO auu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","uwo pikuu da taa peetaaki too ko bo ebo mega. Biku-biku miya ebo kega naaki komaa da kaa wogeedapiika kiya Yesus Waa toomoo umpi. ");
INSERT INTO auu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wa me topenaa see bagee yuwa yaai naadi Yesus maanegea. \"Ei, Tuhan, inii uwo poonakea yoka Aa mée eedii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus me asiino, \"Ikii dimi Ni kaa namagaano taa see bagee yuwa nao, kaasee kaa wedaagea ya?\" see asigi. Waa anoogeeta \"Koogo sikiinii\" asigi naaki bo siki, biku-biku taa kega. ");
INSERT INTO auu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Okoo dimi nagimaano ebo kegea. \"Mee kaasee Mée? Biku-biku, bo kisee agiyoo kuwa Wa me menaa yayiino too\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Piku asii yaato Gadara magaa kaa peemaaga too ko paa agoo see bagee wiya topea. Ekea omaago yoka mée kitaa poono wedaagea. Ekea mée ogopa beapa kaama Yesus paagoo meemaagea. ");
INSERT INTO auu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ekea me mena ebo kaa asiino, \"Ei, Ogatamee Yoopaa, Aa ma inii mapea menaa agoo? Ogatamee me mée wigintagaatagi monaa da kaa pakaamagaano taa kaa kiya A me inii yaai-yaai ma, boodi ma mée kiyaano see naadi mege ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kuwa kaboo da woo kaa naa kaa ekena eebaa ebo etaa maga notaakea. ");
INSERT INTO auu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Paa yuwa me maamaa aseekee kaa \"A me mée abagaano see dimii gaape ko inii kuwa ekenaa kuwa yiba pakaa-seemaanake yoka kitaa mée peeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus me \"Peeweei\" asigi naaki paa yuwa kuwa mée wiya yiba kaama peedaa naadi ekena yuwa yibaa taa pakaa-seemedaakea. Seemedaa naadi kaama ekena yuwa egoowee gidumedoota piku yiba dugumedaakea. ");
INSERT INTO auu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kiyoo ekena munitaa see bagee yuwa yaai naadi kuwa ekenaa yuwa ukuwaanega menaa yuwa ma, kuwa paa yago bagee wiya ukuwaanega menaa yuwa uduma doodoota mee magaa kaa bagee paagoo eewegagea. ");
INSERT INTO auu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mee magaa kaa bagee uduma Yesus diino see naadi medaakea. Yesus paagoo meemaata kaama maamaa aseekee kaa \"Inii me magaa kaa kiyoo Aa se naatooi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus peedoota komaa taa naadi piku asii yaato Wa me magaa kaa peemaayu. ");
INSERT INTO auu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kuwa kaboo da oogimaata bagee ena wa me omegee see keagee da ma doodoota Yesus paagoo doomegea. Yesus me okoo mikee nagaano dimii mee ebo ii naadi kaama Wa me mee oogimaata mée to asiino, \"Niyoopaa, dimi se gaagaa taai. A me pedeo yuwa uduma epa kaekeasega. Eto ko aa Ogatamee ma menaa kuwa taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Musa me menaa mée topetaa see bagee noonaa kuwa menaa yuwa yiitookea. 'Yaai, kaasee menaa weegi ya? Kuwa Ogatamee me be kiyaa menaa' see koogo dimi yiba gaagea. ");
INSERT INTO auu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Okoo me gaagea dimii kuwa Yesus me nekeenta kaama asiino, \"Ikii koogo dimi yiba pedeo see dimii nagaagea kuwa kaasee kaa ya? ");
INSERT INTO auu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ani me mee oogimaata mée to paagoo 'A me pedeo yuwa epa kaekeasega yoka eto ko aa Ogatamee ma menaa kuwa taa' see menaa mee miya wegayaa, bedaa 'Anoogeeta daamaa peenaa taai' see menaa mee miya wegayaa, ekea paaya. ");
INSERT INTO auu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kiya Mée Yogaa mee Wa me magaa da kaa bagee yuwa okoo Ogatamee ma menaa yuwa mikee yataa kiyaayaa ii see kuwa ikii nanekeensea naadi agiyoo ena kideeyaanaka\" see asigi. Kiyoo kaama Wa me mee oogimaata mée to asiino, \"Eto ko anoogeeta a me ometaa see keagee da masegeeta ee kaa pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mee mée to anoogeeta wa me ee kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kiyoo deegea bagee yuwa uduma wedaagea. Ogatamee Wa me mée tomaa yuwa paagoo kisee pesee see agiyoo mée manigi nao naadi Ogatamee yaapaageekea. ");
INSERT INTO auu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus peedoota amo kaa naa kaa deamaagi too ko mée ena ekaa da ko Matius mee tupi. Waa pajak kepee yamasegee see mée. Wa me kepe masegee yoo animaata totaaki. Yesus me \"Ni sekaataa nameei\" asigi naaki yiinaageeta Wa sekaataa peegi. ");
INSERT INTO auu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wa me Yesus badaa maadoota wa me ee kaa eepeegi. Eepeemaata kaama naano agiyoo epo eenotaaki too ko mée eebaa megea. Pajak kepee yamasegee see bagee yuwa ma, apanaa dimi pedeo bagee yuwa ma okoo mée eebaa animaaii naadi Yesus ma, Wa me topenaa see bagee yuwa ma naano agiyoo epo enaataa notaakea. ");
INSERT INTO auu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi kaa bagee okoo noonaa me okoo kisee notaakea see kuwa deegea. Okoo me Yesus me topenaa see bagee yuwa asiino, \"Ikii mena kitopetaa see Mée mee pajak kepee yamasegee see bagee ma, apanaa dimi pedeo see bagee ma okoo paaya enaataa naano agiyoo notaakea kuwa yaai, kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus me kuwa menaa yeeta kaama asiino, \"Ikiyoo taa see bagee kuwa ikiyoo yadeetaa see bagee paagoo se peeyaa kiya ikiyoo yago bagee kuwa too peeyaa. ");
INSERT INTO auu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ogatamee me kapogee yiba Wa me wegata menaa ena mee ko kisee: 'Ikii mée epa kaano kuwa Anii ede, agiyoo nakupi-manee taano kuwa be' see menaa ebeamaata yoka ikii me 'Mee menaa mee mena nekeeniino yaato kaasee, kaasee?' see daamaa ipiipi gaagaa taai. Anii meta mee ko Ogatamee me menaa yayeetaa see bagee yuwa mena ogaano see naadi se kiya dimi pedeo bagee kuwa Ni sekaataa misi naadi meta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kuwa kaboo da Yohanes me topetaa see bagee yuwa Yesus paagoo meemaata kaama asiino, \"Naano agiyoo tapoo toogee siyaa kuwa inii miya ukuwagee see, Parisi kaa bagee okoo miya ukuwageekea kiya A me topenaa see bagee yuwa se ukuwageekea kuwa kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus me asiino, \"Api goeano naagoo naano agiyoo notaa siyaa kaboo paimee ma enaataa tuyaa bagee yuwa naano agiyoo se nota yegee siyaa ye? Taa kiya mee api goeyaa mée to waa amoo-doge-doge taapea naagoo kaama wodoo too wa me bagee yuwa naano agiyoo tapoo toogee taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","\"Gipii dokaa ponee to, uwo wetogeano taa see doka ponee to mee masegeeta kaama nuku see dokaa tokogoo da kaa pee-se kiwiyaa. Kisee kiwiyu ko mee nuku see dokaa da mee geanta tokogoo ebo kedaa siyaa. ");
INSERT INTO auu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bedaa anggur poo uwoo kuwa otaawee yiba wogeawee siyaa kuwa miya kisee. Gipii see anggur poo uwoo gaayu ko nuku see otaawee yiba se wogeawee siyaa. Kisee wogeawee siyu ko mee nuku see otaawee da mee kipuunta kaama anggur poo uwoo miya goedoo peeyaa, otaawee da miya pedeo kiyaa. Kisee kiyaa naadi gipii see anggur poo uwoo kuwa gipii see otaawee yiba too wogeawee siyaa. Kisee ukuwayu ko uwo miya, otaawee da miya ekea paaya daamaa kiyaa\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus kuwa menaa wegataaki too ko sembahyang segee see ee kaa eboo ena Yesus paagoo migi. Waa mumo maga kaa esee-ekeata kaama asiino, \"Niyoopane eto kenaagoo booga kiya A me wa kaa yagaa pee-yamaataata kaama aya andoo peesi yoka meei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus yiinaageeta Wa me topenaa see bagee yuwa ma mee mée to sekaataa peetaaka too ko ");
INSERT INTO auu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","api ena, tahun gaasi ma wiya kisee too tadaa too peegee see apii Yesus oko yaato kaama Wa me doka otoo to pee-yaadeega. ");
INSERT INTO auu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wa me dimi yiba gaano, 'Kisee anii Wa me dokaa da pee-yaadeega kepa ko mee agiyoo taa kaapa yoka' see gaaga. ");
INSERT INTO auu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yayaadeega naadi Yesus me ikigi pe-maataata kaama deeyaa naaki apii to topa. \"Niyoopane, aa se gaagaa taai. A me mikee nagaano dimii mee me a kaa meanee taa see agiyoo taa kega, daba daagimaa peege\" see asigi naaki kisee ki mee agiyoo taa kega. ");
INSERT INTO auu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Muguu naadi sembahyang segee see ee kaa eboo me ee kaa peemaata deamaagi too ko mée eebaa yoga bootaa da kaa puusee, yegee seamoo taakea. ");
INSERT INTO auu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesus me asiino, \"Ikii uduma amoo maa kaa pooi. Mee yogaa mee boopa se, toomoo ompa ke\" see asigi kiya okoo yakeakea. ");
INSERT INTO auu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yesus me kuwa bagee yuwa yoo da kaa abagakomeeta kaama yogaa to topa komoo to kaa pakaanta wa me yagaa da pe-peneasigi naaki aya andoo peega. ");
INSERT INTO auu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mee menaa da kiyoo-kiyoo eeweganaa seta. ");
INSERT INTO auu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus muguu naadi peetaaka too ko emaa digiyoo see bagee ekea wiya Waa peegi-peegi uuto ebo menaa kaa asiino, \"Ei, Daud ma apaa kaa Mée, Aa epa mée gaai, epa mée gaai\" see asepegeekea. ");
INSERT INTO auu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus ee ena yiba pakaaniyaa naaki kuwa mée wiya miya pakaanegea. Yesus me asiino, \"Ani me ekea emaa daamaa kikiyaayaa kuwa mikee nagaagea ye?\" asigi naaki \"Tuhan, enaa mikee kagaage\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wa me ekea emaa masii to kaa yagaa yamaataata kaama asiino, \"Ekea me mikee nagaano dimii mee me ekea me ou see gaagea yuwa ukuwaaniipa\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","emaa diino keago kegea. Wa me asiino, \"Kuwa Ani me emaa daamaa kikiyaaga kuwa mée se asii\" see asigi ");
INSERT INTO auu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","kiya ekea me kuwa kisee mée yakoo sipi menaa kuwa mee magaawee da uduma kiyoo-kiyoo ogo peeyaagea. ");
INSERT INTO auu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kuwa mée wiya pe-seomegea kaboo mée ena Yesus paagoo eemegea, paa me peneata kaama mena wegaano naka see mée to. ");
INSERT INTO auu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus me paa yaabagaapeasigi naaki mena wegaano keago kigi. Kiyoo bagee mée eebaa dimi nagimegea. \"Sooi, kisee agiyoo kuwa inii Israel magaa kaa diino taa agiyoo\" see wegagea ");
INSERT INTO auu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","kiya Parisi kaa bagee yuwa me wegaano, \"Taa, Waa paa me eboo tawata kaama too paa yuwa yaabagaapeasiyaa\" see menaa yawegagea. ");
INSERT INTO auu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus mee ebo magaa kaa miya, peedi magaa kaa miya peenaa naadi kaama sembahyang segee see ee yuwa yiba mée topetaa, Wa me daamaa etokaa doometa menaa, Ogatamee Wa too ebo mée eetuyaa menaa kuwa eewegataa, bedaa ikiyoo meanee see agiyoo tomaa-tomaa eebaa kuwa miya yataa kiyaabuu see, kisee agiyoo ukuwanaa segeeki. ");
INSERT INTO auu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wa me kuwa mée eebaa deeta kaama epa nao see gaagi. Domba wodaa tabaa da domba munitaa see mée taa kaa domba weda, gaagaa siyaa see see okoo miya kisee bagee yuwa yoka naadi okoo epaagi. ");
INSERT INTO auu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yesus me Wa me topenaa see bagee yuwa asiino, \"Bugi kaa agiyoo kapoo, maamaa pudii kiya abaano bagee eebaa taa yoka ");
INSERT INTO auu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","bugi epoo Mée me Wa me bugi kaa agiyoo abaano bagee eebaa peeyaasi naadi asegee taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus me Wa me topenaa see bagee gaasi ma wiya \"Meei\" asigi. Meemaagea kaboo Wa me pesee agiyoo mantayu, kuwa ko paa yuwa yaabagaapeasi naadi ma, bedaa mée kaa meanee see agiyoo tomaa-tomaa yuwa yataa kiyaabuusi naadi miya mantayu. ");
INSERT INTO auu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kuwa mena yadoonaa taano bagee gaasi ma wiya kuwa ekaa yuwa ko kisee: petamanii Simon, Petrus see ekaa miya muntaata mée, menaamee Andreas, Zebedeus yoopaa Yakobus, menaamee Yohanes, ");
INSERT INTO auu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipus, Bartolomeus, Tomas, pajak kepee yamasegee see mée Matius, Alpeus yoopaa Yakobus, Tadeus, ");
INSERT INTO auu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","yape tukuu mée Simon, bedaa Yudas Iskariot, Yesus ekegataata kepe masiipi mée. ");
INSERT INTO auu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kuwa mée gaasi ma wiyaa to kuwa Yesus me peenaa siyaano taa kaboo aseta menaa kuwa ko kisee: \"Ikii apanaa tomaa kaa bagee me magaa kaa taa se pooi, Samaria bagee me magaa kaa taa miya se pooi. ");
INSERT INTO auu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel bagee yuwa, egadaa seta domba wodaa mokoo bagee okoo paagoo too pooi. ");
INSERT INTO auu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ikii peenaaki too 'Ogatamee Wa too ebo mée eetoono kuwa ekaapa yoka' see asenaa taai. ");
INSERT INTO auu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ikiyoo meanta bagee yuwa ikiyoo yataa kiyaabuu taai, boota bagee yuwa aya andoo peeyaabuu taai, esee pedeo abuu meanee see bagee yuwa abuu yataa kiyaabuu taai, paa yago bagee yuwa paa yaabagaapii taai. Ikii miya aii masegea yoka ikii me miya aii kisee manii. ");
INSERT INTO auu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Emas, perak, tembaga, kisee kepee toma ena ma se dogaai. ");
INSERT INTO auu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ayaabu kea, doka kapo wiya, bado doko, tamo, kisee agiyoo kuwa miya se dogaai. Ikii agiyoo tapoo peenaa taapea kuwa ko agiyoo yaokagee see bagee okoo me gaano pedeo agiyoo daamaa masiyaa see see ikii miya daamaa masiipea yoka se gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ikii mée tuyaa magaa kaa peemaata kaama kiyoo ikii daamaa badaa kimaayaa bagee abaai. Abamaata kaama mee ee kaa too eeomegee, toogee taai, apanaa magaa kaa peeyaa naagoo too pooi. ");
INSERT INTO auu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kiyoo magaa kaa ee yuwa yiba pe-seemaano kaboo 'Epao, ikii Ogatamee ma emee-emee kisiyaasi yoka' see keta asii. ");
INSERT INTO auu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Okoo me daamaa badaa kimaayu ko kuwa ikii me okoo Ogatamee ma emee-emee siyaasi naadi menaa kuwa mee ee kaa bagee paagoo daamaa toopa. Kiya ikii badaa se kimaayu ko mee menaa bedaa ikii yaato metaki meepa. ");
INSERT INTO auu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kisee ee ena kaa bagee me ikii badaa kimagaano miya be, ikii me eewegayaa menaa miya be kiyu ko poono kaboo ikii badoo da kaa maga ponee yuwa takadekumii. ");
INSERT INTO auu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Anii mikee kisiino ko: Ogatamee me mée wigintagaatagi naagoo mee magaa kaa bagee okoo kaa pedeo yadootagaatagi agiyoo kuwa mikee ebo kaata, apanaa magaa kaa bagee yuwa see see se. Mee naagoo Sodom magaa kaa bagee ma, Gomora magaa kaa bagee ma okoo kaa pedeo yadootagaatagi agiyoo ebo kaata kiya kuwa eto ikii kibe kaapea bagee kuwa okoo kaa pedeo yadootagaano kuwa ko mee asii esee ebo kaata.\" ");
INSERT INTO auu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","\"Daamaa yii. Domba wodaa yuwa woda nookee kamenoo yuwa paagoo peeyaa mokoo Anii ikii pooi see kisega yoka okoo paagoo peemaata kaama ipiipi gaamagaai, dimi ipi see otoogiyoo mokoo daamaa nekeenii. Deme see bedoo mokoo miya okoo paagoo dimi adumaai, kuwa dimii ekea paaya doonaa taai. ");
INSERT INTO auu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ikii kibe kiyaa bagee agoo kaata yoka gaai, nekeenii. Okoo me ikii yagaa kipeneata kaama mena pekataa see bagee yuwa paagoo kidogeamoo taatagea, sembahyang segee see ee yuwa yiba miya pepeaduu me kidakamaatagea. ");
INSERT INTO auu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ikii Ni yaato bagee kemaata magaa da kaa ebo tookee bagee yuwa paagoo kiipootagea. Kisee ikii kiipeeyaa kaboo okoo ma, Ogatamee ewo see tomaa kaa bagee yuwa ma okoo uduma paagoo Ni me menaa daamaa eewegaai. ");
INSERT INTO auu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Okoo me ikii kipeneata kiipeeyaa kaboo 'Anii kaasee menaa wegaapa, kaasee menaa wegaapa?' see dimii kuwa se abaai. Ikii mena wegaano kaboo 'Kisee wegaai, kisee wegaai' see dimii kuwa ikii daamaa ipi kaapea. ");
INSERT INTO auu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ikii me wegaapea menaa kuwa ikii me wegaapea se kiya Ikiitaagi Wa me Roh me ikii kisi-manee taapi yoka se gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bedaa kuwa kaboo da taa miya kisee ukuwaaniita: Ekea kenaaya kiya ena mee wugimaasi naadi ekegatagaatagi, nagamee me wa me yogaa to ekegatagaatagi, bedaa yogaanii yuwa me okonaka wugimaasi naadi ekegatagaatagea. ");
INSERT INTO auu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ikii Ni yaato bagee kemaata mée uduma kibe kaatagea kiya ikii makii taa, kisee too wodopasi yaato toowoo siyaa bagee kuwa daba daagimaa pootagea. ");
INSERT INTO auu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kisee maga ena kaa bagee me ikii kibe kegea gaayu ko maga ena kaa oogaai. Anii mikee kisiino ko: Israel magaa uduma peenaa semagaano taa see kaboo Mée Yogaa mee meetagi.\" ");
INSERT INTO auu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","\"Mena topetaa see bagee kuwa ebo, okoo me mena topetaa siyaa mée to mee peedi see kuwa taa, bedaa agiyoo yaokagee see bagee yuwa ebo, okoo me eboo mee peedi see kuwa miya taa. ");
INSERT INTO auu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mena topetaa see bagee yuwa me gaano, 'Ni me mena topetaa siyaa mée to mee anii waa see see naaki daamaa' see gaayaa. Bedaa agiyoo yaokagee see bagee yuwa miya kisee gaayaa. 'Ni me eboo mée me daamaa-daamaa kookea kuwa anii miya kisee nakookea naaki daamaa' see gaayaa. Kiya ikii gaayu ko mée me pedeo-pedeo kitaapea. Kuwa ko mée tukuguu to nagamee ebo maa diya kisee mée me nagamee paa ekeata Beelzebul see ekaa muntaagea kepa ko wa me yogaa yuwa uduma ekaa muniino mee asii esee pedeo see ekaa munitagaapea. ");
INSERT INTO auu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kisee kemaata kisee bagee kuwa ikii se wedaai. Eto dapimemaata menaa kuwa uduma awee da kaa kedaa taapa, bedaa koogo boonemaata menaa yuwa uduma miya ipi kiyaabuu taapea yoka ikii weda taa. ");
INSERT INTO auu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ani me digiyoo yiba kaama kisiyaa menaa kuwa egapi yaato awee da kaa naweganaa taai. Bedaa Anii koogo ebe kaa menaa, poko kaa menaa kaa kisiyaa yuwa kuwa miya mena ebo kaa awee da kaa nawegakumii. ");
INSERT INTO auu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Má yaato wugimaayaa bagee kuwa dimi mena yaato se wugimaayaa yoka okoo se wedaai. Wedaano ko Ogatamee Wa too wedaai. Waa ko dimi mena yaato ma, má yaato ma enaataa neraka biyaa yiba mée tameepeasiyaa see Mée yoka mée kuwa wedaakee se. ");
INSERT INTO auu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mugipo daaya see bedoo mee aii agiyoo, esee peedi, imi wiya waa naa enaataa kepe peedi masiyaa agiyoo da, se maa? Mikee kiya bedo ena booyaa mee Ikiitaagi Wa me gaata-gaata doodoo too booyaa. ");
INSERT INTO auu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bedaa ikii edooyuu apa uduma miya Wa me daamaa kiegamaata. ");
INSERT INTO auu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kisee kemaata se wedaai. Ikii ebo, apanaa agiyoo see see se, mugipo daaya see bedoo maamaa eebaa kiyaa miya ikii ma endagii se, kisee Wa me ikii kigaataa see yoka mée se wedaai. ");
INSERT INTO auu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Okoo mée paagoo weda taa ma 'Anii Yesus sekaataa bagee' see asiyaa bagee kuwa Ani me miya epoo to wodoo Neataagi paagoo 'Waa ko Ni sekaataa nameeno weda taa see mée yoka' see yawegaata. ");
INSERT INTO auu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kiya okoo mée paagoo Anii nawisintaata 'Yesus mee anii ewo' see nawegayaa bagee kuwa Ani me miya wisintaata epoo to wodoo Neataagi paagoo 'Mee ko Anii ewo see mée yoka' see yawegaata.\" ");
INSERT INTO auu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","\"Anii magaa da kaa mée tomaa uduma aaemee-emee siyaano see naadi meta see dimii mee se nagaai. Anii mée aaemee-emeesi naadi menaa doomega se kiya mée aapekadaasi naadi meta. ");
INSERT INTO auu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mee ko paayogaa to ma, nagamee ma ekea aawisii taapea, ukuyogaa to ma, okooto ma ekea aawisii taapea, apimee ma, paimee baayo ma ekea aawisii taapea, kisee aapekadaasi naadi meta. ");
INSERT INTO auu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mikee, yape masiyaa bagee kuwa apanaa bagee se kiya ena ee kaa bagee yuwa miya aayape kaapea. ");
INSERT INTO auu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ni sekaataa nameeno kuwa ko okonaka epa kaano kuwa ebo, Anii naepa mee peedi see gaayaa bagee kuwa sikii taa, Ni sekaataa se namiyaa. Bedaa yogaanii yuwa okoo epa kaano mee ebo, Anii naepa mee peedi see gaayaa bagee kuwa miya Ni sekaataa nameeno iyo, sikii taa. ");
INSERT INTO auu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bedaa piya boko ma dootaata Anii naobeedoota booyaa yoo poono be see bagee kuwa miya Ni sekaataa bagee kaano iyo, sikii taa. ");
INSERT INTO auu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Okoo ekaato koogo daba toono see naadi okoo me gaayaa-gaayaa yuwa kaa too umiwoo, toowoo siyaa bagee kuwa usiyaato ko umina pedeo kaatagea. Kiya okoo ekaato ekegataata kaama Ni sekaataa namiyaa bagee kuwa okoo booyaa miya okoo usiyaato ko daamaa kaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Bedaa Yesus me Wa me topenaa see bagee yuwa asiino, \"Ikii mena naweganaa taapea kaboo ikii daamaa badaa kimaayaa bagee kuwa okoo me Anii miya daamaa badaa namaayaa mokoo, bedaa Anii miya daamaa badaa namaayaa bagee kuwa Anii naisiyaata Mée Waa miya daamaa badaa maayaa mokoo. ");
INSERT INTO auu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nabi bagee badaa maayaa bagee kuwa nabi bagee badaa maataa to mokoo da masiitagea, bedaa Ogatamee me menaa yayeewoo see bagee badaa maayaa bagee kuwa miya Ogatamee me menaa yayeewoo see bagee badaa maataa to mokoo da masiitagea. ");
INSERT INTO auu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bedaa peedi, daba see bagee yuwa okoo Ni sekaataa poono bagee kemaata okoo paagoo agiyoo maniyaa bagee kuwa miya kisee. Uwo peenaa too miya nusi naadi maniyaa bagee kuwa taa ma taa daamaa agiyoo yaukuwataa to mokoo da masiitagea, see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kuwa menaa yuwa Wa me topenaa see bagee gaasi ma wiya paagoo asemaata kaama Waa peedoota mee magaa gebo kaa bagee paagoo Wa me doometa menaa mée topenaa, eeweganaa segee seta. ");
INSERT INTO auu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kuwa kaboo da uwo mée yatukumeta mée Yohanes mee digiyoo ee yiba tupi. Kristus me koo senaa seta menaa yuwa doodoota wa paagoo eewegagea. Yohanes me Yesus apaadiino menaa ena agoo naadi wa me topetaa see bagee yuwa me kuwa menaa doodoota Yesus paagoo asiino, ");
INSERT INTO auu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","\"Yohanes me kasiino ko 'Idukaa kaama meetagi see wegawoo seta Mée mee Aa ye, apanaa bagee ena kaata ye?' see kasigi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus me okoo asiino, \"Ikii me yeetaa, deetaa see yuwa kuwa Yohanes pe-asii. ");
INSERT INTO auu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kuwa ko emaa digiyoo bagee diino keago kedaakea, oogimaata bagee bado petooniyaata daamaa peenaakea, esee pedeo abuu meanee see bagee yuwa abuu taa kedaakea, apa takiinta bagee mena daamaa yeegea, boota bagee aya andoo peegea, daba bagee yuwa paagoo daamaa etokaa menaa kuwa eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dimi wiya taa, Anii mikee nao naadi se naekeasiyaa bagee kuwa daamaa, ede nao. Kuwa menaa uduma Yohanes paagoo pe-asii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohanes me menaa yadoopea bagee yuwa pe-seomegea kaboo Yesus me mée yuwa paagoo Yohanes kaa menaa eewegaano see naadi asiino, \"Ikii ebo mee maga ugii da kaa Yohanes paagoo peegee semea kuwa maagiyoo diino see naadi peegee semea ya? Aii boo kabagaa da bo me maki-makaa taaka see kuwa diino see naadi peegee semea ye? ");
INSERT INTO auu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Taa yoka maagiyoo diino see naadi peegee semea ya? Diino disi see dokaa maanaa see mée ena diino see naadi peegee semea ye? Taa, kisee daamaa dokaa maanaa see bagee kuwa ebo tookee bagee me ebo see ee kaa too toogee siyaa yoka ");
INSERT INTO auu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ikii maagiyoo diino see naadi peegee semea? Nabi bagee diino see naadi ye? Mikee, waa nabi bagee kiya nabi bagee asii eboo. ");
INSERT INTO auu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kuwa ko Ogatamee me kapogee yiba Yohanes kaa uwa daata menaa ena idukaa ebeamaata, mee ko kisee: 'Ni me menaa naweganaa taano mée ena wa keta pooi see kaasiita, A me poono etaa da wa me daamaa kamasiitagi' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Anii mikee kisiino ko: Idukaa kaama eto too mée tomaa-tomaa kuwa uduma uwo mée yatukumeta mée Yohanes wa too ebo kiya eto kaama wodoo Ogatamee Wa too ebo mée eetotaa see yoo daba tuyaayaa bagee kuwa uduma ebo. Okoo uduma, esee daba see bagee miya, esee daba see apii miya Yohanes asii esee ebo kegea. ");
INSERT INTO auu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yohanes me petamanii mena weganaa seta yoo kaama eto too mée yuwa Ogatamee Wa too ebo mée eetotaa see yoo anii ma se toga ou naadi omaago ma medaakea, bedaa dimi pedeo bagee me miya be kaa omaago ma wisintagaa segeekea. ");
INSERT INTO auu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kisee ukuwaandaaka menaa kuwa ko idukaa Musa me menaa yiba ma, nabi bagee me menaa yiba ma kuwa menaa wegawoo seta, kisee too Yohanes agoo keta yoo too. ");
INSERT INTO auu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eto ko idukaa kaama wegawoo seta menaa ena ma kisiinaka yoka masiyaa bagee yuwa daamaa masii. Mee ko idukaa kaama nabi Elia waa meetagi see wegawoo seta menaa da kuwa uwa daano yaato ko Yohanes wa kaa kega. ");
INSERT INTO auu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Apa agoo see bagee daamaa yii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Bedaa Yesus me asiino, \"Etokaa bagee kuwa kaasee bagee yuwa naa ya? Anii okoo kaa ebea-ebea menaa ena mee ko kisee: Okoo ko yoga tabaa da pasar kaa animaata ebaa-ebaa siyaa mokoo. Yoga peedi noonaa me apanaa yogaa yuwa paagoo asiyaa menaa ko ");
INSERT INTO auu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'Inii ikii paagoo kaado kiibaa-baa sepe kiya ikii ede ma, ede ma mée eewasiino miya be, otoo-otoo taano miya be. Bedaa \"Niiyegee taai\" see kisiyaa miya ikii inii ma epo enaataa yegee taano be, ikii me kisee mée wisinegea' see asiyaa. ");
INSERT INTO auu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mee mokoo miya etokaa bagee yuwa me wisineekee too. Mee ko uwo mée yatukumeta mée Yohanes waa naano agiyoo naano dimii too see mée se kiya, anggur poo uwoo miya se notaa kiya mée me wisinegee semea. 'Waa paa yago mée to' see yawegagee semea. ");
INSERT INTO auu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mée Yogaa mee miya wisinegeekea. Waa ede ma naano agiyoo eenotaa, anggur poo uwoo miya eenotaa see kuwa okoo dimi nagimaakee kaa wegaano, 'Mee Mée mee deeweei. Naano agiyoo naano dimii too, uwo miya naano omaago. Pajak kepee yamasegee see bagee ma, apanaa dimi pedeo see bagee ma epo eenotaa see Mée to yaai' see yawegageekea. Etokaa bagee me kisee wisinegeekea kiya mée ena wa me daamaa ukuwanaa siyaa agiyoo kuwa kaa kaama mée me 'Mikee, kuwa ko Ogatamee me ipi dimii kaa yaukuwanaa segeeki agiyoo yuwa ii' see kuwa yanekeeniyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesus me dimi nagii-nagii agiyoo eebaa kiyoo-kiyoo ukuwanaa segeeki kiya kuwa magaa kaa bagee okoo me pedeo dimii, pedeo agiyoo kuwa ekeasiino taa, Ogatamee ma dimii menaa kaa taa see bagee kemaata Wa me kagoo kaa wegaano, ");
INSERT INTO auu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","\"Korazim magaa kaa bagee ma, Betsaida magaa kaa bagee ma ikii pedeo kaatagea yoka yaai. Dimi nagii-nagii agiyoo kuwa Anii ikii paagoo koo senaa sepa kiya ikii me pedeo yuwa ekeasiino taa. Kuwa dimi nagii-nagii agiyoo kuwa apanaa bagee me magaa kaa ukuwapa naaki okoo mikee nao see nagaayaa. Kuwa ko idukaa Tirus magaa kaa bagee ma, Sidon magaa kaa bagee ma okoo Ni me ukuwanaa sepa agiyoo kuwa diino taa. Okoo deeta naaki Waa mikee nao see nagaayaa, okoo me pedeo dimii, pedeo agiyoo kuwa yaai naadi ekeata karung see see ponee yuwa maataata kaama aguu miya okoo ekaato kaa widimiyaa. ");
INSERT INTO auu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ani me kisiino ko: Ogatamee me mée wigintagaatagi naagoo Tirus magaa kaa bagee ma, Sidon magaa kaa bagee ma okoo kaa pedeo yadootagaatagi agiyoo kuwa peedi kaata kiya ikii kaa pedeo kidootagaatagi agiyoo kuwa esee ebo kaata. ");
INSERT INTO auu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bedaa ikii Kapernaum magaa kaa bagee yuwa miya yaai. Ikii me 'Ogatamee me inii epoo to wodoo mée yagaatoo taatagi' see dimii mee gaagea ye? Kisee taa kaata. Ikii gaayu ko boota bagee toogee yoo kitamekumiitagi. Kisee kuwa ikii paagoo dimi nagii-nagii agiyoo koo senaa sepa kuwa idukaa Sodom magaa kaa kiyoo ukuwanaa seta naaki okoo mikee nao see gaayaa, okoo me magaa pedeo se kiyaata eto kenaagoo miya tuyaa. ");
INSERT INTO auu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ani me kisiino ko: Ogatamee me mée wigintagaatagi naagoo Sodom magaa kaa bagee okoo kaa pedeo yadootagaatagi agiyoo kuwa ebo kaata kiya ikii kaa pedeo kidootagaano kuwa ko mee asii esee ebo kaata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kuwa magaa kaa bagee mikee gaano taa naadi kaama Yesus me wegaano, \"Neataagi, Anii kiiboo, paamee see kasega. Aa ko epoo to wodoo Eboo miya, magaa da kaa Eboo miya. Okoo 'Anii ipi yoka' see gaayaa bagee ma, dimi yago see bagee ma okoo paagoo mikee menaa nekeensi naadi dimii mee A me yaboonemaage kiya dimi peedi see bagee yuwa paagoo A me daamaa awee da kaa ipi kiyaabuuke. ");
INSERT INTO auu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mikee, Neataagi A me kisee daamaa, ede nao naadi yaukuwayaage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","\"Se-agiyoo, we-agiyoo, se-pesee, we-pesee kuwa uduma Neataagi A me Ani kaa naekeata. Yogamee ipi see bagee mée ena ma taa, Nagamee me too ipi. Nagamee ipi see bagee gaayu ko Yogamee me miya Nagamee ipi, bedaa Yogamee me ipi kiyaabuu see bagee okoo miya Nagamee ipi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Bedaa Yesus me asiino, \"Ikii kana kegea bagee kuwa kana opeesea yoka Ni paagoo miweei. ");
INSERT INTO auu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ni me ikii kaa kidootaayaa menaa kuwa daamaa dogaai, Ni me dimi menaa daamaa tupii. Anii ko dimi daba, mena daba see Mée yoka ikii Ni paagoo kana opeapea. ");
INSERT INTO auu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mikee, Ni me ikii kaa kidootaayaa menaa kuwa ede ma doomaayaa, bedaa Ni me kitupiino menaa kuwa miya daamaa ukuwamaayaa, kana see taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kaawaa ena Sabat naagoo Yesus mee gandum poo uwaa da taa peetaaki too Wa me topenaa see bagee yuwa me naadi kaa gandum poo ukuu yuwa daageeta kaama noopegeekea. ");
INSERT INTO auu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Daagea-daagea kuwa Parisi kaa bagee me deegea. Okoo me Yesus asiino, \"A me topenaa see bagee kuwa deede. Sabat naagoo yoka okoo me kuwa ukuwagea kuwa daa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus me asiino, \"Idukaa Daud ma, waa ma enaataa bagee yuwa ma okoo naadi ebo kaa eeukuwata menaa mee ikii diino taa, ewo ye? ");
INSERT INTO auu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mee ko Daud waa Ogatamee me ee yiba seemeta kaama Ogatamee paagoo manegee seta roti magu yuwa masegeeta nota, waa ma bagee miya eenota. Kuwa roti kuwa naano ko imam bagee me too noogee siyaa roti yuwa, apanaa bagee yuwa naano ko daa kiya kisee-kisee taa. ");
INSERT INTO auu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mena ena miya kisee: Imam bagee yuwa okoo Sabat naagoo miya ukuwaano agiyoo ukuwagee siyaa. Ogatamee me ee yiba okoo me ukuwagee see agiyoo yuwa ukuwageekea naadi Sabat naagoo tuunuu segeekea kiya okoo kaa kisee taa. Kuwa Musa me menaa yiba ebeamaata menaa kuwa ikii diino taa, ewo ye? ");
INSERT INTO auu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ani me kisiino ko: Ogatamee me ee mee ebo maa diya mee asii Eboo ena eto kiipaa nakaayoo tupi see kuwa daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ogatamee me kapogee yiba Wa me wegata menaa ena mee ko kisee: 'Ikii me mée epa kaano kuwa Anii ede, agiyoo nakupi-manee taano kuwa be' see menaa topa kiya ikii se nekeenegea. Nekeenegea naaki pedeo taa see bagee kuwa pedeo see se asiyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","See kemaata Mée Yogaa mee Sabat naagoo epoo Mée\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus muguu naadi kiyoo bagee me sembahyang segee see ee yiba seemetaa. ");
INSERT INTO auu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mée ena, yagaa enaato boota see mée to kiyoo tupi. Mée noonaa peedoota Yesus paagoo asiino, \"Sabat naagoo mée kaa meanee see agiyoo yataa kiyaano kuwa dagu ye, daa ye?\" see asegea. Okoo me Yesus kaa pedeo menaa yaweganaa taano see naadi kisee apaadeegea. ");
INSERT INTO auu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus me asiino, \"Ikii me domba wodaa komo yiba eseaniyu ko Sabat naagoo miya peneata kaama maseageeyaa, se maa? ");
INSERT INTO auu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Domba mee ebo agiyoo maa diya mée tomaa mee ko mee asii esee ebo yoka Sabat naagoo miya kisee daamaa agiyoo yaukuwaano kuwa dagu\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kiyoo kaama Yesus me mee yagaa boota see mée to asiino, \"A me yagaa da petaasede\" asigi. Yagaa peto asigi naaki daamaa keepeasigi, naato see see. ");
INSERT INTO auu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Parisi kaa bagee yuwa kagoo ebo kaa peedaakea, Yesus wugiino see menaa koogo wegapegeekea. ");
INSERT INTO auu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Parisi kaa bagee me wugiino dimii mee Yesus nekeenta kaama peedoota apanaa magaa kaa, mée eebaa Wa sekaataa peegea. Wa me okoo kaa meanee seta agiyoo uduma yataa kiyaabuu semaata okoo paagoo asiino, ");
INSERT INTO auu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","\"Anii mée paagoo se naipi kiyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wa me ukuwata-ukuwata kuwa ko idukaa Ogatamee me nabi Yesaya paagoo eewegata menaa da uwa daaga yoo. Kuwa menaa kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","\"Mee ko Ni me daamaa wigintaata Mée, Ni me asiyaa menaa daamaa naukuwataa see Mée. Waa ko Ni me epa see Mée, Anii dimi wikii-wikii nasiyaayaa Mée. Ni me Roh mee Wa kaa tuyaata, mée tomaa-tomaa Ogatamee me okoo kaa menaa kuwa daamaa yadaakomee taatagi yoka, see menaa kuwa okoo paagoo nawegakumiitagi. ");
INSERT INTO auu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Waa aawisi-maawisi menaa se wegaatagi, ebo menaa-menaa miya taa, bedaa ebo bagee okoo me etaawee ebo menaa wegapegee siyaa see see kuwa miya taa see Mée. ");
INSERT INTO auu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ituunta koto usii to mee miya Wa me se dukuuniyaapi, biyaa otooguu to diino see koo taaka kiyaa miya se deeyaapi. Waa kisee daba see dimii kaa mena mée yadaakomee siwoo taapi, kisee too mée tomaa mikee menaa too yayeewoo taatagea yoo too. ");
INSERT INTO auu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mée tomaa-tomaa Wa kaa too dimi kotopiwoo taatagea\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kiyoo kaama mée ena badaa maadoota Yesus paagoo eemegea. Waa paa me peneata kaama emaa miya pedeo, mena miya wegaano naka. Yesus me paa yaabagaapeasigi naaki mena miya wegaano keago, emaa miya awee keepeasigi. ");
INSERT INTO auu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mée uduma dimi nagimegea. \"Sooi, idukaa kaama Daud ma apaa kaa Mée to meetagi see wegawoo seta Mée mee ye?\" see wegagea ");
INSERT INTO auu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","kiya kuwa menaa Parisi kaa bagee yuwa yeeta kaama asiino, \"Kisee se. Wa me paa yaabagaapii segeeki kuwa paa me eboo Beelzebul mee tawata kaama too paa yuwa yaabagaapeasiyaa\" see menaa yawegagea. ");
INSERT INTO auu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Okoo me gaayaa dimii kuwa Yesus me ipi kemaata kaama ebea-ebea menaa kaa asiino, \"Maga ena kaa bagee okoo aawisi-maawisi siyu ko mée ukubaanta kaama asii se pesee kiyaa, okoo pedeo kiyaa. Kota kaa bagee yuwa miya okoo aawisi-maawisi siyu ko aapataga naadi kaama se pesee kiyaa, kisee dabaa kiyaa. Ee ena kaa bagee miya kisee kiyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mee mokoo miya paa tabaa da aawisi-maawisi siyu ko mee asii se pesee kiyaa. Kisee Iblis me wa kaa tabogetaa see paa yuwa abagaapeasiyu ko kuwa paa yuwa kaasee pesee kiyaa? Iyo, ebo se tuyaa. Paa yuwa uduma ukubaanta kaama dabaa kedaa siyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ikii me Anii 'Beelzebul mee tawata kaama too paa yaabagaapii siyaa' see menaa naweganaakea kiya ikii yaato bagee yuwa me mapeagiyoo pesee kaa paa yaabagaapii siyaa ya? Ikii yaato bagee okoo me miya Anii see see Ogatamee me pesee kaa paa yuwa yaabagaapii siyaa, se maa? Mikee yoka ikii me nakobanaakea menaa kuwa makapaa menaa too see kuwa ikii yaato bagee me too kisiyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eto ko Anii paa yuwa yaabagaapii siyaa mee ko Ogatamee me Roh pesee kaa kemaata kaama eto kiipaa Ogatamee Wa too ebo mée eetoono kuwa ikii paagoo ukuwaandaa taaka ii see kuwa daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mena ena ma kisee: Omaago kiyaa mée wa me agiyoo yuwa mée me oma yamasiino see gaayu ko wa me ee yiba seemeta kaama wa me agiyoo yuwa kaasee yamasiyaa? Mee omaago kiyaa mée wa keta one gadimemaata kaama too wa me agiyoo yuwa daba yamasegeeyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Anii ma epo enaataa eeukuwaano be see bagee kuwa ko Anii nawisintaa see bagee yuwa too, bedaa Anii ma epo enaataa niikutumeeii taano be see bagee kuwa miya mée peeda-paada nasiyaayaa bagee yuwa too. ");
INSERT INTO auu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kisee kemaata Ani me kisiino ko: Mée me pedeo ukuwayaa agiyoo yuwa ma, pedeo see yawegaa-wegaa siyaa yuwa ma uduma Ogatamee me epa yaekeasiyaa kiya Roh Kudus mee pedeo see yawegaa-wegaa siyaa bagee kuwa epa se ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bedaa Mée Yogaa mee pedeo see yawegaa-wegaa siyaa bagee kuwa uduma epa ekeasiyaa kiya Roh Kudus mee pedeo see yawegaa-wegaa siyaa bagee kuwa epa se ekeasiyaa, eto miya, iminookaa miya kisee too yoka daamaa nekeenii.\" ");
INSERT INTO auu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","\"Piya wodoo to daamaa kiyu ko poo yuwa miya daamaa ekayaa, bedaa piya wodoo to pedeo kiyu ko poo yuwa miya pedeo kiyaa. Piya wodoo to daamaa see piyaa miya, pedeo see piyaa miya kuwa poo ota yuwa deeta kaama too yanekeeniyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yaai, ikii otoogiyoo tomaa da miya kisee. Ikii dimi pedeo bagee yoka kaasee daamaa menaa wegamaayaa? Iyo, ebe kaa wegayaa menaa kuwa dimi yiba gaata-gaata yuwa me too mena wegayaa yoka ikii iyo. ");
INSERT INTO auu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dimi daamaa bagee gaayu ko dimi yiba daamaa menaa eebaa maataata kemaata daamaa menaa too wegayaa. Dimi pedeo bagee gaayu ko dimi yiba pedeo menaa eebaa maataata kemaata pedeo menaa too wegayaa. ");
INSERT INTO auu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ani me kisiino ko: Iminookaa Ogatamee me mée wigintagaatagi naagoo mée gakata okoo me otoopa wegata menaa yuwa uduma okoo ekaato dogaatagea. ");
INSERT INTO auu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mee ko ikii me wegata menaa kuwa me kemaata aa dimi topoo see mée yoka naadi pe-kiwigintagaatagi miya, bedaa aa dimi pedeo see mée yoka naadi pe-kiwigintagaatagi miya, kisee kiyaa yoka daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kiyoo kaama Parisi kaa bagee ma, Musa me menaa mée topetaa see bagee ma okoo wedo waa naa Yesus paagoo asiino, \"Guru, Aa mikee kisee Mée ii see kanekeensi naadi dimi nagii-nagii agiyoo ena inii diinake yoka mée deeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kiya Yesus me asiino, \"Yaai, Ogatamee ma dimii ekeata esee pedeo dimii, pedeo menaa kaa too umiwoo, toowoo see bagee yuwa me Ni paagoo 'Aa mikee kisee Mée ii see kanekeensi naadi dimi nagii-nagii agiyoo ena mée deeyaai' see nasegeekea kiya se kiukuwaapa. Ikii me Aa mikee kisee Mée ii see nanekeensea naadi Anii idukaa nabi Yunus wa me ukuwata peeta menaa mee too kiiwegaanaka. ");
INSERT INTO auu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mee ko Yunus waa unu wedo, egapii wedo doge damaa to yibaa taa toogee seta. Mee see see miya Mée Yogaa mee unu wedo, egapii wedo maga yiba tootagi. ");
INSERT INTO auu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Iminookaa Ogatamee me mée wigintagaatagi naagoo Niniwe bagee yuwa ma, ikii etokaa bagee yuwa ma aya andoo peedaa seta kaama okoo me ikii kaa kiwegaatagea menaa ko kisee: 'Kuwa bagee kuwa ko pedeo dimii, pedeo menaa ekeasiino taa, Ogatamee ma dimii menaa kaa se toowoo see bagee yuwa too' see menaa kuwa ikii kaa kiwegaatagea. Idukaa kuwa Niniwe bagee me Yunus me weganaa seta menaa kuwa mikee nao naadi kaama okoo me pedeo dimii, pedeo menaa ekeata Ogatamee ma dimii menaa kaa too toowoo seta. Okoo me kisee ukuwata kiya ikii ko taa yoka kuwa menaa kiwegaatagea. Yunus mee ebo kiya eto kiipaa Yunus mee asii eboo Mée ena nakaayoo tupi. ");
INSERT INTO auu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bedaa idukaa api ena, yamuyaato maga ena kaa ebo tookee apii beesekaa magaa kiya Salomo wa me dimi ipi kaa menaa kuwa si yeega ou naadi pakata. Si yeega ou dimii gaata kemaata iminookaa Ogatamee me mée wigintagaatagi naagoo mee apii to ma, ikii etokaa bagee yuwa ma aya andoo peedaa seta kaama wa me ikii kaa kiwegaata menaa mee ko kisee: 'Kuwa bagee kuwa ko A me menaa se kayeetaa see bagee yuwa' see menaa kiwegaata. Salomo wa me ipi see dimii mee mikee ebo kiya eto kiipaa Salomo mee asii eboo Mée ena nakaayoo tupi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Bedaa Yesus me wegaano, \"Paa kuwa mée yiba kaama yaabagaapeata kaama uwo taa see maga ugii da taa ometaa, totaa see yoo abanaa siyaa kiya se deemaayaa. ");
INSERT INTO auu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Deemagaano taa naadi kaama 'Bedaa ni me toogee sepa yoo metaki poonaka' see gaayaa. Peedoota mee ee kaa peemaaga naaki mée taa, daamaa gekedeepeata kaama kuwa ee kaa agiyoo daamaa wiginemaata topa see deeyaa. ");
INSERT INTO auu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Daamao, imi taa naadi kaama peedoota apanaa esee pedeo see paa petoo waa naa badaa maageeta kaama mee mée to yiba toogee siyaa. Kiyoo toogee naadi kaama mee mée to pedeo kiyaayaa. Petamanii paa yaabagaapeasiino taa kaboo wa me umiino, toono pedeo too kiya eto mee kaama asii wa me umiino, toono kuwa mee asii esee pedeo kedaa siyaa. Etokaa bagee yuwa miya kisee. Okoo pedeo dimii, pedeo menaa kaa too umiwoo see bagee yoka okoo pedeo kaano kuwa ko kisee too pedeo kega, pedeo kega siwoo siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus kuwa menaa yuwa mée eebaa eewegataaki too ko okooto ma, menaanii yuwa ma kuwa meemaagea. Yesus ma mena eewegaano see naadi yoo da kaa yiinaageeta toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mée ena me Yesus asiino, \"Deede, abaayo ma, agaabee nokaa yuwa ma kuwa meemaata mena kaawegaano see naadi yoo da kaa kadiitoo taakea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus me asiino, \"Nibaayo mee maapii naa ya? Anii ma kenaa bagee kuwa maamee nuwaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wa me topenaa see bagee yuwa kepo tamo omeeta kaama asiino, \"Deede, nibaayo nokaa yuwa ma, Anii ma kenaa bagee yuwa ma kuwa. ");
INSERT INTO auu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mikee, epoo to wodoo Neataagi me gaata-gaata yuwa daamaa yaukuwataa see bagee kuwa ko Anii ma kenaa bagee ma, nibaayo nokaa ma kuwa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mee naagoo Yesus mee ee kaa kaama peedoota piku geboo da kaa animaata toomuu taaki too ko ");
INSERT INTO auu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","mée eebaa Wa paagoo kutuukea. Mée eebaa naadi kaama uwo dagii da kaa koma ena kaa pakaanta animaayu, mée yuwa ea da kaa yiinaageeta totaakea. ");
INSERT INTO auu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wa me topetaa see menaa kuwa ebea-ebea menaa kaa eebaa mée yuwa topetaa. Wa me wegaano, \"Mée ena gandum poo keepa sigimenaa taano see naadi peegi. ");
INSERT INTO auu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Keepa sigimenaaka too ko noonaa etaa da kaa eseanee naadi bedo yuwa me nootaagea. ");
INSERT INTO auu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bedaa noonaa oma agoo see magaa kaa, maga eebaa taa see yoo eseaneeka. Maga eebaa taa kaa moga iyadaaka ");
INSERT INTO auu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kiya mani yuwa maga yiba daamaa poono taa kemaata keno mega ko kuwa iyapa yuwa denadaa naadi wii kedaaka. ");
INSERT INTO auu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bedaa noonaa miya takuu uwaa yiba eseaneeka. Iyaga kiya boo aatakiika naaki egaapeasega. ");
INSERT INTO auu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mee kaama too noonaa yuwa daamaa magaa kaa eseaneeka. Iyata kaama poo ekaga naaki poo ukuu noonaa ogei me badoo, noonaa bado ena, noonaa amaamo, kisee ekadaaka. ");
INSERT INTO auu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Apa agoo see bagee daamaa yii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesus me topenaa see bagee yuwa meedoota Wa paagoo asiino, \"A me mée yuwa topegeeke kuwa kaasee kaa ebea-ebea menaa kaa topegeeke?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wa me asiino, \"Ogatamee Wa too ebo mée eetuyaa menaa kuwa idukaa kaama awee da kaa kiyaano taa. Eto ikii kuwa menaa daamaa nekeeniino dimii mee kineegi kiya apanaa bagee ipi kiyaano taa. ");
INSERT INTO auu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kuwa ko agoo kiyaa bagee yuwa bedaa noonaa ma masiipea. Okoo koga eebaa kedaa taapea kiya taa kiyaa bagee yuwa okoo me peenaa kiyaa yuwa miya yamasegeeyaa. ");
INSERT INTO auu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Anii ebea-ebea menaa kaa mée yuwa paagoo eewegageeka mee ko okoo deegea kiya se deegea mokoo, mena yeegea kiya si yeegea mokoo, se nekeenegea. Kisee kemaata Anii ebea-ebea menaa kaa okoo paagoo eewegageeka. ");
INSERT INTO auu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Idukaa nabi Yesaya me wegawoo seta menaa kuwa okoo kaa uwa daaga yoo, kuwa ko kisee: Ogatamee me wegata menaa ko 'Ikii kisee too yeewoo taapea kiya se nekeeniipea, kisee too deewoo taapea kiya se gaamagaapea. ");
INSERT INTO auu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mee ko okoo dimi eboo kegea, apa miya takiinegea, emaa miya sibuunegea kuwa me okoo dimi ewo kedaa seta. Kuwa ko okoo emaa me se deesi naadi, apa me si yeesi naadi, dimi me se nekeensi naadi dimi ewo kedaa seta. Kisee taa naaki okoo Ni paagoo namiyaa, okoo pedeo kiyaabuu see agiyoo yuwa kuwa Ani me yataa kiyaayaa' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Okoo kisee bagee kiya ikii ko dimi ipi see bagee. Emaa miya diino keago, apa miya mena yeeyaa yoka daamaa, ede nao. ");
INSERT INTO auu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Anii mikee kisiino ko: Eto ukuwaandaa taaka agiyoo kuwa ikii deegea, ipi kegea kiya idukaa nabi bagee yuwa ma, Ogatamee me menaa yayeewoo seta bagee yuwa ma okoo mée eebaa diino taa. Ikii me deegeekea agiyoo kuwa okoo miya deega naaki ou see dimii gaata kiya diino taa, bedaa ikii me yeegeekea menaa kuwa okoo miya yeega naaki ou see dimii gaata kiya yiino taa see kuwa mikee kisega.\" ");
INSERT INTO auu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","\"Kisee kemaata poo keepa sigimenaa siyaa ebea-ebea menaa mee mena nekeeniino yaato kuwa daamaa yii, mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Etaa da kaa eseanee siyaa yuwa gaayu ko Ogatamee Wa too ebo mée eetuyaa menaa da yeegea kiya dimi se nekeeniyaa bagee yuwa mokoo. Okoo gaamagaano taa naadi pedeo yago mée Iblis meedoota okoo dimi yiba sigimpea yuwa yamasedoo peeyaa, see ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Oma dagi kaa eseanee siyaa yuwa gaayu ko menaa da yeeta kaama moga ede ma, ede ma masiyaa bagee yuwa mokoo ");
INSERT INTO auu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kiya okoo manii da taa yoka okoo ae-wae siyaa kaboo makii taa see kaa maamaa se toowoo siyaa. Mée me kuwa menaa peneata bagee yuwa wegee-wegee siyaa kaboo okoo kuwa menaa ekeata peeyaa see ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Takuu uwaa yiba eseanee siyaa yuwa gaayu ko menaa da yeegea kiya mée me dimi-pami kuwa me mee menaa da dapimeekee. Kuwa ko okoo me umiino, toono yiba gaagaa dimii mee ma, kepe, kisee mée deebaa siyaa agiyoo ou dimii mee ma kuwa dimii yuwa me mee menaa da egadaa naadi kaama okoo poo ekaano taa see wodoo yuwa ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Daamaa magaa kaa eseanee siyaa yuwa gaayu ko menaa da yeeta kaama daamaa nekeeniyaa bagee yuwa ebea-ebea. Okoo me poo ekawoo siyaa yuwa kuwa ko mée noonaa poo ukuu ena kaa ogei me badoo, noonaa bado ena, noonaa amaamo kisee eebaa kedaa siyaa bagee kuwa, see ebea-ebea menaa mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus me ebea-ebea menaa ena miya okoo eewegaano, \"Ogatamee Wa too ebo mée eetuyaa kuwa ko kisee: Mée ena daamaa keepa yuwa wa me bugii da kaa sigimemaayu. ");
INSERT INTO auu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kiya daatooyiba yaato mée uduma toomoo ompea kaboo waa ma aawisii taa see mée to meedoota mee gandum bugii da kaa má boo yuwa koogo yasigimenaa naadi peegi. ");
INSERT INTO auu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gandum kabaga yuwa iyadaaka kaboo má boo yuwa miya iyadaaka. ");
INSERT INTO auu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bugi epoo mée wa me agiyoo yaokagee see bagee yuwa wa paagoo meemaata kaama asiino, 'Neataagi, a me bugii da kaa daamaa keepa yuwa too sigimenaa seme kiya kuwa yupii má boo yuwa miya iyadaaka kuwa kaasee kaa ya?' see asegea naaki ");
INSERT INTO auu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'Anii ma aawisii naataa see mée wa me nakoo simi kepa ke' see asigi. Okoo me asiino, 'Má boo kuwa badeepii taano naa daamaa ye?' see asegea naaki ");
INSERT INTO auu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","'Kisee se, se badii. Má boo kuwa badiyu ko gandum kabaga yuwa miya badeendaa taapa yoka ekeasii. ");
INSERT INTO auu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kuwa boo kuwa enaataa ekeasii, poo daayaa naagoo too daayaa. Mee naagoo ani me poo nadaaii taa see bagee yuwa paagoo \"Daaii semaata má boo kuwa keta biyaa kaa yuwitaasi yoka kutumeeii semaata pugi taamemagaai. Kiyoo kaama gandum poo yuwa kutumeeii semaata ni me maagee yoo namagaai\" see asiita' see kuwa. Mee mokoo miya Ogatamee Wa too ebo mée eetoowoo siyaa kuwa kisee kaata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus me ebea-ebea menaa ena miya okoo eewegaano, \"Ogatamee Wa too ebo mée eetuyaa kuwa ko kisee: Mée ena sesawi poo keepa ena masegeeta wa me bugii da kaa weetayu. ");
INSERT INTO auu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sesawi poo keepaa to mee umina peedi kiya iyata ko piya wodoo to ebo kiwooka siyaa. Kago ebo peeda-paada naadi kaama bedo yuwa kiyoo geka daamaa maagee siyaa. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bedaa Yesus me ebea-ebea menaa ena miya mée eewegaano, \"Ogatamee Wa too ebo mée eetuyaa kuwa ko kisee: Api ena ragi yeeyee peenaa masegeeta kaama gandum yeeyee eebaa mokoo ebo otaawee yiba sigimekomeeyu. Kuwa agiyoo daamaa enaataa me-gokataga, pe-gokataga naadi kaama eke. Peenaa tookomeeta kaama deeyaa naaki uduma iyadoo pakapa siyaa. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kuwa Yesus me mée topetaa see menaa kuwa uduma ebea-ebea menaa kaa topegee seta. Wa me mée yuwa paagoo ebea-ebea menaa ma taa see menaa kuwa eewegaano taa. ");
INSERT INTO auu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wa me topegee seta kuwa idukaa nabi bagee me menaa da uwa daaga yoo, kuwa ko kisee: \"Anii ebea-ebea menaa kaa wegaapa, epoo to, magaa to ogaataata yoo kaama eto too boonemaata menaa yuwa kuwa Anii wegakumiipa\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesus kuwa menaa eewegamaata kaama amo kaa naa kaa ee ena yiba seemetaa. Wa me topenaa see bagee yuwa meedoota Wa paagoo asiino, \"Kuwa gandum yupii má boo iyayaa ebea-ebea menaa mee mena nekeeniino yaato daamaa mée ase-manee taai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wa me asiino, \"Daamaa keepa sigimenaa taano mée mee ko Mée Yogaa mee ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Bugii da mee ko uwoo to, magaa to kuwa ebea-ebea. Daamaa keepa kuwa ko Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa eetuyaa bagee yuwa ebea-ebea. Má boo kuwa ko pedeo yago mée Iblis wa yaato bagee yuwa ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aawisii taa see mée to mee, má boo sigimenaa sipi mée mee ko Iblis mee ebea-ebea. Poo daaii semaata kutumeeii siyaa kuwa ko iminookaa mée tomaa-tomaa yuwa Ogatamee paagoo kutumeeii taatagea kuwa ebea-ebea. Kuwa poo daaii taano bagee kuwa ko malaikat bagee yuwa ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Má boo yuwa kutumeeii naadi biyaa kaa yuwitaayaa kuwa see see iminookaa miya mée tomaa kutumeeii naadi ukuwaaniita kuwa ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mee naagoo Mée Yogaa mee Wa me malaikat bagee yuwa \"Pooi\" see asiyaa naaki peedoota se-magaa, we-magaa uduma, Wa too ebo tuyaa magaa kaa okoo mée deebaa naadi kaama pedeo agiyoo ukuwayaabuu taa see bagee yuwa ma, pedeo dimii kaa umiwoo see bagee yuwa ma uduma kutumeeii naadi kaama ");
INSERT INTO auu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ebo biyaa yiba tameatagea. Kiyoo ko yege ma, gaagaa ma too totaa see yoo. ");
INSERT INTO auu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kiyoo kaama Wa me menaa daamaa yayeetaa see bagee yuwa Okootaagi Wa too ebo mée eetoowoo siyaa yoo keno agoo da wogaamaayaa mokoo see see okoo miya kisee daamaa umiwoo, toowoo taatagea. Apa agoo see bagee daamaa yii.\" ");
INSERT INTO auu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","\"Ogatamee Wa too ebo mée eetuyaa kuwa ko kisee: Esee ebo agiyoo, maga yiba boonemaata agiyoo kuwa mée ena me deemaayu, moga bedaa maga yiba boontayu. Esee ede kaa yiibaga wa me agiyoo-pagiyoo kuwa uduma pe-doogeeyu, kepe masegeeta kaama mee magaa to edaamaayu. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa.\" ");
INSERT INTO auu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","\"Bedaa Ogatamee Wa too ebo mée eetuyaa kuwa ko kisee: Agiyoo-pagiyoo pe-doogee taa see mée ena daamaa see mutiara keepa edaano see naadi abataa. ");
INSERT INTO auu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Esee diino daamaa see keepa ena deemaata kaama yiibaga wa me agiyoo-pagiyoo kuwa uduma pe-doogeeyu, kepe masegeeta kaama mee mutiara keepaa to edaamaayu. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa.\" ");
INSERT INTO auu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","\"Bedaa Ogatamee Wa too ebo mée eetuyaa kuwa ko kisee kaata: Piku yiba jala onee tameeyamaayaa naaki doge tomaa-tomaa seemedaakea. ");
INSERT INTO auu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jala pudii kega kaboo maayoo kaa pakaa-goemaayu. Kiyoo animaata kaama daamaa dogee yuwa wa too kutumeeii naadi pakaa-awimaayu, pedeo dogee yuwa tameepii. ");
INSERT INTO auu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mee mokoo miya wodopasi naagoo ukuwaaniita. Malaikat bagee yuwa me Ogatamee me menaa yayeetaa see bagee yuwa ma, mena si yayeetaa see bagee yuwa ma okoo uduma wa too, wa too wigintagaatagea. ");
INSERT INTO auu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Wigintaata kaama dimi pedeo bagee yuwa ebo biyaa yiba tameatagea. Kiyoo ko yege ma, gaagaa ma too totaa see yoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus me Wa me topenaa see bagee yuwa asiino, \"Kuwa kisega menaa kuwa uduma ikii nekeenegea ye?\" asigi naaki \"Ei, nekeenege\" asegea. ");
INSERT INTO auu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wa me asiino, \"Kisee gaayu ko mena ena ma kisiinaka, mee ko kisee: Ogatamee me idukaa ebeamaata menaa mée topetaa see bagee kuwa okoo Ogatamee Wa too ebo mée eetuyaa menaa daamaa peneata tupiwoo siyu ko okoo uduma esee ipi see bagee too kiyaa. Mee ko ee epoo mée wa me ebo agiyoo maagee yoo kaama gipii agiyoo ma, idukaa magata agiyoo ma ekea paaya awee da kaa ekeasiyaa mee mokoo see see okoo miya mena uduma awee da kaa nekeeniyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus Wa me kuwa ebea-ebea menaa yuwa eewegamaata kaama peedoota Wa me magaa kaa, ");
INSERT INTO auu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nazaret magaa kaa peemaata kaama kiyoo sembahyang segee see ee yiba seemetaa. Wa me mée topetaa see menaa yuwa kuwa mée uduma dimi nagimegea. Okoo me aawegaa taano, \"Waa kuwa dimi ipi kigi kuwa kaasee kaa kisee dimi ipi kigi? Bedaa kuwa Wa me dimi nagii-nagii agiyoo ukuwaaniyaabuu segeeki kuwa maagiyoo naa tawapi naa ya? ");
INSERT INTO auu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Waa piya kapataa see mée yoopaa, se maa? Wabaayo Maria mee, se maa? Waa ma kenagaa yuwa kuwa Yakobus ma, Yusup ma, Simon ma, Yudas ma kuwa, se maa? ");
INSERT INTO auu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bedaa ukuyogaa yuwa miya nakaayoo inii paaya enaataa topea. Kuwa pesee agiyoo kuwa kayoo kaama naa masimi naa ya?\" see wegagea, ");
INSERT INTO auu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","kisee Waa wisinegea. Yesus me okoo asiino, \"Nabi bagee kuwa ko mée me ebo ekeasiyaa kiya okoo me magaa kaa bagee ma, okoo me ee kaa bagee ma kuwa me too ebo se ekeasiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kisee okoo Yesus mikee gaano taa kemaata Wa me dimi nagii-nagii agiyoo eebaa kiyoo ukuwaaniyaano taa. ");
INSERT INTO auu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kuwa kaboo da Yesus mee ogo peega naadi kaama Galilea wee kaa eboo Herodes me Wa kaa menaa yuwa yeegi. ");
INSERT INTO auu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yeeta kaama wa kaa tabogetaa see bagee yuwa asiino, \"Mee mée mee ko uwo mée yatukumeta mée Yohanes boomi mee. Waa boota kaama aya andoo peepi kemaata kuwa dimi nagii-nagii agiyoo kuwa ukuwamaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yohanes boota-boota menaa mee ko kisee: Petamanii Herodes me waebee Pilipus woga ekaa da ko Herodias mee oma yagoemi. Oma yagoemi kemaata Yohanes me \"Aa goeano ko daa\" see asegeeki. Kisee asegeeki naadi Herodes me \"Yohanes mee digiyoo ee yiba nadogeamaai\" see asigi. Digiyoo ee yiba dogeamaata kaama ");
INSERT INTO auu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes me Yohanes wugiino dimii agoo kiya mée yuwa me Yohanes mee nabi kaa eboo see ekaa peetaa see mée see gaagea kemaata waa wugiino wedaagi. ");
INSERT INTO auu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mee wodoo kaawaa ena Herodes mee kabata naagoo kenoo kaa naano agiyoo naano see naadi waa ma bagee yuwa kutuu semaagea. Kuwa kaboo da Herodias yoopane mee Herodes ikigii to taa waanena-peena senaaka. Herodes waa esee ede kigi. ");
INSERT INTO auu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wa me mee ukuyogaa to asiino, \"A me ede kiyaa agiyoo kuwa taa ma taa kaniipa, se kaniino ko daa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Okooto me ukuyogaa to paagoo \"Kisee idimaai, kisee idimaai\" see koogo ase-maneega. Kiyoo kaama mee ukuyogaa to me Herodes asiino, \"Uwo mée yatukumeta mée Yohanes mumoo to mee nadaageeta piring kaa ekeata nadoomeei see kaidimega\" see asega. ");
INSERT INTO auu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes mee menaa da yaai, dimi nagimigi kiya mée uduma gii da kaa \"A me ede kiyaa agiyoo se kaniino ko daa\" see asigi kemaata wa geboo da kaa bagee asiino, \"Wa me wegapa-wegapa kuwa pee-yaukuwagii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Peedoota digiyoo ee yiba kaama Yohanes mumoo to daageegea. ");
INSERT INTO auu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mumoo to piring kaa ekeata doodoota mee ukuyogaa to paagoo goo-maneegea. Kiyoo kaama mee ukuyogaa to me okooto paagoo dooga. ");
INSERT INTO auu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohanes me topetaa see bagee yuwa bootaa da masegeeta kaama ogo maagea. Kuwa ukuwapea-ukuwapea menaa yuwa doodoota Yesus paagoo pe-asegea. ");
INSERT INTO auu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yohanes mee wugimaagea see menaa da eewegagea naadi Yesus komaa da kaa pakaanta kaama uwaasii yaato mée taa see yoo Wa too toono see naadi peetaa. Mée eebaa Yesus mee kitaa peegi naadi wa me magaa kaa, wa me magaa kaa kaama maayoo kaa taa peegea. ");
INSERT INTO auu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus uwaasii yaato peemaata kaama deamaagi too ko mée eebaa. Epa nao naadi ikiyoo yago bagee yuwa ikiyoo yataa kiyaabuuki. ");
INSERT INTO auu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mee naagoo uwaataa da Wa me topenaa see bagee yuwa meedoota Wa paagoo asiino, \"Uwaapeasega ke, nakaayoo ee taa, bugi taa see magaa yoka kuwa bagee kuwa 'Peedaa taai' see asii, okoo gebo kaa magaa kaa naano agiyoo edaasi ke\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wa me asiino, \"Peekee se, naano agiyoo kuwa ikii me okoo manii\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","\"Nakaayoo inii roti magu idibi, doge imi wiya too topa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","\"Daamaa ke, nadoomeei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kiyoo topea bagee yuwa \"Boo dagi kaa animaaii taai\" see asigi. Roti magu idibi ma, doge imi wiya ma kuwa masegeeyu naadi epoo to yaato pakaa-deeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Kuwa roti magu yuwa kabatagaa naadi kaama Wa me topenaa see bagee yuwa goo-maneeyu, mée yuwa yawudikomeegea. ");
INSERT INTO auu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Okoo uduma naano sikii, bekataa. Kiyoo kaama roti ma, doge ma koga topa ponee-panaa yuwa kuwa Wa me topenaa see bagee yuwa me meeii naadi kaama iduunee ayaa gaasi ma wiya pudii aweamaagea. ");
INSERT INTO auu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kiyoo okoo nota bagee yuwa mée eebaa, api, yoga se egaa see, paayogaa too lima ribu. ");
INSERT INTO auu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kuwa nota bagee yuwa Yesus me \"Koogo peedaa taai\" asiino see naadi Wa me topenaa see bagee yuwa \"Ikii keta koma kaa pakaanta piku asii yaato pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kuwa nota bagee yuwa \"Koogo peedaa taai\" see aseta kaama Wa too sembahyang taano see naadi pakadoota maga kutuu ena kaa pakaamaayu. Digiyoo takiinega see kaboo Wa too totaa. ");
INSERT INTO auu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kuwa kaboo da taa Wa me topenaa see bagee yuwa komaa da piku semoo to kaa peemaagea ko bo ebo okoo poono yaato taa kaama mega, biku-biku koma kaa wogeedapiika. ");
INSERT INTO auu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aweato yaato kaboo Yesus mee uwo dagii da taa peedoota okoo paagoo peemaayu. ");
INSERT INTO auu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Waa bado me uwo dagii da taa peetaaki see deegea. Yaai naadi ebo menaa kaa \"Apee paao\" see asegea ");
INSERT INTO auu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","kiya Wa me moga asiino, \"Taa, Anii yoka ikii se wedaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus me asiino, \"Aa mikee Tuhan mee gaayu ko anii miya uwo dagii da taa meeno see yoka meei see nasii\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","\"Meei\" asigi. Komaa da kaa kaama eseanta uwo dagii da taa Yesus paagoo bado me peegi ");
INSERT INTO auu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kiya bo ebo, biku-biku weda nao naadi uwo yiba seemaano see kooki. Ebo menaa kaa \"Tuhan, nayaagii!\" asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Taka ena Yesus me yagaa esee-goekeata maseageeyu. \"Sooi, aa daamaa mikee nagaano taa see mée kadeega. Aa kaasee kaa dimi wiya kege?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Koma kaa pakaanegea naaki bo taa keepeasega. ");
INSERT INTO auu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kuwa komaa da kaa topea bagee yuwa me Waa ebo ekee, yaapaagee see kaa \"Aa ko mikee Ogatamee Yoopaa ii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Okoo uwaasii yaato Genesaret magaa kaa peemaayu. ");
INSERT INTO auu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kiyoo bagee yuwa me Yesus mee nekeenta kaama kiyoo magaa kaa, kiyoo magaa kaa mena ogo peeyaagea. Ikiyoo yago bagee yuwa uduma Wa paagoo eemegea. ");
INSERT INTO auu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wa me doka otoo to \"Peenaa nayaadee siyaape ye?\" see asegea. Waa yaadee sepea bagee yuwa kuwa uduma okoo kaa meanee seta agiyoo taa kedaa seta. ");
INSERT INTO auu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kaawaa ena Parisi kaa bagee noonaa ma, Musa me menaa mée topetaa see bagee noonaa ma okoo Yerusalem magaa kaa kaama peedoota Yesus paagoo asiino, ");
INSERT INTO auu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","\"A me topenaa see bagee kuwa okoo me Yahudi bagee me asii-wega-wega menaa yuwa wisintagaa segeekea. Kuwa ko okoo naano agiyoo naano taa kaboo yagaa keta uwo se wetogetaa see kuwa. Kaasee kaa se deewoo siyaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kiya Yesus me asiino, \"Bedaa Ani me miya ikii kisiino ko: Ikii me asii-wega-wega menaa yuwa deewoo segeekea naadi kaama Ogatamee me menaa wisintagaakee kuwa kaasee kaa ya? ");
INSERT INTO auu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kuwa ko Ogatamee me aseta menaa ena mee ko kisee: 'Okonaka ebo ekeasii' see aseta. Bedaa mena ena miya kisee: 'Okonaka wisineekee kaa pedeo menaa asiyaa bagee kuwa wogeepeasii' see aseta menaa mee miya agoo. ");
INSERT INTO auu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kiya ikii me wegawoo seta menaa kuwa wa too ena, mee ko kisee: 'Mée ena me okonaka paagoo \"Ekea me gaano pedeo agiyoo kuwa kineeyaa kiya Ogatamee paagoo manega keekee\" see asiyu ko ");
INSERT INTO auu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","wa me okonaka se maniino miya daamaa' see menaa kuwa ikii me asiyaa. Ogatamee me 'Okonaka ebo ekeasii' see aseta kiya ikii me otoopa asii-wega-wega menaa kuwa me Ogatamee me aseta menaa mee wisintagaakee. ");
INSERT INTO auu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yaai, ikii dimi daamaa poga-poga see bagee yuwa, idukaa Ogatamee me nabi Yesaya paagoo wegata menaa da ikii kaa uwa daaga yoo, kisee: ");
INSERT INTO auu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Kuwa bagee kuwa ebee to me too Anii ebo naekee segeekea, dimi menaa da me taa, okoo dimi mena yaato beesekaa. ");
INSERT INTO auu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Okoo me Anii naapaageekea kuwa makapaa, bedaa okoo me mée tupiwoo siyaa menaa kuwa miya mée me otoopa asii-wega-wega menaa yuwa too' see wegata menaa kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus me kiyoo kutuukea bagee yuwa \"Meei\" asigi. Wa me okoo asiino, \"Daamaa nayii, nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ogatamee me otoopa bagee mée diino kuwa ko ebeawee seemiyaa agiyoo kuwa me se. Kuwa agiyoo kuwa me mée se pedeo kiyaayaa kiya ebeawee kaama pedeo dimii, pedeo menaa kuwa me too mée pedeo kiyaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wa me topenaa see bagee yuwa meedoota Wa paagoo asiino, \"A me wegape menaa kuwa kaa Parisi kaa bagee kakagoo kegea see kuwa Aa nekeenege ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wa me asiino, \"Okoo ko epoo to wodoo Neataagi Wa me weeno taa see iyoo yuwa yoka mani ma badeepeasiipi. ");
INSERT INTO auu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Okoo taano ke emaa se wugii. Okoo ewo, emaa digiyoo see bagee ena wa keta eepeeyaa mokoo. Emaa digiyoo see mée gaayu ko wa keta bedaa emaa digiyoo see mée ena ma eepeeyu ko ekea paaya enaataa komo yiba peeyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus me asiino, \"Mee yumakaa ebea-ebea menaa da mee mena nekeeniino yaato mée ase-manee taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus me asiino, \"Yaai, ikii se nekeenegea ye? ");
INSERT INTO auu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mée me ebeawee seemiyaa agiyoo uduma kadapoo yiba seemeta kaama daba tameepeasiyaa yoka mée se pedeo kiyaayaa see kuwa ikii ewo ye? ");
INSERT INTO auu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ebeawee kaama pakayaabuu siyaa yuwa kuwa dimi yiba kaama yoka mée pedeo kiyaayaa. ");
INSERT INTO auu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dimi yiba kaama agoo kedaa siyaa yuwa kuwa ko kisee: mée wugiino ma, tobaaka taano ma, otoopa api doonaa, paayogaa doonaa taano ma, oma masiino ma, mena kobaano ma, mée badiino ma ");
INSERT INTO auu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","kuwa dimii kuwa me mée pedeo kiyaayaa kiya yagaa da keta uwo wetogeano taa kaa naano agiyoo nuyaa kuwa me mée se pedeo kiyaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Muguu naadi Tirus magaa ma, Sidon magaa ma mee magaawee da kaa peemaagi too ko ");
INSERT INTO auu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","apanaa tomaa kaa apii ena topa, Kanaan kaa apii. Waa ebo menaa kaa Yesus mena ugiwooka mega. \"Ei, Daud ma apaa kaa Mée, niyoopane mee paa me peneata kaama gaagaa ebo nao, epa nagaape ye?\" see asepegeeka ");
INSERT INTO auu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","kiya Yesus me mena peenaa ma asiino taa. Wa me topenaa see bagee yuwa meedoota Wa paagoo asiino, \"Mee apii mee waa uuto mena ma pakataaka kuwa be yoka pooi see naasii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus me asiino, \"Ogatamee me nasiino, 'Israel kaa egadaa seta domba yuwa paagoo pooi' see naseta, apanaa tomaa kaa bagee paagoo pooi see nasiino taa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mee apii to meedoota Yesus paagoo mumo maga kaa esee-ekeata asiino, \"Neataagi, anii esee gaano pedeo yoka nayii\" asega naaki ");
INSERT INTO auu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wa me asiino, \"Yoga yuwa me naano agiyoo masegeeta kaama kameno maniino ko pedeo yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Apii to me asiino, \"Neataagi, A me wegage kuwa mikee kiya kameno epoo mée me naano agiyoo noogee yoo kaama eseanee siyaa ponee-panaa yuwa kuwa kameno me nuyaa\" see asega. ");
INSERT INTO auu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus me asiino, \"Keapii nao, a me mikee nagaano dimii mee esee ebo yoka a me ou see gaage agiyoo mee ukuwaaniipa\" see asigi. Kuwa kaboo da wa me yogaa to mee agiyoo taa keepeasega. ");
INSERT INTO auu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus muguu naadi Galilea piku geboo da kaa peemaata kaama pakadoota maga kutuu to kaa kiyoo animaayu naadi ");
INSERT INTO auu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","mée eebaa Wa paagoo eemegea. Kuwa ko oogimaata bagee ma, emaa digiyoo see bagee ma, poono naka see bagee ma, mena wegaano naka see bagee ma, apanaa kisee agiyoo meanta bagee eebaa miya Wa paagoo eemegea. Okoo kaa meanta agiyoo kuwa uduma yataa kiyaabuu seta. ");
INSERT INTO auu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kuwa ko mena wegaano naka see bagee mena wegayaayu, poono naka see bagee yatamooniyaayu, oogimaata bagee daamaa peenaa siyaayu, emaa digiyoo see bagee diino keago yakiyaayu. Kiyoo tuyaa bagee yuwa uduma dimi nagimeamoo naadi Israel bagee me Eboo Ogatamee mee yaapaagee seta. ");
INSERT INTO auu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus me Wa me topenaa see bagee yuwa \"Meei\" asigi. Meemaagea kaboo Wa me asiino, \"Kuwa bagee kuwa okoo unu wedo Ni paagoo niitopea kiya naano agiyoo taa yoka epa nao. Okoo naadi ma peeweei see asiino be, okoo eta mana kaa naadi kaa boomagaa taapea yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Okoo me asiino, \"Sooi, nakaayoo ee taa, bugi taa see magaa. Okoo mée eebaa yoka naano agiyoo naano sikii-sikii see kuwa kayoo kaama masiipea?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus me \"Ikii roti magu magoo topa?\" asigi naaki \"Roti magu petoo ma, doge peedi wiya waa naa ma topa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kuwa bagee yuwa \"Animaaii taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kiyoo kaama roti magu petoo to ma, doge yuwa ma masegeeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Aseta kaama roti kabatagaa naadi Wa me topenaa see bagee yuwa goo-maneeta kaama mée yuwa uduma yawudikomeegea. ");
INSERT INTO auu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Okoo uduma naano sikii, bekataa. Kiyoo kaama roti koga opa topa yuwa meeii naadi iduunee ayaa petoo pudii aweamaagea. ");
INSERT INTO auu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kiyoo okoo nota bagee yuwa mée eebaa, api, yoga se egaa see, paayogaa too empat ribu. ");
INSERT INTO auu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesus me kuwa bagee yuwa \"Pooi\" aseta kaama koma kaa pakaanta kaama peedoota piku asii yaato Magadan wee kaa peeta. ");
INSERT INTO auu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kuwa kaboo da Parisi kaa bagee ma, Saduki kaa bagee ma okoo Yesus paagoo meemaagea. Okoo me Yesus mee kaasee mée to gaadee taano see naadi kaama asiino, \"Inii Aa mikee kisee Mée ii see kanekeensi naadi agiyoo ena, epoo to wodoo kaama dimi nagii-nagii agiyoo ena mée deeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kiya Wa me asiino, \"Ikii uwaataa da epoo to kaa kogeei maadaaka see deeyu ko 'Awee kaapa yoka' see nekeeniyaa. ");
INSERT INTO auu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bedaa pedeo komaa miya epoo to kaa kapoo pakaga, sinu aatakii see deeyu ko 'Kenaagoo ko deka weepa' see wegayaa. Ikii epoo to kaa deeta kaama 'Kisee kaapa, kisee ukuwaaniipa' see kuwa ikii ipi see bagee kiya eto kiipaa ukuwaandaa taaka ii see nekeensi naadi agiyoo kuwa ikii deegea kiya se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yaai, Ogatamee ma dimii ekeata esee pedeo dimii, pedeo menaa kaa too umiwoo, toowoo see bagee yuwa me Ni paagoo 'Aa mikee kisee Mée ii see kanekeensi naadi dimi nagii-nagii agiyoo ena mée deeyaai' see nasegeekea kiya se kiukuwaapa. Ikii me Aa mikee kisee Mée ii see nanekeensea naadi idukaa nabi Yunus wa me ukuwata peeta menaa mee too daamaa nekeenii see kisega\" see asigi. Aseta kaama apanaa magaa kaa peeta. ");
INSERT INTO auu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus me topenaa see bagee yuwa ma epo enaataa koma kaa pakaanta piku asii yaato peemaata kaama deeyaa naaki naano agiyoo gaabuu, roti dogaano taa. ");
INSERT INTO auu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus me asiino, \"Parisi kaa bagee ma, Saduki kaa bagee ma kuwa okoo me ragi yeeyee kuwa ikii gaai, nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kisee asigi naadi kaama okoo me aawegaa taano, \"Mee kaasee menaa? Inii roti dogaano taa naadi mée asigi menaa da yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Okoo dimi abanaakea kuwa Wa me nekeenta kaama asiino, \"Ikii daamaa mikee nagaano taa bagee yuwa nao. Roti dogaano taa menaa mee kaasee kaa aawegaakea ya? ");
INSERT INTO auu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kuwa miyoo taa ukuwaandaa seta yuwa kuwa ikii nekeeniino taa ye? Kuwa roti magu idibii to kuwa Anii kabatagaa naadi kaama mée lima ribu nusi naadi maamaa eebaa yakiyaama kuwa ikii nekeeniino taa ye? Noomaata kaama koga topa yuwa meeii naadi iduunee ayaa gaasi ma wiya aweamaamea kuwa ikii gaabuu sepea ye? ");
INSERT INTO auu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bedaa kuwa roti magu petoo to miya Anii kabatagaa naadi mée empat ribu nomea. Noomaata kaama koga topa yuwa iduunee ayaa petoo miya awemaamea, se maa? ");
INSERT INTO auu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kuwa ragi yeeyee kaa ebea-ebea menaa kuwa ikii gaamagaano taa ye? Roti dogaano taa naadi kisega menaa se kiya 'Parisi kaa bagee ma, Saduki kaa bagee ma kuwa gaai, okoo ragi yeeyee agoo see bagee yoka' see menaa kuwa too kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mee kaama too okoo nekeenegea. 'O, mikee, roti iyadoo pakayaayaa agiyoo kuwa gaai naadi menaa se kiya Parisi kaa bagee ma, Saduki kaa bagee ma okoo me mée tupiino menaa kuwa koopoo yoka see kuwa nekeensi naadi ebea-ebea menaa ii' see kuwa nekeenegea. ");
INSERT INTO auu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus peedoota Kaisarea Pilipi magaa kaa peemaata kaama Wa me topenaa see bagee yuwa paagoo asiino, \"Mée me Mée Yogaa mee maamee see gaageekea?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Okoo me asiino, \"Mée noonaa me Aa ko uwo mée yatukumeta mée Yohanes boomi mee see kagaageekea, mée noonaa me idukaa nabi Elia mee, mée noonaa me nabi Yeremia boota mee yee, apanaa nabi bagee boota kuwa mée ena aya andoo peemi mee yee, see kagaageekea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wa me asiino, \"Kiya ikii gaayu ko Anii maamee see nagaagea?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus me asiino, \"Aa ko Ogatamee me Aa ebo toowoose naadi kawigintaata Mée, Ebo Kristus mee, toono too Mée Ogatamee Wayoopaa mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus me asiino, \"Daamaa, Simon, Yunus yoopaa, ede nao. A me wegage kuwa mée me kasegea menaa se kiya epoo to wodoo Neataagi me aa kaipi kiyaagi menaa. ");
INSERT INTO auu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ani me kasiino ko: Aa mee ko Petrus, omaa to mokoo see see. Oma dagii da kaa ee maataayaa mokoo Ni me bagee yuwa a kaa kamaatagaapa. Maataata wodoo Ni me bagee yuwa kisee too pesee kiwoo taapea. Paa, bogaano, kisee agiyoo kuwa me miya ikii daba, peedi se kiekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ogatamee Wa too ebo mée eetotaaki too mena ena too too mée yadaakomee siwoo taano kuwa Ani me a kaa too kaekeasega, kunci a paagoo kaekeasiyaa mokoo. Magaa da kaa a me yadaakomee siyaa menaa kuwa ko epoo to wodoo Ogatamee me yadaakomee seta menaa doodoo too kaapa. Kuwa ko a me 'Kisee daamaa, kisee pedeo' see yadaakomee siyaa menaa kuwa ko Ogatamee me 'Kisee daamaa, kisee pedeo' see yadaakomee seta menaa yuwa doodoo too kaapa. Bedaa a me 'Kuwa mikee menaa, kuwa makapaa menaa' see yadaakomee siyaa menaa kuwa miya Ogatamee me 'Kuwa mikee menaa, kuwa makapaa menaa' see yadaakomee seta menaa yuwa doodoo too kaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aseta kaama bedaa Wa me topenaa see bagee yuwa omaago ma asiino, \"Mee ko Ebo Kristus mee see kuwa mée ena ma se naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mee kaama wodoo Yesus Waa poono etaa agoo naadi kaama Wa me topenaa see bagee yuwa asiino, \"Anii Yerusalem magaa kaa poono gaano pedeo. Peemaata kaama Yahudi kaa ebo-ebo yuwa ma, imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me Ni kaa ae-wae nasiyaayaa agiyoo kuwa maamaa naukuwamaata kaama mée me nabooyaatagea. Nabooyaata kaama wedaagoo to naagoo Ogatamee me Anii aya andoo napeeyaatagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kiya Petrus me Yesus monaa eepeegi. Wa me ego-tago see kaa asiino, \"Tuhan, kuwa agiyoo kuwa Ogatamee me kaabagaapeasiipi, A kaa se kadeeyaapi yoka kisee menaa se wegaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kiya Yesus ikigi pe-maataata kaama asiino, \"Iblis, aa pooi. Anii taamege-taamege se nataai. A me gaage dimii kuwa Ogatamee me dimii se, mée me dimii too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kiyoo kaama Yesus Wa me topenaa see bagee yuwa asiino, \"Ni sekaataa nameeno see dimii agoo see bagee kuwa ko okoo me gaata-gaata yuwa too ede see dimii mee wisintaata kaama piya boko ma doowoo see bagee kuwa too Ni sekaataa namiyaa. ");
INSERT INTO auu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kuwa ko okoo ekaato koogo daba toono see naadi umiwoo, toowoo siyaa bagee kuwa usiyaato ko umina pedeo kaatagea. Kiya okoo ekaato ekegataata kaama Ni sekaataa namiyaa bagee kuwa okoo booyaa miya okoo usiyaato ko daamaa kaatagea. ");
INSERT INTO auu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Magaa da kaa agiyoo ou see gaawoo siyaa bagee kuwa gaayu ko wa me agiyoo tabaa da eebaa, magaa da kaa se-agiyoo, we-agiyoo uduma epoo mée kiyaayaa miya kiya waa boota kaama umina pedeo kaatagi see kuwa daamaa ye? Waa umina pedeo kiyaata wodoo bedaa daamaa nakiyaasi naadi maniino agiyoo ena ma agoo ye? ");
INSERT INTO auu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mée Yogaa mee Wa me malaikat bagee yuwa ma epo enaataa meetagea. Waa Nagamee me pesee ma meetagi, Wa disii to ebo kaatagi. Kuwa kaboo da Ogatamee me mée gakata okoo me ukuwagee seta yuwa doodoo daamaa agiyoo miya, pedeo agiyoo miya maniitagi. ");
INSERT INTO auu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Anii mikee kisiino ko: Nakaayoo topea bagee yuwa noonaa bogaano taa kaa Mée Yogaa mee ebo mée eetoono see naadi migi see kuwa diitagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Unu bedimi omemaata Yesus me Wa me topenaa see bagee Petrus ma, Yakobus ma, waebee Yohanes ma, kuwa wedoo to okoo too eepakadoota maga kutuu to kaa. Pakaamaata kaama ");
INSERT INTO auu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","deamaagea ko Yesus Waa epoo ena gakademaagi. Ebeyumaa da keno kusi-kusii da keenda, Wa me dokaa da miya esee poodee wikiindaaka. ");
INSERT INTO auu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Taka ena Musa ma, nabi Elia ma wiya awee da kaa keta kaama Yesus ma mena eewegagea. ");
INSERT INTO auu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrus me Yesus asiino, \"Tuhan, inii nakaayoo epo enaataa kiitoono daamaa yoka kisee Aa ede kiyu ko anii nakaayoo ee peedi wedo kimaatagaanaka, Aa taano ena, Musa taano ena, Elia taano ena\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kuwa menaa da wegataaki naaki taka ena sinu yuwa, poodee wikiindaaka see sinuu okoo dagii da kaa esee-takiinega. Sinu uwaa da yibaa taa kaama mena wuu da yeegea. \"Mee ko Ni me esee epa see Yogaa. Anii Waa dimi wikii-wikiika. Wa me menaa too yayeewoo taai\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kuwa Wa me topenaa see bagee yuwa kuwa menaa yuwa yaai naadi se gaata magaa da kaa esee-gapumedaakea. ");
INSERT INTO auu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kiya Yesus meedoota okoo paagoo yagaa pe-peneata kaama \"Anoogii, se wedaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Okoo deamaagea ko mée taa, Yesus Wa too. ");
INSERT INTO auu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kuyee da kaa kaama esetaaki too Yesus me pesee ma menaa asiino, \"Ikii me deepea-deepea yuwa kuwa mée se asii. Mée Yogaa mee boota kaama aya andoo peeyaata kaama asii too mée eewegaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wa me topenaa see bagee yuwa me asiino, \"Musa me menaa mée topetaa see bagee okoo me 'Nabi Elia mee keta meetagi' see wegawoo seta menaa mee kaasee menaa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus me asiino, \"Elia wa keta meemaata kaama mée yuwa ipiipii taano see naadi tupiitagi, see wegawoo seta menaa kuwa mikee menaa. ");
INSERT INTO auu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kiya Ani me kisiino ko: Elia mee mikee meemaami kiya mée me nekeeniino taa kemaata okoo me gaata-gaata dimii kaa waa otoopa taagea. Mée Yogaa mee miya mée me kisee be kaa otoopa wisintagaapea see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mee kaama too Wa me topenaa see bagee yuwa nekeenegea. 'O, mikee maa, Elia mee meemaami mee ko uwo mée yatukumeta mée Yohanes mee kaa menaa yoka' see nekeenegea. ");
INSERT INTO auu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus ma, Wa me topenaa see bagee wedoo to ma okoo eseemaagi too ko mée eebaa topea. Mée ena Yesus paagoo mumo maga yaato esee-ekeata asiino, ");
INSERT INTO auu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","\"Tuhan, Aa niyoopaa mee epa nagaai. Waa boga-bogaa yago yogaa, deei-deei ebo. Deemaayaa kaboo biyaa yiba peantaa, uwo yiba miya eseantaa, kisee too koo segeeki. ");
INSERT INTO auu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A me topenaa see bagee yuwa paagoo eepeepa kiya iyo, si yataa kiyaagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus me asiino, \"Yaai, ikii mikee gaano dimii taa see bagee, dimi koopoo see bagee yuwa nao. Anii ikii ma eebaa kiiompa kiya Anii bedaa unu magoo kisee too dimi apaanta ikii ma kiiomegee taapa naa ya? Mee yogaa to mee nadoomeei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yogaa to eemeemaagea kaboo Yesus me omaago ma \"Paa aa pooi\" see asigi naaki mee paa da peega, gaayaa naaki yogaa to kaa deemaata agiyoo yuwa taa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mée yuwa pe-seomegea kaboo Wa me topenaa see bagee yuwa okoo too toomuu taakea kaboo okoo me Yesus asiino, \"Inii me 'Paa pooi' see asiyaa naaki se peega kuwa kaasee kaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wa me asiino, \"Ikii me mikee gaano dimii mee sikii taa kuwa me paa poono taa. Anii mikee kisiino ko: Ikii Ogatamee mikee gaano dimii mee peenaa too kiyaa miya ebo agiyoo ukuwaaniyaayaa. Kuwa ko ikii me mikee gaano dimii mee sesawi poo keepa peedi ena mee keta kiyaa miya ikii me mee maga bagoo to 'Getadoota woo maa kaa pakaanii' see asiyu ko woogeta siyaayaa. Ikii me se ukuwamaayaa agiyoo ena ma taa kiyaa. ");
INSERT INTO auu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ikii me yaabagaapii sedee sepea paa tomaa mee gaayu ko sembahyang taano ma, naano agiyoo tapoo toogee taano ma kuwa koo semaata kaama too abagaapeasiyaa, see paa tomaa mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesus me topenaa see bagee yuwa Galilea wee kaa Wa paagoo aadee semaata Wa me asiino, \"Mée Yogaa mee omaago see bagee paagoo yaekegatagaapea. ");
INSERT INTO auu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yaekegataata kaama wugimagaapea kiya wedaagoo to naagoo Ogatamee me aya andoo peeyaatagi\" see asigi naaki Wa me topenaa see bagee yuwa dimi gaagaa ebo. ");
INSERT INTO auu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus mee Wa me topenaa see bagee yuwa ma okoo Kapernaum magaa kaa peemaata kaama kiyoo toomuu taaka too ko mée ena Petrus paagoo meemaagi. Waa ko Ogatamee me ee kaa pajak kepee yamasetaa see mée. Wa me Petrus asiino, \"Ogatamee me ee kaa pajak kepee kuwa ikii me Guru me edaayaa ye, se edaayaa ye?\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","\"Mikee, edaayaa\" asigi. Petrus ee kaa peemaata kaama mena eewegaano taa kaboo Yesus Wa me keta Petrus paagoo asiino, \"Simon, Ani me kaapaadiinaka, mee ko magaa to kaa tookee eboo gaayu ko pajak kepee mee wa me maamee taano kepee yamasiyaa? Waa ma tomaa kaa bagee yuwa me kepee yamasiyaa ye, apanaa tomaa kaa bagee yuwa me kepee too yamasiyaa ye? Aa kaasee gaage?\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus me asiino, \"Apanaa tomaa kaa bagee kuwa me kepee too yamasiyaa\" see asigi. Yesus me asiino, \"Mikee, Waa ma tomaa kaa bagee yuwa okoo se edaayaa ");
INSERT INTO auu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","kiya inii mée se kagoo kisi yoka pajak kepee kuwa naaedaai. Aa peedoota uwo pikuu da kaa peemaata kaama kago magaai. Maataata kaama doge petamanii kaapa mee mee ebeawee kitaa pose kepee ena toopa. Mee kepee mee masegeeta enaa taano pajak kepee naaedaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kuwa kaboo da Yesus me topenaa see bagee yuwa meedoota Wa paagoo asiino, \"Ogatamee Wa too ebo mée eetotaa see yoo kiyoo esee ebo kiyaa bagee kuwa maamee naa kaata naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus me yoga peedi ena \"Meei\" asigi. Mee yoga peedii to okoo yupii da kaa ekeata kaama asiino, ");
INSERT INTO auu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","\"Anii mikee kisiino ko: Ikii ebo dimii, ebo menaa ekeata yoga me dimii, yoga me menaa se masiyu ko ikii taa ma taa Ogatamee Wa too ebo mée eetotaa see yoo se kiseemiyaayaa. ");
INSERT INTO auu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","See kemaata okoo ekaato dimi peedi ekeata kaama mee yoga peedii to mee mokoo kiyaa bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo okoo esee ebo kiyaa. ");
INSERT INTO auu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mee see see yoga peedii to Ni ekaa yiba daamaa badaa maayaa bagee kuwa Anii miya daamaa badaa namaayaa mokoo, see kuwa mikee kisega.\" ");
INSERT INTO auu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","\"Yoga me dimii masiyaa bagee kuwa Anii mikee nagaayaa bagee okoo mée waa ena too too miya mée me deebaa naadi kaama waa pedeo agiyoo ukuwayu ko mee deebaa sipi mée to yaai. Waa kaakaa da taa ebo omaa gadeata maakaa piku yiba tamekumiino daamaa. ");
INSERT INTO auu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Magaa da kaa mée pedeo kisi naadi deebaa siyaa menaa eebaa. Mée deebaa see menaa weganaa naadi kaama mée me pedeo agiyoo maamaa ukuwaandaa siwoo taapa kuwa mikee kaapa kiya kuwa mée deebaa see menaa weganaa see bagee kuwa yaai, okoo umina pedeo kaatagea. ");
INSERT INTO auu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A me yagaa da me yee, a me badoo da me yee kuwa me pedeo agiyoo ukuwayu ko daageeta tameepeasii. Aa kisee too umiwoo, toowoo taa see yoo seemaano ko yagaa, bado enaato boota see seemaano miya daamaa. Kiya aa yagaa wiya ma, bado wiya ma se modeemaayaa see biyaa yiba katameamaatagi kuwa pedeo. ");
INSERT INTO auu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bedaa a me emaa mee me pedeo agiyoo ukuwayu ko bigimegeeta tameapeasii. Aa kisee too umiwoo, toowoo taa see yoo seemaano ko emaa keepa enaato taa see seemaano miya daamaa. Kiya aa emaa keepa ekea paaya neraka biyaa yiba katameamaatagi kuwa pedeo yoka.\" ");
INSERT INTO auu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","\"Kuwa yoga me dimii masiyaa bagee ena ma daba, peedi se ekeasii. Ani me kisiino ko: Okoo malaikat bagee agoo. Kuwa okoo me malaikat bagee yuwa epoo to wodoo Neataagi paagoo epo enaataa toogeekea yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mée Yogaa mee egata bagee yuwa daba daagimaa peeyaano see naadi meta yoka kisega. ");
INSERT INTO auu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ni me kisiinaka menaa kuwa ikii kaasee gaagea? Daamaa gaagaa taai. Mee ko mée ena wa me domba wodaa eebaa, ogei me badoo ena agoo kiya ena mee egayu ko waa kaasee ukuwayaa? Woda eebaa yaato sembilan puluh sembilan kuwa maga kutuu to kaa aii ekeata egapi mee mee abaano see naadi peeyaa, se maa? ");
INSERT INTO auu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anii mikee kisiino ko: Mee domba wodaa mee deemaayu ko esee ede kiyaa. Wa me ede kiyaa kuwa ko kuwa sembilan puluh sembilan egaano taa yuwa kuwa kaa ede kiyaa see see se kiya mee domba wodaa ena too too mee kaa too esee ede kiyaa. ");
INSERT INTO auu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mee mokoo miya epoo to wodoo Ikiitaagi mee kuwa yoga me dimii masiyaa bagee yuwa ena ma umina egaano kuwa Waa be.\" ");
INSERT INTO auu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Bedaa Wa me topenaa see bagee yuwa paagoo asiino, \"Anii mikee nagaayaa bagee ena me pedeo kakiyaagi gaayu ko kuwa menaa da wa paagoo ekea too daamaa koogo aawegaa taai. Waa a me menaa da daamaa kayeeyu ko mena taa keta kaama wodoo ekea daamaa dimii, daamaa menaa kaa umiwoo, toowoo siyaa. ");
INSERT INTO auu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kiya waa a me menaa se kayeeyu ko ekea me menaa kiyeetaa, kideetaa see bagee mée ena, wiya badaa maadoota wa paagoo bedaa daamaa aawegaa taai, Ogatamee me menaa yiba kisee bagee badaa magaai see ebeamaata see see. ");
INSERT INTO auu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mena aawegaa semaata kaama mee mée to kuwa bagee me menaa da miya si yayeeyu ko peedoota Anii mikee nagaayaa bagee uduma paagoo eewegaai. Kuwa mikee nagaayaa bagee okoo eebaa kuwa me menaa kuwa miya si yayeeyu ko waa kisee yaekeasii. Mikee, waa ko Ogatamee ewo see bagee mokoo, pajak kepee yamasegee see bagee mokoo, waa kisee bagee ena yoka yaekeasii. ");
INSERT INTO auu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Anii mikee kisiino ko: Magaa da kaa ikii me mena ena too too yadaakomee siyaa menaa kuwa ko epoo to wodoo Ogatamee me yadaakomee seta menaa doodoo too kaapa. Kuwa ko ikii me 'Kisee daamaa, kisee pedeo' see yadaakomee siyaa menaa kuwa ko Ogatamee me 'Kisee daamaa, kisee pedeo' see yadaakomee seta menaa yuwa doodoo too kaapa. Bedaa ikii me 'Kuwa mikee menaa, kuwa makapaa menaa' see yadaakomee siyaa menaa kuwa miya Ogatamee me 'Kuwa mikee menaa, kuwa makapaa menaa' see yadaakomee seta menaa yuwa doodoo too kaapa. ");
INSERT INTO auu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Bedaa Anii mikee kisiino ko: Magaa da kaa kiyoo ikii mée wiya ena dimii, ena menaa kaa 'Kisee mée yaukuwaai, kisee mée yaukuwaai' see asiyu ko mikee Neataagi me kiyiipi, kiukuwaapi. ");
INSERT INTO auu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mikee, mée wiya yee, wedo yee okoo Ani ekaa yiba kutuu taa siyaa yoo kiyoo Anii okoo yupii da kaa eetuyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kiyoo kaama Petrus me Yesus asiino, \"Tuhan, Aa mikee kagaayaa bagee apanaa ena me anii pedeo agiyoo naukuwayaabuu segee siyu ko mee mée to ani me kaagaa magoo naa epa yaekeasiino gaano pedeo naa ya? Pedeo agiyoo kaagaa petoo waa naa naukuwayaa kiyaa miya ani me waa epa yaekeasiyaa ye, epa si yaekeasiyaa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus me asiino \"Taa, kaagaa petoo too epa yaekeasiyaa see se kiya kaagaa bado bado see petoo kiyaa miya epa yaekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","See kemaata Ogatamee Wa too ebo mée eetuyaa kuwa ebea-ebea menaa ena mee ko kisee: Magaa to kaa tookee eboo ena me wa me agiyoo yaokagee see bagee okaayoo okoo kaa agoo see bagee yuwa nakade-maneesi see dimii agoo. ");
INSERT INTO auu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kuwa okaayoo yuwa kadi-maniino see kaboo wa me agiyoo yaokagee see mée ena, wa kaa okaayoo kepe eebaa, se egamaayaa. Waa ma okaayoo agoo naadi mee eboo paagoo badaa maageegea. ");
INSERT INTO auu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Waa kepe sikii taa, si yakademaayaa. Kepe sikii taa naadi mee eboo me wa kaa tabogetaa see bagee yuwa asiino, 'Mee mée to wa kaa okaayoo yuwa nakade-maneesi yoka waa ma, wa me api, yogaa yuwa ma, wa me agiyoo-pagiyoo yuwa uduma pe-nadoogii' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mee agiyoo yaokagee see mée mee moga wa paagoo kagu maga kaa sebaata kaama asiino, 'Yaai, ebo bagee, anii kana, epeekaa deemagaapa naagoo kakadiita yoka eto kiipaa koogo tooi' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mee eboo me waa epa nao naadi wa kaa okaayoo yuwa uduma yawisintaata daba peeyaagi. ");
INSERT INTO auu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mee agiyoo yaokagee see mée to peedoota agiyoo yaokagee see mée apanaa ena paagoo, waa ma okaayoo agoo see mée to ma aadookea. Okaayoo peedi kiya mee mée to kaakaa da taa peneata omaago ma asiino, 'Ni me okaayoo nakadii' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mee mée to moga kagu maga kaa sebaata kaama asiino, 'Mée yogaa to, anii kana, epeekaa kakadiita yoka eto kiipaa koogo tooi' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kiya wa me si yayeeta kaama kagoo kaa mee mée to peneata digiyoo ee yiba nadogeamaasi naadi eepeegi. Eepeemaata kaama digiyoo ee yiba dogeamaagea. Mee mée to wa me okaayoo yuwa uduma yakadetagaatagi naagoo too daba peeyaayaa. ");
INSERT INTO auu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wa me kuwa yaukuwagi yuwa agiyoo yaokagee see bagee apanaa yuwa me deeta kaama epa nao naadi mee magaa to kaa tookee eboo paagoo pe-eewegagea. ");
INSERT INTO auu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mee eboo me kagoo kaa mee agiyoo yaokagee see mée to 'Badaa namaagii' asigi. Badaa maageegea kaboo wa me asiino, 'Yaai, aa dimi pedeo see mée. A me maamaa nasege mee me anii a me okaayoo uduma kaepa kaa kawisintaaga. ");
INSERT INTO auu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ani me aa kaepa kepa kuwa see see a me miya aa ma epo enaataa ukuwagee see mée to mee epa kaano, daa ye?' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Waa kagoo ebo kaa mee mée to digiyoo ee yiba tameamaagi, wa me okaayoo yuwa uduma mantaata kaama wodoo too waa daba peeyaayaa, see koo siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesus me mee ebea-ebea menaa da eewegamaata kaama asiino, \"Mee mokoo miya ikii uduma, ikii esee dimi menaa da me Tuhan mikee gaayaa bagee apanaa yuwa epa se ekeasiyu ko epoo to wodoo Neataagi me miya kisee kiukuwaatagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus kuwa menaa yuwa eewegamaata kaama Galilea wee kaa kaama peedoota Yordan dee kaa uwaasii yaato Yudea wee kaa. ");
INSERT INTO auu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mée eebaa Wa sekaataa peegea. Peemaata kaama ikiyoo yago bagee yuwa ikiyoo yataa kiyaabuu seta. ");
INSERT INTO auu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kuwa kaboo da Parisi kaa bagee yuwa noonaa Wa paagoo meemaagea. Yesus me koopoo see menaa wegasi naadi okoo me Waa apaadiino, \"Api ekeasiino gaayu ko api aii be kaa ekeasiino kuwa naa dagu ye, daa ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus me asiino, \"Ogatamee me menaa ena mee ko kisee: 'Petamanii mée tomaa ogaataata Mée me paayogaa ma, api ma ogaataata' see ebeamaata menaa mee ikii diino taa, ewo ye? ");
INSERT INTO auu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mena ena miya topa, mee ko kisee: 'Kuwa me kemaata paayogaa gakata waataagi ma, wabaayo ma kuwa ekeata kaama wa me goeyaa apii to ma ekea bogaa má ena too too mokoo kiyaa, kisee too umiwoo, toowoo siyaa' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ekea bogaa keta kaama dimi ena-ena see se kiya dimi ena too too see kiyaa. Kisee kemaata Ogatamee me ena too too kiyaata agiyoo kuwa mée me aapataga see se siyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisi kaa bagee me asiino, \"Aapataga see se siyaai see gaayu ko kaasee kaa Musa me ebeamaata menaa yiba api ekeasiino ko api ekeasiyaa ya? Wa me menaa mee ko kisee: 'Apimee ekeasiino see gaayu ko api ekeasiino kapogee mee keta apimee ebea-maneeta kaama ekeasiyaa' see menaa da ebeamaata\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus me asiino, \"Musa me api ekeasiyaa menaa mee ko ikii dimi pesee, se kitupimaayaa bagee yuwa kemaata kaama api ekeasiino ko ekeasiyaa, see menaa ebeamaata. Kiya petamanii mée tomaa ogaataata naagoo kaama kisee api ekeasiino menaa mee taa. ");
INSERT INTO auu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ani me kisiino ko: Paimee me apimee ekeata kaama apanaa apii goeyu ko waa tobaaka taakee mée to kiyaa. Apimee tobaaka sepa gaayu too paimee me ekeasiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wa me topenaa see bagee yuwa me asiino, \"Paimee ma, apimee ma aapataga see dimii agoo kiyaa naadi api se geano too daamaa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesus me asiino, \"Mikee, mée eebaa api tapoo kuwa kana, se toomaayaa. Api se goeyaa bagee mée eebaa taa, Ogatamee me pesee kiyaata bagee yuwa too api tapoo toomaayaa. ");
INSERT INTO auu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kuwa ko mée noonaa agoo keta yoo kaama edo pedeo kaa api se goeyaa, mée noonaa edo daapeata kaama api se goeyaa, bedaa mée noonaa ko 'Ogatamee Wa too ebo mée eetotaa see Mée yoka Wa me agiyoo too yaukuwawoo, umiwoo taapa' see dimii gaayaa bagee kuwa miya api se goeyaa. Kuwa menaa masemaayaa bagee yuwa daamaa masii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kuwa kaboo da yoga peedi yuwa Yesus me okoo kaa yagaa daamaa yamaataata kaama sembahyang yaukuwasi naadi Wa paagoo eemegea. Kiya Wa me topenaa see bagee yuwa me kuwa bagee yuwa kagoo kaa \"Yaai, kisee se\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesus me asiino, \"Kuwa yogaa yuwa Ni paagoo daba misi yoka si yawasii. Okoo kuwa see see yoga me dimii masetaa see bagee kuwa okoo Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa eetuyaa bagee yuwa yoka okoo Ni paagoo miyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yoga yuwa kaa yagaa yamaataata kaama apanaa magaa kaa peeta. ");
INSERT INTO auu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Egaa ena naagoo mée ena Yesus paagoo meemaata kaama asiino, \"Guru, anii iminoo miya, iminoo miya kisee too toowoosi naadi daamaa ukuwayaa agiyoo naa maagiyoo ukuwayaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus me asiino, \"Daamaa see agiyoo maagiyoo naa see menaa mee kaasee kaa nasege? Mikee daamaa see Mée mee ko Ogatamee Wa too, kaama taa. Aa kisee too umiwoo, toowoo taa see yaato seemaano ou see dimii gaape ko Wa me menaa ipiipi yadeewoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mee mée to me asiino, \"Ogatamee me menaa yiba mapea menaa naa ya?\" see asigi. Yesus me asiino, \"Ikii mée se wugii, tobaaka se taai, oma se masii, kobaakee menaa si yakobaai, ");
INSERT INTO auu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","okonaka ebo ekeasii, bedaa aa ekaato miya epa kiyaa see see apanaa bagee miya epa kaai, see menaa kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mee egaanaa da me asiino, \"Kuwa menaa kuwa uduma anii daamaa ipiipi deewoo segeeka yoka mee kaama amoo menaa naa agoo kiyaa ye naadi kaapaadeeka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus me asiino, \"Kisee aa Ogatamee me menaa uduma sikii, uduma daamaa yayeetaa see mée kaano see dimii gaape ko a me agiyoo yuwa uduma pe-doogeeta kaama masiipe kepee kuwa daba bagee aii manii. Aa kisee ukuwamaata kaama epoo to wodoo agiyoo yuwa kaagoo kiyaata kaama kisee too masiwoo siyaa. A me kepee kuwa uduma wudikomeeta kaama Ni sekaataa nameei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kiya mee egaanaa da me kuwa menaa yeeta kaama dimi nagimigi. Wa me agiyoo tabaa da eebaa kemaata dimi gaagaa ebo kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesus me Wa me topenaa see bagee yuwa asiino, \"Anii mikee kisiino ko: Kepe yago bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko esee kana. ");
INSERT INTO auu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bedaa Ani me kisiino ko: Unta wodaa mee abi tokogoo da yibaa taa mikee pakaa-seomiyaa kiya kepe yago bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko kana\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wa me topenaa see bagee yuwa kuwa menaa yeeta kaama esee dimi nagimaakee kaa asiino, \"Kepe yago bagee kuwa daba daagimaa poono kana kiyu ko maamee naa daba daagimaa peeyaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wa me okoo maamaa pe-deeta kaama asiino, \"Mée daba daagimaa poono mee ko mée me se ukuwamaayaa agiyoo kiya Ogatamee Wa me too uduma agiyoo uduma ukuwamaayaa see Mée yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petrus me asiino, \"Inii me agiyoo-pagiyoo uduma ekeata kaama A sekaataa metaake kuwa Aa mée deege. Inii maagiyoo naa masiitage?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wa me okoo asiino, \"Anii mikee kisiino ko: Iminookaa Ogatamee uwoo to, magaa to gipii kiyaatagi naagoo Mée Yogaa mee Wa me ebo animagaano yoo animaata ebo toowoo taatagi, diino esee ebo. Ikii Ni sekaataa bagee yuwa miya ebo animagaano yoo gaasi ma wiya animaata kaama Israel bagee mée apa gaasi ma wiya kuwa mena ena too too yadaakomee siwoo taatagea. ");
INSERT INTO auu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eto ko okoo Ni sekaataa nameeno see naadi okoo me ee, okoo ma kenaa bagee yuwa, okonaka, yogaanii yuwa, bugi, kisee ekeata bagee kuwa okoo me kuwa ekeata yuwa bedaa apanaa miya maamaa masegee taapea, bedaa iminoo miya, iminoo miya kisee too umiwoo, toowoo taatagea. ");
INSERT INTO auu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kiya eto kiipaa ebo kiyaa bagee mée eebaa kuwa iminookaa yaato peedi kedaa taatagea, bedaa eto kiipaa peedi kiyaa bagee mée eebaa kuwa iminookaa yaato ebo kedaa taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus me asiino, \"Ogatamee Wa too ebo mée eetuyaa kuwa ebea-ebea menaa ena mee ko kisee: Bugi epoo mée waa esee pedeo komaa kaama wa me anggur poo bugii yayagaano bagee abaano see naadi peegi. ");
INSERT INTO auu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Deemaata kaama wa me okoo asiino, 'Egapii ena ko kepe ena-ena kiniipa yoka bugi pe-nayagaai' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Keno eboo-taboo see kaboo bedaa waa bugi yayagaano bagee apanaa miya abaano see naadi peedoota agiyoo edaagee yoo pasar kaa peemaagi too ko mée noonaa aii toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wa me asiino, 'Ikii miya ni me bugii pe-nayagaai, ikii me ukuwaapea doodoo kiniipa yoka' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Okoo bugi kaa peegea. Keno mée mumoo to kaa pakaamaagi see kaboo waa bedaa yumakaa asigi-asigi pe-asigi. Bedaa keno ese-kotoonigi see kaboo miya pe-asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bedaa uwaataa da peedoota mée topea yoo peemaagi too ko mée noonaa aii toomuu taakea. Wa me asiino, 'Ikii kaasee kaa kenaagoo egapii aii toomuu taakea ya?' see asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","'Agiyoo naukuwaai see mée asiino bagee taa kaa' see asegea. Wa me asiino, 'Kisee gaayu ko ni me bugii pe-nayagaai' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sege menaa da bugi epoo mée me wa me bugii yadiitoo taa see mée to asiino, 'Kuwa bugi nayagapea bagee yuwa uduma mena naogaai. Okoo uuto mepea bagee kuwa keta naedaai. Kuwa edaamaata kaama keno ese-kotoonigi see kaboo mepea bagee yuwa naedaai, kisee-kisee petamanii mepea bagee yuwa kaa too' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Okoo wodopasi uwaataa mepea bagee yuwa kepe ena-ena masegea. ");
INSERT INTO auu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mee doodoo, mee doodoo kepe masegea, kisee too pedeo komaa kaama bugi yayagapea bagee yuwa. Kuwa bagee yuwa me gaano, 'Inii kepe ebo masiipea yoka' see gaagea kiya okoo miya kepe ena-ena too masegea. ");
INSERT INTO auu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Okoo kepe maseta kaama bugi epoo mée kagoo kegea. ");
INSERT INTO auu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Okoo me asiino, 'Kuwa uuto uwaataa mepea bagee kuwa keno ena too too bugi kayagapea kiya inii ko pedeo komaa kaama, kana ma tani aweta peetaa sepe kiya okoo ma, inii ma endagii see mée manege' see asegea. ");
INSERT INTO auu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kiya bugi epoo mée me okoo waa ena paagoo asiino, 'Mée yogaa to, nayeede. Anii kadeebaa taano taa. Anii yumakaa \"Egapii ena gaayu ko kepe ena-ena see kiniipa\" see kisiyaa naaki a me \"Daamaa\" see nasege kuwa mikee, se maa? ");
INSERT INTO auu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mikee yoka a me bugi nayaataa to mokoo da mee dogaai. Ani me aa kaneega see see anii kuwa uuto mepea bagee miya kisee maneekee ede. ");
INSERT INTO auu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kuwa ni nekee agiyoo yoka ni me mée maniyaa-maniyaa kuwa ni me gaayaa-gaayaa doodoo too maniyaa, se maa? Anii kabu see dimii taa, mée uduma maniino too see mée kemaata nakagoo kegea ye?' see aseta, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bedaa Yesus me asiino, \"Mee mokoo miya eto kiipaa ebo kiyaa bagee kuwa iminookaa yaato peedi kedaa taatagea, bedaa eto kiipaa peedi kiyaa bagee kuwa iminookaa yaato ebo kedaa taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus Waa Yerusalem magaa kaa pakataaki too eta mana kaa Wa me topenaa see bagee gaasi ma wiyaa to okoo too peenaa eepeanta kaama asiino, ");
INSERT INTO auu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","\"Ikii daamaa nayii. Inii Yerusalem magaa kaa pakataakea. Pakaamaata kaama wodoo Mée Yogaa mee imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo paagoo mée me yaekegatagaapea. Ekegataata kaama 'Waa bogaano gaano pedeo' see menaa yadaakumiipea. ");
INSERT INTO auu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kiyoo kaama apanaa tomaa kaa bagee paagoo yaekegatagaapea. Okoo me wisineekee menaa wisineapea, pepeaduu me dakameamoo taapea. Dakameamoo semaata piya bokoo to kaa booyaapea kiya wedaagoo to naagoo Ogatamee me Waa aya andoo peeyaatagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kuwa kaboo da Zebedeus me apimee wa me yogaa Yakobus ma, Yohanes ma wiya Yesus paagoo eemega. Okooto wa me idimaano menaa ena agoo naadi kaama Yesus paagoo kagu maga kaa sebaata toga. ");
INSERT INTO auu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus me asiino, \"Aa maagiyoo naidimaano see mege?\" see asigi naaki \"A too ebo mée eetoowoo siyaa yoo kiyoo kuwa ni me yogaa wiya kuwa miya Aa ma epo enaataa ebo toowoosi yoka A geboo da kaa ebo natuyaai. Ena mee A me dagi yagaa yaato naekeasii, ena mee eka yagaa yaato naekeasii, see menaa kuwa kasiino see naadi mega\" see asega. ");
INSERT INTO auu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus me okoo asiino, \"Ikii me naidimegea kuwa dimi ipiipi see gaamagaano taa kaa naidimegea. Anii boodi abaano gaano pedeo, boodi abaakee uwoo otaawee yiba kaama nuyaa mokoo see see yoka Anii miya naapa mokoo ekea miya nuyaa ye?\" asigi naaki \"Mikee, nuyaa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus me asiino, \"Mikee, ekea miya naapea kiya Ni me dagi yagaa yaato 'Aa', bedaa eka yagaa yaato 'Waa' see asiyaa kuwa Ni me se asiyaa. Neataagi me too kuwa asiitagi bagee yuwa kiyoo ebo tuyaatagi keekee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wa me topenaa see bagee apanaa gaasi yuwa me kuwa kenaaya kaasee menaa idimegea naadi kagoo kegea. ");
INSERT INTO auu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus me Wa me topenaa see bagee yuwa \"Uduma meei\" asigi. Wa me okoo asiino, \"Apanaa tomaa kaa bagee yuwa okoo me eboo yuwa gaayu ko dimi mena pesee, okoo anii ebo yoka naadi omaago ma ebo totaa see bagee yuwa, see kuwa ikii miya ipi. ");
INSERT INTO auu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Okoo kisee bagee kiya ikii gaayu ko kisee dimii se masii. Ikii yupii ebo kaano see dimii gaayaa bagee kuwa ko ikii yupii daba bagee me agiyoo aii yaukuwaai, ");
INSERT INTO auu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","bedaa ikii yupii ekaa pege-pege see mée kaano see dimii gaayaa bagee kuwa ko ikii me kana see agiyoo aii kiokagee siyaa mée to mee see see kaai. ");
INSERT INTO auu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mée Yogaa mee miya kisee. Anii meta mee ko 'Ni me agiyoo naukuwaai' see aseekee mée kaano see naadi se kiya 'Ni me kana see agiyoo naukuwaai' see yayeekee mée mokoo kaano see naadi meta. Kuwa ko Anii ekaato ekegataata mée kaa yaboogiino see naadi meta, bedaa mée eebaa okoo Ogatamee ma menaa kuwa yataa kiyaata daba daagimaa peeyaano see naadi meta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus ma, Wa me topenaa see bagee yuwa ma Yeriko magaa kaa kaama peetaaki too mée eebaa Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kuwa kaboo da taa eta geboo da kaa emaa digiyoo see bagee ekea wiya animaata totaakea. \"Yesus mee amoo-segeki\" see menaa yeeta kaama ekea ebo menaa-menaa kaa \"Tuhan, Daud ma apaa kaa Mée Aa epa mée gaai, epa mée gaai\" see aseamookea. ");
INSERT INTO auu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kiyoo topea bagee yuwa me kagoo kaa \"Ekea koogo tooi\" asegea kiya ekea bedaa maamaa mena ogegea. \"Tuhan, Daud ma apaa kaa Mée, epa mée gaai, epa mée gaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus mee kiyoo tuguunta kaama kuwa mée wiya asiino, \"Ekea maagiyoo naidimegea?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","\"Tuhan, enaa emaa diino keago see ede\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wa me epa kaa ekea emaa yuwa kaa yagaa yamaataagi naaki taka ena emaa awee keepeata kaama kisee ki Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus ma, Wa me topenaa see bagee yuwa ma okoo Yerusalem geboo da kaa magaa ena kaa pakaamaayu, Zaitun Kutuu to kaa Betpage see magaa kaa. Kiyoo pakaamaata kaama Yesus me Wa me topenaa see bagee mée ekea wiya asiino, ");
INSERT INTO auu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","\"Peedoota nakaayoo doodoo magaa kaa peemaata kaama keledai wodaa oka ena opeemaata topa, pooduu to ma enaataa see kuwa ekea diipea. Mee wodaa ope gokataata kaama ekea paaya Ni paagoo nadoomeei. ");
INSERT INTO auu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mena kisiyaa bagee agoo kepa ko 'Tuhan me gaano pedeo yoka' see naasii. Okoo me 'Daamaa, moga dogaai' see kisiipea yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesus me kuwa aseta menaa kuwa ko idukaa Ogatamee me nabi bagee paagoo aseta menaa kuwa uwa daasi naadi aseta, kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","\"Sion magaa kaa bagee paagoo kisee naasii: 'Deeweei, ikii me Eboo mee ikii paagoo migi. Waa dimi daba kaa keledai wodaa dagii da kaa animaata migi, keledai poodu to wodoo taa ikii paagoo migi' see naasii\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kuwa topenaa see bagee wiya Yesus me asigi menaa da yaasiino see naadi peegea. ");
INSERT INTO auu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Peemaata kaama keledai wodaa okooto ma, pooduu to ma doodoota Wa paagoo eemegea. Okoo me dokaa yuwa keledai wodaa dagii da kaa sekeetaata kaama wodaa da dagii da kaa Yesus animaayu. ");
INSERT INTO auu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yerusalem magaa kaa peegee see etaawee mée eebaa okoo me tapaato dokaa yuwa beagee naadi etaawee daamaa yasekeepegeekea, mée noonaa me piya ukuu yuwa taageeta kaama etaawee daamaa yamagapegeekea. ");
INSERT INTO auu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Okoo keta peetaakea bagee yuwa ma, uuto peetaakea bagee yuwa ma kuwa ebo menaa-menaa kaa \"Hosana, Daud ma apaa kaa Mée mee niiyaapaagee taai! Tuhan ekaa yadoopi Mée mee migi yoka magiyaage! Hosana, Asii-sege see Mée mee niiyaapaagee taai!\" see wegapegeekea. ");
INSERT INTO auu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesus mee Yerusalem magaa kaa pakaamaagi too ko kiyoo toogee see bagee yuwa dimi oogea. \"Mee maamee naa ya?\" see asegea naaki ");
INSERT INTO auu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","\"Mee ko Nabi eboo Yesus mee, Galilea wee kaa Nazaret magaa kaa Mée mee\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kiyoo kaama Yesus peedoota Ogatamee me ee kaa peemaata kaama ee geboo da kaa kiyoo agiyoo pe-doogee taa see bagee uduma abagakomeeyu. Kepe aapeka taa see bagee yuwa ma, poodee see bedoo pe-doogee taa see bagee yuwa ma okoo me keagee yuwa yagepeepi-paapi semaata eke. ");
INSERT INTO auu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wa me okoo asiino, \"Ogatamee me ebeamaata menaa ena mee ko kisee: 'Ni me ee mee ko sembahyang taa see ee see ekaa weewoo taapea' see ebeamaata kiya ikii me ko oma masetaa see bagee totaa see yoo mokoo yakiyaagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Waa Ogatamee me ee geboo da kaa toomuu taa siyaa naaki emaa digiyoo see bagee yuwa ma, bado pedeo poono naka see bagee yuwa ma okoo Wa paagoo megea. Wa me daamaa yakiyaabuu taaki kemaata ");
INSERT INTO auu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","kiyoo yoga tabaa da Yesus yaapaagee senaakea menaa ko \"Daud ma apaa kaa Mée, kiiboo, magiyaage\" senaakea. Kiya imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma kuwa kagoo kegea. Kuwa Wa me dimi nagii-nagii agiyoo yuwa miya be, kuwa Waa yaapaageekea menaa kuwa miya be. ");
INSERT INTO auu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Okoo me kagoo kaa Yesus asiino, \"Yaai, kuwa kaapaageekea menaa kuwa Aa yeege ye?\" asegea naaki \"Ei, Anii yeega. Idukaa Ogatamee me menaa yiba mena ena mee ko kisee: 'Yoga peedi yuwa ma, ama kaa yogaa yuwa miya okoo me Ogatamee Aa kaapaagee siyaa menaa kuwa A me agoo kiyaage' see ebeamaata menaa kuwa ikii diino taa, ewo ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kuwa menaa asemaata kaama peedoota Betania magaa kaa kiyoo pe-ometa. ");
INSERT INTO auu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Omemaayu tokoma mee da pedeo tokomaa da Yesus mee pakadoota Yerusalem magaa kaa eta mana kaa naano agiyoo naadi kaa. ");
INSERT INTO auu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Deamaagi too ko eta geboo da kaa ara see piyaa wodoo ena kiyoo agoo. Peedoota piya manii da kaa peemaata deeyaa naaki poo taa, iye too agoo. Wa me mee piya wodoo to asigi menaa ko \"Eto kaama wodoo poo ota ena ma se ekaape\" see asetaagi naaki taka ena kisee ki wii keepeasega, iye yuwa denaagooga. ");
INSERT INTO auu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wa me topenaa see bagee yuwa dimi nagimaakee kaa asiino, \"Mee piyaa wodoo to taka ena kiipaa ki iye denaagoota kaama wii kega kuwa naa kaasee ukuwaanega naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus me asiino, \"Anii mikee kisiino ko: Ikii dimi wiya taa, mikee gaano dimii mee too kiyu ko ikii miya kisee agiyoo ukuwaaniyaayaa. Ani me mee ara piyaa wodoo to wii kiyaaga kuwa ikii miya ukuwaaniyaayaa. Kiya mee too se. Ikii me 'Mee maga bagoo to mee bikimedoota maakaa piku yiba tamekumii' see asiyaa kiyaa miya kisee ukuwaaniyaayaa. ");
INSERT INTO auu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ikii me sembahyang menaa kaa idimiyaa agiyoo kuwa Tuhan mikee nao see gaakee kaa idimiyu ko ikii mikee masiipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus mee Ogatamee me ee kaa peemaata kaama mée yuwa topetaaka too ko imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo Wa paagoo meemaagea. Okoo me asiino, \"Yaai, A me ukuwanaa see agiyoo kuwa ko maamee me 'Aa kisee naukuwaai' see kaseta kaama ukuwanaa segeeke? Maamee me Aa ebo kaekeata kaama ukuwanaa segeeke?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus me asiino, \"Ani me miya ikii kiapaadee taanaka. Ikii me miya Anii mena daamaa nasegea kepa ko ikii me 'Maamee me kaseta kaama A me kisee agiyoo ukuwanaa segeeke?' see naapaadeekea menaa mee Anii miya daamaa kisiipa. ");
INSERT INTO auu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ni me kiapaadee see menaa mee ko kisee: Uwo mée yatukumeta mée Yohanes mee gaayu ko wa paagoo 'A me mée yuwa uwo natukumaai' see menaa kuwa maamee me aseta menaa naa ya? Epoo to wodoo kaama Ogatamee me aseta menaa da ye? Aii mée me aseta menaa da ye? Kaasee? Nasii\" see asigi. Okoo too koogo aawegaa taano, \"Yaai, inii Waa kaasee menaa asiipea? Inii me 'Epoo to wodoo kaama Ogatamee me aseta menaa yoka' see asiyu ko Yesus me mée asiipi menaa ko 'Mikee yoka ikii kaasee kaa Yohanes me weganaa seta menaa kuwa mikee nao see gaano taa ya?' see mée asiipi. ");
INSERT INTO auu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bedaa inii me 'Ogatamee me Yohanes aseta menaa se, aii bagee me aseta menaa' see asiino miya pedeo, mée yuwa me mée kagoo kaapea. Okoo me 'Yohanes mee nabi bagee eboo yoka ikii kaasee kisee pedeo menaa wa kaa yawegagea ya?' see mée asiipea menaa kuwa inii weda yoka kuwa asiino menaa wiya kuwa ekea paaya iyo\" see menaa kuwa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Okoo me kuwa menaa aawegaa semaata kaama Yesus asiino, \"Yohanes paagoo maamee me aseta menaa see kuwa inii ewo keekee\" see asegea. Yesus me asiino, \"Ikii me daamaa nasiino taa yoka Ani me miya ikii me 'Maamee me Aa kaseta kaama A me kisee agiyoo ukuwanaa segeeke?' see nasegea menaa kuwa se kisiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Bedaa Yesus me kuwa Yahudi kaa ebo-ebo yuwa asiino, \"Ni me kisiinaka menaa kuwa ikii kaasee gaagea? Daamaa gaagaa taai. Mee ko kisee: Mée ena waa paayogaa yogaa wiya agoo. Nagamee me yoga yagamee asiino, 'Eto kenaagoo aa anggur poo bugii pe-nayagaai' asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Be' asigi kiya kaama too dimi daamaata bugi kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bedaa nagamee me menaamee asiino, 'Eto kenaagoo aa anggur poo bugii pe-nayagaai' asigi naaki 'Daamaa, neataagi' see asigi kiya se peegi. See kuwa. ");
INSERT INTO auu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Eto ko kuwa yogaa wiya kuwa kamee me nagamee me menaa daamaa yayeeta pe-ukuwagi? Ikii kaasee gaagea ya?\" see asigi. Okoo me asiino, \"Yagamee mee\" see asegea. Yesus me asiino, \"Anii mikee kisiino ko: Mee mokoo miya pajak kepee yamasegee see bagee ma, otoopa kepe masenaa see apii ma kisee bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo okoo keta kiyoo seemaatagea yoka nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kuwa ko uwo mée yatukumeta mée Yohanes mee ikii paagoo umiino, toono kuwa topoo see etaa kiomeetagaano see naadi meta kiya ikii yayiino taa kemea. Kiya pajak kepee yamasegee see bagee ma, otoopa kepe masenaa see apii ma kisee bagee kuwa mikee nao see gaagea. Okoo mikee gaagea kuwa ikii miya deemea kiya ikii dimi daamaata kaama mikee nao see gaano taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus me asiino, \"Ebea-ebea menaa ena miya yeeweedeei, mee ko kisee: Bugi epoo mée anggur poo bugii ena yaatayu. Yaataata kaama wagee uduma aanakitayu. Mee bugii kaa oma ena, ebo omaa masegeeta oma togaawee anggur poo tagimemaata uwo yuwa kitaa isisi naadi denemaata eke, bedaa bugii da diitoo taa see ee miya maatayu. Maataata kaama apanaa bagee me bugi nayaagee segeesi naadi yaekeata kaama apanaa magaa kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maamaa omegee naadi kaama kuwa poo kapoo kega kaboo bugi epoo mée me wa paagoo agiyoo yaokagee see bagee yuwa asiino, 'Peedoota ni me bugii nayaagee see bagee yuwa paagoo ni me see yuwa namasigii' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Peedoota bugi kaa peemaagea naaki bugi yayaagee see bagee yuwa me okoo peneata kaama waa ena mee aii dakamegea, ena mee wogeepeasegea, ena mee oma kamu me wogeepeasegea. ");
INSERT INTO auu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mee asii kaawaa ena ma wa me agiyoo yaokagee see bagee eebaa peeyaagi kiya bedaa petamanii yuwa ukuwata-ukuwata see see ukuwagea. ");
INSERT INTO auu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kaama too wa me yogaa to 'Pooi' asigi. Wa me gaano, 'Niyoopaa yoka Wa me menaa kuwa okoo me daamaa yayiipea' see gaata kaama peeyaagi. ");
INSERT INTO auu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kiya okoo me yogamee beesekaa kaama migi see deeta kaama koogo aawegaa taano, 'Mee ko yogamee. Nagamee me bugii da mee yogamee me masiitagi yoka niiwogeepeasii, wa me bugii da inii takeasiino ke' see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yogamee peneata wagee amoo yaato dogeamaata kaama wogeepeasegea, see koo seta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus me kuwa Yahudi kaa ebo-ebo yuwa asiino, \"Mee bugi epoo mée metaki meedoota bugi kaa meemaata kaama kuwa bugi yayaagee see bagee yuwa kaa maagiyoo yaukuwaapi? Ikii kaasee gaagea?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Okoo me asiino, \"Kuwa dimi pedeo bagee yoka mikee wogeepii naadi kaama mee bugii da apanaa bagee me daamaa nayagageesi naadi yaekeasiipi. Poo daayaa kaboo wa me see yuwa okoo me daamaa maniipea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesus me asiino, \"Ogatamee me ebeamaata menaa ena mee daamaa nekeenii. Mee ko kisee: 'Oma ee maataa see bagee yuwa me be kaa wisintaata tameepeata omaa mee ko TUHAN me masegeeta kaama tuku omaa to mee daamaa pee-yaekeata. Ekeata kaama inii me TUHAN, kiiboo nao naadi yaapaagee seta' see ebeamaata menaa kuwa ikii diino taa, ewo ye? ");
INSERT INTO auu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","See kemaata Ani me kisiino ko: Ogatamee Wa too ebo mée eetotaa see yoo ikii me komoo taa kaapa. Ogatamee me ikii me komoo yuwa apanaa tomaa kaa bagee yuwa me poo daamaa naekayaabuu siwoosi naadi maniipi. ");
INSERT INTO auu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mee pee-yaekeata omaa mee kaa okaayaa bagee yuwa daada-paada siyaa, bedaa mee omaa to me pe-dapimiyaa bagee yuwa miya tagiindaa siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Imam ebo yuwa ma, Parisi kaa bagee yuwa ma okoo kuwa ebea-ebea menaa yuwa yeemaata kaama okoo 'Wa me inii mée gaataata kaama mée asigi menaa ii' see kuwa nekeenegea. ");
INSERT INTO auu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kagoo kaa Yesus peneasiino see dimii agoo kiya mée yuwa wedaagea. Mée yuwa me Yesus Waa nabi bagee ena see gaagea kemaata peneasiino kuwa wedaagea. ");
INSERT INTO auu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bedaa Yesus me ebea-ebea menaa kaa kiyoo bagee yuwa asiino, ");
INSERT INTO auu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","\"Ogatamee Wa too ebo mée eetuyaa kuwa ko ebea-ebea menaa ena mokoo, mee ko kisee: Magaa to kaa tookee eboo ena wa me yogaa api goeano naagoo mée yuwa naano agiyoo epo enaataa ede ma eenaano see naadi ");
INSERT INTO auu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","wa me agiyoo yaokagee see bagee yuwa paagoo asiino, 'Ikii peedoota anii miyoo taa mona asenaa sema bagee yuwa paagoo kisee pe-naasii: \"Eto ko naano agiyoo naano ke meei see kisigi\" see pe-naasii' see asigi. Kuwa menaa doodoota okoo paagoo yaasenaakea naaki be kegea. ");
INSERT INTO auu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bedaa mee eboo me wa me agiyoo yaokagee see bagee apanaa yuwa asiino, 'Ikii peedoota kuwa miyoo taa meei see asema bagee yuwa kisee pe-naasii: \"Naano agiyoo ipiipii semaagea. Sapi wodaa yuwa ma, degaatoo yago wodaa yuwa ma kuwa wugimaata kaama gapemaagea yoka moga meei\" see pe-naasii' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Peedoota kuwa menaa yaasenaakea naaki wisintaata okoo me ukuwataa see agiyoo yiba seemegea. Waa ena bugi kaa peegi, noonaa apanaa agiyoo ukuwaano see naadi peedaakea. ");
INSERT INTO auu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Okoo noonaa me kuwa pee-yaasenaakea bagee yuwa peneata kopaa dakamemaata kaama wogeepeasegea. ");
INSERT INTO auu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mee eboo kagoo ebo. Wa me okaa yago bagee yuwa me kuwa mée wogepea bagee yuwa uduma wogeepeata kaama okoo me ee yuwa biyaa yaiyaasegea. ");
INSERT INTO auu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mee eboo me wa me agiyoo yaokagee see bagee yuwa asiino, 'Naano agiyoo noogee yoo ipiipii semaagea kiya kuwa miyoo taa meei see asema menaa nawisintaata bagee kuwa anii ma epo enaataa naano ko pedeo, be. ");
INSERT INTO auu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eto ko peedoota ebo etaawee kitaa aadee taapea yuwa uduma \"Naano agiyoo naano ke meei\" see niiasenaa taai' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Okoo peedoota etaa da kaa aadookea bagee yuwa uduma, dimi daamaa bagee miya, dimi pedeo bagee miya uduma badaa maageeta kiyoo kutuukea, mee ee kaa mée maamaa pudii. ");
INSERT INTO auu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kuwa kaboo da mee eboo me mée yuwa diino see naadi peedoota naano agiyoo noogee yoo peemaata deamaagi too ko mée ena, api goeano naagoo magaakee dokaa magaano taa bagee ena tupi. ");
INSERT INTO auu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mee eboo me asiino, \"Ei, mée yogaa to, api goeano naagoo magaakee dokaa mee aa magaano taa kaa kaasee seemege naa ya?\" see asigi naaki waa koogo, mena taa. ");
INSERT INTO auu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mee eboo me wa me agiyoo yaokagee see bagee yuwa asiino, 'Mee mée mee yagaa bado one gadimemaata maayoo kaa yaato digiyoo yiba dogeamaai. Kiyoo ko yege ma, gaagaa ma too totaa see yoo' see aseta, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bedaa Yesus me okoo asiino, \"Mee mokoo miya okoo mée eebaa paagoo 'Eto meei' see asiyaa kiya Ogatamee me mée daamaa wigintaata yaato ko mée eebaa taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kuwa wodoo Parisi kaa bagee yuwa kutuu semaata Yesus deebaa taano see naadi aawegaa taano, \"Yesus me koopoo see menaa wegasi naadi inii mapea menaa apaadeekee naa ya?\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","\"Kisee-kisee apaadiino daamaa\" see wegamaata kaama pe-apaadiino bagee wiginegea. Parisi kaa bagee me topetaa see bagee yuwa ma, Herodes yaato bagee ma wiginegeeta kaama \"Ikii peedoota Yesus paagoo kisee-kisee niiapaadee taai\" see asegea. Okoo peedoota Yesus paagoo asiino, \"Aa ko dimi topoo see Mée to ii see kagaage, bedaa Ogatamee me etaa yaato menaa mée tupiino kuwa miya A me daamaa topoo see menaa kaa too mée topetaa see Mée to ii kagaage. A me mée tupiino kuwa mée me kakagoo kiyaa miya mée tupiino too, bedaa ebo bagee me menaa miya Aa weda taa kaa mikee menaa too topenaa segeeke kuwa inii kaipi yoka ");
INSERT INTO auu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","inii kaapaadee see menaa ena agoo. Mee ko inii pajak kepee Kaisar maniino kuwa maneekee daamaa ye, pedeo ye? Aa kaasee gaage? Mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kiya okoo me pedeo dimii mee Wa me nekeenta kaama asiino, \"Yaai, ikii dimi daamaa poga-poga see bagee yuwa, kaasee ikii me Anii nadeebaa taano see naadi nasegea menaa naa ya? ");
INSERT INTO auu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pajak kepee edaano see naadi pose kepee ena Anii nadeeyaai\" see asigi. Doomaagea kaboo ");
INSERT INTO auu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesus me asiino, \"Mee kepee mee kaa maamee ebeyumaa da, maamee ekaa da ebeamaata naa ya?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","\"Kaisar mee\" asegea. Yesus me asiino, \"Kisee gaayu ko Kaisar maniino agiyoo yuwa kuwa Kaisar manii, bedaa Ogatamee maniino agiyoo yuwa kuwa Ogatamee manii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wa me asigi menaa da okoo dimi nagimegea. Waa esee ipi yoka naadi peedaakea. ");
INSERT INTO auu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bedaa mee naagoo miya Saduki kaa bagee mée noonaa Yesus paagoo meemaagea. Okoo me wegawoo see menaa ena mee ko kisee: \"Mée booyaa kuwa ko umina bogaakee, aya se andoo peeyaa\" see menaa wegawoo see. ");
INSERT INTO auu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Okoo me Yesus asiino, \"Ei, Guru. Musa me ebeamaata menaa ena mee ko kisee: 'Mée ena yoga taa kaa booyu ko waa ma kenagaa ena me mee api miyaa da goeano gaano pedeo. Petamanii booyaa mée me yoga yakabayaa mokoo yakabasi yoka tuyaa mée me mee apii goeai' see ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kisee ebeamaata yoka mena ena kasiinake, mee ko kisee: Okoo kenaa bagee okoo petoo. Yagamee yagaaboo to api ena goegi. Waa yoga taa kaboo boogi. Mee api miyaa da ipuugamee me goegi. ");
INSERT INTO auu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ipuugamee miya yoga taa kaboo boogi, bedaa mabeimee miya kisee. Kisee too petaagoo to amaadii to kaa too. ");
INSERT INTO auu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kaama too apii to miya booga. ");
INSERT INTO auu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eto inii kaapaadee taano ko kisee: Boota bagee mikee aya andoo peeyu ko iminookaa mée aya andoo peeyaa naagoo kuwa okoo kenaa bagee petoo to kuwa mee apii to too goeta yoka kamee me apii kaata naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus me asiino, \"Ikii ewo kaa naapaadeekea. Ikii Ogatamee me ebeamaata menaa miya ewo, Wa me pesee kuwa miya se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kuwa ko Ogatamee me boota bagee yuwa aya andoo peeyaabuu taatagi naagoo api goeano miya taa, api mée maniino miya taa. Okoo epoo to wodoo malaikat bagee mokoo kaatagea. ");
INSERT INTO auu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Boota bagee aya andoo peeyaa ii see kuwa nekeeniino menaa agoo. Ikii diino taa, ewo ye? ");
INSERT INTO auu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ogatamee me Musa paagoo aseta menaa kuwa ko kisee: 'Anii ko Ogatamee, Abraham ma, Isak ma, Yakub ma okoo me Eboo' see aseta. Ogatamee Waa okoo me Eboo see wegayu ko umina boota bagee kuwa kaa kisee se wegayaa, aya tuyaa bagee kuwa kaa too see wegayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kiyoo topea bagee yuwa Yesus me topeta menaa kuwa ipi yaai naadi dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesus me Saduki kaa bagee paagoo mena taa kiyaagi see menaa kuwa doodoota Parisi kaa bagee paagoo eewegagea naaki 'Yaai, inii kaasee ukuwaapea, kaasee menaa wegaapea' naadi kutuu semaagea. Mena aawegaa semaata ");
INSERT INTO auu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","okoo mée ena, Musa me menaa mée topetaa see bagee ena peedoota Yesus paagoo Waa ipi ye, ewo ye naadi apaadee taano see naadi apaadiino, ");
INSERT INTO auu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","\"Ei, Guru. Musa me ebeamaata menaa yiba ebo menaa, mena tukuu to mee kamee naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus me asiino, \"Mena ena mee ko kisee: 'A me Eboo TUHAN Ogatamee mee dimi menaa da uduma me esee ou gaai, bedaa a me gaayaa dimii yuwa uduma me miya Waa esee epa kaai' see mee mena ena. ");
INSERT INTO auu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mee menaa da esee ebo, kaama asii taa. ");
INSERT INTO auu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bedaa mee mokoo miya wiyaagoo to menaa mee ko kisee: 'Aa ekaato miya epa kiyaa see see apanaa bagee miya epa kaai' see ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ogatamee me menaa yiba mena tukuu to ko kuwa menaa wiya too. Kuwa ko Musa me menaa yuwa miya, nabi bagee me menaa yuwa miya manii to ko kuwa mena wiya kuwa too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi kaa bagee yuwa okoo kiyoo enaataa kutuu semaata toomuu taakea kaboo Yesus me okoo asiino, ");
INSERT INTO auu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","\"Idukaa kaama wegawoo seta Mée Ebo Kristus mee ko maamee me asii-kaba-kaba seta bagee kaa agoo kaatagi? Ikii kaasee gaagea?\" see asigi naaki \"Mee gaayu ko Daud me asii-kaba-kaba seta bagee kaa agoo kaatagi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus me asiino, \"Mikee kiya Ebo Kristus mee Daud me Tuhan see ekaa weeta. Daud waa Ogatamee me Roh mee ma enaataa kemaata wegata. Tuhan see ekaa weeta mee kaasee kaa ya? Daud me wegata menaa kuwa kisee: ");
INSERT INTO auu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'TUHAN me ni epoo Mée Tuhan mee paagoo asiino, \"Aa Ni me dagi yagaa yaato animagaai, kisee too Aa ma yape kiyaa bagee yuwa kuwa Ani me daba, peedi kaekeata A me badoo da miyoo taa kaekeasiita\" see aseta' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Daud me Ebo Kristus mee ko 'Ni epoo Mée Tuhan mee' see wegata yoka Ebo Kristus mee kaasee Daud me asii-kaba-kaba seta bagee ena kiyaa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kiyoo topea bagee me mena kamu ena ma asiino taa. Mee naagoo kaama wodoo mée me Waa apaadee taano wedaagea. ");
INSERT INTO auu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kiyoo kaama Yesus me kiyoo kutuukea bagee yuwa ma, Wa me topenaa see bagee yuwa ma okoo asiino, ");
INSERT INTO auu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","\"Musa me menaa mée topetaa see bagee ma, Parisi kaa bagee ma kuwa okoo Musa me ebeamaata menaa yuwa mée tupiwoosi naadi wiginta bagee yoka ");
INSERT INTO auu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","okoo me kisiyaa menaa uduma yayii. Kiya okoo me ukuwaa-ukuwaa, poo-poo kuwa se obeai. Okoo me 'Kisee niideewoo taai, kisee niiukuwawoo taai' see wegagee siwoo siyaa kiya mena me too wegataa see bagee, ukuwaano yaato se ukuwataa see bagee yuwa yoka ikii gaai, nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Okoo me mée paagoo 'Kisee ukuwaai, kisee ukuwaano gaano pedeo' see menaa-panaa kuwa ukuwaano kana. Okoo me kuwa menaa-panaa kuwa mée kaa yadootaata kaama mée yuwa ma epo enaataa eeukuwaano be kegeekea. ");
INSERT INTO auu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Okoo me ukuwanaa, peenaa see agiyoo yuwa uduma mée me nadeesi naadi too ukuwanaa, peenaa segeekea. Kuwa ko Ogatamee me menaa ebeamaata kapogee siki yuwa one kaa opeetagaa naadi maanaa taano kuwa okoo me one gakee kapo peedi see kuwa be, ebo see onee kaa too maanaa siyaa. Bedaa doka otoo to kaa one opeekomee naadi maanaa taano kuwa miya okoo me katu see onee kuwa be, togoo see onee kuwa too maanaa siyaa. ");
INSERT INTO auu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ebo naagoo naano agiyoo nuyaa yoo miya okoo woopasi ebo bagee me animaayu taa see yoo kiyoo too animagaano ede, sembahyang segee see ee yiba miya mée me nadeesi naadi woopasi animaayu taa see yoo kiyoo too okoo animagaano ede. ");
INSERT INTO auu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bedaa okoo mée kutuu taa see yoo kiyoo okoo peenaa siyaa kaboo mée me 'Epao, inii me eboo' see naapaagee taano miya ede, 'Kiiboo, Ebo Guru' see naekeasiino too kuwa miya ede see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Okoo kisee bagee kiya ikii miya kisee se. Mée me ikii 'Ebo Guru' see kiseekee se. Ikii me Ebo Guru mee ena too too, bedaa ikii paaya uduma ena doodoo, ikii Wa yiba ena kenaa bagee yoka Ebo Guru see kiseekee se. ");
INSERT INTO auu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bedaa ikii me magaa da kaa bagee paagoo 'Neataagi' see kuwa miya se asii. Ikiitaagi mee ko ena too too, epoo to wodoo Ikiitaagi mee yoka mée paagoo 'Neataagi' see aseekee se. ");
INSERT INTO auu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bedaa mée me ikii 'Ni me eboo' see kiseekee miya se. Ikii me Eboo ena too too, mee ko Ebo Kristus mee. ");
INSERT INTO auu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ikii yupii mikee ebo kiyaa bagee kuwa ko okoo ekaato dimi peedi ekeata kaama ikii me agiyoo aii kiokagee see bagee kuwa too mikee ebo kiyaa. ");
INSERT INTO auu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Okoo ekaato ebo ekee taa see bagee kuwa peedi kaatagea, bedaa okoo ekaato peedi ekee taa see bagee kuwa ebo kaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bedaa Yesus me asiino, \"Ikii Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma yaai. Ikii ipi poga-poga see bagee yuwa too yoka pedeo kaatagea nao. Mée yuwa okoo Ogatamee Wa too ebo mée eetotaa see yoo seemaano kuwa ikii be kegea. Ikii kenee to kaa yatakeata taamege-taamege taa see bagee yuwa. Ikii miya keneawee se pakaaneekea, bedaa pakaaniinaka ou see gaayaa bagee yuwa miya ikii me taamege-taamege yasegeekea. ");
INSERT INTO auu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yaai, ikii dimi daamaa poga-poga see bagee yuwa, api miyaa yuwa ikii me deebaa naadi kaama okoo me ee yuwa oma yatakimiyaa bagee yuwa, bedaa ikii mée me naapaageesi naadi sembahyang siyaa yuwa togoo-togoo see too taa see bagee yuwa. Ikii me kisee ukuwanaa see bagee yuwa yoka ikii esee pedeo kaatagea. ");
INSERT INTO auu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ikii Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma yaai. Ikii ipi poga-poga see bagee yuwa too yoka pedeo kaatagea. Ikii mée ena waa naa ikii yaato kiyaano see naadi uwoo to, magaa to peenaa, nawenaa segee siyaa kiya ikii me waa dimi pedeo see bagee yuwa too kiyaayaa. Mee ko ikii neraka magaa kaa pedeo kaatagea kuwa waa kaagaa wiyaagoo to ma mee asii esee pedeo kaatagi see mee ikii me waa kisee kiyaayaa. ");
INSERT INTO auu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yaai, ikii keta mée eepeetaa see kiya ikii emaa digiyoo see bagee mokoo. Ikii me mée tupiino menaa ena mee ko kisee: Mée waa ena me wegaano ko 'Anii taa ma taa kisee ukuwaapa, Ogatamee me ee mee yoka see menaa mee ma enaataa wegaga yoka' see menaa kuwa wa me wegayu ko wa me 'Anii kisee ukuwaapa' see wegapi agiyoo mee se ukuwaano miya daamaa. Kiya mée waa ena me wegaano, 'Ogatamee me ee yiba emas kaa ukuwata agiyoo-pagiyoo yoka see menaa mee ma enaataa wegaga yoka' see menaa kuwa wa me wegayu ko wa me 'Anii kisee ukuwaapa' see wegapi agiyoo mee se ukuwaano ko daa. Ikii kisee menaa mée tupiwookea. ");
INSERT INTO auu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yaai, ikii dimi taa, emaa digiyoo kiyaa bagee yuwa mokoo. Emas kaa ukuwata agiyoo-pagiyoo kuwa ebo agiyoo se kiya Ogatamee me ee mee too ebo. Kuwa emas kaa agiyoo-pagiyoo kuwa Ogatamee me ee yiba topa kuwa me ebo kiyaa. Kuwa agiyoo kuwa Ogatamee me ee yiba toono taa naaki aii agiyoo mokoo kiyaa yoka Ogatamee me ee mee too ebo. ");
INSERT INTO auu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bedaa ikii me mée tupiino menaa ena mee ko kisee: Mée waa ena me wegaano, 'Anii taa ma taa kisee ukuwaapa, Ogatamee paagoo agiyoo kupi-manee taa see yoo yoka see menaa mee ma enaataa wegaga yoka' see menaa kuwa wa me wegayu ko wa me 'Anii kisee ukuwaapa' see wegapi agiyoo mee se ukuwaano miya daamaa. Kiya wa me 'Anii kupi-manee taa see yoo kiyoo kupi-manee taano agiyoo yoka see menaa mee ma enaataa wegaga yoka' see menaa kuwa wa me wegayu ko wa me 'Anii kisee ukuwaapa' see wegapi agiyoo mee se ukuwaano ko daa see menaa kuwa ikii me kisee mée topegeekea. ");
INSERT INTO auu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ikii emaa digiyoo kiyaa bagee yuwa yaai. Ogatamee paagoo kupi-manee siyaa agiyoo kuwa ebo se kiya Ogatamee paagoo agiyoo kupi-manee taa see yoo mee ebo. ");
INSERT INTO auu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","See kemaata mée waa ena me 'Ogatamee paagoo agiyoo kupi-manee taa see yoo yoka see menaa mee ma enaataa wegaga yoka taa ma taa ukuwaapa' see menaa wegayu ko kiyoo too se kiya kiyoo kupi-manee siyaa agiyoo kuwa ma enaataa wegayaa. Wa too, wa too see se. ");
INSERT INTO auu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Bedaa mée waa ena me 'Ogatamee me ee mee yoka see menaa mee wegaga yoka taa ma taa ukuwaapa' see menaa wegayu ko mee ee to too se kiya kiyoo tuyaa Mée Ogatamee ma enaataa wegayaa. ");
INSERT INTO auu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bedaa mée waa ena me 'Epoo to wodoo yoka see menaa mee wegaga yoka' see wegayu ko epoo to wodoo too se kiya Ogatamee me ebo animaayaa yoo ma, kiyoo animaayaa Mée to ma enaataa wegayaa. ");
INSERT INTO auu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ikii Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma yaai, ikii ipi poga-poga see bagee yuwa too yoka pedeo kaatagea nao. Ikii me agoo kiyaa agiyoo yuwa uduma gaaseagoo to mee Ogatamee paagoo manegee siyaa kiya Musa me menaa yiba yawegawoo, yaukuwawoo taano esee gaano pedeo menaa kuwa ikii otoopa eke-bake segee siyaa. Kuwa ko ikii ogei me poo, wedakamu, kisee peedi-paadi agiyoo yuwa miya gaaseagoo to mee dimi-dimi Ogatamee paagoo manegeekea kiya Musa me menaa yiba ebo menaa yuwa kuwa wisintagaa segeekea. Kuwa ko mée yupii da taa mena mée yadaakomee siyaa yuwa topoo see menaa kaa too mée yadaakumiino kuwa ikii se ukuwageekea, bedaa mée epa kaano ma, Ogatamee me menaa se daata yayeewoo taano ma kuwa miya ikii ko taa see bagee yuwa. Kuwa gaaseagoo to mee Ogatamee manegee taano kuwa daamaa manegee taai kiya kuwa ebo menaa yuwa, kuwa daamaa yayeewoo, yaukuwawoo taano esee gaano pedeo see menaa apanaa yuwa kuwa se gaabuu taai. ");
INSERT INTO auu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yaai, ikii emaa digiyoo kiya ikii keta mée eepeeyaa see bagee yuwa mokoo. Ikii otaawee yiba uwo nuyaa kaboo sikinu-sikinu peedii to dimi-dimi tameepeasiyaa kiya ikii me unta wodaa nookomee siyaa mokoo. ");
INSERT INTO auu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ikii Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma yaai, ikii daamaa poga-poga see bagee yuwa too yoka pedeo kaatagea nao. Otaawee tapaato yaato ikii dimi-dimi uwo wetogetaa see. Ikii mee see see miya ikii tapaato yaato dimi-dimi deegee see bagee yuwa kiya ikii semoo yiba yaato daa see agiyoo maamaa agoo. Ikii dimi omaago, kepe ou, agiyoo ou see dimii kuwa miya maamaa pudii. ");
INSERT INTO auu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yaai, ikii emaa digiyoo see bagee yuwa nao. Otaawee semoo yiba yaato keta daamaa wetogeai, mee kaama too tapaato yaato miya daamaa kiyaa. ");
INSERT INTO auu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ikii Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma yaai, ikii dimi daamaa poga-poga see bagee yuwa too yoka pedeo kaatagea nao. Ikii ko mée ogo maayaa yoo daamaa disi-disii siyaa mokoo. Tapaato yaato deeyaa naaki poodee agiyoo daamaa widimeta, daamaa dimi nagi see kiya semoo yiba yaato ko mée boota metoo tagi, dabeta wunuu maamaa pudii. ");
INSERT INTO auu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mee mokoo miya mée me ikii tapaato yaato kideeyaa naaki daamaa bagee yuwa keenda kiya semoo yiba yaato pedeo dimii, pedeo menaa maamaa pudii, mée deebaa see bagee yuwa too. ");
INSERT INTO auu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ikii Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma yaai, ikii dimi daamaa poga-poga see bagee yuwa too yoka pedeo kaatagea nao. Idukaa nabi bagee boota yuwa ma, Ogatamee me menaa yayeewoo seta bagee boota yuwa ma kuwa ikii epa poga-poga see dimii kaa okoo me ogo maagee yoo daamaa oma kutumeeii naadi kaama dimi-dimi asii-maga-maga siyaa. Ikii me wegayaa menaa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Idukaa bagee me nabi bagee yuwa wogeepii seta kuwa pedeo. Inii idukaa okoo ma epo enaataa toogee seta naaki inii okoo ma epo se wugiyaa, okoo me too wugiyaa' see wegageekea ");
INSERT INTO auu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","kiya kuwa makapaa menaa. Ikii miya nabi bagee wugiino dimii agoo see bagee yuwa yoka ikii okoo me yogaa yuwa mokoo. ");
INSERT INTO auu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","See kemaata kuwa nabi bagee wogeepii seta menaa kuwa ikii kaa miya maamaa eebaa kesea yoka kuwa idukaa bagee yuwa me pedeo ukuwata-ukuwata kuwa ikii miya ukuwawoo taai. ");
INSERT INTO auu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yaai, ikii otoogiyoo tabaa da, mée daakee otoogiyoo me asii-kaba-kaba bagee yuwa. Ikii biyaa piku yiba se peesi naadi ekaato daba daagimaa peeyaano agiyoo ena agoo ye? ");
INSERT INTO auu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kisee kemaata daamaa nayii. Nabi bagee yuwa Anii ikii paagoo pooi see asiita, bedaa ipi kiyaata bagee yuwa ma, mikee menaa kitopetaa see bagee yuwa miya kipeeyaabuu taata. Kuwa bagee noonaa ikii me wogeepii taatagea, noonaa piya bokoo to kaa ekeasiitagea, noonaa sembahyang segee see ee yuwa yiba kaama pepeaduu me dakameamoo taatagea, noonaa be kaa maga ena kaa kaama maga ena kaa too kisee too abaganaa, peenaa taatagea. ");
INSERT INTO auu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ikii me kisee ukuwaatagea yoka idukaa kaama kuwa pedeo taa see bagee wogeepii siwoo seta kuwa uduma petamanii kaama eto too ikii kaa too kaapa, ikii pedeo dogaapea. Petamanii wugimaata mée mee ko dimi topoo see mée Habel mee. Wodopasi wugimaata mée mee ko Berekya yoopaa Zakaria mee. Waa Ogatamee me ee to yupii, Ogatamee paagoo agiyoo kupi-manee taa see yoo yaayupii da kaa kiyoo wogeta. Habel ma, Zakaria ma kuwa yaayupi bagee uduma wogeepii siwoo seta menaa kuwa uduma ikii kaa too kaata. ");
INSERT INTO auu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Anii mikee kisiino ko: Kuwa wogeepii seta menaa kuwa uduma ikii etokaa tuyaa bagee yuwa kaa too kaata yoka daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bedaa Yesus me wegaano, \"Sooi, Yerusalem, Yerusalem, idukaa nabi bagee yuwa miya ikii me wogeepii siwoo seta, bedaa Ogatamee me ikii paagoo kimiyaata bagee yuwa miya oma kamu me wogeepii seta. Ayam poodu yuwa kidikaa da me dapimemaata kaama daamaa eetuyaa see see Ani me miya kisee maamaa ikii daamaa enaataa kikutumemagaano see dimii agoo kiya ikii me nabe kegeekea. ");
INSERT INTO auu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kisee kemaata daamaa nekeenii: Eto kaama wodoo Ogatamee ikii ma enaataa se kiitoopi. ");
INSERT INTO auu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mikee, Ani me kisiino ko Anii peeta kaama wodoo ikii se nadiipea, kisee too Anii bedaa meeta. Mee naagoo ko ikii me 'Tuhan ekaa yadoopi Mée mee migi yoka magiyaage!' see naapaagee taatagea\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus mee Ogatamee me ee kaa kaama peetaaki too ko Wa me topenaa see bagee yuwa Wa paagoo meemaagea. Okoo Ogatamee me ee mee ma, gebo kaa ee yuwa kuwa miya dimi nagimaakee kaa asiino, \"Tuhan, kuwa ee kuwa deede\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kiya Yesus me asiino, \"Kuwa ee yuwa kuwa diino esee daamaa kiya Anii mikee kisiino ko: Epeekaa kuwa uduma kabaapi-paapi taatagea, oma ena ma wa me mokataata yoo kaama kisee se ekeasiitagea, uduma pogadaa taata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kiyoo kaama Yesus peedoota Zaitun Kutuu to kaa peemaata kaama animaata toomuu taaki too ko Wa me topenaa see bagee yuwa okoo too Waa ma mena eewegaano see naadi meemaagea. \"A me kuwa yumakaa mée eewegape menaa kuwa maadee moga ukuwaaniita naa ya? Wodopasi yaato Aa wiyaagoo meeno see kooke ii see nekeeniyaa agiyoo kuwa maagiyoo ukuwaandaa taata naa ya? Mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Wa me asiino, \"Mée deebaa see bagee agoo kaata yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Anii poga-poga see bagee mée eebaa meetagea. Okoo me Ani ekaa naweakee kaa 'Anii ko Ebo Kristus yoka' see menaa weganaa naadi mée eebaa deebaa siwoo taapea. ");
INSERT INTO auu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kuwa kaboo da taa ko ikii yape menaa ekaapa magaa kaa kaama miya yiipea, beesekaa magaa kaa kaama miya yiipea kiya se wedaai. Kuwa uduma mikee agoo kedaa siwoo taata kiya wodopasi naagoo se. ");
INSERT INTO auu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mée tomaa-tomaa yape aawogee senaa taapea. Amokiyoo magaa kaa bagee me yamokiyoo magaa kaa bagee ma yape aawogee taatagea. Kiyoo-kiyoo naano agiyoo taa uwaa miya medaa taata, maga pigii miya medaa taata. ");
INSERT INTO auu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kisee yaai-yaai agiyoo yuwa eebaa kedaa taata kiya kuwa uduma petamanii ukuwaandaa taata yuwa too, api me yoga kabaano see naadi boodi meege-meege siyaa mokoo. ");
INSERT INTO auu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kuwa kaboo da mée me ikii kiwegee-wegee taano ma, kiwugimagaano ma, kisee kiukuwasi naadi kiekegatagaapea. Ikii Ni yaato bagee kemaata mée tomaa uduma kibe kaatagea. ");
INSERT INTO auu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kuwa kaboo da taa miya Ni sekaataa bagee kuwa mée eebaa nawisintagaapea. Nawisintaata aawegenee naadi kaama mée ena me mée ena yaekegatagaapi, kisee aabe kaa aaekegatagaa taapea. ");
INSERT INTO auu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nabi poga-poga bagee eebaa agoo kedaa naadi kaama mée eebaa deebaa senaa taapea. ");
INSERT INTO auu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pedeo dimii, pedeo menaa eebaa agoo kedaa naadi kaama mée eebaa okoo me mée epa dimii kuwa taa kedaa taapa. ");
INSERT INTO auu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kiya okoo makii taa, kisee too wodopasi yaato toowoo siyaa bagee kuwa daba daagimaa pootagea. ");
INSERT INTO auu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Etokaa doomega menaa kuwa naweganaa siwoo taapea. Kuwa ko 'Ogatamee Wa too ebo mée eetupi yoka' see menaa kuwa uwoo to, magaa to mée tomaa yuwa uduma yeesi naadi okoo paagoo wegakumiitagea. Wegakomeeta kaama wodopasi naagoo kaata.\" ");
INSERT INTO auu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","\"Esee pedeo see agiyoo eboo ena Ogatamee me ee yiba yiinaageeta totaaki see kuwa ikii diitagea. Kisee ukuwaaniita menaa kuwa idukaa nabi Daniel me wegawoo seta menaa yuwa. (Ikii eto kiipaa mee kapogee mee deetaakea bagee daamaa nekeenii.) ");
INSERT INTO auu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ikii me waa kisee kiyoo totaaki see deeta kaama Yudea wee kaa toogee see bagee kuwa moga oodoota kuye kaa pakadaa taai. ");
INSERT INTO auu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yoo da kaa tuyaa bagee yuwa ee yiba agiyoo se masii, se gaata oogaai. ");
INSERT INTO auu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bugi kaa tuyaa bagee yuwa miya doka, kisee ou agiyoo kuwa ee kaa pakaa-maseekee se. ");
INSERT INTO auu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kisee yaai-yaai oodaa naadi kaama kadapoo yago apii yuwa ma, yoga baayee yiba kepaa apii yuwa ma kuwa sooi, yaai. ");
INSERT INTO auu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ikii oogaapea kuwa ko dekaanta kiyaa naagoo miya, Sabat naagoo miya se oosea naadi sembahyang taai. ");
INSERT INTO auu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kuwa ukuwaandaa taata agiyoo kuwa ko apanaa agiyoo, yaai-yaai ebo, petamanii epoo to, magaa to ogaataata yoo kaama eto too miya ukuwaaniino taa agiyoo yuwa, bedaa kuwa wodoo taa epeekaa yaato miya kaagaa ena ma se ukuwaaniita agiyoo. ");
INSERT INTO auu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ogatamee me Wa me wiginta bagee yuwa epa nao naadi kuwa yaai-yaai, gaagaa siyaa agiyoo kuwa mani yataa kiyaatagi. Maamaa kisee too naaki mée ena ma se tuyaa. ");
INSERT INTO auu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kuwa kaboo da mée me 'Deede, Ebo Kristus mee nakaayoo tupi' see kisiyu ko emaa se wugii, bedaa okoo me 'Waa amokiyoo tupi' see kisiyaa miya wisintayu. ");
INSERT INTO auu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ebo Kristus poga-poga bagee ma, nabi poga-poga bagee ma kuwa agoo kaatagea yoka okoo wisintagaai. Mée deebaa taano see naadi dimi nagii-nagii agiyoo ukuwaaii taatagea. Ogatamee me wiginta bagee yuwa miya deebaa sedee taano see kiya iyo, se deebaa semaayaa. ");
INSERT INTO auu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ipiipi dii. Kuwa agiyoo uduma ukuwaandaa taano taa da kaa Ani me kisi-maneega yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mée me 'Ei, deede, ebo mee maga ugii da kaa kiyoo Ebo Kristus mee tupi' see kisiyu ko pe-si dii, bedaa okoo me 'Ei, waa ee yiba kitaa tupi' see kisiyaa miya emaa se wugii. ");
INSERT INTO auu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mée Yogaa mee meetagi naagoo ko bego-bego apaa to deeyaa mokoo kaata. Bego-bego apaa to awii yaato kaama masegeeta maga kapii to kaa too seke-wasii peega see deeyaa mokoo Mée Yogaa mee meetagi naagoo miya mée uduma kisee Waa diitagea. ");
INSERT INTO auu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bootaa da tuyaa yoo boota notaa see bedoo yuwa kiyoo kutuu siyaa.\" ");
INSERT INTO auu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","\"Kuwa yaai-yaai, ebo gaagaa uwaa kuwa omekomeeta wodoo taa kisee ki kenoo to digiyoo aatakii taata, agoo to mee miya se wikiiniita, okadee yuwa epoo to kaa kaama kigimedaa taata, bedaa epoo to kaa pesee agiyoo yuwa miya maki-makaa naadi wodeda-peeda sedaa taata. ");
INSERT INTO auu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kuwa kaboo da Mée Yogaa mee meenaki ii see kuwa nekeensi naadi agiyoo epoo to kaa agoo kaata. Uwoo to, magaa to mée tomaa-tomaa yuwa uduma kuwa agiyoo yuwa deeta kaama yegee taatagea. Mée Yogaa mee sinu dagii da taa migi see diitagea. Waa pesee, Waa asii-sege, Wa disii to esee ebo see diitagea. ");
INSERT INTO auu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Puusee too-too da ebo peeyaata kaama Wa me malaikat bagee yuwa 'Pooi' asiyaa naaki peedoota maga otoo to kaa kaama kisee too maga otoo to kaa too peenaa naadi Wa me daamaa wiginta bagee yuwa uduma enaataa yakutumeeii senaa taatagea.\" ");
INSERT INTO auu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","\"Eto ko ebea-ebea menaa ena yeeweei. Ara piyaa mee kagoo da iye mugumedaa naadi iye taki kega gaayu ko mikee, poo ekaano see kooka ii see kuwa ikii nekeeniyaa. ");
INSERT INTO auu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mee mokoo miya kuwa kisega menaa yuwa uduma ukuwaandaa taaka see kuwa ikii deeyu ko monaa da mee katu, ukuwaaniino see kooka ii see kuwa ikii nekeeniitagea. ");
INSERT INTO auu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Anii mikee kisiino ko: Kuwa ukuwaandaa taata agiyoo kuwa uduma eto mee begaa kaa bagee yuwa bogaano taa da kaa diitagea. ");
INSERT INTO auu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Epoo to ma, magaa to ma kuwa taa kaata kiya Ni me menaa mee se taa kaata, kisee too iminoo miya, iminoo miya toota.\" ");
INSERT INTO auu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","\"Monaa da mee ko mee naagoo, mee jam kaa see kuwa mée ena ma ewo. Malaikat bagee miya ewo, Ogatamee Yoopaa miya ewo, Nagamee Wa too ipi. ");
INSERT INTO auu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mée Yogaa mee meetagi naagoo ko idukaa Nuh mee tota kaboo magaa da kaa bagee me ukuwanaa, peenaa siwoo segee seta see see iminookaa miya okoo kisee agiyoo daba ukuwataaka too meetagi. ");
INSERT INTO auu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kuwa ko idukaa uwo ebo degaano taa kaboo mée tomaa yuwa okoo naano agiyoo noogee, api aamanee, api goegee, kisee daba ukuwawoo segee seta, kisee too Nuh mee kapal see komaa yiba seemeta yoo too. ");
INSERT INTO auu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Okoo me kisee kaapa, kisee kaapa see kuwa okoo ewo kaa ebo uwoo me okoo uduma dapimeta. Mée Yogaa mee meetagi naagoo miya kisee kaata. ");
INSERT INTO auu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mee naagoo mée ekea wiya bugi yagataaki too ko mée ena mee badaa maageeyu, ena mee kisee eke. ");
INSERT INTO auu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Api ekea wiya enaataa namo kupitaaka too ko ena mee badaa maageeyu, ena mee kisee eke, see kaata. ");
INSERT INTO auu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kisee kaata yoka ikii ipiipi see diitoo siwoo taai, ikii epoo Mée Tuhan mee meetagi naagoo ikii ewo yoka. ");
INSERT INTO auu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Daamaa nekeenii: Oma masetaa see mée daatooyiba yaato mee kenoo kaa, mee kenoo kaa meepi see kuwa ee epoo mée ipi naaki waa toomoo se umiyaa, ee se nakabasi naadi ipiipi see diitoo siyaa. ");
INSERT INTO auu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mee mokoo miya Mée Yogaa mee meetagi mee ikii se nekeeniyaa kaboo meetagi yoka ikii daamaa ipiipi diitoo siwoo taai.\" ");
INSERT INTO auu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","\"Agiyoo yaokagee see bagee yuwa dimi daamaa bagee gaayu ko waa kaasee mée? Mee ko wa me eboo me menaa uduma daamaa yayeewoo see mée, waa dimi ipi kaa too yaukuwagee see mée. Kisee mée to gaayu ko mee eboo me wa paagoo asiino, 'Kuwa agiyoo yaokagee see bagee apanaa yuwa kuwa a me daamaa nadiitoo taai, bedaa naano agiyoo eewudiino kuwa miya a me too' see asiyaa. ");
INSERT INTO auu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mee eboo maga nawigeeta ee kaa meemaata deeyaa naaki mee mée to me kuwa agiyoo yuwa daamaa yaukuwataaki yoka mee mée to daamaa, ede nao. ");
INSERT INTO auu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anii mikee kisiino ko: Mee kaama wodoo wa me agiyoo-pagiyoo uduma 'A me too nadeewoose yoka' see asiyaa. ");
INSERT INTO auu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Agiyoo yaokagee see mée dimi pedeo gaayu ko waa dimi yiba ni me eboo mee moga se meepi yoka naadi kaama ");
INSERT INTO auu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kuwa agiyoo yaokagee see bagee apanaa yuwa kopaa dakamegee taano ma, boomagaa see uwoo noogee see bagee yuwa ma epo enaataa eenoogee taano ma, kisee ukuwagee siyaa. ");
INSERT INTO auu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wa me eboo meepi naagoo ewo yoka waa miyaa naagoo ");
INSERT INTO auu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","mee mée to kopaa dakamemaata kaama dimi daamaa poga-poga naadi mée deebaa see bagee yuwa dogeamaayaa yoo kiyoo dogeamaapi. Kiyoo ko yege ma, gaagaa ma too totaa see yoo.\" ");
INSERT INTO auu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","\"Iminookaa Ogatamee Wa too ebo mée eetoowoo taatagi naagoo mée me diitoo siwoo siyaa ebea-ebea kuwa ko kisee: Api goeano naagoo ukuyogaa gaasi okoo pelita biyaa doodoota api goeano yoo peemaata kaama api goeano mée to diitoo siyaa. ");
INSERT INTO auu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Okoo idibi yaato dimi ewo, okoo idibi yaato dimi ipi. ");
INSERT INTO auu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dimi ewo idibii to kuwa pelita biyaa doopea kiya biyaa uwoo eebaa dogaano taa. ");
INSERT INTO auu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dimi ipi yuwa gaayu ko otaawee ma, biyaa uwoo yuwa ma uduma sikii. ");
INSERT INTO auu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Api goeano see mée to meemagaano epee naadi kaama kuwa ukuyogaa gaasii to okoo uduma toomoo ontokaa peegea. ");
INSERT INTO auu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Daatooyiba yupigapi maanegea. \"Anoogeeweei, waa migi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Okoo anoogeeta pelita biyaa yuwa ipiipii naadi kaama ");
INSERT INTO auu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","dimi ewo see idibii to okoo me amo kuwa dimi ipi see idibii to asiino, 'Inii me pelita biyaa deega-deega taaka nao, ikii me biyaa uwoo peenaa mée maniipea ye?' asegea naaki ");
INSERT INTO auu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Iyo, inii uduma se sikii kaapa. Ikii peedoota biyaa uwoo edaagee yoo pe-edaai' see asegea. ");
INSERT INTO auu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kiya okoo pe-edaano see peegea kaboo mee api goeano see mée to meemaagi. Kuwa biyaa uwoo agoo see idibi yuwa mee mée to ma api goeyaa ee yiba seemeta kaama kene moneewaagea. ");
INSERT INTO auu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kene munitaata wodoo kuwa dimi ewo idibii to meemaata kaama asiino, 'Neataagi, apee kene mée yakabatagaai, kene mée yakabatagaai' see asegea. ");
INSERT INTO auu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kiya wa me asiino, 'Anii mikee kisiino ko anii ikii kiewo see bagee yuwa' see asiyaa, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bedaa Yesus me asiino, \"Kisee kiyaa naadi ikii ipiipi see diitoo, umiwoo taai, mee naagoo, mee jam kaa meepi see kuwa ikii ewo yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","\"Mee naagoo diitoo siwoo siyaa bagee kuwa ebea-ebea menaa ena mee ko kisee: Mée ena waa beesekaa magaa kaa poono taa kaboo wa me agiyoo yaokagee see bagee yuwa 'Meei' asigi. Okoo uduma meemaagea kaboo kepe okoo ena-ena mantayu, kuwa ko iminookaa koga ma eebaa mokoo namasisi naadi yaeke. ");
INSERT INTO auu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Okoo mée dimi ipi yuwa mee doodoo, mee doodoo yawuditayu. Kuwa ko dimi ipi see mée ebo kepee idibi mantayu. Kiyoo kaama dimi ipi mokoo see mée ebo kepee wiya mantayu. Wodopasi mée ebo kepee ena mantayu. Kepe yawuditaata kaama waa apanaa magaa kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kepe idibi masipi mée me moga pe-doogeeta kaama kepe koga idibii to ma yatabeasigi. ");
INSERT INTO auu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kepe wiya masipi mée waa miya kisee kepe koga wiya ma yatabeasigi. ");
INSERT INTO auu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kiya kepe ena masipi mée mee ko peedoota maga ekegamaata kaama wa me eboo me kepee ena mee maga yiba yaboontaagi. ");
INSERT INTO auu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Maamaa omegee, toogee naadi kaama okoo me eboo meemaagi. Kuwa kepee yuwa egaano see naadi 'Meei' asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kepe idibi maseta mée wa me kepee gaasi kuwa doodoota wa paagoo asiino, 'Neataagi, a me ebo kepee idibii to naekeaseme kuwa eto koga kepee idibi yaato ma kamasemaaga yoka kuwa deede' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wa me eboo me asiino, 'Kiiboo, aa ko dimi ipi, ni me agiyoo daamaa naokagee see mée. Kuwa peedi agiyoo kuwa miya a me daamaa dimi-dimi naukuwagee segeeke see kadeega yoka ni me apanaa ebo agiyoo kuwa miya a me too nadeewoose naadi a kaa kaekeasiipa. Eto ko aa anii ma epo enaataa ede ma, ede ma umiwoo, toowoo taano yoka ni paagoo pakaanii' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kiyoo kaama kepe wiya maseta mée waa miya meedoota wa paagoo asiino, 'Neataagi, a me ebo kepee wiya naekeaseme kuwa eto koga kepee wiya yaato ma kamasemaaga yoka kuwa deede' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wa me eboo me asiino, 'Kiiboo, aa ko dimi ipi, ni me agiyoo daamaa naokagee see mée. Kuwa peedi agiyoo kuwa miya a me daamaa dimi-dimi naukuwagee segeeke see kadeega yoka ni me apanaa ebo agiyoo kuwa miya a me too nadeewoose naadi a kaa kaekeasiipa. Eto ko aa anii ma epo enaataa ede ma, ede ma umiwoo, toowoo taano yoka ni paagoo pakaanii' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Bedaa kiyoo kaama kepe ena maseta mée mee miya wa paagoo meemaata kaama asiino, 'Neataagi, aa dimi pesee see mée see kuwa anii kaipi. Aa kepe se masemaayaa agiyoo kuwa miya aa kepe masemaayaa. Kuwa ko a me weeno taa agiyoo miya ota yadaakee, bedaa aa poo keepa sigimaano taa agiyoo kuwa miya beo yadogaakee, aa kisee koo taa see mée. ");
INSERT INTO auu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kisee kemaata anii kaweda kaa a me kepee maga yiba kaboonemaama. Eto ko a me kepee mee topa yoka masii' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wa me eboo me asiino, 'Yaai, aa ko ni me agiyoo dimi pedeo kaa naokagee see mée, paayaa see mée. Anii weeno taa agiyoo miya ota yadaakee, bedaa poo keepa sigimaano taa agiyoo kuwa miya beo yadogaakee, kisee dimi pesee see mée yoka see kuwa a me nadeege. ");
INSERT INTO auu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A me anii kisee mée see nadeeyu ko ni me kaekeasema kepee mee aa bank kaa bagee paagoo namagame naaki daamaa, anii epeekaa masiyaa naagoo koga ma masiyaa yoka' see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wa me gebo kaa bagee paagoo asiino, 'Mee wa me kepee mee masegeeta kaama kepe gaasi agoo see mée to namanii. ");
INSERT INTO auu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kuwa ko agoo kiyaa bagee yuwa bedaa noonaa ma masiipea. Okoo koga eebaa kedaa taapea kiya taa kiyaa bagee yuwa okoo me peenaa kiyaa yuwa miya yamasegeeyaa. ");
INSERT INTO auu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mee mée to ni me menaa nayiino taa yoka maayoo kaa digiyoo yiba yaato tameai. Kiyoo ko yege ma, gaagaa ma too totaa see yoo' see kuwa mee eboo me aseta menaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","\"Mée Yogaa mee ebo mée eetoono see naadi malaikat bagee yuwa ma uduma enaataa meetagi. Mee naagoo Wa disii to ebo kaatagi. Wa me ebo animaayaa yoo kaama ebo mée eetoowoo taatagi, diino esee ebo kaatagi. ");
INSERT INTO auu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Magaa da kaa mée tomaa-tomaa yuwa uduma Wa ikigii to kaa kutumeeii naadi kutuu wiya ekeasiitagi, domba wodaa munitaa see bagee me domba ma, kambing ma wigintaayaa mokoo. ");
INSERT INTO auu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Domba kuwa Wa me dagi yagaa yaato ekeasiitagi, bedaa kambing yuwa miya Wa me eka yagaa yaato ekeasiitagi. ");
INSERT INTO auu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kisee wuditaata kaama mee Eboo me kuwa dagi yagaa yaato yuwa asiitagi menaa ko 'Kiiboo, Neataagi me ede kiyaa bagee yuwa ikii Ogatamee ebo mée eetuyaa yoo pakaaniweei. Anii idukaa uwoo to, magaa to uduma ogaataata kaboo ikii me tuyaa magaa mee kiipiipii semaata yoka pakaaniweei. ");
INSERT INTO auu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mee ko Anii naadi ketaaka too ikii naano agiyoo neesekea, Anii uwo naadi ketaaka too uwo neesekea, Anii meedaa, peenaaka too ikii me ee yiba badaa namaasekea, ");
INSERT INTO auu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Anii doka taa kaboo ikii me doka neesekea, Anii ikiyoo kusitaaka too ikii naiye-iyee sekea, Anii digiyoo ee yiba totaaka too ikii nadeegee sekea yoka pakaaniweei' see asiitagi. ");
INSERT INTO auu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kuwa daamaa, dimi topoo see bagee yuwa me asiitagea menaa ko 'Tuhan, Aa naadi ketaaka too inii kadeeta kaama naano agiyoo kaneeseke kuwa inii ewo, kame naagoo kaneeseke naa ya? Aa uwo naadi ketaaka too inii kame naagoo uwo kaneeseke? ");
INSERT INTO auu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aa meedaa, peenaaka too inii kame naagoo inii me ee yiba badaa kamaaseke? Aa doka taa kaboo inii kame naagoo doka kaneeseke? ");
INSERT INTO auu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aa ikiyoo kusitaaka too inii kame naagoo kaiye-iyee seke? Aa digiyoo ee yiba totaaka too inii kame naagoo kadeegee seke? Inii kisee kadiino taa, se maa?' see asiitagea. ");
INSERT INTO auu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mee Eboo me asiitagi menaa ko 'Anii mikee kisiino ko: Ikii me kuwa esee daba bagee yuwa kuwa Nii ma ena kenaa bagee yuwa mokoo naadi kaama kisee agiyoo yaukuwagee sekea kuwa Anii naukuwagee sekea mokoo yoka' see asiitagi. ");
INSERT INTO auu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kiyoo kaama Wa me eka yagaa yaato bagee yuwa miya asiitagi menaa ko 'Mba, pedeo ayaa kidootaata bagee yuwa peeweei, se modeemaayaa biyaa yiba pooi. Kiyoo ko Iblis ma, wa me malaikat bagee yuwa ma okoo paaya umiwoo, toowoosi naadi yaipiipii semaata yoo. ");
INSERT INTO auu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mee ko Anii naadi ketaaka too ikii naano agiyoo miya niino taa, Anii uwo naadi ketaaka too ikii uwo miya niino taa. ");
INSERT INTO auu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Anii meedaa, peenaa seta kiya ikii me ee yiba badaa namagaano taa, Anii doka taa kiya ikii me doka niino taa, Anii ikiyoo kusitaaka too ikii me naiye-iyee taano taa, bedaa Anii digiyoo ee yiba totaaka too miya nadiino taa yoka peeweei' see asiitagi. ");
INSERT INTO auu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Okoo me asiitagea menaa ko 'Tuhan, Aa naadi kaa yee, uwo naadi kaa yee, meedaa, peenaaka too yee, doka taa kaboo yee, ikiyoo kusitaaki too yee, digiyoo ee yiba totaaki too yee, kisee Aa gaano pedeo kaa totaake kiya inii epa kagaano taa see kuwa inii ewo, kame naagoo naa ya?' see asiitagea. ");
INSERT INTO auu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wa me asiitagi menaa ko 'Anii mikee kisiino ko: Ikii me kuwa esee daba bagee yuwa kuwa kisee agiyoo miya yaukuwaano taa kuwa Anii miya naukuwaano taa mokoo yoka' see asiitagi. ");
INSERT INTO auu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Okoo boodi abaagee see yoo pootagea kiya kuwa daamaa, dimi topoo see bagee kuwa iminoo miya, iminoo miya kisee too toowoo taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus me kuwa menaa yuwa wegamaata kaama Wa me topenaa see bagee yuwa asiino, ");
INSERT INTO auu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","\"Unu wiya omemaata Paskah naapea naagoo naapea see kuwa ikii ipi. Mée Yogaa mee piya bokoo to kaa boosi naadi ekegatagaapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kuwa kaboo da taa ko imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo Ebo Imam me ee yiba kutuu semaagea. Ebo Imam ekaa da ko Kayapas. ");
INSERT INTO auu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Okoo me \"Yesus mee inii kaasee koogo peneasiipea, kaasee patamaapea?\" see menaa kuwa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","\"Kiya kiipaa se, mée yuwa uduma kagoo ebo kaapea yoka Paskah noomaata kaama too Waa peneasiino daamaa\" see menaa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania magaa kaa mée ena ekaa da ko Simon mee tupi. Waa idukaa kado kaa meanee see agiyoo meanta mée to. Wa me ee kaa Yesus mee toomuu taaki too ko ");
INSERT INTO auu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","api ena meemaaga. Waa wunu daamaa see uwoo, kepe edaano ebo see uwoo, oma otaawee peedi ena yiba doopa. Yesus naano agiyoo notaaki too ko Wa me mumoo to kaa yakabagekomeega. ");
INSERT INTO auu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yakabagekomeega naadi Wa me topenaa see bagee yuwa kagoo kaa koogo aawegaa taano, \"Yaai, kaasee kaa aii peepuuka naa ya? ");
INSERT INTO auu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kuwa uwoo kuwa pe-doogeeta kaama kepe ebo masiyaa. Kuwa kepee kuwa daba bagee aii maniino, daa ye?\" see koogo aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kiya okoo me aawegaakea menaa yuwa Yesus Waa ipi keta kaama asiino, \"Ikii me mee apii mee kaasee kaa pedeo see yawegagea ya? Wa me naukuwaga kuwa esee daamaa agiyoo. ");
INSERT INTO auu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Daba bagee gaayu ko ikii paagoo kisee too kiiumiwoo, toowoo taapea kiya Anii ikii ma enaataa eebaa se kiiumiipa. ");
INSERT INTO auu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wa me nakoo sepa mee ko Anii ogo namagaano taa kaboo naipiipii siyaa agiyoo mokoo yoka pedeo see si yawegaai. ");
INSERT INTO auu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Anii mikee kisiino ko: Ni me doomega menaa kuwa uwoo to, magaa to kiyoo-kiyoo eewegakomeegea kaboo mee apii to me daamaa naukuwapa agiyoo mee miya eeweganaa taapea, bedaa asii yaato miya kuwa menaa neke-nekee siwoosi naadi yadoonaa taapea, see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kiyoo kaama Yesus me topenaa see bagee gaasi ma wiya kuwa mée ena ekaa da ko Yudas Iskariot mee peedoota imam ebo yuwa paagoo peemaata kaama asiino, ");
INSERT INTO auu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","\"Kisee anii Yesus mee kiekegataaga kepa ko ikii me anii maagiyoo niipea ya?\" see asigi naadi okoo kepe egamaata kaama amaamo manegea. ");
INSERT INTO auu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mee kaama wodoo wa me 'Yesus mee yaekegatagaano kuwa kayoo daamaa, kayoo daamaa?' see gaawooki. ");
INSERT INTO auu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yesus me topenaa see bagee yuwa peedoota Wa paagoo asiino, \"Paskah kaa agiyoo naano yoo kayoo naa ipiipii taano daamaa naa ya?\" see asegea. Mee naagoo ko ragi yeeyee ma aatabi taano taa see roti kuwa unu petoo noogee siyaa yiba petamanii naagoo. ");
INSERT INTO auu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus me asiino, \"Peedoota kota kaa mée ena paagoo kisee naasii: 'Guru me kasiino, \"Anii bogaano monaa katu keegooga yoka a me ee yiba kiyoo kaama Ni me topenaa see bagee yuwa ma inii epo enaataa Paskah kaa agiyoo eenaape\" see kasigi' see pe-naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Okoo peedoota kota kaa peemaata kaama Wa me aseta-aseta pee-yaasegea. Yaasemaata kaama Paskah kaa agiyoo uduma daamaa eeipiipii semaagea. ");
INSERT INTO auu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Digiyoo takiinega see kaboo Yesus Wa me topenaa see bagee gaasi ma wiyaa to ma epo enaataa naano see naadi animaayu. ");
INSERT INTO auu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Okoo notaaki too Yesus me asiino, \"Anii mikee kisiino ko: Ikii mée ena me Anii naekegatagaapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Okoo dimi nagimeamookea, gaagaa ebo. Okoo uduma mée ena-ena me Waa asiino, \"Sooi, Tuhan, anii ye, ani me ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus me asiino, \"Roti ponee to mee otaawee yiba Anii ma enaataa tukume-nootaaki mée to wa me Anii naekegatagaapi. ");
INSERT INTO auu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mée Yogaa mee mikee Ogatamee me menaa yiba ebeamaata see see bogaapi kiya Waa ekegatagaapi mée mee esee pedeo kaapi. Mee mée mee kabaano taa naaki daamaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aseta kaama wudikaa ekegatagaapi mée Yudas me asiino, \"Ei, Guru, ani me ye?\" asigi. Yesus me asiino, \"A me wegage kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Okoo epo notaaki too Yesus mee roti masegeeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Roti kabatagaa naadi kaama Wa me topenaa see bagee yuwa goo-maneeyu. \"Mee ko Ni me maa to. Masegeeta nuweei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kiyoo kaama anggur poo uwoo otaawee da masegeeyu naadi Ogatamee paagoo kiiboo, paamee see menaa aseta kaama otaawee da okoo goo-maneeyu. \"Ikii uduma nuweei. ");
INSERT INTO auu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mee ko Ni me tadaa uwoo. Mée yuwa ma, Ogatamee ma, Wa me aseta menaa ma kuwa uduma enaataa aagadimisi naadi yapeeyaapa tadaa, mée eebaa okoo me pedeo yuwa epa yaekeasi naadi yakabageapa tadaa mee. ");
INSERT INTO auu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ani me kisiino ko: Eto kenaagoo kaama wodoo Anii anggur poo uwoo se naapa, Neataagi Wa too ebo mée eetoowoo taatagi naagoo too Anii bedaa gipii see anggur poo uwoo ikii ma epo enaataa naatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kiyoo kaama okoo Ogatamee yaapaagee see kaa yaayaa see menaa ena yaayaa semaata Zaitun Kutuu to kaa peegea. ");
INSERT INTO auu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kiyoo kaama Yesus me okoo asiino, \"Eto mee digiyoo yiba ikii uduma maki-makaa naadi Anii naekeata oodaa taapea, idukaa Ogatamee me menaa yiba ebeamaata see see, mee ko kisee: 'Domba munitaa see mée mee Ani me wugimagaapa, wugimaata kaama domba wodaa yuwa ena kitaa peega, ena kitaa peega sedaa taapea' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kisee kaapa kiya Anii aya andoo peeta kaama Ani keta Galilea wee kaa poota, ikii uuto\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus me asiino, \"Okoo uduma weda kaa A too kaekeata poopea miya anii Aa se kaekeasiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kiya Yesus me waa asiino, \"Anii mikee kasiino ko: Eto mee digiyoo yiba aa kaagaa wedo mée paagoo ewo poga-poga nataape. A me kisee naekeata kaama ayam ena menaa taapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus me asiino, \"Anii Aa ma enaataa bogaapea miya daamaa, anii mée paagoo ewo poga-poga see se kakoo taapa yoka\" see asigi. Apanaa yuwa me \"Anii miya kisee, anii miya kisee\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus mee Wa me topenaa see bagee yuwa ma peedoota maga ena kaa ekaa da ko Getsemani magaa kaa peemaata kaama Wa me okoo asiino, \"Ikii nakaayoo animaata niitooi, Anii woo kaa naa kaa sembahyang taano see naadi pakaanaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Petrus ma, Zebedeus me yogaa wiya ma kuwa okoo too Yesus me badaa maadoota amo kaa naa kaa eepeemaata kaama Waa gaagaa ebo naadi dimi nagimeamooki. ");
INSERT INTO auu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wa me okoo wedo asiino, \"Sooi, Anii esee gaagaa ebo, booyaa mokoo. Ikii miya nakaayoo Anii ma epo enaataa ipiipi niidiitoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Waa pakadoota woo kaa naa kaa kisee ki magaa da kaa esee-gapuunta kaama sembahyang menaa ko \"Neataagi, A me miya daamaa ede gaayu ko kuwa Ni me boodi abaapa kuwa se naekeasii see kasega kiya Ni me gaayaa dimii too se kiya A me gaata-gaata dimii too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sembahyang semaata esedoota Wa me topenaa see bagee wedoo to paagoo eseemaagi too ko okoo toomoo ompea. Wa me Petrus asiino, \"Ikii peenaa kuwa miya Anii ma epo enaataa niidiitoo taano kana kegea ye? ");
INSERT INTO auu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ikii kigaadee siyaa kaboo pedeo dimii, pedeo menaa wisintaasea naadi ikii ipiipi see diitoo taai, sembahyang taai. Ikii me 'Kisee ukuwaanaka' see gaayaa dimii agoo kiya má yaato ko dabaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesus Waa bedaa wiyaagoo to ma pakadoota woo kaa naa kaa Wa me sembahyang menaa mee ko \"Neataagi, kuwa Anii boodi abaapa kuwa Aa boodi abaano too daamaa see nagaayu ko koosi, A me gaata-gaata too yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sembahyang semaata kaama esedoota Wa me topenaa see bagee wedoo to paagoo eseemaagi too ko bedaa toomoo ometaakea, okoo esee toomoo ebo kaa emaa pakaa-wikiiniino naka. ");
INSERT INTO auu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesus Waa bedaa wedaagoo to ma pakadoota sembahyang menaa asigi, yumakaa see see. ");
INSERT INTO auu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sembahyang semaata esedoota Wa me topenaa see bagee wedoo to paagoo eseemaata kaama asiino, \"Ikii kisee too toomoo too ometaakea ye? Deeweei, Mée Yogaa mee dimi pedeo see bagee yuwa yagaa kaa yaekegatagaano see monaa kaa kega. ");
INSERT INTO auu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Anoogeeweei, inii poono. Ikii deeweei, Anii naekegatagaano mée mee migi yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kuwa menaa wegataaka too ko Yudas mee, Yesus me topenaa see bagee gaasi ma wiyaagoo to mee mee meemaagi. Waa ma mée ebo etaa mowai ma, kopaa ma doodoota eemeemaagi. Kuwa bagee kuwa ko imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo me \"Niipeneasea yoka pooi\" see asegea naadi meemaagea bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Miyoo taa meemagaano taa kaa Yudas me kuwa bagee yuwa paagoo mee Yesus yoka see kuwa nekeensi naadi menaa ena ase-maneegi, mee ko kisee: \"Ani me ebe duuduu taapa mée to mee yoka peneasii\" see menaa mee ase-maneegi. ");
INSERT INTO auu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudas meemaata kaama kisee ki peedoota Yesus paagoo \"Guru, epao\" aseta kaama Yesus ebe duuduuki. ");
INSERT INTO auu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus me asiino, \"Mée yogaa to, a me ukuwaano see mege agiyoo mee moga ukuwaai\" see asigi naaki kuwa eemipi bagee yuwa me Yesus me-peneasegea. ");
INSERT INTO auu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Peneasegea naadi Yesus ma enaataa bagee okoo mée waa ena me posee da masegeeta mée ena kaa kobeasigi naaki apa kamuu da yadaakomeegi, Ebo Imam wa me agiyoo yaokagee see mée. ");
INSERT INTO auu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus me waa asiino, \"A me posee da koogo awetagaai. Kuwa okoo pose masegeeta mée daageeyaa bagee kuwa uduma okoo miya pose me daageeta booyaayaa yoka posee da ekeasii. ");
INSERT INTO auu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Anii Neataagi paagoo 'Yaai, Anii nadii' see asiyu ko nayeeyaa yoka, daa ye? Neataagi me malaikat bagee ebo etaa gaasi ma wiya mokoo kuwa pedeo bagee yuwa naabagasi naadi naisiyaayaa, se maa? ");
INSERT INTO auu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kiya kisee taa. Anii eto napeneasegea kuwa idukaa Ogatamee me menaa yiba ebeamaata see see ukuwaaniino gaano pedeo yoka kuwa bagee yuwa naabagaapeasiyu ko kuwa ebeamaata menaa yuwa kaasee uwa daayaa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kiyoo kaama Yesus me kuwa mée yuwa asiino, \"Ikii me dimi pedeo omaago see bagee ena mokoo peneasiino see naadi mowai, kopaa, kisee agiyoo doopea ye? Anii egapii gakata Ogatamee me ee kaa awee da kaa mée topegeeka kiya ikii me napeneasiino taa kemea. ");
INSERT INTO auu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kiya kuwa eto ukuwaanega kuwa ko idukaa nabi bagee me ebeamaata menaa yuwa uwa daasi naadi ukuwaanega\" see asigi. Kiyoo kaama Wa me topenaa see bagee yuwa uduma wa too ekeata oodaakea. ");
INSERT INTO auu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesus peneata bagee yuwa me Ebo Imam Kayapas me ee kaa eepeegea. Kiyoo Musa me menaa mée topetaa see bagee yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo kutuu semaata toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus mee koogo deega se deega see uuto obeegi. Ebo Imam me ee kaa peemaata kaama kiwitaa to yiba seemigi. Kaasee ukuwaapea, kaasee kaapa naadi kiyoo ee yadiitoo taa see bagee yuwa ma epo enaataa animaata diitooki. ");
INSERT INTO auu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mee ee yiba imam ebo yuwa ma, mena pekataa see bagee apanaa yuwa ma okoo uduma Yesus mee patamaano dimii agoo naadi kaama Wa me kisee pedeo agiyoo ukuwapi see deepea bagee yuwa abagea. Kiya kisee makapaa menaa Wa kaa yawegasi naadi deeta bagee ena ma deemagaano taa. ");
INSERT INTO auu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mée eebaa okoo me makapaa menaa yakobagea kiya iyo, Wa kaa pedeo menaa ena ma taa. Kaama too mée ekea wiya okoo paagoo pakaamaata kaama ");
INSERT INTO auu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","asiino, \"Mee Mée mee me miyoo taa wegaano, 'Ani me Ogatamee me ee mee umiyaata kaama unu wedo kaa too bedaa tota-tota maataayaa' see wegami\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ebo Imam mee yiinaageeta kaama Yesus asiino, \"Ekea me A kaa kawegapea menaa kuwa Aa mena ena ma se asiipe ye?\" see asigi ");
INSERT INTO auu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","kiya Yesus mena taa, koogo totaaki. Bedaa Ebo Imam me asiino, \"Idukaa kaama wegawoo seta Mée Ebo Kristus, Ogatamee Yoopaa mee Aa ye, taa ye? Toono Too Mée Ogatamee me A me menaa kayeetaaki yoka mikee menaa kuwa too naawegatagaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus me asiino, \"A me wegage kuwa. Ani me kisiino ko: Eto kaama wodoo Mée Yogaa mee Se-pesee, We-pesee yago Mée Wa me dagi yagaa yaato animaata ebo tupi see kuwa ikii diitagea, sinu dagii da taa migi see miya diitagea, see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ebo Imam me mee menaa da yeeta kaama kagoo kaa waa ekaato dokaa da geakomeeta kaama asiino, \"Wa me Ogatamee me be kiyaa menaa kuwa wegagi yaai. Wa me pedeo menaa kuwa ikii miya yeemaagea yoka eto ko sikii, Wa me kisee pedeo ukuwapi see deepea bagee apanaa se abaai. ");
INSERT INTO auu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Eto ko ikii me kaasee ukuwaakee gaagea ya?\" asigi naaki \"Waa bogaano gaano pedeo\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kiyoo kaama okoo me Yesus ebeyumaa da kaa dabeedi taaweekea, yagaa kopaa dakamegea, mée noonaa me yagaa kopaa ebeyumaa da kaa dakameamoo naadi kaama ");
INSERT INTO auu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","asiino, \"Aa Ebo Kristus nao, maamee me kadakamigi, maamee me kadakamigi see kuwa A me duya kaa mée deede\" see menaa asegea. ");
INSERT INTO auu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrus mee Ebo Imam me ee yoo da kaa animaata toomuu taaki too ko kiyoo agiyoo yaokagee see apii ena wa paagoo meemaaga. \"Ei, aa miya Galilea wee kaa mée Yesus mee ma epo peenaa see mée to, se maa?\" see asega. ");
INSERT INTO auu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kiya Petrus me kiyoo kutuukea bagee yuwa uduma gii da kaa ewo poga-poga naadi asiino, \"Taa, kisee menaa kuwa anii ewo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Waa peedoota wagee kenee to kaa peemaagi too ko agiyoo yaokagee see apii ena miya topa. Wa me Petrus deeta kaama kiyoo topea bagee yuwa asiino, \"Mee mée mee ko Nazaret magaa kaa Mée Yesus mee ma epo enaataa peenaa see mée\" see asega. ");
INSERT INTO auu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus bedaa ewo poga-poga naadi asiino, \"Ataagi yoogi, mee Mée mee anii ewo see Mée\" see baato maa-maneegi. ");
INSERT INTO auu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Peenaa toomaata kaama kiyoo topea bagee yuwa Petrus paagoo meemaagea. \"Ei, a me menaa da wa too see kuwa inii kanekeenege yoka mikee aa miya okoo yaato bagee ena\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrus me baato maata ma baato maataa naadi kaama asiino, \"Ataagi yoogi, mee Mée mee anii ewo see Mée\" see asetaagi naaki taka ena ayam menaaki. ");
INSERT INTO auu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mee kaama too Yesus me yumakaa asigi menaa da nekeenigi, mee ko 'Aa kaagaa wedo mée paagoo ewo poga-poga nataape. A me kisee naekeata kaama ayam ena menaa taapi' see nasigi mee ii naadi kaama peedoota amokiyoo mokoo peanta kaama ebo yegee yegeeki. ");
INSERT INTO auu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tokoma mee da, pedeo komaa da imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo me Yesus mee wugimaasi naadi menaa daakomeegea. ");
INSERT INTO auu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yesus yagaa da taa one gadimemaata eepeedoota Gubernur Pilatus paagoo pe-ekeasegea. ");
INSERT INTO auu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kuwa kaboo da Yudas mee, Yesus ekegataata mée mee okoo me \"Yesus mee bogaano gaano pedeo yoka\" see menaa daakomeegea kuwa waa ipi keta kaama dimi gaagaa ebo kigi. Waa kepe amaamo masipi yuwa kuwa metaki maniino see naadi doodoota imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo paagoo peegi. ");
INSERT INTO auu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Peemaata kaama wa me asiino, \"Anii pedeo ukuwaga nao. Ni me kiekegataaga Mée mee dimi pedeo taa see Mée kiya niibooyaapea\" see asigi. Kiya okoo me asiino, \"Kuwa menaa kuwa inii taano se, aa taano naadi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas wa me masipi kepee yuwa doodoota Ogatamee me ee yiba pe-tameamaagi. Tameamaata kaama peedoota amo kaa naa kaa peemaata kaama waa ekaato kaakaa da taa one gadeata opeekomeegi. ");
INSERT INTO auu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kiyoo kaama imam ebo yuwa me kuwa kepee yuwa meeii naadi kaama wegaano, \"Kuwa kepee kuwa mée wugisi naadi edaata kepee yoka kisee kepee kuwa Ogatamee me ee yiba kepe awetaa see yoo kiyoo awiino ko daa\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Okoo me kaasee ukuwayaa naadi kisee yoka, kisee yoka see aawegaa semaata kuwa kepee yuwa masegeeta maga ena edaagea, ekaa da ko Otaawee Ipiipii Taa See Bagee Me Magaa. Apanaa tomaa kaa bagee me okoo booyaa yuwa kiyoo ogo maageesi naadi edaagea. ");
INSERT INTO auu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Edaamaata kaama wodoo mee magaa mee Tadaa Magaa see ekaa miya weewoo seta, kisee too eto kenaagoo miya kisee ekaa weegea. ");
INSERT INTO auu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kisee kemaata idukaa nabi Yeremia me wegata menaa uwa daaga yoo, mee ko kisee: \"Tuhan me nasiino, 'Israel bagee me waa edaano sikii-sikii, kepe amaamo kuwa ");
INSERT INTO auu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","masegeeta kaama Otaawee Ipiipii Taa See Bagee Me Magaa mee edaai' see naseta. Kiyoo kaama mee magaa mee edaata\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kuwa kaboo da Yesus mee badaa maadoota Gubernur ikigii to kaa ekeasegea. Gubernur me apaadiino, \"Aa ko Yahudi bagee me Eboo mikee ye, taa ye?\" see asigi naaki Yesus me \"A me wegage kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo me Pilatus paagoo Yesus \"Kisee pedeo agiyoo ukuwapi, kisee pedeo menaa wegapi\" see menaa yakobagea naaki Yesus mee koogo, mena ena ma se asigi. ");
INSERT INTO auu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatus me Waa asiino, \"Okoo me A kaa kawegataakea menaa kuwa Aa yiino taa ye?\" see asigi ");
INSERT INTO auu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","kiya Yesus me mena ena ma asiino taa. Gubernur mee dimi nagimigi. ");
INSERT INTO auu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Paskah Naagoo tahun gakata digiyoo ee yiba dogeamoo seta bagee kuwa mée ena Gubernur me daba yapeeyaabuu segee seta. Kuwa ko mée yuwa me Gubernur paagoo \"Mee mée mee daba mée yapeeyaai\" see kuwa tahun gakata asiwoo segee seta. ");
INSERT INTO auu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kuwa kaboo da dimi pedeo naadi ogo pege-pege see mée ena ekaa da ko Yesus Barabas mee digiyoo ee yiba tupi. ");
INSERT INTO auu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mée eebaa Pilatus paagoo kutuu semaagea kaboo wa me okoo apaadiino, \"Eto mee tahun kaa anii daba kipeeyaapa mée mee maamee naa kipeeyaapa naa ya? Yesus Barabas mee ye? Yesus Ebo Kristus see ekaa weegeekea Mée mee ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus me aseta menaa mee ko mée yuwa me Yesus ebo ekeasegea kuwa Yahudi kaa ebo-ebo yuwa me 'Anii miya kisee ebo naekeasegea naaki ou' naadi kagoo kaa Yesus yaekegataagea ii, see kuwa Pilatus me nekeenta kaama aseta menaa mee. ");
INSERT INTO auu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus wa me mena ena too too yadaakomee taa see yoo animaata totaaki kaboo apimee me menaa doodoota wa paagoo eewegagea. \"Mee Mée mee Wa kaa pedeo menaa taa see Mée yoka emaa se wugii. Anii Wa kaa unuu deepa kemaata dimi nagimeamoo taaka yoka kuwa wugimagaano dimii kuwa okoo too yaekeasii, aa ma se, see kasega\" see menaa eewegagea. ");
INSERT INTO auu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kiya imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo me kiyoo topea bagee yuwa koogo eeweganaa taano, \"Barabas mee daba mée yapeeyaai, Yesus mee wugimagaai, see niiasii\" see eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bedaa Gubernur me okoo asiino, \"Kuwa mée wiya kuwa kamee daba kipeeyaano ede kegea naa ya?\" see asigi naaki \"Barabas mee daba mée yapeeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus me asiino, \"Kisee gaayu ko Yesus mee, Ebo Kristus see ekaa weegeekea Mée mee anii Wa kaa maagiyoo yaukuwayaa naa ya?\" see asigi. Okoo uduma ebo menaa kaa asiino, \"Waa piya bokoo to kaa paku wugii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kiya Pilatus me asiino, \"Sooi, Wa me pedeo ukuwapi agiyoo maagiyoo naa ya?\" see asigi kiya okoo bedaa esee ebo menaa kaa asiino, \"Waa piya bokoo to kaa paku wugii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kuwa bagee yuwa kagoo kaa omaago-omaagoo taano see kookea. Pilatus me kagoo taa kisi naadi menaa ena ma se wegamaayaa yoka uwo peenaa masegeeta mée yuwa gii da kaa yagaa uwo wetogigi. Yagaa wetogemaata kaama Wa me okoo asiino, \"Eto ko mee Mée mee bogaapi kuwa anii ma se, ikii kaa too doosea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kuwa bagee yuwa uduma me asiino, \"Waa bogaapi kuwa inii ma, inii me yogaa yuwa ma inii kaa too kisi yoka daamaa, koosi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mee kaama Pilatus me Barabas mee daba yapeeyaagi kiya Yesus mee pepeaduu me dakameamoo semaata piya bokoo to kaa paku wugitaasi naadi okaa yago bagee paagoo yaekeasigi. ");
INSERT INTO auu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kuwa okaa yago bagee yuwa me Yesus badaa maadoota Gubernur me ee yiba eepakaamaagea. Kiyoo apanaa okaa yago bagee topea yuwa ma uduma Yesus paagoo kutuu semaagea. Waa bobetaata kaama ");
INSERT INTO auu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wa me dokaa da yabeageeta kaama dadi poo epoo da see see dokaa ena Wa kaa yamaataagea. ");
INSERT INTO auu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kiyoo kaama takuu yago onee ena bakane yaidimitaata kaama mumoo to kaa yamaataagea. Aii piya tamo ena Wa me dagi yagaa yaato yagaa da kaa yaogoata kaama Wa ikigii to kaa kagu maga kaa sibu naadi wisineekee kaa asiino, \"Yahudi bagee me Eboo, kiiboo, magiyaage\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wa kaa dabeedi taawee naadi Wa me yagaa da kaa yaogoasegea tamoo da mee masegeeta kaama Wa me mumoo to kaa dakamegea. ");
INSERT INTO auu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kisee wisineamoo semaata mee dadi poo epoo da see dokaa da yabeageeta kaama bedaa Wa me petamanii dokaa da yamaataagea. Kiyoo kaama piya bokoo to kaa paku wugiino see naadi badaa maadoo peegea. ");
INSERT INTO auu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Okoo peetaaka too ko Kirene magaa kaa mée ena ekaa da ko Simon mee aadoo seta kaama Yesus me piya bokoo to mee \"Aa yadogaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Muguu naadi maga ena ekaa da ko Golgota magaa kaa eepakaamaagea. Golgota see ekaa mee wegayu ko Mumo Metoo Kutuu to see ekaa mee. ");
INSERT INTO auu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kiyoo pakaamaata kaama anggur poo uwoo ma, gii pedeo see uwoo ma aatogo-maatogo semaata Waa nusi naadi manegea. Uwo noodeegi naaki gii pedeo naadi se nugi. ");
INSERT INTO auu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Waa piya bokoo to kaa paku wugitaata kaama Wa me dokaa yuwa maamee me masiipi, maamee me masiipi naadi okoo me agiyoo iyagideekea. ");
INSERT INTO auu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kuwa agiyoo iyagideeta kaama kiyoo animaaii naadi diitookea. ");
INSERT INTO auu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wa dagii da kaa Wa kaa menaa yuwa yaebeamaata kaama pakaa-tabeasegea. Mee menaa da mee ko kisee: \"Mee mée mee ko Yahudi bagee me Eboo Yesus mee\" see menaa yaebeamaagea. ");
INSERT INTO auu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oma masetaa see bagee wiya miya Yesus ma enaataa piya bokoo to kaa paku wugitaagea. Wa me dagi yagaa yaato mée ena, eka yagaa yaato mée ena. ");
INSERT INTO auu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kitaa peetaakea bagee yuwa me mumo wagii-wagii naadi wisineekee kaa Yesus asiino, ");
INSERT INTO auu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","\"Ei, Ogatamee me ee mee umiyaata kaama bedaa unu wedo yiba too maataata tota-tota siyaayaa see wegame Mée, Aa ko mikee Ogatamee Yoopaa gaayu ko Aa ekaato daba peese yoka eto kiipaa apiyoo piya bokoo to kaa kaama magaa da kaa eseanii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kisee miya imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo me Yesus wisineekee kaa asiino, ");
INSERT INTO auu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","\"Wa me apanaa bagee se boosi naadi daba daagimaayaabuu segee simi kiya Waa ekaato iyo. Waa Israel bagee me Eboo mee mikee ki Waa kepa ko mee piya bokoo to kaa kaama eseaniino too daamaa. Eseanta kaama too inii mikee nao see gaayaa. ");
INSERT INTO auu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Waa Ogatamee kaa dimi maataa see Mée, bedaa Wa me 'Anii ko Ogatamee Yoopaa' see wegageeki yoka eto ko Ogatamee me Waa epa gaapi ko Waa daba daagimaa peeyaasi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yesus ma enaataa piya bokoo to kaa paku wugitaagea bagee wiya ekea me miya Waa wisinegea. ");
INSERT INTO auu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kenoo to mée mumoo to kaa pakaamaagi see kaboo kuwa magaa uduma digiyoo aatakiika, kisee too keno wedo kaa too pakaa-pakaa. ");
INSERT INTO auu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Keno wedo kaa pakaamaaga kaboo da Yesus ebo menaa-menaa kaa \"Eli, Eli, lama sabaktani?\" see wegagi. Mena nekeeniino yaato ko \"Ni me Eboo Ogatamee, Ni me Eboo Ogatamee, Aa kaasee kaa naekeasege?\" see mee. ");
INSERT INTO auu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kiyoo topea bagee yuwa noonaa me kuwa menaa yeeta kaama asiino, \"Waa Elia mee mena ogetaaki\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kiyoo topea bagee mée ena me Yesus uwo nusi naadi doka ponee to see see agiyoo moga masegeeta geebagi see anggur poo uwoo yiba esee-tokoata gokoo da kaa yokoata manigi. ");
INSERT INTO auu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kiya mée noonaa me asiino, \"Wisintayu. Elia mee esedoota Wa paagoo daba daagimaa peeyaapi ye, taa ye see niidiitoo taai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bedaa Yesus Waa ebo menaa-menaaki naaki taka ena dimi noogaa da pe-seomigi. ");
INSERT INTO auu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kuwa kaboo da taa ko taka ena Ogatamee me ee semoo yiba yaato kenee to kaa wasitaata dokaa da mee usii to kaa kaama pegadoota manii to kaa too wiya wodeenega. Maga pigii miya mega, maga kutu-patu kaa omaa yuwa miya kabaandaaka. ");
INSERT INTO auu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mée ogo yuwa miya kabaandaa naadi kaama Ogatamee me bagee yuwa mée eebaa aya andoo peedaakea. ");
INSERT INTO auu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","(Kuwa bagee kuwa gaayu ko Yesus aya andoo peeta wodoo taa okoo Yerusalem magaa kaa, daamaa wa too wigintaata magaa kaa kiyoo peenaa seta. Okoo deeta bagee yuwa mée eebaa.) ");
INSERT INTO auu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Digiyoo, maga pigii, kisee agiyoo ukuwaandaa taaka yuwa kuwa kiyoo Yesus diitoo taa see bagee yuwa dimi nagimegea. Okaa yago bagee me eboo ma, apanaa okaa yago bagee yuwa ma okoo me \"Mee Mée mee ko mikee Ogatamee Yoopaa ii\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kiyoo api eebaa miya beesekaa mokoo kaama diitookea. Okoo ko Yesus me agiyoo yaukuwataa see apii, petamanii Galilea wee kaa kaama Waa ma epo enaataa peenaa seta apii yuwa. ");
INSERT INTO auu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kuwa apii yuwa yupii Maria Magdalena mee ma, Yakobus ma, Yusup ma ekea baayo Maria mee ma, Zebedeus me yogaa wiya ekea baayo ma kuwa topea. ");
INSERT INTO auu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Uwaataa da ayayaa takiinega see kaboo kepe yago bagee ena migi. Waa ekaa da ko Yusup, Arimatea magaa kaa mée. Waa miya Yesus mikee gaayaa see mée. ");
INSERT INTO auu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Waa Yesus bootaa da idimaano see naadi peedoota Pilatus paagoo peemaata idimigi naaki Pilatus me kiyoo gebo kaa bagee yuwa asiino, \"Bootaa da mee wa me masisi yoka yaekeasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Bootaa da masegeeta daamaa poodee see doka gipii da kaa bebenataata kaama ");
INSERT INTO auu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","doodoota mée ogo magaano yoo kiyoo oma ena togaawee ogo maatayu. Mee oma togaawee mee ko Yusup boota kaama ogo maasi naadi yadenamaata oma gipii da mee. Ogo maataata kaama ebo omaa ena bikimedoota kenee to kaa pe-takeata kaama ee kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena ma, apanaa Maria ena ma ekea Yesus ogo da doodoo da kaa kiyoo animaata toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tokoma mee da Sabat naagoo imam ebo yuwa ma, Parisi kaa bagee yuwa ma enaataa peedoota Pilatus paagoo kutuu semaagea. ");
INSERT INTO auu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Okoo me Pilatus asiino, \"Ei, inii me Eboo. Mee makapaa menaa weganaa simi Mée to Waa bogaano taa kaa Wa me wegaano ko 'Anii boota kaama wedaagoo to naagoo aya andoo poopa' see wegami kuwa inii nekeenege yoka ");
INSERT INTO auu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ogoo da kaa yuumaantoo taano bagee kiyoo tuyaai. Wedaagoo to naagoo kaama wodoo wisintayu. Wa me topenaa see bagee yuwa me Wa bootaa da koogo doodoo peeyaa naadi kasege. Doodoo peeta kaama 'Waa aya andoo peegi nao' see weganaa taapea menaa kuwa yaai. Wa me petamanii mée deebaa senaa simi menaa kuwa mikee ebo kiya okoo me 'Waa aya andoo peegi nao' see mée deebaa taapea kuwa mee asii eboo kaapa naadi kaama kiyoo yuumaantoo taano bagee kiyoo tuyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus me asiino, \"Daamaa, okaa yago bagee badaa maadoota pooi. Ogoo da kaa daamaa pe-yuumaantoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Okaa yago bagee peedoota oma kenee to kaa peemaata kaama mee takeata omaa to mée me kabaano wedaasi naadi agiyoo omaa to kaa pe-tabeasegea. Mee kaama kiyoo yuumaantookea. ");
INSERT INTO auu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat naagoo esegekomeeta mee daa yiba petamanii naagoo esee pedeo komaa da Maria Magdalena ma, apanaa Maria ma wiya Yesus ogoo da diino see naadi peegea. ");
INSERT INTO auu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Taka ena maga pigii ebo mega, Tuhan me menaa eseasegee see mée ena epoo to wodoo kaama eseanigi yoo. Eseanta kaama Waa ogoo da kaa takeata oma damaa to amaa kaa bikimeamaata kaama oma dagii da kaa animaagi. ");
INSERT INTO auu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wa me ebeyumaa da bego-bego see see mokoo, wa me dokaa da sinu poodee da keenda. ");
INSERT INTO auu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kiyoo yuumaantoo taa see bagee yuwa okoo weda kaa totomoo naadi boota bagee mokoo kedaakea. ");
INSERT INTO auu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mee malaikat see mée to me kuwa api wiya asiino, \"Ekea se wedaai. Piya bokoo to kaa paku wugitaamea Mée Yesus mee ekea me abagea see kuwa anii ipi. ");
INSERT INTO auu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Waa nakaayoo toono taa, aya andoo peepi, Wa me 'Anii aya andoo poopa yoka' see kisimi see see. Ekea meedoota Wa bootaa da ogo maataamea taa kitaa me-deeweei. ");
INSERT INTO auu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Eto ko moga peedoota Wa me topenaa see bagee yuwa paagoo kisee pe-naasii: 'Waa boota kaama aya andoo peepi. Wa keta Galilea wee kaa pe-seomigi yoka kiyoo ikii me Waa diipea' see kisigi, see pe-naasii. Anii kuwa menaa mikee kisi-maneega yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Asigi naadi kuwa apii wiya weda dimii ma, ede dimii ma Wa me topenaa see bagee yuwa kuwa menaa asiino see naadi yiibaga peegea. ");
INSERT INTO auu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Taka ena Yesus kuwa apii wiya ma aadoo seta kaama \"Epao\" asigi. Ekea meedoota Wa paagoo Wa me badoo da pe-podamaata kaama maamaa yaapaagee, ebo ekeekea. ");
INSERT INTO auu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesus me ekea asiino, \"Se wedaai. Peedoota Nii ma kenaa bagee yuwa paagoo kisee naasii: 'Ikii Galilea wee kaa pooi see kisigi' see pe-naasii. Kiyoo okoo me nadiipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kuwa apii wiya pe-seomegea kaboo kiyoo yuumaantoo sepea bagee okoo wedo waa naa Yerusalem magaa kaa peegea. Imam ebo yuwa paagoo peemaata kaama kuwa ukuwapea-ukuwapea yuwa eewegagea. ");
INSERT INTO auu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kiyoo kaama imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo kutuu semaata kaama \"Kaasee ukuwaapea, maasee ukuwaapea?\" see aawegaakea. Mena aawegaa semaata kuwa yuumaantoo sepea bagee yuwa kepe eebaa manegea. ");
INSERT INTO auu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kuwa Yahudi kaa ebo-ebo yuwa me okoo asiino, \"Mee wodoo kisee menaa niiwegawoo taai, kuwa ko: 'Daatooyiba yaato inii toomoo ompe kaboo Yesus me topenaa see bagee yuwa me Wa bootaa da oma masedoo peepea' see niiwegawoo taai. ");
INSERT INTO auu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Bootaa da masedoo peepea' see menaa da Gubernur paagoo yeeyaagea kepa ko dimi se nagimaai, inii me waa mena me keedapuu-dapuu taape\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kuwa yuumaantoo sepea bagee yuwa kepe masegeeta kaama \"Wa bootaa da oma masedoo peemea yoka\" see menaa wegawoo seta. Eto miya Yahudi bagee me \"Wa bootaa da oma masedoo peemea yoka\" see menaa kuwa aawegaa siwookea. ");
INSERT INTO auu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesus Wa me topenaa see bagee gaasi ma ena kuwa peedoota Galilea wee kaa maga kutuu to kaa peegea, Yesus me \"Kiyoo nadiipea yoka pooi\" see asimi yoo. ");
INSERT INTO auu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Maga kutuu to kaa pakaamaata kaama deamaagea ko Yesus tupi. Okoo me Waa yaapaagee, ebo ekeekea kiya okoo noonaa me dimi wiya kegea. ");
INSERT INTO auu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus meedoota okoo geboo da kaa kaama aseta menaa ko \"Se-pesee, we-pesee, se-menaa, we-menaa uduma, epoo to wodoo kaa miya, magaa da kaa miya kuwa uduma Ni kaa too naekeata topa. ");
INSERT INTO auu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kisee kemaata ikii peedoota uwoo to, magaa to mée tomaa-tomaa yuwa uduma paagoo pooi. Okoo miya Ni me topenaa see bagee yuwa nakiyaabuu senaa taai. Ikii kuwa bagee yuwa uwo yatukumaano kuwa ko Nagamee ekaa yiba ma, Yogamee ekaa yiba ma, Roh Kudus ekaa yiba ma kuwa ekaa yiba uwo yatukumaai. ");
INSERT INTO auu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ni me kiseta-kiseta menaa yuwa uduma okoo miya daamaa nadeewoo, naukuwawoosi yoka tupiwoo taai. Mikee, Anii ikii ma epo enaataa kiitoowoo taapa, kisee too wodopasi naagoo too see kuwa daamaa nekeenii\" see aseta. Kiyoo too.");
INSERT INTO auu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ebo Kristus Yesus mee, Ogatamee Yoopaa Wa kaa daamaa petamanii menaa kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Idukaa Ogatamee me kapogee yiba nabi Yesaya me menaa ena ebeamaata, mee ko kisee: \"Ni me menaa naweganaa taano mée ena wa keta pooi see kaasiita, A me poono etaa da wa me daamaa kamasiitagi. ");
INSERT INTO auu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Piya taa, one taa see ebo mee maga ugii da taa mée waa ena me ebo menaa-menaa kaa 'TUHAN me etaa da ipiipi yawuditagaai. Waa meeno see etaa da daamaa topoo yatupitagaai'\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Uwo mée yatukumeta mée Yohanes waa piya taa, one taa see ebo mee maga ugii da kaa peemaata kaama eeweganaa seta menaa ko \"Ikii me pedeo dimii, pedeo menaa kuwa Ogatamee me epa kiekeasiipi yoka eto ko ekeata kaama uwo tukumaai\" see menaa weganaaki. ");
INSERT INTO auu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mée eebaa wa paagoo peegeekea, kuwa ko Yudea wee kaa bagee ma, Yerusalem magaa kaa bagee ma okoo mée eebaa. Okoo me pedeo yuwa uduma awee da kaa wegatagaa semaata kaama Yohanes me Yordan dee kaa uwo yatukumigi. ");
INSERT INTO auu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes wa me dokaa kuwa ko unta iyuu me iyata dokaa, bedaa epmoonee da mee woda kado me ipiipii seta. Wa me naano agiyoo kuwa ko motaabi ma, degee kegoo uwoo ma kuwa. ");
INSERT INTO auu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wa me wegata menaa mee ko kisee: \"Waa uuto meepi Mée mee ko esee ebo. Anii peedi yoka anii esee-kodeata kaama Wa me bado doko yabeano kuwa miya weda, iyo. ");
INSERT INTO auu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ani me ikii uwo yiba kitukumpa kiya Wa me kitukumaano kuwa ko Roh Kudus yiba miya kitukumaatagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kuwa kaboo da Yesus mee Galilea wee kaa omegee naadi kaama peedoota Yordan dee kaa peemaata kaama Yohanes me Waa uwo yatukumigi. ");
INSERT INTO auu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus maayoo kaa peanta kaama deataayaa naaki taka ena epoo to kabaanta kaama wiya wodeenega. Kisee wodeenta kaama Roh mee poodee see bedoo eseaniyaa mokoo see see Wa kaa eseanigi. ");
INSERT INTO auu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kuwa kaboo da taa epoo to yaato kaama aseeyamaata menaa ko \"Aa ko Ni me esee kaepa see Yogaa yoka A me Anii dimi wikii-wikii nasiyaabuuke\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kuwa kaboo da Roh Kudus me Yesus mee piya taa, one taa see ebo mee maga ugii da kaa eepeegi. ");
INSERT INTO auu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Peemaata kaama Iblis me ni me menaa nayeesi naadi Waa apaadee segee see egapii mée wiya. Yesus Waa mee magaa to kaa yago tookee agiyoo yupii omegee, toogeeka too malaikat bagee yuwa me Waa iye-iyee seta. ");
INSERT INTO auu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kuwa kaboo da Yohanes mee digiyoo ee yiba seemiyaagea. Waa seemiyaata kaama Yesus mee peedoota Galilea wee kaa peemaata kaama Ogatamee me etokaa daamaa menaa kuwa eeweganaaki. ");
INSERT INTO auu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wa me menaa mee ko kisee: \"Eto ko monaa da kaa kega. Ogatamee Wa too ebo mée eetoono see kooki yoka ikii me pedeo dimii, pedeo menaa kuwa ekeata Waa ma dimii menaa kaa too umiwoo, toowoo taai, bedaa kuwa etokaa daamaa menaa kuwa mikee gaawoo taai\" see menaa kuwa eeweganaaki. ");
INSERT INTO auu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus mee Galilea piku geboo da taa peetaaka too deamaayaa naaki doge abagee see bagee mée ekea wiya uwo pikuu da yiba jala onee tameeyamoo taakea. Ena mee ekaa da ko Simon, ena mee Simon ebee ekaa da ko Andreas. ");
INSERT INTO auu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus me asiino, \"Ni sekaataa nameei. Ekea mée naabawoo see bagee wiya kikiyaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kisee ki jala onee ekeata Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bedaa peedoota peenaa amoo maa kaa mokoo peemaata deamaayaa naaki mée ekea wiya topea, kuwa ko Zebedeus me yogaa wiya, Yakobus ma, Yohanes ma ekea kenaaya. Ekea koma yiba jala onee ipiipii taakea. ");
INSERT INTO auu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus me \"Ekea Ni sekaataa nameei\" see asigi naaki kisee ki mee komaa da ma, nagamee Zebedeus ma, wa me agiyoo yaokagee see bagee yuwa ma kuwa uduma ekeata Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus ma okoo peedoota Kapernaum magaa kaa peemaayu. Sabat naagoo Waa sembahyang segee see ee yiba seemeta kaama mée topetaaka too ko ");
INSERT INTO auu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","kiyoo yiitookea bagee yuwa dimi nagimegea, Wa me mée tupiino ko omaago yoka, Musa me menaa mée topetaa see bagee me mée topetaa siyaa see see se. ");
INSERT INTO auu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kuwa kaboo da taa ko mee ee yiba paa agoo see mée ena tupi. Wa me mena ebo kaa ");
INSERT INTO auu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"Ei, Yesus, Nazaret magaa kaa Mée, Aa ma inii mapea menaa agoo? Inii mée umina pedeo kiyaano see naadi mege ye? Aa mee ko anii kanekeenega. Aa ko Ogatamee me kawigintaata pedeo ena ma taa see Mée mee ii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus me omaago ma asiino, \"Aa koogo tooi, wa kaa kaama pooi\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","paa me mee mée to maa da totomo yasiyaata kaama ebo menaa-menaa kaa wa kaa kaama peegi. ");
INSERT INTO auu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kuwa deegea bagee uduma dimi nagimegea. Okoo me wegaano, \"Mee kaasee agiyoo? Wa me mée tupiino menaa kuwa gipii see menaa ii. Wa me menaa kuwa esee pesee, omaago. Paa yuwa 'Pooi' see asigi naaki Wa me menaa yayiino too\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kuwa Wa me koo sipi menaa yuwa doodoota Galilea wee kaa magaa kaa kiyoo-kiyoo uduma eeweganaa seta. ");
INSERT INTO auu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus mee sembahyang segee see ee kaa paa yaabagaapeata kaama peedoota Simon ma, Andreas ma ekea me ee kaa, Yakobus ma, Yohanes ma ekea miya peegea. ");
INSERT INTO auu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ee kaa peemaaga too ko Simon me apimee baayo wa me ometaa see yoo tani ma ikiyoo meanta totaaka. Okoo moga peedoota Yesus paagoo pe-asegea. ");
INSERT INTO auu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Waa peedoota mee apii to paagoo yagaa da peneata anoogeeyaagi naaki ikiyoo taa keepeasega. Taa kega naadi anoogeeta naano agiyoo mée yuwa manega. ");
INSERT INTO auu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Keno seomigi kaboo ikiyoo yago bagee yuwa ma, paa yago bagee yuwa ma okoo uduma Yesus paagoo eemedaakea. ");
INSERT INTO auu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mee magaa kaa bagee uduma mee ee kaa kenee to kaa kutumeeiikea. ");
INSERT INTO auu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Okoo me deei-deei, meanee see agiyoo tomaa-tomaa yuwa eebaa Wa me yataa kiyaagi, paa eebaa miya yaabagaapeasigi. Paa yuwa me 'Mee ko Ebo Kristus yoka' see kuwa ipi kemaata Yesus me okoo mena peenaa ma se wegayaagi. ");
INSERT INTO auu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Omemaayu pedeo tokomaa, pe-aweeniino taa see kaboo da Yesus mee peedoota mée taa see yoo peemaata kaama sembahyang taaki. ");
INSERT INTO auu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ma, waa ma bagee yuwa ma okoo epo Yesus abanaakea. ");
INSERT INTO auu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Okoo me Waa deemaata kaama asiino, \"Mée uduma kaabanaakea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wa me asiino, \"Anii mena eeweganaa taano see naadi meta yoka gebo kaa apanaa magaa kaa bagee yuwa paagoo niipooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Waa Galilea wee kaa magaa uduma nawenaa, peenaaka too sembahyang segee see ee yuwa yiba Wa me menaa daamaa eewegageeki, paa seemeta bagee yuwa miya paa yaabagaapii segeeki, kisee ukuwanaa segee seta. ");
INSERT INTO auu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kuwa kaboo da mée ena, bado yagaa kuwa esee pedeo abuu me daa-noota see mée Yesus paagoo meemaata kaama mumo maga kaa esee-ekeasigi. Wa me maamaa aseekee kaa \"Aa ede kepa ko ni me abuu kuwa A me nataa kiyaayaa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus me waa epa nao naadi wa kaa yagaa pe-maataata kaama \"Daamaa, a me abuu kuwa taa kaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Taka ena abuu kisee ki taa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus me waa koogo pooi see aseta kaama bedaa Wa me pesee kaa asiino, ");
INSERT INTO auu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","\"Ani me abuu kataa kiyaaga kuwa mée se asii. Aa koogo peedoota imam bagee paagoo pooi, okoo me daamaa ipiipi kadeesi ke. Abuu kuwa mikee taa kega ii see kadeegea kaboo Ogatamee paagoo kupi-maniino agiyoo kamanisi naadi doo-pooi, idukaa Musa me 'Kisee ukuwaai' see wegata see see. Mée me 'Aa mikee eto abuu taa kega ii' see kuwa kanekeensi naadi kuwa uduma pe-ukuwaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kisee asigi kiya mee mée to me kuwa Wa me kisee daamaa nakoo sipi see menaa kuwa awee da kaa kiyoo-kiyoo eewegakomeegi. Mee kaama wodoo Waa kota magaa kaa awee da kaa peenaa taano iyo. Waa gebo kaa magaa kaa mée eebaa taa see yoo kiyoo too toogeeki. Kisee kiya kiyoo-kiyoo bagee mée eebaa Wa paagoo medaakea. ");
INSERT INTO auu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Unu wedo waa naa omemaata kaama Waa metaki peedoota Kapernaum magaa kaa peemaayu. Peemaata kaama mée me \"Waa meemaata ee kaa tupi\" see menaa kuwa weganaakea. ");
INSERT INTO auu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Waa tupi yoka naadi mée eebaa medaakea. Ee yiba mée sipi, kenee to kaa kiyoo miya toono naka. Wa me menaa kuwa okoo daamaa eewegataa. ");
INSERT INTO auu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kuwa kaboo da taa ko okoo mée wui me oogimaata bagee ena Yesus paagoo dogaano see kookea. ");
INSERT INTO auu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kiya mée sipi naadi Wa paagoo doomagaano iyo yoka doodoota ee to wodoo taa pakagea. Pakaamaata kaama Yesus doodoo da taa ee kabataagea. Kabataata kaama mee oogimaata mée to wa me ometaa see keagee da ma yadookomeegea. ");
INSERT INTO auu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus me okoo mikee nagaano dimii mee ebo ii naadi kaama Wa me mee oogimaata mée to asiino, \"Niyoopaa, a me pedeo yuwa uduma epa kaekeasega. Eto ko aa Ogatamee ma menaa kuwa taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Musa me menaa mée topetaa see bagee noonaa miya kiyoo animaata totaakea. Okoo me kuwa menaa yeeta kaama dimi yiba gaano, ");
INSERT INTO auu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","'Yaai, kaasee menaa weegi ya? Kuwa Ogatamee me be kiyaa menaa. Mée tomaa okoo me pedeo yuwa epa yaekeasiino kuwa Ogatamee Wa me too koo semaayaa, se maa?' see koogo dimi yiba gaagea. ");
INSERT INTO auu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Okoo me gaagea dimii kuwa Yesus me dimi yiba moga nekeenta kaama asiino, \"Ikii koogo dimi yiba 'Kaasee mée to yaai' see nagaagea kuwa kaasee kaa ya? ");
INSERT INTO auu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ani me mee oogimaata mée to paagoo 'A me pedeo yuwa epa kaekeasega yoka eto ko aa Ogatamee ma menaa kuwa taa' see menaa mee miya wegayaa, bedaa 'Anoogeeta a me ometaa see keagee da masegeeta daamaa peenaa taai' see menaa mee miya wegayaa, ekea paaya. ");
INSERT INTO auu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kiya Mée Yogaa mee Wa me magaa da kaa bagee yuwa okoo Ogatamee ma menaa yuwa mikee yataa kiyaayaa ii see kuwa ikii nanekeensea naadi agiyoo ena kideeyaanaka\" see asigi. Kiyoo kaama Wa me mee oogimaata mée to asiino, ");
INSERT INTO auu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","\"Ani me kasiino ko: Anoogeeta a me ometaa see keagee da masegeeta ee kaa pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kiyoo topea bagee yuwa deegea kaboo waa kisee ki anoogeeta kaama wa me ometaa see keagee da masedoota ee kaa peegi. Kiyoo diitookea bagee yuwa uduma dimi nagimaano ebo, Ogatamee yaapaageekea. \"Ebo ae see agiyoo mee see see inii ewo, se deetaa see agiyoo\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kiyoo kaama Yesus mee kaagaa ena ma peedoota Galilea piku geboo da kaa peemaata kaama mée eebaa Wa paagoo medaakea. Wa me okoo daamaa topetaa. ");
INSERT INTO auu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Waa peetaaki too deeyaa naaki mée ena, Alpeus yoopaa ekaa da ko Lewi mee kiyoo tupi. Wa me pajak kepee masegee yoo animaata totaaki. Yesus me \"Ni sekaataa nameei\" asigi naaki yiinaageeta Wa sekaataa peegi. ");
INSERT INTO auu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wa me Yesus badaa maadoota wa me ee kaa eepeegi. Yesus sekaataa bagee kuwa okoo mée eebaa kemaata pajak kepee yamasegee see bagee yuwa ma, apanaa dimi pedeo see bagee yuwa ma okoo mée eebaa animaaii naadi Yesus ma, Wa me topenaa see bagee yuwa ma naano agiyoo epo enaataa notaakea. ");
INSERT INTO auu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kuwa kaboo da Musa me menaa mée topetaa see bagee yuwa me diitookea. Okoo ko Parisi kaa bagee. Okoo me Yesus Waa pajak kepee yamasegee see bagee ma, apanaa dimi pedeo see bagee ma okoo paaya enaataa naano agiyoo notaakea kuwa deeta kaama Wa me topenaa see bagee yuwa asiino, \"Ikii mena kitopetaa see Mée mee pajak kepee yamasegee see bagee ma, apanaa dimi pedeo see bagee ma okoo paaya enaataa naano agiyoo notaakea kuwa yaai, kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus me kuwa menaa yeeta kaama okoo asiino, \"Ikiyoo taa see bagee kuwa ikiyoo yadeetaa see bagee paagoo se peeyaa kiya ikiyoo yago bagee kuwa too peeyaa. Anii meta mee ko Ogatamee me menaa yayeetaa see bagee yuwa mena ogaano see naadi se kiya dimi pedeo bagee kuwa Ni sekaataa misi naadi meta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kuwa kaboo da uwo mée yatukumeta mée Yohanes wa me topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma okoo naano agiyoo tapoo toogeekea. Mée noonaa Yesus paagoo meemaata kaama asiino, \"Yohanes me topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma okoo naano agiyoo tapoo toogee siyaa kiya A me topenaa see bagee yuwa se ukuwageekea kuwa kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus me asiino, \"Api goeano naagoo naano agiyoo notaa siyaa kaboo paimee ma enaataa tuyaa bagee yuwa naano agiyoo tapoo toogee siyaa ye? Taa, mee api goeyaa mée to epo enaataa tuyaa kaboo naano agiyoo tapoo se toogee siyaa. ");
INSERT INTO auu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Api goeyaa mée to waa amoo-doge-doge taapea naagoo kaama wodoo too wa me bagee yuwa naano agiyoo tapoo toogee taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bedaa Yesus me wegaano, \"Gipii dokaa ponee to, uwo wetogeano taa see doka ponee to mee masegeeta kaama nuku see dokaa tokogoo da kaa pee-se kiwiyaa. Kisee kiwiyu ko mee nuku see dokaa da mee geanta tokogoo ebo kedaa siyaa. ");
INSERT INTO auu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bedaa anggur poo uwoo kuwa otaawee yiba wogeawee siyaa kuwa miya kisee. Gipii see anggur poo uwoo gaayu ko nuku see otaawee yiba se wogeawee siyaa. Kisee wogeawee siyu ko mee nuku see otaawee da mee kipuunta kaama anggur poo uwoo miya pedeo kiyaa, otaawee da miya pedeo kiyaa. Kisee kiyaa naadi gipii see anggur poo uwoo kuwa gipii see otaawee yiba too wogeawee siyaa\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kaawaa ena Sabat naagoo Yesus Waa gandum poo uwaa da taa peetaaka too Wa me topenaa see bagee yuwa gandum poo ukuu yuwa naano see naadi daapegeekea. ");
INSERT INTO auu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kiya Parisi kaa bagee me Yesus asiino, \"Yaai, Sabat naagoo yoka okoo me kuwa ukuwagea kuwa daa. Kaasee kaa ukuwagea ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus me asiino, \"Idukaa Daud ma, waa ma enaataa bagee yuwa ma okoo naano agiyoo taa kaboo naadi ebo kaa eeukuwata menaa mee ikii diino taa, ewo ye? ");
INSERT INTO auu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mee ko idukaa Abiyatar waa Ebo Imam tota kaboo Daud waa Ogatamee me ee yiba seemeta kaama Ogatamee paagoo manegee seta roti magu yuwa masegeeta nota, waa ma bagee miya eenota. Kuwa roti kuwa naano ko imam bagee me too noogee siyaa roti yuwa, apanaa bagee yuwa naano ko daa kiya kisee-kisee taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bedaa Yesus me asiino, \"Sabat naagoo mee ko mée tomaa yuwa okoo kaa daamaa yaagoo kiyaata, mée tomaa me mee naagoo kana ma, kana ma deewoosi naadi agoo kiyaata se. ");
INSERT INTO auu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kisee kemaata Mée Yogaa mee Sabat naagoo mee miya epoo Mée\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sabat naagoo kaawaa ena ma Yesus mee sembahyang segee see ee yiba seemetaa. Mée ena, yagaa enaato boota see mée to kiyoo tupi. ");
INSERT INTO auu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Parisi kaa bagee miya kiyoo topea. Okoo me Yesus kaa pedeo menaa yaweganaa taano see dimii agoo yoka Sabat naagoo Wa me mée kaa meanee see agiyoo yataa kiyaapi ye naadi tamaata maamaa diitookea. ");
INSERT INTO auu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wa me mee yagaa enaato boota see mée to asiino, \"Aa mée uduma dagii da kaa yiinaageeta tooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesus me okoo asiino, \"Musa me menaa yiba Sabat naagoo gaayu ko maagiyoo ukuwaano dagu see ebeamaata ya? Daamaa agiyoo ukuwaano mee dagu ye? Pedeo agiyoo ukuwaano mee dagu ye? Mée daamaa kiyaano mee dagu ye? Mée booyaano mee dagu ye?\" see asigi. Kiya okoo mena taa, koogo togea. ");
INSERT INTO auu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wa me kagoo kaa okoo uduma emaa wugitaga-wugitaga naadi kaama sooi, dimi eboo see bagee yuwa nao naadi dimi boodi ebo. Kiyoo kaama Wa me mee yagaa boota see mée to asiino, \"A me yagaa da petaasede\" asigi. Yagaa peto asigi naaki daamaa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisi kaa bagee yuwa pudumeta kaama Herodes yaato bagee ma enaataa Yesus mee wugiino see menaa koogo aawegaa seta. ");
INSERT INTO auu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus mee Wa me topenaa see bagee yuwa ma enaataa Galilea pikuu da kaa peetaaka too mée eebaa Wa sekaataa peedaakea, kuwa ko Galilea wee kaa bagee ma, Yudea wee kaa bagee ma, ");
INSERT INTO auu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusalem magaa kaa bagee ma, Idumea wee kaa bagee ma, Yordan uwaasii yaato magaa kaa bagee ma, Tirus magaa kaa bagee ma, Sidon magaa kaa bagee ma, okoo mée eebaa. Okoo Wa me ukuwanaaki menaa yuwa yeeta kaama Wa paagoo medaakea. ");
INSERT INTO auu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Okoo mée eebaa kemaata uwo piku geboo da kaa Wa paagoo naayaato-naayaato nasipintagaapea yoka naadi Wa me topenaa see bagee yuwa asiino, \"Koma ena nadoomeei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mee ko deei-deei meanee seta bagee mée eebaa Wa me daamaa yakiyaabuu sipi kemaata deei-deei meanee seta bagee apanaa mée eebaa okoo miya Waa yaadeega naaki ou naadi Wa paagoo sipintagaano see kookea. ");
INSERT INTO auu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Paa agoo see bagee yuwa miya Wa paagoo medaakea. Kuwa paa yuwa me Waa deegea kaboo paa yago bagee yuwa Wa me badoo da kaa mumo esee-kudiinta asiino, \"Aa ko Ogatamee Yoopaa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kiya Wa me kuwa paa yuwa maamaa aseekee kaa \"Anii mée paagoo se naipi kiyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus mee pakadoota maga kutuu to kaa pakaamaata kaama Wa me ede gaata bagee yuwa \"Meei\" asigi. Okoo Wa paagoo megea. ");
INSERT INTO auu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wa me okoo gaasi ma wiya kuwa wigintaata kaama kuwa bagee yuwa Ni me menaa nadoonaasi naadi peeyaata bagee yuwa see ekaa mee muntayu. Kuwa ko okoo Nii ma epo enaataa peenaa naadi Ni me menaa naweganaa taapea, ");
INSERT INTO auu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","bedaa Ni me pesee da kaa paa yuwa mée yiba kaama yaabagaapii taapea, kisee ukuwanaasi yoka naadi okoo wigintayu. ");
INSERT INTO auu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kuwa Wa me wigintaata bagee gaasi ma wiya kuwa ekaa yuwa ko kisee: Simon, Petrus see ekaa Yesus me muntaata mée mee ma, ");
INSERT INTO auu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeus me yoga wiya kuwa ko Yakobus ma, menaamee Yohanes ma Yesus me Boanerges see ekaa muntaata bagee wiya. Mena nekeeniino yaato ko dimi mena keemuu mokoo see bagee see ekaa mee. ");
INSERT INTO auu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kiyoo kaama Andreas, Pilipus, Bartolomeus, Matius, Tomas, Alpeus yoopaa Yakobus, Tadeus, yape tukuu mée Simon, ");
INSERT INTO auu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","bedaa Yudas Iskariot, Yesus ekegataata kepe masiipi mée. ");
INSERT INTO auu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus mee peedoota ee kaa peemaata kaama bedaa mée eebaa Wa paagoo medaakea. Mée eebaa medaakea naadi Waa ma, Wa me topenaa see bagee yuwa ma okoo naano agiyoo nuyaa kaboo taa. ");
INSERT INTO auu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kuwa Wa kaa menaa kuwa Waa ma kenaa bagee yuwa miya yeegea. Okoo me yeeta kaama wegaano, \"Yesus mee taki-takii meanigi yoka\" see wegagea. Okoo me Waa badaa maadoo poono see naadi megea. ");
INSERT INTO auu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kuwa kaboo da Musa me menaa mée topetaa see bagee yuwa kuwa Yerusalem magaa kaa kaama megea. Okoo me wegaano, \"Waa ko Beelzebul mee tawata mée\" see wegagea. Bedaa \"Waa paa me eboo tawata kaama too paa yuwa yaabagaapeasiyaa\" see menaa kuwa miya yawegagea. ");
INSERT INTO auu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus me okoo \"Meei\" see asigi. Meemaagea kaboo Wa me ebea-ebea menaa kaa okoo asiino, \"Kaasee kaa Iblis me Iblis mee ekaato abagaapeasiyaa? Wa kaa tabogetaa see paa yuwa kuwa se abagaapeasiyaa, se maa? Ebea-ebea menaa ena kisee: ");
INSERT INTO auu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Maga ena kaa bagee okoo aawisi-maawisi siyu ko mée ukubaanta kaama asii se pesee kiyaa, okoo dabaa kiyaa. ");
INSERT INTO auu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bedaa ee ena kaa bagee miya okoo aawisi-maawisi siyu ko aapataga naadi kaama se pesee kiyaa. ");
INSERT INTO auu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mee mokoo miya paa tabaa da aawisi-maawisi siyu ko mee asii se pesee kiyaa. Kisee Iblis me wa kaa tabogetaa see paa yuwa abagaapeasiyu ko okoo uduma ukubaanta kaama wa me ebo toono kuwa taa kedaa siyaa. ");
INSERT INTO auu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mena ena ma kisee: Omaago kiyaa mée wa me agiyoo yuwa mée me oma yamasiino see gaayu ko wa me ee yiba seemeta kaama wa keta one gadimemaata kaama too wa me agiyoo yuwa daba yamasegeeyaa. ");
INSERT INTO auu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Anii mikee kisiino ko: Mée me pedeo ukuwayaa agiyoo yuwa ma, pedeo see yawegaa-wegaa siyaa yuwa ma kuwa uduma Ogatamee me epa yaekeasiyaa ");
INSERT INTO auu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kiya Roh Kudus mee pedeo see yawegaa-wegaa siyaa bagee kuwa epa se ekeasiyaa. Mee ko esee pedeo ukuwayaa agiyoo yoka iminoo miya, iminoo miya epa se ekeasiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Wa me okoo kisee asigi menaa mee ko okoo me \"Waa paa agoo see mée to kemaata kisee agiyoo ukuwanaa segeeki\" see menaa kuwa me asigi menaa. ");
INSERT INTO auu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kuwa kaboo da Yesus Wa me okooto ma, menaanii yuwa ma kuwa megea. Okoo meemaata kaama yoo da kaa toomuu taaki too mée waa ena paagoo asiino, \"Waa misi yoka mena naogaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kuwa kaboo da mée eebaa Yesus gebo naayaato-naayaato toomuu taakea. Mée me Wa paagoo pe-asegea menaa ko \"Deede, abaayo ma, agaabee nokaa yuwa ma kuwa yoo da kaa kadiitoo taakea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus me okoo asiino, \"Nibaayo mee maapii naa ya? Anii ma kenaa bagee kuwa maamee nuwaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wa me kuwa Waa naayaato-naayaato toomuu taakea bagee yuwa iiyaga-yaga naadi kaama asiino, \"Deede, kuwa ko nibaayo nokaa yuwa ma, Anii ma kenaa bagee yuwa ma kuwa. ");
INSERT INTO auu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mikee, epoo to wodoo Neataagi me gaata-gaata yuwa too daamaa yaukuwataa see bagee kuwa ko neawaagi nokaa yuwa ma, neebee nokaa yuwa ma, Ni me ukuyogaa yuwa ma, nibaayo nokaa yuwa ma kuwa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Bedaa kaawaa ena ma Yesus mee piku geboo da kaa mée yuwa topetaaka too ko mée eebaa Waa naayaato-naayaato kutuu semaagea. Okoo mée eebaa naadi Waa uwo dagii da kaa koma ena kaa pakaanta animaayu, mée yuwa uduma ea da kaa totaakea. ");
INSERT INTO auu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wa me mée topetaa see menaa kuwa ebea-ebea menaa kaa eebaa topetaa. Wa me mée topeta menaa ena mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","\"Yeede, mée ena gandum poo keepa sigimenaa taano see naadi peegi. ");
INSERT INTO auu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Keepa sigimenaaka too ko noonaa etaa da kaa eseanee naadi bedo yuwa me nootaagea. ");
INSERT INTO auu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bedaa noonaa oma agoo see magaa kaa, maga eebaa taa see yoo eseaneeka. Maga eebaa taa kaa moga iyadaaka kiya ");
INSERT INTO auu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","mani yuwa maga yiba daamaa poono taa kemaata keno mega ko kuwa iyapa yuwa denadaa naadi wii kedaaka. ");
INSERT INTO auu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bedaa noonaa miya takuu uwaa yiba eseaneeka. Iyaga kiya boo aatakiika naaki egaapeasega yoka poo ekaano taa. ");
INSERT INTO auu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mee kaama too noonaa yuwa daamaa magaa kaa eseaneeka. Iyata kaama poo ekaga naaki poo ukuu noonaa amaamo, noonaa bado ena, noonaa ogei me badoo, kisee ekadaaka, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bedaa Wa me asiino, \"Apa agoo see bagee daamaa yii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesus Wa too toomuu taaka too ko Wa sekaataa bagee yuwa ma, Wa me topenaa see bagee gaasi ma wiya kuwa ma epo enaataa peedoota Wa paagoo asiino, \"Kuwa A me ebea-ebea menaa kuwa nekeeniino yaato kuwa kaasee?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wa me asiino, \"Ogatamee Wa too ebo mée eetuyaa menaa kuwa idukaa kaama awee da kaa kiyaano taa. Eto kuwa menaa kuwa ikii paagoo daamaa awee da kaa kikiyaagi kiya Ni yaato taa see bagee kuwa gaayu ko Ni me okoo paagoo eewegaano menaa kuwa uduma ebea-ebea menaa kaa too eewegageeka. ");
INSERT INTO auu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Idukaa ebeamaata menaa ena mee ko kisee: 'Okoo deegea kiya se deesi naadi, bedaa okoo mena yeegea kiya se nekeensi naadi Ani me kisee yakiyaabuu taapa. Kisee taa naaki okoo Ni paagoo namiyaa, Anii okoo me pedeo yuwa epa yaekeasiyaa' see menaa ebeamaata. Kisee ukuwaandaasi naadi Anii okoo paagoo ebea-ebea menaa kaa too eewegageeka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesus me Wa me topenaa see bagee yuwa asiino, \"Ikii mee ebea-ebea menaa mee nekeeniino taa ye? Kisee gaayu ko ikii kaasee apanaa ebea-ebea menaa kuwa nekeeniyaa ya? ");
INSERT INTO auu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mee ko kisee: Poo keepa sigimenaa see mée me Ogatamee me etokaa menaa sigimenaa siyaa ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kuwa menaa etaa da kaa eseanee siyaa ebea-ebea mee gaayu ko mée me yeeyaa kiya kisee ki Iblis me okoo me dimii yiba sigimpea yuwa yamasedoo peeyaa, see ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bedaa oma dagi kaa eseanee siyaa yuwa gaayu ko menaa da yeeta kaama moga ede ma, ede ma masiyaa bagee yuwa mokoo ");
INSERT INTO auu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kiya okoo manii da taa yoka okoo ae-wae siyaa kaboo makii taa see kaa maamaa se toowoo siyaa. Mée me kuwa menaa peneata bagee yuwa wegee-wegee siyaa kaboo okoo kuwa menaa moga ekeata peeyaa see ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Takuu uwaa yiba eseanee siyaa yuwa gaayu ko menaa da yeegea kiya ");
INSERT INTO auu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mée me dimi-pami kuwa me mee menaa da dapimeekee. Kuwa ko okoo me umiino, toono yiba gaagaa dimii mee ma, kepe, kisee mée deebaa siyaa agiyoo ou dimii mee ma, apanaa ou dimii yuwa ma kuwa me mee menaa da egadaa naadi kaama okoo poo ekaano taa see wodoo yuwa ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Daamaa magaa kaa eseanee siyaa yuwa gaayu ko menaa da yeeta kaama daamaa masiyaa bagee yuwa ebea-ebea. Okoo me poo ekawoo siyaa yuwa kuwa ko mée noonaa poo ukuu ena kaa amaamo, noonaa bado ena, noonaa ogei me badoo kisee eebaa kedaa siyaa bagee kuwa, see ebea-ebea menaa mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bedaa Wa me okoo asiino, \"Pelita biyaa iyaata kaama doodoota otaawee me apumaakee se kiya, mée me ometaa see keagee da miyoo taa aii ekeasiyaa mee miya se kiya biyaa maagee yoo pakaa-ekeasiyaa, se maa? ");
INSERT INTO auu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mee mokoo miya idukaa kaama booniwoo seta menaa uduma awee da kaa kedaa taapa, bedaa mée paagoo eewegaano taa menaa kuwa miya ipi kiyaabuu taapea. ");
INSERT INTO auu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Apa agoo see bagee daamaa yii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bedaa Wa me asiino, \"Ikii me yeetaa see menaa kuwa daamaa ipiipi dii. Ikii me daamaa yeewoo siyaa doodoo ikii daamaa masiwoo taapea. Bedaa mee asii miya ikii maamaa eebaa daamaa kineeyaa. ");
INSERT INTO auu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kuwa ko agoo kiyaa bagee yuwa bedaa noonaa ma masiipea. Kiya taa kiyaa bagee yuwa okoo me peenaa kiyaa yuwa miya yamasegeeyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Bedaa Yesus me wegaano, \"Ogatamee Wa too ebo mée eetuyaa kuwa ko kisee: Mée ena poo keepa bugi kaa sigimenaa naadi kaama ee kaa peetaa. ");
INSERT INTO auu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Omemaayu tokoma mee da anoogeeta bugi yaataa, daatooyiba yaato toomoo ometaa, kisee too wa me ukuwagee see. Poo keepa yuwa kuwa daamaa iyataa see kiya 'Kisee kaa iyaga, kisee kaa iyadaaka' see kuwa waa ewo. ");
INSERT INTO auu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Magaa to mee me kaama poo keepa waadibaa iyawoo naadi kaama poo ota ekadaa siyaa. Iyaano ko petamanii kabagaa da pakaamaaga, iyawoo naadi kaama ukuu ekadaaka, kaama too poo ota yuwa kuwa miya ukuu kaa eebaa kedaaka, kisee iyawoo see. ");
INSERT INTO auu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Poo ota yuwa kapoo kega naaki poo daano kaboo yoka bugi epoo mée me poo ota yuwa moga daataa siyaa. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa.\" ");
INSERT INTO auu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus me asiino, \"Ogatamee Wa too ebo mée eetuyaa kuwa inii ebea-ebea menaa kaa kaasee wegayaa? ");
INSERT INTO auu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eto ko kisee: Mée ena sesawi poo keepa ena masegeeta wa me bugii da kaa weetayu. Sesawi poo keepaa to mee umina peedi, magaa da kaa poo keepa apanaa yuwa see see se. ");
INSERT INTO auu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kiya weetaata kaama daamaa iyawoo naadi kaama piya wodoo to ebo kiwooka siyaa, bugi kaa weta agiyoo apanaa yuwa see see se. Kago ebo peeda-paada naadi kaama bedo yuwa kiyoo geka daamaa maagee siyaa. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ebea-ebea menaa kuwa see see Yesus me mée yuwa paagoo okoo me nekeeniyaa dimii doodoo too eewegageeki. ");
INSERT INTO auu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wa me mée yuwa paagoo ebea-ebea menaa ma taa see menaa kuwa eewegaano taa. Kiya Wa me topenaa see bagee yuwa paagoo kuwa menaa nekeeniino yaato daamaa ase-manee segeeki. ");
INSERT INTO auu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mee naagoo uwaataa da Yesus me Wa me topenaa see bagee yuwa asiino, \"Piku asii yaato pookee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Okoo kuwa kiyoo topea bagee yuwa ekeata kaama Yesus mee tupi see komaa da kaa pakaanta kaama okoo paaya epo enaataa peetaa, apanaa bagee miya okoo me komaa yuwa kaa pakaanta kaama epo peegea. ");
INSERT INTO auu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uwo pikuu da taa peetaaka too ko bo ebo mega, biku-biku miya ebo kega. Uwo komaa da yiba seemedaaka naaki uwo pudii taano see kooka. ");
INSERT INTO auu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kiya Yesus Waa koma babu yaato mumo paga kaa toomoo ometaaki. Wa me topenaa see bagee yuwa me Waa maanegea. \"Ei, Guru, inii uwo poonakea kuwa A me wisintaage ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Waa anoogeeta kaama bo ma, piku ma kuwa \"Koogo sikiinii\" asigi naaki bo siki, biku-biku umina taa kega. ");
INSERT INTO auu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wa me okoo asiino, \"Ikii kaasee wedaagea? Ikii me kaasee Ni kaa dimi namagaano taa kepea ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Okoo weda kaa dimi nagimeamookea. \"Mee kaasee Mée? Biku-biku, bo kisee agiyoo kuwa Wa me menaa yayiino too\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Okoo piku asii yaato Gerasa magaa kaa peemaayu. ");
INSERT INTO auu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Koma yiba kaama maayoo kaa eseanigi too ko paa agoo see mée ena ogo maataa see beapa yuwa kaa kaama migi. ");
INSERT INTO auu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Waa kiyoo omegee, toogee see mée. Waa omaago yoka mée me one gadimaano iyo, pose onee me miya iyo. ");
INSERT INTO auu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mée me pose onee me wa me yagaa bado kaagaa eebaa gadimegeekea kiya wa me kuwa onee yuwa, yagaa kaa miya, bado kaa miya daataga-paataga naadi ekeasigi. Waa peneasiino bagee ena ma taa, se ukuwamaayaa. ");
INSERT INTO auu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Waa egapi yaato miya, daatooyiba yaato miya kataa-kataa ma menaa weganaa, peenaa segee see mée. Waa mée ogo maataa see yoo kiyoo miya peenaa segeeki, kuyee da taa miya nawenaa segeeki, bedaa waa ekaato maa to oma uguu me geemegee taa see, waa kisee mée to. ");
INSERT INTO auu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Waa beesekaa mokoo kaama Yesus deeta kaama yiibaga Wa paagoo meemaata kaama mumo maga kaa ekeasigi. ");
INSERT INTO auu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wa me mena ebo kaa asiino, \"Ei, Yesus, Asii-sege see Mée Ogatamee Yoopaa. Aa ma anii mapea menaa agoo? Eto ko A me Ogatamee ekaa weekee kaa yaai-yaai ma, boodi ma kuwa aa se kakiyaapa see nasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wa me Yesus kisee asigi mee ko Yesus Wa me keta \"Aa paa aa, mee mée to ekeata kaama pooi\" see asigi yoo. ");
INSERT INTO auu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus me \"A ekaa da maamee naa ya?\" see asigi naaki \"Anii ekaa da ko Legion, Paa Ebo Etaa see ekaa mee, inii paa maamaa eebaa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wa me Yesus paagoo maamaa aseekee kaa \"Apanaa magaa kaa peedaa taai see mée se asii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kuwa kaboo da woo kaa naa kaa kuyee da kaa ekena eebaa ebo etaa maga notaakea. ");
INSERT INTO auu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Paa yuwa me maamaa aseekee kaa \"Inii kuwa ekenaa kuwa yiba pakaa-seemaanake yoka kitaa mée seemiyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus me \"Daamaa, peeweei\" asigi naaki paa yuwa mee mée to yiba kaama peedaa naadi ekena yuwa yibaa taa pe-seemedaakea. Seemedaa naadi kaama egoowee gidumedoota piku yiba dugumedaakea. Kuwa ekenaa kuwa maamaa eebaa, dua ribu waa naa mokoo. ");
INSERT INTO auu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kiyoo ekena munitaa see bagee yuwa yaai naadi kuwa ukuwaanega menaa yuwa doodoota mee magaa kaa bagee ma, gebo kaa bagee ma kiyoo-kiyoo eeweganaakea. Mée yuwa okoo miya mee ukuwaanega kotoo diino see naadi medaakea. ");
INSERT INTO auu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Okoo Yesus paagoo meemaata deamaagea naaki mee paa ebo etaa seemeta see mée to mee aii toomuu taaki. Waa doka maataata totaaki, taki-takii miya taa kega. Okoo wedaagea. ");
INSERT INTO auu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kuwa yumakaa ukuwaanega kotoo deepea bagee yuwa me \"Wa me kisee paa yaabagaapeasigi, bedaa ekena yuwa miya kisee ukuwaanega\" see menaa kuwa eewegagea. ");
INSERT INTO auu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Okoo me kuwa menaa yeeta kaama Yesus paagoo maamaa aseekee kaa \"Inii me magaa kaa kiyoo Aa se naatooi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus mee bedaa mee komaa kaa pakaanigi too ko mee yumakaa paa agoo see mée to me Wa paagoo asiino, \"Anii miya meenaka\" see menaa maamaa asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kiya Yesus me waa asiino, \"Taa, ee kaa pooi. Tuhan me aa kaepa kaa daamaa kaukuwapi menaa kuwa a me epa see bagee yuwa paagoo pe-eewegaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kisee asigi naadi waa peedoota Dekapolis wee kaa bagee yuwa paagoo eewegaano, \"Yesus me kisee daamaa naukuwapi\" see menaa kuwa eeweganaaki naaki mée uduma dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus ma, Wa me topenaa see bagee yuwa ma epo uwo asii yaato bedaa metaki peemaaga too ko mée okoo eebaa topea. Waa maayoo kaa eseanta toomuu taaki too ko okoo Wa paagoo yigimeeiikea. ");
INSERT INTO auu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kuwa kaboo da mée ena, mee magaa kaa sembahyang segee see ee kaa eboo mee Yesus paagoo migi. Wa ekaa da ko Yairus. Yesus paagoo meemaata kaama Wa me badoo da kaa esee-kudiinigi. ");
INSERT INTO auu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Wa me maamaa aseekee kaa \"Niyoopane mee bogaano see koo taaka yoka meei, wa kaa yagaa yamaatagaai. Mee ikiyoo taa keta kaama waa aya toogeesi ke\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kisee asigi naadi Yesus Waa mee mée to sekaataa peetaa, mée eebaa miya eta ma me-yigimeeiikea. ");
INSERT INTO auu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kuwa epo peegea bagee tabaa da api ena miya kitaa peega. Waa tahun gaasi ma wiya kisee too tadaa too peegee see apii. ");
INSERT INTO auu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokter bagee mée eebaa waa kisee too yadeetaa see kiya iyo, taa kaano taa. Wa me kepee uduma mee agiyoo kaa tameepeata kiya mee agiyoo ebo kega, ebo kega siwooka. ");
INSERT INTO auu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yesus Wa me ukuwanaaki yuwa kuwa waa yeepa kemaata Yesus oko yaato kaama Wa me dokaa da pee-yaadeega. ");
INSERT INTO auu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wa me gaano, \"Anii Wa me dokaa mee too yaadeeyaa miya mee agiyoo taa kaapa\" see gaaga. ");
INSERT INTO auu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wa me dokaa pee-yaadeega naaki taka ena tadaa sikiinega. Wa me 'Mikee, eto ko ni me maa da kaa meanee taa see agiyoo mee taa kega ii' see gaaga. ");
INSERT INTO auu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus me Ni me pesee agiyoo kuwa noonaa peega ii see kuwa nekeenta kaama kiyoo bagee yuwa paagoo asiino, \"Ni me maapa dokaa da mee maamee me nayaadeegea naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wa me topenaa see bagee yuwa me asiino, \"Mée maamaa eebaa A paagoo yigimeeii naadi sipintaagea kuwa Aa miya deege yoka A me 'Maamee me nayaadeegea naa ya' see kuwa kaasee ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesus me maamee me nayaadeegea ya naadi kaama Wa gebo iiyaga-yaga. ");
INSERT INTO auu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mee apii to me mee agiyoo nataa kiyaagi ii see nekeenta kaama weda ebo kaa totomo ma Yesus paagoo esee-kudiinta toomuuka. Wa me \"Ani me kisee koo sepa\" see menaa kuwa ase-maneega. ");
INSERT INTO auu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesus me waa asiino, \"Niyoopane, a me mikee nagaano dimii mee me aa daba daagimaa peege. Koogo pooi, a kaa meanee taa see agiyoo kuwa kataa kiyaaga yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus me kuwa menaa asetaaka too ko mée noonaa Yairus me ee kaa kaama meemaagea. Okoo me Yairus asiino, \"Ayoopane mee booga yoka wisintagaai, Guru mee a me ee kaa badaa se magaai, Waa gaagaa siyaakee se\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kuwa menaa yuwa Yesus yeemaata kaama Yairus asiino, \"Aa se wedaai, mikee nao see dimii mee too gaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mée eebaa Wa sekaataa peegea kiya Wa me \"Petrus ma, Yakobus ma, Yohanes ma kuwa too meei, ikii apanaa yuwa nakaayoo toomuu taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yairus me ee kaa peemaata kaama deeyaa naaki mée okoo uduma mena ebo kaa maamaa yege ma, yii-yii ma seamoo taakea. ");
INSERT INTO auu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ee yiba pakaanta kaama Wa me asiino, \"Ikii kaasee kaa mena ebo kaa yege ma, yii-yii ma taakea ya? Waa boopa se, toomoo ompa ke\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kiya okoo yakeakea. Yesus me okoo uduma yoo da kaa abagakomeeta kaama Wa me mee yogaa to me okonaka ma, Waa ma enaataa bagee wedoo to ma kuwa uduma badaa maadoota yogaa to topa kiwisii to kaa ");
INSERT INTO auu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","peemaata kaama mee yogaa to yagaa da pe-peneasigi. Wa me \"Talita kum\" asigi. Mena nekeeniino yaato ko \"Ukuyogaa peedii to Ani me aa kasiino ko anoogii\" see mee. ");
INSERT INTO auu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","\"Anoogii\" asigi naaki taka ena mee ukuyogaa to anoogeeta peenaaka. Kiyoo topea bagee uduma dimi nagimaano ebo. Waa ko tahun gaasi ma wiya ometa see ukuyogaa. ");
INSERT INTO auu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesus me okoo maamaa asiino, \"Kuwa ukuwapa-ukuwapa kuwa mée se eewegaai\" see asigi. Bedaa \"Yogaa to naadi kaapa yoka naano agiyoo manii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kiyoo kaama peedoota Wa me magaa kaa, Wa me topenaa see bagee yuwa miya Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Peemaata kaama Sabat naagoo Waa kiyoo sembahyang segee see ee yiba seemeta kaama mée topetaa. Wa me mée topetaa see menaa yiitoo see bagee mée eebaa dimi nagimegea. Okoo me wegaano, \"Kuwa menaa kuwa kayoo kaama naa masipi ya? Wa me esee dimi ipi kigi kuwa kaasee? Wa me yagaa da me dimi nagii-nagii agiyoo ukuwaaniyaabuu segeeki kuwa maagiyoo naa tawapi naa ya? ");
INSERT INTO auu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Waa piya kapataa see mée, se maa? Maria yoopaa mee, se maa? Waa ma kenagaa yuwa kuwa Yakobus ma, Yoses ma, Yudas ma, Simon ma kuwa, se maa? Bedaa ukuyogaa yuwa miya nakaayoo inii paaya enaataa topea yoka\" see wegagea, kisee Waa wisinegea. ");
INSERT INTO auu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus me okoo asiino, \"Nabi bagee kuwa ko mée me ebo ekeasiyaa kiya okoo me magaa kaa bagee ma, okoo ma kenagaa ma, okoo me ee kaa bagee ma kuwa me too ebo se ekeasiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wa me dimi nagii-nagii agiyoo eebaa kiyoo agoo kiyaano iyo. Ikiyoo yago bagee ekea wiya, wedo waa naa too okoo kaa yagaa yamaataata kaama ikiyoo yataa kiyaagi. ");
INSERT INTO auu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesus me okoo me mikee nagaano dimii mee taa yaai naadi dimi nagimaano ebo. Kiyoo kaama Yesus Waa kiyoo-kiyoo maga nawenaa, mée topenaa, kisee ukuwanaa, peenaa segeeki. ");
INSERT INTO auu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kuwa kaboo da Yesus me Wa me topenaa see bagee gaasi ma wiya \"Meei\" asigi. Meemaagea kaboo okoo me paa yuwa yaabagaapeasi naadi pesee da okoo kaa mantayu. Mantaata kaama okoo mée ekea wiya maga ena kaa pooi, mée ekea wiya maga ena kaa pooi, kisee Wa me okoo yawuditaata peeyaano see kaboo ");
INSERT INTO auu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wa me okoo asiino, \"Ikii peenaaka too agiyoo se dogaai. Naano agiyoo, ayaa, kepe ayaabu, kisee agiyoo kuwa ekeasii. Tamoo da mee too daamaa dogaai, ");
INSERT INTO auu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","bado doko miya magaai kiya doka wiyaagoo to mee se dogaai. ");
INSERT INTO auu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ee ena kaa peemaata kaama okoo me ikii daamaa badaa kimaapea kepa ko mee ee kaa too eeomegee, toogee taai, apanaa magaa kaa peeyaa naagoo too pooi. ");
INSERT INTO auu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maga ena kaa bagee me ikii badaa kimagaano miya be, ikii me eewegayaa menaa miya be kiyu ko ikii poono kaboo okoo gaamaasi naadi ikii badoo da kaa maga ponee yuwa takadekumii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Asigi naadi okoo peedoota mée yuwa paagoo \"Ikii uduma ikii me pedeo yuwa ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo taai\" see menaa kuwa eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Paa maamaa eebaa miya yaabagaapeasegea, bedaa mée eebaa okoo kaa minyak uwoo miya yawidimegea naaki okoo kaa meanee seta agiyoo kuwa taa kedaakea, kisee agiyoo kuwa okoo me ukuwanaa seta. ");
INSERT INTO auu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kuwa kaboo da Yesus Wa ekaa da ogo peega naadi kaama Galilea wee kaa eboo Herodes mee Wa kaa menaa yuwa yeegi. Mée noonaa me wegaano, \"Mee mée mee ko uwo mée yatukumeta mée Yohanes boomi mee. Waa boota kaama aya andoo peepi kemaata kuwa dimi nagii-nagii agiyoo kuwa ukuwamaayaa\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kiya mée noonaa me wegaano, \"Mee ko nabi Elia mee\" see weganaakea. Bedaa mée noonaa me \"Waa ko nabi bagee ena, idukaa nabi bagee ena mokoo\" see weganaakea. ");
INSERT INTO auu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kiya Herodes me kuwa menaa yeeta kaama wegaano, \"Okoo se. Mee ko Yohanes. Idukaa ani me 'Wa me mumoo to nadaakumii' see asema yoka waa boota kaama aya andoo peepi\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yohanes boota-boota menaa mee ko kisee: Petamanii Herodes me waebee Pilipus woga ekaa da ko Herodias mee oma yagoemi. Oma yagoemi kemaata Yohanes me Herodes paagoo \"Agaabee woga mee aa goeano ko daa\" see asegeeki. Kisee asegeeki naadi Herodes me \"Yohanes mee pe-peneata digiyoo ee yiba nadogeamaai\" see asigi. Asigi naadi digiyoo ee yiba dogeamaagea. ");
INSERT INTO auu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yohanes me \"Aa kisee goeano ko daa\" see asigi menaa kuwa me Herodias mee kagoo ebo, Yohanes mee patamaano dimii agoo kiya iyo. ");
INSERT INTO auu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mee ko Herodes me 'Yohanes mee dimi topoo, daamaa wigintaata pedeo taa see mée ii' see gaagi kemaata Yohanes mee wedaagi. Waa digiyoo ee yiba toogeeki kaboo Herodes me taamege-taamege segeeki. Wa me Yohanes me menaa yiitoo taaki too waa dimi abaano ebo kiya waa yiitoo taano ede. ");
INSERT INTO auu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kisee kemaata Herodias me Yohanes mee patamaano iyo kiya kaawaa ena waa patamaano etaa da agoo kega. Mee ko kisee: Herodes mee kabata naagoo kenoo kaa naano agiyoo naano see naadi ekaa yago bagee yuwa ma, tentara ebo-ebo yuwa ma, Galilea wee kaa tuku-tuku bagee apanaa yuwa ma okoo uduma kutuu semaagea. ");
INSERT INTO auu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kuwa kaboo da Herodias yoopane mee Herodes ikigii to taa waanena-peena senaaka. Herodes waa esee ede kigi, waa ma epo notaakea bagee yuwa miya ede kegea. Wa me mee ukuyogaa to asiino, \"A me ede kiyaa agiyoo kuwa kaniipa. ");
INSERT INTO auu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mikee, A me naidimiyaa agiyoo kuwa taa ma taa kaniipa, se kaniino ko daa. Ni me ebo totaa see magaa kuwa yupigapi wigintaata kaama naayaato kuwa miya kaneeyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mee ukuyogaa to peedoota okooto paagoo asiino, \"Ani me maagiyoo idimaano daamaa naa ya?\" see asega naaki \"Uwo mée yatukumeta mée Yohanes mumoo to mee anii nii see asii\" see asega. ");
INSERT INTO auu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ukuyogaa to moga peedoota Herodes paagoo asiino, \"Uwo mée yatukumeta mée Yohanes mumoo to mee nadaageeta piring kaa ekeata eto kiipaa neekee ede\" see asega. ");
INSERT INTO auu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes mee menaa da yaai, dimi boodi ebo kiya wa me mée uduma gii da kaa \"A me ede kiyaa agiyoo se kaniino ko daa\" see asigi kemaata iyo. Wa me \"Aa kaniino be\" see kuwa se wegamaayaa yoka ");
INSERT INTO auu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","okaa yago bagee ena paagoo asiino, \"Wa me mumoo to daageeta doomeei\" see asigi. Asigi naadi peedoota digiyoo ee kaa Yohanes ogo daageeta kaama ");
INSERT INTO auu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mumoo to piring kaa ekeata doodoota mee ukuyogaa to paagoo manigi. Kiyoo kaama mee ukuyogaa to me okooto manega. ");
INSERT INTO auu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanes me topetaa see bagee yuwa me kuwa menaa yeeta kaama bootaa da masegeeta kaama mée ogopa beapa yiba ogo maagea. ");
INSERT INTO auu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesus me topenaa see bagee yuwa Wa me miyoo taa kiyoo-kiyoo peedaa siyaata kaama bedaa okoo Wa paagoo metaki meemaagea. Okoo me \"Kisee agiyoo ukuwanaa sepe, kisee menaa mée topenaa sepe\" see menaa kuwa uduma Wa paagoo eewegagea. ");
INSERT INTO auu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kuwa kaboo da mée maamaa eebaa Wa paagoo metaa, peetaa segeekea naadi kaama Waa ma, Wa me topenaa see bagee yuwa ma okoo naano agiyoo naano iyo. Kisee kemaata Wa me topenaa see bagee yuwa asiino, \"Meei, inii too keedaa koogo toomuu taano see yoka Anii ma epo enaataa peedoota mée taa see yoo niipooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Okoo too koma kaa pakaanta kaama peedoota mée taa see yoo ");
INSERT INTO auu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","kiya mée eebaa Yesus mee kitaa peegi naadi wa me magaa kaa, wa me magaa kaa kaama yiibaga peedoota maayoo kaa taa Yesus peemagaapi yoo kiyoo okoo keta peemaagea. ");
INSERT INTO auu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus mee uwo yaaguu da kaa peemaata kaama deamaagi too ko mée eebaa totaakea. Wa me epa nao see gaagi. Okoo domba wodaa tabaa da domba munitaa see mée taa see bagee yuwa mokoo yoka naadi Waa mena eebaa okoo topetaa. ");
INSERT INTO auu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mee naagoo uwaataa da Wa me topenaa see bagee yuwa meedoota Wa paagoo asiino, \"Uwaapeasega ke, nakaayoo ee taa, bugi taa see magaa yoka ");
INSERT INTO auu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","kuwa bagee kuwa 'Peedaa taai' see asii, okoo gebo kaa magaa kaa naano agiyoo edaasi ke\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kiya Wa me okoo asiino, \"Naano agiyoo kuwa ikii me okoo manii\" see asigi. Okoo me asiino, \"Sooi, perak kepee ogei me badoo wiya kuwa miya iyo kiya naano agiyoo pee-yaedaageeta manii ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wa me asiino, \"Ikii roti magu magoo topa? Pe-dii\" see asigi. Okoo pe-deegeeta kaama \"Nakaayoo inii roti magu idibi, doge imi wiya topa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wa me kiyoo topea bagee yuwa asiino, \"Ikii uduma wa too kutuu, wa too kutuu naadi boo dagi kaa animaaii taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mée noonaa ko mée wiya ma gaasi wa too kutuu, mée noonaa ogei me badoo ena wa too kutuu, kisee wa too kutuu, wa too kutuu semaata kaama animaaiikea. ");
INSERT INTO auu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wa me kuwa roti magu idibii to ma, doge imi wiya ma kuwa masegeeyu naadi epoo to yaato pakaa-deeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Kuwa roti magu yuwa kabatagaa semaata kaama mée yuwa paagoo yawudikomeesi naadi Wa me topenaa see bagee yuwa goo-maneeyu. Bedaa doge imi wiya kuwa miya kisee kiyoo topea bagee yuwa uduma yawudikomeeyu. ");
INSERT INTO auu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Okoo uduma naano sikii, bekataa. ");
INSERT INTO auu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kiyoo kaama roti ma, doge ma koga topa ponee-panaa yuwa kuwa Wa me topenaa see bagee yuwa me meeii naadi kaama iduunee ayaa gaasi ma wiya pudii aweamaagea. ");
INSERT INTO auu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kiyoo okoo nota bagee yuwa mée eebaa, api, yoga se egaa see, paayogaa too lima ribu. ");
INSERT INTO auu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kuwa nota bagee yuwa Yesus me \"Koogo peedaa taai\" asiino see naadi kaama Wa me topenaa see bagee yuwa \"Ikii keta koma kaa pakaanta piku asii yaato Betsaida magaa kaa pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kuwa nota bagee yuwa \"Koogo peedaa taai\" see aseta kaama sembahyang taano see naadi pakadoota maga kutuu ena kaa pakaamaayu. ");
INSERT INTO auu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Digiyoo takiinega see kaboo Wa me topenaa see bagee yuwa piku semoo to kaa komaa da kaa topea. Yesus mee kuyee da kaa Wa too totaaki too ");
INSERT INTO auu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","deeyaa naaki Wa me topenaa see bagee yuwa bo ebo okoo poono yaato kaama mega yoka poono kana. Aweepegeeka see kaboo Yesus mee uwo dagii da taa peedoota okoo paagoo peemaata kaama amoo-sege taano see koo taaki too ko ");
INSERT INTO auu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","okoo me Waa bado me uwo dagii da taa peetaaki see deeta kaama paa yaai naadi ebo menaa-menaakea. ");
INSERT INTO auu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Okoo uduma kisee deeta kaama esee wedaagea kiya Wa me moga asiino, \"Taa, Anii yoka ikii se wedaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Waa okoo paagoo komaa da kaa pakaanigi naaki bo taa keepeasega. Okoo dimi nagimaano ebo. ");
INSERT INTO auu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mee ko yumakaa Yesus me roti maamaa eebaa yakiyaabuu sipi mee okoo daamaa nekeeniino taa, okoo dimi eboo yoka dimi nagimaano ebo. ");
INSERT INTO auu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Okoo uwaasii yaato Genesaret magaa kaa peemaata kaama komaa da one opeetaata eke. ");
INSERT INTO auu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Okoo koma yiba kaama maayoo kaa peanigi too ko kiyoo bagee yuwa me Yesus mee moga nekeenegea. ");
INSERT INTO auu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Okoo peedoota mee magaa kaa, mee magaa kaa mena ogo peeyaagea. Ikiyoo yago bagee yuwa uduma okoo me ometaa see keagee yuwa ma Wa paagoo doomegea. Mée me \"Eto Waa amokiyoo tupi, eto Waa yamokiyoo tupi\" see asenaa see yoo kiyoo-kiyoo Wa paagoo doomegea. ");
INSERT INTO auu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wa me peenaa, nawenaa see magaa uduma, ebo magaa kaa miya, peedi magaa kaa miya, boba kaa magaa kaa miya kiyoo-kiyoo ikiyoo yago bagee yuwa mée kutuu taa see yoo kiyoo eemedaakea. Okoo me Wa me doka otoo to kuwa \"Peenaa nayaadee siyaape ye?\" see asegea naaki Waa yaadee sepea bagee yuwa kuwa uduma okoo kaa meanee seta agiyoo kuwa taa kedaakea. ");
INSERT INTO auu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kaawaa ena Parisi kaa bagee noonaa ma, Musa me menaa mée topetaa see bagee noonaa ma okoo Yerusalem magaa kaa kaama peedoota Yesus paagoo kutuu semaata ");
INSERT INTO auu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","deamaagea naaki Wa me topenaa see bagee noonaa diiyoo se deeta yagaa keta uwo wetogeano taa kaa naano agiyoo notaakea. ");
INSERT INTO auu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi kaa bagee yuwa ma, apanaa Yahudi bagee yuwa ma kuwa gaayu ko okoo me bagee yuwa me idukaa kaama wegawoo seta menaa kuwa okoo me miya peneata deewoo siyaa, kuwa ko kisee: Yagaa da keta uwo wetogemaata kaama too naano agiyoo naano dagu. ");
INSERT INTO auu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bedaa kisee miya okoo pasar kaa peegeeta ee kaa meemaata kaama diiyoo deekee kaa okoo ekaato uwo wetogemaata kaama too naano agiyoo nuyaa. Okoo me kisee ipiipi see deewoo siyaa menaa kuwa maamaa eebaa, kuwa ko mooki, otaawee, totaano, kisee agiyoo kuwa miya diiyoo deekee kaa uwo kaa wetogetaa siyaa. ");
INSERT INTO auu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kisee kemaata Parisi kaa bagee yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me Yesus asiino, \"A me topenaa see bagee kuwa okoo me Yahudi bagee me asii-wega-wega menaa kuwa diiyoo se deegea. Okoo naano agiyoo naano taa kaboo yagaa keta uwo se wetogetaa see kuwa kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wa me okoo asiino, \"Ikii dimi daamaa poga-poga bagee kuwa yaai. Nabi Yesaya me wegata menaa mee mikee ikii kaa miya kiwegata, mee ko kisee: 'Kuwa bagee kuwa ebee to me too Anii ebo naekee segeekea, dimi menaa da me taa, okoo dimi mena yaato beesekaa. ");
INSERT INTO auu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Okoo me Anii naapaageekea kuwa makapaa, bedaa okoo me mée tupiwoo siyaa menaa kuwa miya mée me otoopa asii-wega-wega menaa yuwa too' see menaa kuwa ikii kaa miya kiwegata. ");
INSERT INTO auu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ogatamee me mée aseta menaa kuwa ikii me eke-bake segeekea, mée me asii-wega-wega menaa kuwa too peneata deewookea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bedaa Wa me asiino, \"Ikii ko ikii me asii-wega-wega menaa yuwa deewoo taano see naadi Ogatamee me menaa kuwa wisintagaa segeekea. Ikii kisee ukuwaano ipi see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kuwa ko Musa me aseta menaa ena mee ko kisee: 'Okonaka ebo ekeasii' see aseta. Bedaa mena ena miya kisee: 'Okonaka wisineekee kaa pedeo menaa asiyaa bagee kuwa wogeepeasii' see aseta menaa mee miya agoo. ");
INSERT INTO auu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kiya ikii me wegawoo seta menaa kuwa wa too ena, mee ko kisee: 'Mée ena me okonaka paagoo \"Ekea me gaano pedeo agiyoo kuwa kineeyaa kiya Ogatamee paagoo manega keekee\" see asiyu ko ");
INSERT INTO auu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ogatamee paagoo manta agiyoo yoka okonaka paagoo se maniyaa' see menaa kuwa ikii me asiyaa. Ikii me asiyaa menaa kuwa me wa me okonaka paagoo agiyoo ena ma se maniyaa. ");
INSERT INTO auu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kisee ikii me asii-wega-wega menaa kuwa me Ogatamee me mée aseta menaa peedi naadi eke-bake segeekea. Ogatamee me aseta menaa apanaa eebaa kuwa miya ikii me kisee eke-bake segeekea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus me bedaa kiyoo kutuukea bagee yuwa \"Meei\" asigi. Wa me okoo asiino, \"Ikii uduma daamaa nayii, nekeenii. ");
INSERT INTO auu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ogatamee me otoopa bagee mée diino kuwa ko mée yiba seemiyaa agiyoo kuwa me se. Kuwa agiyoo yuwa me mée se pedeo kiyaayaa kiya mée semoo yiba kaama pedeo dimii, pedeo menaa kuwa me too mée pedeo kiyaayaa. ");
INSERT INTO auu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Apa agoo see bagee daamaa yii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kuwa menaa okoo paagoo eewegadoota ee yiba pakaanigi kaboo Wa me topenaa see bagee yuwa me Waa asiino, \"A me ebea-ebea menaa mee nekeeniino yaato mee kaasee ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wa me asiino, \"Ikii miya se nekeenegea ye? Mée yiba seemiyaa agiyoo kuwa uduma mée se pedeo kiyaayaa agiyoo, see kuwa ikii ewo ye? ");
INSERT INTO auu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kuwa agiyoo kuwa dimi mena yiba se seemiyaa kiya kadapoo yiba seemeta kaama daba tameepeasiyaa, se maa?\" see asigi. Wa me kisee asetaagi naaki naano agiyoo uduma naano dagu kiyaata. ");
INSERT INTO auu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bedaa Wa me asiino, \"Mée pedeo kiyaayaa agiyoo kuwa ko mée semoo yiba kaama pakayaabuu siyaa yuwa kuwa too. ");
INSERT INTO auu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dimi yiba kaama agoo kedaa siyaa yuwa kuwa ko kisee: pedeo dimii ma, otoopa api doonaa, paayogaa doonaa taano ma, oma masiino ma, mée wugiino ma, ");
INSERT INTO auu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tobaaka taano ma, kepe ou, agiyoo ou dimii ma, pedeo ukuwaano ou dimii ma, mée deebaa taano ma, otoopa ou dimii kaa ukuwanaa taano ma, anii naaki ou see dimii ma, mée badiino ma, ebo poga-poga dimii ma, dimi taa kaa ukuwanaa, peenaa taano ma ");
INSERT INTO auu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","kuwa uduma dimi yiba kaama agoo kedaa siyaa. Kuwa pedeo dimii, pedeo menaa kuwa me mée pedeo kiyaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kiyoo kaama Yesus peedoota Tirus magaa kaa peemaata kaama ee ena yiba seemetaa. Mée me Waa mee ee yiba tupi see ipi kegea kuwa Waa be kiya iyo, okoo ipi kegea. ");
INSERT INTO auu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kuwa kaboo da api ena Yesus tupi see menaa yeedoota moga Wa me badoo da kaa esee-kudiinega. Wayoopane paa agoo. ");
INSERT INTO auu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mee apii mee ko Siro-Penisia magaa kaa Yunani tomaa kaa apii. Wa me Yesus paagoo asiino, \"A me mee paa mee niyoopane kaa kaama yaabagaapeasiipe ye?\" see asega. ");
INSERT INTO auu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesus me waa asiino, \"Yoga yuwa okoo keta naano agiyoo sikii-sikii nuyaakee, okoo me naano agiyoo masegeeta kaama kameno maniino ko pedeo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Apii to me asiino, \"Neataagi, A me wegage kuwa mikee kiya yoga yuwa me naano agiyoo noogee yoo kaama eseanee siyaa ponee-panaa yuwa kuwa kameno me nuyaa\" see asega. ");
INSERT INTO auu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus me waa asiino, \"Kuwa a me daamaa wegage menaa kuwa me aa koogo pooi, mee paa mee ayoopane ekeata peega yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Asigi naadi waa peedoota ee kaa peemaata kaama deeyaa naaki mee paa da pe-seomega, yogaa to komoo da kaa daamaa ometaaka. ");
INSERT INTO auu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kuwa kaboo da Yesus mee Tirus magaa kaa kaama peedoota Sidon magaa doodoo Galilea piku geboo da kaa Dekapolis wee kaa magaa ena kaa peemaayu. ");
INSERT INTO auu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Peemaata kaama apa takiinta mée ena Wa paagoo eemegea. Mee mée to mena wegaano kana. Yesus me yagaa wa kaa yamaasi naadi maamaa asegea. ");
INSERT INTO auu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus me waa badaa maadoota amoo maa kaa mée taa see yoo eepeemaata kaama yagaa kepo wiya mee mée to apa togo wiya kaa pe-sebaata eke. Kiyoo kaama dabeedi taakomeeta kaama mee mée to dabegea da pe-yaadeeyu. ");
INSERT INTO auu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus me emaa epoo to yaato deataata kaama aa-waa ma \"Epata\" see asigi. Mee ko \"Wodaanii\" see menaa mee. ");
INSERT INTO auu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Asigi naaki taka ena mee mée to apa miya wodaanigi, dabegea da miya gakadeenigi naadi kaama mena daamaa wegagi. ");
INSERT INTO auu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesus me kiyoo bagee yuwa maamaa aseekee kaa \"Ani me ukuwaga kuwa mée se asii\" see asigi. Wa me omaago ma mée se asii see asigi kiya kuwa menaa yuwa maamaa eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mée uduma dimi nagimaano ebo kaa asiino, \"Wa me ukuwayaa agiyoo uduma daamaa too. Apa takiinta bagee miya mena daamaa yeeyaayu, bedaa mena wegaano naka see bagee yuwa miya mena daamaa wegayaayu, kisee daamaa ukuwayaabuu taa see Mée\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kaawaa ena ma mée maamaa eebaa Yesus paagoo kutumeeiikea. Kiya naano agiyoo kiyoo taa yoka Yesus Wa me topenaa see bagee yuwa \"Meei\" asigi. Meemaagea kaboo Wa me asiino, ");
INSERT INTO auu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"Kuwa bagee kuwa okoo unu wedo Ni paagoo niitopea kiya naano agiyoo taa yoka epa nao. ");
INSERT INTO auu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Okoo naadi ma peeweei see asiyu ko okoo eta mana kaa naadi kaa boomagaa taapea. Okoo mée noonaa beesekaa bagee yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wa me topenaa see bagee yuwa me asiino, \"Sooi, nakaayoo ee taa, bugi taa see magaa. Okoo mée eebaa yoka naano agiyoo naano sikii-sikii see kuwa kayoo kaama masiipea?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus me \"Ikii roti magu magoo topa?\" asigi naaki \"Roti magu petoo\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kuwa bagee yuwa \"Animagaai\" see asigi. Kiyoo kaama roti magu petoo to masegeeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Aseta kaama roti kabatagaa naadi Wa me topenaa see bagee yuwa goo-maneeta kaama mée yuwa uduma yawudikomeegea. ");
INSERT INTO auu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Doge imi wiya waa naa miya agoo. Wa me kuwa kaa Ogatamee paagoo kiiboo, paamee see menaa aseta kaama \"Ikii me kuwa miya mée yuwa paagoo eewudii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Okoo uduma naano sikii, bekataa. Kiyoo kaama roti koga opa topa yuwa meeii naadi iduunee ayaa petoo pudii aweamaagea. ");
INSERT INTO auu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kiyoo okoo nota bagee yuwa mée eebaa, empat ribu waa naa. Noomaata kaama Wa me okoo \"Koogo peedaa taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kiyoo kaama Waa ma, Wa me topenaa see bagee yuwa ma epo enaataa koma kaa pakaanta kaama piku asii yaato Dalmanuta wee kaa peeta. ");
INSERT INTO auu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kuwa kaboo da Parisi kaa bagee noonaa meemaata kaama Yesus ma aawisiikea. Okoo me Yesus mee kaasee mée to gaadee taano see naadi kaama asiino, \"Inii Aa mikee kisee Mée ii see kanekeensi naadi agiyoo ena, epoo to wodoo kaama dimi nagii-nagii agiyoo ena mée deeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus me gaagaa see dimii mee ebo kaa asiino, \"Eto mee begaa kaa bagee okoo me Waa mikee kisee Mée ii see kuwa nekeensi naadi dimi nagii-nagii agiyoo naidimetaakea kuwa kaasee kaa ya? Anii mikee kisiino ko: Anii mikee kisee Mée ii see nanekeensi naadi agiyoo mee eto mee begaa kaa bagee yuwa si yaukuwaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aseta kaama bedaa koma kaa pakaanta kaama Wa me topenaa see bagee yuwa ma epo enaataa piku asii yaato peeta. ");
INSERT INTO auu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Okoo pikuu da taa komaa taa peetaaka too Wa me topenaa see bagee yuwa deegea naaki naano agiyoo gaabuu, dogaano taa, roti magu ena too too koma yiba topa. ");
INSERT INTO auu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus me okoo gaamaasi naadi asiino, \"Parisi kaa bagee yuwa ma, Herodes mee ma okoo me ragi yeeyee kuwa ikii gaai, nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kisee asigi naadi kaama okoo me aawegaa taano, \"Mee kaasee menaa? Inii roti dogaano taa naadi mée asigi menaa da yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Okoo dimi abanaakea kuwa Wa me nekeenta kaama asiino, \"Roti dogaano taa menaa mee kaasee kaa aawegaakea ya? Ikii nekeeniino taa ye, ikii dimi ewo ye? Ikii dimi mena eboo ye? ");
INSERT INTO auu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ikii emaa agoo kiya se deegea ye? Ikii apa agoo kiya mena si yeegea ye? Kuwa miyoo taa ukuwaandaa seta yuwa kuwa ikii gaabuu sepea ye? ");
INSERT INTO auu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kuwa roti magu idibii to kuwa Anii kabatagaa naadi kaama mée lima ribu nomea. Noomaata kaama ikii koga topa yuwa meeii naadi iduunee ayaa magoo aweamaamea ya?\" asigi naaki \"Iduunee ayaa gaasi ma wiya\" asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","\"Bedaa kuwa roti magu petoo to kuwa miya Anii kabatagaa naadi mée empat ribu nomea. Noomaata kaama ikii koga topa yuwa meeii naadi iduunee ayaa magoo aweamaamea ya?\" asigi naaki \"Iduunee ayaa petoo\" asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wa me okoo asiino, \"Ikii eto miya se nekeenegea ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus ma, Wa me topenaa see bagee yuwa ma okoo Betsaida magaa kaa peemaaga too ko emaa digiyoo see mée ena agoo naadi Yesus paagoo eemegea. \"Wa kaa yagaa yamagaape ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus me mee mée to yagaa peneata badaa maadoota mée toogee yoo kaama amaa kaa eepeemaata kaama mee mée to emaa masii to kaa dabeedi taakomeeyu. Wa me mee mée to kaa yagaa pe-ekeata kaama asiino, \"Aa agiyoo naa deege ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mee mée to iiyaata kaama asiino, \"Mée yuwa deega kiya piya wodo yuwa peenaaka keenda\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bedaa Yesus me kaagaa ena ma wa me emaa masii to kaa yagaa yamaataagi. Waa emaa wikiinta kaama maamaa iiyaagi naaki emaa diino keago, agiyoo-pagiyoo uduma daamaa deegi. ");
INSERT INTO auu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus me waa asiino, \"Koogo ee kaa pooi kiya amokomee magaa mee kaa metaki se pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kiyoo kaama Yesus ma, Wa me topenaa see bagee yuwa ma peedoota Kaisarea Pilipi magaa kaa. Eta mana kaa Wa me topenaa see bagee yuwa paagoo asiino, \"Mée me Anii maamee see nagaageekea?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Okoo me asiino, \"Mée noonaa me Aa ko uwo mée yatukumeta mée Yohanes boomi mee see kagaageekea, mée noonaa me idukaa nabi Elia mee, mée noonaa me apanaa nabi bagee ena, see kagaageekea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wa me asiino, \"Kiya ikii gaayu ko Anii maamee see nagaagea?\" see asigi. Petrus me asiino, \"Aa ko Ogatamee me Aa ebo toowoose naadi kawigintaata Mée, Ebo Kristus mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wa me okoo omaago ma asiino, \"Anii kisee Mée see kuwa mée ena ma se naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesus me Wa me topenaa see bagee yuwa tupiino see naadi asiino, \"Mée Yogaa mee Yahudi kaa ebo-ebo yuwa ma, imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me Wa kaa ae-wae siyaayaa agiyoo kuwa maamaa yaukuwamaata kaama mée me booyaatagea kuwa gaano pedeo. Kiya wedaagoo to naagoo Waa aya andoo pootagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wa me kuwa menaa awee da kaa eewegagi. Kiya Petrus me Yesus monaa eepeegi. Wa me ego-tago see kaa \"Kisee menaa se wegaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kiya Yesus ikigi pe-maataata Wa me topenaa see bagee apanaa yuwa deeta kaama Petrus ego-tago see kaa asiino, \"Iblis, aa pooi. A me gaage dimii kuwa Ogatamee me dimii se, mée me dimii too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kiyoo kaama Wa me kiyoo topea bagee yuwa ma, Wa me topenaa see bagee yuwa ma okoo uduma \"Meei\" asigi. Wa me okoo asiino, \"Okoo Ni sekaataa nameeno see dimii agoo see bagee kuwa ko okoo me gaata-gaata yuwa too ede see dimii mee wisintaata kaama piya boko ma doowoo see bagee kuwa too Ni sekaataa namiyaa. ");
INSERT INTO auu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kuwa ko okoo ekaato koogo daba toono see naadi umiwoo, toowoo siyaa bagee kuwa usiyaato ko umina pedeo kaatagea. Kiya okoo ekaato ekegataata kaama Anii ma, Ni me doometa menaa ma kuwa napeneata kemaata Ni kaa nabooyaa bagee kuwa okoo usiyaato ko daamaa kaatagea. ");
INSERT INTO auu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Magaa da kaa agiyoo ou see gaawoo siyaa bagee kuwa gaayu ko wa me agiyoo tabaa da eebaa, magaa da kaa se-agiyoo, we-agiyoo uduma epoo mée kiyaayaa miya kiya waa boota kaama umina pedeo kaatagi see kuwa daamaa ye? ");
INSERT INTO auu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Waa umina pedeo kiyaata wodoo bedaa daamaa nakiyaasi naadi maniino agiyoo ena ma agoo ye? ");
INSERT INTO auu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kuwa kisega kuwa ko Mée Yogaa mee Wa me malaikat bagee yuwa ma epo enaataa meetagi naagoo Waataagi me pesee da ma enaataa meetagi, Wa disii to ebo kaatagi. Eto mee begaa kaa Ogatamee ma dimii menaa kuwa ekeata esee pedeo dimii, pedeo menaa kuwa kaa too umiwoo, toowoo see bagee maamaa eebaa. Kuwa bagee yuwa paagoo Anii ma, Ni me menaa ma kuwa kaa ego weda see bagee yuwa gaayu ko Mée Yogaa mee meetagi naagoo Waa miya okoo kaa ego weda kaatagi yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Anii mikee kisiino ko: Nakaayoo topea bagee yuwa noonaa bogaano taa kaa Ogatamee pesee da kaa Wa too ebo mée eetotaaki see kuwa diitagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Unu bedimi omemaata Yesus me Wa me topenaa see bagee yuwa Petrus ma, Yakobus ma, Yohanes ma kuwa wedoo to okoo too eepakadoota maga kutuu to kaa. Pakaamaata kaama deamaagea ko Yesus Waa epoo ena gakademaagi. ");
INSERT INTO auu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wa me dokaa da esee poodee wikiindaaka, magaa da kaa doka wetogeano ipi see bagee miya mee see see poodee da se kiyaayaa. ");
INSERT INTO auu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kuwa kaboo da nabi Elia ma, Musa ma wiya awee da kaa keta kaama Yesus ma mena eewegagea. ");
INSERT INTO auu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petrus me Yesus asiino, \"Ei, Guru, inii nakaayoo epo enaataa kiitoono daamaa yoka kisee Aa ede kiyu ko inii nakaayoo ee peedi wedo kimaatagaanake, Aa taano ena, Musa taano ena, Elia taano ena\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrus me menaa mee ko okoo weda ebo, inii mapea menaa wegaape yoka naadi ewo kaa aii kisee wegagi menaa. ");
INSERT INTO auu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kuwa kaboo da sinu yuwa okoo dagii da kaa esee-takiinega. Sinu uwaa da yibaa taa kaama mena wuu da yeegea. \"Mee ko Ni me esee epa see Yogaa. Wa me menaa too yayeewoo taai\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Taka ena iiyaagea naaki mée taa, Yesus Wa too. ");
INSERT INTO auu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kuyee da kaa kaama esetaaki too Yesus me pesee ma menaa asiino, \"Ikii me deepea-deepea yuwa kuwa mée se asii. Mée Yogaa mee boota kaama aya andoo peeta kaama asii too mée eewegaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Okoo me deepea-deepea yuwa mée eewegaano taa, okoo me too \"Kuwa Waa boota kaama aya andoo poono menaa kuwa kaasee menaa naa ya?\" see koogo aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Okoo me Waa asiino, \"Musa me menaa mée topetaa see bagee okoo me 'Nabi Elia mee keta meetagi' see wegawoo see menaa mee kaasee menaa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wa me asiino, \"Elia wa keta meemaata kaama mée yuwa ipiipii taano see naadi tupiitagi, see wegawoo seta menaa kuwa mikee menaa. Kiya Mée Yogaa mee kaa yaebeamaata menaa kuwa kaasee? Waa maamaa boodi, ae-wae segee taatagi, bedaa mée me Waa daba, peedi ekee segee taatagea, see menaa kuwa ebeamaata, se maa? ");
INSERT INTO auu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kiya Ani me kisiino ko: Elia mee mikee meemaami kiya mée me okoo me gaata-gaata dimii kaa waa otoopa taagea. Idukaa Ogatamee me menaa yiba wa kaa kisee yaukuwaatagea see ebeamaata see see okoo me wa kaa yaukuwamea, see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus ma, Wa me topenaa see bagee wedoo to ma okoo kuwa apanaa topenaa see bagee yuwa paagoo eseemaata kaama deamaagi too ko mée eebaa topea. Musa me menaa mée topetaa see bagee yuwa okoo Wa me topenaa see bagee yuwa ma omaago ma mena aawegaa taakea, mée eebaa miya okoo bobetaata yiitookea. ");
INSERT INTO auu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kuwa mée tabaa da okoo me Yesus deeta kaama dimi nagimegea. Okoo yiibaga peedoota Wa paagoo peemaata kaama epao see asegea. ");
INSERT INTO auu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wa me okoo asiino, \"Ikii mapea menaa okoo ma aawegaakea ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Okoo mée waa ena me asiino, \"Guru, wae. Niyoopaa mee paa agoo naadi kaama A paagoo eemega. Paa mee me waa mena wegaano naka. ");
INSERT INTO auu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Paa tawayaa kaboo paa me waa magaa to kaa sepegeata kaama waa dabeedi epogee uditaa, ego dakagetaa, maa da uduma miya eboo keepeasiyaa, kisee too koo segeeki. Anii A me topenaa see bagee yuwa paagoo \"Paa yaabagaapeasii\" see asega kiya okoo iyo, se ukuwamaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus me okoo asiino, \"Yaai, ikii mikee gaano dimii taa see bagee yuwa nao. Anii ikii ma eebaa kiiompa kiya Anii bedaa unu magoo kisee too dimi apaanta ikii ma kiiomegee taapa naa ya? Mee yogaa to mee nadoomeei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yogaa to Wa paagoo badaa maadoo megea. Paa me Yesus deeta kaama mee yogaa to totomo yasiyaagi naaki yogaa to maga kaa esee-gapuunta me-gapine, pe-gapine taaki, dabeedi epogee uditaaki. ");
INSERT INTO auu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus me nagamee asiino, \"Mee agiyoo meanta kaama unu magoo ompea?\" asigi naaki \"Waa peedi kaa kaama kisee too meanee segeeki. ");
INSERT INTO auu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Paa me waa pedeo kiyaano see naadi kaagaa eebaa waa biyaa yiba peeyaayu, uwo yiba miya eseaniyaayu, kisee too koo segeeki. Kiya A me yataa kiyaayaa agiyoo ena yaukuwamaayaa kepa ko epa mée gaai, yataa kiyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus me asiino, \"A me nasiino, 'A me yaukuwamaayaa kepa ko' see nasege mee kaasee menaa ya? Mikee nao see gaayaa bagee yuwa okoo kaa yaukuwaaniyaano iyo see agiyoo mee ena ma taa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nagamee me mena ebo kaa asiino, \"Anii mikee nao see kagaaga. Ni me mikee gaano dimii mee ebo nakiyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kuwa kaboo da Yesus me deamaagi too ko mée eebaa Wa paagoo me-yigimeeiikea yoka Wa me mee paa da peesi naadi omaago ma asiino, \"Aa paa aa, mée mena wegaano naka, mena yiino naka see yakiyaabuu see paa aa mee yogaa to kaa kaama pooi. Eto kaama wodoo wa yiba se seemaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kisee asigi naaki mee paa me ebo menaa-menaa kaa yogaa to maamaa totomo yasiyaata kaama peegi. Mee yogaa to mee bootaa da mokoo keepeasigi. Mée eebaa me \"Waa boogi yoka\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kiya Yesus me mee yogaa to yagaa peneata yagaataagi naaki yiinaageeta daamaa totaaki. ");
INSERT INTO auu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesus ma, Wa me topenaa see bagee yuwa ma okoo ee ena yiba seemeta kaama okoo too toomuu taakea kaboo okoo me Waa asiino, \"Inii me paa pooi see asiyaa naaki se peega kuwa kaasee kaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wa me asiino, \"Mee paa tomaa da mee gaayu ko sembahyang see kaa too abagaapeasiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kiyoo kaama Yesus ma, Wa me topenaa see bagee yuwa ma okoo Galilea wee kaa peetaaka too Yesus Waa tupi yoo mée me ipi see kuwa Waa be. ");
INSERT INTO auu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Wa me topenaa see bagee yuwa tupitaaki yoka okoo too see kuwa Waa ede. Wa me okoo asiino, \"Mée Yogaa mee omaago see bagee paagoo yaekegatagaapea. Yaekegataata kaama booyaapea. Booyaata kaama wedaagoo to naagoo aya andoo pootagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kiya okoo mee menaa se nekeenegea. Okoo me \"Kuwa menaa da kaasee? Mée asii\" see asiino kuwa wedaagea. ");
INSERT INTO auu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Muguu naadi Kapernaum magaa kaa peemaayu. Ee yiba seemeta kaama Yesus me Wa me topenaa see bagee yuwa asiino, \"Ikii yumakaa eta mana kaa aawegaa sepea menaa kuwa mapea menaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kiya okoo koogo togea. Yumakaa eta mana kaa okoo me inii maamee naa ebo bagee kepa naadi kaama \"Aa naa ebo ye, nii naa ebo ye?\" kisee aawegaa sepea yoka okoo me mena ena ma asiino taa. ");
INSERT INTO auu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus mee animaata kaama Wa me topenaa see bagee yuwa \"Meei\" see asigi. Wa me okoo asiino, \"Ebo bagee kaano see dimii gaayaa bagee kuwa ko okoo ekaato esee peedi kiyaano gaano pedeo, apanaa bagee okoo uduma ebo yoka naadi okoo me agiyoo aii yaokagee see bagee mokoo kaano gaano pedeo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kiyoo kaama Waa yoga peedi ena yaageeta kaama okoo yupii da taa tuyaata eke. Wa me mee yoga peedii to yagaa bokaageeta kaama okoo asiino, ");
INSERT INTO auu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"Mee see see yoga peedii to Ni ekaa yiba daamaa badaa maayaa bagee kuwa Anii miya daamaa badaa namaayaa mokoo. Bedaa Anii miya daamaa badaa namaayaa kuwa Anii naisiyaata Mée Waa miya daamaa badaa maayaa mokoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kuwa kaboo da Yohanes me Yesus asiino, \"Guru, yumakaa mée ena me paa yaabagaapeasiino see naadi A ekaa da kaweepi see kuwa inii deepe. Waa inii sekaataa see mée se yoka inii me 'Aa kisee se ukuwaai' see asege\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kiya Yesus me asiino, \"Waa se taamege-taamege taai. Mée waa ena me Ni ekaa yiba dimi nagii-nagii agiyoo ukuwamaata kaama wodoo wa me pedeo menaa Ni kaa nawegaano ko iyo. ");
INSERT INTO auu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kisee inii mée se wisiniyaa bagee kuwa okoo inii yaato bagee yoka okoo se taamege-taamege taai. ");
INSERT INTO auu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Anii mikee kisiino ko: Mée me ikii Ebo Kristus sekaataa poono bagee kemaata uwo peenaa too miya nusi naadi kineeyaa bagee kuwa taa ma taa daamaa agiyoo ukuwataa to mokoo da masiitagea, see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Bedaa Yesus me asiino, \"Yoga me dimii masiyaa bagee kuwa Anii mikee nagaayaa bagee okoo mée waa ena too too miya mée me deebaa naadi kaama waa pedeo agiyoo ukuwayu ko mee deebaa sipi mée to yaai. Waa kaakaa da taa ebo omaa gadeata maakaa piku yiba tamekumiino daamaa. ");
INSERT INTO auu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","A me yagaa da me pedeo agiyoo ukuwayu ko daapeasii. Aa kisee too umiwoo, toowoo taa see yoo seemaano ko yagaa naayaato taa see seemaano miya daamaa. Kiya aa yagaa wiya ma se modeemaayaa see biyaa neraka yiba katameamaatagi kuwa pedeo. ");
INSERT INTO auu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kiyoo ko pepese miya se booyaa, biyaa miya se deeyaa. ");
INSERT INTO auu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A me badoo da me pedeo agiyoo ukuwayu ko daapeasii. Aa kisee too umiwoo, toowoo taa see yoo seemaano ko bado naayaato taa see seemaano miya daamaa. Aa bado wiya ma neraka biyaa yiba katameamaatagi kuwa pedeo. ");
INSERT INTO auu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kiyoo ko pepese miya se booyaa, biyaa miya se deeyaa. ");
INSERT INTO auu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bedaa a me emaa mee me pedeo agiyoo ukuwayu ko bigimeepeasii. Aa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko emaa keepa naayaato taa see seemaano miya daamaa. Kiya aa emaa keepa ekea paaya neraka biyaa yiba katameamaatagi kuwa pedeo. ");
INSERT INTO auu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kiyoo ko pepese miya se booyaa, biyaa miya se deeyaa. ");
INSERT INTO auu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ani me kuwa kisega menaa kuwa ko dega sigimiyaa mokoo mée uduma kaa miya biyaa sigimeamaapea. ");
INSERT INTO auu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dega mee ko daamaa agiyoo kiya dega gii taa keegoota kaama wodoo kaasee bedaa gii kiyaayaa? Iyo. Ikii dimi yiba dega agoo see bagee mokoo daamaa dimii kaa umiwoo, toowoo taai, bedaa ikii aaemee-emee see dimii kaa umiwoo, toowoo taai.\" ");
INSERT INTO auu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kiyoo kaama Yesus mee peedoota Yordan dee kaa uwaasii yaato Yudea wee kaa peemaata kaama mée eebaa Wa paagoo yigimeeiikea. Wa me okoo mena daamaa topetaa, Wa me ukuwageeki see see. ");
INSERT INTO auu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kuwa kaboo da Parisi kaa bagee yuwa noonaa Wa paagoo meemaagea. Yesus me koopoo see menaa wegasi naadi okoo me Waa apaadiino, \"Api ekeasiino kuwa naa dagu ye, daa ye? Aa kaasee gaage?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wa me okoo asiino, \"Idukaa Musa me ikii mapea menaa kiseta ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Okoo me asiino, \"Musa me menaa mee ko kisee: 'Apimee ekeasiino see gaayu ko api ekeasiino kapogee mee keta apimee ebea-maneeta kaama ekeasiyaa' see menaa da ebeamaata\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus me asiino, \"Musa me api ekeasiyaa menaa mee ko ikii dimi pesee, se kitupimaayaa bagee yuwa kemaata kaama api ekeasiino ko ekeasiyaa, see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kiya petamanii mée tomaa ogaataata naagoo kaama kisee api ekeasiino menaa mee taa. Idukaa ebeamaata menaa mee ko kisee: 'Ogatamee me paayogaa ma, api ma ogaataata. ");
INSERT INTO auu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kuwa me kemaata paayogaa gakata waataagi ma, wabaayo ma kuwa ekeata kaama ");
INSERT INTO auu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","wa me goeyaa apii to ma ekea bogaa má ena too too mokoo kiyaa, kisee too umiwoo, toowoo siyaa' see menaa ebeamaata. Mee kaama wodoo ekea bogaa dimi ena-ena see se kiya dimi ena too too see kiyaa. ");
INSERT INTO auu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kisee kemaata Ogatamee me ena too too kiyaata agiyoo kuwa mée me aapataga see se siyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Peedoota ee yiba pakaanta kaama Wa me topenaa see bagee yuwa me Wa paagoo \"Kuwa menaa kuwa kaasee, mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wa me okoo asiino, \"Paimee me apimee ekeata kaama apanaa apii goeyu ko waa tobaaka taakee mée to kiyaa. ");
INSERT INTO auu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bedaa apimee miya wa me pai to ekeata kaama apanaa bagee ena kaa peeyu ko waa miya tobaaka taakee apii kiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kuwa kaboo da yoga peedi yuwa Yesus me okoo kaa yagaa daamaa yamaasi naadi Wa paagoo eemegea. Kiya Wa me topenaa see bagee yuwa me kuwa bagee yuwa kagoo kaa \"Yaai, kisee se\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kiya Yesus me kisee deeta kaama kagoo kaa Wa me topenaa see bagee yuwa asiino, \"Kuwa yogaa yuwa Ni paagoo daba misi yoka si yawasii. Okoo kuwa see see yoga me dimii masetaa see bagee kuwa okoo Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa eetuyaa bagee yuwa yoka okoo Ni paagoo daamaa miyaai. ");
INSERT INTO auu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anii mikee kisiino ko: Okoo Ogatamee Wa too ebo mée eetupi nao naadi kaama yoga me dimii, yoga me menaa kuwa se masiyaa bagee kuwa ko okoo taa ma taa Ogatamee Wa too ebo mée eetotaa see yoo se seemiyaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aseta kaama kuwa yoga peedi yuwa kaa yagaa bokaageeta kaama daamaa agiyoo yaukuwaaniyaasi naadi okoo kaa yagaa yamaatayu. ");
INSERT INTO auu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus mee eta poono see koo taaki too ko mée ena yiibaga Yesus paagoo kagu maga kaa sebaata kaama asiino, \"Ei, Guru daamaa see Mée. Anii iminoo miya, iminoo miya kisee too toowoosi naadi ukuwayaa agiyoo naa maagiyoo ukuwayaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus me asiino, \"Aa daamaa see Mée see menaa mee kaasee kaa nasege? Mikee daamaa see Mée mee ko Ogatamee Wa too, kaama taa. ");
INSERT INTO auu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A me 'Anii maagiyoo ukuwayaa naa ya?' see nasege mee ko Ogatamee me menaa kuwa aa miya ipi. Kuwa ko 'Ikii tobaaka se taai, mée se wugii, oma se masii, kobaakee menaa si yakobaai, mée deebaa naadi oma si yanaai, okonaka ebo ekeasii' kisee menaa kuwa aa miya ipi yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mee mée to me asiino, \"Kuwa menaa kuwa uduma anii peedi kaa kaama daamaa ipiipi deewoo segeeka yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus me waa maamaa pe-deeta kaama epa dimii kaa asiino, \"A me ukuwaano gaano pedeo agiyoo ena ma topa. Mee ko a me agiyoo yuwa uduma pe-doogeeta kaama masiipe kepee yuwa daba bagee aii manii. Aa kisee ukuwamaata kaama epoo to wodoo agiyoo yuwa kaagoo kiyaata kaama kisee too masiwoo siyaa. A me kepee kuwa uduma wudikomeeta kaama Ni sekaataa nameei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kiya mee mée to kuwa menaa yeeta kaama dimi nagimigi. Wa me agiyoo tabaa da eebaa kemaata dimi gaagaa ebo kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus Wa gebo Wa me topenaa see bagee yuwa iiyaga-yaga naadi kaama asiino, \"Kepe yago bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko esee kana\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wa me topenaa see bagee yuwa kuwa menaa yeeta kaama dimi nagimegea. Kiya bedaa Wa me okoo asiino, \"Kepe yago bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko esee kana. ");
INSERT INTO auu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Unta wodaa mee abi tokogoo da yibaa taa mikee pakaa-seomiyaa kiya kepe yago bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko kana\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wa me topenaa see bagee yuwa kuwa menaa da esee dimi nagimaakee kaa asiino, \"Kepe yago bagee kuwa daba daagimaa poono kana kiyu ko maamee naa daba daagimaa peeyaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wa me okoo maamaa pe-deeta kaama asiino, \"Mée daba daagimaa poono mee ko mée me se ukuwamaayaa agiyoo kiya Ogatamee me ko kisee iyo see taa. Wa me too uduma agiyoo uduma ukuwamaayaa see Mée yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petrus me asiino, \"Inii me agiyoo-pagiyoo uduma ekeata kaama A sekaataa metaake kuwa Aa mée deege\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Wa me okoo asiino, \"Anii mikee kisiino ko: Okoo Anii ma, Ni me doometa menaa ma kuwa kaa okoo me ee, okoo ma kenaa bagee yuwa, okooto, nagamee, yogaanii yuwa, bugi, kisee ekeata bagee kuwa ");
INSERT INTO auu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","okoo eto mee begaa kaa miya okoo me kuwa ekeata yuwa bedaa apanaa miya esee maamaa eebaa masegee taapea. Kuwa ko ee yuwa, okoo ma kenaa bagee yuwa, oko yuwa, yogaanii yuwa, bugi, kuwa uduma maamaa masiipea. Bedaa mée me okoo wegee-wegee naadi ae-wae siyaa agiyoo kuwa miya masiipea. Bedaa kaama mee begaa kaa miya iminoo miya, iminoo miya kisee too umiwoo, toowoo taatagea. ");
INSERT INTO auu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kiya eto kiipaa ebo kiyaa bagee mée eebaa kuwa iminookaa yaato peedi kedaa taatagea, bedaa eto kiipaa peedi kiyaa bagee mée eebaa kuwa iminookaa yaato ebo kedaa taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus ma, Wa me topenaa see bagee yuwa ma Yerusalem magaa kaa peetaaka too Yesus mee Wa keta, apanaa yuwa uuto. Wa me topenaa see bagee yuwa dimi gaagaa ebo, apanaa obeetaakea bagee yuwa okoo miya wedaagea. Wa me topenaa see bagee gaasi ma wiyaa to okoo too peenaa eepeanta kaama Wa kaa ukuwaaniita menaa kuwa ase-maneegi, mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","\"Ikii daamaa nayii. Inii Yerusalem magaa kaa pakataakea. Pakaamaata kaama wodoo Mée Yogaa mee imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo paagoo mée me yaekegatagaapea. Ekegataata kaama 'Waa bogaano gaano pedeo' see menaa yadaakumiipea. Kiyoo kaama apanaa tomaa kaa bagee paagoo yaekegatagaapea. ");
INSERT INTO auu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Okoo me Waa wisineekee menaa wisineapea, dabeedi taaii taapea, pepeaduu me dakameamoo taapea. Dakameamoo semaata booyaapea kiya wedaagoo to naagoo aya andoo pootagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kuwa kaboo da Zebedeus me yogaa Yakobus ma, Yohanes ma wiya Yesus paagoo megea. Ekea me asiino, \"Guru, enaa me kasiinake menaa mee A me enaa mée yaukuwase naadi mege\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus me asiino, \"Ekea me kisee mée yaukuwaano ede see gaayaa agiyoo mee maagiyoo naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ekea me asiino, \"A me asii-sege ebo mée eetoowoo siyaa yoo kiyoo enaa A geboo da kaa mée animaayaai. Ena mee A me dagi yagaa yaato mée ekeasii, ena mee eka yagaa yaato mée ekeasii, see kaidimege\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus me ekea asiino, \"Ekea me naidimegea kuwa dimi ipiipi see gaamagaano taa kaa naidimegea. Anii boodi abaano gaano pedeo, boodi abaakee uwoo otaawee yiba kaama nuyaa mokoo see see yoka Anii miya naapa mokoo ekea miya nuyaa ye? Bedaa uwo tukumiyaa mokoo Anii ae-wae siyaa agiyoo yiba tukumaapa. Anii kisee tukumaapa mokoo ekea miya tukumiyaa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ekea me asiino, \"Mikee, enaa miya kisee ukuwayaa\" see asegea. Yesus me asiino, \"Mikee, Ani me naapa see see ekea miya naapea, bedaa Anii tukumaapa see see ekea miya tukumaapea, kisee ae-wae taapea. ");
INSERT INTO auu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kiya Ni me dagi yagaa yaato 'Aa', bedaa eka yagaa yaato 'Waa' see asiyaa kuwa Ni me se asiyaa. Neataagi me too kuwa asiitagi bagee yuwa kiyoo ebo tuyaatagi keekee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wa me topenaa see bagee apanaa gaasi yuwa me Yakobus ma, Yohanes ma ekea kaasee menaa idimegea naadi kagoo kegea. ");
INSERT INTO auu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus me Wa me topenaa see bagee yuwa \"Uduma meei\" asigi. Wa me okoo asiino, \"Apanaa tomaa kaa bagee yuwa okoo me eboo yuwa gaayu ko dimi mena pesee, okoo anii ebo yoka naadi omaago ma ebo totaa see bagee yuwa, see kuwa ikii miya ipi. ");
INSERT INTO auu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Okoo kisee bagee kiya ikii gaayu ko kisee dimii se masii. Ikii yupii ebo kaano see dimii gaayaa bagee kuwa ko ikii yupii daba bagee me agiyoo aii yaukuwaai, ");
INSERT INTO auu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","bedaa ikii yupii ekaa pege-pege see mée kaano see dimii gaayaa bagee kuwa ko ikii uduma paagoo ikii me kana see agiyoo aii kiokagee siyaa mée to mee see see kaai. ");
INSERT INTO auu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mée Yogaa mee miya kisee. Anii meta mee ko 'Ni me agiyoo naukuwaai' see aseekee mée kaano see naadi se kiya 'Ni me kana see agiyoo naukuwaai' see yayeekee mée mokoo kaano see naadi meta. Kuwa ko Anii ekaato ekegataata mée kaa yaboogiino see naadi meta, bedaa mée eebaa okoo Ogatamee ma menaa kuwa yataa kiyaata daba daagimaa peeyaano see naadi meta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Muguu naadi Yesus ma, Wa me topenaa see bagee yuwa ma Yeriko magaa kaa peemaayu. Toomuu naadi kaama Yeriko magaa kaa ekeata apanaa magaa kaa poono see kaboo mée eebaa okoo sekaataa peegea. Peetaaka too ko eta geboo da kaa kepe idimetaa see mée ena animaata tupi, emaa digiyoo see mée ekaa da ko Bartimeus, Timeus yoopaa mee. ");
INSERT INTO auu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kiyoo topea bagee yuwa me \"Nazaret magaa kaa Mée Yesus mee amoo-segeki\" see wegagea menaa kuwa wa me yeeta kaama ebo menaa-menaa kaa \"Yesus, Daud ma apaa kaa Mée Aa epa nagaai, epa nagaai\" see aseamooki. ");
INSERT INTO auu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kiyoo topea bagee yuwa mée eebaa kagoo kaa \"Aa koogo tooi\" asegea kiya waa bedaa maamaa mena ugigi. \"Daud ma apaa kaa Mée, epa nagaai, epa nagaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus mee kiyoo tuguunta kaama \"Mee mée to mena naogaai\" see asigi. Mee emaa digiyoo see mée to mena ogegea. \"Ei, dimi se nagimaai, mena kaogetaaki yoka mani anoogii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wa me tapaato dokaa da beamaata kaama moga anoogeeta Yesus paagoo peegi. ");
INSERT INTO auu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus me waa asiino, \"Aa maagiyoo naidimege?\" see asigi naaki \"Guru, anii emaa diino keago see ede\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus me asiino, \"A me mikee nagaano dimii mee me aa emaa daamaa kege, daba daagimaa peege\" see asigi naaki taka ena emaa awee keepeata kaama kisee ki Wa sekaataa etaawee peegi. ");
INSERT INTO auu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus ma, Wa me topenaa see bagee yuwa ma okoo Yerusalem geboo da kaa magaa wiya kaa pakaamaayu, Zaitun Kutuu to kaa kiyoo Betpage see magaa ma, Betania see magaa ma wiya kaa. Kiyoo pakaamaata kaama Yesus me Wa me topenaa see bagee mée ekea wiya asiino, ");
INSERT INTO auu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","\"Peedoota nakaayoo doodoo magaa kaa peemaata kaama keledai wodaa pooduu ena, mee wodaa da dagii da kaa mée me animaata toodiino taa see wodaa ena ekea diipea. Mee wodaa ope gokataata kaama Ni paagoo nadoomeei. ");
INSERT INTO auu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","'Kaasee ope nagokataagea ya?' see kisiyaa bagee agoo kepa ko 'Tuhan me gaano pedeo. Woda mee bedaa nakaayoo badaa maadoota doomeepea see kasigi' see naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ekea peedoota kaama peemaagea naaki mikee, keledai wodaa poodu ena eta geboo da kaa ee ena kaa kenee to kaa opeemaata topa. ");
INSERT INTO auu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ope gokataagea kaboo kiyoo topea bagee me asiino, \"Kaasee kaa ope gokataagea ya?\" asegea naaki ");
INSERT INTO auu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesus me asigi-asigi see asegea. Asegea naadi \"Daamaa, dogaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Keledai wodaa pooduu to doodoota Yesus paagoo eemegea. Okoo me tapaato dokaa yuwa mee keledai wodaa dagii da kaa sekeetaata kaama Yesus mee wodaa dagii da kaa animaayu. ");
INSERT INTO auu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yerusalem magaa kaa peegee see etaawee mée eebaa okoo me tapaato dokaa yuwa beagee naadi etaawee daamaa yasekeepegeekea, mée noonaa me piya ukuu yuwa taageeta kaama etaawee daamaa yamagapegeekea. ");
INSERT INTO auu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Okoo keta peetaakea bagee yuwa ma, uuto peetaakea bagee yuwa ma kuwa ebo menaa-menaa kaa \"Hosana, Tuhan ekaa yadoopi Mée mee migi yoka niiyaapaagee taai! ");
INSERT INTO auu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Idukaa Daud mee ebo mée eetoogee seta see see eto miya inii paagoo ebo mée eetoowoo taapi Mée mee magiyaage! Hosana, Asii-sege see Mée mee niiyaapaagee taai!\" see wegapegeekea. ");
INSERT INTO auu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus Waa Yerusalem magaa kaa pakaamaata kaama peedoota Ogatamee me ee kaa kiyoo peemaata deenaa, peenaa naadi kaama uwaapeasega yoka Wa me topenaa see bagee yuwa ma epo enaataa Betania magaa kaa peegea. ");
INSERT INTO auu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Betania magaa kaa omegeeta kaama tokoma mee da Yesus mee pakadoota Yerusalem magaa kaa eta mana kaa naano agiyoo naadi kaa. ");
INSERT INTO auu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Deamaagi too ko ara see piya wodo ena kiyoo agoo. Poo agoo ye, taa ye naadi peedoota piya manii da kaa peemaata kaama deeyaa naaki poo ota peedi ena ma ekaano taa. Ara piya poo ekaano uwaa kaa pakaamagaano taa kaboo yoka iye too agoo. ");
INSERT INTO auu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wa me mee piya wodoo to asigi menaa ko \"Eto kaama wodoo poo ota ena ma se ekaape, a me poo yuwa kuwa mée me se kanaapea\" see asigi. Wa me topenaa see bagee yuwa miya kuwa menaa yeegea. ");
INSERT INTO auu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Okoo Yerusalem magaa kaa pakaamaata kaama Yesus mee peedoota Ogatamee me ee kaa peemaata kaama ee geboo da kaa kiyoo agiyoo pe-doogee taa see bagee uduma abagakomeeyu. Kepe aapeka taa see bagee yuwa ma, poodee see bedoo pe-doogee taa see bagee yuwa ma okoo me keagee yuwa yagepeepi-paapi semaata eke. ");
INSERT INTO auu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Okoo me kisee agiyoo kuwa ena ma Ogatamee me ee geboo da taa kitaa se dogaai naadi omaago ma asigi. ");
INSERT INTO auu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wa me okoo tupiyaa menaa asiino, \"Ogatamee me ebeamaata menaa ena mee ko kisee: 'Ni me ee mee ko mée tomaa-tomaa uduma sembahyang taa see ee see ekaa weewoo taapea' see menaa ebeamaata, se maa? Kiya ikii me ko oma masetaa see bagee totaa see yoo mokoo yakiyaagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Imam bagee me eboo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo Yesus me ukuwapi-ukuwapi yuwa yeeta kaama Waa patamaano see dimii agoo kegea. Kiya mée eebaa Wa me topeta menaa kuwa ebo nao naadi dimi nagimegea kuwa me kuwa ebo-ebo yuwa me Yesus wedaagea. \"Waa kaasee wogeekee, kaasee patamaakee\" see menaa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Uwaataa da ayayaa takiinega see kaboo Yesus ma, Wa me topenaa see bagee yuwa ma mee kota magaa mee ekeata gebo kaa magaa ena kaa peegea. ");
INSERT INTO auu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tokoma mee da pedeo tokomaa Yesus ma, Wa me topenaa see bagee yuwa ma eta peetaaka too deeyaa naaki mee ara piya wodoo to mee mani kaa kaama uduma wii keepeasega. ");
INSERT INTO auu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus me nekeenta kaama Yesus asiino, \"Guru, mee ara piya wodoo to mee deede. A me pedeo kisi naadi menaa aseme mee me wii keepeasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus me okoo asiino, \"Ogatamee mee mikee gaai. ");
INSERT INTO auu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Anii mikee kisiino ko: Mée waa ena me waa dimi wiya taa kaa 'Mee maga bagoo to mee bikimedoota maakaa piku yiba tamekumii' see asiyu ko kiyoo tamekomeeyaa. Wa me 'Ni me wegaga menaa mee mikee ukuwaaniipa ii' see gaapi ko daamaa yaukuwaaniyaayaa. ");
INSERT INTO auu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kisee kemaata Ani me kisiino ko: Ikii me sembahyang menaa kaa idimiyaa agiyoo kuwa 'Ni kaa naukuwaaniyaagi ii' see gaai, ikii kaa daamaa kiukuwaaniyaapi. ");
INSERT INTO auu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ikii yiinaageeta sembahyang taa see kaboo ikii apanaa bagee ena ma mena agoo kiyu ko epa yaekeasii. Epoo to wodoo Ikiitaagi me miya ikii me pedeo yuwa epa kiekeasi naadi mée me pedeo yuwa epa yaekeasii. ");
INSERT INTO auu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kiya ikii me okoo me pedeo yuwa epa si yaekeasiyu ko epoo to wodoo Ikiitaagi me miya ikii me pedeo yuwa epa se kiekeasiipi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus ma, Wa me topenaa see bagee yuwa ma peedoota Yerusalem magaa kaa peemaata kaama Ogatamee me ee geboo da taa peenaaka too ko imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo Wa paagoo meemaagea. ");
INSERT INTO auu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Okoo me asiino, \"Yaai, A me ukuwanaa see agiyoo kuwa ko maamee me 'Aa kisee naukuwaai' see kaseta kaama ukuwanaa segeeke? Maamee me Aa ebo kaekeata kaama ukuwanaa segeeke?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus me asiino, \"Ani me miya ikii kiapaadee taanaka. Ikii me miya Anii mena daamaa nasegea kepa ko ikii me 'Maamee me kaseta kaama A me kisee agiyoo ukuwanaa segeeke?' see naapaadeekea menaa mee Anii miya daamaa kisiipa. ");
INSERT INTO auu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ni me kiapaadee see menaa mee ko kisee: Uwo mée yatukumeta mée Yohanes mee gaayu ko wa paagoo 'A me mée yuwa uwo natukumaai' see menaa kuwa maamee me aseta menaa naa ya? Epoo to wodoo kaama Ogatamee me aseta menaa da ye? Aii mée me aseta menaa da ye? Kaasee? Nasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Okoo too koogo aawegaa taano, \"Yaai, inii Waa kaasee menaa asiipea? Inii me 'Epoo to wodoo kaama Ogatamee me aseta menaa yoka' see asiyu ko Yesus me mée asiipi menaa ko 'Mikee yoka ikii kaasee kaa Yohanes me weganaa seta menaa kuwa mikee nao see gaano taa ya?' see mée asiipi. ");
INSERT INTO auu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bedaa inii me 'Ogatamee me Yohanes aseta menaa se, aii bagee me aseta menaa' see asiino miya iyo\" see aawegaakea. Okoo me kisee aawegaakea menaa kuwa ko okoo me mée yuwa me \"Yohanes mee nabi bagee eboo yoka ikii kaasee kisee pedeo menaa wa kaa yawegagea ya?\" see mée asiipea yaai naadi aawegaakea menaa kuwa. ");
INSERT INTO auu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Okoo me kuwa menaa aawegaa semaata kaama Yesus asiino, \"Yohanes paagoo maamee me aseta menaa see kuwa inii ewo keekee\" see asegea. Yesus me asiino, \"Ikii me daamaa nasiino taa yoka Ani me miya ikii me 'Maamee me Aa kaseta kaama A me kisee agiyoo ukuwanaa segeeke?' see nasegea menaa kuwa se kisiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus me ebea-ebea menaa kaa okoo asiino, \"Bugi epoo mée anggur poo bugii ena yaatayu. Yaataata kaama wagee uduma aanakitayu. Mee bugii kaa oma ena, ebo omaa masegeeta oma togaawee anggur poo tagimemaata uwo yuwa kitaa isisi naadi denemaata eke, bedaa bugii da diitoo taa see ee miya maatayu. Maataata kaama apanaa bagee me bugi nayaagee segeesi naadi yaekeata kaama apanaa magaa kaa peegi. ");
INSERT INTO auu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Maamaa omegee naadi kaama kuwa poo yuwa kapoo kega kaboo bugi epoo mée me wa paagoo agiyoo yaokagee see bagee ena asiino, 'Aa peedoota ni me bugii nayaagee see bagee yuwa paagoo ni me see yuwa namasigii' see asigi. Peedoota bugi kaa peemaagi naaki ");
INSERT INTO auu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","bugi yayaagee see bagee yuwa me waa peneata kaama aii dakamegea. Okoo me bugi epoo mée me see yuwa se manegea naadi bedaa metaki peegi. ");
INSERT INTO auu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mee asii kaawaa ena ma wa me agiyoo yaokagee see bagee ena ma peeyaagi kiya bedaa okoo me kisee mumoo to kaa dakamegea, badeekee menaa badegea. ");
INSERT INTO auu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bedaa wa me agiyoo yaokagee see bagee ena ma peeyaagi kiya okoo me waa wogeepeasegea. Kisee wa me apanaa bagee miya peeyaabuu segeeki kiya okoo me mée noonaa aii dakamegea, noonaa wogeepeasegea. ");
INSERT INTO auu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kaama too bugi epoo mée wa paagoo mée ena too too tupi, wayoopaa mee. Wa me gaano, 'Niyoopaa yoka Wa me menaa kuwa okoo me daamaa yayiipea' see gaata kaama 'Pooi' asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kiya okoo me waa migi see deeta kaama koogo aawegaa taano, 'Mee ko yogamee. Nagamee me bugii da mee yogamee me masiitagi yoka niiwogeepeasii, wa me bugii da inii takeasiino ke' see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Waa meemaata kaama okoo me waa peneata patamegea. Patamemaata kaama bootaa da wagee amoo yaato tameeyamaagea, see koo seta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bedaa Yesus me asiino, \"Mee bugi epoo mée me maagiyoo ukuwaapi? Waa meemaata kaama kuwa wa me bugii yayaagee see bagee yuwa pedeo kiyaapi. Pedeo kiyaata kaama mee bugii da apanaa bagee me daamaa nayagageesi naadi yaekeasiipi. ");
INSERT INTO auu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ogatamee me ebeamaata menaa ena mee daamaa nekeenii. Mee ko kisee: 'Oma ee maataa see bagee yuwa me be kaa wisintaata tameepeata omaa mee ko TUHAN me masegeeta kaama tuku omaa to mee daamaa pee-yaekeata. ");
INSERT INTO auu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ekeata kaama inii me TUHAN, kiiboo nao naadi yaapaagee seta' see ebeamaata menaa kuwa ikii diino taa, ewo ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yahudi kaa ebo-ebo yuwa me kuwa ebea-ebea menaa yuwa yeemaata kaama okoo 'Wa me inii mée gaataata kaama mée asigi menaa ii' see kuwa nekeenegea. Kagoo kaa Yesus peneasiino see dimii agoo kiya mée yuwa me mée kagoo kaapea yoka naadi Waa peneasiino kuwa wedaagea. Kisee gaata kaama Waa yaekeata peegea. ");
INSERT INTO auu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kuwa kaboo da Yahudi kaa ebo-ebo yuwa me Yesus mee koopoo see menaa wegasi naadi Parisi kaa bagee noonaa ma, Herodes yaato bagee noonaa ma kuwa wiginegeeta kaama \"Yesus paagoo pooi\" asegea. ");
INSERT INTO auu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Okoo Wa paagoo peemaata kaama asiino, \"Aa ko dimi topoo see Mée to ii see kagaage, bedaa Ogatamee me etaa yaato menaa mée tupiino kuwa miya A me daamaa topoo see menaa kaa too mée topetaa see Mée to ii kagaage. A me mée tupiino kuwa mée me kakagoo kiyaa miya mée tupiino too, bedaa ebo bagee me menaa miya Aa weda taa kaa mikee menaa too topenaa segeeke kuwa inii kaipi yoka inii kaapaadee see menaa ena agoo. Mee ko inii pajak kepee Kaisar maniino kuwa dagu ye, taa ye? Waa maneekee daamaa ye, pedeo ye? Aa kaasee gaage?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kiya Yesus me okoo me daamaa poga-poga dimii mee yadeemaata kaama asiino, \"Yaai, kaasee ikii me Anii nadeebaa taano see naadi nasegea menaa naa ya? Pose kepee ena nadoomeei, diinaka yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Doomaagea kaboo Yesus me asiino, \"Mee kepee mee kaa maamee ebeyumaa da, maamee ekaa da ebeamaata naa ya?\" asigi naaki \"Kaisar mee\" asegea. ");
INSERT INTO auu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesus me asiino, \"Kisee gaayu ko Kaisar maniino agiyoo yuwa kuwa Kaisar manii, bedaa Ogatamee maniino agiyoo yuwa kuwa Ogatamee manii\" see asigi. Wa me asigi menaa da okoo dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kuwa kaboo da Saduki kaa bagee mée noonaa Yesus paagoo meemaagea. Okoo me wegawoo see menaa ena mee ko kisee: \"Mée booyaa kuwa ko umina bogaakee, aya se andoo peeyaa\" see menaa wegawoo see. Okoo me Yesus asiino, ");
INSERT INTO auu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","\"Ei, Guru. Musa me ebeamaata menaa ena mee ko kisee: 'Mée ena yoga taa kaa booyu ko waa ma kenagaa ena me mee api miyaa da goeano gaano pedeo. Petamanii booyaa mée me yoga yakabayaa mokoo yakabasi yoka tuyaa mée me mee apii goeai' see ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kisee ebeamaata yoka mena ena kasiinake, mee ko kisee: Okoo kenaa bagee okoo petoo. Yagamee yagaaboo to api ena goegi. Waa yoga taa kaboo boogi. ");
INSERT INTO auu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mee api miyaa da ipuugamee me goegi kiya waa miya yoga taa kaboo boogi. Bedaa mabeimee miya kisee. ");
INSERT INTO auu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kisee too petaagoo to amaadii to kaa too. Kaama too apii to miya booga. ");
INSERT INTO auu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eto inii kaapaadee taano ko kisee: Boota bagee mikee aya andoo peeyu ko iminookaa mée aya andoo peeyaa naagoo kuwa okoo kenaa bagee petoo to kuwa mee apii to too goeta yoka kamee me apii kaata naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus me asiino, \"Ikii ewo kaa naapaadeekea. Ikii Ogatamee me ebeamaata menaa miya ewo, Wa me pesee kuwa miya se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kuwa ko Ogatamee me boota bagee yuwa aya andoo peeyaabuu taatagi naagoo api goeano miya taa, api mée maniino miya taa. Okoo epoo to wodoo malaikat bagee mokoo kaatagea. ");
INSERT INTO auu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Boota bagee aya andoo peeyaa ii see nekeeniino menaa kuwa gaayu ko idukaa Musa me menaa yiba topa, see kuwa ikii diino taa, ewo ye? Mee ko Ogatamee me katu see piya ena yibaa taa kaama Musa paagoo aseta menaa ko kisee: 'Anii ko Abraham me Eboo, Isak me Eboo, Yakub me Eboo Ogatamee mee' see aseta. ");
INSERT INTO auu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ogatamee Waa okoo me Eboo see wegayu ko umina boota bagee kuwa kaa kisee se wegayaa, aya tuyaa bagee yuwa kuwa kaa too see wegayaa. Kisee kemaata ikii me mée tomaa umina bogaakee, aya se andoo peeyaa see wegayaa menaa kuwa mikee see taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kuwa Saduki kaa bagee yuwa Yesus ma mena aawegaakea kaboo da Musa me menaa mée topetaa see mée ena migi. Yesus mee dimi ipi kaa mena wegagi ii see deeta kaama wa me Yesus asiino, \"Musa me ebeamaata menaa yiba ebo menaa, mena tukuu to mee kamee naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus me asiino, \"Mena tukuu to mee ko kisee: 'Ikii Israel bagee yuwa nayeeweei. Inii me Eboo TUHAN Ogatamee mee ko TUHAN ena too too. ");
INSERT INTO auu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A me Eboo TUHAN Ogatamee mee dimi menaa da uduma me esee ou gaai, bedaa a me gaayaa dimii yuwa ma, a me pesee da ma kuwa uduma me miya Waa esee epa kaai' see menaa mee. ");
INSERT INTO auu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bedaa wiyaagoo to menaa ko kisee: 'Aa ekaato miya epa kiyaa see see apanaa bagee miya epa kaai' see menaa mee. Kuwa menaa wiya kuwa esee ebo, kuwa asii eboo see menaa ena ma taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mee Musa me menaa mée topetaa see mée to me Yesus asiino, \"Guru, A me wegage kuwa mikee menaa. Ogatamee mee ena too too, Waa see see bagee ena ma taa, Wa too. ");
INSERT INTO auu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mikee, inii dimi menaa da uduma me Waa esee ou gaano ma, bedaa inii me pesee da ma, inii me gaayaa dimii yuwa ma kuwa uduma me miya Waa esee epa kaano kuwa esee ebo menaa. Bedaa inii ekaato miya epa kiyaa see see apanaa bagee miya epa kaano mee miya mikee ebo menaa. Kuwa tuku menaa wiya kuwa esee ebo, Ogatamee paagoo biyaa kaa yuweepeasiyaa agiyoo yuwa ma, apanaa Wa paagoo ekega-manee siyaa agiyoo yuwa ma kuwa uduma peedi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus me mee mée to me asigi menaa kuwa daamaa ipi kaa wegagi yoka naadi asiino, \"Aa ko Ogatamee Wa too ebo totaa see yoo seemeta kaama epo eetuyaa see mée to kaano see koo taake\" see asigi. Mee kaama wodoo mée me Waa apaadee taano wedaagea. ");
INSERT INTO auu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus mee Ogatamee me ee kaa mena tupitaaki too Wa me asiino, \"Mée me wegaano, 'Idukaa kaama wegawoo seta Mée Ebo Kristus mee ko Daud me asii-kaba-kaba seta bagee ena kaatagi' see menaa wegayaa kiya kuwa kaasee? ");
INSERT INTO auu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Idukaa Daud mee Roh Kudus wa yiba esee-awigi naadi kaama wa me wegata menaa ena mee ko kisee: 'TUHAN me ni epoo Mée Tuhan mee paagoo asiino, \"Aa Ni me dagi yagaa yaato animagaai, kisee too Aa ma yape kiyaa bagee yuwa kuwa Ani me daba, peedi kaekeata A me badoo da miyoo taa kaekeasiita\" see aseta' see menaa wegata. ");
INSERT INTO auu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daud me Ebo Kristus mee ko 'Ni epoo Mée Tuhan mee' see wegata yoka Ebo Kristus mee kaasee Daud me asii-kaba-kaba seta bagee ena kiyaa?\" see asigi. Yesus me topeta menaa kuwa okoo mée eebaa esee ede ma yiitookea. ");
INSERT INTO auu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus me topeta menaa ena ma kisee: \"Musa me menaa mée topetaa see bagee kuwa okoo me mée me anii ebo naekeasiino too ede see gaayaa bagee yoka gaai. Okoo togoo dokaa maatagaa naadi peenaa-paanaa taa see too ede, mée kutuu taa see yoo okoo peenaa siyaa kaboo 'Epao, inii me eboo' see naapaagee taano miya ede. ");
INSERT INTO auu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bedaa okoo sembahyang segee see ee yiba mée me nadeesi naadi ebo bagee me animaayu taa see yoo too animagaano miya ede, ebo naagoo naano agiyoo nuyaa yoo miya ebo bagee me animaayu taa see yoo kiyoo too okoo animagaano miya ede. ");
INSERT INTO auu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Okoo ko api miyaa yuwa deebaa naadi kaama okoo me ee yuwa oma yatakimiyaa see bagee. Okoo mée me naapaageesi naadi sembahyang menaa yuwa togoo kaa too asetaa see bagee yuwa. Okoo me kisee too ukuwagee see bagee yuwa yoka okoo esee pedeo kaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus mee Ogatamee me ee kaa kepe awegee see yoo doodoo animaata diitoo siyaa naaki mée yuwa me kepe awegee see yoo kepe aweeii taakea, kepe yago bagee yuwa miya kepe eebaa awetaakea. ");
INSERT INTO auu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kuwa kaboo da daba see api miyaa ena me pose kepee wiya, esee peedi see kepee awetaaga. ");
INSERT INTO auu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus me Wa me topenaa see bagee yuwa \"Meei\" asigi. Wa me okoo asiino, \"Anii mikee kisiino ko: Mee daba see api miyaa da wa me kepe awegee see yoo awetaaga kepee wiya kuwa ko kepe peedi kiya peedi se, apanaa bagee okoo me awegea kepee kuwa asii eboo. ");
INSERT INTO auu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kuwa kepe yago bagee kuwa okoo me koga kepee yuwa awegea kiya mee apii miyaa da wa me gaano pedeo agiyoo edaano see kepee yuwa uduma ki awetaaga kuwa me mikee esee ebo kepee mokoo awetaaga\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus mee Ogatamee me ee kaa kaama peetaaka too ko Wa me topenaa see bagee ena me Waa asiino, \"Guru, deede. Ogatamee me ee ma, gebo kaa ee yuwa ma kuwa diino esee ebo, oma ee magaano esee daamaa yaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus me waa asiino, \"Kuwa a me deetaake ee kuwa diino esee daamaa, se maa? Kiya epeekaa kuwa uduma kabaapi-paapi taatagea, oma ena ma wa me mokataata yoo kaama kisee se ekeasiitagea, uduma pogadaa taata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kiyoo kaama Yesus mee Zaitun Kutuu to kaa Ogatamee me ee doodoo animaata toomuu taaki too ko Petrus ma, Yakobus ma, Yohanes ma, Andreas ma okoo too peedoota Yesus paagoo asiino, ");
INSERT INTO auu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","\"A me kuwa yumakaa mée eewegape menaa kuwa maadee moga ukuwaaniita naa ya? Kuwa agiyoo ukuwaaniino see kooka ii see nekeeniyaa agiyoo kuwa maagiyoo ukuwaandaa taata naa ya? Mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wa me asiino, \"Mée deebaa see bagee agoo kaata yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anii poga-poga see bagee mée eebaa meetagea. Okoo me Ani ekaa naweakee kaa 'Anii ko Waa yoka' see menaa weganaa naadi mée eebaa deebaa siwoo taapea. ");
INSERT INTO auu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kuwa kaboo da taa ko ikii yape menaa ekaapa magaa kaa kaama miya yiipea, beesekaa magaa kaa kaama miya yiipea kiya se wedaai. Kuwa uduma mikee agoo kedaa siwoo taata kiya wodopasi naagoo se. ");
INSERT INTO auu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mée tomaa-tomaa yape aawogee senaa taapea. Amokiyoo magaa kaa bagee me yamokiyoo magaa kaa bagee ma yape aawogee taatagea. Kiyoo-kiyoo naano agiyoo taa uwaa miya medaa taata, maga pigii miya medaa taata. Kisee yaai-yaai agiyoo yuwa eebaa kedaa taata kiya kuwa uduma petamanii ukuwaandaa taata yuwa too, api me yoga kabaano see naadi boodi meege-meege siyaa mokoo. ");
INSERT INTO auu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ikii kibe kiyaa bagee agoo kaata yoka gaai, nekeenii. Okoo me ikii yagaa kipeneata kaama mena pekataa see bagee yuwa paagoo kidogeamoo taatagea, sembahyang segee see ee yuwa yiba miya pepeaduu me kidakamaatagea. Ikii Ni yaato bagee kemaata magaa da kaa ebo tookee bagee yuwa paagoo kiipootagea. Kisee ikii kiipeeyaa kaboo Ni me menaa okoo paagoo daamaa eewegaai. ");
INSERT INTO auu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kiya wodopasi kaano taa kaboo kuwa etokaa daamaa menaa kuwa mée tomaa-tomaa uduma paagoo eeweganaa taano mee keta ukuwaano gaano pedeo. ");
INSERT INTO auu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Okoo me ikii kipeneata kiipeeyaa kaboo 'Anii kaasee menaa wegaapa, kaasee menaa wegaapa?' see dimii kuwa se abaai. Ikii mena wegaano kaboo 'Kisee wegaai, kisee wegaai' see dimii kuwa ikii daamaa ipi kaapea. Ikii me wegaapea menaa kuwa ikii me wegaapea se kiya Roh Kudus me ikii kisi-manee taapi yoka se gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bedaa kuwa kaboo da taa miya kisee ukuwaaniita: Ekea kenaaya kiya ena mee wugimaasi naadi ekegatagaatagi, nagamee me wa me yogaa to ekegatagaatagi, bedaa yogaanii yuwa me okonaka wugimaasi naadi ekegatagaatagea. ");
INSERT INTO auu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ikii Ni yaato bagee kemaata mée uduma kibe kaatagea kiya ikii makii taa, kisee too wodopasi yaato toowoo siyaa bagee kuwa daba daagimaa pootagea.\" ");
INSERT INTO auu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","\"Esee pedeo see agiyoo eboo ena waa toono daa see yoo kiyoo yiinaageeta totaaki see kuwa ikii diitagea. (Ikii eto kiipaa mee kapogee mee deetaakea bagee daamaa nekeenii.) Ikii me waa kisee kiyoo totaaki see deeta kaama Yudea wee kaa toogee see bagee kuwa moga oodoota kuye kaa pakadaa taai. ");
INSERT INTO auu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yoo da kaa tuyaa bagee yuwa ee yiba agiyoo se masii, se gaata oogaai. ");
INSERT INTO auu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bugi kaa tuyaa bagee yuwa miya doka, kisee ou agiyoo kuwa ee kaa pakaa-maseekee se. ");
INSERT INTO auu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kisee yaai-yaai oodaa naadi kaama kadapoo yago apii yuwa ma, yoga baayee yiba kepaa apii yuwa ma kuwa sooi, yaai. ");
INSERT INTO auu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kuwa yaai-yaai see agiyoo ukuwaandaa taata kuwa gemoo see uwaa kega kaboo se ukuwaandaasi naadi sembahyang taai. ");
INSERT INTO auu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kuwa ukuwaandaa taata agiyoo kuwa ko apanaa agiyoo, yaai-yaai ebo, petamanii epoo to, magaa to ogaataata yoo kaama eto too miya ukuwaaniino taa agiyoo yuwa, bedaa kuwa wodoo taa epeekaa yaato miya kaagaa ena ma se ukuwaaniita agiyoo. ");
INSERT INTO auu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ogatamee me Wa me wiginta bagee yuwa epa nao naadi kuwa yaai-yaai, gaagaa siyaa agiyoo kuwa mani yataa kiyaatagi. Maamaa kisee too naaki mée ena ma se tuyaa. ");
INSERT INTO auu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kuwa kaboo da mée me 'Deede, Ebo Kristus mee nakaayoo tupi' see kisiyu ko emaa se wugii, bedaa okoo me 'Deede, Waa amokiyoo tupi' see kisiyaa miya wisintayu. ");
INSERT INTO auu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ebo Kristus poga-poga bagee ma, nabi poga-poga bagee ma kuwa agoo kaatagea yoka okoo wisintagaai. Mée deebaa taano see naadi dimi nagii-nagii agiyoo ukuwaaii taatagea. Ogatamee me wiginta bagee yuwa miya deebaa sedee taano see kiya iyo, se deebaa semaayaa. ");
INSERT INTO auu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ipiipi dii. Kuwa agiyoo uduma ukuwaandaa taano taa da kaa Ani me kisi-maneega yoka daamaa nekeenii.\" ");
INSERT INTO auu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","\"Kuwa yaai-yaai, ebo gaagaa uwaa kuwa omekomeeta wodoo taa kisee ki kenoo to digiyoo aatakii taata, agoo to mee miya se wikiiniita, ");
INSERT INTO auu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","okadee yuwa epoo to kaa kaama kigimedaa taata, bedaa epoo to kaa pesee agiyoo yuwa miya maki-makaa naadi wodeda-peeda sedaa taata. ");
INSERT INTO auu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kuwa kaboo da Mée Yogaa mee sinu uwaa da yibaa taa migi see kuwa diitagea. Waa pesee, Waa asii-sege, Wa disii to esee ebo see diitagea. ");
INSERT INTO auu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wa me malaikat bagee yuwa 'Pooi' asiyaa naaki peedoota maga otoo to kaa kaama kisee too maga otoo to kaa too peenaa naadi Wa me daamaa wiginta bagee yuwa uduma enaataa yakutumeeii senaa taatagea. ");
INSERT INTO auu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Eto ko ebea-ebea menaa ena yeeweei. Ara piyaa mee kagoo da iye mugumedaa naadi iye taki kega gaayu ko mikee, poo ekaano see kooka ii see kuwa ikii nekeeniyaa. ");
INSERT INTO auu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mee mokoo miya kuwa kisega menaa yuwa ukuwaandaa taaka see kuwa ikii deeyu ko monaa da mee katu, ukuwaaniino see kooka ii see kuwa ikii nekeeniitagea. ");
INSERT INTO auu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Anii mikee kisiino ko: Kuwa ukuwaandaa taata agiyoo kuwa uduma eto mee begaa kaa bagee yuwa bogaano taa da kaa diitagea. ");
INSERT INTO auu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Epoo to ma, magaa to ma kuwa taa kaata kiya Ni me menaa mee se taa kaata, kisee too iminoo miya, iminoo miya toota.\" ");
INSERT INTO auu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","\"Monaa da mee ko mee naagoo, mee jam kaa see kuwa mée ena ma ewo. Malaikat bagee miya ewo, Ogatamee Yoopaa miya ewo, Nagamee Wa too ipi. ");
INSERT INTO auu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mona naagoo ko ikii ewo yoka ipiipi see diitoo siwoo taai. ");
INSERT INTO auu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mee naagoo diitoo siwoo siyaa bagee kuwa ebea-ebea menaa ena mee ko kisee: Mée ena waa beesekaa magaa kaa poono taa kaboo wa me agiyoo yaokagee see bagee yuwa mée waa ena kisee agiyoo naokageesi naadi yaekeasigi, mée waa ena kisee agiyoo naokageesi naadi yaekeasigi. Bedaa kenee to kaa diitoo taa see mée to miya 'Aa ipiipi nadiitoo siwoo taai' see asigi, see ebea-ebea menaa mee. ");
INSERT INTO auu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mee see see ikii miya ipiipi see diitoo siwoo taai. Ee epoo Mée Waa meetagi naagoo ikii ewo. Uwaataa yee, daatooyiba yupigapi yee, pe-aweeniino taa see kaboo yee, esee pedeo komaa yee, ikii ewo yoka diitoo siwoo taai. ");
INSERT INTO auu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Taa gaayu ko Waa kisee ki meemaata kaama deeyaa naaki ikii toomoo ometaakea, see kideeyaa. ");
INSERT INTO auu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Eto ko Ni me kisega menaa kuwa Ani me mée uduma asiino menaa ko: Daamaa ipiipi see diitoo siwoo taai, see menaa mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kuwa kaboo da Paskah ma, ragi yeeyee ma aatabi taano taa see roti unu petoo noogee siyaa yuwa kuwa ma unu wiya omemaata naapea see naagoo imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me \"Yesus mee inii kaasee koogo peneasiipea, kaasee patamaapea?\" see menaa kuwa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kiya bedaa okoo me wegaano, \"Kiipaa se, mée yuwa uduma kagoo ebo kaapea yoka Paskah noomaata kaama too Waa peneasiino daamaa\" see menaa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania magaa kaa mée ena ekaa da ko Simon mee tupi. Waa idukaa kado kaa meanee see agiyoo meanta mée to. Wa me ee kaa Yesus mee animaata naano agiyoo notaaki too ko api ena meemaaga. Waa wunu daamaa see uwoo, kepe edaano ebo see uwoo, oma otaawee peedi ena yiba doopa. Otaawee da ebee to yaato taapeata kaama uwo yuwa Yesus mumoo to kaa yakabagekomeega. ");
INSERT INTO auu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yakabagekomeega naadi Wa me topenaa see bagee yuwa kagoo kaa koogo aawegaa taano, \"Yaai, kuwa uwoo kuwa kaasee kaa aii peepuuka naa ya? ");
INSERT INTO auu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kuwa uwoo kuwa pe-doogeeta kaama ebo kepee ogei me badoo wedo asii masemaata kaama daba bagee aii maniino daamaa yoka\" see koogo aawegaakea. Okoo me mee apii to kagoo ma menaa asegea. ");
INSERT INTO auu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kiya Yesus me asiino, \"Ikii me mee apii mee si yawegaai. Kaasee kaa pedeo see yawegagea ya? Wa me naukuwaga kuwa esee daamaa agiyoo. ");
INSERT INTO auu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Daba bagee gaayu ko ikii paagoo kisee too kiiumiwoo, toowoo taapea yoka ikii me aii kaboo miya okoo kaa daamaa agiyoo yaukuwayaa. Kiya Anii gaayu ko ikii ma enaataa eebaa se kiiumiipa. ");
INSERT INTO auu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mee apii to me 'Anii daamaa agiyoo ena yaukuwamaayaa yoka yaukuwaanaka' see nagaata kaama nakoo sepa. Wa me Anii ogo namagaano taa kaboo naipiipii siyaa agiyoo mokoo yoka pedeo see si yawegaai. ");
INSERT INTO auu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Anii mikee kisiino ko: Ni me doomega menaa kuwa uwoo to, magaa to kiyoo-kiyoo eewegakomeegea kaboo mee apii to me daamaa naukuwapa agiyoo mee miya eeweganaa taapea, bedaa asii yaato miya kuwa menaa neke-nekee siwoosi naadi yadoonaa taapea, see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kuwa kaboo da Yudas Iskariot mee, Yesus me topenaa see bagee gaasi ma wiya kuwa mée ena mee Yesus yaekegatagaano see naadi peedoota imam ebo yuwa paagoo mena eewegagi. ");
INSERT INTO auu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wa me Yesus mee ikii paagoo kiekegatagaapa see asigi menaa kuwa okoo me yeeta kaama ede kaa \"Kepe kisuwa kaniipe\" see asegea. Mee kaama wodoo wa me 'Yesus mee yaekegatagaano kuwa kayoo daamaa, kayoo daamaa?' see gaawooki. ");
INSERT INTO auu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ebo naagoo, ragi yeeyee ma aatabi taano taa see roti kuwa unu petoo noogee siyaa yiba petamanii nuyaa naagoo, domba wodaa wugiyaa naagoo ko Yesus me topenaa see bagee yuwa peedoota Wa paagoo asiino, \"Paskah kaa agiyoo naano yoo kayoo naa ipiipii taano daamaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wa me topenaa see bagee wiya paagoo asiino, \"Ekea kota kaa pooi. Peemaata kaama mée ena, uwo otaawee doopegeeki see mée ena ma aadee taapea. Aadee seta kaama waa ma epo enaataa pooi. ");
INSERT INTO auu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wa me seemaapi ee yiba seemaai. Ee epoo mée mee kisee naasii: 'Guru me kasiino, \"A me ee yiba Ni me topenaa see bagee yuwa ma inii epo enaataa Paskah kaa agiyoo eenaape yoo naa kayoo ya?\" see kasigi' see naasii. ");
INSERT INTO auu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ee epoo mée wa me ee asii mee kakadee kaa ebo komoo kaa badaa kimagaataapi. Kiyoo inii me animagaapea yoo daamaa mée yaipiipii semaata topa see kuwa ekea diipea. Inii kiyoo naano agiyoo naapea yoka agiyoo-pagiyoo pe-niiipiipii taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Asigi naadi ekea peedoota kota kaa peemaagea naaki mikee, Yesus me asigi-asigi uduma ukuwaanega naadi Paskah kaa agiyoo uduma daamaa eeipiipii semaagea. ");
INSERT INTO auu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Digiyoo takiinega see kaboo Yesus Wa me topenaa see bagee gaasi ma wiyaa to ma enaataa peedoota mee ee kaa peemaayu. ");
INSERT INTO auu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Animaata kaama naano agiyoo notaaki too Yesus me asiino, \"Anii mikee kisiino ko: Ikii Anii ma epo enaataa notaakea bagee kuwa mée ena me Anii naekegatagaapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Okoo dimi boodi ebo. Okoo uduma mée ena-ena me Waa asiino, \"Sooi, anii ye, ani me ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus me asiino, \"Ikii mée gaasi ma wiya kuwa mée ena me, roti ponee to mee otaawee yiba Anii ma enaataa tukume-nootaaki mée to wa me Anii naekegatagaapi. ");
INSERT INTO auu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mée Yogaa mee mikee Ogatamee me menaa yiba ebeamaata see see bogaapi kiya Waa ekegatagaapi mée mee esee pedeo kaapi. Mee mée mee kabaano taa naaki daamaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Okoo epo notaaki too Yesus mee roti masegeeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Roti kabatagaa naadi kaama okoo paagoo goo-maneeyu. \"Mee ko Ni me maa to yoka masii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kiyoo kaama anggur poo uwoo otaawee da masegeeyu naadi Ogatamee paagoo kiiboo, paamee see menaa aseta kaama otaawee da okoo goo-maneeyu, okoo uduma mee otaawee yiba kaama nogea. ");
INSERT INTO auu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wa me asiino, \"Mee ko Ni me tadaa uwoo. Mée yuwa ma, Ogatamee ma, Wa me aseta menaa ma kuwa uduma enaataa aagadimisi naadi yapeeyaapa tadaa, mée eebaa okoo kaa yakabageapa tadaa mee. ");
INSERT INTO auu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anii mikee kisiino ko: Eto kenaagoo kaama wodoo Anii anggur poo uwoo se naapa, Ogatamee Wa too ebo mée eetoowoo taatagi naagoo too Anii bedaa gipii see anggur poo uwoo naata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Okoo Ogatamee yaapaagee see kaa yaayaa see menaa ena yaayaa semaata peedoota Zaitun Kutuu to kaa peemaata kaama ");
INSERT INTO auu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus me okoo asiino, \"Ikii uduma maki-makaa naadi Anii naekeata oodaa taapea, idukaa Ogatamee me menaa yiba ebeamaata see see, mee ko kisee: 'Domba munitaa see mée mee Ani me wugimagaapa. Wugimaata kaama domba wodaa yuwa ena kitaa peega, ena kitaa peega sedaa taapea' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kisee kaapa kiya Anii aya andoo peeta kaama Ani keta Galilea wee kaa poota, ikii uuto\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus me asiino, \"Okoo uduma weda kaa A too kaekeata poopea miya anii Aa se kaekeasiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus me waa asiino, \"Anii mikee kasiino ko: Eto mee digiyoo yiba ayam ena kaagaa wiya menaa taano taa kaboo aa kaagaa wedo mée paagoo ewo poga-poga nataape\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petrus me asiino, \"Anii Aa ma enaataa bogaapea miya daamaa, anii mée paagoo ewo poga-poga see se kakoo taapa yoka\" see asigi. Apanaa yuwa me \"Anii miya kisee, anii miya kisee\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesus mee Wa me topenaa see bagee yuwa ma peedoota maga ena kaa ekaa da ko Getsemani magaa kaa peemaata kaama Wa me okoo asiino, \"Ikii nakaayoo animaata niitooi, Anii sembahyang taanaka yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Petrus ma, Yakobus ma, Yohanes ma kuwa okoo too Yesus me badaa maadoota amo kaa naa kaa eepeemaata kaama Waa gaagaa ebo naadi dimi nagimeamooki. ");
INSERT INTO auu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wa me okoo wedo asiino, \"Sooi, Anii esee gaagaa ebo, booyaa mokoo. Ikii nakaayoo ipiipi diitoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Waa pakadoota woo kaa naa kaa pakaamaata kisee ki magaa da kaa esee-gapuunigi. Wa me sembahyang menaa kaa kuwa yaai-yaai agiyoo nakoo taapea monaa da mee nataa kiyaano daamaa gaayu ko nataa kiyaai naadi menaa asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wa me asigi menaa ko \"Abba, Neataagi, kuwa Ni me boodi abaapa kuwa se naekeasii see kasega kiya Ni me gaayaa dimii too se kiya A me gaata-gaata dimii too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sembahyang semaata kaama esedoota Wa me topenaa see bagee wedoo to paagoo eseemaagi too ko okoo toomoo ompea. Wa me Petrus asiino, \"Simon, aa toomoo ometaake ye? Aa peenaa kuwa miya diitoo taano kuwa kana ye? ");
INSERT INTO auu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ikii kigaadee siyaa kaboo pedeo dimii, pedeo menaa wisintaasea naadi ikii ipiipi see diitoo taai, sembahyang taai. Ikii me 'Kisee ukuwaanaka' see gaayaa dimii agoo kiya má yaato ko dabaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesus Waa kaagaa ena ma pakadoota woo kaa naa kaa bedaa yumakaa sembahyang sipi menaa kuwa asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sembahyang semaata kaama esedoota Wa me topenaa see bagee wedoo to paagoo eseemaagi too ko bedaa toomoo ometaakea, okoo esee toomoo ebo kaa emaa pakaa-wikiiniino naka. Okoo me Yesus asiino menaa peenaa ma taa, ewo. ");
INSERT INTO auu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bedaa kaagaa wedaagoo to ma sembahyang segeeta Wa me topenaa see bagee wedoo to paagoo eseemaata kaama asiino, \"Ikii kisee too toomoo too ometaakea ye? Kuwa sikii. Deeweei, Mée Yogaa mee dimi pedeo see bagee yuwa yagaa kaa yaekegatagaano see monaa kaa kega. ");
INSERT INTO auu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Anoogeeweei, inii poono. Ikii deeweei, Anii naekegatagaano mée mee migi yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kuwa menaa wegataaka too ko taka ena Yudas mee, Yesus me topenaa see bagee gaasi ma wiyaagoo to mee mee meemaagi. Waa ma mée ebo etaa mowai ma, kopaa ma doodoota eemeemaagi. Kuwa bagee kuwa ko imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo me \"Niipeneasea yoka pooi\" see asegea naadi meemaagea bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Miyoo taa meemagaano taa kaa Yudas me kuwa bagee yuwa paagoo mee Yesus yoka see kuwa nekeensi naadi menaa ena ase-maneegi, mee ko kisee: \"Ani me ebe duuduu taapa mée to mee yoka peneata eepooi\" see menaa mee. ");
INSERT INTO auu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudas meemaata kaama kisee ki peedoota Yesus paagoo \"Guru, epao\" aseta kaama Yesus ebe duuduuki. ");
INSERT INTO auu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wa me kisee ukuwagi naaki kuwa eemipi bagee yuwa me Yesus me-peneasegea. ");
INSERT INTO auu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Peneasegea naadi kiyoo topea bagee mée waa ena me posee da masegeeta mée ena kaa kobeasigi naaki dagi yagaa yaato apa kamuu da yadaakomeegi, Ebo Imam wa me agiyoo yaokagee see mée. ");
INSERT INTO auu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus me okoo asiino, \"Ikii me dimi pedeo omaago see bagee ena mokoo peneasiino see naadi mowai, kopaa, kisee agiyoo doopea ye? ");
INSERT INTO auu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Anii egapii gakata Ogatamee me ee kaa awee da kaa mée topegeeka, ikii miya kiyoo topea kiya ikii me napeneasiino taa kemea. Kiya kuwa eto ukuwaanega kuwa ko idukaa ebeamaata menaa yuwa uwa daasi naadi ukuwaanega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kiyoo kaama Wa me topenaa see bagee yuwa uduma Wa too ekeata oodaakea. ");
INSERT INTO auu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kuwa kaboo da egaanaa ena, Yesus ma epo peenaa see mée ena kiyoo tupi. Waa tapaato dokaa da mee too maataata peenaaki kaboo kuwa bagee yuwa me waa miya peneasiino see kookea. ");
INSERT INTO auu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kiya okoo me wa me dokaa da mee too peneasegea naaki dokaa da okoo me yagaa da kaa ekeata waa má tago kisee peegi. ");
INSERT INTO auu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Okoo me Yesus peneata kaama Ebo Imam me ee kaa eepeegea. Kiyoo imam ebo yuwa ma, Yahudi kaa ebo-ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo kutuu semaata toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus mee koogo deega se deega naadi Yesus doogea taa obeegi. Ebo Imam me ee kaa peemaata kaama kiwitaa to yiba seemigi. Waa mee ee yadiitoo taa see bagee yuwa ma epo enaataa animaata biyaa to kaa yabi kiitaaki. ");
INSERT INTO auu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mee ee yiba kaama imam ebo yuwa ma, mena pekataa see bagee apanaa yuwa ma okoo uduma Yesus mee patamaano dimii agoo. Mee dimii agoo naadi kaama Wa me kisee pedeo agiyoo ukuwapi see deepea bagee yuwa abagea. Kiya kisee deeta bagee ena ma deemagaano taa. ");
INSERT INTO auu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mée eebaa okoo me makapaa menaa yakobagea kiya okoo me anii kisee deepa, kisee deepa see wegagea menaa kuwa mée waa ena me wa too menaa wegagi, mée waa ena me wa too menaa wegagi, mena ena too too menaa wegaano taa yoka koopoo see menaa yuwa too. ");
INSERT INTO auu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kuwa kaboo da mée wiya, wedo waa naa yiinaageeta kaama Wa kaa mena ena yawegagea, mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"Mee Mée mee me miyoo taa wegaano, 'Ani me Ogatamee me ee mee, mée me yagaa me maataata ee mee umiyaata kaama unu wedo kaa too bedaa apanaa ee ena, mée me yagaa me magaano taa see ee ena maatagaapa' see wegami menaa kuwa inii yeeme\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kiya kuwa bagee yuwa me menaa kuwa miya mée ena me wa too menaa wegagi, mée ena me wa too menaa wegagi, mena ena too too menaa wegaano taa. ");
INSERT INTO auu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ebo Imam mee okoo yaayupii da kaa yiinaageeta kaama Yesus asiino, \"Kuwa bagee me A kaa kawegapea menaa kuwa Aa mena ena ma se asiipe ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kiya Yesus mena taa, koogo totaaki. Bedaa Ebo Imam me asiino, \"Idukaa kaama wegawoo seta Mée Ebo Kristus mee, inii me yaapaagee see Mée Wayoopaa mee Aa ye, taa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus me asiino, \"Mee ko Anii. Mée Yogaa mee Se-pesee, We-pesee yago Mée Wa me dagi yagaa yaato animaata ebo tupi see kuwa ikii diitagea, sinu uwaa yupii da taa migi see miya diitagea, see kuwa mikee kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ebo Imam me mee menaa da yeeta kaama kagoo kaa waa ekaato dokaa da geakomeeta kaama asiino, \"Eto ko Wa me kisee pedeo ukuwapi see deepea bagee apanaa se abaai. ");
INSERT INTO auu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wa me Ogatamee me be kiyaa menaa wegagi. Ikii miya yeemaagea yoka sikii. Eto ko ikii me kaasee ukuwaakee gaagea ya?\" asigi naaki \"Waa bogaano gaano pedeo\" asegea. ");
INSERT INTO auu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kiyoo kaama okoo me Yesus kaa dabeedi taaweekea, Wa me ebeyumaa da kaa dapimemaata kaama yagaa kopaa dakamegea. Okoo me asiino, \"Ei, duya yago mée, Aa kadakamegea bagee kuwa maamee nuwaa naa ya? Mée asii\" see asegea. Ee diitoo taa see bagee yuwa me miya Waa yagaa kopaa dakamegea. ");
INSERT INTO auu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petrus mee Ebo Imam me ee yoo da kaa toomuu taaki too ko kiyoo Ebo Imam me agiyoo yaokagee see apii ena wa paagoo meemaaga. ");
INSERT INTO auu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wa me Petrus mee biyaa geboo da kaa yabi kiitaaki see deega. Wa me Petrus maamaa tamaata kaama asiino, \"Ei, aa miya Nazaret magaa kaa mée Yesus mee ma epo peenaa see mée to\" see asega. ");
INSERT INTO auu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kiya Petrus me ewo poga-poga naadi asiino, \"Taa, kisee menaa kuwa anii ewo, nekeeniino taa\" see asigi. Petrus waa peedoota wagee kenee to kaa peemaagi too ko ayam menaaki. ");
INSERT INTO auu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mee agiyoo yaokagee see apii to bedaa Petrus deeta kaama kiyoo bagee yuwa asiino, \"Mee mée mee miya okoo yaato bagee ena\" see asega. ");
INSERT INTO auu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kiya Petrus me \"Taa, kisee se\" see asigi. Egaaniino taa kaboo ko bedaa kiyoo topea bagee yuwa me Petrus asiino, \"Aa mikee okoo yaato bagee ena, aa miya Galilea wee kaa mée yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petrus me baato maata ma baato maataa naadi kaama asiino, \"Ataagi yoogi, mee ikii me wegataakea Mée mee anii ewo see Mée\" see asetaagi naaki ");
INSERT INTO auu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ayam mee kaagaa wiyaagoo to ma menaaki. Mee kaama too Yesus me yumakaa asigi menaa da nekeenigi, mee ko 'Ayam ena kaagaa wiya menaa taano taa kaboo aa kaagaa wedo mée paagoo ewo poga-poga nataape' see nasigi mee ii naadi kaama ebo yegee yegeeki. ");
INSERT INTO auu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tokoma mee da, pedeo komaa da imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma, Yahudi kaa ebo-ebo apanaa yuwa ma, kuwa mena pekataa see bagee yuwa kuwa uduma okoo kutuu semaata kaama mena aawegaakea. Mena daakomeeta kaama Yesus yagaa da taa one gadimegea. One gadimemaata kaama badaa maadoota Gubernur Pilatus paagoo pe-ekeasegea. ");
INSERT INTO auu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus me Yesus asiino, \"Aa ko Yahudi bagee me Eboo mikee ye, taa ye?\" asigi naaki \"A me wegage kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Imam ebo yuwa me Pilatus paagoo Yesus \"Kisee pedeo agiyoo ukuwapi, kisee pedeo menaa wegapi\" see menaa maamaa yakobagea. ");
INSERT INTO auu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus me Waa asiino, \"A me asiino menaa taa ye? Yeede, okoo me 'Wa me kisee pedeo agiyoo ukuwapi, kisee pedeo menaa wegapi' see kawegagea menaa kuwa maamaa eebaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kiya Yesus mena ena ma asiino taa. Pilatus mee dimi nagimigi. ");
INSERT INTO auu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paskah Naagoo tahun gakata digiyoo ee yiba dogeamoo seta bagee kuwa mée ena Gubernur me daba yapeeyaabuu segee seta. Kuwa ko mée yuwa me Gubernur paagoo \"Mee mée mee daba mée yapeeyaai\" see kuwa tahun gakata asiwoo segee seta. ");
INSERT INTO auu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kuwa kaboo da mée ena ekaa da ko Barabas mee digiyoo ee yiba tupi. Waa ma, apanaa bagee yuwa ma okoo mee magaa kaa kiyoo mée yuwa aakago-maakago naadi kaama mée wugita kemaata okoo digiyoo ee yiba dogeamaata topea. ");
INSERT INTO auu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kuwa kaboo da mée yuwa me Pilatus paagoo asiino, \"A me ukuwata-ukuwata see see digiyoo ee yiba dogeamaamea bagee ena mee daba mée yapeeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wa me asiino, \"Ikii Yahudi bagee me Eboo Yesus mee daba kipeeyaa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus me aseta menaa mee ko mée yuwa me Yesus ebo ekeasegea kuwa imam bagee yuwa me 'Anii miya kisee ebo naekeasegea naaki ou' naadi kagoo kaa Yesus yaekegataagea ii, see kuwa Pilatus me nekeenta kaama aseta menaa mee. ");
INSERT INTO auu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kiya imam ebo yuwa me kiyoo topea bagee yuwa koogo eeweganaa taano, \"Barabas mee daba mée yapeeyaai, Yesus mee se, see niiasii\" see eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus me kaagaa ena ma asiino, \"Kisee gaayu ko ikii me Yahudi bagee me Eboo see ekaa weegeekea Mée mee anii Wa kaa maagiyoo yaukuwayaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Okoo uduma bedaa ebo menaa kaa asiino, \"Waa piya bokoo to kaa paku wugii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus me asiino, \"Kiya yaai, Wa me pedeo ukuwapi agiyoo maagiyoo naa ya?\" see asigi. Kiya okoo me bedaa esee ebo menaa kaa asiino, \"Waa piya bokoo to kaa paku wugii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus me okoo kisee ede kegea yoka naadi Barabas mee daba yapeeyaagi kiya Yesus mee pepeaduu me dakameamoo semaata piya bokoo to kaa paku wugitaasi naadi okaa yago bagee paagoo yaekeasigi. ");
INSERT INTO auu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kuwa okaa yago bagee yuwa me Yesus badaa maadoota Gubernur me ee yiba eepakaamaagea. Kiyoo apanaa okaa yago bagee topea yuwa ma uduma meei naadi kaama Yesus paagoo kutuu semaagea. ");
INSERT INTO auu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Okoo doka ena, dadi poo epoo da see see dokaa Wa kaa yamaataagea. Kiyoo kaama takuu yago onee ena bakane yaidimitaata kaama mumoo to kaa yamaataagea. ");
INSERT INTO auu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kisee yamaataata kaama wisineekee kaa asiino, \"Yahudi bagee me Eboo, kiiboo, magiyaage\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wa me mumoo to kaa tamoo da me dakamegea, Wa kaa dabeedi taaweekea, Wa paagoo kagu maga kaa sebaata Waa ebo ekeasiyaa poga-poga kaa menaa asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kisee wisineamoo semaata mee dadi poo epoo da see dokaa da yabeageeta kaama bedaa Wa me petamanii dokaa da yamaataagea. Kiyoo kaama piya bokoo to kaa paku wugiino see naadi badaa maadoo peegea. ");
INSERT INTO auu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Okoo peetaaka too ko Kirene magaa kaa mée ena ekaa da ko Simon mee kota gebo kaa magaa kaa kaama meemaagi. Waa ko Aleksander ma, Rupus ma ekeataagi. Okoo waa ma aadee seta kaama Yesus me piya bokoo to mee \"Aa yadogaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Muguu naadi maga ena ekaa da ko Golgota magaa kaa eepakaamaagea. Golgota see ekaa mee wegayu ko Mumo Metoo Kutuu to see ekaa mee. ");
INSERT INTO auu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kiyoo pakaamaata kaama anggur poo uwoo ma, mur see agiyoo ma kuwa aatogo-maatogo semaata Waa nusi naadi manegea kiya se nugi. ");
INSERT INTO auu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Waa piya bokoo to kaa paku wugitaata kaama Wa me dokaa yuwa maamee me masiipi, maamee me masiipi naadi okoo me agiyoo iyagideekea. ");
INSERT INTO auu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesus piya bokoo to kaa paku wugitaagea mee ko pedeo komaa yaato, keno iyee see kaboo ukuwagea. ");
INSERT INTO auu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wa kaa menaa yuwa yaebeamaata kaama piya bokoo to kaa pakaa-tabeasegea. Mee menaa da mee ko kisee: \"Mee mée mee ko Yahudi bagee me Eboo mee\" see menaa mee. ");
INSERT INTO auu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oma masetaa see bagee wiya miya Yesus ma enaataa piya bokoo to kaa paku wugitaagea. Wa me dagi yagaa yaato mée ena, eka yagaa yaato mée ena. ");
INSERT INTO auu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","See ukuwata mee ko idukaa Ogatamee me menaa ena uwa daaga, mee ko kisee: \"Mée me 'Waa miya mena si yayeetaa see Mée ena ii' see gaatagea\" see ebeamaata menaa da mee uwa daaga yoo. ");
INSERT INTO auu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kitaa peetaakea bagee yuwa me mumo wagii-wagii naadi wisineekee kaa Yesus asiino, \"Ei, Ogatamee me ee mee umiyaata kaama bedaa unu wedo yiba too maataata tota-tota siyaayaa see wegame Mée ");
INSERT INTO auu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aa ekaato daba peese yoka eto kiipaa apiyoo piya bokoo to kaa kaama magaa da kaa eseanii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kisee miya imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me Yesus wisineekee kaa aawegaa taano, \"Wa me apanaa bagee se boosi naadi daba daagimaayaabuu segee simi kiya Waa ekaato iyo. ");
INSERT INTO auu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Waa Ogatamee me wigintaata Mée Ebo Kristus mee, Israel bagee me Eboo mee mikee ki Waa kepa ko mee piya bokoo to kaa kaama eseansi ke. Inii me kisee deeta kaama too Waa mikee nao see gaayaa\" see asegea. Yesus ma enaataa piya bokoo to kaa paku wugitaagea bagee wiya ekea me miya Waa wisinegea. ");
INSERT INTO auu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kenoo to mée mumoo to kaa pakaamaagi see kaboo kuwa magaa uduma digiyoo aatakiika, kisee too keno wedo kaa too pakaa-pakaa. ");
INSERT INTO auu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Keno wedo kaa pakaamaaga kaboo da Yesus ebo menaa-menaa kaa \"Eloi, Eloi, lama sabaktani?\" see wegagi. Mena nekeeniino yaato ko \"Ni me Eboo Ogatamee, Ni me Eboo Ogatamee, Aa kaasee kaa naekeasege?\" see mee. ");
INSERT INTO auu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kiyoo topea bagee yuwa noonaa me kuwa menaa yeeta kaama asiino, \"Yeede, Waa Elia mee mena ogetaaki yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kiyoo topea bagee mée ena me Yesus uwo nusi naadi doka ponee to see see agiyoo moga masegeeta geebagi see anggur poo uwoo yiba esee-tokoata gokoo da kaa yokoata kaama asiino, \"Elia me Waa piya bokoo to kaa kaama dookumiino see naadi isiipi ye, taa ye see niidiitoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kuwa kaboo da Yesus Waa ebo menaa-menaaki naaki taka ena dimi noogaa da pe-seomigi. ");
INSERT INTO auu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kuwa kaboo da Ogatamee me ee semoo yiba yaato kenee to kaa wasitaata dokaa da mee usii to kaa kaama pegadoota manii to kaa too wiya wodeenega. ");
INSERT INTO auu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Okaa yago bagee me eboo mee Yesus ikigii to kaa yiinaageeta Waa boopi-boopi kuwa deeta kaama asiino, \"Mee Mée mee ko mikee Ogatamee Yoopaa ii\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kiyoo api eebaa miya beesekaa mokoo kaama diitookea. Kuwa apii yuwa yupii ko Maria Magdalena mee ma, Yakobus ma, Yoses ma ekea baayo Maria mee ma, Salome ma okoo wedo topea. ");
INSERT INTO auu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kuwa apii kuwa ko Yesus Waa Galilea wee kaa kaama peenaa seta kaboo Waa ma epo enaataa peenaa, Wa me agiyoo yaukuwanaa segee seta apii yuwa. Apanaa apii okoo eebaa miya kiyoo topea. Okoo ko Yesus ma epo enaataa peenaa seta, kisee too Waa Yerusalem magaa kaa pakaamaagi yoo too, kisee epo peenaa seta apii yuwa. ");
INSERT INTO auu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Uwaataa da ayayaa takiinega. Mee naagoo ko tokoma Sabat naagoo kaa agiyoo-pagiyoo ipiipii taa see naagoo. ");
INSERT INTO auu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kuwa kaboo da mée ena ekaa da ko Yusup mee, Arimatea magaa kaa mée tupi. Waa ko Yahudi kaa mena pekataa see bagee ena. Mée me waa maamaa ebo ekeasegea, apanaa yuwa see see se. Wa me Ogatamee Wa too ebo mée eetoowoo taatagi naagoo mee moga migi naaki ou see dimii maamaa gaawoo see mée. Waa Yesus bootaa da ogo magaano see naadi weda taa kaa peedoota Pilatus paagoo pe-idimigi. ");
INSERT INTO auu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus me Yesus mee boopi menaa da yeeta kaama moga boopi nao naadi dimi nagimigi. Wa me okaa yago bagee me eboo mee \"Meei\" see asigi. Waa meemaagi kaboo Pilatus me \"Waa mikee boopi ye?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","\"Mikee, boopi\" see asigi. Kisee asigi naadi bootaa da mee Pilatus me Yusup masisi naadi yaekeasigi. ");
INSERT INTO auu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusup me daamaa poodee see doka gipii ena edaageeta kaama Yesus bootaa da masegeeyu. Masegeeta kaama mee daamaa poodee see doka gipii da kaa bebenataata kaama doodoota mée ogo magaano yoo kiyoo oma ena togaawee ogo maatayu. Mee oma togaagoo da mee ko mée bootaa da ogo maasi naadi yadenamaata oma togaagoo da mee. Mee oma togaawee ogo maataata kaama ebo omaa ena bikimedoota kenee to kaa pe-takeata eke. ");
INSERT INTO auu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kuwa kaboo da Maria Magdalena ma, Yoses baayo Maria mee ma ekea me Yesus ogo maapea yoo deegea. ");
INSERT INTO auu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat naagoo esegekomeeta kaama Maria Magdalena ma, Yakobus baayo Maria ma, Salome ma wedo Yesus bootaa da wunu daamaa peesi naadi agiyoo edaagea. ");
INSERT INTO auu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kiyoo kaama mee daa yiba petamanii naagoo esee pedeo komaa da Yesus ogoo da kaa peegea. ");
INSERT INTO auu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Eta mana kaa okoo me aawegaa taano, \"Waa ogoo da kaa takeata omaa to mee maamee me mée yabikimeamaapi naa ya?\" see menaa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Okoo peemaata kaama deamaagi too ko Waa ogoo da kaa takeata omaa to mee bikeata amoo maa kaa peanta topa, esee ebo see oma damaa to mee. ");
INSERT INTO auu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Okoo beapa semoo yiba peanta kaama deamaayaa naaki egaanaa mokoo see mée ena, togoo dokaa poodee da maataata tupi, beapa yiba dagi yagaa yaato kiyoo animaata totaaki. Okoo me waa deeta kaama dimi oogea. ");
INSERT INTO auu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kiya wa me okoo asiino, \"Ikii se wedaai. Piya bokoo to kaa paku wugitaamea Mée, Nazaret magaa kaa Mée Yesus mee ikii me abagea. Waa aya andoo peepi, nakaayoo toono taa. Deede, kiyoo ko Wa bootaa da maataamea yoo. ");
INSERT INTO auu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Eto ko ikii moga peedoota Wa me topenaa see bagee yuwa paagoo pooi. Petrus ma okoo paagoo kisee pe-naasii: 'Yesus Wa keta Galilea wee kaa pe-seomigi yoka kiyoo ikii me Waa diipea, Wa me ikii kisimi see see' see kisigi see pe-naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kuwa apii yuwa me yaai, dimi nagimaano ebo kaa beapa yiba kaama yiibaga peegea. Okoo weda ebo kegea yoka kuwa menaa mée ena ma eewegaano taa. ");
INSERT INTO auu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mee daa yiba petamanii naagoo Yesus mee aya andoo peeta kaama Maria Magdalena wa paagoo keta Waa ekaato awee da kaa deeyaagi. Idukaa waa paa petoo agoo kiya Yesus me yaabagaapeasimi, waa kisee apii to. ");
INSERT INTO auu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Waa peedoota kuwa Yesus ma epo peenaa seta bagee yuwa paagoo peemaaga naaki okoo yege ma, yii-yii ma taakea. Wa me kuwa Yesus kaa menaa kuwa okoo eewegaga. ");
INSERT INTO auu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mee apii to me \"Yesus aya andoo peepi, ani me kisee deepa\" see asega menaa kuwa okoo me yeeta kaama mikee menaa yoka see se gaagea. ");
INSERT INTO auu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kiyoo kaama Yesus mee Waa epoo ena mée ekea wiya paagoo awee da kaa Waa ekaato deeyaagi. Ekea me magaa kaa peetaakea kaboo Waa awee da kaa kigi. ");
INSERT INTO auu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ekea paagoo awee da kaa keta kaama ekea peedoota Yesus ma epo peenaa seta bagee apanaa yuwa paagoo eewegagea naaki okoo me kuwa ekea me menaa kuwa mikee yoka see se gaagea. ");
INSERT INTO auu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kiyoo kaama Wa me topenaa see bagee gaasi ma ena okoo naano agiyoo notaakea kaboo Waa ekaato okoo paagoo deeyaagi. Deeyaata kaama Wa me okoo ego-tago see kaa asiino, \"Ikii dimi eboo see bagee yuwa. Kuwa Anii aya andoo peeta kaama nadeepea bagee yuwa okoo me kiiwegamea menaa kuwa ikii mikee nao see nagaano taa yaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bedaa Wa me okoo asiino, \"Ikii peedoota uwoo to, magaa to mée tomaa-tomaa uduma paagoo Ni me daamaa doometa menaa kuwa eeweganaa taai. ");
INSERT INTO auu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Okoo me mikee nao see nagaata kaama uwo yatukumeta bagee kuwa daba daagimaa pootagea. Kiya Anii mikee see se nagaayaa bagee kuwa pedeo kaatagea. ");
INSERT INTO auu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Waa mikee gaayaa bagee yuwa ii see kuwa nekeensi naadi ukuwayaa agiyoo kuwa ko kisee: Okoo me paa yuwa Ani ekaa naweeta kaama yaabagaapeasiipea, bedaa okoo me ewo see menaa kiya mena tomaa-tomaa kaa wegaapea miya, ");
INSERT INTO auu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bedaa okoo me mée daakee otoogiyoo yuwa yagaa me peneasiipea miya, bedaa okoo me mée booyaa uwoo nuyaa miya se bogaapea. Bedaa okoo me ikiyoo yago bagee yuwa kaa yagaa yamaataagea naaki ikiyoo taa kaapea miya, okoo me kisee agiyoo ukuwaapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tuhan Yesus Wa me kuwa menaa okoo paagoo eewegamaata kaama Waa badaa maadoota epoo to wodoo Ogatamee paagoo pakaamaata kaama Wa me dagi yagaa yaato animaagi. ");
INSERT INTO auu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Waa pakaa-seometa kaama Wa me topenaa see bagee yuwa Wa me menaa kiyoo-kiyoo yaweganaa seta, bedaa okoo me weganaa see menaa kuwa mikee menaa yoka see gaasi naadi agiyoo kuwa miya Tuhan me okoo doodoo yaukuwaaniyaabuu senaa seta, see koo seta. Kiyoo too.");
INSERT INTO auu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teopilus eboo aa epao. Mee kapogee kaebeaga menaa kuwa ko kisee: Idukaa kaama wegawoo seta menaa kuwa Yesus Wa kaa uwa daata. Yesus mee inii ma enaataa kaboo ukuwanaa, peenaa seta menaa kuwa apanaa bagee mée eebaa me ebeamaamea. ");
INSERT INTO auu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kuwa menaa yuwa petamanii kaama deeta bagee yuwa daamaa yaweganaa siwoo seta, inii paagoo miya mée eewegata. ");
INSERT INTO auu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kisee kemaata anii miya kuwa Yesus me ukuwanaa, peenaa seta menaa yuwa kapoge kaa ebeano ko daamaa yoka naadi kuwa menaa yuwa mée paagoo ipiipi apaadee senaa seta mani kaa kaama dimi-dimi kaebeaga. ");
INSERT INTO auu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mée me \"Yesus me kisee ukuwata, kisee peeta\" see katopegee seta menaa kuwa a me 'Mikee, mee menaa too' see kuwa daamaa nekeense naadi eto mee kapogee mee kaebeaga. ");
INSERT INTO auu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Petamanii Herodes mee Yudea wee kaa ebo eetotaaki kaboo da imam bagee ena ekaa da ko Zakaria mee tupi. Imam bagee kutuu yuwa kuwa ko Waa ma kutuu ekaa da ko Abia see kutuu. Apimee ekaa da ko Elisabet. Waa miya idukaa petamanii Ebo Imam Harun mee kaa kaama kabawoo seta apii. ");
INSERT INTO auu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ekea bogaa Tuhan me menaa uduma daamaa ipiipi yayeewoo, yaukuwawoo taa see too kemaata dimi topoo, Ogatamee emaa dagii da kaa ekea kisee bagee wiya ii see deetaa see. ");
INSERT INTO auu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet waa pai keta apii, ekea adama yaato miya yoga taa. ");
INSERT INTO auu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kuwa kaboo da kaawaa ena Ogatamee me ee kaa imam bagee me agiyoo-pagiyoo ukuwagee siyaa kuwa \"Abia see kutuu kaa bagee ikii me ukuwaai\" see asegea. Zakaria peedoota imam bagee me agiyoo-pagiyoo ukuwagee yoo peemaata kaama ");
INSERT INTO auu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ogatamee me ee yiba wunu daamaa peesi naadi agiyoo yeeyee biyaa iyee taapi mée to mee maamee kaapa naadi kaama okoo me ukuwaakee agiyoo iyagideekea, imam bagee me ukuwaa-ukuwaa. Iyagideekea naaki Zakaria kaa kega. ");
INSERT INTO auu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wunu daamaa agiyoo yabonee segee see kaboo kega naadi Tuhan me ee yiba peegi, mée yuwa yoo da kaa sembahyang taakea. ");
INSERT INTO auu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Biyaa iyee semaata kaama deamaagi too ko Tuhan me menaa eseasegee see mée ena tupi, mee biyaa kaa yabonee segee yoo dagi yagaa yaato yiinaageeta totaaki. ");
INSERT INTO auu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria yaai naadi esee weda ebo ");
INSERT INTO auu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","kiya mee malaikat see mée to me asiino, \"Zakaria, aa se wedaai. A me idimegee see menaa kuwa Ogatamee me kayeegeeki yoka a me apii paayogaa yogaa ena agoo kaata. Mee yogaa mee ekaa da ko Yohanes see ekaa munitagaai. ");
INSERT INTO auu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mee yogaa mee kaa aa esee ede kiwoo taape, yoga kabaape naagoo mée maamaa eebaa miya ede kaapea. ");
INSERT INTO auu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mee yogaa mee Tuhan me esee ebo bagee kiyaatagi. Waa anggur poo uwoo ma, boomagaa see uwoo ma kuwa se naapi. Okooto kadapoo yiba kaama asii Roh Kudus me pesee kaa umiwoo, toowoo taapi. ");
INSERT INTO auu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel bagee yuwa okoo me Ogatamee ekeata bagee yuwa okoo mée eebaa kuwa miya waa okoo me Eboo Ogatamee ma dimii menaa kaa too umiwoo, toowoosi naadi tupiitagi. ");
INSERT INTO auu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Idukaa nabi Elia me Roh pesee da kaa ukuwanaa, peenaa seta see see waa miya kisee ukuwanaa, peenaa taatagi. Tuhan me ukuwanaa, peenaa taano see kooki kaboo mée yuwa topegee taatagi, kuwa ko nagaanii yuwa me yogaanii yuwa epa kisi naadi menaa ma, Ogatamee me menaa si yayeetaa see bagee yuwa okoo me pedeo dimii, pedeo agiyoo ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoosi naadi menaa ma kuwa mée topegee taatagi. Mée me Tuhan mee daamaa badaa maasi naadi wa me kisee okoo yaipiipii taatagi\" see kuwa malaikat see mée to me asigi menaa. ");
INSERT INTO auu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria me asiino, \"Kisee kabaata, kisee ukuwaaniita ii see kuwa anii kaasee nekeeniyaa? Anii miya adama, ni me apii miya adama yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaikat see mée to me asiino, \"Anii ko Gabriel, Ogatamee me agiyoo yaukuwaano see naadi Wa paagoo eetotaa see mée. Ogatamee me 'Kuwa daamaa menaa pe-naasigii' see nasigi naadi kasega. ");
INSERT INTO auu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Eto yeede. Ni me kasega menaa kuwa mona naagoo mikee ukuwaaniita kiya aa mikee se nagaage kemaata eto kaama asii aa mena wegaano naka, kisee koogo toogee see mée to kaape. Kuwa menaa da ukuwaaniita naagoo too aa mena wegaano keago kaatage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kuwa kaboo da Ogatamee me ee yoo da kaa topea bagee maamaa diitookea. Epee yaai, maagiyoo masigi naadi dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Waa pudumeta kaama mena peenaa ma wegaano naka. Yagaa me too kisee-kisee see ase-maneeki naaki 'Waa mee kooki mee ko dega-dega kaa agiyoo ena deepi' see kuwa nekeenegea. ");
INSERT INTO auu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ogatamee me ee yiba agiyoo-pagiyoo yaukuwagee see egapii yuwa taa kega kaboo peedoota ee kaa. ");
INSERT INTO auu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Omegee naadi kaama wa me apii Elisabet mee kadapoo kega. Keno idibi ee kaa koogo toogee naadi kaama ");
INSERT INTO auu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","wa me wegaano, \"Tuhan me nadeegi nao. Mée me 'Kaasee yoga taa see apii to ya?' see nagaataa see dimii kuwa nataa kiyaagi nao\" see wegaga. ");
INSERT INTO auu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet kadapoo keta kaama keno bedimi omemaata mee kenoo kaa malaikat see mée to Gabriel mee Ogatamee me menaa doodoota Galilea wee kaa, Nazaret magaa kaa ");
INSERT INTO auu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kiyoo ukuyogaa ena paagoo isigi. Waa goeano see mée to mee ko Daud ma apaa kaa mée wa ekaa da ko Yusup. Mee ukuyogaa ekaa da ko Maria. ");
INSERT INTO auu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel mee Maria paagoo eseemaata kaama asiino, \"Epao, Tuhan me esee kaepa kigi see ukuyogaa aa\" asigi. \"Tuhan mee aa ma enaataa daamaa kaatoogeeki yoka\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","dimi ooga. Mee kaasee menaa nasigi naadi dimi abaga. ");
INSERT INTO auu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaikat see mée to me asiino, \"Maria, wae, Tuhan me kaepa kigi yoka aa se wedaai. ");
INSERT INTO auu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aa kadapoo keta kaama paayogaa yogaa ena kabaatage. Wa ekaa da Yesus see ekaa munitagaai. ");
INSERT INTO auu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Waa esee ebo kaatagi. Ebo Wodoo Eboo Ogatamee Wayoopaa see ekaa weatagea. Idukaa Waa ma apaa kaa mée Daud mee ebo eetoogee seta see see Tuhan Ogatamee me Waa miya ebo tuyaatagi. ");
INSERT INTO auu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Waa Israel bagee paagoo ebo mée eetoono kuwa ko usiyaato ko ewo, kisee too iminoo miya, iminoo miya ebo mée eetoowoo taatagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria me asiino, \"Anii ko ukuyogaa yoka, pai taa. Anii kaasee kadapoo kaapa ya?\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaikat see mée to me asiino, \"Roh Kudus mee a kaa isiitagi, Ebo Wodoo Eboo Ogatamee Wa me pesee a kaa kaisiyaapi. Kuwa me kemaata a me kabaatage yogaa mee Ogatamee me Wa too wigintaata Yogaa kaatagi, Ogatamee Yoopaa see ekaa weatagea. ");
INSERT INTO auu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mikee, a kaa apii Elisabet mee pai keta apii see ekaa weegee semea kiya eto too adama yaato yoga kadapoo keta kaama keno bedimi ompea. ");
INSERT INTO auu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ogatamee me se ukuwamaayaa agiyoo ena ma taa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria me asiino, \"Mikee, anii ko Tuhan me agiyoo aii yaokagee see ukuyogaa. A me nasege menaa kuwa ni kaa naukuwatagaano kuwa daamaa\" see asega. Kiyoo kaama malaikat see mée to peegi. ");
INSERT INTO auu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Egaa ena Maria mee moga pakadoota Yudea wee kaa, boba kaa magaa ena kaa, ");
INSERT INTO auu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakaria me ee kaa pakaamaata kaama Elisabet paagoo \"Epao\" asega. ");
INSERT INTO auu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mee epao see menaa yeega naaki wa me kadapoo yiba yogaa to maki-makaaki, Roh Kudus mee Elisabet yiba esee-awigi. ");
INSERT INTO auu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Esee-awigi naadi kaama wa me mena ebo kaa asiino, \"Neebee, a too daamaa agiyoo kakiyaagi see apii nao, bedaa a me kadapoo yiba yogaa mee miya kisee. ");
INSERT INTO auu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ni me Eboo Tuhan wabaayo mee aii apii dabaa to paagoo nameemaage. ");
INSERT INTO auu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mikee, a me epao nasege menaa da mee ni me kadapoo yiba yogaa to miya yeeta kaama ede kaa maki-makaa sipi. ");
INSERT INTO auu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tuhan me kasimi menaa da kuwa a me 'Mikee naukuwaaniyaapi ii' see dimii mee gaage yoka daamaa, ede nao\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria me wegata menaa kuwa ko kisee: \"Nii dimi keepaa to me Tuhan yaapaageeka, ");
INSERT INTO auu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","bedaa nii dimi menaa da me anii daba nadaagimaa peeyaano Mée Ogatamee mee kaa ede ma, ede ma taaka, ");
INSERT INTO auu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","anii Wa me agiyoo aii yaokagee see dabaa to kiya anii nadeemaagi. Mikee, eto kaama wodoo mée uduma me 'Mee ko Tuhan me epa kiyaa see apii to yoka' see nawegawoo taapea. ");
INSERT INTO auu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pesee Wodoo Pesee Wa me ebo agiyoo naukuwataagi kemaata mée me kisee nawegawoo taapea. Wa ekaa da ko Wa too, pedeo ena ma taa see Mée see ekaa mee. ");
INSERT INTO auu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wa me mée epa dimii mee ko Wa too weda, Wa too ebo see gaayaa bagee yuwa epa kiyaa, bedaa okoo me asii-kaba-kaba bagee yuwa miya kisee too epa kiwoo siyaa. ");
INSERT INTO auu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wa me pesee ma ukuwataa see agiyoo kuwa mée deeyaabuu taa see, okoo dimi yiba 'Anii omaago, ni too ipi' kisee ebo poga-poga bagee yuwa Wa me ketaa-ketaa abagaapii taa see too. ");
INSERT INTO auu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Magaa to kaa tookee eboo yuwa daba bagee kiyaabuu see, bedaa daba bagee yuwa daamaa ebo kiyaabuu siyaa. ");
INSERT INTO auu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Naadi kiyaa bagee yuwa daamaa agiyoo me pesee kiyaabuu see, kiya kepe yago bagee yuwa imi taa aii peeyaayaa. ");
INSERT INTO auu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Inii Israel tomaa kuwa daamaa mée deewoo see, inii Wa me agiyoo yaokagee see bagee yuwa epa mée gaawoo siyaa. ");
INSERT INTO auu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Wa me idukaa Abraham paagoo 'Ani me kisee daamaa kiukuwawoo taapa' see aseta menaa kuwa Waa gaabuu taano taa, kisee too daamaa doowoo see, Abraham me asii-kaba-kaba seta bagee yuwa Wa me epa kaa deewoo see, kisee too iminoo miya, iminoo miya\" see kuwa Maria me yaapaagee seta menaa. ");
INSERT INTO auu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kiyoo kaama waa Elisabet ma epo enaataa keno wedo waa naa omemaata kaama wa me ee kaa peega. ");
INSERT INTO auu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet yoga kabaano keno kaa yoga kabamaaga naaki paayogaa yogaa. ");
INSERT INTO auu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yoga kabamaata kaama \"Tuhan me Elisabet mee esee epa nao\" see menaa weganaakea naaki wa me bagee ma, apanaa gebo kaa bagee uduma waa ma epo enaataa ede ma, ede ma segeekea. ");
INSERT INTO auu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yoga kabamaata kaama unu wagaagoo to naagoo mée noonaa me yogaa to kado ponee yadaapeasiino see naadi megea. Kado ponee to yadaapeata kaama ekaa muniino see kaboo \"Nagamee ekaa da Zakaria see ekaa mee yugumee miya ekaa munitagaano daamaa\" see asegea ");
INSERT INTO auu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kiya okooto me \"Kisee se, Yohanes see ekaa munitagaai\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Okoo me asiino, \"Kiya a me bagee kisee ekaa muniino taa yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yogaa to maamee ekaa muniipea naadi nagamee yagaa begoata apaadeegea. ");
INSERT INTO auu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nagamee piya gakee ena nadoomisi naadi idimigi. Piya gakee da kaa ko \"Wa ekaa da ko Yohanes yoka\" see ebeamaagi. Okoo uduma dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kisee ki taka ena mena wegaano keago kigi, Ogatamee yaapaageeki. ");
INSERT INTO auu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kiyoo bagee uduma wedaagea. Kuwa menaa doodoota Yudea wee kaa boba kaa magaa kaa uduma eeweganaakea naaki ");
INSERT INTO auu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","mée uduma dimi gaagaa naadi wegata menaa ko \"Mee yogaa mee kaasee yogaa kaatagi naa ya?\" see wegagea, Tuhan me pesee kuwa wa kaa ii see gaagea yoo. ");
INSERT INTO auu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yohanes ataagi Zakaria mee Roh Kudus wa yiba esee-aweta kaama Ogatamee me menaa yawegagi, kuwa ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"Inii Israel bagee epoo Mée Tuhan Ogatamee, Wa me bagee yuwa daba mée daagimaa peeyaabuu taano see naadi inii paagoo isigi yoka niiyaapaagee taai. ");
INSERT INTO auu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wa me agiyoo yaokagee seta mée Daud mee wa me asii-kaba-kaba bagee ena, inii omaago ma daba mée daagimaa peeyaabuu taapi Mée mee mée yaagoo kiyaapi. ");
INSERT INTO auu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Idukaa Wa me daamaa wiginta bagee yuwa me menaa, Wa me nabi bagee yuwa me wegawoo seta menaa kuwa uduma eto uwa daano see kooka, ");
INSERT INTO auu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kuwa ko inii ma yape kiyaa bagee yuwa, inii mée be kiyaa bagee kuwa mée yaabagaapii taapi, ");
INSERT INTO auu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","bedaa inii me idukaa bagee okoo Wa me epa dimii mee deeyaano see naadi Wa me okoo aseta menaa yuwa se gaabuu seta, ");
INSERT INTO auu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abraham paagoo \"Anii taa ma taa kisee daamaa kiukuwaaniyaabuu siwoo taapa\" see aseta menaa kuwa Waa neke-nekee siwoo taa see, ");
INSERT INTO auu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kuwa ko inii ma yape kiyaa bagee yuwa mée yaabagageeta kaama inii weda dimii taa kaa Waa yaapaageesi naadi menaa, ");
INSERT INTO auu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","inii me umiino, toono begaa kuwa Wa emaa dagii da kaa pedeo taa, dimi topoo see kaa too umiwoosi naadi menaa, kisee menaa kuwa Wa me Abraham paagoo aseta kaama daamaa doowoo see. ");
INSERT INTO auu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bedaa ei, niyoopaa, aa gaayu ko Asii-sege see Mée Ogatamee Wa me ebo nabi bagee see ekaa aa kaweatagea. Tuhan meeno etaa da a keta daamaa yamasiitage, ");
INSERT INTO auu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kuwa ko Ogatamee me bagee yuwa okoo me pedeo yuwa epa yaekeata kaama daba mée daagimaa peeyaano menaa kuwa daamaa nekeensi naadi a me yaweganaa taatage. ");
INSERT INTO auu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Inii me Eboo Ogatamee me inii mée epa dimii mee ebo. Pedeo komaa keno mée yamiyaayaa mokoo see Mée Waa epoo to wodoo kaama inii paagoo isiipi. ");
INSERT INTO auu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Digiyoo yiba toogee see bagee yuwa, bogaano weda ma omegee see bagee yuwa okoo paagoo awee yakiyaata kaama Waa ma emee-emee siyaayaa etaa da taa eepeegee siwoo taapi\" see kuwa Zakaria me yaapaagee seta menaa. ");
INSERT INTO auu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yohanes see yogaa to kabamaata ebo kiwoo naadi kaama dimi mena miya pesee kiwoo seta. Waa Israel bagee yuwa paagoo poono taa kaboo da ebo mee maga ugii da kaa wa too omegee, toogee seta. ");
INSERT INTO auu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kuwa kaboo da Kaisar Agustus wa me mée uduma ebo menaa da asiino, \"Waa ena wa me magaa kaa, waa ena wa me magaa kaa ekaa yuwa kapoge kaa maagiino see naadi pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuwa mée ekaa yuwa kapoge kaa maageeta mee ko petamanii etaa kaa. Kuwa kaboo da taa ko Kirenius mee Siria wee kaa magaa uduma gubernur eetotaaki too. ");
INSERT INTO auu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kuwa menaa yuwa doodoota maga uduma wegakomeeta kaama waa ena wa me magaa kaa, waa ena wa me magaa kaa ekaa yuwa kapoge kaa maagiino see naadi peegea. ");
INSERT INTO auu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusup miya Galilea wee kaa magaa ena, Nazaret magaa kaa kaama peedoota Yudea wee kaa magaa ena Betlehem magaa kaa peegi. Betlehem magaa mee idukaa Daud kabata magaa. Yusup mee Daud ma apaa kaa mée to kemaata Betlehem magaa kaa peegi. ");
INSERT INTO auu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Waa ma dimi aapeegee see ukuyogaa Maria mee kadapoo ma ekea ekaa maagiino see naadi peedoota ");
INSERT INTO auu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Betlehem magaa kaa peemaayaa naaki yoga kabaano see kenoo kaa kega. ");
INSERT INTO auu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kuwa kaboo da waa petamanii yogaa, paayogaa yogaa ena kabamaata kaama doka ponee me bebenamaayu naadi moneekee agiyoo me boobaa noogee see agiyoo dokoo da kaa eke, meekee bagee me omeekee ee komo sipi mee me. ");
INSERT INTO auu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Betlehem gebo magaa kaa boo uwaa da kaa daatooyiba yaato domba wodaa eetoogee see bagee yuwa domba yuwa eetoomuu taa siyaa naaki ");
INSERT INTO auu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tuhan me menaa eseasegee see mée ena kiyoo eseemaagi. Tuhan me asii-sege siyaa agiyoo agoo da okoo uduma wogaamaaga naadi wedaagea ");
INSERT INTO auu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","kiya mee mée to me asiino, \"Taa, ikii se wedaai\" asigi. \"Anii daamaa menaa eboo, mée uduma ede see menaa kisiino see mega yoka\" asigi. ");
INSERT INTO auu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","\"Mee ko eto kenaagoo Daud mee kabata magaa kaa kaama ikii daba kidaagimaa peeyaano Mée Ebo Kristus, Tuhan kabagea\" asigi. ");
INSERT INTO auu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","\"Amokiyoo kisee nekeensea naadi agiyoo ukuwaandaa taapa yuwa ikii diipea kisee: Baayee yiba yogaa ena doka ponee me bebenamaata kaama moneekee agiyoo me boobaa noogee see agiyoo dokoo da kaa ometaaki diipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Taka ena mee mée to geboo da kaa apanaa malaikat bagee eebaa ebo etaa eseemaata kaama Ogatamee yaapaagee see menaa: ");
INSERT INTO auu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","\"Kiiboo, paamee, magiyaage, Ogatamee, epoo to wodoo Asii-sege see Mée. Bedaa magaa da kaa kiyoo, Tuhan me ede kiyaa bagee yuwa Waa ma emee-emee siyaayaa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kuwa malaikat bagee yuwa epoo to wodoo metaki pakadaakea kaboo da domba eetoogee see bagee yuwa me aawegaa taano, \"Ei, Betlehem magaa kaa ukuwaanega kotoo Tuhan me mée asegeegi yoka pe-diino, niipooi\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Okoo moga peedoota Maria ma, Yusup ma bogaa paagoo peemaata kaama deamaayaa naaki mikee, baayee yiba yogaa to moneekee agiyoo me boobaa noogee see agiyoo dokoo da kaa ometaaki. ");
INSERT INTO auu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Okoo yogaa to deeta kaama \"Kristus mee kabagea yoka see mée asegeegi\" menaa da kuwa asenaa siyaa naaki ");
INSERT INTO auu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","mée uduma dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria mee kuwa menaa yuwa uduma dimi yiba daamaa ipiipi neke-nekeeka. ");
INSERT INTO auu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kuwa domba eetoogee see bagee okoo me deepea-deepea yuwa malaikat bagee me asigi-asigi see see mikee ukuwaanega naadi Ogatamee yaapaagee, ebo ekee ma metaki domba toogee yoo peegea. ");
INSERT INTO auu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yogaa to kabamaata kaama wagaagoo to naagoo ko Waa kado ponee yadaapeasegea. Yadaapeata kaama ekaa da ko okooto kadapoo kaano taa kaboo malaikat see mée to me ekaa munta ekaa da Yesus see ekaa mee muntaagea. ");
INSERT INTO auu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yoga kabamaata kaama unu mée wiya ee kaa too toogee setaa to sikii kega kaboo Yusup ma, Maria ma ekea Tuhan paagoo agiyoo kupi-maneeta kaama mee yogaa to yaekegatagaano see naadi Yerusalem magaa kaa peegea, idukaa Musa me menaa yiba kisee ukuwaai see ebeamaata see see, ");
INSERT INTO auu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kuwa ko kisee: \"Paayogaa yogaa yagaaboo to gaayu ko Tuhan Waa nekee yoka Wa paagoo yaekegatagaano gaano pedeo\" see menaa da ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bedaa Musa me menaa yiba mena ena miya kisee: \"Yoga kabayaa apii yuwa deme see bedoo wiya yee, ugimagu see bedoo poodu mokoo wiya yee Tuhan paagoo kupi-manii\" see menaa ebeamaata. Kuwa menaa wiya yaukuwagiino see naadi peegea. ");
INSERT INTO auu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kuwa kaboo da taa ko Yerusalem magaa kaa mée ena ekaa da ko Simeon mee tupi. Waa Ogatamee me menaa yayeewoo, Waa ma dimii menaa kaa too umiwoo see mée. Roh Kudus mee waa ma eetotaaki. Waa Israel bagee yuwa daba daagimaa peeyaabuu taatagi see wegawoo seta Mée mee maamee kaapi naadi maamaa diitoo segee see mée. ");
INSERT INTO auu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Roh Kudus me Simeon paagoo miyoo taa asimi menaa ko \"Tuhan me wigintaata ebo toowoo see Mée Ebo Kristus mee aa deeta wodoo too bogaape\" see asimi. ");
INSERT INTO auu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kisee asimi kemaata Roh Kudus me Simeon mee Ogatamee me ee geboo da kaa eepeegi. Kuwa kaboo da Yesus see yogaa to mee okonaka kuwa Musa me menaa yiba yoga kaa kisee ukuwaai see menaa ebeamaata yuwa yaukuwagiino see naadi Ogatamee me ee kaa doo-peegea. ");
INSERT INTO auu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aadeekea ko Simeon me mee yogaa to wa me yagaa da kaa yaageeta kaama Ogatamee yaapaagee seta menaa ko ");
INSERT INTO auu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"O, Tuhan, A me naseme menaa da mee uwa nadaayaage, kisee deega yoka eto ko anii koogo bogaano daamaa, ");
INSERT INTO auu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","mee ko A me inii daba mée daagimaa peeyaano Mée mee anii emaa me deega, ");
INSERT INTO auu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mée tomaa-tomaa uduma Waa kisee Mée to ii see nekeensi naadi A me awee da kaa yakiyaage. ");
INSERT INTO auu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Waa ko mée tomaa-tomaa uduma mikee menaa ipi kisi naadi agoo da mokoo see Mée. Waa agoo kemaata mée tomaa-tomaa yuwa me A me bagee, inii Israel bagee kuwa mée yaapaagee taapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kuwa Simeon me mee Yogaa to kaa asigi menaa kuwa okooto ma, nagamee ma dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kiyoo kaama Simeon me Ogatamee me pesee kuwa ekea kaa kisi naadi daamaa yaasigi. Yaasemaata kaama okooto Maria wa too asiino, \"Yeede, mee yogaa mee ko Israel bagee yuwa mée eebaa aapekadaasi naadi Ogatamee me Wa too wigintaata Yogaa. Mée noonaa daamaa kaatagea, mée noonaa pedeo kaatagea. Okoo mikee menaa nekeensi naadi migi kiya okoo me be kaatagea, ");
INSERT INTO auu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","okoo me kisee dimi yiba koogo gaayaa menaa yuwa awee da kaa too kedaa taata. Okooto aa kiyu ko dimi boodi ebo kaatage, mowai me dimi menaa da nokogiyaa mokoo kaatage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kuwa kaboo da nabi apii ena, esee pedeo adamaa da topa. Wa ekaa da ko Hana, Panuel yoopane, Asyer apaa kaa apii. Waa miyaa apii to, paimee ma tahun petoo too omemaata kaama boomi. ");
INSERT INTO auu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Waa miyaa keta kaama wodoo tahun bado asii mée oga ma wui (84) omegee, toogee naadi mée me goeano taa, Ogatamee me ee kaa too egapi yaato miya, daatooyiba yaato miya sembahyang ma, naano agiyoo tapoo toogee taano ma, kisee Ogatamee ebo ekee see agiyoo yaukuwageeka, amaa kaa se peetaa see apii. ");
INSERT INTO auu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yusup bogaa kiyoo topea kaboo da waa peedoota ekea paagoo \"Ogatamee kiiboo, paamee, magiyaage\" see yaapaageeka, bedaa okoo Yerusalem kaa bagee daba mée daagimaa peeyaabuu taatagi Mée mee mani migi naaki ou see dimii gaawoo see bagee yuwa paagoo mee yogaa to kaa menaa eeweganaaka. ");
INSERT INTO auu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kiyoo kaama Yusup bogaa ekea Tuhan me menaa yiba yoga kaa ukuwaa-ukuwaa uduma daamaa yaukuwataata kaama Galilea wee kaa, ekea me magaa kaa Nazaret magaa kaa metaki peegea. ");
INSERT INTO auu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kiyoo kaama yogaa to ebo kiwoo naadi kaama pesee, dimi ipi, Ogatamee me Waa epa nao, ede nao see gaawoo seta. ");
INSERT INTO auu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesus me okonaka tahun gakata Paskah naano see naadi Yerusalem magaa kaa pakagee segee see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Egaa ena Yesus mee tahun gaasi ma wiya ometa see kepaa kaboo okonaka ma eepeegea, okoo me ukuwaa-ukuwaa. ");
INSERT INTO auu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Okoo Paskah noogeeta kaama metaki Nazaret magaa kaa peetaaki too Yesus mee Yerusalem magaa kaa goetaagea. Waa meeno taa see kuwa okonaka se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ekea me gaano, 'Yesus mee apanaa bagee ma okoo keta peepea' see gaata kaama peegea. Eta mana kaa omemaayu, tokoma mee da yogaa to abanaakea. Okoo kenaa bagee yuwa paagoo ma, apanaa peepea bagee yuwa paagoo ma abanaakea ");
INSERT INTO auu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kiya kiyoo diino taa naadi Yerusalem magaa kaa pakaa-abaano see naadi metaki pakagea. ");
INSERT INTO auu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pakaamaata kaama unu wedo abanaa naadi Ogatamee me ee kaa pe-deegea naaki tupi, mée topetaa see bagee yuwa paagoo animaata okoo me menaa yiitooki, bedaa Wa me miya okoo pe-apaadee taaki see deegea. ");
INSERT INTO auu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yesus esee dimi ipi naadi mikee menaa too asetaaki kuwa kiyoo bagee yuwa uduma dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Okonaka me deemaata kaama sooi, dimi nagimegea. Okooto me asiino, \"Ei, niyoopaa, agaataagi ma enaa dimi nagii-nagii mée siyaage kuwa kaasee kaa ya? Aa kaewo naadi kagaaga kaa kaabanaake yoka\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus me asiino, \"Kaasee kaa kiyoo-kiyoo naabanaa sepea? Neataagi me ee kaa kiyoo Anii toono gaano pedeo see kuwa ekea se nanekeenegea ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kiya Wa me asigi menaa kuwa ekea se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kiyoo kaama Waa ma okoo paaya enaataa peedoota Nazaret magaa kaa peemaata kaama Wa me okonaka me aseta menaa yayeewoo seta. Kuwa ukuwaandaa sepa menaa yuwa kuwa uduma okooto daamaa dimi yiba neke-nekee siwoo seta. ");
INSERT INTO auu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus mee ebo kiwoo, ipi kiwoo, Ogatamee me miya Waa epa kaa ede ketaa, mée me miya epa kiwoo, kisee umiwoo seta. ");
INSERT INTO auu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kuwa kaboo da Roma kaa eboo ena ekaa da ko Kaisar Tiberius ebo tota. Waa ebo toogee seta kuwa petamanii kaama tahun gaasi ma idibi ebo toogee seta kaboo da taa ko apanaa Roma kaa eboo ena ekaa da ko Pontius Pilatus mee Yudea wee kaa magaa uduma gubernur ebo tota. Galilea wee kaa magaa kuwa Herodes mee ebo tota, bedaa waawaagi Pilipus mee Iturea wee kaa magaa ma, Trakonitis wee kaa magaa ma ebo tota. Apanaa eboo ena ekaa da ko Lisanias mee Abilene wee kaa magaa kaa ebo tota. ");
INSERT INTO auu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Israel kaa Ebo Imam wiya agoo, ekaa yuwa ko Hanas ma, Kayapas ma wiya. Kuwa kaboo da taa ko Zakaria yoopaa Yohanes mee piya taa, one taa see ebo mee maga ugii da kaa tupi. Kiyoo Ogatamee me wa paagoo mena ase-maneegi. ");
INSERT INTO auu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kuwa menaa doodoota Yordan wee kaa bagee uduma paagoo eeweganaa seta menaa ko \"Ikii me pedeo dimii, pedeo menaa kuwa Ogatamee me epa kiekeasiipi yoka eto ko ekeata kaama uwo tukumaai\" see menaa weganaaki. ");
INSERT INTO auu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Idukaa nabi Yesaya me ebeamaata menaa ena mee uwa daano yaato ko Yohanes kaa uwa daaga, mee ko kisee: \"Ebo mee maga ugii da taa mée waa ena me ebo menaa-menaa kaa 'TUHAN me etaa da ipiipi yawuditagaai, Waa meeno see etaa daamaa topoo yatupitagaai. ");
INSERT INTO auu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Debaa yuwa uduma meandaa taata, maga bago yuwa ma, maga kutuu yuwa ma uduma miya endagii kedaa taata, koopoo kiyaa yuwa topoo-topoo tagaa taata, bedaa kutu-patu kiyaa yuwa miya endagii kedaa taata. ");
INSERT INTO auu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kuwa agiyoo yuwa ukuwaandaa naadi kaama Ogatamee me daba mée daagimaa peeyaabuu taatagi kuwa mée tomaa uduma diitagea'\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kisee kemaata okoo mée eebaa uwo natukumisi naadi megea. Wa me okoo asiino, \"Yaai, ikii otoogiyoo tomaa, kaasee kaa nakaayoo megea ya? Ogatamee me mée wigintagaatagi naagoo 'Wa me se nakagoo kaatagi, anii daba poota' see dimii mee gaagea ye? ");
INSERT INTO auu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Eto ko ikii me pedeo yuwa ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo taai. Ikii mikee kisee bagee ii see kigaasi naadi daamaa agiyoo too ukuwawoo taai, daamaa poo ekayaabuu siwoo taai. Ikii me 'Inii ko Abraham me asii-kaba-kaba seta bagee yoka inii sikii' see dimii mee se gaai. Ani me kisiino ko: Abraham me asii-kaba-kaba seta bagee gaayu ko Ogatamee me apuwa oma tabaa da kuwa kisee bagee maamaa eebaa kiyaayaa yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Piya manii da kaa yaka maataata eto tupi yoka daamaa poo se ekayaa piyaa yuwa uduma kobegeeta kaama biyaa yiba tameatagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kuwa mée yuwa me Yohanes asiino, \"Kisee kiyu ko inii maagiyoo naa ukuwaakee daamaa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wa me asiino, \"Doka wiya kiyaa bagee kuwa doka taa see mée ena manii, bedaa naano agiyoo agoo kiyaa bagee kuwa miya tapoo totaaki mée eenaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kuwa kaboo da pajak kepee yamasegee see bagee miya uwo natukumisi naadi megea. Okoo me asiino, \"Ei, guru, inii maagiyoo naa ukuwaakee daamaa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wa me asiino, \"Pajak kepee kuwa koga ma si yamasii, 'Kisuwa namasii' see kisiyaa yuwa kuwa too yamasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Okaa yago bagee yuwa me asiino, \"Inii gaayu ko maagiyoo naa ukuwaakee daamaa?\" asegea naaki \"Oma kepee se idimaai, se masii, bedaa kepe neesi naadi mée wedaa-wedaa see kuwa miya se ukuwaai, mena si yakobaai. Ikii me ukuwataa to kaa maseekee kepee kuwa too sikii see gaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kuwa kaboo da mée yuwa me Ebo Kristus mee migi naaki ou naadi kaama 'Mee ko Yohanes mee ye?' see dimii gaagea. ");
INSERT INTO auu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kisee gaagea naadi wa me okoo uduma asiino, \"Apanaa bagee ena meepi, mee ko esee ebo see Mée. Anii peedi yoka Wa me bado doko yabeano mee miya anii weda, iyo. Ani me ikii uwo yiba kitukumpa kiya Wa me kitukumaano kuwa ko Roh Kudus yiba miya kitukumaatagi, biyaa yiba miya kitukumaatagi. ");
INSERT INTO auu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wa me yagaa da kaa gandum poo wigineakee agiyoo miya topa. Keepa wiginegee sepea yuwa masegeeta maagee see yoo daamaa awemagaano see kiya pedeo yaato se modeemaayaa see biyaa kaa boneasiitagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kisee kuwa menaa ma Yohanes me etokaa daamaa menaa eebaa eeweganaaki. ");
INSERT INTO auu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kiya mee magaa to kaa tookee eboo Herodes me Yohanes kagoo kigi. Mee ko Herodes me waebee woga ekaa da ko Herodias mee oma yagoemi, bedaa apanaa pedeo agiyoo eebaa ukuwami kemaata Yohanes me waa ego-tagoki. Kuwa me kemaata ");
INSERT INTO auu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes me \"Yohanes mee digiyoo ee yiba nadogeamaai\" see asigi. Kisee kemaata Herodes wa me pedeo ukuwataa see agiyoo ena ma ukuwagi. ");
INSERT INTO auu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yohanes mee digiyoo ee yiba dogeamaano taa kaboo mée yuwa uduma uwo yatukumemaata kaama Yesus mee miya uwo yatukumigi. Yesus sembahyang taaka too ko epoo to kabaanega. ");
INSERT INTO auu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kuwa kaboo da taa Roh Kudus mee poodee see bedoo keenda Wa kaa eseanigi. Eseanigi kaboo epoo to yaato kaama aseeyamaata menaa ko \"Aa ko Niyoopaa. Ni me esee kaepa see Yogaa yoka A me Anii dimi wikii-wikii nasiyaabuuke\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus mee petamanii mena weganaa taano see kaboo Waa tahun amaamo mokoo ometa see Mée. Wa miyoo kabata bagee ekaa yuwa kuwa ko kisee: Nagamee mee ko Yusup, mée me kisee wegawoo seta. Yusup mee Eli yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli mee Matat yoopaa, Matat mee Lewi yoopaa, Lewi mee Malki yoopaa, Malki mee Yanai yoopaa, Yanai mee Yusup yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup mee Matica yoopaa, Matica mee Amos yoopaa, Amos mee Nahum yoopaa, Nahum mee Hesli yoopaa, Hesli mee Nagai yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mee Maat yoopaa, Maat mee Matica yoopaa, Matica mee Simei yoopaa, Simei mee Yosek yoopaa, Yosek mee Yoda yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mee Yohanan yoopaa, Yohanan mee Resa yoopaa, Resa mee Zerubabel yoopaa, Zerubabel mee Sealtiel yoopaa, Sealtiel mee Neri yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mee Malki yoopaa, Malki mee Adi yoopaa, Adi mee Kosam yoopaa, Kosam mee Elmadam yoopaa, Elmadam mee Er yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er mee Yesua yoopaa, Yesua mee Eliezer yoopaa, Eliezer mee Yorim yoopaa, Yorim mee Matat yoopaa, Matat mee Lewi yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi mee Simeon yoopaa, Simeon mee Yehuda yoopaa, Yehuda mee Yusup yoopaa, Yusup mee Yonam yoopaa, Yonam mee Elyakim yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim mee Melea yoopaa, Melea mee Mina yoopaa, Mina mee Matata yoopaa, Matata mee Natan yoopaa, Natan mee Daud yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud mee Isai yoopaa, Isai mee Obed yoopaa, Obed mee Boas yoopaa, Boas mee Salmon yoopaa, Salmon mee Nahason yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason mee Aminadab yoopaa, Aminadab mee Admin yoopaa, Admin mee Arni yoopaa, Arni mee Hezron yoopaa, Hezron mee Peres yoopaa, Peres mee Yehuda yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda mee Yakub yoopaa, Yakub mee Isak yoopaa, Isak mee Abraham yoopaa, Abraham mee Terah yoopaa, Terah mee Nahor yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor mee Serug yoopaa, Serug mee Rehu yoopaa, Rehu mee Peleg yoopaa, Peleg mee Eber yoopaa, Eber mee Salmon yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon mee Kenan yoopaa, Kenan mee Arpaksad yoopaa, Arpaksad mee Sem yoopaa, Sem mee Nuh yoopaa, Nuh mee Lamek yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek mee Metusalah yoopaa, Metusalah mee Henok yoopaa, Henok mee Yared yoopaa, Yared mee Mahalaleel yoopaa, Mahalaleel mee Kenan yoopaa, ");
INSERT INTO auu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan mee Enos yoopaa, Enos mee Set yoopaa, Set mee Adam yoopaa, Adam mee Ogatamee yoopaa. ");
INSERT INTO auu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus mee Roh Kudus esee-aweta kaama Yordan dee kaa kaama peetaaki too ko Roh me Waa badaa maadoota piya taa, one taa see ebo mee maga ugii da kaa eepeegi. ");
INSERT INTO auu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Peemaata kaama Iblis me ni me menaa nayeesi naadi Waa apaadee segee see egapii mée wiya. Kuwa egapii yuwa uduma Yesus naano agiyoo peenaa ma naano taa kemaata naadi ebo. ");
INSERT INTO auu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iblis me Waa asiino, \"Aa Ogatamee Yoopaa yoka mee omaa to mee naano agiyoo kiyaano, daa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus me asiino, \"Ogatamee me kapogee yiba mena ena mee ko kisee: 'Mée tomaa omegee, toogee siyaa kuwa naano agiyoo kaa too se' see menaa ebeamaata yoka se kayiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bedaa kaawaa ena miya Iblis me Yesus badaa maadoota togoo see yoo ena kaa eepakaamaata kaama mée tomaa-tomaa okoo paagoo ebo tookee bagee yuwa ma, okoo me senawii agiyoo-pagiyoo yuwa ma kuwa uduma taka ena deeyaagi. ");
INSERT INTO auu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Wa me Yesus asiino, \"Deede, kuwa esee ebo agiyoo kuwa uduma anii ebo toowoosi naadi ni kaa naekeata, bedaa ni me ede gaayaa bagee yuwa kaa miya anii yaekeata ebo tuyaayaa yoka ");
INSERT INTO auu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","A me anii ebo naekee, naapaagee siwoo siyu ko anii kuwa uduma Aa epoo mée kakiyaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kiya Yesus me asiino, \"Ogatamee me ebeamaata menaa ena mee ko kisee: 'TUHAN Ogatamee Wa too ebo ekee, Wa too yaapaagee siwoo taai' see menaa ebeamaata yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bedaa kaawaa ena ma Iblis me Yesus badaa maadoota Yerusalem magaa kaa eepeegi. Eepeemaata kaama Ogatamee me ee dagii da kaa asipasi yoo eepakaanigi. Yesus kiyoo yiinaageeta tuyaata kaama asiino, \"Aa Ogatamee Yoopaa yoka Aa kagaata magaa da kaa eseande. Ogatamee me kadiipi, ");
INSERT INTO auu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wa me kapogee yiba mena ena agoo yoka, mee ko kisee: 'Ogatamee me aa se pedeo kese naadi Wa me malaikat bagee yuwa paagoo ");
INSERT INTO auu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","\"Waa yagaa pakaa-mokatoo taai\" see kaasiipi, aa omaa to kaa bado kepo ena miya se tukuuniipe' see menaa mee ebeamaata yoka dimi se gaata kagaata eseaniino, daa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus me asiino, \"Ogatamee me kapogee yiba ebeamaata menaa ena mee miya kisee: 'Ikii me Eboo TUHAN Ogatamee mee se gaadee taai' see menaa mee ebeamaata yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Iblis me Waa kisee gaadee semaata wodoo 'Kaagaa ena ma gaadee taapa' see gaagi kiya kenaagoo taa, kenaagoo taa wisintaata peegi. ");
INSERT INTO auu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kiyoo kaama Yesus mee Roh pesee kaa peedoota Galilea wee kaa peemaaga too ko Wa me ukuwanaa, peenaa see menaa yuwa doodoota gebo kaa magaa uduma wegakomeegea. ");
INSERT INTO auu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sembahyang segee see ee yuwa yiba mée topenaa siyaa naaki mée uduma Waa yaapaageekea. ");
INSERT INTO auu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kiyoo kaama Yesus peedoota Nazaret magaa kaa, Waa ebo keta magaa kaa peemaata kaama Sabat naagoo Wa me ukuwageeki-ukuwageeki see see sembahyang segee see ee yiba seemetaa. Waa Ogatamee me kapogee kaa menaa ena eewegaano see naadi yiinaageeyu, ");
INSERT INTO auu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kapoge ena, idukaa nabi Yesaya me menaa manegea. Wa me mee kapogee kegataata kaama mena ena deemaata kaama eewegaano ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"Tuhan me Roh mee Nii ma naatupi, daba bagee yuwa paagoo daamaa menaa eeweganaasi naadi Roh pesee da mee Nii neegi, Ni kaa nakabagekomeegi. ");
INSERT INTO auu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Mée paagoo pooi' see nasimi mee ko one me gadimeta bagee yuwa paagoo 'Ikii daba kiekegataaga yoka koogo pooi' see asenaasi naadi ma, emaa digiyoo see bagee yuwa emaa daamaa yakiyaasi naadi ma, mée me yadaimekomee seta bagee yuwa daba peeyaabuusi naadi ma, bedaa 'Tuhan me epa dimii kuwa eto mee tahun yiba mée paagoo agoo kedaa siyaapi' see menaa kuwa yaweganaasi naadi miya Wa me 'Mée paagoo pooi' see nasimi\" see ebeamaata menaa kuwa Yesus me eewegakomeegi. ");
INSERT INTO auu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kapogee da bebenataata kaama kapoge penee taa see mée to paagoo metaki goo-maneeta kaama animaayu. Mee ee yiba topea bagee uduma Wa kaa too pe-deegea. ");
INSERT INTO auu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wa me okoo asiino, \"Eto kenaagoo ikii nayiitoo sepea kaboo kuwa nabi bagee me menaa yuwa uwa daaga\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Okoo Wa me eewegagi menaa kuwa esee daamaa naadi dimi nagimegea. \"Kaasee? Yusup me yogaa kiya\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Bedaa Yesus me asiino, \"Mée me aawegaa siyaa menaa ena mee taa ma taa ikii me nasiipea, mee ko kisee: 'Aa ko ikiyoo mée yataa kiyaano mée yoka Aa ekaato naa ikiyoo taa kiyaade' see nasiipea, bedaa mena ena mee ko 'Kuwa Aa Kapernaum magaa kaa ukuwanaa seme agiyoo yuwa mée eewegagea kuwa see see nakaa kiyoo, A me magaa kaa miya mée yaukuwaaniyaade' see miya nasiipea. ");
INSERT INTO auu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Anii mikee kisiino ko: Nabi bagee yuwa okoo me magaa kaa bagee me ebo se ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bedaa Anii mikee kisiino ko: Idukaa nabi Elia waa tota kaboo da deka taa, awee too, kisee too tahun wedo ma ebe mee magaa uduma naano agiyoo taa uwaa ebo meta. Kuwa kaboo da Israel magaa kaa kiyoo miyaa apii yuwa eebaa naano agiyoo tapoo omegee, toogee seta kiya, ");
INSERT INTO auu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ogatamee me Elia mee Israel kaa miyaa apii waa ena paagoo pooi see asiino taa kiya apanaa tomaa kaa miyaa apii ena paagoo, Israel gebo kaa magaa, Sidon wee kaa Zarpat magaa kaa kiyoo miyaa apii to mee paagoo too pooi see aseta. ");
INSERT INTO auu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bedaa idukaa miya nabi Elisa tota kaboo da Israel magaa kaa kiyoo pedeo abuu yago bagee mée eebaa tota kiya, kuwa bagee yuwa mée ena ma abuu yataa kiyaano taa kiya apanaa tomaa kaa bagee ena, Siria wee kaa mée Naaman mee too abuu yataa kiyaata, see kuwa daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wa me asigi menaa kuwa kaa kiyoo sembahyang segee see ee yiba yiitookea bagee kuwa uduma esee kagoo ebo kegea. ");
INSERT INTO auu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Okoo yiinaageeta kaama Waa mee magaa kaa kaama amoo-tapu-tapu sedoota egoo tamekumiino see naadi peegea ");
INSERT INTO auu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kiya Waa koogo mée yupii da taa daba pe-seomigi. ");
INSERT INTO auu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesus peedoota Galilea wee kaa magaa ena, Kapernaum magaa kaa peemaata kaama Sabat naagoo yoka sembahyang segee see ee yiba kaama mée tupiino menaa eewegagi naaki ");
INSERT INTO auu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","okoo dimi nagimegea. \"Sooi, mée tupiino ko omaago ma mée tupigi\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kuwa kaboo da taa ko mee ee yiba paa agoo see mée ena tupi. Wa me mena ebo kaa ");
INSERT INTO auu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","\"Ei, Yesus, Nazaret magaa kaa Mée, Aa ma inii mapea menaa agoo? Inii mée umina pedeo kiyaano see naadi mege ye? Aa mee ko anii kanekeenega. Aa ko Ogatamee me kawigintaata pedeo ena ma taa see Mée mee ii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus me omaago ma asiino, \"Aa koogo tooi, wa kaa kaama pooi\" asigi naaki kiyoo topea bagee paagoo kisee ki paa me mee mée to magaa da kaa sepegeata kaama mee mée to kaa kaama peegi. Peegi kaboo mée to boodi kiyaano taa. ");
INSERT INTO auu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kuwa deegea bagee uduma dimi nagimegea. \"Mee kaasee agiyoo? Waa esee pesee, omaago ma menaa. Paa yuwa 'Pooi' see asigi naaki poono too\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wa me koo sipi menaa yuwa doodoota gebo kaa magaa kaa uduma kiyoo-kiyoo eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus mee sembahyang segee see ee kaa paa yaabagaapeata kaama peedoota Simon me ee kaa peemaaga too ko Simon me apimee baayo tani see ikiyoo meanee taaka. Yesus me yadiipi ye naadi asegea. ");
INSERT INTO auu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mee apii to geboo da kaa kaama mena ena wegataagi naaki mee ikiyoo taa keepeasega. Kisee ki anoogeeta naano agiyoo mée yuwa manega. ");
INSERT INTO auu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kenoo to maga kaboo da yibaa taa seomaano see koo taaki see kaboo da ikiyoo tomaa-tomaa meanee taakea bagee mée eebaa Yesus paagoo eemedaakea. Okoo mée ena-ena okoo kaa yagaa pe-maataagi naaki ikiyoo uduma taa kegea. ");
INSERT INTO auu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Paa maamaa eebaa miya mée yiba kaama peedaakea, gaayaa naaki paa yuwa me mena ebo kaa \"Aa ko Ogatamee Yoopaa\" see asegea. Okoo me 'Mee ko Ebo Kristus yoka' see kuwa ipi kemaata Yesus me okoo mena peenaa ma se wegayaagi. ");
INSERT INTO auu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Omemaayu pedeo tokomaa Yesus peedoota mée taa see yoo peemaata toomuu taaka too ko mée yuwa abanaa naadi meemaagea. Okoo me asiino, \"Aa pookee se, nakaayoo too naatooi\" see maamaa asegea. ");
INSERT INTO auu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kiya Wa me asiino, \"Etokaa daamaa doomega menaa, Ogatamee Wa too ebo mée eetuyaa menaa kuwa Anii apanaa magaa kaa bagee paagoo miya eeweganaa taano gaano pedeo. Kuwa menaa yuwa naweganaa taai see nasimi yoka poonaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Peedoota Yudea wee kaa sembahyang segee see ee yuwa yiba kisee eeweganaa seta. ");
INSERT INTO auu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kaawaa ena Yesus mee Genesaret piku geboo da kaa yiinaageeta totaaki too ko mée eebaa Ogatamee me menaa yiino see naadi Wa paagoo naato-naato aabobee naadi kaama sipintaagea. ");
INSERT INTO auu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Deamaagi too ko koma wiya piku kapaa to kaa topa. Doge abagee see bagee yuwa ea da kaa eseanta kaama jala onee yuwa wetogetaakea. ");
INSERT INTO auu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mée eebaa naadi kaama Yesus koma ena kaa, Simon me komaa da kaa pakaanta kaama \"Peenaa uwo semoo yaato naadogeamaade\" see asigi. Koma kaa animaata kaama tupiino menaa mée yuwa eewegataa. ");
INSERT INTO auu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mena eewegamaata kaama Simon paagoo asiino, \"Doge abaano see yoka piku semoo to kaa naadogeamaai. Peemaata kaama jala onee dooyamaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon me asiino, \"Guru, inii yumakaa kuwa uduma doge abadee taa see awiyaage kiya peedi ena ma, ena ma imi taa kepa kiya A me nasege yoka daamaa, jala onee dooyamaanaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Koma uwo semoo to kaa dogeamaata kaama jala onee dooyamaagea naaki doge maamaa eebaa seemedaa naadi kaama one geaniino see kooka. ");
INSERT INTO auu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Koma ena mee kaa okoo epo abagee see bagee kuwa miya okoo paaya goekii taano see yoka moga meei naadi yagaa begoasegea. Meemaata kaama okoo paaya goekii naadi kaama koma wiya pudii, uwo yiba dugumaano see kooka. ");
INSERT INTO auu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Petrus mee kuwa ukuwaanega yuwa deeta kaama Yesus paagoo kagu sebaata kaama asiino, \"Tuhan, Aa ebo, anii pedeo ukuwataa see mée yoka naekea pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon waa ma enaataa bagee okoo uduma kuwa doge tabaa da eebaa masemaagea kuwa deeta kaama dimi nagimeamookea, ");
INSERT INTO auu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","bedaa waa ma epo doge abagee see bagee wiya, Zebedeus me yogaa Yakobus ma, Yohanes ma ekea miya kisee dimi nagimegea. Yesus me Simon asiino, \"Aa se wedaai. Eto kaama wodoo aa mée naabawoo taape\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Okoo kuwa komaa wiya ea da kaa goemaata kaama okoo me agiyoo-pagiyoo uduma ekeata Wa sekaataa too peegea. ");
INSERT INTO auu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kaawaa ena Yesus maga ena kaa peenaaka too ko bado yagaa kuwa esee pedeo abuu me daa-noota see bagee ena tupi. Yesus deeta kaama Wa paagoo mumo maga kaa esee-ekeata kaama maamaa aseekee kaa \"Neataagi, Aa ede kepa ko ni me abuu kuwa A me nataa kiyaayaa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus me wa kaa yagaa pe-maataata kaama \"Daamaa, a me abuu kuwa taa kaai\" asigi naaki taka ena abuu kisee ki taa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesus me asiino, \"Ani me abuu kataa kiyaaga kuwa mée se asii. Aa koogo peedoota imam bagee paagoo pooi, okoo me daamaa ipiipi kadeesi ke. Abuu kuwa mikee taa kega ii see kadeegea kaboo Ogatamee paagoo kupi-maniino agiyoo kamanisi naadi doo-pooi, idukaa Musa me 'Kisee ukuwaai' see wegata see see. Mée me 'Aa mikee eto abuu taa kega ii' see kuwa kanekeensi naadi kuwa uduma pe-ukuwaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","\"Kuwa menaa yuwa mée se asii\" see asigi kiya kuwa menaa da doodoota kiyoo-kiyoo eewegakomeegi. Mée eebaa Wa me topeekee menaa yiino see naadi medaakea, okoo me ikiyoo deei-deei agiyoo miya nataa kiyaasi naadi megea. ");
INSERT INTO auu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kiya Yesus me Wa too sembahyang taano see naadi mée taa see yoo peegee segee seta. ");
INSERT INTO auu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kaawaa ena Yesus me mée yuwa topetaaka too ko Parisi kaa bagee ma, Musa me menaa mée topetaa see bagee miya kiyoo topea. Okoo Galilea wee kaa magaa ma, Yudea wee kaa magaa ma, Yerusalem magaa miya kuwa maga uduma kaa kaama medaa naadi animaagea. Yesus me mée kaa meanee siyaa agiyoo yataa kiyaasi naadi Tuhan me pesee da Wa kaa topa. ");
INSERT INTO auu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kuwa kaboo da taa ko oogimaata bagee ena wa me omegee see keagee da ma doomegea. Ee yiba Yesus paagoo pe-ekeasiino see naadi 'Ee yiba kametaa seemaakee daamaa, kametaa seemaakee daamaa' kisee abanaakea naaki iyo, ");
INSERT INTO auu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ee yiba mée sipi naadi seemaano naka. Ee to wodoo taa pakaamaata kaama ee kabataagea. Kabataata kaama mee oogimaata mée to wa me ometaa see keagee da ma mée eebaa okoo yaayupii da kaa Yesus Waa tupi yoo yadookomeegea. ");
INSERT INTO auu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus me okoo mikee nagaano dimii mee ebo ii naadi kaama Wa me mee oogimaata mée to asiino, \"Mée yogaa to, a me pedeo yuwa uduma epa kaekeasega. Eto ko aa Ogatamee ma menaa kuwa taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Musa me menaa mée topetaa see bagee ma, Parisi kaa bagee ma okoo kuwa menaa yuwa yiitookea. 'Yaai, kaasee menaa weegi ya? Mée tomaa me pedeo yuwa epa yaekeasiino kuwa Ogatamee Wa me too koo semaayaa, se maa? Wa me wegagi menaa kuwa Ogatamee me be kiyaa menaa yaai' see koogo dimi yiba gaagea. ");
INSERT INTO auu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Okoo me gaagea dimii kuwa Yesus me nekeenta kaama asiino, \"Ikii koogo dimi yiba 'Kaasee mée to yaai' see nagaagea kuwa kaasee kaa ya? ");
INSERT INTO auu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ani me mee oogimaata mée to paagoo 'A me pedeo yuwa epa kaekeasega yoka eto ko aa Ogatamee ma menaa kuwa taa' see menaa mee miya wegayaa, bedaa 'Anoogeeta daamaa peenaa taai' see menaa mee miya wegayaa, ekea paaya. ");
INSERT INTO auu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kiya Mée Yogaa mee Wa me magaa da kaa bagee yuwa okoo Ogatamee ma menaa yuwa mikee yataa kiyaayaa ii see kuwa ikii nanekeensea naadi agiyoo ena kideeyaanaka\" see asigi. Kiyoo kaama Wa me mee oogimaata mée to asiino, \"Ani me kasiino ko: Anoogeeta a me ometaa see keagee da masegeeta ee kaa pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kisee ki taka ena kiyoo topea bagee yuwa deegea kaboo anoogeeta kaama wa me ometaa see keagee da masedoota ee kaa ede ma, ede ma Ogatamee yaapaagee sepegeeki. ");
INSERT INTO auu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kiyoo diitookea bagee yuwa uduma dimi nagimaano ebo, Ogatamee yaapaageekea. \"Eto kenaagoo ebo ae see agiyoo ukuwaandaaka see kuwa deegea\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kiyoo kaama Yesus peedoota amo kaa naa kaa deamaagi too ko mée ena ekaa da ko Lewi mee kiyoo tupi. Waa pajak kepee yamasegee see mée. Wa me kepe masegee yoo animaata totaaki. Yesus me \"Ni sekaataa nameei\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","yiinaageeta kaama kuwa agiyoo uduma ekeata Wa sekaataa peegi. ");
INSERT INTO auu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi me Yesus badaa maadoota wa me ee kaa eepeegi. Eepeemaata kaama naano agiyoo eebaa masemaata kaama eenugi. Pajak kepee yamasegee see bagee yuwa ma, apanaa bagee yuwa miya okoo mée eebaa animaaii naadi okoo paaya naano agiyoo epo enaataa notaakea. ");
INSERT INTO auu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi kaa bagee ma, Musa me menaa mée topetaa see bagee ma okoo me kisee be kaa mena dukumeaweekea. Okoo me Yesus me topenaa see bagee yuwa asiino, \"Ei, kuwa pajak kepee yamasegee see bagee ma, apanaa dimi pedeo see bagee ma kuwa ikii paaya enaataa naano agiyoo notaakea kuwa yaai, kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus me okoo asiino, \"Ikiyoo taa bagee kuwa ikiyoo yadeetaa see bagee paagoo se peeyaa kiya ikiyoo yago bagee too peeyaa. ");
INSERT INTO auu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anii meta mee ko Ogatamee me menaa yayeetaa see bagee yuwa mena ogaano see naadi se kiya dimi pedeo bagee okoo me pedeo yuwa ekeata kaama Ni sekaataa misi naadi meta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Parisi kaa bagee me Yesus asiino, \"Naano agiyoo tapoo toogee taano ma, sembahyang ma, kisee ukuwagee siyaa kuwa Yohanes me topetaa see bagee yuwa me ukuwageekea, Parisi kaa bagee me topetaa see bagee okoo miya ukuwagee see kiya A me topenaa see bagee kuwa se ukuwageekea, naano agiyoo too noogeekea kuwa kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus me asiino, \"Api goeano naagoo naano agiyoo notaa siyaa kaboo paimee ma enaataa tuyaa bagee yuwa paagoo 'Naano agiyoo tapoo niitooi' see asiyaa ye? Taa ");
INSERT INTO auu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kiya mee api goeyaa mée to waa amoo-doge-doge taapea naagoo kaama wodoo too wa me bagee yuwa naano agiyoo tapoo toogee taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesus me ebea-ebea menaa ena mee ko kisee: \"Gipii dokaa ponee ena geageeta kaama nuku see dokaa tokogoo da kaa pee-se kiwiyaa. Kisee kiwiyu ko mee gipii dokaa da mee pedeo kiyaa, bedaa aatabi semaata gipii ponee to miya epo ena, nuku dokaa da miya epo ena see kuwa diino pedeo kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bedaa anggur poo uwoo kuwa otaawee yiba wogeawee siyaa kuwa miya kisee. Gipii see anggur poo uwoo gaayu ko nuku see otaawee yiba se wogeawee siyaa. Kisee wogeawee siyu ko mee nuku see otaawee da mee kipuunta kaama anggur poo uwoo miya goedoo peeyaa, otaawee da miya pedeo kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kisee kiyaa naadi gipii see anggur poo uwoo kuwa gipii see otaawee yiba too wogeawee taano gaano pedeo. ");
INSERT INTO auu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Anggur poo uwoo unu eebaa maagee naadi kaama gii daamaa yoka kuwa uwoo noomaata kaama kuwa unu eebaa taa maagee see anggur poo uwoo, gipii see uwoo kuwa naano be kiyaa. 'Unu eebaa maagee seta uwoo kuwa too daamaa, sikii' see wegayaa\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kaawaa ena Sabat naagoo Yesus mee gandum poo uwaa da taa peetaaki too Wa me topenaa see bagee yuwa gandum poo ukuu yuwa daageeta kaama yagaa da kaa ikii amoo-be naadi noopegeekea. ");
INSERT INTO auu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kiya Parisi kaa bagee me Yesus asiino, \"Yaai, Sabat naagoo yoka ikii me kuwa ukuwagea kuwa daa. Kaasee kaa ukuwagea ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus me asiino, \"Idukaa Daud ma, waa ma enaataa bagee yuwa ma okoo naadi ebo kaa eeukuwata menaa mee ikii diino taa, ewo ye? ");
INSERT INTO auu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mee ko Daud waa Ogatamee me ee yiba seemeta kaama Ogatamee paagoo manegee seta roti magu yuwa masegeeta nota, waa ma bagee miya eenota. Kuwa roti kuwa naano ko imam bagee me too noogee siyaa roti yuwa, apanaa bagee yuwa naano ko daa kiya kisee-kisee taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bedaa Yesus me asiino, \"Mée Yogaa mee Sabat naagoo epoo Mée\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Omegee naadi Sabat naagoo kaawaa ena ma Yesus mee sembahyang segee see ee yiba seemeta kaama mée yuwa topetaa. Mée ena, yagaa enaato boota see mée to kiyoo tupi. ");
INSERT INTO auu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Musa me menaa mée topetaa see bagee ma, Parisi kaa bagee miya kiyoo topea. Okoo me Yesus kaa pedeo menaa yaweganaa taano see dimii agoo yoka Yesus mee Sabat naagoo mée kaa meanee see agiyoo yataa kiyaapi ye naadi tamaata maamaa diitookea. ");
INSERT INTO auu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Okoo me dimii mee Yesus Waa ipi. Wa me mee yagaa enaato boota see mée to asiino, \"Aa anoogeeta nakaayoo meei\" asigi. Anoogeeta Wa paagoo peegi. ");
INSERT INTO auu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesus me okoo asiino, \"Anii kiapaadee see menaa ena agoo. Musa me menaa yiba Sabat naagoo gaayu ko maagiyoo ukuwaano dagu see ebeamaata ya? Daamaa agiyoo ukuwaano mee dagu ye? Pedeo agiyoo ukuwaano mee dagu ye? Mée daamaa kiyaano mee dagu ye? Mée pedeo kiyaano mee dagu ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wa me okoo uduma emaa wugitaga-wugitaga naadi kaama mee yagaa boota see mée to asiino, \"A me yagaa da petaasede\" asigi. Yagaa peto asigi naaki daamaa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Parisi kaa bagee yuwa kagoo ebo. \"Yesus mee inii kaasee naa ukuwaakee?\" see koogo aawegaa seta. ");
INSERT INTO auu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kuwa kaboo da Yesus mee sembahyang taano see naadi pakadoota maga kutuu to kaa Ogatamee paagoo daatooyiba yaato uduma sembahyang taa see. ");
INSERT INTO auu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aweepeasega kaboo Wa me topenaa see bagee yuwa \"Meei\" asigi. Okoo gaasi ma wiya kuwa wigintaata kaama Wa me menaa yadoonaa see bagee yuwa see ekaa muntayu. ");
INSERT INTO auu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Okoo ekaa yuwa ko Simon, Wa me Petrus see ekaa munta, menaamee Andreas, Yakobus, Yohanes, Pilipus, Bartolomeus, ");
INSERT INTO auu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Alpeus yoopaa Yakobus, yape tukuu mée Simon, ");
INSERT INTO auu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakobus yoopaa Yudas, bedaa Yudas Iskariot, Yesus ekegataata kepe masiipi mée. ");
INSERT INTO auu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kuwa bagee wigintaata kaama Waa okoo ma epo enaataa esedoota tadii da kaa eseemaagi too ko mée eebaa topea. Noonaa Wa sekaataa bagee, noonaa má bagee. Okoo maga eebaa kaa bagee. Yudea wee kaa bagee ma, Yerusalem magaa kaa bagee ma, maakaa piku gebo kaa magaa wiya Tirus magaa kaa bagee ma, Sidon magaa kaa bagee ma ");
INSERT INTO auu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","okoo Yesus me menaa yiino see naadi ma, ikiyoo nataa kiyaasi naadi ma kiyoo yigimemaagea. Paa yago bagee miya topea. Wa me paa yuwa \"Pooi\" asiyaa naaki peegea. ");
INSERT INTO auu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wa kaa pesee agiyoo kuwa me okoo kaa meanee seta agiyoo uduma yataa kiyaabuuki yoka mée uduma Waa yaadeega naaki ou naadi peneasiino see kookea. ");
INSERT INTO auu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus me Wa me topenaa see bagee yuwa emaa wugitaata kaama aseta menaa da kisee: \"Ikii daba see bagee kuwa daamaa, ikii ko Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa eetuyaa bagee yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ikii eto kiipaa naadi kegea bagee yuwa daamaa, ikii bekataa, pesee kaatagea yoka ede nao. Ikii eto yegee taakea bagee yuwa daamaa, ikii kea seamoo taatagea yoka ede nao. ");
INSERT INTO auu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ikii Mée Yogaa mee yaato bagee kemaata mée me kibe kaano ma, kiwigintagaano ma, kiwisineano ma, ikii pedeo ekaa yago bagee yoka naadi kibadiino ma kuwa kikoo taapea kuwa koosi, ede nao. ");
INSERT INTO auu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mikee, ikii koogo makii taa see kaa toowoo setaa to mokoo da mee ebo, epoo to wodoo topa yoka mée me ikii pedeo kikiyaayaa naagoo ede ma, ede ma wanea-wanea, otoo-otoo taai. Mée me kisee pedeo kiukuwagee taapea kuwa ko idukaa okoo me bagee me miya nabi bagee eboo yuwa maa diya kisee pedeo yaukuwagee siwoo seta yoka dimi se nagimaai. ");
INSERT INTO auu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kiya ikii eto kiipaa kepe yago bagee kuwa yaai, ikii me ede kiyaa agiyoo kuwa masemaagea yoka sikii, kaama taa. ");
INSERT INTO auu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ikii eto kiipaa naano agiyoo bekataa, pesee see bagee kuwa yaai, epeekaa ko ikii naadi kiwoo taatagea. Ikii eto kiipaa kea segee see bagee kuwa yaai, ikii dimi gaagaa, yegee siwoo taatagea. ");
INSERT INTO auu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mée uduma ikii kiapaagee taa see kuwa yaai. Kuwa kiapaagee taa see bagee kuwa idukaa okoo me bagee yuwa miya nabi poga-poga bagee yuwa yaapaagee seta yoka yaai, daamaa nekeenii.\" ");
INSERT INTO auu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","\"Kiya ikii Ni me menaa nayiitookea bagee kuwa Ni me kisiino menaa mee ko kisee: Ikii ma yape kiyaa bagee kuwa miya epa kaai, ikii be kigaayaa bagee kuwa miya daamaa agiyoo yaukuwaai. ");
INSERT INTO auu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pedeo ayaa kidootaayaa bagee yuwa emaibo ebo masisi naadi yaasii, bedaa kiwegee-wegee siyaa bagee yuwa miya sembahyang yataai. ");
INSERT INTO auu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Naato yaato kona butuu to kaa yagaa kopaa katokoasiyaa bagee kuwa bedaa naato yaato miya katokoasi yoka yaekeasii. Bedaa a me ebo dokaa da kamasiyaa bagee paagoo a me mumaato dokaa da miya daamaa masisi yoka yaekeasii. ");
INSERT INTO auu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kaidimiyaa bagee yuwa uduma daamaa maniino too, mée me kimasiyaa agiyoo kuwa bedaa neesi naadi se asii. ");
INSERT INTO auu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ikii me mée me kisee naukuwagea naaki ou see gaayaa agiyoo kuwa ikii me miya apanaa bagee yuwa paagoo daamaa pee-yaukuwaai. ");
INSERT INTO auu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ikii epa kigaayaa bagee yuwa too epa gaayu ko Ogatamee me kiapaagee siyaa agiyoo da ye? Taa, epa nagaayaa bagee yuwa too epa see dimii mee ko dimi pedeo see bagee miya kisee dimii gaayaa yoka ikii kiapaagee siyaa agiyoo se. ");
INSERT INTO auu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bedaa ikii daamaa agiyoo kiukuwagee siyaa bagee yuwa too ikii me okoo daamaa agiyoo yaukuwagee see kuwa miya kiapaagee siyaa agiyoo da ye? Taa, dimi pedeo see bagee yuwa miya kisee aaukuwagee siyaa yoka ikii kiapaagee siyaa agiyoo se. ");
INSERT INTO auu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bedaa ikii me kepe keedaa maniyaa kuwa ko 'Waa bedaa nakadiipi yoka maniipa' see gaata kaama maniyaa mee miya kiapaagee siyaa agiyoo da ye? Taa, dimi pedeo see bagee miya waa bedaa nakadiipi yoka naadi kaama aamanee siyaa yoka ikii miya kisee dimii se gaai. ");
INSERT INTO auu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Okoo kisee bagee kiya ikii gaayu ko ikii ma yape kiyaa bagee kuwa epa kaai, daamaa agiyoo yaukuwaai. Keedaa maniyaa agiyoo kuwa bedaa se niipi miya koosi yoka naadi daamaa maniino too. Ogatamee Waa dimi pedeo bagee miya, Waa paamee dimi taa see bagee miya kuwa uduma Wa me epa yoka ikii miya kisee mée epa kiyu ko daamaa ukuwataa to mokoo da ebo masiipea, ikii Asii-sege see Mée me yogaanii yuwa kaapea. ");
INSERT INTO auu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ikiitaagi me mée epa kegeeki see see ikii miya mée epa kaai.\" ");
INSERT INTO auu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","\"Ikii me 'Waa kisee mée to, waa kisee apii to' see pedeo-pedeo see kuwa se asii. Ikii kisee se asiyu ko Ogatamee me 'Aa kisee mée to, aa kisee apii to' see kuwa pedeo-pedeo see kuwa se kisiitagi. Bedaa 'Waa pedeo kaano daamaa' see kuwa miya si yawegaai. Ikii kisee si yawegayu ko ikii miya 'Pedeo kaano daamaa' see kuwa miya se kiwegaatagi. Mée me pedeo kikiyaayaa agiyoo kuwa yawisintagaai, epa yaekeasii. Ikii kisee ukuwayu ko ikii me pedeo ukuwata agiyoo yuwa kuwa miya kiwisintaata kaama epa kiekeasiitagi. ");
INSERT INTO auu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mée okoo miya daamaa manii. Ikii kisee maniyu ko ikii miya daamaa masiipea. Ikii me masiipea yuwa kuwa ko ayaa pudii awemaata yuku-yuku naadi bedaa opa topa yuwa miya segea peeyaa mokoo ikii daamaa masiipea. Mee ko ikii miya mée okoo kaa yaukuwayaa see see Ogatamee Wa me miya ikii kaa kisee kiukuwaapi yoka daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus me ebea-ebea menaa ena miya wegagi, mee ko kisee: \"Emaa digiyoo see mée gaayu ko wa keta bedaa emaa digiyoo see mée ena ma eepeeyaa ye? Kisee eepeeyu ko ekea paaya enaataa komo yiba peeyaa, se maa? ");
INSERT INTO auu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mena topetaa see bagee kuwa ebo, okoo me topetaa siyaa mée to mee peedi see kuwa taa. Kiya okoo daamaa tupiwoo naadi kaama sikii, ipi kiyaa wodoo too okoo me topetaa siyaa mée to see see kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ikii me apanaa bagee emaa togoo maga ponee peedii to yadeetaa see kiya kaasee kaa aa ekaato emaa togoo piya tukuu to ebo mee nekeeniino taa ya? ");
INSERT INTO auu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kaasee a me apanaa bagee ena asiino, 'Meede, a me emaa togoo maga ponee peedii to mee kamaseepeasiinaka' see asiyaa kiya aa ekaato emaa togoo ebo mee piya tukuu to mee topa see kuwa nekeeniino taa ya? Yaai, aa mée deebaa see mée to, aa ekaato emaa togoo piya tukuu to mee keta badeepeasii, kaama too aa diino keago kaape yoka apanaa bagee emaa togoo maga ponee peedii to mee yamaseepeasiyaa. ");
INSERT INTO auu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Daamaa piya wodoo to kaa pedeo poo se ekayaa, bedaa pedeo piya wodoo to kaa daamaa poo se ekayaa. ");
INSERT INTO auu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Piya wodoo to daamaa see piyaa miya, pedeo see piyaa miya kuwa poo ota yuwa deeta kaama too yanekeeniyaa. Takuu yago piyaa kaa ara poo se daayaa, takuu yago boo kaa anggur poo se daayaa. ");
INSERT INTO auu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mee mokoo miya ebe kaa wegayaa menaa kuwa dimi yiba gaata-gaata yuwa me too mena wegayaa. Dimi daamaa bagee gaayu ko dimi yiba daamaa menaa eebaa maataata kemaata daamaa menaa too wegayaa. Dimi pedeo bagee gaayu ko dimi yiba pedeo menaa eebaa maataata kemaata pedeo menaa too wegayaa.\" ");
INSERT INTO auu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","\"Ikii me Anii 'Tuhan, Tuhan' see ekaa naweegeekea kiya Ni me kisiyaa menaa kuwa ikii se naukuwataa see kuwa kaasee kaa ya? ");
INSERT INTO auu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kuwa Ni paagoo meemaata kaama Ni me menaa daamaa nayeewoo, naukuwawoo siyaa bagee kuwa okoo kaa ebea-ebea menaa mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kuwa bagee yuwa ee maayaa bagee mokoo. Maga semoo yiba ekegakomeeta kaama oma dagii da kaa ee daamaa maataayaa. Ee maataata kaama ebo uwoo ee to kaa degaaweega naaki ee to daamaa maataata yoka makii taa, bogoa se peeyaa. ");
INSERT INTO auu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kiya Ni me menaa yeegea kiya se ukuwayaa bagee kuwa ko okoo kaa ebea-ebea menaa mee ko kisee: Okoo kabo magaano taa, aii magaa da kaa ee maataayaa bagee yuwa mokoo. Ebo uwoo ee to kaa degaaweega naaki ee to moga kabadoo peeyaa, umina pedeo kiyaa, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus me kuwa menaa kuwa mée yuwa eewegamaata kaama peedoota Kapernaum magaa kaa peemaagi too ko ");
INSERT INTO auu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma kaa bagee eboo ena, okaa yago bagee me eboo tupi. Wa me agiyoo yaokagee see mée ena, wa me esee epa gaataa see mée waa ikiyoo kaa bogaano see koo taaki. ");
INSERT INTO auu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kuwa kaboo da wa me Yesus kaa kaama menaa yeeta kaama wa me Yahudi kaa ebo bagee wiya, wedo paagoo asiino, \"Ikii peedoota Yesus paagoo kisee pe-naasii: 'Ni me agiyoo naokagee see mée mee ikiyoo yataa kiyaase yoka meei see kasigi' see pe-naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Okoo Yesus paagoo peemaata kaama omaago ma yaasiino, \"Wa me kasigi menaa kuwa A me yaukuwaano daamaa. ");
INSERT INTO auu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Waa ko inii Israel bagee epa mée gaataa see mée yoka, bedaa inii me sembahyang segee see ee mee maataame kuwa miya wa me mée tabogetaa see mée yoka daamaa yaukuwaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus ma okoo paaya epo peedoota kaama ekaapa see yoo peemaaga too ko mee okaa yago eboo me wa me epa see bagee yuwa wa me menaa yadoosi naadi \"Yesus paagoo pooi\" see asigi. Okoo Wa paagoo peemaata kaama asiino, \"Eto ko wa me kasigi menaa kuwa ko kisee: 'Neataagi, Aa ko ebo, anii peedi yoka Aa ni me ee yiba nameekee se. ");
INSERT INTO auu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kisee kemaata anii A paagoo kameekee miya pedeo yoka A me mena ena too too nawegatagaai, mee ikiyoo mikee taa kaapi. ");
INSERT INTO auu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mee ko ani asii eboo miya agoo. Okoo me menaa anii yayiino too. Bedaa ani miyoo okaa yago bagee miya topea. Ni me menaa okoo miya nayiino too. Kisee ani me mée waa ena \"Pooi\" see asiyu ko waa peeyaa, bedaa mée ena ma \"Meei\" see asiyu ko miyaa. Anii ni me agiyoo naokagee see bagee paagoo miya \"Kuwa agiyoo kuwa naukuwaai\" see asiyu ko naukuwataa see. Aa miya kisee asiyaa see Mée yoka A me mena me too sikii' see kasigi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus me kuwa menaa yeeta kaama dimi nagimaano ebo kaa ikigi maataata kaama Wa sekaataa bagee yuwa asiino, \"Ani me kisiino ko: Mee mée mee wa too esee miya nao see nagaataa see mée. Israel bagee kuwa mee see see mée ena ma Anii diino taa, Anii ewo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kuwa yaasegea bagee yuwa metaki peedoota ee kaa peemaagea naaki mee agiyoo yaokagee see mée to ikiyoo taa keepeasigi. ");
INSERT INTO auu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Omegee naadi kaawaa ena Yesus ma, Wa me topenaa see bagee yuwa ma, apanaa bagee eebaa kuwa miya okoo paaya epo peedoota Nain magaa kaa ");
INSERT INTO auu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","wagee kenee to kaa peemaagi too ko kiyoo bagee yuwa mée bootaa da doopegeekea. Mee bootaa da ko api miyaa ena me ena too too yogaa, paayogaa yogaa. Okoo kiyoo bagee okoo mée eebaa okooto ma epo enaataa peetaakea. ");
INSERT INTO auu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tuhan me mee apii epa nao naadi \"Aa si yegee taai\" asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Waa peedoota amoo, bootaa da dootaakea keagee da kaa pe-yaadeegi naaki dootaakea bagee yuwa tuguunegea. Wa me asiino, \"Egaanaa da aa eto kiipaa aya andoo pooi\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","taka ena bootaa da anoogeeta kaama mena wegagi. Yesus me okooto paagoo pee-yaekeasigi. ");
INSERT INTO auu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kiyoo topea bagee yuwa uduma dimi oogea naadi Ogatamee yaapaageekea. \"Sooi, ebo nabi bagee ena inii paagoo meemaagi nao\" see asegea. \"Ogatamee inii Wa me bagee daba mée daagimaa peeyaabuu taano see naadi migi nao\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesus me kuwa ukuwapi-ukuwapi menaa doodoota Yudea wee kaa magaa ma, mee gebo kaa magaa ma uduma eewegakomeegea. ");
INSERT INTO auu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kuwa kaboo da uwo mée yatukumeta mée Yohanes mee wa me topetaa see bagee yuwa Yesus me koo senaa seta menaa yuwa doodoota wa paagoo eewegagea. ");
INSERT INTO auu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Wa me topetaa see bagee wiya \"Meei\" asigi. Wa me Tuhan apaadiino menaa ena agoo naadi kaama ekea asiino, \"Ekea peedoota Yesus paagoo kisee pe-naasigii: 'Yohanes me kasiino ko \"Idukaa kaama meetagi see wegawoo seta Mée mee Aa ye, apanaa bagee ena kaata ye?\" see kasigi' see menaa kuwa pe-naasigii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ekea kuwa menaa doodoota Yesus paagoo peemaata kaama asiino, \"Neataagi, wae. Uwo mée yatukumeta mée Yohanes me mena ena 'Pe-naasigii' see mée asigi naadi A paagoo mege. Wa me kasiino ko 'Idukaa kaama meetagi see wegawoo seta Mée mee Aa ye, apanaa bagee ena kaata ye?' see kasigi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kuwa kaboo da Yesus me ukuwaaniyaabuu taaki agiyoo yuwa eebaa, kuwa ko kisee: ikiyoo deei-deei taa see agiyoo yuwa eebaa yataa kiyaabuu sipi, paa yuwa yaabagaapii sipi, emaa digiyoo bagee miya emaa daamaa yakiyaabuu sipi, see kuwa. ");
INSERT INTO auu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kisee kemaata Wa me asiino, \"Ekea me yeetaa, deetaa see yuwa kuwa Yohanes pe-asii. Kuwa ko emaa digiyoo bagee diino keago kedaakea, oogimaata bagee bado petooniyaata daamaa peenaakea, esee pedeo abuu meanee see bagee yuwa abuu taa kedaakea, apa takiinta bagee mena daamaa yeegea, boota bagee aya andoo peegea, daba bagee yuwa paagoo daamaa etokaa menaa kuwa eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dimi wiya taa, Anii mikee nao naadi se naekeasiyaa bagee kuwa daamaa, ede nao. Kuwa menaa uduma Yohanes paagoo pe-asii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohanes me menaa yadoopea bagee yuwa pe-seomegea kaboo Yesus me mée yuwa paagoo Yohanes kaa menaa eewegaano see naadi asiino, \"Ikii ebo mee maga ugii da kaa Yohanes paagoo peegee semea kuwa maagiyoo diino see naadi peegee semea ya? Aii boo kabagaa da bo me maki-makaa taaka see kuwa diino see naadi peegee semea ye? ");
INSERT INTO auu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Taa yoka maagiyoo diino see naadi peegee semea ya? Diino disi see dokaa maanaa see mée ena diino see naadi peegee semea ye? Taa, kisee daamaa dokaa maanaa see bagee kuwa ebo tookee bagee me ebo see ee kaa ede ma, ede ma too omegee, toogee siyaa yoka ");
INSERT INTO auu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ikii maagiyoo diino see naadi peegee semea? Nabi bagee diino see naadi ye? Mikee, waa nabi bagee kiya nabi bagee asii eboo. ");
INSERT INTO auu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kuwa ko Ogatamee me kapogee yiba Yohanes kaa uwa daata menaa ena idukaa ebeamaata, mee ko kisee: 'Ni me menaa naweganaa taano mée ena wa keta pooi see kaasiita, A me poono etaa da mee wa me daamaa kamasiitagi' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ani me kisiino ko: Idukaa kaama eto too mée tomaa-tomaa kuwa uduma Yohanes wa too ebo kiya eto kaama wodoo Ogatamee Wa too ebo mée eetotaa see yoo daba tuyaayaa bagee kuwa uduma ebo. Okoo uduma, esee daba see bagee miya, esee daba see apii miya kuwa uduma Yohanes asii esee ebo kegea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kuwa bagee uduma kuwa menaa yeegea, pajak kepee yamasegee see bagee miya yeegea. Okoo ko Yohanes me uwo yatukumeta bagee yuwa, Ogatamee me ukuwayaa agiyoo yuwa uduma mikee topoo too see kuwa gaayaa bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kiya Parisi kaa bagee yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma kuwa Yohanes me uwo yatukumaano taa see bagee yuwa. Uwo natukumaano kuwa be kemaata Ogatamee me kisee daamaa kiukuwaapa, kisee daamaa kikiyaapa see menaa kuwa miya okoo be. ");
INSERT INTO auu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bedaa Yesus me asiino, \"Etokaa bagee kuwa kaasee bagee yuwa naa ya? Anii okoo kaa ebea-ebea menaa ena mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Okoo ko yoga tabaa da pasar kaa animaata ebaa-ebaa siyaa mokoo. Yoga peedi noonaa me apanaa yogaa yuwa paagoo asiyaa menaa ko 'Inii ikii paagoo kaado kiibaa-baa sepe kiya ikii ede ma, ede ma mée eewasiino miya be, otoo-otoo taano miya be. Bedaa \"Niiyegee taai\" see kisiyaa miya ikii inii ma epo enaataa yegee taano be, ikii me kisee mée wisinegea' see asiyaa. ");
INSERT INTO auu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mee mokoo miya etokaa bagee yuwa me wisineekee too. Mee ko uwo mée yatukumeta mée Yohanes waa naano agiyoo naano dimii too see mée se kiya, anggur poo uwoo miya se notaa kiya ikii me wisinegee semea. 'Waa paa yago mée to' see yawegagee semea. ");
INSERT INTO auu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mée Yogaa mee miya wisinegeekea. Waa ede ma naano agiyoo eenotaa, anggur poo uwoo miya eenotaa see kuwa ikii dimi nagimaakee kaa wegaano, 'Mee mée mee deeweei. Naano agiyoo naano dimii too, uwo miya naano omaago. Pajak kepee yamasegee see bagee ma, apanaa dimi pedeo see bagee ma epo eenotaa see mée to yaai' see yawegageekea. ");
INSERT INTO auu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Etokaa bagee me kisee mée wisinegeekea kiya mée ena me daamaa ukuwanaa siyaa agiyoo kuwa kaa kaama mée me 'Mikee, kuwa ko Ogatamee Wa me ipi dimii kaa yaukuwanaa segeeki agiyoo yuwa ii' see kuwa yanekeeniyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi kaa bagee ena ekaa da ko Simon wa me Yesus asiino, \"Aa ni me ee kaa meei, mée yuwa ma epo enaataa naano agiyoo kaanaanaka yoka\" see asigi. Yesus peedoota ee kaa peemaata kaama okoo ma epo naano see naadi animaayu. ");
INSERT INTO auu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kuwa kaboo da mee magaa kaa pedeo ukuwanaa see apii ena topa. Mée me \"Yesus mee Parisi kaa mée to me ee kaa naano agiyoo okoo paaya notaakea\" see wegagea menaa kuwa wa me yeeta kaama mee ee kaa wunu daamaa see uwoo otaawee ena doomaaga. ");
INSERT INTO auu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesus okoo to kaa meemaata kaama yiinaageeta yegeeka. Yegee uwoo yuwa Yesus me badoo da kaa eseaneeka. Edooyuu yuwa me Wa me badoo da kaa yegee uwoo yuwa yawonakomeeta kaama badoo da kaa ebe duuduuka, wunu daamaa uwoo doompa yuwa miya badoo da kaa yakabagekomeega. ");
INSERT INTO auu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mee Parisi kaa mée to, Yesus meei aseta mée to mee wa me mee apii to me ukuwaga yuwa deegi. Wa me dimi yiba gaano, 'Yaai, Yesus mee mikee nabi bagee naaki mee Waa yaadeeka apii mee ko pedeo ukuwanaa see apii to yaai see nekeeniyaa' see gaagi. ");
INSERT INTO auu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesus me asiino, \"Simon, aa mena ena kasiinaka\" asigi naaki \"Guru, daamaa naawegaai\" asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus me ebea-ebea menaa kaa asiino, \"Mée ena me mée ekea wiya kaa okaayoo ekea kaa agoo see menaa kasiinaka. Kuwa mée wiya kuwa ena ko ebo kepee, ogei me badoo idibi masigi, ena mee gaasi taa badoo (50) too. ");
INSERT INTO auu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Omegee naadi ekea wiya okaayoo yatakeasiino kana, si yakademaayaa yoka kuwa okaayoo ekea paaya wa me yawisintayu, see kuwa. Eto ko mee ebea-ebea menaa yiba kuwa mée wiya ekea me mee okaayoo yawisintaagi mée to mee paamee, epa dimii agoo kiya maamee me paamee, epa dimii mee ebo kiyaa? Aa kaasee gaage?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon me asiino, \"Mee okaayoo eebaa agoo see mée to me okaayoo ebo nawisintaagi nao naadi paamee, epa dimii mee ebo kiyaa\" see asigi. Yesus me asiino, \"A me wegage kuwa mikee wegage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesus me mee apii emaa wugitaata kaama Simon asiino, \"Mee apii mee deede. Anii yumakaa a me ee kaa meemaaga kaboo Ni me badoo yuwa nawetogeano uwoo aa nawugimagaano taa kepe kiya mee apii wa me yegee uwoo yuwa me Ni me badoo yuwa nawetogemaata kaama edooyuu yuwa me nawonakomee sepa. ");
INSERT INTO auu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bedaa Anii meemaaga kaboo a me ebe naduuduu taano miya taa kepe kiya wa me too Anii meemaata kaama kisee too Ni me badoo yuwa kaa se daata maamaa ebe naduuduu sepa. ");
INSERT INTO auu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bedaa a me Ni me mumoo to kaa minyak uwoo peenaa miya nakabageano taa kepe kiya wa me too Ni me badoo yuwa kaa wunu daamaa see uwoo nakabagepa. ");
INSERT INTO auu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kisee kemaata Anii mena ena kasiino ko: Wa me pedeo ukuwanaa seta agiyoo eebaa yawisintaaga kuwa kaa wa me epa nagaano dimii mee ebo. Kiya pedeo agiyoo peenaa too ukuwata see bagee kuwa gaayu ko kuwa peenaa too ukuwata agiyoo yawisintaata kaama wa me paamee naadi epa dimii mee ebo se, peenaa too kiyaa, see kuwa naadi kasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesus me mee apii to asiino, \"A me pedeo ukuwanaa segee sepe agiyoo kuwa umina kawisintaata epa kaekeasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kiyoo Waa ma epo enaataa animaa totaakea bagee yuwa me koogo aawegaa taano, \"Mée me pedeo ukuwata agiyoo yuwa yawisintaata epa yaekeasiino kuwa Wa me se. Waa kaasee mée?\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus me mee apii to asiino, \"A me mikee nao see nagaano dimii mee me eto ko a kaa menaa kuwa taa, daba daagimaa peege yoka koogo pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Omegee naadi Yesus mee ebo magaa kaa miya, peedi magaa kaa miya Wa me daamaa etokaa doometa menaa, Ogatamee Wa too ebo mée eetuyaa menaa kuwa eeweganaaki. Wa me topenaa see bagee gaasi ma wiya miya Wa sekaataa peenaakea, ");
INSERT INTO auu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","api noonaa miya epo enaataa peenaakea. Kuwa apii kuwa ko Wa me paa yuwa ma, ikiyoo, kisee okoo kaa meanee seta agiyoo kuwa miya yataa kiyaata. Ena mee ekaa da ko Maria, waa Magdalena see ekaa miya munta mee. Wa kaa paa petoo yaabagaapeata apii. ");
INSERT INTO auu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ena mee ekaa da ko Yohana, waa Herodes me ee kaa agiyoo yadeetaa see mée Kusa me apimee. Bedaa ena mee ekaa da ko Susana. Apanaa apii noonaa miya agoo. Kuwa apii yuwa okoo me kepee yuwa Yesus ma, Wa me topenaa see bagee yuwa ma okoo me gaano pedeo agiyoo edaasi naadi kepe aii manegee siwoo segee seta. ");
INSERT INTO auu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kuwa kaboo da mee magaa gebo kaa bagee okoo mée eebaa Yesus paagoo kutuukea. Wa me ebea-ebea menaa ena eewegaano ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"Mée ena gandum poo keepa sigimenaa taano see naadi peegi. Keepa sigimenaaka too ko noonaa etaa da kaa eseaneeka. Eseanta kaama mée me bado batagi-patagi naadi bedo yuwa me nootaagea. ");
INSERT INTO auu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bedaa noonaa oma agoo see magaa kaa eseaneeka. Iyaga naaki maga gee kaa kemaata wii kedaaka. ");
INSERT INTO auu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bedaa noonaa miya takuu uwaa yiba eseaneeka. Iyaga kiya boo aatakiika naaki egaapeasega. ");
INSERT INTO auu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mee kaama too noonaa yuwa daamaa magaa kaa eseaneeka. Iyata kaama poo ekaga naaki poo ukuu ogei me badoo ekadaaka, see kuwa\" see wegagi. Kuwa menaa wegamaata kaama bedaa mena ebo kaa \"Apa agoo see bagee daamaa yii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus me topenaa see bagee yuwa me asiino, \"Kuwa A me ebea-ebea menaa kaa wegape menaa kuwa nekeeniino yaato kaasee?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wa me asiino, \"Ogatamee Wa too ebo mée eetuyaa menaa kuwa idukaa kaama awee da kaa kiyaano taa. Eto ikii kuwa menaa daamaa nekeeniino dimii mee kineegi kiya apanaa bagee ipi kiyaano taa. Anii okoo paagoo ebea-ebea menaa kaa eewegageeka mee ko Okoo deegea kiya se deesi naadi, bedaa okoo mena yeegea kiya se nekeensi naadi Anii okoo paagoo ebea-ebea menaa kaa eewegageeka. ");
INSERT INTO auu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mee yumakaa ebea-ebea menaa mee nekeeniino yaato ko kisee: Poo keepa kuwa ko Ogatamee me menaa ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Etaa da kaa eseanee naadi bedo yuwa me nootaagea kuwa gaayu ko Ogatamee me menaa yeeyaa bagee kiya Iblis me okoo mikee nao see gaata kaama daba daagimaa poopea yoka naadi okoo me dimii yiba sigimpea yuwa yamasedoo peeyaa, see ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Oma dagi kaa eseanee siyaa yuwa gaayu ko menaa da yeeta kaama moga ede ma, ede ma masiyaa bagee yuwa mokoo kiya okoo manii da taa yoka okoo maamaa mikee se gaawoo siyaa. Gaadee siyaa agiyoo miyaa kaboo okoo kuwa menaa moga ekeata peeyaa, see ebea-ebea mee. ");
INSERT INTO auu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Takuu uwaa yiba eseanee siyaa yuwa gaayu ko menaa da yeegea kiya omegee, toogee naadi mée me dimi-pami kuwa me mee menaa da dapimeekee. Kuwa ko okoo me umiino, toono yiba gaagaa dimii mee ma, kepe ou, agiyoo ou dimii mee ma, otoopa ede ma, ede ma segee see dimii mee ma kuwa me mee menaa da egadaa naadi kaama okoo poo ekaano taa see wodoo yuwa ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Daamaa magaa kaa eseanee siyaa yuwa gaayu ko menaa da dimi daamaa kaa yeemaata kaama dimi yiba maamaa peneata umiwoo, toowoo siyaa bagee yuwa ebea-ebea. Okoo makii taa, kuwa menaa kisee too doowoo naadi kaama poo daamaa ekadaa siwoo siyaa bagee kuwa, see ebea-ebea menaa mee.\" ");
INSERT INTO auu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","\"Pelita biyaa iyaata kaama otaawee me apumaakee se, mée me ometaa see keagee da miyoo taa aii ekeasiyaa mee miya se kiya mee ee yiba seemiyaa bagee uduma daamaa awee da kaa deesi naadi biyaa maagee yoo pakaa-ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mee mokoo miya idukaa kaama booniwoo seta menaa kuwa uduma awee da kaa kedaa taapa, bedaa mée paagoo eewegaano taa menaa kuwa ipi kiyaabuu taapea. ");
INSERT INTO auu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kisee kemaata ikii me nayeetaa see menaa kuwa daamaa ipiipi nekeenii. Kuwa menaa agoo kiyaa bagee yuwa bedaa noonaa ma masiipea kiya taa kiyaa bagee yuwa okoo me peenaa kiyaa yuwa miya yamasegeeyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kuwa kaboo da Yesus me okooto ma, menaanii yuwa ma kuwa meemaagea kiya mée sipi naadi Wa paagoo poono naka. ");
INSERT INTO auu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mée me Yesus asiino, \"Deede, abaayo ma, agaabee nokaa yuwa ma kuwa meemaata mena kaawegaano see naadi yoo da kaa kadiitoo taakea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kiya Wa me asiino, \"Nibaayo nokaa yuwa ma, neebee nokaa yuwa ma kuwa ko Ogatamee me menaa yayeemaata kaama daamaa yaukuwataa see bagee kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kaawaa ena Yesus ma, Wa me topenaa see bagee yuwa ma epo koma kaa pakaanta kaama \"Piku asii yaato pookee\" asigi. Peedoota ");
INSERT INTO auu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","uwo pikuu da taa peetaaki too Yesus Waa toomoo umpi. Kuwa kaboo da taa ko bo ebo mega. Biku-biku miya ebo kega naaki komaa da uwo pudii sepegeeka. ");
INSERT INTO auu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wa me topenaa see bagee yuwa yaai naadi Yesus maanegea. \"Ei, Tuhan, inii uwo poonakea yoka\" see asegea. Waa anoogeeta kaama \"Koogo sikiinii\" asigi naaki bo siki, biku-biku taa kega. ");
INSERT INTO auu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wa me okoo asiino, \"Ikii kaasee dimi Ni kaa namagaano taa kepea ya?\" see asigi. Okoo weda kaa dimi nagimeamookea. \"Mee kaasee Mée? Wa me omaago ma asigi naaki biku-biku, bo kisee agiyoo kuwa Wa me menaa daamaa yayiino too\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus mee Wa me topenaa see bagee yuwa ma epo enaataa Galilea piku asii yaato Gerasa magaa kaa peemaata kaama ");
INSERT INTO auu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","maayoo kaa eseanigi too ko paa agoo see mée ena migi. Waa idukaa kota kaa bagee kiya eto ee kaa se ometaa, mée ogopa beapa yuwa yiba waa má tago see omegee see mée. ");
INSERT INTO auu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Wa kaa paa maamaa tawagee segee naadi kaama mee mée to omaago kiyaata. Mée me pose onee me gadimeeii naadi diitoo segee see kiya kuwa onee yuwa daatagaa naadi mée taa magaa kaa paa me abaganaa see, waa kisee mée to. Wa me Yesus deeta kaama kataa-kataa sedoota Wa paagoo mumo maga kaa ekeasigi. Yesus me \"Mee mée to ekeata kaama pooi\" asigi naaki mena ebo kaa asiino, \"Ei, Yesus, Asii-sege see Mée Ogatamee Yoopaa. Aa ma anii mapea menaa agoo? Anii yaai-yaai ma, boodi ma kuwa se nakiyaai naadi kasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus me \"A ekaa da maamee ya?\" asigi naaki \"Inii ekaa da ko Legion, Paa Ebo Etaa see ekaa mee\" see asigi. Waa paa maamaa eebaa kemaata kisee asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Okoo me asiino, \"Paa yuwa dooyamoo taa see komoo yiba kitaa seemedaa taai see mée se asii\" see maamaa asegea. ");
INSERT INTO auu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kuwa kaboo da woo kaa naa kaa kuyee da kaa ekena eebaa ebo etaa maga notaakea. Paa yuwa me maamaa aseekee kaa \"Inii kuwa ekenaa kuwa yiba pakaa-seemaanake yoka kitaa mée seemiyaai\" see asegea. Yesus me \"Daamaa, peeweei\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","paa yuwa mee mée to yiba kaama peedaa naadi ekena yuwa yibaa taa pe-seemedaakea. Seemedaa naadi kaama egoowee gidumedoota piku yiba dugumedaakea. ");
INSERT INTO auu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kiyoo ekena munitaa see bagee yuwa me kisee deegea. Okoo yaai naadi kuwa menaa yuwa doodoota mee magaa kaa bagee ma, gebo kaa bagee ma kiyoo-kiyoo eeweganaakea. ");
INSERT INTO auu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mee magaa kaa bagee kaasee ukuwaanega naadi medaakea. Yesus paagoo peemaagea naaki mee paa yaabagaapeasigi mée to doka maataata kaama Yesus me badoo da kaa aii toomuu taaki, taki-takii miya taa kega. Okoo wedaagea. ");
INSERT INTO auu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yumakaa ukuwapi-ukuwapi yuwa deepea bagee yuwa me \"Wa me kisee paa yaabagaapeasigi, kisee daamaa yakiyaagi\" see menaa kuwa eewegagea. ");
INSERT INTO auu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kuwa Gerasa magaa kaa bagee uduma wedaagea yoka Yesus paagoo \"Aa kiyoo se naatooi\" see asegea. Yesus bedaa mee komaa da kaa pakaanta kaama poono see kaboo ");
INSERT INTO auu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","mee paa yaabagaapeasigi mée to me \"Anii miya meenaka\" see menaa maamaa asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kiya Yesus me asiino, \"Ee kaa pooi. Ogatamee me daamaa kaukuwapi menaa kuwa pe-eeweganaa taai\" see asigi. Kisee asigi naadi waa peedoota mee magaa kaa bagee yuwa paagoo kiyoo-kiyoo \"Yesus me kisee daamaa naukuwapi\" see menaa eeweganaa segee seta. ");
INSERT INTO auu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus ma, Wa me topenaa see bagee yuwa ma epo enaataa uwo asii yaato metaki peemaaga too ko mée okoo eebaa topea. Okoo me Yesus mee mani meepi ye naadi maamaa diitookea. Waa meemaagi nao naadi ede kaa Wa paagoo yigimeeiikea. ");
INSERT INTO auu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kuwa kaboo da mée ena, mee magaa kaa sembahyang segee see ee kaa eboo mee Yesus paagoo migi. Wa ekaa da ko Yairus. Yesus paagoo meemaata kaama Wa me badoo da kaa esee-kudiinta maamaa aseekee kaa \"Ni me ee kaa moga meei\" asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wayoopane mee, tahun gaasi ma wiya mokoo ometa see yogaa, wa me ena too too yogaa mee bogaano see kooka yoka moga misi naadi asigi. Kisee asigi naadi Yesus Wa me ee kaa peetaa, mée eebaa miya Wa paagoo me-yigimeeii naadi sipintaagea. ");
INSERT INTO auu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kuwa epo peegea bagee tabaa da api ena miya kitaa peega. Waa tahun gaasi ma wiya kisee too tadaa peegee see apii. Mee meanee see agiyoo kaa kepe uduma dokter paagoo tameepeata kiya mee agiyoo taa kaano taa. ");
INSERT INTO auu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yesus oko yaato kaama Wa me doka otoo to pee-yaadeega naaki taka ena tadaa sikiinega. ");
INSERT INTO auu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mee agiyoo taa kega kaboo Yesus me asiino, \"Maamee me nayaadeegea naa ya?\" asigi kiya okoo me \"Anii se, anii se\" see wegagea. Petrus me asiino, \"Mée maamaa eebaa A paagoo yigimeeii naadi sipintaagea kuwa me\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kiya Yesus me asiino, \"Ni me pesee agiyoo kuwa noonaa peega yoka mée me Anii nayaadeegea ii see kuwa Anii nekeenega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mee apii me Yesus yaadee sepa mee koogo se boonemaayaa naadi weda ebo kaa totomo ma Yesus paagoo esee-kudiinta toomuuka. Wa me mée uduma paagoo asiino, \"Anii kisee agiyoo meanee taaka yoka Yesus yaadeega. Yesus yaadeeyaa naaki taka ena tadaa kuwa sikiinega\" see menaa kuwa ase-maneega. ");
INSERT INTO auu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus me waa asiino, \"Niyoopane, a me mikee nagaano dimii mee me a kaa meanee taa see agiyoo kuwa taa kega, daba daagimaa peege yoka koogo pooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus kuwa menaa asetaaka too ko mée waa ena Yairus me ee kaa kaama meemaagi. Wa me Yairus asiino, \"Ayoopane mee booga yoka wisintagaai, Guru mee a me ee kaa badaa se magaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kuwa menaa yuwa Yesus yeeta kaama Yairus asiino, \"Aa se wedaai, mikee nao see dimii mee too nagaai. Mikee nagaata kaama waa daamaa kaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Muguu naadi Yairus me ee kaa peemaata kaama \"Petrus ma, Yakobus ma, Yohanes ma, okonaka yuwa ma kuwa too ee yiba meei, ikii apanaa yuwa nakaayoo toomuu taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mée okoo uduma yegee seamoo taakea kiya Yesus me asiino, \"Si yegee taai. Waa boopa se, toomoo ompa ke\" see asigi kiya ");
INSERT INTO auu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","okoo me waa umina boopa naadi wisinegea yoo yakeakea. ");
INSERT INTO auu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wa me mee yogaa to yagaa da pe-peneata kaama \"Ukuyogaa peedii to aa anoogii\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","taka ena dimi noogaa da seemeta kaama aya andoo peega. Yesus me asiino, \"Yogaa to naadi kaapa yoka naano agiyoo manii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Okonaka dimi nagimegea kiya Yesus me asiino, \"Kuwa ukuwapa-ukuwapa kuwa mée se asii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus me Wa me topenaa see bagee gaasi ma wiya \"Meei\" asigi. Meemaagea kaboo Wa me pesee agiyoo mantayu, kuwa ko paa yuwa yaabagaapeasi naadi ma, bedaa mée kaa meanee see agiyoo tomaa-tomaa kuwa yataa kiyaabuusi naadi miya mantayu. ");
INSERT INTO auu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yesus me okoo asiino, \"Ikii peedoota mée paagoo Ogatamee Wa too ebo mée eetuyaa menaa eeweganaa taai, ikiyoo yago bagee yuwa miya ikiyoo yataa kiyaabuu senaa taai. ");
INSERT INTO auu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tamo, ayaa, naano agiyoo, kepe, doka wiya, kisee agiyoo kuwa se dogaai. ");
INSERT INTO auu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ee ena kaa peemaata kaama okoo me ikii daamaa badaa kimaapea kepa ko mee ee kaa too eeomegee, toogee taai, apanaa magaa kaa peeyaa naagoo too pooi. ");
INSERT INTO auu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Maga ena kaa bagee yuwa me ikii badaa se kimaayu ko ikii poono kaboo okoo gaamaasi naadi ikii badoo da kaa maga ponee yuwa takadekumii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kisee asigi naadi okoo maga wodegea. Okoo Yesus me daamaa doometa menaa kiyoo-kiyoo eeweganaa seta, ikiyoo yago bagee yuwa miya ikiyoo yataa kiyaabuu senaa seta. ");
INSERT INTO auu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kuwa kaboo da Galilea wee kaa eboo Herodes mee Yesus me dimi nagii-nagii agiyoo ukuwanaa segeeki see menaa yuwa yeegi. Yeeta kaama wa me 'Mee mée mee maamee naa ya?' naadi dimi abaa-abaaki. Kuwa kaboo da mée noonaa me wegaano, \"Mee mée mee ko uwo mée yatukumeta mée Yohanes boomi mee. Waa boota kaama aya andoo peepi kemaata kuwa agiyoo koo senaaki\" see menaa weganaakea. ");
INSERT INTO auu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mée noonaa me wegaano, \"Mee ko nabi Elia mee. Waa bedaa mée paagoo meemaagi yoka\" see menaa weganaakea. Bedaa mée noonaa me wegaano, \"Waa ko idukaa nabi bagee boota kuwa aya andoo peepi mée waa ena\" see weganaakea kemaata ");
INSERT INTO auu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes kuwa menaa dimi nagimigi. \"Idukaa ani me 'Yohanes mumoo to nadaakumii' see asema yoka eto mee kisee agiyoo ukuwanaaki see niiwegagea Mée mee maamee naa ya?\" see asigi. Waa Yesus ma aadeeka naaki ou see dimii gaageeki. ");
INSERT INTO auu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesus me topenaa see bagee okoo Wa me menaa yadoonaa segee naadi kaama meemaagea. Okoo me ukuwanaa sepea agiyoo uduma Yesus eewegagea. Kiyoo kaama Yesus ma okoo yuwa too wiginedoota maga ena ekaa da ko Betsaida magaa kaa peetaaka too ko ");
INSERT INTO auu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","mée eebaa Yesus kitaa peegi naadi obeegea. Yesus me daamaa meei naadi kaama Ogatamee Wa too ebo mée eetuyaa menaa daamaa eewegagi, ikiyoo yago bagee yuwa miya ikiyoo yataa kiyaabuuki. ");
INSERT INTO auu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mee naagoo uwaataa da Wa me topenaa see bagee yuwa gaasi ma wiya meedoota Wa paagoo asiino, \"Uwaapeasega ke, nakaayoo ee taa, bugi taa see magaa yoka kuwa bagee kuwa 'Peedaa taai' see asii, okoo gebo kaa magaa kaa umiino ee ma, naano agiyoo ma kuwa abasi ke\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kiya Wa me okoo asiino, \"Naano agiyoo kuwa ikii me okoo manii\" see asigi. Okoo me \"Nakaayoo inii roti magu idibi, doge imi wiya too topa. Okoo mée eebaa yoka inii apanaa ma pe-edaageeyu too sikii kiyaa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kiyoo kutuukea bagee kuwa mée eebaa, api, yoga se egaa see, paayogaa too lima ribu. Yesus me Wa me topenaa see bagee yuwa asiino, \"Kuwa bagee kuwa kisee naasii: 'Ikii mée wiya ma gaasi kuwa wa too kutuu, mée wiya ma gaasi kuwa wa too kutuu, kisee wa too kutuu, wa too kutuu semaata kaama animagaai' see naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kuwa menaa yaasenaakea naaki kisee kutuu wuditaagea. ");
INSERT INTO auu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wa me kuwa roti magu idibii to ma, doge imi wiya ma kuwa masegeeyu naadi epoo to yaato pakaa-deeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Wa me kuwa roti magu yuwa kabatagaa semaata kaama mée yuwa paagoo yawudikomeesi naadi Wa me topenaa see bagee yuwa goo-maneeyu. ");
INSERT INTO auu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yawudikomeeta kaama okoo uduma naano sikii, bekataa. Kiyoo kaama roti ma, doge ma koga topa ponee-panaa yuwa kuwa Wa me topenaa see bagee yuwa me meeii naadi iduunee ayaa gaasi ma wiya pudii aweamaagea. ");
INSERT INTO auu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kaawaa ena Yesus Wa too sembahyang taaki too Wa me topenaa see bagee yuwa miya Wa paagoo topea. Wa me okoo asiino, \"Mée me Anii maamee see nagaageekea?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Okoo me asiino, \"Mée noonaa me Aa ko uwo mée yatukumeta mée Yohanes boomi mee see kagaageekea, mée noonaa me idukaa nabi Elia mee, mée noonaa me idukaa nabi bagee boota kuwa mée ena aya andoo peemi, see kagaageekea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wa me asiino, \"Kiya ikii gaayu ko Anii maamee see nagaagea?\" see asigi. Petrus me asiino, \"Aa ko Ogatamee me Aa ebo toowoose naadi kawigintaata Mée, Ebo Kristus mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesus me okoo omaago ma asiino, \"Mee ko Ebo Kristus mee see kuwa mée ena ma se naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesus me asiino, \"Mée Yogaa mee Yahudi kaa ebo-ebo yuwa ma, imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me Wa kaa ae-wae siyaayaa agiyoo kuwa maamaa yaukuwaatagea, kisee Waa be kaa wisintaata kaama mée me booyaatagea see kuwa gaano pedeo kiya wedaagoo to naagoo Ogatamee me aya andoo peeyaatagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wa me kiyoo topea bagee uduma asiino, \"Okoo Ni sekaataa nameeno see dimii agoo see bagee kuwa ko okoo me gaata-gaata yuwa too ede see dimii mee wisintaata kaama unu gakata, egapii gakata piya boko ma doowoo see bagee kuwa too Ni sekaataa namiyaa. ");
INSERT INTO auu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kuwa ko okoo ekaato daba toono see naadi okoo me gaayaa-gaayaa yuwa kaa too umiwoo, toowoo siyaa bagee kuwa usiyaato ko umina pedeo kaatagea. Kiya okoo ekaato ekegataata kaama Ni sekaataa namiyaa bagee kuwa okoo booyaa miya okoo usiyaato ko daamaa kaatagea. ");
INSERT INTO auu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Magaa da kaa agiyoo ou see gaawoo siyaa bagee kuwa gaayu ko wa me agiyoo tabaa da eebaa, magaa da kaa se-agiyoo, we-agiyoo uduma epoo mée kiyaayaa miya kiya waa boota kaama umina pedeo kaatagi see kuwa daamaa ye? ");
INSERT INTO auu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kuwa kisega kuwa ko Mée Yogaa mee Wa me malaikat bagee yuwa ma epo enaataa meetagi naagoo Nagamee me pesee da ma enaataa meetagi, Wa disii to ebo kaatagi. Mee naagoo ko okoo Anii ma, Ni me menaa ma kuwa kaa mée paagoo ego weda see bagee yuwa gaayu ko Mée Yogaa mee meetagi naagoo Waa miya okoo kaa ego weda kaatagi yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Anii mikee kisiino ko: Nakaayoo topea bagee yuwa noonaa bogaano taa kaa Ogatamee Wa too ebo mée eetotaaki see kuwa diitagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kuwa menaa wegamaata kaama unu wagoo waa naa omemaata Yesus mee sembahyang taano see naadi Wa me topenaa see bagee yuwa Petrus ma, Yohanes ma, Yakobus ma kuwa wedoo to eepakadoota maga kutuu to kaa. ");
INSERT INTO auu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pakaamaata kaama Waa sembahyang taaka too ko Waa epoo ena gakademaagi. Ebeyumaa da keno kusi-kusii da keenda, Wa me dokaa da miya esee poodee wikiindaaka. ");
INSERT INTO auu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Taka ena Musa ma, nabi Elia ma wiya awee da kaa keta kaama Yesus ma mena eewegagea. ");
INSERT INTO auu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ekea disii to ebo kedaakea. Ekea me Yesus mee Yerusalem magaa kaa peemaata kaama bogaatagi see wegawoo seta menaa kuwa eewegagea. ");
INSERT INTO auu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kuwa kaboo da Petrus ma, waa ma enaataa see bagee wiya ma okoo paaya toomoo ompea kiya antukiinta kaama deegea naaki Yesus Wa kaa diino ebo see agiyoo yuwa wikiindaaka, bedaa kuwa mée wiya miya Wa paagoo yiinaageeta topea see deegea. ");
INSERT INTO auu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kuwa mée wiya poono see koo taakea kaboo Petrus me Yesus asiino, \"Ei, Neataagi, inii nakaayoo epo enaataa kiitoono daamaa yoka kisee Aa ede kiyu ko anii nakaayoo ee peedi wedo kimaatagaanaka, Aa taano ena, Musa taano ena, Elia taano ena\" see asigi. Petrus kisee wegagi kiya nekeeniino taa kaa aii kisee menaa wegagi. ");
INSERT INTO auu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kuwa menaa da wegataaki naaki taka ena sinu yuwa okoo dagii da kaa esee-takiinega, okoo weda ebo kegea. ");
INSERT INTO auu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sinu uwaa da yibaa taa kaama mena wuu da yeegea. \"Mee ko Niyoopaa, Ni me daamaa wigintaata Mée. Wa me menaa too yayeewoo taai\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kuwa menaa wegataagi ko mée taa, Yesus Wa too. Okoo me deepea-deepea yuwa kuwa mée se asegea. ");
INSERT INTO auu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tokoma mee da okoo maga kutuu to apaapa eseemaagi too ko mée eebaa Wa paagoo meemaagea. ");
INSERT INTO auu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mée ena me mena ebo kaa asiino, \"Guru, Aa niyoopaa nadii, waa ni me ena too too yogaa. ");
INSERT INTO auu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Paa tawayaa kaboo yogaa to kataa-kataa taa see, maa da boga-bogaa deemaata kaama dabeedi epogee uditaa, kisee too koo segeeki. Paa me kaagaa eebaa wegee-wegee kisee too se peetaa. ");
INSERT INTO auu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Anii A me topenaa see bagee yuwa paagoo paa yaabagaapeasi naadi maamaa asega kiya okoo iyo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus me asiino, \"Yaai, ikii mikee gaano dimii taa see bagee, dimi koopoo see bagee yuwa nao. Anii ikii ma eebaa kiiompa kiya Anii bedaa unu magoo kisee too dimi apaanta ikii ma kiiomegee taapa naa ya? Mee yogaa to mee nadoomeei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yogaa to eemeemaagea kaboo paa me mee yogaa to magaa to kaa sepegeata kaama me-gapine, pe-gapine siyaagi kiya Yesus me omaago ma \"Paa aa pooi\" asigi naaki yogaa to kaa deemaata agiyoo yuwa taa keepeasigi. Yogaa to badaa maadoota nagamee paagoo pe-ekeasigi. ");
INSERT INTO auu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kuwa deegea bagee yuwa Ogatamee me pesee agiyoo kuwa ebo nao naadi dimi nagimegea. Kuwa bagee yuwa Yesus me koo sipi agiyoo yuwa uduma dimi nagimeamoo taakea kaboo Wa me topenaa see bagee yuwa asiino, ");
INSERT INTO auu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"Eto ko Ni me kisiinaka menaa kuwa ikii daamaa yeemaata kaama ipiipi nekeenii, mee ko Mée Yogaa mee omaago see bagee paagoo yaekegatagaapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kiya okoo kuwa menaa da se nekeenegea, mena nekeeniino yaato awee da kaa yakiyaano taa kemaata nekeeniino taa, bedaa \"Kuwa menaa da kaasee? Mée asii\" see apaadiino kuwa miya wedaagea. ");
INSERT INTO auu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kuwa kaboo da Yesus me topenaa see bagee yuwa okoo me inii maamee naa ebo bagee kepa naadi kaama \"Aa naa ebo ye, nii naa ebo ye?\" kisee aawisi-maawisikea. ");
INSERT INTO auu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kiya Yesus me okoo me ebo kaano dimii kuwa ipi kemaata yoga peedi ena yaageeta Wa geboo da kaa ekeata kaama ");
INSERT INTO auu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Wa me okoo asiino, \"Ikii yoga me dimii masiyaa bagee kuwa mikee ebo kiyaa bagee yoka mee see see yoga peedii to Ni ekaa yiba daamaa badaa maayaa bagee kuwa Anii miya daamaa badaa namaayaa mokoo. Bedaa Anii miya daamaa badaa namaayaa bagee kuwa Anii naisiyaata Mée Waa miya daamaa badaa maayaa mokoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kuwa kaboo da Yohanes me Yesus asiino, \"Guru, yumakaa mée ena me paa yaabagaapeasiino see naadi A ekaa da kaweepi see kuwa inii deepe. Waa inii sekaataa see mée se yoka inii me 'Aa kisee se ukuwaai' see asege\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kiya Yesus me asiino, \"Waa mee ko ikii kiwisiniyaa mée se yoka kisee bagee kuwa ekeasii, ikii yaato bagee yoka se taamege-taamege taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus mee epoo to wodoo badaa maagiino see naadi monaa mee ekaapa yoka Waa Yerusalem magaa kaa pakaano ou see dimii mee ebo. ");
INSERT INTO auu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Waa eta mana kaa pakaamagaapi magaa yuwa kaa \"Yesus meepi yoka ipiipii taai\" see menaa doonaasi naadi bagee yuwa keta pakayaayu. Okoo pakadoota Samaria magaa kaa pakaamaata kaama kisee menaa eewegagea naaki ");
INSERT INTO auu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","okoo Yesus meepi see kuwa be kegea. Waa Yerusalem magaa kaa pakaanaki kuwa be kemaata \"Nakaa kitaa se pakaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wa me topenaa see bagee Yohanes ma, Yakobus ma wiya me yaai, kaasee bagee yuwa naadi Yesus asiino, \"Tuhan, kuwa bagee kuwa biyaa peesi yoka epoo to wodoo kaama 'Biyaa yadookumii, biyaa yadookumii' see kuwa inii aseekee daamaa ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kiya Yesus me ekea yaato ikigi maataata kaama ego-tagoki. ");
INSERT INTO auu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kiyoo kaama okoo epo enaataa apanaa magaa kaa peeta. ");
INSERT INTO auu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Okoo eta pakataaka too ko mée ena Yesus paagoo asiino, \"A me peenaa, omenaa taape kuwa uduma anii miya A sekaataa too peenaa, omenaa taapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kiya Yesus me asiino, \"Woda miya umiino yoo agoo, bedo miya geka agoo kiya Mée Yogaa mee omegee see yoo taa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bedaa Yesus me mée waa ena asiino, \"Ni sekaataa nameei\" see asigi kiya wa me asiino, \"Tuhan, neataagi mee boota kaama daamaa ogo maataata asii too A sekaataa meekee naa daamaa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kiya Yesus me asiino, \"Boota bagee kuwa boota bagee me ogo aamagaasi yoka ekeasii. Aa gaayu ko Ogatamee Wa too ebo mée eetuyaa menaa kuwa pe-eeweganaa taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bedaa mée ena me asiino, \"Tuhan, anii A sekaataa meepa kiya ni me ee kaa bagee paagoo anii poonaka yoka see menaa da keta asigiinaka yoka daba napeeyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kiya Yesus me waa asiino, \"Agiyoo ukuwapegeeka too okaato yaato deetaa see bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa toono iyo, sikii taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kiyoo kaama Yesus Wa me peenaa taano see magaa yuwa kaa apanaa bagee okoo bado wodoo taa gaasi kuwa okoo keta pakasi naadi wigintayu. Maga ena kaa mée wiya, maga ena kaa mée wiya kisee wigintaata kaama okoo pooi see asiino taa kaa ");
INSERT INTO auu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","aseta menaa ko kisee: \"Bugi kaa agiyoo kapoo, maamaa pudii kiya abaano bagee eebaa taa yoka bugi epoo Mée me Wa me bugi kaa agiyoo abaano bagee eebaa peeyaasi naadi asegee taai. ");
INSERT INTO auu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Domba wodaa pooduu yuwa woda nookee kamenoo yuwa paagoo peeyaa mokoo Anii ikii pooi see kisega. ");
INSERT INTO auu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayaa, kepe ayaabu, bado doko, kisee agiyoo kuwa se dogaai. Eta mana kaa aadee taapea bagee ma mena se aawegaa taai. ");
INSERT INTO auu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Peemaata kaama kiyoo ee yuwa yiba pe-seemaano kaboo 'Epao, mee ee kaa bagee Ogatamee ma emee-emee kisiyaasi yoka' see keta asii. ");
INSERT INTO auu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mee ee kaa okoo me anii Ogatamee ma naemee-emee siyaano ou gaayaa bagee agoo kiyu ko kuwa ikii me okoo Ogatamee ma emee-emee siyaasi naadi menaa kuwa okoo paagoo daamaa toopa. Kiya kisee menaa kuwa be see bagee gaayu ko mee menaa bedaa ikii yaato metaki meepa. ");
INSERT INTO auu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ikii daamaa badaa kimaayu ko mee ee kaa too eeomegee taai. Mee ee epoo mée wa me kiinuyaa agiyoo kuwa noogee taai. Mee ko agiyoo yaokagee see bagee okoo me yaukuwataa to mokoo da daamaa masiyaa see see ikii miya daamaa masesea yoka mee ee kaa noogee taai, ee ena kaa, ee ena kaa se omenaa taai. ");
INSERT INTO auu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ikii mée tuyaa yoo peemaata kaama kiyoo bagee me ikii daamaa badaa kimaayu ko okoo me kiinuyaa agiyoo daamaa naai. ");
INSERT INTO auu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kiyoo ikiyoo yago bagee yuwa ikiyoo yataa kiyaabuu taai, 'Ogatamee Wa too ebo kiitoono see kooki' see menaa kuwa eeweganaa taai. ");
INSERT INTO auu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kiya ikii maga ena kaa peemaata kaama kiyoo bagee me ikii badaa se kimaayu ko ee yaayupii da kaa kaama ebo menaa-menaa kaa ");
INSERT INTO auu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Deeweedeei, ikii me mee magaa to mee enaa badoo da kaa tabiinega maga ponee kuwa kitakadekomeege. Kiya Ogatamee Wa too ebo mée eetoono see kooki see kuwa daamaa nekeenii' see menaa kuwa wegakumii. ");
INSERT INTO auu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ani me kisiino ko: Ogatamee me mée wigintagaatagi naagoo mee magaa kaa bagee okoo kaa pedeo yadootagaatagi agiyoo kuwa mikee ebo kaata, apanaa magaa kaa bagee yuwa see see se. Mee naagoo Sodom magaa kaa bagee okoo kaa pedeo yadootagaatagi agiyoo kuwa ebo kaata kiya kuwa eto ikii kibe kaapea bagee kuwa okoo kaa pedeo yadootagaano kuwa ko mee asii esee ebo kaata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bedaa Yesus me asiino, \"Korazim magaa kaa bagee ma, Betsaida magaa kaa bagee ma ikii pedeo kaatagea yoka yaai. Dimi nagii-nagii agiyoo kuwa Anii ikii paagoo koo senaa sepa kiya ikii me pedeo yuwa ekeasiino taa. Kuwa dimi nagii-nagii agiyoo kuwa apanaa bagee me magaa kaa ukuwapa naaki okoo mikee nao see nagaayaa. Kuwa ko idukaa Tirus magaa kaa bagee ma, Sidon magaa kaa bagee ma okoo Ni me ukuwanaa sepa agiyoo kuwa diino taa. Okoo deeta naaki Waa mikee nao see nagaayaa, okoo me pedeo dimii, pedeo agiyoo kuwa yaai naadi ekeata karung see see ponee yuwa maataata kaama aguu miya okoo ekaato kaa widimiyaa. ");
INSERT INTO auu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ogatamee me mée wigintagaatagi naagoo Tirus magaa kaa bagee ma, Sidon magaa kaa bagee ma okoo kaa pedeo yadootagaatagi agiyoo kuwa peedi kaata kiya ikii kaa pedeo kidootagaatagi agiyoo kuwa esee ebo kaata. ");
INSERT INTO auu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bedaa ikii Kapernaum magaa kaa bagee yuwa miya yaai. Ikii me 'Ogatamee me inii epoo to wodoo mée yagaatoo taatagi' see dimii mee gaagea ye? Kisee taa kaata. Ikii gaayu ko boota bagee toogee yoo kitamekumiitagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wa me topenaa see bagee yuwa paagoo asiino, \"Ikii mena naweganaa taapea kaboo ikii me menaa kiyeeyaa bagee kuwa okoo me Ni me menaa miya nayeeyaa mokoo, bedaa ikii miya kiwisiniyaa bagee kuwa Anii miya nawisiniyaa mokoo, bedaa Anii miya nawisiniyaa bagee kuwa Anii naisiyaata Mée Waa miya wisiniyaa mokoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kuwa mée bado wodoo taa gaasi kuwa maga nawigeeta kaama meemaaiikea. Okoo ede ma, ede ma Yesus paagoo asiino, \"Tuhan, inii A ekaa kaa 'Paa yuwa pooi' asiyaa naaki mée yayiino too peedaa sepea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus me asiino, \"Iblis mee bego-bego miyaa-miyaa mokoo epoo to wodoo kaama patagaata eseanigi see kuwa Anii deema. ");
INSERT INTO auu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yeede, ikii otoogiyoo, kidimisi, kisee paa me agiyoo kuwa bado batagimesea naadi Ni me pesee kuwa ikii kaa kineema, bedaa inii ma yape see mée Iblis me pesee agiyoo kuwa daba, peedi yaekeasi naadi pesee kikiyaama. Ikii pedeo kikiyaayaa agiyoo ena ma taa kaapa. ");
INSERT INTO auu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kuwa mikee menaa kiya paa yuwa me ikii me menaa kiyiino too kuwa kaa ikii ede kaakee se kiya epoo to wodoo ikii ekaa yuwa kapoge kaa kiebeamaata topa kuwa kaa ikii ede ma, ede ma siwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kuwa kaboo da Yesus mee Roh Kudus me esee ede kiyaata kaama Wa me asiino, \"Neataagi, Anii kiiboo, paamee see kasega. Aa ko epoo to wodoo Eboo miya, magaa da kaa Eboo miya. Okoo 'Anii ipi yoka' see gaayaa bagee ma, dimi yago see bagee ma okoo paagoo mikee menaa nekeensi naadi dimii mee A me yaboonemaage kiya dimi peedi see bagee yuwa paagoo A me daamaa awee da kaa ipi kiyaabuuke. Mikee, Neataagi, A me kisee daamaa, ede nao naadi yaukuwayaage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","\"Se-agiyoo, we-agiyoo, se-pesee, we-pesee kuwa uduma Neataagi A me Ani kaa naekeata. Yogamee ipi see bagee mée ena ma taa, Nagamee me too ipi. Nagamee ipi see bagee gaayu ko Yogamee me miya Nagamee ipi, Yogamee me ipi kiyaabuu see bagee okoo miya Nagamee ipi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesus mee Wa me topenaa see bagee yuwa yaato ikigi maataata kaama okoo too asiino, \"Kuwa ikii me deeyaa yuwa kuwa ikii daamaa deegea yoka daamaa, ede nao. ");
INSERT INTO auu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ani me kisiino ko: Eto ukuwaandaa taaka agiyoo kuwa ikii deegea, ipi kegea kiya idukaa nabi bagee yuwa ma, magaa da kaa ebo tookee bagee yuwa ma okoo mée eebaa diino taa. Ikii me deegeekea agiyoo kuwa okoo miya deega naaki ou see dimii gaata kiya diino taa, bedaa ikii me yeegeekea menaa kuwa okoo miya yeega naaki ou see dimii gaata kiya yiino taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kaawaa ena Musa me menaa mée topetaa see mée ena me Yesus mee ipi ye, ewo ye naadi yiinaageeta apaadiino, \"Guru, anii iminoo miya, iminoo miya kisee too toowoosi naadi ukuwayaa agiyoo naa maagiyoo ukuwayaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus me asiino, \"Kuwa kaa menaa kuwa Musa me menaa yiba ebeamaata yoka kuwa menaa aa kaasee gaage? Naawegade\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mee mée to me asiino, \"Musa me menaa yiba ko 'A me Eboo TUHAN Ogatamee mee dimi menaa da uduma me esee ou gaai, bedaa a me pesee da ma, a me gaayaa dimii yuwa ma kuwa uduma me miya Waa esee epa kaai' see menaa mee ebeamaata. Bedaa mena ena ma kisee: 'Aa ekaato miya epa kiyaa see see apanaa bagee miya epa kaai' see menaa mee miya ebeamaata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus me asiino, \"A me wegage menaa mee mikee wegage yoka aa kuwa mena kamu wiya kuwa daamaa pe-ukuwawoo siyu ko aa iminoo miya, iminoo miya toowoo taatage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yesus me kisee asigi kiya mee mée to me 'Kuwa menaa uduma waa sikii, waa miya nao' see nagaasi naadi wa me Yesus paagoo mena ena ma apaadiino, \"Kuwa Musa me menaa yiba 'Apanaa bagee miya epa kaai' see menaa kuwa ko anii maamee nuwaa see see bagee epa kiyaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus me asiino, \"Mée ena Yerusalem magaa kaa kaama esedoota Yeriko magaa kaa esetaaki too eta mana kaa peemaagi naaki mée me yuumaanemaata wa me agiyoo-pagiyoo uduma yamasegeegea, mée to miya kopaa dakameamoo naadi boota mokoo ekeata peegea. ");
INSERT INTO auu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kuwa kaboo da imam bagee ena etaawee migi kiya mee dakampea mée to deeta kaama geboo da taa kutuwadoota yamoo-segeki. ");
INSERT INTO auu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bedaa kiyoo kaama Lewi apaa kaa mée ena kitaa migi. Waa miya mee mée to deeta kaama kisee geboo da taa kutuwadoota yamoo-segeki. ");
INSERT INTO auu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kaama too Samaria kaa mée ena peetaaka too kitaa migi. Mee mée to deeta kaama epa nao see gaagi. ");
INSERT INTO auu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Peedoota mee mée to paagoo kuwa kopaa dakampea ebee yuwa wetogeano see naadi minyak uwoo ma, anggur poo uwoo ma kuwa yakabagekomeeta kaama abuu yuwa iye me daamaa yapodatagaa naadi wa me keledai wodaa dagii da kaa eke. Doodoota meekee bagee me omeekee ee ena kaa peemaata kaama mee mée to ee yiba dogeamaata kaama daamaa kosetaa, eetotaa, omemaayu ");
INSERT INTO auu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","tokoma mee da waa poono taa kaboo da ee epoo mée mee ebo kepee wiya mantaata kaama asiino, 'Mee mée to daamaa nadii. Anii bedaa kitaa meeta naagoo a me koga ma yatameape kepee kuwa kakadiita yoka dimi se nagimaai' see aseta\" see kuwa Yesus me ebea-ebea menaa kaa asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus kuwa menaa yuwa eewegamaata kaama mee Musa me menaa mée topetaa see mée to paagoo asiino, \"Anii kaawegapa bagee okoo wedo me mee eta mana kaa dakampea mée to deegea kiya mikee epaagi mée mee maamee naa ya? Aa kaasee gaage?\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","wa me asiino, \"Mee mée to epa kaa daamaa iye-iyee sipi mée to mee\" see asigi. Yesus me waa asiino, \"Mikee yoka eto ko pooi, waa see see aa miya ukuwanaa siwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus mee Wa me topenaa see bagee yuwa ma epo enaataa peedoota maga ena kaa peemaayu. Mee magaa kaa api ena ekaa da ko Marta topa. Yesus mee \"Ni me ee kaa meei\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Waebee ekaa da ko Maria. Maria mee Yesus me badoo da kaa animaata Wa me topetaa see menaa yuwa daamaa yayiitooka. ");
INSERT INTO auu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kiya Marta mee meekee bagee nusi naadi ipiipii taano agiyoo kuwa eebaa yaai naadi ukuwaano dimii too. Wa me Yesus asiino, \"Ei, Tuhan, kuwa ukuwaano agiyoo kuwa ni me too ukuwaano kana, neebee se ukuwataa see kuwa aa diino taa ye? 'Abaaba kaa pe-tabogeai' see naasii\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kiya Yesus me asiino, \"Marta, Marta, aa ukuwaano agiyoo eebaa naadi dimi gaagaake ");
INSERT INTO auu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kiya agiyoo ena too too ukuwaano gaano pedeo. Mee agiyoo mee Maria me eto Ni paagoo ukuwataaka. Ni me menaa nayiino ou dimii mee esee daamaa yoka si yadaayaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesus maga ena kaa kaama sembahyang semaata toomuu taa siyaa naaki Wa me topenaa see bagee ena me asiino, \"Tuhan, sembahyang taano mee Yohanes me wa me topetaa see bagee yuwa tupimi see see inii miya kisee daamaa mée tupii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesus me okoo asiino, \"Ikii me sembahyang taano kuwa ko kisee: Iniitaagi, A ekaa da A too ebo kaekee. A too ebo mée eetoowoo taatage begaa kuwa mani mée yamiyaai. ");
INSERT INTO auu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Egapii gakata naano agiyoo sikii-sikii mée manii. ");
INSERT INTO auu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Inii pedeo mée kiyaata bagee yuwa uduma inii me epa ekeasiyaa see see A me miya inii me pedeo yuwa epa mée yaekeasii. Bedaa inii mée gaadee see yoo mée se peeyaai, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kiyoo kaama Yesus me okoo ebea-ebea menaa ena asiino, \"Ikii waa ena daatooyiba yupigapi peedoota gebo kaa ee kaa kenee to kaa kaama mee ee epoo mée paagoo mena ogaano, 'Mée yogaa to wae, anii roti kemo wedo waa naa kaidimaano see naadi mega. ");
INSERT INTO auu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ni me epa see bagee ena beesekaa kaama meemaata naaumigi kiya eenaano agiyoo ko ena ma, ena ma taa keekee' see asiyaa naaki ");
INSERT INTO auu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ee yiba kaama wa me asiino, 'Mée yogaa to, anii se namaaneai. Kene muntaata ni me yogaa yuwa ma enaataa koogo toomoo ometaake yoka anii anoogeeta kaniino be' see asiyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mee ee epoo mée me kisee asiyaa kiya mikee, waa kiipaa ki anoogeeta kuwa idimpi agiyoo maniyaa. Wa me maniino kuwa ko ekea epa aagaa see bagee wiya kuwa kaa se kiya wa me uu ma idimpi mee me waa anoogeeta wa me gaano pedeo agiyoo yuwa uduma mase-maneeyaa, see kuwa mikee kisega. ");
INSERT INTO auu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kisee kemaata Ani me kisiino ko: Idimiweei, ikii masiipea nao. Abaweei, ikii deemagaapea nao. Kenee to kaa tugu-tugu siweei, kene kikabaapi nao. ");
INSERT INTO auu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kuwa ko idimiyaa bagee yuwa uduma masiyaa, abayaa bagee yuwa deemaayaa, kenee to kaa tugu-tugu siyaa bagee yuwa kene yakabataayaa. ");
INSERT INTO auu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ikii nagaanii yuwa ikii me yogaa me doge kiidimiyu ko doge se kiya otoogiyoo maniyaa ye? ");
INSERT INTO auu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bedo misi kiidimiyu ko kidimisi maniyaa ye? ");
INSERT INTO auu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kisee taa. Ikii dimi pedeo see bagee kiya ikii me yogaa yuwa daamaa agiyoo manegee siyaa. Ikii me yogaa kisee daamaa agiyoo maniino ipi maa diya epoo to wodoo kaama Ikiitaagi me kineewoo siyaa agiyoo kuwa mee asii esee daamaa, Waa idimiyaa bagee yuwa Roh Kudus mee daamaa maniyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kaawaa ena mée ena, paa me peneata kaama mena wegaano naka see mée agoo. Yesus me paa yaabagaapeasigi naaki mena wegaano keago. Kiyoo bagee yuwa dimi nagimegea ");
INSERT INTO auu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kiya mée noonaa me wegaano, \"Waa paa me eboo Beelzebul mee tawata kaama too paa yuwa yaabagaapeasiyaa\" see menaa yawegagea. ");
INSERT INTO auu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bedaa mée noonaa miya Yesus mee kaasee mée to gaadee taano see naadi kaama Wa paagoo asiino, \"Aa mikee kisee Mée ii see kanekeensi naadi agiyoo ena, epoo to wodoo kaama dimi nagii-nagii agiyoo ena mée deeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kiya okoo me gaayaa dimii kuwa Yesus me ipi kemaata kaama ebea-ebea menaa kaa asiino, \"Maga ena kaa bagee okoo aawisi-maawisi siyu ko mée ukubaanta kaama asii se pesee kiyaa, okoo pedeo kiyaa. Bedaa ee ena kaa bagee miya okoo aawisi-maawisi siyu ko aapataga naadi kaama se pesee kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mee mokoo miya paa tabaa da aawisi-maawisi siyu ko mee asii se pesee kiyaa. Ikii me Anii 'Paa me eboo Beelzebul mee tawata kaama paa yaabagaapii siyaa' see menaa nawegageekea yoka Anii kiapaadee see menaa ena agoo, mee ko Iblis me wa kaa tabogetaa see paa yuwa abagaapeasiyu ko kuwa paa yuwa kaasee pesee kiyaa? Iyo, ebo se tuyaa. Paa yuwa uduma ukubaanta kaama dabaa kedaa siyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ikii me Anii 'Beelzebul mee tawata kaama too paa yaabagaapii siyaa' see menaa naweganaakea kiya ikii yaato bagee yuwa me mapeagiyoo pesee kaa paa yaabagaapii siyaa ya? Ikii yaato bagee okoo me miya Anii see see Ogatamee me pesee kaa paa yuwa yaabagaapii siyaa, se maa? Mikee yoka ikii me nakobanaakea menaa kuwa makapaa menaa too see kuwa ikii yaato bagee me too kisiyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eto ko Anii paa yuwa yaabagaapii siyaa mee ko Ogatamee me kepo tamo me, Wa me pesee kaa kemaata kaama eto kiipaa Ogatamee Wa too ebo mée eetoono kuwa ikii paagoo ukuwaandaa taaka ii see kuwa daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Bedaa Yesus me asiino, \"Pesee see bagee ena me ni me agiyoo-pagiyoo yuwa mée me namasiipea naadi okaa, mowai kisee agiyoo eebaa masegeeta kaama wa me ee kaa diitoo siyu ko wa me agiyoo yuwa se masemaayaa, daamaa tuyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kiya esee pesee see mée ena meemaata kaama mee mée to daba, peedi ekeasiyu ko kuwa okaa, mowai kisee agiyoo yuwa ma, wa me ee kaa agiyoo-pagiyoo yuwa miya uduma yamasegeeta kaama wodeepi-wadaapi siyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Anii ma epo enaataa eeukuwaano be see bagee kuwa ko Anii nawisintaa see bagee yuwa too, bedaa Anii ma epo enaataa niikutumeeii taano be see bagee kuwa miya mée peeda-paada nasiyaayaa bagee yuwa too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Bedaa Yesus me wegaano, \"Paa kuwa mée yiba kaama yaabagaapeata kaama uwo taa see maga ugii da taa ometaa, totaa see yoo abanaa siyaa kiya se deemaayaa. Deemagaano taa naadi kaama 'Bedaa ni me toogee sepa yoo metaki poonaka' see gaayaa. ");
INSERT INTO auu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Peedoota mee ee kaa peemaaga naaki mée taa, daamaa gekedeepeata kaama kuwa ee kaa agiyoo daamaa wiginemaata topa see deeyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Daamao, imi taa naadi kaama peedoota apanaa esee pedeo see paa petoo waa naa badaa maageeta kaama mee mée to yiba kiyoo toogee siyaa. Kiyoo toogee naadi kaama mee mée to pedeo kiyaayaa. Petamanii paa yaabagaapeasiino taa kaboo wa me umiino, toono pedeo too kiya eto mee kaama asii wa me umiino, toono kuwa mee asii esee pedeo kedaa siyaa\" see menaa eewegagi. ");
INSERT INTO auu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus me kuwa menaa mée yuwa eewegataaki too ko kiyoo apii ena me ebo menaa kaa asiino, \"Aa kakabata apii mee, Aa ama kaneeseka apii mee daamaa, ede nao\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kiya Yesus me asiino, \"A me kisee wegage kiya Ogatamee me menaa yayeeta kaama daamaa pee-yaukuwataa see bagee kuwa ki mee asii esee daamaa, ede nao see yaapaagee taano daamaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mée eebaa Yesus bobetaata kaama toomuu taakea kaboo Wa me eewegaano, \"Yaai, etokaa tuyaa bagee kuwa esee pedeo dimii, pedeo menaa kaa too umiwoo, toowoo see bagee yuwa. Ikii me Ni paagoo 'Aa mikee kisee Mée ii see kanekeensi naadi dimi nagii-nagii agiyoo ena mée deeyaai' see nasegeekea kiya se kiukuwaapa. Ikii me Aa mikee kisee Mée ii see nanekeensea naadi Anii idukaa nabi Yunus wa me ukuwata peeta menaa mee too kiiwegaanaka. ");
INSERT INTO auu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mee ko Yunus mee Ogatamee me wa kaa daamaa yaukuwata agiyoo kuwa kaa Niniwe bagee yuwa dimi nagii-nagii seta. Mee see see mokoo miya Mée Yogaa mee Ogatamee me kisee agiyoo Wa kaa yaukuwaapi naagoo eto kiipaa tuyaa bagee yuwa dimi nagii-nagii taatagea. ");
INSERT INTO auu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bedaa idukaa api ena, yamuyaato maga ena kaa ebo tookee apii beesekaa magaa kiya Salomo wa me dimi ipi kaa menaa kuwa si yeega ou naadi pakata. Si yeega ou dimii gaata kemaata iminookaa Ogatamee me mée wigintagaatagi naagoo mee apii to ma, ikii etokaa bagee yuwa ma aya andoo peedaa seta kaama wa me ikii kaa kiwegaata menaa mee ko kisee: 'Kuwa bagee kuwa ko A me menaa se kayeetaa see bagee yuwa' see menaa kiwegaata. Salomo wa me ipi see dimii mee mikee ebo kiya eto kiipaa Salomo mee asii eboo Mée ena nakaayoo tupi. ");
INSERT INTO auu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bedaa iminookaa Ogatamee me mée wigintagaatagi naagoo Niniwe bagee yuwa ma, ikii etokaa bagee yuwa ma aya andoo peedaa seta kaama okoo me ikii kaa kiwegaatagea menaa mee ko kisee: 'Kuwa bagee kuwa ko pedeo dimii, pedeo menaa ekeasiino taa, Ogatamee ma dimii menaa kaa too se toowoo see bagee yuwa too' see menaa kuwa ikii kaa kiwegaatagea. Idukaa kuwa Niniwe bagee me Yunus me weganaa seta menaa kuwa mikee nao naadi kaama okoo me pedeo dimii, pedeo menaa ekeata Ogatamee ma dimii menaa kaa too toowoo seta. Okoo me kisee ukuwata kiya ikii ko taa yoka kuwa menaa kiwegaatagea. Yunus mee ebo kiya eto kiipaa Yunus mee asii eboo Mée ena nakaayoo tupi. ");
INSERT INTO auu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Pelita biyaa iyaata kaama ee miyoo taa se ekeasiyaa, otaawee me apumaakee miya se kiya mee ee yiba seemiyaa bagee uduma daamaa awee da kaa deesi naadi biyaa maagee yoo pakaa-ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Emaa masii to mee ko peto agoo da mokoo. A me emaa miya daamaa kiyu ko a me maa da yiba miya daamaa awee da kaa kiyaa. Emaa miya pedeo kiyu ko maa da yiba miya digiyoo kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dimi menaa da mee miya kisee yoka gaai. Aa dimi menaa da digiyoo kiyaa naadi dimi menaa da awee da kaa too umiwoo, toowoo taai. ");
INSERT INTO auu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kisee kemaata a yiba awee too, ponee ena ma digiyoo see taa kiyu ko a yiba uduma awee da kaa too kedaa siyaa. Peto agoo da kawogaamaata aa uduma awee da kaa too kawogaamaayaa see see aa miya kisee daamaa awee da kaa too kedaa siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus me kuwa menaa wegamaata kaama toomuu taaki too ko Parisi kaa bagee ena meemaata kaama asiino, \"Ni me ee kaa naano ke meei\" see asigi. Yesus mee ee yiba seemeta kaama naano agiyoo noogee yoo animaayu. ");
INSERT INTO auu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Waa naano agiyoo naano taa kaboo yagaa keta uwo wetogeano taa kemaata Parisi kaa mée to me kuwa daa yaai naadi dimi nagimigi. ");
INSERT INTO auu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kiya Tuhan me asiino, \"Ikii Parisi kaa bagee yuwa me otaawee ma, piring ma kuwa tapaato yaato dimi-dimi uwo wetogetaa see. Ikii mee see see miya ikii kado yaato dimi-dimi deegee see bagee yuwa kiya ikii semoo yiba yaato daa see agiyoo maamaa agoo. Ikii kepe ou, agiyoo ou see dimii mee ebo, apanaa pedeo dimii, pedeo menaa kuwa miya maamaa pudii. ");
INSERT INTO auu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ikii dimi ewo see bagee yuwa yaai. Tapaato yaato ogaataata Mée me semoo yiba yaato miya enaataa daamaa ogaataata, se maa? ");
INSERT INTO auu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ikii semoo yiba yaato yaku taa, daba bagee daamaa aii manii. Kisee manegee siyu ko ikii yiba pedeo kikiyaayaa dimii yuwa uduma taa kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ikii Parisi kaa bagee yuwa pedeo kaatagea nao. Ikii me agoo kiyaa agiyoo yuwa uduma gaaseagoo to mee Ogatamee paagoo manegee siyaa kiya Musa me menaa yiba yawegawoo, yaukuwawoo taano esee gaano pedeo menaa kuwa ikii otoopa eke-bake segee siyaa. Kuwa ko ikii ogei me poo, wedakamu, kisee peedi-paadi agiyoo yuwa miya gaaseagoo to mee dimi-dimi Ogatamee paagoo manegeekea kiya Musa me menaa yiba ebo menaa yuwa kuwa wisintagaa segeekea, kuwa ko mée yupii da taa mena mée yadaakomee siyaa yuwa topoo see menaa kaa too mée yadaakumiino kuwa miya ikii se ukuwageekea, bedaa Ogatamee epa dimii mee miya ikii ko taa see bagee yuwa. Kuwa gaaseagoo to mee Ogatamee manegee taano kuwa daamaa manegee taai kiya kuwa ebo menaa yuwa, kuwa daamaa yayeewoo, yaukuwawoo taano esee gaano pedeo see menaa apanaa yuwa kuwa se gaabuu taai. ");
INSERT INTO auu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ikii Parisi kaa bagee yuwa pedeo kaatagea nao. Ikii ko mée me ebo naekeasiino too ede see gaayaa bagee yuwa. Sembahyang segee see ee yiba mée me nadeesi naadi woopasi ebo bagee me animaayu taa see yoo kiyoo too ikii animagaano ede. Bedaa ikii mée kutuu taa see yoo peenaa siyaa kaboo 'Epao, inii me eboo' see naapaagee taano kuwa miya ede see bagee yuwa yaai. ");
INSERT INTO auu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ikii Parisi kaa bagee yuwa pedeo kaatagea nao. Ikii mée ogoo da mokoo. Kuwa ko boota bagee ogo maataagea kiya semoo yiba boota bagee agoo see kuwa nekeensi naadi agiyoo magaano taa kemaata mée yuwa ewo kaa kitaa peegee naadi pedeo kiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kisee asigi naadi Musa me menaa mée topetaa see bagee ena me Yesus asiino, \"Ei, Guru. A me kuwa Parisi kaa bagee yuwa pedeo menaa asege kuwa A me inii miya pedeo menaa mée asiyaa mokoo yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus me asiino, \"Ikii Musa me menaa mée topetaa see bagee yuwa ikii miya pedeo kaatagea nao. Ikii me mée paagoo 'Kisee-kisee ukuwaano gaano pedeo' see menaa-panaa kuwa ukuwaano kana. Ikii me kuwa menaa-panaa kuwa mée kaa yadootaata kaama mée yuwa ma epo enaataa eeukuwaano be kegeekea. ");
INSERT INTO auu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yaai, ikii Musa me menaa mée topetaa see bagee yuwa pedeo kaatagea nao. Ikii idukaa nabi bagee me menaa kuwa daamaa poga-poga naadi okoo me ogo maagee yoo daamaa ipiipii segee siyaa. Kuwa nabi bagee kuwa idukaa ikii me bagee yuwa me be kaa wogeepeata yoka ");
INSERT INTO auu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ikii me idukaa bagee ma ikii paaya ena dimii, ena menaa see bagee yuwa too. Ikii me bagee yuwa me nabi bagee wogeepii seta, bedaa nabi bagee ogo magagee yoo ikii me ipiipii seta, ikii kisee ukuwawookea yoka ikii miya 'Kuwa nabi bagee wogeepii seta kuwa daamaa yoka' see dimii agoo see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kisee kemaata idukaa Ogatamee me ipi kaa wegata menaa mee ko kisee: 'Anii nabi bagee yuwa ma, Ni me menaa nadoonaa siyaa bagee yuwa ma kuwa Israel bagee paagoo yapeeyaapa. Yapeeyaata kaama noonaa okoo me wogeepii taatagea, noonaa wegee-wegee taatagea' see wegata. ");
INSERT INTO auu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ikii me kisee ukuwaatagea yoka idukaa kaama kuwa pedeo taa see bagee wogeepii siwoo seta menaa kuwa uduma petamanii kaama eto too ikii kaa too kaapa, ikii kaa pedeo dogaapea. ");
INSERT INTO auu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Petamanii wugimaata mée mee ko Habel mee. Wodopasi wugimaata mée mee ko Zakaria mee. Waa Ogatamee me ee to yupii, Ogatamee paagoo agiyoo kupi-manee taa see yoo yaayupii da kaa kiyoo wogeta. Habel ma, Zakaria ma kuwa yaayupi bagee uduma wogeepii siwoo seta menaa kuwa uduma ikii kaa too kaata. Ani me kisiino ko: Kuwa wogeepii seta menaa kuwa uduma ikii etokaa tuyaa bagee yuwa kaa too kaata yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ikii Musa me menaa mée topetaa see bagee yuwa pedeo kaatagea nao. Ogatamee ipi kisi naadi menaa kuwa ikii me mée tupiino taa. Mikee, kunci mee ikii paagoo ekeata kiya ikii kenee to kaa taamege-taamege taa see bagee yuwa too. Ikii miya keneawee se pakaaneekea, bedaa pakaaniinaka ou see gaayaa bagee yuwa miya ikii me taamege-taamege yasegeekea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kuwa menaa asemaata kaama apanaa magaa kaa peeta kaama wodoo kuwa Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma okoo me Yesus maamaa wisiniwookea. Okoo me Yesus paagoo mena maamaa eebaa omaago ma apaadee segeekea. ");
INSERT INTO auu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mee ko okoo me \"Yesus me kisee pedeo menaa mée eewegagi yaai\" see menaa kuwa yaweganaa taano see naadi mena maamaa apaadee segeekea. ");
INSERT INTO auu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kuwa kaboo da mée eebaa, se egamaayaa kutuu naadi mée sipi kaa aabatagi-maabatagikea. Yesus me mée topetaa see menaa kuwa Wa me topenaa see bagee yuwa keta asiino, \"Parisi kaa bagee okoo me ragi yeeyee kuwa ikii gaai. Okoo tapaato yaato ena, semoo yiba yaato ena see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mée me koogo maapetaa see menaa uduma awee da kaa kedaa taapa, bedaa koogo boonemaata menaa yuwa uduma miya ipi kiyaabuu taapea. ");
INSERT INTO auu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kisee kemaata ikii me daatooyiba yaato wegayaa menaa kuwa bedaa egapi yaato awee da kaa yiipea, bedaa ikii ee yiba koogo ebe kaa menaa, poko kaa menaa aasee siyaa menaa kuwa yoo da kaa mena ebo kaa wegakumiipea. ");
INSERT INTO auu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ni me epa see bagee yuwa, wae. Ani me kisiino ko: Mée se wedaai. Okoo má yaato too wugimaayaa, mee kaama asii agiyoo ena ma se ukuwamaayaa yoka se wedaai. ");
INSERT INTO auu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wedaano ko Ogatamee Wa too wedaai. Waa ko má yaato wugimaata kaama neraka biyaa yiba mée tameepeasiyaa see Mée. Mikee, Wa too wedaai, mée kuwa wedaakee se. ");
INSERT INTO auu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mugipo daaya see bedoo mee aii agiyoo, esee peedi see bedoo, imi idibi waa naa enaataa kepe peedi wiya too masiyaa agiyoo da, se maa? Mikee kiya bedo ena too too mee miya Ogatamee me se gaabuu siyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bedaa ikii edooyuu apa uduma miya Wa me daamaa kiegamaata ipi. Ikii ebo, apanaa agiyoo see see se, mugipo daaya see bedoo maamaa eebaa kiyaa miya ikii ma endagii se, kisee Wa me ikii kigaataa see yoka mée se wedaai. ");
INSERT INTO auu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ani me kisiino ko: Okoo mée paagoo weda taa ma 'Anii Yesus sekaataa bagee' see asiyaa bagee kuwa Mée Yogaa mee me miya Ogatamee me malaikat bagee yuwa paagoo 'Waa ko Ni sekaataa nameeno weda taa see mée yoka' see yawegaata. ");
INSERT INTO auu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kiya okoo mée paagoo Anii nawisintaata 'Yesus mee anii ewo see Mée' see nawegayaa bagee kuwa Ani me miya wisintaata Ogatamee me malaikat bagee paagoo 'Mee ko Anii ewo see mée yoka' see yawegaata. ");
INSERT INTO auu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mée Yogaa mee pedeo see yawegaa-wegaa siyaa bagee kuwa uduma Ogatamee me epa ekeasiyaa kiya Roh Kudus mee pedeo see yawegaa-wegaa siyaa bagee kuwa epa se ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mée me ikii kipeneata sembahyang segee see ee kaa eboo yuwa paagoo miya kiipootagea, apanaa eboo yuwa paagoo miya kiipootagea kiya ikii kiipeeyaa kaboo 'Anii kaasee menaa wegaapa, kaasee menaa wegaapa?' see dimii kuwa se abaai. ");
INSERT INTO auu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ikii mena wegaano kaboo 'Kisee wegaai, kisee wegaai' see dimii kuwa Roh Kudus me ikii kisi-manee taapi yoka se gaagaa taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kiyoo kutuukea bagee yuwa mée waa ena me Yesus asiino, \"Guru wae, neawaagi mee enaataagi me daa kepee, daa agiyoo kuwa wa me naawudisi yoka A me nawegaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kiya Yesus me asiino, \"Mée yogaa to, ekea yupii da kaa mena kiwegataa see mée mee Anii se\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aseta kaama bedaa kiyoo topea bagee yuwa paagoo asiino, \"Ikii kepe ou, agiyoo ou kisee ou dimi-pami kuwa nekeenii. Agiyoo tabaa da eebaa kiyaa miya umiino, toono begaa da kuwa daamaa too kaapa se yoka gaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kiyoo kaama Yesus me ebea-ebea menaa ena eewegaano ko kisee: \"Kepe yago mée ena wa me weekee agiyoo yuwa maamaa eebaa iyaga. ");
INSERT INTO auu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wa me dimi yiba gaano, 'Ni me weta agiyoo eebaa kiya maagee yoo sikii taa yoka kaasee naa ukuwaapa?' see gaagi. ");
INSERT INTO auu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bedaa wa me gaano, 'Ni me ukuwaanaka agiyoo eto nekeenega, mee ko ni me daaii, yigimeeii taa see ee kuwa peedi yoka anii kabamaata kaama bedaa wiyaagoo ebo-ebo taanaka. Ebo-ebo taata kaama ni me gandum poo yuwa ma, apanaa agiyoo yuwa ma uduma kuwa ee yuwa yiba magaapa. ");
INSERT INTO auu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Anii kuwa agiyoo uduma awemaata kaama ni me gaawoo taapa dimii mee ko kisee: Ni me maagee sepa agiyoo tabaa da eebaa yoka eto kaama wodoo anii pesee too umiwoo, toowoo taapa, se gaagaa siwoo taapa. Ani me umiino, toono kuwa ede ma, ede ma too noowoo, toowoo siwoo taapa' see gaagi. Wa me kisee gaagi ");
INSERT INTO auu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","kiya Ogatamee me asiino, 'Ei, dimi taa see mée, eto mee digiyoo mee aa bogaape yoka a me ekaato noowoo taano see naadi maagee sepe agiyoo kuwa aa se naape, se maa?' see aseta\" see kuwa Yesus me eewegagi. ");
INSERT INTO auu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bedaa Yesus me asiino, \"Okoo agiyoo-pagiyoo okoo ekaato kaa too yigimeeii taa see bagee kuwa kisee kaata. Kisee bagee kuwa Ogatamee me 'Okoo daba kiyaa bagee yuwa too' see gaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesus me mee ebea-ebea menaa da eewegamaata kaama Wa me topenaa see bagee yuwa paagoo asiino, \"Kisee kemaata ikii me gaano pedeo agiyoo kaa se gaagaa taai. 'Inii maagiyoo naapea, inii maa da kaa maagiyoo magaapea?' see kuwa dimi se nagimaai. ");
INSERT INTO auu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kuwa agiyoo kuwa ebo agiyoo se. Naano agiyoo kuwa ebo maa diya peedi, dimi menaa da mee too ebo, bedaa doka kuwa ebo maa diya peedi, maa da mee too ebo. ");
INSERT INTO auu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Epaawee peenaa see bedoo kuwa deeweei. Okoo keepa weeno miya taa, daaii, yigimeeii taa see ee miya taa kiya Ogatamee me naano agiyoo daamaa manegeeki. Bedo kuwa peedi, ikii ma endagii taa see agiyoo kiya Wa me kisee daamaa manegeeki kemaata ikii miya daamaa kineewoo taapi. ");
INSERT INTO auu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dimi gaagaa see kaa waa ekaato umiino, toono begaa togoo kiyaayaa bagee naa ena agoo ye? ");
INSERT INTO auu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kisee kemaata ikii dimi gaagaa see kaa peedi agiyoo ena miya se agoo kiyaayaa gaayu ko kaasee kaa apanaa agiyoo kaa dimi gaagaa siyaa? ");
INSERT INTO auu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Boo pui kuwa ikii deeweei. Kuwa boo pui kuwa ukuwaano agiyoo miya taa, doka iyaakee miya taa kiya kuwa diino yago. Ani me kisiino ko: Salomo waa senawii ebo, wa me maagee seta dokaa kuwa diino daamaa kiya kuwa boo pui kuwa esee diino daamaa, Salomo me dokaa see see se. ");
INSERT INTO auu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kuwa boo kuwa ebo agiyoo se, eto kenaagoo iyata kaama tokoma mee da badegeeta biyaa kaa yuwitaayaa agiyoo kiya Ogatamee me diino daamaa yakiyaabuu see. Kisee kemaata Wa me ikii me dokaa kuwa miya kuwa boo kuwa asii esee daamaa kiagoo kiyaabuu siwoo taapi, se maa? Ikii dimi gaagaa naadi Ogatamee kaa dimi se maageekea bagee kuwa naa yaai. ");
INSERT INTO auu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","See keta yoo 'Inii maagiyoo naapea, mapea uwoo naapea?' see kuwa se gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kuwa dimii kuwa ko mée tomaa-tomaa uduma kisee gaagaa siyaa dimii yuwa. Ikii me gaano pedeo agiyoo uduma Ikiitaagi mee ipi yoka dimi gaagaa see se ");
INSERT INTO auu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","kiya ikii me Ogatamee Wa too ebo mée eetoono kuwa ou see dimii mee gaawoo taai. Mee kaama ikii me gaano pedeo agiyoo kuwa Wa me kineewoo taapi. ");
INSERT INTO auu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ei, Ni me domba tabaa da ikii se wedaai. Ikii kuwa ko eebaa taa kiya Ikiitaagi Wa me ebo totaa see yoo kiyoo ikii ebo toono komoo kiniino ede kigi yoka se wedaata ");
INSERT INTO auu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ikii me agiyoo-pagiyoo pe-doogeeta kaama masiipea kepee yuwa daba bagee yuwa manii, kisee ikii nekee kepe ayaabu ena agoo kiyaai. Mee kepe ayaabuu to se nuku kiyaa, epoo to wodoo agiyoo ikii masegee siwoo siyaa, kisee too se taa kiyaa. Kuwa agiyoo oma maseekee bagee se masiyaa, dene-dene kuwa miya se nuyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ikii me ou gaayaa agiyoo kuwa kaa too dimi maayaa yoka daamaa nekeenii.\" ");
INSERT INTO auu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","\"Ikii me eboo me agiyoo yaokagee see kaa magaakee dokaa kuwa maawoo, peto wakimiwoo, kisee ikii me eboo miyaa mee maamaa diitoo siwoo taai. ");
INSERT INTO auu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mee ko kisee: Agiyoo yaokagee see bagee kuwa okoo me eboo waa mée me api goetaa see yoo naano agiyoo pe-noogiino see naadi peegi. Waa peeta kaama wodoo okoo me eboo moga meepi ye, epee meepi ye naadi maamaa diitoo, kisee too mee eboo meemaagi. Waa kene tugu-tuguki kaboo okoo moga kene yakabataagea. Mee see see ikii miya kisee daamaa yaukuwaano see naadi maamaa diitoo, ekaato ipiipii siwoo, umiwoo taai. ");
INSERT INTO auu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kisee agiyoo yaokagee see bagee kuwa daamaa, ede nao. Anii mikee kisiino ko: Mee eboo meemaata kaama 'Ikii ko paayaa see dimii taa, daamaa ipiipi nadiitoo siwoo see bagee yuwa yoka naano ke, animaayu taai' see asiipi. Kiyoo kaama agiyoo yaokagee see bagee me magaakee dokaa kuwa wa too maataata kaama naano agiyoo okoo paagoo yawudiipi, kisee yaukuwaapi. ");
INSERT INTO auu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mee eboo mee daatooyiba yupigapi yee, awiino taa kaboo yee meemaata kaama wa me agiyoo yaokagee see bagee yuwa agiyoo daamaa ipiipii semaata nadiitoo taakea see deeyu ko kuwa bagee yuwa daamaa, ede nao, see kuwa mikee kisega. ");
INSERT INTO auu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Daamaa nekeenii: Oma masetaa see mée daatooyiba yaato mee kenoo kaa, mee kenoo kaa meepi see kuwa ee epoo mée ipi naaki ee se nakabasi naadi ipiipi see diitoo siyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mee mokoo miya Mée Yogaa mee meetagi mee ikii se nekeeniyaa kaboo meetagi yoka ikii daamaa ipiipi diitoo siwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus me asiino, \"Tuhan, kuwa ebea-ebea menaa kuwa inii too gaamaasi naadi mée asege menaa ye, mée uduma asege menaa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bedaa Yesus me ebea-ebea menaa kaa eewegaano, \"Agiyoo yaokagee see bagee yuwa kuwa dimi daamaa bagee gaayu ko waa kaasee mée? Mee ko wa me eboo me menaa uduma daamaa yayeewoo see mée, waa dimi ipi kaa too yaukuwagee see mée. Kisee mée to gaayu ko mee eboo me wa paagoo asiino, 'Kuwa agiyoo yaokagee see bagee apanaa yuwa kuwa a me daamaa nadiitoo taai, bedaa naano agiyoo eewudiino kuwa miya a me too' see asiipi. ");
INSERT INTO auu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mee eboo maga nawigeeta ee kaa meemaata deeyaa naaki mee mée to me kuwa agiyoo yuwa daamaa yaukuwataaki yoka mee mée to daamaa, ede nao. ");
INSERT INTO auu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Anii mikee kisiino ko: Mee kaama wodoo wa me agiyoo-pagiyoo uduma 'A me too nadeewoose yoka' see asiyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Agiyoo yaokagee see mée dimi pedeo gaayu ko waa dimi yiba ni me eboo mee moga se meepi yoka naadi kaama kuwa agiyoo yaokagee see bagee apanaa yuwa, paayogaa miya, api miya kuwa kopaa dakamegee taano ma, naano dimii kaa too omegee taano ma, boomagaa see uwoo noogee taano ma, kisee ukuwagee siyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wa me eboo meepi naagoo ewo yoka waa miyaa naagoo mee mée to kopaa dakamemaata kaama Ogatamee si yayeetaa see bagee yuwa dogeamaayaa yoo kiyoo dogeamaapi. ");
INSERT INTO auu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kuwa agiyoo yaokagee see bagee okoo me eboo me aseta menaa yuwa yeegea, ipi kiya waa meeno taa kaboo ipiipii taano taa, wa me menaa kuwa si yaukuwagee siyu ko okoo kopaa dakamaano kuwa ebo kaata. ");
INSERT INTO auu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mée noonaa ko mee eboo me aseta menaa kuwa ewo, yiino taa. Mee eboo meeno taa kaboo okoo miya kopaa dakamiyaa agiyoo ukuwagee seta kiya kopaa dakamaano mee ko peenaa too kaata. Kuwa me kemaata Ogatamee me aseta menaa maamaa yeetaa, maamaa ipi see bagee kuwa okoo paagoo 'Kuwa Ni me kiseta menaa kuwa daamaa naokagee sepea ye' naadi apaadee taatagi, bedaa Wa me agiyoo eebaa naokageesi naadi kaama yaekeata bagee kuwa paagoo miya 'Kuwa Ni me kiekeata agiyoo kuwa koga ma nakiyaagea ye?' see asiitagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","\"Anii meta mee ko magaa da kaa biyaa uwaakumiino see naadi meta. Eto kiipaa miya biyaa peega naaki esee daamaa see gaaga. ");
INSERT INTO auu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Anii boodi abaano ebo kaata, ae-wae siyaa agiyoo yiba natukumiyaa mokoo. Kuwa agiyoo yuwa Anii boodi abaamaata eto totaaka naaki daamaa, ede. Boodi abaano taa kaa Anii be, Anii dimi gaagaa segeeka. ");
INSERT INTO auu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Anii magaa da kaa mée tomaa uduma aaemee-emee siyaano see naadi meta see nagaagea ye? Anii mée aaemee-emeesi naadi menaa doomega se kiya mée aapekadaasi naadi meta. ");
INSERT INTO auu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kuwa ko eto kaama wodoo ee ena kaa mée okoo idibi waa naa tuyaa yoo aawisii taapea. Kisee mée okoo wedo ma apanaa mée ekea wiya ma aawisii taapea. ");
INSERT INTO auu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nagamee ma, paayogaa to ma ekea aawisii taapea, okooto ma, ukuyogaa to ma ekea aawisii taapea, paimee baayo ma, apimee ma ekea aawisii taapea, kisee aapekadaa taapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bedaa Wa me kiyoo topea bagee yuwa asiino, \"Ikii uwaataa da keno seomigi yaato sinu pakaga see deeyu ko 'Deka weepa yoka' see kuwa wegayaa, kaama too mikee deka wiyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bedaa ikii yamuyaato kaama bo pakaga see deeyu ko 'Kenaagoo ko awee kaapa' see kuwa miya wegayaa, kaama too mikee awee kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ikii ipi poga-poga naadi mée deebaa see bagee yuwa yaai. Sinu, bo, kisee agiyoo deeta kaama 'Kisee kaapa, kisee ukuwaaniipa' kuwa ikii ipi see bagee kiya eto kiipaa ukuwaandaa taaka agiyoo kuwa ikii deegea kiya kaasee kaa se nekeenegea ya? ");
INSERT INTO auu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kisee agiyoo ukuwaandaa taaka yoka ikii me 'Kuwa mikee menaa ii' see kuwa kaasee kaa se pekataayaa ya? ");
INSERT INTO auu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Daamaa nekeenii: Aa kakagoo kiyaa mée to me mena pekataa see bagee yuwa paagoo kaapeeyu ko eta mana kaa kaama dimi daamaata kaama moga mena taa kiyaai. Mena taa kaano taa kiyu ko amokiyoo mena pekataa see bagee paagoo kadogeamaayaa. Kiyoo kaama polisi yagaa kaa kapeaniyaata kaama digiyoo ee yiba katameamaayaa. ");
INSERT INTO auu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kisee kiyaa naadi Ani me kasiino ko: Aa kuwa kaidimpi kepee uduma maniyu too mee digiyoo ee yiba kaama aa daba kapeeyaayaa yoka kuwa menaa mani taa kiyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kuwa kaboo da kiyoo topea bagee yuwa me Yesus asiino, \"Galilea wee kaa bagee noonaa Ogatamee me ee kaa Wa paagoo agiyoo kupi-manee taakea kaboo Pilatus wa me okaa yago bagee yuwa me wugimaagea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus me asiino, \"Kuwa Galilea wee kaa bagee wugimaagea kuwa ko ikii me gaano, 'Okoo me pedeo ukuwagee seta agiyoo esee eebaa, apanaa Galilea wee kaa bagee kuwa see see se, kisee kemaata okoo wugimaagea daa' see kuwa ikii gaagea ye? ");
INSERT INTO auu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kisee se gaai. Ani me kisiino ko: Ikii me pedeo yuwa ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo see kuwa se ukuwayu ko okoo see see ikii miya pedeo kaatagea yoka daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bedaa kuwa miyoo taa Yerusalem gebo kaa magaa, Siloam yaato magaa kaa bagee okoo mée gaasi ma wagoo boomea kuwa miya kisee. Mee magaa kaa asii-maga-maga seta ee mee ometa kaama mée tagimeta bagee kuwa naa ikii me gaano, 'Kuwa bagee kuwa esee dimi pedeo bagee, apanaa Yerusalem magaa kaa bagee kuwa see see se, kisee kemaata ukuwaanega daa' see kuwa ikii gaagea ye? ");
INSERT INTO auu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ikii kisee se gaai. Ikii me pedeo yuwa ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo see kuwa se ukuwayu ko okoo see see ikii miya pedeo kaatagea yoka daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kiyoo kaama Yesus me ebea-ebea menaa kaa eewegaano, \"Bugi epoo mée wa me anggur poo bugii da kaa ara piyaa wodoo ena weemaayu. Iyawoo naadi kaama kaawaa ena poo daano see naadi peedoota piya wodoo to kaa peemaata kaama iiyaga-yaga siyaa naaki poo ota ena ma, ena ma taa. ");
INSERT INTO auu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wa me bugi yayaagee see mée to paagoo asiino, 'Anii eto miyoo tahun wedo kuwa mee piyaa mee poo ekapa ye, taa ye naadi kaama deege-deege segeeka kiya poo ota ena ma ekaano taa yoka kaasee ukuwaano see ekeasiino? Maga tuwo kaapa yoka nakubikumii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kiya bugi yayaagee see mée to me asiino, 'Neataagi, eto mee tahun mee too ekeasede. Anii mani yuwa maga daamaa meamaata kaama poo daamaa ekasi naadi agiyoo magaapa. ");
INSERT INTO auu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Magamaata kaama mee tahun mee kaa poo ekadaa siyu ko daamaa, ekeasii kiya poo se ekayu ko koosi, kobeepeasii' see asigi\" see kuwa Yesus me eewegagi. ");
INSERT INTO auu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kaawaa ena Sabat naagoo Yesus mee sembahyang segee see ee yiba mée topetaaka too ko ");
INSERT INTO auu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","api ena kiyoo topa. Waa paa me peneata kaama tahun gaasi ma wagoo omegee naadi doogaa da ituunega, topoo petooniino naka. ");
INSERT INTO auu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus me waa deeta kaama \"Meei\" asigi. Meemaaga kaboo da Wa me asiino, \"A kaa meanta agiyoo mee eto kiipaa ki taa kega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yagaa da mee apii kaa peneasigi naaki taka ena topoo yiinaageega, Ogatamee yaapaageeka. ");
INSERT INTO auu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kisee kiya kiyoo sembahyang segee see ee kaa eboo me Yesus kagoo kigi. Yaai, Sabat naagoo kiya mee agiyoo yataa kiyaagi naadi kaama wa me kiyoo topea bagee yuwa asiino, \"Mée kaa meanee siyaa agiyoo yataa kiyaano kuwa Sabat naagoo se. Kisee agiyoo yataa kiyaano egapii kuwa bedimi topa yoka kuwa egapii kuwa kaa too ikii kaa meanee see agiyoo kuwa kitaa kiyaasi naadi meei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tuhan me waa asiino, \"Ikii dimi ipi poga-poga see bagee yuwa yaai. Ikii me moneekee agiyoo yuwa Sabat naagoo miya ope gokataata uu dee kaa uwo nusi naadi eepeegeekea, se maa? ");
INSERT INTO auu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mee apii mee miya Abraham me asii-kaba-kaba seta apii, Iblis me gadimetaata tahun gaasi ma wagoo omegee seta apii yoka Sabat naagoo yagokataaga kuwa miya daamaa, se maa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kuwa asigi menaa kuwa kaa Yesus kagoo kegea bagee yuwa uduma ego weda kegea kiya apanaa kiyoo topea bagee yuwa okoo Yesus me ukuwanaa see agiyoo kuwa uduma ebo nao naadi esee ede kegea. ");
INSERT INTO auu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus me asiino, \"Ogatamee Wa too ebo mée eetuyaa kuwa Anii ebea-ebea menaa kaa kaasee kiiwegayaa? Eto ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mée ena sesawi poo keepa ena masegeeta wa me bugii da kaa weetayu. Iyaga naaki wodoo to ebo kiwooka siyaa. Kago ebo peeda-paada naadi kaama bedo yuwa kiyoo geka daamaa maagee siyaa. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bedaa Yesus me asiino, \"Ogatamee Wa too ebo mée eetuyaa kuwa Anii ebea-ebea menaa kaa kaasee kiiwegayaa? Eto ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Api ena ragi yeeyee peenaa masegeeta kaama gandum yeeyee eebaa mokoo ebo otaawee yiba sigimekomeeyu. Kuwa agiyoo daamaa enaataa me-gokataga, pe-gokataga naadi kaama eke. Peenaa tookomeeta kaama deeyaa naaki uduma iyadoo pakapa siyaa. Mee mokoo miya Ogatamee Wa too ebo mée eetoono kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus mee Yerusalem magaa kaa taa peetaaki too eta mana kaa ebo magaa kaa miya, peedi magaa kaa miya kiyoo bagee yuwa topepegeeki. ");
INSERT INTO auu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mée ena me asiino, \"Ei, Tuhan, mée peenaa too daba daagimaa pootagea ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesus me kiyoo topea bagee yuwa asiino, \"Ikii sipi see kenee to taa esee omaago ma pakaandee siweei. Ani me kisiino ko: Mée eebaa pakaanega naaki ou naadi pakaandee taatagea kiya pakaaniino ko iyo. ");
INSERT INTO auu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ee epoo mée me yiinaageeta kenee to muntaata kaama wodoo ikii yoo da kaa too kenee to kaa tugu-tugu naadi maamaa aseekee kaa 'Neataagi, apee kene mée yakabatagaai, mée yakabatagaai' see asiitagea. Ee epoo mée me 'Ikii kayoo bagee yuwa? Anii ikii kiewo see bagee yoka' see kisiitagi. ");
INSERT INTO auu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bedaa ikii me asiitagea menaa ko 'Inii ko Aa ma epo naano agiyoo noogee seme bagee yuwa, bedaa A me inii me magaa kaa mée topegee seme, se maa?' see asiitagea. ");
INSERT INTO auu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kiya Wa me 'Ikii kayoo bagee, Anii ikii kiewo see bagee, pedeo ukuwagee see bagee yuwa too kideega yoka peeweei' see kisiitagi. ");
INSERT INTO auu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Iminookaa Ogatamee Wa too ebo mée eetoowoo taatagi naagoo Abraham ma, Isak ma, Yakub ma, nabi bagee yuwa ma kuwa uduma ikii me diitagea kiya ikii ma epo se tootagea, maayoo kaa kitameeyamoo taatagea. Kiyoo ko yege ma, gaagaa ma too totaa see yoo. ");
INSERT INTO auu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kuwa kaboo da Ogatamee Wa too ebo mée eetoowoo taatagi yoo apanaa tomaa kaa bagee yuwa mée eebaa ede ma, ede ma noogee taano see naadi meetagea. Okoo awii yaato kaama miya, uwaa yaato kaama miya, wuyaato kaama miya, yamuyaato kaama miya medaa naadi kaama naano agiyoo noogee yoo animaaii taatagea. ");
INSERT INTO auu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mikee, eto kiipaa peedi kiyaa bagee mée eebaa kuwa iminookaa yaato ebo kedaa taatagea, bedaa eto kiipaa ebo kiyaa bagee mée eebaa kuwa iminookaa yaato peedi kedaa taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kuwa kaboo da Parisi kaa bagee noonaa Yesus paagoo megea. Okoo me asiino, \"Herodes mee kawugiino see dimii agoo yoka Aa apanaa magaa kaa pooi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus me asiino, \"Ikii peedoota mee peeda-paada siyaabuu see kamenoo mee paagoo peemaata kaama kisee naasii: 'Anii eto kenaagoo ma, tokoma miya paa yaabagaapii taano ma, ikiyoo yataa kiyaabuu taano ma kisee agiyoo ukuwapegee taapa. Wedaagoo to naagoo ko Ni me ukuwagee see agiyoo yuwa uduma sikii, ukuwatagaapa, see kasigi' see pe-naasii. ");
INSERT INTO auu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nawugiino dimii agoo kiya eto kenaagoo, tokoma, tokoma mee da miya Anii Yerusalem magaa kaa pakaapa. Nabi bagee wugimagaano mee ko apanaa magaa kaa kaama wugiino iyo, be. Anii mee magaa kaa kiyoo too bogaano gaano pedeo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Bedaa Yesus me wegaano, \"Sooi, Yerusalem, Yerusalem, idukaa nabi bagee yuwa miya ikii me wogeepii siwoo seta, bedaa Ogatamee me ikii paagoo kimiyaata bagee yuwa miya oma kamu me wogeepii seta. Ayam poodu yuwa kidikaa da me dapimemaata kaama daamaa eetuyaa see see Ani me miya kisee maamaa ikii daamaa enaataa kikutumemagaano see dimii agoo kiya ikii me nabe kegeekea. ");
INSERT INTO auu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kisee kemaata daamaa nekeenii: Eto kaama wodoo Ogatamee ikii ma enaataa se kiitoopi. Ani me kisiino ko: Anii peeta kaama wodoo ikii se nadiipea kisee too Anii bedaa meeta. Mee naagoo ko ikii me 'Tuhan ekaa yadoopi Mée mee migi yoka magiyaage!' see naapaagee taatagea\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kaawaa ena Sabat naagoo Yesus mee Parisi kaa bagee me eboo ena me ee kaa naano agiyoo notaaka too ko apanaa kiyoo topea bagee yuwa me Yesus mee tuunuu see agiyoo ukuwaapi ye naadi tamaata maamaa diitookea. ");
INSERT INTO auu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kuwa kaboo da mée ena, wa me yagaa bado yuwa agidaa naadi boodi meanee taa see mée ena meemaata kaama Yesus ikigii to kaa totaaki. ");
INSERT INTO auu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Musa me menaa mée topetaa see bagee yuwa ma, Parisi kaa bagee yuwa ma okoo paagoo Yesus me asiino, \"Musa me menaa yiba Sabat naagoo gaayu ko mée kaa meanee see agiyoo yataa kiyaano mee dagu ye, daa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kiya okoo uduma mena taa, koogo togea. Yesus me mee ikiyoo yago mée to kaa yagaa peneasigi naaki ikiyoo taa kega. Ikiyoo yataa kiyaata kaama \"Koogo pooi\" asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesus me kiyoo topea bagee yuwa asiino, \"Ikii me yogaa yee, moneekee agiyoo yee, komo yiba eseaniyu ko Sabat naagoo miya se gaata kaama kisee ki maseageeyaa, se maa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kiya okoo me asiyaa menaa ena ma taa, iyo. ");
INSERT INTO auu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mee ee kaa naano see naadi mepea bagee kuwa okoo anii ebo bagee yoka naadi kaama ebo bagee me woopasi animagaano komoo yuwa kaa pe-animaaii naadi totaakea. Yesus me kisee deeta kaama okoo tupiino menaa ena asiino ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"Api goeano naagoo 'Naano ke meei' see kasiyu ko aa peemaata kaama ebo bagee me animagaano komoo yuwa wisintayu, kiyoo se animagaai. Aa kiyoo animaayu ko ee epoo mée me apanaa bagee a asii eboo bagee ena 'Naano ke meei' see asiyaa mée ena wa me animagaano komoo a me yaanimaayaa. ");
INSERT INTO auu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ee epoo mée me ekea paaya 'Naano ke meei' see kisimi yoka waa peedoota a paagoo 'Wae, kiyoo ko wa me animagaakee yoo yoka' see kasigi naaki aa ego weda ma gebo kaa aii bagee me animagaakee yoo kiyoo pe-animaayaa. ");
INSERT INTO auu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kisee kiyaa naadi 'Naano ke meei' see kasiyu ko aa ee kaa peemaata kaama gebo kaa aii bagee me animagaakee yoo pe-animagaai. Aa kiyoo animaata kaama ee epoo mée mee peedoota a paagoo kasiino, 'Mée yogaa to, kiyoo se. Woo maa kaa ebo bagee me animagaakee yoo pakaa-animagaai' see kasiipi. Mee kaama kiyoo topea bagee yuwa me aa ebo bagee yoka see kagaayaa. ");
INSERT INTO auu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mee ko okoo ekaato ebo ekee taa see bagee kuwa peedi kaatagea, bedaa okoo ekaato peedi ekee taa see bagee kuwa ebo kaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kiyoo kaama bedaa mee \"Yesus Aa naano agiyoo naano ke meei\" see aseta mée to paagoo Yesus me asiino menaa ko kisee: \"A me apanaa bagee paagoo, egapi yaato miya, daatooyiba yaato miya 'Naano agiyoo naano ke meei' see asenaa taano see gaayu ko a me epa see bagee se asii, aa ma kenagaa miya, a gebo kaa ekaa yago bagee kiyaa miya okoo misi naadi se asii. Okoo me bedaa 'Naano ke meei' see kasiipea, kisee too aa ma ikii too aanoo siwoo taapea yoka okoo aseekee se ");
INSERT INTO auu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","kiya a me 'Naano ke meei' see asiyaa bagee kuwa ko kisee: daba bagee yuwa ma, bagaa-kagaa see bagee yuwa ma, oogimaata bagee yuwa ma, emaa digiyoo see bagee yuwa ma kisee bagee kuwa 'Naano ke meei' see asii. ");
INSERT INTO auu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Okoo me aa miya kaanaano iyo kiya koosi, daamaa, ede nao. Ogatamee me menaa daamaa yayeewoo see bagee aya andoo peeyaatagi naagoo a me kisee daba bagee epa gaataa to mokoo da kaniitagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kuwa Yesus me asigi menaa kuwa Waa ma enaataa nogea bagee ena me yeeta kaama Yesus asiino, \"Ogatamee Wa too ebo mée eetoowoo taatagi naagoo naano agiyoo nuyaa yoo kiyoo eenuyaa bagee kuwa esee daamaa, ede nao\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kiya Yesus me mee mée to asiino, \"Mée ena me mée eebaa naano agiyoo epo enaataa ede ma eenaano see naadi 'Mee naagoo, mee naagoo naano ke meei' see asenaa seta. ");
INSERT INTO auu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mona naagoo ko wa me agiyoo yaokagee see mée paagoo asiino, 'Aa peedoota kuwa miyoo taa mona asenaa sema bagee yuwa paagoo peemaata kaama kisee naasii: \"Naano agiyoo-pagiyoo uduma ipiipii semaage yoka meei see kisigi\" see pe-naasii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Peedoota okoo paagoo kuwa menaa yaasenaaki naaki okoo uduma 'Se meepa, gaano pedeo agiyoo agoo yoka epa naekeasii see pe-naasii' see asegea. Kuwa ko petamanii asigi mée me asiino, 'Anii etokaa maga ena edaamaaga yoka pe-diino gaano pedeo yoka se meepa, epa naekeasii see pe-naasii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Bedaa apanaa ena me asiino, 'Anii sapi wodaa gaasi edaamaaga kuwa pe-diinaka yoka se meepa, epa naekeasii see pe-naasii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bedaa apanaa ena me asiino, 'Anii eto api goemaaga yoka se meepa' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mee agiyoo yaokagee see mée kuwa menaa doodoota wa me eboo paagoo pe-eewegagi naaki kagoo ebo. Wa me agiyoo yaokagee see mée to asiino, 'Aa moga peedoota eta kegaa-pagaa kuwa peenaa naadi kiyoo daba bagee yuwa ma, bagaa-kagaa see bagee yuwa ma, emaa digiyoo see bagee yuwa ma, oogimaata bagee yuwa ma kisee bagee kuwa aii badaa namaagii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wa me kuwa bagee yuwa badaa maageeta kaama mee eboo paagoo asiino, 'Neataagi, a me badaa namaagii see nasege menaa da kuwa kaukuwataaga kiya naano agiyoo notaa see yoo eebaa topa' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mee eboo me asiino, 'Ni me ee kaa mée eebaa pudiisi yoka aa bedaa peedoota yamoo maa kaa mokoo eta kegaa-pagaa yuwa uduma peenaa-paanaa naadi kiyoo tuyaa bagee yuwa paagoo omaago ma \"Naano agiyoo naano ke meei, naano ke meei\" see pe-naaasenaa taai. ");
INSERT INTO auu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ani me kisiino ko: Ani me miyoo taa \"Naano ke meei\" see asema bagee kuwa be kega yoka okoo mée ena ma epo eenaano ko be, se naapea' see aseta\" see kuwa Yesus me asigi menaa. ");
INSERT INTO auu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kuwa kaboo da mée eebaa Yesus sekaataa megea. Waa okoo yaato ikigi maataata kaama asiino, ");
INSERT INTO auu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"Ni sekaataa nameeno see naadi Ni paagoo namiyaa bagee kuwa ko okoo me okonaka, apimee, yogaanii yuwa, okoo kenaa bagee, waa ekaato miya uduma be kaano taa bagee kuwa Ni sekaataa nameeno ko iyo, ");
INSERT INTO auu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","bedaa piya boko ma dootaata Anii naobeedoota booyaa yoo poono be see bagee kuwa miya Ni sekaataa bagee kaano iyo. ");
INSERT INTO auu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ebea-ebea menaa ena ko kisee: Ikii mée ena asii-maga-maga see ee magaano see gaayu ko ee magaano taa kaboo mee ee magatagaano ko ni me kepee sikii kaapa ye, se sikii kaapa ye naadi animaata kaama 'Ee magaano see agiyoo-pagiyoo edaano ko magoo edaayaa, magoo edaayaa?' see keta dimi daamaa gaagaa siyaa, se maa? ");
INSERT INTO auu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kisee daamaa se gaagaa siyu ko ee kaboo da too maataata kaama kepe sikii taa kaa mee asii se maayaa, wisintaayaa. Mee ee kisee aii totaaka kaboo da kuwa kitaa peeyaa bagee yuwa kisee yadeeta kaama wisineekee kaa ");
INSERT INTO auu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Deede, mee mée mee ebo ee magaano see kiya iyo, se maamaayaa' see yawegayaa. ");
INSERT INTO auu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bedaa ebea-ebea menaa ena miya kisee: Magaa da kaa ebo tookee mée ena apanaa magaa da kaa ebo tookee mée ena ma yape aawogee taano see naadi yape paagoo poono taa kaboo waa animaata kaama dimi gaagaa taano ko 'Ni yaato okaa yago bagee mée bado gaasi kuwa me yape bagee yaato okaa yago bagee bado mée oga kuwa daba, peedi kiyaano see naadi mée sikii ye, sikii taa ye?' see keta dimi daamaa gaagaa siyaa, se maa? ");
INSERT INTO auu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mée sikii taa gaayu ko yape bagee meemagaano taa kaboo emee-emee taano see menaa keta doodoota yape bagee paagoo pe-eewegayaa. ");
INSERT INTO auu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mee mokoo miya ikii me agiyoo-pagiyoo uduma se ekeasiyaa bagee kuwa Ni sekaataa nameeno ko iyo. ");
INSERT INTO auu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Dega mee ko daamaa agiyoo kiya dega gii taa keegoota kaama wodoo kaasee bedaa gii kiyaayaa? ");
INSERT INTO auu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Magapugu mantagaa siyaa miya iyo, apanaa gaadee siyaa miya iyo, má agiyoo mokoo naadi tameano too. Apa agoo see bagee daamaa yii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kuwa kaboo da pajak kepee yamasegee see bagee yuwa ma, apanaa dimi pedeo see bagee yuwa ma okoo mée eebaa Yesus me menaa yiino see naadi medaakea. ");
INSERT INTO auu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi kaa bagee yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me kisee deeta kaama mena dukumeawee taano ko \"Mee mée mee me dimi pedeo see bagee yuwa badaa maata kaama okoo ma enaataa naano agiyoo epo eenoogeeki, yaai\" see menaa yawegagea. ");
INSERT INTO auu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesus me ebea-ebea menaa kaa okoo asiino, ");
INSERT INTO auu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"Ikii mée ena wa me domba wodaa eebaa, ogei me badoo ena agoo kiya ena mee egayu ko waa kaasee ukuwayaa? Woda eebaa yaato sembilan puluh sembilan kuwa boo uwaa da kaa aii ekeata egapi mee mee abaano see naadi peeyaa. Abagee siwoo naadi kaama deemaayaa yoo too, kisee ukuwayaa, se maa? ");
INSERT INTO auu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Deemaata kaama kadeemaaga nao naadi ede kaa weka tapa doodoota ee kaa. ");
INSERT INTO auu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Peemaata kaama waa ma bagee yuwa ma, wa gebo kaa bagee yuwa ma kuwa uduma mena ogegeeta asiino, 'Wae, ni me egapa domba wodaa mee deemaata eto mee yagadoo mega yoka ikii anii ma epo enaataa ede ma, ede ma niisiweei' see asiyaa, see kuwa. ");
INSERT INTO auu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ani me kisiino ko: Mee mokoo miya dimi topoo see bagee mée eebaa yaato sembilan puluh sembilan kuwa kaa epoo to wodoo bagee yuwa ede ma, ede ma segee siyaa. Kiya dimi pedeo bagee waa ena too too kiyaa miya wa me pedeo yuwa ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo see kuwa kaa epoo to wodoo bagee yuwa me mee asii esee ede ma, ede ma segee siyaa.\" ");
INSERT INTO auu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","\"Bedaa mena ena ma kisee: Api ena ebo kepee gaasi agoo kiya ena egayu ko waa kaasee ukuwayaa? Waa peto moga iyaata kaama maga ponee dimi-dimi gekedegee, ipiipi abagee, kisee abadee, kisee abadee naadi kaama deemaayaa yoo too, kisee ukuwayaa, se maa? ");
INSERT INTO auu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Deemaayaa kaboo waa ma bagee yuwa ma, wa gebo kaa bagee yuwa ma kuwa uduma mena ogegeeta asiino, 'Wae, ni me egapa kepee mee deemaaga yoka ikii anii ma epo enaataa ede ma, ede ma niisiweei' see asiyaa, see kuwa. ");
INSERT INTO auu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ani me kisiino ko: Mee mokoo miya dimi pedeo bagee waa ena too too kiyaa miya wa me pedeo yuwa ekeata kuwa kaa Ogatamee me malaikat bagee yuwa esee ede ma, ede ma segee siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bedaa Yesus me asiino, \"Mée ena paayogaa yogaa wiya agoo. Yoga ebo kaboo da ");
INSERT INTO auu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","menaamee me nagamee asiino, 'Neataagi, neawaagi ma enaa yoga me masiyaa agiyoo kuwa aa bogaano taa kaboo anii nekee eto kiipaa nii' see asigi. Nagamee wa me agiyoo yuwa uduma yoga wiya yawuditayu. ");
INSERT INTO auu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Unu wiya waa naa omemaata menaamee wa me see yuwa pe-doogeeta kaama beesekaa magaa kaa peegi. Peemaata kaama wa me kepee yuwa ede ma, ede ma too otoopa agiyoo kaa too tameepeasigi. ");
INSERT INTO auu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kepe uduma taa kega kaboo mee magaa kaa naano agiyoo uduma wii keegooga. Mee kaama waa esee dimi nagimaano ebo. ");
INSERT INTO auu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yaai naadi peedoota mee magaa kaa bagee ena paagoo 'A me agiyoo kaukuwaa ye?' asigi naaki 'Aa ni me ekenaa yuwa namunii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Waa naadi ebo kigi, ekena me namo poonta yuwa 'Mee-noo taanaka' dimii mee gaawooki. Naano agiyoo eenaano bagee ena ma taa. ");
INSERT INTO auu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kuwa kaboo da waa dimi gaagaa naadi kaama wegaano, 'Neataagi me agiyoo yaokagee see bagee yuwa kuwa naano agiyoo naano kana-kanaa segeekea kiya anii nakaayoo naadi kaa bogaano see kooka. ");
INSERT INTO auu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eto ko anii pakadoota neataagi paagoo kisee asiipa: \"Neataagi, anii dimi pedeo see mée. Anii Ogatamee kaa miya pedeo yaukuwama, a kaa miya pedeo kaukuwama. ");
INSERT INTO auu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Anii a me yogaa kiya má bagee keenda yoka a me agiyoo aii kaokagee see mée to too naekeasii\" see asiipa' see gaagi. ");
INSERT INTO auu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Waa yiinaageeta nagamee paagoo ki pakagi. Peenaa beesekaa mokoo see yoo pakaamaagi ko nagamee me deeta kaama esee epa nao naadi dimi se gaata yiibaga sedoota yogamee paagoo epoo pe-toomegeeta ebe nuunuuki, kisee ede ma, ede ma see kooki. ");
INSERT INTO auu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yogamee me asiino, 'Neataagi, anii dimi pedeo see mée. Anii Ogatamee kaa miya pedeo yaukuwama, a kaa miya pedeo kaukuwama. Anii a me yogaa kiya má bagee keenda' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kiya nagamee wa me agiyoo yaokagee see bagee yuwa paagoo asiino, 'Esee daamaa dokaa moga masegeeta yamaatagaai. Kepo kaa bako ma, bado doko miya moga yamaatagaai. ");
INSERT INTO auu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sapi poodu pakuu to, pakuu to see kepaa mee niiwugii. Inii ede ma, ede ma epo enaataa naano ke. ");
INSERT INTO auu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Niyoopaa mee boota mokoo ewo kiya aya tupi, waa egata mokoo ewo kiya deemaaga yoka' see wegagi. Okoo paaya ede ma, ede ma notaa. ");
INSERT INTO auu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kuwa kaboo da taa ko yagamee mee bugi kaa tupi. Meedoota eepa geboo da kaa meemaagi ko mée eebaa ede ma, ede ma taakea, kisee menaa yeegi. ");
INSERT INTO auu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Agiyoo yaokagee see mée ena mena ogegeeta asiino, 'Kuwa mapea menaa ya?' asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Agaabee mee eto meemaagi yoka agaataagi me \"Sapi poodu pakuu to, pakuu to see kepaa mee niiwugii, inii epo enaataa ede ma, ede ma naano ke. Niyoopaa mee boota mokoo ewo kiya ni paagoo pakaamaata daamaa tupi yoka\" see mée asigi' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yagamee esee kagoo kigi, ee yiba pakaano be. Nagamee pudumedoota yagamee paagoo mena maamaa yamonaagi naaki ");
INSERT INTO auu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","wa me asiino, 'Neataagi, nayeede. Anii peedi kaa kaama kisee too kana ma, kana ma a me agiyoo kaukuwawoo segeeka. A me menaa peedi ena ma kaemeseano taa kiya anii epo peenaa see bagee yuwa ma enaataa ede ma, ede ma nusi naadi aa kambing woda peedi ena waa naa ma niino taa keme. ");
INSERT INTO auu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kiya a me yogaa mee, a me yawodeme agiyoo kuwa tobaaka taagee see ee yuwa kaa too otoopa tameepi-tamaapi see mée to kiya a paagoo meemaagi ko \"Sapi poodu pakuu to, pakuu to see kepaa mee niiwugii\" see kuwa be keekee' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nagamee me asiino, 'Niyoopaa, aa ni paagoo daamaa naatoogee segeeke, bedaa ni me agiyoo uduma miya aa nekee too topa ke. ");
INSERT INTO auu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Agaabee mee boota mokoo ewo kiya aya tupi, waa egata mokoo ewo kiya deemaaga yoka inii eto ede ma, ede ma notaake kuwa gaano pedeo keekee' see aseta\" see kuwa Yesus me asigi menaa. ");
INSERT INTO auu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus me Wa me topenaa see bagee paagoo ebea-ebea menaa ena eewegaano ko kisee: \"Kepe yago bagee waa ena me wa me agiyoo tabaa da koga ma namagasi naadi mée ena paagoo yaeke. Omegee, toogee naadi kaawaa ena mée me wa paagoo pe-asiino, 'A me agiyoo koga ma kamaataa see mée wa me a me agiyoo yuwa otoopa katameepii segeeki' see asegea. ");
INSERT INTO auu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kisee asegea naadi mee eboo me waa 'Meei see pe-naasii' see asigi. Meemaagi kaboo wa me asiino, 'Mée me aa ni me agiyoo kisee natameepii segeeke see nasegea kuwa kaasee menaa? Eto kaama wodoo aa ni me agiyoo koga ma namaagee taano kuwa anii be. Eto ko okaayoo ni paagoo agoo see bagee yuwa kuwa aa koga kepee magoo namaagee sepe, bedaa kepe magoo nakade-maniino taa, see kuwa anii ipi kaano see yoka kuwa menaa a me kapoge kaa ebeagee sepe yuwa kuwa nii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mee mée to me kuwa yaai naadi dimi yiba gaano, 'Sooi, wa me nabe kigi yoka eto kaama wodoo anii kaasee ukuwaapa naa ya? Anii bugi yagaano, kisee agiyoo kuwa anii kana, bedaa mée paagoo idimaano kuwa miya ego weda keekee' see gaagi. ");
INSERT INTO auu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Dimi gaagaa naadi kaama kisee ki nekeenigi. 'Daamaa, eto ni me gaano dimii mee ko kisee: Ni me eto yaukuwagee see agiyoo kuwa taa keta wodoo apanaa bagee okoo me naepa kaa okoo me ee yiba badaa namaasi naadi agiyoo mee ukuwaanaka' see gaagi. ");
INSERT INTO auu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kiyoo kaama wa me eboo me agiyoo wa paagoo okaayoo agoo see bagee yuwa mée ena-ena 'Meei' asigi. Petamanii mipi mée paagoo wa me asiino, 'Ni me eboo me agiyoo kuwa okaayoo a paagoo magoo topa?' see asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Minyak otaawee ogei me badoo ena masema' see asigi. Kisee asigi naadi wa me asiino, 'Idukaa a me okaayoo mikee anii minyak otaawee ogei me badoo ena kuwa masega ii see ipi kisi naadi ebeamaame kapogee mee masii. Eto ko moga animaata ogei me badoo ena wonataata kaama minyak uwoo mée wiya ma gaasi kuwa too masema see ebeai' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kiyoo kaama okaayoo yago bagee wiyaagoo to mee meemaagi kaboo wa me asiino, 'A paagoo okaayoo magoo topa?' see asigi naaki 'Gandum poo otaawee ogei me badoo gaasi masema' see asigi. Kisee asigi naadi wa me asiino, 'Idukaa a me okaayoo mikee anii kisuwa masega ii see ipi kisi naadi ebeamaame kapogee mee masii. Animaata ogei me badoo wagoo kuwa too masema see ebeai' see asigi. Mee mée to me kisee-kisee wa me eboo me okaayoo agoo see bagee yuwa kuwa okaayoo yuwa peedi yaekeasigi, kisee koogo yaukuwagi. ");
INSERT INTO auu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Waa dimi topoo taa see mée kiya wa me eboo me 'Waa dimi esee ipi kaa ukuwagi' kisee yaapaageeki, see ebea-ebea menaa kuwa. Mikee, kuwa magaa da kaa bagee yuwa okoo kisee gokoo-gokoo taano kuwa dimi ipi kaa aaukuwagee siwoo siyaa kiya awee yaato toogee see bagee kuwa dimi ewo. ");
INSERT INTO auu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ani me kisiino ko: Mee mokoo miya ikii kepe, kisee magaa da kaa mée deebaa see agiyoo yuwa me ikii epa kigaayaa bagee agoo kiyaai. Ikii kisee ukuwayu ko kepe taa kiyaa naagoo Ogatamee Wa me ee kaa ikii daamaa badaa kimagaapi, kisee too iminoo miya, iminoo miya. ");
INSERT INTO auu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Apanaa bagee me agiyoo yaukuwaano mee ko peedi agiyoo miya daamaa-daamaa see yaukuwagee siyaa bagee kuwa okoo ebo agiyoo miya daamaa naukuwasi naadi yaekeasiyaa. Bedaa peedi agiyoo miya pedeo-pedeo see yaukuwagee siyaa bagee kuwa okoo ebo agiyoo kuwa miya pedeo-pedeo see naukuwaapea naadi si yaekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kisee kiyaa yoka ikii kepe, kisee magaa da kaa mée deebaa see agiyoo kuwa otoopa tameepi-tamaapi segee siyu ko mikee ebo see agiyoo yuwa ikii daamaa nadiitoo taai naadi ikii paagoo kiekeasiyaa bagee ena agoo ye? ");
INSERT INTO auu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bedaa apanaa bagee me agiyoo yuwa ikii yatameepi-tamaapi segee siyu ko ikii nekee agiyoo kuwa maamee me kineeyaa? ");
INSERT INTO auu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Agiyoo yaokagee see mée ena me gaano, 'Mee ko ni me eboo, bedaa mee miya ni me eboo, ekea paaya' see gaayaa kiya taa, iyo. Ebo too see ekea wiya kiyu ko ebo ena mee be, ena mee epa, bedaa mena yayiino ko ebo ena mee mena yayeetaa, ena mee otoopa tayu. Mee mokoo miya ikii me 'Ogatamee mee miya ebo, kepe, kisee magaa da kaa agiyoo kuwa miya ebo, ekea paaya ebo, ekea paaya ou' see gaayaa kiya taa, iyo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi kaa bagee yuwa kuwa menaa uduma yiitookea. Okoo kepe ou gaayaa bagee yoka Yesus Waa wisineekee kaa yakeakea. ");
INSERT INTO auu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus me okoo asiino, \"Ikii ko 'Mée me waa sikii, waa miya nao' see nagaasi naadi dimii mee agoo see bagee kiya ikii me koogo gaayaa dimii kuwa Ogatamee me kinekeenigi. Mikee, mée me ou naadi ebo ekee see agiyoo kuwa Wa me esee be. ");
INSERT INTO auu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Idukaa Musa me menaa ma, nabi bagee me menaa ma kuwa kisee too wegawoo naadi Yohanes mee toogee seta yoo too. Yohanes wa kaa kaama asii 'Ogatamee Wa too ebo mée eetupi yoka miweei' see menaa kuwa eewegakomee naadi kaama mée yuwa omaago ma medaakea. Kuwa etokaa daamaa menaa yuwa eewegakomee senaakea ");
INSERT INTO auu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","kiya kuwa idukaa kaama wegawoo seta menaa kuwa umina taa kaata see se. Epoo to ma, magaa to ma kuwa taa kiyaayaa maa diya kuwa idukaa menaa yuwa, peedi see mena kamu ena miya uwa se daaniino ko iyo. ");
INSERT INTO auu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Paimee me apimee ekeata kaama apanaa apii goeyu ko waa tobaaka taakee mée to kiyaa. Bedaa ekeata apii to goeyaa mée to waa miya tobaaka taakee mée to kiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus me bedaa mena ena ma eewegaano ko \"Kepe yago bagee waa ena kaagaa gakata kepe edaano ebo see agiyoo kaa too omegee, toogee see mée agoo. Waa daamaa see dokaa too maagee, daamaa agiyoo too maamaa noogee, kisee ede ma, ede ma too umiwoo, toowoo segeeki. ");
INSERT INTO auu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Daba see mée ena ekaa da ko Lazarus miya agoo. Wa me maa da kaa pedeo abuu maamaa pudii. Kepe yago mée to me ee kenee to kaa totaaki. ");
INSERT INTO auu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kepe yago mée to me notaaka too eseanee see ponee-panaa yuwa naanugi naaki ou see dimii gaataa see, bedaa kameno yuwa miya meedoota wa paagoo wa me abuu yuwa yatakadenoo segee see, kisee umiwoo, toowoo see mée to. ");
INSERT INTO auu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kisee omegee, toogee naadi kaama mee daba see mée to boota kaama malaikat bagee yuwa me badaa maageeta Abraham paagoo daamaa toogee yoo pakaa-ekeasegea. ");
INSERT INTO auu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kiyoo kaama kepe yago mée to miya boogi, ogo maagea. Waa boota bagee toogee yoo peemaagi naaki ae-wae, boodi dimi nagi. Deewoo ko Abraham mee beesekaa mokoo tupi, bedaa wa geboo da kaa Lazarus waa miya kiyoo totaaki. ");
INSERT INTO auu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Waa ebo menaa kaa 'Neataagi, Abraham wae. Nakaayoo biyaa tani ebo yoka epa nagaai. Lazarus mee wa me kepoo to uwo tokoata ni me dabegea da kaa nadabiyaasi yoka naisiyaai' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kiya Abraham me asiino, 'Ei, mée yogaa to, aa bogaano taa kaboo daamaa agiyoo too masegee seme, bedaa Lazarus mee pedeo see kaa too omegee, toogee simi, see kuwa aa daamaa gaagaa taai. Eto mee waa nakaayoo kaama ede ma, ede ma too toogeeki, bedaa aa ko ae-wae, boodi abaagee segeeke. ");
INSERT INTO auu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kuwa too se kiya enaa ma, aa ma yaayupii da taa ko egoo ebo kiyaata yoka nakaayoo kaama a paagoo isiino ko isiino naka, bedaa apiyoo kaama nakaayoo pakaano miya iyo, esetaa, pakataa see se ukuwamaayaa' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kepe yago mée to me asiino, 'Neataagi, kisee kiyu ko Lazarus mee neataagi me ee kaa napeeyaano kuwa esee gaano pedeo. ");
INSERT INTO auu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Neataagi me ee kaa kiyoo neebee nokaa idibi topea yoka okoo miya nakaayoo ae-wae, boodi too abaagee see yoo kiyoo miyaa naadi Lazarus me pe-naasegeesi naadi napeeyaai see kasega' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kiya Abraham me asiino, 'Musa me menaa ma, nabi bagee me menaa ma kuwa yiba gaamaasi naadi menaa topa, kuwa menaa yuwa okoo yeesi yoka' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kepe yago mée to me asiino, 'Neataagi, Abraham, wae, a me kuwa mikee wegage kiya taa. Mée ena nakaayoo boota bagee toogee yoo kaama peedoota nii ma kenaa bagee idibii to paagoo mena pe-ase-maneegi gaayu too okoo me pedeo yuwa ekeasiyaa' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham me asiino, 'Musa me menaa ma, nabi bagee me menaa ma kuwa yiba gaamaasi naadi menaa kuwa okoo me si yayeeyu ko mée waa ena boota kaama aya andoo peeyaa miya wa me pe-asiyaa menaa kuwa si yayiipea, mikee menaa yoka see se gaapea' see aseta\" see kuwa Yesus me asigi menaa. ");
INSERT INTO auu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus me Wa me topenaa see bagee yuwa asiino, \"Mée deebaa see menaa weganaa naadi kaama mée me pedeo agiyoo maamaa ukuwaandaa siwoo taapa kuwa mikee kaapa kiya kuwa mée deebaa see menaa weganaa see bagee kuwa yaai, okoo umina pedeo kaatagea. ");
INSERT INTO auu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Okoo kisee menaa weganaa naadi kaama yoga me dimii masetaa see bagee kuwa okoo mée waa ena too too miya mée me deebaa naadi kaama waa pedeo agiyoo ukuwayu ko mee deebaa sipi mée to yaai. Waa kaakaa da taa ebo omaa gadeata maakaa piku yiba tamekumiino daamaa. ");
INSERT INTO auu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ikii ekaato ipiipi dii. Anii mikee nagaayaa bagee waa ena me pedeo agiyoo ukuwayu ko ego-tago taai. Waa mee agiyoo ekeasiyu ko aa miya waa epa yaekeasii. ");
INSERT INTO auu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Waa miya pedeo kakiyaagi kiya bedaa waa a paagoo 'Epa naekeasii' see kasiyu ko aa miya waa epa ekeasiino gaano pedeo. Bedaa waa mee naagoo too kaagaa petoo pedeo kakiyaabuu segee seta kaama bedaa mee naagoo kaagaa gakata, kaagaa petoo a paagoo meegee naadi 'Epa naekeasii' see kasiyu ko aa miya waa epa ekeasiino gaano pedeo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kuwa Wa me menaa yadoonaa see bagee yuwa me Tuhan asiino, \"Inii me Ogatamee mikee gaano dimii mee ebo mée yakiyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tuhan me asiino, \"Ikii me Ogatamee mikee gaano dimii mee peenaa too kiyaa miya ebo agiyoo ukuwaaniyaayaa. Kuwa ko ikii me mikee gaano dimii mee sesawi poo keepa peedi ena mee keta kiyaa miya ikii me apee ebo piyaa wodoo to mee 'Badegeeta maakaa piku yiba weeniyaai' see asiyu ko ikii me asiyaa menaa kuwa kiyeeyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesus me eewegaano, \"Ikii me agiyoo-pagiyoo kiokagee see mée waa bugi kiyaataaki yee, domba wodaa kimunitaaki yee kisee agiyoo ukuwadoota ee kaa meemaagi kaboo ikii me wa paagoo 'Anii naano agiyoo kakupimaaga yoka moga nakaayoo me-naai' see asiyaa ye? ");
INSERT INTO auu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Taa, mée me kisee wa paagoo se asiyaa. Wa me eboo me wa paagoo asiyaa menaa mee ko kisee: 'Eto ko anii naano agiyoo naanaka yoka aa daamaa dokaa maataata kaama naano agiyoo nakopemaata nii. Ani keta naapa, kaama too aa nose' see kuwa too asiyaa. ");
INSERT INTO auu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mee agiyoo yaokagee see mée to me wa me eboo me asiyaa menaa kuwa yaukuwaano too see mée yoka wa me eboo me paamee see menaa kuwa wa paagoo se asiyaa, se maa? ");
INSERT INTO auu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ikii miya kisee. Ikii me Eboo me kiseta menaa kuwa daamaa yaukuwamaata kaama ikii me wegayaa menaa kuwa ko kisee: 'Inii ko peedi, inii me Eboo me mée asiyaa menaa yuwa koogo yaukuwagee taano too see bagee yuwa yoka paamee see menaa mée se asiyaa miya daamaa' see menaa kuwa ikii me wegaano daamaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus mee Yerusalem magaa kaa pakataaka too Galilea wee kaa magaa ma, Samaria wee kaa magaa ma kuwa yaayupii da taa woosege. ");
INSERT INTO auu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Maga ena kaa pakaamaaga too ko esee pedeo abuu yago bagee okoo mée gaasi topea. Okoo meedoota beesekaa mokoo see yoo kaama yiinaagee naadi ");
INSERT INTO auu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ebo menaa-menaa kaa asiino, \"Ei, Yesus, Guru, inii kuwa epa mée gaai, epa mée gaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus me okoo deeta kaama asiino, \"Ikii peedoota imam bagee paagoo ikii ekaato pe-deeyaai\" see asigi. Etaawee peetaakea naaki abuu yuwa taa keepeasega. ");
INSERT INTO auu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Okoo mée ena ni me abuu yuwa taa kega nao naadi metaki meedoota Yesus paagoo ebo menaa-menaa kaa Ogatamee yaapaageeki. ");
INSERT INTO auu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesus me badoo da kaa mumo maga kaa esee-ekeata kiiboo, paamee see menaa asigi. Mee mée mee ko Samaria kaa mée. ");
INSERT INTO auu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesus me wegaano, \"Okoo abuu taa kedaa sepea bagee okoo mée gaasi, se maa? Mée okoo iyee kuwa kayoo topea naa ya? ");
INSERT INTO auu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mee apanaa tomaa kaa mée to wa too Ogatamee yaapaagee taano see naadi metaki migi ye?\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesus me mee mée to asiino, \"Yiinaageeta koogo pooi. A me Anii mikee nagaano dimii mee me eto aa daamaa kege, daba daagimaa peege\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi kaa bagee yuwa me Yesus asiino, \"Ogatamee Wa too ebo mée eetoowoo taatagi naagoo naa maadee mani kaata naa ya?\" see asegea naaki Wa me asiino, \"Kisee se. Ogatamee Wa too ebo mée eetupi ii see nekeensi naadi agiyoo kuwa mée me ipiipi deena-deena see kaa se deemaayaa. ");
INSERT INTO auu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mée me 'Miweei, deede, nakaayoo Wa too ebo mée eetupi nao' see asiyaa kuwa se, bedaa 'Amokiyoo deede' see kuwa miya taa. Ogatamee Wa too ebo mée eetoono kuwa ikii paagoo eto ukuwaandaa taaka yoka daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kiyoo kaama Yesus me Wa me topenaa see bagee yuwa asiino, \"Mée Yogaa mee meetagi naagoo ikii me moga deega naaki ou see gaatagea kiya se diitagea. ");
INSERT INTO auu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mée me 'Ei, deede, Waa amokiyoo tupi' see kisiipea kiya pe-si dii, bedaa 'Ei, Waa nakaayoo tupi' see kisiyaa miya se pooi. ");
INSERT INTO auu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mée Yogaa mee meetagi naagoo ko bego-bego apaa to deeyaa mokoo kaata. Bego-bego apaa to epoo to kaa uduma, naayaato kaama masegeeta naayaato too seke-wasii peega see deeyaa mokoo Mée Yogaa mee meetagi naagoo miya mée uduma kisee Waa diitagea. ");
INSERT INTO auu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kisee diitagea kiya eto mee begaa kaa bagee yuwa me Waa be kaa wisinegee naadi kaama Waa boodi maamaa abaagee taapi, kisee keta ukuwaaniino gaano pedeo. ");
INSERT INTO auu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mée Yogaa mee meetagi naagoo ko idukaa Nuh mee tota kaboo magaa da kaa bagee me ukuwanaa, peenaa siwoo segee seta see see iminookaa miya okoo kisee agiyoo daba ukuwataaka too meetagi. ");
INSERT INTO auu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mee ko mée tomaa yuwa okoo naano agiyoo noogee, api aamanee, api goegee, kisee daba ukuwawoo segee seta, kisee too Nuh mee kapal see komaa yiba seemeta yoo too. Seemeta kaama kuwa bagee okoo uduma uwo me dapimeta. ");
INSERT INTO auu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bedaa idukaa Lot mee tota kaboo da miya mée me kisee ukuwawoo segee seta. Okoo naano agiyoo noogee, agiyoo-pagiyoo pe-doogee, pe-edaagee, bugi yaagee, ee maagee, kisee agiyoo daba ukuwagee, omegee, toogee seta. ");
INSERT INTO auu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kiya Lot mee Sodom magaa kaa kaama peeta naagoo epoo to kaa kaama biyaa ma, pedeo noogaa peeyaa see biyaa patagu ma kuwa bekea esedaa naadi mee magaa kaa bagee yuwa uduma biyaa peeyaata. ");
INSERT INTO auu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mée Yogaa mee awee da kaa kaatagi naagoo miya kisee kaata. ");
INSERT INTO auu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mee naagoo ko yoo da kaa tuyaa bagee yuwa ee yiba agiyoo se masii, se gaata oogaai. Bugi kaa tuyaa bagee yuwa miya ee kaa agiyoo ou naadi pakaa-maseekee se. ");
INSERT INTO auu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot woga me kisee ukuwata kuwa ikii daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kuwa ko okoo ekaato daba toono see naadi okoo me gaayaa-gaayaa yuwa kaa too umiwoo, toowoo siyaa bagee kuwa usiyaato ko umina pedeo kaatagea. Kiya okoo ekaato ekegataata kaama Ni sekaataa namiyaa bagee kuwa okoo booyaa miya okoo usiyaato ko daamaa kaatagea, okoo daba daagimaa pootagea. ");
INSERT INTO auu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ani me kisiino ko: Mee naagoo daatooyiba mée ekea wiya enaataa toomoo ometaaka too ko mée ena mee badaa maageeyu, ena mee kisee eke. ");
INSERT INTO auu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Api ekea wiya enaataa namo kupitaaka too ko ena mee badaa maageeyu, ena mee kisee eke. ");
INSERT INTO auu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Paayogaa ekea wiya bugi yaataaka too ko mée ena badaa maageeyu, ena mee kisee eke, kisee kaata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wa me topenaa see bagee yuwa me asiino, \"Tuhan, kuwa agiyoo kuwa kayoo naa ukuwaaniita naa ya?\" asegea naaki \"Bootaa da tuyaa yoo boota notaa see bedoo yuwa kiyoo kutuu siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus me Wa me topenaa see bagee yuwa okoo ae-wae, gaagaa siyaa kaboo miya sembahyang se ekeata kisee too ukuwageesi naadi kaama ebea-ebea menaa ena eewegaano ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","\"Maga ena kaa mena ena too too mée yadaakomee taa see mée ena agoo. Waa Ogatamee Wa too weda, Wa too ebo se ekee see mée, mée miya epa taa see mée. ");
INSERT INTO auu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mee magaa kaa api miyaa ena miya topa. Wa me mee mena yadaakomee taa see mée to me anii mena nadaakomeesi naadi maamaa pe-asegee taano ko 'Ei, anii mée ma mena agoo yoka a me mena nadaakumii' kisee maamaa pe-asegeeka. ");
INSERT INTO auu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mee mena yadaakomee taa see mée to me mee apii miyaa da me kisee too nasegeeka kuwa be naadi yawisintagaa segeeki. Kisee ukuwagee naadi kaama kaagaa ena wa me gaano, 'Anii Ogatamee mee miya wedaano taa, mée miya epa taa ");
INSERT INTO auu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kiya mee api miyaa da me ni paagoo kisee nasegee segeeka kuwa kana yoka kisee too se nameegeesi naadi wa me menaa da anii daamaa yadaakumiipa' see gaagi, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tuhan Yesus me mee ebea-ebea menaa eewegamaata kaama bedaa okoo paagoo asiino, \"Mee mena yadaakomee taa see mée waa dimi topoo taa see mée kiya wa me 'Mee api miyaa da wa me menaa da anii daamaa yadaakumiipa' see menaa kuwa ikii daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mee api miyaa da me idimeta menaa kuwa wa me yayeegi kiya Ogatamee me kisee Wa me daamaa wigintaata bagee yuwa me menaa kuwa si yayiipi ye? Okoo me kisee too egapi yaato miya, daatooyiba yaato miya ae-wae segee siyaa menaa kuwa Wa me yayiino be kegee segee taapi ye? ");
INSERT INTO auu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Taa, okoo me ae-wae segee siyaa menaa kuwa Waa moga yayeeta kaama mena ena too too daamaa yadaakomee taapi. Kisee Wa me daamaa okoo kaa yaukuwawoo taapi kiya Mée Yogaa mee meetagi naagoo okoo me Waa mikee gaawoo taakea see kuwa diitagi ye, taa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Okoo 'Anii dimi topoo, apanaa bagee kuwa dimi ewo see bagee yuwa too' see dimii gaayaa bagee kuwa kisee dimii ekeasi naadi Yesus me apanaa ebea-ebea menaa ena eewegaano ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","\"Mée ekea wiya Ogatamee me ee kaa sembahyang taano see naadi peetaa. Ena mee Parisi kaa mée, ena mee pajak kepee yamasegee see mée. ");
INSERT INTO auu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Peemaata kaama Parisi kaa mée to yiinaageeta dimi yiba sembahyang menaa ko 'Ogatamee, anii apanaa bagee see see se yoka anii paamee dimii mee ebo. Oma masetaa see bagee yuwa ma, dimi koopoo see bagee yuwa ma, tobaaka taagee see bagee yuwa ma, amokomee pajak kepee yamasegee see mée waa miya uduma okoo too, anii taa yoka paamee, magiyaage kasega. ");
INSERT INTO auu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Anii gaayu ko daa gakata egapii wiya naano agiyoo tapoo toogee segeeka, bedaa ni me masiyaa agiyoo yuwa uduma gaaseagoo to mee kaneegeeka yoka' kisee sembahyang menaa dimi yiba koogo asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kiya pajak kepee yamasegee see mée to mee beesekaa mokoo kaama yiinaageeta epoo to yaato deataano weda kaa kisee sooi-wooi naadi kaama ekaato bokoo to kaa yagaa kopaa toko-tokoki. Wa me wegaano, 'Ogatamee, wae, anii ko dimi pedeo see mée yoka epa nagaai, epa nagaai' kisee menaa wegagi, see kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Bedaa Yesus me wegaano, \"Ani me kisiino ko: Ekea paaya sembahyang semaata ee kaa peegea kiya Ogatamee me mee mée to 'Wa too sikii, wa too miya nao' see gaagi. Parisi kaa mée to kisee taa. Mee ko okoo ekaato ebo ekee taa see bagee kuwa peedi kaatagea, bedaa okoo ekaato peedi ekee taa see bagee kuwa ebo kaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kuwa kaboo da yoga peedi yuwa Yesus me okoo kaa yagaa yamaasi naadi Wa paagoo eemegea. Wa me topenaa see bagee yuwa kisee deeta kaama kagoo kegea. \"Yaai, kisee se\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kiya Yesus me kuwa yogaa yuwa \"Uduma meei\" see asigi. Bedaa Wa me asiino, \"Kuwa yogaa yuwa Ni paagoo daba misi yoka si yawasii. Okoo kuwa see see yoga me dimii masetaa see bagee kuwa okoo Ogatamee Wa too ebo mée eetotaa see yoo epo enaataa eetuyaa bagee yuwa yoka okoo Ni paagoo daamaa miyaai. ");
INSERT INTO auu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Anii mikee kisiino ko: Okoo Ogatamee Wa too ebo mée eetupi nao naadi kaama yoga me dimii, yoga me menaa kuwa se masiyaa bagee kuwa ko okoo taa ma taa Ogatamee Wa too ebo mée eetotaa see yoo se seemiyaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Egaa ena naagoo Yahudi kaa ebo tota bagee ena Yesus paagoo meemaata kaama asiino, \"Ei, Guru daamaa see Mée, Anii iminoo miya, iminoo miya kisee too toowoosi naadi ukuwayaa agiyoo naa maagiyoo ukuwayaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus me asiino, \"Aa daamaa see Mée see menaa mee kaasee kaa nasege? Mikee daamaa see Mée mee ko Ogatamee Wa too, kaama taa. ");
INSERT INTO auu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A me 'Anii maagiyoo ukuwayaa naa ya?' see nasege mee ko Ogatamee me menaa kuwa aa miya ipi. Kuwa ko 'Ikii tobaaka se taai, mée se wugii, oma se masii, kobaakee menaa si yakobaai, okonaka ebo ekeasii' kisee menaa kuwa aa miya ipi yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mee mée to me asiino, \"Kuwa menaa kuwa uduma anii peedi kaa kaama daamaa ipiipi deewoo segeeka yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kisee asigi naadi Yesus me asiino, \"A me ukuwaano gaano pedeo agiyoo ena ma topa. Mee ko a me agiyoo yuwa uduma pe-doogeeta kaama masiipe kepee kuwa daba bagee aii manii. Aa kisee ukuwamaata kaama epoo to wodoo agiyoo yuwa kaagoo kiyaata kaama kisee too masiwoo siyaa. A me kepee kuwa uduma wudikomeeta kaama Ni sekaataa nameei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kiya mee mée to me kuwa menaa yeeta kaama dimi nagimigi. Wa me agiyoo tabaa da eebaa kemaata dimi gaagaa ebo. ");
INSERT INTO auu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Wa me dimi gaagaaki yuwa Yesus me deeta kaama asiino, \"Kepe yago bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko esee kana. ");
INSERT INTO auu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Unta wodaa mee abi tokogoo da yibaa taa mikee pakaa-seomiyaa kiya kepe yago bagee kuwa Ogatamee Wa too ebo mée eetotaa see yoo seemaano ko kana\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kuwa menaa yeegea bagee yuwa me asiino, \"Kepe yago bagee kuwa daba daagimaa poono kana kiyu ko maamee naa daba daagimaa peeyaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wa me asiino, \"Mée daba daagimaa poono mee ko mée me se ukuwamaayaa agiyoo kiya Ogatamee Wa me too uduma agiyoo uduma ukuwamaayaa see Mée yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petrus me asiino, \"Inii me agiyoo-pagiyoo uduma ekeata kaama A sekaataa metaake kuwa Aa mée deege\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wa me okoo asiino, \"Anii mikee kisiino ko: Okoo Ogatamee Wa too ebo mée eetupi nao naadi okoo me ee, apimee, okoo ma kenaa bagee yuwa, okonaka, yogaanii yuwa, kisee ekeata bagee kuwa ");
INSERT INTO auu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","eto mee begaa kaa miya okoo me kuwa ekeata yuwa bedaa apanaa miya maamaa masegee taapea, bedaa kaama mee begaa kaa miya iminoo miya, iminoo miya kisee too umiwoo, toowoo taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus Wa me topenaa see bagee gaasi ma wiyaa to okoo too amo kaa naa kaa eepeanta kaama asiino, \"Ikii daamaa nayii. Inii Yerusalem magaa kaa pakataakea. Pakaamaata kaama wodoo nabi bagee me Mée Yogaa mee kaa ebeamaata menaa yuwa uduma uwa daapa. ");
INSERT INTO auu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kuwa ko Waa apanaa tomaa kaa bagee paagoo yaekegatagaapea. Okoo me wisineekee menaa wisineapea, mée badeekee menaa asiipea, dabeedi taaii taapea. ");
INSERT INTO auu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pepeaduu me dakameamoo semaata booyaapea kiya wedaagoo to naagoo Waa aya andoo pootagi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kiya Wa me asigi menaa nekeeniino yaato okoo yaboonemaata kemaata se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus mee Yeriko magaa kaa peetaaka too ko eta geboo da kaa emaa digiyoo see bagee ena animaata kepe idimetaaki. ");
INSERT INTO auu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mée eebaa etaawee amoo-segekea kaboo wa me asiino, \"Kuwa maagiyoo?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","\"Mee ko Nazaret magaa kaa Mée Yesus mee amoo-segeki\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wa me ebo menaa-menaa kaa asiino, \"Yesus, Daud ma apaa kaa Mée Aa epa nagaai, epa nagaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Okoo keta amoo-segekea bagee yuwa me kagoo kaa \"Aa koogo tooi\" asegea kiya waa bedaa maamaa mena ugigi. \"Tuhan, Daud ma apaa kaa Mée, Aa epa nagaai, epa nagaai\" see maamaa asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus kiyoo tuguunta kaama \"Mee mée to badaa namaagii\" see asigi. Badaa maageegea kaboo Wa me asiino, ");
INSERT INTO auu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","\"Aa maagiyoo naidimege?\" see asigi naaki \"Tuhan, emaa diino keago see ede\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus me asiino, \"A me mikee nagaano dimii mee me aa emaa daamaa kege, daba daagimaa peege\" see asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","taka ena emaa diino keago kigi. Waa Yesus sekaataa peegi, Ogatamee yaapaagee see menaa wegapegeeki. Kiyoo deegea bagee uduma miya Ogatamee yaapaageekea. ");
INSERT INTO auu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus mee Yeriko magaa kaa pakaamaata kaama peetaaki too ko ");
INSERT INTO auu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","pajak kepee yamasegee see bagee me eboo ena ekaa da ko Zakeus mee tupi. Waa kepe yago mée. ");
INSERT INTO auu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Waa Yesus mee kaasee mée to, kaasee mée to naadi kaama kisee dii-dii, kisee dii-dii see deegi naaki mée taki, waa katu yoka diino naka. ");
INSERT INTO auu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Se deega ou naadi kaama moga peedoota etaawee Yesus peemagaapi yoo ara piya ena kaa pakaa-seke. ");
INSERT INTO auu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus mee piya manii da kaa peemaata kaama deataata asiino, \"Zakeus, moga isii, eto kenaagoo Anii a me ee kaa kaatoono gaano pedeo yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakeus moga maga kaa eseemaata kaama ede ma, ede ma Yesus badaa maadoota ee kaa. ");
INSERT INTO auu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kiya kuwa deegea bagee yuwa mena dukumeaweekea. \"Yaai, dimi pedeo bagee me ee kaa eetoono see naadi peegi\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ee kaa peemaata kaama toomuu taakea kaboo Zakeus yiinaageeta kaama asiino, \"Ei, Tuhan, ni me kepee, ni me agiyoo tabaa da kuwa uduma yupigapi wuditaata naato yaato daba bagee paagoo yawudiipa. Bedaa anii mée paagoo pajak kepee koga yuwa ma yamasema bagee kuwa anii kuwa koga yuwa kuwa too se kiya kepe kaawaa wui bedaa pe-mantagaa taapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus me waa asiino, \"Aa miya Abraham ma ena tomaa kadeega yoka eto kenaagoo Ogatamee me mée daba daagimaa peeyaano menaa kuwa mee ee kaa bagee paagoo nakimega. ");
INSERT INTO auu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mée Yogaa mee meta mee ko egata bagee yuwa abamaata kaama okoo daba daagimaa peeyaano see naadi meta yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesus mee Yerusalem magaa kaa pakaamagaano see koo taaki yoka mée yuwa me gaano, 'Waa pakaamaata kaama kisee ki Ogatamee Wa too ebo mée eetoowoo taapi' see dimii gaagea. Kisee kemaata Yesus Wa me menaa yiitookea bagee paagoo ebea-ebea menaa ena eewegaano ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","\"Ekaa yago mée ena waa magaa to kaa tookee eboo natuyaasi naadi beesekaa magaa ena kaa peegiino see. ");
INSERT INTO auu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Waa poono taa kaboo wa me agiyoo yaokagee see bagee okoo gaasi 'Meei' asigi. Okoo uduma meemaagea kaboo ebo kepee okoo ena-ena yawuditaata kaama asiino, 'Kuwa kineega kepee kuwa ipiipi agiyoo-pagiyoo kaa kepe koga ma eebaa mokoo namasegee siwoo taai, kisee too anii bedaa meemagaata yoo too' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mee magaa kaa bagee apanaa yuwa me waa be kegea yoka waa ebo mée se eetuyaasi naadi menaa pe-asiino bagee peeyaagea. Peemaata kaama okoo me asiino, 'Mee mée mee inii be yoka inii me magaa to kaa waa ebo mée se niituyaai' see asegea. ");
INSERT INTO auu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kisee asegea kiya waa ebo tuyaagea. Waa metaki meedoota mee magaa kaa meemaata kaama wa me kepee yawuditaata bagee yuwa koga kepee magoo namaapea naadi 'Meei' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Petamanii meemaagi mée to me asiino, 'Neataagi, a me ebo kepee naekeaseme mee eto koga kepee gaasi kamasemaaga' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mee eboo me asiino, 'Kiiboo, aa ko ni me agiyoo daamaa naokagee see mée. Kuwa peedi agiyoo kuwa miya a me daamaa dimi-dimi naukuwagee segeeke see kadeega yoka maga gaasi kaa bagee kuwa paagoo a too ebo toowoose yoka ebo katuyaaga' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wiyaagoo to meemaagi mée to me asiino, 'Neataagi, a me ebo kepee naekeaseme mee eto koga kepee idibi kamasemaaga' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mee eboo me asiino, 'Aa gaayu ko maga idibi kaa bagee yuwa paagoo a too ebo toowoose yoka ebo katuyaaga' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bedaa mée ena ma wa paagoo meemaata kaama asiino, 'Neataagi, a me naekeaseme kepee mee deede. Ani me doka sikii to yiba kapodamaata kaama topa. ");
INSERT INTO auu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kuwa ko aa dimi pesee see mée kemaata kaweda kaa. A me ukuwaano taa agiyoo miya a me yamasiyaa see mée, bedaa a me weeno taa agiyoo kuwa miya aa ota yadaayaa see mée, aa kisee omaago see mée to kadeega kemaata' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mee eboo me asiino, 'Yaai, aa ko ni me agiyoo dimi pedeo kaa naokagee see mée. A me nasege menaa kuwa doodoo a me pedeo ukuwataa to mokoo da kaneega. Anii ukuwaano taa agiyoo miya yamasiyaa see mée, bedaa weeno taa agiyoo miya ota yadaayaa see mée, kisee dimi pesee see mée see kuwa a me nadeege. ");
INSERT INTO auu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A me waa kisee mée yoka weda nao see nagaayu ko kaasee kaa ni me kaekeasema kepee mee aa bank kaa bagee paagoo namagaano taa ya? A me kisee namagame naaki anii epeekaa masiyaa naagoo koga ma masiyaa' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kiyoo kaama wa me gebo kaa bagee paagoo asiino, 'Mee wa me kepee mee masegeeta kaama kepe gaasi agoo see mée to namanii' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Okoo me asiino, 'Neataagi, waa kepe gaasi agoo yoka sikii' see asegea naaki ");
INSERT INTO auu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","wa me asiino, 'Agoo kiyaa bagee yuwa bedaa noonaa ma masiipea kiya taa kiyaa bagee yuwa okoo me peenaa kiyaa yuwa miya yamasegeeyaa. ");
INSERT INTO auu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eto ko anii okoo me eboo naatoono kuwa be see nagaagea bagee kuwa nii ma yape kiyaa bagee mokoo yoka badaa namaageeta ni paagoo kaama niiwogeepii taai' see aseta, see ebea-ebea menaa kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kuwa menaa yuwa eewegamaata kaama Yerusalem magaa kaa peetaaka too Yesus mee Wa keta, apanaa yuwa uuto. ");
INSERT INTO auu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Muguu naadi gebo kaa magaa wiya kaa pakaamaayu, Zaitun Kutuu to kaa kiyoo Betpage see magaa ma, Betania see magaa ma wiya kaa. Pakaamaata kaama Yesus me Wa me topenaa see bagee mée ekea wiya asiino, ");
INSERT INTO auu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","\"Peedoota nakaayoo doodoo magaa kaa peemaata kaama keledai wodaa pooduu ena, mee wodaa da dagii da kaa mée me animaata toodiino taa see wodaa ena ekea diipea. Mee wodaa ope gokataata kaama Ni paagoo nadoomeei. ");
INSERT INTO auu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Kaasee ope nagokataagea ya?' see kisiyaa bagee agoo kepa ko 'Tuhan me gaano pedeo yoka' see naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ekea peedoota kaama peemaagea naaki mikee, keledai wodaa poodu ena kiyoo opeemaata topa, Yesus me asigi-asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ope gokataagea kaboo epoo bagee me asiino, \"Kaasee kaa ope nagokataagea ya?\" asegea naaki ");
INSERT INTO auu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","\"Tuhan me gaano pedeo yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ope gokataata kaama Yesus paagoo eemegea. Okoo me tapaato dokaa yuwa mee keledai wodaa dagii da kaa sekeetaata kaama wodaa da dagii da kaa Yesus yagaataagea. ");
INSERT INTO auu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yerusalem magaa kaa peegee see etaawee mée eebaa okoo me tapaato dokaa yuwa beagee naadi etaawee daamaa yasekeepegeekea. ");
INSERT INTO auu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Etaawee peedoota Zaitun kutuu to kaa kaama esetaaka too Yerusalem magaa mee ekaapa see kaboo Yesus Wa sekaataa bagee mée eebaa ede ma, ede ma Ogatamee yaapaagee sepegeekea. Yesus me pesee ma ukuwanaa segee seta agiyoo yuwa okoo uduma dimi nagimeekee kaa ");
INSERT INTO auu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ebo menaa-menaa kaa \"Kiiboo, paamee, inii paagoo ebo mée eetookee Mée mee. Tuhan ekaa yadoopi Mée mee migi yoka magiyaage! Ogatamee ma emee-emee mée yasiyaano Mée, epoo to wodoo Asii-sege see Mée mee niiyaapaagee taai\" see asepegeekea. ");
INSERT INTO auu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kuwa ukuwataakea yuwa diitoo taa see bagee yuwa noonaa Parisi kaa bagee. Okoo me Yesus asiino, \"Ei, Guru, kuwa A sekaataa bagee kuwa 'Kisee se, koogo tooi' see asii, kisee ego-tago taai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kiya Wa me asiino, \"Kisee iyo. Ani me kisiino ko: Okoo koogo tuyu ko oma kuwa miya naapaagee see kaa ebo menaa-menaa taapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kuwa mée tabaa da muguu naadi Yerusalem deetaa see yoo pakaamaata kaama Yesus me yege ma menaa ko kisee: ");
INSERT INTO auu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","\"Sooi, ikii Yerusalem magaa kaa bagee yuwa, eto kenaagoo ikii Ogatamee ma emee-emee siyaa menaa kuwa ikii nekeenegea naaki ikii daamaa umiwoo, toowoo siyaa kiya eto ko ikii kuwa menaa kiboonemaagi. ");
INSERT INTO auu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kuwa kisega kuwa ko yape bagee yuwa kiyoo degaatagea. Mee naagoo ko okoo ikii me magaa mee kibobetaata kaama ikii me peegee see etaa yuwa uduma kitakeasiitagea. Kitakeata kaama apanaa kitaameekee agiyoo magaatoo taatagea, kiyoo-kiyoo aataki naadi kidegaawiitagea. ");
INSERT INTO auu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ikii apa kibadikumiitagea. Ikii me magaa kaa oma wagee weatoo seta yuwa kuwa bogomedaa siyaabuu semaata ikii ma, ikii me yogaa yuwa ma kipatamaatagea, bedaa oma ena ma, ena ma se ekeasiitagea, uduma kabaapi-paapi taatagea. Kuwa yaai-yaai taatagea agiyoo kuwa ko 'Ogatamee me inii daba mée daagimaa peeyaano see naadi migi' see kuwa ikii me eto nekeeniino taa kaa ukuwaaniita agiyoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus mee Yerusalem magaa kaa pakaamaata kaama peedoota Ogatamee me ee kaa peemaata kaama ee geboo da kaa kiyoo agiyoo pe-doogee taa see bagee uduma abagakomeeyu. ");
INSERT INTO auu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wa me okoo asiino, \"Ogatamee me ebeamaata menaa ena mee ko kisee: 'Ni me ee mee ko sembahyang taa see ee yoka' see ebeamaata kiya ikii me ko oma masetaa see bagee totaa see yoo mokoo yakiyaagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus mee egapii gakata Ogatamee me ee kaa mée yuwa topegeeki. Imam bagee me eboo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma, apanaa ebo bagee yuwa ma kuwa Yesus patamaano see dimii agoo ");
INSERT INTO auu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kiya iyo, mée yuwa me Wa me menaa ebo nao naadi maamaa ipiipi yayiitoo siwookea kemaata Waa kaasee patamaakee, ewo. ");
INSERT INTO auu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kaawaa ena Yesus mee Ogatamee me ee kaa kaama kuwa daamaa etokaa doometa menaa mée yuwa topetaaka too ko imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo Wa paagoo meemaagea. ");
INSERT INTO auu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Okoo me asiino, \"Yaai, A me ukuwanaa see agiyoo kuwa ko maamee me 'Aa kisee naukuwaai' see kaseta kaama ukuwanaa segeeke? Maamee me Aa ebo kaekeata kaama ukuwanaa segeeke? Mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus me asiino, \"Ani me miya ikii kiapaadee taanaka. ");
INSERT INTO auu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mee ko uwo mée yatukumeta mée Yohanes mee gaayu ko wa paagoo 'A me mée yuwa uwo natukumaai' see menaa kuwa maamee me aseta menaa naa ya? Epoo to wodoo kaama Ogatamee me aseta menaa da ye? Aii mée me aseta menaa da ye? Kaasee? Nasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Okoo too koogo aawegaa taano, \"Yaai, inii Waa kaasee menaa asiipea? Inii me 'Epoo to wodoo kaama Ogatamee me aseta menaa yoka' see asiyu ko Yesus me mée asiipi menaa ko 'Mikee yoka ikii kaasee kaa Yohanes me weganaa seta menaa kuwa mikee nao see gaano taa ya?' see mée asiipi. ");
INSERT INTO auu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bedaa inii me 'Ogatamee me Yohanes aseta menaa se, aii bagee me aseta menaa' see asiino miya pedeo, mée yuwa me inii mée kagoo kaapea. Okoo me 'Yohanes mee nabi bagee eboo yoka ikii kaasee kisee pedeo menaa wa kaa yawegagea' naadi oma kamu me mée wogeepii siyaa yoka kuwa asiino menaa wiya kuwa ekea paaya iyo\" see menaa kuwa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Okoo me kuwa menaa aawegaa semaata kaama Yesus asiino, \"Yohanes paagoo maamee me aseta menaa see kuwa inii ewo keekee\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus me asiino, \"Ikii me daamaa nasiino taa yoka Ani me miya ikii me 'Maamee me Aa kaseta kaama A me kisee agiyoo ukuwanaa segeeke?' see nasegea menaa kuwa se kisiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kiyoo kaama Yesus me ebea-ebea menaa ena mée yuwa paagoo eewegaano ko kisee: \"Bugi epoo mée anggur poo bugii ena yaatayu. Yaataata kaama apanaa bagee me bugi nayaagee segeesi naadi yaekeata kaama apanaa magaa kaa peegi. Maamaa omegee naadi kaama ");
INSERT INTO auu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","kuwa poo yuwa kapoo kega kaboo bugi epoo mée me wa paagoo agiyoo yaokagee see bagee ena asiino, 'Aa peedoota ni me bugii nayaagee see bagee yuwa paagoo ni me see yuwa namasigii' see asigi. Peedoota bugi kaa peemaagi naaki bugi yayaagee see bagee yuwa me waa peneata kaama aii dakamegea. Okoo me bugi epoo mée me see yuwa se manegea naadi bedaa metaki peegi. ");
INSERT INTO auu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bedaa mee asii kaawaa ena ma wa me agiyoo yaokagee see bagee ena ma peeyaagi kiya okoo me kisee dakamegea, badeekee menaa badegea. Bugi epoo mée me see yuwa maniino taa naadi metaki peegi. ");
INSERT INTO auu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Eta wedaagoo to mee bedaa wa me agiyoo yaokagee see bagee ena ma peeyaayu kiya waa miya dakameamoo naadi kaama abagaapeasegea. ");
INSERT INTO auu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kaama too bugi epoo mée me asiino, 'Anii kaasee ukuwaapa naa ya? Eto ko niyoopaa, ni me esee epa see yogaa mee peeyaapa. Wa me menaa kuwa okoo me daamaa yayiipea gaaga' see asigi. ");
INSERT INTO auu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yogamee beesekaa kaama migi see deeta kaama okoo me koogo aawegaa taano, 'Mee ko yogamee. Nagamee me bugii da mee yogamee me masiitagi yoka niiwogeepeasii, wa me bugii da inii takeasiino ke' see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yogamee peneata wagee amoo yaato dogeamaata kaama wogeepeasegea, see koo seta\" see asigi. Bedaa Yesus me asiino, \"Mee bugi epoo mée me kuwa bugi yayaagee see bagee yuwa kaa maagiyoo yaukuwaapi? ");
INSERT INTO auu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Waa meemaata kaama kuwa wa me bugii yayaagee see bagee yuwa pedeo kiyaapi. Pedeo kiyaata kaama mee bugii da apanaa bagee me daamaa nayagageesi naadi yaekeasiipi\" see asigi. Kuwa menaa yiitookea bagee me asiino, \"Yaai, kisee ukuwaaniino pedeo\" see asegea ");
INSERT INTO auu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","kiya Wa me okoo maamaa tamaata kaama asiino, \"Ikii me 'Yaai, kisee se' see gaagea kiya Ogatamee me kapogee yiba menaa ena mee nekeeniino yaato kaasee? Ikii nekeenegea ye? Mee ko kisee: 'Oma ee maataa see bagee yuwa me be kaa wisintaata tameepeata omaa mee ko TUHAN me masegeeta kaama tuku omaa to mee daamaa pee-yaekeata. ");
INSERT INTO auu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mee pee-yaekeata omaa mee kaa okaayaa bagee yuwa daada-paada siyaa, bedaa mee omaa to me pe-dapimiyaa bagee yuwa miya tagiindaa siyaa' see ebeamaata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Musa me menaa mée topetaa see bagee yuwa ma, imam ebo yuwa ma okoo kuwa ebea-ebea menaa yuwa yeemaata kaama okoo 'Wa me inii mée gaataata kaama mée asigi menaa ii' see kuwa nekeenegea. Kagoo kaa Yesus peneasiino see dimii agoo kiya mée yuwa me mée kagoo kaapea yoka naadi Waa peneasiino kuwa wedaagea. ");
INSERT INTO auu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Musa me menaa mée topetaa see bagee yuwa ma, imam ebo yuwa ma okoo me Yesus mee maamaa tamaata kaama Waa koopoo see menaa wegasi naadi inii kaasee ukuwaakee naa daamaa naa ya naadi dimi abagea. Kiyoo kaama koogo deena-deena see bagee Wa paagoo peeyaagea. Okoo ko dimi daamaa poga-poga see kaa Wa paagoo mena apaadeesi naadi peeyaagea bagee yuwa. Mee ko Yesus me koopoo see menaa ena wegayu ko Waa Gubernur paagoo yaekegataata kaama pedeo kiyaasi naadi okoo me kuwa bagee yuwa Wa paagoo peeyaagea. ");
INSERT INTO auu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kuwa peeyaagea bagee Yesus paagoo peemaata kaama asiino, \"Aa ko mikee menaa too mée topetaa see Mée to ii see kagaage. A me mée tupiino kuwa ebo bagee yuwa miya aa weda taa kaa mée tupiino too, bedaa Ogatamee me etaa yaato menaa mée tupiino kuwa miya A me daamaa topoo see kaa too mée topenaa segeeke kuwa inii kaipi yoka ");
INSERT INTO auu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","inii kaapaadee see menaa ena agoo. Mee ko inii pajak kepee Kaisar maniino kuwa maneekee daamaa ye, pedeo ye? Aa kaasee gaage?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kiya okoo me Waa deebaa taano see dimii mee Wa me nekeenta kaama asiino, ");
INSERT INTO auu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","\"Pose kepee ena Anii nadeeyaai\" see asigi. Doomaagea kaboo \"Mee kepee mee kaa maamee ebeyumaa da, maamee ekaa da ebeamaata naa ya?\" asigi naaki \"Kaisar mee\" asegea. ");
INSERT INTO auu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wa me asiino, \"Kisee gaayu ko Kaisar maniino agiyoo yuwa kuwa Kaisar manii, bedaa Ogatamee maniino agiyoo yuwa kuwa Ogatamee manii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wa me asigi menaa mee ipi nao naadi okoo dimi nagimegea, pe-asiino mena ena ma taa naadi koogo togea. Okoo me Yesus me mée yuwa paagoo koopoo see menaa wegasi naadi apaadeegea kiya iyo. ");
INSERT INTO auu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kuwa kaboo da Saduki kaa bagee mée noonaa Yesus paagoo meemaagea. Okoo me wegawoo see menaa ena mee ko kisee: \"Mée booyaa kuwa ko umina bogaakee, aya se andoo peeyaa\" see menaa wegawoo see. ");
INSERT INTO auu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Okoo me Yesus asiino, \"Ei, Guru. Musa me ebeamaata menaa ena mee ko kisee: 'Mée ena yoga taa kaa booyu ko waa ma kenagaa ena me mee api miyaa da goeano gaano pedeo. Petamanii booyaa mée me yoga yakabayaa mokoo yakabasi yoka tuyaa mée me mee apii goeai' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kisee ebeamaata yoka mena ena kasiinake, mee ko kisee: Okoo kenaa bagee okoo petoo. Yagamee yagaaboo to api ena goegi. Waa yoga taa kaboo boogi. Mee api miyaa da ipuugamee me goegi. ");
INSERT INTO auu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ipuugamee miya yoga taa kaboo boogi ");
INSERT INTO auu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","bedaa mabeimee miya kisee. Kisee too petaagoo to amaadii to kaa too. ");
INSERT INTO auu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kaama too apii to miya booga. ");
INSERT INTO auu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eto inii kaapaadee taano ko kisee: Boota bagee mikee aya andoo peeyu ko iminookaa mée aya andoo peeyaa naagoo kuwa okoo kenaa bagee petoo to kuwa mee apii to too goeta yoka kamee me apii kaata naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus me asiino, \"Eto magaa da kaa toogee see begaa kaa mée me api goetaa, api mée mantaa, kisee ukuwagee see ");
INSERT INTO auu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kiya iminookaa yaato Ogatamee me okoo sikii, ede yoka naadi aya andoo peeyaatagi bagee kuwa ko api goeano miya taa, api mée maniino miya taa. ");
INSERT INTO auu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Okoo wiyaagoo to se booyaa, malaikat bagee yuwa mokoo umiwoo, toowoo siyaa. Okoo Ogatamee me aya andoo peeyaabuu see bagee yoka okoo Wa me yogaa kiyaa. ");
INSERT INTO auu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Boota bagee aya andoo peeyaa ii see nekeeniino menaa kuwa agoo. Mee ko idukaa Musa paagoo katu see piyaa ena biyaa gada peeta kiya pooneano taa keta see menaa yiba mena ena ko kisee: TUHAN mee ko 'Abraham ma, Isak ma, Yakub ma okoo me Eboo' see menaa kuwa Musa me ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ogatamee Waa okoo me Eboo see wegayu ko umina boota bagee kuwa kaa kisee menaa se wegayaa, aya tuyaa bagee kuwa kaa too wegayaa. Okoo uduma Wa paagoo aya toono too yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Musa me menaa mée topetaa see bagee noonaa me asiino, \"Guru, A me daamaa wegage\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mee kaama wodoo mée me Waa apaadee taano wedaagea. ");
INSERT INTO auu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus me okoo asiino, \"Mée me wegaano, 'Idukaa kaama wegawoo seta Mée Ebo Kristus mee ko Daud me asii-kaba-kaba seta bagee ena kaatagi' see menaa wegayaa kiya kuwa kaasee? ");
INSERT INTO auu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daud me idukaa Mazmur kapogee yiba ebeamaata menaa ena kisee: 'TUHAN me ni epoo Mée Tuhan mee paagoo asiino, \"Aa Ni me dagi yagaa yaato animagaai, kisee too ");
INSERT INTO auu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Aa ma yape kiyaa bagee yuwa kuwa Ani me daba, peedi kaekeata A me badoo da miyoo taa kaekeasiita\" see aseta' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daud me Ebo Kristus mee ko 'Ni epoo Mée Tuhan mee' see wegata yoka Ebo Kristus mee kaasee Daud me asii-kaba-kaba seta bagee ena kiyaa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mée yuwa uduma yiitoo taakea kaboo Yesus me Wa me topenaa see bagee asiino, ");
INSERT INTO auu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","\"Musa me menaa mée topetaa see bagee kuwa okoo me 'Mée me anii ebo naekeasiino too ede' see gaayaa bagee yoka gaai. Okoo daamaa togoo dokaa maatagaa naadi peenaa-paanaa taa see too ede, mée kutuu taa see yoo okoo peenaa siyaa kaboo mée me 'Epao, inii me eboo' see naapaagee taano kuwa miya ede. Bedaa okoo sembahyang segee see ee yiba mée me nadeesi naadi ebo bagee me animaayu taa see yoo kiyoo too animagaano miya ede, ebo naagoo naano agiyoo nuyaa yoo miya ebo bagee me animaayu taa see yoo kiyoo too okoo animagaano miya ede. ");
INSERT INTO auu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Okoo me api miyaa yuwa deebaa naadi kaama okoo me ee yuwa oma yatakimiyaa see bagee. Okoo mée me naapaageesi naadi sembahyang menaa yuwa togoo kaa too asetaa see bagee yuwa. Okoo me kisee too ukuwagee see bagee yuwa yoka okoo esee pedeo kaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus mee deamaagi too ko Ogatamee me ee kaa kepe yago bagee yuwa me kepe awegee see yoo kepe awetaakea. ");
INSERT INTO auu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Daba see api miyaa ena me miya pose kepee peedi wiya kuwa too awetaaga. ");
INSERT INTO auu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesus me Wa me topenaa see bagee yuwa asiino, \"Anii mikee kisiino ko: Mee daba see api miyaa da wa me awetaaga kepee wiya kuwa ko kepe peedi kiya peedi se, apanaa bagee okoo me awegea kepee kuwa asii eboo. ");
INSERT INTO auu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kuwa kepe yago bagee kuwa okoo me koga kepee yuwa awegea kiya mee apii miyaa da wa me gaano pedeo agiyoo edaano see kepee yuwa uduma ki awetaaga kuwa me mikee esee ebo kepee mokoo awetaaga\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kuwa kaboo da Wa me topenaa see bagee noonaa me wegaano, \"Ogatamee me ee mee diino esee ebo, oma ee magaano daamaa yaai, ee daamaa deesi naadi mée me manta agiyoo kuwa miya dimi nagimega\" kisee menaa wegagea. Yesus me asiino, ");
INSERT INTO auu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","\"Kuwa ikii me deegea agiyoo kuwa uduma kabaapi-paapi taatagea, oma ena ma wa me mokataata yoo kaama kisee se ekeasiitagea, uduma pogadaa taata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Okoo me asiino, \"Guru, kuwa agiyoo kuwa maadee moga ukuwaaniita naa ya? Kuwa agiyoo ukuwaaniino see kooka ii see nekeeniyaa agiyoo kuwa maagiyoo ukuwaandaa taata naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wa me asiino, \"Mée deebaa see bagee agoo kaata yoka daamaa nekeenii. Anii poga-poga see bagee mée eebaa meetagea. Okoo me Ani ekaa naweakee kaa 'Anii ko Waa yoka' see menaa weganaa taapea, bedaa 'Ogatamee me monaa da kaa kega yoka' kisee menaa kuwa miya weganaa taapea kiya ikii emaa se wugii, okoo sekaataa se pooi. ");
INSERT INTO auu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kuwa kaboo da taa ko ikii yape menaa ekaapa magaa kaa kaama miya yiipea, beesekaa magaa kaa kaama miya yiipea kiya se wedaai. Kuwa uduma mikee agoo kedaa siwoo taata kiya wodopasi naagoo se\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bedaa Wa me asiino, \"Mée tomaa-tomaa yape aawogee senaa taatagea. Amokiyoo magaa kaa bagee me yamokiyoo magaa kaa bagee ma yape aawogee taatagea. ");
INSERT INTO auu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kiyoo-kiyoo maga pigii miya medaa taata. Naano agiyoo taa uwaa miya medaa taata, ikiyoo uwaa da miya medaa taata, kisee yaai-yaai agiyoo eebaa kedaa taata. Epoo to kaa miya yaai-yaai, dimi nagii-nagii agiyoo agoo kedaa taata. ");
INSERT INTO auu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kiya kuwa agiyoo ukuwaaniino taa kaboo mée me ikii kiwegee-wegee taatagea, bedaa ikii kibe kaa yagaa kipeneata sembahyang segee see ee yuwa yiba kidogeamoo taatagea, digiyoo ee yiba miya kidogeamoo taatagea. Ikii Ni yaato bagee kemaata magaa da kaa ebo tookee bagee paagoo kiipootagea. ");
INSERT INTO auu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ikii okoo paagoo kiipootagea kuwa ko ikii Ni me menaa daamaa eewegasi naadi kiekeasiyaa kaboo yoka daamaa eewegaai. ");
INSERT INTO auu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kisee kemaata okoo me kiipeeyaa kaboo ikii me 'Anii kisee menaa wegaapa, kisee menaa wegaapa' see dimii kuwa se gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ikii okoo paagoo mena eewegaapea kaboo Ani me ikii 'Kisee wegaai, kisee wegaai' see menaa kuwa ikii dimi yiba kisi-manee taapa. Kuwa menaa kuwa esee ipi see menaa kaapa yoka apanaa bagee me pedeo menaa ena ma kisiino kana kaapea, ikii ma aawisii taano miya iyo yoka dimi se gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bedaa kuwa kaboo da taa miya ikii me okonaka ma, ikii ma kenaa bagee yuwa ma, ikii epo peenaa see bagee yuwa ma okoo me ikii mée noonaa boosea naadi kiekegatagaatagea. ");
INSERT INTO auu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ikii Ni yaato bagee kemaata mée tomaa uduma kibe kaatagea ");
INSERT INTO auu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kiya ikii umina se pedeo kaatagea, ikii me mumoo to kaa edooyuu ena mee miya umina se egaata. ");
INSERT INTO auu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ikii makii taa see kaa toowoo siyaa bagee kuwa daba daagimaa pootagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Bedaa Yesus me asiino, \"Yerusalem magaa mee yape bagee me bobetaata topea kuwa ikii deepea ko mee magaa mee bugumeepeasiino kuwa ekaapa ii see kuwa ikii nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kuwa kaboo da Yudea wee kaa toogee see bagee yuwa moga oodoota kuye kaa pakadaa taai. Yerusalem magaa kaa toogee see bagee yuwa miya peedaa taano gaano pedeo, bedaa mee magaa gebo kaa topea bagee yuwa miya kiyoo se pakaai. ");
INSERT INTO auu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kuwa kaboo ukuwaandaa taata agiyoo kuwa ko idukaa kapoge yiba ebeamaata menaa yuwa uduma uwa daasi naadi Ogatamee me pedeo yamiyaabuu taatagi agiyoo yuwa. ");
INSERT INTO auu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kuwa kaboo da Ogatamee me mee magaa to kaa bagee kagoo ebo kemaata kuwa ukuwaandaa taata agiyoo kuwa apanaa agiyoo, yaai-yaai ebo kaatagea. Kadapoo yago apii yuwa ma, yoga baayee yiba kepaa apii yuwa ma kuwa sooi, yaai. ");
INSERT INTO auu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mée noonaa yape bagee me mowai daapii taatagea, noonaa yagaa goedoota kaama mée tomaa-tomaa se-magaa, we-magaa kaa doodoo peedaa taatagea. Ogatamee ewo see tomaa kaa bagee kuwa okoo me Yerusalem magaa mee batagi-patagi segee naadi pedeo kiyaabuu taatagea, kisee too okoo me ebo toono monaa mee sikii yakiyaatagi naagoo too.\" ");
INSERT INTO auu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","\"Epoo to kaa kiyoo dimi nagii-nagii agiyoo agoo kedaa taata. Kenoo to ma, agoo to ma, okadee yuwa miya apanaa agiyoo keenda kisee diitagea. Magaa da kaa kiyoo maakaa pikuu da biku-biku ebo kedaa naadi kaama tukuu da miya ebo kedaa taata. Kuwa me kaama mée tomaa yuwa uduma kuwa kaasee agiyoo yaai naadi wedaatagea. ");
INSERT INTO auu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Epoo to kaa pesee agiyoo yuwa miya maki-makaa naadi wodeda-peeda sedaa taata kuwa kaa mée me weda ebo kaa yaai, magaa to kaa kaasee agiyoo ukuwaandaa taaka naadi boomaga-baamaga taatagea. ");
INSERT INTO auu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kuwa kaboo da Mée Yogaa mee sinu uwaa da yibaa taa migi see kuwa diitagea. Waa pesee, Wa disii to esee ebo ma migi see diitagea. ");
INSERT INTO auu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kuwa uduma ukuwaaniino see kooka kaboo mikee, ikii daba kidaagimaa peeyaano naagoo mee ekaapa kega yoka yiinaageeta weda see dimii mee ekeata pesee ma tooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kiyoo kaama Yesus me okoo ebea-ebea menaa ena asiino, mee ko kisee: \"Ara piyaa wodoo to miya, apanaa piya wodoo yuwa miya kuwa nekeenii. ");
INSERT INTO auu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Iye mugumedaaka see deeyu ko mikee, poo ekaano see kooka ii see kuwa ikii nekeeniyaa. ");
INSERT INTO auu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mee mokoo miya kuwa kisega menaa yuwa ukuwaandaa taaka see kuwa ikii deeyu ko Ogatamee Wa too ebo mée eetoono see kooki ii see kuwa ikii nekeeniitagea. ");
INSERT INTO auu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Anii mikee kisiino ko: Kuwa ukuwaandaa taata agiyoo kuwa uduma eto mee begaa kaa bagee yuwa bogaano taa kaa diitagea. ");
INSERT INTO auu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Epoo to ma, magaa to ma kuwa taa kaata kiya Ni me menaa mee se taa kaata, kisee too iminoo miya, iminoo miya toota.\" ");
INSERT INTO auu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","\"Woda tamoo to kaa booyaa kaboo dimi ooyaa see see ikii miya kisee kiyaa naadi ikii ekaato daamaa ipiipi deewoo taai. Ikii boomagaa see uwoo noogee naadi kaama ede ma, ede ma too otoopa pege taano ma, ikii me umiino, toono yiba gaagaa dimii ma kuwa gaawoo, umiwoo see kaa ikii ipiipii semagaano taa kaboo mee naagoo kisee ki miyaa yoka ikii ekaato daamaa deewoo taai. ");
INSERT INTO auu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mee naagoo ukuwaandaa taata agiyoo kuwa magaa da kaa mée tomaa-tomaa yuwa uduma kaa dogeeniita yoka ");
INSERT INTO auu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ikii maamaa ipiipi diitoo segee taai. Kuwa ukuwaandaa taata agiyoo yuwa ikii makii taa, pesee ma toogee naadi kaama Mée Yogaa mee ikigii to kaa daba toomaasea naadi sembahyang siwoo segee taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus mee egapi yaato Ogatamee me ee kaa kaama mée yuwa topemaata kaama bedaa daatooyiba yaato Zaitun kutuu to kaa umiino see naadi peegee segeeki. ");
INSERT INTO auu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Esee pedeo tokomaa mée yuwa uduma Wa me topetaa see menaa yuwa yiino see naadi Ogatamee me ee kaa meegee segeekea. ");
INSERT INTO auu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kuwa kaboo da ragi yeeyee ma aatabi taano taa see roti unu petoo noogee siyaa kuwa eebaa umiino taa kaboo naapea. Paskah noogee siyaa see mee miya wegayaa. ");
INSERT INTO auu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kuwa kaboo da taa ko imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me Yesus patamaano dimii agoo kiya Waa epa see bagee eebaa kuwa wedaagea. Okoo me wegaano, \"Yesus mee inii kaasee koogo peneasiipea, kaasee patamaapea?\" see menaa kuwa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kiyoo kaama Iblis mee Yesus me topenaa see bagee gaasi ma wiya kuwa mée ena ekaa da ko Yudas Iskariot yiba seemigi. ");
INSERT INTO auu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Seemigi naadi peedoota imam ebo yuwa ma, Ogatamee me ee diitoo taa see bagee me eboo yuwa ma okoo paagoo peemaata kaama wa me \"Yesus mee Anii kaasee kiekegatagaapa naa ya?\" see menaa eewegagi. ");
INSERT INTO auu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Okoo ede kaa \"Kepe kisuwa kaniipe\" see asegea naaki ");
INSERT INTO auu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","\"Daamaa\" asigi. Mee kaama wodoo wa me 'Yesus Waa mée taa see yoo yaekegatagaano kuwa kayoo daamaa, kayoo daamaa?' see gaawooki. ");
INSERT INTO auu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ebo naagoo, ragi yeeyee ma aatabi taano taa see roti kuwa unu petoo noogee siyaa yiba petamanii nuyaa naagoo, domba wodaa wugiyaa naagoo ko ");
INSERT INTO auu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus me Petrus ma, Yohanes ma ekea paagoo asiino, \"Paskah kaa agiyoo naano see yoka naano agiyoo nuyaa yoo pe-niiipiipii taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ekea me asiino, \"Kuwa agiyoo naano yoo kayoo naa ipiipii taano daamaa naa ya?\" asegea naaki ");
INSERT INTO auu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","\"Ekea peedoota kota kaa peemaata kaama mée ena, uwo otaawee doopegeeki see mée ena ma aadee taapea. Aadee seta kaama waa ma epo enaataa pooi. Wa me seemaapi ee yiba seemaai. ");
INSERT INTO auu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ee epoo mée mee kisee naasii: 'Guru me kasiino, \"A me ee yiba Ni me topenaa see bagee ma inii epo enaataa Paskah kaa agiyoo eenaape yoo naa kayoo ya?\" see kasigi' see naasii. ");
INSERT INTO auu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ee epoo mée wa me ee asii mee kakadee kaa ebo komoo kaa badaa kimagaataapi. Kiyoo inii me animagaapea yoo daamaa mée yaipiipii semaata topa see kuwa ekea diipea. Inii kiyoo naano agiyoo naapea yoka agiyoo-pagiyoo pe-niiipiipii taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Asigi naadi ekea peedoota kota kaa peemaagea naaki mikee, Yesus me asigi-asigi uduma ukuwaanega naadi Paskah kaa agiyoo uduma daamaa eeipiipii semaagea. ");
INSERT INTO auu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Naano agiyoo naano see kaboo Yesus mee Wa me menaa yadoonaa see bagee yuwa ma epo enaataa animaata kaama ");
INSERT INTO auu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wa me okoo asiino, \"Eto mee Paskah mee Anii boodi abaano taa kaa ikii ma enaataa keenoga kuwa esee ede kega. ");
INSERT INTO auu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eto kenaagoo kaama wodoo Anii bedaa Paskah se naata, iminookaa Ogatamee Wa too ebo mée eetoowoo taatagi naagoo too bedaa naata. Mee naagoo ko Paskah nuyaa-nuyaa wegawoo seta menaa yuwa uwa daaniita naagoo yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kiyoo kaama Waa anggur poo uwoo otaawee da masegeeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Kiyoo kaama bedaa Wa me okoo asiino, \"Otaawee da masegeeta uwo kuwa ikii eewudii. ");
INSERT INTO auu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ani me kisiino ko: Eto kenaagoo kaama wodoo Anii anggur poo uwoo se naapa, Ogatamee Wa too ebo mée eetoowoo taatagi naagoo too Anii bedaa naata\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kiyoo kaama roti masegeeyu, Ogatamee paagoo kiiboo, paamee see menaa asigi. Roti kabatagaa naadi kaama okoo paagoo goo-maneeyu. \"Mee ko Ni me maa to, Ni me ikii kaa kiekegatagaapa maa to mee. Ikii masegeeta nuweei. Anii naneke-nekee see kaa noogee siwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naano agiyoo noomaata kaama anggur poo uwoo otaawee da masegeeyu. \"Mee ko Ni me tadaa uwoo, ikii ma, Ogatamee ma, Wa me gipii see aseta menaa ma kuwa uduma enaataa aagadimisi naadi kikabageapa tadaa mee. ");
INSERT INTO auu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yeede, Anii naekegatagaapi mée to mee nakaayoo Anii ma epo enaataa totaaki. ");
INSERT INTO auu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mée Yogaa mee mikee Ogatamee me menaa yiba ebeamaata see see bogaapi kiya Waa ekegatagaapi mée mee esee pedeo kaapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wa me topenaa see bagee yuwa \"Inii maamee me kisee ukuwaapi, maamee me kisee ukuwaapi?\" see menaa aawegaakea. ");
INSERT INTO auu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kuwa kaboo da Yesus me topenaa see bagee yuwa okoo me inii maamee naa ebo bagee kepa naadi kaama \"Aa naa ebo ye, nii naa ebo ye?\" kisee aawisi-maawisikea. ");
INSERT INTO auu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wa me okoo asiino, \"Apanaa tomaa kaa bagee yuwa okoo me eboo yuwa gaayu ko dimi mena pesee, okoo anii ebo yoka naadi omaago ma ebo totaa see bagee yuwa, okoo mée me 'Waa ko inii me dimi maataa see eboo' see naapaagee taano ede see dimii gaayaa bagee yuwa ");
INSERT INTO auu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kiya ikii gaayu ko kisee dimii se masii. Ikii yupii ebo bagee gaayu ko peedi see bagee mokoo kemagaano gaano pedeo, bedaa ikii ebo kiitotaa see bagee gaayu ko agiyoo aii yaokagee see mée to mokoo kaai. ");
INSERT INTO auu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ebea-ebea menaa ena ko kisee: Noogee yoo animagaakee mée mee ebo ye, naano agiyoo yamase-manee siyaa mée mee ebo ye? Naano see naadi animaayaa mée waa ebo, se maa? Mikee kiya Anii kisee dimii taa. Anii ko agiyoo aii yaokagee see mée mokoo ikii paagoo kiitoogeeka. ");
INSERT INTO auu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Anii nagaadee naadi ae-wae siyaa kaboo ikii me Anii naekeasiino taa, Anii ma enaataa niitoogee see bagee kemaata ");
INSERT INTO auu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Neataagi me Anii ebo natuyaata see see Ani me miya ikii ebo toowoosea naadi ebo kituyaaga. ");
INSERT INTO auu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Anii ebo kiitoowoo taata kaboo ikii miya Anii ma epo enaataa naano agiyoo noowoo segee taatagea, bedaa ikii ebo animagaano yoo animaata kaama Israel bagee mée apa gaasi ma wiya kuwa mena ena too too yadaakomee siwoo taatagea.\" ");
INSERT INTO auu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","\"Simon, Simon, nayii. Iblis me ikii uduma kigaadeesi naadi idimigi. Gandum poo kipii yuwa ikii beedaasi naadi tagimiyaa mokoo kisee kiukuwaapi ");
INSERT INTO auu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kiya a me mikee nagaano dimii mee se taa kisi naadi Anii sembahyang kasegeeka. Aa kisee kagaadee semaata kaama dimi mena gepeenta bedaa Ni kaa namaatagaape kaboo kuwa apanaa mikee nagaayaa bagee yuwa miya okoo me dimi mena daamaa pesee kiyaabuu siwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus me asiino, \"Tuhan, anii Aa ma epo enaataa digiyoo ee yiba mée peeyaayaa miya daamaa, enaataa booyaa miya koosi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kiya Yesus me asiino, \"Petrus, Ani me kasiino ko: Eto mee digiyoo yiba aa kaagaa wedo mée paagoo ewo poga-poga nataape. A me kisee naekeata kaama ayam ena menaa taapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kiyoo kaama Yesus me okoo asiino, \"Idukaa Anii ikii paagoo kisema menaa ko 'Ogatamee Wa too ebo mée eetupi nao see menaa eeweganaasea naadi pooi, kepe ayaabu, ayaa, bado doko kisee agiyoo se dogaai' see kisema. Kisee kisema naadi ikii peenaa semea kaboo ikii agiyoo ena waa naa gaagaa semea ye?\" see asigi naaki \"Taa, inii agiyoo ena ma gaagaa taano taa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wa me asiino, \"Mikee kiya eto kaama wodoo ko kepe ayaabu agoo see bagee doonaa taano daamaa, ayaa miya dogaai. Bedaa mowai taa see bagee kuwa miya okoo me ebo dokaa pe-doogeeta kaama mowai edaakee kuwa daamaa. ");
INSERT INTO auu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kuwa kisega menaa kuwa ko Ogatamee me kapogee yiba ebeamaata menaa ena Ni kaa uwa daasi naadi kisega, mee ko 'Waa miya mena si yayeetaa see Mée ena ii see gaatagea' see ebeamaata menaa mee Ni kaa uwa daano gaano pedeo. Mee see see menaa kuwa uduma eto Ni kaa uwa daataaka yoka naadi kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wa me topenaa see bagee me asiino, \"Tuhan, nakaayoo mowai wiya agoo\" asegea naaki \"Sikii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kiyoo kaama Yesus peedoota Wa me peegee see yoo Zaitun Kutuu to kaa, bedaa Wa me topenaa see bagee yuwa miya Wa sekaataa peegea. ");
INSERT INTO auu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Peemaata kaama Wa me okoo asiino, \"Ikii kigaadee siyaa kaboo pedeo dimii, pedeo menaa wisintaasea naadi sembahyang taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Waa pakadoota woo kaa naa kaa oma kamu pakaaniyaa see yoo mokoo pakaamaata kaama kagu maga kaa sebaata sembahyang menaa ko ");
INSERT INTO auu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","\"Neataagi, A me miya daamaa ede gaayu ko kuwa Ni me boodi abaapa kuwa A me se naekeasii see kasega kiya Ni me gaayaa dimii too se kiya A me gaata-gaata dimii too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kuwa kaboo da epoo to wodoo kaama malaikat bagee ena Yesus pesee kiyaano see naadi Wa paagoo eseemaagi. ");
INSERT INTO auu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus mee esee dimi gaagaa ebo kaa maamaa sembahyang taaka too Wa me aweta kopa yuwa tadaa kopa daata eseanee siyaa mokoo see see magaa da kaa eseaneeka. ");
INSERT INTO auu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sembahyang semaata kaama esedoota Wa me topenaa see bagee yuwa paagoo eseemaagi too ko okoo ae-wae, dimi nagimeamoo naadi kaama toomoo ompea. ");
INSERT INTO auu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wa me asiino, \"Ikii kaasee kaa toomoo too ometaakea ya? Ikii kigaadee siyaa kaboo pedeo dimii, pedeo menaa wisintaasea naadi anoogeeta sembahyang taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kuwa menaa wegataaka too ko taka ena mée ebo etaa meemaagea. Yesus me topenaa see bagee gaasi ma wiyaagoo to mee Yudas mee ma enaataa eemeemaagi. Yesus mee ebe duuduu taano see naadi peedoota Wa paagoo peemaagi ko ");
INSERT INTO auu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","\"Ei, Yudas, Mée Yogaa mee yaekegataage kuwa kaa ebe naduuduuke ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesus ma enaataa topea bagee yuwa me Yesus peneasiipea yaai naadi kaama \"Ei, Tuhan, inii pe-daakumii ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Okoo mée waa ena me posee da me mée ena kaa kobeasigi naaki dagi yagaa yaato apa kamuu da yadaakomeegi, Ebo Imam wa me agiyoo yaokagee see mée. ");
INSERT INTO auu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesus me \"Kisee se\" see asigi. Apa kamuu da daakomeegi mée to apa kamuu da yagaa yapeneasigi naaki daamaa kigi. ");
INSERT INTO auu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kiyoo kaama okoo me Waa peneasiino see naadi mepea bagee tabaa da, kuwa ko imam ebo yuwa ma, Ogatamee me ee diitoo taa see bagee me eboo yuwa ma, Yahudi kaa ebo-ebo yuwa ma okoo paagoo Yesus me asiino, \"Ikii me dimi pedeo omaago see bagee ena mokoo peneasiino see naadi mowai, kopaa, kisee agiyoo doopea ye? ");
INSERT INTO auu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Anii egapii gakata Ogatamee me ee kaa awee da kaa mée topegeeka, ikii miya kiyoo topea kiya ikii me napeneasiino taa kemea. Kiya eto kiipaa ikii miya omaago kegea, digiyoo yaato pesee da mee miya omaago kega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesus mee peneata kaama Ebo Imam me ee kaa eepeegea kiya Petrus waa koogo deega se deega see uuto obeegi. ");
INSERT INTO auu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mee ee kaa peemaagi ko yoo da kaa mée yuwa biyaa yuwitaata toomuu taakea. Petrus waa miya okoo paagoo pe-animaagi. ");
INSERT INTO auu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Animaata toomuu taaki too ko agiyoo yaokagee see apii ena me Petrus maamaa tamaata kaama asiino, \"Ei, mee mée mee miya Yesus ma epo peenaa see mée to, se maa?\" see asega. ");
INSERT INTO auu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kiya Petrus me ewo poga-poga naadi asiino, \"Taa, mee mée to anii ewo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Egaaniino taa kaboo apanaa bagee me Petrus deeta kaama asiino, \"Aa miya okoo yaato bagee ena\" see asigi kiya Petrus me \"Taa, kisee se\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Peenaa toomaata kaama bedaa mée ena me asiino, \"Ei, mee mée mee mikee Waa ma enaataa see mée to, waa miya Galilea wee kaa mée yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kiya Petrus me \"Taa, kisee menaa anii ewo\" see asetaagi naaki taka ena ayam menaaki. ");
INSERT INTO auu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tuhan mee Petrus yaato ikigi maataata kaama emaa pe-wugitaagi naaki Tuhan me yumakaa asigi menaa da taka ena nekeenigi, mee ko 'Eto kenaagoo Aa kaagaa wedo mée paagoo ewo poga-poga nataape. A me kisee naekeata kaama ayam ena menaa taapi' see nasigi mee ii naadi kaama ");
INSERT INTO auu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","peedoota amokiyoo mokoo peanta kaama ebo yegee yegeeki. ");
INSERT INTO auu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kuwa kaboo da Yesus peneata bagee yuwa me Aa ebo ye naadi yagaa kopaa dakameamookea. ");
INSERT INTO auu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yesus Wa me emaa masii to kaa doka me yabebenataata kaama asiino, \"Aa maamee me kadakamigi, maamee me kadakamigi see kuwa A me duya kaa mée deede\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mée badeekee menaa apanaa miya maamaa asegea. ");
INSERT INTO auu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tokoma mee da, pedeo komaa da Yahudi kaa mena pekataa see bagee yuwa ma, Imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo kutuu semaagea kaboo Yesus mee okoo paagoo eemegea. ");
INSERT INTO auu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Okoo me asiino, \"Idukaa kaama wegawoo seta Mée Ebo Kristus mee Aa gaayu ko mée asii\" see asegea. Kiya Yesus me asiino, \"Kisee Ani me kisiipa miya ikii mikee see se nagaapea keekee. ");
INSERT INTO auu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bedaa kisee Anii mena ena kiapaadiipa kuwa miya ikii me se nasiipea. ");
INSERT INTO auu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kiya eto kaama wodoo Mée Yogaa mee Se-pesee, We-pesee yago Mée Ogatamee Wa me dagi yagaa yaato animaata ebo toowoo taapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Okoo me asiino, \"Kisee gaayu ko A me 'Anii ko Ogatamee Yoopaa' see mée asege mee ye?\" asegea naaki \"Ikii me wegagea kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Okoo me asiino, \"Yaai, Wa me wegagi menaa da inii yeemaagea yoka eto ko sikii, Wa me kisee pedeo ukuwapi, kisee pedeo koo sipi see deeta bagee kuwa wisintayu, se abaai\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kuwa mena pekataa see bagee yuwa uduma yiinaageeta Yesus badaa maadoota Pilatus paagoo ");
INSERT INTO auu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","peemaata kaama okoo me yakobaakee menaa kuwa ko kisee: \"Mee Mée mee ko inii tomaa kaa bagee paagoo makapaa menaa eeweganaa see Mée. Wa me wegaano menaa ko 'Pajak kepee kuwa Ebo Kaisar se manii' bedaa Wa me 'Anii ko Ebo Kristus mee' kisee inii ebo mée eetookee mée see ekaa Waa ekaato munigi, kisee mée deebaa segeeki\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus me Yesus asiino, \"Aa ko Yahudi bagee me Eboo mikee ye, taa ye?\" asigi naaki \"A me wegage kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus me imam ebo yuwa ma, apanaa bagee yuwa ma uduma asiino, \"Ani me ko mee Mée mee kaa pedeo ena ma si yadeega yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kiya okoo me omaago ma asiino, \"Taa, mee Mée mee Yudea wee kaa magaa uduma Wa me topenaa see menaa kuwa me mée aakago-maakago siyaabuu segeeki. Petamanii Galilea wee kaa kaama masegeeta kisee too nakaayoo too kisee menaa eeweganaa segeeki\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus me mee menaa da yeeta kaama asiino, \"Waa Galilea wee kaa mée to ye?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","\"Ei\" asegea. Pilatus me kuwa ni me menaa se, Galilea wee kaa ebo totaa see mée wa me menaa yoka naadi kaama \"Herodes mee paagoo eepooi\" see asigi. Kuwa kaboo da Herodes mee miya Yerusalem magaa kaa kiyoo totaaki. ");
INSERT INTO auu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yesus mee badaa maadoota Herodes paagoo eepeemaagea ko Herodes ede kigi. Yesus me ukuwanaa, peenaa seta menaa kuwa yeegi yoka Waa deega naaki ou see dimii gaawoo segeeki, bedaa Yesus Wa me dimi nagii-nagii agiyoo ena waa naa nadeeyaagi naaki ou see dimii mee miya ebo. ");
INSERT INTO auu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wa me Yesus mee mena maamaa apaadeeki kiya Waa mena ena ma se asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Imam ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma okoo me Yesus mee yakobaakee menaa yuwa eebaa omaago ma Herodes asegea. ");
INSERT INTO auu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes ma, wa me okaa yago bagee yuwa ma okoo miya Yesus wisineekee menaa eebaa. Aa ebo ye naadi wisineekee kaa magaa to kaa ebo tookee bagee me disi-disii see dokaa yuwa yamaataagea. Kea seamoo naadi kaama \"Bedaa Pilatus paagoo metaki eepooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Idukaa kaama Herodes ma, Pilatus ma ekea aabe ketaa see kiya mee naagoo kaama wodoo ekea aaepa kiwookea. ");
INSERT INTO auu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Imam ebo yuwa ma, apanaa ebo bagee yuwa ma, aii bagee yuwa ma kuwa Pilatus me \"Uduma meei\" asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Meemaagea kaboo wa me asiino, \"Ikii me mee Mée mee ko mée yuwa paagoo deebaa see menaa too eeweganaa segeeki yoka naadi kaama ni paagoo eemegea. Ikii paagoo ani me Waa ipiipi apaadee sepa kiya ikii me Wa kaa pedeo see yawegagea menaa kuwa anii ena ma yadiino taa. ");
INSERT INTO auu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes wa me miya pedeo menaa yadiino taa naadi kaama bedaa inii paagoo mée yamiyaagi yoka yeeweei, Waa bogaano gaano pedeo see agiyoo ena ma ukuwaano taa. ");
INSERT INTO auu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","See kemaata 'Pepeaduu me dakameamoo semaata daba peeyaai' see asiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatus me aseta menaa kuwa ko Paskah Naagoo tahun gakata Yahudi bagee ena, digiyoo ee yiba dogeamoo seta bagee kuwa mée ena Wa me daba yapeeyaabuu segee seta kemaata Yesus mee daba peeyaano see naadi aseta menaa yuwa. ");
INSERT INTO auu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kisee asigi kiya kiyoo topea bagee okoo uduma enaataa ebo menaa kaa asiino, \"Mee Mée mee wogeepeasii, Barabas mee too daba mée yapeeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mee Barabas see mée to mee ko mee magaa kaa kiyoo mée yuwa aakago-maakago naadi kaama mée ena wugita kemaata digiyoo ee yiba dogeamaata mée to. ");
INSERT INTO auu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus me Yesus mee daba peeyaano see naadi kaama bedaa okoo paagoo wiyaagoo to kuwa menaa eewegagi ");
INSERT INTO auu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","kiya okoo uduma mena ebo kaa asiino, \"Waa piya bokoo to kaa paku wugii, piya bokoo to kaa paku wugii\" see menaa maamaa asegea. ");
INSERT INTO auu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatus me wedaagoo to menaa ko \"Sooi, Wa me pedeo ukuwapi agiyoo maagiyoo naa ya? Waa bogaano gaano pedeo see agiyoo ena ma ukuwaano taa yoka 'Pepeaduu me dakameamoo semaata daba peeyaai' see asiipa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kiya okoo me bedaa mena ebo kaa asiino, \"Waa piya bokoo to kaa paku wugii\" see asegea menaa mee too pesee kegea, ");
INSERT INTO auu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","kaama too Pilatus me okoo me menaa yayeeta kaama Yesus wugimagaai see menaa daataagi. ");
INSERT INTO auu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Okoo me daba mée yapeeyaai see idimegea mée to mee daba yapeeyaagi. Waa ko mée yuwa aakago-maakago naadi kaama mée ena wugita kemaata digiyoo ee yiba dogeamaata mée to kiya daba yapeeyaagi. Kiya Yesus mee okoo me ede gaagea dimii kaa too yaekeasigi. ");
INSERT INTO auu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesus mee badaa maadoota paku wugiino yoo eepeetaaka too ko Kirene magaa kaa mée ena ekaa da ko Simon waa kota kaa meemaagi. Aadee seta kaama Yesus me piya bokoo to mee uuto yadoosi naadi peneasegea. Piya bokoo to wa kaa yadootaata kaama uuto yadoopegeeki. ");
INSERT INTO auu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mée eebaa obeepegeekea. Api yuwa miya yege ma, yii-yii ma uuto obeepegeekea. ");
INSERT INTO auu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus mee oko maataata kaama asiino, \"Ikii Yerusalem magaa kaa apii yuwa, Anii bogaapa kuwa kaa nayegee see se kiya ikii ma, ikii me yogaa yuwa ma ikii kaa aayegee taai. ");
INSERT INTO auu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Weda see agiyoo agoo kaata naagoo ko 'Pai keta apii yuwa ma, yoga kabaano taa see apii yuwa ma, ama taa see apii yuwa kuwa uduma daamaa, ede nao' kisee menaa kuwa wegaatagea yoka ikii ekaato kaa too aayegee siwoo taai. ");
INSERT INTO auu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kuwa yaai-yaai taatagea kaboo mée me 'Maga bago yuwa kuwa inii kaa mée tagimeeii taai, maga kutuu yuwa kuwa inii mée dapimeeii taai' see asiitagea. ");
INSERT INTO auu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eto kiipaa mée me ukuwataakea agiyoo kuwa piya wii kaano taa kaboo kisee ukuwayu ko piya wii keta kaama wodoo kuwa kaasee ukuwaaniita naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pedeo agiyoo ukuwata bagee wiya miya Yesus ma enaataa piya bokoo to kaa boosi naadi eepeegea. ");
INSERT INTO auu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Muguu naadi maga ena ekaa da ko Mumo Metoo Kutuu to kaa eepakaamaata kaama Waa piya bokoo to kaa paku wugitaagea. Pedeo agiyoo ukuwata bagee wiya miya kisee paku wugitaagea. Wa me dagi yagaa yaato mée ena, eka yagaa yaato mée ena. ");
INSERT INTO auu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus wugitaakea bagee yuwa kaa Wa me sembahyang yaasiino, \"Neataagi, okoo nekeeniino taa kaa ukuwagea yoka epa ekeasii\" see asigi. Kiyoo kaama okaa yago bagee me Wa me dokaa yuwa maamee me masiipi, maamee me masiipi naadi okoo me agiyoo iyagideekea. ");
INSERT INTO auu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kuwa kaboo da mée yuwa koogo diitookea. Yahudi kaa ebo-ebo yuwa me Yesus wisineekee kaa asiino, \"Wa me apanaa bagee se boosi naadi daba daagimaayaabuu segee simi kiya Waa ekaato iyo. Waa Ogatamee me wigintaata Mée Ebo Kristus mee mikee ki Waa kepa ko Waa ekaato daba daagimaa peesi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Okaa yago bagee yuwa me miya Waa wisinegea. Geebagi see anggur poo uwoo goo-maneeta kaama asiino, ");
INSERT INTO auu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","\"Aa ko mikee Yahudi bagee me Eboo gaayu ko Aa ekaato daba peedee taai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wa dagii da kaa mena ena yaebeamaata kaama pakaa-tabeasegea. Mee menaa da mee ko kisee: \"Mee mée mee ko Yahudi bagee me Eboo mee\" see menaa yaebeamaagea. ");
INSERT INTO auu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yesus ma enaataa piya bokoo to kaa paku wugitaagea bagee wiya kuwa mée ena mee me Yesus wisineekee kaa asiino, \"Aa ko Ogatamee me kawigintaata Mée Ebo Kristus mee, se maa? Aa se boose yoka piya bokoo to kaa kaama daba pooi, bedaa enaa miya daba mée peeyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kiya ena mee me ego-tago see menaa kaa asiino, \"Aa Ogatamee uu ye? Aa miya Waa see see bogaape yoka Ogatamee mee wedaano, daa ye? ");
INSERT INTO auu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Enaa ko pedeo agiyoo ukuwata kuwa me bogaapea kiya mee Mée mee pedeo ukuwaano taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bedaa wa me asiino, \"Yesus, Aa ebo mée eetoono see naadi meetage naagoo anii miya nanekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus me asiino, \"Anii mikee kasiino ko: Eto kenaagoo aa Anii ma epo enaataa Pirdaus magaa kaa toopea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kenoo to mée mumoo to kaa pakaamaagi see kaboo kuwa magaa uduma digiyoo aatakiika, kisee too keno wedo kaa too pakaa-pakaa, ");
INSERT INTO auu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kuwa uduma keno taa. Kuwa kaboo da Ogatamee me ee semoo yiba yaato kenee to kaa wasitaata dokaa da mee usii to kaa kaama pegadoota manii to kaa too wiya wodeenega. ");
INSERT INTO auu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kuwa kaboo da taa ko Yesus me ebo menaa-menaa kaa asiino, \"Neataagi, Ni me dimi noogaa da A me yagaa da kaa kaekeasega\" asigi naaki taka ena dimi noogaa da pe-seomigi. ");
INSERT INTO auu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kuwa ukuwaanega kotoo yuwa Roma kaa okaa yago bagee me eboo deeta kaama Ogatamee yaapaageeki. \"Mee Mée mee ko mikee pedeo ukuwaano taa see Mée to ii\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kuwa ukuwaanega kotoo yuwa diino see naadi me-yigimeeiikea bagee kuwa okoo mée eebaa. Okoo kuwa agiyoo deegeeta kaama peedaa naadi dimi nagimeekee kaa yagaa kopaa okoo ekaato bokoo to kaa dakamepegeekea. ");
INSERT INTO auu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesus ipi see bagee yuwa ma, Waa ma enaataa Galilea wee kaa kaama epo peenaa see apii yuwa ma okoo beesekaa mokoo kaama yiinaageeta kuwa ukuwaanega kotoo yuwa diitookea. ");
INSERT INTO auu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kuwa kaboo da mée ena ekaa da ko Yusup tupi. Waa dimi topoo, Ogatamee me menaa yayeetaa see mée. Waa Yahudi kaa mena pekataa see bagee ena kiya ");
INSERT INTO auu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kuwa Yahudi kaa ebo-ebo apanaa yuwa me Yesus wugimaasi naadi mona daagea kuwa waa be, okoo me mena daata kaama pedeo kotoo Wa kaa yaukuwagea kuwa miya be. Waa Yahudi bagee me magaa ena ekaa da Arimatea magaa kaa mée. Waa Ogatamee Wa too ebo mée eetoowoo taatagi naagoo mee moga migi naaki ou see dimii maamaa gaawoo see mée. ");
INSERT INTO auu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Waa Yesus bootaa da ogo magaano see naadi peedoota Pilatus paagoo pe-idimigi. ");
INSERT INTO auu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kiyoo kaama bootaa da dookomeeta kaama daamaa poodee see doka gipii da kaa bebenataata kaama doodoota mée ogo magaano yoo kiyoo oma ena togaawee ogo maatayu. Mee oma togaawee mee ko mée me denamaata kaama mée ogo magaano taa see oma gipii da. ");
INSERT INTO auu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mee naagoo ko Sabat kaa agiyoo-pagiyoo ipiipii taa see naagoo. Sabat naagoo kaano see kooka. ");
INSERT INTO auu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea wee kaa kaama Yesus ma epo enaataa peenaa seta apii yuwa Yusup obeedoota mée ogoo da deegea, Yesus bootaa da ogo maagea-maagea kuwa miya diitookea. ");
INSERT INTO auu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Okoo peedoota ee kaa peemaata kaama Yesus bootaa da wunu daamaa peesi naadi sigimaano agiyoo ma, wunu daamaa uwoo ma kuwa ipiipii semaata ekeasegea. Sabat naagoo yoka Ogatamee me wegata-wegata see see okoo koogo togea. ");
INSERT INTO auu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mee daa yiba petamanii naagoo esee pedeo komaa, pe-aweeniino taa kaboo da api yuwa me kuwa miyoo taa wunu daamaa peesi naadi agiyoo ipiipii semea yuwa doodoota Yesus ogoo da kaa peemaata kaama ");
INSERT INTO auu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","deamaagi too ko Waa ogoo da kaa takeata oma damaa to mee bikeata amoo maa kaa peanta topa. ");
INSERT INTO auu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Okoo semoo yiba peanta kaama deeyaa naaki Tuhan Yesus bootaa da toono taa. ");
INSERT INTO auu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kisee dimi nagimeamoo taaki too ko taka ena okoo geboo da kaa mée wiya, kusi-kusi peega see dokaa maataa see bagee wiya yiinaageeta topea. ");
INSERT INTO auu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Api yuwa weda kaa maga yaato mumo esee-ekeasegea kiya kuwa mée wiya me asiino, \"Ikii kaasee kaa boota bagee ogo maagee yoo aya totaaki Mée mee abagea? ");
INSERT INTO auu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Waa nakaayoo toono taa, aya andoo peepi. Galilea wee kaa kiitoogee simi kaboo ikii kisimi menaa kuwa ikii gaagaa taai. ");
INSERT INTO auu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kuwa ko kisee: 'Mée Yogaa mee pedeo bagee paagoo yaekegataata kaama piya bokoo to kaa bogaano gaano pedeo. Bogaapi kiya wedaagoo to naagoo aya andoo pootagi' see kisimi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kisee asegea naadi kuwa apii yuwa me Wa me kuwa menaa da mée asimi ii see kuwa nekeenegea. ");
INSERT INTO auu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Esedoota ee kaa okoo me deepea-deepea menaa yuwa uduma Yesus me topenaa see bagee gaasi ma ena kuwa ma, apanaa bagee yuwa ma okoo paagoo eewegagea. ");
INSERT INTO auu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kuwa apii ekaa yuwa ko Maria Magdalena ma, Yohana ma, Yakobus baayo Maria ma, apanaa epo enaataa peenaa see apii yuwa miya. Okoo me kuwa Yesus me menaa yadoonaa see bagee yuwa pe-eewegagea naaki ");
INSERT INTO auu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","okoo aii menaa keenda naadi mikee menaa yoka see se gaagea. ");
INSERT INTO auu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kiya Petrus mee yiinaageeta kaama yiibaga peedoota mée ogopa peemaata kaama peenaa kagu esee-ituunta mokoo kaama ogo wogaa-wogaa see deamaagi naaki Wa kaa yabebenamaata dokaa yuwa too topa. Peedoota ee kaa 'Kuwa kaasee kotoo ukuwaanega naa ya?' see dimii gaapegeeki. ");
INSERT INTO auu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mee naagoo Yesus sekaataa peenaa seta bagee ekea mée wiya maga ena ekaa da ko Emaus magaa kaa peetaakea. Yerusalem magaa kaa kaama Emaus magaa kaa poo-poo kilometer gaasi ma ena. ");
INSERT INTO auu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kuwa ukuwaandaa sepa menaa yuwa aawegaa sepegeekea. ");
INSERT INTO auu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kuwa menaa aawega-maawega sepegeekea naaki Yesus mee ekea geboo da kaa keta kaama okoo paaya enaataa peetaa. ");
INSERT INTO auu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yesus mee deegea kiya mee ko Yesus yoka see kuwa ekea nekeeniyaano taa. ");
INSERT INTO auu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Wa me asiino, \"Ekea mapea menaa aawegaa sepegeekea naa ya?\" see asigi. Ekea tuguunegea, dimi boodi kegea. ");
INSERT INTO auu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ekea wiya ena ekaa da ko Kleopas me asiino, \"Ei, eto miyoo ukuwadaa sema agiyoo kuwa Yerusalem magaa kaa mepea bagee kuwa uduma A too ewo ye?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","\"Mapea menaa naa ya?\" see asigi. Ekea me asiino, \"Nazaret magaa kaa Mée Yesus mee kaa kaama ukuwaanega menaa kuwa. Waa ko nabi bagee eboo, Ogatamee emaa dagii da kaa miya, inii mée uduma me miya kisee deege. Wa me ukuwaaniyaabuu segee simi agiyoo kuwa miya pesee, Wa me weganaa segee simi menaa kuwa miya omaago. ");
INSERT INTO auu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Imam ebo yuwa ma, inii me ebo-ebo apanaa yuwa ma okoo me Waa wugimaasi naadi ekegataamea. Ekegataata kaama piya bokoo to kaa booyaamea. ");
INSERT INTO auu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Inii Israel bagee yuwa daba mée daagimaa peeyaabuu taapi Mée mee Wa me too ii see kuwa inii gaagee sepe kiya Waa wugimaata kaama wedaagoo to naagoo kega. ");
INSERT INTO auu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bedaa yumakaa inii ma enaataa apii okoo wedo waa naa me inii dimi mée ooyaakee menaa mée asegea. Okoo pedeo komaa mée ogo maata yoo peepea ");
INSERT INTO auu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kiya bootaa da diino taa. Okoo meedoota inii paagoo mée asiino, 'Malaikat bagee yuwa inii paagoo awee da kaa keta kaama \"Yesus mee aya andoo peepi yoka\" see mée asegea' see menaa kuwa niiwegapea. ");
INSERT INTO auu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kiyoo kaama inii ma enaataa bagee yuwa noonaa mée ogopa diino see naadi peegea. Peemaata kaama api yuwa me wegapea see see okoo me miya deegea kiya Yesus mee okoo diino taa\" see kuwa ekea me asegea menaa yuwa. ");
INSERT INTO auu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesus me asiino, \"Yaai, ekea kaasee dimi ewo see bagee wiya. Idukaa nabi bagee me wegawoo seta menaa kuwa ekea mikee gaano epee yaai. ");
INSERT INTO auu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kuwa menaa yiba Ebo Kristus mee boodi ma boomaata kaama Waa asii-sege ebo too toowoo see yoo pakaamagaano gaano pedeo keekee, see menaa ebeamaata, se maa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kiyoo kaama Ogatamee me menaa yiba idukaa kaama Wa kaa wegawoo seta menaa kuwa ekea paagoo daamaa ipiipi eewegagi. Petamanii Musa me menaa mee kaa kaama masegeeta nabi bagee me menaa yuwa kaa too kuwa uduma Waa ekaato kaa ebeamaata menaa yuwa nekeeniino yaato daamaa ase-manee sepegeeki. ");
INSERT INTO auu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ekea peetaakea magaa geboo da kaa peemaata kaama Yesus etaawee yamoo-sege taano see kooki. ");
INSERT INTO auu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kiya ekea me \"Ei, Aa enaa ma enaataa mée eetooi, keno seomigi ke, digiyoo takiiniinaka yoka\" kisee maamaa asegea. Waa ma okoo paaya enaataa ee yiba seemetaa. ");
INSERT INTO auu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Okoo enaataa naano see naadi animaata kaama Waa roti masegeeyu, Ogatamee paagoo kiiboo, paamee see menaa aseta kaama roti kabatagaa naadi ekea paagoo yawuditaayaa naaki ");
INSERT INTO auu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ekea taka ena kisee ki Waa nekeeniino see dimii medaaka. 'Mikee, Yesus ii' see dimii nekeenegea. Kuwa kaboo da taa ko taka ena Waa peanigi taa ewo. ");
INSERT INTO auu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ekea me \"Sooi, yumakaa etaa da kaa kaama Wa me Ogatamee me menaa yuwa nekeeniino yaato daamaa mée ase-manee sepegee sipi kaboo enaa dimi mena esee ede ma, ede ma kedaa sepegee sepea, se maa?\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ekea kisee ki anoogeeta Yerusalem magaa kaa metaki pakagea. Pakaamaagea ko Wa me topenaa see bagee gaasi ma ena kuwa ma, apanaa mée noonaa ma okoo enaataa topea. ");
INSERT INTO auu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Okoo me asiino, \"Tuhan mee mikee aya andoo peepi ii, Simon paagoo Waa ekaato awee da kaa deeyaagi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kiyoo kaama kuwa mée wiya ekea me eta mana kaa kaama ukuwapea-ukuwapea menaa yuwa eewegagea, bedaa ee kaa kaama Yesus me roti mée eekabatagaaki naaki mikee Aa Yesus ii see dimii nekeenege see menaa kuwa miya eewegagea. ");
INSERT INTO auu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kuwa menaa yuwa eewegataakea naaki taka ena Yesus mee okoo paagoo awee da kaa keta kaama \"Epao, ikii Ogatamee ma emee-emee kisiyaayaa bagee yuwa\" see asigi ");
INSERT INTO auu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","kiya okoo dimi oodaakea. Senee to nao naadi okoo weda ebo kegea. ");
INSERT INTO auu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wa me okoo asiino, \"Ikii kaasee kaa weda kegea? Kaasee kaa dimi wiya kegea? ");
INSERT INTO auu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ni me yagaa bado kuwa nadeeweei. Anii yoka, nayaadee siweei. Sene gaayu ko Anii see see se, baboo mogee taa see agiyoo yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kuwa menaa da aseta kaama Wa me yagaa bado yuwa deeyaayu. ");
INSERT INTO auu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Okoo esee ede kaa dimi nagimegao naadi 'Mee mikee Yesus ye, taa ye?' kisee dimii gaataakea kaboo Yesus me asiino, \"Ikii nakaayoo naano agiyoo naa agoo ye?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","peeta dogee ponee ena goo-maneegea. ");
INSERT INTO auu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wa me masegeeta okoo paagoo kaama nugi see deegea. ");
INSERT INTO auu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wa me okoo asiino, \"Anii ikii ma epo enaataa kiitoogee sema kaboo Ni me kisi-manee sema menaa kuwa ko kisee: Idukaa Musa me ebeamaata menaa ma, nabi bagee me ebeamaata mena ma, Mazmur kaa menaa ma kuwa menaa kuwa yiba Ni kaa wegawoo seta menaa yuwa uduma Ni kaa uwa daano gaano pedeo see kisi-manee sema\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kiyoo kaama okoo kuwa Ogatamee me menaa nekeensi naadi Yesus me ipi see dimii yamiyaabuu semaata ");
INSERT INTO auu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","aseta menaa ko \"Ogatamee me idukaa ebeamaata menaa da kisee: Ebo Kristus mee Waa boodi ma boomaata kaama wedaagoo to naagoo aya andoo pootagi see menaa da ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bedaa Wa ekaa yiba 'Ikii me pedeo yuwa epa kiekeasiipi yoka uduma ekeasii' see menaa kuwa Yerusalem magaa kaa kaama masegeeta mée tomaa-tomaa yuwa uduma paagoo yawegakumiino gaano pedeo, see menaa kuwa miya ebeamaata. ");
INSERT INTO auu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ikii ko Ni me ukuwata-ukuwata kuwa uduma nadeewoo seta kaama naweganaa siwoo taano bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yeede, Neataagi me Waa ikii paagoo kiniita see kiseta Mée mee Anii kimiyaata kiya Wa me pesee da ikii kaa kidootagaano taa kaboo kuwa ikii mee magaa kaa kiyoo too toogee taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kiyoo kaama Yesus me okoo badaa maadoota Betania magaa geboo da kaa eepeemaata kaama Waa yagaa yagaataata kaama okoo kaa daamaa pesee kisi naadi menaa yaasigi. ");
INSERT INTO auu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kuwa menaa wegataaki too ko Waa badaa maageeta kaama epoo to wodoo pakaa-seomigi. ");
INSERT INTO auu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Okoo kagu maga kaa sibumedaa seta Waa yaapaagee, ebo ekee naadi kaama metaki esedoota Yerusalem magaa kaa esee ede ma, ede ma eseemaata kaama ");
INSERT INTO auu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ogatamee me ee kaa kaama Ogatamee yaapaagee segee siwoo seta. Kiyoo too.");
INSERT INTO auu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Esee petamanii ko Menaa Da see ekaa munta Mée mee tota. Menaa Da see ekaa munta Mée mee Ogatamee ma epo enaataa tota. Menaa Da mee miya Ogatamee. ");
INSERT INTO auu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Esee petamanii agiyoo-pagiyoo uduma taa kaboo Waa Ogatamee ma epo enaataa tota. ");
INSERT INTO auu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ogatamee me se-agiyoo, we-agiyoo uduma ogaataata kuwa Menaa Da doodoo ogaataata. Wa me ogaatagaano taa agiyoo ena ma taa. ");
INSERT INTO auu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mée tomaa daamaa tuyaabuu siwoo siyaa kuwa manii to ko Wa kaa too. Wa me mée tomaa daamaa tuyaabuu siwoo siyaa menaa kuwa mée paagoo ago yawogaamaayaa mokoo. ");
INSERT INTO auu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Agoo Da mee digiyoo yiba daamaa yawogaamaayaabuu siwoo siyaa, digiyoo mee me peedi se ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mée ena, Ogatamee me mée yuwa paagoo pooi see aseta mée mee meta, wa ekaa da ko Yohanes. ");
INSERT INTO auu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Waa meta mee ko Agoo Da Wa me menaa yaweganaa taano see naadi, bedaa kuwa menaa mée uduma mikee nao see gaasi naadi meta. ");
INSERT INTO auu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanes waa Agoo Da mee se, Agoo Da kaa menaa kuwa too yaweganaa taano see naadi meta. ");
INSERT INTO auu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kuwa menaa yaweganaa seta kaboo da mikee okaa da ebo Agoo Da mee, Waa mée tomaa uduma awee da kaa yawogaamaasi naadi Agoo Da mee, Waa mée paagoo meeno see koo taaki. ");
INSERT INTO auu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Waa magaa da kaa omegee, toogee seta, bedaa uwoo to, magaa to uduma Wa me ogaataata kiya magaa da kaa bagee yuwa me Waa ewo, nekeeniino taa. ");
INSERT INTO auu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wa me magaa kaa Waa ma tomaa kaa bagee paagoo meta kiya Waa be kaa badaa magaano taa. ");
INSERT INTO auu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Okoo kisee koo seta kiya kuwa Waa daamaa badaa maata bagee yuwa, okoo Wa ekaa da ebo, Waa mikee gaata bagee kuwa uduma Ogatamee me daamaa yoka naadi Wa me yogaa kiyaata. ");
INSERT INTO auu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Okoo Wa me yogaa kiyaata kuwa ko mée me yoga agoo kiyaayaa mokoo se, mée me yoga agoo kaano ede gaayaa dimii mee kaa miya se, bedaa paimee me yoga agoo kaanaka gaayaa dimii doodoo kaama miya se kiya Ogatamee Wa me edee, Wa me gaayaa-gaayaa doodoo kaama Wa me yogaa kiyaata. ");
INSERT INTO auu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Menaa Da see ekaa munta Mée mee ko Waa mée ena keta. Mée ena keta kaama inii mée paagoo epo enaataa mée eeomegee, toogee seta. Waa ebo, Waa asii-sege see kuwa inii deemea. Kuwa asii-sege siyaa agiyoo kuwa Nagamee me Wa me ena too too Yogaa kaa manta. Wa me mée epa dimii mee ebo, Wa too esee mikee dimi yago Mée ii see kuwa inii mée deeyaami. ");
INSERT INTO auu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mée me Waa ipi kisi naadi menaa kuwa Yohanes me yaweganaa simi. Wa me ebo menaa-menaa kaa \"Wae, ni me miyoo taa kisema menaa ko 'Waa uuto meepi Mée mee ko esee ebo. Waa anii taa kaa miya tota yoka anii peedi' see kisema. Eto ko mee Mée mee ki see kuwa anii bedaa kiiwegaga\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ogatamee Wa me mée epa dimii mee ebo kemaata inii kaa esee daamaa mée manegee siyaa agiyoo kuwa inii uduma daamaa maseeii siwoo see. ");
INSERT INTO auu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Diiyoo deewoo seta menaa kuwa Ogatamee me Musa doodoo mée manta kiya Wa me inii mée esee epa dimii mee gaayu ko Yesus Kristus mee doodoo mée yamiyaabuu simi, Wa too esee mikee dimi yago Mée ii see kuwa inii mée deeyaami. ");
INSERT INTO auu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ogatamee Waa deetaa see mée ena ma taa kiya Wa me ena too too Yogaa Wa me inii Ogatamee mée ipi kiyaabuu seta. Waa miya Ogatamee, Waa Nagamee ma epo enaataa totaa see Mée mee. ");
INSERT INTO auu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kuwa kaboo da taa ko Yerusalem magaa kaa kiyoo Yahudi kaa ebo-ebo yuwa me Yohanes mee kaasee mée to, kaasee mée to naadi kaama pe-apaadee taano bagee yuwa \"Pe-niiyeegii\" see asegea. Okoo noonaa imam bagee, noonaa Lewi apaa kaa bagee. Okoo Wa paagoo peemaata kaama asiino, \"Aa maamee naa ya?\" asegea. ");
INSERT INTO auu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Waa booneano menaa ena ma taa, wa me awee da kaa asiino, \"Anii Ogatamee me wigintaata wegawoo seta Mée, Ebo Kristus mee se\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Okoo me asiino, \"Aa Ebo Kristus mee se gaayu ko aa maamee naa ya? Aa nabi Elia mee ye?\" asegea naaki \"Taa\" asigi. Bedaa okoo me asiino, \"Idukaa kaama Nabi eboo ena inii paagoo miyaatagi see wegawoo seta Mée mee naa aa ye?\" asegea naaki \"Taa\" asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Okoo me asiino, \"Taa gaayu ko aa maamee naa ya? Kuwa a paagoo inii pe-niideegii see mée asegea bagee yuwa inii bedaa okoo paagoo mena daamaa pe-asiino see yoka a me too 'Anii kisee mée to, kisee mée to' see kuwa mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wa me asiino, \"Idukaa nabi Yesaya me wegata menaa ena mee ko kisee: Mée waa ena me ebo menaa-menaa kaa 'TUHAN me meeno see etaa daamaa topoo yatupitagaai' see menaa mee piya taa, one taa see ebo mee maga ugii da kaa wegaatagi, see menaa wegawoo seta. Mee mée mee ko anii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kuwa wa paagoo mena pe-yeegiino see naadi mepea bagee kuwa noonaa Parisi kaa bagee. ");
INSERT INTO auu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Okoo me asiino, \"Aa ko Ebo Kristus mee miya taa, aa nabi Elia mee miya taa, aa idukaa kaama Nabi eboo ena meetagi see wegawoo seta Mée mee miya taa gaayu ko aa kaasee kaa mée uwo yatukumetaake naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wa me asiino, \"Ani me uwo yiba mée yatukumetaaka kiya Mée Waa ena, ikii me ewo see Mée mee ikii paagoo kiitotaaki. ");
INSERT INTO auu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ani keta ikii paagoo mepa kiya anii peedi. Waa uuto meepi Mée mee ko esee ebo. Wa me badoo doko onee peedii to mee miya ni me yaekagaano iyo, anii sikii taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kuwa menaa aawegaakea kuwa ko Yordan uwoo asii yaato Betania magaa kaa wa me mée uwo yatukumetaa see yoo kaama asegea menaa. ");
INSERT INTO auu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tokoma mee da Yohanes me Yesus mee wa paagoo migi see deeta kaama asiino, \"Ikii deeweei. Mee ko Ogatamee me Domba Pooduu To, magaa da kaa bagee me pedeo yuwa yawonakomeeta kaama Ogatamee ma menaa yataa kiyaano Mée mee. ");
INSERT INTO auu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Waa ko ani me miyoo taa kisema Mée mee. Kuwa ko 'Waa uuto meepi Mée mee esee ebo. Waa ko anii taa kaa tota yoka anii peedi' see kuwa kisema. ");
INSERT INTO auu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Waa kisee Mée see kuwa idukaa anii miya ewo kiya eto ko Israel bagee yuwa miya Waa daamaa ipi kiyaabuu taano see naadi anii meemaata kaama mée uwo yatukumetaaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Bedaa Yohanes me deeta-deeta yuwa eewegaano menaa mee ko kisee: \"Anii deataayaa naaki poodee see bedoo eseaniyaa mokoo see see Roh mee epoo to wodoo kaama Wa kaa eseanigi. Eseanta kaama kisee toomuu taaki see kuwa deema. ");
INSERT INTO auu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Idukaa anii miya Waa ewo, nekeeniino taa kiya mée uwo natukumese yoka pooi see naseta Mée Wa me nasimi menaa mee ko kisee: 'Roh Waa Mée ena kaa eseanta kaama Wa kaa toomuu taapi, see kuwa a me diipe. Mee Mée mee ko Roh Kudus yiba mée yatukumaapi Mée mee' see nasimi. ");
INSERT INTO auu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Anii kuwa mikee kisee deema yoka mee Mée mee Waa mikee Ogatamee Yoopaa yoka see menaa kuwa anii yaweganaaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tokoma mee da Yohanes mee wa me topetaa see bagee ekea wiya ma kiyoo yiinaageeta toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wa me Yesus kitaa peegi see deeta kaama asiino, \"Deeweedeei. Mee ko Ogatamee me Domba Pooduu To\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wa me topetaa see bagee wiya ekea me kuwa menaa yeeta kaama Yesus obeegea. ");
INSERT INTO auu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus Waa ikigi pe-maataata kaama deamaayaa naaki ekea mée wiya Wa sekaataa obeewookea. Wa me asiino, \"Ekea maagiyoo abawookea?\" asigi naaki \"Rabi, wae\" asegea. (Rabi see wegayu ko mena mée topetaa see mée to mee.) Ekea me \"Aa kayoo omegeeke?\" asegea naaki ");
INSERT INTO auu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","\"Ekea me diipea yoka meei\" see asigi. Epo peedoota kaama uwaataa da Wa me ometaa see yoo peemaata kaama kiyoo epo enaataa toomuu naadi digiyoo takiinega. ");
INSERT INTO auu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kuwa Yohanes me menaa yeeta kaama Yesus obeewookea bagee wiya kuwa mée ena ekaa da ko Andreas, Simon Petrus ebee. ");
INSERT INTO auu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andreas mee kisee ki peedoota yagamee Simon deemaata kaama asiino, \"Ebo Mesias see Mée mee deemaage nao\" see asigi. (Ebo Mesias see ekaa mee wegayu ko Ibrani menaa kaa Ebo Kristus see ekaa mee.) ");
INSERT INTO auu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wa me yagamee badaa maadoota Yesus paagoo eepeegi. Yesus me waa deeta kaama asiino, \"Aa ko Simon, Yohanes yoopaa mee kiya Kepas see ekaa kamuntaaga yoka eto kaama wodoo mee ekaa da kaweewoo taapea\" see asigi. (Kepas see ekaa mee wegayu ko Petrus see ekaa mee.) ");
INSERT INTO auu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tokoma mee da Yesus Waa Galilea wee kaa poonaka see gaagi. Kiyoo peemaata kaama Pilipus see mée to mee deemaata kaama \"Ni sekaataa nameei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipus waa Betsaida magaa kaa mée, Andreas ma, Petrus ma okoo paaya enaataa totaa see magaa. ");
INSERT INTO auu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kiyoo kaama Pilipus me Natanael see mée to mee pe-deemaata kaama asiino, \"Idukaa kaama wegawoo seta Mée mee, Musa me menaa yiba miya, nabi bagee me menaa yiba miya kisee wegawoo seta Mée mee ma inii aadee sepe. Waa ko Yesus mee, Yusup Yoopaa, Nazaret magaa kaa Mée mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael me asiino, \"Nazaret magaa kaa bagee kuwa daamaa bagee ena ma agoo ye?\" asigi naaki Pilipus me \"Me-dii\" asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ekea epo peedoota kaama Yesus paagoo peemaagea kaboo Yesus me Natanael migi see deeta kaama Natanael paagoo asiino, \"Deeweei. Mee ko esee mikee Israel kaa mée to. Wa yiba mée deebaa see dimii peenaa ma taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael me asiino, \"Aa kaasee kaa naipi kege?\" asigi naaki Wa me asiino, \"Pilipus waa a paagoo badaa kamaagiino taa kaboo aa ara piyaa manii da kaa toomuu taake see kuwa kadeepa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael me asiino, \"Ei, Guru. Aa ko Ogatamee Yoopaa, Aa ko Israel bagee me Eboo mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus me asiino, \"Ni me aa ara piyaa manii da kaa toomuu taake kuwa kadeepa see kasega menaa da mee kaa too a me 'Aa mikee kisee Mée to yoka' see nagaage ye? Aa Ni me kisee kadeepa see kasega menaa da kuwa kaa dimi nagimege kuwa peedi, esee ebo see agiyoo yuwa a me deewoo taape\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Bedaa Wa me asiino, \"Anii esee mikee kisiino ko: Epoo to kabaanta kaama Ogatamee me malaikat bagee yuwa Mée Yogaa mee paagoo esetaa, pakataa segeekea see kuwa miya ikii diipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Unu wiya omemaata kaama wedaagoo to naagoo Galilea wee kaa Kana magaa kaa kiyoo mée waa ena me api goeano naagoo. Naano agiyoo noogee yoo kiyoo Yesus baayo miya topa, ");
INSERT INTO auu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus ma, Wa me topenaa see bagee yuwa ma okoo paagoo \"Naano ke meei\" asegea naadi okoo miya enaataa eenotaa. ");
INSERT INTO auu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Noogee naadi kaama anggur poo uwoo imi taa. Imi taa naadi okooto me Waa asiino, \"Okoo anggur poo uwoo kuwa taa keepeasega yoka\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus me asiino, \"Ei, nibaayo, kaasee kaa nasege? Anii nanekeensi naadi agiyoo ukuwanaa see monaa kaa kaano taa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Okooto me kiyoo agiyoo yaokagee see bagee yuwa asiino, \"Wa me kisiipi-kisiipi kuwa daamaa pee-yaukuwaai\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Amokiyoo ebo otaawee bedimi agoo, Yahudi bagee me tuunuu sepea yuwa wetogekumiino uwoo wugiino see naadi oma otaawee yuwa. Otaawee noonaa uwo delapan puluh liter wugiyaa, noonaa seratus dua puluh liter wugiyaa see otaawee yuwa. ");
INSERT INTO auu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus me kuwa agiyoo yaokagee see bagee yuwa asiino, \"Kuwa otaawee yuwa uwo pudiisi yoka kabageawee taai\" see asigi. Uwo kabageawee naadi ebeatoo da kaa kega kaboo ");
INSERT INTO auu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wa me asiino, \"Eto ko simu ena wugidoota pesta tuku see mée paagoo yadoo-pooi\" see asigi naadi kisee yadoogea. ");
INSERT INTO auu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kuwa uwoo yuwa anggur poo uwoo keepeasega naadi kaama pesta tuku see mée to peenaa noodeegi naaki esee gii daamaa. Kuwa uwoo wogepea yoo waa ewo, kuwa yawogedoo peepea bagee yuwa okoo too ipi. Wa me kisee ewo kaa mee api goeano mée to mena ogegeeta kaama asiino, ");
INSERT INTO auu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","\"Ei, anggur poo uwoo gaayu ko gii daamaa see yuwa kuwa keta mée me nusi naadi mée paagoo maniyaa. Kuwa uwo daamaa kiyaa yuwa noogee naadi kaama gii peenaa too kiyaa yuwa mée maniyaa, se maa. Kiya aa gaayu ko kisee taa. Eto wodopasi yaato too a me kuwa daamaa kiyaa yuwa mée manege\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kuwa aii uwoo kuwa anggur poo uwoo gakadiyaata mee ko Yesus Waa kisee Mée to ii see kuwa nekeensi naadi dimi nagii-nagii see agiyoo petamanii mee, Galilea wee kaa Kana magaa kaa kiyoo ukuwaaniyaagi. Waa ebo, Waa asii-sege see kuwa kisee daamaa awee da kaa deeyaata kaama Wa me topenaa see bagee yuwa Waa mikee nao see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kiyoo kaama Yesus ma, Wabaayo ma, Waa ma kenaa bagee yuwa ma, Wa me topenaa see bagee yuwa ma kuwa uduma epo enaataa esedoota Kapernaum magaa kaa eseemaata kaama kiyoo unu wiya waa naa ometa. ");
INSERT INTO auu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yahudi bagee me ebo naagoo Paskah naano mee ekaapa kega naadi Yesus Waa pakadoota Yerusalem magaa kaa ");
INSERT INTO auu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","kiyoo Ogatamee me ee kaa pakaamaata kaama deamaagi too ko kepe masetaa see bagee yuwa topea. Sapi wodaa ma, domba wodaa ma, poodee see bedoo ma kuwa pe-doogee taa see bagee miya agoo, kepe aapeka taa see bagee miya kiyoo animaata toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Okoo kiyoo totaakea naadi Yesus me one poo yuwa masegeeyu, uduma enaataa bebenataata kaama kiyoo topea bagee yuwa ma, okoo me domba wodaa yuwa ma, sapi wodaa yuwa ma okoo uduma Ogatamee me ee kaa kaama yoo da kaa abagakomeeyu. Kuwa kepe aapeka taa see bagee okoo me kepee yuwa aii magaa da kaa eseaniyaabuu naadi kaama okoo me keagee yuwa yagepeepi-paapi semaata eke. ");
INSERT INTO auu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wa me kuwa poodee see bedoo doogee taa see bagee yuwa asiino, \"Kuwa nakaayoo se, uduma dogaai. Neataagi me ee mee agiyoo maataa, edaataa see ee si yakiyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kisee asigi kemaata Wa me topenaa see bagee yuwa me idukaa ebeamaata menaa ena nekeenegea, mee ko kisee: \"Ogatamee, A me ee mee anii esee ou, biyaa napooniyaayaa mokoo\" see ebeamaata menaa mee. ");
INSERT INTO auu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yahudi kaa ebo-ebo yuwa me Yesus kagoo kaa asiino, \"Kuwa A me kisee abagaapeasege kuwa Ogatamee me Aa naukuwaai see kasigi gaayu ko inii me kisee ii see kagaano see yoka A me dimi nagii-nagii agiyoo maagiyoo inii mée deeyaape naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesus me asiino, \"Ni me ikii kideeyaapa agiyoo mee ko ikii me Ogatamee me ee mee umiyaaweei. Umiyaata kaama unu wedo kaa too Ani me bedaa daamaa maatagaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Okoo me asiino, \"Sooi, Ogatamee me ee mee ko tahun mée wiya ma bidimi maagee seta ee kiya A me too unu wedo kaa too daamaa maatagaapa see wegage ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kiya Yesus me mikee maa ee mee naadi kaama wegagi menaa mee se kiya Ogatamee me ee mee Wa me maa to ebea-ebea naadi asigi menaa. ");
INSERT INTO auu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesus Waa boota kaama aya andoo peeta kaama wodoo Wa me topenaa see bagee yuwa Wa me aseta menaa da mee daamaa nekeenegea. \"Mikee, Wa me kisee wegami ii\" see nekeenta kaama kuwa Ogatamee me ebeamaata menaa da ma, Yesus me wegata menaa da ma kuwa mikee nao see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesus Waa Paskah Naagoo naano see naadi Yerusalem magaa kaa omegeeka too Waa kisee Mée ii see nekeensi naadi dimi nagii-nagii agiyoo kuwa okoo mée eebaa deegea. Okoo kuwa agiyoo deeta kaama Waa ebo ekaa yago Mée nao naadi mikee gaagea. ");
INSERT INTO auu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Okoo me kisee gaagea kiya mée uduma okoo me dimii kuwa Waa ipi kemaata kaama Waa ekaato okoo paagoo dimi yaekegatagaano be. ");
INSERT INTO auu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mée me iyee-payee kuwa uduma Waa ipi yoka mée me dimi yiba gaayaa yuwa kuwa Waa ipi kisi naadi ase-manee siyaa bagee ena ma taa. ");
INSERT INTO auu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisi kaa mée ena ekaa da ko Nikodemus mee, Yahudi bagee tuku see mée ena, ");
INSERT INTO auu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","waa daatooyiba yaato peedoota Yesus paagoo peemaata kaama asiino, \"Guru, Aa inii mena mée topegeesi naadi Ogatamee me kapeeyaagi ii see kuwa inii ipi. Ogatamee Waa Aa ma epo enaataa kaatoono taa naaki A me dimi nagii-nagii see agiyoo ukuwanaa segeeke kuwa iyo, mée me se ukuwamaayaa agiyoo yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus me asiino, \"Anii esee mikee kasiino ko: Okoo wiyaagoo to ma kabaano taa bagee kuwa Wa too ebo mée eetotaa see yoo kiyoo se deemaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus me asiino, \"Kiya mée ebo kiyaa wodoo kaasee kabamaayaa ya? Wabaayo togaawee pakaa-seometa kaama bedaa wiyaagoo to ma kabamaayaa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus me asiino, \"Anii esee mikee kasiino ko: Okoo uwo kaa ma, Roh kaa ma kabaano taa bagee kuwa Wa too ebo mée eetotaa see yoo kiyoo se seemiyaayaa. ");
INSERT INTO auu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mée me kabayaa-kabayaa mee ena, Roh me kabayaa-kabayaa mee ena. Kabaano ena mee ko má yaato, ena mee dimi mena yaato. ");
INSERT INTO auu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ani me 'Ikii wiyaagoo to ma kabaano gaano pedeo' see kasega menaa kuwa dimi se nagimaai. ");
INSERT INTO auu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Roh me kabayaa mee ko bo pupu mokoo. Bo pupu wa me gaayaa-gaayaa taa too peenaa siyaa. Tukuu da aa yeetaa see kiya kiyoo kaama mega, kiyoo kaama peega see kuwa aa ewo. Mee mokoo miya Roh me mée wiyaagoo to ma kabayaa-kabayaa mee kisee kemaata kasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus me asiino, \"Kuwa agiyoo kuwa kaasee ukuwaaniyaa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus me asiino, \"Aa Israel bagee mena mée topetaa see mée kiya kuwa agiyoo yuwa aa ewo ye? ");
INSERT INTO auu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Anii esee mikee kasiino ko: Inii me ipi see menaa yuwa miya mée eeweganaake, inii me deepe-deepe yuwa miya mée eewegageeke kiya inii me menaa kuwa ikii yaato bagee me se masegea. ");
INSERT INTO auu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Anii kuwa magaa da kaa ebea-ebea menaa kisega kuwa ikii me kuwa mikee menaa yoka see dimii mee taa kiyu ko Anii epoo to yaato menaa kiiwegayaa miya ikii me kuwa menaa kuwa mikee menaa yoka see se nagaapea. ");
INSERT INTO auu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Asiyoo epoo to wodoo pakageeta bagee ena ma taa. Epoo to wodoo kaama magaa da kaa eseta Mée mee ena too too, mee ko Mée Yogaa mee. ");
INSERT INTO auu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Idukaa Musa mee ebo mee maga ugii da kaa otoogiyoo ebea-ebea da yagaataata mokoo see see Mée Yogaa mee miya mée me yagaataano gaano pedeo. ");
INSERT INTO auu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kisee yagaataata kaama Waa mikee gaayaa bagee kuwa uduma iminoo miya, iminoo miya kisee too toogee taatagea. ");
INSERT INTO auu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ogatamee me magaa da kaa bagee yuwa esee epa kemaata Wa me ena too too Yogaa mée manta. Waa mikee gaayaa bagee yuwa uduma se pedeo keta iminoo miya, iminoo miya kisee too toowoo segeesi naadi mée manta. ");
INSERT INTO auu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ogatamee Wa me Yogaa magaa da kaa bagee paagoo isiyaata mee ko mée tomaa pedeo kiyaabuu taano see naadi se kiya Wa me Yogaa me mée tomaa daba daagimaa peeyaabuusi naadi isiyaata. ");
INSERT INTO auu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Waa mikee gaayaa bagee kuwa Ogatamee me pedeo kiyaano see naadi wigintaata se. Yogamee mikee gaano taa bagee kuwa too Ogatamee me wigintagaa seta bagee yuwa. Okoo Ogatamee me ena too too Yogaa Wa ekaa da ebo, Waa mikee nao see gaano taa bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mée tomaa wigintagaa siyaa kuwa ko kisee: Agoo Da mee magaa da kaa eseta kiya mée tomaa kuwa okoo me ukuwagee seta agiyoo kuwa pedeo too naadi kaama okoo digiyoo yiba too toono ede, okoo awee yaato be. ");
INSERT INTO auu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pedeo agiyoo ukuwagee see bagee kuwa uduma awee kuwa be, okoo me pedeo ukuwagee see agiyoo awee da kaa nadiipea naadi awee yaato Agoo da paagoo se miyaa. ");
INSERT INTO auu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kiya mikee daamaa see agiyoo ukuwagee see bagee kuwa gaayu ko okoo awee yaato miyaa. Okoo me daamaa ukuwagee see agiyoo kuwa mikee, Ogatamee me too daamaa yaagoo kiyaabuu taaki agiyoo yuwa ii see kuwa awee da kaa daamaa nekeensi naadi okoo Agoo da paagoo medaa siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mee kaama wodoo Yesus ma, Wa me topenaa see bagee yuwa ma epo peedoota Yudea wee kaa peemaata kaama kiyoo bagee ma enaataa eeometaa, uwo mée yatukumetaa. ");
INSERT INTO auu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kuwa kaboo da Yohanes mee Ainon magaa kaa, Salim gebo kaa magaa kaa kiyoo tupi. Kiyoo uwo eebaa agoo naadi mée yuwa Yohanes paagoo medaakea, wa me okoo uwo yatukumegeeki. ");
INSERT INTO auu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yohanes mee digiyoo ee yiba dogeamaano taa kaboo kuwa kisee ukuwageeki. ");
INSERT INTO auu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kuwa kaboo da taa ko Yohanes me topetaa see bagee yuwa ma, apanaa Yahudi bagee ena ma mena aawegaa taakea. Kuwa ko Yahudi bagee yuwa me tuunuu siyaa yuwa kisee uwo yawetogekomee see daamaa, kisee uwo yawetogekomee see pedeo, see menaa kaa aawisi-maawisikea. ");
INSERT INTO auu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mena aawegaa semaata kaama peedoota Yohanes paagoo asiino, \"Guru, wae. Idukaa Yordan uwo asii yaato kiyoo a paagoo kaatoomuu taa simi Mée, a me mée paagoo ipi yakiyaage Mée mee eto Waa miya mée uwo yatukumetaaki kemaata mée uduma Wa paagoo too peedaakea\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanes me asiino, \"Inii me masiyaa agiyoo kuwa epoo to wodoo kaama Ogatamee Wa me inii kaa mée yadootaagi gaayu too masiyaa. ");
INSERT INTO auu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ni me kisema menaa kuwa ko kisee: 'Anii ko Ogatamee me wigintaata kaama wegawoo seta Mée Ebo Kristus mee se kiya Ogatamee me ani keta napeeyaami mée to mee too' see kisema menaa kuwa ikii naipi. ");
INSERT INTO auu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ebea-ebea menaa ena mee ko kisee: Api goeano mée to gaayu ko apii to wa paagoo peeyaa, wa me apii kiyaa. Mee mée mee waa ma epo peenaa see mée to gaayu ko api goeano mée to me menaa daamaa yayiitoo taano see naadi wa paagoo eetotaa siyaa. Api goeano mée to me menaa kuwa waa esee ede ma, ede ma yayiitoo siyaa. Mee mokoo miya ni me ede dimii mee esee ebo. ");
INSERT INTO auu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wa too ebo kiwoo, anii peedi kiwoo, kisee too siwoo taano gaano pedeo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Asiyoo kaama magaa da kaa eseta Mée Waa Ebo Wodoo Eboo. Magaa da kaa bagee kuwa ko maga yaato kaama bagee kemaata magaa da kaa menaa too aawegaa siyaa. Epoo to wodoo kaama eseta Mée Waa Ebo Wodoo Eboo. ");
INSERT INTO auu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wa me deeta-deeta, yeeta-yeeta kuwa eewegayaa kiya daamaa peneasiino bagee taa. ");
INSERT INTO auu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wa me menaa daamaa masemaayu see bagee kuwa ko okoo me \"Ogatamee mee mikee menaa epoo Mée yoka\" see wegayaa. ");
INSERT INTO auu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ogatamee Wa me isiyaata Mée mee Wa kaa Roh mee maamaa manta kemaata Wa me wegataa see menaa kuwa uduma Ogatamee me menaa too. ");
INSERT INTO auu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nagamee me Yogamee esee epa, bedaa se-agiyoo, we-agiyoo, se-pesee, we-pesee uduma Wa kaa manta. ");
INSERT INTO auu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yogamee mikee gaayaa bagee kuwa iminoo miya, iminoo miya kisee too toogee taatagea kiya Yogamee wisintaata si yayeetaa see bagee kuwa kisee too se toogee taapea. Ogatamee me kagoo kuwa okoo kaa topa, kisee too kagoo yadootagaa siwoo see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kuwa kaboo da Yesus Wa me mée eebaa topetaa, mée eebaa uwo yatukumetaa kiya Yohanes me mée eebaa taa, see menaa kuwa Parisi kaa bagee yuwa yeegea. Okoo me kisee yeegea see kuwa Yesus Waa ipi. ");
INSERT INTO auu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Okoo kisee menaa yeegea kiya taa. Yesus me mée uwo yatukumetaa see kuwa se kiya Wa me topenaa see bagee yuwa me too. ");
INSERT INTO auu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Parisi kaa bagee kuwa menaa yuwa yeemaagea see kuwa Yesus me ipi keta kaama Yudea wee kaa kaama metaki peedoota Galilea wee kaa. Kiyoo peetaaka too ");
INSERT INTO auu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria magaawee mee kotowataayaa kiya kitaa poono gaano pedeo naadi kitaa peedoota ");
INSERT INTO auu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria wee kaa magaa ena ekaa da ko Sikar magaa kaa kiyoo peemaayu. Sikar magaa mee ko idukaa Yakub me wayoopaa Yusup manta magaa mee ekaapa see magaa. ");
INSERT INTO auu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakub wa me uwo wogegeesi naadi ekegata komoo ena kiyoo agoo. Yesus kana peano see naadi mee komoo to geboo da kaa animaayu. Kenoo to mée mumoo to kaa kaboo ");
INSERT INTO auu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Wa me topenaa see bagee yuwa naano agiyoo edaano see naadi mée kutuu taa see yoo pe-seomegea. Wa too kiyoo toomuu taaka too ko api ena uwo wugiino see naadi mega. Meemaaga kaboo Yesus me asiino, \"Ei, Anii uwo nawugi-manii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mee Samaria kaa apii to me asiino, \"Aa ko Yahudi kaa mée to kadeega, bedaa anii ko Samaria kaa apii yoka A me 'Uwo nawugi-manii' nasege kuwa kaasee kaa ya?\" see asega. Wa me kisee asega mee ko Yahudi bagee ma, Samaria bagee ma kuwa aabe kaa mena se aawegaa, se aadee, see kuwa kaa asega menaa. ");
INSERT INTO auu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus me asiino, \"Ogatamee Wa me too aii kaniino agiyoo mee aa ipi naaki, bedaa 'Uwo nawugi-manii' see kasega Mée Waa miya ipi naaki a me 'Uwo nii' see asiyaa. Asiyaa naaki Wa me aya tuyaabuu siyaa uwoo mee aii aa kaneeyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Apii to me asiino, \"Neataagi, Aa otaawee imi taa, uwo wogegee see komoo to mee miya togoo. Kuwa aya tuyaabuu siyaa uwoo kuwa A me kayoo kaama wugiipe naa ya? ");
INSERT INTO auu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Idukaa inii mée kabawoo seta mée Yakub wa me mee uwo komoo to kaa kaama uwo daamaa noogee seta, bedaa wayoopaa nokaa yuwa ma, wa me moneekee agiyoo yuwa ma kuwa uduma kuwa uwoo daamaa noogee siwoo naadi kaama mee komoo to mee eto inii paagoo mée yaekeata. A me uwoo kuwa too daamaa naadi A too ebo, Yakub waa peedi see kuwa Aa gaage ye?\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus me asiino, \"Kuwa aii uwoo kuwa nuyaa bagee uduma bedaa uwo naadi kaapea ");
INSERT INTO auu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kiya Ni me maniyaa uwoo mee too noomaata kaama kisee too peenaa ma uwo naadi taa kiyaa. Uwo mumaa to mokoo okoo yiba kaama kuwa uwoo kabaata peedaa naadi kaama okoo iminoo miya, iminoo miya kisee too toogee taapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Apii to me asiino, \"Neataagi, mee uwoo mee anii nii, anii uwo naadi taa see kuwa ede, anii kisee too nakaayoo uwo me-wogegee segee see kuwa be\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus me asiino, \"Peedoota a me pai to mena ugidoota nakaayoo epo enaataa meei\" asigi naaki \"Anii pai taa\" asega. ");
INSERT INTO auu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yesus me asiino, \"A me 'Anii pai taa' see nasege kuwa mikee menaa. ");
INSERT INTO auu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Eto miyoo a me mée idibi, bedaa eto kiipaa miya aa mée ena paagoo aii eetoogeeke kiya mee miya a me pai to se, yoka aa mikee menaa too wegage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Apii to me asiino, \"Neataagi, Aa nabi bagee ena ii see kadeega. ");
INSERT INTO auu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Anii mena ena kaapaadiinaka, mee ko idukaa kaama inii Samaria bagee kuwa mee kuyee da kaa too Ogatamee ebo ekee, yaapaagee siwooke. Kiya ikii Yahudi bagee gaayu ko Ogatamee ebo ekee, yaapaagee taano kuwa Yerusalem magaa kaa kiyoo kaama too gaano pedeo see menaa kuwa kaasee kaa ya?\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus me asiino, \"Apii to, aa daamaa nekeenii. Epeekaa ikii Samaria bagee me Nagamee ebo ekee, yaapaagee siyaa kuwa ko maga ena kaa kaama too taa, nakaayoo mee kuyee da kaa kaama too miya taa, Yerusalem magaa kaa kaama too miya taa, see kasega kuwa mikee menaa yoka see nagaai. ");
INSERT INTO auu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ikii Samaria bagee gaayu ko ikii me ebo ekee, yaapaagee taa see Mée mee ikii ewo kiya inii Yahudi bagee kuwa Waa ipi. Ogatamee me daba mée daagimaa peeyaano menaa kuwa manii to ko Yahudi bagee paagoo kaama kemaata inii me Waa ipi. ");
INSERT INTO auu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kisee Ogatamee ebo ekee, yaapaagee taatagea kuwa eto kiipaa miya koo segeekea. Okoo mikee Ogatamee ebo ekee, yaapaagee siyaa bagee uduma okoo esee dimi menaa da me ebo ekee taapea, mikee see dimii kaa yaapaagee taapea. Mikee, Nagamee me kuwa see see naapaagee taa see bagee kuwa ede, kuwa ou see gaataa see. ");
INSERT INTO auu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ogatamee Waa dimi noogaa da too see Mée kemaata Waa ebo ekee, yaapaagee see bagee kuwa esee dimi menaa da me too ebo ekee, esee mikee see kaa yaapaagee, kisee ukuwawoo taano gaano pedeo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Apii to me asiino, \"Ebo Mesias mee, Ebo Kristus see ekaa weetaa see Mée mee meepi. Waa meepi naagoo menaa-panaa uduma daamaa mée ase-manee taapi see kuwa anii ipi\" asega naaki ");
INSERT INTO auu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","\"Mee ko mena kaawegataaka Mée Anii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kuwa menaa eewegataaka too ko Wa me topenaa see bagee yuwa meemaagea. Waa apii to ma mena aawegaa taakea yuwa okoo deeta kaama dimi nagimegea kiya okoo me \"Aa maagiyoo abage naa ya?\" see kuwa mée ena ma asiino taa, bedaa \"Aa kaasee kaa mee apii to mee mena eewegataake?\" see miya asiino taa. ");
INSERT INTO auu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mee apii to wa me uwo wugitaa see otaawee da mee kiyoo ekeata peedoota kota kaa kiyoo bagee paagoo asiino, ");
INSERT INTO auu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","\"Ei, amokomee ko Mée Waa ena ani me ukuwata-ukuwata uduma awee da kaa naawegapi. Waa Ebo Kristus mee ye, taa ye naadi ikii deesea yoka meei\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Okoo mee magaa to amoo yaato Waa pe-diino see naadi peegea. ");
INSERT INTO auu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Okoo Wa paagoo meemagaano taa kaboo da taa Wa me topenaa see bagee yuwa me Waa asiino, \"Guru, agiyoo naai\" asegea. ");
INSERT INTO auu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kiya Wa me asiino, \"Anii naano agiyoo agoo, ikii miya ewo see agiyoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Okoo me \"Waa nusi naadi agiyoo naa yadoopea ye?\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesus me asiino, \"Ni me nuyaa agiyoo kuwa ko Anii naisiyaata Mée Wa me gaayaa-gaayaa yuwa too Ani me yaukuwanaa siyaa kuwa. Wa me gaayaa-gaayaa yuwa uduma Anii daamaa yaukuwataata sikii kiyaano ou dimii mee ko Ni me naano agiyoo. ");
INSERT INTO auu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ikii me wegayaa menaa ena mee ko kisee: 'Bugi kaa agiyoo weemaayu naadi keno wui omemaata masiyaa' see kuwa ikii me wegayaa, se maa? Kiya Ani me kisiino ko: Deeweedeei, eto kiipaa miya weta agiyoo maamaa eebaa kapoo kedaaka yoka daamaa masiyaa. ");
INSERT INTO auu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Masiino bagee kuwa okoo me yaukuwataa to mokoo da maseeii segeekea, bedaa okoo me kutumeeii taa see agiyoo kuwa miya iminoo miya, iminoo miya kisee too toogee taatagea. Kisee naadi kaama wetaa see mée to ma, masetaa see mée to ma ekea paaya daamaa epo enaataa ede ma, ede ma segee siyaa. ");
INSERT INTO auu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'Mée ena me weenaa siyaa, mée ena me maseeii senaa siyaa' see wegayaa menaa mee mikee menaa. ");
INSERT INTO auu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ani me ikii kuwa yuwa daamaa namasesea yoka pooi see kisega mee ko ikii me masii masiino miya taa, weeno miya taa, kisee magaa kaa Anii kipeeyaabuu see. Kiyoo apanaa bagee okoo keta kana ma, kana ma masii masegee sepea, kaama too ikii uuto agiyoo maseeii taa see\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mee apii to wa me \"Mee Mée mee ni me ukuwata-ukuwata kuwa uduma awee da kaa naawegapi\" see eeweganaa sepa menaa kuwa kaa mee magaa kaa Yesus mikee gaayaa bagee eebaa kedaakea. ");
INSERT INTO auu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Okoo Yesus paagoo meemaata kaama \"Inii paagoo mée eeomegee, eetoogee taai\" see menaa maamaa asegea. Waa kiyoo unu wiya eeumitaaki too ko ");
INSERT INTO auu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","apanaa bagee mée eebaa miya Wa me wegataa see menaa kuwa me Waa mikee nao see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Okoo me mee apii to asiino, \"Inii a me mée eewegape menaa kuwa kaa too inii Waa mikee nao see gaage se kiya eto ko Wa me mée eewegapi menaa kuwa inii daamaa yayeemaage. Waa ko esee mikee uwoo to, magaa to mée tomaa-tomaa daba daagimaa peeyaano Mée mee ii see kuwa inii miya ipi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Unu wiya omemaata Yesus peedoota Galilea wee kaa. ");
INSERT INTO auu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wa me miyoo taa aseta menaa ena mee ko kisee: \"Nabi bagee gaayu ko wa me magaa kaa bagee yuwa me ebo se ekeasiyaa\" see asimi. ");
INSERT INTO auu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Waa Galilea wee kaa peemaata kaama kiyoo bagee me Waa ede kaa badaa maagea. Okoo me ede kaa badaa maagea mee ko okoo miyoo taa Yerusalem magaa kaa Paskah noogiino see naadi peemaata kaama Wa me ukuwata agiyoo kuwa uduma kiyoo deemea kemaata eto daamaa badaa maagea. ");
INSERT INTO auu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Waa bedaa peedoota Galilea wee kaa Kana magaa kaa, Wa me miyoo taa aii uwoo yuwa anggur poo uwoo gakadiyaami magaa kaa. Kiyoo peemaagi too ko gebo kaa magaa kaa bagee ena, Kapernaum magaa kaa kiyoo ebo tookee mée wa kaa tabogetaa see mée wa me yogaa ikiyoo ebo, ");
INSERT INTO auu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","bogaano see koo taaki yoka Yesus Waa Yudea wee kaa kaama Galilea wee kaa meemaagi yoka see menaa kuwa yeeta kaama Wa paagoo peegi. Wa paagoo peemaata kaama \"Ni me yogaa ikiyoo nataa kiyaase yoka meei\" see menaa maamaa asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus me asiino, \"Sooi, ikii nekeensea naadi agiyoo ma, apanaa dimi nagii-nagii agiyoo ma kuwa deeyu too mikee nao see nagaayaa, ikii se deeyu ko kisee taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mee eboo me asiino, \"Neataagi, ni me yogaa mee bogaanaki yoka meei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesus me \"Ee kaa pooi, a me yogaa mee se bogaapi yoka\" see asigi. Yesus me asigi menaa kuwa wa me mikee nao see gaata kaama ee kaa peegi. ");
INSERT INTO auu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Waa eta mana kaa peemaagi too ko wa me agiyoo yaokagee see bagee yuwa ma aadeekea. \"A me yogaa mee ikiyoo taa kigi nao\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wa me asiino, \"Yogaa to ikiyoo taa kipi kenoo mee mapea keno kaa naa ya?\" asigi naaki \"Etoomanaa keno mée mumoo to kaa kaama peenaa ese-betokeenigi see kaboo wa me tani see ikiyoo mee taa kipi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kuwa asegea naadi wa me mikee, Yesus me \"A me yogaa mee se bogaapi\" see nasimi kuwa mee kenoo kaa kaboo nasimi ii see nekeenigi. Kuwa kaa kaama nagamee ma, wa me ee kaa bagee ma kuwa uduma Yesus mikee gaagea. ");
INSERT INTO auu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mee Wa me kisee nekeensi naadi dimi nagii-nagii agiyoo mee ko Waa Yudea wee kaa kaama Galilea wee kaa peemaata kaama wodoo wiyaagoo to ukuwaaniyaata mee. ");
INSERT INTO auu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kuwa wodoo taa Yahudi bagee me ebo naagoo ena Yesus miya naano see naadi pakadoota Yerusalem magaa kaa. ");
INSERT INTO auu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem magaa kaa kiyoo oma wagee kenee ena ekaa da ko Domba Wodaa Peetaa See Kenee to geboo da taa uwo komoo ena agoo. Ibrani menaa kaa mee uwo komoo to ekaa da ko Betesda. Mee uwo komoo to geboo da kaa eeda-eeda ee idibi agoo. ");
INSERT INTO auu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kuwa ee yiba ikiyoo yago bagee maamaa toomuu taakea, kuwa ko emaa digiyoo see bagee ma, bado pedeo poono naka see bagee ma, oogimaata bagee ma okoo maamaa eebaa kitaa aii ometaakea. Okoo mee uwoo bega-bega taapa ye naadi diitoo taakea. ");
INSERT INTO auu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kuwa ko kaagaa ena-ena malaikat bagee ena esedoota mee uwo komoo to kaa uwo yuwa bega-bega siyaabuu segee see. Uwo bega-bega taaka see kaboo mée waa ena wa keta mee uwoo yiba moga eseanigi naaki wa kaa meanta agiyoo yuwa taa keepeasiyaa yoka naadi okoo kiyoo diitoo segee see. ");
INSERT INTO auu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kuwa kaboo da kiyoo mée waa ena, wa kaa meanta agiyoo tahun amaamo ma wagoo kisee too umiwoo seta kiya taa kaano taa see mée ena agoo. ");
INSERT INTO auu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus me waa kiyoo ometaaki see deeta kaama mikee kisee meanta kaama maamaa eebaa omegeeki yoka naadi wa paagoo \"A kaa meanta agiyoo mee taa kega see aa ede kege ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wa me asiino, \"Neataagi, uwo bega-bega taaka kaboo anii uwo yiba nadooyamaano bagee taa. Anii uwo yiba eseaniino kaboo mée waa ena keta uwo yiba eseanigi, see ukuwagee see\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus me asiino, \"Eto ko aa anoogii, a me omegee see opee to masegeeta peenaa taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kisee asigi naaki taka ena wa kaa meanta agiyoo taa keepeasigi, wa me opee to masegeeta kaama daamaa peenaaki. Mee naagoo ko Sabat naagoo yoka ");
INSERT INTO auu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yahudi kaa ebo-ebo yuwa me mee daamaa yakiyaagi mée to asiino, \"Ei, kenaagoo ko Sabat naagoo yoka a me opee to ma kisee peenaa see kuwa daa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wa me asiino, \"Anii daamaa nakiyaagi Mée Wa me 'A me opee to masegeeta peenaa taai' see nasigi yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Okoo me asiino, \"A paagoo 'A me opee to masegeeta peenaa taai' see kasigi Mée mee maamee naa ya?\" asegea naaki ");
INSERT INTO auu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","waa ewo. Kiyoo mée maamaa eebaa kemaata Yesus me mee agiyoo yataa kiyaata kaama peanigi taa ewo. ");
INSERT INTO auu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Toomuu naadi kaama Ogatamee me ee kaa Yesus me mee mée to deemaata kaama asiino, \"Eto ko a me meanta agiyoo taa, daamaa kemaage. Eto kaama wodoo pedeo agiyoo se ukuwagee taai, a kaa meanta agiyoo mee asii esee pedeo agiyoo meaniyaa yoka daamaa nekeenii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mee mée to peedoota Yahudi kaa ebo-ebo yuwa paagoo \"Anii daamaa nakiyaagi Mée mee ko Yesus mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesus me kuwa agiyoo yuwa Sabat naagoo ukuwageeki naadi kaama kuwa Yahudi kaa ebo-ebo yuwa me Yesus maamaa wisinegeekea. ");
INSERT INTO auu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kiya Yesus me okoo asiino, \"Neataagi mee idukaa kaama kisee too eto kiipaa miya Wa me agiyoo ukuwagee siwooki, bedaa Ani me miya kisee agiyoo ukuwageeka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kisee asigi naadi kuwa Yahudi kaa ebo-ebo yuwa me Waa patamaano see dimii mee ebo kegea. Sabat naagoo tuunuuki yaai naadi kaama too patamaakee se kiya Wa me \"Ogatamee mee Neataagi yoka\" kisee Waa ekaato Ogatamee ma ena doodoo ekee see menaa kuwa kaa miya esee be kegea. ");
INSERT INTO auu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bedaa Yesus me okoo asiino, \"Anii esee mikee kisiino ko: Yogamee Wa me too ukuwamaayaa agiyoo ena ma taa. Nagamee me ukuwataa see agiyoo kuwa deeta kaama too ukuwamaayaa. Nagamee me ukuwataa see agiyoo kuwa Yogamee me miya ukuwataa see. ");
INSERT INTO auu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nagamee me Yogamee esee epa yoka Wa me ukuwataa see agiyoo kuwa uduma Yogamee paagoo daamaa deeyaabuu see. Nagamee me deeyaabuu see agiyoo kuwa ko mée kaa agiyoo yataa kiyaano kuwa too se kiya mee asii esee ebo see agiyoo kuwa miya. Yogamee me kuwa agiyoo yuwa yaukuwaaniyaabuu naadi kaama ikii dimi nagimeamoo taapea. ");
INSERT INTO auu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kuwa ko Nagamee me boota bagee aya andoo peeyaata kaama tuyaayaa mokoo Yogamee me miya Wa me ede kiyaa bagee yuwa kisee too aya tuyaabuu segee siyaa. ");
INSERT INTO auu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nagamee me mée ena ma se wigintaayaa. Yogamee me mée tomaa wigintaasi naadi Wa kaa too yaekeata. ");
INSERT INTO auu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mée me Nagamee ebo ekee segee see mokoo Yogamee miya kisee ebo ekee segeesi naadi mée tomaa wigintagaa siyaa kuwa Yogamee paagoo yaekeata. Yogamee ebo se ekeasiyaa bagee kuwa Yogamee isiyaata Mée Nagamee mee miya ebo se ekeasiyaa. ");
INSERT INTO auu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Anii esee mikee kisiino ko: Ni me menaa daamaa nayeeta kaama Anii naisiyaata Mée mee mikee gaayaa bagee kuwa se wigintaata kisee too iminoo miya, iminoo miya toowoo taatagea. Okoo se pedeo kaatagea, mée umina bogaano yaato ekeata iminoo miya, iminoo miya kisee too toowoo see yaato peanta totaa see bagee yuwa kiyaa. ");
INSERT INTO auu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bedaa Anii esee mikee kisiino ko: Iminookaa boota bagee yuwa Ogatamee Yoopaa Wa me mena wuu da yiitagea. Iminookaa too se kiya eto miya boota bagee yuwa okoo Wa me mena wuu da yeeta kaama kisee too toowoo taapea. ");
INSERT INTO auu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nagamee mee ko aya toono epoo Mée. Kisee kemaata Wa me Yogamee miya mée aya tuyaabuu taano Mée kiyaata. ");
INSERT INTO auu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Waa ko Mée Yogaa kemaata mée tomaa wigintagaa siyaa kuwa miya Wa kaa too yaekeata. ");
INSERT INTO auu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ni me kisega menaa kuwa dimi se nagimaai. Ogo maata bagee yuwa uduma epeekaa Yogamee me mena wuu da yiitagea. Kuwa yiitagea bagee uduma ");
INSERT INTO auu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","okoo ogo maata yoo kaama pakaanee taatagea. Daamaa agiyoo ukuwagee seta bagee kuwa aya andoo peeyaata kaama kisee too toowoo taatagea. Pedeo agiyoo ukuwagee seta bagee kuwa aya andoo peeyaata kaama wa too pe-wigintaata pedeo kaatagea. ");
INSERT INTO auu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ni me too ukuwamaayaa agiyoo ena ma taa. Ni me gaayaa-gaayaa yuwa too ukuwageeka se kiya Anii Wa me gaayaa-gaayaa kuwa too ou naadi yaukuwageeka. Ni me mée tomaa wigintagaa siyaa kuwa ko Anii naisiyaata Mée Wa me kisee-kisee naawigintagaai see menaa yuwa Anii daamaa yayeeta kaama too mée wigintagaa siyaa. Kisee kemaata Ni me mée wigintagaa siyaa kuwa topoo too. ");
INSERT INTO auu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Anii kisee Mée, kisee Mée see menaa kuwa Ani me too weganaa siyu ko kuwa aii menaa too, mikee see menaa see taa. ");
INSERT INTO auu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ni kaa menaa nawegataa see Mée ena agoo. Wa me Ni kaa nawegataa see menaa kuwa mikee menaa too see kuwa Anii ipi. ");
INSERT INTO auu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ikii me Yohanes paagoo asedee taano see naadi mée noonaa pooi see asemea. Wa me Ni kaa \"Waa kisee Mée yoka\" see nawegami menaa kuwa mikee menaa too. ");
INSERT INTO auu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wa me mikee menaa Ni kaa nawegami kiya mée me kisee Ni kaa menaa nawegaano kuwa Anii gaano pedeo see taa. Kiya kuwa wa me Ni kaa nawegami menaa kuwa ikii me mikee gaata kaama daba daagimaa peesea naadi kiiwegaga. ");
INSERT INTO auu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes mee ko peto iyaata kaama ago kusi-kusi peeyaayaa mokoo see mée. Mee agoo da wogaamaata kuwa ko eebaa umiino taa kiya wa me menaa yuwa ikii esee ede kemea. ");
INSERT INTO auu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Anii gaayu ko Anii kisee Mée yoka see nanekeensi naadi ukuwanaa see agiyoo kuwa ebo, Yohanes me Ni kaa nawegami menaa kuwa mee asii esee ebo agiyoo. Nagamee me kuwa agiyoo yuwa naukuwataata sikii kiyaasi naadi Ni kaa naekeata yoka Ani me eto yaukuwataaka. Kuwa agiyoo kuwa ko Nagamee me mikee isiyaata Mée ii see nanekeensi naadi agiyoo yuwa yoka esee ebo. ");
INSERT INTO auu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Anii naisiyaata Mée Nagamee Wa me Ni kaa menaa nawegawoo segeeki. Ikii Wa me menaa miya yiino taa, ebeyumaa da miya diino taa, ewo. ");
INSERT INTO auu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wa me isiyaata Mée mee ikii mikee gaano taa kemaata ikii Wa me menaa yuwa miya dimi yiba yamagaano taa. ");
INSERT INTO auu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mée kisee too iminoo miya, iminoo miya aya tuyaabuu segee siyaa menaa kuwa ikii Ogatamee me kapogee yiba agoo yoka naadi kitaa ipiipi abawoo segeekea. Mikee, kuwa ebeamaata menaa yiba Anii kisee Mée ii see nanekeensi naadi menaa agoo. ");
INSERT INTO auu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ikii miya kisee too toogee siwoo siyaa kiya Ni paagoo nameeno be kegea. ");
INSERT INTO auu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mée me Anii ebo naekeasegea naaki ou see dimii mee Anii taa ");
INSERT INTO auu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","kiya ikii me dimii kuwa Anii keipi. Ikii Ogatamee mee ou dimii mee taa see bagee kideega. ");
INSERT INTO auu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Neataagi me Anii naisiyaata yoka Anii Wa ekaa da yadoonaaka kiya ikii me Anii nawisintaagea, Anii badaa namagaano be. Kiya aii bagee ena, anii ekaa yago bagee yoka naadi waa ekaato ekaa da doonaa see mée gaayu ko ikii me waa daamaa badaa maayaa. ");
INSERT INTO auu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mée me anii naapaagee, ebo naekee taano ede see dimii mee ikii agoo, kisee dimii ikii aagaa segeekea kiya ena too too Mée Ogatamee mee Wa me too naapaagee taano ou see dimii mee ikii taa. Ikii kisee bagee yoka ikii me kaasee Anii mikee nao see nagaayaa? Iyo. ");
INSERT INTO auu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nagamee paagoo 'Okoo kisee bagee yuwa too yoka' see menaa ikii kaa kiwegaatagi mée mee ko Anii se, kisee se nagaai. Ikii kaa kisee menaa kiwegaatagi mée mee ko Musa. Ikii wa me menaa wegawookea, ikii wa kaa dimi maawookea kiya wa me ikii kaa kisee pedeo menaa kiwegaatagi. ");
INSERT INTO auu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Idukaa Wa me Ni kaa menaa kuwa naebeamaata. Ikii kuwa Musa me menaa kuwa mikee menaa yoka see gaapea naaki ikii me Anii miya mikee nao see nagaayaa. ");
INSERT INTO auu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kiya kuwa wa me Ni kaa naebeamaata menaa kuwa ikii me mikee menaa yoka see dimii mee taa kiyu ko Ni me menaa kuwa ikii kaasee mikee menaa yoka see nagaayaa? Iyo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mee wodoo taa Yesus peedoota Galilea uwo piku asii yaato. Galilea uwo pikuu da see ekaa mee ena, Tiberias uwo pikuu da see ekaa miya weeyaa. ");
INSERT INTO auu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kiyoo peemaata kaama ikiyoo yago bagee yuwa Wa me ikiyoo yataa kiyaabuusi naadi dimi nagii-nagii agiyoo yuwa kuwa mée maamaa eebaa deeta kaama Waa obeegea. ");
INSERT INTO auu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Waa kuye ena kaa pakaamaata kaama Wa me topenaa see bagee ma epo animaata totaa. ");
INSERT INTO auu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kuwa kaboo da Yahudi bagee me ebo naagoo Paskah mee ekaapa. ");
INSERT INTO auu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus me deamaagi naaki mée maamaa eebaa Wa paagoo megea. Wa me Pilipus asiino, \"Apee kuwa bagee yuwa eenaano agiyoo inii kayoo kaama edaapea naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mee ko Yesus me 'Anii kisee-kisee ukuwaanaka' see dimii agoo kiya Pilipus mee gaadee taano see naadi apaadeegi menaa. ");
INSERT INTO auu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipus me asiino, \"Sooi, perak kepee ogei me badoo wiya kuwa miya sikii taa, naano agiyoo kuwa sikii-sikii se edaamaayaa. Kuwa bagee yuwa mée gakata roti ponee ena too too masiyaa miya iyo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wa me topenaa see mée ena, Andreas, Simon Petrus ebee wa me Yesus asiino, ");
INSERT INTO auu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","\"Nakaayoo yoga peedii to waa roti magu idibi, doge imi wiya kuwa topa kiya mée maamaa eebaa yoka se sikii kaapa naadi kaasee ukuwaapea naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesus me asiino, \"Mée yuwa animaaii taai see pe-niiasii\" asigi naadi pe-asegea. Kiyoo boo uwaa da agoo yoka mée yuwa kiyoo animaagea. Kuwa bagee yuwa kuwa api, yoga se egaa see, paayogaa too lima ribu waa naa. ");
INSERT INTO auu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kiyoo kaama Yesus kuwa roti magu idibi masegeeta kaama Ogatamee paagoo kiiboo, paamee see menaa asigi. Aseta kaama roti magu yuwa kiyoo animaaii sepea bagee yuwa paagoo yawuditayu. Roti yawuditaata kaama bedaa doge yuwa miya okoo uduma sikii-sikii yawuditayu. ");
INSERT INTO auu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yawuditaata kaama naano sikii, bekataa see kaboo Yesus me asiino, \"Kuwa naano taa koga topa ponee-panaa yuwa otoopa tameakee se yoka daamaa enaataa yigimeeii taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kuwa roti magu idibi kuwa kaa kaama eebaa kedaa siyaabuu sipi koga topa ponee-panaa yuwa kuwa Wa me topenaa see bagee yuwa me meeii naadi iduunee ayaa gaasi ma wiya pudii aweamaagea. ");
INSERT INTO auu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kuwa mée tabaa da okoo me Yesus me nekeensi naadi dimi nagii-nagii agiyoo mee deeta kaama wegaano, \"Mee Mée mee ko esee mikee idukaa kaama nabi bagee eboo ena meetagi see wegawoo seta Mée mee yoka\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Okoo me omaago ma Yesus mee 'Wa too inii paagoo ebo mée eetusi yoka inii Waa badaa maageeta ebo niituyaai' see dimii mee Waa nekeenta kaama bedaa pakadoota mee maga kuyee da kaa koogo Wa too pakaa-seke. ");
INSERT INTO auu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mee naagoo uwaataa da Wa me topenaa see bagee yuwa uwo geboo da kaa esegea. ");
INSERT INTO auu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kiyoo toomuu naadi kaama digiyoo takiinega. Yesus mee eseemagaano taa kaa okoo too koma ena kaa pakaanta uwo asii yaato Kapernaum magaa kaa peegea. ");
INSERT INTO auu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Peetaakea kaboo bo, biku-biku ebo mega. ");
INSERT INTO auu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kisee kega, kisee kega naadi mee komaa da kilometer idibi waa naa piku semoo to kaa peemaata kaama deamoo ko Yesus Waa bado me uwo dagii da taa komaa da doodoo metaaki. Okoo wedaagea ");
INSERT INTO auu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kiya Wa me \"Taa, Anii yoka ikii se wedaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Asigi naadi okoo ede kaa Waa komaa da kaa yaageegea, kaboo da taa ko taka ena okoo me peetaakea magaa kaa keepeasega. ");
INSERT INTO auu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tokoma mee da uwo piku asii yaato okoo koma kaa pakaanee semea yoo kiyoo kuwa mée tabaa da Yesus mee kayoo peepi naadi kaama deamaagea ko koma taa. Okoo me gaano, 'Ei, etoomanaa koma ena too too agoo, Yesus me topenaa see bagee yuwa okoo too mee komaa da kaa pakaanta peemea, Yesus ma epo enaataa poono taa' see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kuwa kaboo da taa ko apanaa komaa yuwa Tiberias magaa kaa kaama megea. Tuhan Wa me roti masegeeta \"Ogatamee paamee, magiyaage\" see aseta kaama nomea yoo magaa ekaapa see yoo kiyoo kuwa komaa yuwa meemaagea. ");
INSERT INTO auu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yesus ma, Wa me topenaa see bagee yuwa ma kuwa kiyoo toono taa naadi okoo me kuwa komaa kaa pakaanta kaama Yesus abanaa taano see naadi Kapernaum magaa kaa peegea. ");
INSERT INTO auu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yesus abanaakea bagee yuwa uwo asii yaato peemaata kaama Yesus deemaagea. Okoo me Waa asiino, \"Guru, nakaayoo tope kuwa Aa kame kepaa mpi ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wa me asiino, \"Anii esee mikee kisiino ko: Ikii me Anii naabanaakea kuwa ko Ani me mee nekeensi naadi dimi nagii-nagii agiyoo mee ikii me nadeemea kuwa me se kiya kuwa roti yuwa ikii maamaa nomea, ikii bekamea kuwa me too naabanaakea. ");
INSERT INTO auu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Naano agiyoo abawoo see mee ko aii nookee agiyoo kuwa se, moga dabiyaa see agiyoo too yoka se abaai. Mée Yogaa Wa me ikii nosea naadi kineeyaa agiyoo kuwa too abaai, ikii me anii noga naaki ou see dimii kaa ukuwawoo taai. Kuwa agiyoo se dabiyaa, mée kisee too iminoo miya, iminoo miya aya tuyaabuu segee siyaa. Wa me kuwa nuyaa agiyoo kineegeesi naadi Nagamee Ogatamee me daamaa, ede kaa Wa kaa too yaekeata yoka kuwa agiyoo too abaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Okoo me asiino, \"Ogatamee Waa ede kisi naadi yaukuwaano gaano pedeo agiyoo kuwa inii maagiyoo naa yaukuwayaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wa me asiino, \"Ogatamee ede kisi naadi yaukuwaakee agiyoo mee ko kisee: Wa me isiyaata Mée mee mikee nao see gaawoo siyaa see mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Okoo me asiino, \"Kisee gaayu ko Aa kisee Mée ii see kanekeensi naadi dimi nagii-nagii agiyoo mee maagiyoo mée yaukuwaape naa ya? Inii me kisee kadeeta kaama Aa mikee nao see kagaasi naadi agiyoo mee maagiyoo naa mée yaukuwaape naa ya? ");
INSERT INTO auu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Idukaa inii me bagee kuwa gaayu ko okoo ebo mee maga ugii da kaa manna see agiyoo mee noogee siwoo seta. Kuwa ko 'Wa me epoo to wodoo kaama roti mee okoo daamaa nusi naadi manegee seta' see menaa mee ebeamaata yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus me asiino, \"Anii esee mikee kisiino ko: Idukaa kuwa roti kuwa epoo to wodoo kaama ikii me bagee paagoo kineegee seta mée mee Musa se kiya Neataagi Wa me too. Waa ko epoo to wodoo kaama esee mikee okaa da roti mee ikii eto kineetaa see Mée mee. ");
INSERT INTO auu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mikee, Ogatamee Wa me roti mee ko epoo to wodoo kaama esedoota mée tomaa yuwa paagoo okoo aya tuyaabuu see roti mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Okoo me asiino, \"Neataagi, Aa mee roti mee inii mée manegee siwoo taai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus me asiino, \"Mée aya tuyaabuu siyaa roti mee ko Anii. Ni paagoo namiyaa bagee kuwa kisee too peenaa ma naadi se kaapea, bedaa Anii mikee nao see nagaayaa bagee kuwa kisee too peenaa ma uwo naadi se kaapea. ");
INSERT INTO auu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kiya Ani me kisema see see ikii me nadeegea kiya Anii mikee nao see dimii nagaano taa. ");
INSERT INTO auu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Neataagi Wa me Anii neetaa see bagee kuwa uduma Ni paagoo nameepea. Bedaa Ni paagoo namiyaa bagee kuwa Anii mée ena ma se abagayaa. ");
INSERT INTO auu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anii kuwa kisega kuwa ko Ni me gaayaa-gaayaa yuwa too ukuwaano see naadi epoo to wodoo kaama eseta se kiya Anii naisiyaata Mée Wa me gaayaa-gaayaa kuwa too yaukuwaano see naadi eseta yoka kisega. ");
INSERT INTO auu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wa me gaayaa-gaayaa mee ko kisee: Wa me Anii neeta bagee yuwa mée ena ma si yaegayaata okoo uduma wodopasi naagoo Ani me daamaa aya andoo peeyaabuu taata see mee. ");
INSERT INTO auu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mikee, Neataagi Wa me gaayaa-gaayaa mee ko kisee: Okoo me Yogamee mee dimi-dimi deeta kaama mikee nao see gaayaa bagee kuwa uduma iminoo miya, iminoo miya kisee too toogee siwoo siyaa, bedaa wodopasi naagoo Ani me okoo aya andoo peeyaabuu taata, see mee Wa me gaayaa-gaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesus me \"Anii ko epoo to wodoo kaama eseta roti mee\" see asigi menaa kuwa kiyoo topea Yahudi bagee yuwa me yayiino be kaa mena dukumeaweekea. ");
INSERT INTO auu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Okoo me wegaano, \"Mee Mée mee ko Yesus, Yusup yoopaa, se maa? Okonaka inii ipi yoka eto ko Wa me 'Anii epoo to wodoo kaama eseta' see wegagi menaa mee kaasee menaa?\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesus me asiino, \"Kuwa ikii me mena nadukumeaweekea kuwa ekeasii. ");
INSERT INTO auu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mée Ni paagoo nameeno mee ko Neataagi Anii naisiyaata Mée Wa me dimi mena goekeata bagee kuwa too Ni paagoo namiyaa. Kuwa bagee kuwa Anii wodopasi naagoo aya andoo peeyaabuu taata. ");
INSERT INTO auu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Idukaa nabi bagee me menaa ena mee ko kisee: 'Okoo uduma Ogatamee me tupiitagi' see menaa ebeamaata. Nagamee Wa me menaa daamaa yayeeta tupiyaa bagee kuwa Ni paagoo nameepea. ");
INSERT INTO auu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mee kisega menaa mee ko Nagamee Waa deetaa see bagee agoo, see kisega se. Wa paagoo kaama eseta Mée Wa me too, Wa me Nagamee deetaa. ");
INSERT INTO auu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Anii esee mikee kisiino ko: Anii mikee nao see nagaayaa bagee kuwa iminoo miya, iminoo miya kisee too toogee taatagea. ");
INSERT INTO auu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Anii ko mée aya tuyaabuu siyaa roti mee. ");
INSERT INTO auu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Idukaa ikii me bagee yuwa ebo mee maga ugii da kaa manna see agiyoo mee noogee seta kiya okoo boogee seta. ");
INSERT INTO auu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eto mee epoo to wodoo kaama eseta roti mee ko kisee taa. Mee roti mee nuyaa bagee kuwa uduma okoo umina se bogaapea. ");
INSERT INTO auu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Anii ko epoo to wodoo kaama mée aya tuyaabuusi naadi eseta roti mee. Mee roti mee nuyaa bagee kuwa uduma iminoo miya, iminoo miya kisee too toogee taatagea. Ani me mée tomaa aya tuyaabuusi naadi maniipa roti mee ko Ni me mogee yuwa kuwa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mee asigi menaa da Yahudi bagee yuwa okoo too omaago ma aawisii naadi wegaano, \"Wa me mogee kuwa inii nusi naadi kaasee mée maniyaa ya?\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesus me asiino, \"Anii esee mikee kisiino ko: Mée Yogaa mee Wa me mogee yuwa ma, Wa me tadaa yuwa ma kuwa ikii se nuyu ko ikii daamaa se toowoo siyaa. ");
INSERT INTO auu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ni me mogee yuwa ma, Ni me tadaa yuwa ma kuwa nanoowoo siyaa bagee kuwa iminoo miya, iminoo miya kisee too toogee siyaa, bedaa wodopasi naagoo Ani me okoo aya andoo peeyaabuu taata. ");
INSERT INTO auu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kuwa ko Ni me mogee kuwa mikee okaa da nookee agiyoo, bedaa Ni me tadaa kuwa miya mikee okaa da nookee uwoo. ");
INSERT INTO auu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ni me mogee yuwa ma, Ni me tadaa yuwa ma kuwa nanoowoo siyaa bagee kuwa Ni yiba niitoogee siyaa, bedaa Anii okoo yiba eetoogee siyaa. ");
INSERT INTO auu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aya toono epoo Mée Nagamee Wa me Anii naisiyaata. Anii Wa kaa too umiwoo, toowoo taaka. Mee mokoo miya Anii nanoowoo siyaa bagee kuwa okoo Ani kaa too toowoo taapea. ");
INSERT INTO auu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mee epoo to wodoo kaama eseta roti mee ko ena, kuwa idukaa bagee yuwa me noogee seta roti kuwa see see se. Okoo kuwa roti noogee seta kiya okoo uduma boogee seta. Eto mee roti mee noowoo siyaa bagee kuwa iminoo miya, iminoo miya kisee too toogee taapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kuwa menaa kuwa ko Waa Kapernaum magaa kaa kiyoo sembahyang segee see ee yiba kaama eewegata menaa. ");
INSERT INTO auu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wa sekaataa peenaa see bagee okoo eebaa kuwa Wa me asigi menaa yeeta kaama \"Kuwa menaa kuwa nekeeniino kana, maamee me yayeemaayaa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Okoo me mena dukumeaweekea kuwa Yesus me nekeenta kaama asiino, \"Ni me menaa kuwa kaa ikii pedeo dimii nagaagea ye? ");
INSERT INTO auu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mée Yogaa mee Wa me petamanii toogee seta yoo asiyoo bedaa metaki pakagi see kuwa ikii me deeta kaama kaasee gaayaa naa ya? ");
INSERT INTO auu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mée aya tuyaabuu siyaa mee ko Roh me too ukuwamaayaa, mée me pesee kaa iyo, se agoo kiyaayaa. Ni me kiiwegaga menaa kuwa ko Roh me menaa, Wa me mée aya tuyaayaa menaa yuwa. ");
INSERT INTO auu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kiya ikii mée noonaa me Aa mikee nao see dimii mee nagaano taa\" see asigi. Kuwa ko Yesus me Waa mikee gaano taa bagee yuwa ma, Waa mée paagoo ekegatagaapi mée to ma okoo uduma Wa me idukaa petamanii kaama ipi keta. ");
INSERT INTO auu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wa me asiino, \"Ikii kisee mikee nagaano taa bagee agoo naadi kaama Ani me yumakaa 'Nagamee me daba miyaata bagee kuwa too Ni paagoo namiyaa' see kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesus me kuwa menaa eewegamaata kaama Wa sekaataa peenaa sepea bagee mée maamaa eebaa kuwa Waa wisintaata Wa sekaataa se peegea. ");
INSERT INTO auu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kuwa bagee yuwa yaekea peeta kaama Yesus Wa me topenaa see bagee gaasi ma wiya kuwa paagoo asiino, \"Ikii miya Anii naekea poopea ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrus me asiino, \"Tuhan, inii maamee paagoo peeyaa? Aa ko mée kisee too iminoo miya, iminoo miya toowoo siyaa menaa epoo Mée, ");
INSERT INTO auu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aa ko Ogatamee me A too kawigintaata Mée see kuwa inii mikee nao see kagaage, inii esee kaipi kege\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesus me asiino, \"Mikee, Ani me ikii kuwa gaasi ma wiya kuwa kiwiginema, taa ye? Kiya ikii waa ena ko Iblis\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mee menaa mee ko kuwa mée gaasi ma wiya kuwa mée waa ena, Yudas Iskariot see mée to wa me Anii naekegatagaapi yoka naadi wegagi menaa. ");
INSERT INTO auu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mee kaama wodoo Yudea wee kaa kiyoo Yahudi kaa ebo-ebo yuwa me Yesus patamaano dimii agoo naadi Waa kiyoo peenaa taano taa, Galilea wee kaa too peenaa seta. ");
INSERT INTO auu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kuwa kaboo da Yahudi bagee me ebo naagoo ena, Ee Peedi Maataata Kiyoo Noogee, Omegee Siyaa mee ekaapa yoka ");
INSERT INTO auu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesus Waebee nokaa yuwa me Waa asiino, \"Aa nakaayoo se tooi. A me ukuwanaa segee siyaa agiyoo kuwa A me topenaa see bagee yuwa kadeesi yoka peedoota Yudea wee kaa peenaa taai. ");
INSERT INTO auu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Waa ekaato ogo peeyaano see dimii agoo see mée to gaayu ko wa me ukuwanaa see agiyoo kuwa koogo-koogo see se ukuwanaa siyaa. Kisee bagee taa yoka Aa kisee ebo agiyoo ukuwageeke gaayu ko mée tomaa uduma kadeesi yoka Aa ekaato awee da kaa mée paagoo deeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kuwa okoo me asegea menaa kuwa ko okoo Waa ma ena kenaa bagee yuwa kiya Waa mikee nao see dimii mee gaano taa kemaata asegea menaa. ");
INSERT INTO auu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesus me okoo asiino, \"Anii kiyoo poono monaa kaa kaano taa kiya ikii gaayu ko aii kaboo peeyaa. ");
INSERT INTO auu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Magaa da kaa bagee okoo me ikii se kibe kiyaa kiya Anii nabe kegea. Anii okoo me ukuwagee see agiyoo kuwa pedeo see asegeeka kemaata nabe kegea. ");
INSERT INTO auu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ikii too pakaa-naai. Anii pakaano monaa kaa kaano taa yoka se pakaapa\" ");
INSERT INTO auu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","see aseta kaama Waa Galilea wee kaa toomaayu. ");
INSERT INTO auu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Waebee nokaa yuwa naano see naadi pakaa-seomegea kaboo Waa miya pakataa, awee da kaa se kiya koogo-koogo see ");
INSERT INTO auu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","pakaamaata kaama toomuu taaka too ko Yahudi kaa ebo-ebo yuwa me Waa abanaakea. \"Mee Mée mee kayoo?\" see asenaakea. ");
INSERT INTO auu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kiyoo mée tabaa da okoo me ebe kaa menaa, poko kaa menaa kaa yawegagea. Mée noonaa me \"Waa dimi daamaa see Mée\" see yawegagea kiya noonaa me \"Taa, Wa me mée yuwa deebaa segeeki yoka\" see yawegagea. ");
INSERT INTO auu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kisee aaseekea kiya kuwa Yesus kaa menaa kuwa Yahudi kaa ebo-ebo yuwa me nakagoo kaapea yoka naadi weda kaa mée ena ma awee da kaa se wegagea. ");
INSERT INTO auu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ebo naagoo noogee siyaa yuwa unu wui omekomeeyu see naagoo Yesus Waa Ogatamee me ee kaa pakaamaata kaama mée yuwa topetaa. ");
INSERT INTO auu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wa me mée topetaa see menaa kuwa Yahudi kaa ebo-ebo yuwa me dimi nagimegea. \"Waa sekolah tupiino taa yoka Waa kuwa dimi ipi kigi kuwa kaasee kaa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wa me okoo asiino, \"Ni me mée topetaa see menaa kuwa Ni me menaa se kiya Anii naisiyaata Mée Wa me menaa too. ");
INSERT INTO auu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wa me gaayaa-gaayaa yuwa yaukuwaano ou gaayaa bagee kuwa okoo me too kisee nanekeeniyaa. Kisee bagee kuwa Ni me mée topetaa see menaa kuwa mikee Ogatamee me menaa yee, Ni me aii wegataa see menaa too yee see kuwa okoo me ipi kaapea. ");
INSERT INTO auu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Okoo mée me ebo naekeasiino ou see dimii gaayaa bagee kuwa gaayu ko okoo me aii dimi kaa menaa too wegataa siyaa kiya mée waa ena, waa peeyaata mée wa too mée me ebo ekeasi naadi menaa yawegataa see mée mee gaayu ko waa mikee, dimi topoo, makapaa dimii, makapaa menaa kuwa peenaa ma taa. ");
INSERT INTO auu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa mee gaayu ko ikii me bagee yuwa deewoosi naadi menaa kuwa kineeta, se maa? Kiya ikii kuwa menaa daamaa yadeewoo, yayeewoo see bagee ena ma taa. Kuwa me kemaata ikii me kaasee kaa Waa tuunuu see Mée yoka naadi kaama napatamaano dimii nagaagea ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kiyoo mée tabaa da me asiino, \"Aa paa yago mée see kadeege. Aa kapatamaano bagee maamee naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus me asiino, \"Anii agiyoo ena too too ukuwama naadi kaama ikii uduma dimi nagimemea. ");
INSERT INTO auu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa me paayogaa yogaa yuwa kado ponee daapii taano menaa mee deewoosi naadi ikii me bagee paagoo kiekeata. (Musa me kuwa menaa okoo paagoo ekeata see wegayaa kiya petamanii kuwa menaa kuwa Ogatamee me Musa miyoo bagee paagoo aseta.) Kuwa menaa kiekeata kemaata ikii me Sabat naagoo miya paayogaa yogaa yuwa kado ponee yadaapii segee siyaa. ");
INSERT INTO auu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kisee kuwa Musa me kiekeata menaa kuwa ikii me se ekeata deewoo taano see naadi Sabat naagoo miya kado ponee yadaapii segee see. Ikii me kado ponee ena too too yadaapeasiino kuwa dagu gaayu ko Ani me mée waa ena wa me maa da kuwa uduma Sabat naagoo daamaa yakiyaama kuwa ikii kaasee kaa nakagoo kegea ya? ");
INSERT INTO auu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ikii ewo kaa otoopa tapaato yaato too deeta kaama wegaakee se kiya mée waa ena kaa 'Waa kisee mée yoka' see menaa yawegaano see gaayu ko ipiipi nekeenta kaama daamaa topoo see menaa kaa too yawegaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kiyoo kaama Yerusalem magaa kaa bagee noonaa me wegaano, \"Mee Mée mee ko okoo me patamaano ou see gaataa see Mée mee, se maa? ");
INSERT INTO auu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Deeweei, Waa mée paagoo awee da kaa mena eeweganaa segeeki kiya inii me ebo-ebo yuwa me Waa ma aawisii siyaa menaa ena ma taa kegea. Okoo me 'Waa ko mikee Ebo Kristus ii' see gaagea kepa ye? ");
INSERT INTO auu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kiya taa, Ebo Kristus gaayu ko Waa mee magaa to kaa Mée, Waa mee magaa to kaa kaama mipi see kuwa ipi kiyaa bagee ena ma taa. Kiya mee Mée mee Waa kabata magaa mee inii ipi yoka\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus Waa Ogatamee me ee kaa mée tupitaaki too ebo menaa-menaa kaa asiino, \"Ikii me Anii mikee naipi kegea ye? Anii mee magaa kaa kaama meta see kuwa miya ikii mikee naipi kegea ye? Anii meta mee ko Ni me gaayaa-gaayaa kaa too aii meta se kiya Wa too mikee menaa yago Mée Wa me too naisiyaata. Ikii Waa ewo kegea. ");
INSERT INTO auu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Anii Wa paagoo kaama meta, Wa me Anii naisiyaata yoka Anii Waa ipi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kisee asigi naadi okoo me Waa peneasiino see kookea kiya iyo, Waa peneasiino monaa kaa pakaaniino taa kemaata se peneasegea. ");
INSERT INTO auu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kiya kuwa mée tabaa da mée eebaa Waa mikee nao see gaagea. Okoo me wegaano, \"Ebo Kristus mee ko Waa meemaata kaama dimi nagii-nagii agiyoo eebaa ukuwaaniyaabuu taatagi kiya Mee Mée mee ko kisee agiyoo maamaa eebaa ukuwaaniyaabuu taaki yoka Waa, se maa?\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Okoo me kisee aasee taakea menaa kuwa Parisi kaa bagee me yeegea. Yeeta kaama imam bagee yuwa ma epo enaataa peedoota Ogatamee me ee yadiitoo taa see bagee paagoo \"Ikii Waa pe-niipeneasii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kuwa kaboo da Yesus me asiino, \"Anii ikii paagoo eebaa taa kiiomegee naadi kaama bedaa Anii naisiyaata Mée paagoo metaki poota. ");
INSERT INTO auu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pe-seometa kaama wodoo ikii me Anii naabanaa taapea kiya se nadeemagaapea. Anii peemaata toogee taata yoo ikii se nameemaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahudi kaa ebo-ebo yuwa me aawegaa taano, \"Waa peemaata kaama inii Waa se deemaayaa yoo kayoo naa ya? Inii me bagee yuwa Yunani bagee ma epo totaa see magaa kaa kiyoo Yunani bagee yuwa Wa me pe-tupiipi ye? ");
INSERT INTO auu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wa me 'Ikii naabanaa taapea kiya se nadeemagaapea. Anii peemaata kaama toogee taata yoo ikii se nameemaayaa' see wegagi menaa mee kaasee menaa naa ya?\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kuwa noogee, omegee siyaa yuwa wodopasi ebo naagoo Yesus yiinaageeta kaama ebo menaa-menaa kaa wegaano, \"Uwo naadi kiyaa bagee yuwa uwo nusi yoka Ni paagoo medaa siweei. ");
INSERT INTO auu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Anii mikee nao see nagaayaa bagee kuwa Ogatamee me kapogee yiba mena ena mee mokoo okoo miya kisee kaapea, mee ko kisee: 'Uwo anoo da peeyaa mokoo okoo miya dimi yiba kaama daamaa toowoosi naadi uwoo kuwa pakadaa segee siwoo taapea' see menaa ebeamaata\" see wegagi. ");
INSERT INTO auu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Wa me wegagi menaa kuwa ko Roh mee ebea-ebea menaa yuwa. Yesus Waa aya andoo peeta kaama ebo ekeasiino taa kaboo yoka Roh mee miya mée paagoo maniino taa. Epeekaa Yesus mikee gaayaa bagee yuwa Roh mee masiitagea naadi ebea-ebea menaa kuwa. ");
INSERT INTO auu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wa me menaa yiitookea bagee yuwa noonaa me asiino, \"Mee Mée mee ko mikee idukaa kaama Nabi eboo ena inii paagoo miyaatagi see wegawoo seta Mée mee ii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bedaa mée noonaa me asiino, \"Waa ko Ogatamee me wigintaata Mée Ebo Kristus mee yoka\" see asegea. Kiya apanaa bagee me asiino, \"Taa, Waa Galilea wee kaa Mée to. Ebo Kristus mee Galilea wee kaa kaama meetagi see menaa kuwa wegawoo taano taa, se maa? ");
INSERT INTO auu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ogatamee me kapogee yiba ebeamaata menaa ena mee ko kisee: 'Ebo Kristus mee ko Daud me asii-kaba-kaba seta kaa Mée ena kaatagi, bedaa Daud kabata magaa, Betlehem magaa kaa kaama meetagi' see menaa ebeamaata, se maa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Okoo me 'Yesus mee kisee Mée, kisee Mée' see aawisi-maawisi naadi kaama ukuu wiya baataagea. ");
INSERT INTO auu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mée noonaa me Waa peneasiino dimii agoo kiya pe-peneasiyaa see taa. ");
INSERT INTO auu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kuwa Ogatamee me ee yadiitoo taa see bagee okoo Yesus paagoo peegeeta metaki imam ebo yuwa ma, Parisi kaa bagee yuwa ma okoo paagoo megea. Meemaagea kaboo okoo me \"Yaai, ikii kaasee kaa Yesus mee peneata doomeeno taa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kuwa yadiitoo taa see bagee yuwa me asiino, \"Wa me wegataa see menaa kuwa wa too, mée ena ma kisee menaa wegaano taa yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisi kaa bagee me asiino, \"Yaai, Wa me ikii miya kideebaa seta kaama mikee menaa yuwa kiewo kedaa siyaagi ye? ");
INSERT INTO auu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yahudi kaa ebo-ebo yuwa ma, Parisi kaa bagee yuwa ma inii mée ena ma Waa mikee nao see gaano taa, se maa? ");
INSERT INTO auu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kiya kuwa mée tabaa da okoo Wa me menaa too peneata Musa me menaa kuwa ewo, kisee ekeata bagee yuwa yoka okoo kaa pedeo menaa ayaa to mantaata bagee yuwa too\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kuwa Parisi kaa bagee ena ko Nikodemus, miyoo taa Yesus paagoo peemi mée to. Wa me asiino, ");
INSERT INTO auu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","\"Musa me menaa yiba inii me deewoo siyaa menaa ena mee ko kisee: Mée waa ena, wa kaa mena agoo see mée to gaayu ko kuwa wa me koo taaki agiyoo yuwa inii ewo, wa me menaa daamaa yeemagaano taa kaa hukuman se maniyaa, see menaa da mee inii deewoo siyaa, se maa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Okoo me asiino, \"Aa miya Galilea wee kaa mée to ye? Aa kapoge yiba ipiipi dii. Nabi bagee gaayu ko Galilea wee kaa kaama mée ena ma se meepi see kuwa a me diipe\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kiyoo kaama mée gakata okoo wa me ee kaa, wa me ee kaa peedaakea. ");
INSERT INTO auu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kiya Yesus Waa pakadoota Zaitun kuyee da kaa kiyoo omemaayu tokoma mee da ");
INSERT INTO auu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","peenaa aweepeasega kaboo Waa bedaa peedoota Ogatamee me ee kaa peemaagi too ko mée uduma Wa paagoo medaakea. Waa animaata kaama mée topetaaka too ko ");
INSERT INTO auu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Musa me menaa mée topetaa see bagee ma, Parisi kaa bagee ma kuwa api ena, tobaaka sepa apii to pe-peneata badaa maadoota Wa paagoo eemegea. Okoo me mee apii to kiyoo topea bagee yuwa yaayupii da kaa yiinaageeyaata kaama asiino, ");
INSERT INTO auu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","\"Ei, Guru. Mee apii mee ko tobaaka taaka too deemaata kaama peneasege. ");
INSERT INTO auu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Idukaa Musa me 'Kisee apii gaayu ko boosi yoka oma kamu me wogeepeasii' see mée aseta. Kisee kemaata A me naa kaasee gaage? Mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Okoo me asegea menaa mee ko Yesus koopoo see menaa ena wegasi naadi asegea. Okoo me \"Yaai, Wa me wegapi menaa da mee pedeo yoka\" see yawegaano see naadi asegea menaa. Kiya Yesus Waa kodeata kaama kepo me magaa to kaa mena ebeataa. ");
INSERT INTO auu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Okoo me kisee mée asii, mée asii see maamaa asegea naadi kaama Waa yiinaageeta kaama asiino, \"Ikii waa ena, pedeo dimii, pedeo menaa ena ma taa see mée wa me keta mee apii to oma kamu me wugisi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aseta kaama bedaa kodeata magaa to kaa mena ebeataa. ");
INSERT INTO auu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Okoo Wa me menaa kuwa yeeta kaama waa ena koogo peegi, waa ena koogo peegi. Ebo bagee yuwa okoo keta peedaakea, kaama too apanaa yuwa miya uduma peedaa naadi Yesus mee apii to ma ekea too totaa. ");
INSERT INTO auu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesus yiinaageeta kaama mee apii to asiino, \"Okoo kayoo? Aa boose naadi kawegapea bagee kuwa ena ma toono taa ye?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","\"Ei, Neataagi, mée ena ma taa\" see asega. Yesus me asiino, \"Anii miya kisee pedeo menaa se kawegaapa. Eto ko aa pooi. Eto kaama wodoo pedeo agiyoo se ukuwaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Bedaa Yesus me mée yuwa asiino, \"Anii ko magaa da kaa bagee paagoo yawogaamaayaa Agoo da. Ni sekaataa namiyaa bagee kuwa digiyoo yiba se peenaa taapea. Mee agoo da okoo kaa agoo naadi kaama daamaa toowoo taapea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisi kaa bagee me asiino, \"Kuwa menaa kuwa A me too wegage. Aa 'Mikee kisee Mée to ii' see kuwa Aa mikee kaipi naadi kawegaano bagee ena ma taa yoka kuwa makapaa menaa too kadeege\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus me asiino, \"Anii kisee Mée yoka see kuwa Anii ekaato kaa wegayaa miya Anii mikee menaa wegayaa. Ni me meta yoo miya Anii ipi, Ni me poopa yoo miya Anii ipi yoka Ni me menaa kuwa mikee menaa too. Kiya ikii Ni me meta yoo miya ewo, Ni me poopa yoo miya ikii ewo. ");
INSERT INTO auu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ikii ko mée me gaayaa-gaayaa dimii me too 'Aa kisee mée yoka, kisee mée yoka' see pe-wigintagaa siyaa bagee. Anii mée ena ma se wigintaayaa. ");
INSERT INTO auu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ani me mée wigintaayaa miya Ani me too wigintaayaa se kiya Nagamee, Anii naisiyaata Mée ma Enaa paaya epo enaataa mée wigintagaa siyaa yoka Ani me mée wigintagaano kuwa mikee, topoo too. ");
INSERT INTO auu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ikii me deewoo siyaa menaa yiba mena ena ko kisee: 'Mée ekea wiya, ekea paaya \"Anii kisee deepa, kisee deepa\" see kuwa mee menaa too wegayu ko ekea me menaa mikee menaa yoka naadi daamaa yayeeyaa' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mee mokoo miya Anii kisee Mée ii see nanekeensi naadi nawegaano bagee wiya agoo. Ena mee ko Anii, bedaa ena mee Nagamee, Anii naisiyaata Mée, Enaa paaya yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kuwa bagee yuwa me asiino, \"Agaataagi mee kayoo?\" asegea naaki Yesus me asiino, \"Ikii Anii esee naipi see taa, Neataagi Waa miya ewo see bagee yuwa. Ikii me Anii miya naipi naaki Neataagi Waa miya ipi kiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Wa me asigi menaa kuwa ko Ogatamee me ee kaa kepe awetaa see yoo geboo da kaa Wa me mée tupitaaki too asigi menaa. Waa peneasiino bagee ena ma taa, mee monaa kaa pakaaniino taa kemaata. ");
INSERT INTO auu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bedaa Yesus me okoo asiino, \"Anii poota naagoo ikii me naabanaa taatagea kiya ikii me pedeo dimii, pedeo menaa kuwa kaa bogaatagea. Anii poota yoo ikii miya meeno iyo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahudi kaa ebo-ebo yuwa me aawegaa taano, \"Wa me 'Anii poota yoo ikii miya meeno iyo' see wegagi menaa mee Waa ekaato wugimagaapa naadi kaama wegagi menaa kepa\" kisee aaseekea. ");
INSERT INTO auu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesus me asiino, \"Ikii ko yamuyaato magaa da kaa bagee. Anii mee ko asiyaato kaama Mée. Ikii manii to ko magaa da kaa kaama, ikii kisee dimi yago bagee. Anii mee ko magaa da kaa kaama se. ");
INSERT INTO auu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kisee kemaata 'Ikii me pedeo dimii, pedeo menaa kuwa kaa bogaatagea' see kisega. Anii kisee Mée, kisee Mée see kisega menaa kuwa ikii me mikee nao see dimii mee taa kiyu ko ikii me pedeo yuwa kaa umina bogaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Okoo me asiino, \"A me 'Anii kisee Mée yoka' see mée asege kuwa Aa maamee naa ya?\" asegea naaki Wa me asiino, \"Yaai, Anii petamanii kaama mapea menaa kisiwoo segeeka ya? ");
INSERT INTO auu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ikii Ogatamee ma menaa eebaa kuwa Ani me kisee yoka, kisee yoka see maamaa kisiyaa, Anii kisee ikii kiwigintaayaa kiya Anii naisiyaata Mée Wa me menaa too Anii yawegagee see. Waa ko mikee menaa too wegataa see Mée yoka Anii Wa me menaa yeeta kaama magaa da kaa yaweganaa segeeka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wa me 'Nagamee gaamaata kaama mée asigi menaa yoka' see kuwa okoo se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","See kemaata Yesus me okoo asiino, \"Mée Yogaa mee ikii me yagaataata kaama 'Mikee, Wa me Anii kisee Mée yoka see wegami ii' see kuwa ikii me nanekeeniitagea. Bedaa 'Ani me too ukuwamaayaa agiyoo ena ma taa, Nagamee me Ni paagoo natopetaa see menaa kuwa too yawegataaka yoka' see wegami ii, see kuwa miya ikii naipi kaatagea. ");
INSERT INTO auu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Anii naisiyaata Mée Waa Anii ma epo enaataa naatupi. Waa dimi wikii-wikii siyaayaa agiyoo kuwa Ani me kisee too yaukuwanaa segeeka yoka Waa Ani too naekeasiino taa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kuwa menaa wegataaki too ko mée eebaa Waa mikee nao see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kuwa Yahudi bagee yuwa okoo Yesus mikee gaagea bagee yuwa paagoo Wa me asiino, \"Ikii Ni me menaa kuwa daamaa peneata doowoo, umiwoo siyu ko ikii mikee Ni me kitopetaa see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ikii mikee menaa daamaa ipi kaapea, bedaa kuwa mikee menaa kuwa me ikii daba kipeeyaabuu taapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Okoo me asiino, \"Inii ko Abraham me asii-kaba-kaba seta bagee. Idukaa kaama eto too apanaa tomaa kaa bagee me okoo me agiyoo aii yaokagee taano see naadi inii hamba bagee mée kiyaano taa. Kisee taa yoka A me 'Ikii daba kipeeyaabuu taapa' see mée asege menaa kuwa kaasee menaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesus me asiino, \"Anii esee mikee kisiino ko: Pedeo dimii gaataa, pedeo agiyoo ukuwataa see bagee kuwa uduma kuwa pedeo dimii, pedeo agiyoo kuwa too ukuwageesi naadi hamba kiyaata bagee yuwa mokoo kiyaa. ");
INSERT INTO auu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mée me ee kaa agiyoo yaokageesi naadi hamba kiyaata mée to gaayu ko waa mee ee kaa kisee too epo se eeumiwoo, toowoo siyaa. Mee ee epoo mée wa me yogaa to wa too mee ee kaa iminoo miya, iminoo miya kisee too eeumiwoo, toowoo siyaa. ");
INSERT INTO auu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kisee kemaata Yogamee me ikii daba kipeeyaagi kepa ko ikii miya esee mikee daba kipeeyaata toowoo see bagee kiyaa. ");
INSERT INTO auu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ikii ko Abraham me asii-kaba-kaba seta bagee see kuwa Anii miya ipi. Ikii kisee bagee kiya Ni me menaa yuwa ikii dimi yiba daamaa magaano taa kemaata Anii napatamaano ou see dimii ikii agoo. ");
INSERT INTO auu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ni me Nagamee paagoo deeta-deeta yuwa Anii kiiwegataaka. Ikii miya ikiitaagi me menaa yuwa yayeeta kaama kisee yaukuwageekea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Okoo me asiino, \"Iniitaagi mee ko Abraham\" see asegea. Yesus me asiino, \"Ikii mikee Abraham me yogaa naaki wa me daamaa ukuwagee seta yuwa kuwa ikii me miya ukuwagee siyaa. ");
INSERT INTO auu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anii Ogatamee paagoo mikee menaa yuwa yayeeta kaama ikii paagoo daamaa kiiwegageeka kiya ikii me Anii napatamaano dimii nagaataakea. Kisee agiyoo kuwa Abraham me ukuwaano taa. ");
INSERT INTO auu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ikii ikiitaagi me ukuwagee siyaa agiyoo kuwa too ukuwageekea\" see asigi. Okoo me asiino, \"Inii gaayu ko tobaaka kaa mée kabata yogaa yuwa se. Iniitaagi Waa ena too too, Ogatamee mee too\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus me asiino, \"Ikiitaagi mee Ogatamee naaki ikii me Anii naepa kiyaa. Anii Ogatamee paagoo kaama meta. Anii meta mee ko Ni me gaayaa-gaayaa kaa too meta see se kiya Wa me Anii naisiyaata kemaata meta. ");
INSERT INTO auu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ni me menaa kuwa kisee too kiiwegageeka kiya ikii me Anii se nanekeenegea kuwa kaasee kaa? Ikii Ni me menaa yuwa se nayeemaayaa. ");
INSERT INTO auu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ikii ko ikiitaagi Iblis yaato kaama bagee. Kisee kemaata ikiitaagi me ou gaayaa-gaayaa yuwa too ikii me yaukuwaano ede. Waa petamanii kaama kisee too mée wugitaa see mée. Wa yiba mikee menaa ena ma taa kemaata mikee menaa yaato taa see mée. Waa ko makapaa menaa wegataa see mée, makapaa menaa epoo mée yoka kisee waa makapaa menaa wegayu ko wa me iyee-payee kaa kaama too wegataa see. Ikii wa me menaa yayeetaa see bagee yuwa ");
INSERT INTO auu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","kiya Anii mikee menaa too kiiwegageeka. Kisee kemaata ikii mikee nao see dimii mee nagaano taa. ");
INSERT INTO auu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ikii me Ni kaa 'Waa kisee pedeo agiyoo ukuwapi yoka' see menaa kuwa nawegayaa bagee ena ma agoo ye? Anii mikee menaa too daamaa kiiwegageeka gaayu ko ikii kaasee kaa mikee nao see nagaano taa ya? ");
INSERT INTO auu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ogatamee yaato bagee gaayu ko Wa me menaa daamaa yayeetaa siyaa. Ikii ko Ogatamee yaato taa see bagee yoka Wa me menaa si yayeetaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudi kaa ebo-ebo yuwa me Yesus asiino, \"Aa ko Samaria kaa mée, paa yago mée see kasege kuwa mikee menaa too, se maa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus me asiino, \"Anii paa yago mée se. Anii Neataagi mee ebo ekee segeeka kiya ikii me Anii peedi naekee segeekea. ");
INSERT INTO auu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mée me Anii ebo naekeasegea naaki ou see dimii mee Anii taa. Anii ebo naekeasiino ou see Mée ena agoo, Wa me too mena Ni kaa daamaa nadaakomee taa see Mée. ");
INSERT INTO auu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Anii esee mikee kisiino ko: Ni me menaa daamaa peneata nadeewoo siyaa bagee kuwa umina se boota iminoo miya, iminoo miya kisee too toowoo taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yahudi kaa ebo-ebo yuwa me asiino, \"Aa ko mikee paa yago mée to ii see kuwa inii eto kanekeenege. Mee ko idukaa Abraham mee miya boota, nabi bagee kuwa miya boota. Uduma boota kiya A me wegaano, 'Ni me menaa daamaa peneata nadeewoo siyaa bagee kuwa umina se boota iminoo miya, iminoo miya kisee too toowoo taatagea' see wegage. ");
INSERT INTO auu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham mee miya boota, nabi bagee miya boota, okoo toowoo taano taa kemaata okoo peedi, Ni too ebo see kuwa Aa gaage ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus me asiino, \"Anii ekaato kisee ebo ekee see naaki Anii ebo naekee see menaa kuwa otoopa imi taa menaa too kiyaa. Anii ebo naekee see Mée mee ko Neataagi mee, ikii me 'Inii me Eboo Ogatamee' see wegageekea Mée mee. ");
INSERT INTO auu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Waa ko ikii me ewo see Mée kiya Anii Waa ipi. Kisee Anii 'Waa ewo' see wegayu ko Anii makapaa menaa wegataa see mée kiyaa, Anii miya ikii see see kiyaa. Kiya taa, Anii mikee Waa ipi, Anii Wa me menaa kuwa daamaa peneata yadeewoo segeeka. ");
INSERT INTO auu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Idukaa kaama Anii meeta monaa da mee ikiitaagi Abraham me anii kadiipa nao naadi esee ede ma, ede ma nadiitoo siwoo seta. Mikee, Anii meemaama mee wa me nadeeta kaama esee ede kimi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahudi kaa ebo-ebo yuwa me asiino, \"Aa tahun mée wiya ma gaasi kuwa umiino taa see Mée kiya Abraham mee Aa deeme ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus me asiino, \"Anii esee mikee kisiino ko: Abraham mee agoo kaano taa kaboo Anii toono too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kisee asigi naadi okoo me Waa oma kamu wugitagaano see naadi masegeegea kiya Waa ekaato boonemaata Ogatamee me ee kaa kaama pe-seomigi. ");
INSERT INTO auu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus Waa peetaaka too deeyaa naaki mée ena, idukaa kabata yoo kaama emaa digiyoo keta see mée ena tupi. ");
INSERT INTO auu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wa me topenaa see bagee me Yesus asiino, \"Guru, mee mée mee kisee emaa digiyoo keta mee gaayu ko maamee me pedeo ukuwamaata kaama kisee kabata ya? Waa ekaato me pedeo kaa ye, okonaka me pedeo kaa ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus me asiino, \"Waa emaa digiyoo keta mee ko waa ekaato pedeo kaa miya taa, okonaka me pedeo kaa miya taa kiya Ogatamee Wa me mee mée to kaa pesee yakiyaayaa agiyoo kuwa mée uduma awee da kaa deeyaano see naadi ukuwaanta. ");
INSERT INTO auu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Digiyoo takiiniipa yoka Anii naisiyaata Mée Wa me agiyoo yuwa inii awee see yaato yaukuwagee taano gaano pedeo. Digiyoo takiinta kaama wodoo mée ena ma agiyoo se koo semaayaa. ");
INSERT INTO auu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Anii magaa da kaa totaa see kaboo kuwa Anii magaa da kaa bagee paagoo awee yawogaamaayaa Agoo da mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aseta kaama magaa to kaa dabeedi taakomeeta tapaa-tapaa naadi kaama mee mée to emaa yuwa kaa widimemaayu. ");
INSERT INTO auu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Widimemaata kaama \"Eto ko aa peedoota Siloam pikuu da kaa kiyoo pe-wetogeai\" see asigi. Siloam see ekaa mee wegayu ko Peeyaata see ekaa mee. Kisee asigi naadi waa peedoota mee pikuu da kaa uwo wetogemaata kaama ee kaa peetaaki naaki emaa diino keago kigi. ");
INSERT INTO auu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ee kaa peemaagi ko wa me ee geboo da kaa bagee kiyoo toomuu taakea, waa kepe neesi naadi idimegee sipi kaboo waa ipi see bagee yuwa miya kiyoo topea. Okoo me asiino, \"Mee mée mee ko kepe idimegee see mée mee, se maa?\" asegea naaki ");
INSERT INTO auu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","mée noonaa me \"Mikee waa\" asegea kiya noonaa me \"Taa, mee waa keenda see mée ena\" see asegea. Kaama too mee mée to me asiino, \"Mikee, Anii ke\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Okoo me asiino, \"Kisee kiya aa emaa diino keago kege kuwa kaasee kaa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wa me asiino, \"Mee Yesus see Mée to me tapaa-tapaa semaata kuwa ani me emaa yuwa kaa nawidimpi. Nawidimemaata kaama 'Peedoota Siloam pikuu da kaa uwo pe-wetogeai' see nasigi. Kisee nasigi naadi anii peedoota mee pikuu da kaa uwo pe-wetogiyaa naaki emaa diino keago keepeasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Okoo me \"Mee Mée to kayoo?\" asegea naaki \"Ewo\" asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mee idukaa kaama emaa digiyoo keta see mée mee Parisi kaa bagee yuwa paagoo badaa maagea. ");
INSERT INTO auu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesus Wa me kuwa tapaa-tapaa semaata mee mée to emaa daamaa yakiyaabuu sipi naagoo mee ko Sabat naagoo. ");
INSERT INTO auu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Badaa maamaagea kaboo Parisi kaa bagee yuwa me apaadiino, \"Aa kaasee diino keago kege naa ya?\" asegea naaki wa me asiino, \"Mée Waa ena me ni me emaa yuwa kaa tapaa nawidimetaata kaama anii uwo kaa wetogiyaa naaki diino keago kepa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kuwa Parisi kaa bagee noonaa me wegaano, \"Mee Mée mee Sabat naagoo diiyoo deeyaa menaa kuwa daamaa se deewooki yoka Waa Ogatamee me mée yamiyaano taa see Mée\" see asegea. Kiya apanaa bagee me wegaano, \"Waa aii dimi pedeo see mée naaki Wa me dimi nagii-nagii agiyoo kuwa kaasee koo semaayaa?\" see asegea. Kisee aawisi-maawisi naadi ukuu wiya baataagea. ");
INSERT INTO auu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kaama too okoo me mee idukaa kaama emaa digiyoo keta see mée to kaagaa ena ma asiino, \"Wa me aa emaa masii kuwa daamaa kakiyaabuu sipi kemaata a me naa Waa kaasee Mée to see gaage ya?\" asegea naaki \"Waa nabi bagee ena\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kuwa Yahudi kaa ebo-ebo yuwa me mee mée to mikee idukaa kaama emaa digiyoo kiwoo seta kiya eto diino keago kigi ii see kuwa okoo me mikee menaa yoka see dimii mee gaano taa kemaata \"Wa me okonaka kuwa mena niiogaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Meemaagea kaboo okoo me ekea asiino, \"Mee mée mee ekea me yogaa, se maa? Waa idukaa ekea me kabata yoo kaama kisee too emaa digiyoo kiwoo seta ii see kuwa ekea miya mikee see asiyaa ye? Kisee gaayu ko waa kaasee kaa eto emaa diino keago kigi naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Okonaka me asiino, \"Mee ko mikee enaa me yogaa. Waa mikee kabata yoo kaama emaa digiyoo kiwoo seta see kuwa miya ipi. ");
INSERT INTO auu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kiya maagiyoo yaukuwamaata kaama waa eto diino keago kigi see kuwa enaa ewo. Waa emaa daamaa yakiyaagi Mée mee miya ewo. Waa ebo yoka wa too asedee taai, wa me daamaa kisiipi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Okonaka me kisee asegea menaa kuwa ko ekea Yahudi kaa ebo-ebo yuwa weda kaa asegea menaa. Kuwa ko okoo me miyoo taa wegaano, \"Yesus 'Waa mikee idukaa wigintaata wegawoo seta Mée Ebo Kristus mee' see wegayaa bagee kuwa inii me okoo paagoo 'Sembahyang ee kaa epo enaataa se niitota pooi' see asiipe\" see wegamea. ");
INSERT INTO auu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Okonaka me okoo me kisee mée asiipea yaai naadi \"Waa ebo yoka wa too asedee taai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kiyoo kaama kuwa Yahudi kaa ebo-ebo yuwa bedaa kaagaa ena ma mee idukaa kaama emaa digiyoo keta see mée to mee \"Mena niiogaai\" asegea. Meemaagi kaboo okoo me waa asiino, \"Ogatamee me a me menaa kuwa kayeegi yoka mikee menaa too mée asii. Mee Yesus see Mée to mee pedeo, Waa tuunuu segee see Mée see kuwa inii ipi yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wa me asiino, \"Mee Mée to pedeo agiyoo ukuwanaa see mée ye, taa ye see kuwa anii ewo. Anii mena ena mee too ipi, mee ko kisee: Anii miyoo taa emaa digiyoo too kiwoo sepa kiya eto ko anii diino keago kega, see kuwa too ipi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Okoo me asiino, \"Wa me maagiyoo kakoo sipi ya? A me emaa kuwa maagiyoo kaukuwamaata kaama daamaa kakiyaagi naa ya?\" asegea naaki ");
INSERT INTO auu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","wa me asiino, \"Anii kuwa menaa kuwa yumakaa kisega kiya ikii daamaa nayiino taa kepea. Kuwa menaa yuwa ikii kaasee kaa wiyaagoo to ma nayiinakea ya? Ikii miya Wa me kitopenaa see bagee yuwa kaano see naadi naapaadeekea ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kisee asigi naadi okoo me waa maamaa wisinegea. \"Aa ko Wa me menaa katopenaa see mée to kiya inii gaayu ko inii Musa me menaa too topetaa see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Idukaa Ogatamee Wa me menaa kuwa Musa daamaa ase-maneeta see kuwa mikee, inii ipi kiya mee Mée to meta yoo kayoo? Inii ewo\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wa me asiino, \"Sooi, Waa ko anii emaa daamaa nakiyaabuu sipi Mée to maa diya Waa kayoo kaama bagee ikii ewo see kuwa kaasee kaa? Anii dimi nagimega. ");
INSERT INTO auu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pedeo agiyoo ukuwanaa see mée gaayu ko wa me Ogatamee paagoo idimaano menaa kuwa si yayeeyaa. Kiya Ogatamee me menaa daamaa yayeetaa, Wa me gaayaa-gaayaa yuwa daamaa yaukuwataa, kisee Waa ebo ekee taa see mée gaayu too Ogatamee me wa me idimaano menaa daamaa yayeeyaa. ");
INSERT INTO auu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mée waa ena kabata yoo kaama emaa digiyoo kiwoo naadi kaama emaa daamaa yakiyaagi see menaa mee ko idukaa esee petamanii kaama eto too mée ena ma ewo see menaa. ");
INSERT INTO auu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kisee kemaata mee Mée to Ogatamee me miyaano taa naaki kisee agiyoo ena ma se ukuwamaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Okoo me asiino, \"Aa ko mikee pedeo dimii, pedeo menaa ma enaataa kakabata see mée kiya a me kisee yoka, kisee yoka see kuwa inii mée topetaake ye?\" see aseta kaama waa eto kaama wodoo sembahyang segee see ee kaa epo enaataa se naatoogee taai naadi abagaapeasegea. ");
INSERT INTO auu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mee mée to okoo me sembahyang segee see ee kaa epo enaataa se naatoogee taai naadi abagaapeasegea see menaa mee Yesus me yeeta kaama mee mée to ma aadee seta kaama asiino, \"Mée Yogaa mee a me mikee nao see gaage ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wa me asiino, \"Neataagi, anii Waa mikee nao see gaano see yoka Waa maamee naa ya? Nasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus me asiino, \"Mee ko a me deege Mée, mena kaawegataaki Mée mee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wa me asiino, \"Tuhan, Aa mikee nao see kagaaga\" see aseta kaama kiiboo, paamee see dimii kaa Wa paagoo mumo esee-kudiinta ebo ekeasigi. ");
INSERT INTO auu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus me asiino, \"Anii mée tomaa wigintagaano see naadi magaa da kaa meta. Mee ko emaa digiyoo kiyaa bagee kuwa emaa daamaa diino keago kedaasi naadi miya, bedaa emaa diino keago kiyaa bagee kuwa emaa digiyoo kedaasi naadi miya, kisee yakiyaabuu taano see naadi meta\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi kaa bagee noonaa kiyoo topea. Okoo me kuwa menaa yeeta kaama asiino, \"Inii miya emaa digiyoo see bagee mokoo see mée deege ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesus me asiino, \"Ikii ko emaa digiyoo see bagee naaki ikii Ogatamee ma menaa yuwa taa kiyaa kiya eto ko ikii me 'Inii diino keago see bagee yoka' see wegageekea kemaata ikii Ogatamee ma menaa kuwa taa kaano taa topa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus me wegaano, \"Anii esee mikee kisiino ko: Domba wodaa kiwitaa to yiba seemaano see naadi kenee to taa se peeta apanaa taa seemiyaa bagee kuwa ko oma maseekee bagee, oma yagaakee bagee too. ");
INSERT INTO auu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kiya kenee to taa seemiyaa mée mee ko domba wodaa munitaa see mée. ");
INSERT INTO auu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Seemaano see kaboo kenee to kaa yadiitoo taa see mée to me kenee to daamaa yakabataayaa. Seemeta kaama wa me domba wodaa yuwa wa ekaa, wa ekaa weetagaa siyaa naaki wa me mena wuu da yayeeta kaama medaakea. Meemaagea kaboo badaa maadoo peetaa. ");
INSERT INTO auu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wa me domba wodaa yuwa uduma badaa maadoota kaama wa keta eepeetaa. Domba wodaa yuwa wa me mena wuu da yayeeta kaama ipi kaa wa sekaataa obeegea. ");
INSERT INTO auu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Apanaa bagee gaayu ko se obeeyaa. Okoo me mena wuu da ewo kemaata oodaa siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus me mee ebea-ebea menaa da asigi kiya kuwa Yahudi bagee yuwa nekeeniino taa. Okoo me 'Wa me menaa kuwa kaasee mée tupitaaki menaa ya?' see dimii gaagea. ");
INSERT INTO auu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bedaa Yesus me asiino, \"Anii esee mikee kisiino ko: Anii ko domba wodaa seemetaa see kenee to. ");
INSERT INTO auu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Idukaa Anii meeno taa miyoo meta bagee kuwa uduma oma maseekee bagee yuwa, oma yagaakee bagee yuwa too yoka domba wodaa yuwa me okoo me menaa yayiino taa. ");
INSERT INTO auu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anii ko kenee to. Ni doodoo da taa seemiyaa bagee kuwa daba daagimaa poopea, bedaa okoo Ni doodoo da taa meegee, peegee naadi kaama naano agiyoo noogee yoo daamaa deemagaapea. ");
INSERT INTO auu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Oma maseekee bagee gaayu ko oma masiino ma, mée wugiino ma, mée wegee-wegee taano ma kuwa too ukuwaano see naadi miyaa. Kiya Anii meta mee ko mée daamaa tuyaabuu siwoo taano see naadi meta, okoo daamaa toowoo naadi kaama ede dimii mee maamaa eebaa kedaasi naadi meta. ");
INSERT INTO auu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Anii ko domba wodaa munitaa see Mée, daamaa mee. Domba wodaa munitaa see Mée, daamaa mee Wa me kuwa domba wodaa yuwa kaa yabogaano see naadi Waa ekaato yaekegataayaa. ");
INSERT INTO auu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aii kisee domba wodaa yamunitaa see mée to gaayu ko waa kisee dimii taa. Waa domba wodaa epoo mée taa kemaata waa domba wodaa yuwa yamunitaaki too deamoo ko piya yiba woda nookee kamenoo damaa to migi. Yaai naadi kaama kuwa domba wodaa yuwa wisintaata moga ooyaa. Oogi naadi kaama kameno me domba wodaa pekageeta kaama apa yuwa peeda-paada siyaabuu siyaa. ");
INSERT INTO auu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mee mée to domba wodaa epoo mée taa, domba wodaa yamunitaa see mée to too yoka domba wodaa daamaa diitoo taapa see dimii mee taa kemaata moga ooyaa. ");
INSERT INTO auu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Anii ko domba wodaa munitaa see Mée, daamaa mee. Nagamee Anii naipi, bedaa Anii miya Nagamee ipi. Mee mokoo miya Ni me domba yuwa Anii ipi, bedaa domba yuwa miya Anii naipi. Ni me domba yuwa kaa Anii yabogaano see naadi ekaato yaekegataayaa. ");
INSERT INTO auu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Anii apanaa domba miya agoo. Okoo eto mee kiwita yiba toono taa. Kuwa miya Anii badaa magaano gaano pedeo. Ni me mena wuu da okoo daamaa nayiipea. Okoo ma uduma aatapi taata kaama domba wodaa kutuu ena too too kaapa, bedaa okoo munitaa see Mée miya ena too too kaapi. ");
INSERT INTO auu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Anii okoo kaa yabogaano see naadi ekaato yaekegataayaa kemaata Nagamee me naepa kigi. Ni me dimi noogaa da bedaa masiino see naadi Anii ekaato yaekegataayaa. ");
INSERT INTO auu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni me dimi noogaa da mée ena ma se namasemaayaa, Anii aii se nabooyaayaa. Ni me gaayaa-gaayaa kuwa kaa too ekaato yaekegataata mée kaa yabooyaa. Ni me dimi noogaa da yaekegatagaano mee miya, Anii bedaa masemagaano mee miya ekea paaya Ni me too koo semaayaa. Ekea paaya Neataagi me 'Kisee ukuwaai' see naseta mee me Anii ekea paaya ukuwaapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kuwa Wa me menaa kuwa me Yahudi bagee bedaa aawisi-maawisi naadi kutuu wiya wuditaagea. ");
INSERT INTO auu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Okoo mée eebaa me wegaano, \"Waa paa agoo naadi taki-takii meanee taaki yoka ikii kaasee kaa Wa me menaa yayeetaakea naa ya?\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kiya mée noonaa me wegaano, \"Taa, Wa me wegayaa menaa kuwa paa yago bagee me menaa ko taa. Paa me kaasee emaa digiyoo keta see mée emaa daamaa yakiyaayaa? Iyo, se maa?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kuwa kaboo da Yerusalem magaa kaa Yahudi bagee me ebo naagoo ena, idukaa Ogatamee me ee mee bedaa daamaa yakiyaata kemaata noowoo see naagoo kega. Kuwa kaboo ko gemoo see uwaa. ");
INSERT INTO auu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus Waa Ogatamee me ee kaa Salomo see ee bapi yaato peegee see etaa da taa peetaaka too ko ");
INSERT INTO auu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yahudi kaa ebo-ebo yuwa Wa paagoo bobetaata kaama asiino, \"Inii dimi abage yoka A me 'Anii Ebo Kristus yoka' see menaa mee mikee gaayu ko A me mée asiino maadee mani kaapa naa ya? Eto ko awee da kaa mée asii\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesus me asiino, \"Anii kisee menaa kisegee sepa kiya ikii me mikee nao see dimii nagaano taa. Anii Neataagi Wa ekaa da ebo ekeasiino see naadi agiyoo yaukuwanaa segeeka. Kuwa uduma Anii kisee Mée ii see kinekeeniyaabuu taano see naadi agiyoo yuwa. ");
INSERT INTO auu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kiya ikii ko Ni me domba yuwa se kemaata Anii mikee nao see dimii nagaano taa. ");
INSERT INTO auu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ni me domba yuwa kuwa Ni me mena wuu da daamaa nayeegee see. Ani me okoo ipi, bedaa okoo miya Anii naobeegea. ");
INSERT INTO auu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ani me okoo iminoo miya, iminoo miya kisee too toowoo siyaa bagee kiyaayaa yoka okoo se pedeo kaatagea. Okoo Ni me yagaa da kaa kaama mée ena ma se napekagiipea. ");
INSERT INTO auu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Neataagi mee, okoo Ni paagoo neeta Mée mee ko Ebo Wodoo Eboo see Mée yoka Nagamee Wa me yagaa kaa kaama yapekagiino bagee ena ma taa. ");
INSERT INTO auu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Anii ma, Nagamee ma Enaa ko ena too too, ena mee too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kaagaa ena ma Yahudi bagee yuwa me Waa wogeepeasiino see naadi oma kamu masegeegea. ");
INSERT INTO auu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Oma kamu wugiino see kookea kaboo Wa me asiino, \"Nagamee me naukuwasi naadi daamaa see agiyoo yuwa esee maamaa eebaa Ani me ikii paagoo kideeyaabuu sepa. Ikii me kuwa agiyoo ena mee pedeo yoka naadi kaama oma kamu me nawugiino see kookea mee ko kamee agiyoo naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Okoo me asiino, \"Kuwa daamaa ukuwataa see agiyoo kuwa kaa se kiya Aa ko mée tomaa ena kiya Aa ekaato Ogatamee ma ena doodoo see wegage menaa kuwa Wa me kisee be kemaata oma kamu me kawugitagaanake\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus me asiino, \"Ikii me deewoo siyaa menaa yiba Ogatamee Wa me aseta menaa ena mee ko kisee: 'Ikii ko Ogatamee mokoo see bagee see kisega' see aseta, see menaa ebeamaata, se maa? ");
INSERT INTO auu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ogatamee me ebeamaata menaa ena ma si yataa kiyaayaa yoka mikee menaa too. Kisee kemaata kuwa bagee kuwa Ogatamee mokoo see bagee see yawegata yoka ");
INSERT INTO auu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ani me 'Anii ko Ogatamee Yoopaa yoka' see kisega menaa kuwa me ikii me pedeo menaa nasegea kuwa kaasee kaa ya? Nagamee me daamaa Wa too wigintaata kaama magaa da kaa isiyaata Mée mee kiya ikii me 'Kisee Aa Ogatamee wisinege' see nasegea. ");
INSERT INTO auu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Anii Neataagi me agiyoo kuwa si yaukuwayaabuu segeeka naaki Anii mikee nao see se nagaai see kisiyaa. ");
INSERT INTO auu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kiya Anii kuwa Wa me agiyoo mikee yaukuwageeka gaayu ko Ni me menaa kuwa ikii mikee nao see nagaano dimii taa miya kuwa agiyoo yuwa mikee Ogatamee me too ukuwaaniyaabuu siyaa agiyoo ii see dimii mee gaai. Ikii me kuwa agiyoo mikee nao see gaata kaama Nagamee Waa miya Ni yiba tupi, bedaa Anii miya Wa yiba topa see kuwa ikii daamaa naipi kaapea, kisee daamaa nanekeeniipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kisee asigi naadi okoo me Waa bedaa peneasiino see kookea kiya peneasiino taa, daba pe-seomigi. ");
INSERT INTO auu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kiyoo kaama Yesus peedoota Yordan uwoo asii yaato, idukaa Yohanes waa petamanii mée uwo yatukumegee seta yoo kiyoo peemaata kaama omegeeka too ko ");
INSERT INTO auu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","mée maamaa eebaa Wa paagoo medaakea. Okoo me wegaano, \"Yohanes wa me dimi nagii-nagii agiyoo ena ma ukuwaano taa kiya wa me Yesus mee 'Kisee Mée, kisee Mée' see yawegata menaa kuwa uduma mikee menaa too\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kuwa kaboo da mée eebaa Yesus mikee nao see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kuwa kaboo da mée ena ekaa da ko Lazarus mee Betania magaa kaa ikiyoo meanee taaki. Wa me ukuyogaa ekea wiya miya mee magaa kaa toogeekea. Ena mee ekaa da ko Maria, wabaaba ekaa da ko Marta. ");
INSERT INTO auu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria mee ko wunu daamaa see uwoo Tuhan badoo da kaa yakabagekomeeta kaama wa me edooyuu yuwa me daamaa yawidimeta see apii to mee. Paayogaa mee Lazarus mee ikiyoo meanee taaki naadi kaama ");
INSERT INTO auu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ekea me kuwa menaa nadoosi naadi bagee yuwa Yesus paagoo peeyaagea. Wa paagoo peemaata kaama \"Tuhan, A me epa see mée to waa ikiyoo meanee taaki see kasegea\" see yaasegea. ");
INSERT INTO auu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wa me kuwa menaa yeeta kaama asiino, \"Mee ikiyoo mee ko waa bogaano ikiyoo se kiya Ogatamee Waa ebo, Waa asii-sege see kuwa mée deeyaasi naadi ikiyoo mee, bedaa mee ikiyoo kaa kaama Ogatamee Yoopaa miya Waa ebo, Waa asii-sege see kuwa mée me daamaa diipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus me Marta ma, waebee ma, Lazarus ma kuwa uduma epa ebo. ");
INSERT INTO auu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lazarus mee meanee taaki see menaa da yeeta kaama wodoo okoo me ee kaa se peeta Wa me ometaa see yoo kiyoo bedaa unu wiya omemaayu. ");
INSERT INTO auu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Unu wiya omemaata Wa me topenaa see bagee yuwa paagoo asiino, \"Inii bedaa metaki Yudea wee kaa niipooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Okoo me asiino, \"Guru, Yudea wee kaa kiyoo kuwa Yahudi bagee yuwa me Aa oma kamu me kawogeepeasiino see koo sepea yoo kiyoo Aa poonake ye?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesus me asiino, \"Egapi yaato ko awee kuwa keno gaasi ma wiya topa, se maa? Egapi yaato peenaa siyaa bagee gaayu ko magaa da kaa bagee paagoo wogaamaayaa agoo da mee me okoo daamaa deepegee naadi kaama badoo da kaa se kepoto-kapato siyaa. ");
INSERT INTO auu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kiya daatooyiba yaato peenaa siyaa bagee gaayu ko okoo yiba agoo da taa yoka badoo da kaa kepoto-kapato siyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kuwa aseta kaama bedaa Wa me asiino, \"Inii me epa see mée Lazarus mee toomoo umpi kiya waa anoogeeyaano see naadi poonaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wa me topenaa see bagee yuwa me asiino, \"Tuhan, waa toomoo umpi gaayu ko ikiyoo taa kaapi yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesus me \"Waa toomoo umpi\" see asigi mee ko Lazarus mee boopi naadi ebea-ebea kiya okoo me 'Waa mikee toomoo umpi naadi asigi menaa too' see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wa me okoo nekeensi naadi awee da kaa asiino, \"Lazarus mee boopi. ");
INSERT INTO auu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ikii me mikee nao see nagaasea naadi Anii pe-diino taa kuwa daamaa, ede. Eto ko inii wa bootaa da paagoo poono\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kisee asigi naadi Tomas mee, Didimus see ekaa miya weetaa see mée to wa me kuwa topenaa see bagee apa yuwa asiino, \"Mée me Yesus mee wogeepeasiino see koo sepea magaa kiya inii miya Waa ma epo enaataa bogaakee yoka niipooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesus peedoota mee magaa kaa peemaagi too ko Lazarus bootaa da ogo maataata kaama unu wui ompea. ");
INSERT INTO auu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania magaa mee Yerusalem magaa ekaapa see yoo magaa, kilometer wedo waa naa too see magaa yoka ");
INSERT INTO auu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yerusalem magaa kaa kaama Yahudi bagee mée eebaa Marta ma, Maria ma ekea me paayogaa mee kaa dimi gaagaa taakea kuwa taa kisi naadi pe-eetoogeekea. ");
INSERT INTO auu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yesus mee migi see menaa mee Marta yeeta kaama Waa ma aadee taano see naadi peega. Kiya Maria mee ee kaa totaaka. ");
INSERT INTO auu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta waa Yesus paagoo peemaata kaama asiino, \"Tuhan, Aa nakaayoo mée eetope naaki ni paayogaa mee mee se booyaa. ");
INSERT INTO auu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kiya eto kiipaa miya A me Ogatamee paagoo 'Kisee naukuwaai, kisee nakiyaai' see asiyaa menaa kuwa Wa me daamaa kaukuwaaniyaapi see kuwa anii kaipi\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus me asiino, \"A paayogaa mee waa aya andoo poopi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta me asiino, \"Mikee, epeekaa wodopasi naagoo Ogatamee Wa me mée uduma aya andoo peeyaabuu taatagi naagoo waa miya epo aya andoo pootagi see kuwa anii ipi\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus me asiino, \"Anii ko mée aya andoo peeyaabuu taano ma, mée aya tuyaabuu siwoo taano ma kuwa koo taa see Mée. Anii mikee nao see nagaayaa bagee kuwa okoo booyaa miya kisee too toowoo taatagea. ");
INSERT INTO auu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kisee toowoo siyaa bagee kuwa Anii mikee nao see nagaawoo naadi kaama umina se bogaapea. Aa kuwa menaa kuwa mikee menaa yoka see nagaage ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","\"Mikee, Tuhan, Aa ko Ogatamee me kawigintaata Mée Ebo Kristus, Ogatamee Yoopaa, magaa da kaa meetagi see wegawoo seta Mée ii see kuwa anii mikee nao see kagaaga\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kisee aseta kaama peedoota ee kaa waebee Maria paagoo mena koogo goeamaaga. \"Guru mee amokiyoo meemaagi. Mena kaawegaanaka see kasigi\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria kuwa menaa yeemaata kaama mani anoogeeta kaama Yesus paagoo peega. ");
INSERT INTO auu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kuwa kaboo da Yesus Waa mée topea yoo pakaamagaano taa, Marta ma ekea aadee sepea yoo tupi. ");
INSERT INTO auu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria mee peega kaboo da kuwa waa gaagaa taa kisi naadi eetoomuu taakea bagee yuwa me waa mani anoogeeta peega kuwa deeta kaama okoo me gaano, 'Ogopa kiyoo yege magaamoo taano see naadi peega yoka' naadi obeegea. ");
INSERT INTO auu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria waa Yesus tupi yoo peemaata Yesus deeta kaama Wa me badoo da kaa mumo esee-kudiinta kaama asiino, \"Tuhan, Aa nakaayoo mée eetope naaki ni paayogaa mee mee se booyaa\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus me Maria ma, wa sekaataa mepea bagee yuwa ma uduma enaataa yegeekea kuwa deeta kaama Waa dimi boodi, gaagaa ebo. ");
INSERT INTO auu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wa me asiino, \"Wa bootaa da kayoo ogo maapea naa ya?\" asigi naaki \"Tuhan, Aa pe-diino ke meei\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesus Waa yegeeki. ");
INSERT INTO auu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahudi bagee me wegaano, \"Ikii deeweei. Waa Lazarus esee epa nao see dimii gaata kaama yegeeki\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kiya mée noonaa me asiino, \"Waa emaa digiyoo see mée emaa daamaa yakiyaami kiya kaasee Lazarus waa se boosi naadi agiyoo yaukuwaano taa naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus Waa bedaa dimi gaagaa ebo kaa peedoota ogo maapea yoo. Mee ko oma beapa, bedaa kenee to kaa ebo omaa ena kiyoo takeata topa. ");
INSERT INTO auu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus me asiino, \"Omaa to mee dogeamaai\" asigi. Boopi mée to wa ukuyogaa mee Marta me asiino, \"Tuhan, waa boota kaama unu wui ompea yoka eto wunu ebo\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesus me asiino, \"A me Anii mikee nao see nagaayu ko Ogatamee Waa ebo, Waa asii-sege see kuwa a me daamaa diipe see kasiino taa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Omaa to dogeamaagea kaboo da Yesus epoo to yaato deataata kaama asiino, \"Neataagi, wae. Ni me kasega menaa kuwa Aa daamaa nayeege kuwa paamee see kasega. ");
INSERT INTO auu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ni me kasiyaa menaa uduma A me nayeegee see kuwa Anii kaipi kiya nakaayoo yiinaageeta toomuu taakea bagee yuwa Anii A me isiyaata Mée to ii see kuwa mikee nao see nagaasi naadi awee da kaa kasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kisee aseta kaama ebo menaa-menaa kaa \"Lazarus, aa awee da kaa meanii\" see wegataagi naaki ");
INSERT INTO auu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","boopi mée to awee da kaa meanigi. Wa me yagaa bado uduma doka ponee me bebenamaata topa, bedaa wa me ebeyumaa da taa miya doka ena me bebenamaata topa. Yesus me asiino, \"Daamaa peesi yoka yaekegatagaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yahudi bagee yuwa okoo Maria paagoo eetoogee taano see naadi mepea bagee mée eebaa kuwa Yesus me ukuwapi-ukuwapi yuwa deeta kaama Waa mikee nao see gaagea. ");
INSERT INTO auu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kiya mée noonaa me kuwa Wa me ukuwapi-ukuwapi menaa yuwa doodoota Parisi kaa bagee paagoo pe-asegea. ");
INSERT INTO auu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kisee asegea naadi kaama imam ebo yuwa ma, Parisi kaa bagee yuwa ma okoo me \"Mena pekataa see bagee uduma meei\" see asegea. Uduma meemaagea kaboo da okoo me asiino, \"Yaai, mee Mée mee me dimi nagii-nagii agiyoo eebaa ukuwanaa segeeki yoka inii maagiyoo ukuwaapea naa ya? ");
INSERT INTO auu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Inii me Waa aii wisintaata kisee daba peenaa, ukuwanaa siyaagea kepa ko mée uduma Waa mikee nao see gaapea, bedaa Roma kaa bagee yuwa me Ogatamee me ee ma, inii tomaa kaa bagee ma mée wegee-wegee taano see naadi meepea\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Okoo paagoo mée ena, ekaa da ko Kayapas mee tupi. Waa ko mee tahun kaa Ebo Imam. Wa me asiino, \"Ikii dimi ewo see bagee yuwa too. ");
INSERT INTO auu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mée ena too too inii mée yabogaakee daamaa, inii se. Inii tomaa kaa bagee yuwa uduma kisee mée me mée wegee-wegee naadi kaama inii mée taa kiyaayaa kuwa pedeo yoka Waa bogaano kuwa daamaa, see kuwa ikii peenaa ma se nekeenegea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wa me asigi menaa mee ko wa me too dimii kaa menaa se. Waa ko mee tahun kaa Ebo Imam totaaki yoka Yesus mee Yahudi tomaa kaa bagee yuwa kaa yabogaapi mee kisee uwa daaniita ii see menaa kuwa wa me ewo kaa yawegagi. ");
INSERT INTO auu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesus mee Yahudi tomaa kaa bagee yuwa kaa too yabogaapi se kiya Ogatamee me yogaa yuwa uduma, uwoo to, magaa to kaa kiyoo-kiyoo wudidaa seta bagee uduma okoo enaataa kutumeeii naadi tukuguu ena too too kisi naadi yabogaapi. ");
INSERT INTO auu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","See kemaata mee naagoo kaama wodoo kuwa Yahudi kaa ebo-ebo yuwa me Yesus wugimagaano see naadi menaa koogo aawegaa siwookea. ");
INSERT INTO auu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kisee kemaata Yesus Waa kiyoo Yahudi bagee paagoo awee da kaa peenaa taano taa. Waa peedoota ebo mee maga ugii da gebo kaa magaa ena ekaa da ko Epraim see magaa kaa kiyoo peemaata kaama Wa me topenaa see bagee yuwa ma epo enaataa kiyoo ometaa, totaa. ");
INSERT INTO auu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kuwa kaboo da Yahudi bagee me Paskah noogee see naagoo ekaapa yoka mée eebaa okoo me magaa kaa kaama Yerusalem magaa kaa pakadaakea. Naano agiyoo naano taa kaboo okoo me tuunuu sepea yuwa wetogekumiino see naadi ukuwaa-ukuwaa kuwa keta ukuwaano see naadi pakagea. ");
INSERT INTO auu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pakaamaata kaama Yesus abagea. Okoo Ogatamee me ee kaa yiinaageeta toomuu taaka too aasee taano, \"Waa naano see naadi meepi ye, se meepi ye? Ikii kaasee gaagea?\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mee ko miyoo taa imam ebo yuwa ma, Parisi kaa bagee yuwa ma okoo me Yesus peneasiino see naadi mée yuwa paagoo \"Ikii Yesus Waa tupi yoo ipi kiyu ko moga mée asii\" see omaago ma wegakomee sepea kemaata Waa meepi ye naadi aaseekea. ");
INSERT INTO auu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paskah naano taa kaboo unu idibi omemaata bidimeagoo to naagoo naatagea see naagoo Yesus peedoota Betania magaa kaa, Lazarus mee, Yesus me boota kaama aya andoo peeyaami mée wa me toogee see magaa kaa. ");
INSERT INTO auu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Peemaata kaama mee ee kaa bagee ede kaa naano agiyoo yakopegea. Marta waa naano agiyoo yawuditaaka. Kiyoo notaakea bagee yuwa paagoo Lazarus waa miya tupi. ");
INSERT INTO auu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kuwa kaboo da taa ko Maria waa wunu daamaa see uwoo, kepe edaano esee ebo see uwoo ekaa da ko narwastu see uwoo mee masegeeta kaama Yesus me badoo da kaa daamaa yakabagekomeega. Yakabagekomeeta kaama wa me edooyuu yuwa me daamaa yawidimega. Mee daamaa uwoo wunuu da mee ee to uduma peemaaga. ");
INSERT INTO auu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kiya Wa me topenaa see bagee mée ena, Yudas Iskariot see mée to, Yesus ekegatagaapi mée ");
INSERT INTO auu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","wa me asiino, \"Yaai, kuwa uwoo kuwa pe-doogeeta kaama ebo kepee ogei me badoo wedo masemaata kaama daba bagee aii maniino daamaa yoka kaasee kaa kisee ukuwaano taa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Wa me kuwa asigi menaa kuwa ko wa me daba bagee yuwa epa nao see dimii gaata kaama asigi se kiya waa oma masetaa see mée kemaata asigi menaa. Mee ko Yesus ma, Wa me topenaa see bagee yuwa ma okoo epo enaataa kepee kuwa wa me too eedoonaa see kiya kepe noonaa wa me koogo oma masegee see kemaata asigi menaa. ");
INSERT INTO auu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kisee asigi naadi Yesus me asiino, \"Mee apii mee si yawegaai. Wa me nakoo sepa agiyoo mee ko Anii ogo namagaapea naagoo nakoo taapea yuwa kuwa wa me pe-nekeenta kaama nakoo sepa agiyoo yoka pedeo see si yawegaai. ");
INSERT INTO auu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Daba bagee gaayu ko ikii paagoo kisee too kiiumiwoo, toowoo taapea kiya Anii ikii ma enaataa eebaa se kiiumiipa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kuwa kaboo da taa ko Yahudi bagee mée eebaa Yesus Waa Betania magaa kaa tupi see menaa mee yeeta kaama medaakea. Okoo Yesus Wa too diino see naadi se kiya Wa me boota kaama aya andoo peeyaami mée Lazarus waa miya diino see naadi megea. ");
INSERT INTO auu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lazarus mee aya andoo peepi naadi kaama Yahudi bagee mée eebaa Yesus mikee nao see gaata kaama Wa yaato peedaakea. Kuwa me kaama imam ebo yuwa me Lazarus waa miya wugimagaano see naadi menaa koogo aawegaakea. ");
INSERT INTO auu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tokoma mee da Paskah naano see naadi mepea bagee yuwa me Yesus Waa Yerusalem magaa kaa pakataaki see menaa yeegea. ");
INSERT INTO auu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Okoo palem see piyaa kagoo yuwa daageeta kaama Yesus ma aadee taano see naadi Wa paagoo peegea. Aadee seta kaama okoo me ebo menaa kaa wegaano, \"Hosana! Tuhan ekaa yadoopi Mée mee migi yoka niiyaapaagee siweei! Israel bagee ebo mée eetotaa see Mée mee magiyaage!\" see wegapegeekea. ");
INSERT INTO auu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus mee keledai wodaa peedi ena deemaata kaama mee wodaa dagii da kaa animaayu, idukaa ebeamaata menaa ena mee mokoo see see, mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","\"Ikii Sion magaa kaa bagee se wedaai. Deeweei, ikii me Eboo mee migi. Waa keledai wodaa peedi ena dagii da kaa animaata ikii paagoo migi\" see menaa yaebeamaata. ");
INSERT INTO auu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kuwa menaa yuwa uwa daano yaato eto Wa kaa kega yoka see kuwa Wa me topenaa see bagee yuwa nekeeniino taa. Yesus Wa me asii-sege see yoo pakaamaata kaama wodoo too okoo me mikee, kuwa Wa kaa yaebeamaata menaa yuwa mée me kisee yaukuwamea ii see kuwa nekeendaa seta. ");
INSERT INTO auu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesus me Lazarus mee ogo maata yoo kaama awee da kaa meanii see aseta kaama wa bootaa da aya andoo peeyaami naagoo deeta bagee yuwa me kuwa menaa weganaa segeekea. ");
INSERT INTO auu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mée eebaa kuwa Yesus me kisee dimi nagii-nagii agiyoo ukuwapi nao see menaa yeeta kaama Waa pe-diino see naadi peegea. ");
INSERT INTO auu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mée tabaa da Wa paagoo peegea kaboo Parisi kaa bagee yuwa me aawegaa taano, \"Yaai, deeweei, eto ko magaa da kaa bagee uduma Wa sekaataa too peedaakea nao. Inii me okoo taamege-taamege, wasege-wasege see agiyoo ena ma si yaukuwamaayaa\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ebo see naagoo kemaata kuwa Yerusalem magaa kaa Ogatamee ebo ekee, yaapaagee taano see naadi pakagea bagee kuwa noonaa Yunani kaa bagee. ");
INSERT INTO auu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Okoo Pilipus paagoo peegea. Pilipus waa ko Galilea wee kaa Betsaida magaa kaa mée. Wa paagoo peemaata kaama okoo me asiino, \"Ei, neataagi, inii Yesus ma aadee taano see yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kisee asegea naadi Pilipus peedoota Andreas paagoo pe-asigi. Pe-aseta kaama ekea paaya peedoota Yesus paagoo pe-asegea. ");
INSERT INTO auu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus me asiino, \"Eto ko Mée Yogaa mee asii-sege ebo ekee see monaa kaa kega. ");
INSERT INTO auu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Anii esee mikee kisiino ko: Gandum poo keepaa to maga yiba eseanta se booyu ko mee keepaa to ena mee too tuyaa. Kiya mee poo keepaa to booyu ko poo maamaa eebaa daamaa ekadaa siyaa. ");
INSERT INTO auu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Okoo ekaato okoo me gaayaa-gaayaa dimii kuwa too obeewoo, umiwoo taano ou see bagee kuwa usiyaato ko umina bogaatagea. Kiya okoo magaa da kaa umiino, toono begaa kuwa okoo me gaayaa-gaayaa yuwa be kaa ekaato ekegatagaa siwoo see bagee kuwa okoo usiyaato ko daamaa toowoo taatagea, kisee too iminoo miya, iminoo miya. ");
INSERT INTO auu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ni me agiyoo naokagee siyaa bagee yuwa Anii peeyaa taa uduma Ni sekaataa nameeno gaano pedeo. Ni me tuyaa yoo kiyoo Ni me agiyoo naokagee siyaa bagee yuwa miya daamaa epo enaataa niitoopea. Ni me agiyoo naokagee siyaa bagee kuwa Nagamee me ebo ekeasiipi.\" ");
INSERT INTO auu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","\"Eto ko Anii dimi mena esee gaagaa ebo. Anii mapea menaa wegayaa? Neataagi, kuwa yaai-yaai agiyoo nakoo taapea monaa da mee A me Anii daba nadaagimaayaai, see kasiyaa ye? Kiya taa, kuwa agiyoo yuwa naukuwasi naadi Anii meta yoka kuwa kisee se kasiyaa. ");
INSERT INTO auu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Neataagi, A ekaa da asii-sege siyaai\" see asigi. Kisee asigi naadi epoo to wodoo kaama mena wuu ena aseeyamaano ko \"Ni ekaa da asii-sege siyaabuu siwooka, bedaa kisee too asii-sege siyaabuu siwoo taapa\" see aseeyamooki. ");
INSERT INTO auu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kiyoo topea bagee yuwa miya mee mena wuu da yeegea. Okoo me wegaano, \"Keemuu yoka\" see wegagea. Kiya mée noonaa me \"Taa, malaikat bagee me Waa ma eewegagi menaa da kuwa\" see wegagea. ");
INSERT INTO auu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus me okoo asiino, \"Mee mena wuu da mee ko Anii yiino gaano pedeo menaa se kiya ikii yeesea naadi menaa da mee. ");
INSERT INTO auu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Eto ko magaa da kaa mée tomaa wigintagaa siyaa monaa kaa kega. Eto ko magaa da kaa bagee me eboo mee Ni me daba, peedi ekeata abagaapeasiino see monaa kaa kega. ");
INSERT INTO auu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mée me Anii magaa da kaa kaama kisee nayagaataapea kaboo mée se-tomaa, we-tomaa uduma Ni paagoo miyaabuu taapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mee Wa me asigi menaa mee ko Waa kisee piya bokoo to kaa bogaapa see ebea-ebea mee naadi asigi menaa. ");
INSERT INTO auu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kiyoo topea bagee yuwa me asiino, \"Inii me deewoo siyaa menaa yiba mena ena mee ko kisee: 'Ebo Kristus mee iminoo miya, iminoo miya kisee too toogee taapi, se bogaatagi' see menaa ebeamaata yoka A me 'Mée Yogaa mee kisee yagaataano gaano pedeo' see wegage menaa kuwa kaasee menaa? Mée Yogaa mee maamee naa ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesus me asiino, \"Mée paagoo yawogaamaayaa Agoo da mee ikii paagoo eebaa se kiitoowoo taapi. Agoo da mee ikii paagoo daamaa wogaamaayaa kaboo da daamaa peenaa taai. Digiyoo mee ikii kaa miya kitakiiniyaa yoka nekeenii. Digiyoo yiba peenaa see bagee kuwa okoo poono yoo ewo kaa amoka peenaa siyaa. ");
INSERT INTO auu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Agoo da mee ikii paagoo kiituyaa kaboo ikii miya dimi mena awee da kaa toogee see yogaa kesea yoka Agoo da mee mikee nao see gaai\" see asigi. Aseta kaama peedoota mée me se deemaayaa see yoo koogo pe-sekeenigi. ");
INSERT INTO auu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yahudi bagee yuwa Yesus me kisee nanekeensi naadi dimi nagii-nagii agiyoo eebaa deegea kiya Waa mikee nao see dimii mee gaano taa. ");
INSERT INTO auu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Okoo me mikee gaano taa kuwa ko idukaa nabi Yesaya me wegata menaa ena uwa daaga yoo kemaata ukuwaanega, mee ko kisee: \"Tuhan, inii me kadoota menaa kuwa daamaa eewegamaage kiya maamee me mikee nao see gaayaa? Bedaa Tuhan me pesee see agiyoo kuwa maamee me daamaa deeyaa naa ya?\" see wegata. ");
INSERT INTO auu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kisee menaa wegawoo seta kemaata kuwa bagee yuwa me Yesus mikee nao see dimii mee iyo. Mikee, nabi Yesaya me okoo kaa yawegata menaa ena ma kisee: ");
INSERT INTO auu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","\"Wa me okoo emaa diino naka see bagee yakiyaata, okoo dimi menaa da miya eboo yakiyaata. Kuwa ko okoo emaa me se deesi naadi, dimi menaa da me se nekeensi naadi, Ni paagoo se namisi naadi okoo dimi ewo kedaa siyaata. Kisee taa naaki okoo pedeo kiyaabuu see agiyoo yuwa Ani me yataa kiyaayaa\" see wegata. ");
INSERT INTO auu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kuwa nabi Yesaya me menaa kuwa ko wa me idukaa kaama Yesus Waa esee ebo, Waa asii-sege see Mée kaatagi see deeta kaama wegata menaa. ");
INSERT INTO auu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nabi Yesaya me Yahudi bagee yuwa kaa kisee yawegata kiya Yahudi kaa ebo-ebo yuwa miya okoo mée eebaa Waa mikee nao see gaagea. Mikee gaagea kiya kisee awee da kaa se asegea. Parisi kaa bagee me 'Sembahyang ee kaa epo enaataa se naatooi' see nasiipea yaai naadi Yesus mikee nao see kuwa koogo dimi yiba too maageekea. ");
INSERT INTO auu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Okoo mée me naapaagee taano ou dimii mee ebo, Ogatamee me naapaagee taano ou see dimii mee peedi naadi kaama Yesus mikee nao see kuwa awee da kaa mée asiino weda. ");
INSERT INTO auu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesus me ebo menaa kaa wegaano, \"Anii mikee nagaayaa bagee kuwa Ani too se kiya Anii naisiyaata Mée Waa miya mikee gaayaa. ");
INSERT INTO auu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bedaa Anii nadeetaa see bagee kuwa okoo me Anii naisiyaata Mée mee miya deetaa see. ");
INSERT INTO auu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Anii magaa da kaa meta mee ko Anii mikee nagaayaa bagee kuwa uduma digiyoo yiba se toogee seta okoo paagoo agoo da daamaa yawogaamagaano see naadi meta. ");
INSERT INTO auu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ni me wegayaa menaa yuwa yeegea kiya daamaa se peneasiyaa bagee kuwa Ani me okoo si yawigintaayaa. Anii magaa da kaa bagee yuwa wigintaata kaama pedeo kiyaano see naadi meta se kiya okoo daba daagimaa peeyaano see naadi meta. ");
INSERT INTO auu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Anii miya nawisintaa, Ni me menaa miya se namasetaa see bagee kuwa wa too wigintagaatagea. Mikee, wodopasi naagoo okoo wigintaata pedeo kiyaasi naadi yawegaano menaa kuwa ko eto Ni me okoo paagoo eewegawooka menaa kuwa too kaata. ");
INSERT INTO auu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ni me eewegageeka menaa kuwa ko Ni me too wegataa see menaa se kiya Nagamee, Anii naisiyaata Mée Wa me 'Kisee naasii, kisee nawegaai' see menaa kuwa Ni paagoo daamaa nase-manee naadi kaama yaweganaa segeeka. ");
INSERT INTO auu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wa me nase-manee see menaa kuwa ko mée kisee too iminoo miya, iminoo miya tuyaabuu siwoo siyaa menaa, see kuwa Anii ipi. Kisee kemaata Ni me yawegayaa menaa kuwa Nagamee me nasegeeki doodoo too yawegageeka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paskah naano taa kaboo Yesus Waa magaa da kaa omegee, toogee seta yuwa kuwa sikii, bedaa Nagamee paagoo metaki pakaano monaa kaa kaano see koo taaka yoka, see kuwa Waa ipi. Waa magaa da kaa bagee paagoo omegee, toogee seta yuwa uduma Wa me bagee yuwa epa gaawoo see too, kisee too wodopasi. ");
INSERT INTO auu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Daatooyiba yaato Wa me topenaa see bagee yuwa naano agiyoo notaakea. Yudas Iskariot mee, Simon see mée to me yogaa mee Iblis me Yesus mee yaekegatagaano dimii mee daa-maneegi. ");
INSERT INTO auu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus Waa Nagamee me se-agiyoo, we-agiyoo, se-pesee, we-pesee uduma Ni kaa naekeata ii see kuwa Waa ipi, bedaa Anii Ogatamee paagoo kaama eseemaata bedaa Wa paagoo pakaapa, see kuwa miya Waa ipi. ");
INSERT INTO auu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Waa kisee ipi kemaata okoo me naano agiyoo notaakea yoo kaama yiinaageeta Wa me togoo dokaa da beamaata eke, peedi dokaa ena masegeeta yupigapii da taa baametayu. ");
INSERT INTO auu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Uwo wugigeeta kaama otaawee yiba kabageamoo naadi Wa me topenaa see bagee ena-ena okoo me badoo yuwa daamaa yawetogetaa, Wa me yupigapii da taa baametaata dokaa peedii to me daamaa yawonakomeeki. ");
INSERT INTO auu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kisee okoo me badoo yuwa kaa uwo yawetogedoota Simon Petrus totaaki yoo peemaayaa naaki \"Yaai, Tuhan, A me ni me badoo yuwa uwo nawetogeanake ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus me asiino, \"Ani me kaukuwataaka agiyoo mee eto kiipaa aa se nanekeenege, epeekaa too aa daamaa nanekeeniipe\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus me asiino, \"A me ni me badoo yuwa kaa uwo peenaa ma se kawetogiyaapa\" see asigi. Yesus me asiino, \"Anii uwo se kawetogiyu ko aa Ni yaato bagee see taa kiyaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petrus me asiino, \"Tuhan, kisee gaayu ko ni me badoo yuwa kuwa too se kiya ni me yagaa yuwa ma, ni me mumoo to ma kuwa miya daamaa uwo nawetogeai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus me asiino, \"Maa to mee uwo daamaa wetogemaata kaama peena-paana naadi badoo da kuwa too uwo wetogiyaa, maa to wiyaagoo to ma uwo se wetogiyaa. Mee mokoo miya ikii daamaa kiwetogemaata kaama pedeo taa, daamaa topea kiya ikii uduma kisee se\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Waa yaekegatagaapi mée to Wa me ipi kemaata \"Ikii pedeo taa see kuwa uduma se\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Okoo me badoo yuwa yawetogemaata kaama bedaa Wa me togoo dokaa da maataata kaama naano agiyoo notaakea yoo Wa me komoo da kaa animaayu. Wa me asiino, \"Ani me kikoo sepa agiyoo mee ikii nekeenegea ye? ");
INSERT INTO auu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Anii daamaa kisi-maniinaka, mee ko ikii me Anii 'Guru' see ekaa naweetaa, 'Tuhan' see ekaa miya nasetaa. Anii mikee kisee Mée yoka kisee ekaa nasiino miya daamaa. ");
INSERT INTO auu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anii ko ikii me Tuhan, Anii ikii me Guru maa diya ikii me badoo yuwa kisee uwo kiwetogepa. Kisee kemaata ikii miya ikii me badoo yuwa daamaa aawetogee siwoo taano gaano pedeo. ");
INSERT INTO auu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ni me daamaa kikoo sepa agiyoo mee see see ikii me miya daamaa aaukuwagee siwoosea naadi kideeyaaga. ");
INSERT INTO auu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Anii esee mikee kisiino ko: Agiyoo yaokagee see mée waa ko ebo, wa me eboo mee peedi see kuwa taa. Bedaa mena yadoonaa see mée waa ko ebo, waa peeyaagi mée mee peedi see kuwa miya taa. ");
INSERT INTO auu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kuwa uduma ikii nekeenta kaama daamaa aaukuwagee siyu ko ikii ede ma, ede ma umiwoo, toowoo taapea. ");
INSERT INTO auu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kuwa Ni me kisega menaa kuwa Anii ikii uduma kisega se. Ikii mée ena-ena Anii kinekeenta kaama kiwiginema kiya Ogatamee me kapogee kaa menaa ikii mée ena kaa uwa daasi naadi Anii waa miya wiginema. Mee menaa mee ko kisee: 'Anii ma enaataa roti naanotaa see mée wa me Anii nawisintaagi' see ebeamaata menaa mee. ");
INSERT INTO auu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kuwa menaa ukuwaaniino taa kaa kisega. Kuwa menaa ukuwaaniipa kaboo Ani me 'Anii kisee Mée, kisee Mée' see kisegeeka menaa kuwa ikii me mikee nao see nagaasea naadi eto kiipaa kiiwegaga. ");
INSERT INTO auu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Anii esee mikee kisiino ko: Ni me menaa nadoonaasi naadi peeyaata bagee kuwa daamaa badaa maayaa bagee Anii miya badaa namaayaa mokoo. Bedaa Anii miya daamaa badaa namaayaa bagee kuwa Anii naisiyaata Mée Waa miya daamaa badaa maayaa mokoo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus kuwa menaa asemaata kaama dimi gaagaa ebo. Waa dimi awee da kaa ekegataata kaama asiino, \"Anii esee mikee kisiino ko: Ikii mée ena me Anii naekegatagaapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wa me topenaa see bagee yuwa me emaa aawoge-woge naadi 'Maamee naa ya? Maamee naa ya?' see dimii gaagea. ");
INSERT INTO auu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wa me topenaa see bagee ena, Yesus me esee epa see mée to waa Yesus geboo da kaa dagi yagaa yaato animaata totaaki. ");
INSERT INTO auu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petrus me Yesus me mee wegapi mée to mee maamee naa ya, see kuwa Yesus paagoo naase-maneesi naadi mumoo to me pe-omeetaagi. ");
INSERT INTO auu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mee Yesus me esee epa see mée to Yesus kaa pe-gebaanta kaama asiino, \"Tuhan, mee maamee naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus me asiino, \"Anii mee roti ponee to mee otaawee yiba tokoata kaama maniipa mée to mee\" see asigi. Aseta kaama roti ponee to otaawee yiba tokoata kaama Yudas Iskariot goo-maneegi. ");
INSERT INTO auu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Roti ponee to masegeegi, gaayaa naaki taka ena Iblis wa yiba seemigi. Yesus me Yudas asiino, \"A me ukuwaano see kooke agiyoo mee mani pe-ukuwaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wa me Yudas asigi menaa mee Waa ma enaataa animaata agiyoo notaakea bagee apa yuwa me 'Kaasee menaa wegagi naa ya?' see kuwa okoo nekeeniino taa. ");
INSERT INTO auu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas waa ko okoo me kepe ayaabu eedoonaa see mée yoka okoo noonaa me gaano, 'Yesus me wa paagoo \"Paskah kaa agiyoo mée eeedaagii\" see asigi yee, \"Daba bagee paagoo kepe aii manii\" see asigi yee' see dimii gaagea. ");
INSERT INTO auu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas mee roti ponee to masegeeta kaama kisee ki peegi. Kuwa kaboo da digiyoo takiinta daatooyiba yaato. ");
INSERT INTO auu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas pe-seomigi kaboo Yesus me asiino, \"Eto ko Mée Yogaa mee Waa ebo, Waa asii-sege see kuwa mée me diipea, bedaa Waa doodoo Ogatamee mee ebo, Waa asii-sege see kuwa miya diipea. ");
INSERT INTO auu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Waa doodoo Ogatamee mee ebo, Waa asii-sege, kisee Wa me deeyaabuu siyu ko Ogatamee me miya Mée Yogaa mee ebo, Waa asii-sege, kisee deeyaabuu taapi, kisee mani-mani mée paagoo deeyaabuu taapi. ");
INSERT INTO auu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ni me yogaa yuwa, wae. Anii ikii paagoo eebaa se kiiumiipa. Ikii me Anii naabanaa taapea kiya Ani me kuwa Yahudi bagee yuwa asema menaa kuwa bedaa eto kiipaa ikii miya kisiinaka, mee ko: 'Anii poota yoo ikii miya meeno iyo' see menaa mee. ");
INSERT INTO auu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Eto ko Anii gipii see menaa ena kisi-maniinaka, mee ko: Ikii epa aagaa taai. Ani me ikii epa kigaawooka see see ikii epa aagaa taano gaano pedeo. ");
INSERT INTO auu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kisee ikii daamaa epa aagaa siyu ko ikii 'Mikee, Wa me topenaa see bagee yuwa ii' see kuwa mée uduma me daamaa kinekeeniipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus me asiino, \"Tuhan, Aa kayoo poope?\" asigi naaki Yesus me asiino, \"Anii poopa yoo aa eto kiipaa se naobeemaayaa kiya aa epeekaa too Anii naobeatage\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus me asiino, \"Tuhan, anii eto kiipaa aa se kaobeemaayaa see kuwa kaasee kaa ya? Anii ekaato ekegataata A kaa kabooyaa yoka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus me asiino, \"A me Ni kaa nabogaano dimii mee aa mikee agoo ye? Anii esee mikee kasiino ko: Wudikaa aa kaagaa wedo mée paagoo ewo poga-poga nataape. A me kisee naekeata kaama ayam ena menaa taapi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus me asiino, \"Ikii dimi se gaagaa taai, Ogatamee kaa dimi magaai, Ni kaa miya dimi namagaai. ");
INSERT INTO auu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Neataagi me ee kaa kiyoo umiwoo, toowoo taano yoo maamaa eebaa. Anii ikii me umiwoo, toowoo taano yoo kuwa kiipiipii taano see naadi poopa. Kisee taa naaki Anii kuwa menaa se kisiyaa. ");
INSERT INTO auu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Anii peemaata kaama ikii me umiwoo, toowoo taano yoo kiipiipii semaata kaama epeekaa bedaa metaki kimeeta. Ni me toogee yoo kiyoo ikii miya Anii ma epo enaataa niiumiwoo, toowoosea naadi badaa kimaagiita. ");
INSERT INTO auu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ani me poopa etaa da mee ikii miya ipi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas me asiino, \"Tuhan, A me poope yoo inii ewo yoka A me poope etaa da mee inii kaasee ipi kiyaa?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus me asiino, \"Anii ko etaa da ma, mikee menaa ma, mée aya tuyaabuu siyaa menaa ma kuwa epoo Mée. Anii doodoo too Nagamee paagoo peemaayaa, apanaa etaa ena taa se peemaayaa. ");
INSERT INTO auu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ikii me Anii esee naipi kegea naaki Neataagi miya ipi kiyaa. Eto kaama wodoo ikii Waa ipi see bagee, eto ikii Waa daamaa deegea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipus me asiino, \"Ei, Tuhan. Nagamee mee inii daamaa mée deeyaai, mee kaama too sikii, ede kaape\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesus me asiino, \"Anii ikii paagoo maamaa eebaa kiiomegee, toogee sepa kiya Pilipus a me Anii naewo kege ye? Anii nadeetaa see kiyu ko Nagamee miya deetaa see yoka A me 'Nagamee mee daamaa mée deeyaai' see kuwa kaasee menaa nasege naa ya? ");
INSERT INTO auu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Anii Nagamee yiba miya eetotaa, bedaa Nagamee Ani yiba miya naatotaa see kuwa a me mikee nagaano dimii mee taa ye? Ni me kiiwegataa see menaa kuwa Ni me menaa too se kiya Nagamee Waa Ani yiba naatotaa see kemaata Wa me agiyoo Anii yaukuwaaniyaabuu see. ");
INSERT INTO auu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Anii Nagamee yiba eetotaa, bedaa Waa Ani yiba naatotaa see kuwa ikii mikee nao see nagaai. Ikii kisee mikee see nagaano kana kiyu ko Wa me agiyoo yuwa Ani me daamaa yaukuwanaa segeeka kuwa me Aa mikee nao see nagaai. ");
INSERT INTO auu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Anii esee mikee kisiino ko: Anii mikee nagaayaa bagee kuwa Ani me ukuwagee see agiyoo yuwa okoo miya ukuwaapea. Bedaa kuwa too se kiya Anii Nagamee paagoo poopa yoka okoo me kuwa asii esee ebo agiyoo miya ukuwaapea. ");
INSERT INTO auu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Anii Wa paagoo peemaata kaama ikii me Ni ekaa yiba naidimiyaa agiyoo uduma kiukuwaapa. Yogamee me Nagamee Waa ebo, Waa asii-sege see kuwa deeyaano see naadi kiukuwaapa. ");
INSERT INTO auu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ikii me Ani ekaa yiba naidimiyaa agiyoo kuwa uduma kiukuwaapa.\" ");
INSERT INTO auu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","\"Ikii me Anii naepa kiyu ko Ni me kisiyaa menaa yuwa ikii me daamaa peneata nadeewoo taapea. ");
INSERT INTO auu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Anii Nagamee paagoo mée ma tabogetaa see Mée apanaa ena manii see kiidimeta kaama ikii kiniitagi. Waa ikii ma epo enaataa iminoo miya, iminoo miya kisee too kiiomegee, toogeesi naadi kiniitagi, ");
INSERT INTO auu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","mee ko mikee menaa yawegataa see Mée Roh mee. Magaa da kaa iyee-payee agoo see bagee okoo me Waa se deemaayaa, Waa ewo see bagee yuwa yoka okoo me Waa masiino naka. Kiya ikii gaayu ko Waa ikii ma epo enaataa kiitotaa see, bedaa kisee too ikii yiba kiitoogee siwoo taapi yoka ikii Waa ipi kegea. ");
INSERT INTO auu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Anii ikii dimmee yogaa mokoo se kiekeasiipa, Anii bedaa ikii paagoo metaki kimeepa. ");
INSERT INTO auu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Eebaa umiino taa kaa magaa da kaa bagee yuwa me Anii se nadiipea kiya ikii me bedaa nadiipea. Anii bedaa aya toopa kemaata ikii miya kisee too toowoo taatagea. ");
INSERT INTO auu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ikii me Anii nadiipea naagoo Anii Neataagi yiba totaaki ii see kuwa nanekeeniipea, bedaa ikii Ani yiba miya niitotaa, bedaa Anii miya ikii yiba kiitotaa siyaa ii see kuwa ikii daamaa nekeeniipea. ");
INSERT INTO auu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ni me asiyaa menaa daamaa peneata naukuwawoo siyaa bagee kuwa ko Anii naepa see bagee yuwa. Anii naepa see bagee kuwa Neataagi me daamaa epa kaapi, bedaa Anii miya okoo epa kaapa, Anii ekaato okoo paagoo daamaa deeyaabuu taapa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudas mee, Yudas Iskariot mee se kiya Yudas ena mee me asiino, \"Tuhan, A me Aa ekaato inii paagoo too mée deeyaabuu taape kiya magaa da kaa bagee apanaa yuwa paagoo se deeyaabuu taape see kuwa kaasee kaa naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus me asiino, \"Anii naepa kiyaa bagee yuwa Ni me asiyaa menaa yuwa daamaa peneata naukuwawoo taapea. Neataagi me okoo epa kaapi, bedaa Waa ma Enaa okoo paagoo meepe, epo enaataa daamaa eeomegee, toogee taape. ");
INSERT INTO auu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Anii se naepa kiyaa bagee kuwa Ni me menaa se peneasiyaa. Ikii me nayeeyaa menaa kuwa Ni me menaa too se kiya Anii naisiyaata Mée Nagamee Wa me menaa yuwa. ");
INSERT INTO auu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kuwa menaa kuwa Anii eto ikii ma epo enaataa kiiomegee, toogeeka too kiiwegaga. ");
INSERT INTO auu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kiya Roh Kudus mee, mée ma tabogetaa see Mée mee Nagamee me Ni ekaa yiba Waa ikii paagoo 'Pooi' see asiitagi. Roh Wa me menaa kuwa uduma ikii daamaa kitupiwoo taatagi, bedaa Ani me kiiwegawoo segeeka menaa yuwa uduma miya Wa me daamaa kinekeeniyaabuu taatagi. ");
INSERT INTO auu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ikii koogo adumeta dimii mee Anii ikii paagoo kiekeasega, Ni me adumeta dimii mee ikii kineega. Ni me kineega dimii mee ena, magaa da kaa bagee me aamanee siyaa mokoo see see se. Ikii dimi se gaagaa taai, ikii se wedaai. ");
INSERT INTO auu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ni me kiiwegapa menaa ena mee ko kisee: 'Anii poonaka, bedaa ikii paagoo metaki kimeepa' see menaa mee ikii me nayeegea. Anii Nagamee paagoo poonaka. Waa ko Ani asii eboo see Mée yoka ikii me Anii naepa kegea naaki Anii Wa paagoo poonaka see menaa mee kaa ikii ede ma, ede ma siyaa. ");
INSERT INTO auu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kuwa kisega menaa kuwa uduma ukuwaandaa semaata kaama ikii me mikee nao see nagaasea naadi Anii kuwa menaa eto ukuwaaniino taa kaa kisega. ");
INSERT INTO auu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eto ko magaa da kaa bagee me eboo mee migi yoka mena eebaa se kiiwegaapa. Waa peedi, pesee taa, nasiyaa menaa ena ma taa. ");
INSERT INTO auu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ani me Nagamee esee epa ii see kuwa magaa da kaa bagee me nagaasi naadi Anii Nagamee me nasiyaa menaa uduma daamaa yaukuwanaa segeeka. Eto ko anoogeeta poono\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus me wegaano, \"Anii ko mikee see anggur poo onee da, bedaa Neataagi Waa bugi yaataa see Mée. ");
INSERT INTO auu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ani kaa takumiyaa kagoo kuwa poo se ekayaa yuwa kuwa Wa me daapii siyaa. Poo ekayaa see kagoo yuwa kuwa poo bedaa maamaa eebaa ekadaasi naadi pedeo kiyaa yuwa maseepii siyaa. ");
INSERT INTO auu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ikii gaayu ko Ani me kiiwegataa see menaa kuwa me ikii me pedeo kiyaa yuwa kimaseepeasega. ");
INSERT INTO auu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ikii Anii ma dimii menaa kaa aagadi-maagadi naadi niitoowoo taai, bedaa Anii miya ikii ma dimi aagadi-maagadi naadi kiitoowoo taapa. Kagoo da mee onee da kaa takuuniino taa see gaayu ko wa too poo se ekayaa, daamaa takuunta kagoo da gaayu too poo daamaa ekadaa siyaa. Mee mokoo miya ikii Anii ma dimii menaa kaa aagadi-maagadi naadi se niitoogee siyu ko ikii daamaa poo ena ma se ekayaayaa. ");
INSERT INTO auu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Anii ko anggur poo onee da, ikii ko kago yuwa. Okoo Anii ma dimii menaa kaa aagadi-maagadi naadi niitoogee, bedaa Anii okoo ma dimi aagadi-maagadi naadi eetoogee, kisee aatoo siwoo see bagee kuwa daamaa poo maamaa eebaa ekadaa siyaa. Ikii Anii ma enaataa taa kiyu ko agiyoo ena ma se ukuwamaayaa. ");
INSERT INTO auu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Okoo Ni kaa se takuuniyaa bagee kuwa okoo poo se ekayaa kagoo yuwa mokoo yoka tameepii naadi wii keepeasiyaa. Kisee kagoo kuwa kutumeeii naadi biyaa yiba tameeyamaata poonooga siyaa. ");
INSERT INTO auu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ikii Anii ma dimi aagadi-maagadi naadi kaama niitoogee, bedaa Ni me menaa ikii yiba daamaa kiitoogee, kisee omegee, toogee siyu ko ikii me Nagamee paagoo idimiyaa yuwa uduma daamaa kiukuwaaniyaapi. ");
INSERT INTO auu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ikii poo maamaa eebaa daamaa ekadaa siwoo naadi kaama Neataagi mee ebo ekeasiipea, bedaa mée me ikii 'Mikee Wa me topenaa see bagee yuwa ii' see kuwa kidiipea. ");
INSERT INTO auu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nagamee me Anii naepa kegeeki see see Ani me miya kisee ikii kiepa kegeeka. Eto ko Ni me epaa mee ma omegee, toogee taai. ");
INSERT INTO auu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Neataagi me nasegee see menaa yuwa Anii daamaa peneata yaukuwageeka kemaata Anii Wa me epaa mee ma daamaa omegee, toogeeka. Mee mokoo miya ikii Ni me kisiyaa menaa yuwa daamaa peneata naukuwagee siyu ko ikii Ni me epaa mee ma daamaa omegee, toogee taapea. ");
INSERT INTO auu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Anii kuwa menaa kisega kuwa ko Ni me ede ma, ede ma see dimii mee ikii yiba miya agoo kesea naadi kisega, bedaa ikii me ede ma, ede ma dimii mee maamaa eebaa kedaa siwoosea naadi kisega. ");
INSERT INTO auu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ni me kisiyaa mena ena mee ko kisee: Ani me epa kigaataa see mokoo ikii miya epa aagaa taai. ");
INSERT INTO auu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Esee epa kaano mee ko mée ena wa me epa see bagee yuwa kaa yabogaano see naadi waa ekaato ekegatagaakee mee. Epa kaano mee asii epaa mee ena ma taa. ");
INSERT INTO auu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ikii Ni me kisiyaa menaa yuwa daamaa naukuwagee siyu ko ikii mikee Ni me epa see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ikii ko Ni me agiyoo naokagee see bagee yuwa see ekaa mee eto kaama wodoo Anii kisee ekaa se kiweapa. Agiyoo yaokagee see bagee gaayu ko ebo bagee me ukuwayaa, peeyaa yuwa kuwa ewo. Kiya ikii ko kisee ewo see bagee mokoo taa. Anii Neataagi me menaa uduma yayeeta kaama ikii paagoo daamaa keipi kiyaabuu segeeka yoka ikii naipi see bagee yuwa. Kisee kemaata ikii ko Ni me epa see bagee yuwa see ekaa mee too Anii kiweega. ");
INSERT INTO auu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ani me ikii kiwiginema, ikii me Anii nawiginemea se. Anii kiwiginta kaama ikii daamaa poo pe-ekayaabuusea naadi kisega. Kuwa poo kuwa se taa kaapa, kisee too daamaa toowoo taapa. Ikii kisee poo kuwa daamaa ekawoo, toowoo naadi kaama ikii me Nagamee paagoo Ni ekaa yiba idimiyaa yuwa uduma kiniipi. ");
INSERT INTO auu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ani me kisega menaa mee ko kisee: Ikii epa aagaa taai see mee.\" ");
INSERT INTO auu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","\"Magaa da kaa mée tomaa-tomaa okoo me ikii kibe kegea gaayu ko Ani keta nabe kemea see kuwa ikii daamaa nekeenii. ");
INSERT INTO auu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ikii ko magaa da kaa mée tomaa-tomaa okoo me iyee-payee kaa bagee naaki okoo me ikii inii see see bagee yoka naadi ikii daamaa kiepa kiyaa. Kiya ikii magaa da kaa mée tomaa okoo me iyee-payee kaa bagee yuwa se. Anii ikii Ni yaato kiwiginegeema kemaata okoo me ikii kibe kegea. ");
INSERT INTO auu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ani me kisema menaa ena mee daamaa neke-nekee taai, mee ko kisee: Agiyoo yaokagee see mée waa ko ebo, wa me eboo mee peedi see kuwa taa. Mee mokoo miya magaa da kaa bagee me Anii nawegee-wegee siyaa bagee kuwa ikii miya kiwegee-wegee taapea. Bedaa okoo Ni me menaa yuwa daamaa nayeeyaa bagee kuwa ikii me menaa yuwa miya daamaa kiyiipea. ");
INSERT INTO auu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kiya Anii naisiyaata Mée mee okoo ewo, bedaa ikii Ni yaato bagee kemaata kibe kaa kiwegee-wegee taapea. ");
INSERT INTO auu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Anii okoo paagoo mena pe-eewegaano taa naaki okoo kaa pedeo menaa taa kiyaa. Kiya Anii okoo paagoo daamaa eeweganaa sepa menaa kuwa okoo me nayiino be kiwookea kemaata eto ko okoo kaa pedeo menaa agoo. Okoo me 'Wa me menaa kuwa naawegami naaki ni me pedeo yuwa ekeasiyaa' see menaa kuwa asiino yaato iyo. ");
INSERT INTO auu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Anii nabe kiyaa bagee kuwa Neataagi mee miya be kiyaa. ");
INSERT INTO auu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Anii okoo paagoo ukuwagee sepa agiyoo kuwa wa too, mée me peenaa ma ukuwaano taa see agiyoo yuwa kiya okoo me kuwa agiyoo nadeeta kaama Anii miya nabe, Neataagi miya be kegea. Anii okoo paagoo kisee agiyoo ukuwaaniyaano taa naaki okoo kaa pedeo menaa taa kiyaa. ");
INSERT INTO auu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kiya okoo me deewoo siyaa menaa kuwa kaa ebeamaata menaa ena uwa daasi naadi ukuwaanega, mee ko kisee: 'Anii pedeo see agiyoo kuwa ukuwaano taa kiya okoo aii kisee nabe kegea' see ebeamaata menaa mee. ");
INSERT INTO auu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Epeekaa Roh mee, mée ma tabogetaa see Mée mee Anii Waa ikii paagoo 'Pooi' see kiasiita. Waa ko Nagamee paagoo kaama mikee menaa esee-yawegataa see Mée. Waa Nagamee paagoo kaama esedoota ikii paagoo eseemaata kaama Ni kaa menaa yuwa daamaa nawegaatagi, ");
INSERT INTO auu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","bedaa ikii me miya kuwa menaa naweganaa taatagea. Ikii idukaa petamanii kaama eto too kuwa Ni paagoo too niitoogee see bagee yuwa yoka kuwa menaa naweganaa taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","\"Anii kuwa kiiwegaga menaa kuwa uduma ikii se naekeata dimi mena makii taa see kaa toowoosea naadi kiiwegaga. ");
INSERT INTO auu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Epeekaa mée me 'Ikii sembahyang segee see ee kaa inii ma epo enaataa se niitota pooi' see kisiitagea, bedaa ikii miya kiwugiitagea kaata. Okoo me ikii kiwugimaata kaama 'Daamaa, Ogatamee me ede kisi naadi yaukuwayaa agiyoo yoka' see gaatagea. ");
INSERT INTO auu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Okoo Nagamee miya ewo, Anii miya naewo see kemaata kuwa agiyoo yuwa kiukuwaatagea. ");
INSERT INTO auu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Epeekaa okoo me kisee agiyoo kiukuwaatagea kaboo ikii me 'Mikee, kisee kiukuwaatagea see mée eewegami menaa mee ii' see kuwa ikii me nekeensea naadi eto kisega.\" \"Anii petamanii kaama ikii ma kiitoogeeka yoka kuwa mée me kisee kiukuwaatagea see menaa kuwa Anii kisi-maniino taa. ");
INSERT INTO auu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kiya eto ko Anii naisiyaata Mée paagoo poopa. Anii kisee kisega kiya ikii me 'Aa kayoo poope naa ya?' see nasiino bagee taa. ");
INSERT INTO auu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ani me kuwa kisega menaa kuwa me ikii dimi boodi gaagaa ebo kegea. ");
INSERT INTO auu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kiya Anii esee mikee kisiino ko: Anii poono mee daamaa. Kisee Anii se peeyu ko mée ma tabogetaa see Mée Roh mee ikii paagoo se meetagi. Anii peeyu too Waa ikii paagoo pooi see kiasiita. ");
INSERT INTO auu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Waa meemaata kaama mée tomaa-tomaa yuwa okoo kisee pedeo yago bagee yuwa ii see menaa kuwa Wa me awee da kaa yakiyaatagi. Bedaa Anii dimi topoo too see Mée ii see menaa kuwa miya mée paagoo awee da kaa naipi kiyaatagi. Bedaa Ogatamee me mée tomaa wigintagaa siyaa menaa kuwa miya Roh me awee da kaa yakiyaatagi. ");
INSERT INTO auu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kuwa ko magaa da kaa bagee okoo me Anii mikee nao see dimii nagaano taa kemaata okoo pedeo yago bagee yuwa ii see kuwa Wa me awee da kaa yakiyaatagi. ");
INSERT INTO auu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bedaa Anii Nagamee paagoo poopa kemaata Anii topoo too see Mée ii see kuwa Wa me mée paagoo awee da kaa naipi kiyaatagi. Anii Wa paagoo peemaata kaama wodoo ikii me se nadiitagea. ");
INSERT INTO auu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bedaa magaa da kaa bagee okoo me eboo mee Ogatamee me wigintaata pedeo kiyaagi kemaata Wa me mée tomaa miya kisee wigintaata ukuwaaniyaatagi ii see kuwa Roh me okoo awee da kaa ipi kiyaabuu taatagi, see kuwa. ");
INSERT INTO auu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Anii apanaa menaa maamaa eebaa kiiwegaano dimii agoo kiya eto kiipaa ikii masemagaano kana kegea. ");
INSERT INTO auu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kiya epeekaa mikee menaa yawegataa see Mée Roh mee meemaata kaama ikii mikee menaa uduma ipi see etaawee kiipootagi. Wa me dimi kaa menaa too kiiwegaatagi se kiya Wa me yeetaa see menaa kuwa too ikii kiiwegaatagi, epeekaa ukuwaandaa taata agiyoo kuwa miya daamaa kisi-manee taatagi. ");
INSERT INTO auu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wa me Anii ebo, Anii asii-sege nasiyaano see naadi Ni me menaa kuwa yeedoota kaama ikii paagoo kisi-manee taatagi. ");
INSERT INTO auu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nagamee me agiyoo kuwa uduma Anii miya epoo Mée kemaata Ni me menaa kuwa Roh me yeeta kaama kisi-manee taatagi see kisega.\" ");
INSERT INTO auu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","\"Peenaa eebaa toono taa kaboo ikii me Anii se nadiipea kiya bedaa wiyaagoo eebaa umiino taa kaboo Anii nadiipea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wa me topenaa see bagee noonaa me aawegaa taano, \"Kuwa kaasee menaa? Wa me 'Peenaa eebaa toono taa kaboo ikii me Anii se nadiipea kiya bedaa wiyaagoo eebaa umiino taa kaboo Anii nadiipea' see menaa mee ma, bedaa Wa me 'Anii Nagamee paagoo poono see yoka' see menaa mee miya kaasee menaa?\" see aawegaakea. ");
INSERT INTO auu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bedaa okoo me \"Wa me 'Eebaa toono taa kaboo' see mee kaasee menaa? Inii Wa me mée eewegagi menaa kuwa nekeeniino kana\" see aaseekea. ");
INSERT INTO auu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus me okoo kuwa menaa kuwa kaasee naadi nasedee taanakea see kuwa Waa nekeenta kaama okoo asiino, \"Ani me 'Peenaa eebaa toono taa kaboo ikii me Anii se nadiipea kiya bedaa wiyaagoo eebaa umiino taa kaboo Anii nadiipea' see kisega menaa mee ikii me kaasee menaa naadi kaama aawegaakea ye? ");
INSERT INTO auu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Anii esee mikee kisiino ko: Ikii yege ma, yii-yii ma taatagea kiya magaa da kaa bagee okoo ede ma, ede ma taatagea. Ikii mikee dimi boodi kaatagea kiya ikii me dimi gaagaa taapea kuwa sikiinta kaama wodoo ede ma, ede ma dimii mee ebo kedaa taata. ");
INSERT INTO auu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yoga kabayaa kuwa ko yoga kabaano see kaboo apii to boodi ebo abaayaa. Kiya yoga kabamaata kaama wodoo wa me boodi abaapa dimii mee ekeata yogaa to daamaa kabamaaga nao naadi ede ma, ede ma siyaa. ");
INSERT INTO auu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mee mokoo miya eto kiipaa ikii dimi boodi gaagaa taakea kiya Anii bedaa ikii kidiita yoka mee naagoo ikii ede ma, ede ma taatagea. Kuwa ikii me ede ma, ede ma taatagea kuwa mée ena ma se sikiiniyaayaa. ");
INSERT INTO auu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mee naagoo ko ikii me naapaadee see menaa kuwa ena ma taa kaata. Anii esee mikee kisiino ko: Ikii me Ni ekaa yiba Nagamee paagoo idimiyaa yuwa uduma Wa me kiniitagi. ");
INSERT INTO auu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Idukaa kaama eto too ikii Ni ekaa yiba idimaano taa. Ikii me ede see dimii mee esee eebaa kedaasea yoka daamaa idimegee taai, ikii daamaa masiipea. ");
INSERT INTO auu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kuwa menaa kuwa Anii ebea-ebea see menaa kaa kiiwegaga kiya epeekaa kisee taa. Ikii Nagamee daamaa nekeeniino menaa kuwa Anii awee da kaa kisi-manee taapa yoka Anii ebea-ebea menaa kaa se kiiwegaapa. ");
INSERT INTO auu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mee naagoo ikii Ni ekaa yiba idimegee taatagea. Ikii me idimiyaa menaa kuwa Ani me Nagamee paagoo kiasiipa see kisega se. ");
INSERT INTO auu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nagamee Wa me miya ikii esee kiepa kigi yoka se kiasiipa. Ikii me Anii naepa kegea, bedaa Anii mikee Ogatamee paagoo kaama meta ii see kuwa ikii me mikee nagaagea kemaata Wa me kiepa kigi. ");
INSERT INTO auu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Anii Nagamee paagoo kaama magaa da kaa meta, bedaa Anii magaa da kaa kaama Nagamee paagoo poopa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wa me topenaa see bagee yuwa me asiino, \"Eto ko Aa kanekeeniino awee see menaa kaa A me daamaa mée eewegataake, ebea-ebea menaa kaa se. ");
INSERT INTO auu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aa se-menaa, we-menaa kuwa uduma ipi too, bedaa mée me kaapaadee taanakea menaa yuwa kasiino taa kaboo miya A me ipi too see kuwa inii eto kanekeenege. Kuwa me kemaata Aa Ogatamee paagoo kaama meta see kuwa inii mikee nao see kagaage\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus me asiino, \"Ikii eto Anii mikee nagaagea ye? ");
INSERT INTO auu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kiya daamaa yii: Eebaa umiino taa kaa mée me ikii peeda-paada kisiyaapea. Mikee, eebaa umiino taa kaa se kiya eto ukuwaaniinaka. Ikii mée gakata ikii me ee kaa peedaa naadi Ani too naekeasiipea. Kisee naekeasiipea kiya Nagamee Ni paagoo naatupi yoka Ani too toopa se. ");
INSERT INTO auu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ani me kiiwegataaka menaa kuwa ko ikii Anii ma dimi aagadi-maagadi naadi koogo adumeta dimii mee ikii miya masesea naadi kiiwegaga. Ikii magaa da kaa omegee, toogee taapea kaboo yaai-yaai, gaagaa ebo see agiyoo agoo kedaa taapa kiya magaa da kaa se-pesee, we-pesee uduma Ani me daba, peedi yaekeasega yoka se wedaai, dimi pesee kaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus kuwa menaa wegataata kaama epoo to yaato deataata aseta menaa ko \"Neataagi, wae. Eto ko monaa da kaa kega. Aa ebo, Aa asii-sege see kuwa Ayoopaa me mée paagoo daamaa kadeeyaabuusi yoka Ayoopaa mee ebo, Waa asii-sege see kuwa daamaa deeyaabuu taai. ");
INSERT INTO auu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A me Yogamee paagoo manta bagee kuwa uduma Wa me okoo iminoo miya, iminoo miya kisee too tuyaabuu siwoosi naadi A me Yogamee ebo ekeasege, magaa da kaa mée tomaa-tomaa uduma Wa too Ebo Wodoo Eboo see Mée kiyaage. ");
INSERT INTO auu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mée iminoo miya, iminoo miya kisee too toogee siwoo siyaa mee ko kisee: Aa ko mikee A too Eboo Ogatamee mee see kuwa okoo me kaipi, bedaa A me isiyaata Mée Yesus Kristus Waa miya ipi, kisee bagee kuwa kisee too toogee siwoo siyaa. ");
INSERT INTO auu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A me naukuwase naadi naseta menaa kuwa uduma sikii, Anii daamaa kaukuwataaga yoka Aa ebo, Aa asii-sege see kuwa Anii kisee magaa da kaa mée paagoo daamaa kadeeyaabuu senaa segee sepa. ");
INSERT INTO auu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Neataagi, eto ko A me Anii A paagoo ebo naekeasii. Idukaa uwoo to, magaa to uduma ogaatagaano taa miyoo Anii A paagoo kaatoogee naadi kaama Enaa ebo, Enaa asii-sege see kuwa see see bedaa eto miya kisee nakiyaai. ");
INSERT INTO auu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","A me mée tomaa-tomaa yuwa yupii kaama wigintaata neeta bagee kuwa Anii okoo paagoo Aa daamaa kaipi kiyaabuu segee sepa. Okoo A me bagee yuwa, A me okoo kuwa Anii neeta. Okoo A me menaa daamaa peneasegea. ");
INSERT INTO auu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","A me neeta agiyoo kuwa uduma okoo me 'Mikee, Wa paagoo uduma manta ii' see menaa kuwa ipi kegea. ");
INSERT INTO auu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","A me naseta menaa kuwa bedaa Anii okoo miya ase-manee sepa. Kuwa menaa okoo daamaa masemaagea. Okoo me Anii mikee A paagoo kaama meta ii, bedaa A me mikee naisiyaata ii see kuwa miya nanekeenegea. ");
INSERT INTO auu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Anii okoo kaa sembahyang yataaka. Anii magaa da kaa mée tomaa-tomaa uduma kaa sembahyang yataaka se kiya A me neeta bagee kuwa okoo A me bagee yoka okoo kaa too sembahyang yataaka. ");
INSERT INTO auu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Anii nekee kuwa uduma Aa nekee, bedaa Aa nekee kuwa uduma Anii nekee. Kuwa A me neeta bagee yuwa doodoo Anii ebo, Anii asii-sege see kuwa mée deeyaabuu segeekea. ");
INSERT INTO auu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eto ko Anii A paagoo meeno see kooka yoka magaa da kaa se toopa kiya A me neeta bagee kuwa okoo magaa da kaa omegee, toogee taapea. Neataagi, pedeo ena ma taa see Mée, A me pesee see ekaa da mee, A me Anii neeta ekaa da mee me okoo daamaa deewoo taai. Aa ma Enaa ena dimii, ena menaa segee siwoo siyaa see see mokoo okoo miya kisee ena dimii, ena menaa segee siwoosi yoka okoo daamaa deewoo taai. ");
INSERT INTO auu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Anii okoo ma epo eetoogee siyaa kuwa uduma A me Anii neeta ekaa da mee, esee pesee see ekaa mee me Ani me okoo daamaa kadeewoo naadi kaama egata bagee taa, pedeo kaatagi mée wa too. Idukaa ebeamaata menaa ena wa kaa uwa daaga kemaata egagi. ");
INSERT INTO auu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Eto ko Anii A paagoo meeno see kooka. Kuwa wegataaka menaa kuwa Anii magaa da kaa topa kaboo da wegataaka. Ni me ede ma, ede ma see dimii mee okoo yiba miya esee eebaa kedaasi naadi wegaga. ");
INSERT INTO auu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anii A me menaa yuwa okoo manegeeka kemaata magaa da kaa bagee me okoo be kegea. Anii magaa da kaa iyee-payee taa see Mée. Mee mokoo okoo miya magaa da kaa iyee-payee taa see bagee kemaata mée tomaa yuwa me okoo be kegea. ");
INSERT INTO auu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Okoo magaa da kaa kaama badaa maagii see kasega se kiya okoo pedeo yago mée Iblis mee A me yataamegeese naadi kasega. ");
INSERT INTO auu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Anii magaa da kaa iyee-payee taa see Mée. Mee mokoo okoo miya magaa da kaa iyee-payee taa see bagee. ");
INSERT INTO auu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kisee iyee kuwa okoo taa kisi yoka A me mikee menaa too okoo yiba yamaatagaa siwoo naadi okoo daamaa wa too wigintagaai. A me menaa mee ko mikee menaa. ");
INSERT INTO auu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","A me Anii magaa da kaa pooi see naseta see see mokoo Ani me miya okoo kisee magaa da kaa kiyoo-kiyoo pooi see asetaa see. ");
INSERT INTO auu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Okoo miya A paagoo kaekegataata kaama mikee menaa doodoo kuwa pedeo iyee-payee wigintagaa siwoosi naadi Anii miya okoo kaa kisee ekaato A paagoo kaekegataaga. ");
INSERT INTO auu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Anii okoo kaa too sembahyang yataaka se kiya okoo mena weganaa naadi kaama Anii mikee nao see nagaatagea bagee yuwa kaa miya sembahyang yataaka. ");
INSERT INTO auu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Neataagi, Aa miya Ani yiba epo naatoogeeke, bedaa Anii miya A yiba epo kaatoogeeka, kuwa mokoo okoo uduma daamaa ena dimii, ena menaa kaa kisi naadi sembahyang yataaka, bedaa okoo Enaa yiba mée eetoowookea kemaata magaa da kaa bagee me 'Mikee, Ogatamee me Waa isiyaata ii' see kuwa nekeensi naadi Anii okoo kaa miya sembahyang yataaka. ");
INSERT INTO auu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Anii ebo, Anii asii-sege see nadeesi naadi A me kisee naekeata. Mee see see mokoo okoo miya ebo, okoo asii-sege see deesi naadi Ani me okoo kisee yaekeasega. Aa ma Enaa ena dimii, ena menaa kaa too toowoo see mokoo okoo miya ena dimii, ena menaa kaa too toowoosi naadi Anii kisee okoo yaekeasega. ");
INSERT INTO auu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Anii okoo yiba epo eetoogeeka, bedaa Aa miya Ani yiba epo naatoogeeke, kisee too toogee siwoo naadi kaama okoo miya esee mikee ena dimii, ena menaa kaa too kaapea. Kisee okoo ena dimii, ena menaa kaa too toowoo naadi kaama magaa da kaa bagee me 'Mikee, Ogatamee me Waa isiyaata ii' see kuwa nekeeniipea, bedaa A me Anii naepa kegee segeeke mokoo A me bagee kuwa miya A me epa kegee segeeke ii see kuwa miya mée me Aa kanekeeniipea. ");
INSERT INTO auu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Neataagi, wae. A me neeta bagee yuwa okoo Ni me tuyaa yoo okoo miya kiyoo niitoowoo siyaa kuwa Anii ede. Uwoo to, magaa to ogaatagaano taa miyoo A me naepa kaa Anii ebo, Anii asii-sege nakiyaata. Okoo miya kisee nadeesi naadi niitoono kuwa daamaa, ede. ");
INSERT INTO auu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Neataagi, dimi topoo too see Mée wae, magaa da kaa bagee kuwa okoo me Aa kaewo kegea kiya Anii Aa kaipi, bedaa A me neeta bagee yuwa okoo me Anii mikee Ogatamee me Waa isiyaata ii see kuwa miya ipi kegea. ");
INSERT INTO auu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aa kisee ekaa, Aa kisee Mée see kuwa Anii okoo paagoo daamaa ipi kakiyaabuu segeeka, bedaa kisee too kaasegee taapa. A me Anii naepa dimii mee okoo yiba miya toowoo, bedaa Anii okoo yiba epo eetoowoo, kisee kiyaano see naadi Ani me okoo paagoo Aa daamaa ipi kakiyaabuu segee taapa\" see kuwa Wa me okoo kaa sembahyang menaa yuwa. ");
INSERT INTO auu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus me kisee sembahyang semaata Wa me topenaa see bagee yuwa ma epo peedoota Kidron uwoo debaa asii yaato peemaata kaama kiyoo bugi ena agoo naadi kitaa peegea. ");
INSERT INTO auu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mee bugii da kaa kiyoo ko Yesus ma, Wa me topenaa see bagee yuwa ma kaagaa eebaa epo enaataa toogee segee see yoo kemaata Yudas mee, Yesus yaekegatagaapi mée waa miya ipi. ");
INSERT INTO auu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudas waa ipi kemaata mée noonaa kiyoo badaa maadoota eepeegi. Kuwa bagee kuwa ko noonaa Roma kaa okaa yago bagee, noonaa Ogatamee me ee yadiitoo taa see bagee. Okoo ko ebo imam bagee ma, Parisi kaa bagee ma okoo me peeyaagea bagee yuwa. Okoo peto ma, biyaa ma, mée patamaano see naadi agiyoo miya doopea. ");
INSERT INTO auu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus me Wa kaa ukuwaaniipa agiyoo kuwa uduma ipi kemaata peedoota okoo paagoo \"Ikii maamee abanaakea naa ya?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","\"Yesus, Nazaret magaa kaa Mée mee\" see asegea. \"Mee gaayu ko Anii yoka\" see asigi. Yesus yaekegataagi mée Yudas mee okoo ma enaataa tupi. ");
INSERT INTO auu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wa me \"Mee Anii yoka\" see asigi naaki okoo kisee metaki peanta kaama magaa da kaa mogoata eseanegea. ");
INSERT INTO auu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bedaa Yesus me egaa ena ma \"Ikii maamee abanaakea naa ya?\" asigi naaki \"Yesus, Nazaret magaa kaa Mée mee\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus me asiino, \"Mee ko Anii yoka see kisega yoka ikii me Ni too naabanaakea gaayu ko kuwa Nii ma bagee kuwa daba napeeyaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wa me okoo \"Daba napeeyaai\" see asigi menaa mee ko Wa me yumakaa sembahyang kaa asigi menaa ena mee uwa daasi naadi asigi, mee ko \"A me neeta bagee kuwa Ani me kadeewoo naadi egata bagee ena ma taa\" see menaa mee uwa daaga yoo. ");
INSERT INTO auu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kuwa kaboo da Simon Petrus waa pose ena agoo yoka masegeeta mée waa ena kaa dagi yagaa yaato apa kamuu da yadaakomeegi, Ebo Imam wa me agiyoo yaokagee see mée, ekaa da ko Malkus. ");
INSERT INTO auu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesus me Petrus asiino, \"A me posee da doko yiba koogo awetagaai. Nagamee me boodi abaakee uwoo otaawee da neegi mokoo yoka Anii naano, daa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kiyoo kaama kuwa okaa yago bagee tabaa da ma, okoo me eboo ma, bedaa kuwa Yahudi kaa ebo-ebo yuwa me peeyaabuu sepea bagee yuwa ma okoo me Yesus pe-peneata kaama one gadimegea. ");
INSERT INTO auu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","One gadimetaata kaama Anas see mée to wa paagoo keta eepeegea. Anas mee wayoopane Kayapas me goeta. Kayapas waa mee tahun yiba Ebo Imam eetotaaki. ");
INSERT INTO auu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapas mee ko miyoo taa wa me Yahudi kaa ebo-ebo yuwa paagoo gaamaasi naadi menaa ena asimi, mee ko kisee: \"Inii tomaa kaa bagee yuwa uduma kisee mée me pedeo mée kiyaabuu taapea naadi kaama Mée ena too too mée yabogaakee mee too daamaa, koosi\" see asimi mée to mee. ");
INSERT INTO auu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yesus mee Anas paagoo eepeegea kaboo Simon Petrus ma, apanaa topenaa see mée ena ma obeegea. Mee topenaa see mée to mee Ebo Imam me waa ipi kemaata Yesus mee Ebo Imam me ee kiwitaa to yiba eeseemegea kaboo waa miya Yesus ma epo seemigi ");
INSERT INTO auu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kiya Petrus waa yoo da kaa kiwita kenee to kaa totaaki. Mee topenaa see mée ena mee, Ebo Imam me ipi see mée waa bedaa esedoota kiwita kenee to kaa kiyoo yadiitoo taa see apii to paagoo mena yaasigi naaki Petrus miya \"Daamaa meei\" asega naadi badaa maageegi. ");
INSERT INTO auu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Badaa maageegi kaboo mee kiwita kenee to kaa yadiitoo taa see apii to me Petrus asiino, \"Aa miya mee Mée to Wa me topenaa see mée ena, se maa?\" asega naaki \"Taa\" asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kiwita kenee to yiba seemeta kaama agiyoo yaokagee see bagee ma, yadiitoo taa see bagee ma kiyoo yiinaageeta toomuu taakea. Okoo okomoo yuwa moometaata kaama biyaa dee da kaa kiyoo yabi kiitaakea. Petrus waa miya okoo ma enaataa yiinaageeta yabi kiitaaki. ");
INSERT INTO auu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kuwa kaboo da taa ko Ebo Imam me Yesus paagoo A me topenaa see bagee kuwa maamee, maamee, bedaa A me topenaa see menaa kuwa miya kaasee menaa, kaasee menaa, kisee apaadee taaki. ");
INSERT INTO auu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kisee mena apaadee naadi kaama Yesus me asiino, \"Ni me menaa kuwa uduma Ani me mée uduma paagoo awee da kaa eewegageeka. Ogatamee me ee kaa miya, sembahyang segee see ee kaa miya, Yahudi bagee uduma okoo me kutumeeii taa see yoo kiyoo Anii kisee too awee da kaa mée topegee siwooka. Anii mée paagoo kaama boonemaayu see menaa ena ma taa. ");
INSERT INTO auu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","See kemaata aa kaasee kaa kisee menaa kuwa naapaadee taake naa ya? Ni me weganaa seta menaa yeeta bagee kuwa okoo paagoo too apaadee taano, daa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kiyoo yadiitoo taa see bagee ena Yesus geboo da kaa tupi. Yesus kuwa menaa asigi yoka naadi Wa me ebeyumaa da kaa yagaa kopaa tokoata kaama asiino, \"Mee mée mee ko Ebo Imam yoka wa me mena kaapaadeeki naaki A me kisee omaago ma menaa asiyaa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus me waa asiino, \"Anii pedeo menaa ena wegayu ko mee menaa mee pedeo yoka see nasii. Kiya Anii mikee menaa too wegayu ko kaasee kaa yagaa kopaa natokoasege?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kiyoo kaama Anas me Yesus kaa gadimetaata onee da mee si yaekegataata Ebo Imam Kayapas paagoo \"Eepooi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kuwa kaboo da taa Simon Petrus waa biyaa geboo da kaa yiinaageeta yabi kiitaaki. Kiyoo mée waa ena me asiino, \"Aa miya Wa me topenaa see mée ena, se maa?\" asigi naaki \"Taa\" asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kiyoo kaama Ebo Imam me agiyoo yaokagee see mée ena, Petrus wa me apa kamuu da yadaakomeegi mée to mee waa ma ena tomaa see mée to me Petrus asiino, \"Apee yumakaa bugii da kaa aa Waa ma epo toomuu taa sepea see kuwa kadeepa, se maa?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","bedaa wa me \"Taa, kisee anii ewo\" see asigi. Kisee asigi naaki taka ena ayam menaaki. ");
INSERT INTO auu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Esee pedeo komaa da Yesus mee Kayapas me ee kaa kaama badaa maadoota Gubernur me ee kaa eepeegea. Kuwa Yahudi bagee yuwa me apanaa tomaa kaa bagee me ee kaa seemaano ko tuunuu siyaa agiyoo yoka Paskah Naagoo daba naano see naadi okoo Gubernur me ee yiba seemaano taa. ");
INSERT INTO auu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kisee kemaata Pilatus mee peedoota yoo da kaa okoo paagoo asiino, \"Mee Mée mee Wa kaa mapea menaa agoo naadi eemegea naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Okoo me asiino, \"Mee Mée mee Wa kaa pedeo menaa taa naaki a paagoo se kaekeasiyaa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus me asiino, \"Ikii me deewoo siyaa menaa kaa ikii me too hukuman manii\" see asigi kiya Yahudi kaa ebo-ebo yuwa me asiino, \"Inii me kisee mée ena ma wugimagaai see menaa kuwa ikii me inii kaa mée yaekeasiino taa naadi eemege\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kisee asegea naadi Yesus Wa me miyoo taa \"Anii kisee bogaapa, mée me kisee nawugiipea\" see wegami menaa mee uwa daasi naadi asegea menaa. ");
INSERT INTO auu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus mee wa me ee yiba seemeta kaama Yesus mena ugigi. Wa me Yesus asiino, \"Aa ko Yahudi bagee me Eboo ye?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus me asiino, \"A me kisee nanekeenta kaama nasege ye, apanaa bagee me naa kasegea ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus me asiino, \"Anii Yahudi bagee se yoka ewo kaa kasega, se maa? Imam ebo yuwa ma, Aa ma tomaa kaa bagee yuwa apanaa yuwa ma okoo me too ni paagoo Aa kaekegataagea kuwa. Aa maagiyoo ukuwape naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus me asiino, \"Ani me ebo mée eetuyaa mee ko ena, magaa da kaa bagee me ebo tuyaa kuwa see see se. Anii magaa da kaa ebo tookee mée naaki Ni yaato bagee me Ni kaa yape namasiyaa, Anii Yahudi kaa ebo-ebo yuwa paagoo naekegatagaano be kaa kuwa bagee yuwa ma yape eetaa siyaa. Kiya Ni yaato bagee me kisee yape se namasiyaa yoka Ani me ebo mée eetuyaa mee ena\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus me asiino, \"A me wegage menaa kuwa me Aa ebo tookee mée ena ye?\" asigi naaki Yesus me asiino, \"A me 'Aa ko ebo tookee mée' see nasege. Anii mikee menaa daamaa mée paagoo eeweganaa taano see naadi magaa da kaa eseemaata nakabata. Mikee menaa too peneasiyaa bagee kuwa uduma Ni me menaa daamaa nayiino too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus me asiino, \"Mikee menaa mee kaasee menaa naa ya?\" see asigi. Pilatus me kisee aseta kaama waa bedaa peedoota yoo da kaa kuwa Yahudi bagee paagoo asiino, \"Anii Wa kaa pedeo menaa ena ma, ena ma agoo see kuwa yadiino taa. ");
INSERT INTO auu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kiya ikii me too nasii. Mee ko anii tahun gakata Paskah Naagoo digiyoo ee yiba dogeamoo seta bagee mée ena mee daba mée yapeeyaai see nasegeekea. Eto mee tahun yiba ikii Yahudi bagee me Eboo Yesus mee daba kipeeyaa ye?\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","okoo me omaago ma asiino, \"Taa, Waa se. Barabas see mée to mee daba mée yapeeyaai\" see asegea. Barabas mee ko mée me agiyoo oma yamasenaa see mée. ");
INSERT INTO auu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kiyoo kaama Pilatus me Yesus pepeaduu me dakameamoosi naadi yaekeasigi. ");
INSERT INTO auu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Dakameamoo semaata okaa yago bagee me takuu yago onee ena bakane yaidimitaata kaama mumoo to kaa yamaataagea, dadi poo epoo da see see dokaa ena miya Wa kaa yamaataagea. ");
INSERT INTO auu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kuwa agiyoo yuwa yaukuwamaata kaama Wa ikigii to kaa wisineekee kaa asiino, \"Yahudi bagee me Eboo, kiiboo, magiyaage\" see asegea, bedaa Wa me ebeyumaa da kaa miya dakamegea. ");
INSERT INTO auu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus mee bedaa peedoota kuwa Yahudi bagee yuwa paagoo asiino, \"Ikii daamaa nekeenii. Anii Wa kaa pedeo menaa ena ma yadiino taa kega yoka see kuwa ikii kisee nanekeensea naadi Waa yoo da kaa ikii paagoo badaa kimaawaanaka\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesus mee takuu yago onee yaidimitaata bakanee to ma, dadi poo epoo da see see yamaataata dokaa da ma, kisee yamaataata kaama yoo da kaa eepeanegea kaboo Pilatus me asiino, \"Eto ko mee Mée mee deeweedeei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Imam ebo yuwa ma, Ogatamee me ee yadiitoo taa see bagee yuwa ma okoo me Yesus deeta kaama \"Piya bokoo to kaa paku wugii, piya bokoo to kaa paku wugii\" see menaa too asegea. Pilatus me asiino, \"Anii Wa kaa pedeo menaa peenaa ma yadiino taa yoka ikii me too piya bokoo to kaa paku wugii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahudi kaa ebo-ebo yuwa me asiino, \"Inii me deewoo siyaa menaa yiba kisee bagee bogaano gaano pedeo see menaa ebeamaata. Wa me 'Anii Ogatamee Yoopaa' see wegagi yoka Waa booyaano gaano pedeo\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus me mee menaa yeeta kaama waa esee wedaagi. ");
INSERT INTO auu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wa me ee yiba pakaanta kaama Yesus asiino, \"Aa kayoo bagee naa ya?\" asigi naaki Yesus me mena ena ma asiino taa. ");
INSERT INTO auu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Asiino taa kemaata Pilatus me asiino, \"Aa mena naawegaano be ye? Anii pesee see mée yoka Aa daba peeyaai see miya kawegayaa, piya bokoo to kaa booyaai see miya kaasiyaa, see kuwa Aa nanekeeniino taa ye?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus me asiino, \"A me Ani kaa kisee-kisee yaukuwaai see nawegayaa mee ko asiyoo epoo to wodoo kaama aa kisee kaukuwaaniyaagi gaayu too kisee nawegayaa. Taa gaayu ko a me agiyoo ena ma se naukuwamaayaa. A me mikee pedeo nakiyaape kiya Anii a paagoo naekegataagi mée wa me pedeo mee asii esee pedeo\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kisee asigi naadi Pilatus me Yesus daba peeyaano see dimii mee ebo. Kisee dimii agoo kiya kuwa Yahudi kaa ebo-ebo yuwa me asiino, \"Mee Mée mee a me daba peeyaage kepa ko aa Ebo Kaisar ma epa see mée se. Mée waa ena me 'Anii magaa da kaa ebo tookee mée yoka' kisee ekaato ebo ekeasigi gaayu ko waa Kaisar ma aayape kiyaa see mée yoka\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatus waa kuwa menaa yeeta kaama Yesus mee badaa maadoota kaama yoo da kaa wa me mena ena too too mée yadaakomee taa see yoo animaagi. Kiyoo ko Oma Keagee da see ekaa mee weakee, Ibrani menaa kaa Gabata see ekaa mee weakee. ");
INSERT INTO auu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mee naagoo ko Paskah Naagoo miyoo taa naagoo, ebo naagoo naano see agiyoo-pagiyoo ipiipii taa see naagoo, kenoo to mée mumoo to kaa pakaamaagi see kaboo. Pilatus me kuwa Yahudi kaa ebo-ebo yuwa asiino, \"Ikii deeweei. Ikii me Eboo mee\" asigi naaki ");
INSERT INTO auu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","okoo me \"Wugii, wugii, piya bokoo to kaa paku wugii\" see asegea. Pilatus me asiino, \"Ikii me Eboo mee piya bokoo to kaa paku wugii ye?\" asigi naaki imam ebo yuwa me asiino, \"Inii me eboo mee ko Ebo Kaisar wa too\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kisee asegea naadi Waa piya bokoo to kaa paku wugitaasi naadi yaekeasigi. Yesus kisee ekeasigi naadi badaa maadoota eepeegea. ");
INSERT INTO auu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Waa ekaato mee piya bokoo to doodoota maga ena ekaa da ko Mumo Metoo Kutuu to kaa. Mee magaa mee ko Ibrani menaa kaa Golgota see ekaa weakee. ");
INSERT INTO auu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kiyoo peemaata kaama piya bokoo to kaa paku wugitaagea. Wa paagoo mée ekea wiya miya kisee paku wugitaagea. Wa me dagi yagaa yaato mée ena, eka yagaa yaato mée ena, Yesus Waa yupii da kaa ekeasegea. ");
INSERT INTO auu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kisee ekeata kaama Pilatus me yaebeapi menaa ena Yesus Wa me piya bokoo to kaa pakaa-tabeasegea. Wa me yaebeapi menaa mee ko kisee: \"Mee mée mee ko Yesus, Nazaret magaa kaa Mée, Yahudi bagee me Eboo mee\" see menaa mee. ");
INSERT INTO auu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kuwa menaa yuwa Ibrani menaa kaa ma, Latin menaa kaa ma, Yunani menaa kaa miya yaebeapi. Yesus mee piya bokoo to kaa paku wugitaagea magaa mee kota ekaapa see magaa yoka kuwa yaebeapi menaa yuwa Yahudi bagee maamaa eebaa me-deegeekea. ");
INSERT INTO auu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yahudi kaa imam ebo yuwa me Pilatus pe-asiino, \"A me 'Waa ko Yahudi bagee me Eboo mee' see ebeape menaa kuwa be, kisee se ebeai. Yaebeano ko 'Mee Mée mee me \"Anii ko Yahudi bagee me Eboo\" see menaa kuwa Wa me too wegapi' see menaa kuwa too yaebeano daamaa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kiya Pilatus me asiino, \"Ni me yaebeapa menaa kuwa too sikii yoka toono too\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Okaa yago bagee me Yesus piya bokoo to kaa paku wugimaata kaama Wa me dokaa yamasegea. Wa me maata dokaa kuwa okoo wui gakata wuditaagea. Wuditaata kaama Wa me semoo yiba yaato maata dokaa mee miya agoo. Mee dokaa da kapo ena too too, asipasi kaama yamuyaato otoo to kaa uduma one me kiwiino taa see dokaa. ");
INSERT INTO auu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Okoo me \"Mee dokaa mee se daaii taai. Maamee me masiipi, maamee me masiipi naadi niiiyagidee taai\" see aaseekea. Okoo me kisee ukuwagea mee ko idukaa Ogatamee me ebeamaata menaa ena uwa daasi naadi ukuwagea, mee ko \"Ni me dokaa kuwa yawuditaagea, Ni me dokaa masiino see naadi okoo me agiyoo iyagideekea\" see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kuwa kaboo da Waa paku wugitaagea piya boko manii to geboo da kaa Wabaayo ma, Wabaayo ma kenagaa apii ma, Klopas me apii Maria ma, Maria Magdalena ma kuwa kiyoo toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Wabaayo ma, Wa me topenaa see bagee ena, Wa me epa see mée ma ekea kiyoo yiinaageeta toomuu taakea see deeta kaama okooto paagoo asiino, \"Wae, deede. Eto kaama wodoo mee ko ayoopaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mee kaama Wa me topenaa see mée to paagoo asiino, \"Wae, deede. Eto kaama wodoo mee ko abaayo\" see asigi. Mee kaama wodoo Wa me topenaa see mée to me Yesus baayo badaa maadoota wa me ee kaa epo enaataa eeomegee, toogee seta. ");
INSERT INTO auu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kuwa kaboo da Yesus me 'Eto ko kuwa uduma yaukuwataaga yoka sikii' see gaata kaama Ogatamee me idukaa ebeamaata menaa ena uwa daasi naadi Wa me \"Anii uwo naadi kega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kiyoo otaawee ena, geebagi see anggur poo uwoo awemaata pudii see otaawee ena agoo yoka kiyoo topea bagee me doka ponee to see see agiyoo masegeeta kuwa geebagi see anggur poo uwoo yiba esee-tokoata hisop see piyaa gokoo da kaa yokoata Wa me ebee to kaa pakaa-yaekeasegea. ");
INSERT INTO auu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Waa uwo noodeeta kaama \"Uduma ukuwataaga, sikii yoka\" see asigi. Aseta kaama mumo kodeata dimi noogaa da pe-seomigi. ");
INSERT INTO auu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mee naagoo ko Sabat miyoo taa naagoo, Sabat naagoo kaa agiyoo-pagiyoo ipiipii taa see naagoo. Mee Sabat naagoo mee ko Paskah miya naapea yoka esee ebo naagoo. Yahudi kaa ebo-ebo yuwa me kuwa boota yuwa Sabat naagoo kisee piya bokoo to kaa tookee kuwa pedeo yoka naadi peedoota Pilatus paagoo asiino, \"Kuwa piya bokoo to kaa ekeata bagee yuwa okoo moga boota kaama masekomeesi yoka okoo me bado metoo yuwa yadukumetagaa taai see kaidimege\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aseta kaama okaa yago bagee noonaa peedoota kuwa piya bokoo to kaa ekeata bagee wedoo to paagoo peemaata kaama petamanii mée wa me bado metoo yuwa kaa dakamegea, bedaa naato mée miya kisee dakamegea. ");
INSERT INTO auu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kiya Yesus paagoo peemaata kaama deegea naaki boopi naadi Wa me bado metoo yuwa dakamaano taa. ");
INSERT INTO auu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kiya okaa yago bagee ena me wa me pose wuya me Wa pamee da taa pakaa-nokogetaagi naaki taka ena tadaa ma uwoo peega. ");
INSERT INTO auu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kuwa ukuwaandaa seta yuwa deeta mée mee wa me kuwa menaa eto kiebeataaki. Kuwa menaa kuwa mikee see menaa too see kuwa waa ipi. Ikii miya Yesus mikee nao see gaasea naadi wa me mikee menaa too kiebeataaki. ");
INSERT INTO auu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kuwa agiyoo ukuwaanega kuwa ko idukaa ebeamaata menaa ena uwa daasi naadi ukuwaanega, mee ko kisee: \"Wa me metoo ena ma si yadukuuniyaapea\" see menaa mee. ");
INSERT INTO auu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bedaa idukaa Wa kaa yaebeamaata menaa ena miya kisee: \"Okoo me nokogegea Mée to mee emaa me diitoo taapea\" see menaa mee. ");
INSERT INTO auu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kiyoo kaama mée waa ena ekaa da ko Yusup, Arimatea magaa kaa mée, Yesus bootaa da daba masiino see naadi Pilatus paagoo pe-idimigi. Yusup mee Yesus mikee gaayaa see mée ena kiya waa Yahudi kaa ebo-ebo yuwa weda kaa kisee koogo maapetaa see mée. Wa me Pilatus paagoo pe-idimigi naaki \"Daamaa, masii\" asigi. Asigi naadi Yesus bootaa da pe-masigi. ");
INSERT INTO auu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus mee, miyoo taa daatooyiba yaato Yesus paagoo peemi mée waa miya epo enaataa peegea. Waa wunu daamaa see agiyoo ekaa da ko mur ma, gaharu ma kuwa enaataa aatabu-maatabu naadi doopi. Kuwa uduma enaataa gaayu ko kilo amaamo waa naa. ");
INSERT INTO auu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yesus bootaa da masegeeta kaama Yahudi bagee me mée bootaa da kaa ukuwaa-ukuwaa ukuwagea. Kuwa wunu daamaa see agiyoo-pagiyoo kuwa bootaa da kaa ekeata kaama daamaa dokaa yuwa kaa podamaagea. ");
INSERT INTO auu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Waa piya bokoo to kaa paku wugitaagea yoo geboo da kaa kiyoo bugi ena agoo. Mee bugii da kaa ogo magaano yoo agoo, mée ogo maadiino taa see beapa. ");
INSERT INTO auu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mee naagoo ko Yahudi bagee me Sabat kaa agiyoo-pagiyoo ipiipii taa see naagoo. Sabat naagoo ekaapa kega yoka, bedaa ogo magaano yoo ekaapa miya agoo yoka naadi Yesus bootaa da kiyoo ogo maagea. ");
INSERT INTO auu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mee daa yiba petamanii naagoo pedeo komaa, pe-aweeniino taa kaboo da Maria Magdalena mee Yesus ogoo da kaa peega. Peemaata kaama deamaagi too ko Wa ogoo da kaa takeata oma damaa to geboo da kaa dogeamaata topa. ");
INSERT INTO auu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kisee deeta kaama mani yiibaga peedoota Simon Petrus ma, Yesus me topenaa see bagee kuwa Wa me esee epa gaataa see mée mee ma ekea paagoo peemaata kaama asiino, \"Tuhan bootaa da ogo maataamea yoo kaama mée me masedoo peegea. Okoo me doodoota pe-ekeasegea yoo inii ewo\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kisee asega naadi Petrus ma, mee apanaa topenaa see mée to ma ekea paaya Yesus ogo maataamea yoo peegea. ");
INSERT INTO auu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ekea paaya epo enaataa yiibaga peegea kiya ena mee moga yoka wa keta peemaagi. ");
INSERT INTO auu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Peemaata kaama peenaa kagu esee-ituunta mokoo kaama ogo wogaa-wogaa see deamaagi naaki Wa kaa bebenataata dokaa yuwa topa. Kisee deegi kiya kitaa seemaano taa. ");
INSERT INTO auu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrus mee uuto kaama peemaata mee ogo maapea taa kisee ki seemigi. Seemeta kaama deamaagi ko bootaa da kaa bebenataata dokaa yuwa kuwa wa too, ");
INSERT INTO auu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","bedaa mumoo to taa bebenataata dokaa da mee daamaa wa too denemaata topa. ");
INSERT INTO auu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kiyoo kaama Wa me topenaa see mée ena mee, wa keta peemaagi mée waa miya seemigi. Kuwa yuwa deeta kaama Yesus mikee aya andoo peepi ii see gaagi. ");
INSERT INTO auu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Aya andoo peepi kiya Ogatamee me menaa yiba \"Waa boota kaama aya andoo poono gaano pedeo\" see ebeamaata menaa mee ekea miya nekeeniino taa. ");
INSERT INTO auu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kuwa topenaa see bagee wiya kuwa ee kaa peegea ");
INSERT INTO auu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","kiya Maria mee se peega. Yesus ogo maataamea yoo geboo da kaa kiyoo yiinaageeta yegeeka. Yegee taaka too peenaa kagu ituunta mokoo kaama ogo maapea taa deamaaga naaki ");
INSERT INTO auu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","malaikat bagee ekea wiya Yesus bootaa da ekeasemea yoo kiyoo topea, ena mee mumo yaato, ena mee badaato yaato, kisee animaata toomuu taakea. ");
INSERT INTO auu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ekea me asiino, \"Apii to, wae. Aa kaasee kaa yegee taake?\" asegea naaki Maria me asiino, \"Ni epoo Mée Tuhan Wa bootaa da maseageeta kaama pe-ekeasegea yoo anii ewo yoka\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kisee aseta kaama waa oko maataata kaama deamaaga naaki Yesus tupi. Wa me kisee deega kiya 'Mee Yesus yoka' see kuwa se nekeenega. ");
INSERT INTO auu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus me asiino, \"Apii to, aa kaasee kaa yegee taake? Aa maamee abanaake naa ya?\" see asigi. Maria me gaano, 'Waa ko mee bugii yaagee see mée to' see gaata kaama asiino, \"Neataagi, aa Wa bootaa da mee doope kepa ko a me ekeasege yoo mee nasii, anii masigiinaka yoka\" see asega. ");
INSERT INTO auu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus me \"Maria, wae\" asigi naaki Maria mee ikigi pe-maataata kaama \"Rabuni\" asega. Rabuni see menaa mee wegayu ko Ibrani menaa kaa mée topetaa see mée see mee. ");
INSERT INTO auu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus me asiino, \"Anii Neataagi paagoo pakaamagaano taa yoka Anii se napeneasii. Eto ko peedoota Nii ma kenaa bagee paagoo kisee pe-naasii: 'Anii Neataagi paagoo, bedaa ikii miya Ikiitaagi paagoo pakaanaka, mee ko Ni me Eboo Ogatamee paagoo, bedaa ikii miya ikii me Eboo Ogatamee paagoo pakaanaka' see kisigi see pe-naasii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdalena mee peedoota Yesus me topenaa see bagee yuwa paagoo peemaata kaama asiino, \"Anii Tuhan ma aadee sepa nao\" see asega. Wa me asigi menaa yuwa miya eewegaga. ");
INSERT INTO auu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mee naagoo, mee daa yiba petamanii naagoo, uwaapeata digiyoo takiinega see kaboo Wa me topenaa see bagee yuwa me Yahudi kaa ebo-ebo yuwa weda kaa okoo me toogee see ee to kaa kutuu semaata kene yuwa munitaata koogo totaakea. Taka ena Yesus mee okoo paagoo awee da kaa keta kaama \"Epao, koogo adumeta dimii masii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aseta kaama Wa me yagaa ma, Wa me pamee da ma kuwa deeyaagi naaki okoo Tuhan nao naadi esee ede kegea. ");
INSERT INTO auu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bedaa Yesus me asiino, \"Koogo adumeta dimii masii. Neataagi Wa me 'Aa mée paagoo pooi' see naseta mokoo kisee Ani me miya ikii mée paagoo pooi see kisega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kiyoo kaama Waa okoo kaa ebe noogaa da puu aseta kaama asiino, \"Roh Kudus mee ikii daamaa masii. ");
INSERT INTO auu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Eto ko mée waa ena wa me pedeo yuwa ikii me epa yaekeasiyu ko Ogatamee Wa me miya waa epa ekeasiyaa, bedaa wa me pedeo yuwa ikii me epa si yaekeasiyu ko Ogatamee Wa me miya waa epa se ekeasiyaa, kuwa waa Ogatamee ma menaa yuwa si yataa kiyaayaa, kisee toopa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesus Waa okoo paagoo meemaata kaama eetoomuu sipi kaboo Yesus me topenaa see mée ena, mee ko Tomas mee, Didimus see ekaa miya weakee mée waa okoo ma enaataa eetoono taa. ");
INSERT INTO auu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wa me topenaa see bagee apa yuwa me Tomas asiino, \"Tuhan mee inii aadee sepe nao\" see asegea naaki wa me asiino, \"Anii Wa me yagaa da kaa kuwa paku wogeta ebee yuwa deeyu too, bedaa kuwa paku wogeta ebee yuwa taa ni me kepoo to me yaadee sepa gaayu too, bedaa ni me yagaa da me Wa me pamee da kaa abuu yobee da taa miya yaadee sepa gaayu too anii mikee nao see gaayaa, taa gaayu ko mikee se gaayaa\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Unu petoo omemaata kaama wagaagoo to naagoo Wa me topenaa see bagee yuwa kaagaa ena ma ee yiba koogo toomuu taakea, Tomas waa miya tupi. Kene yuwa munitaata kaama ee yiba toomuu taakea kaboo Yesus mee okoo paagoo meemaata kaama asiino, \"Epao, koogo adumeta dimii masii\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bedaa Wa me Tomas asiino, \"A me kepoo to me nakaayoo mee-nayaadee sede, Ni me yagaa kuwa daamaa nadeede, bedaa A me yagaa da me Ni me pamee da taa daamaa nayaadee taai. A me mikee se nagaano dimii mee ekeata mikee nao see dimii mee too nagaai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas me asiino, \"Mikee, Ni epoo Mée Tuhan, ni me Eboo Ogatamee\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus me asiino, \"A me Anii nadeege kemaata Anii mikee nao see nagaage. Okoo Anii nadiino taa kiya Anii mikee nao see nagaayaa bagee kuwa daamaa, ede nao\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus me kisee nekeensi naadi dimi nagii-nagii agiyoo apanaa miya maamaa eebaa Wa me topenaa see bagee emaa dagii da kaa ukuwanaa segee seta kiya mee kapogee yiba ebeano taa. ");
INSERT INTO auu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kiya mee kapogee kaa ikii kiebeamaaga menaa kuwa ko Yesus Waa mikee Ogatamee me ebo toowoosi naadi wigintaata Mée Ebo Kristus mee, Ogatamee Yoopaa ii see kuwa ikii mikee gaawoosea naadi kiebeamaaga, bedaa ikii Waa mikee nao see gaawoo naadi kaama Wa ekaa yiba daamaa umiwoo, toowoosea naadi kuwa menaa yuwa kiebeamaaga. ");
INSERT INTO auu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kuwa wodoo taa Yesus Waa Tiberias uwo pikuu da kaa bedaa egaa ena ma Wa me topenaa see bagee yuwa paagoo Waa ekaato deeyaata menaa mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petrus ma, Tomas, Didimus see ekaa miya weakee mée ma, Galilea wee kaa magaa ena Kana magaa kaa mée Natanael ma, Zebedeus see mée to wa me yogaa wiya ma, apanaa topenaa see bagee ekea wiya ma okoo paaya enaataa totaakea. ");
INSERT INTO auu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kuwa kaboo da Simon Petrus me \"Doge abaano see poonaka\" asigi naaki apa yuwa me \"Inii miya meenake\" asegea. Okoo uduma komaa da kaa pakaanta kaama daatooyiba yaato uduma doge abanaakea naaki peenaa ma imi taa. ");
INSERT INTO auu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Awega see kaboo Yesus Waa ea da kaa anoogeeta totaaki kiya Wa me topenaa see bagee yuwa me 'Mee ko Yesus yoka' see kuwa se nekeenegea. ");
INSERT INTO auu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesus me \"Ni me yogaa yuwa, wae. Doge imi taa ye?\" asigi naaki \"Mikee, imi taa\" see asegea. ");
INSERT INTO auu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesus me asiino, \"Ikii me jala onee mee koma dagi yagaa yaato tameeyamaai, doge deemagaapea ke\" see asigi. Jala kisee tameeyamaagea naaki doge esee maamaa eebaa seemedaa naadi goekeasiino kana. ");
INSERT INTO auu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kuwa kaboo da Wa me topenaa see bagee kuwa Wa me epa see mée to me Petrus asiino, \"Ei, mee Mée mee ko Tuhan yoka\" see asigi. Simon Petrus me \"Mee ko Tuhan yoka\" see menaa da yeeta kaama waa doka magaano taa kemaata wa me tapaato yaato maanaa see dokaa da masegeeta maataata kaama uwo dagii da kaa kagaa peanigi. ");
INSERT INTO auu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yesus paagoo peegi see kaboo kuwa apa yuwa mee komaa taa megea, jala onee mee doge maamaa pudii naadi kaama komaa da ma goepegeekea. Okoo ea kaa kaama beesekaa se, seratus meter waa naa too. ");
INSERT INTO auu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ea da kaa peemaata kaama deegea naaki biyaa dee da kaa doge ena topa, bedaa roti miya kiyoo topa. ");
INSERT INTO auu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus me asiino, \"Ikii me booyaagea dogee kuwa noonaa nakaayoo niidoomeei\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus me jala onee mee maayoo kaa goekeasigi. Jala mee pudii, doge yuwa miya ebo, kuwa uduma egataayaa naaki seratus lima puluh tiga. Doge maamaa eebaa kiya jala onee mee geaniino taa. ");
INSERT INTO auu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus me \"Naano ke meei\" asigi. Okoo me 'Mee ko Tuhan yoka' see kuwa nekeenegea kemaata \"Aa maamee naa ya?\" see asedee taano uu see bagee ena ma taa. ");
INSERT INTO auu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesus me roti masegeeta okoo goo-maneeyu, doge miya kisee masegeeta kaama mantaa. ");
INSERT INTO auu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesus Waa boota kaama aya andoo peeta wodoo Wa me topenaa see bagee yuwa paagoo Waa ekaato awee da kaa deeyaabuu simi yuwa kuwa eto mee wedaagoo to mee. ");
INSERT INTO auu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Naano agiyoo noomaata kaama Yesus me Simon Petrus asiino, \"Yohanes yoopaa, Simon Petrus, wae. A me naepa kege mee ko kuwa apanaa yuwa me Anii naepa kegea kuwa asii naepa kege ye?\" asigi naaki wa me asiino, \"Tuhan, mikee, ni me epa kagaaga dimii mee Aa naipi\" see asigi. Yesus me asiino, \"Ni me domba pooduu yuwa naano agiyoo daamaa nanuyaabuu siwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bedaa wiyaagoo to ma asiino, \"Simon, Yohanes yoopaa, aa naepa kege ye?\" asigi naaki \"Tuhan, mikee, anii Aa kaepa kega see kuwa Aa naipi\" see asigi. Yesus me asiino, \"Ni me domba yuwa daamaa namuniwoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bedaa wedaagoo to ma asiino, \"Simon, Yohanes yoopaa, aa naepa kege ye?\" asigi naaki Petrus me 'Sooi, aa naepa kege ye see menaa kuwa kaagaa wedo ma nasedeeki yoka' naadi dimi boodi, gaagaa ebo. Wa me asiino, \"Tuhan, Aa mena uduma ipi see Mée yoka anii kaepa kega see kuwa Aa naipi\" see asigi. Yesus me asiino, \"Ni me domba yuwa naano agiyoo daamaa nanuyaabuu siwoo taai. ");
INSERT INTO auu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Anii esee mikee kasiino ko: Aa peedi yaato doka ena masegeeta kaama aa ekaato daamaa maataata a me ede kiyaa taa daba peenaa segee seme kiya aa adama yaato ko aa yagaa petaasiyaa naaki apanaa bagee me one kagadimemaata kaama a me be kiyaa yoo kadogeamaatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Wa me kisee asigi mee ko 'Petrus, a kaa kisee kaukuwaaniyaata kaama aa bogaatage' see kuwa nekeensi naadi ebea-ebea menaa kuwa. Petrus mee kisee booyaata kaama wodoo mée me Ogatamee Waa ebo, Waa asii-sege nao see yaapaagee taatagea. Yesus me mee menaa wegamaata kaama \"Anii naobeewoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus me oko maataata kaama deeyamaagi naaki Yesus Wa me topenaa see bagee kuwa Wa me epa see mée to mee uuto migi. Mee mée mee miyoo taa Paskah nomea naagoo Yesus Wa kaa pe-gebaanta kaama \"Tuhan, Aa kaekegatagaapi mée mee maamee naa ya?\" see asimi mée to mee. ");
INSERT INTO auu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus me waa uuto migi see deeta kaama wa me Yesus asiino, \"Tuhan, mee mée mee naa kaasee ukuwaaniipi mée naa ya?\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus me asiino, \"Waa gaayu ko waa se boota kaama kisee too umiwoo, toowoo naadi bedaa Anii meeta naagoo too see kuwa Ani me ede kiyu ko kisee yaukuwaaniyaayaa yoka kuwa a me wegaakee se. Aa gaayu ko Anii naobeewoo taai see kasega\" see asigi. ");
INSERT INTO auu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kisee aseta kaama wodoo mee topenaa see mée to se bogaapi see menaa mee Yesus yiba ena kenaa bagee yuwa aawegaa siwoo seta. Kiya Yesus me waa se bogaapi see menaa mee wegaano taa. Wa me wegata menaa ko kisee: \"Waa gaayu ko waa se boota kaama kisee too umiwoo, toowoo naadi bedaa Anii meeta naagoo too see kuwa Ani me ede kiyu ko kisee yaukuwaaniyaayaa yoka kuwa a me wegaakee se\" see menaa mee too wegata. ");
INSERT INTO auu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mee topenaa see mée to mee wa me kuwa deeta-deeta yuwa daamaa ebeamaagi. Kuwa ebeamaata menaa kuwa uduma mikee menaa too see kuwa inii ipi. ");
INSERT INTO auu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus mee Wa me apanaa agiyoo esee maamaa eebaa miya ukuwanaa segee seta. Kuwa menaa yuwa uduma kapoge kaa ebeamaayu ko kuwa ebeamaata kapogee yuwa esee maamaa eebaa naadi kaama kapoge magaano yoo ko iyo, uwoo to, magaa to uduma miya peedi, magaano yoo se sikii kiyaa. Kiyoo too.");
INSERT INTO auu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Epao, Teopilus. Eto mee kapogee mee ko ni me wiyaagoo to kapogee kaebeataaka. Ni me petamanii kaebeamaama kapogee mee ko Yesus me ukuwanaa, peenaa seta menaa yuwa ma, Wa me mée topenaa seta menaa yuwa ma kuwa uduma petamanii kaama kisee too ");
INSERT INTO auu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","epoo to wodoo badaa maageemi yoo too kuwa menaa yuwa uduma daamaa kaebeamaama. Kuwa ko Waa epoo to wodoo badaa magaano taa kaboo Wa me menaa nadoonaasi naadi wiginta bagee yuwa paagoo \"Kisee ukuwaai, kisee ukuwaai\" see menaa eebaa kuwa Roh Kudus me pesee kaa daamaa ase-manee seta. ");
INSERT INTO auu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Waa boodi ma boota kaama aya andoo peemi wodoo Wa me menaa yadoonaa seta bagee yuwa paagoo peenaa seta. Okoo me Waa mikee aya andoo peepi ii see gaasi naadi agiyoo miya okoo paagoo maamaa deeyaabuu seta. Unu mée wiyaa to kuwa okoo me Waa deege-deege seta, bedaa Ogatamee Wa too ebo mée eetuyaa menaa kuwa miya Wa me okoo paagoo eewegagee seta. ");
INSERT INTO auu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kaawaa ena Yesus ma okoo paaya enaataa naano agiyoo notaaki too Wa me asiino, \"Eto kiipaa Yerusalem magaa kaa too toogee taai, apanaa magaa kaa se peenaa taai. Nagamee me ikii paagoo kiniita see kiseta Mée mee kiniitagi, Ani me kisema see see yoka nakaayoo diitoo segee taai. ");
INSERT INTO auu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mee ko idukaa Yohanes wa me uwo yiba mée yatukumeta kiya bedaa eebaa umiino taa kaa ikii Roh Kudus yiba kitukumaatagi yoka nakaayoo too diitoo segee taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kaawaa ena ma Yesus me menaa yadoonaa see bagee yuwa Waa ma enaataa kutuu semaata kaama okoo me asiino, \"Tuhan, idukaa Israel magaa kaa inii Israel bagee yuwa too ebo toogee seta see see Aa eto kiipaa miya inii ebo mée tuyaape ye?\" see asegea naaki ");
INSERT INTO auu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wa me asiino, \"Kuwa ko Nagamee Wa me too ukuwaaniyaayaa agiyoo da. Mee naagoo, mee naagoo kuwa Wa too ipi yoka koogo tooi. ");
INSERT INTO auu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kiya eebaa umiino taa kaa Roh Kudus mee ikii kaa eseanta kaama pesee kikiyaatagi. Pesee kikiyaata kaama ikii Yerusalem magaa ma, Yudea wee kaa magaa ma, Samaria wee kaa magaa ma kuwa magaa kuwa kaa Ni me menaa nadoonaa taatagea, bedaa kisee too uwo otoo to kaa, maga otoo to kaa bagee paagoo miya naweganaa segee taatagea\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kuwa menaa eewegamaata kaama Ogatamee me Waa epoo to wodoo pakayaagi. Pakagi, pakagi kisee deatookea naaki sinu yuwa yibaa taa pakaa-booneenigi, ewo. ");
INSERT INTO auu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Epoo to yaato maamaa pakaa-diitoo taakea naaki taka ena okoo geboo da kaa poodee see dokaa maata see bagee wiya yiinaageeta topea. ");
INSERT INTO auu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kuwa mée wiya me asiino, \"Ei, Galilea wee kaa bagee yuwa, ikii kaasee kaa aii epoo to yaato pakaa-diitoo taakea ya? Yesus mee epoo to wodoo pakapi see deepea see see Waa bedaa kisee metaki isiitagi\" see asegea. ");
INSERT INTO auu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yesus mee Zaitun kutuu to kaa kaama epoo to wodoo pakaa-seometa kaama Wa me menaa yadoonaa see bagee yuwa esedoota Yerusalem magaa kaa ekaapa see yoo esegea. ");
INSERT INTO auu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Eseemaata kaama okoo me omegee see ee kaa asii mee kakadee kaa pakagea. Kuwa bagee ekaa yuwa ko Petrus, Yohanes, Yakobus, Andreas, Pilipus, Tomas, Bartolomeus, Matius, Yakobus ena mee, Alpeus yoopaa mee, kiyoo kaama Simon, yape tukuu mée, bedaa Yudas ena mee, Yakobus yoopaa mee wodopasi. ");
INSERT INTO auu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Api noonaa miya kiyoo topea. Yesus baayo Maria mee miya topa, Yesus ebee nokaa yuwa miya topea. Okoo uduma ena dimii, ena menaa kaa epo enaataa sembahyang segeekea. ");
INSERT INTO auu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kiyoo topea bagee okoo eebaa, mée seratus dua puluh mokoo. Kaawaa ena Petrus mee yiinaageeta asiino, ");
INSERT INTO auu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","\"Neawaagi nokaa, neebee nokaa ikii nayii. Kuwa Yesus peneasiino see bagee eemimi mée Yudas mee, wa me ukuwata peeta yuwa kuwa idukaa Roh Kudus me Daud paagoo 'Wa me kisee ukuwaatagi, kisee ukuwaatagi' see menaa kuwa aseta. Kuwa menaa wegawoo naadi kaama mikee eto uwa daaga. ");
INSERT INTO auu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas mee inii epo peenaa see mée, Yesus me menaa epo yaweganaasi naadi wiginta mée kiya\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudas me pedeo agiyoo ukuwataa to kaa maseta kepee kuwa me maga ena edaamea. Mee magaa kaa waa okaamaata kaama eseanigi naaki yoogaa yuwa pagimedaa simi. ");
INSERT INTO auu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kuwa menaa yuwa Yerusalem magaa kaa bagee uduma yeemaata kaama mee magaa mee okoo me menaa kaa Akeldama see ekaa muntaamea. Akeldama see ekaa mee wegayu ko Tadaa Magaa see ekaa mee. ");
INSERT INTO auu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bedaa Petrus me asiino, \"Idukaa Mazmur kapogee yiba Daud me ebeamaata menaa ena mee ko kisee: 'Mee pedeo agiyoo ukuwata mée wa me omegee sipi ee mee mée ena ma se umii, aii kisee too ekeasii' see menaa ebeamaata. Bedaa mena ena ma kisee: 'Wa me komoo apanaa bagee agoo kiyaano daamaa' see menaa miya ebeamaata. ");
INSERT INTO auu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kisee ebeamaata yoka eto ko Yudas wa me komoo toono mée ena niiwigineai. Mee mée mee gaayu ko waa idukaa petamanii kaama Tuhan Yesus inii paagoo omegee seta kaboo kaama waa miya inii ma epo enaataa peenaa segee seta mée waa ena inii wigineano daamaa. ");
INSERT INTO auu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mee mée mee waa miya Yesus mee Yohanes me uwo yatukumemaata kaama asii kisee too epoo to wodoo badaa maageemi yoo too kuwa yaayupii kuwa uduma deepi mée gaayu too daamaa. Waa ma inii 'Yesus mee aya andoo peepi see kuwa deepe yoka' see menaa epo weganaasi naadi niiwigineai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Okoo me maamee daamaa, maamee daamaa naadi kaama mée ekea wiya ekaa maagea. Ena mee ekaa da ko Yusup Barsabas, ena mee ekaa da ko Matias. Barsabas wa ekaa da ena mee ko Yustus see ekaa mee. ");
INSERT INTO auu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Okoo me sembahyang taano, \"Tuhan, mée me dimi menaa ipi see Mée mee A too yoka kuwa mée wiya kuwa A me wigintaata mée mee ii see kuwa inii daamaa mée deeyaai. ");
INSERT INTO auu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yudas mee A me menaa kadoonaa, A me agiyoo kaukuwanaa see kuwa wa me be kaa kaekeasimi. Wa me pedeo ukuwataa to masigi yoka sikii. Wa me wisintaami yuwa kuwa apanaa bagee me kaukuwageesi yoka A me wigintaata mée to mee inii mée deeyaai\" see asegea. ");
INSERT INTO auu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kisee aseta kaama Ogatamee me wigintaata mée to 'Mee ii' see ipi kaano see naadi agiyoo ena maadeekea naaki Matias kaa kega. Mee kaama wodoo Yesus me menaa yadoonaa see mée gaasi ma wiyaagoo to mée mee ko Matias mee. ");
INSERT INTO auu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentakosta naagoo Yesus mikee gaayaa bagee okoo uduma ee ena kaa kutuu semaata ");
INSERT INTO auu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","toomuu taaka too ko taka ena epoo to kaa kaama tukuu damaa to esega, yiino ebo, ebo boo tukuu see see okoo topea ee yiba uduma seemega. ");
INSERT INTO auu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kuwa kaboo da biyaa gada see see agiyoo kuwa eseanega, dabegea da keenda see agiyoo. Wudidaa naadi kiyoo topea bagee yuwa mée ena-ena okoo kaa peaneeka. ");
INSERT INTO auu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Roh Kudus mee kuwa bagee yuwa yiba esee-awedaa naadi kaama okoo uduma apanaa tomaa kaa bagee me menaa ipi kedaakea, Roh pesee kaa mena tomaa-tomaa yuwa kaa wegataakea. ");
INSERT INTO auu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kuwa kaboo da Yahudi bagee mée eebaa okoo kiyoo-kiyoo maga uduma kaa kaama Yerusalem magaa kaa meemaaii naadi kiyoo omegeekea. Okoo Ogatamee me menaa ipiipi yadeetaa see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Okoo mée eebaa mee tukuu damaa to mee kaasee agiyoo naadi moga peedoota mee ee kaa peemaagea naaki kiyoo topea bagee yuwa me wa me menaa kaa, wa me menaa kaa wegataakea see yeegea. Okoo dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Okoo dimi nagimeamoo naadi kaama aasee taano, \"Kuwa uduma Galilea wee kaa bagee, se maa? ");
INSERT INTO auu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kiya inii me menaa gakata okoo ipi kaa wegataakea yaai, mee kaasee agiyoo ya? ");
INSERT INTO auu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Inii ko noonaa Partia magaa kaa bagee, noonaa Media bagee, noonaa Elam bagee, noonaa Mesopotamia bagee, noonaa Yudea wee kaa bagee, noonaa Kapadokia bagee, noonaa Pontus bagee, noonaa Asia bagee, ");
INSERT INTO auu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","noonaa Prigia bagee, noonaa Pampilia bagee, noonaa Mesir bagee, noonaa Libia magaa kaa Kirene bagee, noonaa miya Roma magaa kaa kaama mepea bagee, ");
INSERT INTO auu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","noonaa Kreta bagee, noonaa Arab bagee. Inii noonaa Yahudi bagee, noonaa apanaa tomaa kaa bagee kiya Ogatamee yaapaagee see bagee yuwa. Inii mena tomaa-tomaa maamaa eebaa kiya okoo kisee inii ena me, ena me menaa kaa wegataakea. Okoo Ogatamee me omaago ma ukuwagee seta agiyoo wegaaiikea kuwa inii daamaa yeegea. ");
INSERT INTO auu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yaai, mee kaasee agiyoo naa ya?\" see menaa aaseekea. ");
INSERT INTO auu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kiya apanaa bagee yuwa me wisineekee kaa asiino, \"Okoo anggur poo uwoo maamaa noomaata kaama boomagaa see kaa wegataakea see deega\" see asegea. ");
INSERT INTO auu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kuwa kaboo da Petrus mee Yesus me menaa yadoonaa see bagee gaasi ma ena kuwa ma enaataa yiinaageeta kaama wa me wegaano, \"Ei, ikii Yahudi bagee ma, Yerusalem magaa kaa bagee miya ikii uduma kuwa ukuwadaaka agiyoo yuwa daamaa nekeensea yoka ni me menaa nayiitoo taai. ");
INSERT INTO auu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ikii me gaano, 'Okoo anggur poo uwoo maamaa noomaata kaama boomagaa see kaa wegataakea menaa too' see se ke. Eto pedeo komaa yaato, keno iyee see kaboo, poo uwoo se notaa see kaboo yoka ");
INSERT INTO auu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","uwo noomaata boomagaa see kaa se kiya idukaa nabi Yoel me ebeamaata menaa ena wegawoo naadi kaama eto kiipaa uwa daaga yoo. Wa me menaa mee ko kisee: ");
INSERT INTO auu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Ogatamee me wegaano, \"Epeekaa wodopasi yaato Ni me Roh mee ko mée tomaa okoo uduma kaa yakabagekumiita. Kisee yakabagekomeeta kaama ikii me yogaa yuwa, paayogaa miya, ukuyogaa miya Ni me kisi-manee siyaa menaa naweganaa taatagea, ikii egaanaa yuwa miya dega-dega kaa diitagea, ikii ebo bagee yuwa miya unu kaa diitagea. ");
INSERT INTO auu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wodopasi yaato Ni me agiyoo naokagee see bagee yuwa, paayogaa miya, api miya okoo uduma kaa Ni me Roh mee yakabagekomeeta kaama Ni me ase-manee siyaa menaa kuwa naweganaa taatagea. ");
INSERT INTO auu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Asiyoo epoo to yaato miya Anii dimi nagii-nagii see agiyoo agoo kiyaabuu taata, bedaa magaa da kaa kiyoo miya apanaa kisee nekeensi naadi agiyoo agoo kedaa taata, tadaa ma, biyaa ma, utuu ebo miya kisee diitagea. ");
INSERT INTO auu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kenoo to mee digiyoo takiiniita, bedaa agoo to mee miya tadaa epoo da kaata. Kuwa agiyoo yuwa ukuwaandaa taata wodoo esee ebo see naagoo kaata, Tuhan Wa too ebo, Wa too asii-sege see diitagea naagoo mee. ");
INSERT INTO auu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kuwa kaboo da Tuhan nao naadi mena naugiyaa bagee uduma daba daagimaa peeyaabuu taata\" see aseta' see kuwa idukaa wegata menaa. ");
INSERT INTO auu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Eto ko Israel bagee yuwa, ikii nayiitoo taai. Yesus mee, Nazaret magaa kaa Mée mee Ogatamee me pesee kiyaata kaama ikii me 'Mee ko Ogatamee me isiyaata Mée to ii' see kuwa nekeensea naadi agiyoo ma, apanaa dimi nagii-nagii agiyoo maamaa eebaa ikii paagoo ukuwanaa segee simi. Kuwa uduma ikii miya ipi. ");
INSERT INTO auu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesus mee Waa aii kisee boomi se kiya idukaa ko 'Kisee bogaatagi, kisee booyaatagea' see kuwa Ogatamee me ebeataata. Apanaa tomaa kaa bagee yuwa ma ikii epo enaataa kisee Yesus peneata piya bokoo to kaa booyaamea ");
INSERT INTO auu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","kiya Waa boota kaama kisee eke see kuwa ko taa, iyo. Kuwa bogaano yaato pesee da kuwa Ogatamee me yataa kiyaata aya andoo peeyaami. ");
INSERT INTO auu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mikee, idukaa Daud me Yesus kaa wegawoo seta menaa ena mee ko kisee: 'TUHAN Waa ni paagoo kisee too naatoowoo segeeki, Waa ani me dagi yagaa yaato anii ma enaataa kemaata anii weda taa, se makii taapa. ");
INSERT INTO auu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Kisee kemaata anii dimi menaa da ede ma, ede ma toogeeka, Wa too yaapaagee siwoo segeeka. Anii boota kaama boota bagee toogee yoo Aa se naekeasiipe, Anii ko Aa ma dimii menaa kaa too umiwoo see mée yoka ni me boota maa to mee A me dabiino be naadi kiyoo se naekeasiipe, má yaato miya daamaa-daamaa toowoo taapa. ");
INSERT INTO auu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Anii daamaa umiwoo, toowoo taano etaa da mee A me nadeeyaage, Aa anii ma enaataa kemaata ni me umiwoo, toowoo siyaa kuwa A me ede ma, ede ma too see nakiyaage' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","See kuwa mée yogaa yuwa eto ko kuwa inii awee da kaa nekeeniino menaa kuwa kiiwegaanaka, mee ko kisee: Kuwa idukaa inii ma tomaa kaa mée Daud wa me ebeamaata menaa kiya ukuwaaniino yaato kuwa waa ekaato kaa se. Waa idukaa mikee boomaata kaama wa bootaa da ogo maata yoo amoo maa kaa topa. Wa me maa to mikee dabeta yoka kuwa 'Ni me boota maa to se dabiipa' see wegata menaa kuwa Daud waa ekaato kaa menaa se. ");
INSERT INTO auu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daud waa nabi bagee yoka ukuwaaniino yaato kuwa apanaa bagee kaa yadoowoosi naadi menaa ebeamaata. Mee ko idukaa Ogatamee me Daud aseta menaa ko 'Taa ma taa a me asii-kaba-kaba bagee ena mee Waa miya aa see see Ani me ebo tuyaata, Anii kisee se kaukuwaano ko daa' see aseta. ");
INSERT INTO auu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kisee aseta kemaata Daud me gaano, 'Kuwa menaa kuwa ko Ebo Kristus kaa menaa yoka Waa boota kaama aya andoo pootagi ii' see nekeenta kaama kuwa menaa ebeamaata. Ogatamee me Ebo Kristus mee boota kaama boota bagee toogee yoo ekeasiino taa, Wa bootaa da miya dabiino taa see kuwa idukaa kaama Daud waa ipi kemaata kuwa menaa yuwa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mee Yesus mee mikee boomaata kaama Ogatamee me aya andoo peeyaami see kuwa inii deeme. ");
INSERT INTO auu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Waa asiyoo epoo to wodoo pakaamaata kaama Ogatamee me Wa me dagi yagaa yaato esee ebo tuyaami. Idukaa Ogatamee me Yesus asiino, 'Roh Kudus mee epeekaa mée paagoo isiyaata' see aseta kuwa me Yesus me Roh mee inii kaa mée yakabagekomeegi. Eto kuwa ikii me yeetaa, deetaa see agiyoo kuwa mee kaama too. ");
INSERT INTO auu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daud waa epoo to wodoo pakaano taa yoka kuwa menaa kuwa waa ekaato kaa menaa se. Daud me yawegawoo seta menaa ena mee ko kisee: 'TUHAN me ni epoo Mée Tuhan mee paagoo asiino, \"Aa Ni me dagi yagaa yaato animagaai, kisee too ");
INSERT INTO auu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Aa ma yape kiyaa bagee yuwa kuwa Ani me daba, peedi kaekeata A me badoo da miyoo taa kaekeasiita\" see aseta' see menaa ebeamaata. ");
INSERT INTO auu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kisee kemaata ikii daamaa nekeenii: Yesus mee, ikii me piya bokoo to kaa paku wugitaata Mée mee, Ogatamee me Wa too wigintaata Mée Tuhan, Ebo Kristus mee ebo tuyaagi ii see kuwa Israel bagee ikii uduma daamaa nekeensea naadi kiiwegaga\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kuwa menaa yiitookea bagee yuwa esee dimi boodi, gaagaa ebo kegea. \"Yaai, inii eto kaasee ukuwaakee daamaa naa ya?\" see asegea naaki ");
INSERT INTO auu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus me asiino, \"Ikii mée gakata ikii me pedeo yuwa uduma Ogatamee me epa kiekeasi yoka ikii kuwa uduma ekeata Waa ma dimii menaa kaa too umiwoo, toowoo taai, bedaa Yesus Kristus ekaa yiba uwo tukumaai. Mee kaama Ogatamee me inii aii mée maniyaa Mée Roh Kudus mee ikii daamaa aii masiipea. ");
INSERT INTO auu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ogatamee me 'Roh mee kiniita' see mée asimi yoka eto ko ikii ma, ikii me asii-kaba-kaba bagee yuwa ma, beesekaa toogee siyaa bagee miya ikii uduma, inii epoo Mée Tuhan Ogatamee Wa me Ni paagoo nameei see asiipi bagee yuwa uduma paagoo Roh mee maniipi\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bedaa Petrus me apanaa gaamaasi naadi menaa eebaa miya eewegagi, kuwa ko kisee: \"Eto begaa kaa bagee kuwa dimi pedeo yoka ikii okoo ma enaataa se kipedeo kiyaasi yoka okoo me iyee-payee kuwa wisintagaai\" see maamaa asigi. ");
INSERT INTO auu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kiyoo kaama wa me menaa mikee nao naadi dimi yiba awegea bagee yuwa uduma uwo tukumegea. Kuwa bagee egataayaa naaki mée tiga ribu. Apanaa mikee gaamea bagee ma aatabi siyaa naaki mee asii mée eebaa. ");
INSERT INTO auu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Okoo uduma ena dimii, ena menaa kaa too omegee, toogeekea. Yesus me menaa yadoonaa see bagee okoo me mée topegee seta menaa yuwa okoo daamaa yayeegee, roti magu kabataata epo noogee, sembahyang epo koo segee, kisee epo ukuwagee see. ");
INSERT INTO auu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesus me menaa yadoonaa see bagee yuwa me Yesus mikee nao see gaasi naadi agiyoo ma, apanaa dimi nagii-nagii agiyoo miya maamaa eebaa ukuwayaabuu naadi kaama mée uduma dimi nagimegee see too. ");
INSERT INTO auu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yesus mikee gaayaa bagee yuwa okoo ena dimii, ena menaa kaa too omegee, toogee naadi kaama kabu see bagee peenaa ma taa, okoo me agiyoo-pagiyoo uduma epo agiyoo too see gaataa see. ");
INSERT INTO auu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Agiyoo yago bagee yuwa me kepe taa see bagee kepe maniino see naadi kaama okoo me agiyoo ena waa naa ekaa montaa. Kuwa masiyaa kepee yuwa kepe taa bagee goo-maneeyu, kisee aaukuwanaa segee see bagee yuwa. ");
INSERT INTO auu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Okoo egapii gakata Ogatamee me ee kaa miya kutuu segee see, bedaa okoo me omegee see ee kaa miya kutuu segee naadi kaama ede ma, ede ma naano agiyoo epo noogee taa see. Egaa ena waa ena me ee kaa, egaa ena waa ena me ee kaa dimi peedi kaa kisee too epo enaataa agiyoo noogee segee see, ");
INSERT INTO auu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","okoo Ogatamee mee epo enaataa yaapaagee see, okoo kisee ukuwanaa segee see. Kuwa me kaama apanaa bagee me kuwa daamaa bagee yoka naadi epa kegea. Egapii gakata Yesus mikee gaayaa bagee yuwa eebaa kega, eebaa kega, Ogatamee me kisee too yaukuwaaniyaabuu segeeki. ");
INSERT INTO auu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kaawaa ena Petrus ma, Yohanes ma ekea uwaataa da keno wedo see kaboo, sembahyang segee see kaboo yoka ekea miya peedoota Ogatamee me ee kaa ");
INSERT INTO auu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","peemaaga too ko bado oogimaata see mée ena kiyoo tupi. Waa agoo keta yoo kaama kisee too poono naka see mée. Ogatamee me ee mee tapa yaato kene ena mee ekaa da ko Diino Disi See Kenee To kaa kiyoo pakaaneekea bagee paagoo wa me kepe idimisi naadi kaama egapii gakata mée me kiyoo dogeamoo segee see, waa kisee too ukuwagee see mée. ");
INSERT INTO auu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mee mée to me Petrus ma, Yohanes ma ekea Ogatamee me ee mee tapa yaato pakaaniino see kookea kuwa deeta kaama asiino, \"Kepe nii\" asigi. ");
INSERT INTO auu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ekea me waa emaa wugitaata kaama Petrus me asiino, \"Aa enaa too mée diitoo taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wa me gaano, 'Kepe niinakea ye' naadi ekea too deatooki. ");
INSERT INTO auu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petrus me asiino, \"Kepe mee ko imi taa kiya ni me agoo see agiyoo kuwa kaniinaka. Kuwa ko Nazaret magaa kaa Mée Yesus, Ebo Kristus Wa too pesee see ekaa mee me aa anoogeeta peenaa taai\" see asigi. ");
INSERT INTO auu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dagi yagaa yaato yagaa pe-peneata goekeasigi naaki kisee ki bado, ekepea kaguu kuwa uduma pesee keegoogi. ");
INSERT INTO auu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mani-mani see anoogeeta kaama daamaa too peenaaki. Waa ma okoo wedo Ogatamee me ee kaa epo peetaaki too mee mée to Ogatamee yaapaageeki, esee ede kaa yuku-yuku sepegeeki. ");
INSERT INTO auu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ogatamee kisee yaapaageeki, kisee peenaaki yuwa kuwa okoo kiyoo topea bagee yuwa miya deegea. ");
INSERT INTO auu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mee mée mee ko mikee egapii gakata Diino Disi See Kenee To kaa animaata \"Kepe nii\" see asegee see mée ii see nekeenegea. Waa daamaa yakiyaagea kuwa kaa okoo sooi, esee dimi nagimegea. ");
INSERT INTO auu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kuwa bagee yuwa dimi nagimeamoo naadi kaama moga peedoota Ogatamee me ee bapi yaato peegee see etaa kaa kiyoo okoo wedo paagoo peemaagea naaki mee mée to epa kaa Petrus ma, Yohanes ma yagaa peneata totaaki. Mee ee bapi yaato peegee see etaa ekaa da ko Salomo see ekaa mee ee bapi yaato peegee see etaa see ekaa muntaata. ");
INSERT INTO auu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus me kuwa mée tabaa da deeta kaama asiino, \"Israel bagee yuwa, wae. Ikii kaasee kaa dimi nagimetaakea ya? Ikii kaasee kaa enaa mée maamaa deetaakea ya? Enaa me pesee kaa waa daamaa peeyaage se, enaa dimi topoo see bagee kemaata kaama waa daamaa yakiyaage miya taa. ");
INSERT INTO auu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Idukaa inii ma tomaa kaa bagee Abraham ma, Isak ma, Yakub ma okoo me yaapaagee see Mée Ogatamee Wa me agiyoo daamaa yaokagee see Mée Yesus mee Ogatamee me Waa ebo, Waa asii-sege, kisee yaekeasigi. Ikii me Yesus mee patamisi naadi Pilatus paagoo yaekegataata kaama be kaa wigintaamea. Pilatus me 'Waa pedeo agiyoo ukuwaano taa yoka daba peeyaapa' see kisimi ");
INSERT INTO auu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kiya ikii me kisee be. Mikee, Yesus Waa pedeo ena ma taa see Mée, dimi topoo too see Mée kiya ikii me Pilatus paagoo 'Apiyoo mée wugitaa see mée wa too daba mée yapeeyaai' see asemea. ");
INSERT INTO auu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yesus mee ko mée daamaa aya tuyaayaa Mée kiya ikii kisee booyaamea. Ikii me booyaamea kiya Ogatamee me aya andoo peeyaami, see kuwa enaa me deeta kaama weganaake. ");
INSERT INTO auu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesus Wa ekaa da pesee see Mée ii see gaataa to kaa mee mée bado yuwa pesee yakiyaagi. Mee mée mee ikii uduma ipi, waa poono naka see kuwa ikii idukaa kaama deegee sepea. Yesus mikee nao see gaataa to kaa bado yuwa pesee yakiyaagi see kuwa ikii miya deegea. ");
INSERT INTO auu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Neawaagi nokaa yuwa, neebee nokaa yuwa, Yesus booyaamea kuwa ikii ma, ikii me ebo bagee yuwa ma kuwa uduma Waa Ebo Kristus ii see kuwa nekeeniino taa, ewo kemaata kaama booyaamea. ");
INSERT INTO auu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mikee kiya Waa aii boopi se. Ikii me booyaamea kuwa ko idukaa nabi bagee yuwa me 'Ebo Kristus mee kisee bogaatagi, kisee booyaatagea' see menaa wegawoo naadi kaama uwa daaga. ");
INSERT INTO auu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","See keta yoo ikii me pedeo yuwa kiwonaapeasi yoka uduma ekeata Ogatamee ma dimii menaa kaa too umiwoo, toowoo taai. ");
INSERT INTO auu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ikii kisee ukuwayu ko ikii dimi menaa da mee Tuhan me daamaa kiadumiyaabuu siwoo taapi, bedaa Ebo Kristus mee ikii paagoo kiisiyaatagi, mee ko ikii paagoo ebo kiitoowoosi naadi daamaa wigintaata Mée Yesus mee. ");
INSERT INTO auu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Eto kiipaa Waa epoo to wodoo tupi. Uwoo to, magaa to uduma petamanii pedeo ena ma taa kaboo see see, iminookaa Ogatamee me kuwa uduma bedaa esee daamaa too kiyaano see naagoo isiyaatagi. Idukaa Wa me nabi bagee daamaa wigintaata yuwa doodoo Wa me kuwa menaa wegawoo seta. ");
INSERT INTO auu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Idukaa Musa me Israel bagee yuwa aseta menaa ena mee ko kisee: 'Ikii me Eboo Ogatamee Waa iminookaa ikii me asii-kaba-kaba bagee ena, anii see see nabi bagee ena kiagoo kiyaatagi. Mee Mée mee Wa me menaa too daamaa yayeewoo taai. ");
INSERT INTO auu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wa me menaa si yayeetaa see bagee kuwa uduma Ogatamee me bagee yuwa se yoka wigintaata pedeo kiyaabuu taatagi' see kuwa Musa me aseta. ");
INSERT INTO auu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Idukaa apanaa nabi bagee yuwa me miya Ebo Kristus me ukuwata peeta yuwa kuwa 'Kisee kaata, kisee ukuwaaniita' see aseta. Samuel waa ma, wa asii nabi bagee yuwa ma okoo uduma kisee wegawoo seta. ");
INSERT INTO auu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kuwa nabi bagee me menaa kuwa ikii kaa ki daamaa uwa daaga. Idukaa Ogatamee me ikii me bagee yuwa paagoo aseta menaa miya kisee. Wa me Abraham paagoo 'A me asii-kaba-kaba bagee doodoo mée tomaa-tomaa yuwa uduma daamaa kiyaabuu taata' see aseta menaa kuwa miya mikee eto inii kaa daamaa uwa daaga. ");
INSERT INTO auu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ogatamee Wa me agiyoo daamaa yaokagee see Mée Yesus Waa magaa da kaa isiyaami mee ko ikii me pedeo yuwa ekeata kaama Ogatamee me ikii daamaa kikiyaabuu taano see naadi Yesus mee Israel bagee paagoo keta 'Pooi' see asimi\" see kuwa Petrus me aseta menaa. ");
INSERT INTO auu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrus ma, Yohanes ma ekea kuwa mée tabaa da mena eewegataaka too ko Yahudi kaa ebo-ebo yuwa meemaagea, noonaa imam bagee, noonaa Saduki kaa bagee. Ogatamee me ee diitoo taa see bagee me eboo miya epo meemaagea. ");
INSERT INTO auu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Petrus ma, Yohanes ma ekea me \"Ogatamee me Yesus boota kaama aya andoo peeyaami mee me inii miya kisee mée aya andoo peeyaatagi\" see menaa kuwa mée topetaakea. Kiya kuwa menaa kuwa Yahudi kaa ebo-ebo yuwa me be, esee kagoo kaa ");
INSERT INTO auu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ekea peneata kaama apaadee taano see kiya digiyoo takiinega yoka tokoma too naadi digiyoo ee yiba aii kisee dogeamaagea. ");
INSERT INTO auu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kisee dogeamaagea kiya ekea me eewegapea menaa mikee gaagea bagee kuwa eebaa. Kuwa bagee yuwa ma, miyoo taa Yesus mikee gaamea bagee yuwa ma kuwa uduma, paayogaa yogaa yuwa too egataayaa naaki mée lima ribu mokoo. ");
INSERT INTO auu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tokoma mee da Yahudi kaa ebo-ebo yuwa ma, Musa me menaa mée topetaa see bagee yuwa ma, apanaa ebo bagee miya okoo uduma Yerusalem magaa kaa kutuu semaagea. ");
INSERT INTO auu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Okoo paagoo Ebo Imam ekaa da ko Hanas see mée to tupi, Ebo Imam bagee apanaa miya topea. Okoo ekaa yuwa ko Kayapas, Yohanes, Aleksander, apanaa miya topea. ");
INSERT INTO auu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Okoo kutuu semaata kaama Petrus ma, Yohanes ma ekea digiyoo ee yiba kaama badaa maageeta okoo yupii da kaa ekeasegea. Kuwa bagee yuwa me ekea asiino, \"Etoomanaa ekea me mee bado oogimaata see mée to daamaa yakiyaamea mee ko maamee me pesee kaa, maamee ekaa yiba kisee ukuwaaniyaamea ya?\" see asegea. ");
INSERT INTO auu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kuwa kaboo da Roh Kudus mee Petrus yiba esee-awigi naadi kaama wa me asiino, \"Ebo yuwa, ikii daamaa nayeeweei. ");
INSERT INTO auu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Enaa me bado oogimaata mée ena daamaa yaukuwame agiyoo mee kaa kaama ikii me eto kenaagoo mée asedeekea, mee ko 'Ekea me kaasee pesee kaa daamaa yakiyaamea ya?' see kuwa ikii nekeeniino taa yoka ");
INSERT INTO auu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ikii ma, Israel bagee apanaa yuwa miya uduma daamaa nekeensea yoka kisiinaka, kuwa ko Nazaret magaa kaa Mée Yesus, Ebo Kristus mee Wa too pesee see ekaa da mee me mee bado oogimaata mée to daamaa yakiyaami kemaata eto kiipaa waa ikii paagoo daamaa yiinaageeta toomuu taaki see ikii deegea. Mee Yesus mee ko ikii me piya bokoo to kaa booyaamea kiya Ogatamee me aya andoo peeyaami Mée mee. ");
INSERT INTO auu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ogatamee me menaa yiba Wa kaa wegawoo seta menaa ena mee ko kisee: 'Ikii oma ee maataa see bagee me be kaa tameepeata omaa mee ko TUHAN me masegeeta tuku omaa mee daamaa pee-yaekeata' see menaa ebeamaata. Tuku omaa to mee ko Yesus mee ebea-ebea. ");
INSERT INTO auu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wa kaa too mée daba daagimaa peeyaa. Epoo to miyoo, magaa da kaa kiyoo apanaa ekaa yago mée ena ma mée maniino taa, kisee inii daba mé