﻿USE sofia;
DROP TABLE IF EXISTS sofia.aui_vpl;
CREATE TABLE aui_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aui_vpl WRITE;
INSERT INTO aui_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ghuyoghuyone na, God abama da kubura ibera. ");
INSERT INTO aui_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kubura na kanakita gegha torewiikayokayowanina bi kwebuna, wiididibara rarima wautapudi isowomumudi, bi God kanumina rarima wowodigha iyaghanoghanowa. ");
INSERT INTO aui_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Bi God iwona bo, “Yeghana nama inarumaghatara” da yeghana irumaghatara. ");
INSERT INTO aui_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God yeghana ikita da imiise; na yeghana da wiididibara ivibogabogaedi. ");
INSERT INTO aui_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God yeghana ikwatuveni Raghani bi wiididibara ikwatuveni Nubabasu. Ravidi inagho bi didibara ipiika - gabudara dagudaguna. ");
INSERT INTO aui_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Wasina bi God iwona bo, “Taraboga nama rarima basune da inibogabogaedi.” ");
INSERT INTO aui_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bi God taraboga ibera da rarimina ivibogaedi da bata situbugha. Bi tarabogine ibera, da rarima rogune bi kiidamove. Na itubugha. ");
INSERT INTO aui_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Taraboga kiidamove ikwatuveni Abama. Ravidi inagho bi didibara ipiika - gabudara wiibatana. ");
INSERT INTO aui_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Noko murine God iwona bo, “Rarima abama rogune gawara tanagha initaghomi, bi tanawa kanakanana inarumaghatara,” na itubugha. ");
INSERT INTO aui_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Bi God tanawa kanakanana ikwatuveni Kubura bi rarima wiiwiitaghomidi ikwatuveni Yegii. Na God ikita da imiise. ");
INSERT INTO aui_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Bi noko murine God iwona bo, “Kubura sawara bogaebogae inigogodi, pei kiidi, da kiiuwa kiidi mma kubure sinagogo bi sinuwagha da ere peidi. Yadi tubugha nunudigha,” na itubugha. ");
INSERT INTO aui_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Wasina bi kubura kiiuwa bogaebogae ivigogodi, yadi tubugha nunudigha na God ikita da imiise. ");
INSERT INTO aui_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ravidi inagho bi didibara ipiika - noko gabudara wiiarobina. ");
INSERT INTO aui_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Bi God iwona magha bo, “Yeghana abame sinarumaghatara bi raghani da nubabasu sinibogabogaedi, bi toudi sinimatakira da raghani meyani gabudara, bodu da kwamra sinadagu, ");
INSERT INTO aui_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","bi abame sinakarata da kubura yeghana sinavereni,” na itubugha. ");
INSERT INTO aui_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Na God yeghana ghamadi bata iberadi - gabudara raghani inibadeni bi nawaravi nubabasu inibadeni, bi kate bada kewokewo iberadi. ");
INSERT INTO aui_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Na mmkodi abame itoredi na yeghana kubura sinavereni, ");
INSERT INTO aui_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","da raghani bi nubabasu sinibadedi, na yeghana wiididibarama ivibogaeni. Bi God ikita da imiise. ");
INSERT INTO aui_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ravidi inagho bi didibara ipiika - noko gabudara wiiruwamaruvina. ");
INSERT INTO aui_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Wasina bi God iwona bo, “Sawara yawayawiidi bogaebogae rarima sinibonuvi bi manu kiidamo sinibonuvi.” ");
INSERT INTO aui_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Na God yegii ighanidi ghamanakidi da gisigisidi mekodi rarime samakamake na iberadi, yadi tubugha nunudigha, bi kate bada manu roworowoyidi tupadi yadi tubugha nunudigha. Bi God ikita da imiise. ");
INSERT INTO aui_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Na ivimiiseyedi bi iwonedi bo, “Ighana kovituwa wiipeyara da yegii konibonuvi bi manu bada kovituwa wiipeyara kiidamove.” ");
INSERT INTO aui_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Na ravidi inagho bi didibara ipiika - noko gabudara wiiimiikovina. ");
INSERT INTO aui_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Wasina bada God iwona bo, “Kubura ribiribi bogaebogae initubuyidi, yadi tubugha nunudigha: ananamanidi da gegha ananamanidi, ghamanakidi da gisigisidi” na itubugha. ");
INSERT INTO aui_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bi God awaki tupadi iberadi, na ikita da imiise. ");
INSERT INTO aui_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Wasina bi God iwona bo, “Bi katana wawaya tanabera mekeyudae, naboni touda mayimayiyida bi toudi kubura tupana sinibadeni da kate ighana, manu kiidamove, ribiribi tupadi, ananamanidi da gegha ananamanidi, ghamanakidi da gisigisidi, bi kate sawara mekodi tanave sasasadi.” ");
INSERT INTO aui_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Na God wawaya ibera tounamani mekeyune, da touna naboni. Tomogha da wasike iberadi. ");
INSERT INTO aui_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Wasina bi God ivimiiseyedi bi iwona wiiyoyowanedi bo, “Kovituwa da natunatumi sinakoroto, da kubura konibonuvi da konakoyayi, bi yegii ighanidi da manu kiidamove bi kate ribiribi tupadi mekodi tanave sasasadi konibadedi.” ");
INSERT INTO aui_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Bi God iwona bo, “Tagu kii tupadi ere peidi da kiiuwa ere peidi bogaebogae avereveremi da toudi tami kamikam, mmko kuburina debane, ");
INSERT INTO aui_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","bi kubura ribiribidi tupadi da kiidamo manudi da kate sawara yawayawiidi tupadi mekodi tanave sasasadi - kiimatagha uwadi avereveredi kadikam,” da itubugha. ");
INSERT INTO aui_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Wasina bi God sawara tupadi ibera na ikita da imiise kirakii. Ravidi inagho bi didibara ipiika - noko gabudara kana wiisix. ");
INSERT INTO aui_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Na mmkona metagha God abama da kubura iberadi bi kate sawara tupadi yawata ivitubuyidina ivikovini. ");
INSERT INTO aui_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Na God awaki iyaberaberana ikabitore, bi gabudara kana wiiseven na yana bagibagi tupadima iviyawiitaveyana. ");
INSERT INTO aui_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Bi gabudara kana wiiseven ivimiiseyeni da ririmonina, basuna noko gabudarine awaki bagibagina iyaberaberana tupana ikabitore bi iviyawiitaveyana. ");
INSERT INTO aui_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Wasina bi Yawe God tanawa dobodobona ikabi da tomogha ibera bi yawa-yawiina gigha bonayine iuvenarughuveni, na tomoyina irupapara. ");
INSERT INTO aui_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Bi Yawe God raghani matane, Eden kubura kamone kwabu tana ikabununayi; da name tomoyina iberana itore. ");
INSERT INTO aui_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Bi noko gawarine ibera da dobodoboma kii warawaratetedi sigogo - kadi kita sivinuwakayowana bi kadi kam simiise. Tanavina basukiine na kii bata, yawa verevereyana kiina da akowa verevereyana kiina meko wawaya uwana sinakani na akowa sinakabi awaki miisena da berona. ");
INSERT INTO aui_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Wasina bi Yawe God - tomoyina ikabi da Eden kwabuna kamone itore da iyabigeni bi iyakoyayi. ");
INSERT INTO aui_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Bi Yawe God - tomoyina iwonawiiyoyowani bo, “Kwabu kamone kii tupadi uwadi na kunakam, ");
INSERT INTO aui_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bi kii meko wawaya inaberadi da awaki berona da awaki miisena sinakovina gegha uwana kunakanina, memeda uwana kunakanina rotomanina tam kunarabobo.” ");
INSERT INTO aui_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Bi Yawe God iwona bo, “Mmkona gegha iyamiise da tomogha tanaduma inamakena. Kana gwabigwabiyana anabera da iniwiiteni.” ");
INSERT INTO aui_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wasina bi tanawa dobodobo nama kwabu ribiribidi tupadi da kiidamo manudi tupadi iberadi. Bi kate ipiikedi bi iyakita da metagha tomoyina iyiwaghawaghayedi; bi metagha ribiribi tupadi iviwaghawaghayedi na wasina kadi waghawagha naboni. ");
INSERT INTO aui_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Na tomoyina ribiribi tupadi, kiidamo manudi da kate ribiribi tupadi gegha ananamanidi iviwaghawaghayedi, bi gegha ribiribi tana rubana da tomoyina iyagwabiyeni da kanawiiwiita. ");
INSERT INTO aui_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Na Yawe God ibera da tomoyina ikenayakuka, bi raghanina iyakenakenana, ghabaghabana irikena tana ikabitaveni bi gawarina vighoma igudu. ");
INSERT INTO aui_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Wasina bi Yawe God tomogha ghabaghabana irikena ikabitavenina tounama wasike ibera, bi ikabi ipiikeni tomoyina biidi. ");
INSERT INTO aui_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Na tomoyina iwona bo, “Eka! Katada tagu mayimayiyigu - irike tagu irikeguma, bi vigho tagu vighoguma, na kana waghawagha Wasike, basuna touna tomogha gwabinama ikanibu.” ");
INSERT INTO aui_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Na noko kiiravine tomogha tamananaki da sinananaki inakuyovedi bi inanagho wavinena teya sinikapudi, da toudi tubugha tanagha. ");
INSERT INTO aui_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Bi tomoyina wavinena teya na ighanidigha, bi gegha siyisinimayaghana. ");
INSERT INTO aui_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Wasina bi mota touna wiiyaba iyakowa kirakii gegha ware ribiribi dipa mekodi Yawe God iberadina naboni. Bi raghani tana mota ipiika da wasikena iwoneni bo, “Wiisuwona God iwona da, ‘Mmko kwabuna kamone kii tupadi uwadi gegha konakamna?’” ");
INSERT INTO aui_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Na wasikena mota iwonenabodeni bo, “Gegha, toumii kii tupadi mmko kwabuna kamone uwadi kanakam, ");
INSERT INTO aui_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bi God iwonemii bo, ‘Kii kwabu basukiine yamiimiirina uwana gegha konakanina, da konakabitowoyina, bi konaberana konarabobo.’” ");
INSERT INTO aui_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Na mota iwona bo, “Noko wiiyaba, kate gegha konarabobona! ");
INSERT INTO aui_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God noko iwonenina, basuna iyakovi da raghanina uwana konakanina inaberami da matami sinaruyeghana, da tami naboni God na awaki miisena da berona na konakovi.” ");
INSERT INTO aui_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Na wasikena ikita da kii uwana kanakam ivinuwakayowana bi kiina ivimatakonakona, da kate kiina nuwagiura iyavereni, na uwana mududi iyouna bi ikam; da kate mududi moghanena nama yawata na ivereni, da touna bada ikam. ");
INSERT INTO aui_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Wasina bi yadi batabata matadi siruyeghana, da sakowa bi sinoghota da ighanidigha; na bidogo rugurugudi siwaturatawatawana naboni kwama da sivikasibabara. ");
INSERT INTO aui_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bi ravidi duduvine na tomoyina wavinena teya Yawe God kwabu kamone iyapepepewa na kwarituna siwaiyaneni, na toudi kii dughudughudi kamodiye Yawe God sikowoyeni da gegha iyakitadina. ");
INSERT INTO aui_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bi gegha, Yawe God tomoyina ikwatuwiidagu bo, “Tam meme barasina?” ");
INSERT INTO aui_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tomoyina iwonabodeyana bo, “Kwabu kamone kuyapeepewa na awaiyanem bi anaghara kiiravine na akowogha, basuna tagu ighanigugha.” ");
INSERT INTO aui_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Na Yawe God iwona bo, “Iiyabo iwonem da tam ighanimgha? Bo noko kiina uwana meko avigesiyem da gegha kuyakani na kukani?” ");
INSERT INTO aui_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tomoyina iwona bo, “Wasike gwabiguve kutore na touna kiina uwana iveregu na akani.” ");
INSERT INTO aui_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Wasina bi Yawe God wasikena iwoneni bo, “Mmko awaki berana tam kubera?” Na wasikena iwona bo, “Mota iviyabegu na uwana akani.” ");
INSERT INTO aui_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Na Yawe God mota iwoneni bo, “Tam mmko berana kubera kiiravine na aro kunakabi; ribiribi tupadi ananamanidi da gegha ananamanidi kamodiye, na tam kawagha aro kunakabi: kata da nabo inagho na tam dobodobo debanagha kamokamomma kunasasa, bi popoku kunakamkam yam yawa kamone. ");
INSERT INTO aui_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Bi anaberam da wasike teya nonowa koninuwapughu kabivivirana; kate anabera da touna nosinosina da tam nosinosim nonowa siniaviya. Touna nosina gayamim initugudaguda bi tam touna nosina kayegiduna kunarutarayi.” ");
INSERT INTO aui_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Bi kate wasikena iwoneni bo, “Tagu yam ropeya nuwapoyina aniragasi da sinivisi teya bi simira gisigisi kuni tubuyi. Bi yam wiina da moghanem kuni badeni, bi gegha, da touna tam inibadem.” ");
INSERT INTO aui_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Bi kate bada tomoyina iwoneni bo, “Wavinem gamona kukabisisireni da kii uwana kukani, meko avitarababaranem awona bo, ‘Gegha uwana kunakani, na noko biidi tam yam bera kiiravine na mmko tanavina iimimagi. Bi yam yawa tupane na sinivisiye kunabagibagi bi kunawawa kunakam. ");
INSERT INTO aui_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Bi tanavina dinamona iyiyodi da modimodidi inigogodi yam kwabu kamone kiiravimve, bi karayaba dipa kunakam. ");
INSERT INTO aui_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Bi bada kunabagibagi kirakii kukuma inaturim da kamkam kunabanani, patana da kunaveramagha dobodobove, basuna tounama kutubugha. Na tam dobodoboma kutubugha kiiravine, na bada kunidobodobo magha.’” ");
INSERT INTO aui_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Wasina bi Adam wavinena iviwaghawaghayeni Eve, basuna touna wawaya tupadi kiiravidiye na katare inisinada. ");
INSERT INTO aui_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bi Yawe God ribiribi ghunighunidima kwama ibera Adam wavinena teya kiiravidiye, bi ivikotedi. ");
INSERT INTO aui_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Wasina bi Yawe God tounamani iwonena mayeni bo, “Aa, katana tomogha touda naboni, na iyakowa da awaki miisena bi berona. Na touna gegha wiiwaghasina inakabi da imana inakoghasi bi kii meko yawa yaverevereyana na uwana inakiyapuri da inakanina, kate bi inamake waghata.” ");
INSERT INTO aui_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Na Yawe God noko kiiravine tomoyina wavinena teya Eden kwabunama ivikanibuvedi da dobodobone inawawa mekonama touna itubughana. ");
INSERT INTO aui_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Wasina bi Yawe God iviporadi bi murine, na Eden kwabune raghani matane serubim ivikoyayidi bi kate seri wiibububuna wiikuwamiwamirina, nabo da mabo itore da yawa verevereyana kiina kana keda sinakoyayi bi sinitarababareni, da wawaya kiine gesiyapiikana. ");
INSERT INTO aui_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam, wavinena Eve teya sivimumurana, da iropeya bi ivituwa da Kein itubugha. Na Eve iwona bo, “Yawe God yana wiiwiita kamone natugu tomogha avitubuyi,” na kana waghawagha ikwatuveni da Kein. ");
INSERT INTO aui_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Bi muriye ivituwa magha da natuna ivibata bi ikwatuveni da Eibol. Bi sivimagura murine, Eibol, na ribiribi kadi waghawagha sip iyakoyakoyagha, bi Kein na kiiuwa iyawawawa tarana kamodiye. ");
INSERT INTO aui_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Raghani tana, Kein yana kiiuwa muduna ipiikedi da Yawe God biidi isuwara, ");
INSERT INTO aui_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","bi Eibol na yana ribiribi kamodima nigenige mududi iyiyarokodi ivikasunughana bi taridi miisedi ipiikedi da Yawe God biidi isuwara. Yawe God na Eibol yana suwara teya kiiravine iviwaghasineni, ");
INSERT INTO aui_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","bi Kein yana suwara teya kiiravine na Yawe God gegha iyiwaghasineni. Na Kein nuwanuwana ipughu kirakii, bi ibera da mayiyina ibero da touna ivinuwapoya. ");
INSERT INTO aui_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Wasina Yawe God, Kein iwoneni bo, “Awaki biidi nuwanuwam ipughu? Awaki biidi mayiyim kanakita ibero? ");
INSERT INTO aui_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Memeda bera miisedi kuyaberabera na ayiwaghasinem. Bi meboda bera beroberodi kwaberabera na, kukita yapori! Basuna berona nama ririmve, ikowogha naboni ware ribiribi dipa yikoyakoyagha da tam inagogonakurim. Yana wiina da inibadem, bi tam kunimaragata da kunagetawani.” ");
INSERT INTO aui_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Wasina muriye na Kein tiinaru Eibol iwoneni bo, “Tana kanibu wareregha tana pepewa.” Raghanina toudi name warereye, na Kein tiinaru igogonakuri da ikasunuyi. ");
INSERT INTO aui_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Noko berana murine Yawe God, Kein ivitarakiiyaneni bo, “Tiiru Eibol meme?” Na Kein iwona bo, “Gegha ayakovi da meme. Bi tagu gegha touna kanakoyakoyaghana.” ");
INSERT INTO aui_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Bi, Yawe God iwona bo, “Awaki biidi mmko berana bero kirakiina kubera? Tiiru kukasunuyi, bi akitana iikanighughuveni, da ware ganiganina dobodoboma iyakwatukwatu da kanarabobo biwana kabina biidi. ");
INSERT INTO aui_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Bi katana mma naboni animagim. Tiiru kukasunuyi na ibera da dobodobo ganiganina yasususu, na katana gegha rubana mmko tanavine kunawawana. ");
INSERT INTO aui_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bi katana mmko tanavine kunawawana kate kam gegha miisedi inaveremna. Wasina, kata da nabo inaghona gegha ere yam meyagiina bi tam kedakedagha kunapeepewa wapawapa.” ");
INSERT INTO aui_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Wasina Kein, Yawe God iwoneni bo, “Kagu aro na iragata kirakii da tagu anipiiyeni. ");
INSERT INTO aui_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tam kata mmko tanavinama kuvikanibuvegu da mayiyimma kwiikowoyigu. Da tagu anikedakeda mmko kuburine, bi wawaya iiyawogha sinabananigu na sinakasunuyigu.” ");
INSERT INTO aui_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Wasina Yawe God iwonena bo, “Gegha tana! Iiyabo inakasunuyimna, wiisuwona da kambiwa kiiravine, na iiyabo inirabobom na vita ghamakirakiina inakawari.” Bi Yawe, Kein debane matakira ivikarapasi, da iiyabo inabanani na gegha inakasunuyina. ");
INSERT INTO aui_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Bi Adam, wavinena teya sivimumurana magha, da tomogha ivitubuyi. Bi ikwatuveni da kana waghawagha Set, basuna Eve iwona bo, “God, wawaya tana iveremayegu da Eibol kana wiitaparara kiiravine, basuna Kein tiinaru ikasunuyi.” ");
INSERT INTO aui_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Wasina bi Set bada ivituwa da natuna tomogha itore, bi ikwatuveni da Inosi. Noko raghanine Inosi iyamakamakena, wawaya sidagu Yawe God siyakabekabepepi. ");
INSERT INTO aui_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yawe God ikita da wawaya yadi bera beroberodi iragata kirakii, bi bada awaki nonowa siyanoghonoghota, bo awaki siyigiugerogerora na ibero kirakii. ");
INSERT INTO aui_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Na noko kiiravine Yawe God ivinuwabero bi inoghota da wawaya mmko kuburine itoredi, na kiiravine ivinuwapoya. ");
INSERT INTO aui_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Bi iwona bo, “Wawaya tupadi mmko kuburina debane anagigirataveni, iinuwapoya da aberadi. Na noko kiiravine tagu, wawaya tupadi da ribiribi ghamadi da gisigisidi, sasasadi mmko kuburina debane da manu tupadi kiidamove saroworowogha na aniberodi.” ");
INSERT INTO aui_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bi Nowa kabikuwaye imake yapora na Yawe God ivinuwamiise touna biidi. ");
INSERT INTO aui_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nowa, natunatuna teya waragututudi naboni: Nowa kawagha na tomogha kabikabikuwayina bi kate gegha ere yana berona mmko kuburine nokodi raghanidiye, na God yawata siyiturana yapora. Touna ivituwa da natunatuna yadi aroba, kadi waghawagha Sem, Hem da Jeipet. ");
INSERT INTO aui_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Bi kata God mmko kuburina ikita da ibero kirakii bi wawaya meghamegha na wiikayotaketowana kamone siyamakamake. ");
INSERT INTO aui_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God ikita da wawaya tupana yawa beroberodi kamodiye siyamakamake na mmko kuburina sivibero kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Na God, Nowa iwoneni bo, “Wawaya yadi berawapawapae na kubura tupana sivibero kirakiiyeni, noko biidi awiiwiini da wawaya tupana nama samakamake na aniberodi. Bi kate sawara tupadi mmko kuburine bada anagigiratavedi. ");
INSERT INTO aui_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Bi mmkona awaki kunabera: Waga ghamanakina kiiravimve kunayoghani. Kii maragasidi bi kakokakodima kunayoghani. Kamona tupana kunatupayarayarayi. Bi wagana kubuna da kamona pakima kunapasidi. ");
INSERT INTO aui_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Naboni kunayoghani: da yanaguri 140 mitas, yananaba 22 mitas, bi yanagae 14 mitas. ");
INSERT INTO aui_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Bare kubu kubera, bi bonagha gegha ghamadi bare kubu bi papa basudiye kunabera da wagana kunikenavivivireni. Waga papana nawanawane matamketa kutore. Bi wagana kamone na kawii guridi aroba kuberadi: Tana wowone, tana basune bi tana rogune.” ");
INSERT INTO aui_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","God iwona bo, “Kuwaiyana, tagu kutukutuwa ghamana anipora da mmko kuburina tupana inakutuvi, bi sawara tupana yawayawiidi bo samakamakena iniberodi. ");
INSERT INTO aui_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bi yagu wiisuwona ghamana gwabimve atoretore. Tam, wavinem, natunatum, da natunatum natuwavinedi yawata tupami wagae konarughu. ");
INSERT INTO aui_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ribiribi mayiyi bogaebogae batabatighate wagae kunuwana, tam yawata. Manu tomoyina tana da wasikena tana bi ribiribi ghamanakidi bada naboni, bi kate ribiribi gisigisidi sasasadi tupadi, da yawayawiidi sinamake. ");
INSERT INTO aui_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Bi kate kam bogaebogae kunuwana kiiravimve, yam rakaraka, da ribiribi tupadi kiiravidiye.” ");
INSERT INTO aui_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Wasina Nowa bera tupana metagha God iwonenina naboni ibera. ");
INSERT INTO aui_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yawe God, noko kiiravine Nowa iwoneni bo, “Yam rakaraka yawata wagae korughu, basuna akita da wawaya tupadi kamodima na tam kabikuwaya kirakiim. ");
INSERT INTO aui_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Bi ribiribi miisedi tupadi mekodi iiwaghasinem na makidi yadi seven bi yagaridi bada yadi seven kunakabidi. Bi nokodi ribiribi dadabudi na bata kawagha kabidi - makina da yagarina. ");
INSERT INTO aui_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Bi kate bada manu roworowoyidi tupadi bogaebogae kuyouna, tomotomoyidi yadi seven bi kadi wiibatabata wasiwasikedi yadi seven. Mmko kunabera na ribiribi da manu bogaebogae tupadi mmko kuburine sinamake bi sinituwawiipeyara magha. ");
INSERT INTO aui_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bi gabudara yadi seven murine na, amra aniporani inayowogha da mmko kuburine inakiyara da gabudara 40 da nubabasu 40, bi mmko kuburina debane sawara tupadi yawayawiidi aberadi na anagigiratavedi.” ");
INSERT INTO aui_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Wasina Nowa bera tupana metagha Yawe God iyawonewonenina ibera. ");
INSERT INTO aui_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kutukutuwa inowiiwoneni da gabudara 40 na, rarimina isisiragasi da iviwautapu na waga irutenam igae da kubura igetawani. ");
INSERT INTO aui_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Wasina bi, Yawe God mmko kuburine sawara tupana iviberodi. Wawaya tupadi, ribiribi ghamadi da sasasadi da manu roworowoyidi tupadi sirabobo. Wasina Nowa, yana rakaraka bi ribiribi bogaebogae da manu tupadi nama waga kamone na toudi kawagha simakae. ");
INSERT INTO aui_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Na God ivisisiya Nowa biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wavinem, natunatum da natuwavinedi teya waga kokanibutaveni koyowogha. ");
INSERT INTO aui_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sawara yawayawiidi tupadi yawata kabitavedi sinayowogha - manu, ribiribi da mekodi tanave sasasadi - da sinituwa wiipeyara da mmko kuburina tupana sinibonuvi.” ");
INSERT INTO aui_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Wasina, Nowa, wavinena, natunatuna da natuwavinedi teya waga sikanibutaveni. ");
INSERT INTO aui_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bi kate ribiribi tupadi, manu da mekodi sasasadi kadirokone waga sikanibutaveni bada siyowogha. ");
INSERT INTO aui_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Wasina bi Nowa, suwara gibugibu gawarina ibera bi ribiribi da manu miimiisedi mekodi Yawe God iviwaghasinedi suwara kiiravinena, yadi tubugha nunudigha tatadigegha iyouna bi ere tupadi igibu da Yawe biidi isuwara, suwara gibugibu debane. ");
INSERT INTO aui_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Raghanina Yawe God mmko suwarina pughuna imaghani da ighabu, na nuwanuwana kamone iwona bo, “Akovi da wawaya na ededa raghanine noghota berodi nuwanuwadiye sanoghonoghota na sadaguni, bi Tagu kate gegha meyani mmko kuburina anakasiwiibero mayenina, bagune akovi da wawaya awaki siberana. Bi bada kate gegha sawara yawayawiidi aniberodi da ware kata aberana naboni. ");
INSERT INTO aui_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Raghanina kubura inamakamakena, wawa da yaba, bodu da kwamra, kiyara da gabudara raghani da nubabasu, sinanagho wiikarukaru, da gegha sinakovi.” ");
INSERT INTO aui_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Wasina bi God, Nowa da natunatuna teya ivimiiseyedi bi iwonedi bo, “Kovituwa da yami koroto inaragata bi mmko kuburina tupana konibonuvi. ");
INSERT INTO aui_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bi ribiribi ghamadi, gisigisidi bi sasasadi mmko kuburine, bi manu da kate ighana, anaberadi da tami sinanagharena kirakiiyemi. Bi tupadi na konibadedi. ");
INSERT INTO aui_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sawara yawayawiidi tupadi na kamikam. Ware naghove kii matagha uwadi averemina naboni, bi katana sawara tupadi avereveremi da kamikam. ");
INSERT INTO aui_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bi tami iyuwa ere ganiganina gekonakani, basuna ganigani touna yawa kayena, bi memeda kanina konawiinina ganiganina inadiororotaveni bi muriye konakani. ");
INSERT INTO aui_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Bi ribiribi tana wawaya inaburavi na noko ribiribina aro inakabi. Bi mmko naboni, memeda iiyabo wawaya turana inakasunuyi, na tagu, noko wawayina aro anavereni. ");
INSERT INTO aui_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tagu, God, wawaya aberadi da mayimayiyigu noko kiiravine iiyabo wawaya turana tana inakasunuyi na touna wawayina sinakasunuyi. ");
INSERT INTO aui_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bi kata tami, kovituwa bi yami koroto inaragata da mmko kuburina tupana konibonuvi.” ");
INSERT INTO aui_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Wasina God, Nowa, natunatuna teya iwonedi bo, ");
INSERT INTO aui_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kowaiyana, mmko raghanine yagu wiisuwona tami biidi atoretore bi bada raghani murine nosinosimi kiiravidiye ");
INSERT INTO aui_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","bi kate ribiribi yawayawiidi mekodi tami yawatana - manu, meyagii da garagara ribiribi tupadi - kate mekodi tami yawata wagama kokanibuna, tupadi raghani murine mmko kuburine sinamake na kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Yagu wiisuwona tami gwabimiye atoretore, da gegha meyani kutukutuwa tana anawona inatubugha da sawara tupadi yawayawiidi inirabobodi, bi kate mmko kuburina iniberona.” ");
INSERT INTO aui_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Bi God iwona bo, “Mmkona wiisuwona matakirina tagu bi tami basudaye, da sawara tupadi yawayawiidi kiiravidiye raghani muriye. ");
INSERT INTO aui_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yagu wurere, uwaye anatore da wiisuwona inimatakireni da tagu bi sawara yawayawiidi kiiravidiye mmko kuburine. ");
INSERT INTO aui_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Raghani nonowa abama, karekarewama anasowo bi wurere inarumaghatara na uwaye konakita, ");
INSERT INTO aui_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","bi inabera na ananoghosi da yagu wiisuwona matakirina tagu bi tami da sawara yawayawiidi tupadi biidi, na gegha muriye kutukutuwa yawa tupana iniberona.” ");
INSERT INTO aui_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Dagudagune, na wawaya tupana mmko kuburine na yadi gamo tanagha, bi sisiyidi mayimayiyidi siyisisiya. ");
INSERT INTO aui_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Noko raghanine na wawaya sivikedakeda raghani matana kubure sitaveyana, da gawara tana ruwiipikapikana sibanani Sainai kubure da name sikwanatu bi simake. ");
INSERT INTO aui_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Bi toudimani sivisisiya da siwona bo, “Kopiika, dobodobo tana youna tana kabiwiipakipaki brik tanabera bi tanagibu da sinakakokako.” Bi naboni sibera, da toudima bare siyayoghana akima wasadi bi pakima siyapasi da siyakabitawana. ");
INSERT INTO aui_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Bi toudimani siwonena mayedi bo, “Kwanatu ghamana kiiravidaye, bi bada bare tana teya tanayoghani inagee kirakii inanagho abame. Naboni tanabera da kada waghawagha inaragata bi gegha mmko kuburine tanimosaredana.” ");
INSERT INTO aui_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Bi gegha Yawe God iyowogha da, kwanatuna da barena geekirakiina yawata, mekona wawaya siyayoghayoghani na iyakita. ");
INSERT INTO aui_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Bi iwona bo, “Meboda mmko na dam tanagha bi gamo tanagha sisisiya. Bi kata mmkodi beradi sidagu sinabera na raghani muriye na awaki sinawiiwiini berana, rubana sinabera. ");
INSERT INTO aui_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Noko biidi, tanayowogha da yadi gamo tanawamiri bi sininagonagowana kabivivirana.” ");
INSERT INTO aui_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wasina Yawe God ikasiwiimosaridi na sivibogabogae kubura tupane da kwanatuna siyayoghayoghanina sikabitore. ");
INSERT INTO aui_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Wasina, noko kiiravine kwanatuna sikwatuveni da Babel, basuna Yawe God name, wawaya tupana yadi gamo iwamiri, bi bada name ikasiwiimosaridi da sivibogabogae kubura tupane. ");
INSERT INTO aui_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bi Yawe God mma naboni, Abram iwoneni, “Yam kwanatu, yam dam da yam rakaraka kukuyovedi bi kunagho da gawara tana avineyina bi muriye aniyevevemna nabo. ");
INSERT INTO aui_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Da nosinosim korotodi anaverem bi sinituwa wiipeyara da yadi koroto inaragata. Bi animiiseyem da kam waghawagha inaragata da wawaya sinakabikarawayem. Bi tamve na wawaya bada miisena sinakabi. ");
INSERT INTO aui_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Raghanina wawaya sinimiiseyem na, animiiseyedi. Bi memeda wawaya sinisisiya berovem na, tagu aro anaveredi. Tamve na dam tupadi, mmko kuburine animiiseyedi.” ");
INSERT INTO aui_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Noko raghanine Abram kana bodu 75, bi wasina metagha Yawe God iwonenina naboni ibera, touna, wavinena Serai bi tiinaru natuna, Lot, Haran kuburina sikuyoveni. Yadi sawara tupadi sikawara da ribiribi bi yadi wiibagubagurana wawayidi Haranne siyounana, da Kenen kubure sitouya sinagho. Bi sipiika kubura kana wiibarabarate, ");
INSERT INTO aui_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","na Abram, yana dam teya noko kuburina sipepewa rughuwoneni sinagho gawara tana, Sikem kwanatuna ririne. Bi name tomogha kana waghawagha More yana kii ghamanakina ririne sivitaki. (Noko raghanine na Kenen damdi patana nama siyamakamake). ");
INSERT INTO aui_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Name Yawe God ivimaghatara mayeni Abram biidi bi iwona bo, “Mmko, Kenen tanavina tam nosinosim anaveredi.” Na Abram, suwara gabugabuna gawarina ibera, meme Yawe ivimaghatara mayenina gawarine. ");
INSERT INTO aui_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Noko raghanine, na Lot patana Abram teya siyapeepewa. Bi yana sip da kau na peyaridi bi yana rakaraka da wiibagubagurana. ");
INSERT INTO aui_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Toudi ribiribi sivirapeneyana na sipeyara kirakii da kadikam gegha rubana, bi kate yadi bata na gerubana da gawarina tanagha siyamakena. ");
INSERT INTO aui_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Na Abram, Lot iwoneni bo, “Kuwaiyana, touda rakarakada bi gegha tanikawakereyana, bi yada ribiribi kadi koyakoyagha bada gegha sinirouwa kabivivirana. ");
INSERT INTO aui_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Wasina tani bogabogae bi tananagho gawara mududiye tanamake. Noko kuburina naghodaye kukita, meko nawana kunawiiwiini na kuvineyi, da kunagho name kunamake. Memeda katiiyamve kunanagho na, tagu dugemve ananagho. Bi dugemve kunanagho na, tagu katiiyamve ananagho.” ");
INSERT INTO aui_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nokona Yawe God, Sodom da Gomora kwanatudi gegha iyiberodi raghanine, bi muriye iviberodi. Wasina bi Lot ikayogagawa bi ikitawiivera da Jodan tanavina ruwiipikapikadi tupana ikita, patana da Jor kwanatune na ere rarimidi bi moumouridi ware Yawe God yana tarana Iden kwabuna mayimayiyina, bo Ijiptne tanawa miisedi naboni. ");
INSERT INTO aui_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Na Lot, Jodan rarimina ririne, tanawa ruwiipikapikana tupana ivineyi kiiravine bi yana wawaya teya raghani matane sitaveyana. Bi mmko kedane, sivibogabogae. ");
INSERT INTO aui_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram, Kenen kubure ikwanatu, bi Lot, kwanatu viya ruwiipikapikaye riridiye imakeyowogha, bi Sodom ririne ivitaki. ");
INSERT INTO aui_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom damdi yadi bera ibero kirakii, bi bera berokirakiidi Yawe God matane siyaberabera. ");
INSERT INTO aui_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot, aghunanaki ivibogaeni bi murinena, Yawe God, Abram iwoneni bo, “Kukita wiiveravera yapoyapora inanagho da meme matam inatupona. ");
INSERT INTO aui_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mmko tanavina kwakitakitana tupana, tam da nosinosim teya anaveremi, da konirapenena waghasi. ");
INSERT INTO aui_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nosinosim korotodi anaveremna gegha rubana da wawaya sinakabiyawa, naboni ware egha mmko kuburine, na gegha tana iiyabo rubana da nosinosim inakabiyavidina. ");
INSERT INTO aui_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Mmko tanavina tupana tam avereverem, na wasina kunagho, kunapepewa wiikenavivireni bi kunakita yapoyapori.” ");
INSERT INTO aui_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Wasina Abram itouya ikanibau da Hebron kubure, Mamri yana kii kabikabikarawayidi gwagwaridiye ivitaki. Bi name suwara gabugabuna gawarina tana ibera da Yawe God iyapepeteni. ");
INSERT INTO aui_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Kiikiiwawo ruwamaruwa yadi wawaya yawata, Sodom da Gomora damdi yadi sawara tupadi sikawara, da kadikam yawata. Bi kate Abram, tiinaru natuna, Lot, na Sodomne iyamakamake na sirutayini da yana sawara yawata sikawara, bi sitouya sinagho. ");
INSERT INTO aui_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Bi tomogha tana wiirouwa kamonama ivikanibu iveraipiika Abram biidi, da awaki wiirouwa kamone itubugha na tupana iwoneni, bi noko raghanine na Abram, touna Hibru tomogha, bi Amori dam tomogha kana waghawagha Mamri yana kii kabikabikarawayidi gwagwaridi riiridiye iyamakamake. Bi Mamri yana rakaraka Iskol da Ena yawata na Abram teya siyitoghatii, bi wiiwaghasina sibera da wiirouwa raghanine na siyiwiita kabivivirana. ");
INSERT INTO aui_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Na raghanina Abram iwaiyana da kiikiiwawo ruwamaruwa, natunaru Lot sirutayini na yana wiiyogha tomotomoyidi yadi 318 nama yana dam kamone situbugha siyamakamakena ikwatu wiitaghomidi bi kiikiiwawo ruwamaruwa yadi wawaya yawata sirukwavinidi sinagho patana da Dan kwanatune. ");
INSERT INTO aui_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nubabasuve na Abram yana wiiyogha tomotomoyidi iyarayidi ribayeribaye, bi keda bogaebogaema sigogona kiikiiwawo ruwamaruwa yadi wawaya yawata biiyadi da sigeiwayidi. Bi siverataveyana na sirukwavinidi sinagho patana da kwanatu kana waghawagha Hoba, nokona Damaskas kwanatuna bi nabo. ");
INSERT INTO aui_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Da sawara siyapina tupadi bi kate natunaru Lot na yana sawara iyouna magha bi bada yawata na wasiwasike da wawaya iiyawogha kiikiiwawo ruwamaruwa yadi wawaya yawata sirutayinidina iviveramayidi. ");
INSERT INTO aui_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Wiirouwa murine Melkisidek, Salem kwanatuna kana kiiwawo bi God Kiidamo Kirakiina yana prist, Abram verabodenina biidi, na bred da wain ikawara ipiika bi ivereni. ");
INSERT INTO aui_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Bi ivimiiseyeni mma naboni iwona, “Abram, God Kiidamo Kirakiina, iiyabo abama da kubura ibera, na inimiiseyem. ");
INSERT INTO aui_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","God Kiidamo Kirakiina, iiyabo iviwiitem da kam aviya kugeiwayidi na tanakabepepi.” Wasina, Abram sawara aviya damdi gwabidima iyouna, na riba yadi ten iberadi, bi tanaikabitaveni da Melkisidek ivereni. ");
INSERT INTO aui_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Raghani muriye Yawe God mimeu kamone Abram biidi ivisisiya iwona bo, “Abram, gegha kunanagharana. Tagu na kam babara, bi puyo ghamanakina anaverem.” ");
INSERT INTO aui_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Bi Abram, iwona bo, “Yawe God yagu Bada, tagu natunatugu gegha bi yam puyo ghamanakina kate gegha iniwiiteguna. Tam gegha natugu tomogha kuyavereguna, bi anarabobo murine, na Damaskas tomogha kana waghawagha Eliyesa, yagu wiibagubagurana, buderigu tupana inayouna.” ");
INSERT INTO aui_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Wasina bi Yawe God, Abram iwonena mayeni bo, “Gegha, noko tomoyina buderim gegha inayouna, bi natum tomogha tam gwabimma inatubugha, na buderim tupana inayouna kuna rabobona murine.” ");
INSERT INTO aui_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Bi Yawe God, Abram irutayini sikanibu maghatare bi iwoneni bo, “Kayogagawa abame bi kuberatowoyi da kewokewo kunakabiyawa - Memeda tam rubana na! Raghani muriye na nosinosim na naboni ware mmkodi kewokewodi bi getana iiyabo rubana da inakabiyavidina.” ");
INSERT INTO aui_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram, Yawe God yana sisiya ivigeruveni na Yawe God matanama ikita na iviwaghasineni iwona, da Abram na gegha awaki berona tana gwabinena. ");
INSERT INTO aui_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Gabudara iyayoyo, na Abram ikena yowogha da ikenayakuka, na wiididibara da kumararagha ipiika na mimeu ikita na iyarewarewa. ");
INSERT INTO aui_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Bi Yawe God ivisisiya touna biidi iwona bo, “Mmko kwakowa yapori! Nosinosim na kubura wiibate sinibaretaya mekona gegha rapediyena. Bodu 400 kamodiye na noko kuburina damdi sinakabidi da kiiravidiye sinabagibagi bi bada sinitupaketowanedi. ");
INSERT INTO aui_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bi noko kuburina damdi, iiyawogha kiiravidiye sinabagibagiyedina, raghani muriye nosinosim kadi biwa nokodi damdi gwabidiye anakabi da aro anaveredi bi nosinosim kuburina sinikanibutaveni da sawara miisedi peyaridi yawata sinakawara. ");
INSERT INTO aui_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Abram, bi tam, na kunamoraba kirakii bi nuwamiiseye kunarabobo da sinadogum. Bi nosinosim na gegha mmko kuburine sinaveramagha yaininagha, da kimta ruwamaruwa murine bi sinaveramagha, basuna Amori damdi mmko kuburine katana samakamake, bi raghanina yadi makamake yawana inabero kirakiina, noko raghanine aro anaveredi bi anarukwavinidi mmko tanavina sinakanibutaveni.” ");
INSERT INTO aui_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram, wavinena Serai ivigagara da gegha tana iyituvenina, bi gegha da touna Ijipt wasike nada waghata ikabi yana wiitamariyana kana waghawagha Heiga, ");
INSERT INTO aui_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","na Serai, Abram iwoneni bo, “Yawe God ivigagarigu da geayituwa, na kunagho da yagu wiitamariyana yawata konimumurana. Memeda inituwa na noko pepeyina aninatuneni.” Abram, wavinena metagha iwonana iviwaghasineni ");
INSERT INTO aui_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","na Serai, yana wiitamariyana ikabi da moghanena Abram ivereni da naboni iviwowowara, (Mmko berana itubugha na raghanina Abram, Kenen kubure bodu 10 imakae bi murine na). ");
INSERT INTO aui_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Muriye na Heiga, Abram natuna tomogha ivitubuyi bi Abram iviwaghaneni Ismel. ");
INSERT INTO aui_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Raghanina Abram kana bodu 99, na Yawe God, irumaghatara touna biidi bi iwoneni bo, “Tagu God Maragata Kirakiigu. Kaye warubigugha kupepewa da gegha bera berodi kunaberana, ");
INSERT INTO aui_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","na yagu wiiwaghasina tam biidi maragasina anabera da nosinosim gerorina sinakoroto kirakii.” ");
INSERT INTO aui_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ivituwapore oghogheyana da mayiyina iyowogha dobodobo iyakasikasitowoyi na God iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Mmko kuwaiyanena yapori, bi tagu yagu nawae na, yagu wiiwaghasina maragasina tam yawata: Iisuwona da kuninosina dam korotodi kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Anaberam da dam korotodi nosidinaki, noko biidi kam waghawagha awamiwamiri da gegha Abram bi katana Abraham. ");
INSERT INTO aui_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Anabera da kunituwa wiipeyara da nosinosim korotodi anaverem, bi mududina sinikiiwawo. Tam nosinosim sinakoroto kirakii da dam bi dam korotodi sinatubugha. ");
INSERT INTO aui_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Yagu wiisuwona anakabitawani da mmko wiiwaghasina maragasina anabera na makewaghawaghasina tam da nosinosim biiyadi raghani muriye da yam God bi nosinosim muriye bada yadi God. ");
INSERT INTO aui_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kenen tanavina tupana, meko kata kopeepevenina, anavereyana naboni yami sawara makewaghawaghasina tam da nosinosim yawata raghani muriye da tanavina sinirapenena waghasi, bi tagu na yadi God.” ");
INSERT INTO aui_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","God, Abraham iwonena mayeni bo, “Bi tam yam nawae, na yagu wiiwaghasina maragasina kunakabisisireni, da kate nosinosim bada naboni sinakabisisireni. ");
INSERT INTO aui_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Da tami wiiwaghasina maragasina sirana kunakabisisireni da tam kuni sinibori, bi kate nosinosim kamodiye tomotomogha tupadi bada naboni. ");
INSERT INTO aui_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Toudi mayinaghodi matabekadi sinaboritavedi, da noko wiiwaghasina maragasina kana matakira tami da tagu basudae. ");
INSERT INTO aui_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Pepeya tomoyina, inatubugha bi gabudara 8 sinakovi, na yagu matakira naboni gwabine konatore. Natunatumi biiyadi konabera bi bada yami wiibagubagurana natunatudi biiyadi - tomotomogha tupadi yam kunukunu kamone. Wasina bi tomotomogha yam kunukunuve sinatubugha bi kate kunukunu wiibata tomotomogha meme konagimonidi yami wiibagubagurana, na yagu matakira gwabidiye konabori. Noko inimatakira da yagu wiiwaghasina maragasina tubuyimi kamone inamake nonowa. ");
INSERT INTO aui_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Bi meko tomoyina wiiwaghasina maragasina matakirina tubuyine gegha na getagu yagu wawaya, touna yagu wiiwaghasina maragasina ivikasigiiyeni na noko damnama sinikanibuveni.” ");
INSERT INTO aui_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Yawe God, Abraham iwonena mayeni bo, “Wavinem Serai na gemuriye kunakwatuveni Serai, bi kata kana waghawagha na Sera. ");
INSERT INTO aui_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bi animiiseyeni da natum tomogha touna gwabinama anaverem. Animiiseyeni bi inisinada dam korotodi kiiravidiye bi nosinosina kamodima kiikiiwawo sinakanibu.” ");
INSERT INTO aui_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham ivituwapore oghogheyana bi mayiyina iyowogha dobodobove, da imaniwa bi nuwanuwana kamone iwona bo, “Tomogha kana bodu 100 rubana inituwa bo? Bi Sera na 90 - rubana inituwa bo gegha?” ");
INSERT INTO aui_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Bi Abraham, God iwoneni bo, “Rubana da Ismel kuyimiiseyeni da kagu tupataveyana.” ");
INSERT INTO aui_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bi God iwona bo, “Gegha! Wavinem Sera inituvem da tomogha bi kuniwaghaneni da Aisik. Yagu wiiwaghasina maragasina gwabine anabera bi kate nosinosina gwabidiye touna murine, da wiiwaghasina maragasina makewaghawaghasina. ");
INSERT INTO aui_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Bi yam wiina, Ismel kiiravine na awaiyaneni. Animiiseyeni bi natunatuna korotodi anavereni bi bada nosinosina sinakoroto kirakii. Bi babada ghamaghamadi yadi 12 touna gwabinama sinatubugha, bi nosinosina anaberadi da yadi dam inaragata kirakii. ");
INSERT INTO aui_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bi gegha da yagu wiiwaghasina maragasina, na Aisik gwabine anatore, iiyabo, Sera muriye initubuyina mmko nawaravine bi viko bodune.” ");
INSERT INTO aui_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yawe God, irumaghatara Abraham biidi Mamri kiina kabikabikarawayidi riridiye na waragututuna mma naboni. Da gabudara yana muyamuya kirakii raghanine na Abraham yana kiregoru matamketane iyamakamake. ");
INSERT INTO aui_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Bi iyakayogagawa na tomotomogha aroba nama ririne, gegha rabarabae siyamiimiiri. Iyakitakitadi, na kiregoru matamketana ikuyoveni, bi ivera inagho da iyikiikiivedi na ipepeta iyowogha dobodobove. ");
INSERT INTO aui_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Bi iwona bo, “Yagu bada, memeda konanoghosi da tagu miisegu, na gegha konaveratupiiregu. ");
INSERT INTO aui_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Bi rarima anakawari anapiika da kayemi konakogha, bi mmko kiina rogune koniyawiitaveyana. ");
INSERT INTO aui_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Bi kam bada anakawara anapiika konakam da maragata inaveremi, bi muriye da yami wagawaga konadagu mayeni. Bi kokabikarawayeguna, wasina anabigemi.” Na siwona bo, “Wasina, awaki kuwonenina kubera.” ");
INSERT INTO aui_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Wasina bi Abraham yaininagha inagho irughu kiregoruve bi Sera iwoneni bo, “Yaininagha, yam kabikabiwiitaghoma ma parawa miisena kabi da bred benabenana kugabuni.” ");
INSERT INTO aui_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Bi bada ivera inagho kau borudiye da natudi takukuna tana ivineyi, bi yana bagibagi wawayina ivereni da iyakabununagha yaiyaineni. ");
INSERT INTO aui_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Wasina bi Abraham, ribiribi susudi miidi bi kam susu miidima siwamirina da kate iyouwa ikawara ipiika bi kii rogune, tomotomoyidi naghodiye iririini, bi siyakamkam na riridiye iyakoyakoyayidi. ");
INSERT INTO aui_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na sivitarakiiyaneni bo, “Wavinem Sera meme?” Na iwonabodedi bo, “Kiregoru kamone.” ");
INSERT INTO aui_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tomoyina tana Abraham iwoneni bo, “Wiisuwona mmko nawaravine, bi viko bodune anaveramagha, na wavinem inituwa da natuna tomogha.” Bi Sera na tomoyina iyisisiyana murine, kiregoru matamketane, iyawaiwaiyana. ");
INSERT INTO aui_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham da Sera na simoraba kirakii, na Sera kubuwiipum kabina ikabitore da wiituwa kedana gegha. ");
INSERT INTO aui_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Bi imanivena mayeni iwona bo, “Tagu amoraba da kata anoganoga, bi moghanegu bada imoraba bi rubana da wawaya wiitubuyina aninuwamiiseyeni?” ");
INSERT INTO aui_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yawe God, Abraham ivitarakiiyaneni bo, “Awaki biidi Sera imaniwa bi iwona bo, ‘Tagu amoraba - bi rubana da wawaya anitubuyi bo?’ ");
INSERT INTO aui_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Sawara tana meme ipiropiro da Tagu Yawe God gegha anaberana bo? Bi nada awona, anaveramagha tam biidi mmko nawaravine, bi viko bodune, da wavinem Sera inituwa da natuna tomogha.” ");
INSERT INTO aui_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sera inaghara, na ikeeyeni bi iwona bo, “Geayamaniwana.” Bi Yawe God iwona bo, “Gegha, kumaniwa.” ");
INSERT INTO aui_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nokodi tomotomogha aroba sigeghomiiri, sitouyana na Abraham yawata sipepewa sinagho da ivitutavedi. Sikita iyowogha da Sodom tanavina sikita, ");
INSERT INTO aui_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Bi Yawe God iwonena mayeni bo, “Awaki pinimina bi anabera, na gegha Abraham gwabinama anikowoyina, ");
INSERT INTO aui_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","touna kana dam na inaragata bi inimaragata kirakii bi tounae na dam tupadi mmko kuburine animiiseyedi. ");
INSERT INTO aui_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Na avineyi da natunatuna, bi nosinosina murine inawonedi da kaye warubigugha sinapepewa bi bera rotomanidi sinabera, da kate miisena sinabera, na awaki avisuwoneni na anabera.” ");
INSERT INTO aui_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Na Yawe God imiiriwamira da Abraham biidi iwona bo, “Sodom da Gomora kwanatudi sisiyidi awaiyana bi wawayidi yadi tamumu na iragata kirakii. ");
INSERT INTO aui_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ayowoyowogha anakita da mmkodi gwinidi na wonawaghata bo gegha, da anakovi.” ");
INSERT INTO aui_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Wasina tomotomogha bata sitouya na Sodomma sitaveyana, bi Yawe God, na Abraham naghone imiiriwaghata. ");
INSERT INTO aui_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham imiiririya Yawe God biidi bi iwona bo, “Wonawaghata da wawaya miisedi da berodi yawata kunakasiwiiberodi? ");
INSERT INTO aui_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Meboda kwanatu kamone wawaya miisedi yadi 50, rubana kuniberodi? Bi gegha kwanatuna kunanuwatotoveni da nokodi wawaya miisedi yadi 50 kiiravidiye nama kamonena bo? ");
INSERT INTO aui_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Wonawaghata kate gegha wawaya miisedi, berodi teya kunikasunughana na. Noko gewasina, bi gerubana da kunabera. Bi memeda kunabera na wawaya miisedi, berodi yawata kunikamowana da aro sinakabi, nokona wawaya miisedi kunikasunughana wawaya beroberodi yadi berae. Noko gebera miisena. Gegha, Tamna wawaya kadi wiitupawamiwamira kubura tupana debane - na kayowiiyayeyane kunibademii, bo?” ");
INSERT INTO aui_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yawe God iwona bo, “Memeda wawaya miisedi yadi 50 Sodom kwanatune anabananidi na, Tagu kwanatuna ananuwatawani basuna toudi kiiravidiye.” ");
INSERT INTO aui_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham iwonabodeyana bo, “Yagu Bada, tagu na tomogha wapawapa, bi tam biidi mmko wiisisiyenina adaguni na anitarakiiyana magha. ");
INSERT INTO aui_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Memeda wawaya miisedi yadi 50 kamodima yadi 5 sinawapana - rubana da kwanatuna tupana kunibero basuna wawaya miisedi 5 sinawapana?” Yawe God iwona bo, “Memeda wawaya miisedi yadi 45 nama anabananidi na gegha aniberoni.” ");
INSERT INTO aui_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham ivitarakiiyana magha bo, “Memeda nama wawaya miisedi yadi 40 kunabananidina?” Yawe God iwona bo, “Memeda 40 nama, na gegha anaberana.” ");
INSERT INTO aui_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham iwona bo, “Yagu Bada, gegha nuwanuwam inapughu tagu biidi, bi anisisiya magha - meboda yadi 30 namana?” Yawe God iwona bo, “Memeda yadi 30 anabananidi, na gegha anaberana.” ");
INSERT INTO aui_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham iwona bo, “Mmko wiisisiyenina avidaguveni tam biidi, rubana da anisisiya magha - meboda yadi 20 nama kunabananidina?” Yawe God iwona bo, “Memeda yadi 20 anabananidi, na gegha aniberona.” ");
INSERT INTO aui_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham iwona bo, “Yagu Bada, gegha nuwanuwam inapughu tagu biidi, kayowiiyayegu da raghani tanagha anisisiya magha - meboda wawaya miisedi yadi 10 nama kunabananidina?” Yawe God iwona bo, “Memeda wawaya miisedi yadi 10 anabananidi, na gegha aniberona.” ");
INSERT INTO aui_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Wasina Yawe God, Abraham teya sivisisiya ikovi, na itouya inaghotaveyana, bi Abraham iveramagha yana gaware. ");
INSERT INTO aui_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nokodi aneyaneya yadi bata sinagho bi ravidiye na Sodomma siverakanibu, na Lot kwanatu matamketane iyamakamake bi raghanine ikitadi na igeghomiiri inagho da iyikiikiivedi, na ipepeta iyowogha da mayiyina dobodobove. ");
INSERT INTO aui_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Bi iwona bo, “Yagu babada, kopiika yagu bare kamone konarughu, bi anabigemi. Kayemi konakogha, da mma konakena bi raghani inaborina didibarawote konageghomiiri da konanagho.” Bi siwona bo, “Gegha, toumii mma debakiikave kanakena kwanatu kamone.” ");
INSERT INTO aui_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bi gegha, da ivibaba tupetupedi, da yawata sinagho bi sirughu yana bare kamone. Bi kepo gisina ibera, da bred gegha yist teya igibu kiiravidiye, bi ikabununagha da sikam. ");
INSERT INTO aui_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bi muriye da kiiwaga siyarughu siyakena, na Sodom kana tomotomogha bare sikousi sivikenavivireni, kwanatu kana tomotomogha tupadi, yaraga bi magura, ");
INSERT INTO aui_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","bi Lot siyakwatukwatuveni bo, “Nokodi tomotomogha iiyawogha, kata ravidiye tam biidi sipiika na meme? Kurutayina kanibuvedi toumii biiyadi, yama wiina da kanakenedi!” ");
INSERT INTO aui_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Wasina Lot ikanibu maghatare da bare naghone imiiri bi murinama matamketa igudu. ");
INSERT INTO aui_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Bi iwonedi bo, “Turaturagu, gegha mmko berana berona konaberana. ");
INSERT INTO aui_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kowaiyanegu! Natunatugu wasiwasikedi bata, wabuwabudi bi gegha tomotomogha teya siyakenatowoghana. Mmkodi wasiwasikedi woudi anarutayina kanibuvedi tami biiyadi, da yami wiina toudi biiyadi konabera. Bi mmkodi tomotomogha apiikedi yagu bareye, na gegha awaki tana konabera.” ");
INSERT INTO aui_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bi Sodom tomotomogha siwona bo, “Kumiiri irana! Tam wawaya wiibata mma, bi kata yam wiina kunabera da tam bada ghamam. Bi kata kanabera da kunakabikwarakwara kirakii gegha naboni nokodi bata!” Na Lot sirutuvena tagutagureni, bi yadi wiina da ware matamketa siyagawowori. ");
INSERT INTO aui_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Na aneyaneya yadi bata bare kamove imadi sirorona sikanibu, da Lot sitayina rughuveni toudi biiyadi, bi matamketa sigudu. ");
INSERT INTO aui_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bi namanamarama tomotomoyidi maghatare sirouvidi da matadi sididibara raghani tupona, na gegha rubana da matamketa siyabananina. ");
INSERT INTO aui_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Bi aneyaneya yadi bata, Lot siwoneni bo, “Pinimina bi mmko kuburina kanibero, Yawe God, mmko kwanatuna wawayidi yadi berabero sisiyidi peyaridi iwaiyana kiiravine na iviporamii da kaniberoni. Bi yam rakaraka mududi mma bo? Natunatum tomotomogha da wasiwasike, natunatum kadi kabibabara, tomotomoyidi: mmko gawarinama kabitavedi kokanibu konanagho!” ");
INSERT INTO aui_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Na Lot ikanibu da natunatuna wasiwasikedi kadi kabibabara iwonedi bo, “Yawe God pinimina bi mmko kwanatuna inibero, yaininagha, mmko gawarina kokuyoveni.” Bi sinoghosi da ware iyiyaba. ");
INSERT INTO aui_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bi raghani kana didiguba iyoghoyeni, na aneyaneya yadi bata, Lot siwoneni da iyiyaininagha. Siwona bo, “Gegha iyamiise da kunamomogha, raghanina Yawe God mmko kwanatuna iniberona. Kuviyaininagha, wavinem, bi natunatum wasiwasikedi bata kabitavedi.” ");
INSERT INTO aui_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Bi Lot ikayowiiwiiyupe na Yawe God inuwatotoveni, na nokodi aneyaneya yadi bata, imana sikabi, wavinena bada imana sikabi da natunatuna wasiwasikedi bata imadi siyouna, da sivinaghovedi kwanatuna sikanibutaveni. ");
INSERT INTO aui_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Raghanina sivikanibuvedi murine, na tana iwona bo, “Kovera da konayawa! Gegha kona rusinimurana bi bada gegha meme anagha kamone koniraborabobona. Koya kadivera kovera, gegha iyamiise da konamomogha.” ");
INSERT INTO aui_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Wasina gabudara iyageegee bi Lot yana rakaraka yawata Jor kwanatune siverakanibu raghanine, ");
INSERT INTO aui_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","na Yawe God ibera da salfa keyamina karakarasina, kiyara mayimayiyina Yawe God gwabinama iyowogha Sodom da Gomora ikarasidi. ");
INSERT INTO aui_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Wasina naboni nokodi kwanatudi da tanawa ruwiipikapikana tupana bi wawaya tupadi nokodi kwanatudiye da kate sawara tanave siyagogogona tupadi iviberodi. ");
INSERT INTO aui_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bi Lot murine, na wavinena irusinimura na iviwamiwamira da ivimadasoru yegii pakoridi totokina naboni. ");
INSERT INTO aui_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Wasina bi Yawe God, Sera iviwiiteni da metagha ivisuwonana naboni da Sera iyituwa da natuna tomogha. ");
INSERT INTO aui_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","God metagha gabudarina iyatoretorena naboni ibera, da Sera iropeya bi Abraham natuna tomogha ivitubuyi, Abraham yana moraba raghanine. ");
INSERT INTO aui_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sera, tomogha ivituveni bi Abraham iviwaghaneni da Aisik. ");
INSERT INTO aui_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Raghanina itubugha bi gabudara 8 sikovi, na Abraham, Aisik sinina ibori da ivimatakira, metagha God naghove iwoneni, na naboni ibera. ");
INSERT INTO aui_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Mmko berana itubugha na raghanina Abraham kana bodu 100 bi natuna Aisik itubugha. ");
INSERT INTO aui_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Raghanina Aisik ivimagura bi siyikarataveni, na gabudarine Abraham kepo ghamana ibera. ");
INSERT INTO aui_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Noko raghanine Abraham natuna Ismel, touna Ijipt wasike ivituveni, na Aisik iyinamayeni na Sera ikita. ");
INSERT INTO aui_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Na noko biidi Abraham iwoneni bo, “Noko wiitamariyana wasike natuna teya kudaru ketoketodi sinanagho! Basuna gegha yagu wiina da natuna buderim muduna inayoyo, wasina natugu Aisik kawagha buderi inirapeneyana.” ");
INSERT INTO aui_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Na Abraham mmko sisiyina ivinuwapoyena kirakiiyeni, basuna Ismel na touna wosina natuna. ");
INSERT INTO aui_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bi gegha, God iwoneni bo, “Tomogha gisigisi da sinananaki, yam wiitamariyana wasike gekuninuwapoyedina. Bi Sera awaki yawonewonem na kubera, basuna iisuwona da Aisik gwabinama nosinosim sinatubugha. ");
INSERT INTO aui_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Bi gegha da wiitamariyana wasike natunama na nosinosina korotodi anavereni da dam tana kate inatubugha, basuna touna na tam natum.” ");
INSERT INTO aui_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Na raghani ibori didibara wote, Abraham igeghomiiri bi kam mududi da rarima, kabikabiwiitaghoma ribiribi bekadima siberana kamone iyouna, bi Heiga katiiyane ivikawari bi tomogha gisigisi teya iviporatavedi. ");
INSERT INTO aui_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Raghani viya sikovi murine na God, Abraham yana wiitumaghana irubuni, ikwatuveni bo, Abraham! Na Abraham iwona bo, “Tagu mma.” ");
INSERT INTO aui_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Na God iwona bo, “Tam, natunuwam Aisik kabi, meko kuvinuwayuyunena kirakiiyenina, bi kunagho Moriya kubure. Bi name koya tana anawonem na debane, kunigeni da ere tupana kugabuni naboni suwara tagu biidi.” ");
INSERT INTO aui_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Na raghani ibori didibara wote Abraham igeghomiiri. Da yana donki ikabununayi, bi keyama ibiga suwara gabunina kiiravine, bi yana wiitamatamariyana bata da natuna Aisik irutayinidi bi sitouya sinagho meko gawarina God iwonenina nabo. ");
INSERT INTO aui_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Wasina bi sipepewa siyanono da gabudara wiiarobine na Abraham rabarabama ikitarorona da gawarina ikita. ");
INSERT INTO aui_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Na yana wiitamatamariyana iwonedi bo, “Mma donki teya komakae, bi tagu da tomogha gisigisi kanatowawona vibo da God kanakabikuwayeni. Bi kate kanaveramagha tami biiyadi.” ");
INSERT INTO aui_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Na Abraham suwara kana gabugabuna keyamidi iyouna da natuna Aisik ivikawari bi touna kiirupatuma da ipaga ikawara bi sinagho. Bi raghanine siyanono patapata, ");
INSERT INTO aui_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","na Aisik ikaradeba tamananaki biidi iwona bo, “Tamada?” Abraham iwona bo, “Kisisiya, natugu.” Na Aisik iwona bo, “Keyama da kiirupatuma na mma, bi suwara gabunina kana nigenige na meme?” ");
INSERT INTO aui_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Na Abraham iwonabodeyana bo, “Natugu, God kawagha nigenige inavereda suwara gabunina kiiravine.” Bi yadi bata sinagho patapata. ");
INSERT INTO aui_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Bi raghanina God gawarina iwonenina name sikanibu, na Abraham akima ivitaghotaghoma da suwara gabunina gawarina ibera bi debane keyama iririni. Bi natuna Aisik iyaghiratawatawani da suwara gabugabuna gawarina debane, kii debadiye ivikeneni. ");
INSERT INTO aui_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Wasina bi imana ikoghasi ipaga ikabi da natuna iyagwarunuyi. ");
INSERT INTO aui_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bi Yawe God yana aneya abamama ikwatuveni iwona bo, “Abraham! Abraham!” Abraham iwonabodeyana bo, “Tagu mma.” ");
INSERT INTO aui_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Na Yawe God yana aneya iwona bo, “Gegha imam tomogha gisigisi debane kunatorena, bo awaki berona tana kunabera touna biidi. Kata akovi da wiisuwona Tagu, God kwakabikabikuwayegu basuna natunuwam gwabiguma gekuyanuwatotovenina.” ");
INSERT INTO aui_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Wasina bi Abraham ikitarorona da sip makina ikita, doghana kii gisigisi ragharaghane sikira. Na inagho da sip na ikabi, ikasunuyi bi ere tupana igabuni da God biidi isuwara, natuna wasana. ");
INSERT INTO aui_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Mmko itubugha kiiravine na Abraham gawarina ikwatuveni “Yawe God inavereyana.” Noko raghanine da patana kata wawaya mma naboni sawona bo, “Yawe God yana koya debane inavereyana.” ");
INSERT INTO aui_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Wasina bi Yawe God yana aneya abamama Abraham ikwatuvena mayeni raghani wiibatana, ");
INSERT INTO aui_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","iwona bo, “Yawe God iwona, ‘Tam kukabisisiregu da natunuwam gwabiguma gekuyanuwatotoveni, na tam biidi iisuwona da kagu waghawaghae ");
INSERT INTO aui_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","animiiseyem bi nosinosim korotodi anaverem. Yadi koroto naboni kewokewo abame bi egha kikire. Na nosinosim kadi aviya sinageiwayidi da yadi kwanatu sinirapeneyana ");
INSERT INTO aui_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","bi nosinosimve na dam tupadi mmko kuburina debane animiiseyedi, basuna tam kukabisisiregu na mmko anabera.’” ");
INSERT INTO aui_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Wasina bi Abraham natuna Aisik teya siveramagha yana wiitamatamariyana biiyadi, bi tupadi sitouya siveramagha Biasibama. Bi Abraham name itourawiipikapika imakae. ");
INSERT INTO aui_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham natuna Aisik da natunatuna yawata waragututudi mma naboni. Aisik tamananaki na Abraham ");
INSERT INTO aui_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","bi raghanina Aisik kana bodu 40, na Rebeka irawayi. Touna Betuwel natuna, bi Leiban tiinaru wasike, na toudi Aram damdi bi Mesapotemiya kubure siyamakamake. ");
INSERT INTO aui_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Bi Rebeka ivigagara na Aisik, Yawe God biidi irupari da wavinena iyiwiiteni. Wasina bi Yawe God, Aisik yana rupari iwaiyaneni na wavinena wawaya bata imakeyedi. ");
INSERT INTO aui_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bi muriye da siyatubugha na ededidi sinadinaki kamokamone siyiketokabivivirana, na Rebeka, Yawe God biidi ruparima ivitarakiiyana bo, “Awaki kiiravine bera naboni yatubutubugha tagu biidi?” ");
INSERT INTO aui_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Na Yawe God iwoneni bo, “Nokodi ededa bata kamokamomve na kate dam sinatubugha wawaya bata kunituvedi, bi siniaviya kabivivirana. Tana inimaragata kirakii genaboni tana Iyarokona touna murimurina inabigeni.” ");
INSERT INTO aui_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Raghanina Rebeka yana wiituwa gabudarina ipiika, na tomotomogha wawaya bata situbugha. ");
INSERT INTO aui_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Bi iyarokona itubugha na sinina idurina bi ere ghunighunina, ware kwama ghunighunina, noko biidi kana waghawagha sikwatuveni Isso. ");
INSERT INTO aui_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Bi noko murine na tomoyina tana itubugha imanama toghanaru kayegidune ikabikikita, na sikwatuveni Jeikap. Aisik kana bodu 60 bi wavinena mmkodi tomotomogha bata ivituvedi. ");
INSERT INTO aui_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Raghanina tomotomoyidi bata sivimagura murine, na Isso yebaye na wasina na nonowa iyanono garagaraye. Bi Jeikap na tomogha wawumina bi nonowa bareye iyamakamake. ");
INSERT INTO aui_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisik yana wiina, na Isso yayebagha na iyuvidi kam, noko biidi Isso ivinuwayuyunena kirakiiyeni bi Rebeka, na Jeikap ivinuwayuyuneni. ");
INSERT INTO aui_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Raghani tana gabudare Jeikap kiipeni monamonana iyimuyamuya, bi Isso garagarama iveramagha, vitonana irabobo da iyamameyeni. ");
INSERT INTO aui_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Na Jeikap iwoneni bo, “Tagu vitonana arabobo. Noko kiipenina idurina katota kuveregu anakani!” (Noko biidi sikwatuveni Idom). ");
INSERT INTO aui_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Bi Jeikap iwona bo, “Tamna iyarokom, muriye tamadanaki yana mourama reregha ghamana kunakabi. Kata kunawonegu da noko rereyina kunaveregu, na mmko kiipenina monamona anaverem.” ");
INSERT INTO aui_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Wasina Isso iwona bo, “Tagu vitonana araborabobo, na noko iyaroko rereyina kate gegha iniwiitegu! Na tam kabi.” ");
INSERT INTO aui_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Bi Jeikap iwona bo, “Katota wota kuwonakasiyaragha da noko iyaroko rereyina kunaveregu.” Na Isso wonakasiyaragha ibera da noko iyaroko rereyina Jeikap ivereni. ");
INSERT INTO aui_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Wasina bi Jeikap kiipeni monamonana muduna iyepataveni da Isso ivereni, bred viya teya, bi ikam iniuna bi igeghomiiri da inaghotaveyana. Wasina noko naboni kiiravine, Isso iyaroko rereyina miisena geiyakabikarawayenina da isinighiiyeni. ");
INSERT INTO aui_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kapoe ghamana ipiika magha Kenen kuburine. Bi noko kapoena, na ware naghove Abraham yana raghaniye itubughana. Na Aisik inagho Gera kwanatune, meme Abimelek, Pilistain damdi yadi kiiwawo, iyamakamakena. ");
INSERT INTO aui_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Wasina bi Yawe God irumaghatara Aisik biidi bi iwona bo, “Gegha kunanagho Ijipt ma, bi gawara anawonem na name kumakae. ");
INSERT INTO aui_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mmko gawarine kunamake raghani gisina, bi tagu na tam gwabimve da animiiseyem. Tagu mmko tanavina tupana anaverem bi kate nosinosim yawata, bi kiiravimve anabera da awaki tamamnaki Abraham biidi avisuwoneni na inatubugha. ");
INSERT INTO aui_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nosinosim korotodi anaverem, yadi koroto naboni ware kewokewo abame, bi mmko tanavina tupana anaveredi. Nosinosimve na dam tupana mmko kuburina debane animiiseyedi ");
INSERT INTO aui_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","noko biidi mmko anabera, basuna Abraham gamogu iwaiyaneni, bi yagu sisiya tupadi ikabisisiredi, kate yagu wiiyeveveyana da yagu gwara.” ");
INSERT INTO aui_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Na Aisik nama Gera kwanatune imakae. ");
INSERT INTO aui_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Wasina bi Aisik, Jeikap ikwatuveni ipiika da ivimiiseyeni bi sisiya bagibaginama iwoneni bo, “Gegha Kenen wasike kunarawayina. ");
INSERT INTO aui_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Bi kunagho Mesapotemiyama, sinamnaki tamananaki Betuwel yana kubure. Bi name wasike kiiravimve kunakabi da wavinem, sinamnaki nughunaru, Leiban natunatuna kamodiye. ");
INSERT INTO aui_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bi God Maragata Kirakiina inimiiseyem kunituwa da yam koroto inaragata, bi kunitamada dam peyaridi kiiravidiye! ");
INSERT INTO aui_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bi bada tam da nosinosim wiimiiseyana inaveremi naboni Abraham iverenina, da kate mmko tanavina kunirapeneni meme wawaya wiibata naboni tam kwamakamakena, tanawa meko God, Abraham iverenina.” ");
INSERT INTO aui_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Wasina bi Jeikap, Biasiba kwanatuna ikuyoveni bi itouya iyanono Haranma. ");
INSERT INTO aui_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Raghanina ipiika da gawara tane ikanibu na nama ivitaki, basuna gabudara nada imakepowa. Bi ikenayowogha da kena biidi, na akima tana ikabi da ivikasepa. ");
INSERT INTO aui_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Bi iyakenakena na imimeu da kedawaga ikita, kayena kubura debane ivitupeni bi damona igae inagho abame, na God yana aneyaneya debanagha siyayoyo bi siyageegee. ");
INSERT INTO aui_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Bi nama wowone na Yawe God iyamiimiiri, na iwona bo, “Tagu Yawe God, tubumnaki Abraham yana God da tamamnaki Aisik yana God. Mmko tanavina debane kwakenakena, na tam da nosinosim anaveremi. ");
INSERT INTO aui_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nosinosim sinakoroto kirakii ware kubura popokuna naboni. Keda tupane sinimosaredi, bi wawaya tupadi mmko kuburina debane tamve da nosinosimve na animiiseyedi. ");
INSERT INTO aui_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tagu na tam gwabimve bi meghamegha kunanono na anakighukighum, da anakabim kunaveramagha mmko tanavine. Bi gegha anakuyovem patana da awaki avisuwonem da ayabera na anabera.” ");
INSERT INTO aui_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Raghanina Jeikap igeghomiiri na iwona bo, “Wiisuwona Yawe God mma, mmko gawarine bi akovina geayakabina.” ");
INSERT INTO aui_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wasina bi inaghara na iwona bo, “Mmko gawarina ririmonina iraghata! Bi mmko God yana bare, ware abama kana matamketa.” ");
INSERT INTO aui_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Raghani ibori bi didibara wote, Jeikap igeghomiiri da noko akimina ivikunuwaneni na ikabiwiimiiri naboni matakira. Bi oliv miina debane iwayi, da God biidi na kabikabikuwayina. ");
INSERT INTO aui_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Bi noko gawarina ikwatuveni Betel (Naghove kwanatuna siyakwatukwatuveni Lus). ");
INSERT INTO aui_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Wasina bi Jeikap wiisuwona maragasina ibera Yawe God biidi iwona bo, “Memeda tam gwabiguve bi mmko wagawagana akabikabi bi kunakoyayigu bi kam da kwama kunaveregu, ");
INSERT INTO aui_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","bi yawayawiigu anaveramagha tamagunaki yana kubure, na tamna yagu God. ");
INSERT INTO aui_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Bi mmko matakira akimina meme akabiwiimiiri na tam yam bare, kabepepa gawarina. Bi sawara tupadi mekodi kunavereguna, riba yadi 10 anabera, bi tana anakabitaveni da anaverem.” ");
INSERT INTO aui_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jeikap, Mesapotemiyama iveramagha, bi Betel kwanatune iyamakamake na God irumaghataramagha touna biidi da ivimiiseyeni. ");
INSERT INTO aui_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Bi iwona bo, “Tam kam waghawagha Jeikap, bi gegha muriye sinakwatuvem Jeikap. Kam waghawagha na Isrel.” Na ikwatuveni Isrel. ");
INSERT INTO aui_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Wasina bi God iwona bo, “Tagu God Maragata Kirakiigu. Kuvituwa da natunatum sinakoroto. Tam nosinosim na sinidam kiitowana bi dam mududi bi kiikiiwawo tamve sinatubugha. ");
INSERT INTO aui_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tagu tanawa anaverem, noko Abraham da Aisik averedina bi bada mmko tanavina nosinosim murimve anaveredi.” ");
INSERT INTO aui_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Wasina bi God, noko gawarine Jeikap yawata sivisisiya, na ikuyoveni inagho. ");
INSERT INTO aui_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Bi gawarina meme God touna biidi ivisisiya, na Jeikap akima ikabiwiimiiri bi wain iwayi debane da naboni yana suwara. Wasina bi oliv miina bada debane iwayi. ");
INSERT INTO aui_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Bi noko gawarina ikwatuveni Betel, basuna God name ivisisiya touna biidi. ");
INSERT INTO aui_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Noko murine Jeikap yana dam yawata Betel sikuyoveni bi siwagawaga siyanono, na boga gisina rabarabana bi muriye da Ifareit kwanatune siyakanibu. Na Reitsel wawaya idaguni. Bi yana wiituwa ipiropiro ");
INSERT INTO aui_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","na patana iyibusura da sinivisi ghamana iyidami bi pepeya iyatubutubugha. Na wiiburaburawa wasikena iwona bo, “Gekunanagharana! Tomogha tana kuvitubuyi.” ");
INSERT INTO aui_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Raghanina Reitsel yawiina itavenatughureni - bi rabobo biidi na pepeyina ikwatuveni Benoni. Bi tamananaki ikwatuveni Benjiman. ");
INSERT INTO aui_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Wasina bi Reitsel irabobo na name Ifareit (kata sakwatuveni Betlihem) kedana ririne sidogu. ");
INSERT INTO aui_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Bi Jeikap wavinena karawagine akima ikabiwiimiiri. Noko akimina na kata patana nama da Reitsel karawagina yimatakireni. Wasina bi Jeikap natunatuna yadi 12 kadi waghawagha mma. ");
INSERT INTO aui_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liya natunatuna: Rubin na Jeikap natuna iyarokona, Simiyon, Livai, Jiuda, Isaka bi Jebulan. ");
INSERT INTO aui_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Bi Reitsel natunatuna: Jousep da Benjiman. ");
INSERT INTO aui_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Reitsel yana wiitamariyana wasike, Bilha natunatuna: Dan da Neptalai. ");
INSERT INTO aui_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liya yana wiitamariyana wasike, Zilpa natunatuna: Ged da Aser. Mmkodi na Jeikap natunatuna Mesapotemiya kubure natuwavinena sivituvedi. ");
INSERT INTO aui_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Wasina bi Jeikap iveramagha Mamrima, Kiriyat-Aba (kata sakwatuveni Hebron) ririne, tamananaki Aisik biidi. Bi mmko kuburine Abraham imake, bi bada muriye Aisik imake. ");
INSERT INTO aui_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Bi Aisik imakae da kana bodu 180. ");
INSERT INTO aui_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Touna imoraba da ikabipipin bi irabobo, na kayekikina muridigha inagho. Wasina bi natunatuna Isso da Jeikap tubuyina sidogu. ");
INSERT INTO aui_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Wasina bi Jeikap yana dam yawata Kenen kubure simakae, tanawa meme tamananaki Aisik imake ware naboni wawaya wiibata. ");
INSERT INTO aui_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Mmkona Jeikap natunatuna teya waragututudi. Raghanina Jousep wabuwabuna kana bodu 17, na tamananaki natuwavinena Bilha da Zilpa natunatudi yawata sip da gout siyakoyakoyagha. Bi Jousep kana makewona iviwara berovedi tamananaki biidi. ");
INSERT INTO aui_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Wasina bi Jeikap, Jousep ivinuwayuyunena kirakiiyeni gegha naboni natunatuna mududi, basuna Jeikap yana moraba raghanine bi itubugha, na kwama katukatuyina ibera bi ivereni. ");
INSERT INTO aui_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Raghanina kana makewona iyiyarokodi sikita da tamadinaki yana nuwayuyuna iragata Jousep biidi, bi gegha toudi biiyadi, na yadi nuwavisi iragata da genuwayuyune siyisisiya touna biidi. ");
INSERT INTO aui_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nubabasu tana Jousep imimeu bi raghanina kana makewona iwonedi, na yadi nuwavisi iviragata kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Jousep iwonedi bo, “Kowaiyana bi yagu mimeu anawonemi. ");
INSERT INTO aui_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Touda kwabu kamone wit ere taghodi tayapetopeto, tayiitaghotaghoma da tayaginaginaba. Bi noko raghanine yagu ginaba igeghomiiri da imiiri rotomana. Bi yami ginaba yagu ginaba simiiri gwagwari da situwayowaneni.” ");
INSERT INTO aui_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Wasina bi kana makewona iyiyarokodi siwona bo, “Da kwanoghonoghosi tam kunikiiwawo? Bi kwanoghonoghosi da kunibademii, bo?” Na Jousep yana sisiya da yana mimeu kiiravine na yadi nuwavisi touna biidi iragata kirakii. ");
INSERT INTO aui_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Raghani tana Jousep kana makewona sinagho Sikem kubure tamadinaki yana sip da gout siyakamkam na siyakoyakoyayidi. ");
INSERT INTO aui_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Na Jeikap iwoneni bo, “Warewaresim Sikem kubure sip da gout sakoyakoyagha. Awiiwiini da aniporam kunanagho toudi biiyadi.” Na Jousep iviwaghasina iwona bo, “Wasina, ananagho.” ");
INSERT INTO aui_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Na Jeikap iwona bo, “Kunagho da kam makewona kunakitadi wasina samakamake bo gegha bi kate sip da gout yawata, bi kunaveramagha na kuniwaraveregu.” Wasina bi Jeikap Hebron anayinama Jousep iviporataveni inagho. Raghanina ikanibu Sikemma, ");
INSERT INTO aui_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","bi muriye na tomogha tana Jousep ibanani guburagha iyapeepewa wapawapa na ivitarakiiyaneni bo, “Awaki kwiininogha?” ");
INSERT INTO aui_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Na Jousep iwona bo, “Kagu makewona ininoyedi, yadi sip da gout sakoyakoyayidi. Rubana da kuyawonegu toudi meme barasina?” ");
INSERT INTO aui_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Bi tomoyina iwona bo, “Nada sinagho bi awaiyanedi siwona bo, ‘Tanatouya tananagho Doten kubure.’” Wasina bi kadi makewona Jousep muridigha ikivinidi, inagho da Doten kubure ibananidi. ");
INSERT INTO aui_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bi muriye da iyakanibu toudi biiyadi, na vimenaki rabarabae sikita na sinuwakapiyeni da siyakasunuyi. ");
INSERT INTO aui_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Na sivisisiya siyawonawona bo, “Kokita, mimeu badana yapiipiika! ");
INSERT INTO aui_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kopiika, tanakasunuyi bi tubuyina mmkodi dogu tana kamone tanitavenayowoyeni. Bi tamadanaki tanawoneni da ribiribi dipa itarunuyi. Bi tanakita yana mimeuma awaki inatubugha.” ");
INSERT INTO aui_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Bi Rubin mmko yadi sisiyina iwaiyaneni na iberatowoyi da Jousep iyiyawiini. Na iwona bo, “Gegha yana yawa tanaborina, ");
INSERT INTO aui_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","bo tanakasunuyina. Bi mma mayabe, doguve tanitavenayowoyena wosi, bi gesinina taniberona.” Rubin mmko iwonenina kiiravine iyanoghonoghota da Jousep iyiyawiini bi iyakabi iyanaveni tamananaki biiyadi. ");
INSERT INTO aui_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Wasina raghanina kadi makewona Jousep ipiika toudi biiyadi, na sikabitawatawani da kana kwama katukatuyina meko tamananaki ibera bi ivereni iyakotekotenina siroukiyakiyani. ");
INSERT INTO aui_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Bi sikabi sinagho da dogu kwebuna kamone sivitavenayowoyeni. ");
INSERT INTO aui_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Bi sivitavenayowoyeni ikovi. Na muriye simakeyowogha siyakam, na sikitarorona da dam Ismel boruna yadi kamel teya siyapiipiika na sikitadi. Yadi kamel na sawara sikawara bi sawaridina: kam kadi wiiwiimetewa, sawara ghabughabudi mududi da myrrh, bi Giliyed kwanatunama sipiika siyanono Ijiptma. ");
INSERT INTO aui_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Na Jiuda yana rakaraka iwonedi bo, “Memeda tiidaru tanakasunuyi bi yana rabobo warana tanikowoyi, na muriye yana miisena awaki tanabanani? ");
INSERT INTO aui_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kopiika, Ismel damdi biiyadi tanigimoneni bi geimada debane tanatorena. Kiiravine touna waresida waghata, bi tubuyida da ganiganida tanagha.” Na wasina Jiuda yana rakaraka yana sisiya siviwaghasineni. ");
INSERT INTO aui_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Na raghanine wiigimona damdi Giliyed kwanatuna, Midiyan kubura kamonama siverakanibu na Jousep yana rakaraka sigeghomiiri sinagho da doguma sitayinageeyeni bi sivigimoneni da silva pinipinimidi 20 rubana Ismel damdi biiyadi. Bi sikabi sinagho Ijipt kubure. ");
INSERT INTO aui_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bi noko murine, raghanina Rubin iveramagha doguve na iyakita da Jousep genama na ivinuwapoya kirakii da kana kwama itainagosiri. ");
INSERT INTO aui_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Bi iveramagha yana rakaraka murimuridi biiyadi da iwona bo, “Tomogha gisigisi gedogu kamonena! Tagu awaki anabera?” ");
INSERT INTO aui_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Wasina bi Jousep, yana rakaraka gout sikasunuyi bi kana kwama sikabi da ganiganine sisirakutuvi. ");
INSERT INTO aui_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bi kwamana sikabi sinagho tamadinaki biidi bi siwona bo, “Mmko kwamana kabanani, kabikitakita, meboda natum kana kwama bo?” ");
INSERT INTO aui_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Na Jeikap akovina ikabi na iwona bo, “Wasina, mmkona natugu kana kwama! Ribiribi dipa itarunuyi. Oo-o, natugu! Ribiribi itainamiimiini.” ");
INSERT INTO aui_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Wasina bi Jeikap ivinuwapoya kiiravine na kana kwama itainagosiri, bi wiirowarowa kwamana ribiribi ghunighunidima sibera, na ikoteni bi natuna kiiravine idou da sinina irudavero. ");
INSERT INTO aui_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bi natunatuna tupadi tomotomogha da wasiwasike sikayoveni da siyiororoyi, bi gegha, touna isinighai. Na iwona bo, “Tagu patana anaduudu, da ere duudugu anayowogha anano Tanamama, natugu biidi.” Na natuna Jousep kiiravine idou wiiwoneni. ");
INSERT INTO aui_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Wasina bi Ismel damdi Jousep sikabi, sinagho Ijipt kubure da sivigimoneni na Potipa igimoni da yana wiitamariyana. Potipa touna na Ijipt kana kiiwawona yana ababagibagi wawayina ghamana tana, bi kate yana bare kanakoyakoyagha kadi bada. ");
INSERT INTO aui_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawe God na Jousep gwabine, na iviwiiteni bi bera tupana iyaberabera na miisena. Bi yana bada Ijipt tomogha yana bareye iyamakamake. ");
INSERT INTO aui_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Raghanina yana bada Potipa ikita da Yawe God na gwabine bi iyiwiiteni da bera tupana iyaberabera na miisena, ");
INSERT INTO aui_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","na ivinuwamiise bi iwoneni da touna wosina yana wiitamariyana. Na Jousep itore da yana bare da kate sawara tupadi rapene, na ima debane itoura da inakoyagha. ");
INSERT INTO aui_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Noko raghanine bi nabo inaghona, Jousep nama kiiravine na Yawe God, Potipa yana bareye wawaya wadubodi ivimiiseyedi na miisena siyabanabanani. Yana sawara tupadi, bare kamove da kwabuve na Yawe iyiimiiseyedi. ");
INSERT INTO aui_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Bi bera tupadi Jousep ima debane itoura da iyibadedi bi iyakoyayidi, na Potipa getana awaki iyinuwapoyenina wasina kam iyakamkam na touna kawagha. Bi Jousep na ere tubuyina bi komerowanina. ");
INSERT INTO aui_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Na nama imake gegurina bi yana bada wavinena ikita kiroroveni na igagari iwoneni bo, “Piika, taniragoba tanakena!” ");
INSERT INTO aui_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Bi Jousep isinighii na iwoneni bo, “Kukita, yagu bada yitumaghanegu na getana awaki yana bare kamone iyinuwapoyenina basuna tagu mma. Sawara tupadi rapene na imaguve itoura da anakoyagha. ");
INSERT INTO aui_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Bi mmko barena kamone getana iiyabo iyageekirakii da tagu naboni, na getana awaki iyanuwatotoveni da wasina tam kawagha, basuna tamna wavinena. Na metagha bi bera berona anabera da God biidi tamumu anabera?” ");
INSERT INTO aui_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bagune wasike gabudara patepatena iyigagarana, bi Jousep iyasinisinighii, na geyawata siyiragoba bo siyamake patapata. ");
INSERT INTO aui_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Gabudara tana Jousep irughu bare kamone yana bagibagi iyabera, bi noko raghanine na bare kana wiitamariyana getana nama kamone. ");
INSERT INTO aui_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Na Potipa wavinena ipiika Jousep biidi da kana tarasowo ikabitawani bi iwoneni bo, “Piika, taniragoba tanakena!” Bi gegha, Jousep kana kwama wasikena gwabine ikuyoveni bi bare kamonama ivera ikanibu maghatare. ");
INSERT INTO aui_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Raghanina wasikena ikita da Jousep kana tarasowo imadebane ikuyoveni bi ivera ikanibu maghatare, ");
INSERT INTO aui_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","na yana bare kana wiitamatamariyana damdi ikwatuvedi sipiika bi iwona bo, “Kokita! Moghanegu mmko Hibru tomoyina meko ipiikeni bareye na ivibera berowaneda! Irughu yagu tupayaraye bi iberatowoyi da iyakenegu, na arakapara da ghamana. ");
INSERT INTO aui_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Bi raghanina iwaiyanegu arakapara, na kana kwama ririguve ikuyoveni, bi ivera ikanibu maghatare.” ");
INSERT INTO aui_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Wasikena tarasowona gwabine ikabitawani patana da Jousep yana bada iveramagha bareye. ");
INSERT INTO aui_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Wasina bi moghanena bada sisiyina mayimayiyina iwoneni bo, “Noko wiibagubagurana Hibru tomoyina meko kupiikeni mabo, na irughu yagu tupayaraye bi iwiini da iyibera berowanegu. ");
INSERT INTO aui_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Bi raghanina arakapara na, kana tarasowo ririguve ikuyoveni bi ivera ikanibu maghatare.” ");
INSERT INTO aui_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wasina bi Potipa wavinena yana sisiya iwaiyana na nuwanuwana ipughu kirakii ");
INSERT INTO aui_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","da iwona, na iyo damdi Jousep sikabitawani bi biwa gawarine sitorerughuveni, meme kiiwawo yana biwa damdi satutoura, na nama imakae. Bi raghanina Jousep biwa gawarina kamone iyamakamake, ");
INSERT INTO aui_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","na Yawe God na gwabine; bi ivinuwayuyuneni da ivimiiseyeni, na biwa gawarina kana bodaboda ivinuwamiise kirakii touna biidi. ");
INSERT INTO aui_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Na Jousep itore da iiyawogha nama biwa gawarina kamone na kadi bada, bi awaki bagibagidi name siyaberabera na iyakoyakoyayidi. ");
INSERT INTO aui_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Na biwa gawarina kana bodaboda bagibagi mekodi Jousep iyirutamariyeni na iyakoyakoyagha gegha iyanoghosidina, basuna Yawe God na gwabine, bi wiiwiita ivereni da bera tupana iyaberaberana miisena. ");
INSERT INTO aui_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Raghani viya murine, na Pero yana redu verevereyana badana da kam gabugabuna badana bera berodi mududi sibera yadi kiiwawo biidi. ");
INSERT INTO aui_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Na nuwanuwana ipughu nokodi yana bagibagi damdi bata biiyadi, ");
INSERT INTO aui_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","da biwa gawarina, bare kana koyakoyagha kadi bada yana bareye sitorerughuvedi, gawarina tanagha meme Jousep sitorena. ");
INSERT INTO aui_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Bi biwa gawarine simake raghani iguri, na koyakoyagha kadi bada, Jousep irupoyedi da yadi wiitamariyana. Bi biwa gawarina kamone siyamakamake. ");
INSERT INTO aui_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Da nubabasu tana tomotomoyidi bata - redu verevereyana badana da kam gabugabuna badana simimeu, bi yadi mimeu na basudi bogaebogae. ");
INSERT INTO aui_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Didibare raghanina Jousep ipiika toudi biidi na ikitadi da siyinuwabero. ");
INSERT INTO aui_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Na ivitarakiiyanedi bo, “Awaki kiiravine kata mayiyimi sibero kirakii?” ");
INSERT INTO aui_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bi siwonabodeni bo, “Toumii kamimeu, bi getana iiyabo mma da yama mimeu basudi iyawonemii.” Na Jousep iwona bo, “Wasina, God kawagha yiwiita da mimeu yawonawiiakowa. Yami mimeu kowonegu.” ");
INSERT INTO aui_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wasina bi redu verevereyana badana iwona bo, “Yagu mimeu kamone na greip uravina naghoguve akita, ");
INSERT INTO aui_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","debane na ragharaghana aroba. Bi raghanina rugurugudi sirumaghatara, da sipopo bi suwagha da simeni. ");
INSERT INTO aui_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na uwana ayouna bi kiiwawo yana redu imaguve na arubotoboto kamone bi kiiwawona avimakabi.” ");
INSERT INTO aui_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Wasina bi Jousep iwona bo, “Mma naboni: da nokodi ragharagha aroba na yana basuna gabudara aroba. ");
INSERT INTO aui_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Bi gabudara aroba murine na kiiwawo inikanibuvem da yam gawara inaverem, bi yana redu imane kuni imakabi ware yana redu kana verevereyana roro kuyaberaberana naboni. ");
INSERT INTO aui_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Bi raghanine bera inarotomana tam biidi na kunoghosigu bi yam miisena anakita, da kiiraviguve; kiiwawo biidi kunikawa da mmko gawarinama anikanibutaveyana. ");
INSERT INTO aui_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kiiravine wawaya tupeyenama Hibru damdi tanavidima sipiikegu, bi bada mma Ijiptne, na gegha awaki berona ayabera da biwa gawarine sitorerughuvegu.” ");
INSERT INTO aui_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wasina bi kam kadi gabugabuna badana iwaiyana da redu verevereyana badana yana mimeu kana wonavereyana irotomana na Jousep iwoneni bo, “Tagu teya naboni amimeu da bred irigidi aroba gayamiguve akunapa. ");
INSERT INTO aui_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Bi iriga wowone na kam gibugibudi bogaebogae kiiwawo kiiravine, bi manu irigina kamonama siyakamkam.” ");
INSERT INTO aui_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Na Jousep iwona bo, “Mma naboni: da nokodi iriga aroba na yana basuna gabudara aroba. ");
INSERT INTO aui_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Bi gabudara aroba murine na kiiwawo inikanibuvem da kanighom sinakasiyarayi! Bi tubuyim kiiye sinakuwiirorogi bi manu vighom sinakani.” ");
INSERT INTO aui_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Wasina bi gabudara aroba murine, na kiiwawo yana tubugha gabudarine, na kepo tana ibera yana ababagibagi damdi kadi babada ghamaghamadi kiiravidiye; redu kana verevereyana badana da kam kadi gabugabuna badana ivikanibuvedi yana ababagibagi damdi kadi babada naghodiye. ");
INSERT INTO aui_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Redu verevereyana badana yana gawara iveremayeni, da kiiwawo imane bada redu inimakabimayeni, ");
INSERT INTO aui_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","bi iwonana kam kadi gabugabuna badana kanighona sikasiyarayi bi sikuwiirorogi, metagha Jousep yana wonawiiakowa iwonedi na naboni itubugha. ");
INSERT INTO aui_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Bi redu kana verevereyana badana gegha Jousep iyanoghosina; touna Jousep ivinuwawapi. ");
INSERT INTO aui_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bodu bata sikovi murine, Ijipt kana kiiwawo imimeu. Yana mimeu mma naboni: Da touna Nail rarimina ririne iyamiimiiri, ");
INSERT INTO aui_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","bi kau miisedi bi takutakukudi yadi 7 rarimama sigae da siviya siyakamkam. ");
INSERT INTO aui_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Bi muridigha na kau berodi kirakiramidi yadi 7 bada Nail rariminama sigae, da kau takutakukudi simiiri tawanidi rarima kawabarane. ");
INSERT INTO aui_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nokodi kau berodi bi kirakiramidi, kau miisedi takutakukudi yadi 7 sikamkovidi. Wasina bi kiiwawo ivitunoka na imataka. ");
INSERT INTO aui_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Bi ikena nuwawapa magha na bada imimeu. Da wit kuvedi miisedi tavetaveyana yaporidi yadi 7 nama kiina tanagha sirukewakewa. ");
INSERT INTO aui_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Wasina bi muridigha na kuvedi yadi 7 sikarapumka sigae, da uwadi na kumararayidi, bi nada raghani matana yanununa muyamuyana ivikarunughana. ");
INSERT INTO aui_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Nokodi kuvedi kumararayidi, kuvedi miisedi bi ruruvidi yadi 7 sivitonanidi. Wasina bi kiiwawo imataka na inuwagiura da touna iyamimeu. ");
INSERT INTO aui_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Didibare igeghomiiri na ivinuwabero, na sisiya idaru mimeu kadi wonawonavereyana Ijipt kamone da kate akowa damdi tupadi siyapiika touna biidi. Kiiwawo yana mimeu iwonedi, bi getana iiyabo rubana da nokodi mimeu bata basudi iyawonaverenina. ");
INSERT INTO aui_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Wasina bi redu verevereyana badana kiiwawo iwoneni bo, “Tagu, kata yagu berona anoghosi. ");
INSERT INTO aui_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Da naghove noko raghanine nuwanuwam ipughu kam gabugabuna badana da tagu biidi, bi biwa gawarina Potipa yana bare kamone kutorerughuvemii. ");
INSERT INTO aui_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Toumii tatadigegha nubabasu tana kamimeu, bi mimeudi yadi basuna bogaebogae. ");
INSERT INTO aui_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Name na Hibru tomogha yaragina toumii yawata, tounana Potipa yana wiitamariyana. Yama mimeu kawoneni, na yadi basuna iwonaveremii. ");
INSERT INTO aui_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Metagha iwonemii na naboni itubugha, da yagu gawara kuveremayegu, bi kuwona na kam gabugabuna badana kanighona sikasiyarayi da sivirorogi.” ");
INSERT INTO aui_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Wasina bi kiiwawo yana sisiya idaru Jousep biidi na yaininagha biwa gawarinama sivikanibuveni. Raghanina ivimura ikovi bi kwama miisedi ivikote murine na, sikabi sipiikeni kiiwawo biidi. ");
INSERT INTO aui_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Da kiiwawo ivisisiya Jousep biidi iwona bo, “Tagu nubabasuve amimeu, bi getana iiyabo rubana da yagu mimeu basudi iyawonavereguna. Bi awaiyana da raghanina mimeu kwawaiyana, na yadi basuna kwawonavereyana.” ");
INSERT INTO aui_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Na Jousep iwona bo, “Tagu gerubagu da anabera, bi God kawagha wonabodeyana miisena kiiwawo inavereni.” ");
INSERT INTO aui_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Wasina bi Pero yana mimeu yadi bata ivisisiyedi ikovi na Jousep iwona bo, “Kiiwawo, nokodi mimeu yadi bata na mayimayiyidi bi basudi tanagha. Bi God awaki pinimina bi inabera na kiiwawo biidi ivimaghatari. ");
INSERT INTO aui_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nokodi kau miisedi yadi 7 na toudi bodu miisedi yadi 7, bi kate wit kuvedi miisedi yadi 7 na bada bodu miisedi yadi 7; bi mimeudi na mayimayiyidi da basudi tanagha. ");
INSERT INTO aui_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bi nokodi kau kirakiramidi yadi 7 murigha sigae na bodu 7, da kate wit kumararayidi kuvedi yadi 7 raghani matana yanununa ikabisisi na ivikarunughana na sivivi: Na toudi kapoe bodudi yadi 7 yirupatanedi. ");
INSERT INTO aui_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kiiwawo, mmko metagha awonem na inatubugha: basuna God pinimina bi awaki inabera na iviyevevem. ");
INSERT INTO aui_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Bodu yadi 7 kamone na moura ghamanakina yapiipiika Ijipt kuburina tupane, ");
INSERT INTO aui_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","bi gegha da kapoe bodudi bada yadi 7 murigha sinapiika, na wawaya Ijipt kubure moura raghanina sininagonagoveni, basuna kapoe kubura tupana inakabimumu. ");
INSERT INTO aui_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Da moura ghamanakina raghanina kate gegha sinanoghosina, basuna kapoe muriye yapiipiika, na inabero kirakii. ");
INSERT INTO aui_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Yana basuna naboni kiiravine na kiiwawo nokodi mimeu yadi bata kukita bi mmko noghosina na God tounamani ikayoveni, na pinimina bi berana inabera. ");
INSERT INTO aui_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Na kiiwawo, memeda kata na tomogha akakovina bi nuwanuwagiurina kuninoyeni bi kunatore da Ijipt kuburina tupana inibadeni. ");
INSERT INTO aui_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Bi kate Ijipt kubura kamone babada mududi kunavinegha. Bi moura raghanine na kabipura ribadi 5 kamodima tana sinakabitaveni da maghara bareye sinatoura. ");
INSERT INTO aui_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Mmkodi babada moura raghanine kam tupadi sinituwiitaghoma. Bi tam gamomve na kwanatu nunudigha kam sinimaghara bi sinakighudi da nokona wawaya kadi kam. ");
INSERT INTO aui_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Bi mmko kamna sinanuwatawani da wawaya kadi kabiwiitete raghanina kapoe bodudi yadi 7 sinapiika Ijipt kuburena. Da mmko kedane na wawaya gegha vitonana sinarabobona.” ");
INSERT INTO aui_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Wasina bi kiiwawo da yana ababagibagi damdi kadi babada tupadi Jousep yana nuwagiura miisena kiiravine siviwaghasina. ");
INSERT INTO aui_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Na yana wiitamariyana iwonedi bo, “Wiisuwona God kanumina Jousep gwabine; touda gerubana wawaya tana nuwanuwagiurina tana banani ware mmko tomoyina naboni.” ");
INSERT INTO aui_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Na kiiwawo imakewamira iwona bo, “Jousep, God mmkodi bera tupadi tam biidi ivimaghataridi kiiravine, na memeda getana iiyabo meme akakovina bo nuwanuwagiurina tam naboni. ");
INSERT INTO aui_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Anatorem yagu kubura kunibadeni, bi yagu wawaya tupadi sinawaiyanem bi gamom sinakabisisireni. Bi tagu kawagha kiiwawo, kiiravine na yagu wiibadana inagee kirakii gegha tam naboni. ");
INSERT INTO aui_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Tagu kata avineyim da Ijipt kuburina tupana kana wiibadana.” ");
INSERT INTO aui_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Wasina bi kana imakwaki kiiwawo yana matakira debane na tounamani imane ikabitaveni da Jousep imane iviyagha. Bi kiikiiwawo kadi kwama yeyeghaninama ivikoteni bi gould posaru kanighone iviruvivireni. ");
INSERT INTO aui_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Wasina bi kiiwawo Ijipt gamodima Jousep waghawagha ivereni Jepenet-Paniya. Bi bada wasike ivereni da wavinena; kana waghawagha Esenet. Bi tamananaki na Potipera bi On kuburina kana prist. Wasina Jousep Ijipt kuburina tupana ivibadeni. ");
INSERT INTO aui_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Noko raghanine na Jousep kana bodu 30, bi kiiwawo wiibadana ivereni. Na kiiwawo gwabinama ikanibutaveyana da Ijipt kuburina tupana ipepewawiiwoneni. ");
INSERT INTO aui_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Moura bodudi yadi seven kamone, na tanawa kam ghamana ivereyana. ");
INSERT INTO aui_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nokodi bodudi yadi 7 kamone, na Jousep Ijipt kuburina tupane kam ivituwiitaghoma, da kwanatu nunudigha ivimaghara. Kwanatu nunudigha, na kwabu name riridiye na kam nama ivituwiitaghoma. ");
INSERT INTO aui_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Jousep wit kamdi riba kiikiitowana ivitubugha ware egha kikire naboni na gerubana da iyakabirubata maghana. ");
INSERT INTO aui_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Wasina bi moura bodudi yadi 7 Ijipt kubure ipiika tughura, ");
INSERT INTO aui_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","bi bada kapoe bodudi yadi 7 idagu, metagha Jousep ivisisiyana. Kapoe ghamana kubura mududiye bada itubugha, bi Ijipt kuburina tupane na kam nama. ");
INSERT INTO aui_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Bi raghanina Ijipt damdi vitonana sidagu siyaraborabobo, na kiiwawo siyibabiini da kam iyaveredi. Na iwonedi bo, “Konagho Jousep biidi da awaki inawonemina kobera.” ");
INSERT INTO aui_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kapoe kubura tupana ikabimumu bi Ijipt kubure na ibero kirakii da Jousep maghara baredi ikabitavetaveyana bi wit iyigimona Ijipt damdi biiyadi. ");
INSERT INTO aui_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kubura mududiye na bada kapoe ibero kirakii, na wawaya nokodi kuburidima sipiika Ijiptma da Jousep gwabinama wit siyagimona. ");
INSERT INTO aui_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Raghanina Jeikap akowa ikabi da wit name Ijiptne, na natunatuna iwonedi bo, “Awaki tana konabera bo gegha? ");
INSERT INTO aui_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Na mma naboni! Tagu awaiyana da name Ijiptne na wit samakamake. Koyowogha konanagho nabo da wit konagimona kiiravidae, da tanayawa bi gegha tanarabobona!” ");
INSERT INTO aui_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Wasina bi Jousep warewaresina iyiyarokodi yadi 10 siyowogha Ijiptma da wit siyagimona. ");
INSERT INTO aui_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Bi Jeikap inaghara na Jousep tiinaru waghata Benjiman gegha iyiporana basuna kate bi awaki berona touna biidi inakayotubugha. ");
INSERT INTO aui_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kenen kubure kapoe ibero kirakii na Jeikap natunatuna, wawaya mududi yawata siyowogha Ijiptma da wit siyagimona. ");
INSERT INTO aui_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Wasina bi Jousep, Ijipt iyibadeni na raghanine, wawaya biiyadi wit iyigimona kuburina tupane. Na raghanina warewaresina siverakanibu na sipepeteni da mayiyidi siyowogha dobodobove. ");
INSERT INTO aui_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Jousep warewaresina iyiyarokodi ikitarutavedi da iyakovidi bi ibera da ware iyinagonagovedi na iwonaghakighakiyedi bo, “Tami mema kopiika?” Na warewaresina siwona bo, “Kenen kuburama kapiika da kam kanagimona.” ");
INSERT INTO aui_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Jousep warewaresina iyiyarokodi iyakovidi, bi toudi, touna sivinagonagoveni. ");
INSERT INTO aui_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Bi naghove waghata imimeuvedina inoghosi na iwona bo, “Tami na kitawiikighu dammi! Bi yama kubura mekodi noganogadi konakita kiiravine kopiika.” ");
INSERT INTO aui_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bi warewaresina iyiyarokodi siwona bo, “Gegha, bada, toumii na yam wiitamariyana bi kapiika kam kanagimona.” ");
INSERT INTO aui_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Na toudimani sivisisiya siwona bo, “Wiisuwona touda awaki tabera tiidaru biidi, kiiravine na mmko arona takabikabi. Basuna yana nuwavisi metagha na takita bi raghanine yana yawa kiiravine ikabida touda biiyadi, na getayawaiyaneni, noko biidi mmko nuwapoyina tabanabanani.” ");
INSERT INTO aui_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubin iwona bo, “Roro na tagu awaki awonemi, ‘Tomogha gisigisi gegha koniberoni!’ Bi yagu sisiya gekoyawaiyanenina! Na katana yana rabobo miisanina takabikabi.” ");
INSERT INTO aui_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Bi sinoghosi da Jousep yadi gamo geiyawaiwaiyanana basuna Ijipt gamodima iyisisiya bi wawaya tana iyiwaraveredi. ");
INSERT INTO aui_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Wasina bi Jousep warewaresina iwonedi bo, “Maboda kopiika ririguve.” Bi sipiika ririne na iwona bo, “Tagu waresimi Jousep, iiyabo kovigimoneni Midiyan damdi da toudi sikabigu sinagho Ijipt damdi biiyadi. ");
INSERT INTO aui_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na genuwanuwami sinavisi bo tamimani koniwawuvivirana da mabo kovigimonegu, basuna God tounamani iviporagu avinagho da wawaya ayiyawiidi. ");
INSERT INTO aui_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kiiravine kata na bodu bata gomara mmko kuburina kamone. Bi bodu yadi 5 kamodiye na kwabu beradi da kabipura gegha. ");
INSERT INTO aui_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Na God iviporagu avinagho da mmko berakayowiiwiiyakinama ayiyawiimi da nosinosimi viya mmko kuburine sinamake. ");
INSERT INTO aui_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Na getami koyiporagu mabo, bi gegha da God. Na itoregu da kiiwawo yana bada ghamanakina tana, yana wawaya kadi koyakoyagha da kate Ijipt kuburina tupana kana wiibadana. ");
INSERT INTO aui_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Na konagho yaininagha, tamagunaki biidi bi kowoneni bo, ‘Natum Jousep iwona da, “God iberagu da Ijipt kuburina tupana kana bada. Na kuyowogha yaininagha tagu biidi bi gekunimetewana. ");
INSERT INTO aui_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Bi Gosen kubure kunamake, da tagu ririguve - tam, natunatum, tubutubum, yam ribiribi gisigisidi da ghamaghamadi da kate sawara rapemve na tupadi. ");
INSERT INTO aui_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Da name na tagu kam anavereveremi, basuna gomara bodudi yadi 5 katare bada sinapiika. Bi meboda gekonayowogha na tam, yam rakaraka da yam ribiribi yawata tupami vitonana konarabobo.” ’” ");
INSERT INTO aui_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wasina bi Jousep warewaresina iyiyarokodi Ijipt sikanibutaveni siveramagha Kenen kubure tamadinaki biidi. ");
INSERT INTO aui_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Raghanina sipiika na siwoneni bo, “Jousep patana yawayawiina, bi wiisuwona Ijipt kuburina tupana yibadeni.” Jeikap yadi sisiya iwaiyana na nuwanuwana irugaogaowori da gegha iyigeruvedina. ");
INSERT INTO aui_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bi raghanina sisiya tupadi metagha Jousep iwonedi na siwoneni, bi kate ikita da Jousep weigon iviporapora da siyigeru siyaveramagha Ijiptma. Na tamadinaki Jeikap yana noghota inoveramagha. ");
INSERT INTO aui_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Na iwona bo, “Wonawaghata! Natugu Jousep patana yawayawiina. Ananagho anakita bi muriye da anarabobo.” ");
INSERT INTO aui_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wasina bi Jeikap yana sawara tupadi rapenena iguguwa itouya Ijiptma, bi raghanina Biasibama ivera kanibu, na ribiribi tana igabuni da tamananaki Aisik yana God biidi isuwara. ");
INSERT INTO aui_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Bi nubabasuve na God mimeu kamone ivisisiya Jeikap biidi iwona bo, “Jeikap! Jeikap!” Jeikap iwonabodeyana, “Tagu mma.” ");
INSERT INTO aui_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Na God iwona bo, “Taguna God, bi tamamnaki yana God, na gegha Ijiptma yowogha kunanagharenina, kiiravine name anabera da nosinosimi inidam kiitowana. ");
INSERT INTO aui_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Tagu yawata tanayowogha Ijiptma, bi muriye na wiisuwona nosinosimi anakabidi sinaveramagha mabo Kenenma. Bi raghanina kuna rabobona natum Jousep inakabununayim bi inadogum.” ");
INSERT INTO aui_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Wasina Jeikap Biasiba kuburina ikuyoveni, na natunatuna sigeghomiiri tamadinaki, bi toudi natuwavinedi da natunatudi yawata weigonye sivigerudi mekodi kiiwawo iviporaporana. ");
INSERT INTO aui_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Bi kate yadi ribiribi tupadi da sawara rapediye mekodi Kenen kubure siyounana bi siyowogha Ijiptma. Na Jeikap yana rakaraka tupana yawata sinagho natunatuna tomotomogha da wasiwasike da tubutubuna tupadi. ");
INSERT INTO aui_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Gosen kubura siyitutukabikabi na Jeikap natuna Jiuda ivipora, ivinagho da Jousep iyitarakiiyaneni da Gosen kubura kedana iyiyeveveni. Bi raghanina Gosen kubure siverakanibu, ");
INSERT INTO aui_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","na Jousep yana seriyot ikabununagha bi inagho da tamananaki Jeikap iyaverabodeni. Bi ibananidi, na Jousep tamananaki itaraghuni bi iduu kirakii. ");
INSERT INTO aui_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Wasina Jeikap iwona bo, “Jousep, katada akitam bi akovi da yawayawiim na wasina bi nuwamiiseye anarabobo.” ");
INSERT INTO aui_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Raghani viya murine na Jousep siwoneni bo, “Tamamnaki igubaga.” Na natunatuna bata Manasa da Ifreim irutayinidi, bi sinagho da Jeikap siyakita. ");
INSERT INTO aui_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Raghanina wawaya Jeikap siwoneni bo, “Natum Jousep kitam kiiravine ipiika,” na Jeikap (kana waghawagha tana Isrel) ivimaramaragateni da yana kenakena gawarinama ikena geghomiiri. ");
INSERT INTO aui_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Wasina bi Jeikap, Jousep iwoneni bo, “God Maragata Kirakiina irumaghatara tagu biidi Biasiba (kana waghawagha tana Lus) kwanatune, Kenen kubura kamone da ivimiiseyegu, ");
INSERT INTO aui_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","bi iwonegu bo, ‘Natunatum korotodi anaverem, bi nosinosim anaberadi da kadi dam sinakoroto bi Kenen tanavina nosinosim anaveredi, da sinirapenena waghasi.’” ");
INSERT INTO aui_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Bi Jeikap iwona bo, “Natunatum yadi bata, Ifreim da Manasa kiiravidiye, iiyawogha Ijipt kubure situbugha yainagha bi muriye apiika mabo, na tagu rapeguve ware natunatugu Rubin da Simiyon naboni. ");
INSERT INTO aui_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Bi natunatum muriye sinatubughana, tam rapemve bi tanawa sinirapeneyana na turadi iyiyarokodi, Ifreim da Manasa kadi waghawaghae sinayoyo.” ");
INSERT INTO aui_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Jousep natunatuna bata ipiikedi, da Ifreim, na Jeikap dugenama ikabi wiimiiri, bi Manasa na, Jeikap katiiyanama ikabi wiimiiri. ");
INSERT INTO aui_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","21","Bi gegha, Jeikap imana ivikasiruwireni, da katiiyana Ifreim gayamine itore bagune touna murimurina, bi dugena Manasa gayamine itore bagune touna iyarokona. Bi raghanina Jousep ikita da tamananaki katiiyana Ifreim gayamine itore, na geiyinuwamiisena. Na tamananaki imana ikabi, ware Ifreim gayaminama iyakabitaveni bi Manasa gayamine iyatore na iwona bo, “Gegha, tamada! Manasa iyarokona, katiiyam gayamine kutore.” Bi tamananaki isinighii na iwona bo, “Natugu, akovi awaki aberabera. Manasa kana waghawagha inaragata bi nosinosina inidam kiitowana, bi gegha da, tiinaru inage kirakii bi nosinosina kadi dam sinakoroto.” Na noko gabudarine ededidi bata ivimiiseyedi iwona bo, “Yagu God, iiyabo tamagunaki Aisik da tubugunaki Abraham siyapeepetenina, God, iiyabo yagu yawa tupane ikoyayigu ware sip kadibodaboda naboni, Yam aneya, iiyabo bero tupadi gwabidima ivitarababaranegu, na mmkodi tomotomoyidi inimiiseyedi. Basuna mmkodi tomotomoyidi kiiravidiye na, wawaya kagu waghawagha da tamagunaki Aisik kana waghawagha da tubugunaki Abraham kana waghawagha sinanoghota wiiwoneni, bi anoghonoghosi da nosinosim korotodi mmko kuburine sinatubugha. Isrel damdi kami waghawaghae raghanina wiimiiseyana sinaberabera, na sinawona bo ‘Karurupari da God wiimiiseyana inaverem naboni Ifreim da Manasa iveredina.’” Na Jeikap noko kedane Ifreim kana waghawagha itore ivinagho bi Manasa kana waghawagha ivimuri. Wasina bi Jeikap, Jousep ivimiiseyeni iwona bo, “Jousep, kukita, pinimina bi anarabobo, bi God na gwabimiye, da inakabimi konaveramagha Kenenma nosinosinakimi yadi tanave.” ");
INSERT INTO aui_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Jiuda, warewaresim sinakabepepim da sinapepetem, basuna kam aviya kanighodiye kwayouna da kwageiwayidi. ");
INSERT INTO aui_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Tam ware laiyon natuna, tam kunimaragata da wawaya kunibadedi. Bi ware laiyon meko kana iyuwa yaburavi yakani, bi yaveramagha yakenayowogha da yiyawiitaveyana. Bi iiyabo rubana inanagho da inakasiwiimataki? Getana da iiyabo! ");
INSERT INTO aui_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Bi Yawe God yana wiikiiwawo matakirina dighonina, na Jiuda imane inamake bi nosinosina nonowa sinibada patana da iiyabo noko wiibadana rapene inapiika na dam tupadi sinakabikuwayeni.” ");
INSERT INTO aui_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Raghanina Jeikap natunatuna iwonawiiyoyowanedi ikovi, na kayena itourageegeeyana yana kenakena gawarine bi ikenayowogha. Da yawiina itavena tughureni bi irabobo. ");
INSERT INTO aui_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Raghanina Jousep warewaresina sakovi da tamadinaki irabobo, na toudimani sivisisiya bo, “Memeda Jousep patana nuwanuwana touda biiyadi inapughu da awaki bera berodi naghove tabera touna biidi na kana biwa inakabi.” ");
INSERT INTO aui_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Na sisiya sidaru Jousep biidi, siwona bo, “Tamadanaki mmkodi wonawiiyoyowanama iwonemii bi muriye da irabobo. ");
INSERT INTO aui_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Mma naboni Jousep konawoneni, “Ibabiim da warewaresim yadi tamumu da kate berona sibera da sivikayotaketowanem na kunoghotatavedi.” ’ Na katana kiibabiim da toumii na tamamnaki yana God yana wiiwiitamariyana, na yama berona kunoghotatavedi.” Raghanina Jousep mmko sisiyina iwaiyaneni na idou. ");
INSERT INTO aui_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Wasina bi warewaresina sipiika da naghone sipepeta siyowogha dobodobove, bi siwona bo, “Kita, toumii na yam wiiwiitamariyana.” ");
INSERT INTO aui_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Bi gegha da Jousep iwonedi bo, “Gekonanagharana, tagu na gegha God, bi gebiwa anaveremina. ");
INSERT INTO aui_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Naghove yami kayowana da koyiberogu, bi God ikayoveni na iwamiri da miisena ibera, da wawaya korotodi gegha sinarabobona, bi yawayawiidi sinamake naboni kata takitakitana. ");
INSERT INTO aui_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Na noko biidi gekonanagharana, tami da natunatumi gisigisidi anabodami.” Noko naboni, iwonawiiyoyowanedi bi nuwamiimiiseye ivisisiya toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Raghanina Jeikap inagho Ijiptma na natunatuna, ere natuwavinedi da natunatudi yawata sinagho, na kadi waghawagha na: ");
INSERT INTO aui_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubin, Simiyon, Livai, Jiuda ");
INSERT INTO aui_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Jebulan da Benjiman, ");
INSERT INTO aui_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neptalai, Ged da Aser. ");
INSERT INTO aui_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Noko raghanine Jeikap natunatuna tomotomoyidi da tubutubuna tomotomogha tupadi na yadi 70. Bi natuna Jousep na nada name Ijiptne iyamakamake. ");
INSERT INTO aui_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Bi noko murine, na Jousep warewaresina teya tupadi, da kate bada wawaya iiyawogha noko raghanine siyamakamake na sirabobo. ");
INSERT INTO aui_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Bi nosinosidi, Isrel damdi, sivituwa wiipeyara da ividam kiitowana. Toudi sivikoroto kirakii da noko kuburina sivibonuvi. ");
INSERT INTO aui_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Bodu viya murine na kiiwawo wouna, iiyabo touna Jousep geiyakovina, idagu Ijipt kuburina iyibadeni. ");
INSERT INTO aui_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Na yana wawaya iwonedi bo, “Kowaiyana, Isrel damdi sikoroto bi sivimaragata kirakii da yadi koroto ikasiwoneda genaboni touda. ");
INSERT INTO aui_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Memeda touda biiyadi aviya inatubugha, na kada aviya sinirukapuvedi siniaviyeda da sinagetawanida bi sinavera sinanagho yada kubura sinakuyoveni. Na keda taninoyeni bi yadi koroto tana yarayi da gegha sinakoroto kirakiina.” ");
INSERT INTO aui_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Wasina bi Ijipt damdi sibera da bagibagi ghamana Isrel damdi siyaberabera kiiravidiye, bi wiibagubagurana kadi babada sitoura da siyibadedi. Nokodi babada siberadi da kwanatu ghamaghamadi yadi bata siyoghana, kadi waghawagha Pitom da Ramesis naboni wiimaghara kwanatudi, meme kiiwawo kana kam da sawara mududi iyatoura. ");
INSERT INTO aui_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Bagune Ijipt damdi bagibagi ghamadima Isrel damdi siyikayotaketowanedi, bi gegha da, Isrel sikoroto kamokamogha da noko kuburina tupana sivibonuvi. Na Ijipt damdi parapa siyanaghanaghara. ");
INSERT INTO aui_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Bi siberadi da sibagibagi kirakii da parapa sikabikwarakwara. Bi siyatupetupedi na brik siyaberabera da kate dobodobo siyawamiwamira brik pasitawanidi kiiravine. Bi bada siyawonewonedi na kwabu bagibagidi tupadi siyaberabera. Ijipt damdi nuwapoya ghamana Isrel siyavereveredi yadi bagibagi kamone bi gesiyanuwaghanedina. ");
INSERT INTO aui_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Wasina bi Ijipt kana kiiwawo yana wawaya iwonedi bo, “Raghanina Hibru damdi natunatudi tomotomogha sinatubugha, na Nail rarimine konitavena yowoyowoghana. Bi raghanina wasiwasike sinatubugha, na wasina sinamake.” ");
INSERT INTO aui_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Noko raghanine bera siyatubutubugha, na tomogha tana kana dam Livai bi dam turanama wasike irawayi, ");
INSERT INTO aui_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","da wasikena iropeya bi ivituwa da natuna tomogha. Bi ikita da pepeyina komerowanina, na Ijipt damdi nagharidi na ivikowoyi da nawaravi aroba sikovi. ");
INSERT INTO aui_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Bi raghanina gerubana iyikowogha wiigurina na tobo, rei kana waghawagha papairasma sibera na ikabi bi pakima ipasibodaboda. Wasina bi pepeyina iuveni kamone bi Nail rarimina kawabarane siviya kamodiye ivitenamni. ");
INSERT INTO aui_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Pepeyina toghanaru wasike kana taraboga imiiri bi iyaruruwiitete da awaki iyatubugha pepeyina biidi. ");
INSERT INTO aui_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Bi noko raghanine kiiwawo natuna wasike iyowogha rarime wiiyeka kiiravine, na yana wiitamariyana wasiwasikedi rarima kawabaranagha siyitutubata siyanono bi siyapiipiika. Bi tobona siviya kamodiye ikita, na yana wiitamariyana wasikena tana ivipora da rarimama iyatayinageeyeni. ");
INSERT INTO aui_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Bi raghanina tobona iyarukwouve, na pepeya ikita, iyaduuduna ivinuwapoyeni, na iwona bo, “Aki-i-i-i, mmkona Hibru damdi natudi tana.” ");
INSERT INTO aui_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Wasina bi pepeyina toghanaru inagho da kiiwawo natuna iwoneni bo, “Rubana da ayanagho Hibru wasike tana ayinoyeni da mmko pepeyina iyakoyayi da kiiravimve iyisusu?” ");
INSERT INTO aui_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Na kiiwawo natuna iviwaghasina iwona bo, “Wasina, kunagho!” Na wasikena inagho da pepeyina sinananaki waghata irutayini ipiika. ");
INSERT INTO aui_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Na kiiwawo natuna iwona bo, “Mmko pepeyina kabi da kiiraviguve kunisusu, bi animiisanim.” Na wasikena natuna ikawari inagho bareye na ivisusu da ikoyayi. ");
INSERT INTO aui_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Raghanina pepeyina ivimagura bi wiikaratavenina kiiravine, na ikabi inagho kiiwawo natuna biidi da iyayabiyi naboni natuna. Na iviwaghawaghayeni Mosis, iwona bo, “Tagu rarimama atayinageeyeni.” ");
INSERT INTO aui_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Raghanina Mosis nada ivimagura, bi bodu viya sikovi murine, na kiiwawo yana bare ikanibutaveni inagho da yana wawaya iyarubodadi, na Ijipt damdi ikitadi da metagha Hibru damdi siyabagubaguredi bi bagibagi ghamadi siyaberabera. Noko raghanine, ikita da Ijipt tomogha tana Hibru tomogha iyarurouvi, yana wawaya waghata tana. ");
INSERT INTO aui_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Na Mosis ikita wiiveravera, da wawaya gesiyakitakita, na yaininagha Ijipt tomogha ikasunuyi bi tubuyina eghae itouna wiikowoyi. ");
INSERT INTO aui_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Raghani iborina Mosis ikanibu magha da yana wawaya iyarubodadi, na Hibru tomotomogha bata siyirouwa na ikitadi. Bi tomogha mekona iberabero na ivitarakiiyaneni bo, “Awaki kiiravine dam turam kwarourouvi?” ");
INSERT INTO aui_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Tomoyina iwonabodeni bo, “Awaki, iiyabo itorem da kunibademii bi kama wiitupawamiwamira? Bo kwanuwanuwagiura da kunirabobogu ware Ijipt tomogha kukasunuyina naboni?” Na Mosis inaghara bi inuwagiura da, “Wawaya nada sibananigu bi sakovi da awaki abera.” ");
INSERT INTO aui_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Raghanina Ijipt kana kiiwawo mmko warana iwaiyaneni, na iberatowoyi da Mosis iyakasunuyi. Bi Mosis, kiiwawo gwabinama iverataveyana inagho Midiyan kubure da name imakae. Bi iverakanibu na dogu tana ririne itourawiipikapika imakae. ");
INSERT INTO aui_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosis rawananaki Jetro yana sip da gout iyakoyakoyagha. Jetro na Midiyan kubura kana prist tana. Bi gabudara tana ribiribidi ivinaghokedaridi sikanibu mayabe da Sainaima siverakanibu, koya kabikabikuwayine. ");
INSERT INTO aui_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Noko gawarine Yawe God yana Aneya irumaghatara Mosis biidi, kana kita ware keyama gweyurina naboni kiikiiruku basunama iyapiipiika. Mosis ikita da kiikiirukuna iruwiinawa bi gegha iyakarataveni. ");
INSERT INTO aui_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Na Mosis inuwagiura, “Awaki biidi mmko kiikiirukuna geiyakaratavenina? Ananagho wiitupo da anakita.” ");
INSERT INTO aui_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Raghanina Yawe God ikita bi Mosis iyapiipiika wiitupo na kiikiiruku kamonama ikwatu bo, “Mosis! Mosis!” Bi Mosis iwona bo, “Uu, tagu mma.” ");
INSERT INTO aui_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Na God iwona bo, “Gegha kunapiika wiitupo kiikiiruku ririnena. Mmko gawarina debane kwamiimiiri na tanawa kabikabikuwayina, na kam kaye turababara kabitavetaveyana.” ");
INSERT INTO aui_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Bi iwona bo, “Tagu nosinosiminakim yadi God - Abraham, Aisik da Jeikap yadi God.” Raghanina Mosis mmko iwaiyaneni na inaghara da gegha God kitana iyakayoveni, na mayiyina ikasibabari. ");
INSERT INTO aui_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Wasina bi Yawe God iwona bo, “Tagu akita da metagha Ijipt yagu wawaya siberaberowanedi na yadi dou, yagu wiiwiita sikayoveni kiiravine awaiyana na kadi tupetupeyana damdi gwabidima ayiyawiidi. Yadi kabikwarakwara na akovi. ");
INSERT INTO aui_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Na ayowogha da Ijipt damdi gwabidima aniyawiidi da anakabidi Ijipt sinakanibutaveni bi sinanagho kubura miisene, mekona ghamana bi moumourina, meme katana dam Kenen, Hitti, Amori, Periji, Hivi bi kate dam Jebusi nama samakamakena. ");
INSERT INTO aui_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Wiisuwona, yagu wawaya yadi dou nada awaiyana. Bi akita da Ijipt damdi metagha sikayotaketowanedina. ");
INSERT INTO aui_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Na kata iiporam, kunanagho Ijipt kana kiiwawo biidi, da yagu wawaya Isrel damdi kuninaghovedi bi Ijipt sinakanibutaveni.” ");
INSERT INTO aui_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Bi Mosis, God iwoneni bo, “Tagu na gerubagu. Metagha ananagho kiiwawo biidi da Isrel damdi aninaghovedi Ijipt sinakanibutaveni?” ");
INSERT INTO aui_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Bi God iwona bo, “Tagu na tam gwabimve. Bi noko raghanine wawaya kuninaghovedi da Ijipt sinakanibutaveni, na mmko koyane konakabikuwayegu. Noko berana inimatakira da kunakita bi murine, na wiisuwona tam kunakovi da taguwosina aviporam.” ");
INSERT INTO aui_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Bi Mosis iwona bo, “Raghanina ananagho Isrel damdi biiyadi anawona bo, ‘Nosinosidanakim yadi God iviporagu tami biiyadi,’ na sinitarakiiyanegu, ‘Kana waghawagha metagha?’ Na awaki anawonedi?” ");
INSERT INTO aui_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Na God, Mosis iwoneni bo, “Tagu Makewaghawaghasigu, da gegha tughurina.” Na Isrel damdi kunawonedi, Noko, kana waghawagha na, “Tagu Makewaghawaghasigu,” touna iviporagu tami biiyadi. ");
INSERT INTO aui_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Isrel damdi kuwonedi, Yawe, nosinosidanakim yadi God - Abraham, Aisik, da Jeikap yadi God, iviporagu tami biiyadi. Mmkona kagu waghawagha makewaghawaghasina. Mmko kimtina tupadi na kagu waghawagha naboni sinakwatuveni. ");
INSERT INTO aui_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yawe God, Mosis iwoneni bo, “Tagu aro raghani tanagha Ijipt kana kiiwawo da yana wawaya teya anaveremayedi. Noko murine na kate kiiwawo iniwaghasinemi da konanagho, bi raghanina iniwaghasinemi, na inikanibuvena waghasimi. ");
INSERT INTO aui_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Na kunagho Isrel damdi kunawonedi bo, ‘Tami tupami konagho Ijipt damdi biiyadi, mekodi ririmiye samakamakena, bi awaki sawaridi gould da silvama sibera, na kiiravidiye konibabiidi.’” ");
INSERT INTO aui_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Na Yawe God, Ijipt damdi iberadi da Isrel damdi sikabikuwayedi. Bi wiisuwona, Mosis kana waghawagha Ijipt kamone iragata kirakii, kiiwawo yana bagibagi damdi ghamaghamadi matadiye da yana wawaya tupadi. ");
INSERT INTO aui_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Wasina bi Mosis inagho da kiiwawo iwoneni bo, “Yawe God iwona bo, ‘Kata pomkam basune, Ijipt tupana anaverarughuwoneni, ");
INSERT INTO aui_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","da ededa tomotomoyidi tubugha-yainidi tupadi Ijipt kamone sinarabobo. Dagudagune na kiiwawo natuna gwabinama inadagu, meko wiikiiwawo gawarina iyakabina, bi inayowogha inanagho bagibagi damdi, mekodi wit sagudaguda, na natunatudi tubugha-yainidi biiyadi. Ribiribi tupadi natunatudi tubugha-yainidi bada sinarabobo. ");
INSERT INTO aui_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Meghamegha Ijipt kamone na wawaya sinaduudu siyapa. Bi siyapa mma naboni naghove na gegha, bi muriye na bada kate genaboni inatubugha maghana. ");
INSERT INTO aui_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Bi getana awaki inatubugha Isrel damdi biiyadi, bo bero gisina tana inatubugha toudi biiyadi, daghasi kate gegha Isrel damdi bo yadi ribiribi inakawonedina. Wasina bi tami Ijipt dammi konakovi da, Tagu Yawe God, Isrel damdi avibogaedi tami gwabimima.’ ");
INSERT INTO aui_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Yam ababagibagi damdi kadi babada ghamaghamadi sinapiika naghoguve sinapepeta sinayowogha bi sinawona bo, ‘Tam da yam wawaya tupadi yawata, konagho!’ Bi noko murine, tagu ananagho.” Bi Mosis nuwanuwana ipughu kirakii na kiiwawo ikuyoveni inagho. ");
INSERT INTO aui_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Wasina bi Yawe God, Mosis iwoneni bo, “Kiiwawo kate gegha gamom inawaiyaneni. Bi mmko mma naboni na Tagu kate Ijipt kamone berakayowiiwiiyaka mududi bada anabera.” ");
INSERT INTO aui_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosis da Eron mmkodi berakayowiiwiiyaka tupadi Ijipt kana kiiwawo matane sibera, bi Yawe God ibera da kiiwawo nuwanuwana ikotakii, na Isrel damdi geiyiwaghasinedi da Ijipt siyakanibutavenina. ");
INSERT INTO aui_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yawe God Ijiptne Mosis da Eron biiyadi mma naboni iwonedi, ");
INSERT INTO aui_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mmko nawaravina konatore kiiravimiye da bodu dagudaguna nawaravina. ");
INSERT INTO aui_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isrel damna tupana kowonedi da gabudara yadi 10 mmko nawaravina kamone tomogha tupadi nigenige bo gout tana sinavineyi yadi rakaraka kiiravine, bare nunudigha na tanagha. ");
INSERT INTO aui_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Bi meboda tomogha tana yana bareye wawaya gekorotodi sinamakamake bi gerubana da noko ribiribina tupana sinakani, na turadi teya sinikamvereyana, mekodi nama riridiye samakamakena. Bi ribiribina yadi koroto rubane sinarereyi da wawaya rubadiye sinakam. ");
INSERT INTO aui_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tami sip bo gout tanagha konavineyi, bi makina, kana bodu tanagha bi tubuyina miisena. ");
INSERT INTO aui_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Kokoyagha yapora patana da gabudara 14 mmko nawaravine, bi noko raghanine gabudara inamakepowa na Isrel damna tupana nokodi ribiribidi sinikasunughana. ");
INSERT INTO aui_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wasina bi ganiganina muduna yami bare matamketadi koghoridi nawanawadiye konakwamira da kate matamketa wowodiye, meme tami kamone konakamkamna. ");
INSERT INTO aui_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Noko pomne iyuvidi konawatara keyama wowone, bi kiimatagha kawagabegabedi da parawa gegha yist teya konakam wiikaninigha. ");
INSERT INTO aui_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mma naboni konakam: Tami pepewa kiiravine konakounagha, kamikaye turababara konakoteyana bi yami dighona imamiye konakabitawana. Konakam kabiyaininagha. Mmkona Koughanu porayina da Tagu, Yawe God konakabepepigu. ");
INSERT INTO aui_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Noko pomna tanagha, Ijipt kuburina tupana anaverarughuwoneni da tomotomogha tubugha-yainidi tupadi anunugha, wawaya da ribiribi. Tagu na Yawe God, bi god gisigisidi kadi waghawagha anatourayowoeyana, noko mekodi Ijipt damdi sapeepetedina. ");
INSERT INTO aui_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Bi ganigani matamkete na yami bare kana matakira, bi iniyevevegu da nokodi barediye na nama kamone komakamake; bi raghanina ganiganina anakita, na anaveratupiiremi. Bi getana awaki berona tami biiyadi inatubughana raghanina Ijipt kuburina biwa anavereverenina. ");
INSERT INTO aui_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mmko porayina bodu nununagha konabera gabudarina mayimayiyina, na Tagu Yawe God awaki abera na nonowa konanoghonoghosigu. Kimta muriye sinapiikana, tami mmko porayina raghani nonowa konaberabera, bi konakabikabitawani.” ");
INSERT INTO aui_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Bi gabudara 7 kamodiye na parawa gegha yist teya sinabera na konakam. Poragha gabudarina dagudagune na yist tupadi yami barema kovitavena kanikanibuwana. Bi iiyabo parawa yist teya sibera bi mmkodi gabudaridi yadi 7 kamodiye inakamkam na dam Isrel kamonama sinikanibuveni. ");
INSERT INTO aui_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Gabudara dagudagune da kate poragha gabudarina tughurine na konitaghomimi kabikuwaya kiiravine. Mmkodi gabudaridi kamodiye na getana bagibagi konaberana, da kam kawagha konakabikuya. ");
INSERT INTO aui_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Tami Parawa Gegha Yist Teya porayina konabera na yami noghota sinaveramagha da metagha noko gabudarine yami rakaraka da kami dam avinaghovedi Ijipt kuburina sikanibutaveni. Noko gabudarine mmko porayina konaberana naboni poragha naghowiikarukaruna.” ");
INSERT INTO aui_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Wasina bi Mosis, Isrel kana babada tupadi ikwatuwiitaghomidi bi iwonedi bo, “Konagho yaininagha da sip bo gout natuna tana konavineyi yami rakaraka kiiravidiye bi konakasunuyi da Koughanu porayina konakam patapata. ");
INSERT INTO aui_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bi kii kana waghawagha hisop konayouna da gumba konabera bi ribiribi ganiganine kaboma kamone konasirakutuvi, bi ganiganinama yami matamketa wowone da nawanawadiye kiiye kokasikwamikwamira. Bi getana iiyabo bare inakanibutavenina patana da raghani inabori. ");
INSERT INTO aui_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Raghanina Yawe God kubura tupana inaverarughuwoneni Ijipt damdi kasunuyidi kiiravine, na ganigani matamketa wowone da nawanawadiye inakita, na noko barena inakoughanuni, bi gegha yana kasunugha Aneyina iniwaghasineni da yami bare kamodiye inarughu da natunatumi tomotomoyidi tubugha-yainidi inirabobodina. ");
INSERT INTO aui_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mmkodi wonawiiyoyowana konakabisisirena nonovedi kiiravimiye, tami da nosinosimi. ");
INSERT INTO aui_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Raghanina Yawe God meko tanavina ivisuwona da inaveremi na name konarughuna, mmko porayina bodu nunudigha konaberabera. ");
INSERT INTO aui_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Raghanina natunatumi sinitarakiiyanemi bo, ‘Mmko porayina yana basuna awaki tami biidi?’ ");
INSERT INTO aui_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Na konawona bo, ‘Mmkona Koughanu suwarina Yawe God biidi, iiyabo naghove Ijiptne yada bare iverakoughanudi da inuwatawanidi bi Ijipt damdi natunatudi tomotomogha tubugha-yainidi iunugha raghanine.’” Wasina bi wawaya sipepeta Yawe biidi da sikabepepi. ");
INSERT INTO aui_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Na Isrel damdi sinagho da metagha Yawe God, Mosis da Eron iwonedi na naboni sibera. ");
INSERT INTO aui_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pomkam basuve na Yawe God Ijipt kubure tubugha-yainidi tupadi iunugha, dagudagune na kiiwawo natuna tomogha tubugha-yainina gwabine idagu, iiyabo wiikiiwawo gawarina iyakabina, bi iyowogha inagho biwa kabikabina biwa gawarina kamone, natuna tubugha-yainina, da kate ribiribi natunatudi tubugha-yainidi tupadi. ");
INSERT INTO aui_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Bi nubabasuve na kiiwawo, yana bagibagi babadidi ghamaghamadi yawata da kate Ijipt damdi tupadi simatakana sigeghomiiri, bi nama Ijipt kamone na duu siyapa ghamana, kiiravine getana bare nama wawaya raborabobona iyakabiwiiadina. ");
INSERT INTO aui_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Wasina bi Ijipt kana kiiwawo nubabasuve Mosis da Eron ikwatuvedi sipiika bi iwonedi bo, “Kogeghomiiri! Yagu wawaya kokuyovedi, tami da Isrel damdi! Konagho, yagu kubura kokanibutaveni da Yawe God konakabepepi metagha kovibabana. ");
INSERT INTO aui_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Yami sip, gout da kau tupadi korutayina, konagho, metagha kowonana. Bi kate yami God kovibabiini da wiimiiseyana inaveregu.” ");
INSERT INTO aui_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Na Ijipt damdi siruwiiyaininagha da Isrel damdi yadi kubura siyakanibutaveni, siwona bo, “Meboda gekonanona, toumii tupamii kanarabobo.” ");
INSERT INTO aui_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Wasina noko raghanine Isrel damdi Ramesis kwanatuna sikuyoveni bi kayegha sitouya siyanono Sukot kubure. Na tomotomogha yadi 600,000, bi wasiwasike da ededa na gegha kabikabiyawa wiikapudina. ");
INSERT INTO aui_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Wawaya korotodi iiyawogha gegha Isrel damdi na yawata sinagho, sip, gout da kau peyaridi yawata. ");
INSERT INTO aui_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Raghanine Ijipt damdi sikwavinidi na toudi siviyaiyainagha da gegha taraboga meme da kadi kam siyakabikuya, bi parawa wamiwamiridi gegha yist teya sikawara. Na nokodi parawa wamiwamiridi gegha yist kamodiye na toudima bred benabenadi sigibu. ");
INSERT INTO aui_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isrel damdi na bodu yadi 430 Ijipt kubura kamone simakae bi muriye sikanibutaveyana. ");
INSERT INTO aui_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yawe God, Mosis da Eron iwonedi bo, “Koughanu porayina siradi mmakatanidi: kuburawiibata wawayidi gesinakanina. ");
INSERT INTO aui_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Yami wiibagubagurana mekodi manema kogimona na sinakani, bi dagudagune na sinibori konaveredi. ");
INSERT INTO aui_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Kuburawiibata damdi iiyawogha samakamake gubaguba kamomiye da kate bagibagi wawayidi iiyawogha kwiimiisanidi na, gesinakanina. ");
INSERT INTO aui_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Tami Koughanu nigenigena bare tanagha kamone konakani, bi iyuvina getana noko barenama konakawari konakanibu maghatarena, bo gegha irikena tana konagiinina. ");
INSERT INTO aui_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isrel dammi tupami mmko Koughanu porayina konakani.” ");
INSERT INTO aui_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Wasina bi Yawe God, Mosis iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Tomotomogha tubugha-yanidi tupadi kutoura irirana kiiraviguve. Bi Isrel damna kamodiye na tomotomogha tubugha-yainidi tupadi, meboda wawaya bo ribiribi, na tagu rapeguve.” ");
INSERT INTO aui_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Yawe God inakabimi, konanagho Kenen damdi yadi kubure da inaveremi, metagha nosinosiminakim ivisuwonedina. Raghanina mmko berana inaberana ");
INSERT INTO aui_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","tami natunatumi tubugha-yainidi da ribiribi natunatudi tubugha-yainidi na Yawe God konapuyoni. Ribiribi makidi mekodi tubugha-yainidi tupadi na rapene. ");
INSERT INTO aui_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bi donki tubugha-yainina wasana na nigenigema Yawe God konimiisaneni naboni donki kanamiisana da konakabi mayeni. Bi memeda donki tubugha-yainina gegha konimiisana da konagimona mayeni na kanighona koturaviroyi. Bi natunatumi tomotomogha tubugha-yainidi na konimiisana da konagimona mayedi. ");
INSERT INTO aui_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Raghani muriye natunatumi sinitarakiiyanemi, ‘Awaki kiiravine mmko berana tabera?’ Na konawonedi bo, ‘Yawe God yana maragata ghamanama Ijipt kuburinama irutayinida takanibutaveyana, bi noko kuburine tabagibagi naboni bagubagurana. ");
INSERT INTO aui_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Bi Ijipt kana kiiwawo nuwanuwana ikotakii na geiyiwaghasineda da taya kanibutaveyana, na Yawe God tomotomogha tubugha-yainidi Ijipt tanavina kamone iunugha, wawaya da ribiribi tupadi yawata. Noko kiiravine touda tomotomogha tubugha-yainidi tupadi Yawe God biidi tasuwasuwara, bi natunatuda tubugha-yainidi tagimogimona da tiiveramaghamayedi.’ ");
INSERT INTO aui_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mmko berana na wonawiinoghota, naboni matakirina imamiye bo kounagha maitepamiye, da Yawe God yana maragata ghamanama Ijipt tanavinama ivikanibuveda.” ");
INSERT INTO aui_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Noko murine Sukot kubura sikuyoveni sinagho mayaba kawabarane kubura Itemne sivitaki. ");
INSERT INTO aui_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yawe God na iyinaghonagho, gabudare na uwa ware madasoru kamone bi iyinagho iyanono, bi nubabasuve na keyama pepana ware madasoru kamone bi iyinagho iyanono da yeghana iyavereveredi. Bi mmko kedane na rubana gabudare da nubabasuve siyapeepewa. ");
INSERT INTO aui_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Wasina, raghanina kiiwawo siwoneni da Isrel damdi sivera, na yana bagibagi damdi kadi babada ghamaghamadi teya yadi noghota siwamiri siwona bo, “Mmko awaki berana tabera? Nokodi Isrel damdi taviwaghasinedi sinagho na kata gesinabagibagiyena mayedana!” ");
INSERT INTO aui_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Wasina bi kiiwawo yana seriyot ikabununagha da iyo wawayidi iyouna. ");
INSERT INTO aui_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Bi nuwanuwana seriyotidi miisedi yadi 600 iyouna da kate Ijipt kana seriyot mududi, tatadigegha na ere aviya badana. ");
INSERT INTO aui_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Bi Yawe God, Ijipt kiiwawona iberani da nuwanuwana ikotakii, na Isrel damdi iverakwavinidi inagho. Bi Isrel damdi na nuwanuwadi torane bi siyakanikanibutaveyana. ");
INSERT INTO aui_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Na Ijipt damdi siverakwavinidi sinagho - kiiwawo, yana seriyot, iyo tomotomogha hosiye tupadi, da iyo tomotomogha kayegha bi kubura Pi-ahirotne sikabitawanidi, Yegii Idurina ririne meme sivitakina, kubura Baal-Jipon ririne. ");
INSERT INTO aui_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Raghanina Isrel damdi sikita bi Ijipt kana kiiwawo yana aviya damdi yawata nada siyitutuwiikabikabidi, na sinaghara kirakii da wiiwiita kiiravine Yawe God biidi sidou. ");
INSERT INTO aui_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Na Mosis siwoneni bo, “Ijiptne karawaga gegha, kiiravine na mabo kupiikemii mayabe da kanarabobo? Awaki berana kubera da Ijiptma kuvikanibuvemii? ");
INSERT INTO aui_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Raghanina Ijiptne taya makamakena kawonem bo, ‘Kuyovemii, da Ijipt damdi kana bagibagiyedi!’ Bi Ijipt damdi yadi wiibagubagurana kayamakae na iyamiise, bi gemayabe rabobo biidi!” ");
INSERT INTO aui_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Bi Mosis iwonedi bo, “Gegha konanagharana! Yami miimiiriye komiiri bi konakita da awaki Yawe God inabera da kata iniyawiimi. Bi mmkodi Ijipt damdi kata kokitakitadi, na gekonakita mayedina. ");
INSERT INTO aui_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yawe God kiiravimiye inirouwa, bi getana awaki konaberana, komake wiiraborabobo.” ");
INSERT INTO aui_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Wasina bi Yawe God Mosis iwoneni bo, “Awaki kiiravine Tagu biidi kwaduudu? Isrel damdi kuwonedi sinanagho. ");
INSERT INTO aui_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Yam dighona kurukabepi bi yegiiye kukoghasi inakanibu da yegii inatupayarayi bi Isrel dammi tanawa kanakananagha konapepewa rughuwona. ");
INSERT INTO aui_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Kukita, tagu, Ijipt damdi nuwanuwadi anikotakiidi da murimigha sinakivinimi sinayowogha yegiiye. Bi Ijipt kana kiiwawo, yana seriyot, iyo tomotomogha hosiye anageiwayidi, na wawaya sinakabepepigu. ");
INSERT INTO aui_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Raghanina kiiwawo, yana seriyot da iyo tomotomogha hosiye anageiwayidi na Ijipt damdi sinakovi da Taguna Yawe God.” ");
INSERT INTO aui_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Wasina bi God yana Aneya, Isrel damdi naghodiye iyanono, na ivituramiiriyeni bi iveramagha muridiye. Bi uuwa ware madasoru naghodiye iyanono, na bada ivimuritayina da muridiye imiiri. ");
INSERT INTO aui_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Bi uuwa, Ijipt damdi da Isrel damdi basudiye imiiriyarayidi. Noko nubabasune wiididibara Ijipt damdi iveredi, bi yeghana Isrel damdi iveredi, kiiravine na noko nubabasu gurigurina Ijipt damdi da Isrel damdi gerubadi siyimiiriruriya kabivivirana. ");
INSERT INTO aui_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Wasina bi Mosis imana ikoghasi ikanibu yegiiye, na Yawe God raghani matana yanununa maragasina ivipora, da noko nubabasu gurigurina yegii itapini da ivibogabogae, da tanawa kanakanana itubugha. ");
INSERT INTO aui_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Bi Isrel damdi tanawa kanakanane sipepewa rughuwona, bi rarima ware papa naboni katiiyadiye da dugediye siyamiimiiri. ");
INSERT INTO aui_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Wasina bi Ijipt damdi Isrel siverakwavinidi - kiiwawo yana hosi, seriyot da iyo tomotomogha hosiye tupadi muridigha siyowogha yegii kamone. ");
INSERT INTO aui_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Bi raghani boriboriye Yawe God uuwa da keyama madasoru kamodima, ikayogenara Ijipt damdi biiyadi da ikasiwiineghaneghadi. ");
INSERT INTO aui_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yadi seriyot kayedi ibera da sitamotavetaveyana, da gerubana siyaverana. Na Ijipt damdi siwona bo, “Yawe God na Isrel damdi yiwiitedi, da touda Ijipt damda yiaviyeda, na kokayotanavera magha!” ");
INSERT INTO aui_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Wasina bi Yawe God, Mosis iwonena mayeni bo, “Imam kukoghasi inakanibu yegiiye da yegii inanoveramagha, bi Ijipt damdi yadi seriyot da iyo tomotomogha hosiye inakutuvidi.” ");
INSERT INTO aui_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Na Mosis imana ikoghasi ikanibu yegiiye, bi raghani ibori na yegiina iveramagha kana gaware da ikasiwiikapu mayeni. Ijipt damdi sivimatipo da siyaverataveyana, bi gegha, Yawe God yegiiye ivitavenayowoyowoyedi. ");
INSERT INTO aui_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Rarimina iveramagha ikasiwiikapu da kana gaware na Ijipt damdi mekodi Isrel damdi sikivinidi siyowogha yegiiye na tupadi ikutuvidi. Nokodi seriyot, iyo tomotomogha hosiye da iyo damdi getana da siyayawana. ");
INSERT INTO aui_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Raghanina Isrel damdi Yawe God yana maragata ghamana sikita, da metagha Ijipt damdi igeiwayidi, na sikabikuwayena kirakiiyeni bi yadi wiitumaghana touna da yana wiitamariyana Mosis gwabidiye sitore. ");
INSERT INTO aui_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Wasina bi Mosis da Isrel damdi Yawe God biidi mmko ayinama sikabepepa, mma naboni sitawora, “Tagu, Yawe God anakabepepi, basuna kana aviya parapa igeiwayidi; bi hosi da seriyot ere aviya badadi yegiiye ivitavenayowoyedi. ");
INSERT INTO aui_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yawe God na kagu wiiwiita maragasina na ayima anakabepepi; touna iviyawiigu. Touna na yagu God na anakabepepi, bi tamagunaki yana God na anakabikuwayeni. ");
INSERT INTO aui_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Kana waghawagha na Yawe God bi touna wiiyogha tomoyina. ");
INSERT INTO aui_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ijipt kana kiiwawo yana seriyot da iyo tomotomogha yegiiye ivitavenayowoyedi; bi kiiwawo yana babada miisedi Yegii Idurine iviniudonadi. ");
INSERT INTO aui_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Bi rarima wautapudi isowodi; na sinibuka siyowogha sinagho yegii dibune ware akima. ");
INSERT INTO aui_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Oo Yawe God, katiiyam na ivimaragata kirakii; bi yam maragatama na aviya damdi kuvitugaogaoworidi. ");
INSERT INTO aui_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tam wiisuwona kugekirakii na noko biidi kam aviya kugeiwayidi. Yam nuwapughu kuvikanibuveni na iviberodi ware keyama rei iyakarakarasina naboni. ");
INSERT INTO aui_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Yawiimma yegii kuveni na rarima ivitaghotaghoma mayeni, bi yabarata simiirikikita ware papa; bi rarima wautapudi yegii nuwanuwane na sikakokako. ");
INSERT INTO aui_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Bi aviya damdi siwona bo, ‘Kanaverakwavinidi, da kana kabitawanidi, yadi moura tupadi kanayouna bi kate awaki kakayokayowana na kanayouna, yama seri kanatayina kanikanibuwana da kanunugha.’ ");
INSERT INTO aui_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Bi gegha da, yawiimma yegii kuvenatatabi na isowomumudi; da yabarata maragasidi kamodiye sinibuka ware akima vitadi. ");
INSERT INTO aui_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yawe God, god tana meme tam naboni bo? Gegha! Tam wiisuwona kabikabikuwayim, yam maragata iragata na kanaghanagharem, bi berakayowiiwiiyaka kwaberabera! ");
INSERT INTO aui_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tam katiiyam kukoghasi ikanibu, na kubura kawana itatari da kam aviya ivitonanidi. ");
INSERT INTO aui_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Yam nuwayuyuna nuwakayowaninama, kuvisuwona na naboni da, yam wawaya kuvinaghovemii, toumii kama aviya gwabidima kuviyawiimiina. Tam yam maragatama kuvinaghovemii tanagho gawara kabikabikuwayine meme kwamakamakena. ");
INSERT INTO aui_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dam mududi awaki kuberana sisiyidi siwaiyana na naghara ikabidi. Pilistiya damdi naghara ghamana ivibonuvidi; ");
INSERT INTO aui_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idom kubura kana dogadogara sinaghara kirakii; bi Moab kubura kana babada ghamaghamadi sinaghara na siyakirokiroro; bi Kenen damdi tupadi yadi noghota ibeku da gesiyimaragatana. ");
INSERT INTO aui_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Naghara ghamanakina tupadi debadiye ibeku. Oo Yawe God, yam maragata ghamana sikita na simiiri waghata ware akima, patana da toumii yam wawaya kapepewa da kaveratupiiredi, nokodi wawaya wiibaguranama kugimona mayemiina. ");
INSERT INTO aui_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yawe God, tam kunakabirughuvedi da koya rapemve debane sinamake, meko gawarina kuvineyi da kunamakena, gawara kabikabikuwayina touna imamma kuberana. ");
INSERT INTO aui_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yawe God na inikiiwawo waghata.” ");
INSERT INTO aui_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Isrel damdi yegii sirughuwoneni tanawa kanakananagha sipepewa. Bi raghanine Ijipt kana kiiwawo yana hosi da seriyot bi kate seriyot kadi babada yegii kamone siyowogha, na Yawe God rarima ikabiwiiveramayi da tupadi isowomumudi. ");
INSERT INTO aui_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Eron toghanaru Miriyam na peroveta wasikena tana. Bi inawa gisina ikabi bi wasiwasike mududi yawata sikanibu da inavidi gisigisidi siyarourouwa bi siyarikuriku. ");
INSERT INTO aui_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyam mma naboni itawora, “Yawe God ayima tanakabepepi, kiiravine kana aviya parapa igeiwayidi, basuna hosi da seriyot ere aviya badadi yegiiye ivitavenayowoyedi.” ");
INSERT INTO aui_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Wasina bi Mosis, Isrel damdi ivinaghovedi da Yegii Idurina sikuyoveni bi sinagho sirughu Sur mayabine. Bi gabudara aroba mayabe sipepewa bi getana rarima siyabananina. ");
INSERT INTO aui_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Bi raghanina sipiika Mara kubure na rarima sibanani, bi damina na ibero kirakii na gerubana siyaniuni (Noko biidi gawarina sikwatuveni Mara). ");
INSERT INTO aui_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Na wawaya Mosis biidi siyagwinigwini, siyawonawona bo, “Katana awaki tananiuna?” ");
INSERT INTO aui_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Na Mosis wiiwiita kiiravine irupari Yawe God biidi na kii raghana gisina iviyeveveni. Raghanina Mosis kiina raghana ivitavenayowoyeni rarima kamone, na rarimina iwaratete ninina kiiravine. Noko gawarine Yawe God wawaya yadi makamake siradi iveredi, bi iruyaghadi da iyakita memeda siyakabisisireni bo gegha. ");
INSERT INTO aui_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Na iwona bo, “Memeda yagu sisiya konawaiyana wiimasi bi yagu noghota miisedi konakivina da yagu gwara konakabisisiredi, na gubagidi mayimayiyidi gegha anaveremina ware Ijipt damdi averedina. Tagu na Yawe God, iiyabo yaberami da koyawa.” ");
INSERT INTO aui_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Muriye na sipiika Elim kubure. Noko gawarine na wusira yadi 12 bi kate notuveya kiidi yadi 70. Bi nama rarima ririne sivitaki. ");
INSERT INTO aui_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Wasina bi Isrel damdi tupadi Elim kubura sikuyoveni bi sikanibu sinagho mayaba kana waghawagha Sin, nama Elim da Sainai Koyana bi basudiye. Noko gawarine na gabudara 15 nawaravi wiibatane bi siverakanibu, nokona nawaravi tana ikovi Ijipt kubura sikuyoveni bi murine. ");
INSERT INTO aui_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Isrel damdi noko gawarine Mosis da Eron biiyadi bada sigwinimagha. ");
INSERT INTO aui_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Siwonedi bo, “Kakayoveni da Yawe God naghove iyiunuyimii raghanine Ijiptne kaya makamakena. Name kamakeyowogha da iyuwa kakam bi kate yama kayowana kamdi mududi. Bi gegha da kokabi kanibuvemii mabo mayabe na vitonanama kanarabobo.” ");
INSERT INTO aui_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Wasina bi Yawe God, Mosis iwoneni bo, “Kuwaiyana! Tagu abamama kam anipora kiiravimiye inayowogha ware amra. Gabudara patepatena wawaya sinakanibu da noko gabudarina kawagha rubane kam sinameka. Mmko kedane na anarubudi bi anakita, memeda gamogu sinakivini bo gegha. ");
INSERT INTO aui_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Bi gabudara 6 na kam sinameka kirakii gabudara 2 rubadiye bi sinakabikuya.” ");
INSERT INTO aui_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yawe God, Mosis iwonena mayeni bo, ");
INSERT INTO aui_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Isrel damdi yadi gwini awaiyaneni. Na kuwonedi, ‘Ravidi pompomve tami iyuwa konakam, bi didibare na kam tupadi kokayokayowana na konakam. Wasina bi konakovi da Tagu na Yawe, yami God.’” ");
INSERT INTO aui_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Noko ravidine manu gisigisi kadi waghawagha kweal peyaridi sirowogha sirughu da meme wawaya siyamakamake na name sitowa, bi didibare na youra tanawa tupana ivibedibedi. ");
INSERT INTO aui_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Raghanina yourina ikanakana, na sawara tana ware yapukare bi nenanenadi sirumaghatara dobodobo debane. ");
INSERT INTO aui_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Raghanina Isrel damdi sikitana, gesiyakovi da awaki na sivitarakiiyana vivirana bo, “Mmko awaki?” Na Mosis iwonedi bo, “Kamna makatanina Yawe God iveremi da konakani. ");
INSERT INTO aui_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mmkodi na Yawe God yana wonawiiyoyowana, ‘Wawaya tanagha kamdi rubane inameka da inakam. Bi oma tanagha irigina wawaya tanagha rubane inayouna da yana kiregoru kamone kiiravidiye.’” ");
INSERT INTO aui_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Na Isrel damdi God metagha iwonedina naboni sibera, da wawaya mududi simeka kirakii, bi mududi na viyagha. ");
INSERT INTO aui_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Bi raghanina sikabirubatadi, na wawaya tupana wasina rubadiye. Iiyawogha simeka kirakii na gesiyipuwatana, bi iiyawogha viyagha simeka na rubae. Rakaraka nunudigha na awaki sikayovenina sikabi. ");
INSERT INTO aui_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Wasina bi Mosis iwonedi bo, “Getana iiyabo kamdi inakabitawana maram kiiravine.” ");
INSERT INTO aui_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Bi gegha da, Isrel damdi gesiyawaiyaneni. Na wawaya viya kam muduna sivipuwata patana da raghani ibori, bi gegha, kamdi simotamota da siyabowabowa, na Mosis nuwanuwana ipughu wawaya biiyadi. ");
INSERT INTO aui_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Didibara nunudigha wawaya kamdi rubae siyamekameka da kam kiiravine, bi raghanine gabudara iyamuyamuya na kamdi mekodi gesiyamekana sitamoguda da simomogha. ");
INSERT INTO aui_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Bi gabudara 6 kamone na wawaya kam simeka kirakii gabudara 2 rubane bi wawaya tatadigegha na oma 2 rubadiye. Wawaya kadi babada ghamaghamadi tupadi sipiika Mosis biidi da mmko berana kiiravine siwoneni. ");
INSERT INTO aui_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Na Mosis iwonedi bo, “Mmkona Yawe God yana sisiya bagibagina, ‘Maram na gabudara meko Yawe God tana kabikuwayeni, bi gabudarina na kabikabikuwayina da taniyawiitaveyana pom. Awakigha konagibu, na kata kogibu bi awakigha konitawogha, na kata kovitawogha. Bi mekodi konakabitoura na kokabitawana da maram didibare.’” ");
INSERT INTO aui_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Na nokodi kam kabiwiiririyidi wawaya sikabitawana patana da raghani ibori, metagha Mosis iwonedina, da gesiyabowa bo siyamotamotana. ");
INSERT INTO aui_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Wasina bi Mosis iwona bo, “Kata konakani, basuna katana wiiyawiitaveyana gabudarina Yawe God biidi na kam kate gegha taki kubune konabananana. ");
INSERT INTO aui_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tami gabudara 6 kamodiye kam konituwiitaghoma, bi gabudara 7 na wiiyawiitaveyana gabudarine na kate gegha kam konabanana.” ");
INSERT INTO aui_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Bi gabudara 7 na wawaya mududi sikanibu kam siyameka, bi getana, sirubodakawa. ");
INSERT INTO aui_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Na Yawe God, Mosis iwoneni bo, “Wawaya kuwonedi, Raghani viya yagu wiiyeveveyana da yagu gwara kivinidi konasinighiiyana?” ");
INSERT INTO aui_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Konoghosi da wiiyawiitaveyana gabudarina na Yawe God yana puyo tami biiyadi. Noko kiiravine gabudara 6 kamone na gabudara 2 kanayaku ikabi kiiravine na kam iveremi, na gabudara 2 rubadiye konakam. Bi wiiyawiitaveyana gabudarine, na tupami bareye konamake. Bi gegha tana iiyabo gabudara 7 kamone na kam inamekana. ");
INSERT INTO aui_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Wasina bi gabudara 7 kamone wawaya getana kam siyamekana. ");
INSERT INTO aui_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isrel damdi mmko kamna sikwatuveni da mana. ");
INSERT INTO aui_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Na Isrel damdi bodu 40 kamone mana sikani, patana da Kenen tanavine siverakanibu, kubura meme siyamakewaghatana. ");
INSERT INTO aui_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Wasina bi Isrel damdi mayaba kana waghawagha Sin sikuyoveni. Bi Yawe God gamone, na gawara siyamakamake wiipepewa. Da Repidim kubure sivitaki, bi name na rarima gegha da wawaya siyaniuna. ");
INSERT INTO aui_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Na Mosis teya sivigamowana siwona bo, “Rarima kuvereda tananina!” Bi Mosis iwona bo, “Awaki biidi tagu yawata tiigamowana? Bi awaki kiiravine Yawe God koruburubuni?” ");
INSERT INTO aui_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Bi gegha da wawaya kanighodi sirugaowora kirakii, na Mosis biidi sigwini siwona bo, “Awaki kiiravine Ijipt kuburinama kukabi kanibuvemii? Bo, toumii, natunatumii da yama ribiribi kanigho rugaoworama kunirabobomii?” ");
INSERT INTO aui_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Wasina bi Mosis, irupari wiimaragata Yawe God biidi, “Awaki anabera mmkodi damdi biiyadi? Bi sikabunagha da akimama sinarouvigu.” ");
INSERT INTO aui_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Na Yawe God, Mosis iwoneni bo, “Yam dighona kabi, mekoma Nail rarimina kurouvina bi wawaya kimuriyedi naghodiye kupepewa. Bi Isrel kana dogadogara mududi kuyouna da sinikapuvem, bi konanagho. ");
INSERT INTO aui_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Na Sainai kubure naghomiye akima debane anamiimiiri. Na akimina kunarouvi, da rarima inakanibu wawaya kiiravidiye da sinaniuna.” Mosis mma naboni Isrel kana dogadogara matadiye bera ibera. ");
INSERT INTO aui_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Na gawarina ikwatuvedi Massa da Meriba, basuna name Isrel damdi Mosis teya sivigamowana da Yawe God sirubuni, siyawonawona bo, “Yawe God mma touda yawata bo gegha?” ");
INSERT INTO aui_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Wasina bi Amelek damdi sigogona sipiika Repidimne Isrel damdi biiyadi. ");
INSERT INTO aui_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Na Mosis, Josuwa iwoneni bo, “Tomotomogha kiiravidae kuvinegha. Bi konagho da Amelek damdi teya konirouwa. Bi maram, na Yawe God yana dighona na imaguve bi koya debane anamiiri.” ");
INSERT INTO aui_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Mosis metagha iwona, na naboni Josuwa ibera, bi Amelek yadi wiiyogha damdi teya sivirouwa. Bi raghanina tanagha, bada Mosis, Eron da Hur sinagho sigae koya debane. ");
INSERT INTO aui_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Raghanina Mosis imana da dighona irukabekabepa sigae kiidamove simakewiiguri, na Isrel wiiyogha damdi turadi siyageegeeiwayidi, bi raghanine imana iyatutoura yowoghana, na Amelek wiiyogha damdi turadi siyageegeeiwayidi. ");
INSERT INTO aui_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Bi raghanina Mosis imana siyamameyana, da gerubana iyarukabepa siyagae, na Eron da Hur akima sikabi da Mosis rogune sitore da debane iyamakekira bi ririne sivimiiri nawaneni da imana sirukabekabepa, na imana gesiyidagudagu patana da gabudara imakepowa. ");
INSERT INTO aui_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Bi mmko kedane na Josuwa yana wawaya teya yadi serima Amelek wiiyogha damdi sigeiwayidi. ");
INSERT INTO aui_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mosis rawananaki Jetro, na Midiyan kubura kana prist bi sisiya iwaiyana da Yawe God awaki tupana ibera Mosis da Isrel damdi kiiravidiye, bi kate metagha ivinaghovedi raghanine Ijipt sikanibutavenina. ");
INSERT INTO aui_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Bi Jetro, na Mosis wavinena da natunatuna tomotomoyidi yadi bata yawata sipiika mayabe Yawe God yana koyaye, meme Mosis iyamakamakena. ");
INSERT INTO aui_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Muriye da iyaverakanibu na Mosis yana sisiya iwonataveni iwona bo, “Tagu, Jetro, rawamnaki bi wavinem da natunatum tomotomoyidi yadi bata yawata kapiipiika kana kitam.” ");
INSERT INTO aui_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Bi raghanina siverakanibu, na Mosis ikanibu da rawananaki iyikiikiiveni, na naghone ipepeta iyowogha, bi imaghani. Wasina sivikiikiiwa kabivivirana, bi sirughu Mosis yana kiregoru kamone. ");
INSERT INTO aui_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosis, rawananaki iwoneni da awaki beradi tupana Yawe God ibera Ijipt damdi da yadi kiiwawo biidi, da Isrel damdi iyiyawiidi na kiiravine. Bi kate iwonena mayeni da kedae wawaya nuwapoyaye sikabikwarakwara na kiiravine bi kate metagha Yawe God iviwiitedina. ");
INSERT INTO aui_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Wasina bi Jetro bera miisedi sisiyidi tupadi iwaiyana bi kate Yawe God awaki ibera dam Isrel biiyadi raghanina Ijipt damdi yadi maragatama iviyawiidi kiiravine, na ivinuwamiise. ");
INSERT INTO aui_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Na Jetro iwona bo, “Tagu, Yawe God akabekabepepi basuna Ijipt damdi gwabidima da Ijipt kana kiiwawo gwabinama iviyawiimina. Bi wiisuwona Ijipt damdi yadi maragatama na Isrel iviyawiimi. ");
INSERT INTO aui_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Bi kata akovi da Yawe God na ivimaragata kirakii genaboni god tupadi mekodigha wawaya sapeepetedina, basuna Ijipt damdi siyatoretoregeegeeyedi da yana wawaya siyikayotaketowanedi raghanine, na iviyawiidi.” ");
INSERT INTO aui_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Raghani ibori, na Mosis wiitupawamiwamira abamakamakene imakeyowogha da wawaya yadi wiikawakereyana iyawaiyana, toudi kana didibara naghone simiiri patana da iravidi. ");
INSERT INTO aui_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Raghanina rawananaki ikita da awaki tupana iyaberabera wawaya biiyadi na iwona bo, “Mmko awaki kwaberabera wawaya kiiravidiye? Awaki biidi mmko bagibagina tamduma kwaberabera, na wawaya kana didibara siyamiimiiri patana da iravidi?” ");
INSERT INTO aui_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Na Mosis iwonabodeyana bo, “Mmko aberaberana basuna wawaya sapiika tagu biidi bi akowa sakabi da awaki Yawe God yawiiwiinedi da sinabera. ");
INSERT INTO aui_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Raghanina wawaya yadi 2 sikawakereyana, na sapiika tagu biidi bi anuwagiura da mekona wasina, bi Yawe God yana wiiyeveveyana da sira awonaveredi.” ");
INSERT INTO aui_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Wasina bi Mosis rawananaki Jetro iwona bo, “Mmkona gebera miisena kuyaberaberana. ");
INSERT INTO aui_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Mmko bagibagina na ivita kirakii da tamduma kuyabera. Tam da wawaya tupadi konamameyemi. ");
INSERT INTO aui_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Na kuwaiyanegu bi anawonawiiyoyowanem, bi Yawe God na yawata gwabimve. Bi wawaya wasadi na imiise kirakii da tam kiiravidiye na Yawe God biidi kunisisiya bi yadi wiikawakereyana kunimaghamaghatareni. ");
INSERT INTO aui_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Yawe God yana wiiyeveveyana da sira kuwonaveredi, bi makamake yawana kunawonawiiyevevedi da awaki kate sinabera. ");
INSERT INTO aui_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Bi kate wawaya tupadi kamodima tomotomogha nuwanuwagiuridi kuvinegha bi kutoredi da wawaya sininaghovedi: mududi wawaya yadi 1,000 sinibadedi, mududi yadi 100, mududi yadi 50 bi mududi yadi 10 sinibadedi. Tomotomogha mekodigha God sakabikabikarawayenina kuvineyidi, iiyawogha kwiitumaghanedina bi gegha wiinuwatayina manedi kabiwiikowoye wawaya gwabidima sinayouna wapawapana. ");
INSERT INTO aui_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Bi nonowa wawaya yadi wiikawakereyana sinanuwagiureyana. Wiikawakereyana piropirodi na sinapiikedi tam biidi, bi wiikawakereyana gisigisidi na toudi wosina sinanuwagiureyana. Bi siniwiitem da vitana konakawari, na berana inatekateka tam biidi. ");
INSERT INTO aui_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Mmko kunaberana Yawe God ininaghovem, da gegha kunamameyemna, bi mmkodi wawaya tupadi sinanagho yadi bareye da nuwaruririye sinamakae.” ");
INSERT INTO aui_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Na Mosis rawananaki Jetro yana wonawiiyoyowana iwaiyaneni da berana ibera. ");
INSERT INTO aui_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Dam Isrel kamonama tomotomogha nuwanuwagiuridi mududi ivinegha, bi itoredi da wawaya siyinaghovedi: mududi wawaya yadi 1,000 siyibadedi, mududi 100, mududi 50, bi mududi na wawaya yadi 10 siyibadedi. ");
INSERT INTO aui_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Mmkodi babadidi na nonowa wawaya yadi wiikawakereyana siyakabikabi wiirotomana. Bi wiikawakereyana piropirodi na siyapiipiikedi Mosis biidi bi toudi wosina na wiikawakereyana gisigisidi siyanuwanuwagiureyana. ");
INSERT INTO aui_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Wasina bi mmko murine, na Mosis rawananaki ivikukuveni bi Jetro iveramagha yana kubure. ");
INSERT INTO aui_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Wasina bi Isrel damdi Repidim kubura sikuyoveni bi sinagho mayaba kana waghawagha Sainaima. Da name Sainai Koyana kayene sivitaki, ");
INSERT INTO aui_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","bi Mosis igae koyae da God yawata siyibanana. Yawe God koyama ikwatuveni da Jeikap nosinosina, Isrel damdi iyawonedi bo, ");
INSERT INTO aui_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Tami wosina kokita da Ijipt damdi biiyadi awaki abera bi kwakovi da metagha akawarimi ware kakaka natunatuna mabenama yakawakawaridi na naboni, da apiikemi mabo tagu biidi. ");
INSERT INTO aui_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Meboda konakabisisiregu bi yagu wiiwaghasina maragasina konakabitawani, na wasina tami na tagu wosina yagu wawaya. Kubura tupana na rapeguve bi gegha da dam tupadi kamodima na anavineyimi da yagu wiivinevinegha wawayimi. ");
INSERT INTO aui_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Bi konabigegu da naboni prist bagibagina konabera patapata, bi kami dam na atoretaveni kiiraviguve da tagu kawagha yagu wawaya. Wasina mmkodi sisiyidi Isrel damdi kuwonedi.” ");
INSERT INTO aui_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Na Mosis koyama iyowogha bi Isrel damdi kadi babada ikwatu wiitaghomidi, bi bera tupana iwonedi metagha Yawe God iwonenina. ");
INSERT INTO aui_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wasina bi wawaya tupana siwonabodeyana bo, “Bera tupana kanabera metagha Yawe God iwonana.” Na Mosis yadi wonabodeyana Yawe God biidi iwonavereni. ");
INSERT INTO aui_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Na Yawe God, Mosis iwoneni bo, “Tagu karekarewa kamodigha anapiika kurim, bi wawaya sinawaiyanegu tam teya tanisisiya na nonowa sinigeruvem.” Wasina bi Mosis, Yawe God ivimaghamaghatareni da metagha wawaya siwonabodeyana. ");
INSERT INTO aui_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Na Yawe God iwona bo, “Kuyowogha wawaya biiyadi bi kuwonedi da kabepepigu kiiravine kata da maram sinakabununagha mayedi. Kadi gara sinakogha ");
INSERT INTO aui_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","bi sinakabunagha gabudara wiiarobina kiiravine, basuna noko gabudarine wawaya tupana matadiye bi anayowogha Sainai Koyane. ");
INSERT INTO aui_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Koyana barata kutore da wawaya gesinighanunina. Bi kuwonedi da sinakoyagha yaporidi! Da gegha koyane sinage bo sinanagho ririnena. Iiyabo inanagho koyane bi kayenama initutowoyi na inarabobo. ");
INSERT INTO aui_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Memeda wawaya bo ribiribi barata inighanuni, na gekona kabitowoyina, bi iyoma bo akimama kona kasunuyi. Bi gegha, raghanina gisumani gamona konawaiyaneni, na wasina bi wawaya sinanagho koyana kayene.” ");
INSERT INTO aui_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Wasina bi Mosis koyama iyowogha bi wawaya iwonedi da kadi gara sinakogha da siyakabununagha mayedi God kabepepina kiiravine. ");
INSERT INTO aui_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Na iwonedi bo, “Gabudara wiiarobina kiiravine kokabununagha bi kata da inanagho noko gabudarine na gekonimumuranana.” ");
INSERT INTO aui_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Gabudara wiiarobine, didibare na namanamara da warikeyakeya sidagu, bi koyae karekarewa sirumaghatara, da gisumani gamona ghamana siwaiyaneni, na wawaya nama makamakedi naghara ikabidi na sikiroro. ");
INSERT INTO aui_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mosis ivinaghovedi taki sikanibutaveni da God teya siyibanana, na koyana kayene simiiri. ");
INSERT INTO aui_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sainai Koyana tupana buu isowomumu, basuna Yawe God debanagha iyowogha keyama naboni. Bi buuna igae na ware brik sagabugabuna na naboni, da koyana tupana ivinukenuke, ");
INSERT INTO aui_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","bi gisumani gamona iragata kamokamogha. Wasina bi Mosis ivisisiya, na God gamo ghamanama iwonabodeyana warikeyakeya naboni. ");
INSERT INTO aui_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yawe God iyowogha Sainai Koyana debane bi Mosis ikwatuveni bo, “Mabo kugae,” na Mosis igae koya debane da Yawe God teya siyibanana. ");
INSERT INTO aui_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Wasina bi God mmkodi sisiyama ivisisiya bo, ");
INSERT INTO aui_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Taguna Yawe yami God, bi Ijipt kuburama akabikanibuvemi, meme tami koyibagubaguranana. ");
INSERT INTO aui_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tami god mududi gegha konakabepepidina, tagu kawagha konakabepepigu. ");
INSERT INTO aui_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Gegha tarabiibiisaka kiiravimiye konabera mekodi kadikita naboni sawara abama kamone bo kubura debane bo rogune yegii kamonena. ");
INSERT INTO aui_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Gekona pepetedi bo konakabepepidina, basuna Taguna Yawe yami God bi geaniwaghasinemi da wasagu konakabepepidina. Tagu wawaya sinisinighiighiiyegu na aro anaveredi bi mmko arona inanagho wiiwoneni natunatudi bi tubutubudi da nosinosidi biiyadi. ");
INSERT INTO aui_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Bi memeda koni nuwayuyunegu da yagu gwara konakabisisiredi na aninuwayuyunena wiikaruvemi bi kate nosinosimi yawata kimta 1,000 murine kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Gegha kagu waghawagha konabera da iniwaghawagha wapawapa, kiiravine Tagu na, Yawe yami God, bi iiyabo kagu waghawagha inabera da iniwaghawagha wapawapa na aro anavereni. ");
INSERT INTO aui_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Konoghosi da wiiyawiitaveyana gabudarina kokabikarawayeni bi konakabitawani da kabikabikuwayina. ");
INSERT INTO aui_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Taparoro nununagha na gabudara yadi 6 kamodiye yami bagibagi konabera. ");
INSERT INTO aui_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Bi gabudara 6 sinakovi murine na Yawe yami God yana raghani, wiiyawiitaveyana gabudarina. Noko gabudarine na getana iiyabo inabagibagina - gegha tami, natunatumi, yami wiibagubagurana, yami ribiribi, bo kubura wiibata damdi iiyawogha yami kubure samakamakena. ");
INSERT INTO aui_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Basuna gabudara 6 kamodiye na Tagu, Yawe God, abama, kubura, yegii da sawara tupadi kamodiye abera, bi gabudara 7 kamone na aviyawiitaveyana. Noko biidi Tagu, Yawe God, wiiyawiitaveyana gabudarina avimiiseyeni bi atoreireni ivibogae da Tagu kiiraviguve. ");
INSERT INTO aui_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tamamnaki da sinamnaki kuna kabikarawayedi, na yam make inaguri mmko tanavina debane meko Tagu, Yawe yami God avereveremina. ");
INSERT INTO aui_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Gegha konakasunughana. ");
INSERT INTO aui_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Gegha wawaya tana wavinena teya konimumurana. ");
INSERT INTO aui_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Gegha konayapina. ");
INSERT INTO aui_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Gegha wawaya tana wiiyabama koniwawuna. ");
INSERT INTO aui_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Gegha kwiinam yana bare kuna kita kirorovenina. Gegha wavinena kuna kirorovenina, yana wiibagubagurana, yana kau, yana donki, bo sawara wapawapa kwiinam rapenena.” ");
INSERT INTO aui_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wasina bi Yawe God, Mosis iwonena mayeni bo, “Memeda wawaya tana wawaya turana inarouvi bi inarabobo, na noko wawayina sinakasunuyi.” ");
INSERT INTO aui_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Bi meboda inatubugha wapawapa bi geiyanoghosi da kasunuyina, na Tagu gawara kiiravimiye anavineyi na nabo kasunugha wawayina inavera inanagho da inayawa. ");
INSERT INTO aui_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Bi memeda wawaya tana nuwanuwana yapughu na yanuwagiura yakovi bi wawaya yakasunuyi, na bagune inavera inanagho yagu suwara gabugabuna gawarine yawa kiiravine, bi gegha da sinakabi kanibuveni da sinakasunuyi. ");
INSERT INTO aui_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Memeda wawaya tana tamananaki bo sinananaki inarouvi, na noko wawayina sinakasunuyi. ");
INSERT INTO aui_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Memeda wawaya tana tupeyane kwiinana inakabiyapi bi inigimoneni bo patana inakabikabitawani gwabine, na noko wawayina sinakasunuyi. ");
INSERT INTO aui_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Bi memeda wawaya tana tamananaki bo sinananaki inawona imimagi na noko wawayina sinakasunuyi.” ");
INSERT INTO aui_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Wasina bi Yawe God, Mosis iwonena mayeni bo, “Memeda tomogha iniyaba, bi wasike wabuwabuna touna tomogha yawata gesiyakenatowogha da getana iiyabo siyakabibabareni bi yawata sinimumurana, na wasikena kiiravine na nayi miisanina inatore bi inarawayi. ");
INSERT INTO aui_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Bi memeda wasike tamananaki inasinighii bi geiniwaghasina da tomoyina, wasikena inarawayi na tomoyina, wasike tamananaki manema inimiisani wasike wabuwabuna rubane nayi miisanina kiiravine. ");
INSERT INTO aui_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Memeda wasike imapu inaberabera na sinakasunuyi. ");
INSERT INTO aui_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Memeda wawaya, ribiribi teya sivimumurana na noko tomoyina sinakasunuyi. ");
INSERT INTO aui_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Memeda iiyabo suwara inagabuni god mududi biiyadi bi getagu kawagha, Yawe God biidi, na noko wawayina sinakasunughataveni. ");
INSERT INTO aui_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Kubura wiibata damdi gegha konitupaketowanedina, kiiravine tami wosina na raghani tana kovi dam wiibata Ijipt kubure. ");
INSERT INTO aui_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Gegha kwabura bo uwuwavi konitupaketowanedi. ");
INSERT INTO aui_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Memeda konitupaketowanedi bi raghanina wiiwiita kiiravine sinibaba Tagu biidi, na Tagu Yawe God rubana anawaiyanedi da aniwiitedi ");
INSERT INTO aui_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","bi nuwanuwagu inapughu kirakii na aviya kamone anunuyimi. Natuwavinemi sinakwabura, bi natunatumi siniuwuwavi. ");
INSERT INTO aui_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Memeda mane kwavereyana yagu wawaya moyamoyakidi biiyadi, na gegha kunabera da mane verevereyana damdi naboni da awaki kuvereyana na kunawona da debane mane pinimina inatore bi inaverem. ");
INSERT INTO aui_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Memeda wawaya tana mane kunavereni bi inisuwona da muriye inimiisana mayem, na kana kwama kunakabitawani naboni kabivereyana matakirina kiiravine, na kunavere mayeni muriye da gabudara inamakepowa, ");
INSERT INTO aui_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","basuna nokona wasina yanasowo keyakeya da sinina inakabiwiimuyamuya. Na awakima bada kamone inakena? Memeda gekuniveramayi bi kwiinam wiiwiita kiiravine inibaba tagu biidi, na anawaiyaneni, basuna Tagu na wiinuwanuwaghana tomoyigu.” ");
INSERT INTO aui_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Wasina bi Yawe God, Mosis iwonena mayeni bo, “Gegha wawaya mududi kiiravidiye sisiya wiiyaba konakabirereghana. Gegha wiitupawamiwamira wawayina naghone koniyaba da wawaya kawakeekeena koniwiiteni. ");
INSERT INTO aui_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Wawaya korotodi berona sinabera na gegha konigubegubedina. Raghanina wiitupawamiwamira wawayina naghone kunisisiya, bi wawaya korotodi mududi siniyabana, gekonabera da toudi naboni. Gegha rotomana kedana naboni konakiyawiiriwana.” ");
INSERT INTO aui_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Wasina bi Mosis inagho da Yawe God yana gwara da wiiyeveveyana tupadi iverenina wawaya iwonedi, na tupadi gamo tanagha bi siwonabodeyana bo, “Yawe God awaki beradi tupana ivisisiyedi, na toumii kanabera.” ");
INSERT INTO aui_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Bi Mosis, Yawe God yana sisiya da gwara tupadi igiruma. Raghani ibori didibare igeghomiiri da koyana kayene suwara gabugabuna gawarina ibera. Bi kate akima ghamaghamadi yadi 12 ikabiwiimiiridi naboni matakira, da Isrel kana dam ikabipatadi. ");
INSERT INTO aui_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Wasina bi tomotomogha yaragidi dam Isrel kamonama iviporadi da ribiribi sivikasunughana bi sigibu naboni puyo Yawe God biidi bi kate kau woudi makidi sisuwara naboni wiiturana puyona. ");
INSERT INTO aui_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosis mmkodi ribiribi sisuwara na ganiganidi muduna ikabi da kaboma kamodiye iwagha bi ganiganidi muduna na suwara gabugabuna gawarina iyeburi. ");
INSERT INTO aui_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Wasina bi Wiiwaghasina Maragasina Bukana ikabi bi ikabiyavi na wawaya tupadi siwaiyaneni. Raghanina siwaiyaneni na siwona bo, “Yawe God kanakabisisireni bi awaki tupana ivisisiyeni na kanabera.” ");
INSERT INTO aui_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Wasina bi Mosis ganigani kabomidi iyouna bi wawaya iyeburidi bi iwonedi bo, “Kokita, raghanina Yawe God mmkodi gwara iveremina, wiiwaghasina maragasina ibera tami biiyadi bi mmko ganiganina na yimatakira da Yawe God yana wiiwaghasina maragasina Isrel yawata yadagudaguni.” ");
INSERT INTO aui_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Bi Yawe God ivisisiya Mosis biidi iwona bo, “Kugae koya debane da yawata tanamake. Bi yagu gwara da sisiya akima benabenadi yadi bata debadiye agiruma na anaverem, bi tam wawaya kuniyevevedi da sinakabisisiredi.” ");
INSERT INTO aui_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Wasina bi Mosis kana wiiwiita Josuwa teya sikabununagha da koya siyaghiini. Na dogadogara biiyadi ivisisiya iwona bo, “Mma kokoyayimii patana da kanaveramagha tami biiyadi. Bi Eron da Hur na tami yawata mma. Memeda iiyabo wiikawakereyana nuwapoyina gwabine na inapiika toudi biiyadi da sinakabiwiirotomani.” Wasina bi Mosis da Josuwa, Yawe God yana koya aghiinina sidaguni. ");
INSERT INTO aui_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Raghanina Mosis igae koya debane na uuwa dumadumana koya isowomumu. ");
INSERT INTO aui_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Bi Yawe God yana kiniwa yeghanina iyowogha Sainai Koyana debane. Bi uuwa koyana isowomumu da gabudara 6 sikovi bi raghani ibori na God, uuwa kamonama Mosis ikwatuveni da iyapiika. ");
INSERT INTO aui_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Bi Isrel damdi na koya kayene bi raghanina sikayogagawa, na Yawe God yana kiniwa sikita ware keyama ghamana gweyurina koya debane. ");
INSERT INTO aui_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Wasina bi Mosis koyana iyaghiini iyageegee da uuwa kamone irughu bi name gabudara 40 da nubabasu 40 imakae. ");
INSERT INTO aui_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Yawe God ivisisiya Mosis biidi iwona bo, “Wawaya Kiregoru Kabikabikuwayina sinabera kiiraviguve da Tagu nama kamodiye anamake. ");
INSERT INTO aui_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kiregoru Kabikabikuwayina da kana sawara tupadi nuwagiuridi na naboni mayimayiyina aniyevevemna kobera.” ");
INSERT INTO aui_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Wawaya kuwonedi da kii kana waghawagha akeisiyama dedewaga sinabera. Kanakabirubata na yana guri 110 sentimita, yana naba na 66 sentimita bi yana gae na 66 sentimita. ");
INSERT INTO aui_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kamona da kubuna gould wotama kopasi bi nawanawanagha gouldma kikiru konatorewiikenavivireni. ");
INSERT INTO aui_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kwaki yadi ruwamaruwa gouldma kobera bi dedewagina kayena yadi ruwamaruwa na tadigegha kovikaba, kwaki bata nawana tane bi bata bada nawane. ");
INSERT INTO aui_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Akeisiya kiinama paghodi kobera bi gouldma kopasi. ");
INSERT INTO aui_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Paghodi dedewaga nawanawadiye kwakidiye konitupatete bi toudima konakawari. ");
INSERT INTO aui_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Paghodi kwakiye kokuyowana; gegha konakabitavetavedina. ");
INSERT INTO aui_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Raghanina dedewagina inakovi na Wiiwaghasina Maragasidi girumidi akima benabenadiye anaverem, na kunuwana kamone. ");
INSERT INTO aui_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Wasina bi taratawana gouldma konabera tamumu koghatavenina gawarina, yana guri 110 sentimita, bi yana naba na 66 sentimita. ");
INSERT INTO aui_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Bi gould kokasigudaguda da Serubim bata koberadi ");
INSERT INTO aui_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","bi taratawana debane konikarapasidi na toudi da taratawana na tanagha, taratawanina pusiridiye na Serubim tadigegha kotoura. ");
INSERT INTO aui_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Bi mabedi na sinarorona sinakanibu da taratawana sinarogutawani. Sinimiiri karokaroneyana bi sinakayogenara taratawanine. ");
INSERT INTO aui_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Bi Wiiwaghasina Maragasina girumina akima benabenadiye dedewaga kamone kwuwana bi mmko taratawanina kabi da dedewaga debane kutore. ");
INSERT INTO aui_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Wasina bi taraboga Serubim bata basudiye da Wiiwaghasina Maragasina Dedewagina debane, na noko gawarina kamone tam yawata tani banana da yagu gwara anaverem Isrel damdi kiiravidiye.” ");
INSERT INTO aui_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Wasina bi Yawe God, Mosis iwonena mayeni bo, “Waresim Eron da natunatuna: Nadab, Abiu, Eliesa da Itama kwatuvedi yawata sinapiika. Dam Isrel kamodima na toudi avineyidi da sinabagibagiyegu naboni prist. ");
INSERT INTO aui_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Bi kounagha kabikabikuwayidi kobera waresim Eron kiiravine, da ragahanina inikote na kanakita ininuwakayowana bi wawaya sinakabikarawayeni. ");
INSERT INTO aui_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Wawaya akowa kirakiidi kuwonedi, iiyawogha nuwagiura averedi da sawara sinabera. Na toudi kawagha prist kadikunagha sinabera Eron kiiravine bi wawayina konakabireni da tagu inabagibagiyegu naboni prist kiikiiwawona.” ");
INSERT INTO aui_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Wasina bi Yawe God ivisisiya Mosis biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Kuwaiyana! Tagu, Jiuda kana dam kamonama, Hur tubuna, bi Uri natuna tomogha Besalel avineyi, ");
INSERT INTO aui_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","bi kanumiguma avibonuvi. Na noghota da nuwagiura miimiisedi avereni, bi akowa yawata da sawara bogaebogae beradi: ");
INSERT INTO aui_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Bi katugha wiinuwakayowanidi beradi bi kate gould, silva da bronsma sawara beradi; ");
INSERT INTO aui_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","akima sinabori bi sinataramumu sawara tupadi kadikounagha kiiravine da kii tarakatugha. Touna nuwagiura tupana inikapukapu bi mmkodi bagibagi akowama inabera. ");
INSERT INTO aui_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Bi kana wiiwiita, na Dan kana dam kamonama, Ahisamek natuna tomogha Oholiyab avineyi. Bi kate bagibagi damdi akakovidi nuwagiura averedi da awaki sawaridi awonem da kunabera na sinabera. ");
INSERT INTO aui_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Sawaridi na mma: Yagu Kiregoru Kabikabikuwayina, Wiiwaghasina Maragasina Dedewagina, da kate taratawanina, touna na tamumu koghataveyana gawarina, da kate yagu Kiregoru Kabikabikuwayina kana sawara: ");
INSERT INTO aui_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","kiinabonabo bi kate kana sawara; kibe miimiiri gouldma sibera bi kate kana sawara, da sikoko kana gabugabuna gawarina; ");
INSERT INTO aui_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","suwara gabugabuna gawarina da kana sawara, bi dabira ghamana koghakogha kiiravine da kate kana abamiimiiri, ");
INSERT INTO aui_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bi kounagha wiinuwakayowanidi katukatuyidi poopodi - nokodi na Eron kana gara prist kiikiiwawona kiiravine, da kate gara natunatuna sinakounagha bi sinabagibagiyegu naboni prist; ");
INSERT INTO aui_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","bi wawaya bo sawara toreiredi kana mayawaga; da kate sikoko ghabughabu gawara Kabikabikuwayina kiiravine. Bi wawaya nuwagiura kirakiidi mmkodi sawaridi sinabera metagha awonem na naboni.” ");
INSERT INTO aui_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Wasina bi wawaya sikita da Mosis koyama geiyayowogha yaininagha, na Eron sigwagwari bi siwoneni bo, “Geghomiiri da god kiiravidae kunabera da ininaghoveda bi inakoyayida. Noko tomoyina, Mosis iiyabo Ijipt kuburama ikabikanibuveda, na gekayakovi da awaki itubugha touna biidi.” ");
INSERT INTO aui_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Na Eron iwonedi bo, “Natuwavinemi, natunatumi tomotomogha da wasiwasike taina yodi gouldma beraberadi siyagha na kokabitavetaveyana, bi kokawara kopiika tagu biidi.” ");
INSERT INTO aui_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Na wawaya tupadi kadi taina yodi sikabitavetaveyana bi sikawara sipiika Eron biidi. ");
INSERT INTO aui_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Bi gould iyouna da ivirararayidi na sivirarima bi ibera da kau natuna makina igubani. Raghanina wawaya sikita na sirukwatu bo, “O Isrel, god na mmakatanina meko Ijiptma ikabi kanibuvedana!” ");
INSERT INTO aui_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Raghanina Eron ikita da wawaya sivinuwamiise, na kau natuna makina naghone suwara gabugabuna gawarina ibera bi iviyonayona iwona bo, “Maram na Yawe God biidi kepo tana tanabera.” ");
INSERT INTO aui_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Raghani ibori na didibara wote wawaya ribiribi sikawara sipiika bi puyo gabugabunidi da wiiturana puyodi sigibu. Wasina bi muriye na simake yowogha sikam da siniuna, bi siniuna neghanegha na madawara beradi siyaberabera. ");
INSERT INTO aui_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Wasina bi Yawe God, Mosis biidi iwona bo, “Kuyowogha yaininagha, basuna yam wawaya, iiyawogha kukabidi da Ijipt kuburinama kokanibutaveyana, na bera berokirakiina sibera. ");
INSERT INTO aui_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Toudi siviyaininagha da keda metagha aviyevevedi da siyakivini na sikuyoveni, bi kau natuna makina gouldma sibera na sipepeteni da sisuwari. Bi siwona da nokona yadi god meko Ijipt kuburama ivikanibuvedina.” ");
INSERT INTO aui_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Bi Yawe God, Mosis iwonena mayeni bo, “Mmkodi wawaya akitadi na akovi da nuwanuwadi sikotakii. ");
INSERT INTO aui_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Katana kuyovegu bi nuwanuwagu ipugha kirakii toudi biiyadi na anakasiwiiberodi. Wasina bi tam da nosinosim anabera da konidam kiitowana.” ");
INSERT INTO aui_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Bi gegha da Mosis, God nuwanuwana ikani iwona bo, “O Yawe God, yam maragata ghamanama yam wawaya Ijiptama kukabi kanibuvedi, bi noko kiiravine na gegha nuwanuwam inapughu da kuniberodina! ");
INSERT INTO aui_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Memeda kuniberodi, na Ijipt damdi sinawona da yam noghota berona bi Isrel damdi kupiikedi koyae, da kubura debanama kunibero tuwanonoyidi. Na genuwanuwam inapughuna; yam noghota kuwamiri da gekuna kasiwiiberodina. ");
INSERT INTO aui_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Yam wiitamariyana Abraham, Aisik da Jeikap kunoghosidi, kiiravine wiisuwona maragasina kam waghawaghae kuveredi raghanina kuwona bo, ‘Anabera da nosinosim yadi koroto ware kewokewo abame naboni bi kate avisuwona da kubura tupana ayaveredina sinirapenena waghasi.’” ");
INSERT INTO aui_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Na Yawe God yana noghota iwamiri da awaki iyanuwanuwagiureni Isrel damdi biiyadi, na ibera da geiyunuyidina. ");
INSERT INTO aui_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Wasina bi Mosis koyama iveremagha iyowogha bi imane na akima benabenadi bata. Akimidiye na God yana gwara karodiye da kubudiye girugirumidi. ");
INSERT INTO aui_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mmkodi akima na God tounamani itarapaapadi, bi sisiyidi na touna wosina igiruma. ");
INSERT INTO aui_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Raghanina Mosis ipiika taki ririne da kau natuna makina bi kate wawaya siyirikuwana ikitadi na nuwanuwana ipughu kirakii, na nokodi akima benabenadi koya kayene dobodobove ivitavena yowoyowoghana da igawoworidi. ");
INSERT INTO aui_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Bi kau natuna makina meko wawaya siberana, ikabi da keyame igabuni. Wasina bi ikasigudaguda da iviyapukare bi rarime ivitavenayowoyeni bi Isrel damdi itupedi da siniuni. ");
INSERT INTO aui_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Wasina bi Mosis, Eron ivitarakiiyaneni iwona bo, “Mmkodi wawaya awaki tam biidi sibera bi kuvinaghovedi mmko tamumuna ghamana sibera?” ");
INSERT INTO aui_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Na Eron iwonabodeyana bo, “O bada, genuwanuwam inapughu bi mmkodi wawaya na kwakovidi da yadi wiina metagha bi berona siyabera. ");
INSERT INTO aui_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Na siwonegu bo, ‘Geghomiiri da kiiravidae god kunabera da ininaghoveda bi inakoyayida. Bi noko tomoyina, Mosis iiyabo Ijipt kuburama ikabikanibuveda na gekayakovi da awaki itubugha touna biidi.’ ");
INSERT INTO aui_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Na awonedi bo, ‘Iiyawogha taina yodi gouldma beraberadi gwabimiye na kokabitavetaveyana.’ Wasina bi sikawara sipiika siveregu, na keyame avitavenageegeeyana na mmko kau natuna makina nuwane iguba mayeni da itubugha.” ");
INSERT INTO aui_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosis ikita da Eron gerubana wawaya iyakabiwiidouvidi, bi sibera da kadiaviya matadiye toudi neghanegha waghata. ");
INSERT INTO aui_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Na taki matamketane imiiri bi irakapara bo, “Tam iiyabo Yawe God yana nawae, na piika tagu biidi!” Na Livai kana dam kamonama tomotomogha tupadi sivikasitaghomana bi sigwagwarawiikenavivireni. ");
INSERT INTO aui_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Bi iwonedi bo, “Yawe God, Isrel dammi yadi God, mma naboni iwona, ‘Tupami yami seri koyouna bi konagho konarughu da taki tupana konavera rughuwoneni nawana da nawana bi warewaresimi, turaturami da maketurami kovikasunughana.’” ");
INSERT INTO aui_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Na dam Livai tomotomogha Mosis yana sisiya sikabisisireni bi noko gabudarine na tomotomogha yadi 3,000 sivikasunughana. ");
INSERT INTO aui_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Wasina bi Mosis iwonedi bo, “Tami, Yawe God kokabisisireni bi bera rotomanina kobera da warewaresimi, turaturami da maketurami kovikasunughanedi, na kata Yawe God ivimiiseyemi bi yatoretoreiremi naboni yana prist da konabagibagiyeni.” ");
INSERT INTO aui_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Raghani ibori na Mosis wawaya iwonedi bo, “Tami tamumu bero kirakiina kobera. Na katana anaveramagha anagae koyae; da memeda tamumu noghotataveyanina Yawe God gwabinama anakabi tami kiiravimiye.” ");
INSERT INTO aui_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Wasina bi Mosis iveramagha igae Yawe God biidi bi iwona bo, “Mmkodi wawaya na bera berokirakiina sibera. Da toudimani kiiravidiye gouldma god sibera na siyapeepeteni. ");
INSERT INTO aui_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Bi katana, yadi tamumu kunoghotataveni, bi gegha na, memeda kagu waghawagha yam buka kamonama kasunaghataveni.” ");
INSERT INTO aui_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Bi Yawe God iwonabodeyana bo, “Gegha, iiyawogha Tagu biidi tamumu sinaberana, yagu buka kamonama kadi waghawagha anakasunayi. ");
INSERT INTO aui_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Na kunagho, da yagu wawaya kuninaghovedi konanagho da gawara meme awonem na nabo, bi yagu aneya ininaghovem. Bi gegha da raghani inapiika na yadi tamumu kiiravine na aro anaveredi.” ");
INSERT INTO aui_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Wasina bi wawaya kau natuna makina, Eron ibera bi sipepeteni kiiravine na Yawe God gubaga bero kirakiinama aro iveredi. ");
INSERT INTO aui_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Raghani viya murine, na Yawe God, Mosis iwoneni bo, “Akima benabenadi bata kuboridi nokodi kugawoworana naboni, bi debadiye na sisiyidi mayimayiyidi anagiruma ware naghove naboni. ");
INSERT INTO aui_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Maram didibare na kabununagha, da kugae Sainai Koyane bi name kunabananigu.” ");
INSERT INTO aui_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Na Mosis akima benabenadi bata iboridi, bi didibare pomsowae akimidi ikawara igae Sainai Koyane, metagha Yawe God iwonenina naboni. ");
INSERT INTO aui_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Bi Yawe God uuwa kamonagha iyowogha da nama yawata siyamiimiiri, na Tounamani kana waghawagha iwonena mayeni, Yawe God. ");
INSERT INTO aui_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Wasina bi Yawe God, Mosis naghone inomiiri bi irukwatu bo, “Tagu, na Yawe, bi kayowiiyayeyana da nuwatotowana kana God, na genuwanuwagu iyapughupughu yaininagha, bi nuwamonika da wiitumaghaneyana gwabiguve na aninuwayuyuna nonowa. ");
INSERT INTO aui_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Bi nuwamonika gwabiguve da aninuwayuyuna nonowa kata da inanagho kimta 1,000 murine, bi iiyawogha bera beroberodi da tamumu sabera na ananoghotatavedi. Bi berabero wawayidi da natunatudi, tubutubudi, bi kate nosinosidi na aro anaveredi.” ");
INSERT INTO aui_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Bi Mosis ivituwapore oghogheyana da mayiyina iyowogha dobodobove bi God ikabepepi ");
INSERT INTO aui_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","iwona bo, “O Yawe God, memeda kuninuwamiise tagu biidi na arurupari da gwabimiiye kunamake. Wiisuwona mmkodi damdi nuwanuwadi sikotakii, bi gegha da bagune, yama beraberodi da tamumu kunoghotatavedi bi kabimii da tamwosina yam wawaya.” ");
INSERT INTO aui_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Wasina bi Yawe God iwonabodeyana bo, “Kuwaiyana! Tagu wiiwaghasina maragasina aberabera Isrel damdi teya. Bi wawaya tupami naghomiye konakitagu bera ghamaghamadi anabera mekodi wawaya gegha naghove siyakita kubura mududiye siyatubughana. Basuna tami kiiravimiye na mmkodi anabera, na wawaya kamodiye komakamakena tupadi sinanaghara.” ");
INSERT INTO aui_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosis gabudara 40 da nubabasu 40 name koya debane Yawe God yawata simakae, bi getana awaki iyakam bo iyaniunana. Bi touna wiiwaghasina maragasina sisiyidi - gwara yadi 10 akima benabenadi debadiye igiruma. ");
INSERT INTO aui_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Wasina bi Mosis Sainai Koyanama iyowogha bi imane na Wiiwaghasina Maragasina akimidi benabenadi bata ikabitawana. Touna koya debane God teya sivisisiya bi raghanina iveramagha iyowogha, na mayiyina iyayeyeghani bi geiyakovina. ");
INSERT INTO aui_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Eron da Isrel damdi sikita bi Mosis mayiyina iyayeyeghani na sinaghara da gesiyapiika ririnena. ");
INSERT INTO aui_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Bi gegha da Mosis ikwatuvedi na Eron da Isrel dogadogara siveramagha bi ivisisiya toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Wasina bi noko murine, na Isrel damdi tupadi simiiririya bi Mosis gwara tupadi Sainai Koyana debane Yawe God iwoneni, na naboni wawaya iwonawiiakovidi. ");
INSERT INTO aui_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Raghanina Mosis toudi biiyadi wiisisiya yakabitore, na mayiturababara garanama mayiyina yasowo. ");
INSERT INTO aui_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Bi raghanina Mosis yanagho Yawe God yawata Kiregoru Kabikabikuwayina kamone wiisisiya biidi, na mayiturababara yakabitaveni patana da yakanibu. Bi ragahanina yakanibu na metagha God iwonawiiyoyowaneni na Isrel damdi yawonedi, ");
INSERT INTO aui_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","na Isrel damdi sakita da mayiyina na yayeyeghani. Wasina bi Mosis mayiturababara garanama mayiyina yasowo mayeni patana da Yawe God yawata wiisisiya magha biidi na yakabitaveni. ");
INSERT INTO aui_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Wasina bi Yawe God ivisisiya Mosis biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Nawaravi dagudaguna bi gabudara dagudagune na yagu Kiregoru Kabikabikuwayina kona kabiwiimiiri. ");
INSERT INTO aui_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Bi Wiiwaghasina Maragasina Dedewagina, mekona gwara yadi 10 kamone na Kiregoruna kamone kutore bi tupayarayina beberama naghona kutorebabari. ");
INSERT INTO aui_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Bi kiinabonabo kawari kurughu da kate kana sawara kiiravine sibera, na debane kutoura. Bi kate kibemiimiiri kawari kurughu bi kibedi debane kutoura. ");
INSERT INTO aui_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Wasina bi sikoko gabugabuna gawarina gouldma sibera na Wiiwaghasina Maragasina Dedewagina naghone kutore bi bebera kirorogi da Kiregoruna kunaguduni. ");
INSERT INTO aui_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Bi suwara kadi gabugabuna puyo gabunidi kiiravine na yagu Kiregoru naghone matamkete kutore. ");
INSERT INTO aui_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Bi dabira ghamana koghakogha kiiravine kabi da Kiregoru da suwara gabugabuna gawarina basudiye kutore bi rarimama kibonuvi. ");
INSERT INTO aui_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Bi gawarina na beberama kutayinaviviridi da kunagaridi bi bebera siberana kuvirorogi da Kiregoru garina matamketana inagudu. ");
INSERT INTO aui_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Wasina bi toreirana mayawagina kabi bi Kiregoru da kana sawara tupadi kamone na debadiye kiwagha, bi kutoreireni, da touna kabikabikuwayina. ");
INSERT INTO aui_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Bi suwara kadi gabugabuna gawarina puyo gabunidi kiiravine da kana sawara tupadi, mayawagama kiwayidi bi kutoreireni da kabikabikuwayina. ");
INSERT INTO aui_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Mayawagama dabira ghamana koghakogha kiiravine da kana miimiiri kiwayidi bi kutoreiredi. ");
INSERT INTO aui_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Bi Eron natunatuna yawata kupiikedi Kiregoru Kabikabikuwayina naghone da rarimama kiyekidi. ");
INSERT INTO aui_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Bi Eron gara kabikabikuwayidima kikounayi, bi mayawaga debane kiwayi da kutoreireni tagu inabagibagiyegu naboni prist. ");
INSERT INTO aui_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Natunatuna piikedi da prist kadi garama kikounayidi, ");
INSERT INTO aui_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","bi mayawaga debadiye kiwagha ware tamadinaki mayawagama kwiiwayi na naboni, da nonowa sinabagibagiyegu naboni prist. Toudi da nosinosidi na kata da kimta muriye sinapiipiika na prist bagibagina sinaberabera wiiwoneni.” ");
INSERT INTO aui_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mosis bera tupana metagha Yawe God iwonenina naboni ibera. ");
INSERT INTO aui_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Wasina bi bodu wiibatane, na nawaravi dagudaguna bi gabudara dagudagune, na Kiregoru Kabikabikuwayina sikabiwiimiirini. ");
INSERT INTO aui_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosis, koghora kadi miimiiri akimama siberana name bonayidiye koghoridi ikabiwiimiiridi bi riirii da tupoga itoura. ");
INSERT INTO aui_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Wasina bi sowo siberana Kiregoruna irikena debanagha sitore bi wowone na ribiribi bekadima sowo siberana tounama sikasitawani, metagha Yawe God iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Wasina bi Mosis akima benabenadi bata iyouna da Wiiwaghasina Maragasina Dedewagine iuwana. Bi paghodi kwakiye sivitupateetee Wiiwaghasina Maragasina Dedewagina nawanawane, bi kanataratawana, meko debane na tamumu koghatavenina gawarina ikabi da itaratawani. ");
INSERT INTO aui_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Bi Dedewagina ikawari irughu Kiregoru Kabikabikuwayine bi tupayaragha beberina tupatupana ivirorogi da Wiiwaghasina Maragasina Dedewagina iyababari, metagha Yawe God iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Bi kate kiinabonabo ikawari irughu Kiregoru Kabikabikuwayina kamone, bi tupayaragha beberina kubune kikiramutumutuba yana nawae itore, ");
INSERT INTO aui_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","bi bred Yawe God biidi sipuyo na iyouna da debane itoura, metagha Yawe God iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Bi kibe miimiiri ikawari irughu Kiregoru kamone da wareregubugubura yana nawae itore da kiinabonabo imiiri karoneni ");
INSERT INTO aui_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","bi kibedi Yawe God matane ivinawanawii, metagha Yawe God iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Bi sikoko gabugabuna gawarina gouldma sibera na ikabi da tupayaragha beberina naghone itore, ");
INSERT INTO aui_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","bi sikoko igibu, metagha Yawe God iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Wasina bi bebera ivirorogi da Kiregoru matamketana iyagudu. ");
INSERT INTO aui_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Bi suwara gabugabuna gawarina puyo gabuna kiiravine Kiregoru matamketana naghone itore, bi debane ribiribi da bred isuwara, metagha Yawe God iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Bi dabira ghamana koghakogha kiiravine Kiregoru da suwara gabugabuna gawarina bi basudiye itore bi rarimama ivibonuvi amagha kiiravine, ");
INSERT INTO aui_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","na Mosis, Eron da natunatuna yawata name imadi da kayedi samagha, ");
INSERT INTO aui_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","raghanina Kiregoru kamone rughu biidina, bo nagho suwara gabugabuna gawarine na, metagha Yawe God iwonenina naboni ibera. ");
INSERT INTO aui_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Na Mosis, Kiregoru da suwara gabugabuna gawarina beberama igari wiikenavivireni, bi gari matamketane bebera ivirorogi. Wasina bi Mosis bagibagi tughurina ibera da ivikovini. ");
INSERT INTO aui_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Wasina bi uuwa Kiregoru Kabikabikuwayina isowo, na Yawe God yana kiniwa ivibonuvi. ");
INSERT INTO aui_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Uuwa Kiregoru wowone itourawiipikapika na Yawe God yana kiniwa ivibonuvi kiiravine, na Mosis gerubana da iyarughu kamonena. ");
INSERT INTO aui_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Bi raghanina uuwa Kiregoru debanama inarukawari, na Isrel damdi sinaguguwa bi sinakivini sinanagho gawara tane. ");
INSERT INTO aui_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Bi uuwa geinarukawari, na kate gesinanaghona - patana da inarukawarina gabudarine na wasina. ");
INSERT INTO aui_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Na yadi pepewa gabudaridi tupana kamone, na Yawe God yana gwabigwabiyana uuwa Kiregoru wowone gabudare siyakitakita, bi nubabasuve na keyama iyakarakarata na siyakitakita. ");
INSERT INTO aui_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yawe God, Kiregoru Kabikabikuwayinama Mosis ikwatuveni iwona bo, ");
INSERT INTO aui_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Mmkodi na suwara gabuna kadi wonawiiyeveveyana, na Isrel damdi mma naboni kuwonedi, raghanina wawaya iiyabo ribiribi kwasuwasuwara Yawe God biidi na kau tana, bo sip bo gout tanagha kunakawari kunapiika yam suwara kiiravine. ");
INSERT INTO aui_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Meboda yam suwara kau, na nokona ribiribi makina bi takutakukuna bi getana berona gwabinena. Kunakawari kunapiika Kiregoru Kabikabikuwayina matamketane, da Yawe God matanena tam wasina. ");
INSERT INTO aui_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Bi imam ribiribina gayamine kutore, da yana basuna noko ribiribina kam gawara inakabi inarabobo da Yawe God noko rabobona iniwaghasineni da kam gawara ikabi da yam tamumu ikabitaveni, bi inaberam da matane na tam rotomanim. ");
INSERT INTO aui_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Yawe God naghone kunakasunuyi, bi Eron natunatuna toudi na prist noko ribiribina ganiganina sinayouna bi Kiregoru Kabikabikuwayina matamketane, suwara gabugabuna gawarina nawanawana yadi 4 sineburidi. ");
INSERT INTO aui_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Wasina bi ribiribina bekana kunasikataveni, bi kunarigha da kunataramutu. ");
INSERT INTO aui_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Bi prist suwara gabugabuna gawarine kii raberabega sinatoura bi sininawiini. ");
INSERT INTO aui_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","9","Bi ribiribina dimna da kayena kukoghadi bi prist kunaveredi, da taridi tupadi bi gayama da nanara teya suwara gabugabuna debane keyama wowone sinatoura, da noko ribiribina ere tupana sinagabuni. Mmkona suwara gabugabunina, kam suwarina, bi ghabuna iwaratete kirakii Yawe God biidi.” ");
INSERT INTO aui_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Yawe God iwona magha bo, “Meboda kau kunapuyo naboni wiiturana suwarina, na noko makina bo yagarina bi takutakukuna getana berona gwabinena. ");
INSERT INTO aui_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Bi Kiregoru Kabikabikuwayina matamketana naghone, imam ribiribina gayamina debane kutore bi kunakasunuyi. Bi Eron natunatuna toudi na prist ribiribina ganiganina sinakabi da suwara gabugabuna gawarina yadi nawanawana 4 sineburidi. ");
INSERT INTO aui_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Bi dim kamonama nanara tupadi, da kubupisipisika yadi bata ere nanaridi da katekate gerena kuyouna bi kusuwara. Bi prist wiiturana puyonama mmkodi dimdima inasuwara naboni kam suwarina Yawe God biidi. ");
INSERT INTO aui_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Wasina bi Eron natunatuna suwara gabugabunidi debane sinatoura bi sinagibu wiikapu. Mmkona kam suwarina, bi ghabuna na iwaratete kirakii Yawe God biidi.” ");
INSERT INTO aui_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Wasina bi Yawe God ivisisiya Mosis da Eron biiyadi iwona bo, ");
INSERT INTO aui_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Meboda iiyabo gubaga ghamana, nota bo sinina inaruyano bi yaberabera da beka gubagina ghamana, na yana wawaya sinapiikeni prist biiyadi, Eron, bo natunatuna tana. ");
INSERT INTO aui_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Da prist gubagina sinakabikita yapori, bi ghunighuni gubagina kamone miimiiridi sinapoe bi gubagina inayokirakii sini kamone, na wasina nokona beka gubagina ghamana. Wasina bi prist wawaya inawonedi bo, ‘Mmko wawayina na God matene na idadabu.’ ");
INSERT INTO aui_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Iiyabo beka gubagina ghamana gwabine na gara tamogosigosiridi iniyagha, gayama ghunighunina geininasina, bi kawana inakasibabari bi wawaya biiyadi inarukwatu bo, ‘Tagu na dadabugu! Gekonapiika ririguvena!’ ");
INSERT INTO aui_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Raghanina gubagina gwabine inamakamake na touna patana dadabuna. Na tanaduma taki kubune inamakae, wawaya gwabidima inibogae.” ");
INSERT INTO aui_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Yawe God ivisisiya Mosis biidi iwona bo, “Raghanina wawaya ribiribi inakasunuyi, na ganiganina inororotaveyana bi noko murine inakani. Meboda Isrel wawaya tana bo kubura wiibata wawaya yawata komakamake bi iyuwa ere ganiganina inakani, na noko wawayina tagu anamiiri kubuteni da getagu yagu wawaya. ");
INSERT INTO aui_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Sawara yawayawiidi tupadi yadi yawa na ganigani kamone, bi ganigani averemi da suwara gabugabuna gawarina debane yami tamumu iyakoghatavedi. Na ganiganina yana basuna na yawa, noko biidi na tamumu yakoghataveyana.” ");
INSERT INTO aui_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Wasina bi Yawe God, Mosis iwonena mayeni bo, ");
INSERT INTO aui_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Isrel damdi kuwonedi da Tagu na Yawe yami God. ");
INSERT INTO aui_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Gegha konabera da ware Ijipt damdi siyaberaberana, iiyawogha yadi kubure koya makamakena naboni, bo konabera da ware Kenen damdi siyaberaberana, iiyawogha yadi kubure akabimi tanaghonagho na naboni. Geyadi kedagha konanaghona. ");
INSERT INTO aui_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Tagu na Yawe God, noko biidi yagu gwara da wonawiiyoyowana kokabisisiredi da konabera. ");
INSERT INTO aui_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Memeda yagu gwara konakabisisiredi bi wonawiiyoyowana konabera, na yawa gwabidima konakabi, Tagu Yawe God. ");
INSERT INTO aui_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Tagu Yawe God, na yagu sisiya kowaiyana, da getana iiyabo yana rakaraka ririne yawata sinimumuranana. ");
INSERT INTO aui_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Gegha wasike nawaravi yakabikabi, bi yawata konimumuranana, basuna touna na dadabuna. ");
INSERT INTO aui_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Gegha tomogha tana wavinena yawata konimumuranana - memeda naboni konabera na konidadabumi. ");
INSERT INTO aui_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Gegha natunatumi konapuyo, god Molek yana suwara gabugabuna gawarina debane. Tagu na Yawe yami God, bi memeda naboni konabera na kagu waghawagha konisinimayamayayi. ");
INSERT INTO aui_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Gegha tomogha tana tomogha turana yawata sinimumuranana, mayimayiyina wasike teya; Mataguve na mmko ibero kirakii. ");
INSERT INTO aui_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Gegha tomogha bo wasike tana ribiribi teya sinimumuranana, memeda naboni konabera na tami konadadabu. ");
INSERT INTO aui_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Gegha mmkodi beradi konabera da konidadabumi. Basuna nokodi wawaya Kenen kubure samakamakena naboni sibera da mataguve na sidadabu, noko biidi na kuburinama ivikanibuvedi bi tami konarughu kamone.” ");
INSERT INTO aui_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yawe God, Mosis iwonena mayeni bo, ");
INSERT INTO aui_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Isrel damdi tupadi kukasi wiitaghomidi bi kuwonedi da Tagu Yawe yami God na kabikabikuwayigu, na kobera da kabikabikuwayimi. ");
INSERT INTO aui_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Iiyabo berona inabera tam biidi, na noko berana gegha nuwanuwam kamone kunatorena, bi gegha da nuwamiiseye kisisiya wawayina biidi, bi berana kuvirotomani wawayina yawata, da gegha iniberomna. ");
INSERT INTO aui_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Gegha biwa kunakabina bo nuwanuwam patana inapughu yam wawaya waghata biidi, bi gegha da maketuram kinuwayuyuneni naboni tammani kwiinuwayuyunemna. Tagu na Yawe God.” ");
INSERT INTO aui_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Yawe God ivisisiya Mosis biidi iwona bo, “Isrel damdi kuwonedi da iiyabo sawara yana basuna kabina kiiravine, na Tagu, Yawe God initarakiiyanegu. Bi gegha wonawiiyoyowana kiiravine na inanagho iiyabo, raborabobodi kanumidi yawata sisisiya na wawayina biidi. Memeda wawaya naboni inabera, na anamiiri kubuteni da getagu yagu wawaya.” ");
INSERT INTO aui_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Yawe God, kate bada Mosis iwonena mayeni bo, “Isrel damdi kuwonedi da iiyabo wawaya iniruberowaneni, na awaki ibera, na mayimayiyina touna biidi konabera. ");
INSERT INTO aui_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Meboda irikena inakasigiini, na touna bada mayimayiyina konabera da irikena tana konakasigiini. Bi meboda wawaya matana tana inibero, na mayimayiyina touna bada naboni matana tana kovibero. Bi meboda wawaya nighona tana inakasirige, na mayimayiyina touna bada naboni nighona tana kokasirige. Wawaya iiyabo nokodi bera berodi naboni inabera, na mayimayiyina bada bera berodi naboni touna biidi konabera. ");
INSERT INTO aui_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Iiyabo wawaya tana yana ribiribi inakasunuyi, na inimiisana da initaparari. Bi iiyabo wawaya tana inakasunuyi, na mayimayiyina touna bada kokasunuyi. ");
INSERT INTO aui_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Tagu na Yawe yami God, noko biidi mmkodi gwara na tami tupami kiiravimiye, Isrel dammi da kate kubura wiibata damdi iiyawogha kamomiye samakamakena.” ");
INSERT INTO aui_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yawe God, Mosis iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Eron da natunatuna kuwonedi da Isrel damdi siniimiiseyedi na mmkodi sisiyidima sinawonedi. ");
INSERT INTO aui_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Yawe God inimiiseyemi, bi inabodami. ");
INSERT INTO aui_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yawe God mayiyina inabera da inaruyeghani debamiye, bi miisena inabera tami biiyadi. ");
INSERT INTO aui_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yawe God nuwamiiseye inakitakitami, bi nuwaruriri inaveremi.’ ");
INSERT INTO aui_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Raghanina Eron natunatuna yawata kagu waghawaghae Isrel damdi siniimiiseyedi, na Tagu wosina toudi animiiseyedi.” ");
INSERT INTO aui_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yawe God, Mosis iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Isrel damdi kadi dam yadi 12 kamodima, babada tadigegha kuvinegha dam nununagha kiiravidiye bi sinanagho da Kenen kubura, meko Isrel damdi avereveredina sinakitawiikighuni.” ");
INSERT INTO aui_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Na Mosis metagha Yawe God iwoneni na ibera. Da Isrel kana dam yadi 12 kamodima babada tatadigegha ivinegha, bi Paran mayabine yadi takima iviporadi sikanibu sinagho. ");
INSERT INTO aui_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Raghanina Mosis iviporadi siyakanibu da Kenen kubura siyakitawiikighuni na iwonedi bo, “Kikiramutumutuba yana nawae kogae da Negeb kubura makewapana koverarughuwoneni bi korughu konagho koyakoya kubure. ");
INSERT INTO aui_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Da kuburina akovina konakabi, bi wawaya viya name samakamake, bi meboda maragasidi bo noganogadi? ");
INSERT INTO aui_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Bi tanawa akovina konakabi, miisena bo berona? Awaki kwanatudiye samakamake ere papadi bo debae gepaapadina? ");
INSERT INTO aui_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Bi dobodobona kanakita metagha? Moumourina bo gomagomarina? Bi name kii bo gegha? Bi kovimatipo da kuburina kana kiiuwa mududi kokawara koveramagha.” (Mmkona greip yadi meni dagudaguna irina). ");
INSERT INTO aui_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Na tomotomoyidi kikiramutumutuba yana nawae sigae sinagho da tanawa sikitawiikighudi Zin mayabina wareregubugubura yana nawae bi igae inagho patana da kubura kana waghawagha Reob, nokona kubura kana waghawagha Lebo-Hamat ririne kikiramutumutuba yana nawae. ");
INSERT INTO aui_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kuburina sikitawiikighuni ikovi bi gabudara 40 sikovi murinena siveramagha, ");
INSERT INTO aui_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Mosis, Eron da dam Isrel tupana biiyadi Paran mayabine, kubura kana waghawagha Kedesma. Bi yadi kitawiikighu warana dam Isrel biiyadi sivimaghamaghatara da kate noko kuburinama kiiuwa sikawara siveramagha na siviyevevedi. ");
INSERT INTO aui_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wasina bi tomotomoyidi, Mosis siwoneni bo, “Tam noko kuburine kuviporami kanagho, na tanavina moumourina, da kwabudi miisedi; bi kam wiiyeveveyana na kiiuwadi makatanina noko kuburinama. ");
INSERT INTO aui_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Bi gegha da wawaya noko kuburine samakamake na toudi maragasidi, bi yadi kwanatu na ghamanakidi da papadi na bada maragasidi. Bi Anak nosinosina kakitadi, da wawayidina imaraguriguridi. ");
INSERT INTO aui_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Bi Amelek damdi Negeb kubure samakamake, bi dam Hitti, Jebusi da Amori na koyakoya kubure samakamake, bi Kenen damdi yegii ririne samakamake da kate Jodan rarimina rurerenagha.” ");
INSERT INTO aui_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Wasina bi Keileb iwona na wawaya, Mosis sigwagwari siyamiimiiri na siviraborabobo bi iwona bo, “Touda rubana nokodi wawaya tanageiwayidi bi tanavina tanakabi, na kata tanagae tananagho da kuburina tanakabi tanirapeneni.” ");
INSERT INTO aui_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Bi gegha da tomotomogha iiyawogha yawata sigae sinagho na siwona bo, “Gegha, nokodi wawaya na sivimaragata kirakii, bi gerubana tananagho da yawata tanirouwana.” ");
INSERT INTO aui_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Na noko tanavina sikitawiikighuni na kiiravine wara berona Isrel damdi biiyadi sivisisiya, siwona bo, “Tanawa meko kakitawiikighuni, na wawaya kamone samakamakena yiberodi. Nokodi wawaya name kakitadi na imaraguriguridi. ");
INSERT INTO aui_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Bi kate Napili damdi bada name kakitadi. (Toudi na Anak nosinosina). Bi toumii kakita mayemii da toudi matadiye, na kagisi kirakii ware tatata naboni toudi riridiye.” ");
INSERT INTO aui_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Wasina bi dam Isrel tupana sidagu gamo ghamanama sinasiyapa, da noko nubabasune na siduu raghani. ");
INSERT INTO aui_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Da gwinima Mosis da Eron siviaviyedi, siwonedi bo, “Toumii kakayoveni da name Ijiptne kayarabobo! Bo meboda mma mayabe. ");
INSERT INTO aui_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Bi awaki kiiravine na Yawe God yanavenaveda noko kuburine, da wawaya name sinikasunughaneda? Bi natuwavineda da natunatuda sinaroda naboni neneyana. Bi iyamiise kirakii da meboda tayaveramagha Ijiptma!” ");
INSERT INTO aui_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Na siwonena mayedi bo, “Touda kiiravidae kada wiinaghowana tana tanavineyi bi tanaveramagha Ijiptma.” ");
INSERT INTO aui_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Wasina bi dam Isrel tupana naghodiye bi Mosis da Eron sipepeta da mayiyidi siyowogha dobodobove. ");
INSERT INTO aui_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Bi Nun natuna Josuwa da Jepune natuna Keileb, na kitawiikighu damdi yadi bata sivinuwapoya na kadi gara sitayina gosigosira, ");
INSERT INTO aui_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","bi dam Isrel tupadi siwonedi bo, “Noko kuburina tupana kavera rughuwoneni da kakita wiikighuni bi tanavina na imiise kirakii. ");
INSERT INTO aui_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Memeda Yawe God ininuwamiise touda biiyadi, na noko kuburine inakabida tanarughu da inavereda. Bi tanavina na moumourina da kwabudi miisedi bi ribiribi peyaridi. ");
INSERT INTO aui_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Bi gekonikuwamira da Yawe God koniaviyenina, gegha kuburina wawayidi konanagharedina, basuna Yawe God na gwabidae bi toudina gegha kadiwiiwita tana meme, bi rubana da tanageiwayidi, noko biidi na gekonanagharedina.” ");
INSERT INTO aui_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Wasina bi wawaya tupana siwona da Josuwa da Keileb akimama siyarouvidi da siyikasunughana. Bi gegha da Yawe God yana kiniwama irumaghatara dam Isrel tupadi biiyadi, Kiregoru Kabikabikuwayina naghone. ");
INSERT INTO aui_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Wasina bi Yawe God, Mosis da Eron iwonedi bo, ");
INSERT INTO aui_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Raghani viya mmkodi wawaya kawakekedi gwinima siniaviyegu? Isrel damdi yadi gwini Tagu biidi na awaiyana! ");
INSERT INTO aui_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Na noko biidi mmko sisiyina kowonedi: Yawe God yawonawona bo, ‘Wiisuwona da awaki beradi sisiyidi awaiyana kovisisiyedi na nokodi bera anabera tami biiyadi. ");
INSERT INTO aui_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Bi iiyawogha sikabiyavimi da kami bodu 20 bi nabo igae, na mma mmko mayabine konarabobo, basuna tupami gwinima koviaviyegu na kiiravine, ");
INSERT INTO aui_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","bi kubura meme avisuwona da ayaveremi, na tupami kate gegha konarughu da konamakena. Wasina Jepune natuna Keileb da Nun natuna Josuwa, toudi kawagha sinarughu noko kuburine. ");
INSERT INTO aui_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Bi natunatumi kiiravidiye mekodi kowona da kami aviya sinayouna ware neneyana, na anakabidi sinarugha noko kuburine, meko kosinighiiyeni na name sinamake. ");
INSERT INTO aui_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Bi tami na mmko mayabine konarabobo. ");
INSERT INTO aui_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Bi natunatumi na bodu 40 mmko mayabine sip sinakoyakoyagha patana da tupami konarabobo. Bi geyami wiitumaghana gwabiguve kiiravine na sinakabikwarakwara. ");
INSERT INTO aui_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tami tanavina gabudara yadi 40 kokita wiikighuni kiiravine, na bodu 40 aro anaveremi bodu tanagha, na gabudara tana kiiravine. Bi koberagu da kami aviya kiiravine na noko kabikwarakwarana damina konakabi. ");
INSERT INTO aui_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Tagu, Yawe God iisisiya, da wiisuwona mmko berana anabera mmko damna kawakekedi tupadi biiyadi, iiyawogha sivituwiikapukapu da siaviyeguna. Bi mma mayabe yadi tughura sinabanani, da mma tupadi sinarabobo.’” ");
INSERT INTO aui_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Wasina bi nawaravi dagudagune, na dam Isrel tupana siverakanibu Zin mayabine, da Kedes kubure sivitaki. Bi Miriyam name irabobo na sidogu. ");
INSERT INTO aui_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Bi noko kuburine rarima gegha kiiravine, na wawaya tupadi Mosis da Eron sigwagwaridi bi siviaviyedi. ");
INSERT INTO aui_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Da gwinima Mosis siwoneni bo, “Toumii kakayovena kiirakiiyeni da warewaresimii yawata kayarabobo, Yawe God matane sirabobona naboni. ");
INSERT INTO aui_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Awaki kiiravine touda Yawe God yana wawaya mabo kukabi kanibuveda mmko mayabine, da yada ribiribi yawata tanarabobo? ");
INSERT INTO aui_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Awaki kiiravine kubera da Ijipt kubura kakuyoveni bi kapiika mmko kuburina berone? Mma na getana wit bo kogheya, greip bo pomegrenate, bi getana rarima da niuna.” ");
INSERT INTO aui_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Wasina bi Mosis da Eron, wawaya tupadi sikuyovedi bi sinagho Kiregoru Kabikabikuwayina matamkete bi mayiyidi siyowogha dobodobove. Na Yawe God yana kiniwa yeghanina irumaghatara toudi biiyadi, ");
INSERT INTO aui_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","bi Mosis iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Yam dighona kabi bi waresim Eron yawata Isrel tupadi kokwatu wiitaghomidi. Bi wawaya matadiye noko akimina kuwoneni da rarima inaveremi. Noko kedane na tam akimama rarima kunapiikeni toudi kiiravidiye, da yadi ribiribi teya sinaniuna.” ");
INSERT INTO aui_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Na Yawe God, Mosis iwoneni na naboni ibera da naghone bi dighonina ikabi. ");
INSERT INTO aui_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Wasina bi Mosis da Eron wawaya tupadi sikwatuvedi na akima ghamana naghone sivitaghomidi, bi Mosis iwona bo, “Kowaiyana, tami wawaya kawakeekeemi, bo mmko akiminama rarima kanapiikeni kiiravimiye?” ");
INSERT INTO aui_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Bi Mosis yana dighona imane na irukabepi da akimina irouvi raghani bata, na rarima ivitosiyo ikanibu da wawaya tupadi da yadi ribiribi yawata siniuna. ");
INSERT INTO aui_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Bi gegha da Yawe God, Mosis da Eron iwonedi bo, “Tami Isrel damdi matadiye gekoyitumaghanegu bi gekoyiyeveveyana da Tagu kabikabikuwayigu kiiravine, na mmko damna kate gekoninaghovedi meko kuburina avisuwona da ayaveredina nabo.” ");
INSERT INTO aui_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Bi Idom kubura kana wiibarabarate, Hor Koyane Yawe God, Mosis da Eron iwonedi bo, ");
INSERT INTO aui_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Tami kubura Meriba rarimine gekoyakabisisiregu kiiravine, na Eron gerubana noko kuburina Isrel damdi avereveredi na inarughuna, bi touna mma inarabobo. ");
INSERT INTO aui_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Na Eron da natuna Eliesa kurutayinidi kogae Hor Koyana debane. ");
INSERT INTO aui_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Bi name prist garadi Eron gwabine na kabitavetaveyana bi natuna Eliesa kikounayi, kiiravine Eron nama inarabobo da inanagho nosinosinanakim biiyadi.” ");
INSERT INTO aui_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mosis awaki tupana Yawe God iwoneni na naboni ibera. Da wawaya tupadi matadiye bi Hor Koyana saghiini sigae. ");
INSERT INTO aui_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mosis, Eron kana gara ikabitavetaveyana bi natuna Eliesa ivikounayi, bi Eron name koya debane irabobo. Wasina bi Mosis da Eliesa koyama siveramagha siyowogha, ");
INSERT INTO aui_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","bi raghanina dam Isrel akowa sikabi da Eron irabobo, na tupadi gabudara 30 kiiravine sidou. ");
INSERT INTO aui_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Bi Hor Koyana sikuyoveni bi sitouyana Yegii Idurina kedana sikabi, da Idom kubura siyaveravivireni. Bi gegha da kedae wawaya nuwanuwadi sipughu basuna yadi wagawaga iyaguriguri. ");
INSERT INTO aui_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Na toudi gwinima God da Mosis siviaviyedi siwona bo, “Awaki biidi Ijiptma kokabikanibuveda da mma mayabe tana rabobo? Toumii kam da rarima gegha! Bi kate geyama kayowana mmko kamna berona!” ");
INSERT INTO aui_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Wasina bi Yawe God, mota googonidi iviporadi sirughu wawaya kamobasudiye da siyakanikanidi, na dam Isrel korotodi sirabobo. ");
INSERT INTO aui_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Na wawaya sipiika Mosis biidi bi siwona bo, “Toumii bera berona kabera raghanina Yawe God da tam biidi kagwinina. Bi kiiravimiiye Yawe God biidi kurupari da mmkodi mota gwabimiima inakabitavetaveyana.” Na Mosis wawaya kiiravidiye irupari. ");
INSERT INTO aui_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Wasina bi Yawe God, Mosis iwoneni bo, “Mota googonidi gubadi tana kubera bi kiikera damone kiyatawatawani. Memeda mota, wawaya tana inakani na inakayogagawa inakita na inayawa.” ");
INSERT INTO aui_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Noko biidi Mosis, bronsma mota igubani bi kiikera damone ikiyatawani. Da memeda mota, wawaya tana inakani na inakayogagawa da bronsma mota beraberana inakita na inayawa. ");
INSERT INTO aui_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Wasina bi dam Isrel sitouya sinagho da kubura kana waghawagha Obotne sivitaki. ");
INSERT INTO aui_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Bi Obot kubura sikuyoveni sitouya na sinagho mayabe kubura kana waghawagha Iye-Abarim, Moab kubure raghani matana nawane. ");
INSERT INTO aui_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Bi nama sitouya na sinagho viriri kubura kana waghawagha Jeredne sivitaki. ");
INSERT INTO aui_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Wasina bi nama sitouya magha na sinagho da kikiramutumutuba yana nawae Anon rarimina rurerene sivitaki, mayabe dam Amori yadi kubura kana wiibarabarate (Anon rarimina na barata, touna Moab kubura da Amori kubura itupayarayidi). ");
INSERT INTO aui_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Wasina bi Isrel damdi sawariyonayona sidarudi dam Amori yadi kiiwawo Siyon biidi da siyawoneni bo, ");
INSERT INTO aui_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Toumii yama wiina da yam kubura kanavera rughuwoneni. Bi gekeda kanituirana da yami kwabuve kanarughuna, bo yami doguve rarima kananiunana. Toumii Kiiwawo yana kedagha kawagha kananagho patana da yam kubura kanaveratupiireni.” ");
INSERT INTO aui_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Bi gegha, kiiwawo Siyon geiyiwaghasina da Isrel yana kubura siyavera rughuwoneni. Touna yana aviya damdi ikwatu wiitaghomidi bi sikanibu sinagho mayabe da dam Isrel teya siyiaviya. Raghanina kubura kana waghawagha Jahasne siverakanibu na name dam Isrel teya sivirouwa. ");
INSERT INTO aui_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Bi gegha da Isrel sigeghomiiri da yadi serima kiiwawo Siyon sigeiwayi bi yana kubura sikabi, Anon rarimine da igae inagho Jabok rarimine, bi gesiyano kirakii wasina Ammon damdi yadi barate, basuna yadi barata na ere maragasidi siyakighukighu wiimasiyeni. ");
INSERT INTO aui_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Dam Isrel sigeghomiiri da dam Amori yadi kwanatu tupadi sivirapeneyana da kamodiye sitoura wiipikapika, yadi kwanatu ghamana Hesbon da kate kwanatu gisigisidi ririnena. ");
INSERT INTO aui_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Dam Isrel, Amori damdi yadi kubure sitoura wiipikapika simakae. ");
INSERT INTO aui_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Bi Mosis tomotomogha idarudi da Jasa kwanatuna siyakitawiikighuni, murine na dam Isrel sigeghomiiri da kwanatu gisigisidi ririne teya sivirapeneyana bi Amori damdi nama makamakedi sirukwavina sikanibu. ");
INSERT INTO aui_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Wasina bi dam Isrel simiiri wamira da keda yageegee Basanma na sikabi sinagho. Bi Basan kana kiiwawo Og yana aviya damdi teya sikanibu da kubura kana waghawagha Edreine sivirouwa. ");
INSERT INTO aui_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Bi gegha da Yawe God, Mosis iwoneni bo, “Gekunanagharenina, kiiravine touna, yana wiiaviya damdi tupadi da kate yana kubura imadebamve atoretoredi. Bi Amori damdi yadi kiiwawo Siyon, iiyabo Hesbonne iyibada bi metagha kuberani na naboni mayimayiyina kunabera kiiwawo Og biidi.” ");
INSERT INTO aui_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Na dam Isrel, kiiwawo Og, natunatuna da yana wiiaviya damdi sigeiwayidi, getana iiyabo siyakabiwiiadina. Wasina bi yana kubura sikabi sivirapeneni. ");
INSERT INTO aui_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Wasina bi Isrel damdi sitouya sinagho da Jodan rarimina ririne, Moab ruwiipikapikane sivitaki bi nawane na Jeriko kwanatuna. ");
INSERT INTO aui_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Raghanina Jipo natuna Balak, Moab kana kiiwawo iwaiyana da Isrel damdi awaki sibera dam Amori biiyadi, ");
INSERT INTO aui_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","bi kate Isrel damdi yadi viya nama, na yana wawaya teya sinaghara kirakii. ");
INSERT INTO aui_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Wasina bi Moab damdi Midiyan babada siwonedi bo, “Mmko korotona ghamana bi sawara tupadi sigwagwarida na siniberodi, ware metagha kau kwabuve rei tupadi yakamkovidi na naboni.” ");
INSERT INTO aui_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Bi noko raghanine na Jipo natuna Balak, touna Moab kana kiiwawo kiiravine, na sawariyonayona iviporadi da Beo natuna Balam biidi, touna yana kubura wadubove Petone iyamakamake Euprate rarimina ririne. Na Balak wara idaru iwoneni da iyapiika touna biidi na iwona bo, “Dam tana Ijiptma ipiika. Toudi kubura tupana sakabikabimumu bi ririguve samakamake. ");
INSERT INTO aui_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Bi sivimaragata kirakii getagu naboni, na piika kiiraviguve kunimagidi. Memeda noko murine na rubana anageiwayidi da anarukwavina yagu kubura sinakanibutaveni. Akovi da raghanina wawaya kwiimiiseyeni, na wiimiiseyana yakabi bi raghanina wawaya kwimagi, na noko wawayina yakabikwarakwara.” ");
INSERT INTO aui_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Na Moab da Midiyan babada sitouya, na imaga kana wiimiisana manena sikawari da Balam siyavereni da Isrel iyimagidi. Raghanina sipiika Balam biidi, na Balak metagha ivisisiyana siwonavereni. ");
INSERT INTO aui_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Wasina bi Balam iwonedi bo, “Kata nubabasuve mma yawata tanakena, bi maram yagu wonabodeyana metagha Yawe God inaveregu na anawonemi.” Na Moab babada nama Balam yawata simake. ");
INSERT INTO aui_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Bi God ipiika Balam biidi iwona bo, “Noko awaki wawayidi tam yawata komakamake?” ");
INSERT INTO aui_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Na Balam iwona bo, “Jipo natuna Balak, Moab damdi yadi kiiwawo wara idaru tagu biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Kuwaiyana, dam tana Ijiptma sipiika. Toudi kubura tupana sakabikabimumu na piika da kiiraviguve kunimagidi. Memeda noko murine na rubana da anagogona kuridi da anarukwavinidi.’” ");
INSERT INTO aui_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Bi gegha da God, Balam iwoneni bo, “Geyawata konanona. Bi gegha Isrel damdi kunimagidina, basuna toudi nada wiimiiseyana sikabi.” ");
INSERT INTO aui_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Bi raghani ibori na Balam igeghomiiri da Balak yana sawariyonayona iwonedi bo, “Yawe God geiyiwaghasinegu da yawata tananaghona, na koveramagha yami kubure.” ");
INSERT INTO aui_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Na Moab babada siveramagha Balak biidi bi siwoneni bo, “Balam isinighii na geyawata kayapiikana.” ");
INSERT INTO aui_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Na Balam didibare igeghomiiri da yana donki ikabununayi bi Moab babada yawata sinanagho Balak biidi. ");
INSERT INTO aui_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Bi gegha da, God nuwanuwana ipughu Balam biidi basuna touna nokodi babada yawata sinagho, na Yawe God yana aneya Balam yana keda imiiriboda ware aviya naboni. Balam na yana donki debane iyamakamake bi yana wiitamatamariyana tomotomogha yadi bata yawata siyanono. ");
INSERT INTO aui_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Bi raghanina donki, Yawe God yana aneya ere serina keda basune ikita iyamiimiiri, na kedama ivituirana irughu kwabuve. Bi Balam yana donki irouvi bi ibera da iyiveramayi kedae. ");
INSERT INTO aui_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Wasina bi Yawe God yana aneya wain kwabudi yadi bata basudiye keda gidorona imiiriboda, bi nawana da nawana na papa akimama sibera. ");
INSERT INTO aui_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Raghanina donki, Yawe God yana aneya ikitana, papae iviriya da Balam kayena iwasiraturatu. Na Balam, donkina iroumayeni. ");
INSERT INTO aui_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Bi Yawe God yana aneya ivinagho da taraboga gisina imiiriboda, bi getana taraboga meme da wiikasiwamira katakatiiye bo dugedugeye. ");
INSERT INTO aui_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Raghanina donki, Yawe God yana aneya ikitana, Balam rogune ikenayowogha. Na Balam nuwanuwana ipughu na yana dighonama irouvi. ");
INSERT INTO aui_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Wasina bi Yawe God, donki kawana ikimotatari na Balam iwoneni bo, “Tagu getana awaki berona ayabera tam biidi, bi awaki kiiravine na kurouvigu da raghani aroba?” ");
INSERT INTO aui_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Na Balam iwona bo, “Tagu kuberagu da wawaya matadiye na naboni ware neghanegha. Tagu akayovena kirakiiyeni da memeda seri ayakabi imaguve, na kata ayagwarunuyim!” ");
INSERT INTO aui_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Wasina bi donki iwona bo, “Taguna yam donki, bi raghani nonowa debaguve kwageru bi kwawagawaga. Bi naghove, naboni abera tam biidi, ware kata abera na naboni, bo gegha?” Na Balam iwona bo, “Gegha, getana naboni kuyaberana.” ");
INSERT INTO aui_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Wasina bi Yawe God, ibera da Balam ikitarunagha da aneya ikita keda basune iyamiimiiri bi imanena seri iyakabikabitawani. Na Balam ipepeta da mayiyina iyowogha dobodobove. ");
INSERT INTO aui_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Na Yawe God yana aneya iwona bo, “Awaki biidi yam donki kurouvi da raghani aroba? Kuwaiyana, mmko yam wagawagana mataguvena ibero kiirakii, na apiika da aniaviyem. ");
INSERT INTO aui_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Bi yam donki ikitaguna raghani aroba naghoguve ivikasirana. Bi memeda noko geiyaberana, wiisuwona tagu ayakasunuyim, bi touna iyayawa.” ");
INSERT INTO aui_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Wasina bi Balam, Yawe God yana aneya iwonabodeni bo, “Tagu bera berona abera, geayakovi da tam keda basune kuyamiimiiri wiiaviyegu kiiravine. Noko biidi memeda mmko yagu wagawagana matamve inabero na kata anaveramagha.” ");
INSERT INTO aui_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Yawe God yana aneya iwona bo, “Mmkodi tomotomogha yawata konagho, bi awaki anawonemna toudi kawagha kisisiya.” Wasina bi Balam, na Balak yana babada yawata siveramagha sinagho Moab kubure. ");
INSERT INTO aui_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Wasina bi Balam mmko warana ivisisiyeni: “Balak, Jipo natuna, piika da yagu sisiya kunawaiyana wiimasi. ");
INSERT INTO aui_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God touna gegha wawaya wotana, gemeyani iyiyabana. Bi touna gemeyani yananoghota iyawamiwamirina, naboni wawaya saberaberana. Bi nonowa yabera da awaki yawoneni na inabera. Raghanina yisuwona da awaki berana inabera, na naboni yatubugha. ");
INSERT INTO aui_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Tagu iwonegu da mmkodi wawaya animiiseyedi. Touna ivimiiseyedi, na gerubana noko wiimiiseyanina anawamirina. ");
INSERT INTO aui_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yawe yadi God na gwabidiye, Toudi rukwatuma sakabepepa da touna na yadi kiiwawo, Bi piropiro bo nuwapoya ghamadi gegha inapiikedi Jeikap nosinosina biiyadi, toudi na Isrel damdi. ");
INSERT INTO aui_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God, Ijipt kuburama ikabikanibuvedi, bi yana maragata na ware garagara kau makina naboni geananamanina. ");
INSERT INTO aui_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Wawaya gerubana dam Isrel sinimagidina toudi kate gerubana imapuma siniberodina. Kata na wawaya, Jeikap nosinosina sinisisiyedi, toudi na Isrel damdi: ‘Kokita awaki beradi ghamaghamadi God ibera yana wawaya kiiravidiye!’ ");
INSERT INTO aui_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Bi Isrel damdi na ware laiyon naboni maragasina Yageghomiiri da kana aviya yunugha yakam bi ganiganidi yaniuna. Murine na yakena yowogha da yiyawiitaveyana!” ");
INSERT INTO aui_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“God iviyevevegu da wawaya tana kate murigha inapiika, tagu akitani, bi gekatota iyapiipiikana. Bi kiiwawo tana inapiika, naboni kewokewo, Jeikap nosinosina, toudi na Isrel damdi kamodima. Touna, Moab damdi mayitepadi inarouwa bi Set damdi deudeudi inagawowora. ");
INSERT INTO aui_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Bi kana aviya, Idom damdi inageiwayidi, da yadi kubura inakabi, na dam Isrel inimaragata kamokamogha. ");
INSERT INTO aui_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Wiinaghowana tana Jeikap nosinosina kamodima inapiika bi Moab damdi toudi Ir kwanatune patana samakamake na iniberodi.” ");
INSERT INTO aui_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Raghanina Isrel damdi Sitimne siyamakamake, na tomogha sidagu wiimumurana beradi siyaberabera Moab wasiwasike yawata. ");
INSERT INTO aui_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Wasina bi mmkodi wasiwasikedi, tomotomogha siviyonedi da yadi god siyasuwasuwaridi, na Isrel tomotomogha, Moab wasiwasike yawata sikam da yadi god sipepetedi. ");
INSERT INTO aui_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Mmko kedane dam Isrel, Moab damdi sivirukapuvedi da Baal-Peo sipepeteni, na Yawe God nuwanuwana ipughu kirakii na gubaga bero kirakiina ivipora Isrel biiyadi. ");
INSERT INTO aui_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Wasina bi Yawe God, Mosis iwoneni bo, “Wawaya kadi wiinaghowana kabidi, da naghoguve bi gabudare koroto matadiye kikasunughana da Isrel damdi biiyadi genuwanuwagu inapughu maghana.” ");
INSERT INTO aui_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Na Mosis dam Isrel kadi babada iwonedi bo, “Tami tatadigegha, tomotomogha iiyawogha yami wiibadana rogune bi sivirukapuwana da Baal-Peo siyapeepeteni na kovikasunughana.” ");
INSERT INTO aui_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Wasina bi Mosis da dam Isrel na Kiregoru Kabikabikuwayina matamketana naghone siyiduduwana, bi matadiye Isrel tomogha, Midiyan wasike irutayini ipiika yana rakaraka biiyadi. ");
INSERT INTO aui_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Raghanina Eron tubuna, bi Eliesa natuna Piniyas touna na prist, mmko ikitana igeghomiiri da koroto ikuyoveni, bi imane iyo ikabi ");
INSERT INTO aui_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","da Isrel tomogha ikivini irughu yana kiregoru kamone. Piniyas noko iyonama tomogha igwari da iyona ivikukupaghopagho inagho wasike kamokamone irughu na sirabobo. Noko raghanine gubaga bero kirakiina Yawe God ivipora Isrel damdi biiyadi na ikovi. ");
INSERT INTO aui_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Bi gegha da noko gubaginama na wawaya yadi 24,000 nada sirabobo. ");
INSERT INTO aui_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Wasina bi Yawe God, Mosis iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Eron tubuna, Piniyas touna na prist yana berama iviyeveveyana da yana noghota tagu naboni, bi geiyiwaghasina da wawaya, god mududi siyapepetedina, wasina tagu kawagha. Nuwanuwagu ipughu Isrel damdi biiyadi bi ayanoghonoghota da ayiberodi, bi gegha da noko naboni na Piniyas yagu nuwapughu ivikovini da gegha aniberodina. ");
INSERT INTO aui_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Na Piniyas kuwoneni da tagu wiiwaghasinina maragasina touna biidi aberabera, da yagu nuwaruriri averevereni. ");
INSERT INTO aui_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Touna ikayovena kirakiiyeni da kagu waghawagha ghamana iyitarababaraneni, na Isrel damdi yadi tamumu ikoghataveni, noko biidi. Tagu wiiwaghasina maragasina aberabera touna da nosinosina biiyadi. Da toudi na yagu prist raghani nonowa.” ");
INSERT INTO aui_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Na Yawe God, Mosis iwoneni bo, “Kanumigu na Nun natuna, Josuwa gwabine na kabi bi imam gayamina debane kutore. ");
INSERT INTO aui_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Bi Eliesa, touna na prist da kate wawaya tupana naghodiye kubera da Josuwa inamiiri bi matadiye karadeba da touna wawaya ininaghovedi naboni kam tupataveyana. ");
INSERT INTO aui_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Bi yam wiibadana muduna kuvereni da Isrel damdi gamona sinakabisisireni. ");
INSERT INTO aui_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Bi Eliesa, touna na prist naghone inamiiri bi kiiravine na Eliesa inibabiigu da yagu nuwagiura Urimve inakabi. Bi yana sisiye, na Josuwa da dam Isrel tupadi sinakanibu bi yana sisiyama na sinaveramagha.” ");
INSERT INTO aui_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Na Mosis ibera da metagha Yawe God iwoneni na naboni. Josuwa ikabi bi Eliesa da dam Isrel naghodiye ikabiwiimiiri. ");
INSERT INTO aui_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Bi Mosis imana Josuwa gayamine itoura bi ikaradeba da wawaya ininaghovedi, metagha Yawe God iwoneni na naboni. ");
INSERT INTO aui_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Raghanina dam Isrel, Moab ruwiipikapikane, Jodan rarimina ririne sivitaki siyamakamake, bi nawane na Jeriko. Noko raghanine, Yawe God, Mosis iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Isrel damdi mmko sisiyina kuwonedi, ‘Raghanina Jodan rarimina konatowawoneni bi konarughu Kenen kubure, ");
INSERT INTO aui_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","na iiyawogha kata nama noko kuburine samakamake na kurukwavina sinakanibu. Yadi god akimama tarakatukatuyidi da yadi kabepepa sawaridi kovikourikeyana. ");
INSERT INTO aui_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Tagu noko kuburina averemi na kokabi kiiravimiye da kamone konamakae. ");
INSERT INTO aui_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Isrel kamone damve damve kuburina kokabirerei metagha aviyevevemina naboni. Kubura ghamana, dam ghamana kovereni bi kubura gisina, dam gisina kovereni. Nosinosiminakim kadi dam nunudigha kokabireregha. Bi gegha da akima kabikabikuwayidima wiirekwa aviyevevemi dam nunudigha kiiravidiye, na naboni yadi kubura sinayouna. ");
INSERT INTO aui_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Bi meboda wawaya iiyawogha noko kuburine kata samakamakena gekonarukwavinidi, bi kwiiwaghasinedi sinamake na nuwapoya ghamadi sinaveremi, toudi na ware mugumugu matam kamone bo ware modi ririwamve, bi siniaviyemi. ");
INSERT INTO aui_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Bi meboda gekona rukwavina sinakanibu na tagu aro anaveremi, kedana mayimayiyina ayanoghonoghosi da aro ayaveredina.’” ");
INSERT INTO aui_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Wasina bi Yawe God, Mosis iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Isrel damdi kuwonedi, ‘Raghanina Jodan rarimina konatowawoneni bi konarughu Kenen kubure, ");
INSERT INTO aui_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","na kwanatu mududi kovinegha da wawaya babaredi kiiravine. Bi meboda tomogha tana geiyanuwagiura da kasunugha bi wawaya tana ikasunuyi na inavera inanagho noko kwanatune na inayawa. ");
INSERT INTO aui_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Bi memeda wawaya raborabobona yana rakaraka sinakayoveni biwa kabina, bi kasunugha wawayina inavera inanagho babara kwanatune, na gerubana yaininagha sinakasunuyina. Dagudagune na wawaya tupadi matadiye bi wiitupawamiwamira wawayina naghone inamiiri.’” ");
INSERT INTO aui_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Wasina bi Mosis, dam Isrel iwonedi bo, “Gwara tupadi kokabisisiredi mekodi awonewonemina, da konamake bi konarughu da kubura meko Yawe, nosinosiminakim yadi God yavereveremina, da konakabi kiiravimiye. ");
INSERT INTO aui_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Bi Yawe yami God yana gwara awonemi na gegha gwara mududi woudima koniagagudina, bi kate gegha gwarana mududi konakabi tavetaveyanana, wasina kokabisisirena wosidi. ");
INSERT INTO aui_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Mmkodi gwara kokabisisirena yaporidi da dam mududi yami nuwagiura bi yami akowa sinakita. Raghanina mmkodi gwara tupadi siwaiyanedi na sinawona bo, ‘Wiisuwona Isrel na dam maragasina bi kana wawaya na nuwanuwagiuridi da akakovidi!’ ");
INSERT INTO aui_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Yawe yada God na riridae bi yiwiiteda raghanina tarupari touna biidina. Bi dam mududi, ghamaghamadi bo gisigisidi god noko naboni gegwabidiyena. ");
INSERT INTO aui_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Mmkodi gwara tupadi kata awonewonemi na rotomanidi bi miisedi, getana dam mududi ghamaghamadi bo gisigisidi, gwara rotomanidi mmkodi naboni gwabidiyena. ");
INSERT INTO aui_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","34","Raghanina maragata ghamanama bi Yawe yami God, Ijiptma ikabikanibuvemi, na berakayowiiwiiyaka da bera ghamanakidi matamiye ibera. Tami kiiravimiye na Ijipt damdi iviaviyedi, da kabikwarakwara ghamana iveredi. Bi iberami da yana wawaya waghata, bi Sainai Koyane keyama kamonama kowaiyana ivisisiya tami biiyadi, bi gegha da patana komakamake. Bi bera tana mmko naboni naghove itubugha bo gegha? Getana! Konoghota inaveramagha da ghuyoghuyone raghanina God kubura debane wawaya iberadina, kubura tupane kovinogha. Getana god meme mmkodi bera naboni iyaberana! ");
INSERT INTO aui_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Kata kovigeruwana bi konakowa yapori da Yawe na God, abama kamone bi kubura debane, getana god meme. ");
INSERT INTO aui_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Yana gwara tupadi kokabibisisiredi mekodi kata avereveremina. Wasina bi tami da nosinosimi makamake miisena konabanani, bi raghani gurina kuburine konamakae meko Yawe yami God yaverevere waghasimina.” ");
INSERT INTO aui_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Wasina bi Mosis iwona bo, “Dam Isrel, kowaiyana! Yawe yada God, na touna kawagha God. ");
INSERT INTO aui_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Bi Yawe yami God, nuwanuwami tupana, kanumimi tupana da yami maragata tupanama koninuwayuyuneni. ");
INSERT INTO aui_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Mmkodi gwara kata awonewonemina na yami noghota kamone kokabitawana yaporidi. ");
INSERT INTO aui_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Mmkodi gwara natunatumi koviyevevedi. Raghanina yami bareye komakamakena, kedae kopeepewana bo nubabasuve kokenakena yowoghana da kate raghani diidibare kogeghomiiri na konisisiyana.” ");
INSERT INTO aui_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Wasina bi Mosis, Isrel damdi iwonedi bo, “Raghanina Yawe yami God inakabimi konarughu meko kuburina konakabi konirapeneni, na naghomiye dam yadi 7 inarukwavina sinakanibu: Damdi na mmakatanidi dam Hitti, Gegasi, Amori, Kenen, Periji, Hivi da dam Jebusi. Nokodi dam na ghamadi bi maragasidi getami naboni. ");
INSERT INTO aui_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Yawe yami God nokodi dam yami maragate inatoredi bi raghanina konageiwayidi, na kovikasunughana. Gegha konakayowiiyayedi da sinamakena. Gewiiwaghasina yawata konabera da koniwiita kabiviviranana da nuwaruririye konamakae. ");
INSERT INTO aui_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Geyawata koninayi kabivivirana, bi genatunatumi wasiwasike koniwaghasinedi da natunatudi tomotomogha sinarawayidina, bo natunatumi tomotomogha, natunatudi wasiwasike sinarawayidina. ");
INSERT INTO aui_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Bi memeda tami naboni konabera na nokodi dam sinageghomiiri da natunatumi sinatainawamiridi da kivinigu sinakabitore bi god mududi sinakabepepidi. Na Yawe God nuwanuwana inapughu kirakii na yaininagha iniberotuwanonoyimi. ");
INSERT INTO aui_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Mmko na awaki kunabera toudi biiyadi: Yadi suwara gabugabuna gawaridi kiberodi, yadi akima kabikabikuwayidi madasorudi kugawowora, yadi god wasikena Asera kabepepina kiitupodi kitaragiiyana da yadi tarabiibiisaka tarakatukatuyidi keyame kugibu. ");
INSERT INTO aui_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Mmkodi beradi kunaberana basuna Yawe yami God itoreiremi touna wosina kiiravine. Dam tupadi kubura debane kamodima na Yawe God tami ivineyimi da yana wawaya. Tami na touna rapene. ");
INSERT INTO aui_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Yawe God ivinuwayuyunemi na ivineyimi, bi ivineyimi na gegha tami yami koroto iyaragatana kiiravine bi dam mududina gegha. Wiisuwona da kami dam na igisi kirakii genaboni dam mududi kubura debanena! ");
INSERT INTO aui_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Yawe God ivinuwayuyunemi bi ikayoveni na wiisuwona maragasina ibera nosinosiminakim biiyadi na naboni inabera. Noko kiiravine yana maragata ghamanama bi Ijipt kuburama ikabikanibuvemi. Bi wiibagubagurana gawarinama iviyawiimi, Ijipt kana kiiwawo yana wiibadana rogune. ");
INSERT INTO aui_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Na kwakowa yapori da Yawe yami God na God waghata, touna nonowa awaki yawoneni na naboni yabera. Wawaya iiyawogha sininuwayuyuneni da yana sisiya sinakabisisireni, na ininuwayuyunena kirakiiyedi bi metagha ivisuwona na naboni miisena yabera, da kimta 1,000 kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Bi gegha da iiyawogha gesiyakabikabisisireni na aro yaveredi da yiberotuwanonoyidi. Iiyawogha sasinighiiyeni na yaininagha aro yaveredi. ");
INSERT INTO aui_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Na noko biidi kokoyagha yaporimi da kata mmkodi gwara da wiiyeveveyana tupadi mekodi awonewonemina kokabisisiredi.” ");
INSERT INTO aui_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Wasina bi Mosis, Isrel damdi iwonedi bo, “Konoghosi da metagha Yawe God vikodi bodudi 40 kamodiye ivinaghovemi mayabe kopepewa. Bi genuwanuwami sinawapa da metagha piropiro iveremi da yana sisiya koyakabisisireni, bi nokodi piropiroma na irubumi. Ikayoveni da yami noghota iyakita bi kate akowa iyakabi da memeda yana gwara konakabisisireni bo gegha. ");
INSERT INTO aui_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Na ibera da vitonana korabobo da yana sisiya koyakabisisiredi, bi muriye na mana iveremi da koyakani. Tami da nosinosiminakim noko kamna gemeyani naghove koyakamtowoyina. Mmkona wiiyeveveyana ibera da kam kawagha na gerubana wawaya inayawana. Wawaya yawa inakayoveni na awaki sisiyidi tupadi Yawe God kawanama sakanikanibu na toudi kawagha inakabisisiredi. ");
INSERT INTO aui_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Raghanina kam konamoureni da konakamkam bi bare miisedi konayoghana, ");
INSERT INTO aui_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","bi yami kau, sip da gout sinapeyapeyara, bi konamoumoura da yami sawara sinapeyara, ");
INSERT INTO aui_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","na kokita wiimasi da gekona toregeegeeyemi da Yawe God koninuwawapina bi kate metagha Ijipt kubure, wiibagubagurana gawarinama ikabikanibuvemina. ");
INSERT INTO aui_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Bi nuwanuwami gesinawapa da touna ivinaghovemi mayaba ghamane bi naghanagharine, meme mota googonidi da gwaghayagwaghaya yawata. Noko kuburina na kanakanana bi gegha ere rariminana. Bi gegha da akima kakokakonama ibera da rarima iwusira ikanibu kiiravimiye, ");
INSERT INTO aui_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","bi kate mana ivikanimi, touna nosinosiminakim naghove gesiyakamtowoyina, bi mmko iberana irubumi da koyakabikuwayeni, bi damone na miisena iyapiikeni tami biiyadi. ");
INSERT INTO aui_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Bi kwakowa wiimasi da genuwanuwamiye konawona bo, ‘Tagu avikiiwawo basuna maragasigu bi abagibagi kirakii.’ ");
INSERT INTO aui_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Yawe yami God konoghosi, touna yana wiiwaghasina maragasina nosinosiminakim teya sibera, na wiiwaghasinina yakabikabitawani, noko biidi maragata iveremi da sawara peyaridi konayouna.” ");
INSERT INTO aui_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Wasina bi Mosis, dam Isrel iwonawiikatayidi bo, “Yawe God gamona konoghosidi bi konuwagiurena nonovedi. Kwasiye kogiruma bi imamiye kwaghira da kate maitepamiye koviyagha naboni matakira. ");
INSERT INTO aui_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Natunatumi koviyevevedi; yami bareye konamakamake na Yawe yana gwara konisisisyedi bo kedae konapeepewana, nubabasuve kena kiiravine bo raghani diidibare kogeghomiirina. ");
INSERT INTO aui_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Kowaiyana! Yami kayowana da Yawe God inimiiseyemi bo aro inaveremi? ");
INSERT INTO aui_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Kata yana gwara avereveremi. Memeda konakabisisiredi na inimiiseyemi. ");
INSERT INTO aui_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Bi memeda yana gwara konasinighiiyedi bi keda iiyevevemi na konamiiri kubutedi, da god mududi konakivinidi mekodi naghove gekoyakivina, na Yawe God aro inaveremi. ");
INSERT INTO aui_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Na kobera yapori bi mmkodi gwara da wonawiiyoyowana kata awonewonemi na konakabisisiredi.” ");
INSERT INTO aui_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Wasina bi Mosis iwona bo, “Yawe God, kubura yavereveremi bi raghanina konapiika noko kuburine na kami aviya konageiwayidi bi yami bare konayoghana da konatourawiipikapika murine, na mma naboni konanuwagiura, ‘Dam turaturada ere yadi kiikiiwawo. Noko biidi na kiiwawo tana kiiravidae tanavineyi.’ ");
INSERT INTO aui_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Yawe God kami dam kamonama tomogha tana inavineyi bi konatore da yami kiiwawo. Gegha tomogha wiibata konavineyina, iiyabo na gedam turamina. ");
INSERT INTO aui_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Bi gegha hosi peyaridi inayouna tounamani kiiravine bo wawaya iniporadi Ijiptma da sinayouna bi sinarutayina sinaveramagha, basuna Yawe God iwona da yana wawaya gemeyani noko kedanagha sinaveramagha Ijiptma. ");
INSERT INTO aui_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Bi kiiwawo genatuwavinena korotodi inayounana. Memeda inabera, na kate nuwanuwana sinatayina wamiri da Yawe God geinakivinina; bi bada moura geinituwiitaghomana. ");
INSERT INTO aui_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Bi raghanina konabera da inikiiwawo, na mmko gwara bukana mayimayiyina tana tounamani kiiravine inagiruma mayeni. Gwara bukana dagudaguna na prist, toudi na dam Livai imadiye. Kiiwawo noko bukana inakabi da inagiruma mayeni. ");
INSERT INTO aui_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Bi yana yawa tupane, na gwabine inamake da nonowa inakabikabiyavi, bi akowa inakabi da Yawe yana God inakabikarawayeni bi mmkodi gwara tupadi inakabisisredi. ");
INSERT INTO aui_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Raghanina mmko inaberana, kate geinatoregeeyena mayeni da yana wawaya inagetawanidina. Bi kate mmkodi gwarama geinamiiri wamira katakatiiye bo dugedugeye bi touna da nosinosina teya raghani gurina Isrel sinibadeni.” ");
INSERT INTO aui_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Mosis kate bada wawaya iwonedi bo, “Raghanina kubura meme Yawe God yavereveremi bi konarughu, na gegha nama dam wiibata yadi kiki beradi bero kirakiidi konigubegubeyana. ");
INSERT INTO aui_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Gemeyani natum tomogha bo wasike suwara gabugabuna keyamine kunagabunina. Bi kate gegha kasiko bogaebogae kunaberana, geimapuma kunawonakasiyaragha raghani murina kiiravine, bo kiirapu da yapunema, bo kuniimagana ");
INSERT INTO aui_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","da kate raborabobodi kanumidi bo kayekiki mekeyudi teya wiisisiya. ");
INSERT INTO aui_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Yawe yami God geyana kayowana wawaya iiyawogha mmkodi bera bero kirakiidi saberaberana. Wawaya noko kuburine samakamake na mmkodi bera saberabera, noko biidi Yawe God pinimina bi inarukwavina, raghanina kuburine konarughurughuna. ");
INSERT INTO aui_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Tami nonowa Yawe yami God konakabisisireni. ");
INSERT INTO aui_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Kubura meko pinimina bi konirapeneni, na wawayidi wonawiipusipusiri imapu damdi da kate wawaya iiyawogha raborabobodi biiyadi sisisiyana gwabidima sakabi, bi Yawe yami God geiyiwaghasina da nokodi damdi yadi kiki beradi konaberana.” ");
INSERT INTO aui_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","“Wasina bi Yawe God, peroveta tana inakabi wiimiiri kiiravimiye tagu mayimayiyigu kami dam kamonama, na kobera da konawaiyaneni. ");
INSERT INTO aui_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Kiiravine mmkona awaki Yawe yami God biidi kovibaba Horebne, Sainai Koyana kayene kovitaghomimi na raghanine, bi kowona bo, ‘Gekunabera da Yawe yama God gamona kanawaiyana bo yana keyama kanakita, geiyamiise da kanarabobo.’ ");
INSERT INTO aui_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Wasina bi Yawe God iwonegu bo, ‘Yadi wiibaba na imiise kirakii. ");
INSERT INTO aui_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Na tagu, peroveta tana anakabi wiimiiri tam naboni nama yadi wawaya kamodima. Bi anawoneni da metagha inisisiya, bi bera tupana inawonedi metagha awoneni da iyisisiyana. ");
INSERT INTO aui_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Bi perovetina waghawaghaguve inadimadima bi wawaya iiyabo gamona geinawaiyaneni na tagu aro anavereni. ");
INSERT INTO aui_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Bi memeda peroveta tana inatoregeeyena mayeni bi awaki geayawoneni da iyisisiya bi inisisiya, bo god mududi waghawaghadiye inisisiya, na konakasunuyi.’” ");
INSERT INTO aui_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Bi Mosis yana sisiya ivikiitayini bo, “Memeda konitarakiiyanena mayemi bo, ‘Metagha tanakovi da yana sisiya na gegha Yawe God gwabinama?’ ");
INSERT INTO aui_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Mmkona metagha konakovi. Raghanina peroveta tana waghawaghaguve inadimadima bi yana sisiya gesinatubughana, na wasina noko sisiyina na getagu gwabigumana. Noko perovetina itoregeeyena mayeni da yana noghotama ivisisiya, na gekonanagharenina.” ");
INSERT INTO aui_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Wasina bi Mosis, Josuwa ikwatuveni ipiika da dam Isrel tupadi naghodiye bi iwoneni bo, “Kimaragata da kitepatora, basuna mmkodi wawaya kuninaghovedi da kubura meko Yawe God wiisuwona maragasina ibera nosinosidinakim iyaveredi na nabo konarughu. Bi kuniwiitedi da kuburina sinakabi sinirapeneni. ");
INSERT INTO aui_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Bi Yawe God touna wosina ininagho naghomve, bi yawata gwabimve; kate gemeyani inakuyovem bo inakayosinighiiyemna. Gegha kunanaghara bo kuninuwapoyana.” ");
INSERT INTO aui_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Wasina bi Mosis, Moab ruwiipikapikanama itouya inagho da Nebo Koyana iyaghiini bi igekamokamogha da igekawaruwana koyapokona sakwatuveni Pisga, bi nawane na Jeriko kwanatuna. Bi Yawe God kuburina tupana iviyeveveni; Giliyed kubura da inagho Dan kwanatune, ");
INSERT INTO aui_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","Neptalai kubura tupana, Ifreim da Manasa kuburidi, Jiuda kubura tupana, bi inagho da Mediteriyen Yegiine. ");
INSERT INTO aui_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Yawe God kate bada Mosis, mayaba kubura kana waghawagha Negeb iviyeveveni, Jodan viririna, bi yawata na Jeriko (kana waghawagha tana na notuveya kwanatuna), bi ikitarorona inagho da Jor kwanatune. ");
INSERT INTO aui_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Wasina bi Yawe God, Mosis iwoneni bo, “Kuburina mmakatanina, noko kiiravine wiisuwona maragasina abera Abraham, Aisik da Jeikap biiyadi awona bo, ‘Nosinosimi anaveredi.’ Tagu aviwaghasinem da matamma kuburina kukita, bi gegha da gekunarughu kamonena.” ");
INSERT INTO aui_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","9","Wasina bi muriye na Mosis, imana Nun natuna Josuwa gayamine itoura bi ikaradeba da touna na wiinaghowana, na God nuwagiura ghamana Josuwa ivereni na dam Isrel sikabisisireni. Bi bera tupadi siyaberabera metagha Yawe God, Mosis iwonenina naboni. Bi Yawe God yana wiitamariyana Mosis nama Moab kubura kamone irabobo metagha Yawe God ivisisiya naboni. ");
INSERT INTO aui_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Raghanina Mosis yana yawa tupane iyamakamake na Yawe God iyabigebigeni bi Nun natuna Josuwa na iyiwiiteni. Bi irabobo murine na Yawe God, Josuwa iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Mosis yagu wiitamariyana na irabobo. Na noko biidi kabunagha, bi tam da dam Isrel tupana Jodan rarimina konatowawoneni konarughu kubura avereveredina. ");
INSERT INTO aui_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Tagu, kubura tupadi meme debadiye kayemi konitutughana anaveremi, metagha Mosis avisuwoneni na naboni. ");
INSERT INTO aui_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Yami kubura na Negeb mayabine inadagu bi inanagho da Lebinon koyadiye kikiramutumutuba yana nawae, bi raghani matene Euprate rarimine inadagu bi inanagho da dam Hitti yadi kubura tupana patana da inanagho Mediteriyen Yegiine, gabudara yowoyinama. ");
INSERT INTO aui_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Josuwa, yam yawa tupane kunamakamake, na getana iiyabo rubana da inageebodem inageeiwayimna, kiiravine tagu na tam gwabimve ware naboni Mosis gwabine na. Gegha meyani anasinighiiyem bo anakuyovemna. ");
INSERT INTO aui_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Tagu yagu wiisuwona maragasina mmkodi wawaya nosinosidinakim biiyadi abera da mmko kuburina ayaveredi. Na kimaragata da kisinitora, bi wawaya kinaghovedi da kuburina konakabi konirapeneni. ");
INSERT INTO aui_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Noko biidi kimaragata bi kisinitora kirakii, bi kayowiimasi da mmkodi wonawiiyoyowana tupadi yagu wiitamariyana Mosis iveremna kunakabisisiredi. Bi yagu wonawiiyoyowana kunakivina yapora da gegwabidima kunituirana katakatiiye bo dugedugeye na tam bera tupana kunabera na wasina kawakawa. ");
INSERT INTO aui_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Kubera wiimasi da mmko gwara bukana nonowa konakabiyavi. Gabudare da nubabasuve nonowa akovina kunakabikabi na girumina akovina kunakabisisirena wiimasiyeni. Memeda naboni kunamake, na tam awaki kunaberabera na wasina kawakawa.” ");
INSERT INTO aui_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Dam Isrel, Jeriko ruwiipikapikane kubura kana waghawagha Gilgalne sivitaki siyamakamake raghanine, nawaravi dagudaguna bi gabudara 14 ravidine na Koughanu porayina sibera. ");
INSERT INTO aui_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Bi Koughanu porayina ikovi murine bi raghani ibori na wit peidi sisabeda bi parawa gegha yist teya sigibu bi sikam. Nokona kabipura kamna noko kuburinama da sikam. ");
INSERT INTO aui_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Noko gabudarine, kam noko kuburinama sikam ikovi murine, na getana mana siyarumaghatarana. Na dam Isrel getana mana siyakam maghana, wasina noko gabudarine inagho na Kenen kubura kamna siyakanikani. ");
INSERT INTO aui_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Wasina bi muriye na Josuwa, Isrel dogadogara tupadi damvedamve iwonedi da Sikem kwanatune siyitaghomidi. Raghanina name sivitaghomidi na Josuwa, dogadogara, wiinaghowana, wiitupawamiwamira da babada ikwatuvedi sipiika da God naghone siyamiiri. ");
INSERT INTO aui_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Bi Josuwa, wawaya tupadi iwonedi bo, “Yawe God, dam Isrel yadi God iwona bo, ‘Naghove waghata kayekikimi Tera da natunatuna Abraham da Naho, Euprate rarimina nawane siyamakamake, bi god mududi siyapeepetedi. ");
INSERT INTO aui_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Bi gegha da nosiminaki Abraham noko kuburinama akabi da avinaghokedari da Kenen kuburina tupana kaverarughuwoneni. Bi natuna Aisik gwabinama na nosinosina korotodi avereni. ");
INSERT INTO aui_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Kubura ere kwabudi averemi, meme getami koyawawana bi kate kwanatu getami koyayoghana na averemi, kwanatudi meme kata komakamakena. Bi greip da oliv uwadi kokamkam, bi nokodi uravidi da kiidi getami koyawawana.’” ");
INSERT INTO aui_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Wasina bi Josuwa, Isrel damdi iwonena mayedi bo, “Noko biidi Yawe God kokabisisireni da nuwanuwami tupanama kobagibagiyeni. Tarabiibiisaka mekodi kayekikimi siyapeepetedina, raghanina Euprate rarimina nawane siyamakamake da kate Ijiptne na kovitavetaveyana, bi Yawe God kawagha konabagibagiyeni. ");
INSERT INTO aui_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Bi memeda Yawe God bigenina konasinighiiyeni, na kata konivinevinegha da meko godna konabigeni, nokodi Eupratene kayekikimi sibigedina bo nokodi god, Amori damdi sibigedina, bi kata yadi kubure komakamakena. Bi tagu da yagu rakaraka yawata, na Yawe God kana bagibagiyeni.” ");
INSERT INTO aui_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Wasina bi wawaya siwona bo, “Toumii gemeyani Yawe God kanakuyoveni bi god mududi kanabigedina. ");
INSERT INTO aui_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Kiiravine Yawe yada God, na touna kayekikida iviyawiidi da kate touda teya, raghanine Ijipt kubure tayibagubaguranana. Bi berakayowiiwiiyaka maragasidi matadaye ibera, bi kate raghanina mayabe kada aviya kamodiye tayapeepewana ikoyayida. ");
INSERT INTO aui_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Bi dam Amori da dam mududi mmko kuburine siyamakamake bi kiiravidaye na irukwavina sikanibu. Noko biidi na toumii teya, Yawe God kanabigeni, kiiravine touna kawagha na yada God.” ");
INSERT INTO aui_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Josuwa iyamakamake gabudaridiye na Isrel damdi Yawe God siyabigebigeni, bi irabobo murine na bada wawaya, Yawe God sibigena wiikaruveni patana da Isrel kanababada yawayawiidi siyamakamakena, iiyawogha Yawe God yana berabera Isrel damdi kiiravidiye ibera sikitana. ");
INSERT INTO aui_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Yawe God yana wiitamariyana Josuwa, Nun natuna na kanabodu 110 bi irabobo. ");
INSERT INTO aui_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Na yana wawaya, kubura kana waghawagha Timnat Heresne tanawa ivirapenenina name sidogu, dam Ifreim yadi kubure koyae, Gaas Koyane kikiramutumutuba yana nawae. ");
INSERT INTO aui_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Noko kimtana tupana sirabobo murine, na bada kimta tana itubugha na Yawe God gesiyakovina bo Isrel damdi kiiravidiye awaki iberana. ");
INSERT INTO aui_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Na toudi Yawe God matane bera berona sibera da Baal yana tarabiibiisaka siyapeepetedi. ");
INSERT INTO aui_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Toudi tamadinakim yadi God, Yawe God sisinighiiyeni, iiyabo Ijipt kuburama ikabikanibuvedi, bi sidagu wawaya wiibata iiyawogha nama riridiye siyamakamake na yadi god siyapeepetedi, na Yawe God sivinuwapughupughuni ");
INSERT INTO aui_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","basuna toudi Yawe God sisinighiiyeni bi Baal da Astoret siyapeepetedi. ");
INSERT INTO aui_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Na Yawe God yana nuwapughu iragata kirakii Isrel damdi biiyadi bi ibera na wiikayotaketowana damdi sigeghomiiri da Isrel damdi tupeyanama siyapiyedi bi aviya damdi nama riridiye iviruveredi da gerubana siyageebodedi. ");
INSERT INTO aui_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Raghanina Isrel damdi sanagho wiiaviya biidi, na Yawe God geiyiwiitedi da kadi aviya sinageeiwayidi. Touna iwonawiikatayidi da metagha ivisuwona na ibera. Na Isrel damdi nuwapoya ghamana sikabi. ");
INSERT INTO aui_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Wasina bi Yawe God babada ikabiwiimiiridi da Isrel damdi siyiyawiidi iiyawogha siyayapiyapiyedi na gwabidima. ");
INSERT INTO aui_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Bi gegha, Isrel damdi babadidi gesiyawaiyanedi da Yawe God kawagha siyapepeteni, bi gegha da bada god wiibata sikirorovedi da sipepetedi. Toudi yaininagha nosidinakim yadi kedama simiiri irana da Yawe God gesiyakabisisireni. ");
INSERT INTO aui_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Raghanina Yawe God, bada tana Isrel damdi yaveredi bi noko badana yana make yawana kamone na God wawaya iyiwiitedi da kadi aviya siyiaviyedina gwabidima yiwiitedi. Basuna Isrel damdi yadi kabikwarakwara da wiikayotaketowana kamodima siyakabikabida kiiravidiye na Yawe God iyinuwanuwaghanedi. ");
INSERT INTO aui_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Bi raghanina noko badana yarabobo na wawaya, Yawe God samiiri kubuteni da saveramagha yadi yawa katamanidiye bi bera bero kirakiidi sabera geware kimta katamanidi naboni, da god mududi sakivikivina bi sabigebigedi da sapeepetedi. Toudi geyadiwiina da bera beroberodi da kotakii beradi sinakabitourana. ");
INSERT INTO aui_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Name na tomogha tana kana waghawagha Elkana, dam Ifreim kamonama bi Rama kwanatune iyamakamake Ifreim yadi koyakoya kubure. Touna Jeroham natuna bi Elihu tubuna bi Tohu yana rakaraka, Jup kana dam muduna. ");
INSERT INTO aui_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elkana natuwavinena yadi bata, Hana da Penina. Penina ivituwa ere natunatuna bi Hana na gegha. ");
INSERT INTO aui_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Bodu nunudigha na yana kuburama iyatutuya iyananono Sailoma da Yawe God Maragata Kirakiina biidi iyakabikuwaya da iyasuwara. Bi name na Eli natunatuna yadi bata, Hopni da Piniyas na Yawe yana prist. ");
INSERT INTO aui_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Raghanina Elkana yapiika suwara puyodi kiiravine, na iyuwa taridi rereyina tana wavinena Penina yavereni da kate bada natunatuna yaveredi. ");
INSERT INTO aui_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Bi gegha da bagune Yawe God, Hana yana wiituwa kedana igudu. Elkana, Hana ivinuwayuyunena kirakiiyeni na kana reregha iyuwa taridi waratetena bada iyaverevereni. ");
INSERT INTO aui_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Orananaki Penina, Hana nonowa na wiinamaghama iyisisiya beroveni basuna Yawe God ivigagari da geiyituwana. ");
INSERT INTO aui_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Bodu patepatena mmko berana iyatubutubugha; raghanina sanagho Yawe God yana bareye, na Penina nonowa Hana yimarumaruveni na yinuwapoya kirakii da yadou na kam yasinighii. ");
INSERT INTO aui_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Na moghanena Elkana iyitarakiiyaneni bo, “Hana, awaki kiiravine kwaduudu da geyamkayowana kam? Bi awaki biiyadi nuwanuwam ibero kirakii? Wiisuwona tagu ware natunatum tomotomoyidi yadi 10 naboni tam biidi!” ");
INSERT INTO aui_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Gabudara tana, Sailone Yawe God yana bareye sikam da siniuna ikovi murine, na Hana igeghomiiri bi inagho da iyarupari. Noko raghanine Eli touna prist na yana gawara God yana bare kamone matamketa ririne iyamakamake. ");
INSERT INTO aui_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Hana ivinuwapoya kirakii da ere duuduna bi Yawe God biidi iyarurupari. ");
INSERT INTO aui_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Na ruparima ivisuwona iwona bo, “O Yawe God Maragata Kirakiim, kitagu, tagu yam wiitamariyana! Yagu nuwapoya kita bi kunoghosigu! Gekuninuwawapiguna! Bi memeda natugu tomogha kunaveregu, na iisuwona da anatoreireni tam kiiravimve yana yawa tupane bi gemeyani gayamina inaborina.” ");
INSERT INTO aui_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Hana naboni iyarurupari wiiguriguri na Eli kawana iyaruruwiitete. ");
INSERT INTO aui_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Touna nuwanuwana kamone iyisisiya na Eli gamona geiyawaiwaiyanenina, bi giburu kawanagha siyidagudagu. Noko kiiravine inoghosi da ware Hana iyaniuna neghanegha. ");
INSERT INTO aui_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Na ikini iwoneni bo, “Awaki kiiravine kunina neghanegha? Yam niuna kabitore bi kimaragata!” ");
INSERT INTO aui_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Bi Hana iwonabodeyana bo, “Gegha bada, tagu gegha ayaniuna neghaneghana, tagu nuwanuwagu ivisikirakii na yagu nuwapoya ayakarakaraiwayi Yawe God biidi. ");
INSERT INTO aui_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Bi mma naboni arurupari basuna avinuwapoya kirakii, na gegha kunanoghosi da tagu wasike berogu.” ");
INSERT INTO aui_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Na Eli iwonabodeni bo, “Nuwaruririye kunagho! Bi Isrel kana God gwabinama awaki kiiravine kwiibaba na inaverem.” ");
INSERT INTO aui_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Na Hana iwona bo, “Avikiikiivem bada, bi kunoghota wiimasiyegu.” Wasina bi inagho ikam bi gemuriye iyinuwapoya maghana. ");
INSERT INTO aui_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Raghani ibori, na Elkana yana rakaraka didibara wote sigeghomiiri da Yawe God sikabepepi bi siveramagha yadi bareye Rama kwanatune. Elkana wavinena teya sikena na Yawe God, Hana yana rupari iwaiyaneni. ");
INSERT INTO aui_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Na wasina Hana iropeya da ivituwa natuna tomogha, bi iviwaghawaghayeni Samwel bi iwona bo, “Touna kiiravine Yawe God avibabiini.” ");
INSERT INTO aui_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Raghanina puyo gabudarina ikabimayeni na, Elkana yana rakaraka yawata tupadi sinagho Sailoma, metagha ivisuwona na naboni da bodu tughurina suwarina siyapuyo Yawe God biidi. ");
INSERT INTO aui_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Bi Hana geiyanagho, na moghanena iwoneni bo, “Tomogha gisigisi wiikaratavenina inakovi murine, na anakabi ananagho Yawe God yana bareye da name yana yawa tupana inamakae.” ");
INSERT INTO aui_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkana iwona bo, “Wasina, awaki kwanoghonoghosi imiise tam biidi na kubera bi kumakae da tomogha gisigisi kunikarataveni, bi Yawe God yana sisiya inabera da inarumaghatara.” Na Hana bareye imakae natuna iyisusu patana da ivikarataveni. ");
INSERT INTO aui_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Samwel sivikarataveni bi murine, na sinananaki ikabi inagho Sailoma, bi siyanono na bull wotuna kana bodu 3, parawa siripuna tana da wain kabikabiwiitaghoma kamone tana sikawara. Touna simira wouna bi sinananaki ikabi sinagho Sailoma, Yawe God yana bareye. ");
INSERT INTO aui_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Bi bull sisuwara ikovi na tomogha gisigisi na sikabi sipiika Eli biidi ");
INSERT INTO aui_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","bi sinananaki iwona bo, “O bada! Iisuwonem da tagu noko wasikena iiyabo rorowayinagha kukitagu Yawe God biidi ayaruruparina. ");
INSERT INTO aui_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Tagu Yawe God avibabiini mmko simirina kiiravine na yagu wiibaba iveregu. ");
INSERT INTO aui_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Na kata Yawe God averevereni, yana yawa tupana na Yawe God inabigeni.” Wasina bi Yawe God nama sikabepepi. ");
INSERT INTO aui_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Wasina bi Hana ruparima iwona bo, “Tagu, Yawe God biidi avinuwamiise; Yagu maragata touna yavereveregu, bi iviyawiigu na iinuwamiise, noko kiiravine kagu aviya iinamayedi. ");
INSERT INTO aui_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","O Yawe God, getana iiyabo kabikabikuwayina ware tam naboni. Getana god mududi meme Getana miiribabara ware tam naboni, yama God. ");
INSERT INTO aui_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Na anawona bo, ‘Yami kabigeegeeyana kokabitoura; yami noghota mayeyana sisiyidi tughuridi kotoura. Basuna Yawe God bera tupadi iyakowa bi yami bera initupawamiwamiredi.’ ");
INSERT INTO aui_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Yawe God, tam aviya damdi yadi riwariwa kugiidi; bi wawaya noganogadi kukabi wiimaragasidi. ");
INSERT INTO aui_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Iiyawogha roro simoura kirakiina, kata kam kiiravine sinabagibagi, bi gomagomaridi katana sakamkam kirakii. Wasike gagarina katana ivituwa da natunatuna seven bi wasike wiituwa kirakiina na getana iiyabo da iyiwiiteni. ");
INSERT INTO aui_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Tam rabobo kwiitubuyi bi yawa kwavereyana; Wawaya karawage kwatoredi bi kwakabiwiigeghomiiridi. ");
INSERT INTO aui_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Yawe God, kwabera na wawaya mududi sagomara bi mududi samoura; kwabera na mududi kwatoreyowoyedi bi mududi kwatoregeeyedi. ");
INSERT INTO aui_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Moyamoyakidi popokuma kwakabiwiimiiridi bi wiikanighughuvidi yoghoma kwarukabepidi da kiikiiwawo yawata samake bi kabikuwaya gawaridi sirapeneyana. Bi kubura tupana na tam Yawe God rapemve; bi bera tupadi kadi gaware kutoredi. ");
INSERT INTO aui_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Yam wawaya kabikabikuwayidi kwiitarababaranedi, bi wawaya wiikawakeekeedi wiididibara kuburine sanagho. Wawaya gemeyani yadi maragatama kadi aviya sinageeiwayidina ");
INSERT INTO aui_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Kam aviya kwakasiwiiberodi, yam nuwapughu abamama inaguguri na ware warikeyakeya naboni toudi biiyadi Yawe God, tam kubura tupana kunitupawamiwamireni bi yam kiiwawo kunakabiwiimaragasi, bi yam wiivinevinegha kiiwawona maragata kunavereni.” ");
INSERT INTO aui_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Bi Elkana yana wawaya yawata siveramagha yadi bareye Rama kwanatune, bi Samwel, Sailo kwanatune imakae da Yawe God ibagibagiyeni bi Eli touna prist yana wiibadana rogune. ");
INSERT INTO aui_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Wasina bi raghanina Samwel, tomogha wabuwabune, na Yawe God iyabigebigeni Eli yana wiibadana rogune. Noko raghanine Yawe God gewawaya biiyadi iyiisisiyana bo wawaya biiyadi genonowa iyarurumaghatara mimeu kamodiye bi raghani tatadigegha siyatubutubugha. ");
INSERT INTO aui_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Eli matana sibero kirakii na pinimina bi siyapota. Nubabasu tana yana gaware iyakenakena, ");
INSERT INTO aui_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","bi Samwel na Yawe God yana bare kamone Wiiwaghasina Maragasina Dedewagina ririne iyakenakena. Bi raghani kana didiguba iyoghogheni na kibe gawara kabikabikuwayine patana iyakarakarata ");
INSERT INTO aui_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","bi Yawe God irukwatu bo, “Samwel!” Na Samwel iwona bo, “Awaki, tagu mma!” ");
INSERT INTO aui_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Bi igeghomiiri da iverainagho Eli biidi bi iwona bo, “Tam kukwatuvegu, tagu mma nada apiika.” Bi Eli iwona bo, “Getagu ayakwatuvemna, kuveramagha kunakena.” Na Samwel iveramagha ikenayowogha iyakenakena. ");
INSERT INTO aui_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Wasina bi Yawe God ikwatumagha bo, “Samwel!” Na Samwel igeghomiiri da inaghomagha Eli biidi bi iwona bo, “Tam kukwatuvegu, nada apiika.” Bi Eli iwona bo, “Natugu, getagu ayakwatuvemna, kuveramagha kunakena.” Na Samwel iveramagha ikenayowogha iyakenakena. ");
INSERT INTO aui_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Noko raghanine Yawe God getana iyisisiya towogha Samwel biidi noko kiiravine na gamona iwaiyana wiinagonagoveni. ");
INSERT INTO aui_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Wasina bi Yawe God ikwatu iviarobi, na Samwel igeghomiiri magha da inagho Eli biidi bi iwona bo, “Tam kukwatuvegu?” Wasina bi Eli noghota ikabi da nokona Yawe God tomogha gisigisi iyakwatukwatuveni. ");
INSERT INTO aui_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Na Samwel iwoneni bi, “Kuveramagha kunakenayowogha, bi memeda wawaya tana inakwatuvena mayem na mma naboni kisisiya, ‘Yawe God, kisisiya, bi yam wiitamariyana yawaiwaiyana.’” Wasina bi Samwel iveramagha ikenayowogha. ");
INSERT INTO aui_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Wasina bi Yawe God ipiika da imiiri bi Samwel ikwatuveni ware dagudagune iberana naboni iwona bo, “Samwel! Samwel!” Na Samwel iwona bo, “Kisisiya, tagu yam wiitamariyana awaiwaiyana.” ");
INSERT INTO aui_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Na Yawe God iwona bo, “Isrel damdi kamodiye Tagu bera bero kirakiina anabera. Raghanina wawaya sinawaiyaneni na sinakabinoka da sinanaghara. ");
INSERT INTO aui_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Tagu, aro Eli yana rakaraka teya anaveredi ware rorowainagha awonedina naboni. ");
INSERT INTO aui_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Touna natunatuna bera beroberodi siyaberabera, bi geiyakidi da siyakabitore, na awoneni da yana rakaraka aro anaverewaghasidi. ");
INSERT INTO aui_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Bi iisuwona da yadi tamumu geananoghotataveni, bagune memeda sinasuwara tagu biidi bi kate geananoghotatavedina.” ");
INSERT INTO aui_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samwel ikenayowogha bi iyimatatete patana da raghani ibori, bi igeghomiiri da Yawe God yana bare matamketana ikabitaveni. Bi Yawe God awaki iwoneni na inaghara da gerubana noko yana mimeuna iyimaghamaghatareni Eli biidi. ");
INSERT INTO aui_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Bi gegha Eli ikwatu bo, “Samwel, natugu.” Na Samwel iwona bo, “Tagu mma.” ");
INSERT INTO aui_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Na Eli iwona bo, “Yawe God metagha iwonem? Na sisiyina tupana kuwonegu, bi memeda gekunawonegu, na God aro ghamanakina inaverem!” ");
INSERT INTO aui_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Na Samwel, Yawe God yana sisiya tupana Eli ivimaghamaghatareni, bi getana iyikowoyina. Wasina bi Eli iwona bo, “Yawe na God, bi awaki yanoghonoghosi miisena touna biidi na inabera.” ");
INSERT INTO aui_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Raghanina Samwel iyaragaragata na Yawe God, Samwel iyagwabigwabiyeni bi iberani da yana sisiya tupadi situbugha. ");
INSERT INTO aui_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Na Isrel damdi tupadi, Dan kwanatune da inagho Biasiba kwanatune sakovi da Samwel na Yawe God yana peroveta. ");
INSERT INTO aui_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Yawe God raghani ipeyari Sailo kwanatune iyidebena mayeni da iyiisisiya Samwel biidi. ");
INSERT INTO aui_vpl VALUES ("S18_1","010_8_1","1SA","8","1","2","Samwel natunatuna yadi bata, iyarokona kana waghawagha Jowel bi murimurina Abija. Raghanina iyamoramoraba na ivineyidi da Isrel damdi siyibadedi, bi noko bagibagina Biasiba kwanatune siyaberabera. ");
INSERT INTO aui_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Bi gegha da gebera miisedi siyabera da ware tamadinaki iberana naboni. Toudi yadi wiina da bera berodima mane siyayouna, na wiinuwatayinama mane kabiwiikowoye wawaya gwabidima siyayuyouna wapawapa bi gegha da keda rotomanina naboni sikiyawiiriwa. ");
INSERT INTO aui_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Na noko kiiravine Isrel kana babada sivitaghomidi bi sinagho Rama kwanatune Samwel biidi da yawata siyibanana. ");
INSERT INTO aui_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Na siwona bo, “Tam nada kumoraba bi natunatum na gekayewarubimgha siyanono bi geyam bera rotomanidi siyakivikivina. Na noko biidi kiiwawo tana kuveremii da ininaghovemii ware kubura mududi saberaberana naboni.” ");
INSERT INTO aui_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Bi gegha da Isrel babadidi yadi wiibaba kiiwawo kiiravine na Samwel geiyinuwamiiseyeni na Yawe God biidi irupari. ");
INSERT INTO aui_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Na Yawe God iwona bo, “Awaki kiiravine sibabiim kuyabera na kubera. Tagu sisinighiighiiyegu, gegha tam. Toudi geyadi kayowana da kata Tagu kiiravidiye anikiiwawo maghana. ");
INSERT INTO aui_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Raghanina Ijipt kuburama akabikanibuvedi gabudarine patana da kata na samiimiiri kubutegu da god mududi sakivikivina ware rorowainagha siyaberabera na naboni. Bi katana bada tam biidi naboni saberabera. ");
INSERT INTO aui_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Na kuwaiyana, metagha sivibabiim na naboni kubera, bi dagudagune na sisiya maragasinama kuwonawiikatayidi da metagha noko kiiwawona inibadedi.” ");
INSERT INTO aui_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Na Samwel, iiyawogha kiiwawo kiiravine sivibaba na Yawe God yana sisiya tupana ivisisiyena rutughutughuredi toudi biiyadi ");
INSERT INTO aui_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","bi iwona bo, “Memeda kiiwawo inibademi, na mma naboni inabera - natunatumi tomotomogha viya inayouna da yana iyo damdi. Bi inabera da mududi yana seriyot da hosi debadiye sinabagibagi, bi yana seriyot naghodiye sinaveravera kiiwawo warana siniyoneyoneni. ");
INSERT INTO aui_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Bi mududi inabera da iyo damdi yadi 1,000 kadi babada bi mududi iyo damdi yadi 50 kadi babada. Mududi na yana kwabuve sinabagibagi da yana kam sinituwiitaghoma. Bi kate mududi na yana wiiyogha sawaridi da seriyot kadi sawara sinabera. ");
INSERT INTO aui_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Noko kiiwawona natunatumi wasiwasike mududi inayouna bi inabera da touna kiiravine wane ghabughabu sinabera bi mududi kana kam sinitawogha da sinagibugibu. ");
INSERT INTO aui_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Yami kam kwabudi, wain kwabudi da kate oliv kiidi sinawawa na gawaridi miisedi inayouna da yana bagibagi wawayidi ghamaghamadi inaveredi. ");
INSERT INTO aui_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Raghanina yami kabeni da wain uwadi konituwiitaghoma bi riba 10 konaberadi, na riba tana inakabi da yana bagibagi wawayidi da wiitamariyana yawata sinarereyi. ");
INSERT INTO aui_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Yami wiitamariyana tomotomogha da wasiwasike, bi kau da donki miisedi inayouna da touna wosina yana bagibagi sinabera. ");
INSERT INTO aui_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Raghanina yami sip bo gout konayouna da riba 10 konaberadi bi kamodiye na ribiribi yadi 10, na riba tana inakabitaveni touna kiiravine, bi inaberami da touna wosina yana wiitamariyana. ");
INSERT INTO aui_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Noko gabudarine, raghanine kiiwawo mmkodi bera inabera na tami, Yawe God biidi konadou mmko kiiwawona kiiravine koyibaba na gwabinama iyiwiitemi, bi gegha Yawe God kate geiniwiitemina.” ");
INSERT INTO aui_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Bi gegha da wawaya, Samwel yana sisiya maragasina gesiyawaiyaneni bi siwona bo, “Gegha, toumii yama kayowana da kiiwawo inibademii. ");
INSERT INTO aui_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Na wasina bi toumii ware kubura mududi naboni. Yama kiiwawo inibademii bi ininaghovemii da ininagho kana kanibu da dam mududi kaniaviyedi.” ");
INSERT INTO aui_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Na Samwel, wawaya yadi sisiya iwaiyana ikovi bi inagho da ivitowawoneni Yawe God biidi, ");
INSERT INTO aui_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","na Yawe God iwona bo, “Awaki sakayokayoveni na kubera da kiiwawo kuveredi.” ");
INSERT INTO aui_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Dam Benjiman kamonama na tomogha tana nama kana waghawagha Kis, tamanananaki na Abiel, tubunanaki Jero bi nosinanaki na Bekoret, bi kayekikidi na Apiya dam Benjiman tomogha bi moumourina. ");
INSERT INTO aui_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kis natuna Sol na tomogha komerowanina, geware tomotomogha mududi Isrel kamone naboni. Bi kate bada igurikirakii da Isrel tomotomogha imiiritawanidi. ");
INSERT INTO aui_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Gabudara tana Kis yana donki sisiwana, na natuna Sol iwoneni bo, “Wiitamariyana tana kurutayini bi konagho da donki koninoyedi.” ");
INSERT INTO aui_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Gabudara raviravi naboni, muriye da Sol iyapiika Samwel biidi, na Yawe God, Samwel iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Mmko raghanine maram, na dam Benjiman kamonama tomogha tana anipora tam biidi. Bi oliv miinama kituboro bi noko iniyeveveyana da avineyi yagu wawaya Isrel damdi inibadedi. Touna Pilistain damdi gwabidima iniyawiidi. Yagu wawaya yadi kabikwarakwara akita bi wiiwiita kiiravine yadi dou awaiyana.” ");
INSERT INTO aui_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Wasina bi Samwel oliv miina verikokona ikabi bi Sol gayamine iwayi, imaghani bi iwona bo, “Yawe God ivineyim da nuwanuwana wawayidi Isrel damdi kunibadedi noko biidi mmko berana aberabera. ");
INSERT INTO aui_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Raghanina kata kunakuyovegu, na tomotomogha bata Jelsane, Benjiman kubura kana wiibarabarate Reitsel karawagina ririne kunabananidi. Na sinawonem bo, ‘Nokodi donki kunagho wiinoyedi kiiravine, na nada sibananidi. Na katana tamamnaki geiyanoghonoghosidina, touna tam yinuwapoyem na patana yitarakiiyana yawonawona bo, “Metagha natugu anabanani?” ’” ");
INSERT INTO aui_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Bi bada Samwel, Sol iwonenamayeni bo, “Bi noko murine na kunanagho God yana Koya Gibiyane, meme Pilistain damdi sivitakina. Bi kwanatuve kunarughurughu, na peroperoveta boruna kunabananidi kabepepa gawarinama sinayoyo. Toudi kabepepa sawaridi kadi waghawagha hap da laya, tambarin da durere sinirekwedi, bi sinawonawona kasiyaragha. ");
INSERT INTO aui_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Noko raghanine na Yawe God kanumina inayoyom na toudi yawata konawonawona kasiyaragha. Tam iniwuwamirem na yam bera inibogae. ");
INSERT INTO aui_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Raghanina mmkodi bera sinatubugha, na Yawe God iniwiitem da awaki beradi yakayokayovem da kuyabera na kunabera. ");
INSERT INTO aui_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Wasina bi kuninagho kunayowogha Gilgal kwanatune, bi name tanibanana da ribiribi anikasunughana bi anagibu naboni suwara Yawe God biidi bi ribiribi mududi anaverewosi naboni wiiturana suwarina. Tam name gabudara 7 kunikoyakoyagha patana da anaverakanibu, bi anawonem da awaki kunabera.” ");
INSERT INTO aui_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Raghanina Sol imiiri wamira bi Samwel iyakuyokuyoveni, na Yawe God iviwuwamireni na yana bera ivibogae. Noko gabudarine Samwel sawara tupadi Sol iwonena katamaneni na wiisuwona situbugha. ");
INSERT INTO aui_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Berana mma naboni. Raghanina Sol da yana wiitamariyana Gibiya kwantune siverakanibu, na peroperoveta boruna sikitadi siyapiipiika toudi biiyadi. Wasina bi God kanumina Sol ivibonuvi, na inorughu da idagu yawata siyawonawona kasiyaragha. ");
INSERT INTO aui_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Raghanina iiyawogha Sol sakowakatamaneni bi sikita mmko berana iyaberabera, na sivitarakiiyana kabivivirana bo, “Wiisuwona? Da mmko awaki berana itubugha Kis natuna biidi? Wiisuwona da Sol touna peroveta?” ");
INSERT INTO aui_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Wawaya tana nama iyamiimiiri na iwona bo, “Getamananaki tananoghota kirakiiyenina, rubana da wawaya wapawapa iniperoveta.” Na wonakayowiiwiiyaka mma naboni irumaghatara, “Wiisuwona bi wonawaghata da Sol touna peroveta?” ");
INSERT INTO aui_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Raghanina Sol iwonakasiyaragha ikovi na igae kabepepa gawarine. ");
INSERT INTO aui_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Muriye na aghunanaki ipiika da ibananidi na touna da yana wiitamariyana teya ivitarakiiyanedi bo, “Tami meme koyamakamake?” Na Sol iwona bo, “Toumii donki kayininoyedi, bi gekayabananidina. Na kanagho Samwel biidi da kayitarakiiyaneni donkidi meme.” ");
INSERT INTO aui_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Na aghunanaki ivitarakiiyana bo, “Bi metagha Samwel iwonem?” ");
INSERT INTO aui_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Na Sol iwona bo, “Touna iwonemii da wawaya donkidi nada sibanana.” Bi Sol aghunanaki geiyawoneni da Samwel iwona da touna inikiiwawo Isrel damdi kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Muriye na Samwel, Isrel damdi tupadi iwonedi da siyanagho Mispa kwanatune da Yawe God yana sisiya siyawaiyana. ");
INSERT INTO aui_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Raghanina siverakanibu, na Samwel iwonedi bo, “Yawe God, Isrel kana God, mma naboni yawonewonemi, ‘Tami Isrel dammi, nosinosiminakim Ijipt damdi maragasidima aviyawiidi, akabi apiikedi mmko kuburine bi dam tupadi siyikayotaketowanemi na gwabidima aviyawiimi. ");
INSERT INTO aui_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Bagune Tagu yami God, iiyabo yami nuwapoya da kabikwarakwarama aviyawiimi, bi gegha da kata mmko gabudarine na kosinighiiyegu, kowona bo, “Gegha, toumii yama kayowana da kiiwawo inibademii.” Noko biidi Yawe yami God naghoguve kovitaghomimi, bi kami dam nunudigha kokabiwiiborumi komiiri.’” ");
INSERT INTO aui_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Na Samwel, Isrel tupana ikabikanibuvedi da kadi dam nunudigha simiiri, bi Yawe God, dam Benjiman ivineyi. ");
INSERT INTO aui_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Wasina bi Samwel, dam Benjiman kamonama rakaraka tupadi iwonedi na simiiri kanikanibu, bi Yawe God, Metri yana rakaraka ivineyi bi noko rakarakana kamonama Kis natuna Sol ivineyi. Bi gegha raghanina wawaya, Sol sivinoyeni na gesiyabanani. ");
INSERT INTO aui_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Na Yawe God sivitarakiiyaneni bo, “Bada wawayina mma bo gegha?” Na Yawe God iwona bo, “Touna sawara kamodiye yakowokowogha.” ");
INSERT INTO aui_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Na sivera sinagho Sol sininoyeni, bi raghanina sibanani na sirutayini sipiika wawaya naghodiye sikabiwiimiiri, bi siyakita da touna igurikirakii da tupana imiiritawanidi. ");
INSERT INTO aui_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Wasina bi Samwel, wawaya iwonedi bo, “Tomoyina mmakatanina Yawe God ivineyi da yami kiiwawo. Getana iiyabo touda Isrel damda kamodae touna naboni!” Na wawaya tupana sikarayewoveni bo, “Kiiwawo rubana inamake da bodu peyaridi!” ");
INSERT INTO aui_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Muriye na Samwel, Isrel damdi iwonedi bo, “Kopiika tana nagho Gilgalma bi taniwaghasina da wiisuwona Sol na yada kiiwawo.” ");
INSERT INTO aui_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Na tupadi sinagho Gilgalma, bi raghanina Yawe God siyakabekabepepina siviwaghasina magha da wiisuwona Sol na yadi kiiwawo. Name ribiribi Yawe God siverewosi naboni wiiturana suwarina, meko tupadi sikam patapata. Na Sol da Isrel damdi tupadi sivinuwamiise kirakii. ");
INSERT INTO aui_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Samwel, Sol iwoneni bo, “Mmkona beraneghanegha kubera! Yawe yam God yana sisiya bagibagina meko iverem na gekuyakabisisirenina. Bi memeda kuyakabisisireni, na Yawe God, tam da nosinosim yawata iyabera da Isrel koyibadena waghasi! ");
INSERT INTO aui_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Bi kata da nabo inagho, na yam wiibadana geinano wiikaruna, basuna yana sisiya bagibagina gekuyakabisisireni kiiravine. Na Yawe God, wawaya tana nada ibanani iiyabo yana noghota na ware touna yana noghota naboni, na ikabiguba ivineyi da kam tupataveyana yana wawaya Isrel damdi ininaghovedi.” ");
INSERT INTO aui_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Muriye na Samwel, Sol iwoneni bo, “Tagu wosina Yawe God iviporagu avituborom da kuvikiiwawo Isrel kuyibadeni. Na noko kiiravine Yawe God yana sisiya kuwaiyana. ");
INSERT INTO aui_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Yawe God Maragata Kirakiina iwona da, ‘Raghanina Isrel damdi Ijiptma siyapiipiika, na Amelek damdi nosinosidinakim sigeghomiiri da sigogona kuridi, na kata Amelek damdi aro anaveredi. ");
INSERT INTO aui_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Na konagho da Amelek kogogona kuridi, bi sawara tupadi rapediye na koviberotuwanonoyidi. Gegha konanuwatotovedina bi tomotomogha, wasiwasike, natunatudi da pepeya tupadi kovikasunughana. Bi kate bada yadi kau, sip, kamel da donki tupadi kovikasunughana.’” ");
INSERT INTO aui_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Wasina bi Sol yana wiiyogha tomotomoyidi yadi sisiya idaru da siyapiika Telem kwanatune siyitaghomidi. Wiiyogha tomotomoyidi yadi 10,000 dam Jiuda kamonama sipiika bi 200,000 na Isrel kana dam mududi kamodima sipiika. ");
INSERT INTO aui_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Sol yana wiiyogha tomotomoyidi ivinaghovedi bi wiirouwa sidaguni da Amelek damdi sigeiwayidi, wiirouvina na Havila kwanatune sidagu bi sivirouwa wiikaru da Su, noko kwanatuna na Ijipt bi raghani matanama. ");
INSERT INTO aui_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Toudi Amelek yadi kiiwawo Agag yawayawiina siburavi, bi wawaya tupana na siviberotuwanonoyidi. ");
INSERT INTO aui_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Bi Sol yana wiiyogha tomotomogha yawata gegha Agag siyakasunuyina, da kate bada sip da kau miisedi, bi natunatudi takutakukudi da kate sawara miisedi tupadi. Bi ribiribi da sawara tupadi mekodi gesiyakayovedi, na toudi kawagha siviberodi. ");
INSERT INTO aui_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Muriye na Yawe God, Samwel iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Tagu iinuwabero da Sol atore ivikiiwawo, basuna imiiri kubutegu da yagu sisiya bagibagidi geiyakabisisiredi.” Raghanina Samwel, Yawe God yana sisiya iwaiyaneni na ivinuwapoya da noko nubabasu gurigurina irupari wiimaragata Yawe God biidi. ");
INSERT INTO aui_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Raghani ibori didibarawote na Samwel itouya inagho da Sol iyinoyeni, bi gegha wawaya tana iwoneni da Sol inagho Kamel kwanatune. Meme tounamani noghosine akima ikabiwiimiiri da wawaya siyakabikuwayeni, bi muriye iyowogha inagho Gilgalma. ");
INSERT INTO aui_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Wasina bi Samwel, Sol ibanani raghanine, na Sol iwona bo, “Samwel, Yawe God inimiiseyem. Tagu yana sisiya bagibagidi akabisisiredi.” ");
INSERT INTO aui_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Bi gegha da Samwel iwona bo, “Memeda yana sisiya bagibagidi kuyakabisisiredi da sawara tupadi kuyiberodi, bi awaki kiiravine sip da kau gamodi awaiwaiyana?” ");
INSERT INTO aui_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Na Sol iwona bo, “Yagu wiiyogha tomotomoyidi nokodi ribiribi Amelek damdi gwabidima siyouna. Bi sip da kau waratetedi sikabitawana da Yawe yam God biidi siyasuwara, bi muduna na kaviberotuwanonoyidi.” ");
INSERT INTO aui_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Wasina bi Samwel, Sol iwoneni bo, “Kiraborabobo kunawaiyana! Bi Yawe God metagha nubabasuve iwonegu na anawonem.” Na Sol iwona bo, “Metagha iwona?” ");
INSERT INTO aui_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Na Samwel iwonabodeyana bo, “Bagune kunoghosida da tam gewawaya ghamam, katana tam Isrel damdi kadibada. Yawe God ivituborom na tam yadi kiiwawo. ");
INSERT INTO aui_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Sisiya bagibagidima iwonem bi iviporam kukanibu da nokodi Amelek damdi kawakeekeedi kuyiberotuwanonoyidi. Iwonem da kuyirouwa patana da tupadi kuyagigiratavedi. ");
INSERT INTO aui_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Awaki kiiravine gekuyakabisisirenina? Iwonem da tupeyane yapi sawaridi gekoyayouna, bi gegha da wiisasarane koyouna, na tami Yawe God matane bera berona kobera.” ");
INSERT INTO aui_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Na Sol iwona bo, “Tagu Yawe God akabisisireni, bi iwonegu da ayanagho na akanibu anagho da Amelek damdi tupadi agigiratavedi bi yadi kiiwawo Agag akabi averamagha. ");
INSERT INTO aui_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Bi gegha da yagu wiiyogha tomotomoyidi, na sip da kau miisedi mekodi siyouna, na gesiyikasunughana bi sikawara sipiika mabo Gilgalma da siyasuwara Yawe yam God biidi.” ");
INSERT INTO aui_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Wasina bi Samwel iwona bo, “Awaki ivinuwayuyuna kirakii Yawe God biidi suwara gabugabunidi bo gamona kabisisirenina? Wiisuwona! Kabisisira, na imiise kirakii geware suwara gabugabunidi naboni. Bi bera ghamana na gamona tana waiyaneni, gegha ware sip makina nanarina miisena suwarina naboni. ");
INSERT INTO aui_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Bi memeda wawaya Yawe God iniaviyeni, na yana berona na ware imapu naboni. Bi wawaya nuwanuwana inakotakii Yawe God biidi na yana berona na ware tarabiibiisaka pepetedi naboni. Na Yawe God yana sisiya bagibagina kuvisinighiighiiyeni kiiravine, na isinighiiyem da tam gemuriye yana wawaya yadi kiiwawona.” ");
INSERT INTO aui_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Raghanina Samwel imiiri wamira da iyatouya na Sol, Samwel kana kwama itainatawani na itamogosira. ");
INSERT INTO aui_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Na Samwel iwoneni bo, “Kagu kwama kutainatawani da itamogosira, na bada mayimayiyina kata mmko gabudarine Yawe God yam wiibadana Isrel damdi gwabidima ikabitaveni, bi wawaya tana ivereni iiyabo imiise getam naboni. ");
INSERT INTO aui_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Isrel kana God makewaghawaghasina na gegha wiiwiiyabina bo yana noghota iyawamiwamirana. Touna gewawaya wota, da yana noghota inawamiri.” ");
INSERT INTO aui_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Wasina bi Samwel iveramagha Rama kwanatune, bi Sol iveramagha yana bareye Gibiya kwanatune. ");
INSERT INTO aui_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Samwel yawayawiine iyamakamake raghanine, na geiyanagho da Sol iyakita mayenina, bi gegha da Sol kiiravine na ivinuwapoya. Bi Yawe God ivinuwapoya kirakii da Sol ibera da Isrel kana kiiwawo. ");
INSERT INTO aui_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Yawe God, Samwel iwoneni bo, “Sol kiiravine kuninuwapoya da raghani meyani duu kunakabitore? Tagu asinighiiyeni da naboni Isrel kana kiiwawo. Na oliv miina yam dogha kamone kiwayi bi kabikunagho tomogha kana waghawagha Jese biidi, Betlihem kwanatune. Natunatuna kamodima tomogha tana avineyi kiiwawo kiiravine Sol kana tupataveyana.” ");
INSERT INTO aui_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Na Samwel ivitarakiiyana bo, “Metagha ananagho? Memeda Sol mmko berana kiiravine inawaiyana na inakasunuyigu!” Bi Yawe God iwona bo, “Kau wouna yagarina kunarutayini da kunananagho bi kunawona bo, ‘Tagu apiika da Yawe God biidi anasuwara.’ ");
INSERT INTO aui_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Bi Jese kuviyoneni noko suwarina kiiravine, bi aniyevevem da awaki kunabera. Raghanina natuna meko avineyi na oliv miina gayamine kuniwayi na noko inimatakira da yagu wiivinevinegha.” ");
INSERT INTO aui_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Na Samwel, Yawe God awaki iwonenina naboni ibera. Raghanina Betlihemma iverakanibu na kwanatu babadidi ere kirokirorodi sikanibu da siyikiikiiveni na siwona bo, “Metagha, nuwaruririye kopiika?” ");
INSERT INTO aui_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Na Samwel iwona bo, “Eeka, mabo apiika da Yawe God biidi anasuwara. Kokabununagha mayemi bi kopiika tana suwara.” Bi kate bada Jese natunatuna yawata iwonedi da siyakabununagha mayedi bi iviyonedi noko suwarina kiiravine. ");
INSERT INTO aui_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Raghanina siverakanibu, na Samwel, Jese natuna iyarokona Eliyab ikita, na tounamani iwonena mayeni bo, “Wiisuwona, mmko tomoyina mma Yawe God naghone yamiimiiri na yana wiivinevinegha kiiwawona.” ");
INSERT INTO aui_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Bi gegha Yawe God, Samwel iwoneni bo, “Gegha yana komerowana da yana guri kunanoghosidina, Tagu geyaguwiina touna. Wawaya gesiyakitakita da Tagu awaki akitakitana. Toudi wawaya tubuyina kubuna sakitakita, bi Yawe God na wawaya nuwanuwana akitakita.” ");
INSERT INTO aui_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Na mmko kedane Jese natunatuna yadi 7 ipiikedi Samwel biidi. Bi gegha da Samwel, Jese iwoneni bo, “Yawe God mmkodi tomotomogha woudi getana meko iyavineyina.” ");
INSERT INTO aui_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Bi ivitarakiiyaneni bo, “Da natunatum wasina mma naboni?” Na Jese iwona bo, “Natugu tomogha tughurina, na touna sip yakoyakoyagha.” Na Samwel iwona bo, “Tomotomogha viya koviporadi da sinarutayini sinapiika mabo. Raghanina inaverakanibu na suwara tanabera da tanakam.” ");
INSERT INTO aui_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Wasina bi Jese tomotomogha iviporadi da sikabisipiikeni. Bi tomoyina na tubuyina miisena, komerowanina bi matana yeghanidi. Raghanina tomoyina iverakanibu. Na Yawe God, Samwel iwoneni bo, “Wasina tomoyina mmakatanina avineyina! Geghomiiri da oliv miinama kunituboro.” ");
INSERT INTO aui_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Wasina bi Samwel oliv miina ikabi da Deivid kana iyiyaroko naghodiye bi ivituboroni. Na noko gabudarine da nabo inagho na Yawe God kanumina Deivid ivibonuvi da gwabiyenina idagu. Noko murine na Samwel iveramagha Rama kwanatune. ");
INSERT INTO aui_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Wasina bi Yawe God kanumina miisena Sol ivikanibutaveni bi kanuma berona ivipora da Sol ivibonuvi na nonowa iyinakinakiyeni na iyanaghanaghara. ");
INSERT INTO aui_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Sol awaki sawaridi beradi kiiravine na Deivid iyiipora na rubana iyaberabera, noko biidi na itore da naboni yana wiiyogha tomotomoyidi kadi bada. Mmko berana kiiravine na wawaya tupadi da wiiyogha tomotomogha kadi babada yawata sivinuwamiise. ");
INSERT INTO aui_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Deivid, Golaiyet ikasunuyi murine, bi raghanina tomotomogha siyaveravera magha bareye na wasiwasike Isrel kwanatudima sikanibu da Sol siyikiikiiveni, na tambarin da kabepepa inavina tana kana waghawagha lute siyiirekwedi bi nuwamiise ayidi siyatawotawora da siyarikuriku. ");
INSERT INTO aui_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Wasina bi yadi nuwamiise kamone na wasiwasikedi mma naboni siyatawotawora, “Sol aviya damdi yadi 1,000 iunugha! Bi Deivid na 10,000 iunugha!” ");
INSERT INTO aui_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Sol mmkodi sisiyidi kiiravine geiyinuwamiise, na nuwanuwana ipughu kirakii da iwona bo, “Toudi Deivid satoretoregeeyeni sawonawona da touna aviya damdi yadi 10,000 ivikasunughana, bi tagu na 1,000 kawagha avikasunughana. Bi muriye na sinabera da yadi kiiwawo!” ");
INSERT INTO aui_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Wasina bi noko raghanine da nabo inagho, na Sol, Deivid iyanuwanuwakapiyeni. ");
INSERT INTO aui_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Wasina bi Deivid inagho kwanatu kana waghawagha Nobma da Ahimelek iyakita, bi touna na prist. Raghanina Ahimelek ikanibu da iyikiikiiveni, bi inaghara na iwona bo, “Awaki kiiravine tamduma mabo kupiika bi getana da iiyabo yawata?” ");
INSERT INTO aui_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Deivid, iwonabodeyana bo, “Kiiwawo Sol iwonegu da bagibagi tana anabera, bi iwona bo, ‘Gewawaya tana kunawoneni da awaki basuna na iiporam bo wonawiiyoyowana awonemna.’ Bi yagu wiiyogha tomotomoyidi, na awonedi da gawara tane sinikoyakoyagha da muriye sinabananigu. ");
INSERT INTO aui_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Gwabimve kam bo gegha da mududi kunaveregu? Bred geredi yadi 5 bo kam wapawapa gwabimve na kuveregu.” ");
INSERT INTO aui_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Bi gegha da Ahimelek iwona bo, “Toumii getana bred wota gwabimiiyena, bi mma na bred Yawe God biidi sisuwara na toudi kawagha. Mmkodi bred kunayouna bi memeda yam wiiyogha tomotomoyidi gabudara viya natuwavinedi yawata gesiyakena, na wasina.” ");
INSERT INTO aui_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Na Deivid iwona bo, “Wiisuwona toumii gegha wasiwasike yawata kayakenana. Raghanina kakanibu kanagho aviya kiiravine na nonowa, toumii kakabununagha mayemii da kanakabepepa. Katana kiiwawo iviporamii na parapa kakoyagha yapoyapora mayemii da toumii mmko bagibagina kanabera.” ");
INSERT INTO aui_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Getana awaki kamna nama, kiiravine na Ahimelek bred Yawe God biidi sipuyo, na iyouna da Deivid ivereni, noko bred na Yawe God naghone satoura yana Kiregoru kamone. Noko gabudarine na bred katamanidi kiinabonabo debanama sikabitavetaveyana Yawe God yana Kiregoru kamone bi bred woudi name sitoura. ");
INSERT INTO aui_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Noko raghanine Pilistain damdi, na Isrel damdi teya Gilbo Koyane siyiirouwa. Na Isrel wiiyogha tomotomoyidi, Pilistain nagharidi siverataveyana, na Pilistain sigeghomiiri da Isrel damdi korotodi sivikasunughana. ");
INSERT INTO aui_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Pilistain damdi Sol da natunatuna yawata sirukwavina sinagho, da natunatuna Jonatan, Abinadeb da Malkisuwa sivikasunughana. ");
INSERT INTO aui_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Sol ririnagha na wiirouwa ivita da ibero kirakii na aviya damdi riwariwa iyonama sogha na sivinoganoga. ");
INSERT INTO aui_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Na Sol wiiyogha tomoyina, meko yana wiirouwa sawaridi iyakawakawara na iwoneni bo, “Yam seri kabitaveni da tounama kunakasunuyigu! Geyagu kayowana da mmkodi kubuna damdi sininamayegu bi sinakasunuyiguna.” Bi gegha da mmko wiiyogha tomoyina kasunuyina inagharareni. Wasina bi Sol tounamani yana seri ikabitaveni da ikabiwiinighonigho bi debane ibeku. ");
INSERT INTO aui_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Raghanina wiiyogha tomoyina ikita bi Sol irabobo, na touna bada yana seri itaina kanibuveni bi berana mayimayiyinama ivirabobo mayeni. ");
INSERT INTO aui_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Wasina bi Isrel damdi kadi babada tupadi sipiika Hebron kwanatune bi Deivid siwoneni bo, “Toumii na yam rakaraka, tubuyida da ganiganida tanagha. ");
INSERT INTO aui_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Roro, raghanine Sol iyikiiwawo kiiravimiiye, na Isrel yana wiiyogha tomotomoyidi kuyinaghovedi wiirouwa kiiravine koyakanikanibu. Na Yawe God iwonem bo, ‘Yagu wawaya Isrel damdi kunakoyayidi ware sip kanabodaboda wawayina sip yakoyakoyayidina naboni, bi tam kadi wiibadana.’” ");
INSERT INTO aui_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Raghanina Isrel kana babada ghamaghamadi tupadi sipiika Hebronma Deivid biidi, na Yawe God matane wiiwaghasina maragasina touna yawata sibera. Wasina bi babadidi oliv miina Deivid gayamine siwayi da noko iyiyeveveyana da touna kata Isrel kana kiiwawo. ");
INSERT INTO aui_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Raghanina Deivid kana bodu 30 na ivikiiwawo, bi bodu 40 kamone ivibada. ");
INSERT INTO aui_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Wasina bi Yawe God, Deivid kana aviyama ivitarababareni bi maragata ivereni da aviya tupadi igeiwayidi. Bi yana kiiwawo barene nuwaruririye iyamakamake, ");
INSERT INTO aui_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","na Deivid, peroveta Neitan iwoneni bo, “Kata tagu mma, bare waratetena bi kii miisena sidama siyoghanina kamone amakamake, bi God yana Wiiwaghasina Maragasina Dedewagina na kiregoru kamone yamakamake.” ");
INSERT INTO aui_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Bi Neitan iwonabodeni bo, “Yawe God na gwabimve, na kunagho da awaki kwanoghonoghosi na kubera.” ");
INSERT INTO aui_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Bi gegha da noko nubabasune Yawe God, Neitan iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Kunagho yagu wiitamariyana Deivid kunawoneni bo, ‘Yawe God mma naboni iwona: Gegha tam kiiraviguve bare kunayoghani da kamone anamakena.’ ");
INSERT INTO aui_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Bi katana yagu wiitamariyana Deivid kuwoneni bo, ‘Yawe God Maragata Kirakiina mma naboni iwona: Naghove na tam wawaya wota wawa kuburidigha sip kuyakoyakoyagha, bi gegha da avineyim bi atoregeeyem da yagu wawaya Isrel damdi yadi bada. ");
INSERT INTO aui_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Meghamegha kuyanono, na tagu nama gwabimve, da matamve bi kamaviya ageiwayidi. Na kata kam waghawagha anabera da inaragata kirakii, ware wawaya kadi waghawagha ghamaghamadi mmko kuburine naboni. ");
INSERT INTO aui_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Bi yagu wawaya Isrel damdi tanawa anaveredi sinirapeneni, bi gawara tana avineyina name anatore wiipikapikadi meme nuwaruririye sinamake da gemuriye sinitainairiredina. Bi wawaya kawakeekeedi gemuriye sinikayotaketowanedina, ware dagudagune siberana naboni nokona babada avinegha da Isrel siyibadenina raghanine sibera. Tagu, Yawe God awonewonem da tam bi nosinosim yawata anaberami da kiikiiwawo. ");
INSERT INTO aui_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Bi nosinosim tana anavineyi, tam wosina natunatum tana da inikiiwawo raghanina yam yawa damona inapiika da kunanagho kayekikim biiyadina. Tagu anabera da yana wiikiiwawo inimaragata, ");
INSERT INTO aui_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","da getana iiyabo rubana da yana wiibadana gwabinama inakabitavenina. Touna wosina kiiraviguve bare inayoghani. ");
INSERT INTO aui_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Tagu na touna tamananaki, bi touna na tagu natugu. Raghanina bera berona inabera, na aro anavereni ware tamada natuna aro yavereverenina naboni. ");
INSERT INTO aui_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Bi gerubana da yagu nuwayuyuna gwabinama anakabitavenina, ware Sol aberana naboni da yagu nuwayuyuna gwabinama akabitaveni bi tam kanagaware atorem da kunikiiwawo. ");
INSERT INTO aui_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Kam dam inatuwa wiiwoneni da inamake nonowa bi anabera da nosinosim sinikiiwawo waghata.’” ");
INSERT INTO aui_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Wasina bi Neitan, awaki sisiyidi mimeu kamone Yawe God ividebedi touna biidi, na tupadi Deivid biidi ivimaghamaghatara. ");
INSERT INTO aui_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Roro, raghanine kiikiiwawo nonowa siyakanikanibu siyanono wiiaviya kiiravine, na kwamra tane noko gabudarina ikabi na Deivid, Joab bi wiirouwa babadidi da kate Isrel wiiyogha tomotomogha iviporadi sikanibu da Ammon damdi teya siyirouwa. Noko raghanine sinagho da Ammon wiiyogha tomotomoyidi siviberotuwanonoyidi bi Raba kwanatuna simiiri gwagwara wiikenavivireni, bi Deivid na Jerusalem kwanatune imakae. ");
INSERT INTO aui_vpl VALUES ("S211_2","011_11_2","2SA","11","2","4","Gabudara tana ravidi gabudare, Deivid yana kenama igeghomiiri bi yana kiiwawo bare debane iyapeepewa. Bi ikitarorona da wasike iyiyeka na ikita, noko raghanine wasikena ivikubuwiipum na iyiyekayeka, da iyiimiiseyena mayeni nawaravi dadabuna iyakoghakoghataveni. Bi wasikena ivikepamara kirakii, na Deivid wawaya tana idaru da akowa iyakabi. Tomoyina iveramagha da iwona bo, “Noko Betsiba, Eliyam natuna, bi dam Hitti tomogha Uraiya wavinena.” Na Deivid sawariyonayona idarudi da wasikena siyakabi siyapiika, na wasikena ipiika Deivid biidi da yawata sikena bi muriye da iveramagha yana bareye. ");
INSERT INTO aui_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Muriye raghanina wasikena ikabibanani da imake na sisiya idaru iveramagha Deivid biidi iwona bo, “Tagu aropeya.” ");
INSERT INTO aui_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Wasina bi Deivid wara idaru Joab biidi iwona bo, “Dam Hitti tomogha Uraiya kuvipora inapiika tagu biidi.” Na Joab, ivipora ipiika Deivid biidi. ");
INSERT INTO aui_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Bi ipiika na Deivid ivitarakiiyaneni bo, “Joab da wiiyogha tomotomogha wasina bo gegha? Bi wiirouwa metagha yanono?” ");
INSERT INTO aui_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Wasina bi Deivid iwona bo, “Uraiya, kunagho yam bareye da kuniyawiitaveyana.” Raghanina kiiwawo barena ikuyoveni bi murine, na Deivid puyo ivipora inagho Uraiya biidi yana bareye. ");
INSERT INTO aui_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Bi geiyanagho yana bareyena, touna nama kiiwawo barena matamketane ikena, Deivid yana wiitamariyana damdi yawata. ");
INSERT INTO aui_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Na wawaya Deivid siwoneni bo, “Uraiya gegha iyanagho yana bareyena.” Na ivitarakiiyaneni bo, “Tam kubura rabarabama kupiika. Awaki kiiravine gekuyanagho yam bareyena?” ");
INSERT INTO aui_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Bi Uraiya iwona bo, “Wiiwaghasina Maragasina Dedewagina, bi Isrel da Jiuda damdi na kiregoru kamodiye samakamake. Yagu wiiyogha badana Joab da yana iyo damdi na warereye sitaki. Touna kiiravine na gerubana ayanagho yagu bareye bi ayakam da ayaniuna da wavinegu teya kayakena, gegha gerubana naboni ayaberana!” ");
INSERT INTO aui_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Na Deivid, Uraiya iwoneni bo, “Kata mma kumake, bi maram aniporam kunaveramagha.” Na noko gabudarine da wowonama na Uraiya, Jerusalemne imakae. ");
INSERT INTO aui_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Na Deivid, iviyoneni da yawata sikam da siniuna patapata, bi ibera da Uraiya iniuna neghanegha. Bi gegha, ravidiye na geiyanagho yana bareye bi ikanibu da yana gaware ikena Deivid yana wiitamariyana damdi yawata. ");
INSERT INTO aui_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Bi didibare na Deivid pepa igirumi bi Uraiya ivereni da iyakawari iyanagho Joab iyavereni. ");
INSERT INTO aui_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Pepa kamone na mma naboni iwona, “Uraiya wiirouwa matane kutore meme wiirouwa yaworaworana bi wiiyogha tomotomoyidi kuberadi da sinimuritayina touna gwabinama da inasirage bi inarabobo.” ");
INSERT INTO aui_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Joab na Raba kwanatuna iyaruruwiitete na iyakovi da aviya damdi yadi wiiyogha tomotomoyidi miisedi meme, na Uraiya noko gawarine ivipora inagho. ");
INSERT INTO aui_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Bi kwanatu kana tomotomogha sikanibu da Joab yana tomotomogha teya sivirouwa na Deivid yana wiiyogha tomotomoyidi viya da kate Uraiya dam Hitti tomogha yawata sivikasunughana. ");
INSERT INTO aui_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Raghanina Betsiba iwaiyana da moghanena Uraiya irabobo, na kiiravine idou. ");
INSERT INTO aui_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Bi duu raghanina ikovi murine, na Deivid wara idaru da wawaya tana iyakabi iyapiika yana bareye da wavinena tana. Wasina bi ivituveni da natuna tomogha. Bi gegha da Deivid naboni ibera na Yawe God geiyinuwamiiseyenina. ");
INSERT INTO aui_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Wasina bi Yawe God, peroveta Neitan idaru inagho Deivid biidi. Raghanina ipiika Deivid biidi na iviwaragututu iwona bo, “Kwanatu tana kamone tomotomogha yadi bata siyamakamake. Tomogha tana kiikiiwawona bi tana na moyamoyakina. ");
INSERT INTO aui_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Tomogha kiikiiwawona yana sip da kau sipeyara kirakii. ");
INSERT INTO aui_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Bi tomogha moyamoyakina na getana da awaki wasina sip wouna yagarina igimoni na touna kawagha bi touna da natunatuna teya gwabidiye iragata da iyamakamake. Kam siyikamvereyana, yana reduve iyaniniuna bi kate imadebane iyakenakena. Touna nigenige na iyabiyi da ware natuna wasike naboni. ");
INSERT INTO aui_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Gabudara tana kiiwaga iverakanibu tomogha kiikiiwawona yana bareye, na tomogha kiikiiwawona geiyakayoveni da yana sip bo kau tana iyakasunuyi bi iyitawoyi da kiiwaga iyakam. Bi gegha tomogha moumourina, tomogha moyamoyakina yana sip wouna yagarina ikabi da ikasunuyi bi ivitawoyi da kiiwaga ipiika yana bareye na ivereni ikam.” ");
INSERT INTO aui_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Noko raghanine na Deivid nuwanuwana ipughu kirakii noko tomoyina biidi na Neitan iwoneni bo, “Wiisuwona, Yawe God yamakamake bi kana waghawaghae awonawona da noko tomoyina mmko berana ibera na imiise da inarabobo. ");
INSERT INTO aui_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Bi mmko ibera na geiyinuwanuwaghaneni, noko kiiravine touna sip woudi yadi ruwamaruwa tomogha moyamoyakina inaveremayeni da inimiisana.” ");
INSERT INTO aui_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Wasina bi peroveta Neitan, Deivid iwoneni bo, “Tomoyina na tam! Mmko na metagha Yawe, Isrel kana God iwona, ‘Tagu avituborom da Isrel tupana kana kiiwawo, bi Sol yana maragatama aviyawiim. ");
INSERT INTO aui_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Bi yam bada yana bare averem, bi kate natuwavinena imamve atoura. Bi atorem da Isrel bi Jiuda kadi kiiwawo. Bi mmkodi bera meboda matamve siyagisikirakii, na memeda ayavere kirakiiyem. ");
INSERT INTO aui_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Awaki kiiravine Yawe God gamona kuvisinighiighiiyeni da matane bera berona kubera? Gamomve na Ammon damdi, dam Hitti tomogha Uraiya sikasunuyi bi wavinena kukabi da kuvirapeneni. ");
INSERT INTO aui_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Na noko kiiravine yam rakaraka kate genuwaruririye sinamakena, basuna gamogu gekuyakabisisireni bi Uraiya wavinena kukabi da kiiravimve.’ ");
INSERT INTO aui_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Mmko na metagha Yawe God yawonawona, ‘Anabera da tam wosina yam rakaraka kamonama na wawaya tana makepiropiro inapiikeni tam biidi. Da matakamomve bi natuwavinem anayouna da tomogha tana ririmve na anavereni, da yawata gabudara moramoraye sinimumurana. ");
INSERT INTO aui_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Tam wiikowoye tamumu kubera bi gegha da tagu gabudara moramoraye Isrel damdi tupadi naghodiye bi mmko berana anabera da inatubugha na matadima sinakita.’” ");
INSERT INTO aui_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Wasina bi Deivid, Neitan iwoneni bo, “Tagu tamumu abera Yawe God biidi.” Na Neitan iwona bo, “Yawe God yam tamumu inoghotataveni. Kate gekunarabobona. ");
INSERT INTO aui_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Bi tam, wonawaghata Yawe God gekuyakabikarawayeni bi mmko berana bero kirakiina kubera, na natum tomogha meko itubugha na inarabobo.” ");
INSERT INTO aui_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Neitan iveramagha yana bareye bi murine, na Yawe God, ibera da Deivid natuna meko Uraiya wavinena ivituvenina igubaga kirakii. ");
INSERT INTO aui_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Na Deivid noko raghanine, Yawe God biidi irupari simirina kiiravine. Bi iviiya da geiyakamkamna bi Irughu yana bare kamove bi nubabasuve na geyanagawara debane iyakenana, bi dobodobo debane iyakenakena. ");
INSERT INTO aui_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Yana bare wadubo kana dogadogara sinagho da simiiritawani bi sivimatipo da siyawona wiitoratorani iyageghomiiri, bi gegha Deivid isinighii da geyawata siyakamna. ");
INSERT INTO aui_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Taparoro tana ikovi murine, na simirina irabobo. Bi Deivid yana wiitamariyana sinaghara na gesiyawoneni da simira irabobo, kiiravine toudimani sivisisiya kabivivirana bo, “Raghanina simira yawayawiine iyamakamake, na Deivid biidi tayi sisiya bi geiyawaiyaneda. Na metagha tana woneni da simira irabobo? Kate bi bera tana inabera da tounamani iniberoni.” ");
INSERT INTO aui_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Raghanina Deivid ikita bi yana wiitamariyana siyikawaghamgham, na iyakovi da awaki itubugha, na ivitarakiiyanedi bo, “Da simira irabobo?” Na siwona bo, “E-ee, irabobo.” ");
INSERT INTO aui_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Wasina bi Deivid dobodoboma ikena geghomiiri da iviyeka, bi wane ghabughabuma sinina ikwamira da ivigararutaveyana. Bi inagho Kiregoru Kabikabikuwayine da Yawe God iyakabepepi. Noko murine, na iveramagha yana bareye bi kam kiiravine ivibaba na sepa da ikam. ");
INSERT INTO aui_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Bi yana wiitamariyana sivitarakiiyana bo, “Awaki kiiravine mmko naboni kwaberabera? Raghanina simira yawayawiine iyamakamake na kam kuvi iya da kudou, bi irabobo murine na kata kugeghomiiri da kukam.” ");
INSERT INTO aui_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Na Deivid iwona bo, “Simira yawayawiine iyamakamake na aviiya da adou, kiiravine anoghosi da Yawe God iyinuwanuwaghanegu bi simira iyakuyoveni iyamake. ");
INSERT INTO aui_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Bi kata irabobo, na awaki kiiravine aniiya? Da simira anakabiwiiveramayi inayawamagha? Gabudara tana kate ananagho touna biidi, bi touna geinaveramagha tagu biidina.” ");
INSERT INTO aui_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Wasina bi Deivid wavinena Betsiba ivinuwapikepikeni, na inagho da yawata sikena. Bi iropeya da ivituwa natuna tomogha na Deivid iviwaghawaghayeni Solomon. Yawe God, Solomon ivinuwayuyuneni kiiravine, ");
INSERT INTO aui_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","na peroveta Neitan idaruni inagho da Deivid iyawoneni da simirina waghawagha ivereni Jedidiya. ");
INSERT INTO aui_vpl VALUES ("K12_10","012_2_10","1KI","2","10","11","Kiiwawo Deivid Isrel iyibadeni raghanine, dagudagune na bodu yadi 7 Hebron kwanatune imakae bi muriye na Jerusalem kwanatune bodu yadi 33 imakae. Da noko kedane na bodu 40 Isrel ivibadeni. Bi irabobo na Jerusalem kwanatuna kamone nosinosinanakim yawata sidogudi. ");
INSERT INTO aui_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Wasina bi Solomon ivikiiwawo, da tamananaki kana gaware Isrel ivibadeni bi God ibera da yana wiibadana ivimaragata. ");
INSERT INTO aui_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Solomon, Yawe God ivinuwayuyuneni na tamananaki Deivid yana wonawiiyoyowana tupadi ikivina. Bi gegha da keda tane na Yawe God geiyakivina yaporina. Touna ribiribi iunugha da ipuyo naboni suwara, god wiiwiiyaba yadi suwara gabugabuna debadiye da insens igibu ware wawaya siyaberabera na naboni. ");
INSERT INTO aui_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Raghani tana Solomon inagho Gibiyon kwanatune da puyo peyaridi 1,000 naboni isuwara Yawe God biidi, basuna suwara gabugabuna gawarina ghamana na noko kuburine. ");
INSERT INTO aui_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Yawe God nubabasu tana mimeu kamone ividebena mayeni Solomon biidi Gibiyon kwanatune, bi ivitarakiiyaneni bo, “Awaki kwakayokayoveni? Awaki kiiravine kunibaba na anaverem.” ");
INSERT INTO aui_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Solomon iwonabodeni iwona bo, “O Yawe yagu God, tam tamagunaki kanagaware kutoregu da anikiiwawo, bi gegha da tagu wawaya ededa kawagha na geayakovi da metagha wawaya anibadena yaporidi. ");
INSERT INTO aui_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Bi tagu kata mma yam wawaya vinevineyidi kamodiye, toudi sikoroto kirakii da gerubana anakabiyavidina. ");
INSERT INTO aui_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Gerubana iiyabo mmko yam damna ghamana tanaduma inibadedina. Na nuwagiura miisedi kuveregu da yam wawaya anibadena wiimasiyedi bi anakovi da awaki miisena bi awaki berona.” ");
INSERT INTO aui_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Solomon nuwagiura kiiravine ivibaba, na Yawe God ivinuwamiise. ");
INSERT INTO aui_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Na Yawe God iwona bo, “Tam gegha makewiiguri kiiravine kuyibabiigu, bo gegha mane peyaridi da sawara bo kam aviya wiikasunughana kiiravidiye kuyibabiigu. Gegha, tam nuwagiura miisedi kiiravidiye kuvibabiigu da ayaverem bi yagu wawaya rubana da keda rotomanine kunibadedi. ");
INSERT INTO aui_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Na awaki kiiravine kuvibaba na anaverem! Tagu nuwagiura miisedi da akowa anaverem, genaboni wawaya naghove sikabina bo wawaya muriye sinakabimayenina naboni. ");
INSERT INTO aui_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Bagune gemoura bo waghawagha ghamadi kiiravidiye kuyibaba, bi gegha da toudi sawaridi na bada anaverem. Patana yawayawiim kunamakamakena, getana meko kiiwawona mane bo waghawagha ghamana inakabi ware tam naboni. ");
INSERT INTO aui_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Bi meboda yagu sisiya kunawaiyana da yagu gwara da sira kunakabisisiredi ware tamamnaki Deivid ibera na naboni, na anaberam da bodu peyaridi kate kunamakae.” ");
INSERT INTO aui_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Raghani viya murine na keda wasiwasike yadi bata piropiro tana basudiye na sipiika kiiwawo biidi bi sivibabiini da yadi piropiro iyakabiwiirotomani. ");
INSERT INTO aui_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Keda wasike dagudaguna iwona bo, “Kiiwawo, mmko wasikena da tagu na bare tanagha kamakamake. Bi kayamakamake patapata raghanine, na avituwa. ");
INSERT INTO aui_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Gabudara aroba murine na mmko wasikena bada ivituwa. Toumiiduma, yama bata kawagha name noko barena kamone, getana da iiyabo nama. ");
INSERT INTO aui_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Wasina bi nubabasu tana kamone ikenawamira na yana pepeya ikenatawani da ikenunuyi. ");
INSERT INTO aui_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Tagu akenayakuka na igeghomiiri da yagu pepeya tomogha ririguve ikabi. Bi yana pepeya raborabobona ririguve ivikeneni bi yagu pepeya ikabi da yawata siviragoba. ");
INSERT INTO aui_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Didibare ageghomiiri da natugu ayisusu bi gegha, pepeyina irabobo. Wasina bi raghani diidibara yeghanine akitarukunukunuveni, da touna getagu natugu.” ");
INSERT INTO aui_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Bi wasikena tana iwona bo, “Gegha! Yawayawiina na tagu natugu bi raborabobona na tam natum!” Bi gegha wasike dagudagune ivituwa na iwona wiimaragata bo, “Raborabobona na tam natum bi yawayawiina na tagu!” Wasina bi kiiwawo naghone naboni siyikawakeereyana. ");
INSERT INTO aui_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Na Solomon iwona bo, “Wasina, mmko wasikena yawona da ‘Pepeya raborabobona na tam, bi yawayawiina na tagu,’ bi noko wasikena tana yawona da, ‘Gegha! Yawayawiina na tagu bi raborabobona na tam.’” ");
INSERT INTO aui_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Wasina bi kiiwawo yana bagibagi damdi iwonedi bo, “Seri kopiikeni konaveregu.” Na seri sikawari sipiika kiiwawo biidi. ");
INSERT INTO aui_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Bi kiiwawo iwona bo, “Pepeya yawayawiina korigha seseri da bata! Nawana wasike tana kovereni bi nawana bada wasike tana kovereni.” ");
INSERT INTO aui_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Noko pepeyina sinananaki waghata ivinuwayuyunena kirakiiyeni, na douma ikabida iwona bo, “Oo bada ghamam, pepeyina gekunakasunuyina, noko wasikena kovereni!” Bi wasikena tana iwona bo, “Gegha, pepeyina korigha seseri da bata. Da gegha tagu bo touna natuna.” ");
INSERT INTO aui_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Wasina bi kiiwawo iwona bo, “Pepeyina gekonakasunuyina, bi meko wasikena yakayokayoveni da pepeyina inamake na touna kovereni, basuna touna na sinananaki waghata.” ");
INSERT INTO aui_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Raghanina kiiwawo noko yana sisiyina Isrel damdi siwaiyaneni, na sakovi da God nuwagiura miisedi ivereni da piropiro iyakabiwiirotomana, na sikabikarawayena kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Jiuda da Isrel damdi na sikoroto kirakii, ware egha kikire naboni. Toudi kam da rarima rubarubadi na siyinuwamiise. ");
INSERT INTO aui_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Solomon dam tupadi, Euprate rarimina ghamane idaguni bi iyowogha inagho Pilistain damdi yadi kubure da Ijipt kubura kana wiibarabarate wareregubugubura yana nawae iyibadedi. Mmkodi damdi na yadi puyo siyiipora kiiwawo Solomon biidi, bi siyakabikabisisireni raghanina yawayawiine iyamakamakena. ");
INSERT INTO aui_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","Raghanina Solomon yawayawiine iyamakamake, na wawaya tupadi Jiuda da Isrel kamodiye nuwaruririye simakae, getana piropiro ghamadi siyabanana. Dan kwanatune kikiramutumutuba yana nawae bi iyowogha inagho Biasiba meyagiine wareregubugubura yana nawae, rakaraka nununagha toudimani siyakoyakoyagha mayedi, ere yadi bare bi ere yadi kwabu. ");
INSERT INTO aui_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Naghove, kiiwawo Deivid yawayawiine iyamakamake, na yana wiiturana waratetena na kiiwawo Hiram. Touna Taya meyagiina damdi iyibadedi, na raghanine iwaiyana da Deivid natuna Solomon na Isrel damdi yadi kiiwawo wouna, na sawariyonayona idarudi sinagho da siyikiikiiveni. ");
INSERT INTO aui_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Wasina bi Solomon wara iwonataveni iveramagha Hiram biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","“Tam kwakovi da metagha tamagunaki Deivid dam tupadi sivitumpipineni na iyiaviyedi, noko biidi gerubana da kabepepa barena iyayoghani da Yawe God iyakabepepina. Dagudagune na iyikoyakoyagha da Yawe God iyiwiiteni da kana aviya tupadi iyageiwayidi. ");
INSERT INTO aui_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Bi katana Yawe yagu God nuwaruriri iveregu tupana ivikenaviviregu. Na geere kagu aviya bo getana piropiro ghamadi. ");
INSERT INTO aui_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Na Yawe God tamagunaki iwoneni bo, ‘Tagu natum anatore inikiiwawo kam gaware bi touna kabepepa barena inayoghani da kagu waghawagha inakabepepi.’ Noko biidi anuwanuwagiura da kabepepa barena kata anayoghani da Yawe yagu God anakabepepi ware tamagunaki Deivid iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Na yam bagibagi wawayidi kudarudi sinanagho Lebinonma da kii kana waghawagha sida kiiraviguve sinataragha, bi yagu bagibagi damdi na yawata sinabagibagi. Touda takovi da tami Saidon dammi kii tarayidi kwakowa kirakii, getoumii Isrel dammii naboni na kuwonegu da yam bagibagi wawayidi mane viya rubana animiisanedi na noko rubane anaveredi.” ");
INSERT INTO aui_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Solomon bodu aroba kamone Isrel damdi ivibadedi, bi bodu 4 kamone nawaravi wiibatana kana waghawagha Jiv, na Yawe God yana bare yoghanina idaguni. Nosinosinanakim yadi gabudare Isrel damdi Ijipt kubura sikanibutaveni, bi bodu 480 nada sikovi bi Solomon mmko bagibagina idaguni. ");
INSERT INTO aui_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","Toudi yoghana kana akima na gawara meme dobodobove sabori na tupadi name sakabununagha, bi irabaraba kirakii da meme barena siyayoghayoghanina, da yoghana gawarine na getana iiyabo amama da karuwakoya bo sisiruma akima iiyabori bo iyataraapapi da kwarituna siyawaiyana. ");
INSERT INTO aui_vpl VALUES ("K16_11","012_6_11","1KI","6","11","12","Wasina bi Yawe God ivisisiya kiiwawo Solomon biidi noko barena iyayoghayoghani kiiravine, iwona bo, “Memeda yagu sisiya kunawaiyana bi yagu gwara kunakivina da awaki awonemna kunabera, na metagha tamamnaki Deivid avisuwoneni na kiiravine naboni anabera. ");
INSERT INTO aui_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Tagu yagu wawaya Isrel kamobasudiye bare meko kwayoghayoghanina kamone anamake, bi geanakuyovedina.” ");
INSERT INTO aui_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Wasina bi kiiwawo Solomon, God yana bare iyayoghayoghani na ivikovini. ");
INSERT INTO aui_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Wasina bi kiiwawo Solomon, Isrel dogadogara, bi dam kadi babada da bare kadi babada iviyonedi da siyapiika Jerusalemma, Deivid yana kwanatu kana waghawagha Zaiyon, bi name Yawe God yana Wiiwaghasina Maragasina Dedewagina siyakawari siyarughu God yana bareye. ");
INSERT INTO aui_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Raghanina Isrel dogadogara tupadi siverakanibu na prist, Wiiwaghasina Maragasina Dedewagina sirukabepi. ");
INSERT INTO aui_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","Bi Livai kana damma tomotomogha da prist, Wiiwaghasina Maragasina Dedewagina da Kiregoru Kabikabikuwayina da kana sawara kabikabikuwayidi sikawara sinagho God yana bare kamone. ");
INSERT INTO aui_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Kiiwawo Solomon da Isrel damdi tupadi nama Wiiwaghasina Maragasina Dedewagina naghone sivitaghomidi bi sip da kau peyaridi siyasuwasuwara, bi sipeyara kirakii da gerubana siyakabiyavidina. ");
INSERT INTO aui_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Wasina bi prist, Wiiwaghasina Maragasina Dedewagina sikawari sirughu God yana bare kamone da Gawara Kabikabikuwaya Kirakiine, da Serubim mabe rogudiye sitore. ");
INSERT INTO aui_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Raghanina prist, Gawara Kabikabikuwayina sikanibutaveni, na karekarewa God yana bare ivibonuvi. ");
INSERT INTO aui_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","Wasina bi karekarevina prist igududi da gerubana yadi bagibagi siyabera basuna Yawe God yana kiniwa bare irughuwoneni. ");
INSERT INTO aui_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Wasina bi kiiwawo Solomon, Yawe God yana suwara gabugabuna gawarina naghone imiiri bi Isrel damdi tupadi na murine siyamiimiiri. Bi imana irukabekabepa abame, ");
INSERT INTO aui_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","da mma naboni irupari, “O Yawe Isrel kana God, getana da god tam naboni abama kamone bo mma kubura debane. Tam nonowa kwabera da metagha kwiisuwona na naboni, tam nonowa yam wawaya kwiinuwayuyunedi, iiyawogha nuwanuwadi tupadima sakabikabisisiremna. ");
INSERT INTO aui_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","Bi rubana God, kubure inamake? Gegha! Abama tupana geiyaragata kirakii da inakamuwanim, Bada! Na mmko kabepepa barena ayoghanina, memeda getam yam makamake gawarina! ");
INSERT INTO aui_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","Yawe yagu God, tagu na yam wiitamariyana. Na yagu pari kuwaiyana, da kata awaki kiiravine iibabiim na kuveregu. ");
INSERT INTO aui_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","Tam mmko barena kiiravine mma naboni kuwona, ‘Kagu waghawagha nama inamakae.’ Na mmko kabepepa barena gabudara da nubabasu kunakoyakoyayi. Kuwaiyanegu raghanina anamiiri karona mmko barene da anaruparina. ");
INSERT INTO aui_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Yagu pari da yam wawaya Isrel yadi pari kuwaiyana raghanina kanakitarorona da mmko gawarina kanakita bi kanarupari tam biidina. Yam makamake gawarinama abame bi yama pari kunawaiyana na yama berona kunoghotatavemii. ");
INSERT INTO aui_vpl VALUES ("K18_41","012_8_41","1KI","8","41","42","Raghani muriye, kubura wiibata damdi iiyawogha na gegha Isrel damdi, kam waghawagha ghamana, yam maragata da yam bera ghamaghamadi sisiyidi sinawaiyana, na yadi kubura rabarabae bi sinapiika da sinakabikuwayem bi yam Bare sinakita bi tam biidi sinarupari. ");
INSERT INTO aui_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","Yam makamake gawarinama abama kamone, bi yadi rupari kuwaiyana da yadi kayowana sinibaba na kuveredi. Wasina bi dam tupadi kubure sinakovi bi sinakabepepim ware toumii yam wawaya Isrel dammii kaberaberana. Toudi sinakovi da mmko barena ayoghani, na touna tam kabepepim kana gawara.” ");
INSERT INTO aui_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Raghanina Siba damdi yadi kiiwawo wasikena iwaiyana, da wawaya tupadi Solomon sakowa kirakiiyeni bi kate metagha Yawe God iyakabikabikarawayeni na iwagawaga ipiika touna biidi, bi yana wiina da Solomon yana nuwagiura miisedi iyaruyagha na wiitarakiiyana bagibagidi peyaridi ivitarakiiyaneni. ");
INSERT INTO aui_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Touna bagibagi damdi korotodi irutayinidi da kate kamel peyaridi kam kadi wiimetewa miisedi, gould peyaridi da akima wiinuwakayowanidi sikawara. Raghanina Solomon teya sivibanana, na wasikena yana noghota tupadi iyanoghonoghota na sivisisiyana. ");
INSERT INTO aui_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Na Solomon wiitarakiiyana tupadi iwonabodeyana, getana awaki iyapiropiro da wasikena iyawonawiiyeveveni. ");
INSERT INTO aui_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Wasina Siba yadi kiiwawo wasikena, Solomon yana nuwagiura miisedi iwayana, bi kate kiiwawo barena meko iyoghani na ikita. ");
INSERT INTO aui_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","Bi kate bada ikita da kam kiinabonabo debadiye, bagibagi damdi kadi kunagha miisedi, bi kate redu verevereyana da suwara gabugabunidi Yawe God yana bareye Solomon isuwara ikitadi, na beradi tupadi kiiravidiye na ivisoko kirakii. ");
INSERT INTO aui_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Na wasikena kiiwawo Solomon mma naboni iwoneni, “Yagu kubura waghate, na yam nuwagiura miisedi da yam bera ghamaghamadi peyaridi kiiravidiye na awaiyana bi kata akovi da nokodi sisiya na wiisuwona! ");
INSERT INTO aui_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Ghuyoghuyone, na nokodi sisiya geayitumaghanedina bi kata apiika da mataguma akitakita. Yam nuwagiura miisedi da yam moura na siragata kirakii, genaboni awaki siwoneguna! ");
INSERT INTO aui_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","Yam wawaya sinuwamiise kirakii bi yam bagibagi wawayidi gabudara patepatena naghomve samiimiiri, da yam nuwagiura miisedi sawaiyana. ");
INSERT INTO aui_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Tagu, Yawe yam God akabekabepepi, tam kiiravimve na yinuwamiise, na itorem da yana wawaya Isrel kunibadedi. Basuna yana nuwayuyuna makewaghawaghasina Isrel damdi biiyadi kiiravine, na ibera da kuvikiiwawo, bi yana wawaya keda miisena da rotomanine kunibadedi.” ");
INSERT INTO aui_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Kiiwawo Solomon, na Ijipt kana kiiwawo natuna irawayi, bi gegha da kubura wiibata wasiwasike bada korotodi ivinuwayuyunedi. Touna Moab, Ammon damdi, Idom, Saidon da Hitti wasiwasike mududi irawayidi. ");
INSERT INTO aui_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Naghove Yawe God Isrel damdi sisiya bagibaginama nokodi dam kiiravidiye mma naboni iwona, “Tami gekonarawayidina, basuna konarawayidi na toudi nuwanuwami sinatainawamira da yadi god konakayokivinidi.” Bi gegha da, bagune noko sisiyina Solomon touna nokodi wasiwasike ivinuwayuyunena kirakiiyedi. ");
INSERT INTO aui_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Kiiwawo Solomon natuwavinena yadi 700, toudi na kiikiiwawo natunatudi. Bi bada yana bagibagi wasiwasikedi yadi 300, toudi naboni natuwavinena mududi. Mmkodi wasiwasike nuwanuwana sitayinawamiri da Yawe God kivinina ikabitore. ");
INSERT INTO aui_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Raghanina kiiwawo Solomon imoraba, na natuwavinena nuwanuwana sitayinawamiri da god mududi iyakivina, touna gegha wiisuwona Yawe God kawagha iyakivini ware tamananaki Deivid ibera na naboni. ");
INSERT INTO aui_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Touna Saidon damdi yadi god wasikena, Astoret bi Ammon damdi yadi god, bero kirakiina Molek iyapeepetedi. ");
INSERT INTO aui_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Jerusalem kwanatune raghani matana yana nawae koya debane, kiiwawo Solomon, Moab damdi yadi god bero kirakiina, Samos, da Ammon damdi yadi god bero kirakiina, Molek, kiiravidiye na kabepepa gawaridi iyoghana. ");
INSERT INTO aui_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Bi bada kabepepa gawaridi iyoghana natuwavinena kiiravidiye da name insense siyagabugabuna bi yadi god biidi siyasuwasuwara. ");
INSERT INTO aui_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Naghove, Yawe God raghani bata ividebena mayeni Solomon biidi, bi iwonawiiyoyowaneni da gegha god mududi iyakivinidi, bi Solomon, God yana sisiya geiyawaiyaneni, touna Isrel damdi yadi God imiirikubuteni da geiyakivinina. Na Yawe God nuwanuwana ipughu Solomon biidi. ");
INSERT INTO aui_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Wasina Yawe God mma naboni Solomon iwoneni, “Tam, yagu wiiwaghasina maragasina gekuyakivini da yagu gwara gekuyakabisisireni kiiravine, na iisuwona da yam wiibadana Isrel damdi gwabidiye anakabitaveni bi yam bagibagi tomoyina tana anavereni. ");
INSERT INTO aui_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Bi gegha da tamamnaki Deivid avinuwayuyuneni, na gegha yam wiibada kata yawayawiimve kwamakamake na raghanine anakabitavenina. Gegha, noko wiibadana na natum yana raghaniye anakabitaveni. ");
INSERT INTO aui_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Bi gegha dam Isrel tupana yana wiibadanama anakabitavenina; Tagu yagu wiitamariyana Deivid da Jerusalem kwanatuna, meko avineyi da rapeguve na noghosidiye dam tanagha yana wiibadana rogune anakuyoveni.” ");
INSERT INTO aui_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Kiiwawo Solomon yana bagibagi tomoyina ghamana tana kana waghawagha Jeroboam, Nebet natuna, yana kwanatu na Jereda, Ifreim kubura kamone bi sinananaki na kwabukwaburina, kana waghawagha Jeruwa, touna igeghomiiri da kiiwawo Solomon iviaviyeni. ");
INSERT INTO aui_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","Waragututuna mma naboni da metagha kiiwawo iviaviyeni. Solomon, Jerusalem kwanatune raghani matana yana nawae tanawa iyasousouwiipika da kwanatu papane bonagha iyagudugudu bodaboda Jerusalemne, tamananaki Deivid yana kwanatu kamone. ");
INSERT INTO aui_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Jeroboam na tomogha akakovina bi raghanina kiiwawo Solomon ikita bi Jeroboam na tomoyina akakovina bi bagibagi tomoyina miisena, na itore da dam Ifreim da Manasa toudina Jousep nosinosina kamodima bagibagi wawayidi tupadi iyakoyayidi. ");
INSERT INTO aui_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Gabudara tana raghanina Jeroboam, Jerusalem kwanatuna ikanibutaveni iyanono, na kedae peroveta tana ibanani, kana waghawagha Ahija touna yana meyagii na Sailo. Toudi yadi bata kawagha wawa kuburidiye bi Ahija na kwama wouna iyakotekoteni. ");
INSERT INTO aui_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Ahija noko kwamana wouna ikabitaveni bi itaina gosigosiri da pinipinimidi yadi 12 situbugha. ");
INSERT INTO aui_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Wasina bi Ahija, Jeroboam iwoneni bo, “Mmkodi kwama pinipinimidi yadi 10 kabidi kiiravimve. Basuna Yawe, Isrel kana God mma naboni iwona, ‘Tagu, wiibada Solomon imanama anakabitaveni, bi dam yadi 10 tam anaverem. ");
INSERT INTO aui_vpl VALUES ("K111_32","012_11_32","1KI","11","32","33","Basuna Solomon imiiri kubutegu, bi idagu Saidon damdi yadi god wasikena Astoret, Moab damdi yadi god, Samos da Ammon damdi yadi god Molek iyakabekabepepidi. Touna yagu keda geiyakivini da mataguve miisena iyabera bi kate yagu sisiya da gwara geiyawaiyana ware tamananaki Deivid ibera na naboni. Bi gegha da yagu tamariyana Deivid noghosine na Isrel kana dam tupana kamonama na Jerusalem kwanatuna avineyi da kiiraviguve, na noko biidi dam tanagha anakuyoveni da Solomon yana wiibadana rogune inamakae. ");
INSERT INTO aui_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","Bi Solomon natuna yana wiibadana raghanine dam Isrel anayarayi bi kamonama na dam yadi 10 na tam anaverem.’” ");
INSERT INTO aui_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Noko kiiravine kiiwawo Solomon ivimatipo da Jeroboam iyakasunuyi bi gegha da ivera inagho kiiwawo Sisak biidi Ijipt kubure bi name imakae patana da Solomon irabobo. ");
INSERT INTO aui_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Solomon, Jerusalem kwanatune iyiikiiwawo bi dam Isrel tupana bodu 40 kamone ivibadedi. ");
INSERT INTO aui_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Raghanina irabobo, na tamananaki Deivid yana Kwanatuve sidogu. Wasina bi Rehoboam, tamananaki Solomon kana gawara ikabi da ivikiiwawo. ");
INSERT INTO aui_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Rehoboam inagho Sikemma, meme Isrel damdi tupadi siyiikoyakoyagha da siyatore iyikiiwawo. ");
INSERT INTO aui_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Raghanina Nebet natuna Jeroboam, iiyabo naghove Solomon nagharina ivera inagho Ijipt kubure iyamakamake, bi mmko sisiyina iwaiyaneni, na Ijipt kuburama iveramagha. ");
INSERT INTO aui_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Bi kikiramutumutuba yana nawae damna siviyoneni ipiika, bi touna da wawaya tupadi sinagho kiiwawo Rehoboam biidi bi siwoneni bo, ");
INSERT INTO aui_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“Tamamnaki Solomon na ghakighakina bi bagibagi vitadi iyavereveremii, memeda mmkodi vita kunabera sinatekateka da yama makamake yawadi sinamiise, na toumii yam wiibadana rogune kanamakae.” ");
INSERT INTO aui_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Rehoboam iwonabodedi bo, “Konagho bi gabudara aroba murine na koveramagha da yami sisiya kiiravine anawonabodemi.” Na wawaya tupadi siveramagha sinagho. ");
INSERT INTO aui_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Wawaya sugetaveni murine, na Rehoboam babada magumaguridi yawata sivisisiya, nokodi iiyawogha naghove Solomon yawayawiine iyamakamake, bi siyiiwiitenina. Touna ivitarakiiyanedi bo, “Vikodi wawaya metagha anawonabodedi?” ");
INSERT INTO aui_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Babada magumaguridi siwona bo, “Memeda wawaya wiiwiitedi kunakayoveni, na awaki kiiravine sibabiim na kubera, nokove na yam wiibadana rogune sinamake waghata.” ");
INSERT INTO aui_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Bi gegha, Rehoboam magumaguridi yadi sisiya geiyawaiyanedi, bi inagho da tomotomogha woudi yawata sivisisiya, mekodi yawata siragata patapata bi kata siwiitenina. ");
INSERT INTO aui_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Ivitarakiiyanedi bo, “Metagha anabera? Mmkodi wawaya sawonewonegu bo, ‘Yama bagibagi kubera inatekateka, gegha tamamnaki yana raghaniye naboni.’ Awaki wonabodeyaninama anawonedi?” ");
INSERT INTO aui_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Tomotomogha woudi siwonabodeni bo, “Mma naboni sivibabiim, ‘Yama bagibagi kubera inatekateka,’ na kuwonedi, ‘Tagu tomogha ghakighakigu, gegha tamagunaki naboni! ");
INSERT INTO aui_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Tamagunaki piropiro ghamadi iveremi, bi gegha, tagu piropiro ghamanakidi anaveremi! Touna kwaro bagidima iyawakiwakirimi bi tagu na kwaro iyiyodima anawakirimi.’” ");
INSERT INTO aui_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Gabudara aroba murine, Jeroboam da wawaya tupadi siveramagha da kiiwawo yana wonabodeyana siyawaiyaneni, metagha iwonedi na naboni sibera. ");
INSERT INTO aui_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Bi gegha da, kiiwawo Rehoboam babada magumaguridi yadi wonawiiyoyowana geiyawaiyana, bi sisiya ghakighakidima wawaya iwonedi. ");
INSERT INTO aui_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Tomotomogha woudi yadi wonawiiyoyowana touna ikivini, na wawaya iwonedi bo, “Tagu tomogha ghakighakigu, geware tamagunaki naboni! Tamagunaki piropiro ghamadi iveremi, bi gegha da taguna piropiro ghamanakidi anaveremi! Touna kwaro bagidima iyawakiwakirimi, bi tagu na kwaro ere iyiyodima anawakiwakirimi!” ");
INSERT INTO aui_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Yawe God ikayoveni da mma naboni iyatubugha kiiravine, na Rehoboam wawaya yadi sisiya geiyawaiyana. Rorowainagha Yawe God ivisisiya Nebet natuna Jeroboam biidi, Sailo kwanatuna kana peroveta Ahija yana sisiyae. Na raghanina Yawe God kiiwawo Rehoboam ivigesiyeni da wawaya yadi sisiya geiyakivini, na Ahija metagha ivisisiya na naboni itubugha. ");
INSERT INTO aui_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Wasina bi Isrel damdi tupadi sikita bi kiiwawo yadi sisiya geiyawaiyaneni, na siwona bo, “Toumii gegha Jese natuna Deivid yana rakaraka muduna! Toumii getouna kana dam muduna! Isrel dammi kokayo tana veramagha yada kubure yada kubure, bi Deivid nosina Rehoboam yana wawaya waghata inibadedi!” Wasina bi Isrel damdi siveramagha sinagho yadi kubure yadi kubure. ");
INSERT INTO aui_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Bi gegha da, Rehoboam patana Isrel damdi iiyawogha Jiuda kubura kwanatudiye siyamakamake na iyiibadedi. ");
INSERT INTO aui_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Wasina bi kiiwawo Rehoboam yana bagibagi damdi kadi bada kana waghawagha Adoniram ivipora inagho Isrel damdi iyatayina wamiridi da kiiwawo yana wiibadana rogune siyarughumagha, bi gegha Isrel damdi sigeghomiiri da akimama sirouvi sikasunuyi. Raghanina kiiwawo Rehoboam warana iwaiyaneni na yana seriyotye igeru bi naghara iverainagho Jerusalem kanatune. ");
INSERT INTO aui_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Noko raghanine inagho da kata, na Isrel damdi kikiramutumutuba yana nawae, na geyadikayowana da Deivid nosinosina sinibadedina. ");
INSERT INTO aui_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Raghanina Isrel damdi siwaiyana da Jeroboam, Ijipt kuburama iveramagha, na dughu tana siviyoneyoneni bi noko dughuna kamone Jeroboam sitore da Isrel tupana kana kiiwawo. Wasina dam Jiuda touna kawagha Deivid nosinosina yadi wiibadana rogune imakae. ");
INSERT INTO aui_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Wasina bi kiiwawo Jeroboam, Ifreim koyakoya kubura kamone Sikem kwanatuna iyababareni na akimama igari wiikenavivireni, bi name imakae. Bi nama itouya na inagho bada Penuel kwanatuna akimama igari wiikenavivireni da iyababari. ");
INSERT INTO aui_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Gabudara tana Jeroboam mma naboni iyanuwanuwagiura na tounamani iwonena mayeni, “Wawaya tupadi na sanagho Jerusalemma, da Yawe God yana bareye yadi puyo sasuwara Bada biidi. Awaki bada inatubugha memeda sinamiiri karona Deivid yana rakaraka biiyadi bi nuwanuwadi sinawamiri da yadi bada ghamana, Rehoboam, Jiuda kana kiiwawo biidi? Toudi sinakasunuyigu bi kagu gaware sinatore da inikiiwawo.” ");
INSERT INTO aui_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Wasina bi kiiwawo Jeroboam awaki iyabera kiiravine na yana wawaya akakovidi yawata sivisisiya ikovi, na kau wotudi bata gouldma iberadi. Bi wawaya iwonedi bo, “Jerusalemma naghona, tami Isrel dammi biiyadi na ipiropiro kirakii, na yami god makatanidina, toudi Ijipt kuburama sikabikanibuvemi.” ");
INSERT INTO aui_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Na kau wotudi gouldma ibera, da tana Betel kwanatune itore, bi tana Dan kwanatune. ");
INSERT INTO aui_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Wasina bi mmko kedane na wawaya tamumu sibera. Bi kate bada siyanono Dan kwanatune kau gouldma beraberana siyakabekabepepi. ");
INSERT INTO aui_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Jeroboam kate bada kabepepa gawaridi koya debadigha iyoghana, bi dam wiibatama tomotomogha ivinegha da naboni prist, bi toudi na gegha Livai kana dam kamonama. ");
INSERT INTO aui_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Omri natuna Aheb na Yawe God matene na bera bero kirakiidi ibera, geware kiikiiwawo tupadi mekodi naghone sivibadana naboni. ");
INSERT INTO aui_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Touna inoghosi da wiitamumu na getana awaki, ware Nebet natuna Jeroboam tamumu iberana naboni. Bi bera bero kirakiina ibera na Saidon damdi yadi kiiwawo Eetbaal natuna wasike Jesibel irawayi bi Baal iyapeepeteni. ");
INSERT INTO aui_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Aheb kabepepa barena tana Baal kiiravine Sameriya kwanatune iyoghani da suwara gabugabuna gawarina kamone ibera. ");
INSERT INTO aui_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Bi kate bada god wasikena Asera kabepepina kiiravine kana kiitupo ikabiwiimiiri. Aheb bera peyaridi ibera da Yawe, Isrel kana God ivinuwapughupughuni, geware kiikiiwawo naghone sivibadana naboni. ");
INSERT INTO aui_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Peroveta tana kana waghawagha Elaija, bi yana kwanatu na Tisbi, Giliyed kubura kamone, inagho kiiwawo Aheb biidi bi iwoneni bo, “Wiisuwona, Isrel kana God, Yawe na Makewaghawaghasina bi tagu na yana wiitamariyana. Bi kana waghawaghae tagu awonawona da geamra bo youra sinayowogha, mmkodi bodu sapiipiikana kamodiye patana da gamogu anatore na wasina.” ");
INSERT INTO aui_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Wasina bi Yawe God, Elaija iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Kunagho da Jerepet meyagiine kunamakae, Saidon kwanatuna ririne. Name na kwabura tana awoneni da tam inikanim.” ");
INSERT INTO aui_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Na Elaija inagho Jerepetma. Bi raghanina iverakanibu meyagii matamketane, na kwabura tana ikita kiiraberabega iyatoghutoghura, na ivitarakiiyaneni bo, “Rubana bo gegha da rarima gisina kiyabu kamone kuyakawari kuyapiika da ayaniuna?” ");
INSERT INTO aui_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Bi wasikena itouya iyanono rarima kabina biidi, na ikwatukwavini bo, “Bi kate bred viya teya kuyouna da anakam.” ");
INSERT INTO aui_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Bi wasikena iwona bo, “Yawe yam God makewaghawaghasina kana waghawaghae awonawona da wiisuwona tagu getana da bred gwabiguve. Tagu gwabiguve na parawa yoghoyoghona kaboma kamone da kate oliv oil kabikabiwiitaghoma gisina kamone. Tagu kiiraberabega atoghutoghura bi anakawara anaveramagha bareye da awaki pinimina gwabiguve na anakabununayi, natugu teya kiiravimiiye da kanakam, bi muriye na vitonana inirabobomii.” ");
INSERT INTO aui_vpl VALUES ("K117_13","012_17_13","1KI","17","13","14","Bi gegha Elaija, wasikena iwoneni bo, “Gekuninuwapoyana! Yawe, Isrel kana God iwona da, ‘Parawa da oliv oil na nonowa yami kabikabiwiitaghoma kamodiye sinamakamake patana da Yawe amra inipora na pei sinagogo maghana raghanine.’ Na kunagho da metagha kuvisisiya na naboni kubera, bi dagudagune na bred gisina kiiraviguve kugabuni da kawari piika. Bi muriye na kabiwiiririyina kabununayi, tam bi natum teya kiiravimiye.” ");
INSERT INTO aui_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Wasikena inagho da metagha Elaija iwoneni na naboni ibera, na Elaija da kwabura bi yana rakaraka yawata gabudara patepatena na kam siyakamkam. ");
INSERT INTO aui_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Bi metagha Yawe God ivisuwona, na naboni da Elaija metagha ivisisiya na nunune, da parawa kabomina geiyakovi bi oliv oil kabikabiwiitaghome geiyamamana. ");
INSERT INTO aui_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Raghani viya sikovi murine, na noko kwaburina iiyabo bare rapene, na natuna igubaga. Kanagubaga iragata kamokamogha da tughurine na irabobo. ");
INSERT INTO aui_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Wasina bi wasikena, Elaija iwoneni bo, “Tam na God yana peroveta, awaki kiiravine na naboni kubera tagu biidi? Bo mabo kupiika yagu tamumu wiiyevevegu kiiravine da natugu kasunuyina biidi?” ");
INSERT INTO aui_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Bi Elaija iwona bo, “Natum kuveregu.” Na tomogha gisigisina sinananaki imane bi ikabaro, da teteboruborugha ikawari igae da tupayaragha meme touna iyamakamake, na name yana kenakena debane ivikeneni. ");
INSERT INTO aui_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Bi Yawe God biidi irupari iwona bo, “Oo Yawe yagu God, awaki kiiravine nuwapoya ghamana mmko kwaburina kuvereni? Touna iviwaghasinegu da yana bareye amakamake, bi kata natuna kubera da irabobo!” ");
INSERT INTO aui_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Wasina bi Elaija iroroni da raghani aroba tomogha gisigisi debane bi irupari Yawe God biidi iwona bo, “Oo Yawe yagu God, mmko tomogha gisigisina yana yawa kuveremayeni!” ");
INSERT INTO aui_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Yawe God, Elaija yana pari iwaiyaneni, na tomogha gisigisi yawiina tavenina idagumayeni da iyawamagha. ");
INSERT INTO aui_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Wasina bi Elaija, tomogha gisigisina irubevi bi ikawari iyowogha tupayaragha ghamane. Da sinananaki iviruvereni bi iwona bo, “Kita, natum iyawamagha!” ");
INSERT INTO aui_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Wasina bi wasikena, Elaija iwoneni bo, “Kata akovi da tam na God yana peroveta, bi Yawe God gamona tam kawamma sakanikanibu na wiisuwona.” ");
INSERT INTO aui_vpl VALUES ("K118_1","012_18_1","1KI","18","1","2","Raghani iguri murine, bodu wiiarobine getana amra Sameriya kubura kamone iyayotowogha, na gomara ghamana itubugha. Noko kapoe boduna wiiarobina kamone, na Yawe God, Elaija iwoneni bo, “Kunagho da kimaghatara mayem kiiwawo Aheb biidi, bi kuwoneni da Tagu pinimina bi amra anipora inayowogha kubure.” Na Elaija inagho da kiiwawo Aheb biidi iyimaghatara mayeni. ");
INSERT INTO aui_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Raghanina Aheb, Elaija ikita na iwona bo, “Da noko tam, iiyabo piropiro ghamaghamadi Isrel biidi kawapiipiikedi?” ");
INSERT INTO aui_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Bi Elaija iwona bo, “Tagu getana awaki piropirona Isrel biiyadi ayaberana, bi gegha da, tam bi tamamnaki yana rakaraka yawata noko berana naboni kobera. Tam geyamwiina da Yawe God yana sisiya bagibagidi kuyakabisisiredina, bi bada tam wosina na Baal yana tarabiibiisaka kuyapeepetedi. ");
INSERT INTO aui_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Katana Isrel damdi tupadi kwatuwiitaghomidi da Kamel Koyane sinabananigu. Bi Baal yana peroperoveta yadi 450 da god wasikena Asera yana peroperoveta yadi 400 kurutayinidi konapiika, mekodi kiiwawo wasikena Jesibel kam yavereveredina.” ");
INSERT INTO aui_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Na Aheb, Isrel damdi tupadi da Baal yana peroperoveta tupadi iviyoneyonedi da Kamel Koyane siyitaghomidi. ");
INSERT INTO aui_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Elaija wawaya tupana naghodiye imiiri bi iwonedi bo, “Raghani meme bi noghota bata basudiye konituyakayakata? Memeda Yawe touna God, na kokivini; bi meboda Baal touna God, na wasina kokivini.” Bi gegha, wawaya tupadi sivikawapotapota. ");
INSERT INTO aui_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Wasina bi Elaija iwonedi bo, “Yawe God yana peroveta na tagu kawagha amakamake, bi Baal yana peroperoveta na yadi 450. ");
INSERT INTO aui_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Kau makidi yadi bata kopiikedi toumii biiyadi. Baal yana peroperoveta kau makina tana sinavineyi, sinakasunuyi, sinarigha pinipinimi bi kiiraberabega wowodiye sinatoura, suwara gabugabuna gawarina debane, bi keyama gesininawiinina. Tagu berana mayimayiyina kau makina tana biidi anabera. ");
INSERT INTO aui_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Wasina bi Baal yana peroperoveta yami god biidi korupari, bi tagu na Yawe God biidi anarupari. Bi meko god na keyamama wonabodeyana inabera da kiiraberabega sinaruwiinawa, na touna wiisuwona God!” Na wawaya tupadi siviwaghasina. ");
INSERT INTO aui_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Wasina bi Elaija ivisisiya Baal yana peroperoveta biiyadi iwonedi bo, “Tami kokoroto kirakii kiiravine, na kovinagho yami suwara konabera. Na kau makina tana kiiravimiye kovineyi da kokabununayi bi keyama gekoninawiinina, bi yami god biidi korupari.” ");
INSERT INTO aui_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Na kau makina tana sikabununayi bi suwara gabugabuna gawarina debane sitore. Wasina bi Baal biidi rupari sidaguni, didibare da inagho gabudara youbasuve. Toudi siyarurukwatu siyawonawona bo, “Oo Baal, kuwaiyana bodemii!” Bi getana wonabodeyana, na yadi suwara gabugabuna gawarina meko siyoghani na parapa siyiibaga wiikenavivireni. ");
INSERT INTO aui_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Gabudara youbasune na Elaija idagu iyinamayedi iyawonawona bo, “Gamo ghamanama korupari! Wiisuwona touna na god! Memeda nuwanuwana iwapawapeni yanuwanuwagiura bo inagho yisarewaboni, bo inagho yawagawagaboni. Meboda yakenakenaboni, na konakasiwiimataki!” ");
INSERT INTO aui_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Na gamo ghamanama sirukwatu kamokamogha bi yadi kiki nunune, na seri da iyoma siyarigharigha mayedi patana da ganiganidi siyorororo. ");
INSERT INTO aui_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Toudi sirukwatu, bi sirukwatu, patana da ravidi suwarina kana gabudare, bi gegha, getana gamo, getana iiyabo iyawaiyana da iyawonabodeyana. ");
INSERT INTO aui_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Wasina bi Elaija wawaya ikwatuvedi iwona bo, “Mabo kopiika tagu biidi.” Na tupadi sipiika da simiiri wiikenavivireni, bi idagu Yawe God yana suwara gabugabuna gawarina, meko sikouwiiririyi na iyakabukabunagha mayeni. ");
INSERT INTO aui_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Akima yadi 12 iyouna bi Isrel kana dam tanagha kiiravine na akimidi tatadigeghama ikabigubadi. Mmko waghawaghana Isrel, na Yawe God, toudi nosidinaki Jeikap ivereni. ");
INSERT INTO aui_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Mmkodi akimidima Elaija suwara gabugabuna gawarina iyoghana mayeni da Yawe God kabepepina kiiravine. Bi durein ibani wiikenavivireni da yana ragata, na rarima 14 litas naboni rubana iyakabitawani. ");
INSERT INTO aui_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Bi kiiraberabega suwara gabugabuna gawarina debane itoura, bi kau makina irigha pinipinimi da kiiraberabega debadiye itoura. Wasina bi iwona bo, “Kibubu yadi ruwamaruwa rarimama kovibonuvidi, bi suwara da kiiraberabega rariminama kwiiwaghayoyoyidi.” ");
INSERT INTO aui_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Raghanina naboni sibera na iwona bo, “Berana mayimayiyina kobera mayeni.” Na sibera mayeni ikovi na iwona bo, “Bada berana mayimayiyina kobera mayeni koniarobi.” Bi iwonedi na berana sibera raghani kanawiiaroba. ");
INSERT INTO aui_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Da rarima suwara gabugabuna gawarinama sivitototo siyowogha da durein sivibonuvi. ");
INSERT INTO aui_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Ravidiye suwara gabuna gabudarine, na Elaija ipepewa inagho suwara gabugabuna gawarine bi irupari iwona bo, “Oo Yawe - Abraham, Aisik, da Jeikap yadi God - kata kiyeveveyana da tamna God Isrel kamone bi tagu na yam wiitamariyana. Bi kiyeveveyana da tam gamomve na mmkodi bera tupadi abera. ");
INSERT INTO aui_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Kuwonabodegu, Yawe God, kuwonabodegu, da mmkodi wawaya sinakovi, da tam Yawe, na God bi nuwanuwadi kwatayina wamira magha tam biidi.” ");
INSERT INTO aui_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Wasina bi Yawe God yana keyama karakarasina abamama irukarata iyowogha, da kau makina, kiiraberabega, akima da dobodobo suwara gabugabuna gawarina ririnagha ikarasidi bi kate rarima durein kamone imuyamuya kirakii na imama. ");
INSERT INTO aui_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Raghanina wawaya tupadi mmko sikita, na sivituwapore oghogheyana mayiyidi siyowogha dobodobove bi sirukwatu bo, “Yawe, touna God! Yawe, touna God!” ");
INSERT INTO aui_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Wasina bi Elaija sisiya bagibaginama iwonedi bo, “Baal yana peroperoveta kokabitawatawanidi. Getana konakabiwiiadidi da inaverataveyana!” Na wawaya sigeghomiiri da Baal yana peroperoveta tupadi sikabitawatawanidi, bi Elaija ivinagho kedaridi siyowogha Kison anayine da name sivikasunughana. ");
INSERT INTO aui_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Bi Elaija, kiiwawo Aheb iwoneni bo, “Kunagho awaki kunayouna da kunakam bi kunaniuna, kiiravine tagu amra ghamana yapiipiikana gugurina vimenaki awaiwaiyaneni.” ");
INSERT INTO aui_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Na Aheb inagho da awaki iyakam da iyaniuna, bi Elaija na igae inagho Kamel Koyana debane bi ivituwapore oghogheyana bi gayamina tuwaporena basudiye itore da mayiyina iyowogha dobodobove da iyarupari. ");
INSERT INTO aui_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Bi yana wiitamariyana iwoneni bo, “Kunagho da kunakitarorona yegiiye.” Na wiitamariyana inagho da ikita bi iveramagha Elaija biidi bi iwona bo, “Tagu getana awaki ayakitana.” Raghani yadi 7 Elaija yana wiitamariyana iwoneni bo, “Kunagho kunakita.” ");
INSERT INTO aui_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Bi raghani 7 tughurine na yana tamariyana inagho bi iveramagha da iwona bo, “Tagu uwa gisina akita bi yana ragata na ware wawaya imana yegiima yageegee.” Na Elaija yana wiitamariyana iwoneni bo, “Kunagho da Aheb kuwoneni bo, ‘Yam seriyotye kugeru bi kunagho bareye muriye da amra inabodebodem.’” ");
INSERT INTO aui_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Bi gerabarabana, na uuwa dumagawoworidi sipiika da abama sisowo. Yanunu idagu inatapi bi amra idagu iyayoyo. Na Aheb yana seriyot debane ivikiiyagha igeru bi itouya inaveramagha Jesrelma. ");
INSERT INTO aui_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Wasina bi Yawe God parapa maragata ghamana Elaija ivereni, na kana kwama damona irukabepi da kanakiideye ivitupakavini bi ivera da Aheb yana seriyot iverawiitaveni ivinagho patana da Jesrelma iverakanibu. ");
INSERT INTO aui_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Raghanina Aheb bareye iverakanibu, na awaki tupadi Elaija ibera da kate metagha Baal yana peroperoveta tupadi ivikasunughana, na wavinena Jesibel iwoneni. ");
INSERT INTO aui_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Na Jesibel sawariyonayona tana idaru inagho Elaija iyawoneni bo, “Iisuwona mmko raghanine maram, tagu anakasunuyim ware metagha peroperoveta kuvikasunughana na naboni. Memeda mmko geanabera, na arurupari da god parapa aro inaveregu bo meboda inakasunuyigu.” ");
INSERT INTO aui_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Elaija inaghara kirakii da yana yawa kiiravine, na ivera inaghotaveyana. Raghanina Jiuda kubure Biasiba kwanatune iverakanibu, na yana wiitamariyana nama ikuyoveni, ");
INSERT INTO aui_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","bi touna tanaduma inagho mayabe, da gabudara tanagha ipepewapom, bi ipiika da kii gisina kana waghawagha brum rogune imakeyowogha bi irupari da yana wiina iyarabobo. Iwona bo, “Mmko gewasina, tagu inunurigu, Yawe God, yagu yawa kata kabitaveni. Mmkona tagu ware nada arabobo naboni nosinosigunakim iiyawogha nada sirabobo na naboni!” ");
INSERT INTO aui_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Wasina bi kiina rogune ikenayowogha da nuwanuwana iwapa iyakenakena. Na yaininagha aneya ikabitowoyi bi iwoneni bo, “Geghomiiri, kunakam!” ");
INSERT INTO aui_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Bi ikitawiiveravera, da nama gayamine na bred benabenana tana akima muyamuyandiye sigabuni da rarima kiyabuna. Bred ikani bi rarima inina ikovi, na ikenayowogha magha. ");
INSERT INTO aui_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Wasina bi Yawe God yana aneya ipiikamagha da ikasiwiimataki bi iwona bo, “Geghomiiri, bred viya kunakam kamogha. Bi gegha na kate mmko wagawagane na tam gerubam.” ");
INSERT INTO aui_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Na igeghomiiri da bred ikam da rarima iniunamagha. Noko kamna maragata ivereni, na gabudara 40 bi nubabasu 40 ipepewa da Sainai Koyane, nokona Yawe God yana Koya. ");
INSERT INTO aui_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Nama na inagho epamana tana bonayine da noko nubabasune name ikena. Bi gegha Yawe God iwona bo, “Elaija, mma awaki kwaberabera?” ");
INSERT INTO aui_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Na Elaija iwona bo, “Yawe God Maragata Kirakiina, tagu nuwanuwagu tupanama ayabagibagiyena nonovem, tam kawagha. Bi gegha da Isrel damdi yam wiiwaghasina maragasina toudi yawata na sivikasigiiyeni, yam suwara gabugabuna gawaridi sivikouririghana bi yam peroperoveta tupadi sivikasunughana. Tagu kawagha amakamake, bi kata simatipo da sinakasunuyigu!” ");
INSERT INTO aui_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Bi Yawe God iwona bo, “Kanibu da koya debane naghoguve kunamiiri.” Wasina bi Elaija nama iyamiimiiri bi Yawe God ipiika da iyaveratupiira, na yanunu maragasina koya itapi da akima ghamadi ivikouririghana da tanawa yarayaragha itubugha, bi gegha Yawe God genama yanunu kamonena. Yanunu tapi ikabitore na bada nukenuke ipiika, bi gegha Yawe God genama nukenuke kamonena. ");
INSERT INTO aui_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Nukenuke murine na bada keyama, bi gegha Yawe God genama keyama kamonena. Bi keyama murine, na wiikawaghamgham gisina gugurina ipiika. ");
INSERT INTO aui_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Raghanina Elaija iwaiyaneni, na mayiyina kana garama ikasibabari bi ikanibu da epamana kawa bonayine imiiri. Wasina bi gamo tana ivisisiya touna biidi iwona bo, “Elaija, awaki kiiravine tam mma?” ");
INSERT INTO aui_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","Na Elaija iwona bo, “Yawe God Maragata Kirakiim, nonowa na tagu nuwanuwagu tupanama ayabagibagiyem, tam kawagha. Bi gegha da Isrel damdi yam wiiwaghasina maragasina toudi yawata na sivikasigiiyeni, yam suwara gabugabuna gawaridi sivikouririghana bi yam peroperoveta tupadi sivikasunughana. Tagu kawagha amakamake, bi kata simatipo da sinakasunuyigu!” ");
INSERT INTO aui_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Wasina bi Yawe God iwona bo, “Megha kupiika, na kedana mayimayiyina kuveramagha, da kunagho Damaskas mayabine. Raghanina name kunaverakanibu, na kurughu kwanatune, bi Hasael kituboro bi noko iniyeveveyana da touna Siriya kana kiiwawo. ");
INSERT INTO aui_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","Bi Nimsi natuna Jehu kituboro bi noko iniyeveveyana da touna Isrel kana kiiwawo, bi kwanatu kana waghawagha Eibol Mehola tomogha, Sapat natuna Elaisa kituboro bi noko iniyeveveyana da touna, tam inatupatavem naboni yagu peroveta. ");
INSERT INTO aui_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Wawaya iiyabo Hasael gwabinama inavera, na Jehu inageghomiiri da inakasunuyi, bi nokodi iiyawogha Jehu gwabinama sinavera, na Elaisa inageghomiiri da inikasunughana. ");
INSERT INTO aui_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Bi Isrel damdi yadi 7,000 iiyawogha na gemeyani Baal siyatuwayowaneni bo geyana tarabiibiisaka siyamaghanina sinamake!” ");
INSERT INTO aui_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Na Elaija inagho da Sapat natuna Elaisa yana tanawa iyaroverove na ibanani. Nama na tomotomogha yadi 12 bi kau batabatiighatema tanawa siyaroverove bi touna tughurine kau yadi batama iyaroverove. Elaija inagho touna biidi bi kana kwama Elaisa katiiyane ivitavenageyeni bi itouya da inagho. ");
INSERT INTO aui_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Wasina bi Elaisa yana kau ikuyowana bi Elaija murinagha ivera inagho da iwoneni bo, “Dagudagune na kuyovegu ananagho tamagunaki da sinagunaki anamaghanidi da anikukuvedi, bi muriye na anakivinim tananagho!” Na Elaija iwona bo, “Wasina kuveramagha, bi kwakowaboga da awaki abera tam biidi.” ");
INSERT INTO aui_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Wasina bi Elaisa iveramagha yana kau biidi da ivikasunughana. Touna roverove sawaridi kiima sibera bi kau satayina da tanawa sarove, na toudima keyama ibera da iyuvidi ivitawogha bi wawaya iveredi da sikam. Wasina bi itouya inagho da Elaija ikivini da kanawiiwiita. ");
INSERT INTO aui_vpl VALUES ("K22_1","013_2_1","2KI","2","1","1","Raghani tupona bi muriye, da Yawe God yanunu virovirogha kamone Elaija iyakabi iyagae abame, na Elaija da Elaisa Gilgalma sitouya siyanono, ");
INSERT INTO aui_vpl VALUES ("K22_2","013_2_2","2KI","2","2","2","na Elaija, Elaisa iwoneni bo, “Mma kumakae, Yawe God iwonegu da ananagho Betelma.” Bi gegha Elaisa iwona bo, “Wiisuwona, Yawe God yamakamake na kana waghawaghae da kate tam yam yawa waghatama awonawona da gemeyani anakuyovemna.” Na siyowogha sinagho Betelma. ");
INSERT INTO aui_vpl VALUES ("K22_3","013_2_3","2KI","2","3","3","Betel meyagiine na God yana peroperoveta ribana nama siyamakamake na sipiika Elaisa biidi bi siwoneni bo, “Kwakovi bo gegha da Yawe God kata yam bada gwabimma inakabirenataveni?” Na Elaisa iwona bo, “Akovi, bi gegha noko konisisiyenina.” ");
INSERT INTO aui_vpl VALUES ("K22_4","013_2_4","2KI","2","4","4","Wasina bi Elaija iwona bo, “Elaisa, mma kumakae, Yawe God iwonegu da ananagho Jeriko kwanatune.” Elaisa iwona bo, “Wiisuwona, Yawe God yamakamake na kana waghawaghae da kate tam yama yawa waghatama awonawona da gemeyani anakuyovemna.” Na sinagho Jerikoma. ");
INSERT INTO aui_vpl VALUES ("K22_5","013_2_5","2KI","2","5","5","Bi Jeriko kwanatune na God yana peroperoveta ribana nama siyamakamake na sipiika Elaisa biidi da siwoneni bo, “Kwakovi bo gegha da Yawe God kata yam bada gwabimma inakabirenataveni?” Na Elaisa iwona bo, “Akovi, bi gegha noko konisisiyenina.” ");
INSERT INTO aui_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","Wasina bi Elaija, Elaisa iwonena bo, “Mma kumakae, bi Yawe God iwonegu da ananagho Jodan rarimine.” Bi gegha Elaisa iwona bo, “Wiisuwona Yawe God yamakamake na kana waghawaghae da kate tam yam yawa waghatama awonawona da gemeyani anakuyovemna.” Na yadi bata sipepewa patapata sinagho. ");
INSERT INTO aui_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","Bi peroperoveta ribana kamonama tomotomogha yadi 50 bada yawata sinagho da kadi taraboga sivituramiiriyedi. Bi Elaija da Elaisa, sinagho da Jodan rarimina ririne sivituramiiriyedi bi peroperovetidi na kadi taraboga simiiri bi Elaija da Elaisa siyaruruwiitetedi. ");
INSERT INTO aui_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","Wasina bi Elaija kana kwama, ikabitaveni da inoku bi tounama rarima irouvi na ivibogabogae, bi yadi bata tanawa kanakananagha sipepewa sitowawona! ");
INSERT INTO aui_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Raghanina Jodan rarimina nawane sikabigae, na Elaija, Elaisa iwoneni bo, “Yam kayowana awaki na kuwonegu da anabera, muriye da Yawe God gwabimma inakabitavegu.” Na Elaisa iwona bo, “Rubana da yam wiiperoveta kamonama maragata tupatupawiikapuna kuyaveregu, bi kam gawara ayakabi naboni peroperoveta kadi bada.” ");
INSERT INTO aui_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","Na Elaija iwona bo, “Tam sawara ghamana kiiravine kuvibaba. Meboda raghanina kunakita bi Yawe God gwabimma inakabikabitavegu, na wasina yam wiibaba kunakabi, bi meboda gegha kunakitagu na bada gegha.” ");
INSERT INTO aui_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Raghanina yadi bata sivisisiya patapata sipepewa siyanono, na raghani tana hosi da seriyot ere keyama karakarasidi sirumaghatara, na Elaija da Elaisa sivibogabogaedi bi Yawe God, yanunu virovirogha kamone Elaija ikabiigae abame. ");
INSERT INTO aui_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Bi Elaisa ikitana irukwatu iwona bo, “Tamagunaki! Tamagunaki! Tagu, Isrel kana seriyot da hosi akitakitadi!” Wasina bi gemuriye Elaija iyakita mayenina. Bi yana nuwapoya matakirina, na kanakwama itayina gosiri da bata situbugha. ");
INSERT INTO aui_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Raghanina Yawe God, Elaija ikabi iyageege, na kana kwama ibeku iyowogha dobodobove, na Elaisa ikabi bi iveramagha inagho Jodan rarimina ririne imiiri. ");
INSERT INTO aui_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Bi Elaija kana kwama meko kiidamoma ibeku, na nokoma rarima irouvi bi iwona bo, “Yawe na meme, Elaija yana God?” Na rarimina itamoyaragha da sivibogabogae bi ipepewa inagho nawane. ");
INSERT INTO aui_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Raghanina God yana peroperoveta ribana, toudi Jeriko kwanatunama sivitukivinidi bi rabarabama sikitarorona da awaki itubugha sikitana na siwona bo, “Elaija yana maragata na kata Elaisa gwabine!” Wasina bi sitouya sinagho da siyikiikiiveni, na naghone sipepeta da mayiyidi siyowogha dobodobove. ");
INSERT INTO aui_vpl VALUES ("K22_16","013_2_16","2KI","2","16","16","Bi siwona bo, “Toumii yama 50 mma bi tupamii maragasimii bi kiwaghasinemii da kananagho yam bada kaninoyeni. Meboda Yawe God kanumina ikabiinagho da koya tana debane bo anagha tana kamone itoreboni.” Bi Elaisa iwona bo, “Gegha, gekonanaghona.” ");
INSERT INTO aui_vpl VALUES ("K22_17","013_2_17","2KI","2","17","17","Bi gegha, toudi siyibaba tupetupeni patana da sinimayagha ikabi na iviwaghasina, iwona bo, “Wasina, tami konagho.” Na tomotomogha yadi 50 sinagho da gabudara aroba sivinoyeni, bi getana da Elaija siyabananina. ");
INSERT INTO aui_vpl VALUES ("K22_18","013_2_18","2KI","2","18","18","Elaisa na Jeriko kwanatune iyamakamake, bi raghanina siveramagha na iwonedi bo, “Tagu awaki awonemi, awona bo, ‘Gekonanaghona.’” ");
INSERT INTO aui_vpl VALUES ("K24_8","013_4_8","2KI","4","8","8","Raghani tana Elaisa inagho Sunem kwanatune. Bi wasike moumourina nama iyamakamake, na ivibaba wiimaragata da iyapiika yana bareye da siyakam patapata. Noko murine, raghanina Elaisa iyanono Sunem kwanatune na noko barene iyakamkam. ");
INSERT INTO aui_vpl VALUES ("K24_9","013_4_9","2KI","4","9","9","Na wasikena, moghanena iwoneni bo, “Kuwaiyana, tagu noko tomoyina raghani peyaridi yapiipiika mabo na akovi, touna God yana peroveta kabikabikuwayina. ");
INSERT INTO aui_vpl VALUES ("K24_10","013_4_10","2KI","4","10","10","Imiise da tupayaragha gisina yada bare wowone tanabera bi kenakena kana pesapesa tana da kamkam kana kiinabonabo, bi abamakamake da bada kibe kamone tanatoura. Da tomoyina meboda inapiika, na noko gawarine inamake.” ");
INSERT INTO aui_vpl VALUES ("K24_11","013_4_11","2KI","4","11","11","Gabudara tana, raghanina Elaisa ipiika magha Sunem kwanatune, na inagho wasikena yana bare wowone yana tupayaraye da iyiyawiitaveyana. ");
INSERT INTO aui_vpl VALUES ("K24_14","013_4_14","2KI","4","14","14","Noko murine, na Elaisa yana wiitamariyana kana waghawagha Gehasi ivitarakiiyaneni bo, “Awaki sawarina miisena rubana ayabera mmko wasikena kiiravine?” Na Gehasi iwona bo, “Touna natuna tomogha gegha bi moghanena imoraba.” ");
INSERT INTO aui_vpl VALUES ("K24_15","013_4_15","2KI","4","15","15","Na Elaisa yana wiitamariyana iwoneni bo, “Wasikena mabo kuwoneni inapiika.” Na Gehasi, wasikena iwoneni na ipiika da Elaisa yana tupayaragha matamketane imiiri. ");
INSERT INTO aui_vpl VALUES ("K24_16","013_4_16","2KI","4","16","16","Bi Elaisa iwona bo, “Mmko gabudarina naboni viko bodune, na natum tomogha imamve kunarurubevi.” Na wasikena iwona bo, “Gegha, tomogha ghamam. Tam na peroveta, na gekuniyabeguna, yam wiitamariyana.” ");
INSERT INTO aui_vpl VALUES ("K24_17","013_4_17","2KI","4","17","17","Bi gegha, wiisuwona wasikena iropeya. Da gabudarina mayimayiyina noko boduna ikovi murine na wasikena ivituwa da tomogha ware Elaisa iwoneni na naboni. ");
INSERT INTO aui_vpl VALUES ("K24_42","013_4_42","2KI","4","42","42","Raghani tane, na tomogha tana Baal-Salisa kwanatunama bred geredi yadi 20 noko bodune barlie dagudaguna sikabipura na toudima sigabuna, bi kate grain woudi katota sikabipura, na irigama iuwana bi ikawara ipiika da Elaisa ivereni. Bi Elaisa yana wiitamariyana iwoneni bo, “Kamna wawaya kuveredi da sinakani.” ");
INSERT INTO aui_vpl VALUES ("K24_43","013_4_43","2KI","4","43","43","Na Elaisa yana wiitamariyana iwona bo, “Awaki, gerubana da tomotomogha yadi 100 mmko kamna sinakanina.” Bi Elaisa iwona bo, “Yawe God iwona da sinakam inanunuridi bi patana kawatupo sinamake, na kamna kuveredi sinakam.” ");
INSERT INTO aui_vpl VALUES ("K24_44","013_4_44","2KI","4","44","44","Wasina bi wiitamariyana kamna wawaya iveredi. Toudi sikam bi murine, na kam muduna iyamakamake, ware Yawe God iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Naaman na, Siriya damdi yadi kiiwawo yana wiiyogha tomotomogha kadi bada ghamana. Yawe God, Naaman iviwiiteni na Siriya damdi sigeghomiiri da kadi aviya sigeiwaiyidi. Na Siriya damdi yadi kiiwawo iyanoghonoghosi da Naaman na tomogha ghamana, na ikabikarawayeni. Naaman na wiiyogha tomoyina ghamana tana, bi gegha da gubaga berona kana waghawagha korekore ikabi. ");
INSERT INTO aui_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Naghove Siriya damdi yadi gogona tane Isrel damdi biiyadi. Na wiiyogha tomotomoyidi Isrel wasike wabuwabuna tana siburavi. Bi wasikena na Naaman wavinena ikabi da yana wiitamariyana. ");
INSERT INTO aui_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","Gabudara tana kana bada wasikena iwoneni bo, “Tagu akayokayoveni da yagu bada Naaman iyanagho da God yana peroveta Sameriya kubure yamakamake na iyakita. Bi kana gubaga korekore iyiyawiini.” ");
INSERT INTO aui_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Na Naaman yana hosi da seriyot teya sinagho Sameriya kubure, da Elaisa yana bare matamketane ivituramiiriyeni. ");
INSERT INTO aui_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Bi Elaisa sawariyonayona tana idaru inagho da Naaman iyawoneni bo, “Kunagho da Jodan rarimine raghani yadi 7 kuniyeka. Na sinim inanoveramagha da kam korekorema kunayawa da kunamiise.” ");
INSERT INTO aui_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Bi gegha Naaman nuwanuwana ipughu, na itouya inaghotaveyana bi iwona bo, “Yagu noghota maragasina, na ware peroveta yana barema iyakanibu tagu biidi da iyamiiri bi yana God, Yawe biidi iyarupari bi gubaga wowone imana inarutapitapi da kagu korekore iyayawa! ");
INSERT INTO aui_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","Bi Damaskas kwanatuna rarimidi Abana da Parpar na simiise kirakii bi Isrel kubura rarimidi na gegha miisedina. Rubana da tagu nokodi rarima Siriya kubure ayiyeka na ayayawa.” Na Naaman nuwanuwana ipughu kirakii bi imiiri wamira da itouya inaghotaveyana. ");
INSERT INTO aui_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Bi Naaman yana wiitamatamariyana sipiika da siwoneni bo, “Tomogha ghamam, memeda peroveta iyawonem da awaki sawarina ghamana kuyabera, na imiise da kunabera. Na rubana kuyakabisisireni da kuyiyeka raghanina iwona bo, ‘Kunagho kuniyeka da kunayawa!’” ");
INSERT INTO aui_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Na Naaman inagho Jodan rarimine bi ivikipukipu da raghani yadi 7 metagha Elaisa iwonenina naboni, na sinina inoveramagha da iyawa ware tomogha gisina sinina naboni da touna imiise. ");
INSERT INTO aui_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Wasina bi Naaman yana wawaya tupadi yawata siveramagha peroveta Elaisa biidi da naghone ivituramiiriyeni bi iwona bo, “Kata akovi da parapa Isrel kana God, na God waghata kubura tupane! Na kata, rubana bo gegha da puyo gwabiguma kuyakabi, tagu yam wiitamariyana.” ");
INSERT INTO aui_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","Bi Elaisa iwona bo, “Wiisuwona, Yawe God yamakamake, iiyabo yana wiitamariyana na tagu bi kana waghawaghaye awonawona da puyona geanakabina.” Naaman, Elaisa ivibaba tupetupeni da puyona iyakabi, bi gegha da, touna isinighii na geiyakabina. ");
INSERT INTO aui_vpl VALUES ("K25_17","013_5_17","2KI","5","17","17","Wasina bi Naaman iwona bo, “Meboda yagu puyo gekunakabi, na rubana kuyiwaghasinegu da mule yadi batama mmko kuburinama tanawa ayuwana, bi sinakawara kanaveramagha yagu kubure. Basuna kata da nabo inagho, na puyo bo suwara gabugabunidi gegha meko godna biidi anavereyana da Yawe God biidi kawagha anabera. ");
INSERT INTO aui_vpl VALUES ("K25_18","013_5_18","2KI","5","18","18","Na anoghonoghosi Yawe God rubana inanoghotatavegu raghanina yagu kiiwawo animataturaneni kananagho Siriya damdi yadi god, Rimon yana kabepepa barene, da name kanakabepepi bi imagu debane inirukekewana da tagu, touna yawata nama kanapepeta. Wiisuwona Yawe God rubana inanoghotatavegu!” ");
INSERT INTO aui_vpl VALUES ("K25_19","013_5_19","2KI","5","19","19","Elaisa, Naaman iwoneni bo, “Nuwaruriri kamone kunagho.” Wasina bi Naaman itouya da inagho. ");
INSERT INTO aui_vpl VALUES ("K217_5","013_17_5","2KI","17","5","5","Wasina bi Asiriya yadi kiiwawo yana wiiyogha tomotomoyidi sipiika Isrel kubure da Isrel damdi siyageiwaiyidi. Toudi bodu aroba kamone Sameriya kwanatuna siyamiimiiri gwagwari bi mmko berane na wawaya iyagudugudu da gesiyakanikanibu bo siyarughurughuna, na wawaya Sameriya kwanatuna kamone kadi kam siyakovikovi, na siyaverevere mayedi kadi aviya biiyadi. ");
INSERT INTO aui_vpl VALUES ("K217_6","013_17_6","2KI","17","6","6","Kiiwawo Hoseya yana wiibada boduna nine bi kamone, na Asiriya yadi kiiwawo Sameriya kwanatuna ikabi, bi Isrel damdi siberadi da biwa kabikabi wawayidi na sikabidi sinagho Asiriya kubure. Da mududi Hala kwanatune itore wiipikapikadi, mududi Gosan kubure Habo rarimina ririne bi mududi na Midiya kubura kwanatudiye itoredi. ");
INSERT INTO aui_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","Mmko itubugha basuna Isrel damdi tamumu sibera Yawe yadi God biidi, iiyabo Ijipt kana kiiwawo yana maragatama iviyawiidi da Ijipt kuburinama ikabidi sikanibutaveyana. Bi god mududi siya peepetedi ");
INSERT INTO aui_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","da dam mekodi Yawe God, Kenen kuburama irukwavina sikanibutaveyana na yadi kiki beradi siyakivikivina bi kate kiki mekodi Isrel kana kiikiiwawo sivitubutubugha, na siyakivikivina. ");
INSERT INTO aui_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","Isrel damdi bada wiikowoye bera peyaridi sibera mekodi Yawe yadi God geiyakayovedina. Bi god mududi kadi kabepepa gawaridi yadi kwanatu tupadiye siyoghana, meyagii gisigisidi da igae inagho kwanatu ghamanakidiye. ");
INSERT INTO aui_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","Bi akima kabikabikuwayidi da Asera kabepepina kiitupodi koya tupadi debadiye da kii tupadi rogu miisedi savereyana, na rogudiye sikabiwiimiimiiridi. ");
INSERT INTO aui_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Wasina bi Asiriya damdi yadi kiiwawo, kwanatu ghamaghamadi Babilon, Kuta, Ava, Hamat da Separwaimma wawaya ikabidi da Sameriya kubura kwanatudiye itoredi siyamake Isrel kaditupataveyana. Bi Sameriya kubura sikabi sivirapeneni da kana kwanatu nunudigha simakae. ");
INSERT INTO aui_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","Raghanina mmkodi kubura wiibata damdi sitourawiipikapika ghuyoghuyone, na Yawe God gesiyakabekabepepina. Noko kiiravine na God, laiyon iviporadi da kubura wiibata damdi viya siyitarunughana. ");
INSERT INTO aui_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Na wawaya, Asiriya yadi kiiwawo siwoneni bo, “Wawaya mekodi kuviporadi da Sameriya kubura kwanatudigha samakamake, na noko kuburina kana god yana gwara gesiyakovina, noko kiiravine God, laiyon iviporadi toudi biiyadi, da wawaya sitarunughana.” ");
INSERT INTO aui_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Wasina bi Asiriya yadi kiiwawo iwona bo, “Prist tana tapiikedi naboni biwa kabikabi wawayidi, na kovipora inaveramagha Sameriyama name inamake, da noko kuburina kana god yana gwara, dam wiibata wawayidi nama samakamakena iniyevevedi.” ");
INSERT INTO aui_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Na prist tana naghove Sameriya kuburama sirutayini, na iveramagha da Betelne imakae bi dam wiibata wawayidi nama makamakedi iviyevevedi da Yawe God siyakabepepi. ");
INSERT INTO aui_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","Bi gegha, kubura wiibata damdi na kwanatu meghamegha siyamakamake, na kamodiye toudimani yadi god rapediye siyaberabera, bi Isrel damdi yadi god mududi kadi kabepepa gawaridi naghove sibera, na kamodiye siyatutoura. ");
INSERT INTO aui_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","Bodu wiiarobine Ela natuna Hoseiya, Isrel kana kiiwawo iyiibada raghanine, na Ahes natuna Hesekaiya ivikiiwawo da Jiuda kiiravidiye wiibada idaguni. ");
INSERT INTO aui_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","Bi kana bodu 25 na ivikiiwawo bi Jerusalem kamone bodu yadi 29 ivibada. Sinananaki na Abija, touna Jakaraiya natuna. ");
INSERT INTO aui_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","Bi yana berabera na rotomanidi Yawe God matane ware nosinanaki Deivid ibera, na naboni. ");
INSERT INTO aui_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","Hesekaiya kabepepa berodi gawaridi ivikouririghana, akima kabikabikuwayidi ivikasigiiyana bi Asera kabepepina kiitupodi ivikasiyaraghana. Bi kate naghove waghata Mosis bronsma mota iberana ikasigiigiini, basuna Isrel damdi noko motana noghosine, na insense siyagabugabuna. Motana sikwatuveni da Nehusten. Na Hesekaiya, motana ikasigiigiini da pinipinimidi. ");
INSERT INTO aui_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","Hesekaiya, Yawe Isrel kana God ivitumaghanena kirakiiyeni. Getana meko Jiuda kiiwawona naghone bo kiiwawona murine da God iyitumaghaneni ware Hesekaiya ibera na naboni. ");
INSERT INTO aui_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","Bi Yawe God metagha iwona, na nonowa iyaberabera. Touna, Yawe God yana gwara Mosis iverenina ikabisisiredi. ");
INSERT INTO aui_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","Noko kiiravine na Yawe God, Hesekaiya iyagwabigwabiyeni bi yana bagibagi na wasina kawakawa. Bi Asiriya yadi kiiwawo igebodeni da isinighii bagibagiyenina. ");
INSERT INTO aui_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","Hesekaiya, Pilistain damdi igeiwaiyidi, nokona Jiuda kubure da inagho Gasa kwanatune bi kate kubura ririnagha kwanatudigha, meyagii gisigisidi da inagho kwanatu ghamaghamadi akimama sigari wiikenaviviredina. ");
INSERT INTO aui_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","Manasa na kana bodu 12 bi ivikiiwawo, da bodu 55 Jerusalem kamone ivibada. Bi sinananaki na kana waghawagha Hepsiba. ");
INSERT INTO aui_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","Manasa, Yawe God, ivikawakeekeeyeni bi dam wiibata yadi kiki beradi beroberodi iyaberabera, iiyawogha na Yawe God, Kenen kuburama iyarurukwavina siyakanikanibu bi Isrel damdi siyarughurughu. ");
INSERT INTO aui_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","Manasa kabepepa berodi gawaridi iyoghana magha mekodi tamananaki Hesekaiya ivikouririghanana. Touna suwara gabugabuna gawaridi ibera da god Baal siyakabepepi. Bi kate god wasikena Asera kabepepina kiitupodi bada ikabiwiimiiridi ware Isrel kana kiiwawo Aheb iberana naboni. Manasa bada ipepeta da abame kewokewo iyakabekabepepidi. ");
INSERT INTO aui_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","Bi Manasa, god mududi yadi suwara gabugabuna gawaridi Yawe God yana bareye ibera, gawara meme naghove Yawe God iwona bo, “Kagu waghawagha Jerusalem kamone inamake nonowa.” ");
INSERT INTO aui_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","Yawe God yana bare garidi yadi bata kamodiye na kewokewo abame kiiravidiye suwara gabugabuna gawaridi ibera. ");
INSERT INTO aui_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","Bi bada natuna waghata keyame igabuni naboni suwara gabugabunina, touna kiirapu bo yapune da kasiko beradi iyaberabera, touna imapu damdi da iiyawogha kanukanuma teya sisisiyana wawayidi iyawaiwaiyanedi. Touna bera berokirakiina ibera na Yawe God nuwanuwana ipughu. ");
INSERT INTO aui_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","Wasina bi Yawe God yana peroperoveta, iiyawogha sabagibagiyeni, na sisiya iveredi, ");
INSERT INTO aui_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","iwonedi bo, “Kenen damdi bera berodi sibera bi gegha da Manasa parapa bera bero kirakiidi ibera. Bi Jiuda damdi iberadi da bera berodi sibera, toudi yana tarabiibiisaka sipepetedi ");
INSERT INTO aui_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","Na Tagu, Yawe, Isrel kana God piropiro ghamanakina anapiikeni Jerusalem kwanatune da Jiuda kubure. Noko raghanine na wawaya mmko piropirona sisiyina sinawaiyaneni na sinanaghara. ");
INSERT INTO aui_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","Tagu Sameriya kwanatuna akabirubata da avibero da Aheb yana rakaraka yawata, na noko naboni tagu Jerusalem kwanatuna aro anavereni. Bi wawaya tupadi Jerusalemne anagigiratavedi ware wawaya enopu sakimokogha bi sikuratabuni da inakanakana na naboni. ");
INSERT INTO aui_vpl VALUES ("K221_14","013_21_14","2KI","21","14","15","Yagu wawaya bera berodi sibera bi nuwanuwagu sivipughu, raghanina rorowainagha nosinosidinakim Ijipt kubura sikanibutaveni, gabudarine bi ipiika da kata mmko raghanine. Na yagu wawaya mekodi patana yawayawiidi samakamakena anasinighiiyedi da kadi aviya aniruveredi. Kadi aviya sinageghomiiri da Jiuda damdi yadi kubura bi yadi sawara tupadi sinayapi.” ");
INSERT INTO aui_vpl VALUES ("K221_16","013_21_16","2KI","21","16","16","Bi kate bada, Manasa igeghomiiri da bera miisedi kadi berabera wawaya korotodi ivikasunughana, na Jerusalem kwanatuna kedadi na ganigani ibonuvi; Na mmko berana ibera na bera katamanina ivikiitayineni bi Jiuda damdi ivinaghovedi da tarabiibiisaka siyapeepetedi bi tamumu siyaberabera Yawe God matane. ");
INSERT INTO aui_vpl VALUES ("K221_18","013_21_18","2KI","21","18","18","Manasa irabobo na kwabu yana kiiwawo bare ririne sidogu, kwabuna sikwatuveni Usa. Bi natuna Amon kana gawara ikabi da ivikiiwawo. ");
INSERT INTO aui_vpl VALUES ("K221_19","013_21_19","2KI","21","19","19","Noko raghanine na Amon kana bodu 22 bi ivikiiwawo Jiuda kiiravine. Bi Jerusalem kamone iyiikiiwawo da bodu bata sikovi. Bi sinananaki na Mesulemet, bi Jotba kwanatu tomogha Harus natuna. ");
INSERT INTO aui_vpl VALUES ("K221_20","013_21_20","2KI","21","20","20","Amon, Yawe God ivikawakekeyeni ware tamananaki Manasa iberana naboni ");
INSERT INTO aui_vpl VALUES ("K221_21","013_21_21","2KI","21","21","21","Amon tamananaki yana bera ikabi na touna bada dam wiibata yadi kiki beradi beroberodi tarabiibiisakidi iyapeepetedi, tamananaki ipepetedina naboni. ");
INSERT INTO aui_vpl VALUES ("K221_22","013_21_22","2KI","21","22","22","Bi nosinosinanakim yadi God, Yawe isinighiiyeni, bi yana sisiya bagibagidi geiyakabisisiredina. ");
INSERT INTO aui_vpl VALUES ("K221_23","013_21_23","2KI","21","23","23","Noko biidi na yana bagibagi tomotomoyidi ghamaghamadi siviaviyeni, na sivigiugerogerora bi yana kiiwawo bare kamone sikasunuyi. ");
INSERT INTO aui_vpl VALUES ("K221_24","013_21_24","2KI","21","24","24","Na Jiuda damdi mududi sigeghomiiri da iiyawogha Amon sikasunuyi, na wawayidi tupadi sivikasunughana, bi natuna Josaiya sitore kana gaware ivikiiwawo. ");
INSERT INTO aui_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Noko raghanine na Josaiya kana bodu 8 bi Jiuda kiiravine ivikiiwawo, touna Jerusalem kamone ivibada patana da bodu 31 sikovi. Bi sinananaki na kana waghawagha Jedida bi Boskat kwanatunama tomogha kana waghawagha Adaiya natuna. ");
INSERT INTO aui_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","Josaiya, bera iberadina Yawe God ivinuwamiimiiseyeni. Bi nosinanaki Deivid yana bera ikabi na Yawe God yana gwara iyakabikabi sisiredi geiyituirana katakatiya bo dugedugeye. ");
INSERT INTO aui_vpl VALUES ("K222_11","013_22_11","2KI","22","11","11","Raghanina kiiwawo gwara bukana kamonama sisiya iwaiyana, na wiiyeveveyana ibera da touna ivinuwapoya, na kana gara itayina gosigosira. ");
INSERT INTO aui_vpl VALUES ("K222_12","013_22_12","2KI","22","12","12","Wasina bi raghani tana Josaiya sisiya itore Hilkaiya touna prist, bi Sapan natuna Ahikam, Mikaiya natuna Akibo, bi kiiwawo yana girugiruma wawayina Sapan da kiiwawo yana wona wiiyoyowana wawayina miisena Asaiya biiyadi iwona bo, ");
INSERT INTO aui_vpl VALUES ("K222_13","013_22_13","2KI","22","13","13","“Nosinosidanakim mmko bukana sisiyidi gesiyakabisisiredi, bi metagha iwoneda tayabera na genaboni siyaberana, noko biidi Yawe God nuwanuwana ipughu kirakii yamuyamuya ware keyama naboni touda biiyadi. Na konagho God yana bareye da Yawe God biidi kovisisiya kiiraviguve bi kate Jiuda kana wawaya tupadi kiiravidiye da mmko buka kamone awaki sigiruma.” ");
INSERT INTO aui_vpl VALUES ("K222_16","013_22_16","2KI","22","16","17","“Yawe God mma naboni iwona bo, ‘Jiuda damdi sisinighiiyegu, toudi god mududi siyasuwasuwaridi, bi tarabiibiisaka imadima siyaberabera na yadi bera kiiravine na sivinuwapughupughugu. Na aro ghamanakina anapiikeni Jerusalem kwanatune da wawaya iiyawogha nama samakamake biiyadi, ware metagha Jiuda yadi kiiwawo buka kamone ikabiyavina naboni. Tagu nuwanuwagu ipughu ware keyama naboni gerubana sinasighirina.’ ");
INSERT INTO aui_vpl VALUES ("K222_18","013_22_18","2KI","22","18","18","Jiuda kana kiiwawo, iiyabo iviporami da Yawe God koyitarakiiyaneni, na kowoneni bo, ‘Mmkona metagha Yawe, Isrel kana God iwona wara kuwaiyaneni na kiiravine. ");
INSERT INTO aui_vpl VALUES ("K222_19","013_22_19","2KI","22","19","19","Kuvinuwapoya da Yawe God naghone kutore yowoyenamayem bi kam gara kutayina gosigosira. Noko raghanine tam yagu sisiya kuwaiyaneni da mmko kuburina da iiyawogha mma samakamake kiiravidiye, na metagha aro anaveredi bi anaberadi da wawaya sinasinighiyedi bi kadi waghawaghaye sinimimaga na kiiravidiye kudou, ");
INSERT INTO aui_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","bi aniwaghasinem da kunarabobo bi yam wawaya nuwaruririye sinadogum. Tam aro ghamanakina meko Jerusalem biidi ayapiikeni na gekunakitana.’” Na wasikena yana sisiya sikabisiveramagha da Josaiya siwoneni. ");
INSERT INTO aui_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Wasina bi kiiwawo Josaiya, Jiuda kuburidi kadi babada da Jerusalem kwanatuna babada ghamaghamadi iwonedi na sipiika touna biidi. ");
INSERT INTO aui_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","Da tupadi sigae sinagho Yawe God yana bareye, bi prist da peroperoveta, da kate wawaya tupadi sivikayeturanedi yawata, wawaya moyamoyakidi bi igae inagho wawaya moumouridi. Name Yawe God yana bareye, na Josaiya Wiiwaghasina Maragasina Bukana meko bagibagi damdi, Yawe God yana bareye sibananina, tupana ikabiyavi wawaya biiyadi. ");
INSERT INTO aui_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Josaiya, Yawe God yana bare tupogina ririne imiiri, gawara meme kiiwawo inamiiri bi sisiya ghamaghamadi inisisiya. Na name Josaiya wiiwaghasina maragasina Yawe God matane iviwuwamireni. Bi ivisuwona da Yawe God yana sisiya bagibagidi, gwara bi sira inakabisisiredi da awaki sisiyidi Wiiwaghasina Maragasina Bukana kamone na inabera. Wawaya tupadi bada mayimayiyina sivisuwona wiimaragata Yawe God biidi. ");
INSERT INTO aui_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","Wasina bi kiiwawo Josaiya sisiya bagibaginama, Hilkaiya touna prist kiikiiwawona, bi kana wiiwiita pristna da kate prist mekodi Yawe God yana bare matamketana samiimiiribabari, na iwonedi da sawara mekodi wawaya sibera Baal kiiravine, Asera kiiravine, kewokewo tupadi kiiravidiye abama kamone, na Yawe God yana barema siyakawara siyakanibu maghatare. Bi kiiwawo Josaiya wawaya iwonedi na sawaridi tupadi Jerusalem kwanatuna kubune, tanawa Kidron anayina gisina ririne siyagabuna. Noko murine na yapukaredi siyakawara siyanagho Betel kwanatune. ");
INSERT INTO aui_vpl VALUES ("R236_14","015_36_14","2CH","36","14","14","Prist babadidi tupadi da wawaya na yadi wiisuwona maragasina Yawe God biidi sibera na gesiyakivinina bi sigeghomiirii da bera berona ghamana sibera da wawaya wiibata yadi kiki beradi siyaberabera da tarabiibiisaka siyapeepetedi na Yawe God yana bare, meko itoreireni da kabikabikuwayina Jerusalem kamone, na sividadabu kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("R236_15","015_36_15","2CH","36","15","15","Wasina bi Jiuda damdi nosinosidinakim yadi God, Yawe na ivinuwapoya kirakii yana wawaya da yana Bare kiiravidiye, na sawariyonayona idarudi da yana wawaya siyikatagha wiitaratawatawanedi, ");
INSERT INTO aui_vpl VALUES ("R236_16","015_36_16","2CH","36","16","16","bi gegha da, wawaya sigeghomiiri God yana sawariyonayona sivinamayedi da yana wiiyoyowana gesiyakabikarawayenina, bi yana peroperoveta simanivedi. Na Yawe God yana nuwapughu iragata kirakii, da gerubana awaki iyagudu bodenina. ");
INSERT INTO aui_vpl VALUES ("R236_17","015_36_17","2CH","36","17","17","Na Yawe God, Babilon damdi yadi kiiwawo Nebukednesa idaru da iyagogona Jerusalem kwanatuna biidi da iyiaviyeni. Babilon iyo damdi sigeghomiiri da Jiuda kana tomotomogha woudi sivikasunughana bi bada iiyawogha Bare Kabikabikuwayina kamone na sirukwavina da nama sivikasunughana. Babilon iyo damdi getana Jiuda wawaya siyanuwaghanedina, toudi tomotomogha woudi da wasiwasike woudi sivikasunughana bi bada wawaya moramorabidi da wawaya gubagubagidi yawata. Yawe God, Jiuda damdi tupadi na kiiwawo Nebukednesa yana maragata rogune itoredi. ");
INSERT INTO aui_vpl VALUES ("R236_18","015_36_18","2CH","36","18","18","Na sawara tupadi ghamadi da gisigisidi God yana bare kamone siyamakamake, na kiiwawo yana iyo tomotomogha sikawara siveramagha sinagho yadi kwanatu ghamana Babilonma. Bi kate Yawe God yana bare kana gararaba teya sikawara sinagho da kate kiiwawo da yana babada yawata yadi gararaba. Mmkodi sawara tupadi sikawara siveramagha Babilonma. ");
INSERT INTO aui_vpl VALUES ("R236_19","015_36_19","2CH","36","19","19","Bi God yana bare kabikabikuwayina sigabuni bi Jerusalem kwanatuna akimama sigari na sikwouwiiririyi da kate bare ghamanakidi sigibu. Bi moura sawaridi nama siviberodi. ");
INSERT INTO aui_vpl VALUES ("R236_20","015_36_20","2CH","36","20","20","Babilon kana kiiwawo yana iyo tomotomogha, Jiuda damdi iiyawogha yawayawiidi siyamakamakena sikabidi bi siberadi da biwa kabikabi wawayidi bi sinavedi Babilon kwanatune. Noko raghanine Jiuda damdi name siyamakamake na toudi sivibagubagurana da kiiwawo Nebukednesa da natunatuna teya siyabagibagiyedi patana da Pesiya kubura wiibada maragasina ikabi. ");
INSERT INTO aui_vpl VALUES ("R236_21","015_36_21","2CH","36","21","21","Wasina bi Yawe God wonana peroveta Jerimaiya kawanama siyakanikanibu na irumaghatara: Da tanawa yana wiiyawiitaveyana gabudaridi na iviyawiitaveyana patana da bodu 70 sikovi. ");
INSERT INTO aui_vpl VALUES ("R236_22","015_36_22","2CH","36","22","22","Wasina bi Pesiya kubura kana kiiwawo Sairus yana wiikiiwawo boduna dagudagune na, noko warana Yawe God peroveta Jerimaiya iyaverevereni na itubugha. Yawe God ibera da Sairus nuwanuwana irukawari na sisiya igiruma bi ivipora kubura tupadi yana wiibana rogune da wawaya akovina siyakabi. ");
INSERT INTO aui_vpl VALUES ("R236_23","015_36_23","2CH","36","23","23","Mmkona metagha Pesiya kana kiiwawo Sairus iwona: Abama kana God, Yawe kubura tumtumpipinina tupana kana wiibadana iveregu. Bi bagibagi iveregu na yana Bare Kabikabikuwayina Jerusalem kwanatune anayoghani Jiuda kubura kamone. Yawe God yana wawaya iiyawogha sawiiwiini veramagha na rubana nabo sinaveramagha, bi Yawe yami God na tami yawata gwabimiye. ");
INSERT INTO aui_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Isrel damdi noko raghanine nawaravi 7 kamone na yadi kwanatuve, kwanatuve siyamakamake, na tupadi nuwanuwadi tanagha bi Jerusalem kwanatune sivitaghomidi. ");
INSERT INTO aui_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","Wasina bi Josadak natuna Jesuwa da prist mududi yawata bi Sieltiel natuna Zerubabel, da yana rakaraka teya, Isrel kana God yana suwara gabugabuna gawarina yoghana mayenina sidaguni, da debane suwara siyagabuna ware sira nunune, God yana peroveta Mosis yana gwara kamone na naboni. ");
INSERT INTO aui_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Isrel damdi na wawaya mududi iiyawogha nama noko kuburine makamakedi siyanaghanagharedi, bi gegha da suwara gabugabuna gawarina kana gharauve siyoghana mayeni. Wasina bi sigeghomiiri da suwara gabugabuna gawarina debane didibara da ravidi puyodi siyagabugabuna da naboni suwara Yawe God biidi. ");
INSERT INTO aui_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Wasina bi Isrel damdi sigeghomiiri da akima tarapapi damdi da yoghayoghana damdi sigimonidi, bi kate kam, wain da oliv Saidon da Taya damdi siveredi da Lebinon kuburama sida kiidi kiiravidiye, kiidi na Lebinon kubure sagogogo bi siyayowoyedi kikire bi yegiigha siyadeudi siyanagho Jopa kawakedane, metagha Pesiya yadi kiiwawo Sairus iwona na naboni. ");
INSERT INTO aui_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Wasina bi sipiika God yana bare Jerusalem kwanatuna kamone, boduna ikovi murine bi bodu tane nawaravi wiibatane na yoghana bagibagina sidaguni. ");
INSERT INTO aui_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Wasina bi Isrel damdi, da prist, da dam Livai tomotomogha da kate wawaya iiyawogha kadi aviya sikabidi bi siviveramayidi na tupadi God yana bare wiimiiseyanina nuwamiiseye porayina sibera. ");
INSERT INTO aui_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Wawaya tupadi sipiika debadebae matamketa tana sakwatuveni rarima naghone sivitaghomidi bi gwara wiiyeveveyana tomoyina kana waghawagha Esra siwoneni da Mosis yana gwara bukana meko Yawe God sisiya bagibagidi Isrel damdi iveredi na iyakawari iyapiika. ");
INSERT INTO aui_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Wasina bi nawaravi kana wii 7 bi gabudara dagudagune na prist kana waghawagha Esra gwara bukana ikawari ipiika wawaya biiyadi, tomotomogha, wasiwasike da ededa iiyawogha kadi bodu rubana da siyakowa na sivitaghomidi. ");
INSERT INTO aui_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Na debadebae bi Esra gwara bukana ikabiyawa gwaruveni wawaya biiyadi. Touna kabiyawa gabudara iyageegeena idaguni patana da gabudara yubasuve, bi wawaya tupadi gwara bukana siwaiyanena wiimasiyeni. ");
INSERT INTO aui_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Esra na pesapesa debane iyamiimiiri na wawaya tupadi rubana siyakitakita. Bi raghanine gwara bukana irutatari bi wawaya sikita na yadi kabikarawagha Yawe God yana gwara biidi sitore na tupadi simakegeghomiiri. ");
INSERT INTO aui_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Wasina bi Esra iwona bo, “Kabepepa Yawe biidi, God maragata kirakiina!” Na wawaya tupadi imadi sirukabekabepa kiidamove bi siwona bo, “Waghasina! Waghasina, noko wiisuwona!” Wasina bi sivituwapore oghogheyana da mayiyidi siyowogha dobodobove bi Yawe God sikabepepi. ");
INSERT INTO aui_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","Livait gwara bukana sikabiyavi bi yana basuna wawaya biiyadi sivisisiyena yapoyaporidi, na wawaya akovina siyakabi wiimasiyeni da awaki sikabiyavi. ");
INSERT INTO aui_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Noko raghanine wawaya gwara sisiyidi siwaiyana, na kiiravine siyaduudu na gavena Niyamaiya, bi Esra touna prist bi gwara wiiyeveveyana tomoyina, da kate dam Livai tomotomogha, toudi na gwara kana wonawonavereyana wawayidi sigeghomiiri da wawaya tupadi siwonedi bo, “Mmko gabudarina na kabikabikuwayina Yawe yami God kiiravine na gekoninuwabero bo konaduuna!” ");
INSERT INTO aui_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Wasina bi Niyamaiya sisiya ivikiitayini iwona bo, “Konagho bareye bi kepo kobera, kam miimiisedi kokam, wain metevidi koniuna, bi wawaya iiyawogha moyamoyakidi na toudi teya kovikamvereyana. Mmko gabudarina na kabikabikuwayina yada Bada biidi, na gekoninuwaberona, kiiravine Yawe God yana nuwamiise tami biiyadi na yami maragata!” ");
INSERT INTO aui_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Raghani tana name Us kubure na tomogha tana kana waghawagha Job iyamakamake. Bi tomogha miisena da God kawagha iyakabekabepepi da bera rotomanidi iyaberabera. ");
INSERT INTO aui_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Touna natunatuna tomotomogha yadi 7 bi wasiwasike yadi 3, ");
INSERT INTO aui_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","bi yana sip yadi 7,000, kamel yadi 3,000, bi kau yadi 1,000 da donki yagayagaridi yadi 500 bi kate yana wiitamatamariyana korotodi. Touna imoura kirakii gegha ware wawaya mududi nama raghani matana kubure naboni. ");
INSERT INTO aui_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Job natunatuna tomotomogha na nonowa tatadigegha yadi gabudara duma kepo yadi bareye siyatutoura bi warewaresidi da nughunughudi yadi 3 siyiyonedi siyapiipiika da yawata siyakamkam niniuna. ");
INSERT INTO aui_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Kepo gabudaridi sakovi bi muridiye, na Job natunatuna yadi sisiya yadaru na sapiika touna biidi da yaberadi da God matane na toudi miisedi. Yana noghota na, “Meboda natunatugu berona sibera, bo meboda nuwanuwadiye God sivisisiyena beroveni.” Na didibara wote yageghomiiri na ribiribi yagabuna da God biidi yasuwara natunatuna kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Wasina bi gabudara tana God yana aneyaneya sivitaghomidi Yawe naghone, bi Seitan na bada nama kamodiye yawata. ");
INSERT INTO aui_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Na Yawe God igeghomiiri da Seitan ivitarakiiyaneni bo, “Tam katota wota na mema kupiika?” Na Seitan iwona bo, “Tagu kubure ayapeepewa wapawapa, nabo ayanono mabo ayapiipiika.” ");
INSERT INTO aui_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Wasina bi Yawe God, Seitan ivitarakiiyaneni bo, “Da yagu wiitamariyana Job kwanoghonoghosi bo gegha? Touna wawaya miisena, geware wawaya mududi kubure naboni. Bi bera rotomanidi kawagha yaberabera da God yakabikabikuwayeni bi bera berodi geiyaberaberana.” ");
INSERT INTO aui_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Bi Seitan iwona bo, “Tam kukoyagha yapori, noko biidi yakabikabikarawayem! ");
INSERT INTO aui_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","Na nonowa touna bi yana rakaraka da yana sawara tupadi kwababaredi. Awaki tupana yaberabera na tam kwiimiiseyeni na yana bagibagi wasina kawakawa, na kata yana kau da sip sipeyara. ");
INSERT INTO aui_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","Bi memeda imam kunakoghasi da yana sawara tupadi kuna kabitavetaveyana, na rubana da matamve bi inakaradeba da inisisiya berovem.” ");
INSERT INTO aui_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Na Yawe God, Seitan iwoneni bo, “Waghasina, Sawara tupadi rapene na yam maragate atoretoredi, bi gegha tubuyina kuniberona.” Wasina bi Seitan, Yawe God naghonama inaghotaveyana. ");
INSERT INTO aui_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Gabudara tana raghanina Job natunatuna tomotomogha da wasiwasike toghadiru iyarokona yana bareye siyakamkam kepokepo, ");
INSERT INTO aui_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","na sawariyonayona tana ipiika Job yana bareye, bi iwoneni bo, “Yam kau kwabuve siyaroverove bi yam donki na nama riiridiye rei siyakamkam, ");
INSERT INTO aui_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","raghani tana wawaya yapiyapidi toudi na Siba damdi sipiika da ribiribi tupadi siyapi bi wiitamariyana tupadi sivikasunughana, wasina tagu kawagha ayawa, na averataveyana apiika da tam ayawonawiikatayim!” ");
INSERT INTO aui_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Tomoyina patana iyisisiya, bi sawariyonayona tana iverakanibu da iwona bo, “Namanamara abamama iyogha iyowogha na yam sip da kadi koyakoyagha ivikarunughana, wasina tagu kawagha ayawa, na averataveyana apiika da tam ayawonawiikatayim!” ");
INSERT INTO aui_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Noko tomoyina patana iyisisiya, bi sawariyonayona kana wiiaroba iverakanibu da iwona bo, “Yapiyapi damdi borudi aroba Babilon kuburama, yam kamel tupadi siyapi da yam wiitamatamariyana sivikasunughana. Wasina tagu kawagha ayawa na averataveyana apiika da tam ayawonawiikatayim!” ");
INSERT INTO aui_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Noko tomoyina bada patana iyisisiya, bi sawariyonayona tana bada iverakanibu da iwona bo, “Natunatum tomotomogha da wasiwasike siyakamkam kepokepo, natum tomogha tubugha yainina yana bareye. ");
INSERT INTO aui_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","Bi yaininagha yanunu maragasina mayabama irughu da bare itapi kirakiiyeni, na barena ibeku da natunatum tupadi kamone ivikasunughana. Wasina tagu kawagha ayawa na averataveyana apiika da ayawonawiikatayim!” ");
INSERT INTO aui_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Wasina bi Job imakegeghomiiri, da kana kwama itayina gosigosira bi gayamina imurataveni da noko yana wiinuwabero matakirina. Bi ivituwapore oghogheyana da mayiyina iyowogha dobodobove da God iyakabikuwayeni. ");
INSERT INTO aui_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","Na iwona bo, “Getana awakima ayimakabi babarana bi atubugha, da getana awakima animakabi babara raghanina anarabobona. Yawe God sawara iveregu, bi bada Yawe God sawaridi gwabiguve na ikabitavetaveyana; na Yawe God kana waghawagha anakabepepi.” ");
INSERT INTO aui_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Mmkodi nuwapoya tupadi Job biidi situbugha, bi gegha iyawona da God ibera bero, Job tamumu genaboni iyaberana. ");
INSERT INTO aui_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Gabudara tana God yana aneyaneya sivitaghoma mayedi Yawe God naghone, bi Seitan na bada nama kamodiye yawata na ipiika da Yawe God naghone imiiri. ");
INSERT INTO aui_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Na Yawe God igeghomiiri da Seitan ivitarakiiyaneni bo, “Tam katota wota na mema kupiika?” Na Seitan iwona bo, “Tagu kubure ayapeepewa wapawapa, nabo ayanono mabo ayapiipiika.” ");
INSERT INTO aui_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Wasina bi Yawe God igeghomiiri da Seitan ivitarakiiyaneni bo, “Da yagu wiitamariyana Job kwanoghonoghosi bo gegha? Touna tomogha miisena, geware wawaya mududi kubure naboni. Bi bera rotomanidi kawagha yaberabera, bi God yakabikabikarawayeni da bera berodi geiyaberaberana. Touna getana awaki berona iyabera bi kutupegu da gebasuna bi ayakasiwiibero, bi gegha da patana bera rotomanidi yaberabera da yakabikabikuwayegu.” ");
INSERT INTO aui_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Seitan igeghomiiri da Yawe God iwoneni bo, “Touna, tounamani tubuyina yanoghonoghota mayeni! Tomogha yana yawa kiiravine na yana sawara tupadi inavereyana tavetaveyana bi inamake. ");
INSERT INTO aui_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Bi memeda imam kunakoghasi da tubuyina kuna kasiwiibero, na rubana da matamve bi inakaradeba da inisisiya berovem!” ");
INSERT INTO aui_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Na Yawe God igeghomiiri da Seitan iwoneni bo, “Waghasina, Tagu tubuyina yam maragate atoretore, bi gegha kuna kasunuyina!” ");
INSERT INTO aui_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Wasina bi Seitan igeghomiiri da Yawe God naghonama inaghotaveyana. Bi ibera kayowiiwiiyaka da gubaga berona Job sinine sikarabubu, kaye kamone da igae inagho gayamina. ");
INSERT INTO aui_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Noko biidi Job yana wiinuwabero matakirina kiiravine na yapukare imakeyarayi iyamakamake bi nau tamobogana sepinama kana gubaga iyaghosighosidi. ");
INSERT INTO aui_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Na wavinena iwona bo, “Mmkodi piropiro tam biidi situbugha na awaki kiiravine tam patana bera rotomanidi kwaberabera da kate God kwakabikabikuwayeni? Rubana da God kuyawona wiiberoveni na wasina da kuyarabobo!” ");
INSERT INTO aui_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Bi gegha, Job iwona bo, “Tam kwiisisiya na ware wasike neghaneghana naboni. Touda sawara miimiisedi God gwabinama tayuyouna, noko biidi raghanina sawara berodi yavereda, na touda teya tanayouna!” Mmkodi piropiro tupadi situbugha Job biidi, bi gegha, getana God iyisisiya berovenina. ");
INSERT INTO aui_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","11","Job turaturana yadi aroba, kadi waghawagha na Elipas yana kwanatu na Teman, bi Bildad yana kubura na Sua bi Jopar yana kwanatu na Naamat. Bi raghanina Job yana piropiro sisiyidi siwaiyana na sivitaghomidi bi sivikiiwaga sinagho touna biidi da siyawona wiikayokayowaneni. ");
INSERT INTO aui_vpl VALUES ("JB2_12","019_2_12","JOB","2","12","12","Raghanina rabarabama Job sikita na gesiyakita akovina. Bi akovina sikabi na siduu siyapa, da kadi gara sitayina gosigosira bi popoku siyitavetaveyana kiidamove bi gayamidiye siyatutoura da yadi nuwavisi kiiravine siyimatakira. ");
INSERT INTO aui_vpl VALUES ("JB2_13","019_2_13","JOB","2","13","13","Bi siverakanibu na gabudara 7 bi nubabasu 7 Job yawata dobodobove simakeyowogha. Getana iiyabo awaki iyisisiyenina, simake wiiraborabobo, kiiravine sikita da Job yana kabikwarakwara na ibero kirakii. ");
INSERT INTO aui_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Noko taparorone raghanine getana iiyabo iyisisiya bi murine, na Job ikararupama da ere ghakighakina sinananaki ivitubuyina gabudarina ivisisiya beroveni. ");
INSERT INTO aui_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","Iwona bo, ");
INSERT INTO aui_vpl VALUES ("JB3_3","019_3_3","JOB","3","3","3","“O God, sinagunaki ivitubuyigu na gabudarina kasunaghataveni da kate nubabasune siwona bo, ‘Tomogha itubugha.’ ");
INSERT INTO aui_vpl VALUES ("JB3_4","019_3_4","JOB","3","4","4","Noko gabudarina na inididibari! God kiidamove kate geininoyenina, da yeghana kate geinarukarata debanena. ");
INSERT INTO aui_vpl VALUES ("JB3_5","019_3_5","JOB","3","5","5","Wiididibara ghamana noko gabudarina inibonuvi; Uwa wowonagha inasowo mumu, bi mmko wiididibarina inabera da sinagunaki ivitubuyiguna gabudarina inanaghara kirakii. ");
INSERT INTO aui_vpl VALUES ("JB3_6","019_3_6","JOB","3","6","6","Wiididibara ghamana noko nubabasuna inakabitawani! Noko nubabasuna kate geininuwamiise ware gabudara mududi naboni bodu tana kamone; genoko boduna kamone sinakabiyawa wiikapuna. ");
INSERT INTO aui_vpl VALUES ("JB3_7","019_3_7","JOB","3","7","7","Noko nubabasuna na inigagara, getana nuwamiise rukwatudi sinawaiyana. ");
INSERT INTO aui_vpl VALUES ("JB3_8","019_3_8","JOB","3","8","8","Imapu damdi iiyawogha sakovi da metagha yegii motana ghamanakina sinakasiwiimatakina, na toudi damdi mmko gabudarina sinawona imimagi. ");
INSERT INTO aui_vpl VALUES ("JB3_9","019_3_9","JOB","3","9","9","Rubana raghani boribori kewokewona inididibari, rubana da raghani yeghanina inakoyagha kawakawa da raghani didigubana na geinakitana, ");
INSERT INTO aui_vpl VALUES ("JB3_10","019_3_10","JOB","3","10","10","kiiravine noko wiididibarina sinagunaki raparapana matamketana geiyagudu bodenina, getana piropiro gwabiguma iyikowoyidina. ");
INSERT INTO aui_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","Iyamiise da sinagunaki kamokamone ayarabobo, bo ayatubutubugha na raghanine ayarabobo. ");
INSERT INTO aui_vpl VALUES ("JB3_12","019_3_12","JOB","3","12","12","Awaki kiiravine sinagunaki manonone ivikenegu? Bi awaki kiiravine susunama ivisusugu? ");
INSERT INTO aui_vpl VALUES ("JB3_13","019_3_13","JOB","3","13","13","Memeda yagu tubugha raghanine ayarabobo, na tagu ayakenayowogha, ayiraborabobo; Augunai da tagu ayakenakena, bi nuwaruririye ayiiyawiitaveyana.” ");
INSERT INTO aui_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Wasina bi Teman tomogha Elipas iwonabodeyana bo, ");
INSERT INTO aui_vpl VALUES ("JB4_2","019_4_2","JOB","4","2","2","“Meboda animatipo da wiisisiya biidi, na nuwanuwam inapughu bo gegha? Basuna gerubana da mmko raghanine anikawapotapota makena. ");
INSERT INTO aui_vpl VALUES ("JB4_3","019_4_3","JOB","4","3","3","Wasina tam raghani katamanidiye wawaya korotodi kuviyevevedi, bi wawaya noganogadi kuviwiitedi da sivimaragata. ");
INSERT INTO aui_vpl VALUES ("JB4_4","019_4_4","JOB","4","4","4","Yam sisiya na wawaya bekubekudi ikabiwiigeghomiiridi; bi wawaya utukirokirorodi kuberadi da sivimaragata. ");
INSERT INTO aui_vpl VALUES ("JB4_5","019_4_5","JOB","4","5","5","Bi katana piropiro ipiika tam biidi, na tam gekuyitumaghanana; piropirona ikabitowoyim, na parapa kwanaghanaghara. ");
INSERT INTO aui_vpl VALUES ("JB4_6","019_4_6","JOB","4","6","6","Metagha, God kabepepina yam noghota yimaragasi bo gegha? Bi yam makamake yawana noghota yavereverem da tam wasina bo? ");
INSERT INTO aui_vpl VALUES ("JB4_7","019_4_7","JOB","4","7","7","Mmko kunuwagiureni! Da wawaya iiyawogha bera berodi gesiyaberaberana sarabobo? Bo wawaya yadi makamake yawana rotomanidi, God iviberodi bo gegha? Gegha! ");
INSERT INTO aui_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","Bi yagu wiikitakitayena, wawaya iiyawogha berona sarove bi piropiro sawavi, na damone mayimayiyina sinakabipura.” ");
INSERT INTO aui_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Wasina bi Yawe God yanunu virovirogha kamonama Job iwonabodeni bo, ");
INSERT INTO aui_vpl VALUES ("JB38_2","019_38_2","JOB","38","2","2","“Metagha, bi yam sisiya kwabudima yagu nuwagiura kiiravine kwiitarakiiyana? ");
INSERT INTO aui_vpl VALUES ("JB38_3","019_38_3","JOB","38","3","3","Kabunagha da tomogha naboni bagibagi ghamana kiiravine; Basuna gwabiguve na wiitarakiiyana viya tam kiiravimve, da kunawonabodeyana. ");
INSERT INTO aui_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","Raghanina kubura kayena ayaberabera, na tam meme barasina? Mmko kunakovi na kuwonegu. ");
INSERT INTO aui_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","Kwakovi bo gegha da iiyabo kana ruba inuwagiureni? Bi iiyabo imana irutatari da irubani? ");
INSERT INTO aui_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","Kayena awaki debane ivitukikita, bo iiyabo papasusu koghorina ikabiwiimiiri, ");
INSERT INTO aui_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","noko raghanine, na raghani boribori kewokewodi tupadi sitawora patapata bi aneyaneya tupadi nuwamiise kiiravine sirukwatu? ");
INSERT INTO aui_vpl VALUES ("JB38_8","019_38_8","JOB","38","8","8","Iiyabo matamketa itoredi da yegii iyamiiri babareni raghanina raparapama ivikwata ikanibuna?” ");
INSERT INTO aui_vpl VALUES ("JB40_1","019_40_1","JOB","40","1","1","Wasina bi Yawe God ivisisiya iwona bo, ");
INSERT INTO aui_vpl VALUES ("JB40_2","019_40_2","JOB","40","2","2","“Job, rubana bo gegha da tagu, God Maragata Kirakiigu teya wiikawakereyana kuyakabitore? Bi memeda tagu biidi kuna gwini, na wasina yagu wiitarakiiyana kunawonabodedi.” ");
INSERT INTO aui_vpl VALUES ("JB40_3","019_40_3","JOB","40","3","3","Wasina bi Job, Yawe God iwonabodeni bo, ");
INSERT INTO aui_vpl VALUES ("JB40_4","019_40_4","JOB","40","4","4","“Tagu getomogha wapawapa, metagha bi tam, God anawonabodem? Bi kawagu imaguma anagudu da anikawapotapota. ");
INSERT INTO aui_vpl VALUES ("JB40_5","019_40_5","JOB","40","5","5","Tagu nada avisisiya, bi gerubana anawonabodemna. Bi getana awaki da anisisiya maghana.” ");
INSERT INTO aui_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Wasina bi Job ivisisiya magha Yawe God biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","“Akovim Yawe God, tam rubana bera tupadi kunabera, da getana iiyabo inigesiyem da awaki kwanoghonoghosi kuyabera na gekunaberana. ");
INSERT INTO aui_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","Tam kuvitarakiyanegu bo, ‘Metagha bi tam, yagu nuwagiura kiiravine yam sisiya kwebudima kwiitarakiiyana?’ Wiisuwona, tagu sawara geayakowa na kiiravidiye avisisiyana, parapa sawara ghamanakidi gerubana akovidi ayayouna na kiiravidiye avisisiya. ");
INSERT INTO aui_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","Tam kuwonegu bo, ‘Kuwaiyana bi anisisiya! Tagu anitarakiiyanem, bi tam kunawonabodeyana.’ ");
INSERT INTO aui_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Naghove na wawaya mududi tam kiiravimve siwonegu na touna kawagha akovi, bi katana tagumani mataguma akitam. ");
INSERT INTO aui_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Na yagu sisiya tupadi kiiravidiye na iisinimayagha, bi popoku da yapukare kamodiye amakamake, noko yagu miiriwamira kanawiiyeveveyana.” ");
INSERT INTO aui_vpl VALUES ("JB42_7","019_42_7","JOB","42","7","7","Yawe God mmkodi sisiya Job biidi ivisisiya ikovi murine, na Teman kwanatuna kamonama tomogha kana waghawagha Elipas biidi ivisisiya iwona bo, “Tagu nuwanuwagu ipughu tam da turaturam yadi bata biiyadi, basuna kiiraviguve gewiisuwona koyisisiyeni ware yagu wiitamariyana Job iberana naboni. ");
INSERT INTO aui_vpl VALUES ("JB42_8","019_42_8","JOB","42","8","8","Na kata kau makidi 7 da sip makidi 7 koyouna bi konagho yagu tamariyana Job biidi da puyo gabugabunidi konasuwara tamimani kiiravimiye. Touna kiiravimiye inarupari, bi metagha inibabiiguna naboni kiiravimiye anabera, da bagune bera berona kobera bi gesinimayagha anaveremina. Tami, gegha wiisuwona sisiyidi kiiraviguve koyaberana, ware Job ibera na naboni.” ");
INSERT INTO aui_vpl VALUES ("JB42_9","019_42_9","JOB","42","9","9","Na Teman kwanatunama tomogha Elipas, bi Bildad yana kubura Sua da Naamat tomogha Jopar metagha Yawe God iwonedi na naboni sibera, bi Yawe God na metagha Job ivibaba na naboni ibera. ");
INSERT INTO aui_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Job turaturana kiiravidiye irupari ikovi murine, na Yawe God ibera da Job imouramagha. Sawara tupadi naghove rapenena Yawe God iveremayeni bi bada debane iviagagumayeni. ");
INSERT INTO aui_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Job warewaresina da genegeneghuna tupadi da iiyawogha naghove sakovina, sipiika yana bareye da yawata siyakam patapata. Piropiro tupadi Yawe God ipiikedi Job biidi kiiravine na sivinuwapoyeni bi siwona wiitoratorani. Bi wawaya tatadigegha mane mududi da imakwaki gouldma beraberadi sikabigunaveni. ");
INSERT INTO aui_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Job yana make yawana damona Yawe God ivimiiseyena kirakiiyeni geware yana make yawana dagudagune naboni. Na kata Job ribiribi ivirapeneyana na erenonoyina sip yadi 14,000 bi kamel yadi 6,000 bi kau yadi 1,000 da donki yagayagaridi yadi 1,000. ");
INSERT INTO aui_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Bi kate bada natunatuna tomotomogha yadi 7 bi wasiwasike yadi 3. ");
INSERT INTO aui_vpl VALUES ("JB42_14","019_42_14","JOB","42","14","14","Natuna wasike iyarokona iviwaghawaghayeni Jimaima, tububasuna iviwaghawaghayeni Kisaiya, bi wiiarobina na Keren-Hapuk. ");
INSERT INTO aui_vpl VALUES ("JB42_15","019_42_15","JOB","42","15","15","Kubura tupana debane na getana wasiwasike nama siyikepamara ware Job natunatuna wasiwasikedi naboni. Job iwonedi da raghanina inarabobo bi murine na yana moura sinarereyi da riba 10 bi ededidi tatadigegha na riba tanagha sinakabi, genatunatuna tomotomogha kawaghana, bi gegha da natunatuna wasiwasike yawata. ");
INSERT INTO aui_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","Mmko murine na Job imake da bodu 140. Na parapa imake da raghani gurina bi tubutubuna ikitadi da kate tubutubuna natunatudi bi iyowogha inagho da kimta ruwamaruwa. ");
INSERT INTO aui_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Bi raghanina Job imoraba kirakii, na irabobo. ");
INSERT INTO aui_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Wawaya iiyawogha berabero wawayidi geyawata siyapeepewa bi yadi sisiya gesiyakivikivina, da bada gewiigeruwana damdi yadi sisiya siyawaiwaiyana raghanina God sinamayenina, toudi nuwamiise wawayidi. ");
INSERT INTO aui_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Bi gegha da Yawe God yana wiiyeveveyana sivinuwayuyuneni, na raghani nonowa gabudara da nubabasu na yana gwara sinuwanoghonoghoteni. ");
INSERT INTO aui_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Toudi ware kii rarima kawabarane siwawa na naboni, kadi iri vinevineyina nunune suwagha bi rugurugudi gesiyaraborabobo da siyariirighana. Wawaya nokodi naboni, na awaki sabera na berana kamna yatubugha. ");
INSERT INTO aui_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Bi berabero wawayidi na genaboni. Toudi na ware rugurugu pokina naboni, yanunu yatapitaveni. ");
INSERT INTO aui_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Na God matane na toudi gewasina raghanina wawaya initupawamiwamiredina gabudarine, toudi kate gegha God yana wawaya yawata sinikapudina. ");
INSERT INTO aui_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Yawe God kana kivikivina yinaghovedi bi yakoyayidi, bi berabero wawayidi na rabobo kedane sapeepewa. ");
INSERT INTO aui_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ayina Deivid igirumi Yawe God yakoyakoyayigu ware sip bodaboda yana sip yakoyakoyayidina naboni na getana awaki ayadadina. ");
INSERT INTO aui_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Bi yaberagu da idu miisediye akenayowogha, bi rarima nighorovidi riridiye yinaghovegu. ");
INSERT INTO aui_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Touna yawa wouna yavereveregu, bi keda rotomanidiye yinaghovegu basuna yana keda waghata na nonowa rotomanidi. ");
INSERT INTO aui_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Raghani viya na anagha wiididibaridiye apeepewa, bi gegha ayanaghanagharana, basuna tam kwabaabaregu da kwiiwiitegu, ware sip bodaboda yana kiima sip yitarababaranedi bi yakoyakoyayidina naboni. ");
INSERT INTO aui_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Kagu aviya matadiye bi tam kepo kiiraviguve kwakabunayi. Tam oil gayamiguve kwiiwayi da wiiyeveveyana tam kwakabikabi karawayegu. Yagu niniuna reduna kwiibonuvi yakamiviwayi ");
INSERT INTO aui_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Akovi da tam kuninuwayuyunegu bi miisena kunabera tagu biidi patana da anarabobo da Yawe God yana bareye anamake waghata. ");
INSERT INTO aui_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Ayina Deivid igirumi Yagu yeghana na Yawe God gwabinama yapiipiika, bi yiyawiigu na geananagharana. Touna piropiro gwabidima yamiiri babaregu na kate geiiyabo ananagharenina. ");
INSERT INTO aui_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Raghanina kagu aviya, iiyawogha na wawaya beroberodi sinagogona tagu biidi bi sinimatipo da kasunuyigu, na toudi wosina sinataguredi da sinabeku. ");
INSERT INTO aui_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Meboda aviya peyaridi sinapiika sinituwiikapudi da sinagogona tagu biidi, bi gegha da geananagharedina. Raghanina sinagogona tagu biidi, na tagu Yawe God kawagha anitumaghaneni. ");
INSERT INTO aui_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Tagu sawara tanagha kiiravine Yawe God avibabiini, sawara tanagha kawagha akayoveni: Yagu wiina kirakii da yagu yawa tupana kamone na yana bare kamone anamakae, bi anakita da touna imiise da awaki patana bi yana Bare Kabikabikuwayine anarupari touna biidi. ");
INSERT INTO aui_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Raghanina piropiro anabanani na yana gawara nighorovine inikowoyigu, bi yana bare kamone inababaregu, touna akima kiidamo kirakiine inatoregeeyegu meme kagu aviya gerubana sinakabiguna. ");
INSERT INTO aui_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Kagu aviya sinagwagwara wiikenaviviregu, bi gegha da animaragata kirakii da anageiwayidi. Yawe God yana bare kabikabikuwayina kamone tagu suwara anagibu, bi nuwamiiseye anarukwatu da anatawora bi inawa anarouwa da ayima anakabepepi. ");
INSERT INTO aui_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yawe God, raghanina arupari tam biidi na kwawaiyanegu, kinuwanuwaghanegu bi yagu sisiya kuwonabodegu! ");
INSERT INTO aui_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Tam kuwonegu bo, Piika kunisisiya tagu biidi, na kata apiipiika tam biidi. ");
INSERT INTO aui_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Tagu yam wiitamariyana, genuwanuwam inapughu da kunamiiri kubuteguna, gegwabiguma kunakowoghana! Tam kuviyawiigu bi nonowa kwiiwiitegu, na kata gekunakuyoveguna! ");
INSERT INTO aui_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Meboda tamagunaki da sinagunaki sinamiiri kubutegu, bi gegha, Yawe God na nonowa inakoyakoyayigu. ");
INSERT INTO aui_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Yawe God, kagu aviya sikoyakoyagha da sinaburavigu, na kiyevevegu da anakivinim, bi keda rotomanidiye kinaghovegu. ");
INSERT INTO aui_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Nokodi aviyidi kiiraviguve sisiya wiiyaba saberabera, yadi wiina da siniberogu, na gekuniwaghasinedi da sinaburaviguna! ");
INSERT INTO aui_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Bi gegha da iitumaghana da Yawe God miisena inabera tagu biidi, raghanina mmko kuburina debane patana yawayawiiguve amakamakena bi anakitani da noko inabera. ");
INSERT INTO aui_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Na tam Yawe God kitumaghaneni, kimaragata bi nuwanuwam inatora, na Yawe God kitumaghaneni. ");
INSERT INTO aui_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Raghani tana Abimelek naghone bi Deivid ibera da ware iyaneghanegha na iviporataveni inagho. Muriye na God metagha Deivid iviwiiteni na kiiravine noko raghanine mmko ayina igirumi. Tagu raghani nonowa Yawe God anakabepepi bi yana miisena kiiravine anisisiya. ");
INSERT INTO aui_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Tagu kana waghawagha iragata kirakii na anakabepepi, tami moyamoyakimi yagu sisiya koyawaiyana bi koyinuwamiise. ");
INSERT INTO aui_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Kobera da tupada Yawe God tana kabepepi, kobera da tupada kana waghawagha tana kabikarawayeni! ");
INSERT INTO aui_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Tagu arupari Yawe God biidi na iwonabodegu, nokodi wawaya ayanaghanagharedi, na gwabidima iviyawiigu. ");
INSERT INTO aui_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Wawaya iiyawogha wiiwiita kiiravine samiiri wamira Yawe God biidi, na toudi parapa sinuwamiise, bi nonowa iniwiitedi. ");
INSERT INTO aui_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Tagu piropiro kamone bi arupari na Yawe God iwaiyanegu, touna yagu nuwapoya tupadi kamodima iviyawiigu. ");
INSERT INTO aui_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Bi wawaya iiyawogha Yawe God sakabi karawayeni, na yana aneya inakoyayidi, bi riiridiye yamake da yitarababaranedi. ");
INSERT INTO aui_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Na Yawe God biidi komiiriwamira bi tami bada konakabibanani da yana miisena metagha. Memeda wiiwiita kiiravine konanagho touna biidi, na tami parapa koninuwamiise. ");
INSERT INTO aui_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Tami wiiwiigeruwana dammi, Yawe God kokabikarawayeni. Wawaya iiyawogha sakabikarawayeni na getana awaki siyadadiyenina. ");
INSERT INTO aui_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Raghani viya, na laiyon kadi kam sarukwamra na vitonana sarabobo, bi gegha da Yawe God yana wiiwiigeruwana damdi na sawara miisedi bogaebogae gesinadiyanana. ");
INSERT INTO aui_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Natunatugu, kopiika yagu sisiya konawaiyana. Tagu aniyevevemi da metagha Yawe God konakabikuwayeni. ");
INSERT INTO aui_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Memeda makewiiguri konakayoveni bi yawa miisena kabina, ");
INSERT INTO aui_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","na gewawaya konisisiya berovedi da gekoniyabana. ");
INSERT INTO aui_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Berabero beradima komiiriwamira, bi miisena konabera, kovi matipo kirakii bi wawaya koniwiitedi da nuwaruririye sinamakae. ");
INSERT INTO aui_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yawe God na rotomana berabera wawayidi yakighukighudi, raghanina wiiwiita kiiravine sakwatu touna biidi na yawaiyanedi. ");
INSERT INTO aui_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Bi bera bero wawayidi na yamiiri kubutedi da yiaviyedi, toudi sinarabobo da getana iiyabo inanoghota mayedina. ");
INSERT INTO aui_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Raghanina Yawe God yana wawaya wiiwiita kiiravine sarukwatu, na yawaiyanedi, da yadi piropiroma yiyawiidi. ");
INSERT INTO aui_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yawe God na noghota kawakawa wawayidi yagwabigwabiyedi, bi raghanina wawaya yadi noghota parapa sabeku na yiwiitedi. ");
INSERT INTO aui_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Rotomana berabera wawayidi na nuwapoya peyaridi sabanana, bi gegha da Yawe God yiwiitena nonovedi. ");
INSERT INTO aui_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Touna irikedi tupadi yabaabarena wiimasiyedi da irikedi getana inipokina. ");
INSERT INTO aui_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Bi wawaya berodi kiiravidiye, na toudi wosina yadi berona sinageghomiiri da sinirabobodi, bi rotomana berabera wawayidi kadi aviya na aro sinakabi. ");
INSERT INTO aui_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Bi gegha, Yawe God yana wiitamariyana yiyawiidi. Wawaya iiyawogha wiiwiita kiiravine samiiri karona touna biidi na aro gesinabananina. ");
INSERT INTO aui_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Raghani tana kiiwawo Deivid madawara ibera, tomogha kana waghawagha Uraiya wavinena kana waghawagha Betsiba yawata. Na God yana peroveta Neitan noko berana kiiravine ikini na Deivid yanabera kiiravine ivinuwapoya na God biidi mmko parina igirumi. O God, yam nuwayuyuna geiyakovikovina na miisena kubera tagu biidi. Tam nonowa wawaya kwiinuwapoyedi, na berona ayaberabera na kunoghotataveni; ");
INSERT INTO aui_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","yagu berona koghataveni, bi yagu tamumu kugigirataveni ware wawaya gara dadabuna sakoghatavenina naboni. ");
INSERT INTO aui_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Berona ayaberabera na akovi, raghani nonowa na iinuwanoghonoghoteni. ");
INSERT INTO aui_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Tagu berona tam biidi abera, tam kawagha; yagu kabikwayo matam kamone ibero. Na raghanina kuwonegu bo, “Tam bera berona kubera!” Na tam wonawaghata kwiisisiya. Raghanina aro kunavereguna, tam bera rotomanina kwaberabera. ");
INSERT INTO aui_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Yagu tubugha raghanine da kata na tagu tamumu wawayigu, raghanina tagu patana sinagunaki kamokamone na tagu naboni abero. ");
INSERT INTO aui_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Bi gegha da kukayoveni da nuwanuwagu kamone wiisuwona iyibonuvigu na noghota miisena nama kuviyevevegu. ");
INSERT INTO aui_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Yagu berona ayaberabera na kukoghataveni da anamiise magha; da parapa anapoe wamira. ");
INSERT INTO aui_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Kuwonegu da tam kunoghotatavegu na wiisuwona aninuwamiise! Naghove, tam irikegu kugawowora, katana kubera da aninuwamiise magha. ");
INSERT INTO aui_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Geyagu berona kunakita kirakiiyedina bi kabitavena tuwanonoyidi. ");
INSERT INTO aui_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O God, nuwanuwa miisena, bi wouna kuveregu da tam wiisuwone anakivinim. ");
INSERT INTO aui_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Gegha gwabimma kunaporataveguna! Gegha Kanumim Kabikabikuwayina gwabiguma kunakabitavenina! ");
INSERT INTO aui_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Kuberagu da aninuwamiise magha, ware dagudagune kuviyawiiguna raghanine naboni; kuberagu da yam sisiya kabisisirenina nuwanuwagu inasisira. ");
INSERT INTO aui_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Wasina bi bero berabera wawayidi biiyadi yam keda aniyeveveyana da sinamiiri karona magha tam biidi. ");
INSERT INTO aui_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O God tam kuviyawiigu, na kata yagu yawa kitara babaraneni bi yam keda rotomanidi kiiravine nuwamiiseye anataworedi. ");
INSERT INTO aui_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Bada, kiwiitegu da anisisiya da tam anakabepepim. ");
INSERT INTO aui_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tagu ribiribi anagibu da tam biidi anasuwara, bi gegha, noko geyam kayowana, tam suwara noko naboni na gekiiravidiye kuyibabana. ");
INSERT INTO aui_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Raghanina atoreyowoyena mayegu bi iibabiim da yagu tamumu kunanoghotataveni, na nokodi suwara naboni na tam yam kayowana. O God, gekuyamiimiiri kubutegu raghanina yagu tamumu kiiravine iinuwapoya bi arupari tam biidina. ");
INSERT INTO aui_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","O God yam nuwasisirama na Zaiyon biidi miisena kunabera; bi Jerusalem papana kunayoghana mayeni. ");
INSERT INTO aui_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Wasina bi wawaya nuwanuwadi miisenama tam biidi suwara sinabera, na tam kuninuwamiise toudi biiyadi. Toudi suwara bogaebogae sinagabuna tam biidi. Bi suwara gabugabunidi kiiravine na kau makidi yam suwara gabugabuna debane sinagabuna. ");
INSERT INTO aui_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Kabepepa ayidi badana kiiravine. Inawa ere uravidima. Psam, bo Ayi. O God, kinuwanuwaghanemii, da kimiiseyemii bi mayiyim kubera da inarukarata toumii biiyadi. ");
INSERT INTO aui_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Wasina bi wawaya tupadi kubura debane sinakovi da tam awaki kwakayokayoveni da toudi sinabera, dam bi dam tupadi sinakovi da tam rubana kuniyawiidi. ");
INSERT INTO aui_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Na dam bi dam tupadi tam sinakabepepim, O God, wawaya tupadi na tam sinakabepepim! ");
INSERT INTO aui_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Dam tupadi kubura debane na nuwamiiseye sinatawora basuna tam keda rotomanidiye wawaya kwiibadedi, bi dam tupadi kubura debane kwiinaghovedi. ");
INSERT INTO aui_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Na dam bi dam tupadi tam sinakabepepim, O God, wawaya tupadi na tam sinakabepepim! ");
INSERT INTO aui_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Na kwabu kabipura miisena inavereyana, bi yada God parapa miisena inabera touda biiyadi. ");
INSERT INTO aui_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Wonawaghata, God wiimiiseyana inavereda bi meghamegha mmko kuburina debane, na wawaya God sinakabikarawayeni. ");
INSERT INTO aui_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","God yana bagibagi tomoyina Mosis, touna mmko parina igirumi. Yawe God, kimta bi kimta nunudigha na tam na ware yama bare. ");
INSERT INTO aui_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Tam rorowainagha na God waghata bi muriye da koya kuyaberadi da muriye na kubura kuyabera. ");
INSERT INTO aui_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Wawaya kwawonedi bo, “Koveramagha konidobodobo magha!” Na kwawamiridi da saveramagha sidobodobo, mema sipiikana. ");
INSERT INTO aui_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Mata kamomve, na bodu 1,000 na ware gabudara tanagha naboni, toudi ware raghani tupona nubabasu kamone. ");
INSERT INTO aui_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Wawaya yadi yawa kwabori yaininagha ware raghanina mimeu yakovina naboni. Touda ware rei didibare yagogo yageena naboni. ");
INSERT INTO aui_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Didibare na reina matayina da yagogo yapora bi ravidiye na yivivi da yarabobo. ");
INSERT INTO aui_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Noko naboni da yam nuwapughu ghamana yiberomii. Raghanina nuwanuwam yapughu toumii biiyadi, na parapa kanagharena kirakiiyem. ");
INSERT INTO aui_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Bi yama bera berodi tupadi kwakitakita bi kiimatipo da yama berona kayikowoyidi, bi gegha da tupadi kwakitadi. ");
INSERT INTO aui_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Raghanina yawayawiimii kamakamake na nuwanuwam yapughu toumii biiyadi, da yama yawa kwabori yaiyainedi, mayimayiyina raghanina wawaya yiyawiigurina naboni. ");
INSERT INTO aui_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Toumii kamake da bodu 70 naboni bi meboda wawaya viya maragasidi na samake da bodu 80 naboni, bi gegha da nuwapoya peyaridi kabanana, na raghani yanagho yaininagha da karabobo. ");
INSERT INTO aui_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Getana iiyabo parapa iyakakovi da yam nuwapughu maragasina metagha; meboda yam nuwapughu kayakowa yapori, na parapa kayakumararayem. ");
INSERT INTO aui_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Kiyevevemii da yama yawa makena gabudarina yana guri kanakovi, da toumii noghota miisena tam gwabimma kanakabi. ");
INSERT INTO aui_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Yawe God kuveramagha da kuninuwanuwaghanemii! Genuwanuwam inapughumake toumii biiyadina! ");
INSERT INTO aui_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Yam nuwamonikama didibara patepatena kibonuvimii, da yama make yawana kamone nuwamiimiiseye kanatawora. ");
INSERT INTO aui_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Bodu peyaridi nuwapoya kuveremii kiiravine, na kata raghani gurina nuwamiise kuveremii! Yama kabikwarakwara kabitavetaveyana, bi bodu miisedi kuveremii! ");
INSERT INTO aui_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Toumii yam wiitamariyana, yam bagibagi yana maragata kiyevevemii. Yam badobado da maragata metagha na natunatumii kiyevevedi! ");
INSERT INTO aui_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Yawe tamna yama God, kinuwanuwaghanemii bi awaki bagibagidi kaberabera na kubera da sinuwagha wiimasi, bi awaki bagibagidi kaberabera na kubera da sinuwagha wiimasi. ");
INSERT INTO aui_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Kopiika, Yawe God tanakabepepi! Kobera da nuwamiise kiiravine God biidi tanatawora, iiyabo yitarababaranedana. ");
INSERT INTO aui_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Kobera da wiikiikiiwama tanapiika naghone bi kabepepa ayidi nuwakayowanidi tanatawora da tanakabepepi. ");
INSERT INTO aui_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Kiiravine Yawe na God kiidamo kirakiina, touna kiiwawo maragata kirakiina, da god tupadi igeetawanidi. ");
INSERT INTO aui_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Bi kubura tupana yibadeni, epamana bonayidi didibaridiye da inagho igae koya gekirakiidiye. ");
INSERT INTO aui_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Yegii tupana yibadeni, meko iberana; bi bada tanawa, meko touna wosina ikabiwiipakipakina. ");
INSERT INTO aui_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Kopiika, kobera da tanapepeta bi tana kabikuwayeni; kobera da Yawe God naghone tanituwapore oghogheyana, kada berabera tomoyina! ");
INSERT INTO aui_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Touna na yada God; bi touda na yana wawaya, na yakoyakoyayida, ware sip bodaboda yana sip yakoyakoyayidina naboni. Kata kowaiyana Yawe God awaki yawonewoneni: ");
INSERT INTO aui_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Genuwanuwami sinakotakii, ware nosinosiminakimi Meriba kubure siberana naboni, ware toudi noko gabudarine Massa mayabine siberana naboni. ");
INSERT INTO aui_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Name siruyaghagu da sivitupawamiwamiregu, bagune sikita da awaki abera kiiravidiye raghanina Ijiptma akabikanibuvedina gabudarine. ");
INSERT INTO aui_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Bi bodu 40 kamodiye nuwanuwagu ipughu nokodi damdi biiyadi. Awona bo, Toudi nuwanuwadiye tagu simiiri kubutegu, da yagu gwara gesiyakabisisiredina. ");
INSERT INTO aui_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Na nuwanuwagu ipughu na wiisuwona maragasina mma naboni abera, awona bo, “Tagu gawara kiiravidiye akabununayi da siyiyawiitaveyana, bi gegha da kata geaniwaghasinedi da sinarughu kamonena.” ");
INSERT INTO aui_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Mmko ayina kamone na God yana miisena kiiravine yana wawaya sikiikiiveni. Wawaya tupami kubura debane, kabepepa ayidma kotawora gwaru Yawe God biidi! ");
INSERT INTO aui_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Nuwamiimiiseye touna kokabepepi, kopiika naghone bi konatawora touna biidi. ");
INSERT INTO aui_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Bi konakovi da, “Yawe na God!” Touna iberada, touda na yana wawaya, bi yakoyakoyayida ware sip bodaboda yana sip yakoyakoyayidina naboni. ");
INSERT INTO aui_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Ere wiikiikiivimi yana Bare Kabikabikuwayine korughu, korughu garina kamone bi konakabepepa. Touna kovikiikiiveni da kana waghawagha kovimiiseyeni. ");
INSERT INTO aui_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Basuna Yawe God na wiinuwanuwaghaneyanina; yana nuwamonika na makewaghawaghasina bi yana nuwamiise na inanowiikarukaru kimta bi kimta biiyadi. ");
INSERT INTO aui_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Ayina Deivid igirumi Tagu nuwanuwagu tupanama Yawe God anakabepepi! Kana waghawagha kabikabikuwayina anakabepepi! ");
INSERT INTO aui_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Tagu nuwanuwagu tupanama Yawe God anakabepepi, bi bera miisedi tupadi ibera na gemeyani aninuwawapidina. ");
INSERT INTO aui_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Touna yagu tamumu tupadi yanoghotatavedi, bi gubaga tupadima yiyawiigu. ");
INSERT INTO aui_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Touna karawagama yiyawiigu, bi yinuwanuwaghanegu da nuwamonika yaveregu bi miisena yaberabera tagu biidi. ");
INSERT INTO aui_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Patana amakamakena, touna sawara miisedi yiwiitegu, da tubuyigu na ware kakaka wouna maragasina naboni. ");
INSERT INTO aui_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Yawe God yana wiiwiita na yayowogha wawaya biiyadi basuna yana keda na nonowa rotomanidi; bi raghanina wawaya berona sabera na Yawe God toudi wawayidi wiitupawamiwamira yaveredi. ");
INSERT INTO aui_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Touna yana noghota iyanoghonoghosi da iyabera na Mosis biidi ividebeni, bi Isrel damdi biiyadi parapa yana maragata ghamana iviyevevedi. ");
INSERT INTO aui_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yawe God na wiiwiinuwaghaneyanina da wiinuwayuyunina, touna genuwanuwana iyapughupughu yaininagha, bi yana nuwayuyuna kiiravidae na gegha damonana. ");
INSERT INTO aui_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Touna genonowa yada berona inatupakoghatedina, bi kate yana nuwapughu inanuwatawana waghawaghasina. ");
INSERT INTO aui_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Bagune touna rubarubana da aro ghamana iyavereda, bi yada bera beroberodi kiiravine yanuwatotoveda na gegha iyiimiisanena mayedana. ");
INSERT INTO aui_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Yana nuwayuyuna touda kiiravidae, iiyawogha sakabikabikarawayeni na gegha damonana; nuwayuyunina na iragata kirakii, gegha abama yana ragata naboni. ");
INSERT INTO aui_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Ware raghani matanama metagha na yana rabaraba mayimayiyina raghani didinama naboni, yada bera berodi gwabidama yayounataveyana da yana rabaraba noko patana. ");
INSERT INTO aui_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Ware tamada natunatuna yanuwatotovedi na naboni, bi Yawe God iiyawogha sakumakumararayeni na yanuwatotovedi; ");
INSERT INTO aui_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","touna yanoghosi da touda dobodoboma kawagha iberada, na iyakovi da touda na noganogada. ");
INSERT INTO aui_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Bi yada make yawana kubura debane na ware rei naboni. Ware garagara sarudi naboni, tiisaru bi tarabobo. ");
INSERT INTO aui_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Yanunu yatapidi, na toudi sasiwana getana iiyabo iyakitakita mayedina. ");
INSERT INTO aui_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Bi gegha da iiyawogha Yawe God sakumakumararayeni, na yana nuwayuyuna da bera rotomanidi beradi gwabidiye inamake nonowa, kimta da kimta kiiravidiye ");
INSERT INTO aui_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","da nokodi iiyawogha yana wiiwaghasina maragasina sakabikabitawani bi yana gwara sakabikabisisiredina biiyadi. ");
INSERT INTO aui_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yawe God ibera da abama na yana wiibada abamakamakena, bi nama sawara tupadi yibadedi. ");
INSERT INTO aui_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Yawe God kokabepepi, tami aneyaneya tupami badobadomi da maragasimi, iiyawogha yana sisiya kowaiyana da koberadina tami Yawe God kokabepepi. ");
INSERT INTO aui_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Yawe God kokabepepi abama kana iyo wawayimi iiyawogha kobagibagiyeni da yana noghota koberaberana. ");
INSERT INTO aui_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Sawara tupadi touna iberadina, sawara tupadi yana wiibadana kamone, na tami Yawe God kokabepepi. Tagu nuwanuwagu tupanama Yawe God anakabepepi. ");
INSERT INTO aui_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Mmko Psamna Deivid igirumi. Yawe God yagu Bada iwoneni bo, “Mma ririguve kumakekira gawara kabikabikarawayine bi Tagu kam aviya anageiwayidi da yam wiibadana rogune anatoredi.” ");
INSERT INTO aui_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Yawe God inabera da yam wiibadana inaragata da Jerusalemma yam kanibutaveyana kamone na tam kam aviya kunibadedi. ");
INSERT INTO aui_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Noko gabudarine kunanagho aviye yam maragatama wiirouwa biiyadi, na yam wawaya nuwasisire sinaveremayedi sinanagho. Tam na gara kabikabikuwayidi kunikote, bi gabudara nununaghana yam maragata aniiwuwamiri, ware youra didibara nununagha naboni. ");
INSERT INTO aui_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Tagu, Yawe God wiisuwona abera na gegha yagu noghota anawamirina, awona bo, “Tam na kuni prist waghata Melkisidek yana kayenama.” ");
INSERT INTO aui_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","O Yawe God, kiiwawo na katiiyamma yamiimiiri da babarem kiiravine. Bi kiikiiwawo korotodi inikasunughana raghanina nuwanuwana inapughuna. ");
INSERT INTO aui_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Touna dam tupadi aro inaveredi bi yadi kubura na wawaya sirabobona tubuyidima inibonuvi. Bi kiikiiwawo tupadi inageiwayidi, kubura tupane. ");
INSERT INTO aui_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Touna kedae wusire rarima inaniuna da gayamina inarukabepi bi iniyeveveyana da touna kana aviya igeeiwayidi. ");
INSERT INTO aui_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","O Yawe God metagha tomogha yaragina keda rotomanine inamake? Nokona wonam kabisisirenina. ");
INSERT INTO aui_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Nuwanuwagu tupanama iimatipo da anabagibagiyem; na kiwiitegu da yam gwara kabisisiredi geanasinighiiyedina. ");
INSERT INTO aui_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Bi wonam agirumeyana da nuwanuwaguve atourarughuwana, na getam biidi tamumu anaberana. ");
INSERT INTO aui_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Yawe God akabekabepepim, yam gwara kiyevevegu. ");
INSERT INTO aui_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Kawaguma gwara tupadi yam wawaya kuveredi na anakabiyawa gwaruvedi. ");
INSERT INTO aui_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Tam wonam akivikivini na nuwamiisena parapa iragata kirakii, genaboni moura peyaridi wiirapeneyanana. ");
INSERT INTO aui_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Bi yam keda ananoghonoghosi; yam gwara kiiravidiye na yagu wiinuwanoghonoghota kamone nonowa ananoghonoghosidi. ");
INSERT INTO aui_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Tagu yam gwara kiiravidiye na aninuwamiise, bi wonam geaninuwawapidina. ");
INSERT INTO aui_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Mmko Psamna Deivid igirumi. Yawe God, tam nuwanuwagu kamona kwaginigini bi kwakowa kirakiiyegu. ");
INSERT INTO aui_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Tam kwakovi da awaki raghanine amakeyowogha bo ageghomiiri amiiri. Bagune tam rabarabae, nonowa na yagu noghota kwakakovi. ");
INSERT INTO aui_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Tam apeepewana raghanine na kwakitakitagu bo raghanina yagu bare kamone iiyawiitaveyanana. Tagu sawara tupana aberabera na tam kwakakovi. ");
INSERT INTO aui_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Yawe God, muriyeda ayisisiya na, tam nada kwakovi da awaki anisisiyeni. ");
INSERT INTO aui_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Tamna ware gari naboni kuvitumpipinegu, bi imam debaguve kutore da yam maragatama kwabababaregu. ");
INSERT INTO aui_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Tam akovigu kabina mma naboni na parapa iragata kirakii da gerubana anakovina. ");
INSERT INTO aui_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Tagu gerubana mebo anaverairem ananagho da gekunakitaguna? Getana kubura noko naboni meme. Meghamegha ananono na tam nonowa na nama! ");
INSERT INTO aui_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Meboda anagae abame, na tam nama; Bo meboda anarabobo bi sinadogugu, na tam nama. ");
INSERT INTO aui_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Meboda anarowoghataveyana ananagho raghani matene gabudara yageegeena kuburidiye, bo meboda ananagho raghani didine gabudara yayoyona kuburidiye make biidi ");
INSERT INTO aui_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","na tam imam maragasina ininaghovegu, bi katiiyam inababaregu. ");
INSERT INTO aui_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Tagu meboda wiididibara ayawoneni da iyikowoyigu bo yeghana ivitumpipinegu na iyididibara magha ");
INSERT INTO aui_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Bi gegha da bagune wiididibara kamone, tagu gerubana anakowoyemna. Tam biidi wiididibara na parapa yeghanina ware gabudara. Wiididibara da yeghana tam biidi na mayimayiyidi. ");
INSERT INTO aui_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Tam tubuyigu kamona torerereyidi, nuwanuwa da gayama kubera bi sinagunaki raparapane kuvikiikiigu. ");
INSERT INTO aui_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Bi kubera wiimasiyegu kiiravine na iikiikiivem; bagibagi tupadi kwaberabera na waratetedi. Tagu nuwanuwagu tupanama akovi. ");
INSERT INTO aui_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Raghanina irikegu kubera, bi sinagunaki raparapane kutoura yapoyapora, bi name wiikowoye ayaragaragata na tam kwakovi da tagu nama. ");
INSERT INTO aui_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Muriye da ayatubugha na tam kukitagu. Na yagu make yawana gabudaridi kuveregu da anamake, na yam buka kamone kugiruma. Muriye da gabudara dagudaguna iyadagu, ");
INSERT INTO aui_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","O God ipiropiro kirakii da tagu yam noghota parapa anakovidi basuna toudi sipeyara kirakii! ");
INSERT INTO aui_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Tagu gerubagu da anakabiyavidina basuna toudi parapa sipeyara, gekikira eghana naboni! Bi tupadi kabiyawa kovidina na, augunai da ayamakewaghata tam naboni! ");
INSERT INTO aui_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","God, tagu parapa akayokayoveni da berabero wawayidi kunikasunughana! Kasukasunugha wawayidi gwabiguma kurukwavina tavetaveyana. ");
INSERT INTO aui_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Toudi sisiya berodima sigiboyim; bi kam waghawagha gesiyakabikabi karawayenina. ");
INSERT INTO aui_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O Yawe God, tagu iiyawogha sasinighiiyem na asinighiiyedi, da iiyawogha gesiyakabikabi sisiremna. ");
INSERT INTO aui_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Getana awaki, da nuwapughuma iisinighiighiiyedi, na toudi kagu aviya. ");
INSERT INTO aui_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O God, kita rughuwona da nuwanuwagu kunakita bi kuruyaghagu da yagu noghota kunakovi. ");
INSERT INTO aui_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Bi meboda berabero wawayidi yadi kedagha ananono na kiyevevegu, bi yawa makewaghawaghasina kedane kinaghovegu anapiika tam biidi. ");
INSERT INTO aui_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Wiiwawaya wiimasi dagunina biidi, na tam ghuyoghuyone na Yawe God kunakabikarawayeni da kunitumaghaneni nokona akowa dagudaguna, bi kawakeekee wawayidi sanoghosi da nuwagiura da akowa kabina na toudi yadi basuna gegha. ");
INSERT INTO aui_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Natugu, tamada yana wonawiiyoyowana kuwaiyaneni, bi sinada yanawiiyeveveyana gekunasinighiiyenina. ");
INSERT INTO aui_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Yadi wiiyeveveyana na iniwiitem da kuniwawaya wiimasi, ware saru gerorina gayamim debane bo ware posaru kanighomve naboni, na inabera da kamkita inawaratete. ");
INSERT INTO aui_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Madawara wasike gwabinama kumiiritaveyana! Da gekunanagho yana makamake gawarina ririnena! ");
INSERT INTO aui_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Bi meboda kunanagho, na wawaya kate tam gesinakabikarawayemna, bi sawara tupana kunavereyana da moghanena kunimiisanena mayeni, tomogha meko geinanuwaghanemna. ");
INSERT INTO aui_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Wawaya awaki sawaridi tupadi yaberabera na Yawe God yakitakita, bi bera miisedi bo berodi wawaya yavinevinegha na yakitakita yapoyapora. ");
INSERT INTO aui_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Kawakeekee damdi yadi tamumu na noko sapuru, na yadi tamumu sapuruna yakonamayedi. ");
INSERT INTO aui_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Toudi koyagha mayeyana gwabidiye kiiravine na sarabobo. Yadi kawakeekee beradi siniporadi sinanagho kadi karawage. ");
INSERT INTO aui_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Natugu, tamada da sinada sawara tupadi siyevevem, na kabisisiredi da kukivina. ");
INSERT INTO aui_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Yadi sisiya nuwanuwamve kutoredi da nonowa kunanoghonoghota. Kubera da ware posaru kanighomve naboni. ");
INSERT INTO aui_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Raghanina kunapeepewa, na mmkodi gwara waratetedi yam keda siniyevevem. Raghanina kunakenakena, na mmkodi gwara sinababarem. Bi kunamataka, na mmkodi gwara sinisisiya tam biidi. ");
INSERT INTO aui_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Kiiravine gwara na kibe, bi wiiyeveveyana na yeghana wiididibara kamone. Yadi giu na rubana iniyevevem da metagha keda rotomandiye kunamakae. ");
INSERT INTO aui_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Toudi madawara wasike yana kedama sinamiiri babarem da kate tomogha bogae wavinena yana sisiya metemetevidima. ");
INSERT INTO aui_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Gegha nuwanuwam kamonama yana kepamara kunakita kirorovenina, bo yana wiimatakamokamota inabera da tam inirubasimna. ");
INSERT INTO aui_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","Yawe God, Tagu nuwagiura ibera yaiyainegu, muriye da mmko kuburina ibera. Naghove waghata, muriye da awaki sawaridi iyabera na tagu iberagu. ");
INSERT INTO aui_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Dagudagune waghata na, Tagu nuwagiura atubugha, muriye da kubura iyabera. ");
INSERT INTO aui_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Dagudagune Tagu nuwagiura atubugha, muriye da Yawe God yegii ibera, bi kate rarima wusirama sakanikanibuna. ");
INSERT INTO aui_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Muriye da koya iyakabiwiipakipakidi, na Tagu nuwagiura atubugha yaiyainagha. ");
INSERT INTO aui_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Raghanina atubughana, Yawe God genada kubura da guburidi iyaberana, bo getana dobodobo. ");
INSERT INTO aui_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Yawe God abama kiidamove itore raghanine na tagu nada nama, da kate gawara ikabiguba da meme abama da yegii sinibanana. ");
INSERT INTO aui_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","Uwa abama kamone itoura raghanine na tagu nama ririne, bi kate wusira ibera da yegii sivibonuvina raghanine. ");
INSERT INTO aui_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Yawe God yegii kana barata itore raghanine na Tagu nama, bi iwoneni da genoko barasina iyaveratupirenina. Tagu nama noko raghanine bi kubura kayena itore. ");
INSERT INTO aui_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Touna mmkodi sawaridi iberadi raghanine na Tagu nama bi aviwiiteni da kanuwagiura bi kabera. Gabudara patepatena na ayaberabera da iyiinuwamiise, bi bada nonowa na ayiinuwamiise da Tagu nama touna yawata. ");
INSERT INTO aui_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Tagu avinuwamiise da kubura ibera na akitani, bi avinuwamiise kirakii da wawaya nama kamone akitadi. ");
INSERT INTO aui_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Nuwagiura yana bare iyoghani ware abayoghayoghana yaberana naboni; touna barena kiiravine na kanakoghora yadi 7 itarakatukatuyidi. ");
INSERT INTO aui_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Wasikena parapa ribiribi iunugha da kepo ghamanakina kiiravine ikabununayi, da kana wain iwamira, bi sawara tupadi na kiinabonabo debane itoura. ");
INSERT INTO aui_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Bi yana tamariyana wasiwasike idarudi sikanibu da wawaya tupadi siyiyonedi. Nuwagiura kwanatu kamone gawara gekirakiina debanama iyiikwatu, ");
INSERT INTO aui_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","iyawonawona bo, “Iiyawogha geakakovimi korughu yagu bareye,” bi kawakeekeedi biiyadi iyawonawona bo, ");
INSERT INTO aui_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Kopiika, korughu yagu kam konakani, bi wain meko awamirina konaniuni. ");
INSERT INTO aui_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Kawakeekee beradi kokuyowana, bi konadagu yawa miisene konamakae, bi akowa yana keda konakivini.” ");
INSERT INTO aui_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Natu nuwanuwagiurina, na raghanina tamananaki keda miisedi yiyevevenina na yakabisisiredi, bi wawaya kawakeekeena, na raghanina wawaya tana yakikini na gegha iyawaiwaiyanana. ");
INSERT INTO aui_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Wawaya kapokapoyanina parapa yana wiina sawara, bi gegha da getana awaki iyakabikabina; bi wawaya bagibagi kirakiina na awaki yakayokayovenina inakabi. ");
INSERT INTO aui_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Wawaya iiyabo natuna aro geiyaverevereni, na touna natuna geiyinuwayuyunenina; bi wawaya iiyabo natuna yinuwayuyuneni na raghanina natuna bera berona inabera na inakabiwiirotomani. ");
INSERT INTO aui_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Tamada bi sinada iiyawogha natunatudi wiikayotirana saberabera, na getana awaki da nuwapoya da kanighughuwa gwabidiye. ");
INSERT INTO aui_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Upi wawayina iiyabo yakapokapoyana bi yana kwabu gerove gabudarine iyaroverove, na kasiyaragha gabudarine na getana awaki inakamna. ");
INSERT INTO aui_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Ededa koviyevevedi da metagha sinamake, da sinimagura na yadi yawa tupana kamone na bera rotomanidi kedadi sinanoghonoghosi. ");
INSERT INTO aui_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Gekunanaghara da natum bera berona iberana aro verenina; bagune memeda kiima kurouvi kate geinarabobona. ");
INSERT INTO aui_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Memeda kiima kunarouvi, na augunai da raboboma kwiiyawiini. ");
INSERT INTO aui_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Tagu, tomogha kapokapoyanina yana kwabu averatupiireni, bi greip kwabuna, na tomogha kawakeekeena rapene. ");
INSERT INTO aui_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Bi akita da dinamona iyiyodi kwabuna debane siyagogogo, bi pasiporo dobodobo sisowomumuni, da kwabuna garina akimama beraberana itamoririgha. ");
INSERT INTO aui_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Tagu mmkodi sawara akitadi, na akowa gwabidima akabi: ");
INSERT INTO aui_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Da kena pinimina, wiiyawiitaveyana gisina kabina. Bi imam kunarukuma da kuniyawiitaveyana kamogha, ");
INSERT INTO aui_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","bi gegha, noko raghanine kunakenakena na yaininagha tam kunigiikayokayo ware yapiyapi tomoyina ruta yawata yapiika da yam sawara tupadi yayounana naboni. ");
INSERT INTO aui_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Wawaya kapokapoyanina yana bare kamone yamakamakae, bi yawona bo, “Laiyon nama maghatare! Laiyon nama kedae!” ");
INSERT INTO aui_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Wawaya kapokapoyanina imana kana kam dabirina kamone yatore; touna ikapokapoyana kirakii da gerubana kam inakabepi da kawane inatorena. ");
INSERT INTO aui_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Wawaya tana nuwagiura miisedi gwabine na yabera da tamananaki yinuwamiise, bi wawaya iiyabo keda wasike yawata sinapeepewa na yana moura inikawawaneni. ");
INSERT INTO aui_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Aro kabina da kabiwiirotomana na sabera da simira nuwagiura savereni. Bi ededa toudimani yadi keda sinakabi, na sinabera da sinadinakim sinisinimayagha. ");
INSERT INTO aui_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Natunatumi kokabiwiirotomanidi da toudi nuwaruriri sinaveremi, bi sinabera da koninuwamiise kirakii. ");
INSERT INTO aui_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Wiisuwona gwabigwabiyana dadourina, na touna parapa gararaba miisena tomogha iiyabo inabanani na. ");
INSERT INTO aui_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Tomogha wavinena initumaghaneni, na kate getana awaki inadiyanana. ");
INSERT INTO aui_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Touna nonowa miisena yaberabera bi geberona moghanena biidi gabudara tupadi yana yawa kamone. ");
INSERT INTO aui_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Touna sip ghunighunidi yayouna da bebera yabera bi yinuwamiise da imanama yabagibagi. ");
INSERT INTO aui_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Bi yana urawa yatumsesera bi yanowa, da kana gara tounamani yaberabera. ");
INSERT INTO aui_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Touna imana yatatari moyamoyakidi yiwiitedi da imana yakoghasi iiyawogha getana awaki gwabidiye na toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Wasike yana bera wiigayagayaye na rubana tomogha iniyabeni, bi mayiyi kepamarina na geinamake waghatana. Bi gegha da, wasike iiyabo Yawe God yakabikabikarawayeni na kokabepepi. ");
INSERT INTO aui_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Bi awaki ibera na kiiravine kana reregha kovereni, wawaya naghodiye kokabepepi basuna sawara tupadi iberana kiiravine. ");
INSERT INTO aui_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","Mmkodi na abawiiyeveveyana yana sisiya, Deivid natuna, iiyabo Jerusalem kamone iyiikiiwawo na: ");
INSERT INTO aui_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Abawiiyeveveyana iwona da, “Sawara tupadi basudi gegha, yawa na yana basuna gegha, parapa basuna gegha!” ");
INSERT INTO aui_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","Tomogha bagibagi tupadi mma kubura debane yaberabera na awaki yakabi? ");
INSERT INTO aui_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Kimta yanagho, bi kimta yapiika, bi gegha da kubura yamake waghata. ");
INSERT INTO aui_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Gabudara yagae, bi gabudara yayowogha, bi yiyaininagha da mema yageegee maghana nabo. ");
INSERT INTO aui_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Yanunu wareregubugubura yana nawae yatapi yanagho, da yatapi wiikenavivira yagae yanagho kikiramutumutuba yana nawae; yanunu yatapi da yatapi wiikenaviivira. ");
INSERT INTO aui_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Rarima savera sayowogha yegiiye, bi gegha da yegii geiyabonubonuvina. Rarima samama saveramagha anagha matadiye mema sawusiwusirana, bi vera sadagumayeni sayowogha yegiiye. ");
INSERT INTO aui_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Sawara tupadi saberam da kwamameyem; wawaya kate gerubana noko kiiravine inisisiyana. Bagune mata yakitada meme, bi gerubana inanunurina, bi taina yawaiyana da meme, bi gerubana inanunurina. ");
INSERT INTO aui_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Awaki sawaridi tupadi naghove situbugha, na bada sinatubugha magha. Sawara tupadi wawaya naghove sibera, na bada sinabera magha, getana da awaki wouna mma kubura debanena. ");
INSERT INTO aui_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Metagha wawaya inawona bo, “Kita, mmkona sawara wouna!” Bi gegha, sawara tupadi naghove situbugha, naghove waghata muriye da tatubugha. ");
INSERT INTO aui_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Getana iiyabo iyanoghonoghosi da awaki naghove itubugha, bi getana iiyabo kata wawaya awaki saberabera na inanoghosidina. Getana iiyabo nokodi sawara raghani muriye sinatubughana inanoghosidina. ");
INSERT INTO aui_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Tagu, na Abawiiyeveveyana bi Isrel damdi yadi kiiwawo, bi Jerusalem kwanatune ayamakamake. ");
INSERT INTO aui_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","Yagu Nuwagiura miisenama na akayoveni da bera tupadi kubura debane parapa ayakita yapoyaporidi. Na anoghota bo, “God nuwapoya da piropiro vitadi wawaya iveredi da iyitaina iriredi.” ");
INSERT INTO aui_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Tagu sawara tupadi wawaya kubura debane saberabera na akitadi, kokita, tupadi na basudi gegha, ware tayimatipo da yanunu taya veraverakwavini. ");
INSERT INTO aui_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Awaki iriwariwa na gerubana sinakabi wiirotomanina, bi memeda awaki isiwana na gerubana sinakabiyawa wiikapuna. ");
INSERT INTO aui_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Na tagumani awonena mayegu, “Kita, kiikiiwawo iiyawogha naghoguve Jerusalem kwanatune sivibadana, toudi meboda nuwagiura miisena gwabidiye bi gegha da tagu yagu nuwagiura da akowa na parapa simiise kirakii.” ");
INSERT INTO aui_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","Tagu parapa avinuwanoghonoghota kirakii da nuwagiura ayakovi, bi kate kawakeekee da neghanegha. Bi gegha, tagu abanani da mmko teya na yanunu vera kwavikwavinina. ");
INSERT INTO aui_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","Memeda yagu nuwagiura inaragata kirakii, na tagu parapa aninuwapoya. Bi bada memeda sawara peyaridi akovidi anayouna, na tagu parapa aninuwapoya. ");
INSERT INTO aui_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","Tagu awona bo, “Wasina, animatipo da tagumani aninuwamiimiiseyena mayegu.” Bi gegha, abanani da mmko bada basuna gegha. ");
INSERT INTO aui_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","Na awona bo, “Maniwa touna neghanegha. Wiinuwamiimiiseyena mayegu na basuna gegha.” ");
INSERT INTO aui_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Yagu nuwagiura iyinaghovegu kiiravine, na parapa ayanoghonoghota kirakii, da metagha wainma bo neghanegha beradi ayabera da ayinuwamiimiiseyena mayegu, bi ayakovi memeda mmko imiise wawaya kiiravidiye, mma kubura debane mmko raghanina tupona yawayawiidi samakamakena. ");
INSERT INTO aui_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Tagu parapa bagibagi kiitowana abera. Bare ayoghana, da wain kwabudi kiiraviguve abera. ");
INSERT INTO aui_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","Kiimatagha kwabudi abera bi kii bogaebogae awawa da kam siyavereyana. ");
INSERT INTO aui_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","Bi tarakibubu aberadi da rarima siyaveregu da yagu kii peyaridi kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","Bi wiibagubagurana korotodi, tomotomogha bi wasiwasike agimona da kate wiibagubagurana mududi iiyawogha nama yagu bareye situbughana. Bi kate bada kau da sip peyaridi avirapeneyana geware kiikiiwawo iiyawogha Jerusalem kwanatune naghove simakena. ");
INSERT INTO aui_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Tagu silva da gould peyaridi, nokodi na kiikiiwawo yadi sawara wiinuwakayowanidi kubura wiibatama avituwiitaghomana. Tomotomogha da wasiwasike kiiraviguve sitawora bi bada natuwavinegu kepakepamaridi korotodi, parapa kepakepamaridi. ");
INSERT INTO aui_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","Na yagu sawara parapa sipeyara geware wawaya Jerusalem kwanatune naghoguve simakena naboni. Mmkodi sawaridi tupadi kamodiye, na yagu nuwagiura gemeyani iyakuyoveguna. ");
INSERT INTO aui_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","Sawara akitadi bi akayoveni da ayimatipo, na toudi beraberadi akivina. Tagu sawara tupadi mekodi siyaberagu da ayinuwamiise na avimatipovedi. Bi bagibagi tupadi siberagu da avinuwamiise, yagu bagibagi tupadi miisanina kiiravidiye na nuwamiise akabi. ");
INSERT INTO aui_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Wasina bi sawaridi aberana kiiravidiye parapa anoghota kirakii da kate yagu bagibagi ghamadi, bi akita da bera tupadi na kwebudi, noko ware yanunu taya veraverakwavini na naboni, da getana awaki toudi gwabidima tanayouna mmko kuburina debane. ");
INSERT INTO aui_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Wasina bi adagu aninuwanoghonoghota nuwagiura, kawakeekee da neghanegha beradi kiiravidiye. Tomogha iiyabo muriye kiiwawo murinagha inapiika na awaki nada Tagu abera na bada inabera. ");
INSERT INTO aui_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","Tagu akita da nuwagiura na iwaratete kirakii geware neghanegha naboni, mayimayiyina yeghana na imiise geware wiididibara naboni. ");
INSERT INTO aui_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","Wawaya nuwanuwagiurina matanama yakita da mebo yanono, bi wawaya kawakeekeena na ware wiididibare iyapeepewa. Bi gegha, akovi da berana tanagha yapiika nokodi wawaya bata biiyadi. ");
INSERT INTO aui_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","Wasina bi awonena mayegu bo, “Yagu rabobo na mayimayiyina wawaya kawakeekeena yana rabobo na naboni.” Bi awona bo, “Mmkona bada basuna gegha. Na nuwagiura kirakiima awaki akabi?” ");
INSERT INTO aui_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","Getana da iiyabo, wawaya nuwanuwagiurina inanoghotamayenina bo wawaya kawakeekeena inanoghotamayenina. Wawaya nuwanuwagiurina yarabobo na mayimayiyina metagha wawaya kawakeekeena yarabobona naboni. ");
INSERT INTO aui_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","Basuna sawara tupadi mma kubura debane taberabera na nuwapoya saverevereda noko biidi yawa avisinighiighiiyeni. Bera tupadi na basudi gegha - ware yanunu taya veraverakwavini. ");
INSERT INTO aui_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Tagu yagu kayopika tupadi mma kubura debane asinighiiyedi, basuna akovi da bera ayaberabera na tomogha iiyabo muriguve inibada, na ima debane anakuyowana. ");
INSERT INTO aui_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","Bi iiyabo iyakovi? Noko wawayina inakowa kirakii bo inaneghanegha? Bi gegha da bera tupadi kiiravidiye ayabagibagi na inirapeneyana, sawara tupadi mmko kuburina kamone yagu nuwagiurama situbughana. Toudi na basudi gegha. ");
INSERT INTO aui_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Na noghota awamiri da yagu kayopika mmko kuburina debane tupadi kiiravidiye na avinuwapoya kirakii. ");
INSERT INTO aui_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Wawaya na nuwagiura, akowa da noghotama sabagibagi, bi wasina bera tupadi rapediye na sakuyowana da wawaya tana iiyabo gekiiravidiye iyabagibagina inirapeneyana. Mmko bada yana basuna gegha, bi gebera miisenana! ");
INSERT INTO aui_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","Wawaya tubuyinama da gayaminama mmko kuburina debane yabagibagi kirakii, bi awaki yakabi? ");
INSERT INTO aui_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Yana make gabudaridiye na sinivisi yakabikabi bi yana bagibagi yaberani da nuwanuwana yapughu. Bi kate nubabasuve na bada geiyakenakenana. Mmko bada basuna gegha. ");
INSERT INTO aui_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","Bera miisena wawaya inabera na inakam da inaniuna bi ininuwamiise basuna awaki ibera situbughana kiiravine. Bi akita da mmko teya na God gwabinama ipiika, ");
INSERT INTO aui_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","basuna God gegha, na getana iiyabo inakam bo ininuwamiisena. ");
INSERT INTO aui_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","God, na nuwagiura, akowa da nuwamiise iiyawogha sinuwamiimiiseyenina yaveredi, bi tamumu damdi na yaberadi da sabagibagi, situwiitaghoma da simaghara, bi iiyawogha sabera da God yinuwamiise na mourina toudi yaveredi. Mmko teya, na basuna gegha - ware yanunu taya veraverakwavini. ");
INSERT INTO aui_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","God, sawara tupadi kiiravidiye na kadi iri itoura. Bera tupadi mma kubura debane satubutubugha na ere kadi gabudara waghata: ");
INSERT INTO aui_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Touna gabudara itore da wawaya inatubugha bi bada rabobo kana gabudara, wawa gabudarina itore bi bada yaba kana gabudara. ");
INSERT INTO aui_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","Kasunugha gabudarina itore bi bada wiiyawa kana gabudara, tayinarika gabudarina itore bi bada yoghana kana gabudara. ");
INSERT INTO aui_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","Dou gabudarina itore bi bada maniwa kana gabudara, wiinuwapoya gabudarina itore bi bada riku kana gabudara. ");
INSERT INTO aui_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","Touna akima wiirubusarana gabudarina itore bi bada wiitaghotaghoma kana gabudara. Wiiaghaghuwana gabudarina itore bi bada gewiiaghaghuwana kana gabudara. ");
INSERT INTO aui_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","Sawara wiinogha gabudarina itore bi bada wiiwapewapeyana kana gabudara, sawara kabitawana gabudarina itore bi bada wiitavetaveyana kana gabudara. ");
INSERT INTO aui_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","Gara gosira gabudarina itore bi bada popo kana gabudara, wiiraborabobo gabudarina itore, bi bada wiisisiya kana gabudara. ");
INSERT INTO aui_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","Wiinuwayuyuna gabudarina itore, bi bada wiigiyaguveyana kana gabudara, wiiaviya gabudarina itore, bi bada nuwaruriri kana gabudara. ");
INSERT INTO aui_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Wawaya tanaduma yamakamake na wasina, bi gegha da wawaya bata sinamakena inamiise kirakii. Toudi yadi bagibagiye siniwiitakabivivirana da miisena sinabanani. ");
INSERT INTO aui_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Memeda toudi, tana inabeku, na tana inageghomiiri da kwiinana iniwiiteni. Bi meboda wawaya tana makedumana bi inabeku na noko ibero kirakii, basuna getana iiyabo nama da iniwiitenina. ");
INSERT INTO aui_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Mayimayiyina, wawaya bata sinikena rereghana na sinidi sinamuyamuya, bi wawaya tanagha na metagha tanaduma bi sinina inamuyamuya? ");
INSERT INTO aui_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","Rubana aviya wawaya inagogona wawaya tanaduma makamakena biidi na inageeiwayi, bi wawaya bata na sinimiiri kubukubutana na aviyina sinageebodeni. Wawaya yadi aroba na parapa maragata ghamana ware kwaro, urawa yadi arobama sametanina naboni. Tam gerubana noko kwarona kunayaragha yaininenina. ");
INSERT INTO aui_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Memeda mane kuninuwayuyuneni, na kate gegha inanunurimna; bi meboda kwakayokayoveni da kuna moura, na kate geyamkayowana tupadi kunayounana. Yam nuwagiura na kwebuna. ");
INSERT INTO aui_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Kunamoura kirakii, na wawaya korotodi sinapiika siniwiitem da yam moura koniawaviyaneni, bi yam moura kunakita bi kuna ruruwiitetewosi da inayorikovi. ");
INSERT INTO aui_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Wawaya iiyawogha sabagibagi kirakii na sakena yapora, bagune memeda sakam kirakii bo gesiyakamkam kirakiina; bi wawaya moura ghamana teya, na geiyakenakena yaporana. ");
INSERT INTO aui_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","Nuwapoya tana bero kirakiina kubura debane akita na mmko: Wawaya tana iiyabo inamoura kirakii, bi memeda inakabitawani tounamani kiravine, na mourina inageghomiiri wawayina inakasiwiibero. ");
INSERT INTO aui_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Meboda wawaya tana yana mane wiigimogimone itore, bi gegha, yikuwamira da yabero na noko manena yiwapeni. Wasina bi raghanina inarabobo, na natunatuna kate gegha ere yadi manena. ");
INSERT INTO aui_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","Noko naboni touda ighanidagha tatubugha, getana mane bo sawara, bi raghanina tanarabobo, na mmko kuburina tanakuyoveni, na kate getana awaki tanakawarina. Touda yada bagibagi tupadi kiiravidiye na getana miisana imadae tanakawarina. ");
INSERT INTO aui_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","Yagu yawa na basuna gegha, bi gegha da kamone na sawara tupadi akita: Rotomana wawayidi na God yana gwara sakivikivini bi gegha da saraborabobo, bi berabero wawayidi na God yana gwara gesiyakivikivinina bi gegha da samake da raghani gurina. ");
INSERT INTO aui_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Noko biidi gekonanoghosi da tami parapa rotomanimi, Bi gekoniyaba da tami yami nuwagiura parapa miisedi. Da kowiiwiini tamimani konirabobo mayemi? ");
INSERT INTO aui_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Gegha konabera da tami bero kirakiimina, gekonabera da parapa wawaya kawakeekeedi. Metagha, kowiiwiini da konarabobo yaninagha, muriye da gabudara waghata inakabi? ");
INSERT INTO aui_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","Augunai da bera miisena na meboda mmkodi wonawiikatagha konakabitawana: Wawaya iiyabo God yakabikabikarawayeni, na mmkodi keda berodi yadi bata gwabidima inamiiritaveyana. ");
INSERT INTO aui_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","Nuwagiura yabera da wawaya tana yimaragata kirakii, geware kiikiiwawo yadi 10 kwanatu tanagha kamone sibadana naboni. ");
INSERT INTO aui_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Getana wawaya nama mmko kuburina debane iiyabo nonowa bera rotomanidi yaberabera, da tamumu geiyaberaberana. ");
INSERT INTO aui_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","Raghanina yagu gayama ayiteteni da nuwagiura parapa ayakovi bi kate wawaya yadi bagibagi ayaruruwiitete mma kubura debane, nubabasuve da raghaniye na gerubana ayakenana. ");
INSERT INTO aui_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","Wasina bi God awaki beradi tupadi ibera na akitadi. Awaki bagibagidi mma tanawa debane satubutubugha na getana iiyabo iyakakovidina. Bagune memeda wawaya parapa yakayopika da akovina iyakabi, kate gerubana inakovina. Wawaya akowa woraworana meboda iwona da iyakovi bi gegha da wiisuwona touna geakovina iyakabina. ");
INSERT INTO aui_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Wawaya woumi, yami kayowiikomerowana konuwasisireni. Tami patana yaragimiye na yawa kovinuwamiiseyeni. Awaki kokayokayoveni na kobera, bi nuwanuwami yana wiina kokivini. Bi konoghosi da raghani damone, na God mmkodi sawaridi tupadi kiiravidiye na wiitupawamiwamira inaveremi. ");
INSERT INTO aui_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Na nuwabero nuwanuwamiye kokabitavetaveyana, bi sinimiye piropiro tupadi kokabitavetaveyana, kiiravine kayowiikomerowana da kate tubugha rubodeyana na basudi gegha. ");
INSERT INTO aui_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Na yami kayowiikomerowana gabudaridiye, na kami berabera wawayina konoghotaboga, muriye da piropiro gabudaridi sinapiika bi bodu sinapiika na noko raghanine konawona bo “Yawa kata geiyamiise kamoghana,” ");
INSERT INTO aui_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","muriye da noko raghanina na gabudara, matu da kewokewo yeghanidi sinarusowa tami biiyadi, bi kiyara uuwadi dumadumadi gemeyani sinanaghotaveyanana, ");
INSERT INTO aui_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","raghanina bare koyakoyagha sinakiroro bi tomotomogha maragasidi sinaturayoudi, raghanina gudaguda siniraborabobo basuna toudi gepeyaridi, bi nokodi kitawiiverama sinakitakita na sinarusowa. ");
INSERT INTO aui_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","Tainam sinapotepoteyana da kwaritu kedae gekunawaiyanana. Tami kate gerubana da parawa kana gudaguda kwarituna konawaiyaneni, bi bada gerubana manu gamodi kenama sinakasikasi wiimatakim bi kunawaiyana. ");
INSERT INTO aui_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Tami gawara kiidamo kirakiidi konanagharedi, bi kedae pepewa na sinikumakumararayina. Raghanina almond kiina yapopona; bi tatata tounamani yatayinakwaro mayeni - miimiikiidigha yatete yanagho, bi wiina tupadi na sinamomogha. Kiiravine wawaya na sanono yadi wiiyawiitaveyana gawarina makewaghawaghasine, wasina bi nama kedae na duudu inaghaaghari iiyawogha sirabobo na kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","Bi kwaro silvama siberana inatamoyaragha, bi kaboma gouldma beraberana inagawowori; bi kiyabu wusire makamakena inatamogawowora; bi kwaro doguve yarororoga na inatamoyaragha; bo wil doguve inatamorika. ");
INSERT INTO aui_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Bi popoku sinaveramagha sinidobodobo mema sipiikana, bi yawa yawiina na inaveramagha God biidi, iiyabo iveredana. ");
INSERT INTO aui_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Abawiiyeveveyana iwona da, “Sawara tupadi basudi gegha, parapa basudi gegha!” ");
INSERT INTO aui_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Abawiiyeveveyana na geakakovina kawagha bi gegha da touna nonowa wawaya bada akowa kiiravine iyiiyevevedi. Touna wona kayowiiwiiyaka igirumeyana da yadi wiisuwona ikabirubatabatadi bi iriri yapoyaporidi. ");
INSERT INTO aui_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","Abawiiyeveveyana ivimatipo da sisiya waghata iyabanana bi iyagiruma da wiisuwona iyimaghatara yapori. ");
INSERT INTO aui_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Wawaya nuwagiura kirakiina yana sisiya na ware kii gamgamna naboni meko sip bodaboda sakabi da sip situwiitetedina, bi yadi wonawiiyoyowana na ware kii ere tutuna gamgamna damone meko amama sarouwiimasiyeni yayowogha na naboni. ");
INSERT INTO aui_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Iikatayim natugu, kuberawiimasi da wiiyeveveyana mududi gwabidima kumiiritaveyana. Buka girumidi na getana meme damodina, bi akowa kabikirakiiyenina na inabera da tubuyim inamameyeni. ");
INSERT INTO aui_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Mmkodi bera murine, na sawara tanagha anawoneni: God kumararayenina bi yana sisiya bagibagidi kunakabisisiredi, basuna wawaya situbugha na mmkodi bera tupadi kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","Sawara tupadi taberabera na kiiravidiye, God kate inageghomiiri da initupawamiwamireda, memeda miisena bo berona, bo meboda wiikowoye bera situbugha na kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("IS2_1","024_2_1","ISA","2","1","1","God awaki Jiuda kubura da Jerusalem kwanatuna kamodiye inabera, na warana mmakatanina Eimos natuna Aisaiya iverenina. ");
INSERT INTO aui_vpl VALUES ("IS2_2","024_2_2","ISA","2","2","2","Raghani tughurina yapiipiika na mmkona awaki inatubugha: Koya meme Yawe God yana bare yamiimiiri na inamakewaghata. Touna inagee kirakii geware koya mududi naboni. Dam tupadi kubura debane na sinikabiriyeni nabo da sinakabepepa. ");
INSERT INTO aui_vpl VALUES ("IS2_3","024_2_3","ISA","2","3","3","Bi wawaya korotodi nabo sinanagho na sinawona bo, “Kopiika, tananagho Yawe God yana koyae, nabo tananagho Isrel kana God yana bareye. Name iniyeveveda da metagha tanamake bi yana kedae tanapepewa.” Basuna wiiyeveveyana na Zaiyonma inakanibu, bi Yawe God ivisisiya na wonana Jerusalem kamonama inakanibu. ");
INSERT INTO aui_vpl VALUES ("IS2_4","024_2_4","ISA","2","4","4","Raghanina dam siniaviya kabivivirana na God initupawamiwamiredi da yadi berona inakabiwiirotomani. Dam gisigisidi yadi wiigamowana inakabiwiidouvidi. Toudi yadi seri ghamadi sinakasiwiibena da roverove yewadi, bi yadi iyo sinakasiwiibena da wawa kana yewakwiikwii gisigisidi. Dam tana geyadi seri sinayouna bi dam tana siniaviyena mayedina, bi kate bada gewiirouwa kiiravine sinakabununaghana. ");
INSERT INTO aui_vpl VALUES ("IS2_5","024_2_5","ISA","2","5","5","Isrel dammi, kopiika, tanabera da Yawe God yana yeghane tanapepewa meko iviyevevedana. ");
INSERT INTO aui_vpl VALUES ("IS5_1","024_5_1","ISA","5","1","1","Kowaiyana bi kwiinagu avinuwayuyuneni na kiiravine mmko ayina anatawori. Tagu, touna da yana wain kwabuna kiiravidiye anatawora. Kwiinagu, koya nawanawane dobodobo miisene wain kwabuna ibera. ");
INSERT INTO aui_vpl VALUES ("IS5_2","024_5_2","ISA","5","2","2","Touna tanavina irove bi akima ikabitavetaveyana, wasina bi greip imatupidi miisedi kamone iwawa. Bi wiikighukighu barena kwabuna basukiine iyoghani, da kate gawara tana akime ibani da greip rubotodi kiiravine. Touna ivikoyakoyagha da greip siyameni, bi gegha da mekodi sigogo na berodi. ");
INSERT INTO aui_vpl VALUES ("IS5_3","024_5_3","ISA","5","3","3","Na kata kwiinagu iwona bo, “Jerusalem kwanatuna kamone makamakemi da Jiuda kubura dammi, iibabiimi da konanuwagiura iiyabo ibera bero. Tagu abera bero bo yagu wain kwabuna? ");
INSERT INTO aui_vpl VALUES ("IS5_4","024_5_4","ISA","5","4","4","Bo nama getana awaki ayabera touna kiiravine? Na wasina, kowonegu awaki biidi greip berodi sigogo bi gegha miisedi ayatumatumayedina? ");
INSERT INTO aui_vpl VALUES ("IS5_5","024_5_5","ISA","5","5","5","Kata awonewonemi da konakovi awaki anabera yagu wain kwabuna kiiravine. Tagu kii iyiyodi simiiri kewakewa sivikenavivireni, na anataratavetaveyana bi gari iyabababareni na anakourikataveni, da ribiribi sinarughu bi sawara tupadi sinakamtavetaveyana da kwabuna sinibero. ");
INSERT INTO aui_vpl VALUES ("IS5_6","024_5_6","ISA","5","6","6","Bi kwabuna anakuyoveni da inabubu. Tagu uravidi ragharaghadi geanayaragha da anakabununayidi bo tanavina anarovena, bi dinamona berodi iyiyodi sinagogo da sinibonuvi. Bi kate bada geaniwaghasinedi da uuwa kiyara sinapiikeni debanena.” ");
INSERT INTO aui_vpl VALUES ("IS5_7","024_5_7","ISA","5","7","7","Na wasina dam Isrel na naboni, toudi na Yawe God Maragata Kirakiina yana wain kwabuna, bi uravidi iwawa yana nuwamiise kiiravine na toudi ware Jiuda damdi. Touna itumayedi da awaki miisena siyabera, bi gegha, wasadi na toudi kasunugha sibera. Itumayedi da awaki rotomanidi siyabera, bi gegha, wasadi na duudu iwaiyaneni wiiwiita kiiravine. ");
INSERT INTO aui_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Mmkona awaki itubugha Jiuda kana kiiwawo, Usaiya irabobo na bodune. Tagu, Bada akita kiikiiwawo yadi abamakamake geekirakiina debane iyamakamake, bi kana kwama pusiridi na Bare Kabikabikuwayina ivibonuvi. ");
INSERT INTO aui_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Bi Serapim na Bada sigwagwara wiikenavivireni siyibodaboda da awaki ikayoveni na toudi siyabera bi tatadigegha na mabemabedi yadi 6. Tatadigegha na mabemabedi batama mayiyidi sikasibabara, bi mabemabedi batama na bada kayedi sikasibabara, bi tughuridi yadi bata na toudima siyaroworowogha. ");
INSERT INTO aui_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Bi siyikwatu kabivivirana siyawonawona bo, “Yawe God Maragata Kirakiina, na kabikabikuwayina, kabikabikuwayina, kabikabikuwayina! Yana kiniwa kubura tupana ivibonuvi.” ");
INSERT INTO aui_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Gamodi gugurina ibera da yana Bare Kabikabikuwayina kayena da matamketana koghoridi sividagudagu, bi buu barena kamona ivibonuvi. ");
INSERT INTO aui_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Wasina bi awona bo, “Aiyo! Kabikwarakwara anabanani! Yagu sisiya na dadabudi, bi wawaya iiyawogha yadi sisiya dadabudi na kamodiye amakamake, bi kate bada Yawe God Maragata Kirakiina akita na anarabobo!” ");
INSERT INTO aui_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Wasina bi Serapim tana suwara gabugabuna gawarine kavinama umeka muyamuyana ikavini, bi irowogha iyowogha ipiika tagu biidi. ");
INSERT INTO aui_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Da tounama kawagu ikasitowoyi bi iwona bo, “Kuwaiyana! Mmko umekina kawam ikasitowoyi da nokove na Yawe God yam berona ikabitavedi bi yam tamumu inoghotataveni.” ");
INSERT INTO aui_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Wasina bi Bada gamona awaiyaneni, iwona bo, “Iiyabo anadaru da sawariyonayona? Iiyabo kiiravidaye inanagho?” Na awona bo, “Tagu ananagho! Kudarugu.” ");
INSERT INTO aui_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Yawe God peroveta Aisaiya kawanama ivisisiya magha Ahes biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Yawe yam God kibabiini da matakira iniyevevem. Tam rubana meboda wawaya raborabobodi yadi gawara kamonakinama, bo abame kiidamonakiye matakira kiiravine kunibaba.” ");
INSERT INTO aui_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","Bi Ahes iwona bo, “Tagu gematakira kiiravine Yawe God anibabiinina, bi tagu geyaguwiina Yawe God anaruyaghanina.” ");
INSERT INTO aui_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Na Aisaiya iwonabodeyana bo, “Tami iiyawogha kiiwawo Deivid nosinosina, mmko kowaiyaneni! Tami yami kawakeekeema wawaya koberaberadi na samameyedi. Bo gerubana noko kiiravine, na yami kawakeekeema, bada koberabera na Yawe God yamameyeni? ");
INSERT INTO aui_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Noko kiiravine Bada touna wosina matakira iniyevevemi. Na mma naboni: Wasike mamaragina inaropeya da inituwa tomogha, bi iniwaghawaghayeni Imaniwel.” ");
INSERT INTO aui_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Wawaya iiyawogha siyiinuwapoya na gewiididibare sinamakena. Naghove Zebulan kubure da Neptalai kubure na wawaya wiikayotaketowane siyamakamake, bi gegha raghani muriye na nokodi kubura kabikarawagha sinakabi - keda ghamana Mediteriyen Yegii ririnagha, bi kubura Jodan rarimina nawane da kate bada Galili kubure meme dam bi dam sipiika samakamakena. ");
INSERT INTO aui_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Wawaya wiididibare sapeepewa na yeghana matakonakonana sikita; bi iiyawogha wiididibara ghamane samakamake, na yeghana irukarata debadiye. ");
INSERT INTO aui_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Bada, dam Isrel kubera da sikoroto kirakii, tam nuwasisira ghamana kuveredi. Awaki kiiravidiye kubera na iberadi da sinuwamiise kirakii, kedana mayimayiyina ware wawaya kabipura raghanine sinuwamiisena naboni, bi kedana mayimayiyina ware wiiruwa tomotomogha nuwamiise kiiravine sarurukwatu na naboni raghanina kadiaviya gwabidima yapi sawaridi sikawara bi sareereghana. ");
INSERT INTO aui_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Simira kiiravidae itubugha, Yawe God natutomogha ivereda. Touna maragata inakabi da inibadeda. Bi wawaya sinakwatuveni da: “Wiiyoyowana Verevereyana Waratetena,” “God Maragata Kirakiina,” “Tamada Makewaghawaghasina,” “Nuwaruriri Badana.” ");
INSERT INTO aui_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Yana wiibada da nuwaruriri inapiikeni na inatuwa wiikarukaru da geere damonana. Touna kiiwawo Deivid kana gaware inikiiwawo, da kubura tupana inibadeni, inabera da inimaragata bi wawaya rotomane inakoyayidi da wiisuwona teya, kata da inanagho wiikarukaru waghata. Yawe God Maragata Kirakiina mmko inabera basuna yana nuwayuyuna wawaya biiyadi na iragata kirakii. ");
INSERT INTO aui_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Kiiwawo wouna Jese nosinosina kamodima inapiika; ware kiighabi naboni iyakarapumka iyakanikanibu, ragharagha wouna kiikotowa ramramnama inagogo da inuwagha. ");
INSERT INTO aui_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","Yawe God kanumina na touna gwabine, bi noko kanumina nuwagiura da akowa inavereni na yana wawaya inibadena yaporidi, kanuma iiyabo ininaghoveni bi noghota rotomanidi inabera da yana nuwagiura inakivina, kanuma iiyabo iniwiiteni na inakowa da Yawe God inakabikarawayeni. ");
INSERT INTO aui_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","3","Touna, Yawe God kabisisireninama ininuwamiise. Bi sawara matanama yakitakitadi bo tainanama yawaiwaiyanedi na gegha initupawamiwamiredina. ");
INSERT INTO aui_vpl VALUES ("IS11_4","024_11_4","ISA","11","4","4","Touna wawaya moyamoyakidi keda rotomanine initupawamiwamiredi, bi wawaya noganogadi na noghota miisedi inabera kiiravidiye. Yana sisiya na ware kii kakokakonama tanawa yarurouvina naboni, da wawaya kawakeekeedi yikasunughana. ");
INSERT INTO aui_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Wiitupawamiwamira rotomanidi na ware kikiru borine iyiruvivireni na naboni, bi wiisuwona na ware sineyetutura geyageyane iyiruvivireni. ");
INSERT INTO aui_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","Noko raghanine, na ribiribi geananamanidi da ananamanidi na nuwaruririye sinamake patapata, noko biidi garagara daghasi na sip wotuwotudi teya sinimakeyana, lepord na gout wotuwotudi teya sinikeneyana, laiyon na kau wotuwotudi teya sinakam patapata bi ededa gisigisidi sinageghomiiri da sinakoyayidi. ");
INSERT INTO aui_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","Kau da Beya sinakam patapata, bi natunatudi na nuwaruririye sinikena reereghana. Laiyon na rei sinakam ware kau sakamkamna naboni. ");
INSERT INTO aui_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","Pepeya, mota ere tuwamorobidi kadi bonagha riridiye sinirekwa; bi ededa gisigisidi bada mota googonidi kadi nighuve imadi sinatoura bi gesinakanidina. ");
INSERT INTO aui_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","Toudi gesinivisi sinayouna bo gesiniyogha kabivivirana da bero sinayouna yagu koya kabikabikuwayina debanena, basuna wawaya iiyawogha Yawe God sakovi na kubura tupana sinibonuvi ware rarima yegii ivibonuvina naboni. ");
INSERT INTO aui_vpl VALUES ("IS11_10","024_11_10","ISA","11","10","10","Noko raghanine na kiiwawo wouna Jese nosinosina kamodima na ware matakira naboni wawaya kiiravidiye kubura debane. Toudi sinariyeni touna biidi yana kwanatu kiikiiwawone bi gawarina meme yamakamake na kabikabikarawayina. ");
INSERT INTO aui_vpl VALUES ("IS35_1","024_35_1","ISA","35","1","1","Nokodi raghanidiye na mayaba da warere sininuwamiise; bi saru gubure na sinapopo. ");
INSERT INTO aui_vpl VALUES ("IS35_2","024_35_2","ISA","35","2","2","Mayaba debane kii sinagogo da sinibonuvi na ininuwamiise da nuwasisire inarukwatu. Touna kana kita ininuwakayowana ware Lebinon koyadi naboni bi inamoura ware kwabu kubura Kamel da Seron ruwiipikapikadi kamodiye naboni. Bi name Yawe God yana kiniwa iniyeveveyana, da nama wawaya tupadi yada God yana waratete da maragata sinakita. ");
INSERT INTO aui_vpl VALUES ("IS35_3","024_35_3","ISA","35","3","3","Touna iiyawogha imadi noganogadi na inakabi wiimaragasidi bi kayedi kirokirorodi na maragata inaveredi. ");
INSERT INTO aui_vpl VALUES ("IS35_4","024_35_4","ISA","35","4","4","Wawaya iiyawogha sanaghanaghara na kuwonedi bo, “Gekonanagharana, kovimaragata! Kokita, yami God yapiipiika da kana aviya iniberodi. Bi yapiipiika na aro inaveredi bi tami iniyawiimi.” ");
INSERT INTO aui_vpl VALUES ("IS35_5","024_35_5","ISA","35","5","5","Raghanina inapiika na inabera da wawaya mata potapotadi sinakita bi taina potapotadi sinawaiyana. ");
INSERT INTO aui_vpl VALUES ("IS35_6","024_35_6","ISA","35","6","6","Wawaya digadigadi sinikapokapoka ware diya, bi kawa gumegumedi nuwamiiseye sinarukwatu. Rarima tanawama sinawusira sinagae da mayaba sinavera rughuwonedi; ");
INSERT INTO aui_vpl VALUES ("IS35_7","024_35_7","ISA","35","7","7","Egha muyamuyana inawamiri da initarabu, bi tanawa kanakanana na rarima wusiridi sinarumaghatara. Ribiribi geananamanidi yadi makamake gawaridi meme sakenayowoghana sinisawasawa bi taritariga da kanikani peyaridi nama sinagogo. ");
INSERT INTO aui_vpl VALUES ("IS35_8","024_35_8","ISA","35","8","8","Keda ghamana kana waghawagha “Keda Kabikabikuwayina” na noko gawarina inavera rughuwoneni. Berabero wawayidi gemeyani debane sinapepewana, nokona God yana wawaya kawagha kiiravidiye; wawaya kawakeekeedi geririnagha sinapepewa wapawapana. ");
INSERT INTO aui_vpl VALUES ("IS35_9","024_35_9","ISA","35","9","9","Laiyon kate genoko kedana debanena, bo getana ribiribi googonidi geananamanidi sinagae debanena. Wasina iiyawogha Yawe God iviyawiidina toudi namagha sinapepewa. ");
INSERT INTO aui_vpl VALUES ("IS35_10","024_35_10","ISA","35","10","10","Wiiwiiyawiidi na nuwasisire bi sinatawora sinaveramagha Jerusalemma. Nuwasisira makewaghawaghasina gayamidiye sinakunapi ware pinawa naboni. Toudi parapa nuwamiise da nuwasisira inibonuvidi, na nuwabero da dou sinamomogha waghata. ");
INSERT INTO aui_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Yami God iwona bo, “Wonawiitora sisiyidi kovisisiya yagu wawaya biiyadi, wonawiitora sisiyidi kovisisiya. ");
INSERT INTO aui_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Nuwapikae kovisisiya wawaya biiyadi Jerusalem kamone bi kowonedi da yadi kabikwarakwara raghanina ikovi, da kate bada Yawe God yadi tamumu inoghotatavedi. Bi touna wasina yadi tamumu kiiravine aro kasiwiikapuna iveredi.” ");
INSERT INTO aui_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Kowaiyana, tagu wawaya tana yarurukwatu na gamona awaiyaneni, “Warereye keda kogigiri Yawe God kiiravine. Mayabe keda rotomanina kobera yada God kiiravine. ");
INSERT INTO aui_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Anagha tupadi kotounamumu, bi koyapoko da koyanuwa kotarawiipikapika. Tanawa opopukidi siniruwiipikapika, bi gawara akakimidi komumutavedi. ");
INSERT INTO aui_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Wasina bi Yawe God yanakiniwa inarumaghatara, da wawaya tupadi meghamegha na raghanina tanagha sinakita. Bi Yawe God touna wosina mmko wiisuwonina ibera, kiiravine mmko ivisisiyeni.” ");
INSERT INTO aui_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Zaiyon, tam na sawariyonayona iiyabo wara miisena kwapiipiikeni, na kugae, kunagho koya kiidamo debane. Jerusalem, tam na sawariyonayona iiyabo wara miisena kwapiipiikeni, na gamo kiitowanama kurukwatu, kurukwatu bi gekunanagharana. Jiuda kubura kwanatudi kuwonedi bo, “Kokita yami God mmakatanina!” ");
INSERT INTO aui_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Eka, Yawe God ere maragasina yapiipiika da inibada. Bi wawaya iviyawiidi na yawata yapiipiikedi. ");
INSERT INTO aui_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Yana wawaya inakoyagha yaporidi ware sip bodaboda yana sip yakoyakoyayidina naboni. Touna sip wotuwotudi imanama inarukabepidi, inadogaredi da inakawaridi, bi sip yagayagaridi ere natunatudi, nuwatepane ininagho kedaridi sinanagho. ");
INSERT INTO aui_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","Yawe God iwona bo, “Kokita, yagu tamariyana, iiyabo akabiwiimaragasina, Tagu avineyi bi iinuwamiise touna biidi. Bi kanumigu touna debane atore, na keda rotomanine initupawamiwamira wiimasi, wawaya tupadi kiiravidiye kubura debane, da inapiikedi God yana wiibadana rogune. ");
INSERT INTO aui_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","Touna geinarukwatu bo gamona inarukabepina, gegha kedae inisisiya gwaruna. ");
INSERT INTO aui_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","Sawasawa reina kiina tuwayowanina gerubana inaturagiinina, bo rampa vikina pepana nuwatepane karakarasina gerubana inuvenawiipekina. Touna keda rotomanine initupawamiwamira wiimasi bi nuwayuyune kayowiiyayeyana inapiikeni wawaya tupadi biidi kubura debane. ");
INSERT INTO aui_vpl VALUES ("IS42_4","024_42_4","ISA","42","4","4","Touna geinakabibeku bo inanagharana, patana da kayowiiyayeyana kubura debane inatoura wiikayokayowana inakovi. Wawaya kubura rabarabae patana yana wiiyeveveyana sinakoyayi. ");
INSERT INTO aui_vpl VALUES ("IS42_6","024_42_6","ISA","42","6","6","Tagu, Yawe God, yagu miisenama na akwatuvem, imam anakabitawani da anitara babaranem. Anaberam da ware wiiwaghasina maragasina naboni wawaya biiyadi bi kate yeghana kubuna damdi kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("IS42_7","024_42_7","ISA","42","7","7","Tam wawaya mata potapotadi matadi kuna kimotaatara, bi biwakabikabi damdi biwa gawarinama kunikanibuvedi, bi iiyawogha biwa gawaridi wiididibaridiye makamakedi, na tam kuniyawiidi.” ");
INSERT INTO aui_vpl VALUES ("IS49_3","024_49_3","ISA","49","3","3","Yawe God iwonegu bo, “Isrel, tam na yagu tamariyana, basuna tamve na wawaya yagu kiniwa kiiravine na sinakabepepigu.” ");
INSERT INTO aui_vpl VALUES ("IS49_5","024_49_5","ISA","49","5","5","Muriye da sinagunaki raparapanama ayakanibu, na Yawe God ivineyigu da yana tamariyana. Mmko ibera na kiiravine yana wawaya iyakabiwiiveramayidi touna wosina biidi, bi Isrel damdi iyakasiwiitaghoma mayedi touna wosina biidi. Yawe God ikabikarawayena kirakiiyegu, da touna na yagu maragata kayena. ");
INSERT INTO aui_vpl VALUES ("IS49_6","024_49_6","ISA","49","6","6","Yawe God iwonegu bo, “Tam yagu tamariyana bi bagibagi averem da kunabera, bi mmkona bagibagi gisina, Jeikap kana dam kitaghoma mayedi bi Isrel damdi kabiwiiveramayiidi iiyawogha aviyawiidina. Na kata anaberam da tam na yeghana maghatara damdi biiyadi, bi wawaya tupadi kubura debane kunawonedi da tagu aniyawiidi.” ");
INSERT INTO aui_vpl VALUES ("IS49_14","024_49_14","ISA","49","14","14","Bi wawaya Jerusalem kamone siwona bo, “Yawe God ikuyoveda, touna ivinuwawapida.” ");
INSERT INTO aui_vpl VALUES ("IS49_15","024_49_15","ISA","49","15","15","Na Yawe God iwona bo, “Rubana sinada natuna waghata sususuna ininuwawapi, bi geininuwayuyuneni da touna ivitubuyi? Meboda sinada natuna ininuwawapi bi Tagu kate geaninuwawapimina!” ");
INSERT INTO aui_vpl VALUES ("IS50_4","024_50_4","ISA","50","4","4","Yawe God iviyevevegu da metagha anisisiya, da tagu wawaya amameyanidi anawonawiitoratoradi. Didibara patepatena na yakasiwiimatakigu, bi tainagu yakimobubu da awaki iniyevevegu na anawaiyanedi ware giruma ededa. ");
INSERT INTO aui_vpl VALUES ("IS50_5","024_50_5","ISA","50","5","5","Yawe God tainagu ikimobubu na geayiaviyeni bo ayamiiri kubutenina. ");
INSERT INTO aui_vpl VALUES ("IS50_6","024_50_6","ISA","50","6","6","Tagu kubukiigu avereyana da wawaya sirouvi, bi nawanawagu avereyana da kagu mudukoro sitayinaraguragu. Bi raghanina siyiinamayegu da siyakanukanugu, na mayiyigu geayikowoyina. ");
INSERT INTO aui_vpl VALUES ("IS50_7","024_50_7","ISA","50","7","7","Bi gegha da Yawe God iviwiitegu na gesinakitayowoyeguna. Noko biidi tagu iitepatora, bi akovi da yagu kabikwarakwara sinimayagha geinavereguna. ");
INSERT INTO aui_vpl VALUES ("IS50_8","024_50_8","ISA","50","8","8","God na ririguve bi iwonayaragha da tagu getana awaki ayabera berona. Iiyabo teya kanikawakereyana? Piika, tani sisiya patapata. Iiyabo yiwawugu? Touna iyamiiririya da yana wiiwawu iyawonegu. ");
INSERT INTO aui_vpl VALUES ("IS50_9","024_50_9","ISA","50","9","9","Kita, Yawe God na yagu nawae da yiwiitegu; Iiyabo inawona da tagu bera berona abera? Kagu wiiwawu wawayidi tupadi na sinamomogha ware gara katamanidi beba sakamna naboni. ");
INSERT INTO aui_vpl VALUES ("IS52_7","024_52_7","ISA","52","7","7","Sawariyonayona tana koya nawanakinama wara miisena ikabiyapiipiika, na touna kayena waratete wosina, basuna warana yapiipiikeni na nuwaruriri da metagha God wawaya iniyawiidina kiiravidiye. Bi Zaiyon iwoneni bo, “Yami God ivikiiwawo!” ");
INSERT INTO aui_vpl VALUES ("IS52_8","024_52_8","ISA","52","8","8","Kuwaiyana, wawaya iiyawogha yam kwanatu sakighukighu na sarurukwatu; bi toudimani matadima sikita da Yawe God yaveraveramagha Zaiyonma, na nuwamiiseye sarurukwatu patapata. ");
INSERT INTO aui_vpl VALUES ("IS52_9","024_52_9","ISA","52","9","9","Tami, Jerusalem kamone gawara kasikasiwiiberodi, nuwamiiseye korukwatu patapata basuna Yawe God yana wawaya na yawonawona wiikayokayowanedi, bi yana kwanatu yabababari. ");
INSERT INTO aui_vpl VALUES ("IS52_10","024_52_10","ISA","52","10","10","Yana maragata kabikabikuwayina yidebeni dam tupadi biiyadi, bi wawaya tupadi kubure sinakita da yada God, wawaya yadi tamumuma iniyawiidi. ");
INSERT INTO aui_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Kita, yagu wiitamariyana yana bagibagi inabera wiimasiyeni da yana bagibagi uwadi sinatubugha; Tagu anarukabepi da wawaya tupadi inageetawanidi bi kabi karawagha ghamana sinavereni. ");
INSERT INTO aui_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Wawaya korotodi raghanina sikitana sikabinokeni; toudi sirouvi siviberoberowaneni da mayiyina kitana ivibogae, bi kanakita iwamiri da gegha naboni ware wawaya. ");
INSERT INTO aui_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Da dam tupadi ininokadi, bi kiikiiwawo sinakabinokeni na kawadi sinapota gesinisisiyana. Kiiravine awaki sawaridi gesiyawonedi, na sinakita, bi awaki sawaridi gesiyawaiyanedi, na akovidi sinayouna. ");
INSERT INTO aui_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","Iiyabo mmko sisiyina kavisisiyeni na yigeruveni? Yawe God iiyabo biidi yana maragata ividebeni? ");
INSERT INTO aui_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Bi Yawe God matane na yana tamariyana igogo igae ware kii wouna naboni, da tanawa kanakanane bi ramramna ituwa. Touna gekiiwawo mayiyidi iyakabi bo iyikomerowana da kayakitani, getana awaki iyinuwatayinimii da iyatainariyamii touna biidi, bo iyaberamii da touna kivinina kayakayovenina. ");
INSERT INTO aui_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Touda takita kayobareni da tawona sinighiiyeni, tomogha kabikwarakwara yawata da sinivisi teya, bi tamiirikubuteni da bogae takita, touda getayakabikarawayeni bi tanoghosi da touna getana awaki. ");
INSERT INTO aui_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Tanoghosi da yana kabikwarakwara na tounamani kana aro, God iviaviyeni da sinivisi ivereni ware yana berabero kiiravine. Bi gegha da yada sinivisi touna ikabi, da yada kabikwarakwara ikawari. ");
INSERT INTO aui_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Touda yada tamumu kiiravine, na ririwana sigwari bi yada berabero kiiravine na sirouvi, bi aro meko ikabi na nuwaruriri ipiikeni touda biiyadi, bi rouwae na yawa takabi. ");
INSERT INTO aui_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Bi tupada, na ware sip naboni tasiwana, touda tatadigegha, yada kedae yada kedae tanono; bi gegha da Yawe God yada berona da yada tamumu na tupadi touna ivikawari. ");
INSERT INTO aui_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Toudi sivikayotaketowanena beroveni bi iviraborabobo da getana awaki iyisisiyenina. Touna geiyituyakayakata ware nigenige wawaya sanaveni kasunuyina biidi na naboni bo ware sip ghunighunina sasikasika bi yiraborabobo na naboni. ");
INSERT INTO aui_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Toudi sikabitawani da siviwawu wapawapa bi sikabisinaveni. Bi iiyabo, wawaya kamodima iyakovi da touna siviraboboni, toudi yada wawaya yadi tamumu kiiravine na sigwari? ");
INSERT INTO aui_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Touna getana awaki berona iyabera bo iyiyabana, bi gegha da wawaya kawakeekeedi teya karawage sitoredi, bi wawaya moumouridi yawata sidogu wiikapudi. ");
INSERT INTO aui_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Bi gegha da mmkona Yawe God yana nuwagiura da yana tamariyana ivikasigiiyaneni bi iberani da ikabikwarakwara. Raghanina tamariyana inaveremayeni ware suwara naboni da tamumu kabitavenina na noghotataveyana yapiikeni na touna nosinosina sinakoroto kirakii, da raghani gurina inamake, bi tounae na Yawe God yana nuwagiura inarumaghatara. ");
INSERT INTO aui_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Touna yana kabikwarakwara kamna inakita da ininuwamiise, bi inakovi da geiyakabikwarakwara wapawapana. Yawe God iwona bo, “Yagu rotomana berabera tamariyina wawaya korotodi yadi tamumu inakawari bi inaberadi da sinarotomana kirakii. ");
INSERT INTO aui_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Noko biidi, akabigeegeeyeni da gawara kabikabikarawayina avereni, bi gawarina na wawaya maragasidi da ghamaghamadi kamodiye, basuna touna rabobo geiyasinighiiyenina da wawaya kawakeekeedi yawata sikabiyawa wiikapu. Bi berabero wawayidi korotodi yadi tamumu ikawari bi kiiravidiye irupari.” ");
INSERT INTO aui_vpl VALUES ("IS54_5","024_54_5","ISA","54","5","5","Kam berabera wawayina na ware moghanem naboni bi kana waghawagha na Yawe God Maragata Kirakiina. Isrel kana God kabikabikuwayina iniyawiimi, touna wawaya sakwatuveni da “Kubura tupana tumtumpipinina kana God.” ");
INSERT INTO aui_vpl VALUES ("IS54_6","024_54_6","ISA","54","6","6","Isrel, tam na ware wasike katotawota inayina naboni da moghanena iwonasinighiiyeni bi ikuyoveni na wasikena iyiinuwapoya kirakii. Bi gegha da Yawe God ikwatuwiiveramayim touna biidi bi iwona bo, ");
INSERT INTO aui_vpl VALUES ("IS54_7","024_54_7","ISA","54","7","7","“Raghani tupona kiiravine akuyovem, bi wiinuwanuwaghaneyana ghamana teya na anakabimayem. ");
INSERT INTO aui_vpl VALUES ("IS54_8","024_54_8","ISA","54","8","8","Nuwanuwagu ipughu kirakii na raghani tupona amiirikubutem bi nuwayuyuna makewaghawaghasina teya, na yagu nuwamiise aniyevevem.” Nokona metagha Yawe God kambabara wawayina iwona. ");
INSERT INTO aui_vpl VALUES ("IS54_9","024_54_9","ISA","54","9","9","“Nowa iyamakamake raghanine na avisuwona da gemuriye kutukutuwa noko naboni kubura debane yawa iyibero mayeni, na kata iisuwonem da gemuriye nuwanuwagu inapughu tam biidi bi geanawonaghakiyemna. ");
INSERT INTO aui_vpl VALUES ("IS54_10","024_54_10","ISA","54","10","10","Bagune meboda koya kiidamo sinanaghotaveyana da koyanuwa sinamomogha, bi gegha da yagu nuwamonika tam kiiravimve na gemeyani inakovina, bi wiisuwona abera da nuwaruriri ayapiikeni tam kiiravimve na inamakewaghata.” Nokona metagha Yawe God iiyabo ivinuwanuwaghanemna iwona. ");
INSERT INTO aui_vpl VALUES ("IS55_1","024_55_1","ISA","55","1","1","“Tami iiyawogha kanighomi sirugawowora, na tupami kopiika rarima konaniuna, bi tami iiyawogha mane gegha, na kopiika, kam konagimona da konakam! Kopiika, wain da milk gemanema konagimona, bi miisanidi gegha! ");
INSERT INTO aui_vpl VALUES ("IS55_2","024_55_2","ISA","55","2","2","Geyami mane konikawawanana awaki gekanikanina kiiravina, gegha kam meko kunakani da geinanunurim bi kiiravine kunabagibagina! Gamogu konawaiyaneni, na tami awaki miisena na konakani, tami kam metevina parapa koninuwamiiseyeni. ");
INSERT INTO aui_vpl VALUES ("IS55_3","024_55_3","ISA","55","3","3","Yagu sisiya kowaiyana, kopiika tagu biidi, tagu konawaiyanegu na yawa wiisuwonina konakabi! Tagu wiiwaghasina maragasina makawaghawaghasina tami biiyadi anabera, aninuwayuyunemi bi miisena anabera tami biiyadi ware kiiwawo Deivid biidi avisuwonana naboni.” ");
INSERT INTO aui_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","“Yawe God kata kovinoyeni, tami patana mmko raghanine na konabanani, touna biidi kata korupari, touna patana riirimiye. ");
INSERT INTO aui_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","Tami berabero wawayimi, yami keda berodi kokuyowana, da yami noghota berodi kowamira. Yawe God biidi komiiri wamira, touna ininuwanuwaghanemi, yada God biidi korupari, da yami bera beroberodi tupadi inanoghotatavedi.” ");
INSERT INTO aui_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","Yawe God iwona bo, “Yagu nuwagiura na getami yami nuwagiura naboni, bi yagu bera na getami yami bera naboni. ");
INSERT INTO aui_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","Abama na parapa igee kirakii, kubura ikuyovena kirakiiyeni, na noko naboni yagu bera na parapa igee kirakii, getami naboni bi kate yagu nuwagiura na parapa igee kirakii, getami naboni. ");
INSERT INTO aui_vpl VALUES ("IS55_10","024_55_10","ISA","55","10","10","Wonagu na ware kiyara da youra duduvina abamama yayowoyowoghana naboni, gesiyaveraveramagha yaininagha, dagudagune na yadi bagibagi sabera, tanawa rarima savereni, na kii sakarapumpumka sagogo, na pei wawaya saveredi da sawawa bi kam sakam. ");
INSERT INTO aui_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","Yagu sisiya na wasina noko naboni, geiyaveraveramagha wapawapa tagu biidina, dagudagune na yana bagibagi yabera, touna sawara tupadi akayokayowana da iyabera na inadibera, da uwana inatore meko akayoveni da iyuwayenina.” ");
INSERT INTO aui_vpl VALUES ("IS56_1","024_56_1","ISA","56","1","1","Yawe God iwona bo, “Tagu pinimina bi wiiyawiimi kiiravine na anaveramagha, bi wawaya tupadi yagu bera rotomanidi aniyevevedi, na rotomane da wiisuwone wawaya kokoyagha yaporidi bi bera miisedi kobera. ");
INSERT INTO aui_vpl VALUES ("IS56_6","024_56_6","ISA","56","6","6","Muriye, na kubuna damdi sinaveremayedi Tagu, Yawe God biidi da yagu kayowana sinabera; toudi sininuwayuyunegu bi sinakabikuwayegu. Toudi yagu wiiyawiitaveyana gabudarina sinakabikarawayeni bi noko gabudarina kana gwara ayavereveredi na gesinikasigiiyeni da siniberona. Bi yagu wiiwaghasina maragisina sinakabitawana kikisi. ");
INSERT INTO aui_vpl VALUES ("IS56_7","024_56_7","ISA","56","7","7","Nokodi kubuna damdi anakabidi anapiika yagu koya kabikabikuwayine, Jerusalem kwanatune, bi yagu pari barene nuwamiise anaveredi. Yadi suwara gabugabunidi da puyo mududi Tagu yagu suwara gabugabuna gawarina debane aniwaghasinedi, basuna wawaya yagu Bare Kabikabikuwayina sinakwatuveni da pari barena dam tupadi kiiravidiye.” ");
INSERT INTO aui_vpl VALUES ("IS58_7","024_58_7","ISA","58","7","7","Kami kam wawaya wiiwiivitonanidi yawata kovi kamvereyana, bi wawaya moyamoyakidi gegha ere yadi bare na kotayinarughuvedi yami bareye. Bi wawaya iiyawogha gegha ere kadi gara da siniyagha na kokabirereyedi, bi gegha yami ganigani rakarakadi konamiiri kubutedina. ");
INSERT INTO aui_vpl VALUES ("IS58_8","024_58_8","ISA","58","8","8","Wasina bi yeghana inarukarata debamiye, ware raghani diidibara gabudara yageegeena naboni, bi kami gubaga na yaiyainagha sinayawa. Tagu nonowa na tami gwabimiye da aniyawiimi bi yagu gwabiyana na inababaremi nawanawa tupadima. ");
INSERT INTO aui_vpl VALUES ("IS58_9","024_58_9","ISA","58","9","9","Wasina bi konarukwatu Tagu, Yawe God biidi na anawonabodemi, bi wiiwiita kiiravine Tagu biidi konadou na anawona bo, ‘Tagu mma!’ Gegha vita ghamana wawaya konikawaridina, bi gekonatupakoghata bo konisisiya berovedina, ");
INSERT INTO aui_vpl VALUES ("IS58_10","024_58_10","ISA","58","10","10","Yami maragata tupanama wawaya wiiwiivitonanidi koviwiitedi bi kobagibagi kirakii da wawaya piropiro kamodiye na koniwiitedi, wasina bi yami yeghana wiididibara kamonama inarukarata bi yami nubabasu na sinarukarata da ware yubasu gabudarina yeghanina naboni.” ");
INSERT INTO aui_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","“Yawe God Maragata Kirakiina kanumina iveregu, touna ivineyigu da wara miisena anadimeni wawaya moyamoyakidi biiyadi. Bi idarugu da wawaya iiyawogha wiiwiinuwaberodi aniyawiidi. Wawaya iiyawogha siburavidi bi sikou patupatumidi na anakaradeba da toudi sirupamatavedi siyawa, bi wawaya biwa gawarina kamone na anawonedi da gawara wiididibarina sinakanibutaveni. ");
INSERT INTO aui_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Bi idarugu da wawaya anawonedi da raghanina ipiika da Yawe God miisena inabera toudi biiyadi. Gabudarina mmakatanina da kana aviya biiyadi kana biwa inasarobi, bi idarugu da wawaya iiyawogha saduudu na aniyororoyidi. ");
INSERT INTO aui_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Bi wawaya tupadi Jerusalem kamone iiyawogha sinuwabero kirakii na aniwiitedi, bi yapukare gayamidiye wasadi na tagu kepamara pinavina anaveredi. Toudi oilma gayamidi sinighoudi da yadi nuwamiise kana matakira bi gemuriye sinadou maghana. Bi nuwavisi wasadi, na kabepepa ayidi ware kadi gara naboni. Yadi bera na parapa rotomanidi, toudi ware kii miisedi bi maragasidi; Yawe God touna wosina kiidi iwawa da wawaya iyiyevevedi da yana miisena iwaratete awaki patana. ");
INSERT INTO aui_vpl VALUES ("IS61_6","024_61_6","ISA","61","6","6","Wawaya sinakwatuvemi da, ‘Yawe God yana prist’ bi ‘yama God yana bagibagi tomotomoyidi.’ Tami mmko kuburina debane dam tupadi yadi gararabama sawara miimiisedi kunayouna bi yadi mourae na kuna kabigeegeeyem da tam kumoura.” ");
INSERT INTO aui_vpl VALUES ("IS61_8","024_61_8","ISA","61","8","8","“Tagu bera rotomanidi iinuwayuyunedi bi kabiyouna da bera riwariwadi iisinighiighiiyana. Basuna tagu wiinuwayuyunigu na yagu wawaya yadi miisana anaveredi bi yagu wiiwaghasina maragasina makewaghawaghasina toudi biiyadi anabera. ");
INSERT INTO aui_vpl VALUES ("IS61_9","024_61_9","ISA","61","9","9","Dam tupadi mma kubura debane na yagu wawaya nosinosidi sinakovidi bi sinakabikarawayedi. Wawaya tupadi sinakitadi na sinawona bo, ‘Yawe God vikodi dam parapa ivimiiseyedi!’” ");
INSERT INTO aui_vpl VALUES ("IS61_10","024_61_10","ISA","61","10","10","“Tagu parapa nuwasisira ikabigu basuna Yawe, yagu God yabera da iinuwamiise kirakii. Na iviyawiigu, bi iberagu da rotomana berabera wawayina touna naboni, bi noko wiiyawiina da bera rotomanidi na ware kagu gara naboni! Na tagu ware tomogha raghanina yanayi na naboni gayama kounagha waratetena yakotenina naboni. Bi ware wasike raghanina yanayi na posaru da kakatema yakounagha na naboni. ");
INSERT INTO aui_vpl VALUES ("IS61_11","024_61_11","ISA","61","11","11","Wasina ware tanawa yabera da kii matagha sagogo sageena, bo ware kwabu yabera da pei sagogo sageena naboni, na noko naboni Yawe God, inabera da bera rotomanidi da kabepepa sinatubugha dam tupadi biiyadi kubura debane bi yana berabera rotomanidi nokodi gawaridiye sinarumaghatara.” ");
INSERT INTO aui_vpl VALUES ("IS64_4","024_64_4","ISA","64","4","4","Naghove, naghove waghata getana iiyabo iyawaiyana da God tana meme tam naboni, bo wawaya getana God tam naboni iyakita towoyina! Iiyabo yiwiita da iiyawogha siyitumaghanem na kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("IS64_5","024_64_5","ISA","64","5","5","Raghanina wawaya nuwamiimiiseye bera miisedi saberabera, bi yam keda rotomanidi sakivikivina, na kwiiwiitedi. Tam nuwanuwam ipughu toumii biiyadi, bi gegha da toumii patana raghani gurina bera berona kaya berabera. Metagha wawaya toumii naboni, rubana kuniyawiimii? ");
INSERT INTO aui_vpl VALUES ("IS64_6","024_64_6","ISA","64","6","6","Yama tamumu saberaberamii da tam matamve na toumii dadabumii. Bagune raghanina kiimatipo da bera miisedi kayabera, bi gegha da matam kamone na nokodi bera na ware gara dadabudi tamogosigosiridi naboni. Bi yama tamumu kiiravine na toumii kakanakana, ware rugurugu mekodi sipokina naboni da yama tamumu sakabitavemii ware yanunu rugurugu yatapi karuvedi sanaghotaveyana naboni. ");
INSERT INTO aui_vpl VALUES ("IS64_7","024_64_7","ISA","64","7","7","Bi getana iiyabo tam biidi iyarurupari, bo iyapiipiika tam biidi wiiwiita kiiravine iyibabana, basuna tam kumiiri kubutemii, na kubera da yama tamumu siviberomii. ");
INSERT INTO aui_vpl VALUES ("IS64_8","024_64_8","ISA","64","8","8","Bi gegha da Yawe God tamna tamamiinaki. Toumii na ware nau kana dobodobo naboni, bi tam na berabera wawayim. Tam imamma toumii tupamii kuberamii. ");
INSERT INTO aui_vpl VALUES ("IS64_9","024_64_9","ISA","64","9","9","Na genuwanuwam inapughu kirakii toumii biiyadi, bi gegha yama tamumu kunanoghota wiikarukaruvenina. Kita! Toumii tupamii na tam yam wawaya, na kinuwanuwaghanemii. ");
INSERT INTO aui_vpl VALUES ("JR1_4","025_1_4","JER","1","4","4","Mmkona Yawe God yana sisiya tagu biidi, iwona bo, ");
INSERT INTO aui_vpl VALUES ("JR1_5","025_1_5","JER","1","5","5","“Muriye da sinamnaki raparapane ayakabi wiipakipakim, na tagu nada waghata akovim. Bi muriye da kuyatubugha, na tagu avineyim da yagu peroveta dam tupadi kiiravidiye.” ");
INSERT INTO aui_vpl VALUES ("JR1_6","025_1_6","JER","1","6","6","Na awona bo, “O Yawe God, tagu tomogha gisigisi kawagha, bi geayakovi da metagha anisisiya!” ");
INSERT INTO aui_vpl VALUES ("JR1_7","025_1_7","JER","1","7","7","Bi Yawe God iwona bo, “Gegha kunawona bo, ‘Tagu tomogha gisigisi kawagha.’ Basuna meghamegha aniporam na kunanagho, da awaki anawonem da kuyisisiyedi na kunisisiyana. ");
INSERT INTO aui_vpl VALUES ("JR1_8","025_1_8","JER","1","8","8","Bi tagu gwabimve da anitara babaranem, na wawaya gekunanagharedina.” Nokona Yawe God yana sisiya tagu biidi. ");
INSERT INTO aui_vpl VALUES ("JR1_9","025_1_9","JER","1","9","9","Wasina bi Yawe God imana ikoghasi ikanibu da kawagu ikabitowoyi bi iwona bo, “Kita, yagu sisiya kawam kamone atutoura! ");
INSERT INTO aui_vpl VALUES ("JR1_10","025_1_10","JER","1","10","10","Tagu kata avineyim da yagu maragatama kunisisiya dam tupadi biiyadi da yadi kiikiiwawo teya. Mududi na kuni tainaraguwana da kuni kourikeyana, tam kuna gawoworidi da kuniberodi, bi mududi na kunayoghanidi da kunawawa.” ");
INSERT INTO aui_vpl VALUES ("JR1_17","025_1_17","JER","1","17","17","Yawe God iwonegu bo, “Kabununagha! Geghomiiri bi wara tupadi averem da kuyisisiya na kuwonedi. Gegha kunanagharedina, bi meboda kunanagharedi, na anaberam da parapa kunanagharegu da sinakitam! ");
INSERT INTO aui_vpl VALUES ("JR1_18","025_1_18","JER","1","18","18","Kata aberam da parapa kuvimaragata kirakii ware kwanatu kanagari geekirakiina naboni, ware koghora aiyanma sibera na yana maragata naboni bo papa bronsma sibera na naboni. Tam Jiuda kubura tupana rubana kunageebodeni, kana kiikiiwawo, kana babada, kana prist da wawaya tupadi. ");
INSERT INTO aui_vpl VALUES ("JR1_19","025_1_19","JER","1","19","19","Toudi siniaviyem da konirouwa, bi gerubana sinageeiwayimna, basuna tagu na tam yawata da anababarem.” Noko na God yana sisiya tagu biidi. ");
INSERT INTO aui_vpl VALUES ("JR6_13","025_6_13","JER","6","13","13","“Yagu wawaya tupadi, moyamoyakidi bi moumouridi na wawaya nuwabanigovidi, toudi wawaya siyabedi bi mane sayouna toudimani kiiravidiye. Bi kate peroperoveta da prist na bada naboni, Toudi tupadi na wiiwiiyabidi. ");
INSERT INTO aui_vpl VALUES ("JR6_14","025_6_14","JER","6","14","14","Yagu wawaya na kadi gubaga ghamana, bi peroperoveta da prist siyabera da siyabunami, bi gegha, sabera da ware tupakwari gisina naboni. Na sawona bo, ‘Sawara tupana na wasina,’ Bi gegha da noko gewaghasina!” ");
INSERT INTO aui_vpl VALUES ("JR17_5","025_17_5","JER","17","5","5","Yawe God mma naboni iwona, “Tagu nokodi iiyawogha wawaya yadi maragata kawagha situmaghanedi na anawonaimimagidi. Bi sanoghosi da maragata na wawaya gwabidima yapiika, na nuwanuwadiye Tagu Yawe God samiiri kubutegu. ");
INSERT INTO aui_vpl VALUES ("JR17_6","025_17_6","JER","17","6","6","Wawayidi na ware kii pokidi mayabe samiimiirina naboni. Toudi gawara kanakanane meme kii gesiyagoogo na name sinamakae, tanavina rariyegayegiina bi getana iiyabo nama iyamakamakena. Getana awaki sawaridi miisedi sinakita bagune raghanina sinatubughana. ");
INSERT INTO aui_vpl VALUES ("JR17_7","025_17_7","JER","17","7","7","Bi iiyawogha Tagu Yawe God situmaghanegu na animiiseyedi, toudi parapa yadi tumagha Tagu biidi sitore. ");
INSERT INTO aui_vpl VALUES ("JR17_8","025_17_8","JER","17","8","8","Toudi ware kii rarima kawabarane sagoogo na naboni, ramramdi sayowogha sanagho rarima ririne. Toudi gabudara muyamuyana gesiyinuwapoyenina, bi raghanina kiyara gegha na naghara gesiyakovina, basuna toudi rugurugudi na nonowa matayidi samakamake; bi nonowa suwuwagha. ");
INSERT INTO aui_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","Getana iiyabo rubana da wawaya nuwanuwana inakita wiimasiyeni, touna wiiyabaworaworana, ware gubaga tarabu naboni, gerubana iiyabo inabunamina. ");
INSERT INTO aui_vpl VALUES ("JR17_10","025_17_10","JER","17","10","10","Bi gegha da Tagu, Yawe God na wawaya nuwanuwadi akitakita, Tagu yadi noghota da wiina aruruwiitete yapoyaporidi, bi yadi bera rubane iimiisanena mayedi, bi awaki sabera kiiravinena yadi miisana waghata averedi.” ");
INSERT INTO aui_vpl VALUES ("JR20_5","025_20_5","JER","20","5","5","“Tagu anabera da mmko kwanatuna mourina tupana kana aviya aniruveredi, toudi tupeyane sinayouna da sinakawara sinanagho Babilonma. Noko na sawara miisanidi ghamadi, sawara mekodi kiiravidiye kobagibagi kirakii da koberana, bi kate Jiuda kana kiikiiwawo yadi gararaba tupadi aniruveredi da sinakawara.” ");
INSERT INTO aui_vpl VALUES ("JR20_7","025_20_7","JER","20","7","7","“O Yawe God, tam kukuwiitupi da yam sisiya wiiwiiyabidi avigeruvedi. Tam parapa maragasim bi tagu noganogagu, na kugeeiwayigu. Gabudara patepatena wawaya sawonawiinamayena pomegu, sanoghosi da tagu geakakoviguna. ");
INSERT INTO aui_vpl VALUES ("JR20_8","025_20_8","JER","20","8","8","Raghanina wawaya biiyadi aniisisiya, na ere duudugu anarukwatu bo, ‘Kami aviya sinagogona tami biiyadi na yawata konirouwa da siniberomi!’ Noko yam sisiyina awonedi, na nonowa siwawugu bi tagu biidi sisiya berodi sawonegu. ");
INSERT INTO aui_vpl VALUES ("JR20_9","025_20_9","JER","20","9","9","Bi raghani viya na awona bo, ‘Yawe God wonana kate geanisisiyenina, bo gemuriye kana waghawaghaye tagu anisisiya maghana.’ Bi gegha da, wonam nuwanuwagu kamone yaruwiikarata, noko ware keyama naboni nuwanuwagu kamone yakarakarata! Tagu iimatipo da kamoguve ayakabitawani, bi gegha da amameyegu, tagu gerubana anaberana! ");
INSERT INTO aui_vpl VALUES ("JR20_10","025_20_10","JER","20","10","10","Wawaya tupadi sayanuyanuveyegu na yadi sisiya awaiwaiyana. Sawara tupadi sivikenaviviregu na tagu anaghanagharedi. Toudi siwonegu bo, ‘Memeda awaki kunawoneni, na yama babada kanimaghamaghataredi, da aro sinaverem.’ Bi kate bada turaturagu waghata saruruwiitetegu, yadi wiina da awaki tana anaberabero. Na sawona bo, ‘Memeda rubana taniyabeni, da sisiya mududi berodi inisisiya, na tanakabitawani bi kada biwa gwabine tanakabi.’ ");
INSERT INTO aui_vpl VALUES ("JR20_11","025_20_11","JER","20","11","11","Bi gegha da, Yawe God tamna ririguve kwamiimiiri, tam ware wiiyogha tomoyina maragasina naboni, bi iiyawogha sikayotaketowanegu na sinaririgha, da gesinageeiwaiyiguna. Toudi gerubana sinageeiwayigu, na sinimayagha ghamana ikabidi, wawaya gerubana noko sinimayayina sininuwawapina. ");
INSERT INTO aui_vpl VALUES ("JR20_12","025_20_12","JER","20","12","12","O, Yawe God Maragata Kirakiina, wawaya iiyawogha yadi bera rotomanidi mata kamomve, na yadi berabera kwaruruyaghadi, tam yadi noghota da wiina tupadi kwaruruwiitete yapoyaporidi. Na mmko yagu nuwapoyina ima debamve atoretore, bi awiiwiini anakita da kagu aviya aro kunaveredi.” ");
INSERT INTO aui_vpl VALUES ("JR20_13","025_20_13","JER","20","13","13","Kotawora Yawe God biidi da kokabeepepi! Raghanina wawaya beroberodi sageghomiiri bi moyamoyakidi da noganogadi nuwapoya saveredi, na Yawe God nokodi wawaya berodi yadi maragatama yiyawiidi. ");
INSERT INTO aui_vpl VALUES ("JR23_1","025_23_1","JER","23","1","1","Yawe God iwona bo, “Nuwapoya ghamaghamadi sinapiika yagu wawaya kadi babada biiyadi! Toudi ware sip bodaboda berodi naboni, toudi sip sakasiwiiberodi bi saberadi na siveramosaredi kubura bogaebogae.” ");
INSERT INTO aui_vpl VALUES ("JR23_2","025_23_2","JER","23","2","2","Na mmkona Yawe, Isrel kana God yana sisiya nokodi sip bodaboda biiyadi, “Tami yagu sip gekoyakoyagha yaporidina, korukwavina sinagho kubura bogaebogae, na yami bera berona toudi biiyadi kiiravine na aro anaveremi. ");
INSERT INTO aui_vpl VALUES ("JR23_3","025_23_3","JER","23","3","3","Tagu yagu wawaya akasiwiimosaridi kubura bogaebogae samakamake, na anakasiwiitaghomidi, mekodi kata yawayawiidi samakamakena, bi anakabidi sinaveramagha yadi kubura waghate. Bi sinituwa wiipeyara da yadi koroto inaragata. ");
INSERT INTO aui_vpl VALUES ("JR23_4","025_23_4","JER","23","4","4","Tagu sip bodaboda anatupavinegha da sinakoyayidi, bi wawayidi na gesinanaghara maghana, bi getana sininuwapoyana, bi getana inasiwanana.” Mmkona Yawe God gamogu. ");
INSERT INTO aui_vpl VALUES ("JR23_5","025_23_5","JER","23","5","5","Yawe God iwona bo, “Raghani yapiipiikana, tomogha tana anavineyi kiiwawo Deivid yana kayenama, touna mataguve na inamiise kirakii bi noghota miisedima wawaya ininaghovedi bi bera miisedi da rotomanidi inabera mmko kuburine. ");
INSERT INTO aui_vpl VALUES ("JR23_6","025_23_6","JER","23","6","6","Bi mma naboni siniwaghawaghayeni, ‘Yawe God keda rotomanidi kiiravidaye yabera.’ Yana wiibada kamone, na Jiuda damdi na nuwabeye sinamake bi Isrel damdi na nuwaruririye sinamake.” ");
INSERT INTO aui_vpl VALUES ("JR31_7","025_31_7","JER","31","7","7","Yawe God iwona bo, “Isrel kiiravine kotawora da kovinuwamiise, kami dam ghamanakina kiiravine korukwatu! Yami kabepepa ayidi rukwatuma mma naboni kotawora, ‘O Yawe God yam wawaya kiyawiidi, Isrel damdi mekodi patana yawayawiidi samakamakena!’ ");
INSERT INTO aui_vpl VALUES ("JR31_8","025_31_8","JER","31","8","8","Tagu yagu wawaya kikiramutumutuba kwanatudima aniveramayidi, bi kate kwanatu rabarabae tupadi mma kubura debane. Kamodiye na wawaya mata potapotadi da kaye beroberodi, wasiwasike roperopeyidi bi wasiwasike saburaburawa da sinituwa na sinapiika, koroto ghamanakina sinaveramagha! ");
INSERT INTO aui_vpl VALUES ("JR31_9","025_31_9","JER","31","9","9","Nokodi sinapiipiikana ere duududi da kate wiinuwanuwaghaneyana kiiravine sinarurupari bi anitutayitayina kanaveramagha. Tagu rarima riridigha aninagho kedaridi kananagho, bi keda mumumudigha sinapepewa da gerubana sinatamotabirana. Kiiravine tagu na Isrel tamananaki, bi Ifreim na natugu tubugha yainina, noko biidi mmko anabera.” ");
INSERT INTO aui_vpl VALUES ("JR31_31","025_31_31","JER","31","31","31","Yawe God iwona bo, “Raghani yapiipiika, na Tagu wiiwaghasina maragasina wouna Isrel da Jiuda damdi yawata kana bera. ");
INSERT INTO aui_vpl VALUES ("JR31_32","025_31_32","JER","31","32","32","Bi wiiwaghasinina maragasina wouna na noko geware nosinosidinakim yawata kaberana naboni, meme imadi ayouna bi avinagho kedaridi da Ijipt kubura kakanibutavenina. Noko raghanine akoyayidi da ware moghanedi naboni, bi gegha da yagu wiiwaghasina maragasina sivikasigiiyeni. ");
INSERT INTO aui_vpl VALUES ("JR31_33","025_31_33","JER","31","33","33","Bi raghani yapiipiika na tagu wiiwaghasina maragasina wouna Isrel damdi yawata kanabera na mma naboni; Tagu yagu gwara gayamidiye anatore, da nuwanuwadiye anagirumi. Bi tagu na yadi God bi toudi na yagu wawaya. ");
INSERT INTO aui_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Getana iiyabo kwiinana inawonawiiyeveveni da Tagu Yawe God inakoviguna, basuna toudi tupadi na nada sinakowa wiimasimasiyegu, nokona wawaya moyamoyakidi bi inagee inanagho wawaya moumouridi biiyadi. Bi yadi tamumu ananoghotatavedi bi geananoghota mayedina. Tagu, Yawe God gamogu.” ");
INSERT INTO aui_vpl VALUES ("JR33_14","025_33_14","JER","33","14","14","Mmkona Yawe God gamona, “Raghani yapiipiika, na Tagu miisena anabera Jiuda da Isrel damdi biiyadi, metagha avisuwonedina naboni. ");
INSERT INTO aui_vpl VALUES ("JR33_15","025_33_15","JER","33","15","15","Noko raghanine na kiiwawo Deivid yana kayenama tomogha tana anavineyi, touna mataguve na inamiise kirakii, bi bera miisedi da rotomanidi inabera mmko kuburina debane. ");
INSERT INTO aui_vpl VALUES ("JR33_16","025_33_16","JER","33","16","16","Yana wiibada raghanine na Jiuda damdi na sinayawa, bi Jerusalem damdi na nuwaruririye sinamake. Bi kwanatuna sinakwatuveni da ‘Yawe God bera rotomanidi kiiravidaye yabera.’” ");
INSERT INTO aui_vpl VALUES ("JR38_4","025_38_4","JER","38","4","4","Raghani tane, babada ghamaghamadi yadi 4 sinagho kiiwawo biidi bi siwona bo, “Yama kiiwawo, rubana Jerimaiya iyarabobo. Yana sisiye na yada wiiyogha tomotomoyidi, iiyawogha patana mma kwanatuve simiirikuyovedi, na yikumararayidi da kate bada wawaya tupadi mma kwanatu kamonena. Bi touna geyanakayowana da wawaya iniwiitedina, bi gegha, yimatipo da inakasiwiiberodi.” ");
INSERT INTO aui_vpl VALUES ("JR38_5","025_38_5","JER","38","5","5","Wasina bi kiiwawo Zedekaiya iwonabodedi bo, “Waghasina, awaki touna biidi konakayokayoveni na kobera, tagu kate geanigesiyemina.” ");
INSERT INTO aui_vpl VALUES ("JR38_6","025_38_6","JER","38","6","6","Wasina bi Jerimaiya sikabi da kiiwawo natuna kana waghawagha Melkisaiya yana doguve, nokona kiiwawo kanabodaboda yadi bare garina kamone. Na kwaroma saghiri bi siruwiiyoyoyi iyowogha dogu kamone. Bi getana rarima doguna kamone, wasina dobodobo kawagha na Jerimaiya iyori iyowogha dobodobo kamone. ");
INSERT INTO aui_vpl VALUES ("LM1_1","026_1_1","LAM","1","1","1","Naghove, na wawaya korotodi Jerusalem kamone, bi katana noko kwanatuna ikwebu. Roro kubura debane na kwanatu tupadi kamodiye, na touna kwanatu maragasina tana, bi katana tanaduma ware wasike kwabukwaburina naboni. Roro na touna ware kiiwawo wasikena naboni, bi katana touna wiibagubagurana. ");
INSERT INTO aui_vpl VALUES ("LM1_2","026_1_2","LAM","1","2","2","Nubabasuve na yaduu raghani, matadoga mayiyinagha sitototo sayowogha. Kana tomotomogha tupadi subukwari kuyoveni, gerubana siniororogha mayenina. Turaturana sigiyaguveni bi nuwanuwadi sipughu touna biidi da katana toudi na kana aviya. ");
INSERT INTO aui_vpl VALUES ("LM1_3","026_1_3","LAM","1","3","3","Aviya sigeghomiiri da Jiuda damdi siburavidi bi sikabidi sinaghotaveyana, bi situpedi da yadi bagubagurana bi nuwapoya ghamadi debadiye sitoura. Katana toudi dam wiibata yadi kubure samakamake, bi getana gawara meme siyabanani da siyiyawiitaveyanana. Kadi aviya sigeghomiiri da sirukwavinidi bi sikabitawatawanidi, toudi gerubana da kadi aviya gwabidima sinaverataveyanana. ");
INSERT INTO aui_vpl VALUES ("LM1_4","026_1_4","LAM","1","4","4","Keda sanono Zaiyonma na sibubu, kiiravine getana iiyabo gabudara kabikabikuwayidiye namagha iyanono God kabepepina kiiravine. Getana iiyabo kwanatu matamketadigha iyarughurughuna, bi prist ere nuwaberodi sakabikabida. Wasiwasike woudi saduudu, bi kwanatu kana wawaya tupadi kabikwarakwara ghamaghamadi sabanabanana. ");
INSERT INTO aui_vpl VALUES ("LM1_5","026_1_5","LAM","1","5","5","Katana kadi aviya sigeghomiiri da sibadedi, bi sawara tupadi sakayokayovedina gwabidiye. Yawe God igeghomiiri da Jerusalem yana tamumu peyaridi kiiravidiye na aro ivereni. Aviya sigeghomiiri da natunatudi siburavidi bi sikabidi sinagho kubura rabarabae. ");
INSERT INTO aui_vpl VALUES ("LM1_6","026_1_6","LAM","1","6","6","Naghove, Jerusalem na maragasina bi wiinuwakayowanina, bi katana nokodi tupadi sikovi. Kana babada na ware ribiribi kadi waghawagha diya vitonana sirabobo na kam sininoghana naboni. Toudi panapana irouvidi da sinoganoga, gerubana kadi aviya gwabidima sinaverataveyanana. ");
INSERT INTO aui_vpl VALUES ("LM1_7","026_1_7","LAM","1","7","7","Katana Jerusalem damdi kabikwarakwara sabanabanana, da yadi wiikedakeda kubura mududiye, na yadi noghota yaveramagha da naghove sawara miisedi tupadi rapediye na sanoghosidi. Wasina bi aviya sipiika da siburavidi, bi getana iiyabo da iyiwiitedi. Nokodi aviya kwanatuna sikitani, bi raghanina siyibero na simaniveni. ");
INSERT INTO aui_vpl VALUES ("LM3_19","026_3_19","LAM","3","19","19","Raghanina yagu kabikwarakwara, da yagu wiikedakeda kubura rabarabae anoghosidi, na noko damina ware rarima kawaororana naboni. ");
INSERT INTO aui_vpl VALUES ("LM3_20","026_3_20","LAM","3","20","20","Nokodi sawara anoghosidi, na nuwanuwagu yabero kirakii. ");
INSERT INTO aui_vpl VALUES ("LM3_21","026_3_21","LAM","3","21","21","Bi gegha da yagu noghota yaveramagha da Yawe God anoghosi na wiigeruwana adagumayeni. ");
INSERT INTO aui_vpl VALUES ("LM3_22","026_3_22","LAM","3","22","22","Yawe God yana nuwamonika kiiravidaye na getughurinana, bi yana wiinuwaghaneyana gegha iyakovikovina; ");
INSERT INTO aui_vpl VALUES ("LM3_23","026_3_23","LAM","3","23","23","didibara patepatena yanavereyana na yanono wiikarukaru, touna nonowa yaberabera ware metagha ivisuwonana naboni. ");
INSERT INTO aui_vpl VALUES ("LM3_24","026_3_24","LAM","3","24","24","Tagumani awonena mayegu bo, “Yawe God na nonowa gwabiguve, na getana awaki ayakayokayoveni, noko kiiravine tagu anitumaghanena kirakiiyeni.” ");
INSERT INTO aui_vpl VALUES ("LM3_25","026_3_25","LAM","3","25","25","Raghanina wawaya yadi tumagha Yawe God gwabine bi sinoyeni, na touna miisena yabera toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("LM3_26","026_3_26","LAM","3","26","26","Na noko biidi imiise da touda tanikoyakoyagha wiiraborabobo touna kiiravine, basuna touna iniyawiida. ");
INSERT INTO aui_vpl VALUES ("LM3_27","026_3_27","LAM","3","27","27","Imiise bi touda akowa tana kabi da Yawe God tanakabisisireni, raghanina touda patana woudayena. ");
INSERT INTO aui_vpl VALUES ("LM3_28","026_3_28","LAM","3","28","28","Raghanina Yawe God piropiro debadae yatoura, na touda duma tayamakeyowogha tayiraborabobo, ");
INSERT INTO aui_vpl VALUES ("LM3_29","026_3_29","LAM","3","29","29","touda tayituwapore oghogheyana, bi mayiyida siyayowogha dobodobove na, meboda God iyiwiiteda. ");
INSERT INTO aui_vpl VALUES ("LM3_30","026_3_30","LAM","3","30","30","Raghanina wawaya tana nawanawam inarouvi, bo inisisiya berovem, na kiwaghasineni da awaki ibera. ");
INSERT INTO aui_vpl VALUES ("LM3_31","026_3_31","LAM","3","31","31","Kiiravine Yawe God geyana wawaya iyamiimiiri kubutena wagiyedina. ");
INSERT INTO aui_vpl VALUES ("LM3_32","026_3_32","LAM","3","32","32","Raghani mududiye na kabikwarakwara yapiikeni, bi kate bada wiinuwanuwaneyana yidebeni touda biiyadi, basuna yana nuwamonika touda kiiravidaye na getughurinana. ");
INSERT INTO aui_vpl VALUES ("LM3_33","026_3_33","LAM","3","33","33","Wiisuwona, raghani mududiye na sinivisi da nuwapoya yapiikedi wawaya biiyadi, bi gegha, touna geiyinuwamiise da nokodi bera inaberana. ");
INSERT INTO aui_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","Yawe God iwona bo, “Wawaya wota, geghomiiri, Tagu yagu wiina tam teya tanisisiya.” ");
INSERT INTO aui_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","Raghanina iyiisisiya, na God kanumina irughu kamoguve, bi itayina wiigeghomiirigu, bi iiyabo iyiisisiya na ayawaiwaiyaneni. ");
INSERT INTO aui_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","Bi iwona bo, “Tam wawaya wota, tagu adarudarum da kunanagho dam Isrel biiyadi, nokodi wawaya iiyawogha gesiyakabisisireguna, bi patana sisinighiighiiyegu ware nosinosidinakim naghove siberana naboni. ");
INSERT INTO aui_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","Bi nuwanuwadi sikotaki da gesiyakabikarawayeguna, noko kiiravine adarudarum kunanagho toudi biiyadi da Tagu, Yawe God nokodi sawaridi iisisiyedi na kunawonedi. ");
INSERT INTO aui_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","Bi meboda nokodi wawaya wiigeruwiiranidi sinawaiyanem bo gegha, bi meboda gesinawaiyana na toudi wawaya kawakeekeedi, bi gegha da rubana sinakovi da peroveta tana nama toudi gwabidiye.” ");
INSERT INTO aui_vpl VALUES ("EK17_22","027_17_22","EZK","17","22","22","Mmko na metagha Yawe God iwona, “Tagu wosina ragharagha karapumkina anakabi, kii kana waghawagha sida, bi kiina gekirakiina debane Tagu numonumona anakiyapiini da koya gekirakiina debane anawavi. ");
INSERT INTO aui_vpl VALUES ("EK17_23","027_17_23","EZK","17","23","23","Nama noko koyana debane Isrel kubura kamone inagogo inagae patana da sidana inikii kiitowana da waratetena, bi inaruragharagha da inuwagha. Manu kadi kita bogaebogae nama ragharaghane sinakema da rogune sinikiirogu. ");
INSERT INTO aui_vpl VALUES ("EK17_24","027_17_24","EZK","17","24","24","Bi kii tupadi kubura debane sinakovi da Tagu na Yawe God. Kii guridi atarayidi sayowogha bi kii gisigisidi aberadi da sagogo da saguri. Kii matayidi abera da sarabobo, bi kii raborabobodi aberadi da sayawa. Tagu Yawe God avisisiya, Tagu anabera.” ");
INSERT INTO aui_vpl VALUES ("EK33_7","027_33_7","EZK","33","7","7","God iwonegu bo, “Tam wawaya wota, tagu akabigubam da dam Isrel kamone kadi kighukighu tomoyina, na awaki anisisiyeni na kuwaiyana bi yagu wonawiiyoyowa na kikatayidi. ");
INSERT INTO aui_vpl VALUES ("EK33_8","027_33_8","EZK","33","8","8","Raghanina anakararumaghatara da wawaya kawakeekeena inarabobo bi gekunikatayi da yana yawa inawamiri bi inamake, na touna yana tamumu kiiravine inarabobo, bi gegha da tagu aro anaverem basuna tam kubera na irabobo. ");
INSERT INTO aui_vpl VALUES ("EK33_9","027_33_9","EZK","33","9","9","Bi meboda kunikatayi da yana bera iyawamiri bi inasinighii, na touna yana tamumu kiiravine inarobobo, bi tamna yawa kunakabi.” ");
INSERT INTO aui_vpl VALUES ("EK34_11","027_34_11","EZK","34","11","11","Yawe God mma naboni iwona, “Tagumani yagu sip aninoyedi patana da anabananidi. ");
INSERT INTO aui_vpl VALUES ("EK34_12","027_34_12","EZK","34","12","12","Memeda sip sivera siwasiwana, na kadi bodaboda wawayina ininoyedi, noko naboni tagu yagu sip anininoyedi. Uuwa wiididibaridiye raghanine na sip sivera siwasiwana, bi gegha da meghamegha sivimosaredi kubura tupane, na tagu anabananidi da aniyawiidi. ");
INSERT INTO aui_vpl VALUES ("EK34_15","027_34_15","EZK","34","15","15","Tagu, Yawe God yagu sip kam anaveredi bi anabera da gawara tane anatoredi meme nuwaruririye sinakena yowogha siniyawiitaveyana. ");
INSERT INTO aui_vpl VALUES ("EK34_16","027_34_16","EZK","34","16","16","Tagu verasiwasiwanidi aninoyedi, bi mekodi verawapawapadi anakabidi sinaveramagha magha. Bi nokodi sidasidabidi na anabunamidi bi gubagubagidi na maragata anaveredi. Bi nokodi iiyawogha gwarugwarudi bi maragasidi, na anikasunughana. Basuna tagu na sip bodaboda iiyabo awaki beradi rotomanidi na anabera, na aro meko sakayokayoveni na tounama anikanidi. ");
INSERT INTO aui_vpl VALUES ("EK34_17","027_34_17","EZK","34","17","17","Bi tami yagu sip kiiravine, na Tagu, Yawe God mma naboni awonewonemi, ‘Ware sip bodaboda naboni da sip inibogaedi sip turadima, bi sip makidi na gout makidi gwabidima, Tagu anibogabogaemi, wawaya miisedi kadiboga bi berodi kadiboga.’” ");
INSERT INTO aui_vpl VALUES ("EK36_16","027_36_16","EZK","36","16","16","Wasina bi Yawe God ivisisiya magha tagu biidi iwona bo, ");
INSERT INTO aui_vpl VALUES ("EK36_17","027_36_17","EZK","36","17","17","“Tam wawaya wota, raghanina Isrel damdi yadi kubura waghate siyamakamake, na yadi keda na berodi da yadi bera beroberodima kuburina sibera da idadabu, bi tagu biidi nokodi keda na ware wasike kubuwiipum yakabina dadabuna naboni. ");
INSERT INTO aui_vpl VALUES ("EK36_18","027_36_18","EZK","36","18","18","Toudi mmko kuburina sibera da idadabu basuna wawaya sivikasunughana da tarabiibiisaka siyapeepetedi, noko kiiravine yagu nuwapughu ghamana debadiye atore. ");
INSERT INTO aui_vpl VALUES ("EK36_19","027_36_19","EZK","36","19","19","Tagu yadi keda da yadi bera beroberodi kiiravine na aro averedi, abera da akasiwiimosaridi bi sinagho kubura wiibate da wawayidi yawata simakae. ");
INSERT INTO aui_vpl VALUES ("EK36_20","027_36_20","EZK","36","20","20","Bi raghanina sinagho nokodi kubura wiibate, na kagu waghawagha kabikabikuwayina sikasiwiibero, basuna wawaya nokodi kuburidiye siwona bo, ‘Mmkodi na Yawe God yana wawaya, bi gegha da yadi kubura waghata sikuyoveni sinaghotaveyana.’ ");
INSERT INTO aui_vpl VALUES ("EK36_21","027_36_21","EZK","36","21","21","Tagu akayoveni da wawaya kagu waghawagha kabikabikuwayina siyakabikarawayeni bi gegha, nokodi kubura nunudigha Isrel damdi sinagho na sinimayagha sipiikeni debaguve. ");
INSERT INTO aui_vpl VALUES ("EK36_22","027_36_22","EZK","36","22","22","Noko biidi, Isrel damdi kuwonedi da Tagu, Yawe God kadi wara na gwabiguve da: Awaki anabera na getami Isrel dammi kiiravimiyena, bi gegha da mmkona tagu kagu waghawagha kabikabikuwayina kiiravine, nokodi kubura tupadiye meme koyamakamake na koviberonina. ");
INSERT INTO aui_vpl VALUES ("EK36_23","027_36_23","EZK","36","23","23","Bi aniyeveveyana da kagu waghawagha maragasina na kabikabikuwayina, waghawaghana meko dam wiibata kamodiye kokasiwiiberona, bi tami Isrel dammiye na nokodi kubura bogaebogae aniyevevedi da kabikabikuwayigu, bi raghanina mmko anabera, na nokodi wawaya sinakovi da, Tagu na Yawe. Tagu, Yawe God avisisiya. ");
INSERT INTO aui_vpl VALUES ("EK36_24","027_36_24","EZK","36","24","24","Bi wawaya wiibata kamodima da kubura wiibata kamodima anakabikanibuvemi bi anituwiitaghomimi da aniveramayimi yami kubura waghate. ");
INSERT INTO aui_vpl VALUES ("EK36_25","027_36_25","EZK","36","25","25","Wasina bi rarima miirarina debamiye anakawariwayi, da konamiise magha, tagu yami berona anakoghataveni bi gemuriye tarabiibiisaka konapepetedina. ");
INSERT INTO aui_vpl VALUES ("EK36_26","027_36_26","EZK","36","26","26","Bi nuwanuwa woudi anaveremi bi kate kanuma woudi kamomiye anatoura. Tami nuwanuwami sikotakii ware akima naboni, na anakabitavetaveyana bi wasadi na nuwanuwa mekodi tagu sinakabisisiregu na toudi anaveremi. ");
INSERT INTO aui_vpl VALUES ("EK36_27","027_36_27","EZK","36","27","27","Tagu kanumigu kamomiye anatoura na yagu wonawiiyoyowana konakabikarawayedi bi kwakowa wiimasi da yagu gwara konakabisisirena yapoyaporidi.” ");
INSERT INTO aui_vpl VALUES ("EK37_1","027_37_1","EZK","37","1","1","Yawe God yana maragata iyowogha debaguve, na Kanumina ikabigu da anagha tane itoregu meme dobodobo na wawaya irikedi ibonuvi. ");
INSERT INTO aui_vpl VALUES ("EK37_2","027_37_2","EZK","37","2","2","Bi ivinagho kedarigu da anayina tupana kapepewa wiikenavivireni irike kamodigha, bi akita da irikedi sipeyara kirakii bi parapa kanakanadi. ");
INSERT INTO aui_vpl VALUES ("EK37_3","027_37_3","EZK","37","3","3","Bi ivitarakiiyanegu bo, “Wawaya wota, da kwanoghonoghosi mmkodi irike sinawamiridi da siniwawaya magha?” Bi awona bo, “Yawe God, tam kawagha noko kwakovi.” ");
INSERT INTO aui_vpl VALUES ("EK37_4","027_37_4","EZK","37","4","4","Na iwona bo, “Mmkodi irikedi biiyadi wonagu kisisiyeni kuwona bo, ‘Tami irike kanakanami, Yawe God wonana kowaiyana! ");
INSERT INTO aui_vpl VALUES ("EK37_5","027_37_5","EZK","37","5","5","Yawe God Maragata Kirakiina yawonewonemi bo: Kowaiyana! Anabera da yawiimi konatavenamagha da konayawa. ");
INSERT INTO aui_vpl VALUES ("EK37_6","027_37_6","EZK","37","6","6","Bi kwaro anikarapasipasi bi vigho anaveremi, bi bekama anageremi. Bi yawii anaveremi na konayawa magha, wasina bi tami konakovi da Tagu na Yawe God.’” ");
INSERT INTO aui_vpl VALUES ("EK37_7","027_37_7","EZK","37","7","7","Noko warana iveregu na irike awonedi. Bi patana ayiisisiya na wiiteriteri awaiyaneni, bi ayakita da irike tatadigegha siyapiipiika siyitupetupena mayedi. ");
INSERT INTO aui_vpl VALUES ("EK37_8","027_37_8","EZK","37","8","8","Bi ayaruruwiitetedi, na kwaro da vigho sirumaghatara irike debadiye, wasina bi beka tubuyidi igeremumu, bi yawiidi gesiyatavetaveyana. ");
INSERT INTO aui_vpl VALUES ("EK37_9","027_37_9","EZK","37","9","9","Wasina bi Yawe God iwonegu bo, “Tam wawaya wota, wonagu kisisiyeni yanunu biidi, kuwona bo, ‘Yawe God Maragata Kirakiina yawonawona bo: Yanunu keda tupadima piika, da kouvenatataba kunarughu mmkodi tubugha raborabobodi biiyadi da sinayawa magha.’” ");
INSERT INTO aui_vpl VALUES ("EK37_10","027_37_10","EZK","37","10","10","Noko warana iwonegu na avisisiya, wasina bi yawii ipiika da nokodi tubugha kamodiye irughu, na tupadi sipapara magha da sigeghomiiri. Toudi sikoroto kirakii rubana da wiiyogha tomotomogha ribana tana siyitubuyi. ");
INSERT INTO aui_vpl VALUES ("EK37_11","027_37_11","EZK","37","11","11","Wasina bi Yawe God iwonegu bo, “Tam wawaya wota, Isrel damdi na ware mmkodi irike naboni. Sawonawona bo, ‘Toumii kiivivi, getana iiyabo iniyawiimiina, tumagha tupana ikovi.’ ");
INSERT INTO aui_vpl VALUES ("EK37_12","027_37_12","EZK","37","12","12","Noko kiiravine, kuwonakasiyaragha yagu wawaya Isrel damdi biiyadi bi kuwonedi da mmkona metagha Yawe God iwona, ‘Kami karawaga anakabitavetaveyana da anikanibuvemi bi anakabimi konaveramagha Isrel kubure. ");
INSERT INTO aui_vpl VALUES ("EK37_13","027_37_13","EZK","37","13","13","Raghanina karawaga meme yagu wawaya sidogudi bi anakabitavetaveyana bi anikanibuvedi, na tami konakovi da Tagu, Yawe God. ");
INSERT INTO aui_vpl VALUES ("EK37_14","027_37_14","EZK","37","14","14","Bi kanumigu kamomiye anatore, da konayawamagha bi anakabidi konaveramagha yami kubura waghate. Raghanina mmko inatubughana, tami konakovi da Tagu, Yawe God. Avisuwona da mmko anabera. Tagu, Yawe God avisisiya, na anaberani!’” ");
INSERT INTO aui_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Yagu wiiguba kitakita nubabasu kamone, na awaki akita da ware wawaya wota iyapiipiika, touna uuwa sigwagwara wiikenavivireni, bi sikabi siyanono Iiyabo Makewaghawaghasina biidi. ");
INSERT INTO aui_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Noko Iiyabo Makewaghawaghasina igeghomiiri da wiibada, bi kabikarawagha da maragata ivereni da iyibada, bi wawaya kubura tupane, mayiyi bogaebogae, da gamo bogaebogae tupadi touna siyabagibagiyeni. Yana maragata na inamakewaghata, bi yana wiibadana gegha siniberona. ");
INSERT INTO aui_vpl VALUES ("DN12_1","028_12_1","DAN","12","1","1","Wasina bi aneya iwonegu bo, “Muriye nokodi raghanidiye na aneya maragata kirakiina kana waghawagha Maikel, iiyabo yam wawaya Isrel damdi yabaabaredi na inarumaghatara. Wasina bi nama noko raghanine na nuwapoya da sinivisi ghamanakidi, geware nuwapoya mududi naboni, nokona raghanina kami dam itubughana gabudarine bi patana da kata. Bi noko raghanine, tami wawaya tupami iiyawogha kami waghawagha God yana buka kamone na yawa konakabi. ");
INSERT INTO aui_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","Wawaya korotodi iiyawogha nada sirabobo bi karawage sidogudi na sinayawamagha, mududi na yawa makewaghawaghasina sininuwamiiseyeni, bi mududi na sinimayagha da kitakayobara makewaghawaghasina sinakabi. ");
INSERT INTO aui_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","Bi wawaya nuwanuwagiuridi, nokodi iiyawogha sageghomiiri da wawaya mududi siyevevedi da metagha God matane sinarotomana na toudi damdi na kiniwa makewaghawaghasina sinakabi, bi kadikita na mata konakonana ware gabudara, abama yagigiri na raghanine naboni bo ware kewokewo nubabasuve.” ");
INSERT INTO aui_vpl VALUES ("HS11_1","029_11_1","HOS","11","1","1","Yawe God iwona bo, “Raghanina dam Isrel gisine, ware simira naboni na avinuwayuyuneni, bi Ijipt kuburama akwatu kanibuveni naboni natugu tomoyina. ");
INSERT INTO aui_vpl VALUES ("HS11_2","029_11_2","HOS","11","2","2","Tagu dam Isrel biidi ayakwatukwatuvena kamokamoyidi, bi gegha da simiiri kubutena wagiwagiyegu. Yagu wawaya na god wiiwiiyaba Baal siyasuwasuwareni, bi yadi kabepepama sikoko siyagabugabuna tarabiibiisaka biiyadi.” ");
INSERT INTO aui_vpl VALUES ("AM8_4","031_8_4","AMO","8","4","4","Tami iiyawogha wawaya wiikanighughuvidi kwiitutugudadi bi kwiimatipo da wawaya moyamoyakidi yami kubura kamone konakasiwiiberodi, na mmko kowaiyaneni. ");
INSERT INTO aui_vpl VALUES ("AM8_5","031_8_5","AMO","8","5","5","Tami kokayokayoveni da wiiyawiitaveyana gabudarina da gabudara kabikabikuwayidi porayidi sinakovi yaiyainagha da kam konigimona magha da gimogimona damdi koniyabedi. Bi gewiisuwone kam miisanidi kogeeyana wapawapa, kam kokabiyawa wapawapa, bi yadi vita koruba wapawapa da gimogimona damdi kwiiyabedi. ");
INSERT INTO aui_vpl VALUES ("AM8_6","031_8_6","AMO","8","6","6","Tami kam bowadi da miisedi kowamira bi kwiigimona. Bi wawaya moyamoyakina iiyabo kana pagiri geinasarobina kobera da yami bagubagurana, bagune sawarina miisanina gisina, ware mane pinimaruruna tana bo kaye tourababara miisanina naboni. ");
INSERT INTO aui_vpl VALUES ("AM8_7","031_8_7","AMO","8","7","7","Yawe God wiisuwona maragasina ibera touna wosina kana waghawaghae, noko waghawaghana meko Isrel damdi sakabikabikarawayeni, na iwona bo, “Tagu gemeyani nokodi bera beroberodi kobera na aninuwawapidina.” ");
INSERT INTO aui_vpl VALUES ("AM8_10","031_8_10","AMO","8","10","10","Tagu kabikwarakwara ghamana anaveremi na yami poragha sinakovi, wasadi na konaduudu, yami nuwamiise taworidi konakabitoura bi konasiyasiyapa. Bi dogudogu garadi konikote da yami wiinuwabero matakirina kiiravine na gayamimi konamura. Anaberam da kunadou ware natunuwam iyarabobona naboni. Noko duuduna patana inanono da damone na wiisuwona nuwapoya kiitowana. ");
INSERT INTO aui_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Yawe God yana sisiya iwonataveni Amitai natuna Jona biidi. ");
INSERT INTO aui_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Iwona bo, “Kabununagha bi kunanagho kwanatu ghamana kana waghawagha Ninivema. Bi kuwonedi da tagu aro anaveredi kiiravine yadi bera beroberodi na akovina akabi.” ");
INSERT INTO aui_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Bi gegha da Jona yana sawara ikabununagha yaiyainagha bi keda nawana ikabi da ware Yawe God gwabinama iyanaghotaveyana. Da iyowogha inagho kikire Jopa kwanatune, meme waga tana ibanani itouya kubura kana waghawagha Tasisma. Yana waga ivimiisaneni bi igeru, touna ikayoveni da Yawe God gwabinama iyaverawiikowogha wagagha iyanagho Tasis kwanatune. ");
INSERT INTO aui_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Bi gegha da Yawe God ibera na yanunu maragasina yegii maghatare iyatapitapi da bogibogi ghamana igae na wagana pinimina bi iyagawowora wiitavetaveni. ");
INSERT INTO aui_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Na waga bagibagi damdi sinaghara kirakii da tatadigegha wiiwiita kiiravine yadi god biidi sirukwatu. Wasina bi sawara waga kamone sidagu siyitavena yowoyowoghana yegiiye da waga siyitekani bi iyarutenami. Bi Jona, noko raghanine na iyowogha katamana waga kamone da ikenayakuka nuwanuwana iwapewapeni. ");
INSERT INTO aui_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Wasina bi yabiyabi tomoyina iyowogha Jona biidi bi iwoneni bo, “Awaki kiiravine tam kwakenakena? Geghomiiri bi yam god biidi kunarupari. Augunai da touna inawaiyanem na iniwiiteda, da getana rabobona.” ");
INSERT INTO aui_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Wasina bi waga bagibagi damdi sivisisiya kabivivirana siwona bo, “Kokayo akimama wiirekwa tana bera bi akovina tanakabi da iiyabo mmko berana berokirakiina wawuna inakabi.” Na toudi wiirekwina sibera na iviyeveveyana da wawayina na Jona. ");
INSERT INTO aui_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Na siwoneni bo, “Tam kuwonemii! Iiyabo mmko wawuna inakawari? Yam bagibagi awaki mma? Mema kupiika? Yam kubura meme? Bi kam dam awaki?” ");
INSERT INTO aui_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Wasina bi Jona iwona bo, “Tagu na Hibru wawaya, bi Yawe God akabekabepepi, God abame makamakena, iiyabo yegii da tanawa kanakanana iberana.” ");
INSERT INTO aui_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Bi gegha da Jona raghani katamane waga bagibagi damdi iwonedi da touna iyimatipo da Yawe God gwabinama iyaverataveyana, na raghanina yana wonabodeyana siwaiyaneni na toudi sinaghara kirakii, na siwoneni bo, “Tam parapa bera berokirakiina kubera!” ");
INSERT INTO aui_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Bi yanununa patana iyiimaragata kamokamogha na waga bagibagi damdi sivitarakiiyaneni bo, “Awaki kana bera tam biidi da mmko bogibogina kana kawarawiidouvi?” ");
INSERT INTO aui_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Na Jona iwona bo, “Akovi da noko tagu yagu kerere na mmko bogibogina berona yarurouvimi, na kokabigu bi yegiiye kovitavenayowoyegu, na ininighorovi.” ");
INSERT INTO aui_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Bi waga bagibagi damdi geyadi kayowana da Jona yegiiye siyitavenayowoyeni, na siwoye wiimaragata da wagana siyakabi siyaveramagha kayetanave, bi gerubana siyaberana basuna yanununa patana iyiimaragata kamokamogha. ");
INSERT INTO aui_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Na sirukwatu Yawe God biidi siwona bo, “O Yawe God, kiibabiim gekunaberamii da mmko tomoyina kiiravine kana rabobona. Gekuniwawumii da mmko tomoyina miisena kaya kasukasunuyina. Yam basuna miisena kiiravine na mmko bogibogina kudaru touna debane.” ");
INSERT INTO aui_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Wasina bi waga bagibagi damdi sivisisiya ikovi, na Jona sikabi da yegiiye sivitavenayowoyeni, na yaininagha yanununa iviraborabobo! ");
INSERT INTO aui_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Raghanina waga bagibagi damdi mmko sikita, na Yawe God sinagharena kirakiiyeni, noko kiiravine suwara sigabuna God biidi bi kate wiisuwona sibera touna biidi. ");
INSERT INTO aui_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Bi gegha da Yawe God yana sisiya bagibagine na ighana ghamana ipiika, bi raghanina Jona yegiiye siyiitavenayowoyeni na ivitonani, da gabudara aroba bi nubabasu aroba na noko ighanina kamokamone imakae. ");
INSERT INTO aui_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Raghanina Jona patana noko ighanina kamone na Yawe yana God biidi irupari. ");
INSERT INTO aui_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Iwona bo, “O Yawe God, yagu nuwabero ghamana kamone bi tam biidi arukwatu, na kuwonabodegu. Bi wawaya raborabobodi yadi kubura kamonakinama wiiwiita kiiravine adou na tam kuwaiyanegu. ");
INSERT INTO aui_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Tam boga dumadumaye kuvitavenayowoyegu, da ayowogha anagho dibune, meme yegii yana maragata tupana ivikenaviviregu, bi yam yabarata ghamanakidi tupadi na debaguve siyatamotamo gawowora. ");
INSERT INTO aui_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Tagu anoghosi da ware gwabimma kudarutavegu, bi gegha, akovi da kate yam Bare Kabikabikuwayina anakitamayeni. ");
INSERT INTO aui_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Bi yegii isowomumugu da gerubana yawiigu ayatavenina, bi boga dumaduma ivikenaviviregu, da watawata gayamigu siviruvivireni. ");
INSERT INTO aui_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Tagu ayori ayowogha koya kaye parapine. Bi noko kuburine avibiwa kabikabi wawayina, noko gawarine na matamketa gudu makewaghawaghasina. Bi gegha da tam, Yawe yagu God kuviyawiigu, da noko doguna wautapunama yawayawiigu bi kukabiwiiveramayigu. ");
INSERT INTO aui_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Bi raghanina ayaparoparoro, na Yawe God anoghosim, da arupari tam biidi, bi yam Bare Kabikabikuwayine kuwaiyanegu. ");
INSERT INTO aui_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Nokodi iiyawogha god wiiwiiyaba sapeepetedi, na yam nuwamonika simiiri kubuteni. ");
INSERT INTO aui_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Bi kiiraviguve, na tam anakabepepim; tagu na tam anasuwarim, bi avisuwona da nokodi sawara ayabera tam biidi na anabera. Yawe God, tam kawagha kuviyawiigu.” ");
INSERT INTO aui_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Raghanina gabudara viya sikovi, na Yawe God yana sisiya bagibagine na ighana, Jona kikire tepaye iguruwiitaveni. ");
INSERT INTO aui_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Wasina bi Yawe God yana sisiya idaru mayeni Jona biidi. ");
INSERT INTO aui_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Iwona bo, “Kabununagha bi kunagho kwanatu ghamana kana waghawagha Ninive, da name nokodi wawaya mmko sisiyina averem na kunawonedi.” ");
INSERT INTO aui_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Na Jona, Yawe God yana sisiya ikabisisireni, da ikabununagha bi inagho Ninive kwanatune. Kwanatuna na iragata kirakii, bi wawaya tana memeda iyapepewa rughuwoneni, na gabudara aroba bi iyikovi. ");
INSERT INTO aui_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Wasina bi Jona irughu kwanatune da gabudara tanagha iyapeepewa pom na wawaya biiyadi iyadimadima bo, “Raghanina gabudara 40 sinakovi muridiye, na Ninive sinibero.” ");
INSERT INTO aui_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Wasina bi Ninive damdi God yana sisiya sivitumaghaneni, nokodi damdi na: wawaya kiikiiwawodi bi iyowogha inagho wawaya wota tupadi, sivinuwanoghonoghota da kam siyiiya, bi gara imimona siberana siviyagha, nokona iyiyeveveyana da toudi yadi bera beroberodima simiiri karona. ");
INSERT INTO aui_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Raghanina Ninive kana kiiwawo warana iwaiyaneni, na yana kiiwawo abamakamakenama igeghomiiri da yana wiibadana garadi ikabitavetaveyana, bi wasadina gara imimonama sibera na iviyagha, bi yapukare ribana imakeyarayi, noko iyiyeveveyana da touna ivinuwapoya. ");
INSERT INTO aui_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Wasina bi sisiya bagibagina iwonataveni Ninive damdi tupadi biiyadi iwona bo, “Mmko sisiyina na tagu yami kiiwawo da yagu babada gwabimiima. Tami tupami, bi yami ribiribi ghamaghamadi da gisigisidi yawata geawaki konakam bo konaniunana. ");
INSERT INTO aui_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Wawaya tupami da ribiribi tupadi, na gara imimodi siberana toudima sinikasibabara. Bi wawaya tupadi nuwanuwadi toradima God biidi sinarupari bi tupadi yadi bera beroberodi sinamiiri kubutedi da bera kayotirana beradi sinakabitoura. ");
INSERT INTO aui_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Getayakovina, augunai da God noghota inawamiri na yana nuwapughu ghamana inakabitore na getana rabobona.” ");
INSERT INTO aui_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Wasina bi raghanina God nokodi sawara sibera ikitadi bi yadi keda beroberodima simiiri wamira, na yana noghota iwamiri da geiyiberodina ware iwonana naboni. ");
INSERT INTO aui_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Bi Jona ivinuwapoya kirakii da God nokodi wawaya geiyiberodi na nuwanuwana ipughu. ");
INSERT INTO aui_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Na irupari bo, “O Yawe God, raghanina tagu patana yagu kubura kamone, na awona da mmko iyatubugha, noko kiiravine tagu akabununagha bi avera ayanono Tasis kwanatune. Tagu akovi da tam na kayowiiyayeyana da wiinuwaghaneyana kana God, genuwanuwam iyapughupughu yaininagha bi yam nuwamonika na makewaghawaghasina, bi gegha da yam noghota kuwamiri da wawaya gekuyakasiwiiberodina. ");
INSERT INTO aui_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Na noko kiiravine geyagu wiina da anamakena. Yawe God imiise kirakii da tagu ayarabobo, na yagu yawa kabitaveni.” ");
INSERT INTO aui_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Bi gegha da Yawe God iwonabodeyana bo, “Gegha iyamiise da mmko berana kiiravine nuwanuwam iyapughuna.” ");
INSERT INTO aui_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Wasina bi Jona noko kwanatune raghani matana yana nawae ikanibutaveni inagho da yobe ibera bi rogune imakeyowogha, da iyikoyakoyagha bi iyakita da awaki iyatubugha Ninive kwanatuna biidi. ");
INSERT INTO aui_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Wasina bi Yawe God ibera da kii gisina nama igogo, bi igogo igae da iruragharagha na Jona sirogutawani da gabudara gwabinama kiirogu ivereni. Mmko ibera na Jona sinina isisira, bi ivinuwamiise kirakii basuna noko kiina kiiravine. ");
INSERT INTO aui_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Bi gegha, raghani ibori na God gamone na puwari kiina sunagha rughuwoneni na yivivi. ");
INSERT INTO aui_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Raghanina gabudara igae, na God ibera da yanunu muyamuyana raghani matanama ivera na gabudara Jona gayamina irarayi da pinimina bi iyaparoro. Touna yana kayowana da iyarabobo na iwona bo, “Geyagukayowana da anamakena, iyamiise kirakii da ayarabobo.” ");
INSERT INTO aui_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Wasina bi God, Jona iwoneni bo, “Gegha iyamiise da tam mmko kiina kiiravine parapa nuwanuwam inapughuna.” Na Jona iwona bo, “Bada, tagu nuwanuwagu ipughu kirakii noko kiiravine akayokayoveni da anarabobo!” ");
INSERT INTO aui_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Bi gegha, Yawe God iwona bo, “Mmko kiina nubabasu tanagha kamone igogo bi raghani ibori na bada irabobo, tam gekuyakoyayi bo gekuyabera da iyagogo, bi gegha da irabobona kwiinuwapoyeni. ");
INSERT INTO aui_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Bi kwanatu ghamana Ninive noghosina, na noko imiise tagu parapa iinuwanuwaghaneni basuna nama na wawaya yadi koroto naboni 120,000 bi nabo, toudi iiyawogha na gesiyakovi da bera miisedi mebo bi bera berodi mebo, bi kate ribiribi peyaridi nama kamone samakamake!” ");
INSERT INTO aui_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Tami Jerusalem dammi, yami wiiyogha tomotomogha kokwatu wiitaghomidi. Kada aviya sigawgwara wiikenavivireda sikoyakoyagha da sinagogona. Toudi kiima Isrel kana wiibadana nawanawana sinarouvi. ");
INSERT INTO aui_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Yawe God iwona bo, “Betlihem Iparata, tam Jiuda kamone na kwanatu gisigisi kawagha, bi gegha da tam gwabimma na wawaya tana inapiika da kiiraviguve Isrel inibadeni, iiyabo na yana kayena inaveramagha inanagho raghani katamanidiye.” ");
INSERT INTO aui_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Noko kiiravine Yawe God, Isrel inakabidi da kadi aviya imadebadiye inatoredi, bi patana inanaghonagho da raghanina wasike yiburaburawa bi inituwa na gabudarine. Wasina bi wiibadana yana wawaya sivibaretaya na sinaveramagha magha da Isrel turaturadi yawata sinikapu mayedi. ");
INSERT INTO aui_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Bi raghanina Badana inapiikana, Yawe God yana maragatama yana wawaya inabodadi ware sip bodaboda yana sip yakoyakoyayidina naboni, yana God, Yawe wiibadana ivereni na touna inabera. Yana wawaya kadi aviya gwabidima sinamake nuwabeya, basuna wawaya tupadi kubura debane na sinakabikarawayena kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("ZC9_9","039_9_9","ZEC","9","9","9","Yawe God iwona bo, “Tami Zaiyon dammi parapa kovi nuwamiise, bi Jerusalem dammi korukwatu gwaru. Kokita, yami kiiwawo yapiipiika tami biiyadi. Yana keda na rotomanidi, bi sawara tupadi igeeiwaiyidi, touna wawaya wawumina bi donki debane inageru bi inapiipiika. Bi donki wotuna debane inageru, nokona donki yagarina natuna. ");
INSERT INTO aui_vpl VALUES ("ZC9_10","039_9_10","ZEC","9","10","10","Tagu, Isrel kamone seriyot da kate Jerusalem kamone hosi, mekodi wiirouwa kamone sigerugeru na anakabitavetaveyana. Bi wiirouwa sawaridi tupadi aniberodi, yami kiiwawo nuwaruriri inapiikeni dam tupadi biiyadi. Yana wiibadana yegii nawane inadaguni da inanagho yegii nawane, bi kate Iparate rarimine da inanagho kubura tupana damone.” ");
INSERT INTO aui_vpl VALUES ("ZC12_10","039_12_10","ZEC","12","10","10","Yawe God iwona bo, “Nokodi wawaya iiyawogha na Deivid nosinosina da kate wawaya Jerusalem kamone samakamake, na anaberadi da sininuwanuwaghaneyana bi kate rupari nuwasisirina anaveredi. Bi sinakitarorona da sinakitagu, iiyabo sigwari da irabobona, bi kiiravine sinaduu ware nokodi iiyawogha natudi nuwanuwadi iyarabobo da siyaduuduvenina naboni. Bi sinaduu siyapa ware nokodi iiyawogha natudi tubugha yainina iyarabobona naboni. ");
INSERT INTO aui_vpl VALUES ("ZC12_11","039_12_11","ZEC","12","11","11","Noko gabudarine na nuwavisi da duudu Jerusalem kamone na inaragata kirakii, ware Megido anayine raghanina Hadad-Rimon kiiravine siyaduudu na naboni.” ");
INSERT INTO aui_vpl VALUES ("ZC13_1","039_13_1","ZEC","13","1","1","Yawe God Maragata Kirakiina iwona bo, “Raghanina noko gabudarina inapiika na name na wusira rarimina veraverana inatubugha meko Deivid nosinosina da kate Jerusalem damdi inakoghadi, bi yadi tamumu da yadi berona inakoghatavedi.” ");
INSERT INTO aui_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Keriso, God natuna, warana miisena mma naboni yadagudaguni. ");
INSERT INTO aui_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Naghove waghata peroveta Aisaiya yana buka kamone igiruma da God ivisisiya iwona bo, “Kowaiyana! Yagu sawariyonayona anawonataveni naghomiye ininagho da touna yami keda inagigiri. ");
INSERT INTO aui_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wawaya mayabe yakwatukwatu yawonawona bo, ‘Tami Bada kiiravine kokabunagha, bi yana keda kovirotomani da inapepewa.’” ");
INSERT INTO aui_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Wasina bi Jon ipiika, mayabe wawaya iyabaabataitodi bi God warana iyadimedimeni iyawonewonedi bo, “Yami bera beroberodi kokabitoura bi konatubuwamira da God yami tamumu inanoghotatavedi, bi konababataito na inimatakira da yami beronama kotubuwamira.” ");
INSERT INTO aui_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wawaya Jiudiya da Jerusalem kamodima sikanibu Jon siyawaiyaneni. Yadi bera beroberodi siyimaghamaghatara bi Jon iyabaabataitodi Jodan rarimine. ");
INSERT INTO aui_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kana kwama na, ribiribi kana waghawagha kamel ghunighuninama ibera bi iyakotekoteni, bi kana kiide na ribiribi bekanama ibera bi borine iviruvivireni. Bi nonowa kana kam na ghuro da manigewa. ");
INSERT INTO aui_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wasina, Jon nonowa iyisisiya bo, “Yagu maragata igisi. Wawaya muriguve yapiipiika na, touna yana maragata iragata kirakii. Tagu gegha kiimatanigu da anawasikuwaya bi kayena kana tourababara uravidi ayarupama. ");
INSERT INTO aui_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tagu rarimama abaabataitomi bi touna Kanuma Kabikabikuwayinama inababataitomi.” ");
INSERT INTO aui_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Noko raghanine Yesu Galili kubure Nasaret meyagiina ikuyoveni ipiika Jon biidi, bi Jon Jodan rarimine Yesu ibabataitoni. ");
INSERT INTO aui_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bi Yesu rarimama iyageegeena, ikitada abama itamotatara bi Kanuma Kabikabikuwayina, ayabo mayimayiyina iyayoyo touna biidi. ");
INSERT INTO aui_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bi God gamona abame iwona bo, “Tam na tagu natugu, iinuwayuyunem, bi tamve iinuwamiise.” ");
INSERT INTO aui_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yaininagha Kanuma Kabikabikuwayina Yesu ivipora ikanibu mayabe. ");
INSERT INTO aui_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Bi gabudara 40 Yesu mayabe iyamakamake na Seitan iyaruruyaghani da ware iyibekuni. Bi touna ribiribi dipa yawata siyamakamake, bi God yana aneyaneya sikoyayi. ");
INSERT INTO aui_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Herod, Jon irubiuveni murine na, Yesu inagho Galili kubure God Warana Miisena iyadimedimeni wawaya biiyadi. ");
INSERT INTO aui_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nonowa iyisisiya bo, “God yana raghani nada ipiika! God yawa woune yana wawaya inibadedi na inoratu. Yami bera beroberodima kotubuwamira bi Warana Miisena konigeruveni.” ");
INSERT INTO aui_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Bi raghani tana Galili sawana ririnagha ipepewa iyanono, da wanowanota wawayidi yadi bata ikitadi, Saimon da tiinaru Andru teya, sawae sewari siyitavenayowoyeni. ");
INSERT INTO aui_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na iwonedi bo, “Kopiika, kokivinigu. Bi aniyevevemi da wawaya konakonadi da tagu sinigeruvegu, metagha ighana sewarima kokonakonadi na naboni.” ");
INSERT INTO aui_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wasina bi, yaininagha yadi sewari sikuyowana bi sikivini. ");
INSERT INTO aui_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bi kikiragha sinagho gerabarabana bi Zebedi natunatuna, Jemes da Jon yadi waga kamone sewari siyataratara bodaboda na ikitadi. ");
INSERT INTO aui_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bi yaininagha ikwatuvedi, “Kokivinigu.” Wasina bi, tamadinaki da yana bagibagi damdi waga kamone sikuyovedi bi Yesu sikivini. ");
INSERT INTO aui_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wasina, Yesu kana kivikivina teya Kaponiyam kwanatune siverakanibu, bi wiiyawiitaveyana gabudarine na irughu kabepepa barene God warana wiiyeveveyana idaguni. ");
INSERT INTO aui_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wawaya yana wiiyeveveyana sivisokoveni, basuna touna iyiyevevedi na ere maragasina, gegha gwara wiiyeveveyana damdi naboni. ");
INSERT INTO aui_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wasina, bi kabepepa barena kamone iyiyeveveyana, na tomogha kanuma berona itowatawani na irukwatu ");
INSERT INTO aui_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","iyawonawona bo, “Awaki toumii biidi kunabera, Yesu, Nasaret tomogha? Bo kupiika toumii kunakasiwiiberomii? Akovi da tam iiyabo, tam na God yana Wiivinevinegha Kabikabikuwayina tana.” ");
INSERT INTO aui_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bi Yesu iwonatagureni, iwona bo, “Kuviraborabobo, tomogha kuyoveni!” ");
INSERT INTO aui_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wasina, kanuma berona tomogha inuke kirakiiyeni, bi irakapara da ghamana bi ivikanibutaveni. ");
INSERT INTO aui_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bi wawaya tupadi sivisokovena kirakiiyeni bi toudimani siyisisiya vivirana siyawonawona bo, “Mmko kokita? Mmkona wiiyeveveyana wouna ere maragasina. Mmko tomoyina maragata gwabine na kanuma beroberodi yawonedi na sakabisisireni.” ");
INSERT INTO aui_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yaininagha Yesu warana, Galili kuburina tupane wawaya siviwarareerebeni. ");
INSERT INTO aui_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bi yaininagha Yesu kana kivikivina teya kabepepa barena sikuyoveni sinagho Saimon da Andru yadi bareye bi Jemes da Jon yawata sivitugwagwaridi. ");
INSERT INTO aui_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon rawananaki wasikena igubaga, sinina imuyamuya kirakii kepane iyakenakena, bi rotomanina Yesu siwoneni da touna metagha. ");
INSERT INTO aui_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Irughu touna biidi, imana ikabi bi itainawiigeghomiiri. Yaininagha sinimuyamuya wasike ikuyoveni bi igeghomiiri da ikoyagha yaporidi. ");
INSERT INTO aui_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gabudara iyowogha bi muriye ravidine, wawaya turadi gubagubagidi da iiyawogha kanuma beroberodi sitowatawanidi na korotodi sipiikedi Yesu biidi. ");
INSERT INTO aui_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bi kate wawaya tupadi noko kwanatune bare naghone sivitaghomidi. ");
INSERT INTO aui_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bi wawaya korotodi gubagegubage iviyawiidi, bi kanuma beroberodi wawaya gwabidima ivikanibuvedi. Bi kanuma beroberodi sakovi da touna iiyabo na iwonedi bo, “Gegha konimaghamaghatara da tagu God natuna.” ");
INSERT INTO aui_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Raghani kana didiguba iyoghoyeni, na Yesu igeghomiiri, bare ikuyoveni bi inagho kubura nighorovine meme wawaya gegha na God biidi iyarurupari. ");
INSERT INTO aui_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bi muriye Saimon turaturana teya sikanibu siyininoyeni. ");
INSERT INTO aui_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bi sibanani na siwoneni bo, “Wawaya korotodi sitarakiiyanem.” ");
INSERT INTO aui_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iwonabodedi, bo “Tana nagho meyagii mududi mma riridae, bi God warana toudi biidi bada anadimeni. Touna kiiravine apiika.” ");
INSERT INTO aui_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wasina, Galili kuburina iverabouni God warana kabepepa baredigha iyarerereyi bi wawaya gwabidima kanuma beroberodi iyikanibuwana. ");
INSERT INTO aui_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Raghani tana tomogha sinine gubaga korekore ikabi, na ipiika Yesu biidi bi ivituwapore oghogheyana bi ivipepeyana iwona bo, “Kunawiini tagu wiiyawiguna, rubana kunimiiseyegu.” ");
INSERT INTO aui_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wasina bi, Yesu tomoyina ikita na nuwanuwana ivisi da ivikanighughuveni, na imana ikoghasi da ikabitowoyi bi iwona bo, “Wasina akayokayoveni da aniyawim. Yam berona avikovini.” ");
INSERT INTO aui_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bi yaininagha gubaga tomogha gwabine ikovi bi touna iyawamagha. ");
INSERT INTO aui_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bi Yesu sisiya bagibaginama iwonawiiyoyowaneni bi iviporani, iwona bo, ");
INSERT INTO aui_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Wasina, kunagho. Wawaya getagu kiiraviguve kunawonedina. Rotomanina kunagho da prist biidi, bi kunidebena mayem. Bi Mosis yana gwara nunune kunasuwara bi noko iniyevevedi da tamna kuyawa.” ");
INSERT INTO aui_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bi gegha, tomogha ivisuwiibogae wawaya korotodi biiyadi iyisisiya awaki touna biidi itubughana, bi kubura tupana warana iyarererei. Wasina noko kiiravine gerubana da Yesu debagha kwanatu kamodiye iyarughuna, bi kubura makewapawapadiye iyamakamake. Bi wawaya kubura tupadima toudimani siyapiipiika touna biidi. ");
INSERT INTO aui_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu kana kivikivina teya siveramagha Kaponiyamma. Bi gabudara viya sikovi murine, na wawaya siwaiyana da touna bareye na ");
INSERT INTO aui_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","koroto sivitaghomidi name, da getana gawara bare kamone iyamakamakena, kate matamketa naghone teya. Bi God warana toudi biidi iyadimedimeni. ");
INSERT INTO aui_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bi wawaya ruwamaruwa sipiika touna biidi, tomogha imana da kayena raborabobodi ritoma sikawari. ");
INSERT INTO aui_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bi wawaya sikoroto kirakii da simiiri babaridi, na gerubana tomoyina siyapiikeni Yesu biidi. Na toudi maghatare teteboruborugha sigae bare kubune, bi katovina muduna sikabitavetaveyana, meme rogune Yesu iyamiimiirina. Wasina bi, bare kubuve bonagha sibera ikovina, tomogha ere ritona sivionayi iyowogha naghone. ");
INSERT INTO aui_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wasina bi, yadi wiitumaghana ikita, na tomoyina iwoneni bo, “Natugu, yam berona anoghotataveni, bi God kate gegha aro inaverem.” ");
INSERT INTO aui_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nama God yana gwara kana wiiyeveveyana damdi siyamakamake. Na toudimani nuwanuwadiyena naboni siyanuwanuwagiura, ");
INSERT INTO aui_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“God touna kawagha bera beroberodi yanoghotataveyana. Awaki biidi mmko tomoyina naboni yisisiya? Touna God yigiboyi, yawonawona da God teya sivikoupopo.” ");
INSERT INTO aui_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yaininagha Yesu nuwanuwana kamone damina ikabi, bi iyakovi da toudi awaki siyanoghonoghosi, na iwonedi bo, “Awaki kiiravine nuwanuwamiye naboni konuwanuwagiura? ");
INSERT INTO aui_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Meko sisiyina gegha iyapiropirona, tomogha imana da kayena raborabobona tanawoneni bo, ‘Yam tamumu anoghotataveni,’ bo tanawona bo, ‘Geghomiiri yam kepana kabi bi kunapepewa’? ");
INSERT INTO aui_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Noko biidi bera tana anabera da tami konakovi da God, yana Wiisuwona Tomoyina maragata iveregu, da bera beroberodi ananoghotatavedi bi kate wawaya mmko kuburine aniyawidi.” Wasina bi tomoyina iwoneni bo, ");
INSERT INTO aui_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Awona, geghomiiri, yam kepana kabi bi kunagho bareye.” ");
INSERT INTO aui_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wasina, bi wawaya tupadi siyakitakita bi tomoyina igeghomiiri, bi yaininagha yana kepana ikawari bi ikanibutaveyana. Tupadi sivisokoveni bi God sikabepepi, bi siyawonawona bo, “Gegha meme bera naboni kayakitana.” ");
INSERT INTO aui_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu Kaponiyam kwanatuna ikuyovena mayeni bi kana kivikivina teya Galili sawana ririnagha sipepewa siyanono. Na koroto ghamana sipiika touna biidi, bi God warana iviyevevedi. ");
INSERT INTO aui_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ipepewa inagho gerabarabana, bi Livai ikita, touna Arupiyas natuna. Yana bagibagi barene iyamakamake, bi teks iyayuyuna. Yesu iwoneni bo, “Kivinigu da kagu kivikivina.” Wasina igeghomiiri bi inagho da ikivini. ");
INSERT INTO aui_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Muriyena, Livai yana bareye kamkena iyakamkam. Teks yuyuna da wawaya berodi korotodi na Yesu siyakivikivini nabo bi mabo, bi Yesu da kana kivikivina teya yawata siyakamkam. ");
INSERT INTO aui_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","God yana gwara kana wiiyeveveyana damdi na toudi Perisis yadi wawaya mududi noko berana sikita. Bi Yesu sikita teks yuyuna da wawaya berodi yawata siyakamkam, na kana kivikivina siwonedi bo, “Awaki biidi teks yuyouna da wawaya beroberodi teya sakamkam?” ");
INSERT INTO aui_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu iwaiyana bi muriye, iwonedi bo, “Wawaya yawayawiidi na gedokta siyakayokayoveni. Gegha, gubagubagidi toudi dokta sakayoveni.” Bi iwona bo, “Apiika na gewawaya miisedi anakwatuvedina, bi apiika iiyawogha bera berodi saberaberana anakwatuvedi.” ");
INSERT INTO aui_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gabudara tana, Jon Babataito kana kivikivina da Perisis mududi kam siyiiya. Wawaya mududi sipiika Yesu biidi bi siwoneni bo, “Jon kana kivikivina da Perisis kadi kivikivina siyiiya, kam gesiyakamkamna. Awaki kiiravine kam kivikivina patana sakamkam?” ");
INSERT INTO aui_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Bi Yesu iwonedi bo, “Memeda tomogha wasike yarawarawayi, na turaturana gekamsiniiya memeda touna patana yawatana, bo? Gegha. Touna yawatana, kam gesiniiyana basuna toudi sinuwamiise patapata. ");
INSERT INTO aui_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bi raghani murine, kana aviya sinakabitavenina. Nokodi raghanidiye, na toudi kam siniiya, basuna toudi sinuwapoya.” ");
INSERT INTO aui_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bi kate iwona bo, “Sawara wouna apiikeni, da gegha yami kiki yawata inikoupopoveni. Gegha iiyabo kwama wouna pinimina iyakabi da kwama katamanine iyatupaghiri. Bi naboni inaberana, muriye inarubotona kwama pinimina inatapikokoma na kwama wouna pinimina inatamogosira da kwama katamanina inagosiri, na bonayina inaragata kamokamogha. ");
INSERT INTO aui_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Naboni bada, gegha iiyabo wain wouna iyiviwayi wain kadi kabikabiwiitaghoma ribiribi bekadima saberana katamanidi kamodiye. Inaberana, noko wain iniposi da kabikabiwiitaghoma inatamobewara, basuna gerubana inakasiroroni, raghanine wain inapuro bi inaruruwana. Noko kiiravine wain da kabikabiwiitaghoma iniberodi. Gegha, wawaya na wain wouna, kabikabiwiitaghoma woune siniwagha na inakasiroroni.” ");
INSERT INTO aui_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wiiyawiitaveyana gabudarina tana Yesu kana kivikivina yawata wit kwabuna kamonagha sirughuwona. Bi toudi siyanono, na kana kivikivina wit kamdi siyapunepuneka kam biidi. ");
INSERT INTO aui_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Perisis mududi sikitadi noko berana siyaberabera, na Yesu siwoneni bo, “Kita, kwakovi da God yana gwara yigesa, da wiiyawiitaveyana gabudarine bagibagi gegha. Bi awaki biidi sabagibagi?” ");
INSERT INTO aui_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu iwonabodedi bo, “Buka kamone sigiruma da awaki Deivid ibera kam ikayovenina, touna yana wawaya teya vitonana sirabobona. Tami waragututuna kokabiyavi bo, bi awaki kiiravine yana basuna gekoyanoghonoghosina? ");
INSERT INTO aui_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Deivid irughu God yana bareye bred kiiravine. Abiyata, touna prist kiikiiwawona yana gabudare, bi nokodi bred nada God biidi isuwara. Prist wiibadadi toudi kawagha nokodi bred sakamkam, bi Deivid bred mududi ikam, bi yana wawaya mududi iveredi.” ");
INSERT INTO aui_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu iwonena mayedi bo, “God wiiyawiitaveyana gabudarina itore, na wawaya kiiravidiye da iniwiitedi, gegha wawaya iyaberadi da wiiyawiitaveyana gabudarina kiiravine siyiwiitenina. ");
INSERT INTO aui_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Noko biidi, God yana Wiisuwona Tomoyina, na tagu wiiyawiitaveyana gabudarina kana Bada.” ");
INSERT INTO aui_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wiiyawiitaveyana gabudarina tana Yesu iveramagha irughu kabepepa barene bi tomogha imana raborabobona ikita nama iyamakamake. ");
INSERT INTO aui_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na Perisis yadi kayowana da siyiwawuni na siyaruruwiiteteni bi siyakita da noko tomoyina iyiyawiini wiiyawiitaveyana gabudarine. ");
INSERT INTO aui_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bi Yesu tomoyina iwoneni bo, “Piika, wawaya naghodiye kunamiiri.” ");
INSERT INTO aui_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bi kate nokodi wawaya ivitarakiiyanedi iwona bo, “Meko sirana imiise wiiyawiitaveyana gabudarine: Miisena tana bera bo berona tana bera? Tani yawa bo tanakasunugha?” Bi getana iiyabo iyawonabodenina. ");
INSERT INTO aui_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na Yesu nuwanuwana ipughu bi ikita wiiveravera. Toudi tainadi sikuru na touna ivinuwapoya na tomogha imana raborabobona iwoneni, “Imam kuroroni inakanibu.” Na imana ikoghasi ikanibu na iyawa. ");
INSERT INTO aui_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wasina, Perisis yaininagha sikuyoveni bi sinagho kiiwawo Herod turaturana biiyadi bi keda sivinogha da metagha Yesu siyiraboboni. ");
INSERT INTO aui_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Wasina bi, Yesu kana kivikivina yawata siveramagha sawa kikirine, na Galilima koroto ghamana sikivini sinagho. Wawaya korotodi siwaiyana da berakayowiiwiiyaka iyaberabera, na wawaya Jiudiyama, Jerusalemma, Idumeyama, bi kwanatu mududi Jodan rarimina nawane bi Taya da Saidon kwanatudi riridigha tupadi sipiika. ");
INSERT INTO aui_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Wawaya korotodi nada iviyawiidi, na gubagubagidi mududi siyibusura da yadi wiina Yesu siyakabitowoi. Na kana kivikivina iwonedi da waga tana sinakabigubeni touna kiiravine, da gewawaya sinagwagwarina. ");
INSERT INTO aui_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Raghanine kanuma beroberodi wawaya siyibadedi bi sikita, na naghone sivituwapore oghogheyana bi sirakapara, “Tamna God natuna!” ");
INSERT INTO aui_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bi Yesu sisiya bagibaginama iwonedi da gegha siyisisiya da touna iiyabo. ");
INSERT INTO aui_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu koyae igae bi tomotomogha ikayovedina ikwatuvedi, sipiika touna biidi. ");
INSERT INTO aui_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bi tomotomogha yadi twelve ivineyidi da touna teya siyamakae bi siyapepewa na ikwatuvedi toudi apasol. Bi iwonedi bo, “Yagu wiina da yawata tana makae, bi raghani murine aniporami konakanibu da wawaya biidi wonagu koniwarareerebeni.” ");
INSERT INTO aui_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bi maragata iveredi da kanuma beroberodi wawaya gwabidima siyikanibuvedi. ");
INSERT INTO aui_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nokodi yadi twelve ivinegha na kadi waghawagha mma naboni: Saimon (Yesu, iviwaghawaghayeni da Pita), ");
INSERT INTO aui_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi natunatuna Jemes da tiinaru Jon, Yesu iviwaghawaghayedi Boaneges (yana basuna warikeyakeya natunatuna), ");
INSERT INTO aui_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Piripo, Batoromiu, Matiu, Tomas, Jemes, Arupiyas natuna, Taidiyas, Saimon touna Zelot wawaya ");
INSERT INTO aui_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","bi Jiudas Iskariyot (touna ivikedawaga da Yesu sinaburavi). ");
INSERT INTO aui_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu yana apasol yawata sinagho bare tane bi koroto ghamana bada siriyena mayeni, na gerubana da siyakam. ");
INSERT INTO aui_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yana rakaraka noko sisiyina siwaiyaneni na siwona bo, “Touna ineghanegha,” bi muriye na sipiika da siyarutayini. ");
INSERT INTO aui_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","God yana gwara Mosis iverenina kana wiiyeveveyana damdi, mududi Jerusalemma siyowogha bi siwona bo, “Belsabub, touna na kanuma beroberodi kadi bada ghamana na Yesu yibadeni! Bi touna yana maragate na Yesu kanuma beroberodi yikanibuvedi.” ");
INSERT INTO aui_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wasina bi, Yesu, gwara kana wiiyeveveyana damdi ikwatuvedi bi miibama iwonedi bo, “Metagha bi Seitan inageghomiiri da Seitan inikanibuveni? ");
INSERT INTO aui_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Memeda kwanatu tana inarutotoni damvedamve bi toudi siyogha vivirana, na noko kwanatuna gegha inamiiri wiimaragatana. ");
INSERT INTO aui_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bi rakaraka tana yayarayi da damvedamve, bi toudi siyogha vivirana, na noko rakarakana gegha inamiiri wiimaragatana. ");
INSERT INTO aui_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bi wasina, memeda Seitan yana dam inayarayi bi siniyogha na gesinamakena bi toudi sinaroukwa. ");
INSERT INTO aui_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Seitan kana miiba waragututuna tana mma: Getana iiyabo rubana tomogha maragasina yana bareye inarughu da yana sawara inayapina, da dagudagunena noko tomoyina inaghira tawatawani, bi muriye na yana bareye inayapi. ");
INSERT INTO aui_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","God wawaya bera berodi sabera bi kate siwaghawagha beroveni na tupadi inanoghotatavedi. ");
INSERT INTO aui_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bi iiyabo Kanuma Kabikabikuwayina iniwaghawagha beroveni, na God noko berona gegha inanoghotatavenina, bi yana berona inamakewaghata.” ");
INSERT INTO aui_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu naboni iyisisiya na basuna Kanuma Kabikabikuwayina yana maragate kanuma beroberodi iyikanibuvedi, bi toudi Kanuma Kabikabikuwayina siyiwaghawagha beroveni siyawonawona bo, “Touna kanuma berona itowatawani.” ");
INSERT INTO aui_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesu sinananaki da warewaresina siverakanibu, bi maghatare siyamiimiiri, na wawaya tana sivipora da touna iyawoneni. ");
INSERT INTO aui_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Koroto ghamana sigwagwari siyamakamake, na nokodi wawayidi mududi siwoneni bo, “Sinamnaki da warewaresim maghatare sakayokayovem.” ");
INSERT INTO aui_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bi iwonabodedi bo, “Sinagunaki iiyabo, bi warewaresigu iiyawogha?” ");
INSERT INTO aui_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wasina, ikita wiipatedi da nokodi wawaya simakegwagwari na iwonedi bo, “Kowaiyana! Mmkodi na sinagunaki bi warewaresigu! ");
INSERT INTO aui_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iiyabo God yana wiina inabera na touna waresigu, nughuguru bi sinagunaki.” ");
INSERT INTO aui_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu Galili sawane wiiyeveveyana idagu mayeni. Wawaya korotodi sinagho iyisisiyana na siyawaiwaiyana, sikoroto kirakii, na touna wagae igeru bi imakekira bi wawaya rarima ririne siyamiimiiri. ");
INSERT INTO aui_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Miiba sisiyidi ivisisiya, bera peyaridi iyiyevevedi. Miiba sisiyidi iwonedi bo, ");
INSERT INTO aui_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mmko kowaiyaneni, tomogha tana kana tarana kamone tanawa iroveni, bi pei ivirubusareni. ");
INSERT INTO aui_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pei mududi keda ririne siririgha, na manu sipiika sikam. ");
INSERT INTO aui_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pei mududi tanawa akakimine siririgha, meme dobodobo gegha ghamana, na nokodi pei sirugogo yaininagha, ");
INSERT INTO aui_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","bi ramramdi gesiyayowogha kirakii, na raghanina gabudara igae bi irarayidi, na gogodi sivivi. ");
INSERT INTO aui_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pei mududi dinamona iyiyodi kamodiye siririgha, bi sigogo sigae na pei sirogutawanidi na gesiyuwaghana. ");
INSERT INTO aui_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bi pei mududi tanawa miisene siririgha, na sigogo yapora kiidi mududi sitaveyana na 30, mududi 60 bi mududi 100.” ");
INSERT INTO aui_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bi iwonedi bo, “Memeda ere tainamina, awaki awonemina kowaiyana.” ");
INSERT INTO aui_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Noko murine Yesu kana kivikivina yadi twelve da wawaya mududi miiba kiiravidiye sivitarakiiyana. ");
INSERT INTO aui_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iwonabodedi bo, “Tami avineyimi na sisiya kowoyidi anawonemi da metagha God wawaya keda woune inibadedi, bi maghatara damdi geanawonena yaporidina, bi miibama anawonedi. ");
INSERT INTO aui_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Anabera da God yana peroveta naghove waghata igirumina inarumaghatara. ‘Patana sinakitakitawiivera bi gerubana sinakitana, bi sinawaiwaiyana bi gesinakovina, kate bi sinamake karona, na yadi beronama ananoghotatavedi.’” ");
INSERT INTO aui_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu ivitarakiiyanedi bo, “Tami mmko miibina yana basuna kwakovi? Metagha, bi, tami miiba mududi gekoyakakowana? ");
INSERT INTO aui_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Upi tomoyina pei yirubusarenina, bi wawayina touna God warana wawaya biidi yarererei. ");
INSERT INTO aui_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wawaya mududi na naboni ware pei keda ririne siririghana - sisiya sawaiyana, bi Seitan yapiika na sisiyina yakabitaveni. ");
INSERT INTO aui_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wawaya mududi na ware tanawa akakimina naboni - sisiyina nuwamiiseye sawaiyaneni ");
INSERT INTO aui_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bi ramramdi gegha, na gesiyamakamake wiigurina. Sisiya kiiravine na, nuwabero bo wiikayotaketowana sapiikana raghani tana sabeku. ");
INSERT INTO aui_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wawaya mududi na ware tanawa meme dinamona iyiyodi sagogona naboni. Mmkodi wawayidi sisiya sawaiyana, ");
INSERT INTO aui_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bi yawa nuwapoyina, moura nuwayuyunina mekodi siyabedina, bi kate bera mududi sarughu kuridina sisiya sarogurogu tawanidi na, gegha siyuwuwaghana. ");
INSERT INTO aui_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tanawa miisena na naboni ware wawaya sisiya sawaiyana, sakabisisireni na suwagha, mududi 30 mududi 60, bi mududi 100.” ");
INSERT INTO aui_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu iwonedi bo, “Da name meyani wawaya kibe yakabi yapiika dabira kamone bo kenakena kemana rogune yatore? Gegha, kibe na kadi miimiiri debane yatore, ");
INSERT INTO aui_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","noko kiiravine yawa kowoyidi tupadi naboni, na anakabiwiimaghataridi debae, bi bera kasikasitawanidi naboni, na anatatetavedi. ");
INSERT INTO aui_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Memeda ere tainamina kowaiyana.” ");
INSERT INTO aui_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bi toudi iwonedi bo, “Koviraborabobo bi konuwagiura, kowaiyana wiimasi na tami konakowa kirakii. ");
INSERT INTO aui_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yagu sisiya basuna konakovina aniwiitemi da konakowa yapora. Bi iiyawogha gesiyakakovina, akowa gisina gwabidiyena siniwapeni.” ");
INSERT INTO aui_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu iwona bo, “Mmko waragututuna, na metagha God yana wawaya inibadedi na yadagudaguni. Tomogha kana tarane pei iwavi. ");
INSERT INTO aui_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nubabasuve yakenakena bi gabudare na yabagibagi, na nonowa pei sagogogo, bi tomoyina geiyakakovi da metagha sagogogo. ");
INSERT INTO aui_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tanawa touna kawagha yaberana kiidi sagogo, dagudagune, na sakarapumka da gisidi, bi kiidi saragata, na suwagha sakasiyuyu. ");
INSERT INTO aui_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uwadi sitora siyamenameni, na tomogha kabipura idaguni.” ");
INSERT INTO aui_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu iwona bo, “Awaki miibidima anawonemi, da metagha God wawaya inibadedi na yadagudaguni? ");
INSERT INTO aui_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Noko naboni ware aveya basuna. Bi basuna na igisi kirakii gebasu mududi naboni bi wawaya sawavi, ");
INSERT INTO aui_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","bi yagogo, yaragata kirakii gekiiuwa mududi naboni, bi ragharaghana saragata kirakiina rubana da manu kadi kema rogune sinayoghana.” ");
INSERT INTO aui_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu miiba waragututudi peyaridi mma naboni wawaya iwonedi, awaki siwaiyana na rubadiye, bi gesiyawaiyana kamoghana. ");
INSERT INTO aui_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Touna miiba waragututudi kawagha ivisisiya, bi raghanina kana kivikivina yawata na, bera tupana yawonena yaporidi. ");
INSERT INTO aui_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Noko gabudarina, ravidiye, Yesu kana kivikivina iwonedi bo, “Tana towawona sawa nawane.” ");
INSERT INTO aui_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Touna patana wagae, bi sigeru da touna yawata sikabisitowawona. Sitouyana koroto ghamana sikuyovedi, bi waga mududina yawata sinagho. ");
INSERT INTO aui_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yanunu ghamana iyatapitapi bi yabarata waga iyarurouvi, na rarima wagae iyarughurughu. ");
INSERT INTO aui_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Name waga murine na Yesu ivikasepa iyakenakena. Kana kivikivina sikasiwiimataki siwona bo, “Abawiiyeveveyana, touda pinimina bi tana rabobo. Tam noko kwanoghonoghosi bo?” ");
INSERT INTO aui_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Igeghomiiri bi yanunu iwoneni bo, “Kiraborabobo!” Bi yabarata iwonedi bo, “Kovinighorowa.” Yanunu ikabitoura na yabarata sivinighorowa. ");
INSERT INTO aui_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bi iwonedi bo, “Awaki kiiravine konaghara? Bo gegha koyitumaghaneguna?” ");
INSERT INTO aui_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Toudi sinaghara kirakii na siwona bo, “Agii mmko awaki tomoyina? Gemeyani wawaya naboni tayakitakitana, iiyabo mmkodi berakayowiiwiiyaka iyaberaberana. Bi maragata gwabine na yanunu da yabarata yawonedi na siraborabobo, bi sikabisisireni!” ");
INSERT INTO aui_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu kana kivikivina teya sipiika Galili sawana nawane, Gerasa damdi yadi kubure. ");
INSERT INTO aui_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bi wagama itarakapoka wota na, tomogha epamana bonayina kamodima ikanibau, meme wawaya raborabobodi siyadogudogudina. Mmko tomoyina kanuma berona iyibadeni, ");
INSERT INTO aui_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","getana iiyabo rubana da iyakabiwiipikana raghani ipeyari kayena da imana seinma saghira, bi nonowa seinma sanigori, na nigora yayaragha, na gerubana iiyabo iyanigoratawanina. ");
INSERT INTO aui_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Raghani da nubabasu koya boridigha iyapeepewa wapawapa, iyakabikabida bi akimama iyarigharigha mayeni, bi epamana bonayidi kamodiye iyamakamake. ");
INSERT INTO aui_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Touna Yesu vimenaki ikita na iverainagho naghone ivituwapore oghogheyana, ");
INSERT INTO aui_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","bi Yesu tomoyina iwoneni bo, “Kanuma beroberomi kokanibutaveni!” Bi tomoyina ikabida gwaru, “Yesu, God kiidamo kirakiina natuna! Awaki biidi tagu kwawiiwiinegu? God waghawaghane, ipepeyana tam biidi, gearo kunavereguna.” ");
INSERT INTO aui_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu ivitarakiiyaneni bo, “Kam waghawagha iiyabo?” Iwonabodeni bo, “Toumii kapeyara kirakii, na kagu waghawagha na ‘Yawo.’” ");
INSERT INTO aui_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Touna patana iyipepeyana tupetupeyana da Yesu kanuma beroberodi noko kuburinama geiyiporatavedi. ");
INSERT INTO aui_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bi nama riridiyena waghita yawodi, koya borine siyakamkam, ");
INSERT INTO aui_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","na kanuma beroberodi Yesu sivibabiini bo, “Waghita biiyadi kuviporami, kanarughu.” ");
INSERT INTO aui_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iviwaghasinedi na kanuma beroberodi tomogha sivikanibutaveni bi waghita kamodiye sirughu. Yawo tupana yadi 2,000 tarapakove sivera siyowogha sawa kamone da siniudona. ");
INSERT INTO aui_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Waghita kadi bodaboda tomotomoyidi sivera sinagho, da kwanatu ghamana damdi siwonedi, bi kate meyagii tupadi riridiye. Wawaya sinagho awaki itubughana siyakita, ");
INSERT INTO aui_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","bi sipiika Yesu biidina noko tomoyina naghove kanuma beroberodi yawona ikabina sikita. Nama iyamakamake ere tarasowona, bi iyanuwanuwagiura wiimasi, na toudi sinaghara. ");
INSERT INTO aui_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wawaya iiyawogha sikitana turadi siwonedi da awaki itubugha kanuma beroberodi tomogha siyibadenina da kate waghita biiyadi. ");
INSERT INTO aui_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Noko kiiravine Yesu sivibabiini da yadi kubura iyakuyoveni. ");
INSERT INTO aui_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Raghanina Yesu wagae iyagerugeru na tomoyina kanuma beroberodi gwabine siyamakamake na, Yesu ivibabiini da yawata siyanagho. ");
INSERT INTO aui_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bi Yesu geiyiwaghasineni, bi iwoneni bo, “Kuveramagha yam rakaraka waghata biiyadi, bi kuwonedi da Bada bera ghamanakina tam kiiravimve ibera, bi metagha touna ivinuwayuyunimna.” ");
INSERT INTO aui_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Noko kiiravine tomoyina iveramagha kwanatu yadi 10 kamodigha, iyimaghamaghatara awaki Yesu touna biidi ibera, bi tupadi iiyawogha siwaiyana na sinuwagiura kirakii. ");
INSERT INTO aui_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wagagha sawa itowawoneni bi ipiika nawane, bi patana kikire na wawaya korotodi sigwagwari. ");
INSERT INTO aui_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tomogha tana ipiika touna biidi, kana waghawagha Jairas, bi touna kabepepa barena kanakoyakoyagha. Jairas, Yesu ikitana kayene ivituwapore oghogheyana. ");
INSERT INTO aui_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bi kate ivibabiini iwona bo, “Natugu wasike gisina yaraborabobo, piika da imam debane kunatore da inayawa bi inamakae.” ");
INSERT INTO aui_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Na Yesu yawata sinagho. Bi wawaya korotodi sikivini, na toudi ririnagha sigwagwari. ");
INSERT INTO aui_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wasike magurina tana nama, kubuwiipum ikabi da bodu 12 sikovi. ");
INSERT INTO aui_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yana mane tupana dokta biiyadi ivitaveni, bi gerubana da siyiwiiteni, patana geiyidami bi gubagina iragata kamokamogha. ");
INSERT INTO aui_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Yesu sisiyina iwaiyaneni na inoghotamayeni, “Memeda kana kwama anakabitowoghawosi na anayawa.” Na koroto basudigha iveravivira murine bi kana kwama ikabitowoyi. ");
INSERT INTO aui_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iyakabitowoyi na yaininagha kubuwiipum ikanakana, bi sinina kamone ividami da gubaga ikovi. ");
INSERT INTO aui_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu damina ikabi da maragata ikanibutaveni na koroto basudiye imiiri wamira bi iwona bo, “Iiyabo kukwama ikabitowoyi?” ");
INSERT INTO aui_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kana kivikivina siwoneni bo, “Kukita, wawaya tupadi sigwagwarim, bi metagha na kuwona da, ‘Iiyabo ikabitowoyigu?’” ");
INSERT INTO aui_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bi ikitawiininogha, da yana wiina iiyabo ikabitowoyina iyakita. ");
INSERT INTO aui_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wasike iyakovi da awaki touna biidi itubugha na inaghara bi ikiroro, na ipiika Yesu naghone ivituwapore oghogheyana bi bera tupana ivisuwoneni. ");
INSERT INTO aui_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu wasikena iwoneni bo, “Natugu, kuvitumaghanegu na kuyawa, kam gubaga ikovi, nuwamiiseye kunagho.” ");
INSERT INTO aui_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu patana iyiisisiya, bi wawaya mududi yona sipiikeni Jairas yana barema bi siwoneni bo, “Natum ikuyovem. Abawiiyeveveyana gekunitaina irirenina.” ");
INSERT INTO aui_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu taina damonama noko sisiyina iwaiyana na Jairas iwoneni bo, “Gekunanagharana, kitumaghanena wosigu.” ");
INSERT INTO aui_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu, wawaya mududi geiyiwaghasinedi da yawata siyanagho bi Pita, Jemes da waresina Jon ikabidi da toudi kawagha sinagho. ");
INSERT INTO aui_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairas yana bareye sikanibu, na Yesu wawaya korotodi ikitadi, sigiirara siyaduudu bi kate siyasiyasiyapa, ");
INSERT INTO aui_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","irughu bareye bi iwonedi bo, “Awaki biidi kwiinuwapoya bi koduudu? Simira gegha iyarabobona - touna yakenakena wota.” ");
INSERT INTO aui_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bi wawaya simaniveni, bi Yesu simira sinananaki, tamananaki da kana kivikivina yadi aroba ikabidi, bi wawaya muduna iviporadi sikanibu, bi toudi sirughu bare kamove, meme simira iyakenakena. ");
INSERT INTO aui_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu wasike gisigisi imana ikabi bi iwoneni bo, “Talita, kum!” yana basuna, “Wasike gisigisi, awonem da geghomiiri!” ");
INSERT INTO aui_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Rotomanina igeghomiiri bi iyapeepewa, (bi touna kana bodu 12). Toudi sinokeni bi sivisokoveni. ");
INSERT INTO aui_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu iwonawiiyoyowanedi da awaki sikitana gegha wawaya siyimaghamaghataredi bi iwona bo, “Simira kam kovereni inakam.” ");
INSERT INTO aui_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kana kivikivina teya noko meyagiina sikuyoveni bi siveramagha yana ragata kwanatune. ");
INSERT INTO aui_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wiiyawiitaveyana gabudarine na wiiyeveveyana kabepepa barena kamone idaguni. Wawaya korotodi nama; bi siwaiyanenina tupadi sivisokoveni. Sivitarakiiyana vivirana, “Meme noghota tupadi iyouna?” bi “Metagha da iyakowa kirakii da berakayowiiwiiyaka yabera?” ");
INSERT INTO aui_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na siwonena mayedi bo, “Touna abayoghayoghana kawagha, bo Meri natuna bi Jemes, Jousep, Jiudas bi Saimon waresidi iyarokona. Bi nughunughuna yoghoyogho mma samakamake, bo?” Na toudi sivisinighiighiiyeni. ");
INSERT INTO aui_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu iwonedi bo, “Kubura mududi wawayidi, peroveta sakabikuwayedi, bi yadi meyagii waghata wawayidi, bi turaturadi da kadi dam gesiyakabikabikuwayedina.” ");
INSERT INTO aui_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Wawaya gesiyigeruveni, na ikabinokeni. Nama, gegha berakayowiiwiiyaka iyaberana, bi wawaya gubagubagidi viyagha imana debadiye itoura bi iviyawiidi. Bi touna meyagiigha iyapeepewa bi wawaya iyiyevevedi. ");
INSERT INTO aui_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu kana kivikivina yadi 12 ikwatu wiitaghomidi bi meyagii bogaebogae iviporadi sikanibu yadi batabatiighate. Touna maragata iveredi da kanuma beroberodi sinibadedi, ");
INSERT INTO aui_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","bi iwonawiiyoyowanedi bo, “Geawaki tana wagawaga kiiravine konakabi da dighona kawagha - kam gegha, ghagu gegha bi mane kutu kamonena. ");
INSERT INTO aui_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kaye turababara kokoteyana, bi gegha kwama tana konakawari.” ");
INSERT INTO aui_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kate iwonedi bo, “Meko meyagiine konanagho bi sinikiikiivemi na, noko barene kawagha komake, patana da noko meyagiina konakuyoveni. ");
INSERT INTO aui_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Konapiika meyagii tane meme wawaya gegha sinikiikiivemi bi sinawaiyanemi na kokuyoveni bi kayemi popokudi kokasiwiiririgha. Noko wiikatagha toudi biiyadi!” ");
INSERT INTO aui_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na sikanibu bi wawaya biiyadi siyadimadima, Yami bera beroberodi komiiri kubutedi bi komiiri karona God biidi. ");
INSERT INTO aui_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Toudi kanuma beroberodi sirukwavina sikanibu bi oliv miina naboni ware tamanuwa otonama wawaya gubagubagidi sivituborodi na siyawa. ");
INSERT INTO aui_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Wawaya memegha na Yesu siyisisiyeni, da tupadi kana waghawagha sakovi. Wawaya mududi siyawonawona bo, “Nokodi berakayowiiwiiyaka inabera na basuna touna Jon Babataito, bi touna wawaya raborabobodi kamodima iveramagha.” Mududi siyawonawona bo, “Noko Elaija - touna iveramagha.” Bi mududi siyawonawona bo, “Noko peroveta tana, ware peroperoveta naghove waghata simakena naboni.” Kiiwawo Herod mmkodi sisiya iwaiyana na iyawonawona bo, “Jon Babataito kanighona awonana sikasiyaraghi, bi iyawamagha.” ");
INSERT INTO aui_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Waragututu na mma naboni. Muriye da Yesu yana bagibagi wiiyeveveyana iyadaguni, na Herod waresina Piripo wavinena ivituaro, bi irawaiyi. Bi wasikena kana waghawagha na Herodiyas. Noko murine Jon, Herod iyawonewoneni bo, “Waresim wavinena gegha kunakabina,” na Herod yana wiiyogha tomotomoyidi iviporadi da Jon siburavi bi saghiri da biwa gawarine sitorerughuveni. Herod iyawonawona na Jon iyapiipiika iyisisiya touna biidi, bi Herod iyinoghota bata, bi nuwamiiseye Jon iyawaiwaiyaneni. Herodiyas na Jon inuwapughuveni bi yana wiina da iyakasunui, bi Herod iyakovi da Jon na wawaya miisena bi God biidi iveremayeni, na inaghara, bi ikoyaghayapori. Noko kiiravine, wasikena gerubana da Jon iyirabobona. ");
INSERT INTO aui_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bi Herodiyas yana nuwapughu kedana ibanani na raghanina Herod yana tubugha gabudarina kiiravine siyakamkamna. Na kepo tana ibera tamudu babada ghamaghamadi, wiiyogha babadidi bi Galili kana wiinaghowana wawayidi kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiyas natuna wasike irughu bi iriku na Herod kana kiiwaga teya ivinuwamiimiiseyedi. Kiiwawo, wasike wabuwabuna iwoneni bo, “Awaki yam wiina kunakabi? Awaki sawarina kunakayoveni na anaverem.” ");
INSERT INTO aui_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bi Herod ivisuwona mma naboni iwoneni bo, “God naghone iisuwonem da awaki sawarina kiiravine kunibaba na anaverem, bo memeda yagu wiibadana muduna!” ");
INSERT INTO aui_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na wasike wabuwabuna ikanibu bi sinananaki ivitarakiiyaneni, “Awaki kiiravine anibaba?” Sinananaki iwonabodeni bo, “Jon Babataito gayamina.” ");
INSERT INTO aui_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wasike wabuwabuna rotomanina idaru ivera magha kiiwawo biidi da ivibabiini iwona bo, “Yagu kayowana Jon Babataito gayamina, dabira debane kunatore bi katota kunaveregu.” ");
INSERT INTO aui_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kiiwawo ivinuwapoya, bi gegha da nada kana kiiwaga naghodiye ivisuwona, na gerubana wasike wabuwabuna yana wiibaba iyigeyeni, ");
INSERT INTO aui_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","na Herod yanawiiyogha tomoyina ivipora, iwoneni da Jon kanighona inakasiyaraghi bi gayamina inapiikeni. Tomoyina ikuyovedi inagho biwa gawarine, Jon kanighona ikasiyaraghi bi gayamina, ");
INSERT INTO aui_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","dabira debane itore bi ikawari ipiika wasike wabuwabuna ivereni, bi touna sinananaki ivereni. ");
INSERT INTO aui_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Raghanine Jon kana kivikivina mmko siwaiyaneni, na toudi sipiika da tubuyina sikawari sinagho epamana bonayina kamone sitore. ");
INSERT INTO aui_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu kana kivikivina yadi 12 siveramagha bi siviwaragututuveni, da metagha bagibagi sibera da wawaya siyiyevevedina. ");
INSERT INTO aui_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bi noko raghanine wawaya korotodi siyapiipiika kuridi bi siyaveraveramagha, na Yesu kana kivikivina teya getaraboga da siyakamna. Na Yesu iwonedi bo, “Tamiduma kopiika, mmko korotona tana kuyovedi, bi tananagho gawara nighorovine, meme wawaya gegha na koniyawiitaveyana gisina.” ");
INSERT INTO aui_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na toudiduma wagagha sawa sitowawoneni da gawara nighorovine meme wawaya gegha. ");
INSERT INTO aui_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bi siyanonona wawaya korotodi sikitadi bi sakovidi, na meyagii nunudigha wawaya kikiragha sivera sivinagho da meko gawarine Yesu kana kivikivina teya siyanonona, toudi sikanibuyaininagha. ");
INSERT INTO aui_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Raghanina Yesu wagama itarakapoka wota kikire, na koroto ghamana ikita na ivinuwapoyedi, basuna toudi ware naboni sip gegha ere kadi bodaboda, na God warana miisena wiiyevevedi idaguni. ");
INSERT INTO aui_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ravidi gabudare na kana kivikivina sipiika touna biidi bi siwona bo, “Gegha tana mmko gawarine iiyabo iyamakamakena, bi gabudara nada yayoyo. ");
INSERT INTO aui_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wawaya kuviporatavedi sinanagho, guburagha da meyagii gisigisidigha, kadi kam sinagimona da sinakam.” ");
INSERT INTO aui_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bi Yesu kana kivikivina iwonabodedi bo, “Tamimani kam koveredi sinakam.” Bi siwona bo, “Yam kayowana da toumii kananagho bi 200 dinari rubane kanitaveni, da bred kanagimona bi mmko korotona kanikanidi?” ");
INSERT INTO aui_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu ivitarakiiyanedi bo, “Bred yadi viya gwabimiye? Konagho da konakita.” Sinagho sikita ikovi bi Yesu siwoneni bo, “Toumii gwabimiiye bred imiikovi bi ighana bata.” ");
INSERT INTO aui_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bi Yesu noko korotona iwonedi bo, “Kokabiwiitaghomimi bi idu debane komakekira.” ");
INSERT INTO aui_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na sikabiwiitaghomidi bi simakekira, riba mududi wawaya 50 bi riba mududi wawaya 100. ");
INSERT INTO aui_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bi Yesu, bred imiikovi da ighana yadi bata ikabidi, bi ikayogagawa abame da kiiravidiye, God biidi ivikiikiiwa bi bred ikiyagimagima. Kate kana kivikivina nokodi bred da ighana iveredi da wawaya sirereyedi. ");
INSERT INTO aui_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tupadi sikam da inunuridi, ");
INSERT INTO aui_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","bi kana kivikivina nokodi bred da ighana kawatupodi siripu yadi 12 sivibonuvidi. ");
INSERT INTO aui_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wawaya 5,000 noko kamna sikani. ");
INSERT INTO aui_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yaininagha Yesu kana kivikivina iwonedi da wagae siyageru, bi sininagho sinatowawona sawa nawane, kubura Betsaidama bi touna koroto muriye iyiporadi. ");
INSERT INTO aui_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ivikukuvedi ikovina, muriye igae koyae da iyarupari. ");
INSERT INTO aui_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nubabasuve, na kana kivikivina yadi wagae bi sawa basukiine, bi Yesu tana duma kayetanave. ");
INSERT INTO aui_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bi kana kivikivina ikitadi, yanunu siyawoewoe bodebodeni bi yabarata siyibageni. Na nubabasu kamone nada raghani boriboriye touna inagho kuridi, sawa debane iyapeepewa bi ibera da ware iyaveratupiiredi. ");
INSERT INTO aui_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bi raghanine sikita sawa debane iyapeepewana, sinoghosi da touna momosika bi sirakabikwarakwara. ");
INSERT INTO aui_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Raghanine sikita na tupadi sinaghara kirakii. Bi yaininagha Yesu ivisisiya iwonedi bo, “Yami noghota inimaragata, mmko tagu. Gekonanagharana!” ");
INSERT INTO aui_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Bi touna wagae toudi teya sigeru na yanunu iviraborabobo. Bi kana kivikivina sikita da metagha wawaya 5,000 ivikanidi, bi patana noko yana berana yana basuna gegha siyakowayaporina. Toudi nuwanuwadi sikotakii bi gayamidi siviakima. ");
INSERT INTO aui_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Toudi sawa sitowawoneni bi sipiika Genasaratma, na waga nama saghiratawani. ");
INSERT INTO aui_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Raghanine waga sikuyoveni, na wawaya yaininagha Yesu sikita na nada sakovi. ");
INSERT INTO aui_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kubura tupana siverabuni; bi toudi siwaiyana da touna meme, na wawaya gubagubagidi ritoma sipiikedi. ");
INSERT INTO aui_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu meghamegha inagho, meyagii gisidi bi ghamadi da wawa baredigha, na wawaya turaturadi gubagubagidi siyakawakawara siyanono nokodi gawaridiye, da debadebae siyatoretoredi bi Yesu biidi siyibaba, “Kuviwaghasinemii da kam kwama damona kawagha kanakabitowoyi.” Bi wawaya iiyawogha sikabitowoyi, na toudi yana maragate siyawa. ");
INSERT INTO aui_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Perisis da Jius wawaya mududi na yadi kiki siradi nosinosidinakim gwabidima siyouna na sakivikivina. Yadi redu, rarima kibubudi da nau sakimokimokogha yapora da nokodi sawaridi na God matane, na toudi wasina. Raghanina maketima saveramagha na yadi gwara nununena imadi samagha, bi kate sakam. Nonowa na yadi kiki siradi nosinosidinakim siveredina sakivina da naghove imadi samagha, bi muriye da sakam. Raghani tana God yana gwara kana wiiyeveveyana mududi Jerusalemma sipiika bi kate Perisis mududi yawata, tupadi Yesu biidi sipiika da sigwagwari bi siyawaiyaneni. Toudi sikita da kana kivikivina, genaghove imadi siyamagha bi kadi kam siyakamkamna. ");
INSERT INTO aui_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na touna siwoneni bo, “Kam kivikivina sakamkam bi God matane na toudi imadi dadabudi. Awaki biidi na nosidam yadi kiki siradi gesiyakivikivinana?” ");
INSERT INTO aui_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bi iwonabodedi bo, “Tami na wiiwiiyabiimi, kokabiguba da tami miisemi! Naghove waghata peroveta Aisaiya, wiisuwona igiruma tami kiiravimiye. Naboni igiruma, God yawonawona bo, ‘Mmkodi damdi kawadima sakabikuwayegu bi nuwanuwadi kamonena tagu samiirikubutegu. ");
INSERT INTO aui_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Toudi yadi kiki siradi waghata siyeveveyana, bi sawona da mmko God yana gwara, na yadi kabepepa gegha ere daminana.’” ");
INSERT INTO aui_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bi Yesu iwonamagha bo, “Tami God yana gwara kokabitaveni bi yami wiiyeveveyana kokivikivini.” ");
INSERT INTO aui_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bi kate iwonedi bo, “Memeda konoghosi da koberabera yapori, bi raghanine God komiirikubuteni bi yami kiki siradi nosidam gwabidima koyouna, na kokivikivina yapora. ");
INSERT INTO aui_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","God yana gwara kamone Mosis naboni igirumi, ‘Tam tamamnaki da sinamnaki kunakabikuwayedi,’ bi ‘Iiyabo tamananaki bo sinananaki inisisiya beroveni, na noko tomoyina konakasunuyi.’ ");
INSERT INTO aui_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bi tami naboni kwiiyeveveyana - memeda iiyabo mane bo sawara tamananaki bo sinananaki inavereni da iniwiiteni, na inawonedi bo, ‘Sawara gwabiguve na ayaveremi da ayiwiitemi bi atoura irirana da God anavereni, na tagu gegha tami anaveremina.’ ");
INSERT INTO aui_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Memeda naboni inisisiyana, tami konawona da yana sisiyana wasina, bi konigesiyeni da sinananaki da tamananaki gegha iniwiitedina. ");
INSERT INTO aui_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bi naboni kunaberana, tami nosidam yadi wiiyeveveyana kawagha kokivikivina bi God yana gwara kobera da yigwara wapawapa, bi gegha ere yana maragatana. Bi tami God yana gwara, keda bogaebogaema bada kogiigiini.” ");
INSERT INTO aui_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu wawaya ikwatuvena mayedi sipiika bi iwonedi bo, “Tami tupami, yagu sisiya kowaiyana wiimasi bi basuna konakovi. ");
INSERT INTO aui_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Gegha wawaya kam tana yakani bi kawane yarughuna inaberada God matane na touna dadabuna. Bi awaki nuwanuwana kamone da kawanama yakanibuna, noko yaberana touna God matanena touna dadabuna.” ");
INSERT INTO aui_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wasina Yesu wawaya ikuyovedi bi irughu bareye na kana kivikivina sivitarakiiyaneni bo, “Mmko miibina katota kuwoneni na yana basuna awaki?” ");
INSERT INTO aui_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Iwona bo, “Tami bada yagu sisiya awaki basuna gegha koyakovina? Gekoyakovida raghanina wawaya inakam, na noko kamna gegha nuwanuwane iyarughurughuna, bi kamokamone yarughu da tubuyinagha yakanibu, noko kiiravinena touna wawayina God matane na gegha dadabuna.” Raghanina Yesu naboni iwonana, yiyeveveyana da kam tupadina miisedi God matane, bi gegha kam tana inaberada touda dadabuda. ");
INSERT INTO aui_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bi kate bada iwona bo, “Awaki beradi bo nuwagiuridi wawaya nuwanuwana kamonama yakanibu, na toudi sabera na God matane na touna dadabuna. ");
INSERT INTO aui_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mmkodi beradi na wawaya yana nuwagiura nuwanuwana kamonama sakanibu - noghota beroberodi, wiimumurana, kabiyouna, kasunugha, madawara, ");
INSERT INTO aui_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kitakirorowana, bera berodi, wiiyaba, noghota mayeyana, nuwapughu, gigitu, kabigeegeeyana, bi beraneghanegha. ");
INSERT INTO aui_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mmkodi beradi tupadi na wawaya nuwanuwana kamonama sakanibu, na God matane na touna tamumu.” ");
INSERT INTO aui_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wasina Yesu noko meyagiina ikuyoveni, bi inagho meyagii tane Taya kwanatuna ririne bi irughu bare kamove. Geiyakayoveni da wawaya siyakovi da touna nama bi gegha, gerubana da iyakowoghana. ");
INSERT INTO aui_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Wasike tana iwaiyana da Yesu nama na ipiika touna biidi. Mmko wasikena touna gegha Jius, bi kubura wiibata wasike. Touna Ponisiyane itubugha Siriya kubura kamone. Bi natuna wasike gisina, kanuma berona iyibadenina kiiravine ipiika Yesu biidi, bi naghone ivituwapore oghogheyana, bi ivibabiini da kanuma berona iyikanibuveni natuna kamone. ");
INSERT INTO aui_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu iyakovi da noko wasikena touna gegha Jius na miibama iwoneni bo, “Gegha iyamiise da ededa kadi kam tanakabi bi tanitaveni daghasi biidi, da naghove na ededa sinakam da inanunuridi.” ");
INSERT INTO aui_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bi wasike iwona bo, “Bada, awaki kuwoneni na wiisuwona, ededa sakam, bi kam yoghoyoghodi saririgha kiinabonabo rogune na daghasi bada sakam, na noko wasina da kuniwiitegu.” ");
INSERT INTO aui_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na Yesu iwoneni bo, “Tam ere wiigeruwanim kuwonabodegu kiiravine na kanuma berona natum kamonama avikanibuveni. Kuveramagha yam bareye.” ");
INSERT INTO aui_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wasina wasikena iveramagha yana bareye, na ikita da natuna yana kepane iyakenakena. Bi kanuma berona nada wasike gisigisi ikanibutaveni. ");
INSERT INTO aui_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu, Taya kwanatuna ikuyoveni bi Saidon kuburina basunagha igae inagho. Gegha Galili kubure iyarughuna, bi gegha, kwanatu yadi ten kuburidigha iverarughuwonedi da inagho Galili sawane. ");
INSERT INTO aui_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bi name tomogha taina potapotana touna gerubana da iyisisiya wiimasi, na wawaya sirutayini sipiikeni Yesu biidi, bi sivibabiini da imana debane iyatore da iyawa. ");
INSERT INTO aui_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu tomoyina ivinaghokedari, da wawaya sikuyovedi bi yadi bata kawagha sinoghotaveyana, bi imakwarukwaruna tomoyina tainana bonayidiye itoura bi imana ikanu da tomoyina pepana itupatowoyi. ");
INSERT INTO aui_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tomoyina ivinuwapoyena kirakiiyeni, na abame ikayogagawa, bi iviyawiiguri iwona bo, “Efata!” Noko sisiyina yana basuna “Kotamobubu!” ");
INSERT INTO aui_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yaininagha tomogha tainana sitamobubu, bi pepana ivikuwamira da iyisisiya wiimasi. ");
INSERT INTO aui_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na Yesu wawaya ivigesiyedi da geturaturadi siyawonedi da awaki itubugha. Na iwonawiiyoyowanedi, bi toudi gegha yana sisiya siyawaiyana bi sinagho wawaya korotodi sivimaghamaghataredi da metagha Yesu tomogha taina potapotana bi kawaneghaneghana iviyawiini. ");
INSERT INTO aui_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Raghanina wawaya noko sisiyina siwaiyaneni, na sinokeni bi siwona bo, “Touna bera tupana yaberabera yapori. Wawaya taina potapotadi da kawaneghaneghadi yiyawiidi na sawaiyana bi bada sisisiya.” ");
INSERT INTO aui_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Noko raghanine, wawaya korotodi siriyenamayeni. Bi mmko korotona kadi tamiina sikawara na gwabidiye sikovi, na Yesu kana kivikivina ikwatuwiitaghomidi sipiika, bi iwonedi bo, ");
INSERT INTO aui_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mmko korotona yawata tamake da gabudara aroba sikovi, bi kadi kam sikovi, na tagu iikanighughuvedi. ");
INSERT INTO aui_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Memeda ere vitonanidi aniporadi sinanagho yadi bareye, na kedae vitonana sinarabobo sinamameyedi. Basuna mududi na rabarabama sipiika.” ");
INSERT INTO aui_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kana kivikivina siwonabodeni bo, “Getana iiyabo mma iyamakamakena, da meme bred tana youna bi mmkodi wawaya tani kanidi?” ");
INSERT INTO aui_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bi Yesu ivitarakiiyanedi bo, “Bred yadi viya gwabimiye?” Toudi siwona bo, “Bred yadi seven.” ");
INSERT INTO aui_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wasina bi noko korotona iwonedi da tanave simakeyowogha. Bi bred yadi 7 ikabidi da God biidi ivikiikiiwa, bi bred ikiyagima, da kana kivikivina iveredi da koroto siyarereyedi, bi sireregha da wawaya sikabipatadi. ");
INSERT INTO aui_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Toudi ighana gisigisidi viya bada gwabidiye, na ighana kiiravidiye na God biidi ivikiikiiwa bi kana kivikivina iwonedi da wawaya siyarereyedi. ");
INSERT INTO aui_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wasina bi wawaya tupadi sikam, da inunuridi. Bi kam kawatupodi peyaridi siyamakamake; na kana kivikivina kam kawatupodi siripu yadi 7 sivibonuvidi. ");
INSERT INTO aui_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Namana wawaya meboda 4,000. Bi muriye na Yesu wawayidi iviporadi sinagho yadi bareye. ");
INSERT INTO aui_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yaininagha Yesu kana kivikivina teya wagae sigeru bi sinagho Dalmanuta kubure. ");
INSERT INTO aui_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bi Perisis mududi sipiika da Yesu teya wiikawakereyana sidaguni. Toudi sikayoveni da siyikayetayini, na kiiravine sivibabiini da God gwabinama matakira tana iyabera, noko iyiyevevedi da touna God gwabinama ipiika. ");
INSERT INTO aui_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Touna nuwanuwana kamone iviyawiiguri iwona bo, “Tami mmko kimsina woumi awaki biidi God gwabinama matakira kiiravine kwiibaba? Iisuwonemi, tami matakira kate gegha anabera da konakitana.” ");
INSERT INTO aui_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wasina bi Yesu, Perisis ikuyovedi bi kana kivikivina teya wagae sigeru bi sitowawona Galili sawana nawane. ");
INSERT INTO aui_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bi kivikivina gesiyanoghosi da bred siyakawara bi gwabidiye na tanagha nama wagae. ");
INSERT INTO aui_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wasina Yesu iwonawiiyoyowana iwona bo, “Kokita yapori da Perisis da Herod yadi yist getami kamomiye sinamakena.” ");
INSERT INTO aui_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kivikivina, Yesu noko yana sisiyina sikaboveni bi toudimani siwona bo, “Memeda touda bred gegha tayakawara, noko kiiravine yist ivisisiyeni.” ");
INSERT INTO aui_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iyakovi da awaki siyanoghonoghosi na iwonedi bo, “Awaki kiiravine kwiinuwapoya da bred gwabimiye gegha? Bo patana gegha koyakakoviguna? Tami nuwanuwami sikotakii! ");
INSERT INTO aui_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tami ere matami bi gekoyakitakita yaporana! Bi ere tainami bi gekoyawaiwaiyana yaporana! ");
INSERT INTO aui_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Konoghosi da metagha bred yadi 5 akiya gimagima wawaya 5,000 kiiravidiye. Bi kam kawatupodi pinipinimidi siripu yadi viya kovibonuvidi?” Na siwona bo, “Siripu 12.” ");
INSERT INTO aui_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bi bada ivitarakiiyanena mayedi bo, “Bi raghanina bred yadi 7 akiya gimagima wawaya 4,000 kiiravidiye? Na kam kawatupodi pinipinimidi siripu viya kovibonuvidi?” Na siwona bo, “Siripu 7.” ");
INSERT INTO aui_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bi kate iwona bo, “Da tami patana awaki awonemina gegha koyakovina?” ");
INSERT INTO aui_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wasina bi Yesu kana kivikivina teya sinagho Betsaida kwanatune. Bi name wawaya mududi tomogha mata potapotana sikabi sipiikeni Yesu biidi bi sivibabiin da iyakabitowoyi da iyiyawiini. ");
INSERT INTO aui_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na Yesu tomoyina imana ikabi bi ivinagho kedari kwanatu sikanibutaveni maghatare. Tomoyina matana ikanu, bi imana matane itoura bi kate iwoneni bo, “Awaki sawarina tana kwakitakita bo?” ");
INSERT INTO aui_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tomoyina ikayogagawa bi iwona bo, “Wawaya akitadi, bi kadi kita ware kii siyigadivivivira.” ");
INSERT INTO aui_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wasina imana tomoyina matane itoura magha, na matana sikitarunagha da siyawa na sawara tupadi ikita yapora. ");
INSERT INTO aui_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bi Yesu iwoneni bo, “Gegha kunaveramagha meyagiiye, rotomanina kunagho yam bareye.” ");
INSERT INTO aui_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wasina bi Yesu kana kivikivina teya sinagho meyagii mududi Sisiriya Pilipai ririne. Siyanono na kedae kana kivikivina ivitarakiiyanedi bo, “Wawaya sawonawona da tagu iiyabo?” ");
INSERT INTO aui_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Toudi siwona bo, “Wawaya mududi sawona da Jon Babataito, mududi sawonawona da Elaija, bi patana mududi sawonawona da tamna peroveta tana, naghove waghata irabobo na bada iyawamagha.” ");
INSERT INTO aui_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bi ivitarakiiyanedi bo, “Bi bada tami, kowonegu da tagu na iiyabo?” Pita iwonabodeni bo, “Tam na Keriso, God yana Wiivinevinegha Kiiwawona.” ");
INSERT INTO aui_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bi Yesu iwonawiiyoyowanedi da gegha wawaya sinawonedi da touna Keriso. ");
INSERT INTO aui_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wasina bi awaki inatubugha touna biidi na idagu kana kivikivina iniyevevedi. Iwona bo, “Tagu, God yana Wiisuwona Tomoyina sinivisi ghamana anakabi, bi kwanatu kadi dogadogara da prist babadidi bi kate God yana Gwara kana wiiyeveveyana damdi sinisinighiighiiyegu. Na sinakasunuyigu bi gabudara 3 murine raboboma anageghomiiri magha.” ");
INSERT INTO aui_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu mmkodi bera debagha iyisisiya na Pita ikabireni ririne bi ikini iwoneni da gegha yana sinivisi da rabobo iyisisiyana. ");
INSERT INTO aui_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bi Yesu imiiri wamira da kana kivikivina ikitadi bi Pita ikini iwonaghakiyeni bo, “Seitan, gwabiguma kunaghotaveyana! Yam noghota gegha God gwabinama iyapiikana bi wawaya gwabidima ipiika!” ");
INSERT INTO aui_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wasina bi Yesu noko koroto da kana kivikivina ikwatuvedi sipiika touna biidi bi iwonedi bo, “Memeda iiyabo kivinigu inakayoveni, na yana wiina inakuyoveni bi yana korosi inakabi da inakawari bi inakivinigu. ");
INSERT INTO aui_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iiyabo yana wiina kubura yawana kedane make inakayoveni, na touna yawa makewaghawaghasina iniwapeni. Bi iiyabo yana wiina sawaridi inakabitoura da tagu inakivinigu bi wara miisena inakabisisireni, na yawa makewaghawaghasina inakabi. ");
INSERT INTO aui_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bi meboda wawaya tana yana wiina sawaridi tupadi mmko kuburine inayouna bi gegha yawa makewaghawaghasina inakabina, nokodi sawara tupadi gesiniwiitenina. ");
INSERT INTO aui_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Basuna meboda wawaya yawa makewaghawaghasina iniwapeni, na kate gegha awakima inimiisana da yawa inagimona mayenina. ");
INSERT INTO aui_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Memeda wawaya iiyawogha kata samakamake na yadi kayowana beroberodi saberabera da samiiri kubutegu. Bi kate tagu bi yagu wiiyeveveyana sinisinighiighiiyeni, na muriye tagu God yana Wiisuwona Tomoyina anawona da geayakovidina. Raghanina mmko kuburine anaveramagha tamagunaki yana maragate bi yana aneyaneya kabikabikuwayidi yawata bi mmko inatubugha.” ");
INSERT INTO aui_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bi kate Yesu iwonenamayedi bo, “Tagu iisuwonemi, tami mudumi mma gekonarabobo patana da God konakita inapiipiika ere maragasina wawaya wiibadedi kiiravine.” ");
INSERT INTO aui_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gabudara 6 sikovi murine Yesu, na Pita, Jemes da Jon kawagha irutayinidi bi ivinaghovedi toudi duma sigae koya kiidamove, bi name kana kita ivibogae toudi matadiye. ");
INSERT INTO aui_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kana kwama siyikarakeyana bi sipoe kirakii. Getana iiyabo mmko kuburine rubana da iyakogha da naboni siyapoena. ");
INSERT INTO aui_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wasina bi Elaija da Mosis sirumaghatara da Yesu teya siyisisiya. ");
INSERT INTO aui_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pita da nokodi kivikivina bata sinaghara kirakii na gegha iyakovi da metagha iyisisiya, na Yesu iwoneni bo, “Abawiiyeveveyana, imiise kirakii da touda mma. Toumii yobe aroba kanayoghanidi, tana tam, tana Mosis, bi tana Elaija.” ");
INSERT INTO aui_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wasina bi karekarewa irumaghatara da tupadi isowodi bi God nama karekarewa kamone iwona bo, “Mmkona tagu natugu iiyabo avinuwayuyuneni. Kowaiyaneni!” ");
INSERT INTO aui_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Rotomanina kivikivina sikitawiininogha bi getana iiyabo siyakitana, wasina Yesu kawagha nama. ");
INSERT INTO aui_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wasina koyama siyayoyo na Yesu iwonawiiyoyowanedi da awaki koya debane sikita, na gegha noko raghanine siyimaghamaghatarana. Bi patana da God yana Wiisuwona Tomoyina raboboma inageghomiiri, bi kate muriye na wawaya sinawonedi. ");
INSERT INTO aui_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na Yesu sikabisisireni da wawaya gesiyawonedina bi toudimani siyisisiya kabivivirana, “Awaki basuna Yesu iwona da raboboma geghomiirimagha?” ");
INSERT INTO aui_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wasina bi sivitarakiiyaneni bo, “Awaki kiiravine God yana gwara kana wiiyeveveyana damdi sawona da dagudagune Elaija inaveramagha bi muriye na God yana Wiivinevinegha Kiiwawona inapiika?” ");
INSERT INTO aui_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu iwonabodedi bo, “Noko wiisuwona, Elaija yinagho yapiika bi sawara tupadi yakabununagha da Keriso yana piikina kiiravine. Bi bada awaki kiiravine God warana meko sigirumi na bada yawonawona da tagu God yana Wiisuwona Tomoyigu sinivisi anakabikirakiiyeni bi sinitupaketowanegu? ");
INSERT INTO aui_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Iisuwonemi, Elaija nada ipiika bi wawaya yadi kayowana sibera touna biidi. Noko awaki itubugha na, naboni ware naghove waghata God warana sigirumina kamone touna kiiravine.” ");
INSERT INTO aui_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu kana kivikivina yadi 3 yawata koyama siveramagha siyowogha, na koroto ghamana sikitadi kivikivina turaturadi sigwagwaridi, bi gwara kana wiiyeveveyana damdi teya siyikawakereyana. ");
INSERT INTO aui_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Raghanina wawaya Yesu sikita, na sinokena kirakiiyeni bi sivera sinagho da sivikiikiiveni. ");
INSERT INTO aui_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kana kivikivina ivitarakiiyanedi bo, “Tami awaki kiiravine toudi teya kwiikawakereyana?” ");
INSERT INTO aui_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tomogha koroto kamone iwonabodeni bo, “Abawiiyeveveyana, kanuma berona irughu natugu kamone na gerubana inisisiya, na apiikeni tam biidi. ");
INSERT INTO aui_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bi raghanina kanuma berona yana maragata tomogha gisigisi kamone yadaguni, na yitavenayowoyeni tanave, bi ere kawapuropurona, nighona yitaragiigiiyeni, da yapatokii. Kam kivikivina avibabiidi da kanuma berona siyikanibuveni, bi gerubana siyaberana.” ");
INSERT INTO aui_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu iwonabodedi bo, “Agii da tami, gekoyigeruveguna! Nada mmko raghani gurina tagu tami teya tamakae! Raghani viya tagu yami vita anakawari? Tomogha gisigisi kopiikeni mabo!” Na sipiikeni touna biidi. ");
INSERT INTO aui_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bi raghanina kanuma berona Yesu ikita, na tomogha gisigisi inukeni da iviparoroni, na ibeku tanave bi ere kawapuropurona ivikuwamiwamira. ");
INSERT INTO aui_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu tomoyina tamananaki ivitarakiiyaneni bo, “Awaki raghanine mmko gubagina gwabine idagu?” Iwonabodeni bo, “Raghanina dodone bi irumaghatara. ");
INSERT INTO aui_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kanuma berona iwiini da iyirabobo na raghani ipeyari ibera da keyame ivitavenageeyeni bi rarime ivitavenayowoyeni. Bi meboda tam rubam, na kuyikanighughuvemii da kuyiwiitemii.” ");
INSERT INTO aui_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu iwoneni bo, “Metagha kuwona da, ‘Meboda tam rubamna?’ Iiyabo yigeruvegu, na rubana God bera tupadi kiiravine inabera!” ");
INSERT INTO aui_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yaininagha simira tamananaki ikwatu iwona bo, “Tagu iigeruvem. Bi yagu wiigeruwana geiyaragata, na kiwiitegu da inaragata kamogha!” ");
INSERT INTO aui_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Raghanina Yesu ikitada noko korotona sivera siyapiipiika, na kanuma berona ikini iwonaghakiyeni bo, “Tam kanuma berom, wawaya kwaberadi da tainadi sapota bi kate gesiyisisiyana, awonewonem da tomogha gisigisi kanibutaveni bi gekunarughukura mayenina!” ");
INSERT INTO aui_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kanuma berona irukwatu, bi tomogha gisigisi inuke kirakiiyeni, da ivikanibutaveni. Na kana kita ware sirage, bi wawaya korotodi nama siwona bo, “Touna irabobo!” ");
INSERT INTO aui_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na Yesu imana ikabi bi itaiyina wiigeghomiiri da imiiri. ");
INSERT INTO aui_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muriyena Yesu irughu bare kamove, na kana kivikivina toudi kawaghana wiikowoye, sivitarakiiyaneni siwona bo, “Awaki kiiravine toumii gerubana da kanuma berona kayikanibuvenina?” ");
INSERT INTO aui_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bi iwonedi bo, “Mmko kanuma berona naboni na, touda gerubana tanikanibuveni, wasina kiiravine memeda tanaruparina.” ");
INSERT INTO aui_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Wasina bi Yesu kana kivikivina teya noko kuburina sikuyoveni, da kubura Galili sivera rughuwoneni. Kana kivikivina iyiyevevedi na geiyakayoveni da wawaya siyakovi da touna noko kuburina kamone na iyawonawona bo, “Kagu aviya siniwaghasina da tagu God yana Wiisuwona Tomoyina wawaya mududi imadiye sinatoregu, bi kate toudi sinakasunuyigu, bi gabudara yadi 3 murine anageghomiiri magha.” ");
INSERT INTO aui_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Naboni ivisisiya, na yana wiiyeveveyana gegha siyakovi, na sinaghara da gesiyitarakiiyaneni. ");
INSERT INTO aui_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wasina bi Yesu kana kivikivina teya siveramagha Kaponiyamma na sirughu bare kamove, bi ivitarakiiyanedi bo, “Kedae awaki kiiravine koyigamowana?” ");
INSERT INTO aui_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Toudi sivikawapotapota, basuna kedae sivigamowana vivirana da kamodiye iiyabo kana waghawagha ghamana. ");
INSERT INTO aui_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu imakewiipikapika, bi yana apasol yadi 12 ikwatuwiitaghomidi sipiika, bi kate iwonedi bo, “Iiyabo yana wiina ininagho, na inatoreyowoyena mayeni bi initughura waghata da wawaya tupadi kiiravidiye inabagibagi.” ");
INSERT INTO aui_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Simira tana imana ikabi itainariya bi basudiye ikabiwiimiiri. Bi imana simira borinagha itaraghuni bi iwonedi bo, ");
INSERT INTO aui_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iiyabo kagu waghawaghae simira mmko naboni inakayowiiyayeni, na getouna kawagha bi tagu teya yakayowiiyayegu, bi iiyabo tagu yakayowiiyayegu, na gegha tagu kawagha iyakayowiiyayeguna, bi bada iiyabo iviporagu na yakayokayowiiyayeni.” ");
INSERT INTO aui_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bi Jon iwoneni bo, “Abawiiyeveveyana, toumii tomogha tana kakita kam waghawaghae kanuma beroberodi iyikanibuwana. Na kavigesiyeni da geinabera mayenina basuna touna gegha touda kwiinada.” ");
INSERT INTO aui_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na Yesu iwona bo, “Gegha konigesiyeni. Gerubana wawaya iiyabo kagu waghawaghae berakayowiiwiiyaka inabera bi katotawota kagu waghawagha inawonawiiberona. ");
INSERT INTO aui_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iiyabo gegha kada aviya na touda kwiinada. ");
INSERT INTO aui_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tagu iisuwonemi, memeda wawaya iiyabo wiiwiita gisina inaveremi, naboni rarima inighu bi inaveremi, na basuna tamina kagu kivikivina, na yana miisana kate gegha iniwapeni bi inakabi.” ");
INSERT INTO aui_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu ivisisiya wiikaru iwona bo, “Memeda iiyabo wawaya gisina tana ware mmko simirina naboni, tagu yigeruvegu bi inaberani da berone inarughu, na God kate aro berokirakiina inavereni. Memeda gegha naboni akima ghamana kanighone sayiratawani bi sitavenayowoyeni yegiiye na noko gegha aro ghamanana. ");
INSERT INTO aui_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yami yawa kokita yapora, memeda imam inaberam da berone kunarughu, na kasiyarayi. Imiise kirakii da imam tanagha bi kunarughu God yana wiikiiwawo kamone kunamakae, bi ibero kirakii da imam bata bi kunarughu keyama karakarasine, keyamina karata makewaghawaghasina. ");
INSERT INTO aui_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Bi memeda kayem inaberam da berone kunarughu, na kasiyarayi. Imiise kirakii da kayem tanagha bi kunarughu God yana wiikiiwawo kamone kunamakae, bi ibero kirakii da kayem bata bi sinitavena rughuvem keyama karakarasine. ");
INSERT INTO aui_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bi memeda matam inaberam da berone kunarughu, na kutupawiisi. Imiise kirakii da matam tanagha bi kunarughu God yana wiibadana kamone kunamakae, bi ibero kirakii da matam bata bi sinitavena rughuvem keyama karakarasine. ");
INSERT INTO aui_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Noko kuburina kamone, na miikopu wawaya sakamkam na gemeyani sinarukwana, bi keyamina gegha meyani inapekina. ");
INSERT INTO aui_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kagu kivikivina tupadi ruyagha vitadi sinabanana mekodi damidi ware keyama, bi mmkodi ruyagha kamodiye na inaberadi da sinamiise na yadi wiigeruwane sinimaragata, naboni ware yegii kam iyimetevina. ");
INSERT INTO aui_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yegii touna sawara miisena, bi memeda yana metewa maragasina inakovi, na gegha rubana tana bera da inayegii maghana. Memeda waghawagha ghamana kiiravine konigamowana, na tami naboni ware yegii yana metewa yakovina. Genaboni konaberana, bi kobera da kam yegiima teya yatawoghana - nuwaruririye komake patapata.” ");
INSERT INTO aui_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu Kaponiyam ikuyoveni, bi inagho Jiudiya kubure da Jodan rarimina itowawoneni inagho raghani matana nawane. Bi wawaya korotodi touna biidi sipiikamagha, na nonowa iyaberaberana naboni iyiyevevedi. ");
INSERT INTO aui_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Perisis mududi siwiini da siyikayetayi, na sipiika touna biidi bi sivitarakiiyaneni bo, “Da yada gwara yiwaghasina da tomogha wavinena rubana iniyakiri?” ");
INSERT INTO aui_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iwonabodedi bo, “Mosis gwara iveremina kamone awaki iwoneni?” ");
INSERT INTO aui_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Toudi siwona bo, “Mosis yana gwara iviwaghasina da tomogha wiiyakira sisiyina inagirumi bo, ‘Gegha ayawiiwiinimna, kunaghotaveyana,’ bi sisiyina igirumina wavinena inavereni bi muriye iniporataveni.” ");
INSERT INTO aui_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bi Yesu iwonabodedi bo, “Tami nuwanuwami gegha siyatamotatarana bi gayamimi siviakima, noko biidi Mosis mmko gwarana igirumi tami kiiravimiye. ");
INSERT INTO aui_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bi konoghosi da dagudagune, raghanina God wawaya iberadi na, ‘Tomogha da wasike iberadi.’ ");
INSERT INTO aui_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Na tomogha tamananaki da sinananaki inakuyovedi, bi inanagho wavinena teya sinikapudi sinamakae, ");
INSERT INTO aui_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bi yadi bata na ware tubugha tanagha.’ Na gegha muriye yadi bata bi toudi tanagha. ");
INSERT INTO aui_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bi awaki God ikasiwiikapu, na gegha iiyabo inibogabogaedina.” ");
INSERT INTO aui_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Muriye siveramagha bareye, na kana kivikivina mmko sisiyina kiiravine sivitarakiiyaneni. ");
INSERT INTO aui_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu iwonabodedi bo, “Memeda tomogha wavinena yiyakiri bi wasike bogae yarawayi, na wavinena katamanina yitutuwiiyogho bi God matane na bera berona. ");
INSERT INTO aui_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kedana mayimayiyine, memeda wasike moghanena yiyakiri bi tomogha bogae yarawayi, na moghanena katamanina yitutuwiiyogho.” ");
INSERT INTO aui_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wasina wawaya mududi ededa sirutayina sipiika Yesu biidi da imana debadiye iyatoura bi iyarupari da God iyimiiseyedi, bi kana kivikivina taghunudinaki sivigesiyedi. ");
INSERT INTO aui_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu mmko ikitana nuwanuwana ipughu bi kana kivikivina iwonedi bo, “Ededa kokuyovedi sinapiika kurigu, gekonitara babaranedi, basuna wawaya mmkodi ededa naboni na God yana wiikiiwawo kamone sinamakae. ");
INSERT INTO aui_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iisuwonemi, memeda wawaya tana gegha iyinuwamiise da God yana wiibadana iniwaghasineni naboni mmkodi ededidi sabera, na kate gegha meyani God yana wiikiiwawo kamone inamakena.” ");
INSERT INTO aui_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wasina bi ededidi iyouna da manonone ivimakedi, bi imana debadiye itoura bi irupari da God iyimiiseyedi. ");
INSERT INTO aui_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wasina, noko raghanine Yesu igeghomiiri iyanono na kedae, tomogha tana ivera ipiika da naghone ivituwapore oghogheyana bi iyitarakiiyaneni bo, “Abawiiyeveveyana miisem, awaki anabera da yawa makewaghawaghasina anakabi?” ");
INSERT INTO aui_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bi Yesu iwoneni bo, “Awaki kiiravine kuwonegu da miisegu? Gegha tana iiyabo miisena, wasina God kawagha miisena. ");
INSERT INTO aui_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wasina, yam wiitarakiiyana kiiravine, na God yana gwara nada kwakovidi: ‘Gegha kunakasunugha; gekamkawakapu kunituwiiyoghona; gekunayapina; gekwiinam wiiyabama kuniwawu beroveni; gewiiyabama wawaya yadi moura kunayouna; tamamnaki da sinamnaki kabikarawayedi.’” ");
INSERT INTO aui_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bi tomoyina iwona bo, “Abawiiyeveveyana, raghanina dodoguve da patana kata, mmkodi gwaradi akivikivina.” ");
INSERT INTO aui_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bi Yesu tomoyina iyakitakita na ivinuwayuyuneni na iwona bo, “Bera tanagha patana isiwana. Kunagho da yam moura kunigimona bi manena moyaka kuveredi, bi yam miisana na kate abame God gwabinama kunakabi. Wasina naboni kunabera murine, na piika kunakivinigu.” ");
INSERT INTO aui_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tomoyina imoura kirakii na geiyawiini da yana moura iyavereyana tavetaveyana, na raghanina mmko sisiyina iwaiyana na ivinuwapoya bi ere nuwavisina inagho. ");
INSERT INTO aui_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wasina Yesu ikita wiipata bi kana kivikivina iwonedi bo, “Ipiropiro kirakii da moura wawayidi sinaveremayedi bi God siniwaghasineni da inibadedi.” ");
INSERT INTO aui_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kivikivina yana sisiya kiiravine sivisokovena kirakiiyeni. Bi Yesu iwonena mayedi bo, “Natunatugu, ipiropiro kirakii da wawaya sinaveremayedi bi God siniwaghasineni da inibadedi. ");
INSERT INTO aui_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ipiropiro da ribiribi ghamana kana waghawagha kamel inobu mata bonayine inarughuwona, bi bada ipiropiro kirakii da tomogha moumourina iniwaghasina da yana yawa God inibadeni.” ");
INSERT INTO aui_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kana kivikivina sinokena kirakiiyeni bi toudimani sivitarakiiyana kabivivirana, “Meboda naboni, na iiyabo bada yawa makewaghawaghasina inakabi?” ");
INSERT INTO aui_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ikitadi bi iwona bo, “Wawaya gegha rubana siniyawii mayedina, bi God na wasina, basuna touna bera tupadi rubana inabera.” ");
INSERT INTO aui_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bi Pita iwona bo, “Wasina, bada toumii metagha? Yama moura nada waghata kakuyowana bi tam kakivinim.” ");
INSERT INTO aui_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu iwona bo, “Wiisuwona awonewonemi, memeda iiyabo yana bare, warewaresina, nughunughuna, sinananaki, tamananaki, natunatuna bo kana tarana inakuyowana da inakivinigu bi wara miisena tagu kiiraviguve wawaya mududi inawonedi, ");
INSERT INTO aui_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na God miisana ghamana debane inatoremayeni bi inavereni mmko yawane. Na naboni bare, warewaresina, nughunughuna, sinananaki, natunatuna da tarana inayouna, bi wawaya bada sinikayotaketowaneni, bi raghani yapiipiika, na yawa makewaghawaghasina inakabi. ");
INSERT INTO aui_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bi iiyawogha kata korotodi sivinagho, na noko raghanine na sinimuri, bi iiyawogha kata korotodi sivimuri na noko raghanine, na sininagho.” ");
INSERT INTO aui_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Toudi kedagha sipepewa siyageegee Jerusalemma, na Yesu ivinagho bi kana kivikivina sivimuri. Na sikabinokeni, bi wawaya iiyawogha murigha siyakivikivini na sinaghara. Wasina bi kivikivina yadi 12 ikabirenamayedi, bi iwonedi da mekodi beradi tupadi raghani muriye touna biidi sinatubugha ");
INSERT INTO aui_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","na iyawonewonedi bo, “Kowaiyana, tageegee Jerusalemma, bi nama wawaya tana, tagu God yana Wiisuwona Tomoyina kagu puke inakabi, prist babadidi da gwara kana wiiyeveveyana damdi biiyadi. Toudi sinigiugerogerora da inarabobo bi dam wiibata sinirouveredi. ");
INSERT INTO aui_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sininamayeni, sinakanuni da sinakwapuni bi sinakasunuyi. Bi gabudara yadi 3 murine na raboboma inageghomiiri magha.” ");
INSERT INTO aui_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Muriye na Zebedi natunatuna, Jemes da Jon sipiika Yesu biidi siyawonawona bo, “Abawiiyeveveyana, awaki kanibabiim na kunabera, yama kayowana da tam kiiravimiiye kunabera.” ");
INSERT INTO aui_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na ivitarakiiyanedi bo, “Yami wiina awaki anabera kiiravimiye?” ");
INSERT INTO aui_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Siwonabodeni bo, “Raghanina yam wiikiiwawo gabudarine wawaya kuniibadedi, na kuniwaghasinemii da yawata tani makerereghana, tana katiiyamve bi tana dugemve.” ");
INSERT INTO aui_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bi Yesu iwonedi bo, “Gekoyakovi da awaki kiiravine kwiibaba. Tami rubami, ananiuna na redunama konanina, bo rubami kona babataito naboni ware tagu anababataitona?” ");
INSERT INTO aui_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bi siwoneni bo, “Toumii rubamii!” Bi Yesu iwonedi bo, “Redu ananiuna na konanina, da konababataito naboni tagu anababataitona. ");
INSERT INTO aui_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bi gegha rubana anavinegha da tani makerereghana, da iiyabo katiiyaguve inamake bi iiyabo dugeguve. God iiyawogha ivineyidi na nokodi gawara inaveredi.” ");
INSERT INTO aui_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Raghanina kana kivikivina yadi 10 mmko siwaiyaneni, na nuwanuwadi sipughu Jemes da Jon biidi. ");
INSERT INTO aui_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na ikwatuwiitaghomidi sipiika bi iwonedi bo, “Tami nada kwakovi da iiyawogha kubuna damdi yadi kiikiiwawo, bi yadi kayowane sinibada, na nokodi babada wawaya wiitupaketowane sakoyayidi. ");
INSERT INTO aui_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na tami, genaboni konigubegubeyana. Bi iiyabo yana kayowana inibada, na touna wiibagubagurana. ");
INSERT INTO aui_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bi iiyabo yana kayowana ininagho, na inabera da touna wawaya tupadi yadi bagubagurana. ");
INSERT INTO aui_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Berana mayimayiyina, Wiisuwona Tomoyina gegha iyapiika da wawaya touna sinabigenina bi ipiika wawaya inabigedi, da nuwasisire inarabobo bi mmkona touna miisana wawaya korotodi kiiravidiye.” ");
INSERT INTO aui_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wasina bi Jeriko kwanatune sinokanibu. Bi muriye, Yesu kana kivikivina teya da koroto ghamana Jeriko siyakuyokuyoveni, na tomogha tana matapotapotana kana waghawagha Batimiyas, Timias natuna, keda riirine iyamakamake bi iyipepeyana. ");
INSERT INTO aui_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Raghanina iwaiyana da Yesu Nasaret tomogha iyapiipiika, na irukwatu iwona bo, “Yesu, Deivid natuna kuvinuwanuwaghanegu!” ");
INSERT INTO aui_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wawaya korotodi sikini bi siwoneni bo, “Kuviraborabobo!” Bi ivikawakeke irukwatu gwaru, “Deivid natuna, kuvinuwanuwaghanegu!” ");
INSERT INTO aui_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Na Yesu ivituramiiriyeni bi iwona bo, “Kokwatuveni inapiika mabo.” Na tomogha matapotapotana sikwatuveni siwona bo, “Kinuwamiise! Geghomiiri! Yakwatukwatuvem.” ");
INSERT INTO aui_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na yana sowo ivirupiitaveni, igeghomiiri ivikapoka bi ipiika Yesu biidi. ");
INSERT INTO aui_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Wasina ivitarakiiyaneni bo, “Awaki yam wiina, kiiravimve anabera?” Tomogha matapotapotana iwonabodeni bo, “Abawiiyeveveyana, akayokayoveni da anakitamagha.” ");
INSERT INTO aui_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu iwoneni bo, “Yam wiigeruwana iviyawiim, kunagho.” Yaininagha ikitarunagha bi kedagha Yesu ikivini. ");
INSERT INTO aui_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Raghanina Yesu kana kivikivina teya Jerusalem siyitutukabikabina, Betapage da Beteni kwanatudi riridiye na sipiika koya kana waghawagha Oliv Koyane. Bi kana kivikivina bata iviporadi sivinagho ");
INSERT INTO aui_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","bi iwonedi bo, “Konagho korughu noko meyagiina naghomiye. Raghanina konanokanibu name, na donki wotuna konabanani saghiratawani getana iiyabo naghove iyagerutowoyina. Korupami bi korutayini kopiika mabo. ");
INSERT INTO aui_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Meboda wawaya sinitarakiiyanemi bo, ‘Awaki kiiravine mmko koberabera?’ Na kowonedi bo, ‘Bada yawiiwiini bi kate inipora inaveramagha.’” ");
INSERT INTO aui_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wasina bi sinagho da donki wotuna sibanani, maghatare kedae, bi bare tana matamketana ririne koghore saghiratawani bi raghanina siyaruparupami, ");
INSERT INTO aui_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","na wawaya mududi riridiye siyamiimiirina sivitarakiiyanedi bo, “Awaki kiiravine donki wotuna koruparupami?” ");
INSERT INTO aui_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na toudi metagha Yesu iwonedi, na naboni wawaya siwonedi, na siviwaghasinedi da sirutayini. ");
INSERT INTO aui_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wasina donki wotuna sirutayini sipiika Yesu biidi bi yadi sowo sivitavenageegeeyana kubukiine, bi Yesu debane imakegae. ");
INSERT INTO aui_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bi wawaya korotodi yadi sowo sirutatara keda debane sikepana bi mududi kii ghabighabi ere rugurugudi kwabuma siyaragha na kedae sikepana. ");
INSERT INTO aui_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bi wawaya naghone da iiyawogha murine siyakivikivini, na sikarayewoveni bo, “Hosanna! Tam, God kana waghawaghae kwapiipiika na kakabekabepepim. ");
INSERT INTO aui_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nosida Deivid yana kunukunuma tam kwapiipiika kunibademii na kakabekabepepim! God abame makamakena kakabekabepepi!” ");
INSERT INTO aui_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu, Jerusalemma inokanibu na inagho God yana bareye irughu, bi sawara tupadi nama ikita yapoyaporidi. Bi noko murine, nada iravidi na touna da kana kivikivina yadi 12 yawata sikanibu sinagho Betenima. ");
INSERT INTO aui_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Raghani ibori bi Yesu kana kivikivina teya Beteni sikuyoveni siyaveravera magha Jerusalemma, na vitonana damina ikabi. ");
INSERT INTO aui_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Rabarabama ikitawiivera da kiiuwa kiina kana waghawagha kogheya inumo na ikita, na inagho iyakita da iuwagha bo gegha. Bi raghanina ipiika kiine, na ikita da rugurugu kawanagha, basuna gegha kogheya kana iri. ");
INSERT INTO aui_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na kogheya kiina iwoneni bo, “Gegha tana iiyabo uwam inakam towogha mayenina!” Na kana kivikivina mmko sisiyina siwaiyaneni. ");
INSERT INTO aui_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Raghanine Jerusalemma sinokanibu, na Yesu irughu God yana bare garina kamone bi wiigimona da gimogimona damdi, idagu iyarurukwavinidi siyakanikanibu. Bi mane wiikabivereyana damdi yadi kemakema da iiyawogha ayabo siyigimona, na yadi makamake ivikouririghana, ");
INSERT INTO aui_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","bi getana iiyabo iyiwaghasineni da wiigimona sawaridi God yana bare garina kamonagha iyakawara iyarughuwonana. ");
INSERT INTO aui_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bi iviyevevedi iwona bo, “God wonana buka kamone nada sigirumina iwona da, ‘Yagu Bare na sinakwatuveni da touna pari barena, wawaya damvedamve kiiravidiye, bi tami kobera da naboni yapiyapi damdi yadi kowokowogha.’” ");
INSERT INTO aui_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na prist babadidi da gwara kana wiiyeveveyana damdi mmko siwaiyaneni. Na sidagu keda siyininogha da Yesu siyakasunuyi. Toudi sinaghareni, basuna koroto tupana yana wiiyeveveyana siyisokoveni. ");
INSERT INTO aui_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wasina bi ravidiye, na kana kivikivina yawata Jerusalem sikuyoveni. ");
INSERT INTO aui_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Raghani ibori didibara wote, kedagha sipepewa siyanono Jerusalemma, na kogheyina kiina sikita. Touna i rabobo iyowogha inagho ramramne. ");
INSERT INTO aui_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita inoghosi da awaki itubugha na Yesu iwoneni bo, “Abawiiyeveveyana, kukita, kogheya kiina kuvimagi na irabobo!” ");
INSERT INTO aui_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu iwonabodedi bo, “God kovigeruveni! ");
INSERT INTO aui_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iisuwonemi, da iiyabo mmko koyana inawoneni bo, ‘Geghomiiri bi yegiiye kitavenayowoyena mayem,’ bi nuwanuwana kamone gegha ininuwabata, bi inigeruwana da awaki iwona na inatubugha, na God inabera kiiravine. ");
INSERT INTO aui_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yana basuna mmko kiiravine awonewonemi: raghanina kwarupari bi sawara kiiravine kwiibaba, kigeruwana da nada kukabi, na awaki kiiravine kunibaba na kunakabi. ");
INSERT INTO aui_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Bi raghanina kwageghomiiri da kwarupari, bi iiyawogha berona tam biidi sibera na kunanoghotatavedi, na noko tamamnaki abame kate yam tamumu inanoghotatavedi.” ");
INSERT INTO aui_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu kana kivikivina yawata Jerusalemma siverakanibu magha, bi raghanina God yana bare garina kamonagha iyapeepewa, na prist babadidi, God yana gwara kana wiiyeveveyana damdi da kwanatu kana dogara sipiika Yesu biidi ");
INSERT INTO aui_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bi sivitarakiiyaneni bo, “Awaki maragasina kukabi na mmkodi bera kubera? Bi iiyabo mmko maragasina iverem?” ");
INSERT INTO aui_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iwonabodedi bo, “Wiitarakiiyana tana anawonemi, bi tami wonabodeyana konaveregu, na anawonemi da awaki maragasine mmkodi bera abera. ");
INSERT INTO aui_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kowonegu, Jon mema yana maragata ipiika na iyabaabataito: God gwabinama bo wawaya?” ");
INSERT INTO aui_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na wiikawakereyana toudimani kamodiye sidaguni, “Awaki tanawoneni? Memeda tanawona bo, ‘God gwabinama,’ na inawona bo, ‘Awaki kiiravine Jon gekoyigeruvenina?’ ");
INSERT INTO aui_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bi meboda tanawona bo, ‘Wawaya gwabidima’ na kate bi koroto sinanuwatupa touda biiyadi.” (Na toudi koroto sinagharedi, kiiravine wawaya tupana sinoghosi da Jon, na peroveta waghata). ");
INSERT INTO aui_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Na yadi wonabodeyana Yesu biidi na, “Toumii gegha kayakovina.” Na Yesu iwonedi bo, “Wasina gegha anawonemi, da awaki maragasine mmkodi bera abera.” ");
INSERT INTO aui_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wasina bi Yesu miibama iwonedi bo, “Tomogha tana kwabuve wain iwavi. Igari wiikenavivireni, dogu tana ibani wain kana ruruboto kiiravine, da wiikighukighu kana bare iyoghani. Bi wawaya iyouna da yana kwabuve ivikoyayidi da siyigimogimoneni, bi iwagawaga inagho takubure. ");
INSERT INTO aui_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Raghanina kabipura gabudarina ipiika, na kwabu wiibadana yana wiitamariyana tana ivipora inagho kwabu bagibagi damdi biiyadi, da kanareregha kabipura kamonama iyakabi. ");
INSERT INTO aui_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bagibagi damdi, wiitamariyana siburavi, da sigudani, bi ima kawanagha sivipora iveramagha. ");
INSERT INTO aui_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wasina wiibadana yana wiitamariyana tana ivipora; bi kwabu bagibagi damdi gayamina sirouvi bi siwona wiisinimayamayayi. ");
INSERT INTO aui_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na yana wiitamariyana tana bada ivipora, na touna bada sikasunuyi; bi wiitamariyana mududi kedana mayimayiyina siviberaberowanedi, mududi sirouwa bi mududi sivikasunughana. ");
INSERT INTO aui_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kwabu wiibadana wawaya tanagha iyamakamake da iyipora na tomoyina touna wosina natunuwana. Tughura waghate, na natuna ivipora inagho bagibagi damdi biiyadi bi iwona bo, ‘Anoghonoghosi da natugu sinakabikarawayeni.’ ");
INSERT INTO aui_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bi gegha, nokodi bagibagi damdi toudimani sivisisiya vivirana bo, ‘Mmkona kwabu wiibadana natuna. Kopiika, tana kasunuyi, bi yana kwabu na tani rapeneni.’ ");
INSERT INTO aui_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na tomoyina natuna siburavi bi sikasunuyi da tubuyina sivitavena kanibuveni kwabu garina kubune. ");
INSERT INTO aui_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Awaki, bada kwabu wiibadana inabera? Inapiika da bagibagi damdi inikasunughana, bi woudi imadiye yana kwabu inatore. ");
INSERT INTO aui_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wiisuwona, God wonana kamone nada kokabiyavidi da iwona bo, ‘Akima meko abayoghayoghana sivisinighiighiiyeni, na kata iviakima kiitowana; ");
INSERT INTO aui_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mmko berana Bada ibera, ayagha matadae yinuwakayowana.’” ");
INSERT INTO aui_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jius babada siberatowoyi da siyaburavi, basuna sakovi da Yesu mmko iyisisiyeni na toudi kadi miiba. Bi gegha da, koroto sinagharedi na sikitawiitaveni bi sinagho. ");
INSERT INTO aui_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muriye na Jius babadidi, Perisis da Herod turaturana mududi siviporadi sinagho Yesu biidi da wiitarakiiyanama siyikayetayina. ");
INSERT INTO aui_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sipiika bi siwona bo, “Abawiiyeveveyana, kakovi da wonawaghata kwiisisiyedi, bi wawaya awaki siyanoghonoghotana gekuyinuwapoyedina. Gegha kuyanoghonoghosi da kadi waghawagha ghamadi, bi tam wiisuwone God yana keda kwiiyeveveyana wawaya biiyadi. Kuwonemii, wasina da teks tani miisana Sisa biidi bo gegha?” ");
INSERT INTO aui_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bi iyakovi da siyaberaberatowoyi da siyiyabeni na iwonedi bo, “Awaki kiiravine tagu kwiikayekayegu? Dinarias tana kopiikeni anakita.” ");
INSERT INTO aui_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na dinarias tana sikabi sivereni, bi ivitarakiiyanedi bo, “Mmkona iiyabo gubana da kana waghawagha?” Toudi siwona bo, “Sisa.” ");
INSERT INTO aui_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na Yesu iwonedi bo, “Wasina, awaki Sisa rapene na Sisa kovereni, bi awaki God rapene na God kovereni.” Bi yana sisiya sivisokoveni. ");
INSERT INTO aui_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusis iiyawoghana sawona da wawaya gegha raboboma sinageghomiiri. Na mududi sipiika Yesu biidi bi siwona bo, ");
INSERT INTO aui_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Abawiiyeveveyana, Mosis mma naboni gwara igirumi kiiravimiiye: Memeda tomogha inarabobo da wavinena inakuyoveni bi natunatuna gegha, na tomoyina waresina tana kwaburina inarawayi da sinituwa, bi nokodi ededidi na naboni waresina raborabobona natunatuna. ");
INSERT INTO aui_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Raghani tana tomotomogha rakarakadi yadi 7. Iyarokona wasike irawayi, bi gesiyituwa bi irabobo. ");
INSERT INTO aui_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na tiinaru murine kwaburina irawayi, gesiyituwa bi irabobo. Berana mayimayiyina tomogha kana wiiaroba biidi itubugha inayi bi irabobo. ");
INSERT INTO aui_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nokodi rakarakadi yadi 7 wasikena sirawayi, da gesiyituwa bi sirabobo. Tughurine, na wasikena irabobo. ");
INSERT INTO aui_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kata, raghanina raborabobodi tupadi geghomiiri magha gabudarine sinageghomiiri, na touna iiyabo wavinena? Basuna yadi 7 tupadi sirawayi.” ");
INSERT INTO aui_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu iwonabodedi bo, “Tami yami noghota sisiwana! Yana basuna God wonana bo yana maragata gekoyakovina. ");
INSERT INTO aui_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Raghanina wawaya raboboma sinageghomiiri, na toudi naboni aneyaneya abame bi gegha sinanayina. ");
INSERT INTO aui_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bi kata, wawaya raboboma sageghomiiri magha kiiravine, na memeda nada kokabiyavi da awaki Mosis yana bukae igirumi, raghanina God irumaghatara touna biidi kiikiiruku iyakarakarasina kamone. Name God, Mosis iwoneni bo, ‘Tagu, Abraham yana God bi Aisik yana God bi Jeikap yana God.’ ");
INSERT INTO aui_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na noko kiiravine na tanakovi da God, na gegha wawaya raborabobodi yadi God, bi wawaya yawayawiidi yadi God. Na yami noghota tupadi siwasiwanidi.” ");
INSERT INTO aui_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","God yana gwara kana wiiyeveveyana tana ipiika, bi Yesu da Sadusis naboni siyikawakereyana, na iwaiyanedi. Iwaiyana da Yesu iwonabodena wiimasiyedi, na ivitarakiiyaneni bo, “God yana gwara meko iragata kirakii?” ");
INSERT INTO aui_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu iwona bo, “Gwara meko igekirakii na mmko: ‘Isrel dammi, kowaiyana! Bada yada God, touna kawagha Bada. ");
INSERT INTO aui_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bi God nuwanuwam tupana, kanumim tupana, yam noghota bi yam maragata tupadima kinuwayuyuneni.’ ");
INSERT INTO aui_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gwara kana wiibata ghamanakina, na mma naboni: ‘Turaturam kuvinuwayuyunedi, mayimayiyina tammani kwiinuwayuyunemna.’ Mmkodi gwaradi yadi bata na siragata kirakii, genaboni mududi.” ");
INSERT INTO aui_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Gwara kana wiiyeveveyana tomoyina iwona bo, “Abawiiyeveveyana, kuvisisiya wiimasi, wiisuwona da God tanagha, bi gegha god tana nama ririnena. ");
INSERT INTO aui_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","God nuwanuwada tupanama, yada noghota tupanama bi yada maragata tupanama taninuwayuyuneni. Bi turaturada taninuwayuyunedi mayimayiyina naboni toudamani tiinuwayuyunedana. Mmkodi gwara yadi bata kabisisiredi na sigekirakii gegha naboni ribiribi tagibudi da God biidi tasuwarana bi kate suwara mududi.” ");
INSERT INTO aui_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu iyakovi da tomogha noghota miisenama iwonabodeyana, na iwoneni bo, “Tam gegha iyarabaraba da God yana wiibadane kunarughu.” Na wawaya sinaghara da getana iiyabo wiitarakiiyana mududi iyawonenina. ");
INSERT INTO aui_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Raghanina Yesu, God yana bare garina kamone iyiyeveveyana, na iwona bo, “Awaki kiiravine Gwara kana wiiyeveveyana damdi sawona da Keriso na Deivid tubuna? ");
INSERT INTO aui_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kanuma Kabikabikuwayina Deivid ivinuwasisiri, na iwona bo, ‘Bada God yagu Bada iwoneni, “Mabo ririguve kumakekira bi kam aviya anakabidi da kaye rogumve anatoredi.” ’ ");
INSERT INTO aui_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deivid tounamani Keriso ikwatuveni da yana Bada. Na metagha konoghonoghosi, Keriso na touna Deivid tubuna bo?” Koroto ghamana Yesu yana sisiya nuwamiiseye siyawaiwaiyaneni. ");
INSERT INTO aui_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu iyiyevevedi, na iwona bo, “Kokita yapori da gwara kana wiiyeveveyana damdi gesiniyabemina. Tarasowo rukarukaruwanidi siniyagha bi sinapepewa, bi yadi wiina wawaya kabikarawaye sinikiikiivedi wiigimona gawaridiye. ");
INSERT INTO aui_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bi yadi wiina makamake gawaridi miisedi kabepepa baredi kamodiye bi kate babada ghamaghamadi yadi gaware sinamake, poragha raghanidiye. ");
INSERT INTO aui_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bi sarupari wiiguriguri na wawaya sanaghosi da toudi kabikabikuwayidi, bi kwabukwabura yadi bare sakita kirorovedi na siyabedi da baredi sirapeneyana. Mmkodi wawayidi, na God aro ghamanakina inaveredi.” ");
INSERT INTO aui_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu suwara kabomidi gawarina riridiye imakekira God yana bare kamone, bi wawaya metagha mane siyatutoura na iyaruruwiitetedi. Wawaya moumouridi korotodi mane peyaridi siyatutoura. ");
INSERT INTO aui_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wasina bi kwabura moyamoyakina ipiika da kopa mane busobusodi bata, itourarughuwana suwara kabomina kamone. Bi mmkodi manedi yadi maragata damina igisikirakii. ");
INSERT INTO aui_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na Yesu kana kivikivina ikwatuvedi sipiika bi iwonedi bo, “Wiisuwona awonewonemi, mmko kwaburina moyamoyakina puyo ghamanakina itore, gegha naboni wawaya mududi. ");
INSERT INTO aui_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yana basuna, mmkodi wawaya moumouridi tupadi yadi moura ghamadi bi pinimidigha sivereyana, bi noko kwaburina bagune moyamoyakina, bi awaki kana makekawakawa na tupana itore.” ");
INSERT INTO aui_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wasina raghanine Yesu, Bare Kabikabikuwayina garina iyakuyokuyoveni, na kana kivikivina tana iwona bo, “Abawiiyeveveyana, kukita mmkodi bare warawaratetedi, da mmkodi akima ghamanakidi.” ");
INSERT INTO aui_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu iwona bo, “Nokodi bare ghamanakidi kwakitakita! Na raghani murine na Jius kadi aviya tupana siniberodi. Gegha akima tana kwiinana debane inamakena.” ");
INSERT INTO aui_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wasina God yana bare bi nawane Oliv koyana debane Yesu iyamakamake, na Pita, Jemes, Jon da Andru wiikowoye sivitarakiiyaneni, ");
INSERT INTO aui_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kuwonemii, meyani mmkodi beradi sinatubugha. Awaki matakirina iniyeveveyana da mmkodi bera pinimina bi sinatubugha?” ");
INSERT INTO aui_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na iwonedi bo, “Kokita wiimasi da gegha iiyabo iniyabemina. ");
INSERT INTO aui_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tomotomogha korotodi waghawaghaguve sinapiika sinawona bo, ‘Tagu na Keriso!’ na wawaya korotodi siniyabedi. ");
INSERT INTO aui_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bi raghanina wiirouwa kwarituna bo aviya waradi rabarabae konawaiyana na gegha konanagharana. Mmkodi beradi sinatubugha naghove, bi noko geraghani damona. ");
INSERT INTO aui_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dam sinageghomiiri da siniaviya vivirana bi kiiwawo sinageghomiiri da sinirouwa vivirana. Nukenuke kubura bogaebogae sinatubugha da kate gomara. Mmkona dagudaguna kawagha, ware wasike roperopeyina wiituwa sinivisina dagudaguna yakabikabina naboni. ");
INSERT INTO aui_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tami wosina kokoyagha yaporimi. Sinakabimi bi sinitupawamiwamiremi da bada kabepepa barediye sinavidividimi. Bi tami kagu kivikivina kiiravine na sinakabimi da sinatupemi bi kiikiiwawo naghodiye konamiiri da wara miisena konawonedi. ");
INSERT INTO aui_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bi dagudagune na wara miisena God yana wiibadana kiiravine tami da iiyawogha sigeruvegu na konadimeni damve damve biiyadi, muriye da damona inapiika. ");
INSERT INTO aui_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bi raghanina kami aviya sinakabimi da sinitupawamiwamiremi, na gekoninuwapoya yaininagha da metagha konisisiya. Gegha tami yami noghotama konisisiyana bi Kanuma Kabikabikuwayina tamiye inisisiya na awaki inaveremina kovisisiya. ");
INSERT INTO aui_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tomotomogha sinageghomiiri da warewaresidi sinavereyana bi kadi aviya sinikasunughana, bi tamadam mayimayiyina natunatudi biidi sinabera. Ededa taghunudinaki siniaviyedi bi sinavereyana da kadi aviya sinikasunughana. ");
INSERT INTO aui_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tami kagu kivikivina kiiravine na wawaya tupana sinasinighiiyemi. Bi iiyabo inamiiri kikita da damone na God iniyawiini.” ");
INSERT INTO aui_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Bi raghanina konakita da awaki peroveta Deniyel ivisisiyeni meko bera tupana yiberodi, na gawara kabikabikuwayine inamiiri, meme gewasina da iyamiirina (Kabiyawa wawayim: Kunuwagiureni mmko awaki basuna). Wasina nokodi Jiudiya kubura kamone samakamake na sinaverataveyana koyae. ");
INSERT INTO aui_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wawaya bare kubune na geinayowogha inarughu bare kamone yana sawara inayounana, ");
INSERT INTO aui_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","bi bada, iiyabo yana kwabuve yabagibagi, na geinaveramagha bareye da kana tarasowo inakabina. ");
INSERT INTO aui_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bi noko raghanine na kabikwarakwara ghamanakina wasiwasike biiyadi iiyawogha siropeya da pepeya sisusuna. ");
INSERT INTO aui_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","God biidi korupari da mmkodi beradi gegha boduve sinatubughana! ");
INSERT INTO aui_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yana basuna noko raghanine na kabikwarakwara ghamanakina nama. Bi raghanine God kubura ibera na kabikwarakwara ghamadi roro nokodi naboni gesiyatubughana, patana da kata bi raghani muriye kate gegha naboni sinatubugha maghana. ");
INSERT INTO aui_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na Bada, nokodi gabudaridi iruwiitupo. Bi memeda gegha iyayaraghana, wawaya kate gesiyayawana. Bi iiyawogha ivineyidi na noghosidiye, touna mmkodi gabudaridi iyaragha. ");
INSERT INTO aui_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Noko raghanine, memeda wawaya tana inawonemi bo, ‘Keriso mmakatanina, kokita!’ bo, ‘Vinikatanina!’ gekonigeruvenina. ");
INSERT INTO aui_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yana basuna Keriso wiiwiiyaba da peroveta wiiwiiyaba sinarumaghatara bi berakayowiiwiiyaka da matakira sinabera, bi sinaberatowoyi da God yana wiivenevinegha wawayidi siniyabedi, da sinigeruvedi. ");
INSERT INTO aui_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Na kokabunagha, bi kokoyagha mayemi! Bera tupadi kadi sisiya awonena katamanemi, muriye da raghanina inapiika.” ");
INSERT INTO aui_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bi kabikwarakwara ghamanakidi gabudaridi sinakovi, muriye na gabudara raragha inakabitore bi matu bada gegha inikonakona. ");
INSERT INTO aui_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kewokewo abame sinaririgha, bi abama kana sawara mududi maragasidi sininukenuke. ");
INSERT INTO aui_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bi noko raghanine wawaya sinakita da God yana Wiisuwona Tomoyina inarumaghatara, uuwa debadigha inapiipiika, maragata ghamana teya da ere kinivina. ");
INSERT INTO aui_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wasina bi aneyaneya iniporadi kubura tupane da God yana wiivinevinegha wawayidi sinituwiitaghoma kubura damone da inanagho abama damone.” ");
INSERT INTO aui_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wasina Yesu iwona bo, “Konoghosi awaki itubugha kogheya kiina biidi da akowa nokove konakabi. Raghanina ragharaghana sameyu da samatagha bi numonumo sarumaghatara, na kwakovi noko gogo raghanina yapiipiika. ");
INSERT INTO aui_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mayimayiyina, raghanina konakita da mmkodi beradi sinatubutubugha, na konakovi da God yana Wiisuwona Tomoyina yana piikina inoratu, bi ikabunagha da inidagu. ");
INSERT INTO aui_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iisuwonemi, mmko kimsina wawayimi tupana gekonarabobo patana da mmkodi beradi sinatubugha naghove. ");
INSERT INTO aui_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Abama da kubura sinamomogha, bi wonagu kate gegha inamomoghana.” ");
INSERT INTO aui_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Getana iiyabo iyakovi, da meyani noko gabudarina bo raghanina inapiika, gegha aneyaneya abame, bo Natu iyakovina; Tamada God kawagha iyakovi. ");
INSERT INTO aui_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kokabunagha da kokoyagha mayemi, gekoyakovi da meyani noko raghanina inapiika! ");
INSERT INTO aui_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ware tomogha tana yana bare yakuyoveni yawagawaga yanagho takubure. Na wiitamariyana imadiye yana sawara yatoura bi tatadigegha yadi bagibagi yaveredi. Bi iiyabo matamketa yakoyakoyayi na yawoneni da inikighukighu. ");
INSERT INTO aui_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wasina bi tami bada kokabunagha, basuna gekoyakovi da meyani bare badana inaveramagha. Memeda ravidiye bo kenakenaruwamire, bo kokorereko sinaduuduna bo didibare. ");
INSERT INTO aui_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bi raghanine inapiika na gegha yana wiina da inabananimi konakenakenana. ");
INSERT INTO aui_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Awaki awonewonemi, na bada wawaya tupadi anawonedi: Kokabunagha!” ");
INSERT INTO aui_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kata na gabudara bata kawagha siyamakamake da Koughanu bi Parawa Gegha Yist Teya porayidi. Na prist babadidi da gwara kana wiiyeveveyana damdi wiikowoye keda siyininogha da Yesu siyiyabeni bi siyakabitawani da siyakasunuyi. ");
INSERT INTO aui_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na siwona bo, “Gegha poragha raghanine tana berana, kate bi wawaya wiirouwa sinidaguveni.” ");
INSERT INTO aui_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bi raghanina Yesu Betenine na Saimon, tomogha iiyabo naghove korekore ikabina yana bareye. Bi siyakamkam, na wasike tana verikoko alabastama sibera bi mayawaga kamone na ikawari irughu. Da verikokona kanighona ikiyagiini bi Yesu gayamine mayawagina iwayi. Bi mayawagina miisanina ghamana bi nadima sibera. ");
INSERT INTO aui_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wawaya mududi nama nuwanuwadi sipughu na sivisisiya kabivivirana bo, “Awaki kiiravine mmko mayawagina ivikawawaneni? ");
INSERT INTO aui_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Siyigimogimoneni da mane ghamana siyakabi bi manena moyaka siyaveredi,” na siki kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bi Yesu iwonedi bo, “Kokuyoveni, awaki kiiravine kwiisinimayamayayi? Touna bera waratetena ibera tagu biidi. ");
INSERT INTO aui_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tami nonowa moyaka teya konamakamake, bi yami kayowane koniwiitedi bi tagu gegha nonowa yawata tana makena. ");
INSERT INTO aui_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bi awaki rubana da iyabera na ibera; da mayawaga tubuyiguve iwayi da raghani katamane ikabununagha kagu dogudogu kiiravine. ");
INSERT INTO aui_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iisuwonemi, meghamegha mmko kuburine, meme wawaya waragu miisena sinadimedimeni, na awaki mmko wasikena tagu biidi ibera na kate sinisisiyeni da raghani nonowa sinanoghonoghosi.” ");
INSERT INTO aui_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Noko murine Jiudas Iskariyot, kivikivina 12 kamodiye bi tana, inagho prist babadidi biiyadi da Yesu kiiravine iyapuke. ");
INSERT INTO aui_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Damdi mmko sisiyina siwaiyaneni na sivinuwamiise bi sivisuwoneni da mane siyavereni. Wasina bi Jiudas keda wiinogha idagu da metagha Yesu, imadiye iyatore. ");
INSERT INTO aui_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Parawa Gegha Yist Teya porayina gabudarina dagudagune, bi gabudarine na nigenige sikasunughana da Koughanu kiiravine, na kivikivina Yesu sivitarakiiyaneni bo, “Mebo yam wiina kananagho da Koughanu kamkenana kiiravimve kana kabununayi?” ");
INSERT INTO aui_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wasina bi kana kivikivina bata iviporadi, iwonedi bo, “Konagho konarughu kwanatuve, bi tomogha rarima kibubuna yakawakawari na konakita. Na kokivini, ");
INSERT INTO aui_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","da meme inarughu, na barena wiibadana kowoneni bo, ‘Abawiiyeveveyana iwona da, “Tupayarayina meme, tagu da kagu kivikivina kiiravimiiye Koughanu kamkenana kana kam?” ’ ");
INSERT INTO aui_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wasina bi tupayaragha ghamana kiidamove iniyevevemi, tourawiikayowanina da kabukabununayina, na name bera tupana kokabikuya kiiravidaye.” ");
INSERT INTO aui_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kivikivina sinagho sirughu kwanatuve, bi bera tupana metagha Yesu iwonedina sibanani, da Koughanu kamkena, na sikabikuyi. ");
INSERT INTO aui_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bi ravidiye na Yesu, kivikivina yadi 12 yawata siverakanibu. ");
INSERT INTO aui_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bi siyakamkam raghanine, iwonedi bo, “Iisuwonemi, da kamomima tana kagu puka inakabi iiyabo yawata kakamkamna.” ");
INSERT INTO aui_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kivikivina noko sisiyina siwaiyana na sivinuwapoya bi sidagu tatadigegha sinitarakiiyaneni, “Wiisuwona tagu bo?” ");
INSERT INTO aui_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu iwonabodedi bo, “Tami 12 kamomiye tana, iiyabo kana parawa dabira kamone tagu teya kakutuwana. ");
INSERT INTO aui_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Peroveta metagha sigirumana naboni da Wiisuwona Tomoyina inarabobo. Bi God noko tomoyina iiyabo yana Wiisuwona Tomoyina kana puke inakabina kate aro ghamanakina inavereni! Na iyamiise kirakii da noko tomoyina gegha iyatubughana.” ");
INSERT INTO aui_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bi siyakamkam raghanine, Yesu parawa tana ikabi, God biidi ivikiikiiwa, bi ikiyagima da kana kivikivina iveredi, iwona bo, “Kokabi; mmko na tubuyigu.” ");
INSERT INTO aui_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bi wain reduna ikabi, God biidi ivikiikiiwa, bi iveredi da tupadi tounama siniuna. ");
INSERT INTO aui_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bi iwona bo, “Mmko tagu ganiganigu, meko inororotaveyana wawaya korotodi kiiravidiye. Ganiganigu touna inabera da God yana wiiwaghasina maragasina wouna inatarakirami yana wawaya biidi. ");
INSERT INTO aui_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iisuwonemi, gegha meyani mmko wainna ananiuna mayeni patana da God wawaya keda woune inibadedi na gabudarine wain wouna ananiuni.” ");
INSERT INTO aui_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wasina bi ayii tana sitawori bi Jerusalem sikanibutaveni sinagho Oliv koyane. ");
INSERT INTO aui_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu iwonedi bo, Tupami konavera da konakuyovegu, basuna God wonana buka kamone iwona da: ‘God sip kadi bodaboda inakasunuyi, na sip tupadi sinimosaredi,’ ");
INSERT INTO aui_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","bi muriye raboboma anageghomiiri magha, na aninagho ananagho Galilima, bi tami murigha. ");
INSERT INTO aui_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita iwona bo, “Memeda turagu sinavera da sinakuyovem, bi tagu geanakuyovemna!” ");
INSERT INTO aui_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu, Pita iwoneni bo, “Iisuwonem, kata nubabasuve muriye da kokorereko inaduu da bata, na naghove kunawona raghani aroba da tagu gegha kuyakoviguna.” ");
INSERT INTO aui_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita iwonabodeyana wiimaragata bo, “Tagu kate genaboni anisisiyana, bagune tam da tagu sinikasunughaneda, kate gemeyani anawona wiinagonagovemna.” Bi kivikivina mududi bada sisiyina mayimayiyina sivisisiyeni. ");
INSERT INTO aui_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wasina sipiika gawara kana waghawagha Getsemenima, na kana kivikivina iwonedi bo, “Mma komakae bi anarupari.” ");
INSERT INTO aui_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na Pita, Jemes da Jon irutayinidi yawata sinagho. Bi nuwavisi da nuwapoya ikabi kirakiiyeni, ");
INSERT INTO aui_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","na iwonedi bo, “Nuwapoya nuwanuwaguve iragata kirakii da damina ware pinimina bi inirabobogu. Mma komakae bi kovikighukighu.” ");
INSERT INTO aui_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Inagho gisina bi ere nuwavisina ivitavenayowoyena mayeni tanave, bi irupari da nuwavisi da sinivisi naghone sapiipiika na memeda rubana bo gegha da siyanaghotaveyana. ");
INSERT INTO aui_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na ruparima iwona bo, “Abba, Tamagunaki! Tam bera tupadi rubana kunabera, na mmko kabikwarakwara reduna gwabiguve kabitaveni. Bi geawaki ayakayovenina, bi tam awaki kukayovenina.” ");
INSERT INTO aui_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wasina bi Yesu iveramagha da kivikivina aroba ibananidi siyakenakena. Na Pita iwoneni bo, “Saimon, da kwakenakena? Raghani gisinagha kunabanenega bo gegha?” ");
INSERT INTO aui_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Na iwonedi bo, “Kovikighukighu, bi korupari da gegha ruyagha kamone konabekuna. Kanuma yakayokayoveni da bera miisena bi tubugha inoganoga.” ");
INSERT INTO aui_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Inagho magha bi irupari, sisiyidi mayimayiyidi ivisisiya. ");
INSERT INTO aui_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bi iveramagha na ibananidi siyakenakena, kiiravine gerubana matadi siyakitatora. Na gegha siyakovi da awaki touna siyawoneni. ");
INSERT INTO aui_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bi raghani wiiarobina iveramagha, na iwonedi bo, “Tami patana kokenakena da kwiiyawiitaveyana? Wasina rubana! Gabudarina ipiika! Kokita, puke wawayina, Wiisuwona Tomoyina yitowawoneni tamumu damdi biiyadi. ");
INSERT INTO aui_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kogeghomiiri, tana nagho, kokita tomoyina mmakatanina iiyabo kagu puke ikabina.” ");
INSERT INTO aui_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu patana iyiisisiya bi Jiudas, kivikivina 12 kamodiye bi tana, iverakanibu. Bi murinagha na koroto ghamana seri da kepata sivimakabikabiyeni. Bi mmkodi wawaya na prist babadidi, gwara wiiyeveveyana damdi, da kwanatu kana dogara siviporadi. ");
INSERT INTO aui_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bi Jiudas nada ivikatayidi matakira kiiravine, iwonedi bo, “Tomogha anamaghanina, wasina touna. Koburavi, kokabitawani bi korutayini konanagho.” ");
INSERT INTO aui_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Raghanina Jiudas iverakanibu, na yaininagha inagho Yesu biidi bi iwona bo, “Abawiiyeveveyana!” bi nawanawana imaghani. ");
INSERT INTO aui_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na sipatumi da sikabikikisi. ");
INSERT INTO aui_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bi wawaya tana nama iyamiimiiri na yana seri itaiyina kanibuveni bi prist kiikiiwawona yana wiibagubagurana tainana ikasiyaraghataveni. ");
INSERT INTO aui_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bi Yesu iwonedi, “Tagu ware kasukasunugha, bo? Na seri da kepatama kopiika da konapatumigu. ");
INSERT INTO aui_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Raghani nonowana tagu tami yawata, God yana bareye ayiyeveveyana, bi gegha koyapatumiguna. Bi gegha, da buka peroveta sigirumina inatubugha.” ");
INSERT INTO aui_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wasina bi kivikivina tupadi sikuyoveni bi siverawiitaveni. ");
INSERT INTO aui_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bi tomogha yaragina, gara yabuyabunama ivitarasowowota, da Yesu iyakivikivini, na siberatowoyi da siyaburavi, ");
INSERT INTO aui_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bi kana gara imadebadiye ikuyoveni bi ighaninagha iverataveyana. ");
INSERT INTO aui_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wasina Yesu sikabi sinagho prist kiikiiwawona yana bareye, meme prist babadidi tupadi, kwanatu kana dogara da gwara wiiyeveveyana damdi sivitaghomidina. ");
INSERT INTO aui_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bi Pita kana taraboga murigha ikivinidi da irughu prist kiikiiwawona yana bare garina kamone. Da name keyama ririne imakeyowogha iyiraragha, koyakoyagha damdi yawata. ");
INSERT INTO aui_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bi prist babadidi da Wiigiugerogerora damdi tupana siberatowoyi da Yesu yana berona siyabanani bi siyiaviyeni da rabobove siyatore, bi gegha tana siyabananina. ");
INSERT INTO aui_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wawaya korotodi sipiika da sisiya wiiyaba sivisisiya da Yesu siyiaviyeni, bi yadi waragututu gegha mayimayiyidina. ");
INSERT INTO aui_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tomotomogha mududi sigeghomiiri da mmko wiiyabinama Yesu siviaviyeni: ");
INSERT INTO aui_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kawaiyaneni iwona da, ‘Tagu, mmko God yana bare, meko wawaya imadima siyoghanina anatainarika, bi gabudara aroba murine na tana anayoghana mayeni gegha naboni wawaya imadima siyaberana.’” ");
INSERT INTO aui_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bi gegha, yadi waragututuna tupadi na sivibogae. ");
INSERT INTO aui_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na prist kiikiiwawona, Wiigiugerogerora naghodiye igeghomiiri da Yesu ivitarakiiyaneni bo, “Mmkodi sisiyama siaviyemna, awaki biidi gekuyawonawona bodeyana?” ");
INSERT INTO aui_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bi Yesu ivikawa potapota da gegha awaki tana iyawoneni. Na prist kiikiiwawona ivitarakiiyanena mayeni bo, “Tamna God yana Wiivinevinegha Kiiwawona, iiyabo kakabekabepepi na Natuna?” ");
INSERT INTO aui_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na Yesu iwona bo, “Wasina Tagu, bi tupami konakita da Wiisuwona Tomoyina, Maragata Kirakiina ririne inamakamake bi abama uuwadigha inapiipiika!” ");
INSERT INTO aui_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na prist kiikiiwawona kana kwama itainagosiri bi iwona bo, “Gegha bada sisiya mududi taya kayokayowana maghana! ");
INSERT INTO aui_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tami tupami, yana sisiya kowaiyaneni, touna God ivigiboyi. Awaki konoghonoghosi?” Bi noko korotona siwona bo, “Touna iberabero na inarabobo.” ");
INSERT INTO aui_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bi mududi sidagu Yesu siyakanukanu, matana sigere bi sirouvi. Da siwoneni bo, “Memeda tam peroveta, na kuwonemii iiyabo irouvim!” Wasina bi koyakoyagha damdi sikabi da sitapitapi. ");
INSERT INTO aui_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wasina bi Pita patana petakone gari kamone, bi prist kiikiiwawona tana yana wiitamariyana wasikena imiiririya. ");
INSERT INTO aui_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na raghanina ikita da Pita keyame iyiraragha, na rotomanina ikitarorona bi iwoneni bo, “Tam teya, na Yesu Nasaret tomogha yawata.” ");
INSERT INTO aui_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bi Pita iwona wiinagonagoveni bo, “Geayakovi bi geyaguakowa da awaki kwiisisiyeni,” bi ikanibutaveyana gari matamketane bi kate noko raghanine kokorereko iduu. ");
INSERT INTO aui_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bi wiitamariyana wasikena, raghanina Pita nama ikita na idagu wawaya nama ririne siyamiimiiri na iwonena mayedi bo, “Mmko tomoyina, na Yesu kwiinana tana!” ");
INSERT INTO aui_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bi Pita iwona wiinagonagoveni. Raghani gisina bi murine na nama iiyawogha miimiiridi bada siwoneni bo, “Gekunakeena, wiisuwona tam Yesu yana wawaya tana, bi tamna Galili tomogha.” ");
INSERT INTO aui_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na Pita iwona bo, “Iisuwona, gegha ayiyabana, bi meboda aniyaba na God aro inaveregu! Tagu noko tomoyina kwiisisiyenina gegha ayakovina.” ");
INSERT INTO aui_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wasina bi kokorereko idou iyibata, na Pita inoghosi da metagha Yesu iwoneni, “Muriye da kokorereko inadou inibata, na naghove raghani aroba kunawona da tagu gekuyakoviguna.” Na nuwanuwana idugari da iwasigorita idou. ");
INSERT INTO aui_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Raghani sowasowae prist babadidi, kwanatu kana dogara, gwara kana wiiyeveveyana damdi, da Wiigiugerogerora damna tupadi yawata nada sivitaghomidi bi siwonaruyarayaragha ikovi, na Yesu imana sikutawatawana, bi sivinaghoveni sinaveni, da Pailat siviruvereni. ");
INSERT INTO aui_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat, Yesu ivitarakiiyaneni bo, “Tam Jius yadi kiiwawo bo?” Na Yesu iwona bo, “Wasina kwiisisiya namakatanina.” ");
INSERT INTO aui_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Prist babadidi Yesu wiiwawu sisiyidima siyikeekeeni. ");
INSERT INTO aui_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na Pailat ivitarakiiyanena mayeni bo, “Kunawonabodeyana bo gegha? Yadi wiiwawu tupana da kuwaiyana!” ");
INSERT INTO aui_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bi Yesu geiyawonabodeyana magha, na Pailat ivisokoveni. ");
INSERT INTO aui_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Raghanina Koughanu porayidi nunudigha na Pailat ibera nuwaneni da biwa gawarina kamonama wawaya tana yikanibuveni, iiyabo, dam Jius sakayoveni na kiiravine sibabana. ");
INSERT INTO aui_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bi noko raghanine tomogha kana waghawagha Barabas na biwa gawarina kamone, da wawaya iiyawogha wiirouwa kamone kasunugha sibera na yawata. ");
INSERT INTO aui_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Raghanina koroto sivitaghomidi, na sidagu Pailat siyibabiini da nonowa iyaberaberana naboni, da yadi kayowana iyabera, ");
INSERT INTO aui_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Bi Pailat iyakowa katamaneni da prist babadidi, na Yesu sivitowawoneni touna biidi basuna sinuwapughuveni. Na koroto ivitarakiiyanedi bo, “Yami kayowana da Jius yadi kiiwawo anikanibuveni kiiravimiye bo?” ");
INSERT INTO aui_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na prist babadidi koroto nuwanuwadi sipiro bi siwonedi da Pailat siyibabiini bi Barabas iyikanibuveni kiiravidiye, Yesu wasana. ");
INSERT INTO aui_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wasina bi Pailat koroto iwonena mayedi bo, “Bi awaki, anabera mmko tomoyina biidi, kokwatuveni da Jius yadi kiiwawo?” ");
INSERT INTO aui_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bi sirabodeyana bo, “Kotuparatuni!” ");
INSERT INTO aui_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na ivitarakiiyanedi bo, “Awaki kiiravine? Bi awaki berana berona ibera?” Bi koroto sirukwatu kamokamogha bo, “Kotuparatuni!” ");
INSERT INTO aui_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na Pailat yana kayowana da koroto iyinuwapikadi, na Barabas biwa gawarinama ivikanibuveni kiiravidiye. Bi kawane na Yesu sikwapu kirakiiyeni bi iwonataveni da siyatuparatu. ");
INSERT INTO aui_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wasina iyo wawayidi Yesu sikabi sinagho Pailat yana bare garina kamone bi iyo turaturadi tupadi sikwaturiyariyadi sipiika. ");
INSERT INTO aui_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bi kwama ididurinama Yesu sivikoteni da kapi iyiyona sibera bi gayamine siviyagha. ");
INSERT INTO aui_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Da ere wiinamayidi siyikayekayeni siyawonawona bo, “Kiiwa, kiiwa Jius yadi kiiwawo!” ");
INSERT INTO aui_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bi dighonama gayamina siyarurouvi da siyakanukanu, bi siyituwapore oghogheyana da ere wiinamayidi siyapeepeteni. ");
INSERT INTO aui_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Raghanina sivinamayeni ikovi, na kwama ididurina sikabitaveni bi kana kwama waghata sivikotena mayeni. Bi sirutayini sikanibu da siyatuparatuni. ");
INSERT INTO aui_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jerusalem sikanibutaveni bi kedae na tomogha kana waghawagha Saimon sibanani, wawa kuburinama ipiika iyarughurughu kwanatuve, na iyo wawayidi siruwiiyaiyaini da Yesu kana korosi iyakawari (Saimon na Sairin tomogha bi Aleksanda da Rufas tamadinaki). ");
INSERT INTO aui_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wasina bi iyo damdi Yesu sirutayini sinagho gawara sakwatuveni Golgota, waghawaghana yana basuna deudeu gawarina. ");
INSERT INTO aui_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Name siberatowoyi ware wain da kii otona kana waghawagha myrrh yawata siwamiri na siyavereni, bi Yesu gegha iyaniunina. ");
INSERT INTO aui_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wasina situparatu, bi kana kwama sikabireregha toudimani kamodiye, bi wiirekwa tana sibera da mekodi kwama yadi kayowane siyayouna. ");
INSERT INTO aui_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Didibare, gabudara iyarurumuyamuya (9:00 o'klok) bi situparatu. ");
INSERT INTO aui_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bi wiiwawu sisiyina siyiaviyeni na kiisepiye sigirumi da gayamina wowone situturatu naboni iwona, “Jius yadi kiiwawo.” ");
INSERT INTO aui_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Bi yapiyapi damdi bata situparatudi, Yesu yawata, tana katiiyane bi tana dugene. ");
INSERT INTO aui_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wawaya ririnagha siyanono piika na gayamidi siwiineyana bi Yesu siwonawiigiboyi bo, “Eka damina kabi! Tam kuwona da God yana bare kuyatainarika bi gabudara aroba kamone kuyayoghana mayeni! ");
INSERT INTO aui_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na kata korosima kuyowogha da kuniyawii mayem!” ");
INSERT INTO aui_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bi berana mayimayiyina, prist babadidi da gwara kana wiiyeveveyana damdi Yesu sivinamayeni, siyawonawona bo, “Wawaya mududi iviyawiidi bi kate gerubana tounamani iniyawii mayenina! ");
INSERT INTO aui_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mede tana kita, iwona da touna God yana Wiivinevinegha Tomoyina, Isrel kana kiiwawo kata korosima inayowogha, na tanigeruveni.” Bi nokodi bata, Yesu yawata situparatudi na bada siwona wiiberoveni. ");
INSERT INTO aui_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gabudara yubasune na wiididibara kubura tupana isowomumu, patana da ravidi gabudare. ");
INSERT INTO aui_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bi ravidi gabudare (3:00 o'klok) na Yesu irukwatu da ghamana, “Eloi, Eloi, lama sabatani?” yana basuna, “Yagu God, Yagu God, awaki biidi kukuyovegu?” ");
INSERT INTO aui_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wawaya mududi nama siyamiimiiri bi siwaiyaneni na siwona bo, “Kowaiyana, touna Elaija yakwatukwatuveni.” ");
INSERT INTO aui_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wasina bi tomogha tana iverainagho gumba ikabi da wain tomatomane isirakutuvi, bi kii damone ivikavini. Bi ikoghasi igae Yesu biidi da iyaniuna bi iwona bo, “Kokoyai! Tana kita memeda Elaija yapiipiika korosima inatoreyowoyeni!” ");
INSERT INTO aui_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bi Yesu irakapara da yawiina itavenatughureni. ");
INSERT INTO aui_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wasina bi God yana bareye bebera meko tupayaragha Kabikabikuwayina itoreboda iyarororoga na itamogosira da bata, wowone da iyowogha kabine. ");
INSERT INTO aui_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iyo damdi kadi bada nama korosi naghone iyamiimiiri na ikita da metagha Yesu irabobo, na iwona bo, “Wiisuwona mmko tomoyina na God natuna!” ");
INSERT INTO aui_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wasiwasike mududi nama, kadi taraboga siyaruruwiitete. Bi kamodiye na Meri Magdalin, bi Meri tana, Jemes murimurina da Joses sinadinaki da Sayome. ");
INSERT INTO aui_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Raghanina touna Galiline, na mmkodi wasiwasikedi siyakivikivini da yana kayowana siyaberabera. Bi wasiwasike mududi iiyawogha Yesu teya sipiika Jerusalemma na bada yawata nama. ");
INSERT INTO aui_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ravidipikae, Jousep Arimatiya tomogha, bi bada ghamana Wiigiugerogerora damna kamone, bi touna wosina bada God keda woune wawaya wiibadedi kiiravine iyakoyakoyayi na iverakanibu. Bi kabununagha gabudarine (noko na wiiyawiitaveyana gabudarina naghone ravidiye), na Jousep idebawowora inagho Pailat biidi da Yesu tubuyina kiiravine ivibaba. ");
INSERT INTO aui_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bi Pailat ikabinokeni da Yesu nada irabobo, na iyo badana ikwatuveni ipiika bi ivitarakiiyaneni da nada waghata irabobo bo gegha! ");
INSERT INTO aui_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bi iyo badana yana sisiya iwaiyana ikovi na Jousep iviwaghasineni da Yesu tubuyina iyakabi. ");
INSERT INTO aui_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na Jousep bebera poina yeyeghanina igimoni bi Yesu tubuyina itoreyowoyeni da igere bi karawaga akima kakokakone sibanina name itore. Bi akima ghamana itabiri ipiikeni karawaga kawabonayina itoreboda. ");
INSERT INTO aui_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Magdalin da Meri tana, Joses sinananaki na siyaruruwiitete bi sikita da meme Yesu tubuyina sitore. ");
INSERT INTO aui_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wiiyawiitaveyana gabudarina ikovi bi murine, Meri Magdalin da Meri tana, Jemes sinananaki da Sayome, wane ghabughabu sigimona bi siyanagho da Yesu tubuyina siyituboro. ");
INSERT INTO aui_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na Sande didibara wote gabudara iwasepi iyageegee, na sinagho karawaga epamana bonayine. ");
INSERT INTO aui_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bi kedagha sidune siyanono na toudimani siyisisiya kabivivirana, “Iiyabo akima karawaga epamana bonayina kawane kiiravidaye inatabirataveni?” ");
INSERT INTO aui_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bi raghanina siyakayogagawa na sikita da akimina nada sitabirataveni (akimina ghamanakina). ");
INSERT INTO aui_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na karawaga epamana bonayine sivitavena rughuvedi, bi siyakita da katiiyadiye na tomogha yaragina ere kwama poepoena iyamakamake na sikumararagha. ");
INSERT INTO aui_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bi iwonedi bo, “Gekonakumararaghana, akovi da Yesu Nasaret tomogha kwiininoyeni, iiyabo situparatuna. Touna gegha mma - nada igeghomiiri! Kokita gawarina mmakatanina meme sitorena. ");
INSERT INTO aui_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bi konagho da kana kivikivina mududi da kate Pita yawata mmko warana kowonedi; touna ivinagho yanono Galilima, bi name konakita, metagha iwonemi na naboni.” ");
INSERT INTO aui_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na karawaga epamana bonayine sikanibutaveni, nuwapoya bi kiroro teya, na getana iiyabo siyawoneni da awaki, kiiravine toudi sinaghara kirakii. ");
INSERT INTO aui_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande raghani diidibare pom sowae, Yesu raboboma igeghomiiri magha murine, na ghuyoghuyone Meri Magdalin biidi irumaghatara, iiyabo roro kanuma beroberodi yadi 7 gwabinama ivikanibuvedina. ");
INSERT INTO aui_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wasikena awaki itubugha kiiravine, na inagho da turaturana iwonedi, toudi siyaduudu da siyasiyasiyapa. ");
INSERT INTO aui_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bi raghanina wasikena iwonedi da Yesu nada raboboma igeghomiiri bi matanama ikita, na toudi, yana sisiya siwaiyana bi gesiyigeruwanana. ");
INSERT INTO aui_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Noko murine, kivikivina bata raghanina Jerusalem sikanibutaveni siyanono wawa kuburidiye na Yesu kana kita ivibogae bi irumaghatara toudi biiyadi na sivinagonagoveni. ");
INSERT INTO aui_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bi muriye sakovi, na siveramagha da turaturadi siwonedi, bi toudi yadi sisiya gesiyigeruvenina. ");
INSERT INTO aui_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tughura waghate, na Yesu kivikivina yadi 11 biiyadi irumaghatara raghanina siyakamkamna. Bi ikidi kiiravine yadi noghota sigisi, basuna nuwanuwadi sikotakii da gayamidi siviakima da iiyawogha sikitana, yadi sisiya gesiyigeruvedi da iyawa magha. ");
INSERT INTO aui_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bi iwonedi bo, “Kokanibu konagho kubura tupane da wara miisena dam bi dam biiyadi konadimeni. ");
INSERT INTO aui_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iiyabo inigeruwana da inababataito na inayawa, bi iiyabo geinigeruwana na yana tamumu kiiravine aro inakabi. ");
INSERT INTO aui_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bi wiigeruwana damdi maragata sinakabi da berakayowiiwiiyaka sinabera; toudi kanuma beroberodi kagu waghawaghae wawaya gwabidima sinikanibuwana, bi gamo wiibatama sinisisiya. ");
INSERT INTO aui_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bi imadima mota sinayouna, bo memeda tuwamoroba sinaniuna, na kate gesinarabobona. Bi imadi wawaya gubagubagidi debadiye sinatoura, na siniyawiidi.” ");
INSERT INTO aui_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bada Yesu, kana kivikivina iwona wiiyoyowanedi ikovi murine, na God yana maragate na ikabi igae abame da ririne ivimakeni. ");
INSERT INTO aui_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wasina bi kivikivina sinagho kubura tupane wara miisena wawaya biiyadi siyadimedimeni, bi Bada yawata kamodiye sibagibagi na ikabirubata da yadi dima na wiisuwona, basuna yana maragate berakayowiiwiiyaka sibera bi wawaya sikitana sivigeruwana. ");
INSERT INTO aui_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Wayakapo, Tiyopilas. Roro buka tana agirumi na kamone Yesu yana wiiyeveveyana da yana bagibagi metagha ibera, dagudagune da tughurine na tupana atore. ");
INSERT INTO aui_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Muriye da abame iyagae na iiyawogha ivineyidi da yana apasol na Kanuma Kabikabikuwayina yana maragate iwonawiiyoyowanedi da awakigha siyabera. ");
INSERT INTO aui_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu irabobo murine na gabudara 40 kamone iyarurumaghatara yana apasol biiyadi bi raghani peyaridi iyiidebena mayeni da wonawaghata touna yawayawiina. Bi God yana wiikiiwawona toudi biiyadi iyisisiyeni. ");
INSERT INTO aui_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Raghani tana yawata siyakamkam bi sisiya bagibaginama iwonedi bo, “Jerusalem gekonakanibutaveni, kovikoyakoyagha raghani gisina. Nada awonemi da tamagunaki yana wiisuwona maragasina itore da kami puyo inawonataveni. ");
INSERT INTO aui_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon, rarimama wawaya ibabataitodi bi gabudara viya murine na tami Kanuma Kabikabikuwayinama konababataito.” ");
INSERT INTO aui_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Raghani na apasol siriyena mayedi Yesu biidi na sivitarakiiyaneni bo, “Bada, rubana da tam mmko raghanine Roum kunagetawanidi bi Isrel damdi yadi wiikiiwawona kuniveramayi, bo?” ");
INSERT INTO aui_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Bi Yesu iwonabodedi bo, “Tamagunaki touna kawagha yana wiibadana da nokodi raghani da iri itoura bi getami yami bagibagi da akovina konakabi. ");
INSERT INTO aui_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bi raghanine Kanuma Kabikabikuwayina inatowatawanimi na maragata inaveremi. Da tagu kiiraviguve na wawaya konimaghamaghataredi, Jerusalem kamone bi Jiudiya kubura tupane da Sameriya kubure bi kate kubura tupana.” ");
INSERT INTO aui_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Raghanina mmkodi ivisisiya ikovi, na siyaruruwiitete bi God ikabi iyageegee da matadiye bi uwa ivikowoyi. ");
INSERT INTO aui_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Raghanina iyageegee abame bi patana siyaruruwiitete na yaininagha tomotomogha bata kadi kwama poepoedi riridiye sirumaghatara. ");
INSERT INTO aui_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bi siwona bo, “Galili dammi, awaki kiiravine komiiri bi abame kogagaagawa? Mmko Yesu na, iiyabo gwabimima sikabitaveni igae abame, na kedana mayimayiyina muriye inaveramagha metagha kokita iyageegee abamena.” ");
INSERT INTO aui_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wasina bi apasol siveramagha Jerusalem kwanatune, Oliv Koyanama bi noko tarabogina yana rabaraba na gegha gurina da Jerusalem kwanatuna. ");
INSERT INTO aui_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Raghanina Jerusalem kwanatune siverakanibu na sigae bare kamove tupayaragha meme siyamakamakena. Kadi waghawagha mma naboni: Pita, Jon, Jemes da Andru, Piripo da Tomas, Batoromiu da Matiu, Jemes (touna Arupiyas natuna), da bada Saimon (touna Zelot wawaya) bi kate Jiudas (touna Jemes natuna). ");
INSERT INTO aui_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bi toudi raghani nonowa nuwanuwadi tanagha bi rupari kiiravine na siyiitaghomidi, wasiwasike viya yawata da Yesu sinananaki Meri teya bi kate tiitiinayoghoyogho. ");
INSERT INTO aui_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nokodi raghanidiye wiigeruwana damdi siriyedi da kamodiye na wawaya yadi 120. Bi Pita igeghomiiri da ivisisiya iwona bo, ");
INSERT INTO aui_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Warewaresigu, buka katamanina kamone metagha igirumina inatubugha da kamone Kanuma Kabikabikuwayina naghove waghata ivisisiya Deivid kawanama iwonakasiyaragha Jiudas kiiravine. Touna ivikedawaga da wawaya Yesu sipatumi. ");
INSERT INTO aui_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kiiravine Jiudas na touda kamodae bi yawata tabagibagi patapata.” ");
INSERT INTO aui_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Bi Jiudas yana wiiyaba berona miisanina ikabi na manenama tanawa muduna igimoni. Noko tanavina kamone Jiudas ibeku da kamokamona ivikwata da kamowarawarana iruwayi. ");
INSERT INTO aui_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wawaya tupadi Jerusalemne makamakedi noko rabobona warana siwaiyaneni na Hibru gamodima tanavina sikwatuveni Akeldama, noko waghawaghana basuna, ganigani tanavina.) ");
INSERT INTO aui_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bi Pita sisiya ivikiitayini iwona, “Psam kamone kiiwawo Deivid igiruma bo, ‘Yana bare inakwebu, da gewawaya sinamakena.’ Bi kate, ‘Wawaya tana kana gawara inakabi.’ ");
INSERT INTO aui_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Noko biidi tomogha tana tanavineyi da Jiudas kana gawara inakabi. Touna tomoyina na toumii yawata raghani patepatena Bada Yesu yawata kayapeepewa, ");
INSERT INTO aui_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","dagudaguna na Jon wawaya iyabaabataitodi raghanine, patana da Yesu yana gae abame gabudarine - mmko tomoyina tana iniwiiteda da wawaya biiyadi tani maghamaghatara da Yesu raboboma igeghomiiri.” ");
INSERT INTO aui_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Na tomotomogha bata sikabigubadi: Jousep sakwatuveni Basabas (kana waghawagha tana Jastas) bi kate Mataiyas. ");
INSERT INTO aui_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Wasina bi tupadi sirupari bo, “Bada, wawaya tupadi nuwanuwadi tam kwakovi. Kiyevevemii da meko tomoyina kwawiiwiini, ");
INSERT INTO aui_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","da mmko bagibagine yana gawara inakabi da apasol bigana inabera meko Jiudas imiiri kuyoveni, basuna ikuyovemii inagho yana kubure.” ");
INSERT INTO aui_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na wiirekwa tana sibera, da Mataiyas sivineyi, da touna iviapasol nokodi yadi 11 iviagagudi. ");
INSERT INTO aui_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Raghanina Pentikos gabudarina ipiika na wiigeruwana damdi tupadi gawara tanagha sivitaghomidi. ");
INSERT INTO aui_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yaininagha gugura abame siwaiyaneni naboni ware yanunu maragasina. Bi gugurina iyowogha da bare kamona tupana inunuri meme siyamakamakena. ");
INSERT INTO aui_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bi siyakita da sawara tana, naboni ware keyama wiibububuna pepana iyowogha bi itamodididigha da tatadigegha debadiye sitowa. ");
INSERT INTO aui_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bi Kanuma Kabikabikuwayina tupadi ivibonuvidi da maragata iveredi na sidagu gamo bogaebogaema siyiisisiya. ");
INSERT INTO aui_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Noko raghanine na Jius damdi iiyawogha yadi bera da God nonowa siyakabikabikuwayeni na kubura bogaebogaema sipiika da Jerusalemne siyamakemake. ");
INSERT INTO aui_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bi raghanina noko gugurina siwaiyaneni na koroto ghamana siriyeni bi sikeyekeyedi basuna siwaiyana da wiigeruwana damdi tatadigegha na dam bi dam yadi gamoma toudi siyiisisiya. ");
INSERT INTO aui_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na noghota kawakawama sivisokovedi siwona bo, “Kokita, metagha bi naboni, nokodi wawaya tupadi na Galili damdi. ");
INSERT INTO aui_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Metagha bi tatadigegha tawaiwaiyanedi da toudi yada gamoma sisisiya? ");
INSERT INTO aui_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Touda kubura bogaebogaema tapiika, mududa na Patiya, Midiya, Elam, Mesapotemiya, Jiudiya, Kapadosiya, Pontas da Eisiya. ");
INSERT INTO aui_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Praigiya, Pampiliya, Ijipt da Libiya kuburina muduna, noko na Sairin kubura ririne. Bi kate viya na touda Roum damda tavikiiwaga, ");
INSERT INTO aui_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jius waghata da kubuna damdi yadi wiigeruwana siwamira bi Jius yadi wiitumaghana sivigeruveni. Bi kate viya na Krite da Areibiya, bi mmkodi damdi tawaiwaiyanedi da God yana bera ghamanakidi iberana kiiravidiye, na toudamani yada gamoma sisisiyana.” ");
INSERT INTO aui_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na tupadi sinokeni bi sinoghota kawakawa na sivitarakiiyana kabivivirana bo, “Mmko touna awaki berana?” ");
INSERT INTO aui_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bi viya noko korotona kamone wiigeruwana damdi sivinamayedi, siwona bo, “Nokodi wawayidi na siniuna neghanegha.” ");
INSERT INTO aui_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita da apasol turaturana yadi 11 sigeghomiiri bi koroto biiyadi iwona bo, “Yagu wawaya, Jius turaturagu da iiyawogha Jerusalem kamone makamakemi. Kowaiyana wiimasi, bi mmko berana yana basuna animaghatari tami biiyadi! ");
INSERT INTO aui_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gekonanoghosi da mmkodi damdi siyaniuna neghaneghana. Gabudara yana muyamuya 9 o'klok kawagha, katare inagepaka bi tupada takovi da rarima maragasidi na gedidibare taya niniuna. ");
INSERT INTO aui_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gegha, raghani katamanine peroveta Jowel iwona da mmko matakirina ghamana iyatubugha. ");
INSERT INTO aui_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Igiruma da God iwona bo, ‘Raghani damona inapiika na Kanumigu anawonataveni inayowogha wawaya tupadi biiyadi. Natunatumi tomotomogha da wasiwasike sinawonakasiyaragha Anabera da yami yaraga bera gubagubadi sinakita, bi yami magumagura mimeu sinamimeu. ");
INSERT INTO aui_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bi noko raghanidiye Kanumigu anawonataveni inayowogha yagu bagibagi tomotomoyidi da wasiwasikedi biiyadi da yagu bera kiiravine sinawonakasiyaragha. ");
INSERT INTO aui_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Berakayowiiwiiyaka abame aniyeveveyana, bi matakira kubure aniyeveveyana. Ganigani, keyama karakarasina da buu ghamana kubure konakita. ");
INSERT INTO aui_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bi gabudara inididibari bi matu kana kita inawamiri da inidura. Mmkodi bera sinatubugha bi murine na Bada yana gabudara ghamanakina inanokanibu bi noghota kawakawana. ");
INSERT INTO aui_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bi naboni iiyawogha Bada kana waghawaghae wiiwiita kiiravine sinakwatu na iniyawiidi.’” ");
INSERT INTO aui_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bi Pita yana sisiya ivikiitayini bo, “Isrel dammi, yagu sisiya kowaiyaneni: Yesu, touna na Nasaret tomogha, bi God maragata ivereni na berakayowiiwiiyaka, bera ghamanakidi da matakira noghota kawakawadi gwabimiye ibera, noko wiiyeveveyana tami biiyadi da wiisuwona touna God gwabinama ipiika. ");
INSERT INTO aui_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bi God yana noghota kamone na tupana nada waghata iwonawiikim da awakigha siyatubugha Yesu biidi. Na tami wawaya kawakeekeedi siviwiitemi bi korosiye kotuparatu da koviraboboni. ");
INSERT INTO aui_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bi gegha, God rabobo sinivisina ghamanama ikabiwiigeghomiiri da iyawamagha, basuna rabobo gerubana iyakabitawani. ");
INSERT INTO aui_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Na kiiwawo Deivid, mma naboni ivisisiya Yesu kiiravine, ‘Akita da Bada na nonowa gwabiguve, bi ririguve kiiravine na geananagharana. ");
INSERT INTO aui_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Noko kiiravine nuwanuwagu imiise kirakii bi kawaguma akabekabepepa. Bagunakine tubuyigu inoganoga nuwanuwagu na duvine Bada iigeruveni, ");
INSERT INTO aui_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","basuna tam gekunakuyovegu da karawaga kamone anakena, bo yam Wiitamariyana Kabikabikuwayina tubuyina gekunakabitore da inatamoririghana. ");
INSERT INTO aui_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tam yawa makewaghawaghasina kedana kuviyevevegu. Bi tam kwagwabigwabiyegu kiiravine na nuwamiise inibonuvigu.’” ");
INSERT INTO aui_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bi kate Pita iwonamagha bo, “Warewaresigu, wonawaghata awonewonemi. Kayekikida Deivid irabobo da sidogu, bi kana karawaga na patana da gwabidae yamakamake na tanakovi da getounamani iyisisiyena mayenina. ");
INSERT INTO aui_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bi touna na peroveta, na iyakovi da God tounamani waghawaghane wiisuwona maragasina ibera da Deivid nosinosina tana kana gawara inakabi da inikiiwawo. ");
INSERT INTO aui_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kiiravine Deivid ikita da God raghani muriye awaki iyabera, noko kiiravine nada Keriso yana geghomiiri magha ivisisiyeni iwona bo, ‘God yana wiivinevinegha Wawayina geinakuyoveni karawaga kamone inakena, bo tubuyina geinakabitore da inatamoririghana.’ ");
INSERT INTO aui_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Bi God, Yesu raboboma ikabiwiigeghomiiri, na toumii tupamii kakitana kiimaghamaghatara ");
INSERT INTO aui_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","bi itoregeeyeni da ririne ivimakeni da yawata siyibada. Bi tamananaki God wiisuwona maragasina itore na naboni ibera da Kanuma Kabikabikuwayina iyavereni. Bi kata Yesu noko Kanumina iwonataveni iyowogha toumii biiyadi da basuna kokitakita bi kowaiwaiyaneni. ");
INSERT INTO aui_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kiiwawo Deivid na gegha iyagee abame ware Yesu naboni, na getouna iyisisiyena mayenina, raghanine iwona bo, ‘Bada God yagu Bada iwoneni bo, “Mabo ririguve kumakekira ");
INSERT INTO aui_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bi kam aviya anakabidi da kaye rogumve anatoredi.” ’ ");
INSERT INTO aui_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Noko kiiravine wawaya tupami Isrel kamone, akovina konakabi yapori! Da God, mmko Yesuna ibera da yami Bada bi yana Wiivinevinegha Kiiwawona iiyabo korosiye kotuparatuna.” ");
INSERT INTO aui_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Raghanine wawaya mmko sisiyina siwaiyaneni na nuwanuwadi iyogha, na Pita da apasol biiyadi siwona bo, “Warewaresimii, awaki toumii kanabera?” ");
INSERT INTO aui_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bi Pita iwonedi bo, “Tami tupami, yami bera beroberodi kokabitoura bi konatubuwamira, bi Yesu Keriso waghawaghane konababataito, tamumu noghotataveyanina kiiravine da Kanuma Kabikabikuwayina puyona konakabi. ");
INSERT INTO aui_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mmko wiisuwonina na tami da natunatumi kiiravimiye bi kate kubuna damdi kiiravidiye iiyawogha tupadi na Bada yada God inakwatuvedi touna biidina.” ");
INSERT INTO aui_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bi Pita sisiya mududi yawata ivisisiyana bi sisiya maragasinama toudi iwonawiiyoyowanedi bo, “Mmko inasina kawakeekeedima kokoyagha yaporimi, toudi sisiwana na kate biwa berona sinabanani.” ");
INSERT INTO aui_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wasina bi, iiyawogha Pita yana sisiya sivigeruveni na sibabataito, bi wawaya 3,000 noko raghanine wiigeruwana damdi siviagagudi. ");
INSERT INTO aui_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wiigeruwana damdi nuwanuwadi tupana tanagha bi apasol yadi wiiyeveveyana siyawaiwaiyana da siyakamkam patapata. Bi kate noko kamone siyarurupari da Bada yana kamkena siyakabikabi. ");
INSERT INTO aui_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apasol na God yana maragate na berakayowiiwiiyaka da matakira ghamanakidi siyaberabera na wawaya tupadi siyakitakita na siyanoghonoghota kawakawa. ");
INSERT INTO aui_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wiigeruwana damdi tupadi raghani nonowa siyiitaghomidi bi yadi sawara siyireregha kabivivirana. ");
INSERT INTO aui_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bi yadi sawara bo yadi tanawa siyigimona, na manedi turaturadi viya gwabidiye gegha na siyarerereyedi. ");
INSERT INTO aui_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Gabudara patepatena Bare Kabikabikuwayina garina kamone siyitaghomidi. Bi kate yadi bare kamodiye Bada yana kamkena siyakabikabi bi siyakamkam patapata, nuwamiiseye da nuwanuwadi yagharine, ");
INSERT INTO aui_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bi noko kamone God siyakabekabepepi, bi tupadi yadi yawa miisena kiiravine na Jerusalem damdi nuwanuwadi sikabi. Raghani nonowa wawaya woudi siyigeruwana bi yawa makewaghawaghasina siyakabikabi. Na Bada iyirughuvedi wiigeruwana damdi siyiagagudi da yadi koroto iyaragaragata. ");
INSERT INTO aui_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Raghani tana Pita da Jon ravidi gabudare 3 o'klok bi siyageegee Bare Kabikabikuwayine, rupari kiiravine. ");
INSERT INTO aui_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na tomogha tana sibanani, itubuyeni da digadigana. Bi raghani nonowa wawaya siyakawakawari da Bare Kabikabikuwayine bi garina matamketana tane siyatoretore. Matamketana kana waghawagha na Wiinuwakayowana. Meme wawaya siyarughurughu na digadigana iyipepeyana toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Raghanine ikita bi Pita da Jon nada rughu biidi na mane kiiravine ivibaba toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yadi bata rotomanina sikitabogaboga, bi Pita iwona bo, “Tam kitamii.” ");
INSERT INTO aui_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na nuwasisire ikayogagawa, iyanoghonoghosi da awaki sawarina tana siyavereni. ");
INSERT INTO aui_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bi gegha Pita iwona bo, “Tagu getana mane gwabiguve, bi awaki gwabiguve na anaverem; Yesu Keriso, Nasaret tomogha waghawaghane awonewonem. Geghomiiri da kupepewa.” ");
INSERT INTO aui_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bi Pita imanama katiiyana ikabi da itaina wiigeghomiiri; bi yaiyainagha kayena da kayetupina sivimaragata. ");
INSERT INTO aui_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Imake geghomiiri da imiiri bi pepewa idaguni, na Pita da Jon yawata sirughu Bare Kabikabikuwayina garina kamone, bi tomoyina iyapeepewa da iyikapokapoka bi God iyakabekabepepi. ");
INSERT INTO aui_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Raghanina wawaya tupadi tomoyina sikita da iyapeepewa bi God iyakabekabepepi, ");
INSERT INTO aui_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na sakovi da touna noko tomoyina iiyabo digadigana gabudara patepatena matamketa kana waghawagha Wiinuwakayowana riirine iyamakamake bi iyipepeyanana; wawaya sivisoko bi sinoghota kawakawa da awaki itubugha touna biidi. ");
INSERT INTO aui_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tomoyina iyawa na Pita da Jon itaraghoudi da yawata sirughu gawara sawoneni Solomon yana Tupatayina, bi wawaya tomoyina sikita na sivera sipiika toudi biiyadi bi sivisoko kirakii. ");
INSERT INTO aui_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bi raghanina Pita mmko ikita na iwonedi bo, “Isrel dammi, awaki biidi mmko ivinokami? Bi awaki kiiravine kokitakita bogamii, da ware mmko tomoyina toumiimani yama maragatama kayabera da iyapepewa. God matane na toumii gewawaya kiimatanimii bi mmko berana kabera. ");
INSERT INTO aui_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God, touna Abraham, Aisik bi Jeikap yadi God bi kate kayekikida tupadi yadi God, touna yana Wiitamariyana Yesu ikabepi bi wiibadana iyavereni kiiravine na mmko berana ibera. Wasina tomoyina tami kokabi bi wawaya koviruveredi da siyakasunuyi, bi tami Pailat naghone kovisinighiighiiyeni, bagune iwiini da iyawonatawani. ");
INSERT INTO aui_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tami wawaya Kabikabikuwayina bi kiimatanina kosinighiiyeni na yami wiina kobera, bi kovibaba da kasunugha wawayina biwa kamone iyikanibuveni kiiravimiye, ");
INSERT INTO aui_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","bi Yawa Badana kokasunuyi. Bi God ibera da raboboma igeghomiiri, matamiima kakita da wonawaghata. ");
INSERT INTO aui_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bi Yesu waghawaghane wiitumaghana, na mmko tomoyina iiyabo kokitakita bi kwakovi na ivimaragata; bi Yesu waghawaghane wiitumaghana sipiika na mmko tomoyina iyawa, da matamima itubugha na kokita. ");
INSERT INTO aui_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Na warewaresigu, akovi da tami yami babada yawata gekoyakovi da awaki kobera Yesu biidi, basuna gekoyakovi da touna na Keriso. ");
INSERT INTO aui_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bi mmko berana na raghani katamanine awaki God peroperoveta biiyadi iwonakasiyaragha da iyatubugha na itubugha, iwona da yana Wiivinevinegha Kiiwawona iyakabikwarakwara. ");
INSERT INTO aui_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Da kata na yami bera beroberodi kokabitoura bi konatubuwamira, bi komiiri karona God biidi, da yami tamumu inakoghatavedi. ");
INSERT INTO aui_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na Bada God kanume maragata inaveremi da koniyawiitaveyana da kanumimi sinimaragata. Bi Yesu inawonataveni tami biiyadi, wawayina iiyabo nada ivineghataveni da yami Keriso. ");
INSERT INTO aui_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Bi touna abame inamakamake patana da kana raghani waghata inapiika na God inawonataveni. Bi noko raghanine God bera peyaridi iniwuwamiredi, ware naghove waghata yana wiisuwona maragasina yana peroperoveta kabikabikuwayidi biiyadi itore da berana iyatubugha na naboni inatubugha. ");
INSERT INTO aui_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Basuna Mosis iwona bo, ‘Bada yami God peroveta tana inavineyi tami kiiravimiye, naboni tagu. Wawayina kami dam kamone inavineyi, bi yana sisiya tupana kowaiyana yapora bi kokabiteketekeni. ");
INSERT INTO aui_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Iiyabo noko perovetina geinawaiyaneni na God yana dam kamonama inakwavini bi inakasunuyi.’ ");
INSERT INTO aui_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Awaki sisiyidi peroperoveta siwonakasiyaragha na kata satubutubugha. Raghani katamanine peroveta Samwel da peroperoveta tupadi murine sisiyina tanagha sitore. ");
INSERT INTO aui_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bi God yana wiisuwona nokodi peroperoveta gwabidima na tami kiiravimiye, da kate wiiwaghasina maragasina makamakena God yana wiisuwona kayekikimi yawata sibera na touna initowawoneni tami biiyadi. Na God, Abraham iwoneni bo, ‘Tam nosinosimve na dam tupadi mmko kuburina debane animiiseyedi.’ ");
INSERT INTO aui_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","God yana noghote na yana Wiitamariyana, Yesu naghove iwonataveni tami Jius dammi biiyadi da tupami tatadigegha inimiiseyemi da yami bera beroberodima inatayinawamirimi.” ");
INSERT INTO aui_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Raghanina Pita da Jon wawaya biiyadi siyisisiya na prist babadidi da Bare Kabikabikuwayina kana wiikighukighu kadi bada da Sadusis damdi sipiika toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mmkodi babada nuwanuwadi sipughu kiiraki basuna apasol, na wawaya siyiyevevedi da Yesu yana geghomiiri na yimatakira da wawaya raboboma sinageghomiiri. ");
INSERT INTO aui_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pita da Jon sipatumidi, bi iravidi kiiravine, na tomotomoyidi biwa gawarine sitoredi patana da raghani iyabori na siyitupawamiwamiredi. ");
INSERT INTO aui_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bi gegha da, wawaya viya yadi wiiyeveveyana siwaiyaneni na sivigeruwana, da wiigeruwana damdi, tomotomogha yadi koroto iragata da 5,000. ");
INSERT INTO aui_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Raghani ibori na Jerusalem kamone babada ghamaghamadi sivitaghomidi dughu kiiravine. Kamodiye na Jius babadidi bi dogadogara da gwara wiiyeveveyana damdi, ");
INSERT INTO aui_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","bi prist kiikiiwawona Anas na nama bi yana rakaraka Kayapas, Jon da Aleksanda, da kate tomotomogha viya rakaraka kamonama yawata. ");
INSERT INTO aui_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wasina bi Pita da Jon sirutayinidi sipiika naghodiye bi sivitarakiiyanedi bo, “Mmko berana iiyabo yana maragate bo kana waghawaghae kobera?” ");
INSERT INTO aui_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bi Pita, Kanuma Kabikabikuwayina ivibonuvi na iwonedi bo, “Jius babadimi da kwanatu kana dogadogara, ");
INSERT INTO aui_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","memeda kata kwiitupawamiwamiremii bera miisena digadigana biidi kabera. Na awaki kiiravine kowiiwiini da konakovi metagha bi iyawa? ");
INSERT INTO aui_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wasina, kowaiyana, tami da wawaya tupami Isrel kamone koyakovi da Yesu Keriso Nasaret tomogha, iiyabo kotuparatu bi God raboboma ikabiwiigeghomiiri, na touna kana waghawagha maragasine na mmko tomoyina digadigana iyawa bi kata naghomiye yamiimiiri. ");
INSERT INTO aui_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Giruma katamanina ivisisiya Yesu kiiravine, iwona bo, ‘Mmko akimina meko tami abayoghayoghana kosinighiiyeni, na kata iviakima kiitowana.’ ");
INSERT INTO aui_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yawa na getana iiyabo gwabine tana banani da Yesu Kerisove. Basuna abama rogune na getana waghawagha iyamakamakena da touna yawa inavereda.” ");
INSERT INTO aui_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bi raghanina babada Wiigiugerogerora damna kamone sikita bi Pita da Jon yadi noghota ivimaragata kirakii bi sakovi da toudi gegirugirumidi, bi wawayawota na sivisokovedi, bi noghota sikabi da mmkodi tomotomoyidi na Yesu yawata siyapeepewa. ");
INSERT INTO aui_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bi tomoyina iyawa na kamodiye iyamiimiiri bi matadima siyakitakita, na noko kiiravine getana awaki siyisisiyeni, ");
INSERT INTO aui_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","bi Pita, Jon da noko tomoyina naghove idigadiga na siwonedi da Wiigiugerogerora yadi dughu gawarina siyakanibutaveni raghani tupona bi muriye toudimani kawagha siyisisiya. ");
INSERT INTO aui_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bi siwona bo, “Awaki tana bera mmkodi tomotomoyidi biiyadi? Wawaya tupadi Jerusalem kamone na sakovi da toudi berakayowiiwiiyaka ghamanakina sibera, noko kiiravine gerubana da tana keeyedina. ");
INSERT INTO aui_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bi tana gududi da mmko berana warana gegha wawaya kamodiye inaragatana, tani gesiyedi da gemeyani Yesu waghawaghane sinisisiya magha wawaya biiyadi.” ");
INSERT INTO aui_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wasina bi Pita da Jon sikwatuvedi sirughu magha bi sisiya maragasinama siwonedi da gemeyani Yesu waghawaghane sinisisiya bo siniyeveveyana. ");
INSERT INTO aui_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bi yadi bata siwonabodedi bo, “Nuwanuwami koviteteni da meko na imiise God matane. Tami kana kabisisiremi bo God kana kabisisireni? ");
INSERT INTO aui_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Awaki beradi kakita bi kawaiyaneni na gerubana da kani kawapotapota bi kanisisiyeni.” ");
INSERT INTO aui_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na babada Wiigiugerogerora damna kamone Pita da Jon siwonawinagharidi bi siwonatavedi sinagho. Getana keda siyabanani da biwa siyaveredina, basuna wawaya tupadi noko berana ghamana itubugha na kiiravine God siyakabekabepepi. ");
INSERT INTO aui_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bi noko tomoyina digadigana iyawa na kana bodu 40 ikuyoveni. ");
INSERT INTO aui_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Prist babadidi da kwanatu kana dogara Pita da Jon siwonatavedi sinagho murine na yadi bata siveramagha wiigeruwana dam turaturadi biiyadi. Bi babadidi metagha siwonedi na tupana sivimaghamaghatara. ");
INSERT INTO aui_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wiigeruwana damdi siwaiyanedi na tupadi yadi noghota tanagha bi God biidi rupari sidaguni, “Bada Ghamam, tam abama da kubura da yegii kubera da bera tupana kamodiye. ");
INSERT INTO aui_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tam Kanuma Kabikabikuwayine kuvisisiya yam wiitamariyana, kayekikimii Deivid kawanama kuwona bo, ‘Awaki kiiravine dam bi dam nuwanuwadi sapughupughu, bi wawaya sitarapiri kawakawa God wiiaviyenina kiiravine? ");
INSERT INTO aui_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kubura kana kiikiiwawo da kadi wiinaghowana sinitaghomidi sinakabunagha, bi Bada siniaviyeni yana Wiivinevinegha Kiiwawona yawata sinirouwa.’ ");
INSERT INTO aui_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Wonawaghata Herod, Pontis Pailat, da kubuve makamakedi da Isrel damdi yawata mmko kwanatuna kamone sivitaghomidi da Yesu, yam Wiitamariyana Kabikabikuwayina, siviaviyeni, touna na tam, yam Wiivinevinegha. ");
INSERT INTO aui_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Toudi awaki sibera na tam yam maragata da yam wiina naghove waghata kunuwagiurenina iyatubugha. ");
INSERT INTO aui_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wasina katana, Bada, yadi wonawiinaghanaghara kuwaiyana da yam wiitamatamariyana maragata kuveremii da mayitepamii sinatora bi wonam kanadimeni. ");
INSERT INTO aui_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bi imam kukoghasi da wawaya kuniyawiidi bi yam Wiitamariyana Kabikabikuwayina Yesu waghawaghane berakayowiiwiiyaka da matakira ghamadi kunabera.” ");
INSERT INTO aui_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Sirupari ikovi bi meko gawarine sivitaghomidi na barena ivinukenuke. Bi Kanuma Kabikabikuwayina ivibonuvidi, na noko raghanine sidagu da ere sinitoradi God wonana siyadimedimeni. ");
INSERT INTO aui_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wiigeruwana damdi tupadi nuwanuwadi bi yadi noghota na tanagha. Bi getana iiyabo iyawona da yana sawara na touna rapenena, bi gegha, yadi sawara tupadi na debae siyatutoura. ");
INSERT INTO aui_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bi God yana wiiwiita ghamana toudi biiyadi iragata da ivimiiseyedi, na apasol siyimaghamaghatara da Bada Yesu raboboma igeghomiiri. ");
INSERT INTO aui_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bi kamodiye na getana iiyabo gomagomarina, basuna iiyawogha bare bo tanawa rapediye na siyiigimona bi manena ");
INSERT INTO aui_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","apasol siyavereveredi da turaturadi gomagomaridi siyarerereyedi. ");
INSERT INTO aui_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Bi tomogha tana, kana waghawagha Jousep, kana dam Livai bi yana kubura Saipras, bi touna apasol sikwatuveni Banabas, (waghawaghana basuna Wonawiiyoyowana wawayina mma bada naboni ibera). ");
INSERT INTO aui_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Da tanawa rapene na ivigimoneni bi manena ikabi ipiikeni da apasol iveredi. ");
INSERT INTO aui_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wasina tomogha tana kana waghawagha Ananaiyas, da wavinena Sapira yawata, yadi tanawa bada pinimina sivigimoneni. ");
INSERT INTO aui_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bi wavinena yana wiiwaghasine na Ananaiyas manena muduna ikabigudu touna kiiravine bi muduna ipiikeni da apasol iveredi. ");
INSERT INTO aui_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bi Pita iwona bo, “Ananaiyas, awaki kiiravine kuviwaghasina da Seitan nuwanuwam ivibadeni bi Kanuma Kabikabikuwayina kuviyabeni bi yam tanawa manena muduna kukabigudu kiiravimve? ");
INSERT INTO aui_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tanavina tam rapemve bi muriye kuvigimoneni; bi kuvigimoneni ikovi murine na manena na tam yam mane, yam kayowane kuyabera. Awaki kiiravine mmko berana berona kubera? Gegha wawaya biiyadi kawagha kuyiyabana, bi God biidi kwiiyaba!” ");
INSERT INTO aui_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Raghanina Ananaiyas mmko sisiyina iwaiyaneni na yaininagha ibeku iyowogha da irabobo. Wawaya tupadi awaki itubugha bi siwaiyaneni na naghara ikabikirakiiyedi. ");
INSERT INTO aui_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wasina bi, yaraga simiiririya da tubuyina sigere bi sikawari sikanibu da sidogu. ");
INSERT INTO aui_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Geraghani gurina bi murine na wavinena irughu bi geiyakovi da awaki itubugha. ");
INSERT INTO aui_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na Pita wasikena ivitarakiiyaneni bo, “Kuwonegu, tam da Ananaiyas tanawa kovigimoneni na miisanina tupana mma naboni bo?” Bi wasikena iwona bo, “Eka, wasina miisanina namakatanina.” ");
INSERT INTO aui_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Na iwonabodeni bo, “Metagha konoghosi bi Bada Kanumina Kabikabikuwayina koyaruyaghani? Kita, yaraga iiyawogha moghanem sidogu na siverakanibu matamkete samiimiiri, bi tam bada sinakawarim sinakanibu.” ");
INSERT INTO aui_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na yaininagha wasikena Pita naghone ibeku iyowogha da irabobo. Raghanina yaraga sirughu da sikita irabobo na sikawari sikanibuveni da moghanena ririne sidoguni. ");
INSERT INTO aui_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bi wiigeruwana damdi tupadi da kate wawaya mududi mmko berana sisiyina siwaiyaneni na naghara ikabikirakiiyedi. ");
INSERT INTO aui_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apasol berakayowiiwiiyaka da matakira peyaridi wawaya kamodiye siyaberabera. Bi raghani nonowa na wiigeruwana damdi Solomon yana tupatayina kamone siyiitaghomidi. ");
INSERT INTO aui_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bi ere nagharidi na getana iiyabo iyiikapuvedi, bagune wawaya na siyiyayedi da toudi sigekirakii. ");
INSERT INTO aui_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bi gegha, raghani nonowa na wawaya korotodi siyarughurughu kamodiye, tomotomogha bi wasiwasike sidagu da Bada siyigeruveni na yadi koroto siyiagagu. ");
INSERT INTO aui_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bi apasol yadi bera ghamanakidi kiiravine, na wawaya turaturadi gubagubagidi siyakawakawaridi siyakanikanibu, keda riridiye bi rito da kepana debadiye siyikenedi, da Pita iyapepewa iyanono na memeda mekeyu kawanagha iyarogutawanidi. ");
INSERT INTO aui_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bi kate koroto ghamana meyagii gisigisidi Jerusalem ririne bada siyariyeriyeni, bi yadi wawaya gubagubagidi da iiyawogha kanuma beroberodi gwabidiye na siyapiipiikedi da tupadi siyawa. ");
INSERT INTO aui_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Noko murine prist kiikiiwawona babada turaturana iiyawogha, toudi na Sadusis damdi, sinuwakapi kirakii apasol biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Noko kiiravine sipatumidi da biwa gawarine sitorerughuvedi. ");
INSERT INTO aui_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bi nubabasuve na Bada yana aneya biwa gawarina matamketadi ikabitavedi bi ivinaghovedi sikanibu. ");
INSERT INTO aui_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Bi iwonedi bo, “Konagho, Bare Kabikabikuwayina garina kamone komiiri bi wawaya biiyadi yawa makewaghawaghasina sisiyina tupana konadimeni.” ");
INSERT INTO aui_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Raghani ibori na metagha aneya iwonedi na sibera. Da sirughu Bare Kabikabikuwayina garina kamone bi wiiyeveveyana sidaguni wawaya biiyadi. Raghanina prist kiikiiwawona babada turaturana yawata siverakanibu na Wiigiugerogerora damna sikasiwiitaghomi nokona Isrel kana babada ghamaghamadi tupadi sipiika dughu kiiravine bi Bare Kabikabikuwayina kana wiikighukighu damdi siwonatavedi biwa gawarine da apasol siyapiikedi. ");
INSERT INTO aui_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bi raghanine Bare Kabikabikuwayina kana wiikighukighu barene sinokanibu, na sikita da apasol gegha nama. Noko biidi siveramagha na sivimaghamaghatara, ");
INSERT INTO aui_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","siwona bo, “Matamketa guduguduna bi wiikighukighu damdi nama, siyabodaboda. Bi raghanina kakabitaveni na kamone wawaya gegha.” ");
INSERT INTO aui_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bi prist babadidi da Bare Kabikabikuwayina kana wiikighukighu yadi bada mmko sisiyina siwaiyaneni na yadi noghota siruragharagha, bi nuwanuwadi siyiteteni da awaki inatubugha. ");
INSERT INTO aui_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Bi wawaya tana ipiika bi iwonedi bo, “Kowaiyana, tomotomogha biwa gawarina kamone kotoredi na Bare Kabikabikuwayina garina kamone samiimiiri bi wawaya siyevevedi.” ");
INSERT INTO aui_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bare Kabikabikuwayina kana wiikighukighu damdi gegha tupeyanama Apasol siyarutayinidi siyapiikedi basuna sinaghara kirakii kate bi wawaya akimama siyarouvidi. ");
INSERT INTO aui_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wasina bi apasol sirutayinidi sipiika na Wiigiugerogerora naghodiye sivimiiridi da prist kiikiiwawona iyitupawamiwamiredi. ");
INSERT INTO aui_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Bi touna iwonedi bo, “Sisiya maragasidima kawonemi da gegha Yesu waghawaghane koyiyeveveyana. Bi gegha, kovikawakeekee na yami wiiyeveveyana Jerusalem inunuri, bi kate kowiiwiini da Yesu yana rabobo kiiravine koyiwawumii.” ");
INSERT INTO aui_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bi gegha Pita, apasol turaturana yawata siwonabodedi bo, “Toumii God kana kabisisireni bi gegha wawaya! ");
INSERT INTO aui_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kayekikidam yadi God ibera da raboboma Yesu igeghomiiri iiyabo kiiye kovirorogi da koviraboboni murine, ");
INSERT INTO aui_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","bi ikabepi da ririne ivimakeni bi wiibadana ivereni da touna Kiiwawo bi Wiiwiiyawa, bi mmkodi bera ibera na Isrel damda tana miiriwamira bi yada tamumu tana kabitoura da God noghotataveyana inavereda. ");
INSERT INTO aui_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Toumii mmkodi bera tupadi matamiima kakita na kiimaghamaghatara, bi kate Kanuma Kabikabikuwayina yawata yimaghamaghatara meko God ivereyana da wawaya iiyawogha sakabikabisisireni na kadi puyo.” ");
INSERT INTO aui_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Raghanina Wiigiugerogerora damdi mmko sisiyina siwaiyaneni na nuwanuwadi sipughu kirakii bi yadi wiina da apasol siyikasunughana. ");
INSERT INTO aui_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bi Perisi tana, kana waghawagha Gamariel, touna na gwara kana wiiyeveveyana tomoyina, bi wawaya tupadi yadi kabikuwaya touna biidi, na Wiigiugerogerona damna kamonama igeghomiiri iwonayaragha da apasol bare kamoma siyikanibuvedi kubuve raghani gisina siyamake. ");
INSERT INTO aui_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wasina bi Gamariel, Wiigiugerogerora damdi iwonedi bo, “Isrel turaturagu, kovinuwanoghonoghota yapora muriye da awaki konabera mmkodi tomotomoyidi biidi. ");
INSERT INTO aui_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Rorowainagha tomogha tana kana waghawagha Tiyodas igeghomiiri bi iyawonawona da touna na bada ghamana tana, bi tomotomogha yadi 400 sivigeruveni na sikivini; bi gegha da sikasunuyi na kana kivikivina sivivera bogabogae da awaki iyabera na imomogha. ");
INSERT INTO aui_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bi touna murine na Galili tomogha tana kana waghawagha Jiudas, bi sensis raghanine igeghomiiri bi yana wawaya ivinaghovedi da Roum babada biiyadi siyiaviya. Bi touna bada sikasinuyi na kana kivikivina siviverabogabogae. ");
INSERT INTO aui_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Noko biidi, tagu iikatayimi, da mmkodi tomotomoyidi kokabitoredi bi kokuyovedi sinanagho! Memeda toudimani yadi noghotama mmkodi bera saberabera na katare sinakovi. ");
INSERT INTO aui_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bi memeda mmkodi noghota God gwabinama sipiika, na gerubana da kate konageiwayidi; bi gududi konibageni na konabanana mayemi da tami wosina God koniaviyeni.” ");
INSERT INTO aui_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamariel yana sisiya kiiravine Wiigiugerogerora damdi yadi noghota iwamiri. Na apasol sikwatuvedi sirughu da siwakiwakiridi. Bi sisiya maragasinama siwonedi da gemeyani Yesu waghawaghane siyisisiya maghana, bi siwonatavedi sinagho. ");
INSERT INTO aui_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apasol Wiigiugerogerora damdi sikuyovedi ere nuwamiisedi, basuna God ivineyidi da Yesu kana waghawagha kiiravine siyakabikwarakwara. ");
INSERT INTO aui_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bi raghani nonowa Bare Kabikabikuwayina garina kamone da bare nunudigha na wara miisena siyiyeveveyana bi siyadimedimeni da Yesu na God yana Wiivinevinegha Kiiwawona. ");
INSERT INTO aui_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mmkodi raghanidiye, raghanina wiigeruwana damdi patana yadi koroto iyaragaragata da Yesu siyigeruveni, na wiigeruwana damdi iiyawogha na Jius bi Grik gamoma siyisisiya na Jius wadubo iiyawogha Hibru gamoma sisisiyana toudi biiyadi siyagwinigwini, basuna nokodi wawaya iiyawogha mane gabudara nununagha, siyareeregha kwabukwabura biiyadi na Grik kwabukwabura gesiyakitakita yaporidina. ");
INSERT INTO aui_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Na wasina bi Apasol yadi 12 wiigeruwana damdi tupadi sikwatu wiitaghomidi bi siwonedi bo, “Gegha iyamiise da God wonana dimana kana kabitore bi mane kana kabirereghana. ");
INSERT INTO aui_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Noko biidi warewaresimii, tomotomogha miisedi kabikabikarawayidi yadi 7 kamomima kovinegha, iiyawogha na Kanuma Kabikabikuwayina ivibonuvidi bi nuwanuwagiuridi. Da maragata kanaveredi bi mmko bagibagina sinibadeni ");
INSERT INTO aui_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","bi toumii wosina na pari bi kate God wonana kana kabikikisidi bi kanadimeni.” ");
INSERT INTO aui_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wawaya tupadi Apasol yadi sisiya siviwaghasineni na Sitivin sivineyi, tomogha iiyabo yana wiigeruwana God gwabine bi Kanuma Kabikabikuwayina ivibonuvina. Bi kate bada mmkodi tomotomogha sivinegha Piripo, Prokoras, Nikano, Timon, Pamenas bi Nikoras (touna Antiyok tomogha. Nikoras touna gegha Jiu bi gegha da Jius yadi kabepepa ivigeruveni). ");
INSERT INTO aui_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wiigeruwana damdi mmkodi tomotomoyidi sipiikedi Apasol biiyadi, na sirupariyedi da imadi gayamidiye sitoura bi maragata siveredi da bagibagi siyabera. ");
INSERT INTO aui_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wiigeruwana damdi patana God wonana siyiisisiyena wiikaruveni na wawaya korotodi Jerusalem kamone Yesu sivigeruveni bi kate prist korotodi Yesu wiigeruwanina kana wiiyeveveyana sikabisisireni. ");
INSERT INTO aui_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wasina bi God, Sitivin ivimiiseyena kirakiiyeni na wiiwiita da maragata ivereni na berakayowiiwiiyaka da matakira wawaya kamodiye iyabera. ");
INSERT INTO aui_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bi gegha da Jius mududi siviaviyeni, toudi na kwanatu ghamaghamadi Sairin da Aleksandriya tomotomogha bi Kabepepa Barena kana waghawagha, Gemuriye Wiibagubagurana kana babada, bi mududi na Silisiya da Eisiya damdi. Mmkodi tomotomogha sivimatipo da Sitivin teya siyigamowana, ");
INSERT INTO aui_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","bi gegha, gerubadi da awaki Sitivin iwonedi na siyawonabodeni basuna yana nuwagiura igekirakii bo Kanuma Kabikabikuwayina mekoma iyiisisiyana. ");
INSERT INTO aui_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Na tomotomogha mududi wiikowoye sivitamariyedi da siyiyaba siyawona bo, “Toumii kawaiyana da Sitivin, sisiya berodima Mosis da God ivigibogha berovedi.” ");
INSERT INTO aui_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mmko kedane na toudi wawaya nuwanuwadi sipiro, dogadogara da gwara wiiyeveveyana damdi yawata, na tupadi Sitivin sikabitawani bi sitayitayini sinagho Wiigiugerogerora babada biiyadi, ");
INSERT INTO aui_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","wasina bi wawaya mududi sirutayinidi sirughu da wiiyaba sisiyidi siyabera. Wawayidi siwona bo, “Mmko tomoyina nonowa sisiya berodi iyisisiyana Bare Kabikabikuwayina da Mosis yana gwara kiiravidiye; ");
INSERT INTO aui_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","kiiravine kawaiyana iwona da mmko Nasaret tomogha Yesu, Bare Kabikabikuwayina inakourika bi kate yada kiki mekodi Mosis, nosinosidanakim iviyevevedi bi siviyeveveda na inawamira.” ");
INSERT INTO aui_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wawaya tupadi Wiigiugerogerora damna kamone Sitivin sikitarukunukunuveni bi sikita da mayiyina na ware aneya mayiyina naboni. ");
INSERT INTO aui_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wasina bi prist kiikiiwawona Sitivin ivitarakiiyaneni bo, “Mmkodi wawu sisiyidi wiisuwona bo gegha?” ");
INSERT INTO aui_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na Sitivin iwona bo, “Warewaresigu bi tamagunakim, yagu sisiya kowaiyana. Muriye da nosidanaki Abraham iyanagho Haranne iyamakae, bi patana Mesapotemiyane iyamakamake, na God Kiidamo Kirakiina irumaghatara touna biidi, ");
INSERT INTO aui_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","bi iwoneni bo, ‘Yam kubura da yam rakaraka kuyovedi bi kunagho da gawara tana meko aniyevevemna nabo.’ ");
INSERT INTO aui_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Na Abraham noko gawarina ikuyoveni, bi inagho Haran kwanatune imakewiipikapika. Bi tamananaki irabobo murine, na God ivipora mmko kuburine iyamakae meme kata tamakamakena. ");
INSERT INTO aui_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Noko raghanine God getana tanawa iyavereni da iyirapeneni, getana pinimarurunana, bi ivisuwona da muriye na Abraham da nosinosina tanavina inaveredi da sinirapeneni, bagune noko raghanine na gegha ere natunatuna. ");
INSERT INTO aui_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Muriye na God, Abraham mma naboni iwoneni, ‘Nosinosim na kubura wiibate sinibaretaya mekona gegha rapediyena. Bodu 400 kamodiye na noko kuburina damdi sinakabidi da kiiravidiye sinabagibagi bi bada sinitupaketowanedi. ");
INSERT INTO aui_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bi raghani muriye nosinosim kadi biwa nokodi dam siyabagibagiyedina gwabidiye anakabi bi nosinosim kuburina sinikanibutaveni da sinapiika mmko gawarine sinakabepepigu.’ ");
INSERT INTO aui_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wasina bi God wiiwaghasina maragasina makamakena Abraham yawata sibera, kana matakira na sinibori. Na raghanine Abraham natuna Aisik itubugha, bi gabudara 8 sikovi murine na mayinaghona matabekana iboritaveni, muriye na Aisik natuna Jeikap bada mayinaghona matabekana iboritaveni bi Jeikap natunatuna yadi 12 bada mayinaghodi matabekadi iboritavedi. Mmkodi tomotomoyidi na nosinosidanakim. ");
INSERT INTO aui_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jeikap natunatuna tiidiru Jousep sinuwakapiyeni na wiigimona damdi biiyadi sivigimoneni naboni wiibagubagurana da sinaveni Ijiptma. Bi gegha da God na Jousep gwabine ");
INSERT INTO aui_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","na raghanina wawaya nuwapoya siyaverevereni na iyiiwiiteni, God nuwagiura ivereni bi ibera da Ijipt kana kiiwawo ikabikuwayeni, na kiiwawona, Jousep itore da Ijipt kana wiibadana bi kate yana bare tupana. ");
INSERT INTO aui_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wasina bi kapoe Ijipt da Kenen kuburidiye itubugha, na wawaya siyakabikabikwarakwara kirakii, bi Jousep warewaresina, touda nosinosidanakim sigomara da kam gegha. ");
INSERT INTO aui_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bi raghanine Jeikap iwaiyana da Ijiptne kam iyamakamake, na nabo natunatuna iviporadi, touda nosinosidanakim da kam mududi siyagimona. Nokona yadi wagawaga dagudaguna sinagho Ijiptma. ");
INSERT INTO aui_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bi raghanina yadi wagawaga wiibatane siveramagha nabo kam siyagimona magha, na Jousep warewaresina biiyadi ivimaghamaghatara da touna iiyabo, na Ijipt kana kiiwawo, Jousep yana rakaraka akovidi ikabi. ");
INSERT INTO aui_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Wasina bi Jousep wara idaru tamananaki Jeikap da yana rakaraka tupadi biiyadi iwonedi da sinapiika Ijiptma. Bi noko raghanine na wawaya tupadi yadi 75. ");
INSERT INTO aui_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na Jeikap iyowogha inagho Ijiptma, kubura meme muriye, touna da natunatuna nosinosidanakim sirabobo. ");
INSERT INTO aui_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na tubuyidi sikawara siveramagha Sikem kwanatune da karawaga akima kakokakone sibanina name sitoredi, meko Abraham ghuyoghuyone Hamo natunatuna gwabidima igimonina. ");
INSERT INTO aui_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Raghanina God yana wiisuwona Abraham biidi itore da awaki iyabera na gabudarina iyitutukabikabi, na yada wawaya Ijipt kamone sivituwawiipeyara da nada yadi koroto iragata kirakii. ");
INSERT INTO aui_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wasina bi kiiwawo wouna idagu Ijipt kuburina iyibadeni, touna Jousep geiyakovina. ");
INSERT INTO aui_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Touna yada wawaya iyiyabedi bi nosinosidanakim iyiikayotaketowanedi. Bi iberadi da natunatudi pepeyidi woudi siyiitavena kanibuwana da siyarabobo. ");
INSERT INTO aui_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Noko raghanine na Mosis itubugha, bi simirina God matane na ivikomerowana kirakii. Nawaravi aroba kamone taghununanaki wiikowoye bare kamone sikoyayi. ");
INSERT INTO aui_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bi raghanina sitorekanibuveni maghatare, na kiiwawo natuna wasike ikabi da iyabiyi bi ikoyayi naboni touna wosina natuna. ");
INSERT INTO aui_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bi Ijipt damdi yadi akowa tupana Mosis siviyeveveni na yana sisiye da yana beraye na touna ivimaragata kirakii. ");
INSERT INTO aui_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Muriye, raghanina Mosis kana bodu 40, na noghota ikabi da touna wosina yana rakaraka, Isrel damdi iyarubodadi. ");
INSERT INTO aui_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na yana pepewa kamone ikita da Ijipt wawaya tana Isrel tomogha iyikayotaketowaneni na kana babara ikabi, da Ijipt wawaya ikasunuyi da biwa ivereni. ");
INSERT INTO aui_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosis inoghosi da touna wosina yana wawaya akowa siyakabi da wiiyawiidi kiiravine na God ivipora da gesiyibagubagurana Ijipt damdi kiiravidiye, bi gegha da gesiyakovina. ");
INSERT INTO aui_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Raghani ibori, na Mosis, Isrel tomotomogha bata ikitadi siyirouwa na iberatowoyi da yadi wiirouwa siyakabitore bi nuwaruriri siyakabi. Na iwona bo, ‘Turaturagu, tami na rakarakami, bi awaki biidi kwiirouwa kabivivirana?’ ");
INSERT INTO aui_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Bi gegha da tomogha meko kwiinana iyarurouvi na Mosis irubukiitaveni bi iwona bo, ‘Iiyabo itorem da kunibademii da kunitupawamiwamiremii? ");
INSERT INTO aui_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bi yam wiina da kunakasunuyigu ware raviravi Ijipt wawaya kukasunuyina naboni bo?’ ");
INSERT INTO aui_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Raghanina Mosis noko sisiyina iwaiyaneni na inaghara da Ijipt ikuyoveni bi iverataveyana inagho ivikuburawiibata wawaya Midiyan kubure imakae. Name iyamakamake da muriye na Midiyan wasike irawayi da natunatuna tomotomogha bata situbugha. ");
INSERT INTO aui_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Bi bodu 40 sikovi murine, na raghani tana mayabe Sainai Koyana ririne aneya irumaghatara touna biidi, kana kita ware keyama gweyurina naboni kiikiiruku basunama iyapiipiika. ");
INSERT INTO aui_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Raghanina Mosis noko ikita na inokena kirakiiyeni na inagho wiitupo da kiikiirukuna iyakita. Wasina bi Bada God gamona iwaiyaneni iwona bo, ");
INSERT INTO aui_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Taguna nosinosiminakim yadi God, Abraham yana God, Aisik da Jeikap yadi God.’ Na Mosis noko sisiyina iwaiyana na idagu iyakirokiroro bi inaghara kirakii na geiyakayogagawa da iyakitana. ");
INSERT INTO aui_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wasina bi Bada, Mosis iwoneni bo, ‘Kam kayeturababara kabitavetaveyena basuna tanawa meme kwamiimiiri na Kabikabikuwayina. ");
INSERT INTO aui_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tagu akita da metagha Ijipt damdi yagu wawaya sikayotaketowanedi. Bi yagu wawaya yadi kabikwarakwara kamone siyakabikabida na awaiyana na ayowogha da aniyawiidi. Na kata kuwaiyana, Tagu aniporam kunaveramagha Ijiptma da kuniwiitedi.’” ");
INSERT INTO aui_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Wasina bi Sitivin ivisisiya wiikaru iwona bo, “Mmko tomoyina, Mosis na tomogha waghasina Isrel damdi sivisinighiighiiyeni raghanina siwona bo, ‘Iiyabo itorem da kunibademii da kunitupawamiwamiremii?’ God, Mosis idaru da aneya meko irumaghatara touna biidi kiikiiruku iyakarakarasina kamone na yana wiiwiitama iyibadedi bi Ijipt damdi yadi wiibadanama iyiyawiidi. ");
INSERT INTO aui_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Bi berakayowiiwiiyaka da matakira name Ijiptne ibera bi ivinaghovedi sikanibutaveyana bi kate Yegii Idurine da kate mayaba kamone bodu 40 siyamakamakena raghanine. ");
INSERT INTO aui_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mmko Mosis na, mayimayiyina bada Isrel damdi iwonedi bo, ‘God, peroveta tana kiiravimiye inavineyi tamimani kamomima, ware ivineyigu na naboni wonana anisisiyeni tami biiyadi.’ ");
INSERT INTO aui_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosis na Isrel damdi yawata raghanina mayabe sivitaghomidina, touna nama nosinosidanakim yawata, bi kate aneya yawata iiyabo ivisisiya touna biidi Sainai Koyana debane. Bi name God wonana makewaghasinina ikabi da iyitowawoneni touda biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bi gegha da nosinosidanakim gesiyakabisisirenina, toudi sivisinighiighiiyeni bi siwiini da siyaveramagha Ijiptma. ");
INSERT INTO aui_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Raghanina Mosis, Sainai Koyana debane na toghanaru Eron siwoneni bo, ‘Mosis iiyabo Ijipt kuburama ikabikanibuveda, na gekayakovi da touna meme, na tam kiiravidae tarabiibiisaka kunaberadi da toudi god bi sininaghoveda.’ ");
INSERT INTO aui_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na noko raghanine tarabiibiisaka sibera da yadi god, kanakita ware kau natuna makina naboni bi sisuwari da awaki imadima siberana noghosine sikam kepokepo. ");
INSERT INTO aui_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Na God imiirikubutedi bi ivitamariyedi da kewokewo, gabudara da matu abame siyapepetedi, metagha peroperoveta God wonana buka kamone sigirumina naboni, iwona bo, ‘Isrel dammi, bo gegha ribiribi koyunugha koyagibu da koyasuwariguna, raghanina bodu 40 mayabe koyamakamakena? ");
INSERT INTO aui_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tami yami god Molek yana kiregoru kokawari, bi kate Ripen gubana yami kewokewo godna, nokodi sawara mekodi kobera da koyapepetedi. Na wawaya aniporadi da yami kuburama sinakabitavemi bi sinanavemi kubura rabarabae Babilon bi nabo.’” ");
INSERT INTO aui_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitivin ivisisiya wiikaru bo, “Nosinosidanakim, raghanina mayabe siyamakamake na God yana gwabiyana kiregoruna sikawari, God, Mosis iwoneni da metagha iyabera, bi kitana ware God, Sainai Koyana debane guba Mosis iviyevevenina naboni. ");
INSERT INTO aui_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Muriye raghanina Josuwa nosinosidanakim ivinaghovedi bi God yana wiiwiitae mmko kuburine iiyawogha mma siyamakamake na sigeiwayidi, bi God yana gwabiyana Kiregoruna mabo sikawari sipiika, bi mma imakae patana da kiiwawo Deivid yana raghaniye. ");
INSERT INTO aui_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na God yana wiina ghamana na Deivid, noko biidi God ivibabiini da iyiwaghasineni bi bare God kiiravine iyayoghani da kamone iyamake meme Jeikap nosinosina Isrel damdi siyakabepepi. ");
INSERT INTO aui_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bi gegha Deivid natuna Solomon touna Kabepepa Barena iyoghani. ");
INSERT INTO aui_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bi gegha, God Kiidamo Kirakiina, gewawaya imadima bare sayoghana na kamodiye iyamakamakena, ware naghove waghata peroveta igirumana naboni da Bada iwona bo, ");
INSERT INTO aui_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Abama na yagu wiikiiwawo gawarina meme anamake bi anibada, bi kubura na kayegu kana kepana. Na awaki barena kiiraviguve konayoghani? Tami gerubana gawara miisena kiiraviguve konabera da aniyawiitaveyana. ");
INSERT INTO aui_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Basuna Tagumani bera tupana abama kamone da kubure debane abera.’” ");
INSERT INTO aui_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Wasina bi Sitivini ikidi iwona bo, “Tami nuwanuwami sikotakii! Bi God gegha koyakabikabi sisirenina bi tainami sipota da yana sisiya gekoyawaiwaiyana. Tami Kanuma Kabikabikuwayina kwiiaviyeni, ware nosinosiminakim siberana naboni. ");
INSERT INTO aui_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nosinosiminakim peroperoveta tupadi God iviporadi toudi biiyadi na sivikayotaketowanedi. Bi kate peroperoveta iiyawogha naghove waghata siwonakasiyaragha da Keriso, Wiitamariyana kiimatanina iyapiika na sivikasunughana. Bi raghanina ipiika na kana puke kokabi bi kokasunuyi. ");
INSERT INTO aui_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tami wosina God yana gwara kokabi, meko aneya ivitowawoneni nosinosidanakim biiyadi bi gegha da gekoyakabi sisirenina!” ");
INSERT INTO aui_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Raghanina Jius babada mmko sisiyina siwaiyaneni na nuwanuwadi sipughu kirakii bi nighodi sivitaragiigiiyana Sitivin biidi. ");
INSERT INTO aui_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bi gegha da touna Kanuma Kabikabikuwayina ivibonuvi, na ikayogagawa abame da God yana kiniwa ikita, bi kate Yesu gawara kabikabikarawayine iyamiimiiri God katiiyane. ");
INSERT INTO aui_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wasina bi iwonedi bo, “Kowaiyana, Tagu akita da abama itamotatara, bi Wiisuwona Tomoyina gawara kabikabikarawayine yamiimiiri God katiiyane.” ");
INSERT INTO aui_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bi gegha Jius babada sirukwatu gwaru bi tainadi sigudubodaboda bi sidabuririyi Sitivini biidi. ");
INSERT INTO aui_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Da sitainakwarokwaro kwanatu sikanibutaveni bi sidagu akimama siyarurouvi; Tomotomogha iiyawogha siviwawu na kadi kwama wowodiye sikabitavetaveyana da tomogha yaragina, kana waghawagha Sol kayekunukunune sitoura da iyakoyagha. ");
INSERT INTO aui_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Raghanina Sitivin akimama patana siyarurouvi, na mma naboni irupari, “Bada Yesu, kanumigu kabi.” ");
INSERT INTO aui_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wasina bi ivituwapore oghogheyana bi gamo ghamanama irukwatu iwona bo, “Bada, mmko tamumunama gearo kunaveredina.” Bi mmko naboni ivisisiya murine, na nuwanuwana iwapa. ");
INSERT INTO aui_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Bi mmkodi bera situbugha na Sol matanama ikita na iviwaghasina da Sitivin sikasunuyi. Jius babada Sitivin sikasunuyi bi murine, na tomotomogha iiyawogha God siyakabekabepepi, na mududi siduu siyapa kirakii bi tubuyina karawaga epamana bonayine sitore. Noko gabudarina mayimayiyine na wawaya sidagu wiigeruwana damdi siyikayotaketowanedi mekodi Jerusalem kamone siyamakamakena, na tupadi sivivera bogabogae meyagii mududiye Jiudiya da Sameriya kuburidiye. Wasina apasol kawagha Jerusalemne simakae. ");
INSERT INTO aui_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Bi Sol na iyiimatipo da wiigeruwana damdi iyakasiwiiberodi. Na bare nunudigha iyiirughukanibu da wiigeruwana damdi, tomotomogha da wasiwasike iyatayitayina kanibuwana bi biwa gawarina kamone iyatoretoredi. ");
INSERT INTO aui_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wiigeruwana damdi iiyawogha Jerusalem sikuyoveni na sinagho kubura bi kubura, Yesu Warana Miisena siyadimedimeni wawaya biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Bi Piripo inagho kwanatu tana Sameriya kubura kamone da God yana Wiivinevinegha Kiiwawona kiiravine wawaya biiyadi iyadimadima. ");
INSERT INTO aui_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Raghanina wawaya, Piripo iyadimadima na siwaiyaneni bi kate berakayowiiwiiyaka iyaberabera sikita, na yadi noghota tanagha bi yana sisiya siyawaiwaiyana wiimasi. ");
INSERT INTO aui_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Basuna Piripo na kanuma beroberodi wawaya gwabidima iyarurukwavina na siyakabikabida bi siyakanikanibu. Bi kate bada wawaya sinidi raborabobodi da digadigadi iyiiyawiidi. ");
INSERT INTO aui_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na wawaya noko kwanatuna kamone sivinuwamiise kirakii. ");
INSERT INTO aui_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wasina bi tomogha kana waghawaga Saimon noko kwanatuna kamone iyamakamake bi raghani iguri iyikiirapu, na Sameriya damdi awaki iyaberabera na siyisokoveni. Bi nonowa na iyatoretoregeegeeyeni da touna wawaya ghamana. ");
INSERT INTO aui_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wawaya tupadi, babada bi iyowogha inagho wawaya wota, yana sisiya siwaiyana wiimasiyeni bi siwona bo, “Mmko tomoyina na God yana sawariyonayona maragasina meko sakwatuveni da Maragata Ghamana!” ");
INSERT INTO aui_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Raghani gurina yana wiikiirapu siyisokoveni na noko biidi siyawaiwaiyanena wiimasiyeni. ");
INSERT INTO aui_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bi raghanina Piripo, God yana wiibadana da Yesu Keriso kana waghawagha Waradi Miisedi toudi biiyadi iyadimadima, na yana sisiya sivigeruveni da ibabataitodi, tomotomogha da wasiwasike. ");
INSERT INTO aui_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon touna wosina bada ivigeruwana da ibabataito. Bi idagu Piripo iyakivikivini meghamegha iyanonona bi iyisokovena kirakiiyeni basuna ikita da Piripo, matakira da berakayowiiwiiyaka iyaberabera. ");
INSERT INTO aui_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wasina raghanina apasol Jerusalem kamone siwaiyana da wawaya korotodi Sameriya kubura kamone God wonana sivigeruveni, na Pita da Jon siviporadi toudi biiyadi, ");
INSERT INTO aui_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","bi raghanina apasol nama siverakanibu, na sirupari da God, Kanuma Kabikabikuwayina iyipora nokodi wiigeruwana damdi woudi biiyadi; ");
INSERT INTO aui_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","basuna Kanuma Kabikabikuwayina genada iyayowogha da wiigeruwana damdi woudi iyibonuvidina, toudi Bada Yesu waghawaghane kawagha sibabataito. ");
INSERT INTO aui_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wasina bi Pita da Jon imadi wiigeruwana damdi woudi gayamidiye sitoura na God, Kanuma Kabikabikuwayina ivipora toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wasina bi raghanina Saimon ikita bi apasol imadi wiigeruwana damdi woudi gayamidiye siyatutoura na Kanuma Kabikabikuwayina wawaya iyibonuvidi, na Pita da Jon manema ipuyodi ");
INSERT INTO aui_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","bi iwonedi bo, “Mmko maragasina tagu bada koveregu, da iiyawogha gayamidiye imagu anatoura na Kanuma Kabikabikuwayina sinakabi.” ");
INSERT INTO aui_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bi gegha da Pita, tomoyina iwoneni bo, “Rubana da God, tam da yam mane iniberomi basuna kunoghosi da rubana manema Kanuma Kabikabikuwayina kunagimoni, meko God yavereyanawota wawaya biiyadi! ");
INSERT INTO aui_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bi getana kamreregha mmko bagibagina kamone, basuna nuwanuwam God matane na gerotomaninana! ");
INSERT INTO aui_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Noko biidi yam noghota beronama kumiiri karona, bi Bada biidi kurupari da, rubana memeda yam noghota berodima inanoghotatavem! ");
INSERT INTO aui_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kiiravine akovi da tam kunuwakapi bi kate noghota berona yibadem.” ");
INSERT INTO aui_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Na Saimon iwona bo, “Kiiraviguve, Bada biidi korupari, da awaki kowonegu na getagu biidi inatubughana.” ");
INSERT INTO aui_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bi raghanina Pita da Jon yadi wiitumaghana sivimaghamaghatara da kate Bada Yesu wonana, wiigeruwana damdi woudi biiyadi sidima ikovi murine, na siveramagha Jerusalemma. Bi raghanina siyaveraveramagha na Wara Miisena wawaya biiyadi siyadimadima, meyagii peyaridiye Sameriya kubura kamone. ");
INSERT INTO aui_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Gabudara tana Bada yana aneya, Piripo iwoneni bo, “Kugeghomiiri da wareregubugubura yana nawae kunagho Jerusalemma bi warere kedana kunakabi meko iyowogha inagho Gasa kwanatune.” (Kedana kata mmko raghanine na ibubu). ");
INSERT INTO aui_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Na Piripo itouya iyanono, na kedae Itiyopiya tomogha ikita. Tomoyina na wawaya ghamana noko kuburine bi yana bagibagi na, Itiyopiya yadi kiiwawo wasikena kana waghawagha Kandake yana moura iyakoyakoyayi. Tomoyina igae Jerusalemma da God ikabepepi ikovi ");
INSERT INTO aui_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","bi iyaveraveramagha na yana seriyot kamone iyamakamake bi peroveta Aisaiya yana buka kamonama iyakabikabiyawa. ");
INSERT INTO aui_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wasina bi Kanuma Kabikabikuwayina Piripo iwoneni bo, “Kunagho noko seriyot na ririnagha kunapepewa.” ");
INSERT INTO aui_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Na ivera inagho seriyot ririne bi iwaiyana da tomoyina peroveta Aisaiya yana buka iyakabikabiyavi, na Piripo ivitarakiiyana bo, “Da awaki kwakabikabiyavi na yana basuna kwakabikabi yapori bo gegha?” ");
INSERT INTO aui_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wasina bi seriyot badana iwona bo, “Gegha, tagu gerubana warana anakowa yaporina, bi memeda wawaya tana tagu biidi inidebeni na wasina.” Na tomoyina Piripo iwoneni da iyagae iyageru bi yawata siyimakerereghana. ");
INSERT INTO aui_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bi God wonana sisiyidi muduna mekodi noko tomoyina ghamana iyakabikabiyawa na mma naboni iwona, “Touna sirutayini sinagho da siyakasunuyi naboni ware sip, da siyirabobo bo ware nigenige raghanina ghunighunina saboribori, bi yiraborabobona naboni. Kedana mayimayiyina touna kawana geiyatatarina. ");
INSERT INTO aui_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wawaya siwona wiisinimayamayayi bi gewonawaghata debane siyitupawamiwamireni. Bi kayekikina kiiravidiye, na wawaya kate gesinisisiyedina, basuna toudi yana yawa sikabitaveni.” ");
INSERT INTO aui_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wasina bi tomoyina, Piripo ivitarakiiyaneni bo, “Kuwonegu, peroveta iiyabo kiiravine yisisiya? Tounamani kiiravine bo wawaya bogae kiiravine yisisiya?” ");
INSERT INTO aui_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Na Piripo, God wonanama wiiyeveveyana idaguni, noko girumina kamonama bi Yesu Warana Miisena ividebeni touna biidi. ");
INSERT INTO aui_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bi raghanina kedagha siyanono, na sipiika tenamve, na tomoyina iwona bo, “Kukita, rarima makatanina! Mma kuyababataitogu bo gegha?” ");
INSERT INTO aui_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Na tomoyina seriyot badana iwoneni da iyitouramiiriyeni, bi touna da Piripo siyowogha sinagho rarime, bi Piripo tomoyina ibabataitoni. ");
INSERT INTO aui_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wasina bi raghanina rarimama sigeetaveyana, na Bada Kanumina Kabikabikuwayina yaininagha Piripo ikabitaveni. Na Itiyopiya tomogha Piripo geiyakitamayenina, bi patana nuwamiimiiseye iyanaghonagho basuna God iviyawiini. ");
INSERT INTO aui_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wasina bi Piripo, Asotas kwanatune irumaghatara bi patana iyanaghonagho na idagu kwanatu nunudigha, Yesu Warana Miisena wawaya biiyadi iyadimadima patana da Sisiriya kwanatune iverakanibu. ");
INSERT INTO aui_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bi noko raghanine, na Sol patana ere nuwapughupughuna iyiisisiya bo, “Tagu iiyawogha sigeruwana da Yesu na Bada na anikasunughana!” Na inagho Jerusalemma prist kiikiiwawona biidi ");
INSERT INTO aui_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","bi ivibabiini da pepa iyagiruma siyanagho kabepepa bare babadidi biiyadi Damaskas kwanatuna kamone. Nokodi pepa kamodiye na prist kiikiiwawona maragata, Sol ivereni da wawaya nama iiyawogha noko kuburine, Yesu yana keda sakivikivini bi inabananidi na inapatumidi, tomotomogha da wasiwasike bi inanavedi Jerusalemma. ");
INSERT INTO aui_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol nokodi pepa iyouna bi itouya iyanono Damaskasma. Raghanina noko kuburina iyiitutukabikabi, na yaininagha gweyura ghamana abamama ikabinamari na yeghanina Sol iviveravivireni. ");
INSERT INTO aui_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na ibeku iyowogha dobodobove bi gamo iwaiyaneni iyiisisiya touna biidi iwona bo, “Sol, Sol, awaki biidi kwiikayotaketowanegu?” ");
INSERT INTO aui_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Na Sol iwona bo, “Tam iiyabo, Bada?” Bi gamona iwonabodeyana bo, “Tagu na Yesu, iiyabo kwiikayotaketowanenina; ");
INSERT INTO aui_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","bi geghomiiri da kunagho kunarughu kwanatu ghamana Damaskasma bi wawaya tana name inawonem da awaki kunabera.” ");
INSERT INTO aui_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tomotomogha iiyawogha Sol yawata siyapeepewa na sinaghara da simiiri waghata da gerubana siyisisiyana. Toudi gamo siwaiyaneni iyiisisiya, bi getana wawaya siyakitana. ");
INSERT INTO aui_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol dobodoboma imakegeghomiiri; bi raghanina matana sitamotatara, na gerubana da awaki tana iyakita; na turaturana imana sikabi da sivinaghokedari sinagho sirughu Damaskasma. ");
INSERT INTO aui_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Matana sipota kiiravine na gabudara aroba geiyakitawiivera, da getana iyakam bo iyaniuna. ");
INSERT INTO aui_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Bi nama Damaskas kamone na tomogha tana wiiwiigeruwanina kana waghawagha Ananaiyas. Na Bada mimeu kamone ikwatuveni bo, “Ananaiyas.” Na iwonabodeyana bo, “Tagu mma, Bada.” ");
INSERT INTO aui_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bi Bada iwona bo, “Kugeghomiiri kunagho Jiudas yana bareye, bi barena na keda sakwatuveni Keda Rotomanina ririne. Bi raghanina name kunaverakanibu na Tasus tomogha kana waghawagha Sol kiiravine kitarakiiyana bi katotawota na tagu biidi yarurupari. ");
INSERT INTO aui_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Touna imimeu bi ikita da tomogha kana waghawagha Ananaiyas ipiika da imana debane itoura da rubana inakitamagha.” ");
INSERT INTO aui_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Bi gegha Ananaiyas iwona bo, “Bada, wawaya korotodi noko tomoyina kiiravine siwonegu, bi kate metagha kam kivikivina iyikayotaketowanedi Jerusalem kamone; ");
INSERT INTO aui_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","bi kate prist babadidi maragata sivereni da mabo iyapiika da iiyawogha tam sakabekabepepim na iyapatumidi.” ");
INSERT INTO aui_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bi gegha, Bada, Ananaiyas iwoneni bo, “Kunagho! Tagu avineyi da kagu waghawagha inakabi inanagho dam wiibata da kiikiiwawo biiyadi bi kate Isrel damdi inawonedi. Basuna Sol na yagu wiivinevinegha tomoyina da inabagibagiyegu; ");
INSERT INTO aui_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tagu wosina na kabikwarakwara ghamadi tupadi inayuna na aniyeveveni basuna touna kiiraviguve na wawaya inawonedi.” ");
INSERT INTO aui_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Na Ananaiyas inagho da irughu bare kamove. Bi imana Sol gayamine itoura bi iwoneni bo, “Wareta Sol, raghanina mabo kuyapiipiika na kedae Bada Yesu kukita, na touna iviporagu tam biidi da tam kunakita magha bi Kanuma Kabikabikuwayina inibonuvim.” ");
INSERT INTO aui_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yaininagha sawara ware ighana yadadi Sol matanama siririgha na rubana ikitawiimasi magha. Na igeghomiiri da ibabataito, ");
INSERT INTO aui_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","bi ikam ikovi na yana maragata iveramagha. Bi Sol gabudara viya wiigeruwana damdi yawata Damaskas kamone simakae. ");
INSERT INTO aui_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bi yaininagha idagu kabepepa barediye iyadimadima Yesu kiiravine, iyawonawona bo, “Yesu na God Natuna.” ");
INSERT INTO aui_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bi wawaya iiyawogha yana dima siwaiyaneni na sivisokoveni, na sivisisiya kabivivirana bo, “Bo gegha mmko tomoyina iiyabo Jerusalem kamone Yesu kana kivikivina iyikayotaketowanedi? Bi kanoghosi da noko berana mayimayiyina kiiravine mabo ipiika, da kivikivina inapatumidi bi inakabidi inaveramagha prist babadidi biiyadi Jerusalem kamone da biwa sinaveredi.” ");
INSERT INTO aui_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bi gegha da Sol yana dima ibera da ivimaragata kirakii, bi wonawaghata ividebeni toudi biiyadi da Yesu na God yana Wiivinevinegha Kiiwawona, na Jius iiyawogha Damaskas kamone makamakedi gerubadi da yawata siyikawakereyana. ");
INSERT INTO aui_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gabudara viya sikovi murine, Jius babada nama sivigiugerogerora da Sol siyakasunuyi, ");
INSERT INTO aui_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","na gabudara da nubabasu nokodi Jius, kwanatu matamketa nunudigha siyaruruwiitete, da raghanina Sol siyakita na siyakasunuyi, bi Sol yadi wiigiugerogerora noghosina nada iwaiyaneni. ");
INSERT INTO aui_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na noko biidi nubabasuve, turaturana mududi iriga ghamana kamone suveni bi kwanatu garina taraboginagha sivionayi iyowogha kubuve. ");
INSERT INTO aui_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bi raghanina Jerusalemma iverakanibu, na ikayoveni da kivikivina iyirukapuvedi; bi gesiyigeruwana da wiisuwona touna Yesu kana kivikivina, na sinaghareni. ");
INSERT INTO aui_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bi gegha, Banabas yana wiiwiitama, na ikabi inagho apasol biiyadi, bi iwonedi da metagha Bada kedae irumaghatara Sol biidi da kate ivisisiya touna biidi. Bi kate metagha Sol Damaskas kamone geiyanaghara bi Bada kiiravine idima. ");
INSERT INTO aui_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wasina bi yawata simake patapata bi Jerusalem sipepewa wiikenavivireni, naghara gwabine gegha bi Yesu waghawaghane iyadimadima. ");
INSERT INTO aui_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Touna iyisisiya bi kate bada Jius damdi iiyawogha Grik gamoma siyisisiya na yawata siyiikawakereyana, na noko biidi keda sivinogha da siyakasunuyi. ");
INSERT INTO aui_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Raghanina wiigeruwana damdi mududi mmko siwaiyaneni, na Sol sirutayini siyowogha Sisiriyama da wagagha sivipora inagho Tasusma, yana kwanatu waghate. ");
INSERT INTO aui_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wasina bi wiigeruwana damdi Jiudiya, Galili da Sameriya kubura kamodiye nuwaruririye simakae; bi Kanuma Kabikabikuwayina ikasepepidi da yadi wiitumaghana ivimaragata. Na yadi koroto iragata kamokamogha bi Bada sikabikarawayena kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Raghanina Pita iyapeepewa kubura bi kubura, na inagho Yesu kana kivikivina biiyadi da iyarubodadi Lida meyagiine makamakedi. ");
INSERT INTO aui_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Name tomogha kana waghawagha Aineyas ibanani, bi tomoyina kayena sirabobo da gerubana yana kepanama iyamakegeghomiiri da bodu 8 sikovi. ");
INSERT INTO aui_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita iwona bo, “Aineyas, Yesu Keriso iviyawiim; Geghomiiri bi yam kepana kunoku.” Yaininagha igeghomiiri. ");
INSERT INTO aui_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wawaya korotodi Lida meyagiina kamone da Seron ruwiipikapikane, Aineyas iyawa sikita na Bada sivitumaghaneni. ");
INSERT INTO aui_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Name Jopa meyagiina kamone na kivikivina wasike tana kana waghawagha Tabita, (waghawaghana Grik gamodima na Dokas). Raghani nonowa bera miisedi iyaberabera wawaya biiyadi bi kate moyamoyakidi iyiiwiitedi. ");
INSERT INTO aui_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bi wasikena igubaga da irabobo, na tubuyina sikabununayi bi bare tupayarayine kiidamove kamone sitore. ");
INSERT INTO aui_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bi Lida meyagiina na Jopa meyagiina ririne, geiyarabarabana noko biidi, raghanina kivikivina siwaiyana da Pita name, na tomotomogha bata siviporadi da siyawoneni bo, “Rubana da kuyapiika yaininagha toumi biiyadi.” ");
INSERT INTO aui_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na Pita, igeghomiiri da tomotomoyidi yawata sinagho. Bi raghanina siverakanibu, na sirutayini sigae tupayaragha kiidamove. Kwabukwabura korotodi nama Pita sigwagwari, siyaduudu bi kwama da gara mududi mekodi Dokas yawayawiine siyamakamake raghanine kiiravidiye ibera na siyiyeveveni. ");
INSERT INTO aui_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bi Pita tupadi ivibabiidi da tupayaragha siyakanibutaveni, wasina bi ivituwapore oghogheyana da irupari; bi irupari ikovi na imiiriwamira wasikena raborabobona biidi bi iwona bo, “Tabita, geghomiiri.” Na wasikena matana sitamotatara, da Pita ikitani na ikenageghomiiri. ");
INSERT INTO aui_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita imana ikoghasi da wasikena imana ikabi bi itaina wiigeghomiiri. Wasina bi wiigeruwana damdi da kwabukwabura ikwatuvedi sirughu bi Dokas yawayawiina bi iviruveredi. ");
INSERT INTO aui_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Awaki itubugha na warana Jopa meyagiina inunuri, na wawaya korotodi Bada sivigeruveni. ");
INSERT INTO aui_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Wasina bi Pita, Jopa meyagiine gabudara peyaridi tomogha kana waghawagha Saimon yawata simakae, bi tomoyina yana bagibagi na ribiribi raborabobodi bekadima gara iyaberabera. ");
INSERT INTO aui_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisiriya meyagiina kamone na tomogha tana kana waghawagha Koneriyes, bi touna Roum aviya badana, bi kate iyo tomotomogha yadi 100, damna sakwatuveni da Itali wiirouwa damna kadi bada ghamana. ");
INSERT INTO aui_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Touna patupatutuna, bi yana rakaraka yawata God siyakabekabepepi. Yana nuwavereyana iragata kirakii wawaya moyamoyakidi biiyadi bi raghani nonowa God biidi iyarurupari. ");
INSERT INTO aui_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Raghani tana ravidi gabudare 3 o'klok naboni, na Koneriyes noghotama ikitarutaveyana da God yana aneya ipiika touna biidi bi iwona bo, “Koneriyes.” ");
INSERT INTO aui_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na Koneriyes inaghara na ikitabogaboga bi iwona bo, “Bada, yam wiina awaki?” Bi aneya iwona bo, “God, yam pari yinuwamiiseyeni bi kate yam vereyana wawaya moyamoyakidi biiyadi. Toudi ware suwara gabugabunidi ghabudi miisedi naboni. ");
INSERT INTO aui_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Noko biidi tomotomogha kuviporadi sinanagho Jopa meyagiine da tomogha kana waghawagha Saimon bi bada sakwatuveni Pita sinarutayini sinapiika. ");
INSERT INTO aui_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Touna ivikiiwaga da Saimon teya samakamake, tomoyina yana bagibagi na ribiribi raborabobodi bekadima gara yaberabera, bi yana bare na kikire yegii ririne.” ");
INSERT INTO aui_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Raghanina aneyina ivisisiya ikovi bi ikuyoveni murine, Koneriyes yana bare kana wiiwiitamariyana yadi bata bi kate iyo tomoyina wiiwiitamariyina, touna teya God yakabekabepepi na ikwatuvedi sipiika, ");
INSERT INTO aui_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","bi awaki tupana iwonedi ikovi murine, na iviporadi sinagho Jopama. ");
INSERT INTO aui_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Raghani ibori, gabudara yubasune naboni na mmkodi tomotomogha Jopa meyagiina siyitutukabikabi, bi noko raghanine Pita igae bare kubuve da iyarupari. ");
INSERT INTO aui_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Bi vitonana irabobo da yana wiina awaki iyakam; Wawaya patana kam siyakabikabikuya, na touna nuwanuwana iwapewapeni na noghotama ikitarutaveyana: ");
INSERT INTO aui_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Da taraboga abame ikita da sawara tana iyayoyo kanakita naboni bebera ghamana bi pusirina yadi ruwamaruve na ware wawaya siyakabiwiiteka bi iyayoyo kubure. ");
INSERT INTO aui_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bi beberina kamone na ribiribi bogaebogae kayedi ruwaruwamiighate, bi kate ghamoghamo sasasadi da kiidamo manudi geananamanidi. ");
INSERT INTO aui_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wasina bi gamo iwoneni bo, “Pita; geghomiiri, kunugha bi kunakam.” ");
INSERT INTO aui_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bi gegha Pita iwona bo, “Gegha, Bada; tagu gerubana noko anabera, Jius yama gwara nunune na gemeyani sawara gemiisedi bo dadabudi ayakamtowogha.” ");
INSERT INTO aui_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Bi gamo, Pita iwonena mayeni bo, “Awaki sawaridi God yawonedi da toudi miisedi, na gekunawonedi da dadabudi.” ");
INSERT INTO aui_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mmko noghotama kitarutaveyana itubugha da raghani aroba, wasina bi beberina yaininagha iveramagha igae abame. ");
INSERT INTO aui_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Raghanina Pita patana noghotama kitarutaveyanina basuna iyanuwanuwagiureni, na tomotomogha aroba iiyawogha Koneriyes iviporadi, na Saimon yana bare sibanani, bi matamketa naghone sivituramiiriyedi, ");
INSERT INTO aui_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","bi sivitarakiiyana siwona bo, “Mma kiiwaga tana kana waghawagha Saimon Pita yamakamake bo gegha?” ");
INSERT INTO aui_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bi Pita na patana noghotama kitarutaveyanina iyanuwanuwagiurena kirakiiyeni, bi Kanuma Kabikabikuwayina iwoneni bo, “Kuwaiyana, tomotomogha aroba sininoyem. ");
INSERT INTO aui_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Na geghomiiri, kuyowogha da yawata konanagho kiiravine tagu aviporadi. Bi gekuninoghota bata basuna toudi gegha Jius.” ");
INSERT INTO aui_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bi Pita iyowogha bi tomotomoyidi iwonedi bo, “Tomogha iiyabo kwiininoyeni na wasina tagu mmakatanina; awaki kiiravine kopiika?” ");
INSERT INTO aui_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tomotomoyidi siwonabodeni bo, “Kama bada Koneriyes, touna Roum yadi iyo badana gwabinama kapiika. Touna tomogha kabikabikarawayina, bi God yakabekabepepi, bi Jius damdi tupadi sakabikabikarawayeni. Bi God yana aneya tana ivikatayi na iviyonem kuyapiika yana bareye, da yam sisiya iyawaiyana.” ");
INSERT INTO aui_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita iviwaghasina bi tomotomoyidi iviyonedi sirughu da noko pomne nama siyakena. Raghani ibori na ikabununagha bi yawata siyanono, na Jopa meyagiinama wiigeruwana damdi mududi bada yawata sinagho. ");
INSERT INTO aui_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wowonama gabudarine na Sisiriya meyagiine siverakanibu. Bi Koneriyes, yana rakaraka da turaturana iviyonedi sipiika da yana bareye Pita siyakoyakoyayi. ");
INSERT INTO aui_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Raghanina Pita bareye iyiitavenarughuveni, na Koneriyes ipepeta iyowogha Pita kayekunukunune bi ikabepepi. ");
INSERT INTO aui_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bi gegha da Pita, Koneriyes itayina wiigeghomiiri bi iwona bo, “Geghomiiri; tagu wawaya wota tam naboni.” ");
INSERT INTO aui_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bi toudi siyisisiya patapata, da sirughu bare kamove na Pita ikita da wawaya korotodi sivitaghomidi. ");
INSERT INTO aui_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Na iwonedi bo, “Tami tupami kwakovi da toumii Jius yama gwara geiyiwaghasinemii da tami gegha Jiu dammi teya tanirukapuwana bo kanikiiwagemi; bi gegha da God iviyevevegu da geananoghosi da wawaya wapawapa tupadi na dadabudi bo gemiisedina. ");
INSERT INTO aui_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na raghanina kuvibabiigu da ayapiika, na apiika bi geayinipuwana. Na kowonegu, awaki biidi kiiraviguve kovibaba na apiika.” ");
INSERT INTO aui_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koneriyes iwonabodeni bo, “Rorowagha ravidi gabudare, gabudara mma naboni, na yagu bareye ayarurupari; raghani tana, tomogha kana gara kabinamanamarina naghoguve ivituramiiriyeni ");
INSERT INTO aui_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","bi iwona bo, ‘Koneriyes, God yam pari iwaiyana da yam vereyana wawaya moyamoyakidi biiyadi na ivinuwamiiseyeni. ");
INSERT INTO aui_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na tomotomogha kuviporadi sinanagho Jopa meyagiine da Saimon bi bada sakwatuveni Pita sinarutayini. Touna ivikiiwaga Saimon teya samakamake, tomoyina yana bagibagi na ribiribi raborabobodi bekadima gara yaberabera bi yana bare na kikire yegii ririne.’ ");
INSERT INTO aui_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Na yaininagha, yam sisiya awonataveni bi imiise kirakii da kupiika. Noko biidi toumii mma God matane kavitaghomimii, da Bada metagha sisiya iverem na tupadi kunawonemii kanawaiyana.” ");
INSERT INTO aui_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na Pita sisiya idagu iyawonawona bo, “Kata akowa yapori da wiisuwona God, wawaya yakayowiiyayedi da tupadi mayimayiyidi, ");
INSERT INTO aui_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","bi bagune dam bogaebogae bi gegha da iiyawogha God sakabikabikarawayeni bi awaki beradi rotomanidi saberabera na yiwaghasinedi. ");
INSERT INTO aui_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tami Wara Miisena God ivipora Isrel damdi biiyadi na kwakovi, da wawaya na God gwabine nuwaruriri sinabanani raghanina Yesu Keriso sinitumaghanenina, bi touna na wawaya tupadi kadi bada, ");
INSERT INTO aui_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","kwakovi da babataito warana Jon idimeni ikovi bi murine, na Yesu awaki beradi ghamadi Jiudiya kubura tupane ibera bi dagudaguna na Galiline: ");
INSERT INTO aui_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","tami Nasaret tomogha Yesu kwakovi da kate metagha God, Kanuma Kabikabikuwayina da maragata ivereni; na inagho meyagii peyaridiye bera miisena iyaberabera bi iiyawogha Seitan yana maragata kamone na iyiyawiidi, basuna God na gwabine. ");
INSERT INTO aui_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Toumii bera tupadi Jiudiya kubure da Jerusalem kwanatune iberadi bi matamiima kakita na kiimaghamaghatara, wasina bi korosiye situparatu da sivirabobo. ");
INSERT INTO aui_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bi gegha da gabudara wiiarobine, na God raboboma ikabiwiigeghomiiri bi ibera da toumii biiyadi irumaghatara na kakita, ");
INSERT INTO aui_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","gegha wawaya tupadi siyakitana wasina wiimaghamaghatara dammii kawagha, iiyawogha na God rorowainagha ivinegha katamana, nokona rabobo murine igeghomiirina, touna da toumii yawata kakam da kaniuna. ");
INSERT INTO aui_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yesu sisiya bagibaginama iwonemii da Wara Miisena wawaya biiyadi kanadimeni, bi kanimaghamaghatara da God, Yesu ivineyi da raghani damone na touna wawaya tupadi yawayawiidi da raborabobodi kadi wiitupawamiwamira. ");
INSERT INTO aui_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","God yana peroperoveta tupadi kiiravine bada sivisisiya. Bi sigiruma siwona da wawaya, Yesu situmaghaneni na waghawaghane tamumu noghotataveyanina sinakabi.” ");
INSERT INTO aui_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Raghanina Pita patana iyiisisiya, bi wawaya tupadi iiyawogha wara siyawaiwaiyaneni na Kanuma Kabikabikuwayina iyowogha da ivibonuvidi. ");
INSERT INTO aui_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bi Jius wiigeruwana damdi iiyawogha Jopa meyagiinama Pita yawata sipiika na sivisoko kirakii da God yana puyo, Kanuma Kabikabikuwayina kubuna damdi iveredi. ");
INSERT INTO aui_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mmko sakovi basuna siwaiyanedi da gamo bogaebogaema siyiisisiya bi God siyakabekabepepi. Wasina bi Pita iwona bo, ");
INSERT INTO aui_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Toudi Kanuma Kabikabikuwayina sikabi ware touda naboni. Noko biidi getana iiyabo inigesiyemii da rarimama kana babataitodina.” ");
INSERT INTO aui_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Na sisiya bagibaginama wiigeruwana damdi iwonedi da Koneriyes, yana rakaraka da kate turaturana yawata, Yesu waghawaghane siyababataitodi. Bi muriye na Koneriyes turaturana teya Pita sivibabiini da gabudara viya yawata siyamake. ");
INSERT INTO aui_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bi apasol da wiigeruwana damdi mududi Jiudiya kubura kamone samakamakena sisiya siwaiyana da kubuna damdi, God wonana siwaiyaneni da bada sivigeruwana. ");
INSERT INTO aui_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na raghanina Pita igae Jerusalemma na Jius wiigeruwana damdi mududi sikini ");
INSERT INTO aui_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","siwona bo, “Tam kunagho kubuna damdi yadi bareye da kate yawata kokam!” ");
INSERT INTO aui_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Wasina bi Pita bera awaki itubugha na tupana ivisisiya rutughutughureni toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Iwona bo, “Raghanine Jopa meyagiine ayamakamake na gabudara tana ayarurupari da nuwanuwagu iwapewapeni na amimeu, da sawara tana akita abamama iyayoyo kanakita naboni bebera ghamana bi pusirina yadi ruwamaruwa na ware wawaya sikabiwiiteka bi iyowogha tagu biidi meme ayamakamakena. ");
INSERT INTO aui_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bi raghanina arugenara kamone na ribiribi kayedi ruwamaruwa ananamanidi da geananamanidi, ghamoghamo sasasadi da kiidamo manudi geananamanidi akitadi. ");
INSERT INTO aui_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Wasina bi gamo awaiyaneni iyawonewonegu bo, ‘Pita, geghomiiri, kunugha bi kunakam.’ ");
INSERT INTO aui_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Bi awonabodeni bo, ‘Bada, tagu gerubana noko anabera! Bi gemeyani sawara gemiisedi bo dadabudi ayakamtowoghana.’ ");
INSERT INTO aui_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na gamo abamama iwonamagha bo, ‘Awaki sawaridi God yawonedi da miisedi na gekunawonedi da dadabudi.’ ");
INSERT INTO aui_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mmko mimeuna itubugha da raghani aroba bi muriye na sawarina iveramagha igae abame. ");
INSERT INTO aui_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Noko raghanina mayimayiyine tomotomogha aroba Sisariyama siviporadi tagu biidi, da bare meme ayamakamakena name siverakanibu. ");
INSERT INTO aui_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na Kanuma Kabikabikuwayina iwonegu da geayinoghota bata bi tomotomoyidi yawata kayanagho. Bi mmkodi wiigeruwana damdi yadi 6 sivimataturanegu da yawata kanagho Sisariyama da Koneriyes yana bareye karughu. ");
INSERT INTO aui_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wasina bi Koneriyes iwonemii da yana bareye aneya irumaghatara na ikita bi iwoneni bo, ‘Tomotomogha kuviporadi sinanagho Jopa meyagiine da Saimon bi bada sakwatuveni Pita sinarutayini. ");
INSERT INTO aui_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Touna iniwaraveremi da metegha God, tam da yam rakaraka yawata iniyawiimina.’ ");
INSERT INTO aui_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Wasina bi raghanina adagu wiisisiya biidi, na Kanuma Kabikabikuwayina iyowogha da ivibonuvidi ware ghuyoghuyone touda biiyadi iyowoghana naboni. ");
INSERT INTO aui_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na anuwagiura da Bada Yesu yana sisiya anoghosi iwona bo, ‘Jon Babataito rarimama wawaya ibabataitodi, bi God na Kanuma Kabikabikuwayinama inababataitomi.’ ");
INSERT INTO aui_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Noko biidi iyeghani da God, kubuna damdi puyona mayimayiyina iveredi, touda iveredana naboni raghanina Bada Yesu Kerisove tanitumaghanana. Na noko kiiravine, tagu iiyabo da God gebodenina ananoghosi?” ");
INSERT INTO aui_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Raghanina Jius wiigeruwana damdi mmko siwaiyaneni, na Pita siyakikini na sikabitore bi God sikabepepi siyawonawona bo, “Naboni da God wiiwaghasina kubuna damdi iveredi da yadi berona sinamiiri kubutedi bi yawa makewaghawaghasina sinakabi.” ");
INSERT INTO aui_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wawaya Sitivin sikasunuyi ikovi bi raghani viya murine na bada iiyawogha Yesu siyitumaghaneni na siyikayotaketowanedi da sivivera bogaebogae sinagho kubura mududiye. Viya sinagho Ponisiya kubure, viya Saipras nuwane bi viya sinagho Antiyok kwanatune bi sidagu Jius damdi biiyadi kawagha Yesu Warana siyadimedimeni. ");
INSERT INTO aui_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bi wiigeruwana damdi mududi, tomotomogha Saipras nuwana da Sairin kwanatuna damdi sinagho Antiyokma bi sidagu kubuna damdi biiyadi siyadimadima, bi Bada Yesu Warana Miisena bada kiiravine siyawonewonedi. ");
INSERT INTO aui_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bi Bada yana maragata gwabidiye kiiravine, na wawaya korotodi Warana sivigeruveni da Bada biidi simiiri karona. ");
INSERT INTO aui_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Wasina bi wiigeruwana damdi Jerusalem kamone siwaiyana da awaki iyatubutubugha na Banabas sidaru inagho Antiyokma. ");
INSERT INTO aui_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Banabas na tomogha miisena, na Kanuma Kabikabikuwayina ivibonuvi bi yana wiitumaghana God biidi ivimaragata kirakii. Na raghanina nama iverakanibu bi ikita da metagha God miisena iyaberabera wawaya biiyadi, na ivinuwamiise kirakii bi tupadi ikasepepidi da nuwanuwadi tupanama wiisuwonaye Bada Yesu sinigeruveni. Bi wawaya korotodi Banabas yana sisisya siwaiyaneni na Bada sivitumaghaneni. ");
INSERT INTO aui_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Wasina bi Banabas, Antiyok ikuyoveni bi inagho Tasusma da Sol iyinoyeni; ");
INSERT INTO aui_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","bi raghanina ibanani, na irutayini siveramagha Antiyokma. Bi bodu tanagha Banabas da Sol wiigeruwana damdi yawata siyitaghomidi da wawaya korotodi siyiyevevedi. Bi noko raghanine Antiyokne, wawaya sidagu da wiigeruwana damdi siviwaghawaghaedi da Keresiyana. ");
INSERT INTO aui_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nokodi raghanidiye God yana peroperoveta mududi Jerusalemma siyowogha sinagho Antiyokma. ");
INSERT INTO aui_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bi tana kana waghawagha Agabas, igeghomiiri bi Kanuma Kabikabikuwayina yana maragate iwonakasiyaragha da kapoe ghamakirakiina inapiika kubura bogaebogae bi Roum yadi wiibadana rogune inakamowanidi; mmko kapoena Roum damdi yadi kiiwawo Klodiyas yana wiibada raghanine na itubugha. ");
INSERT INTO aui_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Na wiigeruwana damdi Antiyok kamone sinuwagiura da tatadigegha awaki gwabidiye, gisina bo ghamana na rubae siyavereyana kirakii bi siyipora iyanagho wiigeruwana turaturadi biiyadi Jiudiya kamone da siyiwiitedi; ");
INSERT INTO aui_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","bi noko sibera ikovi, na yadi puyo Banabas da Sol imadiye sitore da siyakawari siyanagho bi wiigeruwana damdi kadi babada Jerusalem kamone siyaveredi. ");
INSERT INTO aui_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wasina bi kiiwawo Herod Agripa noko raghanine idagu wiigeruwana damdi mududi iyikayotaketowanedi. ");
INSERT INTO aui_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Bi touna gamone na Jon toghanaru Jemes serima kanighona sikasiyarayi da sivirabobo; ");
INSERT INTO aui_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","bi raghanina Herod ikita bi Jius babada Jemes yana rabobo sivinuwamiiseyeni, na iwona da Pita bada siyakabi da biwa gawarine siyatore. Mmko berana Koughanu porayina raghanine sibera. ");
INSERT INTO aui_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bi Pita sipatumi murine na biwa gawarine sitorerughuveni, bi Herod gamone na wiiyogha damdi riba ruwamaruwa siberadi, nokodi riba ruwamaruwa kamodiye na iyo tomotomogha ruwaruwamiighate da Pita siyakoyayi, Herod ikayoveni da Koughanu porayina murine koroto matadiye bi debae Pita iyitupawamiwamireni. ");
INSERT INTO aui_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bi Pita biwa gawarina kamone na siyabodaboda, bi gegha da wiigeruwana damdi God biidi sirupari wiimaragata da Pita iyiwiiteni. ");
INSERT INTO aui_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wasina bi Poragha ikovi murine raghani iyabori bi Herod, Pita iyitupawamiwamireni bi noko nubabasune, na Pita kighukighu damdi bata basudiye iyakenakena, bi sein yadi batama saghira tawatawani bi kighukighu mududi na biwa gawarina matamketana siyakoyakoyayi; ");
INSERT INTO aui_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bi yaininagha, God yana aneya tana irumaghatara na yeghana irukarata biwa barena kamone; bi aneyina, Pita katiiyana ikasitowotowoyi na ikasiwiimataki bi iwoneni bo, “Geghomiiri yaininagha.” Wasina bi Pita imane nokodi sein sitamotaveyana siririgha. ");
INSERT INTO aui_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na aneyina iwona bo, “Kukounagha bi kam kayeturababara kiyagha.” Na Pita ibera, bi aneyina bada iwona bo, “Kam tarasowo sinimve kiruvivireni bi kivinigu.” ");
INSERT INTO aui_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na Pita ikounagha ikovi bi aneya ikivini da biwa gawarina sikanibutaveni; bi geiyakovi da aneya awaki iyaberabera na wiisuwona, touna inoghosi da iyamimeu. ");
INSERT INTO aui_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wasina bi wiikighukighu damdi ribana dagudaguna siveratupiiredi da bada riba wiibatana damdi siveratupiiredi, bi sipiika matamketa aiyanma sibera bi kedana na ikanibu inagho kwanatuve. Bi kiiravidiye na matamaketana nuwane itamotatara da sikanibutaveyana. Bi kedagha sipepewa siyowogha gegurina, bi aneyina yaininagha Pita ikuyoveni. ");
INSERT INTO aui_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Raghanina Pita noghota ikabi da awaki itubugha touna biidi na iwona bo, “Kata akovi da wiisuwona God yana aneya ivipora da Herod yana maragatama iyiyawiigu da kate dam Jius awaki sikayoveni da iyatubughana.” ");
INSERT INTO aui_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wasina Pita akowa ikabi da God iviyawiini, na itouya inagho Jon Mak sinananaki Meri yana bareye, meme wawaya korotodi sivitaghomidi siyarurupari. ");
INSERT INTO aui_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bi raghanina maghatara matamketane irupisipisika na wiitamariyana wasike kana waghawagha Roda iwaiyaneni na ipiika iyakabi taveni. ");
INSERT INTO aui_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Raghanine Pita gamona iwaiyana rukunukunuveni na ivinuwamiise kirakii da matamketa geiyakabitaveni bi ivera iveramagha irughu bareye bi irukwatu bo, “Pita matamkete yamiimiiri!” ");
INSERT INTO aui_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bi gesiyitumaghaneni na siwoneni bo, “Gayamim ineghanegha boni!” Bi gegha da iwonatupetupeyana da Pita maghatare, na siwona bo, “Memeda noko Pita yana aneya.” ");
INSERT INTO aui_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bi gegha da Pita patana iyarurupisipisika, bi raghanina matamketa siyakabitaveni na Pita nama sikita, na sikabinokena kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bi Pita imanama ivimatakira da siyiraborabobo, bi iwonedi da metagha Bada biwa gawarinama ikabikanibuveni, bi kate iwona bo, “Jemes da wiigeruwana damdi tupadi awaki itubugha na kowonedi.” Wasina bi Pita, Jerusalemne ikuyovedi bi inagho kubura tane. ");
INSERT INTO aui_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Raghani ibori na biwa gawarine kabokabo ghamana itubugha iyo tomotomogha kamodiye basuna gesiyakovi da Pita mebo inagho. ");
INSERT INTO aui_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Raghanina Herod iwaiyana da Pita mebo inagho na yana iyo tomotomogha iwonedi da siyinoyeni bi getana siyabanani. Na wiikighukighu damdi iiyawogha Pita siyakoyakoyayina ivitupawamiwamiredi, bi gamone na iwona da sivikasunughana. Wasina mmko berana murine na Herod, Jiudiya kubura ikuyoveni bi inagho Sisariya kwanatune imakae raghani gisina. ");
INSERT INTO aui_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wasina bi Herod na Taya da Saidon damdi teya siyikawapata, na sivituwiikapukapudi bi sinagho da Herod siyakita. Ghuyoghuyone na Brastas, touna kiiwawo yana bagibagi wawayina ghamana tana na yana wiiwiita sikayoveni, bi yana wiiwiite na Herod sivibabiini nuwaruriri kiiravine, basuna kadi kam kedana na touna kiiwawo yana kuburama iyapiipiika. ");
INSERT INTO aui_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Gabudara sivineyina raghanine Herod, kana kwama miisedi ivikote, bi yana wiikiiwawo gawarine imakeyowogha bi wawaya biiyadi sisiya ibera. ");
INSERT INTO aui_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bi raghanina wawaya yana sisiya siwaiyaneni, na sirukwatu bo, “Mmkona god gamona, bi gegha wawaya!” ");
INSERT INTO aui_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Yaininagha God yana aneya tana ivikubuwonayaragha na igubaga kirakii, basuna touna gegha God iyakabikarawayeni kiiravine na miikopu sinina situpabubu na irabobo. ");
INSERT INTO aui_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bagunakine mmkodi beradi, bi gegha da God wonana patana ituwawiiwoneni, na wawaya korotodi sivigeruwana. ");
INSERT INTO aui_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Wasina raghanina Banabas da Sol yadi bagibagi Jerusalemne sivikovini, na Jon Mak sirutayini da yawata siveramagha Antiyok kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nama Antiyok kwanatune keresiyana mududi na peroperoveta da abawiiyeveveyana: Toudi na Banabas, Simiyon (kana waghawagha tana tomogha dumadumana), Lusiyas (touna Sairin tomogha), Manayen (touna Herod Antipas yawata siragata patapata), bi kate Sol. ");
INSERT INTO aui_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Gabudara tana raghanina mmkodi babada tupadi God siyakabekabepepi da siyiiya, na Kanuma Kabikabikuwayina iwonedi bo, “Banabas da Sol kotore iredi tagu kiiraviguve basuna avineyidi da yagu bagibagi sinabera.” ");
INSERT INTO aui_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Na wiiya da rupari ikovi murine, na imadi Sol da Banabas gayamidiye sitoura bi God sivibabiini da maragata iyaveredi bi yana bagibagi siyabera, wasina bi siviporadi sinagho. ");
INSERT INTO aui_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wasina bi Kanuma Kabikabikuwayina, Banabas da Sol iviporadi Antiyok sikanibutaveni sinagho Selusiya kwanatune bi nama wagae sigeru da sinagho Saipras nuwane. ");
INSERT INTO aui_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Raghanina Salamis kwanatune siverakanibu, na Jius yadi kabepepa barediye God wonana sidimeni. Noko raghanine na Jon Mak yawata da toudi kadi wiiwiita. ");
INSERT INTO aui_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Toudi nuwana tupana siverabouni patana da sipiika Papos kwanatune, bi name Jius tomogha kana waghawagha Erimas (kana waghawagha tana na Ba-Yesu) sibanani, touna imimapuna bi peroveta wiiwiiyabina. ");
INSERT INTO aui_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bi Sodiyas Polas, na Roum tomogha bi ivituraneni. Sodiyas Polas na tomogha nuwanuwagiurina bi noko nuwana iyiibadeni. Bi yana wiina da God wonana iyawaiyaneni kiiravine na Banabas da Sol yadi sisiya idaru da siyapiika siyakita. ");
INSERT INTO aui_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bi gegha da Elimas, imimapuna (Grik gamodima kana waghawagha yana basuna na namakatanina), sisiyama iviaviyedi bi ivimatipo da nuwa wiibadana iyatayina wamiri da gegha Yesu iyigeruvenina. ");
INSERT INTO aui_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bi gegha da Sol (kana waghawagha tana Pol), Kanuma Kabikabikuwayina maragata ivereni, na Elimas ikita bogaboga, ");
INSERT INTO aui_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","bi iwoneni bo, “Tamna Seitan yana wiitamariyana, tam nonowa kwiiyaba bi bera beroberodi kwaberabera, tam bera miisedi kwiisinighiighiiyana, bi Bada yana Keda miisena kiiravine wiiyaba gemeyan kuyakabikabitore! ");
INSERT INTO aui_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na kuwaiyana, Bada yana maragate na aro kunakabi da raghani tupona matam sinadidibara da gerubana gabudara yeghanina kunakitana.” Yaininagha sowa da wiididibara Erimas matana sikabimumu da gerubana awaki tana iyakita, na iyakasikasigwamgwam da wawaya tana iyabanani bi imana iyakabi da iyinaghoveni. ");
INSERT INTO aui_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Raghanina Sodiyas Polas ikita da awaki itubugha Erimas biidi, na ivigeruwana, basuna Bada yana Keda kana wiiyeveveyana kiiravine na ivisoko kirakii. ");
INSERT INTO aui_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Wasina bi Pol turaturana yawata Papos kwanatuna sikuyoveni bi wagae sigeru da sinagho Pega kwanatune, Pampiriya kubura kamone. Bi noko kuburine Jon Mak ikuyovedi bi iveramagha Jerusalemma. ");
INSERT INTO aui_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bi Pol da Banabas, Pega sikuyoveni da sinagho Antiyokma Pisidiya kubura kamone. Bi wiiyawiitaveyana gabudarine na sirughu kabepepa barene da simakewiipikapika. ");
INSERT INTO aui_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bi raghanina Mosis yana gwara da peroperoveta yadi giruma sikabiyawa ikovi murine, na kabepepa barena babadidi sisiya sidaru Pol da Banabas biiyadi siwona bo, “Warewaresimii, memeda wonawiikayokayowana sisiyidi gwabimiye wawaya kiiravidiye, na kopiika da konisisiya.” ");
INSERT INTO aui_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Na Pol igeghomiiri imanama ivimatakira da wawaya siyiraborabobo siyawaiyaneni bi iwona bo, “Isrel dammi da tami gegha Jiu dammi wiiwiitumaghanimi iiyawogha God kokabekabepepina, kowaiyanegu. ");
INSERT INTO aui_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Touda Isrel damda, yada God naghove waghata kayekikida ivineyidi bi iberadi da ividam kiitowana Ijipt kubure siyamakamake raghanine, ware kubura wiibata damdi naboni. Bi God yana maragata ghamanama Ijipt kuburama ikabikanibuvedi. ");
INSERT INTO aui_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Da bodu 40 mayabe sipepewa bi noko kamone na sivikawakeekeeyeni bi gegha da ikoyagha yaporidi. ");
INSERT INTO aui_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wasina bi raghanine God, dam yadi 7 Kenen kubure igeiwayidi, na yadi kubura yana wawaya Isrel damdi iveredi da sivirapeneni. ");
INSERT INTO aui_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Raghanina kayekikida ghuyoghuyone sipiika Ijipt kubure, bi bodu 450 kamodiye mmkodi bera situbugha, bi sikovi murine na Kenen kubure make sidaguni. Bi noko murine God wiitupawamiwamira damdi iveredi bi sivibada patana da peroveta Samwel yana raghaniye. ");
INSERT INTO aui_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Wasina bi Isrel damdi kiiwawo kiiravine sivibaba; na God dam Benjiman kamonama Kis natuna Sol ivineyi da bodu 40 kiiravidiye iyikiiwawo. ");
INSERT INTO aui_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bi God, Sol wiikiiwawoma ikabitaveni murine, na Deivid ikabiwiimiiri da iyibada, bi Deivid kiiravine mma naboni iwonaruyaragha, ‘Abanani da Jese natuna Deivid na nuwanuwagu ikabikirakiiyeni da awaki tupadi akayokayoveni da iyabera na inabera.’ ");
INSERT INTO aui_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Bi mmko tomoyina nosinosina gwabidima na God, Isrel kana wiiwiiyawa Yesu ipiikeni, ivisuwona na naboni. ");
INSERT INTO aui_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Muriye da Yesu yana bagibagi iyadaguni, na Jon Babataito, Isrel damdi tupadi biiyadi idima iwona da yadi tamumuma siyatubuwamira da God iyanoghotatavedi da siyababataito. ");
INSERT INTO aui_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Raghanina Jon yana bagibagi wiikovinina biidi na ivitarakiiyana bo, ‘Konoghonoghosi tagu God yana wiivinevinegha? Gegha, getagu. Bi kowaiyana, wawaya muriguve yapiipiika, na yana maragata iragata kirakii bi tagu gekiimatanigu da anawasikuwaya bi kana kayeturababara anakabitavetaveyana.’ ");
INSERT INTO aui_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Warewaresigu, Abraham nosinosina, da tami gegha Jiu dammi wiiwiitumaghanimi iiyawogha God kokabekabepepina, kowaiyana! God metagha wawaya iniyawiidi kiiravine na wara idaru touda biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bi wawaya Jerusalem kamone yadi babada yawata gesiyakovi da Yesu na God yana Wiivinevinegha Kiiwawona. Wiiyawiitaveyana gabudaridi nunudigha na Keriso kiiravine peroperoveta sigirumana wawaya kabepepa barene sakabikabiyawa na sawaiwaiyana, bi gegha da geakovina siyakabi na sivitupawamiwamireni da iyarabobo bi mmko siberana peroperoveta yadi sisiya sibera da iyarumaghatara. ");
INSERT INTO aui_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nokodi wawaya kadi babada yawata getana Yesu yana berona tana siyabanani da iyarabobo, bi gegha da Pailat sivibabiini da siyakasunuyi. ");
INSERT INTO aui_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Raghanina Jius damdi peroperoveta naghove waghata awaki kiiravine sivisisiya na tupana sibera ikovi murine, na tubuyina korosima sitoreyowoyeni bi karawaga epamana bonayine sitore. ");
INSERT INTO aui_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bi gegha da God, Yesu raboboma ikabiwiigeghomiiri; ");
INSERT INTO aui_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","bi gabudara peyaridi kamodiye na iiyawogha yawata Galilima sipepewa sigae Jerusalemma na iyarurumaghatara toudi biiyadi na siyakitakita. Na kata toudi kana wiimaghamaghatara wawayidi Isrel damdi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Bi katana toumii mmko warana miisena kawonewonemi. God naghove waghata awaki ivisuwona da iyabera kayekikida biiyadi ");
INSERT INTO aui_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","God kayikikida ivisuwonedi iwona bo, “Tomogha iiyabo iniyawiimi na inapiika.” Kata touda, toudi nosinosidi takita da noko wiisuwonina irumaghatara. God, tomoyina kiiravine ivisisiyenina, touna Yesu. God, Yesu raboboma ikabiwiigeghomiiri. Touna na God natuna. Noko berana na ware Deivid, Psam wiibatana kamone igirumina naboni meme God, Keriso iwoneni bo, ‘Tamna tagu Natugu, bi kata Tamamnaki na Tagu.’ ");
INSERT INTO aui_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God, Yesu raboboma ikabiwiigeghomiiri da gemeyani inarabobo maghana. Bi mmko berana na ware God giruma kabikabikuwayidiye ivisisiya nosinosidanakim biiyadi iwona bo, ‘Tagu iisuwona da animiiseyemi ware metagha avisuwona da Deivid ayimiiseyeni na naboni.’ ");
INSERT INTO aui_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Bi bada giruma mududiye Deivid iwona bo, ‘Yam wiitamariyana kabikabikuwayina tubuyina gekunakabitore da karawage inatamoririghana.’ ");
INSERT INTO aui_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mmkona gegha Deivid kana sisiya, kiiravine raghanina Deivid yawayawiine iyamakamake na God awaki ikayoveni da iyabera na iberadi. Wasina bi irabobo na nosinanakim yawata sidogudi bi gegha da tubuyina itamoririgha. ");
INSERT INTO aui_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Gegha, touna Yesu iyiisisiyeni, God raboboma ikabiwiigeghomiiri da tubuyina geiyatamoririghana. ");
INSERT INTO aui_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Na warewaresigu, kowaiyana wiimasi. Toumii kakayokayoveni da mmko warana kawonewonemi na konakowa yapori. God na rubana yami tamumu inanoghotatavedi basuna Yesu awaki iberana kiiravine. Bi memeda Yesu konigeruveni na God matane na tami wasina, bi Mosis yana gwara wiimatipo da kivinina, na gerubana inaberami da God matane na tami wasina. ");
INSERT INTO aui_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Noko kiiravine kokita yaporimi da peroperoveta awaki sigirumana gegha tami biiyadi sinatubughana. Kiiravine siwona bo, ");
INSERT INTO aui_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kowaiyana, tami iiyawogha kwiisinighiighiiyeguna! Konakabinoka bi konarabobo. Basuna yami gabudare na aro ghamanakina anapiikeni tami gewiigeruwana dammi biiyadi. Bagune memeda arona kiiravine wawaya tana inawonemi bi gegha da tami kate gekonigeruwanana.’” ");
INSERT INTO aui_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wasina bi raghanina Pol da Banabas kabepepa barena siyakuyokuyoveni, na wawaya siyiibabiidi da muriye wiiyawiitaveyana gabudarina tane na bada sinaveramagha da God warana sinisisiyena mayeni toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bi wawaya kabepepa barena sikuyoveni murine, na Jius da kubuna damdi (toudi Jius yadi wiitumaghana siyakivikivini) korotodi Pol da Banabas sikivinidi. Toudi yawata sivisisiya patapata bi siwonawiiyoyowanedi da God yana nuwamonika ghamana warana sinigeruvena wiikarukaruveni. ");
INSERT INTO aui_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wasina bi wiiyawiitaveyana gabudarina tane, bi tanawona da memeda kwanatu damdi tupana kabepepa barene sivitaghomidi da Bada warana siyawaiyaneni. ");
INSERT INTO aui_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bi raghanina Jius babada noko korotona sikita, na Pol da Banabas biiyadi sinuwakapi, na sidagu Pol siyakikini bi yana sisiya tupadi siyigeruwiiredi. ");
INSERT INTO aui_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bi Pol da Banabas gegha siyanagharedi bi siwona bo, “God iwonemii da dagudagune na warana tami biiyadi kanadimeni, bi gegha da tami kwiisinighiighiiyeni. Mmko yiyeveveyana da gekoyanoghonoghosi da noko wasina da tami yawa makewaghawaghasina konakabina, na kana kuyovemi bi God warana kubuna damdi biiyadi kanadimeni. ");
INSERT INTO aui_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bi Bada God sisiya bagibaginama iwonemii bo, ‘Tagu avineyimi da naboni kubuna damdi yadi yeghana da kubura tupane wawaya tupadi konawonedi da metagha yadi berona kiiravine aro siyakabi bi aniyawiidina.’” ");
INSERT INTO aui_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Raghanina kubuna damdi Pol yana sisiya siwaiyaneni, na sivinuwamiise kirakii bi Bada sikabepepi warana kiiravine; bi iiyawogha nada ivineyidi da yawa makewaghawaghasina sinakabi, na sivigeruwana. ");
INSERT INTO aui_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Wasina bi Bada wonana noko kuburina tupana ikabimumu. ");
INSERT INTO aui_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Na Jius babada sigeghomiiri da kubuna wasiwasike moumouridi iiyawogha God sakabekabepepi, da kate kwanatu kana wiinaghowana tomotomoyidi nuwanuwadi sipiro. Da nokodi damdi wawaya mududi sitarepepidi na Pol da Banabas siviaviyedi bi yadi kuburama sivikanibuvedi. ");
INSERT INTO aui_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Wasina bi Pol da Banabas kaye popokudi sikasiwiiririgha (nokona wiiyeveveyana da God nuwanuwana ipughu nokodi damdi biiyadi), bi sitouya sinagho Ikoniyamma. ");
INSERT INTO aui_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bi wiigeruwana damdi Antiyok kwanatune sivinuwamiise kirakii bi Kanuma Kabikabikuwayina iyakoyakoyayidi. ");
INSERT INTO aui_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Wasina bi ware Antiyokne, berana mayimayiyina Ikoniyam kwanatuna kamone Pol da Banabas sinagho, Jius yadi kabepepa barene bi sidima kayowiiwiiyaka na koroto kiitowana, Jius da kubuna damdi sivigeruwana. ");
INSERT INTO aui_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bi Jius mududi sisinighii da gesiyigeruwana na sigeghomiiri da kubuna damdi nuwanuwadi sipiro da sitayina wamiridi bi Pol da Banabas siviaviyedi. ");
INSERT INTO aui_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bi gegha da Pol da Banabas nama raghani gurina simakae, da geere sinimayayidi bi Bada yana nuwamonika kiiravine siyadimadima. Na Bada, wawaya iviyevevedi da yadi dima na wiisuwona kiiravine da maragata iveredi bi mmko kedane na berakayowiiwiiyaka da matakira sibera. ");
INSERT INTO aui_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bi Ikoniyam kwanatuna kamone wawaya sivibogaebogae da dam bata: mududi na Jius gewiiwiigeruwanidi muridiye bi viya na apasol muridiye. ");
INSERT INTO aui_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wasina bi kubuna damdi da Jius damdi mududi da yadi babada teya sivigiugerogerora bi Pol da Banabas siyagogona kuridi siyikayotaketowanedi bi akimama siyikasunughanedi. ");
INSERT INTO aui_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bi gegha da akovina sikabi na siverawiikowogha sinagho Listra da Debi kwanatudiye, Laikoniya kubura kamone bi kate kubura riridiye. ");
INSERT INTO aui_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bi name Bada Yesu warana miisena bada siyadimadimeni. ");
INSERT INTO aui_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nama Listra kwanatuna kamone na tomogha tana nama itubugha da digadigana bi gemeyani iyapepewa towoghana. ");
INSERT INTO aui_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Gabudara tana imake bi Pol iyiisisiya na iyawaiwaiyana. Na Pol, tomoyina ikitabogaboga bi iyakovi da ivigeruwana da iyayawa, ");
INSERT INTO aui_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","na Pol irukwatu iwoneni bo, “Geghomiiri, kumiiri rotomana!” Yaininagha tomoyina iyawa na imakegeghomiiri da pepewa idaguni. ");
INSERT INTO aui_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Raghanina wawaya sikita da Pol awaki ibera, na sidagu yadi gamo waghata - Laikoniya gamoma sirukwatu bo, “God yadi bata sivi wawaya wota bi kiidamoma siyowogha kurida!” ");
INSERT INTO aui_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Na Banabas waghawagha sivereni Zeus, bi Pol na Hemes, basuna touna wiisisiya woraworana. ");
INSERT INTO aui_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na god Zeus kana kabepepa barena na kwanatu matamketana bi kubuve, na kana prist, kau makidi da saru gerogeroridi ikawara ipiika da matamketa basune, bi touna da yana wawaya sikayoveni da apasol Pol da Banabas biiyadi siyasuwara. ");
INSERT INTO aui_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bi raghanina apasol siwaiyana da awaki iyatubutubugha na kadi gara sitayina gosigosira bi sivera sikanibu koroto kamodiye siwona bo, ");
INSERT INTO aui_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Turaturamii, awaki biidi mmko koberabera? Toumii na wawaya wota, tami naboni. Bi kapiika da wara miisena kanawonemi, da mmkodi god wiiwiiyaba gekonapepetedina bi konadagu God Makewaghawaghasina konapepeteni. Mmko God na abama, kubura da yegii ibera, bi kate awaki kamodiye. ");
INSERT INTO aui_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Naghove wawaya iviwaghasinedi da yadi god rapediye siyakabekabepepa. ");
INSERT INTO aui_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bi gegha da yiyeveveyana da touna yamakamake bi yana miisena ivimaghatari touda biiyadi mmkodi matakirama: Abamama amra ivereda bi moura kadi raghani nunudiye: kam yaverevereda bi yabera da tinuwamiise.” ");
INSERT INTO aui_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bagune mmkodi sisiyama Banabas da Pol sibera towogha kirakiiyeni da Listra damdi siyigesiyedi da gesiyasuwaridina. ");
INSERT INTO aui_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wasina bi Jius damdi mududi Antiyok da Ikoniyam kwanatudima sipiika, bi koroto nuwanuwadi sipiro. Na sitarawiikapudi da akimama Pol sirouvi bi sinoghosi da irabobo na sitayina kwarokwaro sikanibu kwanatu kubune. ");
INSERT INTO aui_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bi gegha da raghanina wiigeruwana damdi mududi sigwagwara wiikenavivireni, na igeghomiiri da iveramagha irughu kwanatuve. Raghani ibori na touna da Banabas sitouya sinagho Debi kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol da Banabas, Debi kwanatune God warana miisena sidimeni na wawaya korotodi Bada sivigeruveni. Murine na siveramagha Listra kwanatune, da sinagho Ikoniyam kwanatune, da kate bada sinagho Antiyokma, Pisidiya kubure. ");
INSERT INTO aui_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bi kwanatu nunudigha wiigeruwana damdi siwonawiitoratoradi bi siwonawiiyoyowanedi da yadi wiitumaghana inimaragata, siwonedi bo, “Wiigeruwana damda nuwapoya bogaebogaema tana kabikwarakwara bi muriye na God yana wiikiiwawo kamone tanarughu.” ");
INSERT INTO aui_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Wasina bi Pol da Banabas wiigeruwana damna nunudigha kadi babada sivinegha, bi wiiya teya sirupari Bada biidi da babadidi imane sitoredi, kiiravine yadi noghota da wiitumaghana na touna gwabine siyatoretore. ");
INSERT INTO aui_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bi Pisidiya kubura siverarughuwoneni murine, na Pampiliya kubure siverakanibu, ");
INSERT INTO aui_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","da Pega kwanatune wara miisena sidima ikovi, bi murine na siyowogha sinagho kikire, Ataliya kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Da name wagae sigeru bi sinagho Antiyokma, Siriya kubura kamone, meme yadi wagawaga sidagunina. Bi rorowainagha noko kwanatune wiigeruwana damdi rupariye sivibaba da God, Pol da Banabas iyakoyayidi bagibagi meko kata sinakivinina kiiravine na imane sitoredi. ");
INSERT INTO aui_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Raghanina Pol da Banabas Antiyokma siverakanibu, na wiigeruwana damdi sikasiwiitaghomidi bi siwonedi da God awaki beradi toudiye ibera da kate metagha keda ikabitaveni kubuna damdi kiiravidiye da siyigeruwana. ");
INSERT INTO aui_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wasina bi Pol da Banabas nama raghani gurina wiigeruwana damdi yawata simakae. ");
INSERT INTO aui_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wasina bi tomotomogha mududi Jiudiya kuburama sipiika siyowogha Antiyokma bi sidagu wiigeruwana damdi siyiyevevedi siyawonawona bo, “Mosis yana gwara nunune na tami konisinibori na wasina, bi mmko matakirina gegha konakabina kate gekonayawana!” ");
INSERT INTO aui_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mmko sisiyina kiiravine na Pol da Banabas, Jiudiya damdi yawata sivikawakeereyana. Noko kiiravine wiigeruwana damdi Antiyok kwanatune Pol, Banabas da wiigeruwana damdi mududi sivineyidi da siyagae siyanagho Jerusalemma bi mmko piropirona kiiravine apasol da dogadogara siyakitadi. ");
INSERT INTO aui_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wasina bi wiigeruwana damna wawayidi Pol, Banabas da wiigeruwana damdi vinevineyidi siviporadi Jerusalemma, bi yadi pepewa kamone na wiigeruwana damdi Ponisiya da Sameriya kubura kamodiye, siwonedi da metagha kubuna damdi simiiri karona God biidi: Bi mmko sisiyina kiiravine na wiigeruwana damdi nama sivinuwamiise kirakii. ");
INSERT INTO aui_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bi raghanina Jerusalema siverakanibu, na wiigeruwana damna wawayidi tupana, apasol bi kate dogadogara sigeghomiiri da turadi sivikiikiivedi, na Pol da Banabas wonavereyana sitore da God metagha yadi bagibagi kamone ibera. ");
INSERT INTO aui_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bi wiigeruwana damdi mududi, toudi na Perisis sigeghomiiri da siwona bo, “Kubuna damdi sinisinibori bi tanawonedi da Mosis yana gwara sinakabisisiredi.” ");
INSERT INTO aui_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na apasol da dogadogara sivitaghomidi da mmko berana siyidughuveni. ");
INSERT INTO aui_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Berana sivisisiyena kirakiiyeni bi murine na Pita igeghomiiri bi iwona bo, “Warewaresigu, kwakovi da God rorowainagha touda kamodama ivineyigu da kubuna damdi biiyadi Wara Miisena anadima bi sinawaiyana da Yesu sinigeruveni. ");
INSERT INTO aui_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God wawaya tupadi nuwanuwadi iyakowa bi iviyeveveyana da kubuna damdi iviwaghasinedi bi Kanuma Kabikabikuwayina iveredi, ware touda biidi ibera na naboni. ");
INSERT INTO aui_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Bi yabera da touda bi kate kubuna damdi na mayimayiyida, na yadi bera beroberodi inoghotatavedi, basuna Yesu sivigeruveni kiiravine. ");
INSERT INTO aui_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Na awaki kiiravine, koberaberatowoyi da God konarubuni? Touda bi kate nosinosidanakim getayimaragata kirakii da mmkodi gwara tayakabisisirena yaporidi. Bi kata tami mmko vitana kubuna damdi katiiyadiye kotoretore. ");
INSERT INTO aui_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Gegha da, touda tavigeruwana da Yesu Keriso yana nuwamonika kawae na tayawa. Na mayimayiyina bada kubuna damdi kiiravidiye.” ");
INSERT INTO aui_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Wasina bi wawaya tupadi siviraborabobo bi Banabas da Pol siyisisiya na siyawaiwaiyanedi da God metagha berakayowiiwiiyaka da matakira toudiye ibera kubuna damdi wiiwiitumaghanidi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Raghanina sivisisiya ikovi na Jemes igeghomiiri bi iwona bo, “Warewaresigu, kowaiyanegu, ");
INSERT INTO aui_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pita nada iwoneda da metagha God dagudagune iviyeveveyana da kubuna damdi nuwanuwadi ikabi, bi kamodiye viya iyouna da touna yana wawaya. ");
INSERT INTO aui_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Bi peroperoveta yadi sisiya na mmko sisiyina teya sivikapudi, da sigirumina iwona bo, ");
INSERT INTO aui_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","17","‘Bada iwona bo, “Muriye anaveramagha da Deivid yana wiikiiwawo ibeku na anakabiwiimaragasi. Gharaghuna anakabunayi da anayoghana mayeni, bi anabera da inimaragata magha. Noko biidi wawaya tupadi tagu, Bada sininoyegu sinapiika, da kate kubuna damdi wiiwiitumaghanidi iiyawogha avinegha da rapeguve na tupadi yawata.” ");
INSERT INTO aui_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mmkona Bada naghove waghata ikabiwiimaghatari na yawonewoneni.’” ");
INSERT INTO aui_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","21","Wasina bi Jemes yana sisiya ivikiitayineni iwona bo, “Mmko raghani gurina kubura nunudiye wawaya na Mosis yana gwara sakabikabiyawa bi wiiyawiitaveyana gabudaridiye na kabepepa barediye nonowa sadimedimedi. Touna kiiravine tagu yagu noghota na kubuna damdi wiiwiitumaghanidi iiyawogha God biidi samiimiiri karona, na getana bera da inapiropiro toudi biiyadi. Bi meboda pepa tayagirumi tayipora toudi biiyadi bi tayawonedi da iyuwa mekodi tarabiibiisaka biidi sasuwara na gesinakamna, bo ribiribi kanighona turaturaviroyina iyuvina meko, ganiganina geiyororotaveyana bi gesinakani bo ganigani gesinaniunina da kate gewiimumurana beradi bogaebogae sinabera da sinitamumuna.” ");
INSERT INTO aui_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Wasina bi noko murine apasol, dogadogara da wiigeruwana damna tupadi noghota sitore da wawaya viya nama kamodima siyavinegha bi siyiporadi Pol da Banabas yawata siyanagho Antiyok kwanatune, Siriya kubure da awaki sividughuveni na wiigeruwana damdi siyawonawiikatayidi. Na tomotomogha bata sivineyidi, Jiudas (sakwatuveni Basabas) da Sailas bi toudi na wiigeruwana damdi yadi kabikarawagha gwabidiye. ");
INSERT INTO aui_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bi pepana sigirumi da sivipora na mma naboni iwona, Toumii apasol da dogadogara na warewaresimi bi Jerusalemma kagiruma. Tami gegha Jiu dammi wiiwiitumaghanimi Antiyok kwanatuna kamone, Siriya kubura da Silisiya kubura kamodiye, kiiwa kiiwa. ");
INSERT INTO aui_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Toumii kawaiyana da wawaya kamomiima iiyawogha gekayiporadi bi sinagho tami biiyadi na yadi wiiyeveveyanama nuwapoya siveremi. ");
INSERT INTO aui_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Na kavidughu bi tupamii kaviwaghasina da tomotomogha kavinegha bi kaviporadi sinagho tami biiyadi turaturada nuwayuyunidi Banabas da Pol yawata da mmko warana siyawonemi. ");
INSERT INTO aui_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Toudi yada Bada Yesu kana waghawaghae yadi yawa siveremayedi da sinabagibagiyeni. ");
INSERT INTO aui_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na toumii Jiudas da Sailas kaviporadi tami biiyadi bi konimayiyi kitakita bi kawadima awaki kagirumina sinawonemi. ");
INSERT INTO aui_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bi imiise kirakii Kanuma Kabikabikuwayina da toumii yama noghotana gegha sira peyaridima kani vita kawarimina, bi mmkodi sira ghamanakidi kawagha sinawonemi da konakabisisireyana: ");
INSERT INTO aui_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","gegha wawaya iyuwa tarabiibiisaka biidi sinasuwara bi konakanina, gegha ganigani konaniunina, gegha ribiribi kanighona wawaya sinaturaviroyi bi ganiganina geiyororotaveyana bi konakanina da kate wiimumurana beradi bogaebogaema tamumu konaberana. Bi memeda mmkodi sira konakabisisirena wiimasiyedi na awaki konaberabera na tami wasina kawakawa. Kiiwa kiiwa. ");
INSERT INTO aui_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Na tomotomoyidi siviporadi da Jerusalem sikuyoveni bi sinagho Antiyok kwanatune; bi name wiigeruwana damdi tupadi sikwatuwiitaghomidi bi pepana siveredi. ");
INSERT INTO aui_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bi raghanina pepana sikabiyavi, na wawaya tupadi sivinuwamiise kirakii noko wonawiiyoyowanina warana kiiravine. ");
INSERT INTO aui_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Wasina bi Jiudas da Sailas, toudi wosina na peroperoveta kiiravine na wiigeruwana damdi biiyadi sisiya miisedima siwonawiiyoyowanedi da yadi wiitumaghana siyimaragasidi. ");
INSERT INTO aui_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Jiudas da Sailas, Antiyok kwanatune simakae raghani gisina bi murine, na wiigeruwana damdi sigeghomiiri nuwamiimiiseye da nuwaruririye siviporadi da siveramagha Jerusalemma iiyawogha siviporadina toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bi Pol da Banabas na Antiyokne simakae, bi toudi da wawaya mududi yawata Bada wonana siyiyeveveyana da siyadimadima. ");
INSERT INTO aui_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Bi gabudara viya sikovi murine na Pol, Banabas iwoneni bo, “Kayo tanaveramagha kwanatu tupadiye da wiigeruwana damdi tana rubodadi, meme Bada wonana tadimana, bi tana kita da yadi wiitumaghana metegha.” ");
INSERT INTO aui_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Na Banabas iviwaghasina bi ikayoveni da Jon (sakwatuveni Mak) siyarutayini, ");
INSERT INTO aui_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","bi Pol inoghosi da geiyamiise da siyarutayini, basuna roro yadi wagawaga patapata kamone na Jon Mak, Pampiliya kubure iveramagha da geyawata siyamake patapata bi yadi bagibagi tughurina siyabera na kiiravine ivigesa. ");
INSERT INTO aui_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bi noko sisiyina kiiravine na sivikawakeereyana kirakii, da sivibogabogae; Banabas na Jon Mak irutayini bi wagae sigeru da sinagho Saipras nuwane, ");
INSERT INTO aui_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","bi Pol na Sailas ivineyi bi muriye da sitouya na wiigeruwana damdi sivitaghomidi bi Bada sivibabiini da iyakoyayidi. ");
INSERT INTO aui_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wasina bi Siriya da Silisiya kwanatudi tupadi sipepewakovi da wiigeruwana damdi siyarurugenaredi bi sisiya miisedi siyadimadima da yadi wiitumaghana siyimaragasidi. ");
INSERT INTO aui_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol da Sailas sinagho Debi kwanatune da bada sinagho magha Listra kwanatune. Bi name na tomogha tana wiiwiigeruwanina iyamakamake kana waghawagha Timoti, touna sinananaki na Jius wasike wiiwiigeruwanina bi tamananaki na Grik tomogha. ");
INSERT INTO aui_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wiigeruwana damdi Listra da Ikoniyam kwanatudi kamodiye na siyawonawona da Timoti na wawaya kiimatanina. ");
INSERT INTO aui_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bi Pol yana kayowana da yawata siyawagawaga patapata kiiravine na Timoti sinina ibori basuna Jius tupadi nokodi kuburidiye samakamake na sakovi da tamananaki na Grik tomogha noko biidi Timoti ivisinibori. ");
INSERT INTO aui_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Wasina bi Pol, na Sailas da Timoti yawata kwanatu nunudigha siyanono, na sira mekodi, Jerusalemne apasol da dogadogara gwabidima sikabi na wiigeruwana damdi siyawonewonedi bi sidimanaveni da kubuna damdi wiiwiitumaghanidi siyakabisisiredi. ");
INSERT INTO aui_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Na wiigeruwana damdi yadi wiitumaghana ivimaragata kirakii na gabudara patepatena wawaya korotodi siyiigeruwana da yadi koroto iragata kamokamogha. ");
INSERT INTO aui_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Wasina bi Kanuma Kabikabikuwayina geiyiwaghasina da Pol turaturana yawata Eisiya kubure God wonana siyadimeni, na Praigiya da Galeisiya kubura kamodigha siveravivira. ");
INSERT INTO aui_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Raghanina sipiika Maisiya kubura kana wiibarabarate, na siberatowoyi da Bitiniya kubure siyarughu bi gegha da Yesu Kanumina geiyiwaghasinedi da nabo siyanaghona. ");
INSERT INTO aui_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Na noko biidi Maisiya kubura siverarughuwoneni da siyowogha sinagho kikire Troas kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Wasina bi noko nubabasune Pol noghotama ikita, bi noghotama ikita kamone na ikita da Masedoniya tomogha iyamiimiiri bi iyiipepeyana wiimaragata Pol biidi iyawonawona bo, “Kutowawona mabo Masedoniya kubure da kuniwiitemii!” ");
INSERT INTO aui_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wasina bi Pol mimeu ikita ikovi murine, na toumii kakabununagha yaininagha da kayatouya Masedoniyama basuna kakovi da God ikayovemii da warana miisena name wawaya biiyadi kayadima. ");
INSERT INTO aui_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wasina bi Troas kwanatuna kakuyoveni na wagae kageru bi katowawona Samotreis nuwane. Bi raghani ibori na katowawona Neyapolis kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bi name na kayegha karughu Pilipai kwanatune. Noko kuburina na Roum yadi wiibadana kamone bi Masedoniya kubura kwanatuna ghamana tana bi nama gabudara viya kamakae. ");
INSERT INTO aui_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Bi wiiyawiitaveyana gabudarine na kwanatu kakanibutaveni kanagho rarime, bi kanoghosi da rupari gawarina tana namameme kayabanani. Wasiwasike mududi nama sivitaghomidi rupari kiiravine, na kamakeyowogha bi wiisisiya kadaguni toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wasike tana nama kamodiye iyawaiwaiyanemii na kana waghawagha Lidiya, touna yana kwanatu na Tayatira bi gara dugadugaridi iyigimogimona. Bi God iyakabekabepepi na ibera da nuwanuwana itamotatara da iyakowa na Pol yana sisiya Yesu kiiravine na ivigeruwana. ");
INSERT INTO aui_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wasina bi Pol da Sailas, Lidiya da wawaya iiyawogha nama yana bareye siyamakamakena sibabataitodi, bi murine na iviyonemii iwona bo, “Memeda kwiiwaghasina da tagu wiisuwona Bada iigeruveni, na kopiika yagu bareye konamake.” Bi ivibaba tupetupemii patana da kaviwaghasina. ");
INSERT INTO aui_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gabudara tana raghanina kayayoyo rupari gawarine, na wiibagubagurana wasikena ibananimii. Bi kanuma berona iyiibadeni na awaki raghani muriye sinatubughana iyiidebedi. Touna yana bada kiiravine na wonaruyaraghama mane ghamana iyakabikabi. ");
INSERT INTO aui_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Bi Pol da toumii iyakivikivina wiitetemii bi iyakwatukwatu bo, “Mmkodi tomotomogha na God Kiidamo Kirakiina Makamakena yana wiitamatamariyana, toudi sawonewonemi da metagha God iniyawiimi.” ");
INSERT INTO aui_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Bi wasikena patana naboni iyisisiya make da gabudara viya sikovi, na Pol nuwanuwana ivisi, na imiiriwamira bi kanuma berona iwoneni bo, “Yesu Keriso kana waghawaghae awonewonem da wasike kanibutaveni!” Na yaininagha kanuma berona wasikena ikanibutaveni. ");
INSERT INTO aui_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bi raghanina kana babada sikabibanani da kanuma berona wasike ikanibutaveni, bi yadi wiimane kedana iwapa, na Pol da Sailas siburavidi bi sitayinakwarokwarodi sinago wiigimogimona gawarine, da kwanatu babadidi naghodiye siyamiiri; ");
INSERT INTO aui_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","bi raghanina sirutayinidi sinagho babadidi biiyadi na siwona bo, “Mmkodi tomotomogha na Jius bi piropiro situbutubugha yada wawaya kamodiye mma yada kwanatuve. ");
INSERT INTO aui_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Toudi yada wawaya kiki beradi siyevevedi mekodi yada gwara geiyiwaghasinedi, bi touda Roum tubutubugha na gerubana mmkodi kiki taniwaghasinedi bo tanabera towoghana.” ");
INSERT INTO aui_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bi koroto bada sivirukapuwana sigeghomiiri Pol da Sailas sigogona kuridi; na kwanatu babadidi iyo tomotomogha siwonedi bo, “Pol da Sailas kadi gara kokabitavetaveyana bi vidima korouvidi.” ");
INSERT INTO aui_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bi sirou kirakiiyedi ikovi murine na biwa gawarine sitorerughuvedi, bi badana siwoneni da inakubodebodedi bi inakoyagha yaporidi. ");
INSERT INTO aui_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mmko sisiyina kiiravine na biwa gawarine tupayarayina tana basukiine itoredi, bi kayedi kii tupodi bi vitadi ere bonayidiye ivitupatetedi bi ipoyakavinidi. ");
INSERT INTO aui_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Bi pom kambasune Pol da Sailas siyarurupari bi ayi siyatawotawora da God siyakabekabepepi, bi turaturadi biwa kabikabi damdi viya na siyawaiwayanedi, ");
INSERT INTO aui_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","bi yaininagha nukenuke ghamanakina itubugha da biwa gawarina barena ere kayena inukeni; raghani tana biwa gawarina matamketadi sitamotatara bi biwa kabikabi damdi kadi sein sitamotavetaveyana. ");
INSERT INTO aui_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bi raghanina biwa badana ikenamataka bi ikita da matamketa tupadi sitamotatara, na inoghosi da biwa kabikabi damdi tupadi siviveraveruwana, na yana seri itainayamuri da pinimina bi tounamani iyagwarunugha mayeni. ");
INSERT INTO aui_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bi Pol irukwatu da ghamana iwoneni bo, “Gekunirabobo mayemna, toumii tupamii mma.” ");
INSERT INTO aui_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Na biwa badana bagibagi turaturana biiyadi kibe kiiravine irukwatu da siyakawari siyapiika, bi ivera irughu biwa gawarina kamone tupayarae bi ere kirokirorona Pol da Sailas naghodiye ipepeta iyowogha. ");
INSERT INTO aui_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wasina bi irutayinidi sikanibu bi iwonedi bo, “Babada, awaki anabera da yawa makewaghawaghasina anakabi da God yagu tamumu kiiravine gegha aro inavereguna?” ");
INSERT INTO aui_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na Pol da Sailas siwoneni bo, “Bada Yesu kitumaghaneni na tam kunayawa, da yam rakaraka yawata.” ");
INSERT INTO aui_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wasina bi Bada wonana sidimeni touna da yana rakaraka tupadi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bagune patana pom kambasune bi biwa badana, irutayinidi sinagho da kadi gubaga iyamagha, bi yaininagha Pol da Sailas, biwa badana da yana rakaraka yawata sibabataitodi. ");
INSERT INTO aui_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wasina bi noko murine na irutayinidi sirughu yana bareye da kam iveredi sikam. Bi touna da yana rakaraka yawata tupadi sivinuwamiise kirakii basuna katana God sivitumaghaneni. ");
INSERT INTO aui_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bi raghani ibori na kwanatu babadidi, iyo damdi siviporadi sinagho biwa badana siyawoneni bo, “Nokodi tomotomogha kuyovedi sinanagho.” ");
INSERT INTO aui_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Na biwa badana Pol iwoneni bo, “Babada sisiya sidaru da tam da Sailas kana kabitavemi. Wasina katana kokanibu, nuwaruririye konagho.” ");
INSERT INTO aui_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bi gegha Pol, iyo tomotomogha iwonedi bo, “Toumii na Roum tubutubugha bi getana awaki kaya berabero. Bi awaki kiiravine gesiyitupawamiwamiremii bi debae wawaya tupadi naghodiye sirou kirakiiyemii bi biwa gawarine sitorerughuvemii. Bi kata yadi kayowana da wiikowoye sinawonatavemii? Gegha, gerubana, kwanatu babadidi toudimani sinapiika da sinikanibuvemii.” ");
INSERT INTO aui_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Wasina bi iyo tomotomogha siveramagha sinagho babadidi biiyadi da Pol yana sisiya siwonaveredi bi raghanina siwaiyana da toudi na Roum tubutubugha na sinaghara kirakii; ");
INSERT INTO aui_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","na sinagho biwa gawarine Pol da Sailas biiyadi da awaki berana berona sibera na kiiravine siwonawiipikepikedi. Wasina bi sikabikanibuvedi bi sivibabiidi da yadi kwanatu siyakuyoveni. ");
INSERT INTO aui_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Raghanina Pol da Sailas biwa gawarina sikanibutaveni, na sinagho Lidiya yana bareye; da name wiigeruwana damdi yawata sivitaghomidi bi siwonawiiyoyowanedi da yadi wiitumaghana inimaragata. Wasina bi murine na kwanatuna sikuyoveni sinagho. ");
INSERT INTO aui_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol da Sailas, Ampipolis da Apoloniya kwanatudigha sipepewa rughuwona sipiika da Tesalonika kwanatune siverakanibu. Bi nama na kabepepa barena tana noko kwanatune Jius damdi kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol nonowa iyaberaberana naboni, na inagho kabepepa barene irughu, bi God wonanama iyiyeveveyana bi toudi siyawonawonabodeyana. Bi mmko berana na wiiyawiitaveyana gabudaridi nunudiye taparoro aroba kamone ibera. ");
INSERT INTO aui_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bi God wonana yana basuna waghata iyiidebeni wawaya biiyadi bi nokove na iviyeveveyana da meboda God yana Wiivinevinegha Kiiwawona inakabikwarakwara da inarabobo bi rabobo murine inageghomiiri. Pol iwonedi bo, “Mmko wawayina iisisiyeni tami biiyadi, na Yesu touna na Keriso, God yana wiivinevinegha kiiwawona!” ");
INSERT INTO aui_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wasina bi Jius damdi mududi da kate Grik damdi korotodi iiyawogha God siyakabekabepepi, da kate bada wasiwasike kadi waghawagha ghamaghamadi korotodi, Pol yana sisisya sivigeruveni da Yesu sivitumaghaneni na Pol da Sailas sivirukapuvedi. ");
INSERT INTO aui_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bi gegha da Jius mududi sinuwakapi basuna wawaya korotodi Pol yana sisiya sivigeruveni kiiravine, na wiigimogimona gawaridiye wawaya berodi wiikedapepevidi sikasiwiitaghomidi da sivirukapuwana bi wiikayotirana sidaguni. Sivera sinagho tomogha kana waghawagha Jeison yana bare sigauwowori da sirughu kamone Pol da Sailas siyiininoyedi, memeda siyakabidi siyakanibu koroto naghodiye. ");
INSERT INTO aui_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bi raghanina gesiyabananidi, na Jeison da wiigeruwana mududi siburavidi bi sirutayinidi sinagho kwanatu babadidi biiyadi da sirukwatu siwona bo, “Nokodi tomotomogha iiyawogha kubura tupane piropiro sibera na kata sipiika yada kwanatuve, ");
INSERT INTO aui_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na Jeison itayinariyadi yana bareye! Toudi, Roum kana kiiwawo Sisa yana gwara sikasigiiyeni sawonawona da kiiwawo tana yamakamake, kana waghawagha na Yesu.” ");
INSERT INTO aui_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Raghanina kwanatu damdi da yadi babada mmko sisiyina siwaiyaneni na nuwanuwadi sipughu kirakii. ");
INSERT INTO aui_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Wasina bi kwanatu babadidi sibera da mane sikabiguba na rubane Jeison da wiigeruwana turaturana viya yawata siyimiisana ware wonawaghata da gemuriye piropiro naboni inatubugha maghana bi sisiya bagibaginama siwonedi bi siviwaghasinedi da sikabitoredi sinagho. ");
INSERT INTO aui_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Wasina bi noko nubabasune wiigeruwana damdi, Pol da Sailas siviporadi sinagho kwanatu kana waghawagha Bereyama. Raghanina siverakanibu na sinagho kabepepa barene. ");
INSERT INTO aui_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bi Bereya damdi yadi bera da nuwanuwadi na miisedi genaboni Tesalonika damdi. Toudi nuwanuwadi sisisira kirakii basuna yadi kayowana ghamana da Yesu warana miisena siyawaiyaneni. Bi gabudara patepatena God wonana bukae girugirumina siyakabikabiyavi bi akowa siyakabikabi da memeda Pol yana sisiya na wonawaghata bo gegha. ");
INSERT INTO aui_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Na noko kiiravine Jius korotodi Bereya kamone Yesu sivitumaghaneni, bi kate Grik wasiwasike kadi waghawagha ghamaghamadi korotodi da kate bada Grik tomotomogha korotodi yawata. ");
INSERT INTO aui_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bi raghanina Jius damdi Tesalonika kwanatune akowa sikabi da Pol, God wonana Bereya kwanatune iyadimadima, na bada nabo sinagho da wawaya nuwanuwadi siyapiro bi siyabera da wawaya nuwanuwadi siyapughu Pol biidi. ");
INSERT INTO aui_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Na wiigeruwana damdi yaininagha Pol siviporataveni ikanibu kikire, bi Sailas da Timoti na nama Bereya kwanatune simakae. ");
INSERT INTO aui_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bi tomotomogha iiyawogha Pol sivikayeturaneni na sikabi sinagho Etens kwanatune. Wasina nama bi Pol yana sisiya sikabi siveramagha Bereya kwanatune, Sailas da Timoti siyawonedi yaininagha siyanagho Pol biidi, Etens kwanatune da siyikapuvena mayeni. ");
INSERT INTO aui_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wasina bi Pol patana Etens kwanatuna kamone Sailas da Timoti iyakoyakoyayidi, na tarabiibiisaka peyaridi noko kuburine ikita na ivinuwapoya kirakii. ");
INSERT INTO aui_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Na noko kiiravine idagu kabepepa barene Jius damdi da Grik damdi iiyawogha God sakabekabepepi na yawata Yesu kiiravine siyidimeyana. Bi kate gabudara patepatena iyanono wiigimogimona gawarine da iiyawogha nama na yawata siyiisisiya. ");
INSERT INTO aui_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bi kamodiye viya na abawiiyeveveyana damdi iiyawogha yadi wiina da wiisuwona sisiyina bi kate yawa yana basuna kiiravidiye sinisisiyana, sakwatuvedi Ipikuriyan da Stoiki damdi. Toudi Pol yawata bada sivigamowana, Pol na Yesu Keriso warana miisena kiiravine iyadimadima da wawaya raboboma sinageghomiiri. Na nokodi damdi mududi sivitarakiiyana bo, “Mmko kawa neghaneghana awaki yisisiyeni? Yana sisiya gedamidina.” Na mududi siwona bo, “Augunai kubura wiibata yadi god kiiravidiye yisisiya.” ");
INSERT INTO aui_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Wasina bi Pol sikabi sinagho yadi wiidughu gawarine kana waghawagha Eriyopagas bi name siwoneni bo, “Toumii kakayokayoveni da kanakovi, mmko awaki wiiyeveveyanina wouna tam kwiisisiyeni? ");
INSERT INTO aui_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tam sawara mududi mekodi kuvisisiyedi na toumi naghove gekayawaiyanedi, na yama kayowana da yadi basuna kunidebedi da kanakowa yaporidi.” ");
INSERT INTO aui_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Mmko sivisisiyenina basuna Etens damdi da kubura wiibata damdi nama makamakedi na getana awaki sinabera da noghota woudi sisiyidi sinawaiyana bi sinidimeyanena pomedi). ");
INSERT INTO aui_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Wasina bi Pol dughu kamone igeghomiiri da kwanatu babadidi naghodiye imiiri bi iwona bo, “Akitakita da tami Etens dammi na nonowa yami god kopeepetedi. ");
INSERT INTO aui_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Noko awonenina basuna yami kwanatu ayiitubata wiikenavivirena raghanine, na yami kabepepa sawaridi akita bi bada suwara gabugabuna gawarina tana abanani bi debane na mma naboni girugirumina, MMKO GAWARINE GOD MEKO GEKAYAKOVINA KIIRAVINE KASUWARI. Tami noko God na gekoyakovi bi kopeepeteni - na tagu noko God na kiiravine anawonemi. ");
INSERT INTO aui_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God, kubura ibera da kate sawara tupadi kamonena. Touna abama da kubura kana wiibadana, na gegha bare meko wawaya imadima siyoghanina kamone inamekena. ");
INSERT INTO aui_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Bi gewawaya yadi wiiwiita iyakayokayovenina, basuna touna wosina yabera da wawaya sayawa bi sawara tupadi sakayokayowana na yaveredi. ");
INSERT INTO aui_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ghuyoghuyone na tomogha tana ibera bi noko tomoyina gwabinama na dam tupadi situbugha da kubura tupane samakamake. Bi gabudara kiiravidiye itoura bi kate bada kubura kadi barata itoura da meme sinamake da meyani sinarabobo. ");
INSERT INTO aui_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God mmko ibera da wawaya siyinoyeni bi kabigwamma meboda siyabanani, bi gegha da touda tatadigegha gwabidayena touna gerabarabana. ");
INSERT INTO aui_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ware naboni wawaya tana iwona bo, ‘Touna ibera da tamakamake bi tiidagudagu da bera awaki taberabera na tana bera.’ Bi bada yami girugiruma wawayidi sigiruma bo, ‘Touda na touna natunatuna.’ ");
INSERT INTO aui_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Wonawaghata touda na God natunatuna, noko kiiravine getananoghosi da touna naboni tarabiibiisaka gould bo silva bo akimama siberana. Wawaya akakovidi yadi nuwagiurama na mmkodi sawara imadima sabera. ");
INSERT INTO aui_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Naghove waghata na wawaya, God gesiyakovina bi gegha da touna kiiravine na aro geiyaveredina, bi kata na wawaya kubura tupadiye samakamake na yawonewonedi da yadi noghota bo berabero sinamiiri kubutedi, ");
INSERT INTO aui_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","basuna touna gabudara itore da awaki raghanine wawaya tupadi initupawamiwamirena yaporidi. Bi tomogha tana ivineyi da tounaye mmko berana inabera. God noko tomoyina raboboma ikabiwiigeghomiiri, da noko inimatakira wawaya biiyadi da tomoyina na vinevineyina tana bi touna initupawamiwamira.” ");
INSERT INTO aui_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Raghanina wawaya, Pol yana sisiya siwaiyaneni bi iwona da wawaya raboboma inageghomiiri, na mududi sivinamayeni bi mududi siwoneni bo, “Toumii yama kayowana da raghani tane na bada mmko berana kunisisiyena mayeni da kanawaiyana.” ");
INSERT INTO aui_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Wasina bi Pol dughu kamonama ikanibu da inagho. ");
INSERT INTO aui_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bi wawaya mududi Pol sivirukapuveni da Yesu sivitumaghaneni, bi kamodiye na tomogha kana waghawagha Diyonisiyas touna kwanatu wiibadana tana da wasike kana waghawagha Damaris bi kate wawaya mududi yawata. ");
INSERT INTO aui_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mmko berana murine na Pol, Etens kwanatuna ikuyoveni bi inagho Korint kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Da name Jius tomogha tana ibanani kana wagahwagha Akwiila, touna yana kubura wadubo na Pontas bi wavinena Prisila yawata katotawota Itali kuburama sipiika, basuna Roum kana kiiwawo Klodiyas, Jius damdi tupadi iwonedi da Roum siyakanibutaveni. Pol inagho da iyakitadi ");
INSERT INTO aui_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","basuna toudi kiregoru kadi berabera wawayidi ware touna naboni, na nama yawata simakae da sibagibagi patapata. ");
INSERT INTO aui_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Bi wiiyawiitaveyana gabudaridi nunudigha na Jius da Grik damdi yawata kabepepa barene siyidimeyana, bi iyimatipo da iyatayina wamiridi da God yana sisiya Yesu kiiravine siyitumaghana. ");
INSERT INTO aui_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Raghanina Sailas da Timoti, Masedoniya kubura sikanibutaveni bi siyowogha sipiika Korint kwanatune, na Pol kiregoru beradi ikabitoura bi raghani nonowa God warana miisena iyadimadima Jius damdi biiyadi, iyawonawona da Yesu na God yana Wiivinevinegha Kiiwawona. ");
INSERT INTO aui_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bi gegha, raghanina Jius damdi Pol sivisinighiighiiyeni bi sivisisiya beroveni, na kana gara popokuna naghodiye ikasiwiiririyi bi iwonedi bo, “Meboda God aro inaveremi, na tamimani koviwawu mayemi. Getagu koniwawuguna! Kata bi nabo inagho na tagu ananagho kubuna damdi biiyadi da God warana anadimeni.” ");
INSERT INTO aui_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wasina bi Pol kabepepa barena ikuyoveni bi inagho tomogha kana waghawagha Taitus Jastas yana bareye. Noko tomoyina na kubuna wawaya, bi gegha da God iyakabekabepepi bi yana bare na kabepepa barena ririne. ");
INSERT INTO aui_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Bi kabepepa barena kana bada, Krispas da yana rakaraka yawata tupadi Bada Yesu sivitumaghaneni: bi bada mayimayiyina Korint damdi korotodi Pol yana sisiya siwaiyaneni, na sivigeruwana da sibabataito. ");
INSERT INTO aui_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nubabasu tana Bada mimeu kamone ivisisiya Pol biidi iwona bo, “Gekunanagharana! Kudima waghawaghata wawaya biiyadi kiiraviguve, gekunikawapotapotana! ");
INSERT INTO aui_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kiiravine tagu gwabimve, na getana iiyabo inarouvim da iniberomna, basuna wawaya korotodi mmko kwanatuna kamone na yagu wawaya.” ");
INSERT INTO aui_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Wasina bi Pol nama Korint kwanatune imakae da bodu tana bi nawaravi 6 kamone, God wonana wawaya iyiyevevedi. ");
INSERT INTO aui_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bi Roum bada ghamana tana, Galiyo sitore da Akaiya kubura iyibadeni raghanine, na Jius mududi sigeghomiiri Pol siviaviyeni da sikabitawatawani bi sikabi sinaveni mmko badana ghamana biidi da iyitupawamiwamireni. ");
INSERT INTO aui_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Toudi siviaviyeni siwona bo, “Mmko tomoyina, yaberaberatowoyi da wawaya nuwanuwadi inawamira da keda bogaema God sinakabepepi meko gwara geiyiwaghasinenina!” ");
INSERT INTO aui_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Wasina bi Pol idagu wiisisiya biiyadi na Galiyo, Jius damdi iwonedi bo, “Tami Jius dammi kowaiyana, augunai da mmko tomoyina bera gisigisidi bo ghamaghamadi iyaberabero da Roum yadi gwara iyikasigiiyeni, na tagu, yagu bagibagi da yami sisiya ayawaiyana. ");
INSERT INTO aui_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Bi gegha da mmkona, sisiya da waghawagha bi kate tami Jius yami gwara kiiravidiye kwiikawakereyana, noko biidi na tamimani konakabi wiirotomani. Bi mmkodi bera getagu anitupawamiwamiredina.” ");
INSERT INTO aui_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Wasina bi irukwavinidi da wiitupawamiwamira gawarina sikanibutaveni. ");
INSERT INTO aui_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bi kabepepa barena badana Sostines sikabitawatawani da nama wiitupawamiwamira gawarina naghone sirouvi. Bi Galiyo mmko yadi berana geiyinuwapoyenina. ");
INSERT INTO aui_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol, Korint kwanatune wiigeruwana damdi yawata simakae da raghani gurina, wasina bi ikuyovedi inagho Kenkriya kwanatune, Prisila da Akwiila yawata. Bi name Pol, wawaya tana iwoneni na gayamina isabutaveni bi nokona ivimatakira da yana wiisuwona God biidi ivikovini. Bi Pol, Prisila da Akwiila wagae sigeru bi siyanagho Siriya kubure. ");
INSERT INTO aui_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","21","Bi siyanono na dagudagune na Epesis kwanatune sirughu soghata, bi raghanine sitarakapoka na tanaduma inagho irughu kabepepa barene da Jius damdi yawata siyidimeyana. Bi raghanina sivibabiini da yawata siyamakewiiguri, na isinighii. Bi gegha da iyatutouya na iwonedi bo, “Memeda God iniwaghasinegu na kate bada anaveramagha kurimi.” Wasina bi nama Prisila da Akwiila, Epesis kwanatune ikuyovedi bi wagae igeru da itouya inagho. ");
INSERT INTO aui_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Raghanina Sisariya kwanatune iverakanibu, na igae inagho Jerusalemma da wiigeruwana damdi ivikiikiivedi, bi iveramagha bada iyowogha inagho Antiyokma. ");
INSERT INTO aui_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bi wiigeruwana damdi yawata simakae raghani gisina, bi ikuyovedi da inagho kubura bi kubura tupadiye ipepewa kovi, Praigiya kubura ririnagha da Galeisiya kubure wiigeruwana damdi biiyadi iyiisisiya da nuwanuwadi iyiimaragasidi. ");
INSERT INTO aui_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Noko raghanine Jius tomogha tana kana waghawagha Apolos, bi yana kwanatu na Aleksandriya, Ijipt kubura kamone iverakanibu Epesis kwanatune. Touna wiisisiya yapoyaporina bi akakovina na God wonana iyakowa kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Touna nada waghata wawaya gwabidiye Yesu yana Keda akovina ikabi, bi nuwanuwana maragasina bi iyadimadima. Bi Yesu kiiravine iyiisisiya na rotomanina kawakawa, bi gegha da touna babataito warana kawagha iyakovi meko Jon Babataito wawaya iviyevevedina. ");
INSERT INTO aui_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Na naghara gwabine gegha bi idagu kabepepa barene iyiisisiya. Raghanina Prisila da Akwiila mmko siwaiyaneni na sirutayini sinagho yadi bareye bi God yana Keda mekodi geiyakowana sivisisiyena rutughutughureni touna biidi. ");
INSERT INTO aui_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Wasina bi noko raghanine Apolos yana wiina da iyanagho Akaiya kubure da name iyadima, na wiigeruwana damdi Epesis kamone siwonawiiyoyowaneni bi pepa tana sigirumi wiigeruwana damdi biiyadi Akaiya kubure, da Apolos yapiipiika na siyaverabodeni da siyikiikiiveni. Raghanina iverakanibu na iiyawogha nada God yana nuwayuyune Yesu sivitumaghaneni kiiravine, na toudi wawayidi iviwiitena kirakiiyedi. ");
INSERT INTO aui_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yana wiiwiita kedana tana na deba dughudiye wiikawakereyana sibera da Jius damdi igeiwayidi. Bi God wonanama ivisisiya da iviyevevedi da Yesu na Keriso, God yana Wiivinevinegha Kiiwawona. ");
INSERT INTO aui_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Noko raghanine Apolos na Korint kwanatune bi Akaiya kubura kamone iyamakamake, bi Pol garagara kedana ikabi ipepewa patana da kikire, Epesis kwanatune iverakanibu bi name wiigeruwana damdi mududi ibananidi. ");
INSERT INTO aui_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Na ivitarakiiyanedi bo, “Raghanina Yesu kovitumaghaneni na Kanuma Kabikabikuwayina kokabi bo gegha?” Na siwonabodeni bo, “Gegha, getana kayawaiyana da nama Kanuma Kabikabikuwayina tana meme.” ");
INSERT INTO aui_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Na Pol ivitarakiiyana magha bo, “Memeda noko naboni, na meko babataitona kokabi?” Na siwona bo, “Jon, wawaya iyiyevevedina touna babataitona.” ");
INSERT INTO aui_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol iwonedi bo, “Jon, wawaya ibabataitodi na iyimatakira da yadi bera berodima simiirikubuta. Bi iwonedi da iiyabo murinagha yapiipiika na siyitumaghaneni. Touna na Yesu.” ");
INSERT INTO aui_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Raghanina Pol yana sisiya siwaiyaneni, na Bada Yesu waghawaghane ibabataitodi. ");
INSERT INTO aui_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Wasina bi Pol imana gayamidiye itoura, na Kanuma Kabikabikuwayina ivibonuvidi, da gamo wiibatama sidagu siyisisiya bi siyawonawonakasiyaragha. ");
INSERT INTO aui_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bi nama na tomotomogha tupadi yadi 12. ");
INSERT INTO aui_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bi nawaravi aroba kamodiye, na Pol raghani nonowa iyanono kabepepa barene iyarughurughu bi ere mayitorana iyiisisiya wawaya biiyadi. Bi toudi yawata God yana Wiibadana siyadimedimeni. ");
INSERT INTO aui_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bi gegha da mududi nuwanuwadi sikotakii da gesiyitumaghana, na debae wawaya biiyadi Yesu yana Keda siyawonawona wiiberoveni. Na touna kiiravine Pol ikuyovedi bi wiigeruwana damdi irutayinidi da yawata sinagho bare tane, touna na Tairanas yana wiiyeveveyana barena, bi raghani nonowa na noko barene God yana wiibadana kiiravine siyiidimeyaneni. ");
INSERT INTO aui_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol noko naboni iyaberabera da bodu bata sikovi, na wawaya tupadi, Jius bi kate kubuna damdi Eisiya kubure makamakedi Bada wonana siwaiyaneni. ");
INSERT INTO aui_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bi God yana maragate na Pol berakayowiiwiiyaka ghamaghamadi iyaberabera, ");
INSERT INTO aui_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","na raghanina agesi bo eipron mekodi Pol sinina sikasitowoyi bi sakawara sanagho wawaya gubagubagidi debadiye satoura na kadi gubaga sayawa bi kanuma beroberodi sakanibutaveyana. ");
INSERT INTO aui_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bi Jius mududi iiyawogha siyapeepewa kubura bi kubura, kanuma beroberodi wawaya gwabidima siyarurukwavina siyakanikanibu, na bada siberatowayi da Bada Yesu waghawaghane mmko siyabera. Na damdi sigeghomiiri da kanuma beroberodi siwonedi bo, “Yesu waghawaghane, iiyabo kiiravine Pol iyadimadima na, awonaghakiyem da mmko wawayina gwabinama kanibutaveyana.” ");
INSERT INTO aui_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bi Jius yadi prist kiikiiwawona tana kana waghawagha Skeva natunatuna yadi 7 na bada mmko berana siyaberabera. ");
INSERT INTO aui_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bi gegha da raghani tana siberatowoyi, na kanuma berona iwonedi bo, “Yesu na akovi da kate Pol na bada akovi, bi tami - tami iiyawogha?” ");
INSERT INTO aui_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wasina bi tomogha kanuma berona gwabine na igogona kuridi da igeiwayidi. Bi irouvidi da ivirouberowanedi na ighanidigha barema sivera sikanibutaveyana ere ganiganidi. ");
INSERT INTO aui_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bi raghanina Jius da kubuna damdi wiiwiitumaghanidi, Epesis kwanatuna kamone makamakedi mmko sisiyina siwaiyaneni, na sinaghara kirakii da Bada Yesu kana waghawaghana parapa sikabikuwayena kirakiiyeni. ");
INSERT INTO aui_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wasina bi wiigeruwana damdi korotodi sinagho da wiigeruwana turaturadi naghodiye yadi berona siyimaghamaghatara. ");
INSERT INTO aui_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bi wawaya imimapudi korotodi yadi buka mekodi sawonedi da metagha sinikiirapu bo sinayapune na wawaya korotodi naghodiye sivitaghoma bi sigibu. Bi memeda mmkodi buka siyigimona, na miisanina augunai da iyaragata kirakii silva pinipinimidi 50,000 rubana. ");
INSERT INTO aui_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mmkodi bera maragasidiye na yaininagha Bada warana miisena kubura tupana ikabimumu, na wawaya korotodi sivitumaghana. ");
INSERT INTO aui_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nokodi bera situbugha murine, na Pol inuwagiura bi noghota ikabi da Masedoniya da Akaiya kuburidigha iyapepewa rughuwonedi da wiigeruwana damdi iyarugenaredi da iyanagho Jerusalemma. Na wiigeruwana damdi iwonedi bo, “Dagudagune na ananagho Jerusalemma, bi muriye na ananagho Roumma.” ");
INSERT INTO aui_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Na kana wiiwiiteyana yadi bata, Timoti da Irastas iviporadi sinagho Masedoniyama, bi touna wosina na nama Eisiya kubure imakae raghani gisina. ");
INSERT INTO aui_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Bi noko raghanine Yesu yana Keda kiiravine nuwapoya ghamana Epesis kwanatuna kamone itubugha. ");
INSERT INTO aui_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Bi nuwapoyina kayena na tomogha tana gwabinama itubugha, kana waghawagha Demetriyas, touna yana bagibagi na silvama sawara bogaebogae iyaberabera. Bi Grik damdi na ere yadi god wasikena kana waghawagha Atemis na Demetriyas, Atemis yana kabepepa barena gubadi gisigisidi iyaberabera na wawaya siyagimogimona. Bi yana bagibagi wawayidi tupadi mmkodi siyaberabera da mane ghamana siyakabikabi. ");
INSERT INTO aui_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Na noko biidi yana bagibagi damdi tupadi da kate turaturadi iiyawogha teya bagibagina mayimayiyina siyaberabera na ikwatuwiitaghomidi bi iwonedi bo, “Yagu wawaya, tami kwakovi da touda mmko bagibaginama na mane ghamana tayakabikabi. ");
INSERT INTO aui_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Bi katana tamimani kokitakita bi kowaiwaiyana da metagha mmko tomoyina, Pol yaberabera mma Epesis kwanatune bi kate bada Eisiya kuburina tupane. Touna wawaya korotodi yadi noghota yataitainawamira da Atemis kabepepina samiimiiri kubuteni. Bi yawonawona da, ‘God wawaya imadima saberana toudi gegha god waghata.’ ");
INSERT INTO aui_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na tana kita yapori da touda tarabiibiisaka berabera wawayida, gekada waghawagha inabero bo yada mane kedana inaguduna. Bi kate tanakita yapori da gegha yada god wasikena Atemis yana kabepepa barena sinabera da gebasunana, kiiravine wawaya tupadi Eisiya da kate kubura tupana kamone na Atemis sakabekabepepi na tanakita yapori da yana wiibada gesinatore yowoyenina.” ");
INSERT INTO aui_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bi raghanina noko korotona Demetriyas yana sisiya siwaiyaneni, na nuwanuwadi sipughu kirakii da rukwatu sidaguni siyawonawona bo, “Touda Epesis damda yada god wasikena Atemis kana waghawagha iragata kirakii!” ");
INSERT INTO aui_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wasina bi wawaya tupadi kwanatu kamone siwaiyanedi siyarurukwatu na toudi bada geere basuna bi sidagu siyarurukwatu wapawapa. Bi Gaiyas da Aristakas, toudi na Masedoniya damdi bi Pol yawata siyapeepewa patapata na sikabitawatawanidi da sitayina wiiveraverudi yawata sirughu sinagho kwanatu wiidughu gawarine. ");
INSERT INTO aui_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Na Pol ikayoveni da iyarughu, bi gegha da wiigeruwana damdi gesiyiwaghasineni da naboni iyabera. ");
INSERT INTO aui_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bi kate bada Eisiya kubura babadidi yawata, toudi na Pol turaturana, yana sisiya sidaru siwonena kirakiiyeni da gegha wiidughu gawarine iyarughuna. ");
INSERT INTO aui_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bi nama wiidughu gawarine, na koroto yadi noghota iruragharagha da siyarurukwatu wapawapa. Wawaya mududi sisiya tana siyawonewoneni, bi mududi na bada sisiya bogae siyawonewoneni, koroto muduna na sinegheneghedi da awaki kiiravine sivitaghomidi. ");
INSERT INTO aui_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wasina bi Jius damdi, tomogha tana, kana waghawagha Aleksanda sirubukiini ikanibu koroto naghodiye, bi wawaya mududi koroto kamodiye sirukwatu siwoneni da iyisisiya. Wasina bi Aleksanda imanama wawaya itapitawanidi da siyiraborabobo, bi koroto iyawonedi da Jius geyadibagibagi mmko piropirona kamone iyamakamakena. ");
INSERT INTO aui_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bi gegha raghanina koroto akowa sikabi da touna Jius tomogha, na sikarayewoveni siyarurukwatu da raghani iguri sisiyina tanagha siyawonewoneni bo, “Touda, Epesis damda yada god wasikena Atemis kana waghawagha na iragata kirakii!” ");
INSERT INTO aui_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wasina bi kwanatu badana tana ikawarawiipikadi bi iwonedi bo, “Epesis dammi, wawaya tupadi kubura debane sakovi da Atemis kana waghawagha iragata kirakii na touda Epesis damda na kana kabepepa barena da yana akima kabikabikuwayina abamama ibeku iyowogha na kadi koyakoyagha! ");
INSERT INTO aui_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Wawaya tupadi sakovi da wonawaghata, na touna kiiravine koyiraborabobo da gebera wapawapa koyaberana. ");
INSERT INTO aui_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tami mmkodi tomotomogha kopiikedi mabo, bi getana awaki kabepepa barene siyayapi bo yada god wasikena siyawona wiiberovenina. ");
INSERT INTO aui_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Memeda Demetriyas da yana bagibagi damdi iiyabo wiiwawuna sinakayoveni, na sinanagho wiitupawamiwamira barene, bi babada nama da toudi siniwiitedi. ");
INSERT INTO aui_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Bi memeda yami gwiini sawara mududi kiiravidiye, na kwanatu babadidi yadi dughu kamone konarughu, da kiiravidiye konisisiya da konirotomanidi. ");
INSERT INTO aui_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tagu kata awaki itubugha kiiravine na anaghanaghara, na tanakita yapori bi gegha na Roum babada siniwawuda sinawona da touda mmko kayoghakighakina taya berabera. Kiiravine mmko wiirouvina na geere basunana, bi memeda naboni sinanoghosi na touda gerubana wiirouvina yana basuna miisena tanaveredina.” ");
INSERT INTO aui_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wasina bi kwanatu badana mma naboni ivisisiya ikovi murine, na wawaya iviporadi dughu gawarina sikanibutaveni bi sikuyoveni sinagho. ");
INSERT INTO aui_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Raghanina noko bera ghakighakina Epesis kwanatune ikovi, na Pol wiigeruwana damdi ikwatu wiitaghomidi bi iwonawiiyoyowanedi murine, na ivikukuvedi bi itouya Masedoniyama. ");
INSERT INTO aui_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Masedoniya kuburidigha ipepewa rughuwona da wara miisedima wawaya iwonawiiyoyowanedi, patana da Gris kubure iverakanibu, ");
INSERT INTO aui_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","da name nawaravi aroba imakae. Bi raghanina iyakabukabununagha da wagagha iyanagho Siriya kubure na sisiya iwaiyana da Jius damdi siyigiugerogerora da siyakasunuyi. Noko biidi yana noghota iwamiri da Masedoniya kuburidigha bada iyaveramagha. ");
INSERT INTO aui_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tomotomogha viya Pol yawata sinagho, toudi na Pairus natuna Sopate, yana kubura na Bereya; Tesalonika tomotomogha yadi bata Aristakas da Sekundas, bi Debi tomogha Gaiyas; bi Timoti; da kate Eisiya tomotomogha yadi bata Taisikas da Toropimas. ");
INSERT INTO aui_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bi mmkodi tomotomogha wagagha sivinagho sinagho da Troas kwanatune siyakoyakoyayimii. ");
INSERT INTO aui_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wasina bi Koughanu porayina ikovi murine, na wagae kageru da Pilipai kwanatuna kakuyoveni, bi gabudara 5 murine na Troas kwanatune kaverakanibu da turaturamii yawata kavibanana, bi name taparoro tanagha toudi yawata kamakae. ");
INSERT INTO aui_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sande ravidiye na wiigeruwana damdi yawata kavitaghomimii da Bada yana kamkena kayakiyagima da kaya kam patapata, bi Pol wawaya biiyadi iyisisisya na idima wiikaru da pomkambasune, kiiravine raghani iyabori na iyatouya. ");
INSERT INTO aui_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bare gekirakiina kawiina yadi aroba bi tupayarayina tana kamone meme kayiidughu, na oil kibedi peyaridi nama siyakarakarata. ");
INSERT INTO aui_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tomogha tana yaragina kana waghawagha Eutikas kitawiiverana debane iyamakamake, bi raghanina Pol iyisisiya wiiguriguri na iyarurudune da nuwanuwana iwapa na kitawiiverama ibeku iyowogha dobodobove. Raghanina siyowogha da tubuyina siyarukabepi na touna nada irabobo. ");
INSERT INTO aui_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol bada iyowogha, da tomoyina debane ikenawiiguriguri da iyaghouni. Bi iwona bo, “Gekoni nuwapoyana, touna patana yawayawiina!” ");
INSERT INTO aui_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Wasina bi Pol iveramagha igae bare gekirakiina tupayarayine, bi bred ikiyagima bi ireregha da wiigeruwana damdi yawata sikam patapata, bi murine toudi biiyadi iyadimadima patana da raghani ibori na noko kuburina ikuyoveni. ");
INSERT INTO aui_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wiigeruwana damdi tomoyina yawayawiina sikabi sinagho bareye na tupadi sivinuwamiise. ");
INSERT INTO aui_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wasina bi Pol iwonemii na wagae kageru da kavinagho Asosma, basuna touna kayegha iyanono noko kuburine da name iyageru. ");
INSERT INTO aui_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Raghanina Asosne ibananimii, na wagae igeru bi kanagho Mitileni kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Raghani ibori na nama katouya kanagho Kiyos nuwane. Bi kanagho Semos nuwane, da yaminama na Miletas kwanatune kaverakanibu. ");
INSERT INTO aui_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol geyanawiina da gabudara viya Eisiya kubure makewiiguri na yana noghota iwamiri da gegha Epesis kwanatune iyarughu, kiiravine touna iyiyaininagha da memeda Jerusalemma iyaverakanibu bi muriye da Pentikos porayina gabudarina. ");
INSERT INTO aui_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Raghanina Miletas kwanatune na Pol sisiya iwonataveni wiigeruwana damdi kadi dogadogara Epesis kwanatune siyapiika da yawata siyisisiya. ");
INSERT INTO aui_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Raghanina siverakanibu na iwonedi bo, “Tami yagu makamake kwakovi da metagha raghanina kamomiye ayamakamakena, name ghuyoghuyone Eisiya kubure averakanibu na gabudarine da kata. ");
INSERT INTO aui_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kwakovi da metagha Jius damdi mududi sivigiugerogerora da siyiberogu da nuwapoya siyaveregu, bi gegha da atoreyowoyenamayegu da Bada abagibagiyeni, bi raghani mududiye na nokodi bagibagidima adou. ");
INSERT INTO aui_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bi tami kwakovi da raghanina God yana sisiya ayadimadima tami biiyadi, na geayanaghara bo ayimuritayina wiiwiitemi kiiravine. Tagu debae sisiya miisedi ayadimadima tami biiyadi bi kate yami baregha ayiyeveveyana. ");
INSERT INTO aui_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Bi wiisuwona sisiyina tanagha Jius da Grik damdi awonedi da yadi tamumu siyamiiri kubutedi bi siyamiiri karona God biidi da Yesu Keriso siyitumaghaneni. ");
INSERT INTO aui_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Bi katana mmko sisiyina kowaiyaneni; Kanuma Kabikabikuwayina ivitamariyegu na anono Jerusalemma. Bi geayakakovi da awaki name inatubugha tagu biidi, ");
INSERT INTO aui_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","bi gegha, tagu kwanatu nunudigha ayanono na nada Kanuma Kabikabikuwayina iyiikatayigu da kabikwarakwara anabanani bi biwa gawarina kamone sinatoregu. ");
INSERT INTO aui_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bi yagu yawa na geayinuwapoyeni, touna gebera ghamana yagu noghota kamone na. Wiisuwona bera ghamana na bagibagi meko Bada Yesu iveregu ayabera na awiiwiini da anadiwiikovini. Nokona wara miisena wawaya anawonedi, da God yana nuwamonika waratetena kiiravine. ");
INSERT INTO aui_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Tagu gwabimigha ayapeepewa na God yana wiibadana kiiravine ayadimadima, bi katana akovi da kata bi nabo inagho na mayiyigu gekonakita mayenina. ");
INSERT INTO aui_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Na tagu mmko gabudarine akarakararumaghatara tami biiyadi: memeda tami tana inasiwana, na getagu kaguwawu. ");
INSERT INTO aui_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Basuna God yana wiina kiiravine ayadimadima na getana awaki ayanuwatawanina. ");
INSERT INTO aui_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Na koboda mayemi da kate God yana wawaya, toudi na Kanuma Kabikabikuwayina tami imadebamiye itoredi da konakoyayidi. Kokoyagha yaporidi ware bodaboda wawayina sip yakoyakoyayidi na naboni. Toudi na God yana kwatuwana wawayidi tounamani ganiganinama igimonidi. ");
INSERT INTO aui_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Akovi da ananagho bi muriye na wiiyaba wiiyeveveyana wawayidi sinapiika kamomiye sinarughu da wawaya yadi wiitumaghana siniberodi, ware garagara daghasi yapiika sip yawodi kamodiye yarughu da yunughana naboni. ");
INSERT INTO aui_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bi kate bada tamimani kamomima, na wawaya mududi sisiya gewiisuwonidi siniyeveveyana da wiigeruwana damdi nuwanuwadi sinatainawamira, da yadi wiiyeveveyana beroberodi sinakivina. ");
INSERT INTO aui_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Noko biidi, kokita yapora! Konoghosi da tagu bodu aroba kamone, na gabudare da nubabasuve na ere matadogagu, bi tami tupami ayawonawona wiiyoyowanemi basuna avinuwapoyena kirakiiyemi. ");
INSERT INTO aui_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Bi katana God imane atoretoremi, bi yana wiiwiita waratetena sisiyina tami biiyadi, na kovitumaghanena waghawaghasi. Memeda noko sisiyina konakivini na yami yawa inagogo wiimaragata, bi God wiimiiseyana inaveremi mekodi ivisuwona da yana wawaya waghata iyaveredina. ");
INSERT INTO aui_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Bi tagu, ayiimatipo da gemeyani wawaya yadi mane bo kadigara waratetedi ayakita kirorovedina. ");
INSERT INTO aui_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Tami wosina kwakovi da tagumani imaguma abagibagi da mane akabi, kam da sawara mududi kiiraviguve ayagimona bi kate bagibagi turaturagu teya kiiravidiye. ");
INSERT INTO aui_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Noko naboni abera, na tagu nonowa ayiyevevemi da metagha tana bagibagi wiimaragata bi mane tana kabi da wawaya moyamoyakidi taniwiitedi. Bada Yesu yana sisiya konoghosi iwona bo, ‘Awaki yabera da tiinuwamiise, na touna sawara tavereyana wawaya mududi biiyadi, bi genaboni sawara gwabidima tayounana.’” ");
INSERT INTO aui_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Raghanina Pol ivisisiya ikovi, na touna da Epesis dogadogara yawata sivituwapore oghogheyana bi God biidi sirupari. ");
INSERT INTO aui_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Bi yana sisiya kamone na iwonedi bo, “Tami gemuriye mayiyigu konakita mayeni,” na noko sisiyina kiiravine sivinuwapoya kirakii. Da tupadi siduu kirakii, bi Pol siyatarataraghuni da siyamaghamaghani. Wasina bi noko murine na sivitugwaagwari da sinagho wagae. ");
INSERT INTO aui_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Epesis wiigeruwana damdi kadi dogadogara kavikukuvedi ikovi murine, na wagae kageru bi rotomanina kanagho Kos nuwane da nubabasuve na name kakena. Bi raghani ibori na kanagho Rodes nuwane bi name na kanagho Patara kwanatune da wagama katarakapoka. ");
INSERT INTO aui_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Name na waga tana bada kabanani, iyatowatowawona Ponisiya kubure na kageru da katouya kanagho. ");
INSERT INTO aui_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bi kayaveravera da Saipras nuwana kakita banani, na wareregubugubura yana nawae kataveyana da kaveratupiireni, bi kakuka kanagho da Siriya kubura kamone, Taya kwanatune koghata da kana sawara iyiyowoyeni. ");
INSERT INTO aui_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nama katarakapoka da wiigeruwana damdi mududi kabananidi, na yawata kamakae da taparoro tana ikovi. Bi mmkodi wiigeruwana damdi, Kanuma Kabikabikuwayina yana maragate na siwonakasiyaragha da Pol geinanagho Jerusalemma. ");
INSERT INTO aui_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bi gegha, raghanina yama gabudara ikabi, na kayatouyamagha da kayanagho. Na wiigeruwana damdi tupadi, natuwavinedi da natunatudi teya kwanatu sikuyoveni bi yawata kayowogha kikire, wasina bi tupamii kavituwapore oghogheyana da karupari. ");
INSERT INTO aui_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Wasina bi rupari ikovi na kavikuku kabivivirana, murine na wagae kageru bi toudi siveramagha yadi bareye. ");
INSERT INTO aui_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wasina bi Taya kwanatuna kakanibutaveni kanagho Tolemayis kwanatune koghata. Wiigeruwana damdi nama kavikiikiivedi bi gabudara tanagha yawata kamakae. ");
INSERT INTO aui_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Raghani iborimagha na noko kuburina kakuyoveni bi kanagho Sisariyama, da name na abadimadima wawayina kana waghawagha Piripo yana bareye kamakae. Bi tomoyina na rorowainagha apasol, tomotomogha yadi 7 sivinegha na kamodiye tana da Jerusalem kamone kam kadireeregha. ");
INSERT INTO aui_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Touna natunatuna mamaragidi yadi 4, getana siyanayina bi kadipuyo na wonakasiyaragha. ");
INSERT INTO aui_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Gabudara viya sikovimurine, na peroveta tana kana waghawagha Agabas, touna bada kanapuyo wonakasiyaragha bi Jiudiya kuburama iyowogha Sisariyama. ");
INSERT INTO aui_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bi ipiika toumii biidi da Pol kanakikiru irupamataveni bi tounamani kayena da imana iyaghira bi iwona bo, “Kanuma Kabikabikuwayina mma naboni iwona, ‘Iiyabo mmko kikiruna yirapeneni, na Jius babada Jerusalem kamone kate mma naboni sinaghira tawatawani, bi kubuna damdi imadiye sinatore.’” ");
INSERT INTO aui_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Raghanina noko sisiyina kawaiyaneni na toumii da wiigeruwana damdi mududi nama Pol kawonena kirakiiyeni da geiyanagho Jerusalemmana. ");
INSERT INTO aui_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bi gegha Pol iwona bo, “Awaki kiiravine kodudu? Tami nuwanuwagu kwiibero! Tagu akabunagha da gegha Jerusalemne aghiratawatawanigu kawagha kiiravine, gegha! Akabunagha da Bada Yesu kana waghawagha kiiravine bada anarabobo.” ");
INSERT INTO aui_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Toumii gerubana da nuwanuwana kayatainawamiri, na kakabitoura bi kawona bo, “Karurupari da metagha Bada yawiiwiini na naboni inatubugha.” ");
INSERT INTO aui_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mmkodi bera murine, na kakabunagha da katouya kana nagho Jerusalemma. ");
INSERT INTO aui_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kivikivina mududi Sisariya kwanatune sivimataturanemii, da sikabimii kanagho Nason yana bareye da name kayamakae. Touna Saipras tomogha, bi ghuyoghuyone wawaya Wara Miisena siyiisisiyeni na raghanine Yesu kivinina idaguni. ");
INSERT INTO aui_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Raghanina Jerusalemne kavera kanibu, na wiigeruwana damdi nuwamiiseye siverabodemii da sivikiikiivemii. ");
INSERT INTO aui_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Raghani ibori na Pol yawata kanagho da Jemes kayakita, bi wiigeruwana damdi kadi dogadogara bada name. ");
INSERT INTO aui_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Na Pol ivikiikiivedi bi bera tupana mekodi tounae God ibera kubuna damdi kamodiye na iwonaveredi. ");
INSERT INTO aui_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Raghanina yana sisiya siwaiyana ikovi, na tupadi God sikabepepi bi siwona bo, “Waresimii, kuwaiyana; kwakovi da Jius damdi kamodiye na koroto ghamana nada Yesu sivitumaghaneni, bi God yana gwara sakivikivina yapori. ");
INSERT INTO aui_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bi siwaiyana da Jius damdi iiyawogha kubuna damdi yadi kubure samakamake na kuyiyevevedi da Mosis yana gwara siyasinighiiyeni. Na kuwonedi da natunatudi gegha siyisinibori bo Jius yadi kiki siyakivinana. ");
INSERT INTO aui_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Toudi akowa sinakabi da nada mabo kupiika, na awaki tana bera bi iniyeveveyana da mmkodi sisiya siyawaiwaiyana na gewiisuwona? ");
INSERT INTO aui_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Na awaki kanawonem na kubera; Tomotomogha yadi 4 mma gwabimiiye bi toudi wiiwaghasina maragasina God biidi sibera. ");
INSERT INTO aui_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Na toudi yawata konagho Bare Kabikabikuwayine da yami berona konakogha taveyana da God matane na tami miisemi. Bi yadi suwara kimiisana kiiravidiye, bi toudi gayamidi sinasabu tavetaveyana nokona inimatakira da awaki sivisuwona siyaberabera na sivikovini. Raghanina wawaya noko berana kunabera sinakita, na sinakovi da tam kam sisiya na gewiisuwona bi sinakovi da tam Mosis yana gwara kwakivikivini. ");
INSERT INTO aui_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Bi kubuna damdi wiiwiitumaghanidi kiiravidiye, iiyawogha Bada Yesu situmaghaneni na nada pepa kagirumi mma naboni kawonedi, ‘Wawaya iyuwa sasuwara tarabiibiisaka biidi na gesinakamna, ganigani gegha sinaniuni, ribiribi meko kanighona sakiyaviroyi bi ganiganina geiyororotaveyana na iyuvina gegha sinakanina, gegha wiimumuranama tamumu sinaberana.’” ");
INSERT INTO aui_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Raghani ibori na Pol nokodi tomotomogha ruwamaruwa ikabidi da yawata yadi berona sikoghataveyana da God matane na toudi miisedi. Wasina bi irughu Bare Kabikabikuwayina garina kamone sisiya itore da gabudara viya yadi berona sinakoghataveyana na inakovi. Noko na gabudara 7 sinakovi murine bi suwara sinabera da toudi tatadigegha kiiravidiye bi iniyeveveyana da yadi wiisuwona siyaberabera na sivikovini. ");
INSERT INTO aui_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","29","Wasina bi gabudara 7 damona ivitukabikabi, na Jius damdi viya yadi kubura na Eisiya, Bare Kabikabikuwayina garina kamone Pol sikita. Bi ghuyoghuyone na sikita da Epesis tomogha kana waghawagha Toropimas teya kwanatu kamone siyapeepewa, na sinoghosi da ikabiirughu Bare Kabikabikuwayina kamone. Na sigeghomiiri da koroto nuwanuwadi sipiro wiitavetavedi na Pol sikabitawatawani, bi siyarurukwatu bo, “Isrel dammi, koviwiitemii! Tomoyina mmakatanina, touna yana pepewa kamone na wawaya korotodi iyiyevevena berodi da touda Jius damda iyiaviyeda, bi wawaya iyawonewonedi da Mosis yana gwara gesiyakabisisirenina, da yada Bare Kabikabikuwayina iyisisiya beroveni. Bi kate bada kubuna damdi ikabidi sirughu gawara Kabikabikuwayine da God matane na ibera da idadabu!” ");
INSERT INTO aui_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Wawaya kwanatuve tupana siwaiyana da bera ghakighaki Bare Kabikabikuwayine, na nabo sivera sinagho da Pol sikabitawatawani bi sitayina kwarokwaro sikanibu maghatare bi yaininagha matamketana sigudu. ");
INSERT INTO aui_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Noko korotona Pol kasunuyina biidi siyimatipo, na sisiya inagho da Roum wiiyogha badana ghamana iwaiyana da Jerusalem damdi Bare Kabikabikuwayina kubune siyirouwa. ");
INSERT INTO aui_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Na yana wiiyogha tomotomogha da kadi babada irutayina, bi sivera sinagho noko gawarine. Raghanina noko korotona sikita bi iyo damdi da kate kadi bada ghamana yawata siyapiipiika na Pol gudana sikabitore. ");
INSERT INTO aui_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Wiiyogha badana ghamana ipiika Pol biidi da ikabitawani, bi yana wiiyogha tomotomogha iwonedi da sein yadi batama siyaghira tawatawani. Wasina bi koroto ivitarakiiyanedi bo, “Mmko awaki tomoyina? Bi awaki ibera?” ");
INSERT INTO aui_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wawaya mududi koroto kamone sisiya tana sakarataveni, bi mududi na bada sisiya bogae sakarataveni. Toudi sirukwatu kirakii da wiiyogha badana ghamana gerubana da awaki itubugha na basuna iyabanani, na yana iyo tomotomogha iwonedi da Pol siyakabi siyarughu barikiye. ");
INSERT INTO aui_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Raghanina Pol ipiika wiitupotupo bariki kedawagine, na koroto siyimatipo da siyakabitawani na iyo damdi sirukabepi bi sikawari. ");
INSERT INTO aui_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Koroto ghamana sikivinidi bi siyarurukwatu bo, “Kokasunuyi, kokasunuyi!” ");
INSERT INTO aui_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Raghanina Pol pinimina bi siyakabi siyarughu bariki kamone, na Grik gamoma wiiyogha badana iwoneni bo, “Rubana sisiya tana ayawonem?” Wiiyogha badana ikabinokeni na iwona bo, “Da Grik gamo kwakovi? ");
INSERT INTO aui_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tagu anoghosi da tam noko Ijipt tomoyina rorowainagha, ivimatipo da yama babada iyiaviyedi, na kedapepewa beroberodi yadi 4,000 ikabidi sikanibu sinagho mayabe. Tam noko tomoyina bo?” ");
INSERT INTO aui_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol iwonabodeyana bo, “Gegha, tagu na Jiu tomogha bi kwanatu ghamana Tasusne atubugha Silisiya kubure. Iibabiim, rubana da ayisisiya wawaya biiyadi.” ");
INSERT INTO aui_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Wiiyogha badana iviwaghasina, na Pol kedawage imiiri bi imanama wawaya itapitawanidi da siyiraborabobo. Raghanina siviraborabobo, na Hibru gamoma ivisisiya toudi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Iwona bo, “Warewaresigu da tamadam, kowaiyanegu! Bi kagu babara naghomiye anabera da getana awaki ayabera berona.” ");
INSERT INTO aui_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Raghanina koroto siwaiyana bi yadi gamo waghatama iyisisiya toudi biiyadi, na rukwatu sikabitore bi siviraborabobo. Wasina bi Pol iwonedi bo, ");
INSERT INTO aui_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Tagu na Jiu tomogha, Tasus kwanatune atubugha, Silisiya kubura kamone. Bi mma Jerusalem kwanatune aragata da agiruma Gamariel yana wiibadane. Nosidam yadi gwara da kiki kamodima iviyevevena yaporigu. Tagu akayovena kirakiiyeni da God ayakabisisirena yapori, ware tupami kata kokayokayovenina naboni. ");
INSERT INTO aui_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Na wawaya iiyawogha Yawa Kedana siyakivikivini, na avikayotaketowanedi da mududi sirabobo. Bi kawaguve na wawaya sigeghomiiri da wiigeruwana damdi, tomotomogha da wasiwasike siyapatupatumidi, bi biwa gawarina kamone siyatoretoredi. ");
INSERT INTO aui_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Prist kiikiiwawona da Wiigiugerogerora damdi na yagu bera sakovi bi sinawonemi da yagu sisiya na wiisuwona. Na wiiwaghasina pepana bada sigirumi warewaresidi biiyadi bi siveregu ayakawari ayanagho Damaskas kwanatune, na anagho nabo da wawaya iiyawogha Yawa Kedana siyakivikivini na ayapatumidi ayapiikedi mabo Jerusalemma da aro siyakabi.” ");
INSERT INTO aui_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Gabudara yubasune raghanina kedagha ayanono, nada Damaskas ayitutukabikabi na yaininagha yeghana ghamana abamama igweyura wiikenaviviregu. ");
INSERT INTO aui_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Da abeku ayowogha dobodobove bi gamo tana awaiyana iyawonewonegu bo, ‘Sol, Sol! Awaki biidi kwiikayotaketowanegu.’ ");
INSERT INTO aui_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Awonabodeyana bo, ‘Tam iiyabo, Bada?’ Bi iwonegu bo, ‘Tagu na Yesu, Nasaret tomogha iiyabo kwiikayotaketowaneguna.’ ");
INSERT INTO aui_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wawaya iiyawogha siyimataturanegu na bada yeghanina sikita bi gamo iyisisiya tagu biidi na gesiyawaiyanenina. ");
INSERT INTO aui_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Na avitarakiiyana bo, ‘Bada awaki anabera?’ Bi iwonegu bo, ‘Geghomiiri bi kunagho kunarughu Damaskas kwanatune, bi name wawaya sinawonem da awaki beradi akayokayoveni na kunabera.’ ");
INSERT INTO aui_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Yeghanina iragata kirakii da matagu ikaraboda na sawara gerubana ayakita, na turaturagu imagu sikabi bi sivinaghokedarigu karughu Damaskas kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tomogha kana waghawagha Ananaiyas name iyamakamake, bi God iyakabikabikuwayeni da yana gwara iyakabikabisisirena yaporidi. Bi Jius damdi tupadi noko kuburine na siyakabikabikarawayeni. ");
INSERT INTO aui_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Touna ipiika da imiiri gwabiyegu bi iwona bo, ‘Wareta Sol, kitamagha!’ Na noko raghanine matagu ikasigigiri da Ananaiyas akitani! ");
INSERT INTO aui_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Wasina bi iwonegu bo, ‘Nosinosidanakim yadi God ivineyim, bi ikayovem da yana noghota kunakovi, na yana Wiisuwona tamariyanina kukita, bi ivisisiya tam biidi da gamona kuwayaneni. ");
INSERT INTO aui_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tam na yana sawariyonayona, bi awaki kukita da kuwaiyana na kunimaghamaghatara wawaya tupadi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na gekunabodana, geghomiiri, da kunababataito. Raghanina kunarupari Bada biidi na yam tamumu inanoghotatavedi.’” ");
INSERT INTO aui_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Wasina bi averamagha Jerusalem kwanatune bi Bare Kabikabikuwayina garina kamone ayarurupari raghanine, na nuwanuwagu iwapewapeni na mimeu akita. ");
INSERT INTO aui_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Da Bada iyisisiya tagu biidi iwona bo, ‘Kabireso, Jerusalem kukuyovena yaiyaineni, basuna wawaya mma kate gegha yam sisiya tagu kiiraviguve sinawaiyanenina!’ ");
INSERT INTO aui_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Bi awonabodeyana bo, ‘Bada, sakovi da kabepepa baredi tupadi kamodiye nokodi iiyawogha siyigeruvem na ayarurouvidi, bi biwa kamone ayatoretoredi. ");
INSERT INTO aui_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Bi raghanina yam sawariyonayona Sitivin sikasunuyi na noko berana aviwaghasineni, na tagu nama ayamiimiiri bi iiyawogha siyakasukasunuyina kadi kwama wowodiye ayakoyakoyagha.’ ");
INSERT INTO aui_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bi gegha, Bada iwonegu bo, ‘Kunagho, Tagu iiporatavem rabarabae kubuna damdi biiyadi.’” ");
INSERT INTO aui_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Koroto tupana Pol iyisisiya na patana siyawaiwaiyaneni bi iwona da ware God iviporataveni inagho kubuna damdi biiyadi. Bi gegha, raghanina mmko sisiyina siwaiyaneni na nuwanuwadi sipughu kirakii da sidagu sinarukwatu bo, “Noko tomoyina kokasunuyi, touna gerubana da kubure inamakena!” ");
INSERT INTO aui_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Raghanina siyarurukwatu, da kadi tarasowoma siyarurutapitapi bi popoku siyirupiitaveni iyageege kiidamove, ");
INSERT INTO aui_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","na Roum wiiyogha badana yana iyo tomotomogha iwonedi da Pol siyarutayini siyanagho yadi bare garina kamone. Bi iwonedi da siyawakiwakiri bi siyitupawamiwamireni da awaki kiiravine Jius nuwanuwadi sipughu touna biidi da siyarurukwatu. ");
INSERT INTO aui_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bi sikutawatawani da siyawakiwakiri na raghanine Pol, wiirouwa badana nama iyamiimiiri na iwoneni bo, “Roum gwara kogeegeeiwayi da tami, tagu Roum wawaya bi konawakira wapawapagu. Tami dagudagune koyitupawamiwamiregu bi memeda koyabanani da berona abera, na noko murine na koyawakiwakirigu!” ");
INSERT INTO aui_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Raghanina wiirouwa badana, Pol yana sisiya iwaiyaneni na inagho yana bada ghamana iwoneni bo, “Awaki kunabera? Mmko tomoyina na Roum wawaya.” ");
INSERT INTO aui_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Na wiiyogha badana ghamana inagho Pol biidi da ivitarakiiyaneni bo, “Kuwonegu, wiisuwona da tam Roum tomogha?” Na Pol iwona bo, “Eee, tabo naboni.” ");
INSERT INTO aui_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Wasina bi wiiyogha badana ghamana Pol iwoneni bo, “Tagu mane ghamana avimiisana da kata tagu Roum wawaya!” Bi Pol iwona bo, “Tagu atubugha da Roum tubutubugha.” ");
INSERT INTO aui_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yaininagha nokodi iyo damdi iiyawogha pinimina bi Pol siyitupawamiwamireni na sinaghara sivimuritayina. Bi wiiyogha badana ghamana bada raghanina ikabibanani da Pol na Roum tomogha bi gamone na saghiratawatawani kiiravine na inaghara kirakii. ");
INSERT INTO aui_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Raghani ibori na wiiyogha badana ghamana yana kayowana iyakowa yapori da awaki basuna Jius damdi Pol siyiwawu, noko biidi na biwa gawarinama ivikanibuveni bi sisiya iwonataveni prist babadidi da Wiigiugerogerora damdi biiyadi da siyitaghomidi. Wasina bi wiiyogha badana ghamana, Pol irutayini ipiika da naghodiye ikabiwiimiiri. ");
INSERT INTO aui_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol, wiigiugerogerora babadidi ikita bogabogadi bi iwonedi bo, “Warewaresigu, nonowa yagu yawa na rotomanina God matane noko biidi nuwanuwagu na yeghanina patana da kata.” ");
INSERT INTO aui_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananaiyas touna prist kiikiiwawona raghanina mmko sisiyina iwaiyaneni na yaiyainagha nuwanuwana ipughu, da wawaya iiyawogha nama Pol ririne siyamiimiiri na iwonedi da kawana siyarouvi. ");
INSERT INTO aui_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Wasina bi Pol, Ananaiyas iwoneni bo, “Tam, God inarouvim, tam wiimiiribatabatam! Wawaya biiyadi na kam kita na miisena bi gegha, nuwanuwam kamone na idadabu kirakii. Tam nama kwamake bi yam kayowana da Mosis yana gwara kamonama kuyitupawamiwamiregu, bi gegha da tammani noko gwarana kwiikasigiiyeni bi wawaya kuwonedi da siyarouvigu!” ");
INSERT INTO aui_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bi iiyawogha nama Pol ririne siyamiimiiri na siwona bo, “Awaki biidi God yana prist kiikiiwawona kwiiwaghawagha beroveni?” ");
INSERT INTO aui_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol iwonabodedi bo, “Warewaresigu, tagu geayakovi da touna prist kiikiiwawona. God wonana giruma katamanine yawonawona bo, ‘Gegha yada Bada kuniwaghawagha berovenina.’” ");
INSERT INTO aui_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol iyakovi da Wiigiugerogerora damna kamone na mududi Sadusis bi mududi na Perisis. Na irukwatu iwonedi bo, “Warewaresigu, tagu na Perisi bi tamagunaki na bada Perisi. Tagu iigeruwana da God, wawaya raboboma inakabiwiigeghomiiridi da sinayawa magha, noko biidi na tami kwiitupawamiwamiregu!” ");
INSERT INTO aui_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Bi raghanina Pol naboni ivisisiya, na Perisis da Sadusis wiikawakereyana sidaguni da noko yadi wiitaghomina dughuna siyarayi da wawaya borudi bata situbugha. ");
INSERT INTO aui_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bi wiikawakereyanina yana basuna mma naboni da Sadusis gesiyitumaghana da God raborabobodi inakabiwiigeghomiiri mayedi, bi gesiyitumaghana da nama aneyaneya bo kanukanuma; bi gegha, Perisis na mmkodi bera tupadi siyitumaghanedi. ");
INSERT INTO aui_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wasina bi wiikawakereyanina iragata, da Perisis mududi toudi na gwara wiiyeeveyana damdi sigeghomiiri da siwonaghakighaki bo, “Mmko tomoyina getana awaki iyabera berona! Meboda kanuma bo aneya tana ivisisiya touna biidi!” ");
INSERT INTO aui_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Raghanina wiikawakereyanina iragata kamokamogha, na wiiyogha badana ghamana inaghara, kiiravine rubana da Pol siyataina miimiini, na yana iyo tomotomogha iwonedi da siyayowogha tupeyanama, wiigiugerogerora yadi dughu kamonama Pol siyataina kanibuveni bi siyanaveni yadi Barikiye. ");
INSERT INTO aui_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Noko nubabasune Bada ividebena mayeni Pol biidi da iwoneni bo, “Gegha kunanagharana! Tam, kiiraviguve mma Jerusalemne wawaya biiyadi kuyimaghamaghatara na kedana mayimayiyina Roum kwanatuna ghamane bada kiiraviguve wawaya kunawonedi.” ");
INSERT INTO aui_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Raghani ibori gabudara igae bi Jiu damdi mududi sivitaghomidi bi sivigiugerogerora da Pol siyiaviyeni, na wiisuwona maragasina sibera God biidi da gesiyakam bo siyaniuna patana da Pol siyadikasunuyi bi muriye na wasina. ");
INSERT INTO aui_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Tomotomogha 40 bo naboni siviwaghasina da mmko berana siyabera. ");
INSERT INTO aui_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Na sinagho prist babadidi da Jius dogadogara biiyadi bi siwonedi bo, “Toumii wiisuwona maragasina kabera God biidi da getana awaki kanakani patana da Pol kanadikasunuyi bi muriye. ");
INSERT INTO aui_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yama noghota mma naboni, tami da Wiigiugerogerora damdi tupami wiiyogha badana ghamana konibabiini da memeda Pol inakabi inayowogha tami biiyadi ware wiitupawamiwamira mayenina biidi da yana sisiya akovina koyakabiyapori. Toumii kedae kanikoyakoyagha da inapiipiika na kanakasunuyi.” ");
INSERT INTO aui_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bi gegha, Pol nughunaru natuna tomogha mmko noghosina sisiyina iwaiyaneni, na inagho iyo damdi yadi barikiye da Pol ivikatayi. ");
INSERT INTO aui_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wasina bi Pol wiirouwa badana tana ikwatuveni ipiika bi iwoneni bo, “Mmko tomogha gisigisina kabi kunagho yam wiiyogha badana ghamana biidi, da meboda sisiya ghamaghamadi inawoneni.” ");
INSERT INTO aui_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Na wiirouwa badana, tomoyina ikabi inagho wiiyogha badana ghamana biidi da iwona bo, “Biwa kabikabi tomoyina kana waghawagha Pol ikwatuvegu bi ivibabiigu da mmko tomogha gisigisina ayakabi ayapiika tam biidi basuna touna sisiya tana inawonem.” ");
INSERT INTO aui_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Wiiyogha badana ghamana, tomoyina imana ikabi da ikabireni bi ivitarakiiyaneni bo, “Awaki sisiyina kunawonegu?” ");
INSERT INTO aui_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na tomogha gisigisina iwona bo, “Jius damdi siviwaghasina bi sinibabiim da maram Pol kunakabi kunayowogha Wiigiugerogerora damdi naghodiye, bi siniyaba da ware sisiya waghata gwabinama kabiyaporina biidi. ");
INSERT INTO aui_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bi gegha kunawaiyanedina, basuna tomotomogha yadi 40 kanaboda sinakeneni bi sinikoyakoyagha da sinkasunuyi. Toudi wiisuwona maragasina sibera bi siviwaghasina da gesinakam bo sinaniuna patana da Pol sinakasunuyi na wasina. Katota na toudi sikabunagha, bi tam sabodabodam da yadi wiibaba kuniwaghasineni bo gegha.” ");
INSERT INTO aui_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Na wiiyogha badana ghamana, tomogha gisigisina iwoneni bo, “Kitaboga da mmko sisiyina getana iiyabo kunimaghamaghatareni da tam kuwonegu.” ");
INSERT INTO aui_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Wasina bi wiiyogha badana ghamana, yana wiiruwa babadidi yadi bata ikwatuvedi sipiika bi iwonedi bo, “Seri tomotomoyidi yadi 200 bi hosi kadiwiiyogha tomotomoyidi yadi 70 da kate bada iyo tomotomoyidi yadi 200 kokabidi. Bi kokabunagha da 9 o'klok kata pome konanagho Sisariya kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bi kate bada hosi mududi kokabunagha da Pol inageru bi konakoyaghayapori da konakabi konanagho gavena Pirikis biidi.” ");
INSERT INTO aui_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Bi wiiyogha badana ghamana pepa mma naboni igirumi: ");
INSERT INTO aui_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Tagu, Klodiyas Lisiyas agirugiruma tam wawaya ghamam, gavena Pirikis biidi. Kiiwa kiiwa. ");
INSERT INTO aui_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mmko tomoyina, na Pol bi Jius damdi sikabitawatawani da pinimina bi siyakasunuyi, bi wawaya tana iwonegu da touna Roum tubutubugha na yagu iyo tomotomogha teya kanagho da kaviyawiini. ");
INSERT INTO aui_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yagu kayowana basuna ayakovi da awaki iberabero na siyiwawu, noko biidi arutayini anagho yadi Wiigiugerogerora damdi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bi akabibanani da yadi wiiwawu sisiyidi touna biidi na getana awaki da toudi wosina yadi gwara kiiravine, bi getana yana berona da ayirabobo bo biwa gawarina kamone ayatore. ");
INSERT INTO aui_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bi gegha, raghanina wawaya siwonegu da Jius damdi siyiiritutura da Pol siyakasunuyi, na yaiyainagha adaruni tam biidi. Bi bada wawaya iiyawogha siyiwawu na awonedi da yadi wiiwawu siyiaviyeni na sisiyidi tam naghomve sinabera.” ");
INSERT INTO aui_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Na iyo damdi metagha wiiyogha badana ghamana iwonedi, na naboni sibera. Noko nubabasune Pol sikabi bi sitouya siyaveravera da Entipetris kwanatune siverakanibu. ");
INSERT INTO aui_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Raghani ibori na seri tomotomogha da iyo tomotomogha siveramagha yadi bareye Jerusalemma, bi iyo tomotomogha hosi debadiye gerugerudi toudi kawagha Pol sikabi sinagho Sisariya kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Raghanina Sisariya kwanatune siverakanibu, na pepana bada ghamana kiikiiwawona sivereni, bi kate imane Pol sitore. ");
INSERT INTO aui_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Wasina bi bada ghamana pepana ikabiyavi ikovi murine na Pol ivitarakiiyaneni da touna mema wawaya. Pol iwona bo, “Tagu yagu kubura Silisiya.” Raghanina Pirikis, Pol yana sisiya iwaiyana ikovi, ");
INSERT INTO aui_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","na iwona bo, “Iiyawogha siwawum na sinapiika mabo bi muriye na anitupawamiwamirem.” Wasina bi yana iyo tomotomogha mududi iwonedi da Pol siyakabi bi kiiwawo Herod yana bare wiinuwakayowanine biwa gawarine siyatore bi siyakighu yapori. ");
INSERT INTO aui_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Gabudara 5, sikovi murine, na Ananaiyas touna prist kiikiiwawona da Jius dogadogara mududi Jerusalemma siyowogha sinagho Sisariyama. Tomogha kana waghawagha Tetulas sirutayini. Touna Roum yadi gwara iyakowa kirakiiyeni. Toudi sinagho da kiiwawo naghone simiiri bi yadi wiiwawu sisiyidima Pol siyiaviyeni. ");
INSERT INTO aui_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Raghanina Pol sikwatuveni irughu, na Tetulas igeghomiiri da wiiwawu sisiyidima Pol siyiaviyeni na toudima Pirikis iwoneni bo, “Wawaya ghamam! Tam parapa bada waratetem da noghota miisedi gwabimve na toumii raghani gurina nuwaruririye kamakae da kate sawara miisedi peyaridi mmko kuburine situbugha. ");
INSERT INTO aui_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mmkodi bera kiiravine, na kubura tupane raghani nonowa kiiyayem. ");
INSERT INTO aui_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bi geayakayokayoveni da anisinighiimna bi tagu yaguwiina da yama sisiya tupokawanagha kunawaiyaneni. ");
INSERT INTO aui_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Toumii kabanani da mmko tomoyina Pol touna kerere wiitubutubgha wawayina, bi kubura tupane touna beraghakighaki Jius damdi kamodiye yitubutubugha. Bi bada wawaya boruna sakwatuveni Nasarin kadi bada ghamana. ");
INSERT INTO aui_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Bi kate ivimatipo da Bare Kabikabikuwayina iyituwiidadabu, na kapatumi. ");
INSERT INTO aui_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Raghanina tammani mmko tomoyina kunitupawamiwamireni, na kunakabibanani da awaki wiiwawu sisiyidima kiiaviyeni na wiisuwona.” ");
INSERT INTO aui_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Wasina bi Jius tupadi Tetulas murina sikousi da Pol siviaviyeni siwona bo, “Mmkodi sisiya tupadi na wiisuwona.” ");
INSERT INTO aui_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Wasina bi gavena Pirikis itupakoghata Pol biidi da iyisisiya, na Pol iwonabodeyana bo, “Bada ghamam Pirikis, akovi da bodu ipeyari tam na wiitupawamiwamira wawayim mmko kuburine, na noko kiiravine iinuwamiise kirakii da naghomve anamiiri da mmkodi wiiaviyegu sisiyidima kagu babara anakabi. ");
INSERT INTO aui_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Tammani wawaya kitarakiiyanedi da sinawonem bi tagu raviraviwota agae Jerusalemma kabepepa kiiravine, katana gabudara 12 sikovi. ");
INSERT INTO aui_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wiiwawu damdi getana siyabananigu da wawaya yawata Bare Kabikabikuwayine kayikawakereyana, bo siyabananigu da wawaya ayinuwapughupughudi, meboda kabepepa barediye bo gawara tana meme kwanatu kamone da nuwanuwadi siyapughu da siyirouwana. ");
INSERT INTO aui_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bi gerubana awaki sawaridi kiiravine kata siaviyegu na inimatakira da yadi wiiwawu sisiyidi na wiisuwona. ");
INSERT INTO aui_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Bi gegha da, wiisuwona tubumiinakim yadi God akabekabepepi bi tagu, na Bada yana Keda kana kivikivina. Jius damdi sanoghosi da mmko Kedana na wiiyaba, bi gegha da tagu sawara tupana gwara kamone Mosis da kate God yana peroperoveta sigiruma na iitumaghanedi ware Jius babada situmaghana na naboni. ");
INSERT INTO aui_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Tagu God iitumaghaneni ware toudi naboni da raghani tana kate rotomana wawayidi da tamumu wawayidi raboboma inakabiwiigeghomiiridi. ");
INSERT INTO aui_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Noko kiiravine, God matane bi wawaya matadiye na iimatipo da keda kayowiiwiiyake anamake da yagu yawa rotomanina bi nuwanuwagu yeghanine. ");
INSERT INTO aui_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Jerusalem nadawaghata bodu viya akuyoveni bi raviraviwota averamagha, da yagu wawaya moyamoyakidi yadi puyo ayaveredi bi kate Bare Kabikabikuwayine God biidi ayasuwara. ");
INSERT INTO aui_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tagu mmko naboni Bare Kabikabikuwayine ayaberabera na sibananigu. Tagu yagu berona akoghataveyana bi akabunaghamayegu da ayakabepepa, bi nama na getana da koroto tagu yawata da siyakabowiikurukuru. ");
INSERT INTO aui_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bi gegha, Jius damdi mududi Eisiya kuburama sipiika na nama. Toudi siyinagho mabo Siriyama siyapiika da awaki berona sikita ayaberabera na kata naghomve siyiwawugu. ");
INSERT INTO aui_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bo kadi babada mma siyawonem da yagu berona awaki sibanani, da Wiigiugerogerora damdi naghodiye ayamiimiiri bi siyitupawamiwamiregu raghanine. ");
INSERT INTO aui_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Memeda mmko sisiyina tanagha kiravine na siwawugu, raghanina Wiigiugerogerora damdi naghodiye ayamiimiiri na arukwatu awona bo, ‘Tagu iitumaghana da God, wawaya tupadi raboboma inakabiwiigeghomiiridi! Yana basuna touna kiravine na kata mma naghomve amiimiiri da kwiitupawamiwamiregu.’” ");
INSERT INTO aui_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Bi kiiwawo Pirikis rorowainagha Bada yana keda sisiyina iyakowa katamaneni kiiravine, na dughuna igudu bi iwonedi bo, “Raghanina wiiyogha badana ghamana Lisiyas inapiika mabo, na Pol yana sisiya anawaiyaneni da bera berona ibera bo gegha.” ");
INSERT INTO aui_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Bi kiiwawo Pirikis, wiirouwa badana tana iwoneni da Pol iyakoyagha yapori bi inakuyoveni da inapepewayawara bi kate turaturana sinarugenareni da yana wiina sinabera. ");
INSERT INTO aui_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Gabudara viya sikovi murine, na Pirikis wavinena Drusila, touna Jius wasike yawata siveramagha dughu gawarine. Bi wara sidaru na Pol ipiika toudi biiyadi, da Yesu Keriso wiitumaghanenina kiiravine ivisisiya na Pirikis iwaiyana. ");
INSERT INTO aui_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bi yana sisiya kamone iwonedi da God yawiiwiini yada yawa rotomanina kawakawa, bi kate metagha tana kabiwiipotepoteda bi berona getana bera da kate bada raghani damone metagha God, wawaya initupawamiwamiredi, na Pirikis inaghara kirakii na iwona bo, “Kabitore kunagho bi kate taraboga anabanani raghanine na anakwatuvena mayem.” ");
INSERT INTO aui_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Bi noko murine Pirikis raghani nonowa Pol yana sisiya iyadarudaru na iyapiipiika yawata siyiisisiya, basuna Pol na biwa gawarina kamone iyamakamake bi Pirikis yana wiina da Pol wiikowoe iyimiisaneni na iyakabitaveni. ");
INSERT INTO aui_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bodu bata sikovi murine na, Posiyas Pestas ivikiiwawo da Pirikis kana gawara ikabi. Pirikisi yana wiina da Jius babada iyinuwamiimiiseyedi kiiravine, na muridiye imiiri da Pol biwa gawarine ikabitorekuyoveni. ");
INSERT INTO aui_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Kiiwawo Pestas iverakanibu Sisariya kwanatune bi name imake da gabudara 3 sikovi, bi muriye na igae inagho Jerusalem Kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bi noko kuburine na prist kiikiiwawodi da Jius dogadogara, Pestas yawata sivitaghomidi bi Pol wiiwawu sisiyidima siviaviyeni. Bi kate sivibabiini, ");
INSERT INTO aui_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","da iyiwiitedi Pol iyawonataveni iyagae iyanagho Jerusalemma, basuna toudi wiikowoye siyigiugerogerora da kedae siyakasunuyi. ");
INSERT INTO aui_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Bi gegha, Pestas iwona bo, “Pol touna Sisariya kwanatune biwa gawarina kamone awonatawani yamakamake. Bi tagu geraghani gurina bi anaveramagha nabo. ");
INSERT INTO aui_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Na noko kiiravine yami babada viya yawata kana yowogha Sisariyama da noko kuburine, memeda Pol awaki sawarina ibera bero, na name konitupawamiwamireni.” ");
INSERT INTO aui_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestas, Jerusalem kwanatune imakae da gabudara 8 bo 10 sikovi murine, na iveramagha iyowogha Sisariyama. Bi raghani ibori, na wiitupawamiwamira gawarine imakeyowogha bi gamone na iyo tomotomogha Pol siyakabi siyapiika da naghodiye iyamiiri. ");
INSERT INTO aui_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Raghanina Pol iverakanibu, na Jius babada iiyawogha Jerusalemma siyowogha na simiiri gwagwari bi sidagu da wawu bogaebogaema siyiaviyeni, bi getana iiyabo rubana iyisisiya da yana wiiwawu sisiyidi na wiisuwona da Pol berona ibera. ");
INSERT INTO aui_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Wasina bi Pol igeghomiiri da kanababara ikabi iwona bo, “Tagu getana awaki berona ayabera da Jius gwara ayiaviyeni bo Bare Kabikabikuwayina da kate Roum yadi Sisa biidi!” ");
INSERT INTO aui_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Bi gegha da Pestas, Jius babada muridiye imiiri, na Pol ivitarakiiyaneni bo, “Da kwiiwaghasina bo gegha da tanagae Jerusalemma, bi name mmkodi wawudi kiiravidiye anitupawamiwamirem?” ");
INSERT INTO aui_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bi Pol iwona bo, “Gegha! Tagu na kiiwawo yana wiitupawamiwamira gawarine amiimiiri, na mmko gawarine kawagha koyitupawamiwamiregu. Tami kwakovi da getana awaki berona ayabera Jius damdi biiyadi. ");
INSERT INTO aui_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bi memeda bera berona ghamana ayabera na kagu aro na koyakasunuyigu, na tagu ayiwaghasina da koyakasunuyigu. Bi mmkodi tomotomogha awaki sisiyidima siaviyegu na gewonawaghata, noko kiiravine getana iiyabo yana maragata iyamakamake da Jius babada imadiye inatoreguna. Tagu akayokayoveni da Sisa naghone anamiiri da touna initupawamiwamiregu!” ");
INSERT INTO aui_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Wasina bi Pestas yana wawaya akakovidi ikwatuvedi da yawata sivisisiya ikovi, na Pestas iwonabodeni bo, “Tam yam kayowana da kunanagho Sisa biidi, na wasina kunanagho touna biidi.” ");
INSERT INTO aui_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Gabudara viya sikovi na kiiwawo Agripa nughunaru Benis yawata siverakanibu Sisariya kwanatune da kiiwawo wouna Pestas siyikiikiiveni. ");
INSERT INTO aui_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bi simakae da gabudara nama viya, na Pestas, Pol siyiwawu da siyiaviyeni na sisiyidi kiiwawo Agripa biidi ivimaghataridi iwona bo, “Pirikis mmko kuburina iyiibadeni na tomogha tana biwa gawarina kamone itore na patana yamakamake. ");
INSERT INTO aui_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Raghanina anagho Jerusalemma, na prist babadidi da Jius dogadogara wawu sisiyidima siviaviyeni na siwonegu da ayakasunuyi. ");
INSERT INTO aui_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Bi awonedi da toumii Roum dammii yama gwara yamakamake da wawaya gegha aro kana verewapawapana. Da dagudagune na kiiwawo naghone inamiiri, wiiwawu damdi yawata bi tounamani kanababara inakabi da inawonabodedi. ");
INSERT INTO aui_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Raghanina Jius babadidi yawata kayowogha mabo na geayikoyakoyaghana. Raghani ibori, na wiitupawamiwamira gawarine amakeyowogha bi yagu iyo tomotomogha awonedi da tomoyina siyarutayini siyapiika da naghoguve siyakabiwiimiirini. ");
INSERT INTO aui_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Raghanina wiiwawu damdi sigeghomiiri da yadi wiiwawu sisiyidi siyabera da siyiaviyeni, na anoghosi bo ware sinawonegu da tomoyina berabero kirakiina ibera. ");
INSERT INTO aui_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bi gegha, yadi wiikawakereyana na Jius damdi yadi wiitumaghana kiiravine da kate tomogha raborabobona kana waghawagha Yesu kiiravine. Pol yawonawona da touna wawayina na yawayawiina. ");
INSERT INTO aui_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tagu geayakovi da metagha sisiya waghata ayabanani, na avitarakiiyaneni memeda iyiwaghasina bo gegha da kayagae Jerusalemma bi name nokodi wiiwawu sisiyidi kiiravine na ayitupawamiwamireni. ");
INSERT INTO aui_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bi gegha Pol isinighii, yana kayowana da Sisa naghone iyamiiri da touna iyitupawamiwamireni. Na noko biidi iyo tomotomogha awonedi da Pol biwa gawarina kamone sitorerughuvena mayeni. Bi raghanina taraboga pinimina ayabanani na ayipora iyanagho Sisa biidi.” ");
INSERT INTO aui_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Wasina bi Agripa, Pestas iwoneni bo, “Yagu wiina da Mmko tomoyina yana sisiya tagumani anawaiyana.” Na Pestas iwona bo, “Wasina, maram yana sisiya kunawaiyana.” ");
INSERT INTO aui_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wasina bi raghani ibori, na kiiwawo Agripa da Benis kiikiiwawo kadi kwama siviyagha bi yawata na iyo tomotomogha da kwanatu kana babada ghamaghamadi ere gisugisumanidi, sideri sipiika sirughu dughu barena kamone. Bi Pestas gamone na yana iyo tomotomogha iwonedi na Pol sirutayini sirughu. ");
INSERT INTO aui_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Na Pestas iwona bo, “Kiiwawo Agripa da tami iiyawogha babada ghamaghamami kata mma toumii yawata, na mmko tomoyina kokita, mma naghodae yamiimiiri, na touna Jius damdi tupadi Jerusalem kamone da mma Sisariya kwanatuna kamone ere rurukwatudi sivibabiigu siwona da ayakasunuyi. ");
INSERT INTO aui_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bi akabibanani da getana awaki berona iyabera da ayakasunuyi, bi gegha tounamani yana wiina da Sisa naghone inamiiri, na noko kiiravine anipora inanagho Sisa yana kwanatu ghamane Roumma. ");
INSERT INTO aui_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bi tagu patana Pol kiiravine geayakakovi da metagha anagiruma inanagho kiiwawo biidi, na noko kiiravine akabi apiika tupami naghomiye bi tam kiiwawo Agripa yawata, tupada tanitupawamiwamireni bi muriye na sisiya waghata anakabi da anagiruma Sisa biidi. ");
INSERT INTO aui_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Geiyamiise da biwa kabikabi wawayina aniporawapawapa inanagho, da dagudagune na yana berona anadibanani bi muriye na kanasisiya teya aniporani inanagho Sisa biidi.” ");
INSERT INTO aui_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Wasina bi kiiwawo Agripa, Pol iwoneni bo, “Iiwaghasina da tammani kiiravimve kunisisiya da kambabara kunakabi.” Noko raghanine Pol imana irukabepi bi wiisisiya idaguni da tounamani kanababara mma naboni ikabi: ");
INSERT INTO aui_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","3","“Kiiwawo Agripa, toumii Jius dammi yamakiki tupadi tam kwakowa bi kate wiitarakiiyana mekodi kiikabowanedi na kiiravidiye, iinuwamiise da kata, kunawaiwaiyana bi Jius kadi babada siwona da awaki abera na tupadi kiiravidiye anawonabodeyana. Yana basuna noko kiiravine iipepeyana tam biidi da yagu sisiya kunawaiyana wiimasi. ");
INSERT INTO aui_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Jius damdi yagu yawa sakovi ikovi, raghanina dodoguve patana da kata. Sakovi da metagha yagu kubura waghate amakae bi kate bada muriye Jerusalem kwanatuna kamone. ");
INSERT INTO aui_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Toudi raghani gurina sakowa katamanegu, bi sinawonem da tagu Jius damdi yadi boru ghakighakina tana sakwatuveni Perisis kamone bi yadi bagibagi siradi tupadi ayakivikivina yaporidi. ");
INSERT INTO aui_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na kata sakayokayovem da kunitupawamiwamiregu, basuna tagu iitumaghana da God awaki nosidam ivisuwonedi na inabera. ");
INSERT INTO aui_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kama dam yadi 12 kamone na bada situmaghana da God awaki kiiravimiiye ivisuwonemii na inabera, toudi gabudara da nubabasu na kabikarawaye sakabekabepepi. Kiiwawo kabikabikarawayina, yana basuna noko kiiravine na mmkodi Jius babada tagu siwawuwapawapagu. ");
INSERT INTO aui_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Na tami awaki biidi konoghonoghosi da gerubarubana God, wawaya raborabobodi inakabiwiigeghomiiridina? ");
INSERT INTO aui_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Tagu rorowainagha anoghosi da bera tupana ayabera da noko Nasaret tomogha Yesu ayiaviyeni bi kana waghawagha ayibero. ");
INSERT INTO aui_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Dagudagune na Jerusalem kwanatune abera, prist babadidi name maragata siveregu na God yana wawaya korotodi biwa gawarine atorerughuvedi. Bi bada kiiravidiye aviwaghasina da siyikasunughana. ");
INSERT INTO aui_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Raghani ipeyari wawaya ayawonewonedi na kabepepa baredi nunudiye wiigeruwana damdi siyakwapukwapudi bi kate avimatipo ayaberadi da yadi wiitumaghana siyakabitoura. Bi kate yagu nuwapughu iragata toudi biiyadi, na ayanono kwanatu wiibatagha ayininoyedi da ayitupaketowanedi.” ");
INSERT INTO aui_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Raghani tana prist babadidi Jerusalem kwanatuna kamone maragata siveregu bi sidarugu ayanagho Damaskas kwanatune. ");
INSERT INTO aui_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kiiwawo Agripa! Noko raghanine kedagha ayanono da gabudara yubasune bi abama ikabinamari na yeghanina iyowogha da turaturagu yawata igweyuravivirimii. Yeghanina ivimaragata kirakii, gegha ware gabudara naboni. ");
INSERT INTO aui_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tupamii karirigha kayowogha dobodobove, bi wawaya tana gamona awaiyaneni Hibru gamoma iyisisiya tagu biidi bo, ‘Sol, Sol, awaki kiiravine kwiitupaketowanegu? Ipiropiro kirakii da tam kwiiaviyegu da gamogu gekuyawaiwaiyaneni, na tammani kwaburaburawa mayem.’ ");
INSERT INTO aui_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Bi avitarakiiyana bo, ‘Tam iiyabo, Bada?’ Na Bada iwonegu bo, ‘Tagu na Yesu, iiyabo kagu kivikivina kwiitupaketowanedina. ");
INSERT INTO aui_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Bi gegha, geghomiiri! Tagu avidebena mayegu tam biidi, bi avineyim da yagu wiitamariyana. Awaki kiiravine iiyevevem na wawaya kunawonedi, bi kate muriye raghanina anidebena mayegu tam biidi da awaki aniyevevem na kiiravine wawaya kunawonedi. ");
INSERT INTO aui_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","Tagu iiporam yam wawaya waghata biidi da kate bada kubuna damdi biiyadi. Kunagho matadi kunakimotatara da sinakowa, da bera berodima sinamiiriwamira bi sinapiika yeghane, Seitan yana maragatama sinakanibutaveyana bi sinapiika God biidi. Wasina bi yadi tamumu ananoghotataveyana bi aniwaghasinedi da toudi yagu wawaya kabikabikuwayidi, basuna toudi situmaghanegu kiiravine. Bi iiyawogha siniimatipo da kasunuyim biidi na gwabidima anitarababaranem.’” ");
INSERT INTO aui_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Na kiiwawo Agripa, mmko matakirina abamama iyowogha akita na akabisisireni, geayasinighiina. ");
INSERT INTO aui_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Wasina bi Damaskas kwanatune dima adaguni Jius damdi biiyadi bi muriye na Jerusalem kwanatune da Jiudiya kubura tupana kamone Jius damdi biiyadi bada adimakovi. Noko murine, na akanibu gegha Jius damdi biiyadi bada adima. Yagu dima kamone na awonedi da yadi bera beroberodi sinakabitoura bi yadi yawa sinakabiwamira God biidi. Da bera miisedi sinabera na toudi sinimatakira da wiisuwona yadi beraberodi sikabitoura. ");
INSERT INTO aui_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Bi mmko warana ayadimadima kiiravine na Jius damdi mududi sikabitawatawanigu, raghanina tagu Bare Kabikabikuwayina kamone bi sivimatipo da siyakasunuyigu. ");
INSERT INTO aui_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bi noko raghanine na God iyiiwiitegu, bi bada kata patana da yiwiitegu. Na mma amiimiiri da tupami, wawaya ghamaghamami da iyowogha inagho wawaya gisigisimi, awaki peroperoveta da Mosis siwona da iyatubughana toudi kawagha anawonemi. ");
INSERT INTO aui_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Toudi siwona da wawaya sinabera da Keriso inakabikwarakwara. Bi ininagho inarabobo bi bada inageghomiiri magha da wara miisena inadimeni da noko yeghana naboni yana wawaya waghata biiyadi da kate kubuna damdi biiyadi.” ");
INSERT INTO aui_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol noko raghanine mmkodi beradi iyisisiyedi da tounamani kanababara iyakabikabi, na Pestas irukwatu bo, “Pol tam kuneghanegha! Yam akowa ghamana iberam na kuneghanegha!” ");
INSERT INTO aui_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bi gegha Pol iwona bo, “Bada ghamam, Pestas, tagu gegha ayaneghaneghana! Gegha, awaki awonewonemi na wiisuwona bi wonawaghata! ");
INSERT INTO aui_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mmkodi bera iisisiyedi na gegha gawara kowoyidiye siyatubughana, na anoghonoghosi da Yesu yana kabikwarakwara, rabobo da geghomiirimagha na kiiwawo Agripa bera tupadi nada akovidi iyouna, noko biidi tagu kawadebae kiiravidiye anisisiya touna biidi.” ");
INSERT INTO aui_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Wasina bi Pol ivitarakiiyana bo, “Kiiwawo Agripa, peroperoveta awaki sigirumana kwiitumaghanedi bo gegha? Akovi da kwiitumaghaneni.” ");
INSERT INTO aui_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Na kiiwawo Agripa igeruwiirana iwona bo, “Da kwanoghonoghosi kwiisisiya, na katotawota nuwanuwagu kunatainawamiri da anikeresiyana bo?” ");
INSERT INTO aui_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bi Pol iwona bo, “Memeda inakabi da raghani tupona bo raghani gurina, noko getana awakina. Bi God biidi arurupari da tam bi kate iiyawogha mma tupami kata kowaiwaiyanegu, na kate Yesu konitumaghaneni naboni tagu, bi geyaguwiina konabera da biwa kabikabi wawayidi konapatadi ware tagu naboni.” ");
INSERT INTO aui_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Wasina bi kiiwawo Agripa da Gavena Pestas bi kate Benis da kate wawaya mududi tupadi sigeghomiiri, ");
INSERT INTO aui_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","bare sikanibutaveni maghatare. Bi toudimani kamodiye sivisisiya kabivivirana siwona bo, “Noko tomoyina getana yana berona awaki da biwa gawarina kamone siyatore bo siyakasunuyi.” ");
INSERT INTO aui_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Bi Agripa, Pestas iwoneni bo, “Noko tomoyina biwa gawarina kamonama tayikanibuveni iyanagho. Bi nada iwona da yanawiina Sisa naghone inamiiri da touna initupawamiwamireni. Noko biidi gerubarubana da tanikanibuvenina.” ");
INSERT INTO aui_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Raghanina touya gabudarina ikabi na Pestas inoghota da kaya touya Itali kubure, na biwa gawarina kana koyakoyagha badana, Pol da biwa kabikabi damdi mududi ivitowawonedi Roum iyo badana ghamana kana waghawagha Jiuliyas biidi. Jiuliyas na Sisa tounamani yana iyo wawayidi kadi bada ghamana. ");
INSERT INTO aui_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Bi Masedoniya tomogha kana waghawagha Aristakas, yana kwanatu Tesalonika na toumii yawata. Bi Adramitiyam damdi yadi wagae kageru. Noko wagana iyanono kwanatu tupadi kikire Eisiya kubura kamone. ");
INSERT INTO aui_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Raghani ibori na Saidon kwanatune kaverakanibu. Bi Jiuliyas na Pol biidi iviwawayamiise na ikayowiiyayeni da itarakapoka iyowogha inagho turaturana iyakitadi, da yana kayowana awaki na siyavereni. ");
INSERT INTO aui_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Muriye, na nama katouya kayanagho bi yanunu waga iyatapitapi bodebodeni kiiravine, na Saipras nuwana kaviruroguroguveni kanagho. ");
INSERT INTO aui_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Wasina bi Silisiya da Pampiliya kuburidi kikiridigha, bi yegii maghataragha kavera da Lisiya kubure Maira kwanatune koghata. ");
INSERT INTO aui_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Bi nama Aleksandriya damdi yadi waga tana iyanono Itali kubure na iyo tomotomogha kadibada ibanani, na noko wagane ivigerumii. ");
INSERT INTO aui_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Bi gabudara viya nuwatepamiiye kavera bi raghani iyawamiwamiri na ipiropiro kirakii da Nidus kwanatune kayaverakanibu yaininagha. Yanunu iragata da gerubana kayano kamogha na Krit nuwana kaviruroguroguveni kanagho da nuwa kana waghawagha Keip Salmon kaveratupiireni. ");
INSERT INTO aui_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Wasina bi miimiikidigha Krit nuwana kikirinagha kavera da kapiika kubura sakwatuveni Gud Habas, nokona Lasea kwanatuna riirine. ");
INSERT INTO aui_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Yama wagawaga ikabimii da raghani iguri da nada Wiiya Gabudarina ghamana ikovi bi touna raghanina yimatakira da yabarata bi yanunu kana gabudara iverakanibu nokona yegii yana wiireporepo gabudarina ikabi, na Pol, wawaya tupadi iwonawiiyoyowanedi ");
INSERT INTO aui_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","iwona bo, “Turaturagu, tagu anoghonoghosi da yada wagawaga mma da nabo inanagho na inabero kirakii: Waga kana sawara kouwana na taniwapewapeyana da wagana bada taniwapeni bi kate mududa tanarabobo.” ");
INSERT INTO aui_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bi gegha, iyo tomotomogha kadi bada, Pol yana sisiya geiyawaiyaneni da noko kuburine kayadimakae. Gegha! Touna waga badadidi yawata sivisisiya da siviwaghasina. ");
INSERT INTO aui_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Basuna noko kuburina na gegawara miisena da yanunu raghanidiye kowogha, na koroto muduna waga debane geyadikayowana da makewiiguri bi kayatouya magha kayimatipo da Krit nuwana kayakabi bi ririnagha kayagae kayanagho da Piniks kwanatuna kawasusune kayoghata bi yanunu kana gabudara tupana na name kayamakae. Piniks kwanatuna na kawasusu miisena Krit nuwana rogune na touna raghani nonowa nighorowa miisena yakenakena. ");
INSERT INTO aui_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Wasina bi noko raghanine wareregubugubura yananawama yanunu idagu iyiyamsibesibe, na waga damdi noko sikita, na sinoghosi da metagha siyanoghonoghota na rubana siyabera da Piniks kwanatuna kayakabi. Na waga kana anika sitayinageeyeni bi Krit nuwana kikirina ririwosinagha kagae, ");
INSERT INTO aui_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","bi gegha, kavera da gerabarabana bi bogibogi ghamana kana waghawagha Nortistar katiiyamiima iiuvenatatabi koyama iyowogha. ");
INSERT INTO aui_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yanunu ibero kirakii da waga iyarurouvi na gerubana waga naghona yanunu matane kayatore, na kavibaguneni bi waga kakasiviviri da yanunu iiuvenakwavinimii. ");
INSERT INTO aui_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Da nuwa gisina kana waghawagha Kauda nighorovinagha kanagho da kaveratupiireni, bi noko kamone kavibaga kirakii da waga kana wiitarawonawona wagana gisina katainageeyeni bi kaghiratawani da bagi. ");
INSERT INTO aui_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Waga damdi noko sibera ikovi na urawa siyouna da waga ghamana borinagha siviruviviredi bi saghiratawatawani da bagi. Noko murine, na sinaghara kirakii da yanunu waga, Siritis rurerene iyitavenageeyeni, kiiravine na waga kukana da uravidi sikabitavetaveyana da noko kedane waga yanavera sividouvi bi yanunu iyatapitapikwavini na iyaveravera. ");
INSERT INTO aui_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Raghani ibori na reporepo iyaruru kirakiiyemi kiiravine, na sidagu sawara, waga kamone siyitavena yowoyowoghana yegiiye. ");
INSERT INTO aui_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Bi gabudara wiiarobine na bada waga kukana, uravidi bi kiidi da kate awaki sawaridi debane siyamakamake na siyitavena yowoyowoghana. ");
INSERT INTO aui_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Raghani ibero kirakii na gabudara da kewokewo gekayakitatowogha bi kaverawapawapa da gabudara viya sikovi. Yanunu iragata kirakii da noghota tupadi sikovi da toumii kanarabobo. ");
INSERT INTO aui_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Noko raghani gurina murine nama waga debane wawaya gesiyakamtowoghana kiiravine, na Pol igeghomiiri da naghodiye imiiri bi iwonedi bo, “Kokita, tagu awonemi da Krit getayakuyovenina bi gegha da, yagu sisiya kowaiyanatawani. Noko kiiravine kata yami waga ivibero da yami sawara kovitavena yowoyowoghana. ");
INSERT INTO aui_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Bi kata awonewonemi da gekonanagharana. Waga kawagha inamonu bi getana iiyabo inarobobona. ");
INSERT INTO aui_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","God na yagu Bada bi taguna yana bagibagi wawayina bi nubabasuve yana aneya tana ipiika tagu biidi. ");
INSERT INTO aui_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Bi aneyina iwonegu bo, ‘Pol, gekunanagharana, tam Sisa naghone kunamiiri da initupawamiwamirem. Noko kiiravine God yam rupari iwaiyaneni na tam da wawaya tupadi iiyawogha waga debane na iniyawiimi.’ ");
INSERT INTO aui_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yagu wawaya, noko kiiravine yami noghota ivimaragata. Tagu, God iitumaghaneni da awaki iwonegu na inatubugha. ");
INSERT INTO aui_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Bi gegha da yanunu na inatapitapida da nuwa tana kikirine inakasibareda.” ");
INSERT INTO aui_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Taparoro bata sikovi nubabasune patana Mediteriyen Yegiine reporepo da yanunu iyatapitapi kwavinimii, da pomkambasune na waga damdi damidi sikabi da nada tepae kayageegee. ");
INSERT INTO aui_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Na touna kiiravine yegii yanawiiwautapu siruba da iyowogha awaki patana. Bi sikabibanani da yanayowogha 40 mitas naboni. Bi simakae raghani gisina bada siruba mayeni bi sikabibanani da yanayowogha 30 mitas naboni. ");
INSERT INTO aui_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Waga damdi sinaghara kirakii bi sinoghosi da reporepona waga siyiitavenageeyeni akima debadiye. Noko kiiravine anika yadi 4 waga murinama sivitavena yowoyowoghana da siyatainatawani. Bi sirupari da yadiwiina raghani iyabori yaiyainagha. ");
INSERT INTO aui_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wasina bi waga damdi sivimatipo da waga siyaverakuyoveni kiiravine, na wiitarawonawona wagana siruwiiyoyoyi iyowogha yegiiye, bi siviyaba da ware anika viya waga naghonama wiitavena yowoyowoghana biidi. ");
INSERT INTO aui_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Bi Pol, wiiyogha badana da iyo tomotomoyidi iwonedi bo, “Memeda waga damdi sinaverawiitaveda, na tami tupami konarabobo.” ");
INSERT INTO aui_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Noko biidi na iyo tomotomoyidi wiitarawonawona wagana uravidi mekodi sitayina tawatawani na sivikasiyaraghana da ikaruvenataveni. ");
INSERT INTO aui_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Raghani iyarurutorewosi na Pol, wawaya tupana iwonena kirakiiyedi da siyakam. Iwonedi bo, “Tami nuwanuwami irugawogawowori bi kovinuwapoya na getana awaki koyakam da taparoro bata sikovi. ");
INSERT INTO aui_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Tagu yaguwiina koyakam da koyimaragata. Kate getanarabobona. Kate getanakabi kwarakwara towoghana.” ");
INSERT INTO aui_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pol tupadi naghodiye ivisisiya ikovi na bred ikabi da God biidi ivikiikiiwa bi pinimina ikiyagima da kam idaguni. ");
INSERT INTO aui_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Na wawaya tupadi waga debane mmko sikita, na yadinoghota ivimaragata da tupadi bada yawata sikam. ");
INSERT INTO aui_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nama waga kamone na tupamii yama 276. ");
INSERT INTO aui_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bi tupadi sikamdona murine, na waga bagibagi damdi wit waga kamonama sivikanibuveni bi yegiiye siviyowoyeni da waga iyatekateka. ");
INSERT INTO aui_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Raghani ibori na waga damdi kubura sikita, na gesiyakitarutavenina. Bi gegha da kawasusu tana sikita ere kikirina, na sinoghota da siyimatipo bi memeda waga siyakawaraviviri siyaveruveni nabo da kikire iyitavenageeyeni. ");
INSERT INTO aui_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Noko biidi waga bagibagi damdi anika uravidi sivikasiyaraghana bi bada waga kana yabiyabi woena sirupami da siyawoe. Bi kuka gisina waga naghone sitayinageeyeni da yanunu iyatapi iyayowogha kikire. ");
INSERT INTO aui_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bi gegha, kavera gegurina bi rurereye kavitavenageeyemii. Da waga naghona ikarapasi yaiyainagha da geiyidaguna, bi reporepo ghamanakidi waga murina siyarurouvi na siyagawogawowori. ");
INSERT INTO aui_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bi iyo tomotomoyidi sivigiugerogerora da biwa kabikabi wawayidi tupadi siyikasunughana, basuna siyayeka siyayowogha kikire na kate bi siyakayovera. ");
INSERT INTO aui_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Bi wiiyogha badana geyanawiina da Pol siyakasunuyi, noko biidi na kadibabara ikabi na iyo tomotomoyidi iwonedi da gesiyikasunughana, bi gamone na iiyawogha yeka sakovi na siyikapoka yegiiye da siyarere kikire. ");
INSERT INTO aui_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Bi wawaya muduna wagae na yadi keda siyinogha waga kiidi sepisepidiye siyakabikikita bi siyayeka kikire. Wasina bi noko kedane na wawaya tupamii kayeka kikire kakabigae da kayawa. ");
INSERT INTO aui_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Wasina raghanina kikire kakabigae, na kakabibabani da nuwana na kana waghawagha Malta. ");
INSERT INTO aui_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bi wadubo damdi nama nuwae yadi nuwayuyuna iragata kirakii toumii biiyadi. Na amra idagu iyayoyo da duwa iragata na keyama sikiiri bi tupamii sivikiikiivemii. ");
INSERT INTO aui_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Wasina bi Pol kii gisigisidi ginabina ikabi da keyama debane iyatoura da siyakarata, bi kiidi kamodiye na mota berona nama bi raghanina keyama muyana damina ikabi na ikanibu da Pol imana irutarayi na iyarooroga. ");
INSERT INTO aui_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bi wadubo damdi nama nuwae sikita da mota berona Pol imane iyarooroga, na toudimani siwonena mayedi bo, “Meboda mmko tomoyina na kasukasunugha wawayina, bi waga imonu na yegiiye geiyaniudona, bi gegha, katana god kana waghawagha Jastis geyanakayowana da inamakena, inakasunuyi.” ");
INSERT INTO aui_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bi gegha, Pol mota ivirupiitaveni da keyama karakarasina debane, bi getana gubaga iyabananina. ");
INSERT INTO aui_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wadubo damdi nama sinoghosi da Pol imana iyaruruwa bo yaiyainagha iyabeku da iyarabobo. Bi sivikoyakoyagha kirakii, siyakitakita da awaki iyatubugha Pol biidi. Bi getana awaki iyatubugha, na yadi noghota siwamira bi siwona bo, “Pol na god tana.” ");
INSERT INTO aui_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kikire meme kakabigae bi gerabarabae na nuwa kana kiiwawo Pabiliyas yana kwabu ghamana da yana bare siyamakamake. Bi ipiika da nuwamiiseye irutayinimii da yana bareye bi ikoyagha yaporimii patana da gabudara aroba sikovi. ");
INSERT INTO aui_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Toumii gwabine kayamakamake, na akowa kakabi da tamananaki igubaga, sinina imuyamuya bi kamovera ikabi. Wasina bi Pol irughu tomoyina yana tupayarae da irupariyeni bi imana debane itoura na iyawa. ");
INSERT INTO aui_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Raghanina mmko berana itubugha na noko nuwana kamone wawaya gubagubagidi tupadi korotove sipiika Pol biidi da iviyawiidi. ");
INSERT INTO aui_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","11","Toumii, Malta damdi yawata kayamakamake da nawaravi aroba sikovi. Bi sikoyagha yaporimi da siviwiitena kirakiiyemii. Bi raghanina kayageru na wawaya sikabigunavemii da bada kama keda tamiina teya tupana siveremii bi waga tane kageru. Touna na Aleksandriya damdi yadi waga bi naghona na tarabiibiisaka bata wawayaruwa Kastor da Polux, toudi na yadi god na gubadi sitarakatukatugha. Wagana noko nuwane imiiri da duwa bi yanunu kana gabudara ikovi na kageru katouya. ");
INSERT INTO aui_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kakuka bi kageru kavera da Sairakas kwanatune koghata bi nama kamakae da gabudara aroba sikovi. ");
INSERT INTO aui_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Bi noko kuburinama kakuka kavera da Regiyam kwanatune, bi raghani ibori na yawara wareregubugubura yana nawama iyaveravera kiiravine, na katouya kaveraraghani da Puteori kwanatune koghata. ");
INSERT INTO aui_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Bi name wiigeruwana damdi viya kabananidi na siviyonemii nama yawata kayamakae da taparoro tanagha iyakovi. Wasina bi Roumma kaverakanibu. ");
INSERT INTO aui_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Bi wiigeruwana damdi waramii siwaiyaneni na viya sigae wiigimogimona gawarina kana waghawagha Apiyas bi viya sigae kubura kana waghawagha Kiiwaga Baredi Aroba. Da nokodi kuburidiye siyiikoyakoyagha da toumii siyaverabodemii. Bi raghanina Pol ikitadi, na ivikiikiivedi da yananoghota ivimaragata bi God ikabepepi. ");
INSERT INTO aui_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Raghanina Roum kwanatune kaverakanibu, na Roum babada siviwaghasina da Pol tanaduma inamakae. Na bare tana sivereni bi iyo tomoyina tanagha sitore da Pol iyaboda. ");
INSERT INTO aui_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Gabudara 3 sikovi murine, na Pol, iviyonayona da Jius wadubo kadi babada siyariyeni. Bi sipiika sivitaghomidi na Pol iwonedi bo, “Warewaresigu, tagu getana awaki berona ayabera yada wawaya biiyadi da kate nosidam yadi kiki siradi ayikasigiiyana. Bi gegha da Jerusalem kamone sipatumigu bi Roum damdi imadiye sitoregu. ");
INSERT INTO aui_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Roum babada sivitupawamiwamiregu bi sikabibanani da getana awaki berona ayabera da siyakasunuyigu, na sikayoveni da siyakabitavegu. ");
INSERT INTO aui_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Bi gegha, Jius damdi geyadiwiina da tagu siyakabitavegu, noko kiiravine Roum babada awonedi da tagu Sisa naghone ayamiiri da touna iyitupawamiwamiregu. Bi geyagu wawaya waghata wiiwawudi biidina. ");
INSERT INTO aui_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Mmkodi bera kiiravidiye na akwatuvemi kopiika ayakitami da yawata tayisisiya. Bi ayawonawiiakovimi da Isrel damda tupada tanitumaghana da God yana Wiivinevinegha Wawayina touda biiyadi inanokanibu da iniyawiida. Bi tagu iitumaghana da wawayina nada inokanibu. Noko kiiravine na imagu seinma saghiratawatawani.” ");
INSERT INTO aui_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bi siwonabodeni bo, “Toumii getana Jiudiya kuburama tam kiiravimve pepa kayakabi bo warewaresida mabo siyapiipiikana, waram siyimaghamaghataremii bo getana siyiwaghawagha berovemna. ");
INSERT INTO aui_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Toumii kakovi da wawaya kubura bogaebogae kamodiye korotodi na tami yami wiikeresiyana satoretoreyowoyeni, na noko kiiravine yamawiina da yam wiitumaghana kuyawonemii da kayawaiyana.” ");
INSERT INTO aui_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Na yadi gabudara tana sitore da Pol siyawaiyaneni. Noko gabudarine wawaya korotodi sipiika Pol yana bareye. Bi raghani diidibare Pol ividagu, da God yana wiikiiwawona kiiravine iviyeeveyana pomeni da inubabasu, bi Mosis yana gwara da peroperoveta yadi giruma debadiye ivitukikita iyiisisiya toudi biiyadi. Yana wiina da nuwanuwadi iyatainawamira da Yesu siyitumaghaneni. ");
INSERT INTO aui_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wawaya, Pol yana sisiya siwaiyaneni na viya nuwanuwadi siwamira da sivitumaghana bi viya na gegha. ");
INSERT INTO aui_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Touna kiiravine na toudimani kamodiye sivigamowana kabivivirana. Bi muriye da siyanagho na Pol yana sisiya tughurina itore toudi biiyadi, iwonedi bo, “Kanuma Kabikabikuwayina ivisisiya waghata nosinosiminakim biiyadi, peroveta Aisaiya yana giruma kamonama iwona bo, ");
INSERT INTO aui_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kunagho mmkodi wawaya biiyadi da kuwonedi bo, “Tami, God yana sisiya konawaiyana da konawaiyana, bi geakovidi konayunana. Tami konakita da God awaki beradi yaberabera na konakita, bi yadi basuna akovidi gekonayunana.” ");
INSERT INTO aui_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Basuna mmkodi damdi nuwanuwadi sikotakii, toudi gesiyakakowana. Ere tainadi, na awaki sawaiyaneni bi akovina gesiyakabikabina, ere matadi bi sigerebodaboda basuna geyadiwiina sinakitana. Kate bi, matadi sinakitarunagha da sinakita, bi tainadi sinatamobubu da sinawaiyana iisisiyana, nuwanuwadi sinayeghana bi akowa sinakabi, da yadi bera berodima sinamiiri kubuta bi sinamiiri karona tagu biidi da anakayowiiyawiidi teya.’” ");
INSERT INTO aui_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Bi Pol yana sisiya tughurina itore bo, “Tami, Jius dammi wonawaghata sisiyina gegha koyawaiwaiyanenina, noko biidi na awonawonawiiakovimi da God, Yawa makewaghawaghasina sisiyina iwonataveni kubuna damdi biiyadi. Da nokodi wawaya na sinawaiyana.” ");
INSERT INTO aui_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Wasina bi bodu bata kamone Pol, Roum kwanatune tanaduma yana maragate imakae. Bi wawaya iiyawogha siyapiipiika kighuna biidi, na tupadi iyiikiikiivedi. ");
INSERT INTO aui_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pol sinitorae bi nuwanuwana tupanama God yana wiikiiwawo kiiravine iyadimadima bi Bada Yesu Keriso kiiravine wara miisena iyiiyeeveyana. Bi getana iiyabo iyimatipo da iyigesiyeni. ");
ALTER TABLE aui_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
