﻿USE sofia;
DROP TABLE IF EXISTS sofia.aucNT_vpl;
CREATE TABLE aucNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aucNT_vpl WRITE;
INSERT INTO aucNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Në Ponguingä, ante dodäni näni në angaingä ïñömö Itota Codito ïnongä ingampa. Tömengä ïñömö Abadäö wodi pæ̈ingä në ingaingä inte Awënë Dabii wodi pæ̈ingä mönö ïnongä ingacäimpa. Tömengä wæ̈mæ̈idi ïïmaï ëmongadänimpa, ante yewæ̈monte ongompa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abadäö wodi wengä Itæca ëñagacäimpa. Ayæ̈ wææ̈ Itæca wodi wengä Aacobo ëñagacäimpa. Ayæ̈ wææ̈ Aacobo wodi wënäni Oodaa näni caipæ̈ ëñagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ayæ̈ wææ̈ Oodaa wodi Tämata ingante monte Pade tönö Dada ïnate tapæ̈igacäimpa. Ayæ̈ wææ̈ Pade wodi wengä Etedöö ëñagacäimpa. Ayæ̈ wææ̈ Etedöö wodi wengä Adäma ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ayæ̈ wææ̈ Adäma wodi wengä Ämïnadabo ëñagacäimpa. Ayæ̈ wææ̈ Ämïnadabo wodi wengä Näatöö ëñagacäimpa. Ayæ̈ wææ̈ Näatöö wodi wengä Tädämöö ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ayæ̈ wææ̈ Tädämöö wodi pæte Adacaba ingante möninque Boodo ingante tapæ̈igacäimpa. Ayæ̈ wææ̈ Boodo wodi pæte Odoto ingante monte Obedo ingante tapæ̈igacäimpa. Ayæ̈ wææ̈ Obedo wodi wengä Yæte ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ayæ̈ wææ̈ Yæte wodi wengä Dabii ëñate pædinque awënë odeye bagacäimpa. Ayæ̈ wææ̈ Dabii wodi pæte Odiya wodi nänöogængä ïningä ingante möninque Tadömöö ingante tapæ̈igacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ayæ̈ wææ̈ Tadömöö wodi wengä Doboäö ëñagacäimpa. Ayæ̈ wææ̈ Doboäö wodi wengä Abiya ëñagacäimpa. Ayæ̈ wææ̈ Abiya wodi wengä Ata ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ayæ̈ wææ̈ Ata wodi wengä Ootapato ëñagacäimpa. Ayæ̈ wææ̈ Ootapato wodi wengä Oodäö ëñagacäimpa. Ayæ̈ wææ̈ Oodäö wodi wengä Otiya ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ayæ̈ wææ̈ Otiya wodi wengä Ootäö ëñagacäimpa. Ayæ̈ wææ̈ Ootäö wodi wengä Acadæ ëñagacäimpa. Ayæ̈ wææ̈ Acadæ wodi wengä Etequiya ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ayæ̈ wææ̈ Etequiya wodi wengä Mänatee ëñagacäimpa. Ayæ̈ wææ̈ Mänatee wodi wengä Ämöö ëñagacäimpa. Ayæ̈ wææ̈ Ämöö wodi wengä Ootiya ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ïninque Ootiya wodi quëwengäñedë idægoidi ïnänite babidöniaidi ponte ö æ̈ gobæ wabæca mäodäni gogadänimpa. Ayæ̈ wææ̈ Babidöniabæ näni goyedë Ootiya wodi wënäni Eecöniya näni caipæ̈ ëñagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mänïï Babidöniabæ ö ænte godäni ate ayæ̈ wææ̈ Eecöniya wodi wengä Tadatiedo ëñagacäimpa. Ayæ̈ wææ̈ Tadatiedo wodi wengä Dodobabedo ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ayæ̈ wææ̈ Dodobabedo wodi wengä Abiodo ëñagacäimpa. Ayæ̈ wææ̈ Abiodo wodi wengä Ediaquïmö ëñagacäimpa. Ayæ̈ wææ̈ Ediaquïmö wodi wengä Atodo ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ayæ̈ wææ̈ Atodo wodi wengä Tadoco ëñagacäimpa. Ayæ̈ wææ̈ Tadoco wodi wengä Aquïï ëñagacäimpa. Ayæ̈ wææ̈ Aquïï wodi wengä Ediodo ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ayæ̈ wææ̈ Ediodo wodi wengä Edeadado ëñagacäimpa. Ayæ̈ wææ̈ Edeadado wodi wengä Mäatäö ëñagacäimpa. Ayæ̈ wææ̈ Mäatäö wodi wengä Aacobo ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ayæ̈ wææ̈ Ootee wodi ingante Aacobo tapæ̈igacäimpa. Ayæ̈ Ootee wodi ëñate pæte wææ̈ Itota badä inguingä ingante Mäadiya ingante mongacäimpa. Mäadiya ingante mongä ate tömengä wæætë Itota ingante mangacäimpa. Tömengä ïñömö Awënë bacæcäimpa, ante cædinque Wængonguï oguinguipæ̈ gao cæcä ate edæ, Codito, ante nänö në pemongaingä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mänömaï ï incæ Abadäö wodi pæ̈ïnäni wææ̈ nänömoidi wææ̈, önompo tipæmpoga wææ̈ mempoga go mempoga mänimpoga näni yebæ̈ñedë ate Abadäö wodi pæ̈ingä Dabii ëñagacäimpa. Ayæ̈ wææ̈ Awënë Dabii wodi pæ̈ïnäni wææ̈ nänömoidi wææ̈, önompo tipæmpoga wææ̈ mempoga go mempoga mänimpoga näni yebæ̈ñedë ate Oodeoidi ïnänite wabæca Babidöniabæ ænte gogadänimpa. Ayæ̈ Babidöniabæ ænte godäni ate tömënäni pæ̈ïnäni wææ̈ nänömoidi wææ̈, önompo tipæmpoga wææ̈ mempoga go mempoga mänimpoga näni yebæ̈ñedë ate mönö Codito nänö ponguinque ëñagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Itota Codito ïïmaï ëñagacäimpa. Wäänä Mäadiya wodi nänö baquecäñedë Ootee wodi tömengä ingante do, Monguïmo, angä ëñëningä inte ayæ̈ mönämaï ïñongante Wængonguï Tæiyæ̈ Waëmö Önöwoca angä ëñëninque do yædëmadä bacä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yædëmadä ingä adinque Ootee cöwë nö cædongä inte, Pïinte änäni wæcæ wæ, ante wædinque, Awëmö pango cæcæboimpa, ante pönengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ante önöwënenque pönëninque möwocodë wïïmöñongä Wængonguï tömengä anquedo ingante da pönongä pöninque anquedo ïñömö ïïmaï angantapa. “Ootee, Awënë Dabii pæ̈ïmi ïnömi inte bitö nänöogængä Mäadiya ingante guïñënämaï æncæbiimpa. Tömengä ïñömö Wængonguï Tæiyæ̈ Waëmö Önöwoca angä ëñente beyænque ënengä adinque bitö ïñömö tömengä ingante ee moncæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tömengä Wëñængä onguïñængä ingante mancæcäimpa. Mangä pæcä ate tömengä ïñömö, Botö guiidëmïni mïni wæquinque wënæ wënæ cæmïnipa, ante adinque botö æ̈mo beyænque quëwencæmïnimpa, ante cæcæcäimpa cæbii. Bitö tömengä ëmöwo ante, Në Ængä ïnongä ingampa, ante Itota pemoncæbiimpa,” ante anquedo Wængonguï nänö në da pönöningä ponte Ootee ingante angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ïninque Wængonguï beyæ̈ në apæ̈negaingä ïïmaï ante nänö yewæ̈mongaïnö baï ante ïinque batimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Baquecä incæ yædëmadä badinque Wëñængä onguïñængä ingante mancæcäimpa. Mangä ëñacä adinque tömengä ëmöwo, Ëmänoedo, ante godö pemoncædänimpa.” Ante näni yewæ̈mongaïnö baï cædinque tömengä ëmöwo, “Wængonguï mönö weca quëwengampa,” ante, Ëmänoedo, ante pemonte ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ootee mänïï wïïmonte ñäni ömæ̈mongä ate Wængonguï nänö da pönöningä anquedo nänö ämaï ëñente cædinque oncönë ænte gocä incæte guëa mönämaï ingadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Edæ bamoncadengä ëñacä ate, Itota, ante pemonte ate tömëna mänïñedë ate guëa mongadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Itota Bedëë näni quëwëñömö ëñacä ate mänïñedë edæ Edode Oodeabæ awënë odeye nänö ïñedë edæ në nö ëñënäni gobæ nænque tamönö quëwënäni inte Eedotadëë pongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ponte äninque, —Oodeo Awënë Odeye ïñömö ñöwocä ëñadingä ïñömö æyömönö owocää, ante ëñencæte ante wæmönipa. Edæ nænque tamönö quëwëñömöni Awënë nëmö ta ñongæ̈ adinque mönitö tömengä weca ædæ wææ̈ninque edæ, Bitö Wængonguï ïmidö anguënë, ante watapæ̈ apæ̈necæ pömöni ïmönipa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ayæ̈, Wacä Awënë Odeye ëñacampa, ante tededäni ëñente wædinque mänïömæ tömämæ awënë odeye Edode wæætë pïinte bayongä Eedotadëë quëwënäni tömänäni tömengä tönö godongämæ̈ guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ïninque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö Wængonguï nänö wææ angaïnö ante në odömönäni tönö tömänäni ïnänite Edode äñecä godongämæ̈ pönänitapa. Pönäni ate tömengä, Codito näni angaingä ïñömö æyömönö ëñaquingää, ante æbänö yewæ̈monte öñö amïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Äñongante, —Oodeabæ ïñömö Bedëë näni quëwëñömö mänïñömö ëñacæcäimpa, ante Wængonguï beyæ̈ në apæ̈necä incæ ïïmaï ante yewæ̈mongacäimpa, ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Oodabæ awënë gobedönadodoidi tæiyæ̈näni ïñönäni mïnitö adobæca Oodabæ quëwëninque Bedëë ïñömö mïni quëwencabo ïñömö mëa pönï ïmïni incæte edæ wïï önömïnique incæmïnimpa. Ïñæmpa Wëñængä adocanque ëñate pædinque në Awënë bate taodinque në aacä baï ïnongä inte botö guiidënäni idægoidi ïnänite aacæcäimpa.” Ante yewæ̈mongä amönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ante apæ̈nedäni ëñente wædinque Edode wæætë në nö ëñënäni ïnänite awëmö äñete pönäni ate, Nëmö æyedënö mä pönï tamö amïnitawo. Äñongante tömënäni, Mänïñedë tamö atamönipa, ante apæ̈nedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ëñëninque Edode ïñömö, —Mïnitö wæætë Bedëë ïñömö mäo në ëñadingä ingante diqui diqui minte aedäni. Tömengä ingante adinque wæætë adodö pöninque apæ̈nemïni ëñëmoedäni. Edæ mïnitö gote æbänö wëñæ̈ ingante apæ̈nemïni baï botö adobaï edæ gote ædæ wææ̈ninque edæ, Wængonguï Awënë ïmidö anguënë, ante watapæ̈ apæ̈necæte ante ämopa, ante Edode önonque ante pönëninque apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Angä ëñëninque nëmö në adïnäni ïñömö Bedëë taadö gote æ̈mö ayönäni edæ ado nëmö tömënäni nænque tamönö quëwëninque näni adïmö incæ wo go adinque edæ të wocæ̈ goyönänite nëmö Wëñæ̈ owoyömö oncömanca tæcædæca ïnö næ̈ gongæ̈ adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Adinque tömënäni edæ, Mönö acæ pönongä ïñömö ongongampa, ante pönëninque watapæ̈ togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mänïï näni adincönë go guiite ayönäni Wëñængä ïñömö wäänä Mäadiya tönö ongongä adinque tömënäni Wëñængä weca ædæ wææ̈ninque, Bitö Wængonguï Awënë ïmidö anguënë, ante watapæ̈ apæ̈nedänitapa. Ayæ̈ tömënäni näni ænte pönincoo wi æmpodinque oodo tönö oguï waa quï tönö tï nä öni pæquï tönö, Bitö quï impa, ante pædæ godönäni ængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Idæwaa adinque tömënäni möwocodë wïïmöñönänite wacä ponte apæ̈necantapa. Mïnitö awënë Edode weca ocæ̈ ëmænte godämaï ïedäni, angä ëñëninque tömënäni wæætë yaatænque godinque tömënäni ömæ wadæ gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Godäni ïninque edæ Ootee wïïmöñongä Wængonguï anquedo ingante da pönongä ponte apæ̈nedinque, “Edode do Wëñængä ingante wæ̈noncæte ante diqui mincæcäimpa cæbii. Ængæ̈ gantite Wëñængä näna badancaya ïnate ö ænte Equitobæ wodii goe. Ayæ̈ gote quëwëñömïni botö ämo ate pöedäni,” angä. ");
INSERT INTO aucNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ëñëninque Ootee tömengä nänö wïïmöönæ ayaönæ̈nëña incæ ængæ̈ gantidinque Wëñængä näna badancaya ïnate ö æ̈ninque edæ Equitobæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Godinque Ootee näni wencabo ïñömö Edode nänö wænguinganca quëwencæ gogadänimpa. Go quëwënäni ïninque mönö Awënë Wængonguï ïïmaï ante nänö apæ̈negaïnö ante ïinque batimpa. “Botö Wëñængä Equitobæ quëwëñongante äñebo pongantapa,” ante Wængonguï beyæ̈ në apæ̈necä nänö yewæ̈mongaïnö baï edæ do ïinque batimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Edode guiquënë, Nëmö në nö ëñënäni botö änïnö ante ëñënämaï inte dæ godänipa, ante adinque edæ ænguï bacantapa. Ænguï badinque tömengä, Wëñæ̈näni ïnänite mäo wæ̈nöedäni, angantapa. Äninque tömengä, Mëa wadepo ïñonte nëmö ta atamönipa, ante në ëñënäni näni änimpoga ante pönëninque, Mëa wadepo ëñadïnäni tönö ayæ̈ ëñadïnäni tönö Bedëë quëwënäni incæ Bedëë eyequeï quëwënäni incæ onguïñæ̈nänique ïnänite mäo wæ̈nöedäni, angantapa. Ïninque në wæ̈nönäni wæætë awënë nänö adïnänique ïnänite capo ado tedæ̈ wæ̈nönäni wængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wæ̈näni wædäni ïninque Wængonguï beyæ̈ në apæ̈negaingä Eedëmiya wodi ïïmaï ante nänö angaïnö baï edæ ïinque batimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nämaa näni quëwëñömö në Ca ca wæwënä nänä Ca ca wæpämo ëñënänitapa. Wäänä në Yæ yæ änönä inte, Daquedä ïñömö, Botö wëñæ̈näni, ante wædä ëñënänitapa. Dæ änäni pönente wædinque wäänä ædö cæte piyæ̈në cæquïnää,” ante Eedëmiya wodi yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ayæ̈ ate awënë Edode wængä ïninque Ootee ïñömö Equitobæ ayæ̈ quëwëninque wïïmöñongä Wængonguï anquedo ponte a ongöninque tömengä ingante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ootee ëñëmi. Wëñængä ingante wæ̈noncæ änönäni incæ dobæ wæ̈nänipa cæbii. Ængæ̈ gantite Wëñængä näna badancaya ïnate Idægobæ adodö ænte gocæbiimpa,” angä. ");
INSERT INTO aucNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ëñëninque Ootee ïñömö edæ ængæ̈ gantidinque näna badancaya ïnate Idægobæ adodö ænte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mänïñedë wæmpo Edode wængä ïninque, Wæætë tömengä wengä Adoquedao Oodeabæ awënë odeye bacantapa, ante tededäni ëñente wædinque Ootee ïñömö, Botö Oodeabæ ædö cæte wæætë goquïmoo, ante guïñente wæcantapa. Wæætë tömengä möwocodë wïïmöñongä wacä angä ëñëninque Oodeabæ wodo tebæ̈ godinque Gadideabæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Godinque Ootee näni wencabo Näatadeta ponte quëwënänitapa. Ïninque, Näatadënö ingampa, ante pemoncædänimpa, ante Wængonguï beyæ̈ në apæ̈negaingä nänö angaïnö baï cædinque wadäni ñöwo mönö Codito ingante, Näatadënö, ante pemonte baï apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mänïñedë Wäö mönö në æpæ̈në guidönongä inte Oodeabæ önömæca ponte apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ponte apæ̈nedinque tömengä, “Öönædë Awënë incæ inguipoga tömämæ Awënë Odeye bacæcäimpa cæmïnii. Mïnitö wënæ wënæ cædïnö ante, Ancaa wæwente awædö, ante ñimpo cæedäni,” ante Wäö apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mänömaïnö ante në apæ̈necä ingantedö ante Wængonguï beyæ̈ në apæ̈negaingä Itaiya wodi ïïmaï ante do yewæ̈mongacäimpa. “Önömæca ïñömö adocanque ogæ̈ tedete aa pecæcäimpa. ‘Awënë nänö ponguïnö ante mïnitö tee moncate baï cæedäni. Taadö töïnö pïnonte baï cædinque mïnitö wënæ wënæ mïni cædïnö ante edæ wido cæedäni,’ ante aa pecä ëñengæ̈impa,” ");
INSERT INTO aucNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ante Itaiya wodi nänö në angaingä inte Wäö ñöwo pongantapa. Tömengä weocoo ante cämeyo ocaguincoo nonte badonte wëñate mongæ̈ninque pacadeyænta ante æ̈montai badonte encadeyæ̈nongäimpa. Tömengä cænguï ante ñäwäique cæ̈ninque tömengä bequï ante guïñëmænque ade bete quëwënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Quëwëñongä, Eedotadëë quëwënäni tönö Oodeabæ tömäo quëwënäni tönö Oododänonga biyönæ tömäo quëwënäni tönö tömengä weca tate bee tëninque änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bitö ämaï näwangä wënæ wënæ cæte quëwëmöni inte wæmönipa, ante wædäni ëñëninque Wäö Oododänö æpæ̈në guidongä guiidänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ayæ̈ Paditeoidi tönö Tadoteoidi guiquënë Wäö nänö guidöñömö pönäni adinque tömengä ayæ̈ wæætë tömënäni ïnänite angantapa. “Tæntæ pæ̈ïmïni baï ïnömïni inte mïnitö ïñömö ëñënämaï cæte quëwëmïnipa. Oo pönï wæ̈nompadäni, ante æcänö wææ angä ëñëninque wodii wïnonte pömïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ïñæmpa Wængonguï Awënë gämæ̈nö mïnitö dicæ ocæ̈ ëmænte poncæ cæmïniyaa. Nö cæte pömïni ïninque mïnitö në ocæ̈ ëmænte pönäni näni waa cædö baï adobaï waa cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ayæ̈ nämä wææ äninque, ‘Mönitö adomönique docä Abadäö wodi pæ̈ïmöni inte möni quëwenguinque ïmönipa,’ ante mïni tedewënö ante pönënämaï inguënë quëwëmïnii. Ïñæmpa Wængonguï, Botö pæ̈ïnäni bacædänimpa, angä baï dicacoo incæ dobæ tömengä pæ̈ïnäni baï bacædönimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Edæ awæ̈ yecæte ante awænca näni mæ̈ yequinca eyewa pönï næ̈æ̈näni baï Wængonguï nänö panguinca næ̈ænte baï do edæ a ongongampa. Tömengä wainca ante a ongöñongä ömæcawæ̈ baï wïï pönente cædäni adinque awæncaca wægo yete godö gongapamö iya tante baï cæcæcäimpa, ante ämo ëñëmaïmïnipa.” ");
INSERT INTO aucNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ayæ̈, “Mïnitö wënæ wënæ mïni cædïnö ante wido cæcæmïnimpa, ante cædinque botö mïnitö ïmïnite æpæ̈në guidömo guiimïnipa. Incæte botö mänömaï cæbo ate wacä ayæ̈ poncæcäimpa. Tömengä ïñömö tæ̈ï ëmongä ëwocadongä ïñongante botö wæætë wædämo ïnömo inte tömengä awæncata incæ ædö cæte godö ænte næ̈æ̈maïmoo. Tömengä da pönongä pöninque Wængonguï Tæiyæ̈ Waëmö Önöwoca incæ pö guiidinque mïnitö mïmö mënongacæcäimpa. Ayæ̈ mïnitö wënæ wënæ cædïnö ante gonga tante baï tömengä cæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Waocä, Todigo tömëmö wati wati tæ̈nöninque botö tæ̈nönïñömö önömancaque baquinque botö apænte æ̈ninque waïña tömämö oncönë da wencæboimpa, ante timpodæ næ̈ænte wo æ̈æntodö wo æ̈æntodö cædinque ontapocoo wææ̈incoo wadæ ñëmænte wo ëwengampa. Waocä mänömaï wo ëwencæte ante timpodæ næ̈ængä baï mönö në Ponguingä ïñömö adobaï oo pönï apænte ancæcäimpa. Todigo waïñacooque oncönë da wente në mangä baï tömengä adobaï në waëmö ïnäni ïnänite apænte ængä ate tömënäni tömengä nempo guiicædänimpa. Wæætë wadæ ñëmænte wo ëwente baï cædinque tömengä në ontapocoo wææ̈incoo baï ïnäni ïnänite cöwë bæcoyömö iya tangä gonte wæcædänimpa,” ante Wäö apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wäö ayæ̈ apæ̈neyongä Itota ïñömö Gadideabæ quëwëninque, Wäö botö ïmote æpæ̈në guidongä guiicæboimpa, ante cædinque Oododänonga pongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ponte, Guidömi guiiboe, äñongante Wäö wæætë wææ äninque, —Botö waëmö ïmopa diyæ̈ bitö ïmite guidömo guiiquïmii. Bitö wæætë botö ïmote guidömi guiibo baï waa incædönimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ante wæyongante Itota wæætë, —Cöwë ee cæbi, ämopa. Wængonguï nänö änö ante tömänö ëñente nö cæmö inguënëmö ïmompa. Ante apæ̈necä ëñëninque Wäö Ao ante ee guidongä guiigacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Guiite æpæ̈ do tao gongænte æ̈mö ayongä ïñontobæ̈ öönæ incæ wëä godömonte bayö Wængonguï Önöwoca incæ equemö wææ̈ baï tömengäa wææ̈ pö guiicä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wææ̈ guiicä ayongä edæ öönædë ïnö apæ̈nedinque, “Mäningä ïñömö botö Wëñængä ïnongä inte botö në waadecä ingampa. Tömengä ingante adinque botö watapæ̈ tobopa,” ante öönædë ïnö apæ̈necä ëñengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ayæ̈ mänïñedë edæ, Itota ïñömö wënæ angä ëñente æbänö cæquingää, ante Wængonguï Önöwoca incæ Itota ingante önömæca mæ̈icä æigacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Æi quëwëninque tömengä wantæpiyæ̈ coadenta ëönæ mänimpoönæ itædë woyowotæ̈ cæ̈nämaï quëwëninque gue æ̈nente wægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gue æ̈nente wæyongä wënæ awënë, Wënæ wënæ cæe, ante në änewengä ïnongä inte Itota weca pöninque, —Bitö Wængonguï Wëmi ïmitawo. Näwangä ï ïninque dica incæ päö ämi ba cæ̈maïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Äñongante Itota ïñömö, —“Cænguinque cænte ædö cæte quëwenguïï. Wængonguï nänö apæ̈nedö tömäne ëñente cædinque waocä cænguï cænte baï quëwencæcäimpa.” Mänömaïnö ante Wængonguï beyæ̈ yewæ̈monte ongö apa änewëë, äninque Baa angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Wënæ awënë ayæ̈ Itota ingante Eedotadëë tæiyæ̈ waëmö näni quëwëñömö ænte mäocä gocantapa. Ayæ̈ Wængonguï oncö ñæ̈nænconga wæ̈nömënæca ænte mæ̈i gönongä næ̈ gongængantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Næ̈ gongæ̈ñongante wënæ awënë wæætë, —Bitö Wængonguï Wëmi ïmitawo. Näwangä ï ïninque bitö to wæibi ate dodäni ïïmaïnö ante näni yewæ̈mongaïnö baï ïinque ba abaimpa. “Bitö beyæ̈ ante cædinque Wængonguï tömengä anquedoidi ïnänite angä pöninque, tömënäni bitö ïmite wææ aate ïñæ̈ æmpodäni ate bitö dicaa tee tëwadämaï incæbiimpa,” ante yewæ̈monte ongompa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Äñongante Itota, —Ïñæmpa godömenque ante yewæ̈mongatimpa. “Bitö Awënë bitö Wængonguï ïñongante bitö wæætë edæ, ‘Ëñënämaï cæbo incæte mönö Awënë Wængonguï æbänö cæquingää,’ ante acæte ante cædämaï incæbiimpa,” ante adobaï wææ yewæ̈monte ongö apa änewëë, ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ayæ̈ wæætë wënæ awënë Itota ingante æibæ pönï onquiyaboga mæ̈icä æicantapa. Æi ongöñongä wënæ awënë ïñömö awënë odeye ömæcoo inguipoga tömäo ongöñömæcoo adoyömö a ongonte baï ado tedæ̈ odömöninque awënë odeyeidi waa pönï näni ëmönö adobaï odömongä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Itota ingante apæ̈nedinque wënæ awënë, —Bitö botö weca ædæ wææ̈ninque, Tatänabi bitö Wængonguï Awënë baï ïnömi ïmipa, ante watapæ̈ apæ̈nebi ëñëmoe. Mänömaïnö ante apæ̈nebi ëñëninque botö wæætë, Mänïömæ tömäo ongöñömæ pönömo æ̈ninque bitö tömämæ Awënë babaïmipa, ante wënæ incæ änewengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Änewëñongante Itota wæætë, —“Bitö Awënë Wængonguï weca ædæ wææ̈ninque tömengä ingante, Bitö Wængonguï ïmidö anguënë, ante watapæ̈ apæ̈necæbiimpa. Ayæ̈ tömengä adocanque ingante në cæbi incæbiimpa,” ante Wængonguï beyæ̈ yewæ̈mongatimpa cæbii. Botö weca ongönämaï gobäwe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Angä go ate Wængonguï tömengä anquedoidi pöninque Itota beyæ̈ pönö waa cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ayæ̈ quëwëñongä, Wäö ingante dobæ tee mönedänipa, ante tededäni ëñente wædinque, Itota wæætë Gadideabæ wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wadæ godinque tömengä Näatadeta ponte wodo pænta godinque godömenque go gäwapæ̈ yæwedeca Tabodööidi tönö Nempatadiidi näni owogaïmæ ïñömö pöninque edæ Capënaömö näni quëwëñömö ponte quëwengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Itota mänïñömö ponte quëwengä ïninque Itaiya wodi Wængonguï beyæ̈ në apæ̈necä nänö angaïnö baï mänïñedë ïinque batimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tabodöömæ tönö Nempatadiibæ ingaïñömö, Gäwapæ̈no gämæ̈nö godö, Oododänö æ̈mæ̈mäa ïñömö, Gadideabæ ïñömö wïï oodeoidi wadäni näni quëwëñömö impa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Në ëñënämaï ïnäni wëmö ïñömö contayönäni, tömënäni weca ñäö guïnæ̈ tamö baï adänitapa. Tömënäni näni wænguïmämo oo ïñonte wëmö ïñömö contayönäni, mönö Codito ñäö ëmongä inte do pongä adänitapa.” Ante Itaiya wodi nänö yewæ̈mongaïnö baï ante cædinque Itota mänïñömö ponte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Itota mänïñedë ïïmaï ante mä apæ̈necä ëñënänitapa. “Öönædë Awënë incæ inguipoga tömämæ Awënë Odeye oo bacæcäimpa cæmïnii. Mïnitö wënæ wënæ cædïnö ante, Ancaa wæwente awædö, ante pönente ñimpo cæedäni,” ante cöwë apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ayæ̈ mänïï pöninque Itota gäwapæ̈ Gadideapæ̈ yæwedeca gote cægonte ayongä Timönö Pegodo näni änongä tönö Æntade näna caya ïnate acantapa. Në gæyæ dadöwëna ïnöna inte tömëna ñöwo dicamöñæ̈ æpæ̈në wo guitodonte dadöwëñöna Itota gote acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tömëna ïnate Itota, —Ïñäna, botö mïñæ̈ edæ tee empo pöeda, ämopa. Në dadonte ænte pömïna inte botö weca pöñömïnate botö pönö cæbo ate mïnatö wæætë në apæ̈nemïna badinque waodäni ïnänite në ænte pömïna bacæmïnaimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Angä ëñëninque tömëna dicamöñæ̈ do ëmö cæte godinque Itota mïñæ̈ edæ tee empo wadæ godatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mänïñömö ongonte wadæ godinque Itota wada ïnate Tebedeo wëna Tantiago tönö Wäö näna caya ïnate acantapa. Tömëna mæmpo tönö wipodë ongonte dicamöñæ̈ tadömoncöna adinque Itota tömëna ïnate, Botö mïñæ̈ pöeda, angä. ");
INSERT INTO aucNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ëñëninque tömëna Ao äninque Tebedeo wëna Tantiago tönö Wäö wæmpocä ingante wæætë, Mæmpo ëñëmi, änatapa. Në cædäni tönö wipodë owote cæyömïnite mönatö bitö ïmite ëmö cæte godinque Itota mïñæ̈ gomönapa, äninque adodaque wadæ gogadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ayæ̈ Gadideabæ tömämæ godinque Itota ïñömö Wængonguï apæ̈necä näni ëñente yewæ̈mongainta ate odömöincönë go guiite odömonte apæ̈negacäimpa. Öönædë Awënë incæ inguipoga tömämæ Awënë oo badinque waa cæte aacæcäimpa, ante apæ̈necä ëñengadänimpa. Ayæ̈ waodäni wënæ wënæ inte näni wæwënö ante ayæ̈ quïëmë beyæ̈ wæncæ cæte wædäni incæ Itota tömënäni näni wædö ante pönö cæcä ate tömänäni waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Adinque, Itota mänömaï cæcampa, ante Tidiabæ tömämæ gode änäni ëñëninque waodäni pöninque në wënæ wënæ inte wæwënäni ïnänite tömengä weca ænte pönänitapa. Ayæ̈ nantate wæwënäni tönö wënæ inte quëwënäni ïnänite ænte pöninque dowænte ïnäni tönö cömäïnäni ïnänite tömengä weca ænte pönäni adinque tömengä godö cæcä ate në wënæ wënæ ïnïnäni inte tömänäni waa bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ayæ̈ Gadideabæ quëwënäni tönö Decapodibæ quëwënäni pöñönäni wadäni Eedotadëë quëwënäni tönö Oodeabæ quëwënäni ayæ̈ Oododänö æ̈mæ̈mäa quëwënäni tæiyæ̈näni pöninque tömengä mïñæ̈ tee empote gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tæiyæ̈näni pönäni adinque Itota ïñömö änanquidi æi tæ̈ contayongä tömengä mïñæ̈ në godäni pönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ate tömengä ïñæ̈ æ̈nete nanguï tedete ïïmaï ante odömonte apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Waodäni, Botö waëmö ëwocabopa diyæ̈ öönædë Awënë weca go guiiquïmoo, ante në wædäni ïñömö tömënäni näni watapæ̈ toquinque edæ öönædë Awënë Odeye nempo tömënäni quëwenguïnö do ëadänipa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Në wæwente quëwënäni ïñömö tömënäni näni watapæ̈ toquinque wædänipa. Edæ Wængonguï tömënäni ïnänite waadete godö cæcä ate tömënäni wampo pönencædänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Në gänë pönente ædæmö cæte quëwënäni ïñömö tömënäni näni watapæ̈ toquinque edæ inguipoga tömämæ æ̈ninque awënëidi baï bacædänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Wængonguï nö pönï nänö entawënö baï adobaï entawencæboimpa, ante æcänö cænguï cæ̈ïnente baï wæda, æcänö tepæ̈ gæ̈wænte baï wæda tömënäni ïñömö näni watapæ̈ toquinque wædänipa. Edæ tömënäni tömo cænte baï Wængonguï nänö nö entawënö ænte ædæmö entawente tocædänimpa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Wadäni quëwencædänimpa, ante në godö waadete waa cædäni ïñömö tömënäni näni watapæ̈ toquinque cædänipa. Edæ mänömaï në cædäni ïnänite wadäni wæætë, Quëwencæmïnimpa, ante näëmæ̈ apæ̈nedinque godö waadete waa cæcædänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Mïmö ñäö baï në entawënäni ïñömö tömënäni näni watapæ̈ toquinque edæ Wængonguï ingante do acædänimpa,” ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Guëadö guëa pïïnämaï ïedäni, ante në wææ wææ änäni ïñömö tömënäni näni watapæ̈ toquinque edæ wææ änänipa. Tömënäni ïnänite wadäni edæ, Mïnitö Wængonguï wëñæ̈mïni ïmïnipa, ante do apæ̈nedäni ëñente tocædänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nö cædäni beyænque wadäni pïinte pänäni në wæwënäni ïñömö edæ tömënäni näni watapæ̈ toquinque wæwënänipa. Tömënäni öönædë Awënë Odeye nempo näni quëwenguïnö edæ do ëadänipa.” ");
INSERT INTO aucNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Wadäni botö beyæ̈ pïïninque mïnitö ïmïnite babæ ante änänitawo. Mïnitö ïmïnite edæ togænte pänänitawo. Ïninque edæ mïni watapæ̈ toquinque impa. Ayæ̈, Në wïwa cæmïni ïmïnipa, ante wadäni pïinte änewënäni wæmïni ïninque edæ mïni watapæ̈ toquinque impa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Edæ, Öönædë mönö ænguïnö ante nanguï ongompa, ante pönëninque mïnitö ñöwo wadäni näni pïinte cæyedë incæ watapæ̈ toedäni. Edæ mïnitö ïmïnite pïinte pänäni baï mïnitö ayæ̈ dæ äñedë Wængonguï beyæ̈ në apæ̈negaïnäni ïnänite adobaï pïinte pangadänimpa, ante toquënë wæwëmïnii,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Godömenque apæ̈nedinque Itota, “Mïnitö ïñömö inguipoga quëwënäni beyæ̈ cati quïmonte cæ̈ï baï inte ongömïnipa. Ïninque mïnitö cati baï yæpæ̈ ëmonte baï ïnömïni inte wæætë edæ nongæ̈monte baï badämaï ïedäni. Cati ïñömö yæpæ̈ ëmönämaï nongæ̈monte ba adinque edæ æbänö cæte wæætë yæpæ̈ waa ëmonguïï. Waa impa cænguïnänii anguënë. Ïñæmpa wido cæte näni pïnä gäwate cægonguinque babaimpa,” ante odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ayæ̈, “Ñäö baï ëmömïni inte mïnitö ïñömö edæ inguipoga quëwënäni beyæ̈ tica ënente baï cædinque, Edonque acædänimpa, ante cæmïni ïmïnipa. Änanquidi tæiyæ̈näni mæ̈nonte quëwënäni ïninque edæ ædö cæte wë womonte inguïï. Edæ edonque abaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Waocä ædö cæte tï wodönote godö cængæ̈në boo cæcaquingää anguënë. Edæ, Mönö quëwencabo edonque acæ̈impa, ante cædinque waocä tï wodönodinque wæ̈nömënæcapaa cö cæcä ate edonque bæco aquïnäni. ");
INSERT INTO aucNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mïnitö guiquënë, Wadäni mönö waa cædïnö adinque mönö Mæmpo öönædë në quëwengä ñäö baï tömengä nänö ëmönö ante waa ate apæ̈necædänimpa, ante cædinque cöwë ñäö baï pönëninque waa cæte quëwëedäni,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ayæ̈ ïïmaï ante godömenque odömonte apæ̈necantapa. “Wængonguï, Ïïmaï cæedäni, ante Möitee wodi ingante angä ëñëninque tömengä nänö wææ yewæ̈mongaïnö ante ayæ̈ Wængonguï beyæ̈ në apæ̈nedäni näni yewæ̈mongaïnö ante mïnitö, Mänïnö ante Itota wido cæcæte ante pongampa, ante ædö cæte pönëmïnii. Ïñæmpa wïï wido cæcæte ante pönïmo inte botö tömënäni näni angaïnö baï ïinque cæbo bacæ̈impa, ante pömo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Edæ näwangä ämopa. Inguipoga tönö öönæ ïinque baganca Wængonguï, Ïïmaï cæedäni, ante nänö wææ angaïnö ïñonte adodeque pönï wë womonte badämaï ingæ̈impa. Edæ guiyä tæ̈noncaï incæ picæ̈ yewæ̈mönï incæ adodeque cöwë wadæ cædämaï ïñonte tömengä nänö angaïnö baï tömänö adodö ïinque cæte bacæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ïninque Wængonguï nänö wææ angaïnö ante æcänö adodeque pönï ante ëñënämaï cæda ïñömö tömengä ïñömö edæ öönædë Awënë Odeye nempo quëwengä incæte önonganque pönï inguingänö anguënë. Ayæ̈ adobaï Wængonguï nänö wææ angaïnö adodeque pönï ante odömöninque, Mänïne ante ëñënämaï cæedäni, ante æcänö odömonte apæ̈neda tömengä ïñömö öönædë Awënë Odeye nempo quëwengä incæte önonganque inguingänö anguënë. Wæætë mänïnö Wængonguï nänö wææ angaïnö ante në ëñente cædinque æcänö adodö ante odömonte apæ̈neda guiquënë tömengä wæætë öönædë Awënë Odeye nempo quëwëninque ñæ̈nængä pönï inguingänö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Incæte mïnitö ïmïnite ïïmaï ämopa. Ïïmaï cæedäni, ante näni wææ yewæ̈mongaïnö ate në odömönäni näni cægancaque nö cæmïni incæte Paditeoidi näni cægancaque nö cæmïni incæte mïnitö wïï godömenque nö cæmïni ïninque mïnitö edæ öönædë Awënë Odeye nempo ædö cæte guiite quëwëmaïmïnii,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mänömaïnö ante apæ̈nedinque Itota godömenque odömonte apæ̈necantapa. “Möitee wodi ïñömö, ‘Wacä ingante godö wæ̈nönämaï ïe. Në wæ̈nongä nänö apænte pante wæquinque impa,’ ante dodäni ïnänite tömengä nänö wææ angaïnö ante mïnitö ïñömö do ëñëninque Ao ämïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Botö ïñömö edæ godömenque ante nö ämopa. Näni caipæ̈ ïñönäni æcänö tömengä tönïñacä ingante pïïna ïñömö tömengä nänö apænte pante wæquinque cæcampa. Ayæ̈ tömengä tönïñacä ingante æcänö, Ëñënämaï ïmipa, äna edæ tömengä ingante në Apænte näni Äincabo weca nänö panguinque ænte gönoncædänimpa. Edæ wacä ingante æcänö, Bitö mïmö ömædëmi inte wïï ëñencædö, ante në äna ïñömö tömengä tadömengadænguipo gonga bæcoyömö nänö wido cæquinque angampa töö,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ayæ̈, “Mänömaï beyæ̈ bitö, Wængonguï quï, ante näni iya täïmoga godoncæte ante tæcæ cædinque, Æ, botö tönïñacä ingante edæ wënæ wënæ cæbo pïingampa, ante pönëmi ïninque, ");
INSERT INTO aucNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bitö godonguincoo näni iya täïmoga gäänë ñönöninque bitö tönïñacä weca täno gote nö apæ̈neyömi mïnatö guëa piyæ̈në cæmïna ate bitö ïñömö adodö ponte godöe,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ayæ̈, “Bitö ïmite në pïinte cæcä ïñömö në apænte anguïnäni weca gönoncæte ante ænte idömæ goyongä bitö tömengä ingante waa apæ̈nebi ëñëninque tömengä wæætë piyæ̈në cædinque ee abaingampa. Edæ taadö godinque guëa waa apæ̈nedinque piyæ̈në cædämaï ïmïna ïninque tömengä ïñömö në awënë apænte anguingä weca ænte mäocä gobaïmipa. Ayæ̈ awënë në apænte angä ingante pædæ godongä æ̈ninque tömengä bitö ïmite wæætë wææ wänongä ingante angä ëñëninque tömengä wæætë bitö ïmite bæi ongonte do tee mönebaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tee mönecä ïninque edæ bitö godonte æ̈inta tömanta pönï pædæ godonte tabaïmipa, ante ämo ëñëmaïmipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ayæ̈ apæ̈nedinque, “Möitee wodi, ‘Bitö nänöogængä ïnämaï ïñongante bitö godö mönämaï incæbiimpa,’ ante nänö wææ angaïnö ante ëñëninque mïnitö Ao ämïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Botö godömenque apæ̈nedinque nö ämopa. Onquiyængä ingante wïwa toïnente adingä ïñömö tömengä nänöogængä ïnämaï ïñongante do godö monte baï mïmö dobæ wentamö entawengampa.” ");
INSERT INTO aucNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ayæ̈, “Bitö tömëmö ïnö incæ adinque wënæ wënæ toïnente babi ïninque tömëmi adïmö incæ o togæ̈monte baï cædinque wënæ wënæ bitö cædïnö ante wido cæbi waa ïmaimpa. Wæætë bitö wënæ wënæ adïmö wido cædämaï ïninque bitö baö tömäo tadömengadænguipo wido cæte baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Adobaï bitö önompoca tömëmæ̈ ïnö incæ wënæ wënæ cædïmi inte tömëmi cædimpo incæ aa wi æmpote baï cædinque bitö wënæ wënæ cædïnö ante wido cæbi waa ïmaimpa. Edæ a wi æmpote wido cædämaï ïmi ïninque bitö baö tömäo tadömengadænguipo wido cæte baquïnö anguënë,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Godömenque odömonte apæ̈nedinque Itota, “Ayæ̈, ‘Onquiyængä ingante æcänö pämæ̈ïnëna tömengä ïñömö yewæ̈möinta ænte yewæ̈möninque, Bitö ïmite æ̈mæ̈wo pämæ̈mopa, ante yewæ̈monte onquiyængä ingante godongä æncæcäimpa,’ ante dodäni näni angaïnö ante do ëñëninque Ao ämïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Botö edæ wadö ante ïïmaï ante nö ämopa. Onquiyængä awëmö todämaï ee quëwëñongante tömengä nänöogængä godö pämængä ïninque onquiyængä në towengä nänö baquinque wacä ingante godö möwengampa. Ayæ̈ onquiyængä pämænte goyongä wacä onguïñængä tömengä ingante godö möninque adobaï në towengä bacampa, ante apæ̈nebo ëñëmaïmïnipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ayæ̈ wæætë edæ, ‘Botö Wængonguï cöwë quëwengä baï botö änö cöwë baquïnö anguënë, ante ämi ïninque Wængonguï ëñengä beyænque bitö änïnö ante cöwë cædinque bitö wadö cædämaï incæbiimpa,’ ante Möitee wodi dodäni ïnänite angacäimpa. Mïnitö ïñömö tömengä nänö wææ angaïnö ante ëñëninque Ao ämïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Botö wadö ante nö ämo ëñëedäni. Edæ mänïnö, Botö änö nöingä baquïnö anguënë, ante änämaï ïedäni. Ayæ̈ mänïnö ancæte ante mïnitö Wængonguï ëmöwo ante apæ̈nedämaï ïmïni incæte mïnitö, Öönæ tæ̈ï ongö baï impa, ante apæ̈nedämaï ïedäni. Ïñæmpa, Öönæ, ante ämïni ïninque mïnitö Wængonguï öönædë waa pönï nänö contayömö ante apæ̈nebaïmïni apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ayæ̈ Wængonguï ëmöwo ante änämaï ïninque mïnitö, Ïmæca cöwë ongö baï botö änö cöwë baquïnö anguënë, ante adobaï apæ̈nedämaï ïedäni. Ïñæmpa, Ïmæca, ämïni ïninque mïnitö Wængonguï pï cæwate nänö ongöñömö ante apæ̈nebaïmïni apa änewëmïnii. Ayæ̈, Eedotadëë cöwë ongö baï botö änö cöwë baquïnö anguënë, ante apæ̈nedämaï ïedäni. Ïñæmpa Eedotadëë ïñömö mönö Tæiyæ̈ Awënë Odeye ongongä apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ayæ̈ adobaï, Botö änö nöingä baquïnö anguënë, ancæte ante bitö, Tömëmo ocabo tæ̈ï ongö baï impa, ante mïni änewënö ante änämaï ïe. Ïñæmpa bitö ocaguï wentamö encabi ïninque bitö ædö cæte adoguinque pönï godö cæbi näämænta baquïï. Ayæ̈ näämænta encabi ïninque bitö ædö cæte adoguinque pönï godö cæbi wentamö baquïï anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ïninque mïnitö Ao äïnëmïni inte ‘Ao’ äninque mäninque äedäni. Ayæ̈ edæ Baa äïnente wædinque ‘Baa’ äninque edæ mäninque äedäni. Godömenque äninque mïnitö edæ në wïwa cædongä angä beyænque ämïnipa töö,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ayæ̈ godömenque odömonte apæ̈nedinque Itota, “Ïïmaï ante dodäni näni angaïnö ante ëñëninque Ao ämïnitawo. ‘Bitö godö cæbi beyæ̈ wacä awinca tæigæ̈mongä bacä ïninque tömengä näëmæ̈ cæcä beyænque bitö awinca adobaï tæigæ̈mömi bacæbiimpa. Ayæ̈ bitö godö cæbi beyæ̈ wacä baga tä tobæ̈ gogacä ïninque tömengä näëmæ̈ cæcä beyænque bitö baga adobaï tä tobæ̈ gogacæbiimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Botö wæætë wadö ante nö ämo ëñëedäni. Në wïwa pönö cæcä ingante näëmæ̈ cædämaï ïedäni. Edæ wacä bitö tömempaga ïnö pönö tamongä wædïmi inte bitö wæætë æ̈mæmpaga ïnö dadi ëmæ̈monte ee ongömi wæætë tamongäe. ");
INSERT INTO aucNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ayæ̈ wacä, Bitö ïmite në apænte angä weca ænte godinque botö bitö weocoo æncæboimpa, ante cæyongä bitö mänincooque tömengä ingante pædæ godöninque wacoo bitö yabæ mongæncoo tönö ee abi ö æncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ayæ̈ wacä bitö ïmite, Bado, mäninganca mongænte mäobi goboe, angä ëñëninque bitö tömengä nänö äninganca mäobi goyongante ayæ̈ adoganca godömenque mongænte mäobi gocäe. ");
INSERT INTO aucNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ayæ̈ në, Pönömi æ̈moe, angä ingante godömi ængäe. Ayæ̈ wacä, Bitö quinca pönömi ænte cæte ate wæætë pönömo æ̈e, ante në angä ingante bitö pæ gompodämaï incæbiimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ayæ̈ apæ̈nedinque Itota, “Mïnitö dodäni näni angaïnö ante do ëñëninque edæ Ao ämïnitawo. Tömënäni ïñömö, ‘Bitö guiidengä ingante waadete cæe,’ äninque edæ, ‘Në pïingä ingante näëmæ̈ pïinte cæe,’ ante wææ änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Botö ïñömö edæ wadö ante nö ämo ëñëedäni. Mïnitö ïmïnite në pïinte cædäni ïnänite mïnitö wæætë waadete cæedäni. Ayæ̈ mïnitö ïmïnite në togænte pänäni beyæ̈ ante Wængonguï ingante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mänömaï cædinque mïnitö mönö Mæmpo öönædë në quëwengä wëñæ̈mïni bacæmïnimpa. Edæ në wïwa cædäni beyæ̈ incæ në waa cædäni beyæ̈ incæ Mæmpo Wængonguï angä nænque tamompa. Ayæ̈ në nö cædäni beyæ̈ incæ në nö cædämaï ïnäni beyæ̈ incæ Wængonguï angä cöönæ cæpa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mïnitö guiquënë mïnitö ïmïnite në waadedänique ïnänite waadete pönëmïni ïninque mïnitö mïni cædïnö beyæ̈ ante dicæ paga ænguïmïniyaa. Ïñæmpa odömäno awënë beyæ̈ në æ̈wënäni incæ mïnitö waadete pönenganca adoganca cædinque tömënäni ïnänite në waadete pönënänique ïnänite waadete pönënänipa töö. Bitö godömenque cæbitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ayæ̈ mïnitö tönïñadänique ïnänite waadete apæ̈nedinque mïnitö dicæ godömenque cæmïniyaa. Ïñæmpa wadäni në, Nämä cæte quëwenguïmo, ante në ëñënämaï cædäni incæ mïni cædö baï adoganca cædäni apa quëwëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mönö Mæmpo öönædë quëwengä në nö waa cædongä ingä baï mïnitö adobaï cædinque picæ̈mïni badinque nö waa cæte quëwëedäni,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Itota ayæ̈ godömenque ïïmaï ante odömonte apæ̈negacäimpa. “Mïnitö edæ, Wængonguï nänö änö ëñente nö cæbote, ante cæmïnitawo. Ïninque mïnitö, Waodäni botö ïmote waa acædänimpa, ante änämaï inte wïï waodäni ayönäni cædinque waa cæedäni. Edæ, Waodäni botö ïmote waa acædänimpa, ante pönëninque cæmïni ïninque mönö Mæmpo öönædë në quëwengä ïñömö mïnitö cædï beyæ̈ wæætë pönönämaï ïmaingampa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ayæ̈, “Wadäni në wadö ante wadö cædäni guiquënë, Ömaadäni inte në wædäni quï, ante pædæ godoncæte ante cædinque, Botö æbänö waa pönï cæboo, ante tömänäni ponte waa acædänimpa, ante pönente todompeta näni ancadeca we we öönänipa. Tömënäni mïnitö odömöincönë go guiite ongöninque ayæ̈ taadö gote cægöninque, Botö waa pönï cæbo aedäni, ante yedæ änäni ëñente godongämæ̈ pönäni ate tömënäni tömänäni ayönäni godönänipa. Bitö ïñömö tömënäni näni, Pönö waa acædänimpa, wædö baï wædämaï inte edæ pæ wëënete godöe. Tömënäni waodänique godö waa adäni æ̈ninque mäninque æ̈nänipa. Wængonguï guiquënë waa adämaï incæcäimpa. Näwangä ämopa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bitö ïñömö, Ömaadäni inte në wædäni quï, ante godoncæte ante cædinque bitö guiidengä eyequeï pönï ongongä incæ adämaï incæcäimpa, ante wææ cæe. ");
INSERT INTO aucNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mänömaï wææ cædinque awëmö godömi æncædänimpa. Mänömaï cæbi adinque bitö Mæmpo në wëmö ïñömö në acä ïnongä inte awëmö bitö godönï ante wæætë eyepæ̈ pönongä æncæbiimpa,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ayæ̈ godömenque apæ̈nedinque, Itota, “Wadäni Wængonguï ingante apæ̈nedinque nämanque ante näni cæbaï mïnitö ïñömö wïï adobaïnö ante Wængonguï ingante apæ̈needäni. Mänïnäni guiquënë, Botö apæ̈nebo adinque waodäni pönö waa acædänimpa, ante pönëwëninque mïnitö odömöincönë go guiidinque næ̈ gongæ̈ninque Wængonguï ingante apæ̈nedänipa. Ayæ̈ tömënäni näni quëwëñömö ñænquedæmpo ïñömö gote næ̈ gongæ̈ninque Wængonguï ingante apæ̈nedänipa. Näwangä ämopa. Tömënäni waodänique godö waa adäni æ̈ninque mäninque æ̈nänipa. Wængonguï guiquënë waa adämaï incæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bitö ïñömö tömëmi oncönë guiite odemö tee mönedinque mönö Mæmpo në awëmö quëwengä ingante apæ̈nee. Mänömaï cæbi adinque bitö Mæmpo wëmö ïñömö në acä ïnongä inte awëmö bitö cædïnö ante wæætë eyepæ̈ pönongä æncæbiimpa,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ayæ̈, “Nämä cæte quëwenguïmo, ante në änäni önonque näni tedewënö baï tededämaï inte mïnitö nö cædinque Wængonguï ingante apæ̈needäni. Tömënäni ïñömö, Wantæpiyæ̈ tedebo beyænque Wængonguï ëñencæcäimpa, ante babæ ante pönëninque önöneque tedewënänipa cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mïnitö ïñömö edæ tömënäni önöneque tedete näni cædö baï edæ cædämaï ïedäni. Ïñæmpa mönö Mæmpo ingante apæ̈nedämaï ïñömonte tömengä mönö anguïnö ante wëënëñedë do ëñengä apa tedewëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ïninque edæ ïïmaï ante Wængonguï ingante apæ̈needäni. ‘Mönitö Mæmpo në öönædë quëwënömi inte ëñëmi. Bitö ëmöwo Tæiyæ̈ Waëmö ëmömi adinque mönitö bitö ëmöwo ante waa adinque apæ̈nemönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bitö öönædë Awënë në ingaïmi inte inguipoga Awënë Odeyebi edæ bitö baquinque quingæ̈ pöe. Öönædë owodäni ëñente cædäni baï inguipoga adobaï bitö änö ante edæ ëñente cæte bacæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mönitö ïmönite bitö, Cænguï, ante ïïmö ïñö ïïmö ïñö bitö pönönï ñöwoönæ incæ eyepæ̈ pönömi ænte cæ̈mönie. ");
INSERT INTO aucNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mönitö ïmönite në waa cæquënënäni inte pönö wënæ wënæ cædäni adinque mönitö godö ñimpo cæmöni quëwënäni baï bitö në panguënëmi incæ adobaï cædinque mönitö në waa cæquënëmöni inte wënæ wënæ cæmöni adinque pönö ñimpo cæbi quëwëmönie. ");
INSERT INTO aucNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ayæ̈ mönitö wënæ wënæ cæïnente wædö ante bitö pönö wææ cæbi ate mönitö taadö oda cædämaï inte wënæ wënæ cædämaï incæmönimpa. Edæ në wïwa cædongä nempo ongonte wæyömönite bitö gä peyæmpote æ̈mi quëwencæmönie, ämönipa. Tömëmique edæ Awënë Odeye tæ̈ï pïñæ̈mi ïñömi mönitö bitö nempo ongömönipa. Nämä ñäö baï entawëmi inte bitö cöwë tæ̈ï ëmömi ïnömi ïmipa. Amëë, ante, Näwangä impa, ante apæ̈nemönipa.’ Mänömaïnö ante Wængonguï ingante apæ̈needäni,” ante Itota odomonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ayæ̈ godömenque odömonte apæ̈nedinque Itota ïïmaïnö ante apæ̈negacäimpa. “Mïnitö ïmïnite wënæ wënæ cæyönänite mïnitö godö ñimpo cæmïni ïninque mönö Mæmpo në öönædë quëwengä adobaï mïnitö wënæ wënæ cædïnö ante pönö ñimpo cæcä quëwëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wæætë mïnitö waodäni näni wënæ wënæ cædïnö ante ñimpo cædämaï ïmïni adinque edæ mönö Mæmpo adobaï mïnitö wënæ wënæ cædïnö ante ñimpo cædämaï inte pönö pïincæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ayæ̈ odömonte apæ̈necantapa. “Wadö ante në wadö cædäni guiquënë ïïmaï ante mä pönëninque cædänipa. Wængonguï beyæ̈ ante ee ate cæ̈nämaï inte botö wæwente baï ëmömo adinque wadäni botö ïmote waa acædänimpa, ante awinca nämönänipa. Mïnitö ïñömö Wængonguï beyæ̈ ante cædinque ee ate cæ̈nämaï ïmïni ïninque tömënäni näni cæbaï cædämaï ïedäni. Wæætë nämönämaï inte Wængonguï beyænque ante cæ̈nämaï ïedäni. Näwangä mïnitö ïmïnite ämopa. Tömënäni waodänique godö waa adäni æ̈ninque mäninque æ̈nänipa. Wængonguï guiquënë waa adämaï incæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bitö guiquënë Wængonguï beyænque ante ee ate cæ̈nämaï inte cæbi ïninque awinca ñä mëmonte ayæ̈ ocabo öni pæcate cæe. ");
INSERT INTO aucNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bitö ee ate cæ̈nämaï ïmi ïninque, Waodäni edonque acædänimpa, ante änämaï inte wæætë, Mæmpoque acæcäimpa, ante mänömaï cæe. Bitö mänömaï cæbi adinque mönö Mæmpo në wëmö ïñömö quëwengä ïnongä inte wëmö ïñömö edonque adinque awëmö bitö cædïnö ante wæætë eyepæ̈ pönongä æncæbiimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Godömenque odömonte apæ̈nedinque Itota, “Tömëmo mäincoo, ante mancæte ante wædinque mïnitö inguipogaque cayæ̈ cænte to tamonte ïñömö cabo të gæte da wënämaï ïedäni. Edæ në ö æ̈näni bæ tate näni ö ænguinque inguipogaque da wëmïni apa quëwëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Öönædë ongoncoo guiquënë to tamönämaï impa. Cayæ̈ guiidämaï ï ïninque mäincoo wodämaï ongompa. Ayæ̈ në ö ænguïnäni adobaï mänïñömö bæ tate guiidämaï ïnäni ïninque mäincoo cöwë wë wodönämaï ee ongompa. Ïninque, Waadete mïni cædincoo cabo të gæte baï cædinque mïnitö öönædë waa pönï incoo mïni ænte manguinque ñöwo ïñömö waodäni ïnänite waadedinque ee cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Edæ waa pönï mïnitö mäincoo ongöñömö mïnitö mänïñömö adoyömö quëwencæte ante wæmïni ïmïnipa, ante adinque botö mänömaïnö ante apæ̈netabopa,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ayæ̈ odömonte apæ̈nedinque, “Baonga quëwëninque mönö edonque adinque cæcæ̈impa, ante mönö awinca ëmömompa. Ïninque awinca wainca ëmonte edonque ate baï bitö mïmöno adobaï ñäö entawëninque, Nö cæbote, ante pönëmi ïninque bitö baonga nö cæte quëwëmaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wæætë edæ awinca wïï wainca ëmöninque adämaï inte baï wentamö entawëmi ïninque bitö, Wïwa cæbote, ante mïmöno pönëñömite bitö baonga wïwa cæbaïmipa. Edæ mïmö ñäö entawëñömi wentamö ba ïninque bitö quëwenguïmämo mæ̈ mämonte baï baquïnö anguënë,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ante apæ̈nedinque Itota ayæ̈ odömonte apæ̈necantapa. “Mënaa awënëna bayönate waocä ïñömö mënaa awënëna näna änö ante ædö cæte ëñente cæquingää. Ïñæmpa adocanque ingante pïïninque tömengä wacä ingante waadebaingampa. Wæætë ïingä mïñæ̈ tee empo godinque tömengä mäningä ingante edæ wïwa adinque ëmö cæte gobaingampa. Mïnitö adobaï Wængonguï beyæ̈ ante në cæmïni inte ædö cæte mäincoo beyæ̈ ante cæte quëwenguïmïnii,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Äninque, Itota ayæ̈ godongämæ̈ odömonte apæ̈nedinque, “Mänömaï beyæ̈ botö mïnitö ïmïnite ïïmaï ämopa, angantapa. Mïnitö inguipogaque mïni quëwenguïmämo ante wædämaï ïedäni. Cænguï bequï ante ayæ̈ weocoo ante wædämaï ïedäni. Cænguï cænte beyænque mönö dicæ quëwëmongaa. Weocooque mönö mongæ̈nö beyænque dicæ quëwëmongaa. Mönö quëwëmämo ïñömö godömenque impa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ayamöidi awæ̈næca në cæwodäni ïnänite amïnitawo. Tömënäni dicæ tömëmö minte pæ ate tä pete daga wente mänäniyaa. Incæte mönö Mæmpo öönædë quëwënongä inte wæætë tömënäni ïnänite eyepæ̈ godongä cæ̈näni aedäni. Mïnitö guiquënë ayamöidi ïnämaï ïñömïnite Wængonguï mïnitö ïmïnite godömenque waa adinque eyepæ̈ pönongä cænte apa wæwëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Edæ Wængonguï nänö anganca quëwenguënëmïni inte mïnitö, Wantæ ïño incæ godömenque quëwëmote, ante wæwëmïni incæte edæ ædö cæte nämä cædinque godömenque wantæpiyæ̈ quëwenguïmïnii.” ");
INSERT INTO aucNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Äninque Itota godömenque odömonte apæ̈necantapa. “Ïninque mïnitö, Weocoo quincoodö wëñaquïï, ante pönente quïnante wæwëmïnii. Ïñæmpa ongaicoo ömædë pæ ïñömö weocoo ante daque daque dadämaï inte wodonte tïnämaï tömenque pæ aedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Incæte Awënë Tadömöö wodi waëmoncoo pönï ëñagaingä incæ wïï ongai baï ëñagacäimpa. Ongai ïñömö godömenque waëmö pönï ënodänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gaguïmæ̈ ïñömö ïïmö ate edæ gongapamö guitodonte tanguinque pæ incæte ñöwoönæ Wængonguï pönongä waëmö wëñate ënopa. Ïninque, Waëmö ënodö në pönongä inte Wængonguï mönö ïmonte godömenque eyepæ̈ pönï pönongä ænte wëñacæ̈impa, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ïninque mïnitö, ‘Quïmönö impa cænguïmöö,’ ante, ‘Quïmæ̈nö impa bequïmöö,’ ante ayæ̈, ‘Quincoodö impa wëñaquïmöö,’ ante pönëninque guïñente wæwënämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mänïnö ante wadäni në ëñënämaï ïnäni näni cabo näni cabo wædäni incæte mïnitö guiquënë, Mönö æ̈ïnente wædö ante mönö Mæmpo ïñömö edæ do ëñengampa, ante pönëninque edæ guïñente wædämaï incæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wæætë edæ, Wængonguï Awënë Odeye nempo quëwencæboimpa, ante nanguï cædinque mïnitö, Tömengä nö cæte nänö waa quëwënö baï adobaï nö cæte waa quëwencæboimpa, ante adobaï nanguï cæedäni. Mänömaï quëwencæte ante täno wæmïni adinque Mæmpo Wængonguï mänïnö ante do edæ eyepæ̈ pönï pönongä æ̈ñömïni mänincooque mïni wædö ante adobaï eyepæ̈ pönongä æncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mänömaï ï ïninque, Ïïmö ate æbänö cæquïï, ante guïñente wædämaï ïedäni. Edæ ïïmö ate mänïnö ante pönëninque eyepæ̈ pönente inguimpa. Ïninque mïnitö, Ñöwoönæque æbänö cæquïï, ante guïñente pönëninque mäninganca pönente quëwëedäni,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mänömaïnö ante odömonte apæ̈nedinque Itota godömenque apæ̈negacäimpa. “Mïnitö wacä ingante, Wënæ wënæ ïmipa, ante apænte änämaï ïedäni. Edæ mïni apænte wæquinque mïnitö wadäni ïnänite apænte ämïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mïnitö wadäni ïnänite tee mante godömïni näni ænganca wæætë adoganca pönönäni æncæmïnimpa. Ayæ̈ mïni apænte anganca adoganca apænte änäni wæcæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bitö tönïñacä wædænque wënæ wënæ cæcä ïñongante bitö guiquënë nanguï bitö wënæ wënæ cædïnö ante pönënämaï inte quïnante tömengä ingante pïinte änewëmii. Tömengä edæ awinca guiyä mæ̈ owo ëmongä baï entawente wæyongante bitö wæætë awæmpa wææ ëmongä baï wææ entawëmi inte ædö cæte ate baï tömengä ingante apænte ämii. ");
INSERT INTO aucNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Edæ tömëmi awinca awæmpa wææ ëmonte baï bitö wënæ wënæ adïmö ëmömi inte bitö tönïñacä ingante, ‘Biwï, bitö awinca guiyangä mæ̈ owo baï ate æ̈ wimömoe,’ ante edæ abipa diyæ̈ æ̈ wimonguïmii. ");
INSERT INTO aucNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ïñæmpa wadö tedete wadö cædömi inte bitö edæ tömëmi awinca awæ̈ wææ ongompa täno wido cæte ate edonque adinque bitö tönïñacä awinca guiyä mæ̈ owodö æ̈moncæbiimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Äninque Itota godömenque apæ̈nedinque, “Guintaidi ïnänite, Tömënäni cænguï, ante tæiyæ̈ waëmö cænguï godönänitawoo. Edæ godönämaï ïnäni baï mïnitö adobaï Wængonguï nänö tæiyæ̈ waëmö apæ̈nedö ante në Baa änäni ïnänite apæ̈nedämaï ïedäni. Ayæ̈ odæ̈ wængänäidi weca waodäni wamoncoo waa pönï ëmoncoo wææntodönämaï ïnäni baï mïnitö adobaï Wængonguï beyæ̈ waa pönï näni apæ̈negaïnö ante në ëñente cædämaï ïnäni ïnänite apæ̈nedämaï ïedäni. Edæ odæ̈ wængänä pïnä gäwa baö wänä ñænte baï cædinque tömënäni ëñënämaï inte cædinque dadi ëmænte tömëmïni baö wangö pocænte baï pïïmaïnänipa, ante mïnitö apæ̈nedämaï ñïne cæedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ayæ̈ apæ̈nedinque Itota, “Pönömi æ̈moe, ante në angä baï cædinque mïnitö mïni ænguïnö ante Wængonguï ingante apæ̈needäni. Æyömönö ïï, ante në diqui diqui mingä baï cædinque mïnitö, Æbänö ïï, ante ædæmö ëñencæte ante Wængonguï ingante wede pönente apæ̈needäni. Odemö mönitö beyæ̈ wi æ̈necæ̈impa, ante aa pecä baï cædinque mïnitö, Æbänö cæquïmoo, ante ëñencæte ante Wængonguï ingante nanguï apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Edæ, Pönömi æ̈moe, ante në änäni ïñömö edæ do æ̈nänipa. Në diqui diqui mïnäni adobaï do adänipa. Ayæ̈ odemö ponte në aa pedäni tömënäni näni guiiquinque edæ do wi æ̈nete baï bacæ̈impa.” ");
INSERT INTO aucNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ayæ̈, “Bitö waobi ïnömi inte ëñëmi. Bitö wëñængä cænguï ante päö angä ëñëninque bitö dicæ dicaque pædæ godömiyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Gæyæ angä ïninque bitö tæntæ incæ dicæ pædæ godömiyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mïni waocabo në wïwa cædömïni incæ, Quïnö waa ï, ante ëñëninque mïnitö wëñæ̈näni ïnänite waëmoncooque godömïni æ̈nänipa. Ïninque mönö Mæmpo öönædë në quëwengä ïñömö në änäni ïnänite waëmoncooque ante godömenque pönongampa,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ayæ̈, “Mïnitö, Waodäni botö ïmote waa cædäni æ̈ninque waa tobaïmopa, ante wæmïnitawo. Ïninque mïni ante wædö baï ante mïnitö tömënäni ïnänite adobaï waa cæedäni. Mänïnonque ante wææ ancæte ante dodäni, Ïïmaï cæedäni, ante wææ angadänimpa. Ayæ̈ Wængonguï beyæ̈ në apæ̈nedäni adodö ante ancæte ante yewæ̈mongadänimpa. Ïninque botö änö baï cædinque mïnitö tömënäni näni angaïnö baï do edæ cæbaïmïnipa,” ante Itota odömoncæte ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Itota godömenque odömoncæte ante ïïmaï apæ̈necantapa. “Mïnitö guiyänemö guiidinque quëwenguïnö taadonque pöedäni. Wænguïnö godö guiiquïnemö guiquënë yabæ ïnö ñæ̈næ̈nemö ongö adinque tæiyæ̈näni önonque pö guiite edæ tömënäni näni wænguinque ñæ̈næ̈nonque godänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wæætë wædænque ïnäni guiquënë diqui minte guiyänemö adinque quëwenguïnö guiyänö guiite pönänipa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Itota ayæ̈ godömenque odömonte apæ̈necantapa. “Pancadäniya, Wængonguï beyæ̈ në apæ̈nemöni ïmönipa, ante në babæ apæ̈nedäni ïñönänite mïnitö gomö ate tömënäni ïnänite ëñënämaï ïedäni. Tömënäni ïñömö edæ mëñeidi baï ïnäni incæ obega æ̈montai baï wëñate baï babæ cædänipa. Obega ee quëwënäni baï ee cæmöni ïmönipa, ante edæ babæ ante pönäni tamëñedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Edæ tömenca adinque mïnitö, Awæ̈ æbänö ïwæ̈, ante tä pete bete do ëñëmïni baï, Ïïnäni ædänidö ïnänii, ante ëñencæte ante tömënäni näni cædïnö adinque edæ do ëñencæmïnimpa.” “Yowemö æncæte ante waodäni dicæ daa mongæ̈wäa tä pete æ̈näniyaa. Iigowæ̈ñeca æncæte ante waodäni dicæ wæntowäa edæ tä pete æ̈näniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Waïwæ̈ tömäwæ̈ wainca incapa. Baawæ̈ wæætë baaca incapa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Waincawæ̈ incæ ædö cæte baaca incaquïï. Wæætë wïwa ïwæ̈ incæ ædö cæte wainca incaquïï. ");
INSERT INTO aucNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Awæ̈ quïwæ̈menque wainca incadämaï ï ïninque mänïwæ̈ tömëwæ̈ mæ̈ yete gongapamö guitodönäni gonguinque ñongæmpa. Tömënäni adobaï näni gonte wæquinque babæ cædänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ïninque, Awæ̈ æbänö ïwæ̈, ante tömenca adinque do ëñënäni baï waocä nänö cædö ante adinque, Tömengä æbänö ingää, ante edæ do ëñencæmïnimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ayæ̈ godömenque odömonte apæ̈nedinque Itota ïïmaï apæ̈necantapa. “Botö ïmote, ‘Awënë, bitö botö Awënë ïmipa,’ ante në tededäni näni tededö beyænque ædö cæte öönædë Awënë Odeye ömæ guiiquïnänii. Wæætë mönö Mæmpo öönædë quëwengä nänö änö baï në cædingä ïñömö tömenganque guiicæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ïinque bayonte pancadäniya botö ïmote, ‘Awënë, Awënë,’ äninque, ‘Bitö beyæ̈ apæ̈negamöniï ae, ancædänimpa. Ayæ̈, Bitö ëmöwo apæ̈nedinque wënæ inte wido cægamöniï ae. Bitö ëmöwo apæ̈nedinque mönitö, Ate pönencædänimpa, ante bamönengæ̈ cædinque nanguï waa cægamöniï ae,’ ancædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ëñëninque botö wæætë, ‘Ïñæmpa botö mïnitö ïmïnite cöwë adämaï inte tæcæ abopa. Në ëñënämaï cædïmïni inte botö weca ongönämaï gobäewedäni,’ ancæboimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ayæ̈ wæætë odömöninque Itota ïïmaï apæ̈necantapa. “Ïninque edæ botö apæ̈nebo ëñëninque në ëñente cædäni ïñömö tömënäni waocä në ëñengä inte nänö nö ëñente cæï baï cædänipa. Në ëñengä ïñömö tæ̈ëmoncaa mæ̈nongampa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tæ̈ëmoncaa mæ̈nongä ate cöönæ nanguï cæ ate æpæ̈ eyede äninque pö tapæmpa. Ayæ̈ woboyæ̈ nanguï pæ̈mænte pö incæte oncö tæ̈ëmoncaa mæ̈nonte ongö ïninque ædö cæte cabænte bobænte guiiquïï. Në ëñente cædäni ïñömö mänïñömö mæ̈nongä baï inte todänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wæætë botö apæ̈nebo ëñëninque në ëñënämaï cædäni guiquënë tömënäni ïñömö waocä ocai ömæcacä nänö ëñënämaï cæï baï cædänipa. Në ömæcacä ïñömö ëmönaiya aquïï ïñömö mæ̈nongampa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aquïï ïñömö mæ̈nongä ate cöönæ nanguï cæ ate æpæ̈ eyede ante tapæmpa. Ayæ̈ woboyæ̈ nanguï pæ̈mænte pö adinque mänincö öñonte ætæwo goquinque edæ do acapowate bogocæ tæ̈ go wææmpa. Në ëñënämaï cædäni ïñömö mänïñömö mæ̈nongä baï inte wædänipa,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mäninganca ante ïinque apæ̈necä ëñëninque tömänäni, Quïnö baï angää, ante guïñente wædinque, ");
INSERT INTO aucNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wïï mönö ïmonte në odömönäni näni odömönö baï tömengä ïñömö në angä inte baï edæ godömenque nöingä ante odömongä ëñëmompa, ante tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mänïï änanquidi ongöninque ïinque apæ̈nete wæængä adinque tæiyæ̈näni tömengä mïñæ̈ wæængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tömengä mïñæ̈ tee empote wææ̈ goyönäni wacä baate ëñawengä ïnongä inte eyepæ̈ pö bee tëninque Itota önöwa gäänë ædæ wææ̈ninque apæ̈necantapa. —Awënë, Bitö Ao ämi inte wadæ caabi ïninque botö waintai baabaïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Äñongante Itota pædæ wææmpo gampo caadinque, —Ao ämopa. Bitö waintai baacæbiimpa. Angä ïninque ñömæ̈intai nänö ëñadintai dæ baadinque tömengä waintai edæ do baacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Itota edæ tömengä ingante, —Botö æbänö cæboo, ante wadäni ïnänite mäo apæ̈nedämaï ïmäwe. Wæætë, Näwangä impa, ante acædänimpa, ante cædinque bitö, Wængonguï quï, ante në godongä weca töingä godinque waintai bitö baadintai odömömi acæcäimpa. Ayæ̈ Möitee wodi wææ ante nänö angaincoo baï ænte pöninque bitö waintai bitö baadï beyæ̈ ante edæ, Wængonguï quï, äninque në godongä ingante pædæ godömi æncæcäimpa, ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mänïï pöninque Capënaömö pö guiiyongä odömäno tontadoidi awënë capitäö incæ, Itota pönö cæcæcäimpa, ante apæ̈necæte ante pongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Pöninque tömengä, —Awënë, botïmote në cæcä ïñömö cömäingä badinque nanguï pönï nantate oncönë öñongampa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ante äñongante Itota, —Gote cæbo waa bacä ae. ");
INSERT INTO aucNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Angä ëñëninque, —Awënë ëñëmi. Botö waëmö ïmopa diyæ̈ bitö botö oncönë pö guiiquïmii. Edæ bitö adoyömö ongöninque ämi ïninque botö ïmote në cæcä waa bacæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bitö ïñömö Awënë Wængonguï ingante në ëñente cædömi ïmi baï botö adobaï wacä awënë ingante në ëñente cæbo ïmopa. Ïninque botö awënë ëabo inte botö awënë beyænque ämo ëñëninque tontadoidi wæætë guïñente wædinque botö änö ante ëñente cædänipa. Ïninque adocanque ingante botö, Goe, ämo ëñëninque edæ do gocampa. Wacä ingante, Pöe, ämo ëñente pongampa. Ayæ̈ botö ïmote në cæcä ingante, Cæe, ämo ëñëninque edæ do cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ante tontado capitäö nanguï ëñengä inte apæ̈necä ëñente wædinque Itota wæætë tömengä mïñæ̈ tee empo pönäni ïnänite apæ̈nedinque, —Mïnitö ïmïnite näwangä ämopa. Mönö idægocabo ïñömonte mäningä wede pönengä ingä baï adocanque incæ edæ dæ angä awædö, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Incæte ïïmaïnö ante apæ̈nebo ëñëedäni. Mönö wæ̈mæ̈idi Abadäö wodi Itæca wodi Aacobo wodi öönædë Awënë Odeye æ̈æ̈mæ̈ ponte waa beyönäni edæ nænque tamönö gämæ̈nö quëwënäni tönö nænque guiidö gämæ̈nö quëwënäni ïñömö idægoidi ïnämaï ïnäni incæ tæiyæ̈näni adoyömö pöninque mönö wæ̈mæ̈idi tönö godongämæ̈ becædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wæætë Wængonguï Awënë Odeye ömæ në guiiquënënäni guiquënë tömënäni wëmö ïñömö, näni guingo imonte Yæ yæ wæyömö mänïñömö guitodonte wæquïnänidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Äninque Itota wæætë tontado capitäö ingante, —Ñöwo wadæ goe. Bitö pönënö baï do bacæ̈impa. Ante äñongä adoyedë Itota nänö änïñedë incæ awënë ingä në cæcä do waa bagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ayæ̈ Itota mänïñömö pöninque Pegodo oncönë pö guiite ayongä Pegodo nänöogængä wäänä daicawo gawænte möïmoga öñongä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Adinque tömengä önompo pædæ wææmpote bæi ongongä ate onquiyængä wæætë gancæ badinque ængæ̈ gantidinque Itota beyæ̈ pönö cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mänïönæ gäwadecæ̈ ba ïninque wënæ tönö quëwënäni tæiyæ̈näni ïnänite ænte pönäni adinque adodeque äninque Itota wënæ inte wido cæcantapa. Ayæ̈ quïëmë quïëmë nantate wæwënäni ïnänite, Waa baedäni, angä waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Itota mänömaï cæcä ïninque Wængonguï beyæ̈ në apæ̈necä Itaiya wodi do ïïmaï ante nänö angaïnö baï ïinque batimpa. “Mönö nantate wæwëmämo ö æ̈ninque mönö daicawoidi teëmente gote mäo wido cæte baï cædinque tömengä teëmente wængä beyænque quëwëmö ïmompa,” ante Itaiya nänö angaïnö baï Itota cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Itota ïñömö, Tæiyæ̈näni godämæ̈ gongæ̈näni awædö, ante pönëninque tömengä mïñæ̈ në godäni ïnänite, Gäwapæ̈ æ̈mæ̈ wedeca mantamïni taoboedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Äninque ayæ̈ ongöñongante wacä tömënäni näni wææ yewæ̈mongaïnö ante në adingä inte në odömongä ïnongä inte Itota weca pöninque, —Awënë në Odömömi ëñëmi. Bitö ædömë goyömite botö bitö mïñæ̈ pö gocæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Angä ëñëninque Itota wæætë edæ, —Babæ guintaidi ïñömö ontatodë monguï ëadäni ïnänipa. Ayamöidi ongonta ëadäni ïnänipa. Botö Waobo ëñagaïmo guiquënë monguï ömaabo ïmo apa poncæ ämii, ante Itota wææ apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ayæ̈ wacä tömengä ëmïñængä incæ tömengä ingante, —Awënë ëñëmi. Botö täno gote botö wæmpo wængä ate daga wente ate pömoe. ");
INSERT INTO aucNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Äñongante Itota wæætë, —Ïñæmpa në wæ̈wocadäni incæ tömënäni guiidënäni wæ̈näni ate ee abi daga wencædänimpa. Bitö wæætë botö mïñæ̈ ee pöe, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mänïï tao gocæte ante wipodë guiiyongä tömengä mïñæ̈ në godäni godongämæ̈ guiidinque tömengä tönö tao godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tao wogaa goyönäni woboyæ̈ ïñontobæ̈ nanguï pönï pæ̈mæ̈ninque æpæ̈ mængonta mængonta pöninque gao gao goyonte wipo ñänæ ñänæ æi guidentapa. Itota ïñömö mö ñongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mö ñongä adinque tömengä tönö godäni ïñömö tömengä weca gote, Ömæ̈moncæcäimpa, ante tao cædinque, —Awënë, bete wæncæ cæmompa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ante äñönäni, —Mïni pönëegade, quïmæ̈ guïñëwëmïnii. Äninque tömengä ængæ̈ gantidinque, Woboyæ̈ pæ̈mæ̈nämaï ïmäwe. Gäwapæ̈ incæ cædämaï næ̈ gongæ̈mäwe, angä ëñente woboyæ̈ pæ̈mæ̈nämaï ïñö gäwapæ̈ incæ næ̈ gongæ̈ninque ñancæ ñancæ gongæ̈mæ̈nimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Äñongä tömënäni ancai guïñëninque nämäneque tededinque, —Æcämë inte angä ëñente woboyæ̈ incæ æpæ̈ incæ gongæmpa, ante guïñente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mänïï æ̈mæ̈mäa tao ti wæænte Guedatabæ pöñongä wënæ inte quëwëna ïñömö wao wodido quëwente pöninque Itota ingante mämö bee tënatapa. Tömëna ïñömö, Waodäni taadö godämaï incædänimpa, ante wææ cæcæte ante në pïinte cædöna inte edæ, ");
INSERT INTO aucNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","pö bee tëninque ogæ̈ tededatapa. —Bitö Wængonguï Wëmi ïnömi incæ quïmæ̈ mönatö weca pöwëë. Ïinque bayedë möna pante wæquënënö ante pönëninque bitö ñöwo do pancæte ante pömitawo, ante wædatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ante äñönate odæ̈ wængänäidi nanguï ïnäni a ongonte cæ̈näni adinque, ");
INSERT INTO aucNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","wënæidi guiquënë Itota ingante äninque, —Bitö cöwë wido cæcæte ante pönëmi ïninque edæ odæ̈ wængänäidi baönë ämi gobaïmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ante ancaa tedete äna ëñëninque Itota, —Gobäewedäni, angä. Ëñëninque tömënäni tao godinque odæ̈ wængänäidi baönë guiiyönäni odæncato wæætë ontadäa wææ̈nömëmö ïñömö gäwapæ̈no pogodo wæi guiite becadote capo wængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Becadote wæ̈näni adinque odæ̈ wængänäidi në aadïnäni guiquënë pogodo wodii wïnonte tömënäni quëwëñömö mäo, Itota mänömaï cæcä wæmönipa, ante tededänitapa. Ayæ̈, Wënæidi tönö në quëwënïna ïnate Itota mänömaï cæcampa, ante wæmönipa, ante apæ̈nedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ëñëninque tömänäni Itota ingante bee tencæte ante tömënäni näni quëwëñömö tate pönänitapa. Tömengä ingante adinque, Mönitö ömæ ïñömö quëwënämaï gobäwe, ante nanguï angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mänïnö ante änäni ëñëninque Itota wadæ godinque wipodë go guiidinque ïmæ̈mäa tate tömengä quëwëñömö pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pongä adinque wadäni në cömäingä möimpataa öñöñongante edæ æ̈matæ̈ æ̈matæ̈ bæi ongöninque tömengä ingante næ̈ænte pönänitapa. Næ̈ænte pönäni adinque, Në næ̈ænte pönïnäni tönö në cömäingä wede pönente pönänipa, ante adinque Itota ïñömö në cömäingä ingante, —Botö wëmi ëñëmi. Wënæ wënæ bitö cædïmämo ante ñöwo ñimpo cætimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ante apæ̈necä ëñëninque edæ në wææ odömönäni guiquënë pancadäniya nämäneque pönente tededinque, “Ïingä ïñömö Wængonguï ingampa diyæ̈ mänömaï cæquingää. Edæ babæ ancædö.” ");
INSERT INTO aucNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ante pönëñönäni Itota tömënäni näni pönëwënö ante önöwëninque do ëñëninque edæ, —Mïnitö mïmöno quïmæ̈ wïwa ante pönëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Në cömäingä nänö wënæ wënæ cædïmämo ante do ñimpo cætimpa,” ante botö Wængonguï baï ämo ëñëninque mïnitö guiquënë, Wængonguï ingampa diyæ̈ mänömaï cæquingää, ante pönëmïnipa. Ayæ̈ wæætë, “Ængæ̈ gantidinque dao dao gocæcäimpa,” ante botö Wængonguï baï cæbo adinque mïnitö edæ, Wængonguï ingampa diyæ̈ mänömaï cæquingää, ante adobaï pönëmïni ïmaïmïnipa, ante awædö. Ïñæmpa mänömaïnö ante pönëmïni ïninque mïnitö edæ æbänö cæquënëmo ïmo ämïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Incæte waodäni näni wënæ wënæ cædïmämo ante botö Waobo ëñagaïmo inte inguipoga quëwëninque në ämo inte ñimpo cæbo quëwënänipa, ante mïnitö edæ ëñencæmïnimpa, ante botö ïïmaï cæbopa. Äninque edæ në cömäingä ingante edæ, —Ængæ̈ gantidinque bitö möimpata topo cædinque ænte tömëmi oncönë næ̈ænte goe. ");
INSERT INTO aucNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Angä ëñëninque cömäingä ïningä incæ edæ ængæ̈ gantidinque tömengä oncönë wadæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dao dao gocä ate wædinque godongämæ̈ ongönäni ïñömö, Æbänö cæcäï, ante ëñënämaï inte guïñente wædinque, Wængonguï pönö cæcä beyænque waocä ñöwo në angä badinque mänömaï cæcä amönipa, ante pönëninque, Wængonguï bitö ñäö baï ëmömi inte tæ̈ï pïñænte cæbi amönipa, ante watapæ̈ apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Itota edæ mänïnö godömenque gocæ cæte ayongä adocanque Mäateo ïñömö, Odömäno awënë quï bacæ̈impa, ante godonte æ̈inta näni æ̈incönë ongonte cæcä adinque Itota guiimö adinque Mäateo ingante angantapa. —Botö mïñæ̈ pöe, angä. Ëñëninque Mäateo edæ do ængæ̈ gantidinque Itota mïñæ̈ tee empote wadæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ayæ̈ ate Itota tömengä mïñæ̈ në godäni tönö Mäateo oncönë go guiite cængöñönäni odömäno awënë beyæ̈ në æ̈wënäni tönö në ëñënämaï cædäni tönö nanguï ïnäni ponte godongämæ̈ cæ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Adinque Paditeoidi guiquënë tömengä mïñæ̈ në godäni ïnänite äninque, —Mïnitö Awënë në Odömongä ïñömö odömäno awënë beyæ̈ në æ̈wënäni tönö në ëñënämaï cædäni tönö quïmæ̈ godongämæ̈ cæ̈wengää. ");
INSERT INTO aucNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Änäni ëñëninque Itota, —Në waa ingä guiquënë, Cæbi waa baboe, änämaï ingampa. Në wënæ wënæ inte wæcä guiquënë dotodo ingante, Cæbi waa baboe, ante do aa pecampa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pancadäniya, Nämä incæ nö entawëmo ïmopa, ante në änäni ïnänite adinque botö në dotodo baï adobaï ïnömo inte tömënäni ïnänite aa pedämaï incæboimpa. Wadäni guiquënë, Nämä wënæ wënæ cæbo ïmopa, ante në änäni guiquënë, Wængonguï gämæ̈nö poncædänimpa, ante botö tömënäni ïnänite aa pecæ pönömoimpa. “Baö, Wængonguï quï baquimpa, ante në iya tänäni ïnänite wïï aïnëwædö, wæætë godö waadete waa cædäni ïnänite aïnëmo ïmopa,” ante Wængonguï angä apa quëwënäni. Ñöwo edæ godinque Wængonguï nänö änö æbänö ante angä ëñente pömäewedäni, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mänïñedë Wäö mïñæ̈ në godäni pöninque Itota ingante äninque, —Paditeoidi tönö Wäö mïñæ̈ möni gocabo tönö mönitonque Wængonguï beyæ̈ ante ee ate wïï cæ̈mönipa. Bitö mïñæ̈ në godäni guiquënë quïnante Wængonguï beyæ̈ ante cædämaï inte edæ do cæ̈nänii. ");
INSERT INTO aucNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Änäni ëñëninque Itota wæætë, —Onguïñængä në monguingä nänö wente ænte në pönäni baï ïnönäni inte botö mïñæ̈ në godäni ïñömö ædö cæte wæwente baï cæ̈nämaï inguïnänii. Wæætë ayæ̈ ate guiquënë, Monguingä, näni në änongä baï ïñömote wadäni ponte botö ïmote ö ænte gocædänimpa. Mänömaï cædäni ate botö mïñæ̈ në godäni ïñömö mänïñedë ate wæætë cæ̈nämaï inte wæcædänimpa, ante apæ̈nedinque Itota godömenque ïïmaï ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Waocä dicæ mïincoo æ̈ninque pedæncooga pönö tadömonguingäa. Mänömaï cæcä ïninque edæ mïincoo incæ dobæ gäni tamonte guipite ate godömenque wänä tente baquënë. Mïnitö, Awente baï cæ̈nämaï inte waa quëwengæ̈impa, ante mïni änewënö guiquënë pedæncoo baï inte ëwenguincoo baï ënepa. Codito nempo watapæ̈ quëwengæ̈impa, ante botö apæ̈nedö guiquënë mïincoo baï inte quëwenguïne ënepa. Ïninque ëwenguïne tönö quëwenguïne edæ ædö cæte adoyömö ëñente cæquïï. ");
INSERT INTO aucNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ayæ̈ adobaï yowepæ̈ biïnömæ̈ näni ämæ̈ mïïmæ̈ æ̈ninque waodäni ædö cæte picæ̈ æ̈montaicadedë godö pe ñïñænguïnänii. Edæ picæ̈ æ̈montaicadedë pe ñïñæ̈näni ïninque yedæ æ̈ninque ætæwo goquïnö anguënë. Wæætë edæ æ̈montai mïincadedë pe ñïñænte ate yedæ æ̈ninque tæi æbæ̈nämaï ee ongöñö edæ mïïmæ̈ tönö æ̈montaicade adobaï ee ongongæ̈impa, apa quëwëmïnii,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tömënäni ïnänite tæcæ apæ̈neyongä wacä tömënäni odömöincö awënë ïnongä inte Itota weca ponte ædæ wææ̈ninque apæ̈necantapa. —Botö wëñængä baquecä ïñömö edæ dobæ wæncæ cæcampa cæbii. Bitö ponte tömengä ingante gampobi ate quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Angä ëñëninque Itota ïñömö ængæ̈ gantidinque tömengä tönö goyöna tömengä mïñæ̈ në godäni godongämæ̈ godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Idömæ goyönäni edæ wacä onquiyængä wantæpiyæ̈ dote wadepo cöwë wepæ̈ wantæ bidämaï wææ̈ wæwëningä ïñömö ñöwo Itota önöñabæ ïnö pöninque tömengä weocoo yæwedecooque gampocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Tömengä weocooque gampote waa bawënëmote,” ante onquiyængä nämä pönëninque gampocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Gampocä ate Itota dadi ëmæ̈monte adinque, —Onquiyæ̈mi, wæwënämaï ïe. Bitö wede pönënö beyæ̈ edæ wantæ bawënëmipa. Ante äñongä do edæ wantæ bawënengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Itota mänïï godinque awënë oncönë go guiite ayongä në ööña baï öönäni tönö nanguï ïnäni cægonte Yæ yæ wædäni ïnänite adinque, ");
INSERT INTO aucNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tömënäni ïnänite, —Gä goedäni, äninque, Ïñæmpa ïñömö wëñængä wodi wïï æ̈mæ̈wo wængampa. Önonque edæ mö ñongampa. Angä ëñëninque tömënäni, Angantedö amïni, ante tömengä ingante badete todänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ayæ̈ mänïï angä taodäni adinque Itota pö guiidinque wëñængä baquecä wodi ingante pædæ wææmpo bæi ongonte töö æ̈mængä ate wëñængä ængæ̈ ganticantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mänömaï cæcä adinque në adäni ïñömö gode ä gode ä cædäni ate mänïñömö quëwënäni tömänäni ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Itota wadæ gote godömenque goyongä babetamöna tee empo ponte aa pedinque, —Awënë Dabii pæ̈ïmi ïnömi inte mönatö ïmönate pönö waadete waa cæbi æ̈mönae, ante ancaa aa pedatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aa peyöna tömengä edæ oncönë go guiicä adinque adoyömö pö guiidatapa. Guiida adinque Itota tömëna ïnate, —Mïna änö ante nö waa cæquïmo, ante pönëmïna. Äñongante, —Ao. Awënë, bitö änö baï cæcæbiimpa, ante pönëmönapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Apæ̈neda ëñëninque Itota pædæ gopo gampomöninque, —Në pönëmïna ïnïmïna inte mïna pönenganca do waa bacæmïnaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ante äñongä edæ tömëna awinca wi æ̈monte baï adatapa. Itota ïñömö edæ, —Botö cædïnö ante apæ̈nedämaï inguënë quëwëmïnaa. Edæ pæ wëëneyömïna ëñënämaï incædänimpa, ante nanguï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ïninque wadæ godinque Itota nänö änïnö ante wïï ëñente cædinque tömëna, Itota mänömaï cæcä waa bamontamönapa, ante tömämæ mäo apæ̈neda ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wadæ goyöna edæ wënæ tönö cæcä inte babetadecä ïnongä ingante Itota weca ænte pönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Adinque wënæ ingante Itota wido cæyongä babetadecä ïningä ïñömö edæ do tedecä adinque tömänäni ancai guïñëninque, —Itota nänö cædö baï mönö idægocabo adocanque incæ dicæ cæcä atamongaa, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Paditeoidi guiquënë, —Wënæidi awënë tönö cædingä inte tömengä wido cæcä apa änewënänii, ante pïingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Itota ïñömö nanguï näni quëwëñömö ayæ̈ wædænque näni quëwëñömö wayömö wayömö godinque Wængonguï angä näni ëñente yewæ̈mongainta ate odömöincönë go guii go guii cædinque odömongä adänitapa. Ayæ̈, Mönö Awënë Odeye inguipoga oo ponguïnö anguënë, ante nänö waa pönï änïnö ante apæ̈necä ëñënänitapa. Ayæ̈ quïëmë daicawo cæpämo adinque quïëmë wæncæ cæte wæwënö adinque tömengä godö cæcä waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cæ̈ningancoo baï waodäni incæ bacoo ïnäni ïñönäni në aadingä dæ angä baï ïnänipa, ante acantapa. Mänömaï ïnäni inte babæidi wïñaate wædïnäni baï ængæ̈ gantidämaï ïnäni baï waodäni incæ wæwëñönäni Itota tömënäni tönö godongämæ̈ wæwente baï pönengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ayæ̈ tömengä mïñæ̈ në godäni ïnänite apæ̈nedinque, Tömëmoncoo bacoo baï ïnäni ïñönänite tä pete ïnäni baï në gode änäni ïñömö mënäniya pönï ïnänipa cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tömëmoncodë gæquï angä Awënë ïñongante mïnitö tömengä ingante apæ̈nedinque, Tömëmoncodë në gæquïnäni da godömi gote gæte baï äñete poncædänimpa, ante Wængonguï ingante apæ̈needäni, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ayæ̈ ate tömengä mïñæ̈ në godäni önompo tipæmpoga go mënäniya mänimpodäni ïñönänite Itota äñecä pönäni ate tömengä, Botö pönö cæbo ate mïnitö në ämïni badinque wënæidi në wentamö ëwocadäni ïnänite wido cæcæmïnimpa, angantapa. Ayæ̈, Quïëmë daicawo gawæ̈näni incæ quïëmë beyæ̈ wæncæ cæte wæwënäni incæ mïnitö eyepæ̈ inte godö cæmïni ate në wæwënïnäni waa bacædänimpa, ante pönö cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Itota nänö në da godönïnäni önompo tipæmpoga go mënäniya mänimpodäni ïnänipa, ante adinque, Dote, ante näni gocabo ïnänipa, ante tededänipa. Tömënäni ïïmaï ëmönäni ïnänipa. Tänoda Timönö Pegodo mönö änongä tönö Æntade näna caya ïnapa. Ayæ̈ Tebedeo wëna Tantiago tönö Wäö näna caya ïnapa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pedipe tönö Batodömëë mënaa ïnapa. Odömäno awënë beyæ̈ në æ̈wëningä Mäateo tönö Tömato mënaa ïnapa. Adepeo wengä Tantiago tönö Tadeo ïnapa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Wacä, Mönö ömæ ingæ̈impa, ante në nanguï cædingä incæ wacä Timönö ingampa. Ayæ̈ Itota ingante odömonte në godonguingä Codaa Icadiote mönö änongä ingacäimpa. Mänimpodäni Itota mïñæ̈ näni, Dote, ante gocabo ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ïninque Itota mïñæ̈ näni, Dote, ante gocabo ïñönänite tömengä, “Mïnitö idægoidi ïnämaï ïnäni taadö godämaï inte edæ Tämadiaidi näni quëwëñömö go guiidämaï ïedäni, ante da godongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Edæ cæ̈ningäidi obegaidi gueogæ̈ gote baï ïnönäni inte mönö idægocabo taadö oda cædinque tömënäni näni wë womonte wænguïnö godänipa, ante adinque mïnitö tömënäni weca gote cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Godinque mïnitö, Öönædë Awënë Odeye oo poncæcäimpa cæmïnii, ante mäo apæ̈nemïni ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ayæ̈ quïëmë beyæ̈ nantate wæwënäni adinque godö cæmïni ate waa bacædänimpa. Do wæ̈nïnäni ïnänite godö cæmïni ate ñäni ömæ̈moncædänimpa. Baate ïnäni ïnänite godö wadæ caamïni waintai baacædänimpa. Wënæidi inte godö wido cæedäni. Botö önonque änämaï inte pönö cæbo æ̈nïmïni inte mïnitö botö cæbo baï adobaï cædinque wadäni ïnänite änämaï inte önonque godö cæmïni æncædänimpa,” ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ayæ̈, “Mïnitö gocæ cædinque, Godonte æ̈inta, ante tiguitamö incæ oodo incæ padata incæ edæ wente æ̈incadedë da wente æ̈nämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Edæ wadäni beyænque në cæcä ïñömö tömengä eyepæ̈ ænte quëwencæcäimpa cæmïnii. Mäincoo da wenguincade æ̈nämaï inte goedäni, Weocoo mïni ëñacooque ëñate awæncata mïni ëwataque ëwate ongonto mïni næ̈æntoque næ̈ænte goedäni,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ayæ̈ apæ̈nedinque Itota tömengä mïñæ̈ në godäni ïnänite angantapa. “Nanguï pönï näni quëwëñömö incæ wædænque ïnäni näni quëwëñömö incæ mïnitö mänïñömö go guiidinque waocä në nö cæcä ingante ante diqui minte adinque mäningä oncönë go guiite owodinque wayömö mïni go quëwenganca mänincönenque quëwëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mänincönë go guiidinque, Ïñänäni, waa quëwëedäni, äedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ayæ̈ äninque, Mïnitö weca æbänö pö guiite quëwenguïmönii, äñömïni Ao änäni ate mïnitö tömënäni weca go guiite gänë pönëninque ee quëwëedäni. Wæætë nö cædämaï ïnäni adinque mïnitö edæ ee quëwënämaï edæ wadæ gomïni wæcædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Edæ, Pöedäni, änämaï ïnäni adinque ayæ̈ mïnitö apæ̈nemïni ëñënämaï ïnäni ïninque mïnitö wæætë tömënäni oncodo tao godinque, Mïnitö quëwëñömö näwate awædö, ante odömoncæte ante cædinque önöwa wadæ wadæ cæwate wadæ goedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Edæ näwangä ämopa. Botö apænte anguïönæ ïñonte Todömä ïñömö quëwengaïnäni tönö Gömoda ïñömö quëwengaïnäni tönö nanguï pante wæwëñönäni mïnitö ïmïnite në Baa änäni guiquënë godömenque pante edæ wæwencædänimpa,” ante Itota tömënäni ïnänite da godongä godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ayæ̈ äninque Itota, “Cöwä aedäni, angantapa. Mïnitö ïñömö në cæ̈ningäidi baï ïñömïnite botö ïñömö mëñe baï ïnäni weca da godömo godinque mïnitö tæntæ nämä wææ cæcæte ante nänö ëñente cæbaï adobaï ëñente cæedäni. Wæætë edæ equemö nänö ee cæbaï mïnitö adobaï pïïnämaï inte ee cæte quëwëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ayæ̈ edæ mïnitö ïmïnite bæi ongöninque waodäni tömënäni në apænte änäni weca mäo pædæ godönäni æncædänimpa. Ayæ̈ godömenque tömënäni odömöincönë mäo ænte godinque mïnitö ïmïnite tæi tæi pancædänimpa cæmïnii. Ïninque mïnitö edæ, Æbänö cæquïnänii, ante do ëñëmïni inte edæ nämä wææ aaedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ayæ̈, Awënëidi tönö në ëñënämaï ïnäni adobaï ëñencædänimpa, ante cædinque botö ämo ëñëninque mïnitö ïmïnite mäo pancabaa awënëidi gobedönadodoidi weca ayæ̈ tömämæ awënëidi odeyeidi weca gönönäni gongæ̈ninque mïnitö botö beyæ̈ apæ̈necæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mänïñedë tömënäni näni ænte mäo gönöñedë, Quïnö baï apæ̈nequïmoo, ante guïñënete wædämaï ïedäni. Mänïñedë edæ quïnö baï apæ̈nequïï, ante do ëñencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ïñæmpa wïï nämä pönëninque apæ̈nequïmïni wæætë mönö Wæmpo Önöwoca incæ apæ̈necä ëñëninque apæ̈nequïmïni ïmïnipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ayæ̈ godömenque apæ̈nedinque Itota, “Mänïñedë edæ näna caya ïñönate adocanque näëmæ̈ pïïninque, Wæ̈noncæ, äninque tömengä tönïñacä ingante da godongä gocæcäimpa. Näna wencaya ïñönate mæmpocä ïñömö näëmæ̈ pïïninque, Wæ̈noncæ, äninque tömengä wengä ingante da godongä gocæcäimpa. Ayæ̈ wëñæ̈näni incæ wæmpoda ïnate näëmæ̈ pïïninque mäo apæ̈nedäni ëñëninque wadäni tömënäni wæmpoda ïnate mämö wæ̈nönäni wæncædaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ayæ̈, Coditoidi ïmïnipæ̈æ̈, ante tömänäni botö ëmöwo beyænque mïnitö ïmïnite nanguï pïincædänimpa. Pïïnäni wæwëmïni incæ æcänö ïïmæca ïinque baganca wæntædämaï inte botö ëmöwo beyæ̈ pïinte badämaï ingää tömengä ingante botö æ̈mo beyænque quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mänïñedë ate waodäni togænte pancæte ante mïni quëwëñömö pönäni ate wædinque mïnitö ïñömö wayömö wadäni näni quëwëñömö wodii wïnöedäni, ämopa. Edæ näwangä ämopa. Edæ mönö Idægobæ wayömö wayömö wodii wïnöninque pancayömonga goyömïni botö Waobo ëñagaïmo inte edæ do poncæboimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ayæ̈, “Në odömongä ingante pïinte cæyönäni tömengä mïñæ̈ në gocä ingante edæ ædö cæte pïinte cædämaï inguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Awënë në odömongä wæwente quëwëñongä tömengä mïñæ̈ në gocä guiquënë ædö cæte wæwënämaï quëwenguingää. Edæ në cæcä tömengä awënë baï bacä ïninque idæwaa edæ ïmaimpa. Botö oncö ëacä baï në Awënë ïmo ïñömote wadäni, Wënæ awënë Beedeboobi ïmidö anguënë, ante pïïnäni incæ mïnitö botö tönö mïni quëwencabo ïñömïnite wadäni godömenque wënæ wënæ ante pïincædänimpa,” ante Itota apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ayæ̈ apæ̈nedinque, “Incæte tömënäni ïnänite guïñënämaï ïedäni. Ïñæmpa, Adämaï incædänimpa, ante quïëmë wë womonte ï incæ ïincayæ̈ ate tömää wi æ̈nete bayonte edonque pönï bacæ̈impa. Ayæ̈ quïëmë awëmö cæteï incæ ïincayæ̈ ate edonque pönï acædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Botö wëmö ïñömö mïnitö ïmïnite apæ̈nebo ëñente ate mïnitö botö apæ̈nedö ante ñäö apäiyömö apæ̈necæmïnimpa. Ayæ̈ godö wæntæ botö änïnö ëñente ate mïnitö æibæ oncömanca æidinque ogæ̈ tedete apæ̈nemïni ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayæ̈ në baonque wæ̈nönäni inte önöwoca wæ̈nönämaï ïnäni ïnänite adinque mïnitö tömënäni ïnänite guïñënämaï ïedäni. Wæætë edæ baö tönö önöwoca tadömengadænguipo në ömæ̈e ëwënongä ingante guiquënë mïnitö tömengä ingante guïñente wæedäni.” ");
INSERT INTO aucNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Äninque, Itota godömenque apæ̈necantapa. “Waocä ayamöidi önompo æ̈mæmpoque mänimpodäni beyæ̈ tiguitamö adotamonque ante pædæ godongä amïnitawo. Incæte mïnitö Mæmpo änämaï ïñonte ayamö adocanque incæ yæipodë wææ̈nämaï ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mönö ocaguï incæ æpoguïnö encamöö, ante Mæmpo Wængonguï do ëñëninque mönö ïmonte aacampa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Edæ, Ayamöidi bacoo pönï ïninque önonque ïnänipa, ante në äningä inte mönö Mæmpo ïñömö mïnitö ïmïnite wæætë waa acä apa guïñëwëmïnii,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Godömenque apæ̈nedinque Itota, “Æcänö waodäni ëñëñönäni botö ïmote Ao äninque, Bitö botö Awënë ïnömi ïmipa, ante äna tömengä öönædë æiyongante botö tömengä ingante wæætë edæ Ao äninque, Bitö ïñömö botö mïñæ̈ në gogaïmi ïnömi ïmipa, ante botö Mæmpo ëñëñongä ancæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wæætë waodäni ëñëñönäni botö ïmote në Baa angaingä ingante guiquënë botö Mæmpo öönædë në quëwengä ëñëñongä botö tömengä ingante adobaï edæ Baa ancæboimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ayæ̈ apæ̈nedinque Itota, “Inguipoga quëwënäni piyæ̈në cæte wæætedö wæætë cædämaï inte quëwencædänimpa, ante cæcæte ante Itota ïmæca pongaingä ingampa, ante mïnitö pönëmïnitawo. Ïñæmpa yaëmë næ̈ænte baï pömo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Botö apæ̈nedö beyæ̈ onguïñæ̈na näna wæmpocaya incæ näëmæ̈ pïincædaimpa, ante pömo ïmopa. Onquiyæ̈na adobaï näna badancaya incæ näëmæ̈ pïincædaimpa. Näna wæntecaya incæ näëmæ̈ waadedämaï inte pïincædaimpa, ante pömopa. Mänömaï cæbo ïmopa, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ïninque, botö änö beyæ̈ näni owocabo incæ näëmæ̈ waadedämaï pïincædänimpa,” ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ayæ̈ apæ̈nedinque Itota ïïmaï apæ̈necantapa. “Edæ æcänö mæmpo tönö wäänä ïnate ædæmö waadedinque botö ïmote wæætë pönömenque waadeda ïñömö tömengä ïñömö botö në ëmïñængä ædö cæte baquingää. Adobaï wëñængä ingante ædæmö waadedinque botö ïmote pönömenque në waadecä ïñömö tömengä wæætë botö në ëmïñængä ædö cæte baquingää. ");
INSERT INTO aucNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ayæ̈ æcänö botö mïñæ̈ pöïnëna tömengä ïñömö edæ, Awæ̈ botö wænguïwæ̈, ante næ̈ænte ponte baï cædinque, Wæ̈nönäni wæ̈mo incæte Itota mïñæ̈ cöwë gocæboimpa, ante poncæcäimpa. Wæætë æcänö mänömaï cædämaï ïna guiquënë tömengä ædö cæte botö në ëmïñængä inguingää. ");
INSERT INTO aucNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Æcänö nämanque pönente, Ïmæcaque waa quëwenguïmo, ante änaa tömengä ïñömö quëwënämaï incæcäimpa. Wæætë edæ, Wæ̈mo incæ wæwëmo incæ botö öönædë Awënë angä ëñente cöwë cæcæboimpa, ante æcänö äna guiquënë tömengä ïñömö edæ cöwë quëwencæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ayæ̈ apæ̈nedinque, “Mïnitö ïmïnite Ao äninque waocä botö ïmote do edæ Ao äningä ingampa. Ayæ̈ botö ïmote Ao äninque botö ïmote në da pönongaingä ingante do edæ Ao äningä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wængonguï beyæ̈ në apæ̈necä ingante bitö, Wængonguï beyæ̈ në apæ̈nebi inte pöe, ämi ïninque Wængonguï beyæ̈ në apæ̈necä nänö paga ænganca bitö adopo æncæbiimpa. Ayæ̈ në nö cæcä ingante, Bitö në nö cæbi inte pöe, ämi ïninque në nö cæcä nänö paga ænganca bitö adopo æncæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Näwangä ämopa. Bitö Itota mïñæ̈ në gobi inte æpæ̈ becæbiimpa, ante bitö guiyangä ingante pædæ godömi ængä ïninque bitö godönï beyæ̈ eyepæ̈ æncæbiimpa,” ante apæ̈nedinque Itota tömënäni ïnänite da godongä gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ayæ̈ tömengä mïñæ̈ näni, Dote, ante gocabo ïnänite ïinque apæ̈nedinque Itota wadæ godinque tömënäni näni quëwëñömö odömoncæte ante ayæ̈, Ëñencædänimpa, ante apæ̈necæte ante wayömö wayömö gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mänïñedë edæ Wäö ïñömö tee mönete ongöñongante wadäni tömengä weca pöninque, Mönö Codito ïïmaï cæcampa, ante tededäni ëñente wædinque Wäö wæætë tömengä mïñæ̈ goda ïnate Itota weca da godongä godatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ïninque Wäö beyæ̈ ancæte ante pöninque tömëna ïïmaïnö ante Itota ingante apæ̈nedatapa. —Bitö ïñömö dodäni näni, Në Ponguingä, ante në angaïmi adobi ïmitawo. Wæætë tömënäni näni në angaïmi ïnämaï ïmi ïninque bitö wæætë, Wacä ponguingä, ante wänö cöedäni, ämitawoo. Æbänö mönitö cæquïmönii, ante ëñencæte ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ante äñönate Itota wæætë, “Mïnatö ponte ëñëñömïna botö æbänö apæ̈nebo ëñëmïnatawo, ante ayæ̈, Botö æbänö cæbo amïnatawo, ante mïnatö wæætë Wäö weca gote mäo apæ̈nemïna ëñengäeda. ");
INSERT INTO aucNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Botö godö cæbo ate babetamö ïnïnäni incæ waa bamonte adäni amïnapa. Cömante ïnïnäni incæ waa bate dao dao godäni amïnapa. Baate ïnïnäni incæ æ̈montai waëmontai baadäni amïnapa. Babetamonca ïnäni ïñönänite botö godö cæmömo ate önömonca waa bamoncate ëñënäni amïnapa. Do æ̈mæ̈wo wænte öñönäni ïñönänite botö godö cæbo ate ñäni ömæ̈mönäni amïnapa. Ömaadäni inte wæyönänite botö Wængonguï waa pönï nänö pönö cægaïnö ante apæ̈nebo ëñente todäni amïnapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ayæ̈, Botö beyæ̈ waocä wïï pïinte wadæ gocä ïñömö tömengä watapæ̈ nänö quëwenguinque edæ oda cædämaï incæcäimpa, ante apæ̈nebo ëñëninque mïnatö Wäö ingante mäo adodö ante apæ̈nemïna ëñengäeda,” ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Angä ëñëninque Wäö beyæ̈ në änïna wadæ goyöna edæ Itota wæætë tömänäni ïnänite, Wäö æbänö ingää, ante apæ̈necantapa. “Mïnitö guiquënë quïnö acæte ante önömæca gomïnitapa. Cæ̈wipa woboyæ̈ pæ̈mænte ate æ̈mæ̈nö ædæ æ̈mæ̈nö ædæ gobaingä ingante mïnitö dicæ acæ gomïnitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ïninque edæ quingänö ingante acæte ante gomïnitapa. Waocä weocoo waëmoncoo mongæ̈nongä ingante mïnitö dicæ acæ gomïnitawogaa. Ïñæmpa waëmoncoo mongængä ïñömö awënë oncönë quëwengä apa quëwënänii. ");
INSERT INTO aucNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ïninque edæ quïnante gomïnitawo. Mïnitö mïni në go acæ cædongä ïñömö edæ Wængonguï beyæ̈ në apæ̈necä ingantawo. Näwangä impa. Wængonguï beyæ̈ në apæ̈necä Wäö ingampa. Incæte tömengä wïï Wængonguï beyæ̈ në apæ̈negaïnäni baï ïnongä inte godömenque nanguï cæcä ingampa, ante apæ̈nebo ëñëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wængonguï ïïmaï angampa, ante yewæ̈mongatimpa. ‘Botö beyæ̈ në apæ̈necä ingante da pönömo pöninque tömengä taadö täno beyænte baï cæcæcäimpa. Tömengä bitö Codito ïmi beyæ̈ ante taadö waa pïnonte baï waa cæcæcäimpa.’ Mänömaïnö ante dodäni adocä Wäö ingantedö ante pönëninque yewæ̈mongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ñöwo ïñömö ämo ëñëedäni. Ïmæca mïni ëñagaincabo ïñömïnite æpæ̈në mönö në guidönongä Wäö adocanque ñæ̈nængä ïñongante wacä tömengä baï edæ dæ angampa. Incæte öönædë Awënë Odeye nempo quëwënäni ïñönäni adocanque guiyangä pönï ingä incæte Wäö pönömenque wædangä ingampa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ayæ̈ ïïmaï ante godömenque apæ̈necantapa. “Wäö täno nänö apæ̈nedöñedë ayæ̈ godömenque ñöwo ganca tæ̈ï pïñæ̈näni pogodo pöninque, Öönædë Awënë Odeye nempo mönö wäänë guiicæ̈impa, ante tee tate guiite baï cædinque, Mönö Awënë incæcäimpa, ante edæ ö ænte baï cædänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Edæ Wængonguï beyæ̈ në apæ̈negaïnäni tönö, Ïïmaï cæedäni, ante në wææ angaingä tönö tömënäni tömänäni edæ, Awënë poncæcäimpa, ante cöwë Wäö nänö ponganca apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ïninque, Ediya wodi ayæ̈ poncæcäimpa, ante näni në änongä Wäö ïñömö adocä ingampa, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ëamonca ongonte ëñëedäni,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Godömenque apæ̈nedinque Itota ïïmaï angantapa. “Inguipogaque ante në quëwënäni ïñömö quingämë baï ïnänipa. Quïëmë baï edæ quëwënänipa. Wëñæ̈näni mönö godonte æ̈ïñömö tæ̈ contate owempodäni näni owempodö baï edæ adobaï cædänipa, ante awædö. Wëñæ̈näni näni owempote cæcabo incæ æ̈æ̈mæ̈ cæte baï owempote cædinque wadäni ïnänite aa pedänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mïnitö beyæ̈ ööña we we ööñömöni mïnitö wæætë edæ äwadämaï ïmïnitapa töö,’ ante owempodinque wëñæ̈näni pïinte tedewënänipa. Ayæ̈ wæætë, Waocä do wængä ate näni wæbaï ante wëñæ̈näni näni owempote cæcabo ïñömö, ‘Mönitö Ca ca wæyömöni mïnitö wæætë edæ wædämaï ïmïni wæmönipa,’ ante pïïninque aa pedäni baï ñöwodäni ïñömö edæ adobaï pïinte tedewënäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ïïmaï edæ impa. Wëñæ̈näni näni wædö baï Wäö ïñömö cænguï cæ̈nämaï tepæ̈ bedämaï ponte quëwëñongante ñöwodäni guiquënë, Wënæ tönö Wäö quëwengampa, ante pïïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ayæ̈ wæætë botö Waobo ëñagaïmo inte edæ ponte në cænte bete quëwëmo adinque botö ïmotedö ante mïnitö ïñömö, Cæ̈owæ̈obi inte cæ̈mipa. Beowæ̈obi inte bebipa, ante badete tomïnipa. Ayæ̈ godömenque, Odömäno awënë beyæ̈ në æ̈wënäni tönö në ëñënämaï cædäni ïñönänite bitö tömënäni æ̈migo ïmipæ̈æ̈, ante botö ïmote pïïninque mïnitö wëñæ̈näni näni pïinte aa pedö baï änewëmïnipa töö. Incæte, Në nö ëñënäni ïñömö nö cædänipa, ante adinque, Näwangä nö ëñënänipa, ante mönö ëñengæ̈impa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ayæ̈, Mïnitö quëwëñömö botö bamönengæ̈ nanguï cæbo adïmïni incæ mïnitö wënæ wënæ mïni cædïnö ante, Ancaa wæwente awædö, ante dicæ wæmïnitawogaa, ante pïïninque Itota wayömö wayömö tömengä nänö nanguï cædïñömö quëwënäni ïnänite ïïmaïnö ante mä pïingantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Codatïï ïñömö quëwëmïni ëñëedäni. Betaida ïñömö quëwëmïni ëñëedäni. Mïnitö mïni wæwenguinque ëñënämaï cæte quëwëmïnidö anguënë. Edæ botö mïnitö weca tæ̈ï pïñænte botö cædï baï Tido näni quëwengaïñömö Tidöö näni quëwengaïñömö adobaï cæbo baï mänïñömö quëwengaïnäni ïñömö tömënäni dobæ wënæ wënæ näni cægaïnö ante ñimpo cædinque weocoo gömæ ëmoncoo wëñadinque gönai öni pæcate Ca ca wæcægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ïninque mïnitö ïmïnite ämopa. Wængonguï nänö apænte anguïönæ ïinque bayonte Tido ïñömö quëwengaïnäni tönö Tidöö ïñömö quëwengaïnäni ïnänite nanguï pangä wæwënäni incæte tömengä mïnitö ïmïnite godömenque pangä wæwencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ayæ̈ Capënaömö ïñömö quëwëmïni ëñëedäni. Mïnitö ïmïnite Wængonguï dicæ öönædë wo æ̈æntodongä æi gote toquïmïniyaa. Ïñæmpa tadömengadænguipo wææntodongä guii wæcæmïnimpa. Edæ botö mïnitö weca tæ̈ï pïñænte botö cædï baï Todömä näni quëwengaïñömö adobaï cæbo baï tömënäni näni quëwengaïñömö edæ godömenque ñöwo ganca edæ mæ̈ ongoncædönimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ïninque edæ ämo ëñëedäni. Wængonguï nänö apænte anguïönæ ïinque bayonte Todömä quëwengaïnäni ïnänite nanguï pangä wædäni incæte mïnitö ïmïnite godömenque pangä wæcæmïnimpa,” ante Itota tömënäni ïnänite pïingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ayæ̈ mänïñedë Wængonguï ingante apæ̈nedinque Itota, “Mæmpo ëñëmi. Wadäni nämä ocai encadäni tönö nanguï adinque në ëñënäni tönö mänïnö bitö ëñengaïnö ante ëñënämaï incædänimpa, ante cædinque bitö cægaïnö ante wë wodonte baï pæ wëënegabiimpa. Wæætë edæ wëñæ̈näni näni pönënö baï në pönënäni ïnänite wæætë bitö edonque odömömi adinque do ëñënänipa. Bitö öönædë Awënë ingaïmi inte inguipoga Awënë adobi ïnömi inte edæ mänömaï cæbipa, ante adinque botö bitö ïmite waa ate pönëninque apæ̈nebopa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mæmpo, bitö tömëmi änö baï cædinque waa cæbi adinque botö Ao ämopa,” ante Wængonguï ingante waa apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wængonguï ingante ïinque apæ̈nedinque Itota godongämæ̈ ongönäni ïnänite wæætë apæ̈necantapa. “Botö Mæmpo nö ëñengä inte pönö odömongä beyænque botö ïñömö tömänö ante në ëñëmo ïmopa. Ayæ̈, Botö tömengä Wëñæ̈mo ïñömote botö Mæmpoque botö ïmote në againgä ïñongante wadäni adämaï ïnänipa. Wæætë edæ Mæmpocä ingante botö tömengä Wëñæ̈mo ïnömo inte adoboque në agaïmo ïmopa. Ïninque, Botö abo baï ïïnänique adobaï ate baï pönencædänimpa, ante cædinque botö mïnitö ïmïnite odömömo adinque mïnitö adobaï Mæmpocä ingante në ate baï pönëmïni bamïnipa.” ");
INSERT INTO aucNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Teëmë mongænte baï nangæ̈ batawëmïni ïninque mïnitö botö weca pömïni ate botö wæætë teëmë mongænte mïni wæwënö ante ö æ̈mo ate mïnitö wæætë gancæ pönente guëmancæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Edæ botö mïmöno gänë pönëninque nämä beyænque änämaï quëwëmo adinque mïnitö botö weca pömïni ïninque botö mïnitö tönö ïñacabo cæcæboimpa. Edæ wagadada awæmpaa goti wïmoncate äämencaque goda baï möna guëa cæcaya bayömöna botö nö ëñënömo inte pönö odömonte apæ̈nebo ëñëninque mïnitö önöwoca wampo pönente guëmancæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Edæ botö tönö äämencaque baï cædinque bitö ïñömö oo wïmoncadimpa mongænte baï edæ do cæcæbiimpa. Botö mongæncoo wodæ̈ï ïñonte bitö wæætë edæ wodæ̈ï mongænte gote baï nangæ̈ badämaï incæbiimpa,” ante Itota ïinque apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mänïñedë guëmanguïönæ ïñonte Itota tömëmoncodë tæcæguedencodë gocantapa. Goyongä tömengä mïñæ̈ në godäni guiquënë gæ̈wænte wædinque tömëmö tä pe tä pe æ̈ninque tæcæ cæncæ cædäni. ");
INSERT INTO aucNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Adinque Paditeoidi guiquënë Itota ingante wæætë, —Bitö mïñæ̈ në godäni æbänö cædänii, ante cöwä aquënë. Ïñæmpa, Guëmanguïönæ ïñonte mänïnö baï cædämaï ïedäni, ante dodäni näni wææ angaïnö ante ëñënämaï inte ïïnäni ïñömö do cædänipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ante pïïñönänite Itota, —Mïnitö ïñæmpa docä Dabii wodi tönö godongämæ̈ godäni tönö gæ̈wænte wædäni ïninque tömengä æbänö cægacäï ante yewæ̈monte ongö incæte mïnitö ïñömö adämaï inte baï änewëmïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tömengä ïñömö Wængonguï oncönë go guiicantapa. Mänincönë, Wængonguï quï, ante në godönänique cænguï impa, ante wææ näni angaïnö baï cædinque tömënäni, Wængonguï quï, ante päö ñoncæ ñoncæ cædönänimpa. Incæte mänïï päö wïï Dabiidi cænguï ïnï incæ Dabii do cængantapa. Ayæ̈ tömengä tönö cægönäni adobaï godongämæ̈ cængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ayæ̈, Wængonguï quï, ante në godönäni ïñömö Wængonguï oncönë ñæ̈næncönë ïñömö önönæque näni cæbaï guëmanguïönæ ïñonte adobaï cædäni incæte wentamö entawënämaï önonque cæcædänimpa, ante Möitee wodi wææ yewæ̈mongacäimpa. Mïnitö ïñömö mänïnö ante adämaï inte baï änewëmïnipa töö, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Ayæ̈ apæ̈nebo ëñëedäni. Mïnitö, Wængonguï oncö ñæ̈næncö waa pönï ongoncompa, ante ayömïni edæ botö ñöwo mïnitö weca në ongömo guiquënë wïï Wængonguï oncö baï ongömo inte wïï önömoque ongömopa. Wæætë edæ nämä nö cædömo inte botö ïñömö edæ godömenque waa pönï ongömo apa quëwëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Incæte, Wængonguï ïïmaïnö ante apæ̈necampa. ‘Wængonguï quï, äninque mïni iya tänö ante pönömenque waa adinque botö në waadete mïni godö waa cædö ante godömenque waa abopa,’ ante Wængonguï angampa. Ïninque mïnitö ïñömö Wængonguï nänö angaïnö ante ëñëmïni inte baï ïïnäni wentamö mongæ̈nämaï ïñönänite, Mïni pante wæquinque mänömaï cæmïnipa, ante apænte pïïnämaï incædömïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Botö ïñömö Waobo në ëñagäïmo ïñömö Tæiyæ̈ Awënë ïnömo ïmopa. Ïninque botö në guëmanguïönæ Awënë ïnömo inte edæ, Guëmanguïönæ ïñonte edæ æbänö cæquïï, ante adobo në Ämo ïmopa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Äninque wadæ godinque Itota ïñömö Wængonguï angä näni ëñente yewæ̈mongainta ate oodeoidi näni odömöincönë go guiigacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mänïñömö nï cömampoingä a ongongä adinque Paditeoidi guiquënë, Itota wapiticæ̈ cæcä ïninque mönö mäo pïinte angæ̈impa, ante në änäni inte tömengä ingante änänitapa. —Guëmanguïönæ ïñonte wacä waa bacæcäimpa, ante cæedäni, ante Wængonguï wææ angantawo. ");
INSERT INTO aucNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ante Itota ingante äñönänite tömengä wæætë, —Guëmanguïönæ ïñonte waocä tömengä cæ̈ningä ontatodë goyæ̈ guii adinque mïni waocabo ïmïni incæ æcämë pædæ guiipote æ̈nämaï ïmaingää. ");
INSERT INTO aucNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Cæ̈ningä önonganque ïñongante waocä ïñömö waëmö pönï ingampa, ante adinque guëmanguïönæ ï incæte waodäni beyæ̈ cöwë waa cæcæ̈impa, ante ämo ëñëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Äninque nï cömampoingä ingante wæætë, —Pædæ pompobi, angä. Ëñëninque tömengä pædæ gopodinque æ̈mæmpo baï waa empocä bacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Adinque edæ Paditeoidi guiquënë wadæ godinque, Æbänö cæte tömengä ingante wæ̈nömö wænguingää, ante godongämæ̈ pönëninque tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tömënäni, Wæ̈nongæ̈impa, ante pönente tededäni wædinque Itota ïñömö wadæ gocantapa. Wadæ goyongä tæiyæ̈näni tee empo godäni ate wædinque tömengä godö cæcä ate në wënæ wënæ inte wæwënïnäni tömänäni waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ayæ̈ në waa badïnäni ïnänite, Mïnitö, Botö æbodö ïmo, ante mäo apæ̈nedämaï ïedäni, ante wææ angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ïninque Itaiya wodi Wængonguï beyæ̈ në apæ̈necä ïïmaïnö ante nänö yewæ̈mongaïnö baï ïinque cætimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wængonguï ïïmaï ante apæ̈necampa. Botö ïmote në cæquingä incæcäimpa, ante botö në apænte æ̈nongä ïñömö a ongongä aedäni. Adocä botö në waadedongä ïñongante botö tömengä ingante adinque watapæ̈ tobopa. Botö Önöwoca ingante da pönömo ænte ëwocadinque botö ïmo në cæcä ïñömö, Botö nö cæte apænte ancæboimpa, ante tömengä oodeoidi ïnämaï ïnäni ïnänite mäo apæ̈necæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Incæte tömengä wïï wæætedö wæætë pïincæcäimpa. Ogæ̈ tededämaï incæcäimpa. Waodäni taadö godinque tömengä dicæ Yæ yæ ante tedecä ëñënäniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Cæ̈wipa bede næ̈æ̈nimpa wä tadämaï ïnäni baï waocä wæwengä ïñongante tömengä adobaï në wæwengä ingante wido cædämaï ingampa. Ayæ̈ gongapæncade cömencaguï mïni tente tëëmämoque go adinque pï ongömönämaï ïnäni baï tömengä adobaï waocä wæntæye bayongante tömengä ingante godö pïïnämaï ingampa. Adocä botö ïmote në cædongä ingaingä inte tömengä në Awënë nänö baganca cöwë nöingä ante apænte äninque cöwë waa cæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayæ̈ botö ïmote në cædongä në Awënë bacä adinque wadäni oodeoidi ïnämaï ïnäni incæ, Tömengä ëmöwo beyænque mönö quëwengæ̈impa, ante pönencædänimpa,” ante Itaiya wodi Wængonguï beyæ̈ nänö yewæ̈mongaïnö baï Itota mönö Codito ñöwo ponte waa cæcä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mänïñedë wacä wënæ tönö quëwënongä inte babetamongä babetadecä badingä ïñongante wadäni tömengä ingante ænte mämönäni pongä adinque Itota godö cæcä ate tömengä awinca adinque në tedecä bacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Cæcä waa bacä adinque tömänäni, Æbänö cæcää, ante guïñente wædinque, “Awënë Dabii wodi pæ̈ingä wabänö ïmaingampa,” ante pönente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mänömaïnö ante wædäni ëñëninque Paditeoidi guiquënë, “Ïñæmpa wënæidi awënë Beedeboo tönö në cæcä ïnongä inte Itota wënæidi ïnänite wido cæbaingampa,” ante tedewënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wapiticæ̈ tömënäni pönënö ante ëñente wædinque Itota tömënäni ïnänite, “Awënë odeye nempo quëwënäni ïñömö näëmæ̈ wæætedö wæætë cædäni ïninque awënë odeye nänö ömædempote wæquinque tömënäni nämä ëwente cæbaïnänipa. Ayæ̈ adocönë owocabo incæ adoyömö godongämæ̈ quëwënïnäni incæ näëmæ̈ wæætedö wæætë cædäni ïninque tömënäni oncö woquinque näwæ̈ gobaïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ayæ̈ Tatäna nempo quëwënäni ïñömö edæ näëmæ̈ pïïninque wæætedö wæætë cædinque tömengä ingante wido cædäni ïninque Tatäna dicæ tömënäni awënë odeye ïmaingää. ");
INSERT INTO aucNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mïnitö, Beedeboo tönö cædinque Itota wënæidi ïnänite wido cæcampa, ante tedewëmïnipa. Mänïnö mïni änewënö näwangä ï baï mïnitö mïñæ̈ në godäni guiquënë æcänö tönö cæte wido cædänii. Ïninque mïnitö mïñæ̈ në godäni incæ mïni änewënö beyænque ante näëmæ̈ pïïninque mïnitö ïmïnite wæætë apænte äninque pïincædänimpa anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Botö ïñömö Wængonguï Önöwoca tönö cæte wënæidi ïnänite wido cæbo apa änewëmïni. Mänömaï ï ïninque botö Wængonguï Awënë Odeye ïnömo inte mïnitö weca do pömo aedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ayæ̈ apæ̈nedinque tömengä, “Në tæ̈ï pïñængä ingante wïï goto wïninque waocä ædö cæte tömengä oncönë guiite mäincoo ö ænguingää. Edæ në ëacä ingante bæi ongonte goto winte ate pö guiite ö æ̈näni baï botö ïñömö wënæ inte në bæi ongonte wido cæbo ïmopa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ayæ̈, “Botö tönö æcänö wïï godongämæ̈ cæcä ïñömö tömengä ïñömö edæ Baa ante botö ïmote pïinte cæcä ingampa. Ayæ̈ botö, Waodäni botö mïñæ̈ poncædänimpa, ante cæyömo waocä botö tönö wïï cæcä ïñömö tömengä wæætë botö mïñæ̈ poncæ cæyönänite tatodongä wadæ godänipa,” ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ayæ̈, “Ïninque apæ̈nebo ëñëedäni, angantapa. Mïni waocabo wënæ wënæ cæmïni incæ Mæmpo Wængonguï ingantedö ante babæ ante godö wïwa ämïni incæte Wængonguï wæætë tömänö beyæ̈ pönö ñimpo cæcä beyænque quëwencæmïnimpa. Wæætë edæ Wængonguï Önöwoca ingante babæ ante godö wïwa ämïni ïninque Wængonguï mänïnö ante cöwë ñimpo cædämaï incæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ayæ̈ botö Waobo ëñagaïmo ïñömote botö ïmotedö ante waocä pïïninque adodeque angä incæte Wængonguï godö ñimpo cæcä ate quëwencæcäimpa. Wæætë botö Tæiyæ̈ Waëmö Önöwoca ingantedö ante æcänö pïïninque babæ äna guiquënë tömengä inguipoga nänö quëwengäñedë incæ wænte ate nänö goyedë incæ Wængonguï tömengä nänö wënæ wënæ änïnö ante cöwë ñimpo cædämaï incæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ayæ̈ waomö mönö cædïnö ante awæ̈ incate baï impa, ante odömoncæte ante Itota ïïmaï ante apæ̈negacäimpa. “Awæ̈ æbänö ïwæ̈, ante ëñencæte ante mönö tömenca tä pete bete ëñengæ̈impa. Awæ̈ waïwæ̈ ïwæ̈ ïninque tömenca wainca incaquïwæ̈ impa. Wæætë awæ̈ baawæ̈ ïwæ̈ ïninque edæ tömenca baaca incaquïwæ̈ ïwæmpa, ante ëñengæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mïmönë mönö pönëmämo eyede tate baï tao godedinque mönö mänïmämoque ante pönëninque tedemompa. Ïninque mïnitö tæntæ pæ̈ïmïni baï ïmïni ïñömö wïwa cæte quëwëmïni inte mïnitö ædö cæte waa ante apæ̈nequïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ayæ̈ waa pönï mäincoo da wente ate tadonte æ̈näni baï cædinque në waa cæcä ïñömö mïmönë waa pönï nänö entawënïnö ante pönëninque waa pönï tedete waa cæcampa. Në wïwa cæcä guiquënë mïmönë wïwa nänö entawënïnö ante pönëninque wïwa tedete wënæ wënæ cæcampa.” ");
INSERT INTO aucNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Edæ apæ̈nebo ëñëedäni. Wængonguï tömengä nänö apænte anguïönæ ïñonte, Mänïne quïnante önonque tedebitawo, ante angä ëñëninque mïni waocabo edonque apæ̈nequënëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ïninque mïni tedepämo tömämämo ante Wængonguï apænte äninque edæ pancamïniya ïmïnite ñimpo cædinque edæ pancamïniya ïmïnite, Mïni panguinque tedewëmïnipa, ancæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Apæ̈necä ëñëninque në odömönäni tönö Paditeoidi pancadäniya Itota ingante apæ̈nedinque, —Awënë në Odömömi ëñëmi. Pönencædänimpa, ante mä cæte bitö odömönö ante mönitö aïnente wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Äñönäni Itota wæætë, —Mïni në wïwa cæcabo inte Wængonguï ingante ëmö cæte pangote baï mïni wadæ godincabo ïñömö mïnitö, Mä cæte odömömi adinque pönëmaïmönipa, ante ancaa ämïni awædö. Näwangä ämo ëñëedäni. Ñöwomïni ïmïnite mä cæte odömönämaï ingæ̈impa. Cönäö wodi beyæ̈ nänö cægaïnö ante edæ mäninque mïni aquinque cæcæ̈impa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mëönaa go adoönæque ïñonte gæyæ cæncadë Cönäö wodi nänö ongongaï baï edæ botö adobaï Waobo ëñagaïmo inte edæ mëönaa go adoönæque adopoönæ wao wodido ongoncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cönäö wodi Wængonguï beyæ̈ apæ̈necä ëñëninque Nïnebaidi wënæ wënæ näni cægaïnö ante ñimpo cædinque Wængonguï gämæ̈nö pongadänimpa. Cönäö wodi wædangä ïñongante botö në ñæ̈næ̈mo inte nö ante apæ̈nebo ëñëninque mïnitö wæætë ëñënämaï ïmïnipa. Ïninque Nïnebaidi Wængonguï gämæ̈nö në pongaïnäni incæ Wængonguï në apænte angä weca pöninque mïni ñöwo quëwencabo tönö godongämæ̈ gongænte ongöninque, Mïni panguinque ëñënämaï ingamïnimpa töö, ante apænte pïïnänidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ayæ̈ adobaï betamonca gämæ̈nö ömæ awënë onquiyængä ïñömö awënë Tadömöö wodi nanguï ëñente nänö apæ̈nedö ante ëñencæte ante doönæ quëwëninque pongacäimpa. Tadömöö wædænque ëñengä ïñongante botö godömenque nanguï ëñëmo inte mïnitö weca ongöñömote mïnitö ïñæmpa wïï ëñëmïnipa töö. Ïninque mäningä onquiyængä incæ Wængonguï në apænte angä weca pöninque mïni ñöwo quëwencabo tönö godongämæ̈ ongöninque, Mïni panguinque ëñënämaï ingamïnimpa töö, ante apænte pïincæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ayæ̈ apæ̈nedinque Itota ïïmaï ante apæ̈necantapa. “Waocä baönë owote ate tao godinque wënæ ïñömö edæ, Quingänö baönë go guiidinque edæ guëmante quëwenguïmoo, ante diqui diqui minte ayongä önömæca to aminte ï ate wædinque edæ, ");
INSERT INTO aucNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Botö tao godincönë adodö go guiite quëwencæboimpa,’ ante pönëninque adodö pongampa. Ponte ayongä waocä önonganque bayongante wacä önöwoca tömengäa owodämaï ingä adinque wënæ wæætë, Æ waocä botö owodincö baï ïnongä inte ñöwo önonconque baï wadæ ñëmænte mäincoo cabo të gæte baï ömæwocacä ingä abopa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ante adinque tömengä wæætë godinque wënæidi godömenque wïwa cædäni tiæte ganca mänimpodäni ïnänite ænte pongampa. Tömënäni tömänäni waocä baönë godongämæ̈ pö guiite owodäni ate waocä ïñömö wënæ yewæ̈ninque godömenque wæwengampa. Ñöwomïni guiquënë wïwa mïni cæcabo adobaï bate wæwencæmïnimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Itota oncönë a ongöninque nanguï ïnäni ïnänite apæ̈neyongä tömengä nänö biwïidi tönö tömengä wäänä tömengä ingante bee tente apæ̈necæte ante oncodo ponte a ongönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Adinque wacä äñecæ ponte apæ̈necantapa. —Bitö badä bitö biwïidi bitö ïmite apæ̈necæte ante oncodo ponte yabæque ongönänipa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Äñongante Itota wæætë, —Botö badä ædänö ïnää ante ämoo. Ayæ̈ botö biwïidi ædänidö ïnänii ante ämoo, ante pönëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Äninque, Itota tömengä mïñæ̈ në godäni gämæ̈nö oo cæmöninque, —Ïïnäni ïñömö botö badäidi botö biwïidi ïnönäni ïnänipa, ante mänömaïnö ämo abaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mönö Mæmpo öönædë në quëwengä nänö änö baï ëñente æcänö cæte quëwëna mäningä edæ botö biwï ingampa. Mäningä botö biwinque ingampa. Mänïnä botö badä ïnampa, ante pönencæboimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mänïönæ edæ Itota oncodo tao godinque gäwapæ̈ wedeca godinque tæ̈ contagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tömengä nänö tæ̈ contate ongöñömö nanguï ïnäni tömäo goto ponte ongönäni adinque tömengä wæætë wipodë go guiite tæ̈ contate wäï wocænte owoyongä tömënäni ayæ̈ gäwapæ̈ yæwedecaque ömaaque ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ayæ̈ ömaaque ongönäni ïnänite apæ̈nedinque tömengä, Wængonguï Awënë nempo quëwëninque æbänö cæquïï, ante ëñencæmïnimpa, ante botö ïmæca quëwënäni näni cædönö ante odömonte apæ̈nebo ëñëedäni. Äninque Itota nanguï apæ̈necantapa. “Waocä në quiyacä ïñömö quiyacæ gocampa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Gote quiyayongä pancamonga taadö ïñömö wææ̈mompa. Taadö wæænte eyepodïmö öñöñonte ayamöidi pöninque dobæ ade cæ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pancamonga guiquënë dicamontaa onguipoi woyedömö ïñömö eyepote wææmpa. Onguipoi woyedömö öñömö inte pæquïnämaï quingæ̈ tä bocate pædinque æ̈monga æipa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Edæ guingo icate æ̈mæ̈wo näñe wæmpa. Ïninque oguïmento yæyæ̈më guiwadämaï inte cöñe bawadämaï ïñonte nænque tï näwäñö wänä cacadinque edæ guingo icate näñe wæmpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pancamonga guiquënë ömentacodë nänö eyepodïmö ïñömö pæquïnämaï tä bocate gä æiyonte ömentacoo pö incootonque ganta cæca ate näñe wæmpa. Wampo incapa pæquïï. ");
INSERT INTO aucNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waëmonguipoga quiyadïmö guiquënë tä bocate waa pædinque tömëmö nanguï pönï incapa. Incate pancawæncaa tiëë ganca, pancawæncaa tetenta ganca, pancawæncaa todëinta ganca mänimpomö incapa. Quiyacä nänö quiyadö ante edæ botö mäninque ante apæ̈nebopa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ëamonca ongonte ëñëedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ayæ̈ tömengä mïñæ̈ në godäni tömengä weca ponte apæ̈nedinque, Itota ëñëmi. Bitö tömënäni ïnänite inguipoga quëwënäni näni cæïnö ante odömöninque quïnante mäninque ante odömonte apæ̈nebitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Äñönänite Itota, “Öönædë Awënë Odeye nempo æbänö quëwenguïï, ante mïni waocabo wëënëñedë mïni ëñënämaï ingaïnö ante botö ñöwo mïnitö ïmïnite pönö edonque apæ̈nebo ate mïnitö adomïnique në ëñëmïni bamïnipa. Wæætë tömënäni ïnänite guiquënë botö mänïnö ante godö apæ̈nedämaï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Edæ në ëacä ingante godönäni nänö godömenque æ̈ï baï botö në ëñengä ingante godö apæ̈nebo ate tömengä godömenque waa pönï ëñente bacæcäimpa. Wæætë në ömæpocä ïnongä ingante wædænque nänö ëadï incæ ö æ̈näni baï në ëñënämaï ingä guiquënë adobaï wædænque nänö ëñënö incæ ö ænte baï ëwente baï baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Incæte edæ awincaque adinque në adämaï ïnäni inte tömënäni önömoncaque ëñëninque në ëñënämaï ïnäni inte pönënämaï ïnänipa. Ïninque botö, Wængonguï Awënë nempo æbänö quëwenguïï, ante ëñënämaï incædänimpa, ante cædinque ïmæca quëwënäni näni cæïnonque ante odömonte apæ̈nebopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Edæ Wængonguï beyæ̈ apæ̈nedinque Itaiya wodi ïïmaï ante nänö yewæ̈mongaïnö baï ñöwo quëwënäni incæ ïinque cædänipa. ‘Näwangä ëñencæte ante cædinque mïnitö önömoncaque ëñëninque pönënämaï ïmïni inte ëñënämaï incæmïnimpa. Näwangä acæte ante cædinque mïnitö awincaque adinque wæætë pönënämaï ïmïni inte adämaï incæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mänïnäni, Wïï aïnëwædö, ante awinca mönæ guimonte baï cædinque, Önömonca wïï ëñëïnëwædö, ante tee mömoncate baï cædinque, Mïmönë wïï pönëïnëwædö, ante mïmö ömædë ïnäni ïnänipa. Wïï mänömaï ï baï tömënäni awinca adinque önömonca ëñëninque mïmönë pönencædönänimpa. Ayæ̈ tömënäni näni waa baquinque edæ dadi ëmæ̈ninque botö gämæ̈nö poncædönänimpa.’ Ante Itaiya wodi nänö angaïnö baï ïinque cætimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ante Itota tömengä mïñæ̈ në godäni ïnänite apæ̈necantapa. “Mïnitö guiquënë awinca do adinque önömonca do ëñëninque mïni toquinque impa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Näwangä ämopa. Wængonguï beyæ̈ në apæ̈negaïnäni tönö në nö cægaïnäni tönö ñöwo mïni adö ante nanguï aïnente wædäni incæte adämaï ingadänimpa. Ayæ̈ mïni ñöwo ëñënö ante nanguï ëñëïnente wædäni incæte ëñënämaï ingadänimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Itota ayæ̈ tömënäni ïnänite godömenque apæ̈necantapa. “Mänïï quiyacä nänö quiyaïnö ante apæ̈nedinque botö, Wængonguï Awënë ingante æbänö ëñenguïï, ante odömoncæte ante apæ̈neyömo mïnitö ëamonca ongonte ëñëedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Awënë Wængonguï Odeye nempo æbänö cæte quëwenguïï, ante mönö apæ̈nedö ante önömoncaque ëñëninque waocä mïmöno pönënämaï ingä ïninque tömengä mïmöno nänö ëñënïnö incæ wënæ në wïwa cæcä ïnongä inte pö ö ængampa. Mäningä në pönënämaï ingä ïñömö taadö wedeca eyepodïmö baï ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Woyedömö dicamontaa eyepodïmö baï ingä guiquënë tömengä Wængonguï nänö apæ̈nedö ëñëninque quingæ̈ Ao ante watapæ̈ tocampa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ayæ̈ ate adocä incæ tömëmö woyedömö baï oguïmento yæyæ̈më guiwadämaï baï ingä inte wantæ ïñö quëwengampa. Wængonguï nänö apæ̈nedö beyæ̈ pïïnäni wæyongä tömengä ingante wënæ wënæ cæcæte ante togæ̈näni ate wædinque tömengä guïñente wædinque edæ ëmö cæte gocampa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ayæ̈, “Ömentacodë wæænte pædïmö baï ingä guiquënë tömengä ëñëninque godömenque quëwëñongä inguipoga quëwente quïëmë beyænque mönö wæpämo pöninque ayæ̈, Mäincoo beyænque toquïmo, ante näni oda cæte wæwëmämo pöninque ömentacoo ñancate cæ baï cæyonte Wængonguï nänö apæ̈nedïnö incæ incadämaï baï bapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Onguipoga wainguipoga quiyadïmö baï ingä guiquënë tömengä Wængonguï nänö apæ̈nedö ëñente wede pönëninque edæ tömëwæ̈ incate baï Wængonguï beyæ̈ nanguï cæcampa. Pancadäniya edæ tiëë ganca incate baï nanguï cædänipa. Wadäni guiquënë tetenta ganca incate baï cædänipa. Ayæ̈ wadäni todëinta ganca incate baï cædänipa,” ante Itota apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ayæ̈ wæætë inguipoga quëwënäni näni cæïnö ante odömöninque Itota godömenque apæ̈negacäimpa. “Öönædë Awënë Odeye ïñömö gönea tömëmö waïmö në quiyacä baï ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tömengä quiyate gocä ate waodäni mö ñöñönäni wacä në pïinte cædongä inte wæætë tömengä nänö quiyadïñömö awëmö ponte, Ömentacoo pæcæ̈impa, ante adoyömö pönö nï quiyate wadæ gocä. ");
INSERT INTO aucNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ate waïmö tänä nä bocate waïwæ̈ pædinque tömëmö incayö adoyömö tæcæguedë ömentacoo pæ. ");
INSERT INTO aucNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Adinque në cædäni guiquënë në ëacä weca pöninque, ‘Awënë, bitö gönea quiyadïñömö tömëmö waïmö mïnämaï ïmitawo. Ædönö ponte ömentacoo adoyömö pæ, ante wæmönipa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ante äñönäni, ‘Wa. Mönö pïinte änongä cæbaingampa. Wabänö ïï.’ Ante pönëñongä tömënäni, ‘Ïninque bitö ämi godinque abæ wiquïmöni, ämitawo.’ ");
INSERT INTO aucNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Änäni ëñëninque në ëacä wæætë edæ, ‘Ïñæmpa mänömaï cæmïni ïninque waïwæ̈ tönö ömentacoo guëa abæ wite babaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ïninque mïnitö ñöwo edæ ömæ widämaï inte to amïña peganca ee amïni guëa pæcæ̈impa. Amïñayedë edæ në pedäni ïnänite botö, Ömentacoo täno të gæte topo cæte iya täninque tömëmö waïmö guiquënë tä pete mämö ñönöedäni, ancæboimpa,’ ante në ëacä apæ̈necampa.” Mänömaïnö ante odömoncæte ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ayæ̈ wæætë inguipoga mönö adö ante odömöninque Itota godömenque apæ̈nedinque, “Waocä möotatamö tömëmö ænte mäo tömëmoncodë quiyacä bocate pæ amïnitawo. Mänïmö guidïmö inte ñæ̈næ̈ pæ baï Wængonguï Awënë Odeye nempo mïni quëwencabo ïñömö adobaï yebænte pæpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Edæ möotatamö mïni ænte quiyamö guidïmö pönï ï baï wamö mïni quiyamö adomonque incæ adobaï guiyämö pönï ï ïñömö edæ dæ ampa. Incæte möotatamö ïñömö tä bocate pædinque möotatawæ̈ edæ ocäñequi doyæ̈ pæwæ̈ bapa. Wïï tömää ocäñequi mïni quiyadïwæ̈ baï edæ ocäa ïnämaï inte möotatawæ̈ ïñömö edæ ñæ̈næ̈ awæ̈ ï adinque ayamöidi ponte awæ̈nëmæ̈ ongönänipa. Möotatamö guidïmö incæ mänömaï pæ baï Wængonguï Awënë nempo quëwënäni ïñömö wædænque ïnïnäni incæ nanguï yebænguïnäni ïnänipa,” ante odömöninque Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ayæ̈ wæætë inguipoga quëwënäni näni cæïnö ante odömöninque Itota godömenque ïïmaï ante apæ̈necantapa. “Päö yedæ æmpocæ̈impa, ante onquiyængä ñæ̈nængade tee manguincade ænte tee mäninque ædïna näni ämö ænte mempoga go adopoque da wëninque ayæ̈ yedæ æmpoquï ænte pönö da wëninque wempo wempo ædæmö cædengä ate päömo yedæ æmpote tömäo näämænta bapa. Yedæ æmpote ate päömo tömäo näämænta ba baï öönædë Awënë Odeye nempo mïni quëwencabo ïñömö tömämïni nö ëñente bamïnipa,” ante odömöninque Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nanguï ïnäni mänïñömö ongönäni ïñönänite Itota inguipoga quëwënäni näni cæïnö ante odömöninque mäninque ante tömënäni ïnänite apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Edæ Wængonguï beyæ̈ në apæ̈negaingä ïïmaïnö ante doyedë apæ̈negacäimpa. “Wængonguï æbänö cæcää, ante botö inguipoga quëwënäni näni cæïnö ante odömöninque botö ïñæ̈ æ̈nete apæ̈necæboimpa. Wængonguï nänö badongaïñedë ayæ̈ godömenque ñöwo ganca nänö wë wodonte ëñengaïnö ante botö ñöwo apæ̈necæboimpa,” ante docä nänö angaïnö baï ñöwo ïñömö ïinque cæquinque Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ayæ̈ nanguï ïnäni ïnänite ëmö cæte godinque Itota oncönë pö guiicä adinque tömengä mïñæ̈ në godäni guiquënë tömengä ingante mämö änänitapa. Gönea ömentacoo quiyadincoo ante apæ̈nedinque bitö æbänö ante odömoncæte ante apæ̈nebii. Edæ edonque apæ̈nebi ëñëmönie. ");
INSERT INTO aucNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Äñönänite tömengä, “Tömëmö waïmö në quiyadingä botö äningä ïñömö botö Waobo ëñagaïmo inte mäningä baï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gönea botö änïñömö baï ïinguipo impa. Tömëmö waïmö botö änïmö baï ïnäni guiquënë Awënë Odeye ingante näni ëñencabo ïnänipa. Ömentacoo botö änincoo baï ïnäni guiquënë wënæ inte në ëñënäni ïñönäni ");
INSERT INTO aucNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","në pïinte quiyacä botö äningä baï ïñömö edæ wënæidi awënë ingampa. Amïña baï guiquënë inguipoga ïinque bayedë ingæ̈impa. Ayæ̈ amïña tä pete baï cædäni guiquënë Wængonguï anquedoidi ïnänipa.” ");
INSERT INTO aucNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ïninque edæ näni amïña bayedë ömentacoo të gæte topo cæte näni iya täï baï edæ adobaï ïinque bayedë baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mänïñedë edæ Waobo ëñagaïmo inte botö anquedoidi ïnänite ämo pöninque tömënäni gönea ïñömö ömentacoo të gæte baï cæcædänimpa. Botö nempo quëwënäni pancadäniya oda cæte ëñënämaï cædänipa. Ïninque, Oda cæcædänimpa, ante në cædäni tönö në ëñënämaï cædäni tönö tömänäni ïnänite botö anquedoidi ïñömö abæ wite baï të gæte mäo, ");
INSERT INTO aucNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","gongapamö näni ämogate Ca ca wæyömö wido cæcædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mänïñedë edæ në nö entawëmïni guiquënë mönö Mæmpo Awënë Odeye ïñongä tömengä nempo në quëwëmïni ïñömö edæ nænque tamö guïnæ̈ gongæ̈ baï adobaï guïnæ̈ edæ gongæncæmïnimpa. Ëamonca ongonte ëñëedäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Godömenque odömöninque Itota ïïmaïnö ante apæ̈necantapa. “Öönædë Awënë Odeye nempo mïni quëwencabo ïñömö waëmoncoo onguipodë æ̈æ̈ wote näni wë wodonte mänincoo baï impa. Waocä gote mänincoo adinque adodö æ̈æ̈ wote æ̈ninque wayömö wë wodongampa. Wodonte ate tömengä watapæ̈ todinque tömengä ëadincoo tömancoo godonte eyepæ̈ æ̈ninque tömengä waëmoncoo nänö wë wodönïmæ æncæte ante ömæ në ëadingä weca do godinque mänïmæ tömämæ beyæ̈ ante edæ eyepæ̈ pædæ godöninque ængampa. Waocä mänömaï tömengä ëadincoo tömancoo nänö godönï baï cædinque öönædë Awënë Odeye ïñömö, Botö nempo quëwencæmïnimpa, ante tömengä Wëñængä ingante eyepæ̈ godöninque inguipoga tömäo quëwënäni ïnänite ængacäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ayæ̈ godömenque, “Öönædë Awënë Odeye nempo guiicæte ante cæcä ïñömö wamoncoo pededamö näni ämoncoo godonte æncæte ante në diqui diqui mingä baï ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ïninque wamö pededamö nänö æ̈ïnënïmö adomonque waëmö pönï ï ate tæcæ adinque waocä wadæ gote tömengä nänö ëadincoo tömancoo godonte eyepæ̈ æ̈ninque wæætë mänïmö wamö incæ godonte ængampa,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ayæ̈ wæætë edæ, Öönædë Awënë Odeye ïñömö edæ dicamöñæ̈ gäwapæ̈ näni dadöï baï tömää gæyæidi ænte baï cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dicamöñæ̈ eyede dadöninque yæwedeca wëä manta cönöninque tæ̈ contate apænte adinque, Näwäaquingä ï, adinque ö æ̈ otodë da wëninque, Baacä ï, adinque wido cædäni baï Wængonguï Awënë adobaï cæquingänö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Edæ ïinque bayedë Wængonguï anquedoidi pöninque në nö cædäni ïnänite apænte æ̈ninque në wïwa cædäni ïnänite adinque nänënë gönongä ");
INSERT INTO aucNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ongöñönänite gongapamö edæ guitodongä guiicædänimpa. Tömënäni edæ mänïñömö guiite ongöninque ämogate wædinque Ca ca wæcædänimpa,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mänïnö ante ïinque odömonte apæ̈nedinque Itota tömënäni ïnänite, —Botö odömonte apæ̈nedö tömänö ante edonque ëñëmïnitawo. Äñongante, —Ao ëñentamönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ante apæ̈nedäni ëñëninque tömengä apæ̈necantapa. —Ïninque æcänö, Öönædë Awënë Odeye æbänö cæcää, ante ædæmö ëñëninque në odömonte apæ̈neda ï tömengä ïñömö waëmoncoo në da wente mangä baï adobaï ïnongä inte Wængonguï nänö änö ante entawengä ingampa. Ayæ̈ edæ në ëacä nänö da wënincade wi æ̈nedinque mïincoo tönö pedæncoo tadonte odömongä baï në odömonte apæ̈necä ïñömö adobaï cæcampa. Edæ doyedë nänö ëñënö incæ ñöwo nänö ëñënö incæ mïmönë waa pönï nänö entawënö ante edonque odömonte apæ̈necampa, ante Itota mäninque ante idæwaa apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wængonguï Awënë æbänö cæcää, ante odömoncæte ante ïmæca quëwënäni näni cæïnö ante nänö odömönïnö tömänö ante ïinque apæ̈nedinque Itota wadæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tömengä nänö pægaïñömö ponte tömënäni odömöincönë pö guiidinque mänïñömö quëwënäni ïnänite odömonte apæ̈necantapa. Ëñëninque tömënäni ancai guïñëninque, —Ïingä ïñæmpa, æbänö cæte nanguï ëñengä ingää, änänitapa. Tömengä edæ æbänö cæte tæ̈ï pïñæ̈ninque bamönengæ̈ cæcää, ante ëñencæte ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ïingä ïñæmpa awæmpa në tïmöwengä wengä ïmaingä inte bamönengæ̈ mänömaï cæcampa, ante awædö. Tömengä wäänä ëmöwo Mäadiya ingampa, ante awædö. Tömengä biwïidi önönänique Tantiago tönö Ootee, Timönö tönö Codaa ïnämaï ïnänitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tömengä biwinqueidi mönitö tönö tömänäni ongönäni aedäni. Ïninque tömengä wæætë æbänö cæte nanguï ëñengä badinque edæ nanguï cæcää. ");
INSERT INTO aucNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ante pönente wædinque tömënäni tömengä beyæ̈ ante pïinte badänitapa. Pïinte badäni adinque Itota tömënäni ïnänite angantapa. —Ïñæmpa Wængonguï beyæ̈ në apæ̈necä ïñömö tömengä tömämæ gote apæ̈neyongante tömengä ingante waa adänipa. Wæætë tömengä nänö pægaïñömö pöninque oncönë pö guiite apæ̈neyongä edæ mänïñömonque tömengä ingante wïwa adänipa töö, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Incæte, Pönënämaï ïñönänite botö ædö cæte nanguï mä cæquïmoo, ante pönente wædinque tömengä tömënäni weca edæ wædænque pönï cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tömänäni mänïñedë, Itota æbänö cæcää, ante mäo änäni ëñëninque pancabaa awënë Edode do ëñengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tömengä ïñömö tömengä ingante në cædäni ïnänite apæ̈necantapa. “Wäö wodi æpæ̈në në guidöningä incæ ïingä Itota ïñömö adocä inte a ongongä awædö. Tömengä do wænte ñäni ömæ̈möninque pongampa töö. Mänïnö beyænque tömengä tæ̈ï pïñænte entawënongä inte në nanguï cæcä ingampa,” ante awædö, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wäö wodi ïñömö ïïmaï wængacäimpa. Do ïñedë awënë Edode ïñömö tömengä biwï Pedipe manguïwëningä Ædodiya ingante ö ænte möningä ïnongäimpa. Mäningä Ædodiya Wäö ingante pïingä beyænque Edode ïñömö Wäö ingante bæi ongonte goti winte tee mönedongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Edæ Wäö ïñömö nänö caate wænguinque Edode ingante ïïmaïnö ante do wææ äningä ïnongäimpa. “Edode ëñëmi, bitö Wængonguï nänö angaïnö baï ëñënämaï inte edæ mäningä onquiyængä ingante manguïwëmipa töö,” ante cöwë wææ äningä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Angä ëñente pïïninque Edode, Wäö ingante botö æbänö cæte wæ̈nonguïmo, ante cædongäimpa. Incæte tömänäni, Wængonguï beyæ̈ në apæ̈nedongä Wäö ingampa, ante tededäni ëñëningä inte Edode, Botö ïmote pïïnäni wæcæ wæ, ante guïñente wædinque Wäö ingante wæ̈nönämaï inte ata cæpodongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Incæte Edode nänö ëñagaïönæ ïinque bayö wadäni ponte godongämæ̈ bete ayönäni edæ Ædodiya wengä baquecä tode pete äwacä adinque Edode wæætë nanguï todongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ïninque tömengä, Wængonguï ayongä näwangä ämopa, ante baquecä ingante änongäimpa. Waa pönï bitö tode pete äwadï beyæ̈ bitö quïëmë ante æ̈ïnente ämi adinque botö bitö änö ante cöwë pönömo æncæbiimpa, änongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Angä ëñëninque baquecä wæætë wäänä weca gote, Æbänö anguïmoo, ante äñongä wäänä guiquënë, Ïïmaï äe, angä ëñëninque baquecä wæætë Edode ingante, —Ïïmaï pönö cæbi æ̈moe. Wäö æpæ̈në guidönongä ingante wangö tamencate tömengä ocabo ïnï coyomënætaca cö cæte ænte mämö pædæ pönömi æ̈moe. ");
INSERT INTO aucNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Angä ëñente wædinque awënë odeye ïñömö, Æ ëñente awædö. Quïnö ñöwo cæquïmoo, ante nanguï wædongäimpa. Incæte godongämæ̈ becönäni ëñëñönänite, Wængonguï ayongä cöwë godoncæboimpa, ante në äningä inte në wæ̈nongä ingante tömengä, Baquecä nänö änïnö baï cæedäni, änongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Angä ëñëninque në wæ̈nongä tee möneincönë go guiidinque edæ Wäö ingante mäo bæi ongöninque wangö tomencadongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ayæ̈ Wäö ocabo ïnï coyomënætaca cö cædinque baquecä weca ænte mämö pædæ pönönäni æ̈ninque baquecä wæætë wäänä ïnante godongä æ̈nönäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ayæ̈ Wäö wodi tömengä mïñæ̈ në godïnäni pöninque tömengä baö ïnï ænte mäo daga wëninque wæætë Itota weca pöninque, Wäö wodi mänömaï wængä wæmönipa, ante tömengä ingante apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wäö wodi do wængäimpa, ante apæ̈nedäni ëñente wædinque Itota wæætë edæ, Önömæca gocæboimpa, ante wipodë guii contate wogaa gocantapa. Gocä ate, Mänïñömö gocæ cæcampa, ante tededäni ëñëninque tæiyæ̈näni tömënäni näni quëwëñömö wacönë ta wacönë ta ömaaque oo pænta täno gote mæ̈ ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Itota ïñömö wipodë wogaa pö ti wæænte ayongä nanguï ïnäni dobæ ponte mæ̈ ongönäni adinque, Æbänö cæte quëwenguïnänii, ante tömënäni tönö godongämæ̈ wæte baï pönengantapa. Ayæ̈ daicawo gawæ̈näni ïnänite godö cæcä ate waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gäwadecæ̈ bayö tömengä mïñæ̈ në godäni tömengä weca pöninque, —Ñöwo wëmö bacæ cæpa cæbii, änänitapa. Ayæ̈, Önömæca incæ cænguï dæ ä adinque bitö godongämæ̈ ongönäni ïnänite ämi waodäni quëwëñömö gote cænguï godonte ænte cæncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Äñönänite Itota, —Goquïnäni, ante quïnante ämïnii. Mïnitö wæætë godömïni cæncædänimpa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Äñongante, —Ïñæmpa päö önompo æ̈mæmpoque gæyæ mëa pönï ï. Cænguï næ̈æ̈mönipa diyæ̈ godömöni cænguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ante wææ äñönäni Itota ïñömö, —Mänimpodänique næ̈æ̈mïni incæ ænte mämö pædæ pönömïni æ̈moedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ayæ̈ godongämæ̈ mæ̈ ongönäni ïnänite angä gaguïmäa tæ̈ contadäni ate tömengä päö önompo æ̈mæmpoque gæyæ mëa æ̈ninque öönædë ïnö æ̈mö adinque, Wængonguï, bitö waa pönömi ænte cæ̈mönipa. Ante apæ̈nedinque päö pä æ̈ pä æ̈ cædinque tömengä mïñæ̈ në godäni ïnänite pædæ pönongä æ̈ninque tömënäni wæætë godömenque tömänäni ïnänite di mæ̈ñæ̈ di mæ̈ñæ̈ cædäni ænte cæ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mänömaï pönö cæcä æ̈ninque tömänäni tömo pönï cæ̈nänitapa. Cænte ate edæ tömënäni ao mæ̈ ao mæ̈ näni ñönönï ee öñoncoo pædæ wææmpo ö æ̈ da da wente æ̈ninque tömengä mïñæ̈ në godäni ïñömö otodë önompo tipæmpoga go mentodëa cænguï eyede da wënäni contagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Në cæ̈näni ïñömö edæ onguïñæ̈nänique incæ tinco mïido ganca mänimpodäni ïñönäni onquiyæ̈näni tönö näni wencabo tönö godömenque nanguï ïnäni inte cængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tömänäni ïinque cæ̈näni ate Itota tömengä mïñæ̈ në godänique ïnänite do angantapa. Mïnitö täno wipodë guii contate æ̈mæ̈ wedeca tao goyömïni botö wæætë godongämæ̈ ongönäni ïnänite ämo godäni ate ayæ̈ poncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Angä Ao ante tao goyönäni tömengä wæætë wadäni ïnänite, Ñöwo goedäni, angä wadæ godänitapa. Ayæ̈ tömengä Wængonguï ingante apæ̈necæte ante änanquidi æicantapa. Æite apæ̈nedinque wëmö bayö tömengä adocanque a ongongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tömengä mïñæ̈ në godäni guiquënë taocæte ante cædinque edæ tæcætibæ wiyate cæwoyönäni edæ woboyæ̈ pæ̈mænte nanguï pöñö edæ æpæ̈ incæ incæ cæte mængonta mængonta cæyonte wipo wäï wocæntapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ayæ̈ tawadiya nänö peyedë bayonte edæ Itota ïñömö æpæ̈ yædopæ̈noque edæ dao dao pongä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yædopæ̈no edæ dao dao pongä gomö adinque tömengä mïñæ̈ në godäni edæ ancai guïñëninque, —Quïëmë ïmaï. Waocä wænte babæ̈ningä wabänö cægongä, ante Yæ ante guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ante wæyönäni edæ Itota ïñömö, —Ee piyæ̈në cæte guïñënämaï ïedäni. Botö ïmo apa guïñëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ante äñongä, Pegodo guiquënë, —Awënë, bitö ïmitawo. Nö nö ïmi inte bitö æpæ̈ yædopæ̈ bitö weca ämi pömoe. ");
INSERT INTO aucNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Angä ëñëninque, —Pöe. Äñongä Pegodo wipodë ongöninque edæ ti wææ̈ninque yædopæ̈no edæ dao dao gote Itota weca tæcæ obo ponte ayongä, ");
INSERT INTO aucNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","woboyæ̈ nanguï nanguï pæ̈mæ̈ ate wædinque ancai guïñëninque æpæ̈në tæi guiidinque Yæ wæcantapa. —Awënë, æpæ̈ bete wæncæbointaye. ");
INSERT INTO aucNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ante wæcä adinque Itota tömengä ingante edæ quingæ̈ pædæ gopo töö æ̈mæ̈ninque, —Ïñæmpa botonque ïñömote pönëninque pöe, antabopa. Quïnante wapiticæ̈ edæ pönëmitapa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ayæ̈ wipodë guiida ate woboyæ̈ ïñontobæ̈ næ̈ pæ̈mæ̈nämaï gongæ̈. ");
INSERT INTO aucNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Adinque wipodë ongönäni wæætë Itota weca ædæ wæænte apæ̈nedinque, —Näwangä bitö Wængonguï Wëñæ̈mi ïnömi ïmipa, ante watapæ̈ apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ayæ̈ æ̈mæ̈mäa taodinque tömënäni Guënetadetebæ ti wææ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti wææ̈näni adinque mänïömæ quëwënäni guiquënë, Tömengä Itota ingampa, ante do adinque tömämæ mäo gode ä gode ä cædäni ëñëninque wënæ wënæ ïnäni ïnänite tömänäni ïnänite tömengä weca ænte mämönäni pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Itota ingante, Bitö weocoo ämi yæwedecooque gampote waa bacædänimpa. Änäni wædinque tömengä Ao angä ëñëninque në gampo gampo cædäni ïñömö tömänäni edæ waa ïnäni bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dodäni näni wææ angainta ate në odömönäni tönö Paditeoidi pancadäniya Eedotadëë quëwëninque mänïñedë Itota weca pöninque ïïmaï änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Bitö mïñæ̈ në godäni ïñömö dodäni näni angaïnö ante quïnante ëñënämaï inte wapiticæ̈ cædäni wæmönipa. Tömënäni ïñæmpa mempodämaï inte wentamö nampote cænguï cæ̈näni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ante pïïnäni wædinque Itota wæætë, —Mïnitö guiquënë dodäni näni angaïnonque ante ëñente cæcæte ante cædinque Wængonguï nänö wææ angaïnö ante edæ quïnante ëñente cædämaï ïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wængonguï, “Bitö wæmpo ingante bitö badä ïnante waadedinque waa cæe,” angacäimpa. Ayæ̈, “Wæmpocä ingante wäänä ïnante në pïinte wïwa angä ingante wæ̈nömïni wæncæcäimpa,” ante wææ angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mïnitö guiquënë ïïmaï änewëninque edæ wææ cæmïnipa. Waocä mæmpocä ingante waa cæquënengä ïñongante wäänä ïnante adobaï waa cæquënengä ïñongante mïnitö wæætë wææ äninque, Waocä wæmpocä ingante wäänä ïnante ïïmaïnö ante apæ̈necæcäimpa, änewëmïnipa. Wæætë edæ “Mæmpo, bitö quï, ante, Badä, mïnö quï, ante botö pönömo mïna ænguënënö incæ ñöwo wæætë edæ, Wængonguï quï, ante do edæ godonte impa.” ");
INSERT INTO aucNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ante apæ̈nedinque waocä wæmpoda ïnate wïï godonguënengä ingampa, ante mïnitö ïñömö edæ wææ änewëmïni awædö. Ïñæmpa mänömaïnö ante wææ änewëninque mïnitö edæ dodäni näni angaïnonque ante cæcæte ante cædinque Wængonguï nänö wææ angaïnö ante edæ, Önöneque impa, ante baï cæmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mïnitö waa cæmïni inte baï në änewëmïni ïñömïnite edæ ämo ëñëedäni. Mïni cædö ante Wængonguï ïïmaï ante apæ̈necampa, ante Itaiya wodi nöingä ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ïïnäni ïñömö botö ïmote önöneque waa apæ̈nete baï tededäni incæte, tömënäni mïmöno æ̈mæ pönente edæ gobæ ongonte baï ïnäni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ayæ̈ botö weca ædæ wæænte waa ate baï tededinque tömënäni, Wængonguï ïmidö anguënë, ante önöneque tedewëninque önonque edæ cædänipa. Waodänique näni wææ änönö ante odömonte apæ̈nedänipa töö.” Ante Wængonguï pïingampa, ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mänömaïnö ante apæ̈nete ate Itota wæætë nanguï ongönäni ïnänite aa pecä pönäni adinque apæ̈negacäimpa. —Botö apæ̈nebo ëñëninque ocaidë pönente ædæmö ëñëedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Önönë guiidï beyænque waocä mïmö wentamö entawënämaï ingampa. Wæætë mïmönë wïwa pönëninque nänö önöne tao gode beyænque tömengä wentamö mongængampa, ante apæ̈nebo ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ante apæ̈necä ate tömengä mïñæ̈ në godäni ïñömö tömengä weca ponte änänitapa. —Bitö mänömaïnö ante apæ̈nebi ëñëninque Paditeoidi ïñömö guingo imonte pïïnäni apa änewëë. ");
INSERT INTO aucNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Äñönäni tömengä, —Awæ̈ botö Mæmpo mïnämaï ïwæ̈ to wite baï wido cæte bacæ̈impa. Paditeoidi ïñömö wïï botö Mæmpo quïnäni ïnönäni inte adobaï edæ wido cæte wæcædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Edæ babetamönäni baï ëñënämaï ïnäni inte tömënäni ïñömö wadäni adobaï babetamönäni baï ïnäni ïnänite në ænte mäodäni ïnäni apa cæmïnii. Tömënäni ïnänite gomö aedäni. Edæ babetamongä ingante wacä adobaï babetamongä ïnongä ingante ænte mäocä gocä ïninque tömëna näna babetamoncaya guëa ontatodë mongæncadæ̈ guiibaïnapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ante apæ̈necä ëñëninque Pegodo, —Mänömaïnö ante odömonte apæ̈nedinque bitö æbänö ante odömoncæte ante apæ̈nebitapa, ante apæ̈nebi ëñëmönie. ");
INSERT INTO aucNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Äñongante Itota, —Mïnitö incæ ocai ömæcadäni baï ïnömïni inte ëñënämaï ïmïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Edæ quincoomë önöne guiidincoo incæ cæncadë guiite ate goiwaa ogä mente wido cæte ba apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wæætë önöne waocä nänö tedewënö guiquënë mïmönë nänö wïwa pönënö beyænque tao godepa. Ïninque waocä önöwoca mänïnö beyænque wentamö ëwocacampa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Edæ waocä mïmönë nänö entawente taodïnö beyæ̈ wïwa ante pönengampa. Mïmönë nänö pïinte pönënö beyænque waocä godö wæ̈nongampa. Mïmönë towëïnente tömengä nänöogængä ïnämaï ïñongante godö mongampa. Ayæ̈ æcämenque ïñongante mïmönë towëïnente beyænque waocä godö mongampa. Mïmöno æ̈ïnente wædinque wacä quï awëmö ængampa. Mïmönë wïwa pönëninque wacä ingante godö babæ wapiticæ̈ apæ̈necampa. Ayæ̈ wacä ingante pïinte tedecampa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ïninque mïmöno tao godï beyænque waocä wentamö ëwocacampa. Wæætë mempodämaï inte nänö cæ̈nö beyæ̈ waocä wentamö ëwocadämaï ingampa, ante edæ Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mänïñömö quëwente wadæ godinque Itota Tido näni quëwëñömö Tidöö näni quëwëñömö eyequeï pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mänïñömö ponte quëwëñongä onquiyængä Cänaämæ në ëñate pædingä inte adoyömö quëwente tadinque tömengä weca pöninque aa pecantapa. —Awënë bitö Awënë Dabii wodi pæ̈ïmi ïnömi inte ëñëmi. Botö beyæ̈ pönö waadete waa cæe. Botö wëñængä onquiyængä wënæ inte quëwente wæwengampa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ante mänömaï aa pecä wædinque Itota pæ wëënecantapa. Pæ wëënecä adinque tömengä mïñæ̈ në godäni guiquënë tömengä weca pöninque wææ apæ̈nedänitapa. —Mönö mïñæ̈ tee empote Yæ yæ në änewënongä ingante ämi gocäe. ");
INSERT INTO aucNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ante wææ änäni ëñëninque Itota wæætë, —Cæ̈nïnäni obegaidi gueogæ̈ gote wæwënäni baï möni idægocabo adobaï inte wë wömonte wædäni adinque Mæmpo Wængonguï, Tömënänique ïnänite cæquïmi goquïmi, äninque botö ïmote da pönongä wïï pontawoo. ");
INSERT INTO aucNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Angä ëñëninque onquiyængä ïñömö wæætë Itota önöwa gäänë ædæ wææ̈ninque apæ̈necantapa. —Awënë, botö beyæ̈ cæbi waa bacäe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Äñongante Itota wæætë, —Wënäni cænguï inguënë waocä dicæ guintamöidi cænguï ante wææntodonguingää. Bitö edæ wabi ïñömite botö bitö beyæ̈ ædö cæte cæquïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Angä ëñente wædinque, —Awënë ïñæmpa në ëadäni näni cænte eyepodïmö wæænte æ̈nömengadæmpa ïnö öñöñö guintamöidi ade cæmpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Äñongante Itota, —Onquiyæ̈mi ëñëmi. Bitö nanguï pönënïmi ïñömite bitö änö ante do cæte impa. Ante tæcæ apæ̈neyongä tömengä wengä edæ do adoyedë edæ waa bagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mänïñömö quëwëninque wadæ godinque Itota Gadideapæ̈ ömaaque pö änanquidi æi tæ̈ contacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tæ̈ contate ongöñongä nanguï ïnäni godongämæ̈ pöninque wënæ wënæ inte wædäni ïnänite ænte pönänitapa. Pæ opa pæ opa godäni tönö tente tobænte wædäni ïnänite babetamö ïnäni tönö babetade ïnäni ïnänite Itota weca ænte mämö ñö cædänitapa. Ñö cædäni ongöñönänite Itota tömänäni ïnänite godö cæcä ate waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Godongämæ̈ ongönäni guiquënë, Itota godö cæcä ate babetade ïnïnäni incæ tededäni ëñëmönipa, ante guïñente wædänitapa. Tente tobænte wædïnäni incæ waa badäni amönipa. Pæ opa pæ opa godäni ïnïnäni incæ waa bate godäni amönipa. Babetamö ïnïnäni incæ waa adäni wæmönipa, ante guïñente wædinque edæ Wængonguï ingante apæ̈nedinque, Möni idægocabo Wængonguï ïnömi inte edæ bitö adobique ñäö baï ëmömi inte edæ tæ̈ï pïñænte cæbi ämönipa, ante watapæ̈ apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mänïñedë Itota tömengä mïñæ̈ në godäni ïnänite aa pecä pönäni ate apæ̈necantapa. —Ïïnäni botö weca ongönäni ïñömö mëönaa go adoönæque ïñonte botö weca ongöñönäni tömënäni cænguï ömæpodäni badäni ate wædinque botö tömënäni tönö godongämæ̈ wæte baï pönëmopa. Cæ̈nämaï inte gue æ̈nente wæyönänite botö, Oncönë goedäni, ämo gote baï tömënäni edæ idömæ godinque nangæ̈ badinque edæ bocæ bocæ cæte wæcædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Angä wædinque tömengä mïñæ̈ në godäni wæætë, —Ënodäni ïnäniyaa. Önömæca incæ päö impa æ̈ninque godömöni cænguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ante wæyönänite Itota, —Mïnitö päö æpodö næ̈æ̈mïni. Äñongante, —Päö önompo æ̈mæmpoque go mëa gæyæ guiyä pönï mëa pönï mæ̈ ongompa, ante edæ apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Itota ïñömö godongämæ̈ ongönäni nanguï ïnäni ïñönänite angä tæ̈ contadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ïninque päö önompo æ̈mæmpoque go mëa tönö gæyæ tönö näni næ̈æ̈nincoo pædæ godönäni æ̈ninque tömengä Wængonguï ingante, Bitö waa pönömi cæncæmönimpa, ante apæ̈nedinque pä æ̈ninque tömengä mïñæ̈ në godäni ïnänite pædæ pönongä æ̈ninque tömënäni wæætë wadäni ïnänite pædæ pædæ godönäni æ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Æ̈ninque tömänäni godongämæ̈ cæ̈ninque tömo pönï cæ̈nänitapa. Idæwaa cæ̈näni ate tömënäni pä ænte näni cænte ñönönï ee öñoncoo wente æ̈ninque Itota mïñæ̈ në godäni otodë pönö da wënänitapa. Ïninque önompo æ̈mæmpoque go mentodëa cænguï eyede contagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Në cæ̈nïnäni ïñömö onguïñæ̈nänique coatodo mïido ganca ïñönäni onquiyæ̈näni tönö näni wencabo tönö tömënäni æpodänimë godömenque nanguï pönï ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ïinque cæ̈näni ate Itota ïñömö, Goedäni, angä godäni ate tömengä wipodë guii contate ïmæ̈mäa Mäagadabæ pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Itota pongä adinque Paditeoidi tönö Tadoteoidi ïñömö, Mönö ämö ëñëninque tömengä oda cæbaingampa, ante cædinque Itota ingante apæ̈nedinque, Bitö, Pönencædänimpa, ante öönædë mä cæï baï cæbi amönie. ");
INSERT INTO aucNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Änäni ëñëninque tömengä wæætë, —Mïnitö ïñæmpa gäwadecæ̈ ïñonte æ̈mö adinque, “Baänæ watamö bacæ wïñadæ̈ pönï gongæmpa,” ante do ëñëmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ayæ̈ ñäö bayö edæ, “Cöönæ cæcæ guïnæ̈ wepæ̈ baï gongæmpa,” äninque mïnitö, Öönæ æbänö ëönæpa, ante adinque do edæ ëñëmïnipa. Ïninque, Wængonguï quïnö cæcæ cæcampa, ante quïnante wïï ëñëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ñöwomïni ïñömö edæ në wïwa cæmïni inte mïnitö Wængonguï ingante pangocæte baï ëmö cæte gomïni ïmïnipa. Edæ, Mä cæte odömömi adinque pönëmaïmönipa, ante ancaa ämïni awædö. Incæte Cönäö wodi mä pönï nänö cægaïnö ante adinque mïnitö pönenguënëmïni ïñömïnite mäninque mïni aquinque ante odömonte ingæ̈impa. Äninque Itota tömënäni ïnänite ëmö cæte wadæ edæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tömengä mïñæ̈ në godäni guiquënë tao gocæ cædinque päö wïï pönente æ̈nämaï inte æ̈mæ̈mäa tao ti wææ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Itota ïñömö mänïï päö tömënäni näni æ̈nämaï ïnö ante wïï tededinque wadö ante pönente ïïmaï apæ̈necantapa. —Päö yedæ æmpoquï, ante Paditeoidi tönö Tadoteoidi näni da wente cæ̈ï ate gomö aedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Angä ëñente wædinque tömengä nänö në ëmïñæ̈näni wæætë näni caboque tededinque, —Päö ænte pönämaï ïmöimpa, ante Itota wabänö mänömaï beyæ̈ ämaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ante nämäneque tededäni wædinque Itota ïñömö, —Mïni pönëegade. Päö æ̈nämaï inte mïni pönïnö ante quïmæ̈ tedewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Awincaque adinque adämaï ïmïnitawo. Edæ päö önompo æ̈mæmpoque æ̈ninque botö godömo æ̈ninque tinco mïido ganca ïnäni näni cæ̈nïnö ante awincaque adïmïni inte mïnitö mïmöno pönënämaï ïmïni awædö. Ayæ̈ cænte ate näni wææntodönincoo wente ænte mïni contadïnö ïñömö cænguï æpotodënö ongontawo, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ayæ̈ ate botö önompo æ̈mæmpoque go mëa päö ænte godömo æ̈ninque coatodo mïido ganca ïnäni näni cæ̈nïnö ante adinque mïnitö ïñömö edæ ëñënämaï ïmïnitawo. Ayæ̈ edæ ñæ̈næ̈ otodë mïni wente ænte contadïnö cænguï æpotodënö ongontawo, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mänïnö ñöwo botö, Gomö aedäni, ante wææ äninque botö wïï päonque ante apæ̈netabopa, ante quïnante wïï ëñëmïnii. Incæte botö, Päö yedæ æmpoquï, ante Paditeoidi tönö Tadoteoidi näni da wente cæ̈ï ate gomö aedäni, ante wææ ämopa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Angä ëñente pönente wædinque tömënäni, Gomö aedäni, ante apæ̈nedinque Itota wïï önonque päö da wente cæ̈inque ante wææ angampa. Wæætë edæ Tadoteoidi tönö Paditeoidi wapiticæ̈ ante näni odömonte apæ̈nedö ante tömengä, Gomö aedäni, ante wææ angampa, ante do ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mänïï ïmæ̈mäa tate ate Tetadea Pidipobæ eyequeï pöninque tömengä mïñæ̈ në godäni ïnänite apæ̈nedinque Itota, —Botö Waobo ëñagaïmo ïñömote wadäni botö ïmotedö ante tededinque, Æbodö ïmoo, ante apæ̈nedäni ëñëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Äñongante tömënäni wæætë apæ̈nedänitapa. —Bitö ïmitedö ante apæ̈nedinque pancadäniya, Æpæ̈në në guidongaingä Wäö wodi incæ Itota adocä ïmaingampa, ante tededänipa. Wadäni guiquënë, Ediya wodi incæ Itota ïnongä ïmaingampa, ante apæ̈nedänipa. Wadäni guiquënë, Eedëmiya wodi ingampa, ante apæ̈nedänipa. Ayæ̈, Wïï Eedëmiya ingä ïninque Itota Wængonguï beyæ̈ në apæ̈negaïnäni ïñönänite adocä ïmaingä ingampa, ante tededänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ante tömengä mïñæ̈ në godäni apæ̈nedäni ëñëninque Itota wæætë, —Mïnitö diyæ̈, Æbodö ïmoo, ante pönëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Äñongante Timönö Pegodo wæætë, —Wængonguï në quëwengä Wëmi ingaïmi inte bitö ïñömö Coditobi ïnömi ïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ante apæ̈necä ëñëninque Itota ïñömö, —Timönö bitö Öönata wëmi ïnömi inte ëñëmi. Wïï waocä apæ̈necä beyæ̈ bitö mänömaïnö ante ëñëmitapa. Wæætë bitö nanguï toquinque edæ botö Mæmpo öönædë në quëwengä incæ bitö ïmite pönö odömonte apæ̈necä ëñëmitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ayæ̈ edæ ïïmaï ante bitö ïmite ämopa. Bitö dicamö baï ïnömi ïmipa, ante pönëninque botö bitö ëmöwo ante Pegodo pönö pemömo ëmömipa. Incæte dicabo tæ̈ïmö ï baï bitö nö änïnö ïñömö edæ tæ̈ïne ï ïñonte botö mänïmoga tæ̈ï mæ̈nonte baï pönö badömo ate mïnitö mïni pönencabo bacæmïnimpa. Ïninque mïnitö, Itota në Codito ingampa, ante mïni pönencabo ïñömö tæ̈ï ëmömïni badinque mänïmoga tæ̈ï ongonte baï wede pönëñömïnite në tæ̈ï pïñæ̈näni tadömengadænguipo owote ta pönäni incæ ædö cæte godömenque mämö bæ taquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Edæ öönædë Awënë Odeye nempo guiiquinque ante odemö wi æ̈nequï baï botö bitö ïmite pönömo æncæbiimpa. Æ̈mi ate bitö në ämi badïmi inte inguipoga bitö wææ änö incæ öönædë dobæ wææ angaïnö inte ongongæ̈impa. Ayæ̈ bitö quïëmë inguipoga ñimpo cæbi ï ïñonte mänïï adobaï öönædë dobæ ñimpo cæte ongongæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ante ïinque apæ̈nedinque Itota tömengä mïñæ̈ në godäni ïnänite ïïmaïnö ante wææ angantapa. Mïnitö ïñömö botö ïmotedö ante apæ̈nedinque, Codito ïnongä ingampa, ante gode änämaï inte edæ pæ wëëneedäni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ayæ̈ Itota mänïñedë mä odömöninque tömengä mïñæ̈ në godäni ïnänite apæ̈nedinque, Botö cöwë Eedotadëë goquënëmo ïmopa, angantapa. Gobo ate oodeoidi në aadäni näni Picæncabo tönö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni tönö godongämæ̈ cædinque botö ïmote wënæ wënæ cædäni wæwencæboimpa. Ayæ̈ botö ïmote godömenque wæ̈nönäni wæncæboimpa. Incæte Wængonguï angä beyænque botö mëönaa go adoönæque ïñonte edæ ñäni ömæ̈monte quëwencæboimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mänömaïnö ante apæ̈necä ëñëñönäni Pegodo guiquënë Itota ingante nänënë mäo godinque Itota ingante pïingantapa. —Awënë, quïmæ̈ wæncæ änewëë. Wængonguï pönö wææ aacä beyæ̈ bitö caate wædämaï incæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ante wææ äñongante Itota dadi ëmæ̈ninque Pegodo ingante näëmæ̈ pïïninque, —Bitö Tatänabi baï ïnömi inte edæ botö weca ongönämaï wadæ gobäwe, angantapa. Bitö wïï Wængonguï nänö pönënö ante pönëmi inte wæætë edæ waodänique näni pönëwënö baï pönëninque mänömaïnö ante bitö botö ïmote ægodawaquï ñönonte baï cædinque wææ änewëmi awædö, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ayæ̈ tömengä mïñæ̈ në godäni ïnänite apæ̈necantapa. —Æcänö botö mïñæ̈ pöïnëna ïna tömengä ïñömö nämä beyæ̈ ante pönënämaï inte edæ botö mïñæ̈ tee empote poncæcäimpa. Nämä nänö wænguïwæ̈ mongænte ponte baï cædinque tömengä, Botö wæ̈mo incæ caate wæbo incæ Itota ingante cöwë tee empote gocæboimpa, ante poncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Edæ æcänö, Nämä wææ gompodinque quëwencæboimpa, ante cædinque botö mïñæ̈ pönämaï ingä guiquënë tömengä ïñömö edæ quëwënämaï incæcäimpa. Wæætë edæ, Wæ̈nönäni wæ̈mo incæte botö Itota mïñæ̈ tee empote cöwë gocæboimpa, ante æcänö äna guiquënë tömengä wæætë quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Edæ waocä inguipoga ongoncoo tömancoo ö æncæte ante cædinque nämä önöwoca incæ pædæ godongä wë womonte ba ïninque edæ tömengä nänö ömæwocate wæquinque æ̈maingampa. Ïñæmpa eyepæ̈ godongampa diyæ̈ önöwoca wæætë æ̈maingää. ");
INSERT INTO aucNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ante Itota ïñömö, “Edæ botö Waobo ëñagaïmo inte botö Wæmpo ñäö tömäo guïnæ̈ gongæ̈ñonte botö edæ botö anquedoidi tönö edæ godongämæ̈ poncæboimpa. Ayæ̈ pömo ate botö tömämïni mïnitö cægaï ganca ante eyepæ̈ pædæ pönömo æncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Edæ näwangä ämopa. Mïnitö ïñömö ongömïni pancamïniya ïñömö ayæ̈ wæ̈nämaï mïïmïni quëwëñömïni botö Waobo ëñagaïmo inte Awënë Odeye bate ponte a ongömo adinque mïnitö botö nempo quëwencæmïnimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mänïnö ante apæ̈necä ate Itota önompo æ̈mæmpoque go adoönæque ïñonte Pegodo ingante ayæ̈ Tantiago tönö Wäö näna caya ïnate mänimpodäni ïnänite änanquidi mæ̈icä adodänique æigadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Æite ongöñönäni edæ Itota awinca tömënäni ayönäni edæ wïï cöwë nänö ëmönö baï waëmö pönï ñäö baï edæ ëmongä bamongä adänitapa. Edæ nænque tï näwante ñäö baï bate ëmongä ïninque tömengä weocoo näämænta ñäö incoo ëñacä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ayæ̈ ayönäni edæ doyedë pönï në æigaïna ïñömö Möitee wodi tönö Ediya wodi incæ ïñontobæ̈ a ongöninque Itota tönö godongämæ̈ tedegönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Adinque edæ Pegodo guiquënë Itota ingante apæ̈necantapa. —Awënë ëñëmi. Ïñömö mönö waa pönï ongonte awædö. Bitö Ao ämi ïninque botö oncontaicoo mentaiya go adotaique mæ̈nöninque bitö oncontai ante adotaique Möitee oncontai ante adotaique Ediya oncontai ante adotaique mæ̈nömaïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ante ayæ̈ tedeyongä boguïmämo waëmö pönï ocabogadäni obo wææ̈ninque guïnæ̈ gongæ̈ ayönäni boguïmämodë önönepämoque apæ̈necantapa. —Ïingä ïñömö botö Wengä ïnongä inte botö në waadegaingä ïnongä ingampa. Tömengä ingante adinque botö watapæ̈ tobopa. Mïnitö tömengä pönö apæ̈necä ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Angä wædinque tömengä mïñæ̈ në æidäni ïñömö ancai guïñëninque do do wäate baï cædinque guidömëmæ̈ tæ̈ go wææ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Go wææ̈näni adinque Itota tömënäni weca ponte godö gampodinque, —Guïñënämaï inte ængæ̈ gantiedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ayæ̈ æ̈mö ayönäni Itotaque adocanque ongongä agadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ayæ̈ änanquidi ïnö wææ̈ pöñönäni Itota tömënäni ïnänite angantapa. —Mïnitö mä pönï botö ëmönö wïïmonte baï mïni adïnö ante gode änämaï pæ wëëneyömïni botö ïñömö Waobo në ëñagaïmo inte edæ wænte ate ñäni ömæ̈moncæboimpa. Ñäni ömæ̈mömo ate mïnitö edæ mänïñedë ate apæ̈necæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Angä ëñente wædinque tömengä tönö në æidïnäni tömengä ingante änänitapa. —Mänömaï ï ïninque, Ediya wodi täno poncæcäimpa, ante në odömönäni ïñæmpa quïnante apæ̈nedänii. ");
INSERT INTO aucNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Äñönäni Itota wæætë, —Ediya wodi näni änongä ïñömö täno pongä ingampa. Näwangä impa. Pöninque tömengä, Doyedë ingaï baï ñöwo wæætë adobaï bacæ̈impa, ante badongampa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Botö wæætë ïïmaïnö ante apæ̈nebo ëñëedäni. Ñöwocä mönö Ediya ïnongä inte do pongäimpa ante aquënë. Do pöningä ingante edæ awincaque adinque, Æcänö ingää, ante ëñënämaï inte cædäni guiquënë quïëmë näni cæïnënö incæ edæ do cædänipa. Ayæ̈ adobaï, Tömengä ingante näni cædï baï botö Waobo ëñagaïmo ïñömote botö ïmote adobaï wënæ wënæ cædäni wæcæboimpa, ante apæ̈nebo ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ante apæ̈necä ëñëninque tömengä tönö në æidïnäni ïñömö edæ, Æpæ̈në mönö guidöningä Wäö ingantedö ante apæ̈necampa, ante tæcæ ëñënäni inte wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mänïï änanquidi æidïnäni inte adodö wææ̈ninque nanguï pönï ïnäni weca pönäni adinque wacä onguïñængä Itota weca ponte da guicapodinque angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Awënë ëñëmi. Botö wengä onguïñængä ingante waadete waa cæe ämopa. Tömengä ïñömö edæ ancaa quidi quidi dowænte wæwëninque wantæ wantæ ïñö gongapamö tæ̈ wææ̈ tæ̈ wææ̈ cæcampa. Ayæ̈ æpæ̈në tæi guii tæi guii cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ante wædinque, Botö wengä ingante pönö cæmïni waa bacæcäimpa, ante botö bitö mïñæ̈ në godäni weca ænte pömo adinque tömënäni ædö cæte cæquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Äñongante Itota tömënäni ïnänite, —Ñöwomïni mïni ædæmö cædämaï incabo mïni pönëegade impa, angantapa. Mïnitö weca æpogadö quëwëmoï. Wapiticæ̈ cæmïni ïñömïnite æpogadö piyæ̈në cæte wæwëmoï. Edæ wëñængä ingante ïñömö botö weca ænte mämömïni pongäedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ayæ̈ wënæ ingante pïïninque Itota, Tao gobäwe, angä tao gocä ate wëñængä ïñömö dobæ waa bacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ayæ̈ ate tömengä mïñæ̈ në godäni adodänique Itota weca pöninque tömengä ingante, —Mönitö guiquënë bitö baï wido cæcæ cædinque edæ quïnante wido cædämaï intamönii. ");
INSERT INTO aucNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ante wæyönänite, —Wede pönëmïnipa diyæ̈ wido cæquïmïnii. Edæ mïni pönënö möotatamö baï guiyä pönï ëwocamïni ïninque mïnitö änanquidi ïñömö ongonquidi adinque, Nänënë gobäwe, ante ämïni baï edæ änanquidi incæ do gä gote wayömö gongæncædönimpa. Edæ quïëmë cæcæte ante ämïni ïninque tömänö edæ do cæte babaimpa, ante näwangä apæ̈nebo ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Incæte mänïï wënæ inte wido cæcæte ante cædinque cænguï wantæpiyæ̈ cæ̈nämaï inte Wængonguï ingante apæ̈nete ate edæ wido cæquï impa, ante Itota apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mänïï Gadideabæ pöninque godongämæ̈ goyönänite Itota ïïmaïnö ante apæ̈necantapa. Adocanque, Waocä në ëñagaingä ïñömö æyömönö ongongää, ante godö odömöninque botö ïmote waodäni nempo pædæ godongä æncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Në æ̈näni wæætë botö ïmote wæ̈nönäni näñe wæncæboimpa. Ayæ̈ mëönaa go adoönæque ïñonte edæ Wængonguï angä beyænque botö edæ ñäni ömæ̈monte quëwencæboimpa. Itota mänömaïnö ante apæ̈necä ëñëninque tömengä mïñæ̈ në godäni wæætë edæ nanguï wæwente bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mänïï pöninque tömënäni Itota tönö godongämæ̈ Capënaömö näni quëwëñömö pöñönäni wadäni guiquënë Wængonguï oncö beyæ̈ ante tiguitamö didacöma näni änontamö mentamonga ante në änönäni inte Pegodo weca ponte änänitapa. —Mïnitö Awënë në Odömongä guiquënë Wængonguï oncö beyæ̈ ante didacöma tiguitamö cöwë pönönämaï ingantawo. ");
INSERT INTO aucNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Äñönänite Pegodo, —Cöwë në pönongä ingampa. Äninque oncönë pö wäänë guiiyongante Itota täno apæ̈necantapa. —Timönö, æbänö ante pönëmii, angantapa. Ïïmæca në quëwëmö mönö eyepæ̈ ænte quëwengæ̈impa, ante ïmæca awënë odeyeidi ïñömö edæ tömënäni nempo në quëwënäni ïnänite, Pönömïni æ̈moedäni, änänitawo. Wæætë edæ wadäni ïnänite änänitawo. Ædänidö ïnänite änäni, ante pönëmii, ante Pegodo ingante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Äñongante Pegodo, —Wadäni ïnänite änänipa. Ante apæ̈neyongä Itota wæætë edæ, —Mänömaï ï ïninque edæ mönö Awënë Wængonguï nempo në quëwënömö inte wïï godonguënëmö ïmompa. ");
INSERT INTO aucNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Incæte wïï pïinte bacædänimpa, ante botö ïïmaï ämopa. Bitö gäwapäa mäo dadonte wëä tadöñömi gæyæ tänocä tacä æ̈e. Æ̈ninque gæyæ önöneca wi æ̈nete ayömi adotamonque incæ coatodo didacöma ëmontamö incæ edæ gæyæ önöne ongontamö adinque bitö tadonte æncæbiimpa. Mänintamö ænte mäo bitö beyæ̈ botö beyæ̈ eyepæ̈ godömi æncædänimpa, angä gote Pegodo cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mänïñedë Itota mïñæ̈ në godäni tömengä weca ponte apæ̈nedinque, —Bitö öönædë Awënë Odeye ïinque bayömi æcänö bitö nempo quëwëninque ñæ̈nængä pönï ïnongä inte në angä inguingää, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Itota ïñömö wëñængä guiyangä ingante edæ aa pecä pongä ate tömengä ingante tæcæguedë goncædinque tömënäni ïnänite wæætë apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Näwangä ämo ëñëedäni. Mïnitö öönædë Awënë Odeye nempo guiicæte ante wapiticæ̈ mïni pönëwënö wido cædinque wëñæ̈näni näni piyæ̈në cæte pönënö baï pönëedäni. Mänömaï cædämaï ïmïni ïninque Awënë Odeye nempo cöwë guiidämaï inte wæbaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Incæte ïingä wëñængä, Önömoque ïmopa, ante pönengä baï æcänö adobaïnö ante pönente quëwëna guiquënë tömengä ïñömö edæ öönædë Awënë Odeye nempo quëwëninque ñæ̈nængä pönï inte edæ në angä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ayæ̈ æcänö botö ëmöwo apæ̈nedinque mäningä baï wëñængä ingante, Pöe, ante godö waa cæcä ïñömö tömengä ïñömö edæ botö ïmote edæ do, Pöe, ante pönö waa cæcä ingampa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Itota ayæ̈ apæ̈necantapa. “Wadäni godö cædäni beyæ̈ botö ïmote në pönënäni incæ pancadäniya edæ dobæ oda cæte wënæ wënæ cædänipa. Ïninque, Wëñængä adocanque guiyangä pönï ingä incæ oda cædämaï incæcäimpa, ante wææ cæcæte ante cædinque në godö cæcæ cædingä ingante ïïmaï cædäni ïninque tömengä toquënengä ïmaingampa. Waodäni näni dacæ godö dacæ godö cæquinca ñæ̈nænca æ̈ninque tömengä önömenca æ wëmencadinque tömengä ingante tæcætibæ wido cædäni ïninque tömengä edæ, Wënæ wënæ cædämaï inte becadote wæ̈mo beyænque Wængonguï botö ïmote wïï godömenque pangampa, ante wædinque waa toquënengä ïmaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Quïëmë beyæ̈ oda cædinque inguipoga quëwënäni näni wæquinque wënæ wënæ cædänipa. Në pönënäni incæ pancadäniya wïï ëñente do oda cædänipa. Cöwë mänömaï impa. Incæte, Oda cæcæcäimpa, ante në cæcä ïñömö edæ tömengä nanguï nänö caate wæquinque cæcampa,” ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ayæ̈, “Bitö önompoca cædinque wënæ wënæ cæbi ïninque önompo aa wi æmpote wido cæte baï cædinque wënæ wënæ bitö cædïnö ante wido cæbäwe. Bitö önöwa wapiticæ̈ godinque wënæ wënæ cæbi ïninque bitö önöwa aa wi æ̈wate wido cæte baï cædinque wënæ wënæ bitö cædïnö ante wido cæbäwe. Ïñæmpa inguipoga quëwëninque bitö æ̈mæmpoque empobi incæte æ̈mæntique entibi incæte bitö öönædë æidinque cöwë wæ̈nämaï quëwëmi ïninque waa ïmaimpa. Edæ tipæmpoga empobi inte tipæntiya entibi inte edæ bitö gonga cöwë bæcote wæwenguïñömö wïï æ̈mæ̈wo wido cæte wæquïmidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ayæ̈ bitö awinca wïwa adinque wënæ wënæ cæbi ïninque bitö awinca oo togæ̈monte wido cæte baï cædinque wënæ wënæ bitö cædïnö ante wido cæbäwe. Ïñæmpa inguipoga quëwëninque bitö æ̈mæ̈monque ëmömi inte bitö godömenque quëwëmi ïninque waa ïmaimpa. Edæ wïï tipæ̈monga ëmömi inte edæ bitö tadömengadænguipo gonga cöwë bæcote wæwenguïñömö wïï wido cæte wæquïmidö anguënë,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ayæ̈, “Ïingä guiyangä ïñömö önonganque ingampa, ante mïnitö adocanque ingante incæ pïinte adämaï ïmäewedäni. Ïñæmpa tömënäni ïnänite në aadäni anquedoidi incæ öönædë quëwëninque botö Mæmpo në öönædë quëwengä awinca cöwë adänipa cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Edæ botö Waobo ëñagaïmo inte edæ wë womönäni ïnänite diqui minte æncæte ante pömo ïmopa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ayæ̈, “Æbänö ante pönëmïni edæ. Waocä obegaidi tiëë ganca ëacä ongöñönäni adocanque pangocæte nänënë gocä adinque në ëacä ïñömö nöobenta i nöebe ganca ïnäni änämæ̈në ongöñönänite ëmö cæte diqui mincæ wïï goquingä, ante pönëmïnii. Cöwë edæ diqui diqui mincæ gocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Godinque në pangocæ godingä ingante ëadente acä ïninque në ëacä waa tobaingampa. Edæ pangocæ godämaï ïnäni nöobenta i nöebe ganca ïnäni ïnänite adinque cöwë tocä ïnongä inte tömengä tæcæ nänö adingä beyæ̈ godömenque tocampa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mïnitö Mæmpo öönædë në quëwengä adobaingä, Guiyangä wë womonte wæ̈nämaï incæcäimpa, ante cöwë diqui diqui mingampa,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Godömenque odömöninque Itota apæ̈necantapa. “Bitö tönïñacä bitö ïmite wënæ wënæ cæcä wædinque bitö tömengä weca gote ämi adomïnaque nänënë gote ongöeda. Ongöñömïnate bitö tömengä ingante, Mänömaï cæbitapa, ante ämi ëñengäe. Mänömaï ämi ëñengä ïninque tömengä waadete babaingampa,” ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ayæ̈ godömenque apæ̈necantapa. “Wæætë tömengä ëñënämaï inte waadedämaï ingä ïninque bitö Wængonguï angä ëñente näni yewæ̈mongaïnö baï cæe. Waocä æbänö cæcää, ante adinque waoda mënaa ïna incæ mënaa go adocanque ïnäni incæ adoyömö ante apæ̈nedäni ïninque tömënäni näni apæ̈nedö beyænque ante mönö, Nö impa, ante ëñengæ̈impa, ante Wængonguï beyæ̈ yewæ̈mongatimpa. Ïninque bitö, Mönö adoyömö ante apæ̈necæ̈impa, ante waoda mënaa ïnate ämi incæ adocanque ingante ämi incæ æcämenque bitö tönö goda tömengä adoyömö ante nöïnö ante apæ̈necæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ayæ̈ apæ̈nemïni ate në wënæ wënæ cædingä cöwë ëñënämaï ingä ate wædinque bitö ïñömö, Itota në Codito ingampa, ante mïni pönencabo weca gote apæ̈nebi ëñenguïnäni. Ayæ̈ tömënäni wææ änäni ate tömengä godömenque ëñënämaï ingä ïninque tömengä, Nämä cæte quëwenguïmo, ante në ëñënämaï cædäni baï ingampa. Ayæ̈, Odömäno awënë beyæ̈ në æ̈wengä baï ingampa cæbii. Tömengä ëñënämaï cæcäïnö anguënë, ante bitö edæ tömengä ingante gomö ae,” ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ayæ̈ apæ̈nedinque, “Näwangä ämopa. Mïnitö inguipoga në ämïni inte apænte ämïni ïninque mïni apænte änïnö incæ öönædë dobæ apænte ante impa. Ayæ̈ inguipoga mïnitö apænte äninque ñimpo cæmïni ïninque mïni cædö baï öönædë adobaï do ñimpo cæte ingæ̈impa.” ");
INSERT INTO aucNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ante apæ̈nedinque Itota ayæ̈ apæ̈nedinque, “Mïnitö ïmïnite ïïmaï ämopa, angantapa. Inguipoga mëmïnaa guëa adoyömö pönente apæ̈neyömïna botö Mæmpo öönædë në quëwengä ïñömö mïna ämaï ante tömänö cæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Edæ mëmïnaa ïmïna incæ mëmïnaa go adocanque ïmïni incæ æpomïnimë ïnömïni incæ mïnitö adoyömö ponte botö ëmöwo apæ̈nete ongöñömïni edæ botö adoyömö mïnitö tönö godongämæ̈ ongoncæboimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ayæ̈ ate Pegodo tömengä weca ponte äninque, —Awënë, botö tönïñacä botö ïmote wënæ wënæ cæcä adinque botö tömengä ingante æpogadö godö ñimpo cæbo ee goquingää. Edæ önompo æ̈mæmpoque go mempoga mänimpoga ñimpo cæbo ee goquingä, ämii. ");
INSERT INTO aucNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Äñongante Itota, —Ïñæmpa, wïï önompo æ̈mæmpoque go mempogaque anguïï. Edæ godömenque bitö änimpoga pïïnämaï inte ñimpo cæbi ate wæætë adopoga wæætë adopoga ayæ̈ cöwë tetenta ganca wæætë wæætë ñimpo cædinque coatodo tiento nöobenta ganca mänimpoga pïïnämaï inte ñimpo cæbi goquingä. Mänömaï ante Itota tömengä mïñæ̈ në godäni ïnänite, Cöwë pïïnämaï inte ñimpo cæquïmïni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Itota ayæ̈ apæ̈necantapa. “Mänïnö beyæ̈ bitö änö baï cædäni wædinque ïmæca awënë odeye nänö apænte ämaï öönædë Awënë Odeye incæ tömengä ingante në ëñëmïni ïmïnite æbänö apænte angampa, ante odömömo aquïmïni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ïmæca awënë ïñömö, Botö ïmote në cædäni incæ botö ïmote debe ïnäni inte eyepæ̈ pönönäni æncæboimpa, ante cæyongä adocanque tadento ñæ̈nængade näni godonte æ̈inta incæ diete mïido ganca nänö pönongä æ̈nï beyæ̈ wæætë pönönämaï debe ingä adinque tömengä ingante ænte mämönäni pongampa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pongä adinque tömengä awënë ïñömö, Ömæpocä inte tömengä ædö cæte pönongä ænguïmoo, ante pönente wædinque ïïmaï angantapa. Wacä ingante në cædäni tömengä näni wencabo bacædänimpa, ante cædinque botö në pönönämaï ingä näna gæncaya näni wencabo tömänäni ïnänite bæi ongonte wacä ingante godonte eyepæ̈ ænguïmoo, angä. ");
INSERT INTO aucNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ëñente wædinque edæ në cæcä ïñömö tömengä weca ædæ wææ̈ninque edæ, ‘Awënë, waadete cædinque ee abi adinque botö ayæ̈ ate botö debe inganca tömanta pönömo æncæbiimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ante wæcä ëñëninque awënë ïñömö në cæcä ingante guëa wæte baï pönëninque, Tömää edæ godonte impa, äninque godö ñimpo cæcä abæ tawænte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Incæte tömengä tönö wadäni näni godongämæ̈ cæcabo ïñönäni wacä guiquënë adocä ingante tiëë tiguitamö ganca nänö pönongä æ̈nï beyæ̈ wæætë pönönämaï debe ïnongäimpa. Adinque në abæ tawænte godingä incæ tömengä ingante debe ingä ingante godö yao ongonte ñïmämencate cædinque, ‘Do bitö æ̈ninta pönömi æ̈mo töö.’ ");
INSERT INTO aucNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ante pïingä wædinque tömengä tönö në cæcä inte në debe ingä wæætë në äningä weca da guicapodinque, ‘Bitö waadete cædinque ee abi ïninque botö ayæ̈ ate pönömo æncæbiimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ante wæyongä edæ Baa äninque tömengä, Tömanta edæ cöwë pönömi æ̈mo ate tabaïmipa, äninque edæ tee mönecä ongongantapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Adinque edæ tömëna tönö në cædäni guiquënë, Mänömaï cæcä, ante wædinque pïïninque awënë weca gote, Mänömaï cæcampa, ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Änäni ëñëninque wënæ wënæ në cædingä ingante äñecä pongä ate tömengä ingante awënë, ‘Botö ïmo në cædïmi inte në wënæ wënæ cæbitapa töö. Ïñæmpa bitö nanguï ämi beyænque botö edæ, Tömanta edæ godonte impa, ante ñimpo cæbo abæ tawænte gobitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ïninque botö guëa wæte pönente cæbo baï bitö tönö në cæcä ingante bitö adobaï guëa wæte pönëmi baï waa incædönimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Äninque awënë äingä badinque, Tömengä tömanta nänö æ̈ninta botö ïmote adodö nänö pönonguinganca botö, Tömengä ingante ænte pancæmïnimpa, ämopa. Äninque tömengä ingante tee mönete oncönë në pänäni ïnänite pædæ godongä æ̈nänipa.” ");
INSERT INTO aucNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mäninque ante odömonte apæ̈nedinque Itota godömenque apæ̈necantapa. —Edæ mïni waocabo ïñömïnite mïnitö wacä nänö wënæ wënæ cædïnö ante godö ñimpo cædämaï ïmïni adinque awënë nänö apænte änö baï botö Mæmpo öönædë në quëwengä ïñömö adobaï mïnitö wënæ wënæ cædïnö ante ñimpo cædämaï inte tömänö ancæcäimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mänïï Gadideabæ quëwente ïinque apæ̈nete ate Itota Oododänö æ̈mæ̈mäa godinque Oodeabæ pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pongä adinque nanguï ïnäni tee empo goyönäni tömengä gampocä waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Paditeoidi guiquënë, Godö ämö ëñëninque Itota wabänö adodeque oda cædete wæcä tocæ̈ï, ante pönëwënäni inte tömengä weca pöninque änänitapa. —Wængonguï æbänö ante wææ angacäï. Waocä tömengä nänöogængä ingante quïëmë beyænque pämængä ïninque edæ nö cæte intawo. ");
INSERT INTO aucNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ante äñönäni Itota, —Mïnitö ïñæmpa Wængonguï beyæ̈ ante näni yewæ̈möinta adämaï inte ämïnitawo. Wëënëñedë edæ waocä ingante në Badongaingä ïñömö, “Onguïñængä ingampa, ante ayæ̈, Onquiyængä ingampa, ante badongacäimpa,” ante yewæ̈mongatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ayæ̈, “Mänömaï beyæ̈ waocä mæmpocä ingante ëmö cæte wäänä ïnante ëmö cæte godinque onquiyængä ingante, Botö nänöogængä, ante æ̈mæ̈wo moncæcäimpa. Ïninque mënaa ïnïna incæ tömëna näna gæncaya badinque adocanque baï bacædaimpa,” ante yewæ̈mongatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ïninque tömëna näna gæncaya adocanque baï badinque nänënë mënaa ïnämaï ïnapa. Mänömaï beyæ̈ Wængonguï, Adocanque baï ïnapa, ante näna gæncaya nänö në badongaïna ïñönate waocä wæætë pango cædämaï incæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Äñongante tömënäni wæætë, —Ïninque, Æ̈mæ̈wo pämæ̈mo goquïmi, ante yewæ̈möninque mäninta bitö yewæ̈möninta onquiyængä ingante godömi ængä ate bitö önonque pämæncæbiimpa, ante Möitee wodi quïnante wææ angacäï, ante ëñencæte ante mönitö wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Änäni ëñëninque Itota edæ, —Ïñæmpa, Mïmö ömædëmïni ïnömïni inte mïnitö wënæ wënæ cæïnëmïni ïmïnipa, ante wædinque edæ Möitee, Nänöogængä ingante pämænguïmi, ante yewæ̈mongacäimpa. Wëënëñedë ïñömö edæ wïï mänömaï ingatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wæætë onquiyængä wacä ingante godö todämaï ïñongante tömengä ingante në pämæ̈ningä ïñömö tömengä dobæ nänö towenguinque edæ wacä onquiyængä ingante godö mongampa. Ayæ̈ onquiyængä pämænte goyongä wacä onguïñængä tömengä ingante godö möninque adobaï në towengä bacampa, ante ämo pönëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Angä ëñëninque tömengä mïñæ̈ në godäni guiquënë, —Ïñæmpa näna gæncaya ïna inte pämæ̈nämaï ingæ̈impa, ante bitö änö baï nö ï ïninque edæ waocä wëmö cæcä baï waa ïmaimpa, ante pönente wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ante wæyönänite Itota, —Wëmö cæcä, ante mïni änö baï ante waocä ædö cæte cæquingää. Wængonguï nänö änïnänique mänïnö ante Ao ante mönämaï ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Edæ ædänidö mönämaï inguïnänii, ante pancadäniya guiquënë wäänä cæncadë ëñayedë edæ ongænca babetamïñæ̈näni ëñagaïnäni inte mönämaï ïnäni. Pancadäniya wæætë waodäni cædäni beyænque babetamïñæ̈näni badinque mönämaï ïnänipa. Ayæ̈ pancadäniya guiquënë öönædë Awënë Odeye nempo beyæ̈ ante nämä pönëninque Ao ante edæ mönämaï ïnänipa. Edæ æcänö botö änö ëñente Ao äna, tömenganque mänömaï cæcæcäimpa, ante Itota odömongä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ayæ̈ ate, Wëñæ̈näni ïnänite Itota pönö gampo cæcadinque tömënäni beyæ̈ Wængonguï ingante apæ̈necæcäimpa, ante cædinque wadäni tömengä weca ænte pö ænte pö cædäni adinque tömengä mïñæ̈ në godäni guiquënë, Ænte pönämaï ïedäni, äninque Baa Baa änäni. ");
INSERT INTO aucNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ate wædinque Itota ïñömö edæ, —Wëñæ̈näni ïnänite ee amïni poncædänimpa. Edæ mänïnäni näni pönënö baï adobaï pönënäni inte edæ öönædë Awënë Odeye nempo do quëwënäni ïnänipa. Ïninque mïnitö ïñömö wëñæ̈näni ïnänite Baa änämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Äninque wëñæ̈näni ïnänite pædæ gopo gampo cæcadinque wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ayæ̈ wacä Itota weca pöninque, —Awënë në Odömömi apæ̈nebi ëñëmoe, angantapa. Botö æbänö waa cæbo ïninque cöwë wæ̈nämaï wantæpiyæ̈ quëwëmaïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ante äñongä Itota edæ, —Wængonguï adocanque në waa cæcä ingä incæte bitö botö ïmonte äninque, Æbänö waa cæquïmo, ämii. Incæte, Quëwenguïmo, ante wæbi ïninque bitö, Ïïmaï cæedäni, ante Wængonguï nänö wææ angaïnö ante ëñente cæe. ");
INSERT INTO aucNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Angä wædinque, —Ædedö ante ämii. Äñongante Itota wæætë, —Ïïmaï. “Wacä ingante godö wæ̈nönämaï. Bitö nänöogængä ïnämaï ïñongante godö mönämaï. Wacä quï awëmö æ̈nämaï. Wacä æbänö cæcää, ante godö babæ wapiticæ̈ änämaï. ");
INSERT INTO aucNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wæmpocä ingante wäänä ïnante waa adinque godö waa cæe. Ayæ̈, Nämä ante bitö waadete cæbi baï wadäni ïnänite adobaï godö waadete cæe.” ");
INSERT INTO aucNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Angä ëñëninque edëningä ïñömö, —Botö mänïnö bitö änö baï do cæte pægaïmo inte botö quïnö edæ godömenque cæquïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Äñongante Itota wæætë, —Bitö, Ædæmö nö cæbo bacæboimpa, ämi ïninque edæ öönædë bitö waëmoncoo ænguinque edæ ñöwo godinque ïmæca bitö mänincoo tömancoo godonte æ̈ninque bitö æ̈ninta wæætë ömæpodäni inte wædäni ïnänite tömanta godömi æncædänimpa. Ayæ̈ edæ botö ïmote tee empote pöe. ");
INSERT INTO aucNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Angä ëñëninque edëningä ïñömö edæ, Botö mäincoo, ante nänö nanguï ëacoo ante pönente wæwente wædinque wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gocä ïninque edæ Itota tömengä mïñæ̈ në godäni ïnänite apæ̈nedinque, —Näwangä ämo ëñëedäni, angantapa. Öönædë Awënë Odeye nempo guiite quëwencæte ante cædinque waodäni ömæpodäni inte botö mïñæ̈ pönänipa. Mäincoo nanguï ëacä guiquënë æbänö cæte ömæpocä inte botö mïñæ̈ ponte guiite quëwenguingää, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ayæ̈ cämeyo ïñömö guiyangä ingampa diyæ̈ daagö guiyampite pædæ tacää. Cämeyo ñæ̈nængade ïnongä inte pædæ tadämaï ingä baï në ëacä adobaï ingampa. Tömengä nämä ayongä ñæ̈nængä ïnongä inte edæ æbänö cæte Wængonguï Awënë Odeye nempo do wäänë guiite quëwenguingää. ");
INSERT INTO aucNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ante apæ̈necä wædinque tömengä mïñæ̈ në godäni wæætë ancai guïñëninque, —Ïñæmpa mänömaï ï ïninque æcänö wäänë guiite quëwenguingää, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Itota tömënäni ïnänite cöwä adinque apæ̈necantapa. —Waomïnique incæ nämä mïni cædö beyænque ædö cæte quëwëmaïmïnii. Wæætë Wængonguinque nämä tömänö do cæcä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Angä ëñente wædinque Pegodo guiquënë, —Mönitö ïñömö edæ möni ëadincoo owæ̈ caate bitö mïñæ̈ ömæpomöni inte pömöni abipa. Ömæpomöni ïmöni inte edæ quïnö ænguïmönii. ");
INSERT INTO aucNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Äñongante Itota wæætë tömënäni ïnänite angantapa. —Näwangä ämopa. Botö badömo ate tömancoo mïincooque ïinque bayonte botö Waobo ëñagaïmo ïñömö edæ tömëmo ñäö ëmönö ëmöninque edæ pö tæ̈ contacæboimpa. Ïninque mïnitö botö ïmote në tee empogaïmïni inte mänïñedë ate tömëmïni tæ̈ contaimpaa tipæmpoga go mempaa pö tæ̈ contadinque awënëidi badinque edæ idægoidi tipæmpoga go mencabodäniya ïnänite apænte ancæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Ayæ̈ godömenque ämopa. Mïnitö näwangä oncodo tao godinque mïnitö tönïñadäni ïnänite ëmö cæte godinque badä ïnante mæmpocä ingante wënäni ïnänite botö ëmöwo beyænque ëmö cæte pömïnitapa. Ïninque ïïmaï ante näwangä ämopa. Æcänö botö beyænque mänömaï cædinque tömengä nänö ëadï ömæ ëmö cæte goda ïñömö tömengä nänö ëmö cæte godincoo baï adopocoo æncæcäimpa. Wïï adopogaque edæ æ̈ninque tömengä wæætë edæ godömenque adopocoo adopocoo æ̈ninque tiëë ganca mänimpoga æncæcäimpa. Ayæ̈ botö pönö cæbo æ̈ninque tömengä cöwë wantæpiyæ̈ wæ̈nämaï quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Incæte edæ täno yæcado ongönïnäni pancadäniya wæætë yæmïñæ̈ gote ongönäni bacædänimpa. Ayæ̈ yæmïñæ̈ ongönïnäni inte wæætë yæcado ponte ongoncædänimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Itota ayæ̈ edæ, Öönædë Awënë Odeye nempo æbänö quëwënänii, ante odömoncæte ante ïïmaï apæ̈negacäimpa. “Waocä në ömæ ëacä nänö cæbaï Öönædë Awënë Odeye incæ adobaï cæcampa. Në ëacä ñäö bayö oncodo taodinque, Æcänö ñöwoönæ botö yowementacodë cæquïnaa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ante adinque tömengä beyæ̈ në cæcædäni ïnänite, Mïnitö tömää itædë cæmïni ate botö adocanque ingante deënadio tiguitamö adotamonque pönöninque wacä ingante wacä ingante adotamonque adotamonque pönömo æncæmïnimpa, äñongante Ao ante yowementacodë cæcæ godänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Gote cæyönäni tömantadæ̈ æ̈ñonte në ëacä tömënäni näni godonte æ̈ïñömö gote ayongä wadäni önonque cædämaï a ongönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Adinque tömengä, ‘Mïnitö adobaï gote cæmïni ate eyepæ̈ godömo æncæmïnimpa.’ Angä ëñëninque Ao ante godänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ayæ̈ tæcæbæcä ïñonte adobaï tömengä wadäni ïnänite angä godäni ate wæætë ædæ wæicä ïñonte adobaï taodinque wadäni ïnänite angä godäni. ");
INSERT INTO aucNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ate edæ awæncabo wæiyongante edæ adocä tao ayongä wadäni önonque a ongönäni adinque tömengä tömënäni ïnänite, ‘Quïnante tömää itædë edæ cædämaï a ongömïni.’ ");
INSERT INTO aucNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ante äñongä, ‘Ïñæmpa mönitö ïmönite, Cæedäni, änänipa cæquïmönii.’ Änäni ëñëninque, ‘Mïnitö adobaï edæ botö yowementacodë gote cæedäni,’ angä godänitapa,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ayæ̈, “Gäwadecæ̈ pönï bayonte në ëacä ïñömö tömengä beyæ̈ në apæ̈necä ingante äninque, ‘Botö beyæ̈ në cædäni ïnänite aa pebi pönäni ate bitö tömënäni näni cædï beyæ̈ godömi eyepæ̈ æncædänimpa. Awæncabo wæiyongä ñöwo pönï gote cædïnäni ïnänite edæ täno godömi æ̈näni ate wæætë wëënë gote cædïnäni ïnänite edæ ayæ̈ ate godömi æncædänimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Angä ëñente aa peyongä awæncabo wæiyongä gote cædïnäni inte täno pönäni ate deënadio tiguitamö adotamonque adotamonque godongä æ̈näni. ");
INSERT INTO aucNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ate adinque täno gote cædïnäni guiquënë, Mönö godömenque ænguï impa, ante pönëñönäni tömengä godongä æ̈ninque edæ deënadio tiguitamö incæ adotamonque adotamonque adopo adopo æ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Æ̈ninque tömënäni në ëacä ingante pïinte tededinque, ");
INSERT INTO aucNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Mönitö tömää itædë näwancate cæmöni incæ ïñæmpa cæbii. Ayæ̈ pönäni guiquënë wantæ ïñö adoque ooda ganca cædäni incæ mönitö baï adopo godömi æ̈näni wæmönipa töö.’ ");
INSERT INTO aucNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ante pïïñönäni në ëacä wæætë adocanque ingante apæ̈nedinque, ‘Ïñæmpa botö bitö ïmite wënæ wënæ cæbogaa. Edæ, Deënadio tiguitamö adotamonque pönömo æncæbiimpa, äñömo Ao änämaï ïmitawoo. ");
INSERT INTO aucNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bado, bitö quï incæ ænte goe. Edæ bitö æ̈nï baï ayæ̈ ponte cædingä ingante adopo godonguënëmo intabopa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Edæ botö ëadincoo incæ, Æcänö ingante godonguïmo, ante pönente wædinque ædö cæte tömëmo incæ änämaï inguïmoo. Botö në waa cæbo ïñömote bitö guiquënë edæ pïinte abi awædö,’ ante në ëacä angampa.” ");
INSERT INTO aucNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mäninganca ante odömonte apæ̈nedinque Itota ïñömö, “Mänömaï cædäni ïninque botö, Täno yæcado ongönïnäni inte wæætë yæmïñæ̈ gote ongoncædänimpa, antabopa. Ayæ̈, Yæmïñæ̈ ongönïnäni inte wæætë yæcado ponte ongoncædänimpa, ante apæ̈netabopa,” ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mänïï godinque Eedotadëë gocæ cædinque tömengä mïñæ̈, Dote, ante näni gocabo ïnänite Itota nänënë ænte mäodinque idömæ goyönäni apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ñöwo ïñömö edæ mönö Eedotadëë ïñömö æicæ̈impa. Æi gote ongömö ate adocanque, Waocä në ëñagaingä æyömönö ongongää, ante wadäni ïnänite godö odömongä bæi ongonguïnäni. Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni nempo tömengä botö ïmote pædæ godongä æ̈ninque tömënäni wæætë botö ïmote apænte äninque, Cöwë wæncæcäimpa, ancædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ayæ̈ edæ, Awæ̈ ñænquedïmæ̈ cædinque tömengä ingante timpote wæ̈nöedäni, ante tömënäni oodeoidi ïnämaï ïnäni nempo botö ïmote wæætë mäo godönäni æncædänimpa. Æ̈ninque tömënäni wæætë botö ïmotedö ante badete todinque ayæ̈ tæi tæi päninque awäa timpodäni wæncæboimpa. Näñe wæ̈mo ate Wængonguï angä beyænque botö mëönaa go adoönæque ïñonte ñäni ömæ̈moncæboimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tebedeo wëna Wäö tönö Tantiago ïñöna tömëna badä ïñömö tömënä wëna tönö Itota weca ponte ædæ wææ̈ninque edæ, Botö ämaï ante cæe, ante apæ̈necä. ");
INSERT INTO aucNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ëñëninque Itota, —Mïnö quïnö apæ̈necæte ante pömïï. Äñongante, —Bitö Tæiyæ̈ Awënë Odeye bate tæ̈ contadinque edæ botö wëñæ̈na ïnate ämi ate adocanque bitö tömëmæ̈mi ïnö adocanque dipæ̈mæ̈mi ïnö tæ̈ contaquïna ämopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ëñëninque Itota wæætë, —Ïñæmpa adämaï inte mïnitö ämïni awædö. Botö nantate wæwenguïmæ̈ baï becabo baï mïnatö edæ adotaca becate baï Ao ante botö beyæ̈ nantate wæwenguïmïnaa. Edæ æpæ̈në guiite baï botö wænguïmæ̈ baï guïñënämaï ïmïnapa diyæ̈ botö beyæ̈ wænguïmïnaa. Äñongante, —Ao ante guïñënämaï cæcæmönaimpa, änatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Itota wæætë, —Botö nanguï caate wæwëmo baï mïnatö adotaca bete baï äanque baï caate wæcæmïnaimpa. Näwangä impa. Incæte æcänö botö tömëmæ̈ ïnö æcänö botö dipæ̈mæ̈ ïnö tæ̈ contaquïna botö edæ pönö änämaï ïmopa. Wæætë botö Mæmpo do, Mänïnaque mänimpaa tæ̈ contaquïna, ante në badongaingä inte tömengä adocanque godö angä contaquïna, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mänömaïnö ante tededapa töö, ante ëñëninque wadäni diete ganca tömengä mïñæ̈ në godäni guiquënë ïñäna näna caya ïnate edæ pïïnänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pïïnäni ïninque Itota aa pecä pönäni ate tömënäni ïnänite ïïmaï apæ̈necantapa. —Oodeoidi ïnämaï ïnäni awënëidi æbänö cædänipa, ante do ëñëmïnipa. Tömënäni ïñömö nämä beyænque ante cædinque nanguï pïinte änäni wædinque tömënäni nempo quëwënäni wæætë do ëñente cædänipa. Ayæ̈ tömënäni weca në ñæ̈næ̈näni ïnönäni ïñömö, Tömëmoque ämo ëñente cæedäni, ante pïinte änäni wædänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mïnitö guiquënë tömënäni nämä beyænque ante nanguï änäni baï wïï adobaï cæquënëmïni ïmïnipa. Wæætë mïni cabo ïñömïni adocanque ñæ̈nængä pönï ingä bacæte ante cædinque tömengä wæætë edæ mïnitö beyæ̈ në cæcä baquënengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ayæ̈ yæcado ongöïnente wæcä ïñömö tömengä yæcado ongoncæte ante cædinque wæætë edæ yæmïñæ̈ pönï gote tömänäni ïnänite në cæcä badinque tömengä nämä beyæ̈ ante cædämaï inguënengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Edæ Waobo ëñagaïmo inte adobaï, Botö beyæ̈ pönö cæcædänimpa, ante wïï pömo ïmopa. Wæætë wadäni beyæ̈ godö cæcæte ante pömoimpa. Ayæ̈ edæ nanguï ïnäni tee mönete baï wæwëñönäni botö wæætë, Tömënäni wibæ̈nete tacædänimpa, ante tömëmo wepæ̈ incæ godoncæte ante pömo ïmopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Itota mänïnö godinque Eedicoo näni quëwëñömö ponte tayönäni tömengä mïñæ̈ nanguï ïnäni tee empote godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Goyönäni onguïñæ̈na babetamöna ïñömö taadö wedeca tæ̈ contate a ongöñöna, Itota pongampa, änäni ëñëninque aa pedatapa. —Awënë, bitö Dabii wodi pæ̈ïmi ïnömi inte mönatö ïmönate pönö waadete waa cæe. ");
INSERT INTO aucNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ante äñöna godongämæ̈ godäni guiquënë, Apocæ̈në inguënë quëwënaa, änäni incæ godömenque yedæ aa pedinque, —Awënë, bitö Dabii wodi pæ̈ïmi ïnömi inte mönatö ïmönate pönö waadete waa cæe, änatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Itota ïñömö næ̈ gongæ̈ninque äñecä pöna adinque, —Mïnatö ïmïnate quïnö cæbo ämïnaa. ");
INSERT INTO aucNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Angä ëñëninque, —Awënë gampomömi awinca wi æ̈nete baï aquïmöna, ante wæmöna. ");
INSERT INTO aucNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Äñöna Itota tömëna godongämæ̈ wæte baï pönëninque edæ pædæ gopo gampomongantapa. Gampomongä ate tömëna waa ada badinque Itota mïñæ̈ do godatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mänïï gote Eedotadëë obo pöninque Odibowænquidi ontacamö goïmö Betapaguee näni quëwëñömö ganca pöñönäni Itota tömengä mïñæ̈ në goda mënaa ïnate da godöninque angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tömëna ïnate, —Mänïï näni quëwëñömö ongö amïna. Tömëñömö go guiite ayömïna bodo onquiyæ̈ näna wencaya ñäni ñæ̈ï a ongö acæmïnaimpa. Ñäni ñæ̈ï a ongö adinque mïnatö mänïna ïnate ñï cæyænte botö weca ænte pöeda. ");
INSERT INTO aucNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ayæ̈ mïnatö ïmïnate wææ änäni ëñëninque mïnatö wæætë edæ, Awënë nänö ænguënënö ante ænte gomönapa, ante apæ̈needa. Ayæ̈, Tömengä ïinque cæte ate do da pönongä æncæmïnimpa, ante apæ̈needa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Do ïñömö Wængonguï beyæ̈ në apæ̈necä ïïmaïnö ante nänö apæ̈negaïnö ante edæ ïinque bacæ̈impa, ante mänömaï cætimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tiöno ïñömö quëwënäni ïnänite ïïmaï äedäni, ‘Badogaa, mïnitö Awënë Odeye ñöwo mïnitö weca pongä aedäni. Edæ mönö mäincoo mongæ̈wënongä bodo wengäa tæ̈ contate mönö Awënë pongampa. Tömengä gänë pönengä inte bodoga contate pongä aedäni,’ ante ancæmïnimpa.” Ante docä nänö apæ̈negaïnö ante ñöwo ïinque cætimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mänömaïnö ante angä ëñente godinque tömengä mïñæ̈ në goda ïñömö Itota nänö änïnö baï do cædinque, ");
INSERT INTO aucNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","bodo näna wencaya ïnate töï töï ænte pöninque tömëna weocoo yabæcooque æidämæ̈ wo cæyabæda ate Itota wæ̈nömënæca ïnö æi yiyæ̈ tæ̈ contacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Adinque edæ nanguï ïnäni, Itota nänö ponguïnö, ante tömënäni weocoo yabæcooque ñö cædinque bee podöwayönäni wadäni guiquënë gönea gote yæpæ̈ma öñabo tapænte mämö bee bee podöwadäni ate tömengä podöwaïnonque gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gocä adinque täno godäni tönö ayæ̈ pönäni tönö godongämæ̈ godinque nanguï ïnäni yedæ äninque, —Bitö Awënë Dabii wodi pæ̈ïmi ïnömi inte pömi adinque, Möni quëwenguinque impa, ante, Badogaa, ante tomönipa. Awënë Wængonguï ëmöwo beyænque pömi ïninque bitö toquinque edæ Wængonguï bitö ïmite waa cæcæcäimpa. Ayæ̈ öönædë ïñömö adobaï, Badogaa, möni quëwenguinque, ante ingæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ante mänïï cædinque pöñönäni, Itota Eedotadëë pongä adinque mänïñömö quëwënäni ancai guïñëninque, —Mäningä æcänö ingää. ");
INSERT INTO aucNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ante wæyönäni godongämæ̈ pönäni ïñömö, —Itota ingampa. Tömengä ïñömö Wængonguï beyæ̈ në apæ̈necä ïnongä inte Gadideabæ Näatadeta quëwente pongä ingampa, ante apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Itota ïñömö Wængonguï oncö ñæ̈næncönë yabæcönë pö guiidinque mänïñömö mäincoo mänäni tönö wadäni në godonte æ̈näni tönö ongönäni adinque tömengä tömänäni ïnänite, Oncodo taoedäni, äninque da tadongä oncodo tao godänitapa. Ayæ̈ campio ante näni godonte æ̈impa tönö equemö godoncæte ante në mänäni näni cönöimpa tönö bæ tacä tömampaa guidömëmæ̈ tæ̈ go wææntapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ayæ̈ tömënäni ïnänite angantapa. —Wængonguï beyæ̈ ïïmaïnö ante yewæ̈mongatimpa. “Waodäni botö oncönë pö guiidinque botö ïmote apæ̈necædänimpa,” ante Wængonguï angä incæte mïnitö wënæ wënæ cæmïni beyænque Wængonguï oncö incæ në awëmö ö æ̈näni näni womöincönë baï wentamö bapa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Äninque Itota ayæ̈ Wængonguï oncö ñæ̈næncönë yabæcönë ongöñongä pæ opa pæ opa godäni tönö babetamönäni tömengä weca pönäni adinque tömengä godö cæcä ate waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mänömaï mä cæcä waa badäni ate wædinque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni guiquënë pïinte badänitapa. Ayæ̈ wëñæ̈näni Wængonguï oncö ñæ̈næncö yabæque ongöninque yedæ äninque, “Badogaa, Awënë Dabii pæ̈ïmi ïnömi adinque möni quëwenguinque impa,” ante Yæ änänitapa. Änäni ëñëninque në godönäni ñæ̈næ̈näni tönö në odömönäni ænguï badinque ");
INSERT INTO aucNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Itota ingante änänitapa. —Wëñæ̈näni æbänö änäni ëñënämaï ïmitawo. Äñönäni Itota, Do ëñëmopa. Ïñæmpa mïnitö guiquënë Wængonguï beyæ̈ ante ïïmaïnö ante yewæ̈monte ongö adämaï inte änewëmïnitawo. “Bitö tæcæ ëñadäni tönö goömæ̈ në gänäni ïnänite apæ̈nebi ëñente, tömënäni Ao ante nö pönï tededinque, Wængonguï tæiyæ̈ waëmö ingänö, ante watapæ̈ apæ̈nedänipa.” Mänömaïnö ante yewæ̈monte ï apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Äninque Itota edæ tömënäni ïnänite ëmö cæte wadæ godinque Betänia näni quëwëñömö gote mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ñäö bayö Eedotadëë näni quëwënö gämæ̈nö adodö pöninque Itota gæ̈wænte wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Gomö adinque iigowæ̈ a ongö ponte ayongä öñaboque ëmæ̈ adinque, —Ömæcabi ïmi cöwë incadämaï incæbiimpa. Äñongä iigowæ̈ incæ guïñë wæ̈nimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Guïñë wæ̈ adinque tömengä mïñæ̈ në godäni ïñömö, —Quïmæ̈ iigowæ̈ ïñontobæ̈ guïñë wæ̈ amöö. ");
INSERT INTO aucNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ante wæyönäni Itota ïñömö edæ, —Näwangä ante mïnitö ïmïnite apæ̈nebopa. Wïï æ̈mæ pönëmïni inte wede pönëmïni ïninque mïnitö iigowæ̈ inte botö cæbaï adobaï do cæbaïmïni. Ayæ̈ godömenque cædinque mïnitö änanquidi ongö ate, “Änanquidi ëñëmi, äninque, Bitö cabænte wo gote gäwapæ̈në guiie,” ante ämïni ïninque edæ mïnitö änïnö baï do babaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wængonguï ingante wede pönëmïni ïninque quïëmë incæ ante tömengä ingante apæ̈nemïni incæ mïni änïnö tömänö æncæmïnimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Itota ayæ̈ Wængonguï oncö ñæ̈næncönë yabæcönë pö guiidinque odömonte apæ̈necä ëñëñönäni, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö oodeoidi ïnänite në aadäni, Näni Picæncabo, näni änäni tönö tömengä weca pöninque änänitapa. —Æcänö në angä inte bitö ïmite angä cæbii. Ïñæmpa, Në ämi bacæbiimpa, ante æcänö pönö äna ëñente në ämi inte baï cæbii, ante ëñencæte ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Änäni ëñëninque, —Mïni ämaï botö adodeque ämo ëñëninque mïnitö täno apæ̈nemïni ëñente ate mänïñedë ate botö wæætë, Æcänö në äna inte pönö angä cæboo, ante apæ̈nebo ëñëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wäö wodi ingante guiquënë, Bitö æpæ̈në guidoncæbiimpa, ante æcänö äna ëñente guidongäï, ante pönëmïnii. Wængonguï öönædë apæ̈necä ëñente cæcantawo. Wæætë edæ waodänique änäni ëñente cæcantawo. Ædö ante pönëmïnii. Itota angä ëñëninque tömënäni nämäneque wæætedö wæætë tedecöninque, “Wa, æbänö anguïï, ante wædänitapa. Ïñæmpa, Wængonguï angä ëñëninque Wäö cægacäimpa, ämö baï Itota wæætë mönö ïmonte, ‘Quïnante pönënämaï ïmïnitawo,’ ancædongäimpa,” ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wæætë edæ, “Waodäni tömänäni, Wængonguï beyæ̈ në apæ̈necä Wäö wodi ingacäimpa, ante pönënänipa, ante pönente wædinque Itota ingante në änäni ïñömö, Wadäni pïïnäni wæcæ wæ, äninque, Waodänique änäni ëñente Wäö cægacäimpa, ante mönö ædö cæte anguïï.” ");
INSERT INTO aucNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ante pönëninque tömënäni Itota ingante edæ, —Wa, ëñënämaï ïmönipa. Ante wæyönäni Itota edæ, Ïninque botö adobaï, Æcänö në angä inte pönö angä cæboo, ante mïni änïnö ante apæ̈nedämaï incæboimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Itota odömoncæte ante apæ̈nedinque, —Mïnitö guiquënë odömonte tedebo ate ämo ëñente apæ̈nemïni ëñëmoedäni. Ïïmaï impa. Waocä tömengä wëna mënaa ïñöna adocanque weca godinque mæmpocä ïñömö, “Botö wëmi, bitö ñöwoönæ yowementacodë cæte pöe.” ");
INSERT INTO aucNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Äñongä edæ, “Wïï goïnëmo,” angampa. Wæætë edæ ayæ̈ ate pönencöninque edæ, Botö ædö cæte Baa äninque quëwëmoo, ante pönëninque edæ mæmpocä nänö änïnö ante ëñëninque edæ cæcæ gocampa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ayæ̈ ate mæmpocä wæætë wacä wengä weca adobaï mäo äñongä tömengä edæ, “Bitö mæmpobi ämi ëñente gocæboimpa,” ante apæ̈necä incæte edæ godämaï ingampa. Mäninque ante tedebo. ");
INSERT INTO aucNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ñöwo mïnitö ïmïnite ämopa, Mæmpocä nänö änö baï æcänö cæcäï, ante pönëmïni. Äñongante, —Tänocä. Ante apæ̈neyönäni Itota tömënäni ïnänite wæætë, —Näwangä ämopa. Mïnitö Awënë Wængonguï Odeye nempo pö guiidämaï ïñömïnite odömäno awënë beyæ̈ në æ̈wënäni tönö onquiyæ̈näni mäincoo beyæ̈ ante në towente quëwënäni tönö täno ponte do guiicædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Edæ Wäö wodi mïnitö weca ponte nö cæte töïnö ante odömöñongante mïnitö ïñömö pönëmïnitawogaa. Ayæ̈ godömenque awënë beyæ̈ në æ̈wënäni incæ mäincoo beyæ̈ ante në towente quëwënäni tönö incæ do pönënänipa. Ayæ̈ mïnitö mänömaï cædäni adïmïni incæte wæætë wënæ wënæ mïni cædïnö ante wædämaï inte wïï pönëmïnitapa töö, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ayæ̈ godömenque apæ̈nedinque Itota, “Wængonguï Awënë æbänö cæcää, ante ëñencæmïnimpa, ante botö ïmæca quëwënäni näni cæïnö ante odömonte apæ̈nebo ëñëedäni. Edæ ïïmaï impa. Ömæ ëacä yowementacodë da da mäo da caate wææ cædinque, Tömëmö ænte pïnä pïnä gäwate wæ yopænte tömëmæ̈ ænguïñömö ante cædinque æ̈æ̈ wote badongantapa. Ayæ̈, Yowementacodë awëmö guiidämaï incædänimpa, ante cædinque æi wæ̈nömënæca gomö aquïñömö mæ̈nongä ate në ëacä ïñömö wabæca gocæ cædinque wadäni ömæ wite në aate tä pedäni ïnänite apæ̈necantapa. Botö yowementacodë incæ mïnitö ömæ wite aaedäni. Aayömïnite botö, Mïnitö quï, ante pancamonga pönömo æncæmïnimpa, angä Ao äñönäni wadæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ayæ̈ yowedepo wodo bayonte tömengä ingante në cædäni ïnänite, Mïnitö yowementacodë në aadäni weca godinque botö yowemö incæ pancamonga ämïni æ̈ninque botö weca wæætë mämömïni æ̈moedäni, angä godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Angä godinque pönäni adinque yowementacodë në aadäni guiquënë në æncæ pönäni ïnänite bæi ongöninque adocanque ingante nanguï tæi tæi päninque wacä ingante godömenque wæ̈nönäni wængä ate ayæ̈ wacä ingante dicaca tacadäni. ");
INSERT INTO aucNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Adinque mäo apæ̈nedäni wædinque në ëacä ïñömö wæætë godömenque nanguï ïnäni da godongä gote pönäni adinque në aadäni guiquënë adobaï cædäni wædänitapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ayæ̈ godömenque odömöninque Itota apæ̈necantapa. “Ïninque në ëacä ïñömö, ‘Tömëmo wengä ingante da godömo gocä adinque tömënäni guïñente wædinque ee abaïnänipa,’ äninque tömengä ingante da godongä tömangä pönï gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yowementacodë në aadäni guiquënë gomö ayönäni në ëacä wengä dicæ pongä adinque, ‘Tömengä ingampa. Wæmpocä mäincoo ïnï edæ ïingä ïñömö në ænguingä ingampa cæmöö. Mönö edæ mäo wæ̈nömö wængä ate edæ mönö quï babaimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Änewëninque tömënäni në ëacä wengä ingante edæ bæi ongonte yowementacodë wææ cæte ïñömö yabæque edæ, Ömäe, ante wæ̈nönäni wængantapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ante mäninganca odömonte apæ̈nedinque Itota ïñömö tömengä ingante në änïnäni ïnänite angantapa. “Ïninque mïnitö ïñömö, Në ëacä pöninque edæ yowementacodë në aaquënënäni ïnänite æbänö cæquingää, ante pönëmïni.” ");
INSERT INTO aucNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ante äñongante tömënäni wæætë, —Ömäe, ante në wæ̈nönïnäni ïnänite tömengä näëmæ̈ edæ, Ömäe, ante wæ̈nongä wæncædänimpa. Ayæ̈ wæætë, Ædänidö nö cædinque yowedepo ïñö yowedepo ïñö tä pete pönönäni ænguïmoo, ante adinque awënë, Mïnitö wæætë aacæmïnimpa, angä Ao ante aacædänimpa, ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Itota ayæ̈ tömënäni ïnänite, —Wængonguï angä ëñente näni yewæ̈mongaintaa æbänö ongö ante mïnitö adämaï inte ämïni awædö, angantapa. “Dica ænte adinque, Wënæ wënæ inca, ante në mæ̈nönäni näni wido cædinca incæ gomonga waëmonca inca ïninque täno näni ñönöninca bæbængapa do bacapa. Wængonguï Awënë incæ mänömaï cæcä adinque mönö waocabo guïñente wædinque waa amompa,” Ante yewæ̈monte impa abaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mänïnö mïni ëñënämaï ïnö beyæ̈ mïnitö Awënë Wængonguï Odeye nempo quëwente mïni cæquënënö incæ ö ænte baï cæcä wæcæmïnimpa. Ayæ̈ wæætë wadäni ïnänite tömëmö wainca incate baï nö cædäni ïnänite godö angä ëñëninque tömënäni wæætë tömengä nempo quëwente waa cæcædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Botö ïñömö mänïï dica waëmonca baï ïnömo inte ämo ëñëninque në wæcä ïñömö tömengä ïñömö mänincaa tæ̈ go wææ̈ninque wædænque tobænte wæcä baï ïnongä inte botö önöwa gäänë ædæ wææncæcäimpa. Wæætë æcänö ingante Wængonguï pïinte mänincaca tacacä ïnaa tömengä guiquënë quïëmë baï yaintai baï goquïnö anguënë, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ante në aaquënënäni näni cæïnö ante odömöninque Itota apæ̈necä ëñente wædinque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö Paditeoidi ïñömö, Ïñæmpa mönö ïmonte pïinte angä awædö, ante pönente wædinque, ");
INSERT INTO aucNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Quïnö cæte tömengä ingante bæi ongonte ö ænguïï, ante cöwä adänitapa. Incæte, Waodäni tömänäni, Wængonguï beyæ̈ në apæ̈necä Itota ïnongä ingampa, ante pönënänipa, ante wædinque, Pïïnäni wæcæ wæ, äninque edæ ñimpo cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Wængonguï Awënë æbänö cæquingää, ante ëñencæmïnimpa, ante ïmæca awënë nänö cæïnö ante Itota tömänäni ïnänite wæætë odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Inguipoga awënë odeye tömengä wëñæ̈ beyæ̈ monguïmæ̈no ante nänö cæbaï öönædë Awënë Odeye ïñömö adobaï cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Inguipoga awënë ïñömö tömengä ingante në cædäni ïnänite, Wëënë botö änïnäni ïnänite wente ænte pöedäni. Angä të të wente æ̈näni ëñëninque edæ, Wïï pöïnëwædö, änäni. ");
INSERT INTO aucNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ëñente wædinque awënë wæætë wadäni tömengä ingante në cædäni ïnänite da godöninque, ‘Wëënë botö änïnäni weca godinque botö beyæ̈ ïïmaïnö ante apæ̈nemïni ëñencædänimpa. Botö wengä monguïmæ̈no ante wagadaidi onguïñæ̈näni tönö cæ̈nïnäni oguïmo pönï ïnäni ïnänite do wæ̈nöninque botö æ̈æ̈mæ̈noca do eyepæ̈ cæbopa. Botö wengä monguïmæ̈no pö beedäni, ante mæmpocä angampa, ante edæ botö beyæ̈ apæ̈needäni.’ ");
INSERT INTO aucNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Angä ëñëninque gote apæ̈neyönäni tömënäni ëñënämaï inte önonque wadæ godinque pancadäniya gönea ante goyönäni wadäni godonte æncæte ante godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wadäni ayæ̈ ongönäni guiquënë ëñënämaï inte awënë nänö da godonte në cædäni ïnänite pïinte wënæ wënæ cædäni wæyönäni mäo wæ̈nönäni wæ̈nänitapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Mänömaï cædäni ate wædinque awënë odeye ïñömö äingä badinque tömengä tontadoidi ïnänite angä ëñëninque në wæ̈nönïnäni ïnänite mäo capo wæ̈nönäni. Wæ̈näni adinque godömenque onconcoo tömënäni näni ëadincoo iya tänäni. ");
INSERT INTO aucNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ïninque edæ awënë wæætë tömengä ingante në cædäni ïnänite, ‘Monguïmæ̈no do eyepæ̈ cæte ongö incæte botö në änïnäni waa cædänipa diyæ̈ ämo bequïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ïninque mïnitö wæætë edæ iyæ̈nompoga iyæ̈nompoga mäo godinque æcämenque ingante bee tëninque tömënäni tömänäni ïnänite ämïni æ̈æ̈mæ̈no pö becædänimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Angä ëñente cædinque në cædäni taadonque pö bee bee bee tëninque waa cædäni incæ wïwa cædäni incæ tömänäni ïnänite äñete ænte mämönäni pö monguïmæ̈no oncönë pö guiidinque eyede goto gongænte bedänitapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ayæ̈, “Awënë odeye ïñömö ëñacæ pö bedäni ïnänite acæ guiiyongä edæ adocanque monguïmæ̈no bequï weocoo awënë odeye nänö pönönincoo incæ wëñadämaï inte önoncooque ee mongængä. ");
INSERT INTO aucNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Adinque, ‘Æ̈migo, bitö ædö cæte monguïmæ̈no weocoo wëñadämaï inte önoncooque ee mongænte guiibii,’ ante äñongä edæ pæ wëënecä. ");
INSERT INTO aucNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Adinque awënë odeye ïñömö në aadäni ïnänite äninque, ‘Në monguïmæ̈no weocoo wëñadämaï ingä ingante mïnitö goti wimpote wææ̈ goti wëwate edæ wëmö ïñömö näni guingo imonte Yæ yæ ante wæyömö mäo wido cæedäni,’ ante awënë odeye angampa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mänömaï näni cædö baï adobaï impa. Edæ nanguï ïnäni ïnänite Wængonguï, Pöedäni, angä incæte edæ wædænque ïnäni ïnänite apænte Ao ante ængampa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Itota mänömaï apæ̈necä ëñente wædinque Paditeoidi wadæ godinque godongämæ̈ ponëë cöninque, Mönö pïinte apænte anguinque ante quïnö cæmö ate Itota adodeque wapiticæ̈ tededinque oda cæquingää. ");
INSERT INTO aucNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ante pönëninque tömënäni në ëmïñæ̈näni tönö Edodeidi ïnänite da godönäni godinque Itota weca pöninque, —Awënë në Odömömi ëñëmi. Bitö nö pönente cæbi ïmipa, ante do ëñëmönipa. Ayæ̈ bitö ayömi mönitö tömämöni önömönique ïmöni adinque bitö, Waodäni æbänö anguïnänii, ante ayæ̈, Æbänö cæquïnänii, ante wædämaï ïnömi inte edæ Wængonguï taadö ante guïñënämaï inte nö odömonte apæ̈nebipa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ïninque bitö æbänö pönëmii. Odömäno gobiedöno beyæ̈ ante tæiyæ̈ awënë Tetædo tiguitamö nänö änintamö ante æbänö wææ yewæ̈monte ï, ante ëñencæte ante wæmönipa edæ. Godonte edæ waa cæte intawo. Wæætë wënæ wënæ cæte intawo, ante apæ̈nebi ëñencæmönimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Äñönäni Itota ïñömö tömënäni do, Cæmö wapiticæ̈ tedecæcäimpa, ante näni änïnö ante do ëñëninque tömënäni ïnänite wæætë edæ, —Mïni wadö tedete wadö cæcabo ïñömö edæ quïnante botö ïmote, Æbänö cæmö oda cæquingää, ante cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tetædo tiguitamö nänö änintamö odömömïni aquïmo. Äñongä deënadio tiguitamö adotamonque ænte pönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Adinque tömënäni ïnänite Itota, —Æcänö awinca baï yewæ̈monte badonte ï. Edæ æcänö ëmöwo ante yewæ̈monte ï. ");
INSERT INTO aucNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Äñongante, —Awënë Tetædo awinca baï yewæ̈monte badonte impa. Adocä ëmöwo ante yewæ̈monte ongö amönipa. Änäni ëñëninque Itota ïñömö edæ, —Awënë Tetædo quï ï ïninque edæ Tetædo ingante godongæ̈impa. Wæætë Awënë Wængonguï quï ï ïninque Wængonguï ingante godonguï ï apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ante Itota nänö änïnö ëñente beyæ̈, Quïëmë baï angää, ante ancai guïñente wædinque wadæ gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mänïönæ adoönæ ïñonte Tadoteoidi në, Waocä wæ̈ninque ñäni ömæ̈mönämaï æ̈mæ̈wo wængampa, ante në änewënäni inte Itota weca pöninque, Ïïmaïnö ante ëñencæte ante wæmönipa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Awënë në Odömömi ëñëmi. Möitee wodi mönö beyæ̈ ante wææ yewæ̈möninque ïïmaï ante yewæ̈mongacäimpa. Waocä möninque wëñæ̈ tapæ̈idämaï inte wængä ate tömengä tönïñacä wæætë owæmpoingä ingante möninque wëñæ̈ tapæ̈idinque, Botö tönïñacä wodi wengä ingampa, ante pæpogacæcäimpa, ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ñöwo ïñömö möni cabo ïñömönite adodäni näni caipæ̈ önompo æ̈mæmpoque go mënaa ïnäni ïñönäni bamoncadengä möninque wëñæ̈ tapæ̈idämaï manguïwëninque edæ näñe wængä ate ayæ̈mengä wæætë owæmpodingä ingante mongä. ");
INSERT INTO aucNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ïninque ayæ̈mengä incæ adobaï wëñæ̈ ömæpocä näñe wængantapa. Ayæ̈ wææ̈ wacä ayæ̈mengä adocä ingante monte ate wëñæ̈ adobaï tapæ̈idämaï inte edæ näñe wængantapa. Ayæ̈ wææ̈ wacä adobaingä, ayæ̈ wææ̈ wacä tapæ̈idämaï inte näñe, ayæ̈ wææ̈ wacä, ayæ̈ wææ̈ ayæ̈mengä pönï adocä ingante möninque wëñæ̈ tapæ̈idämaï inte näñe wængantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Onquiyængä guiquënë owæmpote wædinque tömangä pönï näñe wængantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ïninque, Mönö ñäni ömæ̈monguïönæ, ante mïni äönæ ïñonte mäningä owæmpoingä ïñömö æcänö nänöogængä baquingää. Edæ tömengä ingante ïñömö edæ tömänäni manguïwengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Äñönänite Itota wæætë, —Mïnitö ïñæmpa. Wængonguï angä ëñente näni yewæ̈möinta adämaï inte baï ämïni awædö. Wængonguï adocanque tæ̈ï pïñængä inte edæ tömää cæcampa, ante pönënämaï inte edæ oda cæte ämïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Edæ Wængonguï anquedoidi öönædë cöwë owodäni baï ïnönäni inte waodäni ñäni ömæ̈möninque godö ñänönämaï ïnäni inte edæ mönämaï inguïnänidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wæætë do wængaïnäni näni ñäni ömæ̈monguïnö ante ëñencæmïnimpa, ante Wængonguï beyæ̈ yewæ̈monte ongö adämaï ïmïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Botö ïñömö Abadäö Wængonguïmo ingaïmo inte ayæ̈ Itæca Wængonguïmo ingaïmo inte botö Aacobo Wængonguïmo adobo ïmo anguënë,” angacäimpa. Ante në angaingä inte edæ æ̈mæ̈wo wæ̈nïnäni tömënäni Wængonguingä ædö cæte inguingää. Wæætë edæ mïï quëwënänique tömënäni Wængonguï ïnongä ingampa. Ïninque edæ në wænte godïnäni incæ ayæ̈ mïïnäni quëwënäni ïnänipa, ante pönenguënë änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ante apæ̈necä ëñëninque godongämæ̈ ëñengönäni guiquënë, Æbänö cæte Itota waa pönï odömonte apæ̈necä ëñëmönii, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tadoteoidi guiquënë, Ædö cæte gomonga anguïï, ante edæ pæ wëënedänitapa. Mänömaï Itota nänö nö änïnö beyæ̈ pæ wëënedänipa, ante tededäni ëñëninque Paditeoidi wæætë godongämæ̈ pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Itota æbänö cæte wapiticæ̈ ämaingää, ante pönëñönäni adocanque idægoidi näni wææ angaïnö ante në ate ëñënongä ïñömö Itota ingante angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Awënë në Odömömi ëñëmi. Wængonguï, Ïïmaï cæedäni, ante nänö wææ angaïnecoo ante pönëninque ædedö tæ̈ïne pönï ï ïñonte mönö nanguï ëñente waa cæquïï. ");
INSERT INTO aucNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Äñongante Itota ïñömö, —Ïïmaïnö ante nänö wææ angaïne ïñömö edæ tæ̈ïne pönï ïñonte mönö nanguï ëñente waa cæcæ̈impa. “Wængonguï mönö Awënë ingante bitö mïmö entawente waadedinque bitö ocai encabi inte nö pönëninque bitö önöwoca ëwocabi inte edæ tömengä ingante ædæmö waa waadete pönëe.” ");
INSERT INTO aucNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mänïne nänö wææ angaïnö waa pönï ï ïninque mänïne täno waa cæquï impa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ayæ̈ wade nänö angaïnö adobaï nanguï waa ëñente cæquï impa. “Bitö nämä bitö waadete waa cædö baï adobaï pönëninque wadäni ïnänite adobaï waa waadete cæe.” ");
INSERT INTO aucNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ïïmaï cæedäni, ante Möitee wodi nänö wææ angaïnö ayæ̈ Wængonguï beyæ̈ në apæ̈nedäni näni angaïnö cæcæte ante cædinque edæ mänïne Wængonguï mënea nänö wææ angaïne ëñente cæte beyænque edæ tömänö edæ do eyepæ̈ cæte impa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mänïï Paditeoidi adoyömö ponte ayæ̈ ongöñönäni Itota tömënäni ïnänite angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Itota ïñömö tömënäni ïnänite, —Codito ïñömö æcänö ingää, ante pönëmïni. Æcänö Wengä ïnongä ingää, ante pönëmïni. Ante äñongante Paditeoidi wæætë, —Awënë Dabii pæ̈ingä ïnongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Äñönänite Itota edæ, —Awënë Dabii pæ̈ingä ïnongä ïñongante edæ Dabii tömë edæ Codito ingantedö äninque quïnante, Awënë ïmipa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Awënë Wængonguï incæ botö Awënë ingante apæ̈nedinque, Botö tömëmæ̈ ïnö tæ̈ contayömi, bitö ïmite në pïïnäni ïnänite bæ tabo ate bitö önöwa gäänë ongöñönänite bitö pïnä gäwacæbiimpa, angacäimpa.” Ante Wængonguï Önöwoca apæ̈necä ëñëninque Dabii wodi yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Codito në Awënë ingampa, ante awënë Dabii wodi nänö në angaingä ïnongä inte edæ adocä Codito ïñömö ædö cæte näëmæ̈ Awënë Dabii wodi pæ̈ingä inguingää, ante pönenguënë änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ante äñongä edæ tömänäni, Mönö ædö cæte wæætë anguïï, äninque ëñënämaï inte edæ pæ wëënegadänimpa. Ayæ̈ ïincayæ̈ ate, Apæ̈nebi ëñëmönii, ante ædö cæte anguïmoo, ante edæ tömänäni guïñente wædinque änämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pæ wëënedäni adinque tömengä mïñæ̈ në godäni godongämæ̈ ongönäni nanguï ïnäni tönö ongöñönänite Itota tömänäni ïnänite apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Në odömönäni tönö Paditeoidi ïñömö Möitee wodi nänö angaïnö ante në ëñënäni inte në nö odömonte apæ̈nedäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mänömaï ïnäni adinque mïnitö ïñömö tömënäni änïnö ante tömänö ante cöwë ëñente cæedäni. Wæætë tömënäni näni cæï baï cædämaï ïedäni. Edæ, Ïïmaï cæedäni ïïmaï cæedäni, ante näni änö ante tömënäni nämä incæ ëñënämaï cædänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Edæ mäincoo teëmencoo mö paate wadäni önönancapæ̈ cö cædancapæ̈näni baï cædinque tömënäni, Wadäni guëmancædänimpa, ante cædämaï ïnäni inte önompogonca adopogoncaque incæ gä æ̈nancapæ̈nämaï ïnänipa.” ");
INSERT INTO aucNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Quïëmë cædäni incæ tömënäni cöwë, Wadäni botö ïmote waa acædänimpa, ante cædänipa. Wadäni, Bitö Wængonguï beyæ̈ näni yewæ̈mongainta nanguï abi ïmipa, ante pönëninque mönitö ïmönite waa acædänimpa, ante babæ cædinque mäninta æ̈montaicade ñæ̈næ̈ pönï badonte mïni tente önoncaipoga wo cæte encapodänipa. Ayæ̈, Bitö Wængonguï ingante nanguï apæ̈nebi ïmipa, ante pönencædänimpa, ante cædinque tömënäni weocoo ñä cæwate ñä cæwate doyæ̈ guënë ëwa badöninque doyæ̈ pönï wëñate mongæ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ayæ̈ æ̈æ̈mæ̈ becæ godinque tömënäni, Botö täno bete tocæboimpa, ante waëmompaa pönï tæ̈ contate bete todänipa. Ayæ̈ Wængonguï angä näni ëñente yewæ̈mongainta ate odömöincönë pö guiidinque tömënäni nämanque ante pönëninque waëmompaa pönï tæ̈ contate todänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ayæ̈ waodäni näni godonte æ̈ïñömö waïnö pancadë goyönäni wadäni pö bee tëninque, Në odömömi, bitö ïmite waa amönipa, ante apæ̈nedäni ëñëninque edæ në odömönäni ïñömö nanguï todänipa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ayæ̈ apæ̈nedinque, “Mïnitö guiquënë mïnitö Awënë në Odömongä adocanque pönï ïñongä mïni caipæ̈ ïñömïnite wadäni, Awënë në odömömi ïmipa, ante änämaï incædänimpa, ante wææ cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ayæ̈ mönö Mæmpo adocanque pönï öönædë quëwengä ingä adinque mïnitö waocä ingantedö ante apæ̈nedinque, Mönö mæmpo ingampa, ante änämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ayæ̈, Mönö Awënë në Odömongä ïñömö adocanque pönï Codito ïnongä ingampa, ante ëñëmïni ïñömïnite wadäni, Në ämi ïmipa, ante änämaï incædänimpa, ante wææ cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ayæ̈ edæ mïni cabo ïñömïnite wacä beyæ̈ wacä në godö cæcä ïñömö ñæ̈nængä pönï ingä incæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Edæ nämä ængö cæte baï cædinque æcänö, Botö botö, äna tömengä ïñömö edæ wææntodonte baï önonque bacæcäimpa. Wæætë æcänö, Botö botö, änämaï inte, Önömoque ïmopa, äna ïñömö edæ tömengä ingante ængö cæte baï cædäni adinque wadäni tömengä ingante waa acædänimpa,” ante Itota tömengä mïñæ̈ në godäni ïnänite apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ayæ̈ në odömönäni tönö Paditeoidi ïnänite Itota pïinte angantapa. “Mïnitö ïñömö mïni pante wæquinque edæ wadö tedete wadö cæmïni ïmïnipa. Wadäni öönædë Awënë Odeye nempo guiidämaï incædänimpa, ante mïnitö odemö tee mönete baï wææ cæmïnipa. Tömëmïni guiidämaï ïmïni inte mïnitö wadäni guiicæ cæyönänite edæ tömënäni näni guiidämaï wæquinque edæ wææ cæmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Në odömömïni tönö Paditeoidi ïmïni mïni wadö tedete wadö cædincabo inte mïni wæquinque impa. Owæmpoïnäni oncö ö æ̈mïni incæte mïnitö, Wantæpiyæ̈ botö tedebo beyænque wadäni botö ïmote waa acædänimpa, ante Wængonguï ingante wantæpiyæ̈ në tedemïni inte godömenque mïni panguinque ingæ̈impa,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ayæ̈ apæ̈nedinque, “Në odömömïni tönö Paditeoidi ïmïni mïni wadö tedete wadö cædincabo inte mïni wæquinque. Edæ, Adocanque incæ mönitö ëmïñængä bacæcäimpa, ante mïnitö æpæ̈ tömämæ̈ wogaa gote diqui diqui mïninque inguipoga taadö tömänö gote diqui diqui minte ayömïni adocanque Ao angä adinque mïnitö tömengä ingante godö odömömïni. Ëñëninque tömengä guiquënë mïnitö wënæ wënæ goquïnö godömenque godinque gomonga në wënæ wënæ cæcä badinque tadömengadænguipo nänö gomonga panguinque mïnitö mïñæ̈ tee empote gocampa töö.” ");
INSERT INTO aucNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ayæ̈, “Babetamömïni mïni wæquinque babæ ante mäomïni ate edæ oda cæte godänipa. Ïñæmpa ïïmaï änewëmïnipa. ‘Botö änö nöingä baquïnö anguënë, ancæte ante æcänö, Wængonguï tæiyæ̈ waëmö oncö tæ̈ï ongö baï impa, äna tömengä önonque tedete apæ̈necampa, ante änewëmïnipa. Wæætë edæ, Wængonguï tæiyæ̈ waëmö oncö oodo mæ̈ ongö baï impa, ante æcänö äna guiquënë tömengä nö angä inte cæcæcäimpa,’ ante mïnitö ïñömö babæ wapiticæ̈ ämïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mïni babetamö incabo mïmö ömædë incædö. Edæ Wængonguï tæiyæ̈ waëmö oncönë oodo öñö adinque, Oodo incæ godömenque waa pönï impa, ante babæ ante pönëmïnipa. Ïñæmpa oodo æ̈ninque, Wængonguï oncö waëmö ëmonguinta, ante ænte badönäni beyænque oodo tæiyæ̈ waëmö bapa, ante pönëmïniyaa.” ");
INSERT INTO aucNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ayæ̈ edæ mïnitö babæ apæ̈nedinque, ‘Botö änö nöingä baquïnö anguënë, ancæte ante waocä, Wængonguï quï, ante baö näni iya täimpaa tæ̈ï ongö baï impa, ante æcänö äna önonque tedecampa. Wæætë mänïnö ancæte ante, Baö iya täimpaa näni iya tanguingä baï impa, ante æcänö äna ïñömö tömengä nö ante cæcæcäimpa,’ ante mïnitö babæ wapiticæ̈ ämïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mïni babetamö incabo ämïni ëñëmoedäni. Ædö waa intawo. Näni iya täimpaa incædö tæiyæ̈ waëmö intawo. Wæætë edæ baö näni iya tanguingä incæ tæiyæ̈ waëmö intawo. Æbänö ante pönëmïni. Ïñæmpa baö æ̈ninque, Wængonguï quï, ante iya tänäni beyænque baö näwäaquingä bacampa, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ïninque, Botö änö nöingä baquïnö anguënë, ancæte ante waocä, Näni iya täimpaa tæ̈ï ongö baï impa, ante æcänö äna tömengä, Iya täimpaa tönö baö näni iya tanguingä tönö tömää beyæ̈, ante baï dobæ angampa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ayæ̈ æcänö, Wængonguï tæiyæ̈ waëmö oncö beyænque ante näwangä baquïnö anguënë, äna tömengä Wængonguï oncö beyæ̈ ayæ̈ mänincönë në owocä beyæ̈ adobaï dobæ angampa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ayæ̈ æcänö, Öönædë beyænque näwangä baquïnö anguënë, äna tömengä edæ Wængonguï nänö contaimpaa beyæ̈ ayæ̈ contaimpaa në Contacä beyæ̈ adobaï dobæ angampa,” ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ayæ̈ apæ̈nedinque Itota, “Në odömömïni tönö Paditeoidi incæ mïni wadö tedete wadö cædincabo inte mïni wæquinque impa. Tömëmïni mïni minte pædïmö tönö guïmö oguï wayabo tönö tömëmö mïni tä pete æ̈nïmö të gæte diete ganca mïni cabo të gædincoo ñö cædinque adocooque æ̈ninque, Wængonguï quï, ante godöninque waa cæmïnipa. Incæte edæ Wængonguï, Nö cæedäni, ante nänö änö ante, Godö waadete waa cæedäni, ante nänö änö ante, Wede pönente cæedäni, ante nänö änö ante mïnitö mïni wæquinque ëñente cædämaï ïmïnipa. Ïïmaï täno waa cæquënëmïni inte mïnitö mänincoo ayæ̈ godömenque Wængonguï ingante godömïni inguënëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Babetamömïni babæ ante mäomïni ate edæ oda cæte godänipa. Mïnitö, Diete ganca mïnitö mäincoo ongö adinque adocooque cöwë godonguï ï, äninque owætaca bequïñömö guincawæ owoyö tæ̈ wedote baï cæmïnipa. Wæætë edæ Wængonguï nänö änö baï cædämaï inte mïnitö edæ cämeyo ñæ̈nængade pönï owoyö önonque ade bete baï pönënämaï inte cæmïnipa, ante awædö,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ayæ̈ në odömönäni tönö Paditeoidi ïnänite godömenque äninque tömengä, “Mïni wadö tedete wadö cæcabo inte mïni wæquinque impa. Owæta tönö cængæ̈ yabætaque ñongate baï mïnitö wadäni ayönäni në waa cæmïni inte wæætë edæ cæncadenta ïnö wentaga engate baï cæmïnipa. Mïni wacä quï ö æ̈ïnënö ayæ̈ nämanque ante mïni towënö beyæ̈ owæta cæncadenta ïnö opogö tagate eyede baï impa diyæ̈. ");
INSERT INTO aucNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bitö Paditeobi babetamömi ëñëmi. Cæncadenta ïnö täno ñä mënongabi ïninque yabæta ïnö ñongate wainta baquïnö anguënë,” angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ayæ̈, “Në odömömïni tönö Paditeoidi incæ mïni wadö tedete wadö cædincabo inte mïni wæquinque impa. Mïnitö wao wodido baï yabæque waëmö paate baï ïñonte cæncadë ïnö wao bayetoca ñömænte öö wayömö baï entawëmïni ïmïnipæ̈æ̈. ");
INSERT INTO aucNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ïninque wadäni yabæque adinque, Mïnitö nö entawëmïni ïmïnipa, ante pönëñönäni mïnitö wïwa mïni pönënö beyæ̈ wadö tededinque wadö cædinque edæ mïmö wentamö entawëmïnipa,” ante Itota pïingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Tömënäni ïnänite ayæ̈ pïïninque, “Në odömömïni tönö Paditeoidi incæ mïni wadö tedete wadö cædincabo inte mïni wæquinque. Edæ Wængonguï beyæ̈ në apæ̈negaïnäni wodido, ante mïnitö do mæ̈nönomïnipa. Ayæ̈, Në nö cægaïnäni wodido, ante mæ̈nöninque mïnitö oncontai waëmö pönï paadomïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ayæ̈, ‘Mæ̈mæ̈idi näni quëwengaïñedë quëwëmöni baï mönitö tömënäni tönö, Wængonguï beyæ̈ në apæ̈nedönäni ïnänite mäo wæ̈nönämaï inte ee quëwencædömönimpa,’ ante ämïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mänömaïnö ante apæ̈nedinque mïnitö, Wængonguï beyæ̈ në apæ̈negaïnäni ïnänite në wæ̈nongaïnäni pæ̈ïmöni ïmönipa, ante nämä incæ edonque pönï apænte ämïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Edæ mïnitö wæ̈mæ̈idi në wæ̈nongaïnäni inte näni pe ñïñængaïmämo wïï eyepæ̈ inte baï cædinque mïnitö ñöwo godömenque eyede pe ñïñænte baï capo wæ̈nömäewedäni,” ante Itota badete baï angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ayæ̈ äninque, “Mïni tæntæcabo pæ̈ïmïni baï ïmïni ëñëedäni. Mïni obecabo pæ̈ïmïni baï ïmïni ëñëedäni. Mïnitö tadömengadænguipo mïni pante wæquënënö ante æbänö cæte aamö cæte edæ tabaïmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ïninque Wængonguï beyæ̈ në apæ̈nedäni tönö në nö ëñënäni tönö në odömönäni ïnänite botö ñöwo mïnitö weca da pönömo pönänipa. Adinque mïnitö ïñömö edæ pancadäniya ïnänite wæ̈nömïni wæncædänimpa. Pancadäniya ïnänite mïnitö awäa timpomïni wæncædänimpa. Ayæ̈ pancadäniya ïnänite mïnitö odömöincönë bæi ongöninque tæi tæi pämïni caate wædinque tömënäni wayömö quëwënäni weca wayömö quëwënäni weca wodii goyönäni mïnitö tee empo tee empo togænte goquïmïni, ante awædö. ");
INSERT INTO aucNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mänömaï wënæ wënæ cæyömïni edæ ñöwomïni beyænque tömää inguipoga wepæ̈ aa bedinque näate baquïmïnidö anguënë. Edæ Adäö wodi wengä Abedo në nö cægaingä wepæ̈ tönö ayæ̈ quëwente në ëñente cædäni ïnänite godö wæ̈nönäni wængaïnäni tönö tömënäni tömänäni wepæ̈ beyæ̈ mïnitö näate wæcæmïnimpa. Ayæ̈ mïnitö Wængonguï oncö ñæ̈næncö boyæ̈ iya täimpaa gäänë ongöninque Bedequiya wengä Tacadiya ingante godö wæ̈nömïni wængä ïninque tömengä wepæ̈ näate wæmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ñöwomïni mïni wepæ̈ näate wæquinque tömanguipo aa betïnö anguënë, ante ämo ëñëedäni,” ante Itota tömënäni ïnänite idæwaa pïinte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ayæ̈ Eedotadëë ïñömö quëwënäni beyæ̈ ante pönëninque Itota, “Eedotadëë quëwëmïni ëñëedäni, angantapa. Wængonguï beyæ̈ në apæ̈nedäni ïnänite mïni wæ̈nongaincabo inte ayæ̈ Wængonguï nänö da pönönäni ïnänite dicaca tacamïni ïñömïnite botö ïñömö mïnitö ïmïnite waadete pönö cæïnente nanguï wæbopa. Tawadiya wæ̈mönä ïñömö, Botö wënäni, ante gompodinque tæcæënëmæ̈ wëä pönö ö æ̈nä baï botö adobaï, Botö wënäni pöedäni, ante æpogadö äñömote mïnitö, Wïï pöïnente awædö, ante Baa ämïni wætabopa. ");
INSERT INTO aucNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ñöwo ïñömö edæ mïni quëwëñömö önonconcooque baconcoo tamëñedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ñöwo ïñömö edæ botö dæ äñömo mïnitö, ‘Awënë Wængonguï ëmöwo beyænque pöninque bitö toquinque edæ waa cæcæbiimpa,’ ante mïni anguinganca mïnitö edæ botö ïmote adämaï incæmïnimpa ante ämo ëñëedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Itota Wængonguï oncö ñæ̈næncö oncodo tao gocantapa. Wadæ gocæ cæyongä tömengä mïñæ̈ në godäni ïñömö, Wængonguï oncö ñæ̈næncö æbänö waa pönï mæ̈nonte ïï, ante odömoncæte ante tömengä weca pönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ate wædinque Itota wæætë, —Mïnitö guiquënë mänincoo tömancoo edæ waa amïnitawo. Näwangä ante mïnitö ïmïnite apæ̈nebopa. Mänincoo mïni acoo incæ tömanca bæ tadäni wæænca adinque panguïmæ̈ panguïmæ̈ godinque dica adocaque pönï incæ wæ̈nömënæca ongönämaï ingæ̈impa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mänïï taodinque Odibowænquidi pö æite tæ̈ contate ongöñongä tömengä mïñæ̈ në godäni adodänique tömengä weca ponte apæ̈nedänitapa. —Bitö änö ante æyedënö ïinque baquïï, ante ëñencæte ante wæmönipa. Edæ bitö ponque æyedënö ponguïmii, ante ayæ̈ mönö inguipoga quëwënö æyedënö æ̈mæ̈wo ïinque baquïï, ante ëñencæte ante wæmönipa. Ïninque, Æbänö mä odömonte baï ba adinque edæ, Oo pönï impa, ante wædinque ëñenguïmönii, ante ëñencæte ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Äñönäni Itota, —Wapiticæ̈ odömöñönäni mïnitö wæætë, Mönö oda cædämaï ingæ̈impa, ante nämä wææ aquënë quëwëmïnii. Edæ ïïmaï baquï ï ataqueedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Edæ wadäni nanguï ïnäni botö ëmöwo ante babæ tedete pöninque, “Botö Codito ïnömo ïmopa,” ante apæ̈nedinque wapiticæ̈ mäodäni godinque edæ nanguï ïnäni tömënäni mïñæ̈ oda cæte wapiticæ̈ gocædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Edæ, Wabæca awënë tönö pö bee tëninque wæætedö wæætë cædapa, ante tededäni ëñencæmïnimpa. Ayæ̈ wayömö näni guëadö guëa cæte wæ̈nönö ante tededäni incæte edæ guïñente wædämaï ïedäni. Edæ mänïnö botö änïnö baï cöwë bacæ̈impa. Ba incæte mönö inguipoga quëwënö ïñömö mänïñedë wïï æ̈mæ̈wo ïinque bacæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Adobæca quëwënäni ïñönänite wabæca quëwënäni ponte bee tëninque guëadö guëa cæquïnäni ïnänipa. Adobæca awënë odeye nempo quëwëñönänite wabæca awënë odeye tömengä nänö ënempodäni mämö bee tëninque guëadö guëa cæte wæ̈nonte wænguïnäni ïnänipa. Ayæ̈ waodäni näni cæ̈ïnente wænguinque cænguï incæ tömää capo wængæ̈impa. Ayæ̈ wayömö wayömö goinque pö wæcædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Incæte mänïï näni wæwënö ba ïninque edæ önonque mä pönï näni wæwenguï inguïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mänömaïnö ante Itota godömenque apæ̈negacäimpa. “Mänïñedë edæ mïnitö ïmïnite mïni wæquinque ö ænte mäo godönäni wæyömïni godömenque wæ̈nönäni wæncæmïnimpa. Ayæ̈ mänïñedë botö ëmöwo apæ̈nemïni beyæ̈ tömämæ quëwënäni mïnitö ïmïnite pïincædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ayæ̈ adoyedë mïni pönencabo incæ pancadäniya guingo imonte baï badinque edæ pönënämaï inte Baa anguïnäni. Ayæ̈ mïni cabo incæ näëmæ̈ pïïninque pancadäniya, Nänö wænguinque, ante wacä ingante näëmæ̈ godoncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ayæ̈ në babæ ante apæ̈nedäni ponte, Wængonguï beyæ̈ në apæ̈nemöni ïmönipa, ante odömönäni adinque pancadäniya edæ oda cæte wadö pönente baquïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ayæ̈ ëñënämaï inte näni cæpämo godömenque yebænte baï nanguï ba ate wædinque në pönënïnäni inte wodo tömänäni edæ Baa äninque waadedämaï bacædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Edæ æcänö ïïmæca ïinque baganca wæntædämaï inte botö ëmöwo beyæ̈ pïinte badämaï ïnaa tömengä edæ botö æ̈mo beyænque cöwë wæ̈nämaï quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ayæ̈ edæ, Awënë Odeye nempo watapæ̈ quëwengæ̈impa, ante mïni pönencabo tömämæ quëwënäni ïnänite mäo apæ̈nemïni ëñencædänimpa. Mänömaï apæ̈nedinque ïinque cæmïni ate mänïñedë ate edæ ïinque baquïnö anguënë,” ante Itota tömengä mïñæ̈ në godäni ïnänite apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ayæ̈ apæ̈nedinque Itota, “Ïninque, Wængonguï beyæ̈ në apæ̈negaingä Daäniedo wodi, Ñömæ̈ï baï öö wadö näni wo ëwenguïmämo incæ Wængonguï oncö tæiyæ̈ waëmoncönë ænte mämö cö cæquïnänidö anguënë, angacäimpa. Daäniedo nänö yewæ̈mongainta adinque në adingä ïñömö tömengä do ëñëmaingampa. Ïincayæ̈ ate mänömaï cö cædäni ongö adinque, ");
INSERT INTO aucNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","mänïñedë Oodeabæ quëwëmïni ïñömö edæ änanquidi do wodii wïnonte æibäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ayæ̈ oncömanca ongömïni ïninque mäincoo æncæte ante oncönë wæi guiidämaï inte oncömancaque oncömancaque wodii wïnömäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ayæ̈ tömëmoncodë cæmïni ïninque yacoo æncæte ante oncönë ocæ̈ ëmæ̈nämaï inte godömenque wodii wïnömäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mänïönæ ïinque bayedë në yædëmadä ïnäni tönö goömæ̈ në gänönäni tönö tömënäni näni wæquïmämo baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ayæ̈ mïnitö mïni wodii wïnonguïönæ ante pönëninque edæ Wængonguï ingante, Wïï edæ cöönædepo bacæ̈impa, ante ayæ̈, Guëmanguïönæ ïñonte badämaï ingæ̈impa, ante äedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Edæ mänïñedë waodäni nanguï näni wæwëmämo näni angä baquïnö anguënë. Edæ Wængonguï nänö badongaïñedë mänömaï näni wæwëmämo baï dæ äñonte ayæ̈ godömenque ñöwo ganca dæ änompa. Ayæ̈ godömenque ïinque baganca mänömaï näni wæwenguïmämo baï dæ anguïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Edæ wantæpiyæ̈ näni wæwenguï impa, ante adinque Wængonguï, Mänimpoönæque edæ wæwencædänimpa, ante pönömenque ante änämaï ingä baï quingänö quëwenguënë dæ ancædönänimpa. Incæte, Në quëwenguïnäni botö angaïnäni wïï wantæpiyæ̈ wæwencædänimpa, ante cædinque Wængonguï dobæ pönömenque äninque, Idæwaa impa, ancæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ayæ̈, Ïinque bayonte æbänö inguïï, ante apæ̈nedinque Itota godömenque ïïmaï ante apæ̈necantapa. “Mänïñedë wadäni mïnitö ïmïnite, ‘Ïñömö mönö Codito ponte ongongä tamëñedäni,’ ante ayæ̈, ‘Wayömö ponte a ongongä atamönipa,’ ante tededäni ëñëninque mïnitö ïñömö edæ ëñënämaï ïmäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wadäni mänïñedë ponte a ongöninque nämä incæ ante, Tömëmo Codito ïnömo ïmopa, ante babæ ante tedequïnäni. Ayæ̈, Wængonguï beyæ̈ në apæ̈nebo ïnömo ïmopa, ante babæ ante tedequïnäni. Tömënäni, Wængonguï nänö apænte ængaïnäni incæ æ̈mæ̈wo oda cædinque wapiticæ̈ gocædänimpa, ante cædinque bamönengæ̈ baï cædinque öönædë cæï baï cædinque nö odömonte baï cæquïnäni ïnänipa. Incæte Wængonguï në apænte ængaingä inte edæ ee aquingä diyæ̈ æ̈mæ̈wo oda cædinque wapiticæ̈ goquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Edæ ïinque badämaï ïñonte botö ñöwo do apæ̈nebo ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ïninque, pönente quëwëñömïni wadäni, ‘Cöwä aedäni, önömæca mæ̈ ongongampa,’ ante änäni ëñëninque mïnitö acæ taodämaï ïedäni. Ayæ̈, ‘Oncö guimongacönë a ongongä apa quëwëedäni,’ ante änäni incæte pönënämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Edæ nænque tamönö gämæ̈nö näïninque guiidö gämæ̈nö quingæ̈ gote baï edæ tömänäni edonque ayönäni botö Waobo ëñagaïmo inte botö ponque poncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Edæ abadæidi ñömæ̈ingäa weëö pönäni baï mïnitö tömämïni adoyedë ïñontobæ̈ botö weca ponguïmïni ïmïnipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ayæ̈ godömenque apæ̈nedinque Itota, “Mänïï näni wæwëmämo näni angä ïinque go ate nænque ïñontobæ̈ wëmö badinque apäicä apäidämaï ingæ̈impa. Nëmoncoo öönædë ïnö wææ̈ tæ̈ wææ̈ninque waa tæ̈ waa tæ̈ wæængæ̈impa. Öönædë tæ̈ï ongongaincoo incæ wancæ wancæ cæte baï wapiticæ̈ goquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mänïñedë ate botö Waobo në ëñagaïmo inte oo pöñömo öönædë ate baï ba adinque wabæca näni cabo wabæca näni cabo tömämæ quëwënäni Ca ca wæcædänimpa. Wæyönäni botö Waobo në ëñagaïmo inte boguïmancodë mämö pöninque botö tæ̈ï pönï pïñæ̈mo inte ñäö apäite baï waëmö ëmonte wææ̈mo acædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mänïñedë todompeta mönö ancadeca yedæ æ̈nete baï we ööñonte botö anquedoidi ïnänite da godömo godinque tömënäni boguïmä æ̈mæ̈nö betamonca æ̈mæ̈nö betamonca nänö pö goïnö godinque öönædë tömäne godinque edæ Wængonguï nänö apænte ængaïnäni ïnänite äñete poncædänimpa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ayæ̈, “Wængonguï Awënë æyedënö ponguingää, ante botö iigowæ̈ æbänö ïwæ̈ ante odömonte apæ̈nebo ëñëedäni. Tömëwæ̈ mïïwæ̈ badinque iigowæ̈ wayabo tänä nä boca adinque mïnitö, Öñabo nänö bocaïnepo inte nænque näwantedæ̈ baquinque bocapa, ante pönëninque edæ do ëñëmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ayæ̈ adobaï mänïnö botö apæ̈nedïnö baï edæ do ba adinque mïnitö, Waocä në ëñagaingä ïñömö edæ do odemö pönï ongöninque edæ oo poncæcäimpa, ante ëñencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Näwangä ämopa. Ñöwomïni ayæ̈ mïïmïni quëwëninque wænte godämaï ïñömïni mänïnö botö apæ̈nedïnö baï tömänö edæ do ïinque baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Öönædë ongöñömö inguipoga tönö wo ëwente baï dæ ba incæte botö angaïnonque guiquënë edæ dæ badämaï inte edæ cöwë tæ̈ï ongongæ̈impa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ayæ̈, “Mänïönæ æyedënö ï, ante, Mänïnepo ædepodö ï, ante ëñencæte ante mïni wædïnö ante æcämenque incæ ëñënämaï ingampa. Tömänäni ëñënämaï ïñönäni edæ Wængonguï anquedoidi incæ ëñënämaï ïnänipa. Wæmpocä Wëmo incæ ëñënämaï ïñömote Wæmpocä ïñömö tömengä adocanque incæ edæ në ëñengä ingampa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ayæ̈ godömenque ïïmaï ante apæ̈necantapa. “Waobo në ëñagaïmo inte botö ponguïönæ ïinque bayedë guiquënë Nöwee wodi Docä näni angaingä nänö quëwëñedë dodäni näni quëwengaï baï adobaï edæ quëwenguïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mänïñedë æpæ̈ ayæ̈ änämaï ïñedë në quëwengaïnäni ïñömö önonque cænte bete, Monguingä, ante godonte ate möninque tömënäni Docä Nöwee oncö baï wipo mæ̈nonte nänö guiiquïönæ ïinque baganca quëwencægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tömënäni ïnänite æpæ̈ ænte gocæ cæganca tömënäni, Æpæ̈ anguimpa, ante ëñënämaï näni quëwengaï baï adobaï ëñënämaï cæyönäni botö Waobo ëñagaïmö inte adobaï edæ ïñontobæ̈ poncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mänïñedë waoda tömëmoncodë guëa cæyöna adocanque ingante ö æ̈näni goyongä adocanque wæætë a ongoncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ayæ̈ onquiyæ̈na guëa apo cæyöna adocanque ingante ö æ̈näni goyongä adocanque wæætë a ongoncæcäimpa,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ayæ̈, “Awënë æyedënö ponguingää, ante ëñënämaï ïmïni inte mïnitö mïïmïni inte edæ cöwä aquënë quëwënänii. ");
INSERT INTO aucNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Në awëmö ængä æyedënö ponguingää, ante ëñente baï në ëacä ïñömö, Bæ tate guiidämaï incæcäimpa, ante wææ wänoncædongäimpa, ante ëñente quëwëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wao Wëmo ëñagaïmo inte botö adobaï mïnitö ëñënämaï ïñömïni do ïñontobæ̈ ponguïmo ïmo ante mïnitö botö ponguïnö ante wänö cöedäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ayæ̈ Itota ïïmaï apæ̈necantapa. “Inguipoga awënë ïñömö, Æcänö në ëñengä ïnongä inte botö quincoo ante ædæmö aacä inguingää, äninque, Mänömaï inte cæcä ingante adinque botö ämo ate tömengä në angä badinque botö oncönë quëwënäni ïnänite ædæmö aadinque cænguï eyepæ̈ ïñonte godongä cæncædänimpa, angampa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ante awënë wayömö gote ponte ayongä, Në cæcä botö änö ante ëñente cæcampa, ante adinque awënë wæætë tömengä ingante godö waa cæcä tömengä ingante godö waa cæcä ate në waa cæcä ïñömö edæ waa tocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mïnitö ïmïnite näwangä ante apæ̈nebopa. Në ëñente cædingä ingante awënë, Bitö botö mäincoo tömancoo edæ në aabi bacæbiimpa, ancæcäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Wæætë edæ tömengä ingante në cæcä incæ wënæ wënæ cæcä ïnongä inte mïmöno pönëwëninque, Botö awënë wabänö wantæpiyæ̈ pönämaï ïmaingampa, ante pönengä ïninque æbänö babaï. ");
INSERT INTO aucNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tömengä edæ wadäni näni cæcabo ïñönänite näëmæ̈ pïïninque tæi tæi pangä ïninque ayæ̈ në tï nämæ̈ bete quidi quidi dowænte badäni tönö godongämæ̈ cænte becä. ");
INSERT INTO aucNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ïninque tömengä, Æönædö ponguingää, ante wædämaï ïñongante, Æyedënö ponguingää, ante ëñënämaï ïñongante edæ awënë ïñontobæ̈ pongä wæbaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pöninque awënë ïñömö ëñënämaï cædingä ingante baö wido wido todinque tömengä ingantedö äninque, Në wadö tedete wadö cædïnäni näni panguïnö gote tömënäni tönö godongämæ̈ ongonte wæcæcäimpa. Ante cædinque awënë tömënäni näni guingo imonte Ca ca wæyömö wido cæcä wæcæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mäninganca apæ̈nedinque Itota ayæ̈ godömenque odömonte apæ̈negacäimpa. “Mänïñedë öönædë Awënë Odeye nempo quëwënäni ïñömö baquedäni diete ganca näni cæï baï adobaï cæcædänimpa. Baquedäni ïñömö, Edëningä ñöwoönæ monguingä, ante tica ënëincade æ̈ninque tömengä ingante bee tencæte ante tao godänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Baquedäni incæ tömënäni tinco ganca ïnäni në ëñënäni ïñönäni edæ adoganca tinco ganca ïnäni në ëñënämaï ïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Në ëñënämaï ïnäni guiquënë tömënäni tica ënëincade æ̈ninque gongapæncade æ̈nämaï goyönäni, ");
INSERT INTO aucNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","në ëñënäni guiquënë gongapæncadedë godö pe ñïñænte gongapæ̈ eyepæ̈ ænte godänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mänömaï ænte gote ayönäni në monguingä wantæpiyæ̈ pönämaï dæ angä adinque tömënäni tömänäni edæ möïnente ædo ædo cædinque mö ñönänipa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mö ñöñönäni ayaönæ̈nëña pönï bayonte edæ, ‘Në monguingä pongä ataqueedäni. Tao bee tenguënë quëwëmïnii.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ante aa pedäni ëñëninque edæ baquedäni tömänäni ængæ̈ gantidinque, Tica ënëincade waëmö tï wodönote bacæ̈impa, ante wadæ wadæ cædänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Cæyönäni në ëñënämaï ïnäni guiquënë në ëñënäni ïnänite, ‘Mönitö tica ënëincade edæ wodo mönæ ëmompa cæmïnii. Mïnitö næ̈æ̈nïmæ̈ incæ pancapäa pönömïni æncæmönimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Äñönäni, ‘Ïñæmpa, mönitö beyæ̈ mïnitö beyæ̈ adobaï wïï eyepæ̈ ïmaimpa, ante awædö. Edæ godoncæte ante në mänäni weca gote godonte æ̈edäni.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Änäni ëñente godonte æncæ goyönäni edæ në monguingä do pongä adinque në ëñente eyepæ̈ næ̈æ̈nïnäni ïñömö monguingä tönö godongämæ̈ monguïmæ̈no oncönë becæ guiidäni ïninque edæ odemö tee mönete intapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ayæ̈ ate edæ wadäni gongapæ̈ eyepæ̈ ænte pöñönäni do tee mönete ï adinque tömënäni, ‘Awënë, awënë ëñëmi. Odemö wi æ̈nebi guiimönie.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ante wæyönäni awënë wæætë, ‘Mïnitö ïmïnite näwangä ämopa. Mïnitö æmïnidö ïmïnii, ante botö cöwë adämaï ïmopa,’ angampa.” Mäninque ante odömoncæte ante Itota ïïmaï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Mïnitö guiquënë, Æönædö ï, æyedënö ï, ante ëñënämaï ïmïni inte edæ wänö conte quëwëedäni,” angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ayæ̈ æbänö baquïï, ante odömoncæte ante Itota, Waocä në ëacä nänö cæï baï bacæ̈impa, ante apæ̈negacäimpa. “Në ëacä wayömö gocæte ante cædinque tömengä ingante në cædäni ïnänite äñete mämongä pöñönänite, Botö ëadinta incæ pönömo æ̈ninque mïnitö në aamïni badinque botö beyæ̈ godonte æncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Äninque në ëacä ïñömö, Në cædäni æbänö nanguï cædinque aaquïnänii, ante adinque tadento ñæ̈nængade näni godonte æ̈inta incæ adocanque ingante önompo æ̈mæmpoque mänimpota pædæ pönöninque wacä ingante tadento mentaa mänimpota pædæ pönöninque wacä ingante tadento adotaque pædæ pönongampa. Ayæ̈ wadæ gocä. ");
INSERT INTO aucNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ïninque tadento önompo æ̈mæmpoque mänimpota në æ̈ningä ïñömö do godinque godonte æ̈ godonte æ̈ cædinque önompo æ̈mæmpota tömengä nänö æ̈nimpota adopota æ̈ñongä edæ tadento önompo tipæmpoga bapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ayæ̈ tadento mentaa në æ̈ningä adobaï godonte æ̈ godonte æ̈ cædinque mentaa nänö æ̈ninta adopota wæætë æ̈ñongä edæ tadento mëa go mëa bapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wæætë adotaque në æ̈ningä guiquënë tömengä wadæ godinque onguipodë æ̈æ̈ wodinque awënë godonte æ̈inta æ̈ninque tee moncate wë wodongampa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ayæ̈, “Wantæpiyæ̈ ate tömënäni awënë adodö pöninque, Botö quï eyepæ̈ æncæboimpa, ante cædinque tömënäni näni ænte aadinta ante cöwä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Önompo æ̈mæmpoque tadento në æ̈ningä ïñömö edæ æ̈mæmpota adopota nänö godonte æ̈ninta ænte pöninque awënë ingante, ‘Awënë, bitö botö ïmote, Aacæbiimpa, ante tadento önompo æ̈mæmpoque mänimpota pædæ pönömi æntabopa. Æ̈ninque botö godonte ænte godonte ænte edæ nanguï cædinque edæ mänimpota adopota æ̈mæmpota dobæ æ̈moï ae.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Angä wædinque tömengä awënë ïñömö, ‘Badogaa. Botö ïmote në cæbi ïnömi inte bitö ædæmö aabi inte ñöwo waa cæbi æ̈mopa. Bitö wædænque æ̈ninque cöwë ædæmö aabi adinque botö ñöwo nanguï pönï botö ëadincoo pönömo æ̈ninque bitö wæætë edæ në aabi bacæbiimpa. Botö bitö awënë ïnömo inte watapæ̈ tote quëwëmo ïñömote bitö edæ ääñömonque baï bitö watapæ̈ tote quëwenguinque pöe,’ angantapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ayæ̈ mëa tadento në æ̈ningä adobaï pöninque, ‘Awënë, bitö botö ïmote, Aacæbiimpa, ante tadento mentaa mänimpota pædæ pönömi æ̈ninque botö godonte ænte godonte ænte edæ nanguï cædinque edæ mentaa mänimpota adopota dobæ æ̈moï ae.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Angä wædinque tömengä awënë ïñömö, ‘Badogaa. Botö ïmote në cæbi ïnömi inte bitö ædæmö aabi inte ñöwo waa cæbi æ̈mopa. Bitö wædænque æ̈ninque cöwë ædæmö aabi adinque botö ñöwo nanguï pönï botö ëadincoo pönömo æ̈ninque bitö wæætë edæ në aabi bacæbiimpa. Botö bitö awënë ïnömo inte watapæ̈ tote quëwëmo ïñömote bitö edæ ääñömonque baï bitö watapæ̈ tote quëwenguinque pöe,’ angantapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ayæ̈ ate edæ adotaque në æ̈ningä wæætë pöninque, ‘Awënë, bitö në waadedämaï cædömi inte bitö wïï gadïñömö wayömö incæ edæ do wogaabipa. Ayæ̈ bitö wïï mïñömö wayömö incæ edæ do tä pete gæte baï æ̈mipa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ïninque botö edæ ancai guïñente wædinque edæ tao godinque onguipodë æ̈æ̈ wote bitö tadento daga wëninque edæ wë wodontabopa. Bado, bitö quï incæ edæ do æ̈mipa,’ angantapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Angä ëñente wædinque tömengä awënë wæætë, ‘Botö ïmote në cæbi ïnömi inte bitö wïwa pönëmi inte wæntæye cæbi abopa. Botö æbänö gadämaï ïñömö do wogaabopa, ante bitö edæ do ëñëmitapa. Botö mïnämaï ïñömö do tä pete gæbopa, ante bitö änïnö edæ do ëñënïmi inte cæbitapa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ïninque mänïnö ante do ëñënïmi inte bitö edæ padata botö godonte æ̈inta æ̈ninque edæ në godonte æ̈näni weca godonte ænguënëmi ïmitapa töö. Mänömaï cæbi baï botö ocæ̈ ëmænte pöninque edæ botö quï do æ̈ninque wadäni näni guidöninta tönö edæ do æncædömoimpa töö.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Äninque tömengä ingante në cædäni ïnänite awënë angantapa. ‘Mïnitö ñöwo ïingä tadento adotaque tömengä nänö næ̈æ̈ninta ö æ̈ninque edæ tadento önompo tipæmpoga në næ̈ængä ingante pædæ godömïni æncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Edæ në ëadäni ïnänite tömänäni ïnänite godömenque godonte ingæ̈impa. Ïninque tömënäni quï nanguï ëacædänimpa. Wæætë edæ ëadämaï inte ömæpocä ingä guiquënë tömengä nänö ëadincoo wædænque pönï ï incæte edæ ö ænte dæ ba wæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ayæ̈ edæ mäningä botö ïmote në cædingä incæ wæntæye ïnongä inte cædämaï ïñongante mïnitö wëmö ïñömö näni guingo imonte Ca ca wæwëñömö tömengä ingante edæ guitodonte wido cæmïni wæcæcäimpa,’ ante tömengä awënë angampa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Itota mänömaïnö ante odömonte apæ̈nedinque godömenque apæ̈negacäimpa. “Botö anquedoidi tönö godongämæ̈ pöninque botö Waobo në ëñagaïmo inte ñäö apäite baï në ëmömo inte poncæboimpa. Mänïñedë botö pöñedë botö Awënë tæ̈ contaimpaa tæ̈ contadinque edæ öönædë waa pönï ongönäni baï waa pönï ongoncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mänïñedë tömämæ quëwënäni botö weca godongämæ̈ ponte a ongoncædänimpa. Ayæ̈ në aacä tömengä cæ̈nïnäni ïnänite apænte adinque bodegoidi æ̈mæ̈nö cönöninque cabodaidi æ̈mæ̈nö nänö cönönö baï cædinque botö ïñömö edæ ïmæca quëwënäni tömänäni ïnänite apænte adinque pancadäniya ïnänite æ̈mæ̈nö gönöninque wadäni ïnänite æ̈mæ̈nö gönömo ongoncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Obegaidi baï në ëñente cædäni ïnänite botö tömëmæ̈ ïnö gönöninque wæætë cabodaidi baï në ëñënämaï cædäni ïnänite botö dipæ̈mæ̈ ïnö gönoncæboimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Gönöninque botö Awënë Odeyebo ïnömo inte botö tömëmæ̈ ïnö në ongönäni ïnänite ancæboimpa. ‘Botö Mæmpo nänö në waademïni inte pöedäni. Tömengä inguipoga nänö badongaïñedë äninque, Awënë Odeye nempo mïni quëwenguïnö impa, ante do badongacäimpa. Ïninque Awënë Odeye nempo mïni quëwenguënënö ñöwo ænte quëwëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Edæ botö gue æ̈nente wæyömo mïnitö cænguï në pönömïni cængaboimpa. Tepæ̈ gæ̈wænte wæbo adinque mïnitö në pönömïni begaboimpa. Botö Wabo ïmo inte cowodë baï pömo adinque mïnitö, Pö guii, ämïni ëñëninque mïnitö weca guiite ëñagaboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ayæ̈ ömaabo inte wæyömo mïnitö pönömïni wëñagaboimpa. Wënæ wënæ inte wæyömo mïnitö ponte në waadete cægaïmïni ïmïnipa. Tee mönete oncönë ongonte wæwëñömote botö weca ëñacæ në pongaïmïni ïnömïni inte mïnitö ñöwo wæætë edæ botö nempo guiite quëwencæmïnimpa,’ ancæboimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ämo ëñëninque edæ në nö cædäni guiquënë, ‘Awënë ïñæmpa æyedënö bitö gue æ̈nente wæyömi dicæ pönömöni cæ̈mitawogaa, ancædänimpa. Ayæ̈ tepæ̈ gæ̈wæ̈ñömi dicæ pönömöni bebitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Æyedënö wacä incæ pömi adinque mönitö dicæ, Pö guii, antamöniyaa. Ayæ̈ ömaabi adinque dicæ pönömöni wëñabitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ayæ̈ wënæ wënæ inte wæyömi incæ tee mönete wæyömi incæ mönitö dicæ acæ pontamöniyaa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ante wæyönäni botö Awënë Odeyebo ïnömo inte edæ tömënäni ïnänite, ‘Ïñæmpa botö tönïñadäni ïñönänite adocanque önonganque ïñongante mïnitö waa cægaïmïni inte edæ botö ïmote do waa cæte ïmïnipa ämo ëñëedäni,’ ante tömënäni ïnänite ancæboimpa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ayæ̈ botö dipæ̈mæ̈ ïnö në ongönäni ïnänite botö në Awënë ïnömo inte ancæboimpa. ‘Mïnitö në tente wæquënëmïni guiquënë ñöwo edæ gä gobäewedäni. Edæ Wængonguï do badöninque, Wënæ tönö tömengä anquedoidi nänö në ëmïñæ̈näni tönö wantæpiyæ̈ cöwë wæ̈nämaï näni bæcote wæquïñömö, ante nänö badongaïñömö mïnitö mänïñömö edæ gote guiibäewedäni,’ ante edæ ancæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‘Edæ botö gue æ̈nente wæbo adinque mïnitö edæ dicæ pönömïni cæntabogaa. Gæ̈wænte wæyömo mïnitö dicæ pönömïni betabogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ayæ̈ Wabo ïmo inte cowodë baï pömo adinque mïnitö dicæ, Pö guiie, ämïnitawogaa. Ömaabo inte wæyömo weocoo dicæ pönömïni wëñatabogaa. Wënæ wënæ inte wæbo incæ tee mönete wæbo incæ mïnitö ïñömö edæ dicæ ëñacæ pömïnitawogaa,’ ancæboimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ämo ëñente wædinque në ëñënämaï ïnäni ïñömö, ‘Awënë ëñëmi. Bitö æyedënö gue æ̈nente tepæ̈ gæ̈wænte wæbitawo. Ayæ̈ wabi baï inte æyedënö pömi atamöniyaa. Weocoo ömaabi inte wæbi adinque, daicawo gawæ̈mi adinque, tee mönete wæbi adinque mönitö bitö beyæ̈ dicæ cædämaï intamöniyaa.’ ");
INSERT INTO aucNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Äñönäni botö ïñömö edæ tömënäni ïnänite, ‘Ïñæmpa wacä ingante önonganque ïñongante mïnitö cædämaï ingaïmïni inte botö ïmote edæ mänïnö do cædämaï ingamïnimpa. Ämo ëñëmaïmïnipa,’ ante pïincæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ïninque tömënäni näni tente wæwenguïnö incæ æ̈mæ̈wo wadæ gocædänimpa. Wæætë në nö cædäni guiquënë cöwë wæ̈nämaï näni quëwenguïnö æ̈mæ̈wo gocædänimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ayæ̈ mänïnö tömänö ïinque apæ̈nete ate Itota tömengä mïñæ̈ në godäni ïnänite apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mëönaa go ate wodo pænta gogaïönæ baï Patowa mönö æ̈æ̈mæ̈ cænguïönæ impa, ante do ëñëmïnipa. Mänïönæ ïñonte botö Waobo ëñagaïmo ïñömote botö ïmote bæi ongöninque edæ, Awæ̈ ñænquedïmæ̈ cæte ïingä ingante töö godöninque daagö timpote wææ̈ tïwadinque edæ æ̈æ̈nö gö cæte wæ̈nöedäni, ante botö ïmote pædæ godönäni æncædänimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mänïñedë, Wængonguï quï, ante në godongä ñæ̈nængä pönï Caiapato oncönë godongämæ̈ pöninque wadäni në godönäni ñæ̈næ̈näni tönö oodeoidi ïnänite në aadäni näni Picæncabo ïñömö, ");
INSERT INTO aucNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","adoyömö pönëninque, Mönö æbänö babæ cæte Itota ingante awëmö bæi ongonte ænte wæ̈nonguïï, ");
INSERT INTO aucNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ante pönënäni incæte, —Ïñæmpa æ̈æ̈mæntedæ̈ ïñonte wæ̈nömö baï tömänäni ænguï bate Yæ yæ ante pïinte cæcædönänimpa, ante pönente wædinque mönö ædö cæte mänïñedë cæquïï, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Itota mänïñedë Betänia godinque në baadingä Timönö oncönë guii ëñadinque cæncongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Cæncöñongä wacä onquiyængä ïñömö tömengä weca pö guiidinque oguï wapæ̈ näni nanguï godonte æ̈nïmæ̈ dica adabatodo waincadedë pe ñïñænte nänö mänïmæ̈ incæ ñöwo ænte mämö Itota ocaboga edæ gao cæcacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mänömaï cæcä adinque Itota mïñæ̈ näni gocabo ïñömö pïïninque, —Ïñæmpa önonque gao guënente baï cæcampa töö, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Edæ ïïmæ̈ ïñömö nanguï pönï æ̈ninta beyæ̈ godonte ænguënëmæ̈ ïmæmpa. Godonte ænte baï ömæpodäni ïnänite wæætë godonguënë apa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ante pïïnäni wædinque Itota ïñömö, —Quïmæ̈ pïïwëmïnii. Ïingä onquiyængä ïñömö botö ïmote waa pönï cæcä apa quëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ïñæmpa ömæpodäni ante mïni änïnäni mïnitö weca cöwë quëwëñönäni botö wæætë mïnitö weca wïï wantæpiyæ̈ quëwencæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mänïmæ̈ oguï wapæ̈ botonga gadongadinque tömengä botö baö daga wenguinque eyepæ̈ ïñonte edæ öni paacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mïnitö ïmïnite näwangä ante apæ̈nebopa. Waa pönï botö apæ̈nedö apæ̈nedinque tömämæ æyömömë apæ̈nedäni ëñënäni mäningä onquiyængä nänö cædïnö ante adobaï tededäni ëñente pönencædänimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ayæ̈ mänïñedë näni, Dote, äincabo ïñönäni adocanque Codaa Icadiote näni änongä ïñömö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni weca gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Godinque apæ̈necantapa. —Botö, Itota æyömönö ongongää, ante pönö odömömo ate mïnitö bæi ongonte æ̈mïni ïninque æpotadö, Eyepæ̈ ï, ante pönömïni æ̈maïmoo. Angä ëñëninque tömënäni padata tiguitamö incæ todëinta ganca tee mampote tömengä ingante pædæ godönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Æ̈ningä inte tömengä cöwë cöwä adinque, Æbänö cæte Itota ingante odömonte pædæ godömo ate ænguïnänii, ante pönente cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mänïñedë oodeoidi päö yedæ æmpoquï ömæmö ï näni æ̈æ̈mæ̈ cæte cænguïönæ tæcæ ba adinque Itota mïñæ̈ në godäni ïñömö, Wodo pænta gogaïönæ baï Patowa mönö æ̈æ̈mæ̈ cænguïönæ impa, ante pönente wædinque tömengä weca ponte änänitapa. —Æyömönö bitö beyæ̈ Patowa æ̈æ̈mæ̈ ante cæmöni ate cænguïmii. ");
INSERT INTO aucNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Äñönäni tömengä nänö ëmïñæ̈na mënaa ïnate äninque, —Mïnatö waodäni näni quëwëñömö godinque onguïñængä botö në äningä ingante bee tëninque mïnatö ïïmaïnö ante apæ̈nemïna ëñengäeda. “Mönö Awënë ïïmaï angampa. Botö wænguïönæ oo pönï bapa cæbii. Botö në ëmïñæ̈näni tönö botö bitö oncönë Patowa æ̈æ̈mæ̈ ponte cæncæmönimpa, angampa,” ante ämïna ëñengäeda, angä. ");
INSERT INTO aucNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ëñente wædinque tömëna Itota nänö änö baï cædinque, Patowa æ̈æ̈mæ̈ cænguï impa, ante cædatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gäwadecæ̈ bayö Itota tönö, Dote, näni äincabo ponte godongämæ̈ cæncæte ante ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Cæncöñönäni Itota, —Näwangä ante apæ̈nebo ëñëedäni. Mïni cabo incæ adocanque, Æncædänimpa, ante botö ïmote odömonte pædæ godonguingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ante apæ̈necä ëñëninque tömënäni wæwente bayönäni adocanque adocanque, —Awënë, botö ïmotedö ante dicæ apæ̈nebitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ante tedeyönäni Itota wæætë, —Botö tönö guëa adotaca në mïï cædingä ïñömö tömengä botö ïmote në odömonte pædæ godonguingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Edæ dodäni Wængonguï beyæ̈ näni yewæ̈mongaïnö baï cædinque botö Waobo ëñagaïmo inte cöwë wænte goquënëmo ïmodö anguënë. Ïninque edæ botö ïmo në odömonte godonguingä ïñömö tömengä nänö wæquinque ingæ̈impa. Mäningä wïï ëñate baï waa toquënengä incædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ante apæ̈necä wædinque Codaa ïñömö Itota ingante në odömonte godonguingä ïñömö edæ, —Awënë në Odömömi ëñëmi, botö ïmotedö ante ämitawogaa. Ante äñongante edæ Itota, —Tömëmi nämä incæ, Botö ïmotedö, ante do tedebi ïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ante apæ̈necantapa. Ayæ̈ cæncöñönäni Itota päö bæi ongonte æ̈ninque Wængonguï ingante waa ate apæ̈nedinque päö pä æ̈ninque tömengä mïñæ̈ në godäni ïnänite pædæ godö pædæ godö cæcantapa. —Botö baö baï impa, ante pædæ pönömo æ̈ninque mïnitö Ao ante cæ̈edäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Äninque ayæ̈ bequïmæ̈ owætaca bæi ongonte æ̈ninque Wængonguï ingante waa ate pönente apæ̈nedinque pædæ godöninque, —Botö wepæ̈ baï impa, ante pædæ pönömo æ̈ninque tömämïni Ao äninque godongämæ̈ intaca beedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Botö wepæ̈ ïïmæ̈ baï impa. Wængonguï do apæ̈nedinque, Botö pönö cæbo ate mïnitö Ao ämïni ïninque mönö godongämæ̈ waa cæte quëwengæ̈impa, angacäimpa. Ñöwo adobaï mïïne äninque apæ̈nebopa. Botö wepæ̈ ante Ao ante æ̈mïni inte mönö godongämæ̈ waa cæte quëwengæ̈impa. Edæ nanguï ïmïni mïni wënæ wënæ cædïnö beyæ̈ ante ñä mënongaquïmæ̈ impa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Näwangä ämopa. Botö Mæmpo Awënë Odeye ïñongä botö tömengä nempo quëwëninque mïnitö tönö godongämæ̈ mïïmæ̈ botö beganca mänïmæ̈ yowepæ̈ ñöwo æ̈mæ̈wo bebo tamëñedäni, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ayæ̈ Wængonguï ingante ämotamïni ante tao godinque Odibowænquidi godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Goyönänite Itota apæ̈necantapa. —Wængonguï beyæ̈ yewæ̈möninque, “Në aadingä ingante tacabo dæ wængä ïninque edæ cæ̈ningäidi obegaidi panguïmæ̈ goquimpa,” ante näni yewæ̈monte angaïnö baï cædinque mïnitö tömämïni ñöwoönæ woyowotæ̈ incæ botö dæ ämo beyæ̈ guingo imonte badinque edæ panguïmæ̈ goquïmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Panguïmæ̈ gomïni incæte botö edæ ñäni ömæ̈monte ate Gadideabæ täno gote a ongöñömo mïnitö ayæ̈ pöedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Angä wædinque Pegodo guiquënë, —Ïñæmpa dæ ämi beyæ̈ tömänäni guingo imonte badinque panguïmæ̈ godäni incæte edæ botö guiquënë cöwë panguïmæ̈ godämaï incæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Äñongante Itota wæætë, —Bitö ïmite näwangä ante apæ̈nebo ëñëe. Ñöwoönæ woyowotæ̈ incæ tawadiya pedämaï ïñonte bitö botö ïmotedö ante wadö ante apæ̈nedinque, Dicæ abogaa, ante edæ mempoga go adopoque anguïmi ïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Angä ëñente wædinque, —Ïñæmpa bitö tönö guëa wæ̈mo incæte botö cöwë, Dicæ abogaa, ante edæ änämaï incæboimpa. Äñongä tömengä mïñæ̈ në godäni tömänäni adodö ante angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mänïï godinque Itota yabæ incæ Guetëmänii näni äñömö tömengä mïñæ̈ në godäni tönö gocantapa. Mänïñömö pöninque tömengä tömënäni ïnänite, —Tæ̈ contate ongöñömïni botö godömenque godinque Wængonguï ingante apæ̈nete pömoedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Äninque Pegodo tönö Tebedeo wëna ïnate ænte mäocä goyönäni Itota ïñömö nanguï wæwente badinque ancai guïñëninque, ");
INSERT INTO aucNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tömënäni ïnänite, —Botö wænguïmämo pönö anguënë, ante botö önöwoca incæ pæ̈mænte wæte wænguï wæ, ante wæbo tamëñedäni. Mïnitö guiquënë ëamonca godongämæ̈ wææ aacöedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Äninque Itota wædænque godömenque godinque guidömëmæ̈ ñongænte Wængonguï ingante apæ̈necantapa. “Botö Mæmpo, bitö Ao äninque edæ tï nä wænguïmæ̈ baï ö ænte baï cædinque botö ïmote edæ, Wæ̈nämaï incæbiimpa, ämi ïninque botö edæ waa tobaïmopa. Incæte botö änönö baï wïï cædinque wæætë tömëmi änönö baï cæe,” ämopa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ante apæ̈necä ate tömengä mïñæ̈ në godäni weca adodö ponte ayongä tömënäni mö ñönäni adinque tömengä Pegodo ingante, —Botö tönö wänö conguënëmïni incæ mïnitö adoque ooda incæ wïï aacömïnii. ");
INSERT INTO aucNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mïmöno waa cæïnëmönipa, ante ëwocayömïni baö aquïïñö ëñamïni inte wæntæye bamïnipa. Ïninque edæ wänö cöninque nämä beyænque ante Wængonguï ingante apæ̈nedinque edæ, Wïï wënæ wënæ cæïnëmöni bacæmönimpa, ante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Äninque Itota adodö wadæ gote wæætë apæ̈nedinque, “Botö Mæmpo, botö bedämaï ïñömote bitö ö æ̈nämaï ïmi ïninque botö cöwë bitö ämaï becæboimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ante Wængonguï ingante apæ̈nete ate ponte ayongante möwo möïnente æ̈mö cæte wædinque mö ñönäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Adinque edæ tömengä wæætë adodö godinque ñöwo mempoga go adopoque nänö apæ̈nedïnö ante adodö ante Wængonguï ingante ïinque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ayæ̈ tömengä mïñæ̈ në godäni weca wæætë adodö pöninque, —Ïñæmpa cöwë mömïni edæ cöwë guëmämïni awædö. Aquënë quëwëedäni. Botö Waobo ëñagaïmo inte botö wæwenguïönæ do bayonte edæ botö ïmote në wënæ wënæ cædäni ïnänite në godö odömonguingä ïñömö do godongäï ataqueedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ængæ̈ gantite mönö gocæ̈impa. Botö ïmo në odömonte godonguingä obo pönï pongä tamëñedäni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ayæ̈ apæ̈neyongä edæ Codaa wodi tömënäni näni, Dote, ante gocabo adocabo ïningä incæ ñöwo pongantapa. Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö oodeoidi ïnänite në aadäni näni Picæncabo tönö da pönönäni pöninque wadäni tæiyæ̈näni adobaï yaëmë næ̈æ̈ninque canta næ̈æ̈näni inte Codaa mïñæ̈ pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Doyedë ïñömö në odömonte godoncæ cæcä Codaa ïñömö tömengä mïñæ̈ poncæ cædäni ïnänite ïïmaï ante wëënëñedë apæ̈nedingä ïnongäimpa. “Botö odömonte queë bemömo adinque mïnitö wæætë, Tömengä ingampa, ante adinque tömengä ingante edæ bæi ongonte ö æ̈edäni.” ");
INSERT INTO aucNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ante do äningä inte Codaa ñöwo ïñömö Itota weca pöninque, —Awënë në Odömömi ïmi, bitö ïmi. Äninque edæ waa cæte baï queë bemongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Adinque Itota wæætë, —Botö mïñæ̈ në godïmi ëñëmi. Mänïnö ante bitö ponque pö cæbäwe. Äñongä wadäni tömengä weca pöninque pædæ gopo bæi ongonte Itota ingante æ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wængonguï quï, ante në godongä ñæ̈nængä pönï ingante në cæcä mänïñömö ponte a ongongä adinque Itota tönö pöningä adocanque pædæ guiipote yaëmë o togænte æ̈ninque mäningä në cæcä ingante tæi päninque önömonca wangö tamoncacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Adinque Itota ïñömö tömengä ingante, —Yaëmë adodö mïni tïe, ämopa. Edæ yaëmë në o togænte næ̈æ̈näni tömänäni ïnänite yaëmenca adobaï tacadäni wæncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ïñæmpa æbänö ante pönëmi edæ. Wængonguï anquedoidi adocabodänique tei mïido ganca ïñönänite botö Mæmpo ingante apæ̈nebo baï tömengä do angä ïninque anquedoidi näni cabo näni cabo incæ önompo tipæmpoga go mencabodäniya botö beyæ̈ ponte cæbaïnänipa, ante pönëmiyaa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Incæte botö Codito ïnömo inte botö Mæmpo ingante mänömaï apæ̈nebo ëñente cæcä baï dodäni, Codito ïïmaï wæncæcäimpa, ante Wængonguï angä ëñente näni yewæ̈mongaïnö ante ædö cæte ïinque bacædönimpa, ante awædö, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ayæ̈ wæætë ñöwo pönäni ïnänite Itota apæ̈necantapa. —Mïnitö ïñæmpa, Bitö në ö æ̈nïmi ïmipa, ante baï cædinque botö ïmote canta tönö yaëmë næ̈ænte ö æncæte ante pömïni awædö. Botö Wængonguï oncö yabæcönë ïïmö ïñö ïïmö ïñö apæ̈necöñömo mïnitö botö ïmote yao ongönämaï ee amïnitapa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Incæte mïnitö Wængonguï beyæ̈ në apæ̈nedäni näni yewæ̈mongaïnö baï ñöwo ïinque baquinque cæmïni abopa. Ante apæ̈necä ëñëninque tömengä ëmïñængä në godïnäni tömänäni edæ näwæ̈ panguïmæ̈ cæte wodii wïnongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ayæ̈ Itota ingante në yao ongonte æ̈näni guiquënë, tömengä ingante mäo godinque edæ, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä Caiapato weca ænte godänitapa. Mänïñömö do pöninque në wææ ante odömönäni tönö oodeoidi ïnänite në aadäni näni Picæncabo tönö do a ongönänimpa. Mänïñömö Itota ingante ænte mämönäni pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pegodo guiquënë tömengä mïñæ̈ ayæ̈ ayæ̈ godinque, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä oncö yacömoyæ̈ ïñömö pö guiidinque, Itota ingante æbänö cæquïnänii, ante wææ wänönäni weca pöninque tæ̈ contate waa acongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në Apænte näni Änoncabo tömänäni, Mönö apænte ante wæ̈nömö wæncæcäimpa, ante cædinque, Itota nänö wænguinque wënæ wënæ cæcä ingampa, ante æcänö babæ ante anguingää, ante diqui diqui mïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Incæte nanguï ïnäni ponte babæ apæ̈nedäni incæte, Æcänö eyepæ̈ babæ änaa, ante edæ dæ angä wædänitapa. Ayæ̈ ate mënaa në babæ wapiticæ̈ änöna inte awënëidi weca pö guiite, ");
INSERT INTO aucNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","apæ̈nedinque, —Ïingä, “Wængonguï tæiyæ̈ waëmö oncö ongö incæte botö ïñömö tæ̈ï pïñæ̈mo ïnömo inte godö cæbo baï wo tænguïmæ̈ wææ̈maimpa. Ayæ̈ mëönaa go adoönæque ïñonte botö wæætë do mæ̈nömaïmopa,” angä ëñentamönapa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ante apæ̈neda ëñëninque në godongä ñæ̈nængä pönï ïnongä incæ ængæ̈ gantidinque Itota ingante, —Ïñæmpa pæ wëënebii. Tömëna bitö ïmitedö ante godö äninque näna änïnö ante bitö æbänö ämii. ");
INSERT INTO aucNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Äñongä Itota cöwë änämaï edæ pæ wëënecä. Adinque në godongä ñæ̈nængä pönï ïnongä wæætë, —Wængonguï në Quëwengä inte tömengä nänö ëñëñongä edæ näwangä ante apæ̈nebi ëñëmönii, ämopa. Mönö Codito ïñömö Wængonguï Wengä ïnongä ingampa. Bitö ïñæmpa mänïmidö ïnömi ïmitawo. ");
INSERT INTO aucNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mänömaï angä ëñëninque Itota wæætë, —Tömëmi bitö änïnö baï mänïmodö ïnömo ïmopa. Incæte botö godömenque apæ̈nebo ëñëedäni. Ïincayæ̈ ate botö ïñömö edæ Waobo ëñagaïmo inte edæ Wængonguï në Tæ̈ï Pïñængä ingä tömëmængä ïnö tæ̈ contabo adinque mïnitö ayæ̈ ate botö öönædë boguïmancodë pömo acæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ante apæ̈necä ëñente wædinque në godongä ñæ̈nængä pönï ïnongä pïinte badinque, Ëñente awædö, ante baï cædinque edæ nämä weocoo wänä ñænte, —Wængonguï ingampa mänömaï cæquingää. Edæ tömengä nämä incæ babæ ante në wënæ wënæ apæ̈necä ïninque idæwaa. Wacä tömengä ingantedö, Wënæ wënæ cæcä atabopa, ante në ancæcäimpa, ante ñöwo diqui diqui mïnämaï ingæ̈impa. Tömengä nämä Wængonguï Wengä inte baï babæ ante nänö änewënïnö ante do ëñëmïni inte mïnitö, ");
INSERT INTO aucNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","edæ æbänö ante pönëmïnii. Ante äñongä në apænte änäni guiquënë, —Nänö wænguinque änewengampa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ante apænte äninque edæ pancadäniya Itota tömengä awinca towæ tänömöninque tæi tæi pänänitapa. Wadäni guiquënë tömengä ingante tamöninque, ");
INSERT INTO aucNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tömengä ingante, —Bitö Codito ïmitawo. Æcänö bitö ïmite awëmö në pänaa, ante Wængonguï beyænque apæ̈nedinque apæ̈nebi ëñëmönii, ante badete togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ayæ̈ Pegodo guiquënë mänïï yæipodë yacömöñäa contate ongöñongä onquiyængä në cæcä ïñömö tömengä weca ponte apæ̈nedinque, —Mäningä Gadideabæ quëwëningä Itota tönö bitö guëa cægömitapa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ante apæ̈neyongä tömänäni näni ayömö Pegodo, —Dicæ. Bitö änö ante æbänö ämii, ante dicæ ëñëmogaa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ante äninque Pegodo yademö gäänë tao gote ongongä adinque wacä onquiyængä wæætë godongämæ̈ ongönäni ïnänite apæ̈nedinque, —Mäningä adobaï Itota Näatadeta quëwënongä tönö në cægöningä ingä aedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ante apæ̈neyongä Pegodo wæætë, —Wængonguï ëñëñongä botö näwangä ämo ëñëedäni. Ïingä onquiyængä nänö në äningä ingante botö dicæ abogaa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ayæ̈ wantæ ate mänïñömö ongönäni Pegodo weca pöninque, —Ïñæmpa Itota tömengä tedecä baï adode në tedebi inte bitö tömengä mïñæ̈ mïni në gocabo adobi ïmipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Äñönäni edæ Pegodo wæætë, Wængonguï ëñëñongä apæ̈nedinque botö nöingä ämopa, ante Wængonguï ëmöwo ante babæ tedewëninque tömënäni ïnänite, —Mïni në angä ingante dicæ abogaa. Mänömaï ante tæcæ änewëñongä edæ tawadiya dobæ petapa. ");
INSERT INTO aucNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pe wædinque tömengä, Æ Itota nänö änïnö baï impa, ante wæcantapa. Itota, “Tawadiya pedämaï ïñonte bitö botö ïmotedö ante wadö ante apæ̈nedinque, Dicæ abogaa, ante edæ mempoga go adopoque anguïmi ïmipa,” angantapa. Ante Pegodo, Ñöwo nänö pequinque do pecampa, ante wædinque oncodo taote edæ guingo imonte wædinque edæ Ca ca wægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ayæ̈ ñäö bayonte, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö oodeoidi ïnänite në aadäni näni Picæncabo tönö apænte äninque edæ, Itota ingante wæ̈nongæ̈impa, ante godongämæ̈ Ao angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Äninque tömengä ingante yao ongonte goti winte æ̈ninque edæ odömänoidi beyæ̈ Oodeabæ awënë gobedönadodo Pidato ingante mäo gönönäni ængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ayæ̈, Itota ingante wæ̈nongæ̈impa, änäni ëñente wædinque Codaa tömengä ingante në godöningä guiquënë, Æ tömengä nänö wænguinquemë cæboïnö ante pönëmogaa, ante guingo imonte wæcantapa. Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në aadäni näni Picæncabo adodö æncædänimpa, ante todëinta padatamö tömënäni näni pönontamö adodö pædæ godoncæte ante gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ayæ̈ tömënäni ïnänite, —Ïñæmpa cæboo. Edæ Itota wënæ wënæ cædämaï ïningä ïñongante botö në godönïmo inte wïwa cæbo ïmo ante awædö. Ante äñongante tömënäni guiquënë, —Tömëmi wënæ wënæ cædïmi inte wentamö bitö entawënö adinque mönitö ædö cæte wæquïmönii. Tömëmi edæ në cædïmi inte edæ abaïmipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Änäni wædinque edæ tiguitamö incæ Wængonguï tæiyæ̈ waëmö oncönë wo wææntodöninque Codaa oncodo tao godinque edæ nämä önömenca wëä æi goti guemencate dobæ wængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mäninta wo wææntodongä ate wædinque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni incæ tiguitamö yao yao ongonte æ̈ninque, —Wepæ̈ näadintamö adinque Wængonguï Baa ancæcäimpa, ante pönente wædinque mönö, Wængonguï quï, ante ædö cæte godonguïmöö. ");
INSERT INTO aucNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ante godongämæ̈ pönencöninque tömënäni, Oodeoidi ïnämaï ïnäni wodido bacæ̈impa, ante ömæ në dai bædongä ëadïömæ incæ mänïï tiguitamö godonte ængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ïninque wepæ̈ näadintamö godonte näni æ̈nïmæ ante, Wepænguipo impa, ante näni pemönïmæ ïñömö ñöwo ganca impa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ïninque do ïñömö Eedëmiya wodi Wængonguï beyæ̈ ïïmaï ante nänö apæ̈negaïnö baï ïinque batimpa. “Idægoidi, Tömengä beyæ̈ mänimpotamö godonte ængæ̈impa, ante näni änimpotamö incæ todëinta tiguitamö padatamö æ̈ninque, ");
INSERT INTO aucNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tömënäni Wængonguï botö ïmote nänö änïnö baï ëñente cædinque edæ dai bædongä ëadïömæ godonte æ̈nänitapa,” ante Eedëmiya nänö angaïnö baï do ïinque batimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Itota ïñömö awënë gobedönadodo Pidato weca a ongöñongante awënë gobedönadodo ïñömö tömengä ingante, —Bitö oodeoidi Awënë Odeyebi ïmitawo. Äñongante, —Bitö tömëmi änö baï botö mänïmodö ïmopa, Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në aadäni näni Picæncabo guiquënë Itota ingante äninque, Wënæ wënæ cæbipa töö, ante äñönäni tömengä edæ pæ wëënecä. ");
INSERT INTO aucNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ate wædinque Pidato wæætë, —Bitö æpogadö wënæ wënæ cæbi ïmipa, ante nanguï änäni ëñënämaï inte bitö ædö cæte edæ pæ wëënebii. ");
INSERT INTO aucNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Äñongante Itota ïñömö tömënäni näni änïnö ante adodeque ante apæ̈nedämaï ingä adinque awënë gobedönadodo wæætë, Quïëmë baï pæ wëënecä awædö, ante wægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mänïmæ awënë gobedönadodo mänïñedë wadepo ïñö wadepo ïñö cöwë ïïmaï cædongäimpa. Oodeoidi æ̈æ̈mæ̈ näni cæyedë gobedönadodo ïñömö, Në tee mönete ongönäni ïnänite adinque mïnitö æcänö ingante ämïni ñimpo cæbo goquingää, ante äñongä änäni ëñëninque tömengä tömënäni näni äningä adocanque ingante ñimpo cæcä godongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mänïñedë adocanque wënæ wënæ nänö cædïnö beyæ̈ tee mönete a ongongampa, ante tömänäni do ëñënönänimpa. Mäningä ëmöwo Badabato ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ïninque nanguï ïnäni godongämæ̈ pönäni ate Pidato tömënäni ïnänite edæ, —Æcänö ingante mïnitö beyæ̈ ñimpo cæbo abæ tawænte gocä ænguïmïni. Badabato ingante ñimpo cæbo gocä ænguïmïni. Wæætë edæ Itota Codito mïni änongä ingante ñimpo cæbo gocä ænguïmïni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Edæ do ïñömö, Itota gomonga cæcä ate wædinque tömënäni tömengä ingante pïinte adönänimpa. Mänïnö beyænque tömënäni Itota ingante bæi ongonte botö nempo ænte mämö pædæ pönönänitapa, ante Pidato do ëñengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ayæ̈ odömänoidi näni apænte anguimpaa ayæ̈ ongöñongä Pidato nänöogængä ïñömö wacä ingante da pönongä pöninque Pidato ingante nänöogængä beyæ̈ apæ̈necantapa. “Botö ñöwoönæ möwocodë wïïmöninque mäningä në nö cædongä beyæ̈ nanguï wogæi wogæi cæwënente wæbopa cæbii. Bitö tömengä ingante gampodämaï inte gomö aquënë quëwëë, ämopa,” ante bitö nänöogængä angampa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Angä ëñente wæyongä, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në aadäni näni Picæncabo näni äincabo guiquënë wadäni në godongämæ̈ ongönäni ïnänite änänitapa. Mïnitö Pidato ingante ïïmaï äedäni. Badabato ingante ñimpo cæbi gocäe. Itota ingante wæætë ämi wæ̈nönäni wængäe, ante äedäni, änänitapa. Awënëidi incæ mänömaï änäni ëñëninque godongämæ̈ ongönäni Ao änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Awënë Pidato ïñömö tömënäni ïnänite äninque, —Mënaa ongöna ïñönate mïnitö æcänö ingante ämïni ñimpo cæbo goquingää. Äñongante, —Badabato ingante ämönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Änäni wædinque Pidato wæætë, —Ïninque Itota Codito mïni änongä ingante æbänö cæquïmoo, ante ämïni. Äñongante tömänäni edæ, —Awæ̈ ñænquedïmæ̈ ämi cæte gönonte wæ̈nönäni wængäe töö. ");
INSERT INTO aucNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Änäni ëñëninque Pidato ayæ̈, —Ïñæmpa quïnö wënæ wënæ cæcantawo. Äñongä tömënäni godömenque yedæ äninque adodö, —Ämi awäa timpote wæ̈nönäni wængäe. ");
INSERT INTO aucNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ante ancaa änewëñönäni Pidato ïñömö, Tæcæ wæætedö wæætë änäni inte tömënäni wënæ wënæ cædäni wæquï wæ, ante guïñente wædinque ayæ̈, Ædö cæte botö godömenque cæquïmoo, ante pönente wædinque edæ æpæ̈ pï ñïñænte tömënäni ayönäni önompo mempodinque tömënäni ïnänite angantapa. —Tömengä wënæ wënæ cædämaï ïñongante botö, Wæ̈nongæ̈impa, änämaï ïmo inte tömengä wepæ̈ näadämaï ïmo aedäni. Wæætë mïnitö guiquënë, Wæncæcäimpa, ante në änïmïni inte edæ näate bacæmïnimpa, ante adinque botö mempobo aedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Angä ëñëninque tömänäni Ao äninque edæ, —Möni änïnö beyænque mönitö incæ mönitö wënäni incæ tömengä wepæ̈ beyæ̈ näate baï bacæmönimpa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Änäni ate awënë gobedönadodo Pidato tömënäni näni änïnö ante ëñente cædinque edæ Badabato ingante ñimpo cædinque tömënäni nempo pædæ godongä æ̈nänitapa. Wæætë edæ Itota ingante edæ Pidato angä æ̈montai badöïmenca tæi tæi pänäni ate tömengä ingante ñænque quepote awäa näni gönonguinque edæ da godongä ænte godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Awënë gobedönadodo nänö wææ wänönäni guiquënë Itota ingante ænte godinque awënë gobedönadodo oncönë Podætodio näni ancönë mangui guiiyongä tontadoidi bacabo Itota weca godongämæ̈ äñete pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pöninque tömënäni, Awënë ïmi inte awënë weocoo wëñacæbiimpa, ante baï cædinque badete todinque Itota weocoo gä tadongadinque wæætë opatawæ̈ ëmoncoo pönö da wëñadinque, ");
INSERT INTO aucNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","daa mongæ̈menca baï æ̈ninque que cædinque, Awënë poganta wencacæbiimpa, ante baï cædinque pönö daga wencadänitapa. Ayæ̈ cæ̈wipa ænte mämö pædæ pönonte änäni æ̈ninque tömengä tömëmæmpoca pæ mangä adinque tömënäni da guicapodinque tömengä ingante, —Badogaa, bitö oodeo awënë odeyebi ïmipæ̈æ̈, ante badete togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ayæ̈ tömengäa towæ towæ tänongadinque cæ̈wipa æ̈ninque tæi tæi ancaa pancadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ayæ̈ ïinque badete todinque tömënäni opatawæ̈ ëmoncoo gä tadongadinque tömengä nämä weocoo daga wëñadänitapa. Ayæ̈ edæ tömengä ingante awæ̈ timpote wæ̈noncæte ante töö æ̈mænte ænte tao mäodäni gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ænte mäo godinque tömënäni Tidëne quëwengä Timönö ingante bee tëninque tömengä ingante edæ, Bitö ægodöe, Itota ingante möni timpoquïwæ̈ ænte mongænte goe, änäni mongænte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mänïï Itota ingante ænte mäo godinque Godogota näni äñömö mönö tededö “Ocataïnö” ïñömö mänïñömö pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mänïñömö pönäni ate wadäni, Nantate beyæ̈ becæcäimpa, ante cædinque yowepæ̈ biïnömæ̈ näni ämæ̈ tönö moncapæ̈ adoyömö wempo cædëninque pædæ pönö cæyönäni tömengä önonque yædæ bedinque edæ Baa angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ayæ̈ Itota ingante awæ̈ ñænquedïmæ̈ näni ænte pönïwäa töö godöninque pönö timpodinque wææ̈ tïwadinque ængæ̈ gantidënänitapa. Ængæ̈ gantidënäni ate wægöñongä tömënäni wæætë tömengä weocoo ïnï ante, Æcänö quinca nö ta adinque tömengä mänincoo æncæcäimpa, ante wææntodöninque adocooque adocooque æ̈nänitapa. Mänömaï cæyönäni Wængonguï beyæ̈ näni apæ̈negaïnö baï ïinque cætimpa. “Botö weocoo ïnï ö æ̈ninque tömënäni näni caboque wacä ingä wacä ingä nënempodänitapa. Ayæ̈, Æcänö quinca nö ta adinque tömengä mänincoo æncæcäimpa, ante cædänitapa.” ");
INSERT INTO aucNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tömënäni tæ̈ contadinque tömengä ingante wææ aadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ayæ̈, Itota në wænguënengä ingampa, ante quïnante änänii, ante edonque acæ̈impa, ante cædinque tömënäni, “Ïingä Itota ïñömö oodeoidi Awënë Odeye ïnongä ingampa,” ante yewæ̈möninque edæ awæmpaa tömengä ocaboca ïnö tee tinte wo cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ayæ̈ wada në ö ænte quëwënïna ïnate adoyedë tömengä tönö adocanque tömëmæ̈ ïnö adocanque dipæ̈mæ̈ ïnö godö timpote ængæ̈ gantidëdäni wægongadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ayæ̈ wodo pænta në godäni guiquënë Itota ingante godö wënæ wënæ ante badete todinque pica pica cædinque, ");
INSERT INTO aucNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","tömengä ingante wapiticæ̈ apæ̈nedinque, —Bitö ïñæmpa Wængonguï tæiyæ̈ waëmö oncö incæ bæ tate wo ëwëninque edæ mëönaa go adoönæque ïñonte do mæ̈noncæ ämitawo. Mänömaï cæcæ änïmi inte bitö tömëmi edæ nämä incæ cæte quëwëmäwe. Bitö nö Wængonguï Wëmi ïmi ïninque edæ o togæmpote o togæ̈wate wææ̈e, ämönipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Äñönäni edæ, Wængonguï quï, ante në godönäni ñæ̈næ̈näni guiquënë në odömönäni tönö ayæ̈ oodeoidi ïnänite në aadäni näni Picæncabo tönö adobaï ïïmaï ante edæ badete todänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Tömengä, Wadäni quëwencædänimpa, ante waa cæcantawoo. Ñöwo ïñæmpa ædö cæte nämä waa cæte quëwenguingää. Idægoidi awënë odeye ingampa diyæ̈ ti wæænte goquingää. Edæ ti wæænte gocä adinque mönitö wæætë edæ, Näwangä impa, ante pönëmaï wædö. ");
INSERT INTO aucNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ayæ̈ nämä ingantedö äninque tömengä edæ, Botö Wængonguï Wëmo ïnömo ïmopa, ante angämæ̈æ̈. Tömengä, Wængonguï cöwë pönö cæcæcäimpa, ante wede pönengä ïñongante Wængonguï wæætë tömengä ingante edæ waa acampa diyæ̈ ñimpo cæcä goquingää, ante badete todänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ayæ̈ në ö æ̈na guiquënë tömengä tönö godongämæ̈ timpote wægöna ïninque Itota ingante pïinte adobaï wënæ wënæ ante badete togadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tæcæbæcä pönï bayö tömämæ ïñontobæ̈ wëmö badinque ayæ̈ ayaönäa wæiganca mæ̈ mämonte baï ïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ayæ̈ edæ ayaönäa wæiyonte Itota nanguï pönï yedæ äninque, “Edii, Edii, nëma tabatäni,” äninque mönö tededö, “Botö Wængonguïñaa, botö Wængonguïñaa, ædö cæte botö ïmo ëmö cæte gobiyaa.” ");
INSERT INTO aucNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ante wæcä ëñëninque godämæ̈ ongönäni guiquënë, —Æ. Ediya ingante aa pecä apa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Äñönäni adocanque do pogodo gote önætamö ænte pöninque biïnömæ̈ baï önömænque ænte aa bedöninque næ̈ænte, Cæ̈wipaca pædæ æ̈æ̈nömo becæcäimpa, ante cæyongä, ");
INSERT INTO aucNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","wadäni guiquënë, —Ee aquënë. Ediya edæ ponte wabänö cæcä quëwenguingä abaimpa, angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Itota ïñömö wæætë ogæ̈ tededinque do wængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ïninque edæ Wængonguï oncö tæiyæ̈ waëmoncönë weocoo odemö näni wææ wodöincoo adoyedë önönæca ïnö tæcæguedë pönï tænguïmæ̈ wææntapa. Ayæ̈ goinque bayonte dica incæ tæ̈ gämæntapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ayæ̈ wao wodido incæ wi æ̈note bayonte edæ Wængonguï quïnäni do wængaïnäni incæ pancadäniya ñäni ömæ̈möninque ");
INSERT INTO aucNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","tömënäni wodido abæ tawænte godänitapa. Edæ ñöwo ïñömö, Itota ñäni ömæ̈mongä ate tömënäni në ñäni ömæ̈mönïnäni inte Eedotadëë näni waëmö quëwëñömö ponte a ongöñönäni nanguï ïnäni agadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mänïï goinque do pö adinque ayæ̈, Æbänö cætimpa, ante tömänö adinque edæ tontado capitäö tönö wææ wänönäni tönö ancai guïñëninque, —Näwangä impa. Ïingä ïñömö Wængonguï Wengä ingaïnö ante pönenguënë, angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Do ïñömö Itota Gadideabæ quëwente pöñongante onquiyæ̈näni nanguï ïnäni tee empote pöninque tömengä beyæ̈ në cædïnäni inte ñöwo adodäni adoyömö pö gongæ̈ninque pömö adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mäadiya Mäagadadënä tönö wacä Mäadiya ïnatapa. Ïïnä ïñömö Tantiago tönö Ootee badä ïnantapa. Ayæ̈ Tebedeo wëna tömëna badä tönö wadäni adobaï Itota wæ̈ñongante gobæ agadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ayæ̈ gäwadecæ̈ bayonte Ootee në nanguï ëacä incæ Itota mïñæ̈ në gocä do badingä inte Adïmatea ïñömö pægaingä inte pongä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tömengä ïñömö ñöwo Pidato weca godinque, Itota wodi baö ïnï pönömi æ̈moe, angantapa. Pidato Ao äninque në cædäni ïnänite, Tömengä baö ee amïni æncæcäimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Itota wodi baö ïnï gämiyate pædæ wææ̈nonte ænte godinque waëmö weocoo nïnocoo näni ancoo wïni wïni caadinque, ");
INSERT INTO aucNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ootee, Botö wodido baquimpa, ante dicamontaa nänö wodintatodë mïintatodë mäo guidö ñö cædinque daga wengantapa. Ayæ̈ dicabo da pæ̈ñæ̈ pönö tee mönodinque wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ïïmaï cæyongä Mäadiya Mäagadadënä tönö wacä Mäadiya tönö Itota wodido obo contate acönatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ayæ̈ guëmanguïönæ bacæ cæpa, ante näni täno cæönæ ïinque cædäni ate ïïmö ate, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö Paditeoidi guiquënë Pidato weca ponte ");
INSERT INTO aucNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tömengä ingante äninque, —Awënë ëñëmi. Mäningä në babæ äningä ïñömö tömengä mïingä ïñedë apæ̈nedinque, Mëönaa go adoönæque ïñonte botö ñäni ömæ̈moncæboimpa, ante nänö änïnö ante pönente wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ayæ̈ tömengä mïñæ̈ në godïnäni incæ tömengä baö ïnï awëmö ö æ̈maïnäni ante edæ wæ̈mönipa. Æ̈näni ïninque tömënäni, “Dobæ ñäni ömæ̈mongäimpa,” ante godömenque babæ änäni edæ wënæ wënæ babaimpa cæbii. Ñöwo wææ wänönäni ïnänite ämi godinque tömënäni mäningä nänö wodintatodë tæ̈ëmö tee mönodinque mëönaa go adoönæque ganca wææ wänonte acædänimpa. Edæ wïï godömenque wënæ wënæ bacæ̈impa, ante cæcæbiimpa, ämönipa. ");
INSERT INTO aucNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Äñönäni Pidato wæætë, —Bado, wææ wänönäni mæ̈ ongönänipa. Mïnitö tömënäni ïnänite ænte mäomïni goyönäni mïnitö wæætë mïni ëñënïnö baï do cædinque tæ̈ëmö tee mönote cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Angä ëñente godinque tæ̈ëmö mönodinque Itota nänö wodintatodë dai tee bædodänitapa. Ayæ̈, Awënë ëmöwo adinque wi æ̈nodämaï incædänimpa, ante dai bæyömö aquïñedë ongontoca da guidonte awënë ëmöwo adimpaca yewæ̈monte baï bagatimpa. Ayæ̈ wææ wänönäni ïnänite ænte mäo gö cædäni wææ wänongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mänïï guëmanguïönæ ïinque go ate wacä tëmäna baquinque ñäö ba ïninque Mäadiya Mäagadadënä tönö wacä Mäadiya ïñömö Itota wodido acæte ante gogadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Awënë Wængonguï anquedo do wææ̈ pöninque edæ dicabo wëä godö oo wi æ̈nocantapa. Ayæ̈ goinque nanguï ocæ ocæ cætimpa. Anquedo ïñömö dicaboga tæ̈ contacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tömengä awinca näinte cæ baï ëmönongä inte tömengä weocoo näämænta pönï ëmoncoo mongænte a ongongä. ");
INSERT INTO aucNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Adinque edæ në wææ wänönäni guiquënë ancai guïñente wædinque do do wäate baï badinque æ̈mæ̈wo wænte baï öñönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mänïï onquiyæ̈na pöñönate Wængonguï anquedo ïñömö, —Guïñënämaï ïeda. Itota näni awäa timpodäni wæ̈ningä ingante mïnatö diqui diqui mïmïnapa, ante edæ do ëñëmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ïñömö edæ dæ angampa. Tömengä nänö änïnö baï cædinque do edæ ñäni ömæ̈möninque tao gocäimpa. Pö guiite aeda. Ïintatodë nänö öñontatodë ïñömö edæ önontatoque impa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ayæ̈ në adïmïna inte edæ quingæ̈ pogodo gote tömengä mïñæ̈ në godïnäni ïnänite gode ante apæ̈nedinque, “Itota dobæ ñäni ömæ̈mongäimpa ataqueedäni, äeda.” Ayæ̈ ïñömö tömengä Gadideabæ täno godinque a ongöñongä mïnitö gote aedäni, ante mïnatö gode ante apæ̈neda ëñëedäni. Bado, ämo ëñëmïnapa edæ. ");
INSERT INTO aucNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Angä ëñëninque tömengä wodido abæ tawænte wadæ godinque tömëna, Ancai guïñente wæte todadö, äninque watapæ̈ todinque Itota mïñæ̈ në godïnäni ïnänite gode ancæ pogodo godatapa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Goyöna edæ Itota incæ ïñontobæ̈ mäo bee tëninque edæ, Mïnatö, angä ëñëninque edæ ïñäna tömengä weca pöninque önöwaca ædæ wæænte mö ongöwate, Wængonguï Awënë ïmidö anguënë, ante watapæ̈ apæ̈neyöna, ");
INSERT INTO aucNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Itota ïñömö edæ, —Guïñënämaï ïeda, angantapa. Ayæ̈, Mïnatö botö biwïidi ïnänite gode äninque ïïmaï äeda. Mïnitö Gadideabæ godinque botö ïmote acæmïnimpa, ante tömënäni ïnänite äeda, ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Onquiyæ̈na gode ancæ goyöna Itota wodido në wææ wänönïnäni pancadäniya wæætë tömënäni näni quëwëñömö godinque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni ïnänite apæ̈nedinque, Ïïmaï cætimpa, ante tömänö ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Apæ̈nedäni ëñëninque edæ në godönäni ñæ̈næ̈näni guiquënë në aadäni näni Picæncabo tönö pönë cöninque godongämæ̈ Ao äninque tontadoidi në wææ wänönäni ïñönänite tiguitamö padatamö bacoo godöninque, ");
INSERT INTO aucNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tömënäni ïnänite ïïmaï angadänimpa. —Wadäni Itota wodi baö ante wæyönäni edæ mïnitö önonque, Mö cöñömöni tömengä mïñæ̈ në godïnäni awëmö ponte ö æ̈nänitapa, ante babæ apæ̈necæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ayæ̈ mänïnö äñömïni awënë gobedönadodo ëñëninque, Quïmæ̈ möwëmïnii, ante pïingä adinque edæ mönitö wæætë wææ cædinque tömengä ingante ämöni ëñëninque tömengä pänämaï ñimpo cæyongä mïnitö guïñente wædämaï incæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Äninque në godönäni ñæ̈næ̈näni ïñömö në wææ wänönïnäni ïnänite nanguï tiguitamö godönäni æ̈nänitapa. Mänintamö æ̈ninque awënëidi babæ näni änïnö baï adodö ante apæ̈nedinque, Tömengä mïñæ̈ në godäni ö æ̈nänitapa, ante babæ wapiticæ̈ apæ̈negadänimpa. Ïninque tömënäni näni babæ apæ̈nedö ëñëninque edæ oodeoidi gode ante tededinque godömenque ñöwo ganca ayæ̈ wapiticæ̈ ante tededänipa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Önompo æ̈mæmpoque go adodänique Itota mïñæ̈ näni godincabo guiquënë mänïï Itota nänö änö baï cædinque Gadideabæ godinque änanquidi æiyönäni ");
INSERT INTO aucNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Itota a ongongä adinque tömengä weca ædæ wæænte, Wængonguï Awënë ïmidö anguënë, ante watapæ̈ apæ̈neyönäni pancadäniya guiquënë, Wabänö ï, ante pönënämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Itota ïñömö tömënäni weca pönömenque pöninque, —Wængonguï pönö cæcä beyænque botö ïñömö öönædë Tæiyæ̈ Awënë ïnömo inte inguipoga adobaï në Tæiyæ̈ Awënë badinque nämä tæ̈ï pïñæ̈mo inte në ämo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ante wædinque mïnitö guiquënë inguipoga tömämæ quëwënäni weca godinque, Itota mïñæ̈ gocædänimpa, ante apæ̈nemïni ëñente botö mïñæ̈ në godäni bacædänimpa. Ayæ̈ mönö Mæmpo ëmöwo apæ̈nedinque, ayæ̈ Wængonguï Wëmo ïñömote botö ëmöwo apæ̈nedinque, ayæ̈ Wængonguï Tæiyæ̈ Waëmö Önöwoca ëmöwo apæ̈nedinque mïnitö tömämæ quëwënäni ïnänite æpæ̈në guidömïni guiicædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ayæ̈ botö mïnitö ïmïnite botö änïnö ante, Tömänö ante adodö cæedäni, ante odömömïni ëñente cæcædänimpa. Ayæ̈ botö edæ ñöwo incæ ayæ̈ inguipoga ïinque baganca cöwë mïnitö tönö ongonte godongämæ̈ cæcæboimpa. Näwangä inguïnö anguënë, ante Itota angacäimpa.");
INSERT INTO aucNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ponguingä, ante näni Codito angaingä ïnongä inte Wængonguï Wengä Itota ingantedö ante botö Mäadocobo watapæ̈ ante yewæ̈mömopa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Doyedë ïñömö Wængonguï beyæ̈ apæ̈nedinque, Codito ingante Wængonguï ïïmaï angäimpa, ante Itaiya wodi yewæ̈mongacäimpa. “Taadö bitö goquïnö waa wëwaquingä, ante baï cædinque botö, Botö beyæ̈ në gode änongä ingante da godömo täno beyænte gocä ate bitö ayæ̈ gocæbiimpa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Önömæca ïñömö adocanque ogæ̈ tedete aa pecæcäimpa. Tömengä ïñömö, ‘Awënë nänö ponguïnö ante mïnitö tee moncate baï cædinque, taadö töïnö pïnonte baï cæedäni,’ ante aa pecä ëñengæ̈impa,” ");
INSERT INTO aucNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ante Itaiya wodi nänö në angaingä ïnongä inte Wäö ñöwo önömæca pöninque æpæ̈në guidongantapa. Mänömaï cædinque tömengä mänïñömö pönäni ïnänite apæ̈nedinque, Mïnitö, Idæwaa wënæ wënæ cæte awædö, ante ocæ̈ ëmænte Wængonguï gämæ̈nö pöninque æpæ̈në guiicæmïnimpa. Mänömaï cæmïni adinque Wængonguï mïnitö cædïnö ante në panguënengä incæte pïïnämaï inte ñimpo cæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ante Wäö mänömaï apæ̈neyongante Oodeabæ tömäo quëwënäni Eedotadëë quëwënäni tömänäni tömengä weca pö pö bee tente ëñëninque, Näwangä ämipa. Bitö ä baï ëñënämaï cæte quëwëmöni inte idæwaa wënæ wënæ cæte awædö, ante wædäni ëñëninque Wäö Oododänö æpæ̈në guidongä guiidänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Wäö ïñömö weocoo ante cämeyo ocaguincoo nonte badöincoo mongænte adobaï pacadeyænta ante æ̈montai badonte encadeyæ̈nongäimpa. Tömengä cænguï ante ñäwäique cænte tömengä bequï ante guïñëmænque ade bete në quëwënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ïïmaï ante apæ̈necä ëñënänitapa. “Ïincayæ̈ ate në Ponguingä guiquënë tömengä tæ̈ï ëmongä ëwocadongä inte nanguï cæcä ingampa. Botö guiquënë wædämo pönï ïnömo inte tömengä awæncata eyepæ̈ ïmopa godö ñï cæquïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Botö önonque æpæ̈në guidömo guiimïnipa. Tömengä wæætë da pönongä ate Wængonguï Tæiyæ̈ Waëmö Önöwoca pö guiicä ëwocacæmïnimpa,” ante Wäö mänïñedë apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ïninque Gadideabæ Näatadeta quëwente Itota mänïñedë pongä adinque Wäö Oododänö æpæ̈në tömengä ingante guidongä guiicantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ïninque æpæ̈në guiidingä inte do ää ta gongæ̈ninque Itota æ̈mö ayongä öönæ gä godonte bayö equemö wææ̈ baï Wængonguï Tæiyæ̈ Waëmö Önöwoca incæ tömengäa wææ̈ guiicä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ayæ̈ ëñëñongante, “Bitö botö Wëmi ïnömi inte në botö waadebi ïmipa, ate tobopa,” ante öönædë ïnö apæ̈necä ëñengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mänïñedë Itota ingante Wængonguï Önöwoca incæ, Æibawë, äninque önömæca mæ̈icä æicantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Æi quëwëninque wantæpiyæ̈ coadenta ëönæ önömæca quëwëñongante wënæ awënë Tatäna pöninque, Wënæ wënæ cæcæcäimpa, ante Itota ingante cædongäimpa. Ayæ̈ Itota mänömaï babæidi quëwëñömö quëwëñongante Wængonguï tömengä anquedoidi ïnänite da pönongä pöninque tömënäni tömengä beyæ̈ pönö waa cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mänömaï cæte ate ayæ̈ awënë odeye Edode dobæ Wäö ingante tee mönecä ate mänïñedë Gadideabæ pöninque Itota mä Wængonguï nänö waa pönï cægaïnö ante ïïmaï ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Ponguingä, ante dodäni näni angaïñedë botö Wængonguï Awënë Odeyebo ïnömo inte ñöwo ïinque bayedë do pömopa, ante apæ̈nebo ëñëedäni. Mïnitö wënæ wënæ mïni cædïmämo wido cædinque waa pönï botö apæ̈nedïnö mïni ëñënö ante pönëedäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ayæ̈ mänïï pöninque Itota gäwapæ̈ Gadideapæ̈ yæwedeca gote cægonte ayongä Timönö tönö Æntade tömengä tönïñacä ïnate acantapa. Në gæyæ dadöwëna ïnöna inte tömëna dicamöñæ̈ æpæ̈në wo guitodonte dadöwëna acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tömëna ïnate Itota, —Ïñäna, botö mïñæ̈ edæ tee empo pöeda, ämopa. Në dadonte ænte pömïna inte botö weca pöñömïnate botö pönö cæbo ate mïnatö wæætë në apæ̈nemïna badinque waodäni ïnänite në ænte pömïna bacæmïnaimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Angä ëñëninque tömëna dicamöñæ̈ do ëmö cæte godinque Itota mïñæ̈ edæ tee empo wadæ godatapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Itota ïñömö godömenque gote ayongä Tebedeo wëna Tantiago tönö Wäö adobaï wipodë dicamöñæ̈ tadömoncöna acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Adinque Itota do, Botö mïñæ̈ pöeda, angä ëñëninque tömëna Ao äninque wæmpocä ingante wæætë, Mæmpo ëñëmi, änatapa. Bitö nempo wipo ëmö cæte gomönapa, äninque adodaque wæmpocä ingante ëmö cæte Itota mïñæ̈ wadæ godatapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ayæ̈ tömënäni quëwëñömö Capënaömö mämongä pönänitapa. Oodeoidi guëmanguïönæ bayonte Itota ïñömö Wængonguï apæ̈necä näni ëñente yewæ̈mongainta ate näni odömöincönë do pö guiidinque odömonte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ëñëñönäni tömengä nämä tæ̈ï pïñæ̈ninque në angä ïnongä inte nö odömonte apæ̈necä ëñente wædinque tömënäni, Wadäni në wææ odömönäni guiquënë mänömaï odömonte apæ̈nedäni ëñëmongaa. Itotaque nämä në ëñente entawënongä inte nö pönï odömonte apæ̈necä ëñëmönipa, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ayæ̈ wënæ wentamö ëwocacä inte në quëwengä mänïñedë tömënäni odömöincönë a ongöninque ïñontobæ̈ yedæ ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Bitö Itota Näatadeta quëwënïmi inte quïnante mönatö weca pömii. Mönatö ïmönate edæ æ̈mæ̈wo wido cæcæte ante wabänö pömitawo. Bitö æmömidö ïmii, ante botö do atabopa. Bitö Wængonguï Tæiyæ̈ Waëmö Wëmi ïnömi ïmipa, ante edæ do ëñëmopa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ante tedeyongante Itota tömengä ingante wææ äninque, —Apocæ̈në quëwenguënë tedewëë. Waocä baönë quëwënömi inte edæ tao gobäwe. ");
INSERT INTO aucNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Angä ëñëninque wënæ në wentamö ëwocacä ïñömö waocä ingante quidi quidi mäo tæ̈ gotodö go wææ̈ñongante, Yæ yæ, äninque dobæ tao gotapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Itota angä wënæ tao gocä adinque tömänäni guïñente wædinque näni caboque wæætedö wæætë tededinque, —Ïingä ïñömö quïnö baï ante cæcä. Tömengä në angä ïnongä inte edæ mä pönï odömonte apæ̈necampa. Edæ wënæidi në wentamö ëwocadäni ïnänite tömengä angä ëñente cædänipa, ante awædö. ");
INSERT INTO aucNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ante pönente wædinque tömënäni, Itota mänömaï cæcampa, ante tededinque Gadideabæ tömäo quëwënäni ïnänite mäo gode ä gode ä cædäni do ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mänïï Itota oodeoidi odömöincönë ongöninque ïinque odömonte apæ̈necä ate tömënäni tao godinque Tantiago tönö Wäö mïñæ̈ godinque Timönö tönö Æntade oncönë go guiidänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Go guiiyönänite wadäni, Timönö nänöogængä wäänä daicawo gawænte möïmoga öñongampa, änäni. ");
INSERT INTO aucNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ëñente wædinque Itota tömengä weca go gongæ̈ninque pædæ wææmpote bæi ongonte töö æ̈mængä ate tömengä ængæ̈ ganticantapa. Ayæ̈ gancæ badinque tömengä wæætë tömënäni beyæ̈ cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mänïönæ gäwadecæ̈ pönï nænque wëmö bayö wadäni daicawo gawæ̈näni ïnänite wënæ inte quëwënäni ïnänite tömänäni ïnänite Itota weca ænte pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ayæ̈ mänïñömö quëwënäni tömänäni adoyömö pöninque odemö goto gongæ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ayæ̈ quïëmë beyæ̈ wënæ wënæ inte wædäni adinque Itota nanguï ïnäni ïnänite godö cæcä waa badänitapa. Ayæ̈ wënæidi nanguï ïnäni ïnänite wido cædinque Itota, Botö æbodö ïmoo, ante në adïmïni inte tededämaï ïmäewedäni, ante tömënäni ïnänite wææ angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ayæ̈ tæcæ oque pönente wëmö ïñonte ængæ̈ gantidinque Itota oncodo tao gote gomonga önömæca godinque Wængonguï ingante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Apæ̈neyongante Tïmönöidi, Ædönö gocäï, ante tee empo tee empo gote, ");
INSERT INTO aucNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","adinque, —Dæ ämi wædinque tömänäni bitö ïmite ante diqui diqui mïnänipa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ante äñönänite Itota wæætë, —Mönö wayömö gocæ̈impa. Eyequeï näni quëwëñömö näni quëwëñömö mäo botö apæ̈nebo ëñencædänimpa, ante cæcæte ante tate pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ante në äningä inte Gadideabæ tömäo godinque oodeoidi odömöincönë go guii go guii cædinque Wængonguï nänö apæ̈nedö ante Itota apæ̈necä ëñengadänimpa. Ayæ̈ wënæidi ïnänite wido cæcä gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ayæ̈ wacä cöwë baate ëñawengä ïnongä inte Itota weca ponte da guicapodinque, —Bitö Ao ämi inte wadæ caabi ïninque botö do waintai baabaïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Äñongante Itota tömengä tönö guëa wæwente baï nanguï pönengä inte pædæ wææmpo gampo caadinque, —Ao ämopa. Bitö waintai baacæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Angä ïninque ñömæ̈intai nänö ëñadintai dæ baadinque tömengä waintai edæ do baacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Itota edæ tömengä ingante do da godöninque nanguï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ëñëmi. Botö æbänö cæboo, ante edæ wadäni ïnänite mäo apæ̈nedämaï ïmäwe. Wæætë, Näwangä impa, ante acædänimpa, ante cædinque bitö, Wængonguï quï, ante në godongä weca töingä godinque waintai bitö baadintai odömömi ædæmö acæcäimpa. Ayæ̈ Möitee wodi wææ ante nänö angaincoo baï ænte pöninque bitö waintai bitö baadï beyæ̈ ante edæ, Wængonguï quï, äninque në godongä ingante pædæ godömi æncæcäimpa, ante Itota në baadingä ingante nanguï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Angä incæte në baadingä wæætë wadæ godinque ëñënämaï inte gode ä gode ä cædinque edæ, Itota wadæ caacä waintai baaboï aedäni, ante mäo tedecä ëñënänitapa. Mänömaï ëñënämaï cæcä beyænque Itota, Tömënäni weca ñöwo ædö cæte edonque goquïmoo, ante wædinque nänënë gote önömæca gomonga cægongantapa. Incæte tömengä weca æ̈mæ̈nö quëwënäni æ̈mæ̈nö quëwënäni cöwë pö pö cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ayæ̈ tæ̈önæ quëwëninque ocæ̈ ëmænte Capënaömö pongä adinque wadäni, Itota oncönë ponte ongongampa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ante tededäni wædinque nanguï ïnäni acæ pönäni oncönë eyede pönï guiidinque odemö incæ tömäo wææ ongönänitapa. Mänömaï tömäo goto ongönäni ïnänite tömengä Wængonguï nänö apæ̈nedö ante apæ̈necä. ");
INSERT INTO aucNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ëñëñönäni wadäni tönö godongämæ̈ pöninque mengäa go mengäa ïnäni incæ cömäingä nänö möimpataa æ̈mætæ̈ æ̈mætæ̈ bæi ongonte næ̈ænte pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ponte ayönäni wadäni Itota weca eyede pönï goto ongönäni adinque në ænte mämö pönïnäni ïñömö, Ædö cæte guiiquïï. Ante wædinque oncömäa ïnö æidämæ̈ mæ̈i æidinque Itota önönæca ïnö epæ̈ cædäni ompite gongæ̈ñö tömënäni cömäingä möimpataa bæi ongöninque tömengä ingante Itota weca edæ pædæ wææ̈nönäni. ");
INSERT INTO aucNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wæænte ongongä adinque, Tömënäni æbänö wede pönente cædänipa, ante adinque Itota cömäingä ingante, —Botö wëmi wædämaï ïe. Wënæ wënæ bitö cædïmämo ante bitö ñöwo ñimpo cæte quëwencæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ante apæ̈necä ëñëninque në wææ odömönäni guiquënë pancadäniya godämæ̈ tæ̈ contate ongöninque nämäneque pönente tededinque, ");
INSERT INTO aucNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Quïmæ̈ änewëë. Ïingä ïñömö Wængonguï ingampa diyæ̈ mänömaï cæquingää. Edæ babæ ancædö. Waomö wënæ wënæ mönö cædïmämo ante Wængonguinque në ñimpo cæcä ingampa.” ");
INSERT INTO aucNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ante mïmönoque pönëñönäni Itota tömënäni näni pönëwënö ante önöwënenque do ëñente baï pönëninque edæ, —Mïnitö quïmæ̈ mänömaïnö ante pönëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Botö në cömäingä nänö wënæ wënæ cædïmämo ante ñimpo cæbo quëwencæcäimpa,” ante botö Wængonguï baï ämo ëñëninque mïnitö guiquënë, Wængonguï ingampa diyæ̈ mänömaï cæquingää, ante pönëmïnipa. Wæætë edæ, “Ængæ̈ gantidinque möimpata æ̈ninque dao dao gocæcäimpa,” ante botö Wængonguï baï ämo ïninque mïnitö adobaï, Wængonguï ingampa diyæ̈ mänömaï cæquingää, ante pönëmïni ïmaïmïnipa, ante awædö. Ïñæmpa mänömaïnö ante pönëmïni ïninque mïnitö edæ æbänö cæquënëmo ïmo ämïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Incæte botö Waobo ëñagaïmo inte inguipoga quëwëninque waomïni mïni wënæ wënæ cædïmämo ante në ämo inte ñimpo cæbopa, ante mïnitö edæ ëñencæmïnimpa, ante botö ïïmaï cæbopa. Äninque edæ në cömäingä ingante edæ, ");
INSERT INTO aucNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Bitö ïmite ämo ëñëe. Ængæ̈ gantidinque bitö möimpata topo cæte æ̈ninque edæ tömëmi oncönë næ̈ænte goe. ");
INSERT INTO aucNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Angä ëñëninque cömäingä ïningä incæ edæ tömänäni ayönäni ængæ̈ gantidinque möimpata topo cæte næ̈æ̈ næ̈æ̈ tao gocä adänitapa. Dao dao gocä adinque tömënäni, Æbänö cæcäï, ante ëñënämaï inte guïñente wædinque, —Wëënëñedë mänömaï cædäni atamöniyaa. Ñöwo ïñömö mä pönï cæcä amönipa, ante pönëninque, Wængonguï bitö ñäö ëmömi inte waa pönï cæbi amönipa, ante watapæ̈ apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Itota wæætë adodö gäwapæ̈ wedeca gocantapa. Ayæ̈ nanguï ïnäni adoyömö pö pö cædäni adinque tömengä tömënäni ïnänite odömonte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ayæ̈ godömenque cægonte ayongä Adepeo wengä Debii ïñömö, Odömäno awënë quï bacæ̈impa, ante godonte æ̈inta näni æ̈incönë awënë beyæ̈ æncæte ante ongongä adinque Itota tömengä ingante, —Botö mïñæ̈ pöe. Angä ëñëninque Debii edæ ængæ̈ gantidinque tömengä mïñæ̈ wadæ edæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ayæ̈ ate Itotaidi Debii oncönë pö guiite cængöñönäni odömäno awënë beyæ̈ në æ̈wënäni tönö në ëñënämaï cædäni tönö nanguï ïnäni adoyömö pö guiite godongämæ̈ cæ̈nänitapa. Edæ tæiyæ̈näni tömengä mïñæ̈ në godäni ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Paditeoidi ïnönäni inte në odömönäni guiquënë ponte ayönäni në ëñënämaï ïnäni tönö awënë beyæ̈ në æ̈wënäni tönö Itota godongämæ̈ cængä adinque tömënäni tömengä mïñæ̈ në godäni ïnänite änänitapa. —Odömäno awënë beyæ̈ në æ̈wënäni tönö wadäni në ëñënämaï cædäni tönö Itota quïmæ̈ godongämæ̈ cæ̈wengää. ");
INSERT INTO aucNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Äñönäni Itota wæætë tömënäni ïnänite, —Në waa ingä guiquënë, Cæbi waa baboe, änämaï ingampa. Në wënæ wënæ ingä guiquënë dotodo ingante do, Cæbi waa baboe, ante aa pecampa. Pancadäniya, Nämä incæ nö entawëmo ïmopa, ante në änäni ïnänite adinque botö në dotodo baï adobaï ïnömo inte tömënäni ïnänite aa pedämaï incæboimpa. Wadäni guiquënë, Nämä wënæ wënæ cæbo ïmopa, ante në änäni guiquënë, Wængonguï gämæ̈nö poncædänimpa, ante botö tömënäni ïnänite aa pecæ pontabopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wäö mïñæ̈ në godäni tönö Paditeoidi tönö mänïñedë Wængonguï beyæ̈ ante ee ate cæ̈nämaï ïnönänimpa. Ïninque wadäni Itota weca pöninque änänitapa. —Wäö mïñæ̈ në godäni tönö Paditeoidi mïñæ̈ në godäni tönö tömënänique, Wængonguï beyæ̈, ante ee ate cæ̈nämaï ïnänipa. Bitö mïñæ̈ në godäni guiquënë quïnante Wængonguï beyæ̈ ante cædämaï ïnäni inte do cæ̈nänii. ");
INSERT INTO aucNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Änäni ëñëninque Itota wæætë, —Onguïñængä në monguingä nänö wente ænte në pönäni baï ïnönäni inte botö mïñæ̈ në godäni ïñömö ædö cæte wæwente baï cæ̈nämaï inguïnänii. Edæ botö tönö watapæ̈ quëwënäni inte tömënäni ædö cæte wæwente baï cæ̈nämaï inguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wæætë ayæ̈ ate guiquënë, Monguingä, näni në änongä baï ïñömote wadäni ponte botö ïmote bæi ongöninque ö ænte gocædänimpa. Mänömaï cædäni ate botö mïñæ̈ në godäni ïñömö mänïñedë ate wæætë cæ̈nämaï inte wæcædänimpa, ante apæ̈nedinque Itota godömenque ïïmaï ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Waocä dicæ mïincoo æ̈ninque pedæncooga pönö tadömonguingäa. Mänömaï cæcä ïninque edæ mïincoo incæ dobæ gäänë tamonte guipite ate godömenque wänä tente baquënë. Mïnitö, Awente baï cæ̈nämaï inte waa quëwengæ̈impa, ante mïni änewënö guiquënë pedæncoo baï inte ëwenguïne ënepa. Codito nempo watapæ̈ quëwengæ̈impa, ante botö apæ̈nedö guiquënë mïincoo baï inte quëwenguïne ënepa. Ïninque ëwenguïne tönö quëwenguïne ædö cæte adoyömö ëñente cæquïï. ");
INSERT INTO aucNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ayæ̈ adobaï yowepæ̈ biïnömæ̈ mïïmæ̈ æ̈ninque waocä ædö cæte picæ̈ æ̈montaicadedë godö pe ñïñænguingää. Edæ picæ̈ æ̈montaicadedë pe ñïñængä ïninque yedæ æ̈æ̈ninque ætæwo goquïnö anguënë. Wæætë edæ æ̈montai mïincadedë pe ñïñænte ate yedæ æ̈æ̈ninque tæi æbæ̈nämaï ee ongonguï apa quëwëmïni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ayæ̈ ate guëmanguïönæ ïñonte Itota tömëmoncodë tæcæguedencodë gocantapa. Goyongä tömengä mïñæ̈ në godäni tömëmö inca tæcæ tä pe tä pe ænte idömæ godäni. ");
INSERT INTO aucNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Adinque Paditeoidi guiquënë Itota ingante äninque, —Bitö mïñæ̈ në godäni æbänö cædänii, ante cöwä aquënë. Ïñæmpa, Guëmanguïönæ ïñonte mänïnö baï cædämaï ïedäni, ante dodäni näni wææ angaïnö ante ëñënämaï inte ïïnäni ëñënämaï inte quïmæ̈ cædänii. ");
INSERT INTO aucNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ante pïïñönänite Itota, —Docä Dabii wodi tömengä nänö në ëmïñæ̈näni tönö ömæpodäni pönï inte gæ̈wænte wædinque æbänö cægadänii, ante yewæ̈monte öñö incæ mïnitö ïñæmpa adämaï inte ämïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wængonguï quï, ante në godönänique cænguï impa, ante wææ näni angaïnö baï cædinque dodäni päö, Wængonguï quï, ante ñoncæ ñoncæ cædönänimpa. Incæte Abiatade wodi në godongä ñæ̈nængä pönï ïnongä nänö godöñedë mänïñedë Dabii wodi Wængonguï oncönë go guiidinque mänïï päö do ænte cæ̈ninque tömengä mïñæ̈ në godäni ïnänite godömenque godongä cæ̈nänitapa, ante yewæ̈monte öñö apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ante apæ̈nedinque Itota ayæ̈, —Wængonguï quïnante, Guëmanguïönæ, ante badongacäï, ante pönëmïni. Guëmancædänimpa, ante cædinque Wængonguï waomö beyænque ante, Mïnitö guëmanguïönæ, ante badongacäimpa, ante pönenguënëmïni ïmïnipa. Ædänidö mänïönæ ïñonte cædämaï ïnänii, ante pönëninque Wængonguï dicæ mänïönæ beyænque ante waodäni ïnänite badongantawogaa. Ædö cæte mänömaïnö ante pönëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ïninque botö Waobo në ëñagäïmo ïñömö Tæiyæ̈ Awënë ïnömo inte edæ guëmanguïönæ Awënë ïnömo ïmopa. Ayæ̈, Guëmanguïönæ ïñonte edæ æbänö cæquïï, ante adobo në Ämo ingaïmo ïmopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ïincayæ̈ ate Itota wæætë oodeoidi Wængonguï apæ̈necä näni ëñente yewæ̈mongainta ate näni odömöincönë go guiicantapa. Mänïñömö onguïñængä nï cömampote wædongä inte a ongongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mänïñedë Paditeoidi pancadäniya, Itota wapiticæ̈ cæcä ïninque mönö wæætë pïinte angæ̈impa, ante në änewënäni inte cædönänimpa. Ñöwo ïñömö tömënäni, Guëmanguïönæ ï incæte Itota nï cömampoingä ingante, Waa bacæcäimpa, ante cæcä ïninque mönö mäo pïinte angæ̈impa, ante babæ cæcæte ante cöwä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ante cöwä ayönäni nï cömampoingä ingante Itota, —Bitö ængæ̈ gantidinque tæcæguedë pö næ̈ gongæ̈e. ");
INSERT INTO aucNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Äninque wæætë në pïinte ancædäni ïnänite äninque, —Guëmanguïönæ ïñonte mönö æbänö cæquënëmö ïmöö, ante wææ angatïï. Mönö edæ waa cæquënëmö ïmompa, ante pönëmïnitawo. Wæætë edæ, Wënæ wënæ cæquënëmö ïmompa, ante pönëmïnitawo. Quëwencædänimpa, ante mönö waa cæquënëmö ïmompa, ante pönëmïnitawo. Wæætë, Wæncædänimpa, ante mönö wæ̈nonguënëmö ïmompa, ante pönëmïnitawo. Mänömaï ante Itota angä ïninque tömënäni edæ pæ wëënedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Adinque tömengä ænguï badinque tömënäni ïnänite æ̈mætæ̈ gomö æ̈mætæ̈ gomö adinque edæ, Mïmö ömædëïnäni incædö, ante wædinque nï cömampoingä ingante, —Pædæ pompobi, angä ëñëninque pædæ pompodinque në cömampodingä incæ ædæmö waa empocä bapocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Adinque edæ Paditeoidi guiquënë wadæ tao godinque Edodeidi tönö bee tëninque, Mönö æbänö cæte Itota ingante wæ̈nömö wænguingää, ante godongämæ̈ pönëninque tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Itota ïñömö tömengä nänö në ëmïñæ̈näni tönö wadæ tao godinque gäwapæ̈ wedeca godäni adinque Gadideabæ quëwënäni nanguï ïnäni tee empote godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ïninque wadäni Oodeabæ, Eedotadëë, Idömeabæ, Oododänö æ̈mæ̈mäa, Tido eyequeï, Tidöö eyequeï mänïñömö quëwente tededinque, Itota mänömaï cæcampa, ante tededäni ëñente wædinque bacoo ïnäni mänïömæ tömäo quëwënäni inte tömengä weca pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Adinque Itota, Goto gongæ̈näni wæcæ wæ, ante pönëninque tömengä mïñæ̈ cöwë në godäni ïnänite, Wipo ænte pömïni ate botö wipodë wäï wocænte owocæboimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wëënë ïñömö, Itota nanguï ïnäni ïnänite gampocä waa badänipa, ante në adïnäni inte tömënäni ñöwo, Mönö gampo cæte waa bacæ̈impa, ante cædinque goto gongæ̈näni wædinque mänömaïnö ante änongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ayæ̈ Itota ingante adinque wënæidi në wentamö ëwocadäni incæ tömengä önöwa gäänë ædæ wææ̈ninque, —Bitö Wængonguï Wëmi ïnömi ïmipa töö, ante Yæ änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ëñente wædinque Itota wæætë, Botö æbodö ïmoo, ante cöwë änämaï inguënë quëwëmïnii, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ayæ̈ änanquidi æidinque Itota, Ïïnäni ïnänite ämo poncædänimpa, ante aa pecä tömengä weca pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pönäni ate tömengä dote ganca ïnäni mänimpodäni ïnänite, Mïnitö botö mïñæ̈ quëwëñömïnite botö wadäni weca da godömo gote apæ̈nemïni ëñencædänimpa, äninque, Botö beyæ̈ në gode ämïni incæmïnimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ayæ̈ pönö apæ̈nebo ëñëninque mïnitö tæ̈ï ëmömïni inte wënæidi ïnänite në ämïni badinque wido cæcæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tömengä dote ganca nänö apænte æ̈näni ïñömö ïïmaï ëmönönänimpa. Tänocä Timönö ëmongä incæte Itota wawo Pegodo pemongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tebedeo wodi wëna Tantiago tönö Wäö näna caya në yedæ tededa ïna adinque Itota, “Detæbo nänömoda baï ïnapa,” ante, Mæ̈mæ̈ beyæ̈, ante Boänede pemongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ayæ̈ Æntade, Pedipe tönö Batodömëë, Mäateo tönö Tömato, Adepeo wengä Tantiago tönö Tadeo ïnänitapa. Ayæ̈, Mönö ömæ ingæ̈impa, ante nanguï cædongä inte wacä Timönö ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ayæ̈ Itota ingante odömonte në godonguingä Codaa Icadiote näni änongä ingacäimpa. Mänimpodäni ïnänite Itota angä në gode änäni bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ayæ̈ ate Itota oncönë pongacäimpa. Pongä adinque bacoo ïnäni wæætë pö pö goto gongæ̈näni adinque wadäni guiquënë, Itotaidi quïodö cænguïnänii, ante wædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ayæ̈, Quïmæ̈. Ocai edæ ömædæcacä pönente baï cæcämæ̈æ̈, ante pönente tededönänimpa. Mänömaïnö ante tededäni ëñëninque Itota guiidënäni guiquënë tömengä ingante bæi ongonte æncæte ante wadæ pönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ayæ̈ në wææ odömönäni guiquënë Eedotadëë quëwente pöninque, “Ïñæmpa wënæ awënë Beedeboo tönö quëwengä inte Itota mäningä tönö cædinque wënæidi ïnänite wido cæcä ïmaingampa,” ante tedewënäni. ");
INSERT INTO aucNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ëñente wædinque Itota aa pecä pönäni ate, “Tatäna mïni änongä ïñömö nämä incæ ædö cæte wido cæquingää, ante ëñencæmïnimpa, ante botö, Inguipoga æbänö cædänii, ante odömömo aedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Awënë odeye nempo quëwënäni ïñömö pïïnäni badinque näëmæ̈ wæætedö wæætë cædäni ïninque awënë odeye nänö ömædempote wæquinque tömënäni nämä ëwente cædänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ayæ̈ adocönë owocabo incæ adoyömö godongämæ̈ quëwënïnäni incæ näëmæ̈ wæætedö wæætë cædäni ïninque tömënäni oncö woquinque näwæ̈ gobaïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ayæ̈ Tatäna nempo quëwënäni ïñömö edæ näëmæ̈ pïinte badinque wæætedö wæætë cædinque tömengä ingante wido cædäni ïninque Tatäna dicæ tömënäni awënë ïmaingää,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ayæ̈, “Në tæ̈ï pïñængä ingante wïï goto wïninque waocä ædö cæte tömengä oncönë guiite mäincoo ö ænguingää. Edæ në ëacä ingante bæi ongonte goto winte ate pö guiite ö æ̈näni baï botö ïñömö wënæ inte në bæi ongonte wido cæbo ïmopa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ayæ̈, “Näwangä apæ̈nebo ëñëedäni, angantapa. Mïni waocabo wënæ wënæ cæmïni incæ wadäni ïnänite godö babæ änewëmïni incæte edæ Wængonguï wæætë tömänö ante pönö ñimpo cæcä beyænque quëwencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wæætë Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante waocä godö babæ ante wënæ wënæ apæ̈necä ïninque tömengä æ̈mæ̈wo wentamö mongængä bagaingä ïninque cöwë wantæpiyæ̈ wentamö mongæncæcäimpa. Mänömaï beyæ̈ Wængonguï ñöwopämo ïñonte ñimpo cædämaï inte ïincayæ̈ pömämo ïñonte adobaï ñimpo cædämaï inte cöwë pancæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Äninque, Mïnitö botö ïmote, Bitö wënæ në wentamö ëwocacä tönö quëwente cæbaïmipa, ämïnitawoo. Ïñæmpa, Wængonguï Tæiyæ̈ Waëmö Önöwoca tönö quëwente cæbo apa änewëmïnii, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ayæ̈ Itota wäänä tömengä biwïidi tönö mänïï näni ponque pö do pöninque yabæque ayæ̈ ongöninque, Guii äñete tae. ");
INSERT INTO aucNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Änäni ëñente äñecæte ante ponte apæ̈necä ëñëninque wadäni Itota weca contate ongönäni Itota ingante wæætë apæ̈nedinque, —Bitö badä bitö biwïidi tönö bitö ïmite ante oncodo ponte yabæque ongönänipa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ante äñönänite, —Botö badä ædänö ïnää ante ämoo, ante pönëmïni. Ayæ̈ botö biwïidi ædänidö ïnänii ante ämoo, ante pönëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Äninque godämæ̈ contate ongönäni ïnänite adinque, —Ïïnäni ïñömö edæ botö badäidi botö biwïidi ïnönäni ïnänipa, ante mänömaïnö ämo abaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Edæ Wængonguï nänö änö baï ëñente æcänö cæte quëwëna mäningä botö biwï ingampa. Mäningä botö biwinque ingampa. Mänïnä botö badä ïnampa, ämo abaïmïnipa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wæætë gäwapæ̈ yæwedeca gote odömoncæ cæyongä nanguï ïnäni tömäo goto ponte ongönäni adinque Itota wipodë go guiite tæ̈ contate wäï wocænte owoyongä tömënäni ayæ̈ gäwapæ̈ yæwedecaque ömaaque ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ïninque tömënäni ïnänite nanguï pönï odömöninque Itota, Wængonguï Awënë nempo quëwëninque æbänö cæquïï, ante ëñencæmïnimpa, ante botö ïmæca quëwënäni näni cæïnö ante odömonte apæ̈nebo ëñëedäni. Äninque ïïmaï ante odömonte apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Apæ̈nebo ëñëedäni. Waocä në quiyadongä ïñömö quiyacæ gocampa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Gote quiyayongä pancamonga taadö ïñömö eyepote wææ̈mompa. Taadö wæænte eyepodïmö öñöñonte ayamöidi pöninque dobæ ade cæ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pancamonga guiquënë dicamontaa onguipoi woyedömö ïñömö eyepote wææmpa. Onguipoi woyedömö öñömö inte pæquïnämaï quingæ̈ tä bocate pædinque æ̈monga æipa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ïninque oguïmento yæyæ̈më guiwadämaï inte cöñe bawadämaï ïñonte nænque tï näwäñö wänä cacadinque edæ guingo icate näñe wæmpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pancamonga guiquënë ömentacodë nänö eyepodïmö ïñömö pæquïnämaï tä bocate gä æiyonte ömentacoo pö incootonque ganta cæca ate näñe wæmpa. Wampo incapa pæquïï. ");
INSERT INTO aucNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waëmonguipoga quiyadïmö guiquënë tä bocate waa pædinque tömëmö nanguï pönï godömenque incapa. Pancawæncaa edæ todëinta ganca, pancawæncaa teitenta ganca, pancawæncaa tiëë ganca mänimpomö incapa. Quiyacä nänö quiyadö ante edæ botö mäninque ante apæ̈nebopa.” ");
INSERT INTO aucNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mänömaï impa, ante ïinque apæ̈nebopa. Ëamonca ongonte edæ ëñëedäni, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ayæ̈ ate nanguï ongönïnäni dæ godäni ate Itotaidi adodänique ongöñönäni edæ, Dote, ante näni gocabo tönö wadäni tömengä mïñæ̈ godäni tönö tömengä weca ponte änänitapa. Itota ëñëmi. Bitö mänïnö ante apæ̈nedinque æbänö ante odömoncæte ante apæ̈nebitawo. ");
INSERT INTO aucNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Äñönänite, “Wængonguï Awënë Odeye ïñömö æbänö awëmö cæcää, ante mïni waocabo wëënëñedë ëñënämaï ïnïnö incæte ñöwo edonque pönö apæ̈nebo ate mïnitö adomïnique në ëñëmïni bamïnipa. Gobæ ongönäni ïnänite apæ̈nedinque, Inguipoga quëwënäni näni cæï baï impa, ante botö pancaa ante odömonte apæ̈nebo ëñënänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dodäni Wængonguï beyæ̈ apæ̈nedinque ïïmaïnö ante yewæ̈mongadänimpa. Wængonguï nänö në ñimpo cæquënënäni ïnämaï ïnäni inte tömënäni ïñömö awincaque adinque wïï ædæmö adäni inte önömoncaque ëñëninque ædæmö ëñënämaï ïnäni inte edæ ocæ̈ ëmænte pönämaï incædänimpa, ante yewæ̈mongadänimpa. Mänömaï ïinque bacæ̈impa, ante beyænque botö tömënäni ïnänite wïï edonque apæ̈nebopa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Itota ayæ̈ tömënäni ïnänite godömenque apæ̈necantapa. “Botö mänïnö inguipoga näni cæïnö ante do odömonte apæ̈nebo ëñëninque mïnitö ëñënämaï ïmïnitawo. Ïninque ñöwo godömenque odömonte apæ̈nebo incæte mïnitö ædö cæte godömenque ëñenguïmïnii.” ");
INSERT INTO aucNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Ïïmaï impa. Në apæ̈necä ïñömö tömëmö quiyate baï cædinque Wængonguï tömengä nänö apæ̈nedö ante apæ̈necampa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pancadäniya guiquënë taadö eyepote wææ̈nïmö baï ïnäni inte Wængonguï nänö apæ̈nedö ante ëñëninque mïmöno pönënämaï ïñönänite ayamö ade cængä baï Tatäna incæ ponte ö ængampa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wadäni guiquënë dicamontaa woyedömö ïñömö eyepote wææ̈nïmö baï ïnäni inte tömënäni Wængonguï nänö apæ̈nedö ëñëninque quingæ̈ Ao ante watapæ̈ todänipa.” ");
INSERT INTO aucNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","“Ayæ̈ ate adodäni wantæ ïñö quëwëñönänite wadäni Wængonguï nänö apæ̈nedö beyæ̈ pïïnäni wædänipa. Ayæ̈ wadäni wënæ wënæ cæcæte ante togænte pänäni wædänipa. Ïninque oguïmento yæyæ̈më guiwadämaï näñe wænte baï ïnäni inte tömënäni guïñente wædinque ëmö cæte godänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ayæ̈ wadäni guiquënë ömentacodë eyepote wææ̈nïmö baï ïnïnäni inte Wængonguï nänö apæ̈nedö ëñëñönäni, ");
INSERT INTO aucNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","inguipoga quëwente quïëmë beyænque mönö wæpämo pompa. Ayæ̈, Mäincoo beyænque toquïmo, ante näni oda cæte wæwëmämo pöninque wacoo wacoo näni æ̈ïnënö pöninque edæ ömentacoo ñancate cæ baï cæyonte Wængonguï nänö apæ̈nedïnö incæ incadämaï baï bapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Onguipoga wainguipoga quiyadïmö baï ïnäni guiquënë tömënäni Wængonguï apæ̈nedïnö ëñente Ao äninque wede pönënäni inte tömëwæ̈ incate baï Wængonguï beyæ̈ nanguï cædänipa. Pancadäniya todëinta ganca incate baï nanguï cæyönäni, pancadäniya godömenque teitenta ganca incate baï cædänipa. Pancadäniya nanguï pönï tiëë ganca incate baï cædänipa,” ante Itota apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ayæ̈ tömënäni ïnänite Itota ïïmaï odömöninque apæ̈necantapa. “Waomïni gongapæncade tï wodönodinque dicæ owætadë boo cæcamïniyaa. Dicæ möïmoga æ̈nömengadæ̈ ïnö mäo concæmïniyaa. Wæætë edæ wæ̈nömënæcapaa concæmïni ñäö bæco amïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Quïnö ante wë wodonte baï ï ïñömö mänïnö ante ïincayæ̈ ate tadonte edonque ate baï ëñenguinque ñöwo wë wodonte impa. Quïnö bee ocate baï ï ïñömö mänïnö ïincayæ̈ ate wi æncate edonque aquinque ñöwo bee ocate impa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ëamonca ongonte ëñenguënë cæmïnii,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ayæ̈ tömënäni ïnänite godömenque apæ̈nedinque Itota, “Önömonca ëñëninque ëñenguënë cæmïnii. Mïnitö mïni tee mante godoncade incæ adocadeca tee mäninque Wængonguï mïnitö ïmïnite adodö pönöninque godömenque ayæ̈ pönongä æncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Edæ në ëacä ingante godönäni ængä baï në ëñengä ingante godö apæ̈nebo ëñente entawëninque tömengä godömenque ëñente bacæcäimpa. Në ëadämaï ingä guiquënë tömengä wædænque pönï nänö mäincoo ïñonte mänincoo tömancoo ö æ̈näni wæcä baï në ëñënämaï ingä adobaï tömengä wædænque pönï nänö ëñente entawënö ïñonte ö ænte baï cæbo dæ ba ate wæcæcäimpa.” Mänömaïnö ante Itota tömengä ëmïñæ̈näni ïnänite odömonte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ñöwo ïñömö öömaque ongönäni ïnänite godömenque odömöninque Itota ïïmaï ante apæ̈negacäimpa. “Waocä quiyacä ate awëmö pæ baï inte Wængonguï Awënë Odeye pönö cæcä ate tömengä nempo në quëwënäni awëmö yebæ̈ninque bacoo pönï badänipa. Apæ̈nebo ëñëedäni. Waocä gönea quiyate ate, ");
INSERT INTO aucNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","woyowotæ̈ mö ñöninque baänæ ñäni ömæ̈möñongä ïïmö ïñö ïïmö ïñö tömëmö nänö quiyadïmö incæ awëmö tä bocate pæpa. Waocä ïñömö, Æbämë cæte tä bocate pæpa, ante acantawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Edæ onguipo beyænque tömengä nänö quiyadïmö incæ tä bocate pædinque æ̈monga æi cænguïmæ baate ate ayæ̈ cænguï yagapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yaga adinque, Amïñate cænguï bapa, ante edæ pete ængampa,” ante odömonte Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ayæ̈ godömenque apæ̈nedinque Itota, “Wængonguï Awënë Odeye nempo æbänö quëwënäni, ante mönö quïnö odömonte ate ëñenguïï. Edæ, Inguipoga quïnö pæte yebænte baï ï adinque, Mänïnäni adobaï yebæ̈nänipa, ante ëñengæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ïïmaï impa. Möotatamö mïni ænte quiyamö guidïmö pönï ï baï wamö mïni quiyamö adomonque incæ adobaï guiyämö pönï ï ïñömö edæ dæ ampa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Incæte möotatamö ïñömö tä bocate pædinque möotatawæ̈ edæ ocäñequi doyæ̈ pæwæ̈ bapa. Wïï tömää ocäñequi mïni quiyadïwæ̈ baï edæ ocäa ïnämaï inte möotatawæ̈ ïñömö edæ ñæ̈næ̈ awæ̈ impa. Adinque tömëwæ̈ ibæ̈ñömö ayamöidi gänë ïñömö ponte ongönänipa. Möotatamö guidïmö incæ mänömaï pæ baï Wængonguï Awënë nempo quëwënäni ïñömö wædænque ïnïnäni incæ nanguï yebænguïnäni ïnänipa,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ayæ̈ Itota, Wængonguï Awënë nempo quëwëninque æbänö cæquïï, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante godömenque nanguï pönï odömöninque godongämæ̈ ongönäni näni ëñenganca apæ̈nedinque idæwaa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mänïnonque baï odömonte apæ̈nedinque tömënäni ïnänite cöwë godömenque apæ̈nedämaï ïnongäimpa. Incæte tömengä mïñæ̈ në godäni adodänique ongöñönänite Itota edonque pönï, Mänömaï impa, ante tömänö ante apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mänïönæ gäwadecæ̈ bayonte Itota tömengä ëmïñæ̈näni ïnänite, —Gäwapæ̈ æ̈mæ̈mäa taocæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Äninque ömaa ongönäni ïnänite ëmö cæte taocæ cædinque tömengä nänö apæ̈nedimpodë adopodë ayæ̈ contayongante mantadäni taocantapa. Adinque wadäni wapodë godongämæ̈ taodänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tao wogaa goyönäni woboyæ̈ ïñontobæ̈ nanguï pönï pæ̈mæ̈ninque æpæ̈ mængonta mængonta pöninque gao gao wipodë änëñö, ");
INSERT INTO aucNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Itota yæmïñæmpo bee podoncate mö ñongantapa. Ömæ̈moncæcäimpa, ante tao cædinque, —Awënë, bete wæncæ cæmompa mö ñömii. ");
INSERT INTO aucNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Änäni ëñëninque ñäni ömæ̈monte ængæ̈ gantidinque, —Woboyæ̈, pæ̈mæ̈nämaï ïmäwe. Gäwapæ̈ incæ cædämaï næ̈ gongæ̈mäwe. Ante äñongä woboyæ̈ pæ̈mæ̈nämaï ïñö gäwapæ̈ incæ næ̈ gongæ̈ninque ñancæ ñancæ gongæ̈mæ̈nimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ayæ̈ tömënäni ïnänite, —Mïni pönëegade, quïmæ̈ guïñëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Äñongä tömënäni ancai guïñëninque nämäneque tededinque, —Æcämë inte angä ëñente woboyæ̈ incæ æpæ̈ incæ gongæmpa, ante guïñente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ïninque Itotaidi mänïï æ̈mæ̈mäa tao godinque Guedatabæ pö ti wææ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Itota mänömaï pöninque gäwapæ̈ tao ti wæængä adinque onguïñængä wënæ wentamö ëwocacä tönö në quëwengä ïnongä inte edæ waodänido quëwente tao bee tengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tömengä waodänido cöwë në quëwengä ingante ædö cæte goto winguïnänii. Daagömenca incæ tæ̈æ̈mö impa goto winguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ëno pönö goto wïmænte wææ̈ ëno pönö goto wïwate bacæcäimpa, ante ancaa cæyönäni tömengä daagömë wangö ñæ̈ wangö ñæ̈ cædongäimpa. Æcämenque incæ tæ̈ï pïñængä inte tömengä ingante ænguingää. Edæ dæ änongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Itædë incæ woyowotæ̈ incæ tömengä änanquidi æite wææ̈ waodänido pö änanquidi æite wææ̈ ocæ̈ ëmænte pö pö cæte Yæ yæ äninque dicaca nämä incæ äwæ̈nonga äwæ̈nonga cæte wencata baï ëñate quëwënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ïninque Itota go dibæ pongä adinque tömengä quingæ̈ pogodo godinque Itota weca ædæ wææ̈ninque, ");
INSERT INTO aucNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ogæ̈ tededinque, —Itota ëñëmi, bitö në Æibæ Quëwengä Wængonguï Wëmi ïnömi incæ quïmæ̈ botö weca pöwëë. Edæ, Ämogate wæcæcäimpa, ante botö ïmote cædämaï ïmäwe, ante nanguï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Edæ tömengä tæcæ pö bee tëñongante wënæ ingante Itota ïïmaï ante äningä ïnongäimpa. —Wentamö në wentamö ëwocabi inte ämo ëñëe. Bitö waocä baonga guiidëmi inte ñöwo tao gobäwe, ante Itota täno angä ëñente wædingä inte wënæ ñöwo, Cædämaï ïmäwe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ïninque Itota, —Bitö æmömidö ïmii. Äñongante, —Tontadoidi tæiyæ̈näni adinque, Deguiönö, änänipa. Mönitö adobaï tæiyæ̈ pönï ïmönipa, ante botö ëmöwo adobaï Deguiönö ëmömopa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ante apæ̈nedinque ayæ̈, Mönitö ïmönite wabæca wido cædämaï incæbiimpa, ante ancaa angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mänïñömö odæ̈ wængänäidi nanguï ïnäni eyequeï änanquidi a cængönäni adinque, ");
INSERT INTO aucNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","wënæidi incæ Itota ingante, —Ïï odæ̈ wængänäidi weca ämi godinque tömënäni baönë guiite quëwëmönie. ");
INSERT INTO aucNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ante tedete äñönänite Itota Ao angä ëñente wædinque wënæidi wentamö ëwocadäni ïñömö tao gote odæ̈ wængänäidi baönë go guiidänitapa. Ïninque odæncato dote mïido ganca ïnäni incæ ontacamö cægöninque tömäne to wæi gäwapæ̈no pogodo wæi guiite becadote capo wæ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Becadote wæ̈näni adinque odæ̈ wængänäidi në aadïnäni guiquënë pogodo wodii wïnonte tömënäni quëwëñömö mäo bee tente apæ̈nedinque idömæ mäo gode ä gode ä cæte, Itota mänömaï cæcä wæmönipa, ante apæ̈nedäni ëñëninque wadäni, Æbänö cæcäï, ante acæte ante pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Itota weca ponte ayönäni wënæidi tönö në quëwëningä incæ ñöwo önonganque bate weocoo ëñacä inte tæ̈ contate ongongä adinque tömënäni, Mönö Deguiönö ënempocä äningä ingampa, ante guïñente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Në adïnäni guiquënë ñöwo pönäni ïnänite apæ̈nedinque, Wënæ ënempocä ïningä ingante Itota æbänö cæcäï, odæ̈ wængänäidi ïnänite Itota æbänö cæcäï, ante apæ̈nedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ëñëninque tömënäni wæætë Itota ingante, Mönitö weca quëwënämaï gobäwe, änäni. ");
INSERT INTO aucNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ëñente wædinque wipodë go guiicæ cæyongante wënæidi inte quëwëningä ïñömö, Bitö mïñæ̈ mäobi goboe. ");
INSERT INTO aucNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Äñongante Baa äninque Itota, —Tömëmi oncönë gote, Wængonguï Awënë wënæidi ïnänite wido cæcä önömoque baboï amïnipa, ante bitö guiidënäni ïnänite mäo apæ̈nebi ëñencædänimpa. Ayæ̈, Botö wæwente quëwëñömote tömengä guëa wæwente baï pönente pönö cæcä waa batabopa, ante apæ̈nebi ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Itota angä ëñëninque wadæ godinque tömengä Decapodibæ mäo, Itota waa cæcä waa batabopa, ante apæ̈necä. Ëñente wædinque tömänäni, Æ æbänö cæte mänömaï waa bacäï, ante guïñente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mänïï wipodë guiite tömengä ïmæ̈mäa ta ti wæængä ate nanguï ïnäni acæte ante pö goto goto godämæ̈ gongæ̈nänitapa. Itota ayæ̈ gäwapæ̈ wedeca ongongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ayæ̈ ongöñongä wacä oodeoidi odömöincö awënë ïnongä inte tömengä ëmöwo Gaido ïñömö Itota ingante adinque pöninque tömengä önöwaca gäänë ædæ wææ̈ninque, ");
INSERT INTO aucNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tömengä ingante, —Botö wëñængä baquecä ïñömö edæ dobæ wæncæ cæcampa cæbii. Bitö ponte tömengä ingante gampobi waa bate quëwencæcäimpa, ante nanguï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Gaido mänömaï angä ëñëninque Itota wæætë tömengä mïñæ̈ gocantapa. Idömæ goyongante nanguï ïnäni bee tente goto goto pönäni. ");
INSERT INTO aucNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ïninque godämæ̈ ongönäni tönö onquiyængä adocanque wantæpiyæ̈ dote wadepo ïñonte wepæ̈ wantæ bidämaï cöwë wææ̈ wæwëningä inte adobaï ponte tömënäni mïñæ̈ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doyedë ïñömö onquiyængä waa bawënencæte ante cædinque tömengä quincoo tömancoo eyepote pædæ godongä æ̈ninque dotodoidi tæiyæ̈näni cædäni caate wæcä incæte tömengä waa bawënënämaï inte godömenque wënæ wënæ bate wædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mänömaï quëwente wæyongante wadäni, Itota mänömaï cæcampa, ante tededäni ëñente wædinque tömengä ñöwo goto pönäni tönö pöninque Itota önöñabæca ïnö ponte weocooque godö gampocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Edæ, “Tömengä weocooque gampote waa bawënëmote,” ante pönëningä inte, ");
INSERT INTO aucNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tömengä godö gampoyongä wepæ̈ nänö gowete wæwënïmæ̈ wantæ bi ate tömengä, Wantæ biwënëmopa, ante önöwënenque pönengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Itota ïñömö, Æ, tæ̈ï pïñænte botö entawënö incæ edæ wacä beyæ̈ cæquinque do gotimpa, ante wæwënente awædö, äninque goto gongæ̈näni tæcæguedë næ̈ gongæ̈ninque dadi ëmænte cöwä adinque, —Botö weocoo æcänö pönö gampodaï, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Äñongante tömengä nänö në ëmïñæ̈näni guiquënë, —Ënodäni pönänipa aquïmii. Æcänö gampodaï, ante ämii. ");
INSERT INTO aucNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wææ änäni incæte tömengä, Æcänö botö ïmote wede pönëninque gampodaï, ante godömenque tömäo cöwä cöwä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ayongante onquiyængä guiquënë, Wampo bawënëmopa, ante pönëningä inte nanguï guïñëninque do do wäate wædinque Itota weca ponte ædæ wææncate tömänö ante töingä apæ̈necä ëñengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Apæ̈necä ëñëninque Itota wæætë, —Onquiyæ̈mi ëñëmi. Bitö wede pönënö beyæ̈ edæ wampo bawënëmipa. Ñöwo edæ wædämaï inte waa godinque nö bawënente quëwëe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ante tæcæ apæ̈neyongä oodeoidi odömöincö awënë Gaido oncönë quëwënäni mänïñedë pöninque edæ Gaido ingante apæ̈nedänitapa. —Bitö wengä ïñömö ñöwo æ̈mæ̈wo wængampa cæbii. Ñöwo Awënë në Odömongä ingante quïnante godömenque anguïï. ");
INSERT INTO aucNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ante ponte äñönänite Itota tömënäni æbänö tededäni ante ëñënämaï inte baï cædinque oodeoidi odömöincö awënë Gaido ingante apæ̈nedinque, —Guïñënämaï inte önonque wede pönëe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ayæ̈ godongämæ̈ ongönäni ïnänite, Ee ongöedäni, äninque Pegodo ingante, Tantiago tönö Wäö näna caya ïnate mänimpodänique ïnänite ænte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tömënäni tönö godinque Itota tömënäni odömöincö awënë oncönë ponte ayongä mänincönë waodäni nanguï cægöninque edæ Ca ca wædinque ogæ̈ tedete Yæ yæ änäni acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Adinque Itota oncönë guiidinque, —Quïmæ̈ ogæ̈ tedete cægöwëmïnii. Quïmæ̈ Ca ca wæmïnii. Ïñæmpa ïñömö wëñængä wodi edæ wïï æ̈mæ̈wo wængantapa. Edæ mö ñongampa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ante apæ̈necä ëñëninque tömënäni, Angantedö amïni, ante tömengä ingante badete todänitapa. Itota wæætë edæ, Gä goedäni, angä oncodo tao godänitapa. Ïninque wëñængä wæmpo tönö wäänä ïnate Itota tömengä mïñæ̈ në pönïnäni tönö mänimpodänique ïnänite ænte manguicä wëñængä wodi nänö öñoncönë wäänë guiidänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wëñængä wodi ingante Itota pædæ wææmpo bæi ongonte töö æ̈mæ̈ninque, —Tadita cömi, äninque mönö tededö, “Wëñæ̈mi onquiyæ̈mi ængæ̈ gantibi,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Angä ëñëninque wëñængä baquecä dote wadepo ëñadingä inte dobæ ængæ̈ gantite dao dao gocä. Adinque tömänäni ancai guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Itota wæætë, Botö æbänö cæboo, ante mïnitö mäo apæ̈nedämaï ïedäni. Äninque edæ wëñængä beyæ̈ cænguï angä godöna cængantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Itota wadæ godinque tömengä mïñæ̈ në godäni tönö tömengä nänö pægaïñömö pongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ayæ̈, Guëmanguïönæ impa, äninque Itota tömënäni odömöincönë go guiidinque tæcæ odömonte apæ̈necä ëñëninque mänïñömö ongönäni nanguï ïnäni guïñente wædinque näni caboque tededänitapa. —Ïingä ïñæmpa ædö cæte nanguï ëñente apæ̈necää. Æbänö cæquïï, ante æcänö tömengä ingante godö odömongä adinque tömengä mänömaï bamönengæ̈ cæcää, ante ëñencæte ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ïingä ïñæmpa mönö awæmpa në tïmöwengä ïmaingä inte bamönengæ̈ mänömaï cæcampa, ante awædö. Edæ Mäadiya wengä ïnongä inte tömengä ïñömö önönänique mëmö ingampa. Tantiago tönö Ootee, Codaa tönö Timönö tömënäni mëmö ïnämaï ingantawogaa. Tömengä biwinqueidi incæ mönitö tönö wïï ongönäni atamöö. Ante pönente wædinque tömengä beyæ̈ ante pïinte badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ïninque pïinte badäni adinque Itota wæætë angantapa. —Ïñæmpa, Wængonguï beyæ̈ në apæ̈necä inte tömämæ gote apæ̈neyongante tömengä ingante waa adänipa. Wæætë tömengä nänö pægaïñömö ponte apæ̈neyongante mänïñömonque wæætë wïwa adänipa. Tömengä nänö guiidënäni tönö tömengä oncönë owodäni tönö mänimpodänique tömengä ingante wïwa adänipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Äninque Itota adopoque adopoque gampocä waa badänitapa. Mänömaï wædænque cædinque tömengä, Ædö cæte gomonga cæquïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Äninque, Mïni pönëegade. Quïnante pönënämaï ïmïni, ante wægacäimpa. Ayæ̈ wayömö näni quëwëñömö wayömö näni quëwëñömö mäo odömöninque Itota apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ayæ̈, Dote ïnäni, näni änönäni ïnänite aa pecä pönäni ïninque, Ñöwo mïnitö æ̈mæ̈nö mëmïnaa æ̈mæ̈nö mëmïnaa goyömïnite botö pönö cæbo ate mïnitö awënëidi baï badinque edæ wënæidi wentamö ëwocadäni ïnänite në ämïni incæmïnimpa, ante da godongä godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ayæ̈, Ïïmaï cæedäni, angantapa. Mïnitö taadö godinque ongontoque mïni næ̈æntoque næ̈ænte goedäni. Cænguï incæ mäincoo da wenguincade incæ æ̈nämaï inte godinque tiguitamö önoncamoncadedë da wënämaï inte ömæpomïni goedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Awæncata mïni ëwataque ëwate weocoo mïni ëñacooque ëñadinque wacoo æ̈nämaï goedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ayæ̈ godömenque äninque Itota, —Godinque æcönënö täno go guiimïni owodinque mïnitö wayömö mïni go quëwenguinganca mänincönenque go guii go guii cædinque quëwëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Æyömömë goyömïnite wadäni, Pöedäni, änämaï inte mïnitö apæ̈nedö ante wïï ëñënäni wædinque mïnitö wæætë tömënäni ïnänite ëmö cæte ïïmaïnö ante goedäni. Mïnitö ïñæmpa, Pöedäni, änämaï ïmïni adinque mönitö gomöni tamëñedäni, ante odömoncæte ante mïnitö önöwa wadæ wadæ cæwadinque wadæ goedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Äninque Itota tömengä ëmïñæ̈näni ïnänite, Ñöwo goedäni, äninque da godongä godänitapa. Godinque tömënäni wabæca quëwënäni ïnänite mäo, Mïnitö wënæ wënæ mïni cædïnö ante wæwente pönëninque ñimpo cæedäni, ante mäo apæ̈nedäni ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wënæidi nanguï ïnäni ïnänite wido cædänitapa. Ayæ̈ waodäni nanguï ïnäni wënæ wënæ inte wædäni ïñönänite oguinguipæ̈ öni öni paadäni ate waa bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Itota ëmöwo ante apæ̈nedäni ëñëninque tömämæ quëwënäni do ëñëninque gode ä gode ä cæte tedeyönäni Edode pancabaa awënë odeye incæ, Itota æbänö cæcää, ante ëñengacäimpa. Ïninque tömengä ïñömö, —Æpæ̈në në guidönongä Wäö wodi dobæ wænte ñäni ömæ̈möningä inte ïingä Itota ïñömö ïmaingampa. Mänïnö beyænque tömengä tæ̈ï pïñænte entawënongä inte në nanguï cæcä ingampa, ante pönëmopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ayæ̈ wadäni, —Ediya wodi ïmaingampa. Ante tedeyönäni wadäni wæætë, —Wængonguï beyæ̈ në apæ̈negaïnäni baï tömengä adocä ïmaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ante tededäni ëñëninque Edode ïñömö, —Botö në wangö tamencadongä Wäö wodi adocä incæ edæ ñäni ömæ̈monte a ongömaingampa, ante wædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wäö wodi ïñömö ïïmaï wængacäimpa. Do ïñedë awënë Edode nänö tönïñacä Pedipe ayæ̈ mïingä ïñongä Pedipe manguïwëningä Ædodiya ingante Edode ïñömö, Botö nänöogængä bacæcäimpa, ante ö ænte mongä. Ïninque tömengä adocä Wäö wodi ingante bæi ongonte goti winte tee mönedongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Edæ Wäö ïñömö nänö caate wænguinque Edode ingante ïïmaïnö ante do wææ äningä ïnongäimpa. “Edode ëñëmi, Wængonguï nänö angaïnö baï ëñënämaï inte bitö tönïñacä nänöogængä ingante edæ manguïwëmipa töö.” ");
INSERT INTO aucNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ante wææ angä ëñëninque Ædodiya guiquënë Wäö nänö änïnö beyæ̈ cöwë pïïninque tömengä ingante wæ̈noncæ cæcä incæte ædö cæte tömengä ingante wæ̈nonguingää. ");
INSERT INTO aucNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Edæ, Wäö tæiyæ̈ waëmö onguïñængä inte në nö cæcä ingampa, ante do ëñënongä inte Edode ïñömö Wäö ingante edæ guïñente wædongä ïnongäimpa. Ïninque tömengä ingante edæ wææ gompodongäimpa. Ayæ̈ Wäö apæ̈necä ëñëninque Edode, Angä ëñente æbänö cæquïmoo, ante nanguï wæcä incæte tömengä ingante ëñëninque todongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ïincayæ̈ ate Edode nänö ëñagaïönæ ïinque bayonte Ædodiya, Æönædö wæ̈nonguïmoo, ante nänö änïönæ eyepæ̈ batimpa. Edode ïñömö, Mänïönæ baï ëñagaboimpa, ante æ̈æ̈mæ̈ cædinque wente ængä ate tömengä mïñæ̈ awënëidi tönö tontadoidi awënëidi tönö Gadideabæ quëwënäni awënëidi tönö tömänäni becæ pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ponte bete cængöñönäni Ædodiya wengä baquecä incæ tæcæguedë pö gongænte tode pete äwacä adinque awënë odeye Edode tönö godongämæ̈ ongönäni nanguï todönänimpa. Ïninque baquecä ingante Edode änongäimpa, —Waa pönï bitö tode pete äwadï beyænque bitö quïëmë ante æ̈ïnente ämi ate botö ëñente da pönömo æ̈e. ");
INSERT INTO aucNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Äninque ayæ̈ godömenque äninque, Wængonguï ëñëñongä nöingä ämopa, änongäimpa. Quïëmë impa bitö æ̈ïnëmi botö tömää edæ do godömo æncæbiimpa. Edæ bitö æ̈ïnente ämi ïninque botö awënë odeyebo ïnömo inte botö ënempodö incæ edæ tæcæ pä cæte pönömo æ̈maïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Angä ëñëninque taodinque, —Badä ëñëmi, quïnö anguïmoo. Äñongante wäänä edæ do, —Botö ïïmaï ämopa, änantapa. Wäö æpæ̈në në guidongä ocabo wangö tomencate pædæ pönömi æ̈moe, ancæbiimpa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Änä ëñëninque awënë weca do ponte guiidinque baquecä wæætë, —Wäö æpæ̈në në guidongä ingante wangö tomencate tömengä ocabo ïnï coyomënætaca cö cæte do pönömi æ̈moe. ");
INSERT INTO aucNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Angä ëñente wædinque awënë odeye ïñömö, Æ ëñente awædö. Quïnö ñöwo cæquïmoo, ante nanguï wædongäimpa. Incæte tömengä, Botö ïñæmpa godongämæ̈ becönäni ëñëñönänite, Wængonguï ayongä cöwë godoncæboimpa, ante në änïmo inte edæ ædö cæte ñöwo Baa anguïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ante pönente wædinque tömengä nänö änïnö, Cöwë godonguï impa, ante pönëninque Edode wæætë në wæ̈nongä ingante, Bitö godinque wangö tomencate ænte mämömi ængäe. ");
INSERT INTO aucNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Angä ëñëninque në wæ̈nongä wæætë tee mönincönë gote guiidinque Wäö ingante wangö tomencacä wængantapa. Ayæ̈ Wäö ocamö ïnï coyomënætaca cö cædinque baquecä weca ænte mämö pædæ pönongä æ̈ninque baquecä wæætë wäänä ïnante godongä æ̈nönäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mänömaï wængäimpa, ante gode änäni ëñente wædinque Wäö wodi tömengä mïñæ̈ në godïnäni incæ pöninque tömengä baö ïnï ænte mäo daga wengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mänïï Itota në nänö da godönïnäni ïñömö ocæ̈ ëmænte ponte godämæ̈ gongænte, Mänömaï cætamönipa. Mänömaï odömonte apæ̈nemöni ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ante apæ̈nedänitapa. Ayæ̈, wadäni nanguï owentædæ pænta owentædæ pænta wææ cægönäni adinque tömënäni ædö cæte cæquïnänii. Cænguï incæ ædö cæte cænguïnänii. Adinque Itota, —Mïnitö adomïnique botö mïñæ̈ önömæca gote wædænque guëmäedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Angä Ao ante tömënäni adodänique Itota mïñæ̈ wadæ godinque önömæca gocæte ante wipodë wææ̈ contate wogaa godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Goyönänite wadäni guiquënë, Itotaidi incæ godänipa, ante adinque wacönë ta wacönë ta godinque tæiyæ̈näni tee ta tee ta go ömaaque oo pænta pogodo gote do edæ pöninque a ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ayæ̈ wipodë wogaa mämö tæcæ æ̈æ̈noncadoyönäni Itota ïñömö ti wæænte ayongä nanguï ïnäni do ponte a ongönäni acantapa. Tömënäni në aacä dæ äñongä obegaidi quëwenguïnämaï ïnäni inte adodänique ongönäni baï ïnäni inte wæwënänipa, ante pönente tömengä tömënäni tönö godongämæ̈ wæwente baï pönengantapa. Ïninque nanguï odömonte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ayæ̈ gäwadecæ̈ bayö Itota mïñæ̈ në godäni tömengä weca ponte äninque, —Ñöwo wëmö bacæ cæpa cæbii, änänitapa. Ayæ̈, Önömæca incæ cænguï dæ ampa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ïïnäni ïnänite ämi idömæ owodäni weca godinque ayæ̈ nanguï ïnäni näni quëwëñömö godinque cænguï godonte cænguïnänie. ");
INSERT INTO aucNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Äñönänite Itota wæætë, Mïnitö wæætë godömïni cæncædänimpa, ämopa. Äñongante, —Æ, ënodäni ïnäniyaa. Ïñæmpa ocho apäicä cæte beyæ̈ paga æ̈inta æ̈ninque mänimpota päö ante godonte æ̈ninque edæ wïï eyepæ̈ ïmaimpa. Mönitö wadæ gote mänimpota beyæ̈ päö godonte æ̈ninque ïñömö godongämæ̈ ongönäni ïnänite godömöni cænguïnänii, ämitawoo. ");
INSERT INTO aucNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ante wæyönänite Itota, —Päö æpodö næ̈æ̈mïnii. Acæ goedäni. Angä ate pöninque, —Päö önompo æ̈mæmpoque gæyæ mëa pönï mæ̈ ongompa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ante apæ̈nedäni ëñëninque Itota godongämæ̈ mæ̈ ongönäni ïnänite, Ñöwo mïni cabo mïni cabo gaguïmäa tæ̈ contaedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Angä ëñëninque pancadäniya tiëë ganca näni cabo nänënë pancadäniya tincoenta ganca näni cabo nänënë tömänäni näni cabo näni cabo tæ̈ contadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tæ̈ contadäni ate päö önompo æ̈mæmpoque gæyæ mëa æ̈ninque öönædë ïnö æ̈mö adinque, Wængonguï, bitö waa pönömi ænte cæ̈mönipa, ante apæ̈nedinque päö pä pä æ̈ cædinque tömengä, Nanguï ïnäni cænguï ante ænte mäo cö cæedäni, ante tömengä mïñæ̈ në godäni ïnänite pædæ pönongä æ̈ninque mäo cö cædänitapa. Ayæ̈ gæyæ mëa ïñonte adobaï æ̈ninque tömengä tömänäni ïnänite di mæ̈ñæ̈ di mæ̈ñæ̈ cæcä æ̈ninque cæ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Æ̈ninque tömänäni tömo pönï cæ̈näni, ");
INSERT INTO aucNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ate edæ tömengä ëmïñæ̈näni päö tönö gæyæ näni ao mænte ñönönï ee öñoncoo pædæ wææmpo ö æ̈ da da wente æ̈ninque otodë önompo tipæmpoga go mentodëa cænguï eyede da wënäni contagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Në cæ̈näni ïñömö onguïñæ̈näni edæ tinco mïido ganca mänimpodäni nanguï ïnäni näni wencabo cængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Itota ayæ̈ do tömengä nänö në ëmïñæ̈näni ïnänite, Ægodöedäni. Mïnitö täno wipodë guiite æ̈mæ̈ wedeca Betaida tao goyömïni botö wæætë wadäni në cæ̈nïnäni ïnänite ämo godäni ate pömoedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Angä Ao ante tao goyönäni tömengä wadäni ïnänite wæætë angä godäni ate adocanque ongonte Wængonguï ingante apæ̈necæte ante änanquidi æicantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ayæ̈ wëmö bayö tömënäni tæcætibæ wogaa goyönäni tömengä adocanque ömaa ongonte ayongä, ");
INSERT INTO aucNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","tömengä nänö ëmïñæ̈näni wiyate taocæ cæyönäni edæ woboyæ̈ nanguï pæ̈mænte pönömenque ænte pö ædö cæte goquïnänii. Adinque tawadiya nänö peyedë edæ tæcæpæ̈ pönï ï gäwapæ̈ wæ̈nömënæcapæ̈ ïnö edæ Itota ïñömö æpæ̈no yædopæ̈ dao dao obo ponte wodo pænta gocæ cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yædopæ̈ edæ gocä gomö adinque tömënäni Yæ äninque, Waocä wænte babæ̈ningä wabänö cægongä, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Edæ tömengä ingante adinque tömänäni ancai guïñente wædänitapa. Tömengä ïñömö tömënäni ïnänite do apæ̈nedinque, —Ee piyæ̈në cæte guïñënämaï ïedäni. Botö ïmo apa guïñëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Äninque wipodë pö guiicä ate woboyæ̈ incæ næ̈ gongæ̈ pæ̈mæ̈nämaï batapa. Ba adinque tömënäni godömenque guïñëninque, Quïnante mänömaï cæ, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Edæ, Itota æbänö ïñontobæ̈ päö nanguï pönï pönö badongä, ante në adïnäni incæte tömënäni mïmö ömædë ïnäni inte baï wïï pönente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ayæ̈ æ̈mæ̈mäa taodinque tömënäni Guënetadetebæ ti wææ̈ninque wipo ñä cæmencadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mänömaï ti wæænte ñä cæmencayönäni mänïñömö quëwënäni guiquënë, Tömengä Itota ingampa, ante do adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ante adinque mänïömæ tömäo pogodo godinque wënæ wënæ wæwënäni ïnänite ñönæmpado ñö cædinque, Itota æyömönö ongongää, ante ëñëninque tömëñömö tömengä nänö ongöñömö do ænte pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ayæ̈ wadäni näni nanguï pönï quëwëñömö incæ wædænque näni quëwëñömö incæ idömæ incæ, Itota ædömë gocää, ante adinque wadäni wæncæ cædäni ïnänite mänïñömö ænte mämö taadö wedeca ñö cædäni öñönänitapa. Ïïnäni wæætë tömengä ingante, Bitö weocoo yæwedecooque ämi gampote waa bamönie. Ante wæyönänite, Ao angä ëñente në gampo gampo cædänique tömänäni waa ïnäni bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ayæ̈ Paditeoidi tönö në wææ odömönäni tönö pancadäniya Eedotadëë quëwente mänïñedë Itota weca ponte godongämæ̈ gongænte ayönäni, ");
INSERT INTO aucNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Itota mïñæ̈ në godäni pancadäniya mempodämaï inte wentamö empote cæ̈näni adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Edæ dodäni, Önompo ædæmö mempoïnänique cæncædänimpa, ante näni wææ angaïnö ante Ao äninque, Bapogabo cæte wæcæ wæ, ante Paditeoidi tönö oodeoidi tömänäni ancaa mempote ate cæ̈nönäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ayæ̈, Ædæmö äadänique cænguïnäni ïnänipa, ante pönëninque oodeoidi näni godonte æ̈ïñömö gote pöninque ædæmö äate ate cæ̈nänipa. Ayæ̈ dodäni godömenque nanguï näni wææ angaïnö ante pönente Ao ante cædinque tömënäni owæta cængæ̈ tiguicade awæmpa tömancoo ancaa mënongate quëwënänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ïninque dodäni näni wææ angaïnö ante Ao ante tömänö ante ëñente cæte quëwënäni inte Paditeoidi tönö në wææ odömönäni ñöwo ïñömö Itota ingante edæ pïinte äninque, —Bitö mïñæ̈ në godäni ïñömö quïnante dodäni näni angaïnö ante ëñënämaï inte wentamö nampote cænguï cæ̈nänii. ");
INSERT INTO aucNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ante pïïnäni wædinque Itota wæætë, —Mïnitö guiquënë waa cæmïni inte baï në änewëmïni ïñömïnite mïni cædö ante Wængonguï ïïmaï apæ̈necampa, ante Itaiya wodi nöingä ante yewæ̈mongacäimpa. “Ïïnäni ïñömö botö ïmote önöneque waa apæ̈nete baï tededäni incæte, tömënäni mïmöno æ̈mæ pönente edæ gobæ ongonte baï ïnäni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ayæ̈ botö ïmote waa ate baï ædæ wæænte tededinque, Wængonguïmi ïmidö anguënë, ante apæ̈nedäni incæte tömënäni botö ïmote önonquedö ante cædänipa. Waodänique näni wææ änönö ante odömonte apæ̈nedänipa töö.” Ante Wængonguï pïingampa, ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Edæ Wængonguï, Ïïmaï cæedäni, ante nänö wææ angaïnö ante Baa änïmïni inte mïnitö waodänique näni änewënö ante Ao ante cæmïnipa töö, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ante apæ̈nedinque Itota godömenque, —Mïnitö dodäni näni angaïnonque ante ëñente cæcæte ante cædinque Wængonguï nänö wææ angaïnö ante wido cædinque dicæ waa cæmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Möitee wodi, “Bitö Wæmpo ingante bitö badä ïnante waadedinque waa cæe,” angacäimpa. Ayæ̈, “Waocä wæmpocä ingante wäänä ïnante pïinte wënæ wënæ angä ïninque mïnitö tömengä ingante wæ̈nömïni wæncæcäimpa,” ante wææ ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Incæte mïnitö ïïmaïnö ante wææ cæmïnipa. Waocä mæmpocä ingante waa cæquënengä ïñongante wäänä ïnante adobaï waa cæquënengä ïñongante mïnitö wæætë wææ äninque, Bitö wæmpocä ingante wäänä ïnante apæ̈nedinque ïïmaï ante apæ̈necæbiimpa, änewëmïnipa. Bitö, “Mæmpo, bitö quï, ante, Badä, mïnö quï, ante do botö pönonguënënö incæ ñöwo wæætë Wængonguï ingante do edæ godonte impa,” ante, Codobänö näni änö impa, ante apæ̈necæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Äninque mïnitö Wæmpo beyæ̈ wäänä beyæ̈ në cæquënengä ingante wææ ämïni beyæ̈ tömengä wïï cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mänömaï cædinque mïnitö dodäni näni angaïnö mïni Ao ante æ̈nïnonque ante ëñëninque Wængonguï nänö angaïnö ante edæ, Önöneque impa, ante baï cæmïnipa töö. Ayæ̈ adobaï wapiticæ̈ äninque mïnitö wadö wadö cædinque wënæ wënæ cæmïnipa töö, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ayæ̈ nanguï ïnäni ïnänite Itota aa pecä pöñönänite apæ̈necantapa. —Mïnitö tömämïni ïmïnite apæ̈nebo ëñëninque ocaidë pönente ædæmö ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Quincoomë yabæque ongoncoo incæ waocä önönë guiidï beyænque tömengä mïmö dicæ wentamö entawenguingää. Wæætë mïmönë wïwa pönëninque nänö tao godincoo beyænque mïmö wentamö mongængampa, ante apæ̈nebo ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ëamonca ongonte ëñëedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ante apæ̈nedinque Itota nanguï ongönäni ïnänite ëmö cæte oncönë gote wäänë guiicä ate tömengä nänö në ëmïñæ̈näni guiquënë, Mänömaïnö ante odömonte apæ̈nedinque bitö æbänö ante odömoncæte ante apæ̈nebitapa, ante ëñencæte ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ante wæyönänite Itota, —Mïnitö incæ ocai ömæcadäni baï ïnömïni inte ëñënämaï ïmïnitawo. Cænguï incæ waocä mïmönë guiipa wentamö ëwocaquingää. ");
INSERT INTO aucNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Edæ wïï mïmönë guiipa. Wæætë cæncadë guiite goiwaa ogä mente wido cæquinque ï apa änewëmïnii. Mänömaïnö äninque Itota, Tömää cænguï waëmö impa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Äninque godömenque, —Mïmönë wïwa pönëninque nänö tao godincoo beyænque waocä wentamö ëwocacampa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Edæ mïmönë nänö entawente taodïnö beyænque waocä önöwëninque wënæ wënæ ante pönengampa. Mïmönë towëïnente nänö pönënö beyænque waocä godö towente quëwengampa. Mïmöno æ̈ïnente wædinque wacä quï awëmö ængampa. Mïmönë nänö pïinte pönënö beyænque godö wæ̈nongampa. Nänöogængä ïnämaï ïñongante waocä mïmönë towëïnente nänö pönënö beyænque godö mongampa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mïmönë nanguï æ̈ïnente wædinque mäincooque ante pönëwengampa. Mïmönë nänö taodï beyæ̈ wacä ingante pïinte cæcampa. Mïmönë pönëwëninque, Wacä edæ oda cæcædänimpa, ante babæ cæcampa. Wïwa nänö pönëwënö beyænque quingämë baï cæte quëwengampa. Mïmönë nänö pïinte adö beyæ̈ waocä, Wacä baï ñæ̈næ̈mo pönï bacæboimpa, ante cæcampa, ayæ̈ wacä ingante godö wënæ wënæ ante babæ angampa. Mïmönë nämä ante waa ate nänö pönënö beyænque, Tömëmoque waëmö ïmopa, ante nämä waa acampa. Mïmö ömædengä inte ëñënämaï cæte önonque quëwengampa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mänïï wïwa cæpämo tömämämo mïmönë nänö pönënö beyænque waocä wentamö ëwocacampa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mänïñömö quëwente godinque Itota Tido eyequeï gogacäimpa. Ayæ̈, Awëmö guiite owoyömo wadäni adämaï incædänimpa, ante pönëninque oncönë pö wäänë guiite ongongä incæte ædö cæte wïï aquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Edæ, Itota owocampa, ante do tededäni ëñëninque wacä wäänä, Botö wengä onquiyængä ïñömö wënæ në wentamö ëwocacä ingante ënempocampa, ante wædinque Itota weca ponte ædæ wæænte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Itota ëñëmi. Wënæ botö wengä tönö në quëwengä ingante wido cæquïmi, angantapa. Mänïï onquiyængä Tidopënitiabæ në ëñagaingä inte guidiego tededö në tedecä ïnongä. ");
INSERT INTO aucNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Adinque Itota, Wïï oodea onquiyængä ïnongampa, ante wædinque angantapa. —Wënäni cænguï inguënë waocä dicæ guintamöidi cænguï ante wææntodonguingää. Bitö edæ wabi ïñömite botö bitö beyæ̈ ædö cæte cæquïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Äñongante, —Awënë ïñæmpa wëñæ̈näni cænguï cæ̈ninque eyepodäni wæænte æ̈nömengadæmpa ïnö öñöñö guintamöidi ade cæmpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ante apæ̈neyongä Itota, —Bitö nö apæ̈nedïmi inte waa gocæbiimpa. Wënæ bitö wëñængä nänö wædö incæ dobæ edæ ëmö cæte wadæ gotimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Angä ëñëninque oncönë go guiite ayongä tömengä wëñængä önonganque bate möïmoga ongongä agacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mänïï Tido gote quëwëninque Itota wadæ godinque Tidöö wodo pænta gocanque go Gadideapæ̈ wedeca poncæ cædinque Decapodibæ yaatænque pongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Gadideapæ̈ wedeca pongä adinque wacä önömonca babetamoncacä inte önöne wapiticæ̈ tedecä ingante Itota weca ænte pöninque, Gampo cæbi waa babaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Äñönäni Itota babetamoncacä ingante nänënë ænte godinque önömonca pædæ guipomoncacantapa. Ayæ̈ nämä önompo towæ tänompodinque wapiticæ̈ tedecä ingante godö gampo cæguënëwacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ayæ̈ öönædë ïnö æ̈mö adinque öö guëmante äninque babetamoncacä ingante, “Epata,” äninque mönö tededö, “Önömonca wi æ̈moncabäwe,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Äñongä edæ önömonca tee mömoncate baï ïnï wi æ̈nete baï badinque önonguënëwa ñïmæncæguënëwa gote baï cæguënëwadinque töö tedecantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Itota, Botö cæbo në adïmïni inte gode änämaï ïedäni, äninque ancaa angä incæte në adïnäni ïñömö godömenque nanguï gode ä gode ä cæte tededäni ");
INSERT INTO aucNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ëñente wædinque tömänäni nanguï guïñëninque, “Edæ önömonca babetamonca ïnïnäni ïnänite Itota cæcä ate önömonca ëñënäni badänipa. Önöne babetade ïnïnäni ïnänite cæcä ate önöne tededäni badäni atamönipa. Tömää edæ waa cæcä ingampa,” ante nanguï tedete wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mänïñedë wadäni tæiyæ̈ pönï ïnäni ponte ëñëñönäni tömënäni cænguï dæ ä adinque Itota tömengä mïñæ̈ në godäni ïnänite aa pecä pönäni ate, ");
INSERT INTO aucNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ïïnäni botö weca ongönäni ïñömö mëönaa go adoönæque ïñonte botö weca ongöñönäni tömënäni cænguï ömæpodäni badäni ate wædinque botö tömënäni tönö godongämæ̈ wæte baï nanguï pönëmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cæ̈nämaï inte gue æ̈nente wæyönänite botö, Oncönë goedäni, ämo gote baï tömënäni edæ idömæ godinque tepæ̈ gæ̈wæ̈ninque edæ nangæ̈ badinque bocæ bocæ cæte wæcædönänimpa. Edæ pancadäniya gobæ quëwente pönäni abopa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ante apæ̈necä ëñente wædinque tömengä mïñæ̈ në godäni wæætë, —Ïñæmpa önömæca incæ päö impa æ̈ninque godömöni cænguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ante wæyönänite Itota, —Päö æpodö næ̈æ̈mïni. Äñongante, —Önompo æ̈mæmpoque go mëa mæ̈ ongompa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ante apæ̈neyönäni Itota godongämæ̈ nanguï ongönäni ïnänite angä onguipoiya tæ̈ contadänitapa. Ayæ̈ päö önompo æ̈mæmpoque go mëa näni næ̈æ̈nincoo pædæ godönäni æ̈ninque tömengä Wængonguï ingante, Bitö waa pönömi cæncæmönimpa, ante apæ̈nedinque pä æ̈ninque tömengä mïñæ̈ në godäni ïnänite, Pædæ godö pædæ godö cæmïni cæncædänimpa, ante godongä æ̈ninque wadäni ïnänite godäni ænte cæ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ayæ̈ gæyæ mëa pönï næ̈æ̈nänitapa. Mänïï näni næ̈æ̈nï æ̈ninque Wængonguï ingante apæ̈nedinque adobaï angä pædæ godö pædæ godö cædäni. ");
INSERT INTO aucNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Æ̈ninque tömo pönï cæ̈nänitapa. Ayæ̈ idæwaa cæ̈näni ate tömënäni pä ænte näni cænte ñönönï ee öñoncoo wente æ̈ninque Itota mïñæ̈ në godäni otodë pönö da wënänitapa. Ïninque önompo æ̈mæmpoque go mentodëa cænguï eyede contagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Në cæ̈näni ïñömö onguïñæ̈nänique ante tee mampote coatodo mïido ganca baï ïnäni inte ongönönänimpa. Ïinque cæ̈näni ate Itota angä wadæ godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Godäni ate Itotaidi do wipodë guii contate cæwodinque ïmæ̈mäa pöninque Dadämänotabæ pongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Itota pongä adinque Paditeoidi ponte bee tëninque tömengä ingante, Æbänö cæbii, æbänö ämii, ante ancaa änänitapa. Ayæ̈, Mönö ämö ëñente tömengä oda cæbaingampa, ante cædinque Itota ingante apæ̈nedinque, Bitö, Pönencædänimpa, ante öönædë mä cæï baï cæbi amönie. ");
INSERT INTO aucNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Änäni ëñëninque Itota, Ancaa änäni awædö, ante wæwente badinque öö öö ante guëmangantapa. —Ïñæmpa ñöwomïni, Mä cæte odömömi adinque pönëmaïmönipa, ante ancaa ämïni awædö. Näwangä ämo ëñëedäni. Ñöwomïni ïmïnite mä cæte odömönämaï ingæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ante äninque tömënäni ïnänite ëmö cæte godinque wipodë guiite æ̈mæ̈mäa taocæ cæte cæwodinque wadæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mänïï æ̈mæ̈mäa näni tao gocæ cæyedë tömengä mïñæ̈ në godäni guiquënë päö wïï pönente æ̈nämaï inte godäni ïninque päö adoque pönï näni wëënëñedë ñönöninque wipodë öñompa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Itota ïñömö mänïï päö tömënäni näni æ̈nämaï ïnö ante wïï tededinque wadö ante pönente apæ̈necantapa. —Päö yedæ æmpoquï, ante Paditeoidi tönö Edode näni da wente cæ̈ï ate gomö aedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Angä ëñente wædinque tömengä nänö në ëmïñæ̈näni wæætë näni caboque tededinque, Päö ænte pönämaï ïmöimpa, ante Itota wabänö mänömaï beyæ̈ ämaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ante nämäneque tededäni wædinque Itota wæætë tömënäni ïnänite, —Päö æ̈nämaï inte mïni pönïnö ante quïmæ̈ tedewëmïnii. Botö päö ante dicæ wæbogaa. Nanguï cæbo adïmïni inte mïnitö ayæ̈ ëñënämaï ïmïnitawo. Edæ mïmö ömædëmïni inte tedewëmïnipa, ante awædö. ");
INSERT INTO aucNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Edæ awincaque adinque ayæ̈ adämaï ïmïnitawoo. Önömoncaque ëñëninque ëñënämaï ïmïnitawoo. Edæ botö æbänö cætabopa, ante adïmïni inte edæ wïï pönëmïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Päö önompo æ̈mæmpoque botö pä ænte godönï incæ tinco mïido ganca ïnäni näni cænte ñönönï ee öñöñonte æpotodënö cænguï wente æ̈mïnii. Äñongante, —Önompo tipæmpoga go mentodëa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ayæ̈ päö önompo æ̈mæmpoque go mëa guiquënë coatodo mïido ganca ïnäni näni cænte ñönönï ee öñoncoo æpotodënö cænguï wente æ̈mïnii. Äñongante, —Önompo æ̈mæmpoque go mentodëa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Apæ̈nedäni ëñëninque tömengä edæ, —Ïñæmpa Tadoteoidi tönö Paditeoidi wapiticæ̈ ante näni odömonte apæ̈nedö ante botö, Gomö aedäni, ante wææ ämopa, ante mïnitö ayæ̈ ëñënämaï ïmïnitawoo, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mänïnö godinque Betaida ïñömö pönäni adinque wadäni babetamongä ingante Itota weca ænte pöninque, Gampomonguïmi. ");
INSERT INTO aucNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Änäni ëñëninque Itota babetamongä önompo bæi ongonte töö æ̈mænte tömënäni quëwëñömö tao yabæque ænte mäocä gocantapa. Ayæ̈ godö towæ tänömonte gampo cæmöninque, Pancaa tæcæ abi edæ, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Äñongä edæ tæcæ ïñæ̈ æ̈monte, —Awæ̈ cægonte baï waodäni incæ cægönäni abopa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Itota wæætë godö gampo cæmongä ate babetamongä ïningä incæ ñöwo cöwä adinque edæ waa bamöninque tömäo edonque pönï acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ïninque tömengä ingante Itota, —Ïñömö näni quëwëñömö yaatænque wadæ godinque tömëmi oncönë goe, angä gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Itota ïñömö tömengä mïñæ̈ në godäni tönö wadæ godinque Tetadea Pidipobæ wædænque ïnäni näni quëwëñömö wædænque ïnäni näni quëwëñömö go go cædänitapa. Idömæ godinque tömengä nänö në ëmïñæ̈näni ïnänite Itota angantapa. —Wadäni botö ïmotedö ante tededinque, Æbodö ïmoo, ante apæ̈nedäni ëñëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Äñongante, —Bitö ïmitedö ante apæ̈nedinque pancadäniya, Æpæ̈në në guidongaingä Wäö wodi incæ Itota adocä ïmaingampa, ante tededänipa. Wadäni guiquënë, Ediya wodi incæ Itota ïnongä ïmaingampa, ante apæ̈nedänipa. Wadäni guiquënë, Wængonguï beyæ̈ në apæ̈negaïnäni baï Itota ïñömö adocä ïmaingampa, ante bitö ïmitedö ante tededänipa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ante tömengä mïñæ̈ në godäni apæ̈nedäni ëñëninque Itota, —Ayæ̈ mïnitö guiquënë, Æbodö ïmoo, ante ämïnii. Äñongante Pegodo ïñömö, —Bitö mönö Codito ïnömi ïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Angä ëñëninque, Botö ïmotedö ante, Codito ïnongä ingampa, ante gode änämaï edæ pæ wëëneedäni, ämopa, ante Itota wææ angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ayæ̈ mänïñedë Itota tömengä mïñæ̈ në godäni ïnänite ïïmaï ante mä odömonte apæ̈negacäimpa. Botö Waobo ëñagaïmo inte nanguï caate wæquënëmo ïmopa. Edæ në aadäni näni Picæncabo tönö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni tönö mänïnäni ïñömö botö ïmote Baa änäni wæquënëmo ïmopa. Ayæ̈ botö ïmote godömenque wæ̈nönäni wæncæboimpa. Incæte botö do wæ̈nönäni wæ̈nïmo inte edæ mëönaa go adoönæque ïñonte ñäni ömæ̈moncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mänömaï ante Itota edonque apæ̈necantapa. Apæ̈necä ëñëñönäni Pegodo guiquënë Itota ingante nänënë mäocä godinque, Quïmæ̈ wæncæ änewëë, wææ ante tæcæ pïincæ cæyongante, ");
INSERT INTO aucNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Itota edæ tömengä mïñæ̈ në godäni gämæ̈nö dadi ëmænte adinque Pegodo ingante näëmæ̈ pïïninque angantapa. —Bitö Tatänabi baï ïnömi inte edæ botö weca ongönämaï wadæ gobäwe. Wïï Wængonguï nänö änönö ante pönëmi inte bitö waodänique näni pönëwënonque ante pönëninque mänömaïnö ante tedebi awædö, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ayæ̈ tömengä ëmïñæ̈näni tönö nanguï ongönäni ïnänite aa pecä pönäni ate Itota tömänäni ïnänite apæ̈nedinque, —Æcänö botö mïñæ̈ pöïnëna ïna tömengä nämä beyænque ante pönënämaï inte botö mïñæ̈ tee empote poncæcäimpa. Nämä nänö wænguïwæ̈ ænte mongænte ponte baï cædinque tömengä, Botö wænguïmo incæ caate wæbo incæ Itota ingante cöwë tee empote gocæboimpa, äninque poncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Edæ æcänö, Nämä wææ gompodinque quëwencæboimpa, ante cædinque botö mïñæ̈ pönämaï ingä guiquënë tömengä ïñömö edæ quëwënämaï incæcäimpa. Wæætë edæ, Wæ̈nönäni wæ̈mo incæte botö Itota mïñæ̈ tee empote godinque tömengä waa pönï nänö cægaïnö ante apæ̈necæboimpa, ante æcänö cæda guiquënë tömengä edæ ayæ̈ quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Edæ waocä inguipoga ongoncoo tömancoo ö æncæte ante cædinque nämä önöwoca incæ pædæ godongä wë womonte ba ïninque edæ tömengä nänö ömæwocate wæquinque mäincooque æ̈maingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ïñæmpa eyepæ̈ godongampa diyæ̈ önöwoca wæætë æ̈maingää. ");
INSERT INTO aucNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ñöwodäni Wængonguï ingante pämænte godinque në ëñënämaï cædäni weca quëwëninque mïnitö ïñömö botö Waobo në ëñagaïmo beyæ̈ ante guingo imonte wæmïnitawo. Botö apæ̈nedö beyæ̈ ante guingo imonte wæmïnitawo. Ïñæmpa botö Mæmpo ñäö guïnæ̈ gongæ̈ñonte anquedoidi tæiyæ̈ waëmö ëmönäni tönö dibæ pöninque botö wæætë botö beyæ̈ ante në guingo ïmonte wædingä beyæ̈ ante näëmæ̈ guingo imonte wæcæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mänömaïnö äninque Itota godömenque, —Botö weca ongömïni pancamïniya ïñömö ïïmaï ba acæmïnimpa, ante näwangä ämopa. Mïnitö ayæ̈ wæ̈nämaï mïïmïni quëwëñömïni botö Wængonguï Awënë Odeye ïnömo inte tæ̈ï pïñæ̈ninque Tæiyæ̈ Awënë babo acæmïnimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mänïnö ante apæ̈necä ate Itota ïñömö önompo æ̈mæmpoque go adoönæque ïinque go ate Pegodo ingante Tantiago tönö Wäö ïnate mänimpodänique ïnänite änanquidi mæ̈icä adodänique æibæ æite ongongadänimpa. Æite ongöñönäni edæ Itota awinca tömënäni ayönäni edæ wïï cöwë nänö ëmönö baï waëmö pönï ñäö baï edæ ëmongä bamongä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tömengä weocoo ñäö pönï näämænta weocoo ëñacä adinque tömënäni, Ædö cæte ïincoo baï näämænta pönï yamonte cæquïnänii, ante edæ wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ayæ̈ ayönäni edæ doyedë pönï në æigaïna ïñömö Möitee wodi tönö Ediya wodi incæ Itota tönö edæ godongämæ̈ pö gongæ̈ninque tedegöna adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Adinque Pegodo guiquënë Itota ingante, —Awënë në Odömömi ëñëmi. Ïñömö mönö waa pönï ongonte awædö. Bitö ämi ïninque mönitö oncontaicoo mentaiya go adotaique mæ̈nöninque bitö oncontai ante adotaique Möitee oncontai ante adotaique Ediya oncontai ante adotaique mæ̈nömaïmönipa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Edæ Wäö tönö Tantiago tönö godongämæ̈ guïñente wædinque Pegodo, Æbänö ante tedequïmoo, ante ëñënämaï inte mänïnö ante önonque tedecantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ayæ̈ edæ boguïmämo ocabogadäni obo wææ̈ninque ganta owo ïninque önönepämoque boguïmämodë apæ̈necantapa. “Ïingä ïñömö botö Wengä botö në waadecä ingampa cæmïnii. Tömengä pönö apæ̈necä ate ëñëedäni,” ante apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ëñëninque quingæ̈ gomö gomö ayönäni wada edæ do dæ goda ïñönate Itota adocanque ñöwo tömënäni weca ongongä agadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ayæ̈ änanquidi ïnö wææ̈ pöñönäni Itota tömënäni ïnänite angantapa. Mänïnö mïni adïnö ante mïnitö gode änämaï pæ wëëneyömïni botö Waobo ëñagaïmo inte edæ wænte ate ñäni ömæ̈moncæboimpa. Ñäni ömæ̈mömo ate mïnitö edæ mänïñedë ate apæ̈necæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ante angä ëñëninque tömënäni gode änämaï pæ wëënedäni incæ nämäneque, Mänïnö tömengä nänö ñäni ömæ̈monguïmämo ante æbänö ante apæ̈necää, ante wædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ïninque Itota ingante, —Mänömaï ï ïninque, Ediya wodi täno poncæcäimpa, ante në odömönäni ïñæmpa quïnante apæ̈nedänii. ");
INSERT INTO aucNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Äñönänite Itota wæætë, —Ediya wodi näni änongä ïñömö täno pongä ingampa. Näwangä impa. Pöninque tömengä, Doyedë ingaï baï ñöwo wæætë adobaï nö pönï bacæ̈impa, ante badongampa. Ïninque dodäni Waocä në ëñaquingä ingantedö ante yewæ̈möninque, Nanguï caate wæyongante wadäni pïïninque Baa ancædänimpa, ante quïnante yewæ̈mongadänii, ante pönëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Incæte botö ïïmaïnö ante apæ̈nebo ëñëedäni. Ñöwocä mönö Ediya ïnongä inte do pongäimpa ante aquënë. Tömengä pongä adinque wadäni edæ dodäni näni yewæ̈mongaïnö baï adobaï cædinque quïëmë ante näni cæïnëwënö ante do cædänipa, ante Itota tömengä tönö në æidïnäni ïnänite apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Itotaidi mänïï wææ̈ninque tömengä nänö në ëmïñæ̈näni æidämaï ïnäni weca ponte ayönäni wadäni nanguï ïnäni goto gongæ̈näni adänitapa. Në æidämaï ïnäni tæcæguedë ongöñönänite në wææ odömönäni guiquënë tömënäni tönö wæætedö wæætë änäni adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Itota do pongä adinque edæ goto gongæ̈nïnäni tömänäni guïñente wædinque wadæ pogodo ponte bee tëninque, Bitö pömi, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Äñönänite Itota, —Tömënäni tönö quïnö ante apæ̈nedinque wæætedö wæætë ämïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Äñongante adocanque tæcæguedë ongongä inte wæætë apæ̈nedinque, —Awënë në Odömömi ëñëmi. Botö wengä wënæ babetadecä ingante ëwocampa, ante wædinque botö tömengä ingante bitö weca ænte pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Æyömömë ongöñongante wënæ pö guiidinque wëñængä ingante cöwë gotodongä tæ̈ go wæængampa. Ïninque wëñængä wodi mäwanta tadedinque wentoquënë wentoquënë angadinque pæ opate bacampa. Mänömaï cæcä ate wædinque botö bitö mïñæ̈ në godäni ïnänite, Wënæ inte wido cæedäni, ämo cæquënënäni incæ ædö cæte cæquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ante apæ̈neyongä Itota tömënäni ïnänite, —Ñöwomïni mïni pönëegade. Botö mïnitö weca æpogadö quëwëmoï. Pönënämaï inte cæyömïnite botö æpogadö piyæ̈në cæte wæwëmoï. Edæ wëñængä ingante botö weca ænte mämömïni pongäedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ænte pönäni ate wënæ incæ Itota ingante adinque do wëñængä ingante do do wäate baï cædinque wido cæcä tæ̈ go wæængantapa. Ayæ̈ mäwantabo tadedinque baga wentoquënë wentoquënë angadinque edæ pæntæ̈mæ̈ pæntæ̈mæ̈ gocä. ");
INSERT INTO aucNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Adinque wæmpocä ingante Itota, —Æyedënö mänömaï bacäï. Äñongante, —Wëñængäñedë do badingä inte quëwengampa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Quëwëñongante wëñængä ingante wantæ wantæ ïñö wantæ wantæ ïñö, Gongapamö guitodömo gonte wæncæcäimpa, ante wënæ incæ cæcä. Ayæ̈, Æpæ̈në adobaï guitodömo becadote wæncæcäimpa, ante cæcampa cæbii. Näwangä tæ̈ï pïñæ̈mi ïninque bitö mönatö wæwënö ante pönente cæbaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Äñongante, —Bitö guiquënë wabänö wede pönëmi ïmitawoo. Edæ wede pönëñongante edæ waocä beyæ̈ tömää do cæte impa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Angä ëñente wædinque wæmpocä ïñömö yedæ äninque, —Bitö ïmite pönëmopa. Edæ botö æ̈mæ pönënö ante bitö cæbi ate ædæmö wede pönente bacæboimpa, ante wæbopa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ante äñongä nanguï ïnäni do pogodo pönäni ate wædinque Itota ïñömö wënæ në wentamö ëwocacä ingante pïinte äninque, —Wënæbi bitö, Babetamonca babetade bacædänimpa, ante në cæbi ïnömi inte ñöwo tao godinque wïï adodö guiiquïmi incæbiimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ëñente wædinque nanguï Yæ yæ äninque wëñængä ingante wido cæcä do do wäate tæ̈ go wææ̈ninque pæntæ̈mæ̈ pæntæ̈mæ̈ goyongante wënæ tao gocantapa. Gocä ate wëñængä do wæ̈nïnäni baï öñongä ate wædinque pancadäniya, Æ̈mæ̈wo wæ̈maingampa, ante wædäni. ");
INSERT INTO aucNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ïninque Itota ïñömö pædæ wææmpo önompo bæi ongonte ængæ̈ ganticantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Itota ayæ̈ wadæ godinque oncönë pö guiiyongante tömengä nänö në ëmïñæ̈näni awëmö äninque, —Mönitö guiquënë bitö baï wido cæcæte ante cædinque quïnante wido cædämaï intamönii. ");
INSERT INTO aucNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ante wæyönänite, —Wënæ mäningä baï ingante wido cæcæte ante cædinque wantæpiyæ̈ cæ̈nämaï inte Wængonguï ingante nanguï apæ̈nete ate wido cæcæ̈impa, ante apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ayæ̈ wadæ gote Gadideabæ wodo pænta godinque Itota, Wadäni adämaï ïñönänite ");
INSERT INTO aucNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","botö ëmïñæ̈näni adodänique ongöñönänite odömonte apæ̈nebo ëñencædänimpa, ante cæcantapa. Ayæ̈ tömënäni ïnänite ïïmaïnö ante awëmö apæ̈necantapa. —Adocanque, Waocä në ëñagaingä æyömönö ongongää, ante godö odömöninque botö ïmote waodäni nempo pædæ godongä æncædänimpa. Në æ̈näni wæætë botö ïmote edæ wæ̈nönäni näñe wæncæboimpa. Incæte mëönaa go adoönæque ïñonte botö adobo incæ ñäni ömæ̈moncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ante apæ̈neyongante tömengä ëmïñæ̈näni önömoncaque ëñëninque ëñënämaï ïnäni inte, Æbänö ante tedebii, ante guïñente wædinque änämaï pæ wëënegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mänïï godinque Capënaömö ïñömö ponte oncönë guiidinque tömënäni ïnänite Itota, —Idömæ pöninque æbänö ante tedemïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Äñongante edæ, Mönö cabo incæ æcänonque ñæ̈nængä pönï ïnongä inte në angä inguingää, ante tedewënïnäni inte guingo ïmonte wædinque pæ wëënedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ïninque tæ̈ contadinque Itota ïñömö, Dote, näni äincabo ïnänite, Pöedäni, angä pönäni ate, —Yæcado ongömote, ante në änongä ïñömö tömengä wæætë yæmïñængä pönï gote ongonte tömänäni beyæ̈ në godö cæcä bate waa tobaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Äninque Itota wëñængä guiyangä ingante æ̈ninque tæcæguedë goncæte pæ mäninque tömënäni ïnänite wæætë apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Æcänö botö ëmöwo apæ̈nedinque mäningä baï wëñængä ingante, Pöe, ante godö waa cæcä ïñömö tömengä ïñömö edæ botö ïmote edæ do, Pöe, ante pönö waa cæcä ingampa. Ayæ̈ edæ botö ïmote, Pöe, ante në waa cæcä ïñömö tömengä ïñömö wïï botö adoboque ïmote waa cæcä ingampa. Wæætë botö ïmote në da pönöningä ingante Wængonguï ingante adobaï edæ, Pöe, ante do waa cæcampa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Itota mänömaï apæ̈necä ëñëñönäni Wäö guiquënë, —Awënë në Odömömi ëñëmi. Wacä bitö ëmöwo apæ̈nedinque wënæidi inte wido cæcä atamönipa töö. Ayæ̈, Wïï mönö cabo ingampa, ante adinque mönitö tömengä ingante Baa äninque, Cædämaï ïmäwe, antamönipa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ante apæ̈neyongante Itota wæætë, —Ee amïni cæcäedäni. Edæ æcänö botö ëmöwo apæ̈nedinque öönædë näni cæï baï mä cæda, tömengä ædö cæte botö ïmotedö ante do wënæ wënæ anguingää. ");
INSERT INTO aucNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Edæ mönö ïmonte æcänö pïïnämaï ïna tömengä mönö cabo ïnongä inte baï mönö tönö godongämæ̈ cæcä ingampa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Näwangä ämopa. Bitö Codito nänö në ëmïñæ̈nömi ïmi ænte bee, ante wacä mïnitö ïmïnite æpæ̈ adotacaque pönongä bemïni ïninque në pönöningä wæætë tömengä nänö pönönïnö beyæ̈ eyepæ̈ æncæcäimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mänömaïnö apæ̈nedinque Itota godömenque apæ̈necantapa. “Wadäni godö cædäni beyæ̈ botö ïmote në pönënäni incæ pancadäniya edæ dobæ oda cæte wënæ wënæ cædänipa. Ïninque, Wëñængä adocanque guiyangä pönï ingä incæ oda cædämaï incæcäimpa, ante wææ cæcæte ante cædinque në godö cæcæ cædingä ingante ïïmaï cædäni ïninque tömengä toquënengä ïmaingampa. Waodäni näni dacæ godö dacæ godö cæquinca ñæ̈nænca æ̈ninque tömengä önömenca æ wëmencadinque tömengä ingante tæcætibæ wido cædäni ïninque tömengä edæ, Wënæ wënæ cædämaï inte becadote wæ̈mo beyænque Wængonguï botö ïmote wïï godömenque pangampa, ante wædinque waa toquënengä ïmaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bitö önompoca cædinque wënæ wënæ cæbi ïninque bitö önompo aa wi æmpote baï wido cæte baï cædinque wënæ wënæ bitö cædïnö ante wido cæbäwe. Ïñæmpa inguipoga quëwëninque æ̈mæmpoque empobi incæte bitö cöwë bitö wæ̈nämaï quëwenguinque öönædë æibi waa ïmaimpa. Edæ wïï tipæmpoga empobi inte edæ bitö gonga cöwë bæcote wæwenguïñömö wïï æ̈mæ̈wo wido cæte wæquïmidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Edæ mänïñömö tadömengadænguipo ïñömö cængota wæ̈nämaï gonga ëmönämaï bæcoquïnö anguënë.” ");
INSERT INTO aucNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ayæ̈, “Bitö önöwaca wapiticæ̈ godinque ëñënämaï cæbi ïninque önöwa aa wi æ̈wate baï wido cæte baï cædinque wënæ wënæ bitö cædïnö ante wido cæbäwe. Ïñæmpa inguipoga quëwëninque æ̈mæ̈waque ëwabi incæte bitö cöwë bitö wæ̈nämaï quëwenguinque öönædë æibi waa ïmaimpa. Edæ wïï tipæmpoga ëwabi inte edæ bitö tadömengadænguipo wido cæte wæquïmidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Edæ mänïñömö tadömengadænguipo ïñömö cængota wæ̈nämaï gonga ëmönämaï bæcoquïnö anguënë.” ");
INSERT INTO aucNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Ayæ̈ ægodawate tæ̈ go wæænte baï cædinque bitö awinca beyæ̈ ëñënämaï cæbi adinque bitö awinca cäï cæmonte baï cædinque wënæ wënæ bitö cædïnö ante wido cæquïmi, ämo. Edæ bitö, Botö tipæ̈monga ëmonte incæ tadömengadænguipo wïï goïnente awædö, ante pönente wædinque edæ cäï cæmonte awinca æ̈mæ̈monque ëmömi inte quëwëninque Wængonguï Awënë Odeye weca æite waa tobaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Edæ mänïñömö tadömengadænguipo ïñömö cængota wæ̈nämaï gonga ëmönämaï bæcoquïnö anguënë,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ayæ̈ godömenque apæ̈nedinque, “Waodäni, Ööingä ñömæ̈nämaï ingæ̈impa, ante cædinque cati ñæ̈næ̈ quïmönique gongapamö æ̈ñö cæte biyadänipa. Waomïni tömämïni adobaï caate wædinque ædæmö biyate baï badinque ñömæ̈nämaï inguïmïnidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cati quïmonte cæ̈ï ïñömö waëme inte gæpæ̈ ëmompa. Incæte nongæ̈monte ba adinque mïnitö wæætë æbänö nö cæmïni wæætë gæpæ̈ ëmonguï ï. Ööingä waëme bacæ̈impa, ante quïmonte cæ̈ï wëä wëä pæmönäni baï cædinque mïnitö mïni caipæ̈ incæ piyæ̈në cæte wacä ingä wacä ingä waa cæte quëwëedäni,” ante Itota odömonte apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mänïï Capënaömö ongöninque wadæ tao iguidinque Oodeabæ ganca Oododänö æ̈mæ̈ wedeca pongantapa. Pongä adinque nanguï ïnäni wæætë pö pö cædäni adinque Itota cöwë nänö odömöï baï adobaï odömonte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Paditeoidi guiquënë, Godö ämö ëñëninque Itota adodeque oda cædete wæcä tocæ̈ï, ante cædinque tömengä weca pöninque, Itota ëñëmi, änänitapa. Wængonguï æbänö ante wææ angacäï. Waocä tömengä nänöogængä ingante pämængä ïninque edæ nö cæte intawo. ");
INSERT INTO aucNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ante äñönäni tömengä wæætë, —Möitee wodi æbänö ante yewæ̈möninque mïnitö ïmïnite wææ angacäï. ");
INSERT INTO aucNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Angä ëñëninque, —Æ̈mæ̈wo pämæ̈mo goquïmi, ante yewæ̈möninque mäninta bitö yewæ̈möninta onquiyængä ingante godömi ængä ate bitö önonque pämæncæbiimpa, ante Möitee wodi wææ ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ante apæ̈nedäni ëñëninque Itota, —Ïñæmpa, Mïmö ömædëmïni ïnömïni inte mïnitö wënæ wënæ cæïnëmïni ïmïnipa, ante wædinque Möitee wodi, Mänömaï cæedäni, ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Edæ wëënëñedë Wængonguï nänö badongaïñedë tömengä, “Onguïñængä ingampa, ayæ̈, Onquiyængä ingampa, ante badongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mänömaï beyæ̈ waocä mæmpocä ingante ëmö cædinque wäänä ïnante ëmö cæte godinque onquiyængä ingante, Botö nänöogængä, ante æ̈mæ̈wo mongä ate tömëna näna gæncaya ïnöna inte möninque guëa quëwencædaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ïninque æ̈mæ̈wo möninque tömëna näna gæncaya incæ adocanque baï bate quëwencædaimpa,” ante Möitee wodi nänö yewæ̈mongaï baï cædinque tömëna näna gæncaya do möninque nänënë ïnämaï adocanque baï do bacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mänömaï beyæ̈ Wængonguï, Adocanque baï ïnapa, ante näna gæncaya nänö në badongaïna ïñönate waocä wæætë pango cædämaï incæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Angä wædinque Itota tönö oncönë guiidinque tömengä mïñæ̈ në godänique, Æbänö ante ämitawo. Godömenque apæ̈nebi ëñëmönie. ");
INSERT INTO aucNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ante äñönänite Itota, —Æcänö näwä nänöogængä ingante pämæ̈ninque wacä onquiyængä ingante möna tömengä wïwa towengä do badinque näwä nänöogængä ingante wïwa cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Onquiyængä guiquënë tömengä nänöogængä ingante pämænte godinque wacä ingante godö mongä ïninque tömengä adobaï wïwa towengä bacampa, ante Itota apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ayæ̈ ate, Wëñæ̈näni ïnänite Itota pönö gampo cæcadinque waadete apæ̈necæcäimpa, ante cædinque wadäni tömengä weca ænte pö ænte pö cædäni adinque tömengä mïñæ̈ në godäni guiquënë, Ænte pönämaï ïedäni, äninque Baa Baa änäni. ");
INSERT INTO aucNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ate wædinque Itota ænguï badinque në Baa änönäni ïnänite wææ äninque, —Wëñæ̈näni ïnänite ee amïni poncædänimpa. Edæ mänïnäni näni pönënö baï adobaï pönënäni inte edæ Wængonguï Awënë Odeye nempo do quëwënäni ïnänipa. Ïninque mïnitö ïñömö wëñæ̈näni ïnänite Baa änämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Edæ näwangä apæ̈nebo ëñëedäni. Wëñængä do pönengä inte Ao angä ingä baï Wængonguï Awënë Odeye ingante do pönëninque në Ao änäni ïñömö tömënänique tömengä nempo guiidinque quëwënänipa. Wadäni guiquënë Wængonguï Awënë Odeye ingante Baa ante pönënämaï ïnäni guiquënë tömënäni ædö cæte tömengä nempo guiidinque quëwenguïnänii, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Äninque edæ wëñæ̈näni ïnänite bæi ongonte pæ mäninque, Wængonguï mïnitö ïmïnite waadete pönö cæcæcäimpa, ante Itota gampo cæcacä gampo cæcadinque waa apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ayæ̈ godömenque gocæ cæyongä wacä edæ Itota weca pogodo ponte da guicapodinque, —Awënë në waa Odömömi apæ̈nebi ëñëmoe. Botö æbänö cædinque cöwë wæ̈nämaï wantæpiyæ̈ quëwëmaïmoo. ");
INSERT INTO aucNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Äñongante Itota edæ, —Wængonguï adocanque në waa cæcä ïñongante bitö botö ïmote, Në waa cæbi ïmipa, ämii. ");
INSERT INTO aucNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ïïmaï cæedäni, ante Wængonguï nänö wææ angaïnö ante bitö tömëmi do ëñëmipa. “Wacä ingante godö wæ̈nönämaï ïe. Bitö nänöogængä ïnämaï ïñongante godö guëa mönämaï ïe. Wacä quï adinque awëmö æ̈nämaï ïe. Wacä wënæ wënæ cæcä atabopa, ante godö babæ wapiticæ̈ änämaï ïe. Wacä quï æncæte ante cædinque babæ cædämaï ïe. Wæmpocä ingante wäänä ïnante waa adinque tömëna ïnante godö waadete cæe,” ante wææ yewæ̈mongacäimpa, ante bitö edæ do ëñëmipa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ante apæ̈necä ëñëninque në äningä guiquënë Itota ingante wæætë, —Awënë në Odömömi ëñëmi. Botö mänïnö bitö änö baï tömänö ëñente cædinque pægaboï ae. ");
INSERT INTO aucNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Apæ̈necä ëñëninque Itota tömengä ingante cöwä adinque waadete pönëninque, —Adodeque ayæ̈ ëñente cæquënëmi ïmipa, ante ämo ëñëe. Öönædë bitö waëmoncoo ænguinque edæ ñöwo godinque ïmæca bitö mänincoo tömancoo godonte æ̈ninque bitö æ̈ninta wæætë ömæpodäni inte wædäni ïnänite tömanta godömi æncædänimpa. Ayæ̈ edæ botö ïmote tee empote pöe. ");
INSERT INTO aucNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Angä ëñëninque, Botö mäincoo nanguï impa, ante pönente wædinque në ëacä ïñömö nanguï wæwëninque wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Gocä adinque Itota godongämæ̈ adinque tömengä nänö në ëmïñæ̈näni ïnänite, —Wængonguï Awënë Odeye nempo guiite quëwencæte ante cædinque waodäni ömæpodäni inte botö mïñæ̈ pönänipa. Mäincoo nanguï ëacä guiquënë æbänö cæte ömæpocä inte botö mïñæ̈ ponte guiite quëwenguingää, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ïninque tömengä mïñæ̈ në godäni tömengä nänö apæ̈nedö beyæ̈ ante, Æbänö angää, ante guïñente wæyönänite Itota wæætë, —Botö wëmïni ëñëedäni. Wængonguï Awënë Odeye nempo guiite quëwencæte ante cædinque ante waocä mäincoo mangä beyænque eyepæ̈ cæcampa diyæ̈ guiiquingää. ");
INSERT INTO aucNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Edæ cämeyo guiyangä ingampa diyæ̈ daagö guiyampite pædæ tacää. Ïninque, cämeyo ñæ̈nængade ïnongä inte pædæ tadämaï ingä baï në ëacä adobaï ingampa. Tömengä nämä ayongä ñæ̈nængä ïnongä inte edæ æbänö cæte Wængonguï Awënë Odeye nempo do wäänë guiite quëwenguingää. ");
INSERT INTO aucNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ante apæ̈necä ëñëninque godömenque nanguï pönï guïñente wædinque tömënäni nämäneque tededinque, —Ïñæmpa mänömaï ï ïninque æcänö wäänë guiite quëwenguingää. ");
INSERT INTO aucNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ante nämäneque tededäni ïnänite adinque Itota, —Waomïnique incæ nämä mïni cædö beyænque ædö cæte quëwëmaïmïnii. Wængonguï guiquënë wïï wao baï cædongä inte nämä incæ tömänö do cæcä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ante apæ̈necä ate Pegodo tömengä ingante äninque, —Mönitö ïñömö möni ëadincoo owæ̈ caate bitö mïñæ̈ ömæpomöni pömöni ae. ");
INSERT INTO aucNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tæcæ äñongante Itota tömënäni ïnänite wæætë, —Mïnitö botö beyæ̈ ante pönëninque waa pönï botö apæ̈nebodö beyæ̈ ante pönëninque pömïnitapa. Ïninque edæ botö ïïmaï ante näwangä ämopa. Æcänö mänïnö beyæ̈ tömengä oncodo taodinque tömengä tönïñadäni ïnänite ëmö cædinque mæmpocä tönö wäänä ïnante ëmö cæte wëñæ̈näni ïnänite ëmö cæte godinque tömengä göneacoo ëmö cæte owæ̈ caate godinque botö mïñæ̈ æcänö wadæ pöna ïñömö, ");
INSERT INTO aucNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tömengä ïñömö inguipoga quëwënincoo wëënë nänö ëadincoo baï adopocoo æ̈ninque godömenque adopo adopo tiëë ganca mänimpoga adopo æncæcäimpa. Ayæ̈ onconcoo æ̈ninque tömengä tönïñadäni tömengä badäidi tömengä wëñæ̈näni tiëë ganca baï yebæ̈näni baï æ̈ninque, tömengä göneacoo wæætë bacoo æncæcäimpa. Incæte tömengä ingante togænte pancædänimpa. Ïincayæ̈ pömämo bayonte botö, Bitö quëwenguïmämo, ante godömo æ̈ninque tömengä cöwë wantæpiyæ̈ wæ̈nämaï quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Incæte edæ täno yæcado ongönïnäni inte pancadäniya wæætë yæmïñæ̈ gote ongönäni bacædänimpa. Ayæ̈ yæmïñæ̈ ongönïnäni inte wæætë yæcado ponte ongönäni bacædänimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mänïï Eedotadëë ante ñöwo änämæ̈në æiyönäni Itota incæ täno beyænte æicä. Ate wædinque tömengä ëmïñæ̈näni guiquënë, Tömengä nänö wænguinque täno æicampa, ante wæyönäni ayæ̈ pönäni guiquënë guïñente wædönänimpa. Itota ïñömö tömengä mïñæ̈, Dote, ante näni gocabo ïnänite nänënë ænte mäocä goyönäni tömengä, Botö ïmote ïïmaï cædäni bacæboimpa, ante edonque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ëñëñönänite, “Ñöwo ïñömö mönö edæ Eedotadëë ïñömö æicæ̈impa. Mänïñömö æi pö gongæ̈mö ate adocanque, Waocä në ëñagaingä æyömönö ongongää, ante godö odömongä bæi ongonguïnäni. Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni nempo tömengä botö ïmote pædæ godongä æ̈ninque tömënäni wæætë botö ïmote apænte äninque, Cöwë wæncæcäimpa, äninque oodeoidi ïnämaï ïnäni ïnänite wæætë pædæ mäo godönäni. ");
INSERT INTO aucNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Æ̈ninque ïïnäni wæætë botö ïmotedö ante badete todinque botonga tawïmæ̈ towæ tänongadinque æ̈montaimenca tæi tæi pänäni ämogate wæyömote botö ïmote godömenque wæ̈nönäni wæncæboimpa. Wæætë do wæ̈nïmo inte botö mëönaa go adoönæque ïñonte ñäni ömæ̈moncæboimpa,” ante Itota wæætë apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ayæ̈ Tebedeo wëna Tantiago tönö Wäö ïñömö Itota weca pöninque, —Awënë në Odömömi ëñëmi. Mönatö quïëmë ämöna cæbi waa tobaïmönapa, ");
INSERT INTO aucNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Äna ëñëninque, —Mïnatö beyæ̈ quïnö cæbo æ̈mïna. ");
INSERT INTO aucNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Äñongante, —Awënë ïnömi inte bitö ñäö ëmömämodë tæ̈ contadinque mönatö ïmönate ïïmaï cæcæbiimpa, ante ämönapa. Adocanque bitö tömëmæ̈mi ïnö adocanque dipæ̈mæ̈mi ïnö ämi tæ̈ contaquïmöna. ");
INSERT INTO aucNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ante äna ëñente wædinque Itota wæætë, —Ïñæmpa mïnatö ëñënämaï inte mänömaï ämïna awædö. Edæ botö nantate wæwenguïmæ̈ baï becabo baï mïnatö edæ adobaï adotaca becate baï Ao ante botö beyæ̈ nantate wæwenguïmïnaa. Ayæ̈ botö wænguïmämo ante mïnatö adopæ̈në guiite baï adobaï Ao ante botö beyæ̈ guïñënämaï inte wænguïmïnaa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ante äñongante, —Ao ante guïñënämaï cæcæmönaimpa. Ante apæ̈neyönate Itota, —Botö nanguï caate wæwëmo baï mïnatö adotaca becate baï äanque baï caate wæquïmïna ïmïnapa. Botö wænguïmämo ante mïnatö adopæ̈në guiite baï adobaï wænguïmïna ïmïnapa. Näwangä impa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Incæte botö tömëmæ̈mo ïnö botö dipæ̈mæ̈mo ïnö æcänö tæ̈ contaquïna, ante wïï botö godö ämo ïmopa. Wæætë, Awënë contaimpaa mänïnaque tæ̈ contaquïna, ante do badongaingä inte Mæmpo Wængonguï ïñömö tömengä adocanque godö angä contacædaimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mänömaïnö ante tededapa töö, ante ëñëninque wadäni diete ganca tömengä mïñæ̈ në godäni guiquënë Tantiago tönö Wäö ïnate pïïnänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pïïnäni ate wædinque Itota aa pecä pönäni ate tömënäni ïnänite wæætë apæ̈necantapa. —Mïnitö, Oodeoidi ïnämaï ïnäni æbänö cædänipa, ante do ëñëmïnipa. Tömënäni näni, Awënëidi, ante në änönäni ïñömö nämä beyænque ante cædinque nanguï pïinte änäni wædinque awënëidi nempo quëwënäni incæ wæætë do ëñente cædänipa. Ayæ̈ tömënäni weca në ñæ̈næ̈näni ïnönäni ïñömö, Tömëmoque ämo ëñente cæedäni, ante pïinte änäni wædänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mïnitö guiquënë tömënäni nämä beyænque ante nanguï änäni baï wïï adobaï cæquënëmïni ïmïnipa. Wæætë mïni cabo ïñömïni adocanque ñæ̈nængä pönï ingä bacæte ante cædinque tömengä täno edæ mïnitö beyæ̈ në cæcä baquënengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ayæ̈ yæcado ongöïnente wæcä ïñömö tömengä yæcado ongoncæte ante cædinque wæætë edæ yæmïñæ̈ pönï gote tömänäni beyæ̈ në cæcä badinque tömengä nämä beyæ̈ ante cædämaï inguënengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Edæ Waobo ëñagaïmo inte adobaï, Botö beyæ̈ pönö cæcædänimpa, ante wïï pömo ïmopa. Wæætë wadäni beyæ̈ godö cæcæte ante pömoimpa. Ayæ̈ edæ nanguï ïnäni tee mönete baï wæwëñönäni botö wæætë, Tömënäni wibæ̈nete tadinque quëwencædänimpa, ante tömëmo wepæ̈ incæ godoncæte ante pömo ïmopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Itota mänïnö godinque Eedicoo näni quëwëñömö pongadänimpa. Tömengä nänö në ëmïñæ̈näni tönö tæiyæ̈näni tönö Eedicoo ïñömö wodo pænta tayönäni wacä babetamongä Tïmeo wodi wë Batïmeo ïñömö taadö wedeca, Pönömi æ̈moe, ante änecönongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ïninque wadäni, Itota Näatadeta pædingä inte pongampa, ante tededäni ëñëninque tömengä ogæ̈ tedete, —Itota ëñëmi. Awënë Dabii wodi pæ̈ïmi ïnömi inte botö wædö ante pönente cæe. ");
INSERT INTO aucNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ante tæcæ äñongante godongämæ̈ godäni pancadäniya, Apocæ̈në inguënë quëwëe, ante änäni incæte tömengä godömenque yedæ aa pedinque, —Awënë Dabii wodi pæ̈ïmi ïnömi inte botö wædö ante pönente cæe. ");
INSERT INTO aucNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Äninque ancaa aa pecä ëñëninque Itota næ̈ gongæ̈ninque, —Babetamongä ingante aa pemïni pongäedäni. Angä ëñëninque babetamongä ingante, —Ængæ̈ gantidinque wædämaï ïmäwe. Bitö ïmite, Pöe, angä apa quëwëe. ");
INSERT INTO aucNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Änäni ëñëninque babetamongä incæ ayacooga gäni tadongate do ængæ̈ gantidinque Itota weca pongä. ");
INSERT INTO aucNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Adinque, —Bitö beyæ̈ quïnö cæquïmoo. Äñongante babetamongä, —Awënë në Odömömi ëñëmi. Cæbi waa bamonte aboe. ");
INSERT INTO aucNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Angä ëñëninque Itota, —Waa bitö bamonguinque botö ïmote pönëmitapa. Önonque wadæ gobäwe. Äñongante tömengä do waa bamonte adinque Itota mïñæ̈ taadonque gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mänïï gote Eedotadëë obo pöninque Odibowænquidi näni anquidi ontacamö goïnö Betapaguee näni quëwëñömö ganca ayæ̈ Betänia näni quëwëñömö ganca pöñönäni Itota tömengä mïñæ̈ në goda ïnate mënaa ïnate da godöninque angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ïïmaï angantapa. —Mänïï näni quëwëñömö ongö amïna. Tömëñömö go guiite ayömïna bodo wë picængä incæ waocä ingante mongæ̈nämaï ïningä inte ñäni ñæ̈ingä a ongongä acæmïnaimpa. Adinque ñï cæyænte ænte pöeda. ");
INSERT INTO aucNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wacä, Quïnante ñï cæyæ̈mïnaa, ante wææ angä ëñëninque mïnatö wæætë edæ, Mönö Awënë nänö ænguënënö ante ænte gomönapa. Tömengä ïinque cæte ate adodö do da pönongä æ̈edäni, ante äeda. ");
INSERT INTO aucNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Angä ëñente gote ayöna bodo wë taadö wedeca odemö awäa ñänö ñæ̈ a ongö adinque ñï cæyænte ænte gocæte ante cæda. ");
INSERT INTO aucNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Adinque mänïñömö ongönäni guiquënë, —Bodo wë quïmæ̈ ñï cæyæ̈wëmïnaa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Äñönänite Itota nänö änïnö adodö äna ëñëninque, Ao änäni. ");
INSERT INTO aucNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ëñëninque ñï cæyænte Itota weca töï töï ænte pönatapa. Ænte pöninque tömëna weocoo yabæcooque æidämæ̈ wo cæyabæda ate Itota wæ̈nömënæca ïnö æi yiyæ̈ tæ̈ contacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Adinque nanguï ïnäni, Itota nänö ponguïnö, ante tömënäni weocoo yabæcooque pönö bee podöwayönäni wadäni guiquënë gönea gote yæpæ̈ma öñabo tapænte mämö bee bee podöwadäni ate tömengä podöwaïnonque gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Gocä adinque täno godäni tönö ayæ̈ pönäni tönö nanguï ïnäni godongämæ̈ godinque yedæ äninque, —Möni quëwenguinque impa, ante, Badogaa, ante tomönipa. Awënë Wængonguï ëmöwo beyænque pömi ïninque bitö toquinque edæ Wængonguï bitö ïmite waa cæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mönö mæ̈mæ̈ Dabii wodi pæ̈ïmi ïnömi ïmipa, ante adinque mönitö, Awënë odeye Dabii wodi nempo näni waa quëwengaï baï bitö nempo mönitö waa quëwenguinque impa. Ïninque, Badogaa, ante yedæ äñömöni æibæ pönï quëwënäni incæ, Badogaa, ancædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ante yedæ äñönäni Itota Eedotadëë pö ti wææ̈ninque Wængonguï oncö ñæ̈næncönë yabæcönë pö guiidinque mänïñömö ongoncoo tömää acantapa. Ayæ̈, Gäwadecæ̈ pönï ba awædö, ante tömengä ëmïñæ̈näni dote ganca ïnäni tönö wadæ tao Betänia gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gote Betänia monte baönæ pöñönäni Itota gæ̈wænte wædinque, ");
INSERT INTO aucNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Quïnö impa cænguïmoo, ante gomö ayongä iigowæ̈ öñabo ëmæ̈ incæ incate bocabaimpa, ante gote ayongä ömæcawæ̈ acantapa. Önönepoque ï beyæ̈ incadämaï intapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ante iigowæ̈ inte apæ̈nedinque, —Iigowæ̈ ëñëmi. Incaquïnämaï inte bitö incaquïmi cænguïnänii. Äñongante tömengä nänö në ëmïñæ̈näni edæ ëñëe gongæ̈nänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Do näni ponguënënö Eedotadëë pönänitapa. Itota ïñömö Wængonguï oncö ñæ̈næncönë yabæcönë pö guiidinque mänïñömö mäincoo mänäni tönö wadäni godonte æncæte ante godongämæ̈ pönäni tönö ongönäni adinque tömänäni ïnänite, Oncodo tao goedäni, ante da tadongä tao godänitapa. Ayæ̈ campio ante näni godonte æ̈impa tönö equemö godoncæte ante në mänäni näni cönöimpa tönö bæ tacä tömampaa guidömëmæ̈ tæ̈ go wææntapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ayæ̈ wadäni mäincoo mongænte yacönenque gocæte ante cæyönänite Itota, Ïincodo mongænte godämaï ïedäni, äninque wææ cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ayæ̈ tömënäni ïnänite angantapa. —Wængonguï beyæ̈ ïïmaïnö ante yewæ̈mongatimpa. “Tömämæ quëwënäni botö oncönë pö guiidinque botö ïmote apæ̈necædänimpa,” ante Wængonguï angä incæte mïnitö wënæ wënæ cæmïni beyænque Wængonguï oncö incæ në awëmö ö æ̈näni näni womöincönë baï wentamö bapa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ante odömonte apæ̈neyongante, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në wææ ante odömönäni tönö ëñëë gönänitapa. Wadäni önönänique guiquënë, Itota quïnante waa pönï apæ̈necä ëñëmönii, ante wædäni. Adinque awënëidi wæætë, Itota beyænque pïïnäni wæcæ wæ, ante pönëninque Itota ingante guïñente wædinque, Quïnö cæmö wæ̈maingää, ante wæ̈noncæte ante pönente cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gäwadecæ̈ bayonte Itotaidi ïñömö oncodo tao godinque godömenque yabæque tao gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Baänæ ate ïïmö näni pönïnö adodö ponte ayönäni iigowæ̈ yæwaguinto ætæwowate tömëwæ̈ æi ayawæ̈ edæ dobæ guingo iwate wæ̈nimpa, ante adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Adinque Pegodo, Itota ïïmö nänö änï baï impa, ante pönëninque, —Awënë në Odömömi cöwä ae. Bitö pïinte änïwæ̈ inte iigowæ̈ edæ dobæ guïñë wæ̈ ataque. ");
INSERT INTO aucNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Äñongante tömënäni ïnänite Itota wæætë, —Wængonguï ingante wede pönëmäewedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ïï änanquidi ïñömö ongö ïñonte waocä, “Änanquidi ëñëmi, äninque, Bitö cabænte wo gote gäwapæ̈në guiie,” angä ëñëninque änanquidi tömë gäwapæ̈no do wo gote guiiquï ï, ante pönëmïnitawo. Edæ näwangä ante mïnitö ïmïnite apæ̈nebopa. Æcämenque incæ edæ æ̈mæ pönënämaï inte, Botö änö baï do bacæ̈impa, ante wede pönëninque äna ïninque tömengä nänö änïnö baï do æ̈maingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mänömaï beyæ̈ botö mïnitö ïmïnite apæ̈nebopa. Mïnitö quïëmë incæ ante Wængonguï ingante apæ̈nedinque, Tömengä näwangä pönongä æncæboimpa, ante wede pönente apæ̈nemïni ïninque mïnitö änïnö tömänö edæ do æncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ayæ̈ edæ, “Mïnitö, Wïwa cæbo incæte Wængonguï öönædë në quëwënongä inte botö ïmote pönö ñimpo cæcä ïninque botö waa tobaïmopa, ante wæmïnitawo. Ïñæmpa, Wængonguï mänömaïnö cæcæcäimpa, ante cædinque mïnitö tömengä ingante apæ̈necæte ante ongöninque täno piyæ̈në cæte cæedäni. Wacä wënæ wënæ cæcä wædömïni inte mïnitö wæætë tömengä ingante pönö ñimpo cæedäni, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wæætë edæ mïnitö pönö ñimpo cædämaï ïmïni ïninque mïnitö wënæ wënæ cædïnö ante mïnitö Mæmpo öönædë në quëwengä ïnongä inte tömengä adobaï ñimpo cædämaï ïmaingampa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Eedotadëë ïñömö adodö pönänitapa. Itota Wængonguï oncö ñæ̈næncönë yabæcönë go guiite cægöñongä, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në wææ ante odömönäni tönö në aadäni näni Picæncabo, näni änäni tönö tömengä weca ponte änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tömengä ingante, —Æcänö në angä inte bitö ïmite angä cæbii, änänitapa. Æcänö bitö ïmite, Në ämi ïmipa, pönö äna æ̈ninque bitö në ämi inte baï edæ mänömaï cæbii. ");
INSERT INTO aucNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ante wæyönänite Itota näëmæ̈ äninque, —Botö mïnitö änö baï adodeque ämo ëñëninque mïnitö wæætë apæ̈nemïni ëñëmoedäni. Apæ̈nemïni ëñente ate, Botö cædïnö ante æcänö në angä inte pönö äna æ̈ninque cæboï, ante botö wæætë apæ̈nebo ëñëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wäö wodi ingante æcänö, Æpæ̈në guidonguïmi, äna ëñëninque tömengä wæætë guidongäï, ante pönëmïni. Edæ Wængonguï angä ëñente cæcantawoo. Wæætë waodänique änäni ëñente cæcantawoo. Æcänö Wäö ingante änaa, ante apæ̈nemïni ëñëmoedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Angä ëñente wædinque tömënäni, Æbänö anguïï, ante wæætedö wæætë nämäneque tededinque, “Wængonguï angä ëñente Wäö guidongantapa, ante ämö baï Itota wæætë mönö ïmonte, ‘Quïnante Wäö ingante pönënämaï ïmïnitapa,’ ancædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ante pönente wædinque wæætë, Wængonguï beyæ̈ në apæ̈necä Wäö wodi ïnongäimpa, ante tömänäni pönënänipa. Ante pönëninque awënëidi wæætë, Waodänique änäni ëñente Wäö guidongantapa,” ante mönö ædö cæte anguïï. Edæ pïïnäni wæcæ wæ. ");
INSERT INTO aucNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ante guïñente wædinque Itota ingante edæ, —Wa. Ëñënämaï ïmönipa. Ante wæyönänite Itota wæætë, —Ïninque edæ, Æcänö në angä inte pönö äna æ̈ninque botö cæboï, ante mïnitö änö ante botö adobaï apæ̈nedämaï incæboimpa, ante angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ayæ̈ mänïñedë Itota, Wængonguï æbänö cæcää, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. “Waocä yowementacodë mïninque wææ da da mäo da caadinque, Tömëmoncoo ænte pïnä pïnä gäwate tömëmæ̈ ontatodë wæ yopænte æ̈ñömö, ante æ̈æ̈ wote badongä. Ayæ̈ yowementacodë awëmö guiidämaï incædänimpa, ante æi wæ̈nömënæca gomö aquïñömö mæ̈nongä. Ate wabæca gocæ cædinque wadäni ömæ wite në aadäni ïnänite, Botö yowementacodë incæ ömæ wite aaedäni, angantapa. Aayömïnite botö, Mïnitö quï, ante pancamonga pönömo æncæmïnimpa, angä Ao äñönäni wadæ gocantapa.” ");
INSERT INTO aucNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ayæ̈ yowedepo bayonte tömengä ingante në cæcä ingante apæ̈nedinque, Bitö yowementacodë në aadäni weca godinque pancamonga ämi æ̈ninque botö weca wæætë mämömi æ̈moe, angä gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Angä godinque pongä adinque yowementacodë në aadäni guiquënë në æncæ pöningä ingante bæi ongonte tæi tæi päninque ömæpocä da tadönäni gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Adinque në ëacä ïñömö wacä ingante tömengä ingante në cæcä ingante angä gote pongä adinque yowementacodë në aadäni adobaï tæi tacadäni wæyongante, Guingo imonte wæcæcäimpa, ante tömengä ingante godö wïwa cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ayæ̈ wæætë në ëacä wacä ingante da godongä godinque yowementacodë pongä adinque në aadäni wæætë tömengä ingante wæ̈nönäni wængantapa. Ayæ̈ wæætë nanguï ïnäni ïnänite da godongä pönäni adinque pancadäniya ïnänite tæi tæi päninque pancadäniya ïnänite wæ̈nönäni wæ̈nänitapa.” ");
INSERT INTO aucNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Adocanque pönï në ëacä weca ongönongäimpa. Mäningä ïñömö në ëacä wengä onguïñængä ïñongante në ëacä tömengä ingante nanguï waadedongäimpa. Ïninque në ëacä ïñömö, ‘Tömëmo wengä ingante da godömo gocä adinque tömënäni guïñente wædinque ee abaïnänipa,’ ante pönëninque tömengä ingante da godongä tömangä pönï gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gote dicæ pongä adinque tömënäni, ‘Tömengä ingampa. Wæmpocä mäincoo ïnï edæ ïingä ïñömö në ænguingä ingampa cæmöö. Mönö edæ mäo wæ̈nömö wængä ate edæ mönö quï babaimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Änewëninque tömënäni në ëacä wengä ingante edæ bæi ongonte wæ̈nöninque tömengä baö ïnï yowementacodë wææ cæte yabæque edæ, Ömäe, ante wido cædänitapa. Mäninque apæ̈nebopa.” ");
INSERT INTO aucNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ante tededinque Itota apæ̈negacäimpa. Ayæ̈ mänïï në änïnäni ïnänite wæætë ïïmaï angantapa. “Ïninque yowementacodë në aaquënënäni ïnänite në ëacä æbänö cæquingää, ante pönëmïni. Tömengä edæ, Ömäe, ante do pöninque në aaquënënäni ïnänite godö wæ̈nöninque wadäni ïnänite yowementacodë godongä æ̈ninque aacædänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Äninque Itota, “Mïnitö guiquënë dodäni näni yewæ̈mongainta adämaï inte botö ïmote ämïnitawo. Edæ ïïmaïnö ante Wængonguï angä ëñente yewæ̈mongadänimpa. ‘Dica ænte adinque, Wënæ wënæ inca, ante në mæ̈nönäni näni wido cædinca incæ gomonga waëmonca inca ïninque täno näni ñönöninca bæbængapa do bacapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wængonguï Awënë incæ mänömaï cæcä adinque mönö waocabo guïñente wædinque waa amompa,’ Ante yewæ̈monte ï abaïmïnipa.” ");
INSERT INTO aucNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mänömaï apæ̈necä ëñente wædinque awënëidi wæætë, Ïñæmpa në aaquënënäni näni cæïnö ante odömonte apæ̈nedinque Itota mönö ïmonte pïinte angä awædö, ante pönëninque tömengä ingante bæi ongoncæ cædänitapa. Incæte, Wadäni pïïnäni wæcæ wæ, ante wædinque ee adinque bæi ongönämaï inte tömënäni edæ wadæ gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mänïï awënëidi incæ ayæ̈ ate Paditeoidi pancadäniya tönö Edodeidi pancadäniya ïnänite da godöninque, Mïnitö gote Itota ingante äñömïni wabänö tömengä nänö pante wæquinque adodeque wapiticæ̈ baï tedebaingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Änäni ëñëninque Itota weca wadæ pöninque, —Awënë në Odömömi ëñëmi. Bitö nö pönente cæbi ïmipa, ante do ëñëmönipa. Ayæ̈ bitö ayömi mönitö tömämöni önömönique baï ïmöni adinque bitö ïñömö, Waodäni æbänö anguïnänii, ante ayæ̈, Æbänö cæquïnänii, ante wædämaï ïmi inte Wængonguï taadö ante bitö guïñënämaï inte nö odömonte apæ̈nebipa. Ïninque apæ̈nebi ëñëmönie. Odömäno gobiedöno beyæ̈ ante tæiyæ̈ awënë Tetædo tiguitamö nänö änintamö ante æbänö wææ yewæ̈monte ï, ante ëñencæte ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Godonte edæ waa cæte intawo. Wæætë wënæ wënæ cæte intawo. Ante äñönänite Itota ïñömö, Waa cæte baï tedewënänipa, ante do ëñente wædingä inte tömënäni ïnänite, —Botö ïmotedö ante cædinque, Æbänö cæmö ate oda cæquingää, ante quïnante cæmïnii. Deënadio tiguitamö ænte pömïni aboedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Angä ëñente ænte pönäni adinque, —Æcänö awinca baï yewæ̈monte badonte ï. Æcänö ëmöwo ante yewæ̈monte ï. Ante äñongante, —Awënë Tetædo awinca baï yewæ̈monte badonte impa. Adocä ëmöwo ante yewæ̈monte ongö amönipa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ante apæ̈nedäni ëñëninque Itota tömënäni ïnänite, —Awënë Tetædo quï ï ïninque edæ Tetædo ingante godongæ̈impa. Wæætë Awënë Wængonguï quï ï ïninque Wængonguï ingante godonguï ï apa änewëmïnii. Angä ëñëninque tömënäni, Æ, nö pönï ante apæ̈necampa, ante tömengä ingante waa adinque guïñente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ayæ̈ Tadoteoidi në, Waocä wæ̈ninque ñäni ömæ̈mönämaï æ̈mæ̈wo wængampa, ante në änewënäni inte Itota weca pöninque, Möni änö ante ämi ëñëmaïmönipa, äninque, ");
INSERT INTO aucNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Awënë në Odömömi ëñëmi. Möitee wodi mönö beyæ̈ ante wææ yewæ̈möninque ïïmaï ante yewæ̈mongacäimpa. Waocä möninque wëñæ̈ tapæ̈idämaï inte wængä ate tömengä tönïñacä wæætë owæmpoingä ingante möninque wëñæ̈ tapæ̈idinque, Botö tönïñacä wodi wengä ingampa, ante pæpogacæcäimpa, ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Ïninque wadäni ïïmaï cædänitapa, ante apæ̈nemöni ëñëe. Edæ önompo æ̈mæmpoque go mengäa näni caipæ̈ ïñönänite bamoncadengä möninque wëñæ̈ tapæ̈idämaï manguïwëninque edæ näñe wængä. ");
INSERT INTO aucNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wængä ïninque wææ̈ ayæ̈mengä adocä ingante möninque wëñæ̈ tapæ̈idämaï näñe wængä. Ayæ̈ wææ̈ wacä adobaï wëñæ̈ tapæ̈idämaï näñe. ");
INSERT INTO aucNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ayæ̈ wææ̈ wëñæ̈ tapæ̈idämaï näñe, ayæ̈ wææ̈ wëñæ̈ tapæ̈idämaï näñe, ayæ̈ wææ̈ wëñæ̈ tapæ̈idämaï näñe, ayæ̈ wææ̈ ayæ̈mengä pönï adocä ingante möninque wëñæ̈ tapæ̈idämaï näñe wængantapa. Onquiyængä guiquënë ancaa owæmpote wædinque tömangä pönï näñe wængantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ïninque, Mönö ñäni ömæ̈monguïönæ, ante mïni äönæ ïñonte mäningä owæmpoingä ïñömö æcänö nänöogængä baquingää. Edæ tömengä ingante ïñömö edæ tömänäni manguïwengadänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Äñönänite Itota wæætë, —Mïnitö ïñæmpa. Wængonguï angä ëñente näni yewæ̈möinta adämaï inte baï ämïni awædö. Wængonguï adocanque tæ̈ï pïñængä inte edæ tömää cæcampa, ante pönënämaï inte edæ oda cæte ämïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Edæ Wængonguï anquedoidi öönædë cöwë owodäni baï ïnönäni inte waodäni ñäni ömæ̈möninque godö ñänönämaï mönämaï inguïnänidö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wæætë do wængaïnäni näni ñäni ömæ̈monguïnö ante Möitee wodi ocäñequiya ante yewæ̈möninque adotaa æbänö yewæ̈mongacäï, ante mïnitö adämaï inte ämïni awædö. Edæ Möitee wodi ingante Wængonguï ïïmaï angacäimpa. “Botö ïñömö Abadäö Wængonguïmo ingaïmo inte ayæ̈ Itæca Wængonguïmo ingaïmo inte botö Aacobo Wængonguïmo adobo ïmo anguënë.” ");
INSERT INTO aucNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ante në angaingä inte edæ æ̈mæ̈wo wæ̈nïnäni tömënäni Wængonguï ædö cæte inguingää. Wæætë edæ mïï quëwënänique tömënäni Wængonguï ïnongä ingampa, pönenguënë quëwëmïnii. Në wænte godïnäni incæ ayæ̈ mïïnäni quëwënäni ïnänipa. Mïnitö edæ wadö ante tededïmïni inte edæ oda cæte wapiticæ̈ änewëmïnipa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mänömaï äñönänite nö apæ̈necä ëñente wædinque adocanque në wææ ante odömongä ïñömö Itota weca pöninque, —Wængonguï, Ïïmaï cæedäni, ante nänö wææ angaïnecoo ante pönëninque ædedö tæ̈ïne pönï ï ïñonte mönö nanguï ëñente waa cæquïï. ");
INSERT INTO aucNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Äñongante Itota ïñömö, —Ïïmaïne ante nänö wææ angaïne ïñömö edæ tæ̈ïne pönï ëne ïñonte mönö nanguï ëñente cædinque waa cæcæ̈impa, angantapa. “Idægoidi, ämo ëñëedäni. Wængonguï mönö Awënë ïñömö, tömengä adocanque ïnongä inte edæ näwä Awënë ïnongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mänömaï Awënë Wængonguï ingampa, ante adinque bitö mïmö entawente tömengä ingante waadedinque önöwoca ëwocabi inte ædæmö waadete pönencæbiimpa. Ayæ̈ edæ bitö ocai encabi inte nö pönëninque bitö baö tæ̈ï pïñænte ëñabi inte edæ godö waadete cædinque tömengä ingante waa waadete pönëe,” ante nänö yewæ̈mongaïne tæ̈ïne ïñonte mönö nanguï ëñente waa cæcæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ayæ̈ wade nänö angaïne adobaï tæ̈ïne ïñonte mönö ëñente waa cæcæ̈impa. “Nämä bitö waadete waa cædö baï adobaï pönëninque bitö wadäni ïnänite adobaï waa waadete cæe.” Mäninque. Ïïmaï cæedäni, ante Wængonguï nänö wææ angaïnö ante tæ̈ïneda baï wade edæ dæ ampa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ante apæ̈necä ëñëninque në wææ odömongä ïñömö, —Awënë në Odömömi näwangä edæ ante apæ̈nebi ëñëmopa. Wacä wængonguï dæ äñongante adocanque mönö Wængonguï ïnongä ingampa, ante nö ämipa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ïninque tömengä ingante mïmöno entawente waadedinque mönö ocai encamö inte nö pönëninque mönö baö tæ̈ï pïñæ̈mö inte godö Wængonguï ingante waadete cædinque nämä mönö pönënö baï wadäni ïnänite adobaï waadete godö waa cæmö adinque Wængonguï waa acampa. Näwangä impa. Baö bataa iya tante godömö incæ, Wængonguï quï, ante mönö ancaa godömö incæ Wængonguï ayongä wædænque waa cæte impa. Wæætë mänïnö bitö änïnö baï cæmö adinque Wængonguï godömenque waa acampa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ante në wææ odömongä nö ëñente apæ̈necä wædinque Itota edæ, —Bitö Wængonguï Awënë Odeye nempo obo pönï ongömi inte guiibaïmipa, ante awædö. Angä ëñëninque tömänäni, Mönö æbänö godömenque anguïï, ante guïñënete wædinque pæ wëënegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pæ wëënedäni adinque Itota ayæ̈ Wængonguï oncö ñæ̈næncö yabæcönë ongöninque odömonte apæ̈necantapa. —Dodäni näni wææ yewæ̈mongaïnö ante në odömönäni ïñömö mönö Codito ingantedö ante apæ̈nedinque, Awënë Dabii wodi pæ̈ingä ïnongä ingampa, ante quïnante änänii, ante pönëmïni. ");
INSERT INTO aucNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ïñæmpa Dabii wodi incæ Wængonguï Tæiyæ̈ Waëmö Önöwoca tönö apæ̈nedinque, “Botö Awënë ingante apæ̈nedinque Awënë Wængonguï incæ ïïmaï ante apæ̈negacäimpa. Bitö botö tömëmæ̈ ïnö tæ̈ contate ongöñömi, Bitö ïmite në pïïnäni ïnänite bæ tabo ate, bitö önöwa gäänë ongönäni ïnänite pïnä gäwacæbiimpa.” Ante Awënë Dabii wodi incæ yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Codito ïnongä ingampa, ante awënë Dabii wodi nänö në angaingä ïnongä inte edæ adocä Codito ïñömö ædö cæte näëmæ̈ Awënë Dabii wodi pæ̈ingä inguingää, ante pönenguënë änewëmïnii. Mänömaïnö ante Itota odömonte apæ̈necä ëñëninque tæiyæ̈näni godongämæ̈ ongönäni waa ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Itota godömenque ïïmaï ante odömonte apæ̈negacäimpa. “Cædämaï, ante wææ ante näni yewæ̈mongainta në ate odömönäni ïnänite mïnitö gomö aedäni. Tömënäni ïñömö doyæncoo waëmoncoo wëñate mongænte todänipa. Waodäni näni godonte æ̈ïñömö cægöñönänite wadäni pö bee tëninque tömënäni ïnänite, Në odömömi, bitö ïmite waa amönipa, ante apæ̈nedäni ëñëninque edæ në odömönäni ïñömö nanguï todänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ayæ̈ tömënäni odömöincönë go guiidinque tömënäni nämanque ante pönëninque waëmompaa pönï tæ̈ contate todänipa. Ayæ̈ æ̈æ̈mæ̈ becæ godinque tömënäni, Botö täno bete tocæboimpa, ante waëmompaa pönï tæ̈ contate bete todänipa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ayæ̈ owæmpoïnäni oncö yo mongænte baï cædinque ö æ̈wënäni inte në wææ odömönäni ïñömö, Botö ïmote waa acædänimpa, ante cædinque Wængonguï ingante nöingä apæ̈nete baï cædinque babæ cædinque wantæpiyæ̈ tededänipa. Tömënäni godömenque näni nanguï pönï pante wæquinque mänömaï nämä beyænque ante cædänipa, ante adinque mïnitö ïñömö ee gomö aedäni,” ante Itota wææ angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mänïñedë Wængonguï oncö yabæcönë ïñömö, Wængonguï quï, ante näni wënoncadedë da wënönänimpa. Mänincönë pö guiidinque tömënäni näni da wënoncade gäänë tæ̈ contadinque Itota a ongöñongä nanguï ïnäni adoyömö pöninque daga daga wënäni acantapa. Pancadäniya nanguï ëadäni inte nanguï pönï da wënäni acantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ayæ̈ a ongöñongä owæmpoingä ömæpocä inte önontamonque incæ mentamonga ænte mämö daga wengantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Adinque Itota tömengä nänö në ëmïñæ̈näni ïnänite aa pecä pönäni ate, —Näwangä ante apæ̈nebo ëñëedäni. Wadäni tömänäni wædænque pönï godonte baï wïï eyepæ̈ daga wëñönäni ïingä owæmpoingä ïñömö ömæpocä inte wædongä incæte godömenque nanguï godonte baï godongä abopa. ");
INSERT INTO aucNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Edæ mänïnäni guiquënë nanguï ëadäni ïnönäni inte, Quëwenguinta impa, ante cö cædinque tömënäni näni wïï æ̈ïnentaque ayæ̈ ongöintaque godönänipa. Ïingä ömæpocä ingä guiquënë tömengä nänö quëwenguinta incæ, Wængonguï quï bacæ̈impa, ante tömanta edæ daga wengampa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mänïï Wængonguï oncö ñæ̈næncö yabæcönë ongonte ïinque apæ̈nete tao goyongä tömengä nänö në ëmïñængä adocanque Itota ingante, —Awënë në Odömömi ëñëmi, angantapa. Dicacoo wainca wæ̈nömënæca wæ̈nömënæca näni mæ̈nongaincacoo waincö ongö cöwä ae. ");
INSERT INTO aucNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Äñongante edæ, —Bitö guiquënë, ñæ̈nængade näni mæ̈nongaincö ongö abii. Mänincoo mïni acoo incæ tömanca bæ tadäni wæænca adinque panguïmæ̈ panguïmæ̈ godinque dica adocaque pönï incæ wæ̈nömënæca ongönämaï ingæ̈impa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mänïï taodinque Odibowænquidi go æidinque tömënäni Wængonguï oncö ñæ̈næncö gomö näni ayömö tæ̈ contayongä Pegodo tönö Tantiago, Wäö tönö Æntade mänimpodäni Itota ingante awëmö änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Mänïï bitö änïnö ante æyedënö ïinque baquïï, ante ëñencæte ante wæmönipa. Ayæ̈, Ïïmaï cæbo ate mïnitö, Oo pönï impa, ante ëñencæmïnimpa, ante Wængonguï æbänö mä cæquingää, ante apæ̈nebi ëñëmaïmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ante wæyönänite Itota, “Wapiticæ̈ odömöñönäni mïnitö wæætë, Mönö oda cædämaï ingæ̈impa, ante nämä wææ aquënë quëwëmïnii. Edæ ïïmaï baquï ï ataqueedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Edæ wadäni nanguï ïnäni babæ tedete pöninque botö ëmöwo ante, ‘Botö mänïmodö ïnömo ïmopa,’ ante apæ̈nedinque wapiticæ̈ edæ mäodäni godinque nanguï ïnäni tömënäni mïñæ̈ oda cæte wapiticæ̈ gocædänimpa,” ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ayæ̈, “Wabæca awënë tönö pö bee tëninque wæætedö wæætë cædapa, ante tededäni ëñencæmïnimpa. Ayæ̈ wayömö näni guëadö guëa cæte wæ̈nönö ante tededäni incæte edæ guïñente wædämaï ïedäni. Edæ mänïnö botö änïnö baï cöwë bacæ̈impa. Ba incæte mönö inguipoga quëwënö ïñömö mänïñedë wïï æ̈mæ̈wo ïinque bacæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Adobæca quëwënäni ïñönänite wabæca quëwënäni ponte bee tëninque guëadö guëa cæquïnäni ïnänipa. Adobæca awënë odeye nempo quëwëñönänite wabæca awënë odeye tontadoidi mämö bee tëninque guëadö guëa cæte wæ̈nonte wænguïnäni ïnänipa. Ayæ̈ wayömö wayömö goinque pö wæcædänimpa. Ayæ̈ waodäni näni cæ̈ïnente wænguinque cænguï incæ tömää capo wængæ̈impa. Mänïï wëñæ̈ mä nantate baï wæwente bamïni incæte mïni godömenque wæwenguinque ingæ̈impa.” ");
INSERT INTO aucNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ante apæ̈nedinque Itota godömenque, “Tömëmïni nämä incæ wææ aaedäni. Edæ mïnitö ïmïnite bæi ongöninque edæ në apænte änäni weca mäo pædæ godönäni æncædänimpa. Ayæ̈ godömenque tömënäni odömöincönë mäo gönönäni gongæ̈ñömïni mïnitö ïmïnite tæi tæi pancædänimpa. Ayæ̈ botö beyænque pancabaa awënëidi gobedönadodoidi weca ayæ̈ tömämæ awënëidi odeyeidi weca mäo gönönäni gongæ̈ninque mïnitö botö beyæ̈ apæ̈necæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Edæ ïinque bayedë botö äñedë ayæ̈ badämaï ïñonte, Botö æ̈mo beyænque quëwencæmïnimpa, ante waa pönï botö apæ̈nedö ante tömämæ quëwënäni doyedë ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ïninque mänïñedë mïnitö ïmïnite näni bæi ongonte ænte goyedë, Në apænte änäni weca ongöninque æbänö ante apæ̈nequïmoo, ante wædämaï ïedäni. Edæ, Æbänö waa apæ̈nequïï, ante Wængonguï Tæiyæ̈ Waëmö Önöwoca apæ̈necä ëñente ate apæ̈necæmïnimpa. Wïï nämä pönëninque wæætë Wængonguï nänö apæ̈nedö ëñëninque apæ̈necæmïnimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Mänïñedë edæ näna caya ïñönate adocanque näëmæ̈ pïïninque, Wæ̈noncæ, äninque tömengä tönïñacä ingante da godongä gocæcäimpa. Näna wencaya ïñönate mæmpocä ïñömö näëmæ̈ pïïninque, Wæ̈noncæ, äninque tömengä wengä ingante da godongä gocæcäimpa. Ayæ̈ wëñæ̈näni incæ wæmpoda ïnate näëmæ̈ pïïninque mäo apæ̈nedäni ëñëninque wadäni tömënäni wæmpoda ïnate mämö wæ̈nönäni wæncædaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ayæ̈, Coditoidi ïmïnipæ̈æ̈, ante tömänäni botö ëmöwo beyænque mïnitö ïmïnite nanguï pïincædänimpa. Pïïnäni wæwëmïni incæte æcänö ïïmæca ïinque baganca wæntædämaï inte botö ëmöwo beyæ̈ pïinte badämaï ïnaa botö tömengä ingante æ̈mo beyænque quëwencæcäimpa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ayæ̈, “Wadäni pö ñömæ̈ï baï öö wadö näni wo ëwenguïmämo incæ tæiyæ̈ waëmö ïñömö ænte mämö cö cæcædänimpa, ante doyedë yewæ̈mongatimpa. Docä nänö yewæ̈mongainta adinque në adingä ïñömö tömengä do ëñëmaingampa. Ïincayæ̈ ate cö cædäni ongö adinque edæ mänïñedë Oodeabæ quëwëmïni ïñömö änanquidi do wodii wïnonte æibäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ayæ̈ oncömanca ongömïni ïninque mäincoo æncæte ante oncönë wæi guiidämaï inte oncömancaque oncömancaque wodii wïnömäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ayæ̈ në gönea cæmïni ïninque yacoo æncæte ante oncönë ocæ̈ ëmæ̈nämaï inte godömenque wodii wïnömäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mänïönæ ïinque bayedë yædëmadä ïnäni tönö goömæ̈ në gänönäni tönö tömënäni näni wæquïmämo baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ayæ̈ mïnitö mïni wodii wïnonguïönæ ante pönëninque edæ Wængonguï ingante, Wïï edæ cöönædepo bacæ̈impa, ante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Edæ mänïñedë waodäni nanguï näni wæwëmämo näni angä baquïnö anguënë. Edæ Wængonguï nänö badongaïñedë mänömaï näni wæwëmämo baï dæ äñonte ayæ̈ godömenque ñöwo ganca dæ änompa. Ayæ̈ godömenque ïinque baganca mänömaï näni wæwenguïmämo baï dæ anguïnö anguënë.” ");
INSERT INTO aucNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Edæ wantæpiyæ̈ näni wæwenguï impa, ante adinque Wængonguï, Mänimpoönæque edæ wæwencædänimpa, ante pönömenque ante änämaï ingä baï quingänö quëwenguënë dæ ancædönänimpa. Incæte Wængonguï, Mänimpodäni ïnänite apænte æ̈mo beyænque në quëwenguïnäni ïnänipa, ante nänö apænte ængaïnäni ïnänite waadete pönëninque dobæ, Mänimpoönæque wæwencædänimpa, ante cædinque pönömenque angacäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ayæ̈, Ïinque bayonte æbänö inguïï, apæ̈nedinque Itota godömenque ïïmaï ante apæ̈necantapa. “Mänïñedë wadäni mïnitö ïmïnite, ‘Ïñömö mönö Codito ponte ongongä tamëñedäni,’ ante ayæ̈, ‘Wayömö a ongongä atamönipa,’ ante tededäni ëñëninque edæ mïnitö ïñömö ëñënämaï ïmäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wadäni mänïñedë ponte a ongöninque nämä incæ ante, Tömëmo Codito ïnömo ïmopa, ante babæ ante tedequïnäni. Ayæ̈, Wængonguï beyæ̈ në apæ̈nebo ïnömo ïmopa, ante në babæ ante tedequïnäni. Tömënäni, Wængonguï nänö apænte ængaïnäni incæ æ̈mæ̈wo oda cædinque wapiticæ̈ gocædänimpa, ante cædinque bamönengæ̈ baï cædinque öönædë cæï baï cædinque nö odömonte baï cæquïnäni ïnänipa. Incæte Wængonguï në apænte ængaingä inte edæ ee aquingä diyæ̈ æ̈mæ̈wo oda cædinque wapiticæ̈ goquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Edæ ïinque badämaï ïñonte botö ñöwo do apæ̈nebo ëñente cæedäni. Oda cædämaï incæboimpa, ante nämä wææ aabäewedäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Äninque Itota ayæ̈ godömenque apæ̈nedinque, “Mänïï näni wæwëmämo näni angä ïinque go ate nænque ïñontobæ̈ wëmö badinque apäicä apäidämaï ingæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nëmoncoo öönædë ïnö wææ̈ tæ̈ wææ̈ninque waa tæ̈ waa tæ̈ wæængæ̈impa. Öönædë tæ̈ï ongongaincoo incæ wancæ wancæ cæte baï wapiticæ̈ goquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mänïñedë edæ botö Waobo në ëñagaïmo inte boguïmancodë pöninque tæ̈ï pönï pïñæ̈mo ïninque edæ ñäö apäite baï waëmö ëmonte wææ̈mo acædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mänömaï pöninque botö anquedoidi ïnänite ämo godinque tömënäni æ̈mæ̈nö betamonca æ̈mæ̈nö betamonca boguïmä näni pö goïnö godinque inguipoga tömäne godinque öönæ tömäne godinque Wængonguï nänö apænte ængaïnäni ïnänite äñete poncædänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ante Itota godömenque apæ̈nedinque, “Iigowæ̈ æbänö ïwæ̈, ante odömonte apæ̈nebo ëñëninque pönëedäni, angantapa. Tömëwæ̈ mïïwæ̈ badinque iigowæ̈ wayabo tänä nä boca adinque mïnitö, Öñabo nänö bocaïnepo inte nænque näwantedæ̈ baquinque bocapa, ante pönëninque edæ do ëñëmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ayæ̈ adobaï mänïnö botö apæ̈nedö baï edæ do ba adinque mïnitö, Waocä në ëñagaingä do odemö pönï ongöninque inguipoga oo poncæcäimpa, ante ëñencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Näwangä ämopa. Ñöwomïni ayæ̈ mïïmïni quëwëninque wænte godämaï ïñömïni mänïnö botö apæ̈nedïnö baï tömänö edæ do ïinque baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Edæ öönædë ongöñömö inguipoga tönö wo ëwente baï dæ ba incæte botö angaïnonque guiquënë dæ badämaï inte edæ cöwë tæ̈ï ongongæ̈impa,” angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ayæ̈, “Mänïönæ æyedënö ï, ante, Mänïnepo ædepodö ï, ante ëñencæte ante mïni wædïnö ante æcämenque incæ ëñënämaï ingampa. Tömänäni ëñënämaï ïñönäni edæ Wængonguï anquedoidi incæ ëñënämaï ïnänipa. Wæmpocä Wëmo incæ ëñënämaï ïñömote Wæmpocä ïñömö tömengä adocanque incæ edæ në ëñengä ingampa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Äninque ayæ̈ godömenque apæ̈nedinque Itota tömënäni ïnänite ïïmaï angantapa. “Ïninque, Æyedënö baquïï, ante ëñënämaï ïmïni inte edæ mönämaï mïïmïni wänö cöninque edæ Wængonguï ingante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Botö ponguïnö ïñömö waocä ëacä nänö cæï baï impa. Ïingä waocä ïñömö wabæca gocæ cædinque, Botö ïmote në cædäni në änäni badinque botö oncö waa aacædänimpa, ante adocanque ingante, Mäninganca cæe, wacä ingante edæ, Mäninganca cæe, wacä ingante, Mäninganca cæe, ante odömöninque odemö wææ a congä ingante, Cöwä ae, äninque wadæ gocä. ");
INSERT INTO aucNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ïninque botö në ëacä baï ïñömote mïnitö, Mönitö Awënë æyedënö ponguingää, ante ëñënämaï ïmïni inte gäwadecæ̈ ayaönæ̈nëña tawadiya peyedë ñäö ba, æyedëmë poncæcäimpa, ante wadö conguënë cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Edæ, Wïï mö ñömöni ponguingä ingänö anguënë, ante cædinque mïïmïni quëwëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mïnitö ïmïnite botö änö ante tömänäni ïnänite adobaï, Wänö conguënë quëwëmïnii,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mëönaa go ate wodo pænta gogaïönæ baï Patowa æ̈æ̈mæ̈ baquimpa, ante pönëninque oodeoidi ñöwo, Päö yedæ æmpoquï ömæmö ï mönö cænguïönæ inguimpa, ante cædönänimpa. Mänïñedë, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në wææ ante odömönäni ïñömö, Mönö awëmö cæte Itota ingante bæi ongonte ænte mäo wæ̈nongæ̈impa, ante cædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Oo pönï impa, ante wædinque awënëidi, —Ïñæmpa æ̈æ̈mæntedæ̈ ïñonte wæ̈nömö baï tömänäni ænguï bate Yæ yæ ante pïinte cæcædönänimpa, ante adinque mönö ædö cæte mänïñedë cæquïï, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Itota ïñömö Betänia godinque në baadingä Timönö oncönë go guiite ëñacantapa. Guii ëñate cæncöñongä onquiyængä adoyömö pö guiicantapa. Tömengä oguï wapæ̈ näwä näadodopæ̈ näni änömæ̈ nänö nanguï godonte æ̈nïmæ̈ dica adabatodo waincadedë pe ñïñænte mäningä inte ñöwo ænte mämö Itota weca pongantapa. Pöninque tömengä mänincade wencade ao mæ̈nodinque Itota ocaboga edæ gao cæcacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Adinque godongämæ̈ ongönäni pancadäniya ænguï badinque näni caboque tededinque, —Ïñæmpa oguï wapæ̈ incæ önonque guënente baï cæcampa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Edæ waocä adoque wadepo cæte beyæ̈ paga æ̈ninque todetiento deënadiota näni æ̈ninta ayæ̈ godömenque æ̈ninta beyæ̈ godonte ænguënëmæ̈ ïmæmpa. Godonte ænte baï ömæpodäni ïnänite wæætë godonguënë apa. Ante nämäneque tededinque onquiyængä ingante nanguï pïinte änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Itota wæætë, —Quïmæ̈ pïïwëmïnii. Ïingä onquiyængä ïñömö botö ïmote waa pönï cæcä apa quëwëmïnii. Ee aquënë quëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Edæ ömæpodäni mïni änïnäni mïnitö weca cöwë quëwënäni adinque mïnitö æyedëmë tömënäni beyæ̈ waa cæïnëmïni inte edæ do waa cæbaïmïnipa. Botö guiquënë mïnitö weca wïï wantæpiyæ̈ ongoncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Adinque mänïmæ̈ oguï wapæ̈ botonga gadongadinque tömengä edæ botö baö daga wenguinque eyepæ̈ ïñonte öni paacantapa. Ïninque tömengä nänö cæganca ante do cæcä apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mïnitö ïmïnite näwangä ante apæ̈nebopa. Tömämæ æyömömë wadäni näni ëñente toquinque botö ïmotedö ante apæ̈nedäni ëñënänii mäningä onquiyængä nänö cædïnö ante adobaï tededäni ëñente pönencædänimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ayæ̈ mänïñedë näni, Dote, äincabo ïñönäni adocanque Codaa Icadiote näni änongä ïñömö, Itota æyömönö ongongää, ante odömonte pædæ pönömo æncæmïnimpa, ante cædinque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni weca wadæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Godinque tömengä, Ïïmaï cæcæboimpa, ante apæ̈necä ëñëninque awënëidi nanguï todinque Ao äninque, Cæbi ate tiguitamö pönömöni æncæbiimpa, änäni. Ëñëninque Codaa Ao äninque, Æbänö cæte godö odömömo ænguïnänii, ante cöwä adinque ancaa cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Oodeoidi päö yedæ æmpoquï ömæmö ï näni cænguïönæ tæcæ ba ate tömënäni, Wodo pænta gogaïönæ baï Patowa mönö cænguïönæ impa, ante pönente cædinque, Wængonguï quï impa, ante codotedo mänïönæ edæ cöwë wæ̈nönönänimpa. Ïninque mänïönæ ïinque ba adinque tömengä nänö në ëmïñæ̈näni Itota ingante äninque, —Ædönö ämi gote mönitö Patowa æ̈æ̈mæ̈ ante cæmöni ate bitö bete cænguïmii. ");
INSERT INTO aucNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Änäni ëñëninque Itota tömengä nänö në ëmïñæ̈na mënaa ïnate da godöninque, —Mänïï nanguï näni quëwëñömö gote taadö goyömïnate onguïñængä incæ cadabodë æpæ̈ iyænte næ̈ænte pö bee tengä adinque mïnatö tömengä mïñæ̈ tee empote goeda. ");
INSERT INTO aucNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tömengä æcönënö guiicä adinque mänïï oncö në ëacä ingante äninque mïnatö, “Mönö Awënë në Odömongä inte ïïmaï angampa. Bitö oncönë guicönë æcönënö ante, Bitö oncö, ante ämi guiidinque botö në ëmïñæ̈näni tönö botö Patowa æ̈æ̈mæ̈ bete cænguïmönii, angampa.” ");
INSERT INTO aucNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ante äñömïnate tömengä æ̈mongapaa mæ̈i odömöninque ñæ̈næncö awæmpa nänö do cönöincö odömongä adinque mïnatö mänincönë mönö beyæ̈ tömää eyepæ̈ cæcæmïnaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Angä ëñente tao godinque näni quëwëñömö ponte ayöna, Itota nänö änö baï tömää do cæte ongompa, ante adinque tömëna Patowa æ̈æ̈mæ̈ ante cædatapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gäwadecæ̈ bayonte dote ïnäni näni cabo Itota mïñæ̈ godongämæ̈ pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ponte tæ̈ contate cæncöñönänite Itota, —Näwangä ante apæ̈nebo ëñëedäni. Mïni cabo incæ adocanque botö tönö ñöwo godongämæ̈ cæncongä incæ, Æncædänimpa, ante botö ïmote odömonte pædæ godonguingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ante apæ̈necä ëñëninque, Wæïnente awædö, ante pönëninque tömengä ingante adocanque adocanque äninque tömänäni adoyömö, —Botö ïmotedö ante dicæ apæ̈nebitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Äñönäni Itota wæætë, —Önompo tipæmpoga go mëmïnaa ïñömïni adocanque botö tönö guëa adotaca mï cæte cængä incæ tömengä në cæquingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Edæ dodäni Wængonguï beyæ̈ ante näni yewæ̈mongaï baï cædinque botö Waobo ëñagaïmo inte cöwë wænte goquënëmo ïmodö anguënë. Incæte botö ïmote në odömonte godönongä guiquënë tömengä nänö wæquinque cæquingä ingampa. Mäningä wïï ëñate baï waa toquënengä incædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ayæ̈ tæcæ cæncöñönäni Itota päö bæi ongonte æ̈ninque Wængonguï ingante waa ate apæ̈nedinque päö pä æ̈ninque tömënäni ïnänite pædæ godö pædæ godö cæcantapa. —Botö baö baï impa, ante pædæ pönömo æ̈ninque mïnitö Ao ante cæ̈edäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Äninque ayæ̈ bequïmæ̈ owætaca bæi ongonte æ̈ninque Wængonguï ingante waa ate apæ̈nedinque pædæ godöninque nënempocä æ̈ninque tömänäni bedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Beyönäni tömënäni ïnänite apæ̈nedinque, —Botö wepæ̈ ïïmæ̈ baï impa. Wængonguï do apæ̈nedinque, Botö pönö cæbo ate mïnitö Ao ämïni ïninque mönö godongämæ̈ waa cæte quëwengæ̈impa, angacäimpa. Ñöwo adobaï mïïne äninque apæ̈nebopa. Botö wepæ̈ ante Ao ante æ̈mïni inte mönö godongämæ̈ waa cæte quëwengæ̈impa. Edæ nanguï ïnäni beyæ̈ gowequïmæ̈ impa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Botö ïñömö Awënë Odeye badinque ocæ̈ ëmænte pöninque mïïmæ̈ botö beganca mänïmæ̈ yowepæ̈ ñöwo æ̈mæ̈wo bebo tamëñedäni, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ayæ̈ Wængonguï ingante ämotamïni ante tao godinque Odibowænquidi godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Goyönänite Itota ïïmaï ante apæ̈necantapa. —Dodäni Wængonguï beyæ̈ yewæ̈möninque, “Në aadingä ingante tacabo dæ wængä ate cæ̈ningäidi obegaidi wæætë panguïmæ̈ goquimpa,” ante näni yewæ̈monte angaïnö baï cædinque botö dæ ämo beyæ̈ guingo imonte wædinque tömämïni edæ näwæ̈ goquïmïni ïmïnipa, ante awædö. ");
INSERT INTO aucNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Panguïmæ̈ gomïni incæte botö edæ ñäni ömæ̈monte Gadideabæ täno gote a ongöñömo mïnitö ayæ̈ pöedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Angä ëñente wædinque Pegodo guiquënë, —Ïñæmpa dæ ämi beyæ̈ tömänäni guingo imonte badinque panguïmæ̈ godäni incæte edæ botö guiquënë cöwë panguïmæ̈ godämaï incæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Äñongante, —Bitö ïmite näwangä ante apæ̈nebo ëñëe. Ñöwoönæ woyowotæ̈ incæ tawadiya mempoga pedämaï ïñonte bitö ïñömö botö ïmotedö ante wadö ante apæ̈nedinque, Dicæ abogaa, ante mempoga go adopoque anguïmi ïmipa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Angä ëñente wædinque Pegodo wæætë, —Ïñæmpa botö bitö tönö wæ̈mo incæte mänïnö ante cöwë änämaï incæboimpa. Ante nanguï äñongä tömänäni adodö ante apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mänïï godinque yabæ incæ Guetëmänii näni äñömö pöninque tömengä mïñæ̈ në godäni ïnänite Itota, —Tæ̈ contate ongöñömïni botö godömenque gote Wængonguï ingante apæ̈nete pömoedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Äninque Pegodo Tantiago Wäö mänimpodänique ïnänite ænte mäocä goyönäni Itota ïñömö nanguï wæwente badinque guïñente wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ayæ̈ tömënäni ïnänite, —Botö wæwëmämo entawëninque pæ̈mænte wæte wænguï wædö. Mïnitö guiquënë tæ̈ contadinque ëamonca wänö cöedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Äninque wædæ pö gote ædæ wæænte guidömëmæ̈ ñongæ̈ninque Wængonguï ingante, Bitö Ao ämi botö caate wæquintedæ̈ wïï ba ate waa tobaïmopa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Äninque, “Mæmpo, botö Wæmpo ëñëmi. Bitö tæ̈ï pïñæ̈mi ïnömi ïmipa. Bitö tï nä wænguïmæ̈ baï ö ænte baï cædinque botö ïmote edæ, Wæ̈nämaï incæbiimpa, ämi ïninque botö edæ waa tobaïmopa. Incæte botö änönö baï wïï cædinque wæætë tömëmi änönö baï cæe,” ämopa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Äninque tömënäni weca adodö ponte ayongä mö ñönäni adinque tömengä Pegodo ingante, —Timönö edæ mömitawo. Botö tönö wänö conguënëmi incæ bitö adoque oda ganca incæ wïï aacömii. ");
INSERT INTO aucNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Edæ, Mïmöno waa cæïnëmönipa, ante ëwocayömïni baö aquïïñö ëñamïni inte wæntæye bamïnipa. Ïninque edæ mïnitö wänö cöninque nämä beyænque Wængonguï ingante apæ̈nedinque edæ, Wïï wënæ wënæ cæïnëmöni bacæmönimpa, ante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Äninque Itota wæætë wadæ godinque wëënë nänö änïnö baï apæ̈nedinque Wængonguï ingante adodö ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ayæ̈ adodö ponte ayongä möwo möïnente ædo ædo cædinque mö ñönäni acantapa. Acampa, ante wædinque tömënäni, Æbänö anguïmöö, äninque edæ pæ wëënedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Itota wæætë mempoga go adopoque gote apæ̈nedinque ñöwo adodö pöninque edæ tömënäni ïnänite, —Ayæ̈ edæ guëmante mö ñömïnii. Edæ idæwaa. Ñöwo ïinque cætimpa. Botö Waobo ëñagaïmo inte edæ botö wæwenguïönæ do edæ ba ïninque në wënæ wënæ cædäni nempo në pædæ godömoncæ cædingä ïñömö botö ïmote do odömonte godongäï ataqueedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ñöwo edæ ængæ̈ gantidinque mönö gocæ̈impa. Botö ïmo në odömonte godonguingä ïñömö edæ obo pönï pongä tamëñedäni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ayæ̈ apæ̈neyongä edæ Codaa wodi tömënäni näni, Dote, ante gocabo adocabo ïningä incæ ñöwo pongantapa. Do ïñömö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në wææ odömönäni tönö në aadäni näni Picæncabo tönö wadäni ïnänite, Codaa mïñæ̈ goedäni, ante da godönönänimpa. Ñöwo ïñömö tömënäni näni në da godönäni inte tæiyæ̈näni yaëmë næ̈ænte canta næ̈ænte Codaa mïñæ̈ pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Doyedë ïñömö në odömonte godoncæ cæcä Codaa ïñömö tömengä mïñæ̈ poncæ cædäni ïnänite ïïmaï ante wëënëñedë apæ̈nedingä ïnongäimpa. “Botö odömonte queë bemömo adinque mïnitö wæætë, Tömengä ingampa, ante adinque tömengä ingante bæi ongonte æ̈ninque wææ cæte mäomïni gocæcäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ante do äningä inte Codaa ïñömö ñöwo Itota weca pöninque, —Awënë në Odömömi ïmi. Äninque edæ waa cæte baï edæ queë bemongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mänömaï queë bemonte odömongä adinque tömengä mïñæ̈ pönäni incæ Itota ingante pædæ gopo bæi ongonte æ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä ingante në cæcä incæ mänïñömö ponte a ongongä adinque Itota gäänë ongongä adocanque pædæ guiipote yaëmë o togænte æ̈ninque mäningä në cæcä ingante tæi päninque önömonca wangö tamoncacantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Adinque Itota ïñömö ñöwo pönäni ïnänite, —Mïnitö ïñæmpa, Bitö në ö æ̈nïmi ïmipa, ante baï cædinque botö ïmote canta tönö yaëmë næ̈ænte ö æncæte ante pömïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ïñæmpa Wængonguï oncö ñæ̈næncönë yabæcönë ïïmö ïñö ïïmö ïñö apæ̈necöninque botö mïnitö weca a ongöñömote mïnitö edæ bæi ongönämaï ee amïnitapa töö. Incæte Wængonguï angä ëñente näni yewæ̈mongaïnö baï ïinque baquinque ante cæcæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ante apæ̈neyongante tömänäni edæ ëmö cæte wodii wïnönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Adocanque edëningä guiquënë ömaacä inte yabæcooque nïnocoo näni ancooque pönö wïniyate Itota mïñæ̈ gocantapa. Tömengä ingante yao ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Adinque tömengä wæætë gä tadongate weocoo ömaacä wodii wïnongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä weca ænte godinque Itota ingante gönönäni gongænte ongongantapa. Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në aadäni näni Picæncabo tönö në wææ odömönäni tönö tömänäni pö bee bee bee tente godongämæ̈ ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pegodo guiquënë tömengä mïñæ̈ ayæ̈ ayæ̈ godinque, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä oncö yacömoyæ̈ ïñömö wäänë guiicantapa. Mänïñömö guiidinque tömengä wææ wänönäni tönö gongapamö tæ̈ contate a ootocongantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në Apænte näni Änoncabo tömänäni, Mönö apænte ante wæ̈nömö wæncæcäimpa, ante cædinque, Itota nänö wænguinque wënæ wënæ cæcä ingampa, ante æcänö në adingä inte godö anguingää, ante ancaa diqui diqui mïñönäni mänömaïnö ante në anguënengä edæ dæ angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Edæ nanguï ïnäni pöninque babæ apæ̈nedinque, Mänömaï cæcä atamönipa, ante apæ̈nedäni incæte adoyömö apæ̈nedämaï ïnäni inte wapiticæ̈ wapiticæ̈ änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ayæ̈ ate pancadäniya ængæ̈ gantidinque, Tömengä ingante apænte angæ̈impa, ante cædinque babæ wapiticæ̈ ante äninque, ");
INSERT INTO aucNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ïingä ïïmaï ante apæ̈necä ëñentamönipa. “Ïincö Wængonguï tæiyæ̈ waëmö oncö waodäni önompoca näni mæ̈nönincö incæte botö cæbo wo tænguïmæ̈ wæænguimpa. Ayæ̈ mëönaa go adoönæque ïñonte wacö wïï önompoca mæ̈nonguincö wæætë mæ̈noncæboimpa,” ante apæ̈necä ëñentamönipa töö, ante tededäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Incæte adodeque ante apæ̈nedinque adoyömö äninque tömënäni godömenque äninque wadö wadö wapiticæ̈ ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ëñente wædinque, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä guiquënë godongämæ̈ ongönäni tönö tæcæguedë dibæ ongonte ængæ̈ gantidinque Itota ingante, —Ïñæmpa pæ wëënebii. Bitö æbänö cæbitapa, ante ïïnäni näni änïnö ante bitö æbänö ämii. ");
INSERT INTO aucNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ante äñongante edæ Itota cöwë änämaï pæ wëënecä. Adinque në godongä ñæ̈nængä pönï ïnongä wæætë godö äninque, —Wængonguï mönö Waëmö ïnongä Wengä mönö Codito ïnongä ingampa. Bitö ïñæmpa mänïmidö ïnömi ïmitawo. ");
INSERT INTO aucNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Äñongante Itota ïñömö, —Ao. Mänïmodö ïnömo ïmopa. Ïninque ïincayæ̈ ate botö Waobo ëñagaïmo inte Wængonguï në Tæ̈ï Pïñængä ingä tömëmængä ïnö tæ̈ contabo adinque mïnitö ayæ̈ ate botö öönædë boguïmancodë pömo acæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ante apæ̈necä ëñente wædinque në godongä ñæ̈nængä pönï ïnongä ïñömö pïinte badinque, Ëñente awædö, ante baï cædinque edæ nämä weocoo wänä ñæ̈ninque, —Idæwaa, angantapa. Ñöwo wacä ingante, Itota wënæ wënæ cæcä atabopa, ante në äincædongä ingante godömenque diqui diqui mïnämaï ingæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tömengä nämä Wængonguï Wengä inte baï babæ godö tedewengampa töö. Ïninque edæ tömengä babæ nänö änewënö ante do ëñëmïni inte edæ æbänö ante pönëmïnii. Ante äñongante në apænte änäni tömänäni edæ, Nänö pante wænguinque edæ änewengampa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ante apænte änäni ate edæ pancadäniya Itota tömengäa towæ tänongadinque tömengä awinca weocoota pönö ñäne cæmöninque tæi tæi päninque tömengä ingante, —Æcänö pänaa, ante Wængonguï beyænque apæ̈nebi ëñëmönie. Ante badete toyönäni wææ wänönäni guiquënë tömengä ingante bæi ongonte tæi tæi pangadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ayæ̈ Pegodo guiquënë yæipodë yacömöñäa guii contate ongöñongä onquiyængä, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä ingante në cæcä ïñömö adoyömö pö guiicantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ponte ayongä Pegodo gongapamö ootocæ cæcä adinque onquiyængä ædæmö cöwä adinque, —Mäningä Näatadeta ïñömö quëwënongä Itota tönö bitö guëa cægömitapa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Angä ëñente wædinque, —Dicæ. Bitö änö ante æbänö ämii, ante dicæ ëñëmogaa. Äninque tao yabædemö gäänë gongæ̈ñongä tawadiya wëënengä petapa. ");
INSERT INTO aucNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ayæ̈ wæætë Pegodo ingante adinque onquiyængä ïñömö godongämæ̈ ongönäni ïnänite, —Mäningä adocabodäni ïningä inte ongongä ataqueedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ante apæ̈neyongä Pegodo wæætë, Dicæ bitö angänö ïmogaa, angantapa. Ayæ̈ wantæ ate mänïñömö ongönäni adobaï, —Ïñæmpa Gadideabæ quëwënïmi inte bitö näwangä Itota tönö tee empo në pömi ïmipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Änäni ëñente wædinque Pegodo wæætë, Botö Wængonguï ëñëñongä nöingä ämopa, ante Wængonguï ëmöwo ante babæ tedewëninque tömënäni ïnänite wæætë, —Mïni angantedö ingante dicæ abogaa. Dicæ abo ante baï änewëmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ante tæcæ änewëñongä ïñontobæ̈ tawadiya ayængä petapa. Ayængä pe ëñente wædinque Pegodo Itota nänö änïnö ante pönengantapa. Itota do ïñömö, “Tawadiya mempoga pedämaï ïñonte bitö botö ïmotedö ante wadö ante apæ̈nedinque, Dicæ abogaa, ante edæ mempoga go adopoque anguïmi ïmipa,” änongäimpa. Ante pönente wædinque Pegodo, Ñöwo nänö pequinque do pecampa, ante wædinque Ca ca wægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në aadäni näni Picæncabo tönö në wææ odömönäni tönö tömënäni ïñömö në änäni ïnönäni inte oodeoidi näni në Apænte Änoncabo ïnönänimpa. Ïninque mänïï ñäö bayonte tömënäni, Æbänö cæquïï, ante pönente wædinque godongämæ̈ pönëë cöninque Ao äninque Itota ingante goto winte töö æ̈mænte ænte godinque odömäno awënë Pidato wodi nempo mäo pædæ godönäni ængantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pidato guiquënë tömengä ingante, —Oodeoidi Awënë Odeyebi bitö ïmitawoo. Äñongante, —Bitö tömëmi änö baï botö mänïmodö ïmopa, ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wængonguï quï, ante në godönäni ñæ̈næ̈näni guiquënë, Ïingä Itota ïñömö wënæ wënæ cæcampa, ante wadö wadö ante pïïninque Pidato ingante ancaa änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Änäni ëñente wædinque Pidato wæætë Itota ingante, —Ïñæmpa pæ wëënebii. Bitö æpogadö wënæ wënæ cæbi ïmipa, ante nanguï änäni apa quëwëë. ");
INSERT INTO aucNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Äñongante Itota tömënäni näni änïnö ante cöwë apæ̈nedämaï ingä adinque awënë gobedönadodo wæætë, Quïëmë baï pæ wëënecä awædö, ante guïñente wægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mänïmæ awënë gobedönadodo mänïñedë wadepo ïñö wadepo ïñö cöwë ïïmaï cædongäimpa. Oodeoidi æ̈æ̈mæ̈ cæyönänite gobedönadodo ïñömö, Në tee mönete ongönäni ïnänite adinque mïnitö æcänö ingante ämïni ñimpo cæbo goquingää, ante änäni ëñëninque tömengä tömënäni näni äningä adocanque ingante ñimpo cæcä godongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Doyedë wadäni ænguï badinque, Awënë ingante wido cæcæ̈impa, ante cædinque wæ̈nonte cæyönäni adocanque Badabato näni änongä tömënäni tönö godongämæ̈ cædongä ïnongäimpa. Ïninque awënëidi në wïwa cædäni ïnänite bæi ongonte goto wïnäni ongöñönäni Badabato adobaï tömënäni tönö godongämæ̈ tee mömæ̈nete ongönongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ïninque ñöwo ïñömö wadäni tæiyæ̈näni Pidato weca pöninque, Cöwë bitö cædö baï ñöwo adobaï mönitö beyæ̈ cæquïmi ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Änäni ëñëninque Pidato ïñömö, —Oodeoidi Awënë Odeye ingante pönö ñimpo cæbo abæ tawængä ænguïmïnii. Æbänö cæbo ænguïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Edæ do ïñömö Itota gomonga cæcä ate wædinque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni incæ tömengä ingante pïinte adönänimpa. Mänïnö beyænque tömënäni Itota ingante bæi ongonte botö nempo ænte mämö pædæ pönönänimpa. Ante pönente wædinque Pidato, Oodeoidi Awënë Odeye ingante ñimpo cæbo goquingä, ämïnitawoo, ante ñöwo angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ïninque, Wængonguï quï, ante në godönäni ñæ̈næ̈näni guiquënë godongämæ̈ ongönäni ïnänite apæ̈nedinque, Mïnitö Pidato ingante ïïmaï äedäni, änänitapa. Änäni ëñëninque oodeoidi wæætë Pidato ingante, Wïï bitö änongänö ante ämönipa. Wæætë Badabato ingante ñimpo cæbi gocäe, ante änäni. ");
INSERT INTO aucNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ëñëninque Pidato godö äninque, —Ïninque oodeoidi Awënë Odeye mïni änongä ingante æbänö cæquïmoo, ante ämïnii. ");
INSERT INTO aucNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Äñongante tömënäni ogæ̈ tededinque, —Awæ̈ ñænquedïmæ̈ ämi cæte wæ̈nönäni wængäe töö. ");
INSERT INTO aucNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Änäni ëñente wædinque Pidato, —Ïñæmpa quïnö wënæ wënæ cæcantawoo. Äñongante godömenque yedæ äninque adodö, —Ämi awäa timpote wæ̈nönäni wængäe töö. ");
INSERT INTO aucNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ancaa änewëñönäni Pidato ïñömö, Mänïnäni pïïnämaï piyæ̈në cæcædänimpa, ante cædinque Badabato näni äningä ingante godö ñimpo cædinque tömënäni nempo pædæ godongä æ̈nänitapa. Wæætë edæ Itota ingante edæ Pidato wodi angä æ̈montai badöïmenca tæi tæi pänäni ate ñænque quepote awäa näni gönonguinque edæ da godongä ænte godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pædæ godongä ate në tontadoidi tömengä ingante töö æ̈mænte wadæ godinque awënë gobedönadodo oncönë Podætodio näni ancönë mangui guiiyongä tontadoidi bacabo Itota weca godongämæ̈ äñete pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pöninque tömënäni, Awënë ïmi inte awënë weocoo wëñacæbiimpa, ante baï cædinque badete todinque Itota ingante wæætë opatawæ̈ ëmoncoo pönö da wëñadinque daa mongæ̈menca æ̈ninque que cædinque, Awënë poganta, ante baï pönö daga wencadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ayæ̈ Yæ yæ äninque, —Badogaa, bitö oodeo awënë odeyebi ïmipæ̈æ̈. ");
INSERT INTO aucNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ante badete todinque cæ̈wipaca ancaa tæi tæi pancadinque tömengäa towæ towæ tänongadinque da guicapote ædæ wææ̈ninque, Bitö Tæiyæ̈ Waëmö Awënë ïmi amönipa, ante baï badete todänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ayæ̈ ïinque badete todinque tömënäni opatawæ̈ ëmoncoo gä tadongadinque tömengä nämä weocoo da wëñadänitapa. Ayæ̈ edæ tömengä ingante awæ̈ timpote gönoncæte ante töö æ̈mænte ænte tao mäodäni gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mänïñedë Tidëne quëwënongä Timönö guiquënë Adecantodo tönö Odopo tömëna wæmpo ïnongä inte tömengä yabæque gote pönongäimpa. Ïninque Itota ingante ænte godinque ayönäni mäningä Timönö ñöwo wodo tebæ̈ gocæ cædinque pongä adänitapa. Ïninque tontadoidi, Bitö ægodöe. Itota ingante möni timpoquïwæ̈ ænte mongænte goe, änäni ænte mongænte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mänömaï godinque Godogota näni äñömö mönö tededö “Ocataïnö” ïñömö Itota ingante ænte pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mänïñömö pönäni ate wadäni, Nantate beyæ̈ becæcäimpa, ante cædinque biïnömæ̈ näni wædænque tï nämæ̈ tönö mïidapæ̈ näni änömæ̈ adoyömö wempo cædëninque pædæ pönö cæyönäni tömengä önonque yædæ bedinque edæ bedämaï ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ayæ̈ tömengä ingante awæ̈ ñænquedïmæ̈ näni ænte pönïwäa töö godöninque pönö timpodinque wææ̈ tïwadinque ængæ̈ gantidënänitapa. Ængæ̈ gantidënäni ate wægöñongä tömënäni wæætë tömengä weocoo ïnï ante, Æcänö quinca nö ta adinque tömengä mänincoo æncæcäimpa, ante wææntodöninque adocooque adocooque æ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Edæ nænque tömantadæ̈ æ̈ñonte mänïñedë incæ tömengä ingante ïinque timpote edæ ængæ̈ gantidënäni wægongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ayæ̈, Itota wæncæcäimpa, ante quïnante apænte änänii, ante tömänäni ponte adinque ëñencædänimpa, ante yewæ̈möninque, “Oodeoidi Awënë Odeye ïnongä ingampa,” ante yewæ̈möninque awæmpaa wo cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ayæ̈ wada në ö ænte quëwënïna ïnate adoyedë tömengä tönö adocanque tömëmæ̈ ïnö adocanque dipæ̈mæ̈ ïnö godö timpote gantidëdäni wægongadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ïninque, Në ëñënämaï cædäni näni cabo tönö tömengä adocä ingampa, ante Wængonguï angä ëñente näni yewæ̈mongaïnö baï ñöwo ïinque bagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ayæ̈ wodo pænta në godäni guiquënë Itota ingante godö babæ ante badete todinque pica pica cædinque, —Bitö ïñæmpa Wængonguï tæiyæ̈ waëmö oncö incæ bæ tate wo ëwëninque mëönaa go adoönæque ïñonte do mæ̈nonguïmi inte edæ, ");
INSERT INTO aucNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","o togæmpote o togæ̈wate ti wææ̈ninque edæ quëwëmäwe. ");
INSERT INTO aucNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në wææ odömönäni adobaï näni cabo nämäneque godongämæ̈ badete todinque, —Tömengä, Wadäni quëwencædänimpa, ante waa cæcantawoo. Ñöwo ïñæmpa. Nämä beyænque eyepæ̈ cæcampa diyæ̈ quëwenguingää. ");
INSERT INTO aucNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Idægoidi awënë odeye ingä ïninque tömengä ti wæænte gocä adinque mönitö wæætë, Tömengä näwä Codito ingampa, ante pönëmaï wædö. Ante badete toyönäni në ö æ̈na tömengä tönö godongämæ̈ timpote wægöna incæ adobaï Itota ingante pïïninque wënæ wënæ ante badete togadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tæcæbæcä pönï bayö tömämæ ïñontobæ̈ wëmö badinque ayæ̈ ayaönäa wæiganca mæ̈ mämonte baï ïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ïninque ayaönäa wæiyonte Itota nanguï pönï yedæ äninque, “Edoi, Edoi, nëma tabatäni,” äninque mönö tededö, “Botö Wængonguïñaa, botö Wængonguïñaa, ædö cæte botö ïmote ëmö cæte gobiyaa.” ");
INSERT INTO aucNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ante wæcä ëñëninque godämæ̈ ongönäni guiquënë, —Æ. Ediya wodi ingante aa pecä apa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Äñönäni adocanque do pogodo gote önætamö ænte pöninque biïnömæ̈ baï önömænque æ̈ninque aa bedonte næ̈æ̈ninque edæ, Becæcäimpa, ante cædinque cæ̈wipaca pædæ æ̈æ̈nongantapa. —Ee aquënë quëwëedäni. Ediya wabänö ponte o togænte pædæ wææ̈nongä abaimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Angä ate Itota ïñömö wæætë ogæ̈ äninque edæ æ̈mæ̈wo guëmäninque wængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ïninque edæ Wængonguï tæiyæ̈ waëmoncönë weocoo odemö näni wææ wodöincoo adoyedë önönæca ïnö tæcæguedë pönï tænguïmæ̈ wææntapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mänömaï ogæ̈ äninque do wængä adinque tontadoidi awënë capitäö guiquënë, —Näwangä impa. Ïingä ïñömö Wængonguï Wengä ingaïnö ante pönenguënë, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ayæ̈ onquiyæ̈näni Mäadiya Mäagadadënä näni änongä, Otite tönö Tantiagomö badä Mäadiya, Tadömee, mänimpodäni adobaï oo gote gomö a ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tömënäni ïñömö Gadideabæ quëwengäñedë Itota mïñæ̈ gote pönö waa cædïnäni inte ñöwo pö gobæ ongöninque pömö adänitapa. Itota Eedotadëë pö æ̈ñongante wadäni onquiyæ̈nänique godongämæ̈ tee empote pönïnäni inte ñöwo pöninque a ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Oodeoidi näni, Gäwadecæ̈ ba ate guëmanguïönæ inguimpa, ante näni täno cæönæ ingatimpa. Ïninque gäwadecæ̈ oo ba ate wædinque, ");
INSERT INTO aucNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Adïmatea ïñömö quëwëningä inte Ootee, Wængonguï Awënë Odeye nempo mönö æyedënö quëwengæ̈impa, ante wänö conte baï quëwënongäimpa. Tömengä oodeoidi näni Apænte Äincabo adocä ïnongä inte ñæ̈nængä ïnongäimpa. Tömengä ïñömö Pidato weca ñöwo guïñënämaï pö guiidinque, Itota wodi baö pönömi ænte wëmoe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Angä ëñëninque Pidato, Wa. Wabänö wængäï, ante pönente wædinque awënë capitäö ingante äñete pongä adinque, Do wængäï. ");
INSERT INTO aucNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Äñongante edæ, Dobæ wængäimpa, ante apæ̈necä ëñëninque Pidato wæætë Ootee ingante, Itota wodi baö ïnï o togænte æ̈mäwe. ");
INSERT INTO aucNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Angä ëñëninque Ootee ïñömö edæ waëmö weocoo nïno näni änoncoo godonte æ̈ninque Itota wodi baö ïnï wi æmpote wææ̈ wi æ̈wadinque pædæ wææ̈nonte ænte gocantapa. Ayæ̈ mänincoo wïni wïni caate dicamontaa wointatodë guidö ñö cæte daga wëninque dicabo edæ da pæ̈ñæ̈ pönö tee mönogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mänömaï cæyongante Mäadiya Mäagadadënä näni änongä tönö Otite badä Mäadiya mänimpodaque tömengä ingante näni da wënïñömö adatapa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tömënäni guëmanguïönæ ïinque go ate Mäadiya Mäagadadënä näni änongä tönö Tantiago badä Mäadiya tönö Tadömee tömënäni ïñömö, Itota wodi baö öni pæcæ̈impa, ante cædinque oguï waquï godonte æ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ænte ate wacä tëmäna baquinque ñäö tæcæ bayonte ïïnäni do godinque nænque tæcæ mæ̈ awæ̈ nänö tamöñedë Itota wodido pöninque, ");
INSERT INTO aucNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","nämäneque änänitapa. —Dicabo näni moncadodinca æcänö tæ̈ï pïñængä inte pönö da tæ̈ñæ̈na ate mönö guiite aquïï. ");
INSERT INTO aucNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ante wædinque go gongænte pömo ayönäni dicabo ñæ̈nængade pönï näni äninca incæ dobæ dicabo ñæ̈nængade pönï do da tæ̈ñæ̈ï a öñö adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Adinque tömengä wodido wäänë guiite ayönäni edëningä baï ingä doyæncoo näämænta ëmoncoo wëñate tömëmæ̈ ïnö tæ̈ contate a ongongä adinque onquiyæ̈näni wæætë edæ ancai guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Edëningä ïñömö, —Guïñente wædämaï ïedäni. Mïnitö, Itota Näatadeta quëwëningä ingante edæ wadäni awæ̈ timpodäni ate në wæ̈ningä ingante edæ diqui diqui mïmïni awædö. Tömengä edæ dobæ ñäni ömæ̈monte tao gocäimpa. Ïñömö edæ dæ angampa. Ïintodë nänö öñontatodë ïñömö edæ önontatoque ïï ataqueedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ayæ̈ Pegodo tönö tömengä nänö në ëmïñæ̈nïnäni tömänäni ïnänite gode ante apæ̈nedinque mïnitö në adïmïni inte ïïmaïnö ante apæ̈necæmïnimpa. “Itota ïñömö täno Gadideabæ godinque a ongöñongante mïnitö adoyömö godinque tömengä nänö änïnö baï godinque tömengä ingante acæmïnimpa,” ante gote apæ̈nedäni. ");
INSERT INTO aucNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ante apæ̈necä ëñëninque, Æbänö ante mänömaï angää, ante ancai guïñente do do wäate wædinque onquiyæ̈näni ïñömö Itota wodido abæ tawæ̈ tao wodii wïnönänitapa. Guïñente wædönäni inte tömënäni wadäni ïnänite bee tëninque apæ̈nedämaï pæ wëënegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Itota tömënäni näni guëmänïönæ go ate ïïmö baänæque do ñäni ömæ̈monte pö a ongöñongante Mäadiya Mäagadadënä tänocä agacäimpa. Ïingä onquiyængä ïñömö wëënëñedë wënæidi tiæte ganca ïnäni ënempoyongante Itota wido cædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ñöwo ïñömö Itota mïñæ̈ näni quëwënincabo ayæ̈ ca wæwëñönänite Mäadiya Mäagadadënä incæ tömënäni ïnänite mäo apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Itota ayæ̈ mïingä ingä atabopa, ante apæ̈necä ëñëninque tömënäni wïï pönënänique ongongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mänömaï wïï pönënäni ate tömënäni näni Itota mïñæ̈ godincabo incæ mënaa idömæ gote ayöna Itota incæ wacä baï bate cægongä adatapa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ate wædinque tömëna wadæ godinque Itota mïñæ̈ näni godincabo wadäni ïnänite apæ̈nedinque, Mänömaï cægongä atamönapa, äna ëñëninque edæ cöwë pönënämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ayæ̈ ate onte ganca ïnäni näni Itota mïñæ̈ godincabo cænte tedete a cöñönäni Itota pö a ongongä adänitapa. Tömengä ïñömö, Mïnitö pönëegade impa. Wadäni, Itota do edæ ñäni ömæ̈monte cægongä atamönipa, ante apæ̈nedäni ëñëninque mïnitö mïmö ömædëmïni inte wïï pönëmïnii, ante Itota pïingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ayæ̈ tömënäni ïnänite, “Wængonguï nänö badongaïnäni inguipoga tömäo quëwënäni ïñönänite mïnitö botö ïmotedö ante mäo tömänäni ïnänite watapæ̈ apæ̈nemïni ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Edæ æcänö wede pönëninque æpæ̈në guiida tömengä botö godö æ̈mo beyænque quëwencæcäimpa. Wæætë në pönënämaï ingä guiquënë tömengä nänö apænte pante wæquinque pönënämaï ingampa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Botö cæbo ate në pönënäni adobaï edæ ïïmaï mä cædäni adinque wadäni do ëñencædänimpa. Botö ëmöwo apæ̈nedinque tömënäni wënæidi ïnänite wido cæcædänimpa. Ayæ̈ wadäni tömënäni tededö mä tedecædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ayæ̈ tæntæ bæi ongönäni incæte wænguïmæ̈ bedäni incæte wënæ wënæ badämaï incædänimpa. Ayæ̈ caate wædäni ïnänite gampodäni ate do waa bacædänimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ïinque tömënäni ïnänite apæ̈necä ëñënäni ate edæ Wængonguï öönædë ængö cæcä æidinque Wængonguï tömengä nänö tömëmæ̈ ïnö mönö Awënë Itota ïñömö tæ̈ contagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ïninque tömengä nänö ëmïñæ̈nïnäni wæætë edæ tömämæ wadæ godinque wabæca mäo wabæca mäo apæ̈nedäni ëñënänitapa. Mönö Awënë incæ cæcä ate tömënäni mä cædäni adinque në ëñënäni wæætë, Nö impa, ante wægadänimpa. Mäninque ante yewæ̈monte impa.");
INSERT INTO aucNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ñöwodäni nanguï ïnäni incæ, Mönitö weca æbänö ïinque cægatimpa, ante do yewæ̈moncæ cædänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Doyedë quëwënäni ïñömö, Æbänö cægatimpa, ante në agaïnäni inte mänïnö ante, Näwangä impa, ante në apæ̈nedäni badinque adode beyæ̈ ante në cædäni bagadänimpa. Tömënäni mönitö ïmönite adodö ante pönö apæ̈nedäni ëñentamönipa. Ïninque ïïnäni apæ̈nedäni möni ëñënö baï ñöwodäni wæætë edæ adobaï pönï ante yewæ̈moncæ cædäni ïninque botö ïñömö edæ, Adobaïnö ante yewæ̈moncæboimpa, antabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Teopido bitö ñæ̈næ̈mi pönï ïnömi inte ëñëmi. Botö ïñömö, Wëënëñedë æbänö mä pönï cægatimpa, ante ayæ̈, Ñöwo ganca æbänö cæte ï, ante ëñencæte ante nanguï cædinque ædæmö ëñënïmo inte botö edæ, Bitö Teopidobi acæbiimpa, ante adodö adodö ante yewæ̈mömopa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wadäni odömonte apæ̈nedäni ëñëninque bitö wæætë, Nö intawo, ante ëñencæte ante cædinque botö yewæ̈möninta adinque edæ do ëñencæbiimpa. Mänömaïnö ante yewæ̈mömo ae. ");
INSERT INTO aucNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wængonguï quï, ante në godönäni pancadäniya Abiyaidi näni cabo ïñönänite adocanque Tacadiya ëmongacäimpa. Tömengä ïñömö Oodeabæ awënë odeye Edode wodi nänö ingaïñedë, Wængonguï quï, ante në godongä ingacäimpa. Tömengä nänöogængä Aadöö wodi pæ̈ingä Editabeti ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tömëna ïñömö näna gæncaya ïnöna inte Wængonguï ayongante nö cæte quëwëninque Wængonguï, Ïïmaï cæedäni, ante nänö wææ angaïnö ante ëñente quëwëñönate wadäni, Ëñënämaï quëwënapa, ante ædö cæte anguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Editabeti owæntacä inte wëñæ̈ mänämaï quëwëñongante wëñæ̈ dæ ä wædinque näna gæncaya picæ̈na badinque quëwengadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dæ ä wædinque quëwëñönate Tacadiya wodi tönö godongämæ̈ näni godoncabo näni godöñedë ba ïninque tömengä ïñömö, Wængonguï quï, ante godongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Godöñongante tömënäni, Æcänö ñöwo guiidinque oguï waquï tanguingää, ante acæte ante cædänitapa. Tömënäni cöwë näni cæï baï cædinque tömënäni ëmöwo wataa wataa yewæ̈möninque adoyömö da wëninque adotaque tadonte adänitapa. Ayönäni, Tacadiya ëmöwo impa, ante adinque änäni ëñëninque tömengä Awënë Wængonguï tæiyæ̈ waëmö oncönë guiidinque oguï waquï tangantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Waodäni tömänäni, Ñöwo oguï waquï iya tangæ̈impa, ante yabæcönë godongämæ̈ pöninque Wængonguï ingante apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tacadiya ïñömö tæcæ tancæ cæyongä Wængonguï nänö da pönöningä anquedo tömënäni näni iya täimpaa gäänë tömëmæ̈ ïnö pö næ̈ gongænte a ongongä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Adinque Tacadiya, Æbänö cæquïï, ante ancai guïñente wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wæyongante anquedo guiquënë, —Tacadiya, guïñënämaï ïe. Bitö Wængonguï ingante apæ̈nebi ëñëninque tömengä bitö änö ante do cæcampa. Bitö nänöogængä Editabeti ïñömö onguïñængä ingante mancæcäimpa cæbii. Mangä ëñacä adinque bitö tömengä ëmöwo, Wäö, pemoncæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wëñængä waa pönï ëñacä adinque bitö watapæ̈ tocæbiimpa. Wadäni nanguï ïnäni adobaï wëñængä ëñacä ate tocædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wængonguï incæ, Botö ayömo bitö wengä wadäni baï guiyä ïnämaï ñæ̈nængä pönï ingä abopa, angä beyæ̈ waodäni adobaï tömengä beyæ̈ ante adinque tocædänimpa. Yowepæ̈ biïnömæ̈ incæ wapæ̈ incæ tömengä tï nämæ̈ tömämæ̈ bedämaï incæcäimpa. Wäänä cæncadë ayæ̈ ongöñongante Wængonguï Tæiyæ̈ Waëmö Önöwoca incæ tömengäa pö guiicæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ayæ̈ bitö wengä picængä badinque mäo apæ̈necä ëñëninque idægoidi nanguï ïnäni Wængonguï gämæ̈nö poncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ayæ̈ Wængonguï Önöwoca ingante Ediya wodi nänö ëwocagaï baï adobaï ëwocadinque bitö wengä ïñömö adocä nänö tæ̈ï pïñængaï baï adobaï tæ̈ï pïñængä incæcäimpa. Ïninque tömengä ïñömö mönö Awënë nänö ponguïnö ante täno beyænte baï cædinque odömongä ate mæmpoidi wëñæ̈näni ïnänite pönente waadete cæcædänimpa. Ayæ̈ tömengä apæ̈necä ëñëninque në ëñënämaï cædäni incæ nö cæte quëwënäni näni ëñënö baï nö ëñente cæcædänimpa. Mänömaï cædinque bitö wengä adocä apæ̈necä ëñente cædinque waodäni mönö Awënë nänö ponguïnö ante eyepæ̈ pönï cædinque tömengä ingante ante wänö concædänimpa. Mänömaïnö ante anquedo Tacadiya ingante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angä ëñëninque Tacadiya wæætë anquedo ingante apæ̈nedinque, —Ïñæmpa botö nänöogæ̈nä picæ̈nä ïnampa. Botö adobaï picæ̈mo ïmopa. Ædö cæte, Nö impa, ante ëñenguïmoo. ");
INSERT INTO aucNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Äñongä anquedo wæætë, —Botö Gabodiedo ingaïmo ïmo apa änewëë. Wængonguï weca në ongömo ïñömote tömengä ïñömö, Botö watapæ̈ apæ̈nedö ante bitö Tacadiya ingante apæ̈nete pöe, ante da pönongä pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ñöwo ïñömö botö änö pönënämaï ïmi inte bitö babetadebi badinque tededämaï ïñömite botö apæ̈nedö ante ïinque cæbo ba ate tedecæbiimpa, ante anquedo Tacadiya ingante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mänömaï tedeyöna wadäni, Tacadiya taquingä, ante wänö cöninque, Wængonguï tæiyæ̈ waëmö oncönë guiidinque æiquedö taquingää, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tömengä tadinque tededämaï ingantapa. Ayæ̈ godömenque tededämaï inte önompoque oo cæpo oo cæpo cæcä adinque tömënäni, Wængonguï tæiyæ̈ waëmö oncönë guiite ongöninque Tacadiya wïïmonte baï mä pönï adingä inte ñöwo edæ babetadecä inte tacampa, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wængonguï beyæ̈ ante cæe, ante näni ïinque änïönæ ganca cædinque Tacadiya wodi oncönë gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mänïñedë ate tömengä nänöogængä Editabeti yædëmadä badinque edæ önompo æ̈mæmpoque apäicä ganca oncönë wë womongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tömengä ïñömö edæ, “Wëënëñedë, Owæntabi ïmipa, ante pïïnäni wæbo adinque Wængonguï botö ïmote waadete pönö cædinque ñöwo wæætë, Pïïnämaï incædänimpa, ante cæcampa,” ante pönëninque Editabeti togacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Editabeti önompo æ̈mæmpoque go adoque apäicä yædëmadä nänö ïñedë Wængonguï tömengä anquedo Gabodiedo näni änongä ingante da pönongä pöninque Gadideabæ Näatadeta näni quëwëñömö gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Godinque tömengä baquecä Mäadiya näni änongä weca pongantapa. Tömengä ingante Awënë Dabii wodi pæ̈ingä Ootee, Monguïmo, ante do äningä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ïninque anquedo Gabodiedo Mäadiya weca pö guiidinque tömengä ingante, —Wængonguï nänö në waadebi inte ëñëe. Wængonguï bitö ïmite waa cæcæcäimpa. Wadäni onquiyæ̈näni ïnänite Wængonguï pönömenque pönö waa cædongä inte bitö ïmite edæ godömenque waa pönï pönö cæcä acæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ante tæcæ apæ̈neyongä tömengä ancai guïñëninque, Quïnö baï ï ante botö ïmote apæ̈necää, ante wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wæyongante anquedo wæætë, —Mäadiya, bitö guïñënämaï ïe. Wængonguï incæ edæ bitö ïmite nanguï waadete pönö acampa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bitö ñöwo edæ yædëmadä badinque bitö wëñængä onguïñængä mancæbiimpa. Tömengä ëñacä ate bitö tömengä ëmöwo, Itota ingampa, ante pemoncæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tömengä ïñömö edæ nanguï tæ̈ï pïñænte cæcä incæcäimpa. Ïninque tömengä ingantedö ante, Æibæ pönï në Quëwengä Wengä ingaingä ingampa, ante apæ̈necæ̈impa. Ayæ̈ Awënë Wængonguï incæ tömengä ingante apæ̈nedinque, Bitö Awënë bayömi mæ̈mæ̈ awënë odeye Dabii wodi nempo dodäni näni quëwengaï baï bitö nempo adobaï quëwencædänimpa, ante adocä Itota ingante pönongä ænte Awënë Odeye bacæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ïninque Aacoboidi tömengä nempo quëwëñönänite tömengä cöwë tömënäni Awënë Odeye incæcäimpa. Tömengä nänö Awënë Odeye inguïmämo ïñömö edæ dæ badämaï ingæ̈impa, ante Wængonguï nänö da pönöningä Mäadiya ingante angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mäadiya wæætë tömengä ingante, —Botö ïñæmpa onguïñængä tönö mönämaï inte wëñæ̈ ædö cæte manguïmoo. ");
INSERT INTO aucNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ante wæyongante anquedo wæætë edæ, —Wængonguï Tæiyæ̈ Waëmö Önöwoca incæ bitö weca poncæcäimpa. Wængonguï Æibæ Quëwënongä tömengä nänö tæ̈ï pïñæ̈nö incæ wææ owo baï cæcæcäimpa. Mänömaï beyæ̈ bitö Wëñængä Onguïñængä incæ Tæiyæ̈ Waëmö ëñacä ate, Wængonguï Wëñængä ingampa, ante pemoncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ayæ̈ godömenque apæ̈nebo ëñëe. Editabeti bitö guiidengä ïñömö picængade pönï ïñongante, Owæntacä ingampa, ante tededänitawo. Incæte tömengä picængadecä incæ dobæ edæ önompo æ̈mæmpoque go adoque apäicä yædëmadä inte tömengä wëñængä edæ onguïñængä ingante ënengampa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ïñæmpa quïëmë ante Wængonguï nänö änönö ante tömää edæ cöwë cæcæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ante anquedo angä ëñente wædinque Mäadiya, —Mönö Awënë beyænque në cæbo ïmopa. Bitö änö baï Ao ämo bacæ̈impa. Ante apæ̈necä ëñëninque Wængonguï nänö da pönöningä incæ ëmö cæte wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mänïñedë ate Mäadiya wodi wadæ godinque änämæ̈në quingæ̈ æidinque Oodeabæ quëwënäni näni quëwëñömö adoyömonque incæ pöninque, ");
INSERT INTO aucNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tacadiya oncönë pö guiidinque Editabeti ingante, Waa quëwëmi, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mäadiya mänömaï apæ̈necä ëñëninque Editabeti wodi wengä cæncadë ongöninque wogæi wogæi tocantapa. Editabeti ïñömö Wængonguï Tæiyæ̈ Waëmö Önöwoca incæ tömengäa pö guiicä ïninque ædæmö pönï ëwocacä bacantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mänömaï badinque adocä ogæ̈ tededinque, —Mönö onquiyæncabo ïñömonte bitö adobique bitö waa toquinque impa, angantapa. Wængonguï wamöni ïmönite pönömenque waadedinque bitö ïmïnite godömenque nanguï waadecampa. Bitö në ënënongä ingante Wængonguï nanguï waadecä beyæ̈ tömengä adobaï tocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Botö önömoque ïñömote bitö ïñömö mönö Awënë badä ïnömi inte edæ botö weca quïnante pömii. ");
INSERT INTO aucNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tæcæ edæ apæ̈nebi önömonca ëñëñömo botö cæncadë në ongönongä incæ wogæi wogæi watapæ̈ tocä ae. ");
INSERT INTO aucNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mönö Awënë bitö ïmite nänö änïnö ante bitö ïñömö, Tömengä cöwë cæcæcäimpa, ante pönëninque bitö toquinque edæ në pönëmi ïmitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Editabeti mänömaï apæ̈neyongä Mäadiya wæætë ämotamïni ante baï ïïmaï angacäimpa. “Botö mïmöno pönëninque, Mönö Awënë ïñömö edæ waa pönï mönö ïnongä ingampa, ante watapæ̈ apæ̈nebopa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ayæ̈, Quëwencæbiimpa, ante botö ïmote në Ængä ïñongante botö Wængonguï ingante ante pönëninque edæ watapæ̈ tote ëwocabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Botö tömengä ingante në cædömo inte önömoque pönï ïñömote tömengä wæætë botö ïmote waa acampa. Ïincayæ̈ nänömoidi wææ̈ ïincayæ̈ nänömoidi wææ̈ ïnäni tömänäni botö ïmotedö ante apæ̈nedinque, Tömënä ïñömö Wængonguï nänö në waadedä ingadäimpa, ante apæ̈necædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wængonguï në Tæ̈ï Pïñæ̈nongä inte botö ïmote pönö nanguï cæcä beyænque edæ apæ̈necædänimpa. Tömengä ëmöwo ïñömö edæ Tæiyæ̈ Waëmö ëmongampa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ayæ̈ ïincayæ̈ nänömoidi wææ̈ ïincayæ̈ nänömoidi wææ̈ ïnäni tömengä ingante guïñente cæyönänite tömengä wæætë waadete pönö waa cæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tömengä në tæ̈ï pïñæ̈nongä inte tömengä önompoca cæte baï nanguï cæcantapa. Ayæ̈ wadäni, Tömëmoque waëmö ïmopa, ante önöwëninque pönënäni ïnänite tömengä angä näwæ̈ godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ayæ̈ awënëidi näni tæ̈ contaimpaa ongöñönänite tömengä tömënäni ïnänite wido cæcä godänitapa. Wæætë önönänique ïnänite ængö cæcä contadinque tömënäni wæætë awënëidi baï badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ayæ̈ gue æ̈nente wædäni ïñönänite tömengä waa pönï cænguï godongä æ̈ninque tömënäni tömo pönï cæ̈nänitapa. Wæætë nanguï ëadäni tömënäni ïnänite da godongä godinque ömæpodäni inte godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mönö idægocabo ïñömö tömengä ingante në cæmö ïñömonte tömengä mönö tönö godongämæ̈ cæcantapa. Ayæ̈, Waadete botö pönö waa cægaïnö baï adodö cæcæboimpa, ante pönëninque tömengä ñöwo pönö waadete waa cæcä æ̈mompa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abadäö wodi pæ̈ïmö ïñömonte tömengä mönö mæ̈mæ̈idi ïnänite nänö angaïnö baï cædinque, cöwë ñimpo cædämaï inte pönö waadete cæcampa.” ");
INSERT INTO aucNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ante Mäadiya wodi ämotamïni ante baï angantapa. Ayæ̈ Editabeti weca mëa go adoque apäicä quëwente ate ayæ̈ ate tömengä oncönë gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Editabeti wodi guiquënë oo pönï ënëninque tömengä wëñængä onguïñængä mangacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ayæ̈ tömengä guiidënäni tönö godongämæ̈ quëwënäni ïñömö, Æ mönö Awënë wïï pïingä inte Editabeti ingante ædæmö waadete waa cæcampa, ante tæcæ ëñëmönipa, äninque Editabeti tönö godongämæ̈ togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ayæ̈ adoque Wængonguï itædë go ate wëñængä ingante æ̈montaique ëö togæncæ cædäni ïñömö godongämæ̈ pöninque tömengä wæmpo ëmöwo baï ante, Tacadiya, ante pemoncæ cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Cæyönänite wäänä Baa äninque, —Tömengä ëmöwo Wäö ëmoncæcäimpa, ante wææ angadäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Äñongante tömënäni wæætë, —Ïñæmpa bitö guiidënäni Wäö ëmönämaï. Dæ ämönänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Äninque wæmpocä ingante ömö cædinque, Æmongänö ëmonguingä ämii, ante odömömi amönii. ");
INSERT INTO aucNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Äñönänite tömengä tededämaï ïnongä inte önompocaque odömongä adinque yewæ̈möinta æ̈ninque pædæ pönönäni ate tömengä ïñömö edæ, “Tömengä ëmöwo Wäö ëmoncæcäimpa,” ante yewæ̈mongä adinque tömänäni edæ guïñente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yewæ̈mongä ate tömengä önonguënëwa ñïmæ̈ cæguënëwate baï baguënëwate ate edæ tömengä ogæ̈ tededinque Wængonguï ingante, Waa pönï cæbi abopa, ante watapæ̈ edæ apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ïninque mänïñömö godongämæ̈ quëwënäni tönö Oodeabæ änämæ̈në quëwënäni tönö tömänäni, Mänömaï batimpa, ante nanguï tededänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tededäni ëñëninque në ëñënäni wæætë, “Ïingä wëñængä ïñömö æbänö nänö baquinque edæ pæquingä,” ante tömänäni godongämæ̈ wægadänimpa. Edæ tömengä tönö Wængonguï godongämæ̈ cæcä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wëñængä wæmpocä Tacadiya guiquënë Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante ëwocadinque Wængonguï beyæ̈ apæ̈nedinque ämotamïni ante baï apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mönö idægocabo Wængonguï ïñömö adocä mönö Awënë ïñongante mönö tömengä ingante waa ate watapæ̈ apæ̈necæ̈impa. Tömengä ïñömö, Botö quïnäni bate abæ tawænte baï quëwencædänimpa, ante tömengä do æncæ pongä acæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","‘Önömoncawæ̈ wææ ëmoncate baï wææ gompocæcäimpa,’ ante cædinque tömengä mönö ïmonte në ænguingä ingante da pönongä pöninque ïingä wæætë ængä beyænque quëwëmompa. Wængonguï ingante në cægaingä awënë odeye Dabii wodi pæ̈ingä ïnongä inte tömengä mänömaï cæcä beyænque quëwëmompa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wængonguï ïñömö tömengä beyæ̈ në apæ̈negaïnäni tæiyæ̈ waëmö ingaïnäni ïñönänite tömënäni tönö apæ̈nedinque, Cöwë cæcæboimpa, ante nänö apæ̈negaïnö baï ñöwo edæ ïinque cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mönö ïñömö në pïinte änäni nempo ongöñömonte tömengä, Pïinte cædänipa, ante adinque mönö ïmonte gä pe æmpote ö ængä beyænque quëwëmompa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mänömaï cædinque tömengä mönö mæ̈mæ̈idi ïnänite nänö angaïnö baï cædinque ñöwo waadete pönö cæcampa. Ayæ̈, Botö pönö cæbo ate mïnitö Ao ämïni ïninque mönö godongämæ̈ wææ cæte quëwengæ̈impa, ante tömengä tæiyæ̈ waëmö nänö angaïnö ante cöwë pönënongä inte ñöwo ïinque cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Edæ mæ̈mæ̈ Abadäö wodi ingante, Botö në Quëwëmo ingaïmo inte nöingä ämopa, ante Wængonguï ïïmaïnö ante nänö pönö cæquïnö ante nö apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Abadäö ëñëmi. Në pïinte cædäni nempo wæwëñömïnite botö gä pe æmpote ö æ̈ninque pönö cæbo ate eyepæ̈ badinque mïnitö wæætë guïñënämaï inte botö Wængonguï ïmo beyæ̈ cæcæmïnimpa, ante Wængonguï në pönö cæquingä inte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wængonguï ïñömö edæ, Mïnitö tæiyæ̈ waëmö ëwocadinque mïni quëwenganca botö weca nö pönï cæte quëwencæmïnimpa, ante pönö cæcä ingacäimpa,” ante wëñængä mæmpocä Tacadiya wodi apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ayæ̈ wëñængä ingante tömengä ïïmaï ante godömenque apæ̈necantapa. “Botö wëmi bitö ïmite botö wæætë apæ̈nebo ëñëe, angantapa. Në Æibæ Pönï Quëwengä beyæ̈ bitö në apæ̈nebi ïnömi ïmipa, ante bitö ïmitedö ante apæ̈necædänimpa. Mönö Awënë taadö pïnongæ̈impa, ante bitö edæ täno beyænte gote baï cædinque, ");
INSERT INTO aucNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","mönö Awënë quïnäni ïnänite ïïmaï ante odömonte apæ̈necæbiimpa. Wënæ wënæ mïni cædö ante Wængonguï pönö ñimpo cæcä ate mïnitö ïñömö edæ, Tömengä ængä beyænque mönö quëwenguï impa, ante do ëñencæmïnimpa, ante apæ̈nebi ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Edæ mönö Wængonguï incæ mönö wënæ wënæ wædönö ante waadete pönö waa cædinque, öönædë Quëwengä ingante mönö weca da pönongä pöninque nænque tæcæ tamö baï ëmongä acæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mänömaï cædinque mönö wænguïmämo beyæ̈ wëmö ïñömö awædö, ante wæyömonte tömengä ponte a ongongä adinque mönö nænque pämo oo tote baï quëwëmompa. Ayæ̈, Mïnitö mïni gänë pönente quëwenguïnö taadonque poncæmïnimpa, ante tömengä töö æ̈mænte mämongä pömompa.” Mänömaïnö ante Tacadiya wodi tömengä wëñængä ingante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wëñængä ïñömö do pædinque önöwoca tæ̈ï pïñænte ëwocagacäimpa. Idægoidi weca tömengä nänö ponte a ongonganca önömæca quëwengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wäö idægoidi weca nänö pöñedë ïinque bayonte awënë Tetædo Agoto ïñömö, Æpomïnidö ïmïnii, ante acæte ante cædinque odömäno ömæ në quëwënäni ïnänite edæ, Mïnitö ëmöwo tömämïni yewæ̈moncæmïnimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tidiabæ awënë Tidënio ingäñedë odömäno awënë täno angä. ");
INSERT INTO aucNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ëñëninque adocanque tömengä mæ̈mæ̈idi näni quëwengaïñömö wacä tömengä mæ̈mæ̈idi näni quëwengaïñömö tömänäni yewæ̈moncæte ante edæ go go cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ïninque Oodeabæ Awënë wodi Dabii wodi pæ̈ingä ïnongä inte Ootee ïñömö Gadideabæ Näatadeta näni quëwëñömö quëwëninque adobaï tömengä mæ̈mæ̈ Dabii wodi nänö quëwengaïñömö Bedëë ïñömö gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Edæ Ootee nänöogængä inguingä Mäadiya yædëmadä ïñongante tömëna näna gæncaya inguïna guëa yewæ̈moncæ godatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bedëë ponte quëwëñöna Wëñængä ïñömö ïinque pædinque ");
INSERT INTO aucNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","bamoncadengä incæ onguïñængä inte ïïmaï ëñagacäimpa. Mänïñömö monguï incönë ïñömö mänïñedë eyede pönï goti ongönäni ate wædinque tömëna wæætë cæ̈nënäni cænguï oncontaidë guiyantaidë go guiida ate Wëñængä ëñacantapa. Ïninque guiyantaidë ëñacä ate wäänä Wëñængä ingante weocoo wïni wïni caadinque cæ̈nënäni cænguincadedë ñö cædä öñongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Idægoidi cæ̈nïnäni obegaidi näni änönäni ïñönänite në aawënäni ïñömö eyepancadë adoönæ woyowotæ̈ a cönönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A cöñönäni mönö Awënë anquedo ponte a ongöñongä mönö Awënë nänö ñäö ëmönö beyænque godongämæ̈ guïnæ̈ gongæ̈ adinque në aadäni ancai guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anquedo ïñömö tömënäni ïnänite, “Guïñënämaï ïmäewedäni. Mïni nanguï ëñente toquinque ante botö ñöwo watapæ̈ apæ̈nebo ëñëedäni. Mïnitö tönö inguipoga tömäo quëwënäni adobaï adode beyænque watapæ̈ tocæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mönö Awënë Codito ïñömö, Æ̈mo beyænque quëwencæmïnimpa, ante në Ængä baquingä ïnongä inte do edæ ëñacantapa. Edæ mïnitö beyæ̈ ante tömengä ñöwoönæ incæ awënë Dabii wodi nänö quëwengaïñömö ëñacantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nö impa, ante gote acæmïnimpa. Wëñængä ingante wäänä wïni wïni caadinque edæ cæ̈nïnäni cænguincadedë ñö cædä ate a öñongä adinque mïnitö, Nö impa, ante ëñencæmïnimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ante anquedo äñongä wadäni nanguï ïnäni öönædë owodäni incæ ïñontobæ̈ tontadoidi ongönäni baï tömengä tönö godongämæ̈ ponte a ongöninque ämotamïni ante baï äninque Wængonguï ingante ïïmaï ante watapæ̈ apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wængonguï æibæ pönï quëwënongä inte edæ ñäö apäite baï ëmongänö anguënë. Tömengä inguipoga ïñömö waadete pönö cæcä beyænque mïni waocabo edæ gänë pönenguïmïnidö anguënë.” ");
INSERT INTO aucNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ante ämotamïni ante baï äninque anquedoidi öönædë adodö wadæ æite godäni ate në aawënäni ïñömö näni cabo tededinque, —Mönö Awënë mönö ïmonte apæ̈necä mönö ëñënö ante, Æbänö cæcäï, ante mönö Bedëë gote ædæmö acæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Äninque pogodo ponte ayönäni Mäadiya tönö Ootee a ongöñöna Wëñængä ïñömö cæ̈nïnäni cænguincadedë a öñongä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ïinque adinque wadæ godinque, Wëñængä æbänö ingää, ante anquedo apæ̈necä näni ëñënö ante gode ä gode ä cæte wayömö wayömö quëwënäni ïnänite tededäni ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ëñëninque tömänäni wæætë, Në aawënäni æbänö ante apæ̈nedäni, ante guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mäadiya guiquënë, Wëñængä æbänö ingä änänii, ante nämä pönëë congantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Në aawënäni guiquënë, Wængonguï ñäö apäite baï ëmönongä inte pönö waa pönï cæcä æ̈mönipa. Edæ anquedo nänö apæ̈nedö baï do cæcä amönipa, ante apæ̈nedinque eyepancadë ocæ̈ ëmænte gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ayæ̈, Adoque Wængonguï itædë go ate æ̈montaique ëö togængæ̈impa, ante idægoidi cöwë näni cæï baï cædinque Wëñængä ingante ëö togæ̈nänitapa. Ayæ̈ Mäadiya yædëmadämaï nänö ïñedë anquedo nänö pemönïnö baï äninque mæmpoda Wëñængä ëmöwo ante, Itota, pemongadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wäänä mänimpoönæ wepæ̈ näate ïnampa, ante Möitee wodi nänö angaimpoönæ ïinque go ate tömëna, Wëñængä ïñömö Wængonguï Awënë quï ingampa, ante mönö godongæ̈impa, ante tömengä ingante Eedotadëë ïñömö ænte gogadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Edæ, “Onguïñæ̈näni bamoncadënäni tömänäni tæiyæ̈ waëmö bacædänimpa, ante tömënäni Wængonguï Awënë nempo pædæ godongæ̈impa,” ante Awënë Wængonguï nänö angaïnö ante ëñëninque Mäadiya tönö Ootee do cædatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ayæ̈, Equemöna näna gæncaya, Wængonguï quï, ante godongæ̈impa. Wïï mänömaï cæte tæcæ wengä wengä pæda mënaa ïnate godongæ̈impa. Ootee tönö Mäadiya ïñömö mänömaï cædinque, Wængonguï quï impa, ante mënaa ïnate ænte pöninque pædæ godöna ængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mänïñedë adocanque edæ tömengä ëmöwo Tïmeönö Wængonguï beyænque ante nö cædongä inte Eedotadëë ïñömö quëwengacäimpa. Idægoidi wampo pönente quëwencædänimpa, ante Wængonguï æyedënö ædæmö cæquingää, ante tömengä wänö cönonte quëwënongäimpa. Ayæ̈ Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante tömengä cöwë ëwocacä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wængonguï Tæiyæ̈ Waëmö Önöwoca do apæ̈necä ëñëninque Tïmeönö wodi ïñömö, Botö ayæ̈ wæ̈nämaï mïïmö quëwëmoyedë mönö Awënë Codito ingante aquïmo ïmopa, ante do ëñëningä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ñöwo ïñömö Wængonguï Önöwoca angä ëñëninque tömengä Wængonguï oncö ñæ̈næncönë yabæcönë pö guiicantapa. Mänïñedë Itota mæmpoda ïñömö idægoidi wææ ante näni cægaïnö baï cæcæte ante cædinque Wëñængä Itota ingante ænte pö guiida. ");
INSERT INTO aucNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Adinque Tïmeönö ïñömö edæ Wëñængä ingante bæi ongonte pæ mäninque Wængonguï ingante, Tömëmi waa toquinque mönitö ïmönite pönö cæbipa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bitö Tæiyæ̈ Awënë ïnömi inte ëñëmi. Bitö ïmite në cæbo ïñömote bitö doyedë, Cæbo acæbiimpa, angabiimpa. Ïninque bitö änïnö baï ñöwo edæ ïinque cæbi adïmo ïñömote bitö ämi ate wænte goboe. ");
INSERT INTO aucNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Edæ bitö, Quëwencæmïnimpa, ante në Ænguingä ingante ñöwo da pönömi ponte ëñacä do abopa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mänömaï cædinque bitö, Wadäni näni cabo wadäni näni cabo waodäni tömänäni acædänimpa, ante cædinque bitö në Ænguingä ingante ñöwo da pönömi ponte a ongongä acæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Idægoidi ïnämaï ïnäni incæ tömënäni näni cabo näni cabo incæ edonque acædänimpa, ante cædinque bitö da pönömi pöninque tömengä ñäö apäite baï a ongongä acædänimpa. Ayæ̈ möni idægocabo ïñömönite bitö, Wëñængä ængä beyænque botö quïmïni ïñömö ñäö baï waëmö pönï ëmöninque quëwencæmïnimpa, ante pönö cæbi abopa.” ");
INSERT INTO aucNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ante ämotamïni ante baï Tïmeönö wodi, Wëñængä æbänö cæquingä ingää, ante tedecä ëñëninque Wëñængä mæmpo tönö tömengä badä ïñömö guïñente wædatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tïmeönö wæætë, Mïna waa toquinque ïingä Wëñængä ingante æ̈mïnapa, ante apæ̈nedinque tömengä badä Mäadiya ingante ïïmaï ante godömenque apæ̈necantapa. —Picængä badinque ïingä Wëñængä cæcä beyænque idægoidi pancadäniya tæ̈ go wæænte baï wæyönäni pancadäniya wæætë ængæ̈ gantite baï quëwencædänimpa. Wængonguï ïñömö, Wëñængä ingante ate ëñencædänimpa, ante odömonte cæyongä pancadäniya wæætë adocä ingante godö pïinte tedecædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ante apæ̈nedinque Tïmeönö ïñömö Mäadiya ingante apæ̈necantapa. Mänömaï bayonte, Nanguï ïnäni æbänö ante mïmöno pönënänii, ante edonque acæ̈impa. Bitö ïñömö yaëmë yete baï wæwente ëwocacæbiimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ayæ̈ wadä ïñömö Wængonguï beyæ̈ në apæ̈nedä ïñömö tömënä ëmöwo Änä adobaï ongönantapa. Atedoidi näni cabo ïñönäni adocanque Pänoedo wënä ïnönä inte tömënä picængadedä ingadäimpa. Tömengä ïñömö baquecäñedë möninque nänöogængä tönö önompo æ̈mæmpoque go mëa wadepo quëwente ate onguïñængä guiquënë näñe wængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Onquiyæ̈nä ïñömö ñöwo otenta i coatodo wadepo nänö ëñagainganca owæmpoïnä quëwënä inte tömënä Wængonguï oncö ñæ̈næncönë yabæcönenque cöwë quëwëninque taodämaï ïnönäimpa. Itædë woyowotæ̈ tömënä cöwë, Wængonguï ingampa, ante waa cædinque Wængonguï ingante apæ̈necæte ante wantæpiyæ̈ cæ̈nämaï quëwënä ïnönäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tömënä ñöwo eyepæ̈ pönï mämö bee tëninque Itota ingante adinque Wængonguï ingante waa ate pönëninque apæ̈necantapa. Ayæ̈ wadäni, Mönitö Eedotadëë ïñömö quëwëmöni ïñömönite Wængonguï æyedënö pönö cæcä beyæ̈ abæ tawænte quëwenguïmönii, ante në wänö cönäni ïnänite dodä Änä ïñömö Wëñængä ingante do adïnä inte, Wëñængä në Ænguingä inte do ëñate pongä atabopa, ante cöwë apæ̈nedä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ayæ̈ mänïï, Awënë Wængonguï, Ïïmaï cæedäni, nänö angaïnö ante ïinque cæte ate Ootee näni wencabo Gadideabæ gocæte ante wadæ godinque Näatadeta tömënäni näna quëwënïñömö pongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wëñængä ïñömö edæ picængä pædinque tæ̈ï pïñængä bacantapa. Ayæ̈ ocai encacä inte nanguï ëñente bagacäimpa. Ayæ̈ Wængonguï waadete pönö apæ̈necä ëñente ëwocadinque tömengä në waadete pönö cæcä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wodo pænta gogaïönæ baï Patowa mönö æ̈æ̈mæ̈ cænguïönæ ñöwo impa, ante pönëninque idægoidi Patowa ante Eedotadëë godinque æ̈æ̈mæ̈ cædönänimpa. Itota mæmpoda adobaï Patowa näni ämæ̈ cöwë cæyedë wadepo ïñö wadepo ïñö Eedotadëë goda ingadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ïninque Itota dote wadepo ïñonte Wængonguï beyæ̈ ante æ̈æ̈mæ̈ cöwë näni cædö baï Ootee näni wencabo do gote cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Æ̈æ̈mæ̈ tömää ïinque cædinque oncönë poncæte ante taadonque pöninque mæmpoda adämaï ïñönate Itota guiquënë Eedotadëë ïñömö ayæ̈ quëwengantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Godongämæ̈ mönö poncabo tönö pongä ïmaingampa, ante pönëna inte taadö tömää itædë pöninque tömëna guiidënäni weca tömëna æ̈migoidi weca diqui diqui mincæ cæyöna, ");
INSERT INTO aucNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","edæ dæ angä. Ate wædinque tömengä ingante diqui mincæte ante Eedotadëë adodö ocæ̈ ëmænte gogadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mëönaa go adoönæque ïñonte diqui diqui minte ate edæ Wængonguï oncö ñæ̈næ̈ oncönë yabæcönë pö guiite ayönate Itota ïñömö në odömönäni weca ëñëë cöninque, Æbänö ï, Æbänö cæquïï, ante angä adatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tömengä apæ̈necä ëñëninque tömänäni, Æ tömengä ïñömö ocai në encacä waa ëñengä amönipa, änänitapa. Ayæ̈, Itota ingante, Æbänö ï, ante änäni ëñëninque tömengä wæætë nö apæ̈necampa, ante wædinque tömänäni guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mæmpoda ïñömö mänïñömö pö guiite ayöna Itota mänömaï cæcä adinque guïñente wædatapa. Tömengä badä tömengä ingante, —Botö Wëmi ëñëmi. Mönatö ïmönate quïnante mänömaï cæbii. Ïñæmpa bitö wæmpo tönö mönatö bitö ïmite ante ancaa diqui diqui minte wæwentamönapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Äñongante tömengä wæætë, —Mïnatö ïñæmpa, Mæmpocä oncönë Itota ongonguënengä ingampa, ante ëñënämaï ïmïnatawo. Quïnante wayömö diqui diqui mïmïnatawo. ");
INSERT INTO aucNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Äñongante, Æbänö ante angää, ante ædæmö ëñënämaï ïnatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tömengä wæætë mæmpoda mïñæ̈ gote Näatadeta pöninque tömëna näna änö ante cöwë ëñente cæcantapa. Wäänä guiquënë tömengä nänö cædïnö ante nämä pönëë congä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Itota ïñömö edæ nanguï ëñengä bate pædongäimpa. Picængä bayongante Wængonguï tönö waodäni adobaï tömengä ingante cöwë godömenque godömenque waadete adönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibedio quinte wadepo tömämæ awënë nänö ïnöñedë Pontio Pidato wodi näni änongä adoyedë Oodeabæ awënë ïñongante Edode wæætë Gadideabæ awënë ïnongäimpa. Adoyedë ïñömö Edode wodi nänö tönïñacä Pedipe Itodeabæ Todacönitebæ awënë ïñongä Ditäniato wodi adoyedë Abidëniabæ awënë ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mänimpodäni mänïömæ awënëidi ïñönäni Änato wodi tönö Caiapato wodi adoyedë, Wængonguï quï, ante në godöna ñæ̈næ̈na pönï ïnöna ïnönaimpa. Tömëna näna ïnöñedë adoyedë edæ Tacadiya wodi wengä Wäö ingante önömæca ïñömö ayæ̈ quëwëñongante Wængonguï apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wäö wodi ïñömö Oododänonga ömaaque go tömäo cægöninque ïïmaï apæ̈necä ëñënänitapa. Mïnitö, Idæwaa wënæ wënæ cæte awædö, ante ocæ̈ ëmænte Wængonguï gämæ̈nö pöedäni. Ayæ̈, Wënæ wënæ botö cædïnö ante Wængonguï pïïnämaï inte pönö ata cæpocä quëwëmopa, ante edonque acæ̈impa, ante odömöninque æpæ̈në guiiedäni, ante Wäö angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mänömaï cædinque Wængonguï beyæ̈ në apæ̈negaingä Itaiya wodi ïïmaï ante nänö yewæ̈monte apæ̈negaïnö baï Wäö adobaï cægacäimpa. “Adocanque önömæca ongöninque ïïmaï ante yedæ tedecä ëñencædänimpa. ‘Awënë nänö ponguïnö ante tee monte baï cædinque, taadö töïnö pïnonte baï cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Onquiyabo incæ änanquidi incæ, Mæ̈mö pönï bacæ̈impa, ante æ̈æ̈ wocæ̈impa. Biyönæ ïñömö tee möninque mæ̈mö pönï badongæ̈impa. Taadö idiquibæ̈ ïñonte töïnö pïnongæ̈impa. Wënæ wënæ ïñonte waïnö pönï taadö badongæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Taadö mänömaï mæ̈mö pönï ba ïninque tömämæ quëwënäni incæ, Wængonguï pönö ængä beyænque mönö quëwenguïnö impa, ante edonque acædänimpa,’ ancæcäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ante yewæ̈monte ongompa cæmïnii, ante Wäö wodi æpæ̈në guiicæte ante pönäni nanguï ïnäni ïñönänite ïïmaï angantapa. “Mïnitö ïñömö tæntæ pæ̈ïmïni baï inte në babæ cæmïni ïninque edæ ëñenguënë quëwëmïni. Wængonguï nänö pïinte panguïmämo ante edæ, Wæ̈nompadäni, ante æcänö äna ëñëninque mïnitö wodii wïnonte pömïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wængonguï Awënë gämæ̈nö mïnitö ocæ̈ ëmænte poncæ cæmïnitawo. Nö nö pömïni ïninque edæ në ocæ̈ ëmænte pönäni wainca incate baï waa cædäni baï mïnitö ïñömö edæ adobaï waa cæedäni. Mïnitö nämäneque pönëninque, ‘Mönitö mæ̈mæ̈ Abadäö wodi pæ̈ïmöni ïmöni beyænque Wængonguï mönitö ïmönite waa acæcäimpa,’ ante nämä wææ ancæ cæmïnitawo. Ïñæmpa Wængonguï angä baï Abadäö wodi pæ̈ïmïni mïni ïnö baï dicacoo incæ dobæ adobaï bacædönïï apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Awæ̈ ïñömö wainca incadämaï ï ïninque edæ do yete gongapamö iya tangæ̈impa. Awæ̈ yecæte ante awænca eyewa næ̈æ̈näni baï Wængonguï nänö panguïmämo ïñömö edæ oo pönï pö apa quëwëmïnii,” ante Wäö apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Angä wædinque godongämæ̈ ongönäni pancadäniya wæætë, Mänömaï ï ïninque æbänö cæquënëmöni ïmönii. ");
INSERT INTO aucNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Äñönänite Wäö, —Weocoo mencooga në mangä ïñömö weocoo ömaacä ingante adocooque godongä æncæcäimpa. Cænguï në ëacä adobaï cænguï ömæpocä ingante godongä æncæcäimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ayæ̈ odömäno awënë nänö äninta në æ̈näni guiquënë adobaï æpæ̈në guiicæte ante pöninque Wäö ingante änänitapa. —Në odömömi ëñëmi. Mönitö ïñömö æbänö cæquënëmöni ïmönii. ");
INSERT INTO aucNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Äñönänite tömengä wæætë, —Mïnitö awënë, Mänimpota, ante nänö änimpota ante wadäni ïnänite ämïni pædæ pönönäni eyepæ̈ æ̈ninque mïnitö wæætë, Tömëmöni quï, ante godömenque änämaï ïedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ayæ̈ tontadoidi adobaï tömengä ingante, —Mönitö guiquënë æbänö cæquënëmöni ïmönii. Äñönänite Wäö wodi ïïmaï angantapa. —Mïnitö wacä tömengä nänö godonte æ̈inta ö æncæte ante pæmënënämaï ïedäni. Ayæ̈ wacä wënæ wënæ cædämaï ïñongante mïnitö, Wënæ wënæ cæbitapa, ante babæ wapiticæ̈ änämaï ïedäni. Ayæ̈ mïnitö cædï beyæ̈ mïnitö awënë eyepæ̈ pönongä æ̈ninque piyæ̈në cæte godömenque æ̈ïnente wædämaï ïedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Äñongante godongämæ̈ ongönäni ïñömö, Wængonguï doyedë, Codito ponguingä, ante nänö në angaingä ïñömö edæ ïingä Wäö wabänö ïmaingampa, ante önöwënenque pönënäni inte edæ, Wäö æbänö cæquingää, ante acæte ante a ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wäö wæætë tömänäni ïnänite apæ̈nedinque, “Botö guiquënë näwangä mïnitö ïmïnite æpæ̈në guidömo guiimïnipa. Ïincayæ̈ ate në Ponguingä guiquënë tömengä ïñömö näwangä ñæ̈nængä pönï ïñongante botö guiquënë guiyämo ïnömo inte tömengä awæncata incæ ædö cæte ñï cæquïmoo. Tömengä ïñömö mïnitonga gonga bæcote baï cædinque Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante edæ da pönongä æncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Waocä, Todigo tömëmö wati wati tæ̈nöninque botö tæ̈nönïñömö önömancaque baquinque botö waïña tömämö oncönë da wencæboimpa, ante timpodæ næ̈ænte wo æ̈æntodö wo æ̈æntodö cædinque ontapocoo wææ̈incoo wadæ ñëmænte wo ëwengampa. Waocä mänömaï wo ëwencæte ante timpodæ næ̈ængä baï mönö në Ponguingä ïñömö adobaï oo pönï apænte ancæcäimpa. Edæ waëmö ïnäni ïnänite apænte æ̈ninque tömengä ontapocoo baï ïnäni ïnänite gonga cöwë bæcoyömö iya tangä gonte wæcædänimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mänömaïnö äninque Wäö wodi godömenque wade wade apæ̈nedinque tömënäni ïnänite, Ämo ëñëmaïmïnipa, angacäimpa. Ayæ̈, Codito ingantedö ante watapæ̈ apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Incæte tömengä pancabaa Awënë Edode ingante, Bitö tönïñacä nänöogængä Ædodiya ingante mömii, ante pïïninque Edode nänö wïwa cædïnö ante tömänö ante pïingä adinque, ");
INSERT INTO aucNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Edode wodi guiquënë godömenque wïwa cædinque Wäö ingante tee mönecä wægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mänïï Wäö tömänäni ïnänite æpæ̈në nänö guidöñedë Itota ingante adobaï guidongä guiicantapa. Guiite ate Wængonguï ingante apæ̈neyongä öönæ wi æ̈nete baï bayonte edæ ");
INSERT INTO aucNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wængonguï Tæiyæ̈ Waëmö Önöwoca equemö wææ̈ contate baï tömengäa edonque pönï wææ̈ guiicä ate öönædë apæ̈nedinque, —Bitö botö Wëmi botö në waadebi ïmipa. Bitö ïmite waa adinque waa tobopa, ante öönædë apæ̈necä ëñengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Todëinta wadepo nänö ëñagaïñedë ïinque bayonte Itota mänïñedë täno cæcä ingacäimpa. Tömengä ingante në pæpogadongä ïñömö Ootee ïñongante wadäni, Itota wæmpocä ingampa, ante pönënönänimpa. Ootee wodi mæmpo wææ̈ Edii wodi ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Edii wodi mæmpo wææ̈ Mäatato, Mäatato wodi mæmpo wææ̈ Debii, Debii wodi mæmpo wææ̈ Mëedequi, Mëedequi wodi mæmpo wææ̈ Cäna, Cäna wodi mæmpo wææ̈ docä Ootee wodi ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mänïï docä Ootee wodi mæmpo wææ̈ Mäatatia, Mäatatia wodi mæmpo wææ̈ Ämoto, Ämoto wodi mæmpo wææ̈ Näacö, Näacö wodi mæmpo wææ̈ Etedi, Etedi wodi mæmpo wææ̈ Näagaï ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Näagaï wodi mæmpo wææ̈ Mäato, Mäato wodi mæmpo wææ̈ docä Mäatatia, docä Mäatatia wodi mæmpo wææ̈ Tëmei, Tëmei wodi mæmpo wææ̈ Ooteco, Ooteco wodi mæmpo wææ̈ Oodaa ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Oodaa wodi mæmpo wææ̈ Owäna, Owäna wodi mæmpo wææ̈ Deta, Deta wodi mæmpo wææ̈ Dodobabedo, Dodobabedo wodi mæmpo wææ̈ Tadatiedo, Tadatiedo wodi mæmpo wææ̈ Nëedi ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nëedi wodi mæmpo wææ̈ docä Mëedequi, docä Mëedequi wodi mæmpo wææ̈ Adi, Adi wodi mæmpo wææ̈ Cotäö, Cotäö wodi mæmpo wææ̈ Edëmadäö, Edëmadäö wodi mæmpo wææ̈ Ede ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ede wodi mæmpo wææ̈ Ootowee, Ootowee wodi mæmpo wææ̈ Ediyedede, Ediyedede wodi mæmpo wææ̈ Oodïï, Oodïï wodi mæmpo wææ̈ docä Mäatato ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Mänïï docä Mäatato wodi mæmpo wææ̈ docä Debii, mänïï docä Debii wodi mæmpo wææ̈ Tïmeönö, Tïmeönö wodi mæmpo wææ̈ docä Oodaa, docä Oodaa wodi mæmpo wææ̈ wacä docä Ootee, mänïï docä Ootee wodi mæmpo wææ̈ Öönäö, Öönäö wodi mæmpo wææ̈ Ediyaquïmö ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ediyaquïmö wodi mæmpo wææ̈ Mëedea, Mëedea wodi mæmpo wææ̈ Mëna, Mëna wodi mæmpo wææ̈ Mäatata, Mäatata wodi mæmpo wææ̈ Näatäni ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Näatäni wodi mæmpo wææ̈ Awënë Dabii, Awënë Dabii wodi mæmpo wææ̈ Yæte, Yæte wodi mæmpo wææ̈ Obedo, Obedo wodi mæmpo wææ̈ Boodo, Boodo wodi mæmpo wææ̈ Täna, Täna wodi mæmpo wææ̈ Näatöö ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Näatöö wodi mæmpo wææ̈ Ämïnadabo, Ämïnadabo wodi mæmpo wææ̈ Adämïï, Adämïï wodi mæmpo wææ̈ Adöni, Adöni wodi mæmpo wææ̈ Etedöö, Etedöö wodi mæmpo wææ̈ Pade, Pade wodi mæmpo wææ̈ wacä docä Oodaa ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Mänïï docä Oodaa wodi mæmpo wææ̈ Aacobo, Aacobo wodi mæmpo wææ̈ Itæca, Itæca wodi mæmpo wææ̈ Abadäö, Abadäö wodi mæmpo wææ̈ Tade, Tade wodi mæmpo wææ̈ Näacodo ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Näacodo wodi mæmpo wææ̈ Tedogo, Tedogo wodi mæmpo wææ̈ Dagao, Dagao wodi mæmpo wææ̈ Pedego, Pedego wodi mæmpo wææ̈ Eebedo, Eebedo wodi mæmpo wææ̈ wacä docä Täna ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Mänïï Täna wodi mæmpo wææ̈ Caïnäö, Caïnäö wodi mæmpo wææ̈ Adapacadæ, Adapacadæ wodi mæmpo wææ̈ Temö, Temö wodi mæmpo wææ̈ Docä Nöwee, Docä Nöwee wodi mæmpo wææ̈ Nämeco ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nämeco wodi mæmpo wææ̈ Mäatotadëö, Mäatotadëö wodi mæmpo wææ̈ Ënoco, Ënoco wodi mæmpo wææ̈ Aadedo, Aadedo wodi mæmpo wææ̈ Mäadadede, Mäadadede wodi mæmpo wææ̈ wacä docä Caïnäö ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Docä Caïnäö wodi mæmpo wææ̈ Ënoto, Ënoto wodi mæmpo wææ̈ Teto, Teto wodi mæmpo wææ̈ Adäö, Adäö wodi ingante në badongaingä ïñömö edæ mönö Mæmpo Wængonguï ïnongä ingacäimpa. Mänïnäni ïñömö edæ Itota mæ̈mæ̈idi ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mänïï Oododänonga quëwëninque Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante ædæmö ëwocacä ïnongä inte Itota ïñömö wadæ gocantapa. Goyongante Wængonguï Önöwoca tömengä ingante önömæca ænte mäocä gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Godinque coadenta ëönæ mänimpoönæ quëwëñongante wënæ awënë pöninque, Wënæ wënæ cæe, ante ancaa cædongäimpa. Itota ïñömö mänimpoönæ cæ̈nämaï ïningä inte edæ ïinque bayonte gæ̈wænte wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Adinque wënæ awënë tömengä ingante, —Bitö näwangä Wængonguï Wëmi ïnömi inte dica incæ päö ämi ba cæ̈maïmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Äñongante, —“Cæntedö quëwenguï ï. Ïñæmpa Wængonguï nänö apæ̈nedö ante tömänö ante ëñente quëwengæ̈impa,” ante yewæ̈monte ongö apa, äninque Itota edæ Baa angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ayæ̈ Itota ingante onquiyaboga ænte mæ̈icä æite ongöñongante wënæ awënë wæætë inguipoga awënë odeyeidi ömæ tömäo ongöñömæ adoyömö a ongonte baï adotedæ̈ odömongä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Odömongä ayongante Itota ingante äninque wënæ awënë wæætë, —Awënëidi waincönë pönï ongöninque waëmoncooga mongæ̈ninque tæ̈ï pïñæ̈ninque tömënäni nempo quëwënäni ïnänite nanguï änäni ëñente do cædänipa, ante abii. Tömënäni waëmö pönï näni ëmömämo ante æcänö ëmonguingää, ante, Tæ̈ï pïñænte näni ënempodö ante æcänö empoquingää, ante, botö ïñömö edæ do ænte ënempogaïmo inte tömëmoque në ämo inte godömo æ̈nänipa. Ïninque bitö ïmite, Bado, godömo æ̈e, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ïninque bitö mänincoo æncæte ante botö weca ædæ wææ̈ninque, Tatänabi bitö Wængonguï baï ïnömi ïmipa, ämi adinque botö wæætë, Bado, bitö tömämæ Awënë babipa, ante edæ pönömo æ̈maïmipa, ante wënæ awënë änewengantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Angä ëñëninque Itota, —Ïïmaï ante yewæ̈mongatimpa. “Awënë Wængonguï weca ædæ wæænte tömengä ingante apæ̈nedinque, Bitö adobique Wængonguïmi ïmidö anguënë, ante watapæ̈ apæ̈necæbiimpa. Ayæ̈, Wængonguï beyænque cæcæbiimpa,” ante wææ yewæ̈monte ongö apa quëwëë, ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wënæ awënë ayæ̈ Itota ingante Eedotadëë ænte mäocä goyongante Wængonguï oncö ñæ̈næ̈ oncömäa ænte mæ̈icä æicantapa. Æite næ̈ gongæ̈ñongante wënæ awënë wæætë, Bitö näwangä Wængonguï Wëmi ïmipa, ante acædänimpa, ante bitö to wæibäwe. ");
INSERT INTO aucNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Äninque wënæ awënë godömenque apæ̈nedinque, “Ïïmaï ante do yewæ̈monte ongompa, Bitö ïmite wææ aacædänimpa, ante cædinque Wængonguï tömengä anquedoidi ïnänite da pönongä ");
INSERT INTO aucNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","pöninque bitö ïmite ïñæ̈ æmpodäni ïninque, bitö dicaa tee tëwadämaï incæbiimpa,” ante yewæ̈mongatimpa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Äñongä Itota wæætë, —Ïñæmpa ïïmaï ante ingatimpa. “Bitö, Mönö Awënë Wængonguï æbänö cæquingää, ante acæte ante cædämaï incæbiimpa. Ëñënämaï cæbo incæte edæ mönö Awënë Wængonguï botö ïmote cöwë wææ aaquingä, ante acæte ante wënæ wënæ cædämaï incæbiimpa,” ante wææ yewæ̈monte ongö apa änewëë, Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ante Itota angä ate wënæ awënë incæ, Itota wënæ wënæ cæcæcäimpa, ante nänö änewënö ïinque cædinque ïincayæ̈ ate nänö ponte cæquinque edæ wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Itota ïñömö Wængonguï Önöwoca nänö tæ̈ï pïñæ̈nö ëwocadinque Gadideabæ adodö pongacäimpa. Do pongäimpa, ante adinque wadäni wayömö gode ä gode ä cædäni ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tömengä ïñömö mänïömæ wayömö wayömö godinque tömënäni näni odömöincönë go guiite go guiite cædinque odömonte apæ̈necä adinque tömänäni, Waa pönï odömonte apæ̈necampa, ante tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wæætë Näatadeta tömengä nänö pægaïñömö pöninque tömënäni guëmanguïönæ ïñonte Itota nänö cöwë cæï baï ñöwo cæcantapa. Oodeoidi Wængonguï apæ̈necä näni ëñente yewæ̈mongainta ate odömöincönë go guiidinque tömengä mäninta ate apæ̈necæte ante ængæ̈ ganticä. ");
INSERT INTO aucNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Adinque tömengä ingante Itaiya wodi Wængonguï beyæ̈ nänö yewæ̈mongainta pædæ pönönäni ængantapa. Æ̈ninque, Mänïñömö yewæ̈monte ï, ante ñï cæpote adinque, Ïïmaï yewæ̈monte ongompa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wængonguï Awënë Önöwoca botonga pö guiicä ate botö tömengä ingante ëwocabopa. Ïninque tömengä botonga gao cæte baï cædinque tömengä nänö tæ̈ï pïñæ̈mämo da pönöninque botö ïmote angantapa. Bitö ömaadäni wæwënäni ïnänite Wængonguï Awënë waa pönö cæcæcäimpa, ante watapæ̈ apæ̈nebi ëñencædänimpa, angacäimpa. Në tee mönete baï wædäni ïnänite bitö, Wængonguï pönö wi æ̈necä beyænque mïnitö abæ tawænte gocæmïnimpa, ante godö apæ̈nebi ëñencædänimpa. Në babetamönäni ïnänite, Mïnitö wæætë waa acæmïnimpa, ante bitö godö cæcæbiimpa. Pïinte cædäni ate wæwente quëwëñönänite bitö wæætë gä pe æmpobi abæ tawænte baï gocædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ayæ̈, Wængonguï Awënë nänö waadete cæquïnepo do batimpa, ante apæ̈nebi ëñencædänimpa, ante Wængonguï botö ïmote do da pönongä pömo ïmopa.” ");
INSERT INTO aucNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ante Itaiya wodi nänö yewæ̈mongainta adinque adodö nä nä capodinque mänïñömö në cæcä ingante pædæ godöninque Itota tæ̈ contacantapa. Mänömaï cæcä adinque tömënäni näni odömöincönë në ongönäni tömänäni tömengä ingante cöwä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ayönänite, —Wængonguï botö ïmotedö ante apæ̈necä ëñëninque näni yewæ̈mongaïnö baï ñöwoönæ ëñëñömïni edæ do ïinque ba amïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ante apæ̈necä ëñëninque tömänäni, Tömengä nanguï waadete pönö tedecampa, ante apæ̈nedinque tömengä ingante waa adinque guïñente wædänitapa. —Ïingä ïñæmpa Ootee wengä ïmaingä inte bamönengæ̈ mänömaï cæcampa, ante awædö, ante näni caboque tededänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mänömaï ante wæyönänite Itota tömënäni näni pönënö ante önöwënenque ëñëninque, —Botö ïmote apæ̈nedinque mïnitö, “Bitö dotodo baï ïnömi inte nämä incæ cæte waa babäwe,” ante dodäni näni angaïnö baï ante tedemïni awædö. Ayæ̈, “Capënaömö ïñömö bitö waa cæbi adinque tededäni ëñëmönipa. Mänïñömö bitö cædïnö baï tömëmi ëñagaïñömö adobaï wïï cæbii,” ante wæmïni abopa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Äninque Itota godömenque apæ̈nedinque, —Näwangä ämopa. Wængonguï beyæ̈ në apæ̈necä ïñömö tömengä quëwënïñömö ponte apæ̈neyongante, Wïï ëñëïnë wædö, ante Baa änänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Näwangä edæ ämo ëñëedäni. Docä Ediya wodi quëwengäñedë mëa go adoque wadepo ayæ̈ tæcæ wadepo ïñonte tömënäni ömæ tömäo näni gæ̈wænte wægaïmämo baquinque cöönæ cædämaï ingatimpa. Mänïñedë Idægobæ ïñömö owæmpoïnäni nanguï ïnäni quëwëñönänite, ");
INSERT INTO aucNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","tömënäni weca Ediya ingante da godönämaï inte Wængonguï wæætë edæ, Bitö Tidöö eyequeï gote Tadepata ïñömö quëwengä owæmpoingä weca goe, angä gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Adobaï Wængonguï beyæ̈ në apæ̈negaingä Editeo wodi quëwengäñedë Idægobæ æ̈montai në baadäni nanguï ïnäni ïñönänite Wængonguï tömënäni ïnänite wadæ caadämaï inte wæætë edæ Tidiabæ quëwengä Näämäö ingante wadæ caacä waintai baagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ante Itota apæ̈necä ëñëninque mänincönë ongönäni tömänäni pïinte äïnäni badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Äïnäni badinque tömengä ingante tömënäni näni quëwëñömö yabæ ïnö wido cædänitapa. Ayæ̈ tömënäni näni mæ̈nonte quëwenquidi tömäne ænte mäo godinque tömënäni, Bæ tamö guidömëmæ̈ tæ̈ wææncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ante cæyönäni, Itota ïñömö tæcæguedë godinque aamö cæte wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wadæ godinque Gadideabæ Capënaömö näni quëwëñömö pöninque Itota tömënäni näni guëmanguïönæ bayonte tömënäni ïnänite odömonte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ëñëñönäni tömengä nämä tæ̈ï pïñæ̈ninque në angä ïnongä inte nö odömonte apæ̈necä ëñente wædinque tömënäni, Æ tömengä ïñömö nö pönï odömonte apæ̈necä ëñëmönipa, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mänïñedë edæ onguïñængä wënæ wentamö ëwocacä tönö në quëwengä ïñömö tömënäni odömöincönë a ongöninque ïñontobæ̈ yedæ ante aa pecantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Quïmæ̈ quëwëë. Bitö Itota Näatadeta quëwënïmi inte quïnante mönatö weca pömii. Mönatö ïmönate edæ æ̈mæ̈wo wido cæcæte ante wabänö pömitawo. Bitö æmömidö ïmii, ante botö do atabopa. Bitö Wængonguï Tæiyæ̈ Waëmö Wëmi ïnömi ïmipa, ante edæ do ëñëmopa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ante tedeyongante Itota wææ äninque, —Apocæ̈në quëwenguënë tedewëë. Waocä baönë quëwënömi inte edæ tao gobäwe. Angä ëñëninque wënæ guiquënë tömänäni ayönäni waocä ingante mäo tæ̈ gotodö go wææ̈ñongante tömengä baonga wënæ wënæ cædämaï inte tao gotapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Itota angä wënæ tao gocä adinque tömänäni guïñente wædinque nämäneque tededinque, —Tömengä æbänö cæte në angä ingää. Ïñæmpa në angä ïnongä inte tömengä tæ̈ï pïñæ̈ninque wënæidi në wentamö ëwocadäni ïnänite angä tao godäni awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ante pönente wædinque tömënäni, Itota mänömaï cæcampa, ante tededinque mänïömæ tömäo gode ä gode ä cædäni ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mänïï tömënäni odömöincönë ongonte apæ̈nedinque Itota tao godinque Timönö oncönë go guiicantapa. Go guiiyongante wadäni, Timönö nänöogængä wäänä ïñömö nanguï daicawo gawænte nangæ̈ bacampa cæbii, änäni. ");
INSERT INTO aucNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ëñëninque Itota tömengä weca go gongæ̈ninque daicawo inte pïinte baï äninque, Idæwaa impa, angä dæ batapa. Ïninque tömengä gancæ badinque ængæ̈ gantidinque tömënäni beyæ̈ cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nænque gäwadecæ̈ bayonte nantate wæwënäni ïnänite Itota weca ænte pönäni adinque tömengä wacä ingante wacä ingante godö gampocä ate tömënäni waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ayæ̈ waodäni nanguï ïnäni baönë wënæidi quëwëñönänite Itota angä ëñëninque tao godinque, —Bitö Wængonguï Wëmi ïnömi ïmipa, ante Yæ änänitapa. Ïninque Itota, Botö Codito ïnömo ïmopa, ante do ëñënänipa, ante wædinque wënæidi ïnänite, Apocæ̈në ïmäewedäni, ante edæ wææ angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ayæ̈ baänæ ate Itota wayömö önömæca gocantapa. Gocä adinque wadäni tömengä ingante ante diqui diqui minte tömengä weca do pöninque, Mönitö ïmönite ëmö cæte godämaï incæbiimpa, ante wææ cæcæte ante cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ate wædinque tömengä wææ äninque, —Botö, Wængonguï Awënë Odeye nempo watapæ̈ quëwenguïnö anguënë, ante cöwë apæ̈nequënëmo ïmopa. Wængonguï, Mänömaïnö ante apæ̈necæbiimpa, ante botö ïmote da pönongä pönïmo inte botö tömänäni quëwëñömö gote apæ̈nequënëmo inte gobopa. ");
INSERT INTO aucNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ante Oodeabæ godinque tömënäni odömöincönë go guii go guii cædinque Itota apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ayæ̈ Itota Guënetadetepæ̈ wedeca gote ongöninque Wængonguï nänö apæ̈nedö ante apæ̈necantapa. Ëñencæte ante cædinque nanguï ïnäni godongämæ̈ pö goto ongonte ëñëë congadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Apæ̈necä ëñëñönäni tömengä gomö ayongä gæyæ në dadöwënäni dicamöñæ̈ yamoncæte ante ti wææ̈ninque tömënäni näni ti wææ̈ godimpo mëa wipo gäwapæ̈ wedeca ömædempo wäï wocæ̈ acantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Adinque Itota adoque wipodë Timönö wipodë guiidinque tömengä ingante, Tæcæpæ̈no gämæ̈nö eyequeï wo go wäï wocæ̈e, angä gä go wäï wocængä ïninque Itota tæ̈ contate tömënäni ïnänite odömonte apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tömënäni ïnänite ïinque apæ̈nedinque Timönö ingante, —Bitö wipo tæcæpæ̈no godömenque ænte gobi ate mïnitö dicamöñæ̈ wo guitodonte gæyæ dadonte æncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Äñongä Timönö, —Awënë ëñëmi. Tömää woyowotæ̈ gæyæ dadoncæte ante dicamöñæ̈ ancaa guitodöñömöni wïï datapa. Incæte bitö ämi beyænque botö Ao ante cæcæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ante mäo guitodöñönäni gæyæ nanguï pönï da ate dicamöñæ̈ wodo wægo tengatimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ïninque Tïmönöidi wa wipodë ongönäni ponte godongämæ̈ æncædänimpa, ante ömö cædäni adinque wa wipo ænte pönäni ate gæyæ mëa wipodë eyede pönï ñönönäni ate wipo ëmä guiicæ cætimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ïninque, Itota angä beyænque gæyæ nanguï pönï æ̈mönipa, ante adinque Timönö Pegodo ïñömö Itota önöwa gäänë ædæ wææ̈ninque, —Awënë ëñëmi. Botö wënæ wënæ entawëmo ïñömote bitö waëmö pönï entawëmi inte nänënë goe, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ante guïñente wæyongante në dadöwënäni wadäni adobaï, Æbänö cæte nanguï pönï gæyæ dadonte æ̈möö, ante wædinque ancai guïñëninque Timönö tönö godongämæ̈ wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ayæ̈ Timönö tönö godongämæ̈ gæyæ në dadöwëna Tebedeo wodi wëna Tantiago tönö Wäö adobaï guïñente wægadaimpa. Ïninque Itota ïñömö Timönö ingante, —Guïñënämaï incæbiimpa. Gæyæidi gæte bitö æ̈maï bitö ïincayæ̈ ate waodäni ïnänite gæte baï cædinque apæ̈nebi ëñëninque ponte quëwencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Angä ëñëninque wipo ëmönaiya ænte mämö ñä cæcadodinque tömënäni mäincoo tömancoo edæ ëmö cædinque edæ Itota mïñæ̈ wadæ gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ïincayæ̈ ate Itota wadäni näni quëwëñömö gote quëwëñongante wacä cöwë baate ëñawënongä inte tömengä weca ponte guidömëmæ̈ ædæ wææ̈ninque angantapa, —Awënë, bitö Ao ämi inte wadæ caabi ïninque botö waintai baabaïmopa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Äñongä Itota pædæ wææmpo gampo caadinque, —Ao ämopa. Bitö waintai baacæbiimpa. Ante tæcæ äñongä ñömæ̈intai nänö ëñadintai edæ dæ baadinque tömengä waintai do baacantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ïninque Itota tömengä ingante, —Ëñëmi. Bitö waintai baadïmi inte wadäni ïnänite mäo apæ̈nedämaï ïe. Wæætë, Näwangä impa, ante acædänimpa, ante cædinque bitö, Wængonguï quï, ante në godongä weca töingä godinque waintai bitö baadintai odömömi ædæmö acæcäimpa. Ayæ̈ Möitee wodi wææ ante nänö angaincoo baï ænte pöninque bitö waintai bitö baadï beyæ̈ ante edæ, Wængonguï quï, äninque në godongä ingante pædæ godömi æncæcäimpa, ante wææ angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wææ angä incæte, Itota mänömaï cæcampa, ante nanguï gode ä gode ä cædäni ëñëninque nanguï ïnäni Itota apæ̈necä ëñencæte ante ayæ̈ tömënäni näni caate wædö waa bacæte ante goto pö goto pö cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Itota ïñömö wantæ wantæ ïñö önömæca nänënë godinque Wængonguï ingante wæætë wæætë apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ayæ̈ adobaï ïïmö ïñö ïïmö ïñö Itota cöwë odömonte apæ̈negacäimpa. Mänïñedë oodeoidi näni wææ angaïnö ante nanguï adinque në ëñënäni ïñömö në odömönäni ïnönänimpa. Wadäni adobaï, Mönö wææ angaïnö ante ëñente cæcæ̈impa, ante nanguï änäni guiquënë Paditeoidi näni änäni ïnönänimpa. Ïninque Itota mänïñedë odömonte apæ̈neyongä mänïnäni në odömönäni tönö Paditeoidi ïñömö Gadideabæ näni quëwëñömö ta Oodeabæ näni quëwëñömö ta pöninque ayæ̈ Eedotadëë ïñömö ta pöninque Itota weca pöninque tæ̈ contate a ongönänitapa. Mänïñedë wadäni wa wa badinque wënæ wënæ inte wædäni ïñönänite Itota ïñömö Awënë Wængonguï nänö tæ̈ï pïñæ̈nö entawëninque nanguï cæcä waa badönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ïninque wadäni në cömäingä nänö möimpataa æ̈mætæ̈ æ̈mætæ̈ bæi ongonte næ̈æ̈ninque, Itota weca ænte mangui ñö cæcæ̈impa, ante pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ponte ayönäni wadäni eyede pönï goto ongönäni adinque në ænte mämö pönïnäni ïñömö, Ædö cæte guiiquïï. Ante wædinque oncömäa ïnö æidämæ̈ mæ̈i æidinque dai bæte mæ̈nönïñömö epæ̈ cædäni ompite gongæ̈ñö tömënäni cömäingä möimpataa bæi ongöninque tömengä ingante godongämæ̈ ongönäni weca tæcæguedë Itota weca pædæ wææ̈nönäni ongongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mänömaï cædäni adinque Itota, Näwangä wede pönente cædänipa, ante adinque, —Æ̈migo, wënæ wënæ bitö cædïmämo ante ñöwo ñimpo cætimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Äñongä Paditeoidi tönö në wææ odömönäni nämäneque pönente tededinque, “Wënæ wënæ cædingä ingante æcänö ñimpo cæquingää. Ïingä ïñömö Wængonguï ingampa diyæ̈ mänömaï cæquingää. Edæ babæ ancædö.” ");
INSERT INTO aucNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ante pönëñönäni Itota tömënäni näni pönëwënö ante do ëñëninque, —Mïnitö mïmöno quïmæ̈ wënæ wënæ pönëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Në cömäingä nänö wënæ wënæ cædïmämo ante godö ñimpo cæbopa,” ante botö Wængonguï baï ämo ëñëninque mïnitö guiquënë, Wængonguï ingampa diyæ̈ mänömaï cæquingää, ante pönëmïnipa. Ayæ̈ wæætë, “Ængæ̈ gantidinque möimpata ænte dao dao gocæcäimpa,” ante botö Wængonguï baï ämo ëñëninque mïnitö adobaï, Wængonguï ingampa diyæ̈ mänömaï cæquingää, ante pönëmïni ïmaïmïnipa, ante awædö. Ïñæmpa mänömaïnö ante pönëmïni ïninque mïnitö edæ æbänö cæquënëmo ämïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Incæte botö Waobo ëñagaïmo inte inguipoga quëwëninque waodäni näni wënæ wënæ cædïmämo ante në ämo inte pönö ñimpo cæbopa, ante mïnitö edæ ëñencæmïnimpa, ante botö ïïmaï cæbopa. Äninque në cömäingä ingante edæ, —Bitö ïmite ämo ëñëe. Ængæ̈ gantidinque bitö möimpata topo cæte æ̈ninque tömëmi oncönë næ̈ænte goe. ");
INSERT INTO aucNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Angä ëñëninque cömäingä ïningä incæ edæ tömänäni ayönäni ængæ̈ gantidinque, Wængonguï ñäö baï ëmönongä inte pönö tæ̈ï pïñænte cæcä æ̈mopa, ante apæ̈nedinque tömengä nänö öñöninta topo cæte tao oncönë ænte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Gocä ate wædinque tömänäni, Æbänö cæcäï, ante ëñënämaï inte guïñente wædinque, Wængonguï bitö ñäö baï ëmömi inte waa pönï cæbi amönipa, ante watapæ̈ apæ̈negadänimpa. Ayæ̈, —Ñöwo ïñömö mä pönï cæcä amönipa, ante ancai guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ayæ̈ ate Itota tao gote ayongä odömäno awënë nänö äninta ante në ængä Debii ingante acantapa. Tömengä ïñömö Awënë nänö æ̈impa gäänë tæ̈ contate ongongä adinque Itota tömengä ingante, —Botö mïñæ̈ pöe. ");
INSERT INTO aucNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Angä ëñëninque do ængæ̈ gantidinque Debii mänincoo tömancoo ëmö cæte Itota mïñæ̈ wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ayæ̈ ate Debii, Itota beyæ̈, ante tömengä oncönë æ̈æ̈mæ̈ nanguï pönï cæcantapa. Ïninque æ̈æ̈mæ̈ becæte ante awënë beyæ̈ në æ̈wënäni nanguï ïnäni pö tæ̈ contate cæ̈ñönäni wadäni adobaï pö tæ̈ contate cæ̈näni. ");
INSERT INTO aucNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Adinque Paditeoidi tönö tömënäni në odömönäni guiquënë Itota mïñæ̈ në godäni ïnänite pïinte äninque, —Odömäno awënë beyæ̈ në æ̈wënäni tönö wadäni në wënæ wënæ cædäni tönö mïnitö quïmæ̈ godongämæ̈ ponte tæ̈ contate bete cæ̈mïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ante pïïñönäni Itota wæætë tömënäni ïnänite, —Në waa ingä guiquënë, Cæbi waa baboe, änämaï ïñongante në wënæ wënæ ingä guiquënë dotodo ingante, Cæbi waa baboe, ante do aa pecampa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pancadäniya, Nämä incæ në nö entawëmo ïmopa, ante në änäni ïñönänite botö ïñömö edæ në dotodo baï adobaï ïnömo inte tömënäni ïnänite aa pedämaï incæboimpa. Wadäni guiquënë, Nämä wënæ wënæ cæbo ïmopa, ante në änäni ïñönänite botö, Tömënäni, Idæwaa wënæ wënæ cæte awædö, ante Wængonguï gämæ̈nö poncædänimpa, ante cædinque tömënäni ïnänite aa pecæ pongaboimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Itota ingante ïïmaï ante ayæ̈ änänitapa. Wäö mïñæ̈ në godäni ïñömö, Wængonguï beyæ̈, ante ee ate cæ̈nämaï ïnänipa. Ayæ̈ Paditeoidi mïñæ̈ në godäni adobaï ee ate cædänipa. Bitö mïñæ̈ në godäni guiquënë do cænte bete quëwënänipa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Änäni ëñëninque Itota wæætë, —Onguïñængä në monguingä wente ænte pönäni ïñönänite mïnitö wæætë, Ee ate cæ̈nämaï ïedäni, ante edæ ædö cæte wææ anguïmïnii. Monguingä nänö wente ænte në pönäni baï ïnönäni inte botö mïñæ̈ në godäni ïñömö ædö cæte wæwente baï cæ̈nämaï inguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wæætë ayæ̈ ate guiquënë, Monguingä, näni në änongä baï ïñömote wadäni ponte botö ïmote ö ænte gocædänimpa. Mänömaï cædäni ate botö mïñæ̈ në godäni ïñömö mänïñedë ate wæætë cæ̈nämaï inte wæcædänimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ayæ̈, Wængonguï Awënë nempo quëwëninque æbänö cæquïï, ante ëñencædänimpa, ante Itota ïmæca quëwënäni näni cæïnö ante odömonte ïïmaï ante apæ̈necantapa. —Mïincoo badonte ate waocä dicæ adocoo wänä ñænte pancacooga æ̈ninque pedæncooga pönö tadömonguingäa. Mänömaï cæcä ïninque edæ mïincoo incæ do wänä tente baquënë. Ayæ̈ pedæncoo ëmönö baï mïincoo wïï adobaï ëmompa. Mïnitö, Awente baï cæ̈nämaï inte mönö quëwengæ̈impa, ante mïni änewënö guiquënë pedæncoo baï inte wote baquïne ënepa. Wængonguï gämæ̈nö pöninque quëwencæmïnimpa, ante botö apæ̈nedö guiquënë mïincoo baï inte quëwenguïne ënepa. Ïninque wote baquïne tönö quëwenguïne tönö ædö cæte mënea ante ëñente cæquïï. ");
INSERT INTO aucNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ayæ̈ adobaï yowepæ̈ biïnömæ̈ mïïmæ̈ æ̈ninque waocä ædö cæte picæ̈ æ̈montaicadedë godö pe ñïñænguingää. Ïñæmpa picæ̈ æ̈montaicadedë pe ñïñængä ïninque edæ tæi æbæ æ̈mæ̈wo goquënë. ");
INSERT INTO aucNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mïïmæ̈ wæætë mïincadedë pe ñïñængæ̈impa. Adobaï botö odömönö mïïmæ̈ baï ïñonte dodäni näni odömöwënö ædö cæte botö odömönö tönö adoyedë ëñente cæquïï. ");
INSERT INTO aucNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Incæte, “Gönæ̈nïmæ̈ ïñömö waëmepæ̈ ïmæmpa,” ante në bedömïni inte mïnitö mïïmæ̈ ædö cæte quingæ̈ bequïmïnii, ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayæ̈ ate guëmanguïönæ ïñonte Itota tömëmoncodë tæcæguedencodë gocantapa. Goyongä tömengä mïñæ̈ në godäni ïñömö tömëmö inca tä pete æ̈ninque dacæ dacæ cædinque ade cæ̈ ade cæ̈ godäni. ");
INSERT INTO aucNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Adinque Paditeoidi guiquënë, —Ïñæmpa, Guëmanguïönæ ïñonte mänïnö baï cædämaï ïedäni, ante dodäni näni wææ angaïnö ante mïnitö ëñënämaï inte quïmæ̈ cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ante pïïñönänite Itota, —Docä Dabii wodi tömengä nänö ëmïñæ̈näni tönö ömæpodäni inte gæ̈wænte wædinque æbänö cægadänii, ante yewæ̈monte öñö incæ mïnitö ïñæmpa adämaï inte baï ämïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wængonguï quï, ante në godönänique cænguï impa, ante wææ näni angaïnö baï cædinque dodäni päö, Wængonguï quï, ante ñoncæ ñoncæ cædönänimpa. Incæte Dabii wodi Wængonguï oncönë go guiidinque mänïï päö do ænte cæ̈ninque tömengä mïñæ̈ në godäni ïnänite godömenque godongä cæ̈nänitapa, ante yewæ̈monte öñö apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ante apæ̈nedinque Itota tömënäni ïnänite ayæ̈ apæ̈necantapa. —Botö ïñömö Waobo në ëñagäïmo ïñömö Tæiyæ̈ Awënë ïnömo inte edæ guëmanguïönæ Awënë ïnömo ïmopa. Ïninque botö, Guëmanguïönæ ïñonte edæ æbänö cæquïï, ante adobo në Ämo ingaïmo ïmopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ïincayæ̈ ate guëmanguïönæ adobaï waönæ ïñonte Itota oodeoidi odömöincönë go guiite odömonte apæ̈neyongä onguïñængä önompo tömëmæ̈ ïnö nï cömampote wædongä inte mänïñömö a ongongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mänïñedë në odömönäni tönö Paditeoidi guiquënë, Itota wapiticæ̈ cæcä ïninque mönö wæætë pïinte angæ̈impa, ante në änewënäni ïnönänimpa. Ñöwo ïñömö tömënäni, Ñöwoönæ guëmanguïönæ ï incæte Itota nï cömampoingä ingante, Waa bacæcäimpa, ante cæcä ïninque mönö mäo pïinte angæ̈impa, ante babæ cæcæte ante cöwä adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mänïnö, Mönö pïingæ̈impa, ante näni pönëwënö ante Itota ïñömö önöwënenque edæ do ëñëninque edæ nï cömampoingä ingante, —Bitö ængæ̈ gantidinque tæcæguedë pö næ̈ gongæ̈e. Angä ëñëninque ængæ̈ gantidinque pö næ̈ gongængantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ïninque Itota në pïinte ancædäni ïnänite, —Ämo apæ̈nemïni ëñëmoedäni. Guëmanguïönæ ïñonte mönö æbänö cæquënëmö ïmöö, ante wææ angatïï, ante pönëmïni. Mönö waa cæquënëmö ïmompa, ante pönëmïnitawo. Wæætë edæ, Mönö wënæ wënæ cæquënëmö ïmompa, ante pönëmïnitawo. Guëmanguïönæ ïñonte edæ, Quëwencædänimpa, ante cæquënëmö ïmompa, ante pönëmïnitawo. Wæætë mönö edæ ömæ̈e ëwenguënëmö ïmompa, ante pönëmïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Äninque æ̈mætæ̈ gomö æ̈mætæ̈ gomö edæ tömänäni ïnänite adinque nï cömampoingä ingante, —Pædæ pompobi. Angä ëñente cædinque në cömampodingä incæ pædæ æmpote edæ ædæmö waa empocä bapocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ïninque tömënäni, Guëmanguïönæ incæ mänömaï cæcampa, ante ænguï badinque, Itota ingante mönö æbänö cæquïï, ante pïïninque näni cabo nämäneque tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mänïñedë Wængonguï ingante apæ̈necæte ante Itota änanquidi æidinque tömää woyowotæ̈ apæ̈nee congantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ñäö ba adinque tömengä mïñæ̈ në pönïnäni ïnänite aa pecä pönäni ate tömengä, Botö beyæ̈ në gode ämïni incæmïnimpa, ante dote ganca ïnäni mänimpodäni ïnänite apænte ængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tömengä nänö në da godönäni baquïnäni ïñömö edæ ïïmaï ëmönönänimpa. Tänocä Timönö ëmongä ingä incæte Itota wawo Pegodo pemongacäimpa. Ïingä Pegodo tönö Æntade näna caya, Tantiago tönö Wäö näna caya, Pedipe tönö Batodömëë, ");
INSERT INTO aucNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mäateo tönö Tömato, Adepeo wengä Tantiago ïnönänimpa. Ayæ̈, Mönö ömæ ingæ̈impa, ante nanguï cædongä inte wacä Timönö ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Tantiago wengä Codaa tönö Itota ingante odömonte në godonguingä ingaingä inte wacä Codaa Icadiote näni änongä ïnatapa. Mänimpodäni ïnänite Itota apænte ængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mänimpodäni tönö Itota mæ̈mö ïñömö wææ̈ninque næ̈ gongænte ongongantapa. Mänïñömö tömengä mïñæ̈ në godäni nanguï ïnäni do ponte a ongönönänimpa. Ayæ̈ tömënäni tönö wadäni Eedotadëë ïñömö quëwënäni tönö Oodeabæ tömäo quëwënäni ayæ̈ Tido eyequeï Tidöö eyequeï gäwapæ̈ wedeca quëwënäni nanguï ïnäni do ponte a ongönönänimpa. Tömënäni, Itota apæ̈necä ëñengæ̈impa, ante ayæ̈, Wënæ wënæ inte wæwëmö inte mönö waa edæ bacæ̈impa, ante pöninque a ongönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ayæ̈ wënæidi në wentamö ëwocadäni tönö quëwente wæwënäni mänïñömö ponte ongönäni ïnänite Itota adoyömö wææ̈ pöninque godö cæcä waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ayæ̈, Itota tæ̈ï pïñænte entawengä inte pönö cæcä ate waa badänipa, ante adinque tömänäni tömengä ingante gampocæte ante cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ayæ̈ Itota tömengä mïñæ̈ në godäni ïnänite gomö adinque apæ̈necä ëñënänitapa. “Mïnitö, Botö waëmö ïmopa diyæ̈ Awënë Odeye nempo guiiquïmoo, ante në wæwëmïni ïñömö watapæ̈ mïni toquinque Wængonguï Awënë Odeye nempo mïni quëwenguïnö edæ do ëamïnipa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Inguipogaque gæ̈wænte wæmïni inte edæ mïni watapæ̈ toquinque Wængonguï pönongä tömo pönï cæncæmïnimpa,” angantapa. “Mïnitö inguipogaque wæwente quëwëmïni inte edæ mïni watapæ̈ toquinque Wængonguï pönö waadete cæcæcäimpa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Botö Waobo ëñagaïmo mïñæ̈ gomïni beyænque wadäni mïnitö ïmïnite badete todinque pïinte adinque wido cædänitawo. Botö beyænque mïnitö ëmöwo ante, Wïwa ëmöwo awædö, ante Baa änänitawo. Edæ mïni waa toquinque inguipogaque mänömaï cædänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Öönædë mönö ænguïnö ante nanguï ongompa, ante pönëninque mïnitö ñöwodäni näni pïinte cæyedë incæ watapæ̈ toedäni. Ïïnäni në pïinte cædäni wæ̈mæ̈idi incæ Wængonguï beyæ̈ në apæ̈negaïnäni ïnänite edæ adobaï pïinte cægadänimpa, ante toquënë wæwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wæætë edæ mäincoo nanguï në ëamïni guiquënë ïincayæ̈ ate mïni wæquinque edæ inguipogaque watapæ̈ quëwëmïnipa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Në tömo cæ̈mïni guiquënë ïincayæ̈ ate mïni gæ̈wænte wæquinque edæ inguipogaque tömo cæ̈mïnipa,” ante apæ̈necantapa. “Në Ca ca tomïni adobaï ïincayæ̈ ate Ca ca mïni wæquinque edæ inguipogaque tomïnipa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mïnitö ïmïnite ante tömänäni waa apæ̈nedäni ïninque edæ mïni wæquinque ingæ̈impa. Ïñæmpa ïïnäni në waa apæ̈nedäni adodäni mæ̈mæ̈idi adobaï cægadänimpa. Wadäni babæ wapiticæ̈ apæ̈nedäni incæ, Wængonguï beyæ̈ në apæ̈nebo ïmopa, ante në änewënäni ïnänite ïïnäni mæ̈mæ̈idi ïñömö adobaï waa apæ̈negadänimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ayæ̈ godömenque apæ̈nedinque Itota, “Mïnitö në ëñëmïni ïñömïnite ämo ëñëedäni. Mïnitö ïmïnite në pïinte cædäni ïnänite mïnitö wæætë waadete cæedäni. Mïnitö ïmïnite në pïinte adäni ïnänite mïnitö wæætë waa cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wënæ wënæ bacæmïnimpa, ante në änäni ïnänite mïnitö wæætë waa apæ̈nete godö cæedäni. Mïnitö ïmïnite në wënæ wënæ cædäni ïnänite mïnitö wæætë tömënäni beyæ̈ ante Wængonguï ingante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wacä bitö ïmite ïmæmpaga ïnö tamongä wædïmi inte bitö wæætë æ̈mæmpaga ïnö dadi ëmæ̈monte ee ongömi tamongäe. Ayæ̈ yogui beyæ̈ bitö yabæcoo ö ængä adinque önönancapæncoo tönö ee abi ö ængäe. ");
INSERT INTO aucNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mäincoo ante në angä ingante tömengä nänö änoncoo edæ ee godömi ængäe. Ayæ̈ bitö mäincoo në ö ængä ingante, Wæætë adodö pönömi æ̈moe, änämaï incæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mïnitö, Wadäni botö ïmote waa cæcædänimpa, ante wæmïnitawo. Edæ mänïnö ante mïni wædö baï adobaï wædänipa, ante pönëninque mïnitö wæætë wadäni tömänäni ïnänite waa cæedäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ayæ̈ apæ̈nedinque, “Mïnitö ïmïnite në waadedänique ïnänite waadete pönëmïni inte wadäni ïnänite waadedämaï ïmïni adinque edæ Wængonguï dicæ mïnitö ïmïnite waadete pönö aquingäa. Ïñæmpa në ëñënämaï cædäni incæ në waadete pönënänique ïnänite waadete pönëninque mïnitö cæganca do cædänipa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ayæ̈ adobaï mïnitö ïmïnite waa cædänique ïnänite waa cæmïni inte wadäni ïnänite waa cædämaï ïmïni adinque Wængonguï mïnitö ïmïnite dicæ waa aquingäa. Ïñæmpa mïnitö cædö baï në ëñënämaï cædäni incæ adobaï do cædäni apa cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ayæ̈, Adodö pönongä æncæboimpa, ante pönëwëninque mïnitö në adodö pönonguingä ingante godömïni inte wadäni ïnänite godönämaï ïmïni adinque Wængonguï mïnitö ïmïnite dicæ waa aquingäa. Ïñæmpa në ëñënämaï ïnäni näni cabo incæ, Adodö pönongä æncæboimpa, ante pönëwëninque në adodö pönonguinganque ingante godöninque mïnitö cædö baï adobaï cædänipa töö.” ");
INSERT INTO aucNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Wæætë mïnitö ïmïnite në pïïnäni ïnänite waadete pönëninque waa cæedäni. Ayæ̈ tömënäni näni änö ante, Adodö pönömi æ̈moe, ante änämaï inte ee godömïni æncædänimpa. Mänömaï waadete cæmïni ïninque mïnitö ïincayæ̈ ate mïni waadete cægaïnö beyæ̈ nanguï æ̈maïmïnipa. Ayæ̈ mönö Mæmpo Æibæ pönï në Quëwengä ïñongante tömengä ingante në waa ate pönënämaï ïnäni ïnänite tömengä godö waadete cæcampa. Në wïwa cædäni ïnänite tömengä godö waadete cæcampa. Ïninque mïnitö tömengä nänö cæï baï adobaï waadete cæmïni ïninque Mæmpocä waadete nänö entawënö baï mïnitö adobaï entawëninque tömengä wëmïni ïmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mönö Mæmpo pönö waadete nänö waa cægaï baï mïnitö adobaï wadäni ïnänite godö waadete waa cæedäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ayæ̈ wæætë Itota ïïmaï ante apæ̈necantapa. “Wacä ingante apænte änämaï ïmïni ïninque mönö Mæmpo wæætë mïnitö ïmïnite apænte änämaï incæcäimpa. Ayæ̈, Wacä nänö tente wæquinque wënæ wënæ cæcampa, ante änämaï ïmïni ate mönö Mæmpo wæætë, Mïni tente wæquinque wënæ wënæ cæmïnipa, ante apænte änämaï incæcäimpa. Wacä wënæ wënæ cæcä ingante mïnitö ñimpo cæmïni ee gocä ate mönö Mæmpo adobaï mïnitö ïmïnite ñimpo cæcä quëwencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wadäni ïnänite ee godöedäni. Mïnitö ee godömïni æ̈näni ïninque wadäni wæætë mïnitö ïmïnite ee pönönäni æncæmïnimpa. Në pönönäni ïñömö tömënäni näni tee mäincadedë da wëninque da wææ̈nonte wancæ wancæ cædinque eyepote wæænguinque eyede pönï da wëninque mïnitö ænguincadedë pönö wäne cædäni edæ æncæmïnimpa. Edæ mïnitö tee mante mïni godöincade incæ adocadeca tee mante baï cædinque Wængonguï mïnitö ïmïnite eyepæ̈ pönongä æncæmïnimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ayæ̈, Wængonguï Awënë nempo quëwëninque æbänö cæquïï, ante ëñencædänimpa, ante Itota ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. “Babetamongä ingante wacä babetamongä incæ ædö cæte mäo odömongä goquingää. Ïñæmpa mänömaï cædinque näna babetamoncaya ompite adopiticæ̈ guëa go wææ̈ guiibaïnapa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Në odömonte apæ̈necä ïñömö në ëñengä inte odömöñongante tömengä nänö në ëmïñængä guiquënë dicæ godömenque ëñengä ingäa. Incæte ïinque odömonte apæ̈necä ëñëninque tömengä nänö në ëmïñængä abæ tawæ̈ninque wæætë në odömongä baï bacæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ayæ̈ apæ̈nedinque, “Bitö tönïñacä wædænque wënæ wënæ cæcä ïñongante bitö guiquënë nanguï bitö wënæ wënæ cædïnö ante wædämaï ïnömi inte tömengä ingante quïnante pïinte änewëmii. Ïñæmpa tömëmi awinca gäänë awæmpa wææ ongompa, ante adämaï inte baï cæbipa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tömëmi awinca gäänë awæmpa wææ ongompa, ante bitö adämaï inte bitö tönïñacä ingante, ‘Biwï, bitö awinca guiyä mæ̈ owo baï ate æ̈ wimömoe,’ ante edæ abipa ænguïmii. Ïñæmpa bitö në wadö tedete wadö cædömi inte edæ tömëmi awinca gäänë wææ ongompa täno wido cæte ate edonque adinque bitö tönïñacä awinca guiyä owodö æncæbiimpa,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ayæ̈ godömenque apæ̈nedinque Itota, “Waincawæ̈ incæ ædö cæte baaca incaquïï. Wæætë wïwa ïwæ̈ incæ ædö cæte wainca incaquïï. ");
INSERT INTO aucNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Awæ̈ æbänö ïwæ̈, ante ëñencæte ante mönö tömenca tä pete bete ëñengæ̈impa. Iigowæ̈ñeca æncæte ante waodäni dicæ daa mongæ̈wäa edæ tä pete æ̈näniyaa. Yowemö æncæte ante waodäni dicæ daacamëña tä pete æ̈näniyaa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mönö waocabo ïñömö adobaï ïnömö inte cæmompa. Mïmönë mönö pönëmämo eyede tate baï tao godedinque mönö mänïmämoque ante pönëninque tedemompa. Waocä në waa cæcä guiquënë waa pönï tömengä nänö pönënö ante entawëninque waa tedecampa. Në wïwa cæcä guiquënë tömengä nänö wïwa pönënö ante entawëninque wïwa tedecampa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ayæ̈ godömenque apæ̈nedinque, “Mïnitö ïñömö botö ïmote, ‘Awënë, mönitö Awënë ïmipa,’ ante tedemïni incæte botö änö ante quïnante wïï ëñente cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ñöwo ïñömö edæ apæ̈nebo ëñëedäni. Botö gämæ̈nö ponte ëñëninque waocä botö änö ante do ëñente cæcä ïñömö tömengä ïïmaï ingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Waocä adocanque oncö mæ̈noncæte ante guiibæ æ̈æ̈ wodinque dicaboga mæ̈noncæte ante gönongä baï në ëñente cæcä ïñömö adobaï cæcä ingampa. Tömengä oncö tæ̈ï mæ̈nonte ongö ïninque æpæ̈ äninque quingæ̈ pö incæte oncö ædö cæte wancæ wancæ cæquïï. Ïñæmpa tæ̈ï mæ̈nonte ongompa. ");
INSERT INTO aucNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wæætë waocä guiibæ æ̈æ̈ wote gönönämaï yabæque oncö mæ̈nongä ate yabæque mæ̈nöïñömö æpæ̈ äninque pö ate oncö dobæ bogo cæte tæ̈ wææ̈ninque æ̈mæ̈wo gopa. Botö apæ̈nebo ëñëninque waocä në ëñënämaï cæcä ïñömö tömengä në yabæque mæ̈nongä baï inte ocai incadämaï inte baï ëñënämaï cæcampa,” ante Itota ïinque apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ayæ̈ tömënäni ïnänite ïinque apæ̈nedinque Itota Capënaömö näni quëwëñömö gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mänïñömö quëwëninque odömäno tontadoidi awënë capitäö ingante në cæcä ïñömö wënæ wënæ badinque æ̈mæ̈wo wæncæ cæcä ingantapa. Awënë capitäö ingante në cæcä ïñongante awënë wæætë tömengä ingante nanguï waadecantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ïninque, Itota waa cæcä ingampa, ante mämö apæ̈nedäni ëñëningä inte tontado capitäö ïñömö oodeoidi ïnänite në aadäni näni Picæncabo ïnänite apæ̈nedinque, Mïnitö Itota weca godinque tömengä ingante ämïni ëñente pöninque tömengä wæætë botö ïmote në cæcä ingante cæcä waa bacæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Angä ëñente godinque në aadäni näni Picæncabo guiquënë Itota weca pöninque tömengä ingante nanguï änänitapa. —Mönö oodeocabo ïñömonte mäningä tontado capitäö ïñömö mönö ïmonte waa cæcampa, ante wædinque bitö tömengä beyæ̈ waa cæcæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tömengä ïñömö mönö oodeocabo ïñömonte waadete cædinque, Wængonguï apæ̈necä näni ëñente yewæ̈mongainta ate mïnitö odömöincö impa, ante do mæ̈nonte pönongä æ̈mompa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Änäni ëñëninque Itota në aadäni näni Picæncabo tönö wadæ gocantapa. Oncö obo pöñönänite tontado capitäö ïñömö tömengä guiidënäni ïnänite, Go bee tëninque botö beyæ̈ Itota ingante ïïmaï ante apæ̈needäni, angantapa. “Awënë ee ongöe. Botö waëmö ïmopa diyæ̈ bitö botö oncönë pö guiiquïmii, ante capitäö bitö ïmite angampa,” ante apæ̈needäni, angä ponte apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ayæ̈ adobaï, “Botö wïï waëmö ïnömo inte edæ bitö weca pönämaï intabopa. Incæte bitö adoyömö ongöninque ämi ïninque botö ïmote në cæcä waa bacæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bitö ïñömö Awënë Wængonguï ingante në ëñente cædömi ïmi baï botö adobaï wacä awënë ingante në ëñente cæbo ïmopa. Ïninque botö awënë ëabo inte botö awënë beyænque ämo ëñëninque tontadoidi wæætë guïñente wædinque botö änö ante cædänipa. Ïninque adocanque ingante botö, Goe, ämo ëñëninque edæ do gocampa. Wacä ingante, Pöe, ämo ëñëninque edæ do pongampa. Ayæ̈ botö ïmote në cæcä ingante, Cæe, ämo ëñëninque edæ do cæcampa.” Mänömaïnö ante Itota ingante botö beyæ̈ ante apæ̈nemïni ëñengäedäni, ante tontado capitäö ïñömö tömengä guiidënäni ïnänite angä godinque tömënäni wæætë capitäö nänö änö baï ante Itota ingante adodö ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mänömaïnö ante tontado awënë beyæ̈ apæ̈nedäni ëñëninque Itota wæætë, Mäningä tontado awënë ïñömö waa pönï ëñengampa, ante wædinque godongämæ̈ ongönäni ïnänite, —Näwangä ämopa. Mönö idægocabo ïñömonte mäningä wede pönengä ingä baï adocanque incæ edæ dæ angä awædö, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ayæ̈ në bee tencæ pönïnäni oncönë wadæ gote ayönäni capitäö ingante në cæcä ïñömö do waa bacä agadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Itota ïñömö ïïmö ate Näïno näni quëwëñömö gocæte ante goyongante tömengä nänö në ëmïñæ̈näni tönö wadäni nanguï ïnäni godongämæ̈ gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mänïñömö yabædemö obo pöñongä onguïñængä æ̈mæ̈wo wæ̈ningä ingante næ̈ænte pönänitapa. Tömengä badä owæmpoingä ïnongä inte tömengä wengä adocanque wængä wædinque pongantapa. Ayæ̈ mänïñömö quëwënäni nanguï ïnäni wäänä tönö godongämæ̈ pönäni acantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wäänä ingante adinque Itota tömengä tönö guëa wæwente baï pönëninque, —Wædämaï ïe. ");
INSERT INTO aucNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Äninque do wæ̈ningä ingante tömënäni näni daga wenguimpa gäänë ponte gampocä ate në næ̈æ̈nïnäni næ̈ gongæ̈nänitapa. Itota ïñömö, —Edënïmi, bitö ïmite ämopa. Ængæ̈ gantie, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ëñëninque në wæ̈ningä incæ ængæ̈ gantidinque tæcæ tedecä adinque Itota wäänä ingante pædæ godongä ængantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Itota mänömaï cæcä adinque tömänäni nanguï guïñente wædinque Wængonguï ingante watapæ̈ apæ̈nedinque, —Wængonguï beyæ̈ në apæ̈necä tæ̈ï ëmongä ïnongä inte mönö weca a ongongä amompa, änänitapa. Ayæ̈, —Wængonguï quïmö ïñömonte Wængonguï incæ mönö weca ponte godongämæ̈ cæcampa. Näwangä impa, ante nanguï todänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ayæ̈ Oodeabæ tömäo quëwënäni ïnänite wayömö gomonga quëwënäni ïnänite mäo gode ä gode ä cæte, Itota æbänö cæcää, ante apæ̈nedäni ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wäö mïñæ̈ në godäni adobaï, Itota æbänö cæcä ingää, ante ëñëninque Wäö ingante mämö apæ̈nedäni ëñengantapa. Mänïnö ante apæ̈nedäni ëñente wædinque Wäö ïñömö tömengä mïñæ̈ në goda mënaa ïnate äñecä pönatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pöna adinque Wäö tömëna ïnate, Mïnatö mönö Awënë weca godinque botö beyæ̈ ante ïïmaï ante äeda, angantapa. Awënë ëñëmi. Bitö ïñömö dodäni näni, Në Ponguingä, angaïmi adobi ïmitawo. Wæætë tömënäni näni në angaïmi ïnämaï ïmi ïninque bitö wæætë, Wacä ponguingä, ante wänö cöedäni, ämitawoo. Æbänö mönitö cæquïmönii, ante botö beyæ̈ ante ëñencæte ante äeda. Ante Wäö mënaa ïnate Itota weca da godongä godatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Godinque Itota weca pöninque ïïmaï ante apæ̈nedatapa. —Wäö æpæ̈në në guidönongä ïñömö mönatö ïmönate da pönöninque bitö ïmite ïïmaï angampa. Awënë ëñëmi. Dodäni näni, Në Ponguingä, angaïmi bitö ïñömö adobi ïmitawo. Wæætë tömënäni näni angaïmi ïnämaï ïmi ïninque bitö wæætë, Wacä ponguingä, ante wänö cöedäni, ämitawo. Æbänö mönitö cæquïmönii, ante ëñencæte ante Wäö mönatö ïmönate da pönongä pontamönapa, änatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mänïñedë incæ daicawo gawæ̈näni tönö wënæ wënæ inte wæwënäni nanguï ïnäni ïnänite Itota godö waa cæcä waa badänitapa. Wënæidi në wïwa ëwocadäni ïnänite tömengä wido cæcä ate waodäni nanguï ïnäni waa badänitapa. Babetamönäni nanguï ïnäni ïnänite tömengä gampomongä waa bamönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ïninque mänömaï cæcä waa ayönate ñöwo pöna ïnate Itota, —Botö godö cæbo ate babetamö ïnïnäni incæ do adäni amïnapa. Cömante ïnïnäni incæ waa bate dao dao godäni amïnapa. Baate ïnïnäni incæ ñöwo æ̈montai waëmontai baadäni amïnapa. Babetamonca ïnäni ïñönänite botö godö cæbo ate önömonca ëñënäni badäni amïnapa. Do æ̈mæ̈wo wænte öñönäni ïñönänite botö godö cæbo ate ñäni ömæ̈monte quëwënäni amïnapa. Ömaadäni inte wæwënäni ïnänite botö Wængonguï Awënë pönö waa cæcæcäimpa, ante watapæ̈ apæ̈nebo ëñencædänimpa. Ïninque mïnatö ponte ëñëñömïna botö æbänö apæ̈nebo ëñëmïnatawo, ante ayæ̈, Botö æbänö cæbo amïnatawo, ante mïnatö ñöwo wæætë Wäö weca gote mäo apæ̈nemïna ëñengäeda, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ayæ̈, “Botö beyæ̈ waocä wïï pïinte wadæ gocä ïñömö tömengä nänö watapæ̈ toquinque oda cædämaï incæcäimpa, ante Wäö ingante mäo apæ̈nemïna ëñencæcäimpa,” ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Angä ëñëninque Wäö beyæ̈ në änïna wadæ goda adinque Itota wæætë godongämæ̈ ongönäni ïnänite, Wäö æbänö ingää, ante apæ̈necantapa. “Mïnitö guiquënë quïnö acæte ante önömæca gomïnitapa. Cæ̈wipa woboyæ̈ pæ̈mænte ate æ̈mæ̈nö ædæ æ̈mæ̈nö ædæ gobaingä ingante mïnitö dicæ acæ gomïnitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ïninque edæ quingänö ingante acæte ante gomïnitapa. Edæ waocä weocoo waëmoncoo mongæ̈nongä ingante mïnitö dicæ acæ gomïnitawogaa. Ïñæmpa weocoo waëmoncoo në mongæ̈näni ïñömö nämanque ante pönente näni ænte mäincoo beyæ̈ ante në towënäni inte tömënäni ïñömö awënë oncönë quëwënäni apa quëwënänii. ");
INSERT INTO aucNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ïninque edæ quïnante gomïnitawo. Mïnitö mïni në go acæ cædongä ïñömö edæ Wængonguï beyæ̈ në apæ̈necä ingantawo. Näwangä impa. Wængonguï beyæ̈ në apæ̈necä Wäö ingampa. Incæte tömengä wïï Wængonguï beyæ̈ në apæ̈negaïnäni baï ïnongä inte godömenque nanguï cæcä ingampa, ante apæ̈nebo ëñëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wængonguï ïïmaï angampa, ante yewæ̈mongatimpa. ‘Botö beyæ̈ në apæ̈necä ingante da godömo godinque tömengä taadö täno beyænte baï cæcæcäimpa. Tömengä bitö Codito ïmi beyæ̈ ante taadö waa pïnonte baï waa cæcæcäimpa.’ Mänömaïnö ante dodäni adocä Wäö ingantedö ante pönëninque yewæ̈mongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ñöwo ïñömö ämo ëñëedäni. Ïmæca mïni ëñagaincabo ïñömïnite æpæ̈në mönö në guidönongä Wäö adocanque ñæ̈nængä ïñongante wacä tömengä baï edæ dæ angampa. Incæte Wængonguï Awënë Odeye nempo quëwënäni ïñönäni adocanque guiyangä pönï ingä incæte Wäö pönömenque wædangä ingampa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Itota mänömaïnö ante apæ̈necä në ëñënäni ïñömö odömäno awënë beyæ̈ në æ̈wënäni incæ wadäni incæ tömänäni Wäö nänö në guidongaïnänique ïnönänimpa. Ïninque tömënäni, Wængonguï nö cæcä ingampa, ante tömänäni apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Paditeoidi tönö idægoidi näni wææ angaïnö ante në ate ëñënäni guiquënë Wäö nänö guidongaïnäni ïnämaï ïnönänimpa. Ïninque tömënäni guiquënë Wængonguï gämæ̈nö ponguënënäni incæte edæ Baa änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Godömenque apæ̈nedinque Itota ïïmaï angantapa. “Mänömaï ï ïninque inguipogaque ante në quëwënäni ïñömö quingämë baï ïnänipa. Quïëmë baï edæ quëwënänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wëñæ̈näni mönö godonte æ̈ïñömö tæ̈ contate owempodäni näni owempodö baï edæ adobaï cædänipa, ante awædö. Wëñæ̈näni näni owempote cæcabo incæ æ̈æ̈mæ̈ cæte baï owempote cædinque wadäni ïnänite aa pedänipa. ‘Mïnitö beyæ̈ ööña we we ööñömöni mïnitö wæætë edæ äwadämaï ïmïnitapa töö,’ ante owempodinque wëñæ̈näni pïinte tedewënänipa. Ayæ̈ wæætë, Waocä do wængä ate näni wæbaï, ante wëñæ̈näni näni owempote cæcabo ïñömö, ‘Mönitö Ca ca wæyömöni mïnitö wæætë edæ wædämaï ïmïni wæmönipa,’ ante pïïninque aa pedäni baï ñöwodäni ïñömö edæ adobaï pïinte tedewënäni ïnänipa.” ");
INSERT INTO aucNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Edæ ïïmaï impa. Wëñæ̈näni näni wædö baï Wäö æpæ̈në mönö në guidönongä ïñömö cænguï cæ̈nämaï yowepæ̈ biïnömæ̈ näni wædænque tï nämæ̈ bedämaï ponte quëwëñongante mïnitö guiquënë, Wënæ tönö Wäö quëwengampa, ante pïïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ayæ̈ wæætë botö Waobo ëñagaïmo inte tömää cænguï cænte yowepæ̈ biïnömæ̈ bete mïnitö weca ponte quëwëñömote mïnitö guiquënë, Cæ̈owæ̈obi inte cæ̈mipa. Beowæ̈obi inte bebipa, ante badete tomïnipa. Ayæ̈ godömenque, Odömäno awënë beyæ̈ në æ̈wënäni tönö wadäni në ëñënämaï cædäni ïñönänite bitö tömënäni æ̈migo ïmipæ̈æ̈, ante botö ïmote pïïninque mïnitö wëñæ̈näni näni pïinte aa pedö baï änewëmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Incæte, Në nö ëñënäni ïñömö nö cædänipa, ante adinque, Näwangä nö ëñënänipa, ante mönö ëñengæ̈impa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ayæ̈ ate adocanque Paditeocä incæ Itota ingante, Botö oncönë pö cæ̈e, angä Ao ante Paditeocä oncönë godinque pö guiite cæ̈ congantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tömënäni quëwëñömö onquiyængä në wënæ wënæ cæte quëwengä ïnongäimpa. Tömengä ïñömö, Paditeocä oncönë Itota cæ̈ncongampa, ante tededäni ëñëninque oguï wapæ̈ dica adabatodo waincadedë pe ñïñænte næ̈ænte pongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pö guiidinque tömengä Itota önöwaca ïnö pö næ̈ gongæ̈ninque Ca ca wæcantapa. Ca ca wæyongä Itota önöwaca ïnö ömæ̈ petæ̈ petæ̈ wææ̈ aa bee adinque onquiyængä wæætë tömengä ocaguincooca wadæ cæwacantapa. Ayæ̈ queë bewadinque oguï wapæ̈ gao cæwacantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mänömaï cæcä adinque, Pö cæ̈e, në äningä inte Paditeocä ïñömö nämäneque pönëninque, “Itota ïñömö Wængonguï beyæ̈ në apæ̈necä inte baï tömengä, Æcänö botö ïmote gampocää, ante ayæ̈, Quïëmë baï onquiyængä ingää, ante ëñencædongäimpa. Ïñæmpa në wënæ wënæ cædongä ingampa, ante do ëñencædongäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ante pönëñongä Itota wæætë, —Timönö, bitö ïmite adodeque apæ̈nebo ëñëe. Äñongante Paditeo wæætë, —Ao, në Odömömi ïmi, apæ̈nebi ëñëmoe. ");
INSERT INTO aucNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Angä ïninque Itota, —Onguïñængä adocanque në godöwengä inte quëwëñongante onguïñæ̈na mënaa ïnante godongä ate debe badapa. Adocanque ingante nanguï quïniento ëmö godongä ate nanguï debe bayongante wacä ingante wædænque tincoenta ëmö godongä ate wædænque debe bacampa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Në godöningä nänö änimpota ömæpoda inte tömëna, Ædö cæte wæætë adodö pönonguïmönaa, ante wæyönate në godöningä ïñömö edæ, Ömæpomïna inte mïnatö ædö cæte adodö pönömïna ænguïmoo, ante botö æ̈nämaï inte ñimpo cæcæboimpa, angampa. Ïninque Timönö bitö ïmite ämopa. Mënaa ïnate ñimpo cæte änämaï ingä adinque në godongä ingante æcänö godömenque nanguï waadete pönenguingää, ante pönëmii. ");
INSERT INTO aucNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Äñongante Timönö, —Wa. Godömenque nanguï ëmö debe ingä ïñömö tömengä wabänö godömenque waadete pönengä ïmaingampa, ämopa. Angä ëñëninque Itota, —Näwangä ante pönëmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Äninque Itota onquiyængä gämæ̈nö dadi ëmænte adinque Timönö ingante apæ̈nedinque, —Ïingä onquiyængä ingante edæ abi. Botö bitö oncönë pö guiiyömote bitö, Mëwaquïmæ̈, ante bitö dicæ pönömiyaa. Tömengä guiquënë ömæ̈ wææ̈monte aa bewadinque tömengä ocaguinca wadæ cæwacä ae. ");
INSERT INTO aucNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bitö guiquënë waadedämaï inte queë bemönämaï ïñömite tömengä ïñömö botö pö guiiyedë täno queë bewadinque cöwë queë bewacä ae. ");
INSERT INTO aucNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bitö guiquënë oguinguipæ̈ gao cæcadämaï ïñömite tömengä ïñömö oguï wapæ̈ gao cæwacä ae. ");
INSERT INTO aucNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ïninque botö, Tömengä mänömaï cæcampa, ante odömöninque bitö ïmite ämo ëñëe. Edæ tömengä nanguï wënæ wënæ cæcä ïñongante Wængonguï godö ñimpo cæcä ate tömengä wæætë nanguï waadete pönengampa. Bitö ïñömö edæ wædænque wënæ wënæ cæbi ïñömite Wængonguï pönö ñimpo cæcä ate bitö wæætë wædænque waadete pönëmi abopa. ");
INSERT INTO aucNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Äninque onquiyængä ingante apæ̈nedinque Itota, —Wënæ wënæ bitö cædïnö ante pönö ñimpo cæbo æ̈e. ");
INSERT INTO aucNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Angä ëñëninque wadäni godongämæ̈ cæ̈ cönäni guiquënë godö wæntæ wæntæ äninque, —Ïingä ïñömö edæ waocä wënæ wënæ nänö cædïnö ante, Pönö ñimpo cæbo æ̈e, ante në angä ïñömö edæ æcänö ingää. ");
INSERT INTO aucNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ante wædinque tedeyönäni Itota ïñömö onquiyængä ingante, —Bitö wede pönënö beyænque quëwencæbiimpa. Ñöwo edæ wædämaï inte goe, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ayæ̈ ate Itota nanguï ïnäni näni quëwëñömö wayömö wædænque ïnäni näni quëwëñömö wayömö wayömö godinque, Awënë Wængonguï Odeye nempo watapæ̈ quëwencæmïnimpa, ante waa apæ̈necä ëñengadänimpa. Ayæ̈ tömengä tönö dote ganca ïnäni mänimpodäni godongämæ̈ godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ayæ̈ onquiyæ̈näni adobaï Itota mïñæ̈ godänitapa. Tömënäni pancadäniya wënæidi në wïwa ëwocadäni tönö në quëwengaïnäni ïñönänite wadäni nantate wæwengaïnäni ïñönänite Itota cæcä ate tömänäni do waa badïnäni inte ñöwo tömengä mïñæ̈ tee empote godäni ïnönänimpa. Adocanque Mäadiya Mäagadadënä näni angaingä tömengä baonga wënæidi tiæte ganca ïnäni tao godäni ïninque tömengä önonganque badingä inte Itotaidi tönö godinque pönö cæcä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wacä onquiyængä Wäönä nänöogængä Tiota guiquënë Edode nänö ëadincoo në aacä ïñongante Wäönä ïñömö Totänä tönö ayæ̈ wadäni onquiyæ̈näni nanguï ïnäni tönö adobaï Itotaidi tönö godongämæ̈ godinque pönö cædönänimpa. Tömënäni näni ëadincoo incæ ænte pöninque Itotaidi beyæ̈ ante pönö cædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nanguï ïnäni wayömö näni quëwencabo wayömö näni quëwencabo bacoo ïnäni godongämæ̈ ponte a ongöñönänite Itota apæ̈necantapa. Wængonguï nänö apæ̈nedö ante waodäni æbänö ëñënänii, ante ëñencædänimpa, ante inguipoga quëwënäni näni cæïnö ante ïïmaïnö ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Waocä në quiyadongä ïñömö quiyacæ gocampa. Gote quiyayongä pancamonga taadö ïñömö wææ̈mompa. Taadö wæænte eyepodïmö öñöñonte pïnä gäwadäni ædö cæte pæquïï. Ayæ̈ ayamöidi pöninque dobæ ade cæ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pancamonga guiquënë dicamontaa ïñömö wææ̈ninque pæquïnämaï gä æidinque oguïmento guiwapa pæquïï. Guiwadämaï inte edæ guingo icadinque tömencaguï näñe wæncaguimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pancamonga guiquënë ömentacodë nänö eyepodïmö ïñömö pæquïnämaï tä bocate gä æiyonte ömentacoo adoyömö pö incootonque ganta cæca ate näñe wæmpa. Wampo incapa pæquïï. ");
INSERT INTO aucNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waëmonguipoga quiyadïmö guiquënë tä bocate waa pædinque tömëmö tiëë ganca mänimpomö nanguï pönï incapa. Quiyacä nänö quiyadö ante edæ botö mäninque ante apæ̈nebopa.” Mänömaïnö ante apæ̈nedinque Itota ogæ̈ tededinque, “Ëamonca ongonte edæ ëñëedäni,” angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tömengä mïñæ̈ në godäni ïñömö, Itota ëñëmi, änänitapa. Mänïnö ante apæ̈nedinque bitö æbänö ante odömoncæte ante apæ̈nebitawo. ");
INSERT INTO aucNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Äñönänite tömengä, “Wængonguï Awënë Odeye nempo æbänö quëwenguïï, ante mïni waocabo wëënëñedë mïni ëñënämaï ingaïnö ante botö ñöwo edonque pönö apæ̈nebo ate mïnitö adomïnique ëñëmïni ïmïnipa. Wæætë wadäni ïnänite edæ botö inguipoga quëwënäni näni cæïnonque ante odömöninque apæ̈nebopa. Edæ tömënäni, Awincaque adinque wïï ædæmö adäni inte önömoncaque ëñëninque ædæmö ëñënämaï incædänimpa, ante dodäni Wængonguï beyæ̈ ante näni yewæ̈mongaïnö baï ïinque bacæ̈impa, ante botö tömënäni ïnänite mänömaïnonque ante apæ̈nebopa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Itota ayæ̈ godömenque apæ̈necantapa. “Botö në quiyacä nänö cæïnö ante apæ̈nedinque ïïmaïnö ante odömoncæte ante apæ̈netabopa. Tömëmö quiyadïmö ïñömö Wængonguï nänö apæ̈nedö baï impa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Taadö wæænte öñömö botö änömö guiquënë në ëñënäni baï impa. Tömënäni Wængonguï nänö apæ̈nedö ante tæcæ ëñëñönänite wënæ awënë pöninque, Quëwënämaï incædänimpa, ante cædinque Wængonguï nänö angaïnö ante ö ængä ïninque tömënäni ömætawënäni inte ædö cæte pönente quëwenguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dicamontaa wæænte pædïmö baï ïnäni guiquënë Wængonguï nänö apæ̈nedö ante watapæ̈ ëñente todinque në Ao änäni ïnänipa. Tömënäni ïñömö oguïmento guiwadämaï baï ïnäni inte wantæ ïñö pönënäni ate tömënäni näni pönënö beyæ̈ ante wadäni pïinte cædäni ate tömënäni wæætë guïñente wædinque ëmö cæte godänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ömentacodë wæænte pædïmö baï ïnäni guiquënë tömënäni ëñëninque godömenque quëwëñönäni inguipoga quëwente quïëmë beyænque mönö wæpämo pö ate guïñente wædinque pædämaï ïnänipa. Mäincooque beyæ̈ ayæ̈ önonque towente näni wædö beyæ̈ tömënäni ömentacoo incootonque ñä caate baï cæ ïninque edæ wampo encadänipa pæquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Onguipoga wainguipoga quiyadïmö baï ïnäni guiquënë tömënäni nö pönente waa cæte quëwënäni ïnänipa. Tömënäni ïñömö edæ Wængonguï nänö apæ̈nedö ante ëñëninque do bæi ongonte wede pönënäni ïnänipa. Wæntæye ïnämaï ïnäni inte tömënäni ee cædinque tömëwæ̈ incate baï waa cædänipa. Botö mänömaïnö tömänö ante odömoncæte ante në quiyacä nänö cædö ante apæ̈netabopa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ayæ̈, “Gongapæncade tï wodönodinque waodäni dicæ owætadë boo cæcadäniyaa. Möïmoga æ̈nömengadæ̈ ïnö dicæ concæcadäniyaa. Wæætë, Mänïñömö në pö guiidäni acædänimpa, ante cædinque gongapæncade awæmpa æ̈mongapaa concædäni ñäö bæco adänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Quïëmë ante wë wodonte ï ïñömö mänïnö tömänö ante ïincayæ̈ ate edonque ate baï ëñengæ̈impa. Quïnö ñöwo bee ocate baï ï incæ mänïnö tömänö ïincayæ̈ ate wi æncate baï ïñonte edonque acæ̈impa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ayæ̈, “Në ëacä ingante godönäni ængä baï në ëñengä ingante godö apæ̈nebo ëñente entawëninque tömengä godömenque ëñente bacæcäimpa. Në ëadämaï ingä guiquënë tömengä, Ëabopa, ante pönëninque nänö wædænque pönï ëadincoo ïñonte ö æ̈näni wæcä baï në ëñënämaï ingä adobaï tömengä, Entawëmopa, ante pönengä ïninque wædænque pönï nänö entawënö ïñonte edæ ö ænte baï cæbo dæ ba ate wæcæcäimpa cæmïnii. Ëamonca ongonte ëñenguënë quëwëmïnii,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mänïñedë tömengä wäänä tönö tömengä biwïidi pöninque tömengä weca guiicæte ante cæyönäni wadäni goto ongönäni ate wædinque, Ædö cæte guiiquïï. ");
INSERT INTO aucNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ante wædäni adinque wacä, —Itota ëñëmi. Bitö badä tönö bitö biwïidi bitö ïmite ante oncodo ponte yabæque ongönänipa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ante apæ̈necä ëñëninque Itota, —Wængonguï nänö änö ëñëninque në ëñente cædäni ïñömö tömënäni botö badä baï botö tönïñadäni baï ïnänipa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mänïñedë tömengä mïñæ̈ në godäni ïnänite Itota, —Gäwapæ̈ æ̈mæ̈mäa taocæ̈impa. Angä ëñente cædinque tömengä tönö wipodë guiidinque tæcæ taocæ wogaa godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tao wogaa goyönäni Itota wipodë näñe ñongæ̈ninque edæ mö ñongantapa. Mänömaï mö ñöñongä goyönänite woboyæ̈ nanguï pönï pæ̈mæ̈ninque edæ æpæ̈ mængonta mængonta pöninque wipodë baguïmæ̈ guii adinque tömënäni, Æpæ̈ bete wænguï wæ, ante Yæ wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Itota weca gote, Ömæ̈moncæcäimpa, ante tao cædinque, —Awënë, möni Awënë, ëñenguënë quëwëe. Bete wæncæ cæmompa cæbii. Änäni ñäni ömæ̈monte ængæ̈ gantidinque, Woboyæ̈ æpæ̈ idæwaa mængonta cæbipa. Næ̈ gongæ̈mäwe, angä. Næ̈ gongæ̈ninque ñancæ ñancæ gongæ̈mæmpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ayæ̈ tömënäni ïnänite, —Mïni pönëegade incæ quïnante wïï pönëmïnii. Äñongante tömënäni ancai guïñëninque, Æbänö anguïmöö, ante nämäneque tedegadänimpa. —Ïingä ïñömö æcänö ïnongä inte mänömaï angä ëñëninque woboyæ̈ incæ æpæ̈ incæ næ̈ gongæmpa, ante wæmönipa, ante tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mänïï Gadideabæ ëmö cæte godinque Itotaidi æ̈mæ̈mäa wogaa tao godinque Guedatabæ pö ti wææ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wipodë manta wo cæyönäni Itota ti wæænte tæcæ ömaa goyongante onguïñængä wënæidi tönö në quëwengä ïñömö mämö bee tengantapa. Ïingä ïñömö tömënäni quëwëñömö në quëwengaingä inte ñöwo wantæpiyæ̈ oncönë quëwënämaï inte ömaacä quëwëninque waodänidoque cöwë quëwengä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Itota ingante adinque tömengä önöwa ïnö ædæ wææ̈ninque edæ Yæ angantapa. —Itota ëñëmi, bitö Æibæ Quëwengä Wængonguï Wëmi ïnömi incæ quïmæ̈ botö weca pöwëë. Botö ïmote edæ, Ämogate wæcæcäimpa, ante cædämaï ïmäwe, ante nanguï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Edæ tæcæ pöñongante tömengä wentamö nänö në ëwocadongä ingante Itota, Gobäwe, ante do angä ëñente wædingä inte ñöwo mänömaï angantapa. Mänïï wënæ ïñömö wantæ wantæ ïñonte onguïñængä ingante bæi ongonte baï cædongäimpa. Ïninque mäningä onguïñængä ingante waodäni daagömenca edæ ëno pönö goto wïmænte wææ̈ ëno pönö goto wïwadinque wææ wänönönänimpa. Incæte tömengä daagömë wangö ñæ̈ wangö ñæ̈ cædongäimpa. Ayæ̈ tömengä ingante wënæ wæætë wæætë da godongä önömæca wodii wïnonte quëwënongä inte adocä ñöwo Itota weca ponte angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Angä ëñëninque Itota wæætë, —Æmömidö ïmii. Äñongante, —Botö ëmöwo Deguiönö ëmömopa, angantapa. Edæ tontadoidi Deguiönö näni änoncabo bacoo ïnäni baï botö në ënempodäni adobaï wënæidi bacoo ïnänipa, ante adinque, Deguiönö ëmömopa, ante onguïñængä angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wënæidi guiquënë Itota ingante wæætë wæætë äninque, Mönitö ïmönite tadömengadænguipoga wido cædämaï ïmäwe, ancaa änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mänïñömö odæ̈ wængänäidi nanguï ïnäni änanquidi a cængönäni adinque, Ïñömö odæ̈ wængänä baönë ämi go guiite quëwenguïmöni, änäni ëñëninque Itota, Ao angä. ");
INSERT INTO aucNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ëñëninque waocä baönë quëwente tao godinque wënæidi odæ̈ wængänä baönë wæætë go guiidäni ate odæncato wæætë ontadäa wææ̈nömëmö ïñömö gäwapæ̈no pogodo wæi guiite becadote capo wængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Itota mänömaï cæcä ate wædinque odæ̈ wængänäidi në aadïnäni guiquënë pogodo wodii wïnonte tömënäni quëwëñömö mäo bee tente apæ̈nedinque idömæ mäo gode ä gode ä cæte, Itota mänömaï cæcä wæmönipa, ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ëñëninque wadäni wæætë, Æbänö cæcäï, ante acæte ante pönänitapa. Itota weca ponte ayönäni wënæidi tönö në quëwëningä incæ ñöwo önonganque bate weocoo ëñacä inte Itota önöwa gäänë ëñëë congä adinque guïñente wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wënæ tönö quëwëningä ingante Itota mänömaï cæcä ante në adïnäni ïñömö ñöwo pönäni ïnänite, Mänömaï cæcantapa, ante do apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ëñëninque Guedatabæ quëwënäni tömänäni ancai guïñente wædinque Itota ingante, Mönitö weca quëwënämaï ñöwo gobäwe, änäni ëñente wædinque tömengä wipodë ïmæ̈mäa poncæte ante guiicä. ");
INSERT INTO aucNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Adinque wënæidi tao godäni ate në önonganque bate quëwengä ïñömö Itota ingante, Bitö mïñæ̈ mäobi goboe, angä ëñëninque Itota wæætë, Bitö ee quëwëmi, äninque, ");
INSERT INTO aucNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Tömëmi oncönë adodö godinque, Wængonguï æbänö nanguï cæcä waa batawoo, ante mäo apæ̈nebi ëñencædänimpa. Angä ëñëninque oncönë godinque tömënäni näni quëwëñömö tömäo cægöninque tömengä, Itota mänömaï cæcä ate waa batabopa, ante mäo apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Itota ïmæ̈mäa ocæ̈ ëmænte pongä adinque, Æyedënö ponguingää, ante në wædïnäni inte tömänäni tömengä ingante waa ate togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mänïñedë wacä oodeoidi odömöincö awënë ïnongä inte tömengä ëmöwo Gaido ïñömö pö Itota önöwaca ïnö ædæ wææ̈ninque tömengä ingante, Botö oncönë quingæ̈ pöe, ante nanguï angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Edæ botö wëñængä onquiyængä adocanque ïnongä inte dote wadepo nänö ëñagaï ïñonte edæ wæncæ cæcampa cæbii, ante wæcantapa. Ïninque Itota tömengä mïñæ̈ gocantapa. Idömæ goyongante nanguï ïnäni goto goto pöninque wodo mö ñongæ̈näni wæcantapa. Wampo impa goquingää. ");
INSERT INTO aucNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mänïñedë wacä onquiyængä pongantapa. Tömengä ïñömö wantæpiyæ̈ dote wadepo ïñonte wepæ̈ wantæ bidämaï cöwë wææ̈ wædinque waa bawënencæte ante cædinque tömengä quincoo tömancoo eyepote pædæ godongä æ̈ninque dotodoidi æcämenque incæ onquiyængä beyæ̈ ædö cæte waa cæquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mänömaï quëwente wædongä inte tömengä ñöwo Itota önöñabæca ïnö pöninque tömengä weocoo yæwedecooque godö gampo cæyongä wepæ̈ ïñontobæ̈ edæ wantæ bitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Itota ïñömö edæ, —Æcänö botö ïmote pönö gampodaï. Äñongante tömänäni, Æcänö gampodatawogaa, ante adoyömö ante änäni ate wædinque Pegodoidi wæætë, —Awënë ëñëmi. Bitö weca tömänäni goto goto godäni apa ämii. ");
INSERT INTO aucNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Itota wæætë, —Ïñæmpa adocanque botö ïmote wede pönëninque gampocantapa. Tæ̈ï pïñænte botö entawënö incæ edæ wacä beyæ̈ cæquinque do gotimpa, ante wæwënente awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Äñongante onquiyængä ïñömö, Ædö cæte wë womonguïmoo, ante pönente wædinque do do wäate baï guïñëninque Itota weca ædæ wææncate tömänäni ayönänite apæ̈nedinque, Botö waa bawënencæte ante bitö ïmite pönö gampotabopa. Tæcæ pönö gampo cædinque waa babo ae. ");
INSERT INTO aucNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ante apæ̈necä ëñëninque Itota, —Onquiyæ̈mi ëñëmi. Bitö wede pönënö beyæ̈ edæ wantæ bawënëmipa. Ñöwo edæ nö bawënëmi inte wampo pönente waa goe, ante godö ædæmö apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ante tæcæ apæ̈neyongä oodeoidi odömöincö awënë Gaido oncönë quëwengä mänïñedë pöninque edæ Gaido ingante apæ̈necantapa. —Bitö wengä ïñömö ñöwo æ̈mæ̈wo wængampa cæbii. Në Odömongä ingante ñöwo bitö godömenque änämaï incæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ante ñöwo pöningä Gaido ingante angä ëñëninque Itota wæætë, —Gaido, guïñënämaï ïe. Bitö wede pönëmi adinque bitö wengä mïingä quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Äninque Itota godömenque godinque awënë oncönë pö guiicæ cædinque Pegodo ingante Tantiago tönö Wäö ïnate wëñængä wæmpo tönö wäänä ïnate mänimpodänique ïnänite ænte manguicä wäänë guiidänitapa. Wadäni ïnänite wæætë wææ cæcä guiidämaï ïnänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tömänäni Ca ca wædinque wëñængä wodi ingante ante pönente wæwënäni adinque Itota tömënäni ïnänite, —Ca ca wædämaï ïedäni. Ïñæmpa ïñömö wëñængä wodi edæ wïï æ̈mæ̈wo wængantapa. Mö edæ ñongampa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Angä ëñente wædinque tömënäni, Æ̈mæ̈wo wænte öñongampa, ante do adïnäni inte wæætë edæ, Antedö amïni, ante tömengä ingante badete todänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ïninque Itota wëñængä ingante pædæ wææmpo bæi ongonte töö æ̈mæ̈ninque ogæ̈ tededinque, —Wëñæ̈mi, ængæ̈ gantibi, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Äñongä tömengä do wæ̈ningä inte ñäni ömæ̈monte quëwëninque ængæ̈ ganticantapa. Itota wëñængä beyæ̈ cænguï angä godöna cængantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Adinque mæmpoda, Æbänö cæte mänömaï cæcää, ante guïñente wædatapa. Incæte Itota wæætë, Botö æbänö cæboo, ante mïnatö wadäni ïnänite apæ̈nedämaï incæmïnaimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tömengä mïñæ̈ në godäni, Dote ïnäni, näni änönäni ïnänite Itota angä pönäni ate, Botö në ämo inte botö tæ̈ï pïñæ̈nö ante ñöwo pönömo ænte entawëninque mïnitö tæ̈ï pïñæ̈ninque në ämïni bacæmïnimpa. Ïninque mïnitö ämïni ate wënæidi tömänäni do gocædänimpa. Adobaï ämïni ate wënæ wënæ inte wæwënäni waa bacædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mïnitö, Wængonguï Awënë Odeye inguipoga do pongäimpa, ante apæ̈nemïni ëñencædänimpa. Ayæ̈ wënæ wënæ ïnäni ïnänite godö cæmïni waa bacædänimpa, ante Itota mänimpodäni ïnänite da godongä gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ïïmaï angacäimpa. —Mïnitö ömæpomïni taadö goedäni. Ongonto incæ mäincoo da wenguincade incæ cænguï incæ godonte æ̈inta incæ tömancoo edæ æ̈nämaï inte ömæpomïni godinque edæ ëñacooque ëñate goedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ayæ̈, Godinque æcönënö täno go guiimïni owodinque mïnitö wayömö mïni go quëwenganca mänincönenque go guii go guii cædinque quëwëedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Æyömömë goyömïnite wadäni, Pöedäni, änämaï inte mïnitö apæ̈nedö ante wïï ëñënäni wædinque mïnitö wæætë tömënäni ïnänite ëmö cæte ïïmaïnö ante goedäni. Mïnitö ïñæmpa, Pöedäni, änämaï ïmïni adinque mönitö gomöni tamëñedäni, ante odömoncæte ante mïnitö önöwa wadæ wadæ cæwadinque wadæ goedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Angä godinque tömënäni quëwëñömö wayömö tömënäni quëwëñömö wayömö tömäo godinque Itota nänö da godönïnäni ïñömö mönö Awënë ingantedö ante mäo watapæ̈ apæ̈nedäni ëñënänitapa. Ayæ̈ wënæ wënæ ïnäni ïnänite godö cædäni ate waa bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tömänäni mänïñedë, Itotaidi æbänö cædänii, ante tedeyönänite pancabaa awënë odeye Edode incæ do ëñengantapa. Itota ïñömö æcänö ingää, ante wædinque pancadäniya, Wäö wodi do wænte ñäni ömæ̈möningä inte ïingä Itota ïmaingampa, ante tededäni ëñente wædinque awënë Edode guïñente wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wadäni guiquënë, Ediya wodi ponte a ongömaingampa, ante tedeyönäni wadäni guiquënë, Wængonguï beyæ̈ në apæ̈negaïnäni incæ adocanque docä incæ do ñäni ömæ̈möningä inte a ongömaingampa, ante tededäni. ");
INSERT INTO aucNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ëñente wædinque Edode wæætë, —Botö tömëmo ämo ëñëninque Wäö wodi ingante wido tamencadäni wængantapa. Ïninque mäningä Itota näni në tededongä guiquënë æcänö ingää. Ante wædinque Edode, Æbänö cæte Itota ingante aquïmoo, ante nanguï cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Itota nänö da godönïnäni ïñömö tömengä weca adodö pöninque, Mänömaï mänömaï cætamönipa, ante nanguï tededäni ëñengacäimpa. Ëñente ate tömengä tömënäni ïnänite nänënë Betaida eyequeï ænte mäocä. ");
INSERT INTO aucNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Goyönänite wadäni do ëñëninque tee empote pönäni adinque Itota, Waa pömïni abopa, ante waadete apæ̈nedinque, Mïnitö Wængonguï Awënë Odeye nempo watapæ̈ quëwencæmïnimpa, ante apæ̈necantapa. Ayæ̈, Pancadäniya waa baquënënäni ïnänipa, ante adinque tömengä godö cæcä ate waa badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ayæ̈ gäwadecæ̈ bayonte edæ, Dote, ante näni Itota mïñæ̈ gocabo ïñömö tömengä weca pöninque änänitapa. —Ïñömö önömæca impa cæbii. Bitö godongämæ̈ ongönäni ïnänite ämi idömæ owodäni weca godinque ayæ̈ nanguï ïnäni näni quëwëñömö godinque oncö eyepæ̈ ï ate cæ̈ninque moncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Äñönänite Itota, —Mïnitö wæætë godömïni cæncædänimpa. Äñongante, —Ïñæmpa päö önompo æ̈mæmpoque gæyæ mëa pönï mänimpoque næ̈æ̈mönipa töö. Ïninque bitö wæætë, Tömänäni beyæ̈ cænguï gote ænte pöedäni, ämitawoo. ");
INSERT INTO aucNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Onguïñæ̈nänique tinco mïido ganca ïnäni edæ mæ̈ ongönönänimpa. Incæte Itota tömengä mïñæ̈ në godäni ïnänite angantapa. —Mïnitö tömänäni ïnänite, Tincoenta ganca mïni cabo nänënë tincoenta ganca mïni cabo nänënë ämïni tæ̈ contacædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Angä ëñëninque änäni tæ̈ contadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Itota päö önompo æ̈mæmpoque æ̈ninque gæyæ mëa æ̈ninque öönædë æ̈mö adinque Wængonguï ingante, Bitö waa pönömi ænte cæ̈mönipa, ante apæ̈necantapa. Ayæ̈ päö tönö gæyæ pä æ̈ pä æ̈ cædinque tömengä mïñæ̈ në godäni ïnänite pædæ godongä æ̈ninque tömënäni tömänäni ïnänite di mæ̈ñæ̈ di mæ̈ñæ̈ cædäni ænte cængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tömänäni eyepæ̈ ænte tömo pönï cæ̈nänitapa. Ayæ̈ ao mæ̈ ao mæ̈ cæte ñönönäni ate Itota mïñæ̈ në godäni wæætë ao mæ̈ näni ñönönï ee öñoncoo pædæ wææmpo ö æ̈ninque önompo tipæmpoga go mentodëa cænguï eyede da wënäni contagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ayæ̈ ate Itota nänënë godinque Wængonguï ingante apæ̈neyongä tömengä mïñæ̈ në godäni tömengä tönö godongämæ̈ ongönönänimpa. Tömënäni ïnänite angantapa. —Wadäni botö ïmotedö ante apæ̈nedinque, Æbodö ïmoo, ante apæ̈nedäni ëñëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Äñongante tömënäni wæætë, —Bitö ïmitedö ante apæ̈nedinque pancadäniya, Wäö æpæ̈në në guidongaingä incæ Itota adocä ïmaingä ingampa, änänipa. Wadäni pancadäniya wæætë, Ediya wodi ingaingä incæ Itota adocä ïmaingä ingampa, änänipa. Pancadäniya wæætë, Wængonguï beyæ̈ në apæ̈negaingä adocanque do wængaingä inte ñäni ömæ̈monte quëwënongä incæ Itota adocä ïmaingä ingampa, ante tededänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Mïnitö guiquënë, Botö æbodö ïmoo, ante pönëmïnii. Äñongante Pegodo, —Wængonguï nänö në angaïmi ïnömi inte bitö ïñömö edæ në Coditobi ïnömi ïmipa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pegodo mänömaïnö ante apæ̈necä ëñëninque Itota wæætë angantapa. Mïnitö botö ïmotedö ante apæ̈nedinque, Codito ïnongä ingampa, ante gode änämaï ïedäni ämopa, ante nanguï äninque edæ wææ angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Äninque, —Botö Waobo ëñagaïmo inte nanguï caate wæquënëmo ïmopa. Në aadäni näni Picæncabo tönö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni tönö mänïnäni edæ botö ïmote Baa änäni wæquënëmo ïmopa. Ayæ̈ botö ïmote godömenque wæ̈nönäni wænguënëmo ïmopa. Incæte Wængonguï angä beyænque botö mëönaa go adoönæque ïñonte edæ ñäni ömæ̈monte quëwencæboimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ante apæ̈nedinque Itota tömänäni ïnänite godömenque apæ̈nedinque, —Æcänö botö mïñæ̈ pöïnëna ïna tömengä nämä beyænque ante pönënämaï inte ïïmö ïñö ïïmö ïñö botö mïñæ̈ tee empote poncæcäimpa. Nämä nänö wænguïwæ̈ næ̈ænte ponte baï cædinque tömengä, Botö wænguïmo incæ caate wæbo incæ Itota ingante cöwë tee empote gocæboimpa, äninque poncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Edæ æcänö, Nämä wææ gompodinque quëwencæboimpa, ante cædinque botö mïñæ̈ pönämaï ingä guiquënë tömengä ïñömö edæ quëwënämaï incæcäimpa. Wæætë edæ, Wæ̈nönäni wæ̈mo incæte botö Itota mïñæ̈ tee empote cöwë gocæboimpa, ante æcänö äna guiquënë tömengä wæætë quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Edæ waocä inguipoga ongoncoo tömancoo ö æncæte ante cædinque nämä önöwoca incæ pædæ godongä wë womonte ba ïninque edæ tömengä ïñæmpa quëwengampa diyæ̈ mäincoo ëaquingää. ");
INSERT INTO aucNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mïnitö pancamïniya botö beyæ̈ ante botö apæ̈nedö beyæ̈ ante guingo imonte wæmïnitawo. Ïñæmpa botö Mæmpo nänö ëmönö tönö anquedoidi tæiyæ̈ waëmö ïnäni näni ëmönö guïnæ̈ gongæ̈ñonte botö Waobo në ëñagäïmo inte edæ nämä ñäö apäite baï dibæ pöninque botö wæætë në guïñente wægaingä beyæ̈ ante näëmæ̈ guingo imonte edæ wæcæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Näwangä ämopa. Botö weca ongömïni pancamïniya ayæ̈ wæ̈nämaï edæ mïïmïni quëwëñömïni botö Wængonguï Awënë Odeyebo babo ate botö nempo guiicæmïnimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mänömaïnö ante apæ̈nedingä inte Itota adoque Wængonguï itædë go ate Wængonguï ingante apæ̈necæte ante æidinque Pegodo ingante Wäö tönö Tantiago ïnate mänimpodäni ïnänite änanquidi ænte mæ̈icä æidänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Æite go apæ̈neyongä tömengä awinca ïñömö edæ wïï cöwë nänö ëmönö baï waëmö pönï ñäö baï edæ ëmongä bamongä adänitapa. Ayæ̈ tömengä weocoo nänö ëñacoo ïñömö edæ näinte baï ëmoncoo badinque näämænta pönï ëñacantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ayæ̈ ayönäni edæ onguïñæ̈na mënaa edæ Möitee wodi tönö Ediya wodi incæ ïñontobæ̈ a ongöninque Itota tönö tededatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tömëna ïñömö ñäö apäite baï ëmöna inte Itota tönö godongämæ̈ apæ̈nedatapa. Godongämæ̈ apæ̈nedinque tömënäni, Itota æbänö ñöwo Eedotadëë godinque ïinque cædinque oo wænte wadæ gocæcäimpa, ante tededänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mänömaïnö ante tedeyönäni Pegodoidi guiquënë möïnente a ongöninque ædæmö ñäni ömæ̈monte æ̈mö ayönäni Itota ñäö apäite baï ëmongä adinque tömengä tönö onguïñæ̈na mënaa godongämæ̈ adiyæ̈ ongönäni adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Onguïñæ̈na ïñömö Itota ingante tæcæ ëmö cæte gocæ cæyöna Pegodo guiquënë, —Awënë ëñëmi. Ïñömö mönö waa pönï ongonte awædö. Bitö ämi ate mönitö oncontaicoo mentaiya go adotaique mæ̈nöninque bitö oncontai ante adotaique Möitee oncontai ante adotaique Ediya oncontai ante adotaique mæ̈nömaïmönipa. Mänömaïnö ante tededinque Pegodo, Æbänö ante tedequënëmo ïmoo, ante ëñënämaï inte önonque tedecantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mänömaï tedeyongä boguïmancoo obo wæænte wææ owoyö adämaï ïnäni inte, Boguïmancoo ganta cæ wæcæ wæ, ante Pegodoidi guïñente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ayæ̈ boguïmancodë önönepämoque apæ̈necantapa. “Ïingä botö Wengä botö në apænte ængaingä ingampa cæmïnii. Tömengä pönö apæ̈necä ate ëñëedäni.” ");
INSERT INTO aucNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ante apæ̈necä ëñente ayönäni Itota ñöwo adocanque a ongongä adänitapa. Ïninque tömengä mïñæ̈ në godäni në adïnänique inte pæ wëënedinque tömënäni näni adïnö ante mänïñedë wadäni ïnänite apæ̈nedämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mänïï änanquidi æi ïïmö ate wææ̈ pöñönäni Itota ingante bee tencæte ante nanguï ïnäni pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Godongämæ̈ ponte nanguï ïnäni ongöñönäni onguïñængä adocanque edæ ogæ̈ tededinque, —Në Odömömi ëñëmi. Botö wengä onguïñængä ingante pönö waa ae. Tömengä adocanque botö wengä ingampa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tömengä nänö në ëwocadongä inte wënæ incæ tömengä ingante edæ bæi ongongä ate tömengä ïñontobæ̈ Yæ yæ angampa. Ayæ̈ godö cæcä ate botö wengä edæ do do wäadinque önöne mäwanta tadecampa. Wënæ ïñömö wantæ ïñö tao godinque adodö pö guiite edæ cöwë quëwëninque botö wengä ingante edæ ëwencæ cæcampa cæbii. ");
INSERT INTO aucNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bitö mïñæ̈ në godäni ïnänite botö, Wënæ inte wido cæedäni, ancaa äñömo tömënäni në cæquënënäni incæ ædö cæte wido cæquïnänii, ante wæbopa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ante wæyongante Itota, —Ñöwomïni mïni ædæmö cædämaincabo mïni pönëegade impa. Mïnitö weca æpogadö quëwëmoï. Wapiticæ̈ cæyömïnite botö æpogadö piyæ̈në cæte wæwëmoï. Äninque mæmpocä ingante apæ̈nedinque, Bitö wengä ingante botö weca ænte pöe. ");
INSERT INTO aucNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Angä ëñente ænte mämongä pöñongante wënæ incæ yæipodë bæ tacä do do wäate wæwengantapa. Tömengä wentamö nänö në ëwocadongä ingante Itota ïñömö edæ, Ee ae, ante wææ angantapa. Ayæ̈ wëñængä ingante pönö cæcä ate tömengä wæætë önonganque bayongante mæmpocä ingante Itota pædæ godongä ængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mänömaï cæcä adinque, Wængonguï incæ tæ̈ï pïñæ̈nongä inte mänömaï cæcampa, ante pönëninque tömänäni ancai guïñente wægadänimpa. Mänömaï cæcä ate guïñente wæyönäni tömengä mïñæ̈ në godäni ïnänite Itota ïïmaï ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ñöwo ämo ëñenguënë quëwëmïnii. Adocanque, Waocä në ëñagaingä æyömönö ongongää, ante godö odömöninque botö ïmote waodäni nempo pædæ godönäni æncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Äninque tömengä nänö apæ̈nedö æbänö ï, ante wædänitapa. Wë womonte ï ïninque tömënäni ædö cæte ëñenguïnänii. Ayæ̈, Æbänö ante ämii, ante anguënënäni incæ edæ guïñënete wædinque pæ wëënegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tömengä mïñæ̈ näni në gocabo ïñömö, Möni cabo incæ æcänonque ñæ̈nængä pönï ïnongä inte në angä inguingää, ante wædinque nämä incæ wæætedö wæætë tedeyönänite ");
INSERT INTO aucNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Itota önöwënenque do ëñengantapa. Ëñëninque wëñængä adocanque ingante bæi ongöninque tömengä gäänë ïñömö gö cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tömënäni ïnänite apæ̈necantapa. —Waocä botö ëmöwo beyænque ïingä wëñængä ingante, Pöe, ante waa cæcä ïñömö tömengä botö ïmote adobaï edæ, Pöe, ante do waa cæcampa. Botö ïmote æcänö, Pöe, äninque waa cæda tömengä adobaï botö ïmote në da pönongä ingante Wængonguï ingante edæ adobaï, Pöe, ante do waa cæcampa. Edæ mïni waocabo wædämïni ïñömïnite waocä guiyangä pönï ïnongä nänö entawënö baï në entawengä ïñömö tömengä ñæ̈nængä pönï ïnongä ingampa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wäö ïñömö Itota ingante apæ̈nedinque, —Awënë ëñëmi. Wacä incæ mönö cabo ïnämaï ïnongä inte bitö ëmöwo apæ̈nedinque wënæidi ïnänite wido cæcä atamönipa. Ïninque mönitö wæætë edæ, Bitö mönitö tönö gobi ïmipa Itota ëmöwo apæ̈nequïmii, ante tömengä ingante edæ wææ antamönipa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ante apæ̈neyongante Itota, —Ïñæmpa mïnitö ïmïnite në pïinte cædämaï ingä ïñömö tömengä wæætë mïnitö tönö godongämæ̈ cæcä ingampa cæmïnii. Tömengä ingante wææ änämaï incæmïnimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Oo pönï nänö æiquïönæ bacæ cæyonte Itota, Eedotadëë ïñömö botö cöwë gocæboimpa, ante gocæ cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wadäni ïnänite tömengä, Poncæcäimpa, ante mïnitö täno beyænte goedäni, ante da godongä godänitapa. Godinque tömënäni ïñömö Tämadiabæ godinque tömengä beyæ̈ cæcæte ante Tämadiaidi näni quëwëñömö gocæ cæyönäni, ");
INSERT INTO aucNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tämadiaidi wæætë edæ, Eedotadëë gämæ̈nö Itota gocä awædö, ante adinque, Mönitö weca pönämaï incæcäimpa, ante wææ änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ïïmaï cædäni adinque Wäö tönö Tantiago tömengä nänö ëmïñæ̈na ïñömö, —Awënë ëñëmi. Baa änäni adinque öönædë gonga ämöna wææ̈ gonte wænguïnäni, ämi, änatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Äñönate Itota wæætë edæ dadi ëmæ̈monte wææ ante tömëna ïnate, “Ïñæmpa mïnatö ïmïnate æwocadö angä ëñente ämïnaa, ante mïnatö edæ ëñënämaï ïmïna awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ïñæmpa botö Waobo ëñagaïmo ïmo ïñömö edæ waodäni ïnänite ömæ̈e ëwencæte ante wïï pongaïmo ïmopa. Wæætë edæ, Botö æ̈mo beyænque quëwencædänimpa, ante pongaboimpa,” ante pïingacäimpa. Ayæ̈ wadäni näni quëwëñömö gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Taadonque goyönäni Itota ingante wacä angantapa. —Awënë, bitö ædömë goyömite botö bitö mïñæ̈ pö gocæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Angä ëñëninque Itota wæætë, —Babæ guintaidi ïñömö ontatodë monguï ëadäni ïnänipa. Ayamöidi ongonta ëadäni ïnänipa. Botö Waobo ëñagaïmo wæætë edæ monguï ömaabo ïmopa poncæ ämii, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ayæ̈ wacä ingante Itota, —Botö mïñæ̈ pöe. Angä ëñente wædinque tömengä, —Awënë ëñëmi. Botö täno gote botö wæmpo wængä ate daga wente ate pömoe. ");
INSERT INTO aucNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Äñongante Itota wæætë, —Ïñæmpa në wæ̈wocadäni incæ tömënäni guiidënäni wæ̈näni ate ee abi daga wencædänimpa. Bitö wæætë, Wængonguï Awënë Odeye do pongäimpa, ante gote apæ̈nebi ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ayæ̈ wacä adobaï, —Awënë bitö ïmite tee empote goïnëmo incæ ee ongöñömi täno gote botö guiidënäni ïnänite, Gobopa, ante apæ̈nete pömoe. ");
INSERT INTO aucNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Äñongante Itota wæætë, —Ömæ në mangæ̈ mangæ̈ cædongä ïñömö töö pönï minte pæquimpa, ante cæquënengä ingampa. Tömengä dadi ëmænte adinque töö pönï cæcampa diyæ̈ töö minte pæquïï. Ayæ̈ adobaï Wængonguï Awënë Odeye nempo quëwëninque në cæquënengä ïñömö tömengä dadi ëmænte inguipogaque ante acä ïninque Awënë beyæ̈ ante ædö cæte cæquingää. ");
INSERT INTO aucNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ayæ̈ ate mönö Awënë godömenque tetenta i doo ganca ïnäni mänimpodäni ïnänite ïïmaï angantapa. Mïnitö æ̈mæ̈nö mëmïnaa æ̈mæ̈nö mëmïnaa godinque botö në goquïñömö ante wayömö näni quëwëñömö mäo wayömö näni quëwëñömö mäo täno beyænte gomïni ate botö ayæ̈ poncæboimpa, äninque da godongä gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ïïmaï ante da godongä godänitapa. “Näwangä ämopa. Waocä tömencacodë do pequinca nanguï inca baï Awënë nempo në quëwenguënënäni adobaï nanguï ïnäni ïnänipa. Incæte në tä pedäni wædænque ïnäni baï në gode änäni ïñömö adobaï mënäniya pönï ïnänipa cæmïnii. Mïnitö Wængonguï ingante apæ̈nedinque, Awënë, bitö tömencacodë në ëabi inte ämi ëñëninque gote apæ̈necædänimpa, ante äedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ñöwo mïnitö ïñömö goedäni, ämopa. Mëñeidi weca ongöninque codotedoidi ïñömö tæ̈ëmö ïnänipa diyæ̈ nämä wææ aaquïnänii. Mïnitö ïñömö codotedoidi aquïïnäni baï adobaï aquïïmïni ïñömïnite botö ämo mëñe baï ïnäni weca edæ gomïni ataqueedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Godonte mïni ænguinta wente æ̈ï æ̈nämaï inte mäincoo mongænte godämaï ïedäni. Awæncata næ̈ænte godämaï ïedäni. Taadö godinque wacä ingante bee tëninque apæ̈nedämaï inte goedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Æcönëmenque go guiite, Mïni quëwencabo gänë pönente waa quëwëedäni, ämïni ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mänincönë quëwengä Ao angä ïninque tömengä gänë pönente waa quëwëmaingampa. Wæætë Baa angä ïninque mïnitö adomïnique gänë pönente waa quëwëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mänincönë mïni go guiidincönë quëwëñömïnite mänincönë quëwënäni pædæ pönönäni ænte cænte bete quëwëedäni. Edæ në cæcä ïñömö tömengä nänö cædï beyæ̈ eyepæ̈ ænguënengä ingampa. Mïnitö adocönenque quëwëninque wacönë wacönë godämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Æyömömë goyömïni mänïñömö quëwënäni, Pöedäni, änäni ëñente wædinque mïnitö tömënäni cænguï pönönäni æ̈ninque cæ̈edäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wënæ wënæ wæwënäni ïnänite godö cæmïni waa bacædänimpa. Ayæ̈ tömënäni ïnänite, ‘Wængonguï Awënë Odeye mïnitö weca oo pongä acæmïnimpa,’ ante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ayæ̈ tömënäni quëwëñömö go guiiyömïnite Baa änäni ïninque mïnitö wæætë tömënäni taadonque tao godinque tömënäni ïnänite, ");
INSERT INTO aucNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mïnitö quëwëñömö onguipoi wadæ cæwate gomöna tamëñedäni. Incæte Wængonguï Awënë Odeye mïnitö weca oo pongä acæmïnimpa,’ ante äedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Edæ mïnitö ïmïnite ämopa. Wængonguï nänö apænte anguïönæ ïinque bayonte Todömä ïñömö quëwengaïnäni guiquënë nanguï pante wæwëñönäni mïnitö ïmïnite në Baa änäni guiquënë godömenque nanguï pante wæwenguïnäni ïnänipa,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Äninque Itota në ëñënämaï quëwënäni ïnänite pïïninque ïïmaï angantapa. “Codatïï ïñömö quëwëmïni ëñëedäni. Betaida ïñömö quëwëmïni ëñëedäni. Mïnitö mïni wæwenguinque ëñënämaï cæte quëwëmïnidö anguënë. Edæ botö mïnitö weca tæ̈ï pïñænte botö cædï baï Tido näni quëwengaïñömö Tidöö näni quëwengaïñömö adobaï cæbo baï mänïñömö quëwengaïnäni ïñömö wënæ wënæ näni cægaïnö ante dobæ ñimpo cædinque gömæ ëmoncoo da wëñadinque gönaiboga tæ̈ contadinque Ca ca wæcægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ïninque Wængonguï nänö apænte anguïönæ ïinque bayonte Tido ïñömö tönö Tidöö ïñömö quëwengaïnäni ïnänite nanguï pangä wæwënäni incæte tömengä mïnitö ïmïnite godömenque pangä wæwencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ayæ̈ Capënaömö ïñömö quëwëmïni ëñëedäni. Wængonguï mïnitö ïmïnite dicæ öönædë wo æ̈æntodongä æi gote toquïmïniyaa. Ïñæmpa tadömengadænguipo wææntodongä guii wæcæmïnimpa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Äninque Itota wæætë tetenta i doo ïnäni ïnänite apæ̈nedinque, “Mïnitö apæ̈neyömïni æcänö ëñengä tömengä ïñömö edæ botö ïmote do ëñengä ingampa. Wæætë mïnitö ïmïnite në Baa angä ïñömö tömengä edæ botö ïmote do Baa angä ingampa. Ayæ̈ botö ïmote në Baa äningä inte tömengä botö ïmote në da pönöningä ingante do Baa angampa,” ante apæ̈nedinque tömënäni ïnänite Itota angä godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Angä godïnäni inte tetenta i doo ganca ïnäni adodö ocæ̈ ëmænte pöninque watapæ̈ todinque Itota ingante apæ̈nedinque, —Awënë, bitö ëmöwo apæ̈nedinque mönitö wënæidi ïnänite ämöni ëñëninque bitö ëmöwo beyænque godänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ante todäni ëñëninque Itota wæætë, —Näinte quingæ̈ cæ baï Tatäna ïñömö wënæ awënë incæ öönædë ïnö wæængä në agaïmo inte botö adobo ämopa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Botö pönö ämo ate mïnitö ïñömö në ämïni badinque edæ tæntæ tönö emëñe ingante pïnä gäwadäni baï adobaï tæ̈ï ëmömïni inte tæntæ baï në cædäni ïnänite wido cæcæmïnimpa. Ayæ̈ mönö ïmonte në pïinte cædongä incæ tæ̈ï pïñænte cæcä incæte mïnitö ïñömö godömenque tæ̈ï ëmömïni inte mäningä nänö tæ̈ï pïñænte cæpämo ante tömämämo ante edæ wido cæcæmïnimpa. Edæ æcämenque incæ mïnitö ïmïnite æ̈mæ̈wo wido cædämaï incæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Incæte mïnitö ämïni ëñëninque wënæidi do ëñente cædäni beyænque todämaï ïedäni. Wæætë, Mönitö ëmöwo öönædë dobæ yewæ̈monte ongompa, ante adinque mïnitö mänömaï beyænque watapæ̈ toedäni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Äninque Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante ëwocadongä inte Itota mänïñedë edæ watapæ̈ todinque Wængonguï ingante ïïmaï ante apæ̈necantapa. “Mæmpo ëñëmi. Bitö, Wadäni nämä ocai encadäni tönö nanguï adinque në ëñënäni tönö mänïnö bitö cægaïnö ante ëñënämaï incædänimpa, ante cædinque bitö cægaïnö ante wë wodongabiimpa. Wæætë wëñæ̈näni tæcæ ëñadäni baï ïnäni ïnänite bitö edonque odömömi adinque do ëñënänipa. Bitö öönædë Awënë ingaïmi inte inguipoga Awënë adobi ïnömi inte edæ mänömaï cæbipa, ante adinque botö bitö ïmite waa ate pönëninque apæ̈nebopa. Mæmpo, bitö tömëmi änö baï cædinque waa cæbi adinque botö Ao ämopa, ante apæ̈nebopa,” ante Wængonguï ingante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ayæ̈, “Botö Mæmpo incæ, Bitö Awënë ïnömi inte aacæbiimpa, ante tömäo ïñömö ongoncoo botö nempo pædæ pönöninque tömäo ïñömö quëwënäni tömänäni ïnänite adobaï botö nempo pædæ pönongä æ̈ninque botö ïñömö edæ tömancoo ënempodinque tömäo ïñömö quëwënäni ïnänite në ënempobo ïmopa. Wængonguï Wëmo ïñömote, Æbodö ïmoo, ante Mæmpoque ëñengä ingampa. Botö wæætë tömengä Wëmo ïnömo inte, Wængonguï æcänö ingää, ante adoboque në ëñëmo ïmopa. Ayæ̈, Ïïnänique në ëñënäni incædänimpa, ante botö në angaïnäni ïnänite odömonte botö apæ̈nebo ëñëninque tömënäni wæætë, Wængonguï æcänö ingää, ante në ëñënäni badäni ate mönitö adomönique äanque baï në ëñëmöni ïmönipa.” ");
INSERT INTO aucNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ante apæ̈nedinque Itota dadi ëmæ̈ninque tömengä mïñæ̈ në godänique ïnänite apæ̈nedinque, “Ñöwo mïni adïnö adinque në ëmömïni inte mïnitö mïni watapæ̈ quëwenguinque impa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ïïmaï impa, ante apæ̈nebo ëñëedäni. Wængonguï beyæ̈ në apæ̈negaïnäni nanguï ïnäni tönö ïmæca awënëidi nanguï ïnäni incæ mïni adïnö baï ante aïnente wægaïnäni incæte edæ adämaï ingadänimpa. Mïni ëñënïnö ante adobaï ëñëïnente wægaïnäni incæte tömënäni ëñënämaï ingadänimpa,” ante mäninganca Itota apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ayæ̈ ate adocanque idægoidi näni wææ angaïnö ante në ate ëñengä ïñömö, Itota æbänö wapiticæ̈ apæ̈nebaingää, ante cædinque ængæ̈ gantidinque tömengä ingante ïïmaï angantapa. —Awënë në Odömömi ëñëmi. Botö æbänö cæte cöwë wæ̈nämaï wantæpiyæ̈ quëwenguïmoo, ante wæbopa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Äñongante Itota, —Möitee wodi, Ïïmaï cæedäni, ante wææ yewæ̈möninque æbänö ante yewæ̈mongä ongö abii. ");
INSERT INTO aucNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Äñongante në odömongä wæætë, —Ïïmaï ante yewæ̈mongacäimpa. Bitö mïmö entawëmi inte Wængonguï mönö Awënë ingante waadedinque bitö önöwoca ëwocadinque ædæmö waadete pönencæbiimpa. Bitö baö tæ̈ï pïñænte ëñabi inte godö waadete cædinque bitö ocai encabi inte nö pönëninque waa waadete pönëe. Ayæ̈ adobaï bitö nämä bitö waadete waa cædö baï adobaï pönëninque godongämæ̈ quëwënäni ïnänite adobaï waa waadete cæe. ");
INSERT INTO aucNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ante apæ̈necä ëñëninque Itota tömengä ingante wæætë, —Bitö nö ëñëmi inte nöingä apæ̈nebitapa. Mänïnö bitö änïnö baï cæbi ïninque bitö wæ̈nämaï quëwëmaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Angä ëñëninque guïñente wædinque në odömongä ïñömö, Botö cæquënënö ante wïï cæbopa, ante Itota ëñënämaï incæcäimpa, ante nämanque ante wææ äninque, —Ïñæmpa wa. Godongämæ̈ quëwënäni, ante bitö änïnäni ïñömö ædänidö ïnänii. ");
INSERT INTO aucNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Äñongante Itota wæætë, Mönö guiidengä æcänö ingää, ante odömoncæte ante ïïmaï apæ̈negacäimpa. —Onguïñængä adocanque Eedotadëë quëwente Eedicoo wæidö cægöñongante në ö æ̈näni tömengä ingante ïñontobæ̈ bæi ongonte weocoo gäni tadongadinque tæi tæi pänäni nangæ̈ bacä ïninque wadæ godäni. ");
INSERT INTO aucNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ate, Wængonguï quï, ante në godongä adocanque adodö wæidö godö godinque në nangæ̈ bate öñongä ingante gomö adinque ee wodo pænta æ̈mæ̈ wedeca gocampa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ayæ̈ ate Debii wodi pæ̈ïnäni näni Wængonguï oncönë cæcabo incæ adocanque adobaï adoyömö wææ̈ pöninque në nangæ̈ bate öñongä ingante gomö adinque ee wodo pænta gocampa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ayæ̈ ate wacä Tämadiabæ në quëwënongä incæ ado wæidö godinque në nangæ̈ öñongä weca adoyömö ponte gomö adinque, Tömengä ædö cæte quëwenguingää, ante tömengä wædö ante baï nanguï pönente cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ïingä ïñömö në nangæ̈ bate öñongä weca pöninque tæi tæi pänäni nänö æbäadïñömö oguinguipæ̈ tönö yowepæ̈ tï nämæ̈ biïnömæ̈ näni ämæ̈ gao caadinque weocooca wïni caacampa. Ayæ̈, Tæ̈ contate gocæcäimpa, ante adocä Tämadiabæ quëwengä ïñömö nämä nänö në mongænte goquënengä bodo önöñabæ në nangæ̈ badingä ingante ængö cæcä tæ̈ contayongante bodo ingante töö töö ænte gocampa. Ayæ̈ taadö pönäni näni cænte guiite möincö ganca ænte mäo guiidinque në nangæ̈ badingä ingante waa cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ïïmö ate padata näni godonte æ̈inta mentaa tadöninque mänincönë në aacä ingante pædæ godöninque, Bitö në nangæ̈ badingä ingante waa cæe. Quïëmë æ̈ïnengä adinque bitö godömi ængä ate botö bitö weca adodö pöninque bitö godönimpo adopo wæætë pædæ pönömo æncæbiimpa, ante gocampa. Mänömaï cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Äninque Itota tömengä ingante në äningä ingante godömenque angantapa. Bitö ïmite ñöwo ämo ëñëninque bitö wæætë apæ̈nebi ëñëmoe. Në nangæ̈ bate öñongä weca pönäni mengäa go adocanque ïnäni incæte æcänö tömengä tönö godongämæ̈ quëwënäni baï inte waa cæcantawoo, ante pönëmii. ");
INSERT INTO aucNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Äñongante në odömongä wæætë, —Tömengä ingante në waadete godö waa cædongä incæ tömengä guiidengä baï cæcampa. Ante apæ̈necä ëñëninque Itota wæætë, —Tömengä nänö cædö baï bitö adobaï godinque cæbäwe, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ayæ̈ taadö goyönäni tömënäni quëwëñömö pongä adinque onquiyængä tömengä ëmöwo Mäadota ïñömö Itota ingante angä tömengä oncönë pö guiite ëñacantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mäadota tönïñacä Mäadiya ïñömö Itota önöwaca ïnö tæ̈ contadinque tömengä apæ̈necä ëñëë congantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mäadota guiquënë në ëñadäni beyæ̈ ante nanguï cæte wædinque Itota weca pöninque, —Awënë, botö tönïñacä ëmö cæte gocä ate botö adoboque nanguï cæbo ate wædämaï ïmitawo. Edæ ämi pö cæcäe. ");
INSERT INTO aucNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Äñongante Itota, —Mäadota, Mäadota, bitö wa wa wa cæcæte ante wæwëmi awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wæætë adoque pönï cædinque edæ eyepæ̈ impa. Mäadiya do, Quïnö waa cæquïmoo, ante apænte pönëningä inte botö önöwaca ïnö pö tæ̈ contate ëñëë congä adinque botö wæætë tömengä ingante, Goe, änämaï incæboimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Itota ayæ̈ ate wayömö gote Wængonguï ingante apæ̈necantapa. Ïinque apæ̈necä adinque tömengä nänö në ëmïñængä adocanque tömengä ingante apæ̈nedinque, —Awënë ëñëmi, Wäö tömengä nänö ëmïñæ̈näni ïnänite odömonte, Wængonguï ingante æbänö ante apæ̈nequïï, ante nänö apæ̈nedö baï bitö mönitö ïmönite adobaï ante odömonte apæ̈nebi ëñenguïmönii. ");
INSERT INTO aucNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ante wæyönäni Itota, —Wængonguï ingante apæ̈necæte ante ïïmaï ante apæ̈needäni, “Mönitö Mæmpo në öönædë quëwënömi inte ëñëmi. Mönitö bitö ëmöwo tæiyæ̈ waëmö ëmömi adinque bitö ëmöwo ante waa adinque apæ̈nemönipa. Bitö öönædë Awënë në ingaïmi inte inguipoga Awënë Odeyebi bitö baquinque edæ quingæ̈ pöe. Öönædë owodäni ëñente cædäni baï inguipoga adobaï bitö änö baï ëñente cæcæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mönitö ïmönite bitö, Cænguï, ante ïïmö ïñö ïïmö ïñö eyepæ̈ pönömi ænte cæ̈mönie. ");
INSERT INTO aucNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mönitö wënæ wënæ cæmöni incæte bitö në panguënëmi incæ pönö ñimpo cæbi quëwëmönie. Mönitö adobaï edæ wadäni mönitö ïmönite wënæ wënæ cædäni adinque ñimpo cæmöni quëwënäni ae. Mönitö wënæ wënæ möni cæïnënö godö gocæte ante cæmöni adinque bitö wææ cæbi ate mänïnö godö godämaï inte mönitö wæætë wënæ wënæ cædämaï incæmönimpa, Wæætë edæ në wïwa ëwocadongä nempo ongöñömönite bitö gä pe æmpobi quëwëmönie.” Mänömaïnö ante apæ̈nete Wængonguï ingante apæ̈needäni, Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Äninque tömënäni ïnänite godömenque apæ̈nedinque Itota, —Bitö ïïmaï cæbi ïninque bitö æ̈migo æbänö cæbaingää, ante pönëedäni. Ayaönæ̈nëña incæ bitö æ̈migo weca godinque bitö, “Botö æ̈migo ëñëmi. Päömo bodogaa tänoque pönömi æ̈nïmo inte ayæ̈ ate botö adopo pönömo æncæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Edæ wacä botö æ̈migo incæ wayömö gocæte ante botö weca pongampa cæbii. Botö, Quïnö impa diyæ̈ godömo cænguingää, ante wædïmo inte bitö ïmite ämopa.” ");
INSERT INTO aucNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Äñömi tömengä guiicönë öñöninque, “Botö odemö ædæmö tee mönedinque botö wëñæ̈näni tönö möïmoga öñömo inte diyæ̈ ædö cæte ængæ̈ gantite godömo ænguïmii. Ee ae.” ");
INSERT INTO aucNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Äninque bitö æ̈migo incæ bitö ämi beyænque ængæ̈ gantite pönönämaï ingampa. Incæte wæætë wæætë äñömi tömengä, Ancaa ëñente awædö, äninque ængæ̈ gantidinque bitö ïmite do pönongä æ̈maïmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ante apæ̈nedinque botö ïñömö mïnitö ïmïnite ïïmaï ämopa. Pönömi æ̈moe, ante në angä baï cædinque mïnitö mïni ænguïnö ante Wængonguï ingante apæ̈needäni. Æyömönö ïï, ante në diqui diqui mingä baï cædinque mïnitö, Æbänö ïï, ante ædæmö ëñencæte ante Wængonguï ingante wede pönente apæ̈needäni. Odemö mönitö beyæ̈ wi æ̈necæ̈impa, ante aa pecä baï cædinque mïnitö, Æbänö cæquïmoo, ante ëñencæte ante Wængonguï ingante nanguï apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Edæ, Pönömi æ̈moe, ante në änäni ïñömö edæ do æ̈nänipa. Në diqui diqui mïnäni ïñömö do adänipa. Ayæ̈ odemö ponte në aa pedäni tömënäni näni guiiquinque edæ do wi æ̈nete baï bacæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ante apæ̈nedinque Itota godömenque apæ̈necantapa. —Wëñæ̈ mæmpobi ïmi, ëñëmi. Bitö wëñængä päö ante angä ëñëninque bitö dicæ dicamö incæ godömi ængäa. Gæyæ ante angä ëñëninque bitö tæntæbo incæ dicæ godömi ængäa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Enquëmo angä ëñëninque bitö emëñe incæ dicæ godömi ængäa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ïninque mïnitö në wïwa cædömïni incæ, Wëñængä beyæ̈ quïnö waa ï, ante ëñëmïni inte do godömïni ængampa. Mönö Mæmpo ïñömö waa pönï cædongä ïñongante änäni ëñëninque tömengä në änäni ïnänite tömengä Tæiyæ̈ Waëmö Önöwoca ingante da pönongä æncædänimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ayæ̈ wënæ në babetadecä ïñömö waocä baö do guiite ongöñongante Itota tæcæ wido cæcantapa. Wënæ tao gocä ate onguïñængä tededämaï ïningä incæ do tedecä ate wædinque godongämæ̈ ongönäni wæætë guïñente wædinque waa agadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pancadäniya guiquënë, “Ïñæmpa wënæ awënë Beedeboo tönö godongämæ̈ cædinque Itota wënæidi ïnänite wido cæcä ïmaingampa töö,” ante tedewënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wadäni guiquënë, Æbänö cæmö ate Itota oda cæquingää, ante cædinque tömengä ingante, Bitö öönædë näni cæï baï mä odömömi ate pönëmaïmönipa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mänömaï babæ cæcæte ante änewënänipa, ante Itota do ëñëningä inte ïïmaï angantapa. “Awënë odeye nempo quëwënäni näëmæ̈ wæætedö wæætë cædäni ïninque awënë nänö ömædempote wæquinque tömënäni nämä ëwente cædänipa. Ayæ̈ adocönë owocabo incæ adoyömö godongämæ̈ quëwënïnäni incæ näëmæ̈ wæætedö wæætë cædäni ïninque tömënäni oncö woquinque näwæ̈ gobaïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mïnitö, Wënæ awënë Beedeboo tönö cædinque Itota wënæidi ïnänite wido cæbaingampa, ante änewëmïnipa töö. Ïñæmpa awënë Tatäna nempo quëwënäni ïñömö näëmæ̈ wæætedö wæætë pïïnäni ïninque adocabodäni ïnämaï ïñönänite tömengä dicæ tömënäni ïnänite ënempobaingäa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mïnitö, Beedeboo tönö cædinque Itota wënæidi ïnänite wido cæcampa, ante tedewëmïnipa. Mänïnö mïni änewënö näwangä ï baï mïnitö mïñæ̈ në godäni guiquënë æcänö tönö cæte wido cædänii. Ïninque mïnitö mïñæ̈ në godäni incæ mïni änewënö beyænque ante näëmæ̈ pïïninque mïnitö ïmïnite wæætë apænte äninque pïincædänimpa anguënë. ");
INSERT INTO aucNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Botö ïñömö Wængonguï tönö godongämæ̈ cædinque wënæidi ïnänite wido cæbo apa änewëmïni. Mänömaï ï ïninque botö Wængonguï Awënë Odeye ïnömo inte mïnitö weca do pömo aedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ayæ̈, “Ïïmaï impa. Në tæ̈ï pïñængä ïñömö tæ̈ëmoncoo wëñate mongæ̈ninque, Wææ godö cæinca, ante tæ̈ëmonca næ̈ænte tömengä oncö boyæ̈ wææ godö wææ godö cæyongä tömengä ëadincoo ïñömö edæ ee ongompa. Tatäna ïñömö mänömaï ingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Incæte wacä godömenque tæ̈ï ëmongä inte pöninque mäningä ingante edæ bæ tacampa. Ayæ̈ tæ̈ëmonca, Wææ godö botö cæinca, ante mäningä nänö äninca ñöwo pöningä ïñömö gä pe æmpote ö æ̈ninque tömengä nänö ëadincoo adobaï gä pe æmpote ö ænte mäo nënempocampa. Botö ïñömö në tæ̈ï ëmömo pönï ïnömo inte edæ godömenque tæ̈ï ëmongä nänö gänä cæbaï cæbopa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ayæ̈, “Botö tönö æcänö wïï godongämæ̈ cæcä ïñömö tömengä ïñömö edæ botö ïmote Baa ante pïinte cæcä ingampa. Ayæ̈ botö, Waodäni botö mïñæ̈ poncædänimpa, ante cæyömo waocä botö tönö wïï cæcä ïñömö tömengä wæætë botö mïñæ̈ poncæ cæyönänite tatodongä wadæ godänipa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ayæ̈ apæ̈nedinque Itota ïïmaï ante apæ̈necantapa. “Waocä baönë owote ate tao godinque wënæ wentamö nänö ëwocadingä ïñömö edæ, Quingänö baönë go guiidinque edæ guëmante quëwenguïmoo, ante diqui diqui minte ayongä önömæca to aminte ï ate wædinque edæ, ‘Botö tao godincönë adodö go guiite quëwencæboimpa,’ ante pönëninque adodö pongampa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ponte ayongä waocä önonganque bayongante wacä önöwoca tömengäa owodämaï ingä adinque wënæ wæætë, Æ waocä botö owodincö baï ïnongä inte ñöwo wadæ ñëmænte mäincoo cabo të gæte baï ömæwocacä ingä abopa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ate adinque tömengä wæætë godinque wënæidi godömenque wentamö ëwocadäni tiæte ganca mänimpodäni ïnänite ænte pongampa. Tömënäni tömänäni waocä baönë godongämæ̈ pö guiite owodäni ate waocä ïñömö wënæ yewæ̈ninque godömenque wæwengampa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Itota tæcæ apæ̈neyongante onquiyængä ïñömö godongämæ̈ ongönäni tönö ongöninque ogæ̈ tededinque, —Bitö ïmite në mangaïnä inte edæ tömënä nänä toquinque impa. Bitö ïmi goömæ̈ gänongaïnä inte edæ tömënä watapæ̈ nänä quëwenguinque impa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ante ogæ̈ tedecä ëñëninque Itota wæætë, —Ïñæmpa Wængonguï nänö änö ëñëninque në cædäni guiquënë tömënäni wæætë näni watapæ̈ quëwenguinque ëñente cædänipa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mänïñedë godömenque nanguï ïnäni pönäni adinque Itota, ïïmaï ante apæ̈necantapa. “Mïnitö wïwa mïni cæcabo ïmïnipa. Mïnitö edæ, Mä cæte odömömi adinque pönëmaïmönipa, ante ancaa ämïni awædö. Näwangä ämo ëñëedäni. Cönäö wodi beyæ̈ cædinque Wængonguï bamönengæ̈ nänö cægaïnö ante mïnitö pönënämaï ïñömïnite edæ mäninque mïni aquinque cæcæ̈impa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nïnebaidi pönencædänimpa, ante Cönäö wodi ingante Wængonguï angä quëwengacäimpa. Ñöwomïni pönencæmïnimpa, ante adobaï cædinque Wængonguï botö Waobo ëñagaïmo ïñömote adobaï angä quëwëmo acæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Doyedë ïñömö betamonca gämæ̈nö ömæ awënë ïnongä inte onquiyængä incæ awënë Tadömöö wodi nanguï ëñente nänö apæ̈nedö ante ëñencæte ante doönæ quëwëninque pongacäimpa. Tadömöö wædænque ëñengä ïñongante botö godömenque nanguï ëñëmo inte mïnitö weca ongöñömote mïnitö ïñæmpa wïï ëñëmïnipa töö. Ïninque mäningä onquiyængä incæ Wængonguï në apænte angä weca pöninque mïni ñöwo quëwencabo tönö godongämæ̈ ongöninque, Mïni pante wæquinque ëñënämaï ingamïnimpa töö, ante apænte pïinguingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Cönäö wodi Wængonguï beyæ̈ apæ̈necä ëñëninque Nïnebaidi wënæ wënæ näni cægaïnö ante wæwente pönëninque ñimpo cægadänimpa. Cönäö wodi wædangä ïñongante botö wæætë në ñæ̈næ̈mo inte apæ̈nebo ëñëninque mïnitö ïñömö ëñënämaï ïmïnipa. Ïninque Nïnebaidi incæ Wængonguï në apænte angä weca pöninque mïni ñöwo quëwencabo tönö godongämæ̈ gongænte ongöninque, Mïni pante wæquinque ëñënämaï ingamïnipa töö, ante apænte pïïnänidö anguënë,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ayæ̈ godömenque apæ̈necantapa. “Gongapæncade tï wodönodinque waodäni dicæ awëmö ïñömö wë wodönäniyaa. Owæta boo cæcadäniyaa. Wæætë, Mänïñömö në pö guiidäni acædänimpa, ante cædinque gongapæncade awæmpa æ̈mongapaa cö cædäni ñäö bæco adänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mönö baö tömäo beyæ̈ mönö awinca tica ënente baï ëmömompa. Mönö nö pönëninque amö ïninque mönö ñäö tica ënente cægonte baï waa cæte quëwëmompa. Wæætë wïwa pönente amö ïninque mönö wëmö ïñömö cægonte baï inte wïwa cæte quëwëmompa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mänömaï beyæ̈ bitö, Wëmö ëwocadämaï incæboimpa, ante bitö önöwoca cöwä adinque nämä wææ cæe. ");
INSERT INTO aucNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ïninque bitö baö tömäo ñäö entawëninque bitö önöwoca adobaï ñäö ëwocabi ïninque quïomenque incæ wëmö entawënämaï ïmaïmipa. Gongapæncade ñäö bæco edonque abi baï edæ ñäö ædæmö entawëninque edonque adinque waa quëwëmaïmipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ïinque apæ̈necä ate adocanque Paditeocä tömengä ingante, Pö cæ̈e, angä ëñente pö guiite cæncæte ante ongongä. ");
INSERT INTO aucNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Adinque Paditeocä ïñömö, Itota quïnante mempodämaï inte cængää, ante guïñente wæcä. ");
INSERT INTO aucNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ïninque mönö Awënë tömengä ingante, —Mïnitö Paditeoidi ïñömö edæ owæta tönö podato cæncadë ïnö wentamö ënencoo ee adinque yabæque mënongate baï cæmïni ïmïnipæ̈æ̈. Mäincooque æ̈ïnente mïni wædö beyæ̈ ayæ̈ wïwa mïni cædö beyæ̈ edæ mïmöno wentamö entawëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mïni ëñëegadë. Në badongä ïñömö yabæque badöninque cæncadë ïnö badönämaï ingantawogaa. Ïñæmpa mönö baö në badongaingä ïñömö adocä mönö önöwoca badongacäï apa quëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ïninque mïnitö wæætë wadäni ïnänite ædæmö waadedinque mïnitö mäincoo pædæ godö pædæ godö cæmïni ïninque tömancoo edæ ñä mënongate baï ba adinque mïnitö wæætë edæ ñäö baï entawencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Paditeoidi mïni wæquinque ïïmaï cæmïnipa. Mäincoo diete ganca mänimpocoo ænte cö cædinque, Adocooque Wængonguï quï impa, ante mönö godongæ̈impa, ante cæmïnipa. Mïnitö mänömaï cædinque edæ öñabo mïni minte pæyabo, Oguï waa cænguï, ante mïni tä pete æ̈ñabo incæ edæ, Wængonguï quï impa, ante pancayaboga godömïnipa. Mäninganca cædinque mïnitö waa cæmïni incæte wadäni ïnänite nö cædämaï ïmïni inte Wængonguï ingante waadete pönënämaï ïmïnipa töö. Ïñæmpa mänïnö öñabo godonguënëmïni inte mïnitö godömenque waadete pönëninque nö cæquënëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ayæ̈ Paditeoidi mïni wæquinque impa. Mïnitö odömöincönë go guiidinque nämanque ante pönëninque waëmompaa pönï tæ̈ contate tomïni awædö. Ayæ̈ waodäni näni godonte æ̈ïmancadë godinque mïnitö nämanque pönëninque, Wadäni, Waa quëwëedäni, ante apæ̈nedinque mönitö ïmönite waa acædänimpa, ante mïni wæquinque edæ änewëmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ayæ̈ waocä wodido ñömæ̈ï ongö baï mïnitö ïñömö mïni wæquinque edæ wentamö entawëmïnipa. Mänömaï entawëmïnipa, ante ëñënämaï inte wadäni edæ mïni änö ante ëñente cædinque edæ oda cædänipa, ante Itota pïingantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ïninque adocanque idægoidi näni wææ angaïnö ante në ate ëñengä ïñömö Itota ingante apæ̈nedinque, —Awënë, mänömaï äninque bitö mönitö ïmönite adobaï pïinte änewëmi awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Äñongante, —Mïnitö dodäni näni wææ angaïnö ante në adïmïni inte edæ mïni adobaï wæquinque impa. Edæ, Cædämaï cædämaï, ante ancaa wææ äninque mïnitö ïñömö edæ mäincoo teëmencoo mö paate wadäni önönancapæ̈ cö cædancapæ̈näni baï cæmïnipa töö. Ayæ̈ wæætë önompogonca adopogoncaque incæ gä æ̈nancapæ̈nämaï cæte baï cædinque mïnitö mïni wæquinque edæ, Æbänö cæte waa quëwenguïï, ante odömonte apæ̈nedämaï ïmïnipa töö, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ayæ̈ godömenque apæ̈nedinque, “Wængonguï beyæ̈ në apæ̈negaïnäni ïnänite mïnitö mæ̈mæ̈idi incæ në wæ̈nönäni ingadänimpa. Mïnitö ïñömö, Në wæ̈nongaïnäni nänömoidi ïmönipa, ante baï cædinque, Wængonguï beyæ̈ në apæ̈negaïnänido, ante mæ̈nönomïnipa töö. Mïni wæquinque edæ mänömaï cæmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ïninque, Mönitö mæ̈mæ̈idi wæ̈nongadänimpa, ante ëñënïmöni inte tömënäni wodido ante mæ̈nönomönipa, äninque mïnitö mæ̈mæ̈idi näni cægaïnö ante Ao äninque cæmïnipa töö,” ante Itota pïingantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ayæ̈ ïïmaï ante apæ̈necantapa. “Mänömaï beyæ̈ Wængonguï mönö në ëñengaingä ïnongä incæ ïïmaï ante apæ̈negacäimpa. ‘Botö beyæ̈ në apæ̈nedäni tönö botö në da godönäni ïnänite botö, Idægoidi weca gote apæ̈needäni, ämo gocædänimpa. Ämo gote pönäni adinque idægoidi wæætë pancadäniya ïnänite wæ̈nönäni wæncædänimpa. Ayæ̈ pancadäniya ïnänite togænte pänäni wæcædänimpa,’ ante Wængonguï do apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ïninque ñöwo quëwëmïni ïñömïnite, Quïnante wæ̈nömïnii, ante Wængonguï edæ mïnitö ïmïnite ancæcäimpa. Wængonguï beyæ̈ në apæ̈negaïnäni ïnänite tömengä nänö badongaïñedë dodäni mä pönï wæ̈nönäni beyæ̈ ayæ̈ ïincayæ̈ ate ñöwo ganca wæ̈nönäni beyæ̈ ïninque edæ në wæ̈näni tömänäni wepæ̈ näni näagaïnö ante, Ñöwo quëwëmïni mänïnäni tömänäni wepæ̈ näate baï ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Edæ tömänäni näni wæ̈nongaïnö ante edæ ñöwomïni mïni pante wæquinque impa. Edæ mä pönï wæ̈nöninque docä Abedo wodi ingante adocanque wæ̈nongä wængacäimpa. Ïincayæ̈ ate Wængonguï oncö ñæ̈næncö boyæ̈ näni iya täimpaa gäänë ongöñongante Tacadiya wodi ingante wæ̈nönäni nänö wænganca wadäni nanguï ïnäni ïnänite wæ̈nönäni wængadänimpa. Incæte Wængonguï, Mïnitö mæ̈mæ̈idi nänömoidi ingaïmïni inte tömënäni näni wæ̈nongaï beyænque wepæ̈ näate baï wentamö entawëñömïnite botö wæætë ñöwomïni ïmïnite pämo wæcæmïnimpa, ante Wængonguï angampa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ayæ̈ apæ̈nedinque, “Dodäni näni wææ angaïnö ante në adïmïni ïñömö mïnitö në ëñenguënëmïni inte edæ mïni wæquinque nö pönente ëñënämaï ïmïnipa. Ayæ̈ wadäni, Nö pönente ëñengæ̈impa, ante odemö guiite baï tæcæ cædäni adinque mïnitö odemö tee mönete yabæ wido cæte baï cædinque tömënäni ïnänite edæ wææ cæmïnipa töö,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ïinque apæ̈nete tao goyongä në odömönäni tönö Paditeoidi tömengä ingante nanguï pïinte badinque, Ämöni ëñëninque apæ̈nebi ëñëmönii, apæ̈nebi ëñëmönii, ante ancaa änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ayæ̈, Tömengä wabänö oda cæte tedecä ïninque mönö wæætë pämö wæbaingampa, ante wææ wänonte baï cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mänïñedë nanguï ïnäni æpodö mïido ganca ïnäni adoyömö pö bee të bee të cædinque goto gongæ̈ñönäni Itota tömengä mïñæ̈ në godäni ïnänite täno apæ̈nedinque, “Paditeoidi ïñömö wadö tedete wadö cæyönäni mïnitö wæætë wadö näni cædö ante, Päö yedæ æmpoquï baï wodö wodö cæpa, ante gomö adinque tömënäni näni cæïnö baï cædämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Adämaï incædänimpa, ante quïëmë wë wodonte ï incæ ïincayæ̈ ate tömää wi æ̈nete bayonte edonque pönï bacæ̈impa. Ayæ̈ quïëmë awëmö cæte ï incæ ïincayæ̈ ate edonque pönï acædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wëmö ïñömö mïni tededö incæ edæ ñäö ïñömö edonque pönï ëñengæ̈impa. Ayæ̈ guiicönë mïnitö wæntæ apæ̈nedö incæ ïincayæ̈ ate oncömanca ïnö æi edæ ogæ̈ tedete edonque ëñengæ̈impa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ayæ̈, “Botö æ̈migoidi ämo ëñëedäni. Waocä baonque wæ̈nönäni ate tömengä ingante ædö cæte godömenque cæquïnänii. Ïninque mïnitö ïñömö, Baonque wæ̈nönäni wæncæ wæ, äninque edæ guïñënämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wæætë edæ, Æcänö ingante guïñente wæquënëmïni ïmïnii, ante botö odömonte apæ̈nebo ëñëedäni. Waomïni ïmïnite wæ̈nonte ate në angä ïnongä inte tadömengadænguipo në wido cæcä ingante ïñömö mïnitö tömengä ingante edæ guïñëedäni. Ao. Mäningä ingante guïñente wæedäni,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ayæ̈, “Waodäni ayamöidi önompo æ̈mæmpoque mänimpodäni beyæ̈ tiguitamö mentamonga ante pædæ godonte æ̈näni amïnitawo. Incæte ayamö adocanque ingante edæ Wængonguï cöwë wææ aacampa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Edæ, Ayamöidi bacoo pönï ïnäni incæte önönänique ïnänipa, ante në äningä inte mönö Mæmpo ïñömö mïnitö ïmïnite wæætë godömenque waa acampa. Ïñæmpa mönö ocaguï incæ æpoguïnö encamöö, ante Wængonguï ïñömö edæ do ëñente aacä apa guïñëwëmïnii,” ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ayæ̈ apæ̈nedinque, “Näwangä ämopa, angantapa. Æcänö waodäni ëñëñönäni botö ïmote Ao äninque, Bitö botö Awënë ïnömi ïmipa, ante äna botö Waobo në ëñagaïmo inte tömengä ingante wæætë Ao äninque, Bitö ïñömö botö mïñæ̈ në gogaïmi ïnömi ïmipa, ante Wængonguï anquedoidi ëñëñönäni ancæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wæætë edæ waodäni ëñëñönäni botö ïmote në Baa angaingä ingante botö wæætë Wængonguï anquedoidi ëñëñönäni tömengä ingante edæ Baa ancæboimpa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Äninque, “Botö Waobo ëñagaïmö ïñömote waocä babæ ante wïwa angä incæte Wængonguï wæætë edæ pönö ñimpo cæcä quëwencæcäimpa. Wæætë Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante godö babæ ante në änewengä ingante Wængonguï wæætë edæ ñimpo cædämaï inte cöwë pancæcäimpa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ayæ̈, “Mïnitö ïmïnite bæi ongonte tömënäni odömöincönë ænte godinque gö cædäni incæte mïnitö mänïñedë, Æbänö ante apæ̈nequïmoo, ante wædämaï ïedäni. Awënëidi weca incæ në änäni weca incæ mïnitö ïmïnite ænte mäo goncædäni incæte mïnitö mänïñedë, Pïïnäni ëñente wædinque æbänö ante nämä wææ anguïmoo, ante ayæ̈, Æbänö ante apæ̈nequïmoo, ante guïñente wædämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ïñæmpa Wængonguï Tæiyæ̈ Waëmö Önöwoca mänïñedë incæ, Æbänö wææ anguïï, ante odömonte angä ëñëninque mïnitö wæætë mänïnö ante wææ ancæmïnimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tæcæ apæ̈neyongä godongämæ̈ ongönäni ongöninque adocanque Itota ingante, —Awënë, botö wæmpo wodi mangaincoo incæ mæmpo wodi ömæ ingaïmæ incæ botö mëmö ingante tæcæguedë ämi pä cæcä æ̈möe. ");
INSERT INTO aucNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Äñongante Itota, —Botö në apænte ämo ïmopa diyæ̈ ämo pä cæquingää. ");
INSERT INTO aucNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Äninque godongämæ̈ ongönäni ïnänite apæ̈nedinque, —Wïï mäincoo nanguï ænte beyænque mönö quëwengæ̈impa cæmïnii. Mïni mäincoo æ̈ïnëmämo ante edæ ñimpo cædinque ee aedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Äninque Itota, Wængonguï Awënë æbänö cæquingää, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. —Adocanque në nanguï ëacä inte tömengä ömæ wainguipoga nanguï pönï pæ. ");
INSERT INTO aucNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Adinque tömengä ïñömö, “Æbänö cæquïmoo. Botö cænguï da wenguincö ñæ̈næncö impa diyæ̈ da wente manguïmoo.” ");
INSERT INTO aucNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Äninque, “Ïïmaï cæcæboimpa. Guiyancö oncö bæ tate ñæ̈næncö wæætë mæ̈noncæboimpa. Mæ̈nöninque tömëmoncoo tönö mäincoo wæætë mänincönë tömancoo da wencæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ayæ̈ nämanque apæ̈nedinque botö, Botö cænguï tönö mäincoo nanguï wadepo ba beyæ̈ eyepæ̈ mänïmo inte botö guëmancæboimpa. Önonque cænguï nanguï cænte nanguï bete tocæboimpa,” ");
INSERT INTO aucNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ante nämanque pönëñongä wæætë në mäningä ingante Wængonguï, “Ëñënämaï cæbipa töö. Ñöwo woyowotæ̈ incæ edæ, Idæwaa quëwëmipa, ämo wæncæbiimpa. Wæ̈mi adinque edæ bitö mäincoo ïnï edæ æcänö mäincoo baquïï,” ante Wængonguï angampa, ante Itota, Mäninque ante apæ̈nebopa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ayæ̈ tömënäni ïnänite wæætë, “Wængonguï mänömaï angä ëñente wædinque mïnitö wæætë ïïmaï ante pönencæmïnimpa. Æcänö, Tömëmoque quï, ante da da wente mäna ïñömö tömengä Wængonguï ayongä në ömæpocä baï inte ömæwocacä ingampa. Në ëacä wodi nänö wæ̈nö baï tömengä adobaï bate wæquïnö anguënë,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Itota mänïñedë tömengä mïñæ̈ në godäni ïnänite, “Ïninque botö mïnitö ïmïnite ämopa. Inguipoga mïni quëwenguïmämo ante wædämaï ïedäni. Quïmönö impa cænguïmoo, ante, Quincoodö impa wëñaquïmoo, ante wædämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cænguinque cæ̈ninque dicæ quëwëmongaa. Weocooque wëñadinque dicæ quëwëmongaa. Mönö quëwenguïmämo ïñömö godömenque impa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gapatai ïñömö cænguï ante dicæ minte pæ ate tä pete mänäniyaa. Incæte Wængonguï eyepæ̈ godongä cæ̈näni aedäni. Mïnitö guiquënë öömä ëadäni baï ïnämaï ïñömïnite Wængonguï mïnitö ïmïnite godömenque waa adinque eyepæ̈ pönongä cæ̈mïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wængonguï nänö anganca quëwëninque mïnitö nanguï cædinque wantæ ïñö incæ ædö cæte godömenque quëwenguïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mänïnö wædænque cæquï incæte wïï eyepæ̈ cæmïni ïninque mïnitö, Botö quëwenguïnö ante wadö wadö cæcæboimpa, ante quïnante wæmïnii,” ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ayæ̈, “Ongai guiquënë weocoo ante daque daque dadämaï inte wodonte tïnämaï ïñönänite Wængonguï weocoo waëmoncoo baï godongä waa pönï ënopa. Awënë Tadömöö wodi waëmoncoo ëagaingä incæ wïï ongai baï ëñagacäimpa. Ongai ïñömö godömenque waëmö pönï ënopa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gaguïmæ̈ ïñömö ïïmö ate edæ gongapamö në tanguinque ñöwoönæ pæ incæte Wængonguï waëmö pönongä ënopa. Ïninque, Waëmö ënodö në pönongä inte mönö ïmonte godömenque eyepæ̈ pönï pönongä ænte ëñacæ̈impa, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mïnitö cænguï ante bequï ante æ̈ïnente wædämaï ïedäni. Edæ, Æbänö cæte ænguïmöö, ante wædämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Inguipoga wayömö näni ëñënämaï incabo wayömö näni ëñënämaï incabo mänïnö ante wæyönäni mïnitö guiquënë, Mönö ænguënënö ante mönö Mæmpo ïñömö edæ do ëñengampa, ante pönëninque guïñente wædämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wæætë Awënë Odeye nempo quëwencæte ante nanguï cæyömïnite tömengä wæætë mïnitö ænguënënö ante do edæ eyepæ̈ pönï pönongä æncæmïnimpa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Godömenque apæ̈nedinque Itota, “Botö në aabo ïñömote mïnitö botö mïñæ̈ mïni gocabo ïñömö wædænque pönï ïmïni incæte edæ guïñente wædämaï ïedäni. Ïñæmpa mïnitö Mæmpo ïñömö, Awënë Odeye nempo quëwencæmïnimpa, ante pönö cædinque waa tocampa cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mïnitö ïñömö, Ö æ̈näni dæ äñömö cayæ̈ cæ̈nämaï ïñömö botö mäincoo wodämaï inguincoo inte edæ cöwë mæ̈ ongongæ̈impa, ante cædinque öönædë ïñömö wo æ̈æntodonte baï cæedäni. Wodämaincadedë da wente baï cædinque mïnitö mäincoo godonte æ̈ninque ömæpodäni wæwënäni ïnänite wæætë godömïni æncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mïni waocabo ïñömö mïnitö mäincoo ongöñömö mänïñömö quëwencæte ante wæmïni ïmïnipa, ante adinque botö, Öönædë ïñömö wo æ̈æntodonte baï cæte mäedäni, antabopa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ayæ̈ apæ̈nedinque, “Waodäni, Awënë beyæ̈ ante cæcæ̈impa, ante weocoo eyepæ̈ wëñadinque, Gongapæncade waëmö bæcocæ̈impa, ante eyepæ̈ pönï cædäni baï mïnitö adobaï eyepæ̈ pönï cædinque, Awënë poncæcäimpa, ante wänö cöedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Edæ waodäni tömënäni awënë wayömö gote æ̈æ̈mæ̈ bete ocæ̈ ëmænte ponte aa pecä ëñëninque quingæ̈ wi æ̈necæte ante wänö cönäni baï cædinque mïnitö adobaï, Awënë poncæcäimpa, ante wänö cöedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Edæ awënë ponte ayongä tömengä ingante në cædäni wänö cönäni adinque tömengä wæætë edæ pönö waa cæcä æ̈ninque tömënäni ïñömö tocædänimpa. Mïnitö ïmïnite näwangä ämopa. Në wänö cönïnäni ïnänite awënë pönö angä ate tæ̈ contadäni ate tömengä në awënë ïnongä incæ, Nanguï cæcæ̈impa, ante weocoo wëñadinque tömënäni weca pöninque edæ pönö cæcä æncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Edæ woyowotæ̈ tæcæ bæcä incæ ayatadäa wæicä incæ pöninque tömengä në wänö cönïnäni ïnänite waa adinque pönö waa cæcä adinque tömënäni ïñömö watapæ̈ edæ tocædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wæætë oncö në ëacä guiquënë, Në awëmö æncæ cædongä æyedënö ponguingää, ante ëñëninque do wææ cæcä baï në awëmö æncæ cædongä wæætë edæ pö guiite æ̈nämaï incædongäimpa, ante apæ̈nebo ëñente pönëedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mïnitö adobaï, Waocä në ëñagaingä æyedënö ponguingää, ante ëñënämaï ïmïni inte edæ tömänö eyepæ̈ cædinque edæ wänö cöedäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mänömaï angä ëñëninque Pegodo, —Mänïnö odömonte bitö apæ̈nedö ante mönitö adomönique ëñencæmönimpa, ante apæ̈nebitawo. Wæætë edæ, Wadäni tömänäni ëñencædänimpa, ante apæ̈nebitawo. ");
INSERT INTO aucNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Äñongante mönö Awënë wæætë odömoncæte ante apæ̈nedinque, “Inguipoga awënë ïñömö, Æcänö në ëñengä ïnongä inte botö quincoo ante ædæmö aacä inguingää, äninque, Mänömaï inte cæcä ingante adinque botö ämo ate tömengä në angä badinque botö oncönë në cædäni ïnänite ædæmö aadinque cænguï eyepæ̈ ïñonte godongä cæncædänimpa, angampa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ïninque awënë wayömö gote ponte ayongä, Në cæcä botö änö ante ëñente cæcampa, ante adinque awënë wæætë tömengä ingante godö waa cæcä ate në waa cæcä ïñömö edæ waa tocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mïnitö ïmïnite näwangä ante apæ̈nebopa. Në ëñente cædingä ingante awënë, Bitö botö mäincoo tömancoo edæ në aabi bacæbiimpa, ancæcäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Incæte në cæcä wæætë, Botö awënë æiquedö ponguingää, ante pönëninque tömengä tönö awënë ingante näni godongämæ̈ cæcabo onguïñæ̈näni incæ onquiyæ̈näni incæ tömënäni ïnänite tæi tæi päninque cænguï nanguï cæ̈ninque tï nämæ̈ nanguï bete quidi quidi dowænte bacä. ");
INSERT INTO aucNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ïninque tömengä, Æönædö ponguingää, ante wædämaï ïñongante, Æyedënö ponguingää, ante ëñënämaï ïñongante edæ awënë ïñontobæ̈ pongä wæbaingampa. Ponte adinque awënë wæætë mäningä në ëñënämaï cædingä ingante wido wido todinque në pönënämaï ïnäni weca mäo wido cæbaingampa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ayæ̈, “Awënë ingante në cæcä incæ awënë nänö änö ante önömoncaque ëñëninque wïï eyepæ̈ cædinque ëñënämaï cæcä ïninque awënë ïñömö tömengä ingante nanguï tæi tæi pancæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ayæ̈ wæætë edæ, Awënë æbänö angää, ante ëñënämaï inte ëmoncacä guiquënë tömengä nänö panguinque wënæ wënæ cæcä incæte tömengä ingante wædænque tæi tæi pancæcäimpa, ante Itota apæ̈negacäimpa. Edæ awënë æcänö nempo nanguï pönongä ænte næ̈ængä ïñömö tömengä ingante Awënë wæætë, Bitö adodö nanguï pönömi æ̈moe, ancæcäimpa. Ayæ̈, Botö mäincoo nanguï ongoncoo ïñonte bitö aacæbiimpa, ante æcänö ingante awënë angää tömengä ingante, Bitö godömenque nanguï cæcæbiimpa, ante awënë ancæcäimpa,” ante odömöninque Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Äninque Itota godömenque apæ̈nedinque, “Botö inguipoga gonga baï tänoncæte ante pongaïmo inte edæ, Do tänonte baï edæ waa tocædömoimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ayæ̈ botö nantate wæwencæte ante pongaïmo inte botö nantate wæganca nantate botö wæquënënö ante ïinque cæcæte ante wæbopa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mïnitö, Inguipoga quëwënäni piyæ̈në cæte wæætedö wæætë cædämaï inte quëwencædänimpa, ante cæcæte ante Itota pongaingä ingampa, ante pönëmïnitawo. Ïñæmpa wadö ämo ëñëedäni. Botö inguipoga pömo beyænque wæætedö wæætë pïincædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ïincayæ̈ ate önompo æ̈mæmpoque näni owocabo mänimpodäni ïñönänite mengäa go adocanque ïnäni ïñömö botö beyænque mënaa ïnate näëmæ̈ pïinte bacædänimpa. Ayæ̈ wæætë mënaa ïna incæ mengäa go adocanque ïnäni ïnänite wæætë näëmæ̈ pïinte bacædaimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Botö ëmöwo beyæ̈ mæmpocä tömengä wengä onguïñængä ingante näëmæ̈ pïinte bacæcäimpa. Wëñængä wæætë mæmpocä ingante näëmæ̈ pïinte bacæcäimpa. Wäänä tömënä wengä onquiyængä ingante wæætë näëmæ̈ pïinte bacædäimpa. Wæætë wäänä ingante wëñængä incæ näëmæ̈ pïinte bacæcäimpa. Biyongä ingante nänö wæntedä incæ näëmæ̈ pïinte bacædäimpa. Nänö wæntedä ïnante biyongä ingante näëmæ̈ wæætë pïinte bacæcäimpa,” ante Itota tömengä mïñæ̈ në godäni ïnänite apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ayæ̈ godongämæ̈ ongönäni ïnänite apæ̈nedinque, “Nænque guiidö gämæ̈nö boguïmä wentamö pö adinque mïnitö, Cöönæ wentamö wocæmpa, äñömïni edæ do cæpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ayæ̈ wæætë woboyæ̈ betamonca ïnö pæ̈mæ̈ pö adinque, Ocoi näwancæ cæpa, ante tedeyömïni dobæ ocoi näwampa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Inguipoga gomö adinque öönædë æ̈mö adinque mïnitö, Æbänö cæcæte ante ëmöö, ante edæ do ëñëmïnipa. Wæætë, Inguipoga wayömö wayömö æbänö cædänii, ante adinque mïnitö, Wængonguï oo pönï cæquingänö anguënë, ante quïnante wïï ëñëmïnii. Edæ wadö tedete wadö cæmïni ïmïnipa töö,” ante Itota tömënäni ïnänite pïingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ayæ̈ edæ, “Æbänö cæte nö cæquïï, ante mïnitö tömëmïnique apænte ante cæquënëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Në pïinte angä ïñömö bitö ïmite edæ, Wïwa cæbipa, ante awënë weca ænte mäocä idömæ godinque bitö guiquënë tömengä ingante waadete apæ̈nebi ëñëninque tömengä wæætë piyæ̈në cædinque ee abaingampa. Wæætë edæ wïï waadete apæ̈nebi ïninque tömengä në apænte angä weca godömenque ænte gobaingampa. Në apænte angä wæætë bitö ïmite wææ wänongä ingante pædæ godongä æ̈ninque wææ wänongä wæætë tee mönebaingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tee mönecä ïninque bitö quïëmë beyæ̈ debe ïmi ïninque edæ tömanta pönï di godonte ate tabaïmipa, ante ämo ëñëmaïmipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mänïñedë wadäni Itota weca pöninque ïïmaï ante apæ̈nedäni ëñengantapa. Gadideabæ quëwënäni, Wængonguï quï, ante cæ̈ningä ingante tæcæ wæ̈nöñönänite Pidato guiquënë tömënäni ïnänite ïñontobæ̈ wæ̈nöninque tömënäni wepæ̈ cæ̈ningä wepæ̈ tönö dibæ cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ante tedeyönäni Itota wæætë, “Gadideabæ quëwënäni wadäni pönömenque wënæ wënæ cædäni ïñönäni mänimpodänique godömenque wënæ wënæ cædäni inte mänömaï wæ̈nänipa, ante mïnitö pönëmïni awædö. Ïñæmpa Gadideabæ quëwënäni tömänäni adobaï wënæ wënæ cædäni ïñönäni mänïnänique edæ wæ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wïï mänömaï impa, ämo ëñëmaïmïnipa. Tömënäni wïï godömenque wënæ wënæ cædïnäni inte wæ̈nänitapa. Mïnitö guiquënë wënæ wënæ mïni cædïnö ante wæwente pönëninque ñimpo cædämaï ïmïni ïninque mïnitö tömämïni adobaï wæ̈maïmïnipa,” ängantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Ayæ̈ Eedotadëë ïñömö tömënäni näni gomö aquincö Tidoee näni änoncö tæ̈ wææ̈ñonte waodäni dietiocho ganca ïnäni capo wæ̈näni ïninque mïnitö, Tömënäni godömenque wënæ wënæ cædäni inte wæ̈nänipa, ante pönëmïni awædö. Ïñæmpa Eedotadëë quëwënäni tömänäni adobaï wënæ wënæ cædäni ïñönäni mänimpodänique edæ wæ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wïï mïnitö pönënö baï impa, ämo ëñëmaïmïnipa. Tömënäni wïï godömenque wënæ wënæ cædïnäni inte wæ̈nänitapa. Mïnitö guiquënë wënæ wënæ mïni cædïnö ante wæwente pönëninque ñimpo cædämaï ïmïni ïninque mïnitö tömämïni adobaï wæ̈maïmïnipa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ayæ̈ Itota, Wængonguï Awënë æbänö cæcää, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. “Waocä tömencodë iigowæ̈ minte pæ ate tömenca ante ponte ayongä edæ dæ ömæcawæ̈ ongompa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ate wædinque tömengä ocæ̈ ëmænte godinque tömencawæncoo në aacä ingante apæ̈nedinque, ‘Edæ mëa go adoque wadepo tömenca ante gote ayömo edæ mänïï iigowæ̈ cöwë ömæcawæ̈ önonque wææ ongompa cæbii. Ömæcawæ̈ wææ ongöwæ̈ adinque wido tate æ̈mæ̈wo wido cæe.’ ");
INSERT INTO aucNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Äñongä tömencawæncoo në aacä wæætë, ‘Awënë, ee ongöe. Botö iigowæ̈ önöwa gäänë æ̈æ̈ wodinque mämö wagada goi ænte wempo cædente tee moncabo ate wadepo ate bitö ongöñömi edæ, ");
INSERT INTO aucNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","do incabaimpa. Wæætë wadepo ate ayömite ömæcawæ̈ ate wædinque edæ æ̈mæ̈wo wido tate wido cæbaïmipa,’ ante në cæcä angampa.” Mäninque ante odömonte apæ̈nebopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Guëmanguïönæ ïñonte Itota oodeoidi odömöincönë go guiidinque odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Onquiyængä mänïñömö ongongä ïñömö tömengä dietiocho wadepo ïñonte wënæ guiicä ate bocæ bocæ wæwëningä inte ædö cæte adiyæ̈ ængæ̈ gantiquingää. ");
INSERT INTO aucNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tömengä ingante adinque Itota aa pecä pongä ate, —Onquiyæ̈mi, bitö bocæ bocæ wædö ante ñöwo botö ñïmæncæpote baï cæbo ate bitö waa babipa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Äninque tömengä ingante gampocä ate ñïmæncæpote baï badinque onquiyængä ïñömö adiyæ̈ gantidinque wæætë, Wængonguï bitö ñäö baï ëmömi inte waa pönï pönö cæbi æ̈mopa, ante watapæ̈ apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Guëmanguïönæ ïñonte Itota mänömaï cæcä waa bacä adinque tömënäni odömöincö awënë guiquënë pïinte badinque godongämæ̈ ongönäni ïnänite, —Quïmæ̈ quëwëmïnii. Önompo æ̈mæmpoque go adoönæque mönö cæönæ ïñonte mïnitö waa bacæte ante ponguënëmïni ïmïnipa. Guëmanguïönæ ïñonte edæ cædämaï inguënë quëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ante pïïñongante mönö Awënë wæætë, —Mïnitö wadö tedete në wadö cædömïni inte ëñëedäni. Mïnitö cæ̈ningä ïñömö wagada incæ bodo incæ gue æ̈nente wæyongante mïnitö guëmanguïönæ ï incæte cöwë ñï cæyænte æpæ̈ wedeca ænte mäo gönömïni gongænte becampa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wæætë mäningä onquiyængä ïñömö Abadäö wodi pæ̈ingä ïñongante Tatäna dietiocho wadepo ïñonte goti winte baï cæcä wædingä ïñongante mïnitö ïñæmpa guëmanguïönæ ï beyænque edæ, Tömengä ñïmæncæpodämaï incæcäimpa, ante quïnante wææ ämïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Angä ëñente wædinque në pïinte änäni guingo imonte wæyönäni godongämæ̈ ongönäni guiquënë, Bamönengæ̈ pönï Itota waa pönï cæcampa, ante adinque nanguï togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ïninque Itota tömënäni ïnänite, “Wængonguï Awënë Odeye nempo näni quëwencabo ïñömö quïnö baï ïnänïï. Edæ, Æbänö nanguï yebænte badänii, ante botö inguipoga quïnö pæte yebænte baï ï adinque, Mänïnäni adobaï yebæ̈nänipa, ante ëñenguïï. ");
INSERT INTO aucNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ïïmaï impa. Waocä möotatamö tömëmö ænte mäo tömëmoncodë quiyacä bocate pæ ïninque ñæ̈næ̈ñeque bayonte ayamöidi pöninque awæ̈nëmæ̈ ongönänipa. Möotatamö guidïmö incæ mänömaï pæ baï Wængonguï Awënë nempo quëwënäni ïñömö wædænque ïnïnäni incæ nanguï yebænguïnäni ïnänipa,” ante Itota odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Itota ayæ̈ angantapa. “Wængonguï Awënë ïñömö tömengä nempo quëwënäni ïnänite æbänö cæcää, ante odömoncæte ante botö, Ïïmaï cæcampa, ante odömonte apæ̈nebo ëñenguïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Edæ ïïmaï impa. Onquiyængä ñæ̈nængade tee manguincade ænte tee mäninque ædïna näni ämö ænte mempoga go adopoque da wëninque ayæ̈, Päö yedæ æmpocæ̈impa, ante adoyömö pönö da wëninque wempo wempo ædæmö cædengä ate päömo yedæ æmpote tömäo näämænta bapa. Yedæ æmpote ate päömo tömäo näämænta ba baï öönædë Awënë nempo mïni quëwencabo ïñömö tömämïni nö ëñente bamïnipa,” ante Itota odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Itota mänïñedë Eedotadëë taadö godinque nanguï näni quëwëñömö wodo pænta godinque wædænque näni quëwëñömö wodo pænta godinque wayömö wayömö gote odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Goyongante adocanque, —Awënë, bitö æ̈mi beyænque në quëwenguïnäni ïñömö wædænque ïnänipa, ämitawo. Äñongante Itota, ");
INSERT INTO aucNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Odemö guiyänemö guiicæte ante edæ nanguï cæedäni. Edæ nanguï ïnäni incæ guiicæte ante cædinque guiidämaï incædänimpa, ämo ëñëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ïïmaï impa. Oncö në ëacä ængæ̈ gantidinque odemö tee mönecä adinque mïnitö ïñömö tömengä oncö boyæ̈ gote ongöninque aa pedinque, “Awënë, wi æ̈nebi guiiquïmönii.” Ante wæyömïnite tömengä, “Æmïnidö ïmïnii, ante ayæ̈, Ædönö gämæ̈nö quëwente pömïni ïmïnii, ante botö adämaï ïmopa,” ancæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Angä ëñëninque mïnitö wæætë, “Ïñæmpa mönitö bitö tönö godongämæ̈ cænte becongamönimpa. Ayæ̈ bitö mönitö taadö ponte cægöninque odömonte apæ̈nebi ëñengamöni ae,” ancæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Äñömïni tömengä ïñömö, “Æmïnidö ïmïnii, ante, Ædönö gämæ̈nö pömïni ïmïnii, ante botö ëñënämaï ïmopa. Edæ do antabopa. Ñöwo në wïwa cægaïmïni inte edæ botö weca ongönämaï. Edæ wadæ goedäni, ämopa,” ancæcäimpa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ïninque mïnitö gomö ayömïni Wængonguï beyæ̈ në apæ̈negaïnäni tönö dodäni Abadäö wodi Itæca wodi Aacobo wodi tönö tömänäni Wængonguï Awënë Odeye ömæ godongämæ̈ ongöñönäni mïnitö ïmïnite edæ yabæque wido cæcä ate wædinque mïnitö wæætë guingo imonte pïinte wædinque edæ Ca ca wæcæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wadäni wæætë edæ nænque tamönö pönäni tönö nænque guiidö pönäni ayæ̈ betamonca æ̈matæ̈ æ̈matæ̈ pönäni tönö Wængonguï Awënë Odeye oncönë ponte tæ̈ contadinque æ̈æ̈mæ̈ bete cængoncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ïninque ayæ̈ ate ëñënäni incæ pancadäniya yæcado ongönäni bate toyönäni mïnitö guiquënë do ëñënïmïni inte yæcado ongömïni incæte pancamïniya wæætë yæmïñæ̈ gote ongonte wæcæmïnimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mänïñedë Paditeoidi pancadäniya tömengä weca pöninque, —Awënë Edode bitö ïmite wæ̈noncæ angantaye. Bitö ongönämaï wayömö wadæ goe. ");
INSERT INTO aucNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Änäni ëñëninque Itota, —Edode congäñe baï babæ cædongä ïñongante mïnitö tömengä weca godinque, Itota ïïmaï angampa, ante apæ̈nemïni ëñengäedäni. “Edode ëñëmi. Botö ñöwoönæque baönæque wënæidi ïnänite ïinque wido cædinque ïinque godö cæbo waa badäni ate ïñabæ guingä ïñonte botö edæ mänïñedë edæ idæwaa cægaïmo bacæboimpa, ante Itota apæ̈necampa,” ante apæ̈nemïni ëñengäedäni, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Incæte botö ñöwoönæ godinque baönæ godömenque godinque edæ waönæ godömenque botö goquënënö godinque Eedotadëë gocæboimpa. Edæ Wængonguï beyæ̈ në apæ̈negaïnäni incæ Eedotadëë ïñömö tömënäni näni wængaïñömö ïñonte botö Wængonguï beyæ̈ në apæ̈nebo adobo ïnömo inte edæ ædö cæte wayömö ongonte wænguïmoo. ");
INSERT INTO aucNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ante apæ̈nedinque Itota Eedotadëë ïñömö quëwënäni beyæ̈ ante pönente wædinque, “Eedotadëë quëwëmïni ëñëedäni, angantapa. Wængonguï beyæ̈ në apæ̈nedäni ïnänite mïni wæ̈nongaincabo inte ayæ̈ Wængonguï nänö da pönönäni ïnänite dicaca tacamïni ïñömïnite botö ïñömö mïnitö ïmïnite waadete pönö cæïnente nanguï wæbopa. Tawadiya wæ̈mönä ïñömö, Botö wënäni, ante gompodinque tæcæënëmæ̈ wëä pönö ö æ̈nä baï botö adobaï, Botö wënäni pöedäni, ante æpogadö äñömote mïnitö, Wïï pöïnente awædö, ante Baa ämïni wætabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ñöwo ïñömö mïnitö onconcoo edæ önonconcooque baconcoo tamëñedäni. Ñöwo edæ botö dæ äñömo mïnitö, ‘Awënë Wængonguï ëmöwo beyænque pöninque bitö toquinque edæ waa cæcæbiimpa,’ ante mïni anguinganca mïnitö edæ botö ïmote adämaï incæmïnimpa ante ämo ëñëedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Itota guëmanguïönæ ïñonte Paditeoidi awënë oncönë cæncæte ante go guiiyongante godongämæ̈ ponte ongönäni guiquënë, Itota æbänö cæquingää, ante waa agönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tömengä weca adocanque æpæ̈ ëñate në wædongä inte a ongongä. ");
INSERT INTO aucNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Adinque idægoidi näni wææ angaïnö ante në ate ëñënäni tönö Paditeoidi ïnänite apæ̈nedinque Itota ïïmaï angantapa. —Wængonguï æbänö ante wææ angacäï. Waa bacædänimpa, ante guëmanguïönæ ïñonte mönö waa cæquënëmö ïmöö, ante pönëmïni. Wæætë edæ, Guëmanguïönæ ïñonte cædämaï inguënëmö ïmöö, ante pönëmïni. ");
INSERT INTO aucNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Äñongä edæ pæ wëënedänitapa. Itota ïñömö edæ në æpæ̈ ëñate wædongä ingante gampocä waa bacantapa. Ayæ̈, Goe, angä gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Angä gocä ate Itota wæætë tömënäni ïnänite ïïmaï angantapa. —Mïnitö waocabo ïñömïnite adocanque tömengä wëñængä onguïñængä incæ tömengä wagada onguïñængä incæ æpæ̈ ante näni æ̈æ̈ wodïñömö goyæ̈ guiicä ïninque mæmpocä ïñömö guëmanguïönæ ïñonte edæ dicæ töö tadönämaï inguingää. Mänömaï goyæ̈ guiicä wædinque mïnitö tömämïni guëmanguïönæ ï incæte do gote näwæ̈ gongæ̈ninque edæ quingæ̈ töö tadömaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ante Itota äñongante tömënäni ædö cæte wæætë anguïnänii. Edæ pæ wëënedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ayæ̈ Paditeo awënë nänö në äñedïnäni pöninque nämanque ante pönëninque, Yæcado ongöñömote botö ïmote waa acædänimpa, ante cædinque waa pönï tæ̈ contaï ïñömö tæ̈ contadäni Itota acantapa. Ïninque tömengä, Wængonguï Awënë nempo quëwëninque æbänö cæquïï, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Bitö ïmite, Monguïmæ̈no pö bee, ante në wente ængä ëñëninque bitö pöninque yæcado ïnö waëmö ïñömö tæ̈ contadämaï incæbiimpa. Ïñæmpa wacä tömengä nänö në waadecä pongä ïninque ");
INSERT INTO aucNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mïnatö ïmïnate në wente ængä ïñömö bitö weca pöninque, “Bitö gä goyömi botö në waadecä wæætë tæ̈ contaquingä,” ante ämaingampa. Ïninque bitö gä godinque wïï waëmö ïñömö wæætë tæ̈ contadinque guingo imonte wæbaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wæætë në wente ængä ëñëninque bitö monguïmæ̈no pöninque yæmïñæ̈ pönï wënæ wënæ ïñömö tæ̈ contae. Edæ në wente ængä ponte ayongä bitö wënæ wënæ ïñömö tæ̈ contabi adinque tömengä wæætë bitö ïmite, “Botö në waadebi ïnömi inte bitö ñöwo yæcado pönï pö tæ̈ contae, ämopa,” ämaingampa. Mänömaï angä ëñëninque godongämæ̈ cæ̈ cönäni ïñömö, Në ëacä nänö në waadebi bitö ïmi amönipa, ante bitö ïmite waa abaïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Edæ, Botö nämä në waa cæbo ïnömo inte edæ yæcado ongonguënëmo ïmopa, ante në cæcä ïñömö tömengä ïñömö wææntodonte baï guingo imonte wæcæcäimpa. Wæætë edæ, Botö önömoque ïmopa, ante yæmïñæ̈ në ongongä ïñömö tömengä guiquënë ængö cæte tocæcäimpa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tömënäni ïnänite ïinque apæ̈nedinque në wente æ̈ningä ingante Itota godömenque angantapa. —Bitö, Pö cæ̈e, ante æ̈æ̈mæ̈noca wente æ̈ninque bitö æ̈migoidi ïnänite wente æ̈nämaï ïe. Bitö tönïñadäni ïnänite wente æ̈nämaï ïe. Bitö guiidënäni ïnänite wente æ̈nämaï ïe. Eyequeï owote mäincoo në ëadäni ïnänite wente æ̈nämaï ïe. Edæ bitö tömënäni ïnänite wente æ̈mi ïninque tömënäni wæætë bitö ïmite wente æ̈maïnänipa, ante wææ cædinque bitö ïñömö, Botö godönö wæætë eyepæ̈ pönönäni mäninque æ̈ninque öönædë wæætë æ̈nämaï ïmaïmopa, ante wædinque edæ tömënäni ïnänite wente æ̈nämaï ïe. ");
INSERT INTO aucNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wæætë æ̈æ̈mæ̈no ante wente æ̈ninque ömæpodäni inte wæwënäni ïnänite cömante wæwënäni ïnänite bee ñante wæwënäni ïnänite babetamönäni ïnänite wente æ̈e. ");
INSERT INTO aucNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mänïnäni ïnänite wente æ̈ninque edæ bitö toquinque ingæ̈impa. Tömënäni wæætë ædö cæte adopo pönönäni ænguïmii. Edæ në nö cædäni näni ñäni ömæ̈monguïönæ ïinque bayonte edæ mönö Mæmpo Wængonguï incæ bitö ïmite adopo pönongä æncæbiimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Angä ëñëninque Itota tönö në cængongä adocanque tömengä ingante apæ̈necantapa. —Wængonguï Awënë Odeye pongä ate tömengä tönö godongämæ̈ në cængä ïñömö edæ tömengä nänö watapæ̈ toquinque cænguingä. ");
INSERT INTO aucNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Apæ̈necä ëñëninque Itota wæætë tömengä ingante odömoncæte ante apæ̈necantapa. —Waocä æ̈æ̈mæ̈no ante cædinque nanguï ïnäni ïnänite mäo apæ̈nedinque, Ïincayæ̈ ate ämo ate pö bete cæ̈edäni, ante cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Æ̈æ̈mæ̈no beyedë ïinque bayonte tömengä ingante në cæcä ingante äninque, “Ïïönæ æ̈æ̈mæ̈no ïinque cætimpa. Pöedäni,” ante bitö të të wente ænte pöe, ante da godongä. ");
INSERT INTO aucNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Godinque wente ængä ëñëninque do nänö në äñedïnäni wæætë, Ædö cæte ponguïmönii, ante tömänäni adoyömö wædänipa. Tänocä ïñömö, “Botö ömæ ante tæcæ godonte æ̈ninque botö acæ goquïmo inte botö æ̈æ̈mæ̈ becæ godämaï ïmopa. Incæte në wente æ̈ningä weca adodö gote bitö botö beyæ̈ apæ̈nebi ëñëninque tömengä wæætë botö ïmote pïïnämaï incæcäimpa,” angampa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wacä guiquënë, “Wagada onguïñæ̈na näna goti wïmencacaya näna goti wïmencacaya önompo æ̈mæmpoque ganca mänimpodäni ïnäni ïnänite godonte æ̈nïmo inte botö, Æbänö cædänii, ante acæ gocæ cæbopa. Ïninque botö æ̈æ̈mæ̈ becæ pönämaï ïmo incæte awënë ingante ämi botö ïmote pïïnämaï incæcäimpa,” angampa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wacä guiquënë, “Botö tæcæ mönïmo inte ædö cæte ponguïmoo,” angä. ");
INSERT INTO aucNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ëñëninque në cæcä ïñömö awënë weca adodö pöninque tömënäni näni cædönö ante tömää apæ̈necä ëñente wædinque në ëacä ïñömö ænguï badinque tömengä ingante në cæcä ingante, “Bitö mönö quëwëñömö wacä taadö wacä taadö ñæ̈næ̈nö incæ guiyänö incæ tömäo gote adinque në ömæpodäni ïnänite, në cömäïnäni ïnänite, në biyaate ïnäni ïnänite, në babetamönäni ïnänite adinque ænte pöe.” ");
INSERT INTO aucNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Angä ëñente cædinque në cæcä wæætë awënë ingante, “Awënë, bitö änïnö ante do cæbo incæte bitö oncö wïï eyede impa.” ");
INSERT INTO aucNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ante apæ̈necä ëñente wædinque awënë wæætë, “Önömæca ïñömö ñæ̈næ̈nö incæ guiyänö incæ gote diqui diqui minte wadäni ïnänite ate ämi pönäni ïninque botö oncö eyede ponte cæncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Edæ bitö ïmite ämopa, Wëënëñedë botö wente æ̈nïnäni incæ bedämaï incædänimpa,” ante në ëacä angampa. Mäninque ante apæ̈nebopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Itota tönö nanguï ïnäni godongämæ̈ godänitapa. Tömënäni ïnänite apæ̈necæte ante tömengä dadi ëmænte adinque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mïnitö ïñömö, Itota gämæ̈nö ponguïmo, ämïnitawo. Ïñæmpa botö weca pöninque waocä mæmpo tönö wäänä ïnate ante wædämaï incæcäimpa. Tömengä nänöogængä ingante ante wædämaï inte tömengä wëñæ̈näni tönö tömengä nänö tönïñadäni ïnänite ante wædämaï incæcäimpa. Mänimpodäni ïnänite pïinte baï pönëninque tömengä, Nämanque ante quëwencæboimpa, ante wædämaï inte pïinte baï pönëninque botö ïmote wæætë godömenque nanguï waadete pönenguënengä ingampa. Mänömaï ante pönënäni ïñömö tömënänique edæ botö mïñæ̈ në godäni badänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ayæ̈ botö mïñæ̈ poncæ cædinque waocä, Awæ̈ botö wænguïwæ̈, ante næ̈ænte ponte baï cædinque, Wæ̈nönäni wæ̈mo incæte Itota mïñæ̈ cöwë gocæboimpa, ante poncæcäimpa. Mänömaïnö ante wïï cæcä ïñömö tömengä ïñömö edæ botö në ëmïñængä ædö cæte baquingää. ");
INSERT INTO aucNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Æi gomö aquincö mæ̈noncæ cædinque bitö, Æpodö godonte æ̈ninque ïinque mæ̈nonguïmo. Botö eyepæ̈ mantawo, ante täno pönënämaï inte edæ ædö cæte mæ̈nonguïmii. ");
INSERT INTO aucNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Täno pönëë cönämaï ïmi ïninque bitö ongonto ontowæ̈ do näñe ñongæ̈ninque godömenque ænguï ante ömæpobi badinque ïinque edæ mæ̈nönämaï ïmaïmipa. Ayæ̈ edæ mæ̈nönämaï ïmi adinque godongämæ̈ ongönäni wæætë, ");
INSERT INTO aucNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Æ bitö mæ̈noncæ cædïmi incæ ïinque mæ̈nönämaï ïmipa töö,’ ante badete tobaïnänipa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ayæ̈, “Ïmæca awënë wabæca awënë ingante guëadö guëa pïinte cæcæte ante cædinque ædö cæte täno pönënämaï inte cæquingää. Ïïmaï pönente cæquënengä ingampa. Botö tontadoidi guiquënë diete mïido ganca ïñönänite wabæca awënë tömengä tontadoidi guiquënë bæinte mïido ganca ïnäni awædö. Tömengä tontadoidi nanguï ïnäni tönö pïincæte ante pöñongante botö æbänö cæte edæ wææ cæquïmoo, ante täno pönëë conguënë ingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ayæ̈, Botö ïñömö tæ̈ï pïñæ̈mo ïmopa diyæ̈ tömënäni ïnänite wido cæquïmoo, ante pönengä ïninque tömengä edæ wabæca awënë gobæ ongöñongante mäo wææ anguënengä ingampa. Edæ, Botö æbänö cæbo ate bitö wæætë piyæ̈në cæte ee ate gobi quëwëmoe, ante wææ anguënengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mïni cabo adobaï ïmïnipa. Mäincooque impa, ante godonte baï cædinque mïnitö tömancoo ëmö cædinque tömänäni ïnänite ëmö cædinque botö mïñæ̈ poncæmïnimpa. Ïñæmpa ëmö cædämaï ïmïni ïninque mïnitö botö në ëmïñæ̈mïni ædö cæte baquïmïnii,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ayæ̈ apæ̈nedinque Itota, “Cati quïmonte cæ̈ï ïñömö waëme inte gæpæ̈ ëmompa, angacäimpa. Incæte nongæ̈monte ba adinque mïnitö wæætë æbänö nö cæmïni wæætë gæpæ̈ ëmonguïï. ");
INSERT INTO aucNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ïñæmpa gönea inguipoga cati wäne cædäni ïninque tömëmö cati beyæ̈ pædämaï ingæ̈impa. Ayæ̈ wagada goi tönö wempodente wäne cædäni ïninque tömëmö cati beyæ̈ pædämaï ingæ̈impa. Ïninque edæ cati nongæ̈ ba ate wido cædänipa. Mänömaï apæ̈nebo ëñëninque ëamonca ongonte ëñëedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Odömäno awënë beyæ̈ në æ̈näni tönö Wængonguï ingante ëñënämaï inte në cædäni tönö tömänäni Itota apæ̈necä ëñencæte ante godongämæ̈ pönäni ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Adinque Paditeoidi tönö në odömönäni guiquënë Itota ingante ante pïïninque, —Ïingä ïñömö, Pöedäni, äninque në ëñënämaï cædäni tönö cæ̈ congä awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ante pïinte tededäni wædinque Itota, Wængonguï Awënë nempo quëwëninque æbänö cæquïï, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mïnitö ïñæmpa. Mïni waocabo ïñömïnite adobi ïñömö bitö obegaidi tiëë ganca ëabi ïñömi obega adocanque incæ wë womonte edæ dæ bacä ïninque bitö ïñömö æbänö cæbaïmii. Edæ nöobenta i nöebe ïnäni ayæ̈ ongoncoo ïnänite yabæque ëmö cæte godinque önömæca gote wë womöningä ingante bitö ædö cæte diqui diqui mïnämaï ïmii. Bitö aganca cöwë edæ diqui diqui mïmaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ayæ̈ diqui diqui minte ëadente ate, Ñöwo ëadëmopa, ante todinque önönancapæ̈ wo æ̈æntodöninque, ");
INSERT INTO aucNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","oncönë mongænte pöninque bitö guiidënäni tönö bitö æ̈migoidi tönö äñete pönäni ate, ‘Badogaa, botö wë womö wædö dobæ ëadente ï abopa. Edæ mönö watapæ̈ toquinque impa,’ ante në ëabi ïñömö ämaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Öönædë quëwënäni ïñömö adobaï cædänipa, ante apæ̈nebo ëñëedäni. Waodäni nöobenta i nöebe ganca ïnäni në nö cædönäni inte wë womönämaï inte ayæ̈ ongönäni adinque öönædë quëwënäni wædænque todänipa. Wæætë waocä adocanque incæ në womöningä ïñömö tömengä edæ wënæ wënæ nänö cædïnö ante wæwente pönëninque ñimpo cæte pongä adinque öönædë quëwënäni ïñömö godömenque watapæ̈ todänipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Godömenque apæ̈nedinque Itota odömongantapa. “Ayæ̈ wæætë onquiyængä tiguitamö diete ganca mäñongä adotamonque wë wodonte ba adinque, Ñäö gongængæ̈impa, ante tica wodönodinque tömengä oncö tömäo wadæ ñëmæ̈ wadæ ñëmæ̈ cæte diqui diqui minte ængampa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Do æ̈ninque tömengä guiidënäni tönö tömengä æ̈migoidi tönö äñete pöñönänite, ‘Botö wë womontamö wædö dobæ ëadente abopa. Mönö edæ watapæ̈ toquinque impa,’ angampa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ïninque mïnitö ïmïnite apæ̈nebopa. Adocanque incæ wënæ wënæ nänö cædïnö wæwente pönëninque ñimpo cædinque pongä adinque Wængonguï anquedoidi incæ watapæ̈ todänipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ayæ̈ godömenque apæ̈nedinque Itota, “Mæmpocä tömengä wëñæ̈na mënaa ïñönate, ");
INSERT INTO aucNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ayæ̈mengä ïñömö wæmpocä ingante apæ̈nedinque, ‘Mæmpo, bitö ëacoo incæ æ̈mæncooque pä cæte botö ænguënencooque pönömi æ̈moe.’ Angä Ao äninque wæmpocä pä cædinque wacä ingä pædæ wacä ingä pædæ godongä æ̈na. ");
INSERT INTO aucNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ate wantæ ate ayæ̈mengä ïñömö ænte næ̈ænte wabæca godinque quingämë baï önonque towente quëwëninque wæmpocä nänö pönönincoo incæ eye cæpote ba. ");
INSERT INTO aucNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ate mänïömæ cænguï dæ ba ate näni gæ̈wænte wæpämo pö ïninque tömengä mäincoo ænguënengä inte wæwengä. ");
INSERT INTO aucNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ïninque tömengä mänïñömö quëwengä weca gote äninque, Bitö ïmi në cæbo bacæboimpa, äñongante Ao äninque, Botö ömæ odæ̈ wængänäidi näni cæ̈mancadë gote në aabi bacæbiimpa, ante da godongä. ");
INSERT INTO aucNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gote aadinque tömengä gue æ̈nente ömædengä inte odæ̈ wængänäidi näni cæntapodë incæ cæ̈ïnente wæyongante cænguï dicæ pönönäniyaa.” ");
INSERT INTO aucNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ante wædinque tömengä nämanque pönëë cöninque, ‘Ïñæmpa botö wæmpo ingante në cædäni ïñömö önönänique incæ eyepæ̈ pönï cæ̈ñönäni botö ïñömö edæ gæ̈wænte wænguï wæ. ");
INSERT INTO aucNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Botö mæmpo weca edæ wadæ gocæboimpa. Gote pöninque botö tömengä ingante, Mæmpo ëñëmi. Öönædë quëwengä ingante botö godö ëñënämaï cædinque bitö ayömite pönö wënæ wënæ cæbo ïñömote, ");
INSERT INTO aucNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","bitö ñöwo edæ, Botö wëmi, ante ædö cæte anguïmii. Wæætë edæ, Bitö botö ïmote, Në cæbi bae, ämi ate botö bitö ïmite në cæbo bacæboimpa, ancæboimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ante pönëninque wadæ godinque wæmpocä weca gocantapa,” ante apæ̈nedinque Itota godömenque odömonte apæ̈necantapa. “Ayæ̈mengä mänömaï gote gobæ pönï dibæ pöñongante wæmpocä ïñömö gomö adinque ïñontobæ̈ pönö waadete wæcampa. Pogodo pönï godinque tömengä wengä ingante waa waadedinque bæi ongonte queë bemongampa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tömengä wengä ïñömö, ‘Mæmpo ëñëmi. Öönædë në quëwengä ingante botö godö ëñënämaï cædinque bitö ayömite pönö wënæ wënæ cæbo ïñömote bitö ñöwo edæ, Botö wëmi, ante ædö cæte anguïmii.’ ");
INSERT INTO aucNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ante tæcæ apæ̈neyongante mæmpocä ïñömö në cædäni ïnänite äninque, ‘Weocoo waëmoncoo quingæ̈ ö ænte mämö daga wëñaquïmïni. Önompo timpoï ænte pöninque godö da timpodinque awæncata ö ænte godö da wëwaedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ayæ̈ wagada wëñængä nanguï cænte oguïmo pönï ïnongä inte wæ̈nonte æ̈nömïni ate mönö cænte tocæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Edæ botö wengä ïñömö do wænte baï ïnongä incæte ñöwo mïingä pongä aedäni. Botö në wë womongä wædongä incæ edæ ñöwo dobæ ëadente tobopa.’ Ante wæmpocä angä ëñëninque æ̈æ̈mæ̈ cædinque nanguï todänitapa,” ante Itota godömenque odömonte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Æ̈æ̈mæ̈ cæte toyönäni bamoncadengä guiquënë gönea ayæ̈ cædongäimpa. Ïinque cæte ate obo ponte ëñëñongä ämotamïni ante äwadäni. ");
INSERT INTO aucNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ëñente wædinque në cæcä ingante äñecä pöñongante, Æbänö cædänii, ante wæcampa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Äñongante, ‘Bitö biwï incæ do pongä adinque bitö wæmpo, Botö wengä mïingä ëñadente tobopa, ante adinque wagada wengä oguïmo pönï ïnongä ingante do angä wæ̈nonte æ̈æ̈mæ̈ cæte todänipa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ante apæ̈necä ëñëninque bamoncadengä ïñömö edæ ænguï badinque oncönë guiidämaï, Baa angä. Wædinque wæmpocä ïñömö oncodo taodinque tömengä ingante waadete apæ̈nedinque, Oncönë pö guiie, angampa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bamoncadengä wæætë, ‘Ïñæmpa bitö beyæ̈ ante wadepo ïñö wadepo ïñö botö ancaa cædinque bitö änö tömänö ante do cæbo ïñömote bitö wæætë, Bitö æ̈migoidi tönö cænte tocæmïnimpa, ante dicæ ämiyaa. Caboda wengä incæ dicæ pönömi æ̈mogaa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wæætë mäningä bitö wengä guiquënë onquiyæ̈näni mäincoo beyæ̈ ante në towente quëwënäni tönö quëwëninque bitö ëadincoo incæ në ëwënengä inte pongä adinque bitö wæætë wagada wë oguïmo pönï ïnongä incæ mäningä beyæ̈ do wæ̈nömipa, ante awædö,’ angantapa.” ");
INSERT INTO aucNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ante pïïñongante wæmpocä, ‘Botö wëmi ëñëmi. Bitö ïñömö cöwë edæ botö weca ongömi ïmipa. Botö mäincoo ïnï edæ bitö mäincoo cöwë impa. ");
INSERT INTO aucNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Incæte mäningä bitö biwï, Do wæ̈maï ingampa, ante mönö në pönënongä inte ñöwo mïingä ingä pongä ae. Në wë womöningä ingante do ëadente ate edæ æ̈æ̈mæ̈ cæte toquënë ïnimpa,’ ante bamoncadengä ingante mæmpocä angampa.” Mäninque ante apæ̈nebopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Itota tömengä mïñæ̈ në godäni ïnänite godömenque apæ̈nedinque, “Waocä adocanque mäincoo nanguï ëacä ïñongante wadäni, Bitö mäincoo në aaquënengä incæ önonque pönï wido cæcä ae. ");
INSERT INTO aucNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Änäni ëñëninque në ëacä ïñömö në aaquënengä ingante äñecä pongä ate ïïmaï angampa. ‘Bitö quïmæ̈ cæbii, ante adinque tededäni edæ ëñëmopa. Ñöwo idæwaa botö mäincoo inte në aadïmi inte edæ abæ tawæ̈ gocæbiimpa. Ämo ate ëñente wædinque bitö botö mäincoo ïnï ante edæ, Æbänö aadinque cæboo,’ ante apæ̈nebi ëñëmoe.” ");
INSERT INTO aucNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ante pïinte angä ëñente wædinque në aadingä ïñömö nämäneque tededinque, ‘Botö awënë, Gobäwe, angä ëñëninque botö abæ tawænte gote awædö. Botö cæte ænguënenta ñöwo æ̈nämaï ïninque æbänö cæte ænte quëwenguïmo. Botö, Wadäni beyæ̈ onguipoi æ̈æ̈ wobo ate pönönäni ænte quëwencæboimpa, ante pönëmo baï edæ tæ̈ï pïñæ̈mopa diyæ̈ æ̈æ̈ woquïmoo. Ayæ̈, Önonque pönömïni æ̈moedäni, ante ædö cæte anguïmoo. Guïñënete awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Æ. Tæcæ pönëmopa. Botö awënë angä botö abæ tawænte goyömote wadäni wæætë, Botö oncönë pö guiie, ancædänimpa, ante cædinque botö ñöwo ïïmaï cæcæboimpa,’ ante ïïmaï cæcampa,” ante apæ̈nedinque Itota godömenque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Wadäni ïñömö ïingä awënë pönongä æ̈ninque adodö pönönämaï ïnäni inte debe ïnönänimpa. Ïïnäni ïnänite adocanque adocanque tömänäni ïnänite angä pöñönänite në aadingä ïñömö täno pöningä ingante apæ̈nedinque, ‘Botö awënë ingante bitö ayæ̈ æpodö pönönämaï ïmii.’ ");
INSERT INTO aucNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Äñongante, ‘Oguinguipæ̈ incæ botö tiëë ganca tanquebo encadedë awënë ingante pönönämaï inte debe ïmopa.’ Ante apæ̈necä ëñëninque ‘Mänimpocadedë debe ïmipa,’ ante awënë nänö yewæ̈möninta pædæ godöninque në aadingä ïñömö, ‘Bado, bitö ïinta ænte pönömenque ante yewæ̈möninque edæ, Botö tincoenta ganca encadedë debe ïmopa, ante edæ quingæ̈ tæ̈ contate yewæ̈möe,’ angä ëñente cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ayæ̈ pöningä ingante në aadingä angantapa. ‘Bitö guiquënë æpodö pönönämaï ïmii.’ Äñongante, ‘Todigo incæ tee manguincade ñæ̈nængade pönï tiëë ganca encadedë botö debe ïmopa.’ Ante apæ̈necä ëñëninque awënë nänö yewæ̈möninta pædæ godinque në aadingä, ‘Bado bitö ïinta ænte pönömenque ante yewæ̈möninque, Otenta ganca debe ïmopa, ante yewæ̈möe,’ angä cæcampa.” ");
INSERT INTO aucNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ïninque në aaquënengä mänömaï önonque wïwa cæcä wædinque awënë tömengä ingante, Bitö ocai nanguï encabi inte nämanque ante pönëwëninque cæbitapa, angampa, ante Itota në aaquënengä ingante ante mäninque apæ̈necantapa. Ayæ̈ godongämæ̈ ongönäni ïnänite godömenque apæ̈nedinque, Inguipogaque ante quëwënäni ïñömö näni caboque nanguï ëñente cæyönäni botö ñäö ïñömö në quëwënäni näni cabo guiquënë wïï nanguï ëñente cædänipa,” ante Itota odömoncæte ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ayæ̈, “Mïnitö ïmïnite ñöwo ämo ëñëedäni. Mäningä në aacä ocai encate cæcä baï mïnitö ïñömö adobaï inguipogaque wïwa cæcæte ante näni godonte æ̈inta mämïni ïninque ocai encate töingä pönente cæedäni. Inguipoga ïinque bayedë mäninta ïñömö edæ dæ bacæ̈impa, ante pönente wædinque, wadäni beyænque ante godö waa cæedäni. Mänömaï cæmïni ïninque mïnitö ömæpomïni inte öönædë näni cöwë wantæpiyæ̈ quëwencönë æite godinque pöñömïnite, Oncönë pöedäni, ämaïnänipa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ayæ̈, “Waocä mäincoo wædænque pönï æ̈ninque ædæmö aacä ïninque tömengä wæætë nanguï mäincoo æ̈ninque adobaï ædæmö aaquingä ingampa. Wæætë edæ mäincoo wædænque pönï aaquënengä incæ babæ cæcä ïninque tömengä wæætë nanguï æ̈ninque cöwë babæ cæquingä ïmaingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ïninque mäincooque ante mïni wædoncoo æ̈ninque mïnitö ædæmö aadämaï ïmïni adinque mïnitö ïmïnite, Wo ëwënämaincoo aacæbiimpa, ante dicæ pönönäni ænguïmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ayæ̈ wacä mïnitö ïmïnite, Botö quï ædæmö aaedäni, ante pönongä æ̈nïmïni inte mïnitö ædæmö aadämaï ïmïni adinque, Tömëmïni quï, ante mïnitö ïmïnite pönönämaï incædänimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ante apæ̈nedinque Itota godömenque apæ̈necantapa. “Mënaa awënëna ïna beyæ̈ waocä ædö cæte cæquingää. Adocanque awënë ingante pïïninque wacä ingante waadebaingampa. Wæætë adocanque mïñæ̈ godinque wacä ingante wïï waa abaingampa. Mïnitö adobaï ïmïni inte Wængonguï ingante në cæmïni ïninque mäincooque ante ædö cæte cæquïmïnii,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Itota apæ̈necä ëñëninque Paditeoidi guiquënë mäincooque ante në wæwënäni ïnönäni inte, Quïmæ̈ änewëë, ante badete togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Adinque Itota wæætë tömënäni ïnänite, “Mïnitö ïñæmpa, Mönitö ïmönite adinque waodäni, Në nö cædäni ïnänipa, ante pönencædänimpa, ante në babæ cæmïni ïmïnipa. Incæte Wængonguï mïnitö mïmönë mïni entawënö ante edæ do acampa. Waodäni näni waa adö ante Wængonguï wæætë, Wentamö pönï ï awædö, ante pïingampa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Äninque Itota, “Wëënëñedë ïñömö Wäö nänö ponganca dodäni Möitee wodi nänö wææ angaïnö ante ayæ̈ Wængonguï beyæ̈ në apæ̈nedäni näni angaïnö ante apæ̈nete quëwengadänimpa. Ñöwo guiquënë, Wængonguï Awënë Odeye nempo guiite quëwengæ̈impa, ante watapæ̈ apæ̈nete impa. Ïïne ante ëñëninque tömänäni Awënë nempo guiicæte ante edæ pæ pagænte cædinque da godö guiidänipa,” ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ayæ̈ apæ̈nedinque, “Incæte öönæ tönö inguipo æ̈mæ̈wo edæ dæ näni baganca edæ Wængonguï nänö wææ angaïnö ïñömö edæ cöwë mæ̈ ongongæ̈impa. Mänïne ante yewæ̈möninque dodäni näni tæ̈noncagaï ïñömö edæ guiyä pönï incæ cöwë wadæ cædämaï ingæ̈impa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ayæ̈ godömenque apæ̈nedinque Itota, “Æcänö näwä nänöogængä ingante pämæ̈ninque wacä onquiyængä ingante godö möna ïñömö tömengä edæ wïwa towengä do bacampa. Adobaï, tömengä nänöogængä ïningä ïñongante wacä möninque edæ do towente bacampa,” ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Godömenque odömonte apæ̈necæte ante Itota ïïmaï ante apæ̈negacäimpa. “Onguïñængä adocanque në ëacä inte cæncadencoo waëmoncoo wëñadinque awënëidi näni opatawæ̈ ëmoncoo baï yabæque wëñadongäimpa. Tömengä tæcæ wodi ïnongä inte waëme cænguincooque æ̈ninque ïïmö ïñö ïïmö ïñö æ̈æ̈mæ̈ cædinque nanguï todinque quëwënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tæcæ wodi yabædemö ïnö wacä tömengä ëmöwo Datado ingante ænte mämö ñö cædäni ñongængantapa. Ïingä ïñömö, Pönömi æ̈moe, Pönömi æ̈moe, ante në änewënongä inte quëmoncoo tömäo baate wædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ayæ̈ tæcæ wodi weca cæ̈ninque eyepodäni wæænte öñoncoo adinque tömengä ænte cæncæte ante wæwënongäimpa. Ayæ̈ edæ tömengä nanguï baate ñömænte wæyongä guintaidi incæ pö yædæ yædæ beyadönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tömengä në, Pönömi æ̈moe, Pönömi æ̈moe, ante änewënongä inte näñe wængä adinque Wængonguï anquedoidi tömengä önöwoca ingante Abadäö wodi weca ænte mæ̈idäni æicantapa. Ayæ̈ ate tæcæ wodi adobaï näñe wængä adinque tömengä baö ïnï daga wënänitapa.” ");
INSERT INTO aucNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ante apæ̈nedinque Itota tæcæ wodi ingante ante godömenque apæ̈necantapa. “Tömengä önöwoca guidömëmö taadö wææ̈ gote mæ̈ mämonte baï ïñömö ongöninque nanguï ämogate wæwënongä inte gomö ayongä Abadäö wodi a ongongä acantapa. Datado wodi adobaï Abadäö wodi weca a ongongä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Adinque tæcæ wodi ïñömö Abadäö ingante aa pedinque, ‘Mæmpo Abadäö ëñëmi. Botö gonga bæcoyömö guiite nanguï ämogate wæwëmo cæbii. Botö ämogate wædö ante pönö waadete waa cædinque bitö Datado ingante da pönömi pöninque tömengä æpæ̈ ada ipomencacä botö cöñe bamencaboe.’ ");
INSERT INTO aucNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Äñongante Abadäö, ‘Botö wëmi, Datado ïmæcayedë wënæ wënæ ämogate wæwëñongante bitö mäincoo waëmoncooque ænte todinque quëwënömiimpa. Ñöwo diyæ̈ bitö ämogate wæwëñömite Datado ingante wæætë ædæmö cæbo ate wampo pönëninque tömengä ñöwo ïñömö watapæ̈ quëwente tocampa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ayæ̈ godömenque ämo ëñëe. Nänënë ï apa änewëë. Botö weca ongongä inte ædö cæte bitö weca goquingää. Wæætë bitö weca ongongä inte botö weca ædö cæte ponguingää. Guiibæ pönï ïñömö taadö impa taquïï. Edæ dæ ampa,’ ante Abadäö wodi angampa, angantapa.” ");
INSERT INTO aucNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Angä ëñente wædinque tæcæ wodi wæætë, ‘Mæmpo Abadäö ëñëmi. Datado ingante ämi ëñente tömengä botö mæmpo oncönë adodö gocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mänïñömö botö tönïñadäni önompo æ̈mæmpoque ganca mänimpodäni ïnänipa. Ïninque bitö Datado ingante ämi tömënäni weca gote, Wæ̈nompadäni, ante wææ angä ëñëninque tömënäni wæætë ïñömö nanguï pönï ämogate wæwëñömö pönämaï incædänimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Äñongante Abadäö wæætë, ‘Möitee wodi nänö wææ ante yewæ̈mongainta Wængonguï beyæ̈ në apæ̈nedäni näni yewæ̈mongainta do mänäni inte edæ bitö tönïñadäni ïñömö mäninta adinque, Æbänö ï, ante do ëñenguënënäni ïnänipa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ante apæ̈neyongä tæcæ wodi wæætë, ‘Ïñæmpa mæmpo Abadäö ëñëmi. Wacä në wængaingä inte ñäni ömæ̈monte tömënäni weca gote apæ̈necä ëñëninque botö tönïñadäni tömënäni wënæ wënæ cædïnö ante wæwente pönëninque do edæ ñimpo cæbaïnänipa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ante wæyongante, ‘Ïñæmpa Möitee wodi nänö wææ angaïnö ante Wængonguï beyæ̈ näni apæ̈negaïnö ante ëñënämaï ïnäni inte tömënäni në wænte ñäni ömæ̈möningä apæ̈neyongante cöwë ëñënämaï ïmaïnänipa,’ ante Abadäö wodi angantapa.” Tæcæ wodi ingante ante apæ̈nedinque Itota mäninque ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ayæ̈ tömengä mïñæ̈ në godäni ïnänite apæ̈nedinque Itota, “Në pönënäni incæ pancadäniya wïï ëñente do oda cædänipa. Cöwë mänömaï impa. Incæte, Oda cæcæcäimpa, ante në cæcä ïñömö edæ tömengä nanguï nänö caate wæquinque cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ïninque edæ, Wëñængä adocanque guiyangä pönï incæ oda cæcæcäimpa, ante në godö cæcæ cædingä ïñömö edæ, Wïï cæcæcäimpa, ante mönö edæ wææ cæcæ̈impa. Waodäni näni dacæ godö dacæ godö cæquinca ñæ̈nænca æ̈ninque në godö cæcæ cæcä önömenca æ wëmencadinque tömengä ingante tæcætibæ wido cædäni ïninque tömengä edæ, Wënæ wënæ cædämaï inte wæ̈mo beyænque Wængonguï botö ïmote pänämaï ingampa, ante tömengä waa toquënengä ïmaingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mänömaï ämo ëñëmïni inte mïnitö, Oda cæcæcäimpa, ante në cæcä baï cædämaï incæboimpa, ante edæ nämä wææ aedäni,” äninque Itota ïïmaï apæ̈necantapa. “Wacä wënæ wënæ cæcä adinque bitö wæætë tömengä ingante, Cædämaï incæbiimpa, ante wææ äe. Ämi ëñëninque tömengä wënæ wënæ nänö cædïnö beyæ̈ guingo imonte wædinque, Wïwa cætabopa, ante apæ̈necä ëñëninque bitö wæætë piyæ̈në cædinque tömengä ingante ñimpo cæbi ee gocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tömengä wæætë adoönæque ïñonte önompo æ̈mæmpoque go mempoga mänimpoga bitö ïmite wïwa cædingä inte tömengä guingo imöninque, ‘Bitö ïmite wïwa cætabopa,’ ante adopoga apæ̈necä ëñëninque bitö wæætë tömengä ingante adopoga ñimpo cæbi ee gocæcäimpa,” ante Itota angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mönö Awënë tömengä nänö në da godönïnäni ïñömö tömengä ingante äninque, —Wædænque pönëmöni ïñömönite bitö pönö cæbi æ̈ninque mönitö ædæmö wede pönëmöni bacæmönimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Änäni ëñëninque mönö Awënë wæætë, —Möotatamö guiyämö pönï nänö inganca mïnitö pönënö mäninganca wædænque pönëmïnitawo. Mäningancaque pönëmïni incæte mïnitö möodedawæ̈ näni äwæ̈ inte apæ̈nedinque, “Awæ̈ ëñëmi. Bitö bæ wite godö gäwapæ̈ minte pæbäwe,” ante ämïni baï awæ̈ incæ dobæ edæ ëñente cæcædönimpa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ayæ̈ godömenque apæ̈nedinque, “Mïni waocabo ïñömïnite adobi në ëabi ïmi ïninque bitö ïmite në cæcä ingante edæ æbänö cæbaïmii. Tömengä gönea mangæ̈ mangæ̈ wodinque ayæ̈ cæ̈nïnäni ïnänite ïinque aadinque pö guiicä adinque bitö ïñömö edæ, ‘Pö tæ̈ contate cæ̈e,’ ante edæ dicæ ämiyaa. Edæ në ëacä ingampa diyæ̈ täno cænguingää. ");
INSERT INTO aucNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wæætë në ëabi ïnömi inte bitö, ‘Botö beyæ̈ cænguï æ̈nöninque bitö weocoo topo cædinque pönömi æ̈ninque botö cænte bebo ate bitö mänïñedë ate edæ cænte becæbiimpa,’ ante cöwë ämaïmipa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ayæ̈, Cæe, ante bitö änïnö ante tömengä ëñente cæcä beyænque bitö, Waa cæbi æ̈mopa, ante dicæ anguïmii. ");
INSERT INTO aucNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ïninque mönö Awënë, Cæedäni, ante nänö angaïnö ante eyepæ̈ pönï cædinque mïnitö adobaï ante pönenguënëmïni ïmïnipa. ‘Mönitö në cæmönique inte önömönique ïnömöni inte wënæ wënæ cæte awædö. Mönitö tömengä nänö änonque mäninque cæte ate tömengä beyæ̈ ante dicæ godömenque nanguï cæmöniyaa,’ ante pönente wæquënëmïni ïmïnipa,” ante Itota tömengä mïñæ̈ në godäni ïnänite apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mänïï Eedotadëë ïñömö gocæte ante godinque Itota Tämadiabæ æ̈mætæ̈ Gadideabæ æ̈mætæ̈ tæcæguedë pönï godinque, ");
INSERT INTO aucNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","waodäni näni quëwëñömö tæcæ pöñongä në baate wædäni önompo tipæmpoga ïnäni pö bee tënänitapa. Pö gobæ næ̈ gongæ̈ninque pömö adinque, ");
INSERT INTO aucNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aa pedänitapa. —Itota në Awënë ïnömi inte ëñëmi. Mönitö wædö ante pönö waadete waa cæe, ämönipa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Äñönänite gomö adinque Itota, —Mïnitö guiquënë Wængonguï oncönë godinque, Wængonguï quï, ante në godönäni ïnänite mïnitö æ̈montai mäo odömömïni acædänimpa. Angä ëñente tömënäni idömæ godinque ïñontobæ̈ waintai baagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ïninque adocanque watapæ̈ todinque, Wængonguï bitö ñäö apäite baï ïnömi inte edæ waa cæbi æ̈mopa, ante yedæ apæ̈nedinque adodö pongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tömengä ïñömö wabæca Tämadiabæ në quëwëningä incæ pö Itota önöwa ïnö guidömëmæ̈ ñongæ̈ninque waa ate pönëninque, Bitö pönö cæbi ate waintai baabopa, ante apæ̈necä. ");
INSERT INTO aucNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ëñëninque Itota wæætë angantapa. —Ïñæmpa mïni cabo önompo tipæmpoga mänimpomïni ïnömïni inte edæ wïï tömämïni waintai baamïnitawo. Ïninque wadäni önompo æ̈mæmpoque go mënaa go mënaa ïnäni ïñömö edæ ædönö gote dæ änänii. ");
INSERT INTO aucNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ïingä ïñömö wabæca quëwëningä incæ adocanque Wængonguï ingante waa pönï apæ̈necæte ante ponte quëwëñongä wadäni guiquënë tömänäni pönämaï ïnänitawo. ");
INSERT INTO aucNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Äninque Itota tömengä ingante, —Bitö wede pönënö beyænque waintai baadïmi inte ængæ̈ gantite goe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Paditeoidi Itota ingante, Wængonguï Awënë æyedënö ponte Awënë Odeye baquingää, ante wæyönänite tömengä wæætë, Ïñæmpa wïï waomïni ayömïni Wængonguï Awënë Odeye pongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ïninque, “Tömengä ïñömö ponte ongongampa,” ante ayæ̈ wæætë, “Tömengä wayömö gote ongongampa,” ante edæ ædö cæte anguïï. Mïnitö weca në quëwengä incæ Awënë Odeye bayongante waodäni tömengä nempo do quëwënäni apa änewëmïnii, ante Paditeoidi ïnänite angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ayæ̈ tömënäni ïnänite ïinque apæ̈nedinque Itota tömengä nänö në ëmïñæ̈näni ïnänite wæætë apæ̈necantapa. —Ïincayæ̈ ate mïnitö, Waocä në ëñagaingä ingante adoönæque incæ aïnëmönipa, ante wæcæmïnimpa. Wæmïni incæte adämaï incæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wadäni mïnitö ïmïnite, “Ïñömö ongongä tamëñedäni,” äninque ayæ̈, “Wayömö ongongä tamëñedäni,” äñönäni mïnitö acæ godämaï ïedäni. Tömënäni mïñæ̈ edæ godämaï ïmäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Botö ponguïönæ ïinque bayonte botö ïñömö edæ Waobo në ëñagaïmo inte edæ ñäö æ̈matæ̈ æ̈matæ̈ näinte baï ëmöninque edæ edonque pönï ponte a ongoncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Incæte botö ñöwo guiquënë täno nanguï ämogate wæwencæboimpa. Ayæ̈ ñöwodäni ïñömö botö ïmote edæ Baa äninque wido cæcædänimpa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Botö Waobo në ëñagaïmo inte botö ponguïönæ ïinque bayedë guiquënë Nöwee wodi Docä näni angaingä nänö quëwëñedë dodäni näni quëwengaï baï adobaï edæ quëwenguïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Docä Nöwee wodi ñæ̈næ̈ wipoboga oncö baï mæ̈nöninque tömengä nänö guiiganca tömënäni önonque cænte bete monte quëwengadänimpa. Monguïna, ante ñänonte quëwengadänimpa. Mänïñedë edæ tömënäni näni capo bedö wænguinque edæ æpæ̈ do angatimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Dooto wodi nänö quëwengaïñedë dodäni adobaï cænte bete quëwengadänimpa. Në mänäni godongadänimpa. Æ̈ïnënäni wæætë godonte ængadänimpa. Minte pæcæ̈impa, ante cædinque onconcoo mæ̈nonte quëwengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Incæte Dooto wodi Todömä ïñömö quëwente nänö tao gogaïönæ ïñonte gonga tönö atopodemö nanguï ocoi bæcomö cöönæ cæ baï wææ̈ninque mäo bæco ïninque mänïñömö quëwënäni tömänäni gonte wængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Botö Waobo ëñagaïmo inte edonque botö a ongöñedë mänïnö näni bæco gonte wængaï baï adobaï bacæ̈impa, ante ämo ëñëmaïmïnipa,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ayæ̈ godömenque apæ̈nedinque, “Mänïönæ ïñonte mïnitö oncömanca ongöninque, Botö mäincoo, ante oncönë wæi guiidinque æ̈nämaï inte wodii wïnömäewedäni. Ayæ̈ gönea cædinque mäincoo ante oncönë ocæ̈ ëmænte æncæ pönämaï ïmäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ïñæmpa, Dooto nänöogængä wodi æbänö dadi ëmænte adinque edæ gonte wængacäï, ante pönëmïniyaa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Inguipogaque cöwë quëwencæboimpa, ante në pönengä ïñömö tömengä ïñömö edæ quëwënämaï incæcäimpa. Wæætë edæ inguipoga mönö guëmante quëwenguïmämo ante në wædämaï ingä guiquënë tömengä ïñömö edæ cöwë wæ̈nämaï quëwencæcäimpa, ante ämo ëñëmaïmïnipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ayæ̈, “Mänïñedë woyowotæ̈ ï ïninque mënaa äñömonque öñöna adocanque ingante bæi ongonte goyönäni adocanque ingante ëmö cæte godäni a ongoncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ayæ̈ onquiyæ̈na cænguï ante guëa dicaca dacæ dacæ cæte godö wëñöna adocanque ingante bæi ongonte goyönäni adocanque ingante ëmö cæte godäni a ongoncæcäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“Ayæ̈ onguïñæ̈na gönea guëa cæyöna adocanque ingante bæi ongonte goyönäni adocanque ëmö cæte godäni a ongoncæcäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ante apæ̈necä ëñente wædinque tömënäni wæætë, —Awënë, bitö änö æyömönö incæ mänömaï baquïï. Äñönänite, —Baö æyömömë wænte öñöñömonte abadæidi wë ongonte edæ do godongämæ̈ pönäni baï waodäni, Mönitö Awënë pongampa, ante do ëñëninque godongämæ̈ poncædänimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ayæ̈ tömengä mïñæ̈ në godäni cöwë Wængonguï ingante apæ̈nedinque wæntæte badämaï incædänimpa, ante cædinque Itota inguipoga quëwënäni näni cæïnö ante odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Wayömö näni quëwëñömö adocanque waodäni näni në apænte änongä inte quëwënongäimpa. Wængonguï ingante guïñënämaï ïnongä inte tömengä ïñömö, Waodäni æbänö änänii, ante wædämaï ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Adoyömö tömënäni quëwëñömö onquiyængä adocanque owæmpoingä inte në wædongä inte quëwënongäimpa. Tömengä guiquënë mäningä në apænte adongä weca wæætë wæætë pöninque, Botö ïmote adocanque në pïingä ïñongante bitö ämi ëñente wæætë nö cæcæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ante ancaa pöninque änä ëñente wædinque në apænte änongä ïñömö edæ cöwë Baa Baa angä. Incæte ayæ̈ ate nämäneque tededinque tömengä, ‘Onquiyængä ïñömö ancaa angä awædö, äninque, Wængonguï ingante guïñënämaï ïmo inte botö, Waodäni æbänö änänii, ante wædämaï ïmo incæte, ");
INSERT INTO aucNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mäningä owæmpoingä pö pö cæcä wædinque botö, Ancaa ponte angä wæcæ wæ, ante wæætë tömengä ingante waa cæcæboimpa. Tömengä ingante në pïingä ingante botö, Nö cæe, ante wææ ämo wæcæcäimpa.’ Äninque në Baa äningä incæte owæmpoingä beyæ̈ do waa cæcampa. Mäninque ante odömömopa.” ");
INSERT INTO aucNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ante odömonte apæ̈nedinque mönö Awënë ïñömö godömenque apæ̈necantapa. “Në apænte angä ïñömö wïwa cæcä incæte, Tömengä æbänö apæ̈necää, ante mïnitö ëñente pönëmäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wængonguï nänö në apænte ængaïmïni inte mïnitö itædë woyowotæ̈ wæætë wæætë aa pe aa pe cæyömïni Wængonguï edæ ædö cæte Baa anguingää. Wææ ämi ate nö cæcædänimpa, ante äñömïnite tömengä ïñömö edæ, Ïincayæ̈ ate cæcæboimpa, ante ædö cæte anguingää. ");
INSERT INTO aucNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wæætë quingæ̈ edæ do cæcæcäimpa. Në pïinte cædïnäni ïñönänite Wængonguï wææ angä ate tömënäni mïnitö ïmïnite wæætë nö cæcædänimpa, ante ämo ëñëmaïmïnipa. Incæte Wao Wëmo ëñagaïmo inte botö ponte ayömo wede pönënäni wabänö inguipoga mæ̈ ongönäni aquïmoo, ante wæbopa,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ayæ̈ pancadäniya, Wadäni önönänique ïñönäni mönonque nö cæmö ïmompa, ante pönëwëninque wadäni ïnänite pïinte adänipa. Mänömaïnö ante në änewënäni ïnänite Itota, Wængonguï ingante æbänö apæ̈nequïï, ante ëñencædänimpa, ante ïmæca quëwëna näna apæ̈neïnö ante odömöninque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Waoda mënaa Paditeo tönö odömäno awënë beyæ̈ në æ̈wengä ïñömö Wængonguï ingante apæ̈necæte ante Wængonguï oncö ñæ̈næncö yabæcönë æi guiidatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Paditeo ïñömö adiyæ̈ gongæ̈ninque nämä incæ apæ̈nedinque, ‘Wængonguï ëñëmi. Wadäni baï wïï ïmopa. Botö ïñömö godömenque waëmö ïmopa, ante todinque botö mänömaï beyæ̈ bitö ïmite waa ate apæ̈nebopa, änewengampa. Edæ wadäni guiquënë wacä quï ö æ̈nänipa. Wadäni ïnänite wïwa cædänipa. Tömënäni nänöogængä ïnämaï ïñongante godö guëa mönänipa. Botö ïñömö mänïnäni baï ïnämaï ïnömo inte botö mänïñömö ongongä odömäno awënë beyæ̈ në æ̈wengä baï wïï ïmopa, ante adinque botö Wængonguï bitö ïmite waa ate pönëninque apæ̈nebopa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Botö ïñömö, mëönaa go mëönaa ïñonte, mëönaa go mëönaa ïñonte bitö ïmite apæ̈necæte ante cæ̈nämaï quëwëmopa. Ayæ̈ botö æ̈nincoo tömancoo ate adinque botö önompo tipæmpoga mänimpocoo mæ̈ ongöñoncoo adocooque æ̈ninque, Wængonguï quï, ante cöwë pædæ pönömo ae,’ ante apæ̈newengampa.” ");
INSERT INTO aucNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Odömäno awënë beyæ̈ në æ̈nongä guiquënë guingo imöninque nämä tæi tæi yatawëninque, ‘Wængonguï ëñëmi, botö në wïwa cæbo adinque bitö waadete pönö pïïnämaï incæbiimpa, ämopa,’ angä. Mäninque angampa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mänömaïnö ante odömoncæte ante apæ̈nedinque Itota, Ñöwo ämo ëñëedäni, angantapa. Ïingä awënë beyæ̈ në æ̈wengä mänömaï äñongante Wængonguï do, Botö ayömo bitö nö cæbi babipa, ante godö badongä ate tömengä edæ nö pönënongä inte tömengä oncönë gocampa. Wæætë Paditeo, Nämanque waëmö ïmopa, ante në änewëningä ingante Wængonguï, Nö cæbi bacæbiimpa, ante godö badönämaï incæcäimpa, ante ämo ëñëmaïmïnipa. Edæ, Nämanque waa cæbo ïmopa, ante në ængö cæcä guiquënë edæ wææntodonte baï inte wæcæcäimpa. Wæætë, Nämanque wënæ wënæ cæbo ïmopa, ante në apæ̈necä guiquënë edæ ængö cæte baï inte tocæcäimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ayæ̈ ate wadäni, Wëñæ̈näni ïnänite Itota pönö gampo cæcadinque waa apæ̈necæcäimpa, ante cædinque tömengä weca guiyänäni ïnänite ænte pö ænte pö cædäni adinque tömengä mïñæ̈ në godäni guiquënë, Ænte pönämaï ïedäni, ante Baa änäni. ");
INSERT INTO aucNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Adinque Itota wæætë wëñæ̈näni ïnänite aa pecä pöñönäni tömengä mïñæ̈ në godäni ïnänite apæ̈necantapa. —Wëñæ̈näni ïnänite botö weca ee amïni poncædänimpa. Ïñæmpa mänïnäni näni pönënö baï adobaï pönënäni inte edæ Wængonguï Awënë Odeye nempo do quëwënäni ïnänipa. Ïninque mïnitö ïñömö wëñæ̈näni ïnänite Baa änämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Edæ näwangä apæ̈nebo ëñëedäni. Wëñængä do pönengä inte Ao angä ingä baï Wængonguï Awënë Odeye ingante do pönëninque në Ao änäni ïñömö tömënänique tömengä nempo guiidinque quëwënänipa. Wadäni guiquënë Wængonguï Awënë Odeye ingante Baa ante pönënämaï ïnäni guiquënë tömënäni ædö cæte tömengä nempo guiidinque quëwenguïnänii, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mänïñedë Itota ingante wacä awënë angantapa. —Awënë në waa Odömömi apæ̈nebi ëñëmoe. Botö æbänö cædinque wæ̈nämaï wantæpiyæ̈ quëwëmaïmoo. ");
INSERT INTO aucNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Äñongante Itota tömengä ingante, —Wængonguï adocanque në waa cæcä ïñongante bitö botö ïmote, Në waa cæbi ïmipa, ämii. ");
INSERT INTO aucNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Äninque Itota godömenque apæ̈necantapa. Ïïmaï cæedäni, ante Wængonguï nänö wææ angaïnö ante bitö tömëmi edæ do ëñëmipa. “Bitö nänöogængä ïnämaï ïñongante bitö godö guëa mönämaï ïe. Wacä ingante godö wæ̈nönämaï ïe. Wacä quï adinque awëmö æ̈nämaï ïe. Wacä wënæ wënæ cæcä atabopa, ante godö babæ wapiticæ̈ änämaï ïe. Wæmpocä ingante wäänä ïnante waa adinque tömëna ïnate godö waadete cæe,” ante wææ yewæ̈mongacäimpa, ante bitö edæ do ëñëmipa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ante apæ̈necä ëñëninque mäningä awënë wæætë, —Botö mänïnö bitö änö baï tömänö ante ëñente cædinque pægaboï ae. ");
INSERT INTO aucNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ante apæ̈necä ëñëninque Itota wæætë, —Adodeque ayæ̈ ëñente cæquënëmi ïmipa, ante ämo ëñëe. Öönædë bitö waëmoncoo ænguinque edæ ïmæca bitö mänincoo tömancoo godonte æ̈ninque bitö æ̈ninta wæætë ömæpodäni inte wædäni ïnänite tömanta godömi æncædänimpa. Ayæ̈ edæ botö ïmote tee empote pöe. ");
INSERT INTO aucNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Angä ëñente wædinque tömengä mäincoo nanguï ëadongä inte mänincoo beyænque ante pönëninque mäningä awënë ïñömö wæwente bacantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ïninque Itota tömengä ingante gomö adinque, —Wængonguï Awënë Odeye nempo guiite quëwencæte ante cædinque waodäni ömæpodäni inte botö mïñæ̈ pönänipa. Mäincoo nanguï ëacä guiquënë æbänö cæte ömæpocä inte botö mïñæ̈ ponte guiite quëwenguingää, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Cämeyo ïñömö guiyangä ingampa diyæ̈ daagö guiyampite pædæ tacää. Ïninque cämeyo pædæ tadämaï ingä baï në ëacä ïñömö adobaï ingampa. Tömengä nämä ayongä ñæ̈nængä ïnongä inte edæ æbänö cæte Wængonguï Awënë Odeye nempo do wäänë guiite quëwenguingää. ");
INSERT INTO aucNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mänömaïnö ante Itota apæ̈necä ëñëninque në ëñënäni wæætë, —Ïñæmpa mänömaï ï ïninque æcänö wäänë guiite quëwenguingää. ");
INSERT INTO aucNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ante wæyönänite, —Waomïni mïni, Ædö cæte cæquïï, ante mïni wædö incæ Wængonguï ïñömö do cæcampa, ante Itota apæ̈necä. ");
INSERT INTO aucNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ëñente wædinque Pegodo, —Awënë ëñëmi. Mönitö ëadincoo owæ̈ caate bitö mïñæ̈ tee empo pömöni abipa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Äñongante Itota tömënäni ïnänite wæætë, —Mïnitö näwangä oncodo tao godinque mïnitö nänöogængä ingante mïnitö tönïñadäni ïnänite wæmpoda ïnate wëñæ̈näni ïnänite ëmö cæte botö mïñæ̈ pömïnitapa. Ïninque ïïmaï ante näwangä ämopa. Æcänö Wængonguï Awënë Odeye beyænque botö mïñæ̈ mänömaï pöna ïñömö, ");
INSERT INTO aucNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tömengä ïñömö inguipoga quëwëninque nänö ëmö cædincoo adopocoo æ̈ninque ayæ̈ wæætë godömenque nanguï æncæcäimpa. Ayæ̈ ïincayæ̈ ate öönædë godinque edæ tömengä cöwë wantæpiyæ̈ wæ̈nämaï quëwencæcäimpa, ante ämo ëñëmaïmïnipa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Äninque tömengä mïñæ̈, Dote, ante näni gocabo ïnänite Itota nänënë ænte mäocä goyönäni ïïmaï ante apæ̈necantapa. “Ñöwo ïñömö mönö edæ Eedotadëë ïñömö æicæ̈impa. Wængonguï beyæ̈ në apæ̈negaïnäni ïïmaïnö ante yewæ̈möninque, Në Waocä ïincayæ̈ ate ëñate pæcä adinque tömengä ingante æbänö cæquïnänii, ante yewæ̈mongadänimpa. Ñöwo mönö Eedotadëë ïñömö æi pö gongæ̈mö ate edæ mänïnö dodäni näni angaïnö baï edæ do ïinque bacæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Botö edæ mänïmodö ëñagaïmo ïñömote oodeoidi botö ïmote ö æ̈ninque wadäni ïnänite pædæ mäo godönäni ö æ̈ninque tömënäni wæætë tawïmæ̈ botonga towæ tänongadinque botö ïmote badete todinque pïïninque wïwa anguïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ayæ̈ æ̈montaimenca tæi tæi pänäni ämogate wæyömote botö ïmote godömenque wæ̈nönäni wæncæboimpa. Wæætë mëönaa go adoönæque ïñonte edæ botö do wæ̈nïmo inte edæ ñäni ömæ̈monte wæætë quëwencæboimpa,” angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tömengä mïñæ̈ në godäni ïñömö mänïnö, Tömengä æbänö bate wæquingää, ante adodeque incæ edæ ëñënämaï ingadänimpa. Tömengä nänö apæ̈nedö edæ wë wodonte baï ïñonte tömënäni önömoncaque ëñëninque, Æbänö ante apæ̈necää, ante wïï edonque ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Itota mänïnö godinque Eedicoo ïñömö obo pöñongä onguïñængä babetamö inte në wædongä inte taadö wedeca, Pönömi æ̈moe, ante änecönongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nanguï ïnäni cægönäni ëñëninque babetamongä ïñömö, Quïnante cægönänii, ante wæyongante, ");
INSERT INTO aucNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Itota Näatadeta quëwëningä inte edæ ñöwo wodo tebæ̈ gocampa, ante apæ̈nedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ëñëninque tömengä ïñömö aa pedinque, —Itota ëñëmi. Bitö Awënë Dabii wodi pæ̈ïmi ïnömi inte botö wædö ante edæ ñöwo waadete pönö waa cæe. ");
INSERT INTO aucNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Äñongante täno godäni wæætë tömengä ingante, Apocæ̈në inguënë änewëë, ante wææ äñönäni tömengä godömenque nanguï äninque, —Awënë Dabii pæ̈ïmi ïnömi inte edæ botö wædö ante pönö waadete waa cæe, ante wæcä. ");
INSERT INTO aucNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Wædinque Itota næ̈ gongæ̈ninque, Tömengä ingante ænte mämömïni pongäedäni. Angä obo ænte mämönäni pöñongante Itota, ");
INSERT INTO aucNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Æbänö ante ämii. Bitö beyæ̈ quïnö cæquïmoo. Äñongante, —Awënë, wëënë botö ëmongaï baï cæbi acæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Angä ëñëninque Itota wæætë, —Wëënë bitö ëmongaï baï abäwe. Edæ wede pönëmi inte edæ waa bamömipa. ");
INSERT INTO aucNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ante nänö äñedë në babetamöningä do waa bamöninque Itota mïñæ̈ godinque Wængonguï ingante, Bitö ñäö apäite baï ëmömi inte edæ waa cæbi æ̈mopa, ante togacäimpa. Mänömaï cæcä adinque tömänäni adobaï Wængonguï ingante waa adinque, Bitö ñäö baï ëmömi inte waa cæbipa, ante togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Itota mänïï Eedicoo pöninque tæcæ wodo tebæ̈ gocä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mänïñömö adocanque Taqueo näni änongä ïñömö tömengä odömäno awënë beyæ̈ në æ̈näni awënë ïnongä inte nanguï mäincoo ëadongä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tömengä ñöwo, Itota æcänö ingää, ante acæte ante ponte ayongä wadäni nanguï ïnäni wææ ongönäni adinque, Botö ocäa pönï ïnömo inte edæ Itota ingante ædö cæte aquïmoo, ante wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Adämaï inte wæyongante wadäni, Itota ïïnö gämæ̈nö pö wodo tebæ̈ goquingä, ante tededäni ëñëninque tömengä Itota ingante acæte ante pogodo täno gote awäa ticämodöwäa näni äwäa daëwa æi næ̈ gongænte a ongongantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Itota obo pöninque æ̈mö ayongä Taqueo a ongongä adinque tömengä ingante, —Taqueo, quingæ̈ wææ̈e. Ñöwoönæ edæ pö bitö oncönë ëñaquënëmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Angä ëñëninque Taqueo quingæ̈ wææ̈ ti wææ̈ninque, Ao, botö oncönë waa poncæbiimpa, ante watapæ̈ todinque edæ tömengä oncönë mämongä pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Itota mänömaï cæcä adinque wadäni, Æ në wïwa cæcä weca Itota quïmæ̈ ëñacæ gocää, ante tömänäni pïinte tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Taqueo ïñömö edæ tömënäni ayönäni ængæ̈ gantite adiyæ̈ ongöninque mönö Awënë ingante, —Awënë ëñëmi. Botö mäincoo tæcæguedencoo pä cædinque ömæpodäni inte wæwënäni ïnänite ñöwo godömo æ̈näni ae. Ayæ̈ botö wacä quï ante babæ äninque ö æ̈mo wæcä ïninque wëënëñedë botö ö æ̈nincoo adopocoo baï incæ godömenque mempoga go mempoga godömo æncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ante apæ̈necä ëñëninque Itota wadäni ïnänite apæ̈nedinque, —Taqueo adobaï Abadäö wodi pæ̈ingä ïñongante botö në æ̈mo ïnömo inte tömengä oncönë näni owocabo quëwencædänimpa, ante ñöwoönæ pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Botö Waobo ëñagaïmo ïñömö æ̈mo beyænque quëwencædänimpa, ante cædinque wë womonte baï ïnäni ïnänite diqui diqui mincæ pontabopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mänömaï apæ̈necä ëñënäni inte tömënäni, Itota Eedotadëë obo pongampa, ante adinque, Wængonguï Awënë Odeye nempo mönö oo pönï quëwenguinque impa, ante pönente edæ oda cædänitapa. Ïninque Itota, Wængonguï Awënë æbänö cæquingää, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante odömöninque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ïïmaïnö ante apæ̈necantapa. “Waocä adocanque awënë odeye pæ̈ingä ïnongä inte, Botö gobæ wabæca gote ïmæca pancabaa awënë odeye bate pömoedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Äninque tömengä ingante në cædäni diete ganca ïnäni ïnänite äñete pönäni ate tömengä oodo mïnata näni äinta wantæpiyæ̈ cæte näni æ̈inta incæ æ̈ninque adocanque ingante adotaque pædæ wacä ingante adotaque pædæ godöninque tömänäni ïnänite godongä adopota adopota æ̈nänipa. ‘Mïnitö mäninta æ̈ninque godonte æ̈ï godonte æ̈ï cædinque, Yebængæ̈impa, ante botö gote pompoga cæedäni.’ ");
INSERT INTO aucNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ante wadæ gocä adinque tömengä nempo quëwënäni guiquënë tömengä ingante pïinte cædinque pancadäniya ïnänite äninque, Mïnitö tömengä mïñæ̈ godinque awënëidi ïnänite gode äninque, Mäningä ïñömö wïï mönitö awënë odeye bacæcäimpa, ante wææ ämïni ëñencædänimpa, ante da godönäni godänitapa,” ante apæ̈nedinque Itota ayæ̈ godömenque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Incæte awënëidi do änäni ate awënë odeye badinque tömengä ömæ pongantapa. Pöninque tömengä, Botö beyæ̈ në cædäni ïñömö godonte æ̈ï godonte æ̈ï cædinque æbänö godömenque nanguï edæ ænte mänänii, ante acæte ante cædinque, Botö oodo mïnata në æ̈nïnäni ïnänite äñete pöedäni, angä. ");
INSERT INTO aucNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Äñete pönäni ate tömengä weca täno pöningä ïñömö, ‘Awënë ëñëmi. Bitö oodo mïnata adotaque incæ önompo tipæmpoga mänimpota edæ ñöwo yebænte bapa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ante apæ̈necä ëñëninque tömengä ingante, ‘Botö ïmote në cæbi ïmi waa cæbi æ̈mopa. Wædænque incæ æ̈nïmi inte bitö ædæmö aate cæbipa, ante adinque botö önompo tipæmpoga näni quëwëñömö quëwënäni ïñönänite bitö nempo pönömo æ̈ninque në ämi inte aabi æ̈moe.’ ");
INSERT INTO aucNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ante tömënäni awënë angä ate ayængä pöninque, ‘Awënë ëñëmi. Bitö oodo mïnata adotaque incæ önompo æ̈mæmpoque mänimpota ñöwo yebænte bapa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ante apæ̈necä ëñëninque tömengä ingante adobaï apæ̈nedinque, ‘Önompo æ̈mæmpoque näni quëwëñömö quëwënäni ïñönänite botö bitö nempo godömo ænte aabi æ̈moe,’ angantapa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ayæ̈ godömenque apæ̈nedinque Itota, “Awënë angä ate tömangä guiquënë pöninque, ‘Awënë ëñëmi, tömëmi mïnata æ̈e. Botö weocodë ædæmö wïni caadinque wææ aate mantabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Äninque, Bitö wïï bitö ñönönï incæ wacä ñönönï incæ ö ænte mämi awædö. Ayæ̈ wïï bitö mïmi pæ incæ wacä mingä pædï incæ tä pebi ïmipa, ante pönente wædinque cætabopa. Bitö tæ̈ëmö ïnömi ïmipa, ante guïñente wædinque botö oodo mïnata botö æ̈ninta wïni caapote weocodë ædæmö wææ aabo ae.’ ");
INSERT INTO aucNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Äñongante tömengä awënë ïñömö, ‘Ïñæmpa bitö në wïwa cæbi ïmi nämä bitö tededö beyænque bitö ïmite apænte ancæboimpa. Botö tæ̈ëmö ïmo inte wïï botö ñönönï incæ wacä ñönönï incæ ö æ̈mopa. Wïï botö mïmo pædï incæ wacä mingä pædï incæ edæ do tä pebo ïmopa. Mänömaï impa, ante bitö dicæ ëñënämaï ïmitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Do ëñënïmi inte bitö ëñente edæ cæquënëmi ïmitapa töö. Botö oodo mïnata godonte æ̈inta æ̈ninque edæ në godonte æ̈näni weca baanco weca quïnante wïï guidonte æ̈mitawo. Mänömaï cæbi baï botö ocæ̈ ëmænte pöninque edæ botö quï do æ̈ninque wadäni näni guidöninta tönö edæ do æncædömoimpa töö,’ angampa.” ");
INSERT INTO aucNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Äninque godongämæ̈ ongönäni ïnänite awënë apæ̈necantapa. ‘Mïnitö ñöwo ïingä mïnata nänö næ̈æ̈ninta ö æ̈ninque edæ mïnata önompo tipæmpoga në næ̈ængä ingante pædæ godömïni æncæcäimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Angä ëñëninque tömënäni, ‘Awënë ïñæmpa, ïingä diete ganca mïnata do mangä apa ämii.’ ");
INSERT INTO aucNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ante wæyönäni awënë wæætë, ‘Ïñæmpa në ëadäni ïnänite tömänäni ïnänite godömenque godonte ingæ̈impa. Wæætë edæ ëadämaï inte ömæpocä ingä guiquënë tömengä nänö ëadincoo wædænque pönï ï incæte edæ ö ænte dæ ba wæcæcäimpa. Ante apæ̈nebo ëñëmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ayæ̈ botö ïmote në pïïnäni guiquënë botö ïmotedö ante apæ̈nedinque, Bitö wïï mönitö awënë odeye bacæcäimpa, ante në Baa änäni guiquënë, tömënäni ïnänite botö weca ænte pöninque botö ayömo wæ̈nömïni wæncædänimpa, ämopa,’ awënë angantapa. Mäninque ante odömonte apæ̈nebopa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mäninganca apæ̈nedinque Itota Eedotadëë æicæte ante täno gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Godinque Odibowænquidi näni anquidi ontacamö goïnö Betapaguee näni quëwëñömö obo pöninque Betänia ganca pöninque Itota tömengä mïñæ̈ në goda mënaa ïnate da godöninque, ");
INSERT INTO aucNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ïïmaï angantapa. —Mänïï näni quëwëñömö ongö amïna. Tömëñömö go guiite ayömïna bodo wë picængä incæ waocä ingante mongæ̈nämaï ïningä inte ñäni ñæ̈ingä a ongongä acæmïnaimpa. Adinque ñï cæyænte ænte pöeda. ");
INSERT INTO aucNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ayæ̈ wacä mïnatö ïmïnate, Quïnante ñï cæyæ̈mïnaa, ante wææ angä ïninque mïnatö wæætë, Mönö Awënë nänö ænguënënö ante æ̈mönapa, ante apæ̈needa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tömengä nänö në da godöna wadæ gote ayöna Itota nänö änï baï bodo wë a ongö. ");
INSERT INTO aucNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Adinque ñï cæyæ̈ñöna bodo wë në ëadäni tömëna ïnate, —Bodo wë quïmæ̈ ñï cæyæ̈wëmïnaa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wææ äñönänite tömëna wæætë, —Mönö Awënë nänö ænguënënö ante æ̈mönapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ante äna ëñëninque Ao änäni ïninque awæ̈ ñä cæyæ̈ñömö ñï cæyænte bodo ingante töï töï ænte pönatapa. Ayæ̈ ænte pöninque tömëna weocoo yabæcooque æidämæ̈ wo cæyabædinque äna ate Itota wæ̈nömënæca ïnö æi tæ̈ contate gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bodoga æi tæ̈ contate taadonque goyongä tömengä nänö goquïnö ante waodäni weocoo wææ̈nö bee podöwadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Odibowænquidi wææ̈nömëmö ïñömö pönömenque pöñongante tömengä mïñæ̈ në godäni godongämæ̈ näni poncabo tömänäni ïñontobæ̈ nanguï todinque ogæ̈ tededänitapa. Itota bamönengæ̈ nanguï cæcä atamönipa, ante näni adïnö ante pönëninque Wængonguï ingante waa ate apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Möni quëwenguinque impa, ante, Badogaa, ante tomönipa. Awënë Wængonguï ëmöwo beyænque pömi ïninque bitö toquinque edæ Wængonguï bitö ïmite waa cæcæcäimpa. Öönædë në quëwengä pönö piyæ̈në cæcänö anguënë. Æibæ pönï quëwënongä ïñömö ñäö baï ëmongänö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ante nanguï ïnäni godongämæ̈ godinque ämotamïni ante baï äñönäni pancadäniya Paditeoidi ïnönäni inte Itota ingante, —Në Odömömi ëñëmi. Bitö mïñæ̈ në godäni ïnänite wææ ämi apocæ̈në ïnänie. ");
INSERT INTO aucNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Äñönänite tömengä wæætë, —Mïnitö ïmïnite näwangä ämopa. Waodäni pæ wëënedäni ïninque dicacoo incæ botö ïmote waa ate baï edæ yedæ ämaïnänipa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ayæ̈ pönömenque pöninque Eedotadëë gomö adinque Itota mänïñömö quëwënäni ïnänite ante pönëninque Ca ca wædinque, ");
INSERT INTO aucNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ïïmaï angantapa. “Mïnitö ïñömö edæ ñöwoönæ mïni gänë pönenguinque botö ïmote edonque pönï adinque Ao ämïni baï waa incædönimpa. Incæte mïnitö, Æbänö cæte gänë pönenguïmöö, ante edæ wë wodonte baï ï ïninque mïnitö adämaï ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ïincayæ̈ ate mïnitö ïmïnite në pïïnäni incæ mïnitö wææ cæinca gäänë pönö tee mongate godämæ̈ wææ ongönäni adinque mïnitö edæ ædö cæte tao wodii wïnonguïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Botö mïnitö weca pömo incæte mïnitö awincaque adinque, Wængonguï ñöwoönæ ponte æncæcäimpa, ante dicæ amïniyaa. Mänömaï beyænque në pïïnäni ïñömö mïnitö ïmïnite bæ tadäni tæ̈ go wææ̈ñömïnite wæ̈nönäni wæncæmïnimpa. Ayæ̈ wëñæ̈näni wææ cæte ïñömö quëwëñönänite tömënäni ïnänite edæ wæ̈nönäni wæncædänimpa. Dica mïni mæ̈nongainca incæ bæ tadäni ate dica adocaque incæ wæ̈nömënæca ïnö ongönämaï ingæ̈impa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ayæ̈ Wængonguï oncö ñæ̈næncönë yabæcönë go guiidinque Itota mänïñömö në godonte æncæte ante në mänäni ïnänite da tadongä tao goyönänite, ");
INSERT INTO aucNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ayæ̈ tömënäni ïnänite angantapa. —Wængonguï beyæ̈ ïïmaïnö ante yewæ̈mongatimpa. “Waodäni botö oncönë pö guiidinque botö ïmote apæ̈necædänimpa,” ante Wængonguï angä incæte mïnitö wënæ wënæ cæmïni beyænque Wængonguï oncö incæ në awëmö ö æ̈näni näni womöincönë baï wentamö bapa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ayæ̈ ïïmö ïñö ïïmö ïñö Wængonguï oncö ñæ̈næncönë yabæcönë go guiidinque Itota odömonte apæ̈necä ëñënänitapa. Mänïñömö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni tönö tömënäni awënëidi guiquënë, Itota ingante wæ̈nonte wido cæcæ̈impa, ante ancaa cæyönäni, ");
INSERT INTO aucNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","wadäni tömänäni, Tömengä æbänö odömongää, ante ëñëë cönäni adinque awënëidi wæætë, Tömengä ingante mönö ædö cæte wido cæquïï, ante wædinque ñimpo cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ïincayæ̈ ate Itota Wængonguï oncö ñæ̈næncönë yabæcönë go guiite waodäni ïnänite odömonte apæ̈nedinque Wængonguï Awënë ingantedö ante watapæ̈ apæ̈necä ëñënänitapa. Apæ̈necä ëñëñönäni, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni ïñömö në aadäni näni Picæncabo tönö tömengä weca ponte änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ponte apæ̈nedinque, —Æcänö në angä inte bitö ïmite angä cæbii. Bitö ïmite æcänö, Në ämi babipa, äna ëñëninque cæbii. ");
INSERT INTO aucNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ante äñönänite Itota, —Botö wæætë mïnitö ïmïnite ämo ëñente apæ̈nemïni ëñëmoedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wäö wodi ïñömö quïnante æpæ̈në guidongantawo, ante pönëmïni. Öönædë në owocä angä ëñente cæcantawoo. Waodänique änäni ëñente cæcantawoo. Æbänö ante pönëmïnii. Mïnitö wæætë apæ̈nemïni ëñëmoedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Äñongä tömënäni ïñömö näni caboque tededinque, “Ïñæmpa mönö, Wængonguï öönædë ïnö angä Wäö ëñente cæcampa, ämö baï Itota wæætë, ‘Quïnante tömengä ingante pönënämaï ïmïnii,’ ante mönö ïmonte pïincædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ayæ̈ wæætë, Waodänique änäni ëñente cægacäimpa, ämo baï godongämæ̈ ongönäni ïñömö, Wængonguï beyæ̈ në apæ̈necä Wäö wodi ingacäimpa, ante në pönënäni inte tömänäni mönö ïmonte dicaca tacadäni wæncædömöimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ante pönente wædinque tömënäni wæætë Itota ingante, Wa. Æcämë angä ëñëninque Wäö wodi cægacäï, ante ëñënämaï ïmönipa, änäni. ");
INSERT INTO aucNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wædinque Itota wæætë, —Botö adobaï, Æcänö në angä inte pönö äna ëñëninque botö mänömaï cæboo, ante mïnitö ïmïnite apæ̈nedämaï incæboimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ayæ̈ godongämæ̈ ongönäni ïnänite Itota, Wængonguï Awënë æbänö cæcää, ante ëñencædänimpa, ante ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. “Onguïñængä adocanque yowementacodë minte pæyonte wadäni ömæ wite aate në tä pedäni ïnänite, Botö yowementacodë incæ ömæ wite aaedäni. Aayömïnite botö, Mïnitö quï, ante pancamonga pönömo æncæmïnimpa, angä Ao änäni ate në ëacä ïñömö edæ wantæpiyæ̈ wabæca quëwencæ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yowedepo ïinque bayedë në cæcä ingante në ëacä ïñömö, Bitö yowementacodë në aadäni weca godinque pancamonga ämi æ̈ninque botö weca wæætë mämömi æ̈moe, angä. Gote pongä adinque yowementacodë në aadäni guiquënë në æncæ pöningä ingante bæi ongonte tæi tæi päninque da tadönäni ömæpocä inte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ayæ̈ wæætë në ëacä ïñömö wacä tömengä ingante në cæcä ingante angä gote pongä adinque yowementacodë në aadäni adobaï tæi tæi pänäni wæyongante, Guingo imonte wæcæcäimpa, ante godö wïwa cædäni wæyongante da tadönäni ömæpocä inte gocampa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ayæ̈ mënaa ïnate da godongä ömæpoda pöna adinque në ëacä ïñömö wacä në cæcä ingante angä gote pöñongante tömënäni godö mæ̈ yete wido cædänitapa,” ante odömöninque Itota godömenque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Mänömaï cædänipa, ante ëñente wædinque yowementacodë në ëacä ïñömö, ‘Botö ïñömö æbänö cæquënëmo ïmoo, ante wædinque, Botö edæ ïïmaï cæcæboimpa. Botö wengä onguïñængä botö në waadecä ïñongante da godömo gocæcäimpa. Tömëmo wengä da godömo gocä adinque tömënäni wabänö guïñente wædinque ee abaïnänipa,’ ante pönëninque da godongä. ");
INSERT INTO aucNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Gote dicæ pongä adinque yowementacodë në aadäni guiquënë, ‘Tömengä ingampa. Wæmpocä mäincoo ïnï edæ ïingä ïñömö në ænguingä ingampa cæmöö. Mönö edæ mäo wæ̈nömö wængä ate edæ mönö quï babaimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Änewëninque tömënäni tömengä ingante wææ cæte ïñömö yabæque wido cædinque godömenque wæ̈nönäni wængantapa.” Ante Itota, Mäninque ante apæ̈nebopa, ante tömënäni ïnänite angantapa. “Mänömaï cædäni adinque yowementacodë në ëacä ïñömö tömënäni ïnänite æbänö cæquingää, ante pönëmïni. ");
INSERT INTO aucNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tömengä edæ do pöninque në aaquënënäni ïnänite godö wæ̈nöninque wadäni ïnänite wæætë yowementacodë godongä æ̈ninque në aadäni bacædänimpa.” Itota mänömaï angä ëñente wædinque godongämæ̈ ongönäni ïñömö, —Mänömaï cædämaï inguënë änewëë, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ïninque Itota tömënäni ïnänite gomö adinque, —Ïñæmpa ëñënämaï cæmïni ïñömïnite Wængonguï pänämaï inguingää, ante pönëmïnitawo. Ïninque mïnitö, Ïïmaï ante quïnante yewæ̈mongatimpa, ante pönëmïni. “Dica ænte adinque, Wënæ wënæ inca, ante në mæ̈nönäni näni wido cædinca incæ gomonga waëmonca inca ïninque täno näni ñönöninca bæbængapa do bacapa,” ante yewæ̈mongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Botö ïñömö mänïï dica waëmonca baï ïnömo inte ämo ëñëninque në wæcä ïñömö tömengä ïñömö mänincaa tæ̈ go wææ̈ninque tobænte wæte baï botö önöwa gäänë ædæ wææncæcäimpa. Wæætë æcänö ingante Wængonguï pïinte mänincaca tacacä ïnaa tömengä guiquënë quïëmë baï yaintai baï goquingänö anguënë, ante pönëmïniyaa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ante në aaquënënäni näni cæïnö ante odömöninque Itota apæ̈necä ëñente wædinque në odömönäni tönö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni ïñömö, Ïñæmpa mönö ïmonte pïinte angä awædö, ante pönënänitapa. Ïninque tömënäni, Mönö ñöwo pönï tömengä ingante bæi ongongæ̈impa, ante cædänitapa. Incæte tæcæ bæi ongoncæ cædinque, Wadäni pïïnäni wæcæ wæ, ante wædinque ee adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ïninque, Mönö Itota ingante bæi ongöninque odömäno gobedönadodo awënë nempo godömö æ̈ninque tömengä wæætë në angä inte edæ Itota ingante apænte ancæcäimpa, ante ñæ̈næ̈näni incæ tömengä ingante cöwä adänitapa. Ayæ̈ wadäni ïnänite äninque, Mïnitö Itota mïñæ̈ tee empote gote nöingä ante baï apæ̈nedinque wæætë babæ cæedäni. Babæ cæmïni beyæ̈ tömengä adodeque incæ wapiticæ̈ tedecä ëñëninque mïnitö ocæ̈ ëmænte ponte apæ̈nemïni ëñencæmönimpa, änäni ëñente godinque ñæ̈næ̈näni näni änïnö baï babæ cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ïninque ñæ̈næ̈näni näni në da godönïnäni ïñömö Itota weca pöninque, —Awënë në Odömömi ëñëmi. Bitö apæ̈nedö nö impa, ante do ëñëmönipa. Bitö ayömi mönö waocabo adoyömö pönï ïmönipa, ante adinque bitö tömämöni ïmönite adoyömö pönï cæbi æ̈mönipa. Ayæ̈, Wængonguï taadö ante bitö nö pönï odömömi ïmipa, ante ëñëmönipa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ïninque apæ̈nebi ëñëmönii. Odömäno gobiedöno beyæ̈ ante tæiyæ̈ awënë Tetædo tiguitamö nänö änintamö ante æbänö wææ yewæ̈monte ï, ante ëñencæte ante wæmönipa edæ. Godonte edæ waa cæte intawo. Wæætë wënæ wënæ cæte intawo. ");
INSERT INTO aucNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Äñönänite Itota ïñömö, Tömënäni wënæ wënæ ancæte ante babæ cædänipa, ante do ëñente wædinque, ");
INSERT INTO aucNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Deënadio tiguitamö odömömïni aboedäni. Æcänö awinca baï yewæ̈monte badonte ï. Æcänö ëmöwo ante yewæ̈monte ongö, ante edæ apæ̈nemïni ëñëmoedäni. Äñongante, —Awënë Tetædo awinca baï yewæ̈monte badonte impa. Adocä ëmöwo ante yewæ̈monte ongö amönipa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ante apæ̈nedäni ëñëninque, —Awënë Tetædo quï ï ïninque edæ Tetædo ingante godongæ̈impa. Wæætë Awënë Wængonguï quï ï ïninque Wængonguï ingante godonguï ï apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ante Itota tömänäni ayönänite nö apæ̈necä ëñente wædinque ñæ̈næ̈näni näni da pönönïnäni wæætë, Mönö ædö cæte pïinguïï, ante guingo imonte wædinque pæ wëënegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tadoteoidi në, Waocä wæ̈ninque ñäni ömæ̈mönämaï æ̈mæ̈wo wængampa, ante në änewënäni inte Itota weca pöninque, Möni änö ante apæ̈nebi ëñëmaïmönipa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Awënë në Odömömi ëñëmi. Mönö beyæ̈ ante Möitee wodi ïïmaï ante wææ yewæ̈mongacäimpa. Onguïñængä monte ate wëñæ̈ tapæ̈idämaï inte wængä ïninque tömengä tönïñacä incæ owæmpoingä ingante möninque, Botö tönïñacä wodi wënäni wæætë pæcædänimpa, ante tapæ̈icæcäimpa, ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ïninque wadäni ïïmaï cædänitapa, ante apæ̈nemöni ëñëe. Edæ önompo æ̈mæmpoque go mengäa näni caipæ̈ ïñönänite bamoncadengä möninque wëñæ̈ tapæ̈idämaï manguïwëninque edæ näñe wængä. ");
INSERT INTO aucNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ate ayæ̈mengä wææ̈ adocä ingante möninque wëñæ̈ tapæ̈idämaï inte näñe wængä. ");
INSERT INTO aucNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ayæ̈ wææ̈ wacä möninque adobaï näñe wængä, ayæ̈ wææ̈ wacä möninque näñe wængä, ayæ̈ wææ̈ wacä möninque näñe, ayæ̈ wææ̈ wacä möninque näñe, ayæ̈ wææ̈ wacä möninque näñe wængampa. Önompo æ̈mæmpoque go mënaa ïnäni owæmpoingä ingante möninque edæ wëñæ̈ tapæ̈idämaï inte edæ tömänäni näñe wæ̈näni. ");
INSERT INTO aucNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ate onquiyængä tömangä näñe wængä. ");
INSERT INTO aucNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ïninque, Mönö ñäni ömæ̈monguïönæ, ante mïni äönæ ïñonte mäningä owæmpoingä ïñömö æcänö nänöogængä baquingää. Edæ tömengä ingante ïñömö edæ tömänäni manguïwengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Äñönänite Itota, —Inguipoga quëwëninque edæ mïni waocabo ïñömö do mömïnipa. Wacä ingante do godö ñänömïni mongampa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wæætë, Mïinguipoga bayonte ïïnänique eyepæ̈ inte ñäni ömæ̈monte öönædë æite quëwencædänimpa, ante Wængonguï nänö në angaïnäni ïñömö tömënäni mönämaï ïninque wadäni ïnänite godö ñänönämaï incædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ayæ̈ Wængonguï anquedoidi baï ïnönäni inte tömënäni Wængonguï nänö në angaïnäni ïñömö ædö cæte wæætë wænguïnänii. Tömënäni në ñäni ömæ̈mongaïnäni ïnönäni inte edæ Wængonguï wëñæ̈näni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wæætë Möitee wodi incæ ocäñeque bæcoïñeque ante nänö yewæ̈mongainta adotaa yewæ̈möninque, Waodäni dobæ ñäni ömæ̈monte quëwencædänimpa, ante edonque odömongacäimpa. Tömengä ïïmaï ante yewæ̈mongacäimpa. Mönö Awënë ïnongä ïñömö Abadäö Wængonguï ingaingä inte ayæ̈ Itæca Wængonguï ingaingä inte adocä Aacobo wodi Wængonguï ingänö anguënë, ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ïñæmpa Wængonguï ïñömö në quëwënäni Wængonguï ïnongä inte tömengä në wængaïnäni Wængonguï ïnämaï ingampa. Wæætë tömengä ayongante do wængaïnäni incæ tömänäni mïïnäni quëwënänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ante apæ̈neyongante në odömönäni pancadäniya, —Awënë në Odömömi ëñëmi. Bitö nöingä ante apæ̈nebi awædö, ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ayæ̈ wadäni tömänäni guïñente wædinque godömenque änämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ayæ̈ tömënäni ïnänite Itota, —Awënë Dabii wodi Pæ̈ingä ïnongä wææ̈ Codito ingampa, ante quïnante änänii, ante pönëmïni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ïñæmpa Dabii wodi incæ tömengä nänö ämotamïni äintaa ïïmaï ante yewæ̈mongacäimpa. “Botö Awënë ingante apæ̈nedinque Awënë Wængonguï incæ ïïmaï ante apæ̈negacäimpa. Bitö botö tömëmæ̈ ïnö tæ̈ contate a ongöe. ");
INSERT INTO aucNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ongöñömite botö bitö ïmite në pïïnäni ïnänite bæ tate cæbo ate, bitö önöwa gäänë ongönäni ïnänite pïnä gäwacæbiimpa,” ante Awënë Wængonguï apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Codito në Awënë ingampa, ante awënë Dabii wodi nänö në angaingä ïnongä inte edæ adocä Codito ïñömö ædö cæte näëmæ̈ Awënë Dabii wodi Pæ̈ingä inguingää. ante pönenguënë änewëmïnii, ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ayæ̈ tömänäni ëñëë cöñönänite tömengä mïñæ̈ në godänique ïnänite Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cædämaï, ante wææ ante näni yewæ̈mongainta në ate odömönäni ïnänite mïnitö gomö aedäni. Tömënäni ïñömö doyæncoo waëmoncoo wëñate mongænte todänipa. Waodäni näni godonte æ̈ïñömö cægöñönänite wadäni pö bee tëninque tömënäni ïnänite, Në odömömi, bitö ïmite waa amönipa, ante apæ̈nedäni ëñëninque edæ në odömönäni ïñömö nanguï todänipa. Ayæ̈ tömënäni odömöincönë go guiidinque tömënäni nämanque ante pönëninque waëmompaa pönï tæ̈ contate todänipa. Ayæ̈ æ̈æ̈mæ̈ becæ godinque tömënäni, Botö täno bete tocæ̈impa, ante waëmompaa pönï tæ̈ contate bete todänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ayæ̈ owæmpoïnäni oncö yo mongænte baï cædinque ö æ̈wënäni inte në wææ odömönäni ïñömö, Botö ïmote waa acædänimpa, ante cædinque Wængonguï ingante nöingä apæ̈nete baï cædinque babæ cædinque wantæpiyæ̈ tededänipa. Tömënäni edæ näni nanguï pönï pante wæquinque mänömaï nämä beyænque ante cædänipa, ante adinque mïnitö ïñömö ee gomö aedäni,” ante Itota wææ angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Itota Wængonguï oncönë ongonte gomö ayongä në nanguï ëadäni, Wængonguï quï, ante näni wënoncadedë pö daga daga wënäni acantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ayæ̈ ayongä onquiyængä owæmpoingä ömæpocä inte önontamonque mentamonga pö daga wengä. ");
INSERT INTO aucNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Adinque Itota ïïmaï ante apæ̈necantapa. —Näwangä ante apæ̈nebo ëñëedäni. Wadäni tömänäni wædænque pönï godonte baï wïï eyepæ̈ daga wëñönäni ïingä owæmpoingä ïñömö ömæpocä inte wædongä incæte godömenque nanguï godonte baï godongä abopa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tömënäni nanguï ëadäni ïnönäni inte, Quëwenguinta impa, ante cö cædinque tömënäni näni wïï æ̈ïnentaque ayæ̈ ongöintaque godönänipa. Ïingä ömæpocä ingä guiquënë tömengä nänö quëwenguinta incæ, Wængonguï quï bacæ̈impa, ante tömanta edæ daga wengampa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wëënëñedë Wængonguï oncö ñæ̈næncö mæ̈nöninque wadäni dicacoo waëmoncoo pönï tee bædäni waa ongoncadompa. Ayæ̈ wacoo waëmoncoo pönï ænte pöninque, Wængonguï quï impa, ante pædæ godönäni ongönompa. Ñöwo ïñömö Itota mïñæ̈ në godäni pancadäniya gomö ayönäni, Dicacoo tönö wadäni waa pönï näni ænte pönoncoo waëmoncoo pönï ongö amönipa, ante tededänitapa. Tedeyönänite Itota, ");
INSERT INTO aucNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Mänincoo mïni acoo incæ ïincayæ̈ ate tömanca bæ tadäni wæænca adinque panguïmæ̈ panguïmæ̈ godinque dica adocaque pönï incæ wæ̈nömënæca ongönämaï ingæ̈impa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mänömaï apæ̈necä ëñëninque tömënäni wæætë, —Awënë në Odömömi ëñëmi. Mänïï bitö änïnö ante æyedënö ïinque baquïï, ante ëñencæte ante wæmönipa. Ayæ̈, Ïïmaï cæbo ate mïnitö, Oo pönï impa, ante ëñencæmïnimpa, ante Wængonguï æbänö mä cæquingää, ante apæ̈nebi ëñëmönie. ");
INSERT INTO aucNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Äñönäni Itota, “Wapiticæ̈ odömöñönäni mïnitö wæætë, Mönö oda cædämaï ingæ̈impa, ante nämä wææ aedäni. Edæ ïïmaï baquï ï ataqueedäni. Wadäni nanguï ïnäni ponte botö ëmöwo ante apæ̈nedinque, ‘Coditobo ïmopa,’ ante babæ ante tedequïnäni ïnänipa. Ayæ̈, ‘Oo pönï impa,’ ante ponte nanguï ïnäni tedequïnäni ïnänipa. Mänömaïnö ante ponte tedeyönänite mïnitö wæætë tömënäni mïñæ̈ tee empote godämaï ïmäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ayæ̈, Wabæca awënë tönö pö bee tëninque wæætedö wæætë cædapa, ante tededäni ëñencæmïnimpa. Ayæ̈, Adobæca quëwëninque incæ awënë ingante wido cæcæte ante ængæ̈ gantidänipa, ante tededäni ëñëninque mïnitö ïñömö edæ guïñënämaï ïedäni. Mänömaï edæ täno cöwë bacæ̈impa. Incæte ïinque baönæ botö äönæ æiquedö ponguïï.” ");
INSERT INTO aucNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ante apæ̈nedinque Itota godömenque apæ̈necantapa. “Adobæca quëwënäni ïñönänite wabæca quëwënäni ponte bee tëninque guëadö guëa cæquïnäni ïnänipa. Adobæca awënë odeye nempo quëwëñönänite wabæca awënë odeye nempo quëwënäni mämö bee tëninque guëadö guëa cæte wæ̈nonte wænguïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ayæ̈ wayömö wayömö goinque nanguï pönï ocæ ocæ cæcæ̈impa. Ayæ̈ waodäni näni cæ̈ïnente wænguinque cænguï incæ tömää capo wængæ̈impa. Ayæ̈ quingæ̈ näni wodonte wënæ wënæ inte wæwenguïmämo incæ edæ do pongæ̈impa. Edæ ancai näni guïñenguïmämo edæ pongæ̈impa. Öönædë ïñömö näni wo go wo go cæwënenguïmämo edæ ate baï bacæ̈impa.” ");
INSERT INTO aucNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ayæ̈ apæ̈nedinque Itota, “Mänïmämo näni guïñenguïmämo tömämämo ayæ̈ pönämaï ïñonte mïnitö ïmïnite togænte yao ongonte tömënäni odömöincönë ænte go guiidinque apænte äninque mïnitö ïmïnite mäo tee mönecædänimpa. Ayæ̈ botö ëmöwo beyæ̈ mïnitö ïmïnite tömämæ awënëidi odeyeidi weca ayæ̈ pancabaa awënëidi gobedönadodoidi weca ænte mäodäni gote gongæncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mïnitö awënëidi weca godinque gongænte apæ̈nemïni ëñëninque awënëidi incæ, Itota æcänö ingää, ante ëñencædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ïninque mïnitö ïmïnite awënëidi weca ayæ̈ ænte godämaï ïñedë incæ mïnitö ïïmaï ante nämäneque pönëedäni. Botö awënë weca ongöninque æbänö ante wææ anguïmoo, ante edæ wædämaï incæboimpa, ante piyæ̈në cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ïñæmpa botö pönö nö apæ̈nebo ëñënïmïni inte mïnitö wæætë adodö ante apæ̈necæmïnimpa. Mänömaïnö ante apæ̈nemïni ëñëninque në pïïnäni guiquënë nö pönï mïni apæ̈nedö ante ædö cæte wido cæquïnänii. Wæætedö wæætë ædö cæte anguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mïnitö mæmpoidi incæ mïnitö tönïñadäni incæ mïnitö guiidënäni incæ mïnitö æ̈migoidi incæ, Ïingä ingampa, ante godö odömöninque mïnitö ïmïnite wadäni nempo pædæ godönäni ö æncædänimpa. Æ̈ninque pancamïniya ïmïnite godömenque wæ̈nönäni wænguïmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ayæ̈, Coditoidi ïmïnipæ̈æ̈, ante tömänäni botö ëmöwo beyænque mïnitö ïmïnite nanguï pïincædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Incæte mïnitö baö incæ ocaguï incæ adoguinque incæ æ̈mæ̈wo ëwënämaï ingæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ïninque mïnitö botö ïmote pïïnämaï inte wæntædämaï inte ee cæmïni ïninque botö æ̈mo beyænque quëwencæmïnimpa.” ");
INSERT INTO aucNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ante apæ̈nedinque Itota godömenque apæ̈negacäimpa. “Wabæca tontadoidi pöninque Eedotadëë godongämæ̈ wææ ongönäni adinque mïnitö, Bæ tate näni wido cæquïmämo oo pompa, ante do edæ ëñencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mänömaï cædäni adinque Oodeabæ quëwëmïni ïñömö änanquidi do wodii wïnonte æibäewedäni. Ayæ̈ Eedotadëë quëwëmïni ïñömö edæ yabæque taobäewedäni. Ayæ̈ yabæque quëwëmïni inte Eedotadëë ïñömö pö guiidämaï ïmäewedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mänïñedë edæ Wængonguï nänö panguïönæ incæ Wængonguï beyæ̈ näni yewæ̈monte angaïönæ incæ ïinque baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mänïönæ ïinque bayedë edæ yædëmadä ïnäni tönö goömæ̈ në gänönäni tönö tömënäni näni wæquïmämo baquïnö anguënë. Ïmæca quëwënäni edæ mänïñedë nanguï pönï caate wæquïnäni ïnänipa. Idægoidi ïnänite edæ nanguï pönï pïinte cæquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pancadäniya ïnänite yaëmenca wido tadäni wænguïnäni ïnänipa. Ayæ̈ pancadäniya ïnänite bæi ongonte mäo wabæca ænte goquïnäni ïnänipa. Wængonguï doyedë apæ̈nedinque, Oodeo ïnämaï ïnäni ïinque näni cæpoga cæcædänimpa, angacäimpa. Ïninque tömengä nänö angaimpoga ïinque baganca oodeoidi ïnämaï ïnäni incæ Eedotadëë ïñömö pöninque nanguï cægöninque pïnä gäwate baï bæ tadäni wæquïmïni ïmïnipa, ante apæ̈nebo ëñëmaïmïnipa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ayæ̈, “Oo pönï impa, ante edæ ëñencæmïnimpa, ante cædinque Wængonguï angä ate nænque tönö apäicä nëmoncoo mä pönï edæ wacoo baï bacæ̈impa. Inguipoga guiquënë ñæ̈nængade pönï gäwapæntibæ tadömengadæ̈ mængonta mængonta cædinque nanguï ä ëñente wædinque tömämæ quëwënäni edæ, Æbänö cæquïmöö, ante edæ nanguï pönï guïñente wæquïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ayæ̈ waodäni æ̈mö ayönäni öönædë tæ̈ï ongongaincoo incæ wancæ wancæ cæte baï wapiticæ̈ go ate adinque tömënäni ancai guïñente wædinque, Inguipoga mönö quëwëñömö edæ quïëmë baï bacæ̈impa, ante wædinque ïñontobæ̈ nangæ̈ bate wæcædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mänïñedë edæ botö Waobo në ëñagaïmo inte boguïmancodë pöninque tæ̈ï pönï pïñæ̈mo ïninque edæ ñäö apäite baï waëmö ëmonte wææ̈mo acædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ïninque mänömaï tæcæ ba ate wædinque mïnitö ocabo guïnï æ̈mencadinque, Badogaa, äninque edæ, Oo pönï mönö abæ tawænte goquinque impa, ante ämäewedäni,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ayæ̈, Wængonguï Awënë oo poncæcäimpa, ante æbänö ëñenguïï, ante ëñencædänimpa, ante Itota ïmæca quëwënäni näni cæïnö ante odömöninque ïïmaï apæ̈necantapa. “Iigowæ̈ aedäni. Ayæ̈ quïwæ̈më incæ tömäwæ̈ aedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Öñabo tänä nä boca adinque mïnitö ïñömö, Öñabo nänö bocaïnepo inte nænque näwantedæ̈ baquinque bocapa, ante pönëninque edæ do ëñëmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ayæ̈ adobaï mänïnö botö apæ̈nedö baï do edæ ba adinque mïnitö, Wængonguï Awënë Odeye do odemö pönï ongöninque inguipoga oo poncæcäimpa, ante ëñencæmïnimpa,” angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ayæ̈ apæ̈nedinque Itota, “Näwangä ämopa. Ñöwomïni mïïmïni quëwëninque wænte godämaï ïñömïni edæ mänïnö botö änïnö baï tömänö edæ do ïinque baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Edæ öönædë ongöñömö inguipoga tönö wo ëwente baï dæ ba incæte botö angaïnonque guiquënë dæ badämaï inte edæ cöwë tæ̈ï ongongæ̈impa,” ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ayæ̈, “Mïnitö ïñömö edæ, Mönö quingämë baï wïwa quëwëmö ïninque mönö mïmö ömædëmö bate wæcæ wæ, ante nämä wææ aaedäni. Tï nämæ̈ bete quidi quidi dowäninque mïmö ömædëmö bacæ wæ, ante nämä wææ aaedäni. Ayæ̈, Inguipoga quëwëmö inte quïëmë beyænque wædinque mïmö ömædëmö bacæ wæ, ante nämä wææ cæedäni. Mïmö ömædëmö inte wæyömonte mänïönæ wïï ïñontobæ̈ pö wæcæ̈impa, ante mïmö ömædëmö badämaï ingæ̈impa, ante nämä wææ cæedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ïñæmpa waodäni tömänäni inguipoga tömämæ quëwëñönänite edæ ïñontobæ̈ ba wæcædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ïninque woyowotæ̈ itædë cöwë wänö cöninque mïnitö Wængonguï ingante cöwë apæ̈needäni. Mïnitö, Mänïnö ïinque ba adinque mönö eyepæ̈ inte aamö cæte wodi wïnongæ̈impa, ante Wængonguï ingante apæ̈needäni. Ayæ̈, Waocä në ëñagaingä weca mönö eyepæ̈ gongængæ̈impa, ante adobaï edæ Wængonguï ingante apæ̈needäni,” ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Itota mänïñedë Wængonguï oncö ñæ̈næncönë ïïmö ïñö ïïmö ïñö yabæcönë go guiite odömonte apæ̈necä ëñënäni ate tömengä wæætë gäwadecæ̈ ïñö gäwadecæ̈ ïñö tao godinque Odibowænquidi æite owodongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ayæ̈ tömengä Wængonguï oncö ñæ̈næncönë yabæcönë ongonte apæ̈necä ëñencæte ante tömänäni wæætë baänæ ïñö pö baänæ ïñö pö bee tënönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Päö yedæ æmpoquï ömæmö ï näni cænguïönæ ante oodeoidi, Patowa mönö wodo pænta gogaïönæ æ̈æ̈mæ̈ oo pönï bacæ̈impa, ante cædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni ïñömö, Itota ingante mönö wido cæcæ̈impa, ante cöwë cædönänimpa. Incæte, Wadäni pïïnäni wæcæ wæ, ante guïñente wædinque tömënäni mänïñedë, Mönö æbänö cæte awëmö bæi ongongæ̈impa, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ayæ̈ Itota mïñæ̈ näni, Dote, ante gocabo ïñönäni Codaa Icadiote näni änongä adocä ïnongäimpa. Tatäna mänïñedë tömengäa pö guiicantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ïninque në godönäni ñæ̈næ̈näni tönö Wængonguï oncö në wææ wänönäni awënëidi ïñömö godongämæ̈ ongöñönäni Codaa tömënäni weca godinque ïïmaï ante apæ̈necantapa. Itota æyömönö ongongää, ante botö æbänö odömonte pædæ pönömo ate ænguïmïni. Angä ëñëninque tömënäni tömengä tönö mänïnö ante godongämæ̈ tedegadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tömengä, Odömonte pædæ pönömo æncæmïnimpa, ante apæ̈neyongante tömënäni nanguï todinque wæætë, Tiguitamö padatamö pönömöni æncæbiimpa, ante apæ̈nedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ëñëninque tömengä Ao ante wadæ godinque, Wadäni adämaï ïñönänite botö æbänö cæte ïïnäni ïnänite awëmö odömonte godömo ænguïnänii, ante cöwä adinque cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Päö yedæ æmpoquï ömæmö ï näni cænguïönæ ïñonte wodo pænta gogaïönæ baï ï ïninque Patowa æ̈æ̈mæ̈ bete cænguïönæ do ïinque batimpa. Mänïönæ ïñonte oodeoidi cöwë cæ̈ningä codotedo ingante wæ̈nöninque, Wængonguï quï, ante godonguënënäni ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ïninque Pegodo tönö Wäö ïnate da godöninque Itota ïïmaï angantapa. —Mïnatö ïnönö gote, Patowa æ̈æ̈mæ̈no impa, ante æ̈nömïna ate mönö cængæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Angä ëñëninque tömëna, —Æcönënö go guiite æ̈æ̈nonguïmöna, ämii. ");
INSERT INTO aucNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Äñönate tömengä wæætë, —Waa aeda. Mïnatö mänïï näni quëwëñömö go guiiyömïna onguïñængä incæ cadabodë æpæ̈ iyænte næ̈ænte gocä adinque tömengä ingante edæ tee empote goeda. Tee empo goyömïna tömengä oncönë go guiicä adinque, ");
INSERT INTO aucNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mïnatö wæætë oncö në ëacä ingante ïïmaï ante äeda. “Mönö Awënë në Odömongä incæ bitö ïmite ïïmaï angampa. Bitö æcönënö ämi guiidinque botö në ëmïñæ̈näni tönö Patowa æ̈æ̈mæ̈ ante cænguïmönii, angampa,” ante apæ̈needa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mänömaïnö ante apæ̈nemïna ëñëninque në oncö ëacä ïñömö æ̈mongapaa mæ̈i goyömïnate oncö ñæ̈næncö awæmpaa do nänö cönöincö odömongä adinque mïnatö mänincönë tömää eyepæ̈ cæcæmïnaimpa, ante Itota da godongä godatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mänömaï angä godinque apæ̈neyöna, Itota nänö änö baï adobaï tömää batimpa, ante adinque tömengä nänö në ëmïñæ̈na, Patowa æ̈æ̈mæ̈no impa, ante cædatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ïninque æ̈æ̈mæ̈no näni cæ̈ñedë ïinque bayonte Itota awæmpaa gäänë pö tæ̈ contayongä tömengä nänö në da godönïnäni godongämæ̈ pö tæ̈ contadäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Adinque Itota tömënäni ïnänite apæ̈necantapa. —Botö ïñömö caate wæte wæ̈nämaï ïñedë mïnitö tönö godongämæ̈ Patowa ante cænte tocæ̈impa, ante cæ̈ïnente nanguï wætabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Apæ̈nebo ëñëedäni. Botö Wængonguï Awënë ïnömo inte Awënë Odeye badinque mänïñedë ate waodäni ïnänite æ̈mæ̈wo pönï ata cæpocæboimpa. Mäninganca botö ata cæpoganca botö ñöwo, Wængonguï Awënë dodäni ïnänite ata cæpodinque wodo pænta gogacäimpa, ante Patowa æ̈æ̈mæ̈no ñöwo ïinque cæncæ cæbopa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Äninque ayæ̈ Itota bequïmæ̈ owætaca bæi ongonte æ̈ninque Wængonguï ingante waa ate apæ̈nedinque tömënäni ïnänite angantapa. —Mïnitö owæta ïinta æ̈ninque godongämæ̈ beedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ämo ëñëedäni. Yowepæ̈ ñöwo bedinque botö Wængonguï Awënë ïnömo inte Awënë Odeye botö baganca edæ ñöwo æ̈mæ̈wo bebopa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ante apæ̈nedinque Itota päö æ̈ninque Wængonguï ingante waa ate pönente apæ̈nedinque pä æ̈ninque pædæ godöninque apæ̈necantapa. —Ïï päö botö baö baï impa. Botö, Mïnitö quëwencæmïnimpa, ante botö baö godonte baï cædinque wæncæboimpa. Botö pä ænte pædæ pönömo baï mïnitö ïincayæ̈ ate botö ïmote ante pönëninque adobaï cæte wacä ingä wacä ingä pædæ godonte cæ̈edäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mänömaï angä ïinque cæ̈näni ate owæta adobaï ænte apæ̈nedinque tömengä, —Botö wepæ̈ ïïmæ̈ baï impa. Wængonguï do apæ̈nedinque, Botö pönö cæbo ate mïnitö Ao ämïni ïninque mönö godongämæ̈ waa cæte quëwengæ̈impa, angacäimpa. Ñöwo adobaï botö wepæ̈ mïnitö beyæ̈ pædæ godömo ate mïnitö Ao ante æ̈mïni ïninque mönö godongämæ̈ waa cæte quëwengæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Incæte botö ïmote në pönö odömonte pædæ godonguingä ïñömö botö önompo gäänë cænguimpaa adoyömö ongö aedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wængonguï do nänö angaïnö baï botö në Waobo ëñagaïmo inte wænte gocæboimpa. Näwangä impa. Incæte botö ïmote në pönö odömonte pædæ godonguingä ïñömö edæ tömengä nänö nanguï wæwenguinque edæ mänömaï cæcä ingampa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ante Itota apæ̈neyongä tömënäni näni caboque tededinque edæ, Æcänö ingante ante apæ̈necää, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ayæ̈ adobaï, Mönö cabo ïñömonte æcänö ñæ̈nængä inte edæ yæcado ongonte baï në angä baquingää, ante wædinque tömënäni wæætedö wæætë äninque nanguï tedewënäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Adinque Itota tömënäni ïnänite, “Idægoidi ïnämaï ïnäni awënëidi ïñömö tömënäni nempo quëwënäni ïnänite, Botö ämo ëñente cæedäni, ante nanguï pïinte änewënänipa. Incæte në pïinte änewënäni ïñönänite tömënäni nempo quëwënäni wæætë, Mönitö awënëidi në Pönö Cædäni ïnänipa, ante babæ ante pemöwënänipa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wæætë mïnitö guiquënë inguipoga awënëidi näni cæï baï cædämaï ïedäni. Mïni cabo incæ në yæcado ongongä inte yæmïñængä baï baquënengä ingampa. Ayæ̈ në angä ïnongä inte wacä beyæ̈ në cæcä baï baquënengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Æbänö ante pönëmïnii. Æcänö ingante, Awënë baï ingampa, ante nanguï waa adänii. Në cænguimpaa gäänë tæ̈ contate cængä ingante waa adänitawo. Wæætë awënë beyæ̈ ante ænte mämö pönongä ingante waa adänitawo. Ïñæmpa në contacä ingante näwangä waa adänipa. Incæte botö ïñömö önömoque baï cædömo inte mïnitö weca pöninque në ænte mämö pönongä baï inte në pönö cædömo ïmopa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ayæ̈ apæ̈nedinque, “Botö caate wæwëñömote mïnitö ïñömö botö tönö godongämæ̈ ïñacabo cædïmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ïninque botö Mæmpo botö ïmote, Awënë Odeye bacæbiimpa, ante nänö pönö cægaï baï botö wæætë, Botö tönö ïñacabo cædïmïni ïnömïni inte mïnitö awënë odeyeidi adobaï bacæmïnimpa, ante pönö cæcæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ayæ̈, Botö në Awënë Odeye bayömote mïnitö botö awæmpaa gäänë tæ̈ contadinque godongämæ̈ edæ cænte becæmïnimpa, ämopa. Ayæ̈ idægoidi önompo tipæmpoga go mencabodäniya ïñönänite mïnitö awënë tæ̈ contaimpaa tæ̈ contadinque tömënäni ïnänite në apænte ämïni bacæmïnimpa,” ante tömengä mïñæ̈ në godäni ïnänite Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Itota ayæ̈, —Timönö, ëñëmi. Timönö, bitö ïmite ämopa. Waocä tömëmö ænte wancæ wancæ cæcä ontapo wææ̈ baï mïnitö ïmïnite Tatäna incæ bæi ongonte wënæ wënæ cæcæte ante angampa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wæætë, Bitö wede pönëninque nangæ̈ badämaï incæbiimpa, ante botö do edæ Wængonguï ingante apæ̈netabopa. Ïninque bitö ïñömö edæ ïincayæ̈ ate botö gämæ̈nö ocæ̈ ëmænte ponguïmi ïmipa. Pöninque, Bitö tönïñadäni wæætë tæ̈ï pïñæ̈näni bacædänimpa, ante tömënäni ïnänite godö töö æ̈mænte baï cæe. ");
INSERT INTO aucNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ante apæ̈necä ëñëninque Timönö wæætë, —Awënë ëñëmi. Bitö ïmite tee mönedäni ïninque botö do bitö tönö go guiibaïmopa. Bitö ïmite wæ̈nönäni wæ̈mi ïninque edæ botö bitö tönö do wæ̈maïmopa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ante apæ̈necä ëñëninque Itota angantapa. —Pegodo, bitö ïmite ämo ëñëe. Tawadiya ñöwoönæ ayæ̈ pedämaï ïñonte bitö botö ïmotedö apæ̈nedinque, Dicæ abogaa, ante mempoga go adopoque anguïmi ïmipa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ayæ̈ wæætë tömënäni ïnänite, —Botö wëënëñedë mïnitö ïmïnite da godöninque, Godonte æ̈inta da wente ænguincadedë æ̈nämaï inte goedäni, antabopa. Mäincoo da wente ænguï næ̈æ̈nämaï inte awæncata næ̈æ̈nämaï inte goedäni, ante botö da godömo godinque mïnitö ænguënëmïni inte wæmïnitawo. Äñongante, —Ænguënente wædämaï intamönipa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Itota wæætë tömënäni ïnänite, —Ñöwo ïñömö æcänö godonte æ̈inta da wente ænguincade mäna tömengä mänincade næ̈ænte gocæcäimpa. Ayæ̈ mäincoo da wente ænguï adobaï næ̈ænte gocæcäimpa. Ayæ̈ yaëmë mänämaï ingä inte weocoo yacoo në mäningä wacä ingante godonte æ̈ninque wæætë yaëmë godonte æncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ïïmaï ante dodäni näni yewæ̈mongaïnö baï botö ïmote cæcædänimpa. “Në ëñënämaï näni cæcabo ïñönänite tömengä adocä ïnongä ingampa, ante änänitapa,” ante yewæ̈mongatimpa. Mänömaï impa, ante pönëninque botö ïïmaï ämopa. Botö ïmote æbänö cæquïnänii, ante näni yewæ̈mongaïnö baï botö ïmote tömänö ïinque cæquïnö anguënë. Botö ïmote ante näni yewæ̈mongaïnö baï cædinque ñöwo ïñömö edæ eyepæ̈ ba aedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ante apæ̈neyongante tömënäni, —Awënë, yaëmë mëa mæ̈ ongö ae. Änänitapa. Tömengä wæætë, —Idæwaa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ïinque apæ̈nedinque Itota wadæ godinque cöwë nänö æidö baï æidinque Odibowænquidi go æiyongante tömengä mïñæ̈ në godäni tee empo æigadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Æi cöwë nänö æi ongöñömo pöninque tömënäni ïnänite, —Mïnitö ñöwo Wængonguï ingante nämä beyænque apæ̈nedinque, Mönitö wïï wënæ wënæ cæïnëmöni bacæmönimpa, ante apæ̈needäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Äninque Itota wadæ godinque dica mönö wido cæganca mäninganca godinque da guicapodinque Wængonguï ingante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Apæ̈nedinque, “Mæmpo ëñëmi. Bitö Ao äninque edæ tï nä wænguïmæ̈ baï ö ænte baï cædinque botö ïmote edæ, Wæ̈nämaï incæbiimpa, ämi ïninque botö edæ waa tobaïmopa. Incæte botö änönö baï wïï cædinque wæætë tömëmi änönö baï cæe, ämopa.” ");
INSERT INTO aucNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ante apæ̈neyongä Wængonguï öönædë nänö da pönöningä anquedo Itota weca ponte a ongöninque, Tæ̈ï pïñænte entawencæbiimpa, ante cædinque pönö töö æ̈mænte baï cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Incæte Itota ïñömö edæ nanguï wæwente badinque Wængonguï ingante ancaa apæ̈necä ïninque edæ tömengä owæ̈mæ̈ wepæ̈ gowete baï tadinque onguipoiya petæ̈ petæ̈ wææntapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ayæ̈ ïinque apæ̈nedinque tömengä ængæ̈ gantite godinque tömengä mïñæ̈ në pönïnäni weca ponte ayongä tömënäni nanguï wæwente wædinque mö ñönäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Adinque edæ tömengä tömënäni ïnänite, —Ïñæmpa möwo mömïnii. Edæ ængæ̈ gantidinque, Wënæ wënæ cæïnente badämaï incæmönimpa, ante Wængonguï ingante apæ̈needäni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ante tæcæ apæ̈neyongä nanguï ïnäni ïñontobæ̈ ponte a ongönänitapa. Itota mïñæ̈ näni, Dote, ante gocabo ïningä incæ Codaa ïñömö täno beyænte pöninque Itota ingante waa cæte baï queë bemoncæte ante pongä. ");
INSERT INTO aucNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Adinque Itota tömengä ingante, —Codaa ïñæmpa, botö Waobo ëñagaïmo ïñömote bitö, Ïingä ingampa, ante queë bemöninque odömonte pædæ godömi ænguïnänii, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mänömaï cæcæ cædänipa, ante adinque tömengä mïñæ̈ në godäni guiquënë, —Awënë, yaëmenca godö tao cæquïmöni ämii, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä ingante në cæcä ïñömö mänïñömö ponte a ongongä adinque Itota mïñæ̈ në pöningä adocanque wæætë yaëmë æ̈ninque mäningä önömonca tömëmonca ïnö wangö tamoncacä wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Adinque Itota wæætë, —Idæwaa, äninque gampo cæmoncacä waa bamoncagacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni incæ Wængonguï oncö ñæ̈næncö ante në wææ wänönäni incæ në aadäni näni Picæncabo incæ tömengä ingante æncæte ante në pönïnäni ïñönänite Itota tömënäni ïnänite, Botö mïñæ̈ në godäni tönö botö dicæ awënë ingante wido cæcæte ante cæbogaa. Incæte mïnitö, Në wido cæcä ingampa, ante baï cæmïni awædö. Edæ canta teëmenca mïni badöinca tönö yaëmë næ̈ænte botö weca pömïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ïñæmpa botö æpogadö Wængonguï oncö ñæ̈næncönë ïïmö ïñö ïïmö ïñö yabæcönë go guiidinque mïnitö weca a ongöñömote mïnitö wæætë bæi ongoncæte ante pædæ gopodämaï ïmïnitapa. Edæ ñöwo wëmö mæ̈ mämonte baï ïñonte edæ mïni në wënæ wënæ cæyedë impa, ante apæ̈negacäimpa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ïninque Itota ingante bæi ongonte ænte mäo, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä weca ænte godänitapa. Gobæ godäni ïninque Pegodo ïñömö ayæ̈ ayæ̈ gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ñæ̈næ̈ oncö yacömoyæ̈ ïñömö wææ wänönäni gonga tänonte godämæ̈ pö tæ̈ contadäni adinque Pegodo tömënäni weca pö tæ̈ contacä. ");
INSERT INTO aucNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Adinque në cæcä onquiyængä tömengä gongapamö ongongä adinque tömengä ingante cöwä adinque, —Ïingä adobaï mäningä mïñæ̈ tee empo gocä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Äñongante Pegodo, —Onquiyæ̈mi ëñëmi. Botö mäningä ingante dicæ abogaa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ayæ̈ wantæ ate wacä pöninque Pegodo ingante waa adinque, —Bitö adobaï tömengä mïñæ̈ në gobi ïmitapa töö. Ante apæ̈necä ëñëninque, —Onguïñæ̈mi ëñëmi. Botö dicæ tömengä mïñæ̈ gobogaa. Edæ wabo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ayæ̈ wacä adobaï wantæ wantæ adoque ooda go ate äninque, Ïingä ïñömö Itota mïñæ̈ në godingä ingampa. Näwangä impa. Gadideabæ quëwëningä inte edæ pongä aedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Angä ëñëninque Pegodo, —Onguïñæ̈mi, quïëmë baï apæ̈nebipa, ante botö ëñënämaï ïmopa. Ante tæcæ mënea äñongante tawadiya ïñontobæ̈ aa aa pecantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Itota incæ tömengä gämæ̈nö dadi ëmænte pömö acä adinque Pegodo ïñontobæ̈, Æ, äninque, “Tawadiya ñöwoönæ pedämaï ïñonte bitö botö ïmotedö ante wadö ate apæ̈nedinque, Dicæ abogaa, ante tededinque mempoga go adopoque anguïmi ïmipa,” ante Itota wëënëñedë apæ̈necä ëñentabopa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ñöwo nänö pequinque do pecampa, ante pönente wædinque Pegodo oncodo tao godinque Ca ca wægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Itota ingante në wææ wänönäni ïñömö tömengä ingante mänïñedë badete todinque edæ tæi tæi pänänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ayæ̈ tömengä awinca wïni cæmöninque tömënäni, —Æcänö bitö ïmite tæi tæi pänaa, ante Wængonguï apæ̈necä ëñente ate apæ̈nebi ëñëmönie. ");
INSERT INTO aucNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ante badete todinque quïëmë baï ante godö babæ änewënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ñäö bayedë, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö në odömönäni ïñömö idægoidi ïnänite në aadäni näni Picæncabo ïnönäni inte edæ godongämæ̈ go bee tëninque tömënäni näni apænte anguimpaa gäänë ongöñönäni Itota ingante tömënäni weca töö æ̈mænte ænte mäo gönönäni gongængantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tömengä ingante në apænte änäni ïñömö, —Apæ̈nebi ëñëmönie, äninque, Bitö mönitö Codito ïnömi ïmitawoo. Äñönänite Itota wæætë, —Botö apæ̈nebo ïninque mïnitö wæætë ëñënämaï ïmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ayæ̈ wæætë botö ëñencæte ante ämo ïninque mïnitö wæætë botö ïmote apæ̈nedämaï ïmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Incæte ämo ëñëedäni. Botö ïñömö në Waobo ëñagaïmo inte ïincayæ̈ ate Wængonguï në tæ̈ï Pïñængä tömëmæ̈ ïnö tæ̈ contate ongoncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ante apæ̈necä ëñëninque tömänäni, —Ïñæmpa, bitö Wængonguï Wëmi ïmitawoo. Äñönänite, —Botö mänïmodö ïmopa. Tömëmïni edæ mänömaï äninque edæ nö apæ̈nemïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ante apæ̈necä ëñëninque, —Idæwaa. Tömengä nämä incæ edæ, Wængonguï Wëmo ïmopa, ante wënæ wënæ apæ̈necä do ëñentamompa. Ïninque mönö ñöwo edæ, Wadäni, Itota wënæ wënæ cæcampa, ante apæ̈necædänimpa, ante quïnante godömenque diqui diqui minguïï, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ïninque mänïñömö ongönäni tömänäni godongämæ̈ ængæ̈ gantidinque Itota ingante awënë Pidato weca ænte gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Godinque tömënäni, Itota ïïmaï në wënæ wënæ cæcä ingampa, ante pïïninque, —Mönitö cöwä ayömöni ïingä ïñömö wapiticæ̈ odömonte apæ̈necä ëñëninque mönitö ömæ quëwënäni oda cæte ëñënämaï cædäni wæmönipa. Edæ odömäno awënë Tetædo nänö äninta godönämaï ïedäni, ante tömengä wææ angampa. Ayæ̈ tömengä, Botö ïñömö Awënë Odeye Coditobo ïnömo ïmopa, ante nämä ante angampa töö. ");
INSERT INTO aucNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ante godö pïïnäni ëñëninque Pidato ïñömö Itota ingante, —Bitö oodeoidi Awënë Odeyebi ïmitawoo. Äñongante Itota wæætë, —Bitö tömëmi änö baï botö mänïmodö ïmopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ïninque në godönäni ñæ̈næ̈näni tönö wadäni godongämæ̈ ongöñönänite Pidato wæætë, —Botö ayömote ïingä dicæ ëñënämaï cæte wentamö mongængä abogaa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ante Pidato apæ̈necä incæte tömënäni godömenque äninque, —Ïñæmpa tömengä Gadideabæ täno odömöninque ñöwo ïñömö ganca pöninque Oodeabæ tömäo godinque odömonte apæ̈necä ëñëninque waodäni edæ pïinte badäni apa cæbii, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mänömaïnö änäni ëñente wædinque Pidato wæætë, Ïingä ïñömö näwangä Gadideabæ quëwëningä inte pongantawoo. ");
INSERT INTO aucNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Äñongante, Mäningänö ingampa, ante apæ̈nedäni ëñëninque tömengä, Gadideabæ në quëwëningä inte tömengä awënë Edode nänö në ënempodongä ingampa, ante tæcæ ëñengantapa. Ayæ̈, Edode ñöwo Eedotadëë ponte quëwengampa, ante do ëñëningä inte Itota ingante Edode weca Pidato da godongä gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Doyedë ïñömö wadäni, Itota æbänö cæcää, ante tededäni ëñëninque Edode, Itota botö weca pöninque wabänö bamönengæ̈ pönï cæcä abaïmopa, ante pönëninque tömengä ingante wantæpiyæ̈ aïnengä ïnongäimpa. Ïninque Itota ingante ñöwo adinque Edode nanguï togacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ïninque, Apæ̈nebi ëñëmoe, ämi ëñëmoe, ante Edode wæætë wæætë äñongante Itota ïñömö edæ pæ wëënete apæ̈nedämaï ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Edode weca adoyömö ongöninque në godönäni ñæ̈næ̈näni tönö në odömönäni guiquënë ænguï badinque, Itota wënæ wënæ cæcä ingampa töö, ante nanguï pïinte angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ayæ̈ Edode tönö tömengä tontadoidi tönö Itota ingante pïïninque, Waa cæte baï cæcantedö abi, ante badete todänitapa. Önonque badete tocæte ante tömënäni waëmö pönï weocoo daga wëñadinque tömengä ingante adodö Pidato weca da godönäni gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ïninque do näna guëadö guëa pïincaya ïnïna inte edæ Edode tönö Pidato mänïönæ edæ guëa piyæ̈në cæte näna æ̈migocaya bagadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pidato ïñömö në godönäni ñæ̈næ̈näni tönö awënëidi tönö önönänique ïnänite äñecä pönäni ate tömengä, ");
INSERT INTO aucNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tömänäni ïnänite äninque, —Ïingä ingante botö weca ænte pöninque mïnitö, Tömengä wapiticæ̈ odömonte apæ̈necä ëñëninque wadäni oda cædinque ëñënämaï cædänipa, ante pïïmïnipa. Incæte mïnitö edonque ayömïnite botö, Itota æbänö cæcää, ante ëñencæte ante cöwä ayömo edæ tömengä wënæ wënæ nänö cædö ante mïni änewënö ante edæ dæ ä abopa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ayæ̈ Edode adobaï tömengä ingante apænte äninque wënæ wënæ nänö cædïnö ante adämaï inte wædinque adodö botö weca da pönongä ponte a ongongä aedäni. Edæ, Tömengä nänö wænguinque, ante nänö cædïnö edæ dæ ä apa änewëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ïninque botö önonque tæi tæi päninque ñimpo cæbo gocæcäimpa, ante Pidato angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wadepo ïñö wadepo ïñö tömënäni æ̈æ̈mæ̈ näni cæyedë, Në tee mönete ongongä adocanque gocæcäimpa, ante cöwë godö ñimpo cæquënengä ïnongä inte awënë Pidato ñöwo mänömaïnö ante cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mänömaïnö angä ëñëninque tömänäni adoyömö ogæ̈ tededinque, —Itota ingante wido cædinque Badabato ingante wæætë pönö ñimpo cæbi æ̈mönie, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Badabato guiquënë tömënäni näni quëwëñömö awënë ingante wido cæcæte ante cædinque godömenque waocä ingante wæ̈nöningä inte edæ ñöwo tee mönete ongönongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pidato ïñömö, Itota ingante æbänö cæte ñimpo cæbo goquingää, ante wædinque tömënäni ïnänite wæætë aa aa peyongante, ");
INSERT INTO aucNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Oodeoidi wæætë, —Awæ̈ ñænquedïmæ̈ ämi cæte gönonte wæ̈nönäni wængäe töö, ante wæætë wæætë adodö äninque Yæ änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Quïmæ̈ änewëmïnii, ante do mempoga äningä inte Pidato ñöwo mempoga go adopoque änongä inte, —Quïnö wënæ wënæ cæcantawogaa, angantapa. Ïñæmpa, Quïnö wënæ wënæ cæcantawo, ante cöwä ayömo edæ dæ ampa. Ïninque botö ämo ate edæ tömengä ingante tæi tæi päninque ñimpo cædäni gocæcäimpa, ämopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Incæte awënëidi tönö wadäni godömenque Yæ äninque, Awæ̈ ñænquedïmæ̈ ämi cæte gönonte wæ̈nönäni wæncæcäimpa, ante, Cöwë wæ̈nongæ̈impa, ante ancaa aa pedänitapa. Ïninque tömënäni näni Yæ yæ änö beyænque Pidato ñimpo cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ïninque ancaa wææ änäni ëñente wædinque tömengä, Tömënäni näni änö baï godö cæcæboimpa, ante nämäneque pönengantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mänïñedë Badabato në, Awënë ingante wido cæcæ̈impa, ante cædinque në wæ̈nöningä inte ayæ̈ tee mönete ongönongäimpa. Pidato ñöwo, Ïingä guiquënë oodeoidi näni në äningä ingampa, ante godö ñimpo cæcantapa. Itota ingante wæætë, Oodeoidi näni änö baï cæcæ̈impa, ante cædinque Itota ingante wæætë tontadoidi nempo pædæ godongä ænte godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Itota ingante ænte goyönäni Tidënebæ në quëwengä Timönö wayömö gote pöninque eyepæ̈ pönï mämö bee tengantapa. Tömengä ingante adinque bæi ongöninque tömënäni, Ñænquedïmæ̈ möni cædïwæ̈ Itota mïñæ̈ ænte goe, äninque ñö cædancapæ̈näni næ̈ænte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Goyongante Itota mïñæ̈ nanguï ïnäni godänitapa. Onquiyæ̈näni incæ Yæ yæ ante wo ca wo ca wædinque tee empote godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ïninque Itota dadi ëmænte adinque tömënäni ïnänite, —Onquiyæ̈mïni, Eedotadëë quëwëmïni inte mïnitö botö beyæ̈ ante wædämaï ïedäni. Wæætë tömëmïni nämä beyænque ante wæedäni. Ayæ̈ mïnitö wëñæ̈näni beyæ̈ ante pönente wæedäni, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ïincayæ̈ ate mïnitö caate wædinque ïïmaï ante wæquïmïni ïmïnipa. “Wëñæ̈ në mänämaï ingä ïñömö edæ tömengä nänö waa toquinque. Goömæ̈ në gänönämaï ingä ïñömö edæ tömengä nänö toquinque impa,” ante wæquïmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mänïñedë edæ, “Waodäni ïïmaï ante wæcædänimpa. Onquiyabo onguipo æ̈mæ̈wo cabæ̈ñö goyæ̈ guiimönie. Änanquidi wææ̈ mönitonga capo ñongæ̈ñö wë womonte bamönie, ante wæcædänimpa,” ante dodäni näni yewæ̈mongaïnö baï edæ bacæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Edæ awæ̈ mïïwæ̈ ïñonte gonga wædænque wo cædäni baï ñöwo ïñömö waodäni wïï nanguï wënæ wënæ cædänipa. Wæætë awæ̈ amïmö bayonte tï wodönoyönäni dobæ wo bæco baï waodäni ïincayæ̈ ate quingämë baï cæquïnäni ïnänipa, ante Itota mänïnö godinque apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ayæ̈, Mäo wæ̈nongæ̈impa, ante në ænte godäni ïñömö mënaa në wënæ wënæ cædïna ïnate tömengä tönö godongämæ̈ ænte gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ocataïnö, näni äñömö ænte pöninque awæ̈ ñænquedïmæ̈ näni badönïwäa Itota ingante töö godonte timpodinque wææ̈ tïwadinque ængæ̈ gantidënänitapa. Ængæ̈ gantidënäni ate wægöñongä tömënäni në wënæ wënæ cædïna ïnate adobaï Itota tömëmæ̈ ïnö adocanque tömengä dipæ̈mæ̈ ïnö adocanque timpote gönönäni gongæ̈natapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mänömaï cædäni adinque Itota, —Mæmpo ëñëmi. Tömënäni ëñënämaï ïnäni inte ïïmaï cædänipa cæbii. Wënæ wënæ näni cæïnö ante bitö wæætë edæ ñimpo cæbi quëwencædänimpa ämopa, angacäimpa. Mänïñedë tömengä weocoo ïnï ante, Æcänö quinca nö ta adinque tömengä badincoo æncæcäimpa, ante tömënäni wæntodöninque adocooque adocooque æ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wadäni, Æbänö cæquingää, ante acæte ante godongämæ̈ a ongönänitapa. Awënëidi incæ tömengä ingante ante badete todinque, —Tömengä, Quëwencædänimpa, ante wadäni ïnänite ængä quëwënänitawo. Ayæ̈ Wængonguï ïñömö, Codito ingampa, äninque tömengä ingante ængantawo. Ïninque tömengä Wængonguï nänö në ængaingä ïnongä inte edæ nämä aamö cæte quëwencæcäimpa, ante badete togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tontadoidi guiquënë obo pöninque tömengä ingante badete tote baï cædinque edæ, Yowepæ̈ tï nämæ̈ becæcäimpa, ante pædæ æ̈æ̈nöninque, ");
INSERT INTO aucNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tömengä ingante, —Oodeoidi Awënë Odeyebi ïmi ïninque bitö nämä aamö cædinque quëwëmäwe, ante towengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ayæ̈, “Ïingä oodeoidi Awënë Odeye ïnongä ingampa,” ante yewæ̈möninque tömënäni tömengä dæca ïnö wo cædäni owotapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Në wënæ wënæ cædïna guiquënë tömengä tönö ongöñöna adocanque tömengä ingante godö wënæ wënæ ante badete tocantapa. —Bitö ïñæmpa, Codito ïnömo ïmopa, ämitawo. Mänïmi ïnömi ïninque bitö tömëmi aamö cæte gote quëwëninque mönatö ïmönate adobaï ñimpo cæbi aamö cæte gomönae. ");
INSERT INTO aucNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Äñongante wacä wææ äninque, —Ïñæmpa tömëmi adobaï bitö wænguinque ongömi inte Wængonguï ingante guïñënämaï inte ämi awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mönatö wënæ wënæ cæmöna ïñömönate në apænte änäni edæ nöingä cæte pänäni wæmönapa. Mönatö wënæ wënæ cædïnö beyæ̈ eyepæ̈ tente wæmönapa. Tömengä guiquënë wënæ wënæ cædämaï ïnongä inte wængä apa änewëë. ");
INSERT INTO aucNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Äninque adocä wæætë Itota ingante apæ̈nedinque, Awënë ëñëmi. Bitö Awënë Odeye badinque botö ïmote pönente cæbi ämopa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Äñongante Itota, —Näwangä ämopa. Bitö ñöwoönæ incæ wænte godinque do wænte gogaïnäni näni watapæ̈ quëwëñömö botö tönö guëa ongoncæbiimpa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mänïñedë edæ tæcæbæcä ïñedë mæ̈ mämonte baï tæcæ badinque ayaönäa wæiganca tömämæ ïñömö edæ wëmö ingatimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Edæ nænque näwänämaï ï ïninque wëmö ingatimpa. Ayæ̈ Wængonguï tæiyæ̈ waëmoncönë odemö näni wææ wodöincoo adoyedë edæ önönæca ïnö tæcæguedë pönï tænguïmæ̈ wææntapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mänïñedë Itota ogæ̈ tededinque, —Mæmpo ëñëmi. Ñöwo edæ botö önöwoca bitö önönempo pædæ pönömo æ̈e. Äninque edæ æ̈mæ̈wo guëmäninque wængacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mänömaï cæte wængä adinque odömäno tontado capitäö incæ, —Näwangä impa. Ïingä ïñömö edæ nö pönï cæcä ïnongä inte edæ wængä abopa, äninque, Wængonguï ñäö apäite baï ëmönongä inte mänömaï cæcä abopa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ayæ̈, Æbänö cæquïï, ante godongämæ̈ ponte a ongönäni ïñömö tömänäni, Itota mänömaï wængä awædö, ante wædinque edæ nämä önontawë tæi tæi tompotawëninque wadæ gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wæætë Itota ingante në do adïnänique ïñömö gobæ ongonte pömö agönänitapa. Wëënëñedë tömengä Gadideabæ quëwente pöñongante onquiyæ̈näni tömengä mïñæ̈ në pönïnäni inte tömënäni ñöwo adobaï gobæ ongonte pömö agönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oodeoidi näni Apænte Äincabo ïñönänite adocanque tömengä ëmöwo Ootee ïnongäimpa. Tömengä cöwë waa cædinque në nö cædongä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Do ïñömö, Itota ingante wæ̈nongæ̈impa, ante oodeoidi näni Apænte Äincabo godongämæ̈ pönente cæyönänite adocä Ootee ïñömö edæ Baa ante tömënäni tönö godongämæ̈ cædämaï ïnongäimpa. Tömengä, Wængonguï Awënë Odeye nempo mönö æyedënö quëwengæ̈impa, ante wänö conte baï quëwënongä ïnongäimpa. Tömengä Oodeabæ Adïmatea ïñömö në quëwënongä inte ñöwo pöningä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mäningä Ootee ïñömö awënë Pidato weca do gote apæ̈nedinque, Itota wodi baö ïnï pönömi ænte daga wëmoe. ");
INSERT INTO aucNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Angä ëñëninque awënë Ao angä ëñente gocantapa. Godinque tömengä Itota wodi baö ïnï wi æmpote wææ̈ wi æ̈wadinque pædæ wææ̈nonte ænte godinque waëmö weocoo nïno näni änoncoo wïni wïni caate dicamontaa wointatodë önontatoque ïñömö daga wengantapa. Do näni wënämaï intatocæ̈ ïñonte daga wengantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oodeoidi näni, Gäwadecæ̈ ba ate guëmanguïönæ inguimpa, ante täno näni cæönæ ï ïninque Ootee mänömaï täno cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Do ïñömö Gadideabæ quëwente Itota tönö godongämæ̈ në pönïnäni inte onquiyæ̈näni ñöwo Ootee mïñæ̈ tee empote pöninque Itota wodido adinque, Tömengä baö æbänö ñö cædänii, ante do adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Adinque tömënäni oncönë godinque oguï wapæ̈ oguï wayabo tönö ænte ponte öni pæcæte ante cædänitapa. Incæte, Guëmanguïönæ impa, ante wædinque waönæ ate näni goquinque tömënäni Wængonguï nänö wææ angaïnö baï cædinque täno guëmangadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ayæ̈ guëmanguïönæ ïinque go ate baänæ ate ooque pönente bayonte mänïnäni onquiyæ̈näni oguï waquï näni cædincoo ñöwo ænte næ̈æ̈ninque Itota wodido pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ponte ayönäni dicabo ñæ̈nængade pönï do da tæ̈ñæ̈ï a öñö adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ayæ̈ ontatodë guiite ayönäni edæ mönö Awënë Itota wodi baö edæ dæ antapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Önontatoque ï awædö, ante adinque guïñente wæyönäni edënïna baï ïna ïñömö weocoo näämænta pönï näinte baï ëmoncoo mongæ̈na inte edæ ïñontobæ̈ tömëna weca a ongöna. ");
INSERT INTO aucNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ate wædinque onquiyæ̈näni ïñömö ancai guïñente wædinque ædæ wæænte onguipoga bigui tëmönänitapa. Edënïna baï ïna ïñömö onquiyæ̈näni ïnänite, —Ïñæmpa mïnitö do wæ̈nïnäni weca ponte në quëwengä ingante ante quïnante diqui diqui mïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tömengä ïñömö edæ dobæ ñäni ömæ̈monte godingä inte edæ ïintatodë ïñömö dæ angä aedäni. Tömengä wëënëñedë Gadideabæ mïnitö weca nänö ayæ̈ quëwëñedë mïnitö ïmïnite ïïmaï ante apæ̈necä ëñëmïni inte ñöwo adodö ante pönëedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tömengä ïñömö, Botö Waobo ëñagaïmo ïñömote në wënæ wënæ cædäni nempo odömonte mäo pædæ godönäni æ̈ninque tömënäni wæætë wæ̈nönäni wænguënëmo ïmopa, ante apæ̈necä ëñëmïnitapa. Ayæ̈ mëönaa go adoönæque ïñonte botö ñäni ömæ̈monte quëwenguënëmo ïmopa, ante apæ̈necä ëñëmïni inte pönenguënë quëwëedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ante edënïna baï ïna äna ëñente wædinque onquiyæ̈näni ïñömö, Itota æbänö angacäï, ante tæcæ pönente wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ïninque ontatodë tao wadæ godinque onquiyæ̈näni ïñömö Itota tömengä mïñæ̈ në godïnäni önompo tipæmpoga go adocanque ïnäni ïnänite mäo apæ̈nedinque wadäni tömänäni ïnänite apæ̈nedäni ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mänömaïnö ante Itota nänö në da godongaïnäni ïnänite në gote apæ̈nedäni ïñömö Mäadiya Mäagadadënä näni änongä tönö Wäönä, Tantiago wäänä Mäadiya ayæ̈ wadäni onquiyæ̈nänique tönö godinque tömënäni ïnänite apæ̈nedäni ëñënönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Incæte, Mänömaï impa, ante mäo apæ̈nedäni ëñëninque, Onquiyæ̈näni ïñömö önonquedö ante tededäni awædö, ante Itota nänö në da godönïnäni ïñömö edæ pönënämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pegodo guiquënë quingæ̈ ængæ̈ gantidinque pogodo godinque Itota wodido pongantapa. Ponte ædæ wææ̈ninque guiimö ayongä wïni wïni cædincooque öñö adinque tömengä nämäneque pönëninque, Æbämë cætimpa, ante wædinque wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Eedotadëë ongöninque wædænque ïnäni näni quëwëñömö Ëmao goïnö ïñömö onte quidömetodo ganca mäninganca taadö impa. Mänïönæ adoönæque ïñonte Ëmao ïñömö gocæte ante waoda mënaa idömæ godatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Æbänö cætimpa, ante tömänö ante tedegodatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tedegoyöna Itota incæ mämö bee tëninque godongämæ̈ gocä. ");
INSERT INTO aucNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Incæte, Tömengä æcänö ingää, ante wë wodonte baï ï beyæ̈ tömëna adämaï ëmöna inte ëñënämaï ïnatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Itota ïñömö, —Æbänö ante wæætedö wæætë tede gomïnatawoo. Angä ëñente wædinque tömëna wæwente baï ëmöna inte edæ næ̈ gongæ̈natapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Adocanque tömengä ëmöwo Codeopato ïñömö tömengä ingante apæ̈nedinque, —Eedotadëë quëwënäni tömänäni, Æbänö ñöwo mänïñömö cætimpa, ante ëñëñönäni bitö adobique adoyömö quëwëninque edæ ëñënämaï ïmitawoo. ");
INSERT INTO aucNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Äñongante Itota, —Ædö ämïna. Äñongä tömëna wæætë, —Itota Näatadeta quëwëningä ingante ante tedemönapa. Wængonguï beyæ̈ në apæ̈necä ïnongä inte mäningä onguïñængä ïñömö Wængonguï ayongä ayæ̈ waodäni ayönäni adobaï tæ̈ï pïñæ̈nongä inte waa pönï apæ̈nedinque nanguï cæcä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mänömaï ïñongante në godönäni ñæ̈næ̈näni tönö mönö ömæ awënëidi guiquënë wadäni nempo pædæ godöninque, Itota ingante apænte äninque mäo wæ̈nömïni wængäedäni, änäni ëñëninque ïïnäni wæætë tömengä ingante ñænquedïmæ̈ cæte timpote wææ̈ tïwadinque edæ gönönäni wængantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mönatö guiquënë, Tömengä mönö idægocabo Awënë badinque pönö ængä beyænque mönö abæ tawænte quëwenguïmö ïmompa, ante pönënïmöna inte edæ ñöwo wæmönapa. Ayæ̈, Tömënäni mänömaï näni cædïönæ edæ ñöwo mëönaa go adoönæque impa, ante edæ mönatö godömenque wæmöna ae. ");
INSERT INTO aucNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mänömaï ï incæte möni cabo incæ onquiyæ̈näni pancadäniya tömengä wodido gote pöninque, Ïïmaï atamönipa, ante apæ̈nedäni ëñente wædinque mönatö wæætë ancai guïñente wæmönapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tömënäni ïñömö tömengä baö ïnï adämaï ïnäni inte edæ wadæ pöninque ïïmaï ante apæ̈nedäni wætamönapa. Mönitö wïïmonte baï Wængonguï anquedoda ïnate mä pönï atamönipa, änänitapa. Ayömönite anquedoda ïñömö, Itota ñäni ömæ̈monte edæ mïingä quëwengampa, ante apæ̈neda ëñëninque edæ wadæ pömönipa, ante onquiyæ̈näni apæ̈nedäni ëñentamönapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mänömaïnö ante apæ̈nedäni ëñëninque möni cabo incæ pancadäniya Itota wodido gote adinque, Onquiyæ̈näni näni änïnö baï edæ näwangä impa, ante adäni incæte Itota ingante adämaï ïnäni wæmönapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ante apæ̈neda ëñëninque Itota wæætë tömëna ïnate, —Mïnatö pönëegade ï apa änewëmïnaa. Mïmö ömædëmïna ïmïna inte mïnatö Wængonguï beyæ̈ në apæ̈negaïnäni näni apæ̈nedö ante tömänö ante edæ ëñënämaï ïmïna awædö. ");
INSERT INTO aucNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Codito ïñömö edæ cöwë caate wæquënengä ingacäimpa. Ayæ̈ wænte ñäni ömæ̈möninque tömengä nämä nänö ñäö ïñömö æiquënengä ingacäimpa, ante pönëmïnaa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ayæ̈, Codito æbänö cæquingää, ante Möitee wodi æbänö apæ̈nete yewæ̈mongacäï, ante täno apæ̈nedinque Itota mïmönoque pönëninque, Wængonguï beyæ̈ në apæ̈nedäni tömänäni æbänö apæ̈negadänii, ante, Codito æbänö cæquënengä ingacäï, ante edonque odömonte apæ̈necä ëñënatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mänïï tömëna näna quëwëñömö tömëna näna gocæ cæyömö pöñönäni Itota wodo tebæ̈ gocæ cæte baï cæcä. ");
INSERT INTO aucNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Adinque tömëna nanguï äninque tömengä ingante edæ, —Ñöwo gäwadecæ̈ pönï inte wëmö ba apa. Mönatö oncönë go guiite cænte monte baänæ ate goe. Ante ancaa äñöna tömëna oncönë pö ëñacæ guiicantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ayæ̈ tömëna tönö cæncæte ante tæ̈ contadinque tömengä päö pä æ̈ninque Wængonguï ingante waa ate pönente apæ̈nedinque tömëna ïnate tæcæ pædæ godoncæ cæyongä. ");
INSERT INTO aucNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tömëna awinca wi æ̈nete baï bayö, Tömengä ingampa, ante edæ tæcæ adatapa. Tömengä ïñömö edæ adoyedë tömëna ayöna edæ dæ gocä. ");
INSERT INTO aucNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Adinque tömëna guëa tededinque, —Näwangä intawo. Wængonguï mönö Codito ingantedö ante apæ̈necä ëñëninque æbänö yewæ̈mongadänimpa, ante tömengä ponte odömongä ëñëninque mönö mïmö edæ gonga bæco baï totamompa. Wïï edæ mänömaï intawo. ");
INSERT INTO aucNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ante tededinque tömëna adodö taadö quingæ̈ godinque Eedotadëë ponte ayönate edæ Itota mïñæ̈ në godïnäni ïñömö onte ganca mänimpodäni ïñönäni tömënäni tönö wadäni godongämæ̈ pö bee tente a ongönäni adatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ïïnäni guiquënë, —Mönö Awënë ïñömö ñäni ömæ̈monte mïingä quëwengampa. Näwangä edæ impa. Tömengä ingante Timönö Pegodo do acantapa, ante godongämæ̈ tededäni adatapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mänömaïnö ante tededäni ëñëninque tömëna wæætë, Mönatö taadö goyömönate wacä pö bee tëninque ïïmaï cæcantapa, äninque, Æbänö cæcantapa, ante adodö adodö ante apæ̈nedatapa. Ayæ̈ godömenque apæ̈nedinque, Oncönë go guiiyömöni tömengä päö pä ængä adinque mönatö, Itota ingampa, ante do ëñentamönapa, ante tömänö ante apæ̈neda ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mänïnö ante ayæ̈ tæcæ tedeyönäni Itota incæ edæ tömënäni weca tæcæguedënäni do pö guiite a ongöninque, —Guïñënämaï gänë pönëedäni. ");
INSERT INTO aucNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Angä ëñëninque tömënäni, Önöwoca badï ïïmaï, ante ancai guïñente wædinque, Yæ änäni. ");
INSERT INTO aucNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Adinque Itota, —Quïnante guïñëwëmïnii. Mïmöno quïnante æ̈mæ æ̈mæ pönente wæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bado botö önompo empobo edæ aedäni. Botö önöwa ëwabo aedäni. Botö baö edæ gampo caate aedäni. Ïñæmpa önöwoca badï ïmo baï ædö cæte baö tönö bamë ëaquënëmöö. Baö tönö bamë ëadömo inte botö ïmo apa guïñëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Äninque Itota önompo tönö önöwa tömënäni ïnänite odömongä. ");
INSERT INTO aucNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Adäni incæte tömënäni guïñente todinque wede pönënämaï ïñönänite tömengä, —Mïnitö weca cænguï æbänö mämïnii. ");
INSERT INTO aucNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Äñongante gæyæ baö do awënïï ëadäni inte pædæ godönäni ");
INSERT INTO aucNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","æ̈ninque tömënäni ayönäni edæ ade cængantapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ayæ̈ tömënäni ïnänite apæ̈nedinque Itota, —Botö ïmotedö ante Möitee wodi wææ äninque æbänö yewæ̈mongacäï, ante botö mïnitö weca ayæ̈ quëwëninque do apæ̈netabopa. Botö ïmotedö ante Wængonguï beyæ̈ në apæ̈negaïnäni æbänö yewæ̈mongadänii, ayæ̈ ämotamïni äninque æbänö yewæ̈mongadänii, ante apæ̈netabopa. Mänïne botö apæ̈nedö ante tömänö edæ ïinque baquïnö anguënë. ");
INSERT INTO aucNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ante apæ̈nedinque Itota, Ocai encate ëñencædänimpa, ante pönö cædinque tömënäni ïnänite Wængonguï angä ëñëninque näni yewæ̈mongaïnö ante odömonte apæ̈necä ëñëninque tömënäni edonque edæ ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ayæ̈ godömenque apæ̈nedinque, —Mönö Codito cöwë nantate wæ̈ninque mëönaa go adoönæque ïñonte ñäni ömæ̈monguënengä incæcäimpa, ante edæ edonque yewæ̈mongatimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ayæ̈, Codito ëmöwo ante Eedotadëë ïñömö täno apæ̈nete ate tömämæ quëwënäni ïnänite ïïmaï ante apæ̈necæ̈impa. Tömënäni ïnänite apæ̈nedinque, Wënæ wënæ mïni cædïnö ante ñimpo cædinque Wængonguï gämæ̈nö pöedäni. Pömïni adinque tömengä wæætë pänämaï inte pönö ñimpo cæcæcäimpa, ante apæ̈nequïnäni incædänimpa, ante yewæ̈mongatimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mïnitö ïñömö, Æbänö cætimpa, ante në adïmïni inte edæ në apæ̈nequïmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ayæ̈ edæ Wængonguï, Botö Tæiyæ̈ Waëmö Önöwoca ingante da pönömo æncæmïnimpa, angacäimpa. Ïninque botö Mæmpo nänö në angaingä ingante botö oo da pönömo æncæmïnimpa. Mänömaï ï ïninque Wængonguï nänö tæ̈ï pïñæ̈nö æncæte ante mïnitö, Wængonguï Önöwoca ingante ëwocacæ̈impa, ante Eedotadëë ïñömö wänö cöedäni, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Itota ayæ̈ tao godinque Betänia obo pöninque tipæmpoga pædæ æmpodinque, Mïnitö ïmïnite Wængonguï waa cæcæcäimpa, ante waa apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tæcæ apæ̈necä ëñëñönäni edæ tömengä ïñontobæ̈ inque ingä edæ öönædë æigacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Adinque tömengä mïñæ̈ në godïnäni ïñömö ædæ wæænte apæ̈nedinque, Näwangä Wængonguï Wengä ïnongä inte æicampa, ante watapæ̈ apæ̈nedinque Eedotadëë wadæ godinque nanguï togadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wængonguï oncö ñæ̈næncönë yabæcönë ïïmö ïñö ïïmö ïñö pö pö cædinque Wængonguï ingante, Bitö ñäö baï ëmömi inte waa pönï cæbipa, ante cöwë waa apæ̈negadänimpa.");
INSERT INTO aucNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wëënëñedë pönï Wængonguï nänö mä badöñedë Wængonguï nänö Angaïnö ante në ëmongaingä ïñömö do ingacäimpa. Tömengä Wængonguï weca quëwengacäimpa. Ayæ̈ adocä adobaï në Wængonguï ïnongä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wëënëñedë pönï tömancoo badönämaï ïñedë mäningä do Wængonguï weca quëwengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Wængonguï angä ëñëninque adocä tömancoo badongacäimpa. Tömengä wïï badongä baï Wængonguï nänö badongaincoo tömancoo edæ dæ ancædönimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mäningä ïñömö mönö quëwenguïnö entawengacäimpa. Ayæ̈ mönö quëwenguïnö edæ entawëninque tömengä waodäni beyæ̈ në ñäö baï ïnongä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tömengä në ñäö baï ingaingä inte mönö wëmö ïñömö ta tamongä ate adoyömö ñäö baï bayonte edæ mönö wëmö ïñömö edæ mänïï ñäö ædö cæte mönæ ëmonguïï. ");
INSERT INTO aucNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Onguïñængä adocanque ingante Wængonguï da pönongä pöningä ingampa. Tömengä ëmöwo, Wäö, ante pëmonte ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tömengä ïñömö Wængonguï nänö ñäö ëmömämo ante edonque pönï bacæ̈impa, ante në ñäö baï ingaingä ingantedö ante apæ̈necæte ante pongacäimpa. Adocä apæ̈necä beyænque waodäni tömänäni tömengä nänö në apæ̈nedongä ingante pönencædänimpa, ante pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Incæte mäningä wïï ñäö baï ingaingä ingampa. Wæætë tömengä, Wacä waodäni beyæ̈ në ñäö baï ingaingä ingampa, ante apæ̈necæte ante pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Në nö ñäö baï në ingaingä ïñömö waodäni tömänäni ïnänite tömengä nänö ñäö ëmömämo pönoncæte ante inguipoga wææ̈ pongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tömengä inguipoga ïñömö quëwengacäimpa. Ayæ̈ tömengä inguipoga në badongaingä ïñongante inguipogaque quëwënäni wæætë Baa äninque tömengä ingante ædö cæte ate baï pönenguïnänii. ");
INSERT INTO aucNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tömengä edæ tömengä quï weca pongacäimpa. Pongä ate tömengä guiidënäni incæ tömengä ingante æ̈nämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Incæte tömengä ingante në ængaïnäni ïñömö tömengä ëmöwo, Codito, ante në wede pönënäni ïñönänite tömengä tömënäni ïnänite Ao äninque edæ, Wængonguï wënäni bacædänimpa, ante pönö cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ayæ̈ Wængonguï wënäni ïñömö wïï waocä ëñate baï ïnänipa. Waocä, Botö wë manguinque, ante änämaï ïñongante ëñadänipa. Wïï nänöogængä angä beyænque ïnänipa. Wæætë Wængonguï tömenganque cæcä ate tömënäni tömengä wënäni badänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tömengä ïñömö edæ, Wængonguï nänö Angaïnö, ante në ëmongaingä ïninque Waocä ëñate bagacäimpa. Waocä ëñate badinque tömengä mönö weca quëwengacäimpa. Mæmpo Wængonguï Wengä adocanque inte adocä godömenque ñæ̈nængä inte në cædongä ingä atamönipa. Adocä Mæmpo weca quëwente në pongä ïñömö tömengä nanguï waadete pönö cædongä inte nöingä änongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Wäö ïñömö, Mäningä æbänö ingää, ante apæ̈necäimpa. “Mäningä botö në apæ̈nedongä ingantedö ante ïïmaï apæ̈netabopa. Botö täno pömo ïmopa. Tömengä në ayæ̈ Ponguingä ïñömö godömenque ñæ̈nængä inte cædongä ingampa. Edæ botö ëñadämaï ïñedë tömengä do ingacäimpa,” ante nanguï pönï yedæ äninque Wäö apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mäningä në ayæ̈ Ponguingä ïñömö nanguï pönï waadete pönö cædinque tömengä wæætë wæætë nänö entawënö ante pönongä æ̈ninque tomompa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Edæ Wængonguï tömengä nänö wææ angaïnö ante apæ̈necä ëñëninque Möitee wodi wæætë adodö ante yewæ̈möninque waodäni ïnänite godongacäimpa. Wængonguï nänö waadete pönö cægaïnö ante nöingä nänö angaïnö ante guiquënë Itota Codito beyænque ëñëmompa. Itota Codito ïñömö mönö në Ponguingä ingaingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mönö waocabo tömämö incæ Wængonguï ingante cöwë adämaï ïmompa. Incæte tömengä adocanque Wengä Wængonguï weca në quëwënongä inte, Mæmpo æbänö ingaingä ingää, ante tömengä odömongä ate pönëmompa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Oodeoidi awënëidi Eedotadëë quëwënäni ïñömö Wængonguï quï, ante në godönäni tönö Debii wodi pæ̈ïnäni ïnänite da godönäni Wäö weca godänipa. Gote pöninque adodäni, Æbidö ïnömi ïmii, ante apæ̈nebi ëñëmönie, äñönäni Wäö ïïmaï äninque ");
INSERT INTO aucNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","nämä wææ änämaï inte wæætë, Botö wïï Codito ïnömo ïmopa, ante edonque pönï angantapa. —Botö wïï Codito ïnömo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Äñongante tömënäni wæætë tömengä ingante, —Æbidö ïnömi ïmii, Ediya wodi ïnömi ïmii. Apæ̈nebi ëñëmönie. Ante änäni ëñëninque tömengä, —Wabo ïmopa. Ante äñongä tömënäni wæætë, —Wængonguï beyæ̈ në apæ̈nebi ayæ̈ Ponguïmi ïnömi ïmitawo. Änäni ëñëninque tömengä, —Wabo ïmopa. Ante angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tömënäni ïinque äninque, —Æbidö ïnömi ïmii, ante apæ̈nebi ëñëmönie töö. Mönitö ïmönite në da pönönïnäni weca godinque mönitö tömënäni ïnänite, Æbidö ïmii, ante ancæmönimpa. Ïninque bitö nämä incæ æbänö ämii. ");
INSERT INTO aucNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Äñönäni Wäö wæætë tömënäni ïnänite, Itaiya wodi në Wængonguï beyæ̈ në apæ̈necä nänö angaïnö baï ante ïïmaï ante apæ̈nebo ëñencæmïnimpa. —Önömæca incæ në aa pebo ïnömo inte botö tömëmo pepämo ïïmaï näni ëñënö impa. “Awënë nänö ponguïnö ante töïnö pïnonte baï tee möedäni,” ante aa pebopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Paditeoidi në wadö tedete wadö cædäni näni cabo ïnönäni inte tömënäni pancadäniya ïnänite da godönäni Wäö weca në godänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Gote pöninque mänïnäni guiquënë, —Bitö wïï Codito ïnömi inte wïï Ediya wodi ïnömi inte ayæ̈ wïï Wængonguï beyæ̈ në apæ̈nebi ayæ̈ Ponguïmi ïnömi ïmipa. Bitö ædö cæte waodäni ïnänite æpæ̈në guidömi ïmii. ");
INSERT INTO aucNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ante äñönäni Wäö wæætë, —Botö önonque æpæ̈në guidönömo ïmopa. Wæætë mïnitö weca adocanque a ongongä ïñongante, Tömengä æcänö ingää, ante mïnitö ëñënämaï ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Botö täno pömo ïmopa. Tömengä në ayæ̈ Ponguingä ingampa. Botö önonque wædænque cæbo inte ædö cæte tömengä awæncata incæ ñï cæte cæbo ïmoo. ");
INSERT INTO aucNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betänia näni quëwëñömö Oododänö æ̈mæ̈mäa Wäö æpæ̈në nänö guidöñömö mänömaï bagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Baänæ ate Itota bee tente pongä adinque Wäö apæ̈necantapa. “Aedäni, ïingä Wængonguï da pönongä pöningä ingampa. Ayæ̈ tömengä waodäni inguipoga quëwënäni näni wënæ wënæ cægaïnö ante æ̈ninque teëmë mongænte wænguingä ingampa, ante Wængonguï tömengä ingante, Codotedo, ante pönö pemongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mäningä ïñömö botö në apæ̈nedongä ïñongante botö ïïmaï apæ̈netabopa. ‘Botö täno pömo ïmopa. Onguïñængä në ayæ̈ Ponguingä ïñömö godömenque ñæ̈nængä inte cædongä ingampa. Edæ botö ëñadämaï ïñedë tömengä do ingacäimpa.’ ");
INSERT INTO aucNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Botö incæ adobaï, Tömengä æcänö ingää, ante ëñënämaï intabopa. Mönö idægocabo ïñömonte, Mïnitö tömengä ingante ëñencæmïnimpa, ante botö æpæ̈në guidöninque pömo intabopa.” ");
INSERT INTO aucNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ayæ̈ Wäö, Tömengä ingampa, ante äninque, “Botö æ̈mö ayömote Wængonguï Önöwoca incæ öönædë owote equemö baï wææ̈ tömengäa næ̈ gongængä atabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Wængonguï, Waodäni ïnänite æpæ̈në guidöe, ante botö ïmote në da pönöningä wïï botö ïmo angä baï botö, Itota æcänö ingää, ante ëñënämaïmo incædömoimpa. Incæte tömengä botö ïmote ïïmaï angantapa. ‘Wængonguï Önöwoca incæ æcänö onguïñængäa wææ̈ næ̈ gongængä ayömi mäningä ïñömö në æpæ̈në guidönäni baï Wængonguï Tæiyæ̈ Waëmö Önöwoca ingante da pönongä waodäni mïmönoque pö guiiquingä, ante cæcä ingampa.’ ");
INSERT INTO aucNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mänïnö botö adïnö impa. Mänömaï beyæ̈ ïïmaï ämopa, Mäningä ïñömö Wængonguï Wengä ïnongä ingampa,” ante Wäö apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Baänæ ate Wäö tönö tömengä ëmïñæ̈na mënaa adoyömö ongöñönäni ");
INSERT INTO aucNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Itota wodo tebæ̈ cægongä adinque Wäö angantapa. —Aeda, tömengä ïñömö Wængonguï Codotedo ïnongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mänïnö angä ëñëninque Wäö nänö në ëmïñæ̈na ïnïna incæ Itota ingante tee empo godaimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Itota dadi ëmænte ayongä tee empo pöna adinque angantapa. —Quïnante pömïnaa. Ante äñongä tömëna wæætë, —Mäetodo, æyömönö owobi. Apæ̈nebi ëñëmönae. Änatapa. Mänïne, Mäetodo, ante mönö tededö, Në Odömongä, ante impa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Äna ëñëninque tömengä, —Ægodöeda go aeda. Äñongä tömengä mïñæ̈ godatapa. Goyöna ædæ wææ̈icä intapa. Ayæ̈ nänö owocönë gote adinque tömëna adoönæ tömengä weca a ongönapa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wäö nänö änïnö ëñëninque Itota ingante tee empo goda mënaa ïñönate adocanque Æntade ïñömö Timönö Pegodo tönïñacä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tömengä nänö tönïñacä Timönö ingante ancæte ante diqui diqui minte gote adinque angantapa. —Mëetiya mönö änongä ingante atamönapa, angantapa. Tömengä ïñömö Wængonguï nänö në Pönongaingä Codito ïnongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ayæ̈ Timönö ingante Itota weca ænte mämongä pongä adinque Itota angampa. —Bitö Wäö wë Timönömi ïmi abopa. Botö wæætë, Bitö tæ̈ïmö dicabo baï ïmipa, ante bitö ïmite mönö tededö, Quepata, pönö pemömopa. Önonque adowo ëmöwo incæ guidiego tededö, Pegodo, änänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Baänæ ate Itota, Gadideabæ ante gocæboimpa, ante pönengäimpa. Pedipe ingante adinque Itota tömengä ingante, —Botö mïñæ̈ pöe, ämo, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pedipe ïñömö Æntade tönö Pegodo baï Betaida näna quëwëñömö adoyömö quëwëningä ïnongaimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pedipe Näatänaedo weca gocä adinque tömengä ingante ïïmaï äninque, —Wængonguï nänö wææ angaïnö ante yewæ̈möninque Möitee wodi nänö në yewæ̈mongaingä ingante mönitö atamönipa. Wængonguï beyæ̈ në apæ̈negaïnäni adobaï mäningä ingantedö ante yewæ̈mongadänimpa. Tömengä ïñömö Itota Näatadeta quëwënongä inte Ootee wengä ingampa, ante angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ante äñongä Näatänaedo wæætë, —Näatadeta quëwëñömö adocanque waa quëwente pongä, ante mönitö dicæ ëñëmöniyaa. Angä ëñëninque Pedipe ïñömö, —Pö ae, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Itota ayongä Näatänaedo pongä adinque tömengä, —Ïingä ïñömö näwä idægocä ïnongä inte tömengä në nö entawënongä inte babæ cædämaï ïnongä ingampa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Angä ëñëninque Näatänaedo, —Æbänö ïmoo, ante bitö æbänö cæte do ëñëmii, Ante äñongä Itota wæætë tömengä ingante, —Pedipe ïñömö bitö ïmite ayæ̈ aa pedämaï ïñedë bitö iigowæncawa tæ̈ contabi ïñömite botö bitö ïmite do atabopa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ayæ̈ Näatänaedo, —Awënë në Odömömi ïmi, bitö Wængonguï Wëmi ïnömi ïmipa. Idægoidi mönö cabo ïñömonte bitö mönitö Awënë Odeyebi ïnömi ïmipa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Äñongä Itota wæætë, —Bitö iigowæncawa tæ̈ contabi ïñömite botö bitö ïmite atabopa, ämo beyænque pönëmi ïmipa. Mänïnö ante adinque bitö godömenque botö bamönengæ̈ cæbo acæbiimpa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tömengä godömenque angantapa. —Bitö ïmite näwangä ämopa. Öönædë wi æ̈nete bayö Wængonguï anquedoidi Waocä ëñagaingä weca wææ̈ninque æiyönäni bitö acæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mëönaa go adoönæque ïñonte Cänaa quëwëñömö Gadideabæ ïñömö monguïmæ̈no ante bedänipa. Itota wäänä adoyömö ponte ongongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Itota tömengä ëmïñæ̈näni tönö tömënäni ïnänite adobaï, Monguïmæ̈no mïni bequinque, ante të të wente ænte pongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ayæ̈ yowepæ̈ wædænque tï nämæ̈ biïnömæ̈ näni ämæ̈ dæ bedäni adinque Itota wäänä tömengä Wengä ingante, —Tömënäni biïnömæ̈ dæ ämæmpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Äñongä Itota wæætë, —Badä ëñëmï. Botö cæquënënö tömëmoque cæquïnö impa. Botö cæyedë wïï eyepæ̈ impa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tömengä wäänä ïñömö në cædäni ïnänite, —Mïnitö ïmïnite æbänö angä ëñente cæedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayæ̈ önompo æ̈mæmpoque go adocadeque æpæncade dica inte badöincade ïñömö cö cædäni ongoncadepa. Wængonguï weca guiicæte ante waëmö bacæmöimpa, ante äate cædänipa, ante oodeoidi näni äagaincade incadepa. Ïincade pancacadea otenta ditodo næ̈ ongoncadepa. Ayæ̈ pancacadea tiëë ditodo næ̈ ongoncadepa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Në cædäni ïnänite Itota, —Æpæncadecoo ïñömö æpæ̈ eyede pönï pe ñïñæ̈edäni. Angä ëñëninque pe ñïñængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ayæ̈ tömënäni ïnänite, —Owæta ænte wædænque mä iyænte monguïmæ̈no ante në cædongä ingante godömïni æncæcäimpa, ämopa. Angä ëñëninque mänömaï cægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ayæ̈ monguïmæ̈no ante në cædongä æpæ̈ ïnïmæ̈ incæ biïnömæ̈ badïmæ̈ æ̈ninque, Æbänö ïmæ̈, ante bedinque tömengä, Itota nänö badönïmæ̈ impa, ante ëñënämaï ïnongäimpa. Në cædönäni Itota weca æpæ̈ pe ñïñæ̈nänique ëñënönänimpa. Ayæ̈ monguïmæ̈no ante në cædongä ïñömö në monguingä ingante, Nänënë pöe, aa pecä pongä ate, ");
INSERT INTO aucNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ïïmaï angantapa. —Wadäni tömänäni waïmæ̈ biïnömæ̈ täno godönäni bedänipa. Ayæ̈ ate æ̈æ̈mæ̈ becæ pönäni tömo pönï bedäni adinque tömënäni biïnömæ̈ wædænque godonte näni æ̈nïmæ̈ wæætë godönäni bedänipa. Bitö guiquënë ñöwoyedë waïmæ̈ biïnömæ̈ bitö nänënë concædïmæ̈ ænte pömipa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Itota, Acædänimpa, ante mänömaï cædinque tömengä Cänaa quëwëñömö Gadideabæ ïñömö mänïï mä nänö bamönengæ̈ cægacäimpa. Mänïï tæ̈ï pïñænte bamönengæ̈ cæcä adinque waodäni, Tömengä waëmö pönï inte cæcampa, ante edonque agadänimpa. Ayæ̈ tömengä ëmïñæ̈näni ïñömö tömengä ingante godömenque wede pönënäni bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ayæ̈ ate Capënaömö quëwëñömö Itota tömengä wäänä tönö tömengä biwïidi tönö tömengä ëmïñæ̈näni tönö wææ̈ gogadänimpa. Mänïñömö godinque wædænque ëönæ quëwengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wodo pænta gogaïönæ, ante oodeoidi Patowa näni æ̈æ̈mæ̈ cænguïönæ oo pönï bayedë Itota Eedotadëë ïñömö æigacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tömengä ïñömö Wængonguï oncö ñæ̈næncönë yabæcönë pö guiidinque ayongä wagadaidi obegaidi tönö equemöidi ïnänite godonte æncæte ante në mänäni ïnänite acantapa. Ayæ̈ wadäni campio næ̈ænte në godonte æ̈nönäni ïñömö näni godonte æ̈impaa tæ̈ contayönänite tömengä acantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yæguincamë ñæ̈næ̈mömo nää wënëninque que cæte ate æ̈ninque tömengä Wængonguï oncö ñæ̈næncönë yabæcönë në ongönäni ïnänite tatodongä tao godänitapa. Adobaï obegaidi tönö wagadaidi ïnänite, Tao gobäewedäni, angä tao godänitapa. Ayæ̈ campio næ̈ænte në godonte æ̈nönäni tömënäni tiguitamö æ̈ninque tömengä wido cæcä gueogæ̈ gotimpa. Ayæ̈ adodäni näni æ̈impaa bæ tacä guidömëmæ̈ go wææntapa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ayæ̈ equemöidi godonte æncæte ante në mänäni ïnänite Itota, —Mïnitö equemöidi ænte tao gobäewedäni. Botö Mæmpo oncönë incæ mïnitö ædö cæte, Mönö godonte æ̈ïñömö baï impa, ante cæmïnitapa töö, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mänïnö angä ëñëninque tömengä ëmïñæ̈näni Awënë Dabii nänö yewæ̈mongaïnö ante ïïmaï ante pönente wædänipa. “Bitö oncö ante waodäni waa acædänimpa, ante cæcæboimpa, ante botö nanguï cæïnente wænguï wæ,” ante yewæ̈mongatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ayæ̈ oodeoidi awënëidi pancadäniya tömengä ingante, —Bitö mänïï tömää awënë baï cæbi incæ æbänö bitö bamönengæ̈ cæte odömömi adinque mönitö, Mäningä në angä ingampa, ante ëñencæmönimpa, ämönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Äñönäni Itota wæætë tömënäni ïnänite, —Wængonguï tæiyæ̈ waëmö oncö incæ mïnitö ïincö bæ tate ëwëmïni ïninque botö mëönaa go adoönæque ïñö mïincö mæ̈noncæboimpa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Angä ëñëninque oodeoidi awënëidi pancadäniya, —Wængonguï tæiyæ̈ waëmö oncö coadenta ï tei wadepo ganca mæ̈nongadänimpa. Bitö ïñömö ædö cæte, Botö mëönaa go adoönæque ïñö mïincö mæ̈noncæboimpa, ämii, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Itota ïñömö nämä baö incæ ante, Wængonguï tæiyæ̈ waëmö oncö baï impa, ante apæ̈necä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tömengä ïincayæ̈ wængä ate Wængonguï, Ñäni ömæ̈möe, angä ñäni ömæ̈mongä ate, Æbänö angacäï, ante tömengä ëmïñæ̈näni pönënänitapa. Ayæ̈, Wængonguï angä ëñente näni yewæ̈mongaïnö nö impa, ante pönënäni inte ayæ̈ Itota tömënäni ïnänite nänö änïnö ante adobaï pönengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Patowa näni æ̈æ̈mæ̈ cæyedë Itota Eedotadëë ïñömö ponte quëwëninque, Acædänimpa, ante bamönengæ̈ nanguï cæcä adinque waodäni tæiyæ̈näni ïñömö, Mäningä mönö Codito ingampa, ante pönengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Itota edæ, Waodäni tömänäni æbänö entawënäni ïnänii, ante do ëñënongä inte tömengä, Wabänö pönënänii, ante tömënäni ïnänite gomö adongä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Edæ tömengä waodäni näni entawënö ante do ëñënongä ingantapa. Ïninque waocä ïñömö, Waodäni æbänö cædänii, ante apæ̈necæcäimpa, ante Itota tömengä ingante, Bitö botö ïmo adodö ancæbiimpa, ante änämaï ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Paditeocä adocanque tömengä ëmöwo Nïicodemö tömengä ïñömö oodeoidi awënëidi tönö në godongämæ̈ cæcä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Adocä woyowotæ̈ Itota weca pöninque, —Awënë në Odömömi ëñëmi. Wængonguï, Odömoncæbiimpa, ante bitö ïmite da pönongä pönïmi ïmipa, do ëñëmönipa. Edæ Wængonguï waocä tönö godongämæ̈ cædämaï ingä ïninque mäningä ædö cæte bitö baï bamönengæ̈ cæcä aquïmönii. ");
INSERT INTO aucNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Angä ëñëninque Itota wæætë, —Bitö ïmite näwangä ämopa. Në mempoga ëñadinganque Wængonguï Awënë Odeye nempo guiite aquingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Äñongä Nïicodemö, —Waocä picængä ba ate ædö cæte mempoga ëñaquingää. Tömengä nänö wäänä cæncadë ædö cæte mempoga guii æidinque ëñaquingää. ");
INSERT INTO aucNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Angä ëñëninque Itota angantapa. —Bitö ïmite näwangä ämopa. Waocä æpæ̈në guiidengä ïñongante Wængonguï Önöwoca cæcä beyænque mempoga ëñadinganque Wængonguï Awënë Odeye nempo guiite quëwenguingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Baonga beyænque në ëñadäni ïñömö edæ baonque ëñate quëwënänipa. Wæætë Wængonguï Önöwoca cæcä beyænque në ëñadäni ïñömö Wængonguï Önöwoca ingante ëwocate quëwënänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Botö, Bitö mempoga ëñaquënëmi ïmipa, ante botö änö ëñëninque, Æbämë impa, ante änämaï incæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Woboyæ̈ nänö cægaï baï wayömö wayömö pæ̈mænte gopa. Woboyæ̈ nänö pæ̈mæ̈mämo ëñëmö incæ, Ædonö pæ̈mænte pö, ædonö pæ̈mænte go, ante ëñënämaï ïmompa. Wængonguï Önöwoca cæcä beyænque në ëñadäni tömänäni ïnänite tömengä æbänö cæcää, ante adobaï ëñënämaï ïmompa, ämopa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Apæ̈necä ëñëninque Nïicodemö, —Æbänö inguïï. ");
INSERT INTO aucNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Äñongä Itota wæætë, —Idægoidi ïnänite në odömömi ïmi incæte mänïnö ante ædö cæte ëñënämaï ïmii. ");
INSERT INTO aucNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Bitö ïmite näwangä ämopa. Mönitö quïëmë ante ëñënïmöni inte mänïnö ante apæ̈nemönipa. Mönitö quïëmë ante adïmöni ïninque, Mänömaï impa, ante apæ̈nemönipa. Mïnitö guiquënë möni änö ante apæ̈nemöni ëñëninque ayæ̈ Baa ämïni inte pönënämaï ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Botö mïnitö ïmïnite, Inguipoga quëwënäni weca æbänö ï, ante apæ̈nedïmo ïmo incæte mïnitö ëñënämaï ïmïnipa. Ïninque Wængonguï cæcä beyænque öönædë mïni quëwenguïnö ante æbänö ï, ante apæ̈nebo baï ædö cæte pönenguïmïnii, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ayæ̈ apæ̈nedinque, “Waodäni tömänäni öönædë æidämaï ingadänimpa. Waobo në ëñagaïmo inte öönædë quëwente në wææ̈ pömo ïñömö botö adoboque öönædë æibo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Möitee wodi önömæca tæntæ näni badöninto æ̈ninque awäa ñä cædinque gö cæcä a ongongatimpa. Waobo ëñagaïmo ïmote adobaï awäa timpodinque tïwadinque gö cædäni wægonguënëmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mänömaï botö ïmote cædäni adinque botö ïmote në wede pönënäni ïñömö tömänäni cöwë wæ̈nämaï quëwencædänimpa,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Edæ Wængonguï incæ inguipoga quëwënäni ïnänite në waadete pönengä inte tömengä Wengä adocanque onguïñængä ïñongante pönongä pongacäimpa. Ïninque æcänö tömengä ingante në wede pönëna ïñömö tömengä wë womönämaï inte cöwë wæ̈nämaï quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Edæ Wængonguï incæ tömengä Wengä ingante inguipoga ïñömö da pönongä pongacäimpa. Incæte, Inguipoga quëwënäni näni pante wæquinque, ante apænte ancæte ante wïï pongacäimpa. Wæætë inguipoga quëwënäni ïnänite tömengä ængä beyænque quëwencædänimpa, ante tömengä ingante da pönongä pongacäimpa.” ");
INSERT INTO aucNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Æcänö tömengä ingante në wede pönëna ïñömö Wængonguï tömengä ingante, Bitö pante wæquinque cæbipa, ante apænte änämaï incæcäimpa. Æcänö guiquënë wede pönënämaï ïna ïñömö Wængonguï tömengä ingante, Botö Wengä adocanque ïñongante bitö tömengä ëmöwo ante pönënämaï ïnömi inte wæcæbiimpa, ante do apænte angä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wængonguï nänö apænte änö ïñömö ïïmaï impa. Në ñäö baï ïnongä ïñömö, Wængonguï æbänö ingää, ante inguipoga ïñömö ancæte ante pongacäimpa. Incæte waodäni tömënäni näni cædïmämo wënæ wënæ ï beyænque wëmö ïñömö ante waadete pönënäni ïnänipa. Wæætë në ñäö baï ïnongä ingante waadedämaï ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Në wënæ wënæ cædönäni inte ñäö ïñömö ante pïïninque Baa äninque, Mönö cædïnö edonque pönï badämaï ingæ̈impa, ante ñäö ïñömö pönämaï ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Waodäni Wængonguï näwangä nänö ämaï në cædönäni guiquënë, Mönö cædïnö ante Wængonguï mönö tönö godongämæ̈ cæcä beyænque cætamompa, ante edonque pönï acædänimpa, ante cædinque ñäö ïñömö pöninque cædänipa.” ");
INSERT INTO aucNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ayæ̈ ate Itota tömengä ëmïñæ̈näni tönö Oodeabæ wædænque näni quëwëñömö godänitapa. Gote pöninque mänïñömö tömënäni tönö wædænque quëwëninque Itota angä beyænque tömënäni waodäni ïnänite æpæ̈në guidönäni guiigadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ënöö quëwëñömö æpæ̈ nanguï mæ̈ adinque Wäö mänïñömö guidongä guiigadänimpa. Ayæ̈ waodäni, Wäö mönitö ïmönite æpæ̈në guidonguingä, ante cöwë tömengä weca pönäni ïnänite guidongä guiidänimpa. Ënöö quëwëñömö Tadïï quëwëñömö eyequeï ïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mänïñedë Wäö ingante ayæ̈ tee mönedämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wäö ëmïñæ̈näni pancadäniya oodeocä adocanque tönö apæ̈nedinque, Mönö oodeocabo æbänö cæte Wængonguï weca guiicæte ante waëmö bacæmöimpa, ante tömënäni näni pönënö ante guëadö guëa ante tedewënänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Adodäni Wäö weca ponte apæ̈nedinque, —Në odömömi ëñëmi. Oododänö æ̈mæ̈mäa bitö weca në pöningä ingantedö ante bitö, Mäningä ingampa, ante apæ̈nebitawo. Edæ mäningä onguïñængä ïñömö adobaï æpæ̈në guidongä guiidänipa töö. Waodäni tömänäni tömengä weca godänipa, ante wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ante wædäni ëñëninque Wäö, —Wængonguï öönædë quëwënongä pönö angä æ̈ninque waocä mänömaï beyæ̈ cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Botö wïï Codito ïnömo ïmopa. Ïñæmpa Wængonguï botö ïmote täno da pönongä pönïmo ïmopa. Tömengä ayæ̈ Ponguingä, ante apæ̈netabopa. Mänömaïnö ante apæ̈nebo ëñënïmïni inte mïnitö tömëmïni mänïnö ante në apæ̈nequënëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Monguingä ïñömö mongä ate tömengä onquiyængä nänöogængä bacampa. Tömengä guiidengä ïñömö në monguingä ante wänö cöninque ëñëñongä monguingä apæ̈necä ëñëninque, Monguingä apæ̈necä ëñëmopa, ante watapæ̈ tocampa. Botö adobaï Codito apæ̈necä ëñëmopa, ante mäningä baï nanguï watapæ̈ tobo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tömengä ïñömö godömenque ñæ̈nængä inte cædongä baquënengä ingampa. Botö guiquënë pönömenque wædämo inte cædömo baquënëmo ïmopa, ante Wäö apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ayæ̈ Wäö godömenque apæ̈necantapa. Öönædë në quëwente wææ̈ pongä ïñömö tömengä ïñömö wïï wadäni baï wædangä inte wæætë ñæ̈nængä inte cædongä ingampa. Öönædë në quëwente wææ̈ pongä ïñömö tömengä godömenque ñæ̈nængä inte cædongä ingampa. Inguipoga ïñömö në ëñacä guiquënë waodäni baï quëwënongä inte inguipogaque ante apæ̈necampa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tömengä Wængonguï weca quïëmë adingä inte quïëmë ëñëningä inte mänïnö ante apæ̈necä ëñëninque wadäni wæætë, Näwangä impa, ante änämaï ïnänipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mänïnö ante në Ao angä guiquënë tömengä, Wængonguï näwangä angä ingampa, ante edonque pönï angä ïnongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Edæ Wængonguï nänö da pönöningä ïñömö Wængonguï nänö änö ante apæ̈necampa. Tömengä ingante Wængonguï ïñömö tömengä Önöwoca ingante godongä æ̈ninque tömengä ædæmö ëwocate quëwengampa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mæmpo Wængonguï ïñömö tömengä Wengä ingante në waadete pönengä ingampa. Wængonguï tömengä ingante, Bitö nempo quïnö ïnincoo tömancoo pönömo æ̈ninque bitö awënë bacæbiimpa, ante pönö cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Æcänö Wængonguï Wengä ingante në wede pönëna ïñömö tömengä cöwë wæ̈nämaï quëwencæcäimpa. Æcänö Wængonguï Wengä ingante në Baa ante pönënämaï ïna guiquënë tömengä wïï cöwë wæ̈nämaï quëwencæcäimpa. Edæ Wængonguï tömengä ingante ænguï nänö panguïmämo cöwë cædongä ingampa, ante Wäö mänïñedë ïinque apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Paditeoidi ïnänite ïïmaï ante tededäni ëñënänitapa. Itota pönö cædinque æpæ̈në guidongä guiidinque tömengä nänö ëmïñæ̈näni ïñömö wïï Wäö ëmïñæ̈näni baï wædænque badäni inte nanguï ïnäni badänipa, ante tededänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mänömaï änäni incæte wïï Itota në guidongä ïnongäimpa. Wæætë tömengä ëmïñæ̈näni waodäni ïnänite guidönäni guiigadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mänïnö ante Paditeoidi do ëñënänipa, ante änäni ëñëninque Awënë Itota Oodeabæ quëwëninque wadæ go Gadideabæ ïñömö ocæ̈ ëmænte gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Gadideabæ taadö Tämadiabæ ïñömö tæcæguedë ïnö godö tömengä goquënengä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tämadiabæ ïñömö godinque tömengä Ticada näni äñömö pongantapa. Mänïï Ticada quëwëñömö eyequeï docä Aacobo wodi tömengä wengä Ootee wodi ingante, Pancabaa bitö ömæ baquïñömö, ante tömengä ingante nänö godongaïmæ ïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ayæ̈ æpäamönicæ̈ Aacobo wodi nänö æ̈æ̈ wogaïmönicæ̈ adoyömö ïnimpa. Itota taadö gobæ ïnö godinque nangæ̈ badinque æpäamönicæ̈ ïñömö pö tæ̈ contayongä mänïñedë tæcæ bæcä bagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tæ̈ contate ongöñongä Tämadiabæ quëwengä onquiyængä æpæ̈ iyænte tadonte æncæte ante pongä adinque Itota tömengä ingante, —Æpæ̈ pönömi beboe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Edæ tömengä mïñæ̈ në godäni mänïnäni quëwëñömö cænguï godonte æncæ godäni ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tämadiaidi ïnänite oodeoidi cöwë gomö adäni ïnänipa, ante ëñengä inte Tämadiabæ quëwengä onquiyængä ïñömö Itota ingante, —Bitö oodeobi ïmi incæte botö Tämadiabæ quëwëmo ïñömote bitö ædö cæte botö ïmote, Æpæ̈ pönömi beboe, ämii, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Äñongä Itota wæætë, —Bitö, Wængonguï quïnö nänö pönönï ï, ante ëñente baï ayæ̈, Æbodö ïnömo inte bitö ïmite, Æpæ̈ pönömi beboe, ante apæ̈neboo, ante ëñente baï bitö wæætë botö ïmote, Æpæ̈ pönömi beboe, ancædömiimpa. Ayæ̈ botö bitö ïmite æpæ̈ quëwenguïmæ̈ pönömo becædömiimpa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Angä ëñëninque onquiyængä, —Awënë, bitö æpæ̈ mä iyæncade dæ ampa. Ayæ̈ æpäamönicæ̈ guiibæ impa. Mänïmæ̈ æpæ̈ quëwenguïmæ̈ bitö në apæ̈nedïmæ̈ ædönö mä iyænte ænguïmii. ");
INSERT INTO aucNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mönö docä mæmpo Aacobo wodi ïñömö, Botö æ̈mæ̈wo wæ̈mo adinque botö æpäamönicæ̈ mïnitö quï bacæ̈impa, ante ïïmönicæ̈ mönö ïmonte godongacäimpa. Tömengä adomönicæ̈ æpæ̈ begacäimpa. Tömengä wënäni tönö tömengä cæ̈ningäidi adobaï adopæ̈ begadänimpa. Adocä mönö docä wædangä ïñongante bitö godömenque ñæ̈næ̈mi inte në cædömi ïmitawogaa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Äñongä Itota wæætë, —Æcämenque ïñömö mänïmæ̈ bedinque wæætë gæ̈wænte bacæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Æcämenque botö godonguïmæ̈ në becä guiquënë tömengä gæ̈wæ̈nämaï cöwë quëwencæcäimpa. Wæætë botö tömengä ingante tömëmo godonguïmæ̈ godömo bedinque tömengä botö quëwënö entawente quëwencæcäimpa. Æpäamönicæ̈ cöwë cægö baï botö tömengä mïmöno godonguïmæ̈ beyænque tömengä wæ̈nämaï nänö quëwenguïnö do æ̈ninque quëwencæcäimpa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Onquiyængä tömengä ingante, —Awënë, äninque, Botö gæ̈wæ̈nämaï bacæboimpa, ante mänïmæ̈ botö ïmote pönömi beboe, ämopa. Ayæ̈ mänïñömö cöwë æpæ̈ iyæncæ pönämaï incæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ante äñongä tömengä wæætë, —Goe, bitö nänöogængä ingante aa pedinque ænte mämömi pongäe, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Äñongä tömengä wæætë, —Botö nänöogængä dæ ampa. Angä ëñëninque Itota tömengä ingante, —Bitö, Botö nänöogængä dæ angampa, äninque nö ante ämipa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ïñæmpa bitö nänöogæ̈idi önompo æ̈mæmpoque ïñönänite bitö tömënäni ïnänite mönïmi ïmipa töö. Ayæ̈ ñöwoyedë onguïñængä bitö weca në quëwengä ïñömö wïï bitö näwä nänöogængä ingampa. Ïninque ñöwo bitö änö ïñömö edæ näwangä impa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Angä ëñëninque onquiyængä, —Awënë, Bitö Wængonguï beyæ̈ në apæ̈nebi ïmi adinque ëñëmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mönitö dodäni mæmpoidi wodi, Ïï onquiyabo ïnö gote Wængonguï ingante, Bitö Awënë Wængonguï ïmidö anguënë, ante ædæ wææ̈ninque angadänimpa. Mïnitö në oodeoidi ïmïni guiquënë, Wængonguï ingante waa ate apæ̈necæte ante Eedotadëë quëwëñömö mänïñömonque godinque ædæ wæænte apæ̈necæ̈impa, ämïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Äñongä Itota wæætë, —Onquiyæ̈mi ëñëmi. Botö änö ëñëninque pönëe. Mïnitö ïñömö ædæ wææ̈ninque botö Mæmpo ingante, Bitö Awënë Wængonguï ïmidö anguënë, ante ïï onquiyabo ïnö incæ Eedotadëë mänïñömö incæ mïnitö mänïnö ante änämaï anguïönæ oo pönï impa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mïnitö tämadiaidi ïñömö në Wængonguï ingante, Bitö Awënë Wængonguï ïmidö anguënë, ante ædæ wææ̈ninque apæ̈nemïni incæte adocä ingante, Æbänö ingää, ante ëñënämaï ïmïnipa töö. Mönitö guiquënë në ædæ wææ̈ninque Wængonguï ingante waa ate apæ̈nemöni inte adocä, Æbänö ingää, ante do ëñëmöni ïmönipa. Edæ, Në wënæ wënæ cædäni wæncæ cædïnäni incæ quëwencædänimpa, ante në Ængä ïñömö oodeocä ïnongä ingä apa änewëë. ");
INSERT INTO aucNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Botö Mæmpo ingante, Bitö Awënë Wængonguï ïmidö anguënë, ante ædæ wææ̈ninque näwangä ante apæ̈nedönäni inte apæ̈necædänimpa. Adodäni, Näwangä impa, ante nö pönente ëwocadäni inte ædæ wææ̈ninque Wængonguï ingante mänïnö ante watapæ̈ apæ̈necædänimpa. Mänïnö ante näni apæ̈nequïönæ ïñömö edæ oo pönï impa. Edæ do ïinque batimpa. Wængonguï, Mänömaï entawente nö pönënäni baï ïnäni ïnänite diqui diqui mïninque, Mänïnänique botö ïmote, Bitö Awënë Wængonguï ïmidö anguënë, ante ædæ wææ̈ninque watapæ̈ apæ̈necædänimpa, angampa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wængonguï Önöwocaque ëwocate quëwengä ingampa. Ïninque në ædæ wæænte tömengä ingante watapæ̈ apæ̈nedäni ïñömö tömënäni, Näwangä impa, ante nö pönente ëwocadäni inte ædæ wææ̈ninque tömengä ingante watapæ̈ apæ̈nequënënäni ïnänipa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Angä ëñëninque onquiyængä, —Botö, Mëetiya näni Codito änongä poncæcäimpa, ante do ëñëmopa. Tömengä pongä ate, Æbänö inguïï, ante mönö ïmonte tömänö odömonte apæ̈necä ëñencæmönimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Äñongä Itota wæætë, —Botö në apæ̈nebo ïñömö Codito ïnömo ïmo apa cæbii, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tæcæ apæ̈neyongante tömengä mïñæ̈ në godäni ocæ̈ ëmænte ponte ayönäni tömengä ïñömö onquiyængä ingante apæ̈necä adinque, Æbänö cæ wæmönii, ante guïñente wædänitapa. Incæte, Æbänö ämii, ante, Quïnante tömengä ingante tedebii, ante adocanque incæ änämaï ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ayæ̈ onquiyængä tömengä iyæncade ëmö cæte näni quëwëñömö ocæ̈ ëmænte gote pöninque waodäni ïnänite apæ̈nedinque, ");
INSERT INTO aucNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ægodöedäni, onguïñængä ïñömö botö ïmote tæcæ adinque, Botö æbänö cæboo, ante tömänö ante botö ïmo në apæ̈necä ingante pö aedäni. Mäningä wabänö mönö Codito ïnongä ingantawo, ante ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Angä ëñëninque tömënäni näni quëwëñömö tao godinque tömengä weca gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Onquiyængä näni quëwëñömö tæcæ goyongä Itota nänö në ëmïñæ̈näni ïñömö tömengä ingante, —Awënë në Odömömi ïmi wædænque cæ̈e, ämönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ante äñönäni tömengä wæætë tömënäni ïnänite, —Botö cænguï botö ëadö ante quïnö ï, ante mïnitö guiquënë tömää ëñënämaï ïmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Angä ëñëninque tömengä ëmïñæ̈näni godongämæ̈ nämanque apæ̈nedinque, —Wabänö wacä tömengä ingante cænguï ænte pongantawo. ");
INSERT INTO aucNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Äñönäni Itota, —Botö ïmote në da pönongä nänö änö baï botö cædö ïñömö mänïï tömëmo cænguï baï impa. Ayæ̈, Tömengä nänö cædö ante tömänö ïinque cæbopa, ante botö cædö ïñömö botö cænguï baï adobaï impa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mïnitö ïñömö, Mëa go mëa apäicä bayonte amïñayedë tömëmoncodë gæcæmönimpa, ante wïï ämïnitawo. Botö guiquënë mïnitö ïmïnite ämopa. Waodäni ïnänite wi æ̈monte aedäni. Edæ mänïnäni tömëmoncoo gæyedë baï ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Itota, Botö beyæ̈ ante waodäni ïnänite në gædongä ingante botö, Bitö cæbipa, ante paga cædinque ñöwoyedë incæ do pönömo ængampa. Wæ̈nämaï wantæpiyæ̈ quëwencædänimpa, ante cædinque ñöwoyedë incæ tömengä tömënäni ïnänite do gædongä ingampa. Ïninque botö änö ante waodäni mïmöno në quiyadingä tönö në gædingä tönö guëa tocædaimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mänömaï wëënëñedë näni angaïnö ante, Waocä adocanque tömëmö quiyacä ate wacä guiquënë në gædongä ingampa, ante näwangä ante impa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tömëmoncodë ïñömö cædäni baï cædämaï ïmïni incæte mïnitö tömëmoncoo gæquïnäni baï bacæmïnimpa, ante botö, Waodäni botö quïnäni ïnänite gæcæmïnimpa, ante mïnitö ïmïnite da godömo gomïnitapa. Wadäni ïñömö do mänincodë nanguï pönï quiyate cædinque botö änö ante waodäni ïnänite apæ̈negadänimpa. Mïnitö guiquënë mïni cædämaï ïñömö incæ önonque gædïmïni ïmïnipa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Onquiyængä guiquënë tämadiaidi mänïñömö näni quëwëñömö quëwënäni ïnänite, “Tömengä ïñömö botö ïmote tæcæ adinque, Botö æbänö cæboo, ante tömänö ante botö ïmote apæ̈necantapa,” ante apæ̈necä ëñëninque tömënäni nanguï ïnäni Itota ingante pönengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tämadiaidi tömengä weca godinque, Bitö mönitö weca a ongöe, änäni ëñëninque tömengä mëönaa ïñonte tömënäni weca owocantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tömengä nänö owoyedë tömengä nänö änö beyænque godömenque tæiyæ̈näni ïñömö tömengä ingante wede pönente badänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Adodäni onquiyængä ingante, —Wïï bitö apæ̈nete änonque ante ëñëninque pönëmöni inte mönitö tömengä apæ̈necä adobaï ëñënïmöni ïmönipa. Ayæ̈, Mäningä ïñömö inguipoga mönö quëwencabo ïñömonte tömengä näwangä mönö ïmonte në Ænongä ingampa, ante do ëñëmönipa, apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mëönaa go ate tömengä mänïñömö quëwëninque wadæ godinque, Gadideabæ gocæboimpa, ante gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Itota incæ wëënëñedë, Ïïmaï impa, ante änongäimpa. Wængonguï beyæ̈ në apæ̈necä inte tömengä nänö pægaïmæ incæ mänïñömö apæ̈neyongä tömengä tönö pægaïnäni guiquënë tömengä ingante wïï waa adänipa töö, ante änongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tömengä mänïï Gadideabæ nänö ponque pongä adinque gadideaidi edæ Eedotadëë ïñömö Patowa näni æ̈æ̈mæ̈ cæyedë Itota baï mänïñömö gote ongöñönäni, Tömengä æbänö cæcää, ante tömää adïnäni inte, Bitö pömi waa amönipa, ante tömengä ingante apæ̈negadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ayæ̈ Gadideabæ godinque Itota wæætë Cänaa näni quëwëñömö, Æpæ̈ incæ biïnömæ̈ bacæ̈impa, ante wëënëñedë nänö cædïñömö adoyömö gocantapa. Capënaömö näni äñömö quëwëninque adocanque pancabaa awënë tönö godongämæ̈ cæcä ïñömö tömengä wëñængä onguïñængä wënæ wënæ ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Adocä onguïñængä ïñömö, Itota Oodeabæ quëwente Gadideabæ pongä, änäni ëñëninque tömengä Itota weca gote angantapa. Botö wëñængä onguïñængä wæncæ cæcä ïñongante bitö tömengä ingante cæbi waa bacäe. Ægodöe. ");
INSERT INTO aucNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Itota tömengä ingante, —Botö, Acæmïnimpa, ante bamönengæ̈ cæbo ate wæmïni inte mïnitö mänïnö beyænque botö ïmo pönëmïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ante apæ̈necä ëñëninque pancabaa awënë tönö godongämæ̈ cæcä, —Awënë, botö wëñængä ayæ̈ wæ̈nämaï ïñedë ægodöe gocæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ante äñongä Itota wæætë, —Ñöwo wadæ goe. Bitö wëñængä ïñömö quëwencæcäimpa, ämopa. Angä ëñëninque onguïñængä, Itota nänö änö nö impa, ante pönëninque wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tömengä, Botö oncö, ante taadonque goyongante tömengä beyæ̈ në cædönäni tömengä ingante apæ̈necæte ante pö bee tënänitapa. Pö bee tëninque, —Bitö wëñængä waa bacäï. ");
INSERT INTO aucNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ante apæ̈nedäni ëñëninque tömengä tömënäni ïnänite, Botö wëñængä æyedënö waa bacäï, ante äñongä tömënäni wæætë tömengä ingante, —Ïïmö ædæ gowayedë mänïñedë tömengä gancæ bacantapa, ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ayæ̈ wëñængä mæmpo, Bitö wëñængä quëwencæcäimpa, ante Itota botö ïmote nänö änïñedë adoyedë botö wëñængä do waa bacantapa, ante wædinque tömengä tönö tömengä näni quëwencabo tömancabo Itota ingante wede pönënäni bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Itota oodeoidi weca quëwente Gadideabæ ocæ̈ ëmænte pöninque tömengä mänïñömö ïï bamönengæ̈ cædinque mempoga nänö cædö bamönengæ̈ bagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ayæ̈ ate oodeoidi, Mönö Wængonguï beyæ̈, ante näni æ̈æ̈mæ̈ cæyedë Itota Eedotadëë ïñömö æidinque ado ante gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Eedotadëë wææ cæte ïñömö obegaidi näni pö guiidemö gäänë gäwapæ̈ impa. Mänïmæ̈ gäwapæ̈ ebedeo tededö Betadapæ̈ näni ämæ̈ yæwedeca önompo æ̈mæmpoque ñoncæcate ïnoncöimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mänincönë wënæ wënæ ïnäni tæiyæ̈näni cöwë öñönönänimpa. Pancadäniya babetamönäni inte pancadäniya pæ opa pæ opa godönäni inte pancadäniya cömante ïnönäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Adodäni, Æpæ̈ incæ gopæ̈, ante wänö cönönäni ïnönänimpa. Edæ Wængonguï anquedo wæætë wæætë, Mänïmæ̈ incæ incæ gopængæ̈impa, ante wææ̈ pöninque cædongäimpa. Gäwapæ̈ incæ incæ go cæpæ̈ adinque æcänö täno mänïmæ̈në guiida inte adocä quïëmë wënæ wënæ ï waa badongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mänïñömö öñönäni weca adocanque në öñönongä ïñömö todëinta ï ocho wadepo ganca wënæ wënæ inte wægaingä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Adocä mänïñömö öñongä ingante Itota ponte ayongä wadäni, Mäningä wantæpiyæ̈ mänömaï wënæ wënæ inte wægaingä ingampa, ante apæ̈nedäni ëñëninque Itota tömengä ingante, —Bitö, Waa baïnëmo, ämitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ante äñongä në wënæ wënæ ingä wæætë, —Awënë, gäwapæ̈ incæ incæ gopæ̈ñedë æcänö botö ïmote ænte guiiquïnaa edæ dæ angampa. Ayæ̈ botö, Æpæ̈në guiicæboimpa, ante goyömo wacä pöninque do täno guiicä. ");
INSERT INTO aucNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ante wæyongante Itota, —Ængæ̈ gantie, bitö bee podonte möïmo ænte goe. ");
INSERT INTO aucNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Äñongä onguïñængä ïñömö ïñontobæ̈ waa badingä inte tömengä bee podonte möïmo ænte cægonte gocantapa. Oodeoidi näni guëmanguïönæ ïñonte Itota mänömaï cæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mänömaï beyæ̈ oodeoidi awënëidi ïñömö onguïñængä në waa badingä ingante, —Ñöwoönæ guëmanguïönæ ïñonte mönö æbänö cæquïï, ante do wææ yewæ̈monte impa cæbii. Bitö bee podonte möïmo næ̈æ̈nämaï incæbiimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ante pïïñönäni tömengä wæætë, —Botö ïmote, Waa bae, ante në cædingä ïñömö adocä incæ, Bitö bee podonte möïmo ænte goe, angä cætabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Angä ëñëninque tömënäni tömengä ingante, —Mäningä ïñömö bitö ïmite, Bitö bee podonte möïmo ænte goe, ante në angä ïñömö æcänö ingää. Apæ̈nebi ëñëmönie, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Itota guiquënë do waodäni nanguï ïnäni ongönäni tæcæguedë go wadæ godongäimpa. Mänömaï beyæ̈ onguïñængä në waa badingä ïñömö, Në cædingä æcänö ingää, ante ëñënämaï ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ayæ̈ ate Itota Wængonguï oncö ñæ̈næncö yabæcönë go guiidinque tömengä ingante bee tëninque, —Ëñëmi, bitö wæætë waa babi ïmipa. Ïninque godömenque wënæ wënæ cædämaï incæbiimpa. Bitö mänïnö wënæ wënæ bitö cægaïnö ante ñimpo cædämaï ïmi ïninque wabänö bitö wæwenguinque godömenque babaïmipa, ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Angä ëñëninque onguïñængä wadæ gote oodeoidi awënëidi weca pöninque angantapa. Botö ïmote, Waa bae, ante në cædingä ïñömö Itota ingampa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mänömaï beyæ̈ Itota mänïnö nänö cædïnö ante guëmanguïönæ ïñonte cæcä adinque oodeoidi awënëidi ïñömö tömengä ingante togænte wënæ wënæ cædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Itota tömënäni ïnänite, —Botö Mæmpo ñöwoönæ ganca tömengä nänö cædö ayæ̈ cæcä ingampa. Ayæ̈ botö adobaï cæbo ïmopa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mänïnö angä ëñëninque tömënäni godömenque pïïninque, Mönö tömengä ingante æbänö cæte wæ̈nömö wænguingää, ante godömenque nanguï cægadänimpa. Tömënäni, Tömengä guëmanguïönæ ïñonte do cæcä ingampa. Ayæ̈ godömenque, Wængonguï botö Mæmpo ïnongäimpa, ante tededinque tömengä, Botö Wængonguï baï ïmopa, ante baï cæcampa töö, ante tömënäni godömenque pïingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Itota adodäni ïnänite ïïmaï äninque, “Botö mïnitö ïmïnite näwangä ämopa. Botö Wængonguï Wëmo ïnömo incæ ædö cæte adoboque nämanque cæbo ïmoo. Botö Mæmpo æbänö cæcää adinque botö adodonque cæbopa. Edæ botö Mæmpo nänö cædö baï botö Wængonguï Wëmo inte adobaï cæbopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Edæ Mæmpocä Wëmo ïñömote tömengä botö ïmote waadete pönëninque tömengä nänö cædö tömänö ante botö ïmote odömongä abo ïmopa. Ayæ̈ mïnitö, Æbänö cæcä wæmöö, ante wæcæmïnimpa, ante cædinque tömengä godömenque bamönengæ̈ nänö cædö ante botö ïmote odömongä ate botö wæætë cæbo acæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Edæ botö Mæmpo ïñömö æ̈mæ̈wo wængaïnäni ïnänite, Ñäni ömæ̈möninque mïnitö mïïmïni quëwencæmïnimpa, ante pönö cæcä baï botö tömengä Wëmo ïñömö adobaï cæbo ïmopa. Æcänö ingante, Bitö mïï quëwencæbiimpa, ante äïnëmo inte botö tömengä ingante pönö cæbo ate mïingä quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Adobaï botö Mæmpo ïñömö waodäni ïnänite adinque, Æcänö waa cæcantawo, ante, Æcänö wënæ wënæ cæcantawo, ante apænte änämaï ingampa. Wæætë edæ botö tömengä Wëmo ïñömote tömengä, Bitö mänïnö ante waodäni tömänäni ïnänite apænte ancæbiimpa, ante cægacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mänömaï cædinque botö Mæmpo, Waodäni botö ïmo näni waa abaï adobaï botö Wengä ingante tömänäni waa acædänimpa, ante cægacäimpa. Botö tömengä Wëmo ïñömote në waa adämaï ingä ïñömö tömengä botö Wæmpocä botö ïmote da pönongä ingante adobaï waa adämaï ingampa töö,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ayæ̈ apæ̈nedinque, “Mïnitö ïmïnite näwangä ämopa. Waocä botö änö ëñëninque botö ïmote në da pönongaingä ingante në wede pönengä ïñömö tömengä nänö apænte pante wæwenguïnö godämaï incæcäimpa. Wæætë tömengä nänö wæ̈nämaï quëwenguïnö gocæcäimpa. Edæ tömengä mönö æ̈mæ̈wo wænguïnö ñimpo cædinque wæ̈nämaï mönö quëwenguïnö do gocäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mïnitö ïmïnite näwangä ämopa. Waodäni në quëwënäni incæ tömënäni æ̈mæ̈wo wængaïnäni baï ïnönäni inte tömënäni ïñömö Wængonguï Wëmo botö tedepämo oo ëñencædänimpa. Ñöwoönæ tömënäni näni ëñenguïönæ do batimpa. Në ëñënäni ïñömö tömënäni näni wæ̈nämaï quëwenguïnö gocædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wængonguï nämä në quëwënongä inte tömänäni näni quëwëmämo ante në godongä ingampa. Mänömaï beyænque botö tömengä Wëmo adobaï nämä në quëwënömo inte tömänäni näni quëwëmämo ante në godömo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ayæ̈ Waobo ëñagaïmo ïñömote tömengä pönö cæcä beyænque botö në ämo badinque nämä tæ̈ï pïñænte cædinque edæ, Æcänö waa cæcantawo, ante, Æcänö wënæ wënæ cæcantawo, ante në apænte anguïmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Botö mänömaïnö ante apæ̈nebo ëñëninque mïnitö, Æbänö angä wæmöö, ante änämaï incæmïnimpa. Edæ æ̈mæ̈wo wængaïnäni tömänäni tömënäni näni wodido në öñongaïnäni ïñönänite edæ botö tedepämo incæ tömënäni näni ëñenguïönæ oo pönï impa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Botö tedepämo ëñëninque tömënäni tömänäni ta poncædänimpa. Në waa cægaïnäni ïñömö wæ̈nämaï näni quëwenguïnö näni goquinque ñäni ömæ̈moncædänimpa. Në wënæ wënæ cægaïnäni guiquënë näni apænte pante æ̈mæ̈wo wæwenguïnö näni goquinque ömæ̈moncædänimpa cæmïnii,” ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ayæ̈ godömenque apæ̈nedinque Itota ïïmaï apæ̈necantapa. “Botö ædö cæte nämanque adoboque cæbo ïmoo. Wæætë Wængonguï botö ïmote æbänö angä ëñëninque botö mänïnö ante, Æcänö waa cæcantawo, ante, Æcänö wënæ wënæ cæcantawo, ante apænte ämopa. Ayæ̈ botö apænte änö ïñömö cöwë nöïnö ante impa. Edæ botö tömëmo ämaï cædämaï ïmopa. Wæætë botö Mæmpo botö ïmote në da pönongaingä nänö ämaï cæbo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Botö nämanque äninque, Æbänö cæboo, ante apæ̈nebo baï mïnitö, Önonquedö ante impa, ancædömïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Botö æbänö cæboo, ante wacä botö beyæ̈ ante në apæ̈necä ingampa. Tömengä botö ïmotedö ante nänö apæ̈nedö ïñömö edæ nö impa, ante ëñëmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mïnitö botö ïmotedö ante, Æbänö cæcää, ante ëñencæte ante Wäö në æpæ̈në guidönongä weca wadäni ïnänite da godömïnitapa. Ayæ̈ Wäö mänïnäni ïnänite botö ïmotedö ante nö apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Botö æbänö cæboo, ante waodäni botö beyæ̈ apæ̈necædänimpa, ante botö änämaï ïmopa. Wæætë, Mïnitö botö æ̈mo beyænque quëwencæmïnimpa, ante cædinque botö mänömaïnö ante apæ̈netabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Wäö në æpæ̈në guidönongä tömengä ïñömö tï wodönoincade bæco baï ingacäimpa. Ayæ̈, Tömengä nänö angaïnö ñäö baï impa, ante adinque mïnitö wantæyö ïñonte, Waa impa, ante watapæ̈ tomïnitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Botö æbänö cæboo, ante Wäö në æpæ̈në guidönongä nänö angaïnö beyæ̈ waodäni mänïnö ante do ëwocadäni ingadänimpa. Ayæ̈ botö Mæmpo, Bitö ïïmaï cæe, ante, Tömää ïinque cæcæbiimpa, ante botö ïmote nänö angaïnö baï ante do cædömo ïmopa. Botö Mæmpo botö ïmote da pönongaingä ingampa, ante wadäni botö cædïnö beyæ̈ do ëñënänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ayæ̈ botö Mæmpo botö ïmote në da pönongaingä ïñömö adobaï, Botö æbänö cæboo, ante apæ̈necä ëñengadänimpa. Mïnitö guiquënë tömengä ingante adämaï ïmïni inte tömengä nänö tedepämo incæ cöwë ëñënämaï ïmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ayæ̈ botö Mæmpo botö ïmote da pönongä pönïmo ïmopa, ante mïnitö pönënämaï ïmïni inte edæ tömengä nänö angaïnö ante entawënämaï quëwëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Wængonguï angä ëñëninque näni yewæ̈mongainta ædæmö adömïni inte edæ mïnitö, Mänïnö näni yewæ̈mongainta amöni beyænque mönitö wæ̈nämaï möni quëwenguïnö gocæmönimpa, ante pönëmïni ïmïnipa. Ïñæmpa mänintaa yewæ̈möninque botö ïmotedö ante apæ̈nedinque yewæ̈mongadäni apa quëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Botö, Mïnitö wæ̈nämaï mïni quëwenguïnö ante pö æ̈edäni, äñömote mïnitö wæætë Baa äninque botö weca pönämaï ïmïnipa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ayæ̈ apæ̈nedinque tömengä, “Waodäni botö ïmote waa adinque apæ̈necædänimpa, ante änämaï ïmopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ïñæmpa, Mïnitö æbänö cæmïnii, ante botö do ëñëmopa. Wængonguï nänö waadete pönente entawënö mïnitö entawënämaï quëwëmïnipa, ante do ëñëmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wængonguï angä ëñëninque botö wææ̈ pönïmo adinque mïnitö Baa ante botö ïmote pönënämaï ïmïnipa. Wacä guiquënë nämä äninque pongä ïninque mïnitö mäningä ingante Ao ante pönëmaïmïnipa, ante awædö. ");
INSERT INTO aucNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mïnitö wacä ingä wacä ingä, Botö ïmote waa adinque waa apæ̈necædänimpa, ante cæmïni awædö. Incæte mïnitö, Mönö Wængonguï në adocanque ingaingä ingampa, ante, Tömengä mönö ïmonte waa adinque apæ̈necæcäimpa, ante cædämaï ïmïnipa. Mänömaï beyæ̈ mïnitö botö ïmote ædö cæte pönëmïni ïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Botö Mæmpo weca ongöninque mïnitö ïmïnitedö ante botö, Ïïnäni wënæ wënæ cædäni ïnänitapa, ante ancæboimpa, ante mïnitö pönëmïnitawo. Mänömaïnö ante edæ pönënämaï ïedäni. Wæætë Möitee wodi nänö angaïnö ëñente beyænque mönö quëwengæ̈impa, ante pönëmïnipa. Ïñæmpa adocä Möitee wodi mïni në pönënongä ïñömö, Në wënæ wënæ cæmïni ïmïnipa, ante ancæcäimpa cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mïnitö Möitee wodi ingante pönente baï adobaï botö ïmote pönencædömïnimpa. Edæ tömengä botö ïmotedö ante yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Möitee wodi nänö yewæ̈mongaïnö ante pönënämaï ïmïni ïninque mïnitö ædö cæte botö apæ̈nedö ante ëñëninque pönenguïmïnii,” ante Itota mänïñedë ïinque apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mänïnö ïinque apæ̈nete ate wantæyö ïñonte Itota wadæ godinque gäwapæ̈ Gadideapæ̈ näni ämæ̈ æ̈mæ̈mäa tao gogacäimpa. Mänïmæ̈ Tibediapæ̈ näni ämæ̈ impa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tömengä wogaa tao gocä adinque waodäni tæiyæ̈näni pö tee empo godänitapa. Tömengä, Acædänimpa, ante cædinque wënæ wënæ ïnäni ïnänite bamönengæ̈ cæte odömongä do adïnäni inte godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ayæ̈ Itota tömengä nänö ëmïñæ̈näni ïnänite änanquidi ænte mæ̈icä æidinque tömënäni tömengä tönö tæ̈ contadänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wodo pænta gogaïönæ, ante oodeoidi Patowa näni æ̈æ̈mæ̈ cæönæ oo pönï ingatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Itota gomö ayongä waodäni tæiyæ̈näni tömengä weca pönäni adinque tömengä Pedipe ingante, —Mänïnäni waodäni beyæ̈ ædönö gote päö godonte æ̈ninque godömöni cænguïnänii, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Edæ Itota ïñömö, Æbänö cæbaïmoo, ante do ëñëningä inte mänïnö ante, Pedipe æbänö cæquingää, ante acæte ante angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pedipe wæætë tömengä ingante, —Ïñæmpa päö ante tömänäni wædænque cæncædänimpa, ante ocho apäicä cæte beyæ̈ paga æ̈inta æ̈ninque mänimpota godonte æ̈ninque edæ wïï eyepæ̈ ïmaimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ayæ̈ tömengä ëmïñængä Timönö Pegodo biwï Æntade ïñömö Itota ingante, ");
INSERT INTO aucNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Mönitö weca në ongongä edëningä ïñömö tebada näni awënënïmö guiyä päö önompo æ̈mæmpoque tönö guiyä gæyæ mëa pönï næ̈ængä ingampa. Incæte mänïï cænguï tæiyæ̈näni beyæ̈ ædö cæte eyepæ̈ ï, ante wæbopa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Angä ëñëninque Itota, —Mïnitö tæiyæ̈näni godongämæ̈ ongönäni ïnänite ämïni tæ̈ contaedäni, angantapa. Tömengä nänö ämaï änäni ëñëninque waodäni önömæcaque ïnö nanguï gaguïmæ̈ pæyömö do tæ̈ contadänitapa. Onguïñæ̈näni incæ önompo æ̈mæmpoque mïido ganca ïnäni inte tæ̈ contadäni ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Itota päö æ̈ninque, Wængonguï, Bitö waa pönï pönömi ænte cænguïmöni, ante apæ̈nedinque tömengä nänö ëmïñæ̈näni ïnänite godongä æ̈ninque tömënäni wæætë tæ̈ contadäni ïnänite di mæ̈ñæ̈näni cæ̈nänitapa. Ayæ̈ tömengä gæyæ æ̈ninque adobaï cæcantapa. Tömänäni ïñömö näni cæ̈ïnënö ante eyepæ̈ cængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tömënäni tömo pönï cæ̈näni ate tömengä ëmïñæ̈näni ïnänite tömengä, —Cænguï näni ao mæ̈ ao mæ̈ ñönönï ee öñoncoo wote badämaï ingæ̈impa, ante pædæ wææmpo ö æ̈edäni. ");
INSERT INTO aucNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Angä ëñente cædinque në cæ̈näni päö önompo æ̈mæmpoque tebada näni awënënïmö näni ao mæ̈ ao mæ̈ ñönönï ee öñoncoo ö ænte da wënäni ate edæ otodë tipæmpoga go mentodëa cænguï eyede da wënäni contagatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Waodäni ïñömö Itota bamönengæ̈ nänö cædï adinque, —Näwangä ïingä ïñömö Wængonguï beyæ̈ në apæ̈necä ingampa. Tömengä inguipoga Ponguingä, ante näni angaingä ïnongäimpa, ante tæcæ änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tömënäni, Bitö mönitö Awënë Odeye bacæbiimpa, ante botö ïmote bæi ongoncæte ante poncæ cædänipa, ante wædinque Itota wadæ godinque adocanque änanquidi wæætë æigacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gäwadecæ̈ pönï bayö tömengä ëmïñæ̈näni ïñömö gäwapæ̈ yæwedeca wæi gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Itota angä ëñëninque mänïñömö wæi wipodë guiidinque tömënäni, Gäwapæ̈ æ̈mæ̈mäa Capënaömö näni quëwëñömö mönö taocæ̈impa, ante tæcæ wogaa tao goyönäni dobæ wëmö bayö Itota ayæ̈ tömënäni weca pönämaï ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ayæ̈ woboyæ̈ nanguï pæ̈mænte pöñö æpæ̈ mæ̈ conta mæ̈ conta cæyonte, ");
INSERT INTO aucNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tömënäni wodo tinco quidömetodo wiyate cæyönäni Itota ïñömö wipo gämæ̈nö pöninque æpæ̈ yædopæ̈ wæ̈nömënæcapæ̈ dao dao pongä adinque ancai guïñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ancai guïñëñönänite Itota ïñömö tömënäni ïnänite, —Botö ïmopa. Guïñënämaï ïedäni, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ante äñongä tömënäni Ao ante tömengä ingante wipodë æ̈ninque tömënäni näni goïnëñömö ëmönaiya do tao gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ïïmö ate tæiyæ̈näni gäwapæ̈ ïmæ̈ wedeca a ongönönänimpa. Ïninque tömënäni, Wipo adoque pönï mänïñömö wäï wocæ̈ incæte Itota ïñömö mänimpodë guiidämaï ïñongante tömengä mïñæ̈ godäni adodänique guii wadæ tao godänitapa, ante adinque wædänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Awënë Itota do Wængonguï ingante, Bitö waa pönï pönömi cænguïmöni, ante apæ̈necä ate waodäni näni päö cæ̈nïñömö pancadäniya ayæ̈ ongönänimpa. Ñöwo ïñömö wapocoo Tibedia näni quëwëñömö wo cæwodinque mänïñömö tömënäni näni cæ̈nïñömö eyequeï pönäni adänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ïninque Itota tönö tömengä nänö ëmïñæ̈näni edæ dæ änäni wædinque tæiyæ̈näni ïñömö wipodë guiite Capënaömö godinque Itota ante diqui diqui mincæte ante wogaa gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Adodäni gäwapæ̈ æ̈mæ̈mäa tao godinque tömengä ingä adinque, —Awënë në Odömömi ïmi æyedënö ïñömö pömitawo, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Äñönäni Itota wæætë, —Mïnitö ïmïnite näwangä ämopa. Mïnitö tömo pönï päö cæ̈nïmïni inte botö ïmote ante diqui diqui mincæ pömïnitapa töö. Wæætë edæ botö, Acæmïnimpa, ante bamönengæ̈ cæbo beyæ̈ mïnitö wïï pömïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mïnitö, Mönö cænguï, ante æncæte ante cæmïni incæte inguipogaque mïni woquïnonque ante æncæ cædämaï quëwëedäni. Wæætë edæ, Mönö cænguï ïinque bayedë cænguï mæ̈ öñongæ̈impa, ante cædinque mïnitö, Mönö wæ̈nämaï quëwenguinque gocæmöimpa, ante pönente quëwëedäni. Botö në Waobo ëñagaïmo ïmo mänïï cænguï mïnitö ïmïnite pönömo æncæmïnimpa. Botö Mæmpo botö ïmotedö ante, Ïingä nö cæcä ingampa, ante odömongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Angä ëñëninque tömënäni tömengä ingante, —Mönitö, Wængonguï nänö cæquïmämo ante cæcæte ante quïnö cæquënëmöni ïmönii, ante wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Äñönäni Itota wæætë, —Botö Wængonguï nänö në da pönongaïmo ïñömote mïnitö botö ïmote mïni wede pönënö ïñömö edæ mänïnö Wængonguï nänö cædö impa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mänömaï beyæ̈ tömënäni godömenque tömengä ingante, —Bitö, Ëñencædänimpa, ante bamönengæ̈ bitö cædö ante æbänö cæte odömömi adinque pönëmaïmönipa. Æbänö cæquïmii, ante änewënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mönö wæ̈mæ̈idi önömæca näni quëwëñedë cænguï mänää näni angaï cængadänimpa. Ïïmaïnö ante yewæ̈mongatimpa. “Tömengä, Mïnitö cænguï, ante tömënäni ïnänite öönædë ïnö mäwææ̈ godongacäimpa,” ante näni yewæ̈mongaïnö baï impa, ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Itota wæætë tömënäni ïnänite, —Näwangä ämopa. Mïnitö ïmïnite öönædë mäwææ̈ cænguï në pönongaingä ïñömö tömengä wïï Möitee wodi ingacäimpa. Wæætë botö Mæmpo ïñömö tömengä mïnitö ïmïnite öönædë näni näwä cænguï baï pönongä cæncæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Öönædë quëwente wææ̈ pongaingä ïñömö tömengä ïñömö, Cænguï baï ingampa, ante Wængonguï nänö në angaingä ingampa. Adocä inguipoga quëwënäni ïnänite, Mïni wantæpiyæ̈ wæ̈nämaï quëwenguïnö ante pönongä æ̈ninque quëwënänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ante Itota apæ̈necä ëñëninque tömënäni, —Awënë, ñöwo mänïï cænguï ïïmö ïñö ïïmö ïñö pönömi cæ̈mönie. ");
INSERT INTO aucNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Äñönäni Itota godömenque apæ̈nedinque, —Botö ïñömö, Mïni quëwenguinque, ante mïni cænguï baï ïnömo ïmopa. Botö weca në pongä ïñömö cöwë cænguï gue æ̈nënämaï baï quëwencæcäimpa. Ayæ̈ botö ïmote në wede pönengä ïñömö cöwë tepæ̈ gæ̈wæ̈nämaï baï quëwenguingä ingampa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ayæ̈ wæætë, Mïnitö ïmïnite do botö änö baï impa. Botö ïmote do adïmïni incæte mïnitö ayæ̈ wede pönënämaï ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Botö Mæmpo, Bitö quïnäni bacædänimpa, ante cædinque botö ïmote pönongä æ̈mo ïninque botö quïnäni në badäni inte tömënäni tömänäni ïñömö botö weca edæ do pönänipa. Ayæ̈ æcämenque botö weca pöna ïnate, Botö weca pönämaï ïmipa, ante cöwë änämaï incæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Edæ öönædë quëwëninque botö wïï tömëmo ämaï cæcæboimpa, ante wææ̈ pontabopa. Wæætë botö ïmote në da pönongaingä nänö ämaï cæcæboimpa, ante wææ̈ pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ayæ̈ botö ïmote në da pönongaingä botö ïmo nänö angaïnö ïñömö ïïmaï impa. Waodäni bitö quïnäni bacædänimpa, ante pönömo æ̈ninque bitö quïnäni badinque adocanque incæ wë womonte wæ̈nämaï incæcäimpa. Wæætë ïinque baquïönæ ïñonte bitö, Ñäni ömæ̈möedäni, ämi ëñëninque bitö quïnäni tömänäni edæ ñäni ömæ̈moncædänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Edæ botö Mæmpo nänö angaïnö ïñömö ïïmaï impa. Botö Wængonguï Wëmo ïñömote botö ïmote ædæmö adïnäni inte edæ botö ïmote në pönënäni tömänäni cöwë wæ̈nämaï wantæpiyæ̈ quëwencædänimpa. Mänömaïnö ante impa. Ayæ̈ ïinque baquïönæ ïñonte botö mänïnäni ïnänite, Mïnitö ñäni ömæ̈möedäni, ämo ate ömæ̈moncædänimpa. Itota mänömaï apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Apæ̈necä ëñëninque oodeoidi ïñömö, Tömengä, “Botö cænguï baï ïmopa, ante öönædë ïnö wææ̈ pontabopa,” angampa, ante tömengä ingantedö ante tæcæ pïinte tedewënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tömënäni, —Ïingä ïñömö wïï Ootee wengä Itota ingantawo. Tömengä mæmpo tönö wäänä wïï mönö adöna ïnatawo. Tömengä ædö cæte, Botö öönædë quëwente wææ̈ pontabopa, angä änewëë. ");
INSERT INTO aucNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ante pïïñönäni Itota wæætë, —Mïnitö nämanque godongämæ̈ pïinte tededämaï ïedäni. ");
INSERT INTO aucNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Botö Mæmpo botö ïmote në da pönongaingä wïï pönö cæcä baï æcämenque incæ botö weca pönämaï incædongäimpa. Ayæ̈ ïinque baquïönæ ïñonte botö weca në pongä ingante, Ñäni ömæ̈möe, ämo ñäni ömæ̈moncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wængonguï beyæ̈ në apæ̈negaïnäni näni yewæ̈mongaintaa ïïmaï ante yewæ̈mongadänimpa. “Wængonguï waodäni tömänäni ïnänite odömonte apæ̈necä ëñencædänimpa.” Botö Mæmpo apæ̈necä në ëñënäni ïñömö tömengä nänö odömonte apæ̈nedö ante në ëñënäni ïnönäni ïninque tömënäni tömänäni botö weca pönänipa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ayæ̈ apæ̈nedinque, “Mïni waocabo tömämïni incæ botö Mæmpo ingante cöwë adämaï ïmïnitapa. Botonque ïñömö Wængonguï weca në quëwente pömo inte botö Mæmpo ingante në adïmo ïñömö adoboque pönï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mïnitö ïmïnite näwangä ämopa. Botö ïmote në wede pönengä ïñömö tömengä cöwë wantæpiyæ̈ nänö quëwenguïmämo do entawente quëwengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Botö ïñömö, Mïni quëwenguinque, ante mïni cænguï baï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mïni wæ̈mæ̈idi önömæca quëwëñedë cænguï mänää näni angaï cængaïnäni incæte edæ do wængadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Botö ïñömö cænguï baï ïnömo inte öönædë quëwente wææ̈ pömo ïmopa. Ïninque waocä, Cænguï cænte baï quëwengæ̈impa, ante botö ïmote pönengä ïninque tömengä cöwë wæ̈nämaï quëwëmaingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Botö cænguï baï ïmo inte öönædë quëwengaïmo incæ wææ̈ pontabopa. Æcänö cænguï cænte baï botö ïmote pönëna tömengä ïñömö cöwë wæ̈nämaï quëwencæcäimpa. Ïï cænguï botö godonguï botö nämä baö impa. Inguipoga quëwënäni ïnänite, Mïnitö quëwenguïmïni, ante botö nämä baö incæ godoncæboimpa,” ante Itota mänömaï apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mänïnö angä ëñente wædinque oodeoidi näni cabo ïñömö godongämæ̈ nämanque tededinque wæætë godö wæætë godö änewënänitapa. —Mäningä ïñömö mönö ïmö tömengä nämä baö ædö cæte pönongä cænguïmönii. ");
INSERT INTO aucNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ante tedewëñönäni Itota wæætë tömënäni ïnänite, —Mïnitö ïmïnite näwangä ämopa. Botö Waobo ëñagaïmo ïñömote mïnitö botö baö cæ̈nämaï inte botö wepæ̈ bedämaï ïmïni ïninque ædö cæte Wængonguï wantæpiyæ̈ nänö quëwenguïmämo entawëmïni inguïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Botö baö në cængä ayæ̈ botö wepæ̈ në becä tömengä ïñömö Wængonguï wantæpiyæ̈ nänö cöwë quëwenguïmämo do entawente quëwengä ingampa. Ayæ̈ ïinque baquïönæ ïñonte botö mäningä ingante, Bitö ñäni ömæ̈möe, ämo ñäni ömæ̈moncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Edæ botö baö näwä cænguï baï impa. Ayæ̈ botö wepæ̈ näwä bequï baï impa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Botö baö në cængä inte ayæ̈ botö wepæ̈ në becä ïñömö tömengä botö nempo ee quëwënongä ingampa. Ayæ̈ adobaï tömengä botö ïmote entawënongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Botö Mæmpo në Quëwënongä inte botö ïmote da pönongä pönïmo ïmopa. Tömengä pönö cæcä ate quëwëmo ïmopa. Botö ïmote në cængä ïñömö adobaï botö cæbo beyænque quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Botö cænguï baï ïmo inte öönædë wææ̈ pönïmo ïñömö mänïï cænguï baï ïmopa. Mönö wæ̈mæ̈idi cænguï mänää näni angaï cængaïnäni incæ edæ do wængadänimpa. Wæætë ñöwo wææ̈ pömo ïñömote, Cænguï impa, ante në cæ̈nongä ïñömö tömengä cöwë wæ̈nämaï quëwencæcäimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tömengä mänïnö ante Capënaömö näni quëwëñömö näni odömöincönë ongöninque tömënäni ïnänite odömonte apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mänïnö odömonte apæ̈necä ëñëninque tömengä ëmïñæ̈näni nanguï ïnäni, —Tömengä nänö odömonte apæ̈nedïnö ïñömö waadedämaïnö impa. Edæ æcänö ëñëmaïnaa, ante änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mänïnö nänö odömonte apæ̈nedïnö ante tæcæ pïinte tedewënäni wædinque Itota tömënäni ïnänite, —Mïnitö botö änïnö ante oda cæmïni inte pïïmïni ïmïnitawo, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ayæ̈ godömenque apæ̈nedinque, Botö Waobo ëñagaïmo ïmo öönædë quëwente wææ̈ pongaïmo inte adodö adoyömö æibo adinque mïnitö æbänö ante ämaïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wængonguï Önöwoca pönö cæcä beyænque waocä quëwengä ïninque tömengä baonque nänö ëñayö beyænque ædö cæte quëwëmaingää. Botö Wængonguï Önöwoca tönö apæ̈nedinque mïnitö ïmïnite botö apæ̈nedïnö beyæ̈ mïnitö önöwoca ëwocate quëwencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Incæte mïnitö weca pancadäniya ïñömö botö ïmo pönënämaï ïnänipa töö, ante Itota apæ̈necantapa. Edæ tömënäni weca æcänö tömengä ingante pönënämaï ingää, ante Itota do ëñënongäimpa. Ayæ̈ tömengä ingante në godö odömonguingä æcänö ïmaingää, ante tömengä adobaï do ëñënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Itota godömenque apæ̈nedinque, —Botö mänïï beyæ̈ mïnitö ïmïnite do antabopa. Botö Mæmpo wïï pönö cæcä baï æcämenque incæ botö weca pönämaï incædongäimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mänïönæ ganca tömengä mïñæ̈ në godäni incæ nanguï ïnäni wadæ godinque tömengä mïñæ̈ ayæ̈ tee empo godämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tömënäni wadæ godäni adinque Itota önompo tipæmpoga go mëa ganca ïnäni ïnänite, —Mïnitö diyæ̈ æbänö cæquïmïnii. Mïnitö tömënäni baï adobaï botö ïmote ëmö cæte, Wadæ goïnëmönipa, ämïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Äñongä Timönö Pegodo wæætë, —Awënë, æcänö mïñæ̈ gobaïmönii. Wacä mönitö ïmönite në ëmïñængä ïñömö edæ dæ angampa. Wantæpiyæ̈ wæ̈nämaï möni quëwenguïnö ante æbänö gocæmönimpa, ante wæyömöni bitö ïñömö në apæ̈nebi ïmipa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bitö ïñömö Wængonguï nänö da pönönömi inte tömengä nänö Tæiyæ̈ Waëmö ïnömi ïmipa, ante pönëmöni inte ëñëmönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ante apæ̈necä ëñëninque Itota, —Mïnitö önompo tipæmpoga go mëa ganca ïmïni inte wïï botö apænte æ̈nömïni ïmïnitawo. Incæte mïni cabo incæ adocanque ïñömö wënæ quï ingampa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Timönö Icadiote wengä Codaa ingantedö ante Itota mänömaï angacäimpa. Tömengä önompo tipæmpoga go mënaa näni cabo adocanque ïnongä incæte ayæ̈ ate Itota ingante odömonte në godonguingä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ayæ̈ ate Itota Gadideabæ tömämæ wayömö wayömö gocä ingacäimpa. Oodeabæ ïñömö oodeoidi awënëidi botö ïmote wæ̈noncæ cædänipa, ante wædinque Itota, Oodeabæ wïï goïnëmopa, ante mänïömæ godämaï ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Oodeoidi, Mönö wæ̈mæ̈idi oncontaicoo mæ̈nöninque quëwengadänimpa, ante pönëninque tömënäni æ̈æ̈mæ̈ oo pönï ingatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Itota biwïidi tömengä ingante, —Bitö ëmïñæ̈näni bitö bamönengæ̈ cæbi acædänimpa, ante cæcæte ante bitö ïñömö ongönämaï inte wæætë Oodeabæ goquënëmi ïmipa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Waodäni tömänäni ayönäni cæbo edonque acædänimpa, ante cæïnengä ïñömö tömengä wïï awëmö cæcampa. Bitö mänïï cædïnö do cæbi inte waodäni tömänäni bitö ïmite edonque pönï acædänimpa, ante odömonte cæe, ämönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Edæ tömengä biwïidi incæ tömengä ingante pönënämaï ïnäni ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mänömaï beyæ̈ Itota tömënäni ïnänite, —Botö wïï ñöwo goquënëmo ïmopa. Mïnitö guiquënë æyedëmë gomïni incæ cöwë waa impa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Inguipogaque quëwënäni mïnitö ïmïnite ædö cæte pïinte badänii. Wæætë botö tömënäni ïnänite, Mïnitö wënæ wënæ cæmïni ïmïnipa, ante apæ̈nebo beyæ̈ tömënäni botö ïmo pïïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mïnitö æ̈æ̈mæ̈ cædäni weca æite goedäni. Botö goquïönæ wïï eyepæ̈ impa, ante pönëninque botö ayæ̈ mänïmæ̈ cædäni weca godämaï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mänïnö äninque tömengä godömenque Gadideabæ ongonte quëwengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Incæte tömengä biwïidi æ̈æ̈mæ̈ ante godäni ate tömengä adobaï godinque wïï waodäni näni ayömö gocampa. Wæætë awëmö gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayæ̈ näni æ̈æ̈mæ̈ cæyömö oodeoidi awënëidi ïñömö, —Mäningä onguïñængä æyömönö ingää, ante tömengä ingante ante diqui diqui minte wææ wänönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tæiyæ̈näni ponte a ongönäni godongämæ̈ nämä tededinque tömengä ingantedö ante wæntæ wæntæ tededänitapa. Pancadäniya, “Tömengä waa cæcä ingampa.” Äñönäni wadäni ïñömö, “Baa, mäningä waodäni ïnänite wapiticæ̈ mäodinque, Oda cæquïnänimpa, ante cæcä ingampa,” ante apæ̈nedönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Oodeoidi awënëidi ïnäni adinque guïñente wædinque wadäni tömänäni tömengä ingantedö ante waodäni ëñëñönäni apæ̈nedämaï ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tömënäni æ̈æ̈mæ̈ do cæyedë Itota ïñömö Wængonguï oncö ñæ̈næncönë yabæcönë æite pö guiidinque waodäni ïnänite mä odömonte apæ̈necä ëñengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tömengä odömonte apæ̈necä ëñëninque oodeoidi ancai guïñëninque, —Æbänö cæte nanguï ëñengä ingää. Edæ tömengä ecoeda adämaï ïnongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Äñönäni Itota wæætë, —Botö odömonte apæ̈nedö ante wïï nämä pönëninque odömonte apæ̈nebo ïmopa. Wæætë Wængonguï botö ïmote në da pönongaingä nänö angaïnö ante odömonte apæ̈nebopa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mïnitö, Wængonguï nänö angaïnö ante Itota odömonte apæ̈necampa, ante pönëmïnitawo. Wæætë, Nämä pönëninque Itota odömonte apæ̈necampa, ante pönëmïnitawo. Ïñæmpa waocä, Wængonguï nänö ämaï cæcæboimpa, ante æcänö änaa tömengä ïñömö, Æcänö angä ëñëninque Itota odömonte apæ̈necää, ante do ëñencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Në nämä pönëninque apæ̈necä ïñömö tömengä nämä ante, Botö ïmo waa acædänimpa, ante aïnente apæ̈necä ingampa. Wæætë edæ, Botö ïmo në da pönongainganque ingante waa acædänimpa, ante në aïnente cæcä ïñömö tömengä edæ në nö cæte quëwënongä ingampa. Adocä, Waodäni oda cæquïnänimpa, ante tömënäni ïnänite wïï wapiticæ̈ mäocä ingampa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ayæ̈ apæ̈nedinque, “Wængonguï nänö wææ angaïnö ante Möitee wodi wïï mïnitö beyæ̈ ante yewæ̈mongacäï. Incæte mïnitö tömämïni Wængonguï nänö wææ angaïnö adinque ëñente cædämaï ïmïnipa töö. Mïnitö quïnante botö ïmote, Wæ̈nöïnëmönimpa, ante pönëninque cæmïnii.” ");
INSERT INTO aucNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ante awënëidi ïnänite äñongante nanguï ïnäni adoyömö ongönäni wæætë, —Bitö wënæ tönö cæbi ïmipæ̈æ̈, ante tömengä ingante äninque, Bitö ïmite æcänö wæ̈nöïnente cæcää. ");
INSERT INTO aucNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ante änäni ëñëninque Itota godömenque tömënäni ïnänite, —Guëmanguïönæ ïñonte botö adopoque bamönengæ̈ cæbo adinque mïnitö tömämïni ancai guïñente wæmïnipa edæ. ");
INSERT INTO aucNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Möitee wodi ïñömö, Mïnitö wëñængä ëñacä ate önompo æ̈mæmpoque go mëönaa go adoönæque ïñonte mänïönæ tömengä yabæque ëö togæncæmïnimpa, ante mïnitö ïmïnite odömonte apæ̈negacäimpa. Wïï Möitee wodi mänömaï mä cæcä ingacäimpa. Wæætë wëënëñedë incæ mïnitö wæ̈mæ̈idi do adodö cægadänimpa. Incæte Möitee wodi, Mänïönæ ïñonte ëö togæncæmïnimpa, ante pönö angä beyænque mïnitö guëmanguïönæ ï incæte mïnitö wëñængä onguïñængä ingante ëö togæ̈mïni ïmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Möitee wodi nänö wææ yewæ̈mongaïnö wido cædämaï ingæ̈impa, ante cædinque mïnitö guëmanguïönæ ïñonte edæ wëñængä onguïñængä ingante do ëö togæ̈mïnipa. Incæte edæ guëmanguïönæ ïñonte botö wënæ wënæ ïningä ingante ämo ate tömengä baö tömäñö waa bacä beyænque quïnante botö ïmote pïïmïni ïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Waocä wabänö nänö cædï wënæ wënæ ï, ante pönëninque ædæmö ëñënämaï ïmïni inte mïnitö tömengä ingä, Bitö wënæ wënæ cæbi ïmipa, ante apænte änämaï ïedäni. Wæætë, Æbänö ï, ante ædæmö ëñëninque nöingä ante ancæmïnimpa, ante Itota mänömaï apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mänömaï beyæ̈ Eedotadëë quëwënäni pancadäniya, —Mäningä ingante wæ̈nömöni wæncæcäimpa, ante awënëidi wïï änänitawo, ante mänïñedë tæcæ tedewënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aedäni, tömengä ïñömö edonque pönï a ongöninque waodäni ïnänite apæ̈neyongä incæ mönö awënëidi tömengä ingante änämaï pæ wëënete ïnänipa töö. Tömënäni wabänö, Mäningä ïñömö näwangä Codito mönö änongä ingampa, ante pönënänitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ïñæmpa, Mäningä onguïñængä æyömönö quëwente pongä ingää, ante do ëñëmöpa. Mönö Codito, Në Ponguingä, ante näni angaingä ïñömö æyömönö quëwente pongää, ante mönö waocabo tömämö incæ ëñënämaï inguïmö ïmompa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ayæ̈ Itota Wængonguï oncö ñæ̈næncönë yabæcönë odömonte apæ̈nedinque aa pecantapa. —Ao, Botö æbodö ïmoo, ante mïnitö ëñëmïniyaa. Ayæ̈ botö, Æyömönö quëwente pömoo, ante mïnitö adobaï ëñëmïniyaa. Botö wïï nämä pönëninque pontabopa. Botö ïmote në da pönongaingä näwangä ïnongä ingampa. Mïnitö, Tömengä æbänö ingää, ante ëñënämaï ïmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Botö wæætë edæ tömengä weca quëwëmo ïñömote tömengä botö ïmote da pönongä pönïmo inte edæ botö ïñömö edæ tömengä ingante do agaïmo ïnömo ïmopa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mänïnö angä ëñëninque tömënäni, Quïnö cæte tömengä ingante bæi ongonguïmönimpa, ante pönengadänimpa. Incæte tömengä nänö wænguïönæ wïï eyepæ̈ ï beyæ̈ tömengä ingante ö æ̈nämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tæiyæ̈näni adoyömö pö ongönäni weca ongöninque nanguï ïnäni tömengä ingante wede pönënänitapa. Tömënäni, —Mäningä onguïñængä ïñömö nanguï bamönengæ̈ cæcä ïnongäimpa. Mönö Codito ïñömö tömengä pongä ate godömenque bamönengæ̈ cæquingä ingantawogaa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tæiyæ̈näni mänïñömö ongönäni ïñömö Itota ingantedö ante mänömaïnö ante wæntæ wæntæ tedeyönäni Paditeoidi ëñënänitapa. Ayæ̈, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö Paditeoidi ïñömö Wængonguï oncö ñæ̈næncö wææ wänönäni ïnänite, Mïnitö goedäni. Tömengä weca godinque tömengä ingante bæi ongonte ænte pöedäni, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Itota godömenque apæ̈nedinque, —Mïnitö weca wantæyö quëwëninque botö ayæ̈ ate botö ïmote në da pönongaingä weca ocæ̈ ëmænte gocæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Botö ocæ̈ ëmænte gobo ate mïnitö botö ïmote ante diqui diqui mïmïni incæte adämaï inguïmïni ïmïnipa. Ayæ̈ botö go quëwëñömö mïnitö adoyömö ædö cæte ponguïmïni ïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Angä ëñëninque oodeoidi awënëidi nämanque tededänitapa. —Mäningä, Gocæboimpa, ante ædönö goyongante mönitö diqui diqui mïninque adämaï inguïmöni ïmönii. Tömengä, Edæ mönö guiidënäni do panguïmæ̈ godinque guidiegoidi weca wayömö wayömö näni quëwëñömö tömengä wabänö goquingää. Ayæ̈ guidiegoidi mänïñömö quëwënäni ïnänite odömonte apæ̈nebo ëñencædänimpa, ante apæ̈nequingää. ");
INSERT INTO aucNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tömengä ïñæmpa, “Botö ïmote ante diqui diqui mïmïni incæte mïnitö botö ïmote adämaï inguïmïni ïmïnipa, angampa töö. Ayæ̈, Botö go quëwëñömö mïnitö adoyömö dicæ ponguïmïniyaa,” ante mänïnö ante æbänö ante apæ̈necantawo, angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ayæ̈ tömënäni näni æ̈æ̈mæ̈ ïinque cæönæ ïñonte, Ñæ̈næ̈ æ̈æ̈mæ̈ impa, ante godömenque nanguï cæyönäni Itota ïñömö ængæ̈ gantidinque yedæ yedæ tedecantapa. —Në gæ̈wænte wæcä ïñömö tömengä botö weca poncæcäimpa. Ayæ̈ botö tönö godongämæ̈ becæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Æcämenque botö ïmote në wede pönengä ïñömö tömengä quëwenguïmæ̈ ænte entawencæcäimpa. Ayæ̈ waëmö æpæ̈ tayömö ta gote cægömæ̈ baï tömengä adobaï tömengä nänö entawënö godonte baï cædinque, Wadäni bete baï quëwencædänimpa, ante godö cæcæcäimpa. Wængonguï angä ëñente näni yewæ̈mongaïnö baï ante mänömaïnö ante impa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mänömaïnö ante Itota ïñömö, Botö ïmote në wede pönënäni inte ayæ̈ ate Wængonguï Önöwoca ingante ænte entawenguïnäni ïnänipa, ante pönëninque mäningä Wængonguï Önöwoca ingantedö ante apæ̈negacäimpa. Edæ Itota ayæ̈ wæ̈nämaï inte öönædë ocæ̈ ëmænte æidämaï nänö ïñedë Wængonguï ïñömö Tæiyæ̈ Waëmö Önöwoca ingante ayæ̈ da pönönämaï ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mänïnö nänö änö ëñëninque waodäni pancadäniya, —Näwangä impa. Mäningä ïñömö, Wængonguï beyæ̈ në apæ̈necä në Ponguingä, ante näni angaingä adocä ïnongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ante äñönäni wadäni guiquënë, —Mönö Codito në Ponguingä, ante näni angaingä mäningä ingampa. Änäni ëñëninque wæætë wadäni, —Mönö Codito ædö cæte Gadideabæ quëwente pongä ingää, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ïñæmpa mönö Codito ïñömö Awënë Dabii pæ̈ingä inguingäimpa. Ayæ̈ Bedëë Dabii nänö quëwengaïñömö adoyömö ëñaquingä ingampa, ante Wængonguï angä ëñente näni yewæ̈mongaïnö ongö adämaï ïmïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Angä ëñëninque waodäni, Itota æcänö ingää, ante mänömaï wadö wadö ante pönente tedewengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pancadäniya, Tömengä ingante bæi ongöïnëmönipa, änäni incæte tömengä ingante bæi ongonte æ̈nämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wængonguï oncö tæiyæ̈ waëmö oncönë wææ wänönäni ïñömö, Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö Paditeoidi weca ocæ̈ ëmænte pönänipa. Ocæ̈ ëmænte pönäni adinque tömënäni, —Quïnante tömengä ingante ænte pönämaï ïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ante äñönäni wææ wänönäni wæætë, —Mäningä onguïñængä waa apæ̈necä baï æcänö adobaï tedecä ïñömö edæ dæ angampa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Änäni ëñëninque Paditeoidi guiquënë, —Tömengä mïnitö ïmïnite adobaï wapiticæ̈ mäocä oda cæte gobaïmïni bamïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Äninque tömënäni godömenque, Awënëidi incæ Paditeoidi incæ adocanque tömengä ingante pönengä ingantawogaa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nanguï ïnäni ïñömö ongönäni guiquënë tömënäni në önönänique inte Wængonguï nänö wææ angaïnö ante ëñënämaï ïnäni inte tömengä ingante pönënäni ïnänipa. Mänömaï beyæ̈ tömënäni Wængonguï nänö pangaïmämo ante wæquïnäni ïnänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nïicodemö ïñömö wëënëñedë Itota weca në godingä adobaï tömënäni baï Paditeocä ïnongä inte apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Waocä, Æbänö cæboo, ante nämä beyæ̈ wææ änämaï ïñongante mönö, Tömengä ingante pangæ̈impa, ante ædö cæte apænte anguïï. Edæ, Wææ änämaï ïñongante pangæ̈impa, ante dicæ wææ yewæ̈mongadänïñaa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ante äñongä tömënäni, —Bitö adobaï Gadideabæ quëwente ponte baï tedebipæ̈æ̈. Wængonguï beyæ̈ näni yewæ̈mongainta ae. Adinque bitö, Wængonguï beyæ̈ në apæ̈necä wïï Gadideabæ quëwente pongä ingampa, ante do ëñencæbiimpa, ante angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mänïnö änäni ate tömänäni oncönë ocæ̈ ëmænte gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Itota guiquënë Odibowænquidi näni anquidi gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ïïmö ate ñäö bayedë tömengä Wængonguï oncö ñæ̈næncönë yabæcönë wæætë pö guiicä adinque waodäni tömänäni tömengä nänö ongöñömö goto pönäni adinque Itota tömënäni ïnänite odömonte apæ̈necæte ante tæ̈ contacantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mänïñedë onquiyængä adocanque tömengä nänöogængä ïnämaï ïñongante wacä onguïñængä tönö tæcæ godö guëa mongä adäni ate në odömönäni tönö Paditeoidi ïñömö mäningä onquiyængä ingante ænte pönänitapa. Tömengä ingante tæcæguedë gö cædäni ongöñongä ");
INSERT INTO aucNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","tömënäni Itota ingante, —Awënë në Odömömi ïmi, ïingä onquiyængä ïñömö wacä ingante tæcæ godö guëa mongä adäni wæmönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wængonguï nänö angaïnö ante Möitee wodi ïïmaï ante wææ yewæ̈mongacäimpa. Onquiyæ̈näni mäningä onquiyængä baï cædäni ïñönänite mïnitö tömënäni ïnänite dicaca tacamïni wæncædänimpa. Bitö guiquënë quïnö ämii. ");
INSERT INTO aucNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mänïnö ante tömënäni ïñömö, Æbänö apæ̈necää, äninque, Wabänö pancadea wapiticæ̈ tedecæcäimpa, ante cædänitapa. Edæ wapiticæ̈ tedecä ïninque mönitö, Adocä wënæ wënæ cæcä ingampa, ante ancæmönimpa, ante cædänitapa. Itota guiquënë ædæ wææ̈ninque onguipoga tömengä önongompoga yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tömënäni godömenque tömengä ingante ëñencæte ante äñönäni Itota ængæ̈ gantite tömënäni ïnänite, —Mïnitö weca adocanque ongöninque në wënæ wënæ cædämaï ingä ïninque mäningä täno onquiyængä ingante, Wænguïmi, ante dicaca tacacæcäimpa, ante angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Äninque wæætë ædæ wææ̈ninque onguipoga yewæ̈mongacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mänïnö angä në ëñënäni ïñömö adocanque wadæ go wacä wadæ go wacä wadæ go tömänäni wadæ godänipa. Picæ̈näni täno wadæ godäni ayæ̈ wadäni wadæ godänitapa. Tömänäni dæ godäni adinque Itota adocanque ee ongöñongä onquiyængä ayæ̈ adoyömö næ̈ gongængantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Itota ængæ̈ gantidinque onquiyængä ingante, —Æyömönö ïnänii. Bitö ïmite apænte äninque tacadämaï ïnänitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Äñongä tömengä wæætë, —Awënë, tömänäni mänömaï cædämaï ïnänitapa. Angä ëñëninque Itota, —Botö adobaï bitö ïmite apænte äninque tacadämaï incæboimpa. Ñöwo goe ämopa. Bitö wënæ wënæ cæte quëwënïmämo ñimpo cæte waa quëwëe, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ayæ̈ Itota wæætë waodäni ïnänite apæ̈nedinque, —Botö ïñömö inguipoga quëwënäni beyæ̈ ñäö baï ïmodö anguënë. Æcänö botö mïñæ̈ tee empo goda tömengä wëmö ïñömö cöwë cægönämaï ingampa. Wæætë tömengä nänö quëwënö taadö edonque acæcäimpa, ante botö tömengä beyæ̈ ñäö baï ïmopa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Paditeoidi guiquënë tömengä ingante, —Bitö ïñömö nämä äninque, Æbänö ïmoo, ante apæ̈nebi ïmipa töö. Mänömaï nämanque ante apæ̈nebi beyæ̈ bitö änïnö önonquedö ante impa, ämönipa, pïïnänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Itota wæætë, —Botö ïñömö nämä äninque, Æbänö ïmoo, ante apæ̈nebo incæ botö apæ̈nedö näwangä impa. Edæ, Botö æyömönö quëwente pömo ïmoo, ante ayæ̈, Ædönö gobo ïmoo, ante do ëñëmopa. Mïnitö guiquënë, Botö æyömönö quëwente pömoo ïmoo, ante ayæ̈, Ædönö gobo ïmoo, ante wïï ëñëmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Waodänique, Ïïmaï cæedäni, ante näni wææ ante cægaï baï mïnitö wacä ingante apænte ämïni ïmïnipa. Botö guiquënë waodäni tömänäni ïnänite adinque, Æcänö waa cæcantawo, ante, Æcänö wënæ wënæ cæcantawo, ante apænte änämaï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Incæte botö mänömaï apænte ämo baï, Æbänö apænte ämoo, ante pönëninque tömëmo nö ante apænte ämopa. Edæ wïï botonque apænte ämopa. Wæætë botö Mæmpo botö ïmote në da pönongaingä ïñömö tömengä ïñömö botö tönö godongämæ̈ cæcä ate apænte ämopa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mïnitö mïni wææ yewæ̈mongaintaa ïïmaï ante wææ yewæ̈mongatimpa. Mënaa onguïñæ̈na në adïna inte tömëna näna adïnö ante apæ̈neda ëñëninque mïnitö wæætë, Nö impa, ante ëñencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Botö ïñömö nämä äninque, Æbänö ïmoo, ante apæ̈nebo ïmopa. Ayæ̈ botö Mæmpo botö ïmote në da pönongaingä ïñömö tömengä botö ïmotedö ante, Æbänö ingää, ante adobaï apæ̈necä ëñencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Angä ëñëninque tömënäni tömengä ingante, —Bitö Mæmpo æyömönö quëwengää. Äñönäni Itota wæætë, —Mïnitö ïñömö, Botö incæ æbänö ïmoo, ante, Botö Mæmpo incæ æbänö ingaingä ingää, ante ëñëmïni ïmïnitawogaa. Botö æbodö ïmoo, ante ëñëmïni inte baï mïnitö, Botö Mæmpo æbänö ingaingä ingää, ante adobaï ëñëmïni incædömïnimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Itota Wængonguï oncö ñæ̈næncönë yabæcönë go guiidinque, Wængonguï quï, ante näni da wencade gäänë ongonte apæ̈nedinque mänïnö ante apæ̈negacäimpa. Incæte tömengä nänö wænguïönæ wïï oo pönï ï beyænque tömengä ingante bæi ongonte æ̈nämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Itota wæætë tömënäni ïnänite äninque, —Botö wadæ goquïmo ïmopa. Gobo ate mïnitö botö ïmote ante diqui diqui minguïmïni ïmïnipa. Mïnitö wënæ wënæ cædömïni inte wæncæmïnimpa. Botö goquïñömö mïnitö ædö cæte ponguïmïnii, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mänïnö beyæ̈ oodeoidi awënëidi, Tömengä ïñömö, Botö goquïñömö ante mïnitö ædö cæte ponguïmïnii, ante quïnante angää. Tömengä nämä incæ, Wæ̈nonguïmo, ante pönëninque ïïmaï angantawo, ante änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Itota godömenque, —Mïnitö ïñömö inguipoga quëwëmïni ïmïnipa. Botö guiquënë öönædë quëwente pömo ïmopa. Mïnitö ïñömö ïï inguipogaque näni quëwencabo tönö adomïni ïmïnipa. Botö guiquënë ïï inguipogaque näni quëwencabo tönö adobo ïnämaï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mänömaï beyæ̈ botö, Mïnitö wënæ wënæ cædömïni inte wæncæmïnimpa, ante mïnitö ïmïnite apæ̈netabopa. Botö, Æbänö ïmoo, ante ämo ëñëninque pönënämaï ïmïni ïninque mïnitö wënæ wënæ cædömïni inte nö wæ̈maïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ante apæ̈necä ëñëninque tömënäni, —Æbidö ïmitawo. Ante äñönäni Itota wæætë, —Botö do mïnitö ïmïnite, Æbodö ïmoo, ante në änïmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Botö mïnitö ïmïnitedö ante nanguï anguënëmo ïmopa. Mïnitö ïmïnitedö ante ämo baï mänïï botö änö mïni apænte anguinque ïmaimpa. Incæte botö ïmote në da pönongaingä ïñömö tömengä nöingä inte tömengä, Quïnö botö ïmote angää, ante botö ëñënïnö ante botö adodö ante inguipoga quëwënäni ïnänite apæ̈nebo ïmopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Incæte tömënäni, Itota tömengä Mæmpo ingantedö ante mönitö ïmönite apæ̈necampa, ante ëñënämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mänömaï beyæ̈ Itota, —Botö Waobo ëñagaïmo ïñömote mïnitö botö ïmote awäa timpodinque tïwadinque gö cæmïni wægöñömo mïnitö mänïñedë edæ, Botö æbodö ïmoo, ante ëñencæmïnimpa. Ayæ̈ botö nämä pönëninque cædämaï ïmopa. Wæætë Wæmpo nänö odömonte apæ̈nedö ante botö ïmote apæ̈necä botö ëñënïnö ante adodö ante apæ̈nebopa, ante mïnitö adobaï mänïñedë ëñencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Botö ïmote në da pönongaingä botö ïmote ëmö cædämaï inte cöwë botö tönö godongämæ̈ ongongä ingampa. Edæ botö cöwë, Æbänö cæbo ate tömengä waa aquingää, ante cæbopa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mänïnö äñongä nanguï ïnäni ïñömö tömengä ingante pönengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Oodeoidi pancadäniya në pönënäni ïñönänite Itota ïñömö, —Mïnitö cöwë botö odömonte apæ̈nedïnö baï cæmïni ïninque botö mïñæ̈ nö gomïni ïmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ayæ̈ botö änö nöïnö impa, ante ëñencæmïnimpa. Mänïnö nö botö änö beyænque mïnitö ñimpo cæte quëwencæmïnimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ante äñongä tömënäni wæætë, —Mönitö ïñömö Abadäö nänö pæ̈ïmöni ïmöni inte mönitö cöwë waocä æcämenque beyænque në cæmöni ïnämaï intamönipa töö. Bitö ïñömö, Wacä beyænque mïnitö godömenque cædämaï inte ñimpo cæte quëwencæmïnimpa, ante ædö cæte ämii. ");
INSERT INTO aucNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Äñönäni Itota wæætë, Mïnitö ïmïnite näwangä ämopa. Në wënæ wënæ cæcä ïñömö tömengä wacä beyænque cæte në quëwengä baï wædongä inte edæ tömengä nänö wënæ wënæ cægaïnonque ante cædinque ædö cæte aamö cæte goquingää. ");
INSERT INTO aucNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wacä beyænque cæte në quëwengä ïñömö tömengä awënë näni wencabo tönö wïï cöwë godongämæ̈ quëwengä ingampa. Awënë wengä guiquënë tömengä mæmpo tönö näna wencaya ïna beyænque tömengä awënë tönö cöwë guëa quëwengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mänömaï beyæ̈ Wængonguï Wengä mïnitö ïmïnite ñimpo cæcä ïninque mïnitö nö ñimpo cæte quëwëninque wacä beyænque në cæcä baï ïnämaï inte quëwenguïmïni ïmaïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mïnitö ïñömö Abadäö nänö pæ̈ïmïni ïmïnipa, ante do ëñëmopa. Incæte botö änö ante mïmönë entawënämaï quëwëmïni beyæ̈ mïnitö botö ïmote, Wæ̈nömöni wæncæcäimpa, ante pönëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Botö ïñömö botö Mæmpo weca tömëmo adïnö ante mïnitö ïmïnite apæ̈nebo ïmopa. Mïnitö guiquënë mïni mæmpo nänö angaïnö mïni ëñënïnö ante cæmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ante apæ̈neyongä tömënäni wæætë, —Abadäö mönö docä mæmpo ingaingä ingampa. Änäni ëñëninque Itota, —Mïnitö nö Abadäö wëmïni inte baï mïnitö tömengä nänö cægaïnö baï adobaï cæcædömïnimpa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ñöwo ïñæmpa botö, Wængonguï näwangä nänö angaïnö ante botö ëñënïnö ante mïnitö ïmïnite në apæ̈nebo ïñömote mïnitö, Mönitö æbänö cæte wæ̈nömöni wænguingää, ante pönëmïni ïmïnipa. Abadäö mänïï mïni cægaï baï cædämaï ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mïnitö ïñömö tömëmïni mæmpo nänö cægaï baï adobaï cædömïni ïmïni awædö. Äñongante tömënäni, —Mönitö wïï wegöwæ̈ wëmöni ïmönipa töö. Wængonguï incæ tömengä adocanque mönitö Mæmpo ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Änäni ëñëninque Itota tömënäni ïnänite, —Wængonguï näwangä mïnitö Wæmpocä ingä baï mïnitö botö ïmote waadete pönencædömïnimpa. Edæ botö Wængonguï weca quëwente mïnitö weca ñöwo wææ̈ pontabopa. Botö wïï nämä pönëninque pontabopa. Wæætë tömengä botö ïmote da pönongä pongaïmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mïnitö ïmïnite botö quïnö apæ̈neboo, ante mïnitö quïnante ëñënämaï ïmïnii. Edæ botö änö ante, Quïnö apæ̈neboo, ante mïnitö babetamö ïnäni baï ïnömïni inte ædö cæte ëñenguïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Wënæ ïñömö mïnitö mæmpo ïnongäimpa. Ayæ̈ mïnitö mæmpo nänö cæïnëwënö ante mïnitö adodö ante, Mönitö cæïnëmönipa, ante cæmïnipa. Wëënëñedë inguipoga mä badöñedë tömengä, Botö wæ̈nonguïmo, ante do entawengä ingacäimpa. Tömengä, Quïnö näwangä impa, ante cöwë änämaï ingampa. Ayæ̈ edæ, Quïnö änö nöïnö impa, ante tömengä entawënämaï ïnongäimpa. Adocä babæ tededinque tömengä babæ nänö entawënonque ante tedewengä ingampa. Edæ tömengä në babæ änongä ingampa. Ayæ̈ tömengä ïñömö mä babæ angaingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Incæte botö näwangä ämo beyænque mïnitö botö änö ante pönënämaï ïmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mïnitö weca ongongä ïñömö æcämenque incæ botö ïmote apænte äninque, Bitö wënæ wënæ cæbi ïmipa, ante, Näwangä impa, ante odömönatawogaa. Botö näwangä ämo baï mïnitö quïnante botö angaïnö ante pönënämaï ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wængonguï wënäni në ïnönäni ïñömö Wængonguï nänö angaïnö ante ëñënäni ïnänipa. Mïnitö guiquënë tömengä wëmïni ïnämaï ïmïni beyæ̈, Tömengä quïnö angää, ante ëñënämaï ïmïnipa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Oodeoidi wæætë tömengä ingante, —Bitö Tämadiabæ quëwëmi ïmipæ̈æ̈. Ayæ̈ wënæ tönö cæbi ïmipæ̈æ̈, ante wïï näwangä ämöni intamönii. ");
INSERT INTO aucNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ante pïïnäni ëñëninque Itota wæætë apæ̈nedinque, —Botö wïï wënæ tönö cædömo ïmopa. Wæætë botö ïñömö, Botö Mæmpo ingante waa acæboimpa, ante cæbo ïmopa. Mïnitö guiquënë botö ïmote waa adämaï ïmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Waodäni, Bitö waëmö ïmipa, ante botö ïmote apæ̈necædänimpa, ante botö cædämaï ïmopa. Wæætë wacä ïñömö, Waodäni bitö ïmite apæ̈nedinque, Waëmö ïmipa, ante apæ̈necædänimpa, ante në cæcä ingampa. Mäningä në apænte änongä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mïnitö ïmïnite näwangä ämopa. Botö angaïnö ante në ëñente cæcä tömengä ïñömö wantæpiyæ̈ wæ̈nämaï quëwencæcäimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ante apæ̈necä ëñëninque oodeoidi, —Bitö wënæ tönö cæbi ïmipa, ante ñöwo ædæmö ëñëmönipa. Abadäö wodi ïñæmpa do wængacäimpa. Ayæ̈ Wængonguï beyæ̈ në apæ̈nedäni adobaï do wængadänimpa. Incæte bitö, “Botö angaïnö ante në ëñente cæcä tömengä ïñömö wantæpiyæ̈ wæ̈nämaï quëwencæcäimpa, ante apæ̈nebi töö.” ");
INSERT INTO aucNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mönö docä mæmpo Abadäö wodi ñæ̈nængä inte cægaingä incæte bitö ïñömö edæ, Abadäö wædangä ïñongante botö ïñömö godömenque ñæ̈næ̈mo inte cædömo ïmopa, ämitawo. Tömengä ïñömö edæ do wængacäimpa. Ayæ̈ Wængonguï beyæ̈ në apæ̈nedäni adobaï do wængadäni apa änewëë. Bitö nämä äninque, Æcämë baï ïmoo, ante ämi. ");
INSERT INTO aucNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Äñönäni Itota wæætë, —Botö nämä äninque, Waodäni, Bitö waëmö ïmipa, ante botö ïmote apæ̈necædänimpa, ante ëñëïnente wæbo baï waodäni botö ïmote näni waa apæ̈nedö wæætë önonquedö ante incædönimpa. Botö Mæmpo incæ mïnitö, Mönö Wængonguï ingampa, ante mïni änongä guiquënë tömengä ïñömö, Bitö waëmö ïmipa, ante botö ïmote pönö apæ̈necä apa quëwëmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mïnitö tömengä ingante wïï adinque pönënämaï ïmïnipa töö. Botö guiquënë tömengä ingante do agaïmo inte pönëmo ïmopa. Botö tömengä ingante adämaï ïmopa, ante baï botö mïnitö baï babæ ante ancædömoimpa. Wæætë tömengä ingante do adinque në pönengaïmo inte botö ïñömö edæ tömengä nänö angaïnö baï në cæbo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Inguipoga botö ponguïönæ ante mïnitö docä mæmpo Abadäö wodi incæ, Codito ponguïönæ pongä acæboimpa, ante pönëninque do edæ watapæ̈ togacäimpa. Ïninque tömengä mänïönæ Codito nänö ponguïönæ adinque godömenque togacäimpa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Oodeoidi tömengä ingante, —Bitö ëñagaï ïñömö tincoenta wadepo ïnämaï ï incæte bitö ædö cæte, Botö Abadäö ingante atabopa, ante ämii. ");
INSERT INTO aucNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ante pïïñönäni Itota wæætë, —Mïnitö ïmïnite näwangä ämopa. Abadäö wodi ayæ̈ ëñadämaï ïñedë botö ïñömö edæ do quëwëmo ingaïmo ïmopa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mänïnö ante apæ̈necä ëñëninque tömënäni ïñömö tömengä ingante dicaca tacacæte ante cædinque dicacoo wææmpo æ̈nänitapa. Incæte Itota wë womöninque Wængonguï oncö ñæ̈næncodo tao wadæ gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Itota gomonga godinque onguïñængä babetamö ëñagaingä ingante acantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tömengä ëmïñæ̈näni ïñömö tömengä ingante, —Awënë në Odömömi ïmi, mäningä onguïñængä incæ tömengä mæmpoda incæ æcänö wënæ wënæ cæda beyæ̈ tömengä babetamö ëñacantawo, ante ëñencæte ante änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Itota tömënäni ïnänite, —Ïingä onguïñængä incæ tömengä mæmpoda incæ tömänäni wënæ wënæ cædämaï ïnänitapa. Wæætë tömengä babetamö ëñagaingä inte quëwëñongante Wængonguï nänö cædö ïñömö edonque pönï acæ̈impa, ante mäningä mänömaï ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ïñänäni ëñëedäni. Botö ïmote në da pönongaingä tömengä nänö cædö ante mönö mïï quëwenganca mönö cæquënëmö ïmompa. Mönö wænguïönæ ïñonte mönö ædö cæte ayæ̈ cæquïmöö. ");
INSERT INTO aucNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Botö inguipoga quëwëñedë botö inguipoga quëwënäni beyæ̈ ñäö baï ïnömo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mänïnö ante äninque Itota onguipoga towæ tänöninque wëä wëä gopodinque aquïmæ̈ bayonte æ̈ninque babetamongä awinca öni öni pæmongantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ayæ̈ tömengä ingante, —Goe. Gäwapæ̈ Tidoee näni ämæ̈ godinque bitö awinca ñäö mëmöe, ämopa, angantapa. Tidoepæ̈ näni ämæ̈ ïñömö mönö tededö, Da godömæ̈, ante impa. Angä ëñente godinque onguïñængä ñä mëmöninque tömengä oncönë ocæ̈ ëmænte pöninque do acä ingacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tömengä mänömaï do acä inte pongä adinque godongämæ̈ quëwënäni tönö wëënëñedë tömengä, Pönömi æ̈moe, äñongante në adïnäni tönö, —Æ, Ïingä onguïñængä diyæ̈, Pönömïni æ̈moedäni, ante në änecöningä wïï adocä ingantawo. ");
INSERT INTO aucNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Änäni ëñëninque pancadäniya, —Mäningä ingampa, änänitapa. Wadäni guiquënë, —Wïï tömengä ingä, önonque tömengä nänö ëmö baï ëmönongä ingampa. Ante tedeyönäni onguïñængä tömenganque, —Botö mänïmodö ïnömo ïmopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ayæ̈ tömënäni, —Æbänö cæte bitö waa bamonte abii. ");
INSERT INTO aucNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Äñönäni tömengä wæætë, —Onguïñængä ïñömö tömengä ëmöwo Itota ïñömö onguipoga towæ tänöninque wëä wëä gopodinque aquïmæ̈ bayonte æ̈ninque botö awinca öni öni pæmongantapa. Ayæ̈ botö ïmote, “Goe. Gäwapæ̈ Tidoepæ̈ näni ämæ̈ godinque bitö awinca ñä mëmöe” angantapa. Angä ëñëninque botö wadæ gote ñä mëmöninque do waa bamonte abopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tömënäni tömengä ingante, —Ïingä onguïñængä bitö änongä ïñömö æyömönö ingää. Ante äñönäni tömengä wæætë, —Botö ëñënämaï ïmopa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ayæ̈ Paditeoidi weca onguïñængä në babetamö ëñagaingä ingante ænte mämönäni pongantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Itota mänïï aquïmæ̈ badöninque babetamö ïningä awinca wi æ̈monte baï nänö cæönæ ïñömö oodeoidi guëmanguïönæ ïnönimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mänömaï beyæ̈ Paditeoidi ïñömö adobaï ëñencæte ante babetamö ïningä ingante edæ, Æbänö cæte bitö waa bamonte abii, ante äñönäni tömengä wæætë, —Mäningä ïñömö aquïmæ̈ æ̈ninque botö awinca öni öni pæmongantapa. Ayæ̈ botö tömëmo awinca ñä mëmöninque ñöwo waa bamömo inte abopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Paditeoidi pancadäniya, —Ïingä onguïñængä ïñömö wïï Wængonguï weca quëwente pongä ingampa. Edæ tömengä mönö guëmanguïönæ ïñonte guëmänämaï inte do cæcampa, änänitapa. Wadäni guiquënë, —Ïñæmpa waocä në wënæ wënæ cæcä ïnongä inte ædö cæte mänömaï, Acæmïnimpa, ante mä cæquingää, änänitapa. Ïninque tömënäni wadö wadö ante pönente tedewengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ayæ̈ tömënäni wæætë babetamö ïningä ingante, —Tömengä cæcä ate bitö waa abi inte bitö edæ tömengä ingantedö ante quïnö ämii. Ante äñönäni onguïñængä wæætë, —Tömengä Wængonguï beyæ̈ në apæ̈necä ingampa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Babetamö ïningä ïñömö, Waa bamömo ïmopa, ante apæ̈necä ëñëninque oodeoidi awënëidi ayæ̈ pönënämaï ïnänitapa töö. Tömengä mæmpoda ïnate aa pedäni ponte apæ̈neda ate mänïñedë pönënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tömënäni tömëna ïnate, —Ïingä onguïñængä edæ mïnatö wengä ingantawo. Mäningä në babetamö ëñagaingä mïnatö änongä adocä ingantawo. Æbänö cæte tömengä ñöwo waa bamonte acäï. ");
INSERT INTO aucNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ante äñönäni tömengä mæmpoda wæætë, Në babetamö ëñagaingä ïñömö tömengä mönatö wengä ingampa, ante ëñëmönapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Incæte mönatö, Æbänö cæte tömengä ñöwo waa bamonte acää, ante, Æcänö tömengä awinca wi æ̈monte baï cæcää, ante ëñënämaï ïmönapa. Mïnitö tömengä ingante ëñencæte ante äedäni. Tömengä do picængä ingampa. Tömenganque apæ̈necä ëñencæmïnimpa, änatapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tömengä mæmpoda oodeoidi awënëidi ïnänite guïñëninque mänïnö ante apæ̈nedatapa. Edæ oodeoidi awënëidi ïïmaï ante do apæ̈nedönänimpa. Æcänö Itota ingante Ao ante, Mönö Codito ingampa, äna ëñëninque edæ, Mönitö odömöincönë ongönämaï incæbiimpa, ante tömengä ingante da tadömöni tao gocæcäimpa, ante godongämæ̈ pönente apæ̈nedönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mänömaï beyæ̈ tömengä mæmpoda, “Tömengä do picængä ingampa. Mïnitö tömengä ingante ëñencæte ante äedäni,” angadaimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Onguïñængä në babetamö ïningä ingante wæætë aa pedäni pongä ate tömengä ingante, —Bitö Wængonguï ëñëñongä näwangä ante apæ̈nee, ämönipa. Edæ ïingä onguïñængä mänïnö në cædingä wënæ wënæ cæcä ingampa, ante edæ do amönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ante pïïñönäni tömengä wæætë, —Mäningä wënæ wënæ cæcä incæ wïï wënæ wënæ cæcä incæ botö ëñënämaï ïmopa. Botö babetamömo ïnïmo incæ ñöwo waa bamonte abopa. Mäninque ëñëmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ante apæ̈necä ëñëninque tömënäni tömengä ingante, —Tömengä ïñömö bitö ïmite æbänö cæcantawo. Æbänö cæte bitö waa bamonte abii, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tömengä wæætë, —Mïnitö ïmïnite do antabopa. Botö äñömote mïnitö ëñënämaï ïmïnipa töö. Quïnante wæætë adodö ante ëñëïnëmïnii. Mïnitö adobaï, Mönitö tömengä ëmïñæ̈möni baquïmöni, ante ämïnitawo, ante angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ayæ̈ tömënäni tömengä ingante pïinte wënæ wënæ badete todinque, —Bitö mäningä ëmïñæ̈mi ïmipa töö. Mönitö guiquënë Möitee ëmïñæ̈möni ïmöni apa quëwëmii, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wængonguï Möitee ingante apæ̈negacäimpa, ante do ëñëmönipa. Ïingä guiquënë æyömönö quëwente pongää, ante ëñënämaï ïmönipa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Äñönäni onguïñængä wæætë, —Mänïnö mïnitö änïnö wïwa impa ämïnii. Tömengä pönö cæcä waa bamonte abo incæte tömengä æyömönö quëwente pongää, ante mïnitö ëñënämaï ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Në wënæ wënæ cædäni ïñömö Wængonguï ingante apæ̈neyönäni tömengä tömënäni ïnänite ëñënämaï ingampa, ante do ëñëmompa. Wæætë Wængonguï ingante, Bitö adobique mönö Wængonguï ïmidö anguënë, ante në apæ̈necä ïñömö tömengä Wængonguï nänö angaïnö në ëñente cædongä inte apæ̈neyongante Wængonguï tömengä ingante ëñencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Waocä në babetamö ëñagaingä ïñongante wacä tömengä awinca wi æ̈monte baï cæcä ante æyedëmenque incæ inguipoga quëwënäni dicæ änäni ëñënänitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ïingä onguïñængä ïñömö wïï Wængonguï nänö da pönongä pongaingä inte baï tömengä tömänö cædämaï incædongäimpa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mänïnö angä ëñëninque tömënäni wæætë, Bitö ëñagaïñedë do wënæ wënæ cæte ëñagaïmi ïmipa. Incæte bitö mönitö ïmönite ædö cæte, Ëñencæmïnimpa, ante odömonte apæ̈nebi ïmipa töö. Änäni ïninque tömënäni, Bitö mönitö odömöincönë ongönämaï tao gobäwe, ante tömengä ingante da tadönäni tao gogacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tömënäni tömengä ingante da tadönänipa, ante tededäni ëñëninque Itota tömengä ingante ante diqui diqui minte gote adinque. —Bitö Waocä në ëñagaingä ingante pönëmitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Angä ëñëninque onguïñængä, —Awënë, mäningä æcänö ïnaa. Botö tömengä ingante pönencæboimpa, ante apæ̈nebi ëñëmoe. ");
INSERT INTO aucNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ante äñongä Itota wæætë, Bitö tömengä ingante do abitapa. Ayæ̈ bitö ïmite në apæ̈nebo ïñömö tömëmo ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Angä ëñëninque onguïñængä, —Awënë, botö wede pönëmo ïmopa. Ayæ̈, Bitö Wængonguï Wëmi ïmidö anguënë, ante tömengä Itota weca ædæ wææ̈ninque apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Itota ïñömö edæ, —Botö, Inguipoga quëwënäni æbänö cædänii, ante apænte ancæte ante pöninque ïïmaï cæbopa. Botö në babetamönäni baï ïnäni waa bacædänimpa, ante cædinque pontabopa. Ayæ̈ wæætë, Mönitö waa amönipa, ante në änäni ïnänite, botö, Babetamömïni baï ïmïnipa, ante edonque odömoncæte ante pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mänïnö angä ëñëninque Paditeoidi pancadäniya tömengä weca në ongönäni guiquënë tömengä ingante, —Æbänö ämii. Ïñæmpa mönitö adobaï babetamömöni baï ïmönitawogaa. ");
INSERT INTO aucNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ante äñönäni Itota wæætë, —Mïnitö babetamömïni baï inte baï wënæ wënæ cædämaï incædömïnimpa. Wæætë mïnitö, Mönitö waa amönipa, ante në änömïni inte mïni wentamö mongæncoo ee mongæ̈mïni inguïmïnidö anguënë, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Itota ayæ̈ ïïmaï apæ̈necantapa. “Mïnitö ïmïnite näwangä ämopa. Onguïñængä obegaidi näni wææ cæyömö guiidemö në guiidämaï inte wæætë wayömö da ëwa æi guiicä ïñömö tömengä ïñömö në awëmö ö ængä ïnongä inte adobaï wadäni ayönäni në pö ö ænte gocä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Odemö në guiicä guiquënë tömengä obegaidi ïnänite në aacä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Në aacä beyæ̈ odemö në wææ cæcä wi æ̈necampa. Wi æ̈necä ate në aacä pö guiite tedeyongä obegaidi tömengä nänö tedepämo ëñente ïnänipa. Tömengä obegaidi ïnänite näni ëmöwo näni ëmöwo ante aa pecä pöñönänite tömengä tömënäni ïnänite ænte taocampa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tömengä obegaidi tömänäni ïnänite ænte taodinque tömengä önömæca ïñömö täno beyænte gocä ate tömengä obegaidi tömengä nänö tedepämo ëñëninque tömengä ingante tee empo godänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wacä ingante guiquënë tömënäni tee empote godämaï ïnänipa. Wæætë wacä nänö tedepämo ëñënämaï ïnäni inte tömënäni tömengä weca ongönämaï wodii gocædänimpa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tömengä mänömaï tömënäni ïnänite odömoncæte ante, Në aacä æbänö cæcää, ante odömonte apæ̈necä incæte tömënäni tömengä nänö änïnö ante ëñënämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mänömaï beyæ̈ Itota wæætë äninque, “Botö mïnitö ïmïnite näwangä ämopa. Botö ïñömö në obegaidi baï ïnäni näni wææ cæyömö, Guiicædänimpa, ante odemö baï ïmopa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wëënëñedë botö ayæ̈ pönämaï ïñedë wadäni odömonte apæ̈necæ pongadänimpa. Tömënäni tömänäni waodäni ïnänite në awëmö ö æ̈näni baï ïnönäni inte adobaï wadäni ayönäni në pö ö ænte gogaïnäni baï ingadänimpa. Incæte waodäni ïñömö në botö obegaidi baï ïnönäni inte në ö æ̈ïnënäni ïnänite wæætë ëñënämaï ingadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Botö në odemö baï ïmopa. Odemö në guiicä baï ïñömö tömengä botö ïmote pönengä ïñongante botö æ̈mo beyænque quëwencæcäimpa. Adocä në obega baï inte tömënäni näni wææ cæyömö guiidemö në guiicä baï ïninque tömengä piyæ̈në cæte quëwencæcäimpa. Ayæ̈ tömengä wæætë në taocä baï ïninque tömengä nänö cænguï mæ̈ öñö adinque eyepæ̈ cæncæcäimpa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ayæ̈ apæ̈nedinque, “Në awëmö ængä guiquënë tömengä ïñömö awëmö æncæte ante pongä ïnongä inte adobaï wæ̈noncæte ante wo ëwencæte ante mäninganca cæcæte ante pongä ingampa. Botö ïñömö, Waodäni quëwencædänimpa, ante ayæ̈, Tömënäni näni quëwenguinque ante watapæ̈ pönï quëwencædänimpa, ante pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Botö obegaidi baï ïnäni ïnänite në waa aacä baï ïmopa. Në waa Aacä ïñömö nämä incæ obegaidi beyænque wæncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Godonte æ̈inta ante wacä ingante në cæcä ïñömö tömengä ïñömö obegaidi në ëacä ïnämaï ïnongä inte në aacä ïnämaï ingampa. Mänömaï beyæ̈ adocä ïñömö mëñe baï ingä pongä adinque tömengä obegaidi ïnänite ëmö cæte wodii wïnongampa. Tömengä wodii wïnongä adinque mëñe baï ingä wæætë obegaidi weca pogodo ponte obega ingante yao ongöninque, Obegaidi pangocæ goquïnäni, ante cæcampa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Godonte æ̈intaque ante në cæcä ïñömö, Æbänö cæte obegaidi waa quëwenguïnäni, ante änämaï ïnongä inte edæ wodii wïnongampa,” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ayæ̈ apæ̈nedinque, “Obegaidi ïnänite waa aacä baï edæ botö ïñömö në waa Aabo ïmopa. Botö Mæmpo edæ botö ïmote do ate pönengä baï botö adobaï tömengä ingante do adinque pönëmopa. Ayæ̈ tömëmo obegaidi baï ïnäni ïnänite do adinque tömënäni ïnänite pönëmopa. Ayæ̈ tömënäni guiquënë botö ïmote do adäni inte botö ïmote pönënänipa. Botö nämä incæ obegaidi baï ïnäni beyænque wæncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ayæ̈ wadäni ïñömö botö obegaidi baï në ïnäni incæ wïï mänïñömö wææ cæyömö quëwënäni ïnänipa. Botö mänïnäni ïnänite adobaï ænte mämö ponguënëmo ïmopa. Adodäni adobaï botö tedepämo, Æbänö ämoo, ante ëñenguïnäni ïnänipa. Mänömaï beyæ̈ mänïnäni ïñömö do botö quïnäni tönö tömänäni adocabodänique baquïnäni ïnänipa. Ayæ̈ në Aabo adoboque ïñömö tömänäni beyæ̈ cæcæboimpa.” ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ayæ̈ apæ̈nedinque, “Botö nämä incæ Ao ante wæ̈ninque ñäni ömæ̈moncæboimpa, ante cædinque wæætë tömëmo mïï quëwenguïmo incæboimpa. Mänömaï beyæ̈ botö Mæmpo botö ïmote waadete pönengä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Waodäni ïñömö ædö cæte botö ïmote wæ̈nonguïnänii. Botö nämä incæ Ao äninque wæncæboimpa. Botö nämä tæ̈ï pïñæ̈mo ïñömö, Wænguïmo, ante në ämo ïnömo ïmopa. Ayæ̈ adobaï botö nämä tæ̈ï pïñænte në ämo inte botö, Ñäni ömæ̈moncæboimpa, ante cædinque wæætë tömëmo mïï quëwenguïmo incæboimpa. Botö Mæmpo ïñömö botö ïmote nänö wææ angaïnö botö ëñënïnö ante ëñente cæbopa,” ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mänïnö apæ̈necä ëñëninque oodeoidi wæætë wadö wadö ante pönente tedewengadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oodeoidi nanguï ïnäni ïñömö, —Tömengä wënæ tönö cæcä inte edæ ömæcacä ïnongä ingampa. Ædö cæte tömengä ingante ëñëmïni ïmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Äñönäni oodeoidi incæ wadäni guiquënë, —Tömengä wënæ tönö cæcä inte baï tömengä ïïmaï nänö änïnö ante wïï angä incædongäimpa. Në wënæ inte quëwente cæcä ïñömö babetamönäni awinca wi æ̈monte baï cæcä waa bamönäniyaa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yoguite tedæ̈ ïñonte waodäni Eedotadëë quëwënäni, Wængonguï oncö tæiyæ̈ waëmö oncö ante dodäni mæ̈nongadänimpa, ante pönente æ̈æ̈mæ̈ cæyönäni. ");
INSERT INTO aucNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Itota Wængonguï oncö ñæ̈næncönë yabæcönë Tadömöö näni änoncönë ïñömö cægongantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Oodeoidi tömengä weca pö godongämæ̈ gongænte änäni, —Bitö æbänö ïmii, ante æpoönædö ayæ̈ äïnënämaï ïmii. Bitö mönitö Codito ïmi ïninque mönitö ïmönite edonque pönï apæ̈nebi ëñëmönii. ");
INSERT INTO aucNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ante äñönäni Itota wæætë, —Mïnitö ïmïnite do antabopa. Incæte mïnitö pönënämaï ïmïnipa töö. Botö edæ botö Mæmpo ëmöwo ante bamönengæ̈ cæbo adinque mïnitö, Botö æbänö ïmoo, ante ëñenguënëmïni ïmïnipa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mïnitö wïï botö obegaidi baï ïnömïni inte botö ïmote pönënämaï ïmïnipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Waodäni botö obegaidi baï në ïnäni inte botö tedepämo, Æbänö ämoo, ante do ëñënäni. Ayæ̈ botö tömënäni ïnänite adinque pönëmo ïñömote tömënäni wæætë botö ïmote tee empote godänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Botö adodäni ïnänite wantæpiyæ̈ näni quëwenguïnö godömo æ̈ninque quëwencædänimpa. Ayæ̈ cöwë wæ̈nämaï incædänimpa. Tömënäni tömëmo önönempo ongöñönänite æcänö tömënäni ïnänite gä pe æmpoda ïñömö edæ dæ angampa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Botö Mæmpo edæ adodäni ïnänite botö ïmote në pönongaingä ïnongä ingampa. Tömänäni wædänäni ïñönäni tömengä ïñömö godömenque ñæ̈nængä inte nanguï cædongä ingampa. Ïninque tömengä önönempo ongöñönänite æcänö tömënäni ïnänite gä pe æmpoda ïñömö edæ dæ angampa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Botö ïñömö botö Mæmpo tönö ääwocaque baï ëwocamöna ïmönapa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mänïnö angä ëñëninque oodeoidi wæætë tömengä ingante dicaca tacacæte ante cædinque dicacoo wææmpo æ̈nänipa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tömënäni dicacoo wææmpo æ̈ñönänite Itota tömënäni ïnänite, —Botö mïnitö weca botö Mæmpo nänö angaï baï nanguï bamönengæ̈ odömonte cætabopa. Ædö botö bamönengæ̈ cædïnö ante adinque mïnitö botö ïmote dicaca tacacæ cæmïnii. ");
INSERT INTO aucNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ante äñongä oodeoidi wæætë, —Mänïnö bitö waa cædïnö beyæ̈ ante mönitö wïï bitö ïmite dicaca tacacæ cæmönipa. Wæætë bitö babæ ante Wængonguï ingante godö wënæ wënæ ämipa, ante bitö ïmite tacacæ cæmönipa. Edæ mönitö waomöni baï inte bitö adobaï waobi ïmi incæte bitö, Botö Wængonguïmo ïnömo ïmopa, ante ämipa töö. ");
INSERT INTO aucNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ante wæyönäni Itota wæætë tömënäni ïnänite, —Mïnitö mïni wææ yewæ̈mongaïnö wïï ïïmaï ante yewæ̈mongatïï. “Mïnitö ïñömö wængonguïidi ïmïnipa, ante do antabopa,” ante yewæ̈mongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wængonguï angä ëñente näni yewæ̈mongaïnö ante waodäni ædö cæte Baa äninque wido cæquïnänii. Wængonguï nänö angaïnö ante apæ̈necä në ëñënäni ïñönänite tömengä, Mïnitö wængonguïidi ïmïnipa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ayæ̈ botö Mæmpo botö ïmote inguipoga da pönoncæte ante, Botö adoboque quïmi ïmipa, ante botö ïmote apænte ængacäimpa. Ïninque edæ botö tömengä quïmo ïnömo inte tömengä nänö në da pönongaïmo ïñömote edæ botö ïmote edæ æbänö anguïï. Ïñæmpa botö ïñömö Wængonguï Wëmo ïnömo ïmopa, äñömote edæ mïnitö wæætë, Bitö babæ ante Wængonguï ingante godö wënæ wënæ ämipa, ante quïnante ämïnitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Botö edæ Mæmpo nänö cædö baï cædämaï ïmo baï mïnitö mänïñedë botö ïmote pönënämaï ïmïni baï waa incædönimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mïnitö botö ïmote pönënämaï ïmïni incæte botö guiquënë botö Mæmpo nänö cædö baï adobaï cæbo ïninque mïnitö, Botö æbänö cæboo, ante adinque pönencæmïnimpa. Mänömaï cædinque, Botö Mæmpo ingante botö ëwocabo ïmopa, ante ayæ̈, Botö adobaï botö Mæmpo nempo quëwëmopa, ante ëñenguïmïni inte ayæ̈ ëñëninque pönencæmïnimpa, ante Itota angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mänïnö angä ëñëninque tömënäni wæætë tömengä ingante bæi ongoncæ cæyönäni tömengä do aamö cæte gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ayæ̈ Eedotadëë wadæ godinque Oododänö æ̈mæ̈mäa ocæ̈ ëmænte taodinque tömengä Wäö wëënëñedë waodäni ïnänite æpæ̈në nänö guidönïñömö adoyömö gote ongongä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ayæ̈ tömengä mänïñömö ongöñedë waodäni nanguï ïnäni tömengä weca goto pöninque änänitapa. —Ate ëñencæmïnimpa, ante Wäö wodi cöwë bamönengæ̈ cædämaï ingä incæte tömengä mäningä Itota ingantedö ante nänö angaïnö tömänö näwangä ante angantapa, ante apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ayæ̈ mänïñömö ongöninque waodäni nanguï ïnäni Itota ingante wede pönënäni bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mänïñedë wacä onguïñængä tömengä ëmöwo Datado wënæ wënæ badinque öñönongäimpa. Mäadiya tönö Mäadota tömengä tönïñada näna quëwëñömö tömengä adoyömö Betänia ïñömö quëwënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ïingä Mäadiya guiquënë ayæ̈ ate oguï wapæ̈ ænte Awënë Itota ingante öni pædinque nämä ocaguï inte tömengä önöwa amïmö cæquingä adocä Mäadiya ïñongä tömengä tönïñacä Datado ñöwo wënæ wënæ bacä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ïninque Datado tönïñada ïñömö, Itota ingante aa pebi pongäe, äna ëñente wacä gote, —Awënë ëñëmi, Bitö në waadecä ïñömö wënæ wënæ ingampa cæbii, ante änapa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mänïnö näna änö ante apæ̈necä ëñëninque Itota, —Mänïnö wënæ wënæ inte nänö wædö ïñömö wïï wænguï impa. Wæætë waodäni, Wængonguï ñäö apäite ëmönongä ingampa, ante acædänimpa. Ayæ̈ botö ïmote, Bitö Wængonguï Wëmi adobaï ñäö apäite ëmönömi ïmipa, ante apæ̈necædänimpa, ante mäningä wënæ wënæ ingampa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mäadota tönö tömengä tönïñacä Mäadiya näna caya ïnate ayæ̈ Datado ingante Itota tömënäni ïnänite waadete pönënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Datado wënæ wënæ ingampa, ante apæ̈necä ëñengä incæte Itota nänö ongöñömö adoyömö mëönaa ayæ̈ ongongantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tömengä ayæ̈ ate tömengä ëmïñæ̈näni ïnänite, —Ægodöedäni, wæætë Oodeabæ mönö gocæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Äñongä tömënäni wæætë tömengä ingante, —Awënë në Odömömi ïmi, wantæyö intapa oodeoidi bitö ïmite dicaca tacacæ cædäni incæte bitö ñöwo wæætë, Mänïñömö goquïmo, ämitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ante änäni Itota wæætë, —Ïñæmpa nænque wïï tömää itædë apäitawo. Itædë në gocä mönö nænque inguipoga apäicä ate beyæ̈ tëwadämaï gocampa. Botö ïñömö itædë gocä baï adobaï mïïmo botö quëwenganca botö cæquënënö ïinque cæquinque gobopa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Woyowotæ̈ në gocä baï guiquënë tömengä wæætë ñäö dæ ä beyæ̈ tëwate baï gocampa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mänïnö angä ate tömengä godömenque tömënäni ïnänite, —Mönö æ̈migo Datado ïñömö mö ñongä. Botö ñöwo tömengä weca gote, Ñäni ömæ̈möe, ämo ñäni ömæ̈monguingä, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tömengä ëmïñæ̈näni wæætë tömengä ingante, —Awënë Itota, tömengä mö ñongä ïninque edæ gancæ baquingä, apæ̈nedänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Itota Datado nänö æ̈mæ̈wo wæ̈nïmämo ante apæ̈necä incæte tömengä ëmïñæ̈näni guiquënë, Datado önonque mö ñongampa, ante Itota apæ̈necampa, ante pönënönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mänömaï beyæ̈ Itota tömënäni ïnänite, —Datado æ̈mæ̈wo wængäimpa, ante edonque pönï apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mïnitö pönencæmïnimpa, ante botö, Tömengä wæncæ cæyongä botö tömengä weca ongönämaï intabopa, ante mïnitö beyæ̈ ante tobopa. Ægodöedäni, tömengä weca mönö gocæ̈impa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ayæ̈ Tömato Äancadënaque näni änongä ïñömö Itota ëmïñæ̈näni wadäni ïnänite, —Ægodöedäni, äninque, Tömengä tönö godongämæ̈ wæncæte ante tömengä mïñæ̈ gocæ̈impa, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ayæ̈ Itota ponte ëñëñongä, Datado baö tömënäni näni wodintatodë mëönaa go mëönaa do daga wënänitapa, ante apæ̈nedäni ëñengacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betänia ïñömö näni taadö godö Eedotadëë näni quëwëñömö godö eyequeï ïnönimpa. Mänïï taadö wodo tedete quidömetodo ganca ïnönimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Oodeoidi nanguï ïnäni ïñömö Mäadota tönö Mäadiya weca pöninque, Mïnatö tönïñacä wængä ate wæwëmïna incæte piyæ̈në cæte quëwencæmïnaimpa, ante waadete apæ̈necæte ante pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Itota oo pönï pongampa, ante änäni ëñëninque Mäadota tömengä ingante bee tencæte ante gocantapa. Mäadiya guiquënë oncönë ee ongongantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mäadota Itota weca pöninque tömengä ingante, —Awënë Itota, bitö mönitö weca ongömi baï botö tönïñacä wïï wæncædongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tömengä æ̈mæ̈wo wængä incæte bitö ñöwo Wængonguï ingante quïëmë ante apæ̈nebi tömengä pönö cæcä ænguïmi ïmipa, ante botö ëñëmopa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Angä ëñëninque Itota tömengä ingante, —Bitö tönïñacä wodi ñäni ömæ̈monguingä. ");
INSERT INTO aucNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ante apæ̈necä ëñëninque Mäadota wæætë, —Ao, inguipoga ïinque bayedë mönö ñäni ömæ̈möñedë tömengä do wængaingä incæte ñäni ömæ̈moncæcäimpa, ante botö do ëñëmopa, angantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Itota tömengä ingante äninque, —Botö në ñäni ömæ̈monguïmo ïnömo inte cæbo beyænque mïnitö ñäni ömæ̈moncæmïnimpa. Mïni wantæpiyæ̈ quëwenguinque ante në Quëwëmo ïnömo ïmopa. Botö ïmote në wede pönengä ïñömö do wængä incæte ayæ̈ ate wantæpiyæ̈ quëwencæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ayæ̈ në mïï quëwengä inte botö ïmote wede pönengä ïñömö tömengä cöwë wæ̈nämaï quëwencæcäimpa. Bitö mänïnö ante pönëmitawo. ");
INSERT INTO aucNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Angä ëñëninque Mäadota tömengä ingante, —Awënë Itota Ao ämopa, ante apæ̈necantapa. Bitö mönitö Codito ïnömi ïmipa, ante pönëmopa. Wængonguï Wëmi ïnömi inte bitö ïñömö edæ, Inguipoga në Ponguingä, ante näni angaïmi ïmipa, ante pönëmopa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mänömaï ante apæ̈nedinque Mäadota ocæ̈ ëmænte gote Mäadiya ingante aa pecä pongä ate Mäadota tömengä ingante awëmö äninque, —Mönö në Odömongä do pöninque bitö ïmite aa pecampa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Angä ëñëninque Mäadiya quingæ̈ ængæ̈ gantite tömengä weca gocantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Itota Betänia ïñömö ayæ̈ guiidämaï ïnongäimpa. Mäadota tömengä ingante nänö bee tënïñömö tömengä adoyömö ayæ̈ a ongönongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Oodeoidi Mäadiya tönö oncönë godongämæ̈ ongöninque, Tömengä piyæ̈në cæcæcäimpa, ante tæcæ waadete apæ̈neyönäni tömengä quingæ̈ ængæ̈ gantidinque taocä adinque tömënäni, Tömengä Datado wodi nänö wodintatodë wæcæte ante gocampa, ante pönente tömengä ingante tee empote godänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Itota nänö ongöñömö pöninque Mäadiya tömengä ingante adinque tömengä önöwa ædæ wæænte apæ̈nedinque, —Awënë Itota, bitö mönitö weca ongömi baï botö tönïñacä wïï wæncædongäimpa, ante wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mäadiya mänömaï wæyongä oodeoidi tömengä tönö godongämæ̈ në pönïnäni adobaï wædäni adinque Itota wæwente entawëninque wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ayæ̈, —Datado wodi baö æyömönö da wëmïnitawo, Angä ëñëninque tömënäni, —Awënë Itota, pö ae. ");
INSERT INTO aucNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ante äñönäni Itota Ca wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tömengä mänömaï wæcä adinque oodeoidi, —Aedäni, tömengä Datado wodi ingante nö waadete pönengä ingantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ante tedeyönäni pancadäniya, —Tömengä ïñæmpa në babetamongä awinca wi æ̈monte baï cædingä inte adocä Datado wodi ingante cæcä baï tömengä wïï wæncædongäimpa, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Itota wæætë wæwente entawëninque Datado wodintatodë pongacäimpa. Tömengä wodido ontatodë ï ïñonte dicabo ñæ̈nængade da pæ̈ñæ̈ pönö tee mönodäni. ");
INSERT INTO aucNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Adinque Itota, —Dicabo da tæ̈ ñæ̈edäni, äñongä Datado wodi tönïñacä Mäadota wæætë, —Awënë Itota, ëñëmi. Mëönaa go mëönaa tömengä wodido öñöninque tömengä wodi do öö wadingä ingampa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ante wææ angä ëñëninque Itota, —Bitö wede pönëmi ïninque edæ Wængonguï æbänö ñäö apäite ëmönongä inte cæcää, ante bitö acæbiimpa, ante bitö ïmite wïï antawo, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ïninque tömënäni dicabo tæ̈ ñæ̈nänitapa. Ayæ̈ Itota æ̈mö adinque, —Mæmpo botö apæ̈nedïnö ante do ëñëmitapa, ante adinque botö bitö ïmite waa ate pönëninque apæ̈nebopa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Botö apæ̈nedö ante æyedëmë apæ̈nebo incæ bitö cöwë ëñëmipa, ante botö do ëñëmopa. Wæætë edæ waodäni botö weca godongämæ̈ gongæ̈näni beyæ̈ ante botö mänïnö ante apæ̈netabopa. Bitö botö ïmote da pönömi pontabopa, ante tömënäni pönencædänimpa, ante apæ̈netabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mänömaïnö ante Wængonguï ingante apæ̈nedinque Itota, —Datado ta pöe, ante yedæ aa pecantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Në wæ̈ningä ïñömö edæ do ta pongantapa. Tömengä önompo weocoo inte näni wïni wïni cædincoo ayæ̈ empodinque önöwa näni wïni wïni cædincoo ayæ̈ ëwadinque tömengä awinca weocoo näni ñäne cæmönincoo ayæ̈ ëmongä inte ta pongä adinque Itota tömënäni ïnänite, —Mänincoo ñï cæmïni gocäe, angacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mänömaï beyæ̈ oodeoidi nanguï ïnäni Mäadiya weca ëñacæ në pönïnäni inte ïïnäni ïñömö Itota mänömaï cæcä adinque tömengä ingante wede pönënäni bagadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pancadäniya guiquënë Paditeoidi weca godinque, Itota quïnö cæcää, ante adodö angadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ïninque Wængonguï quï, ante në godönäni ñæ̈næ̈näni tönö Paditeoidi ïñömö wæætë tömënäni ömæ näni Apænte Äincabo tömänäni ïnänite, Mönö godongämæ̈ apæ̈necæ̈impa, ante adoyömö pöedäni, ante äñönäni pönäni adinque tömënäni, —Ïingä ïñömö, Acædänimpa, ante nanguï bamönengæ̈ cæcä ingä. Mönö quïnö cæquïmöö. ");
INSERT INTO aucNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ante wædinque mönö tömengä ingante, Bitö mänömaï godömenque cædämaï incæbiimpa, ante wïï wææ ämö ïninque waodäni tömänäni tömengä ingante pönëmaïnänipa. Tömengä ingante pönënäni ïninque, Itota oodeoidi Awënë bacæte ante cæcampa, ante pönente wædinque odömänoidi incæ edæ wææ cæbaïnänipa. Ïninque tömënäni pöninque mönö tæiyæ̈ waëmö oncö wo ëwëmaïnänipa. Ayæ̈ mönö ömæ ïñömö mönö quëwencabo incæ nämä në ämö ïñömonte tömënäni pö ö ænte baï cædinque tömënänique në änäni babaïnänipa, änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tömënäni weca adocanque Caiapato mänïï wadepo, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä inte tömengä ïñömö, —Mïnitö tömänö ante ëñënämaï ïmïnipa töö, apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mönö ömæ quëwencabo wïï tömämö wængæ̈impa, ante wæætë tömëmö beyæ̈ ante adocanque onguïñængä wængä ïninque godömenque waa ïmaimpa, ante mïnitö ëñënämaï ïmïni inte tedewëmïni awædö. ");
INSERT INTO aucNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mänömaïnö ante apæ̈nedinque Caiapato mä nänö pönënonque ante wïï angacäimpa. Wæætë tömengä mänïï wadepo ïñonte, Wængonguï quï, ante në godongä ñæ̈nængä pönï ïnongä inte Wængonguï beyæ̈ apæ̈nedinque, Itota ïñömö oodeoidi beyæ̈ ante wæncæcäimpa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ayæ̈ wïï Oodeabæ quëwënänique beyæ̈ ante wænguingä. Wæætë, Wængonguï wënäni wayömö wayömö pangote godïnäni inte adodänique badinque adoyömö godongämæ̈ poncædänimpa, ante tömengä wæncæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caiapato mänïnö ante nänö änïönæ ïñonte täno godongämæ̈ pönëninque oodeoidi ömæ näni Apænte Äincabo ïñömö, Æbänö cæte Itota ingante wæ̈nömö wænguingää, ante cöwë tedewënönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mänömaï beyæ̈ Itota ayæ̈ oodeoidi weca wïï edonque gocä ïnongäimpa. Wæætë wadæ godinque tömengä önömæca eyequeï Epadaïmë näni äñömö godinque mänïñömö tömengä ëmïñæ̈näni tönö ongönongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wodo pænta gogaïönæ, ante Patowa näni cæönæ oo pönï ïnönimpa. Mänïñedë Oodeabæ wayömö wayömö quëwënäni nanguï ïnäni Eedotadëë quëwëñömö pö æidinque tömënäni Patowa näni æ̈æ̈mæ̈ ayæ̈ cædämaï ïñedë dodäni angaï baï cædinque, Mönö wënæ wënæ cægaïnö ante mönö mënongate baï waëmö bacæ̈impa, ante nämä incæ äacæte ante cædinque æi gogadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Adodäni Wængonguï oncö ñæ̈næncönë yabæcönë pö guiidinque adiyæ̈ gongæ̈ninque, Itota æyömönö ingää, ante pönente gomö adinque nämäneque godongämæ̈ apæ̈nedinque, —Mäningä ïñömö æ̈æ̈mæ̈ beyæ̈ ante edæ pönämaï ingantawo. Æbänö ante pönëmïnii, ante apæ̈nedönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wængonguï quï, ante godönäni ñæ̈næ̈näni tönö Paditeoidi wæætë waodäni ïnänite wææ änönänimpa. Æcänö Itota nänö a ongöñömö ante në ëñengä ïñömö tömengä mönitö ïmönite angä ëñëninque mönitö wæætë Itota ingante yao ongonte æ̈maïmönipa, ante do wææ änönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Önompo æ̈mæmpoque go adoönæque ate Patowa näni ämæ̈ bacæ cæyedë Itota Betänia ïñömö pongantapa. Itota do angä ate në ñäni ömæ̈möningä Datado ïñömö tömengä adoyömö Betänia quëwënongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Itota pongä adinque waodäni mänïñömö quëwënäni, Itota ingante waa amönipa, ante tömengä beyæ̈ æ̈æ̈mæ̈ cægadänimpa. Wadäni tönö Datado adobaï Itota tönö godongämæ̈ tæ̈ contate cæ̈ñönänite Mäadota ïñömö tömënäni ïnänite cænguï godongä cæ̈nänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ayæ̈ Mäadiya ïñömö mëedio ditodo ganca näni oguï wapæ̈ öni pæquïmæ̈ näadodopæ̈ nänö nanguï godonte æ̈nïmæ̈ incæ ænte mämö Itota önöwa gao cæwadinque tömengä ocaguï inte amïmö cæcä ïninque oncönë tömancönë oguï waacönë ingatimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Itota mïñæ̈ në gocä adocanque Codaa Icadiote näni änongä ïñömö edæ, Itota ingante æncædänimpa, ante odömonte në godonguingä inte ñöwo wææ apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ïïmæ̈ nänö oguï wapæ̈ quïnante ömæpodäni beyæ̈ ante godonte æ̈nämaï ingantawo. Ïñæmpa waocä adoque wadepo cæte beyæ̈ paga æ̈ninque todetiento deënadiota nänö æ̈nimpota beyæ̈ mänïmæ̈ godonte æ̈nïmæ̈ ïmæmpa, ante wæcantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tömengä dicæ ömæpodäni beyæ̈ ante pönëninque mänömaïnö ante apæ̈necantawogaa. Wæætë tömengä në awëmö æ̈nongä inte mänïnö ante apæ̈necantapa. Tömënäni da wente æ̈intaa næ̈æ̈nongä inte tömengä ïñömö, Tömënäni da wënïnta incæ pancataa botö quï bacæ̈impa, ante awëmö æ̈nongä inte mänömaï apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Itota wæætë tömengä ingante, —Onquiyængä ingante pïinte änewënämaï incæbiimpa. Mänïmæ̈ botö daga wenguïönæ ante manguënengä inte tömengä botö baö näni daga wenguinque ante eyepæ̈ ïñonte öni paacantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ömæpodäni cöwë mïnitö weca quëwënäni ïnänipa. Botö guiquënë wïï cöwë mïnitö weca quëwëmo ïmopa, ante apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Itota Betänia ponte ongongampa, ante apæ̈nedäni ëñëninque oodeoidi nanguï ïnäni tömengä weca pönäni incæte wïï tömengä beyænque pönänintapa. Wæætë adobaï Datado ingante angä në ñäni ömæ̈möningä ingante acæte ante pongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mänömaï beyæ̈ Wængonguï quï, ante në godönäni ñæ̈næ̈näni ïñömö, Æbänö cæte Datado ingante adobaï wæ̈nömö wænguingää, ante godongämæ̈ tedewënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ïñæmpa oodeoidi nanguï ïnäni, Datado beyæ̈ mönitö ïmönite ëmö cæte Itota ingante pönëninque tömengä gämæ̈nö godänipa, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ïïmö ate, Eedotadëë ïñömö poncæte ante Itota idömæ pongampa, ante apæ̈nedäni ëñëninque æ̈æ̈mæ̈ beyæ̈ ante tæiyæ̈näni pönïnäni ïñömö, ");
INSERT INTO aucNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","yædëmæ̈mäa wangö tate mäo bee tente taodinque yedæ aa pedinque, —Möni quëwenguinque ante, Badogaa, ante tomönipa. Bitö Awënë Wængonguï ëmöwo beyænque pömi ïninque bitö toquinque edæ Wængonguï bitö ïmite waa cæcæcäimpa. Bitö idægoidi Awënë ïnömi inte bitö toquinque ingæ̈impa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ante yedæ äñönäni Itota ïñömö bodo wengä ate æ̈ninque tömengäa æi contate pongantapa. Wëënëñedë Wængonguï beyæ̈ ïïmaï ante näni yewæ̈monte angaïnö baï ïinque cædinque pongantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tiöno ïñömö quëwëmïni ïñömö edæ guïñënämaï ïedäni. Mïnitö Awënë Odeye ñöwo mïnitö weca pongä aedäni. Edæ bodo wengäa æi contate pongampa,” ante yewæ̈mongadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tömënäni dodäni näni angaï baï cædinque Itota ingante bee tencæ taodäni adinque Itota nänö në ëmïñæ̈näni ïñömö, Æbänö cædänii, ante mänïñedë ëñënämaï inte wædönänimpa. Wæætë edæ Itota Wængonguï ñäö ëmöñömö ocæ̈ ëmænte gocä adinque tömengä ëmïñæ̈näni mänïñedë ate edæ, Itota ingante waodäni ñöwo näni cædönö ante dodäni wëënëñedë yewæ̈mongadänimpa, ante pönente wædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Datado wodi ontatodë ongöñongante Itota, Ta pöe, ante aa pecä ëñëninque në wæ̈ningä incæ ñäni ömæ̈möninque ta pongä adinque Itota weca godongämæ̈ ongönïnäni nanguï ïnäni ïñömö, Itota mänömaï cæcä atamönipa, ante gode ä gode ä cædönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ïninque edæ, Itota mänömaï bamönengæ̈ cæcampa, ante apæ̈nedäni ëñente beyænque waodäni tæiyæ̈näni Itota weca bee tencæ pönänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mänömaï beyæ̈ Paditeoidi ïñömö nämanque godongämæ̈ tedewënänitapa. —Waodäni tömänäni æbänö tömengä mïñæ̈ tee empo godäni ante aedäni. Mänïï beyæ̈ ante, Mönö cædïnö wïï eyepæ̈ impa, ante adinque, Mönö æbänö cæte godömenque cæquïmöö, ante wægadänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Eedotadëë ïñömö tömënäni æ̈æ̈mæ̈ cæyedë Wængonguï ingante waa ate apæ̈necæte ante në pönäni pancadäniya ïñömö guidiegoidi ïnönänimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mänïnäni ïñömö Pedipe weca pöninque edæ, —Awënë, ëñëmi. Mönitö Itota ingante aïnëmönipa, ante änänitapa. Mäningä Pedipe ïñömö Betaida quëwëñömö Gadideabæ quëwente pongä ïnongäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tömengä ïñömö Æntade weca gote tömengä ingante guidiegoidi näni änïnö ante apæ̈necä ate tömëna wæætë Itota weca guëa godinque tömengä ingante äñöna, ");
INSERT INTO aucNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Itota wæætë, —Wængonguï nänö cæönæ do ba ïninque tömengä pönö cæcä beyænque botö Waobo ëñagaïmo ïñömö ñäö apäite ëmoncæboimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mïnitö ïmïnite näwangä ämopa. Tömëmö onguipo quiyadïmö incæ yabæque ñömäadämaï ï baï ædö cæte tä bocate pædinque tömëmö nanguï pönï ïmonguïï. Wæætë tömëmö yabæque ñömäate ate tä bocate pædinque nanguï pönï ïmompa. Botö adobaï wænguënëmo ïmopa. Botö wïï wæ̈mo baï ædö cæte waodäni tæiyæ̈näni botö quïnäni baquïnänii. ");
INSERT INTO aucNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Në, Nämanque pönente quëwëmote, ante pönengä ïñömö edæ tömengä nänö quëwenguïmämo incæ wo ëwente bacæcäimpa. Inguipoga quëwëñedë në, Wïï nämanque pönente quëwëmote, ante pönengä guiquënë tömengä nänö wantæpiyæ̈ quëwenguïnö ante do ëadingä inte tömengä nänö wæ̈nämaï quëwenguinque gocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Æcänö botö ïmote në cæda ïna tömengä ïñömö edæ botö ïmote tee empo goquënengä ingampa. Ayæ̈ æyömönö botö quëwëmo botö ïmote në cædongä adoyömö quëwencæcäimpa. Botö Mæmpo ïñömö botö ïmote në cædongä ingante waa acæcäimpa, ante Itota apæ̈negacäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ayæ̈ godömenque apæ̈nedinque Itota ïïmaï apæ̈necantapa. “Botö guïñëmämo entawëninque wæbo inte quïnö anguïmoo. ‘Botö Mæmpo ëñëmi, äninque, Botö nantate wæwenguïönæ oo pönï ba incæte bitö pönö ö æ̈mi ate wæwënämaï bacæboimpa,’ ante botö wïï mänömaïnö ante ancæboimpa. Edæ botö wæwenguïnö beyæ̈ ante pontabopa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mæmpo, Bitö æbänö ñäö apäite ëmömi ïmii, ante odömömi acædänimpa,” angantapa. Äñongä öönædë ïnö tedepämo apæ̈nedinque, “Botö æbänö ñäö apäite ëmömo ïmopa, ante do odömontabopa. Ayæ̈ wæætë adodö cæcæboimpa,” ante apæ̈necä ëñënänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mänïñömö godongämæ̈ ongönäni nanguï ïnäni ïñömö mänïmämo ëñëninque edæ, Detæbo tæ̈ï tëmämo baï impa, ante wædänitapa. Wadäni guiquënë, —Anquedo ïñömö tömengä ingante apæ̈necantapa, ante änänitapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Itota ïñömö wæætë, —Mänïmämo wïï botö beyæ̈ ante apæ̈necampa. Wæætë mïnitö beyæ̈ ante apæ̈necampa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ñöwoyedë Wængonguï inguipoga quëwënäni ïnänite apænte nänö panguïnö ïñömö edæ oo baquïnö anguënë. Inguipogaque quëwënäni awënë ïñongante wënæ ingante Wængonguï ñöwoyedë, Gobäwe, angä gocæcäimpa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Botö ïmote awäa timpodinque ængæ̈ gantidënäni wægömo ate botö waodäni tömänäni ïnänite, Mïnitö botö weca poncæmïnimpa, ante aa pecæboimpa, ante Itota apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mänömaïnö ante apæ̈nedinque tömengä, Æbänö wænguïmoo, ante ëñencædänimpa, ante apæ̈necantapa. ");
INSERT INTO aucNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ëñëninque mänïñömö ongönäni nanguï ïnäni, —Mönitö ïñæmpa, Mönö Codito cöwë ee ongoncæcäimpa, ante dodäni näni wææ angaïnö ante yewæ̈monte ongompa, ante ëñentamönipa. Incæte bitö ïñömö nämanque äninque, Botö Waobo ëñagaïmo ïñömote botö ïmote awäa timpodinque gö cædäni wægonguïmo ïmopa, ante ædö cæte ämii. Äninque, Ïingä Waocä në ëñagaingä ïñæmpa ee ongönämaï wænte goquingää. ");
INSERT INTO aucNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ante wæyönäni Itota tömënäni ïnänite, —Botö, Waodäni mïmönë ñäö baï entawëninque quëwencædänimpa, ante pontabopa. Wædænque ayæ̈ ïñö botö mïnitö weca quëwëninque mïnitö ïmïnite odömonte apæ̈nebopa. Mönitö taadö wë